﻿USE sofia;
DROP TABLE IF EXISTS sofia.loq_vpl;
CREATE TABLE loq_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES loq_vpl WRITE;
INSERT INTO loq_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Kyeka mankombo ma ɓankɔkɔ ɓa Yesu-Klisto: Yesu ali nkɔkɔ wa Davidi, na nkɔkɔ wa Abalayama. ");
INSERT INTO loq_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","11","Abalayama aɓoti Izake, Izake aɓoti Yakoɓo, Yakoɓo aɓoti Yuda na ɓanaa nyango, Yuda aɓoti Pɛlɛsi na Zala nyango wa ɓɛ́ɛ Tamala, Pɛlɛsi aɓoti Esilɔnɛ, Esilɔnɛ aɓoti Lama, Lama aɓoti Aminadaba, Aminadaba aɓoti Nasonɛ, Nasonɛ aɓoti Salamani, Salamani aɓoti Boaze (nyango yaɓaka Laaɓa), Boaze aɓoti Obɛdɛ (nyango yaɓaka Luta), Obɛdɛ aɓoti Yese, Yese aɓoti mokonzi Davidi, Davidi aɓoti Salomo (nyango yaɓaka ŋwasi owa zalaka phanza na Uliya), Salomo aɓoti Loboama, Loboama aɓoti Abiya, Abiya aɓoti Asa, Asa aɓoti Yozafa, Yozafa aɓoti Yolama, Yolama aɓoti Azaliya, Azaliya aɓoti Yotama, Yotama aɓoti Akaza, Akaza aɓoti Ezekiya, Ezekiya aɓoti Manase, Manase aɓoti Amona, Amona aɓoti Yosiya, Yosiya aɓoti Yoyakimɛ na ɓanaa nyango imbɛlɛ saakyɛkyɛ ɓɛ́ɛ na ɓato ɓa Isalayɛlɛ o ɓoombo pha Babilɔnɛ. ");
INSERT INTO loq_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","16","O sima ya ɓokyɛkye na ɓato ɓa Isalayɛlɛ o ɓoombo o Babilɔnɛ, Yoyakimɛ aɓoti Salitiyɛlɛ, Salitiyɛlɛ aɓoti Zolobabɛlɛ, Zolobabɛlɛ aɓoti Abiudi, Abiudi aɓoti Eliyakimɛ, Eliyakimɛ aɓoti Azɔlɔ, Azɔlɔ aɓoti Sadokɛ, Sadokɛ aɓoti Akimi, Akimi aɓoti Eliudi, Eliudi aɓoti Eleyaza, Eleyaza aɓoti Matanɛ, Matanɛ aɓoti Yakoɓo, Yakoɓo aɓoti Zozefu, Zozefu moloo wa Maliya nyango wa Yesu, okoɓangye ɓɛ́ɛ Masiya. ");
INSERT INTO loq_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Tata oka Abalayama nɔnɔ oka Davidi wali ɓa yoo iko mbuka ɓane. Uta oka Davidi nɔnɔ wakyɛndɛ ɓɛ́ɛ na ɓato ɓa Isalayɛlɛ o ɓoombo o Babilɔnɛ, walekana ɓa yoo iko mbuka ɓane. Na o itata imɓɛlɛ sasina tee nɔnɔ o iɓotama sa Masiya, walekana ɓa yoo iko mbuka ɓane mɛ. ");
INSERT INTO loq_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Iɓotama sa Yesu Masiya saɓaka ɓoɓo: Nyango Maliya aɓaka ŋwaŋwasi owa lukaka Zozefu ilonga, kasi waaɓa ɓɛ́ɛ naino sa ɓobutwakye o ingambi sɔnɔsɔ, Maliya aesi ya ekama na nwiya ŋwa Ɓolɔɓɔ Ɓosanto. ");
INSERT INTO loq_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Moloo nyɛ Zozefu aɓaka moto wa ɓosembo, taikaka zinga imosambola o miyo ma ɓato, amba ya kana imolɛɛ oɓokye ɓato saeɓa. ");
INSERT INTO loq_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Wa ɓaka yo kaumunya ɓaɓona, anzelu mɔnɔmɔ wa Nkolo amba motɔkɔlɛlɛ o ndɔtɔ, amba ya wɔ nɛ oɓokye: «Zozefu, nkɔkɔ wa Davidi, saila ilonga Maliya, phɔ ibu siili nɛ, siuti na mwiya ŋwa Ɓɔlɔɓɔ. ");
INSERT INTO loq_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Amoɓota ŋwana wa lele, waa molaa nkombo Yesu. Eli yo moto owa mobikya ɓato ɓɛ́ɛ na masumu ma ɓɛ.» ");
INSERT INTO loq_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Maphɔɔ masɔ maamana makyelama phɔ ya ikokya yaawɔ Nkolo na munɔkɔ ŋwa moimosi wɛ oɓokye: ");
INSERT INTO loq_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«Ngɔndɔ mɔnɔmɔ amoekama, amoɓota ŋwana wa lele, ɓaamolaa nkombo Emanuɛl.» Nkombo mɛ kyelukye iwɔ oɓokye: «Ŋwaphongo ali na ɓanga elele yɔnɔyɔ.» ");
INSERT INTO loq_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Waa umwa Zozefu, ambakyela nde ɓo wamowɔlɛkyɛ anzelu wa Nkolo, nɔnɔ wa longa yo Maliya. ");
INSERT INTO loq_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Kasi taika angana nɛ nɔnɔ waaɓota yo ŋwana wɛ, emba Zozefu amba laa ŋwana mɛ nkombo ya Yesu. ");
INSERT INTO loq_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesu aɓotamaka o Bɛtɛlɛmɛ ya Yuda, imbɛlɛ saa ɓaka Elode mokonzi. Nkɔlɔ mɛ, ɓanganga ɓaakyekye ɓanyasɛɛsi, ɓautaka biitɔkɔlɔ munyɛlɛ. Ɓamba ya koma o Yelusalɛmɛ. ");
INSERT INTO loq_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ɓamba ya tuna ɓɛ̀ɛ kye: «Ŋwana outi ɓɛ́ɛ iɓota, mokonzi ŋwa ɓayuda, ali bi? Towɛnɛkyi nyasɛɛsi wɛ atɔkɔsi biiye munyɛlɛ, emba toesi ya mokumbela.» ");
INSERT INTO loq_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Waa oka mokonzi Elode simo mɛnɛ, ndondo yamba baa nɛ, na ɓato ɓasɔ ɓa Yelusalɛmɛ. ");
INSERT INTO loq_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Amba ya ɓanga ɓakonzi ɓa ɓanganga ɓa Ŋwaphongo na ɓateye ɓa Miɓeko, amba ya ɓatuna elele'ye esengyesi Masiya iɓotama. ");
INSERT INTO loq_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ɓamba mobuyisa ɓɛ́ɛ kye: «O Bɛtɛlɛmɛ ya Yuda. Phɔ moimosi wa Ŋwaphongo akoma ɓoɓo: ");
INSERT INTO loq_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Ka wɛ, Bɛtɛlɛmɛ, mokyisi ŋwa Yuda, toli ŋwana mokyisi pha o nkyisi ya Yuda. Phɔ mokonzi munɛnɛ owa mokanba ɓato ɓanga Isalayɛlɛ, amouta oka ya wɛ.”» ");
INSERT INTO loq_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Emba Elode amba ya ɓanga ɓato ɓa malondo miiɓombo phɔ ɓamoimole imbɛlɛ sa tɔkɔlɔkɔ nyasɛɛsi mɛ. ");
INSERT INTO loq_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Sima amba ya ɓatoma o Bɛtɛlɛmɛ, amba ya wɔ na ɓɛ́ɛ oɓokye: «Kyɛndɛ okyɛ mituna na mɔɔ na mɔɔ phɔ ya ŋwana, ɓo omowɛni, oya nzimola phɔ na nga na kyɛ mokumbela.» ");
INSERT INTO loq_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Waa oka ɓɛ́ɛ munɔkɔ ŋwa mokonzi, ɓamba ya kyɛndɛ. Ɓamba ya wɛnɛ nyasɛɛsi owa wɛnɛkyɛ ɓɛ́ɛ phanza o mbale ekyetɔkɔlɔ munyɛlɛ, kakyɛ o ɓoo pha ɓɛ. Waakoma nyasɛɛsi mɛ o ikolo sa ele eeli ŋwana, nyasɛɛsi mɛ amba kyɛ tɛmɛ. ");
INSERT INTO loq_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ɓamba tonda na nkyisa waa wɛnɛ ɓɛ́ɛ nyasɛɛsi mɛ atɛmi. ");
INSERT INTO loq_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ɓaesi ya nyɔlɔ o ingambi, ɓawɛni ŋwana na nyango Maliya. Ɓamba kusama phɔ ya imokumbela, ɓamba ya ingola ɓayombo ɓa ɓɛ, ɓamba mophɛ makaɓo mama: Wolo, mpaka na mauta ma milɛ. ");
INSERT INTO loq_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Sima Ŋwaphongo amba ya ɓawɔlɛ o ndɔtɔ oɓokye ɓɛ́ɛ sakula butwa yaaka Elode. Emba ɓamba ya butwa o mokyisi ŋwa ɓɛ́ɛ mi nzela esuu. ");
INSERT INTO loq_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Waabutwa ɓaa malondo, o sima, anzelu wa Nkolo mɔnɔmɔ amba yelela Zozefu o ndɔtɔ, amba ya wɔ nɛ yokye: «Langwa, kpa ŋwana na nyango, lota o Ezipito, ikala omɔ nɔnɔ waamowɔ nga na wɛ oɓokye oya butwa. Phɔ Elode amoluka ŋwana phɔ ya imoɓoma.» ");
INSERT INTO loq_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Nde na muna mokɔlɔ, Zozefu aesi ya tɛmɛ, akpe ŋwana na nyango, amba yakyɛ miɓomba o Ezipito. ");
INSERT INTO loq_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Aɓaka omɔ nɔnɔ waawa Elode. Maphɔɔ mamana makyelama phɔ ya ikokya maphɔɔ maawɔkɔ Ŋwaphongo o munɔkɔ ŋwa moimosi wɛ oɓokye: «Naɓangyi ŋwana wa nga oɓokye amane o Ezipito.» ");
INSERT INTO loq_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Waawɛnɛ Elode oɓokye ɓaamalondo ɓamokose, aokaka yɔɔ ekusi. Amba ya toma ɓatuluku o Bɛtɛlɛmɛ na o nkyisi yaa mambale, ɓaɓome ɓana ɓa ɓampele ɓasɔ ɓaali sakokya mbula iɓale. Amekaka ɓaɓona phɔ atangaka nkɔlɔ yaalekanaka tata waawɛnɛkyɛ ɓaamalondo nyasɛɛsi. ");
INSERT INTO loq_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Maphɔɔ masɔ mamana makyelama ɓo wawɔkɔ moimosi Yilimiya oɓokye: ");
INSERT INTO loq_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«Ɓaokyi ilela siute o Lama, malelo na imiima sa ngɔngɔ. Eli Layele kalele ɓana ɓɛ, taazingye oɓokye ɓamoɓɔndɔ phɔ ɓana ɓɛ́ɛ ɓawe.» ");
INSERT INTO loq_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","O sima ya iwaa sa Elode, anzelu wa Nkolo amba yelela Zozefu o ndɔtɔ o Ezipito. ");
INSERT INTO loq_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Amba ya wɔ nɛ yokye: «Tɛmɛ, kpa ŋwana na nyango, butwa o Isalayɛlɛ, phɔ ɓaalukaka iɓoma ŋwana ɓawe.» ");
INSERT INTO loq_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Zozefu amba ya tɛmɛ, aesi ya kpa ŋwana na nyango, amba ya butwa o Isalayɛlɛ. ");
INSERT INTO loq_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Kasi waaoka Zozefu oɓokye Arkelaus abuto mokonzi ŋwa Yuda o elele ya ango Elode, amba lota ibutwa omɔ. Ŋwaphongo amba kula moteya o ndɔtɔ ndengye ekokyi yo ikyela, amba ya kyɛndɛ o mokyisi ŋwa Galileya. ");
INSERT INTO loq_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Amba ya kyɛ zala o Nazalɛtɛ. Maphɔɔ mamana makyelama phɔ ya ikokya maphɔɔ maawɔkɔ ɓaimosi ɓa Ŋwaphongo oɓokye: «Ɓaamoɓanga moto wa Nazalɛtɛ.» ");
INSERT INTO loq_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Sima ya mambula, Yoane Moɓatise akyɛkyɛ o bokye pha Yuda, akyɛkyɛ miteya ɓoɓo: ");
INSERT INTO loq_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","«Ɓongola mandondo, phɔ ɓokonzi pha ikolo ɓokomi phɛnɛphɛ.» ");
INSERT INTO loq_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yoane, eli yo moto owa wɔkɔ moimosi Isaya phɔ yɛ oɓokye: «Moto mɔnɔmɔ kaaŋwane onte ya bokye yokye: Nkolo kalukye iyaa: Omoɓɔngyisa nzela, tutola ɓanaa manzela maakyikyi yɔɔ!» ");
INSERT INTO loq_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yoane aɓaka kalate etobu eya kyela ɓɛ́ɛ na nkungyɛ ya nyama na nkombo shamo, na nkamba ya lopho la nyama o mobimbi, aɓaka kaze nde ntɛtɛ na maɓoo. ");
INSERT INTO loq_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ɓato ɓa Yelusalɛmɛ na ɓato ɓasɔ ɓa Yuda na ɓaa mokyisi mooli phɛnɛphɛ na ebale ya Yaladɛnɛ, ɓaɓaka ɓakyɛ oka yɛ. ");
INSERT INTO loq_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ɓaimolaka masumu ma ɓɛ́ɛ o ɓoo pha ɓato ɓasɔ, Yoane aɓaka kaɓaɓatisa o eɓale ya Yaladɛnɛ. ");
INSERT INTO loq_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Waawɛnɛ Yoane oɓokye Ɓafalisayi na Ɓasadukayi ɓaikye ɓaye oka yɛ phɔ aɓaɓatisa, amba tata iɓawɔlɛ ɓoɓo: «Ɓɛɛ iɓota sa nzɔɔ, oephɛ malondo ma ilota yɔɔ ya Ŋwaphongo ekye ye nza? ");
INSERT INTO loq_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Wɛninya na bikyela oɓokye oɓongosi motema. ");
INSERT INTO loq_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Lɛ imiwɔlɛ oɓokye: “Ekpele yɔnɔyɔ ete lokyele, phɔ Abalayama ali nkɔkɔ wa ɓanga.” Phɔ naewɔlɛ ngakye, Ŋwaphongo akokyi ibuya maɓanga mama ɓana ɓa Abalayama. ");
INSERT INTO loq_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ɓambo ɓɔngyɛ ikoko phɔ ya ikpɛtɛ nkanga ya nzete; ŋwete munsɔ mote moɓote mbuma ndaa, ɓaamokpɛtɛ, ɓamba movaka o nweya. ");
INSERT INTO loq_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nga, naeɓatisa na maa phɔ ya iwɛninya oɓokye oɓongosi motema, ka ookoye o sima ya nga, amoeɓatisa na Ɓolɔɓɔ Ɓosanto na ná ŋwenya. Yo andekyi na mwiya, sikyilongoɓana na phɔ ya imumanya bikoto. ");
INSERT INTO loq_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Aphisi enyɛngyɛlɛ o maɓɔkɔ phɔ ya ikaɓola mbuma na nkata. Amoɓomba mbuma o ɓompɛndɛ, kasi amotumba nkata o ŋwenya moote moozime.» ");
INSERT INTO loq_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Mokɔlɔ mɔnɔmɔ Yesu autaka o Galileya aesi o Yaladɛnɛ, amba ya koma ooli Yoane phɔ aɓatisame. ");
INSERT INTO loq_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Kasi Yoane amba lɛ, yokye: «Eli nde wɛ moto okokakyi imbatisa, emba kombe kula yaa oka nga ndengye'ye?» ");
INSERT INTO loq_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Kasi Yesu amba ya mobuyisela yokye: «Anola oɓokye wataa ɓaa ɓaɓona phɔ ya uŋwaŋwa eye. Phɔ tosengyesi ikokya maphɔɔ masɔ mazingaka Ŋwaphongo.» Emba Yoane amba ya anola. ");
INSERT INTO loq_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Waunva Yesu izwa ɓatisimo, amba aɓwa o maa. Nde mina wamɔ, ikolo samba ingwa, amba wɛnɛ Ɓolɔɓɔ pha Ŋwaphongo ɓoute ndokolo inkoto-ŋwenya siesi yauta mi yo. ");
INSERT INTO loq_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ŋwɛsi mɔnɔmɔ ŋwamba uta o ikolo mowɔ oɓokye: «Oyo ali Ŋwana wa nga wa lozingo; nasepesi nɛ na ɓoikye.» ");
INSERT INTO loq_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ɓoɓɛlɛ Ɓolɔɓɔ amba ya kamba Yesu o bokye phɔ Zabulu amumekye. ");
INSERT INTO loq_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Omɔɔ, Yesu akyelaka nkɔlɔ mako mane mobimba sazaa, emba Yesu amba ya oka nzala. ");
INSERT INTO loq_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Zabulu amba ya wali yo, amba ya wɔ nɛ yokye: «Ɓo oli Ŋwana wa Ŋwaphongo, wɔ na maɓanga mama ma butwe mapa.» ");
INSERT INTO loq_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Kasi Yesu amba ya mobuyisa yokye: «O buku pha Ŋwaphongo wakomama ɓoɓo: “Moto eta bikye nde na mapa, kasi na maphɔɔ masɔ maa wɔ Ŋwaphongo.”» ");
INSERT INTO loq_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Emba Zabulu amba kyɛ nɛ nɔnɔ o Yelusalɛmɛ, mokyisi mosantu, akyɛ motɛyɛ o sɔngyɛ ya Tempelo, ");
INSERT INTO loq_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","amba ya wɔ nɛ yokye: «Ɓo oli ŋwana wa Ŋwaphongo, omikumbya o se; phɔ o buku pha Ŋwaphongo wakomama ɓoɓo: “Ŋwaphongo amoetomela ɓanze ɓɛ, ɓa moetamba phɔ ekolo ya wɛ yango sazuma mi iɓanga.”» ");
INSERT INTO loq_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu amba ya moɓuyisa yokye: «O buku pha Ŋwaphongo wakomama ɓoɓo: “Sameka Ŋwaphongo Nkolo ya wɛ.”» ");
INSERT INTO loq_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Zabulu amba kula kyɛndɛ nɛ o ikolo sa ngomba aanda, amba moteya makonzi masɔ maa se ná ngambo ya mango. ");
INSERT INTO loq_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Amba ya wɔ nɛ yokye: «Namoephɛ isɔ miina ɓo onkusamesi phɔ ya inkumisa.» ");
INSERT INTO loq_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yesu amba ya wɔ nɛ yokye: «Molemba, mana wawa! Phɔ o buku pha Ŋwaphongo wakomama ɓoɓo: “Wamokumisa nde Ŋwaphongo Nkolo ya wɛ, wamba na kyelela nde yo, moto mosuu phe.”» ");
INSERT INTO loq_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ɓoɓɛlɛ Zabulu amba ya mana wali Yesu. Emba ɓanze ɓamba yaa waali Yesu, ɓamba tata imokyelela. ");
INSERT INTO loq_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Waa oka Yesu oɓokye ɓaakye Yoane o bɔlɔkɔ, amba kyɛ o Galileya. ");
INSERT INTO loq_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Amani o Nazalɛtɛ, kasi amba kyɛ zala o Kapalanauma, mokyisi mooli o mokukulu ŋwa ebale ya Galileya, o manyɛtɛ ma Zabulɔni na Nefetali. ");
INSERT INTO loq_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Wakyelama ɓaɓona phɔ ya ikokya maphɔɔ maawɔkɔ moimosi Isaya oɓokye: ");
INSERT INTO loq_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Manyɛtɛ ma Zabulɔni na ma Nefetali, mopha ŋwa ebale eenɛnɛ, o mbale eyɔkɔ ya Yaladɛnɛ. Galileya mokyisi ŋwa ɓato ɓate ɓali Ɓayuda! ");
INSERT INTO loq_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ɓɛ, ɓato ɓaaɓakyi o enzɔmbi ɓawɛni munyɛlɛ ŋwaa phɛlɛ! Ɓaaɓakyi o enzɔmbi ya mokyisi ŋwa ɓawe, munyɛlɛ moɓatɔkɔlɛsi!» ");
INSERT INTO loq_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Uta imbɛlɛ mɛ, Yesu abuto iteya ɓoɓo: «Ɓongola motema, phɔ ɓokonzi pha Ŋwaphongo ɓokomi phɛnɛphɛ!» ");
INSERT INTO loq_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu aɓaka kakyɛ mitambula o mokukulu ŋwa ebale ya Galileya, amba ya wɛnɛ ɓaɔsi ɓa swe ɓaɓale, ɓola na mosii, Simo okoɓangye ɓɛ́ɛ Petelo, na Andele ŋwana wa nyango, ɓaɓaka ɓavakye ɓondɛndi. ");
INSERT INTO loq_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesu amba ya wɔ na ɓɛ́ɛ yokye: «Imbengye! Namoebuya ɓalukyi ɓa ɓato.» ");
INSERT INTO loq_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Mbala yɔnɔyɔ, ɓaikyi mandɛndi ma ɓɛ, ɓaɓengyi Yesu. ");
INSERT INTO loq_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Waamana Yesu wamɔ, akuli wɛnɛ ɓato ɓaɓale, ɓola na mosii, Zake na Yoane, ɓana ɓa Zebede. Ɓaɓaka o vato na ango wa ɓɛ́ɛ Zebede ɓaɓɔngya mandɛndi. Yesu amba ya ɓaɓanga. ");
INSERT INTO loq_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Mbala yɔnɔyɔ, ɓaikyi ika vato na ango wa ɓɛ, ɓaɓengyi Yesu. ");
INSERT INTO loq_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu atambulaka o Galileya mobimba; kakyɛ miteya o mangambi ma makyita, kakyɛ miimola Simo Elaa ya ɓokonzi pha Ŋwaphongo na ikyɛmibikya ɓato na malɔsi ma ɓɛ́ɛ masɔ, na bilɛmɛ ɓa ɓɛ́ɛ bisɔ. ");
INSERT INTO loq_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ngambo yɛ ya tambulaka o manyɛtɛ ma Siri mobimba, ɓamba moyelela na ɓato ɓasɔ ɓaaɓaka na malɔsi ndengye na ndengye na ɓaaɓaka na matungyisi ndengye na ndengye; na ɓaaɓaka na malɔɓɔ maɓe na ɓaamaphukuluku ná bituku. Yesu amba ya ɓabikya. ");
INSERT INTO loq_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ɓato ɓaikye ɓamoɓengaka; ɓautaka o Galileya, o Dekapolis, o Yelusalɛmɛ, o Yuda na o mokyisi mooli o mopha moyɔkɔ ŋwa Yaladɛnɛ. ");
INSERT INTO loq_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Waawɛnɛ Yesu ɓato ɓaikye wamɔ, aesi ya baa o ikolo sa ngomba, akyɛ zala. Ɓaekosi ɓɛ́ɛ ɓamba ya susinya phɛnɛphɛ nɛ, ");
INSERT INTO loq_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","amba tata iɓateya ɓoɓo: ");
INSERT INTO loq_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Nkyisa ili na ɓaamieɓe oɓokye ɓali ɓakayee o mandondo, phɔ ɓokonzi pha ikolo ɓoli phɔ ya ɓɛ! ");
INSERT INTO loq_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Nkyisa ili na ɓaalele, phɔ Ŋwaphongo aaɓaɓɔndɔ. ");
INSERT INTO loq_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Nkyisa ili na ɓaate ɓali na tɔkɔ, ɓɛ́ɛ ɓamozwa mokyisi ŋwa lakyela Ŋwaphongo ɓato. ");
INSERT INTO loq_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Nkyisa ili na ɓaali na phowa ya ikyela ɓolaa, phɔ Ŋwaphongo amokokya phowa ya ɓɛ. ");
INSERT INTO loq_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Nkyisa ili na ɓaaokye ɓato ngɔngɔ, phɔ Ŋwaphongo aɓaoka na ɓɛ́ɛ ngɔngɔ. ");
INSERT INTO loq_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Nkyisa ili na ɓaali na mandondo maakunywa, phɔ ɓamowɛnɛ Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Nkyisa ili na ɓaakyɛmiambya ɓose, phɔ Ŋwaphongo aaɓaɓanga ɓana ɓɛ. ");
INSERT INTO loq_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Nkyisa ili na ɓaanyɔkɔmɔ phɔ ɓakyele ɓolaa, phɔ ɓokonzi pha ikolo ɓoli phɔ ya ɓɛ. ");
INSERT INTO loq_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Nkyisa ili na ɓɛ̀ɛ ɓo ɓato ɓaetole, ɓaenyɔkɔlɔ ɓambe na ewɔlɛ maphɔɔ masɔ maaɓe phɔ ɓɛ̀ɛ konzanole. ");
INSERT INTO loq_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Kumba, ɓa na nkyisa, phɔ mbano enɛnɛ kyeeziya o ikolo. Phɔ ɓanyɔkɔlɔkɔ ɓaimosi ɓa Ŋwaphongo ɓaaɓaka phanza nde ɓomɔ.» ");
INSERT INTO loq_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«Ɓɛ̀ɛ oli mokpa ŋwa mokyisi. Ka ɓo mokpa mumani vale, ɓamokula moɓuya vale ndengye'ye? Temokuli ɓa na tina, ɓaamovaka o nze, ɓato ɓaamokyita. ");
INSERT INTO loq_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ɓɛ̀ɛ oli saa ya mokyisi, mokyisi ŋwaatongama o ikolo sa ngomba temokokyi iɓombama. ");
INSERT INTO loq_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Teɓaalosa tala phɔ ya iekukya na katini, kasi ɓaetɛyɛ o ikolo sa mesa phɔ ewɛninya ɓato ɓasɔ ɓaali o ingambi. ");
INSERT INTO loq_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Yango mɛna, osengyesi ilola o ɓoo pha ɓato ndokolo tala phɔ ɓawɛnɛ ɓolaa ɓookyele ɓɛ̀ɛ, emba ɓaambe kumbela Ango wa ɓɛ̀ɛ ooli o ikolo.» ");
INSERT INTO loq_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«Saumunya oɓokye nga naya phɔ ya imanya moɓeko ŋwa Mose na mateya ma ɓaimosi ɓa Ŋwaphongo. Siika yaa phɔ ya imanya kasi phɔ ya ikokya. ");
INSERT INTO loq_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Eli phɛlɛ, na wɔ na ɓɛ̀ɛ, tee nɔnɔ wamumana ikolo na muse, ete ɓamanya lowɔɔ lɔnɔlɔ o miɓeko, eɓe na ŋwana itanga o mookyikyi owakoma ɓɛ́ɛ omɔɔ ete ɓaamumanya. ");
INSERT INTO loq_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Yango mɛna, na nza na nza okomanya nɔnɔ ŋwana moɓeko o mokyikyi, kambe nateya ɓato ɓasuu ɓakyele ɓomɔ, amoɓa moto wa mbomela o ɓokonzi pha ikolo. Ka iyo nzaa ookokumole miɓeko kambe na teya ɓato ɓasuu oɓokye ɓakyele ɓomɔ, amoɓa moto wa ɓoo o ɓokonzi pha ikolo. ");
INSERT INTO loq_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Na wɔ na ɓɛ̀ɛ, luka ikumola Ŋwaphongo ileka ɓookomokumole ɓateye ɓa mibeko na Ɓafalisayi, ɓo phe, otoonyɔlɔ o ɓokonzi pha ikolo.» ");
INSERT INTO loq_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«Waunva oka ewɔlɛ ya ɓankɔkɔ kyewɔ ɓoɓo: “Sa ɓoma moto; moto ooɓomi moto, ɓateni ɓa malombe ɓaamosambisa.” ");
INSERT INTO loq_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Kasi nga na wɔ na ɓɛ̀ɛ ɓoɓo: Moto munsɔ ookyesi nwɛbi yɔ, ɓateni ɓa malombe ɓaamosambisa. Ka ootosi nwɛbi oɓokye: “Ebubusi!” ikyita siinɛnɛ sa ɓanganga ɓa Ŋwaphongo saamosambisa. Owa mowɔɔ na nwɛbi nɛ yokye: “Alemana!” eɓɔngyi oɓokye ɓamovakye o ŋwenya ŋwa lifelo. ");
INSERT INTO loq_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ɓokokyɛ o mesa ma Ŋwaphongo phɔ ya ikyɛ mophɛ iɓonza, ɓo omɔ okyɛ umunya oɓokye oli na lowɔɔ na nwɛbi na wɛ, ");
INSERT INTO loq_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","langya iɓonza sa wɛ imbale ya mesa ma maɓonza, kyɛndɛ naino okyɛ ɓɔngyɛ na nwɛbi na wɛ, emba ombe ya ambya iɓonza sa wɛ oka Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ɓo moto aephundi, ɓo ɓɛ́ɛ nɛ kombe kyɛndɛ oka ɓa zuzi, ɓɔngya nɛ wataaɓa ɓɛ̀ɛ o nzela. Ɓo phe, moto mɛ amoeyambya oka ɓa zuzi, ɓamoetoma oka ɓatuluku phɔ ɓaenyɔsa o bɔlɔkɔ. ");
INSERT INTO loq_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nde phɛlɛ na wɔ na wɛ: Otootɔkɔlɔ o bɔlɔkɔ tee nɔnɔ waamophuta wɛ mbɔngɔ ya wɛ esɔ.» ");
INSERT INTO loq_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«Waunva oka ɓawɔ ɓoɓo: “Sakyela phemba na ŋwaŋwasi wa moto.” ");
INSERT INTO loq_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Kasi nga na wɔ na ɓɛ̀ɛ ɓoɓo: Moto munsɔ ookyekyi ŋwaŋwasi wa nwɛbi phɔ ya imooka phowa, ambokyela nɛ phemba o ndondo yɛ. ");
INSERT INTO loq_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ɓo ziyo sa wɛ saa ɓoloo si etome o ikyela ɓoɓe, osiphɛngɔlɔ, osivakye itakye. Elekyi ɓolaa phɔ ya wɛ ibungya enango yɔnɔyɔ ya nzoto ya wɛ na oɓokye ɓaevakye muwosi o lifelo. ");
INSERT INTO loq_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ɓo eɓɔkɔ ya wɛ eya ɓoloo kyeetome o ikyela ɓobe, oetene, oevakye itakye. Elekyi ɓolaa phɔ ya wɛ iɓungya enango yɔnɔyɔ ya nzoto ya wɛ na oɓokye okyɛ muwosi o lifelo.» ");
INSERT INTO loq_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«Ɓakulaka wɔ ɓoɓo: “Ɓo lele alɛ ŋwasi wɛ, asengyesi oɓokye amokomele mokanda moimole oɓokye ɓolonga ɓowee.” ");
INSERT INTO loq_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Kasi nga nawɔ na ɓɛ̀ɛ ɓoɓo: Moto munsɔ ookolɛ ŋwasi wɛ, ɓoteeɓe phɔ ya miɓeko misuu miikatele ɓolonga mɛ oɓokye ɓowe phe, mɛna atomise ŋwaŋwasi mɛ ikyela ɓaphemba. Ka moto owamolonga ŋwaŋwasi wa ndenge mɛna, akyesi phemba.» ");
INSERT INTO loq_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«Wakulaka oka oɓokye ɓawɔkɔ na ɓankɔkɔ ɓa ɓanga ɓoɓo: “Sakata seleka ya ɓɔlɛ. Kasi kyela maphɔɔ masɔ malakyi wɛ ɓookatakyi wɛ seleka o ɓoo pha Nkolo.” ");
INSERT INTO loq_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Kasi nga nawɔ na ɓɛ̀ɛ ɓoɓo: Sakata seleka nɔnɔ ŋwana ɓokyii ɓoɓo. Eɓe na nkombo ya ikolo, phɔ ikolo eli eziye ya Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Naa na nkombo ya munse, phɔ muse eli elele ekye tɛyɛ yo makolo mɛ, naa na nkombo ya Yelusalɛmɛ, phɔ Yelusalɛmɛ eli mokyisi ŋwa Mokonzi munɛnɛ. ");
INSERT INTO loq_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Sakata seleka na moto ŋwa wɛ, phɔ tokokyi ibuya suwe ya wɛ ntane naa nsindo. ");
INSERT INTO loq_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ɓo ɛɛ, wɔ oɓokye: “Ɛɛ”. Ɓo phe, wɔ oɓokye: “Phe”. Maphɔɔ masɔ maɓakya ɓɛ̀ɛ o maamana maute na Molemba.» ");
INSERT INTO loq_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","«Waoka ɓawɔkɔ ɓoɓo: “Ziyo phɔ ya ziyo; zino phɔ ya zino.” ");
INSERT INTO loq_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Kasi nga na wɔ na ɓɛ̀ɛ ɓoɓo: Ɓo moto akyesi ɓoɓe, samoɓuyisa ɓoɓe. Ɓo moto aewandi engyete o itama sa ɓoloo, kula mophɛ saa ɓowɛɛ. ");
INSERT INTO loq_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ɓo moto kalukye iyekamba o ɓaloo phɔ ya iyeɓɔlɔlɔ simisi, omolɛlɛ na muna munkoto. ");
INSERT INTO loq_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ɓo moto aeyongyi na ɓokusi ikyɛ moika o eɓonga, kula lekana nɛ itakye na eɓonga. ");
INSERT INTO loq_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ɓo moto aeyongyi ekpele, omophɛ; ɓo azingyi iɓeka na wɛ, omoɓekya.» ");
INSERT INTO loq_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«Waoka ɓawɔkɔ ɓoɓo: “Zinga nwɛbi na wɛ, ina munguna ŋwa wɛ.” ");
INSERT INTO loq_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Kasi nga na wɔ na ɓɛ̀ɛ ɓoɓo: Zinga ɓanguna ɓa ɓɛ̀ɛ, ɓɔndɛlɛ phɔ ya bato ɓaenyɔkɔlɔ. ");
INSERT INTO loq_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Emba waamba ɓaa ɓakolo ɓana ɓa Ango wa ɓɛ̀ɛ Ooli o ikolo. Phɔ katɔkɔlɔ moo nwɛ na phɔ ya ɓato ɓaaɓe na phɔ ya ɓato ɓaala. Kanɔya mbula phɔ ya ɓato ɓakyele ɓolaa na phɔ ya ɓato ɓakyele ɓoɓe. ");
INSERT INTO loq_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ɓo kozingye nde ɓato ɓaezingye, mbano ye eyamozwa ɓɛ̀ɛ oka Ŋwaphongo? Na ɓaphutise ɓa mputi ɓakyele ɓomɔ! ");
INSERT INTO loq_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ɓo koɓeya nde ɓana nyango na ɓɛ̀ɛ, mɛna o kyesi lowɔ lolekyi? Phe! Na ɓato ɓate ɓaebe Ŋwaphongo ɓakyele nde ɓomɔ! ");
INSERT INTO loq_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ɓɛ̀ɛ ɓa ɓato ɓaala ɓoli Ango wa ɓɛ̀ɛ owa ikolo molaa.» ");
INSERT INTO loq_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«Kyeɓa na ndengye ekyekyelele ɓɛ̀ɛ Ŋwaphongo. Samokyelela o miyo ma ɓato oɓokye ɓaewɛnɛkye. Ɓo phe, otozwe mbano oka Angɔ wa ɓɛ̀ɛ oli o ikolo. ");
INSERT INTO loq_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Waa kaɓele wɛ moɓola ekpele, sakyela oɓokye ɓato ɓaewɛnɛ ɓokyele ɓanyamaɓɔlɛ o mangambi ma makyita na o nsɔngɔ phɔ ɓato ɓaɓakumisa. Nde phɛlɛ, nawɔ na ɓɛ̀ɛ ngakye: Ɓaambozwa mbano ya ɓɛ. ");
INSERT INTO loq_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Kasi ɓo eɓɔkɔ ya wɛ eya ɓoloo kyekaɓele moɓola, kyela oɓokye eɓɔkɔ ya wɛ eya ɓowɛɛ saeɓa. ");
INSERT INTO loq_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Phɔ ikaɓo sa wɛ siɓee miiɓombo; emba Ɔngɔ okowɛnɛ maphɔɔ maɓombama amoeyuma.» ");
INSERT INTO loq_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«Ɓo koɓɔndɛlɛ, sa ɓaa ya ɓato ɓa ɓɔɔlɛ; ɓazingye ikyemitɛmɛ o mangambi ma makyita na o nsɔngɔ phɔ ya iɓɔndɛlɛ phɔ ɓato ɓasɔ ɓaɓawɛnɛ. Nde phɛlɛ, nawɔ na ɓɛ̀ɛ; ɓaambozwa mbano ya ɓɛ. ");
INSERT INTO loq_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Kasi iwɛ, ɓokolukye iɓɔndɛlɛ, nyɔlɔ o kolale wɛ, ziɓa ekomba, ɓɔndɛlɛ Ɔngɔ oli o elele mɛ eya iɓombo, yo okowɛnɛ isɔ ikyikyele wɛ miiɓombo amoephɛ mbano. ");
INSERT INTO loq_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Wa ɓɔndɛlɛ ɓɛ̀ɛ Ŋwaphongo, sa wɔ maphɔɔ maikye ndokolo ɓato ɓate ɓaeɓe Ŋwaphongo; ɓaumunya oɓokye Ŋwaphongo aaɓaoka nde ɓo ɓawɔɔ na ɓoikye. ");
INSERT INTO loq_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Sakyela ya ɓɛ, phɔ Ŋwaphongo, ango wa ɓɛ̀ɛ, kaeɓe iwaa iisengyesi na ɓɛ̀ɛ, ɓɛ̀ɛ naino sataa iyonga. ");
INSERT INTO loq_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Kyeka ɓosengyesi ɓɛ̀ɛ iɓɔndɛlɛ: “Ango wa ɓanga ooli o ikolo, nkombo ya wɛ eɓe esantu. ");
INSERT INTO loq_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ɓokonzi pha wɛ ɓoyee; mokano ŋwa wɛ mokyelame wawa o se ndokolo ɓokokyelame wango o ikolo. ");
INSERT INTO loq_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Olophɛ lɔlɔ ntoma iikokyi. ");
INSERT INTO loq_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ololimbisa ɓobe ɓookyesi ɓanga nde ɓokolimbisa ɓanga ɓɛbi ɓoɓe ɓolokyesi ɓɛ. ");
INSERT INTO loq_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Salokamba o bimekyi; kasi olobikya o nsɛɛ ya Molemba. Phɔ ɓokonzi, mwiya na nkyɛmɔ ili ya wɛ ɓoɓɛlɛ na ɓoɓɛlɛ. Amɛ.”» ");
INSERT INTO loq_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","«Phɔ, ɓokolimbisa ɓɛbi ɓoɓe ɓoekyesi ɓɛ, Ango wa ɓɛ̀ɛ ooli o ikolo amoelimbisa mɛ. ");
INSERT INTO loq_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Kasi ɓo olɛɛ ilimbisa ɓɛbi ɓoɓe ɓoekyesi ɓɛ, Ango wa ɓɛ̀ɛ etaelimbisa ɓoɓe ɓookyesi ɓɛ̀ɛ mɛ.» ");
INSERT INTO loq_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«Waamiime ɓɛ̀ɛ ntoma, samikyela ngɔngɔ ɓokokyele ɓanyamaɓɔlɛ, ɓakangye maɓoo ma ɓɛ́ɛ phɔ ɓato ɓasɔ ɓawɛnɛ oɓokye ɓamiimi ntoma. Nde phɛlɛ, na wɔ na ɓɛ̀ɛ, ɓaambozwa mbano ya ɓɛ. ");
INSERT INTO loq_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Kasi wɛ, ɓo omiimi ntoma, kunyola ɓoo pha wɛ, ɓɔngya suwe na ɓolaa. ");
INSERT INTO loq_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Phɔ ɓato saeɓa oɓokye omiimi ntoma; moto owaaloeɓa nde Ɔngɔ ooli o elele ya iɓombo. Emba Ɔngɔ ookowɛnɛ maphɔɔ maali o maɓombo, amoephɛ mbano.» ");
INSERT INTO loq_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«Sa ɓomba ezwele o mokyisi mumu. O mokyisi mumu, munsɛ na maɓembe ɓamoeyɔtɔ, ɓaibi ɓamobuka maphungola phɔ ya ieyiɓa. ");
INSERT INTO loq_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Kasi ɓomba ezwele nde o ikolo oka Ŋwaphongo. Phɔ omɔ tewali munsɛ, maɓembe ma iyɔtɔ mbolo temali, na ɓaibi ɓaibuka mangambi teɓali. ");
INSERT INTO loq_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Phɔ elele eli ezwele ya wɛ, ndondo ya wɛ elangyi nde omɔ.» ");
INSERT INTO loq_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«Miyo mali tala ya nzoto; ɓo miyo ma wɛ mali na ɓolaa, nzoto moɓimba ya mowɛnɛ saa, ");
INSERT INTO loq_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Kasi ɓo miyo ma wɛ mali na ɓolɔsi, nzoto ya wɛ mobimba yamoɓaa o enzɔmbi, otoowɛnɛ ekpele. Nde ɓomɔ, ɓo tala eeli o ndondo ya wɛ ebuto enzɔmbi, enzɔmbi mɛ yamoɓa ekusi koleka.» ");
INSERT INTO loq_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«Moto mɔnɔmɔ takokyi iɓaa moombo wa ɓankolo ɓaɓale; naa amoina mɔnɔmɔ, amba zinga oomoyɔkɔ, naa amotosa mɔnɔmɔ amba tiyola oomoyɔkɔ. Tokokyi iɓaa na mbala yɔnɔyɔ moombo wa Ŋwaphongo na moombo wa ɓaphalanga.» ");
INSERT INTO loq_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«Yango mɛna na wɔ na ɓɛ̀ɛ ngakye: Samitungyisa phɔ ya izaa na inywaa iisengyesi na ɓɛ̀ɛ phɔ ya ibika, naa phɔ ya bitobu biisengyesi na ɓɛ̀ɛ phɔ ya nzoto. Ɓomɔɔ teɓoolekye ntoma? Nzoto te iilekye bitobu? ");
INSERT INTO loq_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Kyeka manyɔsi, teɓaaphikye, teɓaanɔkɔ mbuma phɔ ya iɓomba o mampɛndɛ kasi Ango wa ɓɛ̀ɛ ooli o ikolo kaɓazeya. Emba ɓɛ̀ɛ toolekye manyɔsi? ");
INSERT INTO loq_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Na ɓo omitungyise ndengye'ye, nzaa onte ya ɓɛ̀ɛ akokyi iɓakya nɔnɔ mokɔlɔ mɔnɔmɔ o ɓomɔɔ phɛ? ");
INSERT INTO loq_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ka phɔ ya'ye komitungyisa phɔ ya bitobu? Kyeka ndengye ekyetɔkɔlɔ ɓa phulɛlɛ o manzaɓi; ɓɛ́ɛ teɓaakyele na etoma, teɓaaɓambe na bitobu. ");
INSERT INTO loq_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Kasi na wɔ na ɓɛ̀ɛ, eɓe na Salomo, na ezwele yɛ esɔ, taikaka lata na bitobu biila koleka phulɛlɛ nɔnɔ yɔnɔyɔ. ");
INSERT INTO loq_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Taaumunya nkata iili lɔlɔ o inzabi, yana ɓakokyi iitumba o ŋwenya. Emba ɓo Ŋwaphongo ailasee ɓaɓona, takokyi ilasa na ɓɛ̀ɛ? Phɔ ya'ye ianola sa ɓɛ̀ɛ sili sikyikyi? ");
INSERT INTO loq_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Sa mitungyisaka na iwɔ oɓokye: “Tomoza iye? Tomunywa iye? Tomolata iye?” ");
INSERT INTO loq_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kyemitungyisa na iluka isɔ miina nde ɓato ɓaate ɓaeɓe Ŋwaphongo. Kasi Ango wa ɓɛ̀ɛ oli o ikolo kaeɓe oɓokye osengyesi na yango. ");
INSERT INTO loq_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Taaluka phanza Ɓokonzi pha Ŋwaphongo na ikyela maphɔɔ maazingye yo. Emba amba ephɛ isɔ iyɔkɔ iisengyesi na ɓɛ̀ɛ. ");
INSERT INTO loq_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Sa mitungyisa phɔ ya yana, yana yango mampeza yaamitungyisa na maphɔɔ ma yango. Mokɔlɔ na mokɔlɔ moli na nkaka iikokyi na ŋwango.» ");
INSERT INTO loq_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","«Satena ɓolombe mi moɓesi ŋwa moto, phɔ Ŋwaphongo nde aetenesi ɓolombe mi moɓesi ŋwa ɓɛ̀ɛ. ");
INSERT INTO loq_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Phɔ Ŋwaphongo amoekyeka ɓookokyekye ɓɛ̀ɛ ɓɛbi, amoekyela ɓoɓe naa ɓolaa nde ɓookokyele ɓɛ̀ɛ ɓɛbi. ");
INSERT INTO loq_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Phɔ ya'ye kowɛnɛ mungalala mooli o ziyo sa nwɛbi na wɛ kasi toowɛnɛ iɓaya siili o ziyo sa wɛ? ");
INSERT INTO loq_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Kowɔ na nwɛbi na wɛ oɓokye: “Lɛ naemanya mungalala mooli o ziyo sa wɛ.” Okokyi iwɔ ɓaɓona ndengye'ye phɔ o ziyo sa wɛ iɓaya silii, kasi kosiwɛnɛ nde pha. ");
INSERT INTO loq_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Nyaɓɔɔlɛ, taamanya phanza iɓaya siili o ziyo sa wɛ, waamba wɛnɛ na ɓolaa phɔ ya imanya mungalala mooli o ziyo sa nwɛbi na wɛ. ");
INSERT INTO loq_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Saphɛ manva mbolo iisantu, phɔ makokyi iyekpana ietwa; savaka ɓayaka ɓa motuya o ɓoo pha mangulu, phɔ nde ɓaɓakyiti.» ");
INSERT INTO loq_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«Onga ɓamoephɛ, luka wamozwa, komola moziɓo ɓamoeziɓola. ");
INSERT INTO loq_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Phɔ moto munsɔ okoongye ɓamophɛ, ookolukye kazwe na ookokomole moziɓo ɓamoziɓole. ");
INSERT INTO loq_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Nzaa onte ya ɓɛ̀ɛ ookokyi iphɛ ŋwana wɛ iɓanga ɓo amoongyi ipa? ");
INSERT INTO loq_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Naa nzɔɔ ɓo amoongyi swe? ");
INSERT INTO loq_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ɓo ɓɛ̀ɛ ɓato ɓaɓe koeɓe iphɛ ɓana ɓa ɓɛ̀ɛ mbolo iindaa, emba na Ango wa ɓɛ̀ɛ oli o ikolo takokyi iephɛ mbolo iilekyi ɓolaa ɓoomongyi yango? ");
INSERT INTO loq_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Isɔ ikyizingye ɓɛ̀ɛ oɓokye ɓaekyelele yango, na ɓɛ̀ɛ oikyelele ɓɛbi, kyeka iikyiloteya miɓeko ma Mose na nkanda ya ɓaimosi.» ");
INSERT INTO loq_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«Nyɔlɔ o moziɓo mookyikyi! Phɔ moziɓo ŋwa inyɔlɔ o mokyisi ŋwa ɓawee moli munɛnɛ ná nzela ekyekyɛndɛ omɔ teeli na nkamba. Yango mɛna ɓato ɓaikye ɓaeɓengye. ");
INSERT INTO loq_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Kasi moziɓo ŋwa inyɔlɔ o mokyisi ŋwa ɓato ɓali na ɓomɔɔ, moli mokyikyi, ná nzela ekyekyɛndɛ omɔ eli na mpika. Yango mɛna ɓato ɓaezwe teɓali ɓaikye.» ");
INSERT INTO loq_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«Nde kokyeɓe na ɓaimosi ɓa ɓɔlɛ! Ɓaye oka ɓɛ̀ɛ ɓalati lopho la mpate nzuka o motema nde mangɔɔ. ");
INSERT INTO loq_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Waaɓaeɓa na moɓesi ŋwa ɓɛ. Teɓaimbe mbuma ya vinyɔ mi nkaa naa mbuma ya fige mi ŋwete ŋwa milɔ. ");
INSERT INTO loq_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ŋwete molaa moɓote mbuma ndaa, ŋwete mooɓe moɓote mbuma mbe. ");
INSERT INTO loq_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ŋwete moola temokokyi iɓota mbuma iimbe naa ŋwete mooɓe temokokyi iɓota mbuma iindaa. ");
INSERT INTO loq_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ŋwete munsɔ moote moɓote mbuma ndaa, ɓaamokpɛtɛ, ɓaamovaka o ŋwenya. ");
INSERT INTO loq_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Yango mɛna, wamoeɓa ɓaimosi ɓa ɓɔɔlɛ na moɓesi ŋwa ɓɛ.» ");
INSERT INTO loq_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«Teli ɓaawɔ na nga oɓokye: “Nkolo, Nkolo”, ɓaamunyɔlɔ o Ɓokonzi pha ikolo, kasi nde ɓaakyele maphɔɔ maazingye Tata oli o ikolo. ");
INSERT INTO loq_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Mokɔlɔ ŋwa moya sambisa nga mokyisi, ɓato ɓaikye ɓa mowɔ na nga ɓɛkye: “Nkolo, Nkolo, toɓaka ɓaimosi na nkombo ya wɛ. Totɔkɔlɔkɔ malɔɓɔ maɓe na nkombo ya wɛ; tokyelaka bilekyesako biikye na nkombo ya wɛ.” ");
INSERT INTO loq_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Kasi nga namba wɔ na ɓɛ̀ɛ ngakye: “Sieyeɓe, mana o ɓoo pha nga ɓɛ̀ɛ ɓato ɓaɓe!”» ");
INSERT INTO loq_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«Yango mɛna, moto munsɔ ookyi mateya ma nga ambi na matosa, ali ndokolo moto wa malondo ootongyi ingambi sɛ o ikolo sa maɓanga. ");
INSERT INTO loq_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Mbula enɔ, maa matondi, ewɛlɛ ekusi enyingyinye ingambi, tesiikyi uuwa phɔ ɓasitonga o ikolo sa maɓanga. ");
INSERT INTO loq_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Kasi moto munsɔ okookye mateya ma nga taambe na matosa, ali ndokolo ebubusi ootongyi ingambi sɛ o ikolo sa musɛngyɛ. ");
INSERT INTO loq_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Mbula enɔ, maa matondi, ewɛlɛ ekusi enyingyinye sina ingambi, siuwo sisɔ sisɔ.» ");
INSERT INTO loq_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Waunva Yesu mateya mamana, ɓato ɓasɔ ɓakamwaka na moteyesi nwɛ. ");
INSERT INTO loq_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Phɔ taikaka ɓaa kateya ya ɓateye ɓa miɓeko, kasi kateya na ɓokonzi ɓosɔ. ");
INSERT INTO loq_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Waaɓa Yesu kaute o ngomba, ɓato ɓaikye ɓaamba ya moɓenga. ");
INSERT INTO loq_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Emba moto mɔnɔmɔ oli na ɓolɔsi pha maɓa amba ya waali yo, aesi ya kusama o ɓoo phɛ, amba wɔ nɛ yokye: «Nkolo, ɓo ozingyi okokyi iimbikya.» ");
INSERT INTO loq_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesu amba ya elola eɓɔkɔ, amokumi, amba ya wɔ yokye: «Nazingyi, bika!» Nde mina wamɔ, maɓa mɛ mamani. ");
INSERT INTO loq_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yesu amba ya wɔ nɛ yokye: «Oka na ɓolaa! Saika loimola moto, kasi kyɛndɛ kyɛmiteya oka nganga ya Ŋwaphongo, oambya na ikaɓo ɓo wa wɔ Mose; phɔ ya iwɛninya oka ɓato ɓasɔ oɓokye obikyi phɛlɛ.» ");
INSERT INTO loq_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Waaɓa Yesu kanyɔlɔ o Kapalanauma, mokonzi ŋwa ɓatuluku ɓa Loma amba yaa ooli yo, amba ya nyingonela nɛ ɓoɓo: ");
INSERT INTO loq_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","«Nkolo, moto wa etoma wa nga alangyi o ingambi, taakokye ikula tambula, ali na ɓolɔsi ɓoikye.» ");
INSERT INTO loq_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu amba ya wɔ nɛ yokye: «Nakyɛndɛ, namokyɛ mobikya.» ");
INSERT INTO loq_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Mokonzi ŋwa ɓatuluku amba moɓuyisa yokye: «Nkolo, nga nali nza oɓokye onyɔlɔ o ingambi sa nga? Kasi wɔ nde lowɔ lɔnɔlɔ, moto wa etoma wa nga amobika. ");
INSERT INTO loq_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Phɔ nga natosa ɓakonzi ɓa nga; nali na ná ɓatuluku ɓaantosa. Ɓo na wɔɔ na mɔnɔmɔ ngakye: “Kyɛndɛ!” kakyɛndɛ, ɓo na wɔɔ na oomoyɔkɔ ngakye: “Yaka!” kaye, na ɓo natomi moto wa etoma wa nga oɓokye: “Kyela ɓoɓo”, kakyele.» ");
INSERT INTO loq_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Waaoka Yesu ɓaaɓona, ambakamwa amba ya wɔ na ɓato ɓaaɓaka ɓamoɓengye yokye: «Nde phɛlɛ na wɔ na ɓɛ̀ɛ, naino siwɛni moto wa ianola ndengye eye onte ya ɓato ɓa Isalayɛlɛ. ");
INSERT INTO loq_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Na wɔ na ɓɛ̀ɛ ngakye: Ɓato ɓaikye ɓamouta biitɔkɔlɔ munyɛlɛ na biikyɛ waa munyɛlɛ, ɓamoyanyɔlɔ o ɓokonzi pha ikolo, ɓamozaa o esɛlɛkɔ elele yɔnɔyɔ na Abalayama, na Izake na ná Yakoɓo. ");
INSERT INTO loq_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Kasi ɓato ɓaaɓakyi ɓato ɓa Ɓokonzi pha ikolo, ɓaaɓavaka o iɓanda, o enzɔmbi, omɔ ɓamobutwa ilela na itwa mino.» ");
INSERT INTO loq_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Emba Yesu amba ya wɔ na mokonzi ŋwa ɓatuluku yokye: «Ɓutwa oka ya wɛ, phɔ ya ianola sa wɛ, Ŋwaphongo aephɛ isɔ imoongyi wɛ.» Nde o sina imbɛlɛ mɛ, moto wa etoma wa mokonzi ŋwa ɓatuluku abikaka. ");
INSERT INTO loq_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesu amba ya kyɛndɛ o ingambi sa Petelo. Aesi ya kyɛ zwa nyango wa ŋwasi wa Petelo alangyi ali na mowɛwɛ. ");
INSERT INTO loq_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Amba mokuma na eɓɔkɔ, mowɛwɛ moesi ya mana, amba ya iŋwa abuto imokyelela. ");
INSERT INTO loq_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Waakoma nkɔnkɔlɔ, ɓamba yelela Yesu ɓato ɓaikye ɓaa malɔɓɔ maɓe. Yesu amba phaphala na mango, amba mitɔkɔlɔ, amba na bikya ɓato ɓasɔ ɓaaɓaka na malɔsi. ");
INSERT INTO loq_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Akyelaka maphɔɔ masɔ ɓaɓona phɔ ya ikokya maloɓa ma moimosi Isaya waa wɔ yo oɓokye: «Akpe bilɛmɛ ɓa ɓanga, anyanye na malɔsi ma ɓanga.» ");
INSERT INTO loq_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Waawɛnɛ Yesu ɓato ɓaikye ɓamolungye, amba ya wɔ na ɓaekosi ɓɛ́ɛ yokye toakale o ngambo eyɔkɔ ya ebale. ");
INSERT INTO loq_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Nde o sina imbɛlɛ mɛ, moteye mɔnɔmɔ wa miɓeko amba yaa oli Yesu amba ya wɔ nɛ yokye: «Moteye, namoeɓenga mboka esɔ eya mokyɛndɛ wɛ.» ");
INSERT INTO loq_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesu amba mobuyisa yokye: «Manzumbu mali na bikakala, manyɔsi mali na mooɓo, kasi nga Ŋwana wa Moto sili na elele ya imilangya.» ");
INSERT INTO loq_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Mɔnɔmɔ na ɓaekosi ɓɛ̀ɛ amba ya wɔ nɛ yokye: «Nkolo, indɛ naingyele taakyɛ kunda tata.» ");
INSERT INTO loq_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yesu amba ya mobuyisa yokye: «Imbengye, lɛ ɓawee na ɓawee ɓakundane.» ");
INSERT INTO loq_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ɓoɓɛlɛ Yesu amba ya kpela o vato ná ɓaekosi ɓɛ́ɛ ɓaamba yakyɛ nɛ molɔngɔ. ");
INSERT INTO loq_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Mbala yɔnɔyɔ Ewɛɛlɛ ekusi eesi yakyela o ebale, emba maa matati inyɔlɔ o vato. Kasi Yesu aɓaka na ebuu. ");
INSERT INTO loq_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ɓaekosi ɓamba ya susinya waali yo, ɓaesi ya moumola ɓɛkye: «Nkolo olobikya, tomowaa!» ");
INSERT INTO loq_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesu amba ya ɓabuyisa yokye: «Ɓɛ̀ɛ koile iye? Iyanola sa ɓɛ̀ɛ sili sikyikyi!» Emba amba ya iŋwa, aesi ya phaphala na Ewɛɛlɛ na maa nɔnɔ waa ikala wango phio. ");
INSERT INTO loq_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ɓɛ́ɛ ɓasɔ ɓakamwaka ɓɛkye: «Moto oyo ani ɓaa nzaa oɓokye Ewɛɛlɛ na kanda imotosa?» ");
INSERT INTO loq_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Waakoma Yesu o ngambo ya ebale, o mokyisi ŋwa Gadara, ɓato ɓaɓale ɓautaka o malita, ɓatɔkɔsi ɓaesi ya vana nɛ. Ɓato mɛ ɓaɓaka na malɔɓɔ maɓe, ɓaɓaka ɓatɔmbɔ na ɓokusi; yango mɛna ɓato teɓakokaka ikula lekana mi nzela mɛ. ");
INSERT INTO loq_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ɓato mɛ ɓamba ɓutwa iyaŋwana ɓɛkye: «Ŋwana wa Ŋwaphongo, ɓanga na wɛ lowɔ'ye? Ombo ya lotungyisa wawa naino imbɛlɛ mɛ sataa koka?» ");
INSERT INTO loq_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ŋwana itakye na waali ɓɛ, ɓokanda pha mangulu phaɓaka ɓokyɛmizaa. ");
INSERT INTO loq_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Milimo miɓe mamba nyingonela na Yesu ɓoɓo: «Ɓoozingyi ilowiinya, olotome tokyɛ nyɔlɔ o mangulu mamana.» ");
INSERT INTO loq_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesu amba ya wɔ na ɓɛ̀ɛ yokye: «Kyɛndɛ kyɛ nyɔlɔ mi mɛ.» Milimo miɓe maamba tɔkɔlɔ oka ɓato ɓaaɓana, makyɛkyɛ nyɔlɔ o mangulu. Mbala yɔnɔyɔ, mangulu masɔ maesi ya uta o ngomba, makyɛ mivaka o ebale. ");
INSERT INTO loq_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ɓato ɓaaɓaka ɓaɓanza mana mangulu ɓaesi ya lota nɔnɔ o lombo, ɓakyɛ imola maphɔɔ masɔ maalekaa na ɓato ɓaaɓaka na malɔɓɔ maɓe. ");
INSERT INTO loq_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Emba ɓato ɓasɔ ɓa mokyisi mɛ ɓamba tɔkɔlɔ phɔ ya ikyɛ vana na Yesu; waamowɛnɛ ɓɛ, ɓamba moonga oɓokye amane o mokyisi ŋwa ɓɛ̀ɛ. ");
INSERT INTO loq_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu amba kpela o vato, amba kula katisa ebale, aesi ya kyɛndɛ o mokyisi nwɛ. ");
INSERT INTO loq_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ɓamba moyelela na moto mɔnɔmɔ owa ɔtɔnɔ makolo alangyi o itɔkɔ. Waawɛnɛ Yesu ianola sa ɓɛ, amba ya wɔ na moto owa ɔtɔnɔ makolo yokye: «Ŋwana wa nga ititala! Masumu ma wɛ malimbisami!» ");
INSERT INTO loq_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Emba ɓateye ɓa miɓeko ɓaamba ya butwa iwɔnɔ onte ya ɓɛ́ɛ ɓɛkye: «Moto oyo katole Ŋwaphongo!» ");
INSERT INTO loq_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesu aeɓaka maumunya ma ɓɛ́ɛ amba ya wɔ na ɓɛ́ɛ yokye: «Oli na maumunya maɓe o mandondo ma ɓɛ̀ɛ phɔ ya'ye? ");
INSERT INTO loq_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Eli pha iwɔ oɓokye: “Masumu ma wɛ malimbisami”, nde iwɔ oɓokye: “Iŋwa tambula?” ");
INSERT INTO loq_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Kasi nazingyi oeɓe oɓokye, Ŋwana wa Moto ali na ɓokonzi o munse mumu pha ilimbisa masumu.» Emba amba ya wɔ na moto owa ɔtɔnɔ makolo yokye: «Iŋwa, kpa itɔkɔ sa wɛ, butwa o ingambi!» ");
INSERT INTO loq_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Moto mɛ amba ya iŋwa nɔnɔ waabutwa yo o ingambi sɛ. ");
INSERT INTO loq_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Waawɛnɛ ɓato ɓaɓona, ɓailaka na ɓoikye, ɓakumbelaka Ŋwaphongo phɔ aphɛ ɓato ɓokonzi ndengye mɛna. ");
INSERT INTO loq_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu aesi ya mana omɔ, waaɓa yo kalekane o nzela, aesi ya wɛnɛ moto mɔnɔmɔ nkombo yɛ Matiye azasi o elele yɛ ya etoma ekyekyɛ ɓɛ́ɛ phuta mputi. Yesu amba ya wɔ nɛ yokye: «Imbengye!» Matiye amba ya tɛmɛ amoɓengyi. ");
INSERT INTO loq_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Waaɓa Yesu kaze o ingambi sa Matiye, ɓaphutise ɓa mputi na ɓato ɓa masumu ɓaikye ɓaɓaka o mesa elele yɔnɔyɔ nɛ na ɓaekosi ɓɛɛ. ");
INSERT INTO loq_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Waawɛnɛ Ɓafalisayi ɓaɓona, ɓamba ya tuna ɓaekosi ɓa Yesu ɓɛkye: «Moteye wa ɓɛ̀ɛ kaze elele yɔnɔyɔ na ɓaphutise ɓa mputi na na ɓato ɓa masumu phɔ ya'ye?» ");
INSERT INTO loq_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu aɓaokyi amba ya wɔ na ɓɛ́ɛ yokye: «Ɓato ɓali na nzoto ndaa teɓasengyesi na munganga, kasi esengyesi nɛ nde ɓaali na malɔsi. ");
INSERT INTO loq_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Kyɛndɛ kyɛ ekola ntina ya maloɓa makomama o buku pha Ŋwaphongo oɓokye: “Nazingye motema ŋwa iokyela ɓato ngɔngɔ, kasi mambeka ma manyama phe.” Phɔ siikyi ya ɓanga ɓato ɓaala kasi naesi ya ɓanga nde ɓato ɓa masumu.» ");
INSERT INTO loq_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ɓaekosi ɓa Yoane Moɓatise ɓamba yaa ooli Yesu, ɓaesi ya motuna ɓɛkye: «Ɓanga na Ɓafalisayi tomiime ntoma mbala na mbala. Ɓaekosi ɓa wɛ teɓaakyele ɓomɔ phɔ ya'ye?» ");
INSERT INTO loq_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesu amba ya ɓaɓuyisa yokye: «Koumunya oɓokye ɓato ɓaaɓangyi ɓɛ̀ɛ o esɛlɛkɔ ya ɓolonga ɓakokyi iɓa na ngɔngɔ ɓo molongyi ali na ɓɛ? Teli ɓomɔ! Kasi imbɛlɛ sɔnɔsɔ waamumanya ɓɛ́ɛ molongyi onte ya ɓɛ̀ɛ, emba ɓamba tata imiima ntoma.» ");
INSERT INTO loq_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","«Moto na mɔnɔmɔ taapke etato ya etobu eenyakune phɔ aeɓambe na etobu eya ɓoka, phɔ etato mɛ ya mowawola etobu eya ɓoka, iluu mɛ samobutwa sinɛnɛ. ");
INSERT INTO loq_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Teɓaatɛyɛ malɛku maa swaswa o mambongo maaɓoka; phɔ ɓoɓakyesi ɓaɓona, mambongo mamoɓoya, malɛku mamokyɛndɛ o se. Kasi ɓatɛyɛ malɛku maa swaswa nde o mambongo maanyakune phɔ masɔ maɓatelame na ɓolaa.» ");
INSERT INTO loq_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Waaɓa Yesu kaɓawɔlɛ ɓaɓona, mokonzi mɔnɔmɔ ŋwa ɓayuda amba ya mokusamela aesi ya wɔ nɛ yokye: «Ŋwana wa nga wa ŋwaŋwasi awe nde iŋwaŋwa eye, kasi yaka, omotandele eɓɔkɔ, amobika.» ");
INSERT INTO loq_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yesu amba ya tɛmɛ, aesi ya moɓenga yo na ɓaekosi ɓɛɛ. ");
INSERT INTO loq_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ŋwaŋwasi mɔnɔmɔ, aɓaka na ɓolɔsi pha itɔkɔlɔ malongo phaa kɔkɔ mbula iko mbuka iɓale, aesi o sima ya Yesu, aesi ya kuma nsɔngyɛ ya etobu Yɛ. ");
INSERT INTO loq_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Phɔ amiwɔlɛkyɛ yokye: «Ɓo nakyɛ kuma nɔnɔ nsɔngyɛ ya etobu Yɛ, namobika.» ");
INSERT INTO loq_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesu amba ya miekola, aesi ya mowɛnɛ, amba ya wɔ nɛ yokye: «Ititala, ŋwana wa nga! Iyanola sa wɛ siebikye.» Nde mina wamɔ ŋwaŋwasi mɛ abikyi. ");
INSERT INTO loq_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yesu amba ya koma o ingambi sa mokonzi mɛ. Waawɛnɛ yo ɓatubi ɓatuɓe meembo phɔ ya iluka ikyɛ kunda eɓembe, na ɓato ɓaikye ɓambe kula lela na ɓokusi. ");
INSERT INTO loq_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Yesu amba ya wɔ yokye: «Tɔkɔlɔ, phɔ ŋwana taikyi waa, kasi alasi nde ebuu.» Kasi ɓamba tata imoekyɛ. ");
INSERT INTO loq_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Waatɔkɔlɔ ɓɛ́ɛ ɓato ɓasɔ o nze, Yesu amba ya nyɔlɔ o ingambi saaɓaka mowee, amba mophila o eɓɔkɔ nɔnɔ wa iŋwa yo. ");
INSERT INTO loq_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Simo mɛ ya tambulaka mboka esɔ o mokyisi mɛ. ");
INSERT INTO loq_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Imbɛlɛ saa mana Yesu omɔ, waaɓa yo kalekane o nzela, ɓato ɓaɓale ɓaaphɔlɔ miyo ɓaesi ya moɓenga, ɓakyɛ mi aŋwana ɓɛkye: «Nkɔkɔ wa Davidi, olookye ngɔngɔ!» ");
INSERT INTO loq_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Waakoma Yesu o ingambi, ɓato ɓaaphɔlɔ miyo ɓaaɓana ɓamba yaa wali yo. Yesu amba ɓatuna yokye: «Oli na ianola oɓokye nakokyi ikyela ɓomɔ?» Ɓamba anola ɓɛkye: «Ɛɛ, Nkolo.» ");
INSERT INTO loq_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Emba Yesu aesi ya ɓakuma o miyo amba ya wɔ yokye: «Waekyelamele ɓoanosi ɓɛ̀ɛ!» ");
INSERT INTO loq_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Miyo ma ɓɛ́ɛ mabuto iwɛnɛ, Yesu amba ya ɓakatela na ɓokusi yokye: «Oka na ɓolaa, moto mɔnɔmɔ saika eɓa lowɔ lolo.» ");
INSERT INTO loq_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Kasi ɓɛ́ɛ ɓakyɛkyɛ butwa iimola nde ngambo ya Yesu mboka esɔ. ");
INSERT INTO loq_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Waaluka ɓɛ́ɛ ikyɛndɛ, ɓamba yelela Yesu moto mɔnɔmɔ owa mbubu phɔ aɓaka na ɓolɔɓɔ ɓoɓe. ");
INSERT INTO loq_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Waatɔkɔlɔ Yesu ɓolɔɓɔ ɓoɓe mɛ, moto owa mbubu abuto iwɔ. Ɓato ɓasɔ ɓakaŋwaka ɓamba wɔ ɓɛkye: «Naino tolowɛni lowɔɔ la ndengye eye o Isalayɛlɛ!» ");
INSERT INTO loq_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Kasi Ɓafalisayi ɓamba wɔ ɓɛkye: «Eli mokonzi ŋwa malɔɓɔ maɓe moto okomophɛ ɓokonzi pha itɔkɔlɔ malɔɓɔ maɓe.» ");
INSERT INTO loq_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu atambulaka o nkyisi isɔ inɛnɛ na iinkyikyi; aɓaka kateya o mangambi ma makyita, Simo Elaa ya ɓokonzi na ibikya ɓato ɓa malɔsi ndengye na ndengye na ná bilɛmɛ ɓa ɓɛ. ");
INSERT INTO loq_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Aokaka ngɔngɔ iikye o ndondo yɛ phɔ ya ɓoikye pha ɓato ɓawɛnɛkyɛ yo, phɔ ɓaphɛmbɛkyɛ, ɓaengyeɓanaka ndokolo mampate mazangyi moɓanze. ");
INSERT INTO loq_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Emba amba ya wɔ na ɓaekosi ɓɛ̀ɛ yokye: «Mbuma ili nzikye o inzabi, kasi ɓato ɓa iinɔkɔ teɓali ɓaikye. ");
INSERT INTO loq_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Onga na nkolo wa inzambi atome ɓato ɓa etoma ɓaikye phɔ ɓamunɔkyɛlɛ mbuma.» ");
INSERT INTO loq_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu amba ya ɓanga ɓaekosi ɓɛ́ɛ iko mbuka ɓaɓale, amba ɓaphɛ mwiya ŋwa itɔkɔlɔ malɔɓɔ maɓe na ibikya malɔsi ndengye na ndengye. ");
INSERT INTO loq_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Kyeka mankombo ma ɓana ɓatoma iko mbuka ɓaɓale: Owa ɓoo Simo okoɓangye ɓɛ́ɛ Petelo na ŋwana nyango Andele; Zake na ŋwana nyango Yoane, ɓana ɓa Zebede; ");
INSERT INTO loq_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipe na Ɓatelemi; Toma na Matiye mophutise wa mputi; Zake ŋwana wa Alafe, na Taade; ");
INSERT INTO loq_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simo owa ingomba sa ɓaatɛmbɛlɛ mokyisi ŋwa ɓɛ, na Yudasi Mosikaliota owa ungyaka Yesu. ");
INSERT INTO loq_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesu amba ya toma ɓatoma iko mbuka ɓaɓale ɓaaɓana; amba ya ɓaphɛ mitindo mimi: «Sakyɛndɛ o nkyisi ya ɓabutu; sanyɔlɔ o mokyisi mɔnɔmɔ ŋwa Samaliya. ");
INSERT INTO loq_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Kasi kyɛndɛ nde oka ɓato ɓa Isalayɛlɛ phɔ ɓabutwa ndokolo mampate mabungyi. ");
INSERT INTO loq_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Waamoɓa ɓɛ̀ɛ o nzela, kyɛmiimola oɓokye: “Ɓokonzi pha ikolo ɓokomi phɛnɛphɛ.” ");
INSERT INTO loq_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Bikyia ɓato ɓa malɔsi, akola ɓawe, bikya ɓato ɓa maɓa, tɔkɔlɔ malɔɓɔ maɓe. Ozwee pha, ambya pha. ");
INSERT INTO loq_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Saphila wolo, na phalanga o makuɓa ma ɓɛ̀ɛ. ");
INSERT INTO loq_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Saphila ikuɓa phɔ ya imbanga, na ɓasimisi ɓaɓale, saphila na mapapa, na motuu. Phɔ, moto wa etoma aɓɔngyi na mbano. ");
INSERT INTO loq_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ɓo okomi o mokyisi mɔnɔmɔ munɛnɛ naa mokyikyi, luka moto owa ndondo elaa, zala oka yɛ tee nɔnɔ mokɔlɔ ŋwa mumana ɓɛ̀ɛ o mokyisi mɛ. ");
INSERT INTO loq_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ɓo onyɔsi o ingambi sɔnɔsɔ, wɔ oɓokye: “Ɓose ɓoɓe na ɓɛ̀ɛ.” ");
INSERT INTO loq_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ɓo ɓato ɓa ingambi mɛ ɓaeyambi, ɓose pha ɓɛ̀ɛ pha moɓa na ɓɛ; “Ka ɓo teɓaeyambi, ɓose pha ɓɛ̀ɛ pha moebutolela. ");
INSERT INTO loq_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ɓo o ingambi sɔnɔsɔ naa omokyisi mɔnɔmɔ, ɓalɛ ieyamba na ieyoka, lekana ombe lasa mobulubutu ŋwa makolo ma ɓɛ̀ɛ. ");
INSERT INTO loq_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nde phɛlɛ na wɔ ɓɛ̀ɛ ngakye: Mokɔlɔ ŋwaa mosambisa Ŋwaphongo ɓato, etumbu ya mokyisi mamuna yamoleka eya Sɔdɔmɔ na Gomola.”» ");
INSERT INTO loq_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«Okyemela! Naetome ndokolo mampate onte ya mangɔɔ. Yango mɛna oɓe na ɓokyɛngyi ndokolo manzɔɔ, na ɓonyilɛ ndokolo mankoto-ŋwenya. ");
INSERT INTO loq_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Kyeɓa, phɔ ɓato ɓamoesongyela oka ɓazuzi, ɓamoebinda phimbo o mangambi ma makyita. ");
INSERT INTO loq_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Phɔ ya nga, ɓa mokyɛ na ɓɛ̀ɛ o ɓoo pha ɓato ɓaateɓaeɓe Ŋwaphongo ɓaeyokye. ");
INSERT INTO loq_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Waa mokyɛ ɓɛ̀ɛ o ɓoo pha ɓazuzi, ɓɛ̀ɛ saila phɔ ya maphɔɔ masengyesi ɓɛ̀ɛ iwɔ, maphɔɔ maamowɔ ɓɛ̀ɛ, wamazwa nde imbɛlɛ mɛ. ");
INSERT INTO loq_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Maphɔɔ mɛ ete maaute na ɓɛ̀ɛ, kasi Ɓolɔɓɔ pha Ango wa ɓɛ̀ɛ pha mowɔ onte ya ɓɛ̀ɛ. ");
INSERT INTO loq_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Onte ya iɓota, ɓaná ɓamoungya ɓanaa nyango na ɓɛ́ɛ oɓokye ɓaɓaɓome. Ɓa ango ɓamoungya ɓana ɓa ɓɛ, ɓana ɓamoekpenela ɓaɓoti ɓa ɓɛ́ɛ phɔ ɓaɓaɓome. ");
INSERT INTO loq_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ɓato ɓasɔ ɓamoeyina phɔ ya nga. Kasi owa moititala tee nɔnɔ o suka amobika. ");
INSERT INTO loq_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Waamoenyɔkɔlɔ ɓɛ́ɛ o mokyisi mɔnɔmɔ, lota o mokyisi mooyɔkɔ. Nde phɛlɛ na wɔ na ɓɛ̀ɛ ngakye: Otootaa unva itambula o nkyisi isɔ ya Isalayɛlɛ mɛna Ŋwana wa Moto sa ɓoyakakye. ");
INSERT INTO loq_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Moekosi taalekye moteye wɛ, moto owa etoma taalekye mokonzi nwɛ. ");
INSERT INTO loq_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Wa ɓɔngyi nde oɓokye moekosi abutwe ɓooli moteye nwɛ, na moto wa etoma ɓooli mokonzi nwɛ. Ɓo ɓaɓangye mokonzi ŋwa iɓota Ɓɛlɛzɛbula, ka ɓaná ɓaamba ɓaɓanga ɓa nza?» ");
INSERT INTO loq_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","«Yango mɛna saila moto. Mokɔlɔ mɔnɔmɔ moli, mowaa maphɔɔ masɔ maaɓombama mamotɔkɔlɔ o nze, maphɔɔ maazite ɓɛ́ɛ mamoeɓana. ");
INSERT INTO loq_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ikyiewɔlɛ nga o enzɔmbi, okule iwɔɔ waa moo, ka ikyikɔlɔ ɓɛ́ɛ na ɓɛ̀ɛ o itoo, o iwɔɔ o ikolo sa motɔndɔ. ");
INSERT INTO loq_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Saila ɓaaɓome nzoto kasi te ɓakokyi iɓoma molimo, ila nde Ŋwaphongo ookokyi iɓoma na nzoto na molimo o lifelo. ");
INSERT INTO loq_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Teɓaungya manyɔsi maɓale maakyikyi na motuya mokyikyi? Kasi yɔnɔyɔ na mango teeka o se sa oɓokye Ɔngɔ wa ɓɛ̀ɛ, Ŋwaphongo saeɓa. ");
INSERT INTO loq_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Phɔ ya ɓɛ̀ɛ, eli nde ɓomɔ, na suwɛ ya ɓɛ̀ɛ ango wa ɓɛ̀ɛ Ŋwaphongo kaiyeɓe na motuya. ");
INSERT INTO loq_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Yango mɛna ɓɛ̀ɛ saila, phɔ oli na ntina koleka manyɔsi maikye maakyikyi.» ");
INSERT INTO loq_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","«Moto okonzanole o miyo ma ɓato, na nga naamoanola o ɓoo pha Tata ooli o ikolo. ");
INSERT INTO loq_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ka moto owamunzangana o ɓoo pha ɓato, na nga naamoangana o ɓoo pha Tata ooli o ikolo.» ");
INSERT INTO loq_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«Saumunya oɓokye naesi yaambya ɓose o mokyisi. Siikyi yaambya ɓose, kasi eɓasi. ");
INSERT INTO loq_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Naesi phɔ ya iyakaɓola ŋwana wa lele na ango, ŋwana wa ŋwaŋwasi na nyango, ŋwaŋwasi wa ŋwana na nyamolo nyɛ. ");
INSERT INTO loq_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Nde phɛlɛ, ɓanguna ɓa moto ya moɓaa nde ɓato ɓa iɓota sɛ.» ");
INSERT INTO loq_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","«Moto ookozingye nyango naa ango indeka nga, takokyi iɓaa moto wa nga. Moto ookozingye ŋwana wɛ wa lele naa wa ŋwaŋwasi indeka nga, takokyi iɓaa moto wa nga. ");
INSERT INTO loq_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Moto ootonyanya ekulusu yɛ phɔ ya imbenga, takokyi iɓaa moto wa nga. ");
INSERT INTO loq_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Moto ookozingye iɓanza ɓomɔɔ phɛ aaɓoɓungya, kasi ookoɓobungya phɔ ya nga amokula ɓozwa.» ");
INSERT INTO loq_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«Moto oeyambi, anzambi nga; ka moto oonzambi, ayambi yo owantoma. ");
INSERT INTO loq_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Moto owamoyamba moimosi wa Ŋwaphongo phɔ ali moimosi, amozwa iphuti siiphɛ Ŋwaphongo moimosi. Ka moto owamoyamba moto owa ndondo elaa phɔ ali moto wa ndondo elaa, amozwa iphuti siiphɛ Ŋwaphongo moto wa ndondo elaa. ");
INSERT INTO loq_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nde phɛlɛ na wɔ na ɓɛ̀ɛ ngakye: Moto owa mophɛɛ nɔnɔ kɔphɔ ya maa ma mpiyɔ na mɔnɔmɔ wa ɓaakyikyi onte ya ɓaekosi ɓanga, phɔ ali moekosi wa nga, amozwa iphuti sɛ.» ");
INSERT INTO loq_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Waaunva Yesu iphɛ ɓaekosi ɓɛ́ɛ iko mbuka ɓaɓale miɓeko maamina, amba ya mana omɔ phɔ ya ikyɛmiimola na ikyɛmiteya o nkyisi yaa mambale. ");
INSERT INTO loq_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yoane Moɓatise aɓaka o bɔlɔkɔ. Amba ya oka sango ya bitoma bikyele Klisto, emba amba ya toma ɓaekosi ɓɛ́ɛ ɓaayɔkɔ, ");
INSERT INTO loq_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","phɔ ɓakyɛtuna Yesu oɓokye: «Eli wɛ Masiya osengyesi iya ndee toziya mosuu?» ");
INSERT INTO loq_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesu amba ɓabuyisa yokye: «Kyɛndɛ kyɛ imola Yoane maphɔɔ masɔ maokyi ɓɛ̀ɛ na maawɛni ɓɛ̀ɛ. ");
INSERT INTO loq_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ɓato ɓaaphɔlɔ miyo ɓabuto iwɛnɛ, ɓaa ɔtɔnɔ makolo ɓabuto itambula, ɓato ɓa maɓa ɓabikyi, ɓaa loko ɓabuto ioka, ɓaawa ɓaako, ɓaa ngɔngɔ ɓaokyi Simo Elaa. ");
INSERT INTO loq_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Nkyisa ili na moto owa moɓa sa lɛɛ ianola sɛ oka nga!» ");
INSERT INTO loq_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Waabutwa ɓaekosi ɓa Yoane, Yesu aesi ya tata ituna ɓato phɔ ya Yoane yokye: «O bokye, okyɛkyi kyeka ye? Mumbunyɛ monyingane na ewɛɛlɛ? Phe? ");
INSERT INTO loq_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ka okyɛkyi kyeka ye? Moto alati bitobu bilaa? Ka ɓalate bitobu bilaa ɓazale o mangambi ma ɓakonzi. ");
INSERT INTO loq_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ka okyɛkyi kyeka nde iye? Moimosi wa Ŋwaphongo? Ɛɛ, nde phɛlɛ na wɔ na ɓɛ̀ɛ, alekyi na moimosi wa Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Phɔ Yoane ali owa wɔ ɓɛ́ɛ o buku pha Ŋwaphongo ɓoɓo: “Namotoma tima ya nga o ɓoo pha wɛ phɔ ya ieɓɔngyisela nzela.” ");
INSERT INTO loq_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nde phɛlɛ na wɔ na ɓɛ̀ɛ ngakye: Onte ya ɓato ɓasɔ ɓaaɓotama na ŋwaŋwasi, oolekyi Yoane Moɓatise na ngambo talii. Kasi oolekyi ɓokyikyi o Ɓokonzi pha ikolo, yo mɔna alekyi Yoane na ngambo. ");
INSERT INTO loq_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Tata imbɛlɛ saaɓa Yoane kateya tee nɔnɔ lɔlɔ eye, ɓali nde iŋwana na ɓokonzi pha ikolo; ɓanguna ɓalukye iɓoɓɔlɔlɔ. ");
INSERT INTO loq_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ɓaimosi ɓa Ŋwaphongo ɓasɔ, eɓe na miɓeko ma Mose, ɓaimolaka maphɔɔ mamana tee nɔnɔ o imbɛlɛ sa Yoane. ");
INSERT INTO loq_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ka ɓokolukye imoanola, Yoane ali Eliya owa imolaka ɓɛ́ɛ iya sɛ. ");
INSERT INTO loq_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ooli na matoo ma ioka, aokye!» ");
INSERT INTO loq_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","«Namoulinya ɓato ɓa lɔlɔ na nza? Ɓaulane na ɓana ɓaakyikyi ɓaazasi o munsɔngɔ ɓambe wɔ na ɓɛbi na ɓɛ́ɛ ɓɛkye: ");
INSERT INTO loq_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Toulesi iphengo, toikyi bina! Totubi meembo ma elesi, kasi toikyi lela!” ");
INSERT INTO loq_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Phɔ Yoane aya, waaɓa yo saza, sanywa, ɓɛkye: “Ali na ɓolɔɓɔ ɓoɓe!” ");
INSERT INTO loq_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Kasi Ŋwana wa Moto aesi, kaze, kanywe, ɓɛkye: “Kyeka moto oyo kaumunya nde izaa na inywa vinyɔ, ekamba ya ɓaphutise ɓamputi na ɓato ɓa masumu!” Kasi zebi siwɛnɛnɛ phɛlɛ na bitoma ba sango.» ");
INSERT INTO loq_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Emba Yesu amba butwa ioya nkyisi iinɛnɛ yaakyelelaka yo bilekyesako biikye, phɔ ɓato ɓa nkyisi mɛ teɓaika ɓongola ntema ya ɓɛ. Amba wɔ yokye: ");
INSERT INTO loq_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«Ngɔngɔ ya wɛ mokyisi ŋwa Korazine! Ngɔngɔ ya wɛ mokyisi ŋwa Ɓetesaida! Phɔ bilekyesako ɓiakyelamaka oka ɓɛ̀ɛ ɓo ɓiakyelamaka nde o Tula na Sidona, kalakala ɓato ɓa ɓɛ́ɛ nde ɓaunva lɛɓɛ, nde ɓaunva misweya mbutu, nde ɓaunva ɓongola ntema ya ɓɛ. ");
INSERT INTO loq_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Yango mɛna nawɔ na ɓɛ̀ɛ ngakye: Mokɔlɔ ŋwaa mosambisa Ŋwaphongo ɓato, etumbu ya ɓɛ̀ɛ ya moleka eyaaka Tula na Sidona. ");
INSERT INTO loq_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Na wɛ Kapalanauma, koumunya oɓokye wa mobaa nɔnɔ o ikolo? Phe. Wamouta nɔnɔ o mokyisi ŋwa ɓawe! Phɔ ɓo bilekyesako ɓiakyelamaka oka ya wɛ ɓo ɓiakyelamaka o Sɔdɔmɔ, mokyisi mɛ nde motaaɓaa nɔnɔ lɔlɔ eye. ");
INSERT INTO loq_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Yango mɛna nawɔ na wɛ ngakye: Mokɔlɔ ŋwaa mosambisa Ŋwaphongo ɓato, etumbu ya wɛ yamoleka eya Sɔdɔmɔ.» ");
INSERT INTO loq_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Imbɛlɛ saasina Yesu amba ya wɔ yokye: «Ee Tata, Nkolo wa ikolo na munse, naephɛ mɛlɛsi phɔ oziti maphɔɔ mama na ɓato ɓa malondo na ná ɓato ɓaaekola, kasi omaimosi ɓato ɓaateɓali na ntina. ");
INSERT INTO loq_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Phɛlɛ, Tata, wazingaka oɓokye wakyelame nde ɓɔmɔ. ");
INSERT INTO loq_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Tata aphɛ maphɔɔ masɔ o maɓɔkɔ ma nga. Moto mɔnɔmɔ taaeɓe Ŋwana ɓo teeɓe Tata, na moto mɔnɔmɔ taaeɓe Tata ɓo teeɓe Ŋwana, na ɓawaa ɓaazinga Ŋwana iɓateya Tata.» ");
INSERT INTO loq_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","«Yaka oka nga ɓɛ̀ɛ ɓasɔ ɓaaphɛmbi na iphila ephesi ezito na moeyeminya. ");
INSERT INTO loq_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Phila na nga mokaka, yaka ya zwe zebi oka nga, phɔ nali moto wa ngɔngɔ na wa ɓonyilɛ; waamba ya zwa na ɓoemakye. ");
INSERT INTO loq_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Mokaka moetomisa nga iphila ŋwa lawa, na ephesi ya nga teeli ezito.» ");
INSERT INTO loq_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Imbɛlɛ mɛ, Yesu na ɓaekosi ɓɛ́ɛ ɓaɓaka ɓalekane o manzabi ma ble, yaɓaka mokɔlɔ mɔnɔmɔ ŋwa saɓata. Ɓaekosi ɓɛ́ɛ ɓawaka na nzala; ɓaesi ya butwa ikyɛminɔkɔ bikpoto ɓa ble ɓambe zaa ina mbuma. ");
INSERT INTO loq_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Waawɛnɛ Ɓafalisayi ɓaaɓona, ɓamba ya wɔ na Yesu ɓɛkye: «Kyeka ɓaekosi ɓa wɛ ɓakyele ikyikatele moɓeko ŋwa ɓanga ikyela mokɔlɔ ŋwa saɓata!» ");
INSERT INTO loq_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesu amba ya ɓabuyisa yokye: «Toikatanga yaakyelaka Davidi na ɓɛbi nɛ wawaka ɓɛ́ɛ na nzala? ");
INSERT INTO loq_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Anyɔlɔkɔ o Ingambi sa Ŋwaphongo yo na ɓɛbi nɛ, ɓamba zaa mapa maaphɛkyɛ ɓɛ́ɛ Ŋwaphongo. Teɓakokaka na imaza; phɔ moɓeko ŋwa ɓanga mowɔ oɓokye kyemaze nde ɓanganga ɓa Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Naino totangyi o Miɓeko ma Mose, wakomama oɓokye ɓanganga ɓa Ŋwaphongo o Tempelo teɓaakumole saɓata, kasi naɓo ɓaɓona teɓali na lowɔ? ");
INSERT INTO loq_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nawɔ na ɓɛ̀ɛ ngakye: Maphɔɔ maawɛnɛ ɓɛ̀ɛ wawa malekyi Tempelo. ");
INSERT INTO loq_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ɓo oeɓakyi ntina ya maloɓa maakoma ɓɛ́ɛ o buku pha Ŋwaphongo maawɔ oɓokye: “Nazingye motema ŋwa iokyela ɓato ngɔngɔ, kasi mambeka ma manyama phe”, nde toɓaoye. ");
INSERT INTO loq_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Phɔ Ŋwana wa Moto ali Nkolo wa saɓata.» ");
INSERT INTO loq_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu amba ya mana o elele mɛ, aesi yakyɛndɛ o ingambi sa makyita. ");
INSERT INTO loq_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Moto mɔnɔmɔ owa nyiɓa eɓɔkɔ aɓaka omɔ. Ɓafalisayi ɓalukaka nzela ya imophunda, yango mɛna ɓamba ya motuna ɓɛkye: «Moɓeko ŋwa ɓanga moanole ibikya moto mokɔlɔ ŋwa saɓata?» ");
INSERT INTO loq_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesu amba ya ɓabuyisa yokye: «Ɓo mɔnɔmɔ onte ya ɓɛ̀ɛ ali na mpate yɔnɔyɔ; ɓo embikyɛ kaa o iɓela siizindo mokɔlɔ ŋwa saɓata, etaakyɛ eyaɓola? ");
INSERT INTO loq_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Moto alekyi mpate! Kyelukye iwɔ oɓokye, moɓeko ŋwa ɓanga moanole ikyela moto ɓolaa mokɔlɔ ŋwa saɓata.» ");
INSERT INTO loq_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Emba Yesu amba ya wɔ na moto owa nyiɓa eɓɔkɔ yokye: «Elola eɓɔkɔ ya wɛ.» Amba ya eyelola nɔnɔ waabutwa yango elaa ndokolo eeyɔkɔ. ");
INSERT INTO loq_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ɓafalisayi ɓamba ya tɔkɔlɔ o ingambi sa makyita, ɓamba ya kyɛ angana phɔ ya iwangya ŋwango ŋwa iɓoma Yesu. ");
INSERT INTO loq_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Waaoka Yesu maphɔɔ maamana, aesi ya mana o elele mɛ, ɓato ɓaikye ɓamba ya moɓenga. Amba bikya ɓato ɓa malɔsi ɓasɔ. ");
INSERT INTO loq_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Kasi amba ya ɓakatela na ɓokusi oɓokye ɓɛ́ɛ saimola ɓato elele eli yo. ");
INSERT INTO loq_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Wakyelama ɓaɓona phɔ ya ikokya maloɓa ma moimosi Isaya maa wɔ yo ɓoɓo: ");
INSERT INTO loq_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«Ŋwaphongo yokye: Kyeka moto wa etoma wa nga owa ɔlɔ nga. Na mozingye, nali na nkyisa phɔ yɛ. Ɓolɔɓɔ pha nga pha moɓa nɛ, phɔ aimole nkyisi isɔ maphɔɔ maazingye nga. ");
INSERT INTO loq_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Eta okye ɓooka na moto, eta tombe ŋwɛsi, ete ɓaamookye kakyɛmiwɔ o munsɔngɔ. ");
INSERT INTO loq_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Eta tene munkata ŋwaumbama; eta zimya tala ekyelukye izima. Amokyela ɓaaɓona tee nɔnɔ wa molonga maphɔɔ masɔ na ɓosembo. ");
INSERT INTO loq_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Amoɓa molemo ŋwa nkyisi isɔ.» ");
INSERT INTO loq_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ɓamba yelela Yesu moto mɔnɔmɔ aɓaka na ɓolɔɓɔ ɓoɓe, aphɔlɔ miyo, ambi kula ɓa na mbubu. Yesu amba ya mobikya, emba moto mɛ amba butwa iwɔ na iwɛnɛ. ");
INSERT INTO loq_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ɓato ɓasɔ ɓakamwaka ɓaamba tunana ɓɛkye: «Eye teli nkɔkɔ wa Davidi?» ");
INSERT INTO loq_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Waaoka Ɓafalisayi ɓawɔ ɓaɓona, ɓamba wɔ ɓɛkye: «Moto mona katɔkɔlɔ malɔɓɔ maɓe phɔ mokonzi ŋwa ɓɛ́ɛ Bɛlɛzɛbula amophɛ ɓokonzi mɛ!» ");
INSERT INTO loq_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Kasi Yesu aeɓaka maumunya ma ɓɛ, amba ya wɔ na ɓɛ́ɛ yokye: «Ɓo ɓato ɓa ɓokonzi ɓɔnɔɓɔ ɓakaɓwa onte ya ɓɛ, ɓokonzi pha ɓɛ́ɛ pha mowaa. Ɓo ɓato ɓa mokyisi mɔnɔmɔ naa ɓa iɓota sɔnɔsɔ ɓakaɓwa, mokyisi naa iɓota mɛ itesiikule ɓa. ");
INSERT INTO loq_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ka ɓo Molemba awiinye moto wɛ, kaɔtɔ nde ɓokonzi phɛ mampenza, emba ɓokonzi phɛ phaamba kɔkɔ ndengye'ye? ");
INSERT INTO loq_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ɓɛ̀ɛ kowɔ oɓokye Bɛlɛzɛbula moto owampɛ mwiya ŋwa itɔkɔlɔ malɔɓɔ maɓe. Ka ɓo eli phɛlɛ, owaamba phɛ ɓato ɓa ɓɛ̀ɛ mwiya ŋwa itɔkɔlɔ malɔɓɔ maɓe nza? Ɓato ɓa ɓɛ̀ɛ mampenza ɓa enyɛtɛ! ");
INSERT INTO loq_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ɓo natɔkɔlɔ malɔɓɔ maɓe na Ɓolɔɓɔ pha Ŋwaphongo, kyelukye iwɔ oɓokye Ɓokonzi pha Ŋwaphongo ɓokomi nɔnɔ oka ɓɛ̀ɛ.» ");
INSERT INTO loq_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","«Moto takokyi inyɔlɔ o ingambi sa moto mokusi phɔ ya iɓɔlɔlɔ mbolo yɛ, ɓo naino tamokangyi maphanga; kasi ɓo amokangyi maphanga, akokyi imoɓɔlɔlɔ mbolo isɔ ya ingambi. ");
INSERT INTO loq_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Moto ootoli na nga mbale, kanzine. Yo ootonsungye na iɓɔkya ɓato, ka ɓanyangole. ");
INSERT INTO loq_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Yango mɛna na wɔ na ɓɛ̀ɛ ngakye: Ɓato ɓasɔ ɓaakyele masumu na ɓaatiyole Ŋwaphongo, ɓaaɓalimbisa. Kasi moto owamowamba Ɓolɔɓɔ Ɓosanto ete ɓaamolimbisa. ");
INSERT INTO loq_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Owa mowɔlɛ Ŋwana wa Moto lowɔ loɓe, ɓaamolimbisa, ka nde yo owa mowɔlɛ Ɓolɔɓɔ Ɓosanto na ɓoɓe, ete ɓaamolimbisa, eɓe o mokyisi mumu, eɓe na o mokyisi ŋwaa moyaa.» ");
INSERT INTO loq_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«Ɓo ophikyi ŋwete moola, wa mozwa mbuma iindaa; ɓo ophikyi ŋwete moɓe, wa mozwa nde mbuma iimbe. Phɔ ɓaeɓe ŋwete nde na mbuma ya ŋwango. ");
INSERT INTO loq_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ɓɛ̀ɛ manzɔɔ! Oli ɓato ɓaɓe, waamba wɔ maphɔɔ malaa ndengye'ye? Phɔ munɔkɔ katɔkɔlɔ nde maphɔɔ maute o ndondo. ");
INSERT INTO loq_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Moto molaa katɔkɔlɔ maphɔɔ malaa maute o ndondo yɛ, moto moɓe katɔkɔlɔ maphɔɔ maɓe maute o ndondo yɛ mɛ. ");
INSERT INTO loq_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Na wɔ na ɓɛ̀ɛ ngakye: Mokɔlɔ ŋwa mosambisa Ŋwaphongo ɓato, moto na moto amosamba na maphɔɔ masɔ maapha maatɔkɔlɔ o munɔkɔ nwɛ. ");
INSERT INTO loq_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Phɔ ɓamoelongya nde na ɓowɔkye pha wɛ naa ɓamoenyɛtɛ nde na ɓowɔkye pha wɛ.» ");
INSERT INTO loq_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Emba ɓateye ɓa miɓeko ɓaayɔkɔ na Ɓafalisayi ɓamɓa ya wɔ na Yesu ɓɛkye: «Moteye, tozingye oɓokye olokyelele elekyesako.» ");
INSERT INTO loq_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yesu amba ya ɓabuyisa ɓoɓo: «Ŋwaphongo amoteya nde elekyesako yɔnɔyɔ eyaka moimosi Yona. ");
INSERT INTO loq_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Phɔ ɓo wakyelaka Yona nkɔlɔ iyato o ibuu sa swe eenɛnɛ, nde ɓomɔ Ŋwana wa Moto amokyela nkɔlɔ iyato o se ya manyɛtɛ. ");
INSERT INTO loq_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Mokɔlɔ ŋwaa mosambisa Ŋwaphongo ɓato, ɓato ɓa Niniwe ɓamoya ephunda ɓɛ̀ɛ ɓato ɓaa lɔlɔ, phɔ ɓɛ́ɛ ɓaɓongolaka ntema ya ɓɛ́ɛ waoka ɓɛ́ɛ yaawɔkɔ Yona. Kasi ooli wawa alekyi Yona. ");
INSERT INTO loq_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Mokɔlɔ ŋwaa mosambisa Ŋwaphongo ɓato, mokonzi ŋwa ŋwaŋwasi wa mokyisi ŋwa Saɓa amoya ephunda phɔ yo autaka itakye phɔ ya iya oka maphɔɔ ma zebi sa Salomo. Kasi ooli wawa, alekyi Salomo!» ");
INSERT INTO loq_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","«Ɓo ɓolɔɓɔ ɓoɓe ɓotɔkɔsi onte ya moto, ɓokyɛ miengyeɓana o bokye phɔ ya iluka elele ya iɓaa. Ɓo te ɓozwe elele, ");
INSERT INTO loq_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ɓomiwɔlɛ oɓokye: “Nakule butolela moto owa ɓaka nga phɔ yo ali ndokolo ingambi sa nga.” Kasi waa ya butwa phaango, ɓoyazwa ingambi mɛ pha, ɓasi ɓɔngyɛ na ɓolaa. ");
INSERT INTO loq_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Emba ɓoombe kyɛ kpa mbengo ya malɔɓɔ masuu sambo maaɓolekye na ɓoɓe; mango masɔ maambe yaa molɔngɔ iya zala o nzoto ya moto mɔna. Emba moto mɔna kambe ɔtɔnɔ ileka ɓowaɓaka yo phanza. Ya moɓa nde ɓomɔ phɔ ya ɓɛ̀ɛ ɓato ɓaaɓe ɓaalɔlɔ.» ");
INSERT INTO loq_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Waaɓa Yesu kataa wɔ na ɓato, nyango na ɓana nyango ɓaamba ya. Ɓaesi ya tɛmɛ o nze, ɓalukaka iwɔnɔ nɛ. ");
INSERT INTO loq_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Moto mɔnɔmɔ amba ya wɔ na Yesu yokye: «Kyeka, nyɔngɔ na ɓanaa nyɔngɔ ɓali o nze, ɓalukye iwɔnɔ na wɛ.» ");
INSERT INTO loq_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesu amba ya buyisa moto mɛ yokye: «Mama nza? Ɓanaa mama ɓanza?» ");
INSERT INTO loq_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Amba teya na eɓɔkɔ bili ɓaekosi ɓɛ́ɛ yokye: «Kyeka mama na ɓanaa mama ɓɛ́ɛ ɓaɓa. ");
INSERT INTO loq_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Phɔ moto okokyele maphɔɔ maazingye Tata owa ikolo ali ŋwana mama, nkanasa ya nga na mama.» ");
INSERT INTO loq_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Mokɔlɔ mamuna, Yesu amba ya tɔkɔlɔ o ingambi, aesi ya kyɛ zala o mokukulu ŋwa ebale phɔ ya iteya. ");
INSERT INTO loq_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ɓato ɓaikye ɓamba ya angana wali yo, yango mɛna Yesu amba ya ɓaa o vato, akyɛ zala. Ɓato ɓasɔ ɓatɛmɛkyɛ o mokukulu. ");
INSERT INTO loq_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Yesu amba ya ɓaimola maphɔɔ maikye na bite. Awɔkɔ yokye: «Moto mɔnɔmɔ akyɛkyɛ phika ndemo o inzambi sɛ. ");
INSERT INTO loq_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Wa ɓa yo kakyɛminyaka ndemo, ndemo iiyɔkɔ ikaa o nzela, manyɔsi maesi ya ikomola. ");
INSERT INTO loq_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ndemo iiyɔkɔ ikyɛ kaa o elele ya maɓanga, wamɔ manyɛtɛ maikye phe, yango mɛna ndemo itɔkɔsi sakɔkɔ. ");
INSERT INTO loq_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Waangala moo, inyiti phɔ nkanga te ya ikaka nyɔsa. ");
INSERT INTO loq_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ndemo iiyɔkɔ ikyɛ kaa o nkata yaa milɔ, nkata mɛ ikosi, ikyɛtitise ndemo iindaa. ");
INSERT INTO loq_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Kasi ndemo iiyɔkɔ ikaa o manyɛtɛ malaa, iɓoti, ina mbuma munkama, iiyɔkɔ mbuma makoo motoɓa, iiyɔkɔ mbuma makoo maato.» ");
INSERT INTO loq_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yesu amba kula ɓakya yokye: «Ooli na matoo ma ioka, aokye!» ");
INSERT INTO loq_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Emba ɓaekosi ɓamba ya susinya phɛnɛphɛ na Yesu, ɓamba ya motuna ɓɛkye: «Phɔ ya'ye kolowɔlɛ na bite?» ");
INSERT INTO loq_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesu amba ya ɓabuyisa yokye: «Ɓɛɛ okokyi eɓa sekyele ya Ɓokonzi pha Ikolo, kasi ɓɛ́ɛ teɓakokyi ieyeɓa. ");
INSERT INTO loq_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Phɔ moto ooli na mbolo nzikye, ɓamokula moɓakyisela, kasi ooli phaa, ɓaamoɓɔlɔlɔ na ŋwana ndambo ooɓakyi nɛ. ");
INSERT INTO loq_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Yango mɛna nakpe bite phɔ ya iɓawɔlɛ, phɔ na ɓo ɓakyekye teɓawɛnɛ, na ɓo ɓalaa mato, teɓaokye, teɓaa sɔsɔlɔ, teɓaambe na eɓa. ");
INSERT INTO loq_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Na ɓaɓona maloɓa ma moimosi Isaya makokyisame waa wɔ yo oɓokye: “Na ɓo ookyi ndengye'ye, otoeɓe, na ɓo olembetesi ndenye'ye, otoowɛnɛ. ");
INSERT INTO loq_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Phɔ ɓato ɓaɓa ɓali na ntema nkusi, ɓamiundi matoo, ɓazibi miyo phɔ ɓɛ́ɛ sawɛnɛ, ɓɛ́ɛ saoka, ɓɛ́ɛ saeɓa. Ɓo sa ɓaɓona phe, nde ɓaɓongolaka ntema ya ɓɛ́ɛ phɔ naɓabikya, kye wɔ Ŋwaphongo.”» ");
INSERT INTO loq_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","«Ka ɓɛ̀ɛ, ɓa na nkyisa phɔ miyo ma ɓɛ̀ɛ mawɛnɛ, matoo ma ɓɛ̀ɛ maokye! ");
INSERT INTO loq_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nde phɛlɛ na wɔ na ɓɛ̀ɛ ngakye: Ɓaimosi ɓaikye na ɓato ɓa ɓosembo ɓaikye ɓaɓaka na phowa ya ioka na ya iwɛnɛ maphɔɔ mawɛnɛ ɓɛ̀ɛ mama, kasi teɓaika mawɛnɛ, ɓaɓaka na phowa ya ioka maphɔɔ maokye ɓɛ̀ɛ mama, kasi teɓaika maoka.» ");
INSERT INTO loq_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«Okyemela ntina ya ete ya mophikyi. ");
INSERT INTO loq_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ɓato ɓaaokye simo ya Ɓokonzi pha ikolo kasi teɓaikyi esɔsɔlɔ, ɓali ndokolo ndemo ikaa o nzela, Munguna aesi ya imanya o mandondo ma ɓɛ. ");
INSERT INTO loq_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ɓato ɓaayɔkɔ ɓali ndokolo ndemo iikaa o manyɛtɛ maangana na maɓanga, ɓaokye iloɓa sa Ŋwaphongo, ɓasianole na nkyisa izele. ");
INSERT INTO loq_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Kasi iloɓa mɛ tesii tɔkɔlɔ nkanga o mandondo ma ɓɛ, ɓasikyelele nde ŋwana ɓokyi ɓoɓo; emba wambe yaa mampasi na minyɔkɔ phɔ ya iloɓa sa Ŋwaphongo, ɓalɛ ianola sa ɓɛ́ɛ izele. ");
INSERT INTO loq_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ɓato ɓaayɔkɔ ɓali ndokolo ndemo ikaa onte ya nkata yaa milɔ, ɓaokye iloɓa sa Ŋwaphongo, kasi phɔ ya phowa ya mokyisi na phowa ya ezwele ekye kosa ɓato, iloɓa mɛ siɔtɔnɔ, emba tesii ɓote na ekpele. ");
INSERT INTO loq_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ɓato ɓayɔkɔ ɓali ndokolo ndemo iikaa o manyɛtɛ maalaa, ɓaokye iloɓa sa Ŋwaphongo, ɓasisɔsɔlɔ, emba ɓaambe ɓota mbuma: Ɓána munkama, ɓaayɔkɔ makoo motoɓa, ɓaayɔkɔ makoo maato.» ");
INSERT INTO loq_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu amba kula ya ɓakpela ete esuu yokye: «Ɓokonzi pha ikolo pha ulana na moto mɔnɔmɔ owa aphikaka mumboto molaa o inzabi sɛ. ");
INSERT INTO loq_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Mokɔlɔ mɔnɔmɔ, waa mokɔlɔ, waaɓa ɓato ɓasɔ na ebuu, munguna ŋwa moto mɔnɔ aesi ya kyɛndɛ phika munkata mooɓe o nte ya ble nɔnɔ wakyɛndɛ yo. ");
INSERT INTO loq_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Waatɔkɔlɔ nkona, ble ekyesi ndomba, munkata mooɓe motɔkɔsi na ŋwango mɛ. ");
INSERT INTO loq_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ɓaombo ɓaesi yakyɛ wɔɔ na mokolo inzambi ɓɛkye: “Nkolo, ka waphikaka mumboto moola o inzabi sa wɛ, ka munkata mooɓe mouti bi?” ");
INSERT INTO loq_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Amba ya ɓabuyisa yokye: “Eli munguna ŋwa nga moto okyesi ɓaaɓona.” Emba ɓaombo ɓaamba ya motuna ɓɛkye: “Ozingyi oɓokye tokyɛ manya munkata mooɓe?” ");
INSERT INTO loq_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Amba ɓabuyisa yokye: “Phe, phɔ waamumanya ɓɛ̀ɛ munkata mooɓe nde obisi na ble. ");
INSERT INTO loq_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Oilɛ kyikole yango isɔ, waainɔkɔ, imbɛlɛ mɛ, na mowɔ na ɓanɔkyi ngakye: Taabila munkata mooɓe phanza, omokangye mbɔmbɔ mbɔmbɔ phɔ ya imotumba, sima ombe angyisa ble oenyɔsa o ɓompɛndɛ pha nga.”» ");
INSERT INTO loq_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu ambakula ɓakpela ete esuu yokye: «Ɓokonzi pha ikolo pha ulana na mumbuma ŋwa mutarde ŋwaaphika moto mɔnɔmɔ o inzabi sɛ. ");
INSERT INTO loq_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Eli mumbuma moolekyi ɓokyikyi onte ya mbuma isɔ, kasi ɓo motɔkɔsi, molekye ndemo isɔ iilii onte ya inzabi na phanda. Mobutwe ŋwete na bitakyi, manyɔsi maya tonga mooɓo omɔ.» ");
INSERT INTO loq_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu amba kula ya ɓakpela ete esuu yokye: «Ɓokonzi pha ikolo pha ulana na munɔɔ ŋwa mapa moangyinya ŋwaŋwasi na faline iikye, nɔnɔ waanyangwe ŋwango oena faline esɔ.» ");
INSERT INTO loq_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu awɔlɛ ɓato maphɔɔ masɔ maamana na bite, aɓaka kaɓawɔlɛ nde na bite. ");
INSERT INTO loq_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Akyelaka ɓaɓona phɔ ya ikokya maphɔɔ maawɔkɔ moimosi oɓokye: «Na mowɔ nde na bite. Namoimola maphɔɔ maaɓombama uta o etatele ya mokyisi.» ");
INSERT INTO loq_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Emba Yesu amba ya mana wali ɓato, amba ya butwa o ingambi. Ɓaekosi ɓɛ́ɛ ɓamba yakyɛ wali yo, ɓamba ya motuna ɓɛkye: «Ololimbolele ete ya munkata mooɓe o inzambi.» ");
INSERT INTO loq_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesu amba ya ɓabuyisa ɓoɓo: «Moto ookophikye mumboto moola, eli Ŋwana wa Moto, ");
INSERT INTO loq_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","inzambi eli mokyisi, mumboto moola eli ɓaanole Ɓokonzi pha ikolo, munkata mooɓe eli ɓato ɓaanole Munguna. ");
INSERT INTO loq_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Munguna okophikye munkata mooɓe, eli zabulu, mbuma ya inɔkɔ eli suka ya mokyisi, ɓanɔkyi eli ɓanze. ");
INSERT INTO loq_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ɓookomanya ɓɛ́ɛ munkata mooɓe phɔ ya imovaka o ŋwenya, yamoɓa nde ɓomɔ o suka ya mokyisi. ");
INSERT INTO loq_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ŋwana wa Moto amotoma ɓanze ɓɛ, ɓamumanya o ɓokonzi phɛ ɓato ɓasɔ ɓaɔtɔ ianola sa ɓɛbi, na ɓato ɓaakyele ɓoɓe, ");
INSERT INTO loq_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ɓaaɓavaka o itumbu sa ŋwenya, omɔ nde malelo na itwa mino. ");
INSERT INTO loq_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kasi ɓato ɓaa ɓosembo ɓamungyɛngyɛ ndokolo moo o ɓokonzi pha Ango wa ɓɛ. Oli na matoo ma ioka, aokye!» ");
INSERT INTO loq_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","«Ɓokonzi pha ikolo pha ulana na ezwele eya kundama o inzabi. Moto mɔnɔmɔ akyɛ ekundola ambikula eɓomba. Na nkyisa isɔ, akyɛ ungya mbolo yɛ isɔ phɔ aombe sina inzaɓi.» ");
INSERT INTO loq_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","«Ɓokonzi pha ikolo pha ulana na muungye wa mbolo ookolukye ɓayaka ɓaala. ");
INSERT INTO loq_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ɓo azwe yɔnɔyɔ eya motuya mwikye, amokyɛ ungya mbolo isɔ iili nɛ phɔ akyɛ omba ɓayaka mɛ.» ");
INSERT INTO loq_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«Ɓokonzi pha ikolo pha kula ulana na ɓondɛndi ɓovakyi ɓɛ́ɛ o eɓale, ɓooakye swe ndengye na ndengye. ");
INSERT INTO loq_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ɓotondi na swe, ɓaɔsi ɓaɓoɓendi o mokukulu, emba ɓambe zala phɔ ya iɔlɔ swe, iindaa ɓaikyele o bikɔkɔlɔ, iimbe ɓaivakye. ");
INSERT INTO loq_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ya moɓa nde ɓomɔ o suka ya mokyisi, ɓanze ɓamoya kaɓola ɓato ɓaaɓe na ɓato ɓaala. ");
INSERT INTO loq_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Phɔ ya ivaka ɓato ɓaaɓe o itumbu sa ŋwenya, omɔɔ nyaa malelo na itwa mino.» ");
INSERT INTO loq_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesu amba ya ɓatuna yokye: «Ɓɛɛ ookyi maphɔɔ masɔ mama na ɓolaa?» Ɓamba ya mobuyisa ɓɛkye: «Ɛɛ, tookyi.» ");
INSERT INTO loq_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Emba amba ya wɔ na ɓɛ́ɛ yokye: «Yango mɛna, moteye wa miɓeko munsɔ ookoekole maphɔɔ ma Ɓokonzi pha ikolo kaulane na moto wa ezwele ookotɔkɔlɔ ná mbolo iinkasi ná mbolo iinyakune.» ");
INSERT INTO loq_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Waaunva Yesu ikpa bite ɓabina, amba ya mana omɔ, ");
INSERT INTO loq_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","amba ya kyɛndɛ o mokyisi ŋwaakolaka yo. Aesi ya butwa iteya o Ingambi sa makyita. Emba ɓato ɓasɔ ɓaaɓaka wamɔ ɓakamwaka na ɓoikye. Ɓawɔkɔ ɓɛkye: «Azwe zebi sisi bi? Kakyele bilekyesako bibi ndengye'ye? ");
INSERT INTO loq_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Teli yo ŋwana wa mowasi ŋwa maɓaya? Nyango teli Maliya? Ɓanaa nyango teli Zake, Zozefu, Simo na Yuda? ");
INSERT INTO loq_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Mankanasa mɛ masɔ temali na ɓanga wawa? Ɓona ɓokonzi ɓoɓo aɓozwe bii?» ");
INSERT INTO loq_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Yango mɛna teɓaikaka moanolela. Emba Yesu amba ya wɔ na ɓɛ́ɛ yokye: «Moimosi wa Ŋwaphongo kazwe ngambo o nkyisi isɔ manya nde o mokyisi nwɛ na o iɓota sɛ.» ");
INSERT INTO loq_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Yesu amba ya kyela omɔ nde ɓanaa bilekyesako ndambo phɔ ɓɛ́ɛ teɓaikaka moanola. ");
INSERT INTO loq_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Imbɛlɛ saasina, Elode, mokonzi ŋwa Galileya, aesi ya oka ɓawɔ phɔ ya Yesu. ");
INSERT INTO loq_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Amba ya wɔ na ɓato ɓaetoma ɓɛ́ɛ yokye: «Eli Yoane Moɓatise, akundo! Yango mɛna azwe mwiya ŋwa ikyela bilikyesako ɓoɓo.» ");
INSERT INTO loq_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Phɔ phanza, Elode atomaka ɓaakya Yoane, ɓamokangye maphanga, ɓamovakye o bɔlɔkɔ. Yaɓaka phɔ ya lowɔɔ la Elodiya, ŋwasi wa ŋwana nyango Filipe. ");
INSERT INTO loq_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Phɔ Yoane awɔkɔ na Elode yokye: «Miɓeko ma ɓanga mikatele oɓokye tokokyi ibuya Elodiya ŋwasi wa wɛ!» ");
INSERT INTO loq_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Yango mɛna Elode alukaka iɓoma Yoane, kasi aɓaka kalote Ɓayuda, phɔ ɓato ɓasɔ ɓakpaka Yoane ndokolo moimosi. ");
INSERT INTO loq_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Nzuka mokɔlɔ ŋwaakyelaka Elode esɛlɛkɔ ya iyumunya mokɔlɔ ŋwaaɓotamaka yo, ŋwana wa Elodiya wa ŋwaŋwasi amba ya bina o ɓoo pha ɓato ɓaaɓangaka yo. Asepelisaka Elode na ɓoikye. ");
INSERT INTO loq_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Yango mɛna Elode amba kata seleka oɓokye aamophɛ ekpele esɔ eya moonga yo. ");
INSERT INTO loq_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Uta na mateya ma nyango, ŋwana amba ya wɔ na Elode yokye: «Impɛ uŋwaŋwa'eye moto ŋwa Yoane Moɓatise mi lako!» ");
INSERT INTO loq_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Mokonzi Elode aesi ya oka ngɔngɔ ɓoikye, kasi phɔ ya seleka eyakataka yo o ɓoo pha ɓato ɓaaɓangaka yo, amba ya toma oɓokye ɓamophɛ moto ŋwa Yoane. ");
INSERT INTO loq_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Amba ya toma moto mɔnɔmɔ ikyɛ tena moto ŋwa Yoane o bɔlɔkɔ. ");
INSERT INTO loq_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ɓaamba yaa na moto mɛ mi lako, ɓamba ya mophɛ ŋwana wa ŋwaŋwasi mɛ, yo amba yakyɛ mophɛ nyango. ");
INSERT INTO loq_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ɓaekosi ɓa Yoane ɓamba yakyɛ kpa ena eɓembe ɓamba kyɛ ekunda. Ɓamba kyɛ imola Yesu maphɔɔ maaleka. ");
INSERT INTO loq_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Waaoka Yesu simo ya iwaa sa Yoane Moɓatise, aesi ya mana omɔ yaa vato, amba ya kyɛ yo mampenza o elele yɔnɔyɔ ya indende. Kasi ɓato ɓaesi ya eɓa, ɓamba tɔkɔlɔ o nkyisi ya phɛnɛphɛ, ɓamba ya moɓenga na makolo yaa mokukulu. ");
INSERT INTO loq_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Waaɓwa yo o vato, aesi ya wɛnɛ ɓato ɓaikye, amba ɓaoka ngɔngɔ, amba butwa ibikya ɓato ɓa ɓɛ́ɛ ɓaamalɔsi. ");
INSERT INTO loq_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Waakoma waa nkɔkɔlɔ, ɓaekosi ɓa Yesu ɓamba ya susinya oli yo, ɓamba ya wɔ nɛ ɓɛ́ɛ kye: «Bunya ɓokyɛ, elele eye eli indende, buya ɓato phɔ ɓakyɛndɛ o nkyisi ɓakyɛ omba ntoma ya izaa omɔ.» ");
INSERT INTO loq_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesu amba ya ɓabuyisa yokye: «Te wali ntina oɓokye ɓakyɛndɛ, oɓaphɛ ɓɛ̀ɛ mampenza ntoma ya izaa!» ");
INSERT INTO loq_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Kasi ɓɛ́ɛ ɓamba ya wɔ nɛ ɓɛkye: «Wawa, toli nde na mapa matano na swe iɓale.» ");
INSERT INTO loq_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesu amba ya wɔ na ɓɛ́ɛ yokye: «Inzelele na yango.» ");
INSERT INTO loq_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Emba, amba ya wɔ na ɓato ɓasɔ ɓazale o nkata, aesi yakpa mapa matano na swe iɓale miina, amba ya tomba miyo o ikolo, aphɛ Ŋwaphongo mɛlɛsi. Aesi ya kyɛsɛ mapa amaphɛ ɓaekosi. Emba ɓaekosi ɓamba kyɛmikaɓela ɓato. ");
INSERT INTO loq_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ɓato ɓasɔ ɓazaka, ɓaokaka. Ɓaekosi ɓamba ya ɔngɔ ɓanyanzima iko mbuka ɓaɓale ɓoɓɛɛ ɓa bitee ɓaikalaka. ");
INSERT INTO loq_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ɓato ɓaazaka ɓaɓaka ɓampele phɛnɛphɛ na nkoto itano sa tanga ɓaɓasi na ɓana. ");
INSERT INTO loq_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Sakɔkɔ Yesu aesi ya toma ɓaekosi ɓɛ́ɛ ɓa baa o vato phɔ ɓakatisa o ɓoo phɛ o mokukulu moyɔkɔ, wamoɓa yo kataa buya ɓato. ");
INSERT INTO loq_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Waunva yo iɓabuya, aesi ya baa o ɓokosi phɔ ya iɓɔndɛlɛ. Waakoma nkɔkɔlɔ aikalaka wamɔ nde yo mampenza. ");
INSERT INTO loq_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Vato pha komaka o ɓodiko, kanda yaɓaka kye ɓabuya na munsima phɔ ewɛɛlɛ yaɓaka ekusi. ");
INSERT INTO loq_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Wakoma bunya phɛnɛphɛ na iyɛ, Yesu amba ya ɓenga ɓaekosi ɓɛ́ɛ yaa makolo, amba tambula o ikolo sa maa. ");
INSERT INTO loq_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Waamowɛnɛ ɓɛ́ɛ katambule o ikolo sa maa, ɓawɛnɛkyɛ ɓɔɔɓɔ, ɓamba wɔ ɓɛkye: «Eli mozisi!» Ɓamba butwa iyaŋwana na ɓona ɓɔɔɓɔ. ");
INSERT INTO loq_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Kasi mbala yɔnɔyɔ Yesu amba ya wɔ na ɓɛ́ɛ yokye: «Saila, eli nde nga, ɓɛ̀ɛ salota!» ");
INSERT INTO loq_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Emba Petelo amba ya wɔ na Yesu yokye: «Ɓo eli wɛ phɛlɛ, wɔ nanga na tambule o ikolo sa maa, nayee oli wɛ.» ");
INSERT INTO loq_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesu amba ya mobuyisa yokye: «Yaka!» Petelo aesi ya tɔkɔlɔ o vato amba ya butwa itambula o ikolo sa maa, phɔ ya ikyɛndɛ oli Yesu. ");
INSERT INTO loq_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Kasi waawɛnɛ yo ewɛɛlɛ ekusi, amba ya wɛnɛ inganga. Amba ya tata izinda nɔnɔ wa aŋwana yo yokye: «Nkolo, imbikya!» ");
INSERT INTO loq_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Mbala yɔnɔyɔ, Yesu amba ya elola eɓɔkɔ, aesi ya mophila, amba ya wɔ nɛ yokye: «Moto wa ianola sikyikyi! Phɔ ya'ye oikakyi ziko?» ");
INSERT INTO loq_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Emba ɓɛ́ɛ ɓasɔ ɓaɓale ɓamba ya baa o vato, ewɛɛlɛ esi ya lɛɛ. ");
INSERT INTO loq_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ɓoɓɛlɛ ɓaekosi ɓaɓaka o vato ɓamba ya kusama na maɓɔngɔ o ɓoo pha Yesu, ɓamba ya wɔ ɓɛkye: «Oli Ŋwana wa Ŋwaphongo phɛlɛ!» ");
INSERT INTO loq_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Waaunva ɓɛ́ɛ ikatisa ebale, ɓaesi ya kyɛ sɛmɛ o manyɛtɛ ma Genesalɛtɛ. ");
INSERT INTO loq_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ɓato ɓa mokyisi mɛ ɓaeɓaka Yesu phanza, emba waamowɛnɛ ɓɛ, ɓamba kyɛmiimola mboka esɔ oɓokye aesi. Ɓamba moyelela ɓato ɓasɔ ɓaa malɔsi. ");
INSERT INTO loq_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ɓamba ya nyingonela nɛ oɓokye aɓalɛ ɓakume nɔnɔ sɔngya ya munkoto nwɛ. Ɓato ɓasɔ ɓaamokumaka ɓabikaka. ");
INSERT INTO loq_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Mokɔlɔ mɔnɔmɔ, Ɓafalisayi na Ɓateye ɓa miɓeko ɓautaka o Yelusalɛmɛ, ɓamba ya angana oli Yesu, ɓamba ya motuna ɓɛkye: ");
INSERT INTO loq_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Phɔ ya'ye, ɓaekosi ɓa wɛ teɓaakumole miɓeko ma ɓankɔkɔ? Phɔ teɓaakunyole sɛ o ɓoo pha izaa.» ");
INSERT INTO loq_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesu amba ya ɓabuyisa yokye: «Ka ɓɛ̀ɛ, phɔ ya'ye tookumole miɓeko ma Ŋwaphongo, Kokumole nde ɓonkɔkɔ pha ɓɛ̀ɛ? ");
INSERT INTO loq_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Phɔ Ŋwaphongo awɔ ɓoɓo: “Kumola nyɔngɔ na ɔngɔ”, kasi “owa motola nyango na ango, ɓasengyesi imoɓoma.” ");
INSERT INTO loq_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Kasi ɓɛ̀ɛ kowɔ oɓokye: “Moto akokyi iwɔɔ na nyango eɓe na ango oɓokye mbolo iunvakyi esunga na nga, na iɓombi phɔ ya Ŋwaphongo.” ");
INSERT INTO loq_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ɓo awɔ ɓaɓona, takokyi kula sunga na nyango na ango. Mɛna kabuya miɓeko ma Ŋwaphongo ekpele phaa phɔ ya itosa ɓonkɔkɔ pha ɓɛ̀ɛ mampenza. ");
INSERT INTO loq_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ɓanyamaɓɔlɛ! Moimosi Isaya aɓaka nde na elongyi waawɔ yo phɔ ya ɓɛ̀ɛ ɓoɓo: ");
INSERT INTO loq_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Ɓato ɓaɓa ɓankumole nde na munɔkɔ. Kasi o mandondo ɓali itakye na nga. ");
INSERT INTO loq_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Losambo la ɓɛ́ɛ teloli na ntina. Phɔ mateya ma ɓɛ́ɛ mali nde miɓeko miute na ɓato.”» ");
INSERT INTO loq_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ɓoɓɛlɛ, Yesu amba ya ɓanga ɓato ɓasɔ, amba ya wɔ na ɓɛ́ɛ yokye: «Okyemela, ombe na kyitolela: ");
INSERT INTO loq_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Teli ekpele ekye nyɔlɔ o munɔkɔ ŋwa moto ekye mobuya moto wa sɔkɔtɔ. Kasi ekyetɔkɔlɔ o munɔkɔ nwɛ, kyeka yango ekye mobuya moto wa sɔkɔtɔ.» ");
INSERT INTO loq_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Emba ɓaekosi ɓamba susana phɛnɛphɛ na Yesu, ɓamba ya wɔ nɛ ɓɛkye: «Koeɓe oɓokye maphɔɔ maawɔ wɛ mamana, maphɛ Ɓafalisayi ndondo ɓolɔsi?» ");
INSERT INTO loq_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yesu amba ya buya yokye: «Ŋwete munsɔ ŋwaateŋwaika phika Tata oli o ikolo, ɓaamophikola. ");
INSERT INTO loq_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Oɓalɛ! Ɓali ɓato ɓaaphɔlɔ miyo ɓateya ɓato ɓaaphɔlɔ miyo nzela. Ɓo moto mɔnɔmɔ owa phɔlɔ miyo kateya nwɛbi nɛ owa phɔlɔ miyo nzela, ɓɛ́ɛ ɓasɔ ɓaɓale ɓamokaa o iɓela.» ");
INSERT INTO loq_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Petelo amba ya wɔ na Yesu yokye: «Ololimbolele ntina ya ete mɛ.» ");
INSERT INTO loq_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu amba ya wɔ yokye: «Na ɓɛ̀ɛ naino tozwe malondo? ");
INSERT INTO loq_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ɓɛ̀ɛ toeɓe oɓokye ekpele esɔ ekye nyɔlɔ o munɔkɔ ŋwa moto, kyelekane o ibuu sɛ, emba sima kyekyɛ tɔkɔlɔ o zikyi? ");
INSERT INTO loq_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Kasi ikyi tɔkɔlɔ o munɔkɔ, kyiute o ndondo, yango ikokyi ibuya moto, moto wa sɔkɔtɔ. ");
INSERT INTO loq_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Phɔ maumunya masɔ ma ikyela ɓoɓe maute o ndondo ya moto, eli ɓooli iɓoma ɓato, ikyela ɓaphemba, ikyela bondumba, iiɓa, ikatela ɓato ɓɔlɛ, na iyɔ ɓato. ");
INSERT INTO loq_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Mɛna eli maphɔɔ maɔtɔ moto. Kasi izaa sataa kunyola sɛ, tesiibuya moto, moto wa sɔkɔtɔ.» ");
INSERT INTO loq_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ɓoɓɛlɛ Yesu aesi ya mana o elele mɛ, akyɛ o nkyisi ya Tula na Sidona. ");
INSERT INTO loq_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ŋwaŋwasi mɔnɔmɔ wa Kanana aɓaka kazale o mokyisi mɛ, amba yaa oli Yesu, amba ya aŋwana yokye: «Moteye, Ŋwana wa Davidi, inzokye ngɔngɔ! Ŋwana wa nga wa ŋwaŋwasi ali na ɓolɔɓɔ ɓoɓe, ɓomunyɔkɔlɔ na ɓokusi!» ");
INSERT INTO loq_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Kasi Yesu taika mobuyisa na lowɔɔ. Ɓaekosi ɓamba yaa oli Yesu. Ɓamba ya wɔ nɛ ɓɛkye: «Omowiinya, phɔ taalɛ ikyɛmiaŋwana o sima ya ɓanga.» ");
INSERT INTO loq_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesu amba ya buya yokye: «Ɓantoma nde oka ɓato ɓa Isalayɛlɛ ɓaali ndokolo mampate maabunga.» ");
INSERT INTO loq_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Kasi ŋwaŋwasi mɛ, amba ya kusama o ɓoo pha Yesu, amba ya wɔ yokye: «Moteye, insungye!» ");
INSERT INTO loq_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesu amba ya wɔ yokye: «Teli ɓolaa o ɓokye okpe ntoma ya ɓana oivakyele manva.» ");
INSERT INTO loq_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ŋwaŋwasi mɛ amba ya wɔ yokye: «Nde phɛlɛ Moteye, kasi manva mazee mpusu ikyilale o se ya mesa ma ɓankolo ɓa mɛ.» ");
INSERT INTO loq_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Emba Yesu amba ya mobuyisa yokye: «Ee, ŋwaŋwasi oyo! Oli na ianola sinɛnɛ. Waekyelamele ɓoozingyi wɛ.» Nde o sina imbɛlɛ mɛ, ŋwana wɛ abikyi. ");
INSERT INTO loq_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ɓoɓɛlɛ Yesu aesi ya mana wa mɔ, akyɛ o mokukulu ŋwa maa maanɛnɛ ma Galileya. Aesi ya kyɛ zala o ikolo sa ngomba. ");
INSERT INTO loq_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ɓato ɓaikye ɓamba ya kyɛndɛ oli yo. Ɓanyanye ɓato ɓaaɔtɔnɔ makolo, ɓato ɓaaphɔlɔ miyo, bituku, mambubu, na ɓato ɓaa malɔsi ndengye na ndengye. Ɓamba ya ɓazasa o se o ɓoo pha Yesu, emba amba ya ɓabikya. ");
INSERT INTO loq_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ɓato ɓakamwaka waaawɛnɛ ɓɛ́ɛ mambubu mabuto iwɔ, bituku bibikyi, ɓato ɓaa ɔtɔnɔ makolo ɓatambusi, ɓato ɓaaphɔlɔ miyo, ɓawɛni. Emba ɓato ɓasɔ ɓamba tata ikumbela Ŋwaphongo owa Isalayɛlɛ. ");
INSERT INTO loq_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu amba ya ɓanga ɓaekosi ɓɛ, amba ya wɔ na ɓɛ́ɛ yokye: «Naokyele ɓato ɓaɓa ngɔngɔ, phɔ nkɔlɔ iyato ɓali na nga wawa, kasi teɓali na ntoma ya izaa. Sizingye iɓabuya na nzala, phɔ imbɛlɛ sisuu nde ɓakyɛ kpa phikyi o nzela.» ");
INSERT INTO loq_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ɓaekosi ɓamba ya motuna ɓɛkye: «Wawa toli o bokye, tomokyɛ zwa ntoma bi, oɓokye ɓazee ɓaokye?» ");
INSERT INTO loq_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Emba Yesu amba ya ɓatuna yokye: «Ɓɛɛ, oli na mapa ɓo?» Ɓamba mobuyisa ɓɛkye: «Toli na mapa sambo na ɓanaa swe inkyikyi.» ");
INSERT INTO loq_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Emba Yesu amba ya wɔ na ɓato ɓasɔ oɓokye ɓazale o se. ");
INSERT INTO loq_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Aesi ya kpa mapa sambo na ina swe, aphɛɛ Ŋwaphongo mɛlɛsi, aikyɛsi, aiphɛ ɓaekosi ɓɛ̀ɛ oɓokye ɓaikaɓe. Ɓaekosi ɓaikpe, ɓaikaɓesi ɓato ɓasɔ. ");
INSERT INTO loq_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ɓato ɓasɔ ɓaazaka ɓaokaka. Ɓaekosi ɓaɔngɔkɔ ntoma yaa otwaka ɓɛ, ya tonzaka ɓanyanzima sambo. ");
INSERT INTO loq_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ɓato ɓaazaka ɓaɓaka ɓampele nkoto ine, sa tanga ɓaɓasi na ɓana. ");
INSERT INTO loq_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Waaunva yo ibuya ɓato o nkyisi ya ɓɛ, Yesu aesi ya baa o vato, aesi ya kyɛndɛ o manyɛtɛ ma Magadana. ");
INSERT INTO loq_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ɓafalisayi na Ɓasadukayi ɓamba ya waali Yesu phɔ ya imumeka. Ɓaesi ya motuna oɓokye akyele elekyesako phɔ ya iteya oɓokye maphɔɔ maakyele yo maute oka Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yesu amba ya ɓabuyisa ɓoɓo: «Waakome nkɔkɔlɔ ɓɛ̀ɛ kowɔ oɓokye: “Mbula eteenɔ, phɔ ikolo sili silaa.” ");
INSERT INTO loq_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ka waamunkunkutu ɓɛ̀ɛ kowɔ oɓokye: “Lɔlɔ mbula ya munɔ, phɔ ikolo siɓɛlɔ.” Waakyekye ɓɛ̀ɛ ikolo, ɓɛ̀ɛ koeɓe naa mbula ya munɔ naa eteenɔ. Kasi bileko biiteya maphɔɔ ma nkɔlɔ ikyiye, toeɓe ibilimbola. ");
INSERT INTO loq_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ɓanyamaɓɔlɛ, ɓato ɓa lɔlɔ eye ɓali ɓato ɓaɓe na ɓato ɓa bikoɓo, teɓaakumole Ŋwaphongo, ɓaongye elekyesako. Kasi eteɓawɛnɛ na elekyesako na yɔnɔyɔ, ɓo teeɓe nd'eyaaka Yona phe.» Emba, amba ika ɓaika, aesi ya kyɛndɛ. ");
INSERT INTO loq_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Waakatisaka ɓaekosi o mbale eeyɔkɔ ya maa ma manɛnɛ, ɓabungaka iphila mapa. ");
INSERT INTO loq_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Emba Yesu amba ya wɔ na ɓɛ́ɛ yokye: «Kyeka! Nde kokyeɓe na munɔɔ ŋwa Ɓafalisayi na Ɓasadukayi moulole mapa!» ");
INSERT INTO loq_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ɓaekosi ɓamba butwa iwɔnɔ ɓɛ́ɛ na ɓɛ, ɓɛkye: «Awɔ ɓaɓona phɔ tololi na mapa.» ");
INSERT INTO loq_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Kasi Yesu aeɓaka maumunya ma ɓɛ, amba ya ɓatuna yokye: «Phɔ ya'ye kowɔnɔ ɓɛ̀ɛ na ɓɛ̀ɛ oɓokye, nde phɔ tololi na mapa? Ɓato ɓa ianola sikyikyi. ");
INSERT INTO loq_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ɓɛ̀ɛ naino tosɔsɔsi? Umunya mapa matano maazeyaka nga ɓampele nkoto itano. Umunya na motuya ŋwa ɓanyanzima ɓaa ɔngɔkɔ ɓɛ? ");
INSERT INTO loq_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Umunya na mapa sambo maazeyaka nga ɓampele nkoto ine, ɓanyanzima ɓo ɓaa ɔngɔkɔ ɓɛ̀ɛ? ");
INSERT INTO loq_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Phɔ ya'ye ɓɛ̀ɛ toosɔsɔlɔ oɓokye siikaka wɔ na ɓɛ̀ɛ phɔ ya mapa, waawɔkɔ nga na ɓɛ̀ɛ oɓokye: “Kyeɓa na munɔ ŋwa Ɓafalisayi na Ɓasadukayi moulole mapa!”» ");
INSERT INTO loq_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Emba ɓaekosi ɓamba ya sɔsɔlɔ oɓokye Yesu taikaka wɔ na ɓɛ̀ɛ oɓokye ɓakyeɓe na munɔ moulole mapa, kasi ɓakyeɓe na mateya ma Ɓafalifayi na Ɓasadukayi. ");
INSERT INTO loq_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu amba ya kyɛndɛ o nkyisi iili phɛnɛphɛ na manyɛtɛ ma Sezare, mokyisi ŋwa mokonzi Filipe. Amba ya tuna ɓaekosi ɓɛ́ɛ yokye: «Ɓato ɓawɔ ɓo phɔ ya Ŋwana wa Moto?» ");
INSERT INTO loq_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ɓamba ya mobuyisa ɓɛkye: «Ɓakyi ɓawɔ oɓokye oli Yoane Moɓatise, ɓana ɓɛkye oli Eliya. Ɓaayɔkɔ ɓakule wɔ ɓɛkye oli Jeremi naa mɔnɔmɔ na ɓaimosi.» ");
INSERT INTO loq_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Amba ya ɓatuna yokye: «Ka ɓɛ̀ɛ, kowɔ oɓokye nga nali nza?» ");
INSERT INTO loq_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simo Petelo amba ya buya yokye: «Iwɛ oli Masiya, Ŋwana wa Ŋwaphongo wa ɓomɔɔ.» ");
INSERT INTO loq_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Emba Yesu amba ya wɔ nɛ yokye: «Oli na nkyisa ɓoikye, Simo ŋwana wa Yoane phɔ teeli moto oeteye maphɔɔ mama, kasi nde Tata ooli o ikolo. ");
INSERT INTO loq_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Emba nga na wɔ na wɛ ngakye: Oli Petelo, o ikolo sa iɓanga sisi namotonga ingomba sa nga, na iwaa etesiikokye isibukola. ");
INSERT INTO loq_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Namoephɛ maphungola ma Ɓokonzi pha ikolo, eya mokanga wɛ wawa o se, Ŋwaphongo amoekanga o ikoli mɛ, eya moingola wɛ wawa o se, Ŋwaphongo nɛ amoeyingola o ikolo.» ");
INSERT INTO loq_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Emba Yesu amba ya katela ɓaekosi ɓɛ́ɛ na ɓokusi oɓokye ɓɛ́ɛ saimola nɔnɔ moto oɓokye iyo ali Masiya. ");
INSERT INTO loq_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tata imbɛlɛ mɛ, Yesu atati iimola ɓaekosi ɓɛ̀ɛ polele maphɔɔ maalukye imoyelela, amba ya wɔ yokye: «Esengyesi oɓokye na kyɛndɛ o Yelusalɛmɛ, omɔ, ɓankumu, ɓakonzi ɓa ɓanganga ɓa Ŋwaphongo, eɓe na ɓateye ɓa miɓeko ɓomunveninya ɓolɔsi ɓoikye. Ɓamumboma, kasi sima ya nkɔlɔ iyato na mokundwa.» ");
INSERT INTO loq_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Emba Petelo amba kyɛ nɛ ŋwana imbale, amba butwa imooya yokye: «Ee Nkolo! Ŋwaphongo amoeɓanza, maphɔɔ mamana ete maakyelame!» ");
INSERT INTO loq_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yesu aesi yaekpana, amba ya wɔ na Petelo yokye: «Mana itakye na nga, Satana! Oli iɓaku phɔ ya nga! Phɔ toumunya ɓokoumunya Ŋwaphongo, kasi koumunya ɓokoumunya ɓato.» ");
INSERT INTO loq_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Emba Yesu amba ya wɔ na ɓaekosi ɓɛ́ɛ yokye: «Ɓo moto kalukye imbenga yo sakula luka ɓolaa phɛ mampenza, anyanya ekulusu yɛ, emba ambe mbenga. ");
INSERT INTO loq_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Phɔ moto ookolukye ibikya ɓomɔɔ phɛ, aaɓobungya, kasi owa mobungya ɓomɔɔ phɛ phɔ ya nga, aaɓozwa. ");
INSERT INTO loq_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Na ɓo moto azwe ezwele esɔ eli o mokyisi, kasi abungye ɓomɔɔ phɛ, ambi zwa ekpele'ye? Ekpele'ye eekokyi yo iambya phɔ ya iikola ɓomɔɔ phɛ? ");
INSERT INTO loq_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Phɔ Ŋwana wa Moto amoya o nkyɛmɔ ya Ango, yo na ɓanze ɓɛɛ, emba amba phuta moto na moto ikokana na bitoma ɓɛ. ");
INSERT INTO loq_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nde phɛlɛ na wɔ na ɓɛ́ɛ ngakye: Onte ya ɓɛ̀ɛ ɓasɔ ɓaali wawa, ɓana ete ɓaata waa phanza, saika wɛnɛ na miyo ɓo wa moyaa Ŋwana wa Moto ndokolo mokonzi.» ");
INSERT INTO loq_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Sima ya nkɔlɔ motoɓa, Yesu aesi ya kpa Petelo, Zake na Yoane, ŋwana nyango na Zake, akyɛ na ɓɛ́ɛ o ngomba yɔnɔyɔ eanda, itakye na ɓato, omɔ ɓaɓaka nde ɓɛ́ɛ mampenza. ");
INSERT INTO loq_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Nzoto ya Yesu ya butwaka ndengye esuu o miyo ma ɓɛ. Ɓoo phɛ pha butwaka ɓongyɛngyɛ ndokolo moo, bitobu ɓɛ́ɛ ɓa butwaka bitane pɛɛ. ");
INSERT INTO loq_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ɓoɓɛlɛ, ɓaekosi mɛ ɓaato ɓaesi ya wɛnɛ Mose na Eliya ɓawɔnɔ na Yesu. ");
INSERT INTO loq_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Emba Petelo amba ya wɔ na Yesu yokye: «Nkolo, eli ɓolaa oɓokye toɓee wawa. Ɓoozingyi, namotonga ndalaku iyato wawa, mɔnɔmɔ phɔ ya wɛ, muna phɔ ya Mose, mooyɔkɔ phɔ ya Eliya.» ");
INSERT INTO loq_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Waataɓa yo kawɔ, impata sɔnɔsɔ siitane siesi ya ɓaziɓa, onte ya impata mɛ, ŋwɛsi mɔnɔmɔ moesi yaokana, mowɔ ɓoɓo: «Oyo ali Ŋwana wa nga owa sɔmi, nali na nkyisa ɓoikye phɔ yɛ. Omookye!» ");
INSERT INTO loq_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Waaoka ɓaekosi ŋwɛsi mɛ, ɓawɛnɛkyɛ ɓɔɓɔ ɓoikye, nɔnɔ waauya ɓɛ́ɛ maɓoo nɔnɔ o se. ");
INSERT INTO loq_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yesu amba ya kyɛndɛ ooli ɓɛ, aesi ya ɓakuma, amba ya wɔ na ɓɛ́ɛ yokye: «Iŋwaa, ɓɛ̀ɛ saila!» ");
INSERT INTO loq_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ɓamba inola maɓoo, kasi teɓaikyi wɛnɛ moto mosuu, nde Yesu yo mampenza. ");
INSERT INTO loq_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Waaɓa ɓɛ́ɛ ɓaute ngomba, Yesu aɓakatelaka yokye: «Ɓɛɛ saimola nɔnɔ moto mɔnɔmɔ maphɔɔ masɔ maawɛni ɓɛɛ, tee nɔnɔ mokɔlɔ ŋwaamokundwa Ŋwana wa Moto onte ya ɓawee.» ");
INSERT INTO loq_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ɓoɓɛlɛ ɓaekosi ɓamba ya tuna Yesu ɓɛkye: «Phɔ ya ye ɓateye ɓa Miɓeko ɓawɔ oɓokye, esengyesi oɓokye Eliya aye phanza?» ");
INSERT INTO loq_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Iyo, amba ya ɓabuyisa yokye: «Eli ɓomɔ, esengyesi oɓokye Eliya aye phanza phɔ ya iyaɓɔngya maphɔɔ masɔ. ");
INSERT INTO loq_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Kasi nga na wɔ na ɓɛ̀ɛ ngakye: Eliya nga aunva yaa, kasi teɓaika moeɓa. Ɓamokyelela maphɔɔ masɔ maɓe ɓo wazingaka ntema ya ɓɛ. Yango mɛna, ɓamunyɔkɔlɔ Ŋwana wa Moto nde ɓomɔ.» ");
INSERT INTO loq_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Emba, ɓaekosi ɓasɔsɔlɔkɔ oɓokye kaɓa wɔlɛ phɔ ya Yoane Moɓatise. ");
INSERT INTO loq_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Waabutwa ɓɛ́ɛ o elele eyikalaka ɓato, moto mɔnɔmɔ amba yaa ooli Yesu, amba kusama na maɓɔngɔ o ɓoo phɛ. ");
INSERT INTO loq_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Amba ya wɔ nɛ yokye: «Moteye, okyela ŋwana wa nga wa lele ngɔngɔ. Ali na iphukuluku, mbala esuu kakaa naa o ŋwenya naa o maa. ");
INSERT INTO loq_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nayakakyi nɛ oka ɓaekosi ɓa wɛ, kasi teɓaikyi koka imobikya.» ");
INSERT INTO loq_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesu amba ya wɔ na ɓɛ́ɛ yokye: «Oo! Ɓɛ̀ɛ toli nde na ianola! Esengyesi oɓokye na kule ɓa na ɓɛ̀ɛ bileko ɓo? Inzelele na ŋwana mɛ wawa!» ");
INSERT INTO loq_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yesu amba phaphala na ɓolɔɓɔ ɓoɓe mɛ, emba phamba tɔkɔlɔ o nzoto ya ŋwana, mina wamɔɔ, ŋwana abikyi. ");
INSERT INTO loq_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ɓaekosi ɓamba yaa ɓɛ́ɛ na ɓɛ́ɛ oli Yesu, ɓamba ya motuna ɓɛkye: «Ɓanga toloikyi koka itɔkɔlɔ ɓolɔɓɔ ɓoɓe mɛ phɔ ya'ye?» ");
INSERT INTO loq_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesu amba ya ɓabuyisa yokye: «Phɔ ɓɛ̀ɛ oli na ianola sikyikyi. Nde phɛlɛ na wɔ na ɓɛ̀ɛ ngakye: Naɓo oli na ianola sikyikyi ɓooli mumbuma ŋwa mutarde, wamowɔ na ngomba eye oɓokye: Mana wawa kyɛndɛ owo, ya mumana. Ekpele yɔnɔyɔ tekokyi iekatela.  ");
INSERT INTO loq_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Kasi ɓakokyi itɔkɔlɔ ɓolɔɓɔ pha ndengye mɛna nde na iɓɔndɛlɛ na ná imiima ntoma.» ");
INSERT INTO loq_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Mokɔlɔ mɔnɔmɔ ɓaekosi ɓamba yaangana ɓɛ́ɛ ɓasɔ o Galileya. Yesu amba ya wɔ na ɓɛ́ɛ yokye: «Ɓamoamba Ŋwana wa Moto o maɓɔkɔ ma ɓato. ");
INSERT INTO loq_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ɓaamoɓoma, kasi o sima ya nkɔlɔ iyato amokundwa o nte ya ɓawe.» Emba ɓaekosi ɓaokaka ngɔngɔ ɓoikye. ");
INSERT INTO loq_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Waakoma Yesu na ɓaekosi ɓɛ́ɛ o Kapalanauma, ɓato ɓaaphutisa mputi ya Tempelo, ɓamba ya waali Petelo. Ɓamba motuna ɓɛkye: «Moteye wa ɓɛ̀ɛ kaphute mputi ya Tempelo?» ");
INSERT INTO loq_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Petelo amba ya buya yokye: «Ɛɛ, kaphute.» Waanyɔlɔ Petelo o ingambi, Yesu amba ya wɔ nɛ yokye: «Simo, koumunya ɓo? Ookokyi iphuta mputi ya mokonzi ŋwa mokyisi nza? Ɓaalombo nde ɓabutu?» ");
INSERT INTO loq_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petelo amba ya mobuyisa yokye: «Ɓabutu.» Emba Yesu amba ya wɔ nɛ yokye: «Ɓo ɓaaɓona, ɓaamokyisi teɓaaphute. ");
INSERT INTO loq_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ka phɔ ɓanga saɓatungyisa, kyɛndɛ lɔɓɔ o maa maanɛnɛ, swe eya motata wɛ iimba, oetakole munɔkɔ, wa mowɛnɛ phalanga eya ebuni, oekpe, ophute mputi phɔ ya ɓanga na wɛ.» ");
INSERT INTO loq_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Mokɔlɔ mɔnɔmɔ ɓaekosi ɓamba ya waali Yesu, ɓamba ya motuna ɓɛkye: «Oolekyi na ngambo o Ɓokonzi pha ikolo nza?» ");
INSERT INTO loq_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesu amba ya ɓanga ŋwana omokyɛ, aesi ya motɛyɛ onte ya ɓɛ. ");
INSERT INTO loq_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Amba ya wɔ yokye: «Nde phɛlɛ nawɔ na ɓɛ̀ɛ ngakye: Ɓo moɓesi ŋwa ɓɛ̀ɛ temobuto ndokolo ŋwaka ɓana ɓaakyɛɛ phe, otonyɔlɔ o Ɓokonzi pha ikolo. ");
INSERT INTO loq_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Oolekyi na ngambo o Ɓokonzi pha ikolo, eli moto ookomiuya na ookobutwe ndokolo ŋwana oyo. ");
INSERT INTO loq_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Emba na moto nza, owa moyamba ŋwana omookyɛɛ phɔ ya nga, mɛna anzambi nde nga mampenza.» ");
INSERT INTO loq_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","«Ka moto nzaa owamokosa ɓaakyikyi ɓaɓa ɓaanzanole oɓokye ɓakyele ɓoɓe, elekakyi na ɓola oɓokye ɓatingya moto mɛ iɓanga sinɛnɛ o nkyingo, ɓamovakye o ebale. ");
INSERT INTO loq_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ngɔngɔ ɓoikye na ɓato ɓa mokyisi, na ndengye ekyekyele ɓɛ́ɛ oɓokye ɓɛbi ɓakyele masumu. Maphɔɔ ma ndengye mɛna temakokyi izanga; kasi ngɔngɔ ɓoikye eli na moto okokyele oɓokye ɓɛbi ɓakyele masumu. ");
INSERT INTO loq_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ɓo eɓokɔ ya wɛ naa ekolo ya wɛ kyeetome ikyela ɓoɓe, oetene, phɔ elekyi na ɓolaa inyɔlɔ o lola na eɓokɔ yɔnɔyɔ naa ekolo yɔnɔyɔ na ikyɛndɛ na maɓɔkɔ maɓale na ná makolo maɓale o lifelo, o ŋwenya mote mozime. ");
INSERT INTO loq_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ka ɓo ziyo sa wɛ sietome ikyela ɓoɓe, osiphɛngɔlɔ kosivakye itakye na wɛ, phɔ elekyi ɓolaa phɔ ya wɛ inyɔlɔ o lola na ziyo sɔnɔsɔ, na ikyɛndɛ na miyo masɔ maɓale o ŋwenya ŋwa lifelo.» ");
INSERT INTO loq_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","«Kyeɓa na iwɛnɛ mɔnɔmɔ na ɓana ɓaɓa phaa; naewɔlɛ phɔ ɓanze ɓa ɓɛ́ɛ ɓaaɓatele ɓatɛmɛ imbɛlɛ sisɔ o ɓoo pha Tata oli o ikolo.  ");
INSERT INTO loq_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Phɔ Ŋwana wa Moto aesi ya bikya ɓaabunga.» ");
INSERT INTO loq_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","«Ɓɛ̀ɛ koumunya ɓo? Ɓo moto mɔnɔmɔ ali na mampate munkama, ɓo yɔnɔyɔ ebungyi, etaikye ika makoo ibuya mbuka ibuya o ikolo sa ngomba phɔ akyɛ luka eebungyi? ");
INSERT INTO loq_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nde phɛlɛ nawɔ na ɓɛ̀ɛ ngakye: Ɓo aezwe, amoɓaa na nkyisa phɔ ya mpate mɛ ileka nkyisa iiɓakyi nɛ phɔ ya mampate mako ibuwa mbuka ibuwa matemaikakyi bunga. ");
INSERT INTO loq_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Nde ɓomɔ, Ango wa ɓɛ̀ɛ ooli o ikolo taazingye oɓokye na mɔnɔmɔ na ɓana ɓaɓa abungye.» ");
INSERT INTO loq_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","«Ɓo nwɛbi aekyesi ɓoɓe, kyɛndɛ oka yɛ, omowɛninya ɓoɓe ɓoekyesi yo ɓɛ̀ɛ ɓaɓale. Ɓo aeyokyi, mɛna akuli butwa nwɛbi na wɛ. ");
INSERT INTO loq_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Kasi ɓo alɛ iyeyoka, kpa moto mɔnɔmɔ naa ɓaɓale, phɔ “ɓatene ɓolombe nde minɔkɔ ya manzoka maɓale naa maato.” ");
INSERT INTO loq_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Kasi ɓo alɛɛ iɓaoka, oloimole o ingomba. Emba ɓo ambi lɛ ioka ingomba, omowɛnɛ ndokolo mopakano naa ndokolo mophutise wa mputi.» ");
INSERT INTO loq_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","«Nde phɛlɛ nawɔ na ɓɛ̀ɛ ngakye: Maphɔɔ masɔ maamoanola ɓɛ̀ɛ wawa o se, nɛ Ŋwaphongo aamaanola o ikolo; ka maphɔɔ masɔ maamolɛ ɓɛ̀ɛ wawa o se, Ŋwaphongo nɛ aamalɛ o ikolo. ");
INSERT INTO loq_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Nakule wɔ na ɓɛ̀ɛ ngakye: Ɓo o mokyisi mumu, ɓato ɓaɓale onte ya ɓɛ, ɓaokaa iɓɔndɛlɛ phɔ ya inzonga ekpele, Tata owa ikolo aaɓaphɛ yango. ");
INSERT INTO loq_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Phɔ elele esɔ eangaa ɓato ɓaɓale naa ɓaato na nkombo ya nga, nali onte ya ɓɛ.» ");
INSERT INTO loq_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Emba Petelo amba yaa phɛnɛphɛ na Yesu, amba ya motuna yokye: «Nkolo, ɓo nwɛbi na nga ankyesi ɓoɓe esengyesi oɓokye na molimbisa mɓala ɓo? Ekokyi iɓaa mbala sambo?» ");
INSERT INTO loq_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu amba ya mobuyisa yokye: «Phe, siiwɔ na wɛ oɓokye mbala sambo, kasi mbala mako sambo mbala sambo. ");
INSERT INTO loq_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Yango mɛna, Ɓokonzi pha ikolo pha ulana na mokonzi mɔnɔmɔ owa ɓangaka ɓato ɓɛ̀ɛ ɓaaetoma, phɔ akyekye maphɔɔ ma mambɔngɔ ma ɓɛ. ");
INSERT INTO loq_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Waatata yo ikyeka maphɔɔ mɛ, ɓamoyelesi na moto wa etoma mɔnɔmɔ owa ɓaka na mbɔngɔ enɛnɛ. ");
INSERT INTO loq_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Moto mɛ taɓaka na ɓaphalanga ɓaiita mbɔngɔ mɛ. Yango mɛna mokonzi nwɛ amba ya toma oɓokye, ɓamoungya ndokolo moombo na ŋwaŋwasi na ɓana ɓa ɓɛɛ, eɓe na mbolo yɛ, phɔ ya iita ena mbɔngɔ. ");
INSERT INTO loq_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Moto wa etoma mɔna, amba ya kusama na maɓɔngɔ; amba wɔ yokye: “Mokonzi inzuyisa mɔɔ, impɛ ɓanaa nkɔlɔ, namwita mbɔngɔ ya wɛ esɔ.” ");
INSERT INTO loq_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Mokonzi aesi ya mooka ngɔngɔ, amolimbise, nɔnɔ waamolɛ yo akyɛ. ");
INSERT INTO loq_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Waatɔkɔlɔ moto wa etoma mɔna, akyɛ vana na nwɛbi nɛ wa etoma owa ɓaka na ŋwana mbɔngɔ yɛ ekyikyi ya ɓaphalanga. Amoakye o ŋwɛsi, abuto imunyata na ɓokusi, amba ya wɔ yokye: “Iita mbɔngɔ ya nga!” ");
INSERT INTO loq_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Nwɛbi nɛ amba ya kusama na maɓɔngɔ, amba ya nyingonela nɛ yokye: “Inzuyisa mɔɔ, impɛ ɓana nkɔlɔ, namwita mbɔngɔ ya wɛ!” ");
INSERT INTO loq_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Kasi yo taikaka anola, amba kyɛ munyɔsa o bɔlɔkɔ tee nɔnɔ mokɔlɔ ŋwa iita yo mɓɔngɔ yɛ. ");
INSERT INTO loq_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Waawɛnɛ ɓato ɓaetoma ɓaayɔkɔ ɓaaɓona, ɓawɛnɛkyɛ ngɔngɔ ɓoikye, ɓamba yakyɛ imola mokonzi ŋwa ɓɛ. ");
INSERT INTO loq_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Mokonzi amba ya ɓanga moto wa etoma mɛ, amba ya wɔ nɛ yokye: “Oli moto wa etoma moɓe! Waɓaka na mbɔngɔ ya nga, na elimbisaka phɔ wanyingonelaka na nga. ");
INSERT INTO loq_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nawɛ nga osengyelakyi iyokyela nwɛbi na wɛ ngɔngɔ ɓo wa eyokyelaka nga ngɔngɔ.” ");
INSERT INTO loq_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Mokonzi aokaka yɔ, amba ya nyɔsa moto wa etoma mɛ o bɔlɔkɔ, tee nɔnɔ mokɔlɔ ŋwa mwita yo mbɔngɔ yɛ.» ");
INSERT INTO loq_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yesu amba ya wɔ yokye: «Tata ooli o ikolo amoekyela nde ɓomɔ, ɓo mɔnɔmɔ onte ya ɓɛ̀ɛ talimbise nwɛbi nɛ na ndondo yɔnɔyɔ.» ");
INSERT INTO loq_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Waaunva Yesu iwɔ maphɔɔ mamana, amani o Galileya, aesi ya kyɛndɛ o manyɛtɛ ma Yuda mali o mokukulu mooyɔkɔ ŋwa ebale ya Yaladɛnɛ. ");
INSERT INTO loq_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Moluku ŋwa ɓato moikye ŋwamba ya moɓenga o mɔ, amba ya ɓabikya. ");
INSERT INTO loq_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Bafalisayi ɓaayɔkɔ ɓayakaka oli Yesu phɔ ya imumeka, ɓamba ya motuna ɓɛkye: «Miɓeko ma ɓanga mianole oɓokye lele akokyi ilɛ ŋwasi wɛ nde pha ɓaɓona?» ");
INSERT INTO loq_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesu amba ya ɓabuyisa yokye: «Ɓɛ̀ɛ naino totangyi buku pha Ŋwaphongo? “O etatele ya mokyisi, Ŋwaphongo akyelaka ŋwaŋwasi na lele.” ");
INSERT INTO loq_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Emba, amba ya wɔ yokye: Yango mɛna, lele amoika nyango na ango, amokyɛ angana elele yɔnɔyɔ na ŋwaŋwasi wɛ, phɔ ɓɛ́ɛ ɓasɔ ɓaɓale ɓabutwe moto mɔnɔmɔ. ");
INSERT INTO loq_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Nde ɓomɔ, teɓakuli ɓa ɓato ɓaɓale, kasi ɓabuto moto mɔnɔmɔ. Emba ɓo Ŋwaphongo ambo angyinya ŋwaŋwasi na lele, moto sa ɓakabinya.» ");
INSERT INTO loq_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ɓafalisayi ɓamba ya motuna ɓɛkye: «Ka phɔ ya ye Mose aphɛkyɛ nzela oɓokye ɓo lele kalɛ ŋwaŋwasi na ɓolonga, asengyesi imokomela mokanda moteya oɓokye ɓolonga ɓowe?» ");
INSERT INTO loq_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesu amba ya ɓabuyisa yokye: «Mose aephɛkyɛ nzela ya ilɛ ɓaɓasi phɔ ya nzoto ɓokusi ya ɓɛ̀ɛ. Kasi uta o etatele teyaikaka ɓaa ɓaɓona. ");
INSERT INTO loq_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Kasi nga na wɔ ɓɛ̀ɛ ngakye: Ɓo lele alɛ ŋwasi wɛ, ɓo te eɓe nde phɔ ya ɓondumba phe, akyɛɛ longa mosuu, mɛna kakyele phemba.» ");
INSERT INTO loq_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ɓaekosi ɓɛ́ɛ ɓamba ya wɔ nɛ ɓɛkye: «Ɓo moɓeko ŋwa ɓolonga moɓee ɓaɓona, elekyi na ɓolaa iɓa salonga.» ");
INSERT INTO loq_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesu amba ya ɓabuyisa yokye: «Teli ɓato ɓasɔ ɓaakokyi isɔsɔlɔ mateya mama, manya nde ɓaaunva phɛ Ŋwaphongo ɓokusi pha imaanola. ");
INSERT INTO loq_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Maphɔɔ mali maikye, maakatele moto salonga. Ɓakyi teɓaalongwe phɔ ɓanyiɓa ɓompele tata o iɓotama, ɓana ɓaɓaɓoma ɓompele, ɓaayɔkɔ te ɓalongye phɔ ɓamiambya muwɔsi phɔ ya Ɓokonzi pha ikolo. Moto oakokyi ianola mateya mama, amaanole!» ");
INSERT INTO loq_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Mokɔlɔ mɔnɔmɔ ɓato ɓayelesi Yesu ɓana ɓa ɓɛ́ɛ phɔ aɓatandele maɓɔkɔ ambe na ɓɔndɛlɛ phɔ ya ɓɛ, ɓaekosi ɓamba ɓakatela. ");
INSERT INTO loq_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Kasi Yesu amba ya wɔ yokye: «Lɛ ɓana ɓakyɛ ɓaye oka nga, lɛ ɓakatela, phɔ Ɓokonzi pha ikolo ɓoli phɔ ya ɓato ɓali ndokolo ɓana ɓakyɛ.» ");
INSERT INTO loq_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Waaɓatandela yo maɓɔkɔ, amba ya mana wamɔ. ");
INSERT INTO loq_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Moto mɔnɔmɔ amba yaa oli Yesu, amba ya motuna yokye: «Moteye, lowɔ'ye loolaa, losengyesi nga ikyela phɔ na zwe ɓomɔɔ pha ɓoɓɛlɛ?» ");
INSERT INTO loq_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesu amba ya mobuyisa yokye: «Phɔ ya'ye kontune phɔ ya lowɔɔ loolekyi ɓolaa? Ooli molaa nde Ŋwaphongo. Ɓoozingyi inyɔlɔ o mokyisi ŋwa ɓomɔɔ, kumola miɓeko.» ");
INSERT INTO loq_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Moto mɛ amba ya motuna yokye: «Miɓeko ye?» Yesu amba ya mobuyisa yokye: «Saɓoma moto, sakyela ɓaphemba, saiɓa, sakatela moto ɓɔɔlɛ, ");
INSERT INTO loq_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","kumola nyɔngɔ na ɔngɔ, zinga mobuɓaa na wɛ ɓo komizingye wɛ mampenza.» ");
INSERT INTO loq_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Munzenga mɛ amba ya wɔ nɛ yokye: «Nakumole miɓeko misɔ maamina. Nakule kyela'ye?» ");
INSERT INTO loq_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu amba ya wɔ nɛ yokye: «Ɓo ozingyi iɓa moto o molaa kyɛndɛ kyɛ ungya mbolo ya wɛ isɔ, ombe kaɓela ɓaɓola ɓana ɓaphalanga. Emba waamba ɓa na ezwele o ikolo. Sima, yaka ya mbengye.» ");
INSERT INTO loq_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Kasi waaoka munzenga mɔna ɓaaɓona, aesi ya butwa na ngɔngɔ phɔ aɓaka moto wa ezwele iikye. ");
INSERT INTO loq_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Emba Yesu amba ya wɔ na ɓaekosi ɓɛ́ɛ yokye: «Nde phɛlɛ na wɔ na ɓɛ̀ɛ, wali nkamba phɔ ya moto wa ezwele inyɔlɔ o ɓokonzi pha ikolo. ");
INSERT INTO loq_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nakule wɔ na ɓɛ̀ɛ ɓoɓo: Wali nkamba phɔ ya nyama enɛnɛ ɓoli shamo iinyɔlɔ o iluu sa sɔlu. Kasi nkamba kyikule lɔɓɔ phɔ ya moto wa ezwele inyɔlɔ o ɓokonzi pha Ŋwaphongo.» ");
INSERT INTO loq_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Waaoka ɓaekosi maphɔɔ mɛ, ɓamba kamwa na ɓoikye, ɓamba ya wɔ ɓɛkye: «Ɓo eɓe ɓaɓona, ombi koka ibika nza?» ");
INSERT INTO loq_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesu aɓakyekyi, amba ya wɔ na ɓɛ́ɛ yokye: «Moto takokyi imibikya nde yo mapenza, kasi eli nde Ŋwaphongo ookokyi ikyela maphɔɔ masɔ.» ");
INSERT INTO loq_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Emba Petelo amba ya kpa maloɓa yokye: «Kyeka, ɓanga ɓaɓa toikyika isɔ yaaɓaka na ɓanga, tobuto ikyɛmieɓenga, ekpele'ye eya mozwa ɓanga?» ");
INSERT INTO loq_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu amba ya ɓabuyisa yokye: «Nde phɛlɛ na wɔ ɓɛ̀ɛ ngakye: Imbɛlɛ saamozala Ŋwana wa Moto o eziye yɛ ya ngambo, o mokyisi ŋwaa sika, ɓɛ̀ɛ ɓambengakyi, wa mozala na ɓɛ̀ɛ o biziye iko mbuka biɓale phɔ ya itenaka malombe ma maɓota iko mbuka maɓale ma Isalayɛlɛ. ");
INSERT INTO loq_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ka moto munsɔ oikyika ingambi sɛ, eɓe ɓanaa nyango, eɓe nyango na ango, eɓe ɓana ɓɛ, na manzabi mɛ, phɔ ya nkombo ya nga, amozwa mbolo mɛ mbala munkama, amba na zwa ɓomɔɔ pha ɓoɓɛlɛ. ");
INSERT INTO loq_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ɓato ɓaikye ɓaali lɔlɔ eye o ɓoo, ɓamobutwa o sima. Kasi ɓaali lɔlɔ o sima ɓamobutwa o ɓoo.» ");
INSERT INTO loq_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","«Okyemela yaamokyela Ŋwaphongo o ɓokonzi pha ikolo, ya moɓa ndokolo moto mɔnɔmɔ ootɔkɔsi na mumbengu phɔ ya ikyɛ luka ɓato ɓa imokyelela etoma o inzabi sɛ sa vinyɔ. ");
INSERT INTO loq_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Aesi ya okana na ɓɛ́ɛ oɓokye: Ɓamozwa mbano ya eɓende yɔnɔyɔ ya ɓaphalanga ɓoophute ɓɛ́ɛ phɔ ya mokɔlɔ mɔnɔmɔ ŋwa etoma, amba ya ɓatoma o inzabi sɛ sa vinyɔ. ");
INSERT INTO loq_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","O ngonga ya ibuwa ya mumbengu, akuli ya tɔkɔlɔ, akyɛ zwa ɓato ɓasuu ɓazasi o munsɔngɔ sa etoma ya ikyela, ");
INSERT INTO loq_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","amba ya wɔ na ɓɛ́ɛ yokye: “Na ɓɛ̀ɛ kyɛ kyela o inzabi sa nga. Namoephɛ mbano eekokyi.” ");
INSERT INTO loq_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Na ɓɛ́ɛ ɓamba ya kyɛndɛ. Wa koma bunya o moto, na wa ngonga eya iyato ya nkɔkɔlɔ, akulaka kyela nde ɓomɔ. ");
INSERT INTO loq_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","O ngonga ya itano eya nkɔkɔlɔ, akuli tɔkɔlɔ akyɛ zwa ɓato ɓasuu ɓazasi o munsɔngɔ. Amba ya ɓatuna yokye: “Phɔ ya'ye ozasi wawa nzanga mobimba sakyela etoma?” ");
INSERT INTO loq_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ɓɛ́ɛ ɓamba ya mobuyisa ɓɛkye: “Moto wa ilokpa o etoma tali.” Amba ya ɓabuyisa yokye: “Ɓɛ kyɛ kyela o inzabi sa nga.”» ");
INSERT INTO loq_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","«Waatata iyinda bunya, mokolo inzabi aesi ya wɔ na kapita yokye: “Ɓanga ɓato ɓaetoma ɓasɔ, oɓaphute. Tata na ɓaakpakyi nga sima, oombe ɓomela na ɓaakpakyi nga o ɓoo.” ");
INSERT INTO loq_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ɓato ɓaatataka ikyela etoma o ngonga eya itano ya nkɔkɔlɔ, ɓaesi ya zwa moto na moto eɓende yɔnɔyɔ ya ɓaphalanga eekokyi na iphuti sa mokɔlɔ mobimba. ");
INSERT INTO loq_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Waakoma imbɛlɛ sa ɓatataka ikyela etoma, ɓaumunyaka oɓokye ɓamozwa ɓaphalanga ileka ɓɛbi. Kasi ɓaɓaphɛkyɛ nde eɓende yɔnɔyɔ ya ɓaphalanga ekokyi na mokɔlɔ mobimba. ");
INSERT INTO loq_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Waakpa ɓɛ́ɛ ɓaphalanga, ɓabuto imiima na mokolo inzabi. ");
INSERT INTO loq_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ɓamba ya wɔ nɛ ɓɛkye: “Ɓato ɓaetoma ɓaasukakyi wɛ ipka ɓakyesi etoma nde ngonga yɔnɔyɔ, o ɓaphuti na ɓanga nde ndengye yɔnɔyɔ. Kasi ɓanga tokyesi etoma mokɔlɔ mobimba, tophɛmbi na ná moo mokusi!” ");
INSERT INTO loq_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Kasi mokolo inzabi amba ya buyisa mɔnɔmɔ na ɓɛ́ɛ yokye: “Nwɛbi na nga, siikyi ekyela ɓoɓe, tolookanakyi nga na wɛ na eɓende yɔnɔyɔ ya ɓaphalanga phɔ ya mokɔlɔ mobimba? ");
INSERT INTO loq_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kpa ɓaphalanga ɓa wɛ, kyɛndɛ. Na zingye iphuta okpakyi nga sima ɓoephuti nga. ");
INSERT INTO loq_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ya ɓo'ye! Eli ɓaphalanga ɓa nga, sikokyi ikyela na ɓɛ́ɛ ɓoozingyi nga? Ookyi zuwa phɔ nali moto molaa?” ");
INSERT INTO loq_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yango mɛna, Yesu amba ya sukya ɓoɓo: Ɓato ɓaali o sima ɓamobutwa o ɓoo, kasi ɓali o ɓoo ɓamobutwa o sima.» ");
INSERT INTO loq_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Waaɓa Yesu kakyendɛ o Yelusalɛmɛ, o nzela, amba ya wɔ na ɓaekosi iko mbuka ɓaɓale yokye: ");
INSERT INTO loq_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Okyemela, uŋwaŋwa eye, tokyɛndɛ o Yelusalɛmɛ, omɔ, nga Ŋwana wa Moto, ɓamunzambya oka ɓakonzi ɓa ɓanganga ɓa Ŋwaphongo, na ɓateye ɓa Miɓeko, ɓamuntenela ɓolombe pha iwaa. ");
INSERT INTO loq_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ɓamba na nzambya oka ɓato ɓaateɓali Bayuda, ɓamunzakya, ɓamumbinda phimbo, ɓaamba na mbaka o ekulusu. Kasi sima ya nkɔlɔ iyato namokundwa.» ");
INSERT INTO loq_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ɓoɓɛlɛ, ŋwaŋwasi wa Zebede aesi ooli Yesu na ɓana ɓɛ̀ɛ ɓaɓale ɓa ɓampele, amba ya kusama o ɓoo phɛ, phɔ ya imonga lowɔɔ lonɔlɔ. ");
INSERT INTO loq_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesu amba ya motuna yokye: «Kozingye'ye?» Ŋwaŋwasi wa Zebede amba mobuyisa yokye: «Indakyele oɓokye o ɓokonzi pha wɛ, ɓana ɓanga ɓa ɓampele ɓaɓa ɓamozala mɔnɔmɔ o ɓoloo pha wɛ, omoyɔkɔ o ɓowɛɛ pha wɛ.» ");
INSERT INTO loq_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesu amba ya buya yokye: «Toeɓe lowɔ loongye ɓɛ̀ɛ. Ɓɛ̀ɛ okokyi inywa kɔphɔ ya ɓolɔsi eya munywa nga?» Ɓamba mobuyisa ɓɛkye: «Tokokyi.» ");
INSERT INTO loq_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Emba Yesu amba ya wɔ na ɓɛ́ɛ yokye: «Eli phɛlɛ, kɔphɔ eyamunywa nga na ɓɛ̀ɛ wa moenyŋwa mɛ. Kasi iyɔlɔ moto owa mozala o ɓoloo naa o ɓowɛɛ pha nga tekyekyi nga, phɔ Tata aunva ɓɔngya bilele ɓaabina phɔ ya ɓato ɓaɔlɔ yo.» ");
INSERT INTO loq_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Waoka ɓaekosi iko ɓayɔkɔ lowɔ mɛ, ɓaokyelaka ɓola na mosi yɔɔ. ");
INSERT INTO loq_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Emɓa Yesu amba ya ɓaɓanga ɓɛ́ɛ ɓasɔ wali yo, amba ya wɔ na ɓɛ́ɛ yokye: «Koeɓe oɓokye ɓakonzi ɓa nkyisi, ɓakonza ɓato ɓa ɓɛ, na ɓato ɓaanɛnɛ ɓawɛninya ɓato ɓa ɓɛ́ɛ mpasi. ");
INSERT INTO loq_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Nzuka onte ya ɓɛ̀ɛ, yango saɓa ɓaɓona. Ɓo mɔnɔmɔ na ɓɛ̀ɛ kalukye imibuya moto munɛnɛ, esengyesi oɓokye aɓe moto wa etoma wa ɓɛ̀ɛ. ");
INSERT INTO loq_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Nde ɓomɔ, ɓo mɔnɔmɔ na ɓɛ̀ɛ kazingye iɓa o ɓoo, esengyesi oɓokye aɓe moombo ŋwa ɓɛ̀ɛ. ");
INSERT INTO loq_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Phɔ nga Ŋwana wa Moto siika yaa phɔ ɓato ɓankyelele, kasi na yaa nde oɓokye naɓakyelele, nambe naambya ɓomɔɔ pha nga phɔ yaiikola ɓato ɓaikye o ɓoombo.» ");
INSERT INTO loq_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Waatɔkɔlɔ ɓɛ́ɛ o Yeliko, ɓato ɓaikye ɓamba ya ɓenga Yesu. ");
INSERT INTO loq_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ɓato ɓaɓale ɓaaphɔlɔ miyo ɓazalaka o mbale ya nzela, waoka ɓɛ́ɛ oɓokye Yesu kalekane, ɓamba tata iyaaŋwana ɓɛkye: «Nkolo, Ŋwana wa Davidi, olookyele ngɔngɔ!» ");
INSERT INTO loq_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ɓato ɓaikye ɓaphaphalaka na ɓɛ, ɓɛkye: «Kanga munɔkɔ!» Kasi ɓɛ́ɛ ɓakulaka aŋwana na ɓokusi ɓɛkye: «Nkolo, Ŋwana wa Davidi, olookyele ngɔngɔ.» ");
INSERT INTO loq_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesu amba ya tɛmɛ, aesi ya ɓaɓanga, amba ya wɔ na ɓɛ́ɛ yokye: «Kozingye oɓokye nakyele'ye phɔ ya ɓɛ̀ɛ?» ");
INSERT INTO loq_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ɓamba ya mobuyisa ɓɛkye: «Nkolo, kyela oɓokye miyo ma ɓanga maingwe.» ");
INSERT INTO loq_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesu amba ɓaokyela ngɔngɔ, amba ya ɓakuma o miyo, nde mina wamɔ, ɓato ɓaɓale mɛ ɓabuto iwɛnɛ, ɓamba butwa iɓenga Yesu. ");
INSERT INTO loq_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesu na ɓaekosi ɓɛ̀ɛ ɓaesi ya koma phɛnɛphɛ na Yelusalɛmɛ. Waakoma ɓɛ́ɛ o Ɓetafaze o ngomba ya Ɓaolive, Yesu amba ya toma ɓaekosi ɓaɓale o ɓoo. ");
INSERT INTO loq_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Amba ya wɔ na ɓɛ́ɛ yokye: «Kyɛndɛ o mokyisi mooli o ɓoo, ɓo okomi omɔ, wamowɛnɛ eɓɛmbɛ ya mpunda ɓaetingye na ŋwana wa yango. Omaingole, oye na mango wawa. ");
INSERT INTO loq_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Kasi ɓo moto aetuni, ɓɛ̀ɛ omobuyisaka oɓokye: “Nkolo asengyesi na mango.” Amokula ebuyisa mango izele.» ");
INSERT INTO loq_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Maphɔɔ maamana makyelamaka phɔ ya ikokya maphɔɔ mawɔkɔ moimosi wa Ŋwaphongo oɓokye: ");
INSERT INTO loq_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«Wɔ na ŋwana wa ŋwaŋwasi wa Siona oɓokye: Kyeka mokonzi ŋwa wɛ kaye. Kaye na ɓonyilɛ, abaa o ikolo sa mpunda na sa ŋwana wa mpunda.» ");
INSERT INTO loq_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ɓaekosi ɓamba ya kyɛndɛ, ɓakyɛkyela nde ɓo wa wɔkɔ Yesu na ɓɛ. ");
INSERT INTO loq_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ɓamba yaa na mpunda na ŋwana wa yango, ɓawalaka bitobu ɓa ɓɛ́ɛ o ikolo sa mango, Yesu amba ya zala iɓɛ. ");
INSERT INTO loq_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Moluku ŋwa ɓato mwikye ɓaɓaka ɓawale bitobu ɓa ɓɛ́ɛ o nzela, ɓaayɔkɔ ɓatenaka nkanga, ɓailangyaka o nzela. ");
INSERT INTO loq_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ɓato ɓaatambulaka o ɓoo pha Yesu na ɓaamoɓengaka o sima, ɓaɓaka ɓaaŋwane ɓɛkye: «Nkyɛmɔ na Ŋwana wa Davidi! Ookoye na nkombo ya Nkolo apambolame! Nkyɛmɔ o bilele biilekyi ikolo!» ");
INSERT INTO loq_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Waanyɔlɔ Yesu o Yelusalɛmɛ, mokyisi munsɔ ŋwanyinganaka, ɓato ɓamba tunana ɓɛkye: «Moto oyo kane ɓaa nza?» ");
INSERT INTO loq_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ɓato ɓaayakaka na Yesu ɓamba buya ɓɛkye: «Eli Yesu moimosi wa Nazalɛtɛ o Galileya.» ");
INSERT INTO loq_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu aesi ya nyɔlɔ o Tɛmpelo, atati iwiinya ɓaungye na ɓaoombi ɓa mbolo omɔ, amba ya bumbya ɓa mesa ma ɓaendinye ɓa ɓaphalanga. Akuli na bumbya biziye ɓa ɓato ɓaungya makoto-ŋwenya. ");
INSERT INTO loq_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Amba ya wɔ na ɓɛ́ɛ yokye: «O buku pha Ŋwaphongo wakomama ɓoɓo: “Ɓamoɓanga ingambi sa nga, ingambi sa losambo.” Amba kula ɓakya yokye: Ɓɛ̀ɛ osibuye elele ya ɓaibi.» ");
INSERT INTO loq_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ɓato ɓaaphɔlɔ miyo na ɓaaɔtɔnɔ makolo ɓamba yaa oli Yesu, amba ɓabikya. ");
INSERT INTO loq_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ɓakonzi ɓa ɓanganga ɓa Ŋwaphongo na ɓateye ɓa Miɓeko ɓaokaka yɔɔ, wawɛnɛ ɓɛ́ɛ bilekyesako ɓiakyelaka Yesu na ɓana ɓaaɓaka ɓaaŋwane o Tɛmpelo oɓokye: «Nkyɛmɔ na Ŋwana wa Dawidi!» ");
INSERT INTO loq_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Emba ɓamba ya wɔ na Yesu ɓɛkye: «Kookye maphɔɔ maawɔ ɓɛ?» Yesu amba ya ɓabuyisa yokye: «Ɛɛ, naokye. Ɓɛ̀ɛ naino totangyi o buku pha Ŋwaphongo? Ɓo wakoma ɓɛ́ɛ ɓoɓo: “Oteye ɓana ɓakyɛɛ na ɓaanywangye ndengye eekokyi ɓɛ́ɛ iekumbela?”» ");
INSERT INTO loq_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ɓoɓɛlɛ, aikyi ɓaika, atɔkɔsi o Yelusalɛmɛ akyɛ milangya o Ɓetani. ");
INSERT INTO loq_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Mokɔlɔ ŋwa sima, waaɓa Yesu kakule butwa o Yelusalɛmɛ, aesi ya oka nzala. ");
INSERT INTO loq_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Amba ya wɛnɛ ŋwete mɔnɔmɔ ŋwa fige imbale ya nzela, amba susana phɛnɛphɛ na ŋwango, akyɛ zwa nde maakyi na maakyi. Amba ya wɔ na ŋwete mɛ yokye: «Otokule ɓota mbuma!» Nde o sina imɓɛlɛ mɛ, ŋwete ŋwa fige moungyi. ");
INSERT INTO loq_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Waawɛnɛ ɓaekosi ɓaɓona, ɓamba kamwa na ɓoikye. Ɓamba ya tuna Yesu ɓɛkye: «Phɔ ya'ye ŋwete mumu moungyi na mbala yɔnɔyɔ ɓoɓo?» ");
INSERT INTO loq_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesu amba ya ɓabuyisa yokye: «Nde phɛlɛ na wɔ na ɓɛ̀ɛ ngakye: Ɓooli phɛlɛ na ianola, ɓo toikyi ziko, okokyi ikyela maphɔɔ maakyesi nga na ŋwete ŋwa fige. Okokyi na iwɔ na ngomba eye oɓokye: Mana wawa, kyɛndɛ kyɛ mivaka o ebale enɛnɛ! Wamokyelama. ");
INSERT INTO loq_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ekpele esɔ eya moonga ɓɛ̀ɛ na iɓɔndɛlɛ, ɓo oanosi oɓokye wa moezwa, waamba na ezwa.» ");
INSERT INTO loq_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu aesi ya nyɔlɔ o Tempelo, atati iteya ɓato. Ɓakonzi ɓa ɓanganga ɓa Ŋwaphongo na ɓankumu ɓa ɓato, ɓamba ya susana oli yo, ɓamba ya motuna ɓɛkye: «Kokyele maphɔɔ mama na ɓokonzi'ye? Oephɛ ɓokonzi pha ikyela maphɔɔ mɛ nza?» ");
INSERT INTO loq_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesu amba ya ɓabuyisa yokye: «Na nga, naetune nde motuna mɔnɔmɔ. Ɓo ombuyise eyano, emba na moeyimola na ɓokonzi ye ɓokyele na nga maphɔɔ mamana. ");
INSERT INTO loq_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Owa tomaka Yoane iɓatisa ɓato nza? Ya motomaka Ŋwaphongo ndee ɓato?» Kasi ɓɛ́ɛ ɓabutwaka iwɔnɔ ɓɛ́ɛ na ɓɛ́ɛ ɓɛkye: «Ɓo tobuye oɓokye yamotomaka Ŋwaphongo, amokula lotuna yokye: Toikaka anola Yoane phɔ ya'ye? ");
INSERT INTO loq_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ɓo toonimobuyisa oɓokye: Ya motomaka ɓato, toile tɔkɔ na ɓato, phɔ ɓato ɓasɔ ɓaanolaka oɓokye Yoane ali nde owa kolo moimosi wa Ŋwaphongo.» ");
INSERT INTO loq_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Yango mɛna, ɓamba mobuyisela ɓɛkye: «Toloeɓe.» Emba Yesu amba ya wɔ na ɓɛ́ɛ yokye: «Na nga mɛ esieyimole naa nakyele maphɔɔ mama na ɓokonzi pha nza.» ");
INSERT INTO loq_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesu amba kula ya wɔ yokye: «Ɓɛɛ koumunya ɓo phɔ ya maphɔɔ mama? Moto mɔnɔmɔ aɓaka na ɓana ɓa ɓampele ɓaɓale, aesi ya ɓanga owa ɓola, amba ya wɔ nɛ yokye: “Ŋwana wa nga, lɔlɔ kyɛndɛ kyɛ kyela o inzabi sa vinyɔ.” ");
INSERT INTO loq_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ŋwana amba ya buya yokye: “Nalɛ, esiikyɛndɛ.” Kasi o sima aumunye, aesi ya kyɛndɛ o inzabi sa vinyɔ. ");
INSERT INTO loq_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Akulaka wɔ na owa iɓale nde ɓomɔ. Owa iɓale amba buya yokye: “Ɛɛ Tata, na mokyɛndɛ.” Kasi taika kyɛndɛ. ");
INSERT INTO loq_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Onte ya ɓana ɓaɓale ɓaaɓana, okyesi maphɔɔ maazingye ango wa ɓɛ́ɛ nza?» Ɓamba ya mobuyisa ɓɛkye: «Ŋwana owa ɓoo.» Emba Yesu amba ya wɔ na ɓɛ́ɛ yokye: «Nde phɛlɛ na wɔ na ɓɛ̀ɛ ngakye: Ɓaphutise ɓa mputi na mandumba, ɓamunyɔlɔ o ɓokonzi pha Ŋwaphongo o ɓoo pha ɓɛ̀ɛ. ");
INSERT INTO loq_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Phɔ, Yoane Moɓatise ayakaka yaeteya nzela elaa, kasi ɓɛ̀ɛ toikaka moanola. Kasi ɓaphutise ɓa mputi, eɓe na mandumba ɓa moanoleleka, ka ɓɛ̀ɛ na ɓo wawɛnɛkyɛ ɓɛ̀ɛ ɓaɓona, toika ɓongola mandondo phɔ ya imoanola.» ");
INSERT INTO loq_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","«Okyemela ete esuu. Moto mɔnɔmɔ aɓalaka inzabi sa vinyɔ, aesi ya silungya na kyengyete. Amba ya tima iɓela o maɓanga phɔ ya ikyela isungu sa iyamola mbuma ya vinyɔ. Atongaka na ingambi sɔnɔsɔ o ngomba phɔ ya moto okokyɛngyɛlɛ sina inzabi. Sima, amba ika siikyela ɓato oɓokye ɓasiphutele, yo akyɛ o imbanga. ");
INSERT INTO loq_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Waakoma imbɛlɛ sa inɔkɔ mbuma, mokolo inzabi aesi ya toma ɓato ɓaetoma ɓɛ́ɛ oka ɓato ɓaaphutele inzabi oɓokye ɓakyɛ mokpela iyalo saaka yɛ. ");
INSERT INTO loq_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Kasi ɓaaphutele inzabi ɓaakye ɓasali mɛ, ɓakutubi mɔnɔmɔ, ɓaɓomi oomoyɔkɔ, owa iyato ɓamoɓomi na maɓanga. ");
INSERT INTO loq_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Emba mokolo inzabi amba kula toma ɓato ɓasuu ɓaikye ileka ɓaaphanza, kasi ɓaaphutele inzabi ɓakulaka ɓakyela nde ɓomɔ. ");
INSERT INTO loq_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","O sima ya ɓɛ́ɛ ɓasɔ, amba ya ɓatomela ŋwana wɛ mɔnɔmɔ. Aumunyaka oɓokye: “Ɓamokumola ŋwana wa nga.” ");
INSERT INTO loq_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Kasi waamowɛnɛ ɓaaphutele inzabi, ɓawɔnɔkɔ onte ya ɓɛ̀ɛ ɓɛkye: “Kyeka sɔmi yɛ, owa moikala na sina inzabi ɓo ango awe! Yaka tomoɓome, inzambi mɛ samobutwa sa ɓanga.” ");
INSERT INTO loq_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ɓaesi ya moakya, ɓamovakyi o sɛlɛkyɛ ya inzambi, ɓamoɓomi.» ");
INSERT INTO loq_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yesu amba ya ɓatuna yokye: «Emba waamoya mokolo ŋwa inzambi, amokyela ye phɔ ya ɓasali ɓaɓana?» ");
INSERT INTO loq_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ɓamba ya mobuyisa ɓɛkye: «Etaɓaokye ngɔngɔ. Aaɓaɓoma ɓɛ́ɛ ɓasɔ, aamba phɛ inzambi oka ɓaphutesi ɓasuu. Emba ɓato mɛ ɓamoɓaka ɓamophɛ mbuma o imbɛlɛ siikokyi.» ");
INSERT INTO loq_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Emba Yesu amba ya wɔ na ɓɛ́ɛ yokye: «Ɓɛɛ toika tanga maphɔɔ mama o Buku pha Ŋwaphongo? Ɓakoma ɓoɓo: “Iɓanga saavakaka ɓatongyi ɓa mangambi, sibuto iɓanga siiphisi ingambi sisɔ. Mɛna etoma ya Nkolo. O miyo ma ɓanga eli lowɔ la ikamwa!”» ");
INSERT INTO loq_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Yesu amba kula ya ɓakya yokye: «Yango mɛna, na wɔ na ɓɛ̀ɛ ngakye: Ɓamoeɓɔlɔlɔ ɓokonzi pha Ŋwaphongo, ɓaamba ɓophɛ ɓato ɓasuu, ɓɛ́ɛ ɓaaɓokyelela etoma elaa.  ");
INSERT INTO loq_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Owa mokaa o ikolo sa sina iɓanga, amokyɛ mitenya ɓinango, kasi ɓo iɓanga mɛ sikaa o ikolo sa moto mɔnɔmɔ, saamowɔlingyinya.» ");
INSERT INTO loq_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ɓakonzi ɓa ɓanganga ɓa Ŋwaphongo na ɓateye ɓa Miɓeko ɓaaokyi bite biɓale mɛ, ɓaeɓaka oɓokye, Yesu kawɔ phɔ ya ɓɛ. ");
INSERT INTO loq_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Emba ɓamba tata iluka malondo ma imwakya, kasi ɓa ilaka ɓato, phɔ ɓato ɓaɓaka ɓakpe Yesu ndokolo moimosi wa Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu akulaka wɔlɛ ɓato ɓaamookye na bite bisuu yokye: ");
INSERT INTO loq_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Kyeka ɓo wamolekana maphɔɔ o Ɓokonzi pha ikolo. Ya moɓa ndokolo mokonzi mɔnɔmɔ akyesi esɛlɛkɔ ya ɓolonga pha ŋwana wɛ. ");
INSERT INTO loq_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Atomi ɓato ɓa etoma ɓɛ́ɛ oɓokye ɓakyɛ oka ɓato ɓaaɓangaka yo, phɔ ɓaye o esɛlɛkɔ, kasi ɓɛ́ɛ ɓasɔ ɓalɛ iyaa. ");
INSERT INTO loq_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Akulaka toma ɓato ɓa etoma ɓasuu, amba ya wɔ na ɓɛ́ɛ oɓokye ɓakyɛndɛ wɔ na ɓato ɓaaɓangaka yo ɓoɓo: “Naumbo ɓɔngya mbolo isɔ, naɓomi ngombɛ ya nga, na manyama maaisa. Yaka o esɛlɛkɔ ya ɓolonga.” ");
INSERT INTO loq_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Kasi ɓɛ́ɛ ɓasɔ ɓawɛni lowɔɔ mɛ nde pha, mɔnɔmɔ na mɔnɔmɔ akyɛ o etoma yɛ, omoyɔkɔ akyɛ o manzabi, ona akyɛ kyela mumbongu. ");
INSERT INTO loq_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ɓaayɔkɔ ɓaakye ɓato ɓa etoma ɓaɓana, ɓa ɓanyɔkɔsi, ɓa ɓaɓomi. ");
INSERT INTO loq_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Mokonzi aokyi yɔɔ, amba toma ɓatuluku ɓɛ, phɔ ɓakyɛ ɓoma ɓaɓomi ɓaɓana, ɓatumbe na mokyisi ŋwa ɓɛ. ");
INSERT INTO loq_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Sima amba ya wɔ na ɓato ɓa etoma ɓɛ́ɛ yokye: “Na ɓɔngyakyi esɛlɛkɔ na ɓolaa, kasi ɓato ɓaaɓangakyi nga teɓaikyi ya zaa. ");
INSERT INTO loq_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Kyɛndɛ o nsɔngɔ isɔ inɛnɛ, oɓangye ɓato ɓaamowɛnɛ ɓɛ, phɔ ɓaye o esɛlɛkɔ.” ");
INSERT INTO loq_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ɓato ɓa etoma ɓaesi ya kyɛndɛ o nsɔngɔ ɓamba yaa na ɓato ɓasɔ ɓaakyɛkyɛ zwa ɓɛ́ɛ omɔ, eɓe ɓato ɓalaa, na ɓato ɓaaɓe, nɔnɔ watondaka ingambi sa esɛlɛkɔ.» ");
INSERT INTO loq_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","«Waanyɔlɔ mokonzi ikyɛ kyeka ɓato ɓaaɓangaka yo, akyɛ wɛnɛ moto mɔnɔmɔ taikaka lata etobu ya esɛlɛkɔ. ");
INSERT INTO loq_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Emba, amba ya motuna yokye: “Iwɛ onyɔsi wawa ndengye'ye? Toikyi lata etobu ya esɛlɛkɔ.” Kasi moto mɛ taikaka zwa lowɔɔ la ibuya. ");
INSERT INTO loq_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ɓoɓɛlɛ mokonzi amba ya toma ɓato ɓa etoma ɓɛ́ɛ yokye: “Omokangye maɓɔkɔ na makolo, omovakye o iɓanda o enzɔmbi amokyɛ lela, amokyɛ twa mino.” ");
INSERT INTO loq_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yesu amba ya sukya ɓoɓo: “Nde phɛlɛ, ɓato ɓaikye ɓaɓangama, kasi ɓaaɔlɔ ɓɛ́ɛ ɓali ɓa itanga.”» ");
INSERT INTO loq_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ɓafalisayi ɓakyɛkyɛ angana ikyita phɔ ya iluka malondo maiyakya Yesu na maloɓa mɛ mampenza. ");
INSERT INTO loq_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ɓatomaka ɓaekosi ɓa ɓɛ́ɛ ɓasuu na ɓato ɓa Elode phɔ ɓakyɛ tuna Yesu oɓokye: «Moteye, toeɓe oɓokye iwɛ kowɔ nde phɛlɛ, toile na moto, iwɛ tookyekye na ngambo ya moto, kasi koteya nde phɛlɛ ikyiongye Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Oloimole, koumunya ɓo, moɓeko ŋwa ɓanga ŋwambya nzela ya iphuta mputi ya mokonzi ŋwa Loma nde phe?» ");
INSERT INTO loq_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Kasi Yesu aeɓaka malondo ma ɓɛ́ɛ maaɓe. Amba ya wɔ na ɓɛ́ɛ yokye: «Ɓanyamaɓɔlɛ. Phɔ ya'ye komekye? ");
INSERT INTO loq_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Taateya ɓaphalanga ɓaphute na ɓɛ́ɛ mputi.» Ɓamba moteya eɓende ya ɓaphalanga yɔnɔyɔ. ");
INSERT INTO loq_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Emba Yesu amba ya ɓatuna yokye: «Ɓoo ɓoɓo na nkombo eyakoma ɓɛ́ɛ wawa ili ya nza?» ");
INSERT INTO loq_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ɓamba ya moɓuyisa ɓɛkye: «Ya mokonzi oo munɛnɛ wa Loma.» Emba Yesu amba ya wɔ na ɓɛ́ɛ yokye: «Yaaka mokonzi ŋwa Loma, oiphɛ mokonzi ŋwa Loma, yaaka Ŋwaphongo, oiphɛ Ŋwaphongo.» ");
INSERT INTO loq_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Waaoka ɓɛ́ɛ ɓaɓona, ɓakamwaka na ɓoikye, ɓaikyi mwika ɓakyɛ. ");
INSERT INTO loq_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Nde o muna mokɔlɔ mɛ, Ɓasadukayi ɓaesi waali Yesu. Eli ɓɛ̀ɛ ɓato ɓawɔ oɓokye, ɓato ɓaawaa ete ɓaakundwe. ");
INSERT INTO loq_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ɓamba motuna ɓɛkye: «Moteye, Mose awɔkɔ yokye: “Ɓo moto awe taikyi ɓota ɓana, ŋwana nyango na mowe asengyesi ilonga ɓozengye mɛ, phɔ aɓotele ŋwana nyango ɓana.” ");
INSERT INTO loq_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Oka ɓanga, yaɓaka ɓampele sambo, ɓɛ́ɛ ɓasɔ nyango mɔnɔmɔ, ango mɔnɔmɔ. Ŋwana owa ɓola alongyi ŋwaŋwasi, awe taikyi ɓota na ŋwaŋwasi ɓana, aikyi ɓozengye mɛ na ŋwana nyango. ");
INSERT INTO loq_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Wakyelamaka nde ɓomɔ na owa iɓale na owa iyato, tee nɔnɔ owa sambo. ");
INSERT INTO loq_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","O sima ya ɓɛ́ɛ ɓasɔ, ŋwaŋwasi mɛ aesi ya waa mɛ. ");
INSERT INTO loq_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Emba mokɔlɔ ŋwa mokundwa ɓawe, ŋwaŋwasi mɛ amoɓa wa nza? Phɔ ɓɛ́ɛ ɓasɔ ɓamolongaka.» ");
INSERT INTO loq_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesu amba ya ɓa ɓuyisa yokye: «Ɓɛ omikose, phɔ toeɓe na maphɔɔ maali o buku pha Ŋwaphongo, toeɓe na ɓokusi phɛ. ");
INSERT INTO loq_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Phɔ waamokundwa ɓawe, malonga ete makule ɓaa, ɓa ɓasi na ɓampele ɓamoɓa ndokolo ɓaanzelu ɓa ikolo. ");
INSERT INTO loq_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Kasi phɔ ya lowɔ lokyekyi ikundwa sa ɓawe, toika tanga ɓo wawɔkɔ Ŋwaphongo na ɓɛ? ");
INSERT INTO loq_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Awɔ ɓoɓo: “Nali Ŋwaphongo wa Abalayama, wa Izake na wa Yakoɓo.” Yo tali Ŋwaphongo wa ɓawe kasi ali Ŋwaphongo wa ɓato ɓali na ɓomɔ.» ");
INSERT INTO loq_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ɓato ɓasɔ ɓaamokaka, ɓakamwaka na mateya mɛ. ");
INSERT INTO loq_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Wa oka Ɓafalisayi oɓokye Yesu asukise Ɓasadukayi, ɓamba ya angana waali yo. ");
INSERT INTO loq_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Mɔnɔmɔ onte ya ɓɛ̀ɛ aɓaka moteye ŋwa miɓeko, alukaka malondo ma imeka Yesu, amba ya motuna yokye: ");
INSERT INTO loq_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Moteye, onte ya Miɓeko misɔ ma Ŋwaphongo, moɓeko'ye molekyi miyɔkɔ?» ");
INSERT INTO loq_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesu amba mobuyisa yokye: «Osengyesi izinga Nkolo Ŋwaphongo wa wɛ na ndondo yɔnɔyɔ, na molimo ŋwa wɛ musɔ na ná maumunya ma wɛ masɔ. ");
INSERT INTO loq_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Mɛna eli moɓeko ŋwaa ɓoo, na moolekyi ɓonɛnɛ. ");
INSERT INTO loq_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Moɓeko ŋwa iɓale mookokaa na ŋwa ɓoo, nwɛ mumu: Osengyesi izinga nwɛbi na wɛ, ɓooko mizingye wɛ mampenza. ");
INSERT INTO loq_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Miɓeko ma Mose na mateya ma ɓaimosi ɓa Ŋwaphongo mali nde onte ya miɓeko miɓale mamina.» ");
INSERT INTO loq_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ɓafalisayi ɓaanganaka elele yɔnɔyɔ, Yesu amba ya ɓatuna motuna mumu: ");
INSERT INTO loq_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«Ɓɛɛ koumunya ɓo phɔ ya Masiya? Iyo ali ŋwana wa nza?» Ɓamba ya mobuyisa ɓɛkye: «Ali ŋwana wa Davidi.» ");
INSERT INTO loq_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesu amba ya wɔ na ɓɛ́ɛ yokye: «Ndengye'ye Davidi wakambemaka yo na Bolɔɓɔ, amoɓangaka “Nkolo?” Waawɔ yo oɓokye: ");
INSERT INTO loq_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Nkolo Ŋwaphongo awɔ na Nkolo wa nga yokye: Yaka ya zale o ɓoloo pha nga tee nɔnɔ waamouya nga ɓanguna ɓa wɛ o se ya makolo ma wɛ.” ");
INSERT INTO loq_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ɓo Davidi amoɓangaka “Nkolo”, ka ndengye'ye Masiya akokyi ikula ɓaa ŋwana wa Davidi?» ");
INSERT INTO loq_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Mɔnɔmɔ na ɓɛ́ɛ takokaka na imobuyisa na lowɔɔ lɔnɔlɔ, tata mokɔlɔ mɛ, moto takulaka meka na imotuna na mituna. ");
INSERT INTO loq_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Emba, Yesu amba ya wɔ na ɓato ɓasɔ na ná ɓaekosi ɓɛ́ɛ yokye: ");
INSERT INTO loq_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«Ɓateye ɓa Mibeko na Ɓafalisayi, etoma ya ɓɛ́ɛ nde ilimbolela ɓato Mibeko ma Mose. ");
INSERT INTO loq_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ɓɛ̀ɛ osengyesi ikumola na ikyela isɔ yaamowɔ ɓɛ́ɛ na ɓɛ̀ɛ kasi ɓɛ̀ɛ samekola moɓesi ŋwa ɓɛ, phɔ teɓaakyelele iikyiteya ɓɛ. ");
INSERT INTO loq_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ɓakangye biphesi bizito bili na nkamba phɔ ya ibinyanya, ɓaambe biphisa ɓato o maɓɛkyɛ, kasi ɓɛ́ɛ mampenza teɓaabikume nɔnɔ na munsɛɛ. ");
INSERT INTO loq_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Bitoma bisɔ biikyele ɓɛ, ɓalukye nde oɓokye ɓato ɓa ɓawɛnɛ. Bitee ɓa nkanda ya Ŋwaphongo bilate ɓato o imɓɛlɛ si sambele ɓɛ, ɓɛ́ɛ ɓa bibuya binɛnɛ mpenza, ɓambe na ɓamba ma sɔngya manɛnɛ ma nkoto ya ɓɛ. ");
INSERT INTO loq_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ɓazingye bilele ɓa ngambo o bisɛlɛkɔ, na biziye ɓa o ɓoo o mangambi ma makyita. ");
INSERT INTO loq_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ɓazingye ɓato ɓaɓaɓeyakye o bilele ɓiangane ɓato ɓaikye, ɓaambakye na ɓaɓanga “ɓateye.” ");
INSERT INTO loq_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Kasi ɓɛ̀ɛ, sazingaka oɓokye ɓaeɓangye “moteye”, phɔ ɓɛ̀ɛ ɓasɔ oli nde ɓaekosi, oli nde na Moteye mɔnɔmɔ. ");
INSERT INTO loq_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","O munse mumu sa ɓanga moto mɔnɔmɔ “tata”, phɔ oli nde na Ango wa ɓɛ̀ɛ mɔnɔmɔ, oli o ikolo. ");
INSERT INTO loq_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Sazingaka oɓokye ɓato ɓaeɓangakye “mokonzi”, phɔ oli nde na Mokonzi mɔnɔmɔ yo Masiya. ");
INSERT INTO loq_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Moto oelekyi ɓɛ̀ɛ ɓasɔ, amoɓa moto wa ɓɛ̀ɛ wa etoma. ");
INSERT INTO loq_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Moto okomitombe, ɓaamounya, kasi moto ookomiuya, ɓaamotomba.» ");
INSERT INTO loq_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","«Ngɔngɔ ya ɓɛ̀ɛ, ɓateye ɓa Miɓeko na Ɓafalisayi, ɓanyamaɓɔlɛ! Koziɓele ɓato nzela eekokyi na ɓɛ́ɛ inyɔlɔ o ɓokonzi pha ikolo. Ɓɛ̀ɛ mampenza toonyɔlɔ, kombe na katela ɓato ɓaazingye inyɔlɔ.» ");
INSERT INTO loq_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","«Ngɔngɔ ya ɓɛ̀ɛ, ɓateye ɓa Miɓeko na Ɓafalisayi, ɓanyamaɓɔlɛ! Koiyele mazengye na mbolo ya ɓɛ́ɛ isɔ na malondo maɓe phɔ ya iɓomba ɓoɓe pha ɓɛ̀ɛ, kombe buzinya na ma ɓɔndɛsi maanda. Yango mɛna Ŋwaphongo amoephɛ etumbu eya moleka ɓonɛnɛ! ");
INSERT INTO loq_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ngɔngɔ ya ɓɛ̀ɛ, ɓateye ɓa Miɓeko na Ɓafalisayi, ɓanyamaɓɔlɛ! Kokyɛ mikyɛndɛ mambanga mboka esɔ, na yaa mokyisi na yaa ebale phɔ ya iluka moanosi mɔnɔmɔ, ka waamozwe ɓɛ̀ɛ, kokule mobuya moto wa lifelo koleka ɓɛ̀ɛ. ");
INSERT INTO loq_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Ngɔngɔ ya ɓɛ̀ɛ, ɓato ɓaaphɔlɔ miyo ɓaateya ɓato nzela. Phɔ ya ɓɛ̀ɛ kowɔ oɓokye: Ɓo moto akati seleka na nkombo ya Tempelo, seleka mɛ eli pha. Kasi ɓo akati seleka na nkombo ya wolo ekyeɓombe yo o Tempelo, asengyesi ikumola seleka mɛ. ");
INSERT INTO loq_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Bibubusi ɓiɓi, ɓato ɓaaphɔlɔ miyo! Elekyi na ntina eli'ye, itela ndee Tempelo? Itela kabutwe ekpele eya ekyila nde onte ya Tempelo. ");
INSERT INTO loq_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kowɔ na oɓokye: Ɓo moto akati seleka na nkombo ya etumbelo seleka mɛ eli pha. Kasi ɓo akati seleka na nkombo ya ikaɓo sili o ikolo sa etumbelo, asengyesi ikumola seleka mɛ. ");
INSERT INTO loq_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ɓato ɓaaphɔlɔ miyo! Ikaɓo na etumbelo, elekyi iye? Ikaɓo sibutwe ekpele eya ekyila phɔ ɓasikyesi o etumbelo. ");
INSERT INTO loq_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Moto ookokate seleka na nkombo ya etumbelo, aekati phɔ ya etumbelo na phɔ ya mbolo isɔ iili o ikolo sa etumbelo. ");
INSERT INTO loq_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Okokate seleka na nkombo ya Tempelo, aekati na nkombo ya Tempelo na ná nkombo ya Ŋwaphongo okozale omɔ. ");
INSERT INTO loq_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Na okokate seleka na nkombo ya ikolo, aekati na nkombo ya eziye ya Ŋwaphongo, na ya Ŋwaphongo okozale miyango. ");
INSERT INTO loq_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ngɔngɔ ya ɓɛ̀ɛ, ɓateye ɓa Miɓeko na Ɓafalisayi, ɓanyamaɓɔlɛ! Komanyisa Ŋwaphongo iyalo sɔnɔsɔ onte ya maalo iko ma maakyi maa solo elaa. Kasi koɓungye miɓeko miilekyi minɛnɛ ɓooli: Ikyela ɓato ɓolaa, iyokyela ɓato ngɔngɔ, na iɓaa ɓato ɓawɔ phɛlɛ. Mɛna eli maphɔɔ masengyesi ɓɛ̀ɛ ikyela, kasi sa bunga maayɔkɔ. ");
INSERT INTO loq_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ɓato ɓaaphɔlɔ miyo ɓateyee ɓa nzela! Kokonde maleku ma ɓɛ̀ɛ phɔ ya imanya esala omokyikyi, kasi komine shamo oomunɛnɛ! ");
INSERT INTO loq_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Ngɔngɔ ya ɓɛ̀ɛ, ɓateye ɓa Miɓeko na Ɓafalisayi, ɓanyamaɓɔlɛ! Kokunyole ɓa kɔphɔ na ɓalako o ikolo kasi o motema itondi na mbolo ya iiɓa na maphowa maɓe. ");
INSERT INTO loq_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Mofalisayi owa phɔlɔ miyo! Kunyola kɔphɔ o motema phanza emba o iɓanda wamokunywa mɛ. ");
INSERT INTO loq_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ngɔngɔ ya ɓɛ̀ɛ, ɓateye ɓa Miɓeko na Ɓafalisayi, ɓanyamaɓɔlɛ! Waulana na malita mainga ɓɛ́ɛ mumpɛmbɛ, mawɛnɛnɛ malaa o iɓanda, kasi o motema matonda na mpee ya ɓato ɓawaa na ná sɔkɔtɔ ndengye na ndengye. ");
INSERT INTO loq_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Na ɓɛ̀ɛ o iɓanda kowɛnɛnɛ ndokolo ɓato ɓalaa o ɓoo pha Ŋwaphongo. Kasi o motema watonda na ɓɔɔlɛ na ná ɓoɓe. ");
INSERT INTO loq_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Ngɔngɔ ya ɓɛ̀ɛ, ɓateye ɓa Miɓeko na Ɓafalisayi, ɓanyamaɓɔlɛ! Kotongyele ɓaimosi ɓa Ŋwaphongo malita malaa, koɓɔngya na malita ma ɓato ɓa ɓosembo. ");
INSERT INTO loq_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Kombe na wɔ oɓokye: “Ɓato ɓaaɓaka o imbɛlɛ sa ɓankɔkɔ ɓa ɓanga, nde toloangana na ɓɛ́ɛ phɔ ya iɓoma ɓaimosi ɓa Ŋwaphongo.” ");
INSERT INTO loq_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ɓaaɓona, ɓɛ̀ɛ mampenza koanole oɓokye oli ɓankɔkɔ ɓa ɓato ɓaɓomaka ɓaimosi ɓa Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Uŋwaŋwa eye, emba unva etoma eya tataka ɓankɔkɔ ɓa ɓɛ́ɛ ikyela! ");
INSERT INTO loq_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ɓɛ̀ɛ manzɔɔ, ɓoso imɛlɛ! Wa mokyela ndengye'ye phɔ olote etumbu eya lifelo? ");
INSERT INTO loq_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Yango mɛna, okyemela: Na moetomela ɓaimosi ɓa Ŋwaphongo na ɓato ɓaa malondo na ɓateye ɓa Miɓeko ɓaalaa. Kasi wa moɓoma ɓakyi na masɛngu na ná maɓanga, ɓaayɔkɔ wa ɓaɓoma o ikolo sa ekulusu, wa mobinda ɓayɔkɔ na phimbo o mangambi ma makyita ma ɓɛ̀ɛ, wa mokyɛ mi ɓawiinya o nkyisi isɔ iinɛnɛ. ");
INSERT INTO loq_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Yango mɛna, konyanya ngambo ya malongo ma ɓato ɓasɔ ɓa ɓosembo ɓaɓomaka ɓɛ̀ɛ, tata oka Abɛlɛ tee nɔnɔ oka Zakaliya ŋwana wa Balasi, owa ɓomamaka onte ya Tempelo na o etumbelo. ");
INSERT INTO loq_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nde phɛlɛ na wɔ na ɓɛ̀ɛ ngakye: Ɓɛ̀ɛ wa mozwa etumbu phɔ ya maphɔɔ masɔ mamana!» ");
INSERT INTO loq_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","«Yelusalɛmɛ, Yelusalɛmɛ, iwɛ moto ookoɓome ɓaumosi ɓa Ŋwaphongo, koɓome na ɓato ɓaa etomele Ŋwaphongo na maɓanga! Kasi ingaa, mbala na mbala na mekakyi eyeyangyinya wali nga, ɓokoangyinya soo ɓana ɓɛ́ɛ o se ya mapapusa mɛ, kasi ɓɛ̀ɛ toika anola! ");
INSERT INTO loq_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Kyeka, ingambi sa wɛ sa moikala nde phaa. ");
INSERT INTO loq_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Na wɔ na ɓɛ̀ɛ ngakye: Tata nde uŋwaŋwa ye, otokule nvɛnɛ tee nɔnɔ wa mo wɔ ɓɛ̀ɛ oɓokye: “Okoye na nkombo ya Nkolo apambolame.”» ");
INSERT INTO loq_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Waaɓa Yesu katɔlɔ o Tempelo, ɓaekosi ɓɛ́ɛ ɓamba yaa wa li yo, ɓamba ya wɔ ɓɛkye: «Taakyeka ɓowa tonga ɓɛ́ɛ Tempelo eye!» ");
INSERT INTO loq_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Emba Yesu amba ya ɓabuyisa yokye: «Oewɛni yango esɔ te? Nde phɛlɛ na wɔ ɓɛ̀ɛ ngakye: Iɓanga na sɔnɔsɔ etesiikale o ikolo sa siyɔkɔ, masɔ ma munyangwa.» ");
INSERT INTO loq_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ɓoɓɛlɛ Yesu amba ya kyɛ zala o ikolo sa ngomba ya Ɓaolive. Ɓaekosi ɓɛ́ɛ ɓamba yaa ɓɛ́ɛ mampenza waali yo, ɓamba ya motuna ɓɛkye: «Taloimola maphɔɔ maawɔ wɛ, mamokyela imɓɛlɛ ye? Tomba na eɓa na ye, oɓokye imɓɛlɛ sa iyaa sa wɛ na saa suka ya mokyisi sikokyi?» ");
INSERT INTO loq_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesu amba ya ɓabuyisa yokye: «Nde koeɓe, moto sa ekosa. ");
INSERT INTO loq_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Phɔ ɓato ɓaikye ɓamoyaa, na nkombo ya nga, ɓamowɔɔ ɓɛkye: “Inga nali Masiya!” Ɓamokosa ɓato ɓaikye. ");
INSERT INTO loq_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Wamooka oɓokye mabita maeyelele na masimo ma mabita mali bisuu, ɓɛ̀ɛ sa ilaa. Esengyesi oɓokye maphɔɔ mɛ makyelame, kasi mɛna teetaa ɓaa suka ya mokyisi. ");
INSERT INTO loq_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ekolo yɔnɔyɔ ya muŋwana na ekolo eeyɔkɔ, ɓokonzi ɓɔnɔɓɔ pha muŋwana na ɓokonzi ɓooyɔkɔ, zilo sikusi sa moɓaa, na manyɛtɛ mamunyingana bilele biikye. ");
INSERT INTO loq_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Maphɔɔ masɔ mamana ma moɓa ndokolo etatele ya eswɛtɛ ya iɓota. ");
INSERT INTO loq_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Emba, ɓato ɓamotata iyeyungya, phɔ ya iyewɛninya ɓolɔsi na iyeɓoma. Maɓota masɔ ma moeyina phɔ ya nkombo ya nga. ");
INSERT INTO loq_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","O nkɔlɔ mɛ, ɓato ɓaikye ɓamolɛɛ ianola sa ɓɛ, ɓamungyana na iyinana ɓɛ́ɛ na ɓɛ. ");
INSERT INTO loq_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ɓaimosi ɓaɓɔlɛ ɓaikye ɓamotɔkɔlɔ, ɓamokosa ɓato ɓaikye. ");
INSERT INTO loq_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Phɔ ɓoɓe pha moleka o mokyisi, ɓato ete ɓakule zingana. ");
INSERT INTO loq_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Kasi owa moititala nɔnɔ o suka, amobika. ");
INSERT INTO loq_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Simo Elaa ya ɓokonzi pha Ŋwaphongo yamoteyama o munse munsɔ munsɔ, phɔ nkyisi isɔ ɓaeyokye. Emba suka yaamba yaa.» ");
INSERT INTO loq_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«Wamowɛnɛ ookoɓangye ɓɛ̀ɛ mɔɔti owa inganga, ɓo wa wɔ moimosi Daniɛlɛ. Amotɛmɛ o elele esantu. Motangyi wa maphɔɔ mama amasɔsɔlɔ! ");
INSERT INTO loq_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ɓaamoɓaa o Yuda ɓɛ́ɛ elotaka o mangomba. ");
INSERT INTO loq_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Owamoɓaa o iɓanda, yo sakula nyɔlɔ o ingambi ikyɛ kpa mbolo yɛ. ");
INSERT INTO loq_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Na owa moɓa o manzabi, yo sakula butwa o lombo phɔ ya ikyɛ kpa etobu yɛ. ");
INSERT INTO loq_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","O nkɔlɔ mɛ, ngɔngɔ ya moɓaa na ɓaɓasi ɓaaekama na ná malekyele! ");
INSERT INTO loq_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ɓɔndɛlɛ Ŋwaphongo, phɔ mokɔlɔ ŋwa molota ɓɛ̀ɛ, nwɛ sa ɓaa imbɛlɛ sa mambula naa mokɔlɔ ŋwa saɓata! ");
INSERT INTO loq_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Phɔ nkɔlɔ mɛ, yamoɓaa ya malɔsi maikye, mali naino ɓato sa wɛnɛ uta waetatele ya mokyisi ɓowamokyela Ŋwaphongo tee nɔnɔ lɔlɔ eye. Malɔsi mamoulana na mango ete makule na wɛnɛnɛ. ");
INSERT INTO loq_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kasi ɓo Ŋwaphongo tabukolaka nkɔlɔ ya malɔsi mɛ phe, moto na mɔnɔmɔ nde tabikyi. Kasi Ŋwaphongo abukola nkɔlɔ mɛ phɔ ya ɓato ɓaunva yo ɔlɔ. ");
INSERT INTO loq_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","O imɓɛlɛ mɛ, ɓo moto awɔ na ɓɛ̀ɛ yokye: “Kyeka, Masiya ali wawa!” Naa oɓokye: “Ali owo!” Ɓɛ̀ɛ samoanolela. ");
INSERT INTO loq_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Phɔ ɓamasiya ɓaaɓɔlɛ na ɓaimosi ɓaaɓɔlɛ ɓamoya ɓaikye, ɓamokyela bilekyesako binɛnɛ na maphɔɔ ma ikamwa phɔ ya ikosa ɓato ɓaaunva ɔlɔ Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Okyemela! Nambo ekyebisa na maphɔɔ masɔ maamoya. ");
INSERT INTO loq_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Yango mɛna, ɓo ɓawɔ na ɓɛ̀ɛ ɓɛkye: “Kyeka ali o bokye!” Sakyɛndɛ. Na ɓo ɓawɔ na ɓɛ̀ɛ ɓɛkye: “Kyeka, amiɓombi wawa!” Saɓaanolela. ");
INSERT INTO loq_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Phɔ ɓookyele munkakasi o ikolo, uta biitɔkɔlɔ moo na biikyɛ milangya ŋwango, Ŋwana wa Moto amoya nde ɓomɔ. ");
INSERT INTO loq_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Waaɓe eɓembe, biwawanga biikye biangane nde wa mɔ.» ");
INSERT INTO loq_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«Ɓo nkɔlɔ ya malɔsi mɛ yumboo, malɔsi masuu maalekyi mamoya. Moo ŋwa mobutwa enzɔmbi, ɓokombe eteɓokule ngala, ɓanyasɛɛsi ɓamobiya, isɔ iili o ikolo ya munyingana. ");
INSERT INTO loq_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Emba elembo ya Ŋwana wa Moto yamowɛnɛnɛ o ikolo, o imbɛlɛ mɛ, ɓato ɓa nkyisi isɔ iili o munse, ɓaamiima, waamowɛnɛ ɓɛ́ɛ Ŋwana wa Moto iyaa o mampata na mwiya na ná nkyɛmɔ iikye. ");
INSERT INTO loq_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Indulɛ sinɛnɛ samokaa, amotoma ɓanze ɓɛ́ɛ mbɔmbɔ isɔ ya munse, ɓamoangyinya ɓato ɓasɔ ɓaunva yo ɔlɔ.» ");
INSERT INTO loq_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«Sɔsɔlɔ na ɓolaa ete ya ŋwete ŋwa fige. Ɓo molɛɓɔsi, ɓɛ̀ɛ koeɓe oɓokye imbɛlɛ siikyɛtɛ mbuma sikokyi. ");
INSERT INTO loq_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Nde ɓɔmɔ, waamowɛnɛ ɓɛ̀ɛ maphɔɔ masɔ maamana makyelame, wa moeɓa oɓokye iyaa sa Ŋwana wa Moto sikokyi. ");
INSERT INTO loq_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nde phɛlɛ na wɔ na ɓɛ̀ɛ ngakye: Maphɔɔ mama mamokyelama naino ɓato ɓaayɔkɔ ɓali na ɓanga lɔlɔ sataa waa. ");
INSERT INTO loq_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ikolo na munse ya molekana kasi maloɓa ma nga etemalekane.» ");
INSERT INTO loq_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","«Moto na mɔnɔmɔ taaeɓe na mokɔlɔ naa imbɛlɛ saamokyelama maphɔɔ mamana, eɓe na ɓanze o ikolo, eɓe na ona Ŋwana taeɓe. Kyeeɓe nde Tata yo mampenza. ");
INSERT INTO loq_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Mokɔlɔ ŋwaamoyaa Ŋwana wa Moto, maphɔɔ mamokyelama nde ɓo wakyelamaka wɛɛ o imɓɛlɛ saaka Nowa. ");
INSERT INTO loq_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","O ɓoo pha maa izinza mokyisi munsɔ, ɓato ɓaɓaka ɓazee, ɓanywe, ɓalonganaka tee nɔnɔ mokɔlɔ ŋwaanyɔlɔ Nowa o masuwa. ");
INSERT INTO loq_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Teɓaɓaka ɓaumunya na ekpele yɔnɔyɔ, tee nɔnɔ waa yaa zinza maa mokyisi munsɔ. Imbɛlɛ saamoya Ŋwana wa Moto ya moɓa nde ɓomɔ. ");
INSERT INTO loq_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ɓampele ɓaɓale ɓamoɓa o inzabi, ɓamokpa mɔnɔmɔ, ɓamoika mɔnɔmɔ. ");
INSERT INTO loq_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ɓaɓasi ɓaɓale ɓamoɓa ɓatwakye o oomba yɔnɔyɔ, ɓamokpa mɔnɔmɔ, ɓamoika mɔnɔmɔ. ");
INSERT INTO loq_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Kyɛngyɛ na ɓolaa, phɔ mokɔlɔ ŋwaamoya Nkolo wa ɓɛ̀ɛ toomoeɓe. ");
INSERT INTO loq_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Umunya na ɓolaa lowɔ lolo: Ɓo nkolo wa ingambi aeɓakyi imbɛlɛ ye saamoya mwibi na mokɔlɔ, nde talasi, phɔ ya ikyɛngyɛ oɓokye mwibi sanyɔlɔ o ingambi sɛ. ");
INSERT INTO loq_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Yango mɛna, ɓɛ̀ɛ ɓaka na ɓokyɛngyi imɓɛlɛ sisɔ. Phɔ Ŋwana wa Moto amoyaa o imɓɛlɛ site sieɓe ɓɛ̀ɛ.» ");
INSERT INTO loq_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","«Ɓaka ndokolo moto wa etoma owa ɓosembo na ná malondo. Mokonzi nwɛ amotɛyɛ kapita ya ɓɛbi nɛ, phɔ aɓaphɛkyɛ ntoma o imbɛlɛ siikokyi. ");
INSERT INTO loq_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Nkyisa ɓoikye na kapita mɔna, ɓo mokonzi nwɛ aesi ya motakana kakyele etoma mɛ. ");
INSERT INTO loq_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nde phɛlɛ na wɔ na ɓɛ̀ɛ ngakye: Mokonzi mona aamophɛ ɓokonzi pha mbolo yɛɛ isɔ. ");
INSERT INTO loq_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Kasi ɓo kapita mɛ tali na ɓosembo, aambi miwɔlɛ yokye: “Mokonzi ŋwa nga taaye zele”, ");
INSERT INTO loq_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ambi tata iwanda ɓɛbi nɛ, abuto izaa na inywa elele yɔnɔyɔ na ɓalangyi ɓa malɛku. ");
INSERT INTO loq_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Emba, mokonzi nwɛ amoyaa mokɔlɔ ŋwaamoɓa yo samoziya, naa o imbɛlɛ siite sieɓe yo. ");
INSERT INTO loq_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Aamowiinya, aamba mophɛ etumbu enɛnɛ, aamunyɔsa ooli ɓanyamaɓɔlɛ, o elele ekyelele ɓɛ́ɛ na ekye twe ɓɛ́ɛ mino.» ");
INSERT INTO loq_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","«Ɓokonzi pha ikolo phamoulana na ete ya ɓangɔndɔ iko ɓaakpaka ɓatala ɓa ɓɛ́ɛ phɔ ya ikyɛ vana na moloo wa ɓolonga. ");
INSERT INTO loq_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Onte ya ɓɛ, ɓatano ɓaɓaka bibubusi, ɓatano ɓayɔkɔ ɓaɓaka ɓamalondo. ");
INSERT INTO loq_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ɓaa bibubusi ɓaphilaka nde ɓatala, kasi iphila mautaa maikye phe. ");
INSERT INTO loq_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Kasi ɓaamalondo ɓaphilaka ɓatala ɓa ɓɛ́ɛ na ndangyi ya mauta. ");
INSERT INTO loq_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Waɓaa moloo wa ɓolonga saya izele, ɓɛ́ɛ ɓasɔ ɓaokyi ebu ɓalasi. ");
INSERT INTO loq_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Waamolengyela, moto mɔnɔmɔ aesi ya aŋwana yokye: “Kyeka moloo wa ɓolonga, tɔkɔlɔ okyɛ moyamba!” ");
INSERT INTO loq_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Emba ɓangɔndɔ ɓaɓana ɓaesi ya umwa, ɓatati iɓɔngya ɓatala ɓa ɓɛ. ");
INSERT INTO loq_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ɓangɔndɔ ɓaa bibubusi ɓamba ya wɔ na ɓɛbi na ɓɛ́ɛ ɓaa malondo ɓɛkye: “Olophɛ ndambo ya mauta, ɓatala ɓa ɓanga ɓazime.” ");
INSERT INTO loq_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ɓaa malondo ɓamba ya ɓabuyisa ɓɛkyɛ: “Phe, ɓo toephɛ, mauta ma ɓanga ete maakokye. Kyɛndɛ omba maɓɛ o zando.” ");
INSERT INTO loq_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Waakyɛ ɓaa bibubusi ikyɛ omba mauta, nde o sina imbɛlɛ mɛ, moloo wa ɓolonga aesi o sima. Ɓatano ɓaa malondo ɓaamilɛngyɛlɛkyɛ, ɓaesi ya nyɔlɔ na moloo wa ɓolonga o ingambi sa esɛlɛkɔ. Ɓamba kanga ekomba na iphungola. ");
INSERT INTO loq_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","O sima, ɓangɔndɔ ɓatano ɓaa bibubusi ɓaesi ya koma, ɓaaŋwanaka ɓɛkye: “Nkolo, Nkolo, oloziɓole!” ");
INSERT INTO loq_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Kasi moloo wa ɓolonga amba yaɓabuyisa yokye: “Nde phɛlɛ na wɔ na ɓɛ̀ɛ ngakye: Sieyeɓe.”» ");
INSERT INTO loq_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yesu amba sukya ɓoɓo: «Yango mɛna, nde kokyɛngyɛ phɔ toeɓe na mokɔlɔ na ngonga.» ");
INSERT INTO loq_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","«Ŋwaphongo amokyela ndokolo moto mɔnɔmɔ kalukye ikyɛndɛ o imbanga, aɓangyi ɓato ɓɛ́ɛ ɓaetoma, aesi ya ɓakaɓela ɓaphalanga ɓɛ́ɛ phɔ ɓa ɓakolisa. ");
INSERT INTO loq_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Aesi ya phɛ moto na moto ɓookokyi na malondo mɛ. Owa eɓandele amophɛ biɓende ɓa ɓaphalanga bitano, owa iɓale biɓende ɓa ɓaphalanga biɓale, emba owa iyato eɓende ya phalanga yɔnɔyɔ. ");
INSERT INTO loq_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Moto wa etoma owa zwaka biɓende ɓa ɓaphalanga bitano, akyɛ ɓakyela na mumbongu, amba kula zwa biɓende bitano bisuu. ");
INSERT INTO loq_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Owa zwaka biɓende biɓale, akyɛ kyela nde ɓɔmɔ amba zwa biɓende ɓa ɓaphalanga biɓale bisuu. ");
INSERT INTO loq_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Kasi owa zwaka eɓende yɔnɔyɔ, akyɛ tima iɓela o manyɛtɛ, aɓombi ɓaphalanga ɓaamophɛkyɛ nkolo wɛ.» ");
INSERT INTO loq_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","«Nkɔlɔ nzikye ya lekanaka, nkolo wa ɓato ɓa etoma aesi ya butwa, amba ya ɓanga ɓato ɓɛ́ɛ ɓa etoma phɔ ɓamoteya ɓo wakyelela ɓɛ́ɛ ɓaphalanga ɓɛ. ");
INSERT INTO loq_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Moto wa etoma owa zwaka biɓende ɓa ɓaphalanga bitano, aesi ya moteya bitano bisuu yokye: “Nkolo, wampɛkyɛ biɓende ɓa ɓaphalanga bitano, kyeka nakuli ɓakya biɓende bitano bisuu o ikolo.” ");
INSERT INTO loq_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Nkolo wɛ amba ya wɔ nɛ yokye: “Ɓolaa, moto wa etoma o molaa na owa ɓosemɓo. Oli na ɓosembo o mbolo iinkyikyi naamoephɛ ɓokonzi pha mbolo iinzikye. Yaka ya kumbe na nga elɔngɔ.” ");
INSERT INTO loq_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Moto wa etoma owa zwaka biɓende ɓa ɓaphalanga biɓale aesi nɛ ya moteya, amba ya wɔ yokye: “Nkolo, wampɛkyɛ biɓende ɓa ɓaphalanga biɓale, kyeka, nakuli ɓakya biɓale bisuu o ikolo.” ");
INSERT INTO loq_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Nkolo wɛ amba ya wɔ nɛ yokye: “Ɓolaa, oli moto wa etoma o molaa na owa ɓosembo. Oɓakyi na ɓosembo o mbolo iinkyikyi, na moephɛ ɓokonzi o mbolo inzikye. Yaka ya kumbe na nga elɔngɔ.” ");
INSERT INTO loq_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","O suka moto wa etoma owa phɛkyɛ ɓɛ́ɛ eɓende ya ɓaphalanga yɔnɔyɔ aesi nɛ, amba ya wɔ yokye: “Nkolo, nga naeɓe oɓokye iwɛ oli moto mɔnɔmɔ wa nkamba, konɔkɔ mbuma o elele eteyaikaka phika wɛ. ");
INSERT INTO loq_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nailaka, namba kyɛ ɓomba ɓaphalanga ɓa wɛ o se ya manyɛtɛ, kyeka ɓaphalanga ɓa wɛ ɓɛ́ɛ ɓaɓa.” ");
INSERT INTO loq_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Nkolo wɛ amba ya mobuyisa yokye: “Moto wa etoma moɓe na wa ɓokɔɔ! Waeɓaka oɓokye nga nanɔkɔ mbuma o elele ete yaikaka nga phika. ");
INSERT INTO loq_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Kasi iwɛ nga nde wa kyɛkyɛ ɓomba ɓaphalanga ɓanga o banki, wa iyaa nga nde naesi ya ɓazwa na ɓanaa matabisi. ");
INSERT INTO loq_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Omoɓɔlɔlɔ eɓende ya phalanga mɛna, oephɛ ooli na biɓende ɓa ɓaphalanga iko. ");
INSERT INTO loq_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Phɔ ooli ná ɓanaa mbolo nzikye ɓamokula moɓakyisela, kasi ooli pha, ɓaamoɓɔlɔlɔ na ŋwana ndambo ooɓakyi nɛ. ");
INSERT INTO loq_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Vaka moto wa etoma ootoli na ntina o iɓanda, o enzɔmbi, o elele ekyelele ɓɛ́ɛ na ekye twe ɓɛ́ɛ mino.”» ");
INSERT INTO loq_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","«Mokɔlɔ ŋwaamoya Ŋwana wa Moto na nkyɛmɔ yɛ, elele yɔnɔyɔ na ɓanze ɓasɔ, amozala o eziye yɛ eya ɓokonzi. ");
INSERT INTO loq_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ɓato ɓasɔ ɓaa munse, ɓamoyaangana o ɓoo phɛ, aaɓakaɓa ndokolo waakaɓe mɔɔkɔsi mampate na mambosi. ");
INSERT INTO loq_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Amotɛyɛ mampate o ɓoloo phɛ, mambosi o ɓowɛɛ phɛ. ");
INSERT INTO loq_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Emba mokonzi amba ya wɔɔ na ɓali o ɓoloo phɛ yokye: “Ɓɛɛ yaka, ɓato ɓapambola Tata, ya nyɔlɔ o ɓokonzi phaa eɓɔngyisela ɓɛ, uta o etatele ya mokyisi. ");
INSERT INTO loq_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Phɔ naɓaka na nzala, wampɛkyɛ ntoma ya izaa, naɓaka na phowa ya maa, wampɛkyɛ maa mainywa, naɓaka mobutu, wanzambaka o mangambi ma ɓɛ̀ɛ. ");
INSERT INTO loq_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Naɓaka ɓolumbu, wamba ya mpɛ bitobu ɓa ilata, naɓaka na ɓolɔsi, wansalisaka, naɓaka o bɔlɔkɔ, wayakaka ya nkyeka.” ");
INSERT INTO loq_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ɓato ɓaɓosembo ɓamba ya mobuyisa ɓɛkye: “Nkolo, imbɛlɛ ye saaewɛnɛkyɛ ɓanga na nzala tomba ya ephɛ ntoma ya izaa, na ná phowa ya maa, tomba yaa ephɛ maa mainywa? ");
INSERT INTO loq_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Imbɛlɛ ye saaɓaka wɛ mobutu oka ɓanga tomba eyamba o mangambi ma ɓanga, na ɓolumbu tomba ephɛ bitobu ɓa ilata? ");
INSERT INTO loq_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Imbɛlɛ ye saaewɛnɛkyɛ ɓanga naa ɓolɔsi naa o bɔlɔkɔ, tomba ya kyɛ ekyeka?” ");
INSERT INTO loq_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Mokonzi amba ya ɓabuyisa yokye: “Nde phɛlɛ nawɔ na ɓɛ̀ɛ ngakye: Mbala isɔ yaaɓaka ɓɛ̀ɛ kokyele na mɔnɔmɔ na ɓaakyɛ onte ya ɓanaa mama, mɛna waɓaka kokyelele nde nga.”» ");
INSERT INTO loq_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","«O sima mokonzi amba ya wɔ na ɓaali o ɓowɛɛ phɛ yokye: “Mana o miyo ma nga, ɓɛ̀ɛ ɓato ɓaalaka ɓɛ́ɛ na ɓoɓe! Kyɛndɛ o ŋwenya mote mozime, ŋwa ɓɔngya ɓɛ́ɛ phɔ ya Zabulu na ɓakonga ɓɛ! ");
INSERT INTO loq_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Phɔ naɓaka na nzala, toikaka ya mpɛ ntoma ya izaa, naokaka phowa ya maa, toikaka mpɛ maa mainywa. ");
INSERT INTO loq_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Naɓaka mobutu toikaka nzamba, naɓaka ɓolumbu, toikaka mpɛ etobu ya ilata, naɓaka na ɓolɔsi na o bɔlɔkɔ, toikaka nsunga.” ");
INSERT INTO loq_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Emba ɓɛ́ɛ ɓamba ya motuna ɓɛkye: “Nkolo, imbɛlɛ ye saa ewɛnɛkyɛ ɓanga na nzala naa na phowa ya maa naa mobutu naa ɓolumbu naa na ɓolɔsi naa o ɓɔlɔkɔ tomba lɛ iesunga?” ");
INSERT INTO loq_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Mokonzi amba ɓabuyisa yokye: “Nde phɛlɛ nawɔ na ɓɛ̀ɛ ngakye: Mbala isɔ yaalɛkyɛ ɓɛ̀ɛ ikyelela mɔnɔmɔ na ɓaakyɛ onte ya ɓanaa mama, mɛna walɛkyɛ ikyelela nde nga.” ");
INSERT INTO loq_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Emba ɓato mɛ ɓaamba zwa etumbu eteyunve, kasi ɓato ɓaaɓosembo ɓamozwa ɓomɔɔ pha ɓoɓɛlɛ.» ");
INSERT INTO loq_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Waaunva Yesu iwɔ maphɔɔ masɔ mamana, amba ya wɔ na ɓaekosi ɓɛ̀ɛ yokye: ");
INSERT INTO loq_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Ɓɛɛ koeɓe oɓokye iikasi nkɔlɔ iɓale phɔ ya esɛlɛkɔ ya Ilekana, ɓamoungya Ŋwana wa Moto phɔ ɓamoɓakye o ekulusu.» ");
INSERT INTO loq_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Nde o sina imɓɛlɛ mɛ, ɓakonzi ɓa ɓanganga ɓa Ŋwaphongo na ɓankumu ɓa Ɓayuda ɓakyɛkyɛ angana o ingambi sa Kayafa, mokonzi ŋwa ɓanganga ɓa Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Emba ɓamba wangya iyakya Yesu miiɓombo phɔ ya imoɓoma. ");
INSERT INTO loq_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ɓamba wɔ ɓɛkye: «Tolokokyi imoakya mokɔlɔ ŋwa esɛlɛkɔ phɔ ɓato nde ɓatɔmbi.» ");
INSERT INTO loq_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Mokɔlɔ mɔnɔmɔ Yesu aɓaka o Betani o ingambi sa Simo, moto owaɓaka na ɓolɔsi pha maɓaa. ");
INSERT INTO loq_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Waaɓa yo kazee, ŋwaŋwasi mɔnɔmɔ aesi wali yo, na molangyi o maɓɔkɔ ŋwa kyela ɓɛ́ɛ na ná iɓanga saa motuya motondi na malasi ma motuya mwikye. Amba ya masweya o moto ŋwa Yesu. ");
INSERT INTO loq_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Waawɛnɛ ɓaekosi ɓaɓona, ɓawɛnɛkye ɓoɓe, ɓamba wɔ ɓɛkye: «Ani ɔtɔ malasi mamana phɔ ya'ye? ");
INSERT INTO loq_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Nde ɓamaungyakyi na motuya mwikye, ɓambe kpa ɓana ɓaphalanga ɓaɓakaɓele ɓaɓola.» ");
INSERT INTO loq_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesu aeɓaka maphɔɔ masɔ maaɓaka ɓɛ́ɛ ɓawɔ. Amba ya wɔ na ɓɛ́ɛ yokye: «Phɔ ya'ye ɓɛ̀ɛ kotungyisa ŋwaŋwasi oyo? Lowɔ lokyesi yo phɔ ya nga lolekyi ɓolaa. ");
INSERT INTO loq_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ɓaɓola ɓamoɓa na ɓɛ̀ɛ wawa imbɛlɛ sisɔ. Kasi nga esiiɓe na ɓɛ̀ɛ nkɔlɔ isɔ. ");
INSERT INTO loq_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ambo nzɔlɔlɔ malasi o nzoto, phɔ ya imbɔngya nɔnɔ wa munkunda ɓɛ. ");
INSERT INTO loq_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nde phɛlɛ nawɔ na ɓɛ̀ɛ ngakye: O nkyisi isɔ, na o bilele bisɔ bamoumolaka ɓɛ́ɛ Simo Elaa, ɓamoɓaka ɓawɔ lowɔɔ lookyesi ŋwaŋwasi oyo, ɓaamba na moumunya.» ");
INSERT INTO loq_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ɓoɓɛlɛ, mɔnɔmɔ na ɓaekosi iko mbuka ɓaɓale, ookoɓangye ɓɛ́ɛ Yudasi Mosikaliyota, aesi ya kyɛndɛ oka ɓakonzi ɓa ɓanganga ɓa Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Amba ya wɔ na ɓɛ́ɛ yokye: «Wamumpɛ'ye, ɓo naekaɓesi Yesu?» Emba ɓɛ́ɛ ɓamba mophɛɛ biɓende ɓa ɓaphalanga makoo maato. ");
INSERT INTO loq_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Uta mokɔlɔ maamuna, Yudasi abutwaka iluka malondo ma iɓaungyisa Yesu. ");
INSERT INTO loq_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ya ɓaka mɔkɔlɔ mwa etatele ya esɛlɛkɔ ya mapa maatumbe ɓɛ́ɛ sa munɔ moulole mapa, ɓaekosi ɓaesi ya kyɛ tuna Yesu ɓɛkye: «Kozingye oɓokye tokyɛ elambela ntoma ya esɛlɛkɔ ya Ilekana bi?» ");
INSERT INTO loq_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yesu amba ya wɔ na ɓɛ́ɛ yokye: «Kyɛndɛ o munsɔngɔ ŋwa mokyisi munɛnɛ o ingambi sa songolo, owɔ nɛ ɓoɓo: “Moteye awɔ yokye: Imbɛlɛ sanga sikokyi, nga na mozaa esɛlɛkɔ ya Ilekana o ingambi sa wɛ nga na ɓaekosi ɓa nga.”» ");
INSERT INTO loq_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ɓaekosi ɓaamba kyela ɓo wa ɓatomaka Yesu, ɓalambi ntoma ya esɛlɛkɔ ya Ilekana. ");
INSERT INTO loq_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Waakoma nkɔkɔlɔ, Yesu amba ya kyɛ zala elele yɔnɔyɔ na ɓaekosi ɓɛ̀ɛ iko mbuka ɓaɓale. ");
INSERT INTO loq_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Waaɓaka ɓɛ́ɛ ɓaze, Yesu amba ya wɔ na ɓɛ́ɛ yokye: «Nde phɛlɛ na wɔ na ɓɛ̀ɛ ngakye: Mɔnɔmɔ onte ya ɓɛ̀ɛ amunzungya.» ");
INSERT INTO loq_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ɓaekosi ɓamba oka ngɔngɔ ɓoikye, ɓamba tata imotuna mɔnɔmɔ na mɔnɔmɔ oɓokye: «Nkolo, eli nza?» ");
INSERT INTO loq_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesu amba buya yokye: «Owa munzungya eli nde mɔnɔmɔ na ɓɛ̀ɛ, maɓɔkɔ ma ɓanga mamovana mɓala yɔnɔyɔ o lako. ");
INSERT INTO loq_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ŋwana wa Moto amowa nde ɓowa komama wango phɔ yɛ o buku pha Ŋwaphongo. Eye ngɔngɔ phɔ ya moto owamoungya Ŋwana wa Moto. Eɓakyi ɓolaa phɔ ya moto mɛ ɓo taɓotamaka.» ");
INSERT INTO loq_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yudasi moto owaamoungya amba ya motuna yokye: «Moteye, eli nga?» Yesu amba ya mobuyisa yokye: «Iwɛ mampenza olowɔɔ.» ");
INSERT INTO loq_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Waaɓa ɓɛ́ɛ ɓaze, Yesu akpe ipa, aphɛ Ŋwaphongo mɛlɛsi, asikyɛsi, amba kaɓela ɓaekosi ɓɛ́ɛ amba ya wɔ na ɓɛ́ɛ yokye: «Imaa, zaa eye eli nzoto ya nga.» ");
INSERT INTO loq_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Amba kula ya kpa kɔphɔ ya vinyɔ, aphɛ Ŋwaphongo mɛlɛsi aephɛ ɓaekosi ɓɛ̀ɛ, amba ya wɔ yokye: «Oenywe ɓɛ̀ɛ ɓasɔ. ");
INSERT INTO loq_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Phɔ eye eli malongo ma nga, malongo ma sangola ya Ŋwaphongo na ɓato, masweye phɔ ya ɓato ɓaikye, ɓazwe ɓolimbisi pha masumu. ");
INSERT INTO loq_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nawɔ na ɓɛ̀ɛ ngakye tata lɔlɔ, esikule nywa vinyɔ eye tee nɔnɔ mokɔlɔ ŋwa munywa nga na ɓɛ̀ɛ vinyɔ eenyakune o Ɓokonzi pha Tata.» ");
INSERT INTO loq_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ɓoɓɛlɛ, Yesu na ɓaekosi ɓɛ̀ɛ, ɓamba ya tuɓa meembo ma esɛlɛkɔ. Waaunva ɓɛ̀ɛ ituɓa meembo, ɓamba ya kyɛndɛ o ngomba ya Ɓaolive. ");
INSERT INTO loq_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Yesu amba ya wɔ na ɓaekosi ɓɛ́ɛ yokye: «Nde na mokɔlɔ ŋwa lɔlɔ, ɓɛ̀ɛ ɓasɔ wamundota. Phɔ yakomama o buku pha Ŋwaphongo ɓoɓo: “Namoɓoma mɔɔkɔsi wa mampate, mampate masɔ mamunyangwa.” ");
INSERT INTO loq_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Yesu amba kula ɓakya yokye: Kasi waamokundwa nga na mokyɛ eziya o Galileya.» ");
INSERT INTO loq_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petelo amba ya wɔ nɛ yokye: «Na ɓo ɓɛ́ɛ ɓasɔ ɓaeloti, nga esielote.» ");
INSERT INTO loq_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesu amba ya mobuyisa yokye: «Nde phɛlɛ nawɔ na wɛ ngakye: Nde na mokɔlɔ ŋwa lɔlɔ, soo sa ɓotɔngɔkye iwɛ wa munzangana mɓala iyato oɓokye toonzeɓe.» ");
INSERT INTO loq_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petelo amɓa ya kpɛtɛ kapha yokye: «Na ɓo eɓe oɓokye na wee na wɛ elele yɔnɔyɔ, nga esieyangane.» Ɓaekosi ɓasɔ ɓamba ya wɔ nde ɓɔmɔ. ");
INSERT INTO loq_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Emba Yesu amba ya koma na ɓaekosi ɓɛ́ɛ o etiye ekyeɓangye ɓɛ́ɛ Getesemani. Amba ya wɔ na ɓɛ́ɛ yokye: «Ɓɛ̀ɛ zala wawa, nga nakyɛ ɓɔndɛlɛ Ŋwaphongo.» ");
INSERT INTO loq_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Amba kyɛ na Petelo na ɓana ɓaɓale ɓa Zebede ɓaa ɓampele, Zake na Yoane. Ɓoɓɛlɛ atati ioka motema ɓolɔsi na inganga. ");
INSERT INTO loq_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Amba ya wɔ na ɓɛ́ɛ yokye: «Ndondo ya nga etondi na ngɔngɔ ndokolo namowa. Ikala wawa, kɛngyɛ na nga.» ");
INSERT INTO loq_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Amba yakyɛ ŋwana itakye, akyɛ kusama ɓoo o se, amba tata iɓɔndɛlɛ Ŋwaphongo yokye: «Tata, ɓo wakokyi ikyelama, manya kɔphɔ eya ɓolɔsi eye. Kasi sakyela ɓoozingyi nga, kyela nde ɓoozingyi wɛ.» ");
INSERT INTO loq_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Yesu amba ya butwa oli ɓaekosi ɓɛ̀ɛ ɓaato, aesi ya kyɛ ɓatakana ɓalasi ebuu. Amba ya wɔɔ na Petelo yokye: «Toikyi koka ikyɛngyɛ na nga na ɓo ngonga yɔnɔyɔ? ");
INSERT INTO loq_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Kyɛngyɛ, ɓɔndɛlɛ Ŋwaphongo phɔ ɓɛ̀ɛ sakaa o bimekyi ɓa Molemba! Moto o ndondo yɛ ali na phowa ya ikyela ɓolaa, kasi o nzoto yɛ tali na ɓokusi.» ");
INSERT INTO loq_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Akulaka kyɛndɛ mbala eya iɓale, amba kyɛ ɓɔndɛlɛ Ŋwaphongo yokye: «Tata, ɓo kɔphɔ eye teekokyi imana, elaa na enywe, wakyelame nde ɓozingyi wɛ.» ");
INSERT INTO loq_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Yesu amba kula ya butwa ooli ɓaekosi ɓɛɛ, amba kula ya kyɛ ɓazwa ɓakuli lala ebuu. Phɔ miyo ma ɓɛ̀ɛ mabutwaka mazito. ");
INSERT INTO loq_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yesu amba kula ɓaika, akyɛ ɓɔndɛlɛ mɓala eya iyato, akulaka wɔ nde ɓɔmɔ. ");
INSERT INTO loq_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","O sima aesi ya butwa ooli ɓaekosi ɓɛ̀ɛ, amba ya wɔ na ɓɛ̀ɛ yokye: «Kokule lala, komieminya? Kyeka, imbɛlɛ sa iyambya Ŋwana wa Moto o maɓɔkɔ ma ɓato ɓa masumu sikokyi. ");
INSERT INTO loq_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Temɛ, tokyɛndɛ. Kyeka moto ookonzungya aesi.» ");
INSERT INTO loq_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Waaɓa Yesu kata wɔ, Yudasi mɔnɔmɔ na ɓaekosi iko mbuka ɓaɓale, aesi ya koma. Aesi na ɓato ɓaikye, ɓaphisi mphata na nkpɔngu o maɓɔkɔ. Ya ɓatomaka ɓakonzi ɓa ɓanganga ɓa Ŋwaphongo na ɓankumu ɓa Ɓayuda. ");
INSERT INTO loq_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yudasi owa ungyaka Yesu, aɓateyaka iyaa samokyela yo, amba ya wɔ yokye: «Moto owa moyamba nga, yo mɔna, omoakya.» ");
INSERT INTO loq_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Waakoma Yudasi, amba susana oli Yesu amba ya wɔ nɛ yokye: «Moteye, mbote!» Amba moyamba. ");
INSERT INTO loq_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesu amba ya mobuyisa yokye: «Nwɛbi na nga, yeesi wɛ ya kyela, oikyele mizele.» Emba ɓaayɔkɔ ɓamba ya susana, ɓaphisi Yesu, ɓamba moakya. ");
INSERT INTO loq_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Mɔnɔmɔ na ɓaaɓaka na Yesu, amba gɓɔlɔ mumphata nwɛ, ateni itoo sa moto wa etoma wa mokonzi ŋwa ɓanganga ɓa Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yesu amba ya wɔ nɛ yokye: «Buya mumphata ŋwa wɛ o ekokolo. Phɔ ɓato ɓasɔ ɓaaŋwane na mumphata, ɓawe nde na mumphata. ");
INSERT INTO loq_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Toeɓe oɓokye ɓo naongyi mbengo oka Tata, nde uŋwaŋwa eye amuntomela ɓaanzelu ɓaikye ileka ɓatayɔ iko mbuka iɓale ya ɓatuluku. ");
INSERT INTO loq_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Kasi ɓonakyesi ɓaɓona, maphɔɔ makomama o buku pha Ŋwaphongo mamokokyisama ndengye'ye? Phɔ wakomama oɓokye maphɔɔ masɔ masengyesi ikyelama nde ɓaɓona.» ");
INSERT INTO loq_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","O sima Yesu amba ya wɔ na ɓato ɓasɔ yokye: «Emba iya nzakya kombe yaa na mphata na ná nkpɔngu o maɓɔkɔ ndokolo nga nali nde moibi? Nkɔlɔ isɔ naɓaka nazale o Tempelo phɔ ya iteya toikaka na nzakya. ");
INSERT INTO loq_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Kasi masɔ mama makyelame phɔ ya ikokya maloɓa ma ɓaimosi ɓa Ŋwaphongo maakoma ɓɛ́ɛ o ɓuku pha Ŋwaphongo.» Emba ɓaekosi ɓasɔ ɓaikyi moika, ɓaloti. ");
INSERT INTO loq_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ɓato ɓaakyaka Yesu, ɓamba yakyɛ nɛ oka Kayafa, mokonzi ŋwa ɓanganga ɓa Ŋwaphongo, waanganaka ɓaamiɓeko na ɓankumu. ");
INSERT INTO loq_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Petelo aɓaka kaɓengye Yesu na itakye tee nɔnɔ wakyɛ yo nyɔlɔ o lophango la mokonzi ŋwa ɓanganga ɓa Ŋwaphongo. Omɔ, amba kyɛ zala elele yɔnɔyɔ na ɓasinzili, phɔ ya ikyeka ndengye eya mosuka lowɔɔ mɛ. ");
INSERT INTO loq_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Bakonzi ɓa ɓanganga ɓa Ŋwaphongo na ɓato ɓasɔ ɓa ikyita siinɛnɛ ɓaɓaka ɓalukye ɓato ɓaakokyi ikatela Yesu maphɔɔ phɔ ɓamoingya. ");
INSERT INTO loq_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Kasi na ɓo ɓato ɓaikye ɓayakaka ya mokatela maphɔɔ, teɓaika zwa na lowɔ lonɔlɔ tee sima ɓato ɓaɓale ɓamba yaa, ");
INSERT INTO loq_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ɓaesi ya wɔ ɓɛkye: «Moto oyo awɔkɔ yokye: Nga na mouwola Tempelo ya Ŋwaphongo namba etonga sima ya nkɔlɔ iyato.» ");
INSERT INTO loq_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Emba mokonzi ŋwa ɓanganga ɓa Ŋwaphongo aesi ya tɛmɛ, amba ya tuna Yesu yokye: «Toobuya na iikyiephunde ɓato ɓaɓa?» ");
INSERT INTO loq_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Kasi Yesu aikalaka nde ɓose. Mokonzi ŋwa ɓanganga ɓa Ŋwaphongo akulaka wɔ nɛ yokye: «Kata seleka na nkombo ya Ŋwaphongo oli na ɓomɔɔ! Oloimole ɓo oli Masiya, Ŋwana wa Ŋwaphongo?» ");
INSERT INTO loq_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu amba mobuyisa yokye: «Iwɛ mampenza olowɔɔ. Kasi nawɔ na ɓɛ̀ɛ ngakye: Tata uŋwaŋwa, wamowɛnɛ Ŋwana wa Moto azasi o ɓoloo pha Ŋwaphongo owa mwiya, waamba na mowɛnɛ kaye onte ya mampata!» ");
INSERT INTO loq_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Emba mokonzi ŋwa ɓanganga ɓa Ŋwaphongo, amba ya kakola bitobu ɓɛ̀ɛ ɓalataka yo, amba ya wɔ yokye: «Atosi Ŋwaphongo! Tolokuli sengyela na manzoka! Ookyi ɓootosi yo Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ɓɛ̀ɛ koumunya ɓo?» Ɓamba mobuyisa ɓɛkye: «Asengyesi iwaa!» ");
INSERT INTO loq_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","O sima mɛ, ɓamba motowa matee o ɓoo, ɓamba mowanda mankutu, ɓaayɔkɔ ɓamba mowanda bingyete. ");
INSERT INTO loq_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ɓamba wɔ ɓɛkye: «Iwɛ Masiya, teya oɓokye oli moimosi! Ooewandi nza?» ");
INSERT INTO loq_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Petelo aɓaka azasi o iɓanda o lophango. Ŋwaŋwasi mɔnɔmɔ wa etoma, amba ya wɔ nɛ yokye: «Na wɛ oɓakyi na Yesu, moto wa Galileya.» ");
INSERT INTO loq_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Kasi yo amba angana o miyo ma ɓato ɓasɔ, amba wɔ yokye: «Maphɔɔ manvɔlɛ wɛ mamana, nga siimaeɓe.» ");
INSERT INTO loq_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Sima Petelo aesi ya kyɛ tɛmɛ o munɔkɔ ŋwa lophango. Moto wa etoma mosuu wa ŋwaŋwasi aesi ya mowɛnɛ, amba ya wɔ na ɓaaɓaka wamɔ yokye: «Moto oyo aɓakyi na Yesu owa Nazalɛtɛ.» ");
INSERT INTO loq_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Petelo akulaka angana, amba kata na seleka yokye: «Sieɓe moto mɔna.» ");
INSERT INTO loq_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Sakɔkɔ ɓato ɓaaɓaka wamɔ ɓaesi oli Petelo, ɓamba ya wɔ nɛ ɓɛkye: «Nde phɛlɛ, oli mɔnɔmɔ na ɓɛ, phɔ ewɔsi ya wɛ kyeephunde!» ");
INSERT INTO loq_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Emba Petelo amba ya aŋwana yokye: «Seleka Nzambi, sieɓe moto mɔna. Ɓo nakate, Ŋwaphongo ampɛ etumbu!» Nde o sina imbɛlɛ mɛ, soo eesi ya tɔngɔ. ");
INSERT INTO loq_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Emba Petelo amba ya umunya maphɔɔ maawɔkɔ Yesu nɛ oɓokye: «Soo sa ɓotɔngɔkye, wamunzangana mbala iyato oɓokye wɛ toonzeɓe.» Ɓoɓɛlɛ Petelo amba ya tɔkɔlɔ na ilela na ngɔngɔ ɓoikye. ");
INSERT INTO loq_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Waa moyɛlɔ, ɓakonzi ɓa ɓanganga ɓa Ŋwaphongo ɓasɔ naa ɓankumu ɓa Ɓayuda, ɓaanga, ɓamba okana oɓokye ɓaɓome Yesu. ");
INSERT INTO loq_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ɓamba mokanga maphanga, ɓamba yakyɛ nɛ oka Pilata moangyesi ŋwa Ɓayuda. ");
INSERT INTO loq_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yudasi moto owa moungyaka, wa oka yo oɓokye ɓatenesi Yesu ɓolombe pha iwaa, aokaka ɓolɔsi ɓoikye o ndondo yɛ, amba ya kyɛ buyisa mokonzi ŋwa ɓanganga ɓa Ŋwaphongo na ɓankumu biɓende ɓa ɓaphalanga makoo maato, biamophɛkyɛ ɓɛ. ");
INSERT INTO loq_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Amba ya wɔ na ɓɛ́ɛ yokye: «Nakyesi ɓoɓe phɔ naungye moto ootoli na lowɔɔ.» Kasi ɓɛ́ɛ ɓamba ya mobuyisa ɓɛkye: «Mɛna nde lowɔɔ la wɛ! Lowɔɔ lalona telokyekyi ɓanga!» ");
INSERT INTO loq_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Emba Yudasi amba vaka ɓana ɓaphalanga o Tempelo, nɔnɔ wakyɛ yo miingya. ");
INSERT INTO loq_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ɓakonzi ɓa ɓanganga ɓa Ŋwaphongo ɓaɔngɔkɔ ɓaphalanga mɛ, ɓamba ya wɔ ɓɛkye: «Miɓeko ma ɓanga temianole inyɔsa ɓaphalanga ɓaa ndengye eye o eɓombelo ya Tempelo, phɔ eli ɓaphalanga ɓaatangya malongo ma moto.» ");
INSERT INTO loq_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Waaunva ɓɛ́ɛ iokana, ɓamba ya ɓaomba na inzabi sa moto mɔnɔmɔ owa ɓaka kakyele manoko phɔ ɓakundakye na ɓabutu ɓaawe omɔ. ");
INSERT INTO loq_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Yango mɛna, ɓaɓangye inzabi mɛ nɔnɔ lɔlɔ eye: «Inzabi sa malongo.» ");
INSERT INTO loq_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Wakyelamaka ɓowawɔkɔ moimosi Yilimiya yokye: «Ɓakpee biɓende ɓa ɓaphalanga mako maato, yɛ eli motuya ŋwaaphɛkyɛ ɓato ɓa Isalayɛlɛ phɔ yɛ, ");
INSERT INTO loq_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ɓamba ɓaomba na inzabi sa moto okokyele manoko ɓo wa nvɔlɛkyɛ Nkolo.» ");
INSERT INTO loq_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesu akyɛ samba o ɓoo pha Pilata. Pilata amba ya motuna yokye: «Iwɛ oli mokonzi ŋwa Ɓayuda?» Yesu amba ya mobuyisa yokye: «Iwɛ mampenza o lowɔɔ.» ");
INSERT INTO loq_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Kasi imbɛlɛ saaɓaka ɓakonzi ɓa ɓanganga ɓa Ŋwaphongo na ɓankumu ɓamophunde, iyo taikaka buya na lowɔɔ. ");
INSERT INTO loq_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Emba Pilata amba kula motuna yokye: «Tookye maphɔɔ maikye maephunde na ɓɛ?» ");
INSERT INTO loq_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Kasi Yesu taika na mobuyisa na lowɔɔ lɔnɔlɔ. Yango mɛna Pilata akamwaka na ɓoikye. ");
INSERT INTO loq_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","O bisɛlɛkɔ bisɔ bya Ilekana, mwangyesi amɛɛlɛkyɛ ikandola moto wa bɔlɔkɔ mɔnɔmɔ oozingyi ɓato. ");
INSERT INTO loq_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","O imbɛlɛ mɛ, moto mɔnɔmɔ aɓaka o bɔlɔkɔ, aeɓanaka na ɓoikye, nkombo yɛ Yesu Ɓalaɓa. ");
INSERT INTO loq_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Pilata amba ya tuna ɓato ɓaanganaka yokye: «Ɓɛɛ kozingye oɓokye naekandolele nza? Yesu Ɓalaɓa nde Yesu okoɓangye ɓɛ́ɛ Klisto?» ");
INSERT INTO loq_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilata aeɓaka na ɓolaa oɓokye, ɓaphundaka Yesu oka yɛ nde phɔ ya zuwa. ");
INSERT INTO loq_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Waaɓa Pilata azasi kasambisa Yesu, ŋwasi wɛ amba motomela maloɓa yokye: «Sanyɔlɔ o lowɔɔ la moto mɔna, tali na lowɔɔ. Lɔlɔ na mokɔlɔ nawɛni ɓolɔsi ɓoikye o ndɔtɔ phɔ yɛ.» ");
INSERT INTO loq_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ɓakonzi ɓa ɓanganga ɓa Ŋwaphongo na ɓankumu, ɓaphɛkyɛ ɓato malondo phɔ ɓaongye Pilata akandole Ɓalaɓa, aɓome Yesu. ");
INSERT INTO loq_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pilata akulaka ɓatuna yokye: «Onte ya ɓato ɓaɓale ɓaɓa kozingye oɓokye naekandolele nza?» Ɓamba mobuyisa ɓɛkye: «Ɓalaɓa!» ");
INSERT INTO loq_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Emba Pilata amba kula ya ɓatuna yokye: «Ka nakyele ɓo na Yesu oko ɓangye ɓɛ́ɛ Klisto?» Ɓamba ya buya ɓɛkye: «Omoɓakye o ekulusu!» ");
INSERT INTO loq_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilata amba ya wɔ na ɓɛ́ɛ yokye: «Ɓoɓe ye ɓookyesi yo?» Kasi ɓɛ́ɛ ɓatataka iyaŋwana na ɓokusi mpenza ɓɛkye: «Omoɓakye o ekulusu!» ");
INSERT INTO loq_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Waawɛnɛ Pilata oɓokye takokyi ikyela na ekpele yɔnɔyɔ, ɓato ɓalukye itɔmbɔ, aesi ya kpa maa akunyosi sɛɛ o miyo na ɓato ɓasɔ amba ya wɔ yokye: «Iwaa sa moto oyo tesili o maɓɔkɔ ma nga! Mɛna nde lowɔɔ la ɓɛ̀ɛ.» ");
INSERT INTO loq_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ɓato ɓasɔ ɓamba ya buya ɓɛkye: «Lowɔ phɛ, malongo mɛ maɓee o ikolo sa ɓanga na ɓana ɓa ɓanga.» ");
INSERT INTO loq_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Emba Pilata amba ya ɓakandolela Ɓalaɓa, atomi ɓawande Yesu phimbo, amba ɓa phɛ Yesu oɓokye ɓamoɓakye o ekulusu. ");
INSERT INTO loq_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ɓatuluku ɓa Pilata ɓaesi ya kyɛ na Yesu o lophango la moangyesi. Emba ɓatayɔ mobimba ya ɓatuluku ɓamba ya molungya. ");
INSERT INTO loq_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ɓamba mumanya bitobu, ɓamba molasa nde munkoto mɔnɔmɔ ŋwa mangola. ");
INSERT INTO loq_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Sima, ɓaesi ya tonga eboko yɔnɔyɔ ya milɔ, ɓamba molasa yango o moto ndokolo mokonzi. Ɓamba mophisa ŋwana munkyɛkyɛlɛ o eɓɔkɔ eya ɓoloo, ɓamba butwa imokusamela na imoɛkyɛ, ɓambe wɔ ɓɛkye: «Mbote, mokonzi ŋwa Ɓayuda!» ");
INSERT INTO loq_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ɓamba motowa matee, ɓaesi ya kpa muna munkyɛkyɛlɛ ŋwaamophisaka ɓɛ́ɛ o eɓɔkɔ, ɓabuto imobinda ŋwango o moto. ");
INSERT INTO loq_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Waunva ɓɛ́ɛ imoɛkyɛ, ɓaesi ya mumanya munkoto ŋwamolasaka ɓɛ, ɓamba mobuyisa bitobu ɓɛ. Emba ɓamba kyɛ nɛ ikyɛ moɓaka o ekulusu. ");
INSERT INTO loq_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Waatɔkɔlɔ ɓɛ́ɛ o mokyisi, ɓamba kyɛ vana na moto mɔnɔmɔ wa Sirene, nkombo yɛ Simo, ɓatuluku ɓamotomisaka na ɓokusi oɓokye anyanya ekulusu ya Yesu. ");
INSERT INTO loq_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ɓamba ya koma o elele ekyeɓangye ɓɛ́ɛ Gologota, kyelukye iwɔ oɓokye: «Elele eya engyɛngyɛlɛ.» ");
INSERT INTO loq_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Omɔ ɓamba phɛ Yesu malɛku maangyinya ɓɛ́ɛ na munɔ ŋwa ɓololo, waamameka yo amba lɛɛ imanywa. ");
INSERT INTO loq_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Waaunva ɓɛ́ɛ imobakya o ekulusu, ɓamba ya maa mbɛsɛ phɔ ya ikaɓa bitobu ɓɛ. ");
INSERT INTO loq_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Sima, ɓamba ya zala wamɔ phɔ ya imokyɛngyɛ. ");
INSERT INTO loq_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","O ikolo sa moto nwɛ, ɓakomaka ntina ya iwaa sɛ oɓokye: «Oyo Yesu, mokonzi ŋwa Ɓayuda». ");
INSERT INTO loq_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ɓaɓakaka na ɓaibi ɓaɓale o ekulusu, ona o ɓoloo phɛ, oomoyɔkɔ o ɓowɛɛ phɛ. ");
INSERT INTO loq_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ɓaalekane ɓamotolaka, ɓanyingye na nzoto, ");
INSERT INTO loq_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ɓamba ya wɔ nɛ ɓɛkye: «Iwɛ owalukaka iyuwola Tempelo, ombe etonga na nkɔlɔ iyato, omibikya ɓooli Ŋwana wa Ŋwaphongo, ombe na uta o ekulusu.» ");
INSERT INTO loq_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ɓakonzi ɓa ɓanganga ɓa Ŋwaphongo na ɓateye ɓa Miɓeko na ɓankumu ɓamoɛkyɛkyɛ nde ɓomɔ, ɓamba ya wɔ ɓɛkye: ");
INSERT INTO loq_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«Abikyaka ɓato ɓasuu, kasi takokyi imibikya yo mampenza! Ali mokonzi ŋwa Isalayɛlɛ? Aute uŋwaŋwa o ekulusu, toomba moanola. ");
INSERT INTO loq_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ambyaka motema nwɛ munsɔ oka Ŋwaphongo, nde kawɔ yokye: “Nali Ŋwana wa Ŋwaphongo.” Ka ɓo Ŋwaphongo kamozingye amobikya uŋwaŋwa eye!» ");
INSERT INTO loq_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Eɓe na ɓaibi ɓaaɓakaka ɓɛ́ɛ o ekulusu phɛnɛphɛ na Yesu ɓamotolaka nde ɓomɔ. ");
INSERT INTO loq_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Waakoma bunya i moto, enzɔmbi yeesi ya ziɓa mokyisi munsɔ, tee nɔnɔ o ngonga ya iyato eya nkɔkɔlɔ. ");
INSERT INTO loq_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Phɛnɛphɛ na ngonga eya iyato, Yesu amba ya aŋwana na ɓokusi yokye: «Eli, Eli, lema saɓakatani?» Kyelukye iwɔ oɓokye: «Ŋwaphongo wa nga! Ŋwaphongo wa nga! Phɔ ya'ye ondɛ?» ");
INSERT INTO loq_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ɓato ɓasuu ɓaatɛmɛkyɛ wamɔ, ɓamookyi, ɓamba ya wɔ ɓɛkye: «Kaɓangye moimosi Eliya!» ");
INSERT INTO loq_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Mɔnɔmɔ na ɓɛ́ɛ amba kyilingana izele, akyɛ nyinya inyuka o malɛku maangaa. Asitingye o sɔngya ya mungbalango amba siphɛ Yesu oɓokye anywe. ");
INSERT INTO loq_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Kasi ɓayɔkɔ ɓamba wɔ ɓɛkye: «Ka tokyekye ɓo Eliya amoya mobikya!» ");
INSERT INTO loq_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Emba Yesu ambakula aŋwana ŋwangye mokusi nɔnɔ waakata yo motema. ");
INSERT INTO loq_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Nde o sina imbɛlɛ mɛ, etobu eya lɛngyɛkyɛ ɓɛ́ɛ o Tempelo, o ɓoo pha elele elekyi ɓosanto, yakakwaka na miɓale uta o ikolo nɔnɔ o se. Manyɛtɛ manyinganaka, maɓanga mawaye, ");
INSERT INTO loq_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","malita maziɓoo, ɓasantu ɓa Ŋwaphongo ɓaikye ɓaawaka ɓakundoo, ");
INSERT INTO loq_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ɓatɔkɔsi o malita, emba sima ya ikundwa sa Yesu ɓamba ya nyɔlɔ o Yelusalɛmɛ. Omɔ ɓato ɓaikye ɓaɓawɛnɛkyɛ. ");
INSERT INTO loq_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ɓatuluku ɓaaɓaka ɓakyɛngyɛlɛ Yesu eɓe na mokonzi wa ɓɛ, wawɛnɛ ɓɛ́ɛ manyɛtɛ manyingaa na maphɔɔ masɔ maaɓaka malekane, ɓamba wɛnɛ inganga siikye, ɓamba wɔ ɓɛkye: «Nde phɛlɛ, moto oyo aɓakyi Ŋwana wa Ŋwaphongo!» ");
INSERT INTO loq_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ɓaɓasi ɓaikye ɓaaɓaka ɓakyɛmikyɛ nɛ uta o Galileya phɔ ya imosunga, ɓatɛmɛkyɛ na ɓɛ́ɛ wamɔ, ɓakyekye na itakye. ");
INSERT INTO loq_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Onte ya ɓɛ̀ɛ, yaɓaka Maliya owa Magadala na ndoo yɛ nyango wa Zake na Zozefu, eɓe na nyango wa ɓana ɓa Zebede. ");
INSERT INTO loq_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Wa nkɔkɔlɔ, moto mɔnɔmɔ wa ezwele amba yaa, nkombo yɛ Zozefu. Autaka o Alimataya, nɛ aɓaka moekosi wa Yesu. ");
INSERT INTO loq_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Akyɛkyɛ oka Pilata ikyɛ moonga eɓembe ya Yesu. Pilata amba wɔ oɓokye ɓamophɛ yango. ");
INSERT INTO loq_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Emba Zozefu amba ekpa, aezingyi na etobu eenyakune. ");
INSERT INTO loq_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Amba yakyɛ enyɔsa o ilita saatimaka yo o maɓanga phɔ yɛ mampenza. Ɓoɓɛlɛ amba ya ukaa iɓanga sinɛnɛ phɔ ya iziɓa munɔkɔ ŋwa ilita, nɔnɔ wa butwa yo. ");
INSERT INTO loq_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maliya owa Magadala na ndoo yɛ ɓazalaka o ɓoo pha ilita. ");
INSERT INTO loq_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Sima ya mokɔlɔ mɔnɔmɔ, yaɓaka mokɔlɔ ŋwa saɓata, ɓakonzi ɓa ɓanganga ɓa Ŋwaphongo na Ɓafalisayi ɓamba ya kyɛndɛ oka Pilata. ");
INSERT INTO loq_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ɓamba wɔ nɛ ɓɛkye: «Mokonzi, toumunya maphɔɔ maawɔkɔ nyaɓɔɔlɛ mɔna, wataka ɓaa yo na ɓomɔɔ. Awɔkɔ yokye: “Namokundwa sima ya nkɔlɔ iyato.” ");
INSERT INTO loq_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Eɓɔngyi oɓokye otome ɓato ɓakyɛngyɛlɛ ilita nkɔlɔ iyato, ɓo phe, ɓaekosi ɓɛ̀ɛ ɓamoyaa iɓa eɓembe, emba sima ɓamba wɔɔ na ɓato oɓokye: “Akundo.” Ɓɔɔlɛ ɓaɓona phamoleka phaa phanza na ɓoɓe.» ");
INSERT INTO loq_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilata amba ɓabuyisa yokye: «Kpa ɓatuluku, kyɛndɛ kyɛngyɛlɛ ilita ɓoumunye ɓɛ̀ɛ.» ");
INSERT INTO loq_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Emba ɓamba ya kyɛ ɓalimisa iɓanga mɛ na ɓokusi. Ɓamba ikaa ɓatuluku phɔ ɓasikyɛngyɛlɛ. ");
INSERT INTO loq_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Mokɔlɔ ŋwa saɓata molekaa, na munkukutu, Maliya owa Magadala na ndoo yɛ, nyango wa Zake na Zozefu, ɓakulaka kyɛ kyeka ilita. ");
INSERT INTO loq_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Na mbala yɔnɔyɔ, manyɛtɛ matati inyingana na ɓokusi. Mwanze wa Nkolo auti o ikolo, aesi ya manya iɓanga, amba zala o ikolo sa sango. ");
INSERT INTO loq_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ɓoo phɛɛ phaɓaka ɓongyɛngyɛ ndokolo munkakasi, bitobu ɓɛ̀ɛ baɓaka mpɛmbɛ pɛɛ. ");
INSERT INTO loq_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ɓatuluku ɓawɛnɛkyɛ inganga, ɓabuto itɛkyɛnɛlɛ, ɓabutwaka ndokolo biɓembe. ");
INSERT INTO loq_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Mwanze amba ya wɔ na ɓaɓasi yokye: «Ɓɛ̀ɛ salota, naeɓe oɓokye kolukye Yesu owa ɓomaka ɓɛ́ɛ o ekulusu. ");
INSERT INTO loq_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Wawa tali! Ambo kundwa ɓo wawɔkɔ yo. Yaka ya kyɛ kyeka elele eeɓakyi nzoto yɛ. ");
INSERT INTO loq_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Kyɛndɛ kyɛ imola ɓaekosi ɓɛ̀ɛ izele oɓokye ambo kundwa, “akyɛ uŋwaŋwa eye o ɓoo pha ɓɛ́ɛ o Galileya. Wamokyɛ mowɛnɛ omɔ.” Mɛna eli simo eyakakyi nga ya ieimola.» ");
INSERT INTO loq_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ɓamba mana o ilita izele, ɓaɓaka na inganga siikye, kasi mandondo ma ɓɛ́ɛ matondaka na nkyisa, ɓamba ya kyɛ na mbangu iimola simo mɛ oka ɓaekosi ɓa Yesu. ");
INSERT INTO loq_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Na mbala yɔnɔyɔ Yesu aesi ya tɔkɔlɛlɛ ɓasi mɛ, amba ya wɔ na ɓɛ́ɛ yokye: «Mbote ya ɓɛ̀ɛ!» Ɓɛ́ɛ ɓamba susana phɛnɛphɛ, ɓamba kusama, ɓamophisi o makolo. ");
INSERT INTO loq_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yesu amba ya wɔ na ɓɛ́ɛ yokye: «Ɓɛ̀ɛ saila, kyɛndɛ kyɛimola ɓɛbi na nga, ɓakyɛndɛ o Galileya, ɓamokyɛ nvɛnɛ omɔ.» ");
INSERT INTO loq_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Waaɓa ɓaɓasi ɓabutwe, ɓatuluku ɓaaɓaka ɓakyɛngyɛlɛ ilita ɓamba ya butwa o lombo, phɔ ya ikyɛimola ɓakonzi ɓa ɓanganga ɓa Ŋwaphongo maphɔɔ masɔ malekanaka. ");
INSERT INTO loq_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ɓakonzi ɓa ɓanganga ɓa Ŋwaphongo na ɓankumu, ɓamba angana phɔ ya iyoka, emba ɓamba phɛ ɓatuluku ɓaphalanga ɓaikye. ");
INSERT INTO loq_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ɓamba ya wɔ na ɓɛ́ɛ oɓokye: «Owɔkɔ ɓoɓo: Ɓaekosi ɓɛ̀ɛ ɓaesi ya iɓaa eɓembe yɛ na mokɔlɔ imbɛlɛ siiɓee ɓanga na ebuu. ");
INSERT INTO loq_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ɓo Pilata aokyi lowɔɔ mɛ, toomuya mɔɔ, ɓɛ̀ɛ salota etaekyele ekpele.» ");
INSERT INTO loq_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ɓatuluku ɓaesi ya kpa ɓaphalanga, ɓakyesi nde ɓo wawɔkɔ ɓɛ́ɛ na ɓɛ̀ɛ. Yango mɛna isolo sisi sanyangwaka onte ya Ɓayuda tee nɔnɔ lɔlɔ eye. ");
INSERT INTO loq_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ɓaekosi iko na mɔnɔmɔ ɓaesi ya kyɛndɛ o ngomba ya Galileya, eyawɔkɔ Yesu oɓokye amokyɛ vana na ɓɛ́ɛ omɔ. ");
INSERT INTO loq_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Waamowɛnɛ ɓɛ, ɓamba mokusamela. Kasi ɓayɔkɔ onte ya ɓɛ́ɛ ɓataaka ɓaa na ziko. ");
INSERT INTO loq_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesu amba susana phɛnɛphɛ na ɓɛ, amba ya wɔ na ɓɛ́ɛ yokye: «Ŋwaphongo ampɛ ɓokonzi ɓosɔ pha ikolo na pha o se. ");
INSERT INTO loq_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Yango mɛna, ɓɛ̀ɛ kyɛndɛ oka ɓato ɓaa nkyisi isɔ ya mokyisi, oɓabuya ɓaekosi ɓanga, oɓaɓatisa na nkombo ya Tata, ya Ŋwana na ya Ɓɔlɔɓɔ. ");
INSERT INTO loq_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Oɓateya oɓokye ɓakumole mitindo mia ephɛkyɛ nga. Oeɓe oɓokye nali na ɓɛ̀ɛ nkɔlɔ isɔ tee nɔnɔ o suka ya mokyisi.»");
INSERT INTO loq_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Eye etatele ya Simo Elaa ya Yesu Klisto, iyo Ŋwana wa ya Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Moimosi Isaya akoma o buku pha Ŋwaphongo ɓoɓo: Ŋwaphongo yokye: «Kyeka! Namotoma tima ya nga o ɓoo pha wɛ. Amoeɓɔngyisa nzela. ");
INSERT INTO loq_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Moto mɔnɔmɔ kaaŋwane o bokye: Ɓɔngya nzela ya Nkolo! Omotɛyisa nsonga!» ");
INSERT INTO loq_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yoane aesi ya tɔkɔlɔ o bokye. Ateyaka ɓato, yokye: «Ɓɔngya mandondo ma ɓɛ̀ɛ, oɓatisame. Emba Ŋwaphongo amoelimbisa masumu ma ɓɛ̀ɛ.» ");
INSERT INTO loq_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ɓato ɓasɔ ɓa ekolo ya Yuda na ɓa mokyisi ŋwa Yelusalɛmɛ ɓakyɛkyɛ oka yɛ. Ɓaimolaka ɓoɓe pha ɓɛ́ɛ o miyo ma ɓato ɓasɔ. Ndokolo Yoane kambe ya ɓaɓatisa o maa ma ebale ya Yaladɛnɛ. ");
INSERT INTO loq_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yoane alataka etobu eyatongamaka na nkungyɛ ya nyama na nkombo «Shamo». Alataka na nkamba ya lopho la nyama o mobimbi nwɛ. Azaka ntɛtɛ, alɛtɛkyɛ na maɓoo. ");
INSERT INTO loq_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Aimolaka ɓato mɛ ɓoɓo: «Moto owamoya o sima ya nga andekyi na mwiya. Nga sikokyi imiinya o ɓoo phɛ oɓokye naingole nɔnɔ simbi ya bikoto ɓɛɛ. ");
INSERT INTO loq_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nga, naeɓatisa na maa, ka iyo amoeɓatisa na Ɓolɔɓɔ Ɓosanto.» ");
INSERT INTO loq_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Emba mi nkɔlɔ mɛ Yesu aesi yauta o mokyisi mɔnɔmɔ o manyɛtɛ ma Galileya, nkombo ya mokyisi mɛ Nazalɛtɛ. Aesi ya koma oka Yoane. Yoane aesi ya moɓatisa o eɓale ya Yaladɛnɛ. ");
INSERT INTO loq_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Sakɔkɔ, Yesu aesi ya londwa o maa. Okolondwe yo, awɛni ikolo si ziɓoo. Akuli wɛnɛ Ɓolɔɓɔ ɓomoutesi ndokolo inkoto-nwinya. ");
INSERT INTO loq_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Aokyi ŋwɛsi moute o ikolo mowɔ ɓoɓo: «Iwɛ, Ŋwana wa nga owa lozingo, nali na wɛ na nkyisa ɓoikye.» ");
INSERT INTO loq_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Sakɔkɔ, Ɓolɔɓɔ aesi ya kamba Yesu o bokye. ");
INSERT INTO loq_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Yesu aɓaka o bokye nkɔlɔ makoo mane. Omɔ, Molemba amumekaka. Ɓaanze ɓamosungaka. ");
INSERT INTO loq_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Waanyɔsa ɓɛ́ɛ Yoane o bɔlɔkɔ, Yesu aesi yakyɛ o manyɛtɛ ma Galileya, abuto ikyɛmimola Simo Elaa ya Ŋwaphongo, ");
INSERT INTO loq_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","aɓaka kakyɛmiwɔ yokye: «Uŋwaŋwa eye imbɛlɛ mɛ simbi yakoka. Ŋwaphongo awɛninye ɓokonzi phɛ. Ɓongola ntema ya ɓɛ̀ɛ, anola Simo Elaa ya Ŋwaphongo!» ");
INSERT INTO loq_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Mokɔlɔ mɔnɔmɔ Yesu aesi ya ɓanda o mokukulu ŋwa maa maanɛnɛ ma Galileya. Okoɓande yo, aesi ya wɛnɛ ɓaɔsi ɓa swe ɓaɓale, mankombo ma ɓɛ́ɛ Simo na ŋwana nyango Andele ɓavakye ɓondɛndi o maa. ");
INSERT INTO loq_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesu amba ya wɔ na ɓɛ́ɛ yokye: «Yambengye. Otokule ɓa ɓaɔsi ɓa swe, namoeɓuya ɓaɔsi ɓa ɓato phɔ ya Ŋwaphongo.» ");
INSERT INTO loq_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Sakɔkɔ, ɓaikyi ika mandɛndi ma ɓɛ, ɓamoɓengyi. ");
INSERT INTO loq_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yesu akuli susana na ŋwana o ɓoo. Aesi ya wɛnɛ Zake na Yoane, ɓana ɓa Zebede. Ɓaɓaka mi vato, ɓaɓambe mandɛndi ma ɓɛ. ");
INSERT INTO loq_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Sakɔkɔ Yesu aesi ya ɓaɓanga. Ɓaikyiika ango wa ɓɛ́ɛ Zebede o vato na ɓato ɓɛ́ɛ ɓaetoma, ɓaɓengyi Yesu. ");
INSERT INTO loq_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesu na ɓaekosi ɓɛ́ɛ ɓaesi ya kyɛndɛ o mokyisi muunɛnɛ ŋwa Kapalanauma. O mokɔlɔ moeme Ɓayuda, Yesu aesi ya nyɔlɔ o Ingambi sa makyita. Atati iteya. ");
INSERT INTO loq_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ɓato ɓakamwaka ioka iteya sɛ, phɔ aɓateyaka na ɓoekondo ɓosɔ. Taikaka ɓateya ndokolo ɓateye ɓa Miɓeko. ");
INSERT INTO loq_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Imbɛlɛ mɛ moto mɔnɔmɔ aesi ya nyɔlɔ o Ingambi sa makyita, aɓaka na ɓolɔɓɔ ɓoɓe, atati iaŋwana yokye: ");
INSERT INTO loq_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«Yesu wa Nazalɛtɛ, kolukye ilokyela ɓo? Oesi nde iya lounva? Naeyeɓe. Iwɛ moto Mosantu owa toma Ŋwaphongo.» ");
INSERT INTO loq_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesu aesi ya phaphala na ɓɔlɔɓɔ mɛ yokye: «Zala ɓose! Tɔkɔlɔ o nzoto ya moto oyo!» ");
INSERT INTO loq_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ɓɔlɔɓɔ ɓooɓe ɓoesi ya nyingyinya moto mɛ na ɓokusi. Ɓoesi ya aŋwana na ɓokusi, ɓotɔkosi o nzoto yɛ. ");
INSERT INTO loq_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ɓato ɓasɔ ɓaesi ya kamwa na ɓoikye. Nde ɓaɓona ɓabuto imituna, ɓɛkye: «Eye lowɔ ye? Kateya maphɔɔ manyakune na ɓoekondo. Katome na malɔɓɔ maaɓe, mamookye.» ");
INSERT INTO loq_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ŋwana ɓokyi ɓoɓo, sango ya Yesu yeesi ya nyangwa o nkyisi isɔ ya Galileya. ");
INSERT INTO loq_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ɓoɓɛlɛ, Yesu na Zake na Yoane ɓaesi ya mana o Ingambi sa makyita. Ɓaesi ya kyɛ o ingambi sa Simo na Andele. ");
INSERT INTO loq_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ɓɔɔ pha Simo owa ŋwaŋwasi amilangyaka phɔ aɓaka na mowɛwɛ. Okokome Yesu, ɓaesi ya moimola ɓolɔsi pha ŋwaŋwasi mɛ. ");
INSERT INTO loq_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yesu asusinye phɛnɛphɛ nɛ. Amophisi na eɓɔkɔ Amotɛyɛ. Mowɛwɛ moesi ya mana. Ŋwaŋwasi mɛ atati iɓakyelela. ");
INSERT INTO loq_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Waankɔkɔlɔ, ɓato ɓamba ya ikyela Yesu ɓato ɓasɔ ɓaaɓaka na biswɛtɛ na ɓaa malɔɓɔ maɓe. ");
INSERT INTO loq_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ɓato ɓasɔ ɓa mokyisi ŋwa Kapalanauma ɓaesi yaangana o ɓoo pha ingambi saaɓaka Yesu. ");
INSERT INTO loq_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Wamɔ, Yesu abikyaka ɓato ɓaikye na biswɛtɛ ndengye na ndengye. Atɔkɔlɔkɔ na malɔɓɔ maɓe maikye. Taikaka ɓenela oɓokye malɔɓɔ maɓe mawɔ phɔ malɔɓɔ maamana maeɓaka oɓokye ali Ŋwana wa Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Yana wa munkukutu, Yesu aesi ya umwa. Aesi ya tɔkɔlɔ o ingambi sa ɓaka ɓɛ. Aesi ya kyɛndɛ o elele eya ɓose. Omɔ, atati iɓɔndɛlɛ. ");
INSERT INTO loq_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simo na ɓɛbi ɓaaɓaka nɛ ɓamba ya kyɛ moluka. ");
INSERT INTO loq_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Okomozwe ɓɛ, ɓamba ya wɔ nɛ ɓɛkye: «Ɓato ɓasɔ ɓaaelukye.» ");
INSERT INTO loq_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Kasi Yesu yokye: «Yaka tokyɛndɛ! Tokyɛndɛ o nkyisi iiyɔkɔ ya phɛnɛphɛ, phɔ ya oɓokye nakyɛ teya Simo Elaa omɔ mɛ. Naesi nde phɔ ya etoma mɛ.» ");
INSERT INTO loq_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Nde ɓaɓona Yesu akyɛkyɛmitambula nkyisi isɔ ya Galileya, ateyaka o Mangambi masɔ ma makyita, atɔkɔlɔkɔ na malɔɓɔ maɓe maaɓaka onte ya ɓato. ");
INSERT INTO loq_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ɓoɓɛlɛ, moto mɔnɔmɔ wa maaɓa aesi ya kyɛ oka Yesu. Amba ya mokusamela. Amba ya moɓɔndɔ, yokye: «Ɓo ozingyi, okokyi imbikya.» ");
INSERT INTO loq_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesu amookyelaka ngɔngɔ, amba ya moelolela eɓɔkɔ, amba ya mokuma, yokye: «Nazingyi, bika!» ");
INSERT INTO loq_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Sakɔkɔ maaɓa mɛ maesi ya mana. Moto mɛ aesi ya bika. ");
INSERT INTO loq_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Yesu amba yawɔ nɛ na ɓokusi yokye: «Inzokye na ɓolaa, Saimola lowɔ lolo nɔnɔ moto mɔnɔmɔ. Kyɛndɛ nde oka nganga ya Ŋwaphongo. Omoteya nzoto ya wɛ. Oambya makaɓo ma ibika sa wɛ, ɓo wakoma ɓɛ́ɛ o buku pha Mose. Kyela ɓaɓona phɔ ɓato ɓaeɓe oɓokye obikyi phɛlɛ. Sima Yesu amba ya mobuya o ingambi sɛ.» ");
INSERT INTO loq_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Kasi naɓo ɓaɓona, moto mɔna abuto kakyɛmiimola mboka esɔ lowɔ lamokomelaka. Yango mɛna, Yesu takulaka miwɛninya na ɓato, aikalaka nde o elele eeteli ɓato. Emba ɓato ɓaakyɛkyɛmiuta mboka esɔ, ɓakyɛkyɛ oli yo. ");
INSERT INTO loq_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Sima ya ɓanaa nkɔlɔ, Yesu akuli butwa o Kapalanauma. Ɓato ɓaokyi oɓokye ali o ingambi saɓaka yo. ");
INSERT INTO loq_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ɓato ɓaikye ɓamba yaangana wamɔ. Malondo ma oɓokye ɓanyɔlɔ ɓɛ́ɛ ɓasɔ o ingambi mɛ temaɓaka. Na elele ya itɛmɛ o ɓoo pha moziɓo mwa ingambi teyaɓaka. Yesu aɓaka kaɓaimole Simo ya Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ikyeka ɓoɓo, ɓato ɓane ɓaesi ya moyelela na etuku. Ɓamophisi miitɔkɔ. ");
INSERT INTO loq_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Nzela ya oɓokye ɓamokomya oka Yesu teyaɓaka, phɔ ɓato ɓalɔɓɔkɔ. Ɓoɓɛlɛ, ɓamba ya baa o ikolo sa motɔndɔ ŋwa ndaku mɛ ŋwaa langyema. Ɓaesi ya ziɓola muna motɔndɔ o elele eyaɓaka Yesu. Ɓaesi ya uya moto mɛ mi sina itɔkɔ. ");
INSERT INTO loq_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesu aesi ya wɛnɛ oɓokye ɓato mɛ ɓali na ianola. Emba amba ya wɔ na etuku yokye: «Nwɛbi, masumu ma wɛ malimbisami.» ");
INSERT INTO loq_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ɓateye ɓa Miɓeko ɓaayɔkɔ ɓaɓaka wamɔ ɓaesi ya ɓomba maumunya mama o mandondo ma ɓɛ: ");
INSERT INTO loq_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Iyo nza oɓokye awɔ ɓaɓona? Eye nga kawambe nde Ŋwaphongo. Kyelimbisa masumu nde Ŋwaphongo!» ");
INSERT INTO loq_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Mina wamɔ Yesu aesi ya eɓa maumunya maaɓaka na ɓɛ, amba wɔ yokye: «Phɔ ya ye otondi na maumunya mamana? ");
INSERT INTO loq_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ɓo na wɔ na etuku oɓokye: “Masumu ma wɛ malimbisami”, na oɓokye “Tɛmɛ, kpa itɔkɔ sa wɛ, kyɛndɛ, lowɔ'ye loolɔbi ɓokusi?” ");
INSERT INTO loq_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Kasi nazingye oɓokye oeɓe oɓokye nga Ŋwana wa Moto nali na ɓokonzi pha ilimbisa masumu o mokyisi mumu.» Ɓoɓɛlɛ, Yesu amba ya wɔ na etuku yokye: ");
INSERT INTO loq_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«Nawɔ na wɛ ngakye: Tɛmɛ, kpa itɔkɔ sa wɛ, obutwe oka ɓɛ̀ɛ.» ");
INSERT INTO loq_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Sakɔkɔ, moto mɛ aesi ya tɛmɛ, akpe itɔkɔ sɛ, o miyo ma ɓato ɓasɔ abutoo. Ɓato ɓasɔ ɓakamwaka, ɓabutwaka ikumisa Ŋwaphongo, ɓɛkye: «Naino tolowɛni lowɔ la ndengye eye!» ");
INSERT INTO loq_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu amba kula ya kyɛmitambula o mokukulu ŋwa maa manɛnɛ ma Galileya. Ɓato ɓaikye ɓayakaka ya moɓenga, amba ya ɓateya. ");
INSERT INTO loq_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Waalekana yo, amba ya wɛnɛ moto mɔnɔmɔ, nkombo yɛ Lewi, ŋwana wa Alafa, azasi o elele ekyephutisa ɓɛ́ɛ mputi. Yesu amba ya wɔ nɛ yokye: «Imbengye!» Lewi aesi ya tɛmɛ, amoɓengyi. ");
INSERT INTO loq_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Emba Yesu amba yakyɛ zala o ingambi sa Lewi. Ɓaesi ya zaa wamɔ, yo na ɓaekosi ɓɛ̀ɛ na ɓaphutise ɓa mputi na ɓato ɓayɔkɔ ɓa masumu, phɔ ɓato ɓaamoɓengaka ɓaɓaka ɓaikye. ");
INSERT INTO loq_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ɓateye ɓa Miɓeko ɓaaɓaka o ingomba sa Ɓafalisayi ɓaesi ya tuna ɓaekosi ɓa Yesu ɓɛkye: «Phɔ ya'ye kaze na ɓaphutise ɓa mputi nana ɓato ɓa masumu?» ");
INSERT INTO loq_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu aesi ya ɓaoka ɓo kowɔ ɓɛ. Ndokolo kambe ya wɔ na ɓɛ́ɛ yokye: «Esengyesi na munganga nde ɓato ɓa malɔsi, kasi ɓato ɓaa nzoto nkusi phe. Naesi ya ɓanga nde ɓato ɓa masumu, siesi phɔ ya ɓato ɓa ɓosembo.» ");
INSERT INTO loq_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Mokɔlɔ mɔnɔmɔ, ɓaekosi ɓa Yoane Moɓatise na Ɓafalisayi ɓamiimaka ntoma. Ɓoɓɛlɛ, ɓato ɓasuu ɓaesi ya kyɛ tuna Yesu ɓɛkye: «Louti ɓo oɓokye ɓaekosi ɓa wɛ teɓaikyi miima ntoma?» Emiimi ntoma nde ɓaekosi ɓa Yoane na Ɓafalisayi. ");
INSERT INTO loq_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu amba ya ɓabuyisa yokye: «Okokyele ɓɛ́ɛ esɛlɛkɔ ya ɓolonga, ɓabutu ɓaɓangye ɓɛ, ɓamiime ntoma?» Ɓo molongyi ata ɓaa na ɓɛ́ɛ wamɔ, eteɓaamiime ntoma. Teli ɓomɔ! ");
INSERT INTO loq_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Kasi mokɔlɔ moli, ɓamoya manya molongyi, nde mokɔlɔ mɛ ɓaamiima ntoma. ");
INSERT INTO loq_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Moto taɓambe munyɛngu munyakune mi etobu ekasi. Ɓo phe, munyɛngu munyakune ŋwamowawola etobu eekasi, iluu samokula ingwa sinɛnɛ. ");
INSERT INTO loq_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Na moto tatɛyɛ malɛku maa swaswa mi mbongo eekasi. Ɓo phe, ɓo malɛku mɛ maulubi mamoɓola mbongo mɛ. Eɓe malɛku, eɓe mbongo, isɔ yamokyɛ phaa. Malɛku maa swaswa makokyi na mbongo eenyakune. ");
INSERT INTO loq_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Mokɔlɔ mɔnɔmɔ ŋwa Saɓata, Yesu alekanaka yo na ɓaekosi o manzabi ma ble. Ɓaekosi ɓɛ̀ɛ ɓatati ikyɛ minɔkɔ ble nzela nzela. ");
INSERT INTO loq_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ɓoɓɛlɛ, Ɓafalisayi ɓaesi ya wɔ na Yesu ɓɛkye: «Kyeka! Phɔ ya'ye ɓaekosi ɓa wɛ ɓakyele etoma mokɔlɔ ŋwa Saɓata?» Moɓeko ŋwa ɓanga temoɓenele ɓaɓona. ");
INSERT INTO loq_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesu amba ya ɓabuyisa yokye: «Toika tanga o buku pha Ŋwaphongo lowɔɔ laakyelaka Davidi? Waaɓaka yo na nzala, iyo na ɓato ɓaaɓaka nɛ. ");
INSERT INTO loq_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Aesi ya nyɔlɔ o Tempelo. Akyɛ zaa mapa maambyaka ɓɛ́ɛ oka Ŋwaphongo. O moɓeko ŋwa ɓanga, mapa mɛ maaze nde ɓanganga ɓɛ́ɛ na ɓɛ. Ka Davidi aesi ya kpa mapa mamana amaze. Aesi ya maphɛ na ɓato ɓaaɓaka nɛ. Minkɔlɔ mɛ Abiyatala aɓaka nganga eya o ɓoo ya ɓanganga ɓa Ŋwaphongo.» ");
INSERT INTO loq_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ɓoɓɛlɛ, Yesu akuli ya wɔ na ɓɛ́ɛ yokye: «Ŋwaphongo akyela mokɔlɔ ŋwa Saɓata phɔ ya ɓato, kasi taika kyela ɓato phɔ ya mokɔlɔ ŋwa Saɓata. ");
INSERT INTO loq_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Yango mɛna, ingaa, Ŋwana wa Moto nali Nkolo ya Mokɔlɔ ŋwa Saɓata.» ");
INSERT INTO loq_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ɓoɓɛlɛ, Yesu akuli yakyɛndɛ o Ingambi sa makyita. Moto mɔnɔmɔ owa ngɓatatala eɓɔkɔ aɓaka nɛ omɔ. ");
INSERT INTO loq_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ɓaphalisayi ɓayɔkɔ ɓaaɓaka wamɔ ɓakyekaka Yesu na biɓɛɛ ɓo amobikya moto mɛ mokɔlɔ ŋwa Saɓata. Ɓalukaka oɓokye ɓamosongyele. ");
INSERT INTO loq_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesu amba ya wɔ na moto owangbatatala eɓɔkɔ yokye: «Iŋwa, okyɛ tɛmɛ o ɓoo pha ɓato ɓasɔ.» ");
INSERT INTO loq_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Emba Yesu amba ya tuna ɓato ɓaɓaka ɓamokyekye, yokye: «Moɓeko ŋwa ɓanga mowɔ ɓo, phɔ ya mokɔlɔ ŋwa Saɓata? Ikyela ɓolaa na ikyela ɓoɓe, elaa'ye? Ibikya moto na iɓoma moto, elaa'ye?» Ɓɛ́ɛ ɓasɔ teɓazwaka na lowɔɔ la ibuya. ");
INSERT INTO loq_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Na ena yɔɔ mɛ, Yesu aesi ya ɓakyeka. Aɓaka na ná ngɔngɔ phɔ ya maumunya maaɓe ma ɓɛ. Ɓoɓɛlɛ, Yesu aesi ya wɔ na moto mɛ yokye: «Elola eɓɔkɔ ya wɛ!» Waaelola yo eɓɔkɔ ɓoɓo, ikyeka, eɓɔngyi. ");
INSERT INTO loq_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ɓaphalisayi ɓaesi ya tɔkɔlɔ o Ingambi sa makyita. Ɓakyɛ angana ikɔlɔ na ɓato ɓaaka Mokonzi Elode. Ɓalukaka malondo ma iɓoma Yesu. ");
INSERT INTO loq_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Lɔlɔ eye Yesu akuli kyɛ na ɓaekosi ɓɛ̀ɛ phɛnɛphɛ na maa manɛnɛ ma Galileya. Ɓato ɓaikye ɓaesi ya moɓenga. Ɓato mɛ ɓautaka o manyɛtɛ ma Galileya, o manyɛtɛ ma Yuda na o Yelusalɛmɛ. ");
INSERT INTO loq_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ɓaayɔkɔ ɓautaka o manyɛtɛ ma Idume, o mokukulu ŋwa ebale ya Yaladɛnɛ, o nkyisi ya phɛnɛphɛ na manyɛtɛ ma Tula na ma Sidona. Ɓato mɛ ɓaikye ɓaokaka yaakyelaka Yesu. Yango mɛnɛ ɓaesi yakyɛ oka yɛ. ");
INSERT INTO loq_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ɓoɓɛlɛ, Yesu aesi ya toma ɓaekosi ɓɛ̀ɛ oɓokye ɓamolukyele vato phɔ ɓato ɓɛ́ɛ sa mokatitisa. ");
INSERT INTO loq_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Yesu awɔkɔ ɓaɓona phɔ abikyaka ɓato ɓaikye, ɓato ɓasɔ ɓaamalɔsi ɓawelanaka ikyɛmokuma. ");
INSERT INTO loq_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Waawɛnɛ ɓato ɓaɓaka na malɔɓɔ maɓe Yesu, ɓakyɛkyɛ mivaka o makolo mɛ. Ɓabutwaka ɓaaŋwane ɓɛɛkye: «Iwɛ, oli Ŋwana wa Ŋwaphongo!» ");
INSERT INTO loq_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Kasi Yesu amba katela ɓato mɛ, yokye: «Sanzebinya!» ");
INSERT INTO loq_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ɓoɓɛlɛ, Yesu amba yakyɛ baa o ngomba, amba ya ɓanga ɓato ɓaazingaka yo. Ɓɛ́ɛ ɓaesi ya kyɛ oka yɛ. ");
INSERT INTO loq_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Aesi ya ɔlɔ ɓato iko mbuka ɓaɓale, ɓaatangaka yo ɓatoma. Yesu aɓaɔlɔkɔ oɓokye ɓaɓee nɛ elele yɔnɔyɔ, oɓokye aɓatome ikyɛmiteya, ");
INSERT INTO loq_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","na oɓokye aɓaakyisa mwiya ŋwa itɔkɔlɔkɔ malɔɓɔ maɓe. ");
INSERT INTO loq_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ɓato iko mbuka ɓaɓale mɛ, yaɓaka: Simo (Yesu amophɛkyɛ nkombo ya Petelo), ");
INSERT INTO loq_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zake na Yoane waɓɛ ango, Zebede (Yesu aɓaphɛkyɛ nkombo ya Ɓɔnɛlɛgɛsi, kyelimbole oɓokye: Ɓana ɓa nkakye), ");
INSERT INTO loq_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andele, Philipe, Ɓatelemi, Matiye, Toma, Zake (ŋwana wa Alafa), Taade, Simo owamiambyaka phɔ ya ɓosɔmi pha ekolo yɛ, ");
INSERT INTO loq_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","na Yuda Mokeliyota, owamungya Yesu. ");
INSERT INTO loq_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ɓobɛlɛ, Yesu akuli butwa o ingambi. Ɓato ɓaikye ɓakuli yaangana, malondo ma oɓokye Yesu na ɓaekosi ɓɛ̀ɛ ɓaze temali. ");
INSERT INTO loq_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ɓanaa nyango na Yesu ɓaesi yaoka simo mɛ. Ɓamba ya kyɛndɛ oɓokye ɓakyɛ mokpa, phɔ ɓato ɓawɔkɔ ɓɛkye: «Abuto ndokolo elemele!» ");
INSERT INTO loq_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Uŋwaŋwa eye ɓateye ɓa Miɓeko ɓautaka o Yelusalɛmɛ ɓawɔkɔ ɓɛkyɛ: «Molemba amunyɔsi, katɔkɔlɔ malɔɓɔ maɓe o nzoto ya ɓato nde na mwiya ŋwa Bɛlɛzebula, mokonzi ŋwa malɔɓɔ maɓe.» ");
INSERT INTO loq_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ɓoɓɛlɛ, Yesu amba ya ɓanga ɓato ɓasɔ. Amba ya ɓawɔlɛ na bite yokye: «Teɓakokyi itɔkɔlɔ Molemba na mwiya ŋwa Molemba. ");
INSERT INTO loq_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ɓo ɓato ɓa mokyisi mɔnɔmɔ ɓaŋwane ɓɛ́ɛ na ɓɛ, mokyisi mɛ etemookɔkɔ. ");
INSERT INTO loq_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ɓo ɓato ɓa iɓota sɔnɔsɔ ɓaŋwane ɓɛ́ɛ na ɓɛ, iɓota mɛ etesiikɔkɔ. ");
INSERT INTO loq_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ka ɓo ɓokonzi pha Molemba ɓomikabinye, ɓokonzi mɛ ete ɓookɔkɔ. ");
INSERT INTO loq_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Moto takokyi inyɔlɔ o ingambi sa moto oli na nkamba phɔ akyɛ iɓa mbolo yɛ, ɓo naino moto mɛ teɓamoɓakyi maphanga. Elaa atamoɓaka maphanga phanza, amba iɓa mbolo yɛ isɔ.» ");
INSERT INTO loq_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","«Nde phɛlɛ na wɔ na ɓɛ̀ɛ ngakye: Ŋwaphongo amolimbisa masumu masɔ maakyele ɓato, na maphɔɔ masɔ maatole ɓato nkombo yɛ. ");
INSERT INTO loq_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Kasi moto ookotole Ɓolɔɓɔ Ɓosanto, kakyele isumu sitesiilimbisa Ŋwaphongo. Isumu mɛ samoikala nde ɓoɓɛlɛ.» ");
INSERT INTO loq_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu awɔkɔ na ɓɛ́ɛ ɓoɓo, phɔ ɓɛ́ɛ ɓaɓaka ɓawɔ ɓɛkyɛ: «Ɓolɔɓɔ ɓoɓe ɓonyɔlɛsi Yesu.» ");
INSERT INTO loq_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ɓoɓɛlɛ, nyango wa Yesu na ɓana ɓɛ́ɛ ɓa ɓampele, ɓaesi oka Yesu. Ɓamba ya tɛmɛ o iɓanda. Ɓamba ya toma moto oɓokye aɓaɓangyele Yesu. ");
INSERT INTO loq_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ɓato ɓasɔ ɓaazalaka nɛ wamɔ, ɓamolungyaka. Ɓamba ya wɔ nɛ ɓɛkyɛ: «Kyeka! Nyɔngɔ na ɓanaa nyɔngɔ ɓatɛmi o iɓanda ɓaelukye.» ");
INSERT INTO loq_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesu amba ya ɓabuyisa yokye: «Mama eli nza? Ɓanaa mama eli ɓanza?» ");
INSERT INTO loq_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ɓoɓɛlɛ, Yesu amba ya kyeka ɓato ɓazalaka nɛ amba ya wɔ yokye: «Kyeka mama na ɓanaa mama, ɓɛ́ɛ ɓaɓa. ");
INSERT INTO loq_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Phɔ moto okokyele maphɔɔ mazingye Ŋwaphongo, yo ŋwana mama owa lele, yo nkanasa ya nga, yo mama.» ");
INSERT INTO loq_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu akuli butwa iteya ɓato o mokukulu ŋwa maa maanɛnɛ ma Galileya. Ɓato ɓaikye ɓaesi yaangana waali yo, emba Yesu amba ya kyɛ zala o vato. Vato mɛ phaɓaka o maa, emba ɓato ɓaɓaka o mokukulu. ");
INSERT INTO loq_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Aɓaka kateya maphɔɔ maikye na bite. Amba ya ɓateya yokye: ");
INSERT INTO loq_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Okyemela! Mokɔlɔ mɔnɔmɔ, moto mɔnɔmɔ akyɛkyɛ o inzabi oikyɛ minyaka ndemo oɓokye itɔkɔlɔ. ");
INSERT INTO loq_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Waanyaka yo ndemo o inzabi, ndambo iesi yakaa o nzela, manyɔsi maesi ya kyɛ iikomola. ");
INSERT INTO loq_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ndambo eyɔkɔ iesi yakaa o manyɛtɛ maa maɓanga, wamɔ manyɛtɛ maikye phe. Sakɔkɔ ndemo miina iesi ya tɔkɔlɔ phɔ teyaika zwa manyɛtɛ maikye wamɔ. ");
INSERT INTO loq_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Waa manzanga, ndemo mɛ iesi ya nyita, iungyi phɔ teyaikaka ɓa na ya kolo nkanga. ");
INSERT INTO loq_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ndambo esuu ya ndemo iesi yakaa o nte ya nkata ya milɔ. Nkata ya milɔ miina iesi ya kola, yuɓye ina ndemo emba teyaamba ɓota. ");
INSERT INTO loq_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Kasi ndemo nsuu mɛ iesi yakaa o manyɛtɛ malaa, iesi ya tɔkɔlɔ, ikosi, iɓoti. Iiyɔkɔ iɓoti mbuma mako maato, iiyɔkɔ mako motoba, iiyɔkɔ munkama.» ");
INSERT INTO loq_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Emba Yesu amba kula wɔ na ɓɛ́ɛ yokye: «Moto oli na matoo ma ioka, aokye!» ");
INSERT INTO loq_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ɓoɓɛlɛ, Yesu aesi ya ika ɓato ɓaaɓana o mokukulu. Waaɓaika yo, ɓaekosi iko mbuka ɓaɓale na ɓaayɔkɔ ɓaaɓaka phɛnɛphɛ nɛ ɓaesi ya motuna ɓɛkye aɓaimole ntina ya bite mɛ. ");
INSERT INTO loq_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Amba ya wɔ na ɓɛ́ɛ yokye: «Ŋwaphongo aeteye, ɓɛ̀ɛ ɓaɓa, sekyele ya Ɓokonzi phɛ. Ɓato ɓasuu ɓaokye nde na bite. ");
INSERT INTO loq_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Yango mɛna wakomama ɓoɓo: “Naɓo ɓakyekye na ɓolaa, teɓaawɛnɛ na ekpele. Naɓo ɓaokye na ɓolaa, kasi teɓaasɔsɔlɔ, ɓo phe nde ɓaɓongolakyi mandondo ma ɓɛ, emba Ŋwaphongo nde aɓalimbisakyi!”» ");
INSERT INTO loq_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ɓoɓɛlɛ, Yesu amba ya wɔ na ɓɛ́ɛ yokye: «Ɓo ɓɛ̀ɛ toeɓe ntina ya ete mɛna? Emba waamba eɓa ntina ya bite bisuu ndengye'ye? ");
INSERT INTO loq_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Mophikyi ndemo ali ndokolo moto okoteya iloɓa sa Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ɓato ɓayɔkɔ ɓali ndokolo nzela. Simo ya Ŋwaphongo yakyɛkyɛ kaa wamɔ. Ɓaokyi Simo mɛ. Oeyokyi ɓɛ, Molemba aesi ya emanya o mandondo ma ɓɛ. ");
INSERT INTO loq_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ɓato ɓayɔkɔ ɓakokaa na ndemo iikaa o manyɛtɛ maangana na maɓanga: Wa okye ɓɛ́ɛ iloɓa sa Ŋwaphongo, ɓasanosi izele na nkyisa. ");
INSERT INTO loq_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Kasi iloɓa mɛ te saika nyɔsɛ nkanga o mandondo ma ɓɛ, ɓaanole nde ŋwana imbɛlɛ mokuwe. Kasi ɓo nkaka na minyɔkɔ yeesi phɔ ya sina iloɓa sa Ŋwaphongo, ɓalɛ ianola sa ɓɛ́ɛ izele. ");
INSERT INTO loq_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ɓato ɓayɔkɔ ɓali ndokolo ndemo iikaa o nkata yaa milɔ: Ɓaokyi maloɓa ma Ŋwaphongo, ");
INSERT INTO loq_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","kasi maumunya ma mokyisi mumu, phowa ya ezwele ekye kosa ɓato, na maumunya masuu ndengye na ndenge maɔtɔ sina iloɓa, emba tesiiɓote. ");
INSERT INTO loq_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Kasi ɓato ɓasuu ɓali ndokolo ndemo ikaa o manyɛtɛ maala: Ɓaokyi maloɓa ma Ŋwaphongo, ɓamaanosi emba ɓaɓoti mbuma iindaa, iiyɔkɔ mako maato, iiyɔkɔ mako motoɓa, iiyɔkɔ munkama.» ");
INSERT INTO loq_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ɓoɓɛlɛ Yesu amba ya wɔ na ɓɛ́ɛ yokye: «Ɓo moto aesi na tala, amoekukya na katini nde amoetɛyɛ o se ya ntangye? Kasi amoetɛya o ikolo sa mesa. Teli ɓomɔ? ");
INSERT INTO loq_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Maphɔɔ masɔ maaɓombama mamotɔkɔlɔ, na maphɔɔ masɔ ma enzɔmbi mamowɛnɛnɛ saa. ");
INSERT INTO loq_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Moto oli na matoo ma ioka, aokye!» ");
INSERT INTO loq_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yesu akuli wɔɔ na ɓɛ́ɛ yokye: «Nde kokyeɓe na maphɔɔ maeyimole nga. Nde ɓokokyele ɓɛ̀ɛ ɓɛbi, Ŋwaphongo amoekyela nde ɓomɔ mɛ. Amba kula ekyela na koleka. ");
INSERT INTO loq_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Moto ooli na mbolo nzikye ɓamokula mophɛ nsuu. Moto ooli pha, ɓaamoɓɔlɔlɔ nɔnɔ ŋwana ndambo ooli nɛ.» ");
INSERT INTO loq_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu akuli wɔ yokye: «Ɓokonzi pha Ŋwaphongo ɓoli ndokolo moto mɔnɔmɔ anyakaka ndemo o inzabi sɛ. ");
INSERT INTO loq_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Na mokɔlɔ, wa lale yo na ná moo wakyɛmitambula yo, ndemo kyitɔkɔlɔ, kyikole. Moto mɛ taikaka eɓa ɓo wakolaka yango. ");
INSERT INTO loq_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Eli nde manyɛtɛ maakosaka ndemo. Phanza kyetɔkɔlɔ iɓɔngyi, sima kyembe ya tɔkɔlɔ munkoloko, o suka kyembe ya ɓota maɓɔtu na ɓolaa. ");
INSERT INTO loq_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ble eesi yaola. Waaola mbuma, moto mɛ akyɛ nɔkɔ phɔ mbunu ya inɔkɔ yakokaka.» ");
INSERT INTO loq_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu akuli ya wɔ yokye: «Ekpele'ye elongoɓa na Ɓokonzi pha Ŋwaphongo? Tomokpa ete'ye phɔ ya ilimbola Ɓokonzi pha Ŋwaphongo? ");
INSERT INTO loq_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ɓokonzi pha Ŋwaphongo pha ulana na mumbuma mwa mutardɛ. Ɓo ɓakyɛ ɛmophika, mumbuma maamuna, molekyi isɔ yaamokyisi na ɓokyikyi. ");
INSERT INTO loq_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Sima moesi ya kola, moombe ya leka ndemo isɔ na ɓonɛnɛ. Moombe ya tɔkɔlɔ bitakyi binɛnɛ. Manyɔsi mamotonga mooɓo ma ɓɛ́ɛ o ɔɔmɛlɛ ya ŋwete mɛ.» ");
INSERT INTO loq_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Nde ɓaɓona Yesu ateyaka ɓato Simo ya Ŋwaphongo na bite biikye bya ndengye eye. Aɓateyaka na ndengye eekokyi na ɓɛ́ɛ ioka. ");
INSERT INTO loq_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","O mateya mɛ taikaka lɛɛ iɓakpela bite. Kasi waaɓaka yo kaikale na ɓaekosi ɓɛ́ɛ yo mampenza aɓalimbolelaka nde bite mɛ bisɔ. ");
INSERT INTO loq_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Mokɔlɔ maamuna bunya ɓoesi ya inda. Okoinde bunya, Yesu aesi ya wɔ na ɓaekosi ɓɛ́ɛ yokye: «Toakale o mokukulu ŋwa maa ŋwaa bina.» ");
INSERT INTO loq_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Yesu azalaka o vato. Ɓaekosi ɓaesi ya kyɛndɛ nɛ o vato ɓaɓona. Mato masuu maɓaka wamɔ mɛ. Ɓaikaka ɓato ɓasɔ ɓaaɓaka wamɔ. ");
INSERT INTO loq_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ɓoɓɛlɛ, ewɛlɛ ekusi yamba ya kyela. Kanda yanyɔsaka maa o motema ŋwa vato. Vato ɓaɓona phatataka itonda na maa. ");
INSERT INTO loq_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesu aɓaka o mbolo eya sima ya vato. Alangyaka moto nwɛ o ikolo sa mungbɛlɛngɔ, alasi ebuu. Ɓaekosi ɓɛ̀ɛ ɓaamba ya moumola miebu mɛna, ɓɛkyɛ: «Towee! Towee! Toli na maumunya phɔ ya ɓanga?» ");
INSERT INTO loq_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesu amba ya umwa, amba ya wɔ na ewɛɛlɛ na ná maa na ɓokusi yokye: «Ikala ɓose!» Ɓoɓɛlɛ, ewɛɛlɛ eesi yaunva. Emba maa mamba yaikala ena phioo! ");
INSERT INTO loq_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Akuli wɔ na ɓaekosi yokye: «Bɛ koile phɔ ya'ye? Ɓɛ̀ɛ naino toanosi?» ");
INSERT INTO loq_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ɓaekosi ɓawɛnɛkyɛ inganga siikye, ɓawɔnɔkɔ ɓɛkyɛ: «Moto oyo ali nde nza? Na maa na ewɛɛlɛ kyimotosa!» ");
INSERT INTO loq_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ɓoɓɛlɛ, Yesu na Ɓaekosi ɓɛ̀ɛ ɓaesi ya koma o mokukulu mɛ o manyɛtɛ ma Ɓagelaza. ");
INSERT INTO loq_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yesu aesi ya aphwa. Okoaphwe yo, moto mɔnɔmɔ atɔkɔsi o malita. Aesi ya vana nɛ. Ɓolɔɓɔ ɓoɓe phanyɔlɔkɔ o nzoto ya moto mɛ. ");
INSERT INTO loq_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Abutwaka izala o malita. Ɓato teɓakulaka koka imoɓaka maphanga, eɓe na munyɔlɔlɔ. ");
INSERT INTO loq_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Soosoo ɓamokangye maɓɔkɔ na makolo na munyɔlɔlɔ. Nzuka moto mɛ aɓaka kabile muna munyɔlɔlɔ. Moto na mɔnɔmɔ takokaka imozibisa. ");
INSERT INTO loq_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Na moo na mokɔlɔ aɓaka katambule o malita na o ngomba. Mbala isɔ aɓaka kaaŋwane nzanga, aɓaka kamizokya na ná maɓanga. ");
INSERT INTO loq_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Mɛna Yesu ataa ɓaa itakye, ambo mowɛnɛ. Aesi ya kyilingana. Akyɛ mokusamela na maɓɔngɔ. ");
INSERT INTO loq_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Amba yaaŋwana na ɓokusi yokye: «Yesu, Ŋwana wa Ŋwaphongo owa ikolo, kolukye inkyela ɓo? Naongyi na wɛ o ɓoo pha Ŋwaphongo, sa nvɛninya mpasi!»  ");
INSERT INTO loq_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Awɔkɔ ɓoɓo phɔ Yesu aɓaka kawɔ yokye: «Ɓolɔɓɔ ɓoɓe, tɔkɔlɔ o nzoto ya moto oyo.» ");
INSERT INTO loq_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yesu amba kula tuna moto mɛ yokye: «Nkombo ya wɛ nza?» Aesi ya mobuyisa yokye: «Nkombo ya nga, Ekonzo, phɔ ɓanga toli ɓaikye.» ");
INSERT INTO loq_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Aongaka Yesu na ɓokusi oɓokye satoma malɔɓɔ maɓe mama o mokyisi mosuu. ");
INSERT INTO loq_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","O ngomba mɛ yaɓaka wamɔ, ɓokanda pha mangulu, phaɓaka ɓokyɛmiwaa. ");
INSERT INTO loq_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Malɔɓɔ mamba ɓɔndɛlɛ Yesu ɓoɓo: «Olotome onte ya mangulu mamana, tokyɛ nyɔlɔ o nzoto ya mango.» ");
INSERT INTO loq_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesu amba ya maphɛ nzela. Ɓoɓɛlɛ, malɔɓɔ maɓe mamana maesi yatɔkɔlɔ oka moto mɛ. Maesi ya kyɛ nyɔlɔ o mangulu mamana. Ɓokanda ɓosɔ phaɓaka phɛnɛphɛ na mangulu nkoto iɓale. Mangulu maesi ya uta ngomba, maesi ya kyilingana nɔnɔ o maa. Mabutwaka ikyiɓa maa, mamba ya waa. ");
INSERT INTO loq_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ɓaɓanze ɓa mangulu ɓaaɓaka wamɔ, ɓaesi ya lota, ɓakyɛ imola o lombo nɔnɔ o manganda. Ɓato ɓaesi ya kyɛ kyeka lowɔɔ mɛ lalekanaka. ");
INSERT INTO loq_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ɓaesi ya koma oka Yesu. Ɓawɛni moto mɛ owaɓaka na malɔɓɔ maɓe azasi, alati bitobu, aɓɔngyi. Waamowɛnɛ ɓɛ, ɓato mɛ ɓawɛnɛkyɛ ɓɔɓɔ. ");
INSERT INTO loq_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ɓato ɓaawɛnɛkyɛ maphɔɔ mɛ masɔ, ɓaesi ya ɓaimola maphɔɔ ma moto owa malɔɓɔ maɓe na ma mangulu. ");
INSERT INTO loq_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ɓoɓɛlɛ, ɓato ɓaaokaka maphɔɔ mɛ ɓaesi ya wɔ na Yesu oɓokye amane o manyɛtɛ ma ɓɛ. ");
INSERT INTO loq_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesu akyɛ kpela o vato. Okokpele yo, moto owaɓaka na malɔɓɔ maɓe aesi yaonga na Yesu yokye: «Bo ozingyi, nakyɛndɛ na wɛ.» ");
INSERT INTO loq_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yesu alɛ, amba wɔ yokye: «Butwa oka ɓɛ, o iɓota sa wɛ, okyɛ ɓaimola isɔ iyekyelesi Nkolo na ngɔngɔ yɛ.» ");
INSERT INTO loq_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Emba moto mɛ amba yakyɛ. Atati ikyɛmiimola o nkyisi yaaɓaka omɔ na nkombo Dekapolis. Aimolaka isɔ yaakyelaka Yesu phɔ yɛ. Ɓato ɓasɔ, ɓaamookaka, ɓakamwaka. ");
INSERT INTO loq_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu akuli akala na vato o mokukulu ŋwaaɓaka yo. Ɓato ɓaikye ɓaesi yaangana wali yo. Mɛna ataa ɓa o ibongu, ɓaesi ya molungya. ");
INSERT INTO loq_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Mɔnɔmɔ na Ɓaangyesi ɓa Ingambi sa makyita aesi ya koma. Nkombo yɛ Yailo. Aesi ya wɛnɛ Yesu. Amba ya mivaka o makolo mɛ. ");
INSERT INTO loq_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Amba ya nyingonela nɛ yokye: «Ŋwana wa nga wa ŋwaŋwasi kawe. Tokyɛ oka nga, okyɛ kyela maɓɔkɔ o ikolo sa nzoto yɛ oɓokye yo sawaa, abikye.» ");
INSERT INTO loq_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ɓoɓɛlɛ, Yesu aesi ya kyɛ nɛ nzela yɔnɔyɔ. Ɓato ɓaikye ɓakyɛkyɛ nɛ ewawaka. Ɓamokatitisaka na mbale na mbale. ");
INSERT INTO loq_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ŋwaŋwasi mɔnɔmɔ aɓaka na ɓɛ. Aɓaka na ɓolɔsi pha malongo, pha kɔkɔ nɛ mambula iko mbuka iɓale. ");
INSERT INTO loq_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Akomaka o maɓɔkɔ ma ɓamiinganga ɓaikye. Abungyaka ɓaphalanga ɓɛ́ɛ ɓasɔ. Taikaka bika. Ɓolɔsi ɓokule ngala nde ɓongasi. ");
INSERT INTO loq_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Aokaka simo ya Yesu. Aumunyaka o ndondo yɛ yokye: «Ɓo nakyɛ kuma nɔnɔ bitobu ɓɛ̀ɛ, nde nabikyi.» Aesi ya moɓenga na ikyɛmiphaka onte ya ɓato ɓaɓana nɔnɔ wakoma yo o sima yɛ. Aesi ya kuma etobu ya Yesu. ");
INSERT INTO loq_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Mina wamɔ malongo maesi ya tenya. Aesi ya wɛnɛ o nzoto yɛ oɓokye abikyi na ɓolɔsi mɛ. ");
INSERT INTO loq_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Nde wamɔ, Yesu aesi ya mioka onte yɛ oɓokye ndambo ya mwiya nwɛ motɔkɔsi. Aesi ya miekpinya o ntante ya ɓato, yokye: «Oonkumi o bitobu ɓa nga nza?» ");
INSERT INTO loq_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ɓaekosi ɓɛkyɛ: «Aaa! Owɛni oɓokye ɓato ɓaekatitise na mbale na mbale, kokule tuna: “Onkumi nza?”» ");
INSERT INTO loq_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Kasi Yesu aesi ya kyeka na mbale na mbale oɓokye aeɓe moto omokumi. ");
INSERT INTO loq_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ŋwaŋwasi mɛ aɓaka katɛkyɛnɛlɛ na sina inganga, phɔ aeɓaka lowɔɔ lamokomelaka o nzoto yɛ. Aesi ya mokusamela. Ɓoɓɛlɛ, aesi ya moimola phɛlɛ phɛlɛ maphɔɔ masɔ maaɓaka nɛ. ");
INSERT INTO loq_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesu amba ya wɔ nɛ yokye: «Mama, ɓoanosi wɛ, obikyi. Eɓe nde ɓomɔ. Kyɛndɛ na ɓolaa.» ");
INSERT INTO loq_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Waaɓaka Yesu kawɔ ɓaɓona, ɓato ɓauti o ingambi sa Moangyesi mɛ, Yailo. Ɓaesi ya wɔ ɓɛkyɛ: «Ŋwana wa wɛ awe. Kokule nyɔkɔlɔ Moteye phɔ ya'ye?» ");
INSERT INTO loq_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Nzuka Yesu aokaka maphɔɔ mawɔkɔ ɓɛ. Amba ya wɔ na Moangyesi wa Ingambi sa makyita mɛ yokye: «Sakula ila! Anola ndee to!» ");
INSERT INTO loq_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yesu taikaka ɓenela ɓato ɓasuu ikyɛndɛ nɛ. Aanolaka nde Petelo, Zake na ŋwana nyango Yoane. ");
INSERT INTO loq_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ɓaesi ya koma o ingambi sa Moangyesi mɛ. Yesu awɛni oɓokye ɓakyɛmi mivaka, ɓalele na ngɔngɔ, ɓaaŋwane. ");
INSERT INTO loq_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Aesi ya nyɔlɔ o ingambi. Aesi ya wɔ na ɓɛ́ɛ yokye: «Ikyɛmi mivaka na ilelo sisi sa lowɔɔ'ye? Ŋwana wa ɓɛ̀ɛ taikyi waa. Alasi nde ebuu.» ");
INSERT INTO loq_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ɓaaelesi ɓaesi ya moɛkyɛ. Emba Yesu aesi ya ɓatɔkɔlɔ ɓɛ́ɛ ɓasɔ o nzee. Akyɛ na ango na nyango na ɓaaɓaka nɛ. Ɓamba ya nyɔlɔ o motema ŋwa ingambi o elele eyalangyaka ɓɛ́ɛ ŋwana. ");
INSERT INTO loq_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yesu amba ya phila ŋwana mɛ mi eɓɔkɔ yokye: «Talita kumi!» kyeimole oɓokye: «Ŋwana ngɔndɔ, umwa!» ");
INSERT INTO loq_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Mina wamɔ, ŋwana ngɔndɔ mɛ — aɓaka na mambula iko mbuka iɓale —, amba ya tɛmɛ. Abuto itambula. Ɓaaɓaka nɛ wamɔ, ɓakamwaka nde ɓokamo. ");
INSERT INTO loq_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesu awɔkɔ na ɓɛ́ɛ na ɓokusi yokye: «Moto saimola moto lowɔ lalona, amba ya wɔ na ɓɛ́ɛ yokye ɓamophɛ na ntoma azee.» ");
INSERT INTO loq_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu na ɓaekosi ɓɛ́ɛ ɓaesi ya mana o elele mɛ, ɓaesi ya kyɛndɛ o Nazalɛtɛ mokyisi ŋwa kolaka yo. ");
INSERT INTO loq_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","O mokɔlɔ ŋwa Saɓata, aɓaka kateya o Ingambi sa makyita. Ɓato ɓaikye ɓaamookaka, ɓakaŋwaka, ɓamitunaka ɓɛkye: «Phɔ iye aizwe bi? Malondo ma zwe yo mama mauti bi? Kakyele na bilekyesako bibi ndenge'ye? ");
INSERT INTO loq_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Eye ka mowasi wa maɓaya, ŋwana wa Maliya, ɓola pha Zake na Zoze na Yudasi na Simo. Na ɓasii ɓɛ́ɛ ɓaa ɓaɓasi ka ɓali na ɓanga wawa.» Yango mɛna ɓalɛkyɛ imoanolela. ");
INSERT INTO loq_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesu amba yawɔ na ɓɛ́ɛ yokye: «Moimosi wa Ŋwaphongo ɓamokumole nde o nkyisi nsuu, manya o mokyisi nwɛ mampenza, na o iɓota sɛ na oka ɓanaa nyango.» ");
INSERT INTO loq_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Yesu taikaka koka ikyela nɔnɔ elekyesako yɔnɔyɔ eenɛnɛ omɔ, manya nde ndambo ya ɓato ɓa malɔsi ɓaatandelaka yo maɓɔkɔ, ɓaabikyaka yo. ");
INSERT INTO loq_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Akamwaka na ɓoikye phɔ ya ɓato ɓa Nazalɛtɛ teɓaikaka ɓa na ianola. Emba Yesu amba yakyɛmiteya o nkyisi yaa mambale. ");
INSERT INTO loq_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Aesi ya ɓanga ɓaekosi iko mbuka ɓaɓale, atati iɓatoma ikyɛmiteya ɓaɓale ɓaɓale. Aɓaphɛ na ɓokonzi pha itɔkɔlɔ malɔɓɔ maɓe. ");
INSERT INTO loq_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Aɓakatelaka yokye: «Ɓo wamokyɛndɛ ɓɛ̀ɛ o imbanga ɓoɓo, ɓɛ̀ɛ saphila ekpele esuu, eɓe ntoma, eɓe ikuɓa, eɓe na ɓaphalanga, ophilaka nde ntuu. ");
INSERT INTO loq_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ɓɛ̀ɛ salata bitobu biɓale, kolate nde etobu yɔnɔyɔ na bikoto.» ");
INSERT INTO loq_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Yesu ambakula ya wɔ na ɓɛ́ɛ yokye: «Ɓo okomi o mokyisi mɔnɔmɔ, oɓaka nde o ingambi sa moelasa ɓɛ́ɛ nɔnɔ mokɔlɔ ŋwa mokyɛndɛ ɓɛ̀ɛ o mokyisi mosuu. ");
INSERT INTO loq_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ka ɓo ɓato ɓa mokyisi mɔnɔmɔ ɓalɛɛ iekumbela, ɓalɛɛ na iyeyoka, lekana mokyisi mɛ, ɔlɔlɔ ngonza phɔ ya iɓateya ɓoɓe ɓookyesi ɓɛ.» ");
INSERT INTO loq_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ɓoɓɛlɛ ɓaekosi ɓamba yakyɛmiimola ɓato oɓokye ɓaɓongole ntema ya ɓɛ. ");
INSERT INTO loq_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ɓatɔkɔlɔkɔ na malɔɓɔ maɓe miikye. Ɓaingaka na ɓato ɓaikye ɓa malɔsi mauta, ɓaɓabikyaka. ");
INSERT INTO loq_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Nkɔlɔ mɛ, Mokonzi Elode amba yaoka Simo ya Yesu phɔ ngambo yɛ ya tambulaka nkyisi isɔ. Ɓana ɓɛkye: «Eye eli nde Yoane Moɓatise akundo! Yango mɛna ali na phɛmbɔ ya ikyela bilekesako ɓabina.» ");
INSERT INTO loq_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Kasi ɓayɔkɔ ɓawɔkɔ ɓɛkye: «Eli moimosi Eliya.» Ɓasuu ɓayɔkɔ ɓɛkye: «Ali moimosi ndokolo ɓaimosi ɓaa phanza.» ");
INSERT INTO loq_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Waaoka Elode ziko sa ɓato, amba ya wɔ yokye: «Eli Yoane Moɓatise, owa tomaka nga oɓokye ɓatene moto, akundoo!» ");
INSERT INTO loq_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Phɔ Elode atomaka ɓatuluku ɓɛ̀ɛ oɓokye ɓaakya Yoane ɓamunyɔsa o ɓɔlɔkɔ, phɔ ya Elodiya ŋwaŋwasi wa ŋwana nyango Philipo owa buyaka yo ŋwasi wɛ. ");
INSERT INTO loq_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Phɔ Yoane awɔkɔ na Elode yokye: «Tokokyi ilonga ŋwasi wa ŋwana nyɔngɔ.» ");
INSERT INTO loq_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Elodiya aphinywaka na Yoane. Alukaka malondo ma imoɓoma, kasi taikaka mozwa. ");
INSERT INTO loq_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Phɔ Elode ailaka Yoane, aeɓaka oɓokye Yoane ali moto wa ɓosembo, moto wa Ŋwaphongo. Yango mɛna, ambaka ɓaa kamoɓanza. Elode aɓaka katungisame na ɓoikye na mateya ma Yoane, ka na ɓaɓona azingaka nde imooka. ");
INSERT INTO loq_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Wakoma esɛlɛkɔ yaimunya mokɔlɔ ŋwa ɓotama Elode, Elode aɓangaka ɓakumu, ɓakonzi ɓa ɓatuluku, ɓato ɓa ngambo ɓa Galileya, oɓokye ɓaya zaa oka yɛ. Mokɔlɔ mɛ Elodiya awɛnɛkyɛ oɓokye nkɔnzɔ yɛ ya iɓoma Yoane imbiyakoka. ");
INSERT INTO loq_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Waɓa ɓɛ́ɛ ɓazee, ŋwana wa Elodiya wa ŋwaŋwasi amba yakyɛ ɓabinela. Elode na ɓato ɓaaɓangaka yo ɓasepelaka na mbina yɛ. Ɓoɓɛlɛ mokonzi Elode amba ya wɔ na ŋwana ngɔndɔ mɛ yokye: «Inzongye ekpele eesɔ ekyezingye wɛ, namoephɛ yango.» ");
INSERT INTO loq_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Amba ya kata na seleka yokye: «Namoephɛ epkele esɔ eyamunzonga wɛ, eɓe naɓo etee ya mokyisi moangyele nga.» ");
INSERT INTO loq_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ŋwana ngɔndɔ mɛ atɔkɔsi, akyɛ tuna nyango, yokye: «Naongye ekpele'ye?» Nyango yokye: «Koongye nde moto ŋwa Yoane Moɓatise.» ");
INSERT INTO loq_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Sakɔkɔ, ŋwana ngɔndɔ mɔna akuli butwa izele oka mokonzi Elode akyɛ wɔ nɛ yokye: «Nazingye oɓokye ompɛ nde iŋwaŋwa eye moto ŋwa Yoane Moɓatise mi lako.» ");
INSERT INTO loq_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Waaoka mokonzi Elode ɓaaɓona, aokyi ngɔngɔ ɓoikye. Ka naiumunya seleka eya kataka yo o miyo ma ɓabutu ɓaɓangaka yo o esɛlɛkɔ, takokyi na ilɛ imophɛ ekpele esɔ eya ongaka yo. ");
INSERT INTO loq_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Sakɔkɔ, mokonzi amba ya toma tuluku mɔnɔmɔ o ɓɔlɔkɔ oɓokye akyɛ tena moto ŋwa Yoane amoyelele na ŋwango. Ɓoɓɛlɛ, tuluku mɛ amba yakyɛ o ɓɔlɔkɔ, akyɛ tena moto ŋwa Yoane ");
INSERT INTO loq_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Aesi na ŋwango mi lako, amophɛ ŋwana ngɔndɔ mɛ, akyɛ mophɛ nyango. ");
INSERT INTO loq_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Waaoka ɓaekosi ɓa Yoane maphɔɔ masɔ maalekaa, ɓaesi yakyɛ kpa eɓembe yɛ ɓakyɛ ekunda. ");
INSERT INTO loq_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ɓatoma waauta ɓɛ́ɛ o imbanga, ɓaesi yaangana wali Yesu, ɓamoimosi maphɔɔ masɔ makyelaka ɓɛ́ɛ na ma teyaka ɓɛ. ");
INSERT INTO loq_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Phɔ ɓato ɓaike ɓaɓaka ɓasekane oka Yesu, Yesu na ɓaekosi ɓɛ̀ɛ teɓaikaka zwa ngonga ya izaa, yango mɛna amba ya wɔ na ɓɛ́ɛ yokye: «Yaka tomane wali ɓato, tokyɛ luka elele eya ɓose phɔ tokute zaa tombe naema.» ");
INSERT INTO loq_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ɓoɓɛlɛ ɓamba ya baa o vato ɓakyɛ ɓɛ́ɛ mampenza o elele eteeli ɓato ");
INSERT INTO loq_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Waaɓa ɓɛ́ɛ ɓakyɛ ɓaɓona, ɓato ɓaɓawɛni, ɓaɓasɔsɔsi. Ɓaɓaka ɓaute o nkyisi isɔ na mambangu, ɓakyɛ koma o ɓoo o elele eyalukaka Yesu na ɓaekosi ɓɛ̀ɛ ikyɛndɛ. ");
INSERT INTO loq_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Waasɛmɛ ɓɛ, Yesu amba ya aphwa o vato, awɛni moluku ŋwa ɓato ɓaikye. Aɓaokyelaka ngɔngɔ ɓoikye phɔ ɓaɓaka ndokolo mampate mazangyi mɔɔkɔsi, amba ya tata iɓateya maphɔɔ maikye. ");
INSERT INTO loq_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Walekana bunya, ɓaekosi ɓamba ya kyɛndɛ oli Yesu, ɓamba ya wɔ nɛ ɓɛkye: «Bunya ɓolekaa, elele eye eli itakye na lombo. ");
INSERT INTO loq_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Buya ɓato oɓokye ɓakyɛndɛ o manzabi, na o nkyisi ya mambale, phɔ ɓakyɛ miombela ntoma ya izaa.» ");
INSERT INTO loq_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yesu amba ya ɓabuyisa yokye: «Ɓɛ mampenza oɓaphɛ ntoma ya izaa.» Ɓaekosi ɓɛkye: «Kozingye oɓokye ɓanga toombe mapa ma ɓadenali nkama iɓale phɔ ya izeya moluku munsɔ mumu? Na ɓo toombi mapa ma ɓadenale nkama iɓale phɔ ya izeya moluku musɔ mumu ete maaɓakokye.» ");
INSERT INTO loq_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yesu amba ya ɓatuna yokye: «Oli na mapa ɓo? Taa kyɛ kyeka!» Waakyɛ kyeka ɓɛ, ɓamba ya moimola ɓɛkyɛ: «Toli na mapa matano na swe iɓale.» ");
INSERT INTO loq_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ndokolo kambe ya toma ɓaekosi ɓazasa ɓato ɓasɔ o nkata, biɓoko biɓoko. ");
INSERT INTO loq_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ɓaɓazasaka na ndɔngɔ, muna ŋwa munkama, moyɔkɔ ŋwa mako matano. ");
INSERT INTO loq_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yesu aesi ya kpa mapa matano mamana na swe iɓale, atombi miyo o ikolo, aɓɔndɛsi Ŋwaphongo. Waunva yo iɓɔndɛlɛ, akyɛsi mapa, amaphɛ ɓaekosi oɓokye ɓakaɓele ɓato ɓasɔ. Akuli kyela na swe nde ɓomɔ. ");
INSERT INTO loq_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ɓato ɓasɔ ɓazaka, ɓaokaka. ");
INSERT INTO loq_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ɓaekosi ɓamba ɔngɔ bikyɛsi ɓa mapa na ɓa swe ɓa otwaka ɓɛ, ɓatonzaka ɓanyanzima iko mbuka ɓaɓale. ");
INSERT INTO loq_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Motango ŋwa ɓato ɓasɔ ɓaazaka mapa mamana, o itanga nde ɓampele, ŋwaɓaka nkoto itano. ");
INSERT INTO loq_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Sakɔkɔ, Yesu aesi ya toma ɓaekosi oɓokye ɓabaa o vato, ɓakatisa, ɓakyɛ moziya o ɓoo o mokukulu moyɔkɔ o mokyisi ŋwa Ɓetesaida. Mina wamɔ, aesi ya buya na moluku ŋwa ɓato ɓaɓaka wamɔ o nkyisi ya ɓɛ. ");
INSERT INTO loq_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Waunva yo iɓabuya, aesi ya kyɛ ɓɔndɛlɛ o ikolo sa ngomba. ");
INSERT INTO loq_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Waainda bunya, ɓaekosi ɓataka ɓaa onte ya eɓale sa ɓokomakye. Kasi Yesu aɓaka yo mampenza o mokukulu. ");
INSERT INTO loq_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Awɛnɛkyɛ ɓaekosi ɓaŋwane na iluka phɔ ewɛɛlɛ yaɓaka kyeɓabuya na munsima. Waa munkukutu, Yesu amba ya ɓaɓenga na makolo o ikolo sa maa, aunvaka na ɓalenaka. ");
INSERT INTO loq_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Waamowɛnɛ ɓɛ́ɛ katambule o ikolo sa maa na makolo, ɓaumunyaka oɓokye eli mozisi. Ɓamba ya aŋwana, ");
INSERT INTO loq_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","phɔ ɓɛ́ɛ ɓasɔ ɓamowɛnɛkyɛ, ɓatondaka na ɓɔɓɔ. Yesu amba ya wɔ na ɓɛ́ɛ yokye: «Ititala, ɓɛ́ɛ salota, eli nde nga!» ");
INSERT INTO loq_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Amba ya baa o vato phaa ɓaka ɓɛ, ewɛɛlɛ eesi ya ema. Ɓaekosi ɓakamwaka na ɓoikye, ");
INSERT INTO loq_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","phɔ na waakyelaka Yesu elekyesako ya izeya ɓampele mapa, teɓaikaka sɔsɔlɔ, malondo ma ɓɛ́ɛ maɓaka makuwe. ");
INSERT INTO loq_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Waaunva ɓɛ́ɛ ikatisa eɓale, ɓaesi ya kyɛ sɛmɛ o Genesalɛtɛ. ");
INSERT INTO loq_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Waaphwa ɓɛ́ɛ o vato, sakɔkɔ ɓato ɓaesi ya eɓa oɓokye eli Yesu. ");
INSERT INTO loq_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ɓoɓɛlɛ ɓamba ya kyilingana o nkyisi ya ɓɛ́ɛ isɔ, ikyɛmikpa ɓato ɓasɔ ɓaa malɔsi, ɓaɓanyanye mi matɔkɔ ɓakyɛkyɛ na ɓɛ́ɛ o bilele bisɔ ɓaokoka ɓɛ́ɛ oɓokye Yesu ali wamɔ. ");
INSERT INTO loq_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Bilele bisɔ baaɓaka Yesu kakyɛmikyɛndɛ, eɓe o nkyisi iinɛnɛ na iinkyikyi na yaa mangonda, ɓaɓaka ɓakyɛ milangya ɓato ɓaa malɔsi o munsɔngɔ. Ɓanyingonelaka na Yesu ɓɛkye: «Oɓalɛ ɓakume nɔnɔ sɔngyɛ ya etobu ya wɛ.» Emba, ɓasɔ ɓaamokumaka, ɓabikaka. ");
INSERT INTO loq_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Mokɔlɔ mɔnɔmɔ Ɓafalisayi na ɓateye ɓa Miɓeko ɓayɔkɔ ɓautaka o Yelusalɛmɛ, ɓaesi ya angana oli Yesu. ");
INSERT INTO loq_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Waawɛnɛ ɓɛ́ɛ oɓokye ɓaekosi ɓa Yesu ɓayɔkɔ ɓaze ntoma na sɔkɔtɔ sa kunyola sɛ, ɓo kowɔ mateya ma ɓankɔkɔ, ");
INSERT INTO loq_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","phɔ Ɓafalisayi na Ɓayuda ɓasɔ ɓakumolaka miɓeko ma ɓankɔkɔ, o ɓoo pha izaa ntoma, ela ɓakunyosi sɛ ɓo wa teyaka ɓankɔkɔ. ");
INSERT INTO loq_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ɓo ɓaute o zando, te ɓakokyi izaa ɓo teɓamikunyosi ɓo kowɔ miɓeko ma ɓɛ. Ɓali na maphɔɔ masuu maike ma ɓankɔkɔ makumole ɓɛ, maphɔɔ mɛ mango mama: Ikunyola binywele, mambongo, manzongo maa biɓende, na biziye. ");
INSERT INTO loq_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Yango mɛna Ɓafalisayi na ɓateye ɓa Miɓeko ɓamba ya tuna Yesu ɓɛkye: «Phɔ ya ye ɓaekosi ɓa wɛ te ɓaakumole miɓeko ma ɓankɔkɔ, ɓaze ntoma sa kunyola sɛ?» ");
INSERT INTO loq_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesu amba ya ɓabuyisa yokye: «Moimosi Isaya alongaka nde phɛlɛ waa wɔ yo phɔ ya Yesu oɓokye: “Ɓato ɓaɓa ɓankumole nde na maloɓa, kasi o mandondo ɓali itakye na nga. ");
INSERT INTO loq_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Losambo la ɓɛ́ɛ loli nde pha, ɓateya nde miɓeko miute na ɓato, ɓɛkye maphɔɔ ma nga Ŋwaphongo.”» ");
INSERT INTO loq_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yesu akuli wɔ na ɓɛ́ɛ yokye: Komanya miɓeko ma Ŋwaphongo phɔ ya ikumola miɓeko ma ɓato. ");
INSERT INTO loq_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","«Koeɓe na ɓola nde ilɛ miɓeko ma Ŋwaphongo phɔ ya iɓanza miɓeko ma ɓankɔkɔ. ");
INSERT INTO loq_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Phɔ Mose awɔ yokye: “Kumola nyɔngɔ na ɔngɔ. Kasi owa motola nyango na ango, ɓasengyesi imoɓoma.” ");
INSERT INTO loq_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ka koteya ɓoɓo: “Moto takokyi iwɔ na nyango eɓe na ango yokye: Mbolo iunvakyi nga iesunga na yango, nataa iphɛ Ŋwaphongo, kyelukye iwɔ oɓokye mbolo mɛ ibuto koloɓanɛ.” ");
INSERT INTO loq_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ɓo ɓakyesi ɓaɓona, mɛna ɓamokatesi ikula sunga nyango na ango. ");
INSERT INTO loq_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Na ɓomɔ, mɛna kɔɔtɔ Simo ya Ŋwaphongo na mateya ma ɓankɔkɔ maateya ɓɛ. Kokyele maphɔɔ masuu maikye nde ɓomɔ.» ");
INSERT INTO loq_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Sima mɛ Yesu akuli ya ɓanga moluku ŋwa ɓato, amba ya wɔ na ɓɛ́ɛ yokye: «Okyemela, ɓɛ̀ɛ ɓasɔ osɔsɔlɔ na ɓolaa. ");
INSERT INTO loq_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ekple esɔ eekyenyɔlɔ onte ya moto, tekokyi ɔtɔ ndondo yɛ, kasi nde maphɔɔ matɔkɔlɔ o ndondo ya moto, eli mɛɛ maamɔtɔ.  ");
INSERT INTO loq_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ooli na matoo ma ioka, aokye!» ");
INSERT INTO loq_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Waaika Yesu moluku ŋwa ɓato ɓaaɓaka nɛ, anyɔsi o ingambi, ɓaekosi ɓaesi ya motuna ntina ya ete mɛ. ");
INSERT INTO loq_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yesu amba ya wɔ na ɓɛ́ɛ yokye: «Na ɓɛ̀ɛ naino tosɔsɔsi? Toeɓe oɓokye epkele esɔ ekye nyɔlɔ onte ya moto teekokyi iɔtɔ ndondo yɛ? ");
INSERT INTO loq_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Phɔ ekpele mɛ te nyɔlɔ o ndondo yɛ, kasi kye nyɔlɔ nde o ibu, sima kaeyete o zikyi.» Na ete mɛ, Yesu ateya oɓokye ntoma isɔ ili ndaa phɔ ya izaa. ");
INSERT INTO loq_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Akulaka wɔ yokye: «Kyeɔtɔ moto nde ekplele ekyetɔkɔlɔ o ndondo yɛ. ");
INSERT INTO loq_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Phɔ maumunya masɔ maaɓe maute o ndondo ya moto, ɓooli: Ɓondumba, iɓa, iɓoma ɓato, ");
INSERT INTO loq_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ikyela ɓaphemba, imengyela, ikyela ɓato ɓoɓe, ikosa, ikyela mobulu ŋwa ɓaɓasi na ɓampele, zuwa, ikata ɓɔlɛ, lolɛndɔ, ɓobubusi. ");
INSERT INTO loq_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Maphɔɔ maaɓe masɔ mama matɔkɔlɔ o ndondo ya moto, mɛɛ mambe mɔɔtɔ.» ");
INSERT INTO loq_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesu aesi ya mama o elele mɛ, akyɛ o nkyisi iili phɛnɛphɛ na mokyisi ŋwa Tula. Aesi ya nyɔlɔ o ingambi sɔnɔsɔ phɔ taikaka zinga oɓokye ɓato ɓaeɓe wali yo. Kasi na ɓo ɓaɓona, ɓato ɓaeɓaka nde elele eli yo. ");
INSERT INTO loq_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Ŋwaŋwasi mɔnɔmɔ, otoikaka ɓa Moyuda, aɓotama o Fenisi. Ŋwaŋwasi mɛ aɓaka na ŋwana wɛ wa ŋwaŋwasi, aɓaka na ɓolɔɓɔ ɓoɓe. Waoka yo simo ya Yesu, sakɔkɔ aesi yakyɛ mivaka o makolo mɛ, amba nyingonela na Yesu oɓokye atɔkɔlɔ ɓolɔɓɔ ɓoɓe o nzoto ya ŋwana wɛ. ");
INSERT INTO loq_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yesu amba ya wɔ nɛ yokye: «Talɛ naino ɓana ɓazee phanza ɓaokye, phɔ teli ɓolaa oɓokye okpe mapa ma ɓana omavakyele ɓana ɓa manva.» ");
INSERT INTO loq_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ŋwaŋwasi mɛ amobuyisaka yokye: «Eli ɓomɔ, Nkolo, ka ɓana ɓa manva nga ɓakute zaa nɔnɔ ina mpusu ikyilasa ɓana o se ya mesa.» ");
INSERT INTO loq_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yesu amba ya wɔ nɛ yokye: «Ee mama, phɔ ya mobuyisesi ŋwa wɛ molaa maamuna, butwa o ingambi sa wɛ, ɓolɔɓɔ ɓoɓe ɓotɔkɔsi o nzoto ya ŋwana wa wɛ.» ");
INSERT INTO loq_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Wabutwa ŋwaŋwasi mɛ o ingambi sɛ, akyɛ takana ŋwana wɛ amilangye o tangye, ɓolɔɓɔ ɓoɓe ɓotɔkɔlɛlɛkyi. ");
INSERT INTO loq_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesu amba ya mana o nkyisi ili phɛnɛphɛ na mokyisi ŋwa Tula, alekaa ya mokyisi ŋwa Sidona, akatise Dekapɔlɛ wakoma yo o maa manɛnɛ ma Galileya. ");
INSERT INTO loq_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Omɔ, ɓaesi ya moyelela na moto owa loko, aɓaka na ná ikyɛkumisa. Ɓato mɛ ɓaɓaka ɓanyingonele nɛ oɓokye amotandele maɓɔkɔ phɔ ya imobikya. ");
INSERT INTO loq_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesu amba ya mopka, akyɛ nɛ ŋwana imbale, itakye na moluku ŋwa ɓato. Amunyɔsɛ nsɛ o matoo, amitowi matee o nsɛ, amotasee na mango o lolee. ");
INSERT INTO loq_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ɓoɓɛlɛ, Yesu amba ya tomba miyo o ikolo, auye mɔɔ, amba ya wɔ na moto mɛ yokye: «Ephata!» Kyelukye iwɔ oɓokye «matoo ziɓwa!» ");
INSERT INTO loq_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Mina wamɔ, matoo ma moto mɛ mazibo, lolee lɛɛ loingoo, abuto iwɔ na ɓolaa. ");
INSERT INTO loq_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesu akatelaka ɓato mɛ ɓaaɓaka wamɔ oɓokye ɓɛ́ɛ saumola nɔnɔ moto monɔmɔ. Na ɓo waɓakatelaka yo ɓaɓona, ɓaɓaka ɓakyɛ mimola nde isɔ ya kyelaka yo. ");
INSERT INTO loq_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ɓato ɓakaŋwaka nde ɓokamo ɓɛkye: «Isɔ iikyikyele yo ili nde ndaa! Kaingole matoo ma ɓato ɓaa loko, phɔ ɓabutwe ioka, kawɔya na ɓato ɓaa mbubu!» ");
INSERT INTO loq_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Nde mi nkɔlɔ mɛ, ɓato ɓaikye ɓakulaka yaangana wali Yesu. Kasi ɓo toikaka ɓa ɓɛ́ɛ na ntoma ya izaa, Yesu amba ya ɓanga ɓaekosi ɓɛɛ, amba ya wɔ na ɓɛ́ɛ yokye: ");
INSERT INTO loq_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Nali na ngɔngɔ phɔ ya ɓato ɓaɓa, ɓambo kyela na nga wawa nkɔlɔ iyato, kasi uŋwaŋwa eye teɓakuli ɓa na ekple ya izaa. ");
INSERT INTO loq_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ɓo na ɓabuye o mangambi ma ɓɛ́ɛ na nzala, ɓamokyɛ kpaa phikyi o nzela, phɔ ɓaayɔkɔ ɓauta itakye.» ");
INSERT INTO loq_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ɓaekosi ɓamba ya mobuyisa ɓɛkye: «Wawa toli o bokye, tomozwa mapa ma iɓaphɛ bi oɓokye ɓazee ɓaokye?» ");
INSERT INTO loq_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesu amba ya ɓatuna yokye: «Oli na mapa ɓo?» Ɓaekosi ɓɛkye: «Toli na mapa sambo.» ");
INSERT INTO loq_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Emba Yesu amba ya wɔɔ na ɓato ɓasɔ oɓokye ɓazale o se. Aesi yakpa mapa sambo maamana, aphɛ Ŋwaphongo mɛlɛsi, amateni amaphɛ ɓaekosi oɓokye ɓamakaɓele ɓato ɓasɔ. Ɓakyelaka nde ɓomɔ. ");
INSERT INTO loq_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ɓakulaka ɓa na ná ɓanaa swe ɓakyikyi. Yesu akuli phɛ Ŋwaphongo mɛlɛsi phɔ ya swe mɛ, aiphɛ ɓaekosi ɓɛ̀ɛ oɓokye ɓakule ikaɓela ɓato. ");
INSERT INTO loq_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ɓato ɓasɔ ɓaazaka ɓaokaka. Ɓaekosi ɓaɔngɔkɔ ntoma yaa otwaka ɓɛ, ɓatonzaka ɓanyanzima sambo. ");
INSERT INTO loq_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ɓato ɓasɔ ɓaazaka ɓaɓaka phɛnɛphɛ nkoto ine! Ɓoɓɛlɛ Yesu amba ya ɓabuya o nkyisi ya ɓɛ. ");
INSERT INTO loq_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Waunva yo iɓabuya, ndokolo kambe ya kpela o vato yo na ɓaekosi ɓɛɛ, ɓamba yakyɛ o manyɛtɛ ma Dalamanuta. ");
INSERT INTO loq_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Mokɔlɔ mɔnɔmɔ Ɓafalisayi ɓaesi ya tɔkɔlɔ, ɓatati iika ziko na Yesu. Phɔ ya imumeka, ɓamba ya motuna oɓokye akyele iyaa phɔ ya iteya oɓokye maphɔɔ maakyele yo maute oka Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesu aumesi, amba ya wɔ yokye: «Phɔ ya'ye ɓato ɓa lɔlɔ eye ɓatune ikyela iyaa? Na wɔ na ɓɛ̀ɛ nde phɛlɛ, esikyele nɔnɔ iyaa sɔnɔsɔ!» ");
INSERT INTO loq_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ɓoɓɛlɛ, aikyi ɓaika, akuli kyɛ kpela o vato, aesi ya katisa o mbale eya mokukulu mooyɔkɔ ŋwa maa. ");
INSERT INTO loq_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ɓaekosi ɓabungaka iphila mapa, ɓaɓaka nde na ipa sɔnɔsɔ ɓoɓɛlɛ o vato. ");
INSERT INTO loq_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesu amba ya wɔ na ɓɛ́ɛ yokye: «Oeɓaka! Kyeɓa na zwɛ siulole mapa sa Ɓafalisayi na ɓato ɓa Elode.» ");
INSERT INTO loq_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ɓaekosi ɓɛ́ɛ na ɓɛ́ɛ ɓaikaka ziko ɓɛkyɛ: «Awɔ ɓaɓona phɔ tololi na mapa.» ");
INSERT INTO loq_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu aeɓaka maumunya ma ɓɛ, amba ya ɓatuna yokye: «Phɔ ya'ye ɓɛ̀ɛ koikye ziko oɓokye toli na mapa? Ɓɛ̀ɛ naino tosɔsɔsi? Naino toɓanze? Malondo ma ɓɛ̀ɛ makuwe? ");
INSERT INTO loq_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Oli na miyo, toowɛnɛ? Oli na matoo, tookye? Obungyi elekyesako eyakyelaka nga? ");
INSERT INTO loq_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Mokɔlɔ ŋwa zeyaka nga ɓampele nkoto itano mapa matano, wabutwaka na ɓanyanzima ɓoo ɓaatonzaka ɓɛ̀ɛ na bitee bya otwaka ɓɛ?» Ɓaekosi ɓamobuyisaka ɓɛkye: «Tobutwaka na ɓanyanzima iko mbuka ɓaɓale.» ");
INSERT INTO loq_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Yesu akuli ɓatuna yokye: «Mokɔlɔ ŋwaezeyaka nga ɓato nkoto ine mapa sambo, wabutwa na ɓanyanzima ɓoo ɓatonzaka ɓɛ̀ɛ na bitee ɓaotwaka ɓɛ?» Ɓaekosi ɓamobuyisaka ɓɛkye: «Tobutwaka na ɓanyanzima sambo.» ");
INSERT INTO loq_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ɓoɓɛlɛ, Yesu amba ya wɔ na ɓɛ́ɛ yokye: «Ɓɛ̀ɛ naino tosɔsɔsi?» ");
INSERT INTO loq_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesu na ɓaekosi ɓɛ̀ɛ ɓaesi ya koma o mokyisi ŋwa Betesaida. Omɔ, ɓato ɓamba yelela Yesu moto owa phɔlɔ miyo. Ɓamba ya nyingonela nɛ oɓokye amotasa. ");
INSERT INTO loq_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesu amba ya kpa moto owa phɔlɔ miyo mi eɓɔkɔ, akyɛ nɛ o eɓonga ya mokyisi. Aesi ya motowa mate o miyo, amba ya motanda maɓɔkɔ, amba ya motuna yokye: «Kowɛnɛ ŋwana ekpele?» ");
INSERT INTO loq_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Moto awa phɔlɔ miyo amba ya ziɓola miyo, yokye: «Nawɛnɛ ɓato. Naɓawɛnɛ ndokolo nzete, kasi ɓatambule.» ");
INSERT INTO loq_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ɓoɓɛlɛ amba kula motasa o miyo, abuto iwɛnɛ na ɓolaa, abikyi, abuto iwɛnɛ mbolo isɔ na ɓolaa. ");
INSERT INTO loq_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ɓoɓɛlɛ, Yesu amba ya mobuya o ingambi sɛ, yokye: «Sazwa yaa munsɔngɔ.» ");
INSERT INTO loq_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu na ɓaekosi ɓɛ́ɛ ɓaesi ya kyɛndɛ o nkyisi iili phɛnɛphɛ na Sezare Filipe, mokyisi ŋwa mokonzi Filipe. Waaɓa ɓɛ́ɛ o nzela, Yesu aesi ya tuna ɓaekosi ɓoɓo: «Ɓato ɓawɔ oɓokye nga nali nza?» ");
INSERT INTO loq_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ɓaesi ya mobuyisa ɓɛkye: «Ɓakyi ɓaetangye Yoane Moɓatise, ɓana ɓaetangye moimosi Eliya, ɓaayɔkɔ ɓawɔ ɓɛkye oli mɔnɔmɔ na ɓaimosi ɓa kalakala.» ");
INSERT INTO loq_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yesu akuli ɓatuna yokye: «Ka ɓɛ̀ɛ, kowɔ oɓokye nga nali nza?» Petelo aesi ya mobuyisa yokye: «Oli Klisto.» ");
INSERT INTO loq_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Emba Yesu aɓakatelaka na ɓokusi oɓokye ɓɛ́ɛ saloimola nɔnɔ moto. ");
INSERT INTO loq_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ɓoɓɛlɛ, Yesu aesi ya tata iteya ɓaekosi yokye: «Esengyesi oɓokye nga, Ŋwana wa Moto nawɛnɛ malɔsi maikye. Ɓankumu ɓa ingomba, ɓakonzi ɓa ɓanganga ɓa Ŋwaphongo, na ɓateye ɓa miɓeko ɓamundɛɛ. Ɓamumboma, kasi o sima ya nkɔlɔ iyato namokundwa.» ");
INSERT INTO loq_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Aɓawɔlɛkyɛ nde pwapwa. Petelo amba ya mokpa, akyɛ nɛ ŋwana imbale, atati iimooya yokye: «Sawɔkɔ ɓaɓona.» ");
INSERT INTO loq_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Yesu amba ya ekpana, akyekyi ɓaekosi, amba ya phaphala na Petelo yokye: «Mana wawa, Molemba! Maumunya ma wɛ temali maaka Ŋwaphongo, mali nde maaka ɓato ɓa mokyisi.» ");
INSERT INTO loq_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Boɓɛlɛ, Yesu aesi ya ɓanga ɓato na ɓaekosi ɓɛ, amba ya wɔ na ɓɛ́ɛ yokye: «Ɓo moto kalukye imbenga, yo sakula luka ɓolaa phɛ mampenza, anyanya ekulusu yɛ, emba ambe mbenga. ");
INSERT INTO loq_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Phɔ moto ookolukye ibikya ɓomɔɔ phɛ aaɓobungya. Ka owa mobungya ɓomɔɔ phɛ phɔ ya nga, na phɔ ya imola Simo Elaa, aaɓobikya. ");
INSERT INTO loq_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Na ɓo moto amizwesi ezwele esɔ eli o mokyisi, kasi abungye ɓomɔɔ phɛ, ambi zwa ekpele'ye? ");
INSERT INTO loq_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ekpele'ye eekokyi yo ambya phɔ ya iikola ɓomɔɔ phɛ? ");
INSERT INTO loq_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ɓato ɓa lɔlɔ eye ɓakyele masumu teɓaalote na Ŋwaphongo. Ɓo moto aokyi sɔɔ ya imbenga, aokyi na sɔɔ ya imola Simo ya nga oka ɓato ɓaaɓana, inga Ŋwana wa Moto nde ɓomɔ mɛ, naamooka sɔɔ wa moyaa nga na Ɓaanze ɓasanto o nkyɛmɔ ya Tata.» ");
INSERT INTO loq_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesu akuli wɔ na ɓɛ́ɛ yokye: «Nde phɛlɛ nawɔ na ɓɛ̀ɛ ngakye: Ɓokonzi pha Ŋwaphongo pha moya na mwiya, naino ɓayɔkɔ ɓali na ɓɛ̀ɛ wawa sataa waa.» ");
INSERT INTO loq_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Sima ya nkɔlɔ motoɓa, Yesu aesi ya kpa Petelo, Zake na Yoane. Akyɛ na ɓɛ́ɛ o ngomba yɔnɔyɔ eanda, itakye na ɓato. Omɔ, ɓaɓaka nde ɓɛ́ɛ mampenza. Nzoto ya Yesu iesi ya butwa ndengye esuu o miyo ma ɓɛ. ");
INSERT INTO loq_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Bitobu ɓɛ̀ɛ ɓabutwaka ingyɛngyɛ na ɓokusi. Ɓabutwaka bitane pɛ na ndengye yɔnɔyɔ oɓokye moto mɔnɔmɔ o mokyisi takokyi ikunyola bitobu pɛɛ pɛɛ ɓaɓona. ");
INSERT INTO loq_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ɓoɓɛlɛ, ɓaekosi mɛ ɓaato ɓaesi ya wɛnɛ Eliya na Mose ɓawɔɔnɔ na Yesu. ");
INSERT INTO loq_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Emba Petelo amba ya wɔ na Yesu yokye: «Moteye, eli ɓolaa oɓokye toɓee wawa! Totongye ndalaku iyato, mɔnɔmɔ phɔ ya wɛ, muna phɔ ya Mose, mooyɔkɔ phɔ ya Eliya!» ");
INSERT INTO loq_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Petelo aɓaɓanganaka saeɓa iikyi wɔ yo, phɔ eɓe yo eɓe ɓɛbi nɛ ɓawɛnɛkyɛ inganga siikye. ");
INSERT INTO loq_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Emba impata sɔnɔsɔ siesi ya ɓaziɓa. Onte ya impata mɛ, ŋwɛsi mɔnɔmɔ moesi ya okana mowɔ ɓoɓo: «Oyo Ŋwana wa nga owa sɔmi, omookye!» ");
INSERT INTO loq_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Mina wamɔ, ɓaekosi ɓakyekyi na mbale na mbale, teɓakuli wɛnɛ moto mosuu, nde Yesu yo mampenza. ");
INSERT INTO loq_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Waaɓa ɓɛ́ɛ ɓaute ngomba, Yesu aɓakatelaka yokye: Saika imola na moto mɔnɔmɔ maphɔɔ maawɛni ɓɛ̀ɛ mama, tee nɔnɔ mokɔlɔ ŋwaamokundwa Ŋwana wa moto onte ya ɓawe. ");
INSERT INTO loq_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ɓazitaka maphɔɔ mɛ. Kasi ɓaɓaka ɓamitune ɓɛkye: «“Ikundwa onte ya ɓawe kyeneluka iwɔ ɓo?”» ");
INSERT INTO loq_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ɓoɓɛlɛ, ɓaesi ya tuna Yesu ɓɛkye: «Phɔ ya'ye ɓateye ɓa Miɓeko ɓawɔ ɓɛkye: Esengyesi oɓokye Eliya atakula yaa phanza, Masiya amba yaa sima?» ");
INSERT INTO loq_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesu amba ya ɓabuyisa yokye: «Eli ɓomɔ! Esengyesi oɓokye Eliya aye phanza iya ɓɔngya maphɔɔ masɔ. Ka phɔ ya'ye yakomama o buku pha Ŋwaphongo oɓokye Ŋwana wa Moto amowɛnɛ ɓolɔsi ɓoikye, ɓamba na mosemola? ");
INSERT INTO loq_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Kasi nga nawɔ na ɓɛ̀ɛ ngakye: Eliya ka aunva yaa, ɓato ɓamokyelela maphɔɔ masɔ maaɓe ɓowa zingaka mandondo ma ɓɛ, nde ɓowakoma ɓɛ́ɛ o buku pha Ŋwaphongo phɔ yɛ!» ");
INSERT INTO loq_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Waakoma ɓɛ́ɛ phɛnɛphɛ na ɓaekosi ɓayɔkɔ ɓaikalaka, ɓawɛni ɓato ɓaikye ɓalungye ɓaekosi mɛ, ɓateye ɓa Miɓeko ɓaikye na ɓɛ́ɛ ziiko. ");
INSERT INTO loq_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Waawɛnɛ ɓato mɛ Yesu, ɓakamwaka na ɓoikye, ɓakyilinganaka ikyɛ moɓeya. ");
INSERT INTO loq_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesu amba ya tuna ɓaekosi ɓɛ̀ɛ yokye: «Lowɔɔ ye loikyele ɓɛ́ɛ na ɓɛ̀ɛ ziko?» ");
INSERT INTO loq_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Moto mɔnɔmɔ onte ya ɓato ɓaaɓana amobuyisaka yokye: «Moteye, naeyelelakyi na mwana wa nga o wa lele phɔ ali na ɓolɔɓɔ ɓoɓe phamobuya mbubu. ");
INSERT INTO loq_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ɓilele bisɔ bimoakya ɓolɔɓɔ mɛ, ɓomovakye o se. Ŋwana kabutwe itɔkɔlɔ luulu o munɔkɔ, kaze na mino, nzoto kyimbe na etetala nɛ. Naongakyi na ɓaekosi ɓa wɛ oɓokye ɓatɔkɔlɔ ɓolɔɓɔ mɛ, kasi teɓaikyi koka.» ");
INSERT INTO loq_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesu amba ya wɔ na ɓɛ́ɛ yokye: «Oo, ɓɛ̀ɛ toli nde na ianola! Esengyesi oɓokye nakule ɓa na ɓɛ̀ɛ bileko ɓo, oɓokye ombe anola? Nakule euyisa mɔɔ tee imbele ye? Inzelele na ŋwana mɛ wawa.» ");
INSERT INTO loq_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ɓaamba ya moyelela na ŋwana mɛ. Wa wɛnɛ ɓolɔɓɔ ɓoɓe mɛ Yesu, phamba ya nyingyinya ŋwana na ɓokusi. Ŋwana mɛ aesi ya kaa o se. Abuto ikuluɓana, bibi luulu lomotɔkɔlɔ o munɔkɔ. ");
INSERT INTO loq_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu amba ya tuna ango wa ŋwana mɛ yokye: «Ambo kyela na ɓolɔsi mɛ mambula ɓo?» Ango wa ŋwana yokye: «Phatata nɛ nɔnɔ waa ɓoŋwana. ");
INSERT INTO loq_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Sooso ɓolɔɓɔ mɛ ɓomovakye o ŋwenya, eɓe na o maa nde oɓokye ɓomoɓome. Kasi ɓowamokoka, olookyele ngɔngɔ, olosungye!» ");
INSERT INTO loq_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu amba ya wɔ nɛ yokye: «Phɔ ya'ye owɔ wɛkye: Ɓo na mokoka? Oeɓe oɓokye: Maphɔɔ masɔ makokyi ikyelama phɔ ya moto okoanole Ŋwaphongo!» ");
INSERT INTO loq_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Sakɔkɔ ango wa ŋwana atati iaŋwana yokye: «Naanosi, kasi insungye phɔ sili na ianola siikye!» ");
INSERT INTO loq_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Waawɛnɛ Yesu ɓato ɓaikye ɓaye waali ɓɛ́ɛ na mankyɛɛ, aesi ya phaphala na ɓolɔɓɔ ɓoɓe mɛ yokye: «Iwɛ ɓolɔɓɔ ɓoɓe phaabuya ŋwana mbubu na loko, nawɔ na wɛ ngakye: Tɔkɔlɔ o nzoto ya ŋwana oyo, na mbala, sakula mobutolela.» ");
INSERT INTO loq_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ɓolɔɓɔ mɛ ɓoesi ya lika ŋwangye, ɓoesi ya nyingyinya ŋwana na ɓokusi, phaamba ya tɔkɔlɔ. Ŋwana aesi ya butwa ndokolo moto awee. Yango mɛna, ɓato ɓaikye ɓaɓaka wamɔ ɓɛkye: «Ŋwana mɛ awee!» ");
INSERT INTO loq_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Kasi Yesu amba ya mokpa mi eɓɔkɔ, amolangosi. Ŋwana mɛ amba ya tɛmɛ. ");
INSERT INTO loq_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Sima mɛ Yesu aesi ya butwa o ingambi. Waaɓa yo na ɓaekosi ɓɛ́ɛ na ɓɛ, ɓaekosi ɓamba ya motuna ɓɛkye: «Ɓanga, toloikyi koka itɔkɔlɔ ɓolɔɓɔ mɛ phɔ ya ye?» ");
INSERT INTO loq_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesu amba ya ɓabuyisa yokye: «Malɔɓɔ maaɓe ma ndengye mɛnɛ makokyi itɔkɔlɔ nde na iɓɔndɛlɛ.» ");
INSERT INTO loq_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yesu na ɓaekosi ɓɛ̀ɛ ɓaesi ya mana o elele mɛ, ɓaesi ya lekana o manyɛtɛ ma Galileya. Yesu taikaka ɓenela oɓokye ɓato ɓaeɓe elele eli yo. ");
INSERT INTO loq_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Phɔ aɓaka kateya ɓaekosi ɓɛ́ɛ ɓoɓo: «Nga Ŋwana wa Moto ɓamunzambya o maɓɔkɔ ma ɓato, ɓamumboma, kasi sima ya nkɔlɔ iyato namokundwa.» ");
INSERT INTO loq_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Kasi ɓaekosi teɓaikaka sɔsɔlɔ ntina ya maphɔɔ maawɔkɔ yo, ɓailaka na imotuna ntina mɛ. ");
INSERT INTO loq_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Yesu na ɓaekosi ɓɛ̀ɛ ɓaesi ya koma o Kapalanauma. Waanyɔlɔ ɓɛ́ɛ o ingambi, Yesu aesi ya ɓatuna yokye: «Lowɔɔ'ye loɓakyi ɓɛ̀ɛ koikyele ziko o nzela?» ");
INSERT INTO loq_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Kasi ɓaekosi ɓaikalaka ɓose, phɔ ɓaɓaka ɓaikye ziko o nzela phɔ ya eɓa nza olekyi na ngambo onte ya ɓɛ. ");
INSERT INTO loq_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ɓoɓɛlɛ, Yesu aesi ya zala, aesi ya ɓanga ɓaekosi ɓɛ̀ɛ ɓasɔ iko mbuka ɓaɓale, amba ya wɔɔ na ɓɛ́ɛ yokye: «Ɓo moto kalukye iɓaa owa o ɓoo, esengyesi oɓokye aɓe o mbomela ya ɓasɔ, ambe kula na ɓaa owa etoma wa ɓɛ.» ");
INSERT INTO loq_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ɓoɓɛlɛ Yesu aesi ya kpa ŋwana oo mokyɛ, amotɛyɛ o nte ya ɓɛ, amoɓɛbi, amba ya wɔ na ɓɛ́ɛ yokye: ");
INSERT INTO loq_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Moto nza owamoyamba ŋwana o mokyɛ ɓoli oyo ɓoɓo phɔ ya nga, mɛnɛ anzambi nde nga mampenza. Ka owamunzamba, taikyi yamba nde nga mamɛ, kasi ayambi na Ŋwaphongo owa ntoma.» ");
INSERT INTO loq_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yoane aesi ya wɔ na Yesu yokye: «Moteye, towɛnɛkyi moto mɔnɔmɔ katɔkɔlɔ malɔɓɔ maɓe na nkombo ya wɛ. Tomokatelaka phɔ taikaka ɓaa mɔnɔmɔ na ɓanga.» ");
INSERT INTO loq_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yesu amba buya yokye: «Ɓɛɛ samokatela! Phɔ moto takokyi ikyela elekyesako na nkombo ya nga sima ambe kula nvɔlɛ na ɓoɓe. ");
INSERT INTO loq_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Phɔ moto ootoolotɛmɛlɛ ali na ɓanga mbale. ");
INSERT INTO loq_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nde phɛlɛ na wɔ na ɓɛ̀ɛ ngakye: Moto owamoephɛ nɔnɔ kɔphɔ ya maa ma inywa phɔ ɓɛ̀ɛ oli ɓato ɓanga, Klisto, nde phɛlɛ amozwa mbano yɛ.» ");
INSERT INTO loq_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Yesu amba kula wɔ yokye: «Ka ɓo moto nza katomisa mɔnɔmɔ na ɓaali na ianola sikyikyi oka nga oɓokye ɓakyele ɓoɓe, esengyesi oɓokye ɓatingya moto mɛ iɓanga sinɛnɛ o nkyingo, ɓamovakye o ebale. ");
INSERT INTO loq_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ɓo eɓɔkɔ ya wɛ kyeetome ikyela ɓoɓe, oetene! Phɔ elekyi ɓolaa inyɔlɔ o lola na eɓɔkɔ yɔnɔyɔ, na ikyɛndɛ na maɓɔkɔ masɔ maɓale o lifelo, o ŋwenya motemoozime. ");
INSERT INTO loq_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Omɔɔ, “nkuu ikyitwe nzoto ya ɓato teiwe, na ŋwenya temozime.” ");
INSERT INTO loq_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ɓo ekolo ya wɛ kyeetome ikyela ɓoɓe, oetene! Phɔ elekyi ɓolaa inyɔlɔ o lola na ekolo yɔnɔyɔ, na ikyɛndɛ na makolo masɔ maɓale o lifelo, o ŋwenya motemozime. ");
INSERT INTO loq_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Omɔɔ, “nkuu ikyitwe nzoto ya ɓato teiwe, na ŋwenya temozime.” ");
INSERT INTO loq_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ka ɓo ziyo sa wɛ sietome ikyela ɓoɓe, osiphɛngɔlɔ! Phɔ elekyi ɓolaa inyɔlɔ o ɓokonzi pha Ŋwaphongo na ziyo sɔnɔsɔ, na ikyɛndɛ na miyo masɔ maɓale o lifelo. ");
INSERT INTO loq_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Omɔɔ, “nkuu ikyitwe nzoto ya ɓato teiwe, na ŋwenya temozime.” ");
INSERT INTO loq_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ɓato ɓasɔ ɓamolekana o ŋwenya oɓokye ɓaɓɔngɔ, nde ɓokokyele ɓɛ́ɛ mokpa o ntoma oɓokye iɓɔngɔ. ");
INSERT INTO loq_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Mokpa eli ekpele elaa. Ka ɓo mokpa mumani vale, ɓamokula mobuya vale ndengye'ye? Ɓaka ndokolo mokpa onte ya ɓɛ̀ɛ, oombakye ɓaa na ɓose o nte ya ɓɛ̀ɛ.» ");
INSERT INTO loq_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ɓoɓɛlɛ Yesu aesi ya mana o Kapalanauma, akyɛ o nkyisi ya manyɛtɛ maa Yuda. Sima aesi yaakala o mokukulu moyɔkɔ ŋwa Yaladɛnɛ. Omɔɔ, ɓato ɓaikye ɓakulaka yaangana wali yo, aesi ya tata iɓateya ɓowamɛɛlɛkyɛ yo. ");
INSERT INTO loq_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ɓafalisayi ɓayɔkɔ ɓayakaka wali Yesu phɔ ya imumeka, ɓaesi ya motuna ɓɛkye: «Lele akokyi ilɛ ŋwasi wɛ?» ");
INSERT INTO loq_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesu amba ya ɓabuyisa yokye: «Moɓeko iye ŋwaaephɛkyɛ Mose?» ");
INSERT INTO loq_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ɓafalisayi ɓɛkye: «Mose ambyaka nzela oɓokye o ɓoo pha ilɛ ŋwaŋwasi o ɓolonga, esengyesi oɓokye lele amokomele mokanda moimole oɓokye ɓolonga ɓowee.» ");
INSERT INTO loq_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Kasi Yesu yokye: «Mose aekomela moɓeko mamuna phɔ ya mandondo makusi ma ɓɛ̀ɛ. ");
INSERT INTO loq_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Kasi uta oetatele ya mokyisi, Ŋwaphongo “akyelaka ŋwaŋwasi na lele. ");
INSERT INTO loq_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Yango mɛna, lele amoika ika nyango na ango, amokyɛ angana elele yɔnɔyɔ na ŋwaŋwasi wɛ. ");
INSERT INTO loq_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ɓɛ́ɛ ɓasɔ ɓamobutwa moto mɔnɔmɔ. Nde ɓomɔ, teɓakuli ɓa ɓato ɓaɓale, kasi ɓabuto nde moto mɔnɔmɔ.” ");
INSERT INTO loq_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Emba ɓo Ŋwaphongo ambo angyinya ŋwaŋwasi na lele, moto saɓakabinya.» ");
INSERT INTO loq_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Waɓa Yesu na ɓaekosi ɓɛ̀ɛ o motema ŋwa ingambi, ɓaekosi ɓakulaka motuna phɔ ya lowɔ la iɓoma ɓolonga. ");
INSERT INTO loq_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yesu amba ya ɓabuyisa yokye: «Ɓo lele alɛ ŋwaŋwasi wɛ, akyɛ longa mosuu, mɛna akyelesi ŋwaŋwasi wɛ o wa phanza ɓoɓe phɔ akyesi phemba. ");
INSERT INTO loq_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ekuli ɓa nde ɓomɔ, ɓo ŋwaŋwasi alɛ lele wɛ, akyɛ zala na lele mosusu, mɛna akyesi phemba.» ");
INSERT INTO loq_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Mokɔlɔ mɔnɔmɔ, ɓato ɓasu ɓayakaka na ɓana ɓa ɓɛ́ɛ ooli Yesu oɓokye aɓapambole, kasi ɓaekosi ɓaɓaka ɓaɓakatele. ");
INSERT INTO loq_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Wawɛnɛ Yesu oɓokye ɓaɓakatele, aesi ya tɛmbɛ na ɓaekosi ɓɛ̀ɛ yokye: «Ɓɛɛ lɛ iɓakatela! Lɛ ɓana ɓakyɛɛ ɓaye oka nga, phɔ ɓokonzi pha Ŋwaphongo ɓoli phɔ ya ɓato ɓali ndokolo ɓana ɓakyɛɛ. ");
INSERT INTO loq_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nde phɛlɛ na wɔ na ɓɛ̀ɛ, ngakye: Ɓo moto taanosi ɓokonzi pha Ŋwaphongo ndokolo ŋwana mokyɛɛ, takokyi inyɔlɔ omɔ.» ");
INSERT INTO loq_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ɓoɓɛlɛ, Yesu aesi yaɓɛɓɛ ɓana mɛ, aɓatandesi maɓɔkɔ o nzótó, aɓapambosi. ");
INSERT INTO loq_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Waaɓa Yesu kalukye na ikyɛndɛ o Yelusalɛmɛ, moto monɔnɔ aesi na mbangu oka yɛ. Akyɛ mokusamela. Amba ya motuna yokye: «Moteye molaa, nakyele ɓo phɔ nazwe ɓomɔɔ pha ɓoɓɛlɛ na ɓoɓɛlɛ?» ");
INSERT INTO loq_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu amba ya mobuyisa yokye: «Phɔ ya'ye kontangye moto molaa? Moto molaa tali, ɓo teeɓe nde Ŋwaphongo.» ");
INSERT INTO loq_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Koeɓe miɓeko mimi: «“Saɓoma moto, sakyela ɓaphemba, sa iɓa, satɛmɛlɛ moto ɓonzoka ɓoɓe, sakpa mbolo ya ɓato na malondo maɓe, kumola nyɔngɔ na ɔngɔ.”» ");
INSERT INTO loq_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Moto mɛ amba ya wɔ nɛ yokye: «Moteye, nakumole miɓeko misɔ mamina tata ɓoŋwana pha nga.» ");
INSERT INTO loq_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu amba ya mokyeka na miyo maala yokye: «Oikasi na lowɔ lɔnɔlɔ, lɛɛ lolo: Kyɛ ungya mbolo ya wɛ isɔ, okpe ɓaphalanga mɛ oɓaphɛ ɓaɓola. Mɛna wamozwa ɓomengɔ o Ikolo. Emba ombe ya mbenga.» ");
INSERT INTO loq_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Waaoka moto mɛ ɓaɓona, yo munsɔ anyibi, aesi ya butwa na ngɔngɔ, phɔ aɓaka moto wa ezwele iikye. ");
INSERT INTO loq_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ɓoɓɛlɛ, Yesu aesi ya kyeka ɓaekosi ɓɛ̀ɛ ɓasɔ ɓaamolungyaka, amba ya wɔ na ɓɛ́ɛ yokye: «Eli nkamba phɔ ya ɓato ɓa ezwele inyɔlɔ o ɓokonzi pha Ŋwaphongo!» ");
INSERT INTO loq_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ɓaekosi ɓakamwaka na maphɔɔ mɛ. Kasi Yesu akulaka wɔ na ɓɛ́ɛ yokye: «Ɓana ɓanga, wali nde nkamba o inyɔlɔ o ɓokonzi pha Ŋwaphongo! ");
INSERT INTO loq_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Eli nkamba phɔ ya nyama enene ɓoli Shamo o ituɓana o iluu sa sɔlu. Kasi nkamba kyimbe kula lɔɓɔ phɔ ya moto wa ezwele o inyɔlɔ o ɓokonzi pha Ŋwaphongo.» ");
INSERT INTO loq_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ɓaekosi ɓakulaka kamwa na ɓoikye, ɓawɔnɔkɔ onte ya ɓɛ, ɓɛkye: «Ka ɓo eɓe ɓaɓona, ombi koka ibika nza?» ");
INSERT INTO loq_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu aɓakyekyi, amba ya wɔ na ɓɛ́ɛ yokye: «Moto takokyi imibikya yo mampenza, kasi nde Ŋwaphongo moto ookokyi imobikya, phɔ Ŋwaphongo akokyi ikyela maphɔɔ masɔ.» ");
INSERT INTO loq_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Emba Petelo amba ya wɔ nɛ yokye: «Kyeka! Ɓanga ɓaɓa toikyi ika isɔ yaaɓaka na ɓanga, tobuto ikyɛ mieɓenga.» ");
INSERT INTO loq_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu amba ya mobuyisa yokye: «Nde phɛlɛ, nawɔ na ɓɛ̀ɛ, ngakye: Ɓo moto aikyi ika ingambi sɛ, eɓe ɓanaa nyango, eɓe nyango na ango, eɓe ɓana ɓɛ, eɓe na manzabi mɛ, phɔ ya nga na phɔ ya Simo Elaa, ");
INSERT INTO loq_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","moto mɛ amokula izwa mbala munkama o mokyisi mumu. Eɓe mangambi, ɓanaa nyango, ɓanyango, ɓana, na manzabi. Aamba na nyɔkɔmɔ phɔ ya nga. Kasi mi nkɔlɔ ya moya, amozwa ɓomɔɔ pha ɓoɓɛlɛ. ");
INSERT INTO loq_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ɓato ɓaikye ɓali o ɓoo lɔlɔ eye, ɓamobutwa ɓaa o sima, emba ɓaikye ɓali lɔlɔ eye o sima, ɓamobutwa ɓaa o ɓoo.» ");
INSERT INTO loq_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Waaɓa Yesu na ɓaekosi ɓɛ̀ɛ ɓakyɛndɛ o Yelusalɛmɛ, Yesu aɓaka katambule o ɓoo pha ɓɛ. Ɓaekosi ɓaɓaka na ɓoilakye phɔ ɓakyɛndɛ o Yelusalɛmɛ, ɓato ɓaayɔkɔ ɓaɓaka na ɓɛ́ɛ ɓaɓaka na ɓolotakye. Yesu amba ya angyinya ɓaekosi ɓɛ̀ɛ iko na mbuka ɓaɓale, atati iɓa imola maphɔɔ maamoyelela. ");
INSERT INTO loq_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Amba ya wɔ na ɓɛ́ɛ yokye: «Okyemela! Uŋwaŋwa eye tokyɛndɛ o Yelusalɛmɛ, omɔɔ, nga Ŋwana wa Moto ɓamunzambya oka ɓakonzi ɓa ɓanganga ɓa Ŋwaphongo, na ɓateye ɓa miɓeko. Ɓamuntenela ɓolombe pha iwaa, ɓamba na nzambya oka ɓato ɓate ɓaeɓe Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ɓamunzakya, ɓamuntowa matee, ɓamumbinda phimbo, ɓamba na mboma. Kasi sima ya nkɔlɔ iyato, namokundwa.» ");
INSERT INTO loq_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ɓoɓɛlɛ, Zake na Yoane, ɓana ɓa ɓampele ɓa Zebede, ɓaesi ya kyɛ oka Yesu, ɓakyɛ wɔ nɛ ɓɛkye: «Moteye, tozingye oɓokye olokyelele maphɔɔ mamoeyonga ɓanga.» ");
INSERT INTO loq_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesu amba ya ɓatuna yokye: «Ɓɛɛ kozingye oɓokye naekyelele ye?» ");
INSERT INTO loq_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ɓamba mobuyisa ɓɛkye: «Waamokoma wɛ o ɓokonzi pha wɛ phaa nkyɛmɔ, olozasaka phɛnɛphɛ na wɛ, ona bi ɓoloo pha wɛ, oomoyɔkɔ bi ɓowɛɛ pha wɛ.» ");
INSERT INTO loq_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Kasi Yesu amba ya wɔ na ɓɛ́ɛ yokye: «Ɓɛ̀ɛ toeɓe lowɔ loongye ɓɛ̀ɛ. Kɔphɔ ya ɓolɔsi eya munywa nga, ɓɛ̀ɛ wamoenywa? Na iɓatisa sa minyɔkɔ saamozwa nga, ɓɛ̀ɛ waa sizwa mɛ?» ");
INSERT INTO loq_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ɓamobuyisaka ɓɛkye: «Tomokoka.» Yesu amba kula ya wɔ na ɓɛ́ɛ yokye: «Nde phɛlɛ, kɔphɔ ya ɓolɔsi eya munywa nga, na ɓɛ̀ɛ wamoenywa mɛ. Iɓatisa sa minyɔkɔ sa mozwa nga na ɓɛ̀ɛ wa sizwa mɛ. ");
INSERT INTO loq_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Kasi lowɔɔ la izasa ɓato, ona bii ɓoloo, omoyɔkɔ bii ɓowɛɛ pha nga, telokyekyi nga. Ɓiziye mɛ bili phɔ ya ɓato ɓaaunva ɓongya Ŋwaphongo.» ");
INSERT INTO loq_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Wa oka ɓaekosi iko ɓayɔkɔ lowɔ mɛ, ɓabuto iyokyela Zake na Yoane yɔɔ. ");
INSERT INTO loq_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesu aesi ya ɓaɓanga ɓɛ́ɛ ɓasɔ wali yo, amba ya wɔ na ɓɛ́ɛ yokye: «Ɓɛɛ koeɓe oɓokye ɓato ɓawɛnɛ ɓɛ̀ɛ ndokolo ɓakonzi ɓa ɓapakano, ɓakonza ɓato ɓa ɓɛ, ɓato ɓaanɛnɛ ɓawɛninya ɓato ɓa ɓɛ́ɛ mpasi. ");
INSERT INTO loq_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Nzuka, onte ya ɓɛ̀ɛ ɓaekosi tewali ɓaɓona. Ɓo monɔmɔ na ɓɛ̀ɛ kalukye iɓa moto munɛnɛ, lɛ oɓokye aɓe moto wa etoma wa ɓɛ̀ɛ. ");
INSERT INTO loq_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Nde ɓomɔ, ɓo mɔnɔmɔ na ɓɛ̀ɛ kazingye iɓa o ɓoo, esengyesi oɓokye aɓe moombo ŋwa ɓato ɓasɔ. ");
INSERT INTO loq_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Phɔ nga Ŋwana wa Moto siika yaa oɓokye ɓato ɓankyelele. Kasi naya nde oɓokye naɓakyelele, nambe na ambya ɓomɔɔ pha nga phɔ ya iikola ɓato ɓaikye o ɓoombo.» ");
INSERT INTO loq_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ɓobɛlɛ, Yesu na ɓaekosi ɓɛ̀ɛ ɓaesi ya koma o Yeliko. Waaɓa ɓɛ́ɛ na moluku ŋwa ɓato ɓatɔkɔlɔ o Yeliko, moto mɔnɔmɔ owa phɔlɔ miyo aɓaka wamɔ. Nkombo yɛ Ɓalatime, ŋwana wa Time, aɓaka kazale i mbale ya nzela phɔ ya iongaka. ");
INSERT INTO loq_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Waaoka yo oɓokye eli Yesu wa Nazalɛtɛ moto okolekane, abuto iaŋwana, yokye: «Yesu, Ŋwana wa Davidi, inzonkye ngɔngɔ.» ");
INSERT INTO loq_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ɓato ɓaikye ɓaphaphalaka nɛ, ɓɛkye: «Kanga munɔkɔ!» Kasi yo akulaka aŋwana nde na ɓokusi, yokye: «Ŋwana wa Davidi, inzokye ngɔngɔ.» ");
INSERT INTO loq_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesu aesi ya tɛmɛ, amba ya wɔ yokye: «Omoɓangye!» Ɓamba ya moɓanga, ɓɛkye: «Salota! Tɛmɛ, kaeɓangye!» ");
INSERT INTO loq_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ɓoɓɛlɛ amba ya vaka munkoto nwɛ, angɓɛngɔɔ, akyɛ oli Yesu. ");
INSERT INTO loq_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu amba ya motuna yokye: «Kozingye oɓokye naekyele'ye?» Moto owa phɔlɔ miyo amba ya mobuyisa yokye: «Moteye, kyela oɓokye nakule wɛnɛ.» ");
INSERT INTO loq_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Emba Yesu amba ya wɔ nɛ yokye: «Kyɛndɛ! Ianola sa wɛ siebikye!» Mina wamɔ, moto mɛ owa phɔlɔkɔ miyo abuto iwɛnɛ. Abuto ikyɛmikyɛndɛ na Yesu. ");
INSERT INTO loq_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yesu na ɓaekosi ɓɛ̀ɛ ɓaesi ya koma phɛnɛphɛ na Yelusalɛmɛ. Waata ɓaa ɓɛ́ɛ o Ɓetani, phɛnɛphɛ na Ɓetafaze, o ngomba ya nzete ya ikyiɓangye ɓɛ́ɛ ɓa-Olive, Yesu aesi ya toma ɓaekosi ɓɛ̀ɛ ɓaɓale, ");
INSERT INTO loq_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","yokye: «Kyɛndɛ o mokyisi moli o ɓoo. Ɓo okomi omɔ, wamokyɛ wɛnɛ ŋwana wa mpunda ɓamotingye. Naino moto tabaa mi yango. Ɓɛ̀ɛ oeyingole, oye na yango wawa. ");
INSERT INTO loq_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ka ɓo moto aetuni oɓokye “koeyingole phɔ ya'ye?” Ɓɛ̀ɛ omobuyisaka oɓokye: “Nkolo asengyesi na yango, amokula ebuyisa yango wawa izele.”» ");
INSERT INTO loq_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ɓoɓɛlɛ, ɓaekosi mɛ ɓaesi ya kyɛndɛ. Wakoma ɓɛ́ɛ omɔ, ɓakyɛ zwa ŋwana wa mpunda o munsɔngɔ, atingyi o nzee o moziɓo ŋwa ingambi sɔnɔsɔ. Ɓamba ya eingola. ");
INSERT INTO loq_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ɓato ɓaayɔkɔ ɓaɓaka wamɔ ɓamba ɓatuna ɓɛkyɛ: «Ɓɛɛ mɛna kokyele'ye? Koingole ŋwana wa mpunda mɔnɔ phɔ ya'ye?» ");
INSERT INTO loq_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ɓaekosi mɛ ɓamba ya ɓabuyisa ɓo wawɔkɔ Yesu na ɓɛ. Emba ɓato mɛ ɓamba ya ɓalɛ ɓakyɛ na yango. ");
INSERT INTO loq_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ɓaekosi ɓaesi ya kyɛ na ŋwana wa mpunda mɛ ooli Yesu. Ɓawasi bitobu ɓa ɓɛ́ɛ o ikolo sa ŋwana wa mpunda mɛ, Yesu amba ya zala o ikolo sa yango. ");
INSERT INTO loq_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ɓato ɓaikye ɓawalaka bitobu ɓa ɓɛ́ɛ o nzela. Ɓaayɔkɔ ɓakyelaka nkanga yatenaka ɓɛ́ɛ o manzabi o nzela. ");
INSERT INTO loq_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ɓato ɓaaɓaka ɓatambule o ɓoo pha Yesu, na ɓaaɓaka o sima yɛ, ɓaɓaka ɓaaŋwane ɓɛkyɛ: «Ozana! Ŋwaphongo apambole oko ye na nkombo ya Nkolo! ");
INSERT INTO loq_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ŋwaphongo apambole ɓokonzi ɓooye, ɓokonzi pha mokonzi Davidi nkɔkɔ wa ɓanga! Ozana oka Ŋwaphongo owa Ikolo!» ");
INSERT INTO loq_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Waakoma Yesu o Yelusalɛmɛ, aesi ya kyɛ nyɔlɔ o Tempelo. Waaunva yo ikyɛ miekyeka, amba ya butwa yo na ɓaekosi ɓɛ̀ɛ iko mbuka ɓaɓale o Ɓetani phɔ bunya phalekanaka. ");
INSERT INTO loq_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Mokɔlɔ ŋwaa sima, Yesu na ɓaekosi ɓɛ̀ɛ ɓaesi ya mana o Ɓetani. Waaɓa ɓɛ́ɛ ɓamane o Ɓetani, Yesu aesi ya oka nzala. ");
INSERT INTO loq_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Aesi ya wɛnɛ na itakye ŋwete mɔnɔmɔ ŋwa Fige ŋwa lɛɓɔlɔ, amba ya kyɛ mokyeka naa amozwa mbuma omɔ. Waakoma yo phɛnɛphɛ na ŋwete mɛ, akyɛ wɛnɛ nde maakyi na maakyi, phɔ imbɛlɛ sikute mbuma te sataaka koka. ");
INSERT INTO loq_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yesu amba ya wɔ na ŋwete mɛ yokye: «Moto nɔnɔ mɔnɔmɔ etakule zaa mbuma ya wɛ!» Na ɓaekosi ɓɛ̀ɛ ɓaokaka ɓo wa wɔkɔ Yesu na ŋwete mɛ. ");
INSERT INTO loq_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yesu na ɓaekosi ɓɛ̀ɛ ɓakuli koma o Yelusalɛmɛ. Yesu aesi ya nyɔlɔ o Tempelo, atati iwiinya ɓaungye na ɓaombi ɓa mbolo o mopkengba ŋwa Tempelo. Aesi ya bumbya ɓa mesa ɓa ɓaendinye ɓa ɓaphalanga. Akuli na bumbya biziye ɓa ɓato ɓaaungya mankotoŋwenya. ");
INSERT INTO loq_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Akatelaka ɓato ɓasɔ oɓokye: Moto salekana na ephesi o Tempelo. ");
INSERT INTO loq_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ɓoɓɛlɛ, Yesu amba ya teya ɓato yokye: «Ŋwaphongo kawɔ o buku phɛ yokye, “ɓamoɓanga Ingambi sa nga Ingambi sa losambo phɔ ya maɓota masɔ.” Amba kula ɓakya yokye: Ka ɓɛ̀ɛ osibuye iɓombo sa ɓaibi!» ");
INSERT INTO loq_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ɓakonzi ɓa ɓanganga ɓa Ŋwaphongo na ɓateye ɓa Miɓeko, ɓaokyi lowɔɔ loleka o Tempelo. Ɓaesi ya luka malondo ma iɓoma Yesu. Kasi ɓamoile phɔ ɓato ɓasɔ ɓaɓaka ɓasambe mateya mɛ. ");
INSERT INTO loq_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Waakoma wa nkɔkɔlɔ, Yesu na ɓaekosi ɓɛ̀ɛ ɓaesi ya mana o Yelusalɛmɛ. ");
INSERT INTO loq_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Na munkukutu, Yesu na ɓaekosi ɓɛ̀ɛ ɓakuli ya lekana mi nzela mɛ. Ɓaesi ya wɛnɛ ŋwete ŋwa Fige mɛ muungyi nɔnɔ o nkanga. ");
INSERT INTO loq_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petelo aesi ya umunya maphɔɔ mawɔlɛkyɛ Yesu ŋwete mɛ, amba ya wɔ nɛ yokye: «Moteye, kyeka, ŋwete ŋwa Fige ŋwawambaka wɛ munsɔ muungyi.» ");
INSERT INTO loq_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu amba ya wɔ na ɓaekosi ɓɛ̀ɛ yokye: «Ɓɛɛ, anola Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nde phɛlɛ nawɔ na ɓɛ̀ɛ, ngakye: Ɓo moto awɔ na ngomba eye yokye: “Mana wawana, kyɛndɛ mivaka o ebale eenɛnɛ!” Ɓo moto mɛ taɓe na ziko o ndondo yɛ, ɓo aanosi oɓokye loowɔ yo lamokyelama, Ŋwaphongo aamokyelela lango. ");
INSERT INTO loq_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Yango mɛna nawɔ na ɓɛ̀ɛ ngakye: Ɓo koɓɔndɛlɛ phɔ ya ionga ekpele oka Ŋwaphongo, anola oɓokye umbo ezwa, Ŋwaphongo amoephɛ yango. ");
INSERT INTO loq_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Waatɛmɛ ɓɛ̀ɛ phɔ ya iɓɔndɛlɛ, ɓooli na lowɔɔ na moto, omolimbisa. Na ɓomɔ, Ango wa ɓɛ̀ɛ ooli o Ikolo amoelimbisa na ɓɛ̀ɛ ɓoɓe pha ɓɛ̀ɛ».  ");
INSERT INTO loq_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ka ɓo ɓɛ̀ɛ toolimbisa ɓɛɓi, Ango wa ɓɛ̀ɛ oli o Ikolo nɛ etaelimbisa ɓoɓe pha ɓɛ̀ɛ. ");
INSERT INTO loq_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yesu na ɓaekosi ɓɛ̀ɛ ɓakuli ya nyɔlɔ o Yelusalɛmɛ. Waaɓa Yesu kakyɛmitambula o Tempelo, ɓakonzi ɓa ɓanganga ɓa Ŋwaphongo, na ɓateye ɓa Miɓeko, na ɓankumu ɓaesi wali yo. ");
INSERT INTO loq_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ɓamba ya motuna ɓɛkyɛ: «Kokyele maphɔɔ mamana na ɓokonzi iye? Owa ephɛ ɓokonzi pha ikyela maphɔɔ mamana nza?» ");
INSERT INTO loq_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesu amba ya ɓabuyisa yokye: «Naetune nde motuna mɔnɔmɔ, ɓo ombuyise, emba namba eimola na ɓokonzi iye ɓokyele na nga maphɔɔ mama. ");
INSERT INTO loq_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Owa tomaka Yoane iɓatisa ɓato nza? Yamotomaka Ŋwaphongo nde ɓato? Inzimole.» ");
INSERT INTO loq_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ɓabutwaka iwɔɔnɔ ɓɛ́ɛ na ɓɛ, ɓɛkye: «Ɓo tobuye oɓokye yamotomaka Ŋwaphongo, amokula lotuna yokye: “Toikaka anola Yoane phɔ ya'ye?” ");
INSERT INTO loq_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ɓotoombi kula mobuyisa oɓokye: “Yamotomaka ɓato…”» Ete wa ɓɔngɔ ɓailaka ɓato, phɔ ɓato ɓasɔ ɓaanolaka oɓokye Yoane ali nde owakolo moimosi wa Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Yango mɛna ɓamba ya buyisela Yesu ɓɛkye: «Toloeɓe.» Emba Yesu amba ya wɔ na ɓɛ́ɛ yokye: «Na nga mɛ esi eimole ɓo nakyele maphɔɔ mama na ɓokonzi pha nza.» ");
INSERT INTO loq_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Uŋwaŋwa eye Yesu atati iɓakpela bite, yokye: «Moto mɔnɔmɔ aɓalaka inzabi sa vinyɔ. Aesi ya silungya na kyengyete. Amba ya ima iɓela o maɓanga phɔ ya ikyela isungu sa iamola mbuma ya vinyɔ. Atongaka na ingambi sɔnɔsɔ sianda phɔ ya moto okokyɛngyɛlɛ sina inzabi. Sima amba ika siikyela ɓato ɓasiphutele, yo akyɛ o imbanga.» ");
INSERT INTO loq_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","«Waakoma imbɛlɛ sa inɔkɔ mbuma, mokolo inzabi aesi ya toma moto wa etoma wɛ oka ɓato ɓaphutele inzabi oɓokye akyɛ mokpela iyalo sa mbuma saaka yɛ. ");
INSERT INTO loq_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Kasi ɓato ɓaphutele inzabi ɓaakye moto wa etoma mɛ, ɓamokutubi, ɓambi na mobuya maɓɔkɔ pha. ");
INSERT INTO loq_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Mokolo inzabi akuli ya toma moto wa etoma mosuu, ɓamozokye o moto, ɓamba na mosambola. ");
INSERT INTO loq_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Emba mokolo inzabi akuli ya toma moto wa etoma mosuu. Ka mɔnɔ, ɓato ɓaphutele inzabi ɓamoɓomi. Mokolo inzabi amba kula ya toma ɓato ɓa etoma ɓasuu ɓaikye. Kasi ɓakulaka ɓakyela nde ɓomɔ, ɓakutuɓaka ɓakyi, ɓaɓomaka ɓaayɔkɔ. ");
INSERT INTO loq_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Mokolo inzabi aesi ya ikala nde na ŋwana wɛ mɔnɔmɔ owa lɔɓɔkɔ yo zinga. O mbomela esɔ amba ya toma ŋwana mɛ oka ɓɛ, o ndondo yɛ yokye: “Ɓamokumola ŋwana wa nga.” ");
INSERT INTO loq_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Kasi ɓato ɓaaphutele inzabi ɓamba ya wɔnɔ onte ya ɓɛ, ɓɛkye: “Kyeka sɔmi yɛ, owamoikala na sina inzabi ɓo ango awe! Yaka tomoɓome, inzabi mɛ saamba butwa sa ɓanga!” ");
INSERT INTO loq_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ɓaesi yaakya ŋwana mɛ, ɓamoɓomi, ɓakyɛ movaka o sɛlɛkyɛ ya inzabi». ");
INSERT INTO loq_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","«Mokolo wa inzabi aaɓakyela ɓo? Amoya ɓoma ɓato ɓaphutele inzabi ɓaaɓana. Amba siphɛ ɓato ɓasuu. ");
INSERT INTO loq_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ɓɛ̀ɛ toika tanga maphɔɔ mama o buku pha Ŋwaphongo? Ɓo wakoma ɓɛ́ɛ oɓokye: “Iɓanga saavakaka ɓatongyi ɓa mangambi, sibuto iɓanga siiphisi ingambi sisɔ. ");
INSERT INTO loq_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Mɛna etoma ya Ŋwaphongo. O miyo ma ɓanga eli lowɔ la ikamwa”» ");
INSERT INTO loq_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ɓakonzi ɓa Ɓayuda ɓalukaka malondo ma iyakya Yesu, phɔ ɓaeɓaka oɓokye akpaka ete mɛ nde phɔ ya iɓalungola. Kasi ɓailaka ɓato ɓaaɓaka wamɔ, ɓamba ya molɛ, nɔnɔ owa kyɛ ɓɛ. ");
INSERT INTO loq_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ɓakonzi ɓa Ɓayuda ɓamba ya toma ndambo ya Ɓafalisayi, na ɓato ɓasuu ɓali mbale na Elode Antipasi oli Yesu. Ɓaesi ya motuna mituna, phɔ ya imolɔngɔ oɓokye ɓamozwe na maloɓa mɛ mampenza. ");
INSERT INTO loq_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ɓaesi ya motuna ɓɛkye: «Moteye, toeɓe oɓokye iwɛ kowɔ nde maphɔɔ maa phɛlɛ, tooile na moto. Tooile na ɓoo pha moto, kasi koteya nde o phɛlɛ maphɔɔ ma Ŋwaphongo. Taa loimola, phɔ ya lowɔ lokyekyi mputi ya Kaisala, miɓeko ma ɓanga miwɔ ɓo? Tokokyi iphuta nde tolokokyi iphuta?» ");
INSERT INTO loq_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Kasi Yesu aeɓaka oɓokye ɓaziti maphɔɔ masuu. Amba ya wɔ na ɓɛ́ɛ yokye: «Koya mbekyisa izɛngyɛ phɔ ya'ye? Inzelele na phalanga yɔnɔyɔ ya eɓende, naekyekye.» ");
INSERT INTO loq_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ɓaesi ya moeyelela na yango. Yesu amba ya ɓatuna yokye: «Mi eɓende eye, ɓoo pha eema ɓɛ́ɛ ɓoɓo, na nkombo eya koma ɓɛ́ɛ eye, ya nza?» Ɓamba ya mobuyisa ɓɛkye: «Ya Kaisala.» ");
INSERT INTO loq_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Emba Yesu amba ya wɔ na ɓɛ́ɛ yokye: «Phɛ Kaisala yaaka Kaisala, phɛ Ŋwaphongo yaaka Ŋwaphongo.» Ɓakamwaka na ɓoikye na eyano ya Yesu. ");
INSERT INTO loq_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ɓasadukayi ɓaayɔkɔ ɓaesi oli Yesu. Oka ɓɛ́ɛ Ɓasadukayi ɓawɔ oɓokye ɓato ɓaawa ete ɓakundwe. Ɓamba ya tuna Yesu ɓɛkye: ");
INSERT INTO loq_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Moteye, Mose alokomela o buku pha Miɓeko ɓoɓo: “Ɓo ɓola awe aikyi ika ŋwaŋwasi kasi taikyi ɓota nɛ, esengyesi oɓokye mosi nyɛ azasa ɓozengye ɓaɓona phɔ ɓola phɛ owa wa azwe ɓana.” ");
INSERT INTO loq_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Yaɓaka ɓaɓona o mokyisi mɔnɔmɔ, ɓana ɓa ɓampele sambo, ɓaɓaka ɓɛ́ɛ ɓasɔ nyango mɔnɔmɔ ango mɔnɔmɔ. Ɓola pha ɓɛ́ɛ aesi ya longa ŋwaŋwasi, awe sa ɓota nɛ. ");
INSERT INTO loq_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Owa iɓale aesi ya zasa ɓozengye mɛ. Akuli waa sa ɓota nɛ. Yakulaka ɓa nde ɓomɔ oka mosi nyɛ owa iyato. ");
INSERT INTO loq_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ɓɛ́ɛ ɓasɔ sambo ɓaazasaka ɓozengye mɛ, ɓawa sa ɓota nɛ. O sima ya ɓɛ́ɛ ɓasɔ, ɓozengye mɛ amba ya waa nɛ.» ");
INSERT INTO loq_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ka mokɔlɔ ŋwa mokundwa ɓawe, onte ya ɓɛ́ɛ ɓasɔ sambo, amoɓa ŋwaŋwasi wa nza? Phɔ ɓɛ́ɛ ɓasɔ ɓamozasaka. ");
INSERT INTO loq_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu amba ya wɔ na ɓɛ́ɛ yokye: «Ɓɛ̀ɛ komɛngyɛ! Phɔ toeɓe maphɔɔ makoma ɓɛ́ɛ o buku pha Ŋwaphongo, eɓe na mwiya nwɛ. ");
INSERT INTO loq_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Phɔ mokɔlɔ ŋwa mokundwa ɓawe, malonga etemakule ɓaa. Kasi ɓaɓasi na ɓampele ɓamobutwa ndokolo ɓaanzelu ɓa ikolo. ");
INSERT INTO loq_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Phɔ ya lowɔ lokyekyi ikundwa sa ɓawe, naeɓe phɛlɛ oɓokye ɓɛ̀ɛ waunva tanga simo ya ŋwete mookyikyi ŋwalolaka sa zika. Omɔ Ŋwaphongo awɔkɔ na Mose yokye: “Nga nali Ŋwaphongo wa Abalayama, wa Izake, na wa Yakoɓo.” ");
INSERT INTO loq_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Yo tali Ŋwaphongo wa ɓawe, kasi ali Ŋwaphongo wa ɓato ɓaali na ɓomɔɔ. Owɛni! Yango mɛna ɓɛ̀ɛ komikosa na ɓoikye.» ");
INSERT INTO loq_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Moteye wa miɓeko mɔnɔmɔ aɓaka kaokye ɓo waɓaka Yesu na Ɓasadukayi ɓaikane ziko. Aesi ya wɛnɛ oɓokye Yesu abuyise Ɓasadukayi na ɓolaa, amba ya susinya, akyɛ motuna yokye: «Onte ya miɓeko misɔ ma Ŋwaphongo, moɓeko ye molekyi miiyɔkɔ?» ");
INSERT INTO loq_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu amba ya mobuyisa yokye: «Moɓeko molekyi miiyɔkɔ ŋwango mumu: “Isalayɛlɛ, okyemela! Ŋwaphongo Nkolo wa ɓanga ali nde yo mɔnɔmɔ, mosuu tali. ");
INSERT INTO loq_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Zinga Ŋwaphongo Nkolo wa wɛ na ndondo ya wɛ esɔ, na molimo ŋwa wɛ munsɔ, na maumunya ma wɛ masɔ, na ná ɓokusi pha wɛ ɓosɔ.” ");
INSERT INTO loq_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Moɓeko ŋwa iɓale ŋwango mumu: “Zinga nwɛbi na wɛ ɓookomizingye wɛ mampenza.” Moɓeko mosuu moolekye miɓale maamina temoli.» ");
INSERT INTO loq_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ɓoɓɛlɛ moteye wa miɓeko amba ya wɔ na Yesu yokye: «Moteye, eli nde ɓomɔ! Iwɔ wɛ ili nde phɛlɛ: Ŋwaphongo Nkolo wa ɓanga ali nde yo mɔnɔmɔ, mosuu tali. ");
INSERT INTO loq_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Esengyesi oɓokye tozingye Ŋwaphongo na ndondo ya ɓanga esɔ, na maumunya ma ɓanga masɔ, na ná ɓokusi pha ɓanga ɓosɔ, toombe kula na zinga ɓɛɓi na ɓanga ɓookomizengye ɓanga mampenza. Elekyi ɓolaa ikyela ɓaɓona, na oɓokye otumbele Ŋwaphongo mambeka ma manyama na imophɛ bilambo.» ");
INSERT INTO loq_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu aesi ya wɛnɛ oɓokye moteye wa miɓeko amobuyise na zebi sisɔ, amba ya wɔ nɛ yokye: «Toli itakye na ɓokonzi pha Ŋwaphongo.» Ɓanda wamɔ, na moto mɔnɔmɔ takulaka meka imotuna mituna. ");
INSERT INTO loq_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Waaɓa Yesu kateya o Tempelo, amba ya tuna motuna yokye: «Phɔ ya'ye ɓateye ɓa miɓeko ɓawɔ ɓɛkye: “Masiya ali nde Ŋwana wa Davidi?” ");
INSERT INTO loq_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Davidi na ɓokambemakye pha Ɓolɔɓɔ Ɓosanto, awɔkɔ yokye: Ŋwaphongo kawɔ na Nkolo yanga yokye: “Yaka ya zale o ɓoloo pha nga tee nɔnɔ waamouya nga ɓanguna ɓa wɛ.” ");
INSERT INTO loq_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Davidi yo mampenza kamoɓangye Nkolo, ka ndengye'ye Masiya ambi kula koka iɓa ŋwana nwɛ?» Ɓato ɓaikye ɓaɓaka ɓaokye Yesu na nkyisa. ");
INSERT INTO loq_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Aɓateyaka yokye: «Ɓɛɛ nde kokyeɓe na ɓateye ɓa miɓeko. Ɓɛ́ɛ ɓazingye ikyɛmitambula na bitobu biinɛnɛ, bianda, ɓakule na zinga oɓokye ɓa ɓaɓeyakye o bilele biangane ɓato ɓaikye phɔ ya imiebinya oɓokye ɓali ɓaakolo ɓato. ");
INSERT INTO loq_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ɓaɔlɔ biziye ɓa o ɓoo o Mangambi ma makyita, eɓe na biziye baa kaa o bisɛlɛkɔ. ");
INSERT INTO loq_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ɓaiyele mazengye na mbolo ya ɓɛ́ɛ isɔ na malondo maɓe. Phɔ ya iɓomba ɓoɓe pha ɓɛ, ɓambe bunzinya na maɓɔndɛsi maanda. Yango mɛna Ŋwaphongo aaɓaphɛ etumbu yɔnɔyɔ yamoleka ɓonɛnɛ.» ");
INSERT INTO loq_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu amba ya kyɛ zala phɛnɛphɛ na ekɔkɔlɔ ekye kyɛ ambya ɓɛ́ɛ makaɓo o Tempelo. Aɓaka kakyekye ɓo koyaambya ɓato makaɓo. Ɓaabizwele ɓaambyaka ɓaphalanga ɓaikye. ");
INSERT INTO loq_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ɓozengye ɓɔnɔɓɔ phaɓaka wamɔ, yo moɓola. Nɛ aesi yaambya ɓanaa ɓaphalanga ɓa biɓende ɓaɓale ɓaa motiya mokyikyi. ");
INSERT INTO loq_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Emba Yesu amba ya ɓanga ɓaekosi ɓɛ̀ɛ, awɔ na ɓɛ́ɛ yokye: «Nde phɛlɛ na wɔ na ɓɛ̀ɛ ngakye: Ikaɓo sa ɓozengye ɓoɓo, yo moɓola, silekyi makaɓo masɔ maambye ɓɛ́ɛ wawa. ");
INSERT INTO loq_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Phɔ ɓaabizwele, ɓaambye nde ɓaphalanga ɓate ɓaasengyelaka na ɓɛ. Ka ɓozengye ɓoɓo, na ɓoɓola phɛ, ambye nde ɓanaa ɓaphalanga ɓasɔ ɓaɓaka nɛ, takuli ikala na ná ekpele yɔnɔyɔ ya ibika.» ");
INSERT INTO loq_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Waɓa Yesu katɔkɔlɔ o Tempelo, mɔnɔmɔ na ɓaekosi ɓɛ́ɛ amba ya wɔ nɛ yokye: «Moteye, kyeka! Eye maɓanga ɓolaa, eye mangambi manɛnɛ!» ");
INSERT INTO loq_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesu amba ya mobuyisa yokye: «Kowɛnɛ mangambi maanɛnɛ mama te? Etewaaikale na iɓanga sɔnɔsɔ wawa, masɔ mamunyangwa.» ");
INSERT INTO loq_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ɓoɓɛlɛ, Yesu amba ya kyɛ zala o ikolo sa ngomba ya ɓa Olive, ekyekyekane na Tempelo. Petelo, Zake, Yoane na Andele, ɓaɓaka nɛ omɔ, ɓamba ya motuna ɓɛkye: ");
INSERT INTO loq_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«Taa loimola, maphɔɔ maawɔɔ wɛ mamokyelama imbɛlɛ ye? Tomba na eɓa na ye oɓokye imbɛlɛ mɛ sikokyi?» ");
INSERT INTO loq_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesu amba ya ɓabuyisa yokye: «Kyeɓa, moto saekatela. ");
INSERT INTO loq_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ɓato ɓaikye ɓamoyaa na nkombo ya nga, ɓamowɔ ɓɛkye: “Masiya nga oyo!” Ɓamokatela ɓato ɓaikye. ");
INSERT INTO loq_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Wamooka ɓɛ̀ɛ oɓokye mabita maeyelele, na masimo ma mabita mali bisuu, ɓɛ̀ɛ sa ila! Esengyesi oɓokye maphɔɔ mamana mayee, kasi mɛna etee taaɓa suka ya mokyisi. ");
INSERT INTO loq_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ekolo yɔnɔyɔ yamuŋwana na ekolo eyɔkɔ, ɓokonzi ɓɔnɔɓɔ phamuŋwana na ɓokonzi ɓooyɔkɔ. Manyɛtɛ mamunyingana o bilele biikye, zilo sikusi samoɓa. Maphɔɔ masɔ mamana mamoɓa ndokolo etatele ya eswɛtɛ ya iɓota. ");
INSERT INTO loq_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Kasi ɓɛ̀ɛ, ɓaa na ɓokyebi, ɓato ɓamoesongyela oka ɓananga. Ɓamoebinda phimbo o mangambi ma losambo. Phɔ ya nga, ɓamokyɛ na ɓɛ̀ɛ o ɓoo pha ɓaangyesi ɓa nkyisi na o ɓoo pha ɓakonzi. Na ɓomɔ, wamoɓa manzoka manga o ɓoo pha ɓɛ. ");
INSERT INTO loq_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Phɔ esengyesi oɓokye Simo Elaa eimolame naino oka ɓato ɓasɔ, emba suka ya mokyisi eembe yaa. ");
INSERT INTO loq_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ka waamokyɛ ɓɛ́ɛ na ɓɛ̀ɛ o ɓoo pha ɓananga phɔ ya ikyɛ samba, ɓɛ̀ɛ sataa miima phanza phɔ ya maphɔɔ maamowɔ ɓɛ̀ɛ. Imɓɛlɛ mɛ, wamowɔ nde maphɔɔ maamoeteya Ŋwaphongo, phɔ etewɔ ɓɛ̀ɛ, kasi yaamowɔ ɓɛ̀ɛ yamouta nde na Ɓolɔɓɔ Ɓosanto. ");
INSERT INTO loq_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Onte ya maɓota, ɓana ɓamuungya ɓana nyango na ɓɛ́ɛ oɓokye ɓaɓaɓome. Ɓaango ɓa ɓana ɓamokyela nde ɓomɔ na ɓana ɓa ɓɛ. Ɓana ɓamobutwa ɓanguna ɓa ɓaɓoti ɓa ɓɛ, ɓaɓaungya oka ɓakonzi oɓokye ɓaɓaɓome. ");
INSERT INTO loq_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ɓato ɓasɔ ɓamoeyina phɔ ya nga. Kasi owamoititala nɔnɔ o suka, yo mɔna Ŋwaphongo aamobikya.» ");
INSERT INTO loq_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«Wamowɛnɛ okoɓangye ɓɛ́ɛ “mɔɔti owa inganga”: Atɛmi o elele etekokyi yo iɓa. (Motangyi wa maphɔɔ mama amasɔsɔlɔ). Imbɛlɛ mɛ, ɓaamoɓa o manyɛtɛ ma Yuda, ɓɛ́ɛ elotaka bi mangomba. ");
INSERT INTO loq_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Owamoɓa o iɓanda yo sakula nyɔlɔ o ingambi phɔ ya ikyɛ kpa mbolo yɛ. ");
INSERT INTO loq_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Na owamoɓa o inzabi, yo sakula butwa o ingambi phɔ ya ikyɛ kpa etobu yɛ. ");
INSERT INTO loq_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","O nkɔlɔ mɛ, ngɔngɔ ya moɓa na ɓaɓasi ɓaekama, na ná malekyele. ");
INSERT INTO loq_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ɓɔndɛlɛ Ŋwaphongo oɓokye imbɛlɛ mɛ sango saɓa wa mambula. ");
INSERT INTO loq_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Phɔ nkɔlɔ mɛ ya moɓa yaa malɔsi maikye maali naino ɓato sawɛnɛ uta o etatele ya mokyisi ɓowamokyela Ŋwaphongo nɔnɔ lɔlɔ eye. Malɔsi maamoulana na mango etemaawɛnɛnɛ. ");
INSERT INTO loq_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ɓo Ŋwaphongo tabukolaka nkɔlɔ ya malɔsi mɛ phe, moto nɔnɔ mɔnɔmɔ nde tabikyi. Kasi aibukola phɔ ya ɓato ɓaɔlɔ yo phɔ yɛ. ");
INSERT INTO loq_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","O imbɛlɛ mɛ, ɓo moto awɔ na ɓɛ̀ɛ yokye: “Kyeka, Masiya ali wawa!” naa “ali wana!” ɓɛ̀ɛ samoanolela. ");
INSERT INTO loq_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Phɔ ɓa masiya ɓaaɓɔlɛ, na ɓaimosi ɓaaɓolɛ ɓamoya ɓaikye. Ɓamokyela bilekyesako na maphɔɔ maikamwa phɔ ɓo walongoɓa ɓazwe nzela ya ikosa ɓato ɓaaunva ɔlɔ Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Yango mɛna, ɓɛ̀ɛ oeɓaka! Naumbo ekyebisa na maphɔɔ masɔ maamoya.» ");
INSERT INTO loq_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«Kasi mi nkɔlɔ mɛ, waamunva malɔsi masɔ mamana, moo ŋwamobutwa enzɔmbi, ɓokombe eteɓokule ngala. ");
INSERT INTO loq_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ɓanyasɛɛsi ɓamobiya, isɔ iili o ikolo yamunyingana. ");
INSERT INTO loq_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Emba imbɛlɛ mɛ, ɓamunvɛnɛ nga Ŋwana wa Moto naye onte ya mapata, na mwiya mwikye na ná nkyɛmɔ nzikye. ");
INSERT INTO loq_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Namba ya toma ɓaanzelu ɓanga oɓokye ɓaangyinya ɓato ɓasɔ ɓaaunva nga ɔlɔ. Ɓato mɛ ɓamouta o bilele bisɔ ɓa mokyisi.» ");
INSERT INTO loq_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","«Sɔsɔlɔ na ɓolaa ete ya ŋwete ŋwa fige. Ɓo molɛɓɔsi, mɛna ɓɛ̀ɛ koeɓe oɓokye imbɛlɛ sa ikyɛtɛ sikokyi. ");
INSERT INTO loq_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Nde ɓomɔ, waamowɛnɛ ɓɛ̀ɛ maphɔɔ masɔ maamana makyelame, oeɓe oɓokye waɓuto phɛnɛphɛ. ");
INSERT INTO loq_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nde phɛlɛ nawɔ na ɓɛ̀ɛ ngakye: Maphɔɔ masɔ mama mamokyelama, naino ɓato ɓaayɔkɔ ɓali na ɓanga lɔlɔ eye sataa waa. ");
INSERT INTO loq_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ikolo na munse yamolekana, kasi maphɔɔ ma nga etemaalekane.» ");
INSERT INTO loq_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","«Moto nɔnɔ mɔnɔmɔ taeɓe na mokɔlɔ na imbɛlɛ saamokyelama maphɔɔ maamana. Eɓe ɓaanzelu o ikolo teɓaeɓe, eɓe na ona nga Ŋwana wa Ŋwaphongo sieɓe; kyeeɓe nde Tata Ŋwaphongo yo mampenza. ");
INSERT INTO loq_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ɓɛ̀ɛ oeɓaka! Sa lala ebuu phɔ toeɓe waamokoka sina imbɛlɛ mɛ. ");
INSERT INTO loq_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Yamoɓa ndokolo moto mɔnɔmɔ ookokyɛ o imbanga. Okokyɛ yo, aikyi ika ɓokonzi pha ingambi sɛ oka ɓato ɓɛ̀ɛ ɓaetoma. Aikyi phɛ moto na moto yɛ etoma ya ikyela. Amba ya wɔ na sinzili yokye akyɛngyɛlɛ ingambi na ɓolaa. ");
INSERT INTO loq_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Nde ɓomɔ, na ɓɛ̀ɛ okyɛngyɛlɛkyɛ phɔ toeɓe imbɛlɛ sa moya nkolo ya ingambi, naa amoya wa nkɔkɔlɔ, naa wa molengyela, naa wa tɔngɔ masoo, naa wamumbengu. ");
INSERT INTO loq_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ɓoaesi mbanyaka, yo sa yaetakana olasi ebuu. ");
INSERT INTO loq_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Maphɔɔ maewɔlɛ nga mama, namawɔlɛ na ɓato ɓasɔ oɓokye: Nde kokyɛngyɛlɛ na ɓolaa.» ");
INSERT INTO loq_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Uŋwaŋwa eye yaikalaka nde nkɔlɔ iɓale oɓokye Ɓayuda ɓaze eyenga ya ɓɛ́ɛ ya iumunya ɓo wabikyaka Ŋwaphongo ɓankɔkɔ ɓa ɓɛ́ɛ o Ezipito, na eyenga ekyeze ɓɛ́ɛ mapa maa te maaulwe. Ɓanganga ɓanɛnɛ na ɓateye ɓa Miɓeko ɓalukaka malondo ma iyakya Yesu na ma imoɓoma oɓokye ɓato saeɓa. ");
INSERT INTO loq_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ɓɛ́ɛ na ɓɛ́ɛ ɓɛkye: «Ɓo tomoakye o miyo ma ɓato ɓaaze eyenga, ɓamotɔmbɔ na ɓanga.» ");
INSERT INTO loq_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Uŋwaŋwa eye Yesu aesi yakyɛ o Ɓetani. Aesi ya kyɛ zala o ingambi sa Simo owaɓaka na ɓolɔsi pha maɓa. Waaɓa ɓɛ́ɛ ɓaze o mesa, ŋwaŋwasi mɔnɔmɔ aesi ya nyɔlɔ o ingambi mɛ. Aɓaka na molangyi ŋwa malasi. Ɓakyelaka malasi mɛ na ŋwete mɔnɔmɔ na nkombo naladi. Amaombaka na motiya moikye. Ɓakyelaka molangyi mɛ na iɓanga siɓangye ɓɛ́ɛ alaɓata. Aesi ya ɓola munɔkɔ ŋwa molangyi mɛ. Amba ya sweya mana malasi o moto ŋwa Yesu. ");
INSERT INTO loq_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ɓato ɓaayɔkɔ ɓaɓaka wamɔ ɓamookyelaka yɔɔ. Ɓawɔnɔkɔ ɓɛkye: «Phɔ ya'ye aɔti malasi mama ɓoɓo?» ");
INSERT INTO loq_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ɓo ɓamaungye, nde ɓazwe ɓaphalanga ɓa biɓende nkama iyato. Emba ɓaphɛ ɓaɓola ɓana ɓaphalanga mɛ. Ɓabilelaka ŋwaŋwasi mɛ mankyɛɛ. ");
INSERT INTO loq_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Kasi Yesu yokye: «Ɓɛɛ omolɛ ɓose. Phɔ ya'ye komunyɔkɔlɔ? Ŋwaŋwasi oyo ankyesi ɓolaa. ");
INSERT INTO loq_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ɓaɓola ɓamoikalaka na ɓɛ̀ɛ ɓoɓɛlɛ. Waaɓakyela ɓolaa nkɔlɔ isɔ ɓoozingye ɓɛ̀ɛ. Ka nga, esikale na ɓɛ̀ɛ ɓoɓɛlɛ. ");
INSERT INTO loq_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ŋwaŋwasi mɛ akyesi ikokyi nɛ. Ambo nzɔlɔlɔ malasi o nzoto phɔ ya oɓokye iɓɔngɔ mokɔlɔ ŋwa munkunda ɓɛ. ");
INSERT INTO loq_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nde phɛlɛ nawɔ na ɓɛ̀ɛ ngakye: Ɓo ɓakyɛ imola Simo Elaa, eɓe mbale ewaa o nkyisi isɔ, ɓamoimolaka na maphɔɔ maakyesi ŋwaŋwasi oyo oɓokye ɓato ɓamaumunya.» ");
INSERT INTO loq_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Mɔnɔmɔ onte ya ɓaekosi iko mbuka ɓaɓale, nkombo yɛ Yudasi Mokeliyota, aɓaka wamɔ. Amba yakyɛ oka ɓanganga ɓaanɛnɛ oɓokye ambya Yesu. ");
INSERT INTO loq_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Waaoka ɓɛ́ɛ ɓoɓo, ɓaɓaka na nkyisa. Ɓamolakyelaka imophɛ ɓaphalanga. Alukaka ndengye ewaa eyamoambya yo Yesu. ");
INSERT INTO loq_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Mokɔlɔ ŋwa etatele ŋwa eyenga ekyeze ɓɛ́ɛ mapa maate maulwe, mokɔlɔ moɓome ɓɛ́ɛ mampate phɔ ya iza eyenga ya Ilekana, ɓaekosi ɓa Yesu ɓamba ya motuna ɓɛkye: «Ozingyi oɓokye tokyɛ ɓɔngya elele eyamoza wɛ eyenga ya Ilekana bi?» ");
INSERT INTO loq_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Yesu amba ya toma ɓaekosi ɓaɓale yokye: «Kyɛndɛ o mokyisi muunɛnɛ. Lele mɔnɔmɔ amovana na ɓɛ̀ɛ. Aphisi mbongo ya maa. Ɓɛɛ, omoɓengaka. ");
INSERT INTO loq_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Elele eya moatola yo, na ɓɛ̀ɛ, waatola nde wamɔ. Wamoimola nkolo ya ingambi ɓoɓo: “Moteye awɔ, yokye: Oloteya elele eyamoza yo na ɓaekosi ɓɛ̀ɛ eyenga ya Ilekana.” ");
INSERT INTO loq_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Emba amokyɛ eteya elele eyaɛmbɔ o ingambi, eyatonga ɓɛ́ɛ o ikolo sa eyɔkɔ. Mbolo isɔ isengyesi na ɓanga ili wamɔ. Elele mɛ nde yango mɛna, eya mobɔngya ɓɛ̀ɛ oɓokye toze eyenga.» ");
INSERT INTO loq_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ɓaekosi mɛ ɓaɓale ɓaesi ya kyɛndɛ. Ɓaesi ya koma o mokyisi muunɛnɛ mɛ. Ɓamba yazwa maphɔɔ masɔ nde ɓomɔ, ɓo waɓawɔlɛkyɛ Yesu. Ɓamba ya ɓɔngya mbolo isɔ ya eyenga. ");
INSERT INTO loq_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Waainda bunya, Yesu aesi ya koma na ɓaekosi ɓɛ̀ɛ iko mbuka ɓaɓale. ");
INSERT INTO loq_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ɓaesi yakyɛ zaa o elele mɛ. Waaɓa ɓɛ́ɛ ɓaze, Yesu amba ya wɔ na ɓɛ́ɛ yokye: «Nde phɛlɛ na wɔ na ɓɛ̀ɛ, ngakye: Onte ya ɓɛ̀ɛ ɓaaze na nga, mɔnɔmɔ amunzambya.» ");
INSERT INTO loq_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Waaoka ɓaekosi ɓaaɓona, ɓɛ́ɛ ɓasɔ ɓaokaka ngɔngɔ. Ɓaesi ya motuna, mɔnɔmɔ na mɔnɔmɔ ɓɛkye: «Eli nga nde'ye?» ");
INSERT INTO loq_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesu yokye: «Eli nde mɔnɔmɔ na ɓɛ̀ɛ ɓaekosi, ɓaaze na nga ɓaɓa. ");
INSERT INTO loq_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ŋwana wa Moto amowaa nde ɓo wakoma ɓɛ́ɛ phɔ yɛ, kasi ngɔngɔ ya moto owamunzambya. Ɓolaa ɓo moto mɛ taikaka ɓotama.» ");
INSERT INTO loq_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Waaɓa ɓɛ́ɛ ɓaze, Yesu aesi yakpa mapa, aphɛ Ŋwaphongo mɛlɛsi, amakyɛsi, amaphɛ ɓaekosi ɓɛ̀ɛ yokye: «Kpa oze, eye eli nzoto ya nga.» ");
INSERT INTO loq_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Akuli ya kpa kɔphɔ, aphɛ Ŋwaphongo mɛlɛsi, aephɛ ɓaekosi. Ɓɛ́ɛ ɓasɔ ɓaesi ya enywa. ");
INSERT INTO loq_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Yesu yokye: «Eye eli malongo ma nga, malongo ma sangola, maasweye phɔ ya ɓato ɓaikye. ");
INSERT INTO loq_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nde phɛlɛ nawɔ na ɓɛ̀ɛ ngakye: Esiikule nywa malɛku mama tee nɔnɔ mokɔlɔ ŋwa mokula nga manywa o ɓokonzi pha Ŋwaphongo.» ");
INSERT INTO loq_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ɓoɓɛlɛ Yesu na ɓaekosi ɓɛ̀ɛ ɓamba ya tuɓa meembo ma Ŋwaphongo. Waunva ɓɛ́ɛ ituɓa meembo, ɓamba ya kyɛndɛ o Ngomba ya ɓa Olive. ");
INSERT INTO loq_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu amba ya wɔ na ɓaekosi ɓɛ́ɛ yokye: «Ɓɛ̀ɛ ɓasɔ wamundota. Phɔ, ɓakoma o buku pha Ŋwaphongo ɓoɓo: “Namoɓoma mɔɔkɔsi wa mampate, emba mampate mamunyangwa.” ");
INSERT INTO loq_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Kasi waamokundwa nga, namokyɛ o Galileya o ɓoo pha ɓɛ̀ɛ.» ");
INSERT INTO loq_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petelo amba ya wɔ nɛ yokye: «Na ɓo ɓɛ́ɛ ɓasɔ ɓaeloti, nga esielote.» ");
INSERT INTO loq_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu amba ya mobuyisa yokye: «Nde phɛlɛ na wɔ na wɛ, nde o mokɔlɔ ŋwa lɔlɔ, mɛna soo saɓotɔngɔkye mbala iɓale, iwɛ wamunzangana mbala iyato oɓokye toonzeɓe.» ");
INSERT INTO loq_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Kasi Petelo amba kpɛtɛ kapha yokye: «Naɓoeɓe oɓokye na wee na wɛ elele yɔnɔyɔ, nga esieyangane.» Ɓaekosi ɓasɔ ɓamba ya wɔ nde ɓomɔ. ");
INSERT INTO loq_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Yesu na ɓaekosi ɓɛ̀ɛ ɓamba ya koma o elele yɔnɔyɔ ekyeɓangye ɓɛ́ɛ Getesemani. Yesu aesi ya wɔ na ɓaekosi ɓɛ́ɛ yokye: «Ɓɛ̀ɛ zala wawa nga nakyɛ ɓɔndɛlɛ Ŋwaphongo.» ");
INSERT INTO loq_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Amba yakyɛ na Petelo, Zake na Yoane. Ɓoɓɛlɛ atati iyoka ndondo ɓolɔsi na inganga. ");
INSERT INTO loq_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Amba ya wɔ na ɓɛ́ɛ yokye: «Ndondo ya nga etondi na ngɔngɔ ndokolo namowa; ikala wawa, ɓɛ̀ɛ okyɛngyɛkye.» ");
INSERT INTO loq_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Amba yakyɛ ŋwana itakye, akyɛ kusama, atati iɓɔndɛlɛ phɔ ɓowakokyi ikyelama, imbele sa ɓolɔsi siimoziya simane itakye nɛ. ");
INSERT INTO loq_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Amba ya wɔ yokye: «Aba, Tata, iwɛ okokyi ikyela maphɔɔ masɔ. Manya kɔphɔ ya ɓolɔsi eye itakye na nga. Kasi sakyela iizingyi nga, kyela nde izingyi wɛ.» ");
INSERT INTO loq_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Yesu amba ya butwa oli ɓaekosi ɓɛ̀ɛ ɓaato. Aesi yakyɛ ɓatakana ɓalasi ebuu. Amba ya wɔ na Petelo yokye: «Simo, kolale? Toikyi koka iɓa salala nɔnɔ ngonga yɔnɔyɔ? ");
INSERT INTO loq_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Kyɛngyɛ ombe na ɓɔndɛlɛ Ŋwaphongo phɔ ɓɛ̀ɛ sakaa o bimekyi ɓa Molemba. Phɔ na ɓo molimo ŋwa moto moli na phowa iikye ya ikyela ɓolaa, kasi nzoto yɛ ili na ɓokɔɔ.» ");
INSERT INTO loq_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ɓoɓɛlɛ Yesu akuli ya ɓaika, akyɛ ɓɔndɛlɛ nde ɓowaɓɔndɛlɛkyɛ yo phanza. ");
INSERT INTO loq_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Akuli ya butwa wali ɓaekosi ɓɛɛ, akuli ya ɓatakana ɓalasi ebuu. Phɔ ya miyo ɓozito, teɓakulaka eɓa na lowɔ la imobuyisa. ");
INSERT INTO loq_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Waabutwa Yesu mbala eya iyato, amba ya wɔ na ɓɛ́ɛ yokye: «Ɓɛ̀ɛ ominangye, olasi, waumbo! Imbɛlɛ mɛ sikokyi. Uŋwaŋwa eye, nga Ŋwana wa Moto ɓamunzungya o maɓɔkɔ ma ɓato ɓa masumu. ");
INSERT INTO loq_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Tɛmɛ tokyɛndɛ! Kyeka moto ookonzungya aesi!» ");
INSERT INTO loq_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Waaɓa Yesu kataa wɔ, sakɔkɔ Yudasi, mɔnɔmɔ na ɓaekosi iko mbuka ɓaɓale aesi yakoma. Aesi na ɓato ɓaikye ɓaphisi mphata na nkpɔngu o maɓɔkɔ. Yaɓatomaka ɓakonzi ɓa ɓanganga ɓa Ŋwaphongo na ɓateye ɓa Miɓeko na ɓankumu. ");
INSERT INTO loq_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yudasi moto okoɓaungyisa Yesu aɓateyaka iyaa saamokyela yo. Awɔkɔ na ɓɛ́ɛ yokye: «Moto owamoyamba nga, mɛna yo! Omoakya, kyɛndɛ nɛ, omoɓanza na ɓolaa.» ");
INSERT INTO loq_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Waakoma ɓɛ, Yudasi amba ya susana phɛnɛphɛ na Yesu, amoɓangyi yokye: «Moteye!» Amba ya moyamba. ");
INSERT INTO loq_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ɓato ɓaaɓaka na Yudasi, ɓamba yaakya Yesu, ɓamokangyi. ");
INSERT INTO loq_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Mɔnɔmɔ na ɓaaɓaka na Yesu, amba ya gɓɔlɔ mumphata nwɛ, ateni itoo sa moto wa etoma wa nganga mokonzi wa Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesu amba ya wɔ na ɓɛ́ɛ yokye: «Iimba ya nzakya kombe yaa na mphata na ná nkpɔngu ndokolo nga nali nde mwibi! ");
INSERT INTO loq_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nkɔlɔ isɔ naɓe na ɓɛ̀ɛ o Tempelo, nateya, toika nzakya. Ka isɔ iye ikyelame phɔ ya ikokya maphɔɔ makomama o buku pha Ŋwaphongo.» ");
INSERT INTO loq_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Emba ɓaekosi ɓasɔ ɓamba molota. ");
INSERT INTO loq_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Munzenga mɔnɔmɔ miɓaɓaka ɓaɓengye Yesu, alataka imputa. Waaluka ɓɛ́ɛ imoakya, ");
INSERT INTO loq_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","aikyi ika sina imputa amba lota ɓolumbu. ");
INSERT INTO loq_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ɓamba yakyɛ na Yesu oka mokonzi ŋwa ɓanganga ɓa Ŋwaphongo. Omɔ, yaanganaka ɓakonzi ɓa ɓanganga ɓa Ŋwaphongo, ɓankumu na ɓateye ɓa Miɓeko. ");
INSERT INTO loq_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petelo aɓaka kaɓengye Yesu na itakye nɔnɔ waakyɛ nyɔlɔ yo o lophango la mokonzi ŋwa ɓanganga ɓa Ŋwaphongo. Omɔ, amba kyɛ zala elele yɔnɔyɔ na ɓasinzili, abuto iɔtɔ ŋwenya. ");
INSERT INTO loq_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ɓakonzi ɓa ɓanganga ɓa Ŋwaphongo na ɓananga ɓasɔ ɓa ikyita sinɛnɛ ɓalukaka eleko oka ɓato phɔ ya iingya Yesu, kasi teɓaika ezwa. ");
INSERT INTO loq_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Phɔ ɓato ɓaɓaka ɓamokatele maphɔɔ ma ɓɔlɛ, kasi bina biwɔlɛ ba ɓɛ́ɛ tebaikaka kokana. ");
INSERT INTO loq_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Emba ɓato ɓaayɔkɔ ɓaesi ya tɛmɛ, ɓamba mokatela ɓoɓo: ");
INSERT INTO loq_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«Tomookaka kawɔ yokye: “Nga namouwola Tempelo eyatongama na ɓato eye. O sima ya nkɔlɔ iyato, namotonga esuu eyamoɓa satongama na maɓɔkɔ ma ɓato.”» ");
INSERT INTO loq_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Kasi na ɓo na lowɔ lalona, biwɔlɛ ba ɓɛ́ɛ tebakulaka na kokana. ");
INSERT INTO loq_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Mokonzi ŋwa ɓanganga ɓa Ŋwaphongo amba tɛmɛ o ɓoo pha ɓato ɓasɔ, amba tuna Yesu yokye: «Iwɛ toobuya na iikyi ewɔlɛ ɓato ɓaɓa?» ");
INSERT INTO loq_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Kasi Yesu aikalaka nde ɓose, sabuya. Mokonzi ŋwa ɓanganga ɓa Ŋwaphongo amba kula motuna yokye: «Iwɛ Masiya, Ŋwana wa Okokumole ɓanga?» ");
INSERT INTO loq_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu amba ya mobuyisa yokye: «Eli nga. Ɓɛ̀ɛ ɓasɔ wamowɛnɛ Ŋwana wa Moto azasi o ɓoloo pha Ŋwaphongo owa mwiya, waamba na mowɛnɛ kaye onte ya mampata.» ");
INSERT INTO loq_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Emba mokonzi ŋwa ɓanganga ɓa Ŋwaphongo amba ya kakola bitobu ɓɛ̀ɛ balataka yo, amba ya wɔ yokye: «Tolokuli sengyela na manzoka! ");
INSERT INTO loq_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ɓɛ̀ɛ ɓasɔ omookyi ɓookotole yo Ŋwaphongo. Ɓɛ̀ɛ koumunya ɓo?» Ɓato ɓasɔ ɓamba ya nyɛtɛ Yesu ɓɛkye akokyi na iwaa. ");
INSERT INTO loq_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ɓayɔkɔ onte ya ɓɛ́ɛ ɓabuto imotowa matee, ɓamozibi ɓoo, ɓamowande mankutu ɓamba wɔ nɛ ɓɛkye: «Imola, oewandi nza?» Ɓoɓɛlɛ, ɓasinzili ɓamba ya mokpa ɓabuto imowanda bingyete. ");
INSERT INTO loq_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Waaɓa Petelo o iɓanda sa lophango la mokonzi ŋwa ɓanganga ɓa Ŋwaphongo, ŋwaŋwasi mɔnɔmɔ, mɔnɔmɔ na ɓaa etoma ɓɛ́ɛ amba yaa wamɔ. ");
INSERT INTO loq_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Aesi ya wɛnɛ Petelo kaɔtɔ ŋwenya, amba ya molembetela, amba ya wɔ nɛ yokye: «Na wɛ waɓaka na Yesu moto wa Nazalɛtɛ!» ");
INSERT INTO loq_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Kasi Petelo aesi yaangana yokye: «Sieɓe ikyilukye wɛ iwɔ! Siisɔsɔlɔ ikyi wɔ wɛ.» Ɓoɓɛlɛ aesi ya mana wamɔ, aesi ya kyɛ zala o nze o munɔkɔ ŋwa lophango. Ɓoɓɛlɛ soo eesi ya tɔngɔ. ");
INSERT INTO loq_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Kasi ŋwaŋwasi mɛ akuli yakyɛ mowɛnɛ, amba ya imola ɓaɓaka wamɔ yokye: «Moto oyo ali mɔnɔmɔ na ɓato ɓaaɓana!» ");
INSERT INTO loq_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Petelo akuli angana mbala esuu yokye: «Phe, teli ɓɔmɔ!» Ŋwana ɓonte, ɓaaɓaka wa mɔ ɓakuli ya wɔ na Petelo ɓɛkye: «Nde phɛlɛ, oli mɔnɔmɔ na ɓɛ, phɔ na wɛ oli moto wa Galileya.» ");
INSERT INTO loq_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Emba Petelo amba butwa ikata seleka yokye: «O nkombo ya Ŋwaphongo, sieɓe moto okowɔ ɓɛ̀ɛ mɔna, ɓo nakate, Ŋwaphongo ampɛ etumbu!» ");
INSERT INTO loq_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Nde o sina imbɛlɛ mɛ, soo ekuli ya tɔngɔ mbala eya iɓale. Emba Petelo amba ya umunya maphɔɔ maawɔkɔ Yesu nɛ oɓokye: «Soo sa ɓotɔngɔkye mbala iɓale, wamunzangana mbala iyato oɓokye iwɛ tonzeɓe.» Emba Petelo amba ya tɔkɔlɔ abuto ikyɛmilela. ");
INSERT INTO loq_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Na moyɛlɔ, ɓakonzi ɓa ɓanganga ɓa Ŋwaphongo ɓaesi yaangana ikyita na ɓankumu na ɓateye ɓa Miɓeko. Ɓaesi ya kanga Yesu maphanga, ɓakyɛ moika oka Pilata. ");
INSERT INTO loq_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilata amba ya tuna Yesu yokye: «Iwɛ oli mokonzi ŋwa Ɓayuda?» Yesu amba mobuyisa yokye: «Mɛna ewɔ nde wɛ.» ");
INSERT INTO loq_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ɓakonzi ɓa ɓanganga ɓa Ŋwaphongo ɓamba ya phunda Yesu na maphɔɔ maikye. ");
INSERT INTO loq_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ɓoɓɛlɛ Pilata amba kula motuna yokye: «Iwɛ toobuya? Ka kookye maphɔɔ maikye maephunde na ɓɛ!» ");
INSERT INTO loq_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Kasi Yesu taika buya na lowɔɔ. Yango mɛna Pilata amba kamwa na ɓoikye. ");
INSERT INTO loq_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","O bisɛlɛkɔ bisɔ ba eyenga ya Ilekana, Pilata kakandole moto wa bɔlɔkɔ mɔnɔmɔ okoongye ɓato. ");
INSERT INTO loq_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Nzuka o bɔlɔkɔ, yaɓaka moto mɔnɔmɔ nkombo yɛ Ɓalaɓa. Aɓaka o mɔ yo na ɓato ɓasuu ɓaaɓomaka moto waatɔmbɔlɛlɛkyɛ ɓɛ́ɛ Ɓaloma. ");
INSERT INTO loq_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ɓato ɓaikye ɓamba ya kyɛndɛ oka Pilata, ɓakyɛ moonga oɓokye aɓakyelele ɓo wamɛɛlɛ yo iɓakyelela. ");
INSERT INTO loq_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilata amba ya ɓabuyisa yokye: «Ozingyi oɓokye naekandolele mokonzi ŋwa Ɓayuda?» ");
INSERT INTO loq_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Phɔ Pilata aeɓaka na ɓolaa oɓokye ɓakonzi ɓa ɓanganga ɓa Ŋwaphongo ɓayakaka yamophɛ Yesu nde phɔ ya zuwa. ");
INSERT INTO loq_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Kasi ɓakonzi ɓa ɓanganga ɓa Ŋwaphongo ɓaindisaka ɓato oɓokye ɓawɔ nde oɓokye ɓaɓakandolele nde Ɓalaɓa. ");
INSERT INTO loq_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilata amba kula ɓatuna yokye: «Ka nakyele ɓo na okoɓangye ɓɛ́ɛ mokonzi ŋwa Ɓayuda?» ");
INSERT INTO loq_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ɓɛ́ɛ ɓamba ya aŋwana ɓɛkye: «Omoɓakye o ekulusu!» ");
INSERT INTO loq_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilata amba kula ya ɓatuna yokye: «Akyesi lowɔɔ loɓe ye?» Kasi ɓamba kula nde aŋwana na ɓokusi ɓɛkye: «Omoɓakye o ekulusu!» ");
INSERT INTO loq_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Phɔ ya isepelisa ɓato, Pilata amba ya ɓakandolela Ɓalaɓa. Amba toma ɓatuluku ɓabinde Yesu phimbo. Waa unva ɓɛ́ɛ imobinda phimbo, amba mophɛ ɓɛ́ɛ oɓokye ɓakyɛ moɓaka o ekulusu. ");
INSERT INTO loq_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ɓatuluku ɓaesi yakyɛndɛ na Yesu onte ya lophango la mokonzi Pilata, ɓaesi ya ɓangana ɓɛ́ɛ ɓasɔ. ");
INSERT INTO loq_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Phɔ ya imoɛkyɛ, ɓaesi ya molasa munkoto ŋwa mangola, ɓaesi ya tonga na eɓoko ya milɔ, ɓamba ya molasa yango o moto. ");
INSERT INTO loq_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ɓabuto imoɓeya ɓɛkye: «Ena wɛ e mokonzi ŋwa Ɓayuda!» ");
INSERT INTO loq_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ɓabuto imobinda na munziye o moto, ɓamotowi matee, ɓakusami na maɓɔngɔ o ɓoo phɛ ndokolo ɓamokumbele. ");
INSERT INTO loq_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Waaunva ɓɛ́ɛ imoɛkyɛ, ɓamba ya mumanya munkoto ŋwa mangola, ɓamba kula ya molasa bitobu ɓɛ. Sima, ɓamba tɔkɔlɔ nɛ o iɓanda phɔ ya ikyɛ moɓaka o ekulusu. ");
INSERT INTO loq_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Moto mɔnɔmɔ wa Sirɛnɛ nkombo yɛ Simo, ango wa Alegizandele na Luphusu, autaka o manzabi, amba ya lekana wamɔ. Ɓatuluku ɓamba ya moengyisa oɓokye anyanya ekulusu ya Yesu. ");
INSERT INTO loq_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ɓaesi yakyɛ na Yesu o elele ekyeɓangye ɓɛ́ɛ Gologota, kyelukye iwɔ oɓɔkye «Elele ya Engyɛngyɛlɛ.» ");
INSERT INTO loq_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ɓamba ya mophɛ malɛku ɓa maangyinya na munɔ moɓangye ɓɛ́ɛ milɛ; kasi Yesu taikaka manywa. ");
INSERT INTO loq_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ɓoɓɛlɛ ɓatuluku ɓamba ya moɓaka o ekulusu. Ɓamba ya maa mbɛsɛ phɔ ya ikaɓa bitobu ɓa Yesu. ");
INSERT INTO loq_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Yaɓaka ngonga ya ibuwa eya mumbengu waamoɓaka ɓɛ́ɛ o ekulusu. ");
INSERT INTO loq_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","O ŋwana iɓaya owackomaka ɓɛ́ɛ ewelele yɛ, ɓakomaka oɓokye: «Mokonzi ŋwa Ɓayuda.» ");
INSERT INTO loq_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ɓatuluku ɓaesi ya ɓaka na ɓaibi ɓaɓale o ekulusu phɛnɛphɛ na Yesu: Ona o ɓoloo, o moyɔkɔ o ɓowɛɛ phɛ.  ");
INSERT INTO loq_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Yango mɛna wakokyisami ɓo wakoma ɓɛ́ɛ o buku pha Ŋwaphongo oɓokye: «Ɓamoangyinye o moɓɔmbɔ ŋwa ɓaibi.» ");
INSERT INTO loq_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ɓato ɓaaɓaka ɓalekane wamɔ ɓabuto imotola, ɓanyingye nzoto ɓɛkye: «Ee! Iwɛ owa wɔkɔ oɓokye wamobukola Tempelo, wamoetonga na nkɔlɔ iyato! ");
INSERT INTO loq_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ka omibikya, uta o ekulusu!» ");
INSERT INTO loq_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Nde ɓomɔ na ɓakonzi ɓa ɓanganga ɓa Ŋwaphongo na ɓateye ɓa Miɓeko ɓaɛkyɛkyɛ Yesu. Ɓawɔɔnɔkɔ onte ya ɓɛ́ɛ ɓɛkye: «Abikyaka ɓato ɓasuu kasi yo mampenza taakokye imibikya! ");
INSERT INTO loq_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ɓo ali Masiya, Mokonzi ŋwa Isalayɛlɛ, aute uŋwaŋwa eye o ekulusu phɔ towɛnɛ, tombe anola!» Na ɓaibi ɓaɓale ɓaɓakaka ɓɛ́ɛ o ekulusu phɛnɛphɛ na Yesu ɓamotolaka nde mɛ. ");
INSERT INTO loq_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Waakoma bunya imoto, enzɔmbi esi ya ziɓa mokyisi musɔ tee nɔnɔ wa ngonga eya iyato eya nkɔkɔlɔ. ");
INSERT INTO loq_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Waakoma ngonga ya iyato, Yesu aesi ya aŋwana na ɓokusi yokye: «Eloi, Eloi lama saɓakatani?» Kyelukye iwɔ oɓokye: «Ŋwaphongo wa nga, Ŋwaphongo wa nga phɔ ya'ye ondɛ?» ");
INSERT INTO loq_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ɓato ɓasuu ɓaaɓaka wamɔ ɓamookyi, ɓamba ya wɔ ɓɛkye: «Okyemela, kaɓangye moimosi Eliya!» ");
INSERT INTO loq_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Mɔnɔmɔ na ɓaaɓaka wamɔ amba ya kyilingana, akyɛ nyinya inyuka o malɛku ma ngaa, asikangyi o sɔngyɛ ya mungɓalango, aesi ya phɛ Yesu phɔ anywe. Amba ya wɔ yokye: «Ziya tokyekye ɓo Eliya aesi ya mouya o ekulusu!» ");
INSERT INTO loq_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Kasi Yesu amba ya aŋwana ŋwangye mokusi nɔnɔ waakata yo motema. ");
INSERT INTO loq_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Etobu enɛnɛ eyalɛngyɛkyɛ ɓɛ́ɛ o Tempelo yakakwaka na miɓale, uta o ikolo nɔnɔ o se. ");
INSERT INTO loq_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Mokonzi ŋwa ɓatuluku owa tɛmɛkyɛ o ɓoo pha Yesu awɛnɛkyɛ ɓoowe yo, yokye: «Nde phɛlɛ, moto oyo aɓakyi Ŋwana wa Ŋwaphongo.» ");
INSERT INTO loq_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ɓaɓasi ɓasuu ɓaaɓaka na ɓɛ́ɛ wamɔ, ɓaɓaka ɓakyekye na itakye. Onte ya ɓɛ́ɛ yaɓaka Maliya owa Magadala, na ndo yɛ Maliya, nyango wa Zake eya munzenga na Zoze na Salome. ");
INSERT INTO loq_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ɓaɓasi ɓaaɓana, ɓaɓaka ɓaɓengye Yesu, ɓaɓaka ɓamokyelele waaɓa yo o manyɛtɛ ma Galileya. Yaɓaka na ɓaɓasi ɓasuu ɓaikye omɔ, ɓaatambulaka na Yesu nzela yɔnɔyɔ o Yelusalɛmɛ. ");
INSERT INTO loq_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Waakomaka nkɔkɔlɔ, imbɛlɛ siilɛngyɛlɛ ɓɛ́ɛ mokɔlɔ ŋwa Saɓata. ");
INSERT INTO loq_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Zozefu wa Alimataya amba yaa. Aɓaka moto wa ngambo onte ya ɓananga ɓaanɛnɛ ɓa Ɓayuda, nɛ aɓaka kaziya iyaa sa ɓokonzi pha Ŋwaphongo. Amba yakyɛ na ɓoititalakye ɓosɔ oka Pilata ikyɛ onga eɓembe ya Yesu. ");
INSERT INTO loq_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilata amba ya kamwa na iyoka oɓokye Yesu aambo waa. Aesi ya ɓanga mokonzi ŋwa ɓatuluku owa ɓaka wamɔ phɔ ya imotuna ɓo Yesu ambo waa elinga. ");
INSERT INTO loq_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Waamoimola mokonzi ŋwa ɓatuluku oɓokye Yesu ambo waa, Pilata amba ya phɛ Zozefu nzela ya ikyɛ kpa eɓembe ya Yesu. ");
INSERT INTO loq_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Zozefu aesi ya omba imputa siilaa, aesi ya uya eɓembe ya Yesu o ekulusu, aezingyi na ena etobu, amba kyɛ enyɔsa o ilita saa imaka ɓɛ́ɛ o maɓanga. Sima, amba uka iɓanga siinɛnɛ phɔ ya iziɓa munɔkɔ ŋwa mɔɔtɔ. ");
INSERT INTO loq_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maliya ma Magadala na ndo yɛ Maliya, nyango wa Zoze, ɓaɓaka ɓakyekye elele ekye kunde ɓɛ́ɛ Yesu. ");
INSERT INTO loq_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Uŋwaŋwa eye mokɔlɔ ŋwa Saɓata moesi ya unva. Maliya ma Magadala, na ndo yɛ nyango wa Zake na Salome ɓaesi yakyɛ omba mauta ma solo elaa oɓokye ɓakyɛ maɔlɔlɔ eɓembe ya Yesu. ");
INSERT INTO loq_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Waamumbengu ŋwa mokɔlɔ ŋwa sima ya Saɓata, waatɔkɔlɔ munyɛlɛ, ɓaesi yakyɛ o mɔɔtɔ. ");
INSERT INTO loq_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ɓawɔnɔkɔ ɓɛkye: «Moto owalomanyisa iɓanga o munɔkɔ ŋwa mɔɔtɔ nza?» ");
INSERT INTO loq_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Waavaka ɓɛ́ɛ miyo omɔ, ɓaesi ya wɛnɛ oɓokye ɓambo manya iɓanga mɛ imbale. Iɓanga mɛ saɓaka sinɛnɛ. ");
INSERT INTO loq_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ɓamba ya nyɔlɔ o mɔɔtɔ. Ɓaesi ya wɛnɛ munzenga mɔnɔmɔ omɔ azasi bi ɓoloo o mɔtɔ, alati etobu eetane. Ɓaɓasi mɛ ɓawɛnɛkyɛ inganga siikye. ");
INSERT INTO loq_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Kasi aesi ya wɔ na ɓɛ́ɛ yokye: «Ɓɛ̀ɛ sa ila. Naeɓe oɓokye ɓɛ̀ɛ kolukye Yesu wa Nazalɛtɛ, owaɓakaka ɓɛ́ɛ o ekulusu. Aambo kundwa. Wawa tali! Kyeka elele eya molangyaka ɓɛ. ");
INSERT INTO loq_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Emba ɓɛ̀ɛ ɓasɔ kyɛndɛ, kyɛ lɔngɔlɔ Petelo na ɓaekosi ɓaayɔkɔ oɓokye Yesu akyɛ ɓaziya o Galileya. Ɓɛ́ɛ ɓamokyɛ mowɛnɛ omɔ, ɓoo ɓalɔngɔsi yo.» ");
INSERT INTO loq_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ɓaɓasi mɛ ɓaesi ya tɔkɔlɔ, ɓamani o mɔɔtɔ, ɓakyilinga mambangu, phɔ ya sina inganga, ɓatɛkyɛnɛlɛkyɛ phɔ malondo maunvaka na ɓɛ. Teɓaikaka imola nɔnɔ moto mɔnɔmɔ, phɔ ɓailaka.  ");
INSERT INTO loq_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Waakundwa Yesu na moyɛlɔ ŋwa sima ya mokɔlɔ ŋwaa Saɓata, atataka itɔkɔlɛlɛ Maliya ma Magadala, owamanyaka yo malɔɓɔ maɓe sambo. ");
INSERT INTO loq_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Maliya amba kyɛ imola simo mɛ oka ɓaekosi ɓa Yesu. Akyɛ ɓazwa ɓalele na ngɔngɔ. ");
INSERT INTO loq_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Kasi waaoka ɓɛ́ɛ oɓokye Yesu ali na ɓɔmɔɔ, Maliya amowɛni, teɓaikaka anola. ");
INSERT INTO loq_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Sima Yesu akulaka tɔkɔlɛlɛ ɓaekosi ɓaɓale o nzela ekyɛkyɛ ɓɛ́ɛ o manzabi. Amibuyaka ndengye esuu. ");
INSERT INTO loq_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ɓaekosi mɛ ɓamba ya ɓomela, ɓakyɛ imola ɓɛbi na ɓɛ́ɛ ɓo wawɛnɛnɛkyɛ ɓɛ́ɛ na Yesu. Kasi ɓɛ́ɛ teɓaikaka na anola. ");
INSERT INTO loq_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Sima ya isɔ, Yesu akulaka tɔkɔlɛlɛ ɓaekosi iko mbuka mɔnɔmɔ, ɓaaɓaka ɓaze. Amba ya ɓaoya yokye: «Ɓɛɛ toli na ianola, kombe ikyela na ziko ɓaayakaka ya eimola oɓokye ɓanvɛni na miyo oɓokye nali na ɓomɔɔ.» ");
INSERT INTO loq_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Emba amba ya ɓatoma, yokye: «Ɓɛɛ ɓasɔ, kyɛndɛ o mokyisi munsɔ, okyɛmimola ɓato ɓasɔ Simo Elaa. ");
INSERT INTO loq_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ɓo moto aanosi Simo Elaa mɛ, ɓo aɓatisami, amobika. Ka ɓo moto taanosi Simo Elaa, amosambisama. ");
INSERT INTO loq_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ɓaanosi mɛ ɓamokyela bilekyesako bibi: Ɓamowiinya malɔɓɔ maɓe na nkombo ya nga, ɓamowɔɔ nɔkɔ insuu itieɓe ɓato; ");
INSERT INTO loq_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ɓo ɓaakye manzɔɔ, na ɓo ɓanywe zwe siɓome, eteɓaokye ɓolɔsi, eteɓawe; ɓamotandela ɓato ɓa malɔsi maɓɔkɔ, ɓato mɛ ɓamobika.» ");
INSERT INTO loq_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Waaunva Nkolo Yesu iwɔ na ɓɛ́ɛ ɓoɓo, abuto o ikolo. Akyɛ zala o elele ya ngambo o ɓoloo pha Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ɓoɓɛlɛ, ɓaekosi ɓaesi ya kyɛmimola Simo Elaa mɛ mboka esɔ. Nkolo aɓaka kaɓasungye o etoma ya ɓɛ, akyelaka bilekyesako biikye o nzela ya ɓɛ́ɛ phɔ ya iphɛ maloɓa ma ɓɛ́ɛ mwiya.");
INSERT INTO loq_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Owa lozingo Teofile, Ɓato ɓaikye ɓameka ikoma na molɔngɔ simo ya maphɔɔ maalekana o nte ya ɓanga, ");
INSERT INTO loq_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ɓo waloumola ɓaawɛnɛkyɛ maphɔɔ mɛ na miyo uta o etatele, ɓaabuto lɔlɔ eye ɓato ɓa etoma ya ikyɛmimola Simo ya Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Yango mɛna, na nga mɛ, o sima ya ioka maphɔɔ masɔ mawɛnɛkyɛ ɓɛ́ɛ na miyo mamana na ɓolaa tata o etatele, nasepesi iyekomela simo mɛ na molɔngɔ, nwɛbi na nga owa ngambo Teofile. ");
INSERT INTO loq_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Nakyele ɓaɓona phɔ oeɓe oɓokye mateya maeteyaka ɓɛ́ɛ mali maa phɛlɛ. ");
INSERT INTO loq_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Waaɓa Elode mokonzi ŋwa manyɛtɛ ma Yuda, yaɓaka nganga mɔnɔmɔ wa Ŋwaphongo, nkombo yɛ Zakaliya aɓaka o iɓota sa ɓanganga ɓa Ŋwaphongo sa Abiya. Ŋwasi wɛ Elizaɓɛti aɓaka nɛ o ɓosoo pha nganga mokonzi Alona. ");
INSERT INTO loq_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ɓɛ́ɛ ɓasɔ ɓaɓale ɓaɓaka ɓato ɓalaa o miyo ma Ŋwaphongo, ɓaɓaka ɓakumole na ɓolaa miɓeko misɔ ma Nkolo. ");
INSERT INTO loq_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Kasi teɓaikaka ɓaa na ŋwana phɔ Elizaɓɛti taikaka ɓaa kaɓote, na ɓɛ́ɛ ɓasɔ ɓaɓale ɓakotwaka. ");
INSERT INTO loq_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Mokɔlɔ mɔnɔmɔ, yaɓaka ngala ya ɓanganga ɓa iɓota sa Abiya ya ikyela etoma, Zakaliya aɓaka kakyele etoma yɛ ya ɓonganga o ɓoo pha Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ikokana na moɓeko ŋwa ɓonganga, mbɛsɛ ya kaaka mi yo oɓokye anyɔlɔ o elele elekyi ɓosantu ya Nkolo phɔ ya ikyɛ tumba mpaka ya malasi. ");
INSERT INTO loq_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Moluku ŋwa ɓato ɓasɔ ɓaɓaka ɓaɓɔndɛlɛ o nze imbɛlɛ siitumbe ɓɛ́ɛ mpaka ya malasi. ");
INSERT INTO loq_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ɓoɓɛlɛ anzelu mɔnɔmɔ wa Nkolo amba ya motɔkɔlɛlɛ, anzelu mɛ aesi ya tɛmɛ o ɓoloo pha elele ekyetumbele ɓɛ́ɛ Ŋwaphongo mpaka ya malasi. ");
INSERT INTO loq_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Waawɛnɛ Zakaliya anzelu mɛ, malondo maesi ya unva nɛ, abuto iwɛnɛ ɓɔɔɓɔ. ");
INSERT INTO loq_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Kasi anzelu amba ya wɔ nɛ yokye: «Zakaliya, saila, phɔ Ŋwaphongo aokyi iɓɔndɛsi sa wɛ. Ŋwasi wa wɛ Elizabɛti amoeɓotela ŋwana wa lele, waamolaa nkombo Yoane. ");
INSERT INTO loq_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Wamoɓa na nkyisa nzikye, na ɓato ɓaikye ɓamoɓa na nkyisa phɔ ya iɓotama sɛ. ");
INSERT INTO loq_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Phɔ amoɓa moto munɛnɛ o ɓoo pha Nkolo. Etaanywe na malɛku naa ekpele esɔ eekyelangya. Amotonda na Ɓolɔɓɔ Ɓosantu tata o ibuu sa nyango. ");
INSERT INTO loq_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Amobuya ɓana ɓaikye ɓa Isalayɛlɛ oka Nkolo Ŋwaphongo wa ɓɛ. ");
INSERT INTO loq_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Amoya o ɓoo pha Ŋwaphongo, na ɓolɔɓɔ na ná mwiya ndokolo moimosi Eliya, phɔ ya iɓɔngya ɓa ango na ɓana ɓa ɓɛ, na ibuya ɓato ɓaa nzoto nkusi ɓato ɓa malondo malaa, phɔ aɓaɓɔngya phɔ ya iyamba Nkolo.» ");
INSERT INTO loq_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakaliya amba ya tuna anzelu yokye: «Namoeɓa na ye oɓokye lowɔ mɛ loli phɛlɛ? Phɔ nga na ŋwasi wa nga tokotoo.» ");
INSERT INTO loq_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Emba anzelu amba ya mobuyisa yokye: «Nga nali Gabiliyɛlɛ, ookotɛmɛ o ɓoo pha Ŋwaphongo. Antomi phɔ ya iyewɔlɛ na iyeyimola simo elaa. ");
INSERT INTO loq_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Maphɔɔ maeyimosi nga mamokyelama imbɛlɛ saameka Ŋwaphongo. Kasi otoikyi wɛ anola, wamobutwa mbubu, ootokule wɔ tata lɔlɔ nɔnɔ mokɔlɔ mɛ.» ");
INSERT INTO loq_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Imbɛlɛ mɛ, ɓato ɓaɓaka ɓaziya Zakaliya o nze ɓakamwaka phɔ akɔkɔkɔ na ɓoikye o motema ŋwa elele eelekyi ɓosantu. ");
INSERT INTO loq_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Watɔkɔlɔ yo, takokaka ikula ɓawɔlɛ, abuto iɓawɔlɛ nde na bikyela phɔ abutwaka mbubu. Emba ɓato ɓasɔ ɓamba eɓa oɓokye awɛni lowɔɔ onte ya elele eelekyi ɓosantu. ");
INSERT INTO loq_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Waaunva Zakaliya nkɔlɔ yɛ ya etoma o ingambi siinɛnɛ sa Ŋwaphongo, abutoo oka yɛ. ");
INSERT INTO loq_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Sima ya ŋwana imbɛlɛ, Elizabɛti ŋwasi wɛ aekami. Akyɛkyɛ miɓomba makombe matano, amiwɔlɛkyɛ yokye: ");
INSERT INTO loq_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«Kyeka lowɔ lokyesi Nkolo phɔ nga, phɔ amanyee sɔɔ o miyo ma ɓato.» ");
INSERT INTO loq_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Waakoma ibuu sa Elizaɓɛti na makombe motoɓa, Ŋwaphongo aesi ya toma anzelu Gabilɛyɛlɛ o mokyisi mɔnɔmɔ muunɛnɛ ŋwa Galileya, nkombo ya ŋwango Nazalɛtɛ, ");
INSERT INTO loq_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","oka ngɔndɔ mɔnɔmɔ owamozala ɓolonga na lele mɔnɔmɔ nkombo yɛ Zozefu, moto wa iɓota sa mokonzi Davidi. Nkombo ya ŋwana ngɔndɔ mɛ Maliya. ");
INSERT INTO loq_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Mwanze amba ya nyɔlɔ oka Maliya amba ya wɔ nɛ yokye: «Kumba! Nkolo Ŋwaphongo aeteye ɓolaa phɛ.» ");
INSERT INTO loq_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Waaoka Maliya maphɔɔ maamana, malondo makyimaka nɛ, amba mituna ntina ya ikumba mɛ. ");
INSERT INTO loq_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Emba anzelu amba ya wɔ nɛ yokye: «Saila, Maliya, phɔ ozwe ngɔlu o miyo ma Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Wamoekama, wamoɓota ŋwana wa lele, waamolaa nkombo Yesu. ");
INSERT INTO loq_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Amoɓa moto munɛnɛ, ɓaamoɓanga Ŋwana wa Owa Ikolo. Nkolo Ŋwaphongo aamophɛ eziye ya ɓokonzi pha nkɔkɔ yɛ Davidi. ");
INSERT INTO loq_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Amoɓa mokonzi phɔ ya ɓoɓɛlɛ o ingambi sa Yakoɓo, ɓokonzi phɛ eteɓooɓe na suka.» ");
INSERT INTO loq_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maliya amba ya wɔ na anzelu yokye: «Lowɔ mɛ lamokyelama ndengye'ye phɔ nga naino sianga na lele?» ");
INSERT INTO loq_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Mwanze amba ya mobuyisa yokye: «Ɓolɔɓɔ Ɓosantu pha moeyutela, na mwiya ŋwa Owa Ikolo ŋwa moeziɓa na ɔɔmɛlɛ yɛ, yango mɛna ŋwana owamoɓota wɛ amoɓa mosantu, ɓamoɓanga Ŋwana wa Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Kyeka na ŋwana nyɔngɔ Elizabɛti nɛ aekama, amoɓota ŋwana wa lele na ɓokoto phɛ. Yo owa wɔkɔ ɓɛ́ɛ oɓokye taɓote, ali lɔlɔ na ibuu sa makombe motoɓa, ");
INSERT INTO loq_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","phɔ lowɔɔ loolekye Ŋwaphongo teloli.» ");
INSERT INTO loq_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Emba Maliya amba ya wɔ yokye: «Nali ŋwaŋwasi wa etoma wa Nkolo. Masɔ makyelame mi nga ɓo wɔ wɛ!» Nɔnɔ wa moika anzelu. ");
INSERT INTO loq_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Nde o sina imbɛlɛ mɛ, Maliya amba ya kyɛ izele o mokyisi mɔnɔmɔ mbale eya mangomba o manyɛtɛ ma Yuda. ");
INSERT INTO loq_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Aesi ya kyɛ nyɔlɔ o ingambi sa Zakaliya, aesi ya ɓeya Elizabɛti. ");
INSERT INTO loq_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Wa oka Elizaɓɛti iɓeya sa Maliya, ŋwana ooli o ibuu sɛ anyinganaka, emba Elizaɓɛti amba tonda na Ɓolɔɓɔ Ɓosantu. ");
INSERT INTO loq_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Amba ya wɔ na ŋwɛsi mokusi yokye: «Opambolami ileka ɓaɓasi ɓasɔ, na ŋwana ooli o ibuu sa wɛ apambolami mɛ! ");
INSERT INTO loq_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ndengye'ye nyango wa nkolo ŋwa nga aya nkyeka? ");
INSERT INTO loq_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Phɔ ookyi nga iɓeya sa wɛ, kyeka ŋwana anyinga na nkyisa o ibuu sa nga. ");
INSERT INTO loq_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nkyisa ili na owaanosi: Imowɔlɛsi ɓɛ́ɛ phɔ ya Nkolo yamokyelama!» ");
INSERT INTO loq_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Emba Maliya yokye: «Nakumole Nkolo na ndondo ya nga esɔ; ");
INSERT INTO loq_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","na molimo ŋwa nga motondi na nkyisa phɔ ya Ŋwaphongo mobikye wa nga, ");
INSERT INTO loq_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","phɔ akyekyi moombo wɛ ootoli na ngambo. Phɛlɛ tata lɔlɔ, ɓato ɓasɔ ɓamumbanga moto wa esɛngɔ, ");
INSERT INTO loq_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","phɔ Ekambambasi ankyelesi maphɔɔ manɛnɛ: Nkombo yɛ eɓe esantu. ");
INSERT INTO loq_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ɓolaa phɛ kaɓokyele oka ɓato ɓasɔ ɓamoile o ɓayoo ɓasɔ. ");
INSERT INTO loq_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Akyesi misala ma ikamwa na mwiya ŋwa eɓɔkɔ yɛ, anyangosi ɓato ɓaalolɛndɔ; ");
INSERT INTO loq_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","amanye ɓakonzi ɓaakusi o biziye ɓa ɓokonzi ɓa ɓɛ, atombi ɓato ɓateɓali na ngambo; ");
INSERT INTO loq_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ɓaawe na nzala aɓatonze na ntoma, na ɓaa ezwele, aɓabuye maɓɔkɔ pha. ");
INSERT INTO loq_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Asungyi ɓato ɓa Isalayɛlɛ, ɓato ɓa etoma ɓɛ, na ɓoumunyakye ɓolaa phɛ. ");
INSERT INTO loq_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Eli ɓo walakyelaka yo ɓankɔkɔ ɓa ɓanga, Abalayama na ɓana ɓɛ́ɛ phɔ ya ɓoɓɛlɛ.» ");
INSERT INTO loq_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maliya amba ikala na Elizaɓɛti phɛnɛphɛ na makombe maato, ɓoɓɛlɛ amba ya butwa oka ɓɛ. ");
INSERT INTO loq_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Waakoka mokɔlɔ ŋwa Elizaɓɛti ŋwa iɓota, aesi ya ɓota ŋwana wa lele. ");
INSERT INTO loq_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ɓabuɓaa nɛ na iɓota sɛɓaokyi ndengye eya mokyelela Nkolo ɓolaa, ɓɛ́ɛ ɓasɔ ɓamba kumba nɛ. ");
INSERT INTO loq_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Waakokya ŋwana nkɔlɔ ŋwambi, ɓakyɛ moɓɛlɛ. Ɓalukaka imolaa nkombo ya ango, Zakaliya. ");
INSERT INTO loq_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Emba nyango amba ya wɔ yokye: «Phe! Nkombo yɛ yamoɓa Yoane.» ");
INSERT INTO loq_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ɓamba mobuyisa ɓɛkye: «Moto na mɔnɔmɔ o iɓota sa wɛ tali na nkombo mɛna!» ");
INSERT INTO loq_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ɓamba tuna ango wa ŋwana na ɓilembo phɔ ya iyeɓa nkombo'ye ekokyi yo ilaa ŋwana. ");
INSERT INTO loq_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zakaliya amba ya onga ŋwana iɓaya wa ikoma, amba koma ɓoɓo: «Nkombo yɛ Yoane.» Emba ɓato ɓasɔ ɓamba kaŋwa. ");
INSERT INTO loq_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Mina wamɔ munɔkɔ na lole lɛ loingo, abuto iwɔɔ, abuto ikumbela Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Emba ɓabuɓaa nɛ ɓabuto ilaa. Na o mangomba masɔ ma manyɛtɛ ma Yuda ɓaɓaka ɓawɔ nde maphɔɔ mɛ. ");
INSERT INTO loq_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ɓato ɓasɔ ɓaa okaka maphɔɔ mɛ ɓamaɓanzaka o mandondo ma ɓɛ, ɓɛkye: «Ŋwana oyo amuna ɓa nza?» Phɔ nde phɛlɛ mwiya ŋwa Nkolo ŋwaɓaka nɛ. ");
INSERT INTO loq_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ɓoɓɛlɛ Zakaliya, ango wa ŋwana, atondaka na Ɓolɔɓɔ Ɓosantu, amba tata isakola ɓoɓo: ");
INSERT INTO loq_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Nkolo apambolame, Ŋwaphongo wa Isalayɛlɛ, phɔ aesi ya kyeka ɓato ɓɛ, aɓamanye o ɓoombo. ");
INSERT INTO loq_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Alotɔkɔlɛsi kamba Mobikye, o iɓota sa Davidi, moto wɛ wa etoma. ");
INSERT INTO loq_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Nde ɓo wawɔkɔ yo kalakala na nɔkɔ ya ɓaimosi ɓɛ́ɛ ɓasantu: ");
INSERT INTO loq_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ibikyi siilomanya o maɓɔkɔ ma ɓanguna ɓa ɓanga na o maɓɔkɔ ma ɓato ɓasɔ ɓaloine. ");
INSERT INTO loq_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Awɛninya ɓolaa phɛ oka ɓankɔkɔ ɓa ɓanga, aumunye sangola yɛ esantu. ");
INSERT INTO loq_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Phɔ Ŋwaphongo alakyelaka nkɔkɔ wa ɓanga Abalayama, ");
INSERT INTO loq_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","iloɓɔlɔlɔ o maɓɔkɔ ma ɓanguna phɔ tomokyelele saɓa na ɓoilakye, ");
INSERT INTO loq_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","onte ya ɓosantu na ɓosembo o miyo mɛ nkɔlɔ isɔ ya ɓomɔɔ pha ɓanga. ");
INSERT INTO loq_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ka wɛ, ŋwana oomokyɛɛ, wamoɓa moimosi wa Owa Ikolo, phɔ wamotambula o ɓoo pha Nkolo phɔ ya iɓɔngya manzela mɛ, ");
INSERT INTO loq_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","phɔ ya iteya ɓato ɓɛ́ɛ oɓokye kaye iya ɓabikya na ilimbisa masumu ma ɓɛ. ");
INSERT INTO loq_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Eli lowɔɔ la bɔlaa ɓoikye pha Ŋwaphongo wa ɓanga. Phɔ ya ɓolaa mɛ, moo motɔkɔsi o ikolo moesi ya lokyeka. ");
INSERT INTO loq_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Motɔkɔlɛsi ɓato ɓaali o enzɔmbi ya iwaa, phɔ ya ikamba matambe ma ɓanga o nzela ya ɓose.» ");
INSERT INTO loq_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ŋwana akolaka na nzoto, akutaka na o molimo. Aɓaka kaɓe o mabokye tee nɔnɔ waakokaka mokɔlɔ nwɛ ŋwa imiwɛninya oka ɓato ɓa Isalayɛlɛ. ");
INSERT INTO loq_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Imbɛlɛ mɛ, mokonzi Kaisala Ogisito ambyaka moɓeko ŋwa itanga ɓato ɓasɔ ɓa ekolo ya Loma. ");
INSERT INTO loq_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Itanga sa ɓato saa ntuɓo sasina sakyelamaka imbɛlɛ saɓaka Kilinus moangyesi wa Siri. ");
INSERT INTO loq_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ɓato ɓasɔ ɓakyɛkyɛ komisa mankombo, moto na moto o mokyisi nwɛ. ");
INSERT INTO loq_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Zozefu nɛ amba ya mana o Nazalɛtɛ o manyɛtɛ ma Galileya, amba ya kyɛ o Bɛtɛlɛmɛ omanyɛtɛ ma Yuda, waa ɓotaka ɓɛ́ɛ mokonzi Davidi. Phɔ yo Zozefu aɓaka moto wa ɓosoo Davidi. ");
INSERT INTO loq_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Akyɛndɛkyɛ komisa nkombo yo na ŋwasi wɛ Maliya, owaɓaka na ibuu. ");
INSERT INTO loq_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Nzuka imbɛlɛ saɓa ɓɛ́ɛ o Ɓɛtɛlɛmɛ, mokɔlɔ nwɛ ŋwa iɓota ŋwakokaka. ");
INSERT INTO loq_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Amba ya ɓota ŋwana wa lele, ŋwana wɛ awa oɓoo. Aesi ya mozinga na bitato, amba ya molangya o kyɛsi ekyelangyisa ɓɛ́ɛ manyama ntoma ya izaa, phɔ teɓaikaka zwa elele ya ilala o ingambi siilasa ɓɛ́ɛ ɓabutu. ");
INSERT INTO loq_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","O manyɛtɛ mɛ, ɓaɓanze ɓa mampate ɓaɓaka ɓalale o manzabi phɔ ya iɓatela mampate ma ɓɛ. ");
INSERT INTO loq_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Mwanze wa Nkolo mɔnɔmɔ amba ya ɓatɔkɔlɛlɛ, nkyɛmɔ ya Nkolo yamba ya ɓangyɛngyɛlɛ, emba ɓailaka na ɓoikye. ");
INSERT INTO loq_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Mwanze amba ya wɔ na ɓɛ́ɛ yokye: «Ɓɛ̀ɛ saila, phɔ naesi ya iemola simo elaa, eya mosepelisa ɓato ɓasɔ: ");
INSERT INTO loq_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","O mokɔlɔ ŋwa lɔlɔ eye, o mokyisi munɛnɛ ŋwa Davidi, ɓaeɓotesi Mobikye ooli Masiya, Nkolo. ");
INSERT INTO loq_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Kyeka bilembetele baamoeɓa na ɓɛ̀ɛ: Wamokyɛ wɛnɛ ŋwana oo mokyikyi ɓamozingyi na bitato, alangyi o kyɛsi ekyelangyisa ɓɛ́ɛ manyama ntoma ya izaa.» ");
INSERT INTO loq_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Mbala yɔnɔyɔ ɓanze ɓasuu ɓaikye ɓamba ya angana na anzelu owa ɓoo. Ɓaɓaka ɓakumbele Ŋwaphongo ɓoɓo: ");
INSERT INTO loq_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Lɛ nkyɛmɔ ya Ŋwaphongo iwɛnɛnɛ o ikolo, ɓose ɓoɓe wawa o se oka ɓato ɓaazingye yo!» ");
INSERT INTO loq_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Waabutwa ɓanze o ikolo, ɓaɓanze ɓa mampate ɓamba ya wɔɔnɔ onte ya ɓɛ, ɓɛkye: «Tokyɛndɛ tee nɔnɔ o Ɓɛtɛlɛmɛ, tokyɛ wɛnɛ lowɔ lokyelami omɔ, loloumosi Nkolo Ŋwaphongo.» ");
INSERT INTO loq_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ɓamba yakyɛ omɔ izele, ɓaesi ya kyɛ wɛnɛ Maliya na Zozefu na ŋwana o mokyikyi alangyi o kyɛsi ekyelangyisa ɓɛ́ɛ manyama ntoma ya izaa. ");
INSERT INTO loq_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Waamowɛnɛ ɓɛ, ɓamba imola isɔ ya ɓawɔlɛkyɛ ɓɛ́ɛ phɔ ya ŋwana. ");
INSERT INTO loq_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Emba ɓato ɓasɔ ɓaɓaokaka ɓakaŋwaka na maphɔɔ maaɓaka ɓaɓanze ɓa mampate ɓawɔ. ");
INSERT INTO loq_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Kasi Maliya aɓanzaka maphɔɔ masɔ mamana o ndondo yɛ ambaka ɓaa kamaumunya. ");
INSERT INTO loq_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ɓoɓɛlɛ ɓaɓanze ɓa mampate ɓamba ya butwa. Ɓakumbelaka ɓonɛnɛ pha Ŋwaphongo, ɓamokumisaka phɔ ya maphɔɔ masɔ maaokaka ɓɛ́ɛ na maawɛnɛkyɛ ɓɛ, phɔ masɔ malekanaka nde ɓowaɓaimolaka anzelu. ");
INSERT INTO loq_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Waakoka nkɔlɔ ŋwambi sima ya iɓotama sa ŋwana, imbɛlɛ sa imoɓɛlɛ sakokaka, ɓaamba ya molaa nkombo ya Yesu, nkombo eyawɔkɔ anzelu phanza nyango saɓoekamakye. ");
INSERT INTO loq_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ɓoɓɛlɛ, waakoka mokɔlɔ ŋwa ikyɛ manya sɔkɔtɔ ɓokowɔ moɓeko ŋwa Mose, Maliya na Zozefu ɓamba yakyɛ na ŋwana o Yelusalɛmɛ phɔ ɓakyɛ moteya Nkolo. ");
INSERT INTO loq_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Phɔ yakomama o Moɓeko ŋwa Nkolo ɓoɓo: «Ŋwana musɔ ooɓoti ɓɛ́ɛ wa lele wa oɓoo, kaɓe wa Nkolo.» ");
INSERT INTO loq_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Maliya na Zozefu ɓamba ya ambya na ɓɛ́ɛ iɓonza ɓokoongye Moɓeko ŋwa Nkolo: Mankoto ŋwenya maɓale maa ngonda naa ɓana ɓaɓale ɓa mankoto ŋwenya maa lombo. ");
INSERT INTO loq_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Nzuka o Yelusalɛmɛ moto mɔnɔmɔ aɓaka omɔ, nkombo yɛ Simeyɔ. Aɓaka moto wa ɓosembo, aɓaka kakumole na Ŋwaphongo, ambaka ɓa kaziya mokɔlɔ ŋwa moyamanya Ŋwaphongo Isalayɛlɛ ngɔngɔ. Ɓolɔɓɔ Ɓosantu phaɓaka nɛ. ");
INSERT INTO loq_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ɓolɔɓɔ Ɓosantu pha moimolaka oɓokye etawee ɓo naino tawɛni Masiya owamotoma Nkolo. ");
INSERT INTO loq_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Emba Simeyɔ akambemi na Ɓolɔɓɔ, amba yakyɛ o ingambi siinɛnɛ sa losambo. O imbɛlɛ mɛ, ɓaɓoti ɓa ŋwana Yesu ɓamba ya nɛ phɔ ya ikyɛ kyela bokoongye moɓeko phɔ yɛ. ");
INSERT INTO loq_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeyɔ amokpe o maɓɔkɔ mɛ, amba ya phɛ Ŋwaphongo mɛlɛsi yokye: ");
INSERT INTO loq_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Uŋwaŋwa eye, Nkolo, okokye mbunu ya wɛ; okokyi ilɛ moombo ŋwa wɛ awe ɓose. ");
INSERT INTO loq_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Phɔ miyo ma nga mawɛni ibikyi sa wɛ, ");
INSERT INTO loq_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","saaɓɔngyɛ wɛ phɔ ya ɓato ɓasɔ: ");
INSERT INTO loq_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ibikyi mɛ sili moo ŋwaamungyɛngyɛlɛ ɓapakano; ŋwamophɛɛ nkyɛmɔ oka ɓato ɓa wɛ Isalayɛlɛ.» ");
INSERT INTO loq_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ango na nyango wa Yesu ɓakaŋwaka na ikyimowɔlɛ ɓɛ. ");
INSERT INTO loq_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeyɔ amba ɓapambola, aesi ya wɔ na Maliya, nyango wa Yesu yokye: «Phɔ ya ŋwana wa wɛ, ɓato ɓaikye o Isalayɛlɛ, ɓana ɓamokaa ɓaayɔkɔ ɓamotɛmɛ. Amoɓa elembo ya Ŋwaphongo, kasi ɓato ɓamolɛ. ");
INSERT INTO loq_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Emba maumunya maaɓombama o mandondo ma ɓato mamowɛnɛnɛ o phaa. Na wɛ, Maliya, ɓolɔsi phamoetubinya ndokolo mumphata.» ");
INSERT INTO loq_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Yaɓaka na moimosi mɔnɔmɔ wa ŋwaŋwasi, nkombo yɛ Ana, ŋwana wa Fanuɛlɛ, wa iɓota sa Asɛlɛ. Yo akotwaka na ɓokusi. Ɓɛ́ɛ na lele wɛ ɓazala ɓolonga nde mbula sambo, ");
INSERT INTO loq_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ɓoɓɛlɛ aesi ya ikala ɓozengye. Aɓaka na mambula mako ŋwambi mbuka mane. Ana aɓaka nkɔlɔ isɔ o ingambi sa losambo ikyelela Ŋwaphongo na moo na mokɔlɔ, na imiima ntoma na ná iɓɔndɛlɛ. ");
INSERT INTO loq_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Nde o sina imbɛlɛ mɛ, abuto iphɛ Ŋwaphongo mɛlɛsi. Abuto iwɔ phɔ ya ŋwana na ɓato ɓasɔ ɓaɓaka ɓaziya oɓokye Ŋwaphongo aikole Yelusalɛmɛ. ");
INSERT INTO loq_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Waunva ɓaɓoti ɓa Yesu ikyela ya ongaka Moɓeko ŋwa Nkolo, ɓamba ya butwa na ŋwana o manyɛtɛ ma Galileya, o mokyisi ŋwa ɓɛ́ɛ Nazalɛtɛ. ");
INSERT INTO loq_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ŋwana akolaka, azwaka ɓokusi. Atondaka na zebi, na ɓolaa pha Ŋwaphongo phaɓaka mi yo. ");
INSERT INTO loq_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Mbula na mbula ɓaɓoti ɓa Yesu ɓaɓaka ɓakyɛndɛ o Yelusalɛmɛ phɔ ya eyenga ya Ilekana. ");
INSERT INTO loq_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Waakokya Yesu na mambula iko mbuka maɓale, ɓaɓoti ɓɛ́ɛ ɓakyɛkyɛ nɛ ɓo owamɛɛlɛ ɓɛ́ɛ ikyela phɔ ya eyenga. ");
INSERT INTO loq_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Waaunva eyenga, ɓaesi ya butwa. Kasi Yesu aikalaka o Yelusalɛmɛ, ɓaɓoti ɓɛ́ɛ saeɓa. ");
INSERT INTO loq_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ɓaumunyaka oɓokye ali na ɓɛbi na ɓɛ́ɛ ɓaa imbanga, ɓamba kyela nzanga moɓimba ya nzela ɓɛ́ɛ satamoluka. Sima, ɓamba ya kyɛ moluka oka ɓanaa nyango na oka ɓaeɓaa na ɓɛ. ");
INSERT INTO loq_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Kasi waaɓa ɓɛ́ɛ samozwa, ɓaesi ya butwa o Yelusalɛmɛ ikyɛmimoluka. ");
INSERT INTO loq_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Sima ya nkɔlɔ iyato, ɓaesi yakyɛ mozwa o Tempelo azasi onte ya ɓateye ɓa miɓeko, kaɓaokye kambe na ɓatuna mituna. ");
INSERT INTO loq_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ɓato ɓasɔ ɓaɓaka ɓamookye ɓakamwaka na malondo mɛ na ná ɓiyano ɓɛ. ");
INSERT INTO loq_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Waamowɛnɛ ɓɛ, ɓakamwaka na ɓoikye, emba nyango amba ya wɔ nɛ yokye: «Ŋwana wa nga, olokyesi ɓaɓona phɔ ya'ye? Kyeka nga na ɔngɔ toɓakyi na ntema o ikolo phɔ ya ikyɛmieluka.» ");
INSERT INTO loq_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Amba ya ɓabuyisa yokye: «Ɓɛ kondukye phɔ ya'ye? Toeɓe oɓokye nasengyesi iɓa o ingambi sa Tata?» ");
INSERT INTO loq_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Kasi ɓɛ́ɛ teɓaikaka sɔsɔlɔ yaɓawɔlɛkyɛ yo. ");
INSERT INTO loq_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ɓoɓɛlɛ Yesu amba ya butwa na ɓɛ́ɛ o Nazalɛtɛ. Aɓaka kaɓatosa. Nyango aɓanzaka maphɔɔ masɔɔ mamana o ndondo yɛ. ");
INSERT INTO loq_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Emba Yesu aɓaka kakole na zebi na ná nzoto, awɛnɛnɛkyɛ moto molaa o miyo ma Ŋwaphongo na oka ɓato. ");
INSERT INTO loq_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","O mbula ya iko mbuka itano ya ɓokonzi pha Tiɓɛlɛ Sezalɛ, Pɔsɔ Pilata aɓaka moangyesi ŋwa Yuda. Elode aɓaka mokonzi ŋwa Galileya, ŋwana nyango Philipe aɓaka mokonzi ŋwa Itule na Talakonite, Lizania aɓaka mokonzi ŋwa Abilɛnɛ. ");
INSERT INTO loq_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ana na Kaifa ɓaɓaka ɓanganga ɓanɛnɛ ɓa Ŋwaphongo. Imbɛlɛ mɛ Yoane ŋwana wa Zakaliya, aesi ya imola Simo ya Ŋwaphongo o ɓokye. ");
INSERT INTO loq_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yoane abuto ikyɛmitambula nkyisi isɔ iili o mokukulu ŋwa ebale ya Yaladɛnɛ. Aɓaka kakyɛmiwɔ na ɓato yokye: «Ɓɔngya mandondo ma ɓɛ̀ɛ, oɓatisame. Emba Ŋwaphongo amoelimbisa masumu ma ɓɛ̀ɛ.» ");
INSERT INTO loq_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ndengye mɛna, Yoane akokyaka maphɔɔ maakoma moimosi Isaya o buku pha Ŋwaphongo oɓokye: «Moto mɔnɔmɔ kaŋwane o bokye: Ɓɔngya nzela ya Nkolo! Omotɛyisa nsonga! ");
INSERT INTO loq_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Mangɔngɔ masɔ ɓamakyinza, mangomba na makosi masɔ ɓamawalole. Mangbɔngbɔ masɔ ɓamaelole; maɓela mali o nzela ɓamakyinza. ");
INSERT INTO loq_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Emba ɓato ɓasɔ ɓaamba wɛnɛ ɓokobikya Ŋwaphongo ɓato.» ");
INSERT INTO loq_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ɓato ɓaikye ɓaɓaka ɓaye oka Yoane phɔ aɓaɓatisa. Yoane aɓaka kawɔ na ɓɛ́ɛ oɓokye: «Ɓɛɛ ɓosoo imɛlɛ; oephɛ malondo ma ilota yɔɔ ya Ŋwaphongo ekyeye nza? ");
INSERT INTO loq_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Kyela maphɔɔ ma wɛninya oɓokye oɓɔngyɛ moɓesi. Lɛ imiwɔlɛ oɓokye: “Ekpele yɔnɔyɔ etelokyele phɔ Abalayama ali nkɔkɔ wa ɓanga.” Nawɔ na ɓɛ̀ɛ ngakye Ŋwaphongo akokyi ibuya maɓanga mama ɓana ɓa Abalayama. ");
INSERT INTO loq_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ɓambo ɓɔngya ikoko phɔ ya itena nkanga ya nzete. Ŋwete munsɔ mootemooɓote mbuma indaa, ɓaamokpɛtɛ, ɓaamovaka o ŋwenya.» ");
INSERT INTO loq_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ɓato ɓamba motuna ɓɛkye: «Emba tokyele ɓo?» ");
INSERT INTO loq_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yoane amba ya ɓabuyisa yokye: «Oli na bitobu ɓiɓale ɓa ikolo, aphɛ yɔnɔyɔ na ooli pha. Oli na ntoma ya izaa, akaɓele ootoli na ntoma.» ");
INSERT INTO loq_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ɓaphutise ɓa mputi ɓakaka na ɓɛ́ɛ oka Yoane phɔ aɓaɓatisa. Ɓamba ya motuna ɓɛkye: «Moteye, tokyele ɓo?» ");
INSERT INTO loq_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Yoane amba ya ɓabuyisa yokye: «Phutisa mputi nde ɓo owaetoma ɓɛ.» ");
INSERT INTO loq_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ɓatuluku ɓamba ya motuna na ɓɛ́ɛ ɓɛkye: «Ka ɓanga tokyele ɓo?» Yoane amba ya wɔ na ɓɛ́ɛ yokye: «Ɓɛɛ sanyɔkɔlɔ moto, saɓɔlɔlɔ moto ɓaphalanga, sakatela moto lowɔ, bika nde na iphuta sa ɓɛ̀ɛ.» ");
INSERT INTO loq_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ɓato ɓasɔ ɓaɓaka ɓakyele maumunya na ilemela oɓokye emba Yoane teli nde yo Masiya. ");
INSERT INTO loq_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yoane amba ya ɓabuyisela ɓɛ́ɛ ɓasɔ yokye: «Nga naeɓatisa nde na maa, kasi ookoye andekyi na mwiya; sikokyi na iingola nsimbi ya bikoto ɓɛ. Yo amoeɓatisa na Ɓolɔɓɔ Ɓosantu na ná ŋwenya. ");
INSERT INTO loq_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Aphisi enyɛngyɛlɛ o maɓɔkɔ phɔ ya inyɛngyɛlɛ nkata ya angana na mbuma. Amoɓomba mbuma o ɓompɛndɛ kasi amotumba nkata o ŋwenya motemozime.» ");
INSERT INTO loq_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yoane akulaka na teya ɓato maphɔɔ masuu maiikye, aɓaka kaɓaimole na Simo Elaa. ");
INSERT INTO loq_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Yoane aoyaka Elode mokonzi ŋwa Galileya phɔ alongaka Elodiade, ŋwasi wa mwana nyango; na phɔ akulaka nakyela maphɔɔ maɓe maiike. ");
INSERT INTO loq_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Emba Elode akulaka kyela lowɔ losuu looɓe; laa inyɔsa Yoane o bɔlɔkɔ. ");
INSERT INTO loq_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Waaunva Yoane iɓatisa ɓato ɓasɔ, aesi ya ɓatisa na Yesu. Waaɓa Yesu kaɓɔndɛlɛ, ikolo siesi ya zibwa. ");
INSERT INTO loq_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ɓolɔɓɔ Ɓosantu ɓoesi ya moutela ndokolo inkoto ŋwenya, ŋwɛsi mɔnɔmɔ mouti o ikolo mooka oɓokye: «Oli Ŋwana wa nga owa sɔmi, nali na nkyisa ɓoikye phɔ yɛ.» ");
INSERT INTO loq_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","38","Yesu aɓaka na manbula phɛnɛphɛ na mako maato wa tata yo etoma yɛ. Ɓato ɓatataka iumunya oɓokye ali ŋwana wa Zozefu. Zozefu aɓaka ŋwana wa Eliya, Eliya ŋwana wa Matati, Matati ŋwana wa Lewi, Lewi ŋwana wa Melekyi, Melekyi ŋwana wa Yanayi, Yanayi ŋwana wa Zozefu, Zozefu ŋwana wa Matatiasi, Matatiasi ŋwana wa Amosi, Amosi ŋwana wa Nauma, Nauma ŋwana wa Esili, Esili ŋwana wa Nagayi, Nagayi ŋwana wa Maati, Maati ŋwana wa Matatiasi, Matatiasi ŋwana wa Semeyi, Semeyi ŋwana wa Yozeki, Yozeki ŋwana wa Yoda, Yoda ŋwana wa Yoanane, Yoanane ŋwana wa Leza, Leza ŋwana wa Zolobabɛlɛ, Zolobabɛlɛ ŋwana wa Salatiyɛlɛ, Salatiyɛlɛ ŋwana wa Neli, Neli ŋwana wa Melekyi, Melekyi ŋwana wa Toli, Toli ŋwana wa Kosama, Kosama ŋwana wa Elemadama, Elemadama ŋwana wa Ele, Ele ŋwana wa Yesu, Yesu ŋwana wa Elezele, Elezele ŋwana wa Yolima, Yolima ŋwana wa Matati, Matati ŋwana wa Lewi, Lewi ŋwana wa Simeyona, Simeyona ŋwana wa Yuda, Yuda ŋwana wa Zozefu, Zozefu ŋwana wa Yowama, Yowama ŋwana wa Eliyakimi, Eliyakimi ŋwana wa Meleya, Meleya ŋwana wa Mena, Mena ŋwana wa Matata, Matata ŋwana wa Nata, Nata ŋwana wa Davidi, Davidi ŋwana wa Yese, Yese ŋwana wa Yeɓeni, Yeɓeni ŋwana wa Ɓoaze, Ɓoaze ŋwana wa Sala, Sala ŋwana wa Nasoni, Nasoni ŋwana wa Aminadaba, Aminadaba ŋwana wa Alani, Alani ŋwana wa Eselona, Eselona ŋwana wa Pelesi, Pelesi ŋwana wa Yuda, Yuda ŋwana wa Yakoɓo, Yakoɓo ŋwana wa Izaka, Izaka ŋwana wa Abalayama, Abalayama ŋwana wa Tela, Tela ŋwana wa Nawolo, Nawolo ŋwana wa Seluga, Seluga ŋwana wa Leyu, Leyu ŋwana wa Peloga, Peloga ŋwana wa Ebele, Ebele ŋwana wa Sela, Sela ŋwana wa Kainama, Kainama ŋwana wa Alapakasada, Alapakasada ŋwana wa Sema, Sema ŋwana wa Nowa, Nowa ŋwana wa Lameke, Lameke ŋwana wa Metusela, Metusela ŋwana wa Enoka, Enoka ŋwana wa Yalede, Yalede ŋwana wa Malele, Malele ŋwana wa Kename, Kaname ŋwana wa Esini, Esini ŋwana wa Seti, Seti ŋwana wa Adamu, Adamu ŋwana wa Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu atondi na Ɓolɔɓɔ Ɓosantu, amani o eɓale ya Yaladɛnɛ, Ɓolɔɓɔ amba ya mokamba o bokye. ");
INSERT INTO loq_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Omɔ, Zabulu aesi yamumeka nkɔlɔ makoo mane. Nkɔlɔ isɔ miina, Yesu taikaka zaa, sima mɛ amba yaoka nzala. ");
INSERT INTO loq_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Zabulu amba ya wɔ nɛ yokye: «Ɓo oli Ŋwana wa Ŋwaphongo, wɔ na iɓanga sisi sibutwe mapa.» ");
INSERT INTO loq_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesu amba ya mobuyisa yokye: «Buku pha Ŋwaphongo ɓowɔ ɓoɓo: “Moto etabikye nde na mapa.”» ");
INSERT INTO loq_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Emba Zabulu amba yakyɛndɛ nɛ o elele yɔnɔyɔ ya ikolo, amba ya moteya nkyisi isɔ ili o mokyisi. ");
INSERT INTO loq_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Amba ya wɔ nɛ yokye: «Namoephɛ ɓokonzi na ngambo ya nkyisi isɔ mina phɔ ɓaimphɛ, nakokyi iphɛ na moto owa ozingyi nga. ");
INSERT INTO loq_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ka ɓo onkusamesi, isɔ miina yamotwa ya wɛ.» ");
INSERT INTO loq_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesu amba ya mobuyisa yokye: «Buku pha Ŋwaphongo ɓowɔ ɓoɓo: “Wamokusamela nde Nkolo, Ŋwaphongo wa wɛ, wamosambela nde yo.”» ");
INSERT INTO loq_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Zabulu ambakula yakyɛndɛ nɛ o Yelusalɛmɛ, akyɛ motɛyɛ o sɔngyɛ ya Tempelo, amba ya wɔ nɛ yokye: «Ɓoli Ŋwana wa Ŋwaphongo, omikumbɛ o se; ");
INSERT INTO loq_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","phɔ buku pha Ŋwaphongo ɓowɔ ɓoɓo: “Ŋwaphongo amotoma ɓanze ɓɛ́ɛ oɓokye ɓaya eɓanza. ");
INSERT INTO loq_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Na oɓokye ɓamoetamba na maɓɔkɔ phɔ ekolo ya wɛ sa zuma o iɓanga.”» ");
INSERT INTO loq_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesu amba ya mobuyisa yokye: «Buku pha Ŋwaphongo ɓowɔ ɓoɓo: “Sameka Nkolo, Ŋwaphongo wa wɛ.”» ");
INSERT INTO loq_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Waunva Zabulu imeka Yesu, amba ya moika akyɛɛ tee nɔnɔ o imbɛlɛ sisuu saamozwana ɓɛ. ");
INSERT INTO loq_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ɓoɓɛlɛ Yesu, na mwiya ŋwa Ɓolɔɓɔ, amba ya butwa o Galileya. Ngambo yɛ ya tambulaka o nkyisi isɔ ya manyɛtɛ ma Galileya. ");
INSERT INTO loq_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Aɓaka kakyɛmiteya o mangambi ma makyita, ɓato ɓasɔ ɓasambaka mateya mɛ. ");
INSERT INTO loq_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesu akyɛndɛkyɛ o Nazalɛtɛ mokyisi ŋwa kolaka yo. Mokɔlɔ ŋwa Saɓata, amba ya nyɔlɔ o ingambi ma makyita ɓowamɛɛlɛkyɛ yo. Amba ya tɛmɛ phɔ ya itanga buku pha Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ɓamba ya mophɛ mokanda ŋwa moimosi Isaya. Amoingosi, aesi yakyɛ zwa elele eyakoma ɓɛ́ɛ oɓokye: ");
INSERT INTO loq_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Ɓolɔɓɔ pha Nkolo ɓoli mi nga. Anzɔsi phɔ ya iya imola ɓaɓola Simo Elaa. Antomi phɔ ya iya iimola ɓato ɓaa bɔlɔkɔ oɓokye ɓaaɓakondola, na ɓaaphɔlɔ miyo oɓokye ɓamokula wɛnɛ, na phɔ ya iyabikya ɓato ɓaa minyɔkɔ, ");
INSERT INTO loq_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","phɔ ya iya imola ɓato mbula eyamowɛninya Nkolo ngɔlu yɛ.» ");
INSERT INTO loq_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Emba Yesu amba ya ziɓa buku aɓobuyise moto wa etoma o ingambi sa makyita, ɓato ɓasɔ ɓabuto imolembetela. ");
INSERT INTO loq_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ɓoɓɛlɛ Yesu amba ya wɔ na ɓɛ́ɛ yokye: «Maphɔɔ maatangyi nga mama makokyisami lɔlɔ phɔ ya ɓɛ́ɛ ɓaanzokye.» ");
INSERT INTO loq_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ɓɛ́ɛ ɓasɔ ɓasepeleka na Yesu ɓamba na kamwa na maphɔɔ malaa maawɔkɔ yo. Ɓɛkye: «Eye nga ŋwana wa Zozefu!» ");
INSERT INTO loq_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yesu amba ya wɔ na ɓɛ́ɛ yokye: «Naebi oɓokye ɓɛ́ɛ wa munkpela ete ekye wɔ oɓokye: “Munganga, omibikya wɛ mampenza.” Wamokula wɔ na nga na oɓokye: “Tooka isɔ yaakyela wɛ o Kapalanauma, oikyele ɓomɔ na wawa o mokyisi ŋwa wɛ.”» ");
INSERT INTO loq_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yesu ambakula wɔ na ɓɛ́ɛ yokye: «Nde phɛlɛ na wɔ na ɓɛ̀ɛ ngakye: Moimosi teɓamoanole o mokyisi nwɛ. ");
INSERT INTO loq_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Nakule ɓakya ngakye: O imbɛlɛ saka moimosi Eliya, mazengye maɓaka maikye o Isalayɛlɛ. Waaɓa imbɛlɛ mɛ mambula sa nɔɔ mbula iyato na makombe motoɓa, zilo sikusi sakyindaka mokyisi munsɔ. ");
INSERT INTO loq_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Kasi Ŋwaphongo taika toma Eliya nɔnɔ oka mɔnɔmɔ na mazengye mamana. Kasi amotoma nde oka ɓozengye ɓɔnɔɓɔ phaaɓaka o Salepeta mokyisi ŋwa manyɛtɛ ma Sidona. ");
INSERT INTO loq_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Na wa imbɛlɛ saka moimosi Elize, ɓato ɓaikye ɓa maɓa ɓaɓaka o Isalayɛlɛ. Na mɔnɔmɔ na ɓɛ́ɛ taikaka bika. Kasi yabikaka nde Namana moto wa Siri.» ");
INSERT INTO loq_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Waaoka ɓato ɓasɔ ɓaaɓaka o ingambi sa makyita maphɔɔ mɛ, ɓɛ́ɛ ɓasɔ ɓaokyelaka Yesu yɔɔ. ");
INSERT INTO loq_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ɓamba ya tɛmɛ ɓaesi ya tɔkɔlɔ na Yesu o eɓonga. Ɓamba ya kyɛndɛ nɛ o ikolo sa ngomba eya tonga ɓɛ́ɛ mokyisi phɔ ɓamuukye o se. ");
INSERT INTO loq_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Kasi Yesu amba ya bolongana onte ya ɓɛ́ɛ nɔnɔ wakyɛndɛ yo. ");
INSERT INTO loq_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ɓoɓɛlɛ Yesu amba ya kyɛndɛ o Kapalanauma, mokyisi ŋwa manyɛtɛ ma Galileya. Aɓaka kateya ɓato nkɔlɔ isɔ ya Saɓata. ");
INSERT INTO loq_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ɓato ɓakamwaka na moteyesi nwɛ phɔ aɓaka kawɔ na ɓokonzi ɓosɔ. ");
INSERT INTO loq_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","O ingambi sa makyita, moto mɔnɔmɔ aɓaka na ɓolɔɓɔ ɓoɓe. Amba ya butwa iyaŋwana na ɓokusi yokye: ");
INSERT INTO loq_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Aa Yesu wa Nazalɛtɛ, kolukye ilokyela ɓo? Oesi nde iya lounva? Naeyeɓe, iwɛ oli Mosantu owa toma Ŋwaphongo.» ");
INSERT INTO loq_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesu amba ya phaphala na ɓolɔɓɔ ɓoɓe mɛ amba wɔ na phango yokye: «Zala ɓose! Eemba na tɔkɔlɔ onte ya moto oyo.» Ɓolɔɓɔ ɓoɓe mɛ phaamba ya vaka moto mɛ o se o ɓoo pha ɓato ɓasɔ, ɓotɔkɔsi saika mokyela na ɓoɓe. ");
INSERT INTO loq_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ɓato ɓasɔ ɓakamwaka na ɓoikye, ɓamba mituna onte ya ɓɛ́ɛ ɓɛkye: «Maphɔɔ ma moto oyo mali ya ɓo'ye? Kawɔ na ɓokonzi na malɔɓɔ maɓe oɓokye matɔkɔlɔ, maambe na tɔkɔlɔ.» ");
INSERT INTO loq_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Emba ngambo ya Yesu ya tambulaka o nkyisi isɔ. ");
INSERT INTO loq_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu amba ya tɔkɔlɔ o ingambi sa makyita, amba ya kyɛ nyɔlɔ o ingambi sa Simo. Ɓokyilo pha Simo owa ŋwaŋwasi aɓaka na mowɛwɛ moikye, ɓamba onga na Yesu oɓokye amobikya. ");
INSERT INTO loq_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yesu amba ya mikpakya mi yo, na ŋwɛsi mokusi amba phaphala na mowɛwɛ nɔnɔ waamana ŋwango, mina wamɔ aesi ya iŋwa, abuto iɓakyelela. ");
INSERT INTO loq_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Waatate inda bunya, ɓato ɓasɔ ɓaaɓaka na ɓato ɓa malɔsi ndengye na ndengye ɓamba ya na ɓɛ́ɛ ooli Yesu. Amba ya tandela mɔnɔmɔ na mɔnɔmɔ maɓɔkɔ, amba ɓabikya. ");
INSERT INTO loq_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Malɔɓɔ maɓe maatɔkɔlɔkɔ onte ya ɓato ɓaayɔkɔ ɓa malɔsi maaŋwanaka oɓokye: «Oli Ŋwana wa Ŋwaphongo!» Kasi Yesu amba phaphala na mango, amakatelaka oɓokye mɛ sa wɔɔ, phɔ mɛ maeɓaka oɓokye yo ali Masiya. ");
INSERT INTO loq_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Waayɛ bunya Yesu aesi ya mana o Kapalanauma, aesi ya kyɛndɛ o elele yɔnɔyɔ ya ɓose. Ɓato ɓaikye ɓabuto imoluka. Waamozwa ɓɛ, ɓamba mozimba oɓokye yo salekana. ");
INSERT INTO loq_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Kasi Yesu amba wɔ na ɓɛ́ɛ yokye: «Nasengyesi iimola Simo Elaa ya Ɓokonzi pha Ŋwaphongo o nkyisi iiyɔkɔ mɛ. Phɔ Ŋwaphongo antoma nde phɔ ya ɓomɔ.» ");
INSERT INTO loq_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Amba ya kyɛmiteya o mangambi ma makyita masɔ mali o Yuda. ");
INSERT INTO loq_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Mokɔlɔ mɔnɔmɔ, Yesu aɓaka o mokukulu ŋwa maa maanɛnɛ ma Genezalɛtɛ, ɓato ɓaikye ɓamba ya izele oli yo phɔ ya iya oka iloɓa sa Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Yesu aesi ya wɛnɛ mato maɓale o mokukulu ŋwa maa maanɛnɛ. Mato mɛ ya maikaka ɓaɔsi ɓautaka o maa phɔ ya akunyola mandɛndi ma ɓɛ. ");
INSERT INTO loq_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesu amba ya baa ovato ɓɔnɔɓɔ, yaɓaka phaka Simo. Amba wɔ na Simo oɓokye tangola vato ŋwana itakye na mokukulu. Yesu amba ya zala o vato abuto iteya ɓato. ");
INSERT INTO loq_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Waaunva yo iteya, amba wɔ na Simo yokye: «Susinya vato o ɓodiko, emba iwɛ na ɓɛbi na wɛ, ovakye mandɛndi phɔ oɓome swe.» ");
INSERT INTO loq_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simo amba ya mobuyisa yokye: «Moteye, toɔsi mokɔlɔ mobimba toloikyi ɓoma na ekpele. Ka phɔ wɛ oniwɔ ɓaɓona, na movaka mandɛndi o maa.» ");
INSERT INTO loq_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ɓamba ya vaka mandɛndi o maa, ɓamba zwa swe ɓoikye. Mandɛndi ma ɓɛ́ɛ matataka naikakwa. ");
INSERT INTO loq_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ɓamba ya ɓanga ɓɛbi na ɓɛ́ɛ ɓaɓaka o vato ɓoyɔkɔ oɓokye ɓayaɓasunga. Ɓɛbi na ɓɛ́ɛ ɓamba yaa. Ɓamba tonza mato masɔ maɓale na swe. Mato mɛ malukaka na izinda. ");
INSERT INTO loq_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Wawɛ nɛ Simo Petelo ɓaɓona, amba kaa na maɓɔngɔ o ɓoo pha Yesu yokye: «Nkolo, mana phɛnɛphɛ na nga, phɔ nali moto wa masumu.» ");
INSERT INTO loq_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Phɔ eɓe yo eɓe ɓɛbi nɛ ɓaokaka ɓɔɔɓɔ, phɔ ya ɓoikye pha swe yaa ɓomaka ɓɛ. ");
INSERT INTO loq_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Zake na Yoane, ɓana ɓa Zebede, ɓɛbi na Simo ɓayakaka ya ɓasunga ɓawɛnɛkyɛ na ɓɛ́ɛ ɓɔɔɓɔ. Kasi Yesu amba ya wɔ na Simo yokye: «Sa ila! Ɓanda lɔlɔ otokule ɓa moɔsi wa swe, wamobutwa molukyi wa ɓato.» ");
INSERT INTO loq_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Emɓa ɓamba komya mato o mokukulu, ɓaesi ya ika isɔ nɔnɔ waa ɓenga ɓɛ́ɛ Yesu. ");
INSERT INTO loq_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Waaɓa Yesu o mokyisi mɔnɔmɔ, moto monɔmɔ aɓaka na ɓolɔsi pha maɓa amba ya ooli yo. Wa wɛnɛ yo Yesu, aesi ya kusama o ɓoo phɛ, ɓoo nɔnɔ o se, amba nyingonela nɛ yokye: «Nkolo! Ɓo ozingyi okokyi imbikya.» ");
INSERT INTO loq_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesu amba ya tanda eɓɔkɔ, amba mokuma, amba wɔ nɛ yokye: «Naanosi, bika.» Nde mina wamɔ, maɓa mamani. ");
INSERT INTO loq_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yesu amba yawɔ nɛ yokye: «Saika imola na moto mɔnɔmɔ lowɔ lolo. Kasi kyɛndɛ nde miteya oka nganga ya Ŋwaphongo ɓoobuto wɛ, emba ombe ambya ikaɓo ɓo wa wɔ Mose phɔ ya ɓato ɓabikyi na ɓolɔsi pha maɓa, phɔ ya iwɛninya oka ɓato oɓokye obikyi phɛlɛ.» ");
INSERT INTO loq_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ngambo ya Yesu yatambulaka mboka esɔ. Ɓato ɓaikye ɓaɓaka ɓayaangana waali yo phɔ ya iyamooka na iyaluka ibikyi na malɔsi ma ɓɛ. ");
INSERT INTO loq_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Kasi Yesu aɓaka kakyɛndɛ ɓɔndɛlɛ yo mampenza o bilele ba ɓose. ");
INSERT INTO loq_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Mokɔlɔ mɔnɔmɔ Yesu aɓaka kateya. Ɓafalisayi na ɓateye ɓa miɓeko ɓaɓaka wamɔ. Ɓakyɛkyɛ miuta o nkyisi isɔ ya Galileya na ya Yuda na o Yelusalɛmɛ. Yesu aɓaka kabikya ɓato ɓa malɔsi na mwiya ŋwa Nkolo Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ɓato ɓamba moyelela na moto owa nyiɓa makolo ɓamophisi miitɔkɔ. Ɓamba ya luka nzela ya imunyɔsa o ingambi phɔ ya ikyɛmolangya o ɓoo pha Yesu. ");
INSERT INTO loq_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Kasi phɔ ya ɓoikye pha ɓato, teɓaika zwa nzela ya ikoma nɔnɔ ooli Yesu. Ɓamba ya ɓaa o motɔndɔ ŋwaa langyema, ɓamba bumbola muna motɔndɔ nɔnɔ wa mouya ɓɛ́ɛ mi sina itɔkɔ onte ya ɓato o ɓoo pha Yesu. ");
INSERT INTO loq_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Waawɛnɛ Yesu ianola sa ɓɛ, amba ya wɔ na moto owa nyiɓa makolo yokye: «Nwɛbi na nga, naelimbise masumu ma wɛ.» ");
INSERT INTO loq_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ɓateye ɓa miɓeko na ɓafalisayi, ɓabuto imituna ɓɛkye: «Moto ookonetola Ŋwaphongo oyo ani ɓa nza? Ookokyi ilimbisa masumu nza ɓo teeɓe nde Ŋwaphongo!» ");
INSERT INTO loq_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesu aeɓaka maumunya ma ɓɛ. Amba wɔ na ɓɛ́ɛ yokye: «Ɓɛ̀ɛ koumunya ɓaɓona phɔ ya'ye? ");
INSERT INTO loq_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Iwɔ na moto oɓokye: “Masumu ma wɛ malimbisami”, na ná iwɔ nɛ oɓokye: “Tɛmɛ, tambula?” Elekyi ɓokusi iye ");
INSERT INTO loq_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Kasi nazingyi oɓokye ɓɛ́ɛ oeɓe oɓokye Ŋwana wa Moto ali na ɓokonzi pha ilimbisa masumu wawa o mokyisi.» Emba amba ya wɔ na moto owa nyiɓa makolo yokye: «Nawɔ na wɛ, tɛmɛ, kpa itɔkɔ sa wɛ butwa oka ɓɛ.» ");
INSERT INTO loq_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Mina wa mɔ, aesi ya tɛmɛ o miyo ma ɓato ɓasɔ atombi itɔkɔ saamolangyaka na ɓɛ, nɔnɔ wabutwa yo oka ɓɛ́ɛ na ikyɛmikumbela Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ɓato ɓasɔ ɓakaŋwaka na ɓoikye, ɓakumbelaka Ŋwaphongo, na ɓɔɔɓɔ ɓɛkye: «Towɛni lɔlɔ maphɔɔ ma ikamwa!» ");
INSERT INTO loq_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ɓoɓɛlɛ Yesu amba ya tɔkɔlɔ, amba ya wɛnɛ moto mɔnɔmɔ nkombo yɛ Lewi, mophutise wa mputi, azasi o elele yɛ ya etoma. Yesu amba wɔ nɛ yokye: «Imbengye!» ");
INSERT INTO loq_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lewi aesi ya tɛmɛ, aikyi iika isɔ aɓengyi Yesu. ");
INSERT INTO loq_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Emba Lewi amba kyelela Yesu esɛlɛkɔ enɛnɛ o ingambi sɛ. Ɓaphutise ɓa mputi ɓaikye na ɓato ɓasuu ɓaɓaka o mesa na ɓɛ. ");
INSERT INTO loq_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ɓafalisayi na ɓateye ɓa miɓeko ɓawɛnɛkyɛ ɓoɓe, ɓamba ya wɔ na ɓaekosi ɓa Yesu ɓɛkye: «Phɔ ya'ye ɓɛ́ɛ koze, konywe elele yɔnɔyɔ na ɓaphutise ɓa mputi na ɓato ɓa masumu?» ");
INSERT INTO loq_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesu amba ɓabuyisa yokye: «Ɓaali na nzoto ndaa teɓasengyesi na munganga, esengyesi na munganga nde ɓato ɓali na malɔsi. ");
INSERT INTO loq_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Siesi ya ɓanga ɓato ɓalaa. Kasi naesi ya ɓanga nde ɓato ɓaaɓe phɔ ɓaɓongole ntema ya ɓɛ.» ");
INSERT INTO loq_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ɓafalisayi ɓamba ya wɔ na Yesu ɓɛkye: «Ɓaekosi ɓa Yoane Moɓatise, eɓe na ɓaaka ɓafalisayi ɓamiime ntoma, ɓambe na ɓɔndɛlɛ; ka ɓaekosi ɓaaka ya wɛ ɓaze, ɓanywe.» ");
INSERT INTO loq_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesu amba ɓabuyisa yokye: «Mokɔlɔ ŋwa esɛlɛkɔ ya ɓolonga, okokyi ilasa ɓato ɓaaɓangyi yo o esɛlɛkɔ nzala ɓo molongyi ataa ɓa na ɓɛ? ");
INSERT INTO loq_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Kasi mokɔlɔ ŋwaa moɓa molongyi saɓa onte ya ɓɛ, emba mi nkɔlɔ mina, ɓaamilasa nzala.» ");
INSERT INTO loq_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesu amba ya ɓakpela ete eye: «Moto takokyi ikpa etato ya etobu eenyakune phɔ ya ietongya na etobu eya ɓooka. Ɓo akyesi ɓaɓona, aɔti etobu eenyakune, etato ya etobu eenyakune teekoka na etobu eya ɓooka. ");
INSERT INTO loq_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Nde ɓomɔ, moto takokyi iangola malɛku maa swaswa o mambongo maaɓoka. Ɓo akyesi ɓaɓona, malɛku maa swaswa mamoɓola mambongo maaɓoka, malɛku ma molukwa o se, mambongo mamɔɔtɔnɔ. ");
INSERT INTO loq_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Kasi ɓaɓona phe, malɛku maa swaswa ɓamatɛyɛ nde o mambongo maaanyakune. ");
INSERT INTO loq_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Moto etazingye inywa malɛku maa swaswa ɓo ambo nywa malɛku maa mpiko, phɔ amowɔ oɓokye: “Malɛku maa mpiko malekyi ɓolaa.”» ");
INSERT INTO loq_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Mɔkɔlɔ mɔnɔmɔ ŋwa Sabata, Yesu na ɓaekosi ɓɛ́ɛ ɓalekanaka o manzabi ma ble. Baekosi ɓɛ́ɛ ɓabuto inɔkɔ ena ble, ɓaeyinya o matandala ɓambe za ina mbuma. ");
INSERT INTO loq_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Bafalisai ɓayɔkɔ ɓamba ya tuna ɓaekosi ɓa Yesu ɓɛkye: «Phɔ ya'ye kokyele maphɔɔ maakatele moɓeko ikyela mokɔlɔ ŋwa Saɓata?» ");
INSERT INTO loq_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesu amba ya ɓabuyisa yokye: «Toikatanga yaakyelaka Davidi, mokɔlɔ mɔnɔmɔ yo na ɓɛbi nɛ ɓaɓaka na nzala? ");
INSERT INTO loq_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Anyɔlɔkɔ o Ingambi sa Ŋwaphongo, akpaka mapa maambyaka ɓɛ́ɛ oka Ŋwaphongo. Amazaka, aphɛkyɛ na ɓɛbi nɛ. Kasi moɓeko ŋwa ɓanga mowɔ oɓokye mapa mamana makokyi izaa nde ɓanganga ɓa Ŋwaphongo.» ");
INSERT INTO loq_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yesu amba ya wɔ na ɓafalisayi yokye: «Ŋwana wa Moto ali Nkolo wa Saɓata.» ");
INSERT INTO loq_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Mokɔlɔ mosuu ŋwa Saɓata, Yesu amba ya nyɔlɔ o Ingambi sa makyita, abuto iteya. Moto monɔnɔ owa nyiɓa eɓɔkɔ ya ɓolo aɓaka omɔ. ");
INSERT INTO loq_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ɓateye ɓa miɓeko na ɓafaliayi ɓaɓaka ɓakyekye Yesu naa amobikya moto mona mokɔlɔ ŋwa Saɓata phɔ ɓazwe nzela ya imophunda. ");
INSERT INTO loq_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Kasi Yesu aeɓaka maumunya ma ɓɛ. Amba ya wɔ na moto owa nyiɓa eɓɔkɔ yokye: «Iŋwa, otɛmɛ o ɓoo pha ɓato ɓasɔ!» Moto mɛ amba ya iŋwa, akyɛ tɛmɛ. ");
INSERT INTO loq_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Emba Yesu amba ya wɔ na ɓɛ́ɛ yokye: «Naetune ɓɛ̀ɛ, moɓeko ŋwa ɓanga mowɔ ɓo phɔ ya Saɓata? Ikyela ɓolaa ndee ikyela ɓoɓe, ibikya moto ndee imolɛ kawe?» ");
INSERT INTO loq_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yesu amba ɓakyeka ɓɛ́ɛ ɓasɔ, amba ya wɔ na moto owa nyiɓa eɓɔkɔ yokye: «Elola eɓɔkɔ ya wɛ.» Amba ya eyelola, eɓɔkɔ eɓɔngyi. ");
INSERT INTO loq_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Kasi ɓateye ɓa miɓeko na ɓafalisayi ɓatondaka na yɔɔ, ɓabuto iyika ziko onte ya ɓɛ́ɛ phɔ ya lowɔɔ lookokyi ɓɛ́ɛ ikyela phɔ ya Yesu. ");
INSERT INTO loq_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Imbɛlɛ mɛ, Yesu akyɛkyɛ ɓaa o ngomba phɔ ya iɓɔndɛlɛ. Alekyinyaka mokɔlɔ mobimba omɔɔ phɔ ya iɓɔndɛlɛ Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Waa yɛ bunya, amba ya ɓanga ɓaekosi ɓɛ. Onte ya ɓɛ, amba ya ɔlɔ iko mbuka ɓaɓale, amba ya ɓaphɛ nkombo ya ɓatoma. ");
INSERT INTO loq_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Yaɓaka: Simo owa phɛkyɛ yo nkombo ya Petelo, Andele ŋwana nyango na Simo, Zake, Yoane, Filipe, Ɓatelemi, ");
INSERT INTO loq_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matiye, Toma, Zake ŋwana wa Alifa, Simo owa ingomba sa ɓaatɛmbɛlɛ mokyisi ŋwa ɓɛ, ");
INSERT INTO loq_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yuda ŋwana wa Zake, na Yudasi Isikaliyɔta, owa ungyaka Yesu. ");
INSERT INTO loq_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesu amba ya uta ngomba yo na ɓatoma ɓɛ, amba ya kyɛ tɛmɛ o elele yɔnɔyɔ eya langyema. Ɓaekosi ɓɛ́ɛ ɓaikye ɓaɓaka wamɔ. Yaɓaka wamɔ na moluku ŋwa ɓato mwikye ɓautaka o Yuda mobimba, ɓautaka o Yelusalɛmɛ na o nkyisi ya mbale ya Tula na Sidona. ");
INSERT INTO loq_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ɓato ɓayakaka phɔ ya iya oka Yesu na iluka ibika na malɔsi ma ɓɛ. Ɓato ɓaɓaka ɓatungyisame na malɔɓɔ maɓe, na ɓɛ́ɛ ɓabikaka. ");
INSERT INTO loq_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ɓato ɓasɔ ɓalukaka ikuma Yesu phɔ phɛmbɔ yaaɓaka kyitɔkɔlɔ nɛ yaɓaka kyiɓabikya ɓɛ́ɛ ɓasɔ. ");
INSERT INTO loq_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Emba Yesu amba kyeka ɓaekosi ɓɛ, amba ya wɔ na ɓɛ́ɛ yokye: «Nkɔnzɔ na ɓɛ̀ɛ ɓaali ɓaɓola, phɔ Ɓokonzi pha Ŋwaphongo ɓoli pha ɓɛ̀ɛ! ");
INSERT INTO loq_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Nkɔnzɔ na ɓɛ̀ɛ ɓali na nzala uŋwamwa eye, phɔ wa mozwa ntoma ya izaa nzikye. Nkɔnzɔ na ɓɛ̀ɛ ɓaalele uŋwaŋwa eye phɔ wamoɛkyɛ! ");
INSERT INTO loq_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Nkɔnzɔ na ɓɛ̀ɛ ɓo ɓato ɓaeyine, ɓo ɓaelɛ na ɓo ɓaambe etola, ɓambe tanga mankombo ma ɓɛ̀ɛ na ɓoɓe phɔ koanole Ŋwana wa Moto. ");
INSERT INTO loq_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Sepela ɓa na esɛngo mokɔlɔ ŋwa moya maphɔɔ mamana, phɔ iphuti siinɛnɛ sieziya o ikolo. Oeɓe oɓokye ɓankɔkɔ ɓa ɓɛ̀ɛ ɓanyɔkɔlɔkɔ ɓaimosi ɓa Ŋwaphongo nde ɓomɔ. ");
INSERT INTO loq_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Kasi ngɔngɔ ya ɓɛ̀ɛ ɓato ɓa ezwele phɔ ombozwa esɛngɔ ya ɓɛ̀ɛ wawa o se. ");
INSERT INTO loq_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ngɔngɔ ya ɓɛ̀ɛ ɓaali na isɔ isengyesi na ɓɛ̀ɛ wawa o se uŋwaŋwa eye, phɔ wa mowa na nzala. Ngɔngɔ ya ɓɛ̀ɛ ɓato ɓaɛkyɛ uŋwaŋwa eye, phɔ wamoɓa o elesi wamba na lela, ");
INSERT INTO loq_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ngɔngɔ ya ɓɛ̀ɛ ɓo ɓato ɓasɔ ɓaewɔlɛ na ɓolaa; ɓankɔkɔ ɓa ɓɛ́ɛ ɓakyelaka nde ɓaɓona na ɓaimosi ɓa ɓɔlɛ.» ");
INSERT INTO loq_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«Kasi na wɔ na ɓɛ̀ɛ ɓaanzokye: Zinga ɓanguna ɓa ɓɛ, kyela ɓolaa na ɓato ɓaaeyine, ");
INSERT INTO loq_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","imela ɓolaa na ɓato ɓaeyimele ɓoɓe, ɓɔndɛlɛ Ŋwaphongo phɔ ya ɓato ɓaaenyɔkɔlɔ. ");
INSERT INTO loq_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ɓo moto aewandi engyete o mpakato eya ɓowɛ, kula molaalela na mpakato eya ɓoloo. Ɓo moto aeɓɔlɔsi munkoto ŋwa wɛ, omolɛ kapke na ena simisi. ");
INSERT INTO loq_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Kaɓela moto munsɔ okoeyongye ekpele. Ka ɓo moto akpe epkele ya wɛ, sakula eonga. ");
INSERT INTO loq_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Kyela na ɓasuu ikyizingye wɛ oɓokye ɓaekyele yango. ");
INSERT INTO loq_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ɓokonzingye nde ɓato ɓaezingye, wamba zwa iye? Phɔ na ɓato ɓa masumu ɓazingye ɓaaɓazingye. ");
INSERT INTO loq_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ka ɓokokyele ɓolaa nde na ɓato ɓaaekyele ɓolaa, wamba zwa iye? Na ɓato ɓa masumu ɓakyele nde ɓomɔ. ");
INSERT INTO loq_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ka ɓokoɓekya nde na ɓaaeɓe wɛ oɓokye ɓamoebuyisa, wamba zwa iye? Na ɓato ɓa masumu ɓaɓekya ɓɛbi na ɓɛ́ɛ ɓato ɓa masumu phɔ ɓaaɓabuyisa ndengye eeɓaɓekyakyi ɓɛ. ");
INSERT INTO loq_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ka ɓɛ̀ɛ, zinga ɓanguna ɓa ɓɛ̀ɛ, oɓakyele ɓolaa, ɓekya salemela oɓokye ɓaaɓekye wɛ ɓamoebuyisa. Emba wamozwa iphuti sinɛnɛ, wamba ɓaa na ɓana ɓa Ŋwaphongo Owa Ikolo. Phɔ yo ali molaa phɔ ya ɓato ɓate ɓaaphɛ mɛlɛsi na ɓato ɓaa nkamba. ");
INSERT INTO loq_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Okyelaka ɓato ngɔngɔ ɓokookyele ango wa ɓɛ̀ɛ ɓato ngɔngɔ.» ");
INSERT INTO loq_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«Sasambisa ɓɛbi, eteɓaesambisa mɛ. Sanyɛtɛ ɓɛbi, eteɓaaenyɛtɛ mɛ. Limbisa ɓɛbi, ɓamoelimbisa mɛ. ");
INSERT INTO loq_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Kaɓela ɓɛbi, ɓamoekaɓela mɛ. Ɓamotonza ɓanyanzima ɓa ɓɛ̀ɛ, ɓaa ɓainisa, ɓaaɓanyingyinya phɔ ɓatonde na ɓolaa. Phɔ, ɓamoekaɓela nde ɓookokaɓele wɛ ɓɛbi.» ");
INSERT INTO loq_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesu ambakula ɓakpelela ete yokye: «Moto owa phɔlɔ miyo takokyi iteya nwɛbi nɛ owa phɔlɔ miyo nzela. Phɔ ɓɛ́ɛ ɓasɔ ɓaɓale ɓamokyɛ kaa o iɓela, teli ɓomɔ? ");
INSERT INTO loq_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Moekosi na mɔnɔmɔ taalekye molakyisi wɛ na mayɛlɛ. Kasi moekosi munsɔ oteye ɓɛ́ɛ na ɓolaa kabutwe nde ɓooli molakyisi wɛ.» ");
INSERT INTO loq_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","«Phɔ ya'ye kowɛnɛ mungalala mooli o ziyo sa mwɛbi na wɛ, kasi ete ya ŋwete eli o ziyo saka ya wɛ toewɛnɛ? ");
INSERT INTO loq_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ndengye'ye okokyi iwɔ na nwɛbi na wɛ oɓokye: “Nwɛbi, lɛ naemanya mungalala mooli o ziyo sa wɛ”, kasi toowɛnɛ ete ya ŋwete eli o ziyo saka ya wɛ? Moto wa ɓɔlɛ, taamanya ete ya ŋwete eli o ziyo sa wɛ, emba wamowɛnɛ na ɓolaa phɔ ya imanya mungalala mooli o ziyo sa nwɛbi na wɛ.» ");
INSERT INTO loq_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«Ŋwete molaa temooɓote mbuma mbe, na ŋwete mooɓe temoɓote mbuma ndaa. ");
INSERT INTO loq_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ŋwete na ŋwete ɓamoeɓe nde na mbuma ya ŋwango. Teɓaa imbe mbuma ya fige o nzete yaa milɔ, teɓaa nɔkɔ mbuma ya vinyɔ o nkaa. ");
INSERT INTO loq_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Moto o molaa katɔkɔlɔ maphɔɔ malaa maute o ndondo yɛ. Moto o moɓe katɔkɔlɔ maphɔɔ maaɓe maute o ndondo yɛ. Phɔ isɔ iikyitɔlɔ o munɔkɔ ŋwa moto kyiute nde o ndondo yɛ.» ");
INSERT INTO loq_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«Phɔ ya'ye ɓɛ́ɛ kombangye: “Nkolo, Nkolo”, kasi tokyele ikyi wɔ nga? ");
INSERT INTO loq_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Na moeteya moto owa ulana na moto okoye oka nga, kaokye maphɔɔ ma nga kambe na matosa. ");
INSERT INTO loq_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Alulana na moto okotongye ingambi, aimi mbɔngu nzindo, akyesi maɓanga o motema. Ambitata itonga o ikolo sa maɓanga mɛ. Waaya mpela enɛnɛ, maa ma ebale matombi, maesi ya koma nɔnɔ o sina ingambi. Kasi temaikyi siuwola phɔ inganbi mɛ satongamaka na ɓolaa. ");
INSERT INTO loq_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ka moto okookye maphɔɔ ma nga kasi tamatosa, aulana na moto mɔnɔmɔ katongye ingambi nde o ikolo sa manyɛtɛ sa ima mbɔngu ya inyɔsa maɓanga. Waaya mpela, ingambi sizindi, sikaa nde mbala yɔnɔyɔ siuwo sisɔ sisɔ.» ");
INSERT INTO loq_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Waaunva Yesu iwɔlɛ ɓato maphɔɔ mamana, ambaka ya kyɛndɛ o Kapalanauma. ");
INSERT INTO loq_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Omɔɔ, mokonzi ŋwa ɓatuluku ba Loma aɓaka na moombo owa lɔɓɔkɔ yo zinga. Moombo mɛ aɓaka na ɓolɔsi pha iwa. ");
INSERT INTO loq_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Waaoka mokonzi ŋwa ɓatuluku mɛ simo ya Yesu, amba ya motomela ɓanaa ɓakumu ɓa ɓayuda phɔ ya ikyɛ wɔ nɛ oɓokye aya bikya moombo wɛ. ");
INSERT INTO loq_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Waakoma ɓakumu oka Yesu, bamba butwa inyingonela nɛ ɓɛkye: «Moto oolotomi oyo ali molaa, akokyi oɓokye omosungye ");
INSERT INTO loq_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","phɔ kazingye ɓato ɓa ɓanga, eli na yo moto owa lotongyela Ingambi sa losambo.» ");
INSERT INTO loq_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Boɓɛlɛ Yesu amba ya kyɛ yo na ɓankumu ɓaatomaka ɓɛ. Waakoma yo phɛnɛphɛ na ingambi, mokomzi ŋwa ɓatuluku aesi ya toma ɓɛbi nɛ phɔ ɓakyɛ wɔ na Yesu oɓokye: «Nkolo, lɛ mitungyisa. Siikyi longobana oɓokye onyɔlɔ o ingambi sa nga. ");
INSERT INTO loq_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Yango mɛna naloti iya nga mampenza oka ya wɛ. Kasi wɔ nde lɔwɔɔ lɔnɔlɔ, moombo wa nga amobika. ");
INSERT INTO loq_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nga na tosa ɓakonzi ɓa nga, naambi na ɓa na ɓatuluku ɓaa kambe nga. Ɓo nawɔɔ na mɔnɔmɔ na ɓɛ́ɛ ngakye: “Kyɛndɛ”, ka kyɛndɛ, ɓo naani wɔɔ na ooyɔkɔ ngakye: “Yaka”, kaye. Ɓo na wɔɔ na moombo wa nga ngakye: “Kyela ɓoɓo”, kakyele nde ɓomɔ.» ");
INSERT INTO loq_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Waaoka Yesu maloba mamana, amba sepela na mokonzi ŋwa ɓatuluku. Amba ekola ɓoo oka ɓato ɓaaɓaka ɓamobengye, amba wɔ na ɓɛ́ɛ yokye: «Na wɔ na ɓɛ̀ɛ ngakye naino siwɛni ianola sa ndengye'ye eɓe na o ɓato ɓa Isalayɛlɛ.» ");
INSERT INTO loq_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Waaya butwa ɓato ɓaatomaka ɓɛ́ɛ o ingambi sa mokonzi ŋwa ɓatuluku, ɓaya kyɛ zwa moombo mɛ abikyi. ");
INSERT INTO loq_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ɓoɓɛlɛ Yesu amba yakyɛ o mokyisi muunɛnɛ mɔnɔmɔ nkombo ya ŋwango Naina. Baesi ɓɛ́ɛ na ɓato ɓasuu ɓaikye ɓaakyɛndɛkyɛ nɛ. ");
INSERT INTO loq_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Waakoma yo phɛnɛphɛ na iɓala, ɓaesi ya vana na ɓato ɓakyɛndɛ kunda moto o malita. Yaɓaka ŋwana wa lele nde mɔnɔmɔ wa ŋwaŋwasi ɓozengye. Ɓato ɓaikye ɓa mokyisi ɓakyɛkyɛ mi moukya. ");
INSERT INTO loq_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Waa wɛnɛ Yesu ŋwaŋwasi mɛ, amookaka ngɔngɔ, amba ya wɔ nɛ yokye: «Lɛ ilela.» ");
INSERT INTO loq_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Yesu amba ya susinya, amba ya kuma ena ephomba. Ɓato ɓaaephilaka ɓamba ya tɛmɛ. Yesu amba ya wɔ yokye: «Munzenga, na wɔ na wɛ, langwa!» ");
INSERT INTO loq_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Mowee amba ya zala, abuto iwɔ. Yesu amba ya mobuyisa nyango. ");
INSERT INTO loq_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ɓato ɓasɔ ɓailaka na ɓoikye, ɓamba butwa iwɔ ɓɛkye: «Moimosi munɛnɛ atɔkɔsi onte ya ɓanga! Ŋwaphongo aesi na ya ɓikya ɓato ɓɛ!» ");
INSERT INTO loq_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Emba ngambo ya Yesu yamba tambula mboka esɔ tee nɔnɔ o Yuda moɓimba na o nkyisi yaa mambale phɔ ya lowɔ laakyelaka yo. ");
INSERT INTO loq_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ɓaekosi ɓa Yoane ɓamba kyɛ moimola maphɔɔ masɔ. Emba Yoane amba ya ɓanga ɓaɓale mi ɓaekosi ɓɛ. ");
INSERT INTO loq_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Amba ya ɓatoma oka Yesu phɔ ya ikyɛ motuna oɓokye: «Eli wɛ Masiya ookoye ndee toziya mosuu?» ");
INSERT INTO loq_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Waakoma ɓɛ́ɛ oka Yesu, ɓamba ya wɔ nɛ ɓɛkye: «Yoane Moɓatise alotomi phɔ ya iya etuna oɓokye “eli wɛ Masiya ookoye ndee toziya mosuu?”» ");
INSERT INTO loq_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Nde o sina imbɛlɛ mɛ, Yesu aɓaka kabikya ɓato ɓaikye na malɔsi ma ɓɛ, na bilɛmɛ ba ɓɛ́ɛ na ɓato ɓa malɔɓɔ maɓe, na ɓaaphɔlɔ miyo. ");
INSERT INTO loq_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Emba Yesu amba ya buyisa ɓatima ɓa Yoane yokye: «Kyɛndɛ kyɛ imola Yoane maphɔɔ masɔ maawɛni ɓɛ̀ɛ na maokyi ɓɛ̀ɛ; ɓato ɓaaphɔlɔ miyo ɓawɛni, ɓato ɓaaɔtɔnɔ makolo ɓatambusi na ɓola, ɓato ɓaa maɓa ɓabikyi, ɓato ɓaaloko ɓaokyi, ɓawe ɓaako, ɓaɓola ɓaokye Simo Elaa. ");
INSERT INTO loq_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Esengɔ na moto owamoɓa sabungya ianola sɛ phɔ ya nga!» ");
INSERT INTO loq_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Waabutwa ɓatoma ɓaatomaka Yoane, Yesu amba ya butwa ituna ɓato ɓaaɓaka wamɔ phɔ ya Yoane yokye: «Ɓɛ okyɛkyi kyela iye o bokye? Ŋwana ŋwete kanyingane na ewɛlɛ? Phe. ");
INSERT INTO loq_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ka okyɛkyi kyeka iye? Moto alati bitobu bilaa? Ɓato ɓaalate bitobu bilaa na ɓaali na ezwele ɓaɓe o mangambi ma ɓakonzi. ");
INSERT INTO loq_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ka oombakyi kyɛ kyeka iye, moimisi? Ɛɛ, na wɔ na ɓɛ̀ɛ, yo alekyi na moimosi. ");
INSERT INTO loq_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Phɔ Yoane eli moto ookowɔ buku pha Ŋwaphongo phɔ yɛ ɓoɓo: “Ŋwaphongo awɔ yokye: Namotoma tima ya nga o ɓoo pha wɛ phɔ ya ieɓɔngyisela nzela.” ");
INSERT INTO loq_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Nawɔ na ɓɛ̀ɛ nga kye onte ya ɓato ɓasɔ ɓaaɓotama na ŋwaŋwasi, tewali moto oolekyi Yoane, kasi moto oolekyi ɓokyikyi o Ɓokonzi pha Ŋwaphongo, yo mɔna alekyi Yoane.» ");
INSERT INTO loq_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ɓato ɓasɔ na ɓaphutise ɓa mputi ɓamba mooka, ɓamba ya anola oɓokye Ŋwaphongo ali na ɓosembo, ɓamba ɓatisama na Yoane. ");
INSERT INTO loq_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Kasi ɓafalisayi na ɓateye ɓa miɓeko teɓaika anola yaa zingaka Ŋwaphongo phɔ ya ɓɛ, ɓamba na lɛ iɓatisama na Yoane. ");
INSERT INTO loq_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesu ambakula wɔ yokye: «Ɓato ɓa lɔlɔ eye, naaɓaulinya na nza? ");
INSERT INTO loq_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ɓaulana na ɓana ɓazasi o munsɔngɔ, ɓayɔkɔ ɓawɔ na ɓɛbi na ɓɛ́ɛ ɓɛkye: “Toeyulelesi iphengo, toikyi bina; toetuɓesi meembo ma elesi, ɓɛ̀ɛ toikyi lela!” ");
INSERT INTO loq_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Phɔ Yoane Moɓatise aesi, taaze mapa, taanywe malɛku, ɓɛ̀ɛ ɓɛkye: “Ayeya.” ");
INSERT INTO loq_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ka Ŋwana wa Moto aniyaa, kaze kanywe, ɓɛ̀ɛ ɓɛkye: “Kyeka moto ookoumunya nde izaa na inywa; ali ekamba ya ɓaphutise ɓa mputi na ɓato ɓaa masumu.” ");
INSERT INTO loq_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Kasi zebi silaa sieɓane oka ɓato ɓaasianole.» ");
INSERT INTO loq_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Mofalisayi mɔnɔmɔ amba ya ɓanga Yesu oɓokye akye zaa oka yɛ. Yesu amba ya kyɛndɛ omɔɔ, amba ya zala o mesa. ");
INSERT INTO loq_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ŋwaŋwasi mɔnɔmɔ wa ndumba aɓaka o mokyisi mɛ. Waaoka yo oɓokye Yesu ali o ingambi sa mofalisayi, amba ya na molangyi mɔnɔmɔ ŋwa motiya motondi na malasi. Ɓakyelaka molangyi mɛ na iɓanga siɓangye ɓɛ́ɛ alaɓata. ");
INSERT INTO loq_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Amba ya tɛmɛ o sima ya Yesu, o makolo mɛ. Aɓaka kalele, abuto inyɔbibisa makolo ma Yesu na mbembe yɛ, kambe ikunyola na suwe yɛ, kambe mayamba, amba masweya malasi. ");
INSERT INTO loq_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Waawɛnɛ mofalisayi owa ɓangaka Yesu ɓaɓona, amba miwɔlɛ yokye: «Ɓo moto oyo aɓakyi owaakolo moimosi, nde aeɓi oɓokye ŋwaŋwasi ookomokume oyo ali ndumba.» ");
INSERT INTO loq_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Emba Yesu amba ya wɔ na mofalisayi yokye: «Simo, nali na ŋwana lowɔɔ wa iewɔlɛ.» Simo amba ya wɔ nɛ yokye: «Moteye, wɔɔ.» ");
INSERT INTO loq_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Emba Yesu yokye: «Moto mɔnɔmɔ aɓekyaka ɓato ɓaɓale ɓaphalanga. Mɔnɔmɔ aɓekaka nkama itano ya ɓaphalanga ɓa biɓende, oyɔkɔ aɓekaka makoo matano ma ɓaphalanga ɓa biɓende. ");
INSERT INTO loq_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Kasi waaɓa ɓɛ́ɛ sakoka iita ena mbɔngɔ, amba ɓalimbisa ɓɛ́ɛ ɓasɔ ɓaɓale. Onte ya ɓɛ́ɛ ɓasɔ ɓaɓale, owa molɔɓɔ zinga moto oɓalimbise na mbɔngɔ nza?» ");
INSERT INTO loq_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simo yokye: «Phɔ ya nga, naumunya oɓokye eli olimbise ɓɛ́ɛ na mbɔngɔ enɛnɛ.» Yesu amba wɔ nɛ yokye: «Olongyi.» ");
INSERT INTO loq_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Amba miekpinya oka ŋwaŋwasi mɛ, amba wɔ na Simo yokye: «Owɛni ŋwaŋwasi oyo? Nanyɔsi o ingambi sa wɛ, toikyi mpɛ maa maikunyola makolo. Kasi yo, akunyosi makolo ma nga na mbembe yɛ, ambi ya maɔlɔlɔ na suwe yɛ. ");
INSERT INTO loq_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Toikyi nyangyela, kasi yo, tata oonyɔsi nga wawa, kaina ɓɛɓɛ makolo ma nga. ");
INSERT INTO loq_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Toikyi nsweya malasi o moto, kasi yo, answeye malasi o makolo. ");
INSERT INTO loq_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Yango mɛna nawɔ na wɛ ngakye lozingo lɛ lonɛnɛ oka nga lowɛninye oɓokye masumu mɛ maikye masɔ malimbisami. Kasi ootoikyi ɓɛ́ɛ limbisa na maphɔɔ maɓe maikye, taawɛninya lozingo loikye.» ");
INSERT INTO loq_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Emba Yesu amba ya wɔ na ŋwaŋwasi mɛ yokye: «Masumu ma wɛ malimbisami.» ");
INSERT INTO loq_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ɓaaɓaka ɓaze nɛ ɓabuto imituna ɓɛkye: «Moto oyo ambi ɓa nza phɔ ya ilimbisa na masumu?» ");
INSERT INTO loq_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yesu amba ya wɔ na ŋwaŋwasi mɛ yokye: «Ianola sa wɛ siebikye. Kyɛndɛ na ɓolaa.» ");
INSERT INTO loq_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Sima, Yesu amba kyɛndɛ o nkyisi iinɛnɛ na inkyikyi, kakyɛ miteya na ikyɛ miimola Simo Elaa ya Ɓokonzi pha Ŋwaphongo. Ɓaekosi iko mbuka ɓaɓale ɓakyɛkyɛ mikyɛ nɛ, ");
INSERT INTO loq_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","na ɓaɓasi ɓasuu ɓaabikya yo na malɔɓɔ maɓe na malɔsi. Yaɓaka Maliya, okobangye ɓɛ́ɛ Maliya ma Magadala, owa tɔkɔlɔkɔ ɓɛ́ɛ malɔɓɔ maɓe sambo, ");
INSERT INTO loq_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Zaani ŋwasi wa Kuza, mɔnɔmɔ wa ɓato ɓaakyele etoma na Elode Atipasi, Suzani na ɓasuu ɓaikye, ɓɛ́ɛ ɓasɔ ɓasungaka Yesu na ɓaekosi ɓɛ̀ɛ na mbolo ya ɓɛ. ");
INSERT INTO loq_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ɓato ɓaikye ɓakyɛkyɛ miuta o nkyisi iinɛnɛ ɓa yakaka oka Yesu. Emba Yesu amba ɓakpela ete eye: ");
INSERT INTO loq_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Moto mɔnɔmɔ akyɛkyɛ phika ndemo o inzabi sɛ. Waaɓa yo kakyɛ miphika, ndemo iiyɔkɔ yakaka o nzela. Ɓatambusi ɓaikyiti, manyɔsi ɓaikomosi. ");
INSERT INTO loq_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ndemo iiyɔkɔ yakaka o manyɛtɛ mali na maɓanga, itɔkɔsi, kasi inyiti phɔ teiizwe mpiyɔ. ");
INSERT INTO loq_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ndambo ya ndemo iiyɔkɔ yakaka onte ya milɔ. Nzete ya milɔ ikosi molɔngɔ na ndemo mɛ, kasi milɔ miikyɛtitise. ");
INSERT INTO loq_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ndambo ya ndemo iiyɔkɔ yakaka o manyɛtɛ malaa. Ikosi, iɓoti mbuma mikama na mikama.» Yesu amba kula wɔ yokye: «Ooli na matoo ma ioka, aokye.» ");
INSERT INTO loq_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ɓaekosi ɓa Yesu ɓamba ya motuna ɓɛkye: «Ete mɛna kyelukye iwɔ ɓo?» ");
INSERT INTO loq_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Amba ɓabuyisa yokye: «Ɓɛɛ, Ŋwaphongo aephɛ iyeɓa ɓa sekyele ɓa ɓokonzi phɛ, kasi ɓato ɓaayɔkɔ ɓaokye nde na bite. “Phɔ ɓakyekye kasi teɓaawɛnɛ, ɓaokye kasi teɓaasɔsɔlɔ.”» ");
INSERT INTO loq_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Yesu amba ya wɔ na ɓaekosi ɓɛ́ɛ yokye: «Okyemela ntina ya ete mɛ; ndemo, eli iloɓa sa Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Nzela eli ɓato ɓaaokye Iloɓa. Kasi Zabulu kaye, kaya manya iloɓa o mandondo ma ɓɛ́ɛ phɔ ɓɛ́ɛ saanola, ɓɛ́ɛ saamba na bika. ");
INSERT INTO loq_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Manyɛtɛ maangana na maɓanga, eli ɓato ɓaokye iloɓa sa Ŋwaphongo, ɓa sianole na nkyisa, kasi iloɓa mɛ tesili na nkanga. Ɓaanole ŋwana imbɛlɛ, sima waaye nkaka ɓalɛ sina iloɓa. ");
INSERT INTO loq_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ndemo yaa kaa onte ya milɔ eli Iloɓa sa Ŋwaphongo siokye ɓato, kasi matungyisi, na ezwele na bisɛngɔ ɓa mokyisi kyi ɓaphɛmbya, emba mbuma ya ɓɛ́ɛ kyiukwe nde ɓouko. ");
INSERT INTO loq_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ndemo yaa kaa o manyɛtɛ malaa eli Iloɓa sa Ŋwaphongo siiokye ɓato na ndondo yɔnɔyɔ. Ɓasiɓombe, ɓambe na phila ianola sa ɓɛ́ɛ nɔnɔ waaɓote ɓɛ́ɛ mbuma.» ");
INSERT INTO loq_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","«Moto ɓo alose tala, taaekukya na katini naa taaenyɔsa o se ya ntangye. Kasi kaetɛyɛ o ikolo phɔ ɓato ɓasɔ ɓaanyɔlɔ o ingambi ɓawɛnɛ na ɓolaa. ");
INSERT INTO loq_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Maphɔɔ masɔ maa ɓombama mamowɛnɛnɛ o phaa o minyo ma ɓato, na maphɔɔ ma sekyele mamoeɓana. ");
INSERT INTO loq_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Nde koeɓe na mookyelesi ŋwa ɓɛ̀ɛ ŋwa maphɔɔ! Phɔ, moto ooli na ŋwana epkele ɓaamoɓakyisela. Kasi moto ooli pha, ɓamoɓɔlɔlɔ na ŋwana ndambo oɓakyi nɛ.» ");
INSERT INTO loq_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Nyango wa Yesu na ɓana nyango na Yesu ɓayakaka ya mokyeka. Kasi te ɓaikaka koka ikoma wali yo phɔ ya ɓoikye pha ɓato. ");
INSERT INTO loq_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ɓamba ya imola Yesu oɓokye: «Nyɔngɔ na ɓanaa nyɔngɔ ɓali o iɓanda, ɓazingye iyewɛnɛ.» ");
INSERT INTO loq_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yesu amba ya ɓabuyisa yokye: «Mama na ɓanaa mama eli ɓato ɓa okye iloɓa sa Ŋwaphongo, ɓambe na sikyelela.» ");
INSERT INTO loq_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Mokɔlɔ mɔnɔmɔ Yesu amba ya baa o vato yo na ɓaekosi ɓɛɛ. Amba ya wɔ na ɓɛ̀ɛ yokye: «Tokatisa o mbale ya mokukulu ŋwa maa manɛnɛ muna.» Bamba ya kyɛndɛ. ");
INSERT INTO loq_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Waaɓa ɓɛ́ɛ ɓakatisa, Yesu aesi ya lala ebu. Mbala yɔnɔyɔ, ewɛɛlɛ ekusi etati ikyela o maa maanɛnɛ, maa mabuto inyɔlɔ o vato. Ɓabuto miiwaa. ");
INSERT INTO loq_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ɓaekosi ɓamba ya susinya oli Yesu, bamba moumola ɓɛkye: «Moteye, Moteye, tomowa!» Waaumwa Yesu, amba ya zibisa ewɛɛlɛ na kanda, sakɔkɔ iesi yaema. Maa maamba ya butwa ɓose. ");
INSERT INTO loq_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Yesu amba ya wɔ na ɓaekosi yokye: «Ianola sa ɓɛ̀ɛ sili wa?» Kasi ɓawɛnɛkyɛ ɓɔɔɓɔ, ɓamba kamwa, ɓamba wɔnɔ ɓɛ́ɛ na ɓɛ́ɛ ɓɛkye: «Moto oyo ambi ɓa nza? Kaambya mitindo, na ewɛɛlɛ na maa kyimookye!» ");
INSERT INTO loq_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ɓoɓɛlɛ ɓamba ya koma o mokyisi ŋwa Genesalɛtɛ moli o mokukulu ŋwa maa ma Galileya. ");
INSERT INTO loq_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Waa aɓwa Yesu o vato, moto monɔmɔ wa mokyisi mɛ aesi ya moɓenga. Moto mɛ aɓaka na malɔɓɔ maɓe. Tata kalakala, taalate na bitobu, taaɓe na o ingambi, kasi kaɓe nde o malita. ");
INSERT INTO loq_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Waawɛnɛ moto oli na malɔɓɔ maɓe Yesu, amba ya aŋwana ŋwange, amba yakaa o makolo mɛ, amba ya wɔ na ɓokusi yokye: «Yesu Ŋwana wa Ŋwaphongo owa Ikolo, nga na wɛ lowɔ iye? Na ongye na wɛ, sankyela ɓoɓe!» ");
INSERT INTO loq_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Awɔkɔ ɓaɓona phɔ Yesu awɔkɔ na ɓolɔɓɔ ɓoɓe oɓokye ɓotɔkɔlɔ. Ɓolɔɓɔ phaɓaka ɓomoakya mbala nzikye; emba ɓaɓaka ɓamokangye na munyɔlɔlɔ na maɓɔkɔ na makolo, kasi mbala isɔ aɓaka kabile muna munyɔlɔlɔ, emba ɓolɔɓɔ mɛ phaɓaka ɓomovakye o bokye. ");
INSERT INTO loq_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesu amba ya motuna yokye: «Nkombo ya wɛ nza?» Amba ya anola yokye: «Nkombo ya nga Ɓoikye». Awɔkɔ ɓaɓona phɔ malɔɓɔ maɓe maikye mamunyɔlɔkɔ. ");
INSERT INTO loq_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Malɔɓɔ mɛ mamba nyingonela na Yesu mɛkye: «Salovaka o iɓela siinɛnɛ siizindo!» ");
INSERT INTO loq_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Yaɓaka wamɔ ɓokanda ɓonɛnɛ pha mangulu maɓaka makyɛ miluka ntoma ya izaa o ngomba. Malɔɓɔ maɓe mɛ mamba ya wɔɔ na Yesu oɓokye: «Ololɛ tonyɔlɔ o mangulu mama!» Yesu amba maanolela. ");
INSERT INTO loq_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Mbala yɔnɔyɔ malɔɓɔ maɓe mambatɔlɔ oka moto mɛ mambakyɛ nyɔlɔ o mangulu. Ɓokanda pha mangulu ɓosɔ phaamba ya uta o ikolo sa ngomba nɔnɔ wakyɛ phango mivaka o ebale nɔnɔ waazinda mango. ");
INSERT INTO loq_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Waawɛnɛ ɓaɓanze ɓa ɓokanda pha mangulu lowɔɔ lolekaa, ɓamba ya lota mambangu, ɓamba kyɛ imola simo mɛ o Genesalɛtɛ na o nkyisi yaa mambale. ");
INSERT INTO loq_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ɓato ɓamba ya kyɛ kyeka lowɔɔ loolekaa. Waakoma ɓɛ́ɛ waali Yesu, ɓamba ya zwa moto ootɔkɔsi ɓɛ́ɛ malɔɓɔ maɓe azasi o makolo ma Yesu, alati bitobu, abuto na ɓolaa. Emba ɓato ɓamba iila. ");
INSERT INTO loq_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ɓaawɛnɛkyɛ masɔ malekaa, ɓamba ya imola ɓɛbi ndenge ebikyi moto ooɓakyi na malɔɓɔ maɓe. ");
INSERT INTO loq_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Emba ɓato ɓasɔ ɓa Genesalɛtɛ ɓamba ya onga na Yesu oɓokye amane o mokyisi ŋwa ɓɛ́ɛ phɔ ɓaɓaka na ɓɔɔɓɔ. Yesu amba ya kpela o vato nɔnɔ waabutwa yo. ");
INSERT INTO loq_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Moto owatɔkɔlɔkɔ ɓɛ́ɛ malɔɓɔ maɓe amba onga na Yesu yokye: «Ɓo ozingyi, lɛ nakyɛndɛ na wɛ!» Kasi Yesu amba wɔ nɛ yokye: ");
INSERT INTO loq_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«Ɓutwa oka ya wɛ! Kyɛ imola isɔ ikyesi Ŋwaphongo phɔ ya wɛ!» Ɓoɓɛlɛ moto mɛ amba ya kyɛ mimola o mokyisi munsɔ maphɔɔ maakyesi Yesu phɔ yɛ. ");
INSERT INTO loq_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Waabutwa Yesu o mokukulu moyɔkɔ ŋwa maa maanɛnɛ, ɓato ɓaikye ɓamba ya moyamba phɔ ɓaɓaka ɓamoziya. ");
INSERT INTO loq_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Moto monɔmɔ nkombo yɛ Yailo, mokonzi ŋwa ingambi sa makyita, amba ya mivaka o makolo ma Yesu aesi ya onga Yesu oɓokye aye o ingambi sɛ. ");
INSERT INTO loq_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Phɔ ŋwana wɛ nde mɔnɔmɔ wa ŋwanwsi, wa mbula iko mbuka iɓale ali nde mowe. Waaɓa Yesu kakyɛndɛ omɔ, ɓato ɓaikye ɓa mokatitisaka mboka esɔ sa ɓɔngɔ itambula. ");
INSERT INTO loq_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ŋwaŋwasi mɔnɔmɔ owa ɓolɔsi pha malongo aɓaka wamɔ. Mbula iko mbuka iɓale malongo maɓaka mamotɔkɔlɔ nde ɓotɔkɔsi satenya. Aunvaka mbolo yɛ isɔ yaaɓaka nɛ phɔ ya iphuta ɓa muunganga, kasi na moto monɔmɔ taika koka imobikya. ");
INSERT INTO loq_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Amba yaa o sima ya Yesu, aesi yakuma sɔngyɛ ya etobu ya Yesu, mina wamɔ, malongo maesi ya tenya. ");
INSERT INTO loq_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesu amba yatuna yokye: «Oonkumi nza?» Ɓasɔ ɓamba anola ɓɛkye ɓanga phe. Petelo amba ya wɔ na Yesu yokye: «Moteye, eli ɓato ɓaikye ɓaaezingyi, ɓaa ekatitise.» ");
INSERT INTO loq_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Kasi Yesu yokye: «Moto monɔmɔ ankumi, phɔ naokyi phɛmbɔ etɔkɔsi o nzoto ya nga.» ");
INSERT INTO loq_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ŋwaŋwasi aesi ya wɛnɛ oɓokye ɓamoebi. Na itɛkyɛnɛlɛ sisɔ, amba ya kyɛ mivaka o makolo ma Yesu. O ɓoo pha ɓato ɓasɔ amba ya moimola ntina eemokumi nɛ na ɓoobikyi yo. ");
INSERT INTO loq_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesu amba ya wɔ nɛ yokye: «Ŋwana wa nga, ianola sa wɛ siebikye, kyɛndɛ na ɓolaa.» ");
INSERT INTO loq_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Waaɓa Yesu kawɔ ɓaɓona, moto monɔmɔ ambauta o ingambi sa Yailo, mokonzi ŋwa ingambi sa makyita. Amba ya wɔ nɛ oɓokye: «Ŋwana wa wɛ wa waŋwasi awee, sakula tungyisa Moteye» ");
INSERT INTO loq_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Kasi Yesu aɓaka kamookye ɓoko wɔɔ yo. Amba wɔ na Yailo yokye: «Saila, ɓa nde na ianola, ŋwana wa wɛ amobika.» ");
INSERT INTO loq_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Waakoma Yesu o ingambi sa Yailo, taikaka anola oɓokye ɓato ɓasuu ɓanyɔlɔ nɛ, manya nde Petelo, Yoane, Zake na ango na nyango wa ŋwana. ");
INSERT INTO loq_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ɓato ɓasɔ ɓaɓaka ɓalele na imiima phɔ ya ŋwana. Emba Yesu amba ya wɔ na ɓɛ́ɛ yokye: «Ɓɛ̀ɛ salela! Taikyi waa, alasi nde ebu.» ");
INSERT INTO loq_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Kasi ɓato ɓamba moɛkyɛ. Phɔ ɓaeɓaka oɓokye ŋwana ambo waa. ");
INSERT INTO loq_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Kasi Yesu amba mophila o eɓɔkɔ, amba aŋwana yokye: «Ŋwana, iŋwa!» ");
INSERT INTO loq_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ŋwana akuli butwa na ɓomɔɔ, aesi ya uŋwa. Emba Yesu amba ya wɔ na ɓɛ́ɛ oɓokye ɓamophɛ ntoma ya izaa. ");
INSERT INTO loq_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ɓaɓoti ɓa ŋwana ɓakamwaka na ɓoikye kasi Yesu amba ɓakatela oɓokye ɓɛ́ɛ saimola na moto maphɔɔ maalekaa. ");
INSERT INTO loq_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu amɓa ya angyinya ɓaekosi iko mbuka ɓaɓale. Amɓa ya ɓaphɛ mwiya na ɓokonzi pha itɔkɔlɔ malɔɓɔ masɔ maɓe na ibikya malɔsi. ");
INSERT INTO loq_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Sima, amba ɓatoma ikyɛ mimola Ɓokonzi pha Ŋwaphongo na ikyɛ mibikya ɓato ɓa malɔsi. ");
INSERT INTO loq_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Amɓa ya wɔ na ɓɛ́ɛ yokye: «Ookokyɛ ɓɛ̀ɛ o imbanga, saphila ekpele na yɔnɔyɔ: Eɓe motuu, eɓe ikuɓa, eɓe ntoma, eɓe na ɓaphalanga. Moto na mɔnɔmɔ saphila ɓasimisi ɓaɓale. ");
INSERT INTO loq_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ɓo ɓaeyamɓi o ingamɓi sɔnɔsɔ, oɓee nde wamɔ tee nɔnɔ waamumana ɓɛ̀ɛ o mokyisi mɛ. ");
INSERT INTO loq_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ka ɓo ɓato ɓa mokyisi mɔnɔmɔ teɓaeyamɓi, mana o mokyisi mɛ, lasa mobulubutu ŋwa mokyisi ŋwa ɓɛ́ɛ mooli o matambe ma ɓɛ̀ɛ phɔ ya iɓawɛninya oɓokye ɓakyesi ɓoɓe.» ");
INSERT INTO loq_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Emɓa ɓaekosi ɓamɓa ya kyɛmdɛ, ɓaesi ya lekana o nkyisi isɔ ikyɛ miimola Simo Elaa na ikyɛ mibikya ɓato ɓa malɔsi. ");
INSERT INTO loq_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Mokonzi Elode aokaka maphɔɔ masɔ malekane. Malondo mambaunva nɛ. Phɔ ɓato ɓakyi ɓawɔkɔ phɔ ya Yesu oɓokye: «Eli Yoane Moɓatise akundoo.» ");
INSERT INTO loq_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Bana ɓɛkye: «Eli Eliya atɔkɔsi!» Baayɔkɔ ɓɛkye: «Eli mɔnɔmɔ na ɓaimosi ɓa Ŋwaphongo akundoo!» ");
INSERT INTO loq_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Kasi Elode yokye: «Yoane, nga mampenza namotena moto. Kasi moto ookokule oka nga na ngambo esɔ oyo nza?» Yango mɛna Elode alukaka iwɛnɛ Yesu. ");
INSERT INTO loq_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Waaya butwa ɓɛ, ɓatoma ɓamba ya imola Yesu maphɔɔ masɔ maakyelaka ɓɛ. Yesu amba ya kyɛ na ɓɛ́ɛ o mokyisi mooɓangye ɓɛ́ɛ Ɓetesaida. ");
INSERT INTO loq_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Kasi waaeɓa ɓato oɓokye akyɛ, ɓato ɓaikye ɓamba moɓenga. Yesu amba ɓayamɓa, amba butwa iɓawɔlɛ phɔ ya Ɓokonzi pha Ŋwaphongo na ibikya ɓaɓaka na phowa ya ibika. ");
INSERT INTO loq_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Wa tata ikoma nkɔkɔlɔ, ɓatoma iko mbuka ɓaɓale ɓamba ya wali Yesu ɓaesi ya wɔ nɛ oɓokye: «Ɓuya ɓato ɓasɔ phɔ ɓakyɛndɛ o nkyisi yaa mambale na oka ɓato ɓaali o manzabi, phɔ ɓakyɛ luka bilangyi na ntoma ya izaa. Phɔ wawa toli mi elele ya bokye.» ");
INSERT INTO loq_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Kasi Yesu amba ya wɔ na ɓɛ́ɛ yokye: «Bɛ̀ɛ mampenza o ɓaphɛ ntoma ya izaa.» Ɓaekosi ɓɛkye: «Toli nde na mapa matano na swe iɓale ɓoɓɛlɛ. Ozingyi oɓokye tokyɛ omba ntoma ya izaa phɔ ya ɓato ɓasɔ ɓaɓa?» ");
INSERT INTO loq_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ɓampele phɛnɛphɛ nkoto itano ɓaɓaka wamɔ. Yesu amba ya wɔ na ɓaekosi yokye: «Oɓazasa biɓoko biɓoko ɓa ɓato mako matano matano.» ");
INSERT INTO loq_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ɓaekosi ɓamba kyela nde ɓomɔ, ɓamba zasa ɓato ɓasɔ. ");
INSERT INTO loq_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yesu amba ya kpa mana mapa matano na swe iɓale. Amba ya tomba miyo o ikolo, apambosi mapa na ina swe. Amba ya makyɛsɛ, amba ya phɛ ɓaekosi ɓɛ̀ɛ phɔ ɓakaɓele ɓato. ");
INSERT INTO loq_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ɓato ɓasɔ ɓamba zaa, ɓamba oka. Ɓamba ɔngɔ bikyɛsi bya otwaka ɓɛ, ɓamba tonza ɓanyanzima iko mbuka ɓaɓale. ");
INSERT INTO loq_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Mokɔlɔ mɔnɔmɔ Yesu na ɓaekosi ɓɛ́ɛ ɓakyɛkyɛ ɓɔndɛlɛ o elele yɔnɔyɔ ya indende. Yesu amba ya ɓatuna yokye: «Ɓato ɓawɔɔ oɓokye nga nali nza?» ");
INSERT INTO loq_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ɓaekosi ɓamba ya moɓuyisa ɓɛkye: «Ɓakyi ɓawɔ ɓɛkye: “Iwɛ Yoane Moɓatise, ɓana ɓɛkye: Iwɛ Eliya, ɓaayɔkɔ ɓane wɔ ɓɛkye: Iwɛ oli mɔnɔmɔ na ɓaimosi ɓa Ŋwaphongo ɓaa phanza akundoo.”» ");
INSERT INTO loq_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Yesu amba ya ɓatuna yokye: «Ka ɓɛ̀ɛ, kowɔ oɓokye nga nali nza?» Petelo amba ya buya yokye: «Iwɛ oli Masiya owa lotomela Ŋwaphongo.» ");
INSERT INTO loq_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yesu amba ɓakatela na ɓokusi oɓokye ɓɛ́ɛ saloimola na moto. ");
INSERT INTO loq_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Emba Yesu amba ya ɓakyisa yokye: «Nwama wa Moto asengyesi ioka ɓolɔsi ɓoikye. Ɓankumu, ɓakonzi ɓa ɓanganga ɓa Ŋwaphongo na ɓateye ɓa miɓeko ɓaamolɛɛ. Ɓaamoɓoma. Kasi o sima ya nkɔlɔ iyato, amokundwa.» ");
INSERT INTO loq_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Sima, Yesu amba ya wɔ na ɓato ɓasɔ yokye: «Ɓo moto kazingye imbenga, alɛɛ iumunya phɔ ya nzoto yɛ, anyanya ekulusu yɛ mokɔlɔ na mokɔlɔ ambe mbenga. ");
INSERT INTO loq_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Phɔ, moto ozingyi ibikya ɓomɔɔ phɛ aaɓobungya. Kasi moto owa mobungya ɓomɔɔ phɛ phɔ ya nga aaɓobikya. ");
INSERT INTO loq_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ɓo moto azwe ezwele ya mokyisi munsɔ, kasi ɓo ambi bungya ɓomɔɔ phɛ naa ani ɓoɔtɔ yo mampenza, amozwa itomba iye? ");
INSERT INTO loq_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ɓo moto kaokye sɔɔ phɔ ya nga na phɔ ya maloɓa ma nga, inga Ŋwana wa Moto, na nga namooka sɔɔ phɔ yɛ mɛ, waamoya nga na nkyɛmɔ ya nga, na eyaaka Tata na eyaaka ɓanze ɓasantu. ");
INSERT INTO loq_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nde phɛlɛ na wɔ na ɓɛ́ɛ ngakye ɓana o nte ya ɓɛ̀ɛ ɓali wawa ete ɓawe phanza saika wɛnɛ Ɓokonzi pha Ŋwaphongo.» ");
INSERT INTO loq_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Nkɔlɔ ŋwambi sima ya maphɔɔ mamana Yesu amba ya kpa Petelo, Yoane na Zake amba ya baa na ɓɛ́ɛ o ikolo sa ngomba phɔ ya iɓɔndɛlɛ. ");
INSERT INTO loq_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Waaɓa Yesu kaɓɔndɛlɛ, ɓoo phɛ phamba ya butwa ndengye esuu, na bitobu ɓɛ́ɛ bamba ya butwa bitane pɛɛpɛ. ");
INSERT INTO loq_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Mbala yɔnɔyɔ, ɓato ɓaɓale ɓabutwaka ɓasolole na Yesu, yaɓaka: Mose na Eliya, ");
INSERT INTO loq_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ɓaɓawɛnɛkyɛ ɓalungami na nkyɛmɔ eya ikolo. Mose na Eliya ɓaɓaka ɓawɔnɔ na Yesu phɔ ya mowesi ŋwa mokyɛ yo waa o Yelusalɛmɛ. ");
INSERT INTO loq_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petelo na ɓɛbi nɛ ɓawaka na eɓuu. Waaumwa ɓɛ, ɓamba ya wɛnɛ nkyɛmɔ ya Yesu na ɓato ɓaɓale ɓaɓaka ɓatɛmi nɛ. ");
INSERT INTO loq_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Imbɛlɛ saluka Mose na Eliya iika Yesu, Petelo amba ya wɔ na Yesu yokye: «Moteye, eli ɓolaa oɓokye toikale wawa. Tomotonga ndalaku iyato: Mɔnɔmɔ phɔ ya wɛ, mɔnɔmɔ phɔ ya Mose, mɔnɔmɔ phɔ ya Eliya.» Kasi Petelo taikaka eɓa yaaɓaka yo ka wɔɔ. ");
INSERT INTO loq_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Waaɓa Petelo kawɔ ɓaɓona, ipata sɔnɔsɔ siesi ya ɓaziɓa. Waa ɓaziɓa impata, ɓaekosi ɓawɛnɛkyɛ ɓɔɔɓɔ. ");
INSERT INTO loq_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Uta o ipata, ŋwɛsi mɔnɔmɔ ŋwaokanaka mowɔ oɓokye: «Oyo ali Ŋwana wa nga, oɔsi nga, omookye!» ");
INSERT INTO loq_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Waaunva iokana ŋwɛsi mamuna, ɓawɛni Yesu nde yo mampenza. Ɓaekosi ɓaesi ya ikala ɓose, mi nkɔlɔ mɛ, teɓaikaka imola na moto maphɔɔ maawɛnɛkyɛ ɓɛ. ");
INSERT INTO loq_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Sima ya mokɔlɔ mɔnɔmɔ, Yesu na ɓaekosi ɓɛ́ɛ ɓaato ɓamba ya uta ngomba. Moluku ŋwa ɓato moikye ŋwaamba yakyɛ vana nɛ. ");
INSERT INTO loq_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","O nte ya moluku ŋwa ɓato ɓaɓana, moto mɔnɔmɔ aɓaka kaaŋwane yokye: «Moteye, naeɓɔndi, okyekye ŋwana wa nga wa lele, phɔ ali ŋwana wa nga nde yo mɔnɔmɔ! ");
INSERT INTO loq_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Mbala nzikye ɓolɔɓɔ ɓoɓe ɓomoakya, ŋwana kabutwe iaŋwana, ɓomunyingyinya na ɓokusi, kabutwe itɔkɔlɔ luulu o munɔkɔ, ɓomunyɔkɔlɔ emba teɓoomane nɛ ɓomanɛla. ");
INSERT INTO loq_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Naongakyi na ɓaekosi ɓa wɛ oɓokye ɓatɔkɔlɔ ɓolɔɓɔ mɛ, kasi teɓaikyi ɓokoka.» ");
INSERT INTO loq_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesu amba ya wɔ yokye: «Ɓɛɛ ɓato ɓaɓe na ɓaazanga ianola. Nasengyesi iɓa na ɓɛ̀ɛ na ikanga motema phɔ ya ɓɛ́ɛ tee nɔnɔ imbɛlɛ iye?» Emba amba ya wɔ na moto mɛ yokye: «Yaka na ŋwana wa wɛ wawa.» ");
INSERT INTO loq_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Waakoma ŋwana phɛnɛphɛ na Yesu, ɓolɔɓɔ ɓoɓe phaamba movaka o se, phaamba munyingyinya na ɓokusi. Kasi Yesu amba ya phaphala na ɓolɔɓɔ ɓoɓe mɛ, amba bikya ŋwana, emba amba moɓuyisa ango. ");
INSERT INTO loq_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ɓato ɓasɔ ɓamba kamwa na ɓonɛnɛ pha Ŋwaphongo. Waaɓa ɓato ɓasɔ ɓakamwe na masɔ makyele Yesu, Yesu amba ya wɔ na ɓaekosi ɓɛ́ɛ yokye: ");
INSERT INTO loq_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Oka na ɓolaa maphɔɔ mamoewɔlɛ nga uŋwaŋwa eye: Ɓamoungya Ŋwana wa Moto o maɓɔkɔ ma ɓato.» ");
INSERT INTO loq_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Kasi ɓaekosi teɓaikaka eɓa ntina ya maphɔɔ mamana. Mayɛlɛ ma ɓɛ́ɛ temaikaka ingwa phɔ ya isɔsɔlɔ, ɓambaka na lota ituna Yesu ntina ya lowɔɔ mɛ. ");
INSERT INTO loq_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Mokɔlɔ mɔnɔmɔ, ɓaekosi ɓamba yaika ziko phɔ ya iyeɓa nza oolekyi ɓɛbi na ngambo. ");
INSERT INTO loq_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesu aeɓaka maumunya ma ɓɛ. Amba ya kpa ŋwana mɔnɔmɔ oo mokyɛ, amba ya motɛyɛ phɛnɛphɛ nɛ. ");
INSERT INTO loq_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Amba ya wɔ na ɓɛ́ɛ yokye: «Owa moyamba ŋwana oyo na nkombo ya nga, mɛna anzambi nga mampenza. Ka oonzambi, ayambi na moto owa ntoma. Phɔ oolekyi mokyɛɛ onte ya ɓɛ́ɛ ɓasɔ, yo mɔnɔ oolekyi na ngambo.» ");
INSERT INTO loq_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yoane amba ya wɔ na Yesu yokye: «Moteye, towɛni moto mɔnɔmɔ katɔkɔlɔ malɔɓɔ maɓe na nkomɓo ya wɛ. Tounvakyi mokatela phɔ taeɓengye na ɓanga.» ");
INSERT INTO loq_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Kasi Yesu amba ya mobuyisela yokye: «Samokatela, phɔ otoo eyine ali mbale na ɓɛ.» ");
INSERT INTO loq_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Waakoma imbɛlɛ sa Yesu sa imana o mokyisi mumu phɛnɛphɛ, amba ya kana ita kyɛndɛ o Yelusalɛmɛ. ");
INSERT INTO loq_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Amba ya toma ɓatima phanza. Ɓamba ya kyɛndɛ o mokyisi mɔnɔmɔ ŋwa Samaliya phɔ ya ikyɛ ɓɔngya iyaa sɛ. ");
INSERT INTO loq_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Kasi ɓato ɓa mokyisi mɛ ɓa lɛkyɛ imoyamba phɔ kaya kyɛndɛ o Yelusalɛmɛ. ");
INSERT INTO loq_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Waawɛnɛ Zake na Yoane ɓaɓona, ɓamba ya wɔ na Yesu ɓɛkye: «Nkolo, ozingyi oɓokye totome nkakye eute o ikolo eɓakpelemele ɓaunve?» ");
INSERT INTO loq_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Kasi Yesu amba ya ekpana bili ɓɛ, amba ɓakatela na ɓokusi. ");
INSERT INTO loq_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Emba ɓamba ya kyɛndɛ o mokyisi mosuu. ");
INSERT INTO loq_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Waaɓa ɓɛ́ɛ o nzela, moto mɔnɔmɔ amba ya wɔ na Yesu yokye: «Namoeɓenga mbale esɔ eya mokyɛmikyɛ wɛ.» ");
INSERT INTO loq_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu amba ya mobuyisa yokye: «Manzumbu mali na bikakala, manyɔsi ma ikolo mali na mooɓo; ka Ŋwana wa Moto tali na ná elele ya ilangya moto.» ");
INSERT INTO loq_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yesu amba ya wɔ na moto mosuu yokye: «Imbengye!» Kasi moto mɔna amba ya moɓuyisa yokye: «Taandɛ nataa kyɛ kunda tata.» ");
INSERT INTO loq_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesu amba ya moɓuyisa yokye: «Lɛ ɓawe ɓakunde ɓawee ɓa ɓɛ; kasi iwɛ, kyɛndɛ kyɛ imola Ɓokonzi pha Ŋwaphongo.» ");
INSERT INTO loq_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Moto mosuu amba kula ya wɔɔ na Yesu yokye: «Nkolo, namoeɓenga; kasi tandɛ nakyɛ wɛnɛnɛ mbala eya suka na iɓota sa nga.» ");
INSERT INTO loq_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesu amba ya wɔ nɛ yokye: «Moto ombo tata ikyela o inzabi, ɓo akuli buya miyo na munsima yo mɔna taika kyelama phɔ ya Ɓokonzi pha Ŋwaphongo.» ");
INSERT INTO loq_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Sima ya maphɔɔ mɛ, Nkolo Yesu amba kula ya ɔlɔ ɓato ɓasuu mako sambo mbuka ɓaɓale. Amba ya ɓatoma ɓaɓale ɓaɓale o ɓoo o nkyisi yaamokyɛ mikyɛ yo. ");
INSERT INTO loq_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Amba wɔ na ɓɛ́ɛ yokye: «Mbuma ya inɔkɔ ili nzikye o inzabi, kasi ɓato ɓaetoma teɓali ɓaikye. Onga na mokolo inzabi atome ɓato ɓaetoma ɓaikye phɔ ɓaya munɔkyɛlɛ mbuma. ");
INSERT INTO loq_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Kyɛndɛ! Naetomi ndokolo mampate o nte ya mangɔɔ. ");
INSERT INTO loq_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Saphila ɓaphalanga, eɓe ikuɓa, eɓe bikoto. O nzela, sakyɛmitɛmɛ phɔ ya iphɛ ɓato mambotɛ. ");
INSERT INTO loq_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Waamunyɔlɔ ɓɛ̀ɛ o ingambi sɔnɔsɔ, kota wɔ phanza ɓoɓo: “Ɓose ɓo ɓee o ingambi sisi!” ");
INSERT INTO loq_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ɓo moto wa ɓose ali wamɔ, ɓose pha ɓɛ̀ɛ phamoikala nɛ, ka ɓo moto wa ɓose tali, ɓose pha ɓɛ̀ɛ phamoebutolela. ");
INSERT INTO loq_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ɓa nde o ingambi mɛ, za ombe na nywa isɔ yaamoephɛ ɓɛ. Phɔ moto wa etoma asengyesi izwa iphuti sɛ. Sakula kyɛluka iɓa ɓabutu o mangambi masuu. ");
INSERT INTO loq_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Waamunyɔlɔ ɓɛ̀ɛ o mokyisi mɔnɔmɔ, ɓo ɓato ɓa mokyisi mɛ ɓaeyambi, zaa yaa moephɛ ɓɛ. ");
INSERT INTO loq_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Bikya ɓato ɓa malɔsi ɓali omɔ, emba wɔ na ɓato ɓasɔ oɓokye: “Uŋwaŋwa eye Ɓokonzi pha Ŋwaphongo ɓoekomesi oli ɓɛ!” ");
INSERT INTO loq_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Kasi waamunyɔlɔ ɓɛ̀ɛ o mokyisi mɔnɔmɔ, ɓo ɓato ɓa mokyisi mɛ te ɓaeyambi, tɔkɔlɔ o musɔngɔ owɔ na ɓato mɛ oɓokye: ");
INSERT INTO loq_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Tolasee mobulubutu ŋwa mokyisi ŋwa ɓɛ́ɛ mooɓandemakyi o matambe ma ɓanga, toeyikyesi ŋwango. Oombe nde eɓa oɓokye Ɓokonzi pha Ŋwaphongo ɓokomi phɛnɛphɛ.” ");
INSERT INTO loq_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nawɔ na ɓɛ̀ɛ nga kye mokɔlɔ ŋwaa mosambisa Ŋwaphongo ɓato, etumbu ya mokyisi maamuna yamoleka eya Sodɔmɔ.» ");
INSERT INTO loq_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","«Ngɔngɔ ya wɛ mokyisi ŋwa Kolazina, ngɔngɔ ya wɛ mokyisi ŋwa Ɓetesaida! Phɔ bilekyesako bakyelaka nga oka ɓɛ̀ɛ, ɓo na bikyelaka nde o Tula na o Sidona, ɓato ɓa nkyisi mɛ nde ɓaunva lata mangɔtɔ, nde ɓamiinga mbutu phɔ ya iwɛninya oɓokye ɓa ɓɔngyɛɛ moɓesi ŋwa ɓɛ. ");
INSERT INTO loq_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Yango mɛna mokɔlɔ ŋwa mosambisa Ŋwaphongo ɓato, etumbu ya ɓɛ̀ɛ yamoleka eyaaka Tula na Sidona. ");
INSERT INTO loq_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Na wɛ, mokyisi ŋwa Kapalanauma, koumunya oɓokye wamo ɓaa nɔnɔ o ikolo? Wamouta nɔnɔ o mokyisi ŋwa ɓawee.» ");
INSERT INTO loq_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yesu ambakula ya wɔ na ɓaekosi ɓɛ́ɛ yokye: «Moto okoeyokye, kanzokye; moto okoelɛ, kandɛ; ka moto okondɛ, kalɛ Yo owantoma.» ");
INSERT INTO loq_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ɓoɓɛlɛ, ɓaekosi mako sambo mbuka ɓaɓale ɓamba ya butwa na nkyisa ɓoikye ɓɛkye: «Nkolo, na malɔɓɔ maɓe malookye wa phaphale ɓanga na mango na nkombo ya wɛ.» ");
INSERT INTO loq_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesu amba ya ɓabuyisa yokye: «Nawɛnɛkyɛ Molemba kabiya, kaute o ikolo ndokolo munkakasi. ");
INSERT INTO loq_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Okyemela, naephɛkyɛ ɓokonzi pha ikyita manzɔɔ na maphalakasa saekyela ekpele, na unva ɓokusi ɓosɔ pha munguna. Ekpele yɔnɔyɔ teekokyi iekyela ɓoɓe. ");
INSERT INTO loq_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Kasi ɓɛ̀ɛ sa kumba phɔ malɔɓɔ maɓe maeyokye, kumba nde phɔ Ŋwaphongo akoma mankombo ma ɓɛ̀ɛ o ikolo.» ");
INSERT INTO loq_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Imbɛlɛ mɛ, Yesu atondi na nkyisa ya Ɓolɔɓɔ Ɓosantu, amba ya wɔ yokye: «Tata, Nkolo wa ikolo na munse, naephɛ mɛlɛsi phɔ ya maphɔɔ maɓombela wɛ ɓato ɓa malondo na ɓaaekola, omawɛninye oka ɓato ɓaate ɓali na ngambo. Phɛlɛ, Tata, wazinga oɓokye waɓee ɓaabona. ");
INSERT INTO loq_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Tata aambya maphɔɔ masɔ o maɓɔkɔ ma nga. Moto na mɔnɔmɔ taeɓe Ŋwana ɓo teeɓe Tata, eɓe moto takokyi eɓa Tata ɓo teeɓe Ŋwana na ɓaazingyi ŋwana iɓawɛninya ɓooli Tata.» ");
INSERT INTO loq_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Emba Yesu amba ya miekpinya oka ɓaekosi ɓɛ̀ɛ, amba ya wɔɔ na ɓɛ́ɛ nde ɓɛ́ɛ mampenza yokye: «Nkyisa ili na miyo mawɛnɛ maphɔɔ maawɛnɛ ɓɛ! ");
INSERT INTO loq_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Phɔ na wɔ na ɓɛ̀ɛ ngakye, ɓaimosi ɓaikye, ɓakonzi ɓaikye, ɓazingaka iwɛnɛ maphɔɔ maawɛnɛ ɓɛ̀ɛ mama, kasi teɓaika mawɛnɛ, na iyoka maphɔɔ maokye ɓɛ̀ɛ mama kasi teɓaika maoka.» ");
INSERT INTO loq_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Moteye wa miɓeko mɔnɔmɔ amba ya tɛmɛ phɔ ya imeka Yesu. Amba ya motuna yokye: «Moteye, nakyele ɓo phɔ nazwe ɓomɔɔ pha ɓoɓɛlɛ?» ");
INSERT INTO loq_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesu amba mobuyisa yokye: «O moɓeko ɓakoma ɓo? Kotangye omɔ ɓo?» ");
INSERT INTO loq_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Moto mɔna amba mobuyisa yokye: «Osengyesi izinga Ŋwaphongo Nkolo wa wɛ, na ndondo yɔnɔyɔ, na molimo ŋwa wɛ munsɔ, na ɓokusi pha wɛ ɓosɔ na ná maumunya ma wɛ masɔ, ombe na zinga nwɛbi na wɛ ɓookomizingye wɛ mampenza.» ");
INSERT INTO loq_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesu amba wɔ nɛ oɓokye: «Obuye na ɓolaa. Kyela nde ɓomɔɔ wamobika.» ");
INSERT INTO loq_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Kasi moteye wa miɓeko alukaka imilongya, amba tuna Yesu yokye: «Nwɛbi na nga nza?» ");
INSERT INTO loq_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesu amba mobuyisa yokye: «Moto mɔnɔmɔ kaute o Yelusalɛmɛ kakyɛndɛ o Yeliko. Aesi ya kyɛ kaa o maɓɔkɔ ma ɓaibi, ɓaesi ya moɓɔlɔlɔ mbolo yɛ isɔ, ɓamokutibi nzi, ɓakyɛɛ, ɓaikyi moika nde mowe. ");
INSERT INTO loq_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Sakɔkɔ, nganga ya Ŋwaphongo mɔnɔmɔ aesi yalekana wamɔ. Waawɛnɛ yo moto mɔna, aɓandi mopha ŋwa nzela moyɔkɔ, alekaa. ");
INSERT INTO loq_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Molewi mɔnɔmɔ nde ɓomɔ, aesi yakoma o elele mɛ, awɛni moto mɛ, aɓandi mopha ŋwa nzela mooyɔkɔ, alekaa. ");
INSERT INTO loq_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Kasi Mosamaliya mɔnɔmɔ aesi yalekana nɛ minzela mɛ. Waawɛnɛ yo moto owakutuɓaka ɓaibi, amookyesi ngɔngɔ. ");
INSERT INTO loq_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Asusinye phɛnɛphɛ nɛ, amosweye mauta na malɛku o maphota nɔnɔ wa mokanga yo na bitato ɓa bitobu. Sima, amba mokpesa o ikolo sa punda yɛ, amba kyɛ nɛɛ o ingambi sa ɓabutu, omɔ, abuto imosalisa. ");
INSERT INTO loq_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Waa yɛ bunya, Mosamaliya aesi ya tɔkɔlɔ biɓende ɓaɓale ɓaɓaphalanga, aesi ya biphɛ mokolo ingambi, amba wɔ nɛ yokye: “Ɓanza moto oyo na ɓolaa. Ɓo otɔkɔsi ɓaphalanga ɓasuu phɔ ya imosalisa, namoya ebuyisa ɓɛ́ɛ wamoya lekana nga wawa.”» ");
INSERT INTO loq_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yesu amba ya tuna moteye wa miɓeko yokye: «Phɔ ya wɛ, onte ya ɓato ɓaato ɓaɓana, oomiteye nwɛbi wa moto owakaaka o maɓɔkɔ ma ɓaibi nza?» ");
INSERT INTO loq_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Moteye wa miɓeko yokye: «Eli moto owamookyelaka ngɔngɔ.» Emba Yesu amba ya wɔ nɛ yokye: «Kyɛndɛ, na wɛ o kyɛ kyela ɓomɔ.» ");
INSERT INTO loq_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Waaɓa Yesu na ɓaekosi ɓɛ̀ɛ o nzela, amba ya nyɔlɔ o mokyisi mɔnɔmɔ. Ŋwaŋwasi mɔnɔmɔ aɓaka omɔ nkombo yɛ Malata, amba moyamba o ingambi sɛ. ");
INSERT INTO loq_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Yo aɓaka na ŋwana nyango wa ŋwaŋwasi nkombo yɛ Maliya, owa zalaka phɛnɛphɛ na makolo ma Nkolo phɔ ya iyoka mateya mɛ. ");
INSERT INTO loq_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Malata amitungyisaka na ɓoikye phɔ ya bitoma. Mbala yɔnɔyɔ amba ya wɔɔ na Yesu yokye: «Nkolo, toowɛnɛ ɓoɓe ɓoondɛsi ŋwana mama bitoma bisɔ nga mampenza? Wɔ nɛ aya nsunga.» ");
INSERT INTO loq_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Nkolo amba mobuyisa yokye: «Malata, Malata, komitungyisa na ikyɛmimiima phɔ ya maphɔɔ maikye, ");
INSERT INTO loq_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","kasi nde lowɔɔ lɔnɔlɔ looli na ntina enɛnɛ. Maliya aɔsi iyalo sɔnɔsɔ siilekyi ɓolaa, na moto mɔnɔmɔ etaamoɓɔlɔlɔ sango.» ");
INSERT INTO loq_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Mokɔlɔ mɔnɔmɔ Yesu aɓaka o elele yɔnɔyɔ kaɓɔndɛlɛ. Waunva yo, mɔnɔmɔ na ɓaekosi ɓɛ́ɛ amba ya wɔ nɛ yokye: «Nkolo, oleteya iɓɔndɛlɛ ɓo wateyaka Yoane Moɓatise ɓaekosi ɓɛ.» ");
INSERT INTO loq_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesu amba ya wɔ na ɓɛ̀ɛ yokye: «Waaɓɔndɛlɛ ɓɛ̀ɛ, nde kowɔ ɓoɓo: Tata, nkombo ya wɛ eɓe esantu. Ɓokonzi pha wɛ ɓoye. ");
INSERT INTO loq_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Olophɛ mokɔlɔ na mokɔlɔ ntoma isengyesi na ɓanga. ");
INSERT INTO loq_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ololimbisa masumu ma ɓanga! Phɔ na ɓanga tolimbisa ɓɛbi ɓaalokyele ɓoɓe. Sa anola oɓokye Munguna alomekye.» ");
INSERT INTO loq_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yesu ambaya kula wɔ na ɓɛ̀ɛ oɓokye: «Umunya oɓokye mɔnɔmɔ na ɓɛ̀ɛ ali na ekamba, ambikyɛ onga nɛ na molengyela yokye: “Nwɛbi na nga, ombekya, mapa maato, ");
INSERT INTO loq_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","phɔ mɔnɔmɔ na ɓɛbi na nga oli o imbanga akomi oka nga uŋwaŋwa eye sili na ekpele ya imophɛ.” ");
INSERT INTO loq_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Emba oli o motema ŋwa ingambi, kambe mobuyisa yokye: “Lɛ ntungyisa! Uŋwaŋwa eye ingambi siimbokangyema; nga na ɓana ɓanga toumbo milangya, sikokyi ikula langwa phɔ ya iyaephɛ mapa.” ");
INSERT INTO loq_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nawɔ na ɓɛ̀ɛ, na ɓo talango phɔ ya imophɛ mapa mɛ phɔ ya ekamba ya ɓɛ, amba nde langwa phɔ ya etungu ya iyonga ya nwɛbi nɛ amba amophɛ isɔ iisengyesi nɛ. ");
INSERT INTO loq_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Yango mɛna nga na wɔ na ɓɛ̀ɛ ngakye: “Onga, ɓamoephɛ; luka wa mozwa, komola ekomba, ɓamoeyingolela.” ");
INSERT INTO loq_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Phɔ moto okoongye ɓamophɛ, moto okolukye kazwe, ɓaziɓolele ekomba ookokomole. ");
INSERT INTO loq_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ɓo mɔnɔmɔ onte ya ɓɛ̀ɛ ali ango wa ŋwana, ɓo ŋwana wɛ amoongyi swe, akokyi imophɛ nzɔɔ? ");
INSERT INTO loq_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Naa ɓo amongyi ikyɛ, aamophɛ iphalakasa? ");
INSERT INTO loq_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ɓo ɓɛ̀ɛ ɓato ɓaɓe koeɓe iphɛ ɓana ɓa ɓɛ̀ɛ mbolo indaa. Ya moɓa ɓoo na Ango wa ɓɛ̀ɛ owa ikolo okoambya Ɓolɔɓɔ Ɓosantu phɛ oka ɓaaɓongye!» ");
INSERT INTO loq_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Mokɔlɔ mɔnɔmɔ, Yesu aɓaka katɔkɔlɔ ɓolɔɓɔ ɓoɓe phaa buyaka moto mɔnɔmɔ mbubu, watɔkɔlɔ ɓolɔɓɔ ɓoɓe mɛ, mbubu mɔnɔ abuto iwɔ. Ɓato ɓamba kamwa na ɓoikye. ");
INSERT INTO loq_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Kasi ɓato ɓayɔkɔ ɓɛkye: «Eli Ɓɛlɛzeɓula, mokonzi ŋwa malɔɓɔ maɓe omophɛ mwiya ŋwa itɔkɔlɔ malɔɓɔ maɓe!» ");
INSERT INTO loq_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ɓaayɔkɔ ɓalukaka imumeka, ɓamba onga nɛ oɓokye akyele elekyesako ekye wɛninya oɓokye mwiya nwɛ moute na Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Kasi Yesu aeɓaka maumunya ma ɓɛ, amba ya wɔ na ɓɛ́ɛ yokye: «Ɓokonzi ɓosɔ ɓookaɓwa phango mampenza, phamunyangwa emba mangambi mamouwa mana o ikolo sa maayɔkɔ. ");
INSERT INTO loq_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ka ɓo Molemba yo mampenza akaɓwa, ɓokonzi phɛ phamotɛmɛ ndengye'ye? Phɔ ɓɛ̀ɛ kowɔ oɓokye nga natɔkɔlɔ malɔɓɔ maɓe na mwiya ŋwa Ɓɛlɛzeɓula. ");
INSERT INTO loq_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ɓoeɓe oɓokye nga natɔkɔlɔ malɔɓɔ maɓe na mwiya ŋwa Ɓɛlɛzeɓula, ka ɓato ɓa ɓɛ̀ɛ ɓamatɔkɔlɔ na mwiya ŋwa nza? Yango mɛna ɓato ɓa ɓɛ̀ɛ mampenza ɓamiwɛninya oɓokye oli na ekpee. ");
INSERT INTO loq_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ka ɓoeɓe oɓokye nde na eɓɔkɔ ya Ŋwaphongo nga na tɔkɔlɔ milimo mibe, emba Ɓokonzi pha Ŋwaphongo ɓoekomesi.» ");
INSERT INTO loq_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","«Phɔ ɓo moto mokusi, na biŋwanele ɓɛ̀ɛ bikusi kaɓanza ingambi sɛ, mbolo yɛ yamoɓa na ɓolaa. ");
INSERT INTO loq_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Kasi nde ɓo moto mosuu oomolekyi na ɓokusi aesi, amoɓɔlɔsi bina biŋwanele ɓisɔ biɓakyi yo kalemele, emba amokaɓa mbolo isɔ iɓɔlɔsi yo.» ");
INSERT INTO loq_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","«Moto ootoli na nga mbale, ali munguna ŋwa nga. Moto ootonsungye o iɓɔkya, kanyangole.» ");
INSERT INTO loq_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","«Watɔkɔlɔ ɓolɔɓɔ ɓoɓe o nzoto ya moto, ɓokyɛ miengyeɓana o bokye, ɓokyɛ miluka elele ya iɓa. Ɓotemozwe elele, ɓomiwɔlɛ oɓokye: “Namobutwa o ingambi sa nga saɓaka nga.” ");
INSERT INTO loq_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Waaya butwa phango, ɓoya zwa ingambi mɛ ɓasikɔmbi, ɓasiɓɔngyɛ na ɓolaa. ");
INSERT INTO loq_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ɓoɓɛlɛ mombe kyɛ kpa mbengo ya malɔɓɔ masuu sambo maamolekye na ɓoɓe; maambe ya nyɔlɔ makyɛɛ zala; emba moɓesi ŋwa moto mɔnɔ mobutwe moɓe koleka ɓowaɓaka ŋwango phanza.» ");
INSERT INTO loq_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Waaunva Yesu iwɔ ɓaɓona, ŋwaŋwasi mɔnɔmɔ amba ya aŋwana onte ya ɓato yokye: «Nkyisa na ibuu saenyanyaka na mabɛlɛ maa enywangyaka!» ");
INSERT INTO loq_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Kasi Yesu amba mobuyisa yokye: «Nkyisa ili nde na ɓato ɓaaokye Iloɓa sa Ŋwaphongo ɓambe na sikyelela!» ");
INSERT INTO loq_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Waaɓa moluku ŋwa ɓato ɓaye waali Yesu, amba butwa iwɔ yokye: «Ɓato ɓalɔlɔ eye ɓali ɓato ɓaɓe. Ɓaongye elekyesako, kasi eteɓawɛnɛ na elekyesako yɔnɔyɔ, ɓote eɓe nde eyaaka Yona eyaunva ɓɛ́ɛ wɛnɛ. ");
INSERT INTO loq_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Phɔ ɓo waɓaka Yona elekyesako phɔ ya ɓato ɓa Niniwe, nde ɓomɔ Ŋwana wa moto amoɓa elekyesako phɔ ya ɓato ɓa lɔlɔ eye. ");
INSERT INTO loq_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Mokɔlɔ ŋwaa mosambisa Ŋwaphongo ɓato, mokonzi wa ŋwaŋwasi ŋwa Saɓa amoya phunda ɓato ɓa lɔlɔ eye, phɔ auti itakye iya oka maloɓa ma zebi sa Salomo. Kasi oli wawa alekyi Salomo! ");
INSERT INTO loq_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Mokɔlɔ ŋwaa mosambisa Ŋwaphongo ɓato, ɓato ɓa Niniwe ɓamophunda ɓato ɓa lɔlɔ eye phɔ ɓato ɓa Niniwe ɓaɓɔngyaka moɓesi ŋwa ɓɛ́ɛ waa okaka ɓɛ́ɛ mateya ma Yona. Kasi ooli wawa alekyi Yona!» ");
INSERT INTO loq_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","«Moto taalosa tala phɔ ya ieɓomba na phɔ ya iekukya na katini, kasi kaetɛya o ikolo sa mesa phɔ ɓato ɓasɔ ɓanyɔlɔ o ingambi ɓawɛnɛ na ɓolaa. ");
INSERT INTO loq_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Miyo ma wɛ mali tala ya nzoto ya wɛ. Ɓo miyo ma wɛ mali malaa, nzoto ya wɛ mobimba kyingyɛngyɛ saa. Ka ɓo miyo mawɛ temali malaa, nzoto ya wɛ mobimba ili o enzombi. ");
INSERT INTO loq_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Yango mɛna okyeɓe oɓokye saa eeli o motema ŋwa wɛ yango sabutwa enzombi. ");
INSERT INTO loq_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ɓo nzoto ya wɛ mobimba kyingyɛngyɛ saa, nɔnɔ ŋwana ete tali o enzɔmbi, nzoto ya wɛ mobimba yamungyɛngyɛ saa, ndokolo ɓokoengyɛngyɛlɛ tala.» ");
INSERT INTO loq_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Waa unva Yesu iwɔ, mofalisayi mɔnɔmɔ amba ya moɓanga na izaa oka yɛ. Yesu amba nyɔlɔ o ingambi sa mofalisayi mɛ, amba kyɛ zala o mesa. ");
INSERT INTO loq_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Mofalisayi amba kamwa waa wɛnɛ yo Yesu kaze sataa kunyola sɛ. ");
INSERT INTO loq_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Emba Nkolo amba ya wɔ na mofalisayi mɛ yokye: «Kyeka ɓoli ɓɛ̀ɛ, ɓɛ̀ɛ ɓafalisayi, kokunyole nde ikolo sa ɓakɔphɔ na sa ɓasaani, kasi o motema ŋwa ɓɛ̀ɛ, watonda na phowa ya iiɓa na ya itɔmbɔ.» ");
INSERT INTO loq_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Bibubusi! Owakyela bii nze teeli yo owakyela na bii motema? ");
INSERT INTO loq_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Kaɓela nde ɓaɓola iili o motema ŋwa ɓa kɔphɔ na ili o ɓasaani ɓa ɓɛ̀ɛ, emba isɔ yamoɓa pɛɛ phɔ ya ɓɛ̀ɛ. ");
INSERT INTO loq_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","«Ngɔngɔ ya ɓɛ̀ɛ ɓafalisayi! Phɔ kophɛ Ŋwaphongo mɔnɔmɔ phɔ ya iko ya maakyi ma solo elaa na ya ndunda isɔ iinkyinkyi kasi kobungye ɓosembo na lozingo phɔ ya Ŋwaphongo; nzuka eli lango losengyelakyi ɓɛ̀ɛ ikyela, saleminya iiyɔkɔ.» ");
INSERT INTO loq_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","«Ngɔngɔ ya ɓɛ̀ɛ ɓafalisayi! Kozingye izala o biziye ɓa o ɓoo o Mangambi ma makyita, kozingye na oɓokye ɓaeɓeyakye o nsɔngɔ. ");
INSERT INTO loq_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ngɔngɔ ya ɓɛ̀ɛ! Oli ndokolo malita maatemaeɓane, kasi ɓato ɓatambule o ikolo sa mango saeɓa!» ");
INSERT INTO loq_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Mɔnɔmɔ wa ɓateye ɓa miɓeko amba ya wɔ na Yesu yokye: «Moteye, ɓo wɔ wɛ ɓaɓona, ka kotole ɓanga!» ");
INSERT INTO loq_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesu amba buya yokye: «Ngɔngɔ ya ɓɛ̀ɛ mɛ, ɓateye ɓa miɓeko! Phɔ ɓɛ̀ɛ kophisa ɓato biphesi bizito o nkukyi kasi ɓɛ̀ɛ toobikume nɔnɔ na munsɛ mɔnɔmɔ. ");
INSERT INTO loq_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ngɔngɔ ya ɓɛ̀ɛ, kotongyele ɓaimosi ɓa Ŋwaphongo malita malaa, kasi ya ɓaɓoma ɓa nkɔkɔ ɓa ɓɛ̀ɛ! ");
INSERT INTO loq_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Koteya oɓokye koanole yakyela ɓankɔkɔ ɓa ɓɛ̀ɛ. Ɓɛ́ɛ ɓaɓoma ɓaimosi ɓa Ŋwaphongo, ɓɛ̀ɛ kombe ɓatongyela mana malita. ");
INSERT INTO loq_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Yango mɛna Ŋwaphongo na zebi sɛ awɔ yokye: “Naaɓatomela ɓaimosi na ɓatoma, ɓamoɓoma ɓakyi, ɓamunyɔkɔlɔ ɓayɔkɔ.”» ");
INSERT INTO loq_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Phɔ oɓokye ɓato ɓa lɔlɔ eye ɓazwe etumbu phɔ ya ɓaimosi ɓa Ŋwaphongo ɓasɔ ɓaaɓoma ɓɛ́ɛ uta o etatele ya mokyisi. ");
INSERT INTO loq_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Tata waa ɓoma ɓɛ́ɛ Abɛlɛ nɔnɔ oka Zakaliya owa ɓoma ɓɛ́ɛ onte ya etumbelo na elele esantu. Phɛlɛ na wɔ na ɓɛ̀ɛ, ɓato ɓa lɔlɔ eye ɓamozwa etumbu phɔ ya ɓato ɓasɔ ɓaaɓoma ɓɛ. ");
INSERT INTO loq_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","«Ngɔngɔ ya ɓɛ̀ɛ ɓateye ɓa miɓeko! Wa kpa iphungola sa zebi kasi ɓɛ̀ɛ mampenza tonyɔlɔ, kasi ɓaazingye inyɔlɔ, ɓɛ̀ɛ koɓakatele.» ");
INSERT INTO loq_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Waatɔkɔlɔ Yesu o ingambi mɛ, ɓateye ɓa miɓeko na ɓafalisayi ɓamba butwa imotungyisa na yɔɔ esɔ, na imotuna maphɔɔ ndengye na ndengye. ");
INSERT INTO loq_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ɓamumekaka phɔ ɓamozwe na lowɔɔ ɓo awɔ lowɔɔ loɓe. ");
INSERT INTO loq_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Imbɛlɛ mɛ, ɓato ɓaikye ɓayakaka yaangana wali Yesu, ɓabuto ikyɛmikyitana o makolo phɔ ya ɓoikye. Yesu amba tata iwɔ phanza na ɓaekosi ɓɛ̀ɛ yokye: «Kyeɓa na munɔ ŋwa mampa ŋwa ɓafalisayi, kyelukye iwɔ oɓokye: Kyeɓa na ɓɔlɛ pha ɓɛ. ");
INSERT INTO loq_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Masɔ maaɓombama, mamowɛnɛ. Masɔ maazite ɓɛ, mamoeɓana. ");
INSERT INTO loq_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Yango mɛna, masɔ maawɔ ɓɛ́ɛ onte ya enzɔmbi, mamookana na moo, ikyikɔlɔ ɓɛ́ɛ o itoo onte ya ingambi, ɓamoiyanwenela o munsɔngɔ.» ");
INSERT INTO loq_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","«Ɓɛbi na nga, na wɔ na ɓɛ̀ɛ ngakye: Saiila ɓato ɓaakokyi iɓoma nde nzoto, kasi teɓakokyi ikulakyela ekpele esuu. ");
INSERT INTO loq_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Naeteya moto ookokyi ɓɛ̀ɛ iila; iila nde yo ookokyi sima ya iwa sa nzoto, ali na ná ɓokonzi pha ievaka o lifelo. Ɛɛ, na wɔ na ɓɛ̀ɛ, eli yo nde moto okokyi ɓɛ̀ɛ iila. ");
INSERT INTO loq_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Teɓaa ungya nswɛnswɛ itano inkyikyi na mpata iɓale? Kasi Ŋwaphongo tabungye na mɔnɔmɔ onte ya yɛɛ. ");
INSERT INTO loq_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Na phɔ ya ɓɛ̀ɛ, eli nde ɓomɔ. Kaeɓe na motiya ŋwa suwe ya ɓɛ̀ɛ. Yango mɛna ɓɛ̀ɛ saiila, ɓɛ̀ɛ oli na ntina eelekyi ɓokanda pha nswɛnswɛ!» ");
INSERT INTO loq_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","«Nakule wɔ na ɓɛ̀ɛ ɓoɓo: Moto munsɔ owamoanola o miyo ma ɓato ɓasɔ oɓokye ali moto wa nga, Ŋwana wa Moto aamoanola o miyo ma ɓanze ɓa Ŋwaphongo oɓokye ali moto wɛɛ. ");
INSERT INTO loq_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ka ɓo moto anzangaa o miyo ma ɓato, Ŋwana wa Moto aamoangana mɛ o miyo ma ɓanze ɓa Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Moto munsɔ ookowɔlɛ Ŋwana wa Moto na ɓoɓe, ɓaamolimbisa. Ka yo okowɔlɛ Ɓolɔɓɔ Ɓosantu na ɓoɓe, ete ɓamolimbisa. ");
INSERT INTO loq_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Waamokyɛ ɓɛ́ɛ na ɓɛ̀ɛ o Mangambi ma losambo phɔ yaesambisa o ɓoo pha ɓazuzi naa ɓakonzi, ɓɛ̀ɛ samiima na yaamokyɛ buya ɓɛ̀ɛ na ná yaamokyɛ wɔ ɓɛ̀ɛ. ");
INSERT INTO loq_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Phɔ imbɛlɛ mɛ, Ɓolɔɓɔ Ɓosantu amoeteya maphɔɔ masɔ maasengyesi ɓɛ̀ɛ iwɔ.» ");
INSERT INTO loq_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Moto mɔnɔmɔ onte ya ɓato ɓaaɓaka wamɔ amba ya wɔ na Yesu yokye: «Moteye, wɔ na ŋwana mama ampɛ iyalo saaka nga sa ilaka.» ");
INSERT INTO loq_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesu amba mobuyisa yokye: «Ekɔ́, owankyela munanga na mokabi ŋwa mbolo ya ilaka sa ɓɛ̀ɛ nza?» ");
INSERT INTO loq_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Sima amba ya wɔ na ɓɛ́ɛ ɓasɔ yokye: «Kyeɓa, motema munɛnɛ ŋwango saeleka! Phɔ ɓomɔɔ pha moto, na ɓo aɓe na ezwele ndengye'ye, teɓoli phɔ ya mbolo iili nɛ.» ");
INSERT INTO loq_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Emba amba ya ɓakpela ete yokye: «Moto mɔnɔmɔ wa ezwele aɓaka na manyɛtɛ maamoɓotelaka na ɓoikye. ");
INSERT INTO loq_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Aɓaka kamitune yokye: “Namokyela ɓo? Phɔ sili na elele ya iɓomba mbolo ya nga isɔ iye!” ");
INSERT INTO loq_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Amba miwɔlɛ yokye: “Kyeka ɓowamokyela nga: Namouwola mampɛndɛ ma nga, namba tonga masu manɛnɛ. Namoɓomba mbuma ya nga ya manzabi na mbolo ya nga isɔ omɔ. ");
INSERT INTO loq_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Sima, namba miwɔlɛ nga mampenza o motema ngakye: Nwɛbi, oli na mbolo nzikye o iɓombo phɔ ya mambula maikye. Eema, zaa, nywa, kumba!” ");
INSERT INTO loq_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Kasi Ŋwaphongo amba wɔ nɛ yokye: “Ebubusi! Nde o mokɔlɔ ŋwa lɔlɔ, namokpa ɓomɔɔ pha wɛ. Uŋwaŋwa eye isɔ iɓɔngyɛ wɛ, yamoɓa ya nza?”» ");
INSERT INTO loq_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yesu amba ya bakya yokye: «Owɛni lowɔɔ looyelele moto ookonukyiya ezwele ikye phɔ yɛ mampenza, kasi tali na ezwele oka Ŋwaphongo.» ");
INSERT INTO loq_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yesu amba ya wɔ na ɓaekosi ɓɛ́ɛ yokye: «Yango mɛna na wɔ na ɓɛ̀ɛ ngakye: Samiima phɔ ya ɓomɔɔ pha ɓɛ̀ɛ oɓokye wamoza ye naa phɔ ya nzoto ya ɓɛ̀ɛ oɓokye wamolata ye. ");
INSERT INTO loq_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Phɔ ɓomɔɔ ɓolekyi ntoma, na nzoto ilekyi bitobu. ");
INSERT INTO loq_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Kyeka biwawanga! Ɓɛ́ɛ teɓaphikye, teɓanɔkɔ, teɓali na mampɛndɛ nana bilele ɓa iɓomba mbolo, kasi Ŋwaphongo kabizeya! Nzuka na ɓɛ̀ɛ ɓaalekye biwawanga na ntina. ");
INSERT INTO loq_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Moto nza onte ya ɓɛ̀ɛ, phɔ ya imiima, ookokyi iɓakyisa mokɔlɔ mɔnɔmɔ o ɓomɔɔ phɛ? ");
INSERT INTO loq_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Kasi emba ɓotookokye ikyela nɔnɔ ŋwana lowɔɔ oomokyikyi, ka phɔ ya'ye kombe miima phɔ ya maphɔɔ maayɔkɔ? ");
INSERT INTO loq_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Kyeka ɓaphulɛlɛ ɓokotɔkɔlɔ ɓɛ, ɓɛ́ɛ teɓaakyele etoma, teɓaatongye na bitobu. Kasi na wɔ na ɓɛ̀ɛ ngakye: Eɓe na Salomo owaɓaka na ezwele ikye, taika lata bitobu bilaa ɓo yɔnɔyɔ na ɓaphulɛlɛ ɓaaɓana. ");
INSERT INTO loq_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ka ɓo Ŋwaphongo kalasa na ɓola nkata ya manzabi iili oɓokye yana ɓamoivaka o ŋwenya; nzuka na ɓɛ̀ɛ, ɓato ɓa ianola sikyikyi. ");
INSERT INTO loq_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Yango mɛna, ɓɛ̀ɛ samiimaka oɓokye tomoza ye, naa tomunywa ye. ");
INSERT INTO loq_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Phɔ, eli nde ɓato ɓateɓaeɓe Ŋwaphongo ɓakyɛ miluka maphɔɔ maamana. Kasi ɓɛ̀ɛ, ango wa ɓɛ̀ɛ kaeɓe oɓokye ɓɛ̀ɛ osengyesi na mango. ");
INSERT INTO loq_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Kasi taaluka phanza Ɓokonzi phɛ, mbolo miina amoekyinzisa yango. ");
INSERT INTO loq_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Saila, ɓɛ̀ɛ ŋwana ɓosoo oo mokyikyi! Phɔ ango wa ɓɛ̀ɛ asepesi iephɛ Ɓokonzi!» ");
INSERT INTO loq_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","«Ungya mbolo ya ɓɛ̀ɛ, ophɛ ɓaphalanga mɛ ɓato ɓaakamba. Omikyelele makuɓa maatemakotwe na ezwele eeteunve o ikolo. Omɔɔ, mwibi takome na munsɛ temokokyi ieza. ");
INSERT INTO loq_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Phɔ elele eli ezwele ya wɛ, ndondo ya wɛ yamoɓaa nde omɔɔ.» ");
INSERT INTO loq_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","«Omizekyitinya mbimbi, lɛ ɓatala ɓa ɓɛ̀ɛ ɓalolakye!» ");
INSERT INTO loq_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ɓaa ndokolo ɓato ɓaaziya nkolo wa ɓɛ́ɛ okoute o esɛlɛkɔ ya ɓolonga; oɓokye ɓo aesi ya komola, ɓamoziɓolele izele. ");
INSERT INTO loq_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Nkɔnzɔ na ɓaombo ɓaamoyazwa nkolo wa ɓɛ, waamoya butwa yo, ɓali o ikyɛngyɛ. Nde phɛlɛ na wɔ na ɓɛ̀ɛ ngakye: Aamizɛkyitinya mobimbi, aaɓazasa o mesa, emba yo mampenza amobutwa iɓakyelela. ");
INSERT INTO loq_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Emba ɓo aesi ya butwa na molengyela, naa sima ya molengyela, ɓo aesi ya ɓazwa ɓali nde o ikyɛngyɛ, ɓamoɓa na nkɔnzɔ. ");
INSERT INTO loq_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","«Eɓa oɓokye ɓo mokolo wa ingambi aeɓakyi imbɛlɛ siwaa saa moyaa nwibi, nde taanolakyi oɓokye abukye ingambi sɛ. ");
INSERT INTO loq_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Na ɓɛ̀ɛ omiɓɔngyia, phɔ Ŋwana wa moto amoya o imbɛlɛ siite siumunya ɓɛ̀ɛ.» ");
INSERT INTO loq_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Emba Petelo amba ya wɔ yokye: «Nkolo, okpe ete mɛna phɔ ya ɓanga ndee na phɔ ya ɓato ɓasɔ?» ");
INSERT INTO loq_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Nkolo amba mobuyisa yokye: «Moombo owa ɓosembo na malondo nza, o wa mɔɔlɔ nkolo phɔ ya iphɛ ɓato ɓa ingambi sɛ ntoma o imbɛlɛ siikokyi? ");
INSERT INTO loq_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Nkɔnzɔ ili na moombo mɔna ɓo nkolo wɛ, waamoyabutwa yo aesi ya motakana kakyele ena etoma. ");
INSERT INTO loq_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nde phɛlɛ na wɔ na ɓɛ̀ɛ ngakye, nkolo aamokyela mokonzi ŋwa mbolo yɛ isɔ. ");
INSERT INTO loq_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Kasi ɓo moombo mɛ amiwɔsi o motema nwɛ yokye: “Nkolo wa nga kangɔmbɔnɔ na iya”, aambi butwa iwanda ɓanzenga na ɓangɔndɔ ɓaetoma, abuto izaa, inywa na ilanga, ");
INSERT INTO loq_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","nkolo wɛ aamba yaa mokɔlɔ moote moomoziya yo, na imbɛlɛ siteseɓe yo: Aamowinya, amba mokyela ɓo wa mokyela ɓɛ́ɛ ɓato ɓaateɓanole Ŋwaphongo.» ");
INSERT INTO loq_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","«Moombo okoeɓe iikyizingye nkolo wɛ, kasi taikyi ɓɔngyia na taikyi kyela ɓokozingye yo, amokaa ɓaphimbo ɓaikye. ");
INSERT INTO loq_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Kasi yo otoeɓe ambi kyela maphɔɔ makokyi na nzii, ɓamoɓinda ɓaphimbo ɓontee. Moto musɔɔ oophɛ ɓɛ́ɛ na ɓoikye, ɓaamoonga na ɓoikye; oophise ɓɛ́ɛ na ɓoikye, ɓamokula moonga na ɓoikye koleka.» ");
INSERT INTO loq_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","«Naesi ya vaka ŋwenya o mokyisi, emba nazingakyi oɓokye nde moinalola eeto! ");
INSERT INTO loq_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nasengyesi ioka ɓolɔsi ɓoikye, phango phamoɓa ndokolo ɓatisimo yanga. Emba nali na nkaa tee nɔnɔ waamokokyisama yango. ");
INSERT INTO loq_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ɓɛ̀ɛ koumunya oɓokye na yaa o mokyisi phɔ ya iya ambya ɓose? Phe! Na wɔ na ɓɛ̀ɛ ngakye, na ya nde iya kaɓola ɓato. ");
INSERT INTO loq_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Phɔ tata lɔlɔ eye, ɓato ɓatano ɓali o ingambi sɔnɔsɔ, ɓamokaɓana: Ɓaato mbale, ɓaɓale mbale. ");
INSERT INTO loq_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ɓamokaɓana, ango amoina ŋwana wɛ owa lele, ŋwana owa lele amoina ango; nyango amoina ŋwana wɛ owa ŋwaŋwasi, ŋwana owa ŋwaŋwasi amoina nyango. Ɓokyilo owa ŋwaŋwasi amoina ŋwasi wa ŋwana wɛ, na ŋwasi wa ŋwana amoina nyamolo nyɛ.» ");
INSERT INTO loq_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu awɔkɔ na ná moluku ŋwa ɓato yokye: «Waawɛnɛ ɓɛ̀ɛ ikolo siɓɛlɔ biikyɛ milangya moo, kowɔ izele oɓokye: “Mbula ya munɔ”, emba wakyelame nde ɓomɔ. ");
INSERT INTO loq_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Waawɛnɛ ɓɛ̀ɛ ewɛɛlɛ kyeuté bii ngyɛlɛ, kowɔ oɓokye: “Lɔlɔ nzanga ya moleka”, emba wakyelame nde ɓomɔ. ");
INSERT INTO loq_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ɓanyamaɓɔlɛ! Koeɓe nde ilimbola lolengye lowɛnɛ ɓɛ̀ɛ o ikolo na lowɛnɛ ɓɛ̀ɛ o se. Ka phɔ ya'ye tombe eɓa ilimbola imbɛlɛ sisi?» ");
INSERT INTO loq_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","«Phɔ ya'ye ɓɛ̀ɛ mampenza toeɓe maphɔɔ ma ɓosembo? ");
INSERT INTO loq_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Waakyɛ ɓɛ̀ɛ na moto ooli na wɛ na lowɔ ikyɛ amba oka munanga, ɓɔngya nɛ wataɓa ɓɛ̀ɛ o nzela. Ɓo phe, moto mɛ amoekomya o ɓoo pha munanga, emba munanga amoeyambya oka bulusi, bulusi amoevaka o bɔlɔkɔ. ");
INSERT INTO loq_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nawɔ na wɛ oɓokye, na ɓo ndengye'ye otoo tɔkɔlɔ o bɔlɔkɔ ɓo naino tokokye ɓaphalanga ɓasɔ ɓaamoeyonga ɓɛ.» ");
INSERT INTO loq_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Imbɛlɛ mɛ, ɓato ɓasuu ɓamba ya imola Yesu ndengye eyasweyaka Pilata malongo ma ɓato ɓa Galileya imbɛlɛ saaɓaka ɓɛ́ɛ ɓaphɛ Ŋwaphongo mambeka. ");
INSERT INTO loq_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesu amba ya ɓabuyisa yokye: «Koumunya oɓokye ɓato ɓa Galileya ɓaaɓana ɓalekaka ɓato ɓa Galileya ɓaayɔkɔ ɓasɔ na masumu phɔ ya izwa etumbu ndengye mɛna? ");
INSERT INTO loq_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Phe, nawɔ na ɓɛ̀ɛ ngakye: Kasi ɓo ɓɛ̀ɛ toɓɔngyɛ moɓesi ŋwa ɓɛ̀ɛ, ɓɛ̀ɛ ɓasɔ wamovaka nde ɓomɔ. ");
INSERT INTO loq_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Eɓe ɓato iko mbuka mwambi ɓaa Yelusalɛmɛ ɓaawa waa bukwaka ingambi sianda saa Silowe, koumunya oɓokye ɓoɓe pha ɓɛ́ɛ phalekaka ɓato ɓasɔ ɓa Yelusalɛmɛ? ");
INSERT INTO loq_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Phe, nawɔ na ɓɛ̀ɛ ngakye: Kasi ɓo ɓɛ̀ɛ toɓɔngyɛ moɓesi ŋwa ɓɛ̀ɛ, ɓɛ̀ɛ ɓasɔ wamovaka nde ɓomɔ.» ");
INSERT INTO loq_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ɓoɓɛlɛ Yesu amba ya ɓakpela ete yokye: «Moto mɔnɔmɔ aphikaka ŋwete ŋwa fige o inzambi sɛ sa vinyɔ. Mokɔlɔ mɔnɔmɔ amba ya kyɛ luka mbuma ya fige omɔ, kasi taamba zwa. ");
INSERT INTO loq_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Emba amba ya wɔ na moto wa etoma owa inzambi yokye: “Kyeka, mbula iyato, naina ya luka mbuma ya fige, kasi siizwe. Oekpɛtɛ! Phɔ ya'ye kyembe na unva ntoma ya manyɛtɛ nde pha?” ");
INSERT INTO loq_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Kasi moto wa etoma owa inzambi amba ya mobuyisa yokye: “Nkolo, taakula elɛ naino mbula eye. Namotima manyɛtɛ o mambale, namba vaka nkata yaa phɔlɔ omɔ. ");
INSERT INTO loq_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Imbɛlɛ sisuu ekokyi iɓota mbuma o mbula ekye ye. Ɓo phe, waamokpɛtɛ.”» ");
INSERT INTO loq_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Mokɔlɔ mɔnɔmɔ ŋwa Saɓata, Yesu aɓaka kateya o Ingambi sɔnɔsɔ sa makyita. ");
INSERT INTO loq_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ŋwaŋwasi mɔnɔmɔ aɓaka wamɔ, aɓaka na ɓolɔɓɔ ɓoɓe pha mobuyaka etuku mambula iko mbuka ŋwambi; aumbamaka, takulaka koka na imielola na ɓolaa. ");
INSERT INTO loq_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Waa wɛnɛ Yesu ŋwaŋwasi mɛ, amba moɓanga, amba ya wɔ nɛ yokye: «Ŋwaŋwasi, obikyi na ɓolɔsi pha wɛ.» ");
INSERT INTO loq_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Amba ya motandela maɓɔkɔ. Mina wamɔ aelo, abuto ikumbela Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Kasi mokonzi ŋwa Ingambi sa makyita, awɛnɛkyɛ ɓoɓe phɔ Yesu abikye moto mokɔlɔ ŋwa Saɓata. Amba ya wɔ na ɓato yokye: «Toli na nkɔlɔ motoɓa ya etoma. Ɓɛ̀ɛ yakaka nkɔlɔ mɛ, phɔ ɓaebikya na malɔsi ma ɓɛ̀ɛ. Kasi mokɔlɔ ŋwa Saɓata phe!» ");
INSERT INTO loq_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Kasi Nkolo amba ya mobuyisa ɓoɓo: «Ɓɛɛ ɓanyamaɓɔlɛ! Mokɔlɔ ŋwa Saɓata, mɔnɔmɔ na mɔnɔmɔ na ɓɛ̀ɛ taingole ngɔmbɛ yɛ eɓe naa mpunda yɛ phɔ ya ikyɛ enyweya maa? ");
INSERT INTO loq_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ka ŋwaŋwasi oyo ali nkɔkɔ ya Abalayama. Molemba amwakya mbula iko mbuka ŋwambi. Emba sikokakyi imoingola o mokɔlɔ ŋwa Saɓata?» ");
INSERT INTO loq_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Waaɓawɔlɛ Yesu ɓaɓona, ɓanguna ɓa ɓɛ́ɛ ɓasɔ ɓaokaka sɔɔ. Kasi moluku ŋwa ɓato munsɔ ɓaɓaka na nkyisa phɔ ya maphɔɔ maalaa maakyelaka yo. ");
INSERT INTO loq_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesu amba ya wɔ yokye: «Ɓokonzi pha Ŋwaphongo ɓoulane na ye? Naɓoulinya na ye? ");
INSERT INTO loq_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ɓoulane na mumbuma ŋwa mutardɛ, moto mɔnɔmɔ amokpee, akyɛ mophika o inzambi sɛ. Mumbuma mokosi, mobuto ŋwete, manyɔsi maya tonga mooɓo o bitakyi ɓa ŋwango.» ");
INSERT INTO loq_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesu amba kula wɔ yokye: «Namoulinya Ɓokonzi pha Ŋwaphongo na ye? ");
INSERT INTO loq_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ɓokonzi pha Ŋwaphongo ɓoulane na munɔ ŋwa mapa; ŋwaŋwasi mɔnɔmɔ amokpe, amoangyinye na faline iikye o saani, faline esɔ yuulo.» ");
INSERT INTO loq_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu alekanaka o nkyisi iinɛnɛ na iinkyikyi ikyɛmiteya tee nɔnɔ waamokyɛ koma yo Yelusalɛmɛ. ");
INSERT INTO loq_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Moto mɔnɔmɔ amba motuna yokye: «Nkolo, ɓato ɓamobika teɓali nde ɓaikye?» Yesu amba ya mobuyisa yokye: ");
INSERT INTO loq_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Kyela ɓokusi onyɔlɔ ya moziɓo mokyikyi. Phɔ nawɔ na ɓɛ̀ɛ nga kye ɓato ɓaikye ɓamoluka inyɔlɔ kasi eteɓakokye.» ");
INSERT INTO loq_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","«Waamoiŋwa mokolo ŋwa ingambi phɔ ya ikanga ekomba, ɓɛ̀ɛ wamoikala o iɓanda, wamba tata ikomola ekomba kombe wɔ oɓokye: “Nkolo, oloziɓole”. Amba ebuyisa yokye: “Ɓɛɛ ɓanza?” ");
INSERT INTO loq_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Emba ɓɛ̀ɛ waamba butwa iwɔ oɓokye: “Tozaaka tonywaka na wɛ elele yɔnɔyɔ, wambaka na teya o nsɔngɔ ya mokyisi ŋwa ɓanga.” ");
INSERT INTO loq_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Kasi yo amokula ebuyisa yokye: “Ɓɛɛ ɓanza? Mana phɛnɛphɛ na nga, ɓɛ̀ɛ ɓasɔ ɓaakyele ɓoɓe.” ");
INSERT INTO loq_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Omɔɔ, yamoɓa nde malelo na itwa mino, waamowɛnɛ ɓɛ̀ɛ Abalayama, Izake na Yakoɓo eɓe ɓaumosi ɓasɔ ɓa Ŋwaphongo, ɓali o Ɓokonzi pha Ŋwaphongo. Ka ɓɛ̀ɛ ɓamoevaka o nzee! ");
INSERT INTO loq_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ɓato ɓamouta o mbale ekyetɔkɔlɔ na ekyekyɛ minangya moo, na mbale eya ikolo na eya ngyɛlɛ ɓamo ya zwa elele ya izaa o esɛlɛkɔ, o Ɓokonzi pha Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Nde phɛlɛ, ɓato ɓayɔkɔ ɓaɓakyi uŋwaŋwa eye o mbomela, ɓamobutwa o ɓoo, ka ɓali uŋwaŋwa eye ɓato ɓa o ɓoo, ɓamobutwa ɓato ɓaa mbomela.» ");
INSERT INTO loq_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Nde o sina imbɛlɛ mɛ, ɓafalisayi ɓaayɔkɔ ɓamba susana oli Yesu, ɓamba wɔ nɛ ɓɛkye: «Mana wawa kyɛndɛ bisuu, phɔ Elode kalukye na ieɓoma.» ");
INSERT INTO loq_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesu amba ya ɓabuyisa yokye: «Kyɛndɛ kyɛ imola munyabi ŋwa Inzumbu mona, oɓokye: “Lɔlɔ na yana, natɔkɔlɔ malɔɓɔ maɓe, nabikya ɓato ɓamalɔsi; maaɓale, namounva etoma ya nga.” ");
INSERT INTO loq_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Kasi lɔlɔ, yana na maaɓale, nasengyesi iunva imbamga sa nga, phɔ teliɓolaa oɓokye moimosi wa Ŋwaphongo awe bisuu, kasi kawe nde o Yelusalɛmɛ.» ");
INSERT INTO loq_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","«Yeeeh! Yelusalɛmɛ! Iwɛ okoɓome ɓaimosi ɓa Ŋwaphongo, kombe kula ɓoma na maɓanga ɓato ɓaetomele Ŋwaphongo! Mbala nzikye nazingaka iɓɔkyɛ ɓana ɓa wɛ ndokolo eɓɛmbɛ ya soo waaɓɔkya yo ɓana ɓɛ́ɛ o se ya mapapusa mɛ, kasi toikaka zinga. ");
INSERT INTO loq_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Kyeka! Ingambi sa ɓɛ̀ɛ ɓaasilɛɛ. Nawɔ na ɓɛ̀ɛ ngakye: Otokule nvɛnɛ nɔnɔ imbɛlɛ sa mowɔ ɓɛ̀ɛ oɓokye: “Lɛ oɓokye Ŋwaphongo apambole ookoye na nkombo ya Nkolo!”» ");
INSERT INTO loq_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Mokɔlɔ mɔnɔmɔ ŋwa Saɓata, Yesu amba ya kyɛndɛ o ingambi sa mokonzi mɔnɔmɔ ŋwa ɓafalisayi phɔ ya ikyɛ zaa. Ɓafalisayi ɓaaɓaka wamɔ, ɓaɓaka ɓamolembetele. ");
INSERT INTO loq_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Moto mɔnɔmɔ amba ya tɛmɛ o ɓoo phɛ, aɓaka na ɓolɔsi ɓoulole makolo na maɓɔkɔ. ");
INSERT INTO loq_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesu amba ya tuna ɓateye ɓa miɓeko na ɓafalisayi yokye: «Moɓeko ŋwa ɓanga moanole oɓokye ɓabikya moto mokɔlɔ ŋwa Saɓata?» ");
INSERT INTO loq_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Kasi, ɓɛ́ɛ ɓasɔ ɓamba ikala ɓose. Emba Yesu amba yakpa moto owa ɓolɔsi mɛ, amobikye, amba mobuya. ");
INSERT INTO loq_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ɓoɓɛlɛ, amba ya wɔ na ɓɛ́ɛ yokye: «Nza onte ya ɓɛ̀ɛ ɓo ŋwana wɛ wa lele naa ngɔmbɔ yɛ eka o iziɓa, etaeyaɓole izele mokɔlɔ ŋwa Saɓata?» ");
INSERT INTO loq_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Kasi teɓaika koka imobuyisa na eyano. ");
INSERT INTO loq_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesu amba ya kpela ɓato ɓaaɓangaka mofalisayi iya zaa o ingambi sɛ ete yɔnɔyɔ, phɔ awɛnɛkyɛ oɓokye ɓaɔlɔ biziye ɓa o ɓoo, amba wɔ na ɓɛ́ɛ yokye: ");
INSERT INTO loq_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Ɓo moto mɔnɔmɔ aeɓangyi o esɛlɛkɔ ya ɓolonga, sakyɛ zala o biziye ɓa o ɓoo, phɔ imbɛlɛ sisuu aɓangyi moto mosuu okoelekye na kaa, ");
INSERT INTO loq_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","emba moto oeɓangyi ɓɛ̀ɛ ɓasɔ ɓaɓale o esɛlɛkɔ, amoya wɔ na wɛ oɓokye: “Omolɛlɛ elele mɛna.” Emba wamumana na sɔɔ iikye, wamba butwa ikyɛ zala o elele eya mbomela. ");
INSERT INTO loq_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ka wɛ, ɓo ɓaeɓangyi o esɛlɛkɔ, kyɛndɛ kyɛ zala o elele ya mbomela. Emba waamoya moto oeɓangyi, amo yawɔ na wɛ yokye: “Nwɛbi na nga, yaka ya zale o elele eya ɓoo.” Emba wamozwa kaa o miyo ma ɓato ɓasɔ ɓazasi na wɛ. ");
INSERT INTO loq_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Phɔ moto munsɔ ookomitombe, ɓaamouya, okomiuya ɓaamotomba.» ");
INSERT INTO loq_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yesu amba ya wɔɔ na moto owa moɓangaka yokye: «Ɓokolukye iɓanga ɓato phɔ ya izaa, sa ɓanga bikamba ɓa wɛ, eɓe ɓanaa nyɔngɔ, eɓe ɓato ɓa iɓota sa wɛ, na ɓato ɓa ezwele ɓali phɛnɛphɛ na wɛ. Phɔ ɓookyesi ɓaɓona mokɔlɔ mosuu na ɓɛ́ɛ ɓamoeɓanga, ɓamoebuyisa ɓolaa ɓosɔ phaa ɓakyelaka wɛ. ");
INSERT INTO loq_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Kasi ɓo kolukye iɓanga ɓato phɔ ya izaa, ɓanga nde ɓaɓola, ɓato ɓaaɔtɔnɔ maɓɔkɔ, na ɓaatɔnɔ makolo, na ɓato ɓa phɔlɔ miyo. ");
INSERT INTO loq_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Emba wa moɓa na nkɔnzɔ, phɔ ɓɛ́ɛ teɓali na ekpele eya iebuyisa. Kasi ɓamoebuyisela yango mokɔlɔ ŋwaa mokundwa ɓato ɓaa ɓosembo.» ");
INSERT INTO loq_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Waaoka mɔnɔmɔ na ɓaaɓangaka ɓɛ́ɛ lowɔɔ mɛ, amba ya wɔ na Yesu yokye: «Nkɔnzɔ na moto owa mozwa elele o izaa o Ɓokonzi pha Ŋwaphongo!» ");
INSERT INTO loq_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesu amba mokpela ete yokye: «Moto mɔnɔmɔ aɓɔngyaka esɛlɛkɔ enɛnɛ, amba ɓanga na ɓato ɓaikye. ");
INSERT INTO loq_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Waakoka imbɛlɛ sa izaa, amba ya toma moto wɛ owa etoma ikyɛ imola ɓato ɓaaɓangaka yo oɓokye: “Ɓɛɛ yaka, uŋwaŋwa eye maphɔɔ masɔ makokyi.” ");
INSERT INTO loq_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Kasi ɓɛ́ɛ ɓasɔ, mɔnɔmɔ na mɔnɔmɔ atati iyonga ɓolimbisi. Owa ɓoo amba ya wɔ na moto owa etoma yokye: “Nauti iyomba inzabi, esengyesi oɓokye nakyɛ sikyeka. Naeɓɔndi ondimbisa.” ");
INSERT INTO loq_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ooyɔkɔ yokye: “Nauti iyomba matina ma mangɔmbɛ matano, nakyɛ mameka naa mali malaa. Naeɓɔndi ondimbisa.” ");
INSERT INTO loq_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Omoyokɔ yokye: “Nauti ilonga ŋwaŋwasi nde nkɔlɔ iye, yango mɛna sikokyi iya.”» ");
INSERT INTO loq_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","«Moto wa etoma amba ya butwa oka mokonzi nwɛ, amba ya moimola maphɔɔ masɔ. Mokonzi amba ya oka yɔ. Amba ya wɔɔ na moto wɛ owa etoma yokye: “Kyɛndɛ izele o bilele biangane ɓato na o nsɔngɔ ya mokyisi, onzelele na ɓaɓola, ɓato ɓaaɔtɔnɔ maɓɔkɔ, ɓato ɓaa phɔlɔ miyo, na ɓato ɓaaɔtɔnɔ makolo.” ");
INSERT INTO loq_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Sakɔkɔ, moto owa etoma amba ya wɔ yokye: “Mokonzi nakyesi ɓoontomakyi wɛ, kasi bilele bisuu bitaɓa pha.” ");
INSERT INTO loq_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Mokonzi amba kula ya wɔ na moto owa etoma yokye: “Kyɛndɛ o manzela na o manzabi. Nyɔsa ɓato ɓasɔ ɓamozwa wɛ na ɓokusi, phɔ ingambi sa nga sitonde. ");
INSERT INTO loq_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nawɔ na ɓɛ̀ɛ ngakye: Onte ya ɓato ɓasɔ ɓaaɓangakyi nga phanza, moto na mɔnɔmɔ takokyi izwa elele o esɛlɛkɔ ya nga.”» ");
INSERT INTO loq_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Moluku ŋwa ɓato ɓaikye ɓaɓaka ɓaɓengye Yesu. Yesu amba ya ekpana oli ɓɛ, amba ya wɔ na ɓɛ́ɛ yokye: ");
INSERT INTO loq_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Moto ookozingye iya oka nga asengyesi inzinga koleka ango, nyango, ŋwaŋwasi wɛ, ɓana ɓɛ, ɓanaa nyango, mankanasa mɛ, eɓe na ɓomɔɔ phɛ, ɓophe takokyi iɓa moekosi wa nga. ");
INSERT INTO loq_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Moto oolɛ inyanya ekulusu yɛ phɔ ya imbenga, takokyi iɓa moekosi wa nga. ");
INSERT INTO loq_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ɓo mɔnɔmɔ na ɓɛ̀ɛ kalukye itonga ingambi siinɛnɛ; amotazala naino phɔ ieɓa motuya ŋwa phalanga ɓaamobungya yo, ɓowalongoɓa na ɓaphalanga ɓali nɛ phɔ ya iunva ingambi mɛ. ");
INSERT INTO loq_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ka ɓotakyesi ɓaaɓona, ɓo awangye ingambi taambi siunva, ɓato ɓasɔ ɓaasiwɛnɛ, ɓamobutwa imwɛkyɛ. ");
INSERT INTO loq_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ɓamowɔ ɓɛkye: “Moto oyo atatakyi itonga ingambi, tambi siunva.” ");
INSERT INTO loq_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Nde ɓomɔ, ɓo mokonzi mɔnɔmɔ kalukye ikyɛ ŋwana mabita na mokonzi mosuu, amotaa zala phanza phɔ ya iumunya, ɓo amokoka na ɓatuluku nkoto iko ɓaali nɛ, iŋwana na nwɛbi nɛ ooli na ɓatuluku nkoto mako maɓale. ");
INSERT INTO loq_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ɓo etaakokye, amotoma ɓatima oka mokonzi oomoyɔkɔ, naino waataɓa yo itakye, phɔ ɓaɓɔngya. ");
INSERT INTO loq_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Eli nde ɓomɔ, onte ya ɓɛ̀ɛ, ɓo mɔnɔmɔ na ɓɛ̀ɛ taikyi isɔ iili nɛ taakokyi iɓaa moekosi wa nga.» ");
INSERT INTO loq_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","«Mokpa eli ekpele elaa. Kasi ɓo mumani vale, ɓamokula mobuya vale ndengye'ye? ");
INSERT INTO loq_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Te mokuli ɓa na ntina. Teɓakokyi imokyelela naa phɔ ya iɓɔngya manyɛtɛ naa phɔ ya manzambi; ɓamovakye nde onze. Ooli na matoo ma ioka, aokye!» ");
INSERT INTO loq_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Mokɔlɔ mɔnɔmɔ, ɓaphutise ɓamputi na ɓato ɓa masumu, ɓamba ya ɓɛ́ɛ ɓasɔ oli Yesu phɔ ya imooka. ");
INSERT INTO loq_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ɓafalisayi eɓe na ɓateye ɓa miɓeko ɓaumelaka, ɓamba wɔ ɓɛkye: «Moto mɛ kanyangyele ɓato ɓa masumu, kambe zaa na ná ɓɛ́ɛ elele yɔnɔyɔ!» ");
INSERT INTO loq_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yango mɛna, Yesu amba ya ɓakpela ete eye: ");
INSERT INTO loq_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Ɓo mɔnɔmɔ onte ya ɓɛ̀ɛ ali na mampate munkama, yɔnɔyɔ embi bunga etaa ikye ika mako ibuwa mbuka ibuwa o bokye, phɔ ya ikyɛ luka yɔnɔyɔ eebungyi tee nɔnɔ wa mo ezwa yo? ");
INSERT INTO loq_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Imbɛlɛ sa moezwa yo, amoɓa na nkyisa ɓoikye; amoenyanya o maɓɛkyɛ, ");
INSERT INTO loq_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","amobutwa o ingambi sɛ. Sima mɛ, amoangyinya bikamba ɓɛ, na ɓabuɓa nɛ, amba ya wɔ na ɓɛ́ɛ yokye: “Yaka ya sepele na nga molɔngɔ, phɔ nazwe mpate ya nga eebungakyi!” ");
INSERT INTO loq_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Na wɔ na ɓɛ̀ɛ, eli nde ɓomɔ o ikolo, nkyisa ya moɓa na ɓoikye, phɔ ya moto wa masumu mɔnɔmɔ ooɓongosi motema, nkyisa mɛ ya moleka yaaka ɓato ɓa ɓosembo mako ibuwa mbuka ibwa ɓaate ɓasengyesi na iɓongola motema.» ");
INSERT INTO loq_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","«Ka naa ɓo ŋwaŋwasi mɔnɔmɔ ali na ɓaphalanga ɓa biɓende iko, ɓo mpata yɔnɔyɔ ebungyi, etaalosa tala, etaakɔmɓɔ ingambi na ikyɛ miluka na ɓolaa, tee nɔnɔ wa mokyɛ ezwa yo? ");
INSERT INTO loq_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Emba imbɛlɛ siezwe yo, amoangyinya bikamba ɓɛ́ɛ na ɓabuɓa nɛ yokye: “Yaka ya sepele na nga molɔngɔ, phɔ nazwe mpata ya nga ebungakyi!” ");
INSERT INTO loq_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nde ɓomɔ, na wɔ na ɓɛ̀ɛ nga kye, nkyisa ili oka ɓanze ɓa Ŋwaphongo phɔ ya moto wa masumu mɔnɔmɔ ooɓongosi motema.» ");
INSERT INTO loq_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu amba kula ya wɔ yokye: «Moto mɔnɔmɔ aɓaka na ɓana ɓa ɓampele ɓaɓale. ");
INSERT INTO loq_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Oo mosi amba ya wɔ na ango wa ɓɛ́ɛ yokye: “Tata, kaɓa ezwele ya wɛ, ompɛ iyalo saaka nga.” Emba ango wa ɓɛ́ɛ amba ya kaɓa ezwele yɛ onte ya ɓana ɓɛ́ɛ ɓaɓale. ");
INSERT INTO loq_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Sima ya ɓanaa nkɔlɔ, ŋwana o mosi aesi ya ungya mbolo yɛ isɔ, akpe ɓana ɓaphalanga akyɛ na ɓɛ́ɛ o mokyisi mɔnɔmɔ itakye. Omɔ, akyɛ ɓaɔtɔ na maphɔɔ mazanga ntina. ");
INSERT INTO loq_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Waunva yo ɓaphalanga, zilo sikusi saamba ya nyɔlɔ o mokyisi mɛ; amba tata izanga na ntoma ya izaa. ");
INSERT INTO loq_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Amba kyɛ nyɔlɔ etoma oka moto mɔnɔmɔ wa mokyisi mɛ. Moto mɛ amba motoma o manzabi mɛ akyɛ ɓanza mangulu. ");
INSERT INTO loq_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Aɓaka nana phowa ya itonza ibu sɛ na ntoma yaɓaka mangulu mazee, kasi na moto mɔnɔmɔ taika mophɛ yango. ");
INSERT INTO loq_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Emba amba ya miyɔɔ yokye: “Ɓato ɓa etoma ɓa tata ɓasɔ, ɓazee mapa ɓamaotwe, nde nga wawa na we na nzala! ");
INSERT INTO loq_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Na mobutwa oka tata, namba wɔ nɛ ngakye: Tata, na kyɛlesi ikolo ɓoɓe, naekyelesi na wɛ ɓoɓe. ");
INSERT INTO loq_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Sikokyi ikula ɓangama ŋwana wa wɛ. Inkyele ndokolo mɔnɔmɔ na ɓato ɓa wɛ ɓa etoma.”» ");
INSERT INTO loq_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Amba ya kpa nzela ya ibutwa oka ango. «Waataɓa yo ŋwana itakye na ingambi, ango amba mowɛnɛ, amba oka ngɔngɔ: Amba kyilingana akyɛ moyamba. ");
INSERT INTO loq_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ŋwana amba ya wɔ na ango yokye: “Tata, nakyelesi ikolo ɓoɓe, naekyelesi na wɛ ɓoɓe. Sikokyi ikula ɓangama ŋwana wa wɛ…” ");
INSERT INTO loq_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Kasi ango amba ya wɔɔ na ɓaombo ɓɛ́ɛ yokye: “Yaka izele na etobu elekyi ɓolaa, omolasa yɛ; omolasa mumpɛtɛ o munsɛ na bikoto o makolo. ");
INSERT INTO loq_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Yaka na ŋwana wa ngɔmbɛ owa isa, omoɓome, tozee, tokyele esɛlɛkɔ. ");
INSERT INTO loq_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Phɔ ŋwana wa nga okowɛnɛ ɓɛ̀ɛ oyo awaka, kasi akuli butwa na ɓomɔɔ, abungaka kasi akuli zwama.”» Emba ɓamba ya tata esɛlɛkɔ. ");
INSERT INTO loq_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","«Imbɛlɛ mɛ ŋwana wa moto mɛ oo ɓola aɓaka o inzabi. O ibutwa sɛ, wakoma yo phɛnɛphɛ na ingambi, aesi ya okaa tɔkɔ ya meembo na mbina. ");
INSERT INTO loq_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Amba ya ɓanga mɔnɔmɔ na ɓaombo ɓa ɓɛ, amba motuna, lowɔ ye loolekane. ");
INSERT INTO loq_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Moombo mɛ amba moimola yokye: “Eli ŋwana nyɔngɔ aesi, yango mɛna ɔngɔ aɓomi ŋwana wa ngɔmbɛ owa isaa, phɔ amowɛni aesi yabutwa na nzoto ndaa.” ");
INSERT INTO loq_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Emba ŋwana oo ɓola amba oka yɔ, tamba na ɓenela inyɔlɔ o ingambi. Ango amba tɔkɔlɔ ikyɛ moɓɔndɔ. ");
INSERT INTO loq_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Kasi ŋwana amba ya buyisa ango yokye: “Kyeka mambula maikye maaekyelele nga satiyola miɓeko ma wɛ; kasi nga naino tombomesi nɔnɔ ŋwana wa mbosi phɔ ya ikyela esɛlɛkɔ na ɓɛbi na nga. ");
INSERT INTO loq_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Kasi oesi ŋwana wa wɛ oyo, iyo owaɔtɔ ezwele ya wɛ esɔ na ɓaɓasi, omoɓomesi ŋwana wa ngɔmbɛ owa isaa!” ");
INSERT INTO loq_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Emba ango amba ya wɔ nɛ yokye: “Ŋwana wa nga, iwɛ oli na nga nkɔlɔ isɔ wawa, mbolo isɔ iili na nga, ili ya wɛ. ");
INSERT INTO loq_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Kasi tosengyesi ikyela esɛlɛkɔ, toombe na sepela phɔ ŋwana nyɔngɔ okowɛnɛ wɛ oyo awaka kasi ali na ɓɔmɔɔ, abungaka, azwa!”» ");
INSERT INTO loq_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu amba ya wɔ na ɓaekosi ɓɛ̀ɛ yokye: «Moto mɔnɔmɔ wa ezwele aɓaka na kapita ooko ɓanza mbolo yɛ; ɓato ɓasu ɓamba moimola oɓokye, kapita wa wɛ, kaɔtɔ mbolo ya wɛ. ");
INSERT INTO loq_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Mokolo mbolo amba ya ɓanga kapita amba ya wɔ nɛ yokye: “Maphɔɔ iye maaokye nga ɓawɔ phɔ ya wɛ? Imbuyisa nkanda isɔ ikyelakyi wɛ etoma ya wɛ, phɔ tata lɔlɔ tokokyi ikula ɓaa kapita ya mbolo ya nga.” ");
INSERT INTO loq_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Emba kapita amba miwɔlɛ yo mampenza yokye: “Namokyela ɓo? Ɓo mokolo mbolo amanye o etoma? Iɓala manzabi, sili na ɓokusi. Ikyɛmionga, naokye sɔɔ. ");
INSERT INTO loq_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Naebi yaa mokyela nga phɔ ɓo ɓamanye o etoma, ɓato ɓanzambakye o mangambi ma ɓɛ.” ");
INSERT INTO loq_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Emba, amba ya ɓanga ɓato ɓasɔ ɓaaɓaka na mbɔngɔ na mokonzi nwɛ mɔnɔmɔ na mɔnɔmɔ. Amba ya tuna moto owa o ɓoo yokye: “Oli na mbɔngɔ ya mokonzi ŋwa nga ya ɓo?” ");
INSERT INTO loq_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Moto mɛ amba ya mobuyisa yokye: “Ɓa tonoo mukama ɓa mauta.” Kapita amba ya wɔ nɛ yokye: “Kyeka mokanda ŋwa mbɔngɔ ya wɛ, zala izele, koma makoo matano.” ");
INSERT INTO loq_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Atuni oomoyɔkɔ yokye: “Iwɛ oli na mbɔngɔ ya ɓo?” Amba ya mobuyisa yokye: “Ɓasakyi mukama ɓa ble.” Kapita amba ya wɔ nɛ yokye: “Kyeka mokanda ŋwa mbɔngɔ ya wɛ, koma ɓasakyi mako mwambi.” ");
INSERT INTO loq_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Mokonzi amba kumisa kapita owa ɓɔlɛ mɔna phɔ ya malondo mɛ. Phɔ ɓato ɓa mokyisi mumu ɓakalangana o maphɔɔ koleka ɓɛbi na ɓɛ́ɛ ɓaatambule na moo.» ");
INSERT INTO loq_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yesu ambakula ɓakya yokye, nga nawɔ na ɓɛ̀ɛ ɓoɓo: Luka bikamba na ezwele ya wɛ eya ɓɔlɛ, phɔ wa mounva ezwele mɛ, ɓaeyambe o mokyisi ŋwa ɓoɓɛlɛ. ");
INSERT INTO loq_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Moto ooli na ɓosembo o maphɔɔ maakyikyi, amoɓa na ná ɓosembo o maphɔɔ maanɛnɛ. Kasi moto otoli na ɓosembo o maphɔɔ maakyikyi, takokyi na iɓa na ɓosembo o maphɔɔ maanɛnɛ. ");
INSERT INTO loq_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ɓo toika ɓa na ɓosembo na ɓaphalanga ɓaakosa ɓato, owa moephɛ eyakolo ezwele nza? ");
INSERT INTO loq_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ka ɓo toika ɓa na ɓosembo na mbolo ya ɓato ɓasuu, owa moephɛ mbola yaka yawɛ nza? ");
INSERT INTO loq_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","«Moto wa etoma mɔnɔmɔ takokyi ikyelela ɓankolo ɓaɓale: Naa amoina mɔnɔmɔ, amba zinga omoyɔkɔ; naa aamiphɛ mi mɔnɔmɔ, amotiyola omoyɔkɔ. Tokokyi ikyelela mbala yɔnɔyɔ Ŋwaphongo na ɓaphalanga.» ");
INSERT INTO loq_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ɓafalisayi ɓaokaka maphɔɔ masɔ mamana, ɓambaka ɛkyɛ Yesu phɔ ɓazingaka ɓaphalanga. ");
INSERT INTO loq_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yesu amba ya wɔ na ɓɛ́ɛ yokye: «Ɓɛ̀ɛ komiwɛninya o miyo ma ɓato oɓokye oli ɓato ɓa ɓosembo. Kasi Ŋwaphongo kaeɓe mandondo ma ɓɛ̀ɛ. Oeɓe oɓokye maphɔɔ masɔ mawɛnɛ ɓato manɛnɛ, Ŋwaphongo kamawɛnɛ nde phaa. ");
INSERT INTO loq_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Imbɛlɛ saa miɓeko ma Mose na ɓaimosi ɓa Ŋwaphongo sasuka na Yoane Moɓatise. Kasi tata o imbɛlɛ saka Yoane Moɓatise, Simo Elaa ya Ɓokonzi pha Ŋwaphongo eimolami, emba moto munsɔ kakyele ɓokusi phɔ ya inyɔlɔ. ");
INSERT INTO loq_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ikolo na munse yamolekana nde na mɔɔ, kasi teɓakokyi imanya nɔnɔ ŋwana lowɔ mokyikyi o miɓeko. ");
INSERT INTO loq_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Moto munsɔ oolɛɛ ŋwasi wɛ, alongyi mosuu kakyele phemba; na olongyi ŋwaŋwasi oolɛɛ ɓɛ́ɛ na ɓolonga kakyele phemba.» ");
INSERT INTO loq_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","«Yaɓaka o mokyisi mɔnɔmɔ, moto wa ezwele aɓaka kalate bitobu bilaa na baamotiya; nkolo isɔ aɓaka kazee nde ntoma indaa ndokolo kakyele esɛlɛkɔ. ");
INSERT INTO loq_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","O ɓoo pha ingambi sɛ, moɓola mɔnɔmɔ nkombo yɛ Lazalo, nzoto yɛ yatondaka na maphika, aɓaka kamilangya omɔ. ");
INSERT INTO loq_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Aɓaka na phowa ya izaa nɔnɔ mpusu yaɓaka kyilale na mozwe o se ya mesa. Kasi yaɓaka nde manva maaɓaka maya lɛtɛ maphika mɛ. ");
INSERT INTO loq_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Mokɔlɔ mɔnɔmɔ moɓola amba ya waa. Ɓaanze ɓamba ya munyanya ooli Abalayama. Moto wa ezwele aesi ya waa mɛ, ɓamokundi. ");
INSERT INTO loq_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","O mokysi ŋwa ɓawe, aɓaka kawɛnɛ ɓolɔsi ɓoikye. Waatomba yo miyo o ikolo, aesi ya wɛnɛ Abalayama na itakye, na Lazalo azasi phɛnɛphɛ nɛ. ");
INSERT INTO loq_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Amba ya aŋwana yokye: “Tata Abalayama, inzokye ngɔngɔ, toma Lazalo, anyinya sɔngyɛ ya munsɛ nwɛ o maa, antangya o lole, phɔ na wɛnɛ ɓolɔsi ɓoikye o itumbu sa ŋwenya sisi.” ");
INSERT INTO loq_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abalayama amba mobuyisa yokye: “Ŋwana wa nga, umunya oɓokye wazwaka ezwele waaɓaka wɛ na ɓomɔɔ, kasi Lazalo aɓaka kawɛnɛ mpasi. Uŋwaŋwa eye wawa ɓamoɓɔndɔ kasi iwɛ kowɛnɛ mpasi. ");
INSERT INTO loq_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Waambi na ɓaa motepha mozindo onte ya ɓanga na ɓɛ̀ɛ. Phɔ ɓato ɓazingye iuta oni, phɔ ya iya oomɔ ɓɛ́ɛ sakoka, na moto na mɔnɔmɔ takokyi iuta oomɔ ayei oni.” ");
INSERT INTO loq_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Moto wa ezwele amba ya wɔ yokye: “Tata, ɓo ɓaɓona na eɓɔndi, toma Lazalo o ingambi sa tata, ");
INSERT INTO loq_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","phɔ nali na ɓanaa mama ɓa ɓampele ɓatano. Akyɛ ɓakyebisa phɔ ɓɛ́ɛ sayaa na ɓɛ́ɛ o elele eya mpasi eye.” ");
INSERT INTO loq_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abalayama amba ya mobuyisa yokye: “Ɓanaa nyɔngɔ ɓali na Mose na ná ɓaimosi ɓa Ŋwaphongo ɓaaɓakyebisa, ɓaɓaokye!” ");
INSERT INTO loq_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Moto wa ezwele yokye: “Phe, tata Abalayama. Ɓo moto mɔnɔmɔ auti onte ya ɓawee akyɛ ɓa imola, ɓamoɓongola motema.” ");
INSERT INTO loq_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Kasi Abalayama amba ya mobuyisa yokye: “Ɓo teɓaokyi Mose na ɓaimosi ɓa Ŋwaphongo, na ɓo moto mɔnɔmɔ auti onteya ɓawee, ete ɓaanole.”» ");
INSERT INTO loq_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu amba ya wɔ na ɓaekosi ɓɛ́ɛ yokye: «Maphɔɔ makyele oɓokye moto akyele masumu temakokyi izanga. Kasi ngɔngɔ eli na moto okotomisa ɓɛbi oɓokye ɓakyele masumu! ");
INSERT INTO loq_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Elekyi ɓolaa phɔ yɛ oɓokye ɓamotingya iɓanga siinɛnɛ o nkyingo, ɓamovakye o ebale, phɔ yo sakula tomisa mɔnɔmɔ na ɓaakyikyi ikyela masumu. ");
INSERT INTO loq_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Nde kokyeɓe! Ɓo nwɛbi na wɛ akyelesi isumu, omooya; ɓo aanosi isumu sɛ, omolimbisa. ");
INSERT INTO loq_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ka ɓo aekyelesi masumu mbala sambo na mokɔlɔ mɔnɔmɔ, ambi ya mbala yɔnɔyɔ na yɔnɔyɔ iyawɔ yokye: “Indimbisa”, wɛ omolimbisaka.» ");
INSERT INTO loq_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ɓatoma ɓamba ya wɔ na Nkolo ɓɛkye: «Kosa ianola sa ɓanga.» ");
INSERT INTO loq_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Nkolo amba ya wɔ yokye: «Ɓo oɓakyi nɔnɔ na ŋwana ianola sikyikyi ɓooli mumbuma ŋwa mutardɛ, nde owɔkyi na ŋwete mumu oɓokye: “Phikwa wawa kyɛndɛ miphika o ebale enɛnɛ”, nde moetose.» ");
INSERT INTO loq_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","«Moto nza onte ya ɓɛ̀ɛ ɓo ali na moombo ookomoɓalele inzabi naa ookomoɓanzisa manyama, amowɔ nɛ ɓo auti o manzabi oɓokye: “Kyɛndɛ kyɛzala o mesa izele ozee?” ");
INSERT INTO loq_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Etawɔ nɛ nde oɓokye: “Ondambele ntoma ya izaa, lata etobu elaa ombɔngyisa mesa, na ze na nywe; emba sima na wɛ waamba zaa waamba ná inywa.” ");
INSERT INTO loq_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Nkolo kaphɛ moombo wɛ mɛlɛsi phɔ akyesi iimotomakyi yo? Phe. ");
INSERT INTO loq_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Eli nde ɓomɔ phɔ ya ɓɛ̀ɛ; ɓo okyesi maphɔɔ masɔ maa etoma ɓɛ, wɔ oɓokye: “Toli nde ɓato ɓa etoma pha. Tokyesi nde etoma esengyelakyi ɓanga ikyela.”» ");
INSERT INTO loq_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Waaɓa Yesu kakyɛndɛ o Yelusalɛmɛ, amba lekana onte ya Samaliya na onte ya Galileya. ");
INSERT INTO loq_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Waanyɔlɔ yo o mokyisi mɔnɔmɔ, ɓato iko ɓaa maɓa, ɓamba ya vana nɛ. Ɓamba tɛmɛ ŋwana itakye, ");
INSERT INTO loq_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ɓamba butwa iaŋwana ɓɛkye: «Yesu, Moteye, olokye ngɔngɔ!» ");
INSERT INTO loq_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Waaɓa wɛnɛ Yesu, amba ya wɔ na ɓɛ́ɛ yokye: «Kyɛndɛ kyɛmiteya oka ɓanganga ɓa Ŋwaphongo.» Waɓa ɓɛ́ɛ ɓakyɛndɛ, ɓabikaka. ");
INSERT INTO loq_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Mɔnɔmɔ onte ya ɓɛ, waawɛnɛ yo oɓokye abikyi, aesi ya butwa oli Yesu, atati ikumbela Ŋwaphongo na ŋwɛsi ikolo. ");
INSERT INTO loq_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Amba kyɛ mivaka ɓoo nɔnɔ ose, o makolo ma Yesu, amba mophɛ mɛlɛsi. Moto mɛ aɓaka Mosaliya. ");
INSERT INTO loq_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Emba Yesu amba wɔ yokye: «Ɓɛ ɓasɔ iko teɓaikyibika? Ka ibuwa ɓaayɔkɔ ɓali bi? ");
INSERT INTO loq_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Onte ya ɓɛ́ɛ tewazwaa moto ooɓomesi iya phɛ Ŋwaphongo mɛlɛsi, yesi nde mobutu oyo?» ");
INSERT INTO loq_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Yesu amba ya wɔ nɛ yokye: «Inua, kyɛndɛ, ianola sa wɛ siebikye.» ");
INSERT INTO loq_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Mokɔlɔ mɔnɔmɔ, ɓafalisayi ɓamba ya tuna Yesu ɓɛkye: «Ɓokonzi pha Ŋwaphongo pha moya imbɛlɛ iye?» Amba ya ɓabuyisa yokye: «Ɓokonzi pha Ŋwaphongo ete ɓoye ndokolo ekpele ekyewɛnɛ ɓɛ́ɛ na miyo. ");
INSERT INTO loq_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ete ɓaawɔ oɓokye: “Kyeka phango ɓoɓo!” naa “phango ɓona.” Oeɓe oɓokye, Ɓokonzi pha Ŋwaphongo ɓoli onte ya ɓɛ̀ɛ.» ");
INSERT INTO loq_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Boɓɛlɛ, amba ya wɔ na ɓaekosi yokye: «Nkɔlɔ yaa moya, wa moɓa na phowa ya iwɛnɛ Ŋwana wa moto nɔnɔ mokɔlɔ mɔnɔmɔ, kasi otoomowɛnɛ. ");
INSERT INTO loq_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ɓamowɔ na ɓɛ̀ɛ oɓokye: “Kyeka yo ona, yo oyo.”» Ɓɛ̀ɛ sakyɛndɛ, sakyilingana omɔ. ");
INSERT INTO loq_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Phɔ mɔkɔlɔ ŋwaa moya Ŋwana wa Moto, ŋwamoɓa ndokolo munkankasi mungyɛngyɛ mbala yɔnɔyɔ, mowɛninya ikolo na suka na suka. ");
INSERT INTO loq_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Kasi phanza asengyesi itaa wɛnɛ ɓolɔsi, ɓato ɓa lɔlɔ eye ɓaamolɛɛ. ");
INSERT INTO loq_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","«Nde ɓowakyelamaka wango o nkɔlɔ yaaka Nowa, yamokyelama nde ɓomɔ o nkɔlɔ yaaka Ŋwana wa Moto: ");
INSERT INTO loq_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ɓato ɓazaaka, ɓanywaka, ɓalongaka, ɓalongyinyaka, tee nɔnɔ mokɔlɔ ŋwa nyɔlɔ Nowa o masuwa maatongaka yo; emba maa maamba ya zinza mokyisi, maamba ɓaɓoma ɓɛ́ɛ ɓasɔ. ");
INSERT INTO loq_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Yamoɓa ndokolo imbɛlɛ saka Lota, ɓato ɓaɓaka ɓazee, ɓanywe, ɓaombe, ɓaungya, ɓaphikye, ɓatongye mangambi; ");
INSERT INTO loq_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","kasi mokɔlɔ ŋwaa manaka Lota o Sɔdɔmɔ, Ŋwaphongo anɔyaka uta o ikolo mbula ya ŋwenya na muuwɛ ndokolo mobulubutu mookusi ya ɓomaka ɓato ɓasɔ. ");
INSERT INTO loq_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Yamokyelama nde ɓomɔ, mokɔlɔ ŋwaamiwɛninya Ŋwana wa Moto.» ");
INSERT INTO loq_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","«Mokɔlɔ mɛ, moto owa moɓa o iɓanda, yo sanyɔlɔ o ingambi ikyɛ ikpa mbolo yɛ; nde ɓomɔ na owa moɓa o inzabi, yo sabutwa na munsima. ");
INSERT INTO loq_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Umunya ya lekanaka na ŋwasi wa Lota. ");
INSERT INTO loq_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Moto okolukye ibikya ɓomɔɔ phɛ, aɓobungya, ka owaaɓobungya aaɓobikya. ");
INSERT INTO loq_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nawɔ na ɓɛ̀ɛ ngakye: Muna mokɔlɔ mɛ, ɓato ɓaɓale ɓamilangya ntangye yɔnɔnɔ: Ɓamokpa mɔnɔmɔ, ɓamwika oomoyɔkɔ. ");
INSERT INTO loq_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ɓaɓasi ɓaɓale ɓamoɓa ɓatwakye o omba yɔnɔyɔ: Ɓamokpa mɔnɔmɔ ɓamwika oomoyɔkɔ.  ");
INSERT INTO loq_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ɓampele ɓaɓale ɓamoɓa o inzabi: Ɓamokpa mɔnɔmɔ, ɓamwika oomoyɔkɔ.» ");
INSERT INTO loq_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ɓaekosi ɓamba ya tuna Yesu ɓɛkye «Nkolo, maphɔɔ mɛ ma molekama bi?» Amba ya ɓabuyisa yokye: «Elele eya moɓa eɓembe, biwawanga bamoangana wamɔ.» ");
INSERT INTO loq_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Mokɔlɔ mɔnɔmɔ, Yesu amba ya pkela ɓaekosi ɓɛ́ɛ ete, phɔ ya iɓateya oɓokye ɓasengyesi iɓɔndɛlɛ Ŋwaphongo nkɔlɔ isɔ, ɓɛ́ɛ saphɛmbɛ. ");
INSERT INTO loq_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Amba ya wɔ na ɓɛ́ɛ yokye: «Yaɓaka o mokyisi mɔnɔmɔ zuzi mɔnɔmɔ taikaka ɓaa kaile Ŋwaphongo, taikaka ɓaa kasaka na ɓato. ");
INSERT INTO loq_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ŋwaŋwasi ɓozengye mɔnɔmɔ aɓaka o mokyisi mɛ. Aɓaka kakyɛ nyingonela na zuzi mɛ nkɔlɔ isɔ yokye: “Intenele ɓolombe ɓolaa na moto owa lowɔɔ na nga.” ");
INSERT INTO loq_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Mbala nzikye zuzi mɔna taikaka ɓa kaɓenele imotenela ɓolomɓe. Kasi amba miwɔlɛ yokye: “Na ɓo siile Ŋwaphongo, na ɓo siitosa ɓato, ");
INSERT INTO loq_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","kasi phɔ ɓozengye ɓoɓo ɓontungyisa, naamotenela ɓolombe. Ɓo phe, nde sizasi ɓose.”» ");
INSERT INTO loq_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Emba Nkolo amba ɓakya yokye: «Okyemela na ɓolaa iiwɔɔ zuzi ootoli na ɓosembo oyo. ");
INSERT INTO loq_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Emba Ŋwaphongo amolɛ salongya ɓato ɓaaɔlɔ yo, ɓo ɓamoɓɔndɛsi na moo na mokɔlɔ? Amowɔ na ɓɛ́ɛ oɓokye ɓaataziya? ");
INSERT INTO loq_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Na wɔ na ɓɛ̀ɛ ngakye: Aaɓatenela ɓolombe izele. Kasi waa moya Ŋwana wa Moto, amoyazwa ianola o mokyisi?» ");
INSERT INTO loq_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Mokɔlɔ mɔnɔmɔ, Yesu amba ya kpa ete eye phɔ ya ɓato ɓaa miwɛnɛ ɓato ɓa ɓosembo o miyo ma Ŋwaphongo, ɓaawɛnɛ ɓato ɓayɔkɔ pha, yokye: ");
INSERT INTO loq_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«Ɓato ɓaɓale ɓakyɛkyɛ ɓondɛlɛ o Tempelo, mɔnɔmɔ aɓaka mofalisayi, omoyɔkɔ mophutise wa mputi. ");
INSERT INTO loq_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Mofalisayi amɓa kyɛ tɛmɛ o ɓoo pha ɓato ɓasɔ, amba ɓɔndɛlɛ o motema yokye: “Oo Ŋwaphongo, naephɛ mɛlɛsi phɔ sili ya ɓato ɓaayɔkɔ, ɓɛ́ɛ ɓali ɓaibi, ɓato ɓate ɓali na ɓosembo, ɓakyesi ɓa phemba, naa ɓooli mophutise wa mputi mɔna. ");
INSERT INTO loq_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Na pɔsɔ yɔnɔyɔ na miime ntoma mɓala iɓale. Onte ya mbolo isɔ iikyizwe nga, na emanyisa ekpele yɔnɔyɔ onte ya iko.” ");
INSERT INTO loq_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Mophutise wa mputi yo atɛmi nde na itakye, taikaka zinga na itomba miyo o ikolo, kasi aɓaka kamiwande nde o ɓontolo, kawɔ yokye: “Oo Ŋwaphongo inzokye ngɔngɔ, nga moto wa masumu.” ");
INSERT INTO loq_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Nawɔ na ɓɛ̀ɛ ngakye: Waabutwa mophutise wa mputi o ingambi sɛ, aɓaka moto wa ɓosembo o miyo ma Ŋwaphongo, kasi mofalisayi phe. Phɔ moto munsɔ ookomitombe ɓaamuya. Kasi ookomiuya ɓaamotomba.» ");
INSERT INTO loq_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ɓato ɓamba yelela Yesu ɓana ɓakyɛ phɔ aɓatandele maɓɔkɔ. Waawɛnɛ ɓaekosi ɓaɓona, ɓatataka iɓaoya. ");
INSERT INTO loq_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Kasi Yesu amba ya ɓanga ɓana ɓakyɛ oli yo, amba ya wɔ yokye: «Lɛ ɓana ɓakyikyi ɓaye oka nga! Saɓakatela, phɔ Ɓokonzi pha Ŋwaphongo ɓoli phɔ ya ɓato ɓali ɓooli ɓɛ. ");
INSERT INTO loq_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nde phɛlɛ naewɔlɛ ngakye: Ɓo moto tayambi Ɓokonzi pha Ŋwaphongo ndokolo ŋwana mokyɛ phe, takokyi inyɔlɔ omɔ.» ");
INSERT INTO loq_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Mokonzi mɔnɔmɔ wa ɓayuda amba ya tuna Yesu yokye: «Moteye o molaa, nakyele ɓo phɔ na zwe ɓɔmɔɔ pha ɓoɓɛlɛ na ɓoɓɛlɛ?» ");
INSERT INTO loq_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesu amba ya mobuyisa yokye: «Phɔ ya'ye kontangye moto molaa? Moto molaa tali, ɓo teeɓe nde Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Koeɓe miɓeko: “Sakyela ɓaphemba, saɓoma moto, saiɓa, satɛmɛ ɓonzoka pha ɓɔɔlɛ, kumola nyɔngɔ na ɔngɔ.”» ");
INSERT INTO loq_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Moto owa ezwele amba mobuyisa yokye: «Natosa miɓeko misɔ maamina tata ɓoŋwana pha nga.» ");
INSERT INTO loq_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Waa oka Yesu ɓaɓona, amba ya wɔ nɛ yokye: «Kyeezangye ekpele yɔnɔyɔ: Kyɛ ungya mbolo ya wɛ isɔ, okaɓele ɓaɓola ɓana ɓaphalanga. Wamozwa ezwele o ikolo; emba yaka ya mbengye.» ");
INSERT INTO loq_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Waaoka moto wa ezwele mɛ ɓaɓona, amba butwa na ngɔngɔ, phɔ aɓaka na ezwele iikye. ");
INSERT INTO loq_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Waawɛnɛ Yesu oɓokye moto mɛ abuto na ngɔngɔ, amba ya wɔ yokye: «Wali kamba phɔ ya ɓato ɓa ezwele inyɔlɔ o Ɓokonzi pha Ŋwaphongo! ");
INSERT INTO loq_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Phɛlɛ wali kamba phɔ ya Shamo inyɔlɔ o iluu sa sɔlu, kasi wambi kula ɓa nkamba koleka phɔ ya moto wa ezwele inyɔlɔ o Ɓokonzi pha Ŋwaphongo.» ");
INSERT INTO loq_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ɓato ɓaaɓaka ɓamokye ɓamba wɔ ɓɛkye: «Emba owamba bika nza?» ");
INSERT INTO loq_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesu amba buya yokye: «Maphɔɔ maate maakokye ɓato ikyela, Ŋwaphongo kamakyele.» ");
INSERT INTO loq_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Petelo amba ya wɔ na Yesu yokye: «Okyemela, ɓanga toika ika isɔ yaɓaka na ɓanga phɔ ya ieɓenga.» ");
INSERT INTO loq_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesu amba ya wɔ na ɓɛ́ɛ yokye: «Nde phɛlɛ, na wɔ na ɓɛ̀ɛ, ɓo moto aikyi ika ingambi, ŋwaŋwasi, ɓana nyango, ɓaɓoti, ɓana phɔ ya Ɓokonzi pha Ŋwaphongo, ");
INSERT INTO loq_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","moto mɛ amozwa mbolo nzikye koleka o imbɛlɛ sisi, emba o nkɔlɔ yaamoyaa amba zwa ɓomɔɔ pha ɓoɓɛlɛ na ɓoɓɛlɛ.» ");
INSERT INTO loq_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu aesi yakpa ɓaekosi ɓɛ̀ɛ iko mbuka ɓaɓale, amba ya wɔ na ɓɛ́ɛ yokye: «Okyemela, uŋwaŋwa eye tokyɛndɛ o Yelusalɛmɛ, omɔ, maphɔɔ masɔ makoma ɓaumosi ɓa Ŋwaphongo phɔ ya Ŋwana wa Moto mamokokyisama. ");
INSERT INTO loq_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Phɔ ɓaamoambya o maɓɔkɔ ma ɓato ɓamasumu, ɓaamoɛkyɛ, ɓaamotola, ɓaamotowa matee; ");
INSERT INTO loq_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","waamounva ɓɛ́ɛ imobinda phimbo, ɓaamoɓoma, emba sima ya nkɔlɔ iyato amokundwa.» ");
INSERT INTO loq_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Kasi ɓaekosi teɓaikaka sɔsɔlɔ ntina ya maphɔɔ mɛ, teɓaikaka eɓa na yaunvaka wɔ Yesu. ");
INSERT INTO loq_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Waakoma Yesu phɛnɛphɛ na Yeliko, moto mɔnɔmɔ owa phɔlɔ miyo, azalaka o imbale ya nzela phɔ ya ionga ɓaalekane. ");
INSERT INTO loq_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Waaoka yo tɔkɔ ya moluku ŋwa ɓato ɓalekane, amba ya tuna yokye: «Eni ɓa lowɔ iye?» ");
INSERT INTO loq_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ɓamba mobuyisa ɓɛkye: «Kyelekane Yesu owa Nazalɛtɛ.» ");
INSERT INTO loq_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Emba amba yaaŋwana yokye: «Yesu, Ŋwana wa Davidi, inzokye ngɔngɔ!» ");
INSERT INTO loq_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ɓato ɓaaɓaka ɓatambule o ɓoo, ɓamba mozibisa phɔ aikale ɓose, kasi yo amba kula yaaŋwana nde na ɓokusi yokye: «Ŋwana wa Davidi, inzokye ngɔngɔ!» ");
INSERT INTO loq_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesu amba ya tɛmɛ, amba ya onga oɓokye ɓamoyelele nɛ. Waakoma moto owa phɔlɔ miyo phɛnɛphɛ na Yesu amba motuna yokye: ");
INSERT INTO loq_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«Kozingye oɓokye na ekyele iye?» Moto owa phɔlɔ miyo yokye: «Nkolo, kyela oɓokye nakule wɛnɛ!» ");
INSERT INTO loq_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesu amba ya wɔ nɛ yokye: «Kula wɛnɛ! Ianola sa wɛ siebikye.» ");
INSERT INTO loq_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Mina wamɔ, moto mɛ abuto iwɛnɛ, abuto iɓenga Yesu naikyɛmikumbela Ŋwaphongo. Waawɛnɛ ɓato ɓasɔ ɓaaɓona, na ɓɛ́ɛ ɓabutwaka ikyɛmikumbela Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Waanyɔlɔ yo o Yeliko, Yesu amba tamba mokyisi. ");
INSERT INTO loq_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Moto monɔmɔ aɓaka omɔɔ nkomo yɛ Zakayo, aamba ya tɔkɔlɔ; yo aɓaka mɔnɔmɔ na ɓakonzi wa ɓa phutise ɓa mputi, na moto wa ezwele iikye. ");
INSERT INTO loq_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Alukaka iwɛnɛ Yesu, kasi ɓo waɓaka yo mokuwe, taikaka koka imowɛnɛ phɔ ya moluku ŋwa ɓato. ");
INSERT INTO loq_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Wawɛnɛ yo ɓaɓona, amba kyilingana o ɓoo, akyɛ baa o ikolo sa ŋwete ŋwa sikɔmɔlɛ, phɔ waa moyalekana Yesu wamɔ, amowɛnɛ na ɓolaa. ");
INSERT INTO loq_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Waakoma Yesu o elele mɛ, amba tomba miyo o ikolo, amba ya wɔ nɛ yokye: «Zakayo, uta mizele: Phɔ nasengyesi lɔlɔ ikyɛ ɓaa o ingambi sa wɛ.» ");
INSERT INTO loq_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zakayo amba ya uta izele, amba moyamba o ingambi sɛ na nkyisa. ");
INSERT INTO loq_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ɓato ɓasɔ ɓaawɛnɛkyɛ lowɔ mɛ, te ɓaikaka sepela na lango, ɓamba wɔ ɓɛkye: «Akyɛ ɓaa nde oka moto wa masumu!» ");
INSERT INTO loq_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Kasi Zakayo amba ya susana o ɓoo pha Nkolo, amba ya wɔ nɛ yokye: «Nkolo, okyemela, nakaɓe mbolo ya nga na miɓale, naphɛ ɓaɓola ndambo eyɔkɔ. Ɓo nakpesi moto ɓaphalanga ɓaikye na malondo maɓe, namobuyisele ɓɛ́ɛ mbala ine.» ");
INSERT INTO loq_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Emba Yesu amba wɔ phɔ yɛ yokye: «Lɔlɔ eye, ibikyi siesi o ingambi sisi, phɔ na wɛ, oli ŋwana wa iɓota sa Abalayama mɛ. ");
INSERT INTO loq_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Phɔ Ŋwana wa Moto aesi yaluka ná iya bikya ɓato ɓaabunga.» ");
INSERT INTO loq_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Yesu ambakula ya kpela ɓato ɓaokaka maphɔɔ mamana ete esuu. Phɔ waaɓa yo phɛnɛphɛ na Yelusalɛmɛ, ɓato ɓaumunyaka oɓokye Ɓokonzi pha Ŋwaphongo pha mowɛnɛnɛ nde mina wamɔ. ");
INSERT INTO loq_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Emba Yesu amba ya wɔ yokye: «Moto mɔnɔmɔ wa iɓota sa ɓokonzi akyɛkyɛ o mokyisi mɔnɔmɔ itakye phɔ ɓamokyele mokonzi, sima amba kula ya butwa. ");
INSERT INTO loq_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","O ɓoo pha ikyɛndɛ, amba ya ɓanga ɓaombo iko mi ɓaombo ɓɛ, aesi yaɓakaɓela moto na moto ebuni yɔnɔyɔ ya wolo ya motiya moikye, amba ya wɔ na ɓɛ́ɛ yokye: “Kyela mumbongu na ɓaphalanga ɓaaɓana, tee nɔnɔ wa moya nga.” ");
INSERT INTO loq_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Kasi ɓato ɓa mokyisi nwɛ ɓamoinaka, ɓamotomelaka ɓato phɔ ya ikyɛ wɔ nɛ oɓokye: “Toloanole oɓokye aɓe mokonzi ŋwa ɓanga.” ");
INSERT INTO loq_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Waamokyela ɓɛ́ɛ mokonzi, amba ya butwa o mokyisi nwɛ. Amba ya ɓanga o ɓoo phɛ ɓato ɓa etoma ɓakaɓelaka yo ɓaphalanga phɔ ya iyeɓa ɓookose moto mɔnɔmɔ na mɔnɔmɔ ɓaphalanga ɓaazwaka yo. ");
INSERT INTO loq_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Owa o ɓoo amba ya wɔ yokye: “Nkolo, eɓende ya ɓaphalanga yɔnɔyɔ eya mpɛkyɛ wɛ eɓoti biɓende iko ba wolo.” ");
INSERT INTO loq_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Nkolo amba ya wɔ yokye: “Ɓolaa, moto wa etoma o molaa. Okyesi ɓolaa o maphɔɔ makyikyi, na moebuya mokonzi wa nkyisi iko iinɛnɛ.” ");
INSERT INTO loq_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Owa iɓale amba ya wɔ yokye: “Nkolo, eɓende ya ɓaphalanga yɔnɔyɔ eya mpɛkyɛ wɛ, eɓoti biɓende bitano ba wolo.” ");
INSERT INTO loq_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Nkolo amba ya wɔ nɛ yokye: “Iwɛ, na moebuya mokonzi ŋwa nkyisi itano iinɛnɛ.” ");
INSERT INTO loq_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Oomoyɔkɔ amba ya wɔ yokye: “Nkolo, kyeka eɓende ya wɛ yɔnɔyɔ ya ɓaphalanga yango eye, na ezingaka na itambala, namba eɓomba. ");
INSERT INTO loq_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Naɓaka na ile, phɔ oli moto mɔnɔmɔ wa nkamba, kokpe mbolo yateyaikaka wɛ langya, konɔkɔ o elele eteyikaka wɛ phika.” ");
INSERT INTO loq_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Nkolo amba ya mobuyisa yokye: “Oli moto wa etoma moɓe, namoesambisa nde na maloɓa ma wɛ mampenza. Waeɓaka oɓokye nga nali moto mɔnɔmɔ wa nkamba, nakpe mbolo yateyaikaka nga langya, nanɔkɔ o elele eteyaikaka nga phika. ");
INSERT INTO loq_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ka phɔ ya'ye toikaka kyɛ ɓomba ɓaphalanga ɓanga naɓo o bankyi? O iyabutwa sa nga nde naesi ya ɓazwa na matabisi.” ");
INSERT INTO loq_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ɓoɓɛlɛ nkolo amba ya wɔ na ɓato ɓaaɓaka wamɔ yokye: “Omoɓɔlɔlɔ eɓende ya wolo mɛna, oephɛ oli na biɓende iko.” ");
INSERT INTO loq_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ɓato ɓamba ya wɔ nɛ ɓɛkye: “Mokonzi, yo nga ali na ɓɛ̀ɛ ikoo!” ");
INSERT INTO loq_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Nkolo amba ya ɓabuyisa yokye: “Nawɔ na ɓɛ̀ɛ, moto ooli na ɓanaa mbolo, ɓamokula moɓakyisa mbolo nsuu. Ka ooli pha, ɓa moɓɔlɔlɔ na ŋwana ndambo ooli nɛ. ");
INSERT INTO loq_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Phɔ ya ɓanguna ɓa nga, ɓato ɓate ɓaikaka zinga oɓokye nga naɓe mokonzi ŋwa ɓɛ, yaka na ɓɛ́ɛ wawa, emba oɓatene nyɛsi o miyo ma nga!”» ");
INSERT INTO loq_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Waaunva yo iwɔ ɓaɓona, Yesu aesi ya tambula o ɓoo phɔ ya ikyɛndɛ o Yelusalɛmɛ. ");
INSERT INTO loq_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Waakoma yo phɛnɛphɛ na Ɓetefaze na Ɓetani, mbale ya ngomba ya ɓa olive, amba ya toma ɓaekosi ɓɛ́ɛ ɓaɓale ");
INSERT INTO loq_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","amba ya wɔ na ɓɛ́ɛ yokye: «Kyɛndɛ o mokyisi mokyekane na ɓanga; waamokoma ɓɛ̀ɛ omɔ, wamokyɛndɛ wɛnɛ ŋwana wa mpunda atingyi, naino moto taɓaa miyango. Oeyingole, oye na yango wawa. ");
INSERT INTO loq_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ka ɓo moto mɔnɔmɔ aetuni oɓokye: “Koeyingole phɔ ya'ye?” Omobuyisa oɓokye: “Phɔ Nkolo asengyesi na yango.”» ");
INSERT INTO loq_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ɓoɓɛlɛ ɓaekosi mɛ ɓaɓale ɓamba ya kyɛndɛ, ɓakyɛ takana maphɔɔ masɔ nde ɓowawɔkɔ Yesu na ɓɛ. ");
INSERT INTO loq_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Waaɓa ɓɛ́ɛ ɓaingole ŋwana wa mpunda, ɓa kolo mpunda ɓamba ɓatuna ɓɛkye: «Koingole ŋwana wa mpunda mɔna phɔ ya'ye?» ");
INSERT INTO loq_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ɓaekosi ɓamba buya ɓɛkye: «Phɔ Nkolo asengyesi na yango.» ");
INSERT INTO loq_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ɓamba yakyɛ na ŋwana wa mpunda mɛ ooli Yesu, ɓamba ya wala bitobu ɓa ɓɛ́ɛ o ikolo sa ŋwana wa mpunda mɛ, ɓamba yabayisa Yesu. ");
INSERT INTO loq_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Waaɓa yo kotambule, ɓato ɓaɓaka ɓakyɛmiwala bitobu o nzela. ");
INSERT INTO loq_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Waakoma yo phɛnɛphɛ na nzela ekyeute o ngomba ya ɓaolive, ɓaekosi ɓasɔ ɓatondaka na nkyisa, ɓabutwaka ikumbela Ŋwaphongo na nyɛsi ikolo phɔ ya bilekyesako bisɔ biawɛnɛkyɛ ɓɛ. ");
INSERT INTO loq_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ɓawɔkɔ ɓɛkye: «Apambolame, mokonzi ookoye na nkombo ya Nkolo! Ɓose ɓoɓe o ikolo, nkyɛmɔ iɓe o bilele biilekyi Ikolo!» ");
INSERT INTO loq_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ɓafalisayi ɓaayɔkɔ, ɓaaɓaka onte ya ɓato, ɓamba ya wɔ na Yesu ɓɛkye: «Moteye, katela ɓaekosi ɓa wɛ!» ");
INSERT INTO loq_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesu amba ya buya yokye: «Na wɔ na ɓɛ̀ɛ ngakye: Ɓo ɓɛ́ɛ ɓaikasi ɓose, maɓanga mamoaŋwana.» ");
INSERT INTO loq_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Waakoma Yesu phɛnɛphɛ na Yelusalɛmɛ, waamowɛnɛ yo, amba lela phɔ ya ŋwango. ");
INSERT INTO loq_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Awɔkɔ yokye: «Ɓo na wɛ waeɓaka mɛ, o mokɔlɔ ŋwa lɔlɔ, ndengye eekokyi wɛ izwa ɓose…! Kasi uŋwaŋwa eye, maphɔɔ mɛ maɓombami phɔ ya wɛ, tokokyi imawɛnɛ! ");
INSERT INTO loq_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Phɔ nkɔlɔ yaamoya, ɓanguna ɓawɛ ɓamoelungya, ɓamoetɛyisa lophango, ɓamba etɔkɔlɛlɛ mbɔmbɔ isɔ. ");
INSERT INTO loq_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ɓamoeɓola, iwɛ na ɓana ɓa wɛ, etewaikale iɓanga sɔnɔsɔ o ikolo sa siiyɔkɔ, phɔ toika eɓa imbɛlɛ sayakaka yaebikya Ŋwaphongo.» ");
INSERT INTO loq_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ɓoɓɛlɛ Yesu amba ya nyɔlɔ o Tempelo abuto iwiinya ɓaaɓaka ɓaungya. ");
INSERT INTO loq_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Amba ya wɔ na ɓɛ́ɛ yokye: «Wakomama ɓoɓo: “Ingambi sa nga samoɓa ingambi sa losambo”. Kasi ɓɛ̀ɛ osibuye iɓombo sa ɓaibi!» ");
INSERT INTO loq_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Nkɔlɔ isɔ, aɓaka kateya o Tempelo. Ɓakonzi ɓa ɓanganga ɓa Ŋwaphongo, ɓateye ɓa miɓeko na ɓa nkumu ɓa mokyisi, ɓalukaka imoɓoma; ");
INSERT INTO loq_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","kasi teɓaikaka eɓa ndengye eekokyi ɓɛ́ɛ ikyela, phɔ ɓato ɓasɔ ɓalɛkyɛkyɛlɛkyɛ nde mi imooka. ");
INSERT INTO loq_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Mokɔlɔ mɔnɔmɔ, waɓa Yesu kateya o Tempelo na iimola ɓato Simo Elaa, ɓakonzi ɓa ɓanganga ɓa Ŋwaphongo, na ɓateye ɓa miɓeko na ɓankumu, ɓamba ya wali yo. ");
INSERT INTO loq_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ɓamba motuna ɓɛkye: «Oloimole, kokyele maphɔɔ mamana na ɓokonzi iye? Owa ephɛ ɓokonzi mɛ nza?» ");
INSERT INTO loq_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesu amba ya ɓabuyisa yokye: «Na nga naetune nde motuna mɔnɔmɔ. Onzimole: ");
INSERT INTO loq_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Iɓatisi sa Yoane, sautaka o ikolo nde na ɓato?» ");
INSERT INTO loq_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ɓamba wɔnɔ ɓɛ́ɛ na ɓɛ́ɛ ɓɛkye: «Ɓo tobuye oɓokye: “Sautaka o ikolo”, amowɔ oɓokye: “Phɔ ya'ye toikaka moanola?” ");
INSERT INTO loq_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ka ɓotoni buya oɓokye: “Sautaka na ɓato”, ɓato ɓasɔ ɓaalomaa maɓanga, phɔ ɓaanole oɓokye Yoane ali moimosi wa Ŋwaphongo.» ");
INSERT INTO loq_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Emba ɓamba buya ɓɛkye teɓaeɓe biwautaka sango. ");
INSERT INTO loq_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ɓoɓɛlɛ Yesu amba ya wɔ na ɓɛ́ɛ yokye: «Na nga mɛ esieyimole naa na ɓokonzi ye nakyele maphɔɔ maamana.» ");
INSERT INTO loq_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ɓoɓɛlɛ Yesu amba butwa ikpela ɓato ete eye: «Moto mɔnɔmɔ aphikaka vinyɔ o inzabi. Aikyi siika na ɓato ɓasiphutele, yo akyɛ o imbanga sa ikɔkɔ. ");
INSERT INTO loq_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Waakoma imbɛlɛ sa inɔkɔ mbuma, nkolo wa inzabi aesi ya toma moombo wɛ oka ɓato ɓaaphutele inzabi oɓokye akyɛ mokpela iyalo sɛ. Kasi ɓaphutesi inzabi, ɓamokutubi, ɓamobuye maɓɔkɔ pha. ");
INSERT INTO loq_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Mokolo ŋwa inzabi akuli ya toma moombo mosuu. Kasi na mɔɔna, ɓaaphutele inzabi ɓamokutubi, ɓamotosi, ɓaambi na mobuya maɓɔkɔ pha. ");
INSERT INTO loq_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Mokolo ŋwa inzabi amba kula toma moombo wa etoma owa iyato, nɛ mɔɔna, ɓaphutele inzabi ɓamba mozokya, ɓamba mowiinya. ");
INSERT INTO loq_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Emba mokolo inzabi amba ya miwɔlɛ yokye: “Na kyele ɓo? Na motoma ŋwana wa nga owa lozingo. Iyo, ɓaamotosa.” ");
INSERT INTO loq_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Kasi, waamowɛnɛ ɓaaphutele inzabi, ɓamba ya wɔnɔ onte ya ɓɛ́ɛ ɓɛkye: “Kyeka ndomi yɛ owamoikala na sina inzabi, ɓo ango awe. To moɓome phɔ inzabi mɛ sibutwe sa ɓanga!” ");
INSERT INTO loq_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ɓamba ya kyɛ movaka o sɛlɛkyɛ ya inzabi, ɓamba moɓoma. Yesu amba ya ɓatuna yokye: “Mokolo inzabi aaɓakyela ɓo?” ");
INSERT INTO loq_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Amoya ɓoma ɓaaphutele inzabi, amba siphɛ ɓato ɓasuu.» Waaoka ɓato ɓaɓona, ɓamba wɔ ɓɛkye: «Phe, ete wakyelame!» ");
INSERT INTO loq_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Kasi Yesu amba ɓakyeka o maɓoo, amba ya wɔ na ɓɛ́ɛ yokye: «Maphɔɔ makoma ɓɛ́ɛ o buku pha Ŋwaphongo mama, malukye iwɔ ɓo? Iɓanga saavakaka ɓatongyi ɓa mangambi, nde sango sibuto iingo ephisi ingambi sisɔ. ");
INSERT INTO loq_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Moto munsɔ owa mokaa o ikolo sa sina iɓanga, amokyɛmitenya binango, emba owamokalela iɓanga mɛ amophitingana.» ");
INSERT INTO loq_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ɓateye ɓa miɓeko na ɓakonzi ɓa ɓanganga ɓa Ŋwaphongo, ɓaeɓaka oɓokye ete mɛna, Yesu aekpesi ɓɛ. Yango mɛna ɓalukaka malondo ma imwakya nde wamɔ. Kasi ɓailaka ɓato. ");
INSERT INTO loq_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Yango mɛna ɓamba tata imokyɛngyɛ, ɓamotomelaka ɓaŋwasanyɔlɔ ɓaawɛnɛnɛ ndokolo ɓato ɓalaa, phɔ na maloɓa mɛ mampenza, ɓamozwe na eleko ya imoambya o maɓɔkɔ na moangyesi. ");
INSERT INTO loq_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ɓaesi ya motuna motuna mumu: «Moteye, toeɓe oɓokye iikyi wɔ wɛ na iikyi teya wɛ ili nde ya phɛlɛ, watene wɛ ɓolombe tokyekye ɓoo pha moto. Kasi koteya nde o phɛlɛ nzela ya Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Taa loimola, miɓeko miphɛ nzela oɓokye tophute mputi ya Kaisala?» ");
INSERT INTO loq_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Kasi Yesu aeɓaka oɓokye ɓazite maphɔɔ masuu, amba ya wɔ na ɓɛ́ɛ yokye: ");
INSERT INTO loq_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«Inteya mpata yɔnɔyɔ ya eɓende. Ɓoo na nkombo eya koma ɓɛ́ɛ o eɓende eye ya nza?» Ɓamba ya mobuyisa ɓɛkye: «Ya Kaisala.» ");
INSERT INTO loq_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Emba Yesu amba ya wɔ na ɓɛ́ɛ yokye: «Buyisa Kaisala yaaka Kaisala, emba Ŋwaphongo yaaka Ŋwaphongo.» ");
INSERT INTO loq_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ɓoɓɛlɛ teɓaikaka koka na imoakya phɔ ya maloɓa mɛ mampeza, kasi ɓakamwaka na eyano yɛ, ɓamba ikala ɓose. ");
INSERT INTO loq_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ɓasadukayi ɓaayɔkɔ ɓamba ya oli Yesu. Ɓɛ́ɛ ɓasadukayi ɓawɔ oɓokye, ɓato ɓaawa ete ɓakundwe. Ɓamba tuna Yesu motuna mumu: ");
INSERT INTO loq_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«Moteye, Mose alokomela o buku pha miɓeko ɓoɓo: “Ɓo moto mɔnɔmɔ ali na mosi, alonga ŋwaŋwasi, yo ambi waa saika ɓota nɛ, esengyesi oɓokye mosi nyɛ azasa ɓozengye ɓaɓona phɔ aɓotele ɓola phɛ owa waa ɓana.” ");
INSERT INTO loq_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Yaɓaka ɓaɓona o mokyisi mɔnɔmɔ, ɓana ɓa ɓampele sambo ɓaɓaka ɓɛ́ɛ ɓasɔ nyango mɔnɔmɔ ango mɔnɔmɔ, ɓola pha ɓɛ́ɛ aesi ya longa ŋwaŋwasi, awe sa ɓota nɛ. ");
INSERT INTO loq_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Owa iɓale aesi ya zasa ɓozengye mɛ, akuli waa, saɓota nɛ. ");
INSERT INTO loq_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Na owa iyato akuli ɓozasa, nɛ awe saɓota nɛ, nde ɓomɔ ɓɛ́ɛ ɓasɔ sambo, ɓawe saɓota nɛ. ");
INSERT INTO loq_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","O sima ya ɓɛ́ɛ ɓasɔ, ɓozengye mɛ nɛ amba ya waa. ");
INSERT INTO loq_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ka mokɔlɔ ŋwa mokundwa ɓawe, onte ya ɓɛ́ɛ ɓasɔ sambo amoɓa ŋwaŋwasi wa nza? Phɔ ɓɛ́ɛ ɓasɔ ɓamozasaka.» ");
INSERT INTO loq_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesu amba ya wɔ na ɓɛ́ɛ yokye: «Ɓato ɓa mokyisi mumu, ɓaɓasi na ɓampele ɓalongane. ");
INSERT INTO loq_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Kasi ɓaawɛnɛ Ŋwaphongo oɓokye ɓali ɓato ɓa ɓosembo, na waamokundwa ɓawe eteɓalongane. ");
INSERT INTO loq_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Teɓakokyi ikula waa phɔ ɓabuto ndokolo ɓaanzelu. Ɓali ɓana ɓa Ŋwaphongo, phɔ ɓakundoo. ");
INSERT INTO loq_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Oɓokye ɓaawa ɓamokundwa, Mose yo mampenza alowokɔ o isolo sa ŋwete moolole sazika, wa ɓanga yo Nkolo, Ŋwaphongo wa Abalayama, Ŋwaphongo wa Izake na Ŋwaphongo wa Yakoɓo. ");
INSERT INTO loq_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ŋwaphongo tali Ŋwaphongo wa ɓawe kasi wa ɓato ɓali na ɓomɔɔ, phɔ ɓato ɓasɔ ɓali na ɓomɔɔ phɔ yɛ.» ");
INSERT INTO loq_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ɓateye ɓa miɓeko ɓaayɔkɔ, ɓamba ya wɔ na Yesu ɓɛkye: «Moteye, owɔ na ɓolaa.» ");
INSERT INTO loq_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Phɔ teɓakulaka meka imotuna motuna mosuu. ");
INSERT INTO loq_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Emba Yesu amba ya wɔ na ɓɛ́ɛ yokye: «Ndengye'ye ɓakokyi iwɔ oɓokye, Masiya ali Ŋwana wa Davidi? ");
INSERT INTO loq_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Phɔ Davidi yo mampenza kawɔ o buku pha Meembo yokye: “Nkolo awɔ na Nkolo wa nga: Zala o ɓoloo pha nga, ");
INSERT INTO loq_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","nɔnɔ waamouya nga ɓanguna ɓa wɛ, o se ya mokolo ma wɛ.” ");
INSERT INTO loq_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Kyeka, Davidi kamoɓangye Nkolo. Emba, ndengye'ye ambi kula ɓa ŋwana wɛ?» ");
INSERT INTO loq_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Amba wɔ na ɓaekosi ɓɛ́ɛ o miyo ma ɓato ɓasɔ ɓaaɓaka ɓamookye yokye: ");
INSERT INTO loq_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Ɓɛ̀ɛ nde kokyeɓe na ɓateye ɓa miɓeko. Ɓɛ́ɛ ɓazingye ikyɛmitambula na bitobu bianda, ɓambe nazinga oɓokye ɓaɓaɓeya o bilele biangane ɓato ɓaikye, ɓaɔlɔ biziye ɓa o ɓoo o mangambi ma losambo na bilele ɓa o ɓoo o bisɛlɛkɔ. ");
INSERT INTO loq_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ɓaiyele mazengye na mbolo ya ɓɛ, ɓaɓɔndɛlɛ maɓɔndɛsi maanda phɔ ya iteya oɓokye ɓali ɓato ɓa ɓosembo. Yango mɛnɛ, Ŋwaphongo aaɓaphɛ etumbu yɔnɔyɔ eya moleka ɓonɛnɛ.» ");
INSERT INTO loq_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Waatomba yo miyo, Yesu aesi ya wɛnɛ ɓato ɓa ezwele ɓakyɛ ambya makaɓo o ekɔkɔlɔ o Tempelo. ");
INSERT INTO loq_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Aesi ya wɛnɛ na ɓozengye ɓɔnɔɓɔ moɓola, aesi ya langya mpata iɓale ya biɓende. ");
INSERT INTO loq_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Yesu amba ya wɔ yokye: «Nde phɛlɛ na wɔ na ɓɛ̀ɛ ngakye, ŋwaŋwasi ɓozengye moɓola oyo, ambye ileka ɓato ɓasɔ. ");
INSERT INTO loq_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Phɔ ɓɛ́ɛ ɓasɔ ɓaɓana ɓambye nde ɓaphalanga ɓateɓali na ɓɛ́ɛ na ntina. Kasi yo, na ɓoɓola phɛ ambye nde ɓaphalanga ɓasɔ ɓaaɓaka nɛ phɔ ya ibika.» ");
INSERT INTO loq_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Waaɓa ɓato ɓaayɔkɔ ɓawɔ phɔ ya Tempelo, ndengye eya sitonga ɓɛ́ɛ na maɓanga malaa, na ná mbolo ya phɛkyɛ ɓɛ́ɛ Ŋwaphongo, Yesu amba ya wɔ yokye: ");
INSERT INTO loq_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«Isɔ ikyi wɛnɛ ɓɛ̀ɛ iye, nkɔlɔ ya moyaa, ete wa ikale iɓanga sɔnɔsɔ o ikolo sa siiyɔkɔ: Isɔ ɓamoiyuwola.» ");
INSERT INTO loq_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Emba ɓamba motuna ɓɛkye: «Moteye, maphɔɔ mɛ mamokyelama imbɛlɛ iye? Tomba na eɓa na elembo oɓokye maphɔɔ mɛ malukye ikyelama?» ");
INSERT INTO loq_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesu amba ya buya yokye: «Nde kokyeɓe oɓokye moto saekosa, phɔ ɓato ɓaikye ɓamoya na nkombo ya nga, ɓamowɔ ɓɛkye: “Eli nga!” na: “Imbɛlɛ mɛ sikokyi!” Saɓaɓenga. ");
INSERT INTO loq_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Wamooka ɓɛ̀ɛ masimo ma mabita, na ma itɔmbɛlɛ ɓakonzi, ɓɛ́ɛ sa ilaa. Phɔ esengyesi oɓokye maphɔɔ mamana mata kyelama phanza, kasi mɛna etetaaɓa suka ya mokyisi.» ");
INSERT INTO loq_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ɓoɓɛlɛ Yesu amba ya wɔ na ɓɛ́ɛ yokye: «Ekolo yɔnɔyɔ ya muŋwana na ekolo eyɔkɔ, ɓokonzi ɓɔnɔɓɔ pha muŋwana na ɓokonzi ɓoyɔkɔ. ");
INSERT INTO loq_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","O bilele bikye, manyɛtɛ ma munyingana, bisenzo na zilo sikusi ya moɓa, maphɔɔ ma inganga mamouta o ikolo na bilembo binɛnɛ biamowɛnɛnɛ.» ");
INSERT INTO loq_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","«Kasi o ɓoo pha maphɔɔ masɔ mamana, ɓamoeyakya ɓamba na enyɔkɔlɔ; ɓamoesambisa o mangambi ma makyita, ɓamoenyɔsa o ɓɔlɔkɔ ɓamokyɛ na ɓɛ̀ɛ o ɓoo pha ɓakonzi na ɓaangyesi ɓa mokyisi phɔ ya nkombo ya nga. ");
INSERT INTO loq_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Yango mɛna ɓɛ́ɛ wamoɓa manzoka ma nga. ");
INSERT INTO loq_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Oeɓaka oɓokye tosengyesi na iɓɔngya ɓo wamosamba ɓɛ̀ɛ. ");
INSERT INTO loq_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Phɔ, nga, na moephɛ munɔkɔ na zebi sa oɓokye moto okoephunde takokyi ieyikyela ziko. ");
INSERT INTO loq_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Eɓe ɓaɔngɔ na ɓanyɔngɔ, ɓanaa nyɔngɔ, ɓaa iɓota sa wɛ, na bikamba ɓa ɓɛ̀ɛ ɓamoekaɓa, ɓamoingya ɓaikye onte ya ɓɛ̀ɛ. ");
INSERT INTO loq_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ɓato ɓasɔ ɓamoeyina phɔ ya nkombo ya nga; ");
INSERT INTO loq_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","kasi na munsuwe mɔnɔmɔ ŋwa moto ŋwa ɓɛ̀ɛ ete moobiya. ");
INSERT INTO loq_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Nde na ilendendala sa ɓɛ̀ɛ, wamozwa ɓomɔɔ.» ");
INSERT INTO loq_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","«Emba waamowɛnɛ ɓɛ̀ɛ Yelusalɛmɛ alungami na ɓatuluku, oeɓa oɓokye imbɛlɛ sa ɓɔɔtɔnokye phɛ sikokyi. ");
INSERT INTO loq_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Emba, ɓaamoɓa o Yuda, ɓɛ́ɛ elotaka o mangomba, ɓamoɓa onte ya mokyisi, ɓɛ́ɛ etɔkɔlɔ; ɓamoɓa o manzabi, ɓɛ́ɛ saya nyɔlɔ o mokyisi! ");
INSERT INTO loq_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Phɔ yamoɓa nkɔlɔ ya ɓolombe, oɓokye isɔ yakomama o buku pha Ŋwaphongo ikokyisame. ");
INSERT INTO loq_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","O nkɔlɔ mɛ, ngɔngɔ na ɓaɓasi ɓaa ekama ná malekyele, phɔ mampasi makusi mamoɓaa o mokyisi na yɔɔ phɔ ya ɓato mɛ. ");
INSERT INTO loq_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ɓaɓaɓoma na mphata; ɓamokyɛ na ɓɛ́ɛ ntungye o bikolo bisɔ, emba ɓato ɓaate ɓaaeɓe Ŋwaphongo ɓamɔɔtɔ Yelusalɛmɛ tee nɔnɔ waamokoka imbɛlɛ sa ɓɛ.» ");
INSERT INTO loq_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","«Ɓilembo ɓamowɛnɛnɛ onte ya moo, onte ya ɓokombe na ɓa nyasɛɛsi, o munse, ɓato ɓaate ɓaeɓe Ŋwaphongo ɓamoɓa na ngɔngɔ, ɓamotɛkyɛnɛlɛ na ɓɔɓɔ waamowɛnɛ ɓɛ́ɛ maa ma ebale enɛnɛ manyingane. ");
INSERT INTO loq_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ɓato ɓamowaa na ɓɔɔɓɔ pha ilota ɓoɓe phaamokpelemela mokyisi phɔ ɓokusi ɓɔsɔ pha ikolo pha munyingana. ");
INSERT INTO loq_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Emba, ɓamowɛnɛ Ŋwana wa Moto kaye onte ya mampata, na mwiya mwikye na nkyɛmɔ. ");
INSERT INTO loq_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Waamotata maphɔɔ mɛ masɔ ikyelama, omielole otombe moto, phɔ imbɛlɛ sa iyekandola sikomi phɛnɛphɛ.» ");
INSERT INTO loq_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yesu amba kula ɓakpela ete yɔnɔyɔ yokye: «Kyeka ŋwete ŋwa fige na nzete nsuu: ");
INSERT INTO loq_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Wa lɛɓɔlɔ yango, koeɓe ɓɛ̀ɛ mampenza nde na iikyeka oɓokye imbɛlɛ sa ikyɛtɛ sikokyi. ");
INSERT INTO loq_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Nde ɓomɔ, na ɓɛ̀ɛ, wamowɛnɛ ɓɛ̀ɛ maphɔɔ masɔ mamana makyelame, eɓa oɓokye Ɓokonzi pha Ŋwaphongo ɓokomi phɛnɛphɛ. ");
INSERT INTO loq_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Nde phɛlɛ nawɔ na ɓɛ̀ɛ, yoo eye etelekane oɓokye maphɔɔ mamana saɓokyelamakye. ");
INSERT INTO loq_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ikolo na munse yamolekana, kasi maloɓa ma nga etemalekane.» ");
INSERT INTO loq_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","«Nde koɓe na ɓokyɛngyi, phɔ ntema ya ɓɛ̀ɛ saɔtɔnɔ na malanga, ɓisɛlɛkɔ na maumunya ma mokyisi, emba mokɔlɔ mɛ saeɓalikyinya, ");
INSERT INTO loq_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","ndokolo ɓondɛndi; phɔ ŋwa mokpelemela ɓato ɓasɔ ɓali o munse. ");
INSERT INTO loq_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Kasi salala ebuu, ɓɔndɛlɛkyɛ imbɛlɛ sisɔ, phɔ maphɔɔ masɔ mamoya mamana mango saezwa; ombe na tɛmɛ o ɓoo pha Ŋwana wa Moto.» ");
INSERT INTO loq_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yesu aɓaka kalekyinya nzanga o Tempelo phɔ ya iteya emba atɔkɔlɔkɔ waa nkɔkɔlɔ phɔ ya ikyɛ lala o ikolo sa ngomba ekyeɓangye ɓɛ́ɛ ya ɓaolive. ");
INSERT INTO loq_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Emba ɓato ɓasɔ ɓaɓaka ɓaye oka yɛ na moyɛlɔ o Tempelo phɔ ya iya mooka. ");
INSERT INTO loq_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Esɛlɛkɔ ya Ilekana yakomaka phɛnɛnɛphɛ, eli esɛlɛkɔ ya mapa matumbe ɓɛ́ɛ sa munɔ moulole mapa. ");
INSERT INTO loq_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ɓakonzi ɓa ɓanganga ɓa Ŋwaphongo na ɓateye ɓa miɓeko ɓalukaka malondo ma imolɛmɔlɔ phɔ ɓailaka ɓato. ");
INSERT INTO loq_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Emba Molemba amba nyɔlɛlɛ Yudasi okoɓangye ɓɛ́ɛ Isikaliyota, owa ɓaka mɔnɔmɔ onte ya iko mbuka ɓaɓale. ");
INSERT INTO loq_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yudasi akyɛkyɛ okana na ɓakonzi ɓa ɓanganga ɓa Ŋwaphongo na ɓakonzi ɓa ɓakyɛngyɛlɛ Tempelo phɔ ya iluka malondo ma iɓaungyisela Yesu. ");
INSERT INTO loq_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ɓɛ́ɛ ɓaɓaka na nkyisa emba ɓamba okana oɓokye ɓamophɛ ɓaphalanga. ");
INSERT INTO loq_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yudasi amba anola, amba tata iluka imbɛlɛ silaa phɔ ya iɓaungyisela yo ɓato saeɓa. ");
INSERT INTO loq_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Mokɔlɔ ŋwa esɛlɛkɔ ya mapa matumbe ɓɛ́ɛ sa munɔ, ŋwa kokaka, mokɔlɔ moɓome ɓɛ́ɛ ɓana ɓa mampate phɔ ya esɛlɛkɔ ya Ilekana. ");
INSERT INTO loq_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesu amba ya toma Petelo na Yoane, amba wɔ na ɓɛ́ɛ yokye: «Ɓɛ̀ɛ kyɛndɛ lolambela ntoma ya esɛlɛkɔ ya Ilekana, phɔ toze.» ");
INSERT INTO loq_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ɓamba motuna ɓɛkye: «Kozingye oɓokye tokyɛ lamba bi?» ");
INSERT INTO loq_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yesu amba ya ɓabuyisa yokye: «Wamunyɔlɔ ɓɛ̀ɛ o mokyisi, wamovana na moto mɔnɔmɔ aphisi mbongo ya maa. Omoɓengye tee nɔnɔ o ingambi sa munyɔlɔ yo ");
INSERT INTO loq_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ombe wɔ na mokolo ingambi ɓoɓo: “Moteye kaetune oɓokye: Oloteya elele eya mozaa yo ntoma ya esɛlɛkɔ ya Ilekana yo na ɓaekosi ɓɛ?” ");
INSERT INTO loq_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Emba moto mɛ amoeteya elele yɔnɔyɔ eenɛnɛ eya ikolo onte ya ingambi, ɓaunva eɓɔngya na ɓolaa. Olambe ntoma ya esɛlɛkɔ omɔ.» ");
INSERT INTO loq_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ɓaekosi ɓaesi ya kyɛndɛ, ɓakyɛ takana isɔ nde ɓo waɓawɔlɛkyɛ yo, emba ɓamba ɓɔngya ntoma ya esɛlɛkɔ ya Ilekana. ");
INSERT INTO loq_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Waakoka imbɛlɛ sa izaa, Yesu yo na ɓatoma ɓɛ́ɛ ɓaesi ya zala o mesa. ");
INSERT INTO loq_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Amba ya wɔ na ɓɛ́ɛ yokye: «Naɓakyi na phowa ya izaa esɛlɛkɔ ya Ilekana eye na ɓɛ̀ɛ minyamipha o ɓoo pha nga inyɔkɔmɔ! ");
INSERT INTO loq_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Phɔ, nawɔ na ɓɛ̀ɛ, esikule zaa esɛlɛkɔ mɛ mbala esuu tee nɔnɔ wamokoka yango o Ɓokonzi pha Ŋwaphongo.» ");
INSERT INTO loq_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Amba ya kpa kɔphɔ ya vinyɔ, waunva yo iphɛ Ŋwaphongo mɛlɛsi, amba ya wɔ yokye: «Kpa kɔphɔ eye, oenywe ɓɛ́ɛ ɓasɔ. ");
INSERT INTO loq_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Phɔ nawɔ na ɓɛ̀ɛ: Tata lɔlɔ esikule nywa malɛku ma mbuma ya vinyɔ tee nɔnɔ wamoya Ɓokonzi pha Ŋwaphongo.» ");
INSERT INTO loq_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ɓoɓɛlɛ aesi ya kpa ipa, waaunva yo iphɛ Ŋwaphongo mɛlɛsi, asikyɛsi, amba ya ɓaphɛ sango yokye: «Eye eli nzoto ya nga, iambemi phɔya ɓɛ̀ɛ. Nde kokyele ɓomɔ phɔ ya inzumunyaka.» ");
INSERT INTO loq_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Nde ɓomɔ waaunva ɓɛ́ɛ izaa, amba ya kpa kɔphɔ yokye: «Kɔphɔ ya malɛku eye eli ya sangola eenyakune ya malongo manga maamosweye phɔ ya ɓɛ̀ɛ.» ");
INSERT INTO loq_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","«Kasi kyeka: Moto okonzungya, kaze na nga o mesa wawa! ");
INSERT INTO loq_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Phɔ Ŋwana wa Moto amowa ɓo owa unva ɓɔngya Ŋwaphongo. Kasi ngɔngɔ ya moto owa moungya!» ");
INSERT INTO loq_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Emba ɓaekosi ɓamba tata itunana onte ya ɓɛ, phɔ ya iyeɓa nza okokyi ikyela ɓaɓona. ");
INSERT INTO loq_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ɓaekosi ɓamba tata iyika ziko phɔ ya iyeɓa olekyi na ngambo onte ya ɓɛ. ");
INSERT INTO loq_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesu amba ya wɔ na ɓɛ: «Ɓakonzi ɓa nkyisi ɓakyele na makonzi ma ɓɛ́ɛ yaa ɓonkolo, na ɓaakonza nkyisi ɓazingye oɓokye ɓa ɓaɓangakye “ɓato ɓaakyele ɓola”. ");
INSERT INTO loq_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Phɔ ya ɓɛ̀ɛ, yango saɓa ɓaɓona. Kasi oolekyi ɓola onte ya ɓɛ̀ɛ akpe elele ya mosi, emba ookokambe akpe elele ya okoekyelele. ");
INSERT INTO loq_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Moto ozasi o mesa na okomokyelele, olekyi na ngambo nza? Teli ozasi o mesa? Kasi nga, nali onte ya ɓɛ̀ɛ o elele ya okoekyelele. ");
INSERT INTO loq_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ɓɛ̀ɛ oli ɓato ɓaɓaka na nga o minyɔkɔ misɔ ma wɛnɛkyɛ nga. ");
INSERT INTO loq_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Emba nga, naephɛ Ɓokonzi nde ɓo wa ɓompɛ Tata: ");
INSERT INTO loq_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Yango mɛna ɓɛ̀ɛ wamozaa, wamunywa o mesa ma nga o Bokonzi pha nga. Wamba na zala o biziye ɓa ɓokonzi phɔ ya itena malombe ma maɓota iko mbuka maɓale ma Isalayɛlɛ.» ");
INSERT INTO loq_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Nkolo amba ya wɔ na Simo Petelo yokye: «Simo, Simo, Molemba aeyongyi phɔ ya iyenyinga ɓokonyingye ɓɛ́ɛ mbuma ya ble. ");
INSERT INTO loq_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Kasi nga, naɓɔndɛsi phɔ ya wɛ oɓokye ianola sa wɛ sango sa unva. Emba iwɛ, waamo ya mbutolela wɛ, okuya ɓɛbi na wɛ.» ");
INSERT INTO loq_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Petelo amba ya wɔ nɛ yokye: «Nkolo, nga naanosi inyɔlɔ o bɔlɔkɔ naa iwa na wɛ, elele yɔnɔyɔ.» ");
INSERT INTO loq_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesu amba ya mobuyisa yokye: «Petelo na wɔ na wɛ ngakye, nde o mokɔlɔ ŋwa lɔlɔ, soo sa ɓotɔngɔkye, wa munzangana mbala iyato, oɓokye toonzeɓe.» ");
INSERT INTO loq_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ɓoɓɛlɛ Yesu amba ya tuna ɓaekosi ɓɛ́ɛ yokye: «Waaetomaka nga sa ɓaphalanga, sa ikuɓa, sa mapapa, ɓɛ̀ɛ wazangaka ekpele?» Ɓamba buya ɓɛkye: «Phe.» ");
INSERT INTO loq_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Amba wɔ na ɓɛ́ɛ yokye: «Kasi, uŋwaŋwa eye, ooli na ɓaphalanga, aɓaphile; nde ɓomɔ na ooli na ikuɓa; emba ootoli na mumphata, aungya munkoto nwɛ phɔ aombe mumphata. ");
INSERT INTO loq_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Phɔ, na wɔ na ɓɛ̀ɛ, esengyesi oɓokye maphɔɔ maakoma ɓɛ́ɛ phɔ ya nga o buku pha Ŋwaphongo mama makyelame: “Ɓamunyɔsa o molɔngɔ ŋwa ɓaɓomi.” Nde phɛlɛ, maphɔɔ maankyekyi, mamokyelama.» ");
INSERT INTO loq_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ɓaekosi ɓamba ya wɔ nɛ ɓɛkye: «Nkolo, kyeka mphata iɓale.» Amba ya ɓabuyisa yokye: «Wakokyi.» ");
INSERT INTO loq_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesu atɔkɔsi, aesi ya kyɛndɛ o ngomba ya ɓa olive, ɓowamɛlɛkyɛ yo. Ɓaekosi ɓɛ́ɛ ɓamba ya moɓenga. ");
INSERT INTO loq_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Waakoma ɓɛ́ɛ o elele mɛ, amba ya wɔ na ɓɛ́ɛ yokye: «Ɓɔndɛlɛ phɔ ɓɛ̀ɛ sakaa o bimekyi.» ");
INSERT INTO loq_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Amba ya mana wali ɓɛ, amigbɔsi ŋwana imbale, akyɛ kusama, atati iɓɔndɛlɛ yokye: ");
INSERT INTO loq_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","«Tata, ɓo ozingyi manya kɔphɔ ya ɓɔlɔsi eye oka nga. Kasi sakyela ɓoozingye nga, kyela nde ɓoozingyi wɛ.» ");
INSERT INTO loq_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Emba anzelu mɔnɔmɔ owa ikolo, amba motɔkɔlɛlɛ phɔ ya imokuya. ");
INSERT INTO loq_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Na ngɔngɔ ɓoikye, amba kula ɓɔndɛlɛ na ɓokusi. Ephamisa yɛ ebuto itanga o se ndokolo matanga ma malongo. ");
INSERT INTO loq_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Waunva yo iɓɔndɛlɛ, atɛmi, aesi yakyɛ oli ɓaekosi ɓɛ. Akyɛ ɓatakana ɓalasi ebu na ngɔngɔ. ");
INSERT INTO loq_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Amba ya wɔ na ɓɛ́ɛ yokye: «Mɛnɛ ye, kolale! Langwa, ɓɔndɛlɛ phɔ ɓɛ̀ɛ sakaa o bimekyi.» ");
INSERT INTO loq_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Waataɓa Yesu kawɔ, ɓoɓɛlɛ ɓato ɓaikye ɓaesi. Yudasi mɔnɔmɔ na ɓaekosi iko mbuka ɓaɓale, moto owaɓaka o ɓoo pha ɓɛ. Amba ya susinya phɛnɛphɛ na Yesu phɔ ya imoyamba. ");
INSERT INTO loq_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Kasi Yesu amba ya wɔ nɛ yokye: «Yudasi, koyambe Ŋwana wa moto, phɔ ya imungya!» ");
INSERT INTO loq_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Waawɛnɛ ɓaekosi ɓa Yesu maphɔɔ malukye ikyelama, ɓamba motuna ɓɛkye: «Nkolo, toŋwane na mphata?» ");
INSERT INTO loq_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Emba mɔnɔmɔ na ɓɛ, aesi ya tena itoo sa ɓoloo sa moombo wa nganga munɛnɛ wa Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Kasi Yesu amba ya wɔ yokye: «Lɛ kyela ɓaɓona, wakokyi.» Amba phila itoo sa moto mɛ, amba mobikya. ");
INSERT INTO loq_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Emba Yesu amba ya wɔ na ɓaa yakaka ya moakya, ɓakonzi ɓanganga ɓa Ŋwaphongo na ɓakonzi ɓa ɓanza Ingambi siinɛnɛ sa losambo na ɓa nkumu, yokye: «Phɔ ya iya nzakya oesi na mphata naná kpɔngu o maɓɔkɔ ndokolo nga nali mwibi! ");
INSERT INTO loq_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nkɔlɔ isɔ, naɓaka na ɓɛ̀ɛ o Ingambi siinɛnɛ sa makyita, toikaka nzakya. Kasi imbɛlɛ sisi sili sa ɓɛ̀ɛ, na sa ɓokonzi phaa enzɔmbi.» ");
INSERT INTO loq_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ɓaakye Yesu, ɓaesi yakyɛ nɛ ɓamunyɔsɛ o ingambi sa nganga munɛnɛ wa Ŋwaphongo. Petelo aɓaka kaɓaɓengye na itakye. ");
INSERT INTO loq_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ɓalosaka ŋwenya o motema ŋwa lophango, Petelo akyɛkyɛ nɛ zala onte ya ɓato ɓaaɓaka ɓaɔtɔ ŋwenya. ");
INSERT INTO loq_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ŋwaŋwasi mɔnɔmɔ wa etoma, aesi ya mowɛnɛ azasi phɛnɛphɛ na ŋwenya, aesi ya molembetela amba ya wɔ yokye: «Moto oyo nɛ aɓaka na Yesu.» ");
INSERT INTO loq_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Kasi Petelo amba angana yokye: «Ŋwaŋwasi oyo, nga si moeɓe.» ");
INSERT INTO loq_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ŋwana ɓote, moto mosuu waamowɛnɛ yo, amba ya wɔ yokye: «Na wɛ oli mɔnɔmɔ na ɓɛ.» Kasi Petelo amba ya mobuyisa yokye: «Lele lolo, nga phe!» ");
INSERT INTO loq_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Sima ya ngonga yɔnɔyɔ, moto mosuu atingami na Petelo, amba ya wɔ nɛ yokye: «Nde phɛlɛ, moto oyo aɓakyi na Yesu. Phɔ nɛ ali moto wa Galileya.» ");
INSERT INTO loq_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Kasi Petelo amba ya buya yokye: «Lele lolo, sieɓe maphɔɔ malukye wɛ iwɔ.» Nde waataɓa yo iwɔ, soo esi ya tɔngɔ. ");
INSERT INTO loq_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Nkolo aekpa, aesi ya kyeka Petelo. Emba Petelo amba ya umunya maphɔɔ maawɔkɔ Nkolo nɛ oɓokye: «Mokɔlɔ ŋwa lɔlɔ eye, soo sa ɓotɔngɔkye, wa munzangana mbala iyato oɓokye toonzeɓe.» ");
INSERT INTO loq_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Emba Petelo amba ya tɔkɔlɔ, abuto ilela na ngɔngɔ ikye. ");
INSERT INTO loq_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ɓato ɓaaɓaka ɓakyɛngɛlɛ Yesu, ɓamoɛkyɛkyɛ, ɓamba na mowanda. ");
INSERT INTO loq_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ɓamoziɓaka miyo, ɓambe motuna ɓɛkye: «Teya oɓokye oli moimosi! Oewandi nza?» ");
INSERT INTO loq_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ɓakulaka motola na ɓoikye. ");
INSERT INTO loq_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Waayɛ bunya, ɓankumu ɓa ɓayuda, ɓakonzi ɓa ɓanganga ɓa Ŋwaphongo na ɓateye ɓa miɓeko, ɓaesi yaangana ikyita sinɛnɛ, bamba ɓayelela na Yesu. ");
INSERT INTO loq_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ɓamba ya motuna ɓɛkye: «Ɓo oli Masiya? Oloumole.» Yesu amba ya ɓabuyisa yokye: «Ɓo naeimosi, otoonzanole, ");
INSERT INTO loq_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","na ɓo naetuni motuna, otombuyisa. ");
INSERT INTO loq_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Kasi tata lɔlɔ, Ŋwana wa moto amokyɛ zala o eɓɔkɔ ya ɓoloo ya Ŋwaphongo, owa mwiya.» ");
INSERT INTO loq_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Emba, ɓɛ́ɛ ɓasɔ ɓamba ya motuna ɓɛkye: «Iwɛ nde Ŋwana wa Ŋwaphongo?» Amba ya ɓabuyisa yokye: «Ɓɛ mampenza owɔɔ, eli nga.» ");
INSERT INTO loq_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Emba ɓɛ́ɛ ɓamba ya wɔ ɓɛkye: «Tonekula luka manzoka maaye, ɓanga mampenza tookyi munɔkɔ nwɛ!» ");
INSERT INTO loq_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ɓato ɓasɔ ɓaaɓaka o ikyita ɓaesi ya tɛmɛ, ɓamba ya kyɛ na Yesu oka Pilata. ");
INSERT INTO loq_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Emba ɓamba butwa imophunda ɓoɓo: «Tokyɛ zwa moto oyo kaambya mobulu o mokyisi ŋwa ɓanga: Kakatele ɓato saphuta mputi ya Kaisala, kambe na miɓanga Masiya na mokonzi.» ");
INSERT INTO loq_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilata amba motuna yokye: «Iwɛ mokonzi ŋwa ɓayuda?» Yesu amba mobuyisa yokye: «Ewɔ nde wɛ.» ");
INSERT INTO loq_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilata amba ya wɔ na ɓakonzi ɓa ɓanganga na ná moluku ŋwa ɓato yokye: «Sikyi zwa ewele ya inyɛtɛ moto oyo.» ");
INSERT INTO loq_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Kasi ɓɛ́ɛ ɓamba ititala na iwɔ ɓɛkye: «Katomisa ɓato na mateya mɛ oɓokye ɓakyele mobulu o Yuda mobimba, tata o Galileya tee nɔnɔ wawa.» ");
INSERT INTO loq_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Waaoka Pilata ɓaɓona, amba tuna naa moto mɛ ali moto wa Galileya. ");
INSERT INTO loq_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Waeɓa yo oɓokye Yesu ali moto wa mokyisi ŋwa Elode, amba ya mobuya oka Elode owaɓaka nɛ mi nkɔlɔ mɛ o Yelusalɛmɛ. ");
INSERT INTO loq_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Wawɛnɛ Elode Yesu, asepelaka na ɓoikye, phɔ tata kala aɓaka na phowa ya imowɛnɛ, phɔ ya maphɔɔ maɓaka yo kaokye phɔ yɛ. Ambaka ɓaa kamokyekyele naa amokyela elekyesako. ");
INSERT INTO loq_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Emba, amba tuna Yesu mituna miikye, kasi Yesu taika mobuyisa na lowɔɔ. ");
INSERT INTO loq_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ɓakonzi ɓa ɓanganga ɓa Ŋwaphongo na ɓateye ɓa Miɓeko ɓaɓaka wa mɔ, ɓamophundaka na ɓokusi. ");
INSERT INTO loq_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Elode na ɓatuluku ɓɛ́ɛ ɓamba motiyola, ɓamba moɛkyɛ; ɓamba molasa etobu yɔnɔnɔ elaa, amba mobuya oka Pilata. ");
INSERT INTO loq_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Mokɔlɔ mɛ, Elode na Pilata ɓabutwaka ekamba, ɓɛ́ɛ ɓaaɓaka phanza ɓanguna. ");
INSERT INTO loq_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Emba Pilata amba ya ɓanga ɓakonzi ɓa ɓanganga ɓa Ŋwaphongo, ɓakonzi ɓa mokyisi, ");
INSERT INTO loq_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","amba wɔ na ɓɛ́ɛ yokye: «Ɓɛɛ onzelesi na moto oyo phɔ kowɔ oɓokye kakosa ɓato ɓamane o nzela elaa; kasi nga, oomotuni nga o miyo ma ɓɛ̀ɛ, sikyi mozwa nɔnɔ na ewele eekokyi na imoakya onte ya maphɔɔ masɔ maamophunde na ɓɛ̀ɛ: ");
INSERT INTO loq_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Elode nɛ taikyi mozwa na lowɔ, phɔ akuli lobuyisa yo. Yango mɛna tewali lowɔ lokoyi na iwa onte ya maphɔɔ makyela yo. ");
INSERT INTO loq_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Namophɛ nde etumbu, ɓamoɓinde phimbo emba ɓamolɛɛ kakyɛndɛ». ");
INSERT INTO loq_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","O biyenga bisɔ ba Ilekanaa, Pilate aɓaka kaɓatokolɛlɛ moto mɔnɔmɔ wa bɔlɔkɔ. ");
INSERT INTO loq_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Kasi ɓɛ́ɛ ɓasɔ ɓamba aŋwana ɓɛkye: «Omoɓome emba olokandolele Ɓalaɓa.» ");
INSERT INTO loq_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ɓakangaka Ɓalaɓa o ɓɔlɔkɔ phɔ ɓato ɓatɔmbɔkɔ o mokyisi, emba aɓomaka moto. ");
INSERT INTO loq_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilata amba kula ya wɔoɔ na ɓɛ́ɛ na ndengye ya iluka ikandola Yesu. ");
INSERT INTO loq_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Kasi ɓɛ́ɛ ɓamba aŋwana ɓɛkye: «Omoɓakye o ekulusu, omoɓakye o ekulusu.» ");
INSERT INTO loq_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Mbala eya iyato, Pilata amba wɔ na ɓɛ́ɛ yokye: «Ɓoɓe iye ɓokyesi moto oyo? Sizwe ɓoɓe ɓokyesi yo phɔ akokye na iwaa. Namophɛ etumbu ya phimbo emba namolɛ kakyɛndɛ.» ");
INSERT INTO loq_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Kasi ɓɛ́ɛ ɓaititalaka nde na iaŋwana nzaga, na iyonga oɓokye aɓakyeme o ekulusu, emba nzanga ya ɓɛ́ɛ ya ɓaka kyikole nde ɓokosi. ");
INSERT INTO loq_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Emba Pilata amba tena lowɔ mɛ ndengye eya ongaka ɓɛ. ");
INSERT INTO loq_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Amba kandola moto owa ongaka ɓɛ, iyo owa kangaka yo o bɔlɔkɔ phɔ ya itɔmbɔ na iɓoma moto. Ka phɔ ya Yesu, amba moambya oɓokye ɓamokyele ɓoozingyi ɓɛ. ");
INSERT INTO loq_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Waaɓa ɓatuluku ɓakyɛndɛ na Yesu, ɓaesi yakpa moto mɔnɔmɔ wa mokyisi ŋwa Sirɛnɛ nkombo yɛ Simo kaute o inzabi. Ɓaesi ya mophisa ekulusu phɔ aenyanya o sima ya Yesu. ");
INSERT INTO loq_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Moluku ŋwa ɓato moikye ŋwaɓaka momoɓengye, na ɓaɓasi ɓaɓa ɓamiwande mantolo na imiima phɔ yɛ. ");
INSERT INTO loq_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesu amba miekpinya biili ɓɛ́ɛ amba wɔ na ɓɛ́ɛ yokye: «Ɓana ɓa ɓaɓasi ɓa Yelusalɛmɛ, salela phɔ ya nga kasi lela phɔ ya ɓɛ̀ɛ mampenza na phɔ ya ɓana ɓa ɓɛ̀ɛ. ");
INSERT INTO loq_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Phɔ kyeka nkɔlɔ kyiye yaamowɔɔ ɓɛ́ɛ oɓokye: “Nkɔnzɔ na ɓaɓasi ɓaa komba na ɓaateɓaika ɓota na ɓaateɓaika nwyangya.” ");
INSERT INTO loq_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Emba ɓamobutwa iwɔɔ na mangomba oɓokye: “Kaa o ikolo sa ɓanga!” na ná makosi oɓokye: “Oloziɓe”. ");
INSERT INTO loq_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Phɔ ɓoɓakyesi ɓaɓona na ŋwete mobio, mi ŋwaaunga yamba ɓa ɓo?» ");
INSERT INTO loq_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ɓayakaka na ná ɓato ɓaɓale ɓasuu, ɓato ɓaɓe, phɔ ɓaɓaɓome na Yesu elele yɔnɔyɔ. ");
INSERT INTO loq_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Waakoma ɓɛ́ɛ o elele ekyeɓangye ɓɛ́ɛ «Engyɛngyɛlɛ», wamɔ, ɓamba moɓaka na ɓato ɓaɓe ɓaɓale ɓaaɓana, ona o ɓoloo, omoyɔkɔ o ɓowɛɛ. ");
INSERT INTO loq_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Emba Yesu amba wɔ yokye: «Tata, oɓalimbisa phɔ teɓaeɓe ikyikyele ɓɛ.» Ɓamba maa mbɛsɛ phɔ ya ikaɓa bitobu ɓɛ. ");
INSERT INTO loq_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ɓato ɓatɛmɛkyɛ wamɔ phɔ ya ikyeka; ɓaakonzi, ɓɛ, ɓamoɛkyɛkyɛ, ɓɛkye: «Abikyaka ɓato ɓasuu, amibikya yo mampenza ɓo ali Masiya owa ɔlɔ Ŋwaphongo!» ");
INSERT INTO loq_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ɓatuluku na ɓɛ́ɛ ɓamoɛkyɛkyɛ mɛ. Ɓamba ya susana phɔ ya imophɛ malɛku maa ngaa, ɓɛkye: ");
INSERT INTO loq_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","«Ɓo oli mokonzi ŋwa ɓayuda, omibikya wɛ mampenza!» ");
INSERT INTO loq_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Yaɓaka na ikomi sɔnɔsɔ o ikolo sɛ: «Moto oyo ali mokonzi ŋwa ɓayunda.» ");
INSERT INTO loq_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Mɔnɔmɔ na ɓato ɓaɓe ɓaɓakaka ɓɛ́ɛ o ekulusu amotolaka yokye: «Iwɛ toli Masiya? Omibikya wɛ mampenza, ombe lobikya na ɓanga!» ");
INSERT INTO loq_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Kasi omoyɔkɔ amba mooya oɓokye: «Iwɛ toolote Ŋwaphongo? Phɔ nawɛ ozwe nde etumbu ɓomɔ mɛ. ");
INSERT INTO loq_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Phɔ ya ɓanga, eli ɓosembo: Tozwe ɓoɓe phaakyelaka ɓanga; Kasi yo taika kyela ɓoɓe ɓɔnɔɓɔ.» ");
INSERT INTO loq_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Emba amba ya wɔ yokye: «Yesu, onzumunyaka waamoya wɛ o ɓokonzi pha wɛ.» ");
INSERT INTO loq_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesu amba mobuyisa yokye: «Nde phɛlɛ na wɔ na wɛ: Lɔlɔ, wa moɓaa na nga o paladiso.» ");
INSERT INTO loq_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Waakoma bunya i moto, moo moesi ya mana. Enzɔmbi yamba ya ziɓa mokyisi mobimba tee nɔnɔ o ngonga ya iyato eya nkɔnkɔlɔ. Emba etobu eyanda eyaɓaka o Tempelo yakakwaka na miɓale. ");
INSERT INTO loq_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesu amba yaaŋwana ŋwangye mokusi yokye: «Tata, naambye molimo ŋwa nga o maɓɔkɔ ma wɛ.» Waaunva yo iwɔ ɓaɓona, akati motema. ");
INSERT INTO loq_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Waawɛnɛ mokonzi ŋwa ɓatuluku maphɔɔ masɔ maɓakyi malekane, amba kumbela Ŋwaphongo yokye: «Nde phɛlɛ, moto oyo aɓakyi moto wa ɓosembo.» ");
INSERT INTO loq_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ɓato ɓasɔ ɓaayakaka yaangana phɔ ya lowɔ mɛ, wawɛnɛ ɓɛ́ɛ maphɔɔ malekaa, ɓabutwaka oka ɓɛ̀ɛ na ikyɛmi miwanda mantolo. ");
INSERT INTO loq_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Bikamba ɓa Yesu ɓisɔ, eɓe na ɓaɓasi ɓaaɓaka ɓamoɓengye tata nɔnɔ Galileya ɓatɛmɛkyɛ itakye phɔ ya ikyeka yaaɓaka kyilekane. ");
INSERT INTO loq_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ikyeka ɓoɓo, moto mɔnɔmɔ na nkombo Zozefu aesi; aɓaka mɔnɔmɔ na ɓato ɓa ikyita siinɛnɛ, moto molaa na wa ɓosembo. ");
INSERT INTO loq_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Iyo alɛkyɛ maumunya na maphɔɔ maaɓaka ɓaa ikyita sinɛnɛ ɓakyele. Iyo moto wa Alimatayi, mokyisi mɔnɔmɔ ŋwa ɓayuda. Aɓaka kaziya Ɓokonzi pha Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Aesi ya kyɛ onga Pilata eɓembe ya Yesu. ");
INSERT INTO loq_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ɓoɓɛlɛ, aesi ya eyuya, amba ya mozinga na etobu amba molangya o ilita sa ima ɓɛ́ɛ o motema ŋwa maɓanga, omɔɔ naino teɓakundi moto. ");
INSERT INTO loq_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Yaɓaka mokɔlɔ ŋwa ilɛngyɛlɛ mokɔlɔ ŋwa saɓata eyalukaka na itata. ");
INSERT INTO loq_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ɓaɓasi ɓaɓengaka Yesu uta o Galileya ɓaesi na Zozefu molɔngɔ. Ɓaɓaka ɓakyekye o ilita ndengye eyalangyaka ɓɛ́ɛ eɓembe ya Yesu. ");
INSERT INTO loq_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ɓoɓɛlɛ ɓaesi ya butwa, ɓamba ɓɔngya malasi na mauta maa solo elaa phɔ ya eɓembe ya Yesu. Emba mokɔlɔ ŋwa saɓata ɓaamba emaa ɓokoongye miɓeko. ");
INSERT INTO loq_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Mokɔlɔ ŋwa saɓata moumbo, na moyɛlɔ, ɓaɓasi ɓaesi ya kyɛndɛ o ilita ɓaphisi malasi maɓɔngyaka ɓɛ. ");
INSERT INTO loq_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ɓaesi ya kyɛ zwa iɓanga simani o munɔkɔ ŋwa ilita. ");
INSERT INTO loq_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Waanyɔlɔ ɓɛ, teɓaikyi kyɛ zwa nzoto ya Nkolo Yesu. ");
INSERT INTO loq_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Waaɓa ɓɛ́ɛ sakula eɓa maphɔɔ maa iwɔɔ, kyeka ɓoɓo ɓato ɓaɓale ɓalati bitobu bitane pɛɛ ɓaesi yaɓatɔkɔlɛlɛ. ");
INSERT INTO loq_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Na ɓona ɓɔɔɓɔ, ɓamba nyɔkyɛ maɓoo o se waɓa ɓato ɓaɓana ɓawɔ na ɓɛ́ɛ oɓokye: «Phɔ ya'ye kolukye moto ooli na ɓomɔɔ onte ya ɓawe? ");
INSERT INTO loq_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Tali wawa, kasi akundoo. Umunya ya ewɔlɛkyɛ yo waataka ɓa yo o Galileya. ");
INSERT INTO loq_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Awɔkɔ yokye: “Esengyesi oɓokye Ŋwana wa moto aambyame o maɓɔkɔ ma ɓato ɓa masumu, ɓamoɓakye o ekulusu emba o mokɔlɔ ŋwa iyato akundwe.”» ");
INSERT INTO loq_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Emba ɓamba umunya maloɓa mɛ. ");
INSERT INTO loq_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Waa uta ɓɛ́ɛ o ilita, ɓamba ya imola maphɔɔ masɔ mamana oka ɓaekosi iko mbuka mɔnɔmɔ na ɓato ɓasuu ɓasɔ. ");
INSERT INTO loq_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ɓaɓasi mɛ yaɓaka Maliya ma Magadala na Zaani na Maliya nyango wa Zake. Na ɓaɓasi ɓasuu ɓaaɓaka na ɓɛ́ɛ molɔngɔ ɓaimolaka ɓatoma nde ɓomɔ. ");
INSERT INTO loq_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","O miyo ma ɓɛ, maloɓa mɛ temaikaka ɓaa na ntina emba teɓambaka na anolela ɓaɓasi mɛ. ");
INSERT INTO loq_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Kasi Petelo amba ya kyilingana o ilita; waaminya yo ikyeka, awɛni nde bitato na bitato. Amba ya butwa oka yɛ na ikamwa na isɔɔ yaalekanaka. ");
INSERT INTO loq_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Kyeka nde muna mokɔlɔ mɛ, ɓaɓale onte ya ɓɛ́ɛ ɓakyɛndɛkyɛ o mokyisi mɔnɔmɔ nkombo Emaus, itakye na Yelusalɛmɛ ngonga iɓale ya itambula. ");
INSERT INTO loq_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ɓaɓaka ɓawɔnɔ onte ya ɓɛ́ɛ na maphɔɔ masɔ maaleka. ");
INSERT INTO loq_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Emba, waaɓa ɓɛ́ɛ ɓasolole na ika ziko, Yesu yo mampenza aesi phɛnɛphɛ na ɓɛ, atati itambula na ɓɛ́ɛ nzela yɔnɔyɔ; ");
INSERT INTO loq_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","kasi miyo ma ɓɛ́ɛ maziɓamaka, teɓakokaka imoeɓa. ");
INSERT INTO loq_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yesu amba ya ɓatuna yokye: «Maphɔɔ iye maaɓakyi ɓɛ́ɛ koikye ziko o nzela?» Emba ɓamba tɛmɛ, ɓatondaka na ngɔngɔ. ");
INSERT INTO loq_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Mɔnɔmɔ na ɓɛ, nkombo Kleopasi, amba ya motuna yokye: «Onte ya ɓato ɓasɔ ɓaali o Yelusalɛmɛ, eli nde wɛ otoeɓe maphɔɔ mauti ilekana inkɔlɔ iye?» ");
INSERT INTO loq_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Amba ya ɓatuna yokye: «Maphɔɔ iye?» Ɓamba mobuyisa ɓɛkye: «Maphɔɔ maakyekyi Yesu wa Nazalɛtɛ, ooɓakyi moimosi mɔnɔmɔ wa mwiya ŋwa bitoma na ŋwa maloɓa o miyo ma Ŋwaphongo na o miyo ma ɓato ɓasɔ. ");
INSERT INTO loq_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ɓakonzi ɓa ɓanganga ɓa Ŋwaphongo na ɓakonzi ɓa mokyisi ɓamoambe oɓokye ɓamoɓome emba ɓamba moɓaka o ekulusu. ");
INSERT INTO loq_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Emba ɓanga, tolemelaka oɓokye aɓakyi moto ounvakyi manya Isalayɛlɛ o ɓoombo. Kasi lɔlɔ eli mokɔlɔ ŋwa iyato tata waakyelama maphɔɔ mɛ. ");
INSERT INTO loq_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Kasi ɓaɓasi ɓaayɔkɔ ɓaaɓe na ɓanga ɓalokamwisa: Ɓakyɛkyɛ na moyɛlɔ o ilita ");
INSERT INTO loq_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","emba waaɓa ɓɛ́ɛ sakyɛ zwa nzoto yɛ, ɓaya wɔ ɓɛkye ɓawɛni ɓanze ɓawɔ na ɓɛ́ɛ oɓokye ali na ɓomɔɔ. ");
INSERT INTO loq_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ɓɛbi na ɓanga ɓaayɔkɔ ɓamba ya kyɛndɛ o ilita, ɓɛ́ɛ ɓamba kyɛ wɛnɛ nde ɓo wawɔkɔ ɓaɓasi mɛ; kasi yo, teɓaika mowɛnɛ.» ");
INSERT INTO loq_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Emba yo amba ya wɔ na ɓɛ́ɛ yokye: «Ooo! Ɓɛ̀ɛ ɓato ɓazanga mayɛlɛ, na mandondo makusi o ianola yaa wɔɔ ɓaimosi ɓa Ŋwaphongo! ");
INSERT INTO loq_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Tesengyelakyi oɓokye Klisto aokye ɓolɔsi emba ambe nyɔlɔ o nkyɛmɔ yɛ?» ");
INSERT INTO loq_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Emba amba ɓalimbolela isɔ yakoma ɓɛ́ɛ o buku pha Ŋwaphongo phɔ yɛ tata oka Mose tee nɔnɔ oka ɓaimosi ɓa Ŋwaphongo ɓasɔ. ");
INSERT INTO loq_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ɓamba ya koma phɛnɛphɛ na mokyisi mokyɛndɛ ɓɛ, yo amba kyela ndokolo kalekane. ");
INSERT INTO loq_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ɓamba ya mozimba ɓɛkye: «Bunya ɓoleka, lala na ɓanga wawa.» Emba amba ya nyɔlɔ o ingambi phɔ ya ilala na ɓɛ. ");
INSERT INTO loq_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Nzuka wa ɓa yo na ɓɛ́ɛ o mesa, amba kpa ipa, aphɛ Ŋwaphongo mɛlɛsi, asikyɛsi emba amba ɓaphɛ sango. ");
INSERT INTO loq_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Emba miyo ma ɓɛ́ɛ mamba ya ingwa ɓamba moeɓa, ɓoɓɛlɛ aesi ya lɛmɔ. ");
INSERT INTO loq_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Emba ɓamba butwa itunana oɓokye: «Mandondo ma ɓanga tematondakyi na nkyisa waaɓa yo kalolimbolele o nzela maphɔɔ maakoma ɓɛ́ɛ o buku pha Ŋwaphongo?» ");
INSERT INTO loq_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Nde imbɛlɛ mɛ, ɓaesi ya tɛmɛ, ɓabuto o Yelusalɛmɛ. Ɓakyɛ takana ɓaekosi iko na mɔnɔmɔ ɓaanga na ɓɛbi na ɓɛ. ");
INSERT INTO loq_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ɓamba ɓaimola oɓokye: «Eli nde phɛlɛ! Nkolo akundo. Atɔkɔlɛsi na Simo.» ");
INSERT INTO loq_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Emba ɓaekosi ɓaɓale ɓaaɓana ɓamba ɓaimola maphɔɔ masɔ malekanaka o nzela na ndengye eyamoeɓaka ɓɛ́ɛ na ikyɛsɛ mapa. ");
INSERT INTO loq_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Waaɓa ɓɛ́ɛ ɓawɔ ɓaaɓona, Yesu yo mampenza aesi ya ɓatɔkɔlɛlɛ atɛmi onte ya ɓɛ, amba ya wɔ na ɓɛ́ɛ yokye: «Ɓose ɓo ɓee na ɓɛ̀ɛ.» ");
INSERT INTO loq_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Na ɓɔɔɓɔ, ɓawɛnɛkyɛ inganga, ɓaumunyaka oɓokye ɓawɛni mozisi. ");
INSERT INTO loq_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Emba amba wɔ na ɓɛ́ɛ yokye: «Phɔ ya'ye mandondo ma ɓɛ̀ɛ mali o ikolo? Phɔ ya'ye koikye ziko? ");
INSERT INTO loq_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Kyeka matandala na makaka ma nga: Eli ndenga. Kyeka, inkume, mozisi tali na nsoti na ná mpee ɓokonvɛnɛ ɓɛ̀ɛ na yango ɓoɓo.» ");
INSERT INTO loq_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Waa wɔ yo ɓaɓona, amba ya ɓateya matandala na makaka mɛ. ");
INSERT INTO loq_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Teɓakokaka naino anola phɔ ya nkyisa, ɓaɓaka ɓakamwe nde ɓokamo. Emba Yesu amba ya ɓatuna yokye: «Oli na ŋwana ekpele wa iza wawa?» ");
INSERT INTO loq_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ɓamba mophɛ ete ya swe eya kalanga ɓɛ. ");
INSERT INTO loq_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Amba ekpa, aesi ya ezaa o miyo ma ɓɛ. ");
INSERT INTO loq_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ɓoɓɛlɛ amba ya wɔ na ɓɛ́ɛ yokye: «Kyeka maphɔɔ maewɔlɛkyɛ nga wataaka ɓa nga na ɓɛ: Esengyesi oɓokye maphɔɔ masɔ maakoma ɓɛ́ɛ phɔ nga o buku pha Miɓeko ma Mose, ɓaimosi ɓa Ŋwaphongo na o Meembo makokyisame.» ");
INSERT INTO loq_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Emba amba ya ingola mayɛlɛ ma ɓɛ́ɛ phɔ ɓasɔsɔlɔ yaakoma ɓɛ́ɛ o buku pha Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Amba na wɔ na ɓɛ́ɛ yokye: «Eli nde ɓowakoma ɓɛ́ɛ oɓokye: Klisto amooka ɓɔlɔsi amba na kundwa onte ya ɓawe mokɔlɔ ŋwa iyato. ");
INSERT INTO loq_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ɓaamba na teya na nkombo yɛ iɓongola mandondo na ilimbisa sa masumu o nkyisi isɔ, tata na Yelusalɛmɛ. ");
INSERT INTO loq_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Eli nde ɓɛ̀ɛ mana manzoka. ");
INSERT INTO loq_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Emba nga, namoetomela yaa elakyela Tata. Ɓɛ́ɛ oikalaka nde o mokyisi munɛnɛ mumu nɔnɔ wamotonda ɓɛ́ɛ na mwiya ŋwaa mouta o ikolo.» ");
INSERT INTO loq_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ɓoɓɛlɛ amba ya kyɛndɛ na ɓɛ́ɛ tee mbale ya Ɓetani, amba ya tomba maɓɔkɔ, amba ɓapambola. ");
INSERT INTO loq_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Waaɓa yo kaɓapambole, amba ya kaɓana na ɓɛ́ɛ nɔnɔ waa baa yo o ikolo. ");
INSERT INTO loq_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Waaunva ɓɛ́ɛ imokusamela, ɓamba ya butwa o Yelusalɛmɛ, ɓatondi na nkyisa. ");
INSERT INTO loq_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Nkɔlɔ isɔ ɓaɓaka o Ingambi siinɛnɛ sa Ŋwaphongo phɔ ya imokumbela.");
INSERT INTO loq_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","O etatele Iloɓa aɓaka, Iloɓa aɓaka oka Ŋwaphongo, Iloɓa aɓaka Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","O etatele aɓaka oka Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Mbolo isɔ yakyelama nde nɛ, ɓo sɛɛ phe ekpele yɔnɔyɔ nde teyakyelama. ");
INSERT INTO loq_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Isɔ yaakyelama nɛ ili na ɓomɔɔ, emba ɓomɔɔ phaɓaka moo ŋwa ɓato. ");
INSERT INTO loq_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Moo muungyɛngyɛ onte ya enzɔmbi, emba enzɔmbi teikyi koka imozimya. ");
INSERT INTO loq_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Yaɓaka moto mɔnɔmɔ, owatomaka Ŋwaphongo: Nkombo yɛ yaɓaka Yoane. ");
INSERT INTO loq_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Iyo aesi iya ɓa nzoka, phɔ awɔlɛ moo, phɔ ya oɓokye ɓato ɓasɔ ɓaanole phɔ yɛ. ");
INSERT INTO loq_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Iyo mampenza taikaka ɓa moo, kasi ayakaka ya wɔ nde phɔ ya moo. ");
INSERT INTO loq_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Iloɓa aɓaka nde ŋwaakolo munyɛlɛ ŋwaya o mokyisi, ŋwaangyɛngyɛlɛ moto munsɔ. ");
INSERT INTO loq_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Aɓaka o mokyisi, mokyisi ŋwakyelama nde nɛ, kasi mokyisi teŋwaika moeɓa. ");
INSERT INTO loq_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Aesi o mokyisi nwɛ mampenza, kasi ɓato ɓɛ́ɛ teɓaikyi moyamba. ");
INSERT INTO loq_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Kasi oka ɓaamoyambi, ɓaanosi na nkombo yɛ, aɓaphɛ ɓokonzi pha ibutwa ɓana ɓa Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ɓɛ́ɛ teɓaika ɓotama na malongo, na ná phowa ya nzoto, na ná phowa ya moto, kasi na Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Iloɓa amibuye moto ambi ya zala onte ya ɓanga emba towɛni nkyɛmɔ yɛ. Nkyɛmɔ mɛ eli oɓokye, Ŋwana nde mɔnɔmɔ, owatonda na ngɔlu na ná phɛlɛ yauta na Tata. ");
INSERT INTO loq_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yoane aaŋwanaka, amba imola phɔ yɛ yokye: «Kyeka owa wɔkɔ nga oɓokye: O sima ya nga, kyeye moto mɔnɔmɔ ookondekye, phɔ aɓaka o ɓoo pha nga.» ");
INSERT INTO loq_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Phɔ nde nɛ owa isɔ, ɓanga ɓasɔ tozwa ngɔlu o ikolo sa ngɔlu. ");
INSERT INTO loq_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ɓo Moɓeko ŋwambyamaka o maɓɔkɔ ma Mose, ngɔlu na phɛlɛ yaya na Yesu Klisto. ");
INSERT INTO loq_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Moto mɔnɔmɔ taikawɛnɛ Ŋwaphongo; kasi Ŋwana nde yo mɔnɔmɔ ooli Ŋwaphongo, yo ooli onte ya Tata, aloteya yo. ");
INSERT INTO loq_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Kyeka munɔkɔ ŋwa Yoane imbɛlɛ saɓa yo o Yelusalɛmɛ, waamotomela Ɓayuda ɓanganga ɓa Ŋwaphongo na ɓalewi phɔ ya imotuna motuna oɓokye: «Wɛ oli nza?» ");
INSERT INTO loq_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Taika zita, amba wɔ yokye: «Nga sili Klisto.» ");
INSERT INTO loq_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Emba ɓamba motuna ɓɛkye: «Wɛ oli nza? Oli Eliya?» Amba buya yokye: «Nga sili Eliya». «Oli Moimosi?» Amba buya yokye: «Phe». ");
INSERT INTO loq_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Emba ɓamba wɔ nɛ ɓɛkye: «Wɛ ombi ɓa nza? Phɔ tokyɛ imola ɓalotomakyi! Kowɔ ɓo phɔ ya wɛ mampenza?» ");
INSERT INTO loq_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Amba ya wɔ yokye: «Nali ŋwɛsi ŋwa moto okoaŋwane o obokye oɓokye: “Ɓɔngya nzela ya Nkolo!”» Ɓo wawɔ moimosi Izaya. ");
INSERT INTO loq_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Nzuka ɓato ɓatomaka ɓɛ́ɛ ɓaɓaka Ɓafalisayi. ");
INSERT INTO loq_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ɓamba kula nde motuna ɓɛkye: «Ɓo toɓee Klisto, naa Eliya, naa Moimosi, phɔ ya'ye koɓatisa?» ");
INSERT INTO loq_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yoane amba ɓabuyisa yokye: «Nga, naɓatisa na maa. Onte ya ɓɛ̀ɛ, moto mɔnɔmɔ ali, ɓɛ̀ɛ toomoeɓe. ");
INSERT INTO loq_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Kaye o sima ya nga, sikokyi na iyingola simbi ya bikoto ɓɛ.» ");
INSERT INTO loq_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Maphɔɔ masɔ mamana malekanaka o Ɓetani o mokukulu moyɔkɔ ŋwa Yaladɛnɛ, waaɓaka Yoane kaɓatisa. ");
INSERT INTO loq_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ɓo yana, aesi ya wɛnɛ Yesu kaye bili yo, amba wɔ yokye: «Kyeka Ŋwana wa mpate wa Ŋwaphongo okomanya masumu ma ɓato. ");
INSERT INTO loq_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Eli nde phɔ yɛ nawɔkɔ oɓokye: “O sima ya nga moto ookoye kandekye, phɔ aɓaka o ɓoo pha nga.” ");
INSERT INTO loq_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nga mampenza, simoeɓe, kasi nde phɔ ya imiwɛninya sɛɛ oka Isalayɛlɛ, yango mɛna naesi iyaɓatisa na maa.» ");
INSERT INTO loq_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yoane amba wɔ yokye: «Nawɛnɛkyɛ Ɓolɔɓɔ ɓoute o ikolo ndokolo inkotoŋwenya, ɓoesi yakyɛ tɛmɛ o ikolo sɛɛ. ");
INSERT INTO loq_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Emba nga siikaka nweɓa, kasi owantoma iɓatisa na maa, eli yo o wa wɔ na nga oɓokye: “Owa mowɛnɛ wɛ Ɓolɔɓɔ ɓoute ɓokyɛ tɛmɛ o ikolo sɛ, eli yo o wa moɓatisa na Ɓolɔɓɔ Ɓosantu.” ");
INSERT INTO loq_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Emba nga, nambo wɛnɛ, na wɔ ngakye, iyo ali Ŋwana wa Ŋwaphongo.» ");
INSERT INTO loq_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ɓo yana, Yoane akulaka ɓa o elele mɛ, yo na ɓaekosi ɓɛ́ɛ ɓaɓale. ");
INSERT INTO loq_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Waawɛnɛ yo Yesu katambule, amba wɔ yokye: «Kyeka Ŋwana wa mpate wa Ŋwaphongo!» ");
INSERT INTO loq_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Wamooka ɓaekosi ɓaɓale kawɔ ɓaɓona, ɓamba ɓenga Yesu. ");
INSERT INTO loq_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesu amba ya miekpinya, waawɛnɛ yo oɓokye ɓamoɓengye, amba wɔ na ɓɛ́ɛ yokye: «Ɓɛ̀ɛ kolukye'ye?» Ɓamba buya ɓɛkye: «Labi — kyelukye iwɔ ɓokye Moteye —, koɓe bi?» ");
INSERT INTO loq_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Amba wɔɔ na ɓɛ́ɛ yokye: «Yaka wamowɛnɛ.» Emba ɓamba ya kyɛndɛ, ɓamba ya kyɛ wɛnɛ elele ekye ɓe yo, emba ɓamba ya zala nɛ mokɔlɔ mɛ. Yaɓaka phɛnɛphɛ ngonga ya iko. ");
INSERT INTO loq_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andele, ŋwana nyango na Simo Petelo, aɓaka mɔnɔmɔ na ɓaɓale ɓaokaka Yoane na ɓaɓengaka Yesu. ");
INSERT INTO loq_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","O ɓoo pha ɓato ɓasɔ, amba kyɛ zwa ŋwana nyango Simo, amba wɔ nɛ yokye: «Towɛni Masiya.» — Kyelukye iwɔ ɓokye Klisto. ");
INSERT INTO loq_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Amba yakyɛ nɛ oka Yesu. Wamolembetela yo, Yesu yokye: «Oli Simo, ŋwana wa Yoane, ɓamoeɓanga Sefasi.» — Kyelukye iwɔ ɓokye «Petelo». ");
INSERT INTO loq_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ɓo yana, Yesu aesi kyɛndɛ o Galileya. Amba yakyɛ zwa Filipe amba wɔ nɛ yokye: «Imbengye!» ");
INSERT INTO loq_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipe aɓaka moto wa Ɓetesaida, mokyisi ŋwa Andele na Petelo. ");
INSERT INTO loq_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipe amba yakyɛ vana na Natanayɛlɛ, amba wɔ nɛ yokye: «Towɛni owakoma ɓɛ́ɛ maphɔɔ mɛ o buku pha miɓeko ma Mose na ɓaimosi: Eli Yesu, ŋwana wa Zozefu owa Nazalɛtɛ». ");
INSERT INTO loq_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanayɛlɛ amba wɔ yokye: «O Nazalɛtɛ wakokyi itɔkɔlɔ lowɔ lolaa?» Filipe amba wɔ yokye: «Yaka ya kyekye.» ");
INSERT INTO loq_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesu amba ya kyeka Natanayɛlɛ okoye bili yo, amba wɔ na ɓato ɓaaɓaka nɛ phɔ yɛ yokye: «Kyeka owakolo moto wa Isalayɛlɛ ootoli na ɓɔlɛ». ");
INSERT INTO loq_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanayɛlɛ amba motuna yokye: «Konzeɓe bi?» Emba Yesu amba mobuyisa yokye: «Waaɓa Filipe saɓoeɓangakye, waaɓa wɛ o se ya ŋwete ŋwa fige, naewɛnɛkyɛ.» ");
INSERT INTO loq_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanayɛlɛ amba buya yokye: «Labi, oli Ŋwana wa Ŋwaphongo, oli mokonzi ŋwa Isalayɛlɛ.» ");
INSERT INTO loq_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesu amba mobuyisa yokye: «Oanosi nde phɔ nawɔ na wɛ oɓokye naewɛnɛkyɛ o se ya ŋwete ŋwa fige. Wamowɛnɛ maphɔɔ maikye malekyi ɓonɛnɛ ileka lolo.» ");
INSERT INTO loq_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Emba amba kula wɔ yokye: «Phɛlɛ phɛlɛ nawɔ na ɓɛ̀ɛ, wamowɛnɛ ikolo siingo, emba ɓanze ɓa Ŋwaphongo ɓabaa ɓaute o ikolo sa Ŋwana wa Moto.» ");
INSERT INTO loq_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Mokɔlɔ ŋwa iyato, esɛlɛkɔ ya ɓolonga yaɓaka o Kana o manyɛtɛ ma Galileya, emba nyango wa Yesu aɓaka omɔ. ");
INSERT INTO loq_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesu na ɓaekosi ɓɛ̀ɛ ɓaɓaɓangaka na ɓɛ́ɛ o esɛlɛkɔ mɛ. ");
INSERT INTO loq_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Waunva malɛku, nyango wa Yesu amba wɔ nɛ yokye: «Teɓakuli ɓa na malɛku.» ");
INSERT INTO loq_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Kasi Yesu amba ya mobuyisa yokye: «Mama, nga na wɛ lowɔ iye? Imbɛlɛ sa nga naino tesikokyi.» ");
INSERT INTO loq_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Nyango amba ya wɔ na ɓato ɓaetoma yokye: «Kyela isɔ yaamoewɔlɛ yo.» ");
INSERT INTO loq_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Mambongo motoɓa, maakyela ɓɛ́ɛ na maɓanga, maaɓaka Ɓayuda ɓakyelele phɔ ya imikunyola ɓoo okowɔ miɓeko ma ɓɛ, maɓaka wamɔ. Mbongo yɔnɔyɔ yɔnɔyɔ kyenyɔlɔ ɓalitele ŋwambi naa iko. ");
INSERT INTO loq_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesu amba ya wɔ na ɓato ɓaetoma yokye: «Tonza mambongo mamana na maa». Emba ɓamba matonza nɔnɔ o munɔkɔ. ");
INSERT INTO loq_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Yesu amba ya wɔ na ɓɛ́ɛ yokye: «Uŋwaŋwa eye, toka ndambo ya maa mɛ, okyɛ maphɛ mokolo wa esɛlɛkɔ.» Ɓamba yakyɛ mophɛ mango. ");
INSERT INTO loq_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Emba waamameka yo, maa mabutoo malɛku. Taikaka eɓa biute mango, yaeɓaka nde ɓatokaka mana maa. Ɓoɓɛlɛ mokolo esɛlɛkɔ amba wɔ na molongyi ");
INSERT INTO loq_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","yokye: «Moto munsɔ kataakaɓa malɛku swaswa phanza, ɓo ɓato ɓaɓangyi ɓɛ́ɛ ɓalangyi, ɓaamɓe ya ambya malɛku ma mpiko. Kasi wɛ, oɓombi malɛku ma swaswa tee nɔnɔ uŋwaŋwa eye!» ");
INSERT INTO loq_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Mɛna eli etatele sa bilekyesako ɓa Yesu o Kana o manyɛtɛ ma Galileya. Ateyaka nkyɛmɔ yɛ, emba ɓaekosi ɓɛ́ɛ ɓamba moanolela. ");
INSERT INTO loq_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Sima ya yango, amba ya kyɛndɛ o Kapalanauma, yo na nyango, na ɓanaa nyango nana ɓaekosi ɓɛ. Kasi ɓakelaka omɔ nde ɓanaa nkɔlɔ. ");
INSERT INTO loq_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Eyenga ya Ilekana ya Bayuda yakomaka phɛnɛphɛ emba Yesu amba yakyɛndɛ o Yelusalɛmɛ. ");
INSERT INTO loq_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Amba yakyɛ zwa o Tempelo ɓaungye ɓa mangɔmbɛ, ɓa mampate na mankoto nwinya na ɓaendinye ɓa ɓaphalanga ɓazasi omɔ. ");
INSERT INTO loq_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ndokolo, kambe ya kyela phimbo ya simbi, amba ɓauwinya ɓɛ́ɛ ɓasɔ o Tempelo, eɓe mampate na mangɔmbɛ. Amba nyangola ɓaphalanga ɓa ɓaendinye, amba bungutinya ɓamesa ɓa ɓɛ. ");
INSERT INTO loq_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Amba ya wɔ na ɓaungye ɓa mankoto ŋwenya yokye: «Manya isɔ miina wawa emba sabuya ingambi sa Tata ingambi sa mumbongu.» ");
INSERT INTO loq_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ɓaekosi ɓɛ́ɛ ɓamba umunya oɓokye ɓakoma oɓokye: «Phowa ya ingambi sa wɛ yamumboma.» ");
INSERT INTO loq_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Kasi Ɓayuda ɓamba ya wɔ nɛ ɓɛkye: «Iyaa ye saaloteya wɛ, ɓokokyele wɛ ɓaɓona?» ");
INSERT INTO loq_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesu amba ɓabuyisa yokye: «Uwola Tempelo eye emba nga namoetonga na nkɔlɔ iyato.» ");
INSERT INTO loq_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Emba Ɓayuda ɓamba wɔ nɛ ɓɛkye: «Tempelo eye ekyesi mambula mako mane mbuka motoɓa ma ietonga. Emba iwɛ, wamokoka ikula etonga na nkɔlɔ iyato?» ");
INSERT INTO loq_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Kasi yo awɔkɔ nde na nzoto yɛ ili Tempelo. ");
INSERT INTO loq_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Yango mɛna, waakundwa Yesu onte ya ɓawe, ɓaekosi ɓamba ya umunya oɓokye awɔkɔ ɓaɓona, emba ɓamba anolela buku pha Ŋwaphongo na maphɔɔ maawɔkɔ yo. ");
INSERT INTO loq_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Waataa ɓaa Yesu o Yelusalɛmɛ, imbɛlɛ sa esɛlɛkɔ ya Ilekana, ɓato ɓaikye ɓaanola nkombo yɛ wa wɛnɛ ɓɛ́ɛ bilekyesako ɓa ɓa yo kakyele. ");
INSERT INTO loq_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Kasi Yesu, yo, taikaka ɓaanolela phɔ aɓaeɓaka ɓɛ́ɛ ɓasɔ, ");
INSERT INTO loq_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","emba taikaka sengyela oɓokye ɓamoimole maphɔɔ maakyekyi moto, phɔ yo mampenza aeɓaka iili o ndondo ya moto. ");
INSERT INTO loq_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Yaɓaka onte ya Ɓafalisayi moto mɔnɔmɔ na nkombo Nikodɛmɛ, mɔnɔmɔ na ɓankumu ɓa Ɓayuda. ");
INSERT INTO loq_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Waa mokɔlɔ, amba ya kyɛndɛ oka Yesu, amba wɔ nɛ yokye: «Labi, ɓanga toeɓe oɓokye oli moteye owatoma Ŋwaphongo. Phɔ na moto takokyi ikyela bilekyesako bikyele wɛ ɓo Ŋwaphongo tali nɛ.» ");
INSERT INTO loq_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesu amba mobuyisa yokye: «Naewɔlɛ nde phɛlɛ phɛlɛ ngakye: Ɓo moto takuli ɓotama mbala eya iɓale, takokyi iwɛnɛ Ɓokonzi pha Ŋwaphongo.» ");
INSERT INTO loq_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodɛmɛ amba wɔ nɛ yokye: «Ɓo moto aunva koma phomba, amokula ɓotama ndengye'ye? Akokyi ikula nyɔlɔ o ibu sa nyango emba ambe ɓotama?» ");
INSERT INTO loq_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesu amba mobuyisa yokye: «Nawɔ na wɛ nde phɛlɛ phɛlɛ ngakye: Ɓo moto taɓotami na maa na ná Ɓolɔɓɔ, takokyi inyɔlɔ o Ɓokonzi pha Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Oo ɓotami na ɓomoto, ali moto, oo ɓotami na Ɓolɔɓɔ ali ɓolɔɓɔ. ");
INSERT INTO loq_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Sakamwa ɓo nawɔkyi na wɛ oɓokye: “Osengyesi iɓotama o ikolo.” ");
INSERT INTO loq_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ewɛɛlɛ kyekyɛndɛ mbale ezingyi yango, emba koeyokye, kasi toeɓe biute yango na bikyɛ yango. Eli nde ɓomɔ phɔ ya moto oo ɓotami na Ɓolɔɓɔ.» ");
INSERT INTO loq_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ɓoɓɛlɛ Nikodɛmɛ amba ya wɔ nɛ yokye: «Lowɔ mɛ laamba kyelama ndengye'ye?» ");
INSERT INTO loq_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesu amba mobuyisa yokye: «Iwɛ oli moteye o Isalayɛlɛ, emba toombe eɓa maphɔɔ mama? ");
INSERT INTO loq_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Naewɔlɛ nde phɛlɛ phɛlɛ: Towɔ maphɔɔ maeɓe ɓanga, toimole maphɔɔ maawɛnɛ ɓanga, emba ɓɛ̀ɛ toanole ikyimole ɓanga. ");
INSERT INTO loq_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ɓo toanole wa ewɔlɛ nga maphɔɔ ma mokyisi, wamba anola ndengye'ye ɓo naewsɔsi maphɔɔ ma ikolo? ");
INSERT INTO loq_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Phɔ moto nɔnɔ mɔnɔmɔ taika baa o ikolo ɓo teeɓe nde Ŋwana wa Moto owauta o ikolo. ");
INSERT INTO loq_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Nde ɓo watombaka Mose nzɔɔ o bokye, esengyesi oɓokye Ŋwana wa Moto atombame ");
INSERT INTO loq_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","phɔ moto munsɔ okoanole, azwe na nzela yɛ ɓomɔɔ pha ɓoɓɛlɛ. ");
INSERT INTO loq_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Phɔ Ŋwaphongo azinga mokyisi na ɓoikye, yango mɛna ambya Ŋwana wɛ, nde yo mɔnɔmɔ, phɔ ya oɓokye moto munsɔ okoanole Ŋwana mɛ, yo sa waa, kasi azwe ɓomɔɔ pha ɓoɓɛlɛ. ");
INSERT INTO loq_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Phɔ Ŋwaphongo taika toma Ŋwana wɛ o mokyisi phɔ ya iya sambisa mokyisi, kasi phɔ ya oɓokye mokyisi mobikye phɔ yɛ. ");
INSERT INTO loq_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Moto okomoanole, taikyi sambisama. Moto otoanole, ambosambisama, phɔ takyi anola nkombo ya Ŋwana nde mɔnɔmɔ wa Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Emba isambisa mɛ sango sisi: Moo moesi o mokyisi, kasi ɓato ɓazingyi enzɔmbi o elele ya moo phɔ bitoma ɓa ɓɛ́ɛ ɓaɓaka biɓe. ");
INSERT INTO loq_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Phɔ moto munsɔ okokyele maphɔɔ maaɓe kaine moo, emba tatɔkɔlɔ o moo, phɔ bitoma ɓɛ́ɛ sawɛnɛnɛ. ");
INSERT INTO loq_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Moto ookokyele maphɔɔ malaa katɔkɔlɔ o moo phɔ bitoma ɓɛ́ɛ biwɛnɛnɛ, bitoma mɛ bakyelama onte ya Ŋwaphongo.» ");
INSERT INTO loq_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Sima mɛ, Yesu na ɓaekosi ɓɛ̀ɛ ɓaesi ya kyɛndɛ o Yuda. Akyelaka na ɓɛ́ɛ omɔ ɓanaa nkɔlɔ, aɓaka kaɓatisa. ");
INSERT INTO loq_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yoane nɛ, aɓaka kaɓatisa o Ainona, phɛnɛphɛ na Salima ooli maa maikye. Ɓato ɓaɓaka ɓayaɓatisama. ");
INSERT INTO loq_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Phɔ Yoane naino teɓataaka munyɔsɛ o bɔlɔkɔ. ");
INSERT INTO loq_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ɓaekosi ɓa Yoane ɓamba ya ika ziko ɓɛ́ɛ na Moyuda mɔnɔmɔ phɔ ya lowɔ la imikunyola ɓowɔ miɓeko ma ɓɛ. ");
INSERT INTO loq_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ɓamba ya kyɛndɛ oka Yoane, ɓamba ya kyɛ wɔ nɛ ɓɛkye: «Labi, moto owaɓaka na wɛ o mokukulu moyɔkɔ ŋwa Yaladɛnɛ, owa wɔkɔ wɛ phɔ yɛ, kyeka nɛ abuto iɓatisa emba ɓato ɓasɔ ɓabuto ɓakyɛndɛ nde oka yɛ!» ");
INSERT INTO loq_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yoane amba ɓabuyisa yokye: «Moto takokyi imiphɛ ekpele koleka eya mophɛ ɓɛ́ɛ o ikolo. ");
INSERT INTO loq_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ɓɛ̀ɛ mampenza oli manzoka ma nga oɓokye nawɔkɔ ngakye: “Nga sili Masiya, kasi nali moto owa toma ɓɛ́ɛ o ɓoo phɛ.” ");
INSERT INTO loq_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Moto oli na ŋwaŋwasi ali moloo. Kasi ekamba ya moloo, ootɛmi wamɔ, kamokye emba ŋwɛsi ŋwa moloo momophɛ nkyisa. Nde ɓoli nkyisa ya nga nzikye. ");
INSERT INTO loq_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Esengyesi oɓokye ngambo yɛ ebaa, emba eyaaka nga eute.» ");
INSERT INTO loq_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","«Okoute o ikolo ali o ikolo sa isɔ. Oouti o mokyisi ali wa mokyisi emba kawɔ ya mokyisi. Okoute o ikolo ");
INSERT INTO loq_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","kaimole yaa wɛnɛ yo na yaa oka yo, emba na moto taanole ikyiimole yo. ");
INSERT INTO loq_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Moto okoanole ikyiimole yo, kaanole oɓokye Ŋwaphongo ali phɛlɛ. ");
INSERT INTO loq_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Phɔ owatoma Ŋwaphongo kawɔ maloɓa ma Ŋwaphongo, ooko mophɛ Ɓolɔɓɔ ɓote ɓoli na ndelo. ");
INSERT INTO loq_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tata kazingye Ŋwana emba isɔ aiyambya o maɓɔkɔ mɛ. ");
INSERT INTO loq_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Moto okoanole Ŋwana ali na ɓomɔɔ pha ɓoɓɛlɛ; moto otokumole Ŋwana etawɛnɛ ɓɔmɔɔ, kasi yɔɔ ya Ŋwaphongo eli mi yo.» ");
INSERT INTO loq_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Waeɓa Yesu oɓokye Ɓafalisayi ɓaoka oɓokye yo kazwe ɓaekosi ɓaikye kambe na ɓatisa ɓato ɓaikye koleka Yoane, ");
INSERT INTO loq_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","— o ɓosembo, Yesu yo mampenza taikaka ɓaa kaɓatisa, kasi ya ɓatisaka nde ɓaekosi ɓɛ́ɛ — ");
INSERT INTO loq_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","amba ya mana o Yuda aesi ya butwa o Galileya. ");
INSERT INTO loq_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Phɔ ya ibutwa omɔ, asengyelaka ikatisa Samaliya. ");
INSERT INTO loq_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Amba ya koma o mokyisi mɔnɔmɔ ŋwa Samaliya mooɓangye ɓɛ́ɛ Sukala, phɛnɛphɛ na manyɛtɛ maphɛkyɛ Yakoɓo ŋwana wɛ Zozefu, ");
INSERT INTO loq_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","elele mɛ eyaɓaka iziɓa sa Yakoɓo. Na ɓophɛmbɛkye pha itambula, Yesu aesi ya kyɛ zala imbale ya mungombe ŋwa iziɓa. Yaɓaka phɛnɛphɛ na ɓunya i moto. ");
INSERT INTO loq_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ikyeka ɓoɓo, ŋwaŋwasi mɔnɔmɔ wa Samaliya aesi ya toka maa. Yesu amba ya wɔ nɛ yokye: «Impɛ maa ma inywa.» ");
INSERT INTO loq_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ɓaekosi ɓɛ̀ɛ ɓakyɛkyɛ o omokyisi munɛnɛ phɔ ya ikyɛ omba ntoma ya iza. ");
INSERT INTO loq_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Kasi ŋwaŋwasi mɛ, Mosamaliya mɔna, amba ya wɔ na Yesu yokye: «Lotati ɓo? Iwɛ, Moyuda, konzongye nga ŋwaŋwasi mosamliya maa ma inywa!» Phɔ Ɓayuda teɓaa ɓenele iyangana ekpele yɔnɔyɔ na Ɓasamaliya. ");
INSERT INTO loq_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesu amba ya mobuyisa yokye: «Ɓo oeɓakyi ikaɓo sa Ŋwaphongo na okoewɔlɛ oɓokye: Impɛ maa ma inywa, eɓakyi nde wɛ moto wa imoonga, emba yo nde aephɛkyi maa ma ɓomɔɔ.» ");
INSERT INTO loq_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ŋwaŋwasi amba wɔ nɛ yokye: «Nkolo, toli nana tubu, na iziɓa sili sizindo, mana maa ma ɓomɔɔ mɛ wamazwa bi? ");
INSERT INTO loq_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Iwɛ olekyi ango wa ɓanga Yakoɓo owa loikyela iziɓa sisi, saa ikaka nywa yo maa, eɓe na ɓana ɓɛ̀ɛ, eɓe na manyama mɛ?» ");
INSERT INTO loq_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesu amba mobuyisa yokye: «Moto munsɔ okonywe maa mama, amokula oka phowa ya maa. ");
INSERT INTO loq_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Kasi moto owa munywa maa maamophɛ nga, etakule oka phowa ya maa. Phɔ maa maamophɛ nga ma mobutwa ndokolo elele ekye tɔkɔlɔ maa onte yɛ nɔnɔ o ɓomɔɔ pha ɓoɓɛlɛ.» ");
INSERT INTO loq_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ŋwaŋwasi amba ya wɔ nɛ yokye: «Nkolo, impɛ maa mɛ phɔ nga sakula oka phowa ya maa ma inywa, nga sambaka kula naya wawa phɔ ya iyatoka maa.» ");
INSERT INTO loq_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesu amba ya wɔ nɛ yokye: «Kyɛ ɓanga moloo nya wɛ emba ɓɛ̀ɛ ɓasɔ oye wawa.» ");
INSERT INTO loq_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ŋwaŋwasi amba mobuyisa yokye: «Nga sili na moloo.» ");
INSERT INTO loq_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Yesu amba wɔ nɛ yokye: «Kowɔ na ɓolaa oɓokye: Sili na moloo, waunva zala na ɓalo ɓatano, emba lele oli na wɛ uŋwaŋwa eye tali molo wa wɛ. Na ɓomɔ, owɔ phɛlɛ.» ");
INSERT INTO loq_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Emba ŋwaŋwasi amba wɔ nɛ yokye: «Nkolo, nawɛnɛ oɓokye oli moimosi. ");
INSERT INTO loq_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ɓaango ɓa ɓanga ɓasambelaka Ŋwaphongo o ngomba eye. Emba ɓɛ̀ɛ kowɔ oɓokye elele ya isambela Ŋwaphongo eli nde o Yelusalɛmɛ.» ");
INSERT INTO loq_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesu amba wɔ nɛ yokye: «Mama, inzanole, imbɛlɛ samoya, eteɓakule sambela Tata na o ngomba eye, na o Yelusalɛmɛ. ");
INSERT INTO loq_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Kosambele itiyeɓe ɓɛ̀ɛ, kasi ɓanga tosambele ikyieɓe ɓanga phɔ lobiko loute na Ɓayuda. ");
INSERT INTO loq_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Kasi imbɛlɛ saamoya, sango sisi, saamosambela ɓaakolo ɓasambesi ɓa Tata, na molimo na ná phɛlɛ. Phɔ mɛna eli ɓasambesi ɓaalukye Tata. ");
INSERT INTO loq_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ŋwaphongo ali molimo. Yango mɛna ɓato ɓaamosambele, ɓasengyesi imosambela na molimo na ná phɛlɛ.» ");
INSERT INTO loq_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ŋwaŋwasi amba ya wɔ nɛ yokye: «Naeɓe oɓokye Masiya mɔnɔmɔ asengyesi iya, okoɓangye ɓɛ́ɛ Klisto. Waamoya yo, aloimola maphɔɔ masɔ.» ");
INSERT INTO loq_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesu amba wɔ nɛ yokye: «Masiya mɛ, eli nga okoewɔlɛ oyo.» ");
INSERT INTO loq_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Imbɛlɛ mɛ ɓaekosi ɓaesi ya koma. Ɓakamwaka na iwɛnɛ oɓokye Yesu kasolole na ŋwaŋwasi. Kasi na moto taika motuna oɓokye: «Kolukye'ye?» Na oɓokye: «Phɔ ya'ye kosolole nɛ?» ");
INSERT INTO loq_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ɓoɓɛlɛ, ŋwaŋwasi mɔna aikyi ika uuku yɛ, aesi ya kyɛ imola ɓato o lombo oɓokye: ");
INSERT INTO loq_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«Yaka yakyɛ kyeka moto mɔnɔmɔ onvɔsi maphɔɔ masɔ maakyela nga. Eteɓe nde yo Klisto?» ");
INSERT INTO loq_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ɓato ɓaesi ya tɔkɔlɔ o mokyisi, ɓamba yakyɛ ooli yo. ");
INSERT INTO loq_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Imbɛlɛ mɛ, ɓaekosi ɓaɓaka ɓamokandindisa ɓɛkye: «Labi, taa za.» ");
INSERT INTO loq_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Kasi yo amba ya wɔ na ɓɛ́ɛ yokye: «Nali na ntoma ya iza ite ieɓe ɓɛ̀ɛ.» ");
INSERT INTO loq_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ɓaekosi ɓamba butwa iwɔnɔ onte ya ɓɛ́ɛ ɓɛkye: «Ɓoɓo moto mɔnɔmɔ animophɛ ntoma ya iza nde iye?» ");
INSERT INTO loq_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesu amba ya wɔ na ɓɛ́ɛ yokye: «Ntoma ya nga, eli ikyela ɓookozingye owantoma na ikokya etoma yɛ. ");
INSERT INTO loq_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ɓɛ̀ɛ mampenza towɔ oɓokye: “Iikasi makombe mane emba imbɛlɛ sa inɔkɔ mbuma sikokye.” Kasi nga nawɔ na ɓɛ̀ɛ ngakye: Tomba miyo okyekye, mbuma ili o manzabi iosi ikokyi phɔ ya inɔkɔ! ");
INSERT INTO loq_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Munɔkyi ambo zwa iphuti sɛ, kambe na ɓɔkya mbuma phɔ ya ɓomɔɔ pha ɓoɓɛlɛ. Na ɓomɔ, moto okophikye na okonɔkɔ ɓakumbe elele yɔnɔyɔ. ");
INSERT INTO loq_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Phɔ i lowɔ lolo ete eye eli nde phɛlɛ: “Mɔnɔmɔ kaphikye, omoyɔkɔ kanɔkɔ.” ");
INSERT INTO loq_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Naetomaka ikyɛ nɔkɔ yaate yaikaka kumela ɓɛ̀ɛ. Ɓaayɔkɔ ɓakuma, emba ɓɛ̀ɛ oesi ya zwa ɓolaa mi yaakumelaka ɓɛbi na ɓoikye.» ");
INSERT INTO loq_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ɓasamaliya ɓaikye ɓa mokyisi munɛnɛ ɓaanolaka Yesu phɔ maloɓa ma ŋwaŋwasi mawɔkɔ yo oɓokye: «Anvɔsi maphɔɔ masɔ maakyela nga.» ");
INSERT INTO loq_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Na wakoma ɓɛ́ɛ phɛnɛphɛ nɛ, Ɓasamaliya ɓaongaka nɛ oɓokye ata ɓaa na ɓɛ. Emba amba kyela na ɓɛ́ɛ nkɔlɔ iɓale. ");
INSERT INTO loq_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ɓato ɓasuu ɓaikye ɓakulaka anola Yesu phɔ ya maphɔɔ maawɔkɔ yo. ");
INSERT INTO loq_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Emba ɓamba ya wɔ na ŋwaŋwasi mɔna, ɓɛkye: «Teli oɓokye tomoanosi nde phɔ ya maphɔɔ maloimolakyi wɛ, kasi na ɓanga mampenza tomookyi, emba toeɓi oɓokye ali phɛlɛ Mobikye wa mokyisi.» ");
INSERT INTO loq_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Sima ya nkɔlɔ iɓale, Yesu amba ya mana o bilele mɛ, amba ya butwa o Galileya. ");
INSERT INTO loq_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Phɔ yo mampenza aanolaka oɓokye moimosi tazwe ngambo o mokyisi mwɛ mampenza. ");
INSERT INTO loq_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Kasi wakoma yo o Galileya, ɓato ɓa Galileya ɓamoyambaka na ɓolaa. Ɓakyɛndɛkyɛ o Yelusalɛmɛ phɔ ya esɛlɛkɔ, na ɓɛ́ɛ mɛ, ɓawɛnɛkyɛ isɔ yakyelaka Yesu. ");
INSERT INTO loq_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yesu amba ya butwa o Kana, o manyɛtɛ ma Galileya, owa ɓongolaka yo maa malɛku. Mokonzi mɔnɔmɔ wa ɓaloo aɓaka na ŋwana wa lele na ɓolɔsi o Kapalanauma. ");
INSERT INTO loq_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Waaoka yo oɓokye Yesu auti o Yuda, akomi o Galileya, amba yakyɛndɛ zwana nɛ, amba ya onga nɛ oɓokye ɓakyɛndɛ phɔ akyɛ bikya ŋwana wɛ wa lele oli nde mowe. ");
INSERT INTO loq_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesu amba wɔ nɛ yokye: «Ɓo ɓɛ̀ɛ towɛni mayaa na bilekyesako ɓɛ̀ɛ otoanole!» ");
INSERT INTO loq_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Mokonzi wa ɓaloo amba wɔ nɛ yokye: «Nkolo, yakyɛ naino ŋwana wa nga saɓowakye!» ");
INSERT INTO loq_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesu amba wɔ nɛ yokye: «Kyɛndɛ, ŋwana wa wɛ ali na ɓomɔɔ.» Moto mɔna amba ya anola maloɓa maa mowɔsi Yesu, nɔnɔ wa butwa yo. ");
INSERT INTO loq_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Waɓa yo kabutwe, ɓato ɓɛ́ɛ ɓaetoma ɓamba ya moɓenga, ɓamba ya wɔ ɓɛkye: «Ŋwana wa wɛ wa lele ali na ɓomɔɔ!» ");
INSERT INTO loq_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Amba ya ɓatuna imbɛlɛ ye sibutwakyi ŋwana na ɓolaa emba ɓamba mobuyisa ɓɛkye: «Yaɓaka yana, o ngonga ya sambo wa mana mowɛwɛ o nzoto yɛ.» ");
INSERT INTO loq_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ango wa ŋwana awɛnɛkyɛ oɓokye yaɓaka nde o sina imbɛlɛ saawɔkɔ Yesu nɛ oɓokye: «Ŋwana wa wɛ wa lele ali na ɓomɔɔ.» Mina wa mɔ, yo na ɓonkpe phɛ ɓosɔ ɓaesi ya anola. ");
INSERT INTO loq_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Mɛna yaɓaka elekyesako eya iɓale eyakyelaka Yesu o Galileya, wauta yo o Yuda. ");
INSERT INTO loq_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Sima ya maphɔɔ mamana, waa imbɛlɛ sa esɛlɛkɔ ya Ɓayuda, Yesu amba ya kyɛndɛ o Yelusalɛmɛ. ");
INSERT INTO loq_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Nzuka o Yelusalɛmɛ, phɛnɛphɛ na moziɓo mootangye ŋwa ɓampate, wali mbondo yɔnɔyɔ ekyeɓangye ɓɛ́ɛ na munɔkɔ ŋwa ɓa Ebele Ɓetezata. Mokanda mɔnɔmɔ ŋwa milaku mitano ŋwaɓaka wamɔ, ");
INSERT INTO loq_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","o milaku mɛ, ɓato ɓa malɔsi ɓaikye ɓaɓaka ɓamilangye omɔ, ɓato ɓaaphɔlɔ miyo, ɓaakpɛkusa, ɓaanyiɓa binango. Ɓaɓaka ɓaziya oɓokye maa maphukuɓane, ");
INSERT INTO loq_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","phɔ anzelu wa Nkolo aɓaka kaute o mbondo imbɛlɛ siiyɔkɔ phɔ ya iphukubinya maa. Moto wa ɓolɔsi owa kyɛkyɛ mikumbya o maa mɛ phanza waaphukuɓane mango, abikaka na ɓolɔsi phɛ, nabo ɓolɔsi mɛ phaɓaka ndengye'ye. ");
INSERT INTO loq_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Moto mɔnɔmɔ owanyiɓa enango mambula mako maato mbuka ŋwambi aɓaka omɔ. ");
INSERT INTO loq_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Waamowɛnɛ Yesu alangyi, na waeɓa yo oɓokye akɔkyi na elɛmɛ mɛna, amba wɔ nɛ yokye: «Oli na phowa ya ibika?» ");
INSERT INTO loq_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Mookaa amba mobuyisa yokye: «Nkolo, sili na moto wa inkumbya o mbondo imbɛlɛ siphukuɓane maa. Imbɛlɛ siikusuɓane nga oɓokye nakyɛ mikumbya o maa, moto mosuu kaingyele angwa o ɓoo pha nga.» ");
INSERT INTO loq_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesu amba ya wɔ nɛ yokye: «Langwa, kpa itɔkɔ sa wɛ, tambula.» ");
INSERT INTO loq_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Mina wamɔ, moto mɛ abikyi. Aesi yakpa itɔkɔ sɛ, abuto itambula. Nzuka mokɔlɔ mɛ yaɓaka mokɔlɔ ŋwa saɓata. ");
INSERT INTO loq_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Phɔ ya ɓomɔ, Ɓayuda ɓamba ya wɔ na moto obikyi ɓɛkye: «Eli mokɔlɔ ŋwa saɓata, tosenyesi iphila itɔkɔ sa wɛ.» ");
INSERT INTO loq_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Kasi amba ɓabuyisa yokye: «Moto oombikye, eli nde yo moto owɔ na nga oɓokye: “Kpa itɔkɔ sa wɛ otambule.”» ");
INSERT INTO loq_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ɓamba motuna ɓɛkye: «Moto mɛ nza owɔ na wɛ oɓokye: “Kpa itɔkɔ sa wɛ otabule?”» ");
INSERT INTO loq_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Kasi moto owabikyaka ɓɛ́ɛ taikaka eɓa nza oomobikye, phɔ Yesu amanaka waali moluku ŋwa ɓato ɓaaɓaka wamɔ. ");
INSERT INTO loq_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Sima, Yesu amba kula kyɛ mozwa o Tɛmpɛlo, amba wɔ nɛ yokye: «Wɛ mɔna obikyi, sakula kyela masumu phɔ lowɔ losuu lolɔbi ɓoɓe saeyelela» ");
INSERT INTO loq_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ɓoɓɛlɛ, moto mɛ amba kyɛndɛ imola Ɓayuda oɓokye eɓakyi Yesu moto oomobikye. ");
INSERT INTO loq_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Tata wamɔ, Ɓayuda bamba ya okyela Yesu yɔɔ, phɔ akyelaka ɓaɓona mokɔlɔ ŋwa saɓata. ");
INSERT INTO loq_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Kasi Yesu amba ya ɓabuyisa yokye: «Tata, nɔnɔ uŋwaŋwa eye ali o ikyela etoma; na nga nde ɓomɔ nali o ikyela etoma.» ");
INSERT INTO loq_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Tata wamɔ, Ɓayuda ɓakulaka luka na ɓoikye manzela ma imoɓoma, teli nde phɔ taikaka kumola mokɔlɔ ŋwa saɓata, kasi na phɔ aɓaka kaɓangye Ŋwaphongo oɓokye ali Ango, kambe na kula mimekyinya na Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesu amba kula ya kpa maloɓa amba ɓawɔlɛ yokye: «Nawɔ na ɓɛ̀ɛ nde phɛlɛ phɛlɛ, Ŋwana takokyi ikyela lowɔ na ndengye'ye yo mampenza, kasi nde ikyi wɛnɛ yo Ango kakyele: Phɔ iikyi kyele Tata, Ŋwana kaikyele nde ɓomɔ. ");
INSERT INTO loq_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Eli oɓokye Tata kazingye Ŋwana emba kamoteya isɔ iikyi kyele yo. Amoteya bitoma bikuli leka ɓonɛnɛ, na oɓokye ɓɛ̀ɛ oɓe kokamwe nde ɓokamo. ");
INSERT INTO loq_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Phɔ ɓooko akole Tata ɓawe kakule ɓabuya na ɓomɔɔ, Ŋwana nɛ kabikya nzaa oozingyi yo. ");
INSERT INTO loq_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Tata taasambisa moto, ambya isambisa sisɔ oka Ŋwana, ");
INSERT INTO loq_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","oɓokye ɓato ɓasɔ ɓakumole Ŋwana ɓo okokumole ɓɛ́ɛ Tata. Moto ootokumole Ŋwana, taakumole na Ango owa motoma. ");
INSERT INTO loq_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Nawɔ na ɓɛ̀ɛ nde phɛlɛ phɛlɛ, moto okookye maloɓa ma nga, kambe na anolela owantoma, ali na ɓomɔɔ pha ɓoɓɛlɛ. Yo etasambe, kasi yo amokundwa onte ya ɓawe, amozwa ɓomɔɔ. ");
INSERT INTO loq_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nawɔ na ɓɛ̀ɛ phɛlɛ phɛlɛ, imbɛlɛ siiye — emba uŋwaŋwa eye imbɛlɛ mɛ sili wawa — ɓawe ɓamooka ŋwɛsi ŋwa Ŋwana wa Ŋwaphongo emba ɓato ɓamooka ŋwɛsi mɛ, ɓamoɓa na ɓomɔɔ. ");
INSERT INTO loq_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Phɔ, ɓooli Tata na ɓomɔɔ yo mampenza, nde ɓomɔɔ aphɛ Ŋwana oɓokye aɓe na ɓomɔɔ mɛ yo mampenza. ");
INSERT INTO loq_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Amophɛ ɓokonzi pha isambisa phɔ ali Ŋwana wa Moto. ");
INSERT INTO loq_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Maphɔɔ masɔ mama mango saekamwisa! Imbɛlɛ siiye, ɓasɔ ɓaakyimele o malita ɓamooka ŋwɛsi nwɛ, ");
INSERT INTO loq_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","emba ɓasɔ ɓaakyelaka ɓolaa ɓamokundwa phɔ ya izwa ɓomɔɔ. Ɓaakyelaka ɓoɓe, ɓamokundwa phɔ ya isambisama.» ");
INSERT INTO loq_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Nga, sikokyi ikyela lowɔ na ndengye ya nga mampenza: Natene ɓolombe nde na nɔkɔ yookyi nga, emba ɓolombe pha nga ɓoli pha ɓosembo phɔ siilukye ikyela ɓoozingyi nga, kasi ɓoozingyi owantoma. ");
INSERT INTO loq_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","«Ɓo namiwɔlɛ phɔ ya nga mampenza, ɓowɔkye pha nga nde teɓoɓe phaa phɛlɛ. ");
INSERT INTO loq_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Eli nde mosuu okwɔ phɔ ya nga, emba naeɓe oɓoye iwɔ siiwɔ yo phɔ ya nga sili sa phɛlɛ. ");
INSERT INTO loq_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ɓɛɛ, watomaka bato oka Yoane Moɓatise. Aewɔlɛ maphɔɔ ma phɛlɛ. ");
INSERT INTO loq_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ka nga, sisengyesi na moto obokye awɔ phɔ ya nga. Nawɔ babona phɔ ya bɛɛ, oɓokye obikye. ");
INSERT INTO loq_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yoane aɓaka tala ekyelosa ɓɛ́ɛ emba kyelole: Kasi ɓɛ̀ɛ wazingaka ikumba nde phɔ ya ŋwana imbɛlɛ na saa ya tala mɛ. ");
INSERT INTO loq_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Kasi nga, nali na maphɔɔ ma iewɔlɛ maalekyi maaka Yoane na ɓonɛnɛ: Eli bitoma biantoma Tata oɓokye nabikyele. Nabikyele, emba eli ɓɛ́ɛ biiwɔ phɔ ya nga oɓokye Tata antoma. ");
INSERT INTO loq_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Tata owantoma awɔ na yo mampenza phɔ ya nga. Kasi toika oka ŋwɛsi nwɛ na mbala, naa iwɛnɛ ɓoo phɛ. ");
INSERT INTO loq_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Emba iloɓa sɛ tesili onte ya ɓɛ̀ɛ, phɔ ɓɛ̀ɛ toanolele owatoma yo. ");
INSERT INTO loq_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ɓɛ̀ɛ koekole Buku pha Ŋwaphongo phɔ koumunya oɓokye wamozwa omɔ ɓomɔɔ pha ɓoɓɛlɛ. Kasi eli nde phango ɓoowɔ phɔ ya nga. ");
INSERT INTO loq_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Emba toozingye iya oka nga phɔ ya iya zwa ɓomɔɔ pha ɓoɓɛlɛ. ");
INSERT INTO loq_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Nkyɛmɔ, siika izwa na ɓato. ");
INSERT INTO loq_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Kasi naeyeɓe, ɓɛ̀ɛ toli na lozingo la Ŋwaphongo onte ya ɓɛ̀ɛ. ");
INSERT INTO loq_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Inga, naesi o nkombo ya Tata, emba ɓɛ̀ɛ toikyi ɓenela inzamba. Ka ɓo moto mosuu aesi na nkombo yɛ mampenza, yo mɔɔna ɓɛ̀ɛ wamoyamba! ");
INSERT INTO loq_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ɓɛ̀ɛ nde ombi anola ndengye'ye, ɓɛ̀ɛ ɓazwe nkyɛmɔ ya ɓɛ̀ɛ onte ya ɓɛ̀ɛ na ɓɛ̀ɛ. Ɓɛ̀ɛ ɓate ɓalukye nkyɛmɔ ikyiute na Ŋwaphongo yo mampenza? ");
INSERT INTO loq_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Saumunya oɓokye yamoɓa nga owamokyɛ esongyela oka Tata. Mosongyesi wa ɓɛ̀ɛ, eli Mose okolemele ɓɛ̀ɛ. ");
INSERT INTO loq_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Phɔ ɓokoanolele Mose, nde onzanolelakyi mɛ, phɔ akomaka nde phɔ ya nga. ");
INSERT INTO loq_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ɓo toanole yaakoma yo, wamba anola iikyi wɔ nga ndengye'ye?» ");
INSERT INTO loq_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Sima mɛ, Yesu amba yakatisa o mokukulu mooyɔkɔ ŋwa ebale eenɛnɛ ya Galileya, ekyeɓangye na ɓɛ́ɛ Tiberias. ");
INSERT INTO loq_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Moluku ŋwa ɓato ŋwaɓaka momoɓengye phɔ ɓato ɓawɛnɛkyɛ bilekyesako biaɓaka yo kakyele oka ɓato ɓaa malɔsi. ");
INSERT INTO loq_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yango mɛna Yesu amba ya ɓaa o ikolo sa ngomba akyɛ zala omɔ yo na ɓaekosi ɓɛ̀ɛ. ");
INSERT INTO loq_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Yaɓaka ŋwana o ɓoo pha esɛlɛkɔ ya Ɓayuda eya Ilekana. ");
INSERT INTO loq_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Nzuka watomba Yesu miyo o ikolo ɓoɓo, amba ya wɛnɛ moluku ŋwa ɓato moye oli yo. Amba ya wɔ na Filipe yokye: «Tomoomba mapa phɔ ya oɓokye ɓato ɓaɓa ɓaze bi?» ");
INSERT INTO loq_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Wa wɔ yo ɓaɓona, amumekaka. Phɔ yo aeɓaka lowɔ laamokyela yo. ");
INSERT INTO loq_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipe amba ya mobuyisa yokye: «Na ɓo toombi mapa ma ɓaphalanga ɓaakokyi na iphuti sa nkɔlɔ mikama miɓale, etemaakokye oɓokye moto na moto azwe nɔnɔ ŋwana etee.» ");
INSERT INTO loq_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Mɔnɔmɔ na ɓaekosi ɓɛ, okoɓangye ɓɛ́ɛ Andele, ŋwana nyango na Simo Petelo, amba ya wɔ nɛ yokye: ");
INSERT INTO loq_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«Munzenga mɔnɔmɔ wawa, ali na mapa matano na swe iɓale. Kasi ina yango miina yamokyela ekpele'ye phɔ ya ɓoikye pha ɓato ɓoɓo?» ");
INSERT INTO loq_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesu yokye: «Oɓazasa o se.» Elele mɛ yaɓaka na nkata nzikye. Ɓoɓɛlɛ, ɓamba ya zala. Ɓaɓaka phɛnɛphɛ ɓampele nkoto itano. ");
INSERT INTO loq_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Emba Yesu amba ya kpa mapa, aphɛ Ŋwaphongo mɛlɛsi emba amba ya makaɓela ɓato ɓasɔ ɓaaɓaka wamɔ. Amba kula kyela nde ɓomɔ na swe. Aɓaphɛkyɛ nde na phowa ya moto na moto. ");
INSERT INTO loq_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Waaoka ɓɛ́ɛ ntoma, Yesu amba ya wɔ na ɓaekosi ɓɛ̀ɛ yokye: «Angyinya bitee bisɔ biikasi, phɔ ekpele yɔnɔyɔ sabunga.» ");
INSERT INTO loq_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ɓamba ya bianginya, ɓamba tonza ɓanyanzima iko mbuka ɓaɓale na bitee ɓa mapa maazaka ɓɛ. ");
INSERT INTO loq_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Waawɛnɛ ɓato elekyesako eyauta yo ikyela, ɓɛkye: «Oyo ali owaakolo moimosi, oosengyesi iya o mokyisi.» ");
INSERT INTO loq_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Kasi Yesu waeɓaka yo oɓokye ɓakokyi iya mokpa na ɓokusi phɔ ya imobuya mokonzi, amba kula mana wamɔ, yo mampenza amba ɓaa o ngomba. ");
INSERT INTO loq_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Wakoma nkɔkɔlɔ, ɓaekosi ɓɛ̀ɛ ɓamba yauta nɔnɔ o ebale enɛnɛ. ");
INSERT INTO loq_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ɓamba ya ɓaa o vato ɓɔnɔɓɔ baamba ya kyɛ o Kapalanauma, o mokukulu moyɔkɔ. Mɛna bunya ɓombo inda, emba Yesu naino sataa ɓaɓenga. ");
INSERT INTO loq_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ewɛɛlɛ enɛnɛ yeesi ya kyela, eɓale ebuto iphukuɓana. ");
INSERT INTO loq_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ɓalukaka phɛnɛphɛ na ɓakyilomɛtɛlɛ ɓatano naa motoɓa, waa wɛnɛ ɓɛ́ɛ Yesu katambule o ikolo sa maa, kambe koma phɛnɛphɛ na vato. Emba ɓɛ́ɛ ɓailaka, ");
INSERT INTO loq_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","kasi Yesu amba wɔ na ɓɛ́ɛ yokye: «Ɓɛɛ saila, eli nde nga!» ");
INSERT INTO loq_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ɓazingaka imokpesa o vato, kasi sa kɔkɔ, vato ɓokyɛ sɛmɛ o elele eyakyɛkyɛ ɓɛ. ");
INSERT INTO loq_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ɓo yana, moluku ŋwa ɓato ŋwa ikalaka o mokukulu moyɔkɔ, ŋwamba yaeɓa oɓokye yaɓaka wamɔ nde vato ɓɔnɔɓɔ, na oɓokye Yesu taikaka kyɛ na ɓaekosi ɓɛ́ɛ elele yɔnɔyɔ, ɓɛ́ɛ ɓakyɛkyɛ ɓɛ́ɛ mampeza. ");
INSERT INTO loq_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Kasi mato maayɔkɔ maautaka o Tiberias makomaka phɛnɛphɛ na elele eya zaka ɓɛ́ɛ mapa sima ya Nkolo iphɛ mɛlɛsi. ");
INSERT INTO loq_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Waaeɓa moluku ŋwa ɓato oɓokye eɓe Yesu, eɓe ɓaekosi ɓɛ̀ɛ teɓakuli ɓaa wamɔ, ɓato ɓamba ya kpela o mato emba ɓamba yakyɛndɛ o Kapalanauma, ikyɛ miluka Yesu. ");
INSERT INTO loq_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Emba wamozwa ɓɛ́ɛ o mopha moyɔkɔ ŋwa eɓale enɛnɛ, ɓamba wɔ nɛ ɓɛkye: «Labi, okomi wawa imbɛlɛ iye?» ");
INSERT INTO loq_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesu amba ɓabuyisa yokye: «Naewɔlɛ nde phɛlɛ phɛlɛ ngakye: Toondukye phɔ ya oɓokye wawɛnɛ bilekyesako, kasi phɔ wazaka mapa wambaka na maoka. ");
INSERT INTO loq_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Osengyesi imiambya o etoma phɔ ya izwa ntoma ite iunve, yamoephɛ Ŋwana wa Moto, kasi phɔ ya ntoma ikyiɔtɔnɔ phe. Phɔ eli Tata, yo ooli Ŋwaphongo, owa mophɛ ɓokonzi.» ");
INSERT INTO loq_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ɓoɓɛlɛ ɓamba ya wɔ nɛ ɓɛkye: «Tosengyesi ikyela ɓoo phɔ ya ikyela bitoma biizingye Ŋwaphongo oɓokye tobikyele?» ");
INSERT INTO loq_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesu amba ɓabuyisa yokye: «Etoma ya Ŋwaphongo eli nde ianolela owatoma yo.» ");
INSERT INTO loq_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ɓamba ya mobuyisa ɓɛkye: «Kasi wɛ, elekyesako iye eyamokyela wɛ phɔ toewɛnɛ emba tombe eanolela? Etoma ya wɛ iye? ");
INSERT INTO loq_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","O obokye, ɓaango ɓa ɓanga ɓazaka mana, nde ɓo wakoma ɓɛ́ɛ oɓokye: “Aɓaphɛkyɛ ya iza, mapa maute o ikolo.”» ");
INSERT INTO loq_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Kasi Yesu amba wɔ na ɓɛ́ɛ yokye: «Naewɔlɛ nde phɛlɛ phɛlɛ, teli Mose owaephɛkyɛ mapa ma ikolo, kasi eli nde Tata okoephɛ maakolo mapa ma ikolo. ");
INSERT INTO loq_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Phɔ mapa ma Ŋwaphongo, eli nde yo okoute o ikolo na okoambya ɓomɔɔ o mokyisi.» ");
INSERT INTO loq_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Emba ɓamba ya wɔ nɛ ɓɛkye: «Nkolo, olophɛkyɛ nkɔlɔ isɔ mapa mɛ.» ");
INSERT INTO loq_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesu amba ya wɔ na ɓɛ́ɛ yokye: «Eli nde nga oli ipa sa ɓomɔɔ, moto okoye oka nga etakule oka nzala. Moto okonzanole etaokye phowa ya maa. ");
INSERT INTO loq_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Kasi naambo wɔ ngakye: Ɓɛ̀ɛ owɛni emba toanole. ");
INSERT INTO loq_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ɓato ɓasɔ ɓaampɛ Tata, ɓamoya oka nga, emba okoye oka nga, esi movakye, ");
INSERT INTO loq_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","phɔ nauta o ikolo phɔ ya iyakyela ɓokozingye owantoma, kasi ɓokozingye nga phe. ");
INSERT INTO loq_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Nzuka, phowa ya owantoma eli oɓokye nga sabungya nɔnɔ moto mɔnɔmɔ mi ɓaampɛ yo, kasi oɓokye naɓakundole o mokɔlɔ ŋwa suka. ");
INSERT INTO loq_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Phowa ya Tata yango eye: Moto munsɔ owɛni Ŋwana ambi na moanola, azwe ɓomɔɔ pha ɓoɓɛlɛ. Emba nga, naamokundola o mokɔlɔ ŋwa suka.» ");
INSERT INTO loq_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Tata wamɔ, Ɓayuda ɓabuto ingunguɓana nɛ phɔ awɔkɔ oɓokye: «Nali ipa siute o ikolo.» ");
INSERT INTO loq_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Emba ɓambaka kula wɔ ɓɛkye: «Teli yo Yesu, ŋwana wa Zozefu? Teloeɓe nyango na ango? Ndengye'ye akokyi iwɔ uŋwaŋwa eye oɓokye: “Nauta o ikolo?”» ");
INSERT INTO loq_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesu amba kula ya ɓabuyisa yokye: «Lɛ ingunguɓana onte ya ɓɛ̀ɛ! ");
INSERT INTO loq_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Moto takokyi iya oka nga ɓo Tata owantoma tamokambi, emba nga naamokundola o mokɔlɔ ŋwa suka.» ");
INSERT INTO loq_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ɓaimosi ɓakoma ɓɛkye: Ɓato ɓasɔ ɓamoteyama na Ŋwaphongo. Moto munsɔ owa oka yauta na Tata ambi na anola mateya mɛ, kaye oka nga. ");
INSERT INTO loq_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Eli oɓokye na moto taika wɛnɛ Tata, ɓo teeɓe nde owauta na Ŋwaphongo. Iyo, awɛnɛ Tata. ");
INSERT INTO loq_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Naewɔlɛ nde phɛlɛ phɛlɛ, moto okoanole ali na ɓomɔɔ pha ɓoɓɛlɛ. ");
INSERT INTO loq_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nali ipa sa ɓomɔɔ. ");
INSERT INTO loq_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","O bokye, ɓaango ɓa ɓɛ̀ɛ ɓazaka mana, emba ɓawa. ");
INSERT INTO loq_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Mapa maute o ikolo mali oɓokye moto owaamazaa, etaawe. ");
INSERT INTO loq_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","«Nali ipa sa ɓomɔɔ siuti o ikolo. Moto owamoza ipa mɛ amoɓa na ɓomɔɔ phɔ ya ɓoɓɛlɛ. Emba ipa samoambya nga, eli nzoto ya nga, yambyami phɔ ya oɓokye mokyisi mozwe ɓomɔɔ.» ");
INSERT INTO loq_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Yango mɛna, Ɓayuda ɓamba butwa iika ziiko na ɓokusi onte ya ɓɛ, ɓɛkye: «Ndengye'ye moto mɔna akokyi ilophɛ nzoto yɛ oɓokye toize?» ");
INSERT INTO loq_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yesu amba ya wɔ na ɓɛ́ɛ yokye: «Naewɔlɛ nde phɛlɛ phɛlɛ, ɓo toze nzoto ya Ŋwana wa Moto, ɓo tombi na nywa malongo mɛ, otoozwe ɓomɔɔ. ");
INSERT INTO loq_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Moto okoze nzoto ya nga, na okonywe malongo ma nga, ali na ɓomɔɔ pha ɓoɓɛlɛ. Emba nga, naamokundola o mokɔlɔ ŋwa suka. ");
INSERT INTO loq_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Phɔ nzoto ya nga ili yaakolo ntoma, na malongo ma nga mali maakolo malɛku. ");
INSERT INTO loq_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Moto okoze nzoto ya nga, na okonywe malongo ma nga, ali onte ya nga, na nga nali onte yɛ. ");
INSERT INTO loq_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Emba ɓo wantoma Tata ooli na ɓomɔɔ na oɓokye nali na ɓomɔɔ phɔ yɛ, yango mɛna moto owamoza nzoto ya nga, amoɓa na ɓomɔɔ phɔ ya nga. ");
INSERT INTO loq_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ipa sauta o ikolo sili ɓoɓo: Sikyɛsɛ na saazaka ɓaango ɓa ɓɛ̀ɛ. Ɓɛ́ɛ ɓawa, kasi moto owamoza ipa siwɛnɛ ɓɛ̀ɛ sisi, amoɓaa na bomɔɔ phɔ ya ɓoɓɛlɛ.» ");
INSERT INTO loq_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Mɛna yaɓaka mateya ma Yesu o mangambi ma makyita ma Ɓayuda o Kapalanauma. ");
INSERT INTO loq_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Sima ya imooka, ɓaekosi ɓɛ́ɛ ɓaikye ɓamba butwa iwɔ ɓɛkye: «Iloɓa sisi sili sikusi! Okokyi imooka nza?» ");
INSERT INTO loq_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Kasi waeɓa yo mampenza oɓokye ɓaekosi ɓɛ̀ɛ ɓagunguɓane phɔ ya iloɓa mɛ, Yesu amba wɔ na ɓɛ́ɛ yokye: «Iloɓa mɛ siephɛ yɔ? ");
INSERT INTO loq_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Emba ɓombi wɛnɛ Ŋwana wa Moto kabaa o elele eyaɓaka yo phanza?… ");
INSERT INTO loq_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Eli nde Ɓolɔɓɔ okambya ɓomɔɔ, nzoto tikyele ekpele. Maphɔɔ maewɔsi nga, mali Molimo na ɓomɔɔ. ");
INSERT INTO loq_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Kasi wali ɓaayɔkɔ onte ya ɓɛ̀ɛ, ɓate ɓaanole.» Phɔ Yesu aeɓaka tata o etatele ɓaaɓaka ɓawa ɓate ɓaikaka anola na nza owamuungya. ");
INSERT INTO loq_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Amba kula wɔ yokye: «Yango mɛna, nawɔkyi na ɓɛ̀ɛ ɓokye: “Moto takokyi iya oka nga ɓo Tata tamoanolesi.”» ");
INSERT INTO loq_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Tata mokɔlɔ mamuna, ɓaekosi ɓɛ̀ɛ ɓaikye ɓamanaka emba teɓakulaka moɓenga. ");
INSERT INTO loq_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Emba Yesu amba ya wɔɔ na Iko mbuka ɓaɓale yokye: «Na ɓɛ̀ɛ, tozingye na ɓɛ̀ɛ ikyɛndɛ?» ");
INSERT INTO loq_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simo Petelo amba ya mobuyisa yokye: «Nkolo, tomokula kyɛndɛ oka nza? Iwɛ oli na maphɔɔ ma ɓomɔɔ pha ɓoɓɛlɛ. ");
INSERT INTO loq_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Na ɓanga, toanosi emba toebi oɓokye oli Mosantu wa Ŋwaphongo.» ");
INSERT INTO loq_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesu amba ɓabuyisa yokye: «Teli nga moto owa eɔlɔ, ɓɛ̀ɛ Iko mbuka ɓaɓale? Emba mɔnɔmɔ na ɓɛ̀ɛ ali zabulu!» ");
INSERT INTO loq_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Awɔkɔ ɓaɓona na Yudasi, ŋwana wa Simo Mosikaliyota. Phɔ yaɓaka yo owamuungya, iyo, mɔnɔmɔ na Iko mbuka ɓaɓale. ");
INSERT INTO loq_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Sima mɛ, Yesu aɓa nde ikyɛmikyɛndɛ o manyɛtɛ ma Galileya. Taikaka ɓenela ikyɛmikyɛndɛ o manyɛtɛ ma Yuda waaɓaka Ɓayuda ɓalukye imoɓoma. ");
INSERT INTO loq_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Nzuka esɛlɛkɔ ya Ɓayuda eya ndalaku ya butwaka phɛnɛphɛ. ");
INSERT INTO loq_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ɓoɓɛlɛ, ɓana nyango ɓamba ya wɔ nɛ ɓɛkye: «Mana wawa okyɛndɛ o Yuda phɔ ɓaekosi ɓa wɛ, na ɓɛ́ɛ mɛ, ɓawɛnɛ bitoma bikyele wɛ. ");
INSERT INTO loq_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Moto okozingye oɓokye ɓato ɓamoeɓe, takyele maphɔɔ mɛ mi iɓombo. Phɔ kokyele bitoma ndengye eye, omiwɛninya o mokyisi!» ");
INSERT INTO loq_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Phɔ, ɓanaa nyango mampenza teɓaikaka moanola. ");
INSERT INTO loq_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Emba Yesu amba wɔ na ɓɛ́ɛ yokye: «Imbɛlɛ sa nga naino tesikokyi. Imbɛlɛ saaka ɓɛ̀ɛ sakoka. ");
INSERT INTO loq_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Mokyisi temokokyi iyeina. Kasi nga, mokyisi munzine phɔ nawɔ ngakye bitoma ba ɓɛ́ɛ bili biɓe. ");
INSERT INTO loq_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Kyɛndɛ o esɛlɛkɔ mɛna. Phɔ ya nga, esikyɛ omɔ, phɔ imbɛlɛ sa nga naino tesikokyi.» ");
INSERT INTO loq_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Sima ya iwɔ ɓaɓona, amba ikala o Galileya. ");
INSERT INTO loq_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Kasi waakyɛ ɓanaa nyango o esɛlɛkɔ, nɛ amba yakyɛ omɔ, samiwɛninya, akyɛkyɛ nde mi iɓombo. ");
INSERT INTO loq_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Onte ya esɛlɛkɔ, Ɓayuda ɓamolukaka emba ɓamba wɔ ɓɛkye: «Ani ɓaa bi?» ");
INSERT INTO loq_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Onte ya moluku ŋwa ɓato, ɓaikaka ziko phɔ yɛ. Ɓana ɓawɔkɔ ɓɛkye: «Ali moto wa maphɔɔ malaa», ɓayɔkɔ ɓɛkye: «Phe, kakosa ɓato.» ");
INSERT INTO loq_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Na ɓo ɓaɓona, moto na mɔnɔmɔ tamekaka iwɔ polele phɔ yɛ, phɔ ya ila Ɓayuda. ");
INSERT INTO loq_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Waakoma ɓɛ́ɛ onte ya nkɔlɔ ya esɛlɛkɔ, Yesu amba ya kyɛ o Tempelo emba abuto iteya. ");
INSERT INTO loq_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ɓayuda ɓakamwaka na mateya mɛ emba ɓamba wɔ ɓɛkye: «Ndengye'ye iyo taika ekola kambe eɓa maphɔɔ makoma ɓɛ?» ");
INSERT INTO loq_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesu amba ɓabuyisa yokye: «Mateya ma nga temaute na nga, kasi na owantoma. ");
INSERT INTO loq_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ɓo moto kazingye ikyela phowa ya Ŋwaphongo, amoeɓa ɓo mateya mama maute na Ŋwaphongo naa ɓo namiwɔlɛ nga mampenza. ");
INSERT INTO loq_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Moto ookowɔ phɔ yɛ, kalukye nkyɛmɔ yɛ mampenza. Kasi ookolukye nkyɛmɔ ya owamotoma, ali na maphɔɔ maa phɛlɛ. Emba ɓɔlɛ teɓoli onte yɛ. ");
INSERT INTO loq_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Teli Mose owaephɛ Miɓeko? Kasi nɔnɔ moto mɔnɔmɔ onte ya ɓɛ̀ɛ takyele ɓokowɔ Miɓeko: Phɔ yaye kolukye imboma?» ");
INSERT INTO loq_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Moluku ŋwa ɓato ɓamba mobuyisa ɓɛkye: «Oli na molemba o nzoto ya wɛ! Okolukye ieɓoma nza?» ");
INSERT INTO loq_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesu amba kula yakpa maloɓa amba wɔ na ɓɛ́ɛ yokye: «Nakyesi nde etoma yɔnɔyɔ, ɓɛ̀ɛ ɓasɔ okamo! ");
INSERT INTO loq_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mose awɔkɔ na ɓɛ̀ɛ oɓokye oɓɛlɛkye ɓana ɓa ɓampele — lauta na ɓankɔkɔ kasi na Mose phe — emba ɓɛ̀ɛ kolokyele na mokɔlɔ ŋwa Saɓata. ");
INSERT INTO loq_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ka ɓo ɓɛ̀ɛ koɓɛlɛ moto mokɔlɔ ŋwa Saɓata sa nka eya oɓokye Moɓeko ŋwa Mose mɔɔtɔ, ka phɔ yaye kontɔmbɛlɛ phɔ nabikye moto mokɔlɔ ŋwa saɓata? ");
INSERT INTO loq_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Sakyeka maɓoo ma ɓato ɓo kotene ɓolombe, kasi tena ɓolombe na ɓosembo.» ");
INSERT INTO loq_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ɓato ɓa Yelusalɛmɛ ɓawɔkɔ ɓɛkye: «Mɛna teli ookolukye ɓɛ́ɛ oɓokye ɓamoɓome? ");
INSERT INTO loq_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Kyeka kawɔ mi pha emba teɓamowɔlɛ na lowɔɔ! Bakonzi ɓa ɓanga ɓaeɓaka phɛlɛ oɓokye eli nde yo Klisto? ");
INSERT INTO loq_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Kasi moto oyo, ɓanga toeɓe biute yo, nzuka imbɛlɛ samoya Klisto, na moto etaeɓe biuti yo.» ");
INSERT INTO loq_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ɓoɓɛlɛ Yesu owateyaka o Tempelo, aimolaka yokye: «Konzeɓe! Koeɓe biuti nga? Kasi sikyi ya na ndengye ya nga mampenza. Owantoma kawɔ phɛlɛ, yo otoeɓe ɓɛ̀ɛ. ");
INSERT INTO loq_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nga, namoeɓe phɔ naute oka yɛ, eli yo owantoma.» ");
INSERT INTO loq_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Emba ɓambaka luka nde imoakya. Kasi na moto taika na moakya phɔ ngonga yɛ teyataaka koka. ");
INSERT INTO loq_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Onte ya moluku ŋwa ɓato, ɓaikye ɓamoanolaka, ɓambaka wɔ ɓɛkye: «Waamoya Klisto, amokyela bilekyesako biikye koleka bikyele moto oyo?» ");
INSERT INTO loq_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Yaaɓaka ɓɛ́ɛ ɓakyɛ mikɔlɔ onte ya moluku ŋwa ɓato phɔ yɛ, yakomaka o matoo ma Ɓafalisayi. Emba ɓanganga ɓanɛnɛ na Ɓafasayi ɓamba ya toma ɓabulusi phɔ ya imoakya. ");
INSERT INTO loq_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yesu amba wɔ yokye: «Nata kuta kula ɓa na ɓɛ̀ɛ ŋwana imbɛlɛ, emba namokyɛndɛ oka owantoma. ");
INSERT INTO loq_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ɓɛ̀ɛ wamunduka kasi ontonzwe. Phɔ elele eyamoɓa nga, ɓɛ̀ɛ otokome omɔ.» ");
INSERT INTO loq_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Tata wamɔ, Ɓayuda ɓabutwaka iwɔnɔ onte ya ɓɛ́ɛ ɓɛkye: «Amunakyɛndɛ mi elele iye eyamoɓaa ɓanga sakyɛ mozwa? Amokyɛ ɓenga ɓakyɛminyangwa onte ya Ɓaela? Amokyɛ teya Ɓaela? ");
INSERT INTO loq_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Maphɔɔ maawɔ yo mamana maluke iwɔ ɓo: Ɓɛ̀ɛ wamunduka kasi ontonzwe, na oɓokye: Elele eyamoɓa nga, ɓɛ̀ɛ otokome omɔ?» ");
INSERT INTO loq_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Mokɔlɔ ŋwa suka ya esɛlɛkɔ, muna moolekye nkɔlɔ isɔ, Yesu aesi ya tɛmɛ, abuto iimola yokye: «Ɓo moto ali na phowa ya maa, aye oka nga, ambe ya nywa. ");
INSERT INTO loq_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Moto ookonzanole; ɓo wawɔ buku pha Ŋwaphongo: “Uta o ndondo yɛ, bibale ba maa ma ɓomɔɔ biamolukwa.”» ");
INSERT INTO loq_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Awɔkɔ ɓaɓona na Ɓolɔɓɔ pha sengyelaka izwa ɓato ɓaamoanolela. Na ɓosembo Ɓolɔɓɔ tephataka ɓa phɔ Yesu tataka zwa naino nkyɛmɔ. ");
INSERT INTO loq_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Onte ya moluku, ɓato ɓaokaka maphɔɔ mɛ, ɓakyi ɓɛkye: «Nde phɛlɛ, kyeka Moimosi!» ");
INSERT INTO loq_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ɓana ɓɛkye: «Klisto, eli nde yo.» Kasi ɓayɔkɔ ɓakulaka wɔ ɓɛkye: «Klisto akokyi itɔkɔlɔ o Galileya? ");
INSERT INTO loq_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Buku pha Ŋwaphongo teɓowɔ oɓokye amoɓa wa ɓosoo Davidi, emba amouta o Ɓɛtɛlɛyɛmɛ, mokyisi mokyikyi ŋwaauta Davidi?» ");
INSERT INTO loq_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Yango mɛna ɓato ɓaamba kaɓwana phɔ yɛ. ");
INSERT INTO loq_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ɓato ɓayɔkɔ onte ya ɓɛ, ɓalukaka imoakya, kasi na moto mɔnɔmɔ taika mokuma. ");
INSERT INTO loq_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ɓoɓɛlɛ ɓabulusi ɓamba ya butwa ooli ɓanganga ɓanɛnɛ na Ɓafalisayi. Ɓamba ya wɔ na ɓabulusi oɓokye: «Phɔ ya'ye ɓɛ̀ɛ toikyi ya nɛ?» ");
INSERT INTO loq_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ɓabulusi ɓamba yabuya ɓɛkye: «Moto taawɔ ɓokowɔ moto mɔna!» ");
INSERT INTO loq_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ɓafalisayi ɓamba wɔ na ɓɛ́ɛ ɓɛkye: «Olukakyi na ɓɛ̀ɛ imoanolela mɛ? ");
INSERT INTO loq_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Onte ya ɓankumu naa onte ya Ɓafalisayi, wali mɔnɔmɔ omoanolesi? ");
INSERT INTO loq_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Eli nde moluku ŋwa ɓato ɓateɓaeɓe Moɓeko, ɓato ɓaaza ɓɛ!» ");
INSERT INTO loq_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Kasi mɔnɔmɔ onte ya Ɓafalisayi, Nikodɛmɛ owa kyɛkyɛ oka Yesu phanza, yokye: ");
INSERT INTO loq_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«Moɓeko ŋwa ɓanga munyɛtɛ moto ɓo naino tomookyi naa ieɓa maphɔɔ makyele yo?» ");
INSERT INTO loq_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ɓamba mobuyisa ɓɛkye: «Na wɛ toli moto wa Galileya? Luka na ɓolaa emba wamowɛnɛ oɓokye o Galileya, tewakokyi itɔkɔlɔ moimosi.» ");
INSERT INTO loq_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ɓamba ya butwa moto na moto o ingambi sɛ. ");
INSERT INTO loq_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Emba Yesu amba ya kyɛndɛ o ngomba ya ɓa Olive. ");
INSERT INTO loq_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Waakoma waa mumbengu, amba kula ya o Tempelo. Emba ɓo waɓaka ɓato ɓasɔ ɓaye oka yɛ, amba ya zala abuto iɓateya. ");
INSERT INTO loq_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ɓoɓɛlɛ, ɓateye ɓa miɓeko na Ɓafalisayi ɓamba moyelela na ŋwaŋwasi mɔnɔmɔ owazwaka ɓɛ́ɛ na lele mosuu, emba ɓamba ya motɛya onte ya ɓɛ́ɛ ɓasɔ. ");
INSERT INTO loq_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ɓamba ya wɔ nɛ ɓɛkye: «Moteye, ŋwaŋwasi oyo, tomozwe na lele mosuu. ");
INSERT INTO loq_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","O buku pha Moɓeko, Mose awɔ na ɓanga oɓokye toɓome ɓaɓasi ɓa ndengye mɛna na maɓanga. Emba wɛ, kowɔ ɓo?» ");
INSERT INTO loq_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ɓawɔkɔ ɓaɓona na maumunya ma imobekyisa izɛngyɛ, phɔ ɓazwe eleko ya imophunda. Kasi Yesu, amba ya miinya, abuto iwala nzɛnzɛ na munsɛɛ o manyɛtɛ. ");
INSERT INTO loq_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Waaɓa ɓɛ́ɛ ɓalendendale nde na imotuna mituna, Yesu amba ya miinola, amba ya wɔ na ɓɛ́ɛ yokye: «Onte ya ɓɛ̀ɛ, otowaikakyela isumu, aɓe moto owa o ɓoo wa imuma iɓanga.» ");
INSERT INTO loq_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Emba kula yo miinya, akuli butwa iwala nzɛnzɛ o manyɛtɛ. ");
INSERT INTO loq_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Waoka ɓɛ́ɛ maphɔɔ mamana, mɔnɔmɔ na mɔnɔmɔ atati imigbɔlɔ, tata na ɓaphomba. Emba Yesu amba ya ikala yo mampenza na ona ŋwaŋwasi owa tɛmɛkyɛ onte ya iɓɔkɔ. ");
INSERT INTO loq_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesu amba ya miinola, amba ya wɔ nɛ yokye: «Ŋwaŋwasi, ɓɛ́ɛ ɓawa? Na moto mɔnɔmɔ taikyi ema iɓanga?» ");
INSERT INTO loq_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Amba ya buya yokye: «Nkolo, moto phe.» Emba Yesu amba ya wɔ nɛ yokye: «Na nga mɛ, siiema iɓanga. Kyɛndɛ, kasi tata lɔlɔ sakula kyela isumu.» ");
INSERT INTO loq_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesu akulaka wɔ na ɓɛ́ɛ yokye: «Nali moo ŋwa mokyisi. Moto okombengye, etaatambule o enzɔmbi, amozwa moo mokambe o ɓomɔɔ.» ");
INSERT INTO loq_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Emba Ɓafalisayi ɓamba ya wɔ nɛ ɓɛkye: «Komiwɔlɛ wɛ mampenza! Munɔkɔ ŋwa wɛ tolokokyi imoanola» ");
INSERT INTO loq_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesu amba ɓabuyisa yokye: «Eli phɛlɛ oɓokye namiwɔlɛ nga mampenza, kasi munɔkɔ ŋwa nga moli ŋwa ianola, phɔ naeɓe mbale euti nga na mbale ekyekyɛ nga; kasi ɓɛ̀ɛ, toeɓe biuti nga na bi kyɛ nga. ");
INSERT INTO loq_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ɓɛ̀ɛ kosambisa na ndengye ya ɓomoto. Inga sii sambisa moto. ");
INSERT INTO loq_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Emba ɓo eniɓa oɓokye na sambisa, isambisa sa nga sili nde phɛlɛ phɔ sili nga mampenza, eli na owantoma. ");
INSERT INTO loq_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","O Moɓeko ŋwa ɓɛ́ɛ mampenza nga ɓakoma oɓokye ɓo nɔkɔ ya ɓato ɓaɓale ikokaa ɓakokyi iianola. ");
INSERT INTO loq_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Namiwɔlɛ nga mampenza, emba Tata owantoma kawɔ phɔ nga mɛ.» ");
INSERT INTO loq_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Emba ɓamba wɔ nɛ ɓɛkye: «Ɔngɔ ali bi?» Yesu amba buya yokye: «Toonzeɓe, tooeɓe na Tata. Ɓowanzeɓaka, okokakyi ieɓa na Tata.» ");
INSERT INTO loq_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Awɔkɔ maphɔɔ mamana o elele ekye ambya ɓɛ́ɛ makaɓo, waɓa yo kateya o Tempelo. Moto na mɔnɔmɔ taika moakya, phɔ ngonga yɛ teyaikaka koka. ");
INSERT INTO loq_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesu amba kula wɔ na ɓɛ́ɛ yokye: «Nakyɛndɛ, wa munduka, kasi wamowa na masumu ma ɓɛ. Elele ekyekyɛ nga, tokokyi ikyɛndɛ omɔ.» ");
INSERT INTO loq_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Emba Ɓayuda ɓamba wɔ ɓɛkye: «Ali na maumunya ma imiɓoma phɔ kawɔ yokye: “Elele eya mokyɛndɛ nga, tokokyi ikyɛndɛ omɔ?”» ");
INSERT INTO loq_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesu amba ɓabuyisa yokye: «Ɓɛ̀ɛ oli ɓato ɓa o se, nga nauti o ikolo. Ɓɛ̀ɛ oli ɓato ɓamokyisi mumu, nga sili wa mokyisi mumu. ");
INSERT INTO loq_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Yango mɛna, nawɔkyi na ɓɛ̀ɛ oɓokye wa mowa na masumu ma ɓɛ̀ɛ. Phɔ na ɓo toanosi oɓokye Nali, wamowa na masumu ma ɓɛ̀ɛ.» ");
INSERT INTO loq_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Emba ɓamba ya wɔ ɓɛkye: «Iwɛ oli nza?» Yesu amba ɓabuyisa yokye: «Ikyiiewɔlɛ nga uta o etatele. ");
INSERT INTO loq_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Phɔ ya ɓɛ̀ɛ, nali na maphɔɔ maikye ma iwɔ na ma isambisa, kasi owantoma kawɔ phɛlɛ. Na yaoka nga nɛ, ili yango ikyi wɔ nga o mokyisi.» ");
INSERT INTO loq_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Teɓaikaka sɔsɔlɔ oɓokye aɓawɔlɛkyɛ phɔ ya Ango. ");
INSERT INTO loq_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ɓoɓɛlɛ, Yesu amba ya ɓawɔlɛ yokye: «Waamotomba ɓɛ́ɛ Ŋwana Moto, wamoeɓa oɓokye Nali, simbe nakyela maphɔɔ na ndengye ya nga mampenza: Nawɔ nde maphɔɔ maanteya Tata. ");
INSERT INTO loq_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Owantoma ali na nga, taika ndɛ nga mampenza, phɔ nakyele nkɔlɔ isɔ maphɔɔ maamosepelisa.» ");
INSERT INTO loq_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Waaɓa yo kawɔ ɓaɓona, ɓato ɓaikye ɓamoanolaka. ");
INSERT INTO loq_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ɓoɓɛlɛ, Yesu amba ya wɔ na Ɓayuda ɓaamoanolaka yokye: «Ɓo oikasi iɓanza maphɔɔ ma nga, oli phɛlɛ ɓaekosi ɓanga, ");
INSERT INTO loq_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","wamoeɓa maphɔɔ ma phɛlɛ emba maphɔɔ mɛ mamoeyikola.» ");
INSERT INTO loq_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ɓamba mobuyisa ɓɛkye: «Ɓanga toli ɓana ɓa Abalayama, tololi ɓaombo ɓa moto: Phɔ ya'ye kowɔ oɓokye tomoikolama?» ");
INSERT INTO loq_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesu amba ya ɓabuyisa yokye: «Nawɔ na ɓɛ̀ɛ nde phɛlɛ phɛlɛ, ngakye, moto okokyele masumu ali moombo ŋwa masumu. ");
INSERT INTO loq_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Moombo taaikale nkɔlɔ isɔ o ingambi, kasi ŋwana, yo kaikale o ingambi phɔ ya ɓoɓɛlɛ. ");
INSERT INTO loq_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ɓo Ŋwana aeyikosi, wamoɓa ɓaakolo ɓato ɓaaikola ɓɛ. ");
INSERT INTO loq_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Naeɓe oɓokye ɓɛ̀ɛ oli ɓana ɓa Abalayama, kasi phɔ maphɔɔ ma nga te manyɔlɔ onte ya ɓɛ̀ɛ, kolukye imboma. ");
INSERT INTO loq_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nga, nawɔ maphɔɔ maawɛnɛ nga oka Tata, kasi ɓɛ̀ɛ, kokyele maphɔɔ maoka ɓɛ̀ɛ oka ango wa ɓɛ̀ɛ!» ");
INSERT INTO loq_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ɓamba mobuyisa ɓɛkye: «Ango wa ɓanga, eli Abalayama.» Yesu amba ya wɔ na ɓɛ́ɛ yokye: «Ɓo oli ɓana ɓa Abalayama, kyela bitoma ɓa Abalayama. ");
INSERT INTO loq_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Kasi uŋwaŋwa eye, ɓɛ̀ɛ kolukye imboma, nga, oewɔsi maphɔɔ ma phɛlɛ maoka nga oka Ŋwaphongo. Abalayama taika kyela ɓaɓona. ");
INSERT INTO loq_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Kasi ɓɛ̀ɛ, kokyele bitoma ɓa ango wa ɓɛ̀ɛ.» Ɓamba mobuyisa ɓɛkye: «Ɓanga tololi ɓana ɓaaɓota ɓɛ́ɛ mi eɓembi! Toli nde ango mɔnɔmɔ, Ŋwaphongo!» ");
INSERT INTO loq_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesu amba ya wɔ na ɓɛ́ɛ yokye: «Ɓo Ŋwaphongo aɓakyi ɔngɔ wa ɓɛ̀ɛ, nde wanzingaka, phɔ natɔkɔlɔ oka Ŋwaphongo namba kula uta nde oka yɛ. Siika ya na ndengye ya nga mampenza, eli Yo owantoma. ");
INSERT INTO loq_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Phɔ ya'ye ɓɛ̀ɛ toosɔsɔlɔ ewɔsi ya nga? Phɔ tookokye iyoka maphɔɔ ma nga. ");
INSERT INTO loq_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Angɔ wa ɓɛ̀ɛ eli Zabulu, emba oli na phowa ya ikokya maphowa ma ango wa ɓɛ̀ɛ. Uta o etatele aɓaka nde moɓomi wa ɓato, taika miambya i maphɔɔ ma phɛlɛ phɔ maphɔɔ ma phɛlɛ temali onte yɛ. Waakate yo ɓɔɔlɛ, loute o ndondo yɛ, phɔ ali moto wa ɓɔɔlɛ na ango wa ɓɔɔlɛ. ");
INSERT INTO loq_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ka phɔ ya Nga, phɔ na wɔ maphɔɔ ma phɛlɛ yango mɛna tonzanole. ");
INSERT INTO loq_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Moto nza, o nte ya ɓɛ̀ɛ owa munteya isumu sakyela nga? Ɓo na wɔ maphɔɔ ma phɛlɛ, phɔ ya'ye ɓɛ̀ɛ tonzanolele? ");
INSERT INTO loq_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Moto wa Ŋwaphongo, kaokye maphɔɔ ma Ŋwaphongo. Ka ootoli ɓɛ̀ɛ ɓato ɓa Ŋwaphongo, yango mɛna, ɓɛ̀ɛ toonzokye.» ");
INSERT INTO loq_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ɓayuda ɓamba mobuyisa ɓɛkye: «Toloikaka longa waawɔkɔ ɓanga oɓokye oli Mosamaliya na ná ɓolɔɓɔ ɓoɓe?» ");
INSERT INTO loq_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesu amba ɓabuyisa yokye: «Phe, sili na ɓolɔɓɔ ɓoɓe, kasi na kumbele Tata, kasi ɓɛ̀ɛ, toonkumbele! ");
INSERT INTO loq_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Siika na luka nkyɛmɔ nga mampenza, moto mosuu ali okoiyambya na ookosambisa. ");
INSERT INTO loq_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Naewɔlɛ nde phɛlɛ phɛlɛ, ɓo moto aɓanze maphɔɔ ma nga, etawe.» ");
INSERT INTO loq_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Emba Ɓayuda ɓamba ya wɔ nɛ ɓɛkye: «Iŋwaŋwa eye tombi ya eɓa oɓokye oli na ɓolɔɓɔ ɓoɓe! Abalayama awa, na ɓaimosi mɛ, kasi wɛ koya wɔ wɛkye: “Ɓo moto kaɓanza maphɔɔ ma nga, etaa we.” ");
INSERT INTO loq_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Iwɛ olekyi ango wa ɓanga Abalayama owa wa? Na ɓaimosi ɓaawa mɛ! Iwɛ kombe mipka nza?» ");
INSERT INTO loq_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesu amba ɓabuyisa yokye: «Ɓo namitatakyi nga mampenza, nkyɛmɔ ya nga nde teiɓe na ntina. Eli nde Tata oko ntate, iyo okoanole ɓɛ̀ɛ oɓokye ali Ŋwaphongo wa ɓɛ̀ɛ. ");
INSERT INTO loq_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ɓɛ̀ɛ toika moeɓa, kasi nga namoeɓe. Ɓo nawɔkɔ ngakye simoeɓe, nde na ɓa nde ya ɓɛ̀ɛ: Moto wa ɓɔɔlɛ. Kasi na moeɓe emba na ɓanza maphɔɔ mɛ. ");
INSERT INTO loq_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ango wa ɓɛ́ɛ Abalayama, aɓaka na nkyisa ya iumunya oɓokye amowɛnɛ mokɔlɔ ŋwa nga. Awɛnɛ mokolɔ mɛ, emba atondaka na nkyisa.» ");
INSERT INTO loq_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Waaawɔ yo ɓaɓona, Ɓayuda ɓamba wɔ nɛ ɓɛkye: «Naino tokokye na mambula mako matano, emba wamba wɛnɛ Abalayama!» ");
INSERT INTO loq_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesu amba ya ɓabuyisa yokye: «Naewɔlɛ nde phɛlɛ phɛlɛ, naino Abalayama sata ɓotama, Nga Nali.» ");
INSERT INTO loq_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ɓoɓɛlɛ, ɓamba ya ɔngɔ maɓanga phɔ ya imumaa, kasi Yesu amba miɓomba, nɔnɔ watɔkɔlɔ yo o Tempelo. ");
INSERT INTO loq_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Waaɓa Yesu kalekane, amba ya wɛnɛ moto mɔnɔmɔ owa ɓotama na miyo maphɔlɔ. ");
INSERT INTO loq_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ɓaekosi ɓɛ̀ɛ ɓamba ya motuna motuna mumu: «Labi, moto oyo aphɔlɔ miyo phɔ ya masumu mɛ ndee phɔ ya masumu ma ɓaɓoti ɓɛ̀ɛ?» ");
INSERT INTO loq_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesu amba buya yokye: «Teli yo naa ɓaɓoti ɓɛ̀ɛ. Kasi eli nde phɔ ya oɓokye bitoma ɓa Ŋwaphongo biwɛnɛnɛ onte yɛ! ");
INSERT INTO loq_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Waata ɓaa moo, tosengyesi ikyela bitoma ɓa owantoma. Waskome mokɔlɔ, moto takokyi ikula kyela etoma. ");
INSERT INTO loq_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Naino ootaɓa nga o mokyisi, nali moo ŋwa mokyisi.» ");
INSERT INTO loq_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Waawɔ yo ɓaɓona, Yesu amba ya towa matee o manyɛtɛ, aesi ya maphuta na manyɛtɛ amba ya mainga moto owa phɔlɔ miyo mɛ o miyo. ");
INSERT INTO loq_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Amba ya wɔ nɛ yokye: «Kyɛ mikunyola o mbondo ya Silowe». Kyelukye iwɔ oɓokye: Toma. Moto owa phɔlɔ miyo amba ya kyɛndɛ, akyɛ mikunyola, waaya butwa yo, abuto iwɛnɛ. ");
INSERT INTO loq_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ɓabuɓaa nɛ na ɓaɓaka ɓamowɛnɛ soosoo — phɔ aɓaka moongyi — ɓawɔkɔ ɓɛkye: «Teli yo owa ɓaka azasi kaongye?» ");
INSERT INTO loq_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ɓana ɓɛkye: «Eli nde yo!» Ɓayɔkɔ ɓɛkye: «Iyo phe, eli nde moula nɛ.» Kasi moto owa phɔlɔ miyo amba anola yokye: «Eli nde nga.» ");
INSERT INTO loq_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Emba ɓamba wɔ nɛ ɓɛkye: «Ka miyo ma wɛ mambi ziɓwa ndengye'ye?» ");
INSERT INTO loq_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Amba buya yokye: «Moto okoɓangye ɓɛ́ɛ Yesu, aphuti manyɛtɛ, amanzingyi o miyo, amba wɔ na nga yokye: “Kyɛ mikunyola o Silowe.” Ɓoɓɛlɛ nga, namba ya kyɛndɛ, namba mikunyola emba namba ya butwa iwɛnɛ.» ");
INSERT INTO loq_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ɓamba ya wɔ nɛ ɓɛkye: «Moto mɛ, ali bi?» Amba buya yokye: «Nga sieɓe.» ");
INSERT INTO loq_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ɓoɓɛlɛ, ɓaesi ya kyɛ na moto owaphɔlɔkɔ miyo oka Ɓafalisayi. ");
INSERT INTO loq_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Nzuka mokɔlɔ ŋwaa phutaka Yesu manyɛtɛ na ŋwaa moziɓolaka yo miyo, yaɓaka mokɔlɔ ŋwa Saɓata. ");
INSERT INTO loq_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ɓafalisayi ɓamba motuna na ɓɛ́ɛ ndengye'ye eya butwa yo iwɛnɛ. Amba ɓabuyisa yokye: «Anzinga mungyinda o miyo, na mikunyosi, nabuto iwɛnɛ.» ");
INSERT INTO loq_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Onte ya Ɓafalisayi ɓana ɓawɔkɔ ɓɛkye: «Moto oyo taakumole Saɓata, tali moto wa Ŋwaphongo.» Kasi ɓayɔkɔ ɓawɔkɔ ɓɛkye: «Moto wa masumu akokyi izwa ɓokonzi pha ikyela bilekyesako bibi ndengye'ye?» Emba ɓokaɓanakye ɓonyɔsi onte ya ɓɛ. ");
INSERT INTO loq_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ɓoɓɛlɛ ɓamba kula tuna moto owa phɔlɔ miyo ɓɛkye: «Ka wɛ, kowɔ ɓo phɔ ya oeziɓosi miyo?» Amba buya yokye: «Ali moimosi.» ");
INSERT INTO loq_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Kasi waaɓa ɓɛ́ɛ naino sata ɓanga ɓaɓoti ɓɛ, Ɓayuda teɓaikaka eɓa oɓokye aphɔlɔkɔ miyo amba butwa iwɛnɛ. ");
INSERT INTO loq_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ɓamba ya tuna ɓaɓoti ɓa ŋwana mɛ motuna mumu: «Moto oyo ali phɛlɛ ŋwana wa ɓɛ̀ɛ ookowɔ ɓɛ̀ɛ oɓokye aɓotama na miyo ma phɔlɔ? Emba uŋwanweye kawɛnɛ ndengye'ye?» ");
INSERT INTO loq_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ɓaɓoti ɓamba ɓabuyisa ɓɛkye: «Toeɓe oɓokye eli nde phɛlɛ ŋwana wa ɓanga, aɓotama na miyo ma phɔlɔ. ");
INSERT INTO loq_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Kasi ɓo buto yo iwɛnɛ uŋwaŋwa eye, ɓanga toloeɓe. Oomoziɓosi miyo nza? Tolomoeɓe. Omotune, ali phomba, aimole yo mampenza!» ");
INSERT INTO loq_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ɓaɓoti ɓɛ́ɛ ɓawɔkɔ ɓaɓona phɔ ɓailaka Ɓayuda. Ɓɛ́ɛ ɓaokanaka itɔkɔlɔ moto munsɔ okowɔ oɓokye Yesu ali Klisto o ingambi sa makyita. ");
INSERT INTO loq_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Yango mɛna, ɓaɓoti ɓawɔkɔ ɓɛkye: «Yo nga ali phomba, omotune yo mampenza.» ");
INSERT INTO loq_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Mbala eya iɓale. Ɓafalisayi ɓamba kula ɓanga moto owa phɔlɔkɔ miyo, ɓamba wɔ nɛ ɓɛkye: «Phɛ Ŋwaphongo ngambo! Ɓanga toeɓe oɓokye moto oyo ali moto wa masumu.» ");
INSERT INTO loq_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Amba ɓabuyisa yokye: «Nga sieɓe naa ali moto wa masumu. Naeɓe nde ekpele yɔnɔyɔ oɓokye: Naphɔlɔkɔ miyo emba uŋwaŋwa eye nabuto iwɛnɛ.» ");
INSERT INTO loq_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ɓamba wɔ nɛ ɓɛkye: «Aekyesi ye? Aeziɓosi miyo ndengye'ye?» ");
INSERT INTO loq_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Amba ɓabuyisa yokye: «Nambo eyimola, kasi ɓɛ̀ɛ tookye! Phɔ ya'ye kozingye oɓokye nakule eyimola mbala esuu? Emba na ɓɛ̀ɛ toli nde na phowa ya ibutwa ɓaekosi ɓɛ̀ɛ?» ");
INSERT INTO loq_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ɓoɓɛlɛ, Ɓafalisayi ɓabuto imotola, ɓamba wɔ ɓɛkye: «Moekosi nwɛ eli nde wɛ! Ɓanga toli ɓaekosi ɓa Mose. ");
INSERT INTO loq_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ɓanga toeɓe oɓokye Ŋwaphongo awɔkɔ na Mose, kasi moto mɔna, toloeɓe mbale euti yo!» ");
INSERT INTO loq_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Moto mɛ amba ɓabuyisa: «Eye eli lowɔ la ikamwa, oɓokye ɓɛ̀ɛ toeɓe mbale euti moto oyo, kasi yo anziɓosi miyo! ");
INSERT INTO loq_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ɓanga toeɓe oɓokye Ŋwaphongo taaokye ɓato ɓa masumu. Kasi ɓo moto ali mosambesi ŋwa phɛlɛ, kambe kyela na phowa ya Ŋwaphongo, Ŋwaphongo kamookye. ");
INSERT INTO loq_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Naino tolookyi ɓawɔ oɓokye moto aziɓosi miyo ma moto owa ɓotama na miyo maphɔlɔ. ");
INSERT INTO loq_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ɓo moto mɛ taɓakyi moto wa Ŋwaphongo, takokakyi ikyela na ekpele.» ");
INSERT INTO loq_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ɓamba ya buya ɓɛkye: «Iwɛ waɓotama onte ya masumu, emba kombe ya loteya?» Ɓamba movaka o nze. ");
INSERT INTO loq_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu aesi ya oka oɓokye ɓamowiinye. Amba yakyɛ vana nɛ, amba ya wɔ nɛ yokye: «Iwɛ, koanole Ŋwana wa Moto?» ");
INSERT INTO loq_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Amba ya buya yokye: «Yo nza, Nkolo, oɓokye namoanole?» ");
INSERT INTO loq_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesu amba wɔ nɛ yokye: «Ombo mowɛnɛ. Eli moto okowɔnɔ na wɛ.» ");
INSERT INTO loq_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Moto mɛ yokye: «Naanosi, Nkolo» Emba amba kusama o ɓoo phɛ. ");
INSERT INTO loq_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Emba Yesu amba wɔ nɛ yokye: «Naya o mokyisi phɔ ya iya sambisa, phɔ ya oɓokye ɓaate ɓaikaka wɛnɛ ɓawɛnɛ, emba ɓaaɓaka ɓawɛnɛ ɓɛ́ɛ sakula wɛnɛ.» ");
INSERT INTO loq_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ɓafalisayi ɓaaɓaka nɛ ɓaokaka maphɔɔ mɛ, ɓamba wɔ nɛ ɓɛkye: «Ɓoɓo na ɓanga tophɔlɔ miyo mɛ?» ");
INSERT INTO loq_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesu amba ɓabuyisa yokye: «Ɓo waɓaka ɓato ɓaaphɔlɔ miyo, nde toɓakyi na masumu. Kasi uŋwaŋwa eye kowɔ oɓokye: “Towɛnɛ”, oli nde ɓato ɓa masumu ɓoɓɛlɛ.» ");
INSERT INTO loq_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","«Naewɔlɛ nde phɛlɛ phɛlɛ oɓokye, moto owa moɓa sanyɔlɔ yaa moziɓo o lophango la mampate, kasi kaɓaa mopha mosuu, yo mɔna ali mwibi na moɓomi. ");
INSERT INTO loq_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Kasi okonyɔlɔ yaa moziɓo, ali mɔɔkɔsi ŋwa mampate. ");
INSERT INTO loq_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Sinzili amoziɓolela moziɓo, na mampate maokye ŋwɛsi nwɛ. Mampate mɛ, kamaɓange, yɔnɔyɔ na yɔnɔyɔ na nkombo ya yango, emba kamatɔkɔlɔ o nze. ");
INSERT INTO loq_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Waamatɔkɔlɔ yo masɔ, katambule o ɓoo pha mango, emba mamoɓengye phɔ maeɓe ŋwɛsi nwɛ. ");
INSERT INTO loq_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ete maaɓengye mobutu, kasi mamolota phɔ temaeɓe ŋwɛsi ŋwa ɓabutu.» ");
INSERT INTO loq_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu amba ɓakpela ete mɛna, kasi teɓaika sɔsɔlɔ ntina ya maphɔɔ maawɔkɔ yo. ");
INSERT INTO loq_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yesu amba kula wɔ yokye: «Naewɔlɛ nde phɛlɛ phɛlɛ ngakye, nali moziɓo ŋwa mampate. ");
INSERT INTO loq_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ɓasɔ ɓaaya o ɓoo pha nga ɓali ɓaibi na ɓaɓomi, kasi mampate temaika ɓaoka. ");
INSERT INTO loq_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Inga, nali moziɓo. Ɓo moto anyɔsi o nzela ya nga, amobika. Amokyɛndɛ, amoya amba zwa na ya izaa. ");
INSERT INTO loq_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Moibi yo kaye nde phɔ ya iiɓa, phɔ ya iɓoma na phɔ ya iɔtɔ. Nga, naya phɔ ya oɓokye ɓato ɓazwe ɓomɔɔ, ɓambe ɓozwa na ɓoikye. ");
INSERT INTO loq_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Nga, nali mɔɔkɔsi molaa wa mampate: Mɔɔkɔsi molaa kambya ɓomɔɔ phɛ phɔ ya mampate mɛ. ");
INSERT INTO loq_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ka moto okokyele etoma nde phɔ ya iphuti, tali owakolo mɔɔkɔsi wa mampate, tali na mokolo ŋwa mampate. Waawɛnɛ yo ngɔɔ kyeye, kaikye ika mampate emba yo kalote. Emba ngɔɔ kaya mabuta kambe na manyangola. ");
INSERT INTO loq_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Phɔ ali moto okokyele etoma nde phɔ ya iphuti emba mampate temali na ntina phɔ yɛ. ");
INSERT INTO loq_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Nga, nali mɔɔkɔsi molaa wa mampate, naeɓe mampate ma nga na mampate ma nga manzeɓe. ");
INSERT INTO loq_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Ɓoo konzeɓe Tata, na nga naeɓe Tata. Emba nambya ɓomɔɔ pha nga phɔ ya mampate. ");
INSERT INTO loq_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Nali na mampate masuu maate mali ma lophango lolo. Emba na mango mamana, nasengyesi imakamba. Ma mooka ŋwɛsi ŋwa nga emba ya moɓa nde ɓokanda ɓɔnɔɓɔ ná mɔɔkɔsi mɔnɔmɔ. ");
INSERT INTO loq_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Tata kanzingye phɔ naambya ɓomɔɔ pha nga phɔ ya ikula ɓozwa sima. ");
INSERT INTO loq_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Moto taika ɓɔlɔlɔ ɓomɔɔ pha nga, kasi naɓoambya nga mampenza. Nali na ɓokonzi pha iɓoambya na ná ɓokonzi pha ikula ɓokpa: Mɛna eli moɓeko ŋwa zwa nga na Tata.» ");
INSERT INTO loq_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Maphɔɔ mɛ mamba kula ambya nde ikaɓana onte ya Ɓayuda. ");
INSERT INTO loq_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ɓaikye onte ya ɓɛ́ɛ ɓamba wɔ ɓɛkye: «Ali na ɓolɔɓɔ ɓoɓe! Ayeyee! Phɔ ya'ye ɓɛ̀ɛ komookye?» ");
INSERT INTO loq_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Kasi ɓaayɔkɔ ɓawɔkɔ ɓɛkye: «Mɛna teli maphɔɔ ma moto oli na ɓolɔɓɔ ɓoɓe, ɓolɔɓɔ ɓoɓe akokyi iziɓola miyo ma moto owa phɔlɔ miyo?» ");
INSERT INTO loq_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Yaɓaka imbɛlɛ sa sɛkyɛ. Ɓakyelaka esɛlɛkɔ ya iumunya mokɔlɔ ŋwa ingolaka ɓɛ́ɛ Tempelo o Yelusalɛmɛ. ");
INSERT INTO loq_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","O Tempelo, Yesu aɓaka kakyɛ kaye o moziɓo ŋwa Salomo. ");
INSERT INTO loq_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ɓayuda ɓaesi ya molungya, ɓamba wɔ nɛ ɓɛkye: «Waa lolɛɛ ntema o ikolo nɔnɔ mokɔlɔ ye? Ɓo oli Klisto, oloimole polele!» ");
INSERT INTO loq_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesu amba ya ɓabuyisa yokye: «Nambo eyimola kasi ɓɛ̀ɛ toanole. Bitoma biikyele nga na nkombo ya Tata biwɔ phɔ ya nga, ");
INSERT INTO loq_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","kasi ɓɛ̀ɛ tonzanole phɔ toli mampate ma nga. ");
INSERT INTO loq_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Mampate ma nga maokye ŋwɛsi ŋwa nga, emnba nga namaeɓe, mambe na mbenga. ");
INSERT INTO loq_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Emba nga, namaphɛ ɓomɔɔ pha ɓoɓɛlɛ. Ete mawɛ na mbala, na moto takokyi imaɓɔlɔlɔ o maɓɔkɔ ma nga. ");
INSERT INTO loq_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Tata owa mampɛ alekyi na mwiya, emba na moto tali na makokyi ma iɓɔlɔlɔ ekpele o maɓɔkɔ ma Tata. ");
INSERT INTO loq_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nga na Tata toli moto mɔnɔmɔ.» ");
INSERT INTO loq_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ɓoɓɛlɛ, Ɓayuda ɓamba kula ya ɔngɔ maɓanga phɔ ya imumaa. ");
INSERT INTO loq_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Kasi Yesu amba ya ɓabuyisa yokye: «Naeteye bitoma biikye bilaa ɓauta oka Tata. Phɔ ya etoma iye ekyembe ɓɛ̀ɛ maa maɓanga?» ");
INSERT INTO loq_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ɓayuda ɓamba mobuyisa ɓɛkye: «Ɓanga telolukye iemaa maɓanga phɔ ya etoma elaa ekyesi wɛ, kasi phɔ kotole Ŋwaphongo, na phɔ iwɛ oli nde moto, komibuya wɛ mampenza Ŋwaphongo.» ");
INSERT INTO loq_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesu amba ya ɓabuyisa yokye: «O buku pha Moɓeko ŋwa ɓɛ̀ɛ, teɓaika koma oɓokye: “Nga nawɔ ngakye: Ɓɛ̀ɛ oli ɓa Ŋwaphongo?” ");
INSERT INTO loq_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Moɓeko ŋwaɓangaka ɓa Ŋwaphongo ɓato ɓaawɔlɛkyɛ Ŋwaphongo. Nzuka maphɔɔ maakomama o buku pha Ŋwaphongo temakokyi imana. ");
INSERT INTO loq_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ka owa kaɓa na owa toma Ŋwaphongo o mokyisi, ɓɛ̀ɛ kowɔ oɓokye: “Kotole Ŋwaphongo”, phɔ nawɔ ngakye nali Ŋwana wa Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ɓo sikyele bitoma ɓa Tata, ɓɛ̀ɛ sa nzanola! ");
INSERT INTO loq_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Kasi ɓo nabikyele, na ɓo tonzanole, anola nɔnɔ bitoma, phɔ oeɓe, ombe na eɓa na ɓolaa oɓokye Tata ali onte ya nga nde ɓooli nga onte ya Tata.» ");
INSERT INTO loq_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Emba, ɓamba kula luka mbala esuu ya imoakya, kasi amba ya ɓɛmbɛtɛnɛ o maɓɔkɔ ma ɓɛ. ");
INSERT INTO loq_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yesu amba kula ya butwa o mopha moyɔkɔ ŋwa Yaladɛnɛ, o elele eyaɓaka Yoane kaɓatisa phanza, emba amba ikala omɔ. ");
INSERT INTO loq_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ɓato ɓaikye ɓamba ya ooli yo, ɓamba wɔ ɓɛkye: «Phɛlɛ, Yoane taika kyela na elekyesako yɔnɔyɔ, kasi isɔ ya wɔ yo phɔ ya moto oyo ili phɛlɛ.» ");
INSERT INTO loq_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Emba omɔ, ɓato ɓaikye ɓamba moanola. ");
INSERT INTO loq_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Yaɓaka moto mɔnɔmɔ na nkombo Lazalo, aɓaka na ɓolɔsi o Ɓetani, mokyisi ŋwa Maliya na ŋwana nyango Malata. ");
INSERT INTO loq_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Eli nde ona Maliya owa ɔlɔlɔkɔ Nkolo malasi na owa mokunyolaka makolo na suwe yɛ. Yaɓaka ŋwana nyango Lazalo owaɓaka na ɓolɔsi. ");
INSERT INTO loq_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Mankanasa ma Lazalo maamba lɔngɔlɔ Yesu oɓokye: «Nkolo, kyeka ookozingye wɛ ali na ɓolɔsi.» ");
INSERT INTO loq_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Waaoka Yesu ɓaɓona, amba wɔ yokye: «Ɓolɔsi ɓaɓona teɓoli pha iwaa, kasi ɓoli phɔ ya iwɛninya nkyɛmɔ ya Ŋwaphongo. Nde na phango, ɓamokumola Ŋwana wa Ŋwaphongo.» ");
INSERT INTO loq_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu azingaka Malata na ŋwana nyango na Lazalo. ");
INSERT INTO loq_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Kasi waoka yo simo oɓokye Lazalo ali na ɓolɔsi, nde phɛlɛ, akulaka kyela nkɔlo iɓale o elele eyaɓaka yo. ");
INSERT INTO loq_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ɓoɓɛlɛ, sima mɛ, amba ya wɔ na ɓaekosi yokye: «Tokule butwa o Yuda.» ");
INSERT INTO loq_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ɓaekosi ɓamba ya wɔ nɛ ɓɛkye: «Labi, nde uŋwaŋwa eye Ɓayuda ɓalukakyi iema maɓanga, emba kokule butwa omɔ?» ");
INSERT INTO loq_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesu amba buyaa yokye: «Tewali mangonga iko mbuka maɓale ma moo? Ɓo moto katambule wa moo, taaɓakatane phɔ kawɛnɛ moo ŋwa mokyisi. ");
INSERT INTO loq_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Kasi ɓo moto katambule waa mokɔlɔ, amoɓakatana phɔ moo temoli onte yɛ.» ");
INSERT INTO loq_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Waaunva yo iwɔ ɓaɓona, amba ya wo na ɓɛ́ɛ yokye: «Nwɛbi na ɓanga Lazalo alasi, kasi na kyɛ moumola.» ");
INSERT INTO loq_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ɓaekosi ɓɛ̀ɛ ɓamba ya wɔ nɛ ɓɛkye: «Nkolo, ɓo alasi, amobika.» ");
INSERT INTO loq_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesu awɔkɔ ɓaɓona phɔ ya iwa sa Lazalo, kasi ɓɛ́ɛ ɓaumunyaka nde oɓokye kawɔ phɔ ya eyaakolo ebu. ");
INSERT INTO loq_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Yesu amba ya ɓawɔlɛ polele yokye: «Lazalo awe, ");
INSERT INTO loq_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","emba nali na nkyisa phɔ sikyi ɓa omɔ, phɔ ɓɛ̀ɛ oanole. Kasi tokyɛndɛ oka yɛ.» ");
INSERT INTO loq_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Emba Toma, okoɓangye ɓɛ́ɛ Ipasa, amba ya wɔ na ɓaekosi ɓayɔkɔ yokye: «Na ɓanga tokyɛndɛ mɛ, emba towe nɛ molɔngɔ.» ");
INSERT INTO loq_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Wakoma yo omɔ, Yesu akyɛ zwa oɓokye Lazalo ambo kyela nkɔlɔ ine o ilita. ");
INSERT INTO loq_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Yelusalɛmɛ na Ɓetani ɓali na itakye sa ɓakilomɛtɛlɛ phɛnɛphɛ na ɓaato. ");
INSERT INTO loq_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ɓaikye onte ya Ɓayuda ɓayakaka oka Malata na Maliya phɔ ya iya zala na ɓɛ́ɛ phɔ ya ŋwana nyango na ɓɛ́ɛ owawaka. ");
INSERT INTO loq_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Waaoka Malata oɓokye Yesu kaye, amba ya kyɛ moɓenga o nzela, mɛnɛ Maliya aikasi azasi o ingambi. ");
INSERT INTO loq_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Emba Malata amba ya wɔ na Yesu yokye: «Nkolo, ɓo waɓaka wawa, ŋwana mama nde tawa. ");
INSERT INTO loq_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Kasi na iŋwaŋwa eye mɛ, naeɓe oɓokye isɔ ya moonga wɛ oka Ŋwaphongo, Ŋwaphongo amoephɛ yango.» ");
INSERT INTO loq_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesu amba wɔ nɛ yokye: «Ŋwana nyɔngɔ amokundwa.» ");
INSERT INTO loq_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Malata amba ya mobuyisa yokye: «Naeɓe oɓokye amokundwa imbɛlɛ saa mokundwa ɓawe o mokɔlɔ ŋwa suka.» ");
INSERT INTO loq_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesu amba ya wɔ nɛ yokye: «Nga nali moto okokundole ɓawee, na okophɛ ɓomɔɔ, moto okonzanole, na ɓo awe amoɓa nde na ɓomɔɔ. ");
INSERT INTO loq_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Emba moto musɔ oli na ɓomɔɔ kambe na nzanola etawe. Koanole ɓomɔ?» ");
INSERT INTO loq_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Amba mobuyisa yokye: «Ɛɛ Nkolo, nga naanosi oɓokye oli Klisto, Ŋwana wa Ŋwaphongo, ookoye o mokyisi.» ");
INSERT INTO loq_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Waaunva yo iwɔ ɓaɓona, amba ya kyɛ ɓanga ŋwana nyango Maliya, amba kɔlɔ nɛ yokye: «Moteye aesi, kaeɓangye.» ");
INSERT INTO loq_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Waaoka Maliya ɓaɓona, aesi ya iŋwa izele, aesi kyɛndɛ oli yo. ");
INSERT INTO loq_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesu tataaka nyɔlɔ o mokyisi, kasi ataka ɓa nde oelele eya vanaka Malata nɛ. ");
INSERT INTO loq_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ɓayuda ɓaɓaka na Maliya o ingambi phɔ ya izala nɛ, waamowɛnɛ ɓɛ́ɛ aino izele, atɔkɔsi, ɓamba ya moɓenga, ɓaumunyaka oɓokye kakyɛ o ilita phɔ ya ikyɛ lela omɔ. ");
INSERT INTO loq_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Waakoma Maliya o elele eya ɓaka Yesu, wamowɛnɛ yo amba ka o makolo mɛ, amba wɔ nɛ yokye: «Nkolo, ɓo waɓaka wawa, ŋwana mama nde tawa.» ");
INSERT INTO loq_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Waɓa wɛnɛ yo ɓanyingonele, Maliya na Ɓayuda ɓaɓaka nɛ, Yesu aokaka ngɔngɔ ɓoikye na ɓolɔsi o ndondo yɛ. ");
INSERT INTO loq_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Emba amba ya ɓatuna yokye: «Ɓɛɛ wamokunda wa?» Ɓamba mobuyisa ɓɛkye: «Nkolo, yaka ya kyekye.» ");
INSERT INTO loq_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesu amba ya lela. ");
INSERT INTO loq_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Emba Ɓayuda ɓɛyke: «Kyeka ɓo wamozingaka yo.» ");
INSERT INTO loq_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ɓakyi onte ya ɓɛ̀ɛ ɓɛkye: «Moto owa ziɓolaka miyo ma moto owa phɔlɔ miyo, taikyi koka ikatela Lazalo iwa.» ");
INSERT INTO loq_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ɓoɓɛlɛ Yesu amba kula ya oka ngɔngɔ o motema amba ya kyɛndɛ o ilita. Yaɓaka mobɔngu onte ya maɓanga emba iɓanga saziɓaka muna mobɔngu. ");
INSERT INTO loq_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Emba Yesu amba ya wɔ yokye: «Manya iɓanga sisi.» Malata, nkanasa ya mowe, amba wɔ nɛ yokye: «Nkolo, kaye solo, phɔ ambo kyela nkɔlɔ ine.» ");
INSERT INTO loq_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Kasi Yesu amba mobuyisa yokye: «Siika wɔ na wɛ ngakye, ɓo oanosi, wamowɛnɛ nkyɛmo ya Ŋwaphongo?» ");
INSERT INTO loq_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ɓoɓɛlɛ, ɓamba ya manya iɓanga. Yesu amba ya tomba miyo o ikolo, amba wɔ yokye: «Tata, naephɛ mɛlɛsi phɔ onzokyi. ");
INSERT INTO loq_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Phɛlɛ, naeɓe oɓokye konzokye nkɔlɔ isɔ, kasi nawɔ ɓaɓona phɔ ya moluku moondungye, phɔ ɓaanole oɓokye iwɛ wantoma.» ");
INSERT INTO loq_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Waawɔ yo ɓaɓona, amba ya aŋwana na ɓokusi yokye: «Lazalo, tɔkɔlɔ!» ");
INSERT INTO loq_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Emba mowee aesi ya tɔkɔlɔ, makolo na maɓɔkɔ makangyemi na bitato, na ɓoo phɛ ɓozingami na etobu. Yesu amba ya wɔ na ɓɛ́ɛ yokye: «Omoingole emba omolɛ kakyɛndɛ!» ");
INSERT INTO loq_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ɓayuda ɓaikye onte ya ɓaayakaka yakyeka Maliya, na ɓawɛnɛkyɛ yaakyelaka Yesu, ɓamba moanolela. ");
INSERT INTO loq_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Kasi ɓayɔkɔ onte ya ɓɛ, ɓamba ya kyɛ imola Ɓafalisayi isɔ yakyelaka Yesu. ");
INSERT INTO loq_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ɓanganga ɓanɛnɛ na Ɓafalisayi ɓamba ya angyinya ikyita ɓamba wɔ ɓɛkye: «Tokyele ɓo? Moto oyo kakyele bilekyesako biikye. ");
INSERT INTO loq_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ɓo tomokyekyi ɓokyekyi ɓaɓona, ɓato ɓasɔ ɓamoanolela. Ɓaloma ɓamoya ɔtɔ elele esantu ya ɓanga na mokyisi ŋwa ɓanga.» ");
INSERT INTO loq_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Kaifa, mɔnɔmɔ na ɓɛ, owa ɓaka nganga o munɛnɛ o mbula mɛ, amba wɔ na ɓɛ́ɛ yokye: «Ɓɛ̀ɛ toosɔsɔlɔ ");
INSERT INTO loq_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","toombe na eɓa oɓokye eli ɓolaa phɔ ya ɓɛ́ɛ oɓokye moto mɔnɔmɔ awe phɔ ya ɓato, naa oɓokye mokyisi mobimba mowe.» ");
INSERT INTO loq_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Taika wɔ ɓaɓona na ndengye yɛ, kasi waɓaka yo nganga o munɛnɛ, o mbula mɛ, ambaka imola oɓokye ya sengyelaka oɓokye Yesu awe phɔ ya mokyisi. ");
INSERT INTO loq_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Teli nde phɔ ya mokyisi ɓoɓɛlɛ, kasi phɔ ya iyangyinya elele yɔnɔyɔ ɓana ɓa Ŋwaphongo ɓaanyangwa. ");
INSERT INTO loq_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Emba nde mokɔlɔ mɛ, ɓamba wanga imoɓoma. ");
INSERT INTO loq_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Yango mɛna, Yesu takulaka tambula mi pha onte ya Ɓayuda. Amba ya kyɛndɛ o manyɛtɛ mali phɛnɛphɛ na obokye, o mokyisi moɓangye ɓɛ́ɛ Efalayimɛ, azalaka omɔ yo na ɓaekosi ɓɛ. ");
INSERT INTO loq_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Eyenga ya Ilekana ya Ɓayuda yakomaka phɛnɛphɛ. Oɓoo pha eyenga ya Ilekana, ɓato ɓaikye ɓautaka o mangonda ɓakyɛkyɛ o Yelusalɛmɛ phɔ ya imipetola. ");
INSERT INTO loq_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ɓalukaka Yesu, emba onte ya Tempelo waaɓaka ɓɛ, ɓawɔnɔkɔ ɓɛkye: «Ɓɛ̀ɛ koumunya ɓo? O esɛlɛkɔ etaye?» ");
INSERT INTO loq_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ɓanganga ɓanɛnɛ na Ɓafalisayi ɓambyaka mitindo oɓokye: Moto munsɔ wamoeɓa elele eli yo, asengyesi eyimola phɔ ɓamoakya. ");
INSERT INTO loq_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Nkɔlɔ motoɓa o ɓoo pha eyenga ya Ilekana, Yesu aesi ya koma o Ɓetani, waaɓaka Lazalo owa kundolaka yo onte ya ɓawe. ");
INSERT INTO loq_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Omɔ, ɓamba ya za nɛ. Malata aɓaka kakaɓe ntoma kasi Lazalo aɓaka mɔnɔmɔ na ɓaɓaka nɛ o mesa. ");
INSERT INTO loq_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ɓoɓɛlɛ, Maliya amba yakpa molangyi ŋwa malasi ŋwakyela ɓɛ́ɛ na nalɛ ŋwa motiya moikye. Aesi ya maɔlɔlɔ o makolo ma Yesu, amba makunyola na suwe yɛ, emba ingambi satondaka na solo ya mana malasi. ");
INSERT INTO loq_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ɓoɓɛlɛ, Yudasi Mokyeliyota, mɔnɔmɔ na ɓaekosi ɓɛ́ɛ, eli nde ona yo owamuungya, yokye: ");
INSERT INTO loq_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«Phɔ ya'ye teɓaungye malasi mamana na nkama iyato ya ɓa denale, phɔ ya iɓaphɛ ɓaɓola?» ");
INSERT INTO loq_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Awɔkɔ ɓaɓona, phɔ teli obokye ali na ngɔngɔ ya ɓaɓola, kasi phɔ aɓaka moibi na oɓokye, yo moɓombi ŋwa ɓaphalanga, aɓaka kaiɓe ɓaphalanga ɓaɓaka ɓɛ́ɛ ɓamophisa. ");
INSERT INTO loq_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Emba Yesu amba wɔ yokye: «Omolɛ! Aɓanza lowɔ lokyesi yo phɔ ya mokɔlɔ ŋwa munkunda ɓɛ. ");
INSERT INTO loq_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ɓaɓola, oli na ɓɛ́ɛ nkɔlɔ isɔ, kasi nga, otooɓe na nga phɔ ya ɓoɓɛlɛ.» ");
INSERT INTO loq_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Emba moluku moikye ŋwa Ɓayuda ɓaokaka oɓokye Yesu aɓaka omɔ, kasi teɓaikaka ya nde phɔ ya Yesu yo mampenza, kasi nde phɔ ya ikyeka Lazalo owa kundolaka yo onte ya ɓawee. ");
INSERT INTO loq_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Tata wamɔ, Ɓanganga ɓanɛnɛ ɓamba wangya oɓokye ɓaɓome na Lazalo mɛ, ");
INSERT INTO loq_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","phɔ yaɓaka nde phɔ yɛ, Ɓayuda ɓaikye ɓaɓalotaka ɓabutwaka ianola Yesu. ");
INSERT INTO loq_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ɓo yana, moluku ŋwa ɓato ŋwakaka o esɛlɛkɔ, ŋwamba oka oɓokye Yesu amoya o Yelusalɛmɛ. ");
INSERT INTO loq_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ɓamba kpa kanga ya mabila ɓamba tɔkɔlɔ ikyɛ vana nɛ. Ɓaɓaka ɓaaŋwane ɓɛkye: «Ozana! Nkolo apambole okoye na nkombo yɛ, mokonzi ŋwa Isalayɛlɛ.» ");
INSERT INTO loq_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Waazwa Yesu ŋwana wa mpunda, amba zala o ikolo sa yango ɓo wakomama wango oɓokye: ");
INSERT INTO loq_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Saila ŋwana ŋwasi wa Siyona: Kyeka mokonzi kaye, abaa ikolo sa ŋwana mpunda. ");
INSERT INTO loq_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","O eɓandele ɓaekosi ɓɛ́ɛ teɓaikaka sɔsɔlɔ maphɔɔ maaye, kasi imbɛlɛ sazwa Yesu ngambo, ɓamba umunya oɓokye maphɔɔ mɛ makomamaka phɔ yɛ, na oɓokye eli nde mango makyela ɓɛ́ɛ phɔ yɛ. ");
INSERT INTO loq_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Moluku ŋwa ɓato ŋwaaɓaka nɛ imbɛlɛ saɓangaka yo Lazalo itɔkɔlɔ onte ya ilita na wa mokundola yo onte ya ɓawee, ɓaimolaka maphɔɔ mawɛnɛkyɛ ɓɛ. ");
INSERT INTO loq_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Yango mɛna moluku ŋwa ɓato ɓayakaka ya vana nɛ phɔ ɓaokaka elekyesako eya kyelaka yo. ");
INSERT INTO loq_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Emba Ɓafalisayi ɓamba wɔnɔ onte ya ɓɛ́ɛ ɓɛkye: «Ka kowɛnɛ, otokule kyela na ekpele, kyeka ɓato ɓasɔ ɓabuto imoɓenga!» ");
INSERT INTO loq_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ɓato ɓayɔkɔ ɓaateɓali Ɓayuda ɓakyɛkyɛ o esɛlɛkɔ phɔ ya ikumbela. ");
INSERT INTO loq_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ɓamba ya wɔ na Filipe owaɓaka wa Ɓetesayida ya Galileya emba ɓamba onga nɛ ɓɛkye: «Nkolo, toli na phowa ya iwɛnɛ Yesu.» ");
INSERT INTO loq_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipe amba yakyɛ lowɔlɛ Andele, emba ɓɛ́ɛ ɓasɔ ɓamba yakyɛ lowɔlɛ Yesu. ");
INSERT INTO loq_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesu amba ɓabuyisa ɓoɓo: «Imbɛlɛ sisengyesi Ŋwana wa moto izwa ngambo sikokyi. ");
INSERT INTO loq_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Naewɔlɛ nde phɛlɛ phɛlɛ, ɓo mumbuma ŋwa ble moka o manyɛtɛ te mowee, moikale ŋwango mampenza. Kasi ɓo mowee, moɓote mbuma nzikye. ");
INSERT INTO loq_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Moto okozingye ɓomɔɔ phɛ, aaɓobungya; kasi moto owamoina ɓomɔɔ phɛ onte ya mokyisi mumu, aaɓoɓanza nɔnɔ o ɓomɔɔ pha ɓoɓɛlɛ. ");
INSERT INTO loq_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ɓo moto kazingye inkyelela, ambengye, emba elele eli nga, na moto wa nga wa etoma amoɓa omɔ. Ɓo moto kankyelele, Tata amokumola.» ");
INSERT INTO loq_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","«Uŋwaŋwa eye, ndondo ya nga teli ɓose. Emba namba wɔ ɓo? Tata, ombikya o imbɛlɛ sisi? Kasi naya nde phɔ ya sina imbɛlɛ sisi. ");
INSERT INTO loq_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tata, phɛ nkombo yawɛ ngambo.» Emba ŋwɛsi mɔnɔmɔ mouti o ikolo mowɔ oɓokye: «Naeephɛ ngambo, emba namokula eephɛ ngambo.» ");
INSERT INTO loq_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Moluku ŋwa ɓato ŋwaɓaka wamɔ na ɓaokaka ɓɛkye eli engyinzi, ɓaayɔkɔ ɓawɔkɔ ɓɛkye eli anzelu moto omowɔsi. ");
INSERT INTO loq_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yesu amba ya buya yokye: «Ŋwɛsi mamuna temoikyi okana phɔ ya nga, kasi nde phɔ ya ɓɛ̀ɛ. ");
INSERT INTO loq_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Uŋwaŋwa eye eli isambisa sa mokyisi mumu, uŋwaŋwa eye ɓamovaka mokonzi ŋwa mokyisi o iɓanda. ");
INSERT INTO loq_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Phɔ ya nga, imbɛlɛ sa moɓaa nga o ikolo, namoɓenda ɓato ɓasɔ oka nga». ");
INSERT INTO loq_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Na maloɓa mamana, aimolaka ndengye eya mowa yo. ");
INSERT INTO loq_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Moluku ŋwa ɓato ŋwamba mobuyisa oɓokye: «Ɓanga Moɓeko ŋwaloimola oɓokye Klisto amoɓaa ɓoɓɛlɛ. Ndengye'ye wɛ okokyi iwɔ oɓokye Ŋwana wa moto amobaa o ikolo? Yo nza, ona Ŋwana wa moto?» ");
INSERT INTO loq_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Emba Yesu amba wɔ na ɓɛ́ɛ yokye: «Moo motaa ɓaa onte ya ɓɛ̀ɛ phɔ ya ŋwana imbɛlɛ. Tambula imbɛlɛ sili ɓɛ̀ɛ na moo, phɔ ya oɓokye enzɔmbi yango saeziɓa. Phɔ ookotambule o enzɔmbi, taeɓe mbale ekyekyɛ yo. ");
INSERT INTO loq_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Wata ɓa ɓɛ̀ɛ na moo, omoanole phɔ ya ibutwa ɓana ɓa moo.» Waaunva yo iɓawɔlɛ ɓaɓona, Yesu amba ya mana wali ɓɛ̀ɛ, akyɛ miɓomba. ");
INSERT INTO loq_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Naɓo wakyela yo bilekyesako biikye o miyo ma ɓɛ, teɓaika moanola. ");
INSERT INTO loq_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Phɔ maphɔɔ mawɔkɔ moimosi Isaya oɓokye: Nkolo, owanosi yaoka ɓanga nza? Na eɓɔkɔ ya Nkolo yamiteya oka nza? Makokyisame. ");
INSERT INTO loq_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Nde ona Isaya akula imola ntina ye ete yakokaka ɓɛ́ɛ anola: ");
INSERT INTO loq_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Aphɔsɛ miyo ma ɓɛ, ambi nabuya ntema ya ɓɛ́ɛ nkusi, phɔ ɓɛ́ɛ sawɛnɛ na miyo ma ɓɛ, oɓokye ntema ya ɓɛ́ɛ sa sɔsɔlɔ, oɓokye ɓɛ́ɛ saɓongola ntema, emba nde na ɓabikye! ");
INSERT INTO loq_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaya kawɔ ɓaɓona phɔ awɛnɛ nkyɛmɔ yɛ na oɓokye awɔ phɔ yɛ. ");
INSERT INTO loq_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Naɓo ɓaɓona, ɓaikye onte ya ɓakambi, ɓamoanolaka. Kasi phɔ ya Ɓafalisayi teɓamekaka na iwɔ, phɔ ya iila oɓokye nde ɓaɓatɔkɔsi o ingambi sa makyita: ");
INSERT INTO loq_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Phɔ ɓazingaka nkyɛmɔ ekyiute na ɓato o elele ya nkyɛmɔ ikyiute na Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yesu amba ya aŋwana yokye: «Okonzanole, taanole nga, kasi kaanole Owantoma, ");
INSERT INTO loq_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","eɓe moto ookonvɛnɛ, kawɛnɛ na Owantoma mɛ. ");
INSERT INTO loq_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Inga, moo, naesi o mokyisi phɔ moto munsɔ okonzanole aɓe saɓa o enzɔmbi. ");
INSERT INTO loq_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ɓo moto aokyi maphɔɔ ma nga, tambe maɓanza, teli nga okomosambisa: Phɔ sikyi ya sambisa mokyisi, kasi naesi nde iya bikya mokyisi. ");
INSERT INTO loq_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Moto okondɛ na otoanole maloɓa ma nga ali na mosambise: Iloɓa siiwɔ nga, samosambisa o mokɔlɔ ŋwa suka. ");
INSERT INTO loq_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Sikyi wɔ phɔ ya nga mampenza, kasi Tata owantoma anteya isengyesi nga iwɔ na iimola. ");
INSERT INTO loq_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Emba naeɓe oɓokye motindo nwɛ eli ɓomɔɔ pha ɓoɓɛlɛ: Ikyi wɔ nga, naiwɔ nde ɓowanvɔlɛ Tata.» ");
INSERT INTO loq_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","O ɓoo pha eyenga ya Ilekana, Yesu aeɓaka oɓokye imbɛlɛ sɛ saimana o mokyisi mumu oikyɛndɛ oka Ango sikokyi, yo owazingaka ɓato ɓɛ́ɛ ɓali o mokyisi, aɓazingaka tee nɔnɔ o suka. ");
INSERT INTO loq_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Emba waaɓa ɓɛ́ɛ ɓaze, Zabulu amba nyɔsa maumunya maɓe o ndondo ya Yudasi Mokyeliyota, oɓokye amungya, ");
INSERT INTO loq_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu aeɓaka oɓokye Ango aphɛ mbolo isɔ o maɓɔkɔ mɛ, phɔ auta na Ŋwaphongo emba amobutwa oka Ŋwaphongo, ");
INSERT INTO loq_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Aesi ya mana o mesa, amanye bitobu, akpe etato yɔnɔyɔ, amba mikanga o mobimbi. ");
INSERT INTO loq_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ɓoɓɛlɛ, amba yaangola maa o bɛsɛni, atati ikunyola makolo ma ɓaekosi, kambe manya maa na etato eyamikanga yo o mobimbi. ");
INSERT INTO loq_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Wakoma yo oka Simo Petelo, Petelo amba wɔ nɛ yokye: «Nkolo, iwɛ konkunyole makolo?» ");
INSERT INTO loq_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesu amba mobuyisa yokye: «Ikyikyele nga, tokokyi ieɓa uŋwaŋwa eye, kasi wamoisɔsɔlɔ sima.» ");
INSERT INTO loq_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petelo amba wɔ nɛ yokye: «Inkunyola makolo! Tewakokyi ikyelama!» Yesu amba mobuyisa yokye: «Ɓo siekunyosi, tokokyi iɓa na nga elele yɔnɔnɔ.» ");
INSERT INTO loq_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Emba Simo Petelo amba ya wɔ nɛ yokye: «Nkolo, sankunyola nde makolo na makolo, kasi na maɓɔkɔ na moto!» ");
INSERT INTO loq_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesu amba ya wɔ nɛ yokye: «Moto oumbo ɔkɔ, ali munsɔ pɛtɔɔ, tasengyesi ikula mikunyola, ɓote eɓee nde malolo phe. Ka ɓɛ̀ɛ, ɓɛ̀ɛ oli pɛtɔɔ, kasi ɓɛ̀ɛ ɓasɔ phe.» ");
INSERT INTO loq_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Phɔ aeɓaka moto owamoungya, yango mɛna amba wɔ yokye: «Ɓɛɛ ɓasɔ toli pɛtɔɔ.» ");
INSERT INTO loq_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Waaunva yo iɓakunyola makolo, aesi ya kpa bitobu ɓɛ, akuli ya nkyɛ zala o mesa amba ya wɔ na ɓɛ́ɛ yokye: «Ɓɛ̀ɛ osɔsɔsi lowɔɔ lookyesi nga phɔ ya ɓɛ̀ɛ? ");
INSERT INTO loq_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ɓɛ̀ɛ kombangye “Moteye na Nkolo”, kowɔ phɛlɛ, phɔ nali ɓomɔ. ");
INSERT INTO loq_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Emba ɓo nga, Nkolo na Moteye, naekunyosi makolo, na ɓɛ̀ɛ osengyesi ikunyolana makolo. ");
INSERT INTO loq_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Phɔ naephɛ ndakisa oɓokye, ikyesi nga na ɓɛ̀ɛ, na ɓɛ̀ɛ oikyele mɛ. ");
INSERT INTO loq_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Naewɔlɛ nde phɛlɛ phɛlɛ oɓokye, moombo taalekye nkolo wɛ, na toma talekye moto oo motomi. ");
INSERT INTO loq_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ɓo koeɓe maphɔɔ mamana, wamoɓa na nkyisa ɓo waamakyelela. ");
INSERT INTO loq_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Siwɔ phɔ ya ɓɛ̀ɛ ɓasɔ, naeɓe ɓaaɔlɔ nga. Kasi phɔ ɓa wɔ buku pha Ŋwaphongo oɓokye: Okoze na nga ipa molɔngɔ, abuto mbomi ya nga. ");
INSERT INTO loq_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Naewɔlɛ uŋwaŋwa eye, o ɓoo pha lowɔ mɛ iya. Phɔ, waamoya lango, oanole oɓoke “nga nali ɓooli nga”. ");
INSERT INTO loq_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Naewɔlɛ nde phɛlɛ phɛlɛ oɓokye: Owamoyamba moto otomi nga, kayambe nga mampenza, ka okonzambe kayambe na moto owantoma.» ");
INSERT INTO loq_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Waaunva yo iwɔ ɓaɓona, Yesu amba oka ngɔngɔ o motema, amba wɔ yokye: «Naewɔlɛ nde phɛlɛ phɛlɛ, mɔnɔmɔ onte ya ɓɛ̀ɛ amunzungya.» ");
INSERT INTO loq_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ɓaekosi ɓamba kyekana, ɓamba mituna ɓɛkye, kanewɔ na nza? ");
INSERT INTO loq_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Mɔnɔmɔ na ɓaekosi ɓɛ, owaɓaka Yesu kalɔɓɔ zinga, azalaka phɛnɛphɛ na Yesu. ");
INSERT INTO loq_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simo Petelo amba munyatela miyo yokye: «Omotune, kaanewɔ na nza.» ");
INSERT INTO loq_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Moekosi amba ya miɓanza o ntolo ya Yesu, amba motuna yokye: «Nkolo, eni ɓa nza?» ");
INSERT INTO loq_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesu amba mobuyisa yokye: «Eli owamophɛ nga ete ya ipa eya munyinya nga o subu.» Waaunva yo iwɔ ɓaɓona, Yesu amba yakpa ete ya ipa eya nyinyaka yo o subu, amba ya ephɛ Yudasi Mokyeliyota, ŋwana wa Simo. ");
INSERT INTO loq_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Emba nde o sina imbɛlɛ saamophɛ yo ena ete ya ipa, Molemba aesi ya nyɔlɛlɛ Yudasi. Ɓoɓɛlɛ Yesu amba wɔ nɛ yokye: «Loozingye wɛ ikyela, olokyele izele.» ");
INSERT INTO loq_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Na mɔnɔmɔ na ɓɛ́ɛ ɓasɔ ɓaɓaka o mesa taikaka sɔsɔlɔ phɔ ya'ye awɔkɔ ɓaɓona. ");
INSERT INTO loq_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ɓo waɓaka Yudasi moɓombi ŋwa ɓaphalanga, ɓaayɔkɔ ɓaumunyaka oɓokye Yesu awɔkɔ nɛ phɔ ya iyomba ya sengyelaka phɔ ya esɛlɛkɔ, naa phɔ ya iphɛ ɓaɓola ŋwana ekpele. ");
INSERT INTO loq_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ka Yudasi, wakpa yo ete ya ipa, amba ya tɔkɔlɔ. Yaɓaka enzɔmbi. ");
INSERT INTO loq_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Waatɔkɔlɔ Yudasi, Yesu amba wɔ yokye: «Uŋwaŋwa eye, Ŋwana wa moto ambo zwa ngambo, na Ŋwaphongo azwe ngambo phɔ yɛ. ");
INSERT INTO loq_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ɓo Ŋwaphongo azwe ngambo phɔ yɛ, Ŋwaphongo amophɛ nɛ ngambo ɓo eeli nɛ. Emba sakɔkɔ amophɛ ngambo. ");
INSERT INTO loq_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ɓana ɓa nga, sikuli ɓa na ɓɛ̀ɛ elinga. Wamunduka, emba nde ɓo wawɔ nga na Ɓayuda oɓokye: “Bi kyɛ nga, ɓɛ̀ɛ otokome omɔ”, naewɔlɛ na ɓɛ̀ɛ uŋwaŋwa eye. ");
INSERT INTO loq_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Naephɛ moɓeko ŋwa sika: Zingana ɓɛ̀ɛ na ɓɛ̀ɛ. Ɓo waezinga nga, na ɓɛ̀ɛ ozingane ɓɛ̀ɛ na ɓɛ̀ɛ. ");
INSERT INTO loq_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ɓoozinga ɓɛ̀ɛ na ɓɛ̀ɛ, na ɓomɔ, ɓato ɓasɔ ɓamoeɓa oɓokye ɓɛ̀ɛ oli ɓaekosi ɓa nga.» ");
INSERT INTO loq_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simo Petelo amba ya wɔ nɛ yokye: «Nkolo, kokyɛ bi?» Yesu amba mobuyisa yokye: «Bi kyɛ nga, tokokyi imbenga uŋwaŋwa eye, kasi wamumbenga sima.» ");
INSERT INTO loq_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petelo amba wɔ nɛ yokye: «Nkolo, phɔ ya'ye sikokyi iyeɓenga uŋwaŋwa eye? Namoambya ɓomɔɔ pha nga phɔ ya wɛ!» ");
INSERT INTO loq_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesu amba ya mobuyisa yokye: «Wamoambya ɓomɔɔ pha wɛ phɔ ya nga? Naewɔlɛ nde phɛlɛ phɛlɛ ngakye: Wamunzangana mbala iyato soo saɓotɔngɔkye.» ");
INSERT INTO loq_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","«Mandondo ma ɓɛ̀ɛ satungyisama, anola Ŋwaphongo, onzanole na nga. ");
INSERT INTO loq_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","O ingambi sa Tata, bilele ba iɓaa bili biikye, ɓo teeɓakyi ɓomɔ, nde naewɔlɛkyi oɓokye nakyɛndɛ eɓɔngyisela elele eya moɓa ɓɛ̀ɛ? ");
INSERT INTO loq_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Emba wamokyɛndɛ eɓɔngyisela nga elele, na mokula yaekpa, phɔ elele eli nga na ɓɛ̀ɛ oɓe omɔ mɛ. ");
INSERT INTO loq_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Na bi kyɛ nga, ɓɛ̀ɛ koeɓe nzela.» ");
INSERT INTO loq_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Toma amba ya wɔ nɛ yokye: «Nkolo, toloeɓe bi kyɛ wɛ, tombaeɓa ena nzela ndengye eye?» ");
INSERT INTO loq_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesu amba ya wɔ nɛ yokye: «Nga nali nzela, na phɛlɛ, na ɓomɔɔ. Moto takokyi ikyɛndɛ oka Tata, ɓo taleka oka nga. ");
INSERT INTO loq_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ɓo onzeɓakyi, na Tata nde omoeɓakyi. Tata uŋwaŋwa eye omoebi, emba omowɛni.» ");
INSERT INTO loq_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipe amba ya wɔ nɛ yokye: «Nkolo, oloteya Tata, mɛna oka ɓanga wakokyi.» ");
INSERT INTO loq_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesu amba ya wɔ nɛ yokye: «Nali na ɓɛ̀ɛ wawa elinga, emba wɛ Filipe toonzeɓe! Moto oo nvɛni awɛni Tata. Phɔ ya'ye kowɔ wɛkye: “Oloteya Tata?” ");
INSERT INTO loq_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Toanole oɓokye nga nali onte ya Tata, emba Tata ali onte ya nga? Maphɔɔ maewɔlɛ nga, si mawɔ na ndengye ya nga mampenza! Kasi eli nde Tata ooli onte ya nga, okokyele bitoma ɓɛ̀ɛ. ");
INSERT INTO loq_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Onzanole, nga nali onte ya Tata, emba Tata ali onte ya nga. Ɓo toone anola maphɔɔ ma nga, anola nɔnɔ phɔ ya bitoma bibi. ");
INSERT INTO loq_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Naewɔlɛ nde phɛlɛ phɛlɛ, moto okonzanole amokyela nɛ bitoma bikyele nga, amokyela na bitoma bilekyi ɓonɛnɛ, phɔ nga nakyɛndɛ oka Tata. ");
INSERT INTO loq_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Isɔ yamoonga ɓɛ̀ɛ na nkombo ya nga, namoikyela, phɔ oɓokye Tata azwe ngambo onte ya Ŋwana. ");
INSERT INTO loq_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ɓoonzongyi ekpele na nkombo ya nga, namoekyela.» ");
INSERT INTO loq_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","«Ɓo konzingye, wamokumola miɓeko ma nga. ");
INSERT INTO loq_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nga namoonga na Tata, amoetomela Moambelesi mosuu owa moɓa na ɓɛ̀ɛ phɔ ya ɓoɓɛlɛ. ");
INSERT INTO loq_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Eli yo Ɓolɔɓɔ owa phɛlɛ, iyo ootokokyi mokyisi iwɛnɛ na ieɓa. Ɓɛɛ, ɓɛ̀ɛ komoeɓe, phɔ ali phɛnɛphɛ na ɓɛ̀ɛ na onte ya ɓɛ̀ɛ. ");
INSERT INTO loq_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Esieyikye biika, namokula ebutolela. ");
INSERT INTO loq_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Eikasi nde ŋwana ɓokyi ɓoɓo, mokyisi ete mokule nvɛnɛ. Kasi ɓɛ̀ɛ, konvɛnɛ phɔ nali na ɓomɔɔ emba ɓɛ̀ɛ wamoɓa na ɓomɔɔ. ");
INSERT INTO loq_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Mokɔlɔ mɛ, wamoeɓa oɓokye nga nali onte ya Tata, ɓɛ̀ɛ onte ya nga na nga onte ya ɓɛ̀ɛ. ");
INSERT INTO loq_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Moto oli na miɓeko ma nga emba kamikumole, yo mɔna kanzingye. Kasi ookonzingye, Tata amozinga, na nga naamozinga namba na miwɛninya nɛ.» ");
INSERT INTO loq_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yudasi, kasi Yudasi Mokyeliyota phe, amba wɔ nɛ yokye: «Nkolo, ndengye'ye waamiwɛninya na ɓanga, kasi na mokyisi phe?» ");
INSERT INTO loq_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesu amba mobuyisa yokye: «Ɓo moto kanzingye, amokumola maphɔɔ ma nga, emba Tata aamozinga. Tomokyɛ, tomobuya elele ya ɓanga ya izala oka yɛ. ");
INSERT INTO loq_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Moto ootonzingye, taakumole maphɔɔ ma nga, nzuka maphɔɔ maokye ɓɛ̀ɛ, temali ma nga kasi ma Tata owantomaka. ");
INSERT INTO loq_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Naewɔlɛkyɛ maphɔɔ mamana wataaka ɓa nga na ɓɛ̀ɛ. ");
INSERT INTO loq_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Moambelesi, Ɓolɔɓɔ pha moetomela Tata na nkombo ya nga, amoteya maphɔɔ masɔ, amoekundolela isɔ yaa ewɔlɛkyɛ nga. ");
INSERT INTO loq_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Naeyikyele ɓose, naephɛ ɓose pha nga. Siephɛ phango ɓokoephɛ ɓato ɓa mokyisi. Mandondo ma ɓɛ̀ɛ maɓee satungisama naa iɓaa na ɓoilakye. ");
INSERT INTO loq_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Waoka oɓokye nawɔkɔ na ɓɛ̀ɛ ngakye: “Nakyɛndɛ, namokula ebutolela.” Ɓokonzingye, wamosepela na oɓokye nakyɛ oka Tata, phɔ Tata andekyi. ");
INSERT INTO loq_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Emba uŋwaŋwa eye, nawɔ na ɓɛ̀ɛ oɓoo pha maphɔɔ mamana ikyelama phɔ wamokyelama mango, ɓɛ̀ɛ oanole. ");
INSERT INTO loq_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Tata uŋwaŋwa eye, esikule wɔnɔ na ɓɛ̀ɛ, phɔ mokonzi ŋwa mokyisi mumu kaye. Nde phɛlɛ tali na ɓokonzi o ikolo sa nga. ");
INSERT INTO loq_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Kasi phɔ ya oɓokye mokyisi moeɓe oɓokye nazingye Tata na oɓokye nakyele isɔ ɓoko zingye yo. Tɛmɛ, tomane wawa!» ");
INSERT INTO loq_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","«Nga nali ŋwete ŋwa vinyɔ ŋwa phɛlɛ phɛlɛ emba Tata ali nkolo ya inzabi. ");
INSERT INTO loq_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Bitakyi bisɔ bili onte yanga, bite biɓote mbuma, aabimanya, emba bitakye bisɔ biɓote mbuma, aabiɓɔngya, phɔ oɓokye bikule ɓota mbuma nzikye. ");
INSERT INTO loq_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ɓɛ̀ɛ waunva ɓɔngɔ phɔ ya iloɓa saewɔlɛ nga. ");
INSERT INTO loq_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ɓa na nga ɓooli nga na ɓɛ̀ɛ! Nde ɓomɔ ɓooli etakyi, teekokyi iɓota mbuma yango mampenzaa ɓoteeɓe yɔnɔyɔ onte ya ŋwete. Nde ɓomɔ na ɓɛ̀ɛ tokokyi iɓota mbuma, ɓotoɓee na nga elele yɔnɔyɔ. ");
INSERT INTO loq_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Nga, nali ŋwete ŋwa vinyɔ, ɓɛ̀ɛ oli bitakyi: Moto okoɓe na nga na owa oli nga onte yɛ, yo mona amoɓota mbuma nzikye, phɔ tokokyi ikyela ekpele ɓo nga siɓe na ɓɛ̀ɛ. ");
INSERT INTO loq_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ɓo moto taɓe na nga elele yɔnɔyɔ, ɓamovaka o nze ya etakyi, amuunga, emba ɓabiɔngɔ, ɓabivaka o ŋwenya emba biamolola. ");
INSERT INTO loq_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ɓo oɓe na nga, na maloɓa ma nga ɓo mali na ɓɛ̀ɛ, wamoonga izingyi ɓɛ̀ɛ, wamoizwa. ");
INSERT INTO loq_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Lowɔ lophɛ Tata ngambo, eli oɓokye ɓɛ̀ɛ oɓote mbuma nzikye na oɓokye obutwe ɓaekosi ɓa nga. ");
INSERT INTO loq_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ɓo wanzinga Tata, na nga naezingye mɛ, ikala na lozingo na nga. ");
INSERT INTO loq_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ɓo kokumole miɓeko ma nga, oli na lozingo na nga, ya ɓookokumole nga miɓeko ma Tata, naikale o lozingo lɛ. ");
INSERT INTO loq_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Naewɔsi ɓaɓona phɔ nkyisa ya nga iɓe na ɓɛ̀ɛ na oɓokye nkyisa ya ɓɛ̀ɛ iiɓe nzikye. ");
INSERT INTO loq_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Eye eli moɓeko ŋwa nga: Zingana ɓɛ̀ɛ na ɓɛ̀ɛ ɓo wa ezinga nga. ");
INSERT INTO loq_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Tewali moto na lozingo loikye ya moto okoambya ɓomɔɔ phɛ phɔ ya ɓɛbi nɛ. ");
INSERT INTO loq_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ɓo kokyele ikyietome nga, ɓɛ̀ɛ oli ɓɛbi na nga. ");
INSERT INTO loq_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Esikule eɓanga ɓaombo, phɔ moombo taeɓe ikyikyele nkolo wɛ. Kasi ɓɛ̀ɛ, naeɓangye ɓɛbi, phɔ isɔ yaaoka nga oka Tata, naeyimola yango. ");
INSERT INTO loq_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Teli ɓɛ̀ɛ ɓato ɓaanzɔlɔ, eli nde nga moto owa eɔlɔ na owa ephɛ etoma phɔ okyɛndɛ, oɓokye oɓote mbuma na oɓokye mbuma mɛ ikɔkɔ. Phɔ ya oɓokye ya moonga ɓɛ̀ɛ oka Tata na nkombo ya nga, amoephɛ yango. ");
INSERT INTO loq_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Lowɔ loeyongye nga, eli oɓokye ozingane ɓɛ̀ɛ na ɓɛ̀ɛ.» ");
INSERT INTO loq_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","«Ɓo mokyisi moeyini, eɓa oɓokye nga ŋwanzina phanza. ");
INSERT INTO loq_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ɓo oɓakyi ɓa mokyisi, mokyisi nde moezingyi. Kasi ɓɛ̀ɛ toli ɓa mokyisi: Kasi eli nga oemanye o mokyisi yango mɛna mokyisi moeyine. ");
INSERT INTO loq_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Umunya maphɔɔ mawɔkɔ nga na ɓɛ̀ɛ oɓokye: “Moombo talekye nkolo wɛ”, ɓo wanyɔkɔlɔ ɓɛ, ɓamoenyɔkɔlɔ na ɓɛ̀ɛ mɛ. Ɓo ɓakumola maphɔɔ ma nga, maphɔɔ ma ɓɛ̀ɛ ɓamakumola mɛ. ");
INSERT INTO loq_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Kasi ɓamoekyela isɔ miina phɔ ya nkombo ya nga, phɔ teɓaeɓe owantoma. ");
INSERT INTO loq_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ɓo sikaka ya, na ɓo sikaka ɓawɔlɛ, nde teɓaɓe na isumu, kasi uŋwaŋwa eye, teɓakokyi angana isumu sa ɓɛ. ");
INSERT INTO loq_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Moto ookonzine, kaine na Tata mɛ. ");
INSERT INTO loq_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ɓo sikyelaka bilekyesako ɓate ɓaika kyela na moto mosuu onte ya ɓɛ, nde teɓaɓe na isumu. Kasi uŋwaŋwa eye oobiwɛni ɓɛ́ɛ ɓali nde iloina, eɓe nga eɓe Tata. ");
INSERT INTO loq_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Kasi eli phɔ ya oɓokye ekokyisame maphɔɔ maakomama o Moɓeko ŋwa ɓɛ́ɛ oɓokye: “Ɓanzina sa eleko.” ");
INSERT INTO loq_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Waamoya Moambelesi owamoetomela nga uta oka Tata, Ɓolɔɓɔ pha phɛlɛ ɓoute na Tata, yo mampenza amoya wɔ phɔ ya nga. ");
INSERT INTO loq_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Na ɓɛ̀ɛ, oli manzoka ma nga, phɔ tata o etatele oli na nga.» ");
INSERT INTO loq_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","«Naewɔsi maphɔɔ masɔ mamana phɔ ya oɓokye oɓe sakaa o bimekyi. ");
INSERT INTO loq_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ɓamoewiinya o mangambi ma makyita ma Ɓayuda. Nzuka imbɛlɛ siye, moto owa moeɓoma, amoumunya oɓokye kambya ikaɓo oka Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ɓamokyela ɓaɓona phɔ teɓaika eɓa eɓee Tata, eɓee nga. ");
INSERT INTO loq_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Kasi naewɔlɛ ɓaɓona phɔ ya oɓokye, wamokoka imbɛlɛ sa ɓɛ, ɓɛ̀ɛ oeɓe oɓokye naewɔlɛkyɛ lango.» «Sika ewɔlɛ lango uta oetatele phɔ naɓaka na ɓɛ̀ɛ. ");
INSERT INTO loq_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Kasi uŋwaŋwa eye nakyɛndɛ oka owantoma, emba na mɔnɔmɔ onte ya ɓɛ̀ɛ santuna oɓokye: “Kokyɛ bi?” ");
INSERT INTO loq_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Kasi phɔ naewɔsi lango, mandondo ma ɓɛ̀ɛ mabuto na ngɔngɔ. ");
INSERT INTO loq_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Nzuka, naewɔsi nde phɛlɛ oɓokye: Eli ɓolaa oɓokye nga nakyɛndɛ, phɔ, ɓo nga sikyɛ, moto ookokyi iya eyambelela etaye. Kasi ɓo na kyɛ, namoetomela yo. ");
INSERT INTO loq_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Emba waamoya yo, amoya phɛ ɓato ɓa mokyisi sɔɔ phɔ ya maphɔɔ maakyekyi masumu, ɓosembo, na isambisa sa Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Phɔ ya masumu, teɓaanzanole. ");
INSERT INTO loq_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Phɔ ya ɓosembo, nakyɛndɛ oka Tata, otokule nvɛnɛ. ");
INSERT INTO loq_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Phɔ ya isambisa, mokonzi wa mokyisi mumu ɓamosambisaka. ");
INSERT INTO loq_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Nakuli ɓa na maphɔɔ maikye ma iewɔlɛ, kasi ɓo naewɔsi mango uŋwaŋwa eye, mamoeleka na ɓokusi. ");
INSERT INTO loq_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Waamoya Ɓolɔɓɔ ɓowɔ maphɔɔ ma phɛlɛ, amoeteya maphɔɔ masɔ ma phɛlɛ. Etawɔ maphɔɔ maaute nɛ mampenza. Amowɔkɔ maphɔɔ maokye yo, amo eimolaka na maphɔɔ mamoya. ");
INSERT INTO loq_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Amowɛninya nkyɛmɔ ya nga oka ɓato phɔ amokpaka maphɔɔ maaute na nga, emba amoeimolaka mango. ");
INSERT INTO loq_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Maphɔɔ masɔ mali na Tata, mali na nga. Yango mɛna, nawɔ ngakye: Ɓɔlɔɓɔ amokpaka maphɔɔ maaute na nga, emba amoeimolaka mango.» ");
INSERT INTO loq_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Ŋwana ɓokyi ɓoɓo, ɓɛ̀ɛ otokule nvɛnɛ, emba nde ŋwana ɓokyi ɓoɓo wamokula nvɛnɛ. ");
INSERT INTO loq_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ɓoɓɛlɛ, ɓaekosi ɓɛ́ɛ ɓaayɔkɔ ɓamitunaka, ɓɛkye: «Maphɔɔ mama malukye iwɔ ɓo? Ŋwana ɓokyi ɓoɓo, ɓɛ̀ɛ otokule nvɛnɛ, emba nde ŋwana ɓokyi ɓoɓo wamokula nvɛnɛ. Ebe na oɓokye: “Nakyɛndɛ oka Tata?”» ");
INSERT INTO loq_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Maphɔɔ mawɔ yo, yokye: Ŋwana ɓokyi ɓoɓo, malukye iwɔ ɓo? Ɓanga tolomaeɓe. ");
INSERT INTO loq_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu aeɓaka oɓokye ɓalukye imotuna, amba ya ɓatuna, yokye: «Ɓɛ̀ɛ komitune phɔ ya maphɔɔ maewɔsi nga oɓokye: Ŋwana ɓokyi ɓoɓo, ɓɛ̀ɛ otokule nvɛnɛ, emba nde ŋwana ɓokyi ɓoɓo wamokula nvɛnɛ? ");
INSERT INTO loq_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Naewɔlɛ nde phɛlɛ: Ɓɛ̀ɛ wamolela, wamba na miima, kasi ɓato ɓa mokyisi ɓamoɓa na nkyisa. Wamoɓa na ngɔngɔ, ngɔngɔ mɛ yamobutwa nkyisa. ");
INSERT INTO loq_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Yamoɓa ndokolo ŋwaŋwasi kalukye iɓota. Waasweya yo, kaɓe na ngɔngɔ phɔ kaeɓe oɓokye akomi imbɛlɛ sa ɓolɔsi. Kasi ɓo aɓoti, taakule eɓa ɓolɔsi ɓosɔ ɓaaɓona phɔ abuto na nkyisa oɓokye atɔkɔsi moto o mokyisi. ");
INSERT INTO loq_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Nde ɓomɔ, uŋwaŋwa eye na ɓɛ̀ɛ, obuto na ngɔngɔ. Kasi namokula ya wɛnɛnɛ na ɓɛ̀ɛ, emba mandondo ma ɓɛ̀ɛ mamobutwa na nkyisa. Moto nɔnɔ mɔnɔmɔ etakokye imanya nkyisa ya ɓɛ̀ɛ. ");
INSERT INTO loq_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Muna mokɔlɔ mɛ, otokule ntuna na maphɔɔ. Naewɔlɛ nde phɛlɛ: Tata, amoephɛ isɔ yamoonga ɓɛ̀ɛ na nkombo ya nga. ");
INSERT INTO loq_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Nɔnɔ uŋwaŋwa eye, naino toongyi ekpele yɔnɔyɔ na nkombo ya nga. Oonga, wamozwa, emba nkyisa ya ɓɛ̀ɛ yaamba lɔɓɔ.» ");
INSERT INTO loq_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Naewɔsi maphɔɔ mamana na bite. Imbɛlɛ siiye, esikule ewɔlɛ na bite, kasi namoewɔlɛ saasa maphɔɔ makyekyi Tata. ");
INSERT INTO loq_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Muna mokɔlɔ mɛ, wamoonga Tata maphɔɔ masengyesi na ɓɛ̀ɛ na nkombo ya nga, teli oɓokye namonga nɛ phɔ ya ɓɛ̀ɛ. Wamoonga nɛ ɓɛ̀ɛ mampenza na nɔkɔ ya ɓɛ̀ɛ, ");
INSERT INTO loq_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","phɔ Tata, yo mampenza kaezingye. Kaezingye phɔ ɓɛ̀ɛ konzingye, koanole na oɓokye nauta na Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nauta na Tata, naya o mokyisi. Uŋwaŋwa eye, naikye mokyisi, nabutwe oka Tata. ");
INSERT INTO loq_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ɓaekosi ɓɛ, ɓɛkye: «Owɛni, uŋwaŋwa eye kowɔ saasa, tokuli wɔ na bite. ");
INSERT INTO loq_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nde uŋwaŋwa eye, ɓanga toeɓe oɓokye koeɓe maphɔɔ masɔ. Tosengyesi oɓokye ɓato ɓakule etuna mituna. Yango mɛna, toanole oɓokye wauta na Ŋwaphongo.» ");
INSERT INTO loq_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesu amba ɓabuyisa yokye: «Uŋwaŋwa eye, ɓɛ̀ɛ kombe yaanola? ");
INSERT INTO loq_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Kyeka, imbɛlɛ mɛ siye, simbo koka, ɓɛ̀ɛ ɓasɔ wamunyangwa, moto na moto amobutwa oka yɛ, wamoika nzika nga mampenza. Kasi sili nga mampenza phɔ Tata ali na nga elele yɔnɔyɔ. ");
INSERT INTO loq_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Naewɔsi maphɔɔ mamana phɔ ɓɛ̀ɛ ɓali na nga elele yɔnɔyɔ oɓe na motema mpiyɔ. Wamunyɔkɔmɔ o mokyisi. Kasi oititalaka, phɔ inga natɔkɔlɔ kamba owanyɛtɛ ɓoɓe pha mokyisi!» ");
INSERT INTO loq_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ɓoɓɛlɛ, waawɔkɔ yo ɓaɓona, Yesu atombaka miyo o ikolo, yokye: «Tata, imbɛlɛ mɛ simbi ya koka. Wɛninya oɓokye nga, Ŋwana wa wɛ, nali na nkyɛmɔ phɔ ya oɓokye na nga nawɛninya nkyɛmɔ ya wɛ. ");
INSERT INTO loq_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Na phɔ ya oɓokye, na ɓokonzi phaamophɛ wɛ o ikolo sa ɓato ɓasɔ, ambya ɓomɔɔ pha ɓoɓɛlɛ oka ɓato ɓasɔ ɓaamophɛ wɛ. ");
INSERT INTO loq_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Nzuka ɓomɔɔ pha ɓoɓɛlɛ ɓoli oɓokye ɓaeyeɓe, nde wɛ mampenza owaakolo Ŋwaphongo, na Yesu Klisto owa toma wɛ. ");
INSERT INTO loq_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nawɛninye nkyɛmɔ ya wɛ o munse mumu. Naumboo etoma eyampɛkyɛ wɛ oɓokye naekyele. ");
INSERT INTO loq_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Emba uŋwaŋwa eye, Tata, ompɛ nkyɛmɔ phɛnɛphɛ na wɛ, nkyɛmɔ yaaɓaka na nga waaɓaka nga phɛnɛphɛ na wɛ o ɓoo pha oɓokye mokyisi mokyelame.» ");
INSERT INTO loq_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","«Nawɛninye nkombo ya wɛ oka ɓato ɓaamanya wɛ o mokyisi phɔ ya iɓa mpɛ. Ɓaɓaka ɓa wɛ, waɓampɛ emba ɓambi kumola iloɓa sawɛ. ");
INSERT INTO loq_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Uŋwaŋwa eye ɓaeɓe oɓokye isɔ yaampɛ wɛ kyiute na wɛ. ");
INSERT INTO loq_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Oɓokye maloɓa maaɓawɔlɛ nga eli nde maloɓa maanvɔlɛ wɛ. Ɓamaanola, ɓaeɓa nde phɛlɛ oɓokye naute na wɛ, emba ɓamba anola oɓokye wɛ wantoma.» ");
INSERT INTO loq_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","«Naongye na Ŋwaphongo phɔ ya ɓɛ, sionga na Ŋwaphongo phɔ ya mokyisi, kasi phɔ ya ɓawa ɓampɛ wɛ, phɔ ɓali ɓa wɛ. ");
INSERT INTO loq_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Emba isɔ ili ya nga ili ya wɛ, nde ɓoli isɔ yaka ya wɛ, ili ya nga, emba nazwe nkyɛmɔ ya nga phɔ ya ɓɛ. ");
INSERT INTO loq_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Tata lɔlɔ, sikuli ɓa wa mokyisi mumu, ɓɛ́ɛ ɓaikale o mokyisi, kasi nga nakyɛ oka ya wɛ. Tata mosantu, oɓaɓanza na nkombo ya wɛ eyampɛ wɛ, phɔ ɓaɓe moto mɔnɔmɔ ɓoli nga na wɛ moto mɔnɔmɔ. ");
INSERT INTO loq_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Waaɓaka nga na ɓɛ́ɛ elele yɔnɔyɔ, naɓaɓanzaka na nkombo ya wɛ eyampɛ wɛ. Naɓaɓanza emba na monɔmɔ onte ya ɓɛ́ɛ taikyi bunga, ɓoteɓe nde ŋwana owaɓaka oɓokye amobunga, phɔ ya oɓokye makomi makokyisame. ");
INSERT INTO loq_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Uŋwaŋwa eye, naye oka ya wɛ emba nawɔ maphɔɔ mama o mokyisi phɔ ya oɓokye ɓazwe na mango nkyisa nzikye. ");
INSERT INTO loq_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Naɓaphɛ iloɓa sa wɛ, emba mokyisi moɓaini, phɔ teɓali ɓa mokyisi nde ɓootoli nga wa mokyisi. ");
INSERT INTO loq_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Siongye na wɛ oɓokye oɓamanya o mokyisi, kasi oɓokye oɓaɓanza ɓɛ́ɛ sa kaa o maɓɔkɔ ma Molemba. ");
INSERT INTO loq_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ɓɛ́ɛ teɓali ɓa mokyisi nde ɓotoli nga wa mokyisi. ");
INSERT INTO loq_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Kyela oɓokye ɓamiambya muwosi oka ya wɛ na nzela ya maphɔɔ ma phɛlɛ, iloɓa sa wɛ sili nde phɛlɛ. ");
INSERT INTO loq_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ɓo wantoma wɛ o mokyisi, na nga naɓantome o mokyisi. ");
INSERT INTO loq_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Phɔ ya ɓɛ, namiambya nga mampenza, phɔ ya oɓokye na ɓɛ́ɛ ɓamiambya na nzela ya maphɔɔ ma phɛlɛ.» ");
INSERT INTO loq_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","«Siongye na Ŋwaphongo nde phɔ ya ɓɛ́ɛ na ɓɛ, naɓondɛlɛ na phɔ ya ɓaawa, phɔ ya iloɓa sa ɓɛ, ɓamunzanola: ");
INSERT INTO loq_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Oɓokye ɓasɔ ɓaɓe moto mɔnɔmɔ ndengye eli wɛ Tata, oli onte ya nga emba nga onte ya wɛ. Ɓaɓe na ɓɛ́ɛ onte ya ɓanga mɛ phɔ ya oɓokye mokyisi moanole oɓokye wɛ wantoma. ");
INSERT INTO loq_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Emba nga naɓaphɛ nkyɛmɔ eyampɛ wɛ, phɔ ɓaɓe moto mɔnɔmɔ ɓoli ɓanga moto mɔnɔmɔ, ");
INSERT INTO loq_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","inga onte ya ɓɛ́ɛ ɓooli wɛ onte ya nga, phɔ ya oɓokye ɓakome o sakolo isanga, na ɓaɓona mokyisi ŋwamoeɓa oɓokye eli wɛ owantoma na oɓokye waɓazinga ɓo wanzinga wɛ.» ");
INSERT INTO loq_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","«Tata, nazingye oɓokye elele eli nga, ɓasɔ ɓaampɛ wɛ ɓaɓe na ɓɛ́ɛ wamɔ mɛ. Emba na ɓɛ́ɛ ɓawɛnɛ nkyɛmɔ yaampɛ wɛ, phɔ wanzinga o ɓoo pha ikyelama sa mokyisi. ");
INSERT INTO loq_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tata owa ɓosembo, mɛna mokyisi temoeyeɓe, nga naeyeɓe, emba ɓato ɓaɓa ɓaebi oɓokye wɛ wantoma. ");
INSERT INTO loq_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Naɓaimola nkombo ya wɛ, namba kula na ɓaimola yango, phɔ ya oɓokye lozingo laanzinga na wɛ loɓe na mi ɓɛ, emba nga onte ya ɓɛ.» ");
INSERT INTO loq_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Waawɔ Yesu ɓaɓona, amba yakyɛndɛ yo na ɓaekosi ɓɛ́ɛ o mokukulu moyɔkɔ ŋwa moluka ŋwa Sɛdrɔ. Aesi ya nyɔlɔ na ɓɛ́ɛ o iɓala sɔnɔsɔ sa ndemo. ");
INSERT INTO loq_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yudasi, owaamoungya, aeɓaka nɛ elele mɛ, phɔ Yesu na ɓaekosi ɓaɓaka ɓaya angana wamɔ. ");
INSERT INTO loq_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Yudasi aesi ya kpa ɓatuluku ɓa Ɓaloma na ɓakyɛngyɛsi ɓa Tempelo, ɓaatomaka ɓakambi ɓa ɓanganga na Ɓafalisayi. Akyɛ na ɓɛ́ɛ o elele mɛ. Ɓaphilaka mphata, na ɓayanzi, na ɓakɔlukɔlu. ");
INSERT INTO loq_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ka Yesu aeɓaka isɔ yaamoyelela. Aesi ya susinya oli ɓɛ, aɓatuni, yokye: «Ɓɛɛ kolukye nza?» ");
INSERT INTO loq_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ɓɛkye: «Ɓanga, tolukye Yesu, moto wa Nazalɛtɛ». Yesu, yokye: «Nga oyo». Yudasi owamungya atɛmɛkyɛ na ɓɛ́ɛ wamɔ. ");
INSERT INTO loq_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Waawɔ Yesu na ɓɛ, yokye: «Nga oyo», ɓabuto na munsima, ɓakaa o se. ");
INSERT INTO loq_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yesu akuli ɓatuna, yokye: «Ɓɛ̀ɛ kolukye nza?» Ɓɛkye: «Tolukye Yesu, moto wa Nazalɛtɛ». ");
INSERT INTO loq_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesu, yokye: «Nambo ewɔlɛ oɓokye Nga oyo. Ka, ɓo eli nga okolukye ɓɛ̀ɛ, olɛ ɓato ɓayɔkɔ ɓaɓa, ɓakyɛndɛ ɓose.» ");
INSERT INTO loq_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Yesu awɔ ɓaɓona phɔ lowɔ, loowɔkyi yo na Ango lolo lokokye: «Sibungye nɔnɔ moto mɔnɔmɔ mi ɓaampɛ wɛ.» ");
INSERT INTO loq_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simo Petelo aɓaka na mumphata. Aesi ya mokaa, aɛngyi moombo wa nganga o munɛnɛ itoo saa ɓoloo. Nkombo ya moombo mɛ, Markus. ");
INSERT INTO loq_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Kasi Yesu amba wɔ na Petelo, yokye: «Buya muphata ŋwa wɛ o kokolo. Iwɛ, kobuya oɓokye esiwɛnɛ ɓolɔsi ɓoompɛ Tata ɓoɓo?» ");
INSERT INTO loq_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ɓoɓɛlɛ, ɓatuluku na mokonzi ŋwa ɓɛ, na ɓakyɛngyɛsi ɓa Ɓayuda ɓaesi yaakya Yesu, ɓamoɓakyi maphanga. ");
INSERT INTO loq_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ɓakyɛ nɛ phanza oka Ana. Ana alongyaka ŋwana wɛ wa ŋwaŋwasi na Kayafa. Kayafa aɓaka nganga munɛnɛ mi mbula mɛ mɛna. ");
INSERT INTO loq_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Nzuka eli Kayafa owawɔkɔ na Ɓayuda lowɔɔ lolo: «Eli ɓolaa oɓokye moto mɔnɔmɔ awe phɔ ya ɓanga ɓato.» ");
INSERT INTO loq_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simo Petelo na moekosi mosuu ɓakyɛkyɛ miɓenga Yesu. Moekosi omosuu mɔna, aeɓanaka na nganga munɛnɛ. Yango mɛna, amba ya nyɔlɔ molɔngɔ mɔnɔmɔ na ɓaanyɔlɔkɔ na Yesu, o iɓala oka nganga munɛnɛ. ");
INSERT INTO loq_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Petelo aikalaka o iɓanda, phɛnɛphɛ na moziɓo. Moekosi owaeɓanaka na nganga munɛnɛ, aesi ya tɔkɔlɔ, awɔɔ na ŋwaŋwasi owaɓaka kakyɛngyɛlɛ moziɓo. Ɓoɓɛlɛ, moekosi mɛ aesi ya nyɔsa Petelo. ");
INSERT INTO loq_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ŋwaŋwasi mɛ amba ya wɔ na Petelo, yokye: «Na wɛ, toli moekosi wa moto mɔna?» Petelo, yokye: «Phe, sili moekosi nwɛ». ");
INSERT INTO loq_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ɓaombo na ɓakyɛngyɛsi ɓakyelaka ŋwenya oɓokye ɓaɔtɔ phɔ mpiyɔ yakyelaka. Petelo nɛ ayakaka ya tɛmɛ na ɓɛ, kaɔtɔ ŋwenya. ");
INSERT INTO loq_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ɓoɓɛlɛ, nganga munɛnɛ aesi ya tuna Yesu phɔ ya ɓaekosi ɓɛ́ɛ na phɔ ya mateya maateyaka yo. ");
INSERT INTO loq_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesu, yokye: «Nawɔkɔ o pha, phɔ ya moto munsɔ. Nateyaka o mangambi ma makyita, na o Tempelo, elele ekyeangane Ɓayuda ɓasɔ. Sikaka wɔ mi iɓombo. ");
INSERT INTO loq_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Phɔ ya'ye kontune? Tuna ɓaanzokaka, ɓaeimole maphɔɔ maaɓawɔlɛkyɛ nga. Ɓaeɓe yaawɔkɔ nga na ɓolaa.» ");
INSERT INTO loq_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Wabuya Yesu ɓaɓona, mɔnɔmɔ na ɓakyɛngyɛsi, owaɓaka phɛnɛphɛ nɛ, aesi ya mowanda engyete, yokye: «Mɛna ɓo kobuyisa wɛ nganga o munɛnɛ?» ");
INSERT INTO loq_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesu, yokye: «Ɓo nawɔ na ɓoɓe, onzimole, ka ɓo na wɔ na ɓola, iwɛ konvande phɔ ya'ye?» ");
INSERT INTO loq_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ɓoɓɛlɛ, Ana amba ya motoma, nde na mana maphanga oka Kayafa, nganga munɛnɛ. ");
INSERT INTO loq_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simo Petelo ataka ɓa atɛmi, kaɔtɔ ŋwenya. Ɓaesi ya motuna, ɓɛkye: «Na wɛ, toli moekosi wa moto mɛ?» Petelo aanga, yokye: «Phe, sili moekosi wɛ?» ");
INSERT INTO loq_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Mɔnɔmɔ na ɓaombo ɓa nganga o munɛnɛ, owaɓaka ŋwana nyango na moto owaɛngyɛkyɛ Petelo itoo, amba wɔ nɛ, yokye: «Siikaka ewɛnɛ na wɛ na nɛɛ o iɓala?» ");
INSERT INTO loq_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Petelo akuli angana. Sa kɔkɔ, soo yamba ya tɔngɔ. ");
INSERT INTO loq_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Na munkukutu, ɓaesi ya mana na Yesu oka Kayafa. Ɓakyɛ nɛ oka Pilata. Kasi ɓakambi ɓa Ɓayuda teɓaikaka nyɔlɔ o ingambi sɛ, oɓokye ɓɛ́ɛ saɔtɔ ekyila ya ɓɛ́ɛ phɔ ɓaze eyenga ya Ilekana. ");
INSERT INTO loq_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Yango mɛna, Pilata akyɛkyɛ ɓatuna o iɓanda, yokye: «Lowɔ iye loosongyele ɓɛ̀ɛ moto oyo?» ");
INSERT INTO loq_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ɓɛkye: «Ɓo taɓakyi moto moɓe, nde toloyakakyi ya eyikyela yo.» ");
INSERT INTO loq_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilata, yokye: «Kasi ɓɛ̀ɛ omokpe, omotenele ɓolombe, ɓookowɔ moɓeko ŋwa ɓɛ̀ɛ.» Ɓayuda ɓamba ya mobuyisa ɓɛkye: «Ɓanga mampenza tolokokyi iphɛ moto etumbu ya iwa.» ");
INSERT INTO loq_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Lowɔ lolo lokokyee ewɔlɛ ya Yesu, eyawɔkɔ yo phɔ ya iteya ndengye ya iwa sa mowa yo. ");
INSERT INTO loq_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ɓoɓɛlɛ, Pilata amba ya nyɔlɔ o ingambi. Aɓangyi Yesu, amba wɔ nɛ yokye: «Iwɛ, oli mokonzi ŋwa Ɓayuda?» ");
INSERT INTO loq_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesu amba ya mobuyisa yokye: «Kowɔ ɓaɓona phɔ umunye wɛ mampenza, ndee ɓasuu ɓaeimosi phɔ ya nga?» ");
INSERT INTO loq_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilata, yokye: «Ombuye Moyuda ndee ɓo? Ɓato ɓa mokyisi ŋwa wɛ mampenza, ɓanganga ɓanɛnɛ ɓaeyambye oka nga! Okyesi lowɔɔ iye?» ");
INSERT INTO loq_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesu amba buya yokye: «Ɓokonzi pha nga teɓoli pha mokyisi mumu. Ɓo ɓokonzi pha nga ɓoɓoɓakyi pha mokyisi mumu, ɓaaka nga nde ɓaŋwanesi eɓasi phɔ nga sa kaa o maɓɔkɔ ma Ɓayuda. Kasi ɓokonzi pha nga, uŋwaŋwa eye, teɓoli pha wawa.» ");
INSERT INTO loq_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilata amba wɔ nɛ yokye: «Oli nde mokonzi?» Yesu amba mobuyisa yokye: «Ewɔ nde wɛ oɓokye nali mokonzi. Naɓotama emba naya o mokyisi phɔ ya iya imola maphɔɔ maa phɛlɛ. Moto munsɔ oli na maphɔɔ maa phɛlɛ kaokye ŋwɛsi ŋwa nga». ");
INSERT INTO loq_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilata amba ya wɔ nɛ yokye: «Maphɔɔ ma phɛlɛ eli iye?» Waatuna Pilata ɓaɓona, amba kula kyɛndɛ ɓenga Ɓayuda o nze, amba wɔ na ɓɛ́ɛ yokye: «Phɔ ya nga, sikyi mozwa na ná lowɔɔ lɔnɔlɔ looɓe. ");
INSERT INTO loq_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Kasi ɓo wamɛlɛ ɓɛ̀ɛ oɓokye mbula na mbula naekandolele moto wa bɔlɔko mɔnɔmɔ phɔ abutwe oka yɛ, imbɛlɛ size ɓɛ́ɛ eyenga ya Ilekana, kozingye oɓokye naekandolele mokonzi ŋwa Ɓayuda?» ");
INSERT INTO loq_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ɓamba ya butwa iyaŋwana ɓɛkye: «Mɔna phe, nde Ɓalaɓa!» Nzuka Ɓalaɓa mɛ aɓaka moɓoni ná moibi. ");
INSERT INTO loq_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ɓoɓɛlɛ, Pilata amba ya na Yesu oɓokye ɓamobinde phimbo. ");
INSERT INTO loq_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ɓatuluku, ɓamba ya tonga eboko, ekyelate ɓakonzi, na milɔ. Ɓamba na molasa yango o moto. Ɓamba kula na molasa munkoto ŋwa mangola ");
INSERT INTO loq_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ɓamba ya susinya phɛnɛphɛ nɛ ɓambe wɔ ɓɛkye: «Wɛ mɔna, mokonzi ŋwa Ɓayuda!» Ɓamba butwa na imowanda bingyete. ");
INSERT INTO loq_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilata amba kula tɔkɔlɔ o iɓanda, amba ya wɔ na Ɓayuda yokye: «Kyeka, naetɔkɔlɛlɛ yo o iɓanda, ombe eɓa oɓokye sikyi zwa nɔnɔ lowɔɔ lonɔlɔ looɓe oka yɛ.» ");
INSERT INTO loq_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Yesu amba ya tɔkɔlɔ o iɓanda, alati eɓoko ekyelate ɓakonzi etongyi ɓɛ́ɛ na milɔ na munkoto ŋwa mangola. Pilataa amba ya wɔ na ɓɛ́ɛ yokye: «Kyeka moto mɛ!» ");
INSERT INTO loq_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Kasi waamowɛnɛ ɓanganga ɓanɛnɛ na ɓato ɓa ɓɛ́ɛ ɓamba butwa iyaŋwana ɓɛkye: «Omoɓakye o ekulusu! Omoɓakye o ekulusu!» Pilata amba wɔ na ɓɛ́ɛ yoye: «Omokpe, omoɓakye o ekulusu ɓɛ̀ɛ mampenza, phɔ ya nga, sikyi mozwa nɔnɔ na lowɔ looɓe.» ");
INSERT INTO loq_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ɓayuda ɓamba mobuyisa ɓɛkye: «Toli na moɓeko mɔnɔmɔ, emba phɔ ya moɓeko mɛ, asengyesi iwa phɔ amibuye Ŋwana wa Ŋwaphongo!» ");
INSERT INTO loq_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Waoka Pilata ɓaɓona, akulaka ila na ɓoikye. ");
INSERT INTO loq_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Amba kula nyɔlɔ o ingambi, amba ya tuna Yesu, yokye: «Iwɛ, oli wa bi?» Kasi Yesu taika mobuyisa nɔnɔ eyano. ");
INSERT INTO loq_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ɓoɓɛlɛ, Pilata amba ya wɔ nɛ yokye: «Kolɛ iwɔlɛ nga! Toeɓe oɓokye nali na ɓokonzi na pha iekandola na pha ieɓaka oekulusu?» ");
INSERT INTO loq_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Kasi Yesu amba mobuyisa yokye: «Tokokakyi iɓa na ɓokonzi mi nga ɓo tephautaka o ikolo, emba yango mɛna oonzambye oka ya wɛ, ali na isumu sinɛnɛ.» ");
INSERT INTO loq_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Waoka Pilata ɓaɓona, alukaka malondo ma ibikya Yesu. Ɓayuda ɓaesi ya aŋwana, ɓɛkye: «Ɓo obikye moto mona, toli nwɛbi na Moangyesi munɛnɛ, Kaisala.» Moto okomibuya mokonzi na ndengye yɛ mampenza, mɛna owa ilanga na Kaisala. ");
INSERT INTO loq_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ɓoɓɛlɛ, Pilata aesi ya tɔkɔlɔ Yesu o iɓanda. Yo akyɛ zala o elele ekyeɓangye ɓɛ́ɛ Mokpengba ŋwa Maɓanga phɔ ya itena ɓolombe. O munɔkɔ ŋwa Ɓayuda, elele mɛ, ɓaeɓangye Gaɓata. ");
INSERT INTO loq_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Yaɓaka mokɔlɔ mɔnɔmɔ oɓo pha eyenga ya ilekana, imbɛlɛ sikome bunya i moto. Pilata aesi ya wɔ na Ɓayuda, yokye: «Kyeka, mokonzi ŋwa ɓɛ!» ");
INSERT INTO loq_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Baesi ya aŋwana, ɓɛkye: «Awe! Awe! Omoingya o ekulusu!» Pilata, yokye: «Naingya mokonzi ŋwa ɓɛ́ɛ o ekulusu?» Ɓakambi ɓa ɓanganga, ɓɛkye: «Ɓanga, tololi na mokonzi mosuu, toeɓe nde Kaisala, suka.» ");
INSERT INTO loq_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ɓoɓɛlɛ, Pilata amba ya ambya Yesu oɓokye ɓamoingya o ekulusu. Uŋwaŋwa eye, ɓakuli yaakya Yesu. ");
INSERT INTO loq_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yesu aesi ya nyanya ekulusu yo mampenza, aikyi mokyisi mamuna, nɔnɔ o elele ekye ɓangye ɓɛ: «Engyɛngyɛlɛ ya moto», o munɔkɔ ŋwa Ɓayuda, ɓɛkye: «Gologota.» ");
INSERT INTO loq_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Wamɔ, ɓaesi ya ingya Yesu o ekulusu. Ɓaingye na ɓato ɓasuu ɓaɓale o bikulusu, ona bi ɓoloo, ona bi ɓowɛɛ, Yesu waa nte. ");
INSERT INTO loq_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilata aesi ya wɔ oɓokye ɓakome mokanda, ɓamoɓakye o ikolo sa ekulusu ya Yesu. Mokanda mɛ mowɔ ɓoɓo: «Yesu, moto wa Nazalɛtɛ, mokonzi ŋwa Ɓayuda.» ");
INSERT INTO loq_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ɓayuda ɓaikye ɓatangaka mokanda mɛ, phɔ elele eya ingyaka ɓɛ́ɛ Yesu o ekulusu, yaɓaka phɛnɛphɛ na mokyisi. Ɓakomaka mokanda mɛ na nɔkɔ iyato iye: Munɔkɔ ŋwa Ɓabɛlɛ, ŋwa Ɓaloma, ŋwa Ɓaela. ");
INSERT INTO loq_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ɓoɓɛlɛ, ɓakambi ɓa ɓanganga ɓakyɛ wɔ na Pilata, ɓɛkye: «Manya ɓookomi wɛ wɛkye: “Mokonzi ŋwa Ɓayuda”, kasi buya oɓokye: “Moto mɛ awɔɔ yokye: Nali mokonzi ŋwa Ɓayuda.”» ");
INSERT INTO loq_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilata, yokye: «Ɓoumbo nga koma, waikale nde ɓookomi nga.» ");
INSERT INTO loq_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Waingya ɓatuluku Yesu o ekulusu, ɓatuluku mɛ ɓaesi ya kpa bitobu ɓɛ, ɓabikaɓi na maalo mane, tuluku na tuluku na sɛ iyalo. Ɓakpe na munkoto nwɛ, ŋwaaɓaka sa ɓobambele, ɓamotonga ɓotongyi tata o ikolo nɔnɔ o se. ");
INSERT INTO loq_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ɓɛkye: «Ɓanga sa mokakola. Toma zekye, moto owamoza, kamokpe.» Eli nde ɓomɔ phɔ lowɔ, laakoma ɓɛ́ɛ o buku pha Ŋwaphongo lolo, lokokye: «Ɓakabi bitobu ɓanga onte ya ɓɛ, ɓamaalesi munkoto ŋwa nga zekye.» Ɓatuluku mɛ ɓakyelaka nde ɓomɔ. ");
INSERT INTO loq_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Maliya, nyango wa Yesu, yo na ŋwana nyango wa ŋwaŋwasi, na Maliya ŋwaŋwasi wa Keleopasi, na Maliya owa Magadala, ɓatɛmɛkyɛ ɓɛ́ɛ ɓasɔ phɛnɛphɛ na ekulusu eyaka Yesu. ");
INSERT INTO loq_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Waawɛnɛ Yesu nyango, na moekosi owalɔɓɔkɔ yo zinga, atɛmi phɛnɛphɛ na nyango, aesi ya wɔ na nyango, yokye: «Mama, mɛna eli ŋwana wa wɛ». ");
INSERT INTO loq_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Awɔ na moekosi mɛ, yokye: «Mɛna eli nyɔngɔ. Nde sina imbɛlɛ mɛ, moekosi mɛ aesi ya kpa nyango o ingambi sɛ.» ");
INSERT INTO loq_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Sima ya maphɔɔ mamana, ɓo waeɓaka Yesu oɓokye etoma yɛ yuumbo, aesi ya wa, phɔ ya ikokya maphɔɔ maakoma ɓɛ́ɛ o buku, yokye: «Naokyi phowa ya maa.» ");
INSERT INTO loq_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Kpala yɔnɔyɔ yaɓaka wamɔ, yatondaka na malɛku ma ngaa. Ɓaesi ya kpa inyuka, ɓasinyinye o malɛku mɛ, ɓasiphakye i ŋwana ŋwete, ɓasiongyise Yesu o munɔkɔ. ");
INSERT INTO loq_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Waanyunya yo malɛku mɛ, yokye: «Etoma ya nga yumbo.» Amba ya nyɔkya moto, asɛngɔɔ. ");
INSERT INTO loq_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Yaɓaka nkɔlɔ ya mosala itano, ɓakambi ɓa Ɓayuda teɓaikaka zinga oɓokye ɓato ɓaikale o ekulusu nɔnɔ mokɔlɔ moeme ɓɛ. Mokɔlɔ mɛ ŋwaɓaka na ntina enɛnɛ phɔ ŋwalongoɓanaka na eyenga ya Ilekana. Ɓoɓɛlɛ, ɓaesi yaakyɛ wɛ na Pilata oɓokye ɓatene ɓato mɛ mpee ya makolo, ɓambe ɓamanya. ");
INSERT INTO loq_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Pilata aesi ya toma ɓatuluku, ɓakyɛ tena mpee ya makolo ma ɓato ɓaɓale, ɓaaingyaka ɓɛ́ɛ na Yesu molɔngɔ o bikulusu. ");
INSERT INTO loq_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Wakoma ɓɛ́ɛ oka Yesu, ɓawɛnɛkyɛ oɓokye ambo wa. Yango mɛna, teɓaika motena mpee yaa makolo. ");
INSERT INTO loq_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Mɔnɔmɔ na ɓatuluku aesi ya mumaa ikɔngɔ o moɓanzi. Ɓoɓɛlɛ, na malongo na maa maesi ya tɔkɔlɔ. ");
INSERT INTO loq_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Moto okoeimole maphɔɔ mamana, amawɛnɛkyɛ, maphɔɔ mɛ mali phɛlɛ. Amaimolaka oɓokye na ɓɛ, oanole mɛ. Kaeɓe oɓokye kawɔ phɛlɛ. ");
INSERT INTO loq_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Lowɔ lalona lalekanaka phɔ lowɔɔ laakoma ɓɛ́ɛ o Buku pha Ŋwaphongo lolo, lokokye: «Ete ɓaamotene nɔnɔ mumpee mɔnɔmɔ.» ");
INSERT INTO loq_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Lowɔ loyɔkɔ laakoma ɓɛ́ɛ lokule wɔ oɓokye: «Ɓamokyeka yo uumbo ɓɛ́ɛ maa.» ");
INSERT INTO loq_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Uŋwaŋwa eye, moto mɔnɔmɔ na nkombo Zozefu, aesi ya onga Pilata, oɓokye akpe ndemba ya Yesu. Zezefu, mokyisi nwɛ Alimataya, aɓaka moekosi wa Yesu. Taikaka miebinya phɔ aɓaka kaile Ɓayuda. Pilata aesi ya anola. Ɓoɓɛlɛ, Zozefu aesi ya kyɛ kpa ndemba ya Yesu. ");
INSERT INTO loq_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodɛmɛ, owakyɛkyɛ phanza oka Yesu waamokɔlɔ mamuna, aɓaka nɛ, yo na Zozefu. Ɓoɓɛlɛ, aesi na nɛ yaakyela ɓɛ́ɛ na phoo na makyikyi ma ŋwete. Yaɓaka na ɓozito pha ɓakilo mako maato. ");
INSERT INTO loq_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ɓaesi ya kpa ndemba ya Yesu, ɓɛ́ɛ ɓasɔ ɓaɓale. Ɓaezingyi na bitato, ɓakyesi na mɛɛ mɛ o motema. Mɛna eli ɓo wamɛlɛkyɛ Ɓayuda ikunda ɓato. ");
INSERT INTO loq_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","O elele eyaingyaka ɓɛ́ɛ Yesu, iɓala sɔnɔsɔ sa ndemo saɓaka wamɔ. O motema ŋwa iɓala mɛ, mɔɔtɔ mɔnɔmɔ monyakune ŋwaɓaka omɔ, naino teɓamokundi moto. ");
INSERT INTO loq_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Yaɓaka mokɔlɔ mɔnɔmɔ oɓo pha mokɔlɔ moeme Ɓayuda. Yango mɛna, ɓamba ya kunda Yesu, phɔ ilita mɛ saɓaka phɛnɛphɛ. ");
INSERT INTO loq_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Mokɔlɔ ŋwa eyenga, waa moyɛlɔ, Maliya Magadala aesi ya kyɛ o mɔɔtɔ. Waakoma yo omɔ, awɛni ɓamanye iɓanga saaziɓaka ɓɛ́ɛ o munɔkɔ ŋwa mɔɔtɔ. ");
INSERT INTO loq_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ɓoɓɛlɛ, aesi ya kyilingana, akyɛ zwa Simo Petelo na moekosi oyɔkɔ, owaɓaka Yesu kazingye. Aesi ya wɔ na ɓɛ, yokye: «Ɓakyɛɛ manya Nkolo o mɔɔtɔ, toloebi mbale ekyɛ ɓɛ́ɛ molangya.» ");
INSERT INTO loq_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Petelo na moekosi mɛ mɔna, ɓaesi ya mana, ɓakyɛ o mɔɔtɔ. ");
INSERT INTO loq_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ɓaesi ya kyilingana, ɓɛ́ɛ ɓasɔ ɓaɓale. Ka moekosi mɛ mɔna alekyi Petelo na mbango, akyɛ koma o mɔɔtɔ, moto owa oɓo. ");
INSERT INTO loq_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Aesi ya nɔngyɛmɛlɛ, awɛni bitato ɓa malekani bilangyi o se, nzuka yo taikaka nyɔlɔ omɔ. ");
INSERT INTO loq_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Emba Simo Petelo owamoɓengaka o sima, nɛ aesi ya koma. Aesi ya nyɔlɔ o mɔɔtɔ awɛni nɛ bitato ɓa malekani biilangyi o se, ");
INSERT INTO loq_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Na malekani maamozingaka ɓɛ́ɛ o moto. Malekani mɛ mazingami, malangyi mbale, bitato na bango mbale. ");
INSERT INTO loq_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ɓoɓɛlɛ, moekosi mɛ owakomaka o mɔɔtɔ moto owa oɓo, nɛ aesi ya nyɔlɔ omɔ. Awɛni nde ɓomɔ, amba yaanola oɓokye Yesu akundoo. ");
INSERT INTO loq_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Naɓo ɓaɓona, ɓaekosi teɓataa kaeɓe makomi maawɔ oɓokye Yesu amokula kundwa onte ya ɓawe. ");
INSERT INTO loq_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Emba ɓaekosi mɛ ɓaɓale ɓaaɓana ɓamba ya butwa oka ɓɛ. ");
INSERT INTO loq_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Imbɛlɛ mɛ, Maliya atɛmɛkyɛ i mbale ya mɔɔtɔ, kalele. Waɓaka yo kalele, aesi ya nɔngyɛmɛlɛ o mɔɔtɔ. ");
INSERT INTO loq_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Awɛni ɓaanze ɓaɓale, ɓalati bitobu ɓa mpɛmbɛ, ɓazasi waalangyaka ɓɛ́ɛ ndemba ya Yesu, ona bi moto, ona bi makolo. ");
INSERT INTO loq_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Baanze mɛ ɓaesi ya motuna, ɓɛkye: «Mama, kolele iye?» Yokye: «Nalele phɔ ɓamanye Nkolo ya nga o mɔɔtɔ. Siebi na mbale ewaa ekyɛ ɓɛ́ɛ molangya.» ");
INSERT INTO loq_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Waaɓaka yo kawɔ ɓaɓona, ɓobuyakye miyo o sima, awɛni Yesu, atɛmi. Ka yo taikaka eɓa oɓokye mɛna Yesu. ");
INSERT INTO loq_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesu aesi ya motuna, yokye: «Mama, kolele iye? Kolukye nza?» Maliya abuyaka oɓokye kyewɔ nɛ nde moto okokyele etoma o iɓala mɛ saaɓaka mɔɔtɔ. Maliya, yokye: «Tata, ɓo wɛ moto oomumanye, onteya mbale ekyɛ wɛ molangya, Nakyɛ mokpa.» ");
INSERT INTO loq_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesu, yokye: «Maliya!» Maliya aesi ya buya miyo mbale eli Yesu. Aesi ya wɔ nɛ na munɔkɔ ŋwa Baebele, yo kye: Raboni! Kyewɔ obokye «Moteye». ");
INSERT INTO loq_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesu aesi ya wɔ nɛ, yokye: «Sa mpila phɔ nali sataa kyɛndɛ oka Tata. Kasi, okyɛ imola ɓɛbi na nga oɓokye nga Yesu, nabutwe oka Tata Ŋwaphongo, nɛ ooli Ango wa ɓɛ, na Ŋwaphongo wa ɓɛ.» ");
INSERT INTO loq_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ɓoɓɛlɛ, Maliya Magadala, aesi ya kyɛ, akyɛ imola ɓaekosi yokye: «Nawɛni Nkolo!» Amba na ɓaimola na maphɔɔ mawɔkɔ Yesu nɛ. ");
INSERT INTO loq_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Mokɔlɔ mɛ ŋwa eyenga, wa nkɔnkɔlɔ, ɓaekosi ɓaanganaka o ingambi sɔnɔsɔ ɓazibi biziɓele, phɔ ɓailaka Ɓayuda. Yesu aesi ya phunzwa, atɛmi onte ya ɓɛ, yokye: «Ɓose ɓoɓee na ɓɛ̀ɛ!» ");
INSERT INTO loq_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Waunva yo iwɔ ɓaɓona, aesi ya teya ɓaekosi matandala mɛ na moɓanzi nwɛ. Wawɛnɛkyɛ ɓɛ́ɛ Yesu, ɓabutwaka isamba. ");
INSERT INTO loq_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesu amba kula ya ɓawɔlɛ, yokye: «Ɓose ɓoɓee na ɓɛ̀ɛ! Na nga naetome o mokyisi, ɓo wantoma Tata.» ");
INSERT INTO loq_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Sima, amba ya ɓaulela muwɛ, yokye: «Naephɛ Ɓolɔɓɔ Ɓosantu! ");
INSERT INTO loq_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ɓo olimbise moto na ɓoɓe ɓookyesi yo, Ŋwaphongo nɛ aamolimbisa. Ɓo tolimbise moto na ɓoɓe ɓookyesi yo, Ŋwaphongo nɛ etamolimbisa.» ");
INSERT INTO loq_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Nzuka, waɓatɔkɔlɛlɛkyɛ Yesu, mɔnɔmɔ na ɓaekosi, na nkombo Toma okoɓangye ɓɛ́ɛ Ŋwana owa Zaa taɓaka na ɓɛ́ɛ wamɔ. ");
INSERT INTO loq_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ɓoɓɛlɛ, ɓɛbi nɛ, ɓaekosi, ɓaesi ya wɔ nɛ, ɓɛkye: «Towɛni Nkolo». Kasi yo, yokye: «Bo siwɛni biusa bia ɓasɛtɛ o matandala mɛ, sibitase na nwɛɛ, na ɓo sitase uusa eya moɓanzi nwɛ na itandala sa nga, esianole.» ");
INSERT INTO loq_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Sima ya pɔsɔ yɔnɔyɔ, ɓaekosi ɓakulaka angana o ingambi, Toma nɛ aɓaka na ɓɛ́ɛ wamɔ. Ɓazibi biziɓele, kasi Yesu akuli kyɛ ɓatɔkɔlɛlɛ. Atɛsi onte ya ɓɛ. Yokye: «Ɓose ɓoɓee na ɓɛ̀ɛ!» ");
INSERT INTO loq_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Yesu amba ya wɔ na Toma, yokye: «Elola nwɛ ŋwa wɛ oni, okyekye matandala ma nga, osusinya na itandala sa wɛ, otasa moɓanzi ŋwa nga. La kula ika ziiko, anola nde to!» ");
INSERT INTO loq_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Toma, yokye: «Nkolo ya nga na Ŋwaphongo wa nga!» ");
INSERT INTO loq_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesu, yokye: «Oanosi phɔ oonvɛni wɛ? Ɓato ɓaanzanole, mɛna sataa nvɛnɛ, ɓɛ́ɛ ɓali ɓato ɓa nkyisa!» ");
INSERT INTO loq_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu akulaka kyela bilekyesako bisuu biikye o miyo ma ɓaekosi ɓɛ, biitebaika koma ɓɛ́ɛ o Ɓuku ɓoɓo. ");
INSERT INTO loq_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Kasi maphɔɔ maakoma ɓɛ, ɓamakoma phɔ ɓɛ̀ɛ oanole oɓokye Yesu ali Masiya, Ŋwana wa Ŋwaphongo, na oɓokye, okomoanole, azwe ɓomɔɔ. ");
INSERT INTO loq_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Sima ya nkɔlɔ, Yesu akulaka kyɛ tɔkɔlɛlɛ ɓaekosi ɓɛ́ɛ o mokukulu ŋwa maa ma Tiberiade. Yaɓaka ɓoɓo: ");
INSERT INTO loq_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simo Petelo, na Toma okoɓangye ɓɛ, Ŋwana awa Zaa, na Natanaɛlɛ moto wa mokyisi ŋwa Kana o Galileya, na ɓana ɓa ɓampele ɓa Zebede, na ɓaekosi ɓaayɔkɔ ɓaɓale ɓa Yesu, ɓaɓaka na ɓɛ. ");
INSERT INTO loq_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simo Petelo aesi ya wɔ na ɓɛbi nɛ, yokye: «Nakyɛ lɔɓɔ.» Ɓɛ, ɓɛkye: «Na ɓanga, tokyɛ na wɛ.» Ɓoɓɛlɛ, ɓaesi ya kyɛ, ɓakyɛ kpela o vato, ɓabuto ikyɛ miɔlɔ. Ɓaɔsi mokɔlɔ mokɔlɔ, sa zwa ekpele. ");
INSERT INTO loq_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Waa limbi limbi, Yesu aesi ya tɛmɛ o mokukulu ŋwa maa. Mɛna ɓaekosi sa eɓa oɓokye eli yo. ");
INSERT INTO loq_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yesu aesi ya wɔ na ɓɛ, yokye: «Ɓanzenga, ozwe ŋwana ekpele?» Ɓɛɛ, ɓɛkye: «Phe» ");
INSERT INTO loq_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Iyo, yokye: «Vaka ɓondɛndi mbale ya vato eya ɓoloo, wamozwa.» Ɓoɓɛlɛ, ɓaesi ya ɓovaka mbale mɛ. Teɓakulaka koka iɓenda ɓondɛndi phɔ phatondaka na swe ɓoɓo nɔnɔ owo. ");
INSERT INTO loq_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Moekosi owaɓaka Yesu kazingye, aesi ya wɔ na Petelo, yokye: «Mɛna, eli Nkolo», Petelo amanyaka etobu phɔ ya ivaka ɓondɛndi. Waoka yo oɓokye mɛna eli Nkolo, aesi ya lata etobu mɛ. Amba ya mivaka o maa. ");
INSERT INTO loq_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ɓɛbi nɛ ɓaesi ya kyɛ na ɓona vato. Ɓabuto iɔngɔ ɓondɛndi mɛ, ɓotondi na swe. Ɓaikalaka na mokukulu phɛnɛphɛ matambe munkama. ");
INSERT INTO loq_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Waabwa ɓɛ́ɛ o mokukulu, ɓaesi ya wɛnɛ ŋwenya wamɔ, ɓatumbi swe i ŋwango, na mapa malangyi. ");
INSERT INTO loq_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesu aesi ya wɔ na ɓɛ, yokye: «Yaka na swe mii zwe ɓɛ.» ");
INSERT INTO loq_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simo Petelo aesi ya kyɛ kpela o vato. Aesi ya aɓola ɓondɛndi, ɓotondi na swe inɛnɛ na iinɛnɛ, munkama mɔnɔmɔ mbuka makoo matano na iyato. Na ɓo watondaka ɓondɛndi mɛ na swe nzikye ɓaɓona, tephaikaka kakwa. ");
INSERT INTO loq_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesu, yokye: «Ɓɛɛ, yaka, ya ze.» Moekosi nɔnɔ mɔnɔmɔ taikaka meka imotuna oɓokye: «Iwɛ oli nza?» Phɔ ɓaeɓaka oɓokye eli yo Nkolo! ");
INSERT INTO loq_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ɓoɓɛlɛ, Yesu aesi ya susinya waali ɓɛ. Aɓuto iɓakaɓela mapa mɛ mamana na swe mɛ mɛna. ");
INSERT INTO loq_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Eye, eli mbala eya iyato eyakulaka Yesu tɔkɔlɛlɛ ɓaekosi ɓɛ, wakundwa yo. ");
INSERT INTO loq_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Waumva ɓɛ́ɛ iza, Yesu amba ya tuna Simo Petelo, yokye: «Simo, ŋwana wa Yoane, oli nwɛbi na nga ileka ɓɛbi ɓaɓa?» Iyo, yokye: «Nkolo, koeɓe oɓokye nali ekamba ya wɛ.» Yesu, yokye: «Oɓanzakye ɓana ɓa mampate ma nga.» ");
INSERT INTO loq_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Akuli motuna mbala eya iɓale, yokye: «Simo, ŋwana wa Yoane, oli nwɛbi na nga?» Iyo, yokye: «Iyo, Nkolo, koeɓe oɓokye nali ekamba ya wɛ.» Yesu, yokye: «Oɓanzakye mampate ma nga.» ");
INSERT INTO loq_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Akuli ya motuna mbala eya iyato, yokye: «Simo, ŋwana wa Yoane, oli ekamba ya nga?» Waamotuna Yesu mbala eya iyato, oɓokye oli ekamba ya nga, Petelo amiokaka ngɔngɔ. Amba ya mobuyisa, yokye: «Nkolo, koeɓe phɔ isɔ, koeɓe oɓokye nali ekamba ya wɛ!» Yesu, yokye: «Oɓanzakye mampate ma nga. ");
INSERT INTO loq_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Naewɔlɛ nde phɛlɛ: Waɓaka wɛ nwɛngyɛ, wɛ mampenza waɓaka komilasa mokaɓa, wakyɛkyɛ mbale esɔ ezingyi wɛ. Kasi wamobutwa wɛ munanga, wamotandola maɓɔkɔ ma wɛ, emba moto mosuu amoelasa mokaɓa. Emba amokyɛ na wɛ mbale ewaa, eteyikyi wɛ zinga.» ");
INSERT INTO loq_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Awɔkɔ maphɔɔ mamana oɓokye aimole ɓo wamowa Petelo, na ɓo wamowɛninya yo nkyɛmɔ ya Ŋwaphongo. Ɓoɓɛlɛ, Yesu, yokye: «Imbengye!» ");
INSERT INTO loq_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Petelo aesi ya buya miyo o sima, awɛni moekosi, owaɓaka Yesu kazingye, kaya ɓaɓenga. Eli yo moekosi owakɔlɔkɔ na Yesu mi itoo, wazaka ɓɛ, yokye: «Nkolo, moto mɛ, owamoeyungya, nza?» ");
INSERT INTO loq_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ɓoɓɛlɛ, Petelo waamowɛnɛ yo, aesi ya tuna Yesu, yokye: «Ka yo, Nkolo, lowɔɔ iye laamokomela?» ");
INSERT INTO loq_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesu, yokye: «Ɓo nazingyi oɓokye ataa ɓa o mokyisi nɔnɔ mokɔlɔ mowaa, ŋwamoya nga, lowɔ mɛ lokyekyi wɛ? Kasi wɛ, imbengye!» ");
INSERT INTO loq_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ɓoɓɛlɛ, Simo yeesi ya nyangwa onte ya ɓɛbi oɓokye moekosi mɛ mɔna, etawe. Nzuka Yesu taikaka wɔ na Petelo ɓomɔ ɓaɓona. Awɔkɔ nde nɛ, yokye: «Ɓo nazingyi oɓokye aɓe o mokyisi nɔnɔ mokɔlɔ mowaa ŋwamoya nga, lowɔ mɛ lokyekyi wɛ?» ");
INSERT INTO loq_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Eli moekosi mɛ mɔna, ooloimosi maphɔɔ mɛ mamana. Amakoma o Buku ɓoɓo. Toeɓe na oɓokye maphɔɔ, maaloimosi yo mali phɛlɛ. ");
INSERT INTO loq_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesu akulaka kyela maphɔɔ masuu maikye. Ɓoɓamakomaka lowɔɔ lɔnɔlɔ na lɔnɔlɔ o Buku, naumunya oɓokye mokyisi mobimba nde te mokokakyi phɔ ya iɓomba ɓabuku ɓaunvaka ɓɛ́ɛ koma.");
INSERT INTO loq_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Nwɛbi na nga, Teofili, o buku pha nga pha ntuɓo, naeyimolaka maphɔɔ masɔ makyelaka Yesu na maateyaka yo, ");
INSERT INTO loq_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","nɔnɔ mokɔlɔ mowa ŋwa phɛ yo ɓatoma ɓaɔlɔkɔ yo miɓeko na nzela ya Ɓolɔɓɔ Ɓosantu, nɔnɔ wabaa yo o ikolo. ");
INSERT INTO loq_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Sima ya iwa sɛ, onte ya nkɔlɔ mako mane, amiwɛninyaka na ɓɛ́ɛ phɔ ya iɓateya oɓokye ali na ɓomɔɔ. Akulaka ɓakyelela bilekyesako biikye, aɓaimolaka na maphɔɔ ma ɓokonzi pha Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Mokɔlɔ mɔnɔmɔ ɓaɓaka ɓaze yo na ɓɛ, amba ya wɔɔ na ɓɛ́ɛ yokye: «Ɓɛɛ sa mana o Yelusalɛmɛ, oziyaka mbunu eya eyikyelaka Tata. Mbunu mɛ, eya eimolaka nga. ");
INSERT INTO loq_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yoane aɓatisaka ɓato na maa, kasi ɓɛ̀ɛ, sima ya ɓana nkɔlɔ, wamoɓatisama na Ɓolɔɓɔ.» ");
INSERT INTO loq_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ɓoɓɛlɛ, waɓa ɓɛ́ɛ ɓaanga, ɓatoma ɓaesi ya motuna ɓɛkye: «Nkolo, imbɛlɛ mɛ sango sisi, sasmobuyisa wɛ Isalayɛlɛ ɓokonzi phɛ?» ");
INSERT INTO loq_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yesu amba wɔ na ɓɛ́ɛ yokye: «Tosengyesi iyeɓa bileko na imbɛlɛ sa ɓɔngya Tata na ɓokonzi phɛ mampenza. ");
INSERT INTO loq_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Kasi ɓɛ̀ɛ, wamozwa mwiya ŋwaka Ɓolɔɓɔ ŋwa moeutela, emba wamoɓa manzoka ma nga o Yelusalɛmɛ, o Yuda mobimba na Samaliya, tee nɔnɔ o mbomela ya mokyisi.» ");
INSERT INTO loq_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Sima ya ɓowɔkye ɓaɓona, Yesu aesi ya baa o ikolo o miyo ma ɓɛ. Ɓoɓɛlɛ, ipata sɔnɔsɔ siesi ya moziɓa, ɓɛ́ɛ sa kula mowɛnɛ. ");
INSERT INTO loq_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Waɓa ɓɛ́ɛ ɓaikasi ilamamala ɓakyekye ɓo okokyɛ yo, ikyeka ɓoɓo, ɓampele ɓaɓale ɓalati bitobu bitane ɓaesi ya ɓatɔkɔlɛlɛ. ");
INSERT INTO loq_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ɓaesi ya wɔ na ɓɛ, ɓɛkye: «Ɓato ɓa Galileya, ɓɛ̀ɛ oikasi otɛmi wawana kokyekye o ikolo phɔ ya'ye? Yesu mɛ, obaa o ikolo o miyo ma ɓɛ̀ɛ, amokula ya nde ɓomɔ ɓo omowɛnɛkyi ɓɛ̀ɛ ibaa o ikolo.» ");
INSERT INTO loq_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ɓoɓɛlɛ, ɓatoma ɓaesi ya mana o ngomba ya nzete ya Olive, ɓabuto o Yelusalɛmɛ. Itakye sa ngomba mɛ na Yelusalɛmɛ saɓaka kilometɛlɛ yɔnɔyɔ. ");
INSERT INTO loq_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Waakoma ɓɛ́ɛ o Yelusalɛmɛ, ɓakyɛkyɛ baa o etee ya ingambi eya ikolo, eyamɛlɛkyɛ ɓɛ́ɛ izala. Yaɓaka Petelo, Yoane, Zake, Andele, Filipe, Toma, Ɓatelemi, Matiye, Zake ŋwana wa Alafa, Simo moambelesi wa mokyisi nwɛ na Yuda ŋwana wa Zake. ");
INSERT INTO loq_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ɓɛ́ɛ ɓasɔ, ndondo yɔnɔyɔ, ɓamiambyaka o iɓɔndɛlɛ nkɔlɔ isɔ, na ndambo ya ɓaɓasi: Maliya, nyango wa Yesu, na ɓasii ɓa Yesu. ");
INSERT INTO loq_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Mi nkɔlɔ mɛ, ɓaekosi ɓaanganaka elele yɔnɔyɔ na ɓato phɛnɛphɛ munkama mbuka mako maɓale. Petelo aesi yakyɛ tɛmɛ onte ya ɓɛ, amba wɔ yokye: ");
INSERT INTO loq_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«Ɓɛbi, elaa oɓokye maphɔɔ maimolaka Ɓolɔɓɔ o makomi makokyisame. Aimolaka maphɔɔ mɛ na munɔkɔ ŋwa Davidi phɔ ya Yudasi owa butwaka ikamba ɓato ɓakyɛkyɛ akya Yesu. ");
INSERT INTO loq_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Phɔ aɓaka mɔnɔmɔ na ɓanga, azwaka sɛ iyalo sa etoma na ɓanga. ");
INSERT INTO loq_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Moto mɛ aombaka mokondo na ɓaphalanga ɓaamuumaka na ɓɛ́ɛ phɔ ya ɓoɓe phakyelaka yo. Atɔkɔɓɔ na moto, ibu sɛ siwaye, nkundu yɛ isɔ inyango. ");
INSERT INTO loq_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ɓato ɓasɔ ɓa Yelusalɛmɛ ɓaokaka simo mɛ, ɓaphɛkyɛ mokondo mɛ nkombo na munɔkɔ ŋwa ɓɛ́ɛ oɓokye: “Akɛlɛdama.” Kyelukye iwɔ oɓokye: “Mokondo ŋwa malongo.” ");
INSERT INTO loq_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Na o buku pha Meembo ɓakoma oɓokye: “Ingambi sɛ sialangane, na moto mɔnɔmɔ sa sizala.” Ɓakula na koma oɓokye: “Moto mosuu akpe etoma yɛ.” ");
INSERT INTO loq_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Yango mɛna onte ya ɓampele ɓasɔ ɓaanganaka na ɓanga imbɛlɛ sisɔ saɓaka Nkolo Yesu kanyɔlɔ katɔkɔ na ɓanga, ");
INSERT INTO loq_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","tata na ɓatisimo ya Yoane nɔnɔ o mokɔlɔ ŋwaamumanya ɓɛ́ɛ onte ya ɓanga: Esengyesi oɓokye mɔnɔmɔ onte ya ɓɛ́ɛ abutwe nɛ nzoka ya ikundwa sɛ elele yɔnɔyɔ na ɓanga.» ");
INSERT INTO loq_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ɓoɓɛlɛ, ɓaesi ya tɔkɔlɔ ɓampele ɓaɓale: Zozefu okoɓangye Ɓalasaɓa, ɓamoɓokyaka nkombo esuu ya Yusutu, na Matiasi. ");
INSERT INTO loq_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Emba ɓamba ya ɓɔndɛlɛ ɓoɓo: «Iwɛ, Nkolo, okoeɓe mandondo ma ɓato ɓasɔ, oloteya moto oɔsi wɛ onte ya ɓato ɓaɓale ɓaɓa, ");
INSERT INTO loq_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","phɔ aɔlɔngɔnɔ o etoma, o elele ya ɓotoma elɛ Yudasi phɔ ya ikyɛ o elele yɛ mampenza.» ");
INSERT INTO loq_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ɓoɓɛlɛ, ɓamba ya maa mbɛsɛ, mbɛsɛ ya mba longya Matiasi, emba ɓaamba moɓakya o motango ŋwa ɓatoma iko mbuka mɔnɔmɔ. ");
INSERT INTO loq_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Wakoma nkɔlɔ mako matano, ɓaekosi ɓaanganaka ɓasɔ elele yɔnɔyɔ. ");
INSERT INTO loq_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Mbala yɔnɔyɔ, tɔkɔ yɔnɔyɔ euti o ikolo ndokolo lokyito la ewɛɛlɛ ekusi elambisinye ingambi sisɔ saazalaka ɓɛ, ");
INSERT INTO loq_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","ɓoɓɛlɛ, ɓaesi ya wɛnɛ ndee ya nwinya ikaɓaa, itɛmi o ikolo sa mɔnɔmɔ na mɔnɔmɔ na ɓɛ. ");
INSERT INTO loq_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Emba ɓɛ́ɛ ɓasɔ ɓatondaka na Ɓolɔɓɔ. Emba ɓamba butwa iwɔ na nɔkɔ suu ɓo waɓa phɛkyɛ Ɓolɔɓɔ maloɓa ma iwɔ. ");
INSERT INTO loq_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ɓayuda ɓaɓaka o Yelusalɛmɛ, ɓampele ɓaatosa Ŋwaphongo, na maɓota masɔ maali o mokyisi. ");
INSERT INTO loq_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Waokana tɔkɔ mɛna, ɓato ɓaikye ɓaesi ya kyɛ angana wamɔ. Ɓakamwaka na ɓoikye phɔ ɓaɓa ɓaɓaokye moto na moto na munɔkɔ nwɛ ŋwa lombo. ");
INSERT INTO loq_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ɓawɛnɛkyɛ inganga, ɓakamwaka, ɓamba wɔ ɓɛkye: «Taakyeka, yango ɓato ɓasɔ ɓawɔ ɓaɓa teli ɓato ɓa Galileya? ");
INSERT INTO loq_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ka ndengye'ye mɔnɔmɔ na mɔnɔmɔ onte ya ɓanga kaɓaokye na munɔkɔ nwɛ ŋwa lombo? ");
INSERT INTO loq_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Onte ya ɓanga, ɓana ɓauta o nkyisi ya Parte, Mɛdɛs na Elamitɛ, ɓato ɓa Mezopotami, ɓa Yuda na ɓa Kapadose, ɓa Pɔntis na ɓa nkyisi ya Azi, ");
INSERT INTO loq_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ɓato ɓa Friji na ɓa Pamfili, ɓa Ezipito na ɓa mokyisi ŋwa Libi phɛnɛphɛ na sirɛnɛ na ɓato ɓauta o Loma, ");
INSERT INTO loq_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ɓasɔ, eɓe Bayuda na ɓato ɓa Loma ɓamibuya Bayuda, ɓato ɓa Kɛlɛtɛ na ɓa Arabi, toɓaokye ɓanga ɓasɔ, ɓaimole bitoma binɛnɛ ɓa Ŋwaphongo na nɔkɔ ya ɓanga ya lombo!» ");
INSERT INTO loq_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ɓɛ́ɛ ɓasɔ ɓawɛnɛkyɛ inganga bibi ɓamakamakye ɓambe wɔnɔ ɓɛkye: «Eye kyelukye iwɔ ɓo?» ");
INSERT INTO loq_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Kasi ɓaayɔkɔ ɓaɓaɛkyɛkyɛ ɓɛkyɛ: «Ɓalangyi malɛku!» ");
INSERT INTO loq_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ɓoɓɛlɛ, Petelo aesi ya tɛmɛ yo na ɓɛbi nɛ ɓatoma iko mbuka mɔnɔmɔ, amba ya tomba ŋwɛsi, amba ya wɔ na ɓɛ́ɛ yokye: «Ɓɛ̀ɛ ɓato ɓa Yuda na ɓɛ̀ɛ ɓato ɓasɔ ɓaazale o Yelusalɛmɛ, sɔsɔlɔ na ɓolaa lowɔ loolekane emba ola itoo ookye maloɓa ma nga. ");
INSERT INTO loq_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ɓato ɓaɓa teɓaikyi langa malɛku ɓookoumunya ɓɛ, phɔ totaa ɓa naino nde o ngonga eya iyato eya moo; ");
INSERT INTO loq_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","kasi eye kyekokyisame yaawɔkɔ moimosi Yowɛlɛ: ");
INSERT INTO loq_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Ŋwaphongo yokye: Kyeka maphɔɔ maamoya o nkɔlɔ ya suka: Namunyangolela ɓato ɓasɔ Ɓolɔɓɔ pha nga, ɓana ɓa ɓɛ́ɛ ɓa ɓampele na ɓa ɓaɓasi ɓamoɓa ɓaimosi, ɓanzenga ɓa ɓɛ̀ɛ ɓamowɛnɛ na ndɔtɔ, ɓananga ɓa ɓɛ̀ɛ ɓamolɔtɔ mandɔtɔ; ");
INSERT INTO loq_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","ɛɛ, mi ɓato ɓa nga ɓa etoma, na ɓa ɓampele na ɓaɓasi, mi nkɔlɔ mɛ, namunyangola Ɓolɔɓɔ pha nga, emba ɓamoɓa ɓaimosi. ");
INSERT INTO loq_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Namokyela bilekyesako o ikolo na o se; na malongo, na ŋwenya na ipata saa zunguu. ");
INSERT INTO loq_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Moo ŋwamobutwa enzɔmbi; ɓokombe phamobutwa malongo. O ɓoo pha oɓokye mokɔlo ŋwa Nkolo moyee, mokɔlɔ munɛnɛ na ŋwa nkyɛmɔ. ");
INSERT INTO loq_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Emba moto munsɔ owamoɓanga nkombo ya Nkolo, amobika.”» ");
INSERT INTO loq_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","«Ɓato ɓa Isalayɛle, okyemela maphɔɔ mama: Yesu, moto wa Nazalɛtɛ, moto owa ewɛninyaka Ŋwaphongo ɓokonzi phɛ na bilekyesako ndengye na ndengye onte ya ɓɛ̀ɛ, ɓo koloeɓe ɓɛ̀ɛ mampenza. ");
INSERT INTO loq_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Moto mɛ, ɓo wameka Ŋwaphongo o ŋwango nwɛ na ɓoeɓakye phɛ, ɓɛ̀ɛ wamoambya o maɓɔkɔ ma ɓato ɓaɓe oɓokye ɓamoɓakye o ekulusu. ");
INSERT INTO loq_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Kasi Ŋwaphongo amokundola, amumanya o ɓolɔsi pha iwa, phɔ iwaa tesaɓaka na mwiya ŋwa imoakya ɓoɓɛlɛ. ");
INSERT INTO loq_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Na Davidi awɔkɔ phɔ yɛ, yokye: “Imbɛlɛ sisɔ nawɛnɛkyɛ Nkolo atɛmi o ɓoo pha nga, phɔ ali o ɓolo pha nga phɔ nga sanyingana. ");
INSERT INTO loq_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Yango mɛna, ndondo ya nga eli na nkyisa, na lolee la nga lokumbe na nkyisa ɓoikye; na nzoto ya nga ili na molemo, ");
INSERT INTO loq_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","phɔ otoikye molimo ŋwa nga o mokyisi ŋwa ɓawe, otoolɛ na nga moto wa wɛ, oɓokye nzoto ya nga iphɔlɔ o mɔɔtɔ. ");
INSERT INTO loq_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Onteye manzela ma ɓomɔɔ, iɓa sa wɛ na nga elele yɔnɔyɔ simpɛ nkyisa.”» ");
INSERT INTO loq_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","«Ɓɛbi na nga, naewɔlɛ saasa phɔ ya nkɔkɔ Davidi oɓokye awa, ɓamokunda. Na mɔɔtɔ nwɛ moli nɔnɔ lɔlɔ onte ya ɓanga. ");
INSERT INTO loq_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Kasi yo, aɓaka moimosi, aeɓaka na oɓokye Ŋwaphongo amolakyelaka oɓokye amozasa mɔnɔmɔ na ɓankɔkɔ ɓauta o ibu sɛ o eziye ya ɓokonzi; ");
INSERT INTO loq_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","awɛnɛkyɛ phanza ikundwa sa Klisto, emba phɔ yɛ awɔkɔ yokye: Teɓaikaka molɛ o mokyisi ŋwa ɓawe na nzoto yɛ teyaikaka phɔlɔ o mɔɔtɔ. ");
INSERT INTO loq_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Yesu mɛ, Ŋwaphongo amokundola, ɓanga ɓasɔ toli manzoka. ");
INSERT INTO loq_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Waabaa yo o eɓɔkɔ ya ɓoloo ya Ŋwaphongo, amba zwa na Ango Ɓolɔɓɔ pha molakyelaka yo; emba yo amba ɓonyangola, ɓoko wɛnɛ ɓɛ̀ɛ na ɓookokye ɓɛ̀ɛ ɓoɓo. ");
INSERT INTO loq_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Davidi, otowaika baa o ikolo, ana wɔ yokye: “Nkolo Ŋwaphongo awɔ na Nkolo ya nga yokye: Yaka ya zale o ɓoloo pha nga, ");
INSERT INTO loq_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","tee nɔnɔ wamobuya nga ɓanguna ɓa wɛ ekyitele ya makolo ma wɛ.” ");
INSERT INTO loq_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Ɓato ɓasɔ ɓa Isalayɛlɛ ɓaeɓe na ɓolaa oɓokye: Ŋwaphongo amokyela Nkolo ná Klisto, nde ona Yesu owaɓakaka ɓɛ̀ɛ oekulusu!» ");
INSERT INTO loq_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Waaoka ɓɛ́ɛ maphɔɔ mamana, mandondo ma ɓɛ́ɛ temaɓaka ɓose. Ɓaesi ya wɔ na Petelo na ɓatoma ɓayɔkɔ ɓɛkye: Ɓɛbi na ɓanga, tokyele ɓo? ");
INSERT INTO loq_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Petelo amba ɓabuyisa yokye: «Ɓongola ntema ya ɓɛ̀ɛ: Mɔnɔmɔ na mɔnɔmɔ na ɓɛ̀ɛ aɓatisame na nkombo ya Yesu Klisto phɔ alimbisame na masumu mɛ, emba wamozwa ikaɓo sa Ɓolɔɓɔ pha Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Phɔ mbunu mɛ eli phɔ ya ɓɛ̀ɛ, na ɓana ɓa ɓɛ̀ɛ na ná ɓato ɓaali itakye, ɓasɔ ɓaamoɓanga Nkolo wa ɓanga Ŋwaphongo.» ");
INSERT INTO loq_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Na maloɓa masuu, Petelo aɓaimolaka na maphɔɔ masuu na iɓalenza yokye: «Omibikya, onte ya yoo eyaɔtɔnɔ eye!» ");
INSERT INTO loq_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ɓato ɓaanolaka iloɓa sɛ ɓazwaka batisimo. Mokɔlɔ mɛ, ɓato ɓaaɓakyisamaka o motango ŋwa ɓaanosi, ɓakomaka phɛnɛphɛ na nkoto iyato. ");
INSERT INTO loq_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ɓɛ́ɛ ɓasɔ ɓalendelaka iɓenga mateya ma ɓatoma na iɓa elele yɔnɔyɔ ndokolo ɓato ɓa iɓota, na itenana ipa na ná maɓɔdɛsi. ");
INSERT INTO loq_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ɓɛ́ɛ ɓasɔ ɓawɛnɛkyɛ ɓɔɓɔ phɔ ɓatoma ɓakyelaka bilekyesako ndengye na ndengye. ");
INSERT INTO loq_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ɓato ɓasɔ ɓaabutwaka ɓaanosi ɓabutwaka moto mɔnɔmɔ emba ɓaangyiyaka mbolo ya ɓɛ́ɛ isɔ elele yɔnɔyɔ. ");
INSERT INTO loq_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ɓaungyaka manzabi ma ɓɛ́ɛ na mbolo ya ɓɛ, phɔ ya ikaɓa ɓana ɓaphalanga onte ya ɓɛ́ɛ ɓasɔ, kokokana na ɓosenga pha moto na moto. ");
INSERT INTO loq_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Mokɔlɔ na mokɔlɔ, ɓalendendalaka ikyɛ o Ingambi siinɛnɛ sa losambo, ɓakyɛsɛkyɛ mapa o mangambi ma ɓɛ, ɓakaɓaka ntoma na nkyisa na ná ndondo yɔnɔyɔ. ");
INSERT INTO loq_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ɓakumbelaka Ŋwaphongo emba ɓato ɓasɔ ɓaɓaka ɓaɓayambe na ɓolaa. Emba Nkolo akyinzaka mokɔlɔ na mokɔlɔ o ingomba ɓato ɓaabikaka o ingomba. ");
INSERT INTO loq_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Petelo na Yoane ɓakyɛkyɛ ikyɛ ɓɔndɛlɛ o Ingambi siinɛnɛ sa losambo, yaɓaka wa ngonga eya iyato eya nkɔkɔlɔ. ");
INSERT INTO loq_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ɓamba yaa na lele mɔnɔmɔ owa ɓaka etuku tata iɓotama sɛ. Nkɔlɔ isɔ ɓaɓaka ɓamozasa o munɔkɔ ŋwa Inganbi siinɛnɛ sa losambo siɓangye ɓɛ́ɛ Moziɓo Molaa phɔ aongakye ɓaphalanga oka ɓato ɓasɔ ɓaayanyɔlɔ omɔ. ");
INSERT INTO loq_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Lele mɛ, wawɛnɛ yo Petelo na Yoane ɓalukye inyɔlɔ o Ingambi sinɛnɛ sa losambo, aesi ya ɓaonga ɓaphalanga. ");
INSERT INTO loq_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Emba Petelo na Yoane ɓamba molembetela, Petelo amba ya wɔɔ nɛ yokye: «Olokyekye» ");
INSERT INTO loq_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Lele mɛ amba ɓakyeka, phɔ aumunyaka izwa na ɓɛ́ɛ ŋwana ekpele. ");
INSERT INTO loq_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ɓoɓɛlɛ Petelo aesi ya wɔ nɛ yokye: «Wolo ná ɓaphalanga, sili na yango; kasi eli na nga, naephɛ yango: Na nkombo ya Yesu Klisto moto wa Nazalɛtɛ, tambula!» ");
INSERT INTO loq_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Emba amba ya mophila mi eɓokɔ eya ɓoloo, amoinosi. Mina wamɔ, makolo na makyɛɛ matuto. ");
INSERT INTO loq_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Moto mɛ aesi ya ngbika, atɛmi, abuto itambula. Amba ya nyɔlɔ na ɓɛ́ɛ o Ingambi siinɛnɛ sa losambo, abuto ikyɛmitambula, kakyɛmingbika bibi kakumbele Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ɓato ɓasɔ ɓaamba mowɛnɛ katambule kakyɛmikumbela Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ɓamoeɓaka oɓokye eli yo moto owaɓaka kazale phɔ ya iongaka o Moziɓo Molaa ŋwa Ingambi siinɛnɛ sa losambo. Emba ɓato ɓailaka, ɓakamwaka na lowɔɔ lamoyelelaka. ");
INSERT INTO loq_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Waaɓa moto mɛ saika Petelo na Yoane itakye, ɓato ɓasɔ ɓayakaka angana wali ɓɛ́ɛ na ikamwa o mokpengba ŋwa Salomo. ");
INSERT INTO loq_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Waawɛnɛ Petelo ɓaɓona, aesi ya wɔ na ɓato mɛ, yokye: «Ɓampele ɓa Isalayɛlɛ, phɔ ya'ye kokamwe na lowɔ lolo? Phɔ ya'ye kololembetele, ndokolo naa ɓanga totambuse moto oyo na mwiya ɓanga naa na ngɔngɔ ya ɓanga? ");
INSERT INTO loq_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ŋwaphongo wa Abalayama, wa Izaka na Yakoɓo, Ŋwaphongo wa ɓaango ɓa ɓanga, aphɛ mosali nwɛ Yesu ngambo, yo owa ungyaka ɓɛ̀ɛ na owa lɛkyɛ ɓɛ̀ɛ o ɓoo pha Pilata owa kpaka meko oɓokye kamokandole. ");
INSERT INTO loq_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Kasi ɓɛ̀ɛ walɛkyɛ moto o mosantu na owa ɓosembo, wamba onga oɓokye ɓaekandolele moɓomi ŋwa ɓato. ");
INSERT INTO loq_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Mokonzi ŋwa ɓomɔɔ owa ɓoma ɓɛ̀ɛ. Ŋwaphongo amokundola o ɓawe, ɓanga toli manzoka ma lowɔɔ mɛ. ");
INSERT INTO loq_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Phɔ ya ianola nkombo ya Yesu, nkombo mɛ esi ya kuya moto okowɛnɛ ɓɛ̀ɛ na okoeɓe ɓɛ̀ɛ oyo; emba ianola siute na Yesu simophɛ nzoto ɓokusi o miyo ma ɓɛ̀ɛ ɓasɔ.» ");
INSERT INTO loq_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","«Yango mɛna, ɓɛbi, naeɓe oɓokye wakyelaka ɓaɓona phɔ ya ɓoeɓakye phe, nde ya ɓakonzi ɓa ɓɛ̀ɛ. ");
INSERT INTO loq_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ŋwaphongo akokye nde ɓomɔ maphɔɔ mawɔkɔ yo phanza na nzela ya ɓaimosi ɓasɔ oɓokye Klisto amunyɔkɔmɔ. ");
INSERT INTO loq_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ɓongola motema ombe butwela Ŋwaphongo, phɔ masumu ma ɓɛ̀ɛ ma malimbisame: ");
INSERT INTO loq_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Emba imbɛlɛ sa iema saamoephɛɛ Nkolo samoya, waamotoma yo Klisto owa emekyela yo, yo Yesu. ");
INSERT INTO loq_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Iyo asengyesi iikala o ikolo nɔnɔ imbɛlɛ sa mokokyisama maphɔɔ masɔ maawɔkɔ Ŋwaphongo namunɔkɔ ŋwa ɓaimosi ɓasantu ɓakalakala. ");
INSERT INTO loq_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Mose phanza awokɔ yokye: “Nkolo Ŋwaphongo wa ɓɛ̀ɛ, amoetomela moimosi mɔnɔmɔ onte ya ɓɛ̀ɛ ɓoli nga; waamooka o maphɔɔ masɔ ma moewɔlɛ yo. ");
INSERT INTO loq_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Emba moto munsɔ owamoɓa saoka moimosi mɔna, etakule ɓa onte ya ɓato, ɓaamoɓoma.” ");
INSERT INTO loq_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Emba ɓaimosi ɓasɔ tata na Samwɛlɛ na ɓasɔ ɓaya o sima yɛ, mɔnɔmɔ na mɔnɔmɔ awɔkɔ phɔ ya iimola nkɔlɔ mɛ ili ɓanga iye. ");
INSERT INTO loq_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Eli ɓɛ̀ɛ ɓana ɓa ɓaimosi na ɓaa sangola eya kyelaka Ŋwaphongo na ɓaango ɓa ɓɛ̀ɛ, waawɔkɔ yo na Abalayama oɓokye: “Phɔ ya ɓankɔkɔ ɓa wɛ, maɓota masɔ ma mokyisi mamopambolama.” ");
INSERT INTO loq_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Eli phanza phɔ ya ɓɛ̀ɛ, Ŋwaphongo atɔkɔlɔ Mosali nwɛ, amba motoma iepambola phɔ ya iemanya moto na moto o maphɔɔ mɛ maaɓe.» ");
INSERT INTO loq_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Waaɓa Petelo na Yoane ɓata ɓa iwɔnɔ na ɓato, ɓanganga ɓa Ŋwaphongo na mokonzi ŋwa ɓaɓanze ɓa Ingambi siinɛnɛ sa losambo na ɓa-Sadukayi ɓaesi wali ɓɛ. ");
INSERT INTO loq_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ɓaɓaka na yɔ iikye ya iɓawɛnɛ ɓateya na iimola ikundwa sa ɓawe ɓo wakundwa Yesu. ");
INSERT INTO loq_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ɓaesi ya ɓaakya, ɓakyɛ ɓanyɔsa o bɔlɔkɔ nɔnɔ yana phɔ ya butwaka nkɔkɔlɔ. ");
INSERT INTO loq_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ɓato ɓaikye ɓaokaka Iloɓa, ɓaanolaka motango ŋwa ɓɛ́ɛ ŋwa komaka phɛnɛphɛ na koto itano. ");
INSERT INTO loq_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Waakoma yana, ɓakonzi, ɓankumu na ɓateye ɓa Miɓeko ɓaanganaka oli ɓɛ́ɛ o Yelusalɛmɛ. ");
INSERT INTO loq_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Yaɓaka Ana, nganga ya Ŋwaphongo o munɛnɛ, Kaifa, Yoane, Alegizandele na ɓato ɓasɔ ɓaa iɓota sa nganga o munɛnɛ. ");
INSERT INTO loq_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ɓaesi ya tɛyɛ Petelo na Yoane onte ya ɓɛ, ɓabuto iɓatuna ɓɛkye: «Na mwiya iye na ná nkombo iye, ɓɛ̀ɛ wakyela lowɔ lalona?» ");
INSERT INTO loq_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Emba Petelo atondi na Ɓolɔɓɔ pha Ŋwaphongo, amba wɔ na ɓɛ́ɛ yokye: «Ɓakonzi ɓa ɓato na ɓankumu, ");
INSERT INTO loq_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ɓo ɓanga lɔlɔ ɓalosambisa phɔ tokyesi moto wa ɓolɔsi lowɔ lolaa, oɓokye toimole na ndengye moto mɔna azwe ɓolaa, ");
INSERT INTO loq_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","oeɓe na ɓolaa ɓɛ̀ɛ ɓasɔ na ɓato ɓa Isalayɛlɛ oɓokye, eli na nkombo ya Yesu Klisto, moto wa Nazalɛtɛ, owa ɓakaka ɓɛ̀ɛ o ekulusu, Ŋwaphongo amokundola onte ya ɓawe, emba eli nde o nzela yɛ, moto ootɛmi o ɓoo pha ɓɛ̀ɛ oyo abikyi. ");
INSERT INTO loq_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yo ali “iɓanga sa tiyolaka ɓɛ́ɛ ɓatongyi ɓa mangambi, siibuto iɓanga siiphisi ingambi sisɔ.” ");
INSERT INTO loq_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Lobiko loli nde na nzela yɛ, kasi na mosuu phe, phɔ nkombo esu teeli o munse mumu eya phɛ ɓɛ́ɛ ɓato eekokyi ilophɛ lobiko.» ");
INSERT INTO loq_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Waaɓa ɓɛ́ɛ ɓawɛnɛ ianola sa Petelo na Yoane, na waeɓaka ɓɛ́ɛ oɓokye ɓali ɓato ɓate ɓaika ekola na ɓato pha, ɓakamwaka, emba ɓamba eɓa oɓokye ɓato mɛ ɓaɓaka elele yɔnɔyɔ na Yesu. ");
INSERT INTO loq_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Kasi waaɓa ɓɛ́ɛ ɓawɛnɛ moto obikyi, atɛmi phɛnɛphɛ na ɓɛ, teɓakulaka zwa na lowɔɔ la ibuya. ");
INSERT INTO loq_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ɓoɓɛlɛ, ɓaesi ya ambya moɓeko ŋwa iɓatɔkɔlɔ o elele ekyeangane ɓɛ́ɛ iwɔ maphɔɔ, ɓamba butwa iwɔnɔ onte ya ɓɛ, ");
INSERT INTO loq_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","ɓɛkye: «Tomokyela ɓo na ɓato ɓaɓa? Phɔ waeɓa saa na ɓato ɓasɔ ɓaazasi o Yelusalɛmɛ oɓokye nde eyakolo elekyesako ekyelami na maɓɔkɔ ma ɓɛ. Tolokokyi ieyangana. ");
INSERT INTO loq_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Kasi phɔ ya oɓokye simo mɛ sanyangwa oka ɓato ɓasɔ, toɓakatele, ɓɛ́ɛ sakula wɔ na nkombo mɛ eɓe naa na moto nza.» ");
INSERT INTO loq_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ɓoɓɛlɛ, ɓaesi ya ɓaɓanga, ɓaɓakatesi na ɓokusi oɓokye ɓɛ́ɛ sakula wɔ eɓe iteya na nkombo ya Yesu. ");
INSERT INTO loq_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Kasi Petelo na Yoane ɓaesi ya ɓabuyisa ɓɛkye: «Ɓɛɛ mampenza otene ɓolombe ɓo eli phɛlɛ oɓokye: Ɓanga toeyokye ndee tookye nde Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Phɔ ya ɓanga tolokokyi ilɛ iteya maphɔɔ maawɛnɛkyɛ ɓanga na miyo ma ɓanga na maaokaka ɓanga na matoo ma ɓanga.» ");
INSERT INTO loq_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ɓamba kula ɓakatela, emba ɓamba ɓalɛ phɔ tebaikaka zwa malondo ma iɓakanga. Phɔ ɓato ɓasɔ ɓakumbelaka Ŋwaphongo phɔ ya lowɔɔ lalekanaka. ");
INSERT INTO loq_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Moto owa bikaka na mwiya ŋwa Ŋwaphongo aɓaka na mambula koleka mako mane. ");
INSERT INTO loq_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Waɓakandola ɓɛ, Petelo na Yoane ɓamba yakyɛ oka ɓɛbi na ɓɛ́ɛ ɓamba ɓaumola maphɔɔ masɔ mawɔkɔ ɓanganga ɓanɛnɛ ɓa Ŋwaphongo na ɓankumu. ");
INSERT INTO loq_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Waoka ɓɛ́ɛ maphɔɔ mamana, ɓaanosi ɓamba yaangana ɓɛ́ɛ ɓasɔ ndondo yɔnɔyɔ, ɓaɓɔndɛlɛ Ŋwaphongo, ɓɛkye: «Nkolo, iwɛ moto owakyela ikolo, munse, maa na isɔ iili omɔ. ");
INSERT INTO loq_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Na mwiya ŋwa Ɓolɔɓɔ, wawɔkɔ na nzela ya nkɔkɔ wa ɓanga Dawidi, moto wa wɛ okoekyelele ɓoɓo: “Phɔ ya'ye nkyisi isɔ itɔmbi na ɓato ɓaawangye makɔlɔ ma pha? ");
INSERT INTO loq_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ɓakonzi ɓa munse munsɔ ɓatombi, iŋwana eɓasi. Na ɓaangyesi ɓaanga oɓokye ɓaangyenele Ŋwaphongo na Masiya wɛ.” ");
INSERT INTO loq_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Eli nde phɛlɛ oɓokye Elode na Pɔnti Pilata ɓaanga o mokyisi mumu na ɓato ɓaateɓali Ɓayuda na ɓosoo Yisalaɛlɛ, ɓaangyenele okoekyelele, yo Yesu Mosantu, owalɛ wɛ iɓa Masiya. ");
INSERT INTO loq_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Na ɓomɔ, ɓakokyee maphɔɔ masɔ, maakanaka wɛ phanza na ɓokusi pha wɛ na ná maumunya ma wɛ. ");
INSERT INTO loq_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Uŋwaŋwa eye, Nkolo, okyekye ɓookokane ɓɛ. Ophɛ ɓato ɓa wɛ ɓaekyelele nguya oɓokye ɓamilenza phɛlɛ iimola maphɔɔ ma wɛ. ");
INSERT INTO loq_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Elola eɓɔkɔ ya wɛ oɓokye ɓato ɓaamalɔsi ɓabikye, bilekyesako na bilembetele bikyelame na nkombo ya Mosantu wa wɛ, okoekyelele, yo Yesu.» ");
INSERT INTO loq_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Waunva iɓɔndɛlɛ, elele eyaanganaka ɓɛ́ɛ yabutwaka inyingana. Emba ɓasɔ ɓatondaka na Ɓolɔɓɔ Ɓosantu, ɓabuto imilenza ikyɛ miimola maphɔɔ ma Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ɓaanosi ɓasɔ ɓaɓaka na ndondo yɔnɔyɔ na ná mokali mɔnɔmɔ. Mɔnɔmɔ na ɓɛ́ɛ tawɔkɔ oɓokye mbolo yɛ ili yɛ ya mpenza. Kasi mbolo isɔ onte ya ɓɛ́ɛ yaɓaka ya ɓɛ́ɛ ɓasɔ. ");
INSERT INTO loq_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ɓatoma ɓaimolaka na nguya ɓoikye oɓokye Nkolo Yesu akundwa ya phɛlɛphɛlɛ. Ŋwaphongo aɓapambolaka na ɓoikye. ");
INSERT INTO loq_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Onte ya ɓasɔ molaa taɓaka. Yango mɛna, ɓato ɓasɔ ɓaaɓaka na manzabi, eɓe mangambi, ɓaiyungyaka. Ɓakpe ɓaphalanga ɓaazwaka ɓɛ, ");
INSERT INTO loq_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ɓakyɛ ɓaphɛ ɓatoma. Emba ɓakaɓaka onte ya ɓɛ́ɛ kokokana na ɓosenga pha moto na moto. ");
INSERT INTO loq_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Moto mɔnɔmɔ, na nkombo Zezefu, wa iɓota sa Lewi, amoɓotaka o esanga ya Shiprɛ, ɓatoma ɓamoɓokyaka nkombo ya Ɓalaɓa kyeyimole oɓokye «moto ookolenza ɓɛbi». ");
INSERT INTO loq_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Aungyaka inzabi sɛ, akpee ɓaphalanga ɓaazwaka yo, akyɛ ɓaphɛ ɓatoma. ");
INSERT INTO loq_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Kasi lele mɔnɔmɔ na nkombo Ananiya, na ŋwaŋwasi wɛ na nkombo Safila, ɓamba ya ungya inzabi sa ɓɛ. ");
INSERT INTO loq_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ananiya aɓombaka ɓaphalanga ɓaayɔkɔ mi ɓaphalanga ɓaazwaka yo, ɓaaikalaka, aesi ya kyɛ ɓaphɛ ɓatoma. Ŋwaŋwasi wɛ aeɓaka lowɔ mɛ. ");
INSERT INTO loq_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ɓoɓɛlɛ, Petelo aesi ya wɔ nɛ, yokye: «Ananiya, phɔ ya'ye Molemba aangangasi o ndondo ya wɛ oɓokye okosa Ɓolɔɓɔ Ɓosantu? Oɓombi ɓaphalanga ɓayɔkɔ mi ɓaazwakyi wɛ, waungye wɛ inzabi. ");
INSERT INTO loq_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Oɓakyi wɛ sataa ungya inzabi mɛ, sango siɓakyi sa wɛ. Emba sima osiungye wɛ, ɓaphalanga ɓaakyi ɓa wɛ, teli ɓomɔ? Ndengye'ye okani o ndondo ya wɛ oɓokye okyele ɓaɓona? Iwɛ tokatesi ɓato kasi okatesi Ŋwaphongo.» ");
INSERT INTO loq_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Waoka Ananiya maphɔɔ mamana, akaa o se, awe. Emba ɓato ɓasɔ ɓaokaka simo mɛ, ɓailaka na ɓoikye. ");
INSERT INTO loq_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ɓanzenga ɓaesi ya kyɛ zinga ndemba yɛ na bitobu, ɓaenyanye, ɓakyɛ ekunda. ");
INSERT INTO loq_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Yalekanaka phɛnɛphɛ ngonga iyato, ŋwaŋwasi nɛ, aesi ya nyɔlɔ, sa eɓa lowɔ lotɔkɔlɔkyi. ");
INSERT INTO loq_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Petelo aesi ya motuna, yokye: «Inzimole, ɓaphalanga ɓaaungye na ɓɛ́ɛ inzabi, ɓɛ́ɛ ɓaso ɓaɓana?» Ŋwaŋwasi, yokye: «Ɓɛ ɓasɔ ɓaɓana.» ");
INSERT INTO loq_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ɓɔɔlɛ, Petelo aesi ya wɔ nɛ, yokye: «Yaɓo'ye, wɛ na molo nya wɛ okɔsi oɓokye omekye Ɓolɔɓɔ pha Nkolo? Kyeka, ɓato ɓaauti ikyɛ kunda molo nya wɛ, ɓatɔkɔsi o munɔkɔ ŋwa ingambi. Na wɛ, ɓamoya ekpa nde ɓomɔ.» ");
INSERT INTO loq_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Mina wamɔ, ŋwaŋwasi mɛ akaa o makolo ma toma Petelo, awee. Ɓanzenga mɛ waanyɔlɔ ɓɛ, ɓakyɛ mozwa, ambo wa. Ɓamba ya mokpa, ɓakyɛ mokunda phɛnɛphɛ na molo nyɛ. ");
INSERT INTO loq_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ɓato ɓasɔ ɓa Ingomba na ɓato ɓasɔ ɓaaokaka lowɔ mɛ, ɓamba ya ila na ɓoikye. ");
INSERT INTO loq_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ɓatoma ɓakyelaka bilekyesako na bilembetele biikye onte ya ɓato. Ɓaanosi ɓaanganaka ɓasɔ elele yɔnɔyɔ o mokpengba ŋwa Salomo o Tempelo. ");
INSERT INTO loq_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Moto mosuu nɔnɔ mɔnɔmɔ taikaka meka ikyɛ angana na ɓɛ, kasi ɓato ɓaɓaka ɓaɓamengyele na ɓoikye. ");
INSERT INTO loq_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ɓampele na ɓaɓasi ɓaikye ɓaanolaka Nkolo, ɓamikyinzaka o eɓoko ya ɓaanosi. ");
INSERT INTO loq_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ɓato ɓabutwaka ikyɛ nyanya ɓaokaa, ɓakyɛ ɓaika o nzela, ɓaɓalangye mi ndengba na mi matɔkɔ oɓokye imbɛlɛ samolekana Petelo, elalaa yɛ ekaalele nɔnɔ ɓaokaa ɓayɔkɔ. ");
INSERT INTO loq_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Eɓoko ya ɓato ɓautaka o nkyisi yaa phanɛphɛ na Yelusalɛmɛ, ɓakyɛkyɛ na ɓaoka na ná ɓato ɓanyɔkɔmɔ na malɔɓɔ maɓe. Emba ɓato ɓasɔ ɓabikaka. ");
INSERT INTO loq_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Nkolo wa Ɓanganga na ɓato ɓasɔ ɓaaka nɛ, ɓato ɓa ingomba sa Ɓasadukai ɓaokyelaka ɓatoma zuwa siikye. ");
INSERT INTO loq_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ɓaesi ya kyɛ akya ɓatoma, ɓakyɛ ɓanyɔsa o bɔlɔkɔ. ");
INSERT INTO loq_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Kasi imbɛla sa mokɔlɔ, ŋwanze ŋwa Nkolo akyɛ ziɓola bikomba ɓa bɔlɔkɔ atɔkɔsi ɓatoma, yokye: ");
INSERT INTO loq_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Kyɛndɛ okyɛ nyɔlɔ o Tempelo, oimole ɓato maphɔɔ masɔ maa bomɔ ɓonyakune.» ");
INSERT INTO loq_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Waoka ɓɛ́ɛ ɓaaɓona, wa mumbengu ɓakyɛ nyɔlɔ o Tempelo, ɓabuto iteya. Nkolo wa Ɓanganga, na ɓato ɓaaɓaka nɛ, ɓaesi ya koma. Ɓaɓangyi ɓakumu ɓasɔ ɓa Yisalayɛlɛ, ɓasɔ ɓaesi ya angana. Ɓaesi ya toma ɓato ikyɛ kpa ɓatoma o bolɔkɔ. ");
INSERT INTO loq_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Waakoma ɓakyɛngyɛsi o bɔlɔkɔ, ikyɛ azwa omɔ phe. Ɓaesi ya butwa ikyɛ imola ɓato ɓaaɓatomaka. ");
INSERT INTO loq_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Ɓɛkye: «Tokyɛ zwa bɔlɔkɔ ɓaezibi nde na ɓolaa, na ɓakyɛngyɛsi ɓatɛmi oɓo pha moziɓo ŋwa bɔlɔkɔ. Kasi waziɓosi ɓanga, toloikyi zwz nɔnɔ moto mɔnɔmɔ o motema.» ");
INSERT INTO loq_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Waoka Nkolo wa ɓakyɛngyɛsi ɓa Tempelo na ɓakolo ɓa Ɓanganga maphɔɔ mamana, ɓakamwaka na ndengye eyalɛmɔkɔ ɓatoma, ɓamitunaka ɓo wamoɓa lowɔɔ mɛ. ");
INSERT INTO loq_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Moto mɔnɔmɔ aesi ya kyɛ ɓaimola, yokye: «Kyeka ɓampele ɓanyɔsakyi ɓɛ́ɛ o bɔlɔkɔ, ɓali o Tempelo, ɓateya ɓato.» ");
INSERT INTO loq_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ɓoɓɛlɛ, Nkolo wa ɓakyɛngyɛsi aesi ya kyɛ na ɓato ɓɛ, ɓakyɛ kpa ɓatoma. Kasi ɓakyɛkyɛ na mɔɔ na mɔɔ, phɔ ɓailaka oɓokye ɓato sa ɓamaa maɓanga. ");
INSERT INTO loq_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ɓaesi ya kyɛ na ɓɛ, ɓakyɛ ɓatɛyɛ oɓo pha ɓato ɓaanganaka. Nkolo ya Ɓanganga abuto iɓatuna, ");
INSERT INTO loq_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","yokye: «Toekatelaka na ɓokusi oɓokye sa kula teya na nkombo ya moto mɔna. Kyeka onyangosi maphɔɔ maateya ɓɛ́ɛ o mokyisi munsɔ ŋwa Yelusalɛmɛ. Kolukye na ibuya oɓokye ɓanga ɓato ɓaamoɓoma.» ");
INSERT INTO loq_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Petelo, na ɓɛbi nɛ ɓatoma, ɓaesi ya ɓabuyisa yokye: «Ioka Ŋwaphongo, na ioka ɓato, ɓanga tookye konza Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ŋwaphongo wa ɓankɔkɔ ɓa ɓanga owakundola Yesu owaɓomaka ɓɛ́ɛ o ekulusu. ");
INSERT INTO loq_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Amobaya o mopha nwɛ ŋwa ɓoloo, amobuya Nkolo na Mobikye phɔ ya ɓato ɓa Yisalayɛlɛ ɓaingole mandondo ma ɓɛ, na oɓokye ɓaɓalimbisa na ɓoɓe pha ɓɛ. ");
INSERT INTO loq_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ɓanga, na Ɓolɔɓɔ Ɓosantu pha Ŋwaphongo ɓoophɛ yo ɓato ɓawaa ɓaamookye, toli manzoka ma maphɔɔ masɔ mamana.» ");
INSERT INTO loq_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Waaoka ɓɛ́ɛ maphɔɔ mamana, ɓaokaka yɔ, ɓalukaka oɓokye ɓaɓome ɓatoma. ");
INSERT INTO loq_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Kasi Mofalisayi mɔnɔmɔ aɓaka onte ya ɓɛ, na nkombo Gamaliɛlɛ, moteye ŋwa miɓeko. Ɓato ɓasɔ ɓamokumolaka, amba ya tɛmɛ onte ya ɓasɔ ɓaanganaka, aɓaongyi oɓokye ɓataa kuta tokɔlɔ ɓatoma onze. ");
INSERT INTO loq_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ɓoɓɛlɛ, aesi ya wɔ na ɓɛ, yokye: «Ɓato ɓa Yisalayɛlɛ, okyeɓaka na lowɔɔ laamokyela ɓɛ́ɛ na ɓato ɓaaɓana. ");
INSERT INTO loq_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Phɔ tewakyesi nkɔlɔ nzikye, Teudas atɔkɔlɔkɔ, yokye: Konza nde yo. Ɓato phɛnɛphɛ minkama mine ɓabutwa isanga nɛ. Kasi yo, ɓamoɓomaka, emba ɓato ɓasɔ ɓaamoɓengaka, ɓamba ya nyangwa, tewakulaka wɛnɛnɛ nɔnɔ moto mɔnɔmɔ. ");
INSERT INTO loq_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Sima yɛ, imbɛlɛ saakyelamaka etango, yakulaka tɔkɔlɔ moto mɔnɔmɔ wa Galileya na nkombo Yudasi, azwaka ɓato ɓaikye ɓaamoɓengaka. Kasi nɛ, ɓamoɓomaka. Emba ɓato ɓasɔ ɓamoɓengaka, ɓamba ya nyangwa. ");
INSERT INTO loq_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Uŋwaŋwa eye, naambe ya ewɔlɛ, ngakye: Ɓɛ́ɛ sakula kyelela ɓato ɓaaɓana etungu, o ɓalɛ, ɓakyɛndɛ. Ɓo eɓe oɓokye maumunya ma ɓɛ̀ɛ na etoma ekyekyele ɓɛ iuti na ɓato, yamunyangwa. ");
INSERT INTO loq_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Kasi ɓo kyeute na Ŋwaphongo, tokokyi ieɔtɔ. Okyeɓe oɓokye ɓɛ́ɛ sa ŋwana na Ŋwaphongo.» Ɓato ɓasɔ ɓaanganaka ɓaesi ya anola maumunya ma Gamalilɛ. ");
INSERT INTO loq_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ɓamba ya ɓanga ɓatoma, ɓaɓawandi phimbo, ɓakuli ɓakatela oɓokye ɓɛ́ɛ sa kula teya na nkombo ya Yesu. Emba ɓamba ya ɓakandola. ");
INSERT INTO loq_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ɓatoma ɓaesi ya mana o elele eyaanganaka ɓɛ́ɛ na nkyisa isɔ, phɔ Ŋwaphongo aɓaphɛ kaa mi minyɔkɔ miizwe ɓɛ́ɛ phɔ ya nkombo ya Yesu. ");
INSERT INTO loq_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Emba nkɔlɔ isɔ teɓaikaka lɛ iteya na iimola Simo Elaa ya Yesu Masiya onte ya Tempelo, eɓe na o mangambi ma ɓato. ");
INSERT INTO loq_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Mi nkɔlɔ mɛ mina, ɓaekosi ɓalɔɓɔkɔ ɓoikye, Ɓayuda ɓa munɔkɔ ŋwa Ɓaela ɓawɔlɛkyɛ Ɓayuda ɓa muna mokyisi, oɓokye: Nkɔlɔ isɔ, waakaɓe ɓɛ́ɛ ntoma, mazengye ma ɓanga maimale. ");
INSERT INTO loq_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ɓoɓɛlɛ, ɓatoma iko mbuka ɓaɓale mɛ ɓaesi ya anginya ɓaekosi ɓasɔ, ɓawɔ na ɓɛ, ɓɛkye: «Teli ɓolaa oɓokye ɓanga tolɛkyɛ imola Simo ya Ŋwaphongo phɔ ya ikaɓaka yaa izaa. ");
INSERT INTO loq_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Yango mɛna ɔlɔ onte ya ɓɛ, ɓampele sambo ɓaali na moɓesi molaa, ɓaatonda na Ɓolɔɓɔ Ɓosantu na ná ɓoomakye. Emba tombe ɓaphɛ etoma mɛ mɛna. ");
INSERT INTO loq_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ɓanga tomiamba nde iɓɔndɛlɛkyɛ na iimolaka Simo ya Ŋwaphongo.» ");
INSERT INTO loq_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ɓɛ́ɛ ɓasɔ ɓaanolaka maphɔɔ mamana. Ɓaesi ya ɔlɔ ɓato ɓaɓa: Setefano, moanosi ŋwa phɛlɛ owa tonda na Ɓolɔɓɔ Ɓosantu, Filipe, Pɔlɔkɔlɛ, Nikanola, Timona, Palamena na Nikola, moto wa Antioshe owamibuyaka Moyuda. ");
INSERT INTO loq_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ɓaesi ya kyɛ ɓateya ɓatoma, ɓaɓɔndɛsi na ɓɛ, ɓaɓatandesi maɓɔkɔ. ");
INSERT INTO loq_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Simo ya Ŋwaphongo yanyangwaka mboka esɔ. Mokyisi ŋwa Yelusalɛmɛ ŋwabutwaka na ɓaekosi ɓaikye, na ɓanganga ɓaikye ɓa Ŋwaphongo ɓaanolaka. ");
INSERT INTO loq_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ŋwaphongo atonzaka Setefano na ngɔlu na ná ɓokusi phɛ. Setefano mɛ akyelaka bilembetele na bilekyesako binɛnɛ onte ya ɓato. ");
INSERT INTO loq_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Kasi, ɓato ɓaayɔkɔ ɓaikaka ziiko na Setefano: Yaɓaka ɓato ɓaaɓɔndɛlɛ o ingambi siinɛnɛ sa losambo la Ɓayuda siiɓangye ɓɛ: Ɓaombo ɓaikwa: Ɓayuda ɓa Sirɛnɛ, ɓa Alegizandri, ɓa Silisi, na ɓa Azi. ");
INSERT INTO loq_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Teɓaikaka koka imunyɛtɛ phɔ aɓaka kawɔ na ɓomakye phaamophɛkyɛ Ɓolɔɓɔ Ɓosantu. ");
INSERT INTO loq_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ɓoɓɛlɛ, ɓamba ya phɛ ɓato ɓayɔkɔ ɓaphalanga oɓokye ɓaimole, oɓokye: «Tomookyi, katole Mose, eɓe na Ŋwaphongo!» ");
INSERT INTO loq_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Nde ɓaɓona ɓamba ya losa ɓato ná ɓankumu ná ɓateye ɓa miɓeko. Emba aɓesi ya moakya, ɓakyɛ moika oɓo pha ɓato ɓaanganaka. ");
INSERT INTO loq_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ɓaesi ya kyɛ na ná ɓato ɓaamokatele maphɔɔ, oɓokye: Moto oyo talɛ itola Tempelo ya ɓanga na moɓeko ŋwa Mose. ");
INSERT INTO loq_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Tomookyi kawɔ, yokye: Yesu wa Nazalɛtɛ amoɔtɔ Tempelo, ɓamobuya na ɓonkɔkɔ phaloikyelaka Mose ndengye esuu. ");
INSERT INTO loq_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ɓato ɓasɔ ɓaanganaka, ɓabuto ilembetela Setefano. Ɓawɛni ɓoo phɛ ɓobuto ndokolo ɓoo pha anzelu. ");
INSERT INTO loq_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Nganga omunɛnɛ amba ya motuna yokye: «Maphɔɔ mamana mali phɛlɛ?» ");
INSERT INTO loq_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Etiɛni amba ya mobuyisa yokye: «Ɓa tata na ɓɛbi na nga, okyemela. Ŋwaphongo owa nkyɛmɔ atɔkɔlɛlɛkyɛ ango wa ɓanga Abalayama waaɓaka yo o Mezopotami, sa ɓokyɛkyɛ zala o Halana, ");
INSERT INTO loq_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","amba ya wɔ nɛ yokye: “Mana o mokyisi ŋwa wɛ, wɛ na ɓonkpe pha wɛ, okyɛndɛ o mokyisi ŋwamoeteya nga.” ");
INSERT INTO loq_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ɓoɓɛlɛ, Abalayama amba ya mana o mokyisi ŋwa Ɓakaladi phɔ ya ikyɛ zala o Halana. Omɔ, sima ya iwa sa ango, Ŋwaphongo aesi ya mumanya o mokyisi ŋwa Halana. Amunyɔsɛ o mokyisi moozasi ɓɛ̀ɛ lɔlɔ eye. ");
INSERT INTO loq_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ŋwaphongo taika mophɛ nɔnɔ ekpele o mokyisi mɛ, nɔnɔ ŋwana elele wa itɛya makolo. Kasi amolakyelaka oɓokye aamophɛ mokyisi mɛ, na ɓo Abalayama tataaka ɓa na ŋwana. ");
INSERT INTO loq_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Emba Ŋwaphongo amba wɔ ɓoɓo: “Ɓankɔkɔ ɓɛ́ɛ ɓamozala o mokyisi mosuu, ɓaaɓabuya ɓaombo, emba ɓaaɓanyɔkɔlɔ mbula mikama mine. ");
INSERT INTO loq_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Kasi mokyisi mɛ ŋwaaɓabuyaka ɓaombo, naamosambisa, inga, kyewɔ Ŋwaphongo. Emba sima mɛ, ɓamotɔkɔlɔ, emba ɓamunkyelela o elele mɛ.” ");
INSERT INTO loq_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Amba ya kyela na ɓɛ́ɛ sangola ya iɓɛlɛ. Yango mɛna waaɓota yo Izake, Abalayama amba ya moɓɛlɛ waakokya yo nkɔlɔ ŋwambi. Izake amba kyela nde ɓomɔ na Yakoɓo, emba Yakoɓo amba kyela nde ɓomɔ mɛ na ɓana ɓɛ́ɛ iko mbuka ɓaɓale ɓaabuwaka ɓankɔkɔ iko mbuka ɓaɓale ɓa Isalayɛlɛ.» ");
INSERT INTO loq_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","«Ɓankɔkɔ mɛ ɓaokyelaka Zozefu zuwa, ɓamba muungya phɔ ɓakyɛ nɛ o Ezipito. Kasi Ŋwaphongo aɓaka nɛ, ");
INSERT INTO loq_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Amba motɔkɔlɔ onte ya minyɔkɔ misɔ mamina, amba na mophɛ ɓolaa na zebi o ɓoo pha Falo, mokonzi ŋwa Ezipito, owa mobuyaka moangyesi ŋwa Ezipito na ingambi sɛ sisɔ. ");
INSERT INTO loq_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Nzuka zilo siesi yakyinda Ezipito mobimba na Kanana. Minyɔkɔ maɓaka miike, emba ɓaango ɓa ɓanga teɓakulaka ɓaa na ntoma ya iza. ");
INSERT INTO loq_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Waaoka ɓɛ́ɛ oɓokye ntoma yaɓaka o Ezipito, Yakoɓo amba ya toma ɓaango ɓa ɓanga mbala eya ntuɓo omɔ. ");
INSERT INTO loq_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Mbala eya iɓale, Zozefu aesi ya eɓa ɓanaa nyango, emba Falo amba ya eɓa mbale eyauta yo. ");
INSERT INTO loq_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ɓoɓɛlɛ, Zozefu amba ya toma oɓokye ɓakyɛ kpa ango Yakoɓo na ɓanaa nyango, ɓɛ́ɛ ɓasɔ ɓaɓaka ɓato mako sambo na ɓatano. ");
INSERT INTO loq_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ɓoɓɛlɛ Yakoɓo amba yakyɛ o Ezipito, amba waa omɔ yo na ɓaango ɓa ɓanga. ");
INSERT INTO loq_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ɓakyɛkyɛ na biɓembe ɓa ɓɛ́ɛ o Sikɛmɛ, ɓaamba kyɛ ɓakunda omɔ, o elele eli mɔɔtɔ ŋwa ombaka Abalayama na ɓaphalanga oka ɓana ɓa Hamɔr, ango wa Sikɛmɛ.» ");
INSERT INTO loq_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","«Waaɓa oɓokye mbunu eyaikyelaka Ŋwaphongo Abalayama, ebutoo phɛnɛphɛ na ikokyisama, ɓankɔkɔ ɓa ɓanga ɓaamba ɓotama, butwaka ɓaikye o Ezipito. ");
INSERT INTO loq_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Nɔnɔ waakpa moto mosuu ɓokonzi o Ezipito, otoikaka eɓa Zozefu. ");
INSERT INTO loq_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Na malondo, mokonzi mɛ anyɔlɛlɛkyɛ ɓonkpe pha ɓanga: Phowa ya inyɔkɔlɔ ɓaango ɓa ɓanga yakyɛkyɛ tee nɔnɔ o iɓatoma na ɓokusi oɓokye ɓavakye ɓana ɓaaɓote ɓɛ́ɛ ɓaa sika phɔ ɓawe. ");
INSERT INTO loq_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Imbɛlɛ mɛ saɓotamaka Mose. Aɓaka molaa o miyo ma Ŋwaphongo. Makombe maato, ɓaɓaka ɓamoɔkɔlɔ o ingambi sa ango ");
INSERT INTO loq_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","emba, wakyɛ movaka ɓɛ, ŋwana wa Falo wa ŋwaŋwasi amba mɔɔngɔ, amba moɔkɔlɔ ndokolo ŋwana wɛ solongo. ");
INSERT INTO loq_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Mose aekolaka zebi sisɔ sa ɓato ɓa Ezipito, emba aɓaka na mwiya o maphɔɔ ma wɔ yo na o bitoma ɓɛ. ");
INSERT INTO loq_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Waakokya yo mbula mako mane, maumunya maamba moyelela oɓokye akyɛndɛ oka ɓanaa nyango, ɓana ɓa Isalayɛlɛ. ");
INSERT INTO loq_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Waakyɛ wɛnɛ yo mɔnɔmɔ na ɓɛ́ɛ ɓamunyɔkɔlɔ, amba moambelela, emba phɔ ya ibuya ɓo nyɔkɔsi ɓɛ́ɛ nwɛbi mɔna, amba ɓoma moto owa Ezipito. ");
INSERT INTO loq_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Aɓaka kaumunya oɓokye ɓanaa nyango ɓamosɔsɔlɔ oɓokye Ŋwaphongo aaɓabikya na nzela yɛ Mose, kasi ɓɛ́ɛ teɓaikaka sɔsɔlɔ ɓomɔ. ");
INSERT INTO loq_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ɓo yana, ɓamowɛni kakande ɓato ɓaɓale ɓaŋwane eɓasi ekusi, phɔ ya imeka iɓaɓɔngya, amba wɔ na ɓɛ́ɛ yokye: “Ɓɛbi, ɓɛ́ɛ oli inyango, phɔ ya'ye koŋwane?” ");
INSERT INTO loq_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Kasi owaɓaka kawande nwɛbi amba uka Mose, amba wɔ nɛ yokye: “Oekyesi mokonzi na munanga ŋwa ɓanga nza? ");
INSERT INTO loq_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Kolukye imboma ɓo waɓomaka wɛ moto wa Ezipito yana?” ");
INSERT INTO loq_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Waoka Mose maphɔɔ mamana, amba ya lota, amba kyɛ miɓomba o mokyisi ŋwa Madiani. Amba kyɛ ɓota omɔ ɓana ɓa ɓampele ɓaɓale.» ");
INSERT INTO loq_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","«Sima ya mbula mako mane, anzelu amba motɔkɔlɛlɛ o bokye pha ngomba ya Sinayi, onte ya ingyɛngu sa ŋwenya. ");
INSERT INTO loq_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mose akamwaka na lowɔɔ lawɛnɛkyɛ yo. Waluka yo isusana phɔ ya ikyeka, ŋwɛsi ŋwa Nkolo ŋwamba okana: ");
INSERT INTO loq_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Nali Ŋwaphongo wa ɓaɔngɔ, Ŋwaphongo wa Abalayama, wa Izake na wa Yakoɓo”. Na itɛkyɛnɛlɛ, Mose takulaka nyanga na ikyeka. ");
INSERT INTO loq_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ɓoɓɛlɛ, Nkolo amba wɔ nɛ yokye: “Manya ɓasapato ɓa wɛ o makolo, phɔ elele etɛmi wɛ eli manyɛtɛ masantu. ");
INSERT INTO loq_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Phɛlɛ, nawɛni pasi ya ɓato ɓa nga o Ezipito, naokyi na nkyime ya ɓɛ. Nauti o se phɔ ya iɓaikola. Emba uŋwaŋwa eye, kyɛndɛ, nazingye ietoma o Ezipito.”» ");
INSERT INTO loq_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","«Nde ona yo Mose, owa lɛkyɛ ɓɛ, oɓokye: “Oekyesi mokonzi na munanga nza?” Eli nde yo owatomaka Ŋwaphongo ndokolo mokonzi na mokandosi, na nzela ya anzelu owa motɔkɔlɛlɛkyɛ o ingyɛngu sa nweya siilole. ");
INSERT INTO loq_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Eli yo owaɓatɔkɔlɔkɔ o Ezipito na ikyela maphɔɔ ma ikamwa na mayaa o mokyisi ŋwa Ezipito, o ebale enɛnɛ eya mangola na o bokye tee mambula mako mane. ");
INSERT INTO loq_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ekuli ɓa nde yo Mose, owawɔkɔ na Ɓaisalayɛlɛ oɓokye: “Ŋwaphongo amotɔkɔlɔ onte ya ɓanaa nyango na ɓɛ̀ɛ moimosi mɔnɔmɔ ɓooli nga.” ");
INSERT INTO loq_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Eli yo moto owaa owatɛmɛkyɛ onte ya ɓaango ɓa ɓanga na anzelu owawɔkɔ nɛ o bokye, o ikolo sa ngomba ya Sinai. Eli yo moto owazwaka maloɓa ma ɓomɔɔ phɔ ya ilophɛ mango. ");
INSERT INTO loq_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Kasi ɓaango ɓa ɓanga teɓaikaka zinga oɓokye ɓamookye. Ɓamotɛkyɛ, na maumunya, ɓakulaka butwa o Ezipito. ");
INSERT INTO loq_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ɓamba wɔ na ná Alona ɓɛkye: “Olokyelele ɓaŋwaphongo ɓaamoɓaka matambule oɓoo pha anga. Phɔ ona Mose owalotɔkɔlɔkɔ o mokyisi ŋwa Ezipito, toloeɓe maphɔɔ maamoyelesi.” ");
INSERT INTO loq_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Mi nkɔlɔ mɛ, ɓamba ya ema ekyeko ya ŋwana wa ngɔmbɛ, ɓamba ya eɓonzela bilambo, ɓamba yaanela na nkyisa ekpele eyakyela ɓɛ́ɛ na maɓɔkɔ ma ɓɛ. ");
INSERT INTO loq_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Phɔ ya ɓomɔ, Ŋwaphongo amba ɓambya o maɓɔkɔ ma ɓatuluku ɓa ikolo, nde ɓo wakomama wango o buku pha ɓaimosi oɓokye: “Ɓato ɓa Isalayɛlɛ, mbula mako mane, o bokye, wambomela manyama, wambonzela mambeka? ");
INSERT INTO loq_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Wanyanya molaku ŋwa Ŋwaphongo Moloki na nyasɛɛsi wa Ŋwaphongo wa ɓɛ̀ɛ Lefana, bikyeko ɓabina wabikyela phɔ ya ibikumola. Yango mɛna namokyɛ evaka itakye koleka Ɓabilɔnɛ.”» ");
INSERT INTO loq_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","«O bokye, ɓaango ɓa ɓanga ɓaɓaka na molaku ŋwaaɓaka na moɓeta ŋwa sangola: Mose amokyelaka nde ɓo waawɔkɔ Ŋwaphongo nɛ. Amokyelaka kokokana na ndengye eya mowɛnɛkyɛ yo. ");
INSERT INTO loq_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Waazwa ɓaango ɓa ɓanga molaku mɛ, ɓamba munyɔsa ɓo waɓakambaka Yosuwa o mokyisi ŋwaaɓolɔlɔkɔ ɓɛ́ɛ mi nkyisi yawiinyaka Ŋwaphongo ɓato o ɓoo pha ɓɛ. Molaku ŋwa moɓeta ŋwa sangola mɛ ŋwaɓaka omɔ nɔnɔ o imbɛlɛ saaka Davidi. ");
INSERT INTO loq_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Davidi azwaka ngɔlu o miyo ma Ŋwaphongo, amba na onga nɛ oɓokye atongele Ŋwaphongo wa Yakoɓo na ingambi sa izala. ");
INSERT INTO loq_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Kasi yaɓaka nde Salomo owamotongyelaka ingambi. ");
INSERT INTO loq_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Kasi Owa ikolo taazale o mangambi maatongama na maɓɔkɔ ma ɓato. Nde ɓo wawɔ moimosi oɓokye: ");
INSERT INTO loq_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“Ikolo sili eziye ya nga ya ɓokonzi emba manyɛtɛ mali ekyitele ya nga ya makolo. Ingambi ye saamuntongyela ɓɛ̀ɛ, kyewɔ Nkolo, na elele ya nga ya iema yamoɓa ewa? ");
INSERT INTO loq_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Teli maɓɔkɔ ma nga makyela bikpele bisɔ ɓabina?”» ");
INSERT INTO loq_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","«Ɓato ɓa nzoto nkusi, ɓate ɓaika ɓɛ́ɛ ɓɛlɛ o ndondo na o matoo, nkɔlɔ isɔ kosemole Ɓolɔɓɔ Ɓosantu; oli nde ya ɓaango ɓa ɓɛ̀ɛ! ");
INSERT INTO loq_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Moimosi nza ooto wanyɔkɔlɔ ɓaango ɓa ɓɛ̀ɛ? Ɓaɓoma na ɓaimolaka phanza iya sa Moto owa ɓosembo, nde yo ooungye ɓɛ̀ɛ na ooɓomi ɓɛ́ɛ uŋwaŋwa eye. ");
INSERT INTO loq_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ɓɛ̀ɛ wazwaka moɓeko ŋwaeyimolaka ɓaanzelu, emba toika mokyelela!» ");
INSERT INTO loq_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Maphɔɔ mɛ maɓaphɛkyɛ kabu emba ɓamba butwa izaa mino na yɔɔ phɔ ya Etiɛni. ");
INSERT INTO loq_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Kasi yo, atondaka na Ɓolɔɓɔ, kakyekye nde ikolo. Amba wɛnɛ nkyɛmɔ ya Ŋwaphongo na Yesu atɛmi o ɓoloo pha Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Yokye: «Kyeka, nawɛnɛ ikolo siingo na Ŋwana wa moto atɛmi o ɓoloo pha Ŋwaphongo.» ");
INSERT INTO loq_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ɓamba ya lika nyangye na ɓokusi, ɓaundi matoo. Ɓoɓɛlɛ, ɓɛ́ɛ ɓasɔ, ɓamba ya mivaka mi yo, ");
INSERT INTO loq_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ɓaesi ya kyɛ nɛ i mbale ya mokyisi, ɓabuto imumaa maɓanga oɓokye awe. Manzoka ɓaikaka bitobu ba ɓɛ́ɛ oka ma munzenga mɔnɔmɔ nkombo yɛ Saolo. ");
INSERT INTO loq_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Nzuka waaɓa ɓɛ́ɛ ɓamuma maɓanga phɔ ya imoɓoma, Etiɛni amba ya ɓɔndɛlɛ ɓoɓo: «Nkolo Yesu, yamba molimo ŋwa nga!» ");
INSERT INTO loq_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ɓoɓɛlɛ, amba ya kusama na maɓɔngɔ, amba lika ŋwangye na ɓokusi yokye: «Nkolo, sakyeka isumu sa ɓɛ́ɛ sisi.» Emba na maloɓa mamana, nɔnɔ waasɛngɔ yo. ");
INSERT INTO loq_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saolo aɓaka mi ɓaanolaka oɓokye ɓaɓome Etiɛni. O mokɔlo mɛ, minyɔkɔ mikusi miayelelaka ɓato ɓa ingomba sa Yelusalɛmɛ. Manya ɓatoma, ɓato ɓasɔ ɓanyangwaka o nkyisi ya Yuda na Samaliya. ");
INSERT INTO loq_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ɓato ɓa mandondo malaa ɓamba kunda Etiɛni, ɓamba na mokyelela eyakolo ngɔndɛ. ");
INSERT INTO loq_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Kasi phɔ ya Saolo, iyo anyangolaka ingomba, anyɔlɔkɔ o mangambi ikyɛ miakya ɓaɓasi na ɓampele, kaɓavakye o bɔlɔkɔ. ");
INSERT INTO loq_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ɓato ɓasɔ ɓanyangwaka, ɓakyɛkyɛ miimola Simo Elaa o bilele bisɔ. ");
INSERT INTO loq_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Yango mɛna Filipe, owakyɛkyɛ o mokyisi munɛnɛ ŋwa Samaliya, abuto iimola simo ya Klisto omɔ. ");
INSERT INTO loq_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ɓato ɓasɔ na munɔkɔ mɔnɔmɔ ɓamiambyaka o maphɔɔ ma Filipi, phɔ ɓaokaka sango ya bilekyesako ɓaɓaka yo kakyele emba ɓabiwɛnɛkyɛ. ");
INSERT INTO loq_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Phɔ malɔɓɔ maɓe maikye maɓaka matɔkɔlɔ onte ya ɓato ɓanyɔlɛlɛkyɛ mango, malikye nyangye na ɓokusi, emba bituku biikye na ɓato ɓa bilɛmɛ ɓabikaka. ");
INSERT INTO loq_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Nkyisa nzikye yaɓaka o mokyisi mɛ. ");
INSERT INTO loq_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Nzuka moto mɔnɔmɔ aɓaka omɔ phanza na nkombo ya Simo owabaka kakyele manganga, aɓaka kakaŋwaisa ɓato ɓa Samaliya. Amikpaka moto mɔnɔmɔ oolekyi na ná ngambo, ");
INSERT INTO loq_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","emba ɓato ɓasɔ ɓamiambyaka mi yo, eɓe ngyɛɛngyɛ nɔnɔ o ɓaphomba. Ɓaɓaka ɓawɔ ɓɛkye: «Moto oyo, ali Mwiya ŋwa Ŋwaphongo, moɓangye ɓɛ́ɛ “Mwiya ŋwa sikyisa.”» ");
INSERT INTO loq_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ɓo ɓamiambyaka mi yo ɓaɓona, eli phɔ wakɔkɔkɔ elinga ɓowaɓaka mbalo yɛ kyiɓakamwisa. ");
INSERT INTO loq_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Kasi waanolela ɓɛ́ɛ Filipe owaɓaka kaɓaimole Simo Elaa ya Ɓokonzi pha Ŋwaphongo na nkombo ya Yesu Klisto, ɓazwaka ɓatisimo na ɓaɓasi na ɓampele. ");
INSERT INTO loq_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simo yo mampenza abutwaka nɛ moanosi, amba ya zwa ɓatisimo, ɓoɓɛlɛ abutwaka na Filipe nde elele yɔnɔyɔ. Simo akamwaka na boikye oikyeka mayaa maanɛnɛ na bilekyesako biaɓaka bikyelame. ");
INSERT INTO loq_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Waaoka ɓatoma ɓaaɓaka o Yelusalɛmɛ oɓokye ɓato ɓa Samaliya ɓaanosi maphɔɔ ma Ŋwaphongo, ɓamba ya toma Petelo na Yoane omɔ. ");
INSERT INTO loq_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Waakoma ɓɛ́ɛ omɔ, Petelo na Yoane ɓamba ɓɔndɛlɛ phɔ ya ɓato ɓa Samaliya oɓokye ɓazwe Ɓolɔɓɔ Ɓosantu. ");
INSERT INTO loq_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Phɔ Ɓolɔɓɔ Ɓosantu tephataaka utela nɔnɔ mɔnɔmɔ na ɓɛ, ɓataaka zwa naino nde ɓatisimo na nkombo ya Nkolo Yesu. ");
INSERT INTO loq_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ɓoɓɛlɛ, Petelo na Yoane ɓamba ya butwa iɓatandela maɓɔkɔ, emba ɓato ɓa Samaliya ɓazwaka Ɓolɔɓɔ Ɓosantu. ");
INSERT INTO loq_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Kasi Simo, waawɛnɛ yo oɓokye ɓatoma ɓaambya Ɓolɔɓɔ Ɓosantu nde na itanda maɓɔkɔ, amba ya wɔ yokye kaɓaphɛ ɓaphalanga. ");
INSERT INTO loq_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Amba wɔ na ɓɛ́ɛ yokye: «Onzakyisa na nga mwiya mamuna, phɔ ya oɓokye ɓato ɓaamotandela nga maɓɔkɔ ɓazwe Ɓolɔɓɔ Ɓosantu.» ");
INSERT INTO loq_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Kasi Petelo amba ya mobuyisa yokye: «Owee wɛ na ɓaphalanga ɓa wɛ, phɔ koumunya oɓokye okokyi iomba na ɓaphalanga, ikaɓo siambya Ŋwaphongo pha! ");
INSERT INTO loq_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Otoozwe nɔnɔ ekpele, eɓe iyalo naa ilaka mi lowɔ lolekane wawa, phɔ ndondo ya wɛ teli elaa o ɓoo pha Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ɓongola motema ŋwa wɛ olɛ maumunya ma wɛ maaɓe, oɓɔndɛlɛ Nkolo, naa akokyi ielimbisa na mango. ");
INSERT INTO loq_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Phɔ nawɛnɛ oɓokye oli na zuwa, oombi na ɓa moombo ŋwa masumu.» ");
INSERT INTO loq_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Emba Simo amba buya yokye: «Ɓɔndɛlɛ Nkolo phɔ ya nga ɓɛ̀ɛ mampenza, phɔ ya oɓokye iiwɔɔ ɓɛ̀ɛ yango sanzelela.» ");
INSERT INTO loq_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ɓoɓɛlɛ, waaunva Petelo na Yoane iimola na iwɔ maphɔɔ ma Nkolo, ɓamba ya butwa o Yelusalɛmɛ. Ɓaimolaka Simo Elaa o nkyisi nzikye yaa Samaliya. ");
INSERT INTO loq_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Mwanze wa Nkolo amba ya wɔ na Filipe yokye: «Tɛmɛ, okyɛndɛ o mbale eya ngyɛlɛ o nzela ekyeute o Yelusalɛmɛ kyekyɛndɛ o Gaza. Nzela mɛ ealangaa.» ");
INSERT INTO loq_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Emba sakɔkɔ, Filipe amba yakyɛ omɔ. Nzuka moto mɔnɔmɔ wa Etiopi owamanya ɓɛ́ɛ ɓompele, mokonzi munɛnɛ na mokambi wa ezwele esɔ ya Kandase, mokonzi owa ŋwaŋwasi wa Etiopi, akyɛkyɛ o Yelusalɛmɛ phɔ ya isambela. ");
INSERT INTO loq_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ayakaka ya butwa oka yɛ, azasi o ikalo sɛ, katangye buku pha moimosi Isaya. ");
INSERT INTO loq_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ɓolɔɓɔ amba wɔ na Filipe yokye: «Susinya okyɛ ɓenga ikalo saasina.» ");
INSERT INTO loq_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filipe amba ya kyilingana omɔ, aesi ya oka moto owamanya ɓɛ́ɛ ɓompele mɔna katangye buku pha moimosi Isaya, amba wɔ nɛ yokye: «Koeɓe ntina ya maphɔɔ matangye wɛ maamana?» ");
INSERT INTO loq_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Amba mobuyisa yokye: «Namba eba ndengye'ye, ɓo siɓe na moteye?» Emba amba ɓanga Filipe oɓokye abaa, azale phɛnɛphɛ nɛ. ");
INSERT INTO loq_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Kyeka maphɔɔ ma buku maɓaka yo katangye: Ndokolo mpate ekyekyɛ na ɓɛ́ɛ phɔ ya ikyɛ etena nkyingo, ndokolo ŋwana wa mpate akangyi munɔkɔ o ɓoo pha okoekate nkungyɛ, nde ɓomɔ taingole munɔkɔ. ");
INSERT INTO loq_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Na imiuya sɛ, teɓaikaka motenela phakolo ɓolombe. Owamoimola mankɔkɔ mɛ nza? Phɔ ɓamanye ɓomɔɔ pha o mokyisi. ");
INSERT INTO loq_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Moto owamanyaka ɓɛ́ɛ ɓompele, amba wɔ na Filipe yokye: «Naeɓɔndi, onzimole, moimosi kawɔ ɓaɓona phɔ ya nza? Phɔ yɛ mampenza ndee phɔ ya mto mosuu?» ");
INSERT INTO loq_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ɓoɓɛlɛ, Filipe amba ya ingola munɔkɔ, utama na yaakoma ɓɛ, amba moimola Simo Elaa ya Yesu. ");
INSERT INTO loq_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Waaɓa ɓɛ́ɛ ɓakyɛ. Ɓamba kyɛ koma o elele yɔnɔyɔ ya maa, emba moto owamanya ɓɛ́ɛ ɓompele yokye: «Kyeka maa, kyekatele iye oɓokye nazwe ɓatisimo?»  ");
INSERT INTO loq_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filipe amba ya wɔ nɛ yo kye: «Bo koanole na ndondo ya wɛ esɔ, okokyi iɓatisama.» Amba ya buya yo kye: «Naanole oɓokye Yesu Klisto ali Ŋwana wa Ŋwaphongo.» ");
INSERT INTO loq_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Amba ya wɔ nɛ oɓokye atɛya ikalo sɛ, Filipe na moto owa manya ɓɛ́ɛ ɓompele ɓaamba ya uta o maa, emba Filipe amba ya moɓatisa. ");
INSERT INTO loq_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Waaɓwa ɓɛ́ɛ o maa, Ɓolɔɓɔ pha Nkolo phaamba ya manya Filipe, emba moto owa manya ɓɛ́ɛ ɓompele takulaka mowɛnɛ, kasi amba kyɛ nde nzela yɛ na nkyisa. ");
INSERT INTO loq_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Kasi phɔ ya Filipe, amba kyɛ wɛnɛnɛ o Azɔtɛ, aimolaka Simo Elaa o nkyisi isɔ yaalekanaka yo nɔnɔ wakoma yo o Sezare. ");
INSERT INTO loq_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saolo aɓaka na maumunya nde ma ikanela na iɓoma ɓaekosi ɓa Nkolo, amba kyɛndɛ ");
INSERT INTO loq_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","tuna nganga o munɛnɛ nkanda phɔ ya mangambi ma makyita ma Damaseke. Ɓo akyɛ zwa omɔ ɓato ɓaaɓengye nzela mɛ, eɓe ɓaɓasi eɓe ɓampele aɓakangye maphanga, aye na ɓɛ́ɛ o Yelusalɛmɛ. ");
INSERT INTO loq_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Waaɓa yo kakyɛ nzela yɛ, wakoma yo phɛnɛphɛ na Damaseke, mbala yɔnɔyɔ, mwenya mouti o ikolo, moesi ya mozinga na sina ilola. ");
INSERT INTO loq_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Aesi ya kaa o se, amba ya oka ŋwɛsi mɔnɔmɔ mowɔ nɛ oɓokye: «Saolo, Saolo, phɔ ya'ye konyɔkɔlɔ?» ");
INSERT INTO loq_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Amba ya tuna yokye: «Iwɛ nza, Nkolo? Nali Yesu, eli nga okonyɔkɔlɔ wɛ. ");
INSERT INTO loq_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Kasi tɛmɛ, nyɔlɔ o mokyisi muunɛnɛ, emba ɓamoewɔlɛ losengyesi wɛ ikyela.» ");
INSERT INTO loq_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ɓɛbi nɛ ɓa imbanga, ɓatɛmɛkyɛ, sawɔ na ɓɔɔɓɔ: Ɓaokaka ŋwɛsi, kasi teɓaiaka wɛnɛ moto. ");
INSERT INTO loq_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saolo amba ya tɛmɛ, kasi na ɓo waɓa yo na miyo makyekye, takulaka wɛnɛ na ekpele, ɓɛbi nɛ ɓamba mophlila mi eɓɔkɔ phɔ ya imonyɔsa o Damaseke. ");
INSERT INTO loq_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Akyɛkyela omɔ nkɔlɔ iyaato sawɛnɛ, saza na ekpele na sanywa. ");
INSERT INTO loq_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Moekosi mɔnɔmɔ na nkombo ya Ananiya aɓaka o Damaseke. Nkolo amba moɓanga o ndɔtɔ yokye: «Ananiya!» Ananiya amba mobuyisa yokye: «Nga oyo, Nkolo!» ");
INSERT INTO loq_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Nkolo amba kula wɔ yokye: «Wamokyɛndɛ o ngɔ ekyeɓangye ɓɛ́ɛ ngɔ eya Tɛmɛ yɔɔ, otune o ingambi sa Yuda, moto okoɓangye ɓɛ́ɛ Saolo wa Talase, ali o mɔ kaɓɔndɛlɛ. ");
INSERT INTO loq_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Auti iwɛnɛ moto mɔnɔmɔ na kombo ya Ananiya anyɔsi, amotandesi maɓokɔ phɔ ya oɓokye abutwe ikula wɛnɛ.» ");
INSERT INTO loq_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananiya amba buya yokye: «Nkolo, naokye ɓato ɓaikye ɓawɔ phɔ ya moto mɔna na phɔ ya ɓoɓe ɓolukye yo ikyela ɓaanosi o Yelusalɛmɛ. ");
INSERT INTO loq_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Emba wawa ali na ɓokonzi ɓosɔ ɓoomophɛ ɓanganga ɓanɛnɛ phɔ ya ikanga maphanga ɓato ɓasɔ ɓatangye nkombo ya wɛ.» ");
INSERT INTO loq_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Kasi Nkolo amba wɔ nɛ yokye: «Kyɛndɛ, phɔ moto mɛ ali ekyelele ya etoma eɔsi nga phɔ ya iteya na nkombo ya nga o nkyisi ya ɓato ɓate ɓaeɓe Ŋwaphongo, oka ɓakonzi na ɓato ɓa Isalayɛlɛ. ");
INSERT INTO loq_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Phɔ naamoteya nga mampenza ɓolɔsi ɓosɔ phaamooka yo phɔ ya nkombo ya nga.» ");
INSERT INTO loq_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ɓoɓɛlɛ, Ananiya amba ya kyɛndɛ, aesi yakyɛ nyɔlɔ o ingambi mɛ, amotandesi maɓɔkɔ yokye: «Saolo, nwɛbi na nga, eli Nkolo ookontome — Yesu mɛ owaetɔkɔlɛlɛkyɛ o nzela eya ɓaka wɛ koye — phɔ ya oɓokye okule butwa iwɛnɛ na oɓokye otonde na Ɓolɔɓɔ Ɓosantu.» ");
INSERT INTO loq_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Mina wamɔ, bikɔɔ ndokolo bikyɛtɛ bimotɔkɔsi o miyo. Boɓɛlɛ, abuto iwɛnɛ nɔnɔ waazwa yo ɓatisimo. ");
INSERT INTO loq_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ɓoɓɛlɛ waza yo, amba kula ya zwa ɓokusi. Amba ya kyela ɓanaa nkɔlɔ na ɓaekosi ɓaɓaka o Damaseke. ");
INSERT INTO loq_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Sa kɔkɔ, abuto ikyɛmimola o mangambi ma makyita oɓokye Yesu ali Ŋwana wa Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ɓato ɓasɔ ɓaaɓaka ɓamookye ɓakamwaka, ɓɛkye: «Eye teli yo owaɓaka kanyɔkɔlɔ ɓato ɓaɓaka ɓatangye nkombo ya Yesu o Yelusalɛmɛ? Emba tayakaka wawa na nkoo phɔ ya iya ɓaakya maphanga phɔ akyɛ na ɓɛ́ɛ oka ɓanganga ɓanɛnɛ?» ");
INSERT INTO loq_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Kasi Saolo anolaka na ɓokusi nkɔlɔ isɔ oɓokye Yesu ali nde owaakolo Masiya. Na waɓa yo kateya ɓaɓona, Ɓayuda ɓaɓaka o Damaseke teɓakulaka zwaka na lowɔ la imobuyisa. ");
INSERT INTO loq_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Sima ya nkɔlɔ, Ɓayuda ɓamba ya okana oɓokye ɓamoɓome. ");
INSERT INTO loq_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Saolo amba ya eɓa ŋwango ŋwa ɓɛ. Na moo na mokɔlɔ, ɓaɓaka ɓakyɛngyɛlɛ biɓonga ɓa mokyisi ŋwa ɓɛ́ɛ phɔ ya imoɓoma. ");
INSERT INTO loq_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Kasi mokɔlɔ mɔnɔmɔ, ɓaekosi ɓɛ́ɛ ɓamba moloya, ɓamokyesi mieluɓa, ɓamba mouya o mbale eyɔkɔ ya ekuka eya zinga mokyisi. ");
INSERT INTO loq_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Waakoma yo o Yelusalɛmɛ, Saolo alukaka oɓokye aangane na ɓaekosi ɓaayɔkɔ, kasi ɓasɔ ɓaɓaka na ɓɔɔɓɔ nɛ, teɓaikaka anola oɓokye abutoo moekosi wa Yesu phɛlɛ. ");
INSERT INTO loq_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Emba Ɓarnabas amba mokpa, amba ya munyɔsa oka ɓatoma, amba na ɓaimola ndengye eya wɛnɛkyɛ yo Nkolo owa mowɔlɛkyɛ o nzela, na ndengye eyateyaka yo Simo Elaa na nkombo ya Yesu o Damaseke. ");
INSERT INTO loq_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Tata wamɔ, Saolo abutwaka na ɓatoma elele yɔnɔyɔ o Yelusalɛmɛ, kaimole Simo Elaa na nkombo ya Nkolo na ianola sisɔ. ");
INSERT INTO loq_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Aɓa kawɔnɔ na Ɓayada ɓaamunɔkɔ ŋwa ɓaela, kaikye miko na ɓɛ. Kasi ɓɛ́ɛ ɓalukaka nde imoɓoma. ");
INSERT INTO loq_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Waloooka ɓɛbi, ɓamba kyɛndɛ nɛ o Sezare. Emba omɔ, ɓamba molekyinya o Tarse. ");
INSERT INTO loq_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Emba ingomba saaɓaka o mokyisi ŋwa Yuda munsɔ, ŋwa Galileya na ŋwa Samaliya ɓaɓaka ɓose. Bamilenzaka, ɓatambulaka na ɓoilakye Nkolo, na nzela ya Ɓolɔɓɔ Ɓosantu, ɓabutwaka ɓaikye. ");
INSERT INTO loq_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Petelo aɓaka kakyɛmikyɛ mi ina nkyisi ɓoɓɛlɛ ɓoɓɛlɛ. Mokɔlɔ mɔnɔmɔ amba ya kyɛndɛ oka ɓaanosi ɓaɓaka o mokyisi na nkombo ya Lidɛ. ");
INSERT INTO loq_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Amba ya kyɛ zwa omɔ moto mɔnɔmɔ na nkombo ya Ene, alangyi mi ntangye mbula ŋwambi, phɔ aɓaka etuku. ");
INSERT INTO loq_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Petelo amba ya wo nɛ yokye: «Ene, Yesu Klisto aebikye. Langwa, oɓɔngya ntangye ya wɛ, wɛ mampenza!» Sa kɔkɔ, aesi ya langwa. ");
INSERT INTO loq_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Waamowɛnɛ ɓato, ɓato ɓasɔ ɓa Lidɛ na ɓa mambale ma Salona ɓaanolaka Nkolo. ");
INSERT INTO loq_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ŋwaŋwasi mɔnɔmɔ aɓaka o Yafo, aɓaka moekosi. Nkombo yɛ yaɓaka Tabita, na munɔkɔ ŋwa ɓaela «Doloka», kyelimbole oɓokye Munkyete. Aɓaka na bitoma bilaa biikye na mosungyi wa ɓato ɓaakaya. ");
INSERT INTO loq_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Nzuka mi nkɔlɔ mɛ, aesi ya zwa ɓolɔsi, aesi ya waa. Wa unva ɓɛ́ɛ imokunyola, ɓaesi yakyɛ molangya o etee ya ingambi eya ikolo. ");
INSERT INTO loq_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Oli Lidɛ phɛnɛphɛ na Yafo, ɓaekosi ɓaokaka oɓokye Petelo aɓaka omɔ. Emba ɓamba motomela ɓato ɓaɓale phɔ ya ikyɛ moɓanga oɓokye: «Yaloɓengye mizele.» ");
INSERT INTO loq_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Petelo amba yakyɛ na ɓɛ́ɛ mizele. Waakoma yo, ɓaesi ya mobaya o etee ya ingambi eya ikolo, emba mazengye masɔ maɓaka matɛmi o ɓoo phɛ malele, mamoteya nkoto na bitobu baɓaka Doloka kakyele wataaka ɓaa yo na ɓɛ. ");
INSERT INTO loq_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Petelo amba ya tɔkɔlɔ ɓato ɓasɔ, amba ya kusama na maɓɔngɔ, amba ɓɔndɛlɛ. Ɓoɓɛlɛ amba ya miekola bili ndemba, amba wɔ yokye: «Tabita, langwa!» Amba ya ziɓola miyo, wa wɛnɛ yo Petelo, amba ya mielola, amba ya zala. ");
INSERT INTO loq_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Petelo amba ya mophɛ eɓɔkɔ, amotɛyɛ, amba kula ya ɓanga ɓaanosi na mazengye, aesi ya ɓateya yo mumɔɔ. ");
INSERT INTO loq_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Mokyisi ŋwa Yafo moɓimba ŋwa okaka lowɔ mɛ, emba ɓato ɓaikye ɓamba anola Nkolo. ");
INSERT INTO loq_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Petelo amba kɔkɔ na ŋwana ɓoikye o Yafo, oka moto mɔnɔmɔ na nkombo ya Simo owa ɓaka mokyesi ŋwa etoma na mangoɓo ma manyama. ");
INSERT INTO loq_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","O mokyisi ŋwa Sezare, moto mɔnɔmɔ aɓaka omɔ nkombo yɛ Kɔlɔnɛlɛ, aɓaka mokonzi ŋwa batayɔ ya ɓatuluku ɓa Loma, ekyeɓangye ɓɛ: «Batayɔ ya Itali». ");
INSERT INTO loq_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Moto mɛ aɓaka moto molaa. Yo na iɓota sɛ sisɔ ɓaɓaka ɓakumole Ŋwaphongo. Aɓaka kalɔɓɔ sunga Ɓayuda ɓaakaya, na iɓɔndɛlɛ Ŋwaphongo ntango isɔ. ");
INSERT INTO loq_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Mokɔlɔ mɔnɔmɔ, imbɛlɛ sa nkɔkɔlɔ, aesi ya wɛnɛ, nde ya nzanga, o ndɔtɔ, mwanze mɔnɔmɔ wa Ŋwaphongo kanyɔlɔ oka yɛ kamoɓangye yokye: «Kɔlɔnɛlɛ!» ");
INSERT INTO loq_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kɔlɔnɛlɛ aesi ya molembetela, na ɓɔɔɓɔ, aesi yaanola yokye: «Nkolo, lowɔ iye? Ŋwaphongo asepesi na maɓɔndɛsi ma wɛ na ɓolaa ɓookyele wɛ oka ɓaɓola, emba taambi ebunga. ");
INSERT INTO loq_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Emba uŋwaŋwa eye, toma ɓato o Yafo phɔ ɓaye na moto mɔnɔmɔ na nkombo Simo, owa kula ɓɛ́ɛ phɛ nkombo ya Petelo. ");
INSERT INTO loq_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ali mobutu wa Simo mosuu, okokyele etoma ya mangoɓo ma manyama, okozale o ingambi sili o mokukulu ŋwa ebale eenɛnɛ.» ");
INSERT INTO loq_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Waalɛmɔ anzelu owautaka imowɔlɛ, Kɔlɔnɛlɛ amba ya ɓanga ɓato ɓaɓale ɓa ingambi sɛ na tuluku mɔnɔmɔ okoɓɔndɛlɛ na okokumole Ŋwaphongo, uta kalakala o se ya miɓeko mɛ. ");
INSERT INTO loq_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Amba ya ɓaimola isɔ ya moimolaka ɓɛ, amba ya ɓatoma o Yafo. ");
INSERT INTO loq_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ɓo yana, mɛna ɓato mɛ ɓatakaɓa o nzela, ɓaesi ya koma phɛnɛphɛ na mokyisi, Petelo aesi ya baa o motɔndɔ ŋwa ingambi ŋwaalangyema phɔ ya iɓɔndɛlɛ. Yaɓaka phɛnɛphɛ na bunya i moto. ");
INSERT INTO loq_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Kasi aesi ya oka nzala, emba alukaka iza. Waɓa ɓɛ́ɛ ɓamolambele ya izaa. Aesi ya lɔtɔ ndɔtɔ. ");
INSERT INTO loq_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Awɛni ikolo siziɓo, ekɔ yɔnɔyɔ ndokolo imputa sinɛnɛ, ɓasiphisi o matuu masɔ mane, siute o se. ");
INSERT INTO loq_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Emba onte ya sango, yaɓaka manyama masɔ ma makolo mane na malande na ibu, na manyɔsi ndengye na ndengye. ");
INSERT INTO loq_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ŋwɛsi mɔnɔmɔ moesi ya mowɔlɛ oɓokye: «Tɛmɛ, Petelo! Ɓoma ozee.» ");
INSERT INTO loq_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Petelo amba ya buya yokye: «Phe, Nkolo! Phɔ o ɓomɔɔ pha nga, naino size ntoma ya ekyila na ya sɔkɔtɔ.» ");
INSERT INTO loq_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Amba kula oka ŋwɛsi mɔnɔmɔ mowɔ nɛ, phɔ ya mbala eya iɓale oɓokye: «Ekpele ebuye Ŋwaphongo elaa, iwɛ tokokyi iwɔ oɓokye eli sɔkɔtɔ!» ");
INSERT INTO loq_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Lowɔ mɛ lakyelama mbala iyato, emba ekɔ mɛ nɔnɔ waabutwa yango o ikolo. ");
INSERT INTO loq_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Petelo ameka imilimbolela yo mampenza ntina ya ndɔtɔ euti yo ilɔtɔ, sakoka, nde imbɛlɛ mɛ, ɓatima ɓa Kɔlɔnɛlɛ ɓaɓaka ɓakyɛmituna mboka esɔ wali ingambi sa Simo, ɓaesi ya koma o munɔkɔ ŋwa lopango. ");
INSERT INTO loq_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ɓamba butwa ɓaɓangye na ɓambe na tuna ɓɛkye: «Simo Petelo kazale wawa?» ");
INSERT INTO loq_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Petelo aɓaka kataumunya nde ndɔtɔ yɛ, kasi Ɓolɔɓɔ amba wɔ nɛ yokye: «Kyeka, ɓato ɓaɓale ɓaelukye. ");
INSERT INTO loq_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Uta uwaŋwa eye, kyɛndɛ na ɓɛ́ɛ molɔngɔ, samakamaka, phɔ eli nga moto oɓatomi.» ");
INSERT INTO loq_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ɓoɓɛlɛ, Petelo amba ya uta ikyɛɓenga ɓato mɛ. Amba ya wɔ na ɓɛ́ɛ yokye: «Nga oyo. Eli nga moto okolukye ɓɛ̀ɛ. Oesi ya nkyeka phɔ ya'ye?» ");
INSERT INTO loq_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ɓamba mobuyisa ɓɛkye: «Eli mokonzi ŋwa ɓatuluku, Kɔlɔnɛlɛ, moto mɔnɔmɔ wa ɓosembo, okoile Ŋwaphongo, oli na ná moɓesi molaa onte ya Ɓayuda ɓasɔ. Mwanze wa Ŋwaphongo amowɛninya oɓokye asengyesi ikyela oɓokye okyɛndɛ o ingambi sɛ phɔ aokye maphɔɔ ma wɛ.» ");
INSERT INTO loq_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Petelo amba ya ɓanyɔsa, amba ya ɓayamba. Ɓo yana, amba ya kyɛ na ɓɛ́ɛ molɔngɔ na ɓɛbi ɓaayɔkɔ ɓa Yafo. ");
INSERT INTO loq_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Bunya pha sima, amba ya koma o Sezare. Kɔlɔnɛlɛ, o mbale yɛ, waɓa yo kaɓaziya, aɓangaka ɓanaa nyango, na ɓɛbi nɛ ɓalɔɓɔ zingana na nɛ. ");
INSERT INTO loq_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Imbɛlɛ saa koma Petelo, Kɔlɔnɛlɛ amba kyɛ vana nɛ, emba amba mivaka o makolo mɛ phɔ ya imokumbela. ");
INSERT INTO loq_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Petelo amba ya wɔ nɛ yokye: «Iŋwa, phɔ na nga nali nde moto ɓoli wɛ». Ɓoɓɛlɛ amba ya mophila phɔ ya imunola. ");
INSERT INTO loq_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Emba, bibi kawɔnɔ nɛ, amba nyɔlɔ. Wakyɛ wɛnɛ yo moluku ŋwa ɓato, ");
INSERT INTO loq_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","amba ya wɔ yokye: «Ɓo koeɓe ɓɛ̀ɛ, eli ekyila phɔ ya Moyuda angana elele yɔnɔyɔ naa ikumana na mobutu. Kasi oka nga, Ŋwaphongo kaute insɔsɔlisa oɓokye tewasengyesi iwɔ oɓɔkye moto oyɔkɔ ali na sɔkɔtɔ naa tali wa iɓa nɛ elele yonɔyɔ. ");
INSERT INTO loq_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Yango mɛna naesi saika ziko wambangyi wɛ. Kasi uŋwaŋwa eye, nazingyi iyeɓa ntina embangyi na wɛ.» ");
INSERT INTO loq_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kɔlɔnɛlɛ amba ya buya yokye: «Lɔlɔ wakokyi nkɔlɔ iyato, o ngonga eya iyato eya nkɔkɔlɔ, naɓaka naɓɔndɛlɛ o ingambi sa nga. Mbala yɔnɔyɔ, moto mɔnɔmɔ alati bitobu bilaa aesi ya tɛmɛ o ɓoo pha nga ");
INSERT INTO loq_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","kawɔ na nga yokye: “Kɔlɔnɛlɛ, iɓɔndɛsi sa wɛ ɓasianosi, na ɓolaa ɓokyele wɛ ɓato, Ŋwaphongo kaɓoumunya. ");
INSERT INTO loq_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Emba toma moto mɔnɔmɔ o Yafo phɔ ya ikyɛ ɓanga Simo, owaphɛ ɓɛ́ɛ nkombo ya Petelo, aye wawa. Ali mobutu o ingambi sa Simo okokyele etoma ya mangoɓo ma manyama, ingambi sɛ sili o mokukulu ŋwa ebale eenɛnɛ.” ");
INSERT INTO loq_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Nde o sina imbɛlɛ, naesi ya toma ɓakyɛ eluka. Emba oɓee na ɓanga na lozingo phɔ ya iyaloɓenga. Uŋwaŋwa eye, kyeka ɓanga ɓasɔ o ɓoo pha wɛ phɔ ya iyoka isɔ ietomi na Nkolo iya loimola.» ");
INSERT INTO loq_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ɓoɓɛlɛ, Petelo amba ya ingola munɔkɔ yokye: «Nde phɛlɛ, nawɛni oɓokye Ŋwaphongo tali mbale nde na moto monɔmɔ. ");
INSERT INTO loq_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Emba na o maɓota masɔ, moto munsɔ okomwile na okokyele ɓosembo, Ŋwaphongo kamoanole. ");
INSERT INTO loq_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Simo yɛ, aetomela ɓato ɓa Isalayɛlɛ: Simo Elaa na ɓose, na nzela ya Yesu Klisto, iyo oli Nkolo ya ɓato ɓasɔ. ");
INSERT INTO loq_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ɓɛ̀ɛ koloeɓe. Lowɔ laokana o Yuda mobimba, lauta o Galileya, sima ya batisimo eyateyaka Yoane. ");
INSERT INTO loq_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Yesu mɛ owa ɓotama o Nazalɛtɛ, ɓɛ̀ɛ koeɓe ndengye eya mophɛ Ŋwaphongo Ɓolɔɓɔ na mwiya. Atambulaka mboka esɔ ikyɛmikyela ɓolaa, kakyɛmibikya ɓato ɓasɔ ɓabutwaka ɓaombo ɓa Zabulu, phɔ Ŋwaphongo aɓaka nɛ. ");
INSERT INTO loq_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Emba ɓanga toli manzoka ma etoma yɛ esɔ o mokyisi ŋwa Ɓayuda na o Yelusalɛmɛ. Yo owa ɓoma ɓɛ́ɛ na imoɓaka o ekulusu, ");
INSERT INTO loq_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ŋwaphongo amoakola mokɔlɔ ŋwa iyato, emba amophɛ oɓokye amiwɛninya, ");
INSERT INTO loq_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","na ɓato ɓasɔ phe, kasi na manzoka matanga Ŋwaphongo phanza, na ɓanga ɓazaka na ɓanywaka nɛ sima ya ikundwa sɛ onte ya ɓawe. ");
INSERT INTO loq_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","O suka, amba lotoma ikyɛmiimola ɓato na iɓayelela simo oɓokye: Eli yo owa ɔlɔ Ŋwaphongo ndokolo munanga ŋwa ɓato ɓali na ɓomɔɔ na ɓaawa. ");
INSERT INTO loq_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Nde phɔ yɛ, ɓaimosi ɓasɔ ɓawɔ ɓoɓo: Ilimbisa sa masumu saphɛmɛ na nzela ya Nkombo yɛ oka moto musɔ okomoanole.» ");
INSERT INTO loq_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Petelo ataka ɓa naino kaimole maphɔɔ, Ɓolɔɓɔ Ɓosantu ɓoesi yauta mi ɓato ɓasɔ ɓaɓaka ɓaokye Iloɓa. ");
INSERT INTO loq_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Yaɓaka ɓɔɔɓɔ onte ya ɓaanosi ɓaɓɛlɛ, ɓakyɛkyɛ na Petelo. Yango mɛna, uŋwaŋwa eye, nɔnɔ o maɓota ma ɓato ɓate ɓali Ɓayuda, ikaɓo sa Ɓolɔɓɔ Ɓosantu sa nyangwaka! ");
INSERT INTO loq_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Phɔ ɓaokaka ɓato mɛ ɓawɔ na nɔkɔ ya ɓɛ, ɓakumbele ɓonɛnɛ pha Ŋwaphongo. Petelo amba kula ya wɔ yokye: ");
INSERT INTO loq_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","«Moto akokyi ikatela iɓatisa ɓato ɓaɓa na maa, phɔ na ɓɛ́ɛ ɓazwe Ɓolɔɓɔ Ɓosantu ndokolo ɓanga?» ");
INSERT INTO loq_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Amba ya ambya moɓeko ŋwa iɓaɓatisa na nkombo ya Yesu Klisto. Ɓoɓɛlɛ, ɓamba ya moonga oɓokye akule ɓa na ɓɛ́ɛ ɓanaa nkɔlɔ. ");
INSERT INTO loq_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ɓatoma na ɓɛbi ɓaaɓaka o Yuda ɓaokaka ɓawɔ oɓokye nkyisi ya ɓato ɓate ɓali Ɓayuda, ɓaanosi iloɓa sa Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Waya butwa Petelo o Yelusalɛmɛ, ɓaaɓɛlɛ ɓɛ́ɛ ɓamba ya ika ziko nɛ. ");
INSERT INTO loq_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Ɓɛkye: «Okyɛ nyɔlɔ o ingambi sa ɓato ɓate ɓaika ɓɛlɛ ɓɛ, ozee na ɓɛ́ɛ elele yɔnoyɔ!» ");
INSERT INTO loq_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ɓoɓɛlɛ, Petelo amba kula ya tata simo mɛ tata o etatele, amba ya ɓawɔlɛ lowɔ lɔnɔlɔ na lɔnɔlɔ, yokye: ");
INSERT INTO loq_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«Naɓaka o mokyisi ŋwa Yafo naɓɔndɛlɛ. Naesi ya wɛnɛ o ndɔtɔ ekpele yɔnɔyɔ ndokolo imputa sinɛnɛ, ɓasiphisi o matuu mane, siute o ikolo nɔnɔ waya sango wali nga. ");
INSERT INTO loq_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Walembetela nga o imputa mɛ, naeai yawɛnɛ manyama ma makolo mane ma mokyisi, manyama ma mangonda, maalande na ibu na manyɔsi ma ikolo. ");
INSERT INTO loq_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Naesi ya oka na ŋwɛsi mɔnɔmɔ mowɔ na nga oɓokye: “Petelo, iŋwa, ɓoma ozee!” ");
INSERT INTO loq_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Naesi ya wɔ ngakye: “Phe, Nkolo! Phɔ bikpele bia ekyila na bia sɔkɔtɔ naino tebinyɔsi o munɔkɔ ŋwa nga.” ");
INSERT INTO loq_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Mbala eya iɓale, ŋwɛsi ŋwamba kula uta o ikolo ŋwamba buya oɓokye: “Iɓɔngyɛ Ŋwaphongo, wɛ tokokyi ikpa ndokolo ili ya sɔkɔtɔ.” ");
INSERT INTO loq_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Lowɔ mɛ lalekanaka mbala iyato, emba isɔ yamba kula butwa o ikolo. ");
INSERT INTO loq_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Emba sakɔkɔ, iwɛnɛkyɛ ɓampele ɓaato ɓantomelaka ɓɛ, ɓautaka Sezare, ɓaesi ya koma o ingambi saaɓaka ɓanga. ");
INSERT INTO loq_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ɓolɔɓɔ Ɓosantu aesi ya wɔ na nga oɓokye nga sa makamaka, nakyɛ na ɓɛ́ɛ molɔngɔ. Nakyɛ na ná ɓɛbi motoɓa ɓakyɛ nzika. Ɓanga ɓaso tomba ya kyɛ nyɔlɔ o ingambi sa moto mɛ. ");
INSERT INTO loq_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Moto mɛ amba ya loimola ɓo wawɛnɛkyɛ yo anzelu o ingambi sɛ atɛmi kawɔ nɛ obokye: “Toma ɓato o Yafo, ɓakyɛ ɓanga Simo, owa kula ɓɛ́ɛ phɛ nkombo ya Petelo, ");
INSERT INTO loq_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","owa moewɔlɛ maphɔɔ mamoebikya iwɛ na ingambi sa wɛ sisɔ.” ");
INSERT INTO loq_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Watata nga iwɔ, Ɓolɔɓɔ Ɓosantu ɓoesi ya ɓautela nde ɓo waloutelaka phango o etatele. ");
INSERT INTO loq_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Namba ya umunya maphɔɔ ma Nkolo wawɔkɔ yo oɓokye: “Yoane aɓatisaka na maa, kasi ɓɛ̀ɛ wamoɓatisama na Ɓolɔɓɔ Ɓosantu.” ");
INSERT INTO loq_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ɓo ikaɓo mɛ siphɛmi oka ɓɛ, Ŋwaphongo asiphɛ na ɓanga phɔ toanola Yesu Klisto. Emba nga nali nza phɔ ya ikatela Ŋwaphongo ikyela.» ");
INSERT INTO loq_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Waoka ɓɛ́ɛ maphɔɔ mamana, ɓamba ya ikala ɓose, ɓabuto ikumbela Ŋwaphongo, ɓɛkye: «Kyeka oɓokye Ŋwaphongo aphɛ na nkyisi iteili ya Ɓayuda oɓokye iɓongole mandondo pho ya izwa ɓomɔɔ.» ");
INSERT INTO loq_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ɓato ɓanyangwaka phɔ ngɔngɔ eyautaka phɔ Etiyɛni, ɓakyɛkyɛ nɔnɔ o Fenisi na o Shiprɛ na o Antioshe. Kasi teɓaikaka teya nɔnɔ moto mɔnɔmɔ iloɓa ɓo teyaɓaka nde Ɓayuda. ");
INSERT INTO loq_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Nzuka ɓana onte ya ɓɛ́ɛ ɓaɓaka ɓato ɓa Shiprɛ, na ɓa Sirɛnɛ, ɓautaka o Antioshe, ɓaɓaka ɓateya na ɓɛ́ɛ oka Ɓaela, ɓaimole Simo Elaa ya Nkolo Yesu. ");
INSERT INTO loq_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Eɓɔkɔ ya Nkolo ya ɓaka na ɓɛ, emba motiya ŋwa ɓato ɓaanolaka Nkolo ŋwa butwaka moikye. ");
INSERT INTO loq_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Simo ya lowɔ mɛ yamba koma o matoo ma ɓaanosi ɓa ingomba saɓaka o Yelusalɛmɛ, emba ɓamba ya toma Ɓalaɓa o Antioshe. ");
INSERT INTO loq_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Wakyɛ wɛnɛ yo omɔ ngɔlu ya Ŋwaphongo kyekyele etoma, aɓaka na nkyisa, emba amba ɓalenza ɓɛ́ɛ ɓasɔ phɔ ɓaikale ikyelela Nkolo na ndondo yɔnɔyɔ. ");
INSERT INTO loq_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Phɔ yo aɓaka moto molaa na owa tonda na Ɓolɔɓɔ Ɓosantu na ná ianola. Emba moluku ŋwa ɓato mwikye ŋwamba ya miambya oka Nkolo. ");
INSERT INTO loq_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ɓoɓɛlɛ, amba yakyɛndɛ o Tarsis phɔ ya ikyɛ luka Saolo. ");
INSERT INTO loq_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Wakyɛ yo mozwa, amba yakyɛ nɛ o Antioshe. Ɓamba kyela omɔ mbula mobimba ikyela etoma elele yɔnɔyɔ na ɓato ɓa ingomba. Ɓateyaka ɓato ɓaikye sɔmɔ. Emba yaɓaka o Antioshe, waatataka ɓɛ́ɛ iɓanga ɓaekosi na nkomgo ya ɓaklisto phɔ ya mbala eya yambo. ");
INSERT INTO loq_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Mi nkɔlɔ mɛ, ɓaimosi ɓamba ya uta o Yelusalɛmɛ, ɓakyɛ o Antioshe. ");
INSERT INTO loq_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Mɔnɔmɔ na ɓɛ, na nkombo ya Agabusu, amba ya tɛmɛ, amba ya imola na mwiya ŋwa Ɓolɔɓɔ Ɓosantu oɓokye zilo sikusi samokyinda mokyisi mobimba. Yakyelamaka imbɛlɛ saaɓaka Kolode mokonzi. ");
INSERT INTO loq_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ɓoɓɛlɛ ɓaekosi ɓamba yakpa meko oɓokye ɓamotaa mɔnɔmɔ na mɔnɔmɔ kokokana na ɓozwakye phɛ, ɓatome phɔ ya isunga ɓɛbi ɓazale o Yuda. ");
INSERT INTO loq_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ɓamba kyela nde ɓomɔ. Ɓamba tomela ɓankumu nsindo yazwaka ɓɛ́ɛ na Ɓalaɓa na Saolo. ");
INSERT INTO loq_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Imbɛlɛ mɛ sasina, mokonzi Elode abutwaka inyɔkɔlɔ ɓato ɓayɔkɔ ɓa ingomba. ");
INSERT INTO loq_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Amba ya ɓoma Zake, ŋwana nyango na Yoane na mumphata. ");
INSERT INTO loq_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Wawɛnɛ yo oɓokye Ɓayuda ɓakumbe na yakyelaka yo, amba kula akya Petelo. (Yaɓaka i nkɔlɔ ya esɛlɛkɔ ya mapa matumbe ɓɛ́ɛ sa munɔ moulole mapa.) ");
INSERT INTO loq_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Wamoɓanga ɓɛ, amba munyɔsa o bɔlɔkɔ, amombye o maɓokɔ ma biɓoko bine ɓa ɓatuluku, eɓoko ya ɓane ɓane phɔ ya imokyɛngyɛlɛ. Ɓazingaka ikyɛ moambinya o ɓoo pha ɓato o sima ya esɛlɛkɔ ya Ilekana. ");
INSERT INTO loq_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Yo Petelo mɔna, aɓaka o bɔlɔkɔ, kasi iɓɔndɛlɛ sikusi sa ingomba saɓaka oka Ŋwaphongo imɓɛlɛ sisɔ phɔ yɛ. ");
INSERT INTO loq_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Waaluka Elode iyambinya Petelo, na mokɔlɔ mɛ, Petelo alalaka onte ya ɓatuluku ɓaɓale, ɓamokangyi na nyɔlɔlɔ iɓale, na ɓakyɛngyɛsi ɓaɓaka ɓatɛmi o moziɓo. ");
INSERT INTO loq_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Emba kyeka anzelu wa Nkolo aesi ya tɔkolɔ na mwenya mobuto ingyɛngyɛ wamɔ. Aesi ya wanda moɓanzi ŋwa Petelo, aesi ya moumola yokye: «Langwa izele!» Ɓoɓɛlɛ, nyɔlɔlɔ yeesi ya mana o maɓɔkɔ mɛ. ");
INSERT INTO loq_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Mwanze amba ya wɔ nɛ yokye: «Kanga kamba ya wɛ, lata bikoto ba wɛ.» Amba kyela ɓomɔ. Amba kula wɔ nɛ yokye: «Lata munkoto ŋwa wɛ, ombengye.» ");
INSERT INTO loq_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Petelo aesi ya tɔkɔlɔ, abuto imoɓenga, saeɓa oɓokye ikyilekane nɛ na anzelu ili ya phɛlɛ: Awɛnɛkyɛ ndokolo kalɔtɔ nde ndɔtɔ. ");
INSERT INTO loq_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Walekana yo iɓala sa etatele na sa iɓale, ɓamba ya koma o moziɓo ŋwa ebuni munyɔlɔ na ɓɛ́ɛ o mokyisi munɛnɛ. Ekomba ya moziɓo mɛ yaingwaka nde yango mampenza. Ɓɛ́ɛ ɓamba ya tɔkɔlɔ nɔnɔ waɓenga ɓɛ́ɛ ngɔɔ yɔnɔyɔ, ɓoɓɛlɛ mina wamɔ, anzelu aesi ya moika. ");
INSERT INTO loq_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Emba Petelo amba ya mieɓa, amba wɔ yokye: «Unaŋwa eye, naeɓi phɛlɛ oɓokye Nkolo atomi anzelu wɛ phɔ ya iyamanya o maɓɔkɔ ma Elode na ɓoɓe ɓosɔ ɓonzimelakyi Ɓayuda.» ");
INSERT INTO loq_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Waeɓa yo elele ekomi yo, amba yakyɛ o ingambi sa Maliya, nyango wa Yoane, owaphɛkyɛ ɓɛ́ɛ na nkombo ya Malako. Omɔ ɓato ɓaikye ɓaanganaka, ɓaɓɔndɛlɛ. ");
INSERT INTO loq_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Wakomola yo ekomba enɛnɛ eya lopango, ŋwaŋwasi mɔnɔmɔ wa etoma amba susinya phɔ ya iyokyemela, nkombo yɛ Loda. ");
INSERT INTO loq_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Amba ya eɓa ŋwɛsi ŋwa Petelo. Na nkyisa, taikaka ziɓola ekomba. Amba butwa na mbangu o motema, amba kyɛ imola oɓokye Petelo atɛmi o ɓoo pha moziɓo munɛnɛ. ");
INSERT INTO loq_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ɓamba ya wɔ nɛ ɓɛkye: «Oyeye!» Kasi yo kaanole nde oɓokye eli phɛlɛ. Ɓamba wɔ ɓɛkye: «Wanaka eli anzelu wɛ.» ");
INSERT INTO loq_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Mɛna Petelo kakomole nde ɓokomosi. Wamba ya ziɓola ɓɛ́ɛ ekomba, ɓamowɛni, ɓabuto ikamwa. ");
INSERT INTO loq_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Amba ya ɓazibisa na eɓɔkɔ oɓokye ɓaikale ɓose. Amba ya ɓaimola ndengye emotɔkɔsi Nkolo o bɔlɔkɔ, yokye: «Oimola Zake na ɓɛbi lowɔ mɛ.» Emba amba ya tɔkɔlɔ, aesi yakyɛ o elele esuu. ");
INSERT INTO loq_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Waayɛ bunya, tɔkɔ ekusi yeesi ya tɔkɔlɔ onte ya ɓatuluku. Ɓamitunaka ɓɛkye: «Petelo akyesi ɓo?» ");
INSERT INTO loq_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Elode amba toma ɓato ɓakyɛmimoluka, imozwa phe. Amba ya tuna ɓakyɛngyɛsi, amba ya wɔ oɓokye ɓaɓaɓome. Amba ya mana o Yuda akyɛ o Sezare, amba ikala omɔ. ");
INSERT INTO loq_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Elode aɓaka na yɔ na ɓato ɓa Tula na Sidona. Ɓato ɓaɓana ɓaesi ya kɔlɔ, ɓakyɛ oka yɛ. Ɓaɓɔngyɛ na Ɓalasitusu, moto wa etoma wa etee ya ingambi eya ilala ya mokonzi, oɓokye ɓakule butwa na ɓooka, phɔ nkyisi ya ɓɛ́ɛ izwakye ntoma ya iza ikyeute o mokyisi ŋwa mokonzi. ");
INSERT INTO loq_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Wakoma mokɔlɔ ŋwa okanaka ɓɛ, Elode amba ya lata etobu ya ɓokonzi, aesi ya zala o eziye yɛ ya ɓokonzi kaɓawɔlɛ maphɔɔ. ");
INSERT INTO loq_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ɓato ɓaesi ya aŋwana, ɓɛkye: «Eye nde ŋwɛsi ŋwa Ŋwaphongo, teli ŋwa moto!» ");
INSERT INTO loq_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Nde o sina imbɛlɛ, anzelu wa Nkolo asei ya mowanda phɔ taphɛ waphongo nkyɛmɔ. Ɓoɓɛlɛ ɓanyanzumbɛlɛ ɓamba ya mozaa, nɔnɔ waa wa yo. ");
INSERT INTO loq_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Maphɔɔ ma Ŋwaphongo manyangwaka mboka esɔ, na ɓaanosi ɓabutwaka ɓaikye. ");
INSERT INTO loq_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Waunva Ɓalaɓa na Saolo etoma ya ɓɛ, ɓamba ya butwa o Yelusalɛmɛ. Ɓakyɛkyɛ na Yoane, owaphɛkyɛ ɓɛ́ɛ nkombo ya Malako. ");
INSERT INTO loq_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","O ingomba sa Antioshe, ɓaimosi na ɓateye ɓaɓaka omɔ. Ɓalaɓa, Simeyɔ okoɓangye ɓɛ́ɛ Mwindo, Lukusu wa Sirɛnɛ, Manaene owakolaka elele yɔnɔyɔ na ŋwangyesi Elode, na Saolo. ");
INSERT INTO loq_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Mokɔlɔ mɔnɔmɔ ŋwa ɓaka ɓɛ́ɛ ɓaɓɔndɛlɛ Nkolo na imiima ntoma, Ɓolɔɓɔ Ɓosantu amba ya wɔ yokye: «Omanyisa Ɓalaɓa na Saolo phɔ ya etoma eeɓaɓangyi na nga.» ");
INSERT INTO loq_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ɓoɓɛlɛ, wa miima ɓɛ́ɛ ntoma na wa ɓɔndɛlɛ ɓɛ, ɓamba ya ɓatandela maɓɔkɔ, nɔnɔ wa ɓalɛ ɓɛ́ɛ ɓakyɛ. ");
INSERT INTO loq_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Wa ɓa ɓɛ́ɛ o etoma eya ɓaphɛ Ɓolɔɓɔ Ɓosantu ya ikyɛnimola Simo Elaa, Ɓalaɓa na Saolo ɓamba ya uta o ibongu sa Silisi. Omɔ, ɓamba ya kpela o masuwa phɔ ya ikyɛndɛ o Shiprɛ. ");
INSERT INTO loq_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Wakoma ɓɛ́ɛ o Salamini, ɓamba ya imola iloɓa sa Ŋwaphongo o mangambi ma makyita ma Ɓayuda. Ɓaɓaka na ná Yoane phɔ ya iɓasunga. ");
INSERT INTO loq_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Wa katisa ɓɛ́ɛ esanga esɔ nɔnɔ o Pafos, ɓamba kyɛ zwa moto mɔnɔmɔ, nkombo yɛ Ɓalayesu, yo moyuda, mokyesi ŋwa manganga, aɓaka kamikpe oɓokye ali moimosi. ");
INSERT INTO loq_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Aɓaka yo na mwangyesi wa esanga. Nkombo ya mwangyesi mɛ, Sɛlɛgusu Polo, moto wa malondo. Iyo amba ya toma oɓokye ɓamoɓangyele Ɓalaɓa na Saolo, phɔ alukaka na ɓokusi oɓokye aokye iloɓa sa Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Kasi nganga Elima (phɔ nkombo yɛ kyelimbole ɓaɓona), taikaka anola yaaɓaka ɓɛ́ɛ ɓawɔ, emba alukaka na oɓokye ŋwangyesi yo sa anola. ");
INSERT INTO loq_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ɓoɓɛlɛ, Saolo, okoɓangye ɓɛ́ɛ Polo, atondaka na Ɓolɔɓɔ Ɓosantu, amba ya molembetela. ");
INSERT INTO loq_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Amba wɔ nɛ yokye: «Owatonda na malondo maɓe na ná ɓɔɔlɛ, ŋwana wa Molemba, ŋwakolo munguna ŋwa ɓosembo! Otoeme ikyɛmiɔtingyinya manzela ma Nkolo matɛmɛ yɔɔ? ");
INSERT INTO loq_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Emba kyeka iŋwaŋwa eye, eɓɔkɔ ya Nkolo ya moewanda: Wamophɔlɔ miyo, nɔnɔ itekye, otokule wɛnɛ moo.» Mina wamɔ, lonzumbe na enzɔmbi eesi ya moziɓa, abuto tiɓatiɓa phɔ ya iluka ɓato ɓa imokpa mi eɓɔkɔ. ");
INSERT INTO loq_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ɓoɓɛlɛ wawɛnɛ mwangyesi lowɔ loleka, amba butwa ianola, phɔ mateya ma Nkolo maamokamwisaka na ɓoikye. ");
INSERT INTO loq_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Polo na ɓɛbi nɛ ɓamba ya kpela o masuwa o Pafos, ɓamba ya koma o Pɛlɛze o Pamfiliya. Emba Yoane amba kaɓana na ɓɛ, yo ibutwa o Yelusalɛmɛ ");
INSERT INTO loq_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ɓɛ, ɓamba ya mana o Pɛlɛze, ɓamba ya koma o Antioshe o pisidi. Mokɔlɔ ŋwa saɓata, ɓamba ya kyɛ nyɔlɔ o ingambi sa makyita, ɓakyɛ zala. ");
INSERT INTO loq_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Waunva ɓɛ́ɛ itanga buku pha Miɓeko na pha Ɓaimosi, Ɓakonzi ɓa ingambi sa makyita ɓamba ya toma ɓato ikyɛ wɔ na ɓɛ́ɛ ɓɛkye: «Ɓɛbi ɓa ɓampele, na oli na lowɔ la iɓɔndɔ ɓato, owɔ.» ");
INSERT INTO loq_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Polo amba ya tɛmɛ, amba ya ɓazibisa na eɓɔkɔ, yokye: «Ɓato ɓa Isalayɛlɛ na ɓa lote Ŋwaphongo, okyemela! ");
INSERT INTO loq_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Ŋwaphongo owa ɓato ɓa Isalayɛlɛ owa ɔlɔ ɓa ango ɓa ɓanga, na ɓato ɓa tomba yo imbɛlɛ sa ɓaka ɓɛ́ɛ o mokyisi ŋwa Ezipito wa tɔkɔlɔ yo na eɓɔkɔ yɛ ekusi onte ya ɓɛ. ");
INSERT INTO loq_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Phɛnɛphɛ mbula mako mane, akuyaka na moɓesi ŋwa ɓɛ́ɛ o bokye. ");
INSERT INTO loq_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Emba waɔtɔ yo maɓota sambo o mokyisi ŋwa Kanana, amba kaɓa mokyisi ŋwa ɓɛ́ɛ ilaka ");
INSERT INTO loq_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","phɛnɛphɛ na mbula mikama mine mbuka mako matano. Emba sima mɛ, amba ya ambya ɓananga nɔnɔ o imbɛlɛ saka moimosi Samwɛlɛ. ");
INSERT INTO loq_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Emba tata wamɔ, ɓamba ya onga mokonzi mɔnɔmɔ. Ŋwaphongo amba ya ɓaphɛ Saolo ŋwana wa Kyisi, moto wa iɓota sa Ɓenzamɛ, phɔ ya mbula mako mane. ");
INSERT INTO loq_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Wamolɛ ɓɛ, amba ya ɓaphɛ Davidi oɓokye aɓe mokonzi ŋwa ɓɛ. Phɔ yɛ amba na wɔ yokye: “Nazwe Davidi, ŋwana wa Yese, moto olongoɓa o ndondo ya nga, owa mokyela maphɔɔ masɔ ɓoozingye nga.” ");
INSERT INTO loq_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","O iɓota sɛ, Ŋwaphongo, ɓo waikaka yo mbunu, atɔkɔlɛlɛkyɛ Isalayɛlɛ Mobikye Yesu. ");
INSERT INTO loq_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","O ɓoo pha iya sɛ, Yoane ateyaka phanza ɓato ɓasɔ ɓa Isalayɛlɛ ɓatisimo ya iɓongola motema. ");
INSERT INTO loq_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Wakoma Yoane iyunva etoma yɛ, awɔkɔ yokye: “Ɓɛɛ koumunya oɓokye nga nali nza? Sili yo! Kasi kyeka oɓokye okoye o sima ya nga, sikokyi na iyingola simbi ya bikoto ɓɛ.”» ");
INSERT INTO loq_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","«Ɓɛbiɓana ɓa iɓota sa Abalayama na ɓaalote Ŋwaphongo, maphɔɔ ma ibika mama, ɓamatoma phɔ ya ɓanga. ");
INSERT INTO loq_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Phɔ ɓato ɓa Yelusalɛmɛ na ɓakonzi ɓa ɓɛ, teɓaikyi moeɓa, na wamoingya ɓɛ, ɓakokyisa maphɔɔ mawɔkɔ ɓaimosi, matangye ɓɛ́ɛ nkɔlɔ ya saɓata isɔ. ");
INSERT INTO loq_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Na waɓaka ɓɛ́ɛ sazwa ewele ya imoingya, ɓamba onga oka Pilata obokye amoɓome. ");
INSERT INTO loq_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Waunva ɓɛ́ɛ ikokya maphɔɔ masɔ maakoma ɓɛ́ɛ phɔ yɛ, ɓamba ya mumanya o ekulusu, ɓaesi ya mokunda. ");
INSERT INTO loq_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Kasi Ŋwaphongo amba ya mokundola onte ya ɓawe. ");
INSERT INTO loq_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Iyo owatɔkɔlɛlɛkyɛ nkɔlɔ nzikye ɓato ɓautaka nɛ Galileya phɔ ya ikyɛndɛ o Yelusalɛmɛ. Uŋwaŋwa eye, ɓɛ́ɛ ɓali manzoka mɛ oka ɓato. ");
INSERT INTO loq_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Na ɓanga, toeyimole Simo Elaa eye: Mbunu eyaikyelaka ɓɛ́ɛ ɓaango ɓa ɓanga, ");
INSERT INTO loq_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Ŋwaphongo aekokye esɔ phɔ ya ɓanga, ɓana ɓa ɓɛ, wakundola yo Yesu, ɓo wakoma ɓɛ́ɛ o zembo sa iɓale oɓokye: Oli ŋwana wa nga, inga, lɔlɔ, naeɓoti. ");
INSERT INTO loq_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Omokundosi Ŋwaphongo onte ya ɓawe, etakule phɔlɔ, eli nde ɓo wawɔkɔ yo, oɓokye: “Namoephɛ mbolo isantu ya Davidi, maphɔɔ ma phɛlɛ.” ");
INSERT INTO loq_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Yango mɛna, kakule wɔ o elele eyɔkɔ yokye: “Otolɛ moto mosantu wa wɛ oɓokye aphɔlɔ o ilita.” ");
INSERT INTO loq_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Phɔ Davidi, wakyelela yo iɓota sɛ o imbɛlɛ sɛ, na ŋwango ŋwa Ŋwaphongo, amba wa. Ɓamba ya mokunda phɛnɛphɛ na ɓaango, nɛ aphɔlɔ. ");
INSERT INTO loq_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Kasi yo owakundola Ŋwaphongo onte ya ɓawe, taika phɔlɔ. ");
INSERT INTO loq_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Ɓande, oeɓe oɓokye eli phɔ yɛ simo ya ilimbisa masumu yeesi, na ibutwa ɓato ɓa ɓosembo phate pha ikaka zwa ɓɛ̀ɛ na Moɓeko ŋwa Mose, ");
INSERT INTO loq_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","na nzela yɛ, moanosi musɔ abuto moto wa ɓosembo. ");
INSERT INTO loq_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Omiɓanza, oɓokye maphɔɔ mawɔ ɓaimosi mango sa eyelela: ");
INSERT INTO loq_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“Kyeka, ɓɛ̀ɛ ɓasemosi, okamwe, olɛmɔ! Phɔ, ɓo taɓaa ɓɛ̀ɛ na ɓomɔɔ, namokyela etoma yɔnɔyɔ, oɓokye ɓo ɓaeyimosi yango otoeyanole!”» ");
INSERT INTO loq_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Wa itɔkɔlɔ, ɓamba ya ɓɔndɛlɛ Polo na Ɓalaɓa na ɓoikye oɓokye ɓakule ya ɓaawɔlɛ phɔ ya lowɔ mɛ mɔkɔlɔ ŋwa saɓata ŋwa sima. ");
INSERT INTO loq_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Wanyangwa ɓato ɓasɔ ɓaanganaka, Ɓayuda ɓaikye na ɓato ɓasuu ɓaakumole Ŋwaphongo, ɓamba ya ɓenga Polo na Ɓalaɓa. Ɓaɓalenzaka oɓokye ɓaphile ɓophɛlɛlu ngolu ya Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Wakoma saɓata, phanɛphɛ mokyisi mobimba ŋwamba yaangana phɔ ya iyoka maphɔɔ ma Nkolo. ");
INSERT INTO loq_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Wa wɛnɛ Ɓayuda moluku ŋwa ɓato, ɓaesi ya tnda na zuwa, abuto iikyela maphɔɔ ma Polo ziko, ɓamotole. ");
INSERT INTO loq_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Polo na Ɓalaɓa, na mwiya, ɓamba ɓabuyisela ɓɛkye: «Eɓakyi oɓokye maphɔɔ ma Ŋwaphongo ɓata mateya ɓɛ̀ɛ phanza. Kasi phɔ ɓɛ̀ɛ omalɛ, tokokyi na ɓomɔɔ pha ɓoɓɛlɛ. Yango mɛna tokyɛ oka ɓato bate ɓali Ɓayuda. ");
INSERT INTO loq_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Phɔ Nkolo awɔ na ɓanga ɓaɓona: “Naekyesi ndokolo tala ya na maɓota phɔ ya ikyɛ na Simo yanga nɔnɔ o mbomela ya mokyisi!”» ");
INSERT INTO loq_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Waoka ɓaate ɓali Ɓayuda ɓaaɓona, na nkyisa, ɓabuto ikumbela maphɔɔ ma Nkolo, emba ɓasɔ ɓaɔlɔmɔkɔ phɔ ya ɓomɔɔ pha ɓoɓɛlɛ ɓamba butwa ɓaanosi. ");
INSERT INTO loq_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Maphɔɔ ma Nkolo mamba ya nyangwa o mokyisi munsɔ. ");
INSERT INTO loq_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Kasi Ɓayuda ɓamba ya losa ɓaɓasi ɓa kaa ɓakumole Ŋwaphongo na onte ya bankumu ɓa mokyisi, ɓalukaka inyɔkɔlɔ Polo na Ɓalaɓa, emba ɓamba ya ɓawiinya o manyɛtɛ ma ɓɛ. ");
INSERT INTO loq_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Kasi ɓɛ, ɓamba ya lasa mobulubutu ŋwa makolo ma ɓɛ, ɓamba yakyɛ o Ikoniumu. ");
INSERT INTO loq_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Kasi ɓaekosi ɓatondaka na nkyisa na ná Ɓolɔɓɔ Ɓosantu. ");
INSERT INTO loq_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","O Ikoniumu, wakula lekana nde ɓomɔ. Polo na Ɓalaɓa ɓamba ya kyɛ nyɔlɔ o ingambi sa Ɓayuda sa makyita. Ɓamba ya wɔ na ndengye yɔnɔyɔ oɓokye Ɓayuda na Ɓaela ɓaikye ɓabutwaka ɓaanosi. ");
INSERT INTO loq_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Kasi Ɓayuda ɓayɔkɔ ɓate ɓaikaka anola, ɓamba losa ɓapakano oɓokye ɓaɓe na maumunya maɓe phɔ ya ɓɛbi. ");
INSERT INTO loq_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Na ɓo ɓomɔ, ɓakyelaka nkɔlɔ nzikye o Ikoniumu. Ɓaɓaka ɓawɔ nde pwapwa phɔ ya Nkolo na phɔ ya maphɔɔ ma ngɔlu yɛ. Aɓaphɛkyɛ mwiya ŋwa ikyela na maɓokɔ ma ɓɛ́ɛ bilembetele na bilekyesako. ");
INSERT INTO loq_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Moluku ŋwa ɓato ɓa mokyisi ŋwamba kaɓana. Ɓana ɓaɓaka mbale na Ɓayuda, ɓayɔkɔ mbale na ɓatoma. ");
INSERT INTO loq_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ɓapakano na Ɓayuda na ɓakonzi ɓa ɓɛ́ɛ ɓamba kana inyɔkɔlɔ na iɓoma ɓatoma na maɓanga. ");
INSERT INTO loq_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Waawɛnɛ ɓɛ́ɛ ɓaɓona, ɓamba ya lota mbale ya nkyisi ya Likaoni, Listrɛ na Dɛrbɛ, na o nkyisi ili phɛnɛphɛ na yango. ");
INSERT INTO loq_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Omɔ, ɓabuto nde iimola Simo Elaa. ");
INSERT INTO loq_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","O Listrɛ, moto mɔnɔmɔ munɛnɛ aɓaka omɔ, taikaka ɓa katɛmɛ. Makolo mɛ manyiɓa uta o ibu sa nyango, taikaka na ɓa katambule. ");
INSERT INTO loq_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Amba oka Polo kawɔ. Polo amba ya molembetela, aesi ya wɛnɛ oɓokye ali na ianola phɔ ya ibika, ");
INSERT INTO loq_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Amba ya wɔ na ɓokusi yokye: «Tɛmɛ na makolo ma wɛ!» Emba amba ya ngbɛngɔ, aɓuto itambula. ");
INSERT INTO loq_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Waayawɛnɛ moluku ŋwa ɓato lowɔ lokyesi Polo, ɓamba ya aŋwana na munɔkɔ ŋwa ɓɛ, ɓɛkye: «Ɓa Ŋwaphongo ɓamibuye ɓato, ɓauti o ikolo, ɓaesi oka ɓanga!» ");
INSERT INTO loq_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ɓaɓangaka Ɓalaɓa «Zeyusu», emba Polo «Ɛrmɛsi», phɔ ya ɓaka yo owa kpaka maloɓa. ");
INSERT INTO loq_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Nganga wa Ŋwaphongo Zeyusu o nze ya iɓala, amba yaa na ɓalo ɓa mangɔmbɛ na biɓoko ɓa ɓokonzi o nziɓo ya inyɔlɔ o mokyisi. Yo na moluku ŋwa ɓato ɓamba okana oɓokye ɓaɓakaɓele ikaɓo. ");
INSERT INTO loq_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Waaoka ɓatoma Ɓalaɓa na Polo lowɔ mɛ, bamba kakola bitobu ɓa ɓɛ, ɓamba ya ngbɛngɔ bili moluku ŋwa ɓato na iyaŋwana ");
INSERT INTO loq_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","ɓɛkye: «Ɓato, phɔ ya'ye kokyele maphɔɔ mamana? Na ɓanga toli nde ɓato ɓoli ɓɛ̀ɛ! Simo Elaa ekyeyimole ɓanga, eli nde oɓokye olɛ maphɔɔ maaɓe obutwele Ŋwaphongo oli na ɓomɔɔ, owakyela ikolo na munse, ebale eenɛnɛ na isɔ ili omɔ. ");
INSERT INTO loq_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Wa phanza, alɛkyɛ maɓota masɔ maɓengye manzela ma ɓɛ́ɛ mampenza. ");
INSERT INTO loq_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Nzuka amiwɛninyaka na maphɔɔ malaa maakyele yo mama. Kasi taika lɛ iɓawɛninya maphɔɔ malaa, phɔ kaɓatomele uta o ikolo mambula na bipha bilaa, kaɓatonza na ntoma katonza na mandondo ma ɓɛ́ɛ na nkyisa.» ");
INSERT INTO loq_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Maphɔɔ mɛ temakokaka izibisa moluku ŋwa ɓato izele, phɔ ya oɓokye ɓɛ́ɛ saɓaambisa mambeka. ");
INSERT INTO loq_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ɓoɓɛlɛ, o Antioshe na o Ikoniumu, wamba ya tɔkɔlɔ Ɓayuda ɓaya losa moluku na ɓato. Ɓaesi ya ma Polo maɓanga, ɓamba ya tɔkɔlɔ nɛ o imbale ya mokyisi, ɓaumunyaka oɓokye awe. ");
INSERT INTO loq_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Kasi, wangana ɓaekosi wali yo, amba ya iŋwa ɓoɓɛlɛ amba ya nyɔlɔ o mokyisi. Ɓo yana, yo na Ɓalaɓa ɓamba ya kyɛ o Dɛrbɛ. ");
INSERT INTO loq_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Sima ya iyimola Simo Elaa o mokyisi mɛ na izwa ɓaekosi ɓaikye omɔ, ɓamba kula ya kyɛndɛ o Listrɛ, o Ikoniumu na o Antioshe. ");
INSERT INTO loq_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ɓakyɛkyɛ kuya mandondo ma ɓaekosi na iɓalenza oɓokye ɓalendendale o ianola, ɓɛkyɛ: «Tosengyesi ilekana na minyɔkɔ miikye, phɔ ya inyɔlɔ o Ɓokonzi pha Ŋwaphongo.» ");
INSERT INTO loq_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","O ingomba sɔnɔsɔ na sɔnɔsɔ, ɓaɓaɔlɛlɛkyɛ ɓankumu, ɓamba ɓɔndɛlɛ, ɓamba na miima ntoma phɔ ya iɓaambya oka Nkolo owa anola ɓɛ. ");
INSERT INTO loq_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Emba wakatisa ɓɛ́ɛ Pisidi, ɓamba ya kyɛ o Pamfili. ");
INSERT INTO loq_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Wateya ɓɛ́ɛ maphɔɔ ma Ŋwaphongo o Pɛrgɛ, emba ɓamba ya kyɛndɛ o Atali. ");
INSERT INTO loq_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Omɔ, ɓamba ya kpela o masuwa, ɓabuto o Antioshe, wautaka ɓɛ, elele eya ɓambyaka ɓɛ́ɛ o ngɔlu ya Ŋwaphongo phɔ ya etoma ekyeute ɓɛ́ɛ ikyela. ");
INSERT INTO loq_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Wakoma ɓɛ, ɓaesi ya angyinya Ingomba, ɓamba ɓaimola masɔ makyela Ŋwaphongo na ɓɛ, na ndengye eyaingolaka yo moziɓo ŋwa ianola phɔ ya ɓapakano. ");
INSERT INTO loq_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Emba, ɓamba ya kɔkɔ omɔ ɓɛ́ɛ na ɓaekosi. ");
INSERT INTO loq_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ɓoɓɛlɛ, ɓato ɓayɔkɔ ɓamba uta o Yuda, ɓɛ́ɛ ɓalukaka iteya ɓɛbi ɓoɓo: «Ɓɛ ɓoto miɓɛsi ɓokowɔ moɓeko ŋwa Mose, ɓɛ́ɛ tokokyi ibika.» ");
INSERT INTO loq_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Tɔkɔ yamba tɔkɔlɔ, emba miko makusi mamba ɓa onte ya Polo na Ɓalaɓa na ɓato mɛ. Ɓamba ya sukya oɓokye Polo, Ɓalaɓa na ɓato ɓasu ɓakyɛ o Yelusalɛmɛ, ɓakyɛ zwana na ɓatoma na ɓakumu phɔ ya tɔkɔ mɛ. Teɓaikaka ɓanolela, ɓaesi ya phalatana na ná ɓokusi phɔ ya lowɔ mɛ. Na ɓomɔ, ɓaesi ya toma Polo, Ɓalaɓa na ɓato ɓayɔkɔ ɓa Antioshe oɓokye ɓakyɛndɛ o Yelusalɛmɛ oka ɓatoma na ɓankumu, ɓawɔ lowɔ mɛ. ");
INSERT INTO loq_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ingomba ɓasungaka phɔ ya imbanga mɛ. Ɓoɓɛlɛ, ɓaesi ya katisa Fenikisi na Samaliya, ɓakyɛ mimola o waanola ɓato ɓaateɓali Ɓayuda Yesu. Simo mɛ ya phɛkyɛ nde ɓɛ́ɛ ɓasɔ nkyisa na ɓoikye. ");
INSERT INTO loq_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Wakoma ɓɛ́ɛ o Yelusalɛmɛ, ingomba ɓaakumbelaka, eɓe na ɓatoma na ɓakumu, ɓaaimolaka isɔ yaakyelaka Ŋwaphongo na nzela ya ɓɛ. ");
INSERT INTO loq_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ɓaanosi ɓaayɔkɔ ɓa mbale ya Ɓafalisayi, ɓaesi ya tɛmɛ, ɓɛkye: «Esengyesi oɓokye ɓaɓɛlɛ ɓaanosi ɓaateɓali Ɓayuda, ɓaɓatome na ɓokusi ikokya moɓeko ŋwa Mose.» ");
INSERT INTO loq_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Ɓatoma na ɓakumu ɓaesi ya angana phɔ ya ekola lowɔ mɛ. ");
INSERT INTO loq_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ɓaphalatanaka na ɓoikye. Sima, Petelo aesi ya tɛmɛ, yokye: «Ɓande, koeɓe oɓokye Ŋwaphongo anzɔlɔ onte ya ɓɛ̀ɛ oɓokye naimole Simo Elaa oka ɓato ɓaateɓali Ɓayuda, phɔ ɓa okye, ɓaanole. ");
INSERT INTO loq_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ŋwaphongo, okoeɓe mandondo ma ɓato, aɓaphɛ Ɓolɔɓɔ Ɓosantu ɓo ŋwaalophɛ yo, phɔ ya iteya oɓokye ɓaanosi. ");
INSERT INTO loq_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Taika lokyɛsinya na ŋwana ɓokyi ɓoɓo na ɓɛ, Ŋwaphongo akunyola mandondo ma ɓɛ́ɛ phɔ ɓamoanola. ");
INSERT INTO loq_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Kasi kolukye itoma ɓaanosi inyanya ephesi ewaa, na ɓankɔkɔ ɓa ɓanga, na ɓanga toloikyi koka ienyanya. Komekye Ŋwaphongo ɓaɓona phɔ ya'ye? ");
INSERT INTO loq_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Kasi na ngɔlu ya Nkolo Yesu, ɓanga toanole oɓokye tobikyi ndengye yɔnɔyɔ na ɓɛ.» ");
INSERT INTO loq_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Ɓato ɓasɔ ɓaesi ya ikala ɓose, ɓaokyemele Ɓalaɓa na Polo ɓaɓaimole bilekyesako na bilembetele bisɔ ɓiakyelaka Ŋwaphongo na nzela yɛ o nte ya ɓato ɓaateɓali Ɓayuda. ");
INSERT INTO loq_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Waunva iwɔ, Zake nɛ aesi ya wɔ, yokye: «Ɓande, inzokyemele! ");
INSERT INTO loq_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simo aimosi ɓo watataka Ŋwaphongo ikana oɓokye onte ya ɓato ɓaateɓali Ɓayuda aɔlɔ iɓota sɔnɔsɔ siili sɛ. ");
INSERT INTO loq_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Maphɔɔ maawɔ baimosi makoka na lowɔ mɛ, phɔ totangye o buku pha Ŋwaphongo ɓoɓo: ");
INSERT INTO loq_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Nkolo kawɔ ɓoɓo: “Sima ya maphɔɔ mamana namokula ya, Namotonga na ingambi sa Davidi saabukwaka, nasiinola, naasitɛyɛ, ");
INSERT INTO loq_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Emba ɓato ɓayɔkɔ ɓasɔ ɓamoluka Nkolo, eɓe na maɓota masɔ maɓanga nga oɓokye maɓe ma nga. Eye ɓooko wɔ Nkolo. ");
INSERT INTO loq_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Aebinyaka maphɔɔ mɛ mamana uta kalakala.” ");
INSERT INTO loq_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Zake akuli wɔ, yokye: Yango mɛna, nawɛnɛ oɓokye tolokokyi iɓaphɛ motema ɓolɔsi oka ɓaatebali Ɓayuda, ɓaanole Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Kasi toɓakomele mokanda oɓokye toongye na ɓɛ, sa zaa nsoti ikyiambya ɓɛ́ɛ oka manzambe ma bikyeko, sa kyela ɓondumba, sa zaa manyama maawe na malongo o motema, sa zaa na malongo. ");
INSERT INTO loq_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Phɔ nɔnɔ wa kalakala, ɓato ɓateya moɓeko ŋwa Mose o mokyisi mɔnɔmɔ na mɔnɔmɔ, ɓamotangye na o mangambi ma makyita ma Ɓayuda nkɔlɔ isɔ ya Saɓata.» ");
INSERT INTO loq_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ɓoɓɛlɛ, ɓatoma, ɓakumu, na ingomba sisɔ ɓaesi ya kana oɓokye ɓaɔlɔ ɓato onte ya ɓɛ, ɓaɓatome o Antioshe ɓɛ́ɛ na Polo na Ɓalaɓa. Ɓaesi ya ɔlɔ Yuda okoɓangye ɓɛ́ɛ Ɓalasabas, na Silasi, ɓasɔ ɓaɓale ɓaɓaka ɓato ɓa kaa onte ya ɓande na ɓɛ. ");
INSERT INTO loq_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ɓaphisaka mokanda moowɔ ɓoɓo: «Ɓande na ɓɛ̀ɛ, ɓatoma na ɓankumu, ɓaɓeya ɓande na ɓɛ, ɓaateɓali Ɓayuda, ɓaazale o nkyisi iye: Antioshe, Siri na Silisi. ");
INSERT INTO loq_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Tooka oɓokye ɓana ɓato, ɓawaa ɓaateɓaika ɓanga phɛ nzela, ɓauta oni, ɓaya bi omɔɔ, ɓaebunzinya na maphɔɔ maawɔ ɓɛ, ɓakyɛtitisa mandondo ma ɓɛ̀ɛ. ");
INSERT INTO loq_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Yango mɛna, tokani ɓanga ɓasɔ oɓokye toɔlɔ ɓato emba toetomele ɓɛ. Ɓamoyaa molɔngɔ na ɓɛbi na ɓanga, Ɓalaɓa na Polo. ");
INSERT INTO loq_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Ɓaambya ɓomɔ pha ɓɛ́ɛ phɔ ya etoma ya Nkolo wa ɓanga Yesu Klisto. ");
INSERT INTO loq_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Toetomesi Yuda na Silasi ɓaamoeyimola, ɓɛ́ɛ mampenza, maphɔɔ maakomi ɓanga mamana. ");
INSERT INTO loq_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Phɔ, na ɓanga na Ɓolɔɓɔ Ɓosantu, tokani oɓokye tolokokyi iephisa ephesi esuu, kasi maphɔɔ masengyesi ɓɛ́ɛ ikyila mango mama: ");
INSERT INTO loq_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Sa zaa nsoti ikyiambya ɓɛ́ɛ oka manzambe ma bikyeko, sa zaa malongo, sa zaa manyama maawe na malongo o motema, sa kyela ɓondumba. Ɓo omimanye mi maphɔɔ masɔ mamana, kokyele ɓolaa. Oikalaka na ɓolaa.» ");
INSERT INTO loq_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Emba ɓato mɛ ɓaatomaka ɓɛ, ɓamba ya kyɛndɛ, ɓakyɛ koma o Antioshe. Ɓaesi ya angyinya ɓaanosi ɓasɔ, ɓaɓaphɛ mokanda mɛ. ");
INSERT INTO loq_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ɓaesi ya tanga mokanda mɛ, ɓato ɓasɔ ɓatondaka na nkyisa phɔ ya maphɔɔ maaɓalenzaka na ɓɛ́ɛ o mokanda mɛ. ");
INSERT INTO loq_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yuda na Silasi, ɓɛ́ɛ mampenza ɓaɓaka ɓaimosi, ɓalenzaka ɓɛbi, ɓaɓakuyaka na maphɔɔ maikye maawɔkɔ ɓɛ. ");
INSERT INTO loq_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ɓakutaka kɔkɔ na ɓɛ. Waakoma ɓɛ́ɛ wa ibutwa, ɓɛbi ɓaesi ya kyɛ ɓaika, ɓɛ́ɛ o kyɛkyɛ na ɓolaa. Ɓamba ya butwa oka ɓaaɓatomaka.  ");
INSERT INTO loq_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Kasi Silasi akanaka oɓokye kaikale omɔ. ");
INSERT INTO loq_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Ɓoɓɛlɛ Polo na Ɓalaɓa ɓamba ya ikala o Antioshe. Na ɓato ɓayɔkɔ ɓaikye, ɓɛ́ɛ ɓasɔ ɓaɓaka ɓateya, ɓaimole Simo Elaa ya Nkolo. ");
INSERT INTO loq_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Sima ya ɓana nkɔlɔ, Polo aesi ya wɔ na Ɓalaɓa, yokye: «Tobutwe, tokyɛ kyeka ɓande na ɓanga o nkyisi isɔ yaimolaka ɓanga Simo ya Nkolo, tokyekye ndengye eli ɓɛ.» ");
INSERT INTO loq_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Ɓalaɓa aɓaka na phowa ikyɛndɛ na Yoane, ookoɓangye ɓɛ́ɛ Malako. ");
INSERT INTO loq_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Kasi Polo taikaka zinga oɓokye akyɛndɛ ɓɛ, phɔ aɓaikaka o mokyisi na nkombo Pamfili, takulaka ɓakamba o etoma ya ɓɛ. ");
INSERT INTO loq_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Baokaka na ɓokusi onte ya ɓɛ, ɓamba ya kaɓana. Ɓalaɓa akpe Malako, abaa o masuwa, akyɛ o Shiprɛ. ");
INSERT INTO loq_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Polo aɔsi Silasi, waunva ɓaanosi iɓaamba o maɓɔkɔ ma Ŋwaphongo oɓokye aɓaɓanza na ngɔlu yɛ, ɓamba ya kyɛndɛ. ");
INSERT INTO loq_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ɓamba ya katisa Siri na Silisi, ɓalenzaka mangomba oɓokye ɓaikale na ianola. ");
INSERT INTO loq_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Polo aesi ya koma o Dɛrbɛ, na o Listrɛ. Moanosi mɔnɔmɔ aɓaka omɔ, nkombo yɛ Timote, nyango Moyuda, owaɓutwa Moklisto, kasi ango Moela. ");
INSERT INTO loq_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Ɓande ɓaɓaka ɓazale o Listrɛ na o Ikoniumu, ɓaɓaka ɓawɔ oɓokye ali moto molaa. ");
INSERT INTO loq_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Polo aɓaka na phowa oɓokye Timote atambulakye nɛ molɔngɔ. Aesi ya mokpa, ɓamoɓɛsi phɔ Ɓayuda, ɓaaɓaka o nkyisi mɛ, ɓɛ́ɛ ɓasɔ ɓaeɓaka oɓokye ango ali Moela. ");
INSERT INTO loq_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","O nkyisi isɔ, yaaɓaka yo kalekane, ɓaimolaka ɓaanosi miɓeko miakpa ɓatoma na ɓakumu ɓa Yelusalɛmɛ. Ɓaongaka na oɓokye ɓakokya miɓeko mɛ. ");
INSERT INTO loq_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Mangomba mabutwaka na ianola sikusi, motiya ŋwa ɓato ŋwaɓaka moɓakisame nkɔlɔ isɔ. ");
INSERT INTO loq_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Ɓolɔɓɔ Ɓosantu aɓakatelaka oɓokye sa imola Simo ya Ŋwaphongo o nkyisi ya Azi. Yango mɛna aesi ya katisa o nkyisi iye: Friji na Galati. ");
INSERT INTO loq_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Wakomaka phɛnɛphɛ na Misi, alukaka ikyɛndɛ o Ɓitini. Kasi Ɓolɔɓɔ pha Yesu tephawaikaka ɓaɓenisa ikyɛndɛ omɔ. ");
INSERT INTO loq_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ɓoɓɛlɛ, aesi ya katisa Misi, akyɛ o ibongu siiɓangye ɓɛ́ɛ Troas. ");
INSERT INTO loq_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Wa mokɔlɔ, Polo aesi ya lɔtɔ ndɔtɔ awɛni moto mɔnɔmɔ wa Makedoniya atɛmi, kamoɓɔndɛlɛ, yokye: «Lekana o Makedoniya, oya losunga!» ");
INSERT INTO loq_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Sima ya ndɔtɔ mɛ ya Polo, sa kɔkɔ, ɓanga toesi ya luka nzela ya ikyɛndɛ o Makedoniya, phɔ toeɓaka oɓokye Ŋwaphongo kaloɓangye ikyɛ imola Simo Elaa oka ɓato ɓa mokyisi mɛ. ");
INSERT INTO loq_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Tokpe masuwa o Troas, tokyɛ o esanga na nkombo Samotras, ɓo yana toleka o Neapolis. ");
INSERT INTO loq_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Toesi ya mana omɔ, tokyɛ o Filipi, mokyisi munɛnɛ ŋwa Makedoniya, ŋwazalaka Ɓaloma. Tokyelaka nkɔlɔ nzikye o mokyisi mɛ. ");
INSERT INTO loq_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Mokɔlɔ ŋwa Saɓata, toesi ya tɔkɔlɔ, toikyi mokyisi, tokyɛ o mokukulu ŋwa eɓale, toumunyaka oɓokye tomozwa elele ekyesambele Ɓayuda omɔ. Toesi ya zala, towɛni na ɓaɓasi ɓaanganaka wamɔ. ");
INSERT INTO loq_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Mɔnɔmɔ na ɓaɓasi mɛ, nkombo yɛ Lidi, mokyisi nwɛ Tiyatire, aɓaka moungye wa bitobu bilaa ɓa mangola, aɓaka ŋwaŋwasi okosambele Ŋwaphongo. Waɓa ɓanga towɔ, aɓaka kalookye. Nkolo aesi ya ingola ndondo yɛ oɓokye aanole maphɔɔ maawɔkɔ Polo. ");
INSERT INTO loq_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ɓaesi ya moɓatisa, eɓe na iɓota sɛ. Ɓoɓɛlɛ, aloɓangyi oka yɛ, yokye: Ɓo koanole phɛlɛ oɓokye nali moanosi wa Nkolo, yaka ya kyɛ ɓa o ingambi sa nga. Alokandindisaka oɓokye toanole. ");
INSERT INTO loq_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Mokɔlɔ mɔnɔmɔ waɓa ɓanga tokyɛndɛ o elele ya iɓɔndɛlɛ, moombo mɔnɔmɔ ŋwa ŋwaŋwasi aesi ya vana na ɓanga: Aɓaka na ɓolɔɓɔ ɓoɓe onte yɛ, phaɓaka ɓomotome imola maphɔɔ maamoya. Azwelaka ɓakolo ɓɛ́ɛ ɓaphalanga ɓaikye mi etoma mɛ. ");
INSERT INTO loq_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Aesi ya butwa iloɓenga, ɓanga na Polo. Aɓaka kaŋwane yokye: «Ɓato ɓaɓa ɓali ɓato ɓa Ŋwaphongo owa ikolo, ɓaeteya nzela eya ibika.» ");
INSERT INTO loq_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Akyelaka ɓaɓona nkɔlɔ nzikye. Polo aesi ya wɛnɛ eempi, amba ya miekpinya, awɔ na ɓolɔɓɔ mɛ, yokye: «Na nkombo ya Yesu Klisto, nawɔ na wɛ oɓokye otɔkɔlɔ onte yɛ!» Mina wamɔ, ɓolɔɓɔ mɛ ɓotɔkɔsi onte ya moombo mɛ. ");
INSERT INTO loq_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Waawɛnɛ ɓakolo ɓa moombo mɛ oɓokye teɓakokyi ikula zwa ɓaphalanga na nzela yɛ, ɓaesi ya akya Polo na Silasi, ɓakyɛ na ɓɛ́ɛ o elele eya zando oɓoo pha ɓakonzi. ");
INSERT INTO loq_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Wakoma ɓɛ́ɛ oɓoo pha ɓananga mɛ, ɓɛkye: «Ɓato ɓaɓa ɓali Ɓayuda. Ɓaambya mobulu o mokyisi ŋwa ɓanga. ");
INSERT INTO loq_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Ɓateya ɓonkɔkɔ ɓolokatele moɓeko ŋwa ɓanga oɓokye ɓanga Ɓaloma, tolokokyi iɓoanola na iɓokyelela.» ");
INSERT INTO loq_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Eɓoko ya ɓato mɛ ɓaesi ya ɓasonga nɔkɔ. Ɓananga ɓa Ɓaloma ɓaesi ya ɓatomisa oɓokye ɓamanya Polo na Silasi bitobu, ɓaɓawande phimbo. ");
INSERT INTO loq_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Waunva ɓɛ́ɛ iɓawanda phimbo na ɓoikye, aɓavakyi o bɔlɔkɔ, ɓawɔ na moto ookokyɛngɛlɛ oɓokye aɓakyɛngyɛlɛ na ɓolaa. ");
INSERT INTO loq_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Mokyɛngyɛsi mɛ, waoka yo ɓaɓona, aesi ya ɓanyɔsa o etee ya bɔlɔkɔ eya motema, ɓaɓanyɔsɛkye makolo o motema ŋwa maɓaya manɛnɛ. ");
INSERT INTO loq_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Wa molengyela, Polo na Silasi ɓaɓaka ɓaɓɔndɛlɛ, ɓatuɓe phɔ ya ikumbela Ŋwaphongo, ɓato ɓaayɔkɔ ɓa bɔlɔkɔ ɓaɓaka ɓaɓaokye. ");
INSERT INTO loq_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Iɓalakana ɓoɓo, manyɛtɛ mabuto inyingana na ɓokusi, manyingyinye na bɔlɔkɔ, bikomba bisɔ biziɓo, nyɔlɔlɔ ya ɓato ɓasɔ ɓa bɔlɔkɔ yiingo. ");
INSERT INTO loq_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Mokyɛngyɛsi aesi ya umwa, wawɛnɛ yo oɓokye bikoma ɓa bɔlɔkɔ biikasi pha, aesi ya pka mumphata nwɛ oɓokye kamibome, phɔ abuyaka oɓokye ɓato ɓa bɔlɔkɔ ɓasɔ ɓaloti. ");
INSERT INTO loq_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Kasi Polo aesi ya aŋwana na ɓokusi, yokye: «Sa mikyela lowɔ! Ɓanga ɓasɔ toli wawa!» ");
INSERT INTO loq_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ɓoɓɛlɛ, mokyɛngyɛsi aesi ya onga tala, anyɔsi izele o motema, katɛkyɛnɛlɛ na sina inganga, aesi ya mivaka o makolo ma Polo na Silasi. ");
INSERT INTO loq_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Aesi ya ɓatɔkɔlɔ o nze, yokye: «Ɓatata, nakyele ɓo oɓokye nabikye?» ");
INSERT INTO loq_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ɓɛkye: «Anola Nkolo Yesu, wamobika, na wɛ, na iɓota sa wɛ.» ");
INSERT INTO loq_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ɓaesi ya moimola Simo ya Nkolo, yo na ɓato ɓasɔ ɓaaɓaka o ingambi sɛ. ");
INSERT INTO loq_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Na sina imbɛlɛ mɛ sa mokɔlɔ, mokyɛngyɛsi aesi ya ɓakpa oka yɛ, aɓakunyosi maphota ma ɓɛ. Ɓoɓɛlɛ, ɓaesi ya moɓatisa yo na iɓota sɛ sisɔ. ");
INSERT INTO loq_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Amba ya nyɔsa Polo na Silasi o ingambi sɛ, aɓaphɛ ntoma ya izaa. Moto mɛ na iɓota sɛ sisɔ ɓatondaka na nkyisa phɔ ɓaanolaka Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Wayɛ bunya, ɓananga ɓa Ɓaloma ɓaesi ya toma ɓato oɓokye ɓakyɛ wɔ na mokyɛngyɛsi, ɓatɔkɔlɔ ɓato ɓaɓana. ");
INSERT INTO loq_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Mokyɛngyɛsi aesi ya imola Polo, yokye: «Ɓananga ɓatomi ɓato iya imola oɓokye ɓaetɔkɔlɔ. Uŋwaŋwa ye, emba tɔkɔlɔ, okyɛndɛ na ɓolaa.» ");
INSERT INTO loq_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Kasi Polo aesi ya wɔ na ɓato mɛ, yokye: «Ɓalowanda phimbo o miyo ma ɓato ɓasɔ, mɛna sa taa lotenela ɓolombe, ɓanga toli ɓato ɓa Loma! Ɓalovakyi o Ɓɔlɔkɔ. Uŋwaŋwa ye, ɓakule luka ilotɔkɔlɔ mi iɓombo? Pha! Ɓaya lotɔkɔlɔ ɓɛ́ɛ mampenza!» ");
INSERT INTO loq_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Ɓato ɓaatomaka ɓɛ́ɛ ɓaesi ya kyɛ imola maphɔɔ mɛ oka ɓananga ɓa Ɓaloma. Ɓananga mɛ ɓailaka, waoka ɓɛ́ɛ oɓokye Polo na Sila ɓali ɓato ɓa Loma. ");
INSERT INTO loq_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Emba ɓamba ya kyɛ ɓaonga ɓolimbisi, ɓaɓatɔkɔsi o bɔlɔkɔ, ɓamba ya onga na ɓɛ́ɛ oɓokye ɓamane o mokyisi mɛ. ");
INSERT INTO loq_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Watɔkɔlɔ Polo na Silasi o bolɔkɔ, aesi ya kyɛndɛ oka Lidi. Waunva ɓɛ́ɛ ikyeka ɓande na ɓɛ, na iɓalenza, ɓamba ya kyɛndɛ. ");
INSERT INTO loq_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Ɓaesi ya lekana o Afipolis na Apoloni, ɓakyɛ koma o Tesaloniki waaɓaka ingambi sa makyita sa Ɓayuda. ");
INSERT INTO loq_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Polo, ɓo wamɛlɛ yo, amba ya nyɔlɔ o ingambi sa makyita sa Ɓayuda, awɔnɔkɔ na ɓɛ̀ɛ ɓa Saɓata ɓaato mi makomi ma Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Aɓalimɓolelaka makomi mɛ, aɓateyaka, yokye: «Esengyesi oɓokye Masiya awɛnɛ ɓolɔsi, awe, akundwe onte ya ɓawe.» Aɓawɔlɛkyɛ, yokye: «Yesu okoeyimole nga, eli yo Masiya.» ");
INSERT INTO loq_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ɓana onte ya ɓɛ, ɓaesi ya anola ɓaɓengyi na Polo na Silasi. Na moluku ŋwa Ɓaela ɓaaɓaka ɓasambele Ŋwaphongo, na ɓaɓasi ɓaikye ɓa kaa. ");
INSERT INTO loq_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Kasi Ɓayuda ɓatondaka na zuwa. Ɓaesi ya kpa ɓana nzoɓo ɓaazwaka ɓɛ́ɛ o nzela, ɓakyɛ angyinya eɓoko ya ɓato. Ɓamba yaambya mobulu onte ya mokyisi. Ɓaesi ya kyɛndɛ o ingambi sa Yasona, ikyɛ luka Polo na Silasi oɓokye ɓakyɛ na ɓɛ́ɛ o ɓoo pha ɓato ɓasɔ ɓa Tesaloniki. ");
INSERT INTO loq_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Waɓa ɓɛ́ɛ sa ɓazwa, ɓaesi yaakya Yasona na ɓɛbi ɓayɔkɔ, ɓakyɛ na ɓɛ́ɛ o ɓoo pha ɓananga ɓa mokyisi, ɓaaŋwanaka, ɓɛkye: «Ɓato ɓaɓa ɓabunzinye maumunya ma munse munsɔ, uŋwaŋwa ye ɓaesi ya koma wawa! ");
INSERT INTO loq_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Yasona aɓabuye oka yɛ! Ɓato mɛ ɓasɔ ɓaɔtɔ miɓeko ma Moangyesi Kaisala, awɔ oɓokye mokonzi mosuu ali, nkomo yɛ Yesu.» ");
INSERT INTO loq_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Maphɔɔ mamana maesi ya phɛ ɓato ɓasɔ na ɓananga ɓa mokyisi yɔɔ. ");
INSERT INTO loq_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Yasona na ɓɛbi mɛ ɓayɔkɔ ɓaesi ya tukya ɓaphalanga oka ɓananga ɓa mokyisi, ɓamba ya ɓalɛ, ɓakyɛ. ");
INSERT INTO loq_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Waamokɔlɔ ɓande ɓaesi ya toma Polo na Silasi o Bere. Waakoma ɓɛ́ɛ omɔ, ɓaesi ya kyɛ nyɔlɔ o ingambi sa makyita sa Ɓayuda. ");
INSERT INTO loq_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Ɓayuda mɛ ɓaɓaka ɓato ɓalaa ileka ɓaa Tesaloniki. Ɓaesi ya anola Simo ya Ŋwaphongo na motema molaa. Ɓaɓaka ɓaekole makomi nkɔlɔ isɔ, oɓokye ɓaeɓe maphɔɔ maaɓaka Polo kawɔ mali phɛlɛ. ");
INSERT INTO loq_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ɓato ɓaikye onte ya ɓɛ́ɛ ɓamba ya anola, onte ya Ɓaela, ɓato ɓaikye ɓa kaa, ɓaɓasi na ɓampele, ɓamba ya anola mɛ. ");
INSERT INTO loq_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Kasi waoka Ɓayuda ɓa Tesaloniki oɓokye Polo akyɛ imola Simo ya Ŋwaphongo o Bere, ɓamba ya kyɛndɛ omɔ, ɓakyɛ losa moluku ŋwa ɓato na iɓabunzinya maumunya. ");
INSERT INTO loq_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Sakɔkɔ, ɓande ɓaesi ya loya Polo mopha ŋwa maa manɛnɛ, Silasi na Timote ɓaikalaka o Bere. ");
INSERT INTO loq_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Ɓaakyɛkyɛ na Polo, ɓamba kyɛ moika nɔnɔ o Atɛnɛ. Emba waya butwa ɓɛ́ɛ o Bere, Polo amba ya lɔngɔlɔ Silasi na Timote oɓokye ɓamoɓengye izele. ");
INSERT INTO loq_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Waaɓa Polo kaziya Silasi na Timote o Atɛnɛ, aokaka ɓolɔsi o ndondo yɛ na ɓoikye iwɛnɛ ndengye eyatonda mokyisi mɛ na manzambe ma bikyeko. ");
INSERT INTO loq_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ateyaka o Ingambi sa makyita, yo na Ɓayuda, na ná ɓato ɓaateɓali Ɓayuda, ɓaasambele Ŋwaphongo. Na o zando, ateyaka nkɔlɔ isɔ ɓato ɓaavanaka nɛ wamɔ. ");
INSERT INTO loq_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ɓateye ɓa Epikiriɛ na ɓa Stoisiɛ ɓawɔnɔkɔ nɛ. Ɓana ɓɛkye: «Nyaewɔ oyo kalukye wɔɔ ɓo?» Ɓayɔkɔ, waoka ɓɛ́ɛ Polo kaimole Simo ya Yesu, na maphɔɔ ma ikundwa sa ɓawe, ɓɛkye: «Kolo kaloimole manzambe masuu.» ");
INSERT INTO loq_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ɓaesi ya mokpa, ɓakyɛ nɛ o ɓo pha ɓananga ɓaangane o ngomba ya Aaropaje, ɓawɔ nɛ, ɓɛkye: «Mateya mɛ manyakune maateya wɛ mali iye? Ɓanga tozingye imaeɓa, ");
INSERT INTO loq_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","phɔ matoo ma ɓanga maokyi maphɔɔ ma inganga, tolukye eeɓa maphɔɔ mɛ malukye iwɔ ɓo.» ");
INSERT INTO loq_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Na ɓomɔ ɓato ɓasɔ ɓa Atɛnɛ, na ɓabutu ɓaya onte ya ɓɛ, etoma ya ɓɛ́ɛ yabutwaka nde iwɔkɔ na iokaka maphɔɔ manyakune. ");
INSERT INTO loq_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Polo aesi ya tɛmɛ o ntante ya ɓananga, yokye: «Ɓɛ ɓato ɓa Atɛnɛ, nawɔ na ɓɛ́ɛ oɓokye oli phɛlɛ ɓaakolo ɓasambesi. ");
INSERT INTO loq_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Phɔ, waɓe nga nalekane o mokyisi ŋwa ɓɛ, nawɛni bikyeko biisambele ɓɛ, nawɛni na mɛsa elele yɔnɔyɔ ekyeambya ɓɛ́ɛ mandaa, ɓakoma o ikolo ɓoɓo: “Oka nzambe otoeɓane.” Iyo okosambele ɓɛ́ɛ sa moeɓa, eli yo okoeyimole nga. ");
INSERT INTO loq_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Ŋwaphongo owakyela mokyisi na isɔ ili omɔ, ali Nkolo ya ikolo na ya munse, taazale o ɓatempelo, ɓaatonga ɓato. ");
INSERT INTO loq_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Tasengyesi na oɓokye ɓato ɓamophɛ eɓe na ekpele iye, phɔ eli yo okophɛ ɓato ɓasɔ ɓomɔɔ na mpema ná mbolo isɔ. ");
INSERT INTO loq_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Uta na moto mɔnɔmɔ, akyela maɓota masɔ, oɓokye ɓazale o munse munsɔ. Aɓamekyela imbɛlɛ sa elanga na sa mampela, na mandelo ma makyito maasengyesi ɓɛ́ɛ izala. ");
INSERT INTO loq_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Akyela ɓaɓona phɔ ɓato ɓamolukye, na ɓo bazwe kamba phɔ ya imoluka, naa ɓakokyi imozwa. O solongo, Ŋwaphongo tali itakye na ɓanga ɓasɔ. ");
INSERT INTO loq_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Phɔ “eli yo moto okolophɛ ɓomɔɔ, na ɓokusi pha ikyɛ mitambula. Toli o munse mumu nde phɔ yɛ.” Na ɓakombi ɓa ɓɛ́ɛ ɓaayɔkɔ, ɓɛkye: “Na ɓanga, toli ɓana ɓɛ́ɛ mɛ.” ");
INSERT INTO loq_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Ɓo oli ɓanga ɓana ɓɛ, tolokokyi umunya oɓokye Ŋwaphongo akokaa na bikyeko ɓa itela, eɓe ɓa ebuni ya motiya, eɓe ɓa iɓanga, mbolo yaakyelama na maumunya ma moto. ");
INSERT INTO loq_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ŋwaphongo taakule ɓenga imbɛlɛ saatesaikaka moeɓa ɓato. Kasi uŋwaŋwa eye kaimole ɓato ɓasɔ, o bilele bisɔ, oɓokye ɓaɓongole ntema ya ɓɛ. ");
INSERT INTO loq_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Phɔ ameka mokɔlɔ mɔnɔmɔ ŋwamotenela yo munse munsɔ phaakolo ɓolombe, na nzela ya moto owa somya yo. Ateya ɓato ɓasɔ, ɓo wakundola yo moto mɛ onte ya ɓawe oɓokye eli phɛlɛ.» ");
INSERT INTO loq_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Waoka ɓɛ́ɛ Polo kawɔ na ikundwa sa ɓawe, ɓana ɓamoɛkyɛkyɛ, ɓayɔkɔ ɓɛkye: «Tomokula eyoka kowɔ lowɔɔ lalona mokɔlɔ mosuu.» ");
INSERT INTO loq_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ɓoɓɛlɛ, Polo aesi ya mana onte ya ɓɛ, akyɛ. ");
INSERT INTO loq_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Ɓana ɓamoɓengaka, ɓamba ya anola, onte ya ɓɛ, yaɓaka Denisi, mɔnɔmɔ na ɓananga ɓaangane o ngomba ya Aeropaje, na ŋwaŋwasi mɔnɔmɔ na nkombo Damaris, na ɓato ɓasuu mɛ. ");
INSERT INTO loq_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Sima ya maphɔɔ mamana, Polo aesi ya mana o Atɛnɛ, akyɛ o Koliti. ");
INSERT INTO loq_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Omɔ, akyɛ vana na Moyuda mɔnɔmɔ, nkombo yɛ Akilas, mokyisi nwɛ Pɔntis. Iyo na ŋwaŋwasi wɛ, Prisilɛ, auta o Itali, phɔ moangyesi Klode atomaka oɓokye Ɓayuda ɓasɔ ɓamane o Loma. Polo aesi ya kyɛ miɓanza na ɓɛ. ");
INSERT INTO loq_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Ɓowaɓaka yo kakyele etoma ndengye yɔnɔyɔ na ɓɛ, amba ya kyɛ zala oka, ɓabuto ikyela etoma elele yɔnɔyɔ. Etoma ya ɓɛ́ɛ yaɓaka ya ikyele ndalaku. ");
INSERT INTO loq_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Nkɔlɔ isɔ ya Saɓata, Polo aɓaka kateya Ɓayuda na Ɓaela o ingambi sa makyita. Alukaka oɓokye ɓasɔ ɓaanole. ");
INSERT INTO loq_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Wauta Silasi na Timote o Makedoniya, ɓaesi, Polo amiambyaka imbɛlɛ sisɔ iimolaka Simo ya Ŋwaphongo. Ateyaka Ɓayuda oɓokye Yesu ali Masiya. ");
INSERT INTO loq_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Kasi Ɓayuda, teɓaikaka moanola, ɓamotolaka. Ɓoɓɛlɛ, aesi ya ɓalasisa mobulubutu ŋwa bitobu ɓɛ, yokye: «Ɓo ɓɛ̀ɛ obungyi, tekuli ɓa lowɔɔ la nga, malongo ma ɓɛ́ɛ mali o moto ŋwa ɓɛ! Uŋwaŋwa ye, namokyɛndɛ oka ɓato ɓaateɓali Ɓayuda.» ");
INSERT INTO loq_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Aesi ya mana wamɔ, akyɛ oka moto mɔnɔmɔ owaɓaka kasambele Ŋwaphongo, nkombo yɛ Tito Yusutu. Ingambi sa moto mɛ saɓaka phɛnɛphɛ na ingambi sa makyita. ");
INSERT INTO loq_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Krispus, mokonzi ŋwa ingambi sa makyita, aesi ya anola Nkolo, yo na iɓota sɛ sisɔ. Ɓakoliti ɓaikye ɓaokaka Polo, ɓaesi ya anola mɛ, aɓaɓatise. ");
INSERT INTO loq_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Waa mokɔlɔ, Nkolo aesi ya wɔ na Polo o ndɔtɔ, yokye: «Sa ila, saikala ɓose, wɔkɔ nde ɓowɔ, ");
INSERT INTO loq_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","phɔ, inga, nali na wɛ elele yɔnɔyɔ. Moto etaeyakya oɓokye aekyele ɓoɓe, phɔ ɓato ɓaikye o mokyisi mumu ɓali ɓa nga.» ");
INSERT INTO loq_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Polo akyelaka o Koliti mbula yɔnɔyɔ na makombe motoɓa iimola ɓato maloɓa ma Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Wa imbɛlɛ saɓaka Galion moangyesi wa nkyisi ya Akaye, Ɓayuda ɓaesi ya wangyela Polo na ɓoɓe. Ɓakyɛ nɛ o ɓoo pha ɓato ɓaasambisa maphɔɔ. ");
INSERT INTO loq_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Ɓɛkye: «Moto oyo katomisa ɓato oɓokye ɓasambele Ŋwaphongo na ndengye eteɓenele moɓeko.» ");
INSERT INTO loq_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Waluka Polo oɓokye kawɔ, Galion aesi ya wɔ na Ɓayuda, yokye: «Ɓo eɓakyi oɓokye aɓomi moto, naa akyesi lowɔ lɔnɔlɔ loolekyi ɓoɓe, nde naanolakyi iphunda sa ɓɛ̀ɛ, oo Ɓayuda, ndeoɓakyi na elongyi. ");
INSERT INTO loq_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Kasi tɔkɔ ya ɓɛ̀ɛ oli yango nde phɔ ya ianola, phɔ ya ma nkombo na miɓeko ma ɓɛ̀ɛ mampenza, mɛna ekyekyi ɓɛ̀ɛ! Nga sikokyi iɓa munanga i maphɔɔ ma ndengye mɛna!» ");
INSERT INTO loq_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Amba ya ɓawiinya o elele ekyeambe ɓɛ́ɛ maphɔɔ. ");
INSERT INTO loq_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ɓoɓɛlɛ, ɓasɔ ɓaesi ya akya Sositɛnɛ, mokonzi ŋwa ingami sa makyita sa Ɓayuda, ɓabuto imowanda o ɓoo pha elele ekyeambe maphɔɔ. Kasi Galion akyekaka nde ɓaɓona. ");
INSERT INTO loq_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Polo akulaka kɔkɔ o Koliti na ɓoikye. Ɓoɓɛlɛ, aikyi ika ɓɛbi, abaa o masuwa, akyɛ o Siri, yo na Prisilɛ na Akilas. Oɓoo pha iba o masuwa, amikololaka moto o Sasele, phɔ aunvaka nkɔlɔ yaalakyelaka yo Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ɓaesi ya koma o Efese, Polo aikaka Prisilɛ na Akilas omɔ. Aesi ya kyɛ nyɔlɔ o ingambi sa makyita sa Ɓayuda, kaikye ziiko omɔ na Ɓayuda. ");
INSERT INTO loq_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ɓaongaka nɛ oɓokye akɔkɔ omɔ, kasi yo taikaka anola. ");
INSERT INTO loq_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Aikyi ɓaika, yokye: «Bo Ŋwaphongo azingyi, namokula ya oka ɓɛ.» Aesi ya ba o masuwa o Efese, akyɛ. ");
INSERT INTO loq_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Wakoma yo o Sezare, aesi ya uta, akyɛ o Yelusalɛmɛ phɔ ya iɓeya ɓɛbi ɓa ingomba. Ɓoɓɛlɛ, amba ya kyɛndɛ o Antioshe. ");
INSERT INTO loq_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Akyelaka ɓanaa nkɔlɔ omɔ. Amba kula ya kyɛndɛ, aakasi Galati na Friji, alenze ianola sa ɓaekosi ɓasɔ. ");
INSERT INTO loq_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Moyuda mɔnɔmɔ, nkombo yɛ Apolo, mokyisi nwɛ Alegizandri, akomaka o Efese. Aɓaka moto mɔnɔmɔ wa yelaa ya iwɔɔ, aeɓaka makomi ma Ŋwaphongo na ɓolaa. ");
INSERT INTO loq_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Aunva ekola phanza maphɔɔ ma nzela ya Ŋwaphongo, aɓaka na phowa ekusi, aimolaka, ateyaka nde maphɔɔ ma Yesu. Kasi yo, aeɓaka nde iɓatisa saka Yoane. ");
INSERT INTO loq_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Aesi ya tata iwɔ pwapwa o ingambi sa makyita. Prisilɛ na Akilas, wamooka ɓɛ, ɓaesi ya mokpa, ɓakyɛ molimbolela nde maphɔɔ ma nzela ya Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Kasi waɓa Apolo na phowa ya ikyɛndɛ o Akaye, ɓɛbi ɓaesi ya molenza mi lowɔɔ mɛ. Ɓakomi mokanda, ɓamotomesi ɓaanosi ɓa mokyisi mɛ oɓokye ɓamokumbele na ɓolaa. Waakoma yo omɔ, asungaka ɓato ɓaanolaka na ngɔlu ya Ŋwaphongo, ");
INSERT INTO loq_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","phɔ, anyɛtɛkyɛ phɛlɛ Ɓayuda, o miyo ma ɓato ɓasɔ, na maphɔɔ maaɓawɔlɛkyɛ yo. Aɓateyaka o makomi ma Ŋwaphongo oɓokye Yesu ali Masiya. ");
INSERT INTO loq_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Wataaka ɓa Apolo o Koliti, Polo amba ya lekana o nkyisi ya mambale, akyɛ koma o Efese. Azwe ɓaekosi ɓaayɔkɔ omɔ. ");
INSERT INTO loq_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Aesi ya ɓatuna, yokye: «Waanola Ŋwaphongo, wazwa Ɓolɔɓɔ Ɓosantu?» Ɓɛkye: «Ɓanga toloika na oka ɓawɔ oɓokye Ɓolɔɓɔ Ɓosantu ali.» ");
INSERT INTO loq_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Polo, yokye: «Emba wazwa iɓatisi siwaa?» Ɓɛkye: «Iɓatisi saaka Yoane.» ");
INSERT INTO loq_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Polo, yokye: «Yoane aɓaka kabatisa ɓaanolaka iɓongola mandondo ma ɓɛ, ambaka wɔ na Ɓayuda, yokye: Ɓaanole owamoya o sima yɛ, kyelukye iwɔ oɓokye Yesu.» ");
INSERT INTO loq_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Waoka ɓɛ́ɛ ɓaɓona, ɓaesi ya ɓatisama na nkombo ya Nkolo Yesu. ");
INSERT INTO loq_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Polo amba ya ɓatandela maɓɔkɔ, ɓaesi ya zwa Ɓolɔɓɔ Ɓosantu, ɓabuto iwɔ nɔkɔ nsuu, na imola Simo ya Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ɓato mɛ ɓaɓaka ɓasɔ phɛnɛphɛ iko mbuka iɓale. ");
INSERT INTO loq_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Ɓoɓɛlɛ, Polo amba ya kyɛndɛ o ingambi sa makyita sa Ɓayuda, aɓaimolaka pwapwa Simo ya Ŋwaphongo. Ɓalukaka oɓokye ɓato ɓaamookye ɓaanole maphɔɔ ma ɓokonzi pha Ŋwaphongo. Akyelaka ɓomɔ makombe maato. ");
INSERT INTO loq_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Kasi ɓayɔkɔ ɓakyelaka moto ɓokusi, teɓaikaka ɓaanola, ɓatiyolaka nzela ya Ŋwaphongo oɓoo pha ɓato ɓasɔ. Ɓoɓɛlɛ, Polo aesi ya ɓaika, akpe ɓaekosi, akyɛ na ɓɛ, aɓateyaka nkɔlɔ isɔ o Ingambi sa kalasi ya Tiranus. ");
INSERT INTO loq_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Akɔkɔkɔ omɔ mambula maɓale, emba na ɓomɔ, ɓato ɓasɔ ɓaazalaka o Azi, Ɓayuda, na ɓaateɓali Ɓayuda, ɓamba ya oka Simo ya Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Ŋwaphongo akyelaka bilekyesako ɓa ikamwa na nzela ya Polo. ");
INSERT INTO loq_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Yango mɛna, ɓato ɓaayɔkɔ ɓaphilelaka ɓato ɓa malɔsi, bitobu, na bitato baakumaka nzoto ya Polo. Malɔsi ma ɓato mɛ mamanaka, na malɔɓɔ maɓe matɔkɔlɔkɔ o nte ya ɓɛ. ");
INSERT INTO loq_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ɓana Bayuda ɓaaɓaka ɓakyɛ mitambula phɔ ya iwinya malɔɓɔ maɓe onte ya ɓato ɓa malɔsi, ɓaɓaka ɓatangye na nkomo ya Nkolo Yesu phɔ ya itɔkɔlɔ malɔɓɔ mɛ. Ɓaɓaka ɓawɔ, ɓɛkye: «Na nkombo ya Yesu, okoteya Polo, nawɔ na ɓɛ, malɔɓɔ maɓe, oɓokye otɔkɔlɔ!» ");
INSERT INTO loq_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ɓato ɓaaɓaka ɓakyele ɓaɓona, yaɓaka ɓana ɓa ɓampele sambo ɓa nganga munɛnɛ, Moyuda, nkombo yɛ Sekewa. ");
INSERT INTO loq_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ɓolɔɓɔ ɓoɓe ɓoɓabuyise oɓokye: «Nga naeɓe Yesu, naeɓe na Polo, kasi ɓɛ, oli ɓanza?» ");
INSERT INTO loq_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ɓoɓɛlɛ, moto owaɓaka na ɓolɔɓɔ ɓoɓe aesi ya mivaka miɓɛ. Aŋwani na ɓɛ, aɓalekaka na mwiya, ɓaesi ya tɔkɔlɔ o iɓanda, ɓaloti ɓɛ́ɛ ɓasɔ malumbu, ɓazokyi na maphota. ");
INSERT INTO loq_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ɓato ɓasɔ ɓa Efese, Ɓayuda na ɓaateɓali Ɓayuda, waoka lowɔ mɛ ɓailaka, ɓabutwaka ikpa nkombo ya Nkolo Yesu na kaa ikye. ");
INSERT INTO loq_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ɓato ɓaikye ɓabutwaka ɓaanosi, ɓayakaka ya yaimola maphɔɔ maakyelaka ɓɛ, ɓamaimolaka o ɓoo pha ɓato ɓasɔ. ");
INSERT INTO loq_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Onte ya ɓato ɓaaɓaka na meete, ɓaikye ɓayakaka na nkanda ya meete, ɓaitumbaka o miyo ma ɓato ɓasɔ. Watanga ɓɛ́ɛ nkanda mɛ, motiya ŋwa yɛ ŋwakokanaka na ɓaphalanga ɓa biɓende nkoto mako matano (50.000). ");
INSERT INTO loq_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Na ɓomɔ, na mwiya ŋwa Nkolo, Simo Elaa yanyangwaka na ɓoikye. ");
INSERT INTO loq_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Sima ya maphɔɔ mamana, Polo aesi ya kana ikatisa Makedoniya na Akaye oɓokye akyɛndɛ o Yelusalɛmɛ. Yokye: «Ɓo nakomi omɔ, esengyesi oɓokye nakome na o Loma.» ");
INSERT INTO loq_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Atomaka ɓɛbi nɛ ɓaɓale ɓaamosungye o etoma, Timote na Eraste o Makedoniya, kasi yo akulaka kuta kɔkɔ o nkyisi ya Azi. ");
INSERT INTO loq_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Imbɛlɛ mɛ, tɔkɔ iikye yatɔkɔlɔkɔ phɔ ya maphɔɔ ma nzela ya Nkolo. ");
INSERT INTO loq_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Motusi mɔnɔmɔ, nkombo yɛ Demetelius, aɓaka katule ɓatempelo ɓa nzambe Artemis na eɓende ya motiya. Azwaka ɓaphalanga o etoma mɛ, aphutaka na ɓolaa ɓaakyele nɛ. ");
INSERT INTO loq_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Aesi ya aangana na ná ɓato ɓasuu ɓaakyele etoma ɓo ekyekyele yo. Yokye: «Ɓande, koeɓe oɓokye ɓanga tobikye nde na etoma ekyekyele ɓanga eye. ");
INSERT INTO loq_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ɓo kowɛnɛ, kombe na kula oka maphɔɔ maakyele Polo, yokye: Manzambe maakyelama na nsɛ ya ɓato temali manzambe. Aɓongosi maumunya ma ɓato ɓaikye. Teli nde wawa na wawa o Efese, kasi phɛnɛphɛ nde o nkyisi ya Azi isɔ. ");
INSERT INTO loq_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Lowɔ mɛ nde lɔɔti etoma ya ɓanga, nde lombi na kula buya tempelo ya nzambe munɛnɛ owa ŋwaŋwasi, Artemis, ekpele pha, nzambe mɛ okosambele ɓato ɓa Azi, na ɓato ɓa mokyisi munsɔ, nde takuli ɓa na kaa!» ");
INSERT INTO loq_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Waoka ɓato maphɔɔ mamana, ɓatondaka na yɔɔ, ɓaaŋwanaka ɓɛkye: «Ali nzambe munɛnɛ, Artemis wa Ɓaefese!» ");
INSERT INTO loq_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Mokyisi munsɔ moesi ya tonda na tɔkɔ, ɓato ɓasɔ ɓawelane ikyɛndɛ o elele ya maano. Ɓaakyaka na ɓato ɓa Makedoniya ɓaɓale ɓaaɓaka ɓatambule na Polo elele yɔnɔyɔ o imbanga sɛ, Gayusu na Aristarke. ");
INSERT INTO loq_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Polo aunvaka mitɔkɔlɔ o ɓo pha eɓoko ya ɓato, kasi ɓaekosi ɓamokatelaka. ");
INSERT INTO loq_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Ɓankumu ɓaayɔkɔ ɓa nkyisi ya Azi, ɓaali ɓikamba ɓa Polo, ɓamolɔngɔlɔkɔ phɔ ya imoɓɔndɔ oɓokye yo sa kyɛndɛ o elele ya maano. ");
INSERT INTO loq_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","O elele eyaanganaka ɓato, tɔkɔ yalɔɓɔkɔ. Ɓaná ɓaaŋwane lowɔ lolo, ɓaayɔkɔ ɓaaŋwane na lowɔ losuu, ɓaikye onte ya ɓɛ́ɛ teɓaikaka eɓa na ntina eyaanganaka ɓɛ. ");
INSERT INTO loq_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ɓayuda Ɓamba ya lekyinya moto monɔmɔ o ɓoo pha eɓoko mɛ na nkombo Alegizandre. Ɓato ɓaayɔkɔ ɓaaɓaka wamɔ ɓamoimolaka maphɔɔ maalekanaka. Ɓoɓɛlɛ, Alegzandre aesi ya tomba eɓɔkɔ o ikolo, alukaka iyambelela Ɓayuda. ");
INSERT INTO loq_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Waeɓa ɓɛ́ɛ nde oɓokye ali Moyuda, ɓaesi ya aŋwana, ɓɛ́ɛ ɓasɔ mbala yɔnɔyɔ, ɓɛkye: «Artemis wa Ɓafese! Ali nzambe munɛnɛ!» Ɓaaŋwanaka ɓabona phɛnɛphɛ mangonga maɓale. ");
INSERT INTO loq_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Emba nkumu monɔmɔ wa mokyisi mɛ, amba ya zibisa eɓoko ya ɓato, yokye: «Bɛ Ɓaefese, ɓato ɓasɔ ɓaeɓe oɓokye mokyisi ŋwa Ɓaefese ɓaɓanza tempelo ya omunɛnɛ, Artemis, na ekyeko yɛ eyauta o ikolo ya kaa o se. ");
INSERT INTO loq_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Moto takokyi ika ziiko na lowɔɔ mɛ. Na ɓomɔ, uya mɔ, oumunya o ɓoo pha ikyela lowɔɔ. ");
INSERT INTO loq_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Oesi na ɓato ɓaɓa wawa, kasi teɓaikyi ɔtɔ tempelo ya ɓanga, teɓaikyi tola na nzambe ya ɓanga. ");
INSERT INTO loq_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Ɓo Demetelius na ɓato ɓali na lowɔɔ na moto monɔmɔ, elele ekyeambe ŋwambo eli, na ɓananga ɓali, ɓakyɛ songyela! ");
INSERT INTO loq_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ɓoli na lowɔ losuu la ituna, tooloɓɔngya waangane ɓato ɓasɔ ɓo kowɔ moɓeko. ");
INSERT INTO loq_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Mi maphɔɔ maleka lɔlɔ, iikasi ŋwana ɓokyi ɓoɓo, ɓalosongyele oɓokye totɛmbi. Na ɓomɔ, otoloɓe na ná elongyi yɔnɔyɔ ya imola ɓato ntina ya angana sisi.» ");
INSERT INTO loq_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Waunva yo iwɔ ɓaɓona, aesi ya buya ɓato, ɓakyɛ mibutwa oka ɓɛ. ");
INSERT INTO loq_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Waunva tɔkɔ, Polo amba yaangyinya ɓaanosi, aɓalenze, sima aesi ya ɓaika, akyɛ o Makedoniya. ");
INSERT INTO loq_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Alekanaka o nkyisi mɛ, kakyɛ milenza ɓaanosi na mateya maikye. Ɓoɓɛlɛ, aesi ya kyɛndɛ o Grɛsɛ. ");
INSERT INTO loq_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Akyelaka omɔ makombe maato. Aunvaka baa o masuwa phɔ akyɛndɛ o Siri. Waoka yo oɓokye omɔ Ɓayuda ɓamowangyele, ɓoɓɛlɛ, aesi ya kana ibutwa o nzela ya Makedoniya. ");
INSERT INTO loq_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Ɓato ɓakyɛkyɛ moika ɓaɓa: Sopatele, ŋwana wa Pirus, mokyisi nwɛ Bere, Aristarke na Sekundus, ɓato ɓa Tesaloniki, Galion moto wa Dɛrbɛ, Timote, Tishikɛ na Trofime, ɓato ɓa Azi. ");
INSERT INTO loq_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Moluku mɛ ɓakyɛkyɛ o ɓoo, ɓakyɛ loziya o Troas. ");
INSERT INTO loq_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Ɓanga, sima ya eyenga ya umunya itɔkɔlɔ sa Ɓayisalaɛlɛ o Ezipito, toesi ya baa o masuwa o Filipi. Sima ya nkɔlɔ itano, tokyɛ ɓazwa o Troas, tokyelaka omɔ nkɔlɔ sambo. ");
INSERT INTO loq_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Mokɔlɔ ŋwa pɔsɔ, wa nkɔkɔlɔ, toanganaka phɔ ya izaa, Polo awɔnɔkɔ na ɓaekosi. Waaɓa oɓokye ɓamokyɛndɛ ɓoyana, aesi ya teya nɔnɔ waa molengyela. ");
INSERT INTO loq_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ɓatala ɓaɓaka ɓaikye o ingambi saanganaka ɓanga o ikolo. ");
INSERT INTO loq_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Munzenga mɔnɔmɔ, nkombo yɛ Etikos, azalaka o fɛnɛtɛlɛ. Imɓɛlɛ saaɓaka Polo kateya nde ɓoteye, yo azwaka ebuu na ɓokusi, mi ena ebu, aesi ya uta o etaze eya iyato, akaa nɔnɔ o se. Ɓamba ya motomba, awelakyi. ");
INSERT INTO loq_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Kasi Polo aesi ya uta, amiinye ooli munzenga mɛ, amokpe o maɓɔkɔ mɛ, yokye: «Ɓɛ sa lota, taikyi wa. Ali mumɔ!» ");
INSERT INTO loq_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Ɓoɓɛlɛ, akuli baa, ateni mapa, azee. Akulaka teya ɓoɓɛlɛ nɔnɔ wa mumengu. Waunva yo, amba ya kyɛndɛ. ");
INSERT INTO loq_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Ɓabutwaka na munzenga mɛ, abikyi na ná nzoto nkusi, ɓo waaka yo. Lowɔɔ mɛ labuyaka ɓato ɓasɔ na nkyisa ɓoikye. ");
INSERT INTO loq_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Ɓanga tokyɛkyɛ o ɓo oɓokye tobaa o masuwa maakyɛkyɛ na ɓanga o Asos, mokyisi ŋwakanaka Polo oɓokye tomokpesa o masuwa, phɔ yo mampenza azingaka itambula nzela mɛ na makolo. ");
INSERT INTO loq_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Wakyɛ lozwa yo o Asos, tomokpese o masuwa, tokyɛ ɓanga ɓasɔ o Mitilɛnɛ. ");
INSERT INTO loq_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Toesi ya mana wamɔ, ɓoyana tokyɛ sɛmɛ, tokyekane na esanga ya Kio. Mokɔlɔ ŋwa sima, toesi ya katisa o esanga ya Samos, sima ya mokɔlɔ mamuna, tomba ya kyɛ sɛma o Milɛtɛ. ");
INSERT INTO loq_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Polo taikaka zinga isɛmɛ o Efese, phɔ ya oɓokye yo sa ngɔmbɔnɔ o nkyisi ya Azi. Aɓaka kawelane oɓokye, ɓo walongoɓa, ɓakome o Yelusalɛmɛ o eyenga ya Pantekote. ");
INSERT INTO loq_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Wasɛmɛ masuwa o Milɛtɛ, Polo aesi ya lɔngɔlɔ ɓakumu ɓa Efese oɓokye ɓaya vana nɛ omɔ. ");
INSERT INTO loq_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Waya koma ɓɛ́ɛ waali yo, yokye: «Ɓɛ koeɓe moɓesi ŋwa nga, nkɔlɔ isɔ yaaɓaka nga na wawa tata nɔnɔ mokɔlɔ ŋwakomaka nga o Azi. ");
INSERT INTO loq_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Nakyelelakyi Nkolo na imiuya sisɔ, na mbembe o matama nawɛnɛkyɛ na mpasi phɔ ya maphɔɔ maaɓaka Ɓayuda ɓanvangyele. ");
INSERT INTO loq_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Ɓo, koeɓe oɓokye sikyi ezitela maphɔɔ maakokyi iesunga, naeyimosi masɔ, naeteye eɓe o ɓo pha ɓato ɓasɔ, eɓe o mangambi ma ɓɛ. ");
INSERT INTO loq_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Naimosi Ɓayuda na ɓaateɓali Ɓayuda oɓokye ɓaɓongole mandondo ma ɓɛ, ɓabutwe ɓato ɓa Ŋwaphongo, ɓaanole Nkolo wa ɓanga, Yesu. ");
INSERT INTO loq_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Kyeka, uŋwaŋwa eye, nakyɛndɛ o Yelusalɛmɛ, o kontome Ɓolɔɓɔ Ɓosantu, sieɓe maphɔɔ mamunzelela omɔ. ");
INSERT INTO loq_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Naeɓe nde oɓokye o mokyisi na mokyisi mookyɛ nga, Ɓolɔɓɔ Ɓosantu kanzimole nde phanza oɓokye bɔlɔkɔ na minyɔkɔ kyinziya. ");
INSERT INTO loq_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Kasi phɔ ya nga, nawɛnɛ oɓokye ɓomɔ pha nga teɓoli na ntina, phowa ya nga eli oɓokye nakomya imbanga sa nga o suka, naunve etoma empɛ Nkolo Yesu, Imola Simo Elaa eya ngɔlu ya Ŋwaphongo.» ");
INSERT INTO loq_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","«Nalekanaka onte ya ɓasɔ ikyɛ mimola ɓokonzi pha Ŋwaphongo. Kasi uŋwaŋwa ye, naeɓe oɓokye nɔnɔ mɔnɔmɔ na ɓɛ́ɛ etaakule nvɛnɛ. ");
INSERT INTO loq_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Yango mɛna, naewɔlɛ lɔlɔ oɓokye: Ɓo mɔnɔmɔ na ɓɛ́ɛ abungyi nzela ya Ŋwaphongo, tekuli ɓa lowɔ la nga, ");
INSERT INTO loq_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","phɔ sikyi ezita, naeyimosi maphɔɔ masɔ maaɓɔngya Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Nde komiɓanza ɓɛ̀ɛ mampenza, nde koɓanza na ɓaanosi ɓasɔ. Ɓolɔɓɔ Ɓosantu aekyesi ndokolo ɓaɔkɔsi ɓa mampate. Okambakye ingomba sa Ŋwaphongo saaikola yo na malongo ma Sɔmi yɛ mampenza. ");
INSERT INTO loq_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Naeɓe, ngakye: O sima ya nga, ɓo nakyɛ, ɓato ɓaali ndokolo mangɔɔ maa vale, ɓamoya onte ya ɓɛ̀ɛ, ɓamunyangola mampate. ");
INSERT INTO loq_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Eɓe na onte ya ɓɛ̀ɛ, ɓato ɓayɔkɔ ɓamobutwa iwɔ maphɔɔ maa ɓɔlɛ, oɓokye ɓaanosi ɓaɓaɓengye. ");
INSERT INTO loq_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Yango mɛna nde komiɓanza, umunyaka oɓokye mambula maato, na moo na mokɔlɔ, na ná mbembe o matama, sikakyi lɛ iiyolela mɔnɔmɔ na mɔnɔmɔ na ɓɛ̀ɛ.» ");
INSERT INTO loq_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","«Uŋwaŋwa eye, naeyikye o maɓɔkɔ ma Ŋwaphongo. Simo yɛ ya ngɔlu yamoeɓanza. Eli na ikokyi sa iyelenza, na sa iephɛ ilaka saaɓomba yo phɔ ya ɓato ɓasɔ. ");
INSERT INTO loq_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Sikyi mengyela, eɓe ɓaphalanga, eɓe itela, eɓe bitobu ɓa moto. ");
INSERT INTO loq_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Koeɓe ɓɛ̀ɛ mampenza oɓokye nakyelakyi etoma na maɓɔkɔ ma nga mpenza, phɔ ya izwa isengyesi na nga na yaka ɓɛbi na nga. ");
INSERT INTO loq_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","O maphɔɔ masɔ mamana, mɛna naeteye oɓokye osengyesi ikyela etoma, phɔ osungakye ɓato ɓaakaya. Toumunya maphɔɔ maawɔkɔ Nkolo Yesu yo mpenza, oɓokye: “Nkyisa ya iphɛ, ilekyi nkyisa ya izwa!”» ");
INSERT INTO loq_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Waunva Polo iwɔ ɓaɓona, amba ya kusama na maɓɔngɔ, yo na ɓɛ, ɓaɓɔndɛsi. ");
INSERT INTO loq_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Ɓɛ́ɛ ɓasɔ ɓabutwaka ilela, ɓaakyinyaka na Polo phɔ ya imophɛ mbɔtɔ eya suka. ");
INSERT INTO loq_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Ɓaɓaka na ngɔngɔ ɓoikye, phɔ Polo awɔkɔ na ɓɛ, yokye: Eteɓakule mowɛnɛ. Ɓoɓɛlɛ, ɓamba ya kyɛ moika nɔnɔ o masuwa. ");
INSERT INTO loq_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Waamana ɓanga oka ɓɛ, tokuli ya kpela o masuwa. Toesi ya kyɛndɛ ɓoɓɛlɛ nɔnɔ o Kos. Ɓo yana, toesi ya kyɛ koma o esanga ya Rode, tomani omɔ, tokyɛ o Patara. ");
INSERT INTO loq_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Tozwaka omɔ masuwa maakyɛndɛ o Fenisi. Toesi ya baa o masuwa mɛ, tokyɛ. ");
INSERT INTO loq_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Toesi ya koma phɛnɛphɛ na esanga ya Shiprɛ, toesi ya mana o esanga phɔ ya ikyɛndɛ mopha ŋwa Siri emba tomba kyɛ aɓwa o Tir, phɔ masuwa maɓaka na mbolo ya iyaɓola omɔ. ");
INSERT INTO loq_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Toesi ya kyela omɔ nkɔlɔ sambo phɔ tozwaka ɓaanosi, na nwiya ŋwa Ɓolɔɓɔ Ɓosantu, ɓamba ya wɔ na Polo oɓokye yo sakyɛndɛ o Yelusalɛmɛ. ");
INSERT INTO loq_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Wakokya ɓanga nkɔlɔ ya iɓa na ɓɛ, tomba kula ya ɓenga imbanga sa ɓanga. Waɓa ɓanga totambule, ɓato ɓasɔ ɓamba ya kyɛ loika o eɓonga, na ɓaɓasi na ɓana. O eɓonga, tomba ya kusama na maɓɔngɔ o mokululu ŋwa maa maanɛnɛ, tomba ya ɓɔndɛlɛ. ");
INSERT INTO loq_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Ɓoɓɛlɛ, tomba ya kaɓwana. Ɓanga tomba ya baa o masuwa, emba ɓɛ́ɛ ɓamba ya butwa oka ɓɛ. ");
INSERT INTO loq_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Kasi phɔ ya ɓanga, wa uta ɓanga o Tir, wakatisa ɓanga, tomba ya koma o Ptolemais, emba waaunva ɓanga iɓeya ɓɛbi, tomba ya kyela na ɓɛ́ɛ mokɔlɔ mɔnɔmɔ. ");
INSERT INTO loq_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Ɓo yana, toesi ya lekana, tokyɛ koma o Sezare. Omɔ, tokyɛ uta o ingambi sa moteye wa Simo Elaa, nkombo yɛ Filipe, mɔnɔmɔ na ɓateye, emba tomba zala oka yɛ. ");
INSERT INTO loq_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Aɓaka na ɓana ɓa ɓaɓasi ɓane, ɓali sa taa eɓa ɓampele, ɓaɓaka ɓaimole maphɔɔ maute oka Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Wakyela ɓanga nkɔlɔ nzikye omɔ, yamba ya moimosi mɔnɔmɔ wa Yuda na nkombo Agabusu. ");
INSERT INTO loq_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Waya lokyeka yo, amba ya kpa nkamba ya Polo, amba ya mikanga na yango na maɓɔkɔ na makolo yokye: «Kyeka ɓokowɔ Ɓolɔɓɔ Ɓosantu. Mokolo ŋwa mokaɓa mumu, kyeka ɓo waamokanga ɓakonzi ɓa Ɓayuda o Yelusalɛmɛ na mokaɓa o maɓɔkɔ na o makolo, emba ɓamba moambya oka ɓaate ɓali Ɓayuda.» ");
INSERT INTO loq_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Waoka ɓanga ɓaɓona, ɓanga na ɓɛbi ɓa mokyisi, tomba ya ɓɔndɔ Polo oɓokye yo sakula kyɛndɛ o Yelusalɛmɛ. ");
INSERT INTO loq_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Ɓoɓɛlɛ yo, amba lobuyisa yokye: «Ɓɛɛ kolele phɔ ya intena maɓale phɔ ya'ye? Nga nali phɛnɛphɛ, teli de phɔ ya inkanga kasi na phɔ ya iwa o Yelusalɛmɛ phɔ ya nkombo ya Nkolo Yesu». ");
INSERT INTO loq_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Waɓa yo saanola, toloomba kula mokandindisa. Tomba wɔ nde oɓokye: «Mokano ŋwa Nkolo mokyelame!» ");
INSERT INTO loq_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","O sima ya nkɔlɔ mɛ, waunva ɓanga imiɓɔngya, tomba yakyɛndɛ o Yelusalɛmɛ. ");
INSERT INTO loq_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Ɓaekosi ɓaayɔkɔ ɓa Sezare ɓakyɛkyɛ loika, ɓamba kyɛ lolasa o ingambi sa Manasɔnɔ moto wa Shiprɛ, moekosi wa kalakala. ");
INSERT INTO loq_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Waakoma ɓanga o Yelusalɛmɛ, ɓɛbi ɓamba ya lokumbela na nkyisa. ");
INSERT INTO loq_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Ɓo yana, Polo aesi ya kyɛ na ɓanga oka Zake. Ɓankumu ɓa ingomba ɓasɔ ɓaanganaka omɔ. ");
INSERT INTO loq_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Polo aesi ya ɓaɓeya, aɓaimosi lowɔ lɔnɔlɔ na lɔnɔlɔ o maphɔɔ masɔ maɓakyelelaka Ŋwaphongo o etoma yɛ onte ya ɓato ɓateɓali Ɓayuda. ");
INSERT INTO loq_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Waoka ɓankumu maphɔɔ mɛ, ɓamba kumola Ŋwaphongo. Emba ɓamba ya wɔ na Polo, ɓɛkye: «Nwɛbi, owɛni Ɓayuda nkoto na nkoto, ɓabuto ɓaanosi, ɓasɔ ɓaɓengye miɓeko na ɓolaa. ");
INSERT INTO loq_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ɓaɓaimolaka oɓokye iwɛ koteya Ɓayuda ɓasɔ ɓaali onte ya maɓota mayɔkɔ oɓokye ɓalɛ moɓeko ŋwa Mose, kowɔ na oɓokye ɓɛ́ɛ saɓɛlɛ ɓana ɓa ɓɛ, ɓɛ́ɛ saɓenga miɓeko. ");
INSERT INTO loq_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Tokyele ɓo? Tewali ziko, ɓato ɓamooka oɓokye okomi wawa. ");
INSERT INTO loq_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Na ɓomɔ, kyela ɓo wamoewɔlɛ ɓanga. Toli wawa na ɓampele ɓane ɓaakata seleka. ");
INSERT INTO loq_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Oɓakpe, omikunyole na ɓɛ́ɛ elele yɔnɔyɔ, ombe ɓaphutela maphɔɔ masɔ. Ɓakokyi imikolola moto, emba ɓato ɓasɔ ɓamoeɓa oɓokye maphɔɔ maokaka ɓɛ́ɛ phɔ ya wɛ, mali maɓɔlɛ, kasi oɓokye wɛ koɓengye na wɛ ɓo okoongye Moɓeko. ");
INSERT INTO loq_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Phɔ ya ɓapakano ɓabutwa ɓaanosi, toɓakomela mokanda phɔ ya iɓaimola ɓo wakana ɓanga. Tokana oɓokye: Ɓɛ́ɛ sa zaa manyama maɓomesi ɓɛ́ɛ bikyeko, ɓɛ́ɛ sa zaa malongo, ɓɛ́ɛ sa zaa manyama mawe na malongo o motema, ɓɛ́ɛ sakyela ɓondumba.» ");
INSERT INTO loq_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Ɓoɓɛlɛ, mokɔlɔ ŋwa sima, Polo amba yakpa ɓato mɛ, aesi ya tata imikunyola yo na ɓɛ́ɛ molɔngɔ, amba ya kyɛndɛ o Tempelo phɔ ya iumola mokɔlɔ mowaa ɓo imikunyola siumbo, amoya ambya ikaɓo phɔ ya mɔnɔmɔ na mɔnɔmɔ na ɓɛ. ");
INSERT INTO loq_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Nkɔlɔ sambo ya imikunyola ya lukaka unva, waamowɛnɛ Ɓayuda ɓaautaka o Azi o Tempelo. Ɓamba ya losa moluku mosɔ nɔnɔ wa moakya ɓɛ. ");
INSERT INTO loq_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Ɓaaŋwanaka ɓɛkye: «Ɓato ɓa Isalayɛlɛ, yaka ya lophɛ maɓɔkɔ! Omokyekye, moto okoŋwane na ɓato ɓa ɓanga, na Moɓeko na ná elele eye na mateya makyɛ yo miteya mboka esɔ na oka ɓato ɓasɔ!» ");
INSERT INTO loq_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Phɔ ɓamowɛnɛkyɛ phanza na Tolofimɛ, moto wa Efeze, onte ya mokyisi, emba ɓaumunyaka oɓokye Polo amunyɔsaka onte ya Tempelo. ");
INSERT INTO loq_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Mokyisi moɓimba ŋwamba ya tɔmbɔ, emba ɓato ɓamba yaa ɓaikye. Ɓamba ɓa akya Polo, emba ɓamba motɔkɔlɔ o Tempelo, nɔnɔ wakanga ɓɛ́ɛ bikomba ɓa Tempelo izele. ");
INSERT INTO loq_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Waɓa ɓɛ́ɛ ɓalukye imoɓoma, simo mɛ esiyakoma oka mokonzi ŋwa ɓatuluku nkoto ɓa Ɓaloma oɓokye: Yelusalɛmɛ mobimba ali na mobulu. ");
INSERT INTO loq_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Sakɔkɔ, ɓaesi ya angyinya ɓatuluku na ɓakambi ɓa ɓɛ, ɓaesi ya tomisa moluku ŋwa ɓato oɓokye wamowɛnɛ ɓɛ́ɛ mokambi ŋwa ɓatuluku na ɓatuluku, ɓɛ́ɛ elɛ iwanda Polo. ");
INSERT INTO loq_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Ɓoɓɛlɛ, nkolo ya ɓatuluku amba ya susana phɛnɛphɛ na Polo, amba ya tomisa oɓokye ɓamokangye na nyɔlɔlɔ iɓale. Emba alukaka iyeɓa oɓokye ali nza na oɓokye akyesi ye. ");
INSERT INTO loq_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Kasi onte ya eɓoko mɛ ya ɓato, ɓaaŋwanaka moto na moto aɓa na ewɔlɛ yɛ. Mokonzi ŋwa ɓatuluku taikaka oka ekpele phɔ ya tɔkɔ. Aesi ya ɓa toma oɓokye ɓakyɛ na Polo o ingambi sa ɓatuluku. ");
INSERT INTO loq_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Wakoma ɓɛ́ɛ na Polo phɛnɛphɛ na ebaalele ya ingambi mɛ, ɓatuluku ɓamunyanyaka phɔ eɓoko ya ɓato ɓatondaka na yɔɔ. ");
INSERT INTO loq_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Na ɓomɔ, ɓato ɓasɔ ɓamoɓengaka, ɓaɓaka ɓaaŋwane, ɓɛkye: «Ɓamoɓome!» ");
INSERT INTO loq_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Imbɛlɛ salukaka ɓɛ́ɛ inyɔsa Polo o ingambi sa ɓatuluku, aesi ya wɔ na mokonzi ŋwa ɓatuluku, yokye: «Impɛ nzela, naewɔlɛ nɔnɔ lowɔ lɔnɔlɔ?» Mokonzi ŋwa ɓatuluku yokye: «Koeɓe iwɔ munɔkɔ ŋwa Ɓaela? ");
INSERT INTO loq_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Emba iwɛ toli Moezipito owakyelaka tɔkɔ mi nkɔlɔ iye wawa, emba amba loya ɓaɓomi ɓa ɓato nkoto ine o bokye?» ");
INSERT INTO loq_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Polo, yokye: «Inga nali, Moyuda, mokyisi ŋwa nga Tarsis o Silisi, nakuli ɓa na ŋwana mɔnɔmɔ wa mokyisi ŋwa kaa. Naeɓɔndi, impɛ nzela, nawɔlɛ ɓato.» ");
INSERT INTO loq_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Mokonzi ŋwa ɓatuluku amɓa ya mophɛ nzela. Ɓoɓɛlɛ, Polo aesi ya tɛmɛ o ikolo sa ebalele ya ingambi mɛ, aziɓise ɓato na eɓɔkɔ. Waikala ɓɛ́ɛ ɓose, Polo amba ya wɔ na ná munɔkɔ ŋwa Ɓayuda: ");
INSERT INTO loq_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Ɓande na nga, na ɓatata, okyemela iili na nga oɓokye naewɔlɛ uŋwaŋwa eye. ");
INSERT INTO loq_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Waoka ɓɛ́ɛ Polo kaɓawɔlɛ na munɔkɔ ŋwa lombo ɓamba kula ikala phio. Polo yokye: ");
INSERT INTO loq_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","«Inga nali Moyuda, mokyisi ŋwa nga Tarsis o Silisi, kasi ɓanzɔkɔlɔ wawa o Yelusalɛmɛ, naekola maphɔɔ masɔ ma miɓeko ma ɓankɔkɔ oka Gamaliɛlɛ. Naɓaka na nga moto wa phowa o maphɔɔ ma Ŋwaphongo, ɓo oli lɔlɔ eye. ");
INSERT INTO loq_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Nanyɔkɔlɔkɔ ɓato ɓaaɓaka ɓaɓengye nzela ya Nkolo, ɓaayɔkɔ ɓawaka. Naakyaka ɓampele na ɓaɓasi, naɓanyɔsaka o bɔlɔkɔ. ");
INSERT INTO loq_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Nkolo ya ɓanganga na ɓakumu ɓakokyi eimola ɓo nawɔ ɓɔlɛ. Ɓantomaka na nkanda phɔ ya ɓɛbi Ɓayuda ɓa Damaseke. Nakyɛkyɛ akya ɓaanosi ɓaaɓaka omɔ oɓokye nakyɛ na ɓɛ́ɛ o Yelusalɛmɛ, ɓaɓaphɛ etumbu.» ");
INSERT INTO loq_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","«Naɓaka natambule o nzela, waakoma nga phɛnɛphɛ na Damaseke, iɓalakana ɓoɓo, phɛnɛphɛ na imbɛlɛ sa bunya i moto, ɓongyɛngyɛkye ɓouti o ikolo, ɓoesi ya nzinga. ");
INSERT INTO loq_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Naesi ya kaa o se, namba ya oka ŋwɛsi mɔnɔmɔ mowɔ na nga, oɓokye: “Saolo, Saolo, konyɔkɔlɔ phɔ ya'ye?” ");
INSERT INTO loq_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Namba ya tuna ngakye: “Iwɛ nza, Nkolo?” Ŋwɛsi moesi ya buya oɓokye: “Inga Yesu moto wa Nazalɛtɛ, okonyɔkɔlɔ wɛ.” ");
INSERT INTO loq_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Ɓaaɓaka na nga elele yɔnɔyɔ, ɓawɛnɛkyɛ ɓongyɛngyɛkye mɛ, kasi teɓaikaka oka ŋwɛsi ŋwa nvɔlɛkyɛ. ");
INSERT INTO loq_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Ɓoɓɛlɛ, namba ya tuna ngakye: “Nkolo, nakyele ɓo?” Emba Nkolo amba ya mbuyisa yokye: “Inua, kyɛndɛ o Damaseke, emba omɔ, ɓamoeyimola na ɓolaa etoma eephɛ ɓɛ.” ");
INSERT INTO loq_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Kasi phɔ ɓongyengyekye mɛ pha ndandindisaka miyo, sakula wɛnɛ, nde mɔnɔmɔ na ɓaɓaka na nga ambampila mi eɓɔkɔ oɓokye nakome o Damaseke.» ");
INSERT INTO loq_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","«Moto mɔnɔmɔ aɓaka omɔ, nkombo yɛ Ananiya. Aɓaka moto monɔmɔ mokumosi ŋwa miɓeko ma ɓanga. Ɓayuda ɓasɔ ɓaɓaka omɔ, ɓaɓaka ɓatate ɓomoto ɓolaa phɛ. ");
INSERT INTO loq_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ɓoɓɛlɛ, amba yaa oli nga, amba ya wɔ na nga yokye: “Saolo, nwɛbi na nga, kula butwa iwɛnɛ!” Emba nde mina wamɔ, miyo ma nga maziɓo, nakuli butwa iwɛnɛ. ");
INSERT INTO loq_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Amba wɔ na nga yokye: “Ŋwaphongo wa ɓaango ɓa ɓanga aɓɔngyɛ oɓokye oeɓe phowa yɛ, owɛnɛ Ɓosembo phɛ na iyoka ŋwɛsi nwɛ mampenza. ");
INSERT INTO loq_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Phɔ osengyesi iɓa nzoka yɛ, o ɓoo pha ɓato ɓasɔ. Wamoimola na masɔ mawɛni na maokyi wɛ. ");
INSERT INTO loq_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Kombe kula makamaka phɔ ya'ye? Tokyɛndɛ! Oɓatisame, emba oɓɔndɛlɛ na nkombo ya Nkolo phɔ masumu ma wɛ malibisame.”» ");
INSERT INTO loq_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","«Waya butwa nga o Yelusalɛmɛ, mokɔlɔ mɔnɔmɔ naɓaka o Tempelo, naɓɔndɛlɛ, namba ya lɔtɔ ndɔtɔ. ");
INSERT INTO loq_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Naesi ya wɛnɛ Nkolo kawɔ na nga yokye: “Izele, mana o Yelusalɛmɛ, sangɔmbɔnɔ, phɔ eteɓaanole simo eyamoɓaimola wɛ.” ");
INSERT INTO loq_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Namba ya buya ngakye: “Nkolo, kasi ɓɛ́ɛ nga ɓaeɓe na ɓolaa oɓokye eli nga owaɓaka kakyɛ o Mangambi ma makyita phɔ ya ivaka o bɔlɔkɔ na ibinda na phimbo ɓato ɓaeyanole. ");
INSERT INTO loq_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Na waɓomaka ɓɛ́ɛ Etiyɛni, nzoka ya wɛ, na nga naɓaka omɔ, naanolelaka ɓaɓomi mɛ emba naɓaphilelaka bitobu ɓa ɓɛ.” ");
INSERT INTO loq_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Kasi amba wɔ na nga yokye: “Kyɛndɛ, amoetoma itakye ombale ya nkyisi ya ɓapakano!”» ");
INSERT INTO loq_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Ɓayuda ɓaokaka Polo kawɔ nɔnɔ o maphɔɔ ndengye mɛna, ɓamba ya lika nyangye ɓɛkye: «Ɓamanya moto ndengye eye o mokyisi! Takokyi iɓa na ɓomɔɔ!» ");
INSERT INTO loq_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ɓaaŋwanaka, ɓamba manya minkoto ma ɓɛ, ɓavakye mobulubutu o ikolo. ");
INSERT INTO loq_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Mokonzi ŋwa ɓatuluku aesi ya toma oɓokye ɓanyɔsa Polo o ingambi sa ɓatuluku, ɓamowande phimbo, ɓamoɓalimisa oɓokye awɔ ɓo kaeɓe ntina ekyemoanwenele ɓɛ. ");
INSERT INTO loq_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Kasi wamokanga ɓɛ́ɛ na mokpɔsɔ oɓokye ɓamowande phimbo, Polo awɔ na mokambi wa ɓatuluku owaɓaka wamɔ, yokye: «Moloma otoikyi na ɓɛ́ɛ sambisa, oli na makokyi ma imowanda phimbo?» ");
INSERT INTO loq_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Waoka mokambi ɓaɓona, akyɛ imola mokonzi ŋwa ɓatuluku, yokye: «Wamokyela ɓo?» Moto mɛ ali Moloma! ");
INSERT INTO loq_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Mokonzi ŋwa ɓa tuluku aesi ya kyɛndɛ phɛnɛphɛ na Polo, ɓamotuni, yokye: «Inzimole, oli Moloma?» Polo aesi ya anola, yokye: «Eli ɓomɔ.» ");
INSERT INTO loq_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Mokonzi ŋwa ɓatuluku yokye: «Inga naphuta ɓaphalanga ɓaikye oɓokye nabutwe Moloma.» Polo, yokye: «Kasi nga ɓambota Moloma.» ");
INSERT INTO loq_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Sa kɔkɔ, ɓaalukaka imowanda phimbo oɓokye awɔ, aesi ya mana phɛnɛphɛ nɛ, mokonzi ŋwa ɓatuluku, waeɓa yo oɓokye Polo ali Moloma, ailaka, phɔ amokangaka na minyɔlɔlɔ. ");
INSERT INTO loq_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Mokonzi ŋwa ɓatuluku alukaka oɓokye aeɓe solongo, lowɔ ye losongyele Ɓayuda Polo. Yango mɛna, ɓoyana, ɓamɓa ya moingola nyɔlɔlɔ yaamokangaka na ɓɛ, aesi ya toma ɓakolo ɓa ɓanganga na ɓato ɓa ikyita sinɛnɛ oɓokye ɓaangane. Ɓoɓɛlɛ, ɓamɓa ya kpa Polo, ɓamotyɛ oɓo pha ɓɛ. ");
INSERT INTO loq_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Polo aesi ya kyeka ɓato ɓa ikyita sinɛnɛ, yokye: «Ɓande, nɔnɔ lɔlɔ eye, naikasi ikyelela Ŋwaphongo na ndondo yɔnɔyɔ.» ");
INSERT INTO loq_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Nkolo ya ɓanganga, Ananiya, aesi ya tomisa ɓato ɓaaɓaka phɛnɛphɛ na Polo oɓokye ɓamowande o munɔkɔ. ");
INSERT INTO loq_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Ɓoɓɛlɛ, Polo aesi ya wɔ nɛ, yokye: «Yamoewanda nde Ŋwaphongo, ekuka eyainga ɓɛ́ɛ mokoɓo ŋwa mpɛmbɛ! Ozasi wawana oɓokye ontenele ɓolombe, ɓo kowɔ moɓeko. Emba kokule ɔtɔ moɓeko, kotomisa ɓato oɓokye ɓanvande.» ");
INSERT INTO loq_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Ɓaaɓaka phɛnɛphɛ na Polo, ɓaesi ya wɔ nɛ, yokye: «Kotole nkolo ya ɓanganga ɓa Ŋwaphongo!» ");
INSERT INTO loq_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Polo, yokye: «Ɓande, sikakyi eɓa oɓokye ali nkolo ya ɓanganga, phɔ naeɓe na ɓolaa oɓokye ɓakoma o buku pha Ŋwaphongo, “sa wɔlɛ nkolo ya iɓota sa wɛ maphɔɔ maaɓe!”» ");
INSERT INTO loq_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Polo aeɓaka oɓokye ɓato ɓa ikyita sinɛnɛ ɓaɓaka ɓana Ɓasadukai, ɓayɔkɔ Ɓafalisayi. Yango mɛna, aŋwanaka oɓoo pha ɓɛ̀ɛ, yokye: «Ɓande, nga nali Mofalisayi, ŋwana wa Ɓafalisayi. Okoanole nga oɓokye ɓawee ɓamokundwa, yango mɛna nasambe.» ");
INSERT INTO loq_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Wawɔ yo ɓaɓona, Ɓafalisayi na Ɓasadukayi ɓaphalatanaka, ɓato ɓaanganaka ɓaesi ya mikabinya na ɓiɓoko biɓale. ");
INSERT INTO loq_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Phɔ Ɓasadukayi ɓawɔ oɓokye ɓawee eteɓakule kundwa, ŋwanze tali, ɓolɔɓɔ tali, kasi Ɓaphalisayi ɓaanole oɓokye isɔ mina ili. ");
INSERT INTO loq_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Ɓakulaka aŋwana na ɓokusi, ɓateye ɓa miɓeko ɓayɔkɔ ɓali na Ɓafalisayi, ɓaesi ya tɛmɛ, ɓaphalatanaka na ɓokusi, ɓɛkye: «Ɓanga toloikyi mozwa na lowɔ loɓe. Yamoɓa ɓolɔɓɔ, na ŋwanze awɔ nɛ!» ");
INSERT INTO loq_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Ɓakuli phalatana na ɓokusi, mokonzi ŋwa ɓatuluku ailaka oɓokye ɓamotena Polo bitee bitee. Yango mɛna, ɓatomaka ɓatuluku oɓokye ɓaute o elele eyanga ɓato, ɓamanya Polo onte ya ɓɛ̀ɛ na ɓokusi, ɓakyɛ nɛ o ingambi sa ɓtuluku. ");
INSERT INTO loq_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Wa mokɔlɔ ŋwa sima, Nkolo amba ya miwɛninya na Polo, awɔ nɛ, yokye: «Oititala nde ɓaɓona! Ɓo uti wɛ iimola Simo ya nga wawa o Yelusalɛmɛ, esengyesi oɓokye okyɛ na imola o Loma.» ");
INSERT INTO loq_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Ɓoyana wa mumbengu, Ɓayuda ɓamba ya wanga, ɓakati seleka oɓokye ɓamokula zaa, ɓamokula nywa, elaa phanza ɓaɓomi Polo. ");
INSERT INTO loq_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Ɓayuda mɛ ɓaawangaka ɓaɓaka ɓato leka mako mane. ");
INSERT INTO loq_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Ɓaesi ya kyɛndɛ oka ɓakolo ɓa ɓanganga na oka ɓankumu, ɓawɔ na ɓɛ, ɓɛkye: «Ɓanga tokati seleka oɓokye tomokula zaa elaa phanza toɓomi Polo. ");
INSERT INTO loq_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Emba uŋwaŋwa eye, ɓɛ̀ɛ okana na ɓato ɓa ikyita sinɛnɛ, ongye na mokonzi ŋwa ɓatuluku, oɓokye ɓaye na Polo oɓo pha ɓɛ̀ɛ, eɓe ndokolo oli na phowa ya ikula ɔlinya lowɔ lɛ na ɓolaa. Ɓanga mampenza, tumbo miwangya oɓokye tomoɓome mɛna yo sa taakoma wawa.» ");
INSERT INTO loq_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ŋwana wa lele wa ŋwana nyango na Polo owa ŋwaŋwasi, waoka yo ikɔlɔ mɛ, aesi ya kyɛndɛ o ingambi sa ɓatuluku, akyɛ imola Polo maphɔɔ mɛ. ");
INSERT INTO loq_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Ɓoɓɛlɛ, Polo aesi ya ɓanga mɔnɔmɔ na ɓakambi ɓa ɓatuluku, awɔ nɛ, yokye: «Kyɛndɛ na munzenga oyo oka mokonzi ŋwa ɓatuluku, ali na lowɔ la imoimola.» ");
INSERT INTO loq_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Mokambi wa ɓatuluku aesi ya mokpa, akyɛ nɛ oka mokonzi ŋwa ɓatuluku, yokye: «Polo, amɓangyi, amɓɔndi oɓokye naeyelele na munzenga oyo, ali na lowɔ la ewɔlɛ.» ");
INSERT INTO loq_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Mokonzi ŋwa ɓatukuluu aesi ya kpa munzenga mɛ meeɓɔkɔ, akyɛ nɛ ɓi mbale, yokye: «Lowɔ ye loolukye wɛ inzimola?» ");
INSERT INTO loq_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Yokye: «Ɓayuda ɓaoka oɓokye ɓaongye na wɛ okyɛndɛ na Polo yana oɓo pha ikyita sinɛnɛ, eɓe ndokolo ɓali na phowa ya ikula ɔlinya lowɔɔ lɛ na ɓolaa. ");
INSERT INTO loq_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Kasi iwɛ, sa anola yaamowɔ ɓɛ! Phɔ ɓato leka mako mane onte ya ɓɛ́ɛ ɓaamiɓomba oɓokye ɓamoakya. Ɓakata seleka oɓokye ɓamokula zaa, ɓamokula nywa elaa phanza ɓamoɓomi. Uŋwaŋwa ye ɓambo miwangya, ɓaziya nde ɓowaɓabuyisa wɛ.» ");
INSERT INTO loq_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Mokonzi mɛ aesi ya wɔ na munzenga mɛ oɓokye: Wɛ sa kyɛ imola nɔnɔ moto mɔnɔmɔ maphɔɔ maanzimosi wɛ. Emba amba ya mobuya. ");
INSERT INTO loq_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Ɓoɓɛlɛ, mokonzi ŋwa ɓatuluku amba ya ɓanga ɓakambi ɓaɓale onte ya ɓakambi, yokye: «Angyinya ɓatuluku mikama miɓale, ɓato mako sambo ɓaatambule na mampunda, na ɓato mikama miɓale ɓaaphile makɔngɔ, omiɓɔngya phɔ ya ikyɛndɛ o Sezare wa ngonga ya ibuwa eya nkɔkɔlɔ. ");
INSERT INTO loq_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Ɓɔngya na mampunda ma inyanya Polo oɓokye omokomya na nzoto ndaa oka Moangyesi Feliks.» ");
INSERT INTO loq_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Akomaka mokanda yokye: ");
INSERT INTO loq_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","«Inga Klode Lusias, naɓeya, Moangyesi Feliks, moto wa kaa. ");
INSERT INTO loq_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Ɓayuda ɓaakyaka moto oyo, ɓalukaka imoɓoma, waoka nga oɓokye ali Moloma, naesi ya kyɛ na ɓatuluku ɓa nga, nakyɛ mokandola. ");
INSERT INTO loq_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Nalukaka eeɓa naa Ɓayuda ɓamosongyele na lowɔ ye, naesi ya kyɛndɛ nɛ oɓo pha ikyita sinɛnɛ. ");
INSERT INTO loq_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Nawɛnɛkyɛ oɓokye ɓamosongyele phɔ ya maphɔɔ ma moɓeko ŋwa ɓɛ́ɛ mampenza, kasi taika kyela lowɔ lɔnɔlɔ loɓe la oɓokye awe, naa ɓamunyɔsa o bɔlɔkɔ. ");
INSERT INTO loq_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Waoka nga oɓokye Ɓayuda ɓamowangyele na ɓoɓe, yango mɛna naetomesi yo izele, nawɔ na ɓato ɓaamosongyele oɓokye ɓaya mosongyele oɓo pha wɛ.» ");
INSERT INTO loq_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Ɓatuluku ɓaesi ya kyela ɓo waatomaka ɓɛ, ɓakpe Polo, ɓakyɛ nɛ mokɔlɔ mɛ mamuna nɔnɔ o Antipatris. ");
INSERT INTO loq_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Ɓoyana, ɓatuluku, ɓaakyɛkyɛ na makolo, ɓaesi ya butwa o ingambi sa ɓɛ, ɓaikyi ɓaaɓaka na mampunda, ɓakyɛ na Polo. ");
INSERT INTO loq_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Wakoma ɓɛ́ɛ o Sezare, ɓaakyɛkyɛ na mampunda ɓaesi ya phɛ Moangyesi mokanda, ɓaikyi Polo o sɛ yɛ. ");
INSERT INTO loq_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Moangyesi amba ya tanga mokanda, atuni Polo naa kaute o mokyisi ye. Waeɓaka yo oɓokye kaute o Silisi, ");
INSERT INTO loq_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","awɔ nɛ, yokye: «Namoetuna mituna ɓo ɓato ɓaaesongyele ɓaesi». Amba ya toma ɓato oɓokye ɓaɓanza Polo o ingambi sa Elode. ");
INSERT INTO loq_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Sima ya nkɔlɔ itano, Nganga munɛnɛ, Ananiya, amba ya kyɛndɛ o Sezare yo na ndambo ya ɓankumu, na ná moto mɔnɔmɔ wa yela ya iwɔ, nkombo yɛ Tertulus. Ɓaesi ya kyɛ oɓo pha Moangyesi Feliks oɓokye ɓasongyele Polo. ");
INSERT INTO loq_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Ɓamba ya ɓanga Polo. Tertulus atati imosongyela, yokye: «Iwɛ Moangyesi wa kaa, Feliks, eli phɔ ya wɛ, ɓanga lɔlɔ toli na nkyisa ya iɓa ɓose. Ɓakyele bitoma bilaa o iɓota sa Ɓayuda sisi phɔ ya ɓoeɓakye pha wɛ pha maphɔɔ. ");
INSERT INTO loq_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Toeɓe na ɓolaa ɓo kyele wɛ, phɔ ya isɔ ikyizwe ɓanga mala na mala bilele bisɔ. ");
INSERT INTO loq_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Kasi sikokyi iwɔ waikye, yango mɛna, naongye nde oɓokye, na ngɔngɔ ya wɛ, okute looka ŋwana ɓokyi ɓoɓo. ");
INSERT INTO loq_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Towɛni oɓokye moto oyo ali phɛlɛ moto moɓe, kaambya tɔkɔ oka Ɓayuda ɓasɔ ɓa mokyisi munsɔ. Ali mokambi ŋwa ingomba sa ɓato ɓa Nanasalɛtɛ. ");
INSERT INTO loq_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Alukaka na ɔtɔ Tempelo, emba tomba moakya. Tolukaka imosambisa ɓo kowɔ moɓeko ŋwa ɓanga. ");
INSERT INTO loq_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Kasi mokonzi ŋwa ɓatuluku, Lusias, wa ya yo, aesi ya moɓɔlɔlɔ na ɓokusi o sɛ ya ɓanga. ");
INSERT INTO loq_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Lusias amba ya wɔ na ɓato ɓaamosongyele oɓokye ɓaye oɓo pha wɛ. Ɓo otuni moto mɛ wɛ mampenza, wamowɛnɛ oɓokye maphɔɔ masɔ maamosongyele na ɓanga mali phɛlɛ.» ");
INSERT INTO loq_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Ɓayuda ɓamba ya anola, ɓɛkye: Eli nde ɓomɔ. ");
INSERT INTO loq_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Ɓoɓɛlɛ, Moangyesi Feliks amba ya kyelela Polo eɓɔkɔ oɓokye awɔ. Polo, yokye: «Naeɓe oɓokye mambula maikye oli moteni wa ɓolombe wa iɓota sisi, nali na nkyisa ya aamba oɓo pha wɛ. ");
INSERT INTO loq_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Na wɛ mampenza, okokyi eeɓa phɛlɛ oɓokye, o wakomaka nga o Yelusalɛmɛ phɔ ya iɓɔndɛlɛ Ŋwaphongo, nakyela nde nkɔlɔ iko mbuka biɓale ɓoɓɛlɛ. ");
INSERT INTO loq_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Teɓaika nzwa, eɓe o Tempelo, eɓe o mangambi ma makyita ma Ɓayuda, eɓe o lombo, oɓokye naphalatane na moto mɔnɔmɔ, naa nalosa eɓoko ya ɓato. ");
INSERT INTO loq_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ɓato ɓaɓa teɓali na ekpele ekyeteya oɓokye maphɔɔ maansongyele na ɓɛ́ɛ lɔlɔ mali phɛlɛ. ");
INSERT INTO loq_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Naanole oɓo pha wɛ oɓokye nakyelele Ŋwaphongo owakyelelaka ɓankɔkɔ ɓa ɓanga, namokyelele na Nzela ya Yesu enyakune ekyewɔ ɓɛ́ɛ oɓokye telongoɓa. Nakule anola maphɔɔ masɔ maali o buku pha miɓeko na o buku pha ɓaimosi. ");
INSERT INTO loq_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Nalemele oka Ŋwaphongo, na ɓaansongyele ɓalemele ɓomɔ mɛ, oɓokye ɓato, na ɓalaa na ɓaaɓe ɓasɔ ɓamokundwa. ");
INSERT INTO loq_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Yango mɛna, nakyele ɓokusi oɓokye naɓee imbɛlɛ sisɔ na maumunya maalongoɓa oɓo pha Ŋwaphongo, na o ɓoo pha ɓato.» ");
INSERT INTO loq_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","«Sima ya mambula maikye sa kula koma o Yelusalɛmɛ, nakuli yaa oɓokye nasungye iɓota sa ɓanga Ɓayuda na ɓaphalanga na oɓokye naamba ndaa oka Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Mɛna maphɔɔ manzwaka na ɓɛ́ɛ nakyele o Tempelo, naumvaka imikunyola, ɓo kowɔ moɓeko. Ɓato teɓaikaka ɓa ɓaikye, na tɔkɔ teyaikaka ɓa. ");
INSERT INTO loq_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Kasi Ɓayuda ɓayɔkɔ ɓa Azi ɓaɓaka wamɔ, eli ɓɛ́ɛ ɓakokakyi iyansongyela oɓo pha wɛ, ɓo ɓaɓakyi na nga na lowɔ. ");
INSERT INTO loq_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Ɓo teɓe ɓomɔ, lɛ oɓokye ɓato ɓaɓa ɓawɔ, ɓo ɓanzwa na lowɔ'ye looɓe, waɓaka nga oɓo pha ikyita sinɛnɛ. ");
INSERT INTO loq_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Nawɔkɔ na ná ɓokusi, ngakye: “Naambe lɔlɔ ye oɓo pha wɛ nde phɔ naanole oɓokye ɓawee amokundwa. Sieɓe lowɔ losuu loonsongyele na ɓɛ!”» ");
INSERT INTO loq_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Feliks, o waeɓaka yo maphɔɔ ma nzela ya Kolo na ɓolaa, aesi ya ɓabuyisa, yokye: «Namotena ɓolombe pha lowɔ la ɓɛ, wamoya mokonzi ŋwa ɓatuluku, Lusias.» ");
INSERT INTO loq_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Amba ya wɔ na mokambi wa ɓatuluku oɓokye abuya Polo o bɔlokɔ, amoɛphisa, ɓo ɓɛbi nɛ ɓaaya mosunga, yo sa ɓakatela. ");
INSERT INTO loq_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Sima ya ɓana nkɔlɔ, Feliks amba ya na ŋwaŋwasi wɛ Dulusila, ali Moyuda. Aesi ya toma ɓato oɓokye ɓaye na Polo, aokye maphɔɔ maawɔ yo phɔ ya aanola Yesu Klisto. ");
INSERT INTO loq_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Feliks, waoka yo Polo kateya ɓookokyi moto ikumola Ŋwaphongo na moɓesi nwɛ, ɓookokyi moto imizila, ɓo wamotena Ŋwaphongo ɓolombe pha mokyisi mumu, awɔkɔ nɛ kyɛ. Yokye: «Uŋwaŋwa ye, taa kyɛndɛ, ɓo nazwe ngonga, namokula eɓanga.» ");
INSERT INTO loq_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Alemelaka na oɓokye Polo aamophɛ ɓaphalanga, yango mɛna ɓaɓaka kamoɓangye oɓokye ɓavane. ");
INSERT INTO loq_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Mambula maɓale malekana nde ɓaɓona, sima Porsuis Festus amba ya butwa moangyesi o elele ya Feliks. Feliks aikaka Polo o bolɔkɔ, phɔ ya ilɛkyikyisa Ɓayuda. ");
INSERT INTO loq_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Sima ya nkɔlɔ iyato, wakpa Festus ɓokonzi, aesi ya uta o Sezare, akyɛ o Yelusalɛmɛ. ");
INSERT INTO loq_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Omɔ, ɓakolo ɓa ɓanganga na ɓankumu ɓa Ɓayuda ɓaesi ya songyela Polo oka yɛ. ");
INSERT INTO loq_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Ɓaongaka nɛ oɓokye ɓatome ɓato ɓakyɛ ɓanga Polo, ɓaye nɛ o Yelusalɛmɛ, ɓawangyaka oɓokye amoɓome o nzela. ");
INSERT INTO loq_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Festus aesi ya ɓabuyisa, yokye: Polo aɓaka o bɔlɔkɔ o Sezare, na nga mampenza nalukye ikula kyɛndɛ omɔ uŋwaŋwa ye. ");
INSERT INTO loq_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Lɛ oɓokye: «Ɓakonzi ɓa ɓɛ̀ɛ ɓakyɛ nzika o Sezare, ɓambe songyela moto mɛ, ɓo akyela ɓoɓe.» ");
INSERT INTO loq_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Festus akyelaka omɔɔ nde nkɔlɔ wambe naa iko, amba ya butwa o Sezare. Ɓoyana, aesi ya kyɛ zala o elele ekyeambe ɓɛ́ɛ maphɔɔ, amba ya toma ɓato, yokye: Ɓaye na Polo. ");
INSERT INTO loq_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Waya ɓɛ́ɛ nɛ, Ɓayuda ɓaa utaka o Yelusalɛmɛ, ɓaesi ya molungya, ɓamosongyele na maphɔɔ maikye maikye manɛnɛ, mawaa ɓɛ́ɛ mampenza teɓaikaka koka iteya oɓokye mali phɛlɛ. ");
INSERT INTO loq_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Polo aesi ya ɓabuyisa, yokye: «Eɓe phɔ ya miɓeko ma Ɓayuda, eɓe phɔ ya Tempelo, eɓe phɔ ya Kaisala, sikyi kyela lowɔ lɔnɔlɔ loɓe.» ");
INSERT INTO loq_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Festus alukaka oɓokye Ɓayuda ɓamosambe, aesi ya tuna Polo, yokye: «Wamozinga ikyɛndɛ o Yelusalɛmɛ oɓokye osambe lowɔ lolo omɔ o ɓoo pha nga?» ");
INSERT INTO loq_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Kasi Polo amba ya buya yokye: «Nali o tilibinalɛ ya Mokonzi, nasengyesi isamba nde omɔ. Sikyi kyela Ɓayuda na lowɔ lɔnɔlɔ looɓe, nde ɓokowɛnɛ wɛ mampenza ɓaɓona. ");
INSERT INTO loq_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Ɓo nakyesi ɓoɓe phɛlɛ, na ɓo naani kyela lowɔ loɓe lokokyi oɓokye nawe, sikokyi ilota iwa. Kasi ɓo maphɔɔ mansongyesi na ɓɛ́ɛ mali ma ɓɔlɛ, moto takokyi inzambya o maɓɔkɔ ma ɓɛ. Nazingyi iamba o ɓoo pha mokonzi.» ");
INSERT INTO loq_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Ɓoɓɛlɛ, Festus amba ya anola maumunya mɛ, emba amba mobuyisa yokye: «Ozingyi iamba nde oka mokonzi, wamokyɛ o ɓoo pha mokonzi.» ");
INSERT INTO loq_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Ɓana nkɔlɔ ɓalekanaka, mokonzi Agripa na Belenisɛ ɓamba yaa o Sezare, emba; bamba kyɛ kyeka Festus. ");
INSERT INTO loq_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Emba ɓo waɓa ɓɛ́ɛ ɓalekyinya ŋwana imbɛlɛ, Festus amba ya imola mokonzi lowɔ la Polo, yokye: «Moto mɔnɔmɔ ali wawa, Feliks amoika o bɔlɔkɔ. ");
INSERT INTO loq_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Waɓa nga o Yelusalɛmɛ, ɓanganga ɓanɛnɛ na ɓankumu ɓa Ɓayuda ɓamba ya mosongyela, ɓaongye oɓokye ɓamunyɛtɛ. ");
INSERT INTO loq_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Namba ɓabuyisa oɓokye o miɓeko ma Ɓaloma, teɓakokyi ambya moto ɓo naino teɓamokyi yo na ɓato ɓamosongyesi, na ibuya i maphɔɔ masɔ mamosongyesi na ɓɛ. ");
INSERT INTO loq_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Yango mɛna ɓaya wawa nde ena yana, sakuta na nzɛphisa. Namba ya zala o tilibinalɛ, emba na mba ɓatoma oɓokye ɓaye na moto mɛ. ");
INSERT INTO loq_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Wa yaangana ɓasongyesi ɓɛ́ɛ wali yo, teɓaka zwa na lowɔ lɔnɔlɔ lokusi ɓowa umunyaka nga. ");
INSERT INTO loq_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Ɓaɓaka nɛ nde na tɔkɔ ekyekyi maphɔɔ ma losambo la ɓɛ́ɛ mampenza, na phɔ ya moto mɔnɔmɔ na nkombo ya Yesu owawa, kasi Polo kawɔ oɓokye ooli nde na ɓomɔɔ. ");
INSERT INTO loq_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Waɓa nga sazwa ndengye ya itena ɓolombe mi lowɔ ndengye mɛna, namba ya onga nɛ oɓokye akyɛndɛ o Yelusalɛmɛ phɔ ya oɓokye lowɔ lɛ lokyɛ wɔɔmɔ omɔ. ");
INSERT INTO loq_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Kasi Polo azingyi nde ikyɛ aamba o ɓoo pha mokonzi omunɛnɛ, emba namba ya toma oɓokye ɓatamovaka o bɔlɔkɔ nɔnɔ mokɔlɔ ŋwaamolekyinya ɓanga o ɓoo pha mokonzi.» ");
INSERT INTO loq_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Ɓoɓɛlɛ Agripa amba ya wɔ na Festus: «Nazingyi ooka na nga moto mɛ.» Amba mobuyisa yokye: «Yana, wamooka.» ");
INSERT INTO loq_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Ɓo yana, Agripa na Ɓelenisɛ ɓamba yakyɛ nyɔlɔ na kaa esɔ o ingambi siambinya ɓɛ́ɛ maphɔɔ, ɓɛ́ɛ na ɓakonzi ɓanɛnɛ ɓa ɓatuluku na ɓankumu ɓa mokyisi. Festus amba ya toma ɓato oɓokye ɓaye na Polo. ");
INSERT INTO loq_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Emba Festus amba ya tata iwɔ, yokye: «Mokonzi Agripa na ɓɛ̀ɛ ɓasɔ ɓali na ɓanga, kowɛnɛ moto oyo. Ɓayuda ɓasɔ ɓaesi oka nga phɔ yɛ, o Yelusalɛmɛ nɔnɔ wawa, ɓakyɛmiaŋwana ɓɛkye takokyi ikula ɓa na ɓomɔɔ. ");
INSERT INTO loq_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Phɔ ya nga, sikyi zwa o maphɔɔ mɛ lokokyi nɛ iwa. Kasi phɔ yo mampenza azingyi ikyɛ amba oka mokonzi omunɛnɛ, naanosi imotoma oka yɛ. ");
INSERT INTO loq_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Otoli nga na ná lakolo lowɔ la ikomela mokonzi phɔ yɛ, namoambinya o ɓoo pha ɓɛ̀ɛ, konza o ɓoo pha wɛ mokonzi Agripa, phɔ okokye imokomela sima ya iyoka munɔkɔ nwɛ. ");
INSERT INTO loq_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Phɔ yamoɓa ɓoɓe, phɔ ya nga, itoma moto wa bɔkɔlɔ, sanka ya iyebinya biwele bimoakye na ɓɛ.» ");
INSERT INTO loq_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agripa amba ya wɔ na Polo, yokye: «Toephɛ nzela oɓokye oambe.» Polo amba ya elola eɓɔkɔ, amba ya amba yokye: ");
INSERT INTO loq_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","«Mokonzi Agripa, i maphɔɔ masɔ mansongyesi na Ɓayuda, namiwɛnɛ nde na nkɔnzɔ ya iyamba lɔlɔ o ɓoo pha wɛ, ");
INSERT INTO loq_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","phɔ iwɛ koeɓe na ɓolaa ɓonkɔkɔ ɓosɔ pha Ɓayuda na maphɔɔ ma phango. Naongye na wɛ oɓokye onzokye na ɓolaa.» ");
INSERT INTO loq_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","«Ɓayuda ɓasɔ ɓanzeɓe na ɓolaa, uta ɓolɛngyɛ pha nga, ɓaeɓe ɓo waɓaka nga phanza onte ya iɓota sa ɓanga Ɓayuda, na o Yelusalɛmɛ. ");
INSERT INTO loq_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Ɓanzeɓe kalakala, ɓakokyi na iwɔ ɓo ɓazingyi, oɓokye nali moto okokumole na ɓokusi miɓeko ma ingomba sa ɓanga Ɓafalisayi. ");
INSERT INTO loq_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Emba lɔlɔ eye, ɓo naesi yaamba, eli nde phɔ ya molemo ŋwa mbunu eya ikyela Ŋwaphongo ɓaango ɓa ɓanga. ");
INSERT INTO loq_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Na oɓokye maɓota ma ɓanga iko mbuka maɓale, wa moɓɔndɛlɛ ɓɛ́ɛ Ŋwaphongo na moo na mokɔlɔ, saema, ɓalemele iwɛnɛ mbunu mɛ ekokyisame. Eli nde phɔ ya molemo mamuna, so mokonzi, ɓonsongyesi Ɓayuda ɓoɓo. ");
INSERT INTO loq_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Phɔ ya'ye onte ya ɓɛ̀ɛ toanole oɓokye Ŋwaphongo kakundole ɓawe? ");
INSERT INTO loq_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Phɔ ya nga, naanolaka ɓato saanola nkombo ya Yesu, moto wa Nazalɛtɛ. ");
INSERT INTO loq_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Emba nde ɓomɔ ɓo wakyela nga o Yelusalɛmɛ. Nga mampenza naakyaka ɓaanosi ɓaikye na ɓokonzi pha mpɛkyɛ ɓanganga ɓanɛnɛ emba na nga naanolaka waɓa ɓɛ́ɛ ɓaɓaɓome. ");
INSERT INTO loq_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Nanyɔlɔkɔ o mangambi ma makyita masɔ, nakyelaka bitoma biikye phɔ ya ɓɛ, phɔ ya iɓatomisa na ɓokusi oɓokye ɓatole Yesu, emba na kabu ya nga ekusi, naɓaɓengaka nɔnɔ o nkyisi nsuu inɛnɛ.» ");
INSERT INTO loq_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","«Yango mɛna, mokɔlɔ mɔnɔmɔ, naɓaka na kyɛndɛ o Damaseke na ɓokonzi ɓosɔ na etoma ya ɓanganga ɓanɛnɛ. ");
INSERT INTO loq_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Naɓaka o nzela, so mokonzi, imbɛlɛ sa bunya o moto, naesi ya wɛnɛ ɓongyɛngyɛkye ɓouti o ikolo, ɓolole koleka moo, ɓongyɛngyɛkye mɛ ɓoesi ya nzinga eɓe na ɓɛbi ɓatambulaka na nga nzela. ");
INSERT INTO loq_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Tomba ya ka ɓanga ɓasɔ o se, emba namba ya oka ŋwɛsi mɔnɔmɔ mowɔ na nga na munɔkɔ ŋwa ɓa Eɓele oɓokye: “Saolo, Saolo, phɔ ya ye konyɔkɔlɔ? Ɓo olɛ mbela ya nga, mɛna komizokya nde wɛ mampenza.” ");
INSERT INTO loq_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Namba ya buya ngakye: “Iwɛ nza, Nkolo?” Nkolo amba kula yawɔ yokye: “Nali Yesu, eli nga moto okonyɔkɔlɔ wɛ. ");
INSERT INTO loq_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Kasi iŋwa, tɛmɛ! Kyeka phɔ ya'ye naetɔkɔlɛsi: Naeyɔsi phɔ oɓe moto wa etoma na nzoka ya iwɛnɛ siuti wɛ invɛnɛ, na yaamowɛnɛkyɛ sima, na yaamoɓaka nga naeteya. ");
INSERT INTO loq_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Namba ebikya o maɓɔkɔ ma Ɓayuda, na ma maɓota ma ɓapakano wamoetoma nga ");
INSERT INTO loq_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","phɔ ya ikyɛ ɓaingola miyo, iɓamanya o enzɔmbi phɔ ya iɓabuya o moo, iɓamanya o ɓokonzi pha Molemba phɔ ya iɓabuya oka Ŋwaphongo. Phɔ ya oɓokye ɓazwe ɓolimbisi pha masumu na iyalo sa ilaka elele yɔnɔyɔ na ɓaanosi, na nzela ya inzanola.”» ");
INSERT INTO loq_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","«Tata wamɔ, mokonzi Agripa, sika koka ilɛ ndɔtɔ ya ikolo eya wɛnɛkyɛ nga. ");
INSERT INTO loq_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Kasi naimola ɓato ɓa Damaseke phanza, emba ɓa Yelusalɛmɛ, o nkyisi isɔ ya Yuda, sima o maɓota ma ɓapakano oɓokye ɓasengyesi ɓongola mandondo phɔ ya ekpana bika Ŋwaphongo, ɓobikakye ɓooteya oɓokye ɓaɓongosi mandondo ma ɓɛ. ");
INSERT INTO loq_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Eli phɔ ya ɓomɔ Ɓayuda ɓanzakyakyi o Tempelo, ɓalukakyi imɓoma. ");
INSERT INTO loq_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Ŋwaphongo ambanze nɔnɔ lɔlɔ eye, nataɓa ɓa ɓomɔ oɓokye naimole simo ya nga oka ɓato ɓasɔ ɓaakyikyi na ɓaanɛnɛ. Naanole nde maphɔɔ maawɔ Mose na mawɔ ɓikondo oɓokye mamoya: ");
INSERT INTO loq_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Masiya amowɛnɛ ɓolɔsi, amoɓa moto owa ɓoo, owamokundwa onte ya ɓawee. Amoimola o iɓota sa ɓanga na ɓato ɓaateɓali Ɓayuda oɓokye moo moesi, enzɔmbi emani.» ");
INSERT INTO loq_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Waɓa Polo katɔndɔlɔ ɓaɓona, Festus amɓa ya aŋwana nɛ, yokye: «Polo, oli na ŋwaa! Iekola saaekola wɛ na ɓoikye siephɛ ŋwaa!» ");
INSERT INTO loq_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Polo, yokye: «Festus moto wa kaa, nga sili na ŋwaa, nawɔ maakolo maphɔɔ maali phɛlɛ. ");
INSERT INTO loq_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Mokonzi Agripa kaeɓe maphɔɔ mamana na ɓolaa. Nakokyi imowɔlɛ mango pwapwa. Naanole oɓokye tabungye nɔnɔ lowɔ lɔnɔlɔ i maphɔɔ mamana, phɔ malekanaka o miyo ma ɓato. ");
INSERT INTO loq_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Mokonzi Agripa, koanole maphɔɔ maawɔ ɓaimosi? Naeɓe oɓokye komaanole!» ");
INSERT INTO loq_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agripa aesi ya wɔ na Polo, yokye: «Kolukye imbuya nde uŋwaŋwa eye Moklisto?» ");
INSERT INTO loq_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Kasi Polo, yokye: «Eɓe uŋwaŋwa eye, eɓe wakɔkɔ, naɓɔndɛlɛ Ŋwaphongo oɓokye na wɛ, na ɓasɔ ɓaanzokye lɔlɔ ye, ɓɛ́ɛ obutwe ɓooli nga, manya nde nyɔlɔlɔ iye!» ");
INSERT INTO loq_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Mokonzi, na moangyesi, na Bɛlɛnisɛ, na ɓasɔ ɓaazalaka na ɓɛ́ɛ ɓamba ya tɛmɛ. ");
INSERT INTO loq_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Wamana ɓɛ́ɛ wamɔ, ɓawɛnɛkɛ, ɓɛkye: «Moto oyo taikyi kyela lowɔ lɔnɔlɔ la iwaa naa laa imunyɔsa o bɔlɔkɔ.» ");
INSERT INTO loq_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agripa amba wɔ na Festus, yokye: «Moto oyo, ɓo tawɔkyi oɓokye azingyi ikyɛ amba oka Kaisala phe, nde ɓamokandolakyi.» ");
INSERT INTO loq_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Wakpama meko oɓokye toba o masuwa phɔ ya ikyɛndɛ o Itali, aesi ya kpa Polo na ɓato ɓa bɔlɔkɔ ɓayɔkɔ ɓakyɛ ɓaphisa Yuli, oli mɔnɔmɔ na ɓakambi ɓa moluku ŋwa ɓatuluku ɓa moangyesi wa Loma. ");
INSERT INTO loq_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Ɓoɓɛlɛ tomba ya baa o masuwa mautaka o Adramite, makyɛndɛ mopha ŋwa mabɔngu ma Azi. Moto mɔnɔmɔ wa Makedoniya, mokyisi nwɛ Tesaloniki, aɓaka na ɓanga elele yɔnɔyɔ. Nkombo yɛ Aristarke. Tomba ya kyɛndɛ. ");
INSERT INTO loq_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Ɓoyana, toesi ya koma o Sidona. Yuli aɓaka na Polo na ɓolaa, aesi ya mophɛ nzela ya ikyɛ kyeka ɓande nɛ, oɓokye azwe ya sengyelaka nɛ. ");
INSERT INTO loq_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Wamana ɓanga wawana, toesi ya ɓanda mopha ŋwa esanga ya Shiprɛ, phɔ phɛphɛkyɛ yaɓaka kyekule lobuya na munsima. ");
INSERT INTO loq_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Toesi ya katisa maa manɛnɛ maali phɛnɛphɛ na Silisi na Pamfili, tokyɛ koma o Mira, mokyisi mɔnɔmɔ o Lisi. ");
INSERT INTO loq_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Omɔ, mokambi wa ɓatuluku azwe masuwa mautaka o Alegizandri, makyɛ o Itali, aesi ya lokpesa omɔ. ");
INSERT INTO loq_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Tokyelaka nkɔlɔ nzikye o nzela, masuwa makyɛkyɛ nde na mɔɔ na mɔɔ. Tolukaka oɓokye tokome o Kinidi. Toesi ya lekana o Salmone oɓokye toekpane o mopha moyɔkɔ ŋwa esanga ya Kɛlɛtɛ, phɔ phɛphɛkyɛ teyaikaka lophɛ nzela ya ilekana mopha ŋwaɓaka ɓanga. ");
INSERT INTO loq_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Totambulaka na nkaka oɓokye tolekane o mokukulu mɛ, tokyɛ koma o elele yɔnɔyɔ, ɓaeɓangye Mabongu Maalaa phɛnɛphɛ na mokyisi na nkombo Lase. ");
INSERT INTO loq_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Tokɔkɔkɔ na ɓoikye o nzela. Nkɔlɔ ikyikyile ɓɛ́ɛ izaa yaunva lekana. Na ɓomɔ tokomaka imɓɛlɛ siikyele phɛphɛkyɛ na ɓokusi. Yabutwaka nkamba oɓokye masuwa makule tambula. ");
INSERT INTO loq_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","Ɓɛbi, nawɛnɛ oɓokye imbanga sisi samoɓa na nkamba, masuwa na mbolo iili omɔ yamɔtɔnɔ na ɓoɓe, kasi na ɓanga mampenza ɓotewalongoɓa phe, tomowaa. ");
INSERT INTO loq_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Kasi mokambi wa ɓatuluku taikaka anola munɔkɔ ŋwa Polo, anolaka nde munɔkɔ ŋwa mopuse wa masuwa na mokolo wa masuwa. ");
INSERT INTO loq_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Ibongu mɛ tesaikaka ɓa elele elaa oɓokye masuwa masɛmɛ imbɛlɛ saɓaka phɛphɛkyɛ kyekyele na ɓokusi. Yango mɛna, ɓato ɓayɔkɔ ɓaikye ɓa masuwa, ɓakanaka oɓokye tomane wamɔ, ɓo tomokoka, tokome o Feniks, ibongu sa Kɛlɛtɛ sikyekye mbale eya ngyɛlɛ, na mbale eya ikolo, oɓokye imbɛlɛ sa sɛkyɛ suunve wamɔ. ");
INSERT INTO loq_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Ŋwana phɛphɛkyɛ ekeute mopha ŋwa ngyɛlɛ, ebuto ikyela. Ɓato ɓa masuwa ɓabuyaka oɓokye ɓamokokya yaakanaka ɓɛ. Ɓaesi ya manya longo, ɓabuto itambula, ɓaɓande phɛnɛphɛ na mokukulu ŋwa esanga ya Kɛlɛtɛ. ");
INSERT INTO loq_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Sa kɔkɔ, ewɛɛlɛ yɔnɔyɔ yautaka o mangomba manɛnɛ ma esanga. O munɔkɔ ŋwa Ɓaela ɓaɓangye ewɛlɛ mɛ Yulakulu. ");
INSERT INTO loq_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Yeesi ya lodikyinya, tewakulaka koka iɓekola masuwa mopha mooye ewɛɛlɛ. Ɓoɓɛlɛ, ewɛlɛ ebuto ikyɛ milouka nde ɓaɓona. ");
INSERT INTO loq_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Toesi ya ɓanda phɛnɛphɛ na esanga yɔnɔyɔ ekyikyi, nkombo na yango Koda, yakutaka loziɓa phɔ ya ewɛɛlɛ. Tonyɔkɔkɔ iphila ŋwana eɓɛ omokyikyi okoɓe o sima ya masuwa ");
INSERT INTO loq_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Oɓokye ɓato ɓa masuwa ɓaebaya omɔ. Ɓoɓɛlɛ, ɓaesi ya kpa nsimbi inɛnɛ, ɓaizingyi o masuwa, ɓamakangyi oɓokye mɛ sa ɔtɔnɔ. Waɓa ɓɛ́ɛ ɓaile ikyɛ baa mi bokye pha mokukulu ŋwa Libi, ɓaesi ya vaka iɓaya sɔnɔsɔ sinɛnɛ oɓokye sizimbe masuwa, mabutwe ikyɛ na mɔɔ na mɔɔ, ewɛɛlɛ yeesi ya butwa ikyɛ mi louka nde ɓaɓona. ");
INSERT INTO loq_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Ewɛɛlɛ yaɓaka kyelodikyinya nde na ɓokusi, ɓoyana ɓaesi ya ɓutwa ivaka biphɛsi banyanyaka ɓanga o maa. ");
INSERT INTO loq_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Mokɔlɔ ŋwa sima, ɓaesi ya vaka ɓɛ́ɛ mampenza ɓakapoo ɓaa masuwa solongo o maa. ");
INSERT INTO loq_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Nkɔlɔ nzikye tolokulaka wɛnɛ, eɓe moo, eɓe ɓanyasɛsi, ewɛɛlɛ yataaka ɓa nde ekusi. Tolokulaka lemela oɓokye tomobika. ");
INSERT INTO loq_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Ɓaaɓaka o masuwa ɓakɔkɔkɔ sa zaa. Ɓoɓɛlɛ, Polo aesi ya tɛmɛ onte ya ɓɛ, yokye: «Ɓɛbi, ɓo wanzokaka oɓokye ɓanga sa mana o Kɛlɛtɛ, nde tolonyɔmɔkyi ɓoɓo, nde tolobungye na mbolo ɓoɓo. ");
INSERT INTO loq_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Kasi uŋwaŋwa eye, naongye na ɓɛ́ɛ oɓokye oititale, phɔ nɔnɔ moto mɔnɔmɔ etaawe, ekpele yɔnɔyɔ eya mɔɔtɔnɔ nde masuwa. ");
INSERT INTO loq_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Ŋwaphongo, ooli Mobikye wa nga, owaa okokyelele nga, antomelakyi ŋwanze wɛ na mokɔlɔ, ");
INSERT INTO loq_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","awɔ na nga, yokye: “Polo, iwɛ sa ila! Esengyesi oɓokye okome oɓo pha Moangyesi Kaisala, phɔ ya wɛ, Ŋwaphongo na ngɔlu yɛ amobikya na ɓasɔ ɓaatambule na wɛ o masuwa”. ");
INSERT INTO loq_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Yango mɛna, ɓɛbi, oititala phɔ nakyele ndondo ya nga oka Ŋwaphongo oɓokye maphɔɔ mamana mamoɓa nde ɓo nzimolakyi ŋwanze. ");
INSERT INTO loq_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Kasi esengyesi oɓokye masuwa makyɛ lovaka o mokukulu ŋwa esanga yɔnɔyɔ ɓaɓona.» ");
INSERT INTO loq_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Tokyela nkɔlɔ iko mbuka ine, ewɛɛlɛ yaɓaka kyekyɛ na ɓanga nde ɓokyɛ o maa manɛnɛ ma Meditelane. Wa molengyela, ɓato ɓaakyele o masuwa ɓawɛnɛkyɛ oɓokye tokomi phɛnɛphɛ na manyɛtɛ. ");
INSERT INTO loq_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Ɓaesi ya meka ɓozindo pha maa, ɓawɛni oɓokye ɓoli pha ɓamɛtɛlɛ mako mane. Ɓasusa na ŋwana ɓoo, ɓakuli meka, ɓazwe ɓozindo pha ɓamɛtɛlɛ mako maato. ");
INSERT INTO loq_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Ɓailaka oɓokye masuwa sa zuma o maɓanga. Yango mɛna, ɓamba ya vaka ɓalongo ɓane o sima ya masuwa, ɓaimaka oɓokye bunya ɓoyɛɛ izele. ");
INSERT INTO loq_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Ɓato ɓaakyele o masuwa ɓalukaka ilota, ɓaesi ya uya eɓɛ̀ɛ ya masuwa o maa, ɓakyɛ vaka ɓalongo o ɓoo pha masuwa. ");
INSERT INTO loq_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Kasi Polo aesi ya wɔɔ na ɓatuluku na mokambi wa ɓɛ, yokye: «Ɓo ɓato ɓaɓa teɓaikasi o masuwa, tolokokyi ibika.» ");
INSERT INTO loq_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Ɓoɓɛlɛ, ɓatuluku ɓaesi ya tena nsimbi yaaphilaka eɓɛ̀ɛ, ɓaelɛ, ekyɛ. ");
INSERT INTO loq_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Phɛnɛphɛ na walukye iyɛ bunya, Polo aesi ya ɓanga ɓato ɓasɔ oɓokye ɓaze, yokye: «Lɔlɔ eye tokokyee nkɔlɔ iko mbuka ine, koziya nde oɓokye ewɛɛlɛ yunve, oli nde ɓaɓona sa zaa ekpele. ");
INSERT INTO loq_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Kasi naongye na ɓɛ́ɛ oɓokye oze, phɔ osengyesi na ntoma oɓokye obikye. Moto mɔnɔmɔ onte ya ɓɛ́ɛ etaabungya nɔnɔ munsuwe mɔnɔmɔ o moto nwɛ.» ");
INSERT INTO loq_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Waunva Polo iwɔ ɓaɓona, amba ya kpa mapa, aɓɔndɛsi Ŋwaphongo oɓo pha ɓasɔ, aesi ya makaɓa, ɓabuto izaa. ");
INSERT INTO loq_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Ɓoɓɛlɛ, ɓasɔ ɓabutwaka na nkyisa, ɓaesi ya zaa. ");
INSERT INTO loq_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Ɓanga ɓasɔ o masuwa, toɓaka ɓato nkama iɓale na mako sambo mbuka motoɓa. ");
INSERT INTO loq_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Waawɛnɛ ɓɛ́ɛ oɓokye ɓaokyi ntoma, ɓamba ya vaka ɓa ble o maa oɓokye masuwa malawe. ");
INSERT INTO loq_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Wayɛ bunya, ɓato ɓaakyele o masuwa teɓaikaka eɓa oɓokye ɓakomi phɛnɛphɛ na manyɛtɛ. Kasi ɓamba ya wɛnɛ iɓongu sɔnɔsɔ o iwɛɛ sa maa, ɓaesi ya kana, ɓɛkye, ɓo ɓaakokyi, ɓakyɛ sɛminya masuwa omɔ. ");
INSERT INTO loq_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Ɓamba ya tena nsimbi ya ɓalongo ɓasɔ, ɓaɓaikyi o maa, ɓamba ya ingola na nsimbi ya yenda ya masuwa. Ɓoɓɛlɛ, ɓaesi ya kyela etobu yɔnɔyɔ enɛnɛ o masuwa mopha ŋwa oɓoo, oɓokye ewɛɛlɛ eukye masuwa mopha ŋwa ibongu mɛ. ");
INSERT INTO loq_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Masuwa maesi ya kyɛ sɛlɛ na ɓokusi o bokye mɛ phaaɓaka o ntante ya maa, mopha ŋwa oɓo munyɔsi o bokye, temokuli nyingana, emba kanda yamba tena mopha ŋwa sima. ");
INSERT INTO loq_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Ɓatuluku ɓalukaka iɓoma ɓato ɓabɔlɔkɔ phɔ nɔnɔ mɔnɔmɔ na ɓɛ́ɛ sa nyongyela oɓokye alote. ");
INSERT INTO loq_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Kasi mokambi wa ɓatuluku alukaka ibikya Polo, amba ya ɓakatela oɓokye ɓalɛ. Aesi ya tomisa ɓaaeɓaka inyongyela, yokye, amikumbya o maa phanza, akyɛ abwa o ikolo. ");
INSERT INTO loq_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Ɓayɔkɔ ɓaphile o maɓaya, na o bite ɓa masuwa, ɓaɓengye ɓɛbi. Na ɓomɔ ɓaɓona, ɓanga ɓasɔ toabwaka o ikolo, tobikaka. ");
INSERT INTO loq_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Wamana ɓanga o mbale eya makama, tomba ya oka oɓokye esanga mɛ ɓaeɓangye na nkombo ya Malte. ");
INSERT INTO loq_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Ɓato ɓa esanga mɛ, ɓalookyelaka ngɔngɔ. Waɓa mbula kyenɔ, mpiyɔ yaɓaka, ɓaesi ya lokyelela ŋwenya muikye, ɓaloɓangyi ɓanga ɓasɔ oɓokye tokyɛ ɔtɔ. ");
INSERT INTO loq_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Polo aɔngɔkɔ eɓolo ya nkoo oɓokye aevakye o ŋwenya, na ina mbambisa nzɔɔ yeesi ya tɔkɔlɔ omɔ, ekatemi o eɓɔkɔ yɛ. ");
INSERT INTO loq_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Wawɛnɛ ɓato ɓa esanga oɓokye nzɔɔ ekatemi o eɓɔkɔ ya Polo, ɓawɔnɔkɔ, ɓɛkye: «Nde phɛlɛ moto oyo ali molɛmɔsi wa ɓato. Na ɓo ɓabikakyi o maa, Ŋwaphongo na ɓolomɓe phɛ, taikyi zinga oɓokye aɓe na ɓomɔ.» ");
INSERT INTO loq_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Kasi Polo, nde phɛlɛ, aesi ya nyaka nzɔɔ o ŋwenya, saoka na ŋwana ɓolɔsi. ");
INSERT INTO loq_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Ɓato ɓaziyaka nde oɓokye ɓamowɛnɛ aulo, na aka awe. Kasi, waziya ɓɛ́ɛ tee, ɓaesii ya wɛnɛ nde oɓokye tewamoyelele na lowɔ lɔnɔlɔ looɓe. Ɓamba ya ɓongola maumunya ma ɓɛ, ɓamba butwa iwɔ mbala nzikye ɓɛkye: Ali nde nzambe. ");
INSERT INTO loq_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Manyɛtɛ ma mokonzi ŋwa esanga mɛ maɓaka phɛnɛphɛ na elele mɛ, nkombo yɛ Pubilusu. Amba loyamba na ɓolaa, amba lolasa nkɔlɔ iyato. ");
INSERT INTO loq_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Ango aɓaka alangyi o ntangye, mowɛwɛ ŋwaɓaka momunyɔkɔlɔ na iphanza malongo. Polo amba yakyɛndɛ o moto ŋwa ntangye yɛ, na iɓɔndɛlɛ, amba motandela maɓɔkɔ, amba mobikya. ");
INSERT INTO loq_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Sima ya lowɔ lalona, ɓato ɓaayɔkɔ ɓa esanga ɓaaɓaka na malɔsi, ɓayakaka na ɓɛ́ɛ oka Polo, na ɓɛ́ɛ ɓabikaka mɛ. ");
INSERT INTO loq_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Ɓamba lokumola na ndengye isɔ, emba wakula ɓanga ɓenga imbanga sa ɓanga o nzela ya ebale, ɓalokokyiselaka mbolo isɔ iwaa yasengyelaka na ɓanga. ");
INSERT INTO loq_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Sima ya makombe maato, tomba ya ɓaa o masuwa masengyelaka wamɔ imbɛlɛ sisɔ sa sɛɛkyɛ. Masuwa mɛ mautaka o Alegizandri, nkombo ya mango Manzambe ma zaa. ");
INSERT INTO loq_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Toesi ya kyɛ sɛmɛ o Sirakize, tokyelaka omɔ nkɔlɔ iyato. ");
INSERT INTO loq_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Wamana ɓanga wawana, toesi nde yaɓanda mokukulu, tokyɛ koma o Regiyumu. Ɓo yana, phɛphɛkyɛ ekyeute o ngyɛlɛ, yeesi ya kyela, emba tomba ya koma o Puzɔlɛ sima ya nkɔlɔ iɓale. ");
INSERT INTO loq_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Omɔ, tokyɛzwa ɓɛbi ɓaongaka na ɓanga oɓokye tokyele pɔsɔ yɔnɔyɔ oka ɓɛ. Kyeka ɓo wakyɛ ɓanga o Loma. ");
INSERT INTO loq_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Wataɓa ɓanga o mokyisi mamuna, ɓɛbi ɓaokaka iya sa ɓanga, ɓamba ya loɓenga nɔnɔ o Zando sa Apiyusu na o elele ekyeɓangye ɓɛ́ɛ Mangambi Maato. Waɓawɛnɛ yo, Polo amba phɛ Ŋwaphongo mɛlɛsi, akuli zwa nkyisa. ");
INSERT INTO loq_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Wakoma ɓanga o Loma, ɓaanolaka oɓokye Polo akyɛ zala o elele yɛ mampenza, na tuluku mɔnɔmɔ phɔ ya imoɓanza. ");
INSERT INTO loq_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Sima ya nkɔlɔ iyato, Polo amba ya ɓanga ɓankumu oɓokye ɓaangane. Wa angana ɓɛ, amba wɔ na ɓɛ́ɛ yokye: «Ɓɛbi, nga otowaika kyela lowɔ na ɓato ɓa ɓanga naa na miɓeko ma loikyela ɓaango ɓa ɓanga, ɓakambi ɓa Ɓayuda ɓanzakyaka o Yelusalɛmɛ, ɓanzambe o maɓɔkɔ ma Ɓaloma. ");
INSERT INTO loq_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Waunva intuna mituna, ɓalukaka inkandola phɔ teɓaikaka nzwa na ná lowo lɔnɔlɔ looɓe oɓokye ɓambome. ");
INSERT INTO loq_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Kasi Ɓayuda teɓaikaka ɓanola, nambaka ɓaonga nde oɓokye nakyɛndɛ oka Moangyesi Kaisala, siikaka ɓaa na ná lowɔ la isongyela iɓota sa nga. ");
INSERT INTO loq_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Yango mɛna, naeɓangakyi oɓokye naewɛnɛ, towɛnɛ, ɓankangaka munyɔlɔlɔ mumu nde phɔ ya moto okokyelele ɓanga ɓato ɓa Yisalaɛlɛ molika.» ");
INSERT INTO loq_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Ɓaesi ya mobuyisa, ɓɛkye: «Toloika zwa nɔnɔ mokanda mɔnɔmɔ muute o Yuda phɔ ya wɛ, onte ya ɓɛbi ɓaaesi wawa, nɔnɔ mɔnɔmɔ taikyi loimola lowɔ la wɛ, naa awɔ lowɔ loɓe phɔ ya wɛ. ");
INSERT INTO loq_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Kasi ɓanga toli na phowa oɓokye oloimole ɓo koumunya wɛ, phɔ toeɓe oɓokye bilele ɓisɔ ɓaikye ziiko na ingomba sa Ɓaklisto.» ");
INSERT INTO loq_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Ɓɛ́ɛ ɓasɔ na Polo, ɓalongyibinyaka mokɔlɔ ŋwamovana ɓɛ. Wakoka mokɔlɔ mɛ, ɓato ɓaikye ɓayakaka ya ɓenga Polo o ingambi siizale yo. Polo aɓateyaka tata na mumbengu nɔnɔ wa nkɔkɔlɔ. Aɓaimolaka ɓo oli ɓokonzi pha Ŋwaphongo: Aɓatangyelaka nkanda ya miɓeko ma Mose na nkanda yaakomaka ɓamoisi, akyelaka ɓokusi oɓokye ɓaanole Yesu. ");
INSERT INTO loq_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Ɓana ɓaanolaka maphɔɔ maawɔkɔ yo, kasi ɓayɔkɔ teɓaikaka anola. ");
INSERT INTO loq_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Waiŋwa ɓɛ́ɛ oɓokye ɓabutwe, ɓaɓaka na ziiko onte ya ɓɛ. Polo aesi ya wɔ na ɓɛ́ɛ nde oɓokye: «Ɓolɔɓɔ Ɓosantu alongaka, waawɔkɔ yo na ɓankɔkɔ ɓa na nzela ya moimosi Yisaya, yokye! ");
INSERT INTO loq_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Kyɛ wɔ na iɓota sa Ɓayuda sasina ɓoɓo: “Wamooka na ɓolaa, kasi otoeɓe ntina ya maphɔɔ mɛ, Wamokyeka na ɓolaa, kasi otoowɛnɛ ekpele. ");
INSERT INTO loq_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Phɔ ntema ya ɓato ɓaɓa ibuto nkusi, Phɔ iɓota mɛ, ɓaundi matoo ma ɓɛ, sa oka, Ɓazibi miyo ma ɓɛ, oɓokye ɓɛ́ɛ sa wɛnɛ, Mandondo ma ɓɛ́ɛ mabuto makusi oɓokye Ɓɛ́ɛ sa eɓa ekpele phɔ ɓaye oka nga, naɓabikya. Eye kyewɔ nga Ŋwaphongo.” ");
INSERT INTO loq_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Emba Polo amba ya sukya yokye: Oeɓa oɓokye Ŋwaphongo atomelaka ɓato ɓaateɓali Ɓayuda Simo yɛ oɓokye ɓabikye, emba ɓɛ́ɛ ɓaamooka!» ");
INSERT INTO loq_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Wawɔ Polo ɓaɓona, Ɓayuda ɓabutwaka, ɓaphalatanaka na ɓokusi onte yaɓɛ. ");
INSERT INTO loq_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Polo aphutelaka ingambi sɔnɔsɔ o Loma. Akyelaka mambula maɓale omɔ. Ayambaka ɓato ɓasɔ ɓaaɓaka ɓaya mokyeka. ");
INSERT INTO loq_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Aimolaka ɓo li ɓokonzi pha Ŋwaphongo, ateyaka maphɔɔ ma Nkolo Yesu Klisto pwapwa. Moto nɔnɔ mɔnɔmɔ taikaka mokatela.");
INSERT INTO loq_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Mokanda mumu moute na nga Polo, moto wa etoma wa Yesu Klisto. Ŋwaphongo ambanga phɔ ya iɓaa toma yɛ, anzɔlɔ phɔ nakyɛndɛ imola Simo Elaa yɛ oka ɓato, ");
INSERT INTO loq_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Simo Elaa mɛ, Ŋwaphongo alolakyelaka yango o buku phɛ na munɔkɔ ŋwa ɓaimosi ɓɛ́ɛ ɓaaphanza. ");
INSERT INTO loq_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Simo Elaa mɛ kye wɔ phɔ ya Ŋwana wɛ Yesu Klisto Nkolo wa ɓanga. Na ɓomoto aɓotama o iɓota sa mokonzi Davidi. ");
INSERT INTO loq_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Wa kundwa yo, Bolɔɓɔ amowɛninyaka Ŋwana wa Ŋwaphongo owa mwiya. ");
INSERT INTO loq_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Na nzela ya Yesu, Ŋwaphongo na ngɔlu yɛ amba ya ntoma phɔ ya ngambo ya Yesu, phɔ na kyɛ miimola ɓato ɓa nkyisi isɔ iloɓa sɛ phɔ ɓa moanole ɓambe na motosa. ");
INSERT INTO loq_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Ɓɛ̀ɛ ɓato ɓa Loma oli na ɓɛ̀ɛ nde ɓo ɓato mɛ, ɓɛ̀ɛ ɓato ɓaaɓanga Ŋwaphongo phɔ o ɓe ɓato ɓa Yesu Klisto. ");
INSERT INTO loq_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Emba naekomele ɓɛ́ɛ ɓasɔ, Ŋwaphongo kaezingye ɓɛ́ɛ ɓali phɔ yɛ. Ŋwaphongo Ango wa ɓanga na Yesu Klisto Nkolo wa ɓanga aephɛ ngɔlu na ɓose. ");
INSERT INTO loq_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","O eɓandele, na nzela ya Yesu Klisto, na phɛ Ŋwaphongo wa nga mɛlɛsi phɔ ya ɓɛ́ɛ ɓasɔ, phɔ o munse munsɔ, ɓato ɓawɔɔ phɔ ya ianola sa ɓɛ. ");
INSERT INTO loq_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Ŋwaphongo kaeɓe oɓokye iikyi wɔ nga ili phɛlɛ, iyo okokyelele nga etoma na ndondo yɔnɔyɔ ná iimola Simo Elaa ekyekyi Ŋwana wɛ. Kaeɓe oɓokye nkɔlɔ isɔ wa ɓɔndɛlɛ nga na ɓɔndɛlɛ phɔ ya ɓɛ. ");
INSERT INTO loq_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Mbala isɔ o maɓɔndɛsi ma nga na ongye na Ŋwaphongo oɓokye ɓoeɓe mokano nwɛ, aingole nzela oɓokye nata na yaa ekyeka. ");
INSERT INTO loq_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Phɔ nasepele na ɓoikye iyaa ephɛ ikaɓo siuti na Ɓolɔɓɔ Ɓosantu phɔ ya iyaekuya. ");
INSERT INTO loq_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Nazingye oɓokye ɓanga ɓasɔ tokuyinyakye onte ya ianola sa ɓanga oka Klisto. ");
INSERT INTO loq_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Ɓaande, eɓa oɓokye mbala nzikye naumunya iya ekyeka, kasi tewa longoɓane. Phɔ phowa ya nga eli oɓokye etoma ya nga eɓote mbuma oka ɓɛ̀ɛ ɓo wa ɓota yango o nkyisi iyɔkɔ, ");
INSERT INTO loq_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Ŋwaphongo ampɛ etoma mɛ. Yango mɛna nasengyesi iimola Simo Elaa oka ɓato ɓasɔ, eɓe ɓato ɓali o nkyisi inɛnɛ, eɓe ɓato ɓali o nkyisi ya mongonda. Na moeyimola oka ɓato ɓaekola na oka ɓato ɓate ɓaika ekola. ");
INSERT INTO loq_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Yango mɛna nali na phowa ya iyaa eimola Simo Elaa na ɓɛ̀ɛ ɓato ɓali o Loma mɛ. ");
INSERT INTO loq_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Sili na sɔɔ ya iimola Simo Elaa. Yango Eli mwiya ŋwa Ŋwaphongo moobikya ɓato ɓasɔ ɓaanola Yesu Klisto: Ɓayuda phanza, emba ɓaate ɓali Ɓayuda sima. ");
INSERT INTO loq_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Simo Elaa mɛ kyewɛninya ndengye ekye buya Ŋwaphongo ɓato, ɓato ɓa ɓosembo o miyo mɛ. Esengyesi nde oɓokye ɓato ɓaanole nde Yesu Klisto, nzela esuu teeli. Nde ɓo wakomama wɛ o buku pha Ŋwaphongo oɓokye: «Moto wa ɓosembo, amobika na ianola sɛ.» ");
INSERT INTO loq_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Uta o ikolo, Ŋwaphongo kawɛninya yɔɔ yɛɛ phɔ ya masumu masɔ na ɓoɓe ɓosɔ ɓokyele ɓato, maphɔɔ maɓe makyele ɓɛ́ɛ makatele ɓato saeɓa nzela ya ɓosembo. ");
INSERT INTO loq_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Ŋwaphongo aaɓaphɛ etumbu phɔ nzela ekokakyi na ɓɛ́ɛ imoeɓa eli polele, Ŋwaphongo yo mampenza aɓateya yango kasi ɓɛ́ɛ te ɓaikyi eɓanga. ");
INSERT INTO loq_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Uta waakyela Ŋwaphongo mokyisi, bikpele biakyela yo biwɛninya ɓato polele ɓooli yo, naɓo tebiiwɛnɛnɛ na miyo. Emba te ɓakokyi iwɔ oɓokye teli ɓoɓe pha ɓɛ́ɛ ɓo teɓaamotosa. ");
INSERT INTO loq_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Naɓo okoeɓe ɓɛ́ɛ oɓokye Ŋwaphongo alii, teɓaamokumole, teɓamophɛ na mɛlɛsi ɓo sengyesi ɓɛ́ɛ ikyelela Ŋwaphongo. Maumunya ma ɓɛ́ɛ mali nde o maphɔɔ mpamba, ɓataaɓa o enzɔmbi, te ɓaeɓe na lowɔ loolaa. ");
INSERT INTO loq_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Ɓamitate oɓokye ɓali ɓato ɓa malondo, nzuka ɓali nde ɓato ɓa nyaa. ");
INSERT INTO loq_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Oɓokye ɓakumbele Ŋwaphongo owa nkyɛmɔ, otoowe, ɓakumbele nde bikyeko baulana na moto ookowe, bikyeko biiyɔkɔ bauluna na manyɔsi, biiyɔkɔ na manyama, bina bikuli ɓa ndokolo manyama maalande na ibuu. ");
INSERT INTO loq_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Yango mɛna Ŋwaphongo amba ɓalɛ phɔ ɓakyele maphɔɔ maaɓe ɓozingye ɓɛ́ɛ ikyela, emba ɓambe kyela maphɔɔ ma sɔɔ onte ya ɓɛ. ");
INSERT INTO loq_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Ɓalɛ ɓosembo pha Ŋwaphongo, ɓaɓengyi nde ɓɔɔlɛ. Ɓakumbele bikpele ɓakyela Ŋwaphongo, ɓabikyelele, kasi ona Ŋwaphongo owa bikyela teɓoamokumole, osengyesi ɓɛ́ɛ ikumbela nkɔlɔ isɔ. Amɛ. ");
INSERT INTO loq_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Yango mɛna Ŋwaphongo aɓalɛ phɔ ɓakyele maphɔɔ masɔ maakane ɓɛ́ɛ ikyela. Ɓaɓasi ɓalɛ ɓampele ɓabuto ikyela maphɔɔ ma sɔɔ ɓɛ́ɛ na ɓɛ. ");
INSERT INTO loq_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Ɓampele nde ɓomɔ mɛ, ɓalɛ ɓaɓasi, ɓali na phowa ekusi ya ikpa ɓampele ɓasu ndokolo ɓaɓasi. Ɓampele na ɓampele ɓakyele maphɔɔ ma sɔɔ. Ɓamiɓangyesi etumbu ekokyi phɔ ya masumu makyele ɓɛ. ");
INSERT INTO loq_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Phɔ ɓato ɓalɛ ieɓa Ŋwaphongo, Ŋwaphongo aɓalɛ na maumunya ma ɓɛ́ɛ maɓe phɔ ɓakyele maphɔɔ maɓe matemakokyi ɓɛ́ɛ ikyela. ");
INSERT INTO loq_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Mandondo ma ɓɛ́ɛ matonda na maphɔɔ maaɓe, ɓamengyele mbolo ya ɓato, ɓakyelane ɓoɓe, ɓaokyenele zuwa, ɓaɓome ɓato, ɓaokye maoka, ɓakatele ɓato, ɓaine ɓato, ɓayɔɔ ɓato. ");
INSERT INTO loq_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Ɓakyɛmiwɔlɛ ɓɛbi na ɓɛ́ɛ na ɓoɓe, ɓali ɓanguna ɓa Ŋwaphongo ɓatole ɓɛbi, ɓali ɓato ɓa lolɛndɔ, ɓamitate. Ɓaumunya nkɔlɔ isɔ nde ikulaka kyela masumu, teɓatosa ɓaɓoti ɓaɓɛ. ");
INSERT INTO loq_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Teɓakule eɓa lowɔ lolaa, teɓakokya mambunu ma ɓɛ, teɓaeɓe izinga ɓato, teɓali na ngɔngɔ na moto. ");
INSERT INTO loq_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Ɓaeɓe na ɓolaa oɓokye moɓeko ŋwa Ŋwaphongo mowɔ oɓokye: Ɓato ɓakyele maphɔɔ maɓe ndengye mɛna, ɓakokyi na iwaa. Na ɓokoeɓe ɓɛ́ɛ ɓaɓona, ɓakule kyela nde maphɔɔ maaɓe. Te eni ɓa nde yango miina, ɓasambe wa wɛnɛ ɓɛ́ɛ ɓɛbi na ɓɛ́ɛ ɓakyele maphɔɔ maɓe. ");
INSERT INTO loq_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Iwɛ, oɓe na nzaa, okosambisa ɓɛbi, eteɓaelimbisa. Phɔ waasambisa wɛ moto, kominyɛtɛ wɛ mampenza, phɔ na wɛ kokyele ɓomɔ mɛ, iwɛ okosambisa ɓɛbi. ");
INSERT INTO loq_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Nzuka ɓanga toeɓe oɓokye isambisa sa Ŋwaphongo sikyelame na ɓosembo phɔ ya ɓato ɓakyele maphɔɔ maɓe. ");
INSERT INTO loq_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Koumunya oɓokye iwɛ ookosambisa ɓato ɓakyele ɓoɓe na ɓakyele ya ɓɛ, wamolota isambisa saka Ŋwaphongo? ");
INSERT INTO loq_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Naa iwɛ kotiyole ɓolaa pha Ŋwaphongo, na iyɔsa sɛ, na ndondo elaa yɛ, saeɓa oɓokye ɓolaa phɛ ɓoetomisa oɓokye oɓongole motema? ");
INSERT INTO loq_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Na moto ɓokusi ŋwa wɛ, na ndondo ya wɛ ete okye na wɛ ngɔngɔ, komiɓangyele kabu o mokɔlɔ ŋwaa kabu wamokyelama sakolo isambisa sa Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Amophɛ moto na moto iɓonza kokokana na bitoma ɓɛ: ");
INSERT INTO loq_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Ɓomɔɔ pha ɓoɓɛlɛ phɔ ya ɓato ɓawaa, na ilendendala sa ɓɛ́ɛ sa ikyela ɓolaa, ɓaluye nkyɛmɔ, ngambo na ɓosembo, ");
INSERT INTO loq_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","kasi yɔɔ na kabu yamoɓa phɔ ya ɓato ɓaatɔmbɔ, ɓaatɛmɛlɛ ɓosembo ɓambe na miambya o maphɔɔ matemali na ɓosembo. ");
INSERT INTO loq_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Ngɔngɔ na minyɔkɔ yamoɓa phɔ ya moto okokyele ɓoɓe, phɔ ya Moyuda phanza na phɔ ya moto otoli moyuda. ");
INSERT INTO loq_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Nkyɛmɔ, ngambo na ɓose oka moto munsɔ okokyele ɓola, oka Moyuda phanza, sima oka moto ootoli moyuda ");
INSERT INTO loq_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Phɔ oka Ŋwaphongo, ɓato ɓasɔ ɓali nde ndengye yɔnɔyɔ. ");
INSERT INTO loq_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Ɓato ɓasɔ ɓaakyela masumu saeɓa moɓeko ɓamowa samiɓeko mɛ. Ɓato ɓasɔ ɓaakyela masumu na ɓoeɓakye moɓeko, ɓamosambisama na moɓeko. ");
INSERT INTO loq_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Phɔ teli ɓato ɓaokye moɓeko ɓaali ɓato ɓa ɓosembo o ɓoo pha Ŋwaphongo, ɓato ɓa ɓosembo eli nde ɓaakyelele moɓeko mɛ. ");
INSERT INTO loq_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Waaɓe ɓapakano saeɓa moɓeko, ɓakyele ikyitomisa moɓeko, ɓamibuya moɓeko ɓɛ́ɛ mampenza, ɓɛ́ɛ ɓaate ɓali na moɓeko. ");
INSERT INTO loq_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Ɓateya oɓokye bitoma bizingye moɓeko biakamama o mandondo ma ɓɛ. Mandondo ma ɓɛ́ɛ mawɔ mɛ na maumunya ma ɓɛ, bina ma ɓaphunde bina ma ɓaambelele. ");
INSERT INTO loq_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Maphɔɔ mɛ mamotɔkɔlɔ mokɔlɔ ŋwaa mosambisa Ŋwaphongo na nzela ya Yesu Klisto, moɓesi munsɔ ŋwa ɓato ŋwaa ɓombama, ɓowawɔ Simo Elaa ekyeimole nga. ");
INSERT INTO loq_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Kasi ɓo wɛ ookoɓangye ɓɛ́ɛ Moyuda, ootɛmi nde o moɓeko na ookyesi lolɛndɔ lɛ oka Ŋwaphongo wɛ, ");
INSERT INTO loq_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","koeɓe maphɔɔ mazingye yo, na moɓeko ŋwa eteya iyɔlɔ maphɔɔ maala. ");
INSERT INTO loq_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Koumunya iɓa moteye ŋwa ɓato ɓaaphɔlɔ miyo nzela, tala phɔ ya ɓato ɓaali o enzɔmbi, ");
INSERT INTO loq_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","moteye ŋwa ɓato ɓate ɓaeɓe ekpele na moteye ŋwa ɓato ɓaate ɓali na ngambo, phɔ koanole oɓokye nanzela ya moɓeko, oli na phaakolo ɓoeɓakye na ná maphɔɔ ma phɛlɛ. ");
INSERT INTO loq_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Ee ɓolaa! Iwɛ okoteya nwɛbi, tomiteya wɛ mampenza! Koteya oɓokye ɓato saiɓa, emba iwɛ koiɓe! ");
INSERT INTO loq_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Kokatele ɓato ikyela ɓaphemba, emba iwɛ kokyele ɓaphemba! Toozingye bikyeko, kasi koiɓe mbolo ili o makɔkɔ ma ɓɛ! ");
INSERT INTO loq_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Kokyele lolɛndɔ la wɛ o miɓeko, kasi tookumole Ŋwaphongo waate waakumole wɛ mina miɓeko! ");
INSERT INTO loq_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Phɔ, nde ɓo wakoma ɓɛ́ɛ oɓokye: «Nkombo ya Ŋwaphongo etolami phɔ ya ɓɛ̀ɛ onte ya ɓapakano.» ");
INSERT INTO loq_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Tewali ziko, iɓɛlɛ sili na ntina ɓo kokyelele miɓeko, kasi ɓo tokumole miɓeko, na iɓɛlɛ sa wɛ, oli nde moto oli mungbɔtu. ");
INSERT INTO loq_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Kasi ɓo moto oli mungbɔtu kakumole ikyiwɔ miɓeko, ɓomungbɔtu phɛ ete ɓaɓokye ndokolo iɓɛlɛ? ");
INSERT INTO loq_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Emba yo otoika ɓɛlɛ o nzoto, ɓo kakokya miɓeko, amoesambisa; iwɛ ooli na buku pha miɓeko na owa ɓɛlɛ ɓɛ, kasi tookumole mina miɓeko. ");
INSERT INTO loq_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Phɔ teli maphɔɔ mawɛnɛnɛ maakyele oɓokye moto ali Moyuda, naa mbasi ikyiwɛnɛnɛ o nzoto ikyikyele iɓɛlɛ, ");
INSERT INTO loq_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","kasi eli nde maphɔɔ maɓombama maakyele oɓokye moto ali Moyuda, emba iɓɛlɛ eli nde sa motema, siute na Ɓolɔɓɔ, kasi sa buku phe. Owaakolo Moyuda mɔna kazwe ngambo yɛ oka Ŋwaphongo, kasi oka ɓato phe. ");
INSERT INTO loq_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Ntina ya iɓa Moyuda eli iye? Ntina ya iɓɛlɛ eli iye? ");
INSERT INTO loq_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Ntina eli enɛnɛ phɔ ya ɓato ɓasɔ! Emba phanza oka ɓato ɓaaphɛkyɛ Ŋwaphongo mambunu mɛ. ");
INSERT INTO loq_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Kasi tomowɔ ɓo? Ɓo ɓakyi ɓaɓaka sakokya yasengyelaka ɓɛ́ɛ ikyela, ɓoɓe pha ɓɛ́ɛ phamokyela oɓokye Ŋwaphongo sakula kokya yaa lakaka yo? ");
INSERT INTO loq_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Phee! Ŋwaphongo asengyesi ieɓana oɓokye ali moto wa maphɔɔ maa phɛlɛ; naɓo moto munsɔ ali moto wa ɓɔɔlɛ, ɓowakomama wɛ oɓokye: «Esengyesi oɓokye oeɓane moto wa ɓosembo onte ya maloɓa ma wɛ, emba olongye imbɛlɛ saamoesambisa ɓɛ.» ");
INSERT INTO loq_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Kasi ɓo izanga ɓosembo sa ɓanga siwɛninya ɓosembo pha Ŋwaphongo, tomowɔ ɓo? Ŋwaphongo kazangye ɓosembo waalowande yo na kabu yɛ? Nawɔ ndengye ekyeumunya ɓato. ");
INSERT INTO loq_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Phee! Phɔ ɓoeli ɓomɔ, Ŋwaphongo amosambisa mokyisi ndengye'ye? ");
INSERT INTO loq_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Kasi ɓo ɓɔɔlɛ pha ɓanga ɓowɛninya ɓosembo pha Ŋwaphongo, na phɔ ya nkyɛmɔ yɛ, phɔ ya'ye nga, nakule kangyema ndokolo moto wa masumu? ");
INSERT INTO loq_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Emba, phɔ ya'ye tolokyele ɓoɓe phɔ ɓolaa ɓoyee, ɓookokyɛminvɔlɛ ɓato ɓa ɓɔɔlɛ ɓaayɔkɔ? Ɓato mɛ ɓakokyi na etumbu! ");
INSERT INTO loq_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Ka ɓo? Tokuli ɓa, ɓanga Ɓayuda na ɓokonzi mi ɓɛbi? Na ŋwana ɓokyikyi phe! Phɔ toumbo loteya oɓokye: Ɓanga ɓasɔ, Ɓayuda na ɓaate ɓali Ɓayuda, toli ɓanga ɓasɔ o se ya ɓokonzi pha masumu. ");
INSERT INTO loq_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Eli nde ɓo wakoma ɓɛ́ɛ o buku pha Ŋwaphongo oɓokye: «Moto molaa tali, na mɔnɔmɔ phee, ");
INSERT INTO loq_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","moto okosɔsɔlɔ tali, na mɔnɔmɔ taalukye Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Ɓato ɓasɔ teɓakuli ɓenga nzela elaa, ɓɛ́ɛ ɓasɔ ɓabunza, na mɔnɔmɔ taakyele ɓolaa, na mɔnɔmɔ phee. ");
INSERT INTO loq_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Nɔkɔ ya ɓɛ́ɛ ili ndokolo ilita siili munɔkɔ pha, na lolee la ɓɛ, ɓakate ɓɔɔlɛ, ngyɛngyi ya nzɔɔ eli o biɓaa ɓa ɓɛ. ");
INSERT INTO loq_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Nɔkɔ ya ɓɛ́ɛ yatonda na bitoo na ná maloɓa maa ɓololo. ");
INSERT INTO loq_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Makolo ma ɓɛ́ɛ makyɛ mizele o ikyɛ ɓoma moto. ");
INSERT INTO loq_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Iɔtɔ na ngɔngɔ ili o manzela maatambule ɓɛ, ");
INSERT INTO loq_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","emba nzela ya ɓose, ɓɛ́ɛ teɓaeyeɓe. ");
INSERT INTO loq_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Teɓali na ɓoilakye pha Ŋwaphongo o miyo ma ɓɛ.» ");
INSERT INTO loq_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Kasi toeɓe oɓokye isɔ ikyiwɔ moɓeko, kaiwɔ na ɓato ɓasɔ ɓaali o se ya moɓeko, phɔ moto satakola munɔkɔ phɔ ya isamba, emba munse munsɔ moeɓane moɓe o miyo ma Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Kyeka phɔ ya'ye moto na mɔnɔmɔ eta ɓe mola o ɓoo phɛ phɔ ya bitoma ba moɓeko, phɔ moɓeko kateya ɓato nde oɓokye ɓakyesi masumu. ");
INSERT INTO loq_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Kasi, uŋwaŋwa eye, na nzela ya moɓeko phe, ɓosembo pha Ŋwaphongo phaa miteya, moɓeko na ɓaimosi ɓawɔ phɔ yɛ. ");
INSERT INTO loq_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Ŋwaphongo kaɓuya ɓato, ɓato ɓa ɓosembo o miyo mɛ na nzela ya ianola sa ɓɛ́ɛ oka Yesu Klisto. Kakyele ɓaɓona phɔ ya ɓato ɓasɔ ɓaanole, phɔ tewali ɓokyɛsɛ. ");
INSERT INTO loq_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Phɔ ɓato ɓasɔ ɓakyesi masumu, emba ɓaimasi nkyɛmɔ ya Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Kasi Ŋwaphongo na ngɔlu yɛ, aɓabuya ɓato ɓa ɓosembo o miyo mɛ nde pha, kakyele ɓaɓona na nzela ya Yesu Klisto oko ɓaikole o masumu. ");
INSERT INTO loq_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Ŋwaphongo amoambya mbeka, phɔ oɓokye awe phɔ ya ɓanga, phɔ malongo mɛ mamanya masumu ma ɓanga, nzela mɛ Ŋwaphongo aeyingola phɔ ya ɓato ɓaanole Yesu Klisto. Kakyele ɓaɓona phɔ ya iwɛninya oɓokye ali na ɓosembo. Masumu maakyeleka ɓato phanza, Ŋwaphongo akyelaka ndokolo taikaka mawɛnɛ, ");
INSERT INTO loq_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","imbɛlɛ saaɓaka yo na motema moanda. Kateya ɓosembo phɛ imbɛlɛ sa lɔlɔ, phɔ aɓe na ɓosembo, ambe na ibuya ɓato ɓaanole Yesu ɓato ɓa ɓosembo. ");
INSERT INTO loq_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Oli wango ɓaɓona, ekpele yɔnɔyɔ eekokyi na ɓanga imitata eli? Phee, teli. O nkombo ya'ye? Ya bitoma? Phe, kasi o nkombo ya ianola. ");
INSERT INTO loq_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Phɔ toeɓe oɓokye ɓato ɓabutwe ɓato ɓa ɓosembo o miyo ma Ŋwaphongo nde na ianola; kasi phɔ ya bitoma ba ɓɛ́ɛ ɓo koongye moɓeko phe. ");
INSERT INTO loq_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Naa oɓokye, Ŋwaphongo akokyi iɓaa nde Ŋwaphongo wa Ɓayuda? Tali na Ŋwaphongo wa ɓapakano? Eli ɓomɔ, ali na Ŋwaphongo wa ɓapakano, ");
INSERT INTO loq_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Phɔ Ŋwaphongo ali nde yo mɔnɔmɔ owa mobuya ɓato ɓa ɓosembo ɓato ɓaaɓɛlɛ ɓɛ́ɛ na ɓaate ɓaika ɓɛ́ɛ ɓɛlɛ phɔ ya ianola. ");
INSERT INTO loq_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Kyelukye iwɔɔ oɓokye na ianola mɛna tomanya ngambo eli na moɓeko? Phe, mɛna tokule nde phɛ moɓeko eyaakolo ngambo ya ŋwango. ");
INSERT INTO loq_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Emba tomowɔ ɓo phɔ ya Abalayama nkɔkɔ wa ɓanga? Lokola moto, azwaka iye? ");
INSERT INTO loq_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Ɓo Abalayama abutwaka moto wa ɓosembo o miyo ma Ŋwaphongo phɔ ya bitoma ɓɛ, akokyi imitata. Kasi oɓoo pha Ŋwaphongo phe! ");
INSERT INTO loq_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Phɔ buku ɓowɔ ɓo? Abalayama aɓaka na ianola oka ŋwa Ŋwaphongo, emba ɓamotanga moto wa ɓosembo. ");
INSERT INTO loq_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Nzuka phɔ ya moto okokyele bitoma, iphuti sɛ tesitangyeme ndokolo ngɔlu, kasi ndokolo mbano. ");
INSERT INTO loq_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Kasi phɔ ya moto otokyele bitoma kasi kaanole moto okoɓuya moto moɓe moto wa ɓosembo, Ŋwaphongo kakyeke ianola sɛ, kaambe mobuya moto wa ɓosembo. ");
INSERT INTO loq_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Yango mɛna Davidi kakumisa ɓoola pha moto okobuya Ŋwaphongo moto wa ɓosembo sakyeka bitoma ɓɛ. ");
INSERT INTO loq_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","Nkɔnzɔ eli na ɓato ɓalimbise ɓɛ́ɛ ɓoɓe pha ɓɛ́ɛ ná masumu ma ɓɛ. ");
INSERT INTO loq_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Nkɔnzɔ eli na moto owa Ŋwaphongo taakyeke isumu sɛ. ");
INSERT INTO loq_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Bola ɓoowɔ ɓɛ́ɛ ɓaɓona ɓoli nde phɔ ya ɓaaɓɛlɛ na ɓaaɓɛlɛ, ndee na phɔ ya ɓate ɓaika ɓɛ́ɛ ɓɛlɛ mɛ? Phɔ towɔ oɓokye ianola sa Abalayama samobuya moto wa ɓosembo. ");
INSERT INTO loq_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Wango wakyelama imbɛlɛ iye? O ɓoo nde o sima ya iɓɛlɛ sɛ? Teli sima, kasi phanza! ");
INSERT INTO loq_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Emba iɓɛlɛ simophɛ elembo ya ɓosembo pha zwa yo na nzela ya iamola, wataaka ɓa yo sa ɓoɓɛlɛkye. Yango mɛna abutwaka na ango wa ɓato ɓasɔ ɓateɓaika ɓɛlɛ ɓɛ́ɛ ɓaanola, phɔ ya oɓokye na ɓɛ́ɛ ɓabutwe ɓato ɓa ɓosembo. ");
INSERT INTO loq_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Ali na ango wa ɓaaɓɛlɛ ɓɛ, na ɓasɔ ɓali o ingomba sa ɓato ɓaɓɛlɛ nde ɓoɓɛsi phe, kasi na ɓaatambule o matambe ma ianola sa ango wa ɓanga Abalayama, oɓoo pha oɓokye ɓamoɓɛlɛ. ");
INSERT INTO loq_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Phɔ, teeli phɔ ya moɓeko, kasi phɔ ya ɓosembo pha ianola, mbunu eya izwa mokyisi ndokolo ilaka sikabi ɓɛ, ya lakyelamaka na Abalayama na ná ɓana ɓɛ. ");
INSERT INTO loq_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Ɓo ɓaakumole moɓeko ɓaɓe mandomi, ianola nde tesikuli ɓa na ntina na mbunu ya Ŋwaphongo nde teekuli ɓaa na elele. ");
INSERT INTO loq_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Phɔ moɓeko kaɓote yɔɔ. Elele eteli na moɓeko, tewali omɔ na lowɔɔ la itiyola moɓeko. ");
INSERT INTO loq_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Na ianola tobutwe mandomi, phɔ yango eɓe oɓokye na ngɔlu na oɓokye mbunu eikale na ntina phɔ ya ɓankɔkɔ ɓa Abalayama, yango saɓa nde phɔ ya ɓɛ́ɛ ɓamitangye ɓaa moɓeko, kasi na phɔ ya ɓamitangye ɓa ianola sa Abalayama, ango wa ɓanga ɓasɔ. ");
INSERT INTO loq_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Phɔ wakomama oɓokye: «Naebuyee ango wa ɓato ɓaikye.» Ali ango wa ɓanga o ɓoo pha owa anola yo, Ŋwaphongo ookoakole ɓawe na ookotɔkɔlɔ o mokyisi iteili. ");
INSERT INTO loq_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Na ilemela sa saphɛmbɛ, «aanola emba amba butwa ango wa ɓato ɓaikye», ɓo wa wɔ Ŋwaphongo oɓokye: «Ɓankɔnkɔ ɓa wɛ ɓamoɓa ɓoɓo.» ");
INSERT INTO loq_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Na ɓokyekakye nzoto yɛ, aɓaka phɛnɛphɛ na mambula munkama kasi taika phɛmbɛ o ianola - Naɓo awɛnɛkyɛ oɓokye yo na ŋwaŋwasi wɛ Sala ɓakotoo ɓabutoo phɛnɛ phɛ na iwaa. ");
INSERT INTO loq_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","O ɓoo pha mbunu ya Ŋwaphongo, taika ika ziko, kasi azwaka ɓokusi na ianola emba amba phɛ Ŋwaphongo nkyɛmɔ. ");
INSERT INTO loq_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Aɓaka na ianola oɓokye Ŋwaphongo ali na mwiya ŋwa ikokya yaalakyela yo. ");
INSERT INTO loq_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Yango mɛna Ŋwaphongo atanga Abalayama o molɔngɔ ŋwa ɓato ɓa ɓosembo, phɔ ya ianola sɛ. ");
INSERT INTO loq_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Nzuka tewaikaka komama ɓaɓona phɔ yɛ mampenza oɓokye: «Yango mɛna ɓamotanga o molɔngɔ ŋwa ɓato ɓa ɓosembo». ");
INSERT INTO loq_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Kasi na phɔ ya ɓanga mɛ ɓaanola, phɔ toanole oka moto owa kundwa onte ya ɓawe, Nkolo Yesu. ");
INSERT INTO loq_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Ɓamokaɓa o iwa phɔ ya ɓoɓe pha ɓanga, amba kundwa phɔ ya ilobuya na ɓanga ɓato ɓa ɓosembo. ");
INSERT INTO loq_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Yango mɛna, toli ɓato ɓa ɓosembo phɔ ya ianola sa ɓanga, toli ɓose na Ŋwaphongo phɔ ya Nkolo wa ɓanga Yesu Klisto. ");
INSERT INTO loq_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Na nzela yɛ, na ianola, ɓaloanosi izwa ngɔlu ya Ŋwaphongo ekyekyele oɓokye tomitate na molemo ŋwa nkyɛmɔ ya Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Na koleka, tomitate na o mampasi, phɔ toeɓe oɓokye mpasi kaɓote ilendendala, ");
INSERT INTO loq_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","ilendendala kaɓote iititala simekyi ɓɛ, iititala simekyi ɓɛ́ɛ siɓote molemo. ");
INSERT INTO loq_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Emba molemo taakate, phɔ Ɓolɔɓɔ Ɓosantu phaalophɛkyɛ ɓɛ, anyangola lozingo la Ŋwaphongo o mandondo ma ɓanga. ");
INSERT INTO loq_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Phɛlɛ, wataka ɓa ɓanga naino sa ɓokusi, Klisto, o imbɛlɛ sameka ɓɛ, awa phɔ ya ɓato ɓaɓe. ");
INSERT INTO loq_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Eli nkamba oɓokye ɓaanole iwa phɔ ya moto molaa. Moto akoyi ikoka izwa ɓokusi pha iwa phɔ ya moto molaa. ");
INSERT INTO loq_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Kasi Ŋwaphongo kateya lozingo lɛ oka ɓanga na ɓoɓo: Klisto awa phɔ ya ɓanga, mɛna totaɓa naino ɓato ɓa masumu. ");
INSERT INTO loq_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Emba oobuto ɓanga uŋwaŋwa eye ɓato ɓa ɓosembo phɔ ya malongo mɛ, tomobika nɛ o kabu ya Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Phɔ ɓo eɓe oɓokye wataka ɓa ɓanga ɓanguna ɓa Ŋwaphongo, toɓɔngyɛkyɛ nɛ na iwa sa Ŋwana wɛ, ka ombi ɓɔngya ɓanga, tomobika na ɓomɔɔ phɛ. ");
INSERT INTO loq_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Teli nde ɓaɓona, waakule mitata ɓanga oka Ŋwaphongo na nzela ya Nkolo wa ɓanga Yesu Klisto, na nzela ya yɛ, uŋwaŋwa eye, tozwe maɓɔngyɛ. ");
INSERT INTO loq_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Isumu sanyɔlɔ o mokyisi na nzela ya moto mɔnɔmɔ, Adama, emba iwa na nzela ya isumu. Nde ɓomɔɔ iwa siesi phɔ ya ɓato ɓasɔ, phɔ ɓato ɓasɔ ɓakyela isumu. ");
INSERT INTO loq_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Phɔ, nɔnɔ o moɓeko, isumu saɓaka o mokyisi emba na ɓo isumu tesaikaka zwa etumbu wa tewaɓaka moɓeko. ");
INSERT INTO loq_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Kasi uta oka Adama nɔnɔ oka Mose iwa saɓaka, na oka ɓateɓaikaka kyela isumu na itiyola moɓeko ndengye yɔnɔyɔ na Adama owa ulana na owa moya. ");
INSERT INTO loq_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Kasi tewali ɓomɔ phɔ ya ikaɓo sa ngɔlu phɔ ya ɓoɓe. Phɔ, ɓo phɔ ya ɓoɓe pha moto mɔnɔmɔ ɓato ɓaikye ɓawe, ka phɔ ya ngɔlu ya Ŋwaphongo, ngɔlu eelokyelesi yo na moto mɔnɔmɔ, Yesu klisto, enyango na ɓoikye mi ɓato ɓoikye. ");
INSERT INTO loq_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Emba teli ɓomɔ mɛ phɔ ya ikaɓo ɓo phɔ isumu sa moto mɔnɔmɔ. Phɔ, phɔ ya isumu sa moto mɔnɔmɔ isamba sikambe o etumbu, kasi ɓoɓe ɓoikye, ikaɓo sa ngɔlu sikambe o ɓosembo. ");
INSERT INTO loq_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Phɔ ɓo phɔ ya moto mɔnɔmɔ, na nzela ya ɓoɓe pha moto mɔnɔmɔ iwa siesi, ka phɔ ya moto mɔnɔmɔ Yesu Klisto, ɓato ɓaikye ɓaamoɓa na ɓomɔ ɓamozwa ngɔlu na ɓoikye na ikaɓo sa ɓosembo. ");
INSERT INTO loq_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Yango mɛna, ooli phɔ ya ɓoɓe pha moto mɔnɔmɔ ɓato ɓasɔ ɓazwe etumbu, nde ɓomɔ mɛ phɔ ya etoma ya ɓosembo ya moto mɔnɔmɔ, eli phɔ ya ɓato ɓasɔ ɓosembo ɓoo ambya ɓomɔ. ");
INSERT INTO loq_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Nde phɔ ya oɓokye na izanga ɓotosi pha moto mɔnɔmɔ, ɓato ɓaikye ɓabutwakyi ɓato ɓamasumu, nde ɓomɔ mɛ na itosa sa moto mɔnɔmɔ ɓato ɓabuto ɓato ɓa ɓosembo o miyo ma Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Moɓeko moesi phɔ ya oɓokye ɓoɓe ɓotonde. Elele eli masumu maikye, ngɔlu na yango etondi wamɔ. ");
INSERT INTO loq_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Phɔ ya oɓokye ɓo oesi isumu phɔ ya iwa, nde ɓomɔ phɔ ya ɓosembo, ngɔlu eesi phɔ ya ɓomɔɔ pha ɓoɓɛlɛ na nzela Yesu Klisto, Nkolo wa ɓanga. ");
INSERT INTO loq_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Tomba wɔ ɓo? Toikale nde oikyela maasumu, phɔ ngɔlu ya Ŋwaphongo etonde? ");
INSERT INTO loq_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Tekokyi iɓa ɓomɔ. Na isumu toli ɓawe, tomba kula ɓika na isumu ndengye'ye? ");
INSERT INTO loq_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Na ɓɛ̀ɛ kobungye oɓokye ɓanga ɓasɔ ɓaaɓatisama na nkombo ya Yesu, toɓatisama na iwa sɛ? ");
INSERT INTO loq_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Na ɓatisimo, na iwa sɛ, tokundamaka nɛ, phɔ ya oɓokye ɓo wakundwa Klisto onte ya ɓawe na nkyɛmɔ ya Tata, na ɓanga mɛ nde ɓomɔ tobikye na ɓomɔɔ pha sika. ");
INSERT INTO loq_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Phɔ ɓo tobuto nɛ moto mɔnɔmɔ, toulaa nɛ o iwa sɛ, tomba kula ulana nɛ mɛ o ikundwa sɛ. ");
INSERT INTO loq_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Toeɓe na ɓolaa: Moɓesi ŋwa ɓanga mookasi ŋwa ɓakama nɛ o ekulusu phɔ ya oɓokye nzoto ya masumu imane phɔ ɓanga sakula ɓa ɓaombo ɓa masumu. ");
INSERT INTO loq_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Phɔ moto oowe aikolami na masumu. ");
INSERT INTO loq_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Ɓo towe molɔngɔ na Klisto, toli na ianola oɓokye tomobika nɛ. ");
INSERT INTO loq_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Phɔ toeɓe oɓokye: Waakundwa yo onte ya ɓawe, Klisto etakule waa. Iwaa tesikuli ɓa na ɓokonzi o ikolo sɛ. ");
INSERT INTO loq_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Phɔ na iwaa, awe phɔ ya isumu mbala yɔnɔyɔ phɔ ya ɓoɓɛlɛ. Kasi na ɓomɔɔ, ali na ɓomɔɔ phɔ ya Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Yango mɛna na ɓɛ̀ɛ, omikpe oɓokye na isumu, oli ɓawee emba na Yesu Klisto, oli na ɓomɔɔ phɔ ya Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Eli oɓokye isumu tesikuli ɓa na ɓokonzi mi nzoto ya ɓɛ̀ɛ ikyi we phɔ ya ietomisa ianola maphowa maɓe mɛ. ");
INSERT INTO loq_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Sakyelela binango ɓa nzoto ya ɓɛ̀ɛ phɔ ya masumu ndokolo biŋwanele ɓa maphɔɔ mate mali na ɓosembo, kasi ndokolo ɓato ɓaakundwa onte ya ɓawe, na binango ɓa nzoto ya ɓɛ̀ɛ, ndokolo biŋwanele ɓa ɓosembo, omiambya o etoma ya Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Phɔ isumu etesikule ɓa na ɓokonzi o ikolo sa ɓɛ̀ɛ, phɔ ɓɛ̀ɛ tokuli ɓa o se ya miɓeko, kasi o se ya ngɔlu. ");
INSERT INTO loq_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Emba kyelukfye iwɔ ɓo? Tomokyela masumu phɔ tolokuli ɓa o se ya miɓeko, kasi o se ya ngɔlu? Teli ɓomɔ! ");
INSERT INTO loq_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Toeɓe oɓokye wamiambya ɓɛ̀ɛ oka moto ndokolo moombo phɔ ya imokumola, oli ɓaombo ɓa ookokumle ɓɛ̀ɛ, naa ɓa isumu sikambe o iwa, naa ɓa itosa sikambe o ɓosembo. ");
INSERT INTO loq_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Kasi Ŋwaphongo akumisame oɓokye, na ɓo phanza ɓɛ̀ɛ waɓaka ɓaombo ɓa masumu, kasi uŋwaŋwa eye obuto itosa na motema mɔnɔmɔ lolengye la mateya mazwaka ɓɛ̀ɛ. ");
INSERT INTO loq_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Tokuli ɓa ɓaombo ɓa masumu, obuto ɓaombo ɓa ɓosembo. ");
INSERT INTO loq_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Nakpe mowɔsi ŋwa ɓomoto phɔɔ ya ewɔlɛ phɔ ya ɓokɔ pha nzoto. Phanza, waɓaka ndokolo ɓaombo ɓa maphɔɔ maɓe maatome itɔmbɛlɛ Ŋwaphongo. Nde ɓomɔ uŋwaŋwa eye, omiambya mouwosi ndokolo ɓaombo ɓa maphɔɔ maalaa phɔ ya ɓomɔɔ ɓosantu. ");
INSERT INTO loq_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Phɔ, waaɓaka ɓɛ̀ɛ ɓaombo ɓa masumu, maphɔɔ ma ɓosembo temaikaka ekyeka. ");
INSERT INTO loq_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Wamba zwa omɔ iye? Uŋwaŋwa eye, maphɔɔ makyelaka ɓɛ̀ɛ obuto komaokyele sɔɔ, phɔ suka ya mɛ eli iwa. ");
INSERT INTO loq_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Kasi uŋwaŋwa eye, tokuli ɓa ɓaombo ɓa masumu, obuto ɓaombo ɓa Ŋwaphongo, wamokyela maphɔɔ ma ɓosantu. Suka ya mɛ eli ɓomɔɔ pha ɓoɓɛlɛ. ");
INSERT INTO loq_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Phɔ iphuti sa isumu eli iwa. Kasi ikaɓo si ambya Ŋwaphongo pha, eli ɓomɔɔ pha ɓoɓɛlɛ onte ya Yesu Klisto Nkolo wa ɓanga. ");
INSERT INTO loq_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Ɓaande, ɓɛ̀ɛ kobungye oɓokye nawɔ phɔ ya ɓato ɓaeɓe miɓeko oɓokye, miɓeko mili na ɓokonzi o ikolo sa moto nde imbɛlɛ sitaa yo ɓa na ɓomɔɔ? ");
INSERT INTO loq_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Yango mɛna, ŋwaŋwasi wa ɓolonga ali o se ya miɓeko ma lele wɛ ɓo naino lele mɛ ali na ɓomɔɔ. Kasi ɓo lele awe, ŋwaŋwasi takuli ɓa o se ya miɓeko ma lele mɛ. ");
INSERT INTO loq_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Emba ɓo moloo wɛ ata ɓa na ɓomɔɔ, ɓo akyɛ ɓa na lele mosuu, mɛna akyesi phemba. Kasi ɓo lele awe, takuli ɓa o se ya miɓeko. Emba ɓo akyɛ ɓa na lele mosuu, mɛna taikyi kyela phemba. ");
INSERT INTO loq_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Ɓaande na nga, phɔ ya ɓɛ̀ɛ eli nde ɓomɔ mɛ, wawaka phɔ ya miɓeko, elele yɔnɔyɔ na Klisto, phɔ ya ibutwa ɓato ɓa mosuu, owa kundwa onte ya ɓawee, phɔ ya oɓokye toɓotele Ŋwaphongo mbuma. ");
INSERT INTO loq_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Phɔ waataka ɓa ɓanga toɓengye bitoma ɓa ɓomoto, maphowa maɓe maatomisa miɓeko makyelaka onte ya ɓanga emba malotomaka o iwa. ");
INSERT INTO loq_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Kasi uŋwaŋwa eye, tolokuli ɓa ɓaombo ɓa miɓeko, oɓakyi ɓanga ɓawe ndokolo ɓaloakya o bɔlɔkɔ. Tokokyi ikyelea Ŋwaphongo na ndengye enyakune o se ya ɓokonzi pha Ɓolɔɓɔ, kasi na ndengye ekasi phe, o se ya ɓokonzi pha miɓeko miakoma ɓɛ. ");
INSERT INTO loq_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Tomoewɔlɛ ɓo? Miɓeko mili masumu? Phe! Kasi naebi masumu nde phɔ ya miɓeko. Yango mɛna sikokyi ieɓa imengyela ɓo miɓeko temiwɔkɔ oɓokye: «Wɛ samengyela». ");
INSERT INTO loq_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Kasi waateyaka miɓeko oɓokye: Kyeka masumu, masumu mazwa nzela oka nga, mamba ntoma imengyela mbolo ndengye na ndengye. Ɓo miɓeko temili, masumu temali na ɓokusi. ");
INSERT INTO loq_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Kalakala wataka ɓa nga saeɓa miɓeko, naɓaka na ɓomɔɔ. Kasi wa sɔsɔlɔ nga miɓeko, masumu maɓandi ibutwa na ɓokusi, ");
INSERT INTO loq_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","emba nga nali mowe. Ŋwaphongo ambya miɓeko phɔ oɓokye miphɛ ɓato ɓomɔɔ. Kasi nga miɓeko mimbomi. ");
INSERT INTO loq_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Waoka nga miɓeko, masumu mazwe nzela oka nga, ndondo ya nga enkose phɔ nakyele masumu, yango mɛna masumu mambomi. ");
INSERT INTO loq_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Yango mɛna, miɓeko ma Mose mauta na Ŋwaphongo, mitindo ma mango mili misantu, miɓeko mɛ mili ma ɓosembo na maiilaa. ");
INSERT INTO loq_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Emba yango kyelukye iwɔ oɓokye ekpele mɛ elaa ya mboma? Phe, teli ɓomɔɔ. Kasi eli nde masumu maamboma. Masumu mɛ makpa ekpele elaa, maamba mboma na yango. Eli phɔ ɓaeɓe oɓokye masumu mali phɛlɛ masumu. Emba phɔ ya miɓeko, masumu mawɛnɛɛ na ɓoɓe koleka. ");
INSERT INTO loq_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Toeɓe oɓokye miɓeko miute na Ŋwaphongo, kasi inga nali nde moto. Nabuto moombo ŋwa masumu. ");
INSERT INTO loq_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Ikyikyele nga, siisɔsɔlɔ. Phɔ sikyele ikyi zingye nga ikyela, kasi nakyele nde iteiizingye nga. ");
INSERT INTO loq_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Ɓo siizingye ikyikyele nga, mɛna naanole oɓokye miɓeko mili milaa. ");
INSERT INTO loq_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Yango mɛna, ɓoɓe ɓokyele nga, teli nga ookoɓokyele, kasi eli nde masumu maali onte ya nga maaɓokyele. ");
INSERT INTO loq_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Phɔ na eɓe oɓokye ekpele elaa teli onte ya nga, nawɔ onte ya nga lokola moto. Nazingye ikyela ɓolaa kasi siikokye iɓokyela. ");
INSERT INTO loq_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Yango mɛna, sikyele lowɔ lolaa lozingye nga ikyela. Kasi nakyele nde lowɔ loɓe loote loozingye nga ikyela. ");
INSERT INTO loq_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Ɓo nakyele lootelozingye nga ikyela, mɛna kyelukye iwɔ oɓokye teli nga moto ookokyele ɓomɔɔ, kasi eli nde masumu maali onte ya nga. ");
INSERT INTO loq_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Emba nga nawɛnɛ ɓoɓo: Ɓo nazingye ikyela ɓolaa, nawɛnɛ oɓokye nakule kyele nde ɓoɓe. ");
INSERT INTO loq_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Kyelukye iwɔ oɓokye o ndondo ya nga nasepele na miɓeko ma Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Kasi nawɛnɛ oɓokye o ndondo ya nga, wali moɓeko mosuu muŋwane na miɓeko ma Ŋwaphongo. Moɓeko mɛ onte ya nga mumbuya moombo ŋwa masumu. ");
INSERT INTO loq_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Moto wa ngɔngɔ ɓoli nga! Owa mumanya o ɓoombo pha nzoto ikyitome o iwaa iye nza? ");
INSERT INTO loq_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Ŋwaphongo akumisame na nzela ya Yesu Klisto Nkolo wa ɓanga! Emba inga mampenza na maumanya ma nga natosa miɓeko ma Ŋwaphongo. Kasi nzoto ya nga ya ɓomoto kyizingye oɓokye naɓengye masumu. ");
INSERT INTO loq_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Emba iŋwaŋwa eye, Ŋwaphongo etaingya ɓato ɓaangana na Yesu Klisto. ");
INSERT INTO loq_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Phɔ moɓeko ŋwa Ɓolɔɓɔ moolophɛ ɓɔmɔɔ pha phɛlɛ na nzela ya Yesu Klisto moli miɓanga, tolokuli ɓa ɓaombo ɓa moɓeko ŋwa masumu na ŋwa iwaa. ");
INSERT INTO loq_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Miɓeko na Mose temaikaka koka ilophɛ ɓomɔɔ phɔ ɓanga ɓato toli na ɓokɔ. Toloikaka koka itosa miɓeko kasi lootelaikaka koka miɓeko ikyela, Ŋwaphongo alokyela. Phɔ ya ilokyela, atoma Ŋwana wɛ o mokyisi, abuto moto, aulanaka na ɓanga ɓato ɓa masumu phɔ ya imanya masumu ma ɓanga. Yango mɛna, Ŋwaphongo amba ingya Ŋwana wɛ o elele ya ɓanga phɔ taazingye masumu. ");
INSERT INTO loq_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Ŋwaphongo akyela ɓaɓona phɔ tozwe nzela ya ikyelela miɓeko mɛ, ɓanga ɓaatambule o nzela ya Ɓolɔɓɔ kasi ɓate ɓatambule o nzela ya nzoto. ");
INSERT INTO loq_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Ɓato ɓaabikye o nzela ya ɓomoto, ɓaumunya nkɔlɔ isɔ nde maphɔɔ masepelisa nzoto. Kasi ɓato ɓaabikye o nzela ya Ɓolɔɓɔ, ɓɛ́ɛ ɓaumunya nkɔlɔ isɔ nde ikyela maphɔɔ maasepelisa Ɓolɔɓɔ. ");
INSERT INTO loq_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Ɓo toumunya nkɔlɔ isɔ nde maphɔɔ maasepelisa nzoto, mɛna eli nzela ya iwaa. Kasi ɓotoumunya nkɔlɔ isɔ nde maphɔɔ maasepelisa Ɓɔlɔɓɔ, tomozwa ɓomɔɔ pha phɛlɛ na ɓose. ");
INSERT INTO loq_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Ɓato ɓaaumunya nkɔlɔ isɔ nde maphɔɔ maasepelisa nzoto ya ɓɛ, ɓali ɓanguna ɓa Ŋwaphongo. Teɓaaɓengye na miɓeko ma Ŋwaphongo, tewali nzela oɓokye ɓaamotosa. ");
INSERT INTO loq_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Bato ɓabikye o nzela ekyesepelisa nzoto, te ɓakokyi isepelisa Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Kasi ɓɛ, toobikye o nzela ya maphɔɔ maasepelisa nzoto. Kasi ɓɛ́ɛ kobikye o nzela eyaka Ɓolɔɓɔ pha Ŋwaphongo phɔ Ɓɔlɔɓɔ mɛ ɓoli onte ya ɓɛ. Ɓo moto tali na Ɓɔlɔɓɔ pha Yesu Klisto onte yɛ, tali moto wa Yesu Klisto. ");
INSERT INTO loq_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Ɓo Klisto ali onte ya ɓɛ, na ɓo nzoto ya ɓɛ́ɛ isengyesi iwa phɔ wakyela masumu, kasi Ɓɔlɔɓɔ phɛ ɓoephɛ ɓomɔɔ, phɔ Ŋwaphongo aebuya ɓato ɓa ɓosembo o miyo mɛ. ");
INSERT INTO loq_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Kasi ɓo Ɓolɔɓɔ pha Ŋwaphongo owaakola Yesu Klisto o iwa ali phɛlɛ o nte ya ɓɛ̀ɛ, emba nde ona Ŋwaphongo mɛ amoakola nzoto ya ɓɛ́ɛ o iwaa mɛ na nzela ya mwiya ŋwa Ɓolɔɓɔ phɛ ɓoli onte ya ɓɛ. ");
INSERT INTO loq_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Phɔ oli wango ɓaɓona ɓande na nga, esengyesi oɓokye toɓikye ɓokozingye Ɓolɔɓɔ kasi ɓokozingye nzoto ya ɓanga phe. ");
INSERT INTO loq_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Ɓo oɓengyi nzela ya maphɔɔ maasepelisa nzoto ya ɓɛ́ɛ wa mowaa. Kasi ɓoephɛ Ɓolɔɓɔ nzela na mwiya nwɛ, wamolɛ ɓoɓɛlɛ maphɔɔ maɓe makyele ɓɛ, emba wamoɓa na ɓomɔɔ. ");
INSERT INTO loq_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Ɓato ɓasɔ ɓaakambame na Ɓolɔɓɔ pha Ŋwaphongo ɓali ɓana ɓa Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Phɔ Ɓolɔɓɔ phaephɛ Ŋwaphongo teɓoebuya ɓaombo, naa ɓokule ephɛ iɓale. Kasi eli nde Ɓolɔɓɔ Ɓosantu ɓooebuya ɓana ɓa Ŋwaphongo, ɓoolotome iɓanga Ŋwaphongo oɓokye «Aba, Tata!» ");
INSERT INTO loq_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Ɓolɔɓɔ mɛ ɓoloteya o mandondo ma ɓanga oɓokye toli ɓana ɓa Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Phɔ toli ɓana ɓɛ, emba tomozwa mbolo isɔ indaa ikyi ɓombe yo phɔ ya ɓanga. Tomoizwa molɔngɔ na Yesu Klisto phɔ ɓanga nɛ tonyɔkɔmɔ elele yɔnɔyɔ. Emba na ɓanga mɛ tomozwa nkyɛmɔ elele yɔnɔyɔ nɛ. ");
INSERT INTO loq_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Naeɓe oɓokye minyɔkɔ miiwɛnɛ ɓanga lɔlɔ eye mili ndokolo ŋwana ekpele mokyikyi wa phaa. Temiikyi buɓanaa na ŋwana ɓokyi ɓoɓo na nkyɛmɔ ya loteya Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Bikpele bisɔ biakyela Ŋwaphongo biziya na phowa. Bizingye na ɓoikye iwɛnɛ mokɔlɔ ŋwa mowɛninya Ŋwaphongo ɓana ɓɛ́ɛ nkyɛmɔ ya ɓɛ. ");
INSERT INTO loq_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Phɔ bikpele bisɔ biakyela yo Ŋwaphongo te bikuli ɓaa na ntina. Bikpele byɛ mampenza, te biikaka zinga ɓomɔɔ. Eli nde Ŋwaphongo owazinga ɓomɔɔ. Kasi nkɔlɔ isɔ kalemele, ");
INSERT INTO loq_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","phɔ mokɔlɔ mɔnɔmɔ aamokandola na bikpele bisɔ biakyela yo. Bikpele mɛ etebikule ɓaa ndokolo ɓaombo, etebikule phɔlɔ, biamozwa nkyɛmɔ ndokolo ɓana ɓa Ŋwaphongo, biamozwa ɓosɔmi. ");
INSERT INTO loq_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Toeɓe oɓokye nɔnɔ lɔlɔ bikpele bisɔ biakyela Ŋwaphongo bikyimele. Bili na ɓɔlɔsi ndokolo ŋwaŋwasi okosweya. ");
INSERT INTO loq_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Ɓolɔsi mɛ teɓookye nde bikpele na bikpele. Na ɓanga ɓawaa ɓaphɛ Ŋwaphongo Ɓolɔɓɔ phanza na ɓaamokula phɛ yo nkyɛmɔ, na ɓanga tokyimele o mandondo ma ɓanga mɛ. Toziya na phowa iikye oɓokye Ŋwaphongo alobuya ɓana ɓɛ, kyelukye iwɔ oɓokye amanya nzoto ya ɓanga o malɔsi. ");
INSERT INTO loq_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Ŋwaphongo alobikya kasi naino tolowɛni maphɔɔ masɔ, tolemele nkɔlɔ isɔ oɓokye toomawɛ nɛ. Waamowɛnɛ ɓanga na miyo maphɔɔ malemelakyi ɓanga, etelookule malemela phɔ mabuto ma ɓanga. Moto ookolemele ekpele ekye wɛnɛ yo nza? ");
INSERT INTO loq_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Kasi phɔ naino tolowɛni ekpele ekyelemele ɓanga, emba tokangye motema, toziya na phowa iikye. ");
INSERT INTO loq_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Nde ɓomɔɔ, Ɓolɔɓɔ nɛ kaya losunga, ɓanga ɓate ɓali na mwiya o nzela ya Ŋwaphongo. Phɔ toloeɓe iɓɔndɛlɛ na ɓolaa. Kasi Ɓolɔɓɔ yo mampenza ka ɓɔndɛlɛ Ŋwaphongo o elele ya ɓanga, kanyingonele, koleka ndengye ekokyi iwɔ ɓato. ");
INSERT INTO loq_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Ŋwaphongo kaeɓe ili o mandondo ma ɓato. Emba kaeɓe na ikyiumunya Ɓolɔɓɔ mɛ, phɔ Ɓolɔɓɔ kaɓɔndɛlɛ o elele ya ɓato, kamoɓɔndɛlɛ na ndengye ekyezingye yo. ");
INSERT INTO loq_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Toeɓe oɓokye o maphɔɔ masɔ, Ŋwaphongo kakyele phɔ ya ɓolaa pha ɓato ɓaamozingye, ɓato ɓawaa ɓaaɓanga yo kokokana na ŋwango nwɛ. ");
INSERT INTO loq_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Phɔ ɓato ɓaunva ɔlɔ yo, aunva kana iɓabuya ndokolo Ŋwana wɛ, oɓokye Ŋwana wɛ aɓe ɓola onte ya ɓana ɓaikye. ");
INSERT INTO loq_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Ɓaaɔlɔ unva ɔlɔ Ŋwaphongo phanza, amba na ɓaɓanga. Ɓaaɓanga yo, aɓabuya na ɓato ɓa ɓosembo, emba ɓaabuya yo ɓato ɓa ɓosembo, aɓaphɛ na nkyɛmɔ yɛ. ");
INSERT INTO loq_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Emba toombe kula wɔɔ ɓo? Ɓo Ŋwaphongo ali mbale na ɓanga, owaalotɛmɛlɛ nza? ");
INSERT INTO loq_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Emba Ŋwaphongo, yo otoika ima Ŋwana wɛ, amoambya oɓokye aya waa phɔ ya ɓanga ɓasɔ, emba takokyi ilophɛ na ɓanga mɛ isɔ molɔngɔ Ŋwana wɛ? ");
INSERT INTO loq_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Owa mophunda ɓato ɓa ɔlɔ Ŋwaphongo nza? Moto phe. Phɔ eli Ŋwaphongo owa ɓabuya ɓato ɓa ɓosembo. ");
INSERT INTO loq_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Okokyi iɓaingya nza? Moto phe. Phɔ Yesu Klisto ali moto owa waa, aambakula naakundwa, ali o ɓoloo pha Ŋwaphongo, kambe na ɓondɛlɛ phɔ ya ɓanga. ");
INSERT INTO loq_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Owaalokaɓola na lozingo la Yesu Klisto nza? Mampasi, minyɔkɔ, ɓato ɓaalonyɔkɔlɔ, manzala, ɓoɓola, ikama, iwaa? ");
INSERT INTO loq_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Ɓowakoma ɓɛ́ɛ o buku pha Ŋwaphongo oɓokye: «Phɔ ya wɛ Ŋwaphongo, imbɛlɛ sisɔ toli o ikama sa iwaa. O miyo ma ɓato tobuto ndokolo mampate makyɛ ɓɛ́ɛ ɓoma.» ");
INSERT INTO loq_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Kasi tolongye minyɔkɔ misɔ mamina na mwiya ŋwa okolozingye. ");
INSERT INTO loq_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Phɔ nali na ianola oɓokye tewali ekpele eyaa lokaɓola na lozingo la Yesu Klisto: Eɓe iwaa, eɓe ɓomɔɔ, eɓe ɓanze, eɓe malɔɓɔ, eɓe maphɔɔ maa lɔlɔ eye, eɓe maphɔɔ maamoyaa, eɓe isɔ iili na mwiya, ");
INSERT INTO loq_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","eɓe phɛmbɔ yaa ikolo, eɓe na phɛmbɔ yaa o se, eɓe isɔ yaakyelama, ekpele nɔnɔ yɔnɔyɔ teekokyi ilokaɓola na lozingo la Ŋwaphongo laawɛninya yo onte ya Yesu Klisto Nkolo wa ɓanga. ");
INSERT INTO loq_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Maphɔɔ mamowɔ nga mali maa phɛlɛ, phɔ nali moto wa Klisto, sikosa. Ɓolɔɓɔ kanteya oɓokye maphɔɔ maawɔ nga mali maphɛlɛ, na ndondo ya nga kyeanole ɓɔmɔ mɛ. ");
INSERT INTO loq_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","Nali na ngɔngɔ ɓoikye, imbɛlɛ sisɔ nali na ɓolɔsi o motema, ");
INSERT INTO loq_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","phɔ ya Ɓayuda ɓato ɓa iɓota sa nga. Ɓɛbi na nga ɓa iɓota sɔnɔsɔ. Ɓo nzela eɓakyi, nazingye oɓokye Ŋwaphongo anvambe, ambe nakaɓola na Yesu Klisto phɔ yaɓola pha ɓɛbi na nga ɓa iɓota sa nga. ");
INSERT INTO loq_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Ɓaali ɓana ɓa Isalayɛlɛ, Ŋwaphongo aɓaɔlɔ phɔ ɓaɓe ɓana ɓɛ, aɓateya nkyɛmɔ yɛ, akyela na ɓɛ́ɛ ɓasangola, aɓaphɛ miɓeko, aɓateya nzela ya imoɓɔndɛlɛ, aɓaikyela mambunu. ");
INSERT INTO loq_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Ɓaali ɓankɔkɔ ɓa Abalayama. Yesu Klisto nɛ wa butwa yo moto, ali wa iɓota sa ɓɛ. Kasi teɓaika moanola. Yo, Klisto nɛ ali Ŋwaphongo, ali o ikolo sa maphɔɔ masɔ. Tomokumbele phɔ ya ɓoɓɛlɛ. Amɛ. ");
INSERT INTO loq_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Teli oɓokye Ŋwaphongo taika kyela yaalakaka yo. Alokyela na ɓaakolo ɓana ɓa Isalayalɛ. Na wɔ ɓo? Na wɔ ngakye ɓana ɓayɔkɔ teɓali ɓaakolo ɓana ɓa Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Abalayama aɓaka na ɓana ɓaikye, kasi ɓɛ́ɛ ɓasɔ teɓali ɓaakolo ɓana ɓɛ́ɛ ɓo wa wɔ Ŋwaphongo. Kalakala Ŋwaphongo amba wɔ na Abalayama yokye: «Ɓaakolo ɓana ɓa wɛ ɓamotɔkɔlɔ oka ɓana ɓa Izake.» ");
INSERT INTO loq_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Kyekukye iwɔ oɓokye: Onte ya ɓana ɓasɔ ɓa Abalayama, ɓɛ́ɛ ɓasɔ tebali ɓana ɓa Ŋwaphongo. Ŋwaphongo kawɔ yokye ɓaakolo ɓana ɓɛ́ɛ eli nde ɓaɓota yo kokokana na mbunu eya ikyelaka yo Abalayama. ");
INSERT INTO loq_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Mbunu eya moikyelaka Ŋwaphongo eli oɓokye: Waamokoka imbɛlɛ simekyi nga, namokula yaa, Sala amoɓota ŋwana wa lele. ");
INSERT INTO loq_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Teyaikaka ɓa nde Sala yo mampenza. Lebeka aɓaka ŋwaŋwasi wa nkɔkɔ wa ɓanga Izaka. Aekamaka zaa. ");
INSERT INTO loq_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","12","Ŋwaphongo awɔkɔ nɛ yokye: «Mosi amoleka ɓola.» Wa wɔ Ŋwaphongo ɓaɓona teɓaikaka kyela naa maphɔɔ maala naa maphɔɔ maaɓe, teɓataka na ɓotama. Ŋwaphongo akyela ɓaɓona phɔ ya iteya oɓokye kakyele nde ɓozingye yo. Ka ɔlɔ moto wɛ onte ya ɓato, tamoɔlɔ phɔ ya maphɔɔ maala makyele yo. ");
INSERT INTO loq_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Nde ɓowakoma ɓɛ́ɛ o buku pha Ŋwaphongo oɓokye: «Ŋwaphongo awɔ yokye nazinga Yakoɓo, naina Esau.» ");
INSERT INTO loq_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Emba tomba wɔ ɓo? Tomowɔ oɓokye Ŋwaphongo taakyele maphɔɔ na ɓosembo? Phe, teeli ɓaɓona! ");
INSERT INTO loq_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Amba wɔ na Mose yokye: «Ɓo nazingyi ikyela moto ɓolaa, na ɓokyela. Na ɓo nazingyi ooka moto ngɔngɔ, naamooka ngɔngɔ.» ");
INSERT INTO loq_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Emba wa ɔlɔ Ŋwaphongo moto, kamoɔlɔ nde phɔ azingyi imokyela ɓolaa, teeli phɔ moto azingyi, naa phɔ ya etoma yɛ. ");
INSERT INTO loq_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Wakomama o buku pha Ŋwaphongo oɓokye Ŋwaphongo awɔkɔ phɔ ya Falo yokye: «Naetɛyɛ mokonzi phɔ nawɛninya oka ɓato ɓasɔ ɓokusi pha nga miwɛ na phɔ nkombo ya nga eokane o mokyisi moɓimba.» ");
INSERT INTO loq_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Yango mɛna, towɛnɛ oɓokye Ŋwaphongo kakyele ɓolaa na moto oozingyi yo. Moto oozingyi Ŋwaphongo oɓokye aɓe sa motosa, Ŋwaphongo kakyele nde oɓokye aɓe samotosa ɓomɔɔ. ");
INSERT INTO loq_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Naa moto mɔnɔmɔ amowɔ na nga oɓokye: «Ɓo eɓe ɓaɓona, phɔ ya'ye Ŋwaphongo kaoya ɓato? Ɓato ɓakyele ka nde ya ɓaatoma yo mampenza?» ");
INSERT INTO loq_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Nwɛbi na nga, iwɛ moto okowɔ ɓaɓona, oli nza oɓokye oikyele Ŋwaphongo ziko? Mbongo ekokyi iwɔ na owa ekyelela oɓokye: «Phɔ ya'ye onkyesi ndengye eye?» ");
INSERT INTO loq_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Mokyesi ŋwa mambongo ali na ɓokonzi pha ikyela ekpele ezingyi yo na manyɛtɛ; nde na manyɛtɛ mɛ akokyi ikyela mbongo eya motuya na mbongo eteli na motuya. ");
INSERT INTO loq_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Emba ɓo Ŋwaphongo azingakyi iɓa ya mokyesi ŋwa mambongo, eli lowɔ la wɛ? Azingaka oɓokye ɓato ɓaeɓe oɓokye ali na yɔɔ, ali nana mwiya. Emba kakangye motema phɔ ya ɓato ɓaokyele yo yɔɔ na ɓaakokyi yo iɓoma. ");
INSERT INTO loq_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Kasi Ŋwaphongo azingaka oɓokye ɓato ɓaeɓe oɓokye ali na nkyɛmɔ nzikye, kambe na kaɓela ɓato ɓazingye yo ikyela ɓolaa nkyɛmɔ mɛ. Aloɓɔngya phanza oɓokye tozwe nkyɛmɔ mɛ. ");
INSERT INTO loq_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Toli ɓanga ɓasɔ ɓato ɓaaɓanga Ŋwaphongo phɔ ya iɓa ɓato ɓɛ. Taika ɔlɔ nde oka Ɓayuda na Ɓayuda, aɓanga na ɓato ɓasuu mɛ. ");
INSERT INTO loq_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Nde ɓo wawɔ yo obuku pha Oze yokye: «Ɓato ɓateɓaikaka ɓaa phanza ɓato ɓanga, naɓaɓanga ɓato ɓanga, na iɓota satesaikaka nga zinga, nasiɓanga iɓota saalɔɓɔ nga zinga. ");
INSERT INTO loq_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","O elele eya wɔkɔ nga na ɓɛ́ɛ oɓokye: “Toli ɓato ɓanga”, nde oena elele mɛ, nga Ŋwaphongo ooli na ɓomɔɔ, naɓaɓanga ɓana ɓanga.» ");
INSERT INTO loq_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Ka phɔ ya ɓato ɓa Isalayɛlɛ, moimosi Isaya awɔ phɔ ya ɓɛ, aimola yokye: «Naɓo ɓato ɓa Isalayɛlɛ ɓaɓaka ɓaikye ndokolo musɛngyɛ o mokukulu ŋwa ebale, eɓa oɓokye ɓaamobikya Ŋwaphongo teɓali ɓaikye. ");
INSERT INTO loq_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Nkolo Ŋwaphongo etaa kɔkɔ, amoyakyela maphɔɔ masɔ maawɔ yo o mokyisi.» ");
INSERT INTO loq_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Nde ɓowawɔkɔ ona Isaya phanza yokye: «Ɓo Nkolo Ŋwaphongo okokambe maphɔɔ masɔ taikaka manya ndambo ya ɓana ɓaɓanga, nde towee ndokolo ɓato ɓa Sodɔmɔ na Gomola.» ");
INSERT INTO loq_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Emba tomowɔ ɓo? Towɔɔ oɓokye ɓato ɓate ɓali Ɓayuda ɓɛ́ɛ teɓaikaka luka nzela ya ibutwa ɓato ɓa ɓosembo o miyo ma Ŋwaphongo. Kasi iŋwaŋwa eye ɓabuto ɓato ɓa ɓosembo o miyo ma Ŋwaphongo phɔ ɓamoanosi. ");
INSERT INTO loq_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Ɓayuda ɓɛ́ɛ ɓalukaka miɓeko phɔ ɓamiɓɔngya oɓokye ɓaɓe ɓato ɓa ɓosembo o miyo ma Ŋwaphongo, yango mɛna ɓakaa o nzela. ");
INSERT INTO loq_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Ɓakaa phɔ ya'ye? Phɔ ɓaumunyaka oɓokye ɓamoɓa ɓato ɓosembo na misala miaɓaka ɓɛ́ɛ ɓakyele, kasi te ɓaikaka onola Ŋwaphongo. Emba ɓamba zuma o iɓanga. ");
INSERT INTO loq_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","Iɓanga mɛ eli Yesu Klisto, siiwɔɔ o buku pha Ŋwaphongo. O buku, Ŋwaphongo awɔ yokye: «Okyemela nakyesi iɓanga sɔnɔsɔ o mokyisi ŋwa Siyona, ɓato ɓamoɓakatana misango. Ɓato ɓamokaa phɔ ya iɓanga mɛ. Kasi phɔ ya moto owa moanola iɓanga mɛ etesimophɛ sɔɔ.» ");
INSERT INTO loq_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Ɓande na nga, nazingye na ɓoikye oɓokye ɓato ɓanga Ɓayuda ɓayee phɔ Ŋwaphongo aɓabikya. Naɓɔndɛlɛ Ŋwaphongo na ɓoikye phɔ ya lowɔ mɛ. ");
INSERT INTO loq_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Naeɓe oɓokye ɓazingye iɓenga Ŋwaphongo phɛlɛ, kasi teɓaeɓe eya kolo nzela. ");
INSERT INTO loq_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Phɔ teɓaika sɔsɔlɔ nzela ekyebuya Ŋwaphongo na yango ɓato, ɓato ɓa ɓosembo o miyo mɛ. Ɓazingaka iɓenga nde nzela ya ɓɛ́ɛ mampenza. Yango mɛna ɓalɛ nzela ekyebuya Ŋwaphongo na yango ɓato, ɓato ɓa ɓosembo o miyo mɛ. ");
INSERT INTO loq_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Nawɔ ɓaɓona phɔ waaya Yesu Klisto, ayaa unva ɓokusi pha miɓeko ma Mose, akyela ɓaɓona phɔ ɓato ɓasɔ ɓa moanole ɓabutwe ɓato ɓa ɓosembo o miyo ma Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Mose akoma phɔ ya nzela ya ibutwa moto wa ɓosembo na miɓeko, akoma yokye: «Moto ookotosa miɓeko misɔ amozwa ɓomɔɔ pha phɛlɛ phɔ ya miɓeko.» ");
INSERT INTO loq_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Kasi nzela ekyebuya ɓato ɓa ɓosembo o miyo ma Ŋwaphongo phɔ ɓamoanole, nzela mɛ ekyɛsɛ. O buku pha Ŋwaphongo ɓawɔ phɔ ya nzela mɛ oɓokye: «Samiwɔlɛ oɓokye: Owa mobaa oikolo nza?» (Kyelukye iwɔ oɓokye owa mokyɛ ɓanga Klisto aute nza). ");
INSERT INTO loq_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","Samiwɔlɛ na oɓokye: «Owa munyɔlɔ ose ya manyɛtɛ onte ya ɓawe nza?» (Kyelukye iwɔ oɓokye owamokyɛ ɓanga Klisto oɓokye atɔkɔlɔ nza). ");
INSERT INTO loq_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Ɓuku pha Ŋwaphongo ɓowɔ nde oɓokye: «Iloɓa sa Ŋwaphongo sili phɛnɛphɛ na wɛ, tesili itakye na wɛ, iloɓa mɛ sili o munɔkɔ ŋwa wɛ, sili na o ndondo ya wɛ.» Iloɓa mɛ eli nde sango siiteya ɓanga ɓato oɓokye ɓasengyesi ianola Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Ɓo kowɔ na munɔkɔ ŋwawɛ oɓokye Yesu ali Nkolo, na ɓo koanole o ndondo ya wɛ oɓokye Ŋwaphongo amoakola o ɓawe, Ŋwaphongo amoebikya. ");
INSERT INTO loq_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Ɓo toanosi Yesu phɛlɛ tobutwe ɓato ɓa ɓosembo o miyo mɛ. Ɓo towɔ na munɔkɔ oɓokye Yesu ali Nkolo, Ŋwaphongo aalobikya. ");
INSERT INTO loq_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Nde ɓo wakoma ɓɛ́ɛ o buku pha Ŋwaphongo oɓokye: «Ɓato ɓasɔ ɓaamoanole eta ɓaphɛ sɔɔ.» ");
INSERT INTO loq_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Yango mɛna eɓe moyuda, eɓe ɓaate ɓali Ɓayuda, ɓokyɛsɛ teɓoli, Nkolo nde yo mɔnɔmɔ ali Nkolo wa ɓato ɓasɔ, kakyele ɓolaa oka ɓato ɓasɔ ɓaamoɓɔndɛlɛ. ");
INSERT INTO loq_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Eli ɓo wakoma ɓɛ́ɛ o buku pha Ŋwaphongo oɓokye: «Ɓato ɓasɔ ɓaamoɓɔndɛlɛ Nkolo ɓamobika.» ");
INSERT INTO loq_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Kasi ɓaamoɓɔndɛlɛ ndengye'ye ɓo naino teɓamoanosi? Ɓaamoanola ndengye'ye ɓo naino teɓaokyi Simo yɛ? Ɓamooka simo yɛ ndengye'ye ɓo ɓato ɓaiɓaimola yango te ɓali? ");
INSERT INTO loq_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Emba ɓaaɓaimola ndengye'ye ɓote ɓaɓatomi? Eli nde ɓowakoma ɓɛ́ɛ o buku pha Ŋwaphongo oɓokye: «Eye ɓolaa, na matambe ma ɓato ɓaaya imola Simo Elaa!» ");
INSERT INTO loq_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Kasi ɓato ɓasɔ teɓaika anola Simo Elaa mɛ. Moimosi Isaya yo mampenza awɔ yokye: «Nkolo, owaanola Simo eyaimolaka ɓanga nza?» ");
INSERT INTO loq_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Yango mɛna, ianola siute na ioka Simo, Simo mɛ eli maloɓa ma Klisto. ");
INSERT INTO loq_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Phɔ oli yango ɓaɓona, natune motuna monɔmɔ, na wɔ ngakye: Ɓato ɓa Isalayɛlɛ teɓaika aoka Simo Elaa phɛlɛ? Phe, ɓaeyoka. Nde ɓo wakoma ɓɛ́ɛ oɓuku pha Ŋwaphongo oɓokye: Ɓato ɓakyɛmiwɔ Iloɓa sa Ŋwaphongo o mokyisi moɓimba. «Nyɛsi ya ɓɛ́ɛ yooka mboka esɔ eɓe na o bilele bia itakye.» ");
INSERT INTO loq_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Emba natune motuna mosuu ngakye: Ɓato ɓa Isalayɛlɛ te ɓaika sɔsɔlɔ na ɓolaa? Mose awɔ phanza yokye: Ŋwaphongo yokye: «Namokyela oɓokye wamookyela ekolo eteli na ngambo zuwa. Na mokyela oɓokye oɓe na yɔɔ na ekolo ya ɓato ɓaateɓali na malondo.» ");
INSERT INTO loq_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Sima mɛ moimosi Isaya awɔ na iwɔ yokye: Ŋwaphongo kawɔ yokye: «Ɓato ɓateɓaikaka ɓaa ɓandukye, ɓanzwee. Namiwɛninye na ɓato ɓateɓaikaka ɓaa ɓanzongye ekpele.» ");
INSERT INTO loq_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Kasi phɔ ya ɓato ɓa Isalayɛlɛ, Ŋwaphongo kawɔ na munɔkɔ nwɛ yokye: «Naelolesi ɓato ɓanga maɓɔkɔ nzanga moɓimba oɓokye ɓaye, kasi ɓali na nzoto nkusi, teɓaikyi anola ikyi wɔ nga.» ");
INSERT INTO loq_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Emba nakule tuna motuna mosuu: Ɓoli wango ɓaaɓona, kyelukye iwɔ oɓokye Ŋwaphongo alɛ ɓato ɓɛ́ɛ Isalayɛlɛ? Phe, na mbala! Phɔ nga mampenza nali moto wa Isalayɛlɛ. Nauta o iɓota sa Benzamɛ, nɛ aɓaka ŋwana wa Abalayama. ");
INSERT INTO loq_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Ŋwaphongo taika lɛ ɓato ɓɛ́ɛ ɓaɔlɔ yo uta wakyela yo mokyisi phɔ ɓaɓe ɓato ɓɛ. Koeɓe yaakoma ɓɛ́ɛ o buku pha Ŋwaphongo phɔ ya Eliya. Eliya amilelaka na Isalayɛlɛ o ɓoo pha Ŋwaphongo. Awɔkɔ yokye: ");
INSERT INTO loq_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","«Nkolo, ɓato ɓaɓa ɓaɓoma ɓaimosi ɓa wɛ, ɓanyangola bilele bietumbele ɓɛ́ɛ mambeka. Naikasi nde nga mampenza okoeɓengye, ɓalukye imboma mɛ.» ");
INSERT INTO loq_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Kasi Ŋwaphongo amobuyisa ɓo? Awɔ nɛ yokye: «Phe, toli wɛ mampenza. Na ɓomba phɔ ya nga ɓato nkoto sambo ɓamɓangye nkɔlɔ isɔ. Ɓo teɓaikyi sambela ekyeko ya Baala.» ");
INSERT INTO loq_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Phɔ ya ɓanga lɔlɔ eli nde ɓomɔ, wali nde ndambo ya ɓato ɓaɔlɔ Ŋwaphongo phɔ yɛ na ngɔlu yɛ onte ya ɓato ɓa Isalayɛlɛ. ");
INSERT INTO loq_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Phɔ Ŋwaphongo aɓaɔlɔ na ngɔlu yɛ emba kyelukye iwɔ oɓokye taika ɓaɔlɔ phɔ ya bitoma biikyele ɓɛ. Ɓo ɓaɓona phe, emba ngɔlu yɛ nde tekuli ɓa eyaakolo ngɔlu. ");
INSERT INTO loq_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Kyelukye iwɔ ɓo? Kyelukye iwɔ oɓokye ɓato ɓa Isalayɛlɛ teɓaika zwa ekyelukye ɓɛ, ndambo ya ɓato ɓaɔlɔkɔ Ŋwaphongo onte ya ɓɛ, ɓɛ́ɛ ɓaezwa. Kasi phɔ ya ɓaayɔkɔ, ɓabutwaka na nzoto nkusi. ");
INSERT INTO loq_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Eli nde ɓo wakoma ɓɛ́ɛ o buku pha Ŋwaphongo oɓokye: «Ŋwaphongo aɓabuye bibubusi, aziɓi miyo ma ɓɛ, aundi na matoo ma ɓɛ, nɔnɔ lɔlɔ ɓali nde ɓaɓona.» ");
INSERT INTO loq_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Na Davidi awɔ ɓoɓo: «Bisɛlɛkɔ ɓa ɓɛ̀ɛ biebisa ndokolo izɛngyɛ siibise nyama. Ɓaaka, Ŋwaphongo aɓaphɛ etumbu ekokyi na ɓɛ. ");
INSERT INTO loq_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Miyo ma ɓɛ́ɛ maphɔlɔ phɔ ɓɛ́ɛ sakula wɛnɛ, ɓazwakye nkɔlɔ isɔ nde maphɔɔ phɔ ɓanyiɓe.» ");
INSERT INTO loq_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Emba nakule tuna motuna mosuu ngakye: Waazuma Ɓayuda iɓaku, ɓakaa ɓoɓɛlɛ? Phe, na mbala! Kasi eli nde phɔ ya oɓokye ɓakyela masumu, Ŋwaphongo abikye ɓato ɓasuu. Ŋwaphongo akyela ɓaaɓona phɔ Ɓayuda ɓaokyele ɓato ɓaayɔkɔ zuwa. ");
INSERT INTO loq_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Waakyela ɓato ɓa Isalayɛlɛ masumu, Ŋwaphongo akyela ɓolaa na ɓato ɓasɔ ɓa mokyisi. Phɔ ya ikaa sa ɓayuda o ɓoo pha Ŋwaphongo, ɓato ɓasuu ɓazwe ɓolaa o maɓɔkɔ ma Ŋwaphongo. Ɓo Ŋwaphongo kakyele ɓato ɓasuu ɓolaa imbɛlɛ sitesimotosa Ɓayuda, ɓolaa phamba ɓakyela yo pha moɓa ndengye'ye waamba mobutwela Ɓayuda ɓasɔ? ");
INSERT INTO loq_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Iŋwaŋwa eye na wɔ na ɓɛ̀ɛ ɓato ɓali Ɓayuda. Nali toma wa Ŋwaphongo owa etomela yo ɓɛ̀ɛ ɓato ɓate ɓali Ɓayuda. Yango mɛna, nasepele na etoma eyampɛ yo. ");
INSERT INTO loq_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","Nazingye oɓokye ɓato ɓanga Ɓayuda ɓawɛnɛ ɓaɓona phɔ ɓayɔkɔ ɓaokye zuwa, ɓayee phɔ Ŋwaphongo aɓabikya o nzela ya etoma ya nga. ");
INSERT INTO loq_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Phɔ, waalɛ Ŋwaphongo Ɓayuda, akyela maɓɔngyɛ na ɓato ɓasuu ɓa mokyisi. Wamoɓa ɓoo ɓo akuli ɓaanola? Ya moɓa ndokolo ɓawe ɓakundo. ");
INSERT INTO loq_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Ɓo moto aphɛ Ŋwaphongo mbuma ya eɓandele ya inzabi sɛ kyelukye iwɔ oɓokye mbuma isɔ ya inzabi ili yɛ mɛ. Ɓo moto amophɛ munkanga ŋwa ŋwete, emba na bitakyi bili nde ɓɛ́ɛ mɛ. ");
INSERT INTO loq_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Isalayɛlɛ eli ndokolo ŋwete ŋwa olive ŋwa tena Ŋwaphongo ndambo ya bitakyi, o elele ya bitakyi mɛ, aesi ya eɓanza, iwɛ otoli moyuda, ndokolo etakyi ya ŋwete ŋwa olive eya ngonda. Maphɔɔ maala maaɓaka Ɓayuda ɓazwe, uŋwaŋwa eye ɓɛ́ɛ komazwe mɛ, ndokolo bitakyi biizwe ɓokusi uta na ŋwete. ");
INSERT INTO loq_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","Yango mɛna satiyola ɓali ndokolo bitakyi ɓatenya. Komitate phɔ ya'ye? Oli nde bitakyi phaa, ɓokusi pha bitakyi ɓoute nde na nkanga, ɓokusi pha nkanga teɓoute na bitakyi. ");
INSERT INTO loq_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Naa monɔnɔ onte ya ɓɛ̀ɛ amowɔ yokye: «Ŋwaphongo amanya bitakyi biiyɔkɔ phɔ ambanza o elele mɛ.» ");
INSERT INTO loq_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Eli phɛlɛ, Ŋwaphongo abimanya phɔ teɓaika moanola. Ka phɔ ya wɛ, aephɛ elele phɔ komoanole. Sa ɓaa na lolɛndɔ, kasi ɓaa nde na ilota Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Phɔ, ɓo Ŋwaphongo alɛ Ɓayuda ɓaaɓaka ndokolo bitakyi bia phɛlɛ, koumunya oɓokye etaewiinya mɛ ɓo tomoasi, iwɛ o wa ɓanza yo ɓoɓanze wawana. ");
INSERT INTO loq_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Okyemela ɓoli Ŋwaphongo molaa naa okophɛ yo bitumbu mɛ. Kaphɛ etumbu ɓato ɓaaka inzela yɛ, kasi oka ya wɛ ali molaa ɓo oli oikyela maphɔɔ mamosepelisa. Ɓo phe amoemanya mɛ. ");
INSERT INTO loq_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Ɓayuda ɓaɓana, ɓote ɓaikasi o iɓa saanola sa ɓɛ, Ŋwaphongo aɓabuya o bilele ɓa ɓɛ, phɔ ali na ɓokonzi pha iɓabuya. ");
INSERT INTO loq_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Ɓo toli Ɓayuda, oli ndokolo bitakyi ɓa ŋwete ŋwa ngonda biteni ɓɛ, ɓakyɛ biɓanza o ŋwete moli o ingambi. Ɓo Ŋwaphongo akokyi ikyela lowɔ lokusi ɓaɓona, embi ɓa iye oɓokye abuya Ɓayuda o elele eya ɓamanyaka yo, ɓɛ́ɛ ɓaali ndokolo ɓakolo bitakyi. ");
INSERT INTO loq_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Ɓɛbi na nga, nazingye oɓokye ɓɛ̀ɛ o sɔsɔlɔ sekyele eye, phɔ ɓɛ̀ɛ saɓaa na lolɛndɔ. Eli oɓokye ndambo ya ɓato ɓa Isalayɛlɛ teɓazinzye ianola Ŋwaphongo, yango mɛna, kasi ɓamo ɓongwana. Esengyesi oɓokye ɓato ɓasɔ ɓate ɓali Ɓayuda ɓaɔlɔ Ŋwaphongo ɓaanole, emba ɓato ɓa Isalayɛlɛ ɓamba ɓongwana. ");
INSERT INTO loq_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Emba Ŋwaphongo amobikya ɓato ɓasɔ ɓa Isalayɛlɛ ɓo wa koma ɓɛ́ɛ o buku pha Ŋwaphongo oɓokye: «Moto owa moya kandola ɓato amouta o Siyona. Amumanya masumu ma ɓato ɓasɔ ɓaali ɓana ɓa Yakoɓo. ");
INSERT INTO loq_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Ŋwaphongo kawɔ yokye: Eye eli sangola eya mokyela nga na ɓɛ, wa mumanya nga masumu ma ɓɛ.» ");
INSERT INTO loq_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Ɓayuda ɓalɛ Simo Elaa, emba ɓabuto ɓanguna ɓa Ŋwaphongo. Eli ɓaɓona phɔ ɓɛ̀ɛ ɓate ɓali Ɓayuda onyɔlɔ omɔ. Kasi mbala eyɔkɔ Ŋwaphongo aɓaɔlɔ phɔ ɓaɓe ɓato ɓɛ, kambe na ɓazinga phɔ alakyelaka ɓankɔkɔ ɓa ɓɛ́ɛ ɓaɓona. ");
INSERT INTO loq_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Ɓo Ŋwaphongo aɓangyi moto ambi na mophɛɛ mbolo, wa ikale nde ɓaɓona, phɔ Ŋwaphongo taaɓongole maumunya mɛ. ");
INSERT INTO loq_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Ɓɛ̀ɛ ɓaate ɓali Ɓayuda, kalakala toika tosa Ŋwaphongo. Kasi uŋwaŋwa eye Ŋwaphongo aeyokyesi ngɔngɔ phɔ Ɓayuda teɓaikyi motosa. ");
INSERT INTO loq_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Phɔ ya ɓɛ̀ɛ, ya moɓaa nde ɓomɔ mɛ. Uŋwaŋwa eye teɓamotosa emba Ŋwaphongo kakyele nde ɓolaa oka ɓɛ. Kasi eli ɓaɓona phɔ ya oɓokye na ɓɛ́ɛ mɛ ɓaɓongole ntema na oɓokye Ŋwaphongo aɓaokyele ngɔngɔ. ");
INSERT INTO loq_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Emba Ŋwaphongo alɛ ɓato ɓasɔ oɓokye ɓalɛ imotosa. Akyela ɓaɓona phɔ aokyele ɓato ɓasɔ ngɔngɔ. ");
INSERT INTO loq_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Phɛlɛ ndondo elaa ya Ŋwaphongo elekyi! Ali na zebi, kaeɓe maphɔɔ masɔ! Ikyiumunya yo o ndondo yɛ moto takokyi iilimbola! Moto takokyi isɔsɔlɔ nzela yɛ! ");
INSERT INTO loq_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Nde ɓo wakoma ɓɛ́ɛ o buku pha Ŋwaphongo oɓokye: «Okoeɓe maumunya ma Nkolo Ŋwaphongo nza? Ookokyi imophɛ toli nza? ");
INSERT INTO loq_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Wali moto owa mokaɓela ekpele phɔ ya oɓokye Ŋwaphongo ali na mbɔngɔ yɛ?» ");
INSERT INTO loq_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Eli phɛlɛ, tewali moto, phɔ eli nde yo moto owa kyela bikpele bisɔ, yo moto okobiɓanza, mbolo isɔ ili omɔ phɔ yɛ. Eɓɔngyi tomokumole nkɔlɔ isɔ. Amɛ! ");
INSERT INTO loq_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Phɔ eli ɓaɓona ɓande na nga, na eɓɔndi, phɔ Ŋwaphongo alookyesi ngɔngɔ iikye. Ambya nzoto ya ɓɛ̀ɛ isɔ oka yɛ, phɔ oɓe na ɓomɔɔ, omamɓya ndokolo nyama eya ɓoma ɓɛ́ɛ phɔ ya ikaɓela Ŋwaphongo. Ɓa mouwosi phɔ yɛ, phɔ ya imosepelisa. Mɛna eli laakolo losambo lookokyi ɓɛ́ɛ imosembela. ");
INSERT INTO loq_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Sa ɓenga moɓesi ŋwa ɓato ɓa mokyisi. Lɛ oɓokye Ŋwaphongo aɓongole mandondo ma ɓɛ̀ɛ, phɔ obutwe ɓato ɓa moɓesi moonyakune. Emba wamoeɓa maphɔɔ mazingye Ŋwaphongo. Kyelukye iwɔ oɓokye: Maphɔɔ maala, maphɔɔ mamosepelisa, na maphɔɔ malongoɓana. ");
INSERT INTO loq_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Phɔ ya ikaɓo saphɛ Ŋwaphongo na ngɔlu yɛ, nawɔ na mɔnɔmɔ na mɔnɔmɔ onte ya ɓɛ̀ɛ ngakye: Sa mitata, kasi omieɓe nde na ɓolaa ndengye eli ɓɛ̀ɛ phɛlɛ, kyeka ndengye ya ianola sa wɛ ɓo owaephɛ Ŋwaphongo. ");
INSERT INTO loq_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Nzoto ya moto ili yɔnɔyɔ kasi ili na binango biikye. Enango yɔnɔyɔ na yɔnɔyɔ eli na etoma eekyɛsɛɛ. ");
INSERT INTO loq_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","Na phɔ ya ɓanga wali nde ɓomɔ mɛ. Toli ɓaikye kasi toli nde mɔnɔmɔ onte ya Yesu Klisto. Totongana na moto mɔnɔmɔ nde ɓo watongana binango ɓa nzoto o nzoto ya moto. ");
INSERT INTO loq_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Ŋwaphongo alophɛ makaɓo ma Ɓolɔɓɔ makyɛsɛnɛ, nde ɓo wazinga yo ilophɛ mango. Emba, mɔnɔmɔ na mɔnɔmɔ akyelele makaɓo mɛ. Ɓo Ŋwaphongo aephɛ ikaɓo sa iimolaka maphɔɔ mɛ, imola ɓo koeɓe wɛ oɓokye Ŋwaphongo aephɛ ikaɓo. ");
INSERT INTO loq_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Ɓo Ŋwaphongo aephɛ ikaɓo sa ikyelela ɓato, oɓakyelele ɓookokyi. Ɓo Ŋwaphongo aephɛ ikaɓo sa iteya ɓato, oɓateya nde ɓomɔ. ");
INSERT INTO loq_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Ɓo Ŋwaphongo aephɛ ikaɓo sa ilenzaka ɓato, oɓalenzakye nde ɓomɔ. Ɓo Ŋwaphongo aephɛ ikaɓo sa ikaɓela ɓaɓola, oɓakaɓele nde ɓomɔ na ndondo yɔnɔyɔ. Ɓo Ŋwaphongo aephɛ ikaɓo sa ikamba ɓɛbi, kyela etoma mɛ na ɓolaa. Ɓo Ŋwaphongo aephɛ ikaɓo sa ikyelaka ɓɛbi ɓolaa, oɓakyelele na nkyisa. ");
INSERT INTO loq_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Zinga ɓɛbi na ndondo yɔnɔyɔ, sa ɓazinga nde na munɔkɔ. Iina maphɔɔ maaɓe. Zinga maphɔɔ maala. ");
INSERT INTO loq_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Zinga ɓɛbi na ɓɛ̀ɛ ɓaklisto, eɓa oɓokye ɓɛ̀ɛ ɓasɔ oli ɓana ɓa nyango mɔnɔmɔ. Tosanaka ɓɛ̀ɛ na ɓɛ̀ɛ. ");
INSERT INTO loq_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Omiambya o etoma, sa ɓa ɓato ɓa ɓokɔɔ. Omiambya mouwosi o etoma ya Nkolo. ");
INSERT INTO loq_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Kolemele yalakyela Ŋwaphongo. Emba ɓaa na nkyisa. Ititala o minyɔkɔ, ɓɔndɛlɛ Ŋwaphongo imbɛlɛ sisɔ. ");
INSERT INTO loq_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Kaɓa mbolo ya ɓɛ̀ɛ oka ɓaanosi ɓa Ŋwaphongo ɓaakyelesi. Yamba na ɓolaa ɓato ɓaaye oka ɓɛ̀ɛ. ");
INSERT INTO loq_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Onga Ŋwaphongo apambole ɓato ɓaenyɔkɔlɔ, sa moonga oɓokye aɓakyele ɓoɓe. ");
INSERT INTO loq_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Sepela na ɓaasepele, lela na ɓaalele. ");
INSERT INTO loq_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Ɓa na ɓooka wɛ na ɓɛbi na wɛ. Sa ɓaa na lolɛndɔ, kyela etoma esɔ na ɓo eɓe na ngambo ekyikyi. Saumunya oɓokye oli ɓato ɓaa zebi. ");
INSERT INTO loq_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Ɓo moto mɔnɔmɔ aekyesi ɓoɓe, sa mobuyisa ɓoɓe, kasi wɛ luka nde nzela ya ikyela maphɔɔ maakokyi oɓokye ɓato ɓasɔ ɓaanole oɓokye iwɛ kokyele ɓolaa. ");
INSERT INTO loq_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Ɓo wakokyi, emba ɓo eeli nde phɔ ya wɛ, luka oɓokye oɓee na ɓose na ɓato ɓasɔ. ");
INSERT INTO loq_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Ɓɛ̀ɛ ɓato ɓazingye nga, sabuyisa ɓato ɓoɓe, kasi lɛ oɓokye yɔɔ ya Ŋwaphongo ekyele etoma ya yango, phɔ ɓakoma o buku pha Ŋwaphongo oɓokye: «Nkolo Ŋwaphongo yokye: Moambelesi eli nde nga! Lowɔ loɓe loekyesi nwɛbi, nde nga moto owaamobuyisa ɓoɓe.» ");
INSERT INTO loq_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Kasi iloɓa sa Ŋwaphongo siwɔ na oɓokye: «Ɓo monguna ŋwa wɛ ali na nzala, omophɛ ŋwana ekpele wa izaa. Ɓo ali na phowa ya maa, omophɛ maa mainywa. Ɓo okyesi ɓaɓona sɔɔ ya moakya amba na ɓɔngyɛ moɓɛsi nwɛ.» ");
INSERT INTO loq_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Samilɛɛ oɓokye ɓoɓe ɓoelekye, kasi leka ɓoɓe na ikyela ɓolaa. ");
INSERT INTO loq_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Moto munsɔ atosa ɓakonzi ɓa ɓaloo phɔ ɓokonzi ɓosɔ ɓoute na Ŋwaphongo; Emba makonzi maalii, eli Ŋwaphongo moto owamatɛyɛ. ");
INSERT INTO loq_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Emba moto ookotɛmɛlɛ ɓakonzi, katɛmɛlɛ maphɔɔ molɔngɔ ŋwaaɓɔngya Ŋwaphongo. Ɓato ɓakyele ɓaɓona ɓamiɓangyele etumbu. ");
INSERT INTO loq_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Ɓato ɓakyele ɓolaa teɓali na inganga sa ɓakonzi, kasi nde ɓato ɓakyele ɓoɓe ɓamoɓa na inganga. Ɓo tozingye iɓaa na inganga sa ɓakonzi, kyela ɓolaa phɔ ɓaekumisa. ");
INSERT INTO loq_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Eli ɓaɓona phɔ ɓali ɓato ɓa etoma ya Ŋwaphongo, ɓazingye iesunga o ikyela ɓolaa. Ɓo okyesi ɓoɓe, ɓa na inganga na ɓɛ́ɛ phɔ ɓokusi phaaɓaphɛ Ŋwaphongo taaɓoambya ɓoambisa. Ɓali ɓato ɓa etoma ya Ŋwaphongo phɔ ya iteya yaaka Ŋwaphongo na iphɛ ɓato ɓakyele ɓoɓe etumbu. ");
INSERT INTO loq_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Phɔ eli ɓaɓona, osengyesi itosa ɓakonzi. Teli nde phɔ ɓamoephɛ etumbu ɓo toɓatose. Oɓatosa nde phɔ koeɓe o mandondo ma ɓɛ̀ɛ oɓokye eli nzela elaa. ");
INSERT INTO loq_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Phɔ ya ntina mɛ, yango mɛna, kophute mputi, phɔ Ŋwaphongo atɛyɛ ɓato ɓaephutisa oɓokye etoma mɛ eɓe na ɓolaa. ");
INSERT INTO loq_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Phuta oka moto na moto isengyesi wɛ iphuta oka yɛ. Phuta mputi oka ɓaephutisa, phutela mbolo ya wɛ oka ɓato ɓaiphutisa. Tosa na ɓolaa ɓato ɓasengyesi wɛ itosa. ");
INSERT INTO loq_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Sa ɓaa na mbɔngɔ na moto, ɓoteeɓe nde mbɔngɔ ya izingana onte ya ɓɛ̀ɛ. Moto okozingye ɓɛbi atose miɓeko ma Ŋwaphongo misɔ. ");
INSERT INTO loq_vpl VALUES ("RM13_9","075_13_9","ROM","13