﻿USE sofia;
DROP TABLE IF EXISTS sofia.log_vpl;
CREATE TABLE log_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES log_vpl WRITE;
INSERT INTO log_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yésu Krísto angá Dàwídì nɨ súrú lésè, ɨ̀ndɨ̀ Dàwídì angá ɨ́na Àbàrámà nɨ súrú lésè. Kònɨ̀dhɨ Yésu Krísto nɨ tábhí kɨ tìma nɨ tà tɨsɨ̀le dhɨ ꞌɨ: ");
INSERT INTO log_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Àbàrámà ti tá Ɨ̀sákà, Ɨ̀sákà dré Yàkóbhò nɨ tìzo gò, Yàkóbhò dré Yúdà kɨ tìzo adrúpi nɨ ɨ́be. ");
INSERT INTO log_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yúdà ɨ Tàmárà be dhɨ ɨ̀ dré Fàrésà kɨ tìzo Zárà be. Fàrésà dré Èsèrómà nɨ tìzo, Èsèrómà dré Àrámà nɨ tìzo. ");
INSERT INTO log_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Àrámà dré Àmìnàdábà nɨ tìzo, Àmìnàdábà dré Nàsónà nɨ tìzo, Nàsónà dré Sàlòmónà nɨ tìzo. ");
INSERT INTO log_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Sàlòmónà ɨ Rábà be dhɨ ɨ̀ dré Bòwésà nɨ tìzo. Bòwésà ɨ Rútà be dhɨ ɨ̀ dré Yòbédè nɨ tìzo. Yòbédè dré Yésè nɨ tìzo, ");
INSERT INTO log_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yésè dré ópɨ́ Dàwídì nɨ tìzo. Dàwídì ɨ Ùríyà nɨ tòkó be dhɨ ɨ̀ dré Sòlòmónò nɨ tìzo. ");
INSERT INTO log_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sòlòmónò dré Ròbòwámà nɨ tìzo, Ròbòwámà dré Àbɨ́yà nɨ tìzo, Àbɨ́yà dré Àsáfà nɨ tìzo. ");
INSERT INTO log_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Àsáfà dré Yòsàfátà nɨ tìzo, Yòsàfátà dré Yòrámà nɨ tìzo, Yòrámà dré Òzɨ́yà nɨ tìzo. ");
INSERT INTO log_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Òzɨ́yà dré Yòwàtámà nɨ tìzo, Yòwàtámà dré Àkázà nɨ tìzo, Àkázà dré Èzèkɨ́yà nɨ tìzo. ");
INSERT INTO log_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Èzèkɨ́yà dré Mànásè nɨ tìzo, Mànásè dré Àmónà nɨ tìzo, Àmónà dré Yòsɨ́yà nɨ tìzo. ");
INSERT INTO log_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yòsɨ́yà dré Yèkònɨ́yà kɨ tìzo adrúpi nɨ ɨ́be, lókyá Ɨ̀sèrélè ànzɨ kɨ rùzo dòle Bàbìlónà na àdzú sè dhɨ ꞌá. ");
INSERT INTO log_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Àyɨ nda kɨ dòma Bàbìlónà na dhɨ àmvolésè dhɨ, Yèkònɨ́yà dré Sàlàtɨ̀yélè nɨ tìzo, Sàlàtɨ̀yélè dré Zòròbàbélè nɨ tìzo. ");
INSERT INTO log_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zòròbàbélè dré Àbìyúdà nɨ tìzo, Àbìyúdà dré Èlìyàkímà nɨ tìzo, Èlìyàkímà dré Àzórà nɨ tìzo. ");
INSERT INTO log_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Àzórà dré Sàdókà nɨ tìzo, Sàdókà dré Àkímà nɨ tìzo, Àkímà dré Èlìyúdà nɨ tìzo. ");
INSERT INTO log_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Èlìyúdà dré Èlèyàzárà nɨ tìzo, Èlèyàzárà dré Màtánà nɨ tìzo, Màtánà dré Yàkóbhò nɨ tìzo, ");
INSERT INTO log_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yàkóbhò dré Yòséfà nɨ tìzo. Yòséfà nda tá Màrɨ́yà nɨ agó ꞌɨ. Dɨ Màrɨ́yà nda dré Yésu, adrélé zìle Mèsɨ́yà dhɨ nɨ tìzo. ");
INSERT INTO log_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Kɨdhólé Àbàrámà rú atsálé Dàwídì rú dhɨ, máti tá mudrí-drì-su. Kɨdhólé Dàwídì rú atsálé Ɨ̀sèrélè ànzɨ kɨ dòma Bàbìlónà na dhɨ rú dhɨ, máti kpà mudrí-drì-su. Kɨdhólé àyɨ nda kɨ dòma rú atsálé Mèsɨ́yà nɨ tìma rú dhɨ, máti kókpà mudrí-drì-su. ");
INSERT INTO log_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yésu Krísto nɨ tìma tá kònɨ̀nɨ: À zɨ̀ tá Yésu nɨ andre, Màrɨ́yà, Yòséfà dré tòko ró. Dɨ, drìdrì ɨ̀ dré ru amúzó dhɨ kandrá dhɨ, Màrɨ́yà kisú tá ɨ́na ꞌa Tɨrɨ́ Lólo nɨ rìnyí sè. ");
INSERT INTO log_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Dɨ agó nɨ Yòséfà dré adrélé móndɨ́ gyǎgya ꞌɨ dhɨ sè dhɨ, lè tá kanyò fèle drá móndɨ́ ɨ mi ko gò, dré kisùzoá dhɨ, ɨ́ nɨ akódhɨ nɨ tayɨ́ kòlyà. ");
INSERT INTO log_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Dɨ dré tá adréràꞌa tà nda nɨ kisù dhɨ ꞌá dhɨ, ángéló Mírì àdhya dré agázó akódhɨ kandrá toróbɨ́ na, tàá drá dhɨ: «Yòséfà, Dàwídì nɨ mvá, mɨ́ ro Màrɨ́yà nɨ dòma mòle dhɨ ko. Tàko ko, ꞌa dré kisúlé kòdhɨ, kisú Tɨrɨ́ Lólo nɨ rìnyí sè. ");
INSERT INTO log_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","A nɨ mváagó ti. Mɨ́ nɨ akódhɨ nɨ rú zi Yésu. Tàko ko, akódhɨ nɨ áyɨ móndyá kɨ tɨdrɨ́ àyɨ kɨ tàkonzɨ̀ ɨ lésè.» ");
INSERT INTO log_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Dɨ tà nda kòdhɨ ɨ̀ atsá títí kònɨ̀nɨ, kɨtswálé tà Mírì dré tá longólé áyɨ pròfétà tí dhɨ ɨ̀ kòꞌoró ru be dhɨ bvó. Akódhɨ longó tá dhɨ: ");
INSERT INTO log_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«Mɨ̀ nò rè ká! Kyánzɨ àgo tà nìlepi rè ko dhɨ nɨ ꞌa kisú gò, dré mváagó tìzo. À nɨ rú nɨ nɨ zi Èmànùwélè.» Rú nda kòdhɨ adré lèá tàle dhɨ «Gìká túmä́ní àma ɨ́be». ");
INSERT INTO log_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Dɨ Yòséfà kòlaró dre dhɨ, dré Màrɨ́yà nda nɨ dòzo mòle ngóró ángéló Mírì àdhya dré tá tàle akódhɨ dré dhɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Dɨ, ayí ɨ́na akódhɨ be ko, tsàle lókyá dré mváagó tìzo dhɨ ꞌá. Gò dré mváagó nda nɨ rú zìzo Yésu. ");
INSERT INTO log_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","À ti tá Yésu Bètèlémè, bvò Yùdáyà àdhya lé dhɨ na, ópɨ́ Èródè nɨ lókyá ꞌá. Akódhɨ nɨ tìma àmvolésè dhɨ, tògyabhá bhìbhínyà tà ndabhá nìle dhɨ ɨ̀ dré angázó kìtú dré apfǒrà lésè, alɨ̀le atsálé Yèrúsalémà le. ");
INSERT INTO log_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ɨ̀ dré lizízóá dhɨ: «Mvámvá tìle Yúdà ànzɨ kɨ ópɨ́ ro dhɨ ángwà? Tàko ko, mà nò tá akódhɨ nɨ bhìbhínyà kìtú dré apfǒrà lésè gò, mà dré alɨ̀zo kɨtswálé akódhɨ nɨ lɨndrɨ̀ bha.» ");
INSERT INTO log_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Dɨ ópɨ́ Èródè kòyi tà nda dre dhɨ, akódhɨ nɨ drì dré abɨ́zó, ngóró móndyá títí Yèrúsalémà le dhɨ kya tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Dré Yúdà ànzɨ kɨ kòwánà kàdrɨ̀ kɨ kɨmózó tátrɨ́trɨ́ kúlí tadhábhá ɨ́be gò, lizízóá àyɨ tí dhɨ: «Pròfétà ɨ̀ adré tá tàá dhɨ, à nɨ Mèsɨ́yà nɨ ti ángolé ya?» ");
INSERT INTO log_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ɨ̀ logó drá dhɨ: «Bètèlémè, Yùdáyà le dhɨ na. Àngyá ko, pròfétà kɨ àlo tɨsɨ̀ kònɨ̀nɨ: ");
INSERT INTO log_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‹Dɨ mɨ, Bètèlémè bvò Yúdà àdhya lé nɨ, ámɨ tà tsà bhàandre kàdrɨ̀kàdrɨ̀ Yùdáyà le dhɨ kya ɨ kòfalé ko. Tàko ko, ópɨ́ àlo dhɨ nɨ apfò mɨ́ lésè. A nɨ áma móndyá, Ɨ̀sèrélè ànzɨ kɨ drì ko kábilígyà lɨkɨ́lépi tɨ́nɨ.›» ");
INSERT INTO log_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Èródè kòyi tà nda dre dhɨ, dré tògyabhá nda kɨ zìzo lùzu ró gò, àyɨ kɨ lizízó lókyá bhìbhínyà nda dré tá kɨdhózó apfòle dhɨ nɨ nìzo. ");
INSERT INTO log_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Gò dré àyɨ kɨ mùzo Bètèlémè na, tàzoá àyɨ dré dhɨ: «Mɨ̀ kòlɨ̀ móndyá kònàle dhɨ kɨ lizí, mvámvá nda nɨ tà nìzo dóro. Dɨ mɨ̀ kòkisú akódhɨ dre dhɨ, mɨ̀ kàmù kúlí má dré, má kòkɨtswáró kpà lɨ̀le akódhɨ nɨ lɨndrɨ̀ bha be dhɨ bvó.» ");
INSERT INTO log_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Dɨ tògyabhá nda ɨ̀ kòyi ópɨ́ nda nɨ kúlí dre dhɨ, ɨ̀ dré ngàzo lɨ̀le. Ɨ̀ dré tá adréràꞌa láti ꞌá dhɨ, bhìbhínyà ɨ̀ dré tá nòle kìtú dré apfǒrà lésè nda adré tá lɨ̀le àyɨ kandrána, tsàle áyɨ kɨkɨ́ àrà mvámvá nda dré tá adrézó dhɨ drìle. ");
INSERT INTO log_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Dɨ ɨ̀ kònò bhìbhínyà nda áyɨ kɨkɨ́ràꞌa dre dhɨ, ɨ̀ dré lenzézó lavúlé. ");
INSERT INTO log_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ɨ̀ kòfɨ dzó na dre dhɨ, ɨ̀ dré mvámvá nda nɨ nòzo andre nɨ Màrɨ́yà be gò, ɨ̀ dré dhèzo àyɨ kɨ kórókó titì mvámvá nda kandrá, akódhɨ nɨ lɨndrɨ̀ bhàzo. Dɨ ɨ̀ dré ngá làgɨ́ be kàdrɨ̀ ɨ̀ dré adólé dhɨ kɨ kɨnzɨ́zó fèle drá. Ɨ̀ fè tá órò, béndélé, ɨ̀ndɨ̀ màlásɨ̀ ledélé mírè sè dhɨ be. ");
INSERT INTO log_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Àmvolásà dhɨ, Gìká dré tà longózó àyɨ dri toróbɨ́ na tàzoá dhɨ, ɨ̀ kògò nzɨ̀le Èródè vélésè ko. Dɨ ɨ̀ dré láti àzya dòzo, nzɨ̀zo àyɨ kɨ bvò na. ");
INSERT INTO log_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Tògyabhá nda ɨ̀ kòlɨ̀ dre dhɨ, ángéló Mírì àdhya dré agázó Yòséfà kandrá toróbɨ́ na, tàá drá dhɨ: «Mɨ́ nga mvámvá kòdhɨ nɨ do andre nɨ be, lapázó àyɨ ɨ́be Èzèpétò na. Mɨ̀ kàdré kònàle tsàle lókyá má dré dra tàzoá mɨ́ kàgò dhɨ ꞌá. Tàko ko, Èródè adré ꞌòle mvámvá nda nɨ nda pfùle dràle.» ");
INSERT INTO log_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Dɨ Yòséfà dré ngàzo ngátsi kɨ́tógá sè mvámvá nda nɨ do andre nɨ be gò, lapázó àyɨ ɨ́be Èzèpétò na. ");
INSERT INTO log_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ɨ̀ dré adrézó kònàle tsàle lókyá Èródè dré dràzo dhɨ ꞌá. Tà nda kòdhɨ atsá kònɨ̀nɨ, kɨtswálé tà Mírì dré tá longólé áyɨ pròfétà tí dhɨ kòꞌoró ru be dhɨ bvó. Akódhɨ longó tá dhɨ: «Má azí áma mváagó apfòle Èzèpétò lésè.» ");
INSERT INTO log_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Èródè kònò dhɨ, tògyabhá nda ɨ̀ lɨtɨ́ tá ɨ dre dhɨ, akódhɨ nɨ togó dré aswázó tà tàndɨ ró. Dɨ dré móndɨ́ kɨ mùzo lɨ̀le Bètèlémè na ɨ̀ndɨ̀ bhà làgásà dhɨ ɨ ꞌásè, ànzɨàgo títí kóná ɨ́be rì dhɨ kɨ tupfú todràle, túmä́ní àyɨ kóná tsabhá rè rì ko dhɨ ɨ́be. Kɨ tá kóná nda kɨ bvó lókyá dré tá yìle tògyabhá nda ɨ vélésè dhɨ sè. ");
INSERT INTO log_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Dɨ tà Mírì dré tá longólé pròfétà Yèrèmɨ́yà tí dhɨ dré ru ꞌòzo kònɨ̀nɨ. Akódhɨ longó tá dhɨ: ");
INSERT INTO log_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«Kúlí adré angálé Rámà lésè. À adré ngòle adrézó tongólé. Ràkélè adré áyɨ ànzɨmvá kɨ ngo nɨ̀. Adré lèá à kòtɨndrɨ̀ áyɨ togó wà dhɨ ko, ànzɨmvá nda ɨ̀ dré adrélé vélé yó dhɨ sè.» ");
INSERT INTO log_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Èródè nɨ dràma àmvolésè dhɨ, ángéló Mírì àdhya dré agázó toróbɨ́ na Yòséfà kandrá Èzèpétò na, tàá drá dhɨ: ");
INSERT INTO log_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","«Mɨ́ nga mvámvá do andre nɨ be, nzɨ̀zo àyɨ ɨ́be Ɨ̀sèrélè ànzɨ kɨ bvò na. Tàko ko, móndyá adrébhá tá láti nda mvámvá nda nɨ ꞌòzo dràle dhɨ ɨ̀ todrà akɨ́lé dre.» ");
INSERT INTO log_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Dɨ Yòséfà dré ngàzo mvámvá nda nɨ do andre nɨ be gò, nzɨ̀zo àyɨ ɨ́be Ɨ̀sèrélè ànzɨ kɨ bvò na. ");
INSERT INTO log_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Dɨ, dré yìzoá tàle dhɨ, Àrèkèláwò atsá tá ópɨ́ ro Yùdáyà drìle áyɨ atá Èródè nɨ àrà ꞌa dhɨ, dré ɨ́na adrézó ngá ro nzɨ̀ma kònàle dhɨ sè. Dɨ Gìká dré gòzo tà longó drá toróbɨ́ na gò, ɨ̀ dré lɨ̀zo bvò Gàlìláyà àdhya na. ");
INSERT INTO log_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ɨ̀ kòtsa kònàle dre dhɨ, ɨ̀ dré bhà mòzo adrézó bhàandre rú zìle Nàzàrétà dhɨ na. Tà nda kòdhɨ atsá kònɨ̀nɨ, kɨtswálé tà longólé pròfétà ɨ tí dhɨ kòꞌoró ru be dhɨ bvó. Ɨ̀ longó tá dhɨ: «À nɨ akódhɨ nɨ zi Nàzàrétà mvá ro.» ");
INSERT INTO log_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Lókyá nda àmvolésè dhɨ, Yòwánɨ̀ Bàtísimò fèlepi dré pfòzo adrélé Gìká nɨ kúlí longó duku Yùdáyà àdhya na. ");
INSERT INTO log_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Adré tá tàá dhɨ: «Mɨ̀ kòladzá àmɨ kɨ togó agòzo Gìká vélé. Tàko ko, Òpɨ̀ bhù àdhya atsá ànyɨ dre.» ");
INSERT INTO log_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yòwánɨ̀ nda tá dhya pròfétà Èsáyà dré tá tà nɨ nɨ tàzo dhɨ ꞌɨ. Akódhɨ tà tá dhɨ: «Dhya àlo adré kúlí loyó duku na, adrézó tàá dhɨ: ‹Mɨ̀ kòledé láti Mírì dré alɨ̀zo! Mɨ̀ kòlotó láti atsálé pyà akódhɨ dré!›» ");
INSERT INTO log_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yòwánɨ̀ asó tá kɨ́tá ledélé kàmílò bhɨ́ sè dhɨ ɨ́ rú, káfà ledélé kàꞌwá kɨ́nɨ́ sè dhɨ nɨ ꞌɨ̀zo áyɨ kípílé ꞌá. Akódhɨ nɨ mányàngá tá kɨ́sa ꞌɨ, túmä́ní apé mbɨ̀ na dhɨ be. ");
INSERT INTO log_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Móndɨ́ zyandre dhɨ ɨ̀ adré tá apfòle Yèrúsalémà lésè, bvò wä́yi Yùdáyà àdhya lésè, ɨ̀ndɨ̀ bvò wä́yi Yòròdánè làgásè dhɨ lésè, alɨ̀le Yòwánɨ̀ vélé. ");
INSERT INTO log_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ɨ̀ adré tá àyɨ kɨ tàkonzɨ̀ kɨ ta ngádra ꞌá gò, akódhɨ dré adrézó bàtísimò fe àyɨ dré yǐandre Yòròdánè àdhya na. ");
INSERT INTO log_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Dɨ, akódhɨ kònò Fàrìsáyò ɨ, Sàdùkáyò ɨ́be bǐ dhɨ ɨ adréràꞌa alɨ̀le kɨtswálé bàtísimò do ɨ́ vélé dre dhɨ, dré tàzoá àyɨ dré dhɨ: «Àmɨ, nì àtrá kɨ àrèbhá nɨ ɨ, àdhi tadhá àmɨ dré dhɨ, mɨ̀ kòlapá Gìká nɨ kombà adrélépi alɨ̀le dhɨ sílésè dhɨ nɨ̀? ");
INSERT INTO log_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Lè mɨ̀ kàdré tà adrébhá tadhá dhɨ, mɨ̀ ladzá àmɨ kɨ togó dre dhɨ kɨ ꞌo kòdhya. ");
INSERT INTO log_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Mɨ̀ kòbhà àmɨ adrélé kisùá àmɨ léna dhɨ ‹Àma àmakya Àbàrámà nɨ ànzɨ ꞌɨ› dhɨ ko. Tàko ko, má adré tàá àmɨ dré dhɨ: Gìká rìnyí ɨ́be kɨtswázó ànzɨ ꞌo topfòle Àbàrámà dré kɨ́rà kònɨ ɨ lésè. ");
INSERT INTO log_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","À ga kùbalú fa kómvó ɨ rú dre. Dɨ à nɨ fa títí adrébhá lòꞌwa dóro ꞌa ko dhɨ kɨ togá lebhélé àtsɨ́ na. ");
INSERT INTO log_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Má adré mána bàtísimò fe àmɨ dré yǐ sè tadházóá dhɨ, mɨ̀ ladzá àmɨ kɨ togó dre. Dɨ, dhya àlo áma lavúlépi rìnyí sè dhɨ nɨ ɨ́na adhé má bvó. Má kɨtswá akódhɨ nda nɨ lɨndrɨ̀ sè ko. Má kɨtswá ndɨ̀ndɨ̀ akódhɨ nɨ kámókà tɨngɨ́ bwà ko. Akódhɨ nɨ bàtísimò fe àmɨ dré Tɨrɨ́ Lólo sè, ɨ̀ndɨ̀ àtsɨ́ sè. ");
INSERT INTO log_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Akódhɨ ndàkpá ɨ́be ɨ́ drɨ́gá. Ásà dhɨ, a nɨ ngánò àngbó ɨ́na drìna dhɨ nɨ awá, lòꞌwa nɨ nɨ lomvózó dàle kòbhó na gò, kúyí nɨ nɨ kùzo zàle àtsɨ́ adrélépi adrálé ko dhɨ na.» ");
INSERT INTO log_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Lókyá nda sè dhɨ, Yésu dré angázó Gàlìláyà lésè alɨ̀le Yòwánɨ̀ vélé kɨtswálé bàtísimò do Yòròdánè na. ");
INSERT INTO log_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Dɨ, Yòwánɨ̀ lè tá ɨ́na bàtísimò fèle Yésu dré ko gò, dré tàzoá drá dhɨ: «Adré tá lèá dhɨ, mɨ́ kòfè bàtísimò má dré mɨ. Dɨ, mɨ́ gò mɨ́na alɨ̀le bàtísimò do má vélé ngɨ́nɨngɨ́nɨ ró?» ");
INSERT INTO log_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Dɨ Yésu logó drá dhɨ: «Mɨ́ kòkaꞌì tà kòdhɨ kàdré kònɨ̀nɨ lókyá kònɨ̀dhɨ sè. Tàko ko, adré lèá dhɨ, mà kòꞌo tà gyǎgya títí Gìká dré adrélé lèle mà kòꞌo dhɨ ɨ kɨtswálé títí.» Dɨ Yòwánɨ̀ dré bàtísimò kaꞌìzo fèle drá. ");
INSERT INTO log_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yésu kòdo bàtísimò dre dhɨ, dré apfòzo yǐ lésè. Dɨ gbǎ kòdhwa, bhù dré ru lanzízó gò, Yésu dré Gìká nɨ Tɨrɨ́ nòzo asíràꞌa kòbhòlà tɨ́nɨ adhélé ɨ́ dri. ");
INSERT INTO log_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Gò kúlí dré apfòzo bhù lésè tàá dhɨ: «Kònɨ̀dhɨ áma Mváagó má dré lèle tò dhɨ ꞌɨ. Áma togó adré kɨnɨ́lé akódhɨ nɨ tà sè tò.» ");
INSERT INTO log_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Àmvolásà dhɨ, Tɨrɨ́ Lólo dré Yésu nɨ drìzo lɨ̀zo akódhɨ be duku na, Dzáborò kòtabhìró akódhɨ lɨtɨ́lé be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Kònàle dhɨ, Yésu dré tàbirí mvòzo kìtú nyadhɨ-rì ɨ̀ndɨ̀ ngátsi nyadhɨ-rì gò, tàbirí dré akódhɨ nɨ ꞌòzo. ");
INSERT INTO log_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Dɨ Dzáborò dré áyɨ kisízó ànyɨ akódhɨ làga, tàá drá dhɨ: «Mɨ́ kàdré Gìká nɨ Mváagó ꞌɨ bàti dhɨ, mɨ́ kòtà kɨ́rà kònɨ ɨ dré dhɨ, ɨ̀ kòladzá ru atsálé mápà ro.» ");
INSERT INTO log_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Dɨ, Yésu logó drá dhɨ: «Gìká nɨ Kúlí adré tàá dhɨ: ‹Móndɨ́ adré ngbà ꞌí adrélé lɨ́drɨ̀ ɨ́be mápà sè ko. Be ró dhɨ, adré lɨ́drɨ̀ ɨ́be kúlí títí adrébhá apfòle Gìká sílésè dhɨ ɨ sè.›» ");
INSERT INTO log_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Gò Dzáborò dré akódhɨ nɨ drìzo lɨ̀zo ába Yèrúsalémà, bhàandre lólo dhɨ na, akódhɨ nɨ bha tépelò nɨ drì kàkú na. ");
INSERT INTO log_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Dré tàzoá drá dhɨ: «Mɨ́ kàdré Gìká nɨ Mváagó ꞌɨ bàti dhɨ, mɨ́ wa dhèle bvò dri. Àngyá ko, Gìká nɨ Kúlí adré tàá dhɨ: ‹Gìká nɨ tòlɨ́ fe áyɨ ángéló ɨ dré ámɨ tà sè. Àyɨ nda kɨ ámɨ ko kɨ́tó, mɨ́ kòdheró ámɨ pá si kɨ́rà dri ko.›» ");
INSERT INTO log_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Dɨ Yésu gò logóá drá dhɨ: «Gìká nɨ Kúlí adré kókpà tàá dhɨ: ‹Lè mɨ́ kòtabhì Mírì ámɨ Gìká ko.›» ");
INSERT INTO log_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Gò Dzáborò dré gòzo akódhɨ nɨ dri mbàzo ába kòngó àlo mvumvù lavúlé dhɨ drìna, òpɨ̀ wä́yi bvò àdhya kɨ tadházó drá àyɨ kɨ rúku ɨ́be. ");
INSERT INTO log_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Dré tàzoá drá dhɨ: «Má nɨ òpɨ̀ títí kòdhɨ kɨ fe mɨ́ dré, mɨ́ kàdhé ámɨ kórókó titì má kandrá áma lɨndrɨ̀ bhàzo dhɨ.» ");
INSERT INTO log_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Dɨ Yésu tà drá dhɨ: «Sàtánà, mɨ́ nga kònwásè! Tàko ko, Gìká nɨ Kúlí adré tàá dhɨ: ‹Lè mɨ́ kàdré ngbà ꞌí Mírì ámɨ Gìká nɨ lɨndrɨ̀ bha kòdhya. Mɨ́ kàdré kpà lɨ̀sámbò ꞌo ngbà ꞌí akódhɨ nɨ rú sè kalóma.›» ");
INSERT INTO log_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Dɨ Dzáborò dré ngàzo akódhɨ nɨ tayɨ́. Gò ángéló ɨ̀ dré alɨ̀zo akódhɨ nɨ ledé. ");
INSERT INTO log_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Àmvolásà dhɨ, Yésu dré yìzoá tàle dhɨ, à ru tá Yòwánɨ̀ bhèle bǎdzó na gò, dré gòzo gòle Gàlìláyà na. ");
INSERT INTO log_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Dré rè zyà tsàzo Nàzàrétà na gò, dré bhàandre nda nɨ tayɨ́zó lɨ̀zo bhà mo Kàpàrànàwúmà na. Bhàandre nda tä́pä́ríandre Gàlìláyà àdhya mìle, bvò Zàbùlónà ànzɨ kya Nèfàtálì ànzɨ ɨ́be dhɨ na. ");
INSERT INTO log_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Tà nda kòdhɨ atsá kònɨ̀nɨ, kɨtswálé tà longólé pròfétà Èsáyà tí dhɨ kòꞌoró ru be dhɨ bvó. Akódhɨ longó tá dhɨ: ");
INSERT INTO log_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Móndyá bvò Zàbùlónà ànzɨ kya Nèfàtálì ànzɨ ɨ́be dhɨ na dhɨ ɨ, àyɨ adrébhá tä́pä́ríandre mìle, ɨ̀ndɨ̀ Yòròdánè nɨ taꞌá na dhɨ ɨ, àyɨ adrébhá Gàlìláyà, bvò móndyá súrú twá ro dhɨ kya na dhɨ ɨ, ");
INSERT INTO log_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ɨ̀ adré tá lɨrɨ́lé tínímvá na gò, ɨ̀ dré ngádra kàdrɨ̀ dhɨ nɨ nòzo. Ɨ̀ adré tá lɨrɨ́lé lɨ́ndrɨ́ dràdrà àdhya zàle gò, ngádra dré apfòzo ngá kazá àyɨ kòfalé.» ");
INSERT INTO log_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kɨdhólé lókyá nda sè dhɨ, Yésu dré ngàzo adrélé Gìká nɨ kúlí longó, adrézó tàá dhɨ: «Mɨ̀ kòladzá àmɨ kɨ togó agòzo Gìká vélé. Tàko ko, Òpɨ̀ bhù àdhya atsá ànyɨ dre!» ");
INSERT INTO log_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Kìtú àlo, Yésu dré tá adréràꞌa atsílé tä́pä́ríandre Gàlìláyà àdhya mìlésè dhɨ ꞌá dhɨ, nò tá móndɨ́ rì adrúpi ró dhɨ ɨ. Àyɨ nda ɨ tá Sìmónà adrélé kpà rú zìle Pétèró dhɨ, túmä́ní adrúpi nɨ Àndréyà be dhɨ ꞌɨ. Ɨ̀ adré tá kɨmbá bhe yǐ na. Tàko ko, àyɨ tá kosyá bhebhá ꞌɨ. ");
INSERT INTO log_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yésu dré tàzoá àyɨ dré dhɨ: «Mɨ̀ alɨ̀ má vésè. Kɨdhólé nyànomvá dhɨ, mɨ̀ gò vélé adrélé kosyá bhebhá ɨ ró ko. Má nɨ àmɨ kɨ ꞌo adrélé móndɨ́ ndabhá ɨ ró.» ");
INSERT INTO log_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Dɨ gbǎ lókyá nda sè dhɨ, ɨ̀ dré àyɨ kɨ kɨmbá kɨ tayɨ́zó gò, ɨ̀ dré ngàzo adrélé akódhɨ nɨ lebè. ");
INSERT INTO log_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Yésu kòlɨ̀ drìdrì tsà dre dhɨ, dré móndɨ́ rì àruka adrébhá kpà adrúpi ró dhɨ kɨ nòzo. Àyɨ nda ɨ tá Yàkóbhò ɨ Yòwánɨ̀ be, Zèbèdáyò nɨ ànzɨ ꞌɨ. Ɨ̀ adré tá bwátù na túmä́ní àyɨ kɨ atá Zèbèdáyò be, adrélé àyɨ kɨ kɨmbá kɨ mì ledé. Gò Yésu dré àyɨ kɨ azízó. ");
INSERT INTO log_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Dɨ gbǎ kòdhwa, ɨ̀ dré àyɨ kɨ bwátù tayɨ́zó àyɨ kɨ atá be gò, ɨ̀ dré ngàzo adrélé akódhɨ nɨ lebè. ");
INSERT INTO log_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Àmvolásà dhɨ, Yésu dré ngàzo adrélé tatsílé bvò wä́yi Gàlìláyà àdhya ꞌásè, tà tadhábe Yúdà ànzɨ kɨ lɨ̀sámbò dzó ɨ ꞌásè, Rúbí Tanɨ Gìká nɨ Òpɨ̀ àdhya nɨ longóbe, ɨ̀ndɨ̀ móndɨ́ kɨ tɨdrɨ́be àyɨ kɨ drà títí ɨ lésè. ");
INSERT INTO log_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Dɨ akódhɨ nɨ rúbí adré tá laꞌúlé bvò nda ꞌásè títí, tsàle byá bvò Sìríyà àdhya na. À adré tá móndyá títí drà twátwa ɨ́be ɨ̀ndɨ̀ ngáaswa twátwa ɨ́be dhɨ kɨ adzí akódhɨ vélé, túmä́ní móndɨ́ tɨrɨ́ kònzɨ ɨ́be dhɨ ɨ́be, móndɨ́ àgɨlɨ́lɨ́ ɨ́be dhɨ ɨ́be, ɨ̀ndɨ̀ móndɨ́ pá be àbvò ro dhɨ ɨ́be. Dɨ akódhɨ adré tá àyɨ kɨ tɨdrɨ́ títí. ");
INSERT INTO log_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Móndɨ́ zyandre angábhá Gàlìláyà lésè, bhàandre zìle Mudrí dhɨ ɨ lésè, Yèrúsalémà lésè, Yùdáyà lésè, ɨ̀ndɨ̀ Yòròdánè nɨ taꞌá lésè dhɨ ɨ̀ adré tá akódhɨ nɨ lebè. ");
INSERT INTO log_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Kìtú àlo, Yésu kònò móndɨ́ zyandre adrébhá tá ru kɨmó dhɨ ɨ dre dhɨ, dré mbàzo kòngó àlo drìna gò lɨrɨ́lé. Akódhɨ nɨ lebèbhá ɨ̀ dré àyɨ kɨ kisízó ànyɨ akódhɨ làga gò, ");
INSERT INTO log_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","dré kɨdhózó adrélé àyɨ kɨ tadhá kònɨ̀nɨ: ");
INSERT INTO log_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Kólénzé móndyá adrébhá àyɨ kɨ no lemerè ro àyɨ kɨ togó na dhɨ ɨ dré. Tàko ko, Òpɨ̀ bhù àdhya àyɨkya ꞌɨ! ");
INSERT INTO log_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Kólénzé móndyá adrébhá àwó ngo dhɨ ɨ dré. Tàko ko, Gìká nɨ àyɨ kɨ togó tɨndrɨ̀! ");
INSERT INTO log_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Kólénzé móndyá adrébhá àyɨ kɨ tà bha kìní mi dhɨ ɨ dré. Tàko ko, ɨ̀ nɨ bvò Gìká dré lazílé dhɨ nɨ kisú tàyɨlé ro! ");
INSERT INTO log_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Kólénzé móndyá adrébhá lovó ɨ́be adrézó tà gyǎgya ꞌo dhɨ ɨ dré. Tàko ko, Gìká nɨ tà ɨ̀ dré adrézó lovó nɨ ɨ́be nda nɨ ꞌo kɨtswálé àyɨ dré títí! ");
INSERT INTO log_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Kólénzé móndyá adrébhá àyɨ kɨ àzya kɨ kɨzà bha dhɨ ɨ dré. Tàko ko, Gìká nɨ àyɨ kɨ tàndɨ kɨ kɨzà bha! ");
INSERT INTO log_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Kólénzé móndyá adrébhá togó lólo ɨ́be dhɨ ɨ dré. Tàko ko, ɨ̀ nɨ Gìká nɨ no! ");
INSERT INTO log_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Kólénzé móndyá adrébhá tà kɨ̀drɨ́kɨ̀drɨ bha móndɨ́ ɨ kòfalé dhɨ ɨ dré. Tàko ko, à nɨ àyɨ kɨ zi Gìká nɨ ànzɨ ɨ ró! ");
INSERT INTO log_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Kólénzé móndyá adrélé mì pfòle ɨ̀ dré adrélé tà gyǎgya ꞌo dhɨ sè dhɨ ɨ dré. Tàko ko, Òpɨ̀ bhù àdhya àyɨkya ꞌɨ! ");
INSERT INTO log_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Kólénzé àmɨ dré, à kàdré àmɨ kɨ lodhá, adrézó àmɨ kɨ mì pfo, adrézó tà kònzɨ ta àmɨ rú kɨnzò sè áma tà sè dhɨ. ");
INSERT INTO log_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Mɨ̀ kàdré lenzélé, adrézó arɨ́ ɨ́be tà nda ɨ sè! Tàko ko, làgɨ́ múrúngú adré àmɨ kɨ letè bhù na. À pfo tá kpà pròfétà atú àmɨ kandrá dhɨ kɨ mì kònɨ̀nɨ.» ");
INSERT INTO log_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Yésu gò tàá dhɨ: «Àmɨ tàꞌí bvò kòndɨ àdhya ꞌɨ. Dɨ, tàꞌí nda nɨ aswaaswa kòtɨ̀ akɨ́lé lásà dhɨ, à nɨ kɨtswá logóá ngɨ́nɨ? Tàꞌí nda kɨtswá gòle vélé tà àlo ꞌo ko. À adré kutúá gò, móndɨ́ ɨ̀ dré adrézó atóá àyɨ pálé. ");
INSERT INTO log_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Àmɨ ngádra bvò kòndɨ àdhya ꞌɨ. À kɨtswá bhàandre sìle kòngó drìna dhɨ nɨ zu bwà ko. ");
INSERT INTO log_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","À dhɨ̀ gà kpà tálà bhàle lɨ̀drɨ́ zàna ko na. Be ró dhɨ, à adré dhɨ̀á bhàle zá kuru mɨ́sá drìna gò, dré adrézó ngá kazá móndyá títí adrébhá dzó lé dhɨ ɨ dré. ");
INSERT INTO log_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Dɨ mɨ̀ kàdré kókpà àmɨ kɨ ngádra tayɨ́ adrélé ngá kazá móndɨ́ ɨ kòfalé kònɨ̀nɨ, ɨ̀ kàdréró tà dóro mɨ̀ dré adrélé ꞌòle dhɨ kɨ no, adrézó àmɨ kɨ Atá bhù na dhɨ nɨ rú bha kùle.» ");
INSERT INTO log_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«Lè mɨ̀ kòkisù ko tàle dhɨ, má alɨ̀ kɨtswálé tátrɨ́trɨ́ kúlí Mósè àdhya ɨ̀ndɨ̀ tà pròfétà ɨ̀ dré tɨsɨ̀le dhɨ kɨ pfu dhɨ. Má alɨ̀ tà nda kɨ pfu ko. Be ró dhɨ, má alɨ̀ mána tà nda kɨ ꞌo kɨtswálé títí dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Má adré tà bàti ta àmɨ dré: Tsàle bhù kɨ kùdù bvò be dhɨ na dhɨ, tátrɨ́trɨ́ kúlí nda nɨ wárágà pá mvá tsà dhɨ ꞌɨ yà, kó ngalè tà mvá tsà tɨsɨ̀le lána dhɨ ꞌɨ yà dhɨ kɨtswá tàdzí akɨ́lé ko, tsàle lókyá tà títí nda ɨ̀ dré dra ru ꞌòzo kɨtswálé títí dhɨ ꞌá. ");
INSERT INTO log_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Dɨ ásà dhɨ, dhya ángùdhi adrélépi tà mvá tsà àlo tátrɨ́trɨ́ kúlí nda dré adrélé tàle à kòꞌo dhɨ nɨ ŋo gò, adrézó áyɨ àzya nɨ tadhá adrélé kpà ꞌòá kònɨ̀nɨ dhɨ, à nɨ akódhɨ nda nɨ zi móndɨ́ tàko ró lavúlé móndyá títí Òpɨ̀ bhù àdhya na dhɨ ɨ rúsè. Dɨ, dhya ángùdhi adrélépi tà tátrɨ́trɨ́ kúlí nda dré adrélé tàle à kòꞌo dhɨ kɨ ꞌo gò, adrézó tà nda kɨ tadhá móndɨ́ ɨ dré dhɨ, à nɨ akódhɨ nda nɨ zi móndɨ́ kàdrɨ̀ ro Òpɨ̀ bhù àdhya na. ");
INSERT INTO log_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Dɨ, má adré tàá àmɨ dré dhɨ: Àmɨ kɨ tà gyǎgya kòlavú tátrɨ́trɨ́ kúlí tadhábhá kya Fàrìsáyò kya be ko dhɨ, mɨ̀ kɨtswá tàdzí fɨ̀le Òpɨ̀ bhù àdhya na ko.» ");
INSERT INTO log_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«Mɨ̀ yi tàle dhɨ, à tà tá àma kɨ tábhí ɨ dré dhɨ: ‹Lè mɨ́ kòpfu móndɨ́ dràle ko. Dhya ángùdhi móndɨ́ pfùlepi dràle dhɨ nɨ pfo áyɨ totó tàbvó tàlepi kandrá.› ");
INSERT INTO log_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Dɨ, má adré mána tàá àmɨ dré dhɨ: Dhya ángùdhi áyɨ togó tayɨ́lépi adrélé aswálé áyɨ adrúpi rú dhɨ nɨ pfo tàbvó tàlepi kandrá. Dhya ángùdhi adrélépi áyɨ adrúpi nɨ zi móndɨ́ tàko ró dhɨ nɨ pfo Yúdà ànzɨ kɨ bhàgo kàdrɨ̀ ɨ kandrá. Dhya ángùdhi adrélépi áyɨ adrúpi nɨ zi tɨrɨ́ kɨza líyí ro dhɨ kɨtswá ɨ́na lɨ̀le líferò nɨ àtsɨ́ na. ");
INSERT INTO log_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Dɨ ásà dhɨ, mɨ́ kàdré ꞌòle ngá fe Gìká dré àlètárɨ̀ kandrá gò, tà àmɨ kòfalé ámɨ adrúpi be dhɨ dré agázó mɨ́ léna dhɨ, ");
INSERT INTO log_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","lè mɨ́ kòtayɨ́ ngá mɨ́na nda àlètárɨ̀ kandrá. Mɨ́ kòlɨ̀ rè zyà mɨ̀ dré àmɨ kɨ kòfalé ledézó ámɨ adrúpi nda be ꞌíká, gò mɨ́ kàgòró ngá nda nɨ fe Gìká dré ndò. ");
INSERT INTO log_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Mɨ̀ kàdré lɨ̀le dhya adrélépi ámɨ asíkì dhɨ be tàbvó tǎrà na dhɨ, lè mɨ̀ kòyi ru mbèlè akódhɨ be mɨ̀ dré rè dhu adréràꞌa láti ꞌá dhɨ ꞌá. Mɨ́ kòꞌo kònɨ̀nɨ ko dhɨ, akódhɨ nɨ ámɨ fe tàbvó tàlepi drɨ́gá, tàbvó tàlepi nda dré ámɨ fèzo pòlísì drɨ́gá gò, ámɨ bhèzo bǎdzó na. ");
INSERT INTO log_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Má adré tà bàti ta mɨ́ dré: Mɨ́ kɨtswá apfòle kònalésè ko, tsàle lókyá mɨ́ dré dra màri nda nɨ logózó akɨ́lé títí dhɨ ꞌá.» ");
INSERT INTO log_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«Mɨ̀ yi tàle dhɨ, à tà tá dhɨ: ‹Lè mɨ́ kòꞌo múná tà ko.› ");
INSERT INTO log_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Dɨ, má adré mána tàá àmɨ dré dhɨ: Dhya ángùdhi adrélépi tòkó àlo dhɨ nɨ no gò adrézó rúbhá lovó bha akódhɨ nɨ tà sè dhɨ, ꞌo ɨ́na múná tà tòkó nda be áyɨ togó na dre. ");
INSERT INTO log_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ámɨ mì drɨ́ágó lésè dhɨ kàdré ámɨ ꞌo dhèle tàkonzɨ̀ na nɨ̀ dhɨ, lè mɨ́ kàngɨ́ ámɨ mì nda bhèle mɨ́ rúsè vwàvwà ro. Àngyá ko, mɨ́ dré ngá àlo mɨ́ rú dhɨ nɨ tayɨ́lé abɨ́lé dhɨ dóro lavúlé, ámɨ rúbhá wä́yi dhɨ nɨ bhèle líferò na dhɨ rúsè. ");
INSERT INTO log_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ámɨ drɨ́ágó kàdré kó ámɨ ꞌo dhèle tàkonzɨ̀ na nɨ̀ dhɨ, lè mɨ́ kòli ámɨ drɨ́ágó nda bhèle mɨ́ rúsè vwàvwà ro. Àngyá ko, mɨ́ dré ngá àlo mɨ́ rú dhɨ nɨ tayɨ́lé abɨ́lé dhɨ dóro lavúlé, ámɨ rúbhá wä́yi dhɨ dré lɨ̀le líferò na dhɨ rúsè.» ");
INSERT INTO log_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«Mɨ̀ yi tàle dhɨ, à tà tá dhɨ: ‹Lè dhya adrélépi áyɨ tòkó nɨ le tɨngálé dhɨ kòfè drá wárágà adrélépi tadhá dhɨ, ɨ́ tɨngá akódhɨ dre dhɨ.› ");
INSERT INTO log_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Dɨ, má adré mána tàá àmɨ dré dhɨ: Kàdré ngbà ꞌí ndòtò tà sè ko dhɨ, dhya ángùdhi áyɨ tòkó nɨ tɨngálépi dhɨ ꞌo ɨ́na akódhɨ atsálé tòkó zàràbhù ro dhɨ ró. Kòdhɨ ɨ́be dhɨ, dhya ángùdhi tòkó tɨngálé dre dhɨ nɨ adólépi mòle dhɨ, adré kpà múná tà ꞌo.» ");
INSERT INTO log_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«Mɨ̀ yi kpà tàle dhɨ, à tà tá àma kɨ tábhí ɨ dré dhɨ: ‹Lè mɨ́ kòŋò mòndrà mɨ́ dré sɨ̀le dhɨ ko. Dɨ, mɨ́ kàdré be mòndrà mɨ̀ dré sɨ̀le Mírì kandrá dhɨ kɨ ꞌo títí.› ");
INSERT INTO log_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Dɨ, má adré mána tàá àmɨ dré dhɨ: Lè mɨ̀ kòsɨ̀ mòndrà àlomvá ko. Mɨ̀ kòsɨ̀ mòndrà bhù nɨ rú sè ko. Tàko ko, bhù nda Gìká nɨ lɨrɨ́rà adrézó òpɨ̀ nya dhɨ ꞌɨ. ");
INSERT INTO log_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Mɨ̀ kòsɨ̀ kpà mòndrà bvò nɨ rú sè ko. Tàko ko, bvò nda àrà Gìká dré adrézó áyɨ pá bha drìá dhɨ ꞌɨ. Mɨ̀ kòsɨ̀ kpà mòndrà Yèrúsalémà nɨ rú sè ko. Tàko ko, bhàandre nda bhàandre Ópɨ́ kàdrɨ̀ àdhya ꞌɨ. ");
INSERT INTO log_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Mɨ́ kòsɨ̀ kpà mòndrà ámɨ drì nɨ rú sè ko. Tàko ko, mɨ́ kɨtswá ndɨ̀ndɨ̀ ámɨ drìbhɨ́ àlo dhɨ nɨ ladzá atsálé kini yà, kó ngalè kemve yà dhɨ bwà ko. ");
INSERT INTO log_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Mɨ̀ kàdré dɨ tà kaꞌì ꞌòle dhɨ, mɨ̀ kòtà ngbà ꞌí ‹Àyíya› kòdhya. Mɨ̀ kàdré tà kaꞌì ꞌòle ko dhɨ, mɨ̀ kòtà ngbà ꞌí ‹Kóko› kòdhya. Tà àzya kɨtswálé bhàle kúlí nda ɨ dri dhɨ, adré ɨ́na angálé Dhya kònzɨ vélésè.» ");
INSERT INTO log_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","«Mɨ̀ yi tàle dhɨ, à tà tá dhɨ: ‹Mì kɨ ru kisú mì be. Sí kɨ kpà ru kisú sí be.› ");
INSERT INTO log_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Dɨ, má adré mána tàá àmɨ dré dhɨ: Dhya àlo kòꞌo tà kònzɨ àmɨ rú dhɨ, mɨ̀ kògò lɨgɨ́lé akódhɨ rú ko. Be ró dhɨ, dhya àlo kòsa ámɨ kóbhólé drɨ́ágó lésè dhɨ dhɨ, mɨ́ kògò mɨ́na àzya nɨ nɨ alá akódhɨ dré kpà sàle. ");
INSERT INTO log_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Dhya àlo kòlè ámɨ drìle tàbvó tàlepi kandrá ámɨ kɨ́tá agá lésè dhɨ nɨ dòzo dhɨ, mɨ́ kòtayɨ́ kpà akódhɨ ámɨ kɨ́tá kɨdhɨ̀ àdhya nɨ do. ");
INSERT INTO log_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Dhya àlo kòru mɨ ꞌòle atsí to ɨ́ be kìlòméterè àlo dhɨ, mɨ̀ kòlɨ̀ túmä́ní akódhɨ be kìlòméterè rì. ");
INSERT INTO log_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mɨ́ kàdré ngá fe dhya ángùdhi adrélépi ngá zi mɨ́ tí dhɨ dré. Dhya àlo kàdré ngá le zìle mɨ́ tí màri ró dhɨ, mɨ́ kògà ngá nda nɨ fèma drá dhɨ ko.» ");
INSERT INTO log_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«Mɨ̀ yi tàle dhɨ, à tà tá dhɨ: ‹Lè mɨ́ kàdré ámɨ àzya nɨ le, adrézó ámɨ kàrɨbhá nɨ ga.› ");
INSERT INTO log_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Dɨ, má adré mána tàá àmɨ dré dhɨ: Lè mɨ̀ kàdré àmɨ kɨ kàrɨbhá kɨ le. Mɨ̀ kàdré kpà tà zi Gìká tí móndyá adrébhá àmɨ kɨ mì pfo dhɨ ɨ dré. ");
INSERT INTO log_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Mɨ̀ kàdré ꞌòá kònɨ̀nɨ dhɨ, mɨ̀ nɨ adré àmɨ kɨ Atá bhù na dhɨ nɨ ànzɨ ɨ ró. Tàko ko, akódhɨ adré kìtú ꞌo kàle móndɨ́ kònzɨ ɨ dri, ɨ̀ndɨ̀ móndɨ́ dóro ɨ dri. Adré kpà kozya ꞌo dhìle móndɨ́ gyǎgya ɨ dri, ɨ̀ndɨ̀ móndɨ́ gyǎgya ko dhɨ ɨ dri. ");
INSERT INTO log_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Mɨ̀ kàdré ngbà ꞌí móndyá adrébhá àmɨ kɨ le dhɨ kɨ le kòdhya dhɨ, mɨ̀ nɨ àdho làgɨ́ kisú ásà? Ndɨ̀ndɨ̀ mèdáyɨ̀ lagɨ́bhá ɨ̀ adré ꞌòá kònɨ̀nɨ. ");
INSERT INTO log_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Mɨ̀ kàdré ngbà ꞌí mòdo fe àmɨ kɨ adrúpi ɨ dré dhɨ, mɨ̀ adré àdho tà dóro ꞌo móndɨ́ àruka kya kɨ lavú? Ndɨ̀ndɨ̀ pàgánò ɨ̀ adré ꞌòá kònɨ̀nɨ. ");
INSERT INTO log_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Adré dɨ lèá dhɨ, mɨ̀ kàdré móndɨ́ dóro kɨtswálé títí dhɨ ɨ ró, ngóró àmɨ kɨ Atá bhù na dhɨ dré adrélé dóro kɨtswálé títí dhɨ tɨ́nɨ.» ");
INSERT INTO log_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yésu gò tàá dhɨ: «Mɨ̀ kònò dóro, mɨ̀ kàdréró ngbà ꞌí àmɨ kɨ tà gyǎgya kɨ ꞌo móndɨ́ ɨ mi, ɨ̀ kàdréró àmɨ kɨ no dhɨ ko. Tàko ko, mɨ̀ kàdré ꞌòá kònɨ̀nɨ dhɨ, mɨ̀ kɨtswá àmɨkya làgɨ́ kisú àmɨ kɨ Atá bhù na dhɨ vélésè ko. ");
INSERT INTO log_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Mɨ́ kàdré dɨ ngá fe lemerèbhá ɨ dré dhɨ, lè mɨ́ kòyo tà nda drìdrì ngóró túrúpfúbhá ɨ̀ dré adrélé ꞌòle dhɨ tɨ́nɨ ko. Tàko ko, àyɨ nda ɨ̀ adré gòká vo Yúdà ànzɨ kɨ lɨ̀sámbò dzó ɨ ꞌásè ɨ̀ndɨ̀ láti ɨ ꞌásè, móndɨ́ ɨ̀ kàdréró àyɨ kɨ tà bha kuru ngá ɨ̀ dré adrélé fèle dhɨ kɨ tà sè. Má adré tà bàti ta àmɨ dré: Ɨ̀ kisú àyɨkya làgɨ́ wä́yi ɨ̀ dré kɨtswálé kisúlé dhɨ dre. ");
INSERT INTO log_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Dɨ, mɨ ró dhɨ, mɨ́ kàdré ngá fe lemerèbhá ɨ dré dhɨ, mɨ́ kòtayɨ́ ámɨ lìdzí tà ámɨ drɨ́ágó dré adrélé ꞌòle dhɨ nɨ ni ko. ");
INSERT INTO log_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Be ró dhɨ, mɨ́ kàdré mɨ́na ámɨ ngá fe lùzu ró. Dɨ ámɨ Atá adrélépi tà adrélé ꞌòle lùzu ró dhɨ kɨ no dhɨ nɨ làgɨ́ múrúngú fe mɨ́ dré.» ");
INSERT INTO log_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«Mɨ̀ kàdré tà zi Gìká tí dhɨ, mɨ̀ kòꞌo túrúpfúbhá kya tɨ́nɨ ko. Tàko ko, àyɨ nda ɨ̀ adré tà le zìle Gìká tí ɨ̀ dré adréràꞌa àyɨ kɨ totó kuru lɨ̀sámbò dzó ɨ ꞌásè ɨ̀ndɨ̀ láti andre ɨ ꞌásè dhɨ ꞌá, móndɨ́ ɨ̀ kàdréró àyɨ kɨ no be dhɨ bvó. Má adré tà bàti ta àmɨ dré: Ɨ̀ kisú àyɨkya làgɨ́ wä́yi ɨ̀ dré kɨtswálé kisúlé dhɨ dre. ");
INSERT INTO log_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Dɨ, mɨ ró dhɨ, mɨ́ kàdré tà le zìle Gìká tí dhɨ, mɨ́ kòfɨ kalóma dzómvá na, dzóti asé mɨ́ vélé gò, adrézó tà zi ámɨ Atá tí lùzu ró. Dɨ ámɨ Atá adrélépi tà adrélé ꞌòle lùzu ró dhɨ kɨ no nda nɨ làgɨ́ múrúngú fe mɨ́ dré. ");
INSERT INTO log_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Mɨ̀ dré adréràꞌa tà zi Gìká tí dhɨ ꞌá dhɨ, mɨ̀ kàdré tà àlo ta rä pàgánò kya tɨ́nɨ ko. Àngyá ko, àyɨ nda ɨ̀ adré kisùá dhɨ, ɨ̀ kàdré kúlí ta bǐ dhɨ, Gìká nɨ àyɨ kɨ yi. ");
INSERT INTO log_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Dɨ mɨ̀ kòꞌo tà àyɨkya tɨ́nɨ ko. Tàko ko, àmɨ kɨ Atá nì tà mɨ̀ dré adrélé lèle zìle dhɨ ɨ drìdrì, mɨ̀ dré tà nda kɨ ziràꞌa tíá ko dhɨ ꞌá. ");
INSERT INTO log_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Dɨ ásà dhɨ, mɨ̀ kàdré tà zi Gìká tí kònɨ̀nɨ: ‹Àma kɨ Atá bhù na dhɨ, lè móndyá wä́yi dhɨ ɨ̀ kònì dhɨ, mɨ Gìká lólo ꞌɨ dhɨ be. ");
INSERT INTO log_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ámɨ Òpɨ̀ kàtsá móndyá wä́yi ɨ kòfalé wà. Tà mɨ́ dré adrélé lèle ꞌòle dhɨ ɨ̀ kòꞌo ru kònwa bvò dri, ngóró dré adrélé ꞌòle bhù na dhɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Mɨ́ kàfè àma dré mápà kɨtswálépi àma sè kìtú ándrò kònɨ̀dhɨ sè dhɨ wà. ");
INSERT INTO log_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Mɨ́ kòtrì àma kɨ tàkonzɨ̀ ɨ, ngóró mà dré kpà adrélé móndyá tàkonzɨ̀ ꞌobhá àma rú dhɨ kya kɨ tri dhɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Mɨ́ kòtayɨ́ àma tà dré tabhìle, àma kɨ ꞌòzo dhèle tàkonzɨ̀ na dhɨ ko. Be ró dhɨ, mɨ̀ kàpá àma Dhya kònzɨ drɨ́gásè.› ");
INSERT INTO log_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Mɨ̀ kàdré móndyá tàkonzɨ̀ ꞌobhá àmɨ rú dhɨ kɨ tàkonzɨ̀ tri dhɨ, àmɨ kɨ Atá bhù na dhɨ nɨ kókpà àmɨ kɨ tàkonzɨ̀ tri. ");
INSERT INTO log_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Dɨ, mɨ̀ kàdré àmɨkya móndɨ́ kɨ tàkonzɨ̀ tri ko dhɨ, àmɨ kɨ Atá kɨtswá kpà àmɨ kɨ tàkonzɨ̀ tri ko.» ");
INSERT INTO log_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«Mɨ̀ kàdré tàbirí mvo adrézó tà zi Gìká tí dhɨ, mɨ̀ kòtayɨ́ àmɨ kɨ mìbhalé adrélé kɨzà ro túrúpfúbhá kya tɨ́nɨ dhɨ ko. Àngyá ko, àyɨ nda ɨ̀ adré àyɨ kɨ mìbhalé ladzá atsálé kɨzà ro tadházóá móndɨ́ ɨ dré dhɨ, ɨ̀ adré tàbirí mvo. Má adré tà bàti ta àmɨ dré: Ɨ̀ kisú àyɨkya làgɨ́ wä́yi ɨ̀ dré kɨtswálé kisúlé dhɨ dre. ");
INSERT INTO log_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Dɨ, mɨ ró dhɨ, mɨ́ dré adréràꞌa tàbirí mvo dhɨ ꞌá dhɨ, mɨ́ kàdré ámɨ mìbhalé dzɨ, adrézó kpà dò da mɨ́ dri, ");
INSERT INTO log_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","dhya àlo kònìró ko tàle dhɨ, mɨ́ adré tàbirí mvo dhɨ. Ngbà ꞌí ámɨ Atá adrélépi tà adrélé ꞌòle lùzu ró dhɨ kɨ ni dhɨ nɨ nìá nɨ̀. Dɨ ámɨ Atá adrélépi tà lùzu ró nda kɨ no nda nɨ làgɨ́ múrúngú fe mɨ́ dré.» ");
INSERT INTO log_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«Lè mɨ̀ kòndà ngá làgɨ́ be kàdrɨ̀ dhɨ ɨ lokólé àmɨ dré kònwa bvò dri ko. Tàko ko, bvò kònɨ̀dhɨ àrà órò dré adrézó ngá si, kɨ̀ndrɨ̀ dré adrézó ngá mbe, ɨ̀ndɨ̀ kùgú ɨ̀ dré adrézó fɨ̀le ngá kugù dhɨ ꞌɨ. ");
INSERT INTO log_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Dɨ, mɨ̀ kàdré àmɨkya ngá làgɨ́ be kàdrɨ̀ dhɨ kɨ nda lokólé àmɨ dré bhù na. Kònàle dhɨ, órò sì ngá ko na, kɨ̀ndrɨ̀ mbe ngá ko na, kùgú ɨ̀ fɨ kpà ngá kugù ko na. ");
INSERT INTO log_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Tàko ko, àrà ángùdhi àmɨ kɨ ngá làgɨ́ be kàdrɨ̀ dhɨ ɨ̀ dré adrézó lána dhɨ na dhɨ, àmɨ kɨ togó nɨ adré kókpà kònàle.» ");
INSERT INTO log_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«Dhyá kɨ mì tálà adrélépi ngádra fe rúbhá dré dhɨ ꞌɨ. Ámɨ mì kàdré dóro dhɨ, ámɨ rúbhá wä́yi dhɨ nɨ adré ngádra ꞌá. ");
INSERT INTO log_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Dɨ, ámɨ mì kàdré drà ro dhɨ, ámɨ rúbhá wä́yi dhɨ nɨ ɨ́na adré tínímvá na. Dɨ ngádra adrélépi mɨ́ léna dhɨ kàdré ɨ́na tínímvá ro dhɨ, tínímvá nda nɨ adré kàdrɨ̀ lavúlé!» ");
INSERT INTO log_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«Dhya àlo kɨtswá mírì rì dhɨ kɨ tà ꞌo lókyá àlo sè bwà ko. Tàko ko, kàdré ꞌòá kònɨ̀nɨ dhɨ, a nɨ àlo nɨ nɨ ga, adrézó àzya nɨ nɨ le. Kó ngalè, a nɨ tro àlo nɨ rú, adrézó àzya nɨ nɨ ayɨ́zè. Dɨ mɨ̀ kɨtswá adrélé Gìká nɨ tà ꞌo, adrézó kpà làfa nɨ tà ꞌo àyɨ kɨ màrábà tɨ́nɨ lókyá àlo sè bwà ko.» ");
INSERT INTO log_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«Dɨ ásà dhɨ, má adré tàá ámɨ dré dhɨ: Mɨ̀ kòbhà àmɨ kɨ togó adrélé lanzìle àmɨ kɨ lɨ́drɨ̀ nɨ tà sè ko, ngalè mɨ̀ nɨ dra àdho ngá nya ya, kó ngalè mɨ̀ nɨ dra àdho ngá mvu ya dhɨ. Mɨ̀ kòbhà kpà àmɨ kɨ togó adrélé lanzìle àmɨ kɨ rúbhá nɨ tà sè ko, ngalè mɨ̀ nɨ dra àdho asó àmɨ rú ya dhɨ. Àmɨ kɨ lɨ́drɨ̀ lavú tsì mányàngá ko? Àmɨ kɨ rúbhá lavú tsì kɨ́tá ko? ");
INSERT INTO log_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Mɨ̀ nò rè àrɨ́ ɨ ká. Ɨ̀ kidhí ngá ko na, ɨ̀ akónà ngá ko na, ɨ̀ lokó kpà ngá kòbhó na ko na. Dɨ, àmɨ kɨ Atá bhù na dhɨ adré ɨ́na ngá fe àyɨ dré tèle. Dɨ àmɨ kɨ tà lavú tsì àrɨ́ kya ko? ");
INSERT INTO log_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Àmɨ kòfalé dhɨ, àdhi nɨ kɨtswá áyɨ lɨ́drɨ̀ nɨ lókyá nɨ drì tɨmbà tsà, dré adrélé áyɨ togó bha lanzìle dhɨ sè bwà dhɨ nɨ̀? ");
INSERT INTO log_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Mɨ̀ adré kpà àmɨ kɨ togó bha lanzìle kɨ́tá nɨ tà sè àdho tà sè? Mɨ̀ nò rè ngalè pfò mbɨ̀ na dhɨ ɨ̀ adré topfòle ngɨ́nɨ ya dhɨ ká. Ɨ̀ ꞌo àzí ko na. Ɨ̀ ledé kpà kɨ́tá ko na. ");
INSERT INTO log_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Dɨ, má adré mána tàá àmɨ dré dhɨ: Ndɨ̀ndɨ̀ ópɨ́ Sòlòmónò rúku nɨ ɨ́be títí dhɨ asó tá kɨ́tá aveave pfò nda kɨ àlo àdhya tɨ́nɨ dhɨ ko. ");
INSERT INTO log_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Gìká kàdré kó mbɨ̀ adrélépi ándrò kònwa gò kìdru dra bhèzoá àtsɨ́ na dhɨ kɨ tosó kònɨ̀nɨ be dhɨ, a nɨ dɨ vélé àmɨ kɨ tosó dóro àyɨ kɨ lavú ngɨ́nɨ? Àmɨ àmɨkya móndɨ́ tà kaꞌìkaꞌì ɨ́be tsà dhɨ ꞌɨ! ");
INSERT INTO log_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Mɨ̀ kòbhà dɨ àmɨ kɨ togó adrélé lanzìle, adrézó tàá dhɨ ‹Mà nɨ dra àdho ngá nya?› ya, ‹Mà nɨ dra àdho ngá mvu?› ya, kó ngalè ‹Mà nɨ dra àdho asó?› ya dhɨ ko. ");
INSERT INTO log_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Tàko ko, pàgánò ɨ̀ adré àyɨkya ngá títí nda kɨ nda kòdhya landè àko ró. Àmɨ kɨ Atá bhù na dhɨ nì kpà tàle dhɨ, àmɨ lovó ɨ́be ngá nda kɨ kisúzó dhɨ be. ");
INSERT INTO log_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Dɨ mɨ̀ kàdré rè zyà Gìká nɨ Òpɨ̀ nda akódhɨ nɨ tà gyǎgya ɨ́be ꞌíká, gò akódhɨ kòtɨmbàró kpà ngá nda ɨ títí àmɨ dré ndò. ");
INSERT INTO log_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Dɨ ásà dhɨ, mɨ̀ kòbhà àmɨ kɨ togó adrélé lanzìle tà adrébhá alɨ̀le kìdru dhɨ kɨ tà sè dhɨ ko. Àngyá ko, tà kìdru àdhya kɨ kɨtswá kìtú kìdru nda sè. Kìtú àlo àlo títí dhɨ kɨ kɨzà kɨtswá kìtú nda sè.» ");
INSERT INTO log_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Yésu gò tàá dhɨ: «Mɨ̀ kàdré móndɨ́ kɨ tàbvó ta ko, Gìká kòtàró kpà àmɨ kɨ tàbvó ko dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Tàko ko, Gìká nɨ àmɨ kɨ tàbvó ta ngóró mɨ̀ dré adrélé móndɨ́ kɨ tàbvó ta dhɨ tɨ́nɨ. A nɨ kpà àmɨ kɨ tà tabhì ngóró mɨ̀ dré adrélé móndɨ́ kɨ tà tabhì dhɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Mɨ́ adré mɨ́na kayísá kórònyá mvá ámɨ adrúpi mìna dhɨ nɨ no gò, adrézó fa gú mɨ́ mìna dhɨ nɨ atógyà ko àdho tà sè? ");
INSERT INTO log_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Mɨ́ adré ámɨ ꞌo ngɨ́nɨ tàá ámɨ adrúpi dré dhɨ ‹Mɨ́ ꞌo má kàpèró kayísá kórònyá mvá mɨ́ mìlésè› dhɨ, tákò fa gú dré adréràꞌa ámɨ tàndɨ mìna dhɨ ꞌá dhɨ? ");
INSERT INTO log_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Mɨ túrúpfú líyí ꞌɨ! Mɨ́ kàpè rè zyà fa gú nda mɨ́ mìlésè ꞌíká, gò mɨ́ kògòró ngá no dra kɨtswázó kayísá kórònyá mvá nda nɨ apè ámɨ adrúpi mìlésè ndò.» ");
INSERT INTO log_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","«Mɨ̀ kòfè tà lólo kòkɨ́ ɨ dré ko, ɨ̀ kògòró àyɨ kɨ alá àmɨ kɨ tɨtsɨ́ ko sè. Mɨ̀ kòbhe àmɨ kɨ màyɨ̀kà aveave dhɨ ɨ tɨ̀gá ɨ kandrá ko, ɨ̀ kàtóró àyɨ pálé ko sè.» ");
INSERT INTO log_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«Mɨ̀ kàdré tà zi Gìká tí gò, kòꞌoró tà nda àmɨ dré. Mɨ̀ kàdré ngá nda gò, mɨ̀ kòkisúró. Mɨ̀ kàdré dzóti ga gò, à kònzìró àmɨ dré. ");
INSERT INTO log_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Tàko ko, dhya ángùdhi adrélépi tà zi Gìká tí dhɨ adré kisúá. Dhya adrélépi ngá nda dhɨ adré kisúá. Dhya adrélépi dzóti ga dhɨ dré dhɨ, à adré kpà nzìá. ");
INSERT INTO log_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Àmɨ ànzɨ kɨ atá ro nɨ ɨ, àmɨ kɨ mvá kàdré mápà zi àmɨ tí dhɨ, mɨ̀ nɨ tsì kɨ́rà fe drá kòdhya? ");
INSERT INTO log_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Àmɨ kɨ mvá kàdré kosyá zi àmɨ tí dhɨ, mɨ̀ nɨ tsì nì fe drá kòdhya? ");
INSERT INTO log_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Dɨ àmɨ móndɨ́ kònzɨ ró nɨ ɨ, mɨ̀ kònì adrélé ngá dóro fe àmɨ kɨ ànzɨmvá ɨ dré dhɨ be dhɨ, àmɨ kɨ Atá bhù na dhɨ nɨ ngá dóro fe dhya adrébhá zìá ɨ́ tí dhɨ ɨ dré tà tàndɨ ró!» ");
INSERT INTO log_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","«Dɨ tà títí ɨ sè dhɨ, mɨ̀ kàdré tà ꞌo móndɨ́ ɨ dré ngóró mɨ̀ dré adrélé lèle ɨ̀ kòꞌo àmɨ dré dhɨ tɨ́nɨ. Tàko ko, mɨ̀ kàdré ꞌòá kònɨ̀nɨ dhɨ, mɨ̀ adré tà títí Mósè nɨ tátrɨ́trɨ́ kúlí ɨ̀ndɨ̀ pròfétà ɨ̀ dré adrélé tàle à kòꞌo dhɨ kɨ ꞌo kòdhya.» ");
INSERT INTO log_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«Mɨ̀ kòlavú dzóti wàlepi ko dhɨ ꞌásè fɨ̀le Gìká nɨ Òpɨ̀ na. Tàko ko, dzóti adrézó fɨ̀le ꞌásà ɨ̀ndɨ̀ láti adrézó lavúlé ꞌásà lɨ̀le dràdrà kisú dhɨ wawà. Móndɨ́ zyandre dhɨ ɨ̀ adré fɨ̀le dzóti wawà nda ꞌásè dhɨ àyɨ. ");
INSERT INTO log_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Dɨ, dzóti adrézó fɨ̀le ꞌásà ɨ̀ndɨ̀ láti adrézó lavúlé ꞌásà lɨ̀le lɨ́drɨ̀ kisú dhɨ wa ɨ́na ko. Ngbà ꞌí móndɨ́ àlo àlo dhɨ ɨ̀ adré dzóti nda nɨ kisú àyɨ.» ");
INSERT INTO log_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«Mɨ̀ kàdré àmɨ kɨ lɨkɨ́ pròfétà kɨnzò ro dhɨ kɨ tà sè. Àngyá ko, àyɨ nda ɨ̀ adré àyɨ kɨ ladzá alɨ̀le àmɨ vélé ngóró kábilígyà ɨ tɨ́nɨ. Tákò àyɨ léna dhɨ, àyɨ kàlagɨ́ àtrá ꞌɨ. ");
INSERT INTO log_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mɨ̀ nɨ kɨtswá àyɨ kɨ ni lòꞌwa ɨ̀ dré adrélé ꞌàle dhɨ ɨ sè. À adré tsì vínò lòꞌwa kɨ kùtsí sílé ꞌí? À adré kó fígì lòꞌwa kɨ áyɨ̀dhá sílé ꞌí? Tàdzí ko. ");
INSERT INTO log_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Fa dóro títí dhɨ ɨ̀ adré lòꞌwa dóro ꞌa kòdhya. Dɨ, fa kònzɨ ɨ̀ adré àyɨkya lòꞌwa kònzɨ ꞌa kòdhya. ");
INSERT INTO log_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Fa dóro kɨtswá lòꞌwa kònzɨ ꞌa bwà ko. Fa kònzɨ kɨtswá kpà lòꞌwa dóro ꞌa bwà ko. ");
INSERT INTO log_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Fa títí adrébhá lòꞌwa dóro ꞌa ko dhɨ ɨ, à adré togá lebhélé àtsɨ́ na. ");
INSERT INTO log_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Dɨ ngóró mɨ̀ dré adrélé fa kɨ ni lòꞌwa ɨ̀ dré adrélé ꞌàle dhɨ ɨ sè dhɨ tɨ́nɨ dhɨ, mɨ̀ nɨ kókpà pròfétà kɨnzò ro dhɨ kɨ ni, tà ɨ̀ dré adrélé ꞌòle dhɨ ɨ sè. ");
INSERT INTO log_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Móndyá títí adrébhá áma zi ‹Mírì, Mírì!› dhɨ ɨ̀ kɨtswá fɨ̀le Òpɨ̀ bhù àdhya na ko. Ngbà ꞌí àyɨ adrébhá tà áma Atá bhù na dhɨ dré adrélé lèle à kòꞌo dhɨ kɨ ꞌo dhɨ kɨ fɨ lána àyɨ. ");
INSERT INTO log_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Kìtú tàbvó tàzo dhɨ tú dhɨ, móndɨ́ bǐ dhɨ kɨ tàá má dré dhɨ: ‹Mírì, Mírì, mà longó tá tsì ámɨ kúlí pròfétà kya tɨ́nɨ ámɨ rú sè ko? Mà dro tá tsì tɨrɨ́ kònzɨ ɨ ámɨ rú sè ko? Mà ꞌo tá tsì tà lɨ́ndrɨ́ga ró bǐ dhɨ ɨ ámɨ rú sè ko?› ");
INSERT INTO log_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Dɨ, má nɨ go tàá àyɨ dré dhɨ: ‹Má nì àmɨ tàdzí ko! Àmɨ tà kònzɨ ꞌobhá nɨ ɨ, mɨ̀ nga má mìlésè!›» ");
INSERT INTO log_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«Dɨ dhya ángùdhi adrélépi áma kúlí kòdhɨ kɨ yi gò adrézó kaꞌìá ꞌòle dhɨ, sù ngóró agó tògya ró áyɨ dzó sìlepi kɨ́rà dri dhɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Kozya dré dhìzo, yǐ dré tìzo gò, lyǎ dré dzó nda nɨ vìzo dhɨ, dzó nda dré arɨ́zó ko, pá nɨ nɨ bhàle kɨ́rà dri dhɨ sè. ");
INSERT INTO log_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Dɨ, dhya ángùdhi adrélépi áma kúlí kòdhɨ kɨ yi gò adrézó kaꞌìá ꞌòle ko dhɨ, sù ngóró agó azaaza áyɨ dzó sìlepi sɨ́nyɨ́ dri dhɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Dɨ kozya dré dhìzo, yǐ dré tìzo gò, lyǎ dré dzó nda nɨ vìzo dhɨ, dzó nda dré arɨ́zó akɨ́lé nyɨ̌nyɨ.» ");
INSERT INTO log_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yésu kòtà tà nda ɨ akɨ́lé dre dhɨ, móndyá zyandre ɨ̀ dré adrézó vélé síbhálé be ngbo tà dré tadhálé nda kɨ tà sè. ");
INSERT INTO log_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Tàko ko, akódhɨ nɨ kúlí ɨ tá lanzìlanzì ro. Adré tá ɨ́na àyɨ kɨ tadhá ngóró àyɨ kɨ tátrɨ́trɨ́ kúlí tadhábhá kya tɨ́nɨ ko. ");
INSERT INTO log_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yésu kàsí kòngó nda drìlésè dre dhɨ, móndɨ́ zyandre lavúlé dhɨ ɨ̀ dré ngàzo adrélé akódhɨ nɨ lebè. ");
INSERT INTO log_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Dɨ agó àlo kàrɨ́ dré rùle dhɨ dré alɨ̀zo adhélé áyɨ kórókó titì Yésu kandrá, tàzoá drá dhɨ: «Mírì, mɨ rìnyí ɨ́be kɨtswázó áma temvé tɨdrɨ́lé, mɨ́ kòlè dhɨ.» ");
INSERT INTO log_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Dɨ Yésu dré áyɨ drɨ́gá kɨdzɨ̀zo akódhɨ nɨ tabè gò, tàzoá drá dhɨ: «Má lè ꞌí. Mɨ́ kàdré kemve kpɨ́rɨ́kpɨ́rɨ́ wà!» Gbǎ kòdhwa, agó nda dré adrɨ́zó kàrɨ́ drà nda lésè. ");
INSERT INTO log_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Gò Yésu dré tàzoá drá dhɨ: «Mɨ́ kònò dóro, mɨ́ kòlongóró tà kòdhɨ dhya àlo dré ko. Be ró dhɨ, mɨ́ lɨ̀ mɨ́na ámɨ tadhá kòwánà dré nòle, ɨ̀ndɨ̀ mɨ́ fè ngá Gìká dré ngóró Mósè nɨ tátrɨ́trɨ́ kúlí dré adrélé tàle dhɨ tɨ́nɨ, tadházóá móndɨ́ ɨ dré dhɨ, mɨ́ adrɨ́ dre káyà dhɨ.» ");
INSERT INTO log_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yésu kògò tsàle Kàpàrànàwúmà na dre dhɨ, Rómà kɨ sòdá kɨ kàdrɨ̀ àlo dhɨ dré áyɨ kisízó ànyɨ akódhɨ làga, akódhɨ nɨ ti lizí ");
INSERT INTO log_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","tàzoá dhɨ: «Mírì, áma màrábà adré ayílé drà be bhà na. Akódhɨ nɨ pá àbvò ro, ɨ̀ndɨ̀ rúbhá nɨ adré aswálé tò.» ");
INSERT INTO log_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yésu tà drá dhɨ: «Má nɨ lɨ akódhɨ nɨ tɨdrɨ́.» ");
INSERT INTO log_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Dɨ, sòdá kɨ kàdrɨ̀ nda logó drá dhɨ: «Mírì, má kɨtswá mána ámɨ lɨndrɨ̀ sè ko. Má kɨtswá ndɨ̀ndɨ̀ mɨ́ dré fɨ̀zo áma dzó na dhɨ ko. Dɨ, mɨ́ kòtà ndɨrɨ kúlí àlo gò, áma màrábà nda kàdrɨ́ró. ");
INSERT INTO log_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Tàko ko, áma tàndɨ, ma áma kàdrɨ̀ kɨ rìnyí zàle. Ma kpà sòdá ɨ́be má zàle. Má kàdré tàá àyɨ kɨ àlo dré dhɨ ‹Mɨ́ lɨ̀!› dhɨ, adré lɨ̀le. Má kàdré tàá àzya nɨ dré dhɨ ‹Mɨ́ alɨ̀!› dhɨ, adré alɨ̀le. Má kàdré kó tàá áma màrábà dré dhɨ ‹Mɨ́ ꞌo tà kòdhɨ!› dhɨ, adré ꞌòá.» ");
INSERT INTO log_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Dɨ Yésu kòyi tà nda dre dhɨ, akódhɨ nɨ lɨ́ndrɨ́ dré gàzo. Dré áyɨ alázó tàá móndyá adrébhá áyɨ lebè dhɨ ɨ dré dhɨ: «Má adré tà bàti ta àmɨ dré: Má kisú rè dhya àlo adrélépi tà kaꞌìkaꞌì ɨ́be kònɨ̀nɨ dhɨ Ɨ̀sèrélè ànzɨ ɨ kòfalé ko. ");
INSERT INTO log_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Má adré tàá àmɨ dré dhɨ: Móndɨ́ zyandre dhɨ kɨ angá kìtú dré apfǒrà lésè ɨ̀ndɨ̀ kìtú dré ndǐrà lésè, lɨrɨ́lé mɨ́sá làgásè túmä́ní Àbàrámà ɨ́be, Ɨ̀sákà be, ɨ̀ndɨ̀ Yàkóbhò be Òpɨ̀ bhù àdhya na. ");
INSERT INTO log_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Dɨ, kàdré móndyá kɨtswábhá tá fɨ̀le Òpɨ̀ nda na dhɨ kɨ tà sè dhɨ, à nɨ àyɨ kɨ bhe kɨvɨ̀ na, àrà tínímvá ro dhɨ na. Kònàle dhɨ, à nɨ adré tongólé, adrézó kpà síkálándrá tsɨ.» ");
INSERT INTO log_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Gò Yésu dré tàzoá sòdá kɨ kàdrɨ̀ nda dré dhɨ: «Mɨ́ nzɨ mɨ́ bhàna. Tà nda kòꞌo ru mɨ́ dré ngóró mɨ́ dré adrélé kaꞌìle dhɨ tɨ́nɨ!» Dɨ akódhɨ nɨ màrábà nda dré adrɨ́zó gbǎ lókyá nda sè. ");
INSERT INTO log_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Àmvolásà dhɨ, Yésu dré lɨ̀zo Pétèró nɨ dzó na gò, akódhɨ nɨ àdrá nɨ kisú lángá na, rúbhá nɨ dré tá adrélé àtsɨ ró dhɨ sè. ");
INSERT INTO log_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Dɨ Yésu dré tòkó nda nɨ drɨ́gá tabèzo gò, rúbhá àtsɨ́ nda dré pfòzo rúásà. Gò tòkó nda dré ngàzo kɨdhólé ngá fe Yésu dré nyàle. ");
INSERT INTO log_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ɨ̀ndró kàndrɨ̀ dre dhɨ, à dré móndɨ́ bǐ tɨrɨ́ kònzɨ ɨ́be àyɨ léna dhɨ kɨ adzízó Yésu vélé. Dɨ akódhɨ dré tɨrɨ́ kònzɨ nda kɨ dròzo topfòle àyɨ lésè kúlí sè. Dré kpà móndɨ́ drà ɨ́be dhɨ kɨ tɨdrɨ́zó títí. ");
INSERT INTO log_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Dɨ tà longólé pròfétà Èsáyà tí dhɨ dré ru ꞌòzo kònɨ̀nɨ. Longó tá dhɨ: «Akódhɨ nɨ tàndɨ do àma kɨ tà yàyà dhɨ ɨ, àma kɨ drà kɨ dòzo kpà ɨ́ rú.» ");
INSERT INTO log_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yésu kònò móndɨ́ zyandre ru kɨmóbhá ɨ́ làgásè kúrú dhɨ ɨ dre dhɨ, dré tàzoá áyɨ lebèbhá ɨ dré dhɨ, ɨ̀ kòzya tä́pä́ríandre nɨ taꞌá na. ");
INSERT INTO log_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Gò tátrɨ́trɨ́ kúlí tadhábhá kɨ àlo dré áyɨ kisízó ànyɨ akódhɨ làga, tàá drá dhɨ: «Tadhálépi, má nɨ ámɨ lebè àrà títí ángùdhi mɨ́ dré adrézó lɨ̀le dhɨ ɨ ꞌásè.» ");
INSERT INTO log_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yésu logó drá dhɨ: «Kɨ̀lɨ̀wá ɨ àyɨ kɨ bhú ɨ́be. Àrɨ́ ɨ kpà àyɨ kɨ bhà ɨ́be. Dɨ, Móndɨ́ nɨ Mvá ɨ́na àrà ɨ́ dré kɨtswázó áyɨ drì la lovózó dhɨ àko.» ");
INSERT INTO log_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Go Yésu nɨ lebèlepi àzya dhɨ dré tàzoá drá dhɨ: «Mírì, mɨ́ kòtayɨ́ rè zyà ma lɨ̀le áma atá nɨ si ꞌíká.» ");
INSERT INTO log_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Dɨ, Yésu logó drá dhɨ: «Mɨ́ lebè ma! Mɨ́ tayɨ́ móndɨ́ dràbhá dre dhɨ ɨ àyɨ kɨ àbvò kɨ si.» ");
INSERT INTO log_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yésu ɨ̀ dré tombàzo bwátù na lebèbhá nɨ ɨ́be gò, ɨ̀ dré kɨdhózó adrélé zyàle tä́pä́ríandre nɨ taꞌá na. ");
INSERT INTO log_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Gbǎ kòdhwa, kàgùmá dré ngàzo adrélé vìle tä́pä́ríandre nda mi gò, yǐ adrélépi longálé dhɨ dré adrézó lodàle bwátù na. Dɨ, Yésu adré tá ɨ́na ayí ko. ");
INSERT INTO log_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Gò akódhɨ nɨ lebèbhá ɨ̀ dré àyɨ kɨ kisízó ànyɨ làgá, akódhɨ nɨ toró tàzoá dhɨ: «Mírì, mɨ́ tɨdrɨ́ àma wà! Mà adré dràle!» ");
INSERT INTO log_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yésu logó àyɨ dré dhɨ: «Àmɨ tà kaꞌìkaꞌì ɨ́be tsà nɨ ɨ, mɨ̀ adré ngá ro àdho tà sè?» Dɨ dré ngàzo lɨgɨ́lé lyǎandre nda ɨ dri tä́pä́ríandre nda be gò, ngá dré gòzo bhùle ndiii. ");
INSERT INTO log_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Dɨ àyɨ kɨ lɨ́ndrɨ́ dré gàzo bhwǎbhwa gò, ɨ̀ dré adrézó lizíá àyɨ kòfalésè dhɨ: «Dhya kòndɨ tá ɨ́na móndɨ́ kárá be ngɨ́nɨ dhɨ ꞌɨ, ndɨ̀ndɨ̀ lyǎandre ɨ tä́pä́ríandre be dhɨ ɨ̀ dré adrézó akódhɨ nɨ kúlí kaꞌì ꞌòle nɨ?» ");
INSERT INTO log_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yésu kòzya tä́pä́ríandre nɨ taꞌá na tsàle bvò Gàdárà kya na dre dhɨ, àgo rì tɨrɨ́ kònzɨ ɨ́be àyɨ léna dhɨ ɨ̀ dré apfòzo mógó lésè alɨ̀le ru kisú akódhɨ be. Àyɨ nda ɨ̀ dré tá adrélé móndɨ́ tòmbátòmba ɨ ró tò dhɨ sè dhɨ, dhya àlo kɨtswá tá lavúlé àrà nda ꞌásè bwà ko. ");
INSERT INTO log_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Gò ɨ̀ dré ngàzo loyóá kúlí ꞌuꞌù sè dhɨ: «Gìká nɨ Mváagó, àma kòfalésè mɨ́ be dhɨ, àdho tà ꞌɨ? Mɨ́ alɨ̀ tsì kònwa àma kɨ ꞌo kònzɨ lókyá bhàle dhɨ kandrá?» ");
INSERT INTO log_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Àyɨ làgana vwàvwà ro tsà dhɨ, tɨ̀gá kɨ pä̀rí andre adré tá ngá nya. ");
INSERT INTO log_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Dɨ tɨrɨ́ kònzɨ nda ɨ̀ dré Yésu nɨ ti lizízó tàzoá dhɨ: «Mɨ́ kàdré ꞌòle àma kɨ dro dhɨ, mɨ́ kòmù àma lɨ̀le tɨfɨ́lé tɨ̀gá kòna ɨ léna.» ");
INSERT INTO log_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yésu tà àyɨ dré dhɨ: «Mɨ̀ lɨ̀!» Dɨ ɨ̀ dré topfòzo àgo rì nda ɨ lésè, lɨ̀le tɨfɨ́lé tɨ̀gá nda ɨ léna. Gbǎ kòdhwa, tɨ̀gá nda ɨ̀ dré ndìzo títí kòngó nda nɨ gòlòko ꞌásè, ledhélé tä́pä́ríandre na todràle. ");
INSERT INTO log_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Gò tɨ̀gá nda kɨ lɨkɨ́bhá ɨ̀ dré ngàzo ràle tà títí lavúbhá nda kɨ rúbí longó bhàandre na. Ɨ̀ longó tá kpà tà atsálépi àgo rì tá tɨrɨ́ kònzɨ ɨ́be àyɨ léna nda ɨ rú dhɨ. ");
INSERT INTO log_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Gò móndyá títí dhɨ ɨ̀ dré apfòzo bhàandre nda lésè alɨ̀le ru kisú Yésu be. Dɨ, ɨ̀ kònò akódhɨ dre dhɨ, ɨ̀ dré akódhɨ nɨ ti lizízó, kòngaró àyɨ kɨ bvò ꞌásè be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Àmvolásà dhɨ, Yésu dré mbàzo bwátù na gòle zyàle tä́pä́ríandre nɨ taꞌá na, tsàle áyɨ tàndɨ nɨ bhàandre na. ");
INSERT INTO log_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Kònàle dhɨ, móndɨ́ àruka ɨ̀ dré agó àlo pá be àbvò ro dhɨ nɨ adózó kíndri dri alɨ̀zo ába akódhɨ vélé. Yésu kònò àyɨ kɨ tà kaꞌìkaꞌì dre dhɨ, dré tàzoá agó pá be àbvò ro nda dré dhɨ: «Áma mvá, mɨ́ tsɨ togó! À trì ámɨ tàkonzɨ̀ ɨ dre!» ");
INSERT INTO log_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Dɨ, tátrɨ́trɨ́ kúlí tadhábhá àruka ɨ̀ dré dhèzo adrélé kisùá àyɨ léna dhɨ: «Dhya kòndɨ adré ɨ́na Gìká nɨ dha kúlí kòdhɨ sè!» ");
INSERT INTO log_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yésu dré tà ɨ̀ dré tá adrélé kisùle nda nɨ nìzo kyá gò, tàzoá dhɨ: «Mɨ̀ adré àmɨkya tà kònzɨ kisù àmɨ léna àdho tà sè? ");
INSERT INTO log_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Tà kɨtswálé tàle mbèlè agó pá be àbvò ro kònɨ̀dhɨ dré dhɨ, ángùdhi ꞌɨ: ‹À trì ámɨ tàkonzɨ̀ ɨ dre› dhɨ, kó ngalè, ‹Mɨ́ nga, mɨ́ kɨdhó atsí to› dhɨ? ");
INSERT INTO log_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Má adré lèá mɨ̀ kònì dhɨ, Móndɨ́ nɨ Mvá rìnyí ɨ́be adrézó tàkonzɨ̀ tri bvò dri.» Dɨ dré tàzoá agó pá be àbvò ro nda dré dhɨ: «Mɨ́ nga, mɨ́ do ámɨ kíndri, ɨ̀ndɨ̀ mɨ́ nzɨ mɨ́ bhàna!» ");
INSERT INTO log_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Dɨ agó nda dré ngàzo nzɨ̀le ɨ́ bhàna. ");
INSERT INTO log_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Móndyá zyandre ɨ̀ kònò tà nda dre dhɨ, àyɨ kɨ togó dré gàzo tirì dré. Gò ɨ̀ dré ngàzo adrélé Gìká nɨ rú bha kùle, dré rìnyí múrúngú afèle móndɨ́ ɨ dré kònɨ̀nɨ dhɨ sè. ");
INSERT INTO log_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yésu kàpfò kònalésè gò adrélé lɨ̀le dre dhɨ, dré agó àlo rú be Màtáyò dhɨ nɨ no adréràꞌa lɨrɨ́lé mèdáyɨ̀ lagɨ́rà na. Dré tàzoá drá dhɨ: «Mɨ́ lebè ma!» Dɨ Màtáyò nda dré ngàzo adrélé Yésu nɨ lebè. ");
INSERT INTO log_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Bvóá dhɨ, Yésu ɨ̀ dré lɨ̀zo lebèbhá nɨ ɨ́be Màtáyò nɨ dzó na gò, ɨ̀ dré lɨrɨ́zó mɨ́sá làgásè adrélé ngá nya. Dɨ mèdáyɨ̀ lagɨ́bhá bǐ dhɨ ɨ, ɨ̀ndɨ̀ móndɨ́ bǐ adrélé nòle tàkonzɨ̀bhá ro dhɨ ɨ́be dhɨ ɨ̀ alɨ̀ tá kpà lɨrɨ́lé mɨ́sá làgásè túmä́ní àyɨ ɨ́be. ");
INSERT INTO log_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Dɨ Fàrìsáyò ɨ̀ kònò tà nda dre dhɨ, ɨ̀ dré ngàzo lizíá Yésu nɨ lebèbhá ɨ tí dhɨ: «Àmɨ kɨ tadhálépi adré ngá nya túmä́ní mèdáyɨ̀ lagɨ́bhá ɨ́be ɨ̀ndɨ̀ tàkonzɨ̀bhá ɨ́be àdho tà sè?» ");
INSERT INTO log_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yésu kòyi tà lizílé nda dre dhɨ, dré tàzoá dhɨ: «Móndyá rúbhá be dóro dhɨ ɨ̀ ndà gà kódzó ko na. Be ró dhɨ, móndyá drà ro dhɨ ɨ̀ adré àyɨkya ndàá àyɨ. ");
INSERT INTO log_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Dɨ, mɨ̀ kòlɨ̀ àmɨkya tà tɨsɨ̀le Gìká nɨ Kúlí na kònɨ̀dhɨ nɨ àndu nda nìle: ‹Má adré móndyá adrébhá àyɨ kɨ àzya kɨ kɨzà bha dhɨ kɨ nda kòdhya. Má adré mána mòbòmà adrélé fèle má dré dhɨ kɨ nda kòdhya ko.› Tàko ko, má alɨ̀ móndyá adrébhá àyɨ kɨ no gyǎgya dhɨ kɨ azí kòdhya ko. Be ró dhɨ, má alɨ̀ mána tàkonzɨ̀bhá kɨ azí kòdhya.» ");
INSERT INTO log_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Àmvolásà dhɨ, Yòwánɨ̀ Bàtísimò fèlepi nɨ lebèbhá ɨ̀ dré alɨ̀zo Yésu vélé lizíá tíá dhɨ: «Àma Fàrìsáyò ɨ́be dhɨ ɨ, mà adré kó tàbirí mvo rä, adrézó tà zi Gìká tí dhɨ, ámɨ lebèbhá ɨ̀ adré dɨ àyɨkya tàbirí mvo ko àdho tà sè?» ");
INSERT INTO log_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yésu logó àyɨ dré dhɨ: «Móndyá azílé gwányá làmó àdhya lé dhɨ kɨ kɨtswá tsì adrélé kɨzà ro, ɨ̀ dré adréràꞌa túmä́ní tòkó líyí be dhɨ ꞌá? Tàdzí ko! Dɨ, lókyá adrélépi alɨ̀le dhɨ sè dhɨ, à nɨ tòkó líyí nda nɨ tɨngá àyɨ kòfalésè gò, ɨ̀ dré kɨdhózó adrélé tàbirí mvo lókyá nda sè. ");
INSERT INTO log_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Dhya àlo kàdré kɨ́tá àku ró lasɨ́lépi dhɨ ɨ́be dhɨ, dhɨ kɨ́tá tɨ́dhɨ́ ro dhɨ kɨ́tá àku nda dri ko na. Tàko ko, kòꞌo kònɨ̀nɨ dhɨ, kɨ́tá tɨ́dhɨ́ nda nɨ kɨ́tá àku nda nɨ asé gò, kɨ́tá àku nda dré gòzo vélé lasɨ́lé lɨ̀le drìdrì. ");
INSERT INTO log_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Kòdhɨ ɨ́be dhɨ, dhya àlo dà vínò tɨ́dhɨ́ ro dhɨ kɨ́nɨ́ dhɨ̀le adrézó vínò lɨkɨ́, akùbhá dre dhɨ ɨ léna ko na. Tàko ko, kòꞌo kònɨ̀nɨ dhɨ, vínò tɨ́dhɨ́ nda nɨ abhò kɨ́nɨ́ àku nda kɨ lasɨ́ gò, vínò dré kutúzó gò, kɨ́nɨ́ nda ɨ̀ dré abɨ́zó títí. Ásà dhɨ, à adré vínò tɨ́dhɨ́ ro dhɨ nɨ da kɨ́nɨ́ tɨ́dhɨ́ ro dhɨ ɨ léna, adrézó ngá rì nda kɨ lɨkɨ́ dóro.» ");
INSERT INTO log_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yésu dré tá adréràꞌa tà nda kɨ ta dhɨ ꞌá dhɨ, Yúdà ànzɨ kɨ kàdrɨ̀ kɨ àlo dré alɨ̀zo adhélé áyɨ kórókó titì akódhɨ kandrá, tàzoá drá dhɨ: «Áma zapi drà nyànomvá kòndɨ. Dɨ, mɨ́ alɨ̀ ámɨ drɨ́gá bha akódhɨ dri wà, kàdrɨ́ró be dhɨ bvó!» ");
INSERT INTO log_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Dɨ Yésu ɨ̀ dré ngàzo lebèbhá nɨ ɨ́be adrélé lɨ̀le agó nda vésè. ");
INSERT INTO log_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Gbǎ lókyá nda sè dhɨ, tòkó àlo kàrɨ́ dré adrézó ràle rúásà kóná be mudrí-drì-rì dhɨ dré áyɨ kisízó ànyɨ Yésu àmvolésè gò, akódhɨ nɨ kɨ́tá ti tabè. ");
INSERT INTO log_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Àngyá ko, adré tá ɨ́na kisùá dhɨ: «Má kòtabè ngbà ꞌí akódhɨ nɨ kɨ́tá ti kòdhya dhɨ, má nɨ adrɨ́.» ");
INSERT INTO log_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Dɨ Yésu dré áyɨ alázó tòkó nda nɨ no gò, tàzoá dhɨ: «Áma zapi, mɨ́ tsɨ togó! Ámɨ tà kaꞌìkaꞌì tɨdrɨ́ mɨ dre.» Dɨ akódhɨ nda dré adrɨ́zó gbǎ lókyá nda sè. ");
INSERT INTO log_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Dɨ Yésu kòlɨ̀ tsàle Yúdà ànzɨ kɨ kàdrɨ̀ nda bhàna dre dhɨ, dré lärí tswabhá kɨ nòzo túmä́ní móndɨ́ zyandre adrébhá tongólé dhɨ ɨ́be. ");
INSERT INTO log_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Dré tàzoá àyɨ dré dhɨ: «Mɨ̀ nga kònwásè. Tàko ko, mvátòkó kòdhɨ drà ko. Adré ɨ́na ayí ko.» Gò ɨ̀ dré dhèzo adrélé akódhɨ nɨ gu. ");
INSERT INTO log_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","À kòdro móndyá zyandre nda ɨ topfòle kɨvɨ̀ na dre dhɨ, Yésu dré fɨ̀zo dzó nda na, mvátòkó nda nɨ drɨ́gá ru gò, akódhɨ dré ngàzo kuru. ");
INSERT INTO log_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Gò tà nda nɨ rúbí dré laꞌúzó bvò nda ꞌásè títí. ");
INSERT INTO log_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yésu kàpfò dzó nda lésè adrélé lɨ̀le dre dhɨ, àgo rì mì kùdúkùdu ró dhɨ ɨ̀ dré ngàzo adrélé akódhɨ nɨ lebè loyóába dhɨ: «Dàwídì nɨ Mvá, mɨ́ bhà àma kɨ kɨzà wà!» ");
INSERT INTO log_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yésu kòtsa bhàna fɨ̀le dzó na dre dhɨ, àyɨ nda ɨ̀ dré àyɨ kɨ kisízó ànyɨ akódhɨ làga. Dɨ akódhɨ dré àyɨ kɨ lizízó tàzoá dhɨ: «Mɨ̀ adré kaꞌìá dhɨ, má nɨ kɨtswá àmɨ kɨ tɨdrɨ́ bwà?» Ɨ̀ logó drá dhɨ: «Àyíya, Mírì.» ");
INSERT INTO log_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Gò Yésu dré àyɨ kɨ mì tabèzo, tàzoá dhɨ: «Tà nda kòꞌo ru àmɨ dré ngóró mɨ̀ dré adrélé kaꞌìle dhɨ tɨ́nɨ!» ");
INSERT INTO log_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Dɨ àyɨ kɨ mì dré ru nzìzo adrélé ngá no. Gò Yésu dré àyɨ kɨ bí sèzo tàzoá dhɨ: «Mɨ̀ kònò dóro, mɨ̀ kòlongóró tà kòdhɨ dhya àlo dré ko.» ");
INSERT INTO log_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Dɨ, ɨ̀ kòpfò dzó nda ꞌásè dre dhɨ, ɨ̀ dré àyɨkya lɨ̀zo Yésu nɨ rúbí longóbe laꞌúlé bvò nda ꞌásè títí. ");
INSERT INTO log_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ɨ̀ dré tá adréràꞌa apfòle dzó nda lésè dhɨ ꞌá dhɨ, à dré agó àlo tɨrɨ́ kònzɨ ɨ́be ɨ́ léna, adrélépi kpà ábhä́bhä́ ro dhɨ nɨ adzízó Yésu vélé. ");
INSERT INTO log_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Dɨ Yésu dré tɨrɨ́ kònzɨ nda nɨ dròzo pfòle ábhä́bhä́ nda lésè dhɨ, dré kɨdhózó adrélé kúlí ta. Móndyá zyandre kònàle dhɨ kɨ lɨ́ndrɨ́ dré gàzo bhwǎbhwa gò, ɨ̀ dré adrézó tàá dhɨ: «À nò rè tàdzí tà ꞌòle làsú be kònɨ̀nɨ dhɨ Ɨ̀sèrélè ꞌa ko!» ");
INSERT INTO log_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Dɨ, Fàrìsáyò ɨ̀ adré tá àyɨkya tàá dhɨ: «Dhya kòdhɨ adré tɨrɨ́ kònzɨ kɨ dro topfòle móndɨ́ ɨ lésè, tɨrɨ́ kònzɨ kɨ kàdrɨ̀ nɨ rìnyí sè.» ");
INSERT INTO log_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Gò Yésu dré ngàzo adrélé tatsílé bhàandre títí ɨ ꞌásè ɨ̀ndɨ̀ bhà títí ɨ ꞌásè, tà tadhábe Yúdà ànzɨ kɨ lɨ̀sámbò dzó ɨ ꞌásè, Rúbí Tanɨ Gìká nɨ Òpɨ̀ àdhya nɨ longóbe, ɨ̀ndɨ̀ móndɨ́ kɨ tɨdrɨ́be àyɨ kɨ drà títí ɨ lésè. ");
INSERT INTO log_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Dɨ dré tá adréràꞌa móndɨ́ zyandre dhɨ kɨ no dhɨ ꞌá dhɨ, adré tá kɨzà do áyɨ togó na àyɨ kɨ tà sè. Tàko ko, ɨ̀ adré tá landèle tò, ɨ̀ndɨ̀ tà adré tá àyɨ kɨ lavú. Àyɨ tá ngóró kábilígyà adrébhá àyɨ kɨ lɨkɨ́lépi àko dhɨ ɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Dɨ dré tàzoá áyɨ lebèbhá ɨ dré dhɨ: «Lànyá ka amvú na lavúlé dre. Dɨ, àzibhá adrébhá lànyá nda nɨ lokó dhɨ kɨ àbvò yókódhó. ");
INSERT INTO log_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Mɨ̀ kàdré dɨ lànyá nda nɨ líyí nɨ ti lizí, kòmùró àzibhá ɨ lɨ̀le áyɨ lànyá lokó be dhɨ bvó.» ");
INSERT INTO log_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Àmvolásà dhɨ, Yésu dré áyɨ lebèbhá mudrí-drì-rì dhɨ kɨ azízó gò, rìnyí fèzo àyɨ dré kɨtswázó tɨrɨ́ kònzɨ kɨ dro móndɨ́ ɨ lésè, ɨ̀ndɨ̀ kɨtswázó móndɨ́ kɨ tɨdrɨ́ àyɨ kɨ drà títí ɨ lésè. ");
INSERT INTO log_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Àpóstolò mudrí-drì-rì nda kɨ rú ɨ tá: Sìmónà (adrélé kpà rú zìle Pétèró dhɨ), adrúpi nɨ Àndréyà, Yàkóbhò Zèbèdáyò nɨ mvá, adrúpi nɨ Yòwánɨ̀, ");
INSERT INTO log_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Fìlípò, Bàràtòlòmáyò, Tòmá, Màtáyò (mèdáyɨ̀ lagɨ́lépi dhɨ), Yàkóbhò Àlàfáyò nɨ mvá, Tàdáyò, ");
INSERT INTO log_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Sìmónà (adrélépi àtsɨ ró áyɨ súrú nɨ tà sè dhɨ), ɨ̀ndɨ̀ Yùdásɨ̀ Ɨ̀sɨ̀kàrɨ̀yótà (dra Yésu nɨ lefèlepi kàrɨbhá ɨ drɨ́gá dhɨ). ");
INSERT INTO log_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Dɨ Yésu dré dhya mudrí-drì-rì nda kɨ tibhùzo, tà lazízó àyɨ dri kònɨ̀nɨ: «Mɨ̀ lɨ̀ móndyá súrú twá ro dhɨ ɨ véna ko. Mɨ̀ fɨ kpà bhàandre àlo Sàmàrɨ́yà kya na ko. ");
INSERT INTO log_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Be ró dhɨ, mɨ̀ lɨ̀ àmɨkya Ɨ̀sèrélè ànzɨ avɨ̀bhá kábilígyà ɨ tɨ́nɨ dhɨ ɨ véna. ");
INSERT INTO log_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Mɨ̀ dré adréràꞌa lɨ̀le dhɨ ꞌá dhɨ, mɨ̀ kàdré longóá móndɨ́ ɨ dré dhɨ: ‹Òpɨ̀ bhù àdhya atsá ànyɨ dre!› ");
INSERT INTO log_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mɨ̀ kàdré dràbhá kɨ tɨdrɨ́, adrézó móndɨ́ dràbhá dre dhɨ kɨ tɨngá dràdrà lésè, adrézó móndɨ́ kàrɨ́ dré rùle dhɨ kɨ tɨdrɨ́, adrézó tɨrɨ́ kònzɨ kɨ dro topfòle móndɨ́ ɨ lésè. Mɨ̀ kàdré tà ꞌo móndɨ́ ɨ dré àngyá, ngóró mɨ̀ dré kisúlé àngyá dhɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mɨ̀ do órò ꞌɨ yà, àrezá ꞌɨ yà, kó ngalè làfa lòꞌwa mvá ꞌɨ yà dhɨ àmɨ rú ko. ");
INSERT INTO log_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Mɨ̀ kòdo kòmvò atsí sè dhɨ ꞌɨ yà, kɨ́tá agá lésè dhɨ nɨ àzya ꞌɨ yà, kámókà àzya ꞌɨ yà, kó ngalè kùtù fa ꞌɨ yà dhɨ ko. Tàko ko, adré lèá dhɨ, dhya àzí ꞌòlepi dhɨ kònya áyɨ landè. ");
INSERT INTO log_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Bhàandre ángùdhi yà, ngalè bhà tsà ángùdhi yà mɨ̀ dré dra fɨ̀zo lána dhɨ na dhɨ, mɨ̀ kòndà rè zyà móndɨ́ kɨtswálépi àmɨ kɨ kaꞌì dòle dóro dhɨ ꞌíká gò, mɨ̀ kàdréró ayílé akódhɨ nda bhàna tsàle kìtú mɨ̀ dré dra ngàzo àrà nda ꞌásè dhɨ tú. ");
INSERT INTO log_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Mɨ̀ kàdré fɨ̀le dzó àlo dhɨ na dhɨ, mɨ̀ kòtà dhɨ: ‹Tà kɨ̀drɨ́kɨ̀drɨ kàdré dzó kònɨ̀dhɨ ꞌá.› ");
INSERT INTO log_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Móndyá dzó nda lé dhɨ ɨ̀ kàdré àmɨ kɨ kaꞌì dòle dóro dhɨ, tà kɨ̀drɨ́kɨ̀drɨ àmɨkya nda kàdré àyɨ dri. Dɨ, ɨ̀ kàdré àmɨ kɨ kaꞌì dòle dóro ko dhɨ, mɨ̀ kòꞌo tà kɨ̀drɨ́kɨ̀drɨ àmɨkya nda agòle àmɨ vélé. ");
INSERT INTO log_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Dzó ángùdhi yà, ngalè bhàandre ángùdhi yà dra àmɨ kɨ kaꞌìzo dòle lána dóro ko yà, kó ngalè àmɨ kɨ kúlí yìzo ko yà dhɨ na dhɨ, mɨ̀ kòpfò ꞌásà, ɨ̀ndɨ̀ mɨ̀ kòtowá tàpfulɨ́ndrɨ́ àmɨ pásè tadházóá dhɨ, mɨ̀ tayɨ́ àyɨ kɨ tà títí dre. ");
INSERT INTO log_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Má adré tà bàti ta àmɨ dré: Kìtú Gìká dré dra tàbvó tàzo dhɨ tú dhɨ, a nɨ tà ŋo móndyá bhàandre nda lésè dhɨ ɨ dri, móndyá Sòdómà ɨ lésè Gòmórà be dhɨ kya kɨ lavú.» ");
INSERT INTO log_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«Mɨ̀ yi rè ká! Má adré àmɨ kɨ mu ngóró kábilígyà ɨ tɨ́nɨ trú kàlagɨ́ ɨ kòfalé. Ásà dhɨ, lè mɨ̀ kàdré tògya ró ngóró nì ɨ tɨ́nɨ, adrélé kpà tà àko àmɨ rú ngóró kòbhòlà ɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mɨ̀ kàdré àmɨ kɨ lɨkɨ́ móndɨ́ kɨ tà sè. Tàko ko, ɨ̀ nɨ àmɨ kɨ ꞌo topfòle tàbvó tǎrà ɨ ꞌásè, adrézó àmɨ kɨ bhwa àyɨ kɨ lɨ̀sámbò dzó ɨ ꞌásè. ");
INSERT INTO log_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Áma tà sè dhɨ, à nɨ àmɨ kɨ tidrì topfòzo àmɨ ɨ́be gùvèrènérè ɨ kandrásè ɨ̀ndɨ̀ ópɨ́ kàdrɨ̀ ɨ kandrásè, mɨ̀ kòkɨtswáró áma tà mɨ̀ dré nòle ɨ̀ndɨ̀ mɨ̀ dré yìle dhɨ kɨ longó àyɨ dré, ɨ̀ndɨ̀ móndyá súrú twá ro dhɨ ɨ dré. ");
INSERT INTO log_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Dɨ, à kàdré àmɨ kɨ dri tàbvó tàle dhɨ, mɨ̀ kòbhà àmɨ kɨ togó adrélé lanzìle tà mɨ̀ dré dra tàle àmɨ rúsè yà, kó ngalè mɨ̀ nɨ tà nda nɨ ta ngɨ́nɨ ya dhɨ dri dhɨ ko. Gìká nɨ tà mɨ̀ dré kɨtswálé tàle dhɨ nɨ fe àmɨ dré gbǎ lókyá nda sè. ");
INSERT INTO log_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Àngyá ko, mɨ̀ nɨ adré tà nda nɨ ta àmɨ ko. Be ró dhɨ, àmɨ kɨ Atá nɨ Tɨrɨ́ nɨ adré tàá àmɨ tí dhɨ nɨ̀. ");
INSERT INTO log_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Móndɨ́ kɨ àyɨ kɨ adrúpi kɨ lefè todràle kàrɨbhá ɨ drɨ́gá. Ànzɨ kɨ atá kɨ kpà àyɨ kɨ ànzɨ kɨ lefè todràle. Ànzɨmvá kɨ lɨgɨ́ àyɨ kɨ tibhá ɨ rú, adrézó àyɨ kɨ ꞌo todràle. ");
INSERT INTO log_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Móndyá títí dhɨ kɨ togó kònzɨ bha àmɨ rú áma tà sè. Dɨ, dhya adrélépi ɨ́na togó tsɨ, adrézó áyɨ totó tätä tsàle kùdù na dhɨ nɨ adrɨ́. ");
INSERT INTO log_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","À kàdré àmɨ kɨ mɨ̀ pfo bhàandre àlo dhɨ na dhɨ, mɨ̀ kòlapá lɨ̀le àzya nɨ léna. Má adré tà bàti ta àmɨ dré: Mɨ̀ kɨtswá tàdzí tatsílé bhàandre títí Ɨ̀sèrélè ànzɨ kya ɨ ꞌásè drìdrì Móndɨ́ nɨ Mvá dré dra agòzo dhɨ kandrá ko. ");
INSERT INTO log_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Dhya adrélé tadhálé dhɨ lavú ɨ́na dhya adrélépi áyɨ tadhá dhɨ ko. Dhya adrélépi màrábà ro dhɨ lavú kpà áyɨ mírì ko. ");
INSERT INTO log_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Adré lèá dhɨ, dhya adrélé tadhálé dhɨ kàtsá dhya adrélépi áyɨ tadhá dhɨ tɨ́nɨ. Adré kpà lèá dhɨ, màrábà kàtsá áyɨ mírì tɨ́nɨ. À kàdré dzó líyí zi Bèlèzèbúlè ro be dhɨ, à nɨ dɨ vélé móndyá akódhɨ nɨ dzó lé dhɨ kɨ lodhá ngɨ́nɨ?» ");
INSERT INTO log_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","«Dɨ mɨ̀ kòro móndɨ́ àlomvá ko. Tàko ko, à nɨ tà títí lùzu ró dhɨ kɨ tadhá ngádra ꞌá. À nɨ kpà tà títí zùle zùzù dhɨ kɨ ꞌo apfòle móndɨ́ ɨ̀ dré nìle dóro. ");
INSERT INTO log_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Dɨ tà má dré adrélé tàle àmɨ dré tínímvá na dhɨ ɨ, mɨ̀ kàdré tàá ngádra ꞌá. Tà adrélé tàle àmɨ bína kòyàyà sè dhɨ, mɨ̀ kàdré longóá dzódrì ɨ lésè. ");
INSERT INTO log_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mɨ̀ kòro dhya adrébhá móndɨ́ kɨ rúbhá kɨ tupfú todràle gò, ɨ̀ dré kɨtswázó àyɨ kɨ lɨ́drɨ̀ pfu bwà ko dhɨ ɨ ko. Be ró dhɨ, mɨ̀ kàdré àmɨkya Gìká kɨtswálépi móndɨ́ kɨ lɨ́drɨ̀ kɨ tupfú todràle àyɨ kɨ rúbhá ɨ́be líferò na dhɨ nɨ ro kòdhya. ");
INSERT INTO log_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","À adré zakó tsì kɨ̀tsɨ̀kɨ́rɨ́nyà rì dhɨ kɨ lagɨ́ làfa lòꞌwa mvá àlo dhɨ sè? Dɨ tágba dré adrézó kònɨ̀nɨ dhɨ, àyɨ nda kɨ àlo kɨtswá dhèle kìní mi, Gìká àmɨ kɨ Atá dré tà nda nɨ ni àko ró ko. ");
INSERT INTO log_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Kàdré dɨ àmɨ kɨ tà sè dhɨ, akódhɨ nà ndɨ̀ndɨ̀ àmɨ kɨ drìbhɨ́ ɨ títí nànà. ");
INSERT INTO log_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Mɨ̀ kàdré dɨ ngá ro ko. Àmɨ kɨ tà lavú kɨ̀tsɨ̀kɨ́rɨ́nyà zyandre dhɨ kya byá! ");
INSERT INTO log_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Dhya ángùdhi adrélépi tàá móndɨ́ ɨ kandrá dhɨ ɨ́ kaꞌì ma dre dhɨ, má nɨ kókpà tàá áma Atá bhù na dhɨ kandrá dhɨ, má kaꞌì akódhɨ nda dre. ");
INSERT INTO log_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Dɨ, dhya ángùdhi adrélépi ɨ́na áma ga móndɨ́ ɨ kandrá dhɨ, má nɨ kókpà akódhɨ nda nɨ ga áma Atá bhù na dhɨ kandrá.» ");
INSERT INTO log_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«Lè mɨ̀ kòkisù ko tàle dhɨ, má alɨ̀ kɨtswálé tà kɨ̀drɨ́kɨ̀drɨ fe bvò dri dhɨ. Má alɨ̀ kɨtswálé tà kɨ̀drɨ́kɨ̀drɨ fe ko. Be ró dhɨ, má alɨ̀ mána kɨtswálé àdzú so móndɨ́ ɨ kòfalé. ");
INSERT INTO log_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Tàko ko, má alɨ̀ mváagó kɨ kòfalé lanzɨ́ atá nɨ be. Má alɨ̀ mvátòkó kɨ kòfalé lanzɨ́ andre nɨ be, adrézó kpà àdramvá kɨ kòfalé lanzɨ́ àdrá nɨ be. ");
INSERT INTO log_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Dhyá kɨ kàrɨbhá kɨ adré móndɨ́ dhyá kɨ tàndɨ nɨ dzó na dhɨ ꞌɨ. ");
INSERT INTO log_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Dhya ángùdhi adrélépi áyɨ atá ꞌɨ yà, kó ngalè áyɨ andre ꞌɨ yà dhɨ nɨ le áma lavú dhɨ, kɨtswá má sè ko. Dhya adrélépi áyɨ mváagó ꞌɨ yà, kó ngalè áyɨ mvátòkó ꞌɨ yà dhɨ nɨ le áma lavú dhɨ, kɨtswá má sè ko. ");
INSERT INTO log_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Dhya ángùdhi adrélépi áyɨ fa kɨpakɨpa do, adrézó áma lebè dhɨ ko dhɨ, kɨtswá kpà má sè ko. ");
INSERT INTO log_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Dhya ángùdhi adrélépi áyɨ lɨ́drɨ̀ lɨkɨ́ áyɨ tàndɨ dré dhɨ, nɨ áyɨ lɨ́drɨ̀ nda nɨ ꞌo avɨ̀le. Dɨ, dhya adrélépi áyɨ lɨ́drɨ̀ fe áma tà sè dhɨ nɨ áyɨ lɨ́drɨ̀ nda nɨ kisú.» ");
INSERT INTO log_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«Dhya ángùdhi adrélépi àmɨ kɨ kaꞌì dòle dóro dhɨ, adré áma tàndɨ nɨ kaꞌì kòdhya. Dhya adrélépi áma kaꞌì dòle dóro dhɨ, adré dhya áma amùlepi dhɨ nɨ kaꞌì kòdhya. ");
INSERT INTO log_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Dhya ángùdhi adrélépi pròfétà àlo dhɨ nɨ kaꞌì dòle dóro, dré adrélé pròfétà ꞌɨ dhɨ sè dhɨ, akódhɨ nda nɨ làgɨ́ adrélé fèle pròfétà ɨ dré dhɨ nɨ kisú. Dhya adrélépi móndɨ́ àlo gyǎgya dhɨ nɨ kaꞌì dòle dóro, dré adrélé móndɨ́ gyǎgya ꞌɨ dhɨ sè dhɨ, akódhɨ nda nɨ làgɨ́ adrélé fèle móndɨ́ gyǎgya ɨ dré dhɨ nɨ kisú. ");
INSERT INTO log_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Dɨ má adré tà bàti ta àmɨ dré: Dhya ángùdhi adrélépi ndɨ̀ndɨ̀ kópò àlo yǐ kɨ̀drɨ́ àdhya nɨ fe áma ànzɨmvá kɨ àlo dré mvùle, dré adrélé áma lebèlepi ꞌɨ dhɨ sè dhɨ, akódhɨ nda nɨ làgɨ́ ɨ́na nɨ kisú bàti.» ");
INSERT INTO log_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yésu kòlazí tà nda ɨ áyɨ lebèbhá mudrí-drì-rì dhɨ ɨ dri akɨ́lé dre dhɨ, dré ngàzo adrélé tatsílé tà tadhábe ɨ̀ndɨ̀ Gìká nɨ kúlí longóbe bhàandre bvò Gàlìláyà àdhya lé dhɨ ɨ ꞌásè. ");
INSERT INTO log_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Dɨ Yòwánɨ̀ Bàtísimò fèlepi, adrélépi tá bǎdzó na dhɨ kòyi tà Krísto dré tá adrélé ꞌòle dhɨ ɨ dre dhɨ, dré áyɨ lebèbhá kɨ mùzo ");
INSERT INTO log_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","akódhɨ nɨ lizí tàzoá dhɨ: «Mɨ Mèsɨ́yà adrélépi tá alɨ̀le dhɨ ꞌɨ? Kó ngalè, mà kàdré dhu rè dhya àzya nɨ letè kòdhya?» ");
INSERT INTO log_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yésu logó àyɨ dré dhɨ: «Mɨ̀ gò tà mɨ̀ dré adrélé yìle, ɨ̀ndɨ̀ mɨ̀ dré adrélé nòle kònɨ kɨ tɨtɨ́ Yòwánɨ̀ dré: ");
INSERT INTO log_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Mì kùdúkùdu ɨ̀ adré ngá no, mèrèkpè ɨ̀ adré atsí to, móndɨ́ kàrɨ́ dré rùle dhɨ ɨ̀ adré adrɨ́lé, móndɨ́ bíbhálé be kùdúkùdu ró dhɨ ɨ̀ adré tà yi, móndɨ́ dràbhá dre dhɨ ɨ̀ adré angálé dràdrà lésè, ɨ̀ndɨ̀ à adré Rúbí Tanɨ longó lemerèbhá ɨ dré. ");
INSERT INTO log_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Kólénzé dhya ángùdhi dra dhèlepi áma tà sè ko dhɨ dré!» ");
INSERT INTO log_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Dɨ Yòwánɨ̀ nɨ lebèbhá nda ɨ̀ dré tá adréràꞌa lɨ̀le dhɨ ꞌá dhɨ, Yésu dré kɨdhózó adrélé Yòwánɨ̀ nɨ tà ta móndyá zyandre ɨ dré, adrézó tàá dhɨ: «Mɨ̀ lɨ̀ tá duku na àdho no? Mɨ̀ lɨ̀ kòzó lyǎ dré tá adrélé vìle dhɨ nɨ no? ");
INSERT INTO log_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Mɨ̀ lɨ̀ tá àdho no? Mɨ̀ lɨ̀ móndɨ́ kɨ́tá aveave asólépi ɨ́ rú dhɨ nɨ no? Mɨ̀ yi rè ká! Móndyá adrébhá kɨ́tá aveave dhɨ kɨ tosó dhɨ ɨ àyɨkya ópɨ́ kɨ dzó kàdrɨ̀ ɨ ꞌásè be. ");
INSERT INTO log_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Mɨ̀ lɨ̀ tá dɨ àdho no? Mɨ̀ lɨ̀ pròfétà nɨ no? Àyíya! Má adré tàá àmɨ dré dhɨ: Yòwánɨ̀ nda lavú pròfétà byá. ");
INSERT INTO log_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Tàko ko, akódhɨ dhya tà kònɨ̀dhɨ nɨ tɨsɨ̀zo tà nɨ dri Gìká nɨ Kúlí na dhɨ ꞌɨ: ‹Mɨ́ nò ká! Má nɨ dhya dra áma kúlí longólépi dhɨ nɨ mu lɨ̀le mɨ́ kandrána. Akódhɨ nda nɨ láti ledé mɨ́ dré mɨ́ kandrána.› ");
INSERT INTO log_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Má adré tà bàti ta àmɨ dré: Móndyá títí tòkó dré tìle dhɨ ɨ kòfalé dhɨ, dhya àlo kàdrɨ̀ Yòwánɨ̀ Bàtísimò fèlepi nda nɨ lavúlépi dhɨ apfò rè tàdzí ko. Dɨ, tágba dré adrézó kònɨ̀nɨ dhɨ, dhya tàko lavúlé Òpɨ̀ bhù àdhya na dhɨ lavú ɨ́na akódhɨ. ");
INSERT INTO log_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Kɨdhólé lókyá Yòwánɨ̀ Bàtísimò fèlepi dré kɨdhózó Gìká nɨ kúlí longó dhɨ sè atsálé ándrò kònɨ̀dhɨ dhɨ, à adré ru pfu Òpɨ̀ bhù àdhya be, ɨ̀ndɨ̀ móndɨ́ rìnyi ró dhɨ ɨ̀ adré láti nda topázóá. ");
INSERT INTO log_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Tàko ko, pròfétà títí dhɨ ɨ Mósè nɨ tátrɨ́trɨ́ kúlí be dhɨ ɨ̀ longó tá Òpɨ̀ nda nɨ tà, atsálé Yòwánɨ̀ nɨ lókyá ꞌá. ");
INSERT INTO log_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Mɨ̀ kàdré áma kúlí le kaꞌìle dhɨ, Yòwánɨ̀ nda Èlɨ́yà adrélépi tá alɨ̀le dhɨ ꞌɨ. ");
INSERT INTO log_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Dhya ángùdhi adrélépi bíbhálé ɨ́be tà yìzo dhɨ kòyi! ");
INSERT INTO log_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Má nɨ kɨtswá móndyá ándrò kònɨ kɨ tà tadhá àdho ngá rú? Àyɨ nda ɨ̀ sù ngóró ànzɨmvá lɨrɨ́bhá ngá lagɨ́rà na, adrélé kúlí loyó àyɨ kòfalésè dhɨ ɨ tɨ́nɨ. Ɨ̀ adré loyóá dhɨ: ");
INSERT INTO log_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‹Mà tswà lärí àmɨ dré wóyá, mɨ̀ to àmɨkya lärí nda ko. Mà ngo àwó longó wóyá, mɨ̀ tongó àmɨkya ko.› ");
INSERT INTO log_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Tàko ko, Yòwánɨ̀ nda dré alɨ̀zo dhɨ, nya tá ngá ko, mvu kpà ngá ko gò, à dré adrézó tàá dhɨ: ‹Akódhɨ tɨrɨ́ kònzɨ ɨ́be ɨ́ léna.› ");
INSERT INTO log_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Dɨ, ma, Móndɨ́ nɨ Mvá, má dré alɨ̀zo dhɨ, má adré mána ngá nya, adrézó kpà ngá mvu gò, à dré adrézó tàá dhɨ: ‹Dhya kòdhɨ kòvongbolo líyí ꞌɨ, wá lìtsí líyí ꞌɨ, ɨ̀ndɨ̀ mèdáyɨ̀ lagɨ́bhá kɨ arúpi tàkonzɨ̀bhá ɨ́be dhɨ ꞌɨ!› Dɨ, à adré Gìká nɨ tògyá no gyǎgya, tà adrélé ꞌòle tògyá nda sè dhɨ ɨ sè.» ");
INSERT INTO log_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Gò Yésu dré ngàzo adrélé lawàle bhàandre ɨ́ dré tá tà lɨ́ndrɨ́ga ró bǐ dhɨ kɨ ꞌòzo ꞌásà dhɨ ɨ dri, móndyá ꞌásà dhɨ ɨ̀ dré àyɨ kɨ togó ladzálé ko dhɨ sè. ");
INSERT INTO log_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Tà dhɨ: «Kɨzà àmɨ kɨ ngá ꞌɨ, àmɨ Kòràzínàbhá ro nɨ ɨ! Kɨzà kpà àmɨ kɨ ngá ꞌɨ, àmɨ Bètèsàyɨ́dàbhá ro nɨ ɨ! Àngyá ko, má kòꞌo tá tà lɨ́ndrɨ́ga ró má dré ꞌòle àmɨ véna dhɨ ɨ Tírè na ɨ̀ndɨ̀ Sìdónà na dhɨ, kònò móndyá bhàandre nda ɨ ꞌásè dhɨ ɨ̀ asó tá kɨ́tá lirí àyɨ rú kɨ́nó, àyɨ kɨ drì pfòzo tópfó sè tadházóá dhɨ, ɨ̀ ladzá àyɨ kɨ togó káyà dhɨ dre. ");
INSERT INTO log_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Má adré dɨ tàá àmɨ dré dhɨ: Kìtú Gìká dré dra tàbvó tàzo dhɨ tú dhɨ, a nɨ tà ŋo àmɨ dri móndyá Tírè ɨ lésè Sìdónà be dhɨ kya kɨ lavú. ");
INSERT INTO log_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Dɨ àmɨ Kàpàrànàwúmàbhá ro nɨ ɨ, mɨ̀ adré tsì kisùá dhɨ, Gìká nɨ àmɨ kɨ tà tɨngá tsàle byá kurú na bhù na bàti? Tàdzí ko! A nɨ àmɨ kɨ tà tɨrɨ́ tsàle byá móndyá dràbhá dre dhɨ kɨ àrà na. Àngyá ko, má kòꞌo tá tà lɨ́ndrɨ́ga ró má dré ꞌòle àmɨ véna dhɨ ɨ Sòdómà na dhɨ, kònò bhàandre nda nɨ tá adré ngbú rè be atsálé ándrò kònɨ̀dhɨ. ");
INSERT INTO log_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Má adré dɨ tàá àmɨ dré dhɨ: Kìtú Gìká dré dra tàbvó tàzo dhɨ tú dhɨ, a nɨ tà ŋo àmɨ dri móndyá Sòdómà lésè dhɨ kya kɨ lavú.» ");
INSERT INTO log_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Lókyá nda sè dhɨ, Yésu dré tàzoá dhɨ: «Á! Tátá, Mírì bhù kya bvò be nɨ, má adré àwoyà ta mɨ́ dré, mɨ́ dré tà kòdhɨ kɨ zùle tògyabhá ɨ dré ɨ̀ndɨ̀ móndyá tà nibhá ɨ dré gò, mɨ́ dré tà nda kɨ tadházó ànzɨmvá ɨ dré dhɨ sè. ");
INSERT INTO log_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Àyíya, Tátá, tàko ko, tà mɨ́ dré ꞌòle nda tá dóro mɨ́ mìlésè. ");
INSERT INTO log_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Áma Atá tayɨ́ tà títí dhɨ ɨ má drɨ́gá dre. Dhya àlo Gìká nɨ Mváagó nìlepi bàti dhɨ yókódhó, ngbà ꞌí Gìká Atá nì nɨ̀. Dhya àlo Gìká Atá nìlepi bàti dhɨ kpà yókódhó. Ngbà ꞌí akódhɨ nɨ Mváagó nì nɨ̀, ɨ̀ndɨ̀ dhya Mváagó nda dré adrézó áyɨ Atá nɨ le tadhálé àyɨ dré dhɨ ɨ̀ nì àyɨ. ");
INSERT INTO log_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Àmɨ títí adrébhá ngá lanzì do adrézó landèle nɨ ɨ, mɨ̀ alɨ̀ má vélé wà, má kòꞌoró àmɨ adrélé lovólé be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Mɨ̀ kòtayɨ́ àmɨ má dré adrélé tidrìle, mɨ̀ kàdréró áma tà nda nìle. Tàko ko, áma togó yàyà ànzɨmvá kya tɨ́nɨ, ɨ̀ndɨ̀ mɨ̀ nɨ tà kɨ̀drɨ́kɨ̀drɨ kisú àmɨ kɨ togó na. ");
INSERT INTO log_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Àngyá ko, àmɨ kɨ tayɨma má dré adrélé tidrìle dhɨ dóro, ɨ̀ndɨ̀ ngá má dré adrélé fèle àmɨ dré dòle dhɨ lanzì ko.» ");
INSERT INTO log_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Àmvolásà, sàbátù àlo dhɨ, Yésu ɨ̀ adré tá lavúlé amvú ngánò àdhya ɨ ꞌásè. Tàbirí dré akódhɨ nɨ lebèbhá kɨ ꞌòzo gò, ɨ̀ dré kɨdhózó adrélé ngánò lòꞌwa vu, adrézó tsɨ̀á. ");
INSERT INTO log_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Fàrìsáyò ɨ̀ kònò tà nda dre dhɨ, ɨ̀ dré tàzoá Yésu dré dhɨ: «Mɨ́ nò rè ká! Ámɨ lebèbhá ɨ̀ adré àyɨkya tà àma kɨ tátrɨ́trɨ́ kúlí dré adrélé logálé sàbátù tú dhɨ nɨ ꞌo!» ");
INSERT INTO log_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Dɨ Yésu logó àyɨ dré dhɨ: «Mɨ̀ nà rè tà Dàwídì dré tá ꞌòle ɨ̀ dré adréràꞌa tàbirí ɨ́be akódhɨ nɨ arúpi ɨ́be dhɨ ꞌá dhɨ ko? ");
INSERT INTO log_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Akódhɨ fɨ tá Gìká nɨ dzó kàdrɨ̀ na gò, ɨ̀ dré mápà fèle Gìká dré dhɨ nɨ adózó nyàle arúpi nɨ ɨ́be. Tákò àma kɨ tátrɨ́trɨ́ kúlí adré tá ɨ́na mápà nda nɨ nyàma logá àyɨ dré. Ngbà ꞌí kòwánà kɨ tá kɨtswá nyàá dhɨ àyɨ. ");
INSERT INTO log_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Mɨ̀ nà rè kpà Mósè nɨ tátrɨ́trɨ́ kúlí na ko tàle dhɨ, kòwánà ɨ̀ adré àyɨkya àzí ꞌo tépelò na gba kàdré sàbátù tú gò, adrézó tà bha àyɨ dri ko dhɨ? ");
INSERT INTO log_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Dɨ má adré tà bàti ta àmɨ dré: Dhya kàdrɨ̀ tépelò nda nɨ lavúlépi dhɨ be kònwárè! ");
INSERT INTO log_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Gìká nɨ Kúlí adré tàá dhɨ: ‹Má adré móndyá adrébhá àyɨ kɨ àzya kɨ kɨzà bha dhɨ kɨ nda kòdhya. Má adré mána mòbòmà adrélé fèle má dré dhɨ kɨ nda kòdhya ko.› Kònò mɨ̀ kònì tá kúlí kòdhɨ kɨ àndu be dhɨ, mɨ̀ kɨtswá tá tà bha móndyá tà àko àyɨ rú dhɨ ɨ dri ko. ");
INSERT INTO log_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Tàko ko, Móndɨ́ nɨ Mvá, Mírì sàbátù àdhya ꞌɨ.» ");
INSERT INTO log_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yésu kòtayɨ́ àrà nda dre dhɨ, dré lɨ̀zo fɨ̀le Yúdà ànzɨ kɨ lɨ̀sámbò dzó na. ");
INSERT INTO log_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Kònàle dhɨ, agó àlo drɨ́gá nɨ dré ꞌyòzo ꞌyoꞌyò dhɨ tá be. Fàrìsáyò àruka ɨ̀ adré tá tà ɨ̀ dré kɨtswázó Yésu nɨ asíkì ásà dhɨ nɨ nda gò, ɨ̀ dré lizízóá tíá dhɨ: «Àma kɨ tátrɨ́trɨ́ kúlí kaꞌì, à kàdré móndɨ́ kɨ tɨdrɨ́ sàbátù tú dhɨ ꞌí?» ");
INSERT INTO log_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Akódhɨ logó àyɨ dré dhɨ: «Dhya àlo àmɨ kòfalé dhɨ kàdré kábilígyà àlo dhɨ ɨ́be gò, kábilígyà nda dré dhèzo bhú na sàbátù tú dhɨ, dhya nda kɨtswá tsì aséá gbǎ kìtú nda sè ko? ");
INSERT INTO log_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Dɨ móndɨ́ kɨ tà lavú kábilígyà kya byá! Ásà dhɨ, àma kɨ tátrɨ́trɨ́ kúlí adré tà dóro ꞌòma sàbátù tú dhɨ nɨ kaꞌì.» ");
INSERT INTO log_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Dɨ Yésu dré tàzoá agó nda dré dhɨ: «Mɨ́ kɨdzɨ̀ ámɨ drɨ́gá.» Akódhɨ dré kɨdzɨ̀zoá gò, drɨ́gá nɨ nda dré adrɨ́zó atsálé dóro àzya nɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Dɨ Fàrìsáyò nda ɨ̀ dré pfòzo ru yi, kɨtswázó láti nda Yésu nɨ pfùzo dràle dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Dɨ Yésu dré tà nda nɨ yìzo gò, àrà nda nɨ tayɨ́zó lɨ̀zo. Móndɨ́ zyandre lavúlé dhɨ ɨ̀ dré ngàzo lɨ̀le akódhɨ vésè gò, dré àyɨ kɨ dràbhá títí dhɨ kɨ tɨdrɨ́zó. ");
INSERT INTO log_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Dré àyɨ kɨ logázó, ɨ̀ kòtadháró móndɨ́ ɨ dré ɨ àdhi ꞌɨ ya dhɨ ko. ");
INSERT INTO log_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Tà nda kòdhɨ atsá kònɨ̀nɨ, kɨtswálé tà Gìká dré tá longólé pròfétà Èsáyà tí dhɨ kòꞌoró ru be dhɨ bvó. Akódhɨ longó tá dhɨ: ");
INSERT INTO log_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«Kònɨ̀dhɨ áma adhemakandra má dré zɨ̀le dhɨ ꞌɨ. Akódhɨ dhya má dré adrélé lèle tò, ɨ̀ndɨ̀ áma togó dré adrézó kɨnɨ́lé tà nɨ nɨ sè dhɨ ꞌɨ. Má nɨ áma Tɨrɨ́ bha akódhɨ dri gò, dré áma tà gyǎgya longózó súrú títí dhɨ ɨ dré. ");
INSERT INTO log_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Akódhɨ kɨtswá lawàle móndɨ́ ɨ́be ko, kɨtswá kpà trèle ko. Kɨtswá áyɨ kúlí loyó móndɨ́ ɨ dré yìle láti ɨ bhálésè ko. ");
INSERT INTO log_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Kɨtswá kòzó bhèlebhéle dhɨ nɨ ŋo ko. Kɨtswá kpà tálà adrélépi ꞌòle adrálé dhɨ nɨ avó adrálé ko, tsàle lókyá dré dra áma tà gyǎgya ꞌòzo tà kònzɨ lavú dhɨ ꞌá. ");
INSERT INTO log_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Dɨ súrú títí bvò dri dhɨ kɨ àyɨ kɨ mì bha akódhɨ véna.» ");
INSERT INTO log_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Àmvolásà dhɨ, à dré agó àlo tɨrɨ́ kònzɨ ɨ́be ɨ́ léna, adrélépi kpà mì kùdúkùdu ró ɨ̀ndɨ̀ ábhä́bhä́ ro dhɨ nɨ adzízó Yésu vélé. Dɨ Yésu dré akódhɨ nda nɨ tɨdrɨ́zó gò, akódhɨ dré kɨdhózó adrélé kúlí ta, adrézó kpà ngá no. ");
INSERT INTO log_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Móndyá zyandre títí dhɨ kɨ lɨ́ndrɨ́ dré gàzo bhwǎbhwa gò, ɨ̀ dré adrézó tàá dhɨ: «Dhya kòdhɨ tsì Dàwídì nɨ Mvá, Mèsɨ́yà ro dhɨ ꞌɨ ko?» ");
INSERT INTO log_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Dɨ, Fàrìsáyò ɨ̀ kòyi kúlí nda dre dhɨ, ɨ̀ dré àyɨkya tàzoá dhɨ: «Dhya kòdhɨ adré ngbà ꞌí tɨrɨ́ kònzɨ kɨ dro topfòle móndɨ́ ɨ lésè, Bèlèzèbúlè, tɨrɨ́ kònzɨ kɨ kàdrɨ̀ nɨ rìnyí sè.» ");
INSERT INTO log_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Dɨ, Yésu dré ɨ́na tà ɨ̀ dré tá adrélé kisùle nda nɨ nìzo kyá gò, tàzoá àyɨ dré dhɨ: «Òpɨ̀ ángùdhi móndyá zàlá dhɨ ɨ̀ dré adrézó ru lanzɨ́ àyɨ kòfalésè dhɨ, òpɨ̀ nda nɨ tà nɨ akɨ́ títí. Bhàandre ángùdhi yà, kó ngalè dzó ángùdhi yà móndyá lána dhɨ ɨ̀ dré adrézó ru lanzɨ́ àyɨ kòfalésè dhɨ, kɨtswá kpà áyɨ totó bwà ko. ");
INSERT INTO log_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Sàtánà kàdré Sàtánà nɨ dro dhɨ, adré ɨ́na ru pfu áyɨ tàndɨ be. Akódhɨ nɨ òpɨ̀ nɨ dɨ áyɨ totó ngɨ́nɨngɨ́nɨ ró? ");
INSERT INTO log_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Má kàdré mána tɨrɨ́ kònzɨ kɨ dro Bèlèzèbúlè nɨ rìnyí sè dhɨ, àmɨ kɨ móndyá ɨ̀ adré dɨ àyɨ kɨ dro àdhi nɨ rìnyí sè? Dɨ ásà dhɨ, àyɨ nda kɨ tà mɨ̀ dré adrélé tàle nda kɨ bvó ta àyɨ. ");
INSERT INTO log_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Dɨ, má kàdré mána tɨrɨ́ kònzɨ kɨ dro Gìká nɨ Tɨrɨ́ nɨ rìnyí sè dhɨ, kòdhɨ adré tadhá dhɨ, Gìká nɨ Òpɨ̀ atsá àmɨ kòfalé dre káyà dhɨ. ");
INSERT INTO log_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Kòdhɨ ɨ́be dhɨ, dhya àlo kɨtswá fɨ̀le agó kòmbá àlo dhɨ nɨ dzó na akódhɨ nɨ ngá wu bwà ko, kàdrò zyà rè kòmbá nda bǎ sè ꞌíká ko dhɨ. Dɨ kàdrò akódhɨ dre dhɨ, a nɨ kɨtswá ngá títí akódhɨ nɨ dzó na nda kɨ wu. ");
INSERT INTO log_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Dhya ángùdhi adrélépi túmä́ní má be ko dhɨ adré ɨ́na ru pfu má be. Dhya adrélépi móndɨ́ kɨ kɨmó túmä́ní má be ko dhɨ, adré ɨ́na àyɨ kɨ lapé. ");
INSERT INTO log_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Dɨ ásà dhɨ, má adré tàá àmɨ dré dhɨ: Gìká nɨ kɨtswá tàkonzɨ̀ títí móndɨ́ ɨ̀ dré adrélé ꞌòle dhɨ kɨ tri, túmä́ní làdhá títí ɨ̀ dré adrélé dhàle ɨ́ rú dhɨ ɨ́be. Dɨ, kɨtswá ɨ́na làdhá dhàle Tɨrɨ́ Lólo rú dhɨ nɨ tri ko. ");
INSERT INTO log_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Dhya ángùdhi adrélépi kúlí kònzɨ ta Móndɨ́ nɨ Mvá rú dhɨ, Gìká nɨ akódhɨ nda nɨ tàkonzɨ̀ tri. Dɨ, dhya ángùdhi adrélépi ɨ́na kúlí kònzɨ ta Tɨrɨ́ Lólo rú dhɨ, à kɨtswá akódhɨ nda nɨ tàkonzɨ̀ tri lókyá kònɨ̀dhɨ sè yà, kó ngalè lókyá adrélépi alɨ̀le dhɨ sè yà dhɨ ko.» ");
INSERT INTO log_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Yésu gò tàá dhɨ: «Fa kàdré dóro dhɨ, lòꞌwa nɨ kɨ kókpà adré dóro. Fa kàdré kó kònzɨ dhɨ, lòꞌwa nɨ kɨ kókpà adré kònzɨ. Tàko ko, à adré fa ni lòꞌwa nɨ ɨ sè. ");
INSERT INTO log_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Àmɨ, nì àtrá kɨ àrèbhá nɨ ɨ, àmɨ kó kònzɨ dhɨ, mɨ̀ nɨ dɨ kɨtswá tà àlo dóro dhɨ nɨ ta ngɨ́nɨngɨ́nɨ ró? Àngyá ko, ti adré tà adrélépi gàle togó na dhɨ kɨ ta kòdhya. ");
INSERT INTO log_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Dhya dóro adré tà dóro ꞌo apfòle tà dóro títí dré zùle áyɨ togó na dhɨ ɨ lésè. Dɨ, dhya kònzɨ adré ɨ́na tà kònzɨ ꞌo apfòle tà kònzɨ títí dré zùle áyɨ togó na dhɨ ɨ lésè. ");
INSERT INTO log_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Má adré tàá àmɨ dré dhɨ: Kìtú dra tàbvó tàzo dhɨ tú dhɨ, móndyá títí dhɨ kɨ kúlí tàko àlo àlo títí ɨ̀ dré tàle dhɨ kɨ tà ta Gìká kandrá. ");
INSERT INTO log_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Tàko ko, kúlí mɨ́ dré tàle dhɨ kɨ tà sè dhɨ, a nɨ ámɨ tàbvó ta ngalè ámɨ nòzo gyǎgya yà, kó ngalè tà bhàzo mɨ́ dri yà dhɨ.» ");
INSERT INTO log_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Àmvolásà dhɨ, Fàrìsáyò àruka ɨ tátrɨ́trɨ́ kúlí tadhábhá àruka ɨ́be dhɨ ɨ̀ dré tàzoá Yésu dré dhɨ: «Tadhálépi, mà adré lèá dhɨ, mɨ́ kòꞌo tà lɨ́ndrɨ́ga ró dhɨ àma dré nòle.» ");
INSERT INTO log_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Dɨ Yésu dré logózóá àyɨ dré dhɨ: «Móndyá ándrò adrébhá kònzɨ ɨ̀ndɨ̀ zàràbhù ro dhɨ ɨ̀ adré tà lɨ́ndrɨ́ga ró dhɨ nɨ nda nòle. Dɨ, à kɨtswá tà àzya lɨ́ndrɨ́ga ró dhɨ nɨ ꞌo àyɨ dré nòle dhɨ ko, kàdré ngbà ꞌí pròfétà Yónà àdhya ꞌɨ ko dhɨ. ");
INSERT INTO log_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Tàko ko, ngóró Yónà dré tá ayílé kìtú na ɨ̀ndɨ̀ ngátsi na kosyá àgá léna dhɨ tɨ́nɨ dhɨ, Móndɨ́ nɨ Mvá nɨ kókpà ayí bvò na kìtú na ɨ̀ndɨ̀ ngátsi na. ");
INSERT INTO log_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Kìtú dra tàbvó tàzo dhɨ tú dhɨ, Nìnívèbhá kɨ nga tà bha móndyá ándrò nɨ ɨ dri. Tàko ko, Nìnívèbhá nda ɨ̀ dré tá tà Yónà dré longólé àyɨ dré dhɨ nɨ yìzo dhɨ, ɨ̀ ladzá tá àyɨkya àyɨ kɨ togó ꞌí. Dɨ mɨ̀ nò rè ká! Dhya kàdrɨ̀ Yónà nda nɨ lavúlépi dhɨ be kònwárè! ");
INSERT INTO log_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Kòdhɨ ɨ́be dhɨ, kìtú dra tàbvó tàzo dhɨ tú dhɨ, ópɨ́ kàdrɨ̀ tòko ró bvò tàbhu na dhɨ drìle dhɨ nɨ nga tà bha móndyá ándrò nɨ ɨ dri. Tàko ko, ópɨ́ nda angá tá ɨ́na làwú làvo lésè alɨ̀le ópɨ́ Sòlòmónò nɨ tògyakúlí yi ꞌí. Dɨ mɨ̀ nò rè ká! Dhya kàdrɨ̀ Sòlòmónò nda nɨ lavúlépi dhɨ be kònwárè!» ");
INSERT INTO log_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Yésu gò tàá dhɨ: «Tɨrɨ́ kònzɨ àlo dhɨ kòpfò dhya àlo lésè dhɨ, adré anyálé àrà fà ro dhɨ ɨ ꞌásè, àrà ɨ́ dré kɨtswázó lovólé lána dhɨ nɨ ndabe. Dɨ, kòkɨtswá kisúá bwà ko dhɨ, ");
INSERT INTO log_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","adré tàá dhɨ: ‹Má nɨ go fɨ̀le áma dzó má dré apfòzo lásà dhɨ na.› Kògò tsàle dre dhɨ, adré kisúá dhɨ, dzó nda ngbo: À awá ꞌálé nɨ, ngá lána dhɨ kɨ tobhàzo kpǎkpa dre. ");
INSERT INTO log_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Dɨ adré lɨ̀le tɨrɨ́ kònzɨ áyɨ lavúbhá nzi-drì-rì dhɨ kɨ nda lɨ̀zo àyɨ ɨ́be gò, ɨ̀ dré adrézó tɨfɨ́lé adrélé dhya nda léna. Dɨ dhya nda nɨ tà kùdù ro dhɨ vélé kònzɨ wáláká nɨ nɨ lavú. Dɨ tà nda nɨ adré kókpà kònɨ̀nɨ móndyá ándrò adrébhá kònzɨ nɨ ɨ dré.» ");
INSERT INTO log_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yésu dré tá adréràꞌa tà ta móndyá zyandre ɨ dré dhɨ ꞌá dhɨ, akódhɨ nɨ andre ɨ adrúpi nɨ ɨ́be dhɨ ɨ̀ dré atsázó adrélé àyɨ kɨ totó kɨvɨ̀ na. Ɨ̀ adré tá tà le tàle akódhɨ be. ");
INSERT INTO log_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Dhya àlo dré tàzoá Yésu dré dhɨ: «Ámɨ andre ɨ ámɨ adrúpi ɨ́be dhɨ ɨ̀ adré àyɨ kɨ totó kɨvɨ̀ na. Ɨ̀ adré tà le tàle mɨ́ be.» ");
INSERT INTO log_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yésu logó dhya nda dré dhɨ: «Áma andre àdhi ꞌɨ? Áma adrúpi ɨ àdhibhá ꞌɨ?» ");
INSERT INTO log_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Dré drɨ́gá bhèzo áyɨ lebèbhá ɨ véna, tàzoá dhɨ: «Mɨ̀ nò rè áma andre ɨ áma adrúpi ɨ́be kònɨ ɨ ká! ");
INSERT INTO log_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Tàko ko, dhya ángùdhi adrélépi tà áma Atá bhù na dhɨ dré adrélé lèle à kòꞌo dhɨ kɨ ꞌo dhɨ ɨ́na áma adrúpi ꞌɨ, áma amvúpi ꞌɨ, ɨ̀ndɨ̀ áma andre ꞌɨ.» ");
INSERT INTO log_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Kìtú nda sè dhɨ, Yésu dré apfòzo dzó lésè lɨ̀le lɨrɨ́lé tä́pä́ríandre mìle. ");
INSERT INTO log_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Móndɨ́ zyandre lavúlé dhɨ ɨ̀ dré ru kɨmólé akódhɨ làgásè kúrú dhɨ sè dhɨ, dré mbàzo lɨrɨ́lé bwátù na kɨtswálé tà tadhá, móndyá zyandre títí nda ɨ̀ dré adréràꞌa àyɨ kɨ totó yǐ mìle dhɨ ꞌá. ");
INSERT INTO log_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Dɨ dré kɨdhózó tà bǐ dhɨ kɨ tadhá àyɨ dré pɨ́dhɨ́gó sè, adrézó tàá dhɨ: «Mɨ̀ yi rè ká! Kìtú àlo dhɨ, agó àlo dhɨ pfò tá lɨ̀le kórɨ̀ rɨ áyɨ amvú na. ");
INSERT INTO log_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Dré tá adréràꞌa kórɨ̀ rɨ dhɨ ꞌá dhɨ, kórɨ̀ àruka ɨ̀ ledhé tá láti mìle gò, àrɨ́ ɨ̀ dré adàzo tetéá títí. ");
INSERT INTO log_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Kórɨ̀ àruka ɨ̀ ledhé tá bvò kɨ́rà ro adrélépi kìní ɨ́be tsà dhɨ dri. Ɨ̀ dré apfòzo mbèlè, kìní dré nzìle ko dhɨ sè. ");
INSERT INTO log_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Dɨ, kìtú kòka dre dhɨ, dré àyɨ kɨ zàzo ꞌyòle, àyɨ kɨ kɨ́drɨ dré fɨ̀le kìní na dóro ko dhɨ sè. ");
INSERT INTO log_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Kórɨ̀ àruka ɨ̀ ledhé tá kùtsí kòfalé gò, kùtsí nda dré mbàzo àyɨ kɨ amó. ");
INSERT INTO log_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Dɨ, kórɨ̀ àruka ɨ̀ ledhé tá àyɨkya kìní dóro dri gò, ɨ̀ dré lòꞌwa ꞌàzo dóro. Àlo nɨ ꞌa lòꞌwa nyadhɨ-nzi, àzya nɨ nyadhɨ-na, àzya nɨ nyadhɨ-àlo-drì-mudrí.» ");
INSERT INTO log_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yésu gò tàá dhɨ: «Dhya ángùdhi adrélépi bíbhálé ɨ́be tà yìzo dhɨ kòyi!» ");
INSERT INTO log_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Àmvolásà dhɨ, Yésu nɨ lebèbhá ɨ̀ dré àyɨ kɨ kisízó ànyɨ akódhɨ làga, akódhɨ nɨ lizí tàzoá dhɨ: «Mɨ́ adré tà ta móndɨ́ ɨ dré pɨ́dhɨ́gó sè àdho tà sè?» ");
INSERT INTO log_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Dɨ Yésu logó àyɨ dré dhɨ: «Gìká fè àmɨ dré tògyá Òpɨ̀ bhù àdhya nɨ tà lùzu ró dhɨ kɨ nìzo. Dɨ, fè ɨ́na tògyá nda àyɨ dré ko. ");
INSERT INTO log_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Tàko ko, dhya ángùdhi tà nìlepi bǐ dhɨ dré dhɨ, à nɨ tà dré nìle nda kɨ drì tɨmbà gò, akódhɨ dré adrézó vélé tà nìnì ɨ́be bǐ lavúlé. Dɨ, dhya ángùdhi tà nìlepi ko dhɨ dré dhɨ, à nɨ ndɨ̀ndɨ̀ tà tsà dré nìle dhɨ nɨ tɨngá. ");
INSERT INTO log_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Tà nda sè dhɨ, má adré tà ta àyɨ dré pɨ́dhɨ́gó sè. Tàko ko, tágba ɨ̀ dré adrézó ngá no dhɨ, ɨ̀ adré ngá nda kɨ no dóro ko. Tágba ɨ̀ dré adrézó tà yi dhɨ, ɨ̀ adré tà nda kɨ yi dóro ko, adrézó kpà tà nda kɨ àndu ni ko. ");
INSERT INTO log_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Dɨ tà Gìká dré tá longólé pròfétà Èsáyà tí dhɨ ɨ̀ ꞌo ru àyɨ léna kònɨ̀nɨ. Akódhɨ longó tá dhɨ: ‹Mɨ̀ nɨ adré tà yi ꞌí, dɨ, mɨ̀ kɨtswá tà mɨ̀ dré adrélé yìle nda kɨ àndu ni tàdzí ko. Mɨ̀ nɨ adré ngá no ꞌí, dɨ, mɨ̀ kɨtswá ngá mɨ̀ dré adrélé nòle nda kɨ atógyà tàdzí ko. ");
INSERT INTO log_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Tàko ko, móndyá kòdhɨ kɨ togó andírì dre. Ɨ̀ tabhó àyɨ kɨ bíbhálé, àyɨ kɨ mì dròzo dròdrò. Ɨ̀ kòꞌo tá kònɨ̀nɨ ko dhɨ, kònò ɨ̀ nɨ tá ngá no àyɨ kɨ mì sè, adrézó tà yi àyɨ kɨ bíbhálé sè, adrézó tà ni àyɨ kɨ togó na, ɨ̀ dré àyɨ kɨ togó adzázó má vélé gò, má dré àyɨ kɨ tɨdrɨ́zó.› ");
INSERT INTO log_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Dɨ, kólénzé ɨ́na àmɨ dré, àmɨ kɨ mì dré adrélé ngá no, ɨ̀ndɨ̀ àmɨ kɨ bíbhálé dré adrélé tà yi dhɨ sè! ");
INSERT INTO log_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Má adré tà bàti ta àmɨ dré: Pròfétà bǐ dhɨ ɨ móndɨ́ gyǎgya bǐ dhɨ ɨ́be dhɨ ɨ tá lovó ɨ́be tò kɨtswázó tà mɨ̀ dré adrélé nòle dhɨ kɨ no gò, ɨ̀ dré àyɨkya nòzoá ko. Àyɨ tá kpà lovó ɨ́be tò kɨtswázó tà mɨ̀ dré adrélé yìle dhɨ kɨ yi gò, ɨ̀ dré àyɨkya yìzoá ko.» ");
INSERT INTO log_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«Dɨ mɨ̀ yi rè pɨ́dhɨ́gó agó kórɨ̀ rɨ̀lepi dhɨ àdhya nda adré lèá tàle ngɨ́nɨ ya dhɨ ká. ");
INSERT INTO log_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Móndɨ́ àruka ɨ̀ adré Gìká nɨ kúlí kaꞌì ngóró kórɨ̀ rɨ̀le ledhélé láti mìle nda ɨ tɨ́nɨ. Ɨ̀ kòyi Gìká nɨ Òpɨ̀ nɨ tà dre dhɨ, ɨ̀ adré àndu nɨ nɨ ni ko gò, Dhya kònzɨ dré adrézó atsálé kórɨ̀ rɨ̀le nda nɨ tɨngɨ́ àyɨ kɨ togó lésè. ");
INSERT INTO log_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Móndɨ́ àruka ɨ̀ adré Gìká nɨ kúlí kaꞌì ngóró kórɨ̀ rɨ̀le ledhélé bvò kɨ́rà ro dhɨ dri nda ɨ tɨ́nɨ. Ɨ̀ kòyi kúlí nda dre dhɨ, ɨ̀ adré ndɨrɨ kaꞌìá arɨ́ sè. ");
INSERT INTO log_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Dɨ, ɨ̀ dré adrélé kúlí nda nɨ tayɨ́ adrélé tɨ̀le àyɨ kɨ togó na ko dhɨ sè dhɨ, ɨ̀ adré ngbà ꞌí tròle rúá lókyá tsà sè. Dɨ kàdré tà ɨ̀ dré adrézó kɨzà nya ásà dhɨ ꞌɨ yà, ngalè tà adrézó àyɨ kɨ mì pfo kúlí nda nɨ tà sè dhɨ ꞌɨ yà dhɨ, ɨ̀ adré àyɨ kɨ tà kaꞌìkaꞌì nda nɨ tayɨ́ mbèlè. ");
INSERT INTO log_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Móndɨ́ àruka ɨ̀ adré Gìká nɨ kúlí kaꞌì ngóró kórɨ̀ rɨ̀le ledhélé kùtsí kòfalé nda ɨ tɨ́nɨ. Ɨ̀ kòyi kúlí nda dre dhɨ, tà bvò kòndɨ àdhya adrébhá àyɨ kɨ togó ꞌo lanzìle dhɨ ɨ, ɨ̀ndɨ̀ ngá lovó adrélépi àyɨ kɨ lɨtɨ́ dhɨ ɨ́be dhɨ ɨ̀ adré kúlí nda nɨ amó gò, dré adrézó lòꞌwa ꞌa ko. ");
INSERT INTO log_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Dɨ, móndɨ́ àruka ɨ̀ adré àyɨkya Gìká nɨ kúlí kaꞌì ngóró kórɨ̀ rɨ̀le ledhélé kìní dóro dri nda ɨ tɨ́nɨ. Àyɨ nda ɨ̀ kòyi kúlí nda dre dhɨ, ɨ̀ adré àndu nɨ nɨ ni gò, ɨ̀ dré adrézó lòꞌwa ꞌa dóro. Àlo nɨ adré lòꞌwa ꞌa nyadhɨ-nzi, àzya nɨ nyadhɨ-na, àzya nɨ nyadhɨ-àlo-drì-mudrí.» ");
INSERT INTO log_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yésu dré gòzo pɨ́dhɨ́gó àzya pɨ àyɨ dré, tàzoá dhɨ: «Òpɨ̀ bhù àdhya sù ngóró dhya àlo kórɨ̀ dóro rɨ̀lepi áyɨ amvú na dhɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Dɨ, móndyá títí dhɨ ɨ̀ dré tá adréràꞌa ayí ko ngátsi sè dhɨ ꞌá dhɨ, akódhɨ nɨ kàrɨbhá dré ɨ́na atsázó mbɨ̀ kórɨ̀ rɨ ngánò kòfalé gò lɨ̀zo. ");
INSERT INTO log_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Dɨ ngánò nda kòmba adrélé lòꞌwa ꞌa dre dhɨ, mbɨ̀ nda dré kpà apfòzo. ");
INSERT INTO log_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Gò amvú líyí nda nɨ màrábà ɨ̀ dré alɨ̀zo akódhɨ vélé tàá drá dhɨ: ‹Mírì, mɨ́ rɨ tsì kórɨ̀ dóro ámɨ amvú na kòdhya ko? Mbɨ̀ angá dɨ ɨ́na ángolésè?› ");
INSERT INTO log_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Akódhɨ logó àyɨ dré dhɨ: ‹Kàrɨbhá ꞌo tà kòdhɨ nɨ̀.› Dɨ màrábà nda ɨ̀ gò akódhɨ nɨ lizí: ‹Mɨ́ lè mà kòlɨ̀ mbɨ̀ nda nɨ akú?› ");
INSERT INTO log_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Akódhɨ logó àyɨ dré dhɨ: ‹Kóko! Mɨ̀ kòlɨ̀ mbɨ̀ nda nɨ akú dhɨ, mɨ̀ nɨ dra akúá túmä́ní ngánò ɨ́be. ");
INSERT INTO log_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Mɨ̀ tayɨ́ àyɨ rìti dhɨ ɨ adrélé mbàle túmä́ní tsàle lókyá dra lànyá lokózó dhɨ ꞌá. Dɨ lókyá nda sè dhɨ, má nɨ tàá dhya dra lànyá lokóbhá dhɨ ɨ dré dhɨ: Mɨ̀ akú rè zyà mbɨ̀ todròle kɨtswálé zàle ꞌíká, gò mɨ̀ kòlokóró ngánò tobhàle áma kòbhó na ndò.›» ");
INSERT INTO log_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yésu dré gòzo pɨ́dhɨ́gó àzya pɨ àyɨ dré, tàzoá dhɨ: «Òpɨ̀ bhù àdhya sù ngóró mùtádì lòꞌwa dhya àlo dré dòle rɨ̀le áyɨ amvú na dhɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Lòꞌwa nda konyókonyó mvá lavúlé lòꞌwa àruka títí dhɨ ɨ rúsè. Dɨ, kàpfò dre dhɨ, dré ɨ́na mbàzo atsálé kàdrɨ̀ ngá àruka títí kidhílé amvú ꞌá dhɨ kɨ lavú. Atsá fa tɨ́nɨ gò, àrɨ́ ɨ̀ dré adrézó alɨ̀le bhà si kólá nɨ ɨ drìna.» ");
INSERT INTO log_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yésu dré gòzo pɨ́dhɨ́gó àzya pɨ àyɨ dré, tàzoá dhɨ: «Òpɨ̀ bhù àdhya sù ngóró tàkú mvá tsà tòkó àlo dré adólé amúlé fóndro kàdrɨ̀ dhɨ be gò, tàkú nda dré fóndro nda nɨ ꞌòzo avólé títí dhɨ tɨ́nɨ.» ");
INSERT INTO log_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Dɨ Yésu tà tá tà nda kòdhɨ ɨ títí móndyá zyandre ɨ dré pɨ́dhɨ́gó sè. Tà tà àlo àyɨ dré pɨ́dhɨ́gó àko dhɨ ko, ");
INSERT INTO log_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","kɨtswálé tà longólé pròfétà tí kònɨ̀dhɨ kòꞌoró ru be dhɨ bvó: «Má nɨ tà adó tàle àyɨ dré pɨ́dhɨ́gó sè. Má nɨ tà zùle kɨ́nó kɨdhólé bvò nɨ bhàma lésè dhɨ kɨ longó.» ");
INSERT INTO log_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Àmvolásà dhɨ, Yésu dré móndyá zyandre nda kɨ tayɨ́zó gò, nzɨ̀zo bhàna. Akódhɨ nɨ lebèbhá ɨ̀ dré àyɨ kɨ kisízó ànyɨ akódhɨ làga, tàá drá dhɨ: «Mɨ́ ngɨ àma dré pɨ́dhɨ́gó mbɨ̀ amvú na dhɨ àdhya nɨ àndu wà.» ");
INSERT INTO log_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Akódhɨ logó àyɨ dré dhɨ: «Dhya kórɨ̀ dóro rɨ̀lepi nda, Móndɨ́ nɨ Mvá ꞌɨ. ");
INSERT INTO log_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Amvú nda bvò ꞌɨ. Kórɨ̀ dóro nda, Gìká nɨ ànzɨ akódhɨ nɨ Òpɨ̀ na dhɨ ꞌɨ. Mbɨ̀ nda, Dhya kònzɨ nɨ ànzɨ ꞌɨ. ");
INSERT INTO log_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Kàrɨbhá mbɨ̀ kórɨ̀ rɨ̀lepi nda, Dzáborò ꞌɨ. Lókyá lànyá lokózó nda, lókyá kùdù ꞌɨ. Dhya adrébhá lànyá lokó nda ɨ, ángéló ꞌɨ. ");
INSERT INTO log_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Dɨ ngóró à dré adrélé mbɨ̀ nda nɨ akú kɨtswálé zàle àtsɨ́ na dhɨ tɨ́nɨ dhɨ, a nɨ kókpà adré kònɨ̀nɨ lókyá kùdù sè. ");
INSERT INTO log_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Móndɨ́ nɨ Mvá nɨ áyɨ ángéló kɨ amù, tà títí adrébhá móndɨ́ kɨ ꞌo ledhélé tàkonzɨ̀ na dhɨ kɨ akú túmä́ní móndyá títí adrébhá tà kònzɨ ꞌo dhɨ ɨ́be, àyɨ kɨ tɨngázó pfòle Gìká nɨ Òpɨ̀ ꞌásè. ");
INSERT INTO log_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Dɨ ángéló nda ɨ̀ dré àyɨ kɨ bhèzo àtsɨ́ adrélépi adrálé ko dhɨ na. Kònàle dhɨ, ɨ̀ nɨ adré tongólé, adrézó kpà síkálándrá tsɨ. ");
INSERT INTO log_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Dɨ, móndyá gyǎgya dhɨ kɨ adré àyɨkya lagúlé kìtú tɨ́nɨ àyɨ kɨ Atá nɨ Òpɨ̀ na. Dhya ángùdhi adrélépi bíbhálé ɨ́be tà yìzo dhɨ kòyi!» ");
INSERT INTO log_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","«Òpɨ̀ bhù àdhya sù ngóró ngá làgɨ́ kyàkyà zùle amvú àlo na dhɨ tɨ́nɨ. Agó àlo dhɨ kisú tá ngá làgɨ́ kyàkyà nda gò, gòzo zùá tódhyá. Dɨ togó kɨ̀nɨ́ dré dhɨ, dré lɨ̀zo áyɨ ngá títí dhɨ kɨ lagɨ́ gò, amvú nda nɨ gɨ̀zo ɨ́ dré.» ");
INSERT INTO log_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","«Òpɨ̀ bhù àdhya sù kpà ngóró agó àlo adrélépi tá màyɨ̀kà aveave dhɨ kɨ nda dhɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Akódhɨ kòkisú màyɨ̀kà àlo làgɨ́ kyàkyà dhɨ dre dhɨ, dré lɨ̀zo áyɨ ngá títí dhɨ kɨ lagɨ́ gò, gɨ̀zoá.» ");
INSERT INTO log_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«Òpɨ̀ bhù àdhya sù ngóró kɨmbá à dré bhèle yǐandre na gò, dré kosyá kɨ kárá títí dhɨ kɨ turúzó dhɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Kɨmbá nda kòga kosyá sè bǐ dre dhɨ, kosyá bhebhá ɨ̀ dré asézóá apfòle yǐ mìle. Dɨ ɨ̀ dré lɨrɨ́zó kosyá dóro dhɨ kɨ kɨpè tobhàle kánzɨ̀ ɨ ꞌásè gò, kosyá kònzɨ dhɨ kɨ bhèzo. ");
INSERT INTO log_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Tà nda nɨ kókpà adré kònɨ̀nɨ lókyá kùdù sè. Ángéló kɨ alɨ̀ móndyá kònzɨ kɨ kòfalé lanzɨ́ móndyá gyǎgya ɨ́be gò, ");
INSERT INTO log_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ɨ̀ dré móndyá kònzɨ nda kɨ bhèzo àtsɨ́ adrélépi adrálé ko dhɨ na. Kònàle dhɨ, ɨ̀ nɨ adré tongólé, adrézó kpà síkálándrá tsɨ.» ");
INSERT INTO log_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Dɨ Yésu lizí àyɨ tàzoá dhɨ: «Mɨ̀ yi tà kòdhɨ ɨ títí, àndu nɨ kɨ nìzo vélé?» Ɨ̀ logó drá dhɨ: «Àyíya!» ");
INSERT INTO log_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Akódhɨ gò tàá àyɨ dré dhɨ: «Dɨ dhya ángùdhi adrélépi tátrɨ́trɨ́ kúlí tadhá gò Òpɨ̀ bhù àdhya nɨ tà tadházó drá dhɨ, dhya nda ngóró bhà líyí adrélépi ngá làgɨ́ be kàdrɨ̀ dhɨ ɨ́be gò, dré adrézó ngá tɨ́dhɨ́ dhɨ kɨ adó lásà ngá àku dhɨ ɨ́be dhɨ tɨ́nɨ.» ");
INSERT INTO log_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yésu kòpɨ pɨ́dhɨ́gó nda ɨ akɨ́lé dre dhɨ, dré àrà nda nɨ tayɨ́zó gò, ");
INSERT INTO log_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","lɨ̀zo tsàle bhàandre ɨ́ dré tá mbàzo lána dhɨ na. Dɨ dré kɨdhózó adrélé tà tadhá Yúdà ànzɨ kɨ lɨ̀sámbò dzó na. Gò móndyá nda ɨ̀ dré adrézó akódhɨ nɨ yi síbhálé be ngbo, adrézó lizíá àyɨ kòfalésè dhɨ: «Dhya kòndɨ kisú ɨ́na tògyá kòdhɨ túmä́ní rìnyí adrézó tà lɨ́ndrɨ́ga ró dhɨ kɨ ꞌo dhɨ be dhɨ ángwà? ");
INSERT INTO log_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Akódhɨ kòndɨ tsì dhya adrélépi fa ledé dhɨ nɨ mvá ꞌɨ ko? Andre nɨ nɨ rú tsì Màrɨ́yà ko? Adrúpi nɨ ɨ tsì, Yàkóbhò, Yòséfà, Sìmónà tsàle Yúdà ko? ");
INSERT INTO log_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Amvúpi nɨ ɨ títí àma kòfalé ko? Akódhɨ kisú dɨ tà kòdhɨ ɨ títí dhɨ ángwà?» ");
INSERT INTO log_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Dɨ tà nda sè dhɨ, ɨ̀ kɨtswá tá Yésu nɨ kaꞌì bwà ko. Dɨ Yésu dré tàzoá àyɨ dré dhɨ: «À adré ngbà ꞌí pròfétà nɨ lɨndrɨ̀ bha ko dhɨ akódhɨ nɨ tàndɨ bha ɨ̀ndɨ̀ akódhɨ nɨ tàndɨ nɨ dzó ꞌá.» ");
INSERT INTO log_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Dɨ akódhɨ ꞌo tá tà lɨ́ndrɨ́ga ró bǐ dhɨ ɨ kònàle ko, ɨ̀ dré akódhɨ nɨ kaꞌìle ko dhɨ sè. ");
INSERT INTO log_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Lókyá nda sè dhɨ, Èródè adrélépi tá ópɨ́ ro bvò Gàlìláyà àdhya drìle dhɨ dré Yésu nɨ rúbí yìzo. ");
INSERT INTO log_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Dré tàzoá áyɨ màrábà ɨ dré dhɨ: «Dhya kòdhɨ Yòwánɨ̀ Bàtísimò fèlepi ꞌɨ! Angá ɨ́na dràdrà lésè nɨ̀. Ásà dhɨ, akódhɨ rìnyí ɨ́be adrézó tà lɨ́ndrɨ́ga ró dhɨ kɨ ꞌo.» ");
INSERT INTO log_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Tàko ko, Èródè nda ꞌo tá Yòwánɨ̀ rùle adròle, bhèle bǎdzó na dhɨ nɨ̀. ꞌO tá kònɨ̀nɨ áyɨ adrúpi Fìlípò nɨ tòkó, Èròdɨ́yà nɨ tà sè. ");
INSERT INTO log_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Àngyá ko, Yòwánɨ̀ adré tá tàá Èródè dré dhɨ: «Kɨtswá mɨ́ dré adrézó ámɨ adrúpi nɨ tòkó ɨ́be dhɨ ko.» ");
INSERT INTO log_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ásà dhɨ, Èródè adré tá Yòwánɨ̀ nɨ le pfùle dràle. Dɨ, adré tá ɨ́na móndɨ́ zyandre dhɨ kɨ ro, ɨ̀ dré adrélé Yòwánɨ̀ nɨ no pròfétà ro dhɨ sè. ");
INSERT INTO log_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Dɨ, kìtú Èródè nɨ tìzo ásà dhɨ sè dhɨ, Èròdɨ́yà nɨ zapi dré apfòzo ngá to Èródè ɨ kandrá móndyá dré azílé gwányá lé dhɨ ɨ́be gò, tà nda dré Èródè nɨ togó ꞌòzo kɨnɨ́lé tò. ");
INSERT INTO log_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Dɨ akódhɨ dré mòndrà sɨ̀zo tàzoá dhɨ, ɨ́ nɨ ngá ángùdhi mvátòkó nda dré lèle zìle ɨ́ tí dhɨ nɨ fe drá. ");
INSERT INTO log_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Dɨ andre nɨ kòtà akódhɨ nɨ drì dre dhɨ, akódhɨ dré tàzoá Èródè dré dhɨ: «Mɨ́ kàfè má dré Yòwánɨ̀ Bàtísimò fèlepi nɨ drì kònwa sǎnɨ̀ na.» ");
INSERT INTO log_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Gò ópɨ́ nda nɨ togó dré kɨzà nyàzo tà nda sè. Dɨ, mòndrà dré tá sɨ̀le móndyá azílé nda ɨ kandrá dhɨ ɨ sè dhɨ, dré ɨ́na tòlɨ́ fèzo tà zìle nda nɨ ꞌòzo gò, ");
INSERT INTO log_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","móndɨ́ mùzo lɨ̀le Yòwánɨ̀ nɨ drì li bǎdzó na. ");
INSERT INTO log_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Gò akódhɨ nɨ drì nda nɨ adózó sǎnɨ̀ na alɨ̀zo fèá mvátòkó nda dré. Dɨ akódhɨ nda dré fèzoá áyɨ andre dré. ");
INSERT INTO log_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Bvóá dhɨ, Yòwánɨ̀ nɨ lebèbhá ɨ̀ dré tsàzo akódhɨ nɨ àbvò do sìle. Gò ɨ̀ dré lɨ̀zo tà nda nɨ longó Yésu dré. ");
INSERT INTO log_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yésu kòyi rúbí nda dre dhɨ, dré mbàzo bwátù na kɨtswálé lɨ̀le kalóma àrà móndɨ́ àko dhɨ na dhɨ bvó. Dɨ, móndɨ́ zyandre dhɨ ɨ̀ kòyi tà nda dre dhɨ, ɨ̀ dré ngàzo bhàandre bǐ dhɨ ɨ lésè lɨ̀le akódhɨ vésè pá sè, tä́pä́ríandre mìlésè. ");
INSERT INTO log_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Dɨ Yésu kàsí bwátù lésè dre dhɨ, dré móndyá zyandre lavúlé nda kɨ nòzo, kɨzà dòzo áyɨ togó na àyɨ kɨ tà sè gò, dré àyɨ kɨ dràbhá kɨ tɨdrɨ́zó. ");
INSERT INTO log_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ɨ̀ndró kàndrɨ̀ dre dhɨ, akódhɨ nɨ lebèbhá ɨ̀ dré àyɨ kɨ kisízó ànyɨ akódhɨ làga, tàá drá dhɨ: «Kònɨ̀dhɨ àrà bhà àko dhɨ ꞌɨ, ɨ̀ndɨ̀ lókyá lavú dre. Mɨ́ kòfè dɨ láti móndyá zyandre kònɨ ɨ dré lɨ̀zo mányàngá gɨ nyàle bhà àma làgásè dhɨ ɨ ꞌásè wà.» ");
INSERT INTO log_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Dɨ, Yésu logó àyɨ dré dhɨ: «Kɨtswá ɨ̀ dré lɨ̀zo dhɨ ko. Àmɨ kɨ tàndɨ, mɨ̀ kòfè ngá àyɨ dré nyàle dhɨ àmɨ.» ");
INSERT INTO log_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Dɨ, ɨ̀ logó drá dhɨ: «Àma ngbà ꞌí kònwa dhɨ mápà ɨ́be nzi, ɨ̀ndɨ̀ kosyá ɨ́be rì.» ");
INSERT INTO log_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yésu gò tàá dhɨ: «Mɨ̀ alɨ̀ ngá nda ɨ́be má vélé.» ");
INSERT INTO log_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Gò dré tàzoá móndyá zyandre nda ɨ dré dhɨ, ɨ̀ kòlɨrɨ́ mbɨ̀ dri. Dɨ kàdó mápà nzi nda ɨ kosyá rì nda ɨ́be dre dhɨ, dré mì tɨngázó kurú na bhù na, tà tanɨ zìzo Gìká tí ngá nda ɨ dri. Dré mápà nda kɨ toŋòzo lanzɨ́lé áyɨ lebèbhá ɨ dré gò, ɨ̀ dré lanzɨ́zóá móndyá zyandre ɨ dré. ");
INSERT INTO log_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Dɨ àyɨ títí nda ɨ̀ dré nyàzoá pìzo. Gò akódhɨ nɨ lebèbhá ɨ̀ dré àmbí nɨ kɨ lokózó gàle kánzɨ̀ mudrí-drì-rì dhɨ ɨ sè bǐbi. ");
INSERT INTO log_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Àgo ngá nda kɨ nyabhá dhɨ ɨ tá ànyɨ́ànyɨ ngùlù-nzi. (À nà tá tòkó ɨ ànzɨmvá ɨ́be ko.) ");
INSERT INTO log_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Gbǎ lókyá nda sè dhɨ, Yésu dré áyɨ lebèbhá kɨ ꞌòzo lɨ̀le mbàle bwátù na, ɨ̀ kòzyaró drìdrì ɨ́ kandrána tä́pä́ríandre nɨ taꞌá na. Tàko ko, lè tá rè zyà láti fèle móndyá zyandre nda ɨ dré lɨ̀zo ꞌíká. ");
INSERT INTO log_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Kòfè láti àyɨ dré dre dhɨ, dré mbàzo kalóma kòngó àlo drìna kɨtswálé tà ta Gìká be. Gò ngá dré anízó akódhɨ nɨ kɨ kònàle kalóma. ");
INSERT INTO log_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Dɨ, bwátù nda lɨ̀ tá ɨ́na vwàle kìní rúsè vwàvwà ro. Lyǎandre adré tá vìle sɨ́nyà dri rúá gò, yǐ adrélépi longálé dhɨ dré adrézó ru tswa rúá. ");
INSERT INTO log_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Dɨ ngátsi kɨ́tógá àmvolésè dhɨ, Yésu dré ngàzo adrélé atsí to tä́pä́ríandre drǐsè, adrézó lɨ̀le áyɨ lebèbhá nda ɨ véna. ");
INSERT INTO log_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ɨ̀ kònò akódhɨ adréràꞌa atsí to tä́pä́ríandre drǐsè dre dhɨ, tirì dré gàzo àyɨ léna bǐ gò, ɨ̀ dré tàzoá dhɨ: «Kòdhɨ móndɨ́ lɨ́ndrɨ́ ꞌɨ!» Gò ɨ̀ dré ngàzo adrélé tetrélé tirì dré. ");
INSERT INTO log_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Dɨ, gbǎ kòdhwa, Yésu dré tàzoá àyɨ dré dhɨ: «Mɨ̀ tsɨ togó! Ma ꞌɨ. Mɨ̀ ro ngá ko.» ");
INSERT INTO log_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pétèró logó drá dhɨ: «Mírì, kàdré mɨ ꞌɨ bàti dhɨ, mɨ́ tà má dré má kòlɨ̀ró mɨ́ véna yǐ drǐsè wà.» ");
INSERT INTO log_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yésu gò tàá drá dhɨ: «Mɨ́ alɨ̀!» Dɨ Pétèró dré pfòzo bwátù ꞌásè gò, kɨdhólé atsí to yǐ drǐsè, adrézó lɨ̀le Yésu véna. ");
INSERT INTO log_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Dɨ, kònò lyǎandre nda dre dhɨ, tirì dré akódhɨ nɨ ꞌòzo gò, dré kɨdhózó adrélé tandrùle. Dɨ dré loyózóá dhɨ: «Mírì, mɨ́ tɨdrɨ́ ma wà!» ");
INSERT INTO log_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Gbǎ kòdhwa, Yésu dré áyɨ drɨ́gá kɨdzɨ̀zo akódhɨ nɨ ru gò, tàzoá drá dhɨ: «Mɨ tà kaꞌìkaꞌì ɨ́be tsà nɨ, mɨ́ kayí tà mɨ́ léna àdho tà sè?» ");
INSERT INTO log_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ɨ̀ kòmbà fɨ̀le bwátù na dre dhɨ, lyǎandre nda dré rɨ̀zo adrélé kɨ́rɨ. ");
INSERT INTO log_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Dɨ Yésu nɨ lebèbhá bwátù na nda ɨ̀ dré ledhézó àyɨ kɨ kórókó titì akódhɨ kandrá, tàzoá dhɨ: «Mɨ Gìká nɨ Mváagó ꞌɨ bàti!» ");
INSERT INTO log_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ɨ̀ kòzya tä́pä́ríandre nda nɨ taꞌá na dre dhɨ, ɨ̀ dré tsàzo bvò Gènèsàrétè àdhya na. ");
INSERT INTO log_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Móndyá kònàle dhɨ ɨ̀ kònò Yésu nìle kyá dre dhɨ, ɨ̀ dré ngàzo akódhɨ nɨ rúbí ꞌo ayɨ́lé bvò wä́yi nda ꞌásè. Dɨ móndɨ́ ɨ̀ dré àyɨ kɨ dràbhá títí dhɨ kɨ adzízó akódhɨ vélé gò, ");
INSERT INTO log_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","akódhɨ nɨ ti lizízó, kòtayɨ́ró dràbhá nda ɨ adrélé ngbà ꞌí áyɨ kɨ́tá ti tabè kòdhya. Dɨ àyɨ títí akódhɨ nɨ kɨ́tá nda nɨ tabèbhá dhɨ ɨ̀ dré adrɨ́zó. ");
INSERT INTO log_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Àmvolásà dhɨ, Fàrìsáyò àruka ɨ tátrɨ́trɨ́ kúlí tadhábhá ɨ́be dhɨ ɨ̀ dré angázó Yèrúsalémà lésè alɨ̀le Yésu vélé gò, lizíá tíá dhɨ: ");
INSERT INTO log_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Ámɨ lebèbhá ɨ̀ adré àma kɨ tábhí kɨ labhɨ ŋo àdho tà sè? Àngyá ko, ɨ̀ adré àyɨkya ngá nya drɨ́gá dzɨ àko ró.» ");
INSERT INTO log_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yésu dré logózóá àyɨ dré dhɨ: «Àmɨ ró dhɨ, mɨ̀ adré àmɨkya Gìká nɨ tòlɨ́ ŋo, kɨtswázó àmɨ kɨ labhɨ lɨkɨ́ àdho tà sè? ");
INSERT INTO log_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Tàko ko, Gìká tà tá dhɨ: ‹Lè mɨ́ kàdré ámɨ atá nɨ lɨndrɨ̀ bha ámɨ andre be.› Tà kpà dhɨ: ‹Dhya ángùdhi adrélépi tà kònzɨ ta áyɨ atá rú yà, kó ngalè áyɨ andre rú yà dhɨ, lè à kòꞌo akódhɨ nda dràle dràdrà.› ");
INSERT INTO log_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Dɨ, mɨ̀ adré àmɨkya tàá dhɨ, dhya àlo kòtà áyɨ atá dré yà, kó ngalè áyɨ andre dré yà dhɨ, ‹Ngá má dré tá kɨtswálé fèle ámɨ ledé dhɨ, ngá má dré dra fèle Gìká dré dhɨ ꞌɨ› dhɨ, ");
INSERT INTO log_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","adré dɨ lèá vélé dhya nda kòbhà áyɨ atá nɨ lɨndrɨ̀ áyɨ andre be ngá nda sè dhɨ ko. Dɨ ásà dhɨ, mɨ̀ adré àmɨkya Gìká nɨ kúlí bhe gàrà dri, adrézó àmɨ kɨ tàndɨ kɨ labhɨ lebè. ");
INSERT INTO log_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Àmɨ túrúpfúbhá ꞌɨ! Pròfétà Èsáyà dré tá adréràꞌa Gìká nɨ kúlí longó àmɨ kɨ tà sè dhɨ ꞌá dhɨ, longó tá tà nda kyá tàzoá dhɨ: ");
INSERT INTO log_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‹Móndyá kòdhɨ ɨ̀ adré áma lɨndrɨ̀ bha ngbà ꞌí ti sè. Dɨ, àyɨ kɨ togó vwà ɨ́na má rúsè vwàvwà. ");
INSERT INTO log_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ɨ̀ adré lɨ̀sámbò ꞌo má dré wóyá. Tàko ko, ɨ̀ adré tòlɨ́ angábhá móndɨ́ ɨ vélésè dhɨ kɨ tadhá ngóró tòlɨ́ nda ɨ̀ angá tá má vélésè na tɨ́nɨ.›» ");
INSERT INTO log_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Gò Yésu dré móndyá zyandre kònàle dhɨ kɨ azízó, tàzoá àyɨ dré dhɨ: «Mɨ̀ yi vo rè tà kònɨ̀dhɨ, àndu nɨ nɨ nìzo ká! ");
INSERT INTO log_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ngá adrélépi fɨ̀le móndɨ́ nɨ síbhálé ꞌásè dhɨ adré akódhɨ nɨ ꞌo atsálé ndǐ ró dhɨ nɨ̀ ko. Be ró dhɨ, tà adrélépi apfòle móndɨ́ sílésè dhɨ adré ɨ́na akódhɨ nɨ ꞌo atsálé ndǐ ró dhɨ nɨ̀.» ");
INSERT INTO log_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Gò Yésu nɨ lebèbhá ɨ̀ dré àyɨ kɨ kisízó ànyɨ akódhɨ làga, tàá drá dhɨ: «Mɨ́ nì, tà mɨ́ dré tàle kòdhɨ dhe Fàrìsáyò ɨ léna kònzɨ dhɨ be?» ");
INSERT INTO log_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Akódhɨ logó àyɨ dré dhɨ: «Fa ángùdhi áma Atá bhù na dhɨ dré kidhílé nɨ̀ ko dhɨ, à nɨ tɨngɨ́á. ");
INSERT INTO log_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Mɨ̀ tayɨ́ àyɨ nda ɨ. Àyɨ mì kùdúkùdu kɨ drì kobhá mì kùdúkùdu ró dhɨ ꞌɨ. Dɨ mì kùdúkùdu àlo dhɨ kàdré mì kùdúkùdu àzya se drìle dhɨ, àyɨ rìti nda kɨ ledhé bhú na.» ");
INSERT INTO log_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Gò Pétèró dré tàzoá drá dhɨ: «Mɨ́ ngɨ kúlí alaala mɨ́ dré tàle nda nɨ àndu àma dré wà.» ");
INSERT INTO log_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Dɨ Yésu logó dhɨ: «Àmɨ, àmɨ dhu rè tà nìnì àko? ");
INSERT INTO log_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Mɨ̀ nì ko tàle dhɨ, ngá ángùdhi adrélépi fɨ̀le móndɨ́ nɨ síbhálé ꞌásè dhɨ adré fɨ̀le akódhɨ nɨ ꞌa na gò, adrélé apfòle akódhɨ nɨ rúbhá lésè dhɨ? ");
INSERT INTO log_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Dɨ, tà ángùdhi adrélépi apfòle móndɨ́ sílésè dhɨ adré ɨ́na angálé akódhɨ nɨ togó lésè. Tà nda ɨ́na tà adrélépi móndɨ́ ꞌo atsálé ndǐ ró dhɨ ꞌɨ. ");
INSERT INTO log_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tàko ko, tà adrébhá apfòle móndɨ́ kɨ togó lésè dhɨ ɨ, tà kònɨ ꞌɨ: tà kònzɨ kisùle dhɨ ɨ, móndɨ́ kɨ tupfuma nɨ tà, múná tà, ndòtò tà, kugù tà, tà tàma móndɨ́ ɨ rú kɨnzò sè dhɨ nɨ tà, ɨ̀ndɨ̀ móndɨ́ kɨ rú tàma kònzɨ dhɨ nɨ tà. ");
INSERT INTO log_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Tà nda kòdhɨ ɨ̀ adré móndɨ́ kɨ ꞌo atsálé ndǐ ró dhɨ nɨ̀. Dɨ, ngá nyàma drɨ́gá dzɨ àko ró dhɨ adré ɨ́na móndɨ́ kɨ ꞌo atsálé ndǐ ró ko.» ");
INSERT INTO log_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Àmvolásà dhɨ, Yésu dré àrà nda nɨ tayɨ́zó gò, lɨ̀zo tsàle bvò Tírè ɨ làga Sìdónà be dhɨ na. ");
INSERT INTO log_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Dɨ Kànánà tòkó àlo bvò nda lésè dhɨ dré alɨ̀zo akódhɨ vélé gò, kɨdhólé adrélé loyóá dhɨ: «Mírì, Dàwídì nɨ Mvá, mɨ́ bhà áma kɨzà wà! Áma zapi tɨrɨ́ kònzɨ ɨ́be ɨ́ léna. Adré kɨzà nya lavúlé.» ");
INSERT INTO log_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Dɨ, Yésu logó ɨ́na kúlí drá ko. Gò akódhɨ nɨ lebèbhá ɨ̀ dré àyɨ kɨ kisízó ànyɨ akódhɨ làga, tàá drá dhɨ: «Mɨ́ dro akódhɨ nzɨ̀le. Tàko ko, akódhɨ adré tetrélé àma àmvolésè tò.» ");
INSERT INTO log_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yésu logó dhɨ: «Gìká amù ma ngbà ꞌí Ɨ̀sèrélè ànzɨ avɨ̀bhá kábilígyà ɨ tɨ́nɨ dhɨ ɨ vélé.» ");
INSERT INTO log_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Dɨ, tòkó nda dré ɨ́na adhézó áyɨ kórókó titì akódhɨ kandrá, tàzoá drá dhɨ: «Mírì, mɨ́ ledé ma wà!» ");
INSERT INTO log_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yésu gò logóá dhɨ: «Kɨtswá ànzɨmvá kɨ mápà dòzo bhèle kòkɨ́ ɨ dré dhɨ ko.» ");
INSERT INTO log_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Dɨ, tòkó nda tà drá dhɨ: «Mírì, kònɨ̀nɨ bàti. Dɨ, ndɨ̀ndɨ̀ kòkɨ́ ɨ̀ adré àyɨkya mápà kórònyá adrébhá ledhélé àyɨ kɨ líyí nɨ mɨ́sá zàle dhɨ kɨ nya kòdhya.» ");
INSERT INTO log_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yésu logó drá dhɨ: «Á! Tòkó, mɨ tà kaꞌìkaꞌì ɨ́be kàdrɨ̀! Tà nda kòꞌo ru mɨ́ dré ngóró mɨ́ dré adrélé lèle dhɨ tɨ́nɨ.» Dɨ tòkó nda nɨ zapi dré adrɨ́zó gbǎ lókyá nda sè. ");
INSERT INTO log_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yésu kòtayɨ́ àrà nda dre dhɨ, dré lɨ̀zo tsàle tä́pä́ríandre Gàlìláyà àdhya làgana. Dɨ dré mbàzo kòngó àlo drìna gò lɨrɨ́lé. ");
INSERT INTO log_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Gò móndɨ́ zyandre lavúlé dhɨ ɨ̀ dré alɨ̀zo túmä́ní mèrèkpè ɨ́be, mì kùdúkùdu ɨ́be, móndɨ́ rúbhá be àbvò ro dhɨ ɨ́be, ábhä́bhä́ ɨ́be, ɨ̀ndɨ̀ dràbhá àruka bǐ dhɨ ɨ́be, àyɨ kɨ tobhà Yésu kandrá. Gò akódhɨ dré àyɨ kɨ tɨdrɨ́zó títí. ");
INSERT INTO log_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Dɨ móndyá zyandre nda kɨ lɨ́ndrɨ́ dré gàzo bhwǎbhwa. Tàko ko, ɨ̀ nò tá ábhä́bhä́ nda ɨ adréràꞌa kúlí ta, móndyá rúbhá be àbvò ro nda ɨ adréràꞌa adrɨ́lé, mèrèkpè nda ɨ adréràꞌa atsí to, ɨ̀ndɨ̀ mì kùdúkùdu nda ɨ adréràꞌa ngá no. Gò ɨ̀ dré Gìká Ɨ̀sèrélè ànzɨ kya nɨ rú bhàzo kùle. ");
INSERT INTO log_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Àmvolásà dhɨ, Yésu dré áyɨ lebèbhá kɨ azízó, tàzoá àyɨ dré dhɨ: «Má adré kɨzà do áma togó na móndyá zyandre kònɨ kɨ tà sè. Tàko ko, àma túmä́ní àyɨ ɨ́be kìtú na, ɨ̀ndɨ̀ ngá ɨ̀ dré kɨtswálé nyàle dhɨ vélé yókódhó. Dɨ má lè àyɨ kɨ logólé nzɨ̀le tàbirí be ko, ɨ̀ kòlandèró ledhézó láti bhálé ko dhɨ sè.» ");
INSERT INTO log_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Dɨ akódhɨ nɨ lebèbhá ɨ̀ logó drá dhɨ: «Àrà bhà àko kònɨ̀dhɨ ꞌá dhɨ, mà nɨ kɨtswá mápà kisú fèle móndyá zyandre kònɨ ɨ dré nyàle pìzo ásà dhɨ ángwà?» ");
INSERT INTO log_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yésu lizí àyɨ tí dhɨ: «Àmɨ mápà ɨ́be ángopɨ́?» Ɨ̀ logó dhɨ: «Nzi-drì-rì, ɨ̀ndɨ̀ kosyá àruka tsàtsà dhɨ ɨ́be.» ");
INSERT INTO log_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Gò Yésu dré tàzoá móndyá zyandre nda ɨ dré dhɨ, ɨ̀ kòlɨrɨ́ bvò dri. ");
INSERT INTO log_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Dré mápà nzi-drì-rì nda kɨ adózó kosyá nda ɨ́be, àwoyà fèzo Gìká dré gò, toŋòzoá lanzɨ́lé áyɨ lebèbhá ɨ dré gò, ɨ̀ dré lanzɨ́zóá móndyá zyandre nda ɨ dré. ");
INSERT INTO log_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Dɨ móndyá títí nda ɨ̀ dré nyàzoá pìzo. Gò akódhɨ nɨ lebèbhá ɨ̀ dré àmbí nɨ kɨ lokózó gàle kánzɨ̀ nzi-drì-rì dhɨ ɨ sè bǐbi. ");
INSERT INTO log_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Àgo ngá nyabhá nda ɨ tá ngùlù-su. (À nà tá tòkó ɨ ànzɨmvá ɨ́be ko.) ");
INSERT INTO log_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Gò Yésu dré láti fèzo móndyá zyandre nda ɨ dré nzɨ̀zo. Dré mbàzo bwátù na gò, zyàle tsàle bvò Màgàdánà àdhya na. ");
INSERT INTO log_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Àmvolásà dhɨ, Fàrìsáyò ɨ Sàdùkáyò ɨ́be dhɨ ɨ̀ dré àyɨ kɨ kisízó ànyɨ Yésu làga, kɨtswálé akódhɨ nɨ tabhì. Dɨ ɨ̀ dré akódhɨ nɨ ti lizízó, kòꞌoró tà àlo lɨ́ndrɨ́ga ró angálépi Gìká vélésè dhɨ. ");
INSERT INTO log_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Dɨ Yésu dré logózóá àyɨ dré dhɨ: «Ɨ̀ndró sè, bhù mìbhalé kàdré wà dhɨ, mɨ̀ adré tàá dhɨ: ‹Kìdru, kozya kɨtswá dhìle ko.› ");
INSERT INTO log_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Drùbhì sè, bhù mìbhalé kàdré ngbàràngbàrà ro dhɨ, mɨ̀ adré tàá dhɨ: ‹Ándrò, kozya nɨ dhi.› Mɨ̀ nì kó bhù mìbhalé nɨ làsú lanzɨ́lé dhɨ be dhɨ, mɨ̀ kɨtswá dɨ àmɨkya tà adrébhá lókyá twátwa dhɨ kɨ tadhá dhɨ kɨ ni lanzɨ́lé bwà ko àdho tà sè? ");
INSERT INTO log_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Móndyá ándrò adrébhá kònzɨ ɨ̀ndɨ̀ zàràbhù ro dhɨ ɨ̀ adré tà lɨ́ndrɨ́ga ró dhɨ nɨ nda nòle. Dɨ, à kɨtswá tà àzya lɨ́ndrɨ́ga ró dhɨ nɨ ꞌo àyɨ dré nòle dhɨ ko, kàdré ngbà ꞌí pròfétà Yónà àdhya ꞌɨ ko dhɨ.» Gò Yésu dré àyɨ kɨ tayɨ́zó, lɨ̀zo. ");
INSERT INTO log_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yésu ɨ lebèbhá nɨ ɨ́be dhɨ ɨ̀ kòzya tä́pä́ríandre nɨ taꞌá na dre dhɨ, lebèbhá nɨ nda ɨ̀ dré atógyàzoá dhɨ, ɨ̀ tɨvɨ̀ tá mápà dòma atsí na dhɨ. ");
INSERT INTO log_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Gò Yésu dré tàzoá àyɨ dré dhɨ: «Mɨ̀ kònò dóro, mɨ̀ kàdréró àmɨ kɨ lɨkɨ́ tàkú Fàrìsáyò kya Sàdùkáyò ɨ́be dhɨ nɨ tà sè.» ");
INSERT INTO log_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Dɨ akódhɨ nɨ lebèbhá ɨ̀ dré ngàzo adrélé tà kayí àyɨ kòfalésè adrézó tàá dhɨ: «Akódhɨ tà kònɨ̀nɨ, mà dré mápà adólé ko dhɨ sè.» ");
INSERT INTO log_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yésu dré tà ɨ̀ dré adrélé tàle nda nɨ nìzo kyá gò, tàzoá àyɨ dré dhɨ: «Àmɨ tà kaꞌìkaꞌì ɨ́be tsà nɨ ɨ, mɨ̀ adré àmɨkya tà kayí àmɨ kòfalésè mɨ̀ dré adrélé mápà àko dhɨ sè àdho tà sè? ");
INSERT INTO log_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Mɨ̀ nì vo dhu rè tà àlo ko? Mɨ̀ tɨvɨ̀ vo àmɨkya mápà nzi má dré lanzɨ́lé móndyá ngùlù-nzi dhɨ ɨ dré dhɨ kɨ tà dre? Mɨ̀ gò tá àmbí nɨ kɨ lokó gàle kánzɨ̀ ángopɨ́? ");
INSERT INTO log_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Mɨ̀ tɨvɨ̀ kókpà àmɨkya mápà nzi-drì-rì má dré lanzɨ́lé móndyá ngùlù-su dhɨ ɨ dré dhɨ kɨ tà dre? Mɨ̀ gò tá àmbí nɨ kɨ lokó gàle kánzɨ̀ ángopɨ́? ");
INSERT INTO log_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Mɨ̀ nì ko tàle dhɨ, má adré tá mápà tà ta àmɨ dré kòdhya ko dhɨ? Dɨ, má tà tá mána dhɨ: ‹Mɨ̀ kàdré àmɨ kɨ lɨkɨ́ tàkú Fàrìsáyò kya Sàdùkáyò ɨ́be dhɨ nɨ tà sè.›» ");
INSERT INTO log_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Gò lebèbhá nɨ ɨ̀ dré nìzoá tàle dhɨ, akódhɨ adré tá tàá àyɨ dré dhɨ, ɨ̀ kàdré àyɨ kɨ lɨkɨ́ tàkú mápà àdhya nɨ tà sè ko. Be ró dhɨ, ɨ̀ kàdré àyɨ kɨ lɨkɨ́ tà Fàrìsáyò ɨ̀ dré tá adrélé tadhálé Sàdùkáyò ɨ́be dhɨ kɨ tà sè. ");
INSERT INTO log_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Àmvolásà dhɨ, Yésu ɨ̀ dré lɨ̀zo tsàle bvò bhàandre Kàyìsàríyà Fìlípò àdhya làga dhɨ na. Gò akódhɨ dré lizízóá àyɨ tí dhɨ: «Móndɨ́ ɨ̀ adré tàá dhɨ, ma, Móndɨ́ nɨ Mvá àdhi ꞌɨ?» ");
INSERT INTO log_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ɨ̀ logó drá dhɨ: «Móndɨ́ àruka ɨ̀ adré tàá dhɨ, mɨ Yòwánɨ̀ Bàtísimò fèlepi ꞌɨ. Àruka nɨ ɨ̀ adré tàá dhɨ, mɨ Èlɨ́yà ꞌɨ. Àruka nɨ ɨ̀ adré kó tàá dhɨ, mɨ Yèrèmɨ́yà ꞌɨ yà, kó ngalè pròfétà kɨ àzya ꞌɨ yà dhɨ.» ");
INSERT INTO log_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yésu gò lizíá àyɨ tí dhɨ: «Dɨ àmɨ ró dhɨ, mɨ̀ adré àmɨkya tàá dhɨ, ma àdhi ꞌɨ?» ");
INSERT INTO log_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Sìmónà Pétèró logó dhɨ: «Mɨ mɨ́na Mèsɨ́yà, Gìká lɨ́drɨ̀ ro dhɨ nɨ Mváagó ꞌɨ.» ");
INSERT INTO log_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yésu gò tàá drá dhɨ: «Sìmónà, Yónà nɨ mvá, Gìká bhà tà tanɨ mɨ́ dri dre. Àngyá ko, móndɨ́ tadhá tà kòdhɨ mɨ́ dré nɨ̀ ko. Be ró dhɨ, áma Atá bhù na dhɨ tadhá mɨ́ dré nɨ̀. ");
INSERT INTO log_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Má adré kpà tàá mɨ́ dré dhɨ: Mɨ Pétèró ꞌɨ. Má nɨ Èkèlézyà mána nɨ si kɨ́rà kònɨ̀dhɨ dri. Ndɨ̀ndɨ̀ dràdrà nɨ rìnyí kɨtswá ɨ́na Èkèlézyà nda nɨ lavú ko. ");
INSERT INTO log_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Má nɨ Òpɨ̀ bhù àdhya nɨ lìfùngúlà ànzɨ kɨ fe tayɨ́lé mɨ́ drɨ́gá. Tà ángùdhi mɨ́ dré dra ꞌɨ̀le kònwa bvò dri dhɨ, à nɨ kókpà tà nda nɨ ꞌɨ bhù na. Tà ángùdhi mɨ́ dré dra trɨ̀le bvò dri dhɨ, à nɨ kókpà tà nda nɨ trɨ bhù na.» ");
INSERT INTO log_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Gò Yésu dré áyɨ lebèbhá nda kɨ logázó, ɨ̀ kòtadháró dhya àlo dré dhɨ, ɨ Mèsɨ́yà ꞌɨ dhɨ ko. ");
INSERT INTO log_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kɨdhólé lókyá nda sè dhɨ, Yésu dré kɨdhózó adrélé tadhá áyɨ lebèbhá ɨ dré dhɨ, adré tá lèá dhɨ, ɨ́ kòlɨ̀ Yèrúsalémà na kɨtswálé kɨzà nya lavúlé Yúdà ànzɨ kɨ bhàgo ɨ drɨ́gá, kòwánà kàdrɨ̀ ɨ drɨ́gá ɨ̀ndɨ̀ tátrɨ́trɨ́ kúlí tadhábhá ɨ drɨ́gá, à kòpfuró ɨ dràle gò, kìtú nɨ na sè dhɨ, Gìká kòtɨngáró ɨ dràdrà lésè. ");
INSERT INTO log_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Dɨ Pétèró dré Yésu nɨ drìzo gàrà dri gò, kɨdhózó adrélé tà ta akódhɨ dri, tàzoá dhɨ: «Mírì, Gìká kòlɨkɨ́ mɨ! Tà nda kòdhɨ kɨtswá tàdzí atsálé mɨ́ rú ko!» ");
INSERT INTO log_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Dɨ, Yésu dré áyɨ alázó tàá Pétèró dré dhɨ: «Sàtánà, mɨ́ nga má mìlésè gòle má àmvona! Mɨ́ adré láti nda áma ꞌòzo dhèle. Tàko ko, mɨ́ adré tà kisù Gìká àdhya tɨ́nɨ ko. Be ró dhɨ, mɨ́ adré mɨ́na tà kisù móndɨ́ kya tɨ́nɨ.» ");
INSERT INTO log_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Gò Yésu dré tàzoá áyɨ lebèbhá ɨ dré dhɨ: «Dhya àlo kàdré lèá alɨ̀le má vésè dhɨ, lè akódhɨ nda kòtayɨ́ áyɨ tàndɨ nɨ tà, kàdó áyɨ fa kɨpakɨpa gò, kàdréró áma lebè. ");
INSERT INTO log_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Tàko ko, dhya ángùdhi adrélépi áyɨ tàndɨ nɨ lɨ́drɨ̀ le tɨdrɨ́lé dhɨ, a nɨ áyɨ lɨ́drɨ̀ nda nɨ ꞌo avɨ̀le. Dɨ, dhya ángùdhi adrélépi ɨ́na áyɨ lɨ́drɨ̀ fe áma tà sè dhɨ, a nɨ áyɨ lɨ́drɨ̀ nda nɨ kisú. ");
INSERT INTO log_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Àngyá ko, dhya àlo kòkisú ngá bvò kòndɨ àdhya ɨ títí gò, áyɨ tàndɨ nɨ lɨ́drɨ̀ tayɨ́zó avɨ̀le dhɨ, akódhɨ nda kisú ɨ́na àdho tà dóro ꞌɨ? A nɨ go àdho ngá fe kòdhya kɨtswázó áyɨ lɨ́drɨ̀ nda nɨ kisú dhɨ? ");
INSERT INTO log_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Tàko ko, Móndɨ́ nɨ Mvá nɨ agò áyɨ Atá nɨ mìlanzìlanzì na akódhɨ nɨ ángéló ɨ́be gò, dré tà logózó móndɨ́ àlo àlo títí ɨ dré, tà ɨ̀ dré ꞌòle dhɨ ɨ tí. ");
INSERT INTO log_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Má adré tà bàti ta àmɨ dré dhɨ: Móndɨ́ àruka adrébhá àyɨ kɨ totó kònwa nɨ ɨ̀ kɨtswá dràle drìdrì ɨ̀ dré dra Móndɨ́ nɨ Mvá nɨ nòzo alɨ̌ràꞌa áyɨ Òpɨ̀ na dhɨ kandrá ko.» ");
INSERT INTO log_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Kìtú nzi-drì-àlo àmvolésè dhɨ, Yésu dré Pétèró kɨ drìzo Yàkóbhò ɨ́be ɨ̀ndɨ̀ adrúpi nɨ Yòwánɨ̀ be gò, ɨ̀ dré lɨ̀zo àyɨ pátí mbàle kòngó àlo mvumvù dhɨ drìna. ");
INSERT INTO log_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Kònàle dhɨ, Yésu nɨ làsú dré ngàzo ru ladzá àyɨ mìle. Akódhɨ nɨ mìbhalé dré kɨdhózó adrélé lagúlé kìtú tɨ́nɨ. Akódhɨ nɨ kɨ́tá ɨ̀ dré kpà atsázó kemve kpɨ́rɨ́kpɨ́rɨ́ ngádra tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Gbǎ kòdhwa, Mósè ɨ Èlɨ́yà be dhɨ ɨ̀ dré agázó àyɨ kandrá, adrélé tà ta Yésu be. ");
INSERT INTO log_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Dɨ Pétèró dré tàzoá Yésu dré dhɨ: «Mírì, dóro nɨ mà dré adrélé kònwa dhɨ. Mɨ́ kàdré lèá dhɨ, má nɨ wémà na dhɨ kɨ ledé kònwa: àlo nɨ mɨ́ dré, àlo nɨ Mósè dré, ɨ̀ndɨ̀ àlo nɨ Èlɨ́yà dré.» ");
INSERT INTO log_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Dré rè dhu adréràꞌa tà ta dhɨ ꞌá dhɨ, ndùrùku lagulagu ró dhɨ dré apfòzo àyɨ kɨ asó rùkù gò, kúlí dré apfòzo lásà tàá dhɨ: «Kònɨ̀dhɨ áma Mváagó má dré lèle tò dhɨ ꞌɨ. Áma togó adré kɨnɨ́lé akódhɨ nɨ tà sè tò. Mɨ̀ kòyi akódhɨ!» ");
INSERT INTO log_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Yésu nɨ lebèbhá ɨ̀ kòyi kúlí nda dre dhɨ, àyɨ kɨ togó dré gàzo tirì sè bǐ gò, ɨ̀ dré ledhézó àyɨ kɨ mìbhalé bha kìní mi. ");
INSERT INTO log_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Dɨ, Yésu dré ɨ́na áyɨ kisízó ànyɨ àyɨ làga, àyɨ kɨ tabè gò, tàzoá àyɨ dré dhɨ: «Mɨ̀ nga! Mɨ̀ ro ngá ko.» ");
INSERT INTO log_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ɨ̀ kòtɨngá mì dre dhɨ, ɨ̀ dré gòzo vélé móndɨ́ àzya no ko, ngbà ꞌí Yésu ꞌɨ kalóma. ");
INSERT INTO log_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ɨ̀ dré tá adréràꞌa asílé kòngó nda drìlésè dhɨ ꞌá dhɨ, Yésu dré lazízóá àyɨ dri dhɨ: «Mɨ̀ kòlongó tà agálépi àmɨ mìle kòdhɨ dhya àlo dré ko, tsàle lókyá Gìká dré dra Móndɨ́ nɨ Mvá nɨ tɨngázó dràdrà lésè dhɨ ꞌá.» ");
INSERT INTO log_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Gò akódhɨ nɨ lebèbhá nda ɨ̀ dré akódhɨ nɨ lizízó tàzoá dhɨ: «Tátrɨ́trɨ́ kúlí tadhábhá ɨ̀ adré tàá dhɨ, lè Èlɨ́yà kàlɨ̀ rè zyà Mèsɨ́yà kandrá ꞌíká àdho tà sè?» ");
INSERT INTO log_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yésu logó àyɨ dré dhɨ: «Tà bàti ró dhɨ, Èlɨ́yà adré alɨ̀le tà títí dhɨ kɨ ledé. ");
INSERT INTO log_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Dɨ, má adré mána tàá àmɨ dré dhɨ: Èlɨ́yà atsá dre. Dɨ, móndɨ́ ɨ̀ nì tá àyɨkya akódhɨ àdhi ꞌɨ ya dhɨ ko. Gò ɨ̀ dré akódhɨ nɨ ꞌòzo ngóró ɨ̀ dré tá lèle dhɨ tɨ́nɨ. Dɨ Móndɨ́ nɨ Mvá nɨ kókpà kɨzà nya àyɨ drɨ́gá kònɨ̀nɨ.» ");
INSERT INTO log_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Dɨ Yésu nɨ lebèbhá ɨ̀ dré nìzoá tàle dhɨ, akódhɨ adré tá Yòwánɨ̀ Bàtísimò fèlepi nɨ tà ta àyɨ dré kòdhya. ");
INSERT INTO log_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ɨ̀ kògò tsàle móndyá zyandre ɨ véna dre dhɨ, agó àlo dhɨ dré alɨ̀zo adhélé áyɨ kórókó titì Yésu kandrá, ");
INSERT INTO log_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","tàzoá dhɨ: «Mírì, mɨ́ bhà áma mváagó nɨ kɨzà wà! Àgɨlɨ́lɨ́ adré akódhɨ nɨ lebhé, ɨ̀ndɨ̀ akódhɨ adré kɨzà nya tò. Vésè be bǐ, adré ledhélé àtsɨ́ na, kó ngalè yǐ na. ");
INSERT INTO log_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Má drì tá akódhɨ lɨ̀zo ába ámɨ lebèbhá ɨ véna. Dɨ, ɨ̀ kɨtswá tá àyɨkya akódhɨ nɨ tɨdrɨ́ bwà ko.» ");
INSERT INTO log_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Dɨ Yésu logó dhɨ: «Àmɨ, móndyá ándrò tà kaꞌìkaꞌì àko ɨ̀ndɨ̀ àmɨ kɨ tayɨ́bhá lɨtɨ́lé nɨ ɨ, mà nɨ adré vélé àmɨ ɨ́be vwàle lókyá be ángopɨ́? Má nɨ àmɨ kɨ tà mvo vwàle lókyá be ángopɨ́? Mɨ̀ adrì mvámvá nda alɨ̀zo ába má vélé.» ");
INSERT INTO log_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Dɨ ɨ̀ kàlɨ̀ akódhɨ be dre dhɨ, Yésu dré lɨgɨ́zó tɨrɨ́ kònzɨ akódhɨ lé dhɨ be gò, dré dròzoá pfòle lásà. Dɨ mvámvá nda dré adrɨ́zó gbǎ lókyá nda sè. ");
INSERT INTO log_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Àmvolásà dhɨ, Yésu nɨ lebèbhá ɨ̀ dré àyɨ kɨ kisízó àyɨ pátí ànyɨ akódhɨ làga, akódhɨ nɨ lizí tàzoá dhɨ: «Mà kɨtswá tá tɨrɨ́ kònzɨ nda kònàdhɨ nɨ dro bwà ko àdho tà sè?» ");
INSERT INTO log_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yésu logó àyɨ dré dhɨ: «Mɨ̀ kɨtswá tá bwà ko, mɨ̀ dré adrélé tà kaꞌìkaꞌì ɨ́be tsà dhɨ sè. Má adré tà bàti ta àmɨ dré: Mɨ̀ kàdré tà kaꞌìkaꞌì ɨ́be tsàmvá ngóró mùtádì lòꞌwa tɨ́nɨ dhɨ, mɨ̀ nɨ kɨtswá tàá kòngó kònɨ̀dhɨ dré dhɨ ‹Mɨ́ kisí mɨ kònwásè lɨ̀le kònàle› gò, kòngó nda dré áyɨ kisízó. Dɨ tà àlo mɨ̀ dré kɨtswálé ꞌòle bwà ko dhɨ nɨ adré yókódhó.»  ");
INSERT INTO log_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Kìtú àlo dhɨ, Yésu ɨ lebèbhá nɨ ɨ́be dhɨ ɨ̀ kɨmó tá ru bvò Gàlìláyà àdhya na. Gò akódhɨ dré tàzoá àyɨ dré dhɨ: «À nɨ Móndɨ́ nɨ Mvá nɨ lefè kàrɨbhá ɨ drɨ́gá. ");
INSERT INTO log_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ɨ̀ dré akódhɨ nɨ pfùzo dràle gò, kìtú nɨ na sè dhɨ, Gìká dré akódhɨ nɨ tɨngázó dràdrà lésè.» Dɨ kúlí nda sè dhɨ, akódhɨ nɨ lebèbhá kɨ togó dré gàzo kɨzà sè bǐ. ");
INSERT INTO log_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Àmvolásà dhɨ, Yésu ɨ lebèbhá nɨ ɨ́be dhɨ ɨ̀ dré lɨ̀zo tsàle Kàpàrànàwúmà na. Gò dhya adrébhá tá mèdáyɨ̀ tépelò àdhya nɨ lagɨ́ dhɨ ɨ̀ dré alɨ̀zo Pétèró vélé lizíá tíá dhɨ: «Àmɨ kɨ tadhálépi adré mèdáyɨ̀ tépelò àdhya nɨ gɨ?» ");
INSERT INTO log_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pétèró logó àyɨ dré dhɨ: «Àyíya, akódhɨ adré gɨ̀á.» Pétèró kògò fɨ̀le dzó na dre dhɨ, Yésu dré zyà kúlí dòzo tàle nɨ̀. Tà dhɨ: «Sìmónà, mɨ́ kisù mɨ́na ngɨ́nɨ? Ópɨ́ bvò kòndɨ àdhya ɨ̀ adré àdhibhá kɨ ꞌo adrélé mèdáyɨ̀ gɨ dhɨ kòdhya: àyɨ kɨ tàndɨ kɨ ànzɨ ɨ, kó ngalè, móndɨ́ àruka àyɨ kɨ òpɨ̀ zàle dhɨ ɨ?» ");
INSERT INTO log_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pétèró logó dhɨ: «Móndɨ́ àruka ɨ.» Yésu gò tàá drá dhɨ: «Kàdré dɨ kònɨ̀nɨ dhɨ, ópɨ́ kɨ ànzɨ nda ɨ̀ kɨtswá àyɨkya gɨ̀á ko. ");
INSERT INTO log_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Dɨ, má lè mána móndyá kòna kɨ togó ꞌòle aswálé àma rú ko. Ásà dhɨ, mɨ́ lɨ̀ kosyá bhe tä́pä́ríandre na. Mɨ́ adó kosyá mɨ́ dré dra asélé drìdrì dhɨ, síbhálé nɨ nɨ nzìzo gò, làfa lòꞌwa àlo dhɨ nɨ kisúzó sílána. Dɨ mɨ́ do làfa lòꞌwa nda lɨ̀zo ába àyɨ véna mèdáyɨ̀ gɨ àma dré mɨ́ be.» ");
INSERT INTO log_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Lókyá nda sè dhɨ, Yésu nɨ lebèbhá ɨ̀ dré àyɨ kɨ kisízó ànyɨ akódhɨ làga, akódhɨ nɨ lizí tàzoá dhɨ: «Dhya kàdrɨ̀ lavúlé Òpɨ̀ bhù àdhya na dhɨ àdhi ꞌɨ?» ");
INSERT INTO log_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Dɨ Yésu dré mvámvá àlo dhɨ nɨ azízó bhàle àyɨ kɨ kɨ́tó ꞌá gò, ");
INSERT INTO log_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","tàzoá dhɨ: «Má adré tà bàti ta àmɨ dré: Mɨ̀ kòladzá àmɨ kɨ togó atsázó ànzɨmvá ɨ tɨ́nɨ ko dhɨ, mɨ̀ kɨtswá tàdzí fɨ̀le Òpɨ̀ bhù àdhya na ko. ");
INSERT INTO log_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Dɨ dhya ángùdhi adrélépi áyɨ tà bha kìní mi ngóró mvámvá kònɨ̀dhɨ àdhya tɨ́nɨ dhɨ, nɨ adré dhya kàdrɨ̀ lavúlé Òpɨ̀ bhù àdhya na dhɨ ꞌɨ. ");
INSERT INTO log_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Kòdhɨ ɨ́be dhɨ, dhya ángùdhi adrélépi mvámvá kònɨ̀dhɨ tɨ́nɨ dhɨ nɨ kaꞌì dòle dóro áma rú sè dhɨ, adré áma tàndɨ nɨ kaꞌì kòdhya.» ");
INSERT INTO log_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","«Dɨ, dhya àlo kàdré ɨ́na ànzɨmvá adrébhá áma kaꞌì kònɨ kɨ àlo ꞌo dhèle tàkonzɨ̀ na dhɨ, dóro nɨ tá kɨ́rà kàdrɨ̀ ꞌɨ̀le akódhɨ nda kembé gò, akódhɨ nɨ bhèzo dràle yǐandre nɨ tä́lí na dhɨ. ");
INSERT INTO log_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kɨzà vo ngɨ́nɨ bvò kòndɨ dri, tà adrébhá móndɨ́ kɨ ꞌo ledhélé tàkonzɨ̀ na dhɨ kɨ tà sè dhɨ! Tà bàti ró dhɨ, tà nda kòdhɨ kɨ ngbú adré be. Dɨ, kɨzà nɨ adré kàdrɨ̀ dhya ángùdhi adrélépi tà nda kɨ àndu bha dhɨ dré! ");
INSERT INTO log_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ámɨ drɨ́gá ꞌɨ yà, kó ngalè ámɨ pá ꞌɨ yà dhɨ kàdré ámɨ ꞌo dhèle tàkonzɨ̀ na nɨ̀ dhɨ, lè mɨ́ kòli akódhɨ nda bhèle mɨ́ rúsè vwàvwà ro. Àngyá ko, mɨ́ dré fɨ̀le lɨ́drɨ̀ kóná vésè kólyá dhɨ na ngbà ꞌí drɨ́gá be àlo yà, kó ngalè pá be àlo yà dhɨ dóro lavúlé, ámɨ bhèle àtsɨ́ adrélépi adrálé ko dhɨ na drɨ́gá be rì ɨ̀ndɨ̀ pá be rì dhɨ rúsè. ");
INSERT INTO log_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ámɨ mì kàdré kó ámɨ ꞌo dhèle tàkonzɨ̀ na nɨ̀ dhɨ, lè mɨ́ kàngɨ́ mì nda bhèle mɨ́ rúsè vwàvwà ro. Àngyá ko, mɨ́ dré fɨ̀le lɨ́drɨ̀ na ngbà ꞌí mì be àlo dhɨ dóro lavúlé, ámɨ bhèle àtsɨ́ líferò àdhya na mì be rì dhɨ rúsè.» ");
INSERT INTO log_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","«Mɨ̀ kònò dóro, mɨ̀ kàdréró ànzɨmvá kònɨ kɨ àlo no móndɨ́ tàko ró ko. Tàko ko, má adré tàá àmɨ dré dhɨ: Àyɨ nda kɨ ángéló ɨ̀ adré ngbú áma Atá bhù na dhɨ nɨ mìbhalé no.  ");
INSERT INTO log_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Mɨ̀ kisù àmɨkya ngɨ́nɨ? Agó àlo kàdré kábilígyà ɨ́be nyadhɨ-nzi gò àyɨ kɨ àlo dré avɨ̀zo dhɨ, a nɨ ꞌòá ngɨ́nɨ? A nɨ zakó tsì kábilígyà nyadhɨ-su-drì-mudrí-drì-nzi-drì-su nda kɨ tayɨ́ kòngó drìna gò, lɨ̀zo akódhɨ avɨ̀lepi nda nɨ ndabe. ");
INSERT INTO log_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Má adré tà bàti ta àmɨ dré: Kòkisú kábilígyà nda dre dhɨ, a nɨ lenzé akódhɨ nɨ tà sè lavúlé, dré adrélé lenzélé kábilígyà nyadhɨ-su-drì-mudrí-drì-nzi-drì-su avɨ̀bhá ko nda kɨ tà sè dhɨ rúsè. ");
INSERT INTO log_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Kókpà kòdhɨ tɨ́nɨ, àmɨ kɨ Atá bhù na dhɨ adré lèá ko, ànzɨmvá kònɨ kɨ àlo dré avɨ̀le dhɨ.» ");
INSERT INTO log_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","«Ámɨ adrúpi àlo dhɨ kòꞌo tàkonzɨ̀ mɨ́ rú dhɨ, mɨ́ kòlɨ̀ rè zyà kalóma akódhɨ véna, akódhɨ nɨ tàkonzɨ̀ nda nɨ tadhá drá. Akódhɨ kòyi mɨ dhɨ, kòdhɨ mɨ́ gò ámɨ adrúpi nda nɨ kisú dre. ");
INSERT INTO log_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Dɨ, kòyi ɨ́na mɨ ko dhɨ, mɨ́ kòdrì móndɨ́ àlo yà, ngalè rì yà dhɨ, mɨ̀ kòlɨ̀ró akódhɨ véna, ‹kɨtswálé tà títí dhɨ kɨ bvó lanzɨ́ móndɨ́ rì yà kó ngalè na yà tà nda kɨ nobhá mì sè dhɨ kɨ kúlí sè.› ");
INSERT INTO log_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Akódhɨ kògà àyɨ nda kɨ yìma rè dhɨ, mɨ́ kòlɨ̀ tà nda nɨ ta Èkèlézyà kandrá. Kògà ndɨ̀ndɨ̀ Èkèlézyà nda nɨ kúlí yìma rè dhɨ, mɨ́ kàdré akódhɨ nɨ no pàgánò tɨ́nɨ, kó ngalè mèdáyɨ̀ lagɨ́lépi tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Má adré tà bàti ta àmɨ dré: Tà ángùdhi mɨ̀ dré dra ꞌɨ̀le kònwa bvò dri dhɨ, à nɨ kókpà tà nda nɨ ꞌɨ bhù na. Tà ángùdhi mɨ̀ dré dra trɨ̀le bvò dri dhɨ, à nɨ kókpà tà nda nɨ trɨ bhù na. ");
INSERT INTO log_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Má adré kpà tàá àmɨ dré dhɨ: Móndɨ́ rì àmɨ kòfalé bvò dri dhɨ ɨ̀ kàdré ru yi, tà ángùdhi ɨ̀ dré adrélé zìle áma Atá bhù na dhɨ tí dhɨ dri dhɨ, akódhɨ nɨ tà nda nɨ ꞌo àyɨ dré. ");
INSERT INTO log_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Àngyá ko, àrà ángùdhi móndɨ́ rì yà, ngalè na yà dhɨ ɨ̀ dré adrézó ru kɨmó áma rú sè dhɨ na dhɨ, ma kókpà túmä́ní àyɨ ɨ́be.» ");
INSERT INTO log_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Gò Pétèró dré áyɨ kisízó ànyɨ Yésu làga, akódhɨ nɨ lizí tàzoá dhɨ: «Mírì, áma adrúpi kàdré tàkonzɨ̀ ꞌo má rú dhɨ, má nɨ akódhɨ nɨ tàkonzɨ̀ tri tsàle vésè be ángopɨ́? Tsàle vésè be nzi-drì-rì?» ");
INSERT INTO log_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yésu logó drá dhɨ: «Kóko! Má adré tàá mɨ́ dré dhɨ, tsàle vésè be nzi-drì-rì dhɨ ko. Be ró dhɨ, mɨ́ kàdré akódhɨ nɨ tàkonzɨ̀ tri tsàle vésè be nyadhɨ-na-drì-mudrí vésè be nzi-drì-rì.» ");
INSERT INTO log_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","«Tà nda sè dhɨ, Òpɨ̀ bhù àdhya sù ngóró tà kònɨ̀dhɨ tɨ́nɨ: Ópɨ́ àlo dhɨ lè tá áyɨ màri áyɨ màrábà ɨ rú dhɨ kɨ tà ꞌòle akɨ́lé. ");
INSERT INTO log_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Dɨ kòkɨdhó adrélé áyɨ màri nda kɨ tà ꞌo dre dhɨ, à dré màrábà àlo adrélépi tá màri kàdrɨ̀ lavúlé dhɨ ɨ́be ɨ́ rú dhɨ nɨ adrìzo alɨ̀zo ába akódhɨ vélé. Màri akódhɨ nda rú dhɨ tá làfa lòꞌwa ngùlù-mudrí. ");
INSERT INTO log_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Dɨ màrábà nda dré tá kɨtswálé ngá logó màri nda tí bwà ko dhɨ sè dhɨ, mírì nɨ dré tòlɨ́ fèzo tàzoá dhɨ, à kòlagɨ́ akódhɨ, tòkó nɨ, ànzɨmvá nɨ ɨ, tsàle akódhɨ nɨ ngá títí dhɨ ɨ́be, kɨtswázó màri nda nɨ logó. ");
INSERT INTO log_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Dɨ màrábà nda dré dhèzo áyɨ kórókó titì áyɨ mírì kandrá, tàzoá drá dhɨ: ‹Mɨ́ tadhá ámɨ togó vwàvwà má vélé wà! Má nɨ ámɨ màri logó mɨ́ dré títí.› ");
INSERT INTO log_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Dɨ mírì nɨ dré akódhɨ nɨ kɨzà bhàzo gò, màri nda nɨ tà tayɨ́zó, akódhɨ nɨ tàndɨ nɨ tayɨ́zó kpà lɨ̀le. ");
INSERT INTO log_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Dɨ, màrábà nda kòpfò dre dhɨ, dré ɨ́na lɨ̀zo áyɨ àzízɨ̌ àlo áyɨ màri ɨ́be làfa lòꞌwa nyadhɨ-nzi dhɨ nɨ kisú. Dré akódhɨ nɨ rùzo bèle kembe ꞌá, adrézó akódhɨ nɨ kɨzɨ́, adrézó tàá dhɨ: ‹Mɨ́ logó áma màri mɨ́ rú dhɨ!› ");
INSERT INTO log_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Àzízɨ̌ nɨ nda dré dhèzo áyɨ kórókó titì akódhɨ kandrá, akódhɨ nɨ ti lizízó tàzoá dhɨ: ‹Mɨ́ tadhá ámɨ togó vwàvwà má vélé wà! Má nɨ ámɨ màri logó.› ");
INSERT INTO log_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Dɨ, màrábà nda kaꞌì tá kúlí nda ko. Be ró dhɨ, lɨ̀ ɨ́na áyɨ àzízɨ̌ nda nɨ ꞌo bhèle bǎdzó na, kòlogóró màri ɨ́ rú nda akɨ́lé títí be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Dɨ màrábà àruka ɨ̀ kònò tà nda dre dhɨ, àyɨ kɨ togó dré kɨzà nyàzo tò. Gò ɨ̀ dré lɨ̀zo tà títí lavúbhá nda kɨ tɨtɨ́ àyɨ kɨ mírì dré. ");
INSERT INTO log_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Dɨ mírì nda dré màrábà nda nɨ azízó, tàzoá drá dhɨ: ‹Mɨ màrábà kònzɨ nɨ, má tayɨ́ tá áma màri mɨ́ rú dhɨ, mɨ́ dré áma ti lizílé dhɨ sè. ");
INSERT INTO log_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Adré dɨ tá kpà lèá dhɨ, mɨ́ kòbhà ámɨ àzízɨ̌ nɨ kɨzà, ngóró má dré ámɨ kɨzà bhàle dhɨ tɨ́nɨ.› ");
INSERT INTO log_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Dɨ togóaswa dré dhɨ, mírì nɨ dré akódhɨ nɨ fèzo bǎdzó lɨkɨ́bhá ɨ drɨ́gá, ɨ̀ kàdréró akódhɨ nɨ rúbhá ꞌo aswálé, tsàle lókyá dré màri ɨ́ rú nda nɨ logóràꞌa akɨ́lé títí dhɨ ꞌá.» ");
INSERT INTO log_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yésu gò tàá dhɨ: «Áma Atá bhù na dhɨ nɨ kókpà àmɨ àlo àlo títí dhɨ kɨ ꞌo kònɨ̀nɨ, mɨ̀ kàdré àmɨ kɨ adrúpi kɨ tàkonzɨ̀ tri togó wä́yi sè ko dhɨ.» ");
INSERT INTO log_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yésu kòtà tà nda ɨ akɨ́lé dre dhɨ, dré ngàzo Gàlìláyà lésè, lɨ̀le bvò Yùdáyà àdhya na, Yòròdánè nɨ taꞌá na. ");
INSERT INTO log_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Móndɨ́ zyandre lavúlé dhɨ ɨ̀ dré akódhɨ nɨ lebèzo gò, dré àyɨ kɨ dràbhá kɨ tɨdrɨ́zó. ");
INSERT INTO log_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Gò Fàrìsáyò àruka ɨ̀ dré àyɨ kɨ kisízó ànyɨ akódhɨ làga, kɨtswálé akódhɨ nɨ tabhì lɨtɨ́lé. Dɨ ɨ̀ dré lizízóá tíá dhɨ: «Àma kɨ tátrɨ́trɨ́ kúlí kaꞌì, agó kòtɨngá áyɨ tòkó tà ángùdhi dré adrézó akódhɨ nɨ le tɨngálé ásà dhɨ sè dhɨ ꞌí?» ");
INSERT INTO log_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yésu logó dhɨ: «Mɨ̀ nà rè Gìká nɨ Kúlí na ko tàle dhɨ, ngá títí dhɨ kɨ kɨdhoma ꞌá dhɨ, ‹Gìká ngá títí dhɨ kɨ bhàlepi dhɨ bhà tá àyɨ agó ɨ tòkó be› dhɨ? ");
INSERT INTO log_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Gìká tà tá kpà dhɨ: ‹Ásà dhɨ, agó nɨ áyɨ atá nɨ tayɨ́ áyɨ andre be, ru amúzó áyɨ tòkó be gò, àyɨ rìti nda ɨ̀ dré atsázó rúbhá àlo ró.› ");
INSERT INTO log_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Dɨ ɨ̀ gò vélé adrélé rì ko. Be ró dhɨ, àyɨ ngá àlo ꞌɨ. Ásà dhɨ, lè móndɨ́ ɨ̀ kòlanzɨ́ ngá Gìká dré amúlé nɨ̀ dhɨ ko.» ");
INSERT INTO log_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Fàrìsáyò nda ɨ̀ gò lizíá tíá dhɨ: «Kàdré kònɨ̀nɨ dhɨ, Mósè fè tá dɨ tòlɨ́ tàzoá dhɨ, agó adrélépi áyɨ tòkó nɨ le tɨngálé dhɨ kòfè wárágà drá akódhɨ nɨ tɨngázó gò, mùzoá nzɨ̀le dhɨ àdho tà sè?» ");
INSERT INTO log_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Dɨ Yésu logó àyɨ dré dhɨ: «Mósè kaꞌì tá ɨ́na àmɨ kɨ tòkó kɨ tɨngama, àmɨ kɨ togó dré adrélé tòmbátòmba dhɨ sè. Dɨ, tà nda tá ɨ́na kònɨ̀nɨ kɨdhoma lésè ko. ");
INSERT INTO log_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Má adré tàá àmɨ dré dhɨ: Kàdré ngbà ꞌí ndòtò tà sè ko dhɨ, agó ángùdhi áyɨ tòkó nɨ tɨngálépi gò gòzo tòkó àzya adó mòle dhɨ, adré ɨ́na múná tà ꞌo.» ");
INSERT INTO log_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Yésu nɨ lebèbhá ɨ̀ dré tàzoá drá dhɨ: «Agó nɨ tà tòkó nɨ be dhɨ kàdré kònɨ̀nɨ dhɨ, dóro nɨ làmó mòle ko dhɨ.» ");
INSERT INTO log_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yésu logó àyɨ dré dhɨ: «Móndyá títí dhɨ ɨ̀ kɨtswá kúlí kòdhɨ nɨ kaꞌì bwà ko. Ngbà ꞌí àyɨ Gìká dré rìnyí fèzo àyɨ dré dhɨ kɨ kɨtswá kaꞌìá dhɨ àyɨ. ");
INSERT INTO log_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Tàko ko, tà twátwa àgo ɨ̀ dré adrézó làmó mo ko dhɨ ɨ be. Àruka nɨ ɨ, à ti àyɨ adrélé làmó lovó àko gò ɨ̀ dré atsázó ùníkì ɨ ró. Àruka nɨ ɨ, móndɨ́ ꞌo àyɨ atsálé ùníkì ɨ ró dhɨ nɨ̀. Àruka nɨ ɨ̀ gà kó làmó atsázó ùníkì ɨ ró, adrélé àyɨ kɨ fe Gìká nɨ Òpɨ̀ nɨ tà ꞌo. Dhya ángùdhi kɨtswálépi kúlí nda nɨ kaꞌì dhɨ, kàdré kaꞌìá!» ");
INSERT INTO log_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Àmvolásà dhɨ, móndɨ́ ɨ̀ dré àyɨ kɨ ànzɨmvá kɨ adrìzo alɨ̀zo àyɨ ɨ́be Yésu vélé, kòbhàró drɨ́gá àyɨ dri, tà zìzo Gìká tí àyɨ dré be dhɨ bvó. Dɨ, akódhɨ nɨ lebèbhá ɨ̀ dré àyɨkya lawàzo móndyá nda ɨ dri tà nda sè. ");
INSERT INTO log_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Dɨ, Yésu dré tàzoá dhɨ: «Mɨ̀ tayɨ́ ànzɨmvá kònɨ ɨ alɨ̀le má vélé. Mɨ̀ logá àyɨ ko. Àngyá ko, Òpɨ̀ bhù àdhya móndyá adrébhá àyɨ nda ɨ tɨ́nɨ dhɨ ɨ dré.» ");
INSERT INTO log_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Dré drɨ́gá bhàzo àyɨ dri, tà tanɨ zìzo àyɨ dré gò, lɨ̀zo. ");
INSERT INTO log_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Àmvolásà dhɨ, kàdhúrà àlo dhɨ dré áyɨ kisízó ànyɨ Yésu làga, akódhɨ nɨ lizí tàzoá dhɨ: «Tadhálépi, lè má kòꞌo àdho tà dóro kòdhya kɨtswázó lɨ́drɨ̀ kóná vésè kólyá dhɨ nɨ kisú dhɨ?» ");
INSERT INTO log_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yésu logó drá dhɨ: «Mɨ́ adré áma lizí tà dóro nɨ tà dri àdho tà sè? Dhya adrélépi dóro dhɨ ngbà ꞌí àlo kwákwá. Dɨ, mɨ́ kàdré lɨ́drɨ̀ kóná vésè kólyá dhɨ nɨ le kisúlé dhɨ, lè mɨ́ kàdré tà tátrɨ́trɨ́ kúlí dré adrélé tàle à kòꞌo dhɨ kɨ ꞌo.» ");
INSERT INTO log_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Kàdhúrà nda gò lizíá dhɨ: «Tà ángùdhi?» Yésu gò logóá dhɨ: «Lè mɨ́ kòpfu móndɨ́ dràle ko. Mɨ́ kòꞌo múná tà ko. Mɨ́ kòkugù ngá ko. Mɨ́ kòtà tà móndɨ́ rú kɨnzò sè ko. ");
INSERT INTO log_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Mɨ́ kàdré ámɨ atá nɨ lɨndrɨ̀ bha ámɨ andre be. Mɨ́ kàdré ámɨ àzya nɨ le ngóró mɨ́ dré adrélé ámɨ tàndɨ nɨ le dhɨ tɨ́nɨ.» ");
INSERT INTO log_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Kàdhúrà nda tà drá dhɨ: «Má lɨkɨ́ tòlɨ́ nda kòdhɨ ɨ títí. Lè dɨ má kògò àdho tà ꞌo kòdhya?» ");
INSERT INTO log_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Dɨ Yésu logó drá dhɨ: «Mɨ́ kàdré lèá ámɨ tà kàdré dóro kɨtswálé títí Gìká mìlésè dhɨ, mɨ́ lɨ̀ ámɨ ngá títí dhɨ kɨ lagɨ́ gò, làfa nɨ nɨ lanzɨ́zó lemerèbhá ɨ dré, mɨ́ kàdréró ngá làgɨ́ be kàdrɨ̀ dhɨ ɨ́be bhù na. Dɨ mɨ́ alɨ̀ adrélé áma lebè.» ");
INSERT INTO log_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Kàdhúrà nda kòyi kúlí nda ɨ dre dhɨ, dré ngàzo lɨ̀le kɨzà be tò, dré tá adrélé ngá ɨ́be zyandre ró dhɨ sè. ");
INSERT INTO log_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Gò Yésu dré tàzoá áyɨ lebèbhá ɨ dré dhɨ: «Má adré tà bàti ta àmɨ dré: Ngá líyí nɨ fɨ̀ma Òpɨ̀ bhù àdhya na dhɨ kòkóròko. ");
INSERT INTO log_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Má adré gòle tàá àmɨ dré dhɨ: Ngá líyí nɨ fɨ̀ma Gìká nɨ Òpɨ̀ na dhɨ ɨ́na kòkóròko lavúlé, kàmílò dré lavúlé sìndánì nɨ bhálé ꞌásè dhɨ rúsè.» ");
INSERT INTO log_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Dɨ akódhɨ nɨ lebèbhá ɨ̀ kòyi tà nda dre dhɨ, àyɨ kɨ lɨ́ndrɨ́ dré gàzo bhwǎbhwa gò, ɨ̀ dré adrézó lizíá àyɨ kòfalésè dhɨ: «Kàdré kònɨ̀nɨ dhɨ, àdhi nɨ kɨtswá lɨ́drɨ̀ kóná vésè kólyá dhɨ nɨ kisú nɨ̀?» ");
INSERT INTO log_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yésu dré àyɨ kɨ nòzo dɨ̀ɨɨ́ gò, tàzoá àyɨ dré dhɨ: «Móndɨ́ ɨ mìlésè dhɨ, tà nda kòdhɨ tà kɨtswálé ꞌòle bwà ko dhɨ ꞌɨ. Dɨ, Gìká mìlésè dhɨ, tà àlo kɨtswálé ꞌòle bwà ko dhɨ yókódhó.» ");
INSERT INTO log_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Gò Pétèró dré tàzoá drá dhɨ: «Mɨ́ nò rè ká! Mà tayɨ́ tà títí dhɨ ɨ adrézó ámɨ lebè. Mà nɨ dɨ àdho tà dóro kisú ásà kòdhya?» ");
INSERT INTO log_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yésu gò logóá dhɨ: «Má adré tà bàti ta àmɨ dré: Bvò tɨ́dhɨ́ ro dhɨ na dhɨ, lókyá Móndɨ́ nɨ Mvá dré dra lɨrɨ́zó áyɨ lɨrɨ́rà òpɨ̀ àdhya mìlanzìlanzì ro dhɨ dri dhɨ tú dhɨ, àmɨ áma lebèbhá nɨ kɨ kókpà lɨrɨ́ lɨrɨ́rà mudrí-drì-rì adrézó òpɨ̀ nya dhɨ ɨ drǐsè, adrélé Ɨ̀sèrélè ànzɨ kɨ súrú mudrí-drì-rì dhɨ kɨ tàbvó ta. ");
INSERT INTO log_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Dhya ángùdhi áyɨ dzó ɨ ꞌɨ yà, áyɨ adrúpi ɨ ꞌɨ yà, áyɨ amvúpi ɨ ꞌɨ yà, áyɨ atá ꞌɨ yà, áyɨ andre ꞌɨ yà, áyɨ ànzɨ ɨ ꞌɨ yà, kó ngalè áyɨ amvú ɨ ꞌɨ yà dhɨ kɨ tayɨ́lépi áma tà sè dhɨ, a nɨ ngá nda kɨ vúdrì kisú tsàle vésè be nyadhɨ-nzi. Kòdhɨ ɨ́be dhɨ, a nɨ kókpà lɨ́drɨ̀ kóná vésè kólyá dhɨ nɨ kisú tàyɨlé ro. ");
INSERT INTO log_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Dɨ, móndɨ́ bǐ adrébhá drìdrì nyànomvá dhɨ kɨ go adrélé bvólé ro. Móndɨ́ bǐ adrébhá bvólé ro nyànomvá dhɨ kɨ go adrélé drìdrì.» ");
INSERT INTO log_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Yésu gò tàá dhɨ: «Òpɨ̀ bhù àdhya sù ngóró tà kònɨ̀dhɨ tɨ́nɨ: Amvú líyí àlo dhɨ pfò tá drùbhì kɨ́nó kɨtswálé móndɨ́ kɨ nda dòle àzí ꞌo áyɨ vínò amvú na. ");
INSERT INTO log_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Kòkisú móndɨ́ àruka ɨ dre dhɨ, ɨ̀ dré ru yìzo àyɨ ɨ́be, akódhɨ kòfèró làfa lòꞌwa àlo àlo àyɨ àlo àlo títí ɨ dré àzí ꞌòle kìtú àlo sè dhɨ tí. Dré àyɨ kɨ mùzo lɨ̀le àzí ꞌo áyɨ vínò amvú na. ");
INSERT INTO log_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Sáà nzi-drì-su drùbhì àdhya sè dhɨ, dré gòzo pfòle ngá lagɨ́rà na, móndɨ́ àruka kɨ no adréràꞌa àyɨ kɨ totó àngyá gò, ");
INSERT INTO log_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","dré tàzoá àyɨ dré dhɨ: ‹Àmɨ, mɨ̀ lɨ̀ kókpà àzí ꞌo áma vínò amvú na. Má nɨ go làgɨ́ gyǎgya dhɨ nɨ fe àmɨ dré.› ");
INSERT INTO log_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Dɨ ɨ̀ dré ngàzo lɨ̀le. Kìtú rírí sè, ɨ̀ndɨ̀ sáà na kìtú rírí àmvolésè dhɨ sè dhɨ, amvú líyí nda dré gòzo pfòle ꞌòá kònɨ̀nɨ. ");
INSERT INTO log_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Sáà nzi ɨ̀ndró àdhya sè dhɨ, dré gòzo tódhyá pfòle móndɨ́ àruka kɨ kisú adréràꞌa àyɨ kɨ totó àngyá gò, dré tàzoá àyɨ dré dhɨ: ‹Mɨ̀ adré àmɨ kɨ totó kònwa àngyá kìtú ndìle àdho tà sè?› ");
INSERT INTO log_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ɨ̀ logó drá dhɨ: ‹Àma kònwa, à dré àma kɨ zìle àzí ꞌo ko dhɨ sè.› Dɨ akódhɨ tà àyɨ dré dhɨ: ‹Àmɨ, mɨ̀ lɨ̀ kókpà àzí ꞌo áma vínò amvú na.› ");
INSERT INTO log_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ɨ̀ndró kàndrɨ̀ dre dhɨ, amvú líyí nda dré tàzoá dhya adrélépi tá áyɨ àzí ꞌobhá kɨ drì ko dhɨ dré dhɨ: ‹Mɨ́ azí àzí ꞌobhá ɨ, làfa fèzo àyɨ dré àyɨ kɨ àzí sè. Mɨ́ kɨdhó rè zyà àyɨ dòle kùdù ro dhɨ ɨ vélésè ꞌíká, gò mɨ́ kògòró lavúlé àyɨ dòle drìdrì dhɨ ɨ véna ndò.› ");
INSERT INTO log_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Àzí ꞌobhá dòle sáà nzi ɨ̀ndró àdhya sè nda ɨ̀ kàtsá dre dhɨ, àyɨ àlo àlo títí dhɨ ɨ̀ dré làfa lòꞌwa kisúzó àlo àlo. ");
INSERT INTO log_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Dɨ àyɨ dòle drìdrì nda ɨ̀ kàtsá dre dhɨ, ɨ̀ adré tá kisùá dhɨ, ɨ̀ nɨ tá làfa kisú bǐ lavúlé. Dɨ, àyɨ àlo àlo títí dhɨ ɨ̀ dré kpà làfa lòꞌwa kisúzó àlo àlo. ");
INSERT INTO log_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ɨ̀ kòkisú làfa lòꞌwa nda ɨ dre dhɨ, ɨ̀ dré dhèzo adrélé amvú líyí nda nɨ ndrɨ, ");
INSERT INTO log_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","adrézó tàá dhɨ: ‹Dhya dòle kùdù ro kòdhɨ ɨ̀ ꞌo àzí ngbà ꞌí sáà àlo. Dɨ, mɨ́ fè mɨ́na làfa àyɨ dré ngóró mɨ́ dré afèle àma dré dhɨ pɨ́, tágba mà dré àzí ꞌòzo landèzo kìtú àtsɨ́ sè kìtú ndìle dhɨ!› ");
INSERT INTO log_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Dɨ, amvú líyí nda logó àyɨ kɨ àlo dré dhɨ: ‹Áma arúpi, má ꞌo mɨ kònzɨ ko. Mà yi tá tsì ru mɨ́ be, mɨ́ kòꞌoró àzí làfa lòꞌwa àlo sè dhɨ ko? ");
INSERT INTO log_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Mɨ́ do dɨ làfa mɨ́na lɨ̀zo ába. Má adré mána làfa le fèle dhya dòle kùdù ro dhɨ ɨ dré ngóró má dré fèle mɨ́ dré dhɨ pɨ́. ");
INSERT INTO log_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Má kɨtswá mána tà má dré adrélé lèle ꞌòle áma làfa sè dhɨ nɨ ꞌo ko? Mɨ́ adré kó mɨ́na áma no mì kònzɨ sè, má dré adrélé móndɨ́ kɨ ꞌo dóro dhɨ sè?›» ");
INSERT INTO log_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Dɨ Yésu go tàá dhɨ: «Móndyá adrébhá bvólé ro dhɨ kɨ go adrélé drìdrì. Móndyá adrébhá drìdrì dhɨ kɨ go adrélé bvólé ro.» ");
INSERT INTO log_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yésu ɨ̀ dré tá adréràꞌa mbàle Yèrúsalémà na dhɨ ꞌá dhɨ, akódhɨ dré áyɨ lebèbhá mudrí-drì-rì dhɨ kɨ drìzo gàrà dri gò, tàzoá àyɨ dré dhɨ: ");
INSERT INTO log_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Mɨ̀ yi rè ká! Mà adré mbàle Yèrúsalémà na. Kònàle dhɨ, à nɨ Móndɨ́ nɨ Mvá nɨ lefè kòwánà kàdrɨ̀ ɨ drɨ́gá tátrɨ́trɨ́ kúlí tadhábhá ɨ́be. Ɨ̀ dré tà ŋòzo akódhɨ dri kɨtswálé dràdrà sè gò, ");
INSERT INTO log_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","akódhɨ nɨ fèzo pàgánò ɨ drɨ́gá. Àyɨ nda ɨ̀ dré akódhɨ nɨ gùzo, tswàzoá gò, tidízóá dràle fa kɨpakɨpa dri. Dɨ kìtú nɨ na sè dhɨ, Gìká dré akódhɨ nɨ tɨngázó dràdrà lésè.» ");
INSERT INTO log_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Àmvolásà dhɨ, Zèbèdáyò nɨ tòkó ɨ ànzɨàgo nɨ ɨ́be dhɨ ɨ̀ dré àyɨ kɨ kisízó ànyɨ Yésu làga. Gò tòkó nda dré dhèzo áyɨ kórókó titì akódhɨ kandrá, kɨtswázó tà zi tíá be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yésu tà drá dhɨ: «Mɨ́ adré àdho tà le zìle má tí?» Akódhɨ logó drá dhɨ: «Mɨ́ kòlazí kúlí tayɨ́lé, áma ànzɨàgo rì nɨ ɨ̀ kòlɨrɨ́ró mɨ́ làga ámɨ Òpɨ̀ na: àlo nɨ ámɨ drɨ́ágó lésè, àzya nɨ ámɨ lìdzí lésè.» ");
INSERT INTO log_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yésu logó àyɨ dré dhɨ: «Mɨ̀ nì tà mɨ̀ dré adrélé zìle kòdhɨ ko. Mɨ̀ nɨ kɨtswá tsì kópò kɨzà àdhya má dré adrélé ꞌòle mvùle dhɨ nɨ mvu bwà?» Ɨ̀ logó drá dhɨ: «Mà nɨ kɨtswá.» ");
INSERT INTO log_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Dɨ Yésu tà àyɨ dré dhɨ: «Tà bàti ró dhɨ, mɨ̀ nɨ kópò mána nɨ mvu. Dɨ, kàdré ɨ́na móndɨ́ dra bhàle lɨrɨ́lé áma drɨ́ágó lésè yà, kó ngalè áma lìdzí lésè yà dhɨ kɨ tà sè dhɨ, tà nda kòdhɨ nò ma ko. Áma Atá ledé lɨrɨ́rà nda ɨ dhya dré kɨpèle kɨtswálé lɨrɨ́lé drìá dhɨ ɨ dré.» ");
INSERT INTO log_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Yésu nɨ lebèbhá mudrí àruka ɨ̀ kòyi tà zìle nda dre dhɨ, àyɨ kɨ togó dré aswázó adrúpi rì nda ɨ rú. ");
INSERT INTO log_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Dɨ Yésu dré àyɨ kɨ azízó títí gò, tàzoá àyɨ dré dhɨ: «Mɨ̀ nì tàle dhɨ, móndyá bvò kòndɨ àdhya kɨ kàdrɨ̀ ɨ̀ adré àyɨkya òpɨ̀ nya àyɨ dri rìnyí sè dhɨ be. Àyɨ kɨ dhya kàdrɨ̀kàdrɨ̀ dhɨ ɨ̀ adré kpà tà ꞌo adrézó àyɨ kɨ rìnyí tadhá àyɨ dré. ");
INSERT INTO log_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Dɨ, adré lèá dhɨ, tà nda kàdré kònɨ̀nɨ àmɨ kòfalé ko. Be ró dhɨ, lè dhya ángùdhi adrélépi lèá atsálé kàdrɨ̀ àmɨ kòfalé dhɨ, kàdré àmɨ kɨ màrábà ro. ");
INSERT INTO log_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Lè kpà dhya ángùdhi adrélépi lèá adrélé drìdrì àmɨ kòfalé dhɨ, kàdré àmɨ kɨ màrábà ro. ");
INSERT INTO log_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Kókpà kòdhɨ tɨ́nɨ, Móndɨ́ nɨ Mvá alɨ̀ bvò dri, móndɨ́ ɨ̀ kàdréró tà ꞌo ɨ́ dré dhɨ bvó ko. Be ró dhɨ, alɨ̀ ɨ́na kɨtswálé tà ꞌo móndɨ́ ɨ dré dhɨ bvó. Alɨ̀ kpà kɨtswálé áyɨ lɨ́drɨ̀ fe ngóró làgɨ́ kàdrɨ̀ fèle móndɨ́ zyandre dhɨ kɨ apázó tàkonzɨ̀ lésè dhɨ tɨ́nɨ.» ");
INSERT INTO log_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yésu ɨ̀ dré tá adréràꞌa apfòle bhàandre Yèríkò àdhya lésè dhɨ ꞌá dhɨ, móndɨ́ zyandre lavúlé dhɨ ɨ̀ adré tá alɨ̀le akódhɨ vésè. ");
INSERT INTO log_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Dɨ àgo rì mì kùdúkùdu ró lɨrɨ́bhá láti làga dhɨ ɨ̀ kòyi Yésu adré tá lavúlé dhɨ dre dhɨ, ɨ̀ dré ngàzo adrélé loyóá dhɨ: «Mírì, Dàwídì nɨ Mvá, mɨ́ bhà àma kɨ kɨzà wà!» ");
INSERT INTO log_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Móndyá zyandre nda ɨ̀ dré adrézó tetrélé àyɨ dri, ɨ̀ kòtayɨ́ró kúlí adrézó kɨ́rɨ. Dɨ, ɨ̀ dré gòzo vélé adrélé kúlí loyó wáláká nɨ nɨ lavú: «Mírì, Dàwídì nɨ Mvá, mɨ́ bhà àma kɨ kɨzà wà!» ");
INSERT INTO log_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Gò Yésu dré áyɨ kɨkɨ́zó, àyɨ kɨ azí lizízóá àyɨ tí dhɨ: «Mɨ̀ adré lèá má kòꞌo àmɨ dré àdho tà kòdhya?» ");
INSERT INTO log_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ɨ̀ logó drá dhɨ: «Mírì, àma kɨ mì kònzì ru adrélé ngá no!» ");
INSERT INTO log_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Dɨ Yésu dré kɨzà dòzo áyɨ togó na àyɨ kɨ tà sè gò, dré àyɨ kɨ mì tabèzo. Gbǎ kòdhwa, ɨ̀ dré kɨdhózó adrélé ngá no gò, ɨ̀ dré ngàzo adrélé akódhɨ nɨ lebè. ");
INSERT INTO log_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yésu ɨ̀ dré tá adréràꞌa ꞌòle tsàle Yèrúsalémà na dhɨ ꞌá dhɨ, ɨ̀ dré tsàzo ànyɨ bhà rú zìle Bètèfágè dhɨ kandrá, ànyɨ kòngó Òlívè fa kya làga. Gò Yésu dré áyɨ lebèbhá rì dhɨ kɨ mùzo lɨ̀le drìdrì, ");
INSERT INTO log_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","tàzoá àyɨ dré dhɨ: «Mɨ̀ lɨ̀ bhà àmɨ kandrá kònàdhɨ léna. Kònàle dhɨ, mɨ̀ nɨ ndɨrɨ púndà ꞌɨ̀le dhɨ kɨ kisú, mvámvá nɨ be. Mɨ̀ atrɨ̀ àyɨ, alɨ̀zo àyɨ ɨ́be má vélé. ");
INSERT INTO log_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Dhya àlo kòlizí tà àmɨ tí dhɨ, mɨ̀ kòtà drá dhɨ: ‹Mírì adré lèá nɨ̀.› Dɨ akódhɨ nɨ ndɨrɨ púndà nda kɨ tayɨ́ mɨ̀ dré alɨ̀zo àyɨ ɨ́be.» ");
INSERT INTO log_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Tà nda kòdhɨ atsá kònɨ̀nɨ, kɨtswálé tà longólé pròfétà tí dhɨ kòꞌoró ru be dhɨ bvó. Akódhɨ longó tá dhɨ: ");
INSERT INTO log_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«Mɨ̀ kòtà zapi Sìyónà àdhya dré dhɨ: ‹Mɨ́ nò ká! Ámɨ ópɨ́ adré alɨ̀le mɨ́ vélé. Akódhɨ nɨ togó yàyà, ɨ̀ndɨ̀ lɨrɨ́ ɨ́na púndà dri, púndà nɨ mvámvá dri.›» ");
INSERT INTO log_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Gò Yésu nɨ lebèbhá rì nda ɨ̀ dré lɨ̀zo ꞌòá ngóró dré tàle àyɨ dré dhɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ɨ̀ kàsé púndà nda ɨ mvámvá nɨ be atsázó àyɨ ɨ́be Yésu vélé dre dhɨ, ɨ̀ dré àyɨ kɨ kɨ́tá bhèzo àyɨ dri gò, akódhɨ dré mbàzo lɨrɨ́lé drìá. ");
INSERT INTO log_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Gò móndɨ́ zyandre lavúlé dhɨ ɨ̀ dré àyɨ kɨ kɨ́tá kɨ lasézó láti mǐsè. Àyɨ kɨ àruka ɨ̀ dré fa bí kɨ toŋòzo lebhélé láti mǐsè, Yésu kòlavúró drìásà be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Dɨ móndyá zyandre nda ɨ̀ dré adrézó lɨ̀le akódhɨ kandrána ɨ̀ndɨ̀ akódhɨ vésè, adrélé loyóába dhɨ: «Òsánà kàdré Dàwídì nɨ Mvá dré! Tà tanɨ kàdré dhya adrélépi alɨ̀le Mírì nɨ rú sè dhɨ dri! Òsánà kàdré Gìká kurú na bhù na dhɨ dré!» ");
INSERT INTO log_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yésu kòfɨ Yèrúsalémà na dre dhɨ, móndyá títí bhàandre nda lé dhɨ ɨ̀ dré adrézó lyàle lyàlyà, adrézó lizíá àyɨ kòfalésè dhɨ: «Dhya kòdhɨ àdhi ꞌɨ?» ");
INSERT INTO log_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Dɨ móndyá zyandre adrébhá lɨ̀le Yésu ɨ́be nda ɨ̀ adré tá logóá dhɨ: «Akódhɨ Yésu ꞌɨ, pròfétà angálépi Nàzàrétà, Gàlìláyà na dhɨ lésè dhɨ ꞌɨ.» ");
INSERT INTO log_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Àmvolásà dhɨ, Yésu dré fɨ̀zo tépelò na gò, móndyá títí adrébhá tá ngá lagɨ́ ɨ̀ndɨ̀ ngá gɨ kònàle dhɨ kɨ dro topfòle ꞌásà. Dré mɨ́sá móndyá adrébhá tá làfa topfó dhɨ kya kɨ lebhézó bvò dri, túmä́ní gbólókó móndyá adrébhá tá kòbhòlà lagɨ́ dhɨ kya ɨ́be. ");
INSERT INTO log_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Gò dré tàzoá àyɨ dré dhɨ: «Gìká nɨ Kúlí adré tàá dhɨ: ‹À nɨ áma dzó zi dzó adrézó tà ta má be dhɨ ró.› Dɨ, mɨ̀ gò àmɨkya dzó nda nɨ bha adrélé àrà kùgubhá ɨ̀ dré adrézó àyɨ kɨ zu dhɨ ró!» ");
INSERT INTO log_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Gò móndɨ́ mì kùdúkùdu ró dhɨ ɨ móndɨ́ mèrèkpè ro dhɨ ɨ́be dhɨ ɨ̀ dré àyɨ kɨ kisízó ànyɨ Yésu làga tépelò na gò, akódhɨ dré àyɨ kɨ tɨdrɨ́zó. ");
INSERT INTO log_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Dɨ kòwánà kàdrɨ̀ ɨ tátrɨ́trɨ́ kúlí tadhábhá ɨ́be dhɨ ɨ̀ nò tá tà lɨ́ndrɨ́ga ró Yésu dré ꞌòle nda ɨ. Ɨ̀ yi tá kpà ànzɨmvá adréràꞌa kúlí loyó tépelò na adrézó tàá dhɨ: «Òsánà kàdré Dàwídì nɨ Mvá dré!» Dɨ àyɨ kɨ togó dré aswázó Yésu rú gò, ");
INSERT INTO log_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ɨ̀ dré lizízóá tíá dhɨ: «Mɨ́ adré tà ànzɨmvá nɨ ɨ̀ dré adrélé tàle kòdhɨ nɨ yi?» Yésu logó àyɨ dré dhɨ: «Àyíya! Mɨ̀ nà rè Gìká nɨ Kúlí na ko tàle dhɨ, ‹Mɨ́ ꞌo ànzɨmvá ɨ ànzɨ kùrí ɨ́be dhɨ ɨ adrélé ámɨ rú bha kùle› dhɨ?» ");
INSERT INTO log_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Dɨ Yésu dré àyɨ kɨ tayɨ́zó gò, pfòzo bhàandre ꞌásè lɨ̀le ayílé Bètànɨ́yà na. ");
INSERT INTO log_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Drùbhì kɨ́nó, Yésu dré tá adréràꞌa gòle Yèrúsalémà na dhɨ ꞌá dhɨ, tàbirí dré akódhɨ nɨ ꞌòzo. ");
INSERT INTO log_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Akódhɨ dré fígì fa àlo dhɨ nɨ nòzo láti mìle. Dɨ, a nɨ lɨ tsàle ànyɨ làgá dhɨ, kisú ɨ́na lòꞌwa nɨ àlomvá ko. Kisú ngbà ꞌí bí nɨ ɨ kòdhya. Dɨ dré tàzoá fígì fa nda dré dhɨ: «Mɨ́ kògò vélé lòꞌwa ꞌa tàdzí ko!» Gbǎ kòdhwa, fa nda dré ꞌyòzo. ");
INSERT INTO log_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Akódhɨ nɨ lebèbhá ɨ̀ kònò tà nda dre dhɨ, àyɨ kɨ lɨ́ndrɨ́ dré gàzo gò, ɨ̀ dré akódhɨ nɨ lizízó tàzoá dhɨ: «Fígì fa kònɨ̀dhɨ ꞌyo ɨ́na mbèlè kònɨ̀nɨ ngɨ́nɨngɨ́nɨ ró?» ");
INSERT INTO log_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yésu logó àyɨ dré dhɨ: «Má adré tà bàti ta àmɨ dré: Mɨ̀ kàdré tà kaꞌìkaꞌì ɨ́be gò, adrézó tà kayí àmɨ léna ko dhɨ, mɨ̀ nɨ kókpà kɨtswá tà làsú be kònɨ̀nɨ dhɨ kɨ ꞌo, túmä́ní tà kàdrɨ̀ dra tà nda kɨ lavúbhá dhɨ ɨ́be. Mɨ̀ nɨ kɨtswá ndɨ̀ndɨ̀ tàá kòngó kònɨ̀dhɨ dré dhɨ, ‹Mɨ́ nga kònwásè lɨ̀le dhèle yǐandre na!› gò, tà nda dré ru ꞌòzo. ");
INSERT INTO log_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Tà ángùdhi mɨ̀ dré dra zìle Gìká tí, adrézó kaꞌìá dhɨ akódhɨ nɨ ꞌòá dhɨ, mɨ̀ nɨ tà nda nɨ kisú.» ");
INSERT INTO log_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Àmvolásà dhɨ, Yésu dré gòzo fɨ̀le tépelò na gò, kɨdhólé adrélé tà tadhá móndɨ́ ɨ dré. Gò kòwánà kàdrɨ̀ ɨ bhàgo ɨ́be dhɨ ɨ̀ dré alɨ̀zo akódhɨ vélé lizíá tíá dhɨ: «Rìnyí mɨ́ dré adrézó tà kòdhɨ kɨ ꞌo dhɨ angá ɨ́na ángolésè? Àdhi fè rìnyí nda mɨ́ dré nɨ̀?» ");
INSERT INTO log_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yésu logó àyɨ dré dhɨ: «Má nɨ kókpà tà àlo dhɨ nɨ lizí àmɨ tí. Mɨ̀ kòlogó kúlí má tí dhɨ, má nɨ kpà tàá àmɨ dré ngalè rìnyí má dré adrézó tà kòdhɨ kɨ ꞌo dhɨ angá ángolésè ya dhɨ. ");
INSERT INTO log_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Bàtísimò Yòwánɨ̀ dré fèle dhɨ angá tá ɨ́na ángolésè: Gìká vélésè, kó ngalè móndɨ́ ɨ vélésè?» Gò ɨ̀ dré dhèzo adrélé tà kayí àyɨ kòfalésè, adrézó tàá dhɨ: «Mà kòtà dhɨ ‹Bàtísimò nda angá Gìká vélésè› dhɨ, akódhɨ nɨ go lizíá àma tí dhɨ: ‹Mɨ̀ kaꞌì dɨ Yòwánɨ̀ ko àdho tà sè?› ");
INSERT INTO log_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Dɨ, mà kòtà kó dhɨ ‹Bàtísimò nda angá móndɨ́ ɨ vélésè› dhɨ, mà nɨ go móndyá zyandre dhɨ kɨ ro. Tàko ko, àyɨ títí nda ɨ̀ adré kaꞌìá dhɨ, Yòwánɨ̀ tá ɨ́na pròfétà ꞌɨ.» ");
INSERT INTO log_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Dɨ ɨ̀ dré logózóá Yésu dré dhɨ: «Mà nì ko.» Yésu gò tàá àyɨ dré dhɨ: «Kàdré kònɨ̀nɨ dhɨ, má kɨtswá kókpà tàá àmɨ dré ngalè rìnyí má dré adrézó tà nda kɨ ꞌo dhɨ angá ángolésè ya dhɨ ko.» ");
INSERT INTO log_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yésu gò tàá dhɨ: «Mɨ̀ kisù àmɨkya tà kònɨ̀dhɨ dri ngɨ́nɨ? Agó àlo dhɨ tá ànzɨàgo ɨ́be rì. Dré lɨ̀zo mváagó nɨ àlo véna tàá drá dhɨ: ‹Áma mvá, mɨ́ lɨ̀ ándrò àzí ꞌo vínò amvú na.› ");
INSERT INTO log_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Dɨ mváagó nda logó drá dhɨ: ‹Kóko. Má lè lɨ̀le ko.› Dɨ, dré gòzo áyɨ tà kisùle nda nɨ ladzá gò, lɨ̀zo àzí ꞌo. ");
INSERT INTO log_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Agó nda dré kpà lɨ̀zo mváagó nɨ rì véna, tàá drá làsú be kònɨ̀nɨ. Mváagó nda dré logózóá drá dhɨ: ‹Àyíya, atálágó, má nɨ lɨ.› Dɨ, dré ɨ́na lɨ̀zo ko. ");
INSERT INTO log_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Àyɨ rìti nda ɨ kòfalé dhɨ, àdhi ꞌo tà áyɨ atá dré tá lèle dhɨ nɨ̀?» Ɨ̀ logó drá dhɨ: «Mváagó nɨ àlo ꞌɨ.» Yésu gò tàá àyɨ dré dhɨ: «Má adré tà bàti ta àmɨ dré: Mèdáyɨ̀ lagɨ́bhá ɨ tòkó zàràbhù ro dhɨ ɨ́be dhɨ kɨ fɨ Gìká nɨ Òpɨ̀ na drìdrì àmɨ kandrána. ");
INSERT INTO log_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Tàko ko, Yòwánɨ̀ alɨ̀ tá láti tà gyǎgya àdhya nɨ tadhá àmɨ dré gò, mɨ̀ dré àmɨkya akódhɨ nɨ kaꞌìzo ko. Dɨ, mèdáyɨ̀ lagɨ́bhá ɨ tòkó zàràbhù ro dhɨ ɨ́be dhɨ ɨ̀ kaꞌì tá àyɨkya akódhɨ ꞌí. Tágba mɨ̀ dré tá àyɨ nda kɨ tà kaꞌìkaꞌì nòzo dhɨ, mɨ̀ gò àmɨ kɨ togó ladzá akódhɨ nɨ kaꞌì ko.» ");
INSERT INTO log_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","«Mɨ̀ yi rè pɨ́dhɨ́gó àzya ká. Amvú líyí àlo dhɨ bhe tá vínò áyɨ amvú na. Dré gàrà nɨ kɨ tobhàzo kɨ́rà sè, bhú gàzo kɨtswázó vínò lòꞌwa zwa gò, dzó mvumvù dhɨ nɨ sìzo kɨtswázó amvú nda nɨ lɨkɨ́. Dré amvú nda nɨ tayɨ́zó vínò lɨkɨ́bhá àruka ɨ drɨ́gá gò, lɨ̀zo atsí na làwú làvo na. ");
INSERT INTO log_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Lókyá vínò lòꞌwa kɨ̀zo dhɨ kòkɨtswá dre dhɨ, dré áyɨ màrábà kɨ mùzo kɨtswálé lòꞌwa ɨ́na tɨ́nɨ dhɨ nɨ adó vínò lɨkɨ́bhá nda ɨ véna. ");
INSERT INTO log_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Dɨ, vínò lɨkɨ́bhá nda ɨ̀ dré àyɨkya màrábà nda kɨ turúzó, àlo nɨ nɨ tswàzo, àzya nɨ nɨ pfùzo dràle gò, àzya nɨ nɨ lebhézó dràle kɨ́rà sè. ");
INSERT INTO log_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Gò amvú líyí nda dré gòzo màrábà àruka bǐ wáláká nɨ kɨ lavúbhá dhɨ kɨ mu lɨ̀le. Dɨ, vínò lɨkɨ́bhá nda ɨ̀ dré kpà àyɨ kɨ ꞌòzo ngóró ɨ̀ dré tá ꞌòle drìdrì dhɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Kùdù ro dhɨ, amvú líyí nda dré áyɨ mváagó nɨ mùzo lɨ̀le àyɨ véna. Adré tá kisùá dhɨ: ‹Ɨ̀ nɨ áma mváagó nɨ lɨndrɨ̀ bha!› ");
INSERT INTO log_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Dɨ, vínò lɨkɨ́bhá nda ɨ̀ kònò mváagó nda adréràꞌa alɨ̀le dre dhɨ, ɨ̀ dré tàzoá àyɨ kòfalésè dhɨ: ‹Kònàdhɨ dhya dra amvú kònɨ̀dhɨ nɨ kisúlépi tàyɨlé ro dhɨ ꞌɨ. Mà kòlɨ̀ akódhɨ nɨ pfu dràle, amvú dré tá kɨtswálé kisúlé tàyɨlé ro nda nɨ dòzo àma dré!› ");
INSERT INTO log_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Dɨ ɨ̀ dré ngàzo akódhɨ nɨ ru bhèle amvú nda ꞌásè kɨvɨ̀ na gò, pfùzoá dràle.» ");
INSERT INTO log_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yésu gò lizíá dhɨ: «Lókyá amvú líyí nda dré dra agòzo dhɨ tú dhɨ, a nɨ ꞌòá ngɨ́nɨ vínò lɨkɨ́bhá nda kɨ tà sè dhɨ?» ");
INSERT INTO log_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ɨ̀ logó drá dhɨ: «A nɨ drìkònzɨbhá nda kɨ tupfú todràle gò, gòzo amvú nda nɨ tayɨ́ vínò lɨkɨ́bhá àruka ɨ drɨ́gá, ɨ̀ kòlogóró ɨ́ dré vínò lòꞌwa ɨ́na tɨ́nɨ dhɨ lókyá lòꞌwa nda nɨ kɨ̀zo dhɨ sè.» ");
INSERT INTO log_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yésu gò tàá àyɨ dré dhɨ: «Mɨ̀ nà rè tà tɨsɨ̀le kònɨ̀dhɨ Gìká nɨ Kúlí na ko? ‹Kɨ́rà dzó sibhá ɨ̀ dré gàle gàgà dhɨ, gò atsálé kɨ́rà agógó dzó nda dré adrézó áyɨ totó drìá dhɨ ró. Kòrɨ̀dhɨ tà Mírì dré ꞌòle nɨ̀ dhɨ ꞌɨ. Dɨ tà nda lɨ́ndrɨ́ga ró àma mìlésè!› ");
INSERT INTO log_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Má adré dɨ tàá àmɨ dré dhɨ: Gìká nɨ áyɨ Òpɨ̀ tɨngá àmɨ drɨ́gásè gò, fèzoá móndyá dra Òpɨ̀ nda nɨ lòꞌwa ꞌabhá dhɨ ɨ dré. ");
INSERT INTO log_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Dhya ángùdhi dra dhèlepi kɨ́rà nda dri dhɨ nɨ ŋo. Kòdhɨ ɨ́be dhɨ, kɨ́rà nda nɨ dhya ángùdhi ɨ́ dré dra adhézó drìá dhɨ nɨ kɨnyɨ́.» ");
INSERT INTO log_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Kòwánà kàdrɨ̀ ɨ Fàrìsáyò ɨ́be dhɨ ɨ̀ kòyi pɨ́dhɨ́gó Yésu dré pɨ̀le nda ɨ dre dhɨ, ɨ̀ dré nìzoá tàle dhɨ, akódhɨ tà tá tà nda ɨ àyɨ rú dhɨ be. ");
INSERT INTO log_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Gò ɨ̀ dré ngàzo adrélé láti nda kɨtswázó akódhɨ nɨ ru. Dɨ, ɨ̀ adré tá àyɨkya móndyá zyandre dhɨ kɨ ro, àyɨ nda ɨ̀ dré tá adrélé Yésu nɨ no pròfétà ro dhɨ sè. ");
INSERT INTO log_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Gò Yésu dré gòzo tódhyá tà tadhá àyɨ dré pɨ́dhɨ́gó sè, tàzoá dhɨ: ");
INSERT INTO log_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Òpɨ̀ bhù àdhya sù ngóró tà kònɨ̀dhɨ tɨ́nɨ: Ópɨ́ àlo dhɨ adré tá gwányá làmó àdhya nɨ ꞌo áyɨ mváagó dré. ");
INSERT INTO log_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Dré áyɨ màrábà kɨ mùzo lɨ̀le móndyá dré tá azílé gwányá nda lé dhɨ kɨ azí ngá nya. Dɨ, àyɨ nda ɨ̀ dré àyɨkya gàzo rè. ");
INSERT INTO log_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Dɨ ópɨ́ nda dré gòzo màrábà àruka kɨ mu lɨ̀le kúlí kònɨ kɨ ta móndyá azílé nda ɨ dré: ‹Mɨ̀ yi rè ká! Má ꞌo ngá títí dhɨ ɨ ladhɨ́lé áma gwányá sè dhɨ dre. Má ꞌo áma tíàgo ɨ tilílé, áma tí ngbòlò dò ro dhɨ ɨ́be. Tà títí dhɨ ɨ̀ kɨtswá dre. Mɨ̀ alɨ̀ gwányá lé wà!› ");
INSERT INTO log_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Dɨ, móndyá azílé nda ɨ̀ dré àyɨkya tà nda nɨ nòzo tà tàko ró. Gò ɨ̀ dré lɨ̀zo àyɨ kɨ tà ꞌobe kòdhya. Àlo nɨ lɨ̀ tá áyɨ amvú na. Àzya nɨ lɨ̀ ɨ́na áyɨ àzí làfa àdhya kɨ tà ꞌobe. ");
INSERT INTO log_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Àyɨ kɨ àruka ɨ̀ dré màrábà nda kɨ turúzó, àyɨ kɨ ꞌòzo kònzɨ gò, àyɨ kɨ tupfúzó todràle. ");
INSERT INTO log_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Dɨ ópɨ́ nda nɨ togó dré aswázó tà nda sè. Dré áyɨ sòdá zyandre dhɨ kɨ mùzo lɨ̀le móndyá kàrɨ́ kutúbhá nda kɨ tupfú todràle gò, bhàandre àyɨkya nɨ zàzo vèle. ");
INSERT INTO log_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Gò dré tàzoá áyɨ màrábà ɨ dré dhɨ: ‹Gwányá làmó àdhya gànzi ró. Dɨ, móndyá má dré azílé nda ɨ̀ kɨtswá tá àyɨkya gwányá nda sè ko. ");
INSERT INTO log_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Dɨ ásà dhɨ, mɨ̀ lɨ̀ láti andre ɨ ꞌásè, móndyá títí mɨ̀ dré dra kisúlé dhɨ kɨ azí alɨ̀le gwányá lé.› ");
INSERT INTO log_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Dɨ màrábà nda ɨ̀ dré lɨ̀zo láti ɨ ꞌásè, móndyá títí ɨ̀ dré kisúlé dhɨ kɨ kɨmó alɨ̀zo àyɨ ɨ́be, tágba àyɨ nda ɨ̀ kàdré tá móndɨ́ dóro ꞌɨ yà, kó ngalè móndɨ́ kònzɨ ꞌɨ yà dhɨ. Gò dzó làmó gwányá àdhya dré gàzo móndyá azílé nda ɨ sè bǐ. ");
INSERT INTO log_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Dɨ, ópɨ́ nda kàfɨ́ móndyá azílé nda kɨ no dre dhɨ, dré agó àlo kɨ́tá làmó gwányá àdhya nɨ asólépi ko dhɨ nɨ nòzo. ");
INSERT INTO log_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Dré lizízóá tíá dhɨ: ‹Áma arúpi, mɨ́ afɨ́ kònwa kɨ́tá làmó gwányá àdhya àko ngɨ́nɨngɨ́nɨ ró?› Agó nda tá kúlí logólé dhɨ àko. ");
INSERT INTO log_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Dɨ ópɨ́ nda dré tàzoá áyɨ màrábà ɨ dré dhɨ: ‹Mɨ̀ adrò akódhɨ nɨ pá ɨ drɨ́gá nɨ ɨ́be, akódhɨ nɨ bhèzo kɨvɨ̀ na, àrà tínímvá ro dhɨ na. Kònàle dhɨ, à nɨ adré tongólé, adrézó kpà síkálándrá tsɨ.› ");
INSERT INTO log_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Tàko ko, à adré móndɨ́ zyandre dhɨ kɨ azí. Dɨ, à adré ngbà ꞌí móndɨ́ àlo àlo dhɨ kɨ kɨpè kòdhya.» ");
INSERT INTO log_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Àmvolásà dhɨ, Fàrìsáyò ɨ̀ dré ngàzo ru yi, kɨtswázó Yésu nɨ ꞌo laꞌɨ̀le kúlí dré tá adrélé tàle dhɨ ɨ sílé dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Dɨ ɨ̀ dré àyɨ kɨ lebèbhá kɨ mùzo móndɨ́ àruka ópɨ́ Èródè àdhya ɨ́be lɨ̀le Yésu véna tàá drá dhɨ: «Tadhálépi, mà nì tàle dhɨ, mɨ́ adré tròle tà bàti rú dhɨ be. Mɨ́ adré Gìká nɨ tà tadhá tà bàti sè. Mɨ́ adré kpà móndɨ́ kɨ lɨndrɨ̀ nɨ tà kisù ko, mɨ́ dré adrélé àyɨ kɨ no twátwa ko dhɨ sè. ");
INSERT INTO log_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Dɨ mɨ́ tà rè àma dré tà mɨ́ dré adrélé kisùle tà kònɨ̀dhɨ dri dhɨ ká: Àma kɨ tátrɨ́trɨ́ kúlí kaꞌì, mà kàdré Kàyìsárà nɨ mèdáyɨ̀ gɨ dhɨ ꞌí? Kó ngalè, kaꞌì ko?» ");
INSERT INTO log_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Dɨ, Yésu dré ɨ́na tà kònzɨ ɨ̀ dré tá adrélé lèle ꞌòle nda nɨ nìzo kyá gò, logózóá àyɨ dré dhɨ: «Àmɨ túrúpfúbhá nɨ ɨ, mɨ̀ adré áma tabhì lɨtɨ́lé àdho tà sè? ");
INSERT INTO log_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mɨ̀ tadhá má dré làfa lòꞌwa adrézó mèdáyɨ̀ gɨ ásà dhɨ.» Dɨ ɨ̀ dré dènárì àlo dhɨ nɨ fèzo drá. ");
INSERT INTO log_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Gò dré lizízóá àyɨ tí dhɨ: «Móndɨ́ lɨ́ndrɨ́ kònɨ̀dhɨ tsàle rú tɨsɨ̀le drìá kònɨ̀dhɨ be dhɨ, àdhi àdhya ꞌɨ?» ");
INSERT INTO log_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ɨ̀ logó drá dhɨ: «Kàyìsárà àdhya ꞌɨ.» Dɨ Yésu tà àyɨ dré dhɨ: «Mɨ̀ kàdré dɨ ngá Kàyìsárà àdhya nɨ fe Kàyìsárà dré, adrézó kpà ngá Gìká àdhya nɨ fe Gìká dré.» ");
INSERT INTO log_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ɨ̀ kòyi akódhɨ nɨ kúlí nda dre dhɨ, àyɨ kɨ lɨ́ndrɨ́ dré gàzo gò, ɨ̀ dré akódhɨ nɨ tayɨ́zó lɨ̀zo. ");
INSERT INTO log_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Kìtú nda sè dhɨ, Sàdùkáyò àruka ɨ̀ dré alɨ̀zo Yésu vélé kɨtswálé tà lizí tíá. (Àyɨ nda ɨ̀ adré tàá dhɨ, ngangà dràdrà ꞌásè dhɨ yókódhó.) Dɨ ɨ̀ tà drá dhɨ: ");
INSERT INTO log_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«Tadhálépi, Mósè tɨsɨ̀ àma dré dhɨ: ‹Agó àlo adrélépi mvá àko dhɨ kòdrà áyɨ tòkó nɨ tayɨ́ dhɨ, lè adrúpi nɨ kòdo tàyɨ́tòkó nda mòle, kɨtswázó ànzɨ ti áyɨ adrúpi dràlepi nda dré.› ");
INSERT INTO log_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Dɨ àma kòfalé dhɨ, àgo nzi-drì-rì adrúpi ró dhɨ ɨ tá be. Àyɨ kɨ kàyo dré tòkó àlo dhɨ nɨ mòzo gò, dràzo. Dré tá adrélé mvá àko dhɨ sè dhɨ, dré áyɨ tòkó nda nɨ tayɨ́zó áyɨ adrúpi ɨ́ bvó dhɨ dré. ");
INSERT INTO log_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Tà nda dré kpà ru ꞌòzo kònɨ̀nɨ adrúpi nɨ nɨ rì rú, adrúpi nɨ nɨ na rú, tsàle byá adrúpi nɨ nɨ nzi-drì-rì rú. ");
INSERT INTO log_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Kùdù ro dhɨ, tòkó nda dré kpà dràzo. ");
INSERT INTO log_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Dɨ kìtú móndɨ́ ɨ̀ dré dra ngàzo dràdrà ꞌásè dhɨ tú dhɨ, adrúpi nzi-drì-rì nda ɨ kòfalé dhɨ, tòkó nda nɨ adré tsítsì dhɨ àdhi dré? Àngyá ko, àyɨ títí nda ɨ̀ do tá akódhɨ mòle àyɨ dré tòko ró.» ");
INSERT INTO log_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yésu logó àyɨ dré dhɨ: «Mɨ̀ lɨtɨ́ àmɨ kɨ tàndɨ ɨ dre, mɨ̀ dré Gìká nɨ Kúlí ɨ rìnyí nɨ ɨ́be dhɨ kɨ nìle ko dhɨ sè. ");
INSERT INTO log_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Kìtú móndɨ́ ɨ̀ dré dra ngàzo dràdrà ꞌásè dhɨ tú dhɨ, ɨ̀ gò adrélé ru mo ko. Ɨ̀ gò kpà adrélé àyɨ kɨ ànzɨ kɨ fe mòle ko. Be ró dhɨ, ɨ̀ nɨ àyɨkya adré ngóró ángéló bhù na dhɨ ɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Dɨ kàdré ɨ́na ngangà dràdrà ꞌásè dhɨ nɨ tà sè dhɨ, mɨ̀ nà rè tà Gìká dré tàle àmɨ dré dhɨ ko? Akódhɨ tà dhɨ: ");
INSERT INTO log_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‹Ma Gìká Àbàrámà àdhya ꞌɨ, Ɨ̀sákà àdhya ꞌɨ, ɨ̀ndɨ̀ Yàkóbhò àdhya ꞌɨ.› Dɨ Gìká nda Gìká àbvò kya ꞌɨ ko. Be ró dhɨ, akódhɨ ɨ́na Gìká móndyá lɨ́drɨ̀ ro dhɨ kya ꞌɨ.» ");
INSERT INTO log_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Dɨ móndyá zyandre kònàle dhɨ ɨ̀ kòyi tà nda dre dhɨ, àyɨ kɨ lɨ́ndrɨ́ dré adrézó gàle tà Yésu dré adrélé tadhálé dhɨ ɨ sè. ");
INSERT INTO log_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Fàrìsáyò ɨ̀ kòyi, Yésu kɨkɨ́ tá Sàdùkáyò kɨ kúlí dre dhɨ, ɨ̀ dré gòzo ru kɨmó akódhɨ làga. ");
INSERT INTO log_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Gò àyɨ kɨ àlo Mósè nɨ tátrɨ́trɨ́ kúlí nìlepi dóro lavúlé dhɨ dré tà kònɨ̀dhɨ nɨ lizízó akódhɨ tí, kɨtswázó akódhɨ nɨ tabhì: ");
INSERT INTO log_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Tadhálépi, Mósè nɨ tátrɨ́trɨ́ kúlí na dhɨ, tòlɨ́ kàdrɨ̀ lavúlé dhɨ ángùdhi ꞌɨ?» ");
INSERT INTO log_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Dɨ Yésu logó drá dhɨ: «‹Lè mɨ́ kàdré Mírì ámɨ Gìká nɨ le ámɨ togó sè wä́yi, ámɨ lɨ́drɨ̀ sè wä́yi, ɨ̀ndɨ̀ ámɨ tà kisùkisù sè wä́yi.› ");
INSERT INTO log_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Kòdhɨ tòlɨ́ drìdrì dhɨ ꞌɨ, ɨ̀ndɨ̀ tòlɨ́ kàdrɨ̀ lavúlé dhɨ ꞌɨ. ");
INSERT INTO log_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Tòlɨ́ nɨ rì adrélépi kpà kàdrɨ̀ àlo nɨ tɨ́nɨ dhɨ, kònɨ̀dhɨ ꞌɨ: ‹Lè mɨ́ kàdré ámɨ àzya nɨ le ngóró mɨ́ dré adrélé ámɨ tàndɨ nɨ le dhɨ tɨ́nɨ.› ");
INSERT INTO log_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Tà títí Mósè nɨ tátrɨ́trɨ́ kúlí ɨ̀ndɨ̀ pròfétà ɨ̀ dré adrélé tadhálé dhɨ ɨ̀ adré àyɨ kɨ totó tòlɨ́ rì nda kòdhɨ ɨ dri.» ");
INSERT INTO log_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Fàrìsáyò ru kɨmóbhá nda ɨ̀ dré rè dhu adréràꞌa Yésu làga dhɨ ꞌá dhɨ, akódhɨ dré lizízóá àyɨ tí dhɨ: ");
INSERT INTO log_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«Mɨ̀ kisù àmɨkya Mèsɨ́yà nɨ tà sè ngɨ́nɨ? Akódhɨ àdhi nɨ mvá ꞌɨ?» Ɨ̀ logó drá dhɨ: «Akódhɨ Dàwídì nɨ mvá ꞌɨ.» ");
INSERT INTO log_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Dɨ Yésu tà àyɨ dré dhɨ: «Kàdré kònɨ̀nɨ dhɨ, Dàwídì dré tá adréràꞌa tà ta Tɨrɨ́ Lólo nɨ rìnyí sè dhɨ ꞌá dhɨ, zi ɨ́na Mèsɨ́yà nda áyɨ Mírì ro ngɨ́nɨ? Àngyá ko, Dàwídì tà tá dhɨ: ");
INSERT INTO log_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‹Mírì Gìká tà áma Mírì dré dhɨ: Mɨ́ alɨ̀ lɨrɨ́lé áma drɨ́ágó lésè, tsàle lókyá má dré dra ámɨ kàrɨbhá kɨ bhàzo adrélé ámɨ pá zàle dhɨ ꞌá.› ");
INSERT INTO log_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Dɨ Dàwídì kòzi Mèsɨ́yà áyɨ Mírì ro dhɨ, Mèsɨ́yà nda nɨ kɨtswá kpà adrélé akódhɨ nɨ mvá ro ngɨ́nɨngɨ́nɨ ró?» ");
INSERT INTO log_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Dɨ dhya àlo àyɨ kòfalé kɨtswálépi kúlí logó Yésu tí dhɨ tá yókódhó. Kɨdhólé kìtú nda sè dhɨ, dhya àlo dré gòzo vélé tà tabhì lizílé akódhɨ tí ko. ");
INSERT INTO log_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Gò Yésu dré tàzoá móndyá zyandre ɨ dré áyɨ lebèbhá ɨ́be dhɨ: ");
INSERT INTO log_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«À tayɨ́ àzí tátrɨ́trɨ́ kúlí tadhábhá ɨ drɨ́gá Fàrìsáyò ɨ́be, ɨ̀ kàdréró Mósè nɨ tátrɨ́trɨ́ kúlí nɨ tà tadhá móndɨ́ ɨ dré. ");
INSERT INTO log_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Adré dɨ lèá dhɨ, mɨ̀ kàdré àyɨ nda kɨ kúlí yi, adrézó tà títí ɨ̀ dré adrélé tàle àmɨ dré dhɨ kɨ kaꞌì ꞌòle. Dɨ, mɨ̀ kàdré àmɨkya tà ɨ̀ dré adrélé ꞌòle dhɨ kɨ ꞌo kòdhya ko. Tàko ko, ɨ̀ adré tà ɨ̀ dré adrélé tadhálé dhɨ kɨ ꞌo kòdhya ko. ");
INSERT INTO log_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ɨ̀ adré àyɨkya ngá lanzìlanzì kɨtswálé dòle bwà ko dhɨ kɨ todrò tobhàle móndɨ́ ɨ dri gò, ɨ̀ dré adrézó ndɨ̀ndɨ̀ drɨ́gámbɨ́lɨ́ le sòle àyɨ kɨ ledézó dhɨ ko. ");
INSERT INTO log_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Tà títí ɨ̀ dré adrélé ꞌòle dhɨ ɨ, ɨ̀ adré ꞌòá móndɨ́ ɨ̀ kàdréró àyɨ kɨ no be dhɨ bvó. Ɨ̀ adré àyɨ kɨ kpúkúbhú tsàtsà adrézó wárágà Gìká nɨ Kúlí tɨsɨ̀zo drìá dhɨ kɨ tobhà lána dhɨ kɨ kɨwá, adrézó kpà àyɨ kɨ kánzò kɨ ti ꞌo atsálé kàtswa. ");
INSERT INTO log_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ɨ̀ adré lèá lɨrɨ́lé mɨ́sá lɨndrɨ̀ àdhya gwányá ɨ ꞌásè dhɨ ɨ làgásè, adrézó kpà lèá lɨrɨ́lé àrà lɨndrɨ̀ àdhya lɨ̀sámbò dzó ɨ ꞌásè dhɨ ɨ ꞌásè. ");
INSERT INTO log_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ɨ̀ adré lèá dhɨ, à kàdré mòdo fe àyɨ dré lɨndrɨ̀ sè ngá lagɨ́rà ɨ ꞌásè, adrézó kpà àyɨ kɨ zi ‹Rábbì›. ");
INSERT INTO log_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Dɨ, àmɨ ró dhɨ, mɨ̀ kòtayɨ́ àmɨ adrélé zìle Rábbì ro ko. Àngyá ko, àmɨ kɨ tadhálépi ngbà ꞌí àlo kwákwá, ɨ̀ndɨ̀ àmɨ títí dhɨ ɨ adrúpi ꞌɨ. ");
INSERT INTO log_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Mɨ̀ kàdré kpà dhya àlo bvò dri dhɨ nɨ zi àmɨ kɨ Atá ro ko. Àngyá ko, àmɨ kɨ Atá ngbà ꞌí àlo kwákwá. Akódhɨ àmɨ kɨ Atá bhù na dhɨ ꞌɨ. ");
INSERT INTO log_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Mɨ̀ kòtayɨ́ kpà àmɨ adrélé zìle móndɨ́ kɨ drì kòlepi ró ko. Àngyá ko, àmɨ kɨ drì kòlepi ngbà ꞌí àlo kwákwá. Akódhɨ Mèsɨ́yà ꞌɨ. ");
INSERT INTO log_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Adré lèá dhɨ, dhya kàdrɨ̀ lavúlé àmɨ kòfalé dhɨ kàdré àmɨ kɨ màrábà ro. ");
INSERT INTO log_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Tàko ko, dhya ángùdhi adrélépi áyɨ tà bha kuru dhɨ, Gìká nɨ akódhɨ nda nɨ tà tɨrɨ́ kìní mi. Dɨ, dhya ángùdhi adrélépi áyɨ tà bha kìní mi dhɨ, Gìká nɨ akódhɨ nda nɨ tà tɨngá kuru. ");
INSERT INTO log_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Àmɨ, tátrɨ́trɨ́ kúlí tadhábhá ɨ Fàrìsáyò ɨ́be nɨ ɨ, kɨzà àmɨ kɨ ngá ꞌɨ. Àmɨ túrúpfúbhá ꞌɨ! Tàko ko, mɨ̀ adré àmɨkya láti kɨkɨ́ móndɨ́ ɨ dré, ɨ̀ kòfɨró Òpɨ̀ bhù àdhya na ko. Àmɨ kɨ tàndɨ, mɨ̀ adré fɨ̀le lána ko gò, mɨ̀ dré adrézó móndyá adrébhá lèá fɨ̀le lána dhɨ kɨ tayɨ́ fɨ̀le ko.  ");
INSERT INTO log_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Àmɨ, tátrɨ́trɨ́ kúlí tadhábhá ɨ Fàrìsáyò ɨ́be nɨ ɨ, kɨzà àmɨ kɨ ngá ꞌɨ. Àmɨ túrúpfúbhá ꞌɨ! Mɨ̀ adré àmɨkya tatsílé bvò drǐsè ɨ̀ndɨ̀ yǐ mǐsè, kɨtswálé móndɨ́ àlo dhɨ nɨ ꞌo togó ladzá àmɨ kɨ Gìká nɨ kaꞌì. Dɨ, akódhɨ nda kònɨ̀ dra kaꞌì dhɨ, mɨ̀ adré akódhɨ nɨ ꞌo atsálé mvá líferò àdhya ró, adrélé kònzɨ àmɨ kɨ lavú vwàvwà ro. ");
INSERT INTO log_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Àmɨ móndɨ́ kɨ drì kobhá mì kùdúkùdu ró nɨ ɨ, kɨzà àmɨ kɨ ngá ꞌɨ! Mɨ̀ adré àmɨkya tàá dhɨ, dhya àlo kàdré mòndrà sɨ tépelò nɨ rú sè dhɨ, mòndrà nda tà tàko ꞌɨ. Dɨ, dhya àlo kàdré ɨ́na mòndrà sɨ órò tépelò le dhɨ nɨ rú sè dhɨ, lè akódhɨ kàdré mòndrà dré sɨ̀le nda nɨ lɨkɨ́. ");
INSERT INTO log_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Àmɨ móndɨ́ azaaza mì kùdúkùdu ró dhɨ ꞌɨ! Ngá kàdrɨ̀ lavúlé dhɨ ángùdhi ꞌɨ: órò nda ꞌɨ, kó ngalè, tépelò adrélépi órò nda nɨ ꞌo atsálé lólo nda ꞌɨ? ");
INSERT INTO log_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Mɨ̀ adré kpà tàá dhɨ, dhya àlo kàdré mòndrà sɨ àlètárɨ̀ nɨ rú sè dhɨ, mòndrà nda tà tàko ꞌɨ. Dɨ, dhya àlo kàdré ɨ́na mòndrà sɨ ngá fèle àlètárɨ̀ nda dri dhɨ nɨ rú sè dhɨ, lè akódhɨ kàdré mòndrà nda nɨ lɨkɨ́. ");
INSERT INTO log_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Àmɨ mì kùdúkùdu ꞌɨ! Ngá kàdrɨ̀ lavúlé dhɨ ángùdhi ꞌɨ: ngá fèle nda ꞌɨ, kó ngalè, àlètárɨ̀ adrélépi ngá nda nɨ ꞌo atsálé lólo nda ꞌɨ? ");
INSERT INTO log_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Dɨ dhya ángùdhi adrélépi mòndrà sɨ àlètárɨ̀ nɨ rú sè dhɨ, adré sɨ̀á àlètárɨ̀ nda nɨ rú sè, ɨ̀ndɨ̀ ngá títí drìá dhɨ kɨ rú sè. ");
INSERT INTO log_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Dhya ángùdhi adrélépi mòndrà sɨ tépelò nɨ rú sè dhɨ, adré sɨ̀á tépelò nda nɨ rú sè, ɨ̀ndɨ̀ Gìká adrélépi adrélé lána dhɨ nɨ rú sè. ");
INSERT INTO log_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Dhya ángùdhi adrélépi mòndrà sɨ bhù nɨ rú sè dhɨ, adré sɨ̀á Gìká nɨ lɨrɨ́rà òpɨ̀ àdhya nɨ rú sè, ɨ̀ndɨ̀ akódhɨ adrélépi lɨrɨ́lé drìá dhɨ nɨ rú sè. ");
INSERT INTO log_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Àmɨ, tátrɨ́trɨ́ kúlí tadhábhá ɨ Fàrìsáyò ɨ́be nɨ ɨ, kɨzà àmɨ kɨ ngá ꞌɨ. Àmɨ túrúpfúbhá ꞌɨ! Mɨ̀ adré ngá nzɨ̌ tsàtsà títí mɨ̀ dré adrélé lokólé àmɨ kɨ amvú na, lanzɨ́lé ꞌa be mudrí dhɨ kɨ àlo fe Gìká dré: ndɨ̀ndɨ̀ àmɨ kɨ ménetè, àmɨ kɨ fènúwì, tsàle àmɨ kɨ kúmè. Dɨ, mɨ̀ adré àmɨkya tà kàdrɨ̀ lavúlé tátrɨ́trɨ́ kúlí dré adrélé tadhálé dhɨ kɨ bhe gàrà dri: tà gyǎgya ꞌòma, móndɨ́ kɨ kɨzà bhàma, ɨ̀ndɨ̀ Gìká nɨ kaꞌìma. Adré tá lèá dhɨ, mɨ̀ kàdré tà nda kòdhɨ kɨ ꞌo, ngá fèma Gìká dré dhɨ nɨ tɨvɨ̀ àko ró. ");
INSERT INTO log_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Àmɨ móndɨ́ kɨ drì kobhá mì kùdúkùdu ró dhɨ ꞌɨ! Mɨ̀ adré àmɨkya ŋǒŋó kogá àmɨ kɨ yǐ lésè gò, adrézó kàmílò te kòdhya! ");
INSERT INTO log_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Àmɨ, tátrɨ́trɨ́ kúlí tadhábhá ɨ Fàrìsáyò ɨ́be nɨ ɨ, kɨzà àmɨ kɨ ngá ꞌɨ. Àmɨ túrúpfúbhá ꞌɨ! Mɨ̀ adré àmɨkya kópò kɨ rúbhá dzɨ sǎnɨ̀ kya ɨ́be gò, àyɨ kɨ ꞌa dré adrézó gàle ngá lovó sè bǐ, ɨ̀ndɨ̀ lovó kònzɨ sè bǐ. ");
INSERT INTO log_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Mɨ, Fàrìsáyò mì kùdúkùdu ró nɨ, mɨ́ kòdzɨ̀ rè zyà kópò nɨ ꞌálé ꞌíká, gò rúbhá nɨ kògòró kpà atsálé ndǐ àko ndò. ");
INSERT INTO log_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Àmɨ, tátrɨ́trɨ́ kúlí tadhábhá ɨ Fàrìsáyò ɨ́be nɨ ɨ, kɨzà àmɨ kɨ ngá ꞌɨ. Àmɨ túrúpfúbhá ꞌɨ! Àmɨ ngóró mógó rúbhá tswàle mvèle kemve dhɨ ɨ tɨ́nɨ. Kɨvɨ̀ lésè dhɨ, mógó nda kɨ rúbhá avé tò. Dɨ, àyɨ kɨ ꞌa ga ɨ́na àbvò kɨ fà sè bǐ, ɨ̀ndɨ̀ ngá títí ndǐ ró dhɨ ɨ sè bǐ. ");
INSERT INTO log_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Tà nda kòdhɨ kókpà kònɨ̀nɨ àmɨ kɨ tà sè. Kɨvɨ̀ lésè dhɨ, móndɨ́ ɨ̀ adré àmɨ kɨ no ngóró móndɨ́ gyǎgya dhɨ ɨ ró. Tákò, àmɨ kɨ togó na dhɨ, mɨ̀ ga túrúpfú tà sè bǐ, ɨ̀ndɨ̀ tà kònzɨ sè bǐ. ");
INSERT INTO log_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Àmɨ, tátrɨ́trɨ́ kúlí tadhábhá ɨ Fàrìsáyò ɨ́be nɨ ɨ, kɨzà àmɨ kɨ ngá ꞌɨ. Àmɨ túrúpfúbhá ꞌɨ! Mɨ̀ adré àmɨkya mógó kɨ tobhà pròfétà ɨ dré, adrézó kpà mógó móndyá gyǎgya dhɨ kya kɨ ledé avélé tò. ");
INSERT INTO log_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Mɨ̀ adré kpà tàá dhɨ: ‹Kònò mà kàdré tá àma kɨ tábhí kɨ lókyá ꞌá be dhɨ, mà kɨtswá tá ru amú àyɨ ɨ́be adrézó pròfétà kɨ kàrɨ́ kutú dhɨ ko.› ");
INSERT INTO log_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ásà dhɨ, mɨ̀ adré àmɨkya tadhá dhɨ, àmɨ dhya pròfétà kɨ tupfúbhá todràle dhɨ kɨ ànzɨ ꞌɨ. ");
INSERT INTO log_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Mɨ̀ kògò dɨ adrélé tà kònzɨ àmɨ kɨ tábhí ɨ̀ dré kɨdhólé ꞌòle dhɨ kɨ ꞌo kɨtswálé títí. ");
INSERT INTO log_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Àmɨ nì ꞌɨ, ɨ̀ndɨ̀ nì àtrá kɨ àrèbhá ꞌɨ! Mɨ̀ nɨ àmɨkya lapá Gìká nɨ tàbvó tàma sílésè ngɨ́nɨngɨ́nɨ ró, mɨ̀ dré kɨtswázó fɨ̀le líferò na ko dhɨ? ");
INSERT INTO log_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Dɨ mɨ̀ yi rè ká! Má nɨ pròfétà kɨ tibhù tògyabhá ɨ́be ɨ̀ndɨ̀ tà tadhábhá ɨ́be lɨ̀le àmɨ véna. Dɨ, mɨ̀ nɨ àyɨ kɨ àruka kɨ tupfú todràle, adrézó àruka nɨ kɨ tidí fa kɨpakɨpa ɨ drǐsè, adrézó àruka nɨ kɨ tswa àmɨ kɨ lɨ̀sámbò dzó ɨ ꞌásè, adrézó àruka nɨ kɨ ladró bhàandre àlo àlo dhɨ ɨ ꞌásè. ");
INSERT INTO log_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Dɨ ásà dhɨ, móndyá gyǎgya títí dhɨ kɨ kàrɨ́ kutúlé bvò dri dhɨ nɨ ngo àmɨ dri. Kɨdhólé Àbélè adrélépi tá gyǎgya dhɨ rú, tsàle Zàkàrɨ́yà, Bàràkɨ́yà nɨ mvá mɨ̀ dré pfùle dràle tépelò ɨ kòfalé àlètárɨ̀ be dhɨ rú dhɨ, àyɨ kɨ kàrɨ́ nɨ ngo àmɨ dri. ");
INSERT INTO log_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Má adré tà bàti ta àmɨ dré: Tà nda kòdhɨ kɨ atsá títí móndyá ándrò nɨ ɨ rú.» ");
INSERT INTO log_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","«Á! Yèrúsalémà, Yèrúsalémà, mɨ adrélépi pròfétà kɨ tupfú todràle, adrézó kpà dhya Gìká dré adrélé amùle mɨ́ vélé dhɨ kɨ lebhé todràle kɨ́rà sè nɨ! Tsàle vésè be ángopɨ́, má lè tá ámɨ ànzɨ kɨ kɨmólé má zàle, ngóró tàꞌú dré adrélé áyɨ ànzɨmvá kɨ kɨmó áyɨ kupfú zàle dhɨ tɨ́nɨ dhɨ? Dɨ, mɨ̀ lè tá àmɨkya ko. ");
INSERT INTO log_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Dɨ mɨ̀ yi rè ká! À tayɨ́ àmɨ kɨ dzó ngbo dre. ");
INSERT INTO log_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Tàko ko, má adré tàá àmɨ dré dhɨ: Kɨdhólé nyànomvá dhɨ, mɨ̀ gò vélé áma no ko, tsàle lókyá mɨ̀ dré dra tàzoá dhɨ ‹Tà tanɨ kàdré dhya adrélépi alɨ̀le Mírì nɨ rú sè dhɨ dri!› dhɨ ꞌá.» ");
INSERT INTO log_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yésu kàpfò tépelò lésè gò adrélé lɨ̀le dre dhɨ, akódhɨ nɨ lebèbhá ɨ̀ dré àyɨ kɨ kisízó ànyɨ làgá, akódhɨ nɨ ꞌo tépelò nda nɨ dzó kàdrɨ̀ dhɨ kɨ no. ");
INSERT INTO log_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Dɨ, Yésu dré tàzoá àyɨ dré dhɨ: «Mɨ́ nò tsì dzó kàdrɨ̀ kònɨ ɨ títí ꞌí? Má adré tà bàti ta àmɨ dré: Lókyá adrélépi alɨ̀le dhɨ sè dhɨ, à gò vélé àyɨ kɨ kɨ́rà kɨ àlo kisú àzya nɨ dri ko. À nɨ kɨ́rà nda kɨ lebhé títí kìní mi.» ");
INSERT INTO log_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Àmvolásà dhɨ, Yésu ɨ̀ dré lɨ̀zo mbàle kòngó Òlívè fa kya drìna gò, akódhɨ dré lɨrɨ́zó. Dɨ akódhɨ nɨ lebèbhá ɨ̀ dré àyɨ kɨ kisízó àyɨ pátí ànyɨ làgá, akódhɨ nɨ lizí tàzoá dhɨ: «Mɨ́ tà rè àma dré, tà nda kòdhɨ kɨ atsá ángutú ya dhɨ ká? Àdho tà nɨ ru ꞌo drìdrì tadházóá dhɨ, ámɨ agòma ànyɨ, ɨ̀ndɨ̀ lókyá kùdù ànyɨ káyà dhɨ nɨ̀?» ");
INSERT INTO log_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yésu logó àyɨ dré dhɨ: «Mɨ̀ kàdré àmɨ kɨ lɨkɨ́ dóro, dhya àlo kòlɨtɨ́ró àmɨ ko. ");
INSERT INTO log_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Tàko ko, móndɨ́ bǐ dhɨ kɨ alɨ̀ áma rú sè adrélé tàá dhɨ, ‹Ma Mèsɨ́yà ꞌɨ!› gò, ɨ̀ dré móndɨ́ zyandre dhɨ kɨ lɨtɨ́zó. ");
INSERT INTO log_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mɨ̀ nɨ àdzú kɨ kpòrò yi ànyɨ, adrézó kpà àdzú kɨ rúbí yi làwú làvo na. Dɨ, mɨ̀ kònò dóro, mɨ̀ kòtayɨ́ró àmɨ kɨ togó adrélé gàle ásà dhɨ ko. Tàko ko, adré lèá dhɨ, tà nda kòdhɨ ɨ̀ kòꞌo rè zyà ru ꞌíká. Dɨ, lókyá kùdù atsá rè ko. ");
INSERT INTO log_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Súrú kɨ àdzú bhu súrú àruka ɨ́be. Òpɨ̀ kɨ kpà àdzú bhu òpɨ̀ àruka ɨ́be. Kàrábhò nɨ dhe, ɨ̀ndɨ̀ kàdíkàdi nɨ bvò kosé àrà twátwa ɨ ꞌásè. ");
INSERT INTO log_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Dɨ, tà títí nda kòdhɨ kɨ ngbà ꞌí adré ngóró tòkó nɨ mváaswa nɨ kɨdhoma tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Lókyá nda sè dhɨ, à nɨ àmɨ kɨ lefè kàrɨbhá ɨ drɨ́gá gò, ɨ̀ dré adrézó àmɨ kɨ mì pfo, adrézó àmɨ kɨ tupfú todràle. Súrú títí bvò dri dhɨ kɨ togó kònzɨ bha àmɨ rú áma tà sè. ");
INSERT INTO log_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Móndɨ́ bǐ dhɨ kɨ kpà àyɨ kɨ tà kaꞌìkaꞌì tayɨ́, adrézó ru lefè, adrézó ru ga àyɨ kòfalésè. ");
INSERT INTO log_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Pròfétà kɨnzò ro dhɨ kɨ apfò bǐ adrélé móndɨ́ zyandre dhɨ kɨ lɨtɨ́. ");
INSERT INTO log_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Tà kònzɨ dré dra atsálé kàdrɨ̀ lavúlé dhɨ sè dhɨ, móndɨ́ bǐ dhɨ kɨ lèle nɨ kɨdrɨ́. ");
INSERT INTO log_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Dɨ, dhya ángùdhi adrélépi togó tsɨ, adrézó áyɨ totó tätä tsàle kùdù na dhɨ nɨ ɨ́na adrɨ́. ");
INSERT INTO log_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","À nɨ Rúbí Tanɨ Gìká nɨ Òpɨ̀ àdhya kòdhɨ nɨ longó bvò wä́yi ꞌásè, tà nɨ nɨ tadházó súrú títí ɨ dré ꞌíká, gò lókyá kùdù dré gòzo atsálé ndò.» ");
INSERT INTO log_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«Dɨ mɨ̀ nɨ ‹ngá adrélé gàle gàgà adrélépi ngá lólo dhɨ kɨ kɨzá dhɨ› nɨ no adréràꞌa áyɨ totó àrà lólo dhɨ na, ngóró longólé pròfétà Dànyélè tí dhɨ tɨ́nɨ. (Lè dhya adrélépi tà kòdhɨ nɨ na dhɨ kàdré àndu nɨ nɨ ni dóro.) ");
INSERT INTO log_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Lókyá nda sè dhɨ, lè móndyá dra adrébhá bvò Yùdáyà àdhya na dhɨ ɨ̀ kòlapá ràle kòngó ɨ drìna. ");
INSERT INTO log_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Lè kpà dhya dra adrélépi áyɨ dzó drìna dhɨ kàsí fɨ̀le dzó na, áyɨ ngá kɨ do lapázó ába dhɨ ko. ");
INSERT INTO log_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Dhya dra adrélépi amvú na dhɨ kògò nzɨ̀le ɨ́ bhàna áyɨ kɨ́tá kɨdhɨ̀ àdhya nɨ do lapázó ába dhɨ ko. ");
INSERT INTO log_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kìtú nda ɨ tú dhɨ, kɨzà nɨ adré kàdrɨ̀ tòkó ꞌa ɨ́be dhɨ ɨ dré, ɨ̀ndɨ̀ tòkó adrébhá bà fe ànzɨmvá ɨ dré dhɨ ɨ dré. ");
INSERT INTO log_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mɨ̀ kàdré tà zi Gìká tí, àmɨ kɨ lapama nda kàdréró kɨdhɨ̀ lókyá sè yà, kó ngalè sàbátù tú yà dhɨ ko. ");
INSERT INTO log_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Tàko ko, kɨzà kìtú nda kya nɨ adré kàdrɨ̀ lavúlé. À nò rè kɨzà kárá be kònɨ̀nɨ nda ko, kɨdhólé bvò bhǎrà lésè atsálé ándrò kònɨ̀dhɨ. À kɨtswá kpà gòle vélé nòá tàdzí ko. ");
INSERT INTO log_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kònò Gìká kòkɨ tá kìtú nda kɨ bvó ko dhɨ, dhya àlo bvò dri dhɨ kɨtswá tá adrɨ́lé bwà ko. Dɨ, Gìká nɨ ɨ́na kìtú nda kɨ bvó kɨ móndyá ɨ́ dré zɨ̀le dhɨ kɨ tà sè. ");
INSERT INTO log_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Lókyá nda sè dhɨ, à kàdré tàá àmɨ dré dhɨ ‹Mɨ̀ nò rè ká, Mèsɨ́yà kònwa!› dhɨ, mɨ̀ kòkaꞌì ko. À kàdré kó tàá dhɨ ‹Akódhɨ kònàle!› dhɨ, mɨ̀ kòkaꞌì ko. ");
INSERT INTO log_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Tàko ko, mèsɨ́yà kɨnzò ro dhɨ kɨ apfò pròfétà kɨnzò ro dhɨ ɨ́be adrélé tà kàdrɨ̀ lɨ́ndrɨ́ga ró adrébhá àyɨ kɨ rìnyí tadhá dhɨ kɨ ꞌo, kòkɨtswá dhɨ, ɨ̀ dré ndɨ̀ndɨ̀ móndyá Gìká dré zɨ̀le dhɨ kɨ lɨtɨ́zó. ");
INSERT INTO log_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Mɨ̀ yi rè ká! Má longó tà nda kòdhɨ ɨ drìdrì àmɨ dré. ");
INSERT INTO log_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Dɨ à kàdré tàá àmɨ dré dhɨ ‹Mɨ̀ nò rè ká, Mèsɨ́yà kònàle duku na!› dhɨ, mɨ̀ kòlɨ̀ kònàle ko. À kàdré kó tàá dhɨ ‹Akódhɨ kònwa dzó ꞌá!› dhɨ, mɨ̀ kòkaꞌì ko. ");
INSERT INTO log_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Tàko ko, ngóró bhù dré adrélé lagúlé ngá kazá kìtú dré apfǒrà lésè tsàle kìtú dré ndǐrà na dhɨ tɨ́nɨ dhɨ, Móndɨ́ nɨ Mvá nɨ agòma nɨ adré kókpà kònɨ̀nɨ. ");
INSERT INTO log_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Àrà ángùdhi àbvò dré adrézó lána dhɨ drìle dhɨ, àrɨ́ àgáàga dhɨ kɨ kókpà ru kɨmó kɨtswálé àbvò nda nɨ te.» ");
INSERT INTO log_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«Gbǎ kɨzà kàdrɨ̀ kìtú nda kya àmvolésè dhɨ, ‹kìtú nɨ mì nɨ atsá tínímvá ro, mbǎ gò vélé mvèle ko, bhìbhínyà kɨ ledhé bhù lésè, ɨ̀ndɨ̀ rìnyí bhù na dhɨ kɨ ru kɨzɨ́.› ");
INSERT INTO log_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Dɨ lókyá nda sè dhɨ, tà dra Móndɨ́ nɨ Mvá nɨ agòma tadhálépi dhɨ nɨ agá bhù mìbhalé ꞌá gò, súrú títí bvò dri dhɨ ɨ̀ dré tongózó. Dɨ ɨ̀ dré Móndɨ́ nɨ Mvá nɨ nòzo adréràꞌa alɨ̀le ndùrùku ɨ drǐsè, rìnyí kàdrɨ̀ be ɨ̀ndɨ̀ mìlanzìlanzì kàdrɨ̀ be. ");
INSERT INTO log_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Gò akódhɨ dré áyɨ ángéló kɨ mùzo gòká kúlí ꞌuꞌù be, lɨ̀le áyɨ móndyá ɨ́ dré zɨ̀le dhɨ kɨ kɨmó bvò nɨ pá su dhɨ ɨ lésè, kɨdhólé bhù nɨ kùdù àlo lésè, tsàle byá àzya nɨ na.» ");
INSERT INTO log_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«Lè mɨ̀ kàdré tà tadhálé fígì fa nɨ tà rú dhɨ nɨ àndu ni dóro. Fígì fa nɨ dríti kàdré atsálé màlɨmálɨ gò, bí nɨ dré adrézó ròle dhɨ, mɨ̀ nì tàle dhɨ, yǐgú ànyɨ dhɨ be. ");
INSERT INTO log_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Kókpà kòdhɨ tɨ́nɨ, lókyá mɨ̀ dré dra tà títí nda kòdhɨ kɨ nòzo adréràꞌa ru ꞌo dhɨ tú dhɨ, lè mɨ̀ kònì tàle dhɨ, Móndɨ́ nɨ Mvá láti ꞌá, ndɨ̀ndɨ̀ àmɨ kɨ dzó tí káyà dhɨ. ");
INSERT INTO log_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Má adré tà bàti ta àmɨ dré: Móndyá dra adrébhá lɨ́drɨ̀ ɨ́be lókyá nda sè dhɨ ɨ̀ kɨtswá dràle títí drìdrì tà títí nda ɨ̀ dré dra ru ꞌòzo dhɨ kandrá ko. ");
INSERT INTO log_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Bhù ɨ bvò be dhɨ kɨ akɨ́. Dɨ, áma kúlí ɨ̀ kɨtswá àyɨkya tàdzí akɨ́lé ko.» ");
INSERT INTO log_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","«Dɨ, dhya àlo nì ɨ́na kìtú ꞌɨ yà, kó ngalè sáà ꞌɨ yà tà nda ɨ̀ dré dra ru ꞌòzo dhɨ ko. Ndɨ̀ndɨ̀ ángéló bhù na dhɨ ꞌɨ yà, kó ngalè Gìká nɨ Mváagó ꞌɨ yà dhɨ, ɨ̀ nì ko. Gìká Atá nì ngbà ꞌí nɨ̀ kalóma. ");
INSERT INTO log_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Lókyá Móndɨ́ nɨ Mvá dré adréràꞌa ꞌòle agòle dhɨ ꞌá dhɨ, tà kɨ adré ngóró Nówè nɨ lókyá ꞌá dhɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Tàko ko, kìtú yǐ lìti andre kandrá dhɨ ɨ sè dhɨ, móndɨ́ ɨ̀ adré tá àyɨkya ngá nya, adrézó ngá mvu, adrézó ru mo, adrézó àyɨ kɨ ànzɨ kɨ fe mòle, tsàle kìtú Nówè dré fɨràꞌa bwátù kàdrɨ̀ na dhɨ ꞌá. ");
INSERT INTO log_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Àyɨ nda ɨ̀ nì tá tà adrélépi tá ꞌòle atsálé dhɨ àlomvá ko, tsàle yǐ dré tiràꞌa àyɨ kɨ wu títí dhɨ ꞌá. Tà nda kòdhɨ kɨ adré kókpà kònɨ̀nɨ kìtú Móndɨ́ nɨ Mvá dré dra agòzo dhɨ tú. ");
INSERT INTO log_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Àgo rì dhɨ kɨ adré àzí ꞌo amvú na. À nɨ àlo nɨ nɨ do, àzya nɨ nɨ tayɨ́. ");
INSERT INTO log_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Tòkó rì dhɨ kɨ adré ngá ꞌi. À nɨ àlo nɨ nɨ do, àzya nɨ nɨ tayɨ́. ");
INSERT INTO log_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Mɨ̀ kàdré dɨ tàmìga dri. Àngyá ko, mɨ̀ nì kìtú ángùdhi àmɨ kɨ Mírì dré dra agòzo dhɨ ko. ");
INSERT INTO log_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Dɨ, adré lèá dhɨ, mɨ̀ kònì tà kònɨ̀dhɨ dóro: Dzó líyí kònì tá lókyá ángùdhi ngátsi sè kùgú dré kɨtswázó atsálé ásà dhɨ be dhɨ, kònò a nɨ tá adré tàmìga dri, kòtayɨ́ró kùgú nda áyɨ dzóti ŋo ko. ");
INSERT INTO log_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Dɨ àmɨ ró dhɨ, mɨ̀ kàdré kókpà gànzi ró. Tàko ko, Móndɨ́ nɨ Mvá nɨ atsá sáà mɨ̀ dré adrélé kisùle ko dhɨ sè.» ");
INSERT INTO log_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","«Màrábà tògya ró mírì nɨ dré kɨtswálé kaꞌìle dhɨ, àdhi ꞌɨ? Akódhɨ nda, dhya mírì nɨ dré bhàle áyɨ màrábà àruka áyɨ dzó lé dhɨ ɨ drìle, kɨtswálé mányàngá fe àyɨ dré nyàle lókyá kɨtswálépi dhɨ sè dhɨ ꞌɨ. ");
INSERT INTO log_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Màrábà nda nɨ mírì kàtsá akódhɨ nɨ kisú adréràꞌa ꞌòá kònɨ̀nɨ dhɨ, kólénzé nɨ adré akódhɨ dré! ");
INSERT INTO log_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Má adré tà bàti ta àmɨ dré: Akódhɨ nɨ mírì nɨ akódhɨ nɨ bha adrélé áyɨ ngá títí dhɨ ɨ drìle. ");
INSERT INTO log_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Dɨ, màrábà nda kàdré ɨ́na kònzɨ gò adrélé kisùá ɨ́ léna dhɨ ‹Áma mírì adré gìle agòma sè› gò, ");
INSERT INTO log_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","dré kɨdhózó adrélé áyɨ àzízɨ̌ kɨ tswa, adrézó ngá nya, adrézó ngá mvu, adrézó kpà wá tsi dhɨ, ");
INSERT INTO log_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","akódhɨ nɨ mírì nɨ atsá kìtú dré adrélé letèle ko dhɨ tú, ɨ̀ndɨ̀ sáà dré adrélé nìle ko dhɨ sè. ");
INSERT INTO log_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Dɨ a nɨ akódhɨ nɨ togá, akódhɨ nɨ tà bhàzo adrélé túmä́ní túrúpfúbhá kya be. Kònàle dhɨ, à nɨ adré tongólé, adrézó kpà síkálándrá tsɨ.» ");
INSERT INTO log_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yésu gò tàá dhɨ: «Dɨ Òpɨ̀ bhù àdhya nɨ adré ngóró tà kònɨ̀dhɨ tɨ́nɨ: Kyánzɨ mudrí dhɨ ɨ̀ do tá àyɨ kɨ tálà, topfòzo ába kɨtswálé tòkó líyí nɨ drì letè. ");
INSERT INTO log_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Àyɨ nda ɨ kòfalé dhɨ, nzi dhɨ ɨ tá azaaza ró, ɨ̀ndɨ̀ nzi dhɨ ɨ tá tògya ró. ");
INSERT INTO log_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Àyɨ azaaza ró nda ɨ̀ do tá àyɨ kɨ tálà ꞌí, dɨ, ɨ̀ do tá dò ko. ");
INSERT INTO log_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Dɨ, àyɨ tògya ró nda ɨ̀ do tá àyɨkya dò mòlàngɨ̀ na túmä́ní àyɨ kɨ tálà ɨ́be. ");
INSERT INTO log_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Tòkó líyí nda dré tá adrélé gìle dhɨ sè dhɨ, kyánzɨ nda ɨ̀ dré landèzo títí gò, ɨ̀ dré ledhézó ayí be adrélé ayí ko. ");
INSERT INTO log_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ngátsi kɨ́tógá sè dhɨ, à dré ngàzo kúlí yo tàzoá dhɨ: ‹Mɨ̀ nò rè ká! Tòkó líyí adré alɨ̀le! Mɨ̀ pfò lɨ̀le ru kisú akódhɨ be!› ");
INSERT INTO log_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Gò kyánzɨ títí nda ɨ̀ dré larózó, àyɨ kɨ tálà kɨ ledé. ");
INSERT INTO log_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Dɨ kyánzɨ azaaza ró nda ɨ̀ dré tàzoá àyɨ tògya ró nda ɨ dré dhɨ: ‹Mɨ̀ afè àma dré àmɨ kɨ dò nɨ àruka wà. Àngyá ko, àma kɨ tálà adré adrálé.› ");
INSERT INTO log_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Dɨ, àyɨ tògya ró nda ɨ̀ logó dhɨ: ‹Kóko! Dò nda kɨtswá àma dré àmɨ ɨ́be ko. Mɨ̀ kòlɨ̀ be gɨ̀á àmɨ dré móndɨ́ adrébhá dò lagɨ́ dhɨ ɨ véna.› ");
INSERT INTO log_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Dɨ, ɨ̀ dré tá adréràꞌa lɨ̀le gɨ̀á dhɨ ꞌá dhɨ, tòkó líyí dré atsázó. Dɨ kyánzɨ adrébhá gànzi ró nda ɨ̀ dré fɨ̀zo akódhɨ be dzó làmó gwányá àdhya na gò, dzóti asézó. ");
INSERT INTO log_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Àmvolásà dhɨ, kyánzɨ àruka nda ɨ̀ dré agòzo atsálé gò, tàá dhɨ: ‹Mírì, mírì, mɨ́ nzì àma dré dzóti wà!› ");
INSERT INTO log_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Dɨ, tòkó líyí nda logó dhɨ: ‹Má adré tà bàti ta àmɨ dré: Má nì mána àmɨ ko.›» ");
INSERT INTO log_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yésu gò tàá dhɨ: «Dɨ mɨ̀ kàdré tàmìga dri! Tàko ko, mɨ̀ nì kìtú ꞌɨ yà, kó ngalè sáà ꞌɨ yà má dré dra agòzo dhɨ ko.» ");
INSERT INTO log_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","«Òpɨ̀ bhù àdhya nɨ kókpà adré ngóró tà kònɨ̀dhɨ tɨ́nɨ: Agó àlo dhɨ adré tá ꞌòle lɨ̀le atsí na. Dɨ dré áyɨ màrábà kɨ azízó, áyɨ ngá kɨ tayɨ́zó àyɨ drɨ́gá, ɨ̀ kàdréró àzí ꞌo ásà be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Àlo nɨ dré dhɨ, fè tá làfa lòꞌwa rú zìle tàlétà dhɨ ɨ nzi. Àzya nɨ dré dhɨ, fè tá tàlétà rì. Àzya nɨ dré dhɨ, fè tá tàlétà àlo. Lanzɨ́ tá tàlétà nda ɨ àyɨ àlo àlo dhɨ ɨ dré, ngóró ɨ̀ dré kɨtswálé àzí ꞌo ásà bwà dhɨ tɨ́nɨ. Gò dré lɨ̀zo atsí na. ");
INSERT INTO log_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Gbǎ lókyá nda sè dhɨ, dhya tàlétà nzi dhɨ kɨ kisúlépi nda dré lɨ̀zo àzí ꞌo ásà gò, tàlétà nzi àruka kɨ kisúzó bhàle drìá. ");
INSERT INTO log_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Dhya tàlétà rì dhɨ kɨ kisúlépi nda dré kpà ꞌòzoá kònɨ̀nɨ gò, tàlétà rì àruka kɨ kisúzó bhàle drìá. ");
INSERT INTO log_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Dɨ, dhya tàlétà àlo dhɨ nɨ kisúlépi nda dré ɨ́na lɨ̀zo bhú dhi kìní na, áyɨ mírì nɨ làfa nda nɨ zùzo. ");
INSERT INTO log_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Lókyá kòlavú vwàvwà ro dre dhɨ, màrábà nda kɨ mírì dré agòzo àyɨ kɨ azí, ɨ̀ kòtàró ɨ́ dré dhɨ ɨ̀ ꞌo tá àzí áyɨ làfa sè ngɨ́nɨ ya dhɨ. ");
INSERT INTO log_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Dɨ dhya tàlétà nzi dhɨ kɨ kisúlépi nda dré atsázó ába túmä́ní tàlétà nzi àruka ɨ́be, tàá dhɨ: ‹Mírì, mɨ́ tayɨ́ tá má drɨ́gá tàlétà nzi kònɨ ɨ. Mɨ́ nò ká, má kisú tàlétà nzi àruka ɨ bhàle drìá dre.› ");
INSERT INTO log_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Dɨ Mírì nɨ tà drá dhɨ: ‹Áma màrábà dóro má dré kɨtswálé kaꞌìle nɨ, mɨ́ ꞌo dóro! Mɨ́ tadhá dhɨ, mɨ́ kɨtswá má dré kaꞌìle tà mvá tsà tayɨ́lé mɨ́ drɨ́gá dhɨ sè. Dɨ ásà dhɨ, má nɨ ámɨ bha adrélé tà kàdrɨ̀kàdrɨ̀ ɨ drìle. Mɨ́ alɨ̀ lenzélé ámɨ mírì vélé!› ");
INSERT INTO log_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Gò dhya tàlétà rì dhɨ kɨ kisúlépi nda dré kpà atsázó tàá dhɨ: ‹Mírì, mɨ́ tayɨ́ tá má drɨ́gá tàlétà rì kònɨ ɨ. Mɨ́ nò ká, má kisú tàlétà rì àruka ɨ bhàle drìá dre.› ");
INSERT INTO log_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Dɨ Mírì nɨ tà drá dhɨ: ‹Áma màrábà dóro má dré kɨtswálé kaꞌìle nɨ, mɨ́ ꞌo dóro! Mɨ́ tadhá dhɨ, mɨ́ kɨtswá má dré kaꞌìle tà mvá tsà tayɨ́lé mɨ́ drɨ́gá dhɨ sè. Dɨ má nɨ ámɨ bha adrélé tà kàdrɨ̀kàdrɨ̀ ɨ drìle. Mɨ́ alɨ̀ lenzélé ámɨ mírì vélé!› ");
INSERT INTO log_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Gò dhya tàlétà àlo dhɨ nɨ kisúlépi nda dré kpà atsázó tàá dhɨ: ‹Mírì, má nì tá tàle dhɨ, mɨ agó tòmbá ꞌɨ dhɨ be. Mɨ́ adré mɨ́na ngá akónà àrà mɨ́ dré ngá kidhízó ko dhɨ na, adrézó kpà ngá lokó àrà mɨ́ dré kórɨ̀ rɨ̀zo ko dhɨ na. ");
INSERT INTO log_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Dɨ má adré tá ngá ro gò, má dré lɨ̀zo làfa mɨ́na nɨ zu kìní na. Mɨ́ nò ká, ngá mɨ́na kònɨ̀dhɨ.› ");
INSERT INTO log_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Dɨ, mírì nɨ tà drá dhɨ: ‹Mɨ, màrábà kònzɨ ɨ̀ndɨ̀ tòbvo ró dhɨ ꞌɨ! Mɨ́ nì tá tàle dhɨ, má adré ngá akónà àrà má dré ngá kidhízó ko dhɨ na, adrézó kpà ngá lokó àrà má dré kórɨ̀ rɨ̀zo ko dhɨ na dhɨ be. ");
INSERT INTO log_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Adré dɨ tá lèá dhɨ, mɨ́ kòbhà tá làfa mána dzó adrézó làfa ꞌo lendrélé dhɨ na, kònò má kònɨ̀ agò dhɨ, má nɨ tá làfa mána nɨ adó àmupi nɨ be.› ");
INSERT INTO log_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Dɨ mírì nda gò tàá dhɨ: ‹Mɨ̀ do tàlétà kòdhɨ akódhɨ drɨ́gásè, fèle dhya adrélépi ába mudrí dhɨ dré. ");
INSERT INTO log_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Tàko ko, dhya ángùdhi adrélépi ngá ɨ́be dhɨ dré dhɨ, à nɨ akódhɨ nɨ ngá nda kɨ drì tɨmbà gò, akódhɨ dré adrézó vélé ngá ɨ́be bǐ lavúlé. Dɨ, kàdré ɨ́na dhya adrélépi ngá àko dhɨ nɨ tà sè dhɨ, à nɨ ndɨ̀ndɨ̀ ngá mvá tsà dré adrézó ába dhɨ nɨ do drɨ́gásà. ");
INSERT INTO log_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Kàdré màrábà tàko ró kòdhɨ nɨ tà sè dhɨ, mɨ̀ bhe akódhɨ kɨvɨ̀ na, àrà tínímvá ro dhɨ na. Kònàle dhɨ, à nɨ adré tongólé, adrézó kpà síkálándrá tsɨ.›» ");
INSERT INTO log_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Yésu gò tàá dhɨ: «Lókyá Móndɨ́ nɨ Mvá dré dra agòzo áyɨ mìlanzìlanzì na ángéló ɨ́be títí dhɨ sè dhɨ, a nɨ lɨrɨ́ áyɨ lɨrɨ́rà mìlanzìlanzì ro òpɨ̀ àdhya dri. ");
INSERT INTO log_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Dɨ à nɨ móndyá títí súrú títí ɨ lésè dhɨ kɨ kɨmó akódhɨ kandrá gò, dré àyɨ kɨ kòfalé lanzɨ́zó ngóró kábilígyà lɨkɨ́lépi dré adrélé kábilígyà kɨ kòfalé lanzɨ́ ndrǐ ɨ́be dhɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","A nɨ kábilígyà nda kɨ bha áyɨ drɨ́ágó lésè gò, ndrǐ nda kɨ bhàzo áyɨ lìdzí lésè. ");
INSERT INTO log_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Dɨ ópɨ́ kàdrɨ̀ nda nɨ tàá àyɨ adrébhá áyɨ drɨ́ágó lésè nda ɨ dré dhɨ: ‹Àmɨ áma Atá dré tà tanɨ bhàzo àmɨ dri nɨ ɨ, mɨ̀ alɨ̀ wà! Mɨ̀ kòkisú òpɨ̀ áma Atá dré ledélé àmɨ dré kɨ́nó bvò nɨ bhàma lésè dhɨ tàyɨlé ro. ");
INSERT INTO log_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Tàko ko, ma tá tàbirí ɨ́be gò, mɨ̀ dré ngá afèzo má dré nyàle. Ma tá yǐ lovó ɨ́be gò, mɨ̀ dré yǐ afèzo má dré mvùle. Ma tá móndɨ́ twá ꞌɨ gò, mɨ̀ dré áma kaꞌìzo dòle àmɨ véna. ");
INSERT INTO log_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ma tá kɨ́tá asólé dhɨ àko gò, mɨ̀ dré kɨ́tá tosózó má rú. Ma tá drà ro gò, mɨ̀ dré alɨ̀zo áma lomɨ́. Ma tá bǎdzó na gò, mɨ̀ dré alɨ̀zo áma no.› ");
INSERT INTO log_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Dɨ móndyá gyǎgya nda kɨ go logóá drá dhɨ: ‹Mírì, mà nò tá mɨ adréràꞌa tàbirí ɨ́be gò, mà dré ngá fèzo mɨ́ dré nyàle yà, kó ngalè mà nò tá mɨ adréràꞌa yǐ lovó ɨ́be gò, mà dré yǐ fèzo mɨ́ dré mvùle yà dhɨ ángutú? ");
INSERT INTO log_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Mà nò tá mɨ adréràꞌa móndɨ́ twá ro gò, mà dré ámɨ kaꞌìzo dòle àma vélé yà, kó ngalè mà nò tá mɨ adréràꞌa kɨ́tá àko gò, mà dré kɨ́tá tosózó mɨ́ rú yà dhɨ ángutú? ");
INSERT INTO log_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Mà nò tá mɨ adréràꞌa drà ro yà, kó ngalè bǎdzó na yà gò, mà dré lɨ̀zo ámɨ no dhɨ ángutú?› ");
INSERT INTO log_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Dɨ ópɨ́ kàdrɨ̀ nda nɨ logóá àyɨ dré dhɨ: ‹Má adré tà bàti ta àmɨ dré: Tà ángùdhi mɨ̀ dré tá ꞌòle áma adrúpi tàko lavúlé kònɨ kɨ àlo dré dhɨ, mɨ̀ ꞌo tà nda áma tàndɨ dré.› ");
INSERT INTO log_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Dɨ ópɨ́ kàdrɨ̀ nda nɨ tàá àyɨ adrébhá áyɨ lìdzí lésè nda ɨ dré dhɨ: ‹Àmɨ tátrɨ́trɨ́ ɨ́be àmɨ dri nɨ ɨ, mɨ̀ nga àmɨkya má mìlésè, lɨ̀le àtsɨ́ adrélépi adrálé ko, Gìká dré ledélé Dzáborò dré ángéló nɨ ɨ́be dhɨ na. ");
INSERT INTO log_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Tàko ko, ma tá tàbirí ɨ́be gò, mɨ̀ dré ngá afèzo má dré nyàle dhɨ ko. Ma tá yǐ lovó ɨ́be gò, mɨ̀ dré yǐ afèzo má dré mvùle dhɨ ko. ");
INSERT INTO log_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ma tá móndɨ́ twá ꞌɨ gò, mɨ̀ dré áma kaꞌìzo dòle àmɨ véna ko. Ma tá kɨ́tá asólé dhɨ àko gò, mɨ̀ dré kɨ́tá tosózó má rú ko. Ma tá drà ro ɨ̀ndɨ̀ bǎdzó na gò, mɨ̀ dré alɨ̀zo áma no ko.› ");
INSERT INTO log_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Dɨ àyɨ nda kɨ kókpà go logóá drá dhɨ: ‹Mírì, mà nò tá mɨ adréràꞌa tàbirí ɨ́be yà, yǐ lovó ɨ́be yà, móndɨ́ twá ro yà, kɨ́tá àko yà, drà ro yà, kó ngalè bǎdzó na yà dhɨ gò, mà dré tà ꞌòzo mɨ́ dré ko dhɨ ángutú?› ");
INSERT INTO log_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Dɨ ópɨ́ kàdrɨ̀ nda nɨ logóá àyɨ dré dhɨ: ‹Má adré tà bàti ta àmɨ dré: Tà ángùdhi mɨ̀ dré tá ꞌòle dhya tàko lavúlé kònɨ kɨ àlo dré ko dhɨ, mɨ̀ ꞌo kókpà tà nda má dré ko.› ");
INSERT INTO log_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Dɨ àyɨ nda kɨ lɨ tà ŋòle àyɨ dri kóná vésè kólyá dhɨ nɨ kisú. Dɨ, móndyá gyǎgya nda kɨ àyɨkya lɨ lɨ́drɨ̀ kóná vésè kólyá dhɨ nɨ kisú.» ");
INSERT INTO log_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yésu kòtà tà nda ɨ akɨ́lé títí dre dhɨ, dré tàzoá áyɨ lebèbhá ɨ dré dhɨ: ");
INSERT INTO log_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Ngóró mɨ̀ dré nìle be dhɨ tɨ́nɨ dhɨ, tayɨ́ kìtú rì gwányá Pásɨkà àdhya dré atsázó. Dɨ à adré ꞌòle Móndɨ́ nɨ Mvá nɨ lefè kàrɨbhá ɨ drɨ́gá, ɨ̀ kòtidíró akódhɨ dràle fa kɨpakɨpa dri be dhɨ bvó.» ");
INSERT INTO log_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Lókyá nda sè dhɨ, Yúdà ànzɨ kɨ kòwánà kàdrɨ̀ ɨ àyɨ kɨ bhàgo ɨ́be dhɨ ɨ̀ dré ru kɨmózó kòwánà kɨ kàdrɨ̀ rú be Kàyáfà dhɨ nɨ dzó kàdrɨ̀ na. ");
INSERT INTO log_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Gò ɨ̀ dré ru yìzo kɨtswázó Yésu nɨ ru túrúpfú sè, pfùle dràle. ");
INSERT INTO log_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Dɨ, ɨ̀ adré tá tàá dhɨ, ɨ̀ kòꞌo tà nda gwányá Pásɨkà àdhya tú ko, móndyá zyandre dhɨ ɨ̀ kòlɨgɨ́ró àyɨ ɨ́be ko sè. ");
INSERT INTO log_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Àmvolásà dhɨ, Yésu lɨ̀ tá Bètànɨ́yà na, fɨ̀le Sìmónà atú kàrɨ́ dré tá rùle dhɨ nɨ dzó na gò, dré lɨrɨ́zó mɨ́sá làga kɨtswálé ngá nya. ");
INSERT INTO log_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Gò tòkó àlo dhɨ dré afɨ́zó mòlàngɨ̀ mvá ledélé àlàbásterè sè, gàlepi màlásɨ̀ làgɨ́ kyàkyà dhɨ sè bǐ dhɨ be. Dré áyɨ kisízó mòlàngɨ̀ nda be ànyɨ Yésu làga gò, màlásɨ̀ nda nɨ da akódhɨ dri. ");
INSERT INTO log_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Akódhɨ nɨ lebèbhá ɨ̀ kònò tà nda dre dhɨ, àyɨ kɨ togó dré aswázó gò, ɨ̀ dré adrézó tàá àyɨ kòfalésè dhɨ: «À kɨzá tsì màlásɨ̀ kòdhɨ àdho tà sè? ");
INSERT INTO log_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Kònò à nɨ tá kɨtswá lagɨ́á làgɨ́ be kàdrɨ̀ gò, làfa nɨ nɨ fèzo lemerèbhá ɨ dré!» ");
INSERT INTO log_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yésu dré tà ɨ̀ dré adrélé tàle nda nɨ nìzo kyá gò, tàzoá àyɨ dré dhɨ: «Mɨ̀ adré tòkó kònɨ̀dhɨ nɨ drì kɨzá àdho tà sè? Tà dré ꞌòle má dré kòdhɨ, tà avélépi tò dhɨ ꞌɨ. ");
INSERT INTO log_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Àngyá ko, mɨ̀ adré ngbú adrélé lemerèbhá ɨ́be àmɨ kòfalé. Dɨ, mɨ̀ kɨtswá ngbú adrélé túmä́ní má be ko. ");
INSERT INTO log_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Akódhɨ dà màlásɨ̀ kònɨ̀dhɨ má rú drìdrì, kɨtswázó áma rúbhá ledé bhàle mógó na dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Má adré tà bàti ta àmɨ dré: Àrà títí bvò wä́yi ꞌásè à dré dra Rúbí Tanɨ kòdhɨ nɨ longózó dhɨ ɨ ꞌásè dhɨ, à nɨ kókpà tà tòkó kònɨ̀dhɨ dré ꞌòle kòdhɨ nɨ tɨtɨ́, akódhɨ nɨ tà kisùzo.» ");
INSERT INTO log_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Àmvolásà dhɨ, Yésu nɨ lebèbhá mudrí-drì-rì dhɨ kɨ àlo, rú be Yùdásɨ̀ Ɨ̀sɨ̀kàrɨ̀yótà dhɨ dré ngàzo lɨ̀le kòwánà kàdrɨ̀ ɨ véna, ");
INSERT INTO log_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","àyɨ kɨ lizí tàzoá dhɨ: «Mɨ̀ nɨ àdho ngá afè má dré, má kòlefèró Yésu àmɨ drɨ́gá be dhɨ bvó dhɨ?» Dɨ ɨ̀ dré làfa lòꞌwa ledélé àrezá sè dhɨ kɨ nàzo nyadhɨ-àlo-drì-mudrí, fèle drá. ");
INSERT INTO log_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Dɨ kɨdhólé lókyá nda sè dhɨ, Yùdásɨ̀ dré kɨdhózó adrélé lókyá dóro Yésu nɨ lefèzo àyɨ drɨ́gá dhɨ nɨ nda. ");
INSERT INTO log_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Gwányá Mápà tàkú àko dhɨ àdhya nɨ kìtú nɨ àlo sè dhɨ, Yésu nɨ lebèbhá ɨ̀ dré àyɨ kɨ kisízó ànyɨ akódhɨ làga, akódhɨ nɨ lizí tàzoá dhɨ: «Mɨ́ adré lèá dhɨ, mà kòladhɨ́ ngá mɨ́ dré gwányá Pásɨkà àdhya nɨ nyàzo dhɨ ángwà?» ");
INSERT INTO log_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Dɨ Yésu logó àyɨ dré dhɨ: «Mɨ̀ lɨ̀ bhàandre na agó dra tadhálé àmɨ dré dhɨ véna. Mɨ̀ kòtà drá dhɨ: ‹Dhya tà tadhálépi dhɨ adré tàá dhɨ: Lókyá mána atsá ànyɨ. Mà nɨ Pásɨkà nya áma lebèbhá ɨ́be ámɨ dzó na.›» ");
INSERT INTO log_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Dɨ akódhɨ nɨ lebèbhá nda ɨ̀ dré ꞌòzoá ngóró dré tá lazílé àyɨ dri dhɨ tɨ́nɨ. Gò ɨ̀ dré ngá ladhɨ́zó kɨtswázó gwányá Pásɨkà àdhya nɨ nya. ");
INSERT INTO log_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ɨ̀ndró kàndrɨ̀ dre dhɨ, Yésu ɨ̀ dré tsàzo lɨrɨ́lé mɨ́sá làgásè túmä́ní akódhɨ nɨ lebèbhá mudrí-drì-rì dhɨ ɨ́be. ");
INSERT INTO log_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ɨ̀ dré tá adréràꞌa ngá nya dhɨ ꞌá dhɨ, Yésu dré tàzoá dhɨ: «Má adré tà bàti ta àmɨ dré: Àmɨ kɨ àlo nɨ áma lefè kàrɨbhá ɨ drɨ́gá.» ");
INSERT INTO log_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Dɨ kɨzà dré àyɨ kɨ ꞌòzo lavúlé gò, àyɨ àlo àlo títí dhɨ ɨ̀ dré kɨdhózó adrélé tàá drá dhɨ: «Mírì, zakó ɨ́na ma ꞌɨ ko?» ");
INSERT INTO log_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Akódhɨ logó dhɨ: «Dhya drɨ́gá sòlepi má be sǎnɨ̀ àlo na dhɨ nɨ áma lefè nɨ̀. ");
INSERT INTO log_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Tà bàti ró dhɨ, Móndɨ́ nɨ Mvá nɨ lɨ dràle ngóró tɨsɨ̀le akódhɨ nɨ tà dri Gìká nɨ Kúlí na dhɨ tɨ́nɨ. Dɨ, kɨzà nɨ ɨ́na adré kàdrɨ̀ dhya dra Móndɨ́ nɨ Mvá nda nɨ lefèlepi dhɨ dré! Dóro nɨ tá dhya nda nɨ tìle ko dhɨ.» ");
INSERT INTO log_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Gò Yùdásɨ̀ adrélépi tá ꞌòle akódhɨ nɨ lefè nda dré tàzoá dhɨ: «Rábbì, zakó tsì ma ꞌɨ ko?» Yésu logó drá dhɨ: «Ámɨ tàndɨ mɨ́ tà dre.» ");
INSERT INTO log_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ɨ̀ dré tá adréràꞌa ngá nya dhɨ ꞌá dhɨ, Yésu dré mápà adózó, tà tanɨ zìzo drìá Gìká tí gò, ŋòzoá fèle áyɨ lebèbhá ɨ dré gò, tàzoá dhɨ: «Mɨ̀ do nyàle. Kònɨ̀dhɨ áma rúbhá ꞌɨ.» ");
INSERT INTO log_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Dré kpà kópò adózó, àwoyà tàzo Gìká dré gò, fèzoá àyɨ dré gò, tàzoá dhɨ: «Àmɨ títí, mɨ̀ mvu. ");
INSERT INTO log_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Kònɨ̀dhɨ áma kàrɨ́ adrélépi tà Gìká dré bhàle ru yìzo móndɨ́ ɨ́be dhɨ nɨ ꞌo kɨtswálé títí dhɨ ꞌɨ. Kàrɨ́ nda nɨ kutú móndɨ́ zyandre ɨ dré, Gìká kòtrìró àyɨ kɨ tàkonzɨ̀ ásà be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Má adré tàá àmɨ dré dhɨ: Má gò vélé vínò kòdhɨ tɨ́nɨ dhɨ nɨ mvu ko, tsàle kìtú mà dré dra vínò tɨ́dhɨ́ ro dhɨ nɨ mvùzo àmɨ ɨ́be áma Atá nɨ Òpɨ̀ na dhɨ tú.» ");
INSERT INTO log_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Dɨ ɨ̀ dré longó ngòzo lenzézó Gìká nɨ rú sè gò, ɨ̀ dré pfòzo lɨ̀le mbàle kòngó Òlívè fa kya drìna. ");
INSERT INTO log_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Gò Yésu dré tàzoá àyɨ dré dhɨ: «Ngátsi kònɨ̀dhɨ sè dhɨ, àmɨ títí mɨ̀ nɨ áma tayɨ́ adrélé kalóma. Tàko ko, Gìká nɨ Kúlí adré tàá dhɨ: ‹Má nɨ kábilígyà lɨkɨ́lépi nɨ tswa dràle gò, à dré kábilígyà nda kɨ pä̀rí ꞌòzo ayɨ́lé.› ");
INSERT INTO log_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Dɨ, má kònga mána dràdrà ꞌásè dre dhɨ, má nɨ lɨ drìdrì àmɨ kandrána Gàlìláyà na.» ");
INSERT INTO log_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Dɨ Pétèró tà drá dhɨ: «Tágba móndyá títí dhɨ ɨ̀ kòtayɨ́ mɨ yà dhɨ, má kɨtswá mána ámɨ tayɨ́ tàdzí ko!» ");
INSERT INTO log_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yésu logó drá dhɨ: «Má adré tà bàti ta mɨ́ dré: Ndɨ̀ndɨ̀ ngátsi ándrò kònɨ̀dhɨ sè, drìdrì àgólòwa dré dra tsírà bhèzo dhɨ kandrá dhɨ, mɨ́ nɨ áma ga vésè be na.» ");
INSERT INTO log_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Dɨ, Pétèró logó drá dhɨ: «Tágba kòkɨtswá mà dré dràzo túmä́ní mɨ́ be yà dhɨ, má kɨtswá tàdzí ámɨ ga ko.» Gò Yésu nɨ lebèbhá àruka títí dhɨ ɨ̀ dré kókpà tàzoá kònɨ̀nɨ. ");
INSERT INTO log_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Àmvolásà dhɨ, Yésu ɨ̀ dré lɨ̀zo lebèbhá nɨ ɨ́be tsàle àrà rú zìle Gètèsèmánì dhɨ na. Gò dré tàzoá àyɨ dré dhɨ: «Mɨ̀ lɨrɨ́ kònwa, má kòlɨ̀ró adrélé tà zi Gìká tí kònàle.» ");
INSERT INTO log_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Dré Pétèró kɨ drìzo Zèbèdáyò nɨ ànzɨ rì dhɨ ɨ́be ɨ́ vésè. Gò akódhɨ nɨ togó dré kɨdhózó adrélé kɨzà nya, adrézó lanzìle lavúlé. ");
INSERT INTO log_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Dɨ dré tàzoá àyɨ dré dhɨ: «Áma togó adré ŋòle kɨzà dré, tsàle ndɨ̀ndɨ̀ dràdrà mìle. Mɨ̀ kàdré kònwa, adrélé tàmìga dri má be.» ");
INSERT INTO log_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Kòlɨ̀ vwàle àyɨ rúsè tsà dre dhɨ, dré dhèzo áyɨ mìbhalé bha kìní mi gò, tà zìzo Gìká tí kònɨ̀nɨ: «Áma Atá, kòkɨtswá mɨ́ mìlésè dhɨ, mɨ́ kòdo kópò kɨzà àdhya kòdhɨ má vélésè wà. Dɨ, mɨ́ kòꞌo ngóró má dré adrélé lèle dhɨ tɨ́nɨ ko. Be ró dhɨ, mɨ́ kòꞌo ngóró mɨ́ dré adrélé lèle dhɨ tɨ́nɨ.» ");
INSERT INTO log_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Gò dré gòzo áyɨ lebèbhá nda ɨ véna, àyɨ kɨ kisú ayí na. Dré tàzoá Pétèró dré dhɨ: «Mɨ̀ kɨtswá tá tsì adrélé tàmìga dri má be ngbà ꞌí sáà àlo bwà ko? ");
INSERT INTO log_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Lè mɨ̀ kàdré tàmìga dri, adrélé kpà tà zi Gìká tí, kòtayɨ́ró àmɨ tà dré tabhìle, àmɨ kɨ ꞌòzo dhèle tàkonzɨ̀ na dhɨ ko. Bàti, dhyá kɨ togó àtsɨ ró adrézó tà dóro ꞌo. Dɨ, dhyá kɨ rúbhá ɨ́na yàyà.» ");
INSERT INTO log_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Gò dré gòzo lɨ̀le vésè nɨ rì sè, tà zi Gìká tí kònɨ̀nɨ: «Áma Atá, kòkɨtswá mɨ́ dré kópò kòdhɨ nɨ dòzo má vélésè má dré mvùá àko ró dhɨ ko dhɨ, mɨ́ kòꞌo tà mɨ́ dré adrélé lèle ꞌòle dhɨ kòdhya.» ");
INSERT INTO log_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Gò dré gòzo tódhyá gòle àyɨ kɨ kisú ayí na, àyɨ kɨ mì dré tá adrélé ayí ro dhɨ sè. ");
INSERT INTO log_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Dɨ dré àyɨ kɨ tayɨ́zó gò, gòzo lɨ̀le vésè nɨ na sè tà zi Gìká tí ngóró dré tá zìle drìdrì dhɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Gò dré gòzo gòle áyɨ lebèbhá nda ɨ véna, tàá àyɨ dré dhɨ: «Mɨ̀ adré dhu rè ayí ko, adrézó lovólé? Mɨ̀ nò rè ká! Lókyá kɨtswá dre. À adré ꞌòle Móndɨ́ nɨ Mvá nɨ lefè tàkonzɨ̀bhá ɨ drɨ́gá. ");
INSERT INTO log_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Mɨ̀ nga, mà kòlɨ̀ró! Dhya adrélépi áma lefè dhɨ atsá dre!» ");
INSERT INTO log_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Gbǎ kòdhwa, Yésu dré rè dhu adréràꞌa tà ta dhɨ ꞌá dhɨ, Yùdásɨ̀, akódhɨ nɨ lebèbhá mudrí-drì-rì dhɨ kɨ àlo dré atsázó. Adrì tá ɨ́ vésè móndɨ́ zyandre angábhá kòwánà kàdrɨ̀ ɨ vélésè ɨ̀ndɨ̀ bhàgo ɨ vélésè dhɨ ɨ be. Àyɨ nda ɨ̀ ru tá sápɨ́ ɨ fa ɨ́be àyɨ drɨ́gá. ");
INSERT INTO log_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yùdásɨ̀ adrélépi ꞌòle Yésu nɨ lefè nda tà tá àyɨ dré dhɨ, ɨ́ nɨ akódhɨ àdhi ꞌɨ yà dhɨ nɨ tadhá àyɨ dré dhɨ kònɨ̀nɨ: «Dhya má dré dra kamúlé dhɨ, akódhɨ ꞌɨ. Mɨ̀ kòru dɨ akódhɨ, lɨ̀zo ába.» ");
INSERT INTO log_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Dɨ Yùdásɨ̀ nda dré ndɨrɨ áyɨ kisízó ànyɨ Yésu làga, tàá drá dhɨ: «Rábbì, mòdo mɨ́ dré!» Dré akódhɨ nɨ kamúzó. ");
INSERT INTO log_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Dɨ Yésu dré logózóá drá dhɨ: «Áma arúpi, mɨ́ ꞌo tà mɨ́ dré alɨ̀zo ꞌòá dhɨ.» Gò móndyá nda ɨ̀ dré dhèzo Yésu dri, akódhɨ nɨ ru. ");
INSERT INTO log_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Gbǎ kòdhwa, dhya adrébhá tá túmä́ní Yésu be dhɨ kɨ àlo dré ngàzo áyɨ sápɨ́ asé gò, kòwánà kɨ kàdrɨ̀ nɨ màrábà nɨ bí bvwàzo kɨ̀le. ");
INSERT INTO log_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Dɨ, Yésu dré tàzoá drá dhɨ: «Mɨ́ logó sápɨ́ mɨ́na àrà nɨ na. Àngyá ko, móndyá títí adrébhá sápɨ́ ru àyɨ drɨ́gá dhɨ kɨ todrà sápɨ́ sè. ");
INSERT INTO log_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Mɨ́ nì ko tàle dhɨ, má nɨ tá kɨtswá áma Atá nɨ ti lizí gò, akódhɨ dré ángéló zyandre lavúlé dhɨ kɨ amùzo àma kɨ lɨkɨ́ dhɨ? ");
INSERT INTO log_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Dɨ, má kòꞌo tá kònɨ̀nɨ dhɨ, tà tɨsɨ̀le Gìká nɨ Kúlí na adrébhá tàá dhɨ, tà kòdhɨ kɨ ru ꞌo kònɨ̀nɨ dhɨ kɨ tá dɨ ru ꞌo ngɨ́nɨ?» ");
INSERT INTO log_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Gò Yésu dré tàzoá móndyá zyandre nda ɨ dré dhɨ: «Ma vo kùgú ꞌɨ gò, mɨ̀ dré adrézó alɨ̀le sápɨ́ ɨ́be ɨ̀ndɨ̀ fa ɨ́be kɨtswálé áma ru nɨ? Kìtú àlo àlo títí ɨ sè dhɨ, má adré tá lɨrɨ́lé tà tadhá tépelò na dhɨ, mɨ̀ ru tá ma ko. ");
INSERT INTO log_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Dɨ, tà kòdhɨ ɨ̀ atsá títí kònɨ̀nɨ, kɨtswálé tà pròfétà ɨ̀ dré tɨsɨ̀le dhɨ ɨ̀ kòꞌoró ru be dhɨ bvó.» Gò akódhɨ nɨ lebèbhá títí dhɨ ɨ̀ dré akódhɨ nɨ tayɨ́zó lapázó. ");
INSERT INTO log_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Dhya Yésu nɨ rubhá nda ɨ̀ dré akódhɨ nɨ drìzo lɨ̀zo ába Kàyáfà, kòwánà kɨ kàdrɨ̀ bhàna. Kònàle dhɨ, tátrɨ́trɨ́ kúlí tadhábhá ɨ bhàgo ɨ́be dhɨ ɨ̀ kɨmó tá ru. ");
INSERT INTO log_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Dɨ Pétèró ro dhɨ, lebè tá ɨ́na Yésu lárá ro, tsàle byá kòwánà kɨ kàdrɨ̀ nda nɨ bhàꞌálé na. Dré fɨ̀zo lɨrɨ́lé tépelò lɨkɨ́bhá ɨ kòfalé, kɨtswálé nòá ngalè tà nda nɨ kùdù nɨ adré ngɨ́nɨ ya dhɨ. ");
INSERT INTO log_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Kòwánà kàdrɨ̀ ɨ bhàgo kàdrɨ̀ nda ɨ́be títí dhɨ ɨ̀ adré tá tà adrélé tàle Yésu rú kɨnzò sè dhɨ kɨ nda, kɨtswázó akódhɨ nɨ ꞌo dràle dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Dɨ, ɨ̀ kisú tá àyɨkya tà àlo ko, tágba móndɨ́ bǐ dhɨ ɨ̀ dré apfòzo tà ta akódhɨ rú kɨnzò sè dhɨ. Kùdù ro dhɨ, móndɨ́ rì dhɨ ɨ̀ dré apfòzo ");
INSERT INTO log_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","tàá dhɨ: «Dhya kònɨ̀dhɨ tà dhɨ: ‹Má nɨ kɨtswá tépelò Gìká àdhya nɨ pfu gò, gòzo sìá kìtú na àmvolésè.›» ");
INSERT INTO log_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Gò kòwánà kɨ kàdrɨ̀ dré ngàzo áyɨ totó lizíá Yésu tí dhɨ: «Mɨ́ logó mɨ́na kúlí tà dhya kònɨ ɨ̀ dré adrélé tàle mɨ́ rú kòdhɨ ɨ sè ko?» ");
INSERT INTO log_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Dɨ, Yésu adré tá ɨ́na kɨ́rɨ. Gò kòwánà kɨ kàdrɨ̀ nda dré tàzoá drá dhɨ: «Má adré ámɨ kodzó Gìká lɨ́drɨ̀ ro dhɨ nɨ rú sè, mɨ́ kòsɨ̀ró mòndrà tàzoá àma dré ngalè mɨ Mèsɨ́yà, Gìká nɨ Mváagó ꞌɨ yà dhɨ.» ");
INSERT INTO log_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yésu logó drá dhɨ: «Ámɨ tàndɨ mɨ́ tà dre. Dɨ, má adré mána tàá àmɨ dré dhɨ: Mɨ̀ nɨ Móndɨ́ nɨ Mvá nɨ no adréràꞌa lɨrɨ́lé Gìká rìnyí líyí nɨ drɨ́ágó lésè. Mɨ̀ nɨ kpà akódhɨ nɨ no adréràꞌa agòle ndùrùku bhù na dhɨ ɨ drǐsè.» ");
INSERT INTO log_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Dɨ kòwánà kɨ kàdrɨ̀ nda dré áyɨ kɨ́tá lasɨ́zó kɨzà dré gò, tàzoá dhɨ: «Akódhɨ dha Gìká dre! Mà nɨ dɨ go vélé móndɨ́ àruka kɨtswábhá tà ta akódhɨ rú dhɨ kɨ nda àdho tà sè? Mɨ̀ nò rè ká! Mɨ̀ yi làdhá dré dhàle Gìká rú kòdhɨ àmɨ kɨ bíbhálé sè dre. ");
INSERT INTO log_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Mɨ̀ adré dɨ kisùá ngɨ́nɨ?» Dɨ ɨ̀ logó dhɨ: «Akódhɨ kɨtswá dràdrà sè!» ");
INSERT INTO log_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Gò ɨ̀ dré tùsú lufúzó akódhɨ mi, akódhɨ nɨ tisìzo. Àyɨ kɨ àruka ɨ̀ dré akódhɨ nɨ mì tosázó, ");
INSERT INTO log_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","adrézó tàá dhɨ: «Mèsɨ́yà, mɨ́ tà rè àma dré pròfétà ro dhɨ, ngalè àdhi sa mɨ nɨ̀ ya dhɨ ká!» ");
INSERT INTO log_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Lókyá nda sè dhɨ, Pétèró adré tá ɨ́na lɨrɨ́lé kɨvɨ̀ na, bhàꞌálé nda na. Gò mvátòkó àlo màrábà ro dhɨ dré áyɨ kisízó ànyɨ akódhɨ làga, tàá drá dhɨ: «Mɨ tá kókpà túmä́ní Yésu Gàlìláyà lésè dhɨ be.» ");
INSERT INTO log_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Dɨ, Pétèró dré ɨ́na tà nda nɨ gàzo rè móndyá títí ɨ kandrá, tàzoá dhɨ: «Má nì ngalè mɨ́ adré àdho tà ta ya dhɨ ko.» ");
INSERT INTO log_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Gò dré ngàzo pfòle bhàꞌálé nda ꞌásè, áyɨ totó ànyɨ dzóti làga. Mvátòkó àzya dhɨ dré akódhɨ nɨ nòzo gò, tàzoá móndyá adrébhá tá akódhɨ làga dhɨ ɨ dré dhɨ: «Dhya kòndɨ tá túmä́ní Yésu Nàzàrétà lésè dhɨ be.» ");
INSERT INTO log_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Dɨ Pétèró dré gòzo tódhyá tà nda nɨ ga gò, mòndrà sɨ̀zo tàzoá dhɨ: «Má nì agó kòdhɨ ko!» ");
INSERT INTO log_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Gí ko, móndyá kònàle nda ɨ̀ dré àyɨ kɨ kisízó ànyɨ Pétèró làga, tàá drá dhɨ: «Mɨ àyɨ kɨ àlo ꞌɨ bàti! Ámɨ kúlí kómvó adré tadhá dhɨ, mɨ́ angá ángolésè ya dhɨ nɨ̀.» ");
INSERT INTO log_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Dɨ Pétèró dré ngàzo mòndrà sɨ, tàzoá dhɨ: «Tátrɨ́trɨ́ kàdré má dri, má kàdré kɨnzò ta dhɨ! Má nì agó kòdhɨ ko!» Gbǎ kòdhwa, àgólòwa dré tsírà bhèzo. ");
INSERT INTO log_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Gò kúlí Yésu dré tá tàle dhɨ dré agázó Pétèró léna. Tà tá dhɨ: «Drìdrì àgólòwa dré dra tsírà bhèzo dhɨ kandrá dhɨ, mɨ́ nɨ áma ga vésè be na.» Dɨ Pétèró dré pfòzo kɨvɨ̀ na gò, ngòle kaꞌílé kaꞌikaꞌi kɨzà dré. ");
INSERT INTO log_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ngá kòwa dre dhɨ, kòwánà kàdrɨ̀ ɨ bhàgo ɨ́be dhɨ ɨ̀ dré ru yìzo títí, kɨtswázó Yésu nɨ ꞌo dràle dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Dɨ ɨ̀ dré akódhɨ nɨ adròzo gò, drìzoá lɨ̀zo fèá Pìlátò, Rómà kɨ gùvèrènérè drɨ́gá. ");
INSERT INTO log_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Dɨ Yùdásɨ̀ Yésu nɨ lefèlepi nda kàtógyà à ŋò tá tà Yésu dri kɨtswálé dràdrà sè dhɨ dre dhɨ, akódhɨ nɨ togó dré atsázó kɨzà ro lavúlé tà dré tá ꞌòle dhɨ nɨ tà sè. Gò dré làfa lòꞌwa nyadhɨ-àlo-drì-mudrí nda kɨ dòzo, lɨ̀zo kɨtswálé logóá kòwánà kàdrɨ̀ ɨ véna bhàgo ɨ́be, ");
INSERT INTO log_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","tàzoá dhɨ: «Má ꞌo tàkonzɨ̀ dre. Tàko ko, má lefè móndɨ́ adrélépi tá tà àlo àko ɨ́ rú dhɨ kàrɨbhá ɨ drɨ́gá, ɨ̀ kòꞌoró akódhɨ dràle.» Dɨ, ɨ̀ logó drá dhɨ: «Tà kòdhɨ nò àma ko. Nò mɨ kòdhya!» ");
INSERT INTO log_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Dɨ Yùdásɨ̀ dré làfa lòꞌwa nda kɨ bhèzo tépelò na gò, lɨ̀zo áyɨ ꞌɨ dràle. ");
INSERT INTO log_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Kòwánà kàdrɨ̀ nda ɨ̀ dré làfa lòꞌwa nda kɨ kudhúzó, tàzoá dhɨ: «Àma kɨ tátrɨ́trɨ́ kúlí adré làfa kònɨ̀dhɨ nɨ bhàma túmä́ní làfa tépelò na dhɨ ɨ́be dhɨ nɨ logá. Tàko ko, kònɨ̀dhɨ làfa fèle kàrɨ́ kutúzó dhɨ ꞌɨ.» ");
INSERT INTO log_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Dɨ ɨ̀ dré ru yìzo gò, làfa nda nɨ dòzo lɨ̀zo lɨ̀drɨ́ rùlepi àlo dhɨ nɨ amvú gɨ, amvú nda kàdréró àrà adrézó móndɨ́ alɨ̀alɨ̀ dhɨ kɨ àbvò si lána dhɨ ró. ");
INSERT INTO log_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Tà nda sè dhɨ, à adré amvú nda nɨ zi «Amvú kàrɨ́ àdhya» atsálé ándrò kònɨ̀dhɨ. ");
INSERT INTO log_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Dɨ tà longólé pròfétà Yèrèmɨ́yà tí dhɨ dré ru ꞌòzo kònɨ̀nɨ. Akódhɨ longó tá dhɨ: «Ɨ̀ do làfa lòꞌwa nyadhɨ-àlo-drì-mudrí ledélé àrezá sè dhɨ ɨ. Kòdhɨ tá làgɨ́ Ɨ̀sèrélè ànzɨ ɨ̀ dré bhàle akódhɨ nɨ tà sè dhɨ ꞌɨ. ");
INSERT INTO log_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Làfa nda sè dhɨ, ɨ̀ dré amvú lɨ̀drɨ́ rùlepi àdhya nɨ gɨ̀zo, ngóró Mírì dré tá tàle má dré dhɨ tɨ́nɨ.» ");
INSERT INTO log_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Lókyá nda sè dhɨ, Yésu dré pfòzo áyɨ totó Pìlátò, gùvèrènérè nda kandrá. Gò Pìlátò dré lizízóá tíá dhɨ: «Mɨ, mɨ ópɨ́ Yúdà ànzɨ kya ꞌɨ?» Yésu logó drá dhɨ: «Ámɨ tàndɨ mɨ́ tà dre.» ");
INSERT INTO log_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Kòwánà kàdrɨ̀ ɨ bhàgo ɨ́be dhɨ ɨ̀ kàsíkì akódhɨ dre dhɨ, dré kúlí logózó ko. ");
INSERT INTO log_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Dɨ Pìlátò dré lizízóá tíá dhɨ: «Mɨ́ yi tà títí ɨ̀ dré adrélé tàle mɨ́ rú kòdhɨ ɨ ko?» ");
INSERT INTO log_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Dɨ, Yésu logó ɨ́na kúlí àlo ko. Gò gùvèrènérè nda nɨ lɨ́ndrɨ́ dré gàzo ásà. ");
INSERT INTO log_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Kóná àlo àlo títí, gwányá Pásɨkà àdhya tú dhɨ, gùvèrènérè nda adré tá dhya ángùdhi bǎdzó na, móndɨ́ zyandre dhɨ ɨ̀ dré adrélé kɨpèle dhɨ nɨ trɨ àyɨ dré. ");
INSERT INTO log_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Lókyá nda kònàdhɨ sè dhɨ, agó àlo rú be Yésu Bàrábà, tà nɨ nɨ nìzo dóro dhɨ tá bǎdzó na. ");
INSERT INTO log_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Dɨ móndɨ́ zyandre dhɨ ɨ̀ kòkɨmó ru dre dhɨ, Pìlátò dré àyɨ kɨ lizízó tàzoá dhɨ: «Mɨ̀ adré lèá dhɨ, má kòtrɨ̀ àmɨ dré dhya ángùdhi kòdhya: Yésu Bàrábà, kó ngalè, Yésu adrélé zìle Mèsɨ́yà ro kònɨ̀dhɨ?» ");
INSERT INTO log_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Lizí tá àyɨ kònɨ̀nɨ tàko ko, nì tá tàle dhɨ, ɨ̀ fè tá Yésu ɨ́ drɨ́gá ngbà ꞌí dɨrèma sè dhɨ be. ");
INSERT INTO log_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pìlátò dré tá adréràꞌa lɨrɨ́lé tàbvó tǎrà na dhɨ ꞌá dhɨ, akódhɨ nɨ tòkó dré móndɨ́ mùzo tàá drá dhɨ: «Mɨ́ kòꞌo agó tà àko ɨ́ rú kòdhɨ kònzɨ ko. Àngyá ko, ándrò kònɨ̀dhɨ, má abɨ̀ toróbɨ́ akódhɨ nɨ tà dri gò, áma drì dré adrézó abɨ́lé tà nda sè tò.» ");
INSERT INTO log_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Dɨ kòwánà kàdrɨ̀ ɨ bhàgo ɨ́be dhɨ ɨ̀ dré móndyá zyandre nda kɨ kodzózó, ɨ̀ kòziró Pìlátò tí kòtrɨ̀ró Bàrábà gò, Yésu nɨ ꞌòzo dràle. ");
INSERT INTO log_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Gò Pìlátò dré gòzo lizíá àyɨ tí dhɨ: «Mɨ̀ adré lèá dhɨ, má kòtrɨ̀ àmɨ dré dhya ángùdhi àyɨ rì kònɨ ɨ kòfalé dhɨ kòdhya?» Dɨ ɨ̀ logó dhɨ: «Bàrábà!» ");
INSERT INTO log_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pìlátò gò lizíá dhɨ: «Má nɨ dɨ àdho ꞌo Yésu adrélé zìle Mèsɨ́yà ro kònɨ̀dhɨ sè?» Dɨ àyɨ títí nda ɨ̀ logó dhɨ: «Mɨ́ tidí akódhɨ fa kɨpakɨpa dri!» ");
INSERT INTO log_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pìlátò gò lizíá dhɨ: «Akódhɨ ꞌo àdho tà kònzɨ ꞌɨ?» Dɨ ɨ̀ dré gòzo adrélé tetrélé rìnyí sè, adrézó loyóá dhɨ: «Mɨ́ tidí akódhɨ!» ");
INSERT INTO log_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pìlátò dré nòzoá dhɨ, ɨ́ kɨtswá tá vélé tà àlo ꞌo bwà ko, be ró dhɨ, móndyá zyandre nda ɨ̀ adré tá ꞌòle lɨgɨ́lé ɨ́ be. Dɨ dré yǐ adózó, áyɨ drɨ́gá dzɨ̀zo àyɨ títí ɨ mi gò, tàzoá dhɨ: «Ma tà àlo àko má rú dhya kònɨ̀dhɨ nɨ kàrɨ́ nɨ tà sè! Akódhɨ nɨ kàrɨ́ nɨ ngo àmɨ dri!» ");
INSERT INTO log_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Dɨ móndyá zyandre títí nda ɨ̀ dré logózóá dhɨ: «Akódhɨ nɨ kàrɨ́ kàdré ngòle àma dri, àma kɨ ànzɨ ɨ́be wà!» ");
INSERT INTO log_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Gò Pìlátò dré Bàrábà nɨ trɨ̀zo àyɨ dré. Dré Yésu nɨ ꞌòzo bhwàle gò, akódhɨ nɨ fèzo kɨtswálé tidílé fa kɨpakɨpa dri dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Gò Pìlátò nɨ sòdá ɨ̀ dré Yésu nɨ drìzo fɨ̀zo ába gùvèrènérè nda nɨ dzó kàdrɨ̀ na. Ɨ̀ dré sòdá àruka títí dhɨ kɨ azízó ru amú àyɨ ɨ́be akódhɨ làgásè. ");
INSERT INTO log_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Gò ɨ̀ dré akódhɨ nɨ kɨ́tá kɨ tuvùzo rúásà, kánzò kǎ asózó rúá. ");
INSERT INTO log_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ɨ̀ dré fanzɨ̌ kùtsi ró dhɨ nɨ pàzo kùla ró asólé drìá gò, kòzó bhàzo drɨ́ágó nɨ lésè. Dɨ ɨ̀ dré àyɨ kɨ kórókó titìzo akódhɨ kandrá adrézó akódhɨ nɨ gu, adrézó tàá dhɨ: «Mòdo mɨ́ dré, ópɨ́ Yúdà ànzɨ kya nɨ!» ");
INSERT INTO log_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ɨ̀ dré adrézó tùsú lufú rúá gò, ɨ̀ dré kòzó nda nɨ adózó adrézó akódhɨ nɨ drì tswa ásà. ");
INSERT INTO log_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ɨ̀ kògu akódhɨ kònɨ̀nɨ dre dhɨ, ɨ̀ dré kánzò nda nɨ avùzo rúásà, gòzo akódhɨ nɨ kɨ́tá kɨ tosó rúá. Gò ɨ̀ dré akódhɨ nɨ drìzo lɨ̀zo ába, kɨtswálé tidílé fa kɨpakɨpa dri dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ɨ̀ dré tá adréràꞌa apfòle kònalésè dhɨ ꞌá dhɨ, ɨ̀ dré drì sìzo agó àlo rú be Sìmónà, angálépi Kìrénè lésè dhɨ be. Dɨ ɨ̀ dré akódhɨ nda nɨ ꞌòzo rìnyí sè adrélé fa kɨpakɨpa Yésu àdhya nɨ do. ");
INSERT INTO log_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Gò ɨ̀ dré lɨ̀zo Yésu be tsàle àrà rú zìle Gòlògótà dhɨ na. (Rú nda kòdhɨ adré lèá tàle dhɨ «Àrà drìfà àdhya».) ");
INSERT INTO log_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Kònàle dhɨ, ɨ̀ dré vínò amúlé àlókò kùdzí dhɨ be dhɨ nɨ fèzo akódhɨ dré mvùle. Dɨ, akódhɨ kòtabhì ngá nda dre dhɨ, dré ɨ́na gàzoá rè. ");
INSERT INTO log_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Dɨ ɨ̀ dré akódhɨ nɨ tidízó fa kɨpakɨpa dri gò, akódhɨ nɨ kɨ́tá kɨ lanzɨ́zó àyɨ kòfalésè dzègé sè. ");
INSERT INTO log_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Gò ɨ̀ dré lɨrɨ́zó adrélé tà lɨkɨ́ akódhɨ làgásè. ");
INSERT INTO log_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","À tɨsɨ̀ tá tà tà ŋòzo akódhɨ dri dhɨ wárágà dri gò, wárágà nda nɨ dìzo akódhɨ drìle. À tɨsɨ̀ tá dhɨ: «Kònɨ̀dhɨ Yésu, ópɨ́ Yúdà ànzɨ kya ꞌɨ.» ");
INSERT INTO log_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","À tidí tá kpà kùgubhá rì dhɨ ɨ fa àruka ɨ drǐsè akódhɨ làgásè: àlo nɨ drɨ́ágó nɨ lésè, àzya nɨ lìdzí nɨ lésè. ");
INSERT INTO log_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Móndyá adrébhá tá lavúlé àrà nda ꞌásè dhɨ ɨ̀ adré tá akódhɨ nɨ lodhá, adrézó àyɨ kɨ drì ya, ");
INSERT INTO log_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","adrézó tàá dhɨ: «Mɨ tá kɨtswálépi tépelò pfu gòzo sìá kìtú na àmvolésè nɨ, mɨ́ tɨdrɨ́ dɨ ámɨ tàndɨ wà! Mɨ́ kàdré Gìká nɨ Mváagó ꞌɨ bàti dhɨ, mɨ́ así fa kɨpakɨpa kòdhɨ drìlésè wà!» ");
INSERT INTO log_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Kòwánà kàdrɨ̀ ɨ, tátrɨ́trɨ́ kúlí tadhábhá ɨ bhàgo ɨ́be dhɨ ɨ̀ adré tá kpà akódhɨ nɨ gu kònɨ̀nɨ, adrézó tàá dhɨ: ");
INSERT INTO log_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«Akódhɨ tɨdrɨ́ móndɨ́ àruka ɨ ꞌí. Dɨ, kɨtswá ɨ́na áyɨ tàndɨ nɨ tɨdrɨ́ bwà ko! Kàdré ópɨ́ Ɨ̀sèrélè ànzɨ kya ꞌɨ bàti dhɨ, kàsí nyànomvá fa kɨpakɨpa drìlésè gò, mà kòkaꞌìró akódhɨ! ");
INSERT INTO log_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Bhà tá áyɨ tà kaꞌìkaꞌì Gìká léna, adrézó tàá dhɨ: ‹Ma Gìká nɨ Mváagó ꞌɨ.› Gìká kàdré dɨ akódhɨ nɨ le bàti dhɨ, kàpá akódhɨ nyànomvá dràdrà lésè.» ");
INSERT INTO log_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Kùgubhá tidílé akódhɨ be nda ɨ̀ adré tá kpà akódhɨ nɨ lodhá kònɨ̀nɨ. ");
INSERT INTO log_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Kɨdhólé kìtú rírí sè dhɨ, tínímvá dré bvò nɨ mì dòzo wä́yi, tsàle sáà na kìtú rírí àmvolésè dhɨ na. ");
INSERT INTO log_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ànyɨ́ànyɨ sáà na sè dhɨ, Yésu dré liyízó kúlí ꞌuꞌù sè tàzoá dhɨ: «Èlóyɨ̀, Èlóyɨ̀, lémà sàbàkàtánɨ̀?» Kòdhɨ adré lèá tàle dhɨ: «Áma Gìká, áma Gìká, mɨ́ tayɨ́ ma àdho tà sè?» ");
INSERT INTO log_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Móndɨ́ àruka adrébhá tá kònàle dhɨ ɨ̀ kòyi kúlí nda dre dhɨ, ɨ̀ dré tàzoá dhɨ: «Akódhɨ adré Èlɨ́yà nɨ zi.» ");
INSERT INTO log_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Gò àyɨ kɨ àlo dré ràzo mbèlè ngá vòdhovódho dhɨ nɨ adó, vìnègárì dàzo lána, dròzoá kòzó sílé gò, tɨngázóá kuru fèle Yésu dré mvùle. ");
INSERT INTO log_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Dɨ, àyɨ kɨ àruka ɨ̀ dré tàzoá dhɨ: «Mɨ́ tayɨ́ rè akódhɨ, mà kònòró ngalè Èlɨ́yà nɨ atsá akódhɨ nɨ tɨdrɨ́ yà dhɨ.» ");
INSERT INTO log_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yésu dré gòzo tódhyá trèle kúlí ꞌuꞌù sè gò, áyɨ lɨ́drɨ̀ tayɨ́zó lɨ̀le. ");
INSERT INTO log_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Gbǎ lókyá nda sè dhɨ, kɨ́tá ꞌɨ̀le tépelò nɨ ꞌa lakɨ́zó dhɨ dré lasɨ́zó ꞌa be rì, kɨdhólé drì lésè tsàle pá na. Bvò dré ru kosézó gò, kɨ́rà ɨ̀ dré togázó. ");
INSERT INTO log_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Mógó ɨ̀ dré ru lanzízó gò, móndɨ́ lólo Gìká àdhya bǐ dràbhá dre dhɨ kɨ rúbhá ɨ̀ dré ngàzo dràdrà ꞌásè. ");
INSERT INTO log_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Àyɨ nda ɨ̀ kòpfò mógó ɨ lésè dre dhɨ, ɨ̀ dré tɨfɨ́zó Yèrúsalémà na Yésu nɨ ngàma dràdrà ꞌásè dhɨ àmvolésè gò, ɨ̀ dré agázó móndɨ́ bǐ dhɨ ɨ mi. ");
INSERT INTO log_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Rómà kɨ sòdá kɨ kàdrɨ̀ ɨ sòdá nɨ ɨ́be adrébhá Yésu nɨ lɨkɨ́ dhɨ ɨ̀ kònò kàdíkàdi nda túmä́ní tà títí ru ꞌobhá nda ɨ́be dre dhɨ, tirì dré gàzo àyɨ léna bǐ. Dɨ ɨ̀ dré tàzoá dhɨ: «Dhya kòdhɨ tá ɨ́na Gìká nɨ Mváagó ꞌɨ bàti!» ");
INSERT INTO log_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Tòkó bǐ dhɨ ɨ tá kpà kònàle, adrélé tà nda kɨ no lárá ro. Àyɨ nda ɨ̀ lebè tá Yésu Gàlìláyà lésè, adrézó tà ꞌo drá. ");
INSERT INTO log_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Àyɨ kòfalé dhɨ tá: Màrɨ́yà Màgàdàlénè, Màrɨ́yà Yàkóbhò kɨ andre Yòséfà be dhɨ, tsàle Zèbèdáyò nɨ ànzɨ kɨ andre. ");
INSERT INTO log_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ɨ̀ndró kàndrɨ̀ dre dhɨ, agó àlo rú be Yòséfà dhɨ dré lɨ̀zo Pìlátò véna. Akódhɨ nda tá ngá líyí angálépi Àrìmàtáyà lésè dhɨ ꞌɨ. Atsá tá kpà Yésu nɨ lebèlepi ró. ");
INSERT INTO log_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Dɨ akódhɨ kòtsa Pìlátò véna dre dhɨ, dré Yésu nɨ rúbhá zìzo tíá. Gò Pìlátò dré tàzoá dhɨ, à kòfè rúbhá nda drá. ");
INSERT INTO log_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Dɨ Yòséfà dré lɨ̀zo rúbhá nda nɨ do lambélé kɨ́tá kemve dóro dhɨ sè gò, ");
INSERT INTO log_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","lɨ̀zo bhàá áyɨ tàndɨ nɨ mógó tɨ́dhɨ́ ɨ́ dré tá ꞌòle gàle kɨ́rà na dhɨ na. Dré kɨ́rà kàdrɨ̀ dhɨ nɨ alɨ́zó bhàle mógó nda tí gò, lɨ̀zo. ");
INSERT INTO log_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Màrɨ́yà Màgàdàlénè ɨ Màrɨ́yà àzya be dhɨ ɨ̀ lɨrɨ́ tá mógó nda kandrá, adrélé tà nda kɨ no. ");
INSERT INTO log_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Kìtú bvóá dhɨ sè, kòdhɨ adré tàá dhɨ, kìtú adrézó tà ledé dhɨ àmvolésè dhɨ, kòwánà kàdrɨ̀ ɨ Fàrìsáyò ɨ́be dhɨ ɨ̀ dré lɨ̀zo Pìlátò véna, ");
INSERT INTO log_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","tàá drá dhɨ: «Atálágó, tà àlo dhya móndɨ́ kɨ lɨtɨ́lépi kòdhɨ dré tá tàle dré adréràꞌa lɨ́drɨ̀ ɨ́be dhɨ ꞌá dhɨ agá ɨ́na àma léna dre. Akódhɨ tà tá dhɨ: ‹Kìtú na àmvolésè dhɨ, má nɨ nga dràdrà ꞌásè.› ");
INSERT INTO log_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Dɨ ásà dhɨ, mɨ́ kòfè tòlɨ́ adrézó akódhɨ nɨ mógó lɨkɨ́ tsàle kìtú nɨ na tú. À kòꞌo kònɨ̀nɨ ko dhɨ, akódhɨ nɨ lebèbhá kɨ kɨtswá lɨ̀le akódhɨ nɨ rúbhá kugù, gòzo tàá móndɨ́ ɨ dré dhɨ, akódhɨ nga dràdrà ꞌásè dre. Dɨ tà nda nɨ go vélé móndɨ́ kɨ lɨtɨ́ wáláká nɨ nɨ lavú.» ");
INSERT INTO log_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pìlátò logó àyɨ dré dhɨ: «Sòdá ɨ be kònwárè. Mɨ̀ kòdrì àyɨ lɨ̀zo àyɨ kɨ bha adrélé mógó nda nɨ lɨkɨ́ ngóró mɨ̀ dré nìle ꞌòle dhɨ tɨ́nɨ.» ");
INSERT INTO log_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Dɨ ɨ̀ dré lɨ̀zo kɨ́rà mógó nda tí dhɨ nɨ kɨkpà gò, ɨ̀ dré sòdá nda kɨ bhàzo adrélé lɨkɨ́á. ");
INSERT INTO log_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sàbátù àmvolésè, kìtú nɨ àlo pósò àdhya sè dhɨ, Màrɨ́yà Màgàdàlénè ɨ Màrɨ́yà àzya be dhɨ ɨ̀ dré ngàzo drùbhì kɨ́nó lɨ̀le Yésu nɨ mógó no. ");
INSERT INTO log_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Gbǎ kòdhwa, bvò dré ru kosézó rìnyí sè gò, ángéló Mírì àdhya dré asízó bhù lésè alɨ̀le kɨ́rà lɨ mógó nda tísè gò, dré lɨrɨ́zó kɨ́rà nda dri. ");
INSERT INTO log_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Akódhɨ nɨ làsú tá lagulagu ró, ɨ̀ndɨ̀ akódhɨ nɨ kɨ́tá ɨ tá kemve kpɨ́rɨ́kpɨ́rɨ́. ");
INSERT INTO log_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Dɨ sòdá adrébhá tá mógó nda nɨ lɨkɨ́ dhɨ ɨ̀ dré lyàzo kwàkwà tirì dré gò, ɨ̀ dré ledhézó kìní mi atsálé àbvò ɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Dɨ, ángéló nda dré tàzoá tòkó nda ɨ dré dhɨ: «Mɨ̀ ro ngá ko! Má nì tàle dhɨ, mɨ̀ adré Yésu tidílé fa kɨpakɨpa dri dhɨ nɨ nda kòdhya dhɨ be. ");
INSERT INTO log_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Akódhɨ kònwa yókódhó. Nga ɨ́na dràdrà ꞌásè ngóró dré tá tàle dhɨ tɨ́nɨ. Mɨ̀ alɨ̀ àrà tá rúbhá nɨ nɨ bhàzo dhɨ nɨ no. ");
INSERT INTO log_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Dɨ mɨ̀ lɨ̀ mbèlè tàá akódhɨ nɨ lebèbhá ɨ dré dhɨ: ‹Akódhɨ nga dràdrà ꞌásè dre. Adré lɨ̀le àmɨ kandrána Gàlìláyà na. Kònàle dhɨ, mɨ̀ nɨ akódhɨ nɨ no.› Nyànomvá dhɨ, má longó tà nda kòdhɨ ɨ àmɨ dré dre!» ");
INSERT INTO log_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Dɨ tòkó nda kɨ togó dré gàzo tirì sè bǐ ɨ̀ndɨ̀ arɨ́ sè bǐ gò, ɨ̀ dré ngàzo mógó nda lésè, ràle kɨtswálé rúbí nda nɨ longó Yésu nɨ lebèbhá ɨ dré. ");
INSERT INTO log_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Gbǎ kòdhwa, ɨ̀ dré ru kisúzó Yésu be gò, dré tàzoá dhɨ: «Mòdo àmɨ dré!» Dɨ ɨ̀ dré àyɨ kɨ kisízó ànyɨ akódhɨ làga, ledhélé akódhɨ nɨ pá ru, akódhɨ nɨ lɨndrɨ̀ bhàzo. ");
INSERT INTO log_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Dɨ Yésu dré tàzoá àyɨ dré dhɨ: «Mɨ̀ ro ngá ko! Mɨ̀ lɨ̀ tàá áma adrúpi ɨ dré dhɨ, ɨ̀ kòlɨ̀ Gàlìláyà na. Kònàle dhɨ, ɨ̀ nɨ áma no.» ");
INSERT INTO log_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Tòkó nda ɨ̀ dré tá adréràꞌa láti ꞌá dhɨ, sòdá adrébhá tá mógó nda nɨ lɨkɨ́ dhɨ kɨ àruka ɨ̀ dré lɨ̀zo bhàandre na, tà títí lavúbhá nda kɨ longó kòwánà kàdrɨ̀ ɨ dré. ");
INSERT INTO log_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Dɨ kòwánà kàdrɨ̀ nda ɨ̀ kòkɨmó ru bhàgo ɨ́be dre dhɨ, ɨ̀ dré ru yìzo gò, làfa fèzo bǐ sòdá nda ɨ dré, ");
INSERT INTO log_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","tàzoá àyɨ dré dhɨ: «Lè mɨ̀ kòtà dhɨ: ‹Akódhɨ nɨ lebèbhá ɨ̀ atsá tá ngátsi sè akódhɨ nɨ rúbhá kugù, mà dré tá adréràꞌa ayí ko dhɨ ꞌá.› ");
INSERT INTO log_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Dɨ tà nda nɨ rúbí kòlɨ̀ dhèle gùvèrènérè bína dhɨ, mà nɨ àmɨ kɨ tàrá ga akódhɨ kandrá, tà àlo kònzɨ dhɨ kàtsáró àmɨ rú ko dhɨ bvó.» ");
INSERT INTO log_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Dɨ sòdá nda ɨ̀ dré làfa nda nɨ dòzo gò, ɨ̀ dré ꞌòzoá ngóró tàle àyɨ dré dhɨ tɨ́nɨ. Dɨ tà nda kòdhɨ dré laꞌúzó Yúdà ànzɨ ɨ kòfalé, lɨ̀le drìdrì atsálé ándrò kònɨ̀dhɨ. ");
INSERT INTO log_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Gò Yésu nɨ lebèbhá mudrí-drì-àlo dhɨ ɨ̀ dré ngàzo lɨ̀le Gàlìláyà na, mbàle kòngó Yésu dré tá tadhálé àyɨ dré dhɨ drìna. ");
INSERT INTO log_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Dɨ ɨ̀ kòtsa akódhɨ nɨ no dre dhɨ, ɨ̀ dré ledhézó àyɨ kɨ kórókó titì akódhɨ kandrá, akódhɨ nɨ lɨndrɨ̀ bhàzo. Dɨ, àyɨ kɨ àruka ɨ̀ kayí tá àyɨkya tà nda àyɨ léna. ");
INSERT INTO log_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Gò Yésu dré áyɨ kisízó ànyɨ àyɨ títí dhɨ ɨ làga, tàá àyɨ dré dhɨ: «Gìká afè má dré rìnyí adrézó tà títí bhù na ɨ̀ndɨ̀ bvò dri dhɨ ɨ drìle dhɨ dre. ");
INSERT INTO log_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Dɨ ásà dhɨ, mɨ̀ lɨ̀ móndɨ́ súrú títí ɨ ꞌásè dhɨ kɨ ꞌo atsálé áma lebèbhá ɨ ró, bàtísimò fèzo àyɨ dré Gìká Atá nɨ rú sè, Mváagó nɨ rú sè ɨ̀ndɨ̀ Tɨrɨ́ Lólo nɨ rú sè. ");
INSERT INTO log_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Mɨ̀ kòtadhá tà títí má dré tàle mɨ̀ kòꞌo dhɨ ɨ àyɨ dré adrélé ꞌòle. Dɨ mɨ̀ yi rè ká! Má nɨ ngbú adré túmä́ní àmɨ ɨ́be, tsàle byá lókyá kùdù na.» ");
INSERT INTO log_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Kònɨ̀dhɨ Rúbí Tanɨ, Yésu Krísto, Gìká nɨ Mváagó nɨ tà dri dhɨ ꞌɨ. ");
INSERT INTO log_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ngóró pròfétà Èsáyà dré tɨsɨ̀le Gìká nɨ Kúlí na dhɨ tɨ́nɨ dhɨ, Gìká tà tá dhɨ: «Mɨ́ nò ká! Má nɨ dhya dra áma kúlí longólépi dhɨ nɨ mu lɨ̀le mɨ́ kandrána. Akódhɨ nda nɨ láti ledé mɨ́ dré. ");
INSERT INTO log_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Akódhɨ dhya adrélépi kúlí loyó duku na dhɨ ꞌɨ. Adré tàá dhɨ: ‹Mɨ̀ kòledé láti Mírì dré alɨ̀zo! Mɨ̀ kòlotó láti atsálé pyà akódhɨ dré!›» ");
INSERT INTO log_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Dɨ Yòwánɨ̀ Bàtísimò fèlepi pfò tá duku na gò, kɨdhólé adrélé bàtísimò fe móndɨ́ ɨ dré. Adré tá longóá àyɨ dré dhɨ, ɨ̀ kòladzá àyɨ kɨ togó gò, bàtísimò dòzo, Gìká kòtrìró àyɨ kɨ tàkonzɨ̀ ɨ be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Dɨ móndɨ́ zyandre dhɨ ɨ̀ adré tá apfòle bvò wä́yi Yùdáyà àdhya lésè ɨ̀ndɨ̀ Yèrúsalémà lésè, alɨ̀le Yòwánɨ̀ vélé. Ɨ̀ adré tá àyɨ kɨ tàkonzɨ̀ kɨ ta ngádra ꞌá gò, akódhɨ dré adrézó bàtísimò fe àyɨ dré yǐandre Yòròdánè àdhya na. ");
INSERT INTO log_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yòwánɨ̀ asó tá kɨ́tá ledélé kàmílò bhɨ́ sè dhɨ ɨ́ rú, káfà ledélé kàꞌwá kɨ́nɨ́ sè dhɨ nɨ ꞌɨ̀zo áyɨ kípílé ꞌá. Adré tá kɨ́sa nya, adrézó kpà apé mbɨ̀ na dhɨ nɨ mbe. ");
INSERT INTO log_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Adré tá longóá móndɨ́ ɨ dré dhɨ: «Dhya àlo áma lavúlépi rìnyí sè dhɨ nɨ adhé má bvó. Má kɨtswá akódhɨ nda nɨ lɨndrɨ̀ sè ko. Má kɨtswá ndɨ̀ndɨ̀ tandìle akódhɨ nɨ kámókà bǎ trɨ bwà ko. ");
INSERT INTO log_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Má adré mána bàtísimò fe àmɨ dré yǐ sè. Dɨ, akódhɨ nɨ ɨ́na bàtísimò fe àmɨ dré Tɨrɨ́ Lólo sè.» ");
INSERT INTO log_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Lókyá nda sè dhɨ, Yésu dré angázó Nàzàrétà Gàlìláyà le dhɨ lésè, alɨ̀le bàtísimò do Yòwánɨ̀ vélé Yòròdánè na. ");
INSERT INTO log_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Dɨ gbǎ lókyá Yésu dré tá adréràꞌa apfòle yǐ lésè dhɨ ꞌá dhɨ, dré bhù nòzo ru lanzíràꞌa gò, Tɨrɨ́ Lólo nòzo asíràꞌa kòbhòlà tɨ́nɨ adhélé ɨ́ dri. ");
INSERT INTO log_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Gò kúlí dré apfòzo bhù lésè tàá dhɨ: «Mɨ áma Mváagó má dré lèle tò dhɨ ꞌɨ. Áma togó adré kɨnɨ́lé ámɨ tà sè tò.» ");
INSERT INTO log_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Gbǎ lókyá nda sè dhɨ, Tɨrɨ́ Lólo dré Yésu nɨ drìzo lɨ̀zo ába duku na. ");
INSERT INTO log_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Kònàle dhɨ, Sàtánà dré akódhɨ nɨ tabhìzo lɨtɨ́lé kìtú nyadhɨ-rì. Akódhɨ adré tá adrélé kàꞌwá mbɨ̀ na dhɨ ɨ́be, ɨ̀ndɨ̀ ángéló ɨ̀ adré tá akódhɨ nɨ ledé. ");
INSERT INTO log_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yòwánɨ̀ nɨ rùma bhèle bǎdzó na dhɨ àmvolésè dhɨ, Yésu dré lɨ̀zo bvò Gàlìláyà àdhya na gò, kɨdhólé adrélé Rúbí Tanɨ angálépi Gìká vélésè dhɨ nɨ longó móndɨ́ ɨ dré. ");
INSERT INTO log_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Adré tá longóá dhɨ: «Lókyá kɨtswá dre. Gìká nɨ Òpɨ̀ atsá ànyɨ dre. Mɨ̀ kòladzá àmɨ kɨ togó agòzo Gìká vélé! Mɨ̀ kòkaꞌì Rúbí Tanɨ!» ");
INSERT INTO log_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Kìtú àlo, Yésu dré tá adréràꞌa atsílé tä́pä́ríandre Gàlìláyà àdhya mìlésè dhɨ ꞌá dhɨ, nò tá Sìmónà ɨ adrúpi nɨ Àndréyà be, adréràꞌa àyɨ kɨ kɨmbá bhe yǐ na. Àngyá ko, àyɨ tá kosyá bhebhá ꞌɨ. ");
INSERT INTO log_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yésu dré tàzoá àyɨ dré dhɨ: «Mɨ̀ alɨ̀ má vésè. Kɨdhólé nyànomvá dhɨ, mɨ̀ gò vélé adrélé kosyá bhebhá ɨ ró ko. Má nɨ àmɨ kɨ ꞌo adrélé móndɨ́ ndabhá ɨ ró.» ");
INSERT INTO log_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Dɨ gbǎ lókyá nda sè dhɨ, ɨ̀ dré àyɨ kɨ kɨmbá kɨ tayɨ́zó gò, ɨ̀ dré ngàzo adrélé akódhɨ nɨ lebè. ");
INSERT INTO log_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yésu kòlɨ̀ vwàle tsà dre dhɨ, dré Yàkóbhò ɨ adrúpi nɨ Yòwánɨ̀ be, Zèbèdáyò nɨ ànzɨ ɨ ró dhɨ kɨ nòzo, adréràꞌa àyɨ kɨ kɨmbá kɨ mì ledé bwátù na. ");
INSERT INTO log_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Gbǎ kòdhwa, Yésu dré àyɨ kɨ azízó gò, ɨ̀ dré àyɨ kɨ atá Zèbèdáyò nɨ tayɨ́zó àzibhá nɨ ɨ́be bwátù na, alɨ̀zo Yésu vésè. ");
INSERT INTO log_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Àmvolásà dhɨ, Yésu ɨ̀ dré lɨ̀zo lebèbhá nɨ ɨ́be tsàle bhàandre Kàpàrànàwúmà àdhya na. Sàbátù kàtsá dre dhɨ, Yésu dré fɨ̀zo Yúdà ànzɨ kɨ lɨ̀sámbò dzó na gò, kɨdhólé adrélé àyɨ kɨ tadhá. ");
INSERT INTO log_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ɨ̀ adré tá akódhɨ nɨ yi síbhálé be ngbo, tà dré adrélé tadhálé dhɨ kɨ tà sè. Tàko ko, akódhɨ nɨ kúlí ɨ tá lanzìlanzì ro. Adré tá ɨ́na àyɨ kɨ tadhá ngóró tátrɨ́trɨ́ kúlí tadhábhá kya tɨ́nɨ ko. ");
INSERT INTO log_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Gbǎ kòdhwa, agó àlo àyɨ kɨ lɨ̀sámbò dzó nda ꞌá adrélépi tɨrɨ́ kònzɨ ɨ́be ɨ́ léna dhɨ dré ngàzo trèle, ");
INSERT INTO log_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","yòzoá dhɨ: «Á! Yésu Nàzàrétà lésè nɨ, tsítsì àma kòfalésè mɨ́ be dhɨ, àdho tà ꞌɨ? Mɨ́ alɨ̀ àma kɨ tà ꞌo akɨ́lé? Má nì mɨ àdhi ꞌɨ ya dhɨ be. Mɨ Dhya lólo Gìká àdhya ꞌɨ!» ");
INSERT INTO log_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Gò Yésu dré ngàzo lɨgɨ́lé tɨrɨ́ kònzɨ nda be, tàzoá dhɨ: «Mɨ́ atsú ámɨ ti! Mɨ́ pfò agó kònɨ̀dhɨ lésè!» ");
INSERT INTO log_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Dɨ tɨrɨ́ nda dré agó nda nɨ kɨzɨ́zó rìnyí sè, trèzo kúlí ꞌuꞌù sè gò, pfòzo lásà lɨ̀le. ");
INSERT INTO log_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Móndyá títí kònàle nda kɨ lɨ́ndrɨ́ dré gàzo bhwǎbhwa gò, ɨ̀ dré adrézó lizíá àyɨ kòfalésè dhɨ: «Kònɨ̀nɨ nɨ àdho tà ꞌɨ? Mɨ̀ yi rè tà tɨ́dhɨ́ akódhɨ dré adrélé tadhálé kúlí lanzìlanzì ɨ sè dhɨ ɨ ká! Adré ndɨ̀ndɨ̀ tòlɨ́ fe tɨrɨ́ kònzɨ ɨ dré gò, ɨ̀ dré adrézó akódhɨ nɨ kúlí kaꞌì ꞌòle.» ");
INSERT INTO log_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Dɨ Yésu nɨ rúbí dré laꞌúzó mbèlè bvò wä́yi Gàlìláyà àdhya ꞌásè. ");
INSERT INTO log_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yésu ɨ̀ kàpfò lɨ̀sámbò dzó nda lésè dre dhɨ, ɨ̀ dré lɨ̀zo Yàkóbhò ɨ́be ɨ̀ndɨ̀ Yòwánɨ̀ be tsàle Sìmónà kɨ dzó Àndréyà be dhɨ na. ");
INSERT INTO log_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Dɨ, Sìmónà nɨ àdrá adré tá ɨ́na ayílé lángá na, rúbhá nɨ dré tá adrélé àtsɨ ró dhɨ sè. Gò tà nda nɨ tàzo Yésu dré. ");
INSERT INTO log_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Dɨ dré áyɨ kisízó ànyɨ tòkó nda làga, akódhɨ nɨ drɨ́gá ru, akódhɨ nɨ tɨngázó kuru gò, rúbhá àtsɨ́ nda dré pfòzo rúásà. Gò tòkó nda dré kɨdhózó ngá fe àyɨ dré nyàle. ");
INSERT INTO log_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ɨ̀ndró sè, kìtú kòndì dre dhɨ, à dré dràbhá títí dhɨ kɨ adzízó túmä́ní móndyá títí tɨrɨ́ kònzɨ ɨ́be àyɨ léna dhɨ ɨ́be Yésu vélé. ");
INSERT INTO log_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Móndyá títí bhàandre nda ꞌá dhɨ ɨ̀ kɨmó tá ru adrélé dzó nda tí. ");
INSERT INTO log_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Dɨ Yésu dré móndɨ́ bǐ adrébhá tá drà twátwa ɨ́be dhɨ kɨ tɨdrɨ́zó. Dré kpà tɨrɨ́ kònzɨ bǐ dhɨ kɨ dròzo topfòle móndɨ́ ɨ lésè. Dɨ, adré tá ɨ́na kúlí logá tɨrɨ́ kònzɨ nda ɨ dré, ɨ̀ dré nìle akódhɨ àdhi ꞌɨ ya dhɨ be dhɨ sè. ");
INSERT INTO log_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Drùbhì kɨ́nó, ngá pfùnìpfùnì sè dhɨ, Yésu dré pfòzo lɨ̀le àrà móndɨ́ àko dhɨ na gò, kɨdhólé adrélé tà ta Gìká be. ");
INSERT INTO log_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Sìmónà ɨ arúpi nɨ ɨ́be dhɨ ɨ̀ dré ngàzo adrélé akódhɨ nɨ nda. ");
INSERT INTO log_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ɨ̀ kòkisú akódhɨ dre dhɨ, ɨ̀ dré tàzoá drá dhɨ: «Móndyá títí dhɨ ɨ̀ adré ámɨ nda.» ");
INSERT INTO log_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Dɨ akódhɨ logó àyɨ dré dhɨ: «Mà kòlɨ̀ bhà àma làgásè dhɨ ɨ ꞌásè, má kòlongóró kpà Gìká nɨ kúlí kònàle be dhɨ bvó. Tàko ko, tà nda tà má dré alɨ̀zo ꞌòá dhɨ ꞌɨ.» ");
INSERT INTO log_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Gò dré ngàzo tatsílé bvò wä́yi Gàlìláyà àdhya ꞌásè, Gìká nɨ kúlí longóbe Yúdà ànzɨ kɨ lɨ̀sámbò dzó ɨ ꞌásè, ɨ̀ndɨ̀ tɨrɨ́ kònzɨ kɨ drobe topfòle móndɨ́ ɨ lésè. ");
INSERT INTO log_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Kìtú àlo dhɨ, agó àlo kàrɨ́ dré rùle dhɨ alɨ̀ tá adhélé áyɨ kórókó titì Yésu kandrá, akódhɨ nɨ ti lizízó tàzoá dhɨ: «Mɨ rìnyí ɨ́be kɨtswázó áma temvé tɨdrɨ́lé, mɨ́ kòlè dhɨ.» ");
INSERT INTO log_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Dɨ Yésu dré kɨzà dòzo áyɨ togó na akódhɨ nɨ tà sè gò, drɨ́gá kɨdzɨ̀zo akódhɨ nɨ tabè, tàzoá drá dhɨ: «Má lè ꞌí. Mɨ́ kàdré kemve kpɨ́rɨ́kpɨ́rɨ́ wà!» ");
INSERT INTO log_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Gbǎ kòdhwa, kàrɨ́ drà nda dré ngàzo agó nda rúsè gò, dré adrɨ́zó. ");
INSERT INTO log_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Gbǎ lókyá nda sè dhɨ, Yésu dré láti fèzo akódhɨ dré lɨ̀zo, tà lazízó drìá kònɨ̀nɨ: ");
INSERT INTO log_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","«Mɨ́ kònò dóro, mɨ́ kòlongóró tà kòdhɨ dhya àlo dré ko. Be ró dhɨ, mɨ́ lɨ̀ mɨ́na ámɨ tadhá kòwánà dré nòle, ɨ̀ndɨ̀ mɨ́ fè ngá mòbòmà ro Gìká dré ámɨ temvema sè ngóró Mósè nɨ tátrɨ́trɨ́ kúlí dré adrélé tàle dhɨ tɨ́nɨ, tadházóá móndɨ́ ɨ dré dhɨ, mɨ́ adrɨ́ dre káyà dhɨ.» ");
INSERT INTO log_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Dɨ, agó nda kòlɨ̀ dre dhɨ, dré ɨ́na kɨdhózó adrélé tà atsálépi ɨ́ rú nda nɨ longó ngádra ꞌá, adrézó rúbí nɨ nɨ ꞌo laꞌúlé. Ásà dhɨ, Yésu kɨtswá tá gòle vélé fɨ̀le bhàandre àlo dhɨ na ngádra ꞌásè bwà ko. Be ró dhɨ, adré tá ɨ́na adrélé àrà móndɨ́ àko dhɨ ɨ ꞌásè. Dɨ, tágba kònɨ̀nɨ dhɨ, móndɨ́ zyandre dhɨ ɨ̀ adré tá angálé àrà títí ɨ lésè alɨ̀le akódhɨ vélé. ");
INSERT INTO log_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Kìtú àruka ɨ̀ kòlavú dre dhɨ, Yésu dré gòzo gòle Kàpàrànàwúmà na gò, à dré yìzoá tàle dhɨ, akódhɨ ɨ́ bhàna. ");
INSERT INTO log_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Dɨ móndɨ́ zyandre lavúlé dhɨ ɨ̀ dré alɨ̀zo ru kɨmó gàle dzó nda léna bǐ. Àrà adrézó dhyá kɨ totó ndɨ̀ndɨ̀ kɨvɨ̀ na dzó nda tí dhɨ tá vélé yókódhó. Yésu dré tá adréràꞌa Gìká nɨ kúlí longó àyɨ dré dhɨ ꞌá dhɨ, ");
INSERT INTO log_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","móndɨ́ àruka ɨ̀ dré atsázó agó àlo pá be àbvò ro, àyɨ kɨ su ɨ̀ dré adrélé adólé kíndri dri dhɨ be. ");
INSERT INTO log_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Dɨ, móndyá zyandre nda kɨ tà sè dhɨ, ɨ̀ kɨtswá tá àyɨkya láti kisú fɨ̀zo ába Yésu véna bwà ko. Dɨ ɨ̀ dré ngàzo mbàle ába dzó nda drìna gò, dzó nda nɨ drì awú. Ɨ̀ kòlò láti dre dhɨ, ɨ̀ dré akódhɨ nɨ tɨrɨ́zó sìle kíndri dré adrézó ayílé drìá dhɨ dri, Yésu kandrá. ");
INSERT INTO log_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Dɨ Yésu kònò àyɨ kɨ tà kaꞌìkaꞌì dre dhɨ, dré tàzoá agó pá be àbvò ro nda dré dhɨ: «Áma mvá, à trì ámɨ tàkonzɨ̀ ɨ dre.» ");
INSERT INTO log_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Dɨ, tátrɨ́trɨ́ kúlí tadhábhá àruka adrébhá tá lɨrɨ́lé kònàle dhɨ ɨ̀ dré dhèzo adrélé kisùá àyɨ léna dhɨ: ");
INSERT INTO log_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Dhya kòndɨ adré tà ta kònɨ̀nɨ àdho tà sè? Adré ɨ́na Gìká nɨ dha! Àdhi nɨ kɨtswá tàkonzɨ̀ tri nɨ̀, kàdré ngbà ꞌí Gìká ꞌɨ kalóma ko dhɨ?» ");
INSERT INTO log_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Gbǎ kòdhwa, Yésu dré tà ɨ̀ dré adrélé kisùle nda nɨ nìzo kyá gò, tàzoá àyɨ dré dhɨ: «Mɨ̀ adré àmɨkya tà kisù kònɨ̀nɨ àdho tà sè? ");
INSERT INTO log_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Tà kɨtswálé tàle mbèlè agó pá be àbvò ro kònɨ̀dhɨ dré dhɨ, ángùdhi ꞌɨ: ‹À trì ámɨ tàkonzɨ̀ ɨ dre› dhɨ, kó ngalè, ‹Mɨ́ nga, mɨ́ do ámɨ kíndri, ɨ̀ndɨ̀ mɨ́ kɨdhó atsí to› dhɨ? ");
INSERT INTO log_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Má adré lèá mɨ̀ kònì dhɨ, Móndɨ́ nɨ Mvá rìnyí ɨ́be adrézó tàkonzɨ̀ tri bvò dri.» Dɨ dré tàzoá agó pá be àbvò ro nda dré dhɨ: ");
INSERT INTO log_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«Má adré tàá mɨ́ dré dhɨ: Mɨ́ nga, mɨ́ do ámɨ kíndri, ɨ̀ndɨ̀ mɨ́ nzɨ mɨ́ bhàna!» ");
INSERT INTO log_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Gbǎ kòdhwa, agó nda dré ngàzo áyɨ kíndri do, pfòzo lɨ̀le móndyá títí ɨ misè. Dɨ àyɨ títí nda kɨ lɨ́ndrɨ́ dré gàzo bhwǎbhwa gò, ɨ̀ dré ngàzo adrélé Gìká nɨ rú bha kùle, adrézó tàá dhɨ: «Mà nò rè tàdzí tà làsú be kònɨ̀nɨ dhɨ ko!» ");
INSERT INTO log_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Àmvolásà dhɨ, Yésu dré gòzo tódhyá pfòle tä́pä́ríandre Gàlìláyà àdhya làgana. Móndɨ́ zyandre lavúlé dhɨ ɨ̀ adré tá alɨ̀le akódhɨ vélé gò, dré adrézó àyɨ kɨ tadhá. ");
INSERT INTO log_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Dré tá adréràꞌa lavúlé tä́pä́ríandre nda mìlésè dhɨ ꞌá dhɨ, dré Lévì Àlàfáyò nɨ mvá nɨ nòzo adréràꞌa lɨrɨ́lé mèdáyɨ̀ lagɨ́rà na. Dré tàzoá drá dhɨ: «Mɨ́ lebè ma!» Dɨ Lévì nda dré ngàzo adrélé akódhɨ nɨ lebè. ");
INSERT INTO log_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Bvóá dhɨ, Yésu ɨ̀ dré lɨ̀zo lebèbhá nɨ ɨ́be Lévì nɨ dzó na gò, ɨ̀ dré lɨrɨ́zó mɨ́sá làgásè adrélé ngá nya túmä́ní mèdáyɨ̀ lagɨ́bhá ɨ́be bǐ, ɨ̀ndɨ̀ móndɨ́ adrélé nòle tàkonzɨ̀bhá ro dhɨ ɨ́be bǐ. Tàko ko, móndɨ́ bǐ làsú be kònɨ̀nɨ dhɨ ɨ̀ adré tá Yésu nɨ lebè. ");
INSERT INTO log_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Dɨ, tátrɨ́trɨ́ kúlí tadhábhá àruka adrébhá tá kpà Fàrìsáyò ro dhɨ ɨ̀ kònò akódhɨ adréràꞌa ngá nya túmä́ní móndɨ́ làsú be kònɨ̀nɨ dhɨ ɨ́be dre dhɨ, ɨ̀ dré ngàzo lizíá akódhɨ nɨ lebèbhá ɨ tí dhɨ: «Akódhɨ adré ngá nya túmä́ní mèdáyɨ̀ lagɨ́bhá ɨ́be ɨ̀ndɨ̀ tàkonzɨ̀bhá ɨ́be àdho tà sè?» ");
INSERT INTO log_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yésu kòyi tà lizílé nda dre dhɨ, dré tàzoá àyɨ dré dhɨ: «Móndyá rúbhá be dóro dhɨ ɨ̀ ndà gà kódzó ko na. Be ró dhɨ, móndyá drà ro dhɨ ɨ̀ adré àyɨkya ndàá àyɨ. Má alɨ̀ móndyá adrébhá àyɨ kɨ no gyǎgya dhɨ kɨ azí kòdhya ko. Be ró dhɨ, má alɨ̀ mána tàkonzɨ̀bhá kɨ azí kòdhya.» ");
INSERT INTO log_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Kìtú àlo dhɨ, Yòwánɨ̀ Bàtísimò fèlepi nɨ lebèbhá ɨ Fàrìsáyò ɨ́be dhɨ ɨ̀ adré tá tàbirí mvo. Dɨ móndɨ́ àruka ɨ̀ dré alɨ̀zo lizíá Yésu tí dhɨ: «Yòwánɨ̀ nɨ lebèbhá ɨ Fàrìsáyò kya ɨ́be dhɨ ɨ̀ adré kó tàbirí mvo, adrézó tà zi Gìká tí dhɨ, ámɨ lebèbhá ɨ̀ adré dɨ àyɨkya tàbirí mvo ko àdho tà sè?» ");
INSERT INTO log_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yésu logó àyɨ dré dhɨ: «Móndyá azílé gwányá làmó àdhya lé dhɨ kɨ kɨtswá tsì tàbirí mvo, ɨ̀ dré adréràꞌa túmä́ní tòkó líyí be dhɨ ꞌá? Tàdzí ko! Ɨ̀ dré rè dhu adréràꞌa tòkó líyí nda be àyɨ kòfalé dhɨ ꞌá dhɨ, ɨ̀ kɨtswá tàbirí mvo ko. ");
INSERT INTO log_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Dɨ, lókyá adrélépi alɨ̀le dhɨ sè dhɨ, à nɨ tòkó líyí nda nɨ tɨngá àyɨ kòfalésè gò, ɨ̀ dré kɨdhózó adrélé tàbirí mvo lókyá nda sè. ");
INSERT INTO log_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Dhya àlo kàdré kɨ́tá àku ró lasɨ́lépi dhɨ ɨ́be dhɨ, dhɨ kɨ́tá tɨ́dhɨ́ ro dhɨ kɨ́tá àku nda dri ko na. Tàko ko, kòꞌo kònɨ̀nɨ dhɨ, kɨ́tá tɨ́dhɨ́ nda nɨ kɨ́tá àku nda nɨ asé gò, kɨ́tá àku nda dré gòzo vélé lasɨ́lé lɨ̀le drìdrì. ");
INSERT INTO log_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Kòdhɨ ɨ́be dhɨ, dhya àlo dà vínò tɨ́dhɨ́ ro dhɨ kɨ́nɨ́ dhɨ̀le adrézó vínò lɨkɨ́, akùbhá dre dhɨ ɨ léna ko na. Tàko ko, kòꞌo kònɨ̀nɨ dhɨ, vínò tɨ́dhɨ́ nda nɨ abhò kɨ́nɨ́ àku nda kɨ lasɨ́ gò, vínò ɨ kɨ́nɨ́ nda ɨ́be dhɨ ɨ̀ dré abɨ́zó títí. Ásà dhɨ, à adré vínò tɨ́dhɨ́ ro dhɨ nɨ da kɨ́nɨ́ tɨ́dhɨ́ ro dhɨ ɨ léna.» ");
INSERT INTO log_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sàbátù àlo dhɨ, Yésu ɨ̀ adré tá lavúlé amvú ngánò àdhya ɨ ꞌásè gò, akódhɨ nɨ lebèbhá ɨ̀ dré kɨdhózó adrélé ngánò lòꞌwa vu. ");
INSERT INTO log_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Gò Fàrìsáyò ɨ̀ dré tàzoá Yésu dré dhɨ: «Mɨ́ nò rè ká! Ámɨ lebèbhá ɨ̀ adré àyɨkya tà àma kɨ tátrɨ́trɨ́ kúlí dré adrélé logálé sàbátù tú dhɨ nɨ ꞌo àdho tà sè?» ");
INSERT INTO log_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Dɨ Yésu logó àyɨ dré dhɨ: «Mɨ̀ nà rè tàdzí tà Dàwídì dré tá ꞌòle ɨ̀ dré adréràꞌa lemerè ro ɨ̀ndɨ̀ tàbirí ɨ́be akódhɨ nɨ arúpi ɨ́be dhɨ ꞌá dhɨ ko? ");
INSERT INTO log_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Kòwánà kɨ kàdrɨ̀, Àbɨ̀yàtárà nɨ lókyá ꞌá dhɨ, Dàwídì nda fɨ tá Gìká nɨ dzó kàdrɨ̀ na, mápà fèle Gìká dré dhɨ nɨ adó nyàle gò, dré kpà fèzoá áyɨ arúpi ɨ dré nyàle. Tákò àma kɨ tátrɨ́trɨ́ kúlí adré tá ɨ́na mápà nda nɨ nyàma logá àyɨ dré. Ngbà ꞌí kòwánà kɨ tá kɨtswá nyàá dhɨ àyɨ.» ");
INSERT INTO log_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yésu gò tàá àyɨ dré dhɨ: «Gìká bhà móndɨ́ ɨ adrélé sàbátù dré ko. Be ró dhɨ, bhà ɨ́na sàbátù adrélé móndɨ́ ɨ dré. ");
INSERT INTO log_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Dɨ ásà dhɨ, Móndɨ́ nɨ Mvá Mírì ꞌɨ, ndɨ̀ndɨ̀ Mírì sàbátù àdhya ꞌɨ.» ");
INSERT INTO log_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Sàbátù àzya tú dhɨ, Yésu dré gòzo fɨ̀le Yúdà ànzɨ kɨ lɨ̀sámbò dzó na. Kònàle dhɨ, agó àlo drɨ́gá nɨ dré ꞌyòzo ꞌyoꞌyò dhɨ tá be. ");
INSERT INTO log_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Fàrìsáyò àruka ɨ̀ adré tá tà ɨ̀ dré kɨtswázó Yésu nɨ asíkì ásà dhɨ nɨ nda. Dɨ ɨ̀ adré tá akódhɨ nɨ mì ga, nòzoá ngalè akódhɨ nɨ agó nda nɨ tɨdrɨ́ sàbátù tú yà dhɨ. ");
INSERT INTO log_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Dɨ Yésu dré tàzoá agó drɨ́gá be àꞌyo ró nda dré dhɨ: «Mɨ́ nga ámɨ totó móndyá títí dhɨ kɨ kɨ́tó ꞌá.» ");
INSERT INTO log_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Gò dré lizízóá àyɨ títí nda ɨ tí dhɨ: «Àma kɨ tátrɨ́trɨ́ kúlí adré tà ángùdhi nɨ kaꞌì sàbátù tú dhɨ kòdhya: adrélé tà dóro ꞌo dhɨ, kó ngalè adrélé tà kònzɨ ꞌo dhɨ? Adrélé móndɨ́ tɨdrɨ́ dhɨ, kó ngalè adrélé móndɨ́ pfu dràle dhɨ?» Dɨ, ɨ̀ logó àyɨkya kúlí ko. ");
INSERT INTO log_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yésu dré móndyá ɨ́ làgásè kúrú nda kɨ nòzo títí togóaswa sè. Dɨ, akódhɨ nɨ togó tá kpà kɨzà ro, ɨ̀ dré àyɨ kɨ togó ꞌòle tombálé dhɨ sè. Gò dré tàzoá agó nda dré dhɨ: «Mɨ́ kɨdzɨ̀ ámɨ drɨ́gá.» Akódhɨ dré kɨdzɨ̀zoá gò, drɨ́gá nɨ nda dré adrɨ́zó. ");
INSERT INTO log_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Gbǎ lókyá nda sè dhɨ, Fàrìsáyò nda ɨ̀ dré pfòzo ru yi móndyá ópɨ́ Èródè àdhya ɨ́be, kɨtswázó láti nda Yésu nɨ pfùzo dràle dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Àmvolásà dhɨ, Yésu ɨ̀ dré àyɨ kɨ vùzo lyà lebèbhá nɨ ɨ́be lɨ̀le tä́pä́ríandre Gàlìláyà àdhya làgana. Dɨ móndɨ́ zyandre lavúlé dhɨ ɨ̀ dré akódhɨ nɨ lebèzo. Àyɨ nda ɨ̀ yi tá tà títí akódhɨ dré adrélé ꞌòle dhɨ ɨ gò, ɨ̀ dré angázó bvò Gàlìláyà àdhya lésè, bvò Yùdáyà àdhya lésè, Yèrúsalémà lésè, bvò Ìdùmáyà àdhya lésè, Yòròdánè nɨ taꞌá lésè, ɨ̀ndɨ̀ bvò Tírè ɨ làga Sìdónà be dhɨ lésè, alɨ̀le akódhɨ vélé. ");
INSERT INTO log_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Dɨ Yésu dré tàzoá áyɨ lebèbhá ɨ dré dhɨ, ɨ̀ kòkisí bwátù bhàle ànyɨ ɨ́ làga adrélé gànzi ró ɨ́ dré, móndyá zyandre nda ɨ̀ kòkipìró ɨ ko dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Tàko ko, akódhɨ tɨdrɨ́ tá móndɨ́ bǐ dhɨ ɨ gò, móndɨ́ drà twátwa ɨ́be dhɨ ɨ̀ dré adrézó adàle akódhɨ vélé, kɨtswálé akódhɨ nɨ tabè dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Dɨ àyɨ tɨrɨ́ kònzɨ ɨ́be àyɨ léna dhɨ ɨ̀ kàdré akódhɨ nɨ no dhɨ, ɨ̀ adré tá adhélé akódhɨ kandrá, adrélé tetrélé, adrézó tàá dhɨ: «Mɨ Gìká nɨ Mváagó ꞌɨ!» ");
INSERT INTO log_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Dɨ, Yésu adré tá ɨ́na àyɨ kɨ logá, ɨ̀ kòtadháró móndɨ́ ɨ dré ɨ àdhi ꞌɨ ya dhɨ ko. ");
INSERT INTO log_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Àmvolásà dhɨ, Yésu dré lɨ̀zo mbàle kòngó àlo drìna. Dré móndɨ́ ɨ́ dré lèle azílé dhɨ kɨ azízó gò, ɨ̀ dré alɨ̀zo akódhɨ vélé. ");
INSERT INTO log_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Dɨ dré móndyá mudrí-drì-rì nda kɨ bhàzo twá, àyɨ kɨ zìzo àpóstolò ɨ ró, ɨ̀ kàdréró túmä́ní ɨ́ be, ɨ̀ndɨ̀ ɨ́ kàdréró àyɨ kɨ tibhù Rúbí Tanɨ longó be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Dré kpà rìnyí fèzo àyɨ dré kɨtswázó tɨrɨ́ kònzɨ kɨ dro topfòle móndɨ́ ɨ lésè. ");
INSERT INTO log_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Àyɨ mudrí-drì-rì dré bhàle twá nda ɨ tá: Sìmónà (dré rú zìle Pétèró dhɨ), ");
INSERT INTO log_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yàkóbhò Zèbèdáyò nɨ mvá, adrúpi nɨ Yòwánɨ̀ be (Yésu dré àyɨ kɨ rú zìzo Bwànèrégè dhɨ ɨ; rú nda kòdhɨ adré lèá tàle dhɨ «Bhù nɨ tadima nɨ ànzɨàgo ɨ»), ");
INSERT INTO log_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Àndréyà, Fìlípò, Bàràtòlòmáyò, Màtáyò, Tòmá, Yàkóbhò Àlàfáyò nɨ mvá, Tàdáyò, Sìmónà (adrélépi àtsɨ ró áyɨ súrú nɨ tà sè dhɨ), ");
INSERT INTO log_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ɨ̀ndɨ̀ Yùdásɨ̀ Ɨ̀sɨ̀kàrɨ̀yótà (dra Yésu nɨ lefèlepi kàrɨbhá ɨ drɨ́gá dhɨ). ");
INSERT INTO log_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Àmvolásà dhɨ, Yésu dré gòzo nzɨ̀le ɨ́ bhàna gò, móndɨ́ zyandre dhɨ ɨ̀ dré gòzo tódhyá ru kɨmó kònàle. Tà nda sè dhɨ, akódhɨ ɨ lebèbhá nɨ ɨ́be dhɨ ɨ̀ kɨtswá tá ndɨ̀ndɨ̀ ngá nya bwà ko. ");
INSERT INTO log_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Akódhɨ nɨ aró ɨ̀ kòyi tà nda dre dhɨ, ɨ̀ dré alɨ̀zo kɨtswálé akódhɨ nɨ dri sùzo rúá dhɨ bvó. Tàko ko, ɨ̀ adré tá tàá dhɨ, akódhɨ nɨ drì abɨ́ vélé dre. ");
INSERT INTO log_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Dɨ, tátrɨ́trɨ́ kúlí tadhábhá angábhá Yèrúsalémà lésè dhɨ ɨ̀ adré tá àyɨkya tàá dhɨ: «Akódhɨ Bèlèzèbúlè ɨ́be ɨ́ léna! Adré tɨrɨ́ kònzɨ kɨ dro topfòle móndɨ́ ɨ lésè, tɨrɨ́ kònzɨ kɨ kàdrɨ̀ nɨ rìnyí sè!» ");
INSERT INTO log_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Dɨ Yésu dré àyɨ nda kɨ azízó gò, tàzoá àyɨ dré kúlí alaala sè dhɨ: «Sàtánà nɨ kɨtswá Sàtánà nɨ dro pfòle móndɨ́ lésè ngɨ́nɨngɨ́nɨ ró? ");
INSERT INTO log_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Òpɨ̀ ángùdhi móndyá zàlá dhɨ ɨ̀ dré adrézó ru lanzɨ́ àyɨ kòfalésè dhɨ, òpɨ̀ nda kɨtswá áyɨ totó bwà ko. ");
INSERT INTO log_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Dzó ángùdhi móndyá lá dhɨ ɨ̀ dré adrézó ru lanzɨ́ àyɨ kòfalésè dhɨ, dzó nda kɨtswá kpà áyɨ totó bwà ko. ");
INSERT INTO log_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kókpà kòdhɨ tɨ́nɨ, móndyá Sàtánà nɨ rìnyí zàle dhɨ ɨ̀ kàdré ru lanzɨ́ adrézó ru pfu àyɨ kòfalésè dhɨ, akódhɨ nɨ rìnyí nda kɨtswá áyɨ totó bwà ko. Be ró dhɨ, tà nɨ nɨ akɨ́ títí. ");
INSERT INTO log_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Kòdhɨ ɨ́be dhɨ, dhya àlo kɨtswá fɨ̀le agó kòmbá àlo dhɨ nɨ dzó na akódhɨ nɨ ngá wu bwà ko, kàdrò zyà rè kòmbá nda bǎ sè ꞌíká ko dhɨ. Dɨ kàdrò akódhɨ dre dhɨ, a nɨ kɨtswá ngá títí akódhɨ nɨ dzó na nda kɨ wu. ");
INSERT INTO log_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Má adré tà bàti ta àmɨ dré: Gìká nɨ kɨtswá tàkonzɨ̀ títí móndɨ́ ɨ̀ dré adrélé ꞌòle dhɨ kɨ tri, túmä́ní làdhá títí ɨ̀ dré adrélé dhàle ɨ́ rú dhɨ ɨ́be. ");
INSERT INTO log_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Dɨ, dhya ángùdhi adrélépi ɨ́na làdhá dha Tɨrɨ́ Lólo rú dhɨ, à kɨtswá akódhɨ nda nɨ tàkonzɨ̀ tri tàdzí ko. Be ró dhɨ, tàkonzɨ̀ nda nɨ adré akódhɨ dri kóná vésè kólyá.» ");
INSERT INTO log_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yésu tà tá tà nda kònɨ̀nɨ, ɨ̀ dré tá adrélé tàle dhɨ «Akódhɨ tɨrɨ́ kònzɨ ɨ́be ɨ́ léna» dhɨ sè. ");
INSERT INTO log_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Lókyá nda sè dhɨ, Yésu nɨ andre ɨ adrúpi nɨ ɨ́be dhɨ ɨ̀ dré atsázó adrélé àyɨ kɨ totó kɨvɨ̀ na. Gò ɨ̀ dré móndɨ́ mùzo fɨ̀le Yésu nɨ azí. ");
INSERT INTO log_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Móndɨ́ zyandre dhɨ ɨ̀ lɨrɨ́ tá adrélé akódhɨ làgásè kúrú. Gò tàzoá drá dhɨ: «Ámɨ andre, ámɨ adrúpi ɨ, ámɨ amvúpi ɨ́be dhɨ ɨ̀ adré ámɨ letè kɨvɨ̀ na.» ");
INSERT INTO log_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Dɨ Yésu logó àyɨ dré dhɨ: «Áma andre ɨ áma adrúpi ɨ́be dhɨ ɨ àdhibhá ꞌɨ?» ");
INSERT INTO log_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Dré móndyá lɨrɨ́bhá ɨ́ làgásè kúrú nda kɨ nòzo títí gò, tàzoá dhɨ: «Mɨ̀ nò rè áma andre ɨ áma adrúpi ɨ́be kònɨ ɨ ká! ");
INSERT INTO log_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Tàko ko, dhya ángùdhi adrélépi tà Gìká dré adrélé lèle à kòꞌo dhɨ kɨ ꞌo dhɨ ɨ́na áma adrúpi ꞌɨ, áma amvúpi ꞌɨ, ɨ̀ndɨ̀ áma andre ꞌɨ.» ");
INSERT INTO log_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Àmvolásà dhɨ, Yésu dré gòzo tódhyá adrélé tà tadhá tä́pä́ríandre Gàlìláyà àdhya làga. Móndɨ́ zyandre lavúlé dhɨ ɨ̀ dré ru kɨmólé akódhɨ làgásè kúrú dhɨ sè dhɨ, dré mbàzo lɨrɨ́lé bwátù adrélépi yǐ mìle dhɨ na, móndyá zyandre títí nda ɨ̀ dré adréràꞌa tä́pä́ríandre mìle dhɨ ꞌá. ");
INSERT INTO log_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Dɨ dré kɨdhózó tà bǐ dhɨ kɨ tadhá àyɨ dré pɨ́dhɨ́gó sè, adrézó tàá dhɨ: ");
INSERT INTO log_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Mɨ̀ yi rè ká! Kìtú àlo dhɨ, agó àlo dhɨ pfò tá lɨ̀le kórɨ̀ rɨ áyɨ amvú na. ");
INSERT INTO log_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Dré tá adréràꞌa kórɨ̀ rɨ dhɨ ꞌá dhɨ, kórɨ̀ àruka ɨ̀ ledhé tá láti mìle gò, àrɨ́ ɨ̀ dré adàzo tetéá títí. ");
INSERT INTO log_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Kórɨ̀ àruka ɨ̀ ledhé tá bvò kɨ́rà ro adrélépi kìní ɨ́be tsà dhɨ dri. Ɨ̀ dré apfòzo mbèlè, kìní dré nzìle ko dhɨ sè. ");
INSERT INTO log_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Dɨ, kìtú kòka dre dhɨ, dré àyɨ kɨ zàzo ꞌyòle, àyɨ kɨ kɨ́drɨ dré fɨ̀le kìní na dóro ko dhɨ sè. ");
INSERT INTO log_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Kórɨ̀ àruka ɨ̀ ledhé tá kùtsí kòfalé. Kùtsí nda dré mbàzo àyɨ kɨ amó gò, ɨ̀ dré lòꞌwa ꞌàzo ko. ");
INSERT INTO log_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Dɨ, kórɨ̀ àruka ɨ̀ ledhé tá àyɨkya kìní dóro dri gò, ɨ̀ dré apfòzo mbàle lòꞌwa ꞌa dóro. Àlo nɨ ꞌa lòꞌwa nyadhɨ-àlo-drì-mudrí, àzya nɨ nyadhɨ-na, àzya nɨ nyadhɨ-nzi.» ");
INSERT INTO log_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yésu gò tàá dhɨ: «Dhya ángùdhi adrélépi bíbhálé ɨ́be tà yìzo dhɨ kòyi!» ");
INSERT INTO log_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Àmvolásà dhɨ, Yésu dré tá adréràꞌa kalóma dhɨ ꞌá dhɨ, akódhɨ nɨ lebèbhá mudrí-drì-rì dhɨ ɨ túmä́ní móndyá adrébhá tá àyɨ kɨ kɨmó akódhɨ làga dhɨ ɨ́be dhɨ, ɨ̀ dré alɨ̀zo akódhɨ nɨ lizí pɨ́dhɨ́gó dré adrélé pɨ̀le dhɨ kɨ tà sè. ");
INSERT INTO log_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Dɨ dré logózóá àyɨ dré dhɨ: «Gìká fè àmɨ dré tògyá áyɨ Òpɨ̀ nɨ tà lùzu ró dhɨ nɨ nìzo. Dɨ, móndyá kɨvɨ̀ na dhɨ ɨ dré dhɨ, má adré tà títí dhɨ kɨ ta pɨ́dhɨ́gó sè, ");
INSERT INTO log_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","kɨtswálé: ‹ɨ̀ kàdré gba ngá no yà dhɨ, ɨ̀ kàdréró ngá ɨ̀ dré adrélé nòle nda kɨ atógyà ko, ɨ̀ndɨ̀ ɨ̀ kàdré gba tà yi yà dhɨ, ɨ̀ kàdréró tà ɨ̀ dré adrélé yìle nda kɨ àndu ni ko. Kònò kàdré tá kònɨ̀nɨ ko dhɨ, ɨ̀ nɨ tá àyɨ kɨ togó adzá má vélé gò, má dré àyɨ kɨ tàkonzɨ̀ trìzo!›» ");
INSERT INTO log_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Dɨ Yésu gò tàá àyɨ dré dhɨ: «Mɨ̀ nì tsì pɨ́dhɨ́gó kòdhɨ nɨ àndu ko? Mɨ̀ nɨ dɨ pɨ́dhɨ́gó àruka títí dhɨ kɨ àndu ni ngɨ́nɨngɨ́nɨ ró? ");
INSERT INTO log_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Agó adrélépi kórɨ̀ rɨ nda adré Gìká nɨ kúlí rɨ kòdhya. ");
INSERT INTO log_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Móndɨ́ àruka ɨ̀ adré kúlí nda nɨ kaꞌì ngóró kórɨ̀ rɨ̀le ledhélé láti mìle nda ɨ tɨ́nɨ. Ɨ̀ kòyi kúlí nda dre dhɨ, Sàtánà adré ndɨrɨ atsálé kúlí rɨ̀le nda nɨ tɨngá àyɨ kɨ togó lésè. ");
INSERT INTO log_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Móndɨ́ àruka ɨ̀ adré Gìká nɨ kúlí kaꞌì ngóró kórɨ̀ rɨ̀le ledhélé bvò kɨ́rà ro dhɨ dri nda ɨ tɨ́nɨ. Ɨ̀ kòyi kúlí nda dre dhɨ, ɨ̀ adré ndɨrɨ kaꞌìá arɨ́ sè. ");
INSERT INTO log_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Dɨ, ɨ̀ dré adrélé kúlí nda nɨ tayɨ́ adrélé tɨ̀le àyɨ kɨ togó na ko dhɨ sè dhɨ, ɨ̀ adré ngbà ꞌí tròle rúá lókyá tsà sè. Dɨ kàdré tà ɨ̀ dré adrézó kɨzà nya ásà dhɨ ꞌɨ yà, ngalè tà adrézó àyɨ kɨ mì pfo kúlí nda nɨ tà sè dhɨ ꞌɨ yà dhɨ, ɨ̀ adré àyɨ kɨ tà kaꞌìkaꞌì nda nɨ tayɨ́ mbèlè. ");
INSERT INTO log_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Móndɨ́ àruka ɨ̀ adré Gìká nɨ kúlí kaꞌì ngóró kórɨ̀ rɨ̀le ledhélé kùtsí kòfalé nda ɨ tɨ́nɨ. Ɨ̀ kòyi kúlí nda dre dhɨ, ");
INSERT INTO log_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","tà bvò kòndɨ àdhya adrébhá àyɨ kɨ togó ꞌo lanzìle dhɨ ɨ, ngá lovó adrélépi àyɨ kɨ lɨtɨ́ dhɨ, ɨ̀ndɨ̀ lovó kònzɨ twátwa dhɨ ɨ̀ adré fɨ̀le àyɨ kɨ togó na kúlí nda nɨ amó gò, dré adrézó lòꞌwa ꞌa ko. ");
INSERT INTO log_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Dɨ, móndɨ́ àruka ɨ̀ adré àyɨkya Gìká nɨ kúlí kaꞌì ngóró kórɨ̀ rɨ̀le ledhélé kìní dóro dri nda ɨ tɨ́nɨ. Àyɨ nda ɨ̀ kòyi kúlí nda dre dhɨ, ɨ̀ adré kaꞌìá gò, ɨ̀ dré adrézó lòꞌwa ꞌa dóro. Àlo nɨ adré lòꞌwa ꞌa nyadhɨ-àlo-drì-mudrí, àzya nɨ nyadhɨ-na, àzya nɨ kó nyadhɨ-nzi.» ");
INSERT INTO log_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yésu gò tàá àyɨ dré dhɨ: «À adré gà tsì tálà dhɨ bhàle lɨ̀drɨ́ zàna yà, kó ngalè lángá zàna yà dhɨ be? Tàdzí ko! À adré zakó dhɨ̀á bhàle zá kuru mɨ́sá drìna. ");
INSERT INTO log_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Tàko ko, à nɨ tà títí zùle zùzù dhɨ kɨ tadhá ngádra ꞌá. À nɨ kpà tà títí lùzu ró dhɨ kɨ ꞌo apfòle ngádra ꞌá. ");
INSERT INTO log_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Dhya ángùdhi adrélépi bíbhálé ɨ́be tà yìzo dhɨ kòyi!» ");
INSERT INTO log_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Gò tàá àyɨ dré dhɨ: «Lè mɨ̀ kàdré tà mɨ̀ dré adrélé yìle dhɨ kɨ kisù dóro! Mɨ̀ kàdré tà yi dóro dhɨ, Gìká nɨ àmɨ kɨ fe adrélé tà nda kɨ àndu ni dóro lavúlé. A nɨ ndɨ̀ndɨ̀ tà mɨ̀ dré nìle nda kɨ drì tɨmbà. ");
INSERT INTO log_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Tàko ko, dhya ángùdhi tà nìlepi bǐ dhɨ dré dhɨ, à nɨ tà dré nìle nda kɨ drì tɨmbà. Dɨ, dhya ángùdhi tà nìlepi ko dhɨ dré dhɨ, à nɨ ndɨ̀ndɨ̀ tà tsà dré nìle dhɨ nɨ tɨngá.» ");
INSERT INTO log_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yésu gò tàá dhɨ: «Gìká nɨ Òpɨ̀ sù ngóró kórɨ̀ dhya àlo dré rɨ̀le bvò dri dhɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Dhya nda kàdré ayílé ngátsi sè yà, kó ngalè kàdré ngàle kìtú sè yà dhɨ, kórɨ̀ nda adré apfòle mbàle, tágba dhya nda dré nìzoá ngalè tà nda adré ru ꞌo ngɨ́nɨ ya dhɨ ko dhɨ. ");
INSERT INTO log_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Bvò nda nɨ tàndɨ adré kórɨ̀ nda nɨ ꞌo adrélé lòꞌwa ꞌa dhɨ nɨ̀. Kórɨ̀ nda adré rè zyà apfòle mbɨ̀ ro gò, drì nɨ dré adrézó pfòle gò, dré adrézó lòꞌwa ꞌa. ");
INSERT INTO log_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Lòꞌwa nda ɨ̀ kòka dre dhɨ, dhya nda adré méngerè adó adrézó lwàá. Tàko ko, lókyá adrézó lòꞌwa nda kɨ akónà dhɨ kɨtswá dre.» ");
INSERT INTO log_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yésu gò tàá dhɨ: «Má nɨ kɨtswá Gìká nɨ Òpɨ̀ nɨ tà tadhá àdho ngá rú? Kó ngalè, má nɨ tà nɨ nɨ tadhá kúlí alaala ángùdhi sè? ");
INSERT INTO log_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Òpɨ̀ nda sù ngóró mùtádì lòꞌwa tɨ́nɨ. Lòꞌwa nda konyókonyó mvá lavúlé lòꞌwa àruka títí adrélé rɨ̀le bvò dri dhɨ ɨ rúsè. ");
INSERT INTO log_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Dɨ, à kàdré lòꞌwa nda nɨ rɨ dhɨ, adré ɨ́na apfòle mbàle atsálé kàdrɨ̀ ngá àruka títí adrélé kidhílé amvú ꞌá dhɨ kɨ lavú. Adré mbàle áyɨ kólá kɨ lebhé ɨ́ rúsè kàdrɨ̀kàdrɨ̀ gò, àrɨ́ ɨ̀ dré adrézó bhà si drìlána lɨ́ndrɨ́ nɨ nɨ tà sè.» ");
INSERT INTO log_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Dɨ Yésu adré tá Gìká nɨ kúlí tadhá àyɨ dré kúlí alaala bǐ làsú be kònɨ̀nɨ dhɨ ɨ sè, tsàle ɨ̀ dré kɨtswázó tà nda kɨ àndu ni bwà ko dhɨ na. ");
INSERT INTO log_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Adré tá tà àlo tadhá àyɨ dré kúlí alaala àko dhɨ ko. Dɨ, ɨ̀ dré adréràꞌa lebèbhá nɨ ɨ́be àyɨ pátí dhɨ ꞌá dhɨ, adré tá ɨ́na tà títí nda kɨ àndu ngɨ àyɨ dré. ");
INSERT INTO log_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Kìtú nda nɨ ɨ̀ndró sè dhɨ, Yésu dré tàzoá áyɨ lebèbhá ɨ dré dhɨ: «Mà kòzya tä́pä́ríandre nɨ taꞌá na.» ");
INSERT INTO log_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Dɨ akódhɨ nɨ lebèbhá nda ɨ̀ kòtombà bwátù dré tá adrézó lána dhɨ na dre dhɨ, ɨ̀ dré móndyá zyandre nda kɨ tayɨ́zó gò, kɨdhózó adrélé zyàle taꞌá na. Bwátù àruka ɨ̀ adré tá kpà zyàle túmä́ní àyɨ ɨ́be. ");
INSERT INTO log_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Gbǎ kòdhwa, lyǎandre gú dhɨ dré ngàzo adrélé vìle tä́pä́ríandre nda mi. Yǐ adrélépi longálé dhɨ dré adrézó lodàle bwátù na gò, bwátù nda dré adrézó ꞌòle arɨ́lé. ");
INSERT INTO log_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Dɨ, Yésu adré tá ɨ́na ayí ko àmvòràmvò kùsé dri. Gò akódhɨ nɨ lebèbhá nda ɨ̀ dré akódhɨ nɨ torózó, tàzoá drá dhɨ: «Tadhálépi, mà adré dràle! Tà nda tsì tà tàko ꞌɨ mɨ́ dré?» ");
INSERT INTO log_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Dɨ Yésu dré ngàzo lɨgɨ́lé lyǎandre nda dri, tàzoá tä́pä́ríandre nda dré dhɨ: «Mɨ́ kɨkɨ́ mɨ adrélé kɨ́rɨ!» Lyǎandre nda dré rɨ̀zo adrélé kɨ́rɨ gò, ngá dré gòzo bhùle ndiii. ");
INSERT INTO log_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Dɨ Yésu dré tàzoá áyɨ lebèbhá ɨ dré dhɨ: «Mɨ̀ adré ngá ro àdho tà sè? Àmɨ dhu rè tà kaꞌìkaꞌì àko?» ");
INSERT INTO log_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Tirì dré gàzo àyɨ léna bǐ gò, ɨ̀ dré adrézó lizíá àyɨ kòfalésè dhɨ: «Dhya kòndɨ tá ɨ́na àdhi ꞌɨ, ndɨ̀ndɨ̀ lyǎandre ɨ tä́pä́ríandre be dhɨ ɨ̀ dré adrézó akódhɨ nɨ kúlí kaꞌì ꞌòle nɨ?» ");
INSERT INTO log_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ɨ̀ kòzya tä́pä́ríandre nda nɨ taꞌá na dre dhɨ, ɨ̀ dré tsàzo bvò Gèrásà kya na. ");
INSERT INTO log_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yésu kàsí bwátù lésè dre dhɨ, agó àlo tɨrɨ́ kònzɨ ɨ́be ɨ́ léna dhɨ dré apfòzo ngbǒ ró mógó lésè kɨtswálé ru kisú akódhɨ be. ");
INSERT INTO log_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Agó nda adré tá ɨ́na ayílé mógó ꞌásè. Dhya àlo kɨtswá tá vélé akódhɨ nɨ ru ꞌɨ̀le ndɨ̀ndɨ̀ nyɨ̀rɨ̀ sè bwà ko. ");
INSERT INTO log_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Tàko ko, vésè be bǐ, à adré tá akódhɨ nɨ pá kɨ tɨꞌɨ̀ kómvè sè, adrézó akódhɨ nɨ drɨ́gá kɨ tɨꞌɨ̀ nyɨ̀rɨ̀ sè. Dɨ, akódhɨ adré tá ɨ́na nyɨ̀rɨ̀ nda kɨ tɨkɨ́, adrézó kómvè nda kɨ toŋò. Dhya àlo kɨtswálépi akódhɨ nɨ bha áyɨ rìnyí zàle bwà dhɨ tá yókódhó. ");
INSERT INTO log_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Kìtú sè ɨ̀ndɨ̀ ngátsi sè dhɨ, akódhɨ adré tá tatsílé tetrébe mógó ꞌásè ɨ̀ndɨ̀ kòngó ɨ drǐsè, adrézó áyɨ rúbhá tɨsɨ̀ kɨ́rà sè. ");
INSERT INTO log_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Dɨ akódhɨ kònò Yésu vwàvwà ro dre dhɨ, dré ngàzo arálé adhélé áyɨ kórókó titì akódhɨ kandrá. ");
INSERT INTO log_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Dré yòzoá kúlí ꞌuꞌù sè dhɨ: «Yésu, Gìká kurú na dhɨ nɨ Mváagó, àma kòfalésè mɨ́ be dhɨ, àdho tà ꞌɨ? Má adré ámɨ ti lizí Gìká nɨ rú sè, mɨ́ kòꞌoró ma kònzɨ ko!» ");
INSERT INTO log_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Tà tá kònɨ̀nɨ tàko ko, Yésu tà tá drá dhɨ: «Tɨrɨ́ kònzɨ, mɨ́ pfò agó kònɨ̀dhɨ lésè!» ");
INSERT INTO log_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Gò Yésu dré lizízóá tíá dhɨ: «Ámɨ rú àdhi?» Akódhɨ logó drá dhɨ: «Áma rú ‹Zyandre›. Àngyá ko, àma agó kòndɨ léna dhɨ bǐ.» ");
INSERT INTO log_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Dɨ tɨrɨ́ kònzɨ nda dré dhèzo adrélé ngòle Yésu rú, kòmùró àyɨ pfòle bvò nda ꞌásè ko dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Àyɨ làgana kònànɨ dhɨ, tɨ̀gá kɨ pä̀rí andre adré tá ngá nya kòngó drìna. ");
INSERT INTO log_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Dɨ tɨrɨ́ kònzɨ nda ɨ̀ dré Yésu nɨ ti lizízó tàzoá dhɨ: «Mɨ́ kòmù àma lɨ̀le tɨ̀gá kòna ɨ véna wà, mà kòtɨfɨ́ró àyɨ léna be dhɨ bvó.» ");
INSERT INTO log_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yésu dré kaꞌìzoá. Dɨ tɨrɨ́ kònzɨ nda ɨ̀ dré topfòzo agó nda lésè, lɨ̀le tɨfɨ́lé tɨ̀gá nda ɨ léna. Gò tɨ̀gá ànyɨ́ànyɨ ngùlù-rì nda ɨ̀ dré ndìzo títí kòngó nda nɨ gòlòko ꞌásè, ledhélé tä́pä́ríandre na, yǐ mvu gò, todràzo. ");
INSERT INTO log_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Gò tɨ̀gá nda kɨ lɨkɨ́bhá ɨ̀ dré ngàzo ràle tà lavúlépi nda nɨ rúbí longóbe bhàandre na ɨ̀ndɨ̀ gbàbhú ꞌásè. Dɨ móndɨ́ zyandre dhɨ ɨ̀ dré apfòzo tà nda nɨ no. ");
INSERT INTO log_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ɨ̀ kàtsá Yésu vélé dre dhɨ, ɨ̀ dré agó tá tɨrɨ́ kònzɨ zyandre ɨ́be ɨ́ léna nda nɨ nòzo adréràꞌa lɨrɨ́lé Yésu làga. Akódhɨ tá kɨ́tá ɨ́be ɨ́ rú, ɨ̀ndɨ̀ tà kisùkisù ɨ́be dóro. Dɨ tirì dré àyɨ kɨ ꞌòzo lavúlé. ");
INSERT INTO log_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Gò dhya tà nda kɨ nobhá mì sè dhɨ ɨ̀ dré tà atsábhá agó tá tɨrɨ́ kònzɨ ɨ́be nda rú, ɨ̀ndɨ̀ tɨ̀gá ɨ rú dhɨ kɨ tɨtɨ́zó àyɨ dré. ");
INSERT INTO log_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Dɨ àyɨ nda ɨ̀ dré ngàzo Yésu nɨ ti lizí, kòngaró àyɨ kɨ bvò ꞌásè be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yésu dré tá adréràꞌa mbàle bwátù na dhɨ ꞌá dhɨ, agó tá tɨrɨ́ kònzɨ ɨ́be ɨ́ léna nda dré akódhɨ nɨ ti lizízó, ɨ̀ kòlɨ̀ró túmä́ní. ");
INSERT INTO log_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Dɨ, Yésu dré akódhɨ nɨ logázó, tàzoá drá dhɨ: «Mɨ́ nzɨ mɨ́ bhàna, ámɨ súrú na. Mɨ́ tɨtɨ́ àyɨ dré tà títí Mírì dré ꞌòle mɨ́ dré dhɨ ɨ, ɨ̀ndɨ̀ akódhɨ bhà ámɨ kɨzà ngɨ́nɨ ya dhɨ.» ");
INSERT INTO log_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Dɨ agó nda dré ngàzo lɨ̀le tà títí Yésu dré ꞌòle ɨ́ dré dhɨ kɨ longóbe bhàandre zìle Mudrí dhɨ ɨ ꞌásè. Dɨ móndyá títí dhɨ ɨ̀ adré tá akódhɨ nɨ yi síbhálé be ngbo. ");
INSERT INTO log_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yésu kògò azyálé tä́pä́ríandre nda nɨ taꞌá lésè bwátù sè dre dhɨ, móndɨ́ zyandre lavúlé dhɨ ɨ̀ dré ru kɨmózó akódhɨ làgásè kúrú tä́pä́ríandre mìle. ");
INSERT INTO log_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Yúdà ànzɨ kɨ lɨ̀sámbò dzó nɨ kàdrɨ̀ kɨ àlo rú be Yàyírò dhɨ dré kpà atsázó kònàle. Dɨ kònò Yésu dre dhɨ, dré adhézó akódhɨ pá, ");
INSERT INTO log_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","akódhɨ nɨ ti lizí tà tàndɨ ró tàzoá dhɨ: «Áma zapi ànyɨ́ànyɨ dràdrà mìle. Mɨ́ alɨ̀ ámɨ drɨ́gá bha akódhɨ dri wà, kàdrɨ́ró adrélé lɨ́drɨ̀ be!» ");
INSERT INTO log_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Dɨ Yésu ɨ̀ dré ngàzo adrélé lɨ̀le akódhɨ be. Móndyá zyandre lavúlé nda ɨ̀ dré kpà adrézó akódhɨ nɨ lebè, adrézó àyɨ kɨ tri rúásà. ");
INSERT INTO log_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Dɨ àyɨ nda ɨ kòfalé dhɨ, tòkó àlo kàrɨ́ dré adrézó ràle rúásà kóná be mudrí-drì-rì dhɨ tá be. ");
INSERT INTO log_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Akódhɨ nda nya tá kɨzà lavúlé kódzó bǐ dhɨ ɨ drɨ́gá. Kɨzá tá ngá ɨ́ drɨ́gásè akɨ́lé títí wóyá. Dɨ, kàrɨ́ nda adré tá vélé ràle rúásà lɨ̀le drìdrì. ");
INSERT INTO log_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Dɨ kòyi Yésu nɨ tà dre dhɨ, dré lavúzó móndyá zyandre nda ɨ kòfalésè, atsálé ànyɨ Yésu àmvolésè gò, akódhɨ nɨ kɨ́tá ti tabè. ");
INSERT INTO log_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Àngyá ko, adré tá ɨ́na kisùá dhɨ: «Má kòtabè ngbà ꞌí akódhɨ nɨ kɨ́tá ti kòdhya dhɨ, má nɨ adrɨ́.» ");
INSERT INTO log_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Gbǎ kòdhwa, kàrɨ́ adrélépi ràle rúásà nda dré akɨ́zó gò, dré atógyàzoá ɨ́ rú dhɨ, ɨ́ adrɨ́ áyɨ kɨzà nda lésè dre. ");
INSERT INTO log_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Gbǎ lókyá nda sè dhɨ, Yésu dré kpà atógyàzoá ɨ́ rú dhɨ, rìnyí pfò tá ɨ́ lésè dre. Dré áyɨ alázó móndyá zyandre nda ɨ kòfalé gò, lizíá dhɨ: «Àdhi tabè kɨ́tá mána nɨ̀?» ");
INSERT INTO log_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Akódhɨ nɨ lebèbhá ɨ̀ logó drá dhɨ: «Mɨ́ nò zakó móndyá zyandre kònɨ ɨ adréràꞌa àyɨ kɨ tri mɨ́ rúsè dhɨ ꞌí! Mɨ́ adré dɨ lizíá dhɨ, ‹Àdhi tabè ma nɨ̀› ya dhɨ ngɨ́nɨ?» ");
INSERT INTO log_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Dɨ, Yésu dré gòzo vélé adrélé móndyá ɨ́ làgásè nda kɨ no, nìzoá ngalè àdhi ꞌo tà nda nɨ̀ ya dhɨ. ");
INSERT INTO log_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Tòkó nda kàtógyà tà atsálépi ɨ́ rú dhɨ dre dhɨ, dré alɨ̀zo lyabe tirì dré adhélé akódhɨ pá gò, tà ɨ́ dré ꞌòle nda nɨ ta drá ngádra ꞌá. ");
INSERT INTO log_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Dɨ Yésu dré tàzoá drá dhɨ: «Áma zapi, ámɨ tà kaꞌìkaꞌì tɨdrɨ́ mɨ dre. Mɨ́ lɨ̀ togó be kɨ̀drɨ́kɨ̀drɨ. Mɨ́ adrɨ́ kɨzà mɨ́na lésè dre.» ");
INSERT INTO log_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yésu dré rè dhu adréràꞌa tà ta dhɨ ꞌá dhɨ, móndɨ́ àruka angábhá Yàyírò, lɨ̀sámbò dzó nɨ kàdrɨ̀ nda bhàlésè dhɨ ɨ̀ dré atsázó tàá drá dhɨ: «Ámɨ zapi drà dre. Tà adrézó gòle dhya tà tadhálépi dhɨ nɨ lagù ásà dhɨ àdho tà ꞌɨ?» ");
INSERT INTO log_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Dɨ, Yésu dré ɨ́na kúlí nda nɨ kaꞌìzo yìle ko. Gò dré tàzoá Yàyírò dré dhɨ: «Mɨ́ ro ngá ko. Mɨ́ kòkaꞌì ngbà ꞌí kaꞌìkaꞌì.» ");
INSERT INTO log_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Dɨ dré móndɨ́ àzya kaꞌìzo lɨ̀le ɨ́ vésè ko, kaꞌì ngbà ꞌí Pétèró, Yàkóbhò, tsàle adrúpi nɨ Yòwánɨ̀ be dhɨ ɨ kòdhya. ");
INSERT INTO log_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ɨ̀ kòtsa Yàyírò bhàna dre dhɨ, Yésu dré nòzoá dhɨ, móndyá títí dhɨ kɨ drì abɨ́abɨ́ gò, ɨ̀ dré adrézó àwó ngo, adrézó tongólé lúlǔ be. ");
INSERT INTO log_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Dɨ kòfɨ dzó nda na dre dhɨ, dré tàzoá àyɨ dré dhɨ: «Àmɨ kɨ drì abɨ́abɨ́ gò, mɨ̀ dré adrézó àwó ngo àdho tà sè? Mvámvá kòdhɨ drà ko. Adré ɨ́na ayí ko.» ");
INSERT INTO log_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Gò ɨ̀ dré dhèzo adrélé akódhɨ nɨ gu. Dɨ Yésu dré àyɨ kɨ ꞌòzo pfòle títí kɨvɨ̀ na. Dré mvámvá nda nɨ atá kɨ drìzo andre nɨ ɨ́be, ɨ̀ndɨ̀ áyɨ lebèbhá na nda ɨ́be gò, fɨ̀zo àyɨ ɨ́be àrà mvámvá nda dré adrézó dhɨ na. ");
INSERT INTO log_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Dré akódhɨ nɨ drɨ́gá rùzo, tàzoá drá dhɨ: «Tàlítà kúmì!» (Kòdhɨ adré lèá tàle dhɨ: «Mvátòkó, má tà mɨ́ dré dhɨ, mɨ́ nga!») ");
INSERT INTO log_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Gbǎ kòdhwa, mvátòkó adrélépi tá kóná ɨ́be mudrí-drì-rì nda dré ngàzo kɨdhólé atsí to. Dɨ àyɨ kɨ lɨ́ndrɨ́ dré gàzo bhwǎbhwa. ");
INSERT INTO log_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Gò Yésu dré àyɨ kɨ kodzózó tà tàndɨ ró tàzoá dhɨ, ɨ̀ kòlongó tà nda dhya àlo dré ko. Dré tàzoá dhɨ, ɨ̀ kòfè ngá mvámvá nda dré nyàle. ");
INSERT INTO log_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yésu kòtayɨ́ àrà nda dre dhɨ, dré lɨ̀zo tsàle bhàandre ɨ́ dré tá mbàzo lána dhɨ na. Akódhɨ nɨ lebèbhá ɨ̀ lɨ̀ tá kpà túmä́ní akódhɨ be. ");
INSERT INTO log_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sàbátù kàtsá dre dhɨ, dré kɨdhózó adrélé tà tadhá Yúdà ànzɨ kɨ lɨ̀sámbò dzó na. Gò móndyá zyandre nda ɨ̀ dré adrézó akódhɨ nɨ yi síbhálé be ngbo, adrézó lizíá àyɨ kòfalésè dhɨ: «Dhya kòndɨ kisú ɨ́na tà kòdhɨ ɨ ángwà? Tògyá fèle drá kònɨ̀nɨ nɨ̀ àdho tògyá ꞌɨ? Kisú kpà rìnyí adrézó tà lɨ́ndrɨ́ga ró dhɨ kɨ ꞌo áyɨ tàndɨ nɨ drɨ́gá sè dhɨ ángwà? ");
INSERT INTO log_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Akódhɨ kòndɨ tsì dhya adrélépi fa ledé dhɨ ꞌɨ ko? Akódhɨ tsì Màrɨ́yà nɨ mvá ꞌɨ ko? Adrúpi nɨ ɨ tsì Yàkóbhò, Yósè, Yúdà tsàle Sìmónà ko? Amvúpi nɨ ɨ àma kòfalé ko?» Dɨ tà nda sè dhɨ, ɨ̀ kɨtswá tá Yésu nɨ kaꞌì bwà ko. ");
INSERT INTO log_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Dɨ Yésu dré tàzoá àyɨ dré dhɨ: «À adré ngbà ꞌí pròfétà nɨ lɨndrɨ̀ bha ko dhɨ akódhɨ nɨ tàndɨ bha, akódhɨ nɨ súrú ꞌá, ɨ̀ndɨ̀ akódhɨ nɨ dzó ꞌá.» ");
INSERT INTO log_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Dɨ akódhɨ kɨtswá tá tà àzya lɨ́ndrɨ́ga ró dhɨ nɨ ꞌo kònàle ko, bhà ngbà ꞌí áyɨ drɨ́gá dràbhá àruka ɨ dri, àyɨ kɨ tɨdrɨ́zó dhɨ kòdhya. ");
INSERT INTO log_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Dɨ akódhɨ nɨ lɨ́ndrɨ́ adré tá gàle, ɨ̀ dré tá adrélé tà kaꞌìkaꞌì àko dhɨ sè. Àmvolásà dhɨ, Yésu dré ngàzo adrélé tatsílé tà tadhábe bhà àlo àlo títí bvò nda lé dhɨ ɨ ꞌásè. ");
INSERT INTO log_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Dré áyɨ lebèbhá mudrí-drì-rì dhɨ kɨ azízó, rìnyí fèzo àyɨ dré kɨtswázó tɨrɨ́ kònzɨ kɨ bha àyɨ pálé gò, dré kɨdhózó àyɨ kɨ tibhù lɨ̀le rì rì àzí ꞌo. ");
INSERT INTO log_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Dré tá adréràꞌa àyɨ kɨ tibhù dhɨ ꞌá dhɨ, lazí tà àyɨ dri kònɨ̀nɨ: «Mɨ̀ do ngá àlo dhɨ atsí sè ko, ngbà ꞌí kùtù fa kòdhya. Mɨ̀ kòdo mápà ꞌɨ yà, kòmvò ꞌɨ yà, kó ngalè làfa ꞌɨ yà dhɨ àmɨ rú ko. ");
INSERT INTO log_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Mɨ̀ asó kámókà, dɨ, mɨ̀ kòdo kɨ́tá agá lésè dhɨ nɨ àzya ko. ");
INSERT INTO log_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Dzó ángùdhi mɨ̀ dré dra fɨ̀zo lána dhɨ, mɨ̀ kàdré ayílé kònàle tsàle kìtú mɨ̀ dré dra ngàzo bhà nda ꞌásè dhɨ tú. ");
INSERT INTO log_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Bhà ángùdhi dra àmɨ kɨ kaꞌìzo dòle lána dóro ko yà, kó ngalè àmɨ kɨ kúlí yìzo ko yà dhɨ na dhɨ, mɨ̀ kòpfò ꞌásà, ɨ̀ndɨ̀ mɨ̀ kòtowá tàpfulɨ́ndrɨ́ àmɨ pásè tadházóá dhɨ, mɨ̀ tayɨ́ àyɨ kɨ tà títí dre.» ");
INSERT INTO log_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Dɨ Yésu nɨ lebèbhá nda ɨ̀ dré ngàzo lɨ̀le longóába móndɨ́ ɨ dré dhɨ, ɨ̀ kòladzá àyɨ kɨ togó agòzo Gìká vélé. ");
INSERT INTO log_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ɨ̀ adré tá tɨrɨ́ kònzɨ bǐ dhɨ kɨ dro móndɨ́ ɨ lésè, adrézó dò da dràbhá bǐ dhɨ ɨ dri, adrézó àyɨ kɨ tɨdrɨ́. ");
INSERT INTO log_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Dɨ ópɨ́ Èródè dré tà nda kɨ rúbí yìzo. Tàko ko, Yésu nɨ rúbí laꞌú tá bvò nda ꞌásè títí. Móndɨ́ àruka ɨ̀ adré tá tàá dhɨ: «Yòwánɨ̀ Bàtísimò fèlepi angá ɨ́na dràdrà lésè nɨ̀! Ásà dhɨ, akódhɨ rìnyí ɨ́be adrézó tà lɨ́ndrɨ́ga ró dhɨ kɨ ꞌo.» ");
INSERT INTO log_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Àruka nɨ ɨ̀ adré tá tàá dhɨ: «Akódhɨ Èlɨ́yà ꞌɨ.» Àruka nɨ ɨ̀ adré kó tàá dhɨ: «Akódhɨ pròfétà ꞌɨ, ngóró pròfétà atú dhɨ kɨ àlo tɨ́nɨ.» ");
INSERT INTO log_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Dɨ, Èródè kòyi tà adrélé tàle nda ɨ dre dhɨ, dré ɨ́na tàzoá dhɨ: «Yòwánɨ̀ má dré drì ꞌòle lìle kòdhɨ angá ɨ́na dràdrà lésè nɨ̀.» ");
INSERT INTO log_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Tàko ko, Èródè nda ꞌo tá Yòwánɨ̀ rùle adròle, bhèle bǎdzó na dhɨ nɨ̀. ꞌO tá kònɨ̀nɨ áyɨ adrúpi Fìlípò nɨ tòkó, Èròdɨ́yà, ɨ́ dré tá dòle mòle tòko ró dhɨ nɨ tà sè. ");
INSERT INTO log_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Àngyá ko, Yòwánɨ̀ adré tá tàá Èródè dré dhɨ: «Kɨtswá mɨ́ dré adrézó ámɨ adrúpi nɨ tòkó ɨ́be dhɨ ko.» ");
INSERT INTO log_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ásà dhɨ, Èròdɨ́yà nda adré tá togó kònzɨ bha Yòwánɨ̀ rú. Adré tá akódhɨ nɨ le pfùle dràle, dɨ, kɨtswá tá ɨ́na tà ꞌo bwà ko. ");
INSERT INTO log_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Tàko ko, Èródè nì ɨ́na tàle dhɨ, Yòwánɨ̀ tá móndɨ́ gyǎgya ɨ̀ndɨ̀ lólo dhɨ ꞌɨ dhɨ be. Dɨ adré tá akódhɨ nɨ ro, adrézó sùle rúá. Adré tá kpà akódhɨ nɨ kúlí le yìle, tágba akódhɨ nɨ drì dré tá adrézó abɨ́lé tò kúlí nda ɨ sè dhɨ. ");
INSERT INTO log_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Dɨ, lókyá Èròdɨ́yà dré kɨtswázó tà ꞌo bwà dhɨ dré atsázó. Kìtú Èródè nɨ tìzo ásà dhɨ sè dhɨ, akódhɨ dré gwányá ꞌòzo áyɨ àzibhá kɨ kàdrɨ̀ ɨ dré, sòdá kɨ kàdrɨ̀ ɨ dré, ɨ̀ndɨ̀ móndɨ́ kàdrɨ̀ àruka Gàlìláyà àdhya ɨ dré. ");
INSERT INTO log_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Gò Èròdɨ́yà nɨ zapi dré apfòzo ngá to Èródè ɨ kandrá móndyá dré azílé gwányá nda lé dhɨ ɨ́be, àyɨ kɨ togó ꞌòzo kɨnɨ́lé tò. Dɨ ópɨ́ nda dré tàzoá mvátòkó nda dré dhɨ: «Mɨ́ zi ngá ángùdhi mɨ́ dré adrélé lèle dhɨ má tí, má kòfèró mɨ́ dré.» ");
INSERT INTO log_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Dré mòndrà sɨ̀zo tàzoá drá dhɨ: «Ngá ángùdhi mɨ́ dré dra zìle má tí dhɨ, má nɨ fèá mɨ́ dré, kàdré gba áma òpɨ̀ lanzɨ́lé ꞌa be rì dhɨ nɨ àlo ꞌɨ yà dhɨ.» ");
INSERT INTO log_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Gò mvátòkó nda dré pfòzo lizíá áyɨ andre tí dhɨ: «Má kòzi àdho ngá kòdhya ya?» Andre nɨ logó dhɨ: «Mɨ́ kòzi Yòwánɨ̀ Bàtísimò fèlepi nɨ drì kòdhya.» ");
INSERT INTO log_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Dɨ mvátòkó nda dré gòzo tsàle mbèlè ópɨ́ nda véna, tàá drá dhɨ: «Má lè mɨ́ kàfè má dré Yòwánɨ̀ Bàtísimò fèlepi nɨ drì kònwa sǎnɨ̀ na.» ");
INSERT INTO log_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Gò ópɨ́ nda nɨ togó dré kɨzà nyàzo lavúlé tà nda sè. Dɨ, mòndrà dré tá sɨ̀le móndyá azílé nda ɨ kandrá dhɨ ɨ sè dhɨ, lè ɨ́na tà zìle ɨ́ tí nda gàle ko. ");
INSERT INTO log_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Dré ndɨrɨ sòdá kɨ àlo mùzo lɨ̀le kɨtswálé Yòwánɨ̀ nɨ drì li, kògòró agòle ába be dhɨ bvó. Dɨ sòdá nda dré lɨ̀zo Yòwánɨ̀ nɨ drì li bǎdzó na gò, ");
INSERT INTO log_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","drì nda nɨ adózó sǎnɨ̀ na, alɨ̀zo fèá mvátòkó nda dré. Gò akódhɨ nda dré fèzoá áyɨ andre dré. ");
INSERT INTO log_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Dɨ Yòwánɨ̀ nɨ lebèbhá ɨ̀ kòyi tà nda dre dhɨ, ɨ̀ dré tsàzo akódhɨ nɨ àbvò do lɨ̀zo bhàá mógó na. ");
INSERT INTO log_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Àpóstolò Yésu dré tá tibhùle nda ɨ̀ kàgò dre dhɨ, ɨ̀ dré àyɨ kɨ kɨmózó akódhɨ làga, tà títí ɨ̀ dré ꞌòle ɨ̀ndɨ̀ tadhálé dhɨ kɨ tɨtɨ́ drá. ");
INSERT INTO log_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Gò Yésu dré tàzoá àyɨ dré dhɨ: «Mɨ̀ alɨ̀, mà kòlɨ̀ró àma pátí lovólé tsà àrà móndɨ́ àko dhɨ na.» Tà tá kònɨ̀nɨ tàko ko, móndɨ́ zyandre dhɨ ɨ̀ adré tá alɨ̀le, adrélé gòle gò, Yésu ɨ̀ dré ndɨ̀ndɨ̀ adrézó lókyá ngá nyàzo dhɨ ɨ́be ko. ");
INSERT INTO log_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ɨ̀ dré dɨ tombàzo bwátù na kɨtswálé lɨ̀le àyɨ pátí àrà móndɨ́ àko dhɨ na dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Dɨ, móndɨ́ bǐ àyɨ kɨ nobhá lɨ̌ràꞌa dhɨ ɨ̀ nì tá àrà ɨ̀ dré tá adrézó lɨ̀le lána dhɨ be. Gò móndɨ́ zyandre dhɨ ɨ̀ dré ngàzo bhàandre títí dhɨ ɨ lésè, ràle pá sè tsàle àrà nda na drìdrì Yésu ɨ kandrána. ");
INSERT INTO log_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Dɨ Yésu kàsí bwátù lésè dre dhɨ, dré móndyá zyandre lavúlé nda kɨ nòzo gò, kɨzà dòzo áyɨ togó na àyɨ kɨ tà sè. Tàko ko, àyɨ tá ngóró kábilígyà adrébhá àyɨ kɨ lɨkɨ́lépi àko dhɨ ɨ tɨ́nɨ. Dɨ dré kɨdhózó adrélé tà bǐ dhɨ kɨ tadhá àyɨ dré. ");
INSERT INTO log_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ɨ̀ndró kàndrɨ̀ dre dhɨ, akódhɨ nɨ lebèbhá ɨ̀ dré àyɨ kɨ kisízó ànyɨ akódhɨ làga, tàá drá dhɨ: «Kònɨ̀dhɨ àrà bhà àko dhɨ ꞌɨ, ɨ̀ndɨ̀ lókyá lavú dre. ");
INSERT INTO log_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Mɨ́ kòfè dɨ láti móndyá zyandre kònɨ ɨ dré lɨ̀zo mányàngá gɨ nyàle gbàbhú ꞌásè ɨ̀ndɨ̀ bhà àma làgásè dhɨ ɨ ꞌásè wà.» ");
INSERT INTO log_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Dɨ, Yésu logó àyɨ dré dhɨ: «Àmɨ kɨ tàndɨ, mɨ̀ fè ngá àyɨ dré nyàle dhɨ àmɨ.» Ɨ̀ gò tàá drá dhɨ: «Mà kòlɨ̀ tsì làfa lòꞌwa kámá-rì dhɨ kɨ kɨzá ngbà, mápà gɨ̀zo kɨtswálé fèle àyɨ títí dhɨ ɨ dré nyàle?» ");
INSERT INTO log_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Dɨ Yésu lizí àyɨ tí dhɨ: «Àmɨ mápà ɨ́be ángopɨ́? Mɨ̀ lɨ̀ nòá.» Ɨ̀ kòlɨ̀ nòá dre dhɨ, ɨ̀ dré tàzoá dhɨ: «Àma mápà ɨ́be nzi, ɨ̀ndɨ̀ kosyá ɨ́be rì.» ");
INSERT INTO log_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Dɨ Yésu dré tàzoá àyɨ dré dhɨ, ɨ̀ kòtukù móndyá títí nda ɨ lɨrɨ́lé mbɨ̀lɨ́drɨ̀ drǐsè. ");
INSERT INTO log_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Gò àyɨ nda ɨ̀ dré lɨrɨ́zó ngbungbu nyadhɨ-nzi, ɨ̀ndɨ̀ nyadhɨ-rì-drì-mudrí. ");
INSERT INTO log_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Dɨ Yésu kàdó mápà nzi nda ɨ kosyá rì nda ɨ́be dre dhɨ, dré mì tɨngázó kurú na bhù na, tà tanɨ zìzo Gìká tí ngá nda ɨ dri. Dré mápà nda kɨ toŋòzo lanzɨ́lé áyɨ lebèbhá ɨ dré, ɨ̀ kòlanzɨ́ró móndyá zyandre nda ɨ dré. Dré kpà kosyá rì nda kɨ lanzɨ́zó àyɨ títí dhɨ ɨ dré. ");
INSERT INTO log_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Dɨ àyɨ títí nda ɨ̀ dré nyàzoá pìzo. ");
INSERT INTO log_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Gò akódhɨ nɨ lebèbhá ɨ̀ dré mápà nda kɨ àmbí kosyá ɨ́be dhɨ kɨ lokózó gàle kánzɨ̀ mudrí-drì-rì dhɨ ɨ sè bǐbi. ");
INSERT INTO log_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Àgo ngá nda kɨ nyabhá dhɨ ɨ tá ngùlù-nzi. ");
INSERT INTO log_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Gbǎ lókyá nda sè dhɨ, Yésu dré áyɨ lebèbhá kɨ ꞌòzo lɨ̀le mbàle bwátù na, ɨ̀ kòzyaró drìdrì ɨ́ kandrána tä́pä́ríandre nɨ taꞌá na, Bètèsàyɨ́dà na. Tàko ko, lè tá rè zyà láti fèle móndyá zyandre nda ɨ dré lɨ̀zo ꞌíká. ");
INSERT INTO log_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Kòlazí àyɨ tí dre dhɨ, dré mbàzo kòngó àlo drìna kɨtswálé tà ta Gìká be. ");
INSERT INTO log_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ngá kàní dre dhɨ, Yésu nɨ lebèbhá ɨ tá bwátù na tä́pä́ríandre nda nɨ kɨ́tógá na. Dɨ, akódhɨ tá ɨ́na kalóma bvò dri. ");
INSERT INTO log_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Dré nòzoá dhɨ, áyɨ lebèbhá nda ɨ̀ adré tá ru lagù kápí sè kɨtswálé bwátù zɨ lɨ̀le drìdrì, lyǎandre dré adrélé vìle sɨ́nyà dri àyɨ rú dhɨ sè. Dɨ ngátsi kɨ́tógá àmvolésè dhɨ, dré ngàzo adrélé atsí to tä́pä́ríandre drǐsè, adrézó lɨ̀le áyɨ lebèbhá nda ɨ véna, adrélé ꞌòle àyɨ kɨ lavú. ");
INSERT INTO log_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ɨ̀ kònò akódhɨ adréràꞌa atsí to tä́pä́ríandre drǐsè dre dhɨ, ɨ̀ dré kisùzoá dhɨ, kòdhɨ tá móndɨ́ lɨ́ndrɨ́ ꞌɨ gò, ɨ̀ dré ngàzo tetrélé. ");
INSERT INTO log_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Tàko ko, àyɨ títí dhɨ ɨ̀ nò tá akódhɨ gò, tirì dré gàzo àyɨ léna bǐ. Dɨ, gbǎ kòdhwa, Yésu dré tàzoá àyɨ dré dhɨ: «Mɨ̀ tsɨ togó! Ma ꞌɨ. Mɨ̀ ro ngá ko!» ");
INSERT INTO log_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Dré mbàzo bwátù na àyɨ véna gò, lyǎandre nda dré rɨ̀zo adrélé kɨ́rɨ. Dɨ àyɨ kɨ lɨ́ndrɨ́ dré gàzo bhwǎbhwa. ");
INSERT INTO log_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Àngyá ko, tà lɨ́ndrɨ́ga ró Yésu dré ꞌòle mápà nɨ tà sè nda fɨ tá dhu rè àyɨ drìna ko, àyɨ kɨ togó dré tá adrélé tòmbátòmba dhɨ sè. ");
INSERT INTO log_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ɨ̀ kòzya tä́pä́ríandre nda nɨ taꞌá na dre dhɨ, ɨ̀ dré tsàzo bvò Gènèsàrétè àdhya na. ");
INSERT INTO log_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ɨ̀ dré tá adréràꞌa apfòle bwátù lésè dhɨ ꞌá dhɨ, móndyá kònàle dhɨ ɨ̀ dré ndɨrɨ Yésu nɨ nòzo nìle kyá. ");
INSERT INTO log_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Dɨ ɨ̀ dré ngàzo tatsílé bvò nda ꞌásè títí, adrélé dràbhá kɨ adó káꞌyá ɨ dri, adrézó alɨ̀le àyɨ ɨ́be àrà ángùdhi ɨ̀ dré yìzoá akódhɨ lána dhɨ lé. ");
INSERT INTO log_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Dɨ àrà títí Yésu dré adrézó lɨ̀le dhɨ ɨ ꞌásè dhɨ, gba kàdré bhàandre ꞌɨ yà, bhà ꞌɨ yà, kó ngalè gbàbhú ꞌɨ yà dhɨ, móndɨ́ ɨ̀ adré tá àyɨ kɨ dràbhá kɨ adó alɨ̀zo àyɨ ɨ́be àrà adrézó ngá lagɨ́ dhɨ ɨ ꞌásè. Dɨ ɨ̀ adré tá akódhɨ nɨ ti lizí, kòtayɨ́ró dràbhá nda ɨ adrélé ngbà ꞌí áyɨ kɨ́tá ti tabè kòdhya. Dɨ àyɨ títí adrébhá tabèá nda ɨ̀ adré tá adrɨ́lé. ");
INSERT INTO log_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Kìtú àlo dhɨ, Fàrìsáyò ɨ tátrɨ́trɨ́ kúlí tadhábhá àruka angábhá Yèrúsalémà lésè dhɨ ɨ̀ alɨ̀ tá ru kɨmó Yésu làga. ");
INSERT INTO log_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Gò ɨ̀ dré nòzoá dhɨ, akódhɨ nɨ lebèbhá kɨ àruka ɨ̀ adré tá ngá nya drɨ́gá be ndǐ ró. Kòdhɨ adré tàá dhɨ, ɨ̀ adré tá ngá nya drɨ́gá dzɨ àko ró. ");
INSERT INTO log_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Tàko ko, Fàrìsáyò ɨ Yúdà ànzɨ àruka títí dhɨ ɨ́be dhɨ, ɨ̀ adré rè ngbú àyɨ kɨ drɨ́gá dzɨ dóro ꞌíká, gò adrézó ngá nya ndò, ɨ̀ dré adrélé tròle àyɨ kɨ tábhí kɨ labhɨ ɨ rú dhɨ sè. ");
INSERT INTO log_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ɨ̀ kàdré nzɨ̀le àrà adrézó ngá lagɨ́ dhɨ lésè dhɨ, ɨ̀ adré ngbú àyɨ kɨ temvé yǐ sè ꞌíká, gò adrézó ngá nya ndò. Ɨ̀ adré kpà labhɨ àruka bǐ dhɨ kɨ lebè, adrézó kópò kɨ dzɨ lɨ̀drɨ́ ɨ́be ɨ̀ndɨ̀ sǎnɨ̀ ɨ́be.) ");
INSERT INTO log_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Dɨ Fàrìsáyò nda ɨ tátrɨ́trɨ́ kúlí tadhábhá nda ɨ́be dhɨ ɨ̀ dré lizízóá Yésu tí dhɨ: «Ámɨ lebèbhá ɨ̀ adré àma kɨ tábhí kɨ labhɨ lebè ko àdho tà sè? Tàko ko, ɨ̀ adré àyɨkya ngá nya drɨ́gá be ndǐ ró.» ");
INSERT INTO log_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yésu logó àyɨ dré dhɨ: «Pròfétà Èsáyà dré tá adréràꞌa Gìká nɨ kúlí longó àmɨ túrúpfúbhá ɨ ró nɨ kɨ tà sè dhɨ ꞌá dhɨ, longó tà nda kyá tàzoá dhɨ: ‹Móndyá kòdhɨ ɨ̀ adré áma lɨndrɨ̀ bha ngbà ꞌí ti sè. Dɨ, àyɨ kɨ togó vwà ɨ́na má rúsè vwàvwà. ");
INSERT INTO log_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ɨ̀ adré lɨ̀sámbò ꞌo má dré wóyá. Tàko ko, ɨ̀ adré tòlɨ́ angábhá móndɨ́ ɨ vélésè dhɨ kɨ tadhá ngóró tòlɨ́ nda ɨ̀ angá tá má vélésè na tɨ́nɨ.› ");
INSERT INTO log_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Mɨ̀ tayɨ́ àmɨkya tòlɨ́ Gìká àdhya ɨ, adrézó tròle labhɨ móndɨ́ kya ɨ rú.» ");
INSERT INTO log_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Gò tàá àyɨ dré dhɨ: «Mɨ̀ nì àmɨkya adrélé Gìká nɨ tòlɨ́ kɨ bhe gàrà dri, adrézó àmɨ kɨ tàndɨ kɨ labhɨ kɨ lɨkɨ́ dhɨ dóro. ");
INSERT INTO log_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Tàko ko, Mósè tà tá dhɨ: ‹Lè mɨ́ kàdré ámɨ atá nɨ lɨndrɨ̀ bha ámɨ andre be.› Tà kpà dhɨ: ‹Dhya adrélépi tà ta kònzɨ áyɨ atá rú yà, kó ngalè áyɨ andre rú yà dhɨ, lè à kòꞌo akódhɨ nda dràle dràdrà.› ");
INSERT INTO log_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Dɨ, mɨ̀ adré àmɨkya tàá dhɨ, dhya àlo nɨ kɨtswá tàá áyɨ atá dré yà, kó ngalè áyɨ andre dré yà dhɨ: ‹Ngá má dré tá kɨtswálé fèle ámɨ ledé dhɨ kòròbánɨ̀ ꞌɨ, kòdhɨ adré tàá dhɨ, ngá fèle Gìká dré dhɨ ꞌɨ.› ");
INSERT INTO log_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Akódhɨ nda kòtà kònɨ̀nɨ dhɨ, mɨ̀ adré dɨ vélé akódhɨ nɨ tayɨ́ tà ꞌo atá nɨ dré yà, kó ngalè andre nɨ dré yà dhɨ ko. ");
INSERT INTO log_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Dɨ ásà dhɨ, mɨ̀ adré àmɨkya Gìká nɨ kúlí bhe gàrà dri, àmɨ kɨ labhɨ mɨ̀ dré kisúlé àmɨ kɨ tábhí ɨ véna dhɨ kɨ tà sè. Mɨ̀ adré kpà tà bǐ dhɨ kɨ ꞌo kònɨ̀nɨ.» ");
INSERT INTO log_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Gò Yésu dré gòzo móndyá zyandre kònàle dhɨ kɨ azí, tàzoá àyɨ dré dhɨ: «Àmɨ títí, mɨ̀ yi vo rè tà kònɨ̀dhɨ, àndu nɨ nɨ nìzo ká! ");
INSERT INTO log_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ngá adrélépi fɨ̀le móndɨ́ léna dhɨ kɨtswá akódhɨ nɨ ꞌo atsálé ndǐ ró bwà ko. Be ró dhɨ, tà adrélépi apfòle móndɨ́ lésè dhɨ adré ɨ́na akódhɨ nɨ ꞌo atsálé ndǐ ró dhɨ nɨ̀.»  ");
INSERT INTO log_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yésu kòtayɨ́ móndyá zyandre nda ɨ dre dhɨ, dré nzɨ̀zo bhàna gò, akódhɨ nɨ lebèbhá ɨ̀ dré kúlí alaala nda nɨ àndu lizízó tíá. ");
INSERT INTO log_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Akódhɨ dré tàzoá àyɨ dré dhɨ: «Àmɨ, àmɨ kókpà tà nìnì àko? Mɨ̀ nì ko tàle dhɨ, ngá adrélépi fɨ̀le móndɨ́ léna dhɨ kɨtswá ɨ́na akódhɨ nɨ ꞌo atsálé ndǐ ró bwà ko dhɨ? ");
INSERT INTO log_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Tàko ko, ngá nda adré fɨ̀le akódhɨ nɨ togó na ko. Be ró dhɨ, adré ɨ́na fɨ̀le akódhɨ nɨ ꞌa na gò, adrélé apfòle akódhɨ nɨ rúbhá lésè.» (Kúlí nda kòdhɨ sè dhɨ, Yésu adré tá tàá dhɨ, mányàngá títí dhɨ ɨ dóro Gìká mìlésè.) ");
INSERT INTO log_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Yésu gò tàá dhɨ: «Tà adrélépi apfòle móndɨ́ nɨ togó lésè dhɨ ɨ́na tà adrélépi akódhɨ nɨ ꞌo atsálé ndǐ ró dhɨ ꞌɨ. ");
INSERT INTO log_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Tàko ko, tà adrébhá apfòle móndɨ́ kɨ togó lésè dhɨ ɨ, tà kònɨ ꞌɨ: tà kònzɨ kisùle dhɨ ɨ, ndòtò tà, kugù tà, móndɨ́ kɨ tupfuma nɨ tà, ");
INSERT INTO log_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","múná tà, ngá lovó nɨ tà, togó kònzɨ nɨ tà, móndɨ́ kɨ lɨtɨma nɨ tà, tà swà, lovó kònzɨ bhàma móndɨ́ ɨ rú dhɨ nɨ tà, móndɨ́ kɨ rú tàma kònzɨ dhɨ nɨ tà, drìkàdrɨ̀ nɨ tà, ɨ̀ndɨ̀ tà azaaza. ");
INSERT INTO log_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Tà kònzɨ nda kòdhɨ ɨ̀ adré títí apfòle móndɨ́ kɨ togó lésè gò, adrélé àyɨ kɨ ꞌo atsálé ndǐ ró.» ");
INSERT INTO log_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Àmvolásà dhɨ, Yésu dré àrà nda nɨ tayɨ́zó gò, lɨ̀zo tsàle bvò Tírè làga dhɨ na. Kònàle dhɨ, dré fɨ̀zo dzó àlo na lùzu ró. Lè tá à kònì ɨ kònàle dhɨ ko. Dɨ, kɨtswá tá ɨ́na tà nda nɨ zu móndɨ́ ɨ dré bwà ko. ");
INSERT INTO log_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Dɨ tòkó àlo zapi nɨ dré adrézó tɨrɨ́ kònzɨ ɨ́be ɨ́ léna dhɨ kòyi Yésu nɨ rúbí dre dhɨ, dré ndɨrɨ alɨ̀zo adhélé akódhɨ pá. ");
INSERT INTO log_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Tòkó nda tá ɨ́na móndɨ́ súrú twá ro tìle bvò Fòwìníkè àdhya Sìríyà le dhɨ na dhɨ ꞌɨ. Dɨ dré ngàzo adrélé Yésu nɨ ti lizí, kòdroró tɨrɨ́ kònzɨ nda áyɨ zapi lésè be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yésu dré tàzoá drá dhɨ: «Mɨ́ tayɨ́ rè zyà ànzɨmvá ɨ ngá nya pìzo ꞌíká. Tàko ko, kɨtswá ànzɨmvá kɨ mápà dòzo bhèle kòkɨ́ ɨ dré dhɨ ko.» ");
INSERT INTO log_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Dɨ, tòkó nda logó drá dhɨ: «Mírì, tágba kònɨ̀nɨ dhɨ, ndɨ̀ndɨ̀ kòkɨ́ mɨ́sá zàle dhɨ ɨ̀ adré àyɨkya mápà kórònyá ànzɨmvá ɨ̀ dré adrélé tayɨ́lé ledhélé dhɨ kɨ nya kòdhya.» ");
INSERT INTO log_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Dɨ Yésu tà drá dhɨ: «Kúlí mɨ́ dré logólé kòdhɨ sè dhɨ, mɨ́ kɨtswá nzɨ̀le. Tɨrɨ́ kònzɨ nda pfò ámɨ zapi lésè dre.» ");
INSERT INTO log_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Dɨ tòkó nda kònzɨ ɨ́ bhàna dre dhɨ, dré áyɨ zapi nda nɨ kisúzó adréràꞌa ayílé lángá dri. Tɨrɨ́ kònzɨ nda pfò tá lásà dre. ");
INSERT INTO log_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Àmvolásà dhɨ, Yésu dré bvò Tírè làga nda nɨ tayɨ́zó gò, lɨ̀zo lavúlé Sìdónà ꞌásè, ɨ̀ndɨ̀ bvò zìle bhàandre Mudrí ɨ ró dhɨ ꞌásè, gòle tsàle tä́pä́ríandre Gàlìláyà àdhya làgana. ");
INSERT INTO log_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Kònàle dhɨ, à dré agó àlo bíbhálé be kùdúkùdu ró adrélépi kpà ábhä́bhä́ ro dhɨ nɨ adzízó Yésu vélé, akódhɨ nɨ ti lizízó, kòbhàró drɨ́gá agó nda dri, akódhɨ nɨ tɨdrɨ́zó be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Dɨ Yésu dré akódhɨ nda nɨ drìzo lɨ̀zo ába gàrà dri móndɨ́ zyandre ɨ rúsè gò, áyɨ drɨ́gá ànzɨ kɨ sòzo akódhɨ bína. Dré tùsú fùzo áyɨ drɨ́gámbɨ́lɨ́ dri gò, akódhɨ nɨ làdra tabèzo ásà. ");
INSERT INTO log_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Dré mì tɨngázó kurú na bhù na gò, laꞌázó fèèè, tàzoá dhɨ: «Èfátà!» (Kòdhɨ adré lèá tàle dhɨ: «Mɨ́ nzì ru!») ");
INSERT INTO log_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Gbǎ kòdhwa, agó nda nɨ bíbhálé dré fùzo, akódhɨ nɨ làdra dré ru nzìzo gò, dré kɨdhózó adrélé tà ta dóro. ");
INSERT INTO log_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Gò Yésu dré móndyá kònàle dhɨ kɨ kodzózó tàzoá dhɨ, ɨ̀ kòlongó tà nda nɨ rúbí dhya àlo dré ko. Dɨ, kàdré vélé áyɨ rúbí nɨ longoma logá móndɨ́ ɨ dré dhɨ, ɨ̀ adré vélé rúbí nda nɨ longó lɨ̀zo ába drìdrì. ");
INSERT INTO log_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Dɨ móndɨ́ kɨ lɨ́ndrɨ́ adré tá vélé gàle bhwǎbhwa gò, ɨ̀ dré adrézó tàá dhɨ: «Tà títí akódhɨ dré adrélé ꞌòle dhɨ ɨ dóro! Adré ndɨ̀ndɨ̀ móndɨ́ bíbhálé be kùdúkùdu ró dhɨ kɨ ꞌo adrélé tà yi, ɨ̀ndɨ̀ móndɨ́ ábhä́bhä́ ro dhɨ kɨ ꞌo adrélé tà ta.» ");
INSERT INTO log_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Àmvolásà dhɨ, móndɨ́ zyandre lavúlé dhɨ ɨ̀ dré gòzo ru kɨmó Yésu làga. Àyɨ nda ɨ̀ dré tá adrélé ngá nyàle dhɨ àko dhɨ sè dhɨ, Yésu dré áyɨ lebèbhá kɨ azízó, tàzoá àyɨ dré dhɨ: ");
INSERT INTO log_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Má adré kɨzà do áma togó na móndyá zyandre kònɨ kɨ tà sè. Tàko ko, àma túmä́ní àyɨ ɨ́be kìtú na, ɨ̀ndɨ̀ ngá ɨ̀ dré kɨtswálé nyàle dhɨ vélé yókódhó. ");
INSERT INTO log_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Má kòlogó àyɨ nzɨ̀le bhàna tàbirí be dhɨ, ɨ̀ nɨ landè ledhézó láti bhálé. Àngyá ko, àyɨ kɨ àruka ɨ̀ angá làwú làvo lésè.» ");
INSERT INTO log_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Dɨ akódhɨ nɨ lebèbhá ɨ̀ logó drá dhɨ: «Àrà bhà àko kònɨ̀dhɨ ꞌá dhɨ, à nɨ kɨtswá mápà kisú fèle àyɨ dré nyàle pìzo ásà dhɨ ángwà?» ");
INSERT INTO log_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yésu lizí àyɨ tí dhɨ: «Àmɨ mápà ɨ́be ángopɨ́?» Ɨ̀ logó dhɨ: «Nzi-drì-rì.» ");
INSERT INTO log_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Gò Yésu dré tàzoá móndyá zyandre nda ɨ dré dhɨ, ɨ̀ kòlɨrɨ́ bvò dri. Dɨ kàdó mápà nzi-drì-rì nda ɨ dre dhɨ, dré àwoyà fèzo Gìká dré gò, toŋòzoá lanzɨ́lé áyɨ lebèbhá ɨ dré gò, ɨ̀ dré lanzɨ́zóá móndyá zyandre nda ɨ dré. ");
INSERT INTO log_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Àyɨ tá kpà kosyá àruka tsàtsà dhɨ ɨ́be. Dɨ Yésu dré kpà tà tanɨ zìzo Gìká tí kosyá nda ɨ dri gò, tàzoá áyɨ lebèbhá ɨ dré dhɨ, ɨ̀ kòlanzɨ́ móndyá nda ɨ dré. ");
INSERT INTO log_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Dɨ móndyá títí nda ɨ̀ dré ngá nda kɨ nyàzo pìzo. Gò akódhɨ nɨ lebèbhá ɨ̀ dré àmbí nɨ kɨ lokózó gàle kánzɨ̀ nzi-drì-rì dhɨ ɨ sè bǐbi. ");
INSERT INTO log_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Móndyá ngá nyabhá nda ɨ tá ànyɨ́ànyɨ ngùlù-su. Gò Yésu dré láti fèzo àyɨ dré nzɨ̀zo. ");
INSERT INTO log_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Gbǎ lókyá nda sè dhɨ, Yésu ɨ̀ dré tombàzo bwátù na lebèbhá nɨ ɨ́be gò, ɨ̀ dré lɨ̀zo tsàle bvò Dàlàmànútà àdhya na. ");
INSERT INTO log_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Gò Fàrìsáyò ɨ̀ dré alɨ̀zo Yésu vélé, adrélé tà kayí akódhɨ be. Ɨ̀ adré tá akódhɨ nɨ le tabhìle gò, ɨ̀ dré akódhɨ nɨ ti lizízó, kòꞌoró tà àlo lɨ́ndrɨ́ga ró angálépi Gìká vélésè dhɨ. ");
INSERT INTO log_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Dɨ Yésu dré ngàzo laꞌálé fèèè gò, tàzoá dhɨ: «Móndyá ándrò kònɨ ɨ̀ adré tà lɨ́ndrɨ́ga ró dhɨ nɨ nda nòle àdho tà sè? Má adré tà bàti ta àmɨ dré: À kɨtswá tà àlo lɨ́ndrɨ́ga ró dhɨ nɨ ꞌo àyɨ dré nòle dhɨ ko.» ");
INSERT INTO log_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Gò dré àyɨ kɨ tayɨ́zó, gòzo mbàle bwátù na kɨtswálé zyàle tä́pä́ríandre nɨ taꞌá na. ");
INSERT INTO log_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Dɨ Yésu nɨ lebèbhá ɨ̀ tɨvɨ̀ tá mápà dòma atsí na dhɨ. Àyɨ tá ngbà ꞌí mápà ɨ́be àlo bwátù na. ");
INSERT INTO log_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Gò Yésu dré àyɨ kɨ kodzózó tàzoá dhɨ: «Mɨ̀ kònò dóro, mɨ̀ kàdréró àmɨ kɨ lɨkɨ́ tàkú Fàrìsáyò kya ɨ̀ndɨ̀ Èródè àdhya kɨ tà sè.» ");
INSERT INTO log_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Dɨ akódhɨ nɨ lebèbhá ɨ̀ dré ngàzo adrélé tà kayí àyɨ kòfalésè adrézó tàá dhɨ, akódhɨ tà tá kònɨ̀nɨ ɨ̀ dré tá adrélé mápà àko dhɨ sè. ");
INSERT INTO log_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yésu dré tà ɨ̀ dré adrélé tàle nda nɨ nìzo kyá gò, tàzoá àyɨ dré dhɨ: «Mɨ̀ adré àmɨkya tà kayí mɨ̀ dré adrélé mápà àko dhɨ sè àdho tà sè? Mɨ̀ atógyà dhu rè àmɨkya tà àlo ko? Mɨ̀ nì dhu rè tà àlo ko? Àmɨ kɨ togó tsì tòmbátòmba bàti? ");
INSERT INTO log_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Àmɨ mì ɨ́be gò, mɨ̀ dré adrézó ngá no ko? Àmɨ bíbhálé ɨ́be gò, mɨ̀ dré adrézó tà yi ko? Mɨ̀ tɨvɨ̀ vo tà má dré ꞌòle dhɨ ɨ dre? ");
INSERT INTO log_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Má dré tá mápà nzi dhɨ kɨ toŋòzo lanzɨ́lé móndyá ngùlù-nzi dhɨ ɨ dré dhɨ, mɨ̀ gò àmbí nɨ kɨ lokó gàle kánzɨ̀ ángopɨ́?» Ɨ̀ logó drá dhɨ: «Mudrí-drì-rì.» ");
INSERT INTO log_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Yésu gò lizíá dhɨ: «Má dré tá kó mápà nzi-drì-rì dhɨ kɨ toŋòzo lanzɨ́lé móndyá ngùlù-su dhɨ ɨ dré dhɨ, mɨ̀ gò àmbí nɨ kɨ lokó gàle kánzɨ̀ ángopɨ́?» Ɨ̀ logó dhɨ: «Nzi-drì-rì.» ");
INSERT INTO log_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Dɨ Yésu dré tàzoá àyɨ dré dhɨ: «Mɨ̀ nì vo dhu rè tà àlo ko?» ");
INSERT INTO log_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Àmvolásà dhɨ, ɨ̀ dré lɨ̀zo tsàle bhàandre rú zìle Bètèsàyɨ́dà dhɨ na. Kònàle dhɨ, à dré agó àlo mì kùdúkùdu ró dhɨ nɨ adzízó Yésu vélé, akódhɨ nɨ ti lizízó, kòtabèró agó nda, akódhɨ nɨ tɨdrɨ́zó be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Dɨ Yésu dré mì kùdúkùdu nda nɨ drɨ́gá rùzo, akódhɨ nɨ sèzo pfòzo ába bhà nda ꞌásè kɨvɨ̀ na. Dré tùsú fùzo akódhɨ mi, drɨ́gá bhàzo drìá gò, akódhɨ nɨ lizízó tàzoá dhɨ: «Mɨ́ adré ngá no?» ");
INSERT INTO log_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Agó nda dré mì bhèzo gò, tàzoá dhɨ: «Má adré móndɨ́ kɨ no ngóró fa ɨ tɨ́nɨ, dɨ, ɨ̀ adré atsí to.» ");
INSERT INTO log_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yésu dré gòzo tódhyá áyɨ drɨ́gá bha agó nda mi. Dɨ akódhɨ nda dré gòzo mì nzi kàdrɨ̀ gò, mì nɨ dré adrɨ́zó adrélé ngá títí dhɨ kɨ no dóro. ");
INSERT INTO log_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Gò Yésu dré akódhɨ nɨ logózó nzɨ̀le bhàna, tàzoá drá dhɨ: «Mɨ́ kògò fɨ̀le bhà kòdhɨ na ko.» ");
INSERT INTO log_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Àmvolásà dhɨ, Yésu ɨ lebèbhá nɨ ɨ́be dhɨ ɨ̀ dré ngàzo adrélé lavúlé bhà tsàtsà bhàandre Kàyìsàríyà Fìlípò àdhya làgásè dhɨ ɨ ꞌásè. Láti ꞌá dhɨ, akódhɨ dré lizízóá àyɨ tí dhɨ: «Móndɨ́ ɨ̀ adré tàá dhɨ, ma àdhi ꞌɨ?» ");
INSERT INTO log_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ɨ̀ logó drá dhɨ: «Móndɨ́ àruka ɨ̀ adré tàá dhɨ, mɨ Yòwánɨ̀ Bàtísimò fèlepi ꞌɨ. Àruka nɨ ɨ̀ adré tàá dhɨ, mɨ Èlɨ́yà ꞌɨ. Àruka nɨ ɨ̀ adré kó tàá dhɨ, mɨ pròfétà kɨ àlo ꞌɨ.» ");
INSERT INTO log_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yésu gò lizíá àyɨ tí dhɨ: «Dɨ àmɨ ró dhɨ, mɨ̀ adré àmɨkya tàá dhɨ, ma àdhi ꞌɨ?» Pétèró gò logóá drá dhɨ: «Mɨ mɨ́na Mèsɨ́yà ꞌɨ.» ");
INSERT INTO log_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Gò Yésu dré àyɨ kɨ logázó, ɨ̀ kòlongóró tà nda dhya àlo dré ko. ");
INSERT INTO log_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Gò Yésu dré kɨdhózó adrélé tadhá àyɨ dré dhɨ, adré tá lèá dhɨ, Móndɨ́ nɨ Mvá kònya kɨzà lavúlé, ɨ̀ndɨ̀ Yúdà ànzɨ kɨ bhàgo ɨ, kòwánà kàdrɨ̀ ɨ, ɨ̀ndɨ̀ tátrɨ́trɨ́ kúlí tadhábhá ɨ́be dhɨ ɨ̀ kògà akódhɨ rè. Adré tá kpà lèá dhɨ, à kòpfu akódhɨ dràle gò, kìtú na àmvolésè dhɨ, kòngaró dràdrà ꞌásè. ");
INSERT INTO log_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yésu adré tá tà nda nɨ ta àyɨ dré ngádra ꞌá. Dɨ Pétèró dré akódhɨ nɨ drìzo gàrà dri gò, kɨdhózó adrélé tà ta akódhɨ dri tà nda sè. ");
INSERT INTO log_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Dɨ, Yésu dré áyɨ alázó áyɨ lebèbhá kɨ no gò, lawàzo Pétèró dri tàzoá drá dhɨ: «Sàtánà, mɨ́ nga má mìlésè gòle má àmvona! Mɨ́ adré tà kisù Gìká àdhya tɨ́nɨ ko. Be ró dhɨ, mɨ́ adré mɨ́na tà kisù móndɨ́ kya tɨ́nɨ.» ");
INSERT INTO log_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Gò Yésu dré móndyá zyandre kònàle dhɨ kɨ azízó áyɨ lebèbhá ɨ́be, tàzoá àyɨ dré dhɨ: «Dhya àlo kàdré lèá alɨ̀le má vésè dhɨ, lè akódhɨ nda kòtayɨ́ áyɨ tàndɨ nɨ tà, kàdó áyɨ fa kɨpakɨpa gò, kàdréró áma lebè. ");
INSERT INTO log_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Tàko ko, dhya ángùdhi adrélépi áyɨ tàndɨ nɨ lɨ́drɨ̀ le tɨdrɨ́lé dhɨ, a nɨ áyɨ lɨ́drɨ̀ nda nɨ ꞌo avɨ̀le. Dɨ, dhya ángùdhi adrélépi ɨ́na áyɨ lɨ́drɨ̀ fe áma tà sè ɨ̀ndɨ̀ Rúbí Tanɨ nɨ tà sè dhɨ, a nɨ áyɨ lɨ́drɨ̀ nda nɨ tɨdrɨ́. ");
INSERT INTO log_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Àngyá ko, dhya àlo kòkisú ngá bvò kòndɨ àdhya ɨ títí gò, áyɨ tàndɨ nɨ lɨ́drɨ̀ tayɨ́zó avɨ̀le dhɨ, akódhɨ nda kisú ɨ́na àdho tà dóro ꞌɨ? ");
INSERT INTO log_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","A nɨ go àdho ngá fe kòdhya kɨtswázó áyɨ lɨ́drɨ̀ nda nɨ kisú dhɨ? ");
INSERT INTO log_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Dhya àlo kàdré kanyò ro áma tà sè ɨ̀ndɨ̀ áma kúlí kɨ tà sè móndyá ándrò zàràbhù ro ɨ̀ndɨ̀ tàkonzɨ̀bhá ro nɨ ɨ kòfalé dhɨ, Móndɨ́ nɨ Mvá nɨ kókpà adré kanyò ro akódhɨ nda nɨ tà sè, lókyá ɨ́ dré dra agòzo áyɨ Atá nɨ mìlanzìlanzì na ángéló lólo dhɨ ɨ́be dhɨ tú.» ");
INSERT INTO log_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yésu gò tàá àyɨ dré dhɨ: «Má adré tà bàti ta àmɨ dré: Móndɨ́ àruka adrébhá àyɨ kɨ totó kònwa nɨ ɨ̀ kɨtswá dràle drìdrì ɨ̀ dré dra Gìká nɨ Òpɨ̀ nòzo atsáràꞌa rìnyí be dhɨ kandrá ko.» ");
INSERT INTO log_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Kìtú nzi-drì-àlo àmvolésè dhɨ, Yésu dré Pétèró kɨ drìzo Yàkóbhò ɨ́be ɨ̀ndɨ̀ Yòwánɨ̀ be gò, ɨ̀ dré lɨ̀zo àyɨ pátí mbàle kòngó àlo mvumvù dhɨ drìna. Kònàle dhɨ, Yésu nɨ làsú dré ngàzo ru ladzá àyɨ mìle. ");
INSERT INTO log_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Akódhɨ nɨ kɨ́tá ɨ̀ dré kpà atsázó kemve kpɨ́rɨ́kpɨ́rɨ́, adrélé lagúlé kɨ́tá móndɨ́ bvò dri dhɨ ɨ̀ dré kɨtswálé temvélé bwà dhɨ kya nɨ lavú. ");
INSERT INTO log_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Gò Èlɨ́yà ɨ Mósè be dhɨ ɨ̀ dré agázó àyɨ kandrá, adrélé tà ta Yésu be. ");
INSERT INTO log_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Dɨ Pétèró dré tàzoá Yésu dré dhɨ: «Rábbì, dóro nɨ mà dré adrélé kònwa dhɨ. Mà kòledé wémà na dhɨ ɨ kònwa: àlo nɨ mɨ́ dré, àlo nɨ Mósè dré, ɨ̀ndɨ̀ àlo nɨ Èlɨ́yà dré.» ");
INSERT INTO log_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Akódhɨ tà tá kònɨ̀nɨ, dré tá nìle ɨ́ kɨtswá àdho tà ta kòdhya ya dhɨ ko dhɨ sè. Tàko ko, tirì ga tá àyɨ léna bǐ.) ");
INSERT INTO log_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Gò ndùrùku dré apfòzo àyɨ kɨ asó rùkù gò, kúlí dré apfòzo lásà tàá dhɨ: «Kònɨ̀dhɨ áma Mváagó má dré lèle tò dhɨ ꞌɨ. Mɨ̀ kòyi akódhɨ!» ");
INSERT INTO log_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Gbǎ kòdhwa, ɨ̀ kònò ngá àyɨ làgásè dre dhɨ, ɨ̀ dré gòzo vélé móndɨ́ àzya no àyɨ ɨ́be ko, ngbà ꞌí Yésu ꞌɨ kalóma. ");
INSERT INTO log_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ɨ̀ dré tá adréràꞌa asílé kòngó nda drìlésè dhɨ ꞌá dhɨ, Yésu dré àyɨ kɨ kodzózó tàzoá dhɨ, ɨ̀ kòtɨtɨ́ tà ɨ̀ dré nòle nda dhya àlo dré ko, tsàle lókyá Móndɨ́ nɨ Mvá dré ngaràꞌa dràdrà ꞌásè dhɨ ꞌá. ");
INSERT INTO log_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Dɨ ɨ̀ dré tà nda nɨ zùzo tayɨ́lé àyɨ léna, adrézó lizíá àyɨ kòfalésè ngalè kúlí «ngàma dràdrà ꞌásè» nda adré tá lèá tàle ngɨ́nɨ ya dhɨ. ");
INSERT INTO log_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Gò ɨ̀ dré Yésu nɨ lizízó tàzoá dhɨ: «Tátrɨ́trɨ́ kúlí tadhábhá ɨ̀ adré tàá dhɨ, lè Èlɨ́yà kàlɨ̀ rè zyà Mèsɨ́yà kandrá ꞌíká àdho tà sè?» ");
INSERT INTO log_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yésu logó àyɨ dré dhɨ: «Tà bàti ró dhɨ, Èlɨ́yà adré alɨ̀le drìdrì tà títí dhɨ kɨ ledé. Dɨ, Gìká nɨ Kúlí adré kókpà tàá dhɨ, lè Móndɨ́ nɨ Mvá kònya kɨzà lavúlé, ɨ̀ndɨ̀ à kògà akódhɨ rè dhɨ àdho tà sè? ");
INSERT INTO log_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Dɨ, má adré mána tàá àmɨ dré dhɨ, Èlɨ́yà atsá dre. Gò móndɨ́ ɨ̀ dré àyɨkya akódhɨ nɨ ꞌòzo ngóró ɨ̀ dré tá lèle dhɨ tɨ́nɨ, ngóró tɨsɨ̀le akódhɨ nɨ tà dri Gìká nɨ Kúlí na dhɨ tɨ́nɨ.» ");
INSERT INTO log_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yésu ɨ̀ kògò tsàle akódhɨ nɨ lebèbhá àruka nda ɨ véna dre dhɨ, ɨ̀ dré móndɨ́ zyandre ru kɨmóbhá àyɨ nda ɨ làgásè kúrú dhɨ kɨ nòzo, túmä́ní tátrɨ́trɨ́ kúlí tadhábhá adrébhá tà kayí àyɨ ɨ́be dhɨ ɨ́be. ");
INSERT INTO log_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Gbǎ lókyá móndyá zyandre nda ɨ̀ dré Yésu nɨ nòzo dhɨ sè dhɨ, àyɨ kɨ lɨ́ndrɨ́ dré gàzo gagà gò, ɨ̀ dré arázó mòdo fe drá. ");
INSERT INTO log_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Gò Yésu dré lizízóá áyɨ lebèbhá nda ɨ tí dhɨ: «Mɨ̀ adré tà kayí àyɨ ɨ́be àdho tà dri?» ");
INSERT INTO log_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Dɨ agó àlo móndyá zyandre nda ɨ kòfalé dhɨ dré logózóá drá dhɨ: «Tadhálépi, má adrì áma mváagó alɨ̀zo ába mɨ́ vélé. Tàko ko, akódhɨ tɨrɨ́ kònzɨ akódhɨ nɨ ꞌòlepi atsálé ábhä́bhä́ ro dhɨ ɨ́be ɨ́ léna. ");
INSERT INTO log_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Tɨrɨ́ nda kàdré akódhɨ nɨ ru dhɨ, adré akódhɨ nɨ abhé kìní mi, kápfùtrá dré adrézó apfòle sílásà gò, dré adrézó síkálándrá tsɨ, adrézó áyɨ kɨdzɨ̀ sɨ̀ adrélé tòmbátòmba. Má lizí tá ámɨ lebèbhá kɨ ti, ɨ̀ kòdroró tɨrɨ́ nda ká. Dɨ, ɨ̀ kɨtswá tá àyɨkya bwà ko.» ");
INSERT INTO log_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Dɨ Yésu logó àyɨ dré dhɨ: «Àmɨ, móndyá ándrò tà kaꞌìkaꞌì àko nɨ ɨ, mà nɨ adré vélé àmɨ ɨ́be vwàle lókyá be ángopɨ́? Má nɨ àmɨ kɨ tà mvo vwàle lókyá be ángopɨ́? Mɨ̀ adrì mvámvá nda alɨ̀zo ába má vélé.» ");
INSERT INTO log_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ɨ̀ dré dɨ alɨ̀zo ába. Dɨ gbǎ lókyá tɨrɨ́ nda dré Yésu nɨ nòzo dhɨ sè dhɨ, dré ngàzo adrélé mvámvá nda nɨ kɨzɨ́ rìnyí sè. Akódhɨ nda dré dhèzo kìní mi, adrélé áyɨ lɨlɨ́ gò, kápfùtrá dré adrézó apfòle sílásà. ");
INSERT INTO log_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Dɨ Yésu dré akódhɨ nɨ atá nɨ lizízó tàzoá dhɨ: «Tà kòdhɨ ꞌo akódhɨ kònɨ̀nɨ vwàle ángopɨ́?» Atá nɨ logó dhɨ: «Kɨdhólé akódhɨ nɨ anzɨ̀ lésè. ");
INSERT INTO log_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Vésè be bǐ, tɨrɨ́ nda lebhé akódhɨ àtsɨ́ na yà, kó ngalè yǐ na, kɨtswázó akódhɨ nɨ pfu dràle dhɨ bvó. Dɨ mɨ́ kòkɨtswá dhɨ, mɨ́ kòbhà àma kɨ kɨzà àma kɨ ledézó wà!» ");
INSERT INTO log_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Dɨ Yésu tà drá dhɨ: «Mɨ́ adré tàá dhɨ, má kòkɨtswá yà dhɨ? Gìká rìnyí ɨ́be kɨtswázó tà títí dhɨ kɨ ꞌo dhya adrélépi áyɨ kaꞌì dhɨ dré.» ");
INSERT INTO log_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Gbǎ kòdhwa, mvámvá nda nɨ atá dré yòzoá dhɨ: «Má adré kaꞌìá! Dɨ, mɨ́ kòledé ma, áma tà kaꞌìkaꞌì nda dré adrélé yàyà dhɨ sè!» ");
INSERT INTO log_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yésu kònò móndyá zyandre nda ɨ̀ adré tá arálé àyɨ vélé dhɨ dre dhɨ, dré lɨgɨ́zó tɨrɨ́ kònzɨ nda be, tàzoá dhɨ: «Mɨ, tɨrɨ́ adrélépi móndɨ́ ꞌo atsálé ábhä́bhä́ ro ɨ̀ndɨ̀ bíbhálé ɨ́be kùdúkùdu ró nɨ, má adré tàá mɨ́ dri dhɨ, mɨ́ pfò mvámvá kònɨ̀dhɨ lésè! Mɨ́ kògò tàdzí fɨ̀le lána ko!» ");
INSERT INTO log_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Dɨ tɨrɨ́ nda dré trèzo, mvámvá nda nɨ kɨzɨ́zó rìnyí sè gò, pfòzo lásà lɨ̀le. Móndyá nda ɨ̀ kònò mvámvá nda adréràꞌa ayílé àbvò tɨ́nɨ dre dhɨ, àyɨ kɨ àruka ɨ̀ dré tàzoá dhɨ: «Drà dre.» ");
INSERT INTO log_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Dɨ, Yésu dré akódhɨ nɨ drɨ́gá rùzo tɨngázóá gò, akódhɨ dré áyɨ totózó áyɨ pá dri. ");
INSERT INTO log_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Bvóá dhɨ, Yésu ɨ̀ kònzɨ bhàna lebèbhá nɨ ɨ́be adrélé àyɨ pátí dre dhɨ, ɨ̀ dré akódhɨ nɨ lizízó tàzoá dhɨ: «Mà kɨtswá tá tɨrɨ́ kònzɨ nda kònàdhɨ nɨ dro bwà ko àdho tà sè?» ");
INSERT INTO log_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yésu logó àyɨ dré dhɨ: «À kɨtswá ngbà ꞌí tɨrɨ́ kònzɨ kárá be kònɨ̀nɨ dhɨ kɨ dro pfòle tà zìma Gìká tí dhɨ sè.» ");
INSERT INTO log_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ɨ̀ kòtayɨ́ àrà nda dre dhɨ, ɨ̀ dré ngàzo adrélé lavúlé bvò Gàlìláyà àdhya ꞌásè. Yésu lè tá à kònì àyɨ tá kònàle dhɨ ko. ");
INSERT INTO log_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Tàko ko, adré tá tà tadhá áyɨ lebèbhá ɨ dré, adrézó tàá dhɨ: «À nɨ Móndɨ́ nɨ Mvá nɨ lefè kàrɨbhá ɨ drɨ́gá. Ɨ̀ dré akódhɨ nɨ pfùzo dràle gò, kìtú na àmvolésè dhɨ, dré ngàzo dràdrà ꞌásè.» ");
INSERT INTO log_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Dɨ, kúlí nda kɨ àndu fɨ tá ɨ́na àyɨ drìna ko. Ɨ̀ adré tá kpà ngá ro tà nda nɨ lizima Yésu tí dhɨ sè. ");
INSERT INTO log_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Gò ɨ̀ dré lɨ̀zo tsàle Kàpàrànàwúmà na. Ɨ̀ dré tá adréràꞌa dzó na dhɨ ꞌá dhɨ, Yésu dré lizízóá áyɨ lebèbhá ɨ tí dhɨ: «Láti ꞌá dhɨ, mɨ̀ adré tá tà kayí àmɨ kòfalésè àdho tà dri?» ");
INSERT INTO log_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Dɨ, ɨ̀ dré kúlí logózó ko. Tàko ko, ɨ̀ adré tá àyɨkya tà kayí nìzoá ngalè dhya kàdrɨ̀ lavúlé àyɨ kòfalé dhɨ àdhi ꞌɨ ya dhɨ. ");
INSERT INTO log_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Dɨ Yésu kòlɨrɨ́ dre dhɨ, dré áyɨ lebèbhá mudrí-drì-rì nda kɨ azízó, tàzoá àyɨ dré dhɨ: «Dhya àlo kàdré lèá adrélé drìdrì móndɨ́ ɨ kòfalé dhɨ, lè akódhɨ nda kàdré dhya bvólé ro àyɨ títí dhɨ ɨ kòfalé, ɨ̀ndɨ̀ màrábà àyɨ títí dhɨ kya ró.» ");
INSERT INTO log_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Gò dré mvámvá àlo dhɨ nɨ adózó bhàle àyɨ kɨ kɨ́tó ꞌá. Kàdó akódhɨ nda rùle ɨ́ drɨ́gá dre dhɨ, dré tàzoá àyɨ dré dhɨ: ");
INSERT INTO log_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Dhya ángùdhi adrélépi mvámvá kònɨ̀dhɨ tɨ́nɨ dhɨ nɨ kaꞌì dòle dóro áma rú sè dhɨ, adré áma tàndɨ nɨ kaꞌì kòdhya. Dhya ángùdhi adrélépi áma kaꞌì dòle dóro dhɨ, adré ngbà ꞌí áma kaꞌì kòdhya ko, adré kókpà dhya áma amùlepi dhɨ nɨ kaꞌì kòdhya.» ");
INSERT INTO log_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Gò Yòwánɨ̀ dré tàzoá Yésu dré dhɨ: «Tadhálépi, mà nò tá agó àlo dhɨ adréràꞌa tɨrɨ́ kònzɨ kɨ dro ámɨ rú sè. Dɨ mà dré akódhɨ nda nɨ logázó, dré tá adrélé àma kɨ àlo ꞌɨ ko dhɨ sè.» ");
INSERT INTO log_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Dɨ, Yésu logó dhɨ: «Mɨ̀ logá akódhɨ ko. Tàko ko, dhya àlo tà lɨ́ndrɨ́ga ró dhɨ nɨ ꞌòlepi áma rú sè dhɨ, kɨtswá ndɨrɨ gòle áyɨ alá tà ta kònzɨ má rú bwà ko. ");
INSERT INTO log_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Àngyá ko, dhya ángùdhi adrélépi ru pfu àma ɨ́be ko dhɨ, àma kɨ àlo ꞌɨ. ");
INSERT INTO log_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Má adré tà bàti ta àmɨ dré: Dhya ángùdhi adrélépi ndɨ̀ndɨ̀ kópò yǐ àdhya nɨ fe àmɨ dré mvùle, mɨ̀ dré adrélé móndyá Krísto àdhya ꞌɨ dhɨ sè dhɨ, akódhɨ nda nɨ làgɨ́ ɨ́na nɨ kisú bàti.» ");
INSERT INTO log_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","«Dɨ, dhya àlo kàdré ɨ́na ànzɨmvá adrébhá áma kaꞌì kònɨ kɨ àlo ꞌo dhèle tàkonzɨ̀ na dhɨ, dóro nɨ tá kɨ́rà kàdrɨ̀ ꞌɨ̀le akódhɨ nda kembé gò, akódhɨ nɨ bhèzo dràle yǐandre na dhɨ. ");
INSERT INTO log_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ámɨ drɨ́gá kàdré ámɨ ꞌo dhèle tàkonzɨ̀ na nɨ̀ dhɨ, lè mɨ́ kòli ámɨ drɨ́gá nda. Àngyá ko, mɨ́ dré fɨ̀le lɨ́drɨ̀ kóná vésè kólyá dhɨ na ngbà ꞌí drɨ́gá be àlo dhɨ dóro lavúlé, mɨ́ dré lɨ̀le líferò àtsɨ́ nɨ dré adrézó adrálé ko dhɨ na drɨ́gá be rì dhɨ rúsè.  ");
INSERT INTO log_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ámɨ pá kàdré ámɨ ꞌo dhèle tàkonzɨ̀ na nɨ̀ dhɨ, lè mɨ́ kòli ámɨ pá nda. Àngyá ko, mɨ́ dré fɨ̀le lɨ́drɨ̀ na ngbà ꞌí pá be àlo dhɨ dóro lavúlé, ámɨ bhèle líferò na pá be rì dhɨ rúsè.  ");
INSERT INTO log_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ámɨ mì kàdré kó ámɨ ꞌo dhèle tàkonzɨ̀ na nɨ̀ dhɨ, lè mɨ́ kàngɨ́ ámɨ mì nda. Àngyá ko, mɨ́ dré fɨ̀le Gìká nɨ Òpɨ̀ na ngbà ꞌí mì be àlo dhɨ dóro lavúlé, ámɨ bhèle líferò na mì be rì dhɨ rúsè. ");
INSERT INTO log_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Kònàle dhɨ, ‹kùbhú adrébhá àbvò nya dhɨ ɨ̀ todrà ko na, ɨ̀ndɨ̀ àtsɨ́ adrélépi kòle dhɨ adrá kpà ko na.› ");
INSERT INTO log_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","À nɨ móndyá títí dhɨ kɨ tà kaꞌìkaꞌì tabhì àtsɨ́ sè, ɨ̀ kàdréró tàꞌí ɨ́be àyɨ léna. ");
INSERT INTO log_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Tàꞌí ngá dóro ꞌɨ. Dɨ, tàꞌí nɨ aswaaswa kòtɨ̀ akɨ́lé lásà dhɨ, mɨ̀ nɨ kɨtswá logóá ngɨ́nɨ? Lè mɨ̀ kàdré tàꞌí ɨ́be àmɨ kɨ tàndɨ ɨ léna, adrézó kpà tà kɨ̀drɨ́kɨ̀drɨ ɨ́be àmɨ kòfalé.» ");
INSERT INTO log_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yésu kòtayɨ́ àrà nda dre dhɨ, dré lɨ̀zo bvò Yùdáyà àdhya na gò, zyàle tsàle Yòròdánè nɨ taꞌá na. Móndɨ́ zyandre dhɨ ɨ̀ dré gòzo ru kɨmó akódhɨ làga gò, dré kɨdhózó adrélé àyɨ kɨ tadhá, ànzyà gà dré adrélé ꞌòle dhɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Gò Fàrìsáyò àruka ɨ̀ dré àyɨ kɨ kisízó ànyɨ akódhɨ làga, kɨtswálé akódhɨ nɨ tabhì lɨtɨ́lé. Dɨ ɨ̀ dré lizízóá tíá dhɨ: «Àma kɨ tátrɨ́trɨ́ kúlí kaꞌì, agó kòtɨngá áyɨ tòkó dhɨ ꞌí?» ");
INSERT INTO log_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Akódhɨ logó àyɨ dré dhɨ: «Mósè fè tòlɨ́ àmɨ dré ꞌòzoá ngɨ́nɨ?» ");
INSERT INTO log_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ɨ̀ logó drá dhɨ: «Mósè kaꞌì tá dhɨ, agó kòtɨsɨ̀ wárágà áyɨ tòkó nɨ tɨngázó gò, mùzoá nzɨ̀le.» ");
INSERT INTO log_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yésu logó àyɨ dré dhɨ: «Mósè tɨsɨ̀ tá ɨ́na tòlɨ́ nda kòdhɨ àmɨ dré, àmɨ kɨ togó dré adrélé tòmbátòmba dhɨ sè. ");
INSERT INTO log_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Dɨ, ngá títí dhɨ kɨ bhàma nɨ kɨdhoma ꞌá dhɨ, ‹Gìká bhà tá àyɨ agó ɨ tòkó be.› ");
INSERT INTO log_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‹Ásà dhɨ, agó nɨ áyɨ atá nɨ tayɨ́ áyɨ andre be, ru amúzó áyɨ tòkó be gò, ");
INSERT INTO log_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","àyɨ rìti nda ɨ̀ dré atsázó rúbhá àlo ró.› Dɨ ɨ̀ gò vélé adrélé rì ko. Be ró dhɨ, àyɨ ngá àlo ꞌɨ. ");
INSERT INTO log_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ásà dhɨ, lè móndɨ́ ɨ̀ kòlanzɨ́ ngá Gìká dré amúlé nɨ̀ dhɨ ko.» ");
INSERT INTO log_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Àmvolásà, ɨ̀ kòfɨ dzó na dre dhɨ, akódhɨ nɨ lebèbhá ɨ̀ dré gòzo akódhɨ nɨ lizí tà nda dri. ");
INSERT INTO log_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Akódhɨ logó àyɨ dré dhɨ: «Agó ángùdhi áyɨ tòkó nɨ tɨngálépi gò gòzo tòkó àzya adó mòle dhɨ, adré ɨ́na múná tà ꞌo tòkó nɨ àlo nda rú. ");
INSERT INTO log_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Kòdhɨ ɨ́be dhɨ, tòkó ángùdhi áyɨ agó nɨ tayɨ́lépi gò gòzo agó àzya mo dhɨ, adré kókpà múná tà ꞌo.» ");
INSERT INTO log_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Kìtú àlo dhɨ, móndɨ́ ɨ̀ adré tá àyɨ kɨ ànzɨmvá kɨ adrì alɨ̀zo àyɨ ɨ́be Yésu vélé, kòtabèró àyɨ, tà tanɨ zìzo Gìká tí àyɨ dri be dhɨ bvó. Dɨ, akódhɨ nɨ lebèbhá ɨ̀ dré àyɨkya lawàzo móndyá nda ɨ dri tà nda sè. ");
INSERT INTO log_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yésu kònò tà nda dre dhɨ, akódhɨ nɨ togó dré aswázó gò, dré tàzoá àyɨ dré dhɨ: «Mɨ̀ tayɨ́ ànzɨmvá kònɨ ɨ alɨ̀le má vélé. Mɨ̀ logá àyɨ ko. Àngyá ko, Gìká nɨ Òpɨ̀ móndyá adrébhá àyɨ nda ɨ tɨ́nɨ dhɨ ɨ dré. ");
INSERT INTO log_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Má adré tà bàti ta àmɨ dré: Dhya ángùdhi adrélépi Gìká nɨ Òpɨ̀ kaꞌì ànzɨmvá kya tɨ́nɨ ko dhɨ, kɨtswá tàdzí fɨ̀le lána ko.» ");
INSERT INTO log_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Gò dré ànzɨmvá nda kɨ adózó rùle ɨ́ drɨ́gá, áyɨ drɨ́gá bhàzo àyɨ àlo àlo títí dhɨ ɨ dri, tà tanɨ zìzo àyɨ dré. ");
INSERT INTO log_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yésu kònga adrélé lɨ̀le láti ꞌásè dre dhɨ, agó àlo dhɨ dré arázó adhélé áyɨ kórókó titì akódhɨ kandrá, akódhɨ nɨ lizízó tàzoá dhɨ: «Dhya dóro adrélépi tà tadhá nɨ, lè má kòꞌo àdho tà kòdhya kɨtswázó lɨ́drɨ̀ kóná vésè kólyá dhɨ nɨ kisú dhɨ?» ");
INSERT INTO log_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yésu logó drá dhɨ: «Mɨ́ adré áma zi dhya dóro dhɨ ró àdho tà sè? Dhya adrélépi dóro dhɨ yókódhó, ngbà ꞌí Gìká ꞌɨ kalóma. ");
INSERT INTO log_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Mɨ́ nì tà tátrɨ́trɨ́ kúlí dré adrélé tàle à kòꞌo dhɨ ɨ be: ‹Lè mɨ́ kòpfu móndɨ́ dràle ko. Mɨ́ kòꞌo múná tà ko. Mɨ́ kòkugù ngá ko. Mɨ́ kòtà tà móndɨ́ rú kɨnzò sè ko. Mɨ́ kòdo móndɨ́ kɨ ngá túrúpfú sè ko. Mɨ́ kàdré ámɨ atá nɨ lɨndrɨ̀ bha ámɨ andre be.›» ");
INSERT INTO log_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Dɨ agó nda tà drá dhɨ: «Tadhálépi, má lɨkɨ́ tòlɨ́ nda kòdhɨ ɨ títí, kɨdhólé má dré tá adréràꞌa kàdhúrà ro dhɨ ꞌá.» ");
INSERT INTO log_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yésu dré akódhɨ nɨ nòzo lèle sè wě gò, tàzoá drá dhɨ: «Tayɨ́ ngbà ꞌí mɨ́ dré tà àlo kòdhya: Mɨ́ lɨ̀ ámɨ ngá títí dhɨ kɨ lagɨ́, làfa nɨ nɨ lanzɨ́zó lemerèbhá ɨ dré gò, mɨ́ kàdréró ngá làgɨ́ be kàdrɨ̀ dhɨ ɨ́be bhù na. Dɨ mɨ́ alɨ̀ adrélé áma lebè.» ");
INSERT INTO log_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Agó nda kòyi kúlí nda ɨ dre dhɨ, akódhɨ nɨ mìbhalé dré atsázó kɨzà ro. Gò dré ngàzo lɨ̀le kɨzà be tò, dré tá adrélé ngá ɨ́be zyandre ró dhɨ sè. ");
INSERT INTO log_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yésu dré áyɨ alázó áyɨ lebèbhá kɨ no gò, tàzoá àyɨ dré dhɨ: «Ngábhá kɨ fɨ̀ma Gìká nɨ Òpɨ̀ na dhɨ kòkóròko!» ");
INSERT INTO log_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Gò akódhɨ nɨ lebèbhá nda kɨ lɨ́ndrɨ́ dré gàzo gagà kúlí nda sè. Dɨ, Yésu dré gòzo tàá dhɨ: «Áma ànzɨ ɨ, fɨ̀ma Gìká nɨ Òpɨ̀ na dhɨ kòkóròko! ");
INSERT INTO log_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ngá líyí nɨ fɨ̀ma Gìká nɨ Òpɨ̀ na dhɨ ɨ́na kòkóròko lavúlé, kàmílò dré lavúlé sìndánì nɨ bhálé ꞌásè dhɨ rúsè!» ");
INSERT INTO log_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Dɨ akódhɨ nɨ lebèbhá nda kɨ lɨ́ndrɨ́ dré gàzo vélé wáláká nɨ nɨ lavú gò, ɨ̀ dré adrézó lizíá àyɨ kòfalésè dhɨ: «Kàdré kònɨ̀nɨ dhɨ, àdhi nɨ kɨtswá lɨ́drɨ̀ kóná vésè kólyá dhɨ nɨ kisú nɨ̀?» ");
INSERT INTO log_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yésu dré àyɨ kɨ nòzo dɨ̀ɨɨ́ gò, tàzoá àyɨ dré dhɨ: «Móndɨ́ ɨ mìlésè dhɨ, tà nda kòdhɨ tà kɨtswálé ꞌòle bwà ko dhɨ ꞌɨ. Dɨ, Gìká adré ɨ́na tà nda nɨ no kònɨ̀nɨ ko. Akódhɨ mìlésè dhɨ, tà àlo kɨtswálé ꞌòle bwà ko dhɨ yókódhó.» ");
INSERT INTO log_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Gò Pétèró dré tàzoá drá dhɨ: «Mɨ́ nò rè ká! Mà tayɨ́ tà títí dhɨ ɨ adrézó ámɨ lebè.» ");
INSERT INTO log_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Dɨ Yésu logó àyɨ dré dhɨ: «Má adré tà bàti ta àmɨ dré: Dhya ángùdhi áyɨ dzó ꞌɨ yà, áyɨ adrúpi ɨ ꞌɨ yà, áyɨ amvúpi ɨ ꞌɨ yà, áyɨ andre ꞌɨ yà, áyɨ atá ꞌɨ yà, áyɨ ànzɨ ɨ ꞌɨ yà, kó ngalè áyɨ amvú ɨ ꞌɨ yà dhɨ kɨ tayɨ́lépi áma tà sè ɨ̀ndɨ̀ Rúbí Tanɨ nɨ tà sè dhɨ, ");
INSERT INTO log_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","a nɨ ngá nda kɨ vúdrì kisú tsàle vésè be nyadhɨ-nzi lókyá kònɨ̀dhɨ sè. A nɨ dzó kɨ kisú, adrúpi ɨ́be, amvúpi ɨ́be, andre ɨ́be, ànzɨ ɨ́be, amvú ɨ́be, túmä́ní tà adrézó áyɨ mì pfo dhɨ ɨ́be. Kòdhɨ ɨ́be dhɨ, a nɨ kókpà lɨ́drɨ̀ kóná vésè kólyá dhɨ nɨ kisú lókyá adrélépi alɨ̀le dhɨ sè. ");
INSERT INTO log_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Dɨ, móndɨ́ bǐ adrébhá drìdrì nyànomvá dhɨ kɨ go adrélé bvólé ro. Móndɨ́ bǐ adrébhá bvólé ro nyànomvá dhɨ kɨ go adrélé drìdrì.» ");
INSERT INTO log_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ɨ̀ dré tá adréràꞌa mbàle Yèrúsalémà na dhɨ ꞌá dhɨ, Yésu adré tá lɨ̀le áyɨ lebèbhá ɨ kandrána. Àyɨ nda kɨ togó adré tá gàle tirì dré. Móndyá adrébhá lɨ̀le àyɨ vésè dhɨ ɨ̀ adré tá kpà ngá ro. Dɨ Yésu dré gòzo tódhyá áyɨ lebèbhá mudrí-drì-rì nda kɨ dri gàrà dri gò, kɨdhózó adrélé tà adrébhá ꞌòle atsálé ɨ́ rú dhɨ kɨ ta àyɨ dré. ");
INSERT INTO log_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Tà dhɨ: «Mɨ̀ yi rè ká! Mà adré mbàle Yèrúsalémà na. Kònàle dhɨ, à nɨ Móndɨ́ nɨ Mvá nɨ lefè kòwánà kàdrɨ̀ ɨ drɨ́gá tátrɨ́trɨ́ kúlí tadhábhá ɨ́be. Ɨ̀ dré tà ŋòzo akódhɨ dri kɨtswálé dràdrà sè gò, akódhɨ nɨ fèzo pàgánò ɨ drɨ́gá. ");
INSERT INTO log_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Àyɨ nda ɨ̀ dré akódhɨ nɨ gùzo, tùsú lufúzó mìá, tswàzoá gò, pfùzoá dràle. Dɨ kìtú na àmvolésè dhɨ, dré ngàzo dràdrà ꞌásè.» ");
INSERT INTO log_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Gò Yàkóbhò ɨ Yòwánɨ̀ be, Zèbèdáyò nɨ ànzɨ ɨ ró dhɨ, ɨ̀ dré àyɨ kɨ kisízó ànyɨ Yésu làga, tàá drá dhɨ: «Tadhálépi, mà adré lèá mɨ́ kòꞌo tà mà dré dra zìle mɨ́ tí dhɨ àma dré.» ");
INSERT INTO log_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yésu tà àyɨ dré dhɨ: «Mɨ̀ adré lèá má kòꞌo àmɨ dré àdho tà kòdhya?» ");
INSERT INTO log_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ɨ̀ logó drá dhɨ: «Ámɨ Òpɨ̀ mìlanzìlanzì ro dhɨ na dhɨ, mɨ́ kòbhà àma lɨrɨ́lé mɨ́ làga: àlo nɨ ámɨ drɨ́ágó lésè, àzya nɨ ámɨ lìdzí lésè.» ");
INSERT INTO log_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Dɨ Yésu tà àyɨ dré dhɨ: «Mɨ̀ nì tà mɨ̀ dré adrélé zìle kòdhɨ ko. Mɨ̀ nɨ kɨtswá tsì kópò kɨzà àdhya má dré adrélé ꞌòle mvùle dhɨ nɨ mvu bwà? Mɨ̀ nɨ kpà kɨtswá bàtísimò kɨzà àdhya má dré adrélé ꞌòle dòle dhɨ nɨ do bwà?» ");
INSERT INTO log_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ɨ̀ logó drá dhɨ: «Mà nɨ kɨtswá.» Dɨ Yésu tà àyɨ dré dhɨ: «Tà bàti ró dhɨ, mɨ̀ nɨ kópò má dré dra mvùle dhɨ nɨ mvu, adrézó kpà bàtísimò má dré dra dòle dhɨ nɨ do. ");
INSERT INTO log_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Dɨ, kàdré ɨ́na móndɨ́ dra bhàle lɨrɨ́lé áma drɨ́ágó lésè yà, kó ngalè áma lìdzí lésè yà dhɨ kɨ tà sè dhɨ, tà nda kòdhɨ nò ma ko. Gìká ledé lɨrɨ́rà nda ɨ dhya dré kɨpèle kɨtswálé lɨrɨ́lé drìá dhɨ ɨ dré.» ");
INSERT INTO log_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Yésu nɨ lebèbhá mudrí àruka dhɨ ɨ̀ kòyi tà zìle nda dre dhɨ, àyɨ kɨ togó dré aswázó Yàkóbhò ɨ rú Yòwánɨ̀ be. ");
INSERT INTO log_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Dɨ Yésu dré àyɨ kɨ azízó títí gò, tàzoá àyɨ dré dhɨ: «Mɨ̀ nì tàle dhɨ, dhya adrélé nòle móndyá bvò kòndɨ àdhya kɨ kàdrɨ̀ ɨ ró dhɨ ɨ̀ adré àyɨkya òpɨ̀ nya àyɨ dri rìnyí sè dhɨ be. Àyɨ kɨ dhya kàdrɨ̀kàdrɨ̀ dhɨ ɨ̀ adré kpà tà ꞌo adrézó àyɨ kɨ rìnyí tadhá àyɨ dré. ");
INSERT INTO log_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Dɨ, adré lèá dhɨ, tà nda kàdré kònɨ̀nɨ àmɨ kòfalé ko. Be ró dhɨ, lè dhya ángùdhi adrélépi lèá atsálé kàdrɨ̀ àmɨ kòfalé dhɨ, kàdré àmɨ kɨ màrábà ro. ");
INSERT INTO log_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Lè kpà dhya ángùdhi adrélépi lèá adrélé drìdrì àmɨ kòfalé dhɨ, kàdré àmɨ títí dhɨ kɨ màrábà ro. ");
INSERT INTO log_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Tàko ko, Móndɨ́ nɨ Mvá alɨ̀ bvò dri, móndɨ́ ɨ̀ kàdréró tà ꞌo ɨ́ dré dhɨ bvó ko. Be ró dhɨ, alɨ̀ ɨ́na kɨtswálé tà ꞌo móndɨ́ ɨ dré dhɨ bvó. Alɨ̀ kpà kɨtswálé áyɨ lɨ́drɨ̀ fe ngóró làgɨ́ kàdrɨ̀ fèle móndɨ́ zyandre dhɨ kɨ apázó tàkonzɨ̀ lésè dhɨ tɨ́nɨ.» ");
INSERT INTO log_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Gò Yésu ɨ̀ dré tsàzo Yèríkò na lebèbhá nɨ ɨ́be. Ɨ̀ dré tá adréràꞌa apfòle bhàandre nda lésè móndɨ́ zyandre ɨ́be dhɨ ꞌá dhɨ, agó àlo mì kùdúkùdu ró rú be Bàràtìmáyò, Tìmáyò nɨ mvá ro dhɨ, lɨrɨ́ tá láti làga adrélé ngá zi móndɨ́ ɨ tí. ");
INSERT INTO log_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Akódhɨ nda kòyi Yésu Nàzàrétà lésè dhɨ adré tá lavúlé dhɨ dre dhɨ, dré ngàzo adrélé loyóá dhɨ: «Yésu, Dàwídì nɨ Mvá, mɨ́ bhà áma kɨzà wà!» ");
INSERT INTO log_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Móndɨ́ bǐ dhɨ ɨ̀ dré adrézó tetrélé akódhɨ dri, kòtayɨ́ró kúlí adrézó kɨ́rɨ. Dɨ, dré gòzo vélé adrélé kúlí loyó wáláká nɨ nɨ lavú: «Dàwídì nɨ Mvá, mɨ́ bhà áma kɨzà wà!» ");
INSERT INTO log_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Gò Yésu dré áyɨ kɨkɨ́zó tàá dhɨ: «Mɨ̀ azí akódhɨ.» Dɨ ɨ̀ dré mì kùdúkùdu nda nɨ azízó, tàzoá drá dhɨ: «Mɨ́ tsɨ togó! Mɨ́ nga! Akódhɨ adré ámɨ zi.» ");
INSERT INTO log_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Dɨ akódhɨ dré áyɨ kɨ́tá bhèzo gàrà dri, áyɨ totózó pá dri gò, alɨ̀le Yésu vélé. ");
INSERT INTO log_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yésu dré akódhɨ nɨ lizízó tàzoá dhɨ: «Mɨ́ adré lèá má kòꞌo mɨ́ dré àdho tà kòdhya?» Mì kùdúkùdu nda logó drá dhɨ: «Rábbì, má lè ngá nòle!» ");
INSERT INTO log_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Dɨ Yésu tà drá dhɨ: «Mɨ́ lɨ̀! Ámɨ tà kaꞌìkaꞌì tɨdrɨ́ mɨ dre.» Gbǎ kòdhwa, akódhɨ dré kɨdhózó adrélé ngá no gò, dré ngàzo adrélé Yésu nɨ lebè láti ꞌásè. ");
INSERT INTO log_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yésu ɨ̀ dré tá adréràꞌa ꞌòle tsàle Yèrúsalémà na dhɨ ꞌá dhɨ, ɨ̀ dré tsàzo ànyɨ bhà rú zìle Bètèfágè ɨ̀ndɨ̀ Bètànɨ́yà dhɨ ɨ kandrá, ànyɨ kòngó Òlívè fa kya làga. Gò Yésu dré áyɨ lebèbhá rì dhɨ kɨ mùzo lɨ̀le drìdrì, ");
INSERT INTO log_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","tàzoá àyɨ dré dhɨ: «Mɨ̀ lɨ̀ bhà àmɨ kandrá kònàdhɨ léna. Mɨ̀ kòfɨ lána dre dhɨ, mɨ̀ nɨ ndɨrɨ púndà mvá ꞌɨ̀le, à dré dhu rè mbàzo drìá ko dhɨ nɨ kisú. Mɨ̀ atrɨ̀ akódhɨ, alɨ̀zo ába má vélé. ");
INSERT INTO log_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Dhya àlo kòlizí àmɨ tí dhɨ, ‹Mɨ̀ adré ꞌòá kònɨ̀nɨ àdho tà sè?› ya dhɨ, mɨ̀ kòtà drá dhɨ: ‹Mírì adré lèá nɨ̀. A nɨ dra akódhɨ nɨ logó kònwa mbèlè.›» ");
INSERT INTO log_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Dɨ ɨ̀ dré lɨ̀zo púndà mvá nda nɨ kisú. À ꞌɨ̀ tá akódhɨ láti làga, dzó àlo dhɨ tí. Ɨ̀ dré tá adréràꞌa akódhɨ nɨ atrɨ̀ dhɨ ꞌá dhɨ, ");
INSERT INTO log_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","móndɨ́ àruka kònàle dhɨ ɨ̀ dré lizízóá àyɨ tí dhɨ: «Mɨ̀ adré púndà mvá kòdhɨ nɨ trɨ àdho tà sè?» ");
INSERT INTO log_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Dɨ ɨ̀ dré kúlí logózó àyɨ dré ngóró Yésu dré tá tàle àyɨ dré dhɨ tɨ́nɨ gò, móndyá nda ɨ̀ dré àyɨ kɨ tayɨ́zó lɨ̀le ába. ");
INSERT INTO log_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ɨ̀ kàsé púndà mvá nda atsázó ába Yésu vélé dre dhɨ, ɨ̀ dré àyɨ kɨ kɨ́tá bhèzo drìá gò, akódhɨ dré mbàzo lɨrɨ́lé drìá. ");
INSERT INTO log_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Gò móndɨ́ zyandre dhɨ ɨ̀ dré àyɨ kɨ kɨ́tá kɨ lasézó láti mǐsè. Àyɨ kɨ àruka ɨ̀ dré fa bí kɨ toŋòzo amvú ɨ ꞌásè, lebhézóá láti mǐsè, Yésu kòlavúró drìásà be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Dɨ móndyá zyandre nda ɨ̀ dré adrézó lɨ̀le akódhɨ kandrána ɨ̀ndɨ̀ akódhɨ vésè, adrélé loyóába dhɨ: «Òsánà! Tà tanɨ kàdré dhya adrélépi alɨ̀le Mírì nɨ rú sè dhɨ dri! ");
INSERT INTO log_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Tà tanɨ kàdré òpɨ̀ àma kɨ tábhí Dàwídì àdhya adrélépi alɨ̀le dhɨ dri! Òsánà kàdré Gìká kurú na bhù na dhɨ dré!» ");
INSERT INTO log_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Dɨ Yésu dré tsàzo Yèrúsalémà na gò, lɨ̀le fɨ̀le tépelò na, ngá títí lána dhɨ kɨ no. Dɨ ɨ̀ndró dré andrɨ̀le dre dhɨ sè dhɨ, ɨ̀ dré pfòzo bhàandre nda lésè akódhɨ nɨ lebèbhá mudrí-drì-rì dhɨ ɨ́be, gòle lɨ̀le Bètànɨ́yà na. ");
INSERT INTO log_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Kìtú bvóá dhɨ sè, ɨ̀ dré tá adréràꞌa apfòle Bètànɨ́yà lésè dhɨ ꞌá dhɨ, tàbirí dré Yésu nɨ ꞌòzo. ");
INSERT INTO log_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Akódhɨ dré fígì fa àlo dhɨ nɨ nòzo bí nɨ ɨ́be vwàvwà ro gò, dré lɨ̀zo nòá ngalè ɨ́ nɨ kɨtswá lòꞌwa kisú drìlána bwà yà dhɨ. Dɨ, a nɨ lɨ tsàle ànyɨ làgá dhɨ, kisú ɨ́na lòꞌwa nɨ àlomvá ko. Kisú ngbà ꞌí bí nɨ ɨ kòdhya. Tàko ko, lókyá nda tá lókyá adrézó fígì lòꞌwa kɨ dhɨ ꞌɨ ko. ");
INSERT INTO log_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Gò dré tàzoá fígì fa nda dré dhɨ: «Dhya àlo kògò vélé lòꞌwa kisú nyàle mɨ́ drìna tàdzí ko!» Dɨ akódhɨ nɨ lebèbhá ɨ̀ yi kúlí dré tá tàle nda ꞌí. ");
INSERT INTO log_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ɨ̀ kòtsa Yèrúsalémà na dre dhɨ, Yésu dré fɨ̀zo tépelò na gò, dré ngàzo móndyá adrébhá tá ngá lagɨ́ ɨ̀ndɨ̀ ngá gɨ kònàle dhɨ kɨ dro topfòle ꞌásà. Dré mɨ́sá móndyá adrébhá tá làfa topfó dhɨ kya kɨ lebhézó bvò dri, túmä́ní gbólókó móndyá adrébhá tá kòbhòlà lagɨ́ dhɨ kya ɨ́be. ");
INSERT INTO log_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Dré kpà kaꞌìzoá dhɨ, dhya àlo kàdré ngá do lavúzó ába tépelò ꞌásè dhɨ ko. ");
INSERT INTO log_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Gò dré ngàzo adrélé móndɨ́ kɨ tadhá, adrézó tàá dhɨ: «Gìká nɨ Kúlí adré tàá dhɨ: ‹À nɨ áma dzó zi dzó súrú títí dhɨ ɨ̀ dré adrézó tà ta má be dhɨ ró.› Dɨ, mɨ̀ gò àmɨkya dzó nda nɨ bha adrélé àrà kùgubhá ɨ̀ dré adrézó àyɨ kɨ zu dhɨ ró!» ");
INSERT INTO log_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Kòwánà kàdrɨ̀ ɨ tátrɨ́trɨ́ kúlí tadhábhá ɨ́be dhɨ ɨ̀ kòyi tà Yésu dré tá ꞌòle nda dre dhɨ, ɨ̀ dré ngàzo adrélé láti nda kɨtswázó akódhɨ nɨ pfu dràle dhɨ bvó. Àngyá ko, ɨ̀ adré tá àyɨkya akódhɨ nɨ ro, móndyá zyandre títí dhɨ ɨ̀ dré tá adrélé tà dré adrélé tadhálé dhɨ kɨ yi síbhálé be ngbo dhɨ sè. ");
INSERT INTO log_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ɨ̀ndró kàndrɨ̀ dre dhɨ, Yésu ɨ̀ dré pfòzo bhàandre nda lésè lebèbhá nɨ ɨ́be. ");
INSERT INTO log_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Drùbhì kɨ́nó, ɨ̀ dré tá adréràꞌa lavúlé láti ꞌásè dhɨ ꞌá dhɨ, ɨ̀ dré nòzoá dhɨ, fígì fa nda ꞌyo tá tsàle kómvó nɨ na dre. ");
INSERT INTO log_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Dɨ tà Yésu dré tá tàle dhɨ dré agázó Pétèró léna gò, dré tàzoá drá dhɨ: «Rábbì, mɨ́ nò rè ká! Fígì fa mɨ́ dré tatrɨ́lé kònɨ̀dhɨ ꞌyo dre!» ");
INSERT INTO log_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Dɨ Yésu dré tàzoá áyɨ lebèbhá ɨ dré dhɨ: «Mɨ̀ kàdré Gìká nɨ kaꞌì bàti! ");
INSERT INTO log_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Má adré tà bàti ta àmɨ dré: Dhya àlo kàdré tàá kòngó kònɨ̀dhɨ dré dhɨ, ‹Mɨ́ nga kònwásè lɨ̀le dhèle yǐandre na› gò, dré adrézó tà kayí ɨ́ léna ko, dɨ, adrézó ɨ́na kaꞌìá dhɨ tà ɨ́ dré adrélé tàle nda nɨ ru ꞌo káyà dhɨ, Gìká nɨ tà nda nɨ ꞌo drá. ");
INSERT INTO log_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ásà dhɨ, má adré tàá àmɨ dré dhɨ: Tà ángùdhi mɨ̀ dré adrélé zìle Gìká tí dhɨ, lè mɨ̀ kàdré kaꞌìá dhɨ, mɨ̀ kisú tà nda dre dhɨ, dɨ mɨ̀ nɨ kisúá bàti. ");
INSERT INTO log_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Kòdhɨ ɨ́be dhɨ, mɨ̀ kàdré àmɨ kɨ totó adrélé tà zi Gìká tí gò, mɨ̀ dré adrézó tà ɨ́be móndɨ́ àlo rú dhɨ, lè mɨ̀ kòtrì akódhɨ nda nɨ tàkonzɨ̀ gò, àmɨ kɨ Atá bhù na dhɨ kòtrìró kókpà àmɨ kɨ tàkonzɨ̀ be dhɨ bvó.»  ");
INSERT INTO log_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ɨ̀ dré gòzo tódhyá tsàle Yèrúsalémà na. Dɨ Yésu dré tá adréràꞌa atsílé tépelò nɨ bhàꞌálé ꞌásè dhɨ ꞌá dhɨ, kòwánà kàdrɨ̀ ɨ tátrɨ́trɨ́ kúlí tadhábhá ɨ tsàle bhàgo ɨ́be dhɨ ɨ̀ dré alɨ̀zo akódhɨ vélé ");
INSERT INTO log_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","lizíá tíá dhɨ: «Rìnyí mɨ́ dré adrézó tà kòdhɨ kɨ ꞌo dhɨ angá ɨ́na ángolésè? Àdhi fè mɨ́ dré rìnyí adrézó tà nda kɨ ꞌo dhɨ nɨ̀?» ");
INSERT INTO log_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yésu logó àyɨ dré dhɨ: «Má nɨ kókpà tà àlo dhɨ nɨ lizí àmɨ tí. Mɨ̀ kòlogó kúlí má tí dhɨ, má nɨ kpà tàá àmɨ dré ngalè rìnyí má dré adrézó tà kòdhɨ kɨ ꞌo dhɨ angá ángolésè ya dhɨ. ");
INSERT INTO log_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Mɨ̀ tà rè má dré ká! Bàtísimò Yòwánɨ̀ dré fèle dhɨ angá tá ɨ́na ángolésè: Gìká vélésè, kó ngalè móndɨ́ ɨ vélésè?» ");
INSERT INTO log_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Gò ɨ̀ dré dhèzo adrélé tà kayí àyɨ kòfalésè, adrézó tàá dhɨ: «Mà kòtà dhɨ ‹Bàtísimò nda angá Gìká vélésè› dhɨ, akódhɨ nɨ go lizíá àma tí dhɨ: ‹Mɨ̀ kaꞌì dɨ Yòwánɨ̀ ko àdho tà sè?› ");
INSERT INTO log_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Dɨ, mà nɨ kɨtswá tsì tàá dhɨ ‹Bàtísimò nda angá móndɨ́ ɨ vélésè› yà dhɨ?» (Ɨ̀ tà tá kònɨ̀nɨ, ɨ̀ dré tá adrélé móndyá zyandre dhɨ kɨ ro dhɨ sè. Tàko ko, àyɨ títí nda ɨ̀ adré tá kaꞌìá dhɨ, Yòwánɨ̀ tá ɨ́na pròfétà ꞌɨ.) ");
INSERT INTO log_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Dɨ ɨ̀ dré logózóá Yésu dré dhɨ: «Mà nì ko.» Yésu gò tàá àyɨ dré dhɨ: «Kàdré kònɨ̀nɨ dhɨ, má kɨtswá kókpà tàá àmɨ dré ngalè rìnyí má dré adrézó tà nda kɨ ꞌo dhɨ angá ángolésè ya dhɨ ko.» ");
INSERT INTO log_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Gò Yésu dré kɨdhózó adrélé tà tadhá àyɨ dré pɨ́dhɨ́gó sè, adrézó tàá dhɨ: «Agó àlo dhɨ bhe tá vínò áyɨ amvú na. Dré gàrà nɨ kɨ tobhàzo kɨ́rà sè, bhú gàzo kɨtswázó vínò lòꞌwa zwa gò, dzó mvumvù dhɨ nɨ sìzo kɨtswázó amvú nda nɨ lɨkɨ́. Dré amvú nda nɨ tayɨ́zó vínò lɨkɨ́bhá àruka ɨ drɨ́gá gò, lɨ̀zo atsí na làwú làvo na. ");
INSERT INTO log_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Lókyá vínò lòꞌwa kɨ̀zo dhɨ kòkɨtswá dre dhɨ, dré áyɨ màrábà kɨ àlo mùzo kɨtswálé lòꞌwa ɨ́na tɨ́nɨ dhɨ nɨ adó vínò lɨkɨ́bhá nda ɨ véna. ");
INSERT INTO log_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Dɨ, ɨ̀ dré àyɨkya màrábà nda nɨ rùzo tswàle gò, logózóá nzɨ̀le drɨ́gálé sè. ");
INSERT INTO log_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Gò amvú líyí nda dré màrábà àzya mùzo lɨ̀le àyɨ véna. Dɨ, ɨ̀ dré akódhɨ nda nɨ drì tswàzo, kanyò fèzo drá. ");
INSERT INTO log_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Amvú líyí nda dré gòzo màrábà nɨ na mu lɨ̀le gò, ɨ̀ dré akódhɨ nda nɨ pfùzo dràle. Dré gòzo màrábà àruka bǐ dhɨ kɨ mu gò, ɨ̀ dré àruka nɨ kɨ tswàzo, àruka nɨ kɨ tupfúzó todràle. ");
INSERT INTO log_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Tayɨ́ tá ngbà ꞌí amvú líyí nda nɨ mváagó dré lèle tò dhɨ kòdhya. Dɨ kùdù ro dhɨ, dré kpà akódhɨ nda nɨ mùzo lɨ̀le àyɨ véna. Adré tá kisùá dhɨ: ‹Ɨ̀ nɨ áma mváagó nɨ lɨndrɨ̀ bha!› ");
INSERT INTO log_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Dɨ, vínò lɨkɨ́bhá nda ɨ̀ dré tàzoá àyɨ kòfalésè dhɨ: ‹Kònàdhɨ dhya dra amvú kònɨ̀dhɨ nɨ kisúlépi tàyɨlé ro dhɨ ꞌɨ. Mà kòlɨ̀ akódhɨ nɨ pfu dràle, amvú dré tá kɨtswálé kisúlé tàyɨlé ro nda kàdréró àma dré!› ");
INSERT INTO log_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Dɨ ɨ̀ dré ngàzo akódhɨ nɨ ru pfùle dràle gò, àbvò nɨ nɨ bhèzo amvú nda ꞌásè kɨvɨ̀ na.» ");
INSERT INTO log_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yésu gò lizíá dhɨ: «Mɨ̀ adré kisùá dhɨ, amvú líyí nda nɨ ꞌòá ngɨ́nɨ? Akódhɨ nɨ tsa vínò lɨkɨ́bhá nda kɨ tupfú todràle gò, gòzo amvú vínò àdhya nda nɨ tayɨ́ móndɨ́ àruka ɨ drɨ́gá. ");
INSERT INTO log_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Mɨ̀ nà rè tà tɨsɨ̀le Gìká nɨ Kúlí na kònɨ̀dhɨ ko? ‹Kɨ́rà dzó sibhá ɨ̀ dré gàle gàgà dhɨ, gò atsálé kɨ́rà agógó dzó nda dré adrézó áyɨ totó drìá dhɨ ró. ");
INSERT INTO log_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Kòrɨ̀dhɨ tà Mírì dré ꞌòle nɨ̀ dhɨ ꞌɨ. Dɨ tà nda lɨ́ndrɨ́ga ró àma mìlésè!›» ");
INSERT INTO log_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Gò Yúdà ànzɨ kɨ kàdrɨ̀ ɨ̀ dré gòzo adrélé láti nda kɨtswázó Yésu nɨ ru dhɨ bvó. Àngyá ko, ɨ̀ nì tá tàle dhɨ, akódhɨ pɨ tá pɨ́dhɨ́gó nda àyɨ rú dhɨ be. Dɨ, ɨ̀ dré tá adrélé móndyá zyandre dhɨ kɨ ro dhɨ sè dhɨ, ɨ̀ dré akódhɨ nɨ tayɨ́zó gò, lɨ̀zo. ");
INSERT INTO log_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Àmvolásà dhɨ, ɨ̀ dré Fàrìsáyò àruka kɨ mùzo móndɨ́ àruka ópɨ́ Èródè àdhya ɨ́be lɨ̀le Yésu véna, kɨtswálé akódhɨ nɨ ꞌo laꞌɨ̀le kúlí dré tá adrélé tàle dhɨ ɨ sílé dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Àyɨ nda ɨ̀ dré tàzoá drá dhɨ: «Tadhálépi, mà nì tàle dhɨ, mɨ́ adré tròle tà bàti rú dhɨ be. Mɨ́ adré kpà móndɨ́ kɨ lɨndrɨ̀ nɨ tà kisù ko, mɨ́ dré adrélé àyɨ kɨ no twátwa ko dhɨ sè. Mɨ́ adré kpà Gìká nɨ tà tadhá tà bàti sè. Dɨ mɨ́ tà rè àma dré ká: Àma kɨ tátrɨ́trɨ́ kúlí kaꞌì, à kàdré Kàyìsárà nɨ mèdáyɨ̀ gɨ dhɨ ꞌí? Kó ngalè, kaꞌì ko? Lè mà kàdré gɨ̀á, kó ngalè mà kàdré gɨ̀á ko?» ");
INSERT INTO log_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Dɨ, Yésu dré ɨ́na àyɨ kɨ túrúpfú tà nìzo kyá gò, logózóá àyɨ dré dhɨ: «Mɨ̀ adré áma tabhì lɨtɨ́lé àdho tà sè? Mɨ̀ afè dènárì àlo dhɨ má dré nòle.» ");
INSERT INTO log_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Dɨ ɨ̀ dré làfa lòꞌwa nda nɨ fèzo drá. Gò dré lizízóá àyɨ tí dhɨ: «Móndɨ́ lɨ́ndrɨ́ kònɨ̀dhɨ tsàle rú tɨsɨ̀le drìá kònɨ̀dhɨ be dhɨ, àdhi àdhya ꞌɨ?» Ɨ̀ logó drá dhɨ: «Kàyìsárà àdhya ꞌɨ.» ");
INSERT INTO log_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Dɨ Yésu tà àyɨ dré dhɨ: «Mɨ̀ kàdré dɨ ngá Kàyìsárà àdhya nɨ fe Kàyìsárà dré, adrézó kpà ngá Gìká àdhya nɨ fe Gìká dré.» Ɨ̀ kòyi akódhɨ nɨ kúlí nda dre dhɨ, àyɨ kɨ lɨ́ndrɨ́ dré gàzo bhwǎbhwa akódhɨ nɨ tà sè. ");
INSERT INTO log_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Àmvolásà dhɨ, Sàdùkáyò àruka ɨ̀ dré alɨ̀zo Yésu vélé kɨtswálé tà lizí tíá. (Àyɨ nda ɨ̀ adré tàá dhɨ, ngangà dràdrà ꞌásè dhɨ yókódhó.) Dɨ ɨ̀ tà drá dhɨ: ");
INSERT INTO log_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Tadhálépi, Mósè tɨsɨ̀ àma dré dhɨ: ‹Agó àlo adrélépi mvá àko dhɨ kòdrà áyɨ tòkó nɨ tayɨ́ dhɨ, lè adrúpi nɨ kòdo tàyɨ́tòkó nda mòle, kɨtswázó ànzɨ ti áyɨ adrúpi dràlepi nda dré.› ");
INSERT INTO log_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Dɨ àgo nzi-drì-rì adrúpi ró dhɨ ɨ tá be. Àyɨ kɨ kàyo dré tòkó àlo dhɨ nɨ mòzo gò, dràzo tólò mvá ti àko ró. ");
INSERT INTO log_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Adrúpi nɨ nɨ rì dré tòkó nda nɨ dòzo mòle gò, dré kpà dràzo tólò mvá ti àko ró. Tà nda dré kpà ru ꞌòzo kònɨ̀nɨ adrúpi nɨ nɨ na rú, ");
INSERT INTO log_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","tsàle byá adrúpi nɨ nɨ nzi-drì-rì rú. Àyɨ títí nda ɨ̀ todrà mvá ti àko ró. Kùdù ro dhɨ, tòkó nda dré kpà dràzo. ");
INSERT INTO log_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Dɨ kìtú móndɨ́ ɨ̀ dré dra ngàzo dràdrà ꞌásè dhɨ tú dhɨ, adrúpi nzi-drì-rì nda ɨ kòfalé dhɨ, tòkó nda nɨ adré tsítsì dhɨ àdhi dré? Àngyá ko, àyɨ títí nda ɨ̀ do tá akódhɨ mòle àyɨ dré tòko ró.» ");
INSERT INTO log_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yésu logó àyɨ dré dhɨ: «Mɨ̀ lɨtɨ́ àmɨ kɨ tàndɨ ɨ dre, mɨ̀ dré Gìká nɨ Kúlí ɨ rìnyí nɨ ɨ́be dhɨ kɨ nìle ko dhɨ sè. ");
INSERT INTO log_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kìtú móndɨ́ ɨ̀ dré dra ngàzo dràdrà ꞌásè dhɨ tú dhɨ, ɨ̀ gò adrélé ru mo ko. Ɨ̀ gò kpà adrélé àyɨ kɨ ànzɨ kɨ fe mòle ko. Be ró dhɨ, ɨ̀ nɨ àyɨkya adré ngóró ángéló bhù na dhɨ ɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Dɨ, kàdré ɨ́na ngangà dràdrà ꞌásè dhɨ nɨ tà sè dhɨ, mɨ̀ nà rè Mósè nɨ búkù na, tà Gìká dré tá tàle drá fanzɨ̌ adrélépi kòle àtsɨ ró dhɨ na dhɨ ko? Akódhɨ tà tá dhɨ: ‹Ma Gìká Àbàrámà àdhya ꞌɨ, Ɨ̀sákà àdhya ꞌɨ, ɨ̀ndɨ̀ Yàkóbhò àdhya ꞌɨ.› ");
INSERT INTO log_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Dɨ Gìká nda Gìká àbvò kya ꞌɨ ko. Be ró dhɨ, akódhɨ ɨ́na Gìká móndyá lɨ́drɨ̀ ro dhɨ kya ꞌɨ. Mɨ̀ lɨtɨ́ àmɨ tà tàndɨ ró dre.» ");
INSERT INTO log_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Tátrɨ́trɨ́ kúlí tadhábhá kɨ àlo kòyi àyɨ nda ɨ tà kayíràꞌa àyɨ kòfalésè dre dhɨ, dré atógyàzoá dhɨ, Yésu logó kúlí àyɨ dré kyá. Dɨ dré áyɨ kisízó ànyɨ akódhɨ làga, akódhɨ nɨ lizí tàzoá dhɨ: «Tòlɨ́ títí dhɨ ɨ kòfalé dhɨ, tòlɨ́ kàdrɨ̀ lavúlé dhɨ ángùdhi ꞌɨ?» ");
INSERT INTO log_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yésu logó drá dhɨ: «Tòlɨ́ kàdrɨ̀ lavúlé dhɨ, kònɨ̀dhɨ ꞌɨ: ‹Ɨ̀sèrélè ànzɨ ɨ, mɨ̀ yi rè ká! Mírì àma kɨ Gìká, Mírì ꞌɨ kalóma. ");
INSERT INTO log_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Lè mɨ́ kàdré Mírì ámɨ Gìká nɨ le ámɨ togó sè wä́yi, ámɨ lɨ́drɨ̀ sè wä́yi, ámɨ tà kisùkisù sè wä́yi, ɨ̀ndɨ̀ ámɨ rìnyí sè wä́yi.› ");
INSERT INTO log_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Tòlɨ́ nɨ rì, kònɨ̀dhɨ ꞌɨ: ‹Lè mɨ́ kàdré ámɨ àzya nɨ le ngóró mɨ́ dré adrélé ámɨ tàndɨ nɨ le dhɨ tɨ́nɨ.› Tòlɨ́ àzya kàdrɨ̀ tòlɨ́ rì kòdhɨ kɨ lavúlépi dhɨ yókódhó.» ");
INSERT INTO log_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Dɨ tátrɨ́trɨ́ kúlí tadhálépi nda tà drá dhɨ: «Tadhálépi, tà mɨ́ dré tàle kòdhɨ, tà bàti ꞌɨ. Mɨ́ tà kyá tàle dhɨ, Gìká ngbà ꞌí àlo kwákwá, ɨ̀ndɨ̀ àzya nɨ akódhɨ rúsè dhɨ yókódhó. ");
INSERT INTO log_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Adrélé Gìká nɨ le togó wä́yi sè, tà nìnì wä́yi sè ɨ̀ndɨ̀ rìnyí wä́yi sè dhɨ, ɨ̀ndɨ̀ adrélé dhyá kɨ àzya nɨ le dhyá kɨ tàndɨ tɨ́nɨ dhɨ kàdrɨ̀ lavúlé, kàꞌwá títí adrélé zàle mòbòmà ro dhɨ ɨ rúsè, ɨ̀ndɨ̀ ngá títí adrélé fèle Gìká dré mòbòmà ro dhɨ ɨ rúsè.» ");
INSERT INTO log_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Dɨ Yésu kònò akódhɨ logó tá kúlí tògyá sè dhɨ dre dhɨ, dré tàzoá drá dhɨ: «Mɨ vwàvwà ro Gìká nɨ Òpɨ̀ rúsè ko.» Dɨ kɨdhólé lókyá nda sè dhɨ, dhya àlo dré gòzo vélé tà tabhì lizílé akódhɨ tí ko. ");
INSERT INTO log_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yésu dré tá adréràꞌa tà tadhá móndɨ́ ɨ dré tépelò na dhɨ ꞌá dhɨ, dré lizízóá dhɨ: «Tátrɨ́trɨ́ kúlí tadhábhá ɨ̀ adré tàá dhɨ, Mèsɨ́yà Dàwídì nɨ mvá ꞌɨ dhɨ ngɨ́nɨ? ");
INSERT INTO log_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Tàko ko, Dàwídì nɨ tàndɨ tà tá Tɨrɨ́ Lólo nɨ rìnyí sè dhɨ: ‹Mírì Gìká tà áma Mírì dré dhɨ: Mɨ́ alɨ̀ lɨrɨ́lé áma drɨ́ágó lésè, tsàle lókyá má dré dra ámɨ kàrɨbhá kɨ bhàzo adrélé ámɨ pá zàle dhɨ ꞌá.› ");
INSERT INTO log_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Kòdhɨ Dàwídì nɨ tàndɨ adré Mèsɨ́yà nɨ zi áyɨ Mírì ro. Dɨ Mèsɨ́yà nda nɨ kɨtswá kpà adrélé akódhɨ nɨ mvá ro ngɨ́nɨngɨ́nɨ ró?» Dɨ móndyá zyandre lavúlé nda ɨ̀ adré tá akódhɨ nɨ yi lovó sè. ");
INSERT INTO log_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yésu dré rè dhu adréràꞌa àyɨ kɨ tadhá dhɨ ꞌá dhɨ, dré tàzoá dhɨ: «Mɨ̀ kàdré àmɨ kɨ lɨkɨ́ tátrɨ́trɨ́ kúlí tadhábhá kɨ tà sè. Àngyá ko, àyɨ nda ɨ̀ adré kánzò kàtswákàtswa dhɨ kɨ le asólé àyɨ rú, adrézó tatsílé ába móndɨ́ ɨ kòfalésè. Ɨ̀ adré lèá dhɨ, à kàdré mòdo fe àyɨ dré lɨndrɨ̀ sè ngá lagɨ́rà ɨ ꞌásè. ");
INSERT INTO log_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ɨ̀ adré lèá lɨrɨ́lé àrà lɨndrɨ̀ àdhya lɨ̀sámbò dzó ɨ ꞌásè dhɨ ɨ ꞌásè, adrézó kpà lèá lɨrɨ́lé mɨ́sá lɨndrɨ̀ àdhya gwányá ɨ ꞌásè dhɨ ɨ làgásè. ");
INSERT INTO log_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ɨ̀ adré tàyɨ́tòkó kɨ ngá kɨ kärí títí. Ɨ̀ adré kpà tà zi Gìká tí vwàvwà ro, à kònòró àyɨ be dhɨ bvó. Dɨ kìtú dra tàbvó tàzo dhɨ tú dhɨ, à nɨ tà ŋo àyɨ dri tà tàndɨ ró.» ");
INSERT INTO log_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Àmvolásà dhɨ, Yésu dré lɨrɨ́zó tépelò na, àrà adrézó làfa fe Gìká dré dhɨ kandrá, adrélé móndɨ́ zyandre dhɨ kɨ no adréràꞌa àyɨ kɨ làfa bhe kpúkúbhú adrézó làfa lɨkɨ́ dhɨ na. Ngábhá bǐ dhɨ ɨ̀ adré tá làfa bhe lána bǐ. ");
INSERT INTO log_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Gò tàyɨ́tòkó àlo lemerè ro dhɨ dré kpà alɨ̀zo làfa lòꞌwa nzɨ̌ tsàtsà rì làgɨ́ be tsà dhɨ kɨ bhe lána. ");
INSERT INTO log_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Dɨ Yésu dré áyɨ lebèbhá kɨ azízó, tàzoá àyɨ dré dhɨ: «Má adré tà bàti ta àmɨ dré: Tàyɨ́tòkó lemerè ro kòdhɨ bhà ɨ́na kpúkúbhú na làfa kàdrɨ̀, móndyá àruka títí dhɨ kya kɨ lavú. ");
INSERT INTO log_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Tàko ko, àyɨ títí nda ɨ̀ adó àyɨkya àyɨ kɨ ngá kɨ drì fèle kòdhya. Dɨ, tòkó lemerè ro nda adó ɨ́na ngá títí ɨ́ dré tá adrézó ába kɨtswázó adrɨ́lé ásà dhɨ ɨ fèle kòdhya.» ");
INSERT INTO log_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yésu dré tá adréràꞌa apfòle tépelò lésè dhɨ ꞌá dhɨ, akódhɨ nɨ lebèbhá kɨ àlo dré tàzoá drá dhɨ: «Tadhálépi, mɨ́ nò rè dzó kàdrɨ̀ gú kònɨ ɨ, àyɨ kɨ kɨ́rà ɨ́be ká!» ");
INSERT INTO log_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Dɨ Yésu logó drá dhɨ: «Mɨ́ nò tsì dzó kàdrɨ̀ kònɨ ɨ ꞌí? Lókyá adrélépi alɨ̀le dhɨ sè dhɨ, à gò vélé àyɨ kɨ kɨ́rà kɨ àlo kisú àzya nɨ dri ko. À nɨ kɨ́rà nda kɨ lebhé títí kìní mi.» ");
INSERT INTO log_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Àmvolásà dhɨ, Yésu ɨ̀ dré lɨ̀zo mbàle kòngó Òlívè fa kya drìna gò, akódhɨ dré lɨrɨ́zó àrà kɨtswázó tépelò no lásà bwà dhɨ na. Gò Pétèró, Yàkóbhò, Yòwánɨ̀, tsàle Àndréyà be dhɨ ɨ̀ dré akódhɨ nɨ lizízó àyɨ pátí, tàzoá dhɨ: ");
INSERT INTO log_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«Mɨ́ tà rè àma dré, tà nda kòdhɨ kɨ atsá ángutú ya dhɨ ká? Àdho tà nɨ ru ꞌo drìdrì tadházóá dhɨ, tà títí nda ɨ̀ adré ꞌòle ru ꞌo káyà dhɨ nɨ̀?» ");
INSERT INTO log_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yésu logó àyɨ dré dhɨ: «Mɨ̀ kàdré àmɨ kɨ lɨkɨ́ dóro, dhya àlo kòlɨtɨ́ró àmɨ ko. ");
INSERT INTO log_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Tàko ko, móndɨ́ bǐ dhɨ kɨ alɨ̀ áma rú sè adrélé tàá dhɨ, ‹Ma Mèsɨ́yà ꞌɨ!› gò, ɨ̀ dré móndɨ́ zyandre dhɨ kɨ lɨtɨ́zó. ");
INSERT INTO log_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Mɨ̀ nɨ àdzú kɨ kpòrò yi ànyɨ, adrézó kpà àdzú kɨ rúbí yi làwú làvo na. Dɨ, mɨ̀ kòtayɨ́ àmɨ kɨ togó adrélé gàle ásà dhɨ ko. Tàko ko, adré lèá dhɨ, tà nda kòdhɨ ɨ̀ kòꞌo rè zyà ru ꞌíká. Dɨ, lókyá kùdù atsá rè ko. ");
INSERT INTO log_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Súrú kɨ àdzú bhu súrú àruka ɨ́be. Òpɨ̀ kɨ kpà àdzú bhu òpɨ̀ àruka ɨ́be. Kàdíkàdi nɨ bvò kosé, ɨ̀ndɨ̀ kàrábhò nɨ dhe àrà twátwa ɨ ꞌásè. Dɨ, tà nda kòdhɨ kɨ ngbà ꞌí adré ngóró tòkó nɨ mváaswa nɨ kɨdhoma tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Dɨ àmɨ ró dhɨ, mɨ̀ kàdré àmɨ kɨ lɨkɨ́ dóro. Tàko ko, à nɨ àmɨ kɨ ꞌo topfòle tàbvó tǎrà ɨ ꞌásè, adrézó àmɨ kɨ bhwa lɨ̀sámbò dzó ɨ ꞌásè. Áma tà sè dhɨ, mɨ̀ nɨ àmɨ kɨ totó gùvèrènérè ɨ kandrá ɨ̀ndɨ̀ ópɨ́ kàdrɨ̀ ɨ kandrá, mɨ̀ kòkɨtswáró áma tà mɨ̀ dré nòle ɨ̀ndɨ̀ mɨ̀ dré yìle dhɨ kɨ longó àyɨ dré be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Tàko ko, adré lèá dhɨ, à kòlongó rè zyà Rúbí Tanɨ súrú títí ɨ dré ꞌíká. ");
INSERT INTO log_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Dɨ, à kàdré àmɨ kɨ dri tàbvó tàle dhɨ, mɨ̀ kòbhà àmɨ kɨ togó adrélé lanzìle tà mɨ̀ dré dra tàle àmɨ rúsè dhɨ dri dhɨ ko. Be ró dhɨ, mɨ̀ kàdré ndɨrɨ tà Gìká dré dra fèle àmɨ dré tàle lókyá nda sè dhɨ nɨ ta kòdhya. Àngyá ko, mɨ̀ nɨ adré tà nda nɨ ta àmɨ ko. Be ró dhɨ, Tɨrɨ́ Lólo nɨ adré tàá nɨ̀. ");
INSERT INTO log_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Móndɨ́ kɨ àyɨ kɨ adrúpi kɨ lefè todràle kàrɨbhá ɨ drɨ́gá. Ànzɨ kɨ atá kɨ kpà àyɨ kɨ ànzɨ kɨ lefè todràle. Ànzɨmvá kɨ lɨgɨ́ àyɨ kɨ tibhá ɨ rú, adrézó àyɨ kɨ ꞌo todràle. ");
INSERT INTO log_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Móndyá títí dhɨ kɨ togó kònzɨ bha àmɨ rú áma tà sè. Dɨ, dhya adrélépi ɨ́na togó tsɨ, adrézó áyɨ totó tätä tsàle kùdù na dhɨ nɨ adrɨ́.» ");
INSERT INTO log_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«Dɨ mɨ̀ nɨ ‹ngá adrélé gàle gàgà adrélépi ngá lólo dhɨ kɨ kɨzá dhɨ› nɨ no adréràꞌa áyɨ totó àrà kɨtswálépi tá kàdré lána ko dhɨ na. (Lè dhya adrélépi tà kòdhɨ nɨ na dhɨ kàdré àndu nɨ nɨ ni dóro.) Lókyá nda sè dhɨ, lè móndyá dra adrébhá bvò Yùdáyà àdhya na dhɨ ɨ̀ kòlapá ràle kòngó ɨ drìna. ");
INSERT INTO log_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Lè kpà dhya dra adrélépi áyɨ dzó drìna dhɨ kàsí fɨ̀le dzó na, áyɨ ngá kɨ do lapázó ába dhɨ ko. ");
INSERT INTO log_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Dhya dra adrélépi amvú na dhɨ kògò nzɨ̀le ɨ́ bhàna áyɨ kɨ́tá kɨdhɨ̀ àdhya nɨ do lapázó ába dhɨ ko. ");
INSERT INTO log_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kìtú nda ɨ tú dhɨ, kɨzà nɨ adré kàdrɨ̀ tòkó adrébhá ꞌa ɨ́be dhɨ ɨ dré, ɨ̀ndɨ̀ tòkó adrébhá bà fe ànzɨmvá ɨ dré dhɨ ɨ dré. ");
INSERT INTO log_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mɨ̀ kàdré tà zi Gìká tí, àmɨ kɨ lapama nda kàdréró kɨdhɨ̀ lókyá sè ko. ");
INSERT INTO log_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Tàko ko, kɨzà kìtú nda kya nɨ adré kàdrɨ̀ lavúlé. À nò rè kɨzà kárá be kònɨ̀nɨ nda ko, kɨdhólé Gìká dré bvò bhǎrà lésè atsálé ándrò kònɨ̀dhɨ. À kɨtswá kpà gòle vélé nòá tàdzí ko. ");
INSERT INTO log_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kònò Mírì kòkɨ tá kìtú nda kɨ bvó ko dhɨ, dhya àlo bvò dri dhɨ kɨtswá tá adrɨ́lé bwà ko. Dɨ, Mírì kɨ ɨ́na kìtú nda kɨ bvó móndyá ɨ́ dré zɨ̀le dhɨ kɨ tà sè. ");
INSERT INTO log_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Lókyá nda sè dhɨ, à kàdré tàá àmɨ dré dhɨ ‹Mɨ̀ nò rè ká, Mèsɨ́yà kònwa!› dhɨ, mɨ̀ kòkaꞌì ko. À kàdré kó tàá dhɨ ‹Akódhɨ kònàle!› dhɨ, mɨ̀ kòkaꞌì ko. ");
INSERT INTO log_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Tàko ko, mèsɨ́yà kɨnzò ro dhɨ kɨ apfò pròfétà kɨnzò ro dhɨ ɨ́be adrélé tà kàdrɨ̀ lɨ́ndrɨ́ga ró adrébhá àyɨ kɨ rìnyí tadhá dhɨ kɨ ꞌo, kòkɨtswá dhɨ, ɨ̀ dré ndɨ̀ndɨ̀ móndyá Gìká dré zɨ̀le dhɨ kɨ lɨtɨ́zó. ");
INSERT INTO log_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Má longó àmɨ dré tà nda kòdhɨ ɨ títí drìdrì. Dɨ mɨ̀ kàdré tàmìga dri.» ");
INSERT INTO log_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«Kìtú nda ɨ tú, kɨzà kàdrɨ̀ nda àmvolésè dhɨ, ‹kìtú nɨ mì nɨ atsá tínímvá ro, mbǎ gò vélé mvèle ko, ");
INSERT INTO log_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","bhìbhínyà kɨ ledhé bhù lésè, ɨ̀ndɨ̀ rìnyí bhù na dhɨ kɨ ru kɨzɨ́.› ");
INSERT INTO log_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Dɨ lókyá nda sè dhɨ, móndyá títí dhɨ kɨ Móndɨ́ nɨ Mvá nɨ no adréràꞌa alɨ̀le ndùrùku ɨ ꞌásè, rìnyí kàdrɨ̀ be ɨ̀ndɨ̀ mìlanzìlanzì kàdrɨ̀ be. ");
INSERT INTO log_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Gò akódhɨ dré áyɨ ángéló kɨ mùzo lɨ̀le áyɨ móndyá ɨ́ dré zɨ̀le dhɨ kɨ kɨmó bvò nɨ pá su dhɨ ɨ lésè, kɨdhólé bvò nɨ kùdù lésè, tsàle byá bhù nɨ kùdù na.» ");
INSERT INTO log_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","«Lè mɨ̀ kàdré tà tadhálé fígì fa nɨ tà rú dhɨ nɨ àndu ni dóro. Fígì fa nɨ dríti kàdré atsálé màlɨmálɨ gò, bí nɨ dré adrézó ròle dhɨ, mɨ̀ nì tàle dhɨ, yǐgú ànyɨ dhɨ be. ");
INSERT INTO log_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Kókpà kòdhɨ tɨ́nɨ, lókyá mɨ̀ dré dra tà nda kòdhɨ kɨ nòzo adréràꞌa ru ꞌo dhɨ tú dhɨ, lè mɨ̀ kònì tàle dhɨ, Móndɨ́ nɨ Mvá láti ꞌá, ndɨ̀ndɨ̀ àmɨ kɨ dzó tí káyà dhɨ. ");
INSERT INTO log_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Má adré tà bàti ta àmɨ dré: Móndyá dra adrébhá lɨ́drɨ̀ ɨ́be lókyá nda sè dhɨ ɨ̀ kɨtswá dràle títí drìdrì tà títí nda ɨ̀ dré dra ru ꞌòzo dhɨ kandrá ko. ");
INSERT INTO log_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Bhù ɨ bvò be dhɨ kɨ akɨ́. Dɨ, áma kúlí ɨ̀ kɨtswá àyɨkya tàdzí akɨ́lé ko.» ");
INSERT INTO log_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","«Dɨ, dhya àlo nì ɨ́na kìtú ꞌɨ yà, kó ngalè sáà ꞌɨ yà tà nda ɨ̀ dré dra ru ꞌòzo dhɨ ko. Ndɨ̀ndɨ̀ ángéló bhù na dhɨ ꞌɨ yà, kó ngalè Gìká nɨ Mváagó ꞌɨ yà dhɨ, ɨ̀ nì ko. Gìká Atá nì ngbà ꞌí nɨ̀ kalóma. ");
INSERT INTO log_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Adré dɨ lèá dhɨ, mɨ̀ kàdré àmɨ kɨ lɨkɨ́, adrézó tàmìga dri! Tàko ko, mɨ̀ nì ngalè lókyá nda nɨ atsá ángutú ya dhɨ ko. ");
INSERT INTO log_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Tà nda kòdhɨ ngóró agó àlo adrélépi ꞌòle lɨ̀le atsí na dhɨ àdhya tɨ́nɨ. Akódhɨ nda adré rìnyí fe áyɨ màrábà àlo àlo títí dhɨ ɨ dré adrézó àyɨ kɨ àzí ꞌo gò, dré adrézó tàá dhya adrélépi dzóti lɨkɨ́ dhɨ dré dhɨ, kàdré tàmìga dri. Dɨ dré adrézó dzó nda nɨ tayɨ́ lɨ̀zo. ");
INSERT INTO log_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Mɨ̀ kàdré dɨ tàmìga dri. Àngyá ko, mɨ̀ nì lókyá ángùdhi dzó líyí nda dré dra agòzo ásà dhɨ ko, gba kàdré ɨ̀ndró sè yà, ngátsi kɨ́tógá sè yà, àgólòwa dré tsírà bheràꞌa yà, kó ngalè drùbhì sè yà dhɨ. ");
INSERT INTO log_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Dɨ akódhɨ kàgò ngbǒ ró dhɨ, mɨ̀ kòtayɨ́ àmɨ akódhɨ dré kisúlé adréràꞌa ayí ko dhɨ ko. ");
INSERT INTO log_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Tà má dré adrélé tàle àmɨ dré kònɨ̀dhɨ, má adré kpà tàá móndyá títí ɨ dré: Mɨ̀ kàdré tàmìga dri!» ");
INSERT INTO log_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Tayɨ́ tá kìtú rì gwányá Pásɨkà àdhya ɨ Mápà tàkú àko dhɨ àdhya be dhɨ ɨ̀ dré atsázó. Kòwánà kàdrɨ̀ ɨ tátrɨ́trɨ́ kúlí tadhábhá ɨ́be dhɨ ɨ̀ adré tá láti nda kɨtswázó Yésu nɨ ru túrúpfú sè, pfùle dràle. ");
INSERT INTO log_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Dɨ, ɨ̀ adré tá tàá dhɨ, ɨ̀ kòꞌo tà nda gwányá Pásɨkà àdhya tú ko, móndyá zyandre dhɨ ɨ̀ kòlɨgɨ́ró àyɨ ɨ́be ko sè. ");
INSERT INTO log_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Lókyá nda sè dhɨ, Yésu lɨ̀ tá Bètànɨ́yà na, fɨ̀le Sìmónà atú kàrɨ́ dré tá rùle dhɨ nɨ dzó na gò, dré lɨrɨ́zó mɨ́sá làga kɨtswálé ngá nya. Gò tòkó àlo dhɨ dré afɨ́zó mòlàngɨ̀ mvá ledélé àlàbásterè sè, gàlepi màlásɨ̀ làgɨ́ kyàkyà dhɨ sè bǐ dhɨ be. À ladhɨ́ tá màlásɨ̀ nda tsèrèlè náradà sè. Dɨ tòkó nda dré mòlàngɨ̀ nda nɨ ti ŋòzo gò, màlásɨ̀ nda nɨ dàzo Yésu dri. ");
INSERT INTO log_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Móndɨ́ àruka adrébhá tá dzó nda ꞌá dhɨ ɨ̀ kònò tà nda dre dhɨ, àyɨ kɨ togó dré aswázó gò, ɨ̀ dré adrézó tàá àyɨ kòfalésè dhɨ: «À kɨzá tsì màlásɨ̀ kòdhɨ àdho tà sè? ");
INSERT INTO log_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Kònò à nɨ tá kɨtswá lagɨ́á làfa lòꞌwa kámá-na sè gò, làfa nda nɨ fèzo lemerèbhá ɨ dré!» Dɨ ɨ̀ dré adrézó tòkó nda nɨ ndrɨ tà tàndɨ ró. ");
INSERT INTO log_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Dɨ, Yésu dré tàzoá àyɨ dré dhɨ: «Mɨ̀ tayɨ́ tòkó kònɨ̀dhɨ. Mɨ̀ adré akódhɨ nɨ drì kɨzá àdho tà sè? Tà dré ꞌòle má dré kòdhɨ, tà avélépi tò dhɨ ꞌɨ. ");
INSERT INTO log_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Àngyá ko, mɨ̀ adré ngbú adrélé lemerèbhá ɨ́be àmɨ kòfalé, ɨ̀ndɨ̀ mɨ̀ kɨtswá àyɨ kɨ ledé lókyá ángùdhi mɨ̀ dré adrélé lèle dhɨ sè. Dɨ, mɨ̀ kɨtswá ngbú adrélé túmä́ní má be ko. ");
INSERT INTO log_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Tòkó kònɨ̀dhɨ ꞌo tà dré tá kɨtswálé ꞌòle dhɨ kòdhya. Dà màlásɨ̀ má rú drìdrì, kɨtswázó áma rúbhá ledé bhàle mógó na dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Má adré tà bàti ta àmɨ dré: Àrà títí bvò wä́yi ꞌásè à dré dra Rúbí Tanɨ longózó dhɨ ɨ ꞌásè dhɨ, à nɨ kókpà tà tòkó kònɨ̀dhɨ dré ꞌòle kòdhɨ nɨ tɨtɨ́, akódhɨ nɨ tà kisùzo.» ");
INSERT INTO log_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Àmvolásà dhɨ, Yùdásɨ̀ Ɨ̀sɨ̀kàrɨ̀yótà, Yésu nɨ lebèbhá mudrí-drì-rì dhɨ kɨ àlo dré ngàzo lɨ̀le tà ta kòwánà kàdrɨ̀ ɨ́be, kɨtswázó Yésu nɨ lefè àyɨ drɨ́gá dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Àyɨ nda ɨ̀ kòyi tà dré tàle nda dre dhɨ, ɨ̀ dré lenzézó ásà gò, ɨ̀ dré lazízóá dhɨ, ɨ̀ nɨ làfa fe drá. Dɨ Yùdásɨ̀ dré kɨdhózó adrélé lókyá dóro Yésu nɨ lefèzo àyɨ drɨ́gá dhɨ nɨ nda. ");
INSERT INTO log_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Gwányá Mápà tàkú àko dhɨ àdhya nɨ kìtú nɨ àlo adrézó kábilígyà mvá Pásɨkà àdhya nɨ pfu dràle mòbòmà ro dhɨ sè dhɨ, Yésu nɨ lebèbhá ɨ̀ dré akódhɨ nɨ lizízó tàzoá dhɨ: «Mɨ́ adré lèá dhɨ, mà kòlɨ̀ ngá ladhɨ́ mɨ́ dré gwányá Pásɨkà àdhya nɨ nyàzo dhɨ ángwà?» ");
INSERT INTO log_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Dɨ Yésu dré áyɨ lebèbhá rì dhɨ kɨ mùzo, tàzoá àyɨ dré dhɨ: «Mɨ̀ lɨ̀ bhàandre na. Mɨ̀ nɨ drì si agó àlo adrélépi yǐ do lɨ̀drɨ́ na dhɨ be. Mɨ̀ dhe akódhɨ nda bvó. ");
INSERT INTO log_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Dzó dré dra fɨ̀zo lána dhɨ na dhɨ, mɨ̀ kòtà dzó nda nɨ líyí dré dhɨ: ‹Dhya tà tadhálépi dhɨ adré ámɨ lizí: Dzó ꞌa kɨ̀le mà dré kɨtswázó Pásɨkà nya áma lebèbhá ɨ́be dhɨ ángwà?› ");
INSERT INTO log_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Dɨ akódhɨ nda nɨ dzó ꞌa kɨ̀le kàdrɨ̀ kurú na dhɨ nɨ tadhá àmɨ dré. À tobhà mɨ́sá ɨ ngá àruka ɨ́be tayɨ́lé lána gànzi ró. Mɨ̀ kòladhɨ́ ngá àma dré kònàle.» ");
INSERT INTO log_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Dɨ akódhɨ nɨ lebèbhá nda ɨ̀ dré lɨ̀zo bhàandre na gò, ɨ̀ dré tà títí nda kɨ kisúzó ngóró dré tá tàle àyɨ dré dhɨ tɨ́nɨ. Gò ɨ̀ dré ngá ladhɨ́zó kɨtswázó gwányá Pásɨkà àdhya nɨ nya. ");
INSERT INTO log_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ɨ̀ndró kàndrɨ̀ dre dhɨ, Yésu ɨ̀ dré tsàzo lɨrɨ́lé mɨ́sá làgásè túmä́ní akódhɨ nɨ lebèbhá mudrí-drì-rì dhɨ ɨ́be. ");
INSERT INTO log_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ɨ̀ dré tá adréràꞌa ngá nya dhɨ ꞌá dhɨ, Yésu dré tàzoá dhɨ: «Má adré tà bàti ta àmɨ dré: Àmɨ kɨ àlo adrélépi ngá nya túmä́ní má be dhɨ nɨ áma lefè kàrɨbhá ɨ drɨ́gá.» ");
INSERT INTO log_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Dɨ kɨzà dré àyɨ kɨ ꞌòzo gò, àyɨ àlo àlo títí dhɨ ɨ̀ dré kɨdhózó adrélé tàá drá dhɨ: «Zakó ɨ́na ma ꞌɨ ko?» ");
INSERT INTO log_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Akódhɨ logó àyɨ dré dhɨ: «Akódhɨ nda àmɨ mudrí-drì-rì nɨ kɨ àlo ꞌɨ. Akódhɨ dhya adrélépi mápà so má be sǎnɨ̀ àlo na dhɨ ꞌɨ. ");
INSERT INTO log_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Tà bàti ró dhɨ, Móndɨ́ nɨ Mvá nɨ lɨ dràle ngóró tɨsɨ̀le akódhɨ nɨ tà dri Gìká nɨ Kúlí na dhɨ tɨ́nɨ. Dɨ, kɨzà nɨ ɨ́na adré kàdrɨ̀ dhya dra Móndɨ́ nɨ Mvá nda nɨ lefèlepi dhɨ dré! Dóro nɨ tá dhya nda nɨ tìle ko dhɨ.» ");
INSERT INTO log_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ɨ̀ dré tá adréràꞌa ngá nya dhɨ ꞌá dhɨ, Yésu dré mápà adózó, tà tanɨ zìzo drìá Gìká tí gò, ŋòzoá fèle áyɨ lebèbhá ɨ dré gò, tàzoá dhɨ: «Mɨ̀ do nyàle. Kònɨ̀dhɨ áma rúbhá ꞌɨ.» ");
INSERT INTO log_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Dré kpà kópò adózó, àwoyà tàzo Gìká dré gò, fèzoá àyɨ dré. Dɨ àyɨ títí nda ɨ̀ dré mvùzoá. ");
INSERT INTO log_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Dré tàzoá àyɨ dré dhɨ: «Kònɨ̀dhɨ áma kàrɨ́ adrélépi tà Gìká dré bhàle ru yìzo móndɨ́ ɨ́be dhɨ nɨ ꞌo kɨtswálé títí dhɨ ꞌɨ. Kàrɨ́ nda nɨ kutú móndɨ́ zyandre ɨ dré. ");
INSERT INTO log_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Má adré tà bàti ta àmɨ dré: Má gò vélé vínò mvu ko, tsàle kìtú má dré dra vínò tɨ́dhɨ́ ro dhɨ nɨ mvùzo Gìká nɨ Òpɨ̀ na dhɨ tú.» ");
INSERT INTO log_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Dɨ ɨ̀ dré longó ngòzo lenzézó Gìká nɨ rú sè gò, ɨ̀ dré pfòzo lɨ̀le mbàle kòngó Òlívè fa kya drìna. ");
INSERT INTO log_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Gò Yésu dré tàzoá àyɨ dré dhɨ: «Àmɨ títí, mɨ̀ nɨ áma tayɨ́ adrélé kalóma. Tàko ko, Gìká nɨ Kúlí adré tàá dhɨ: ‹Má nɨ kábilígyà lɨkɨ́lépi nɨ tswa dràle gò, à dré kábilígyà nda kɨ ꞌòzo ayɨ́lé.› ");
INSERT INTO log_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Dɨ, má kònga mána dràdrà ꞌásè dre dhɨ, má nɨ lɨ drìdrì àmɨ kandrána Gàlìláyà na.» ");
INSERT INTO log_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Dɨ Pétèró tà drá dhɨ: «Tágba móndyá títí dhɨ ɨ̀ kòtayɨ́ mɨ yà dhɨ, má kɨtswá mána ámɨ tayɨ́ tàdzí ko!» ");
INSERT INTO log_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yésu logó drá dhɨ: «Má adré tà bàti ta mɨ́ dré: Ndɨ̀ndɨ̀ ngátsi ándrò kònɨ̀dhɨ sè, drìdrì àgólòwa dré dra tsírà bhèzo vésè be rì dhɨ kandrá dhɨ, mɨ́ nɨ mɨ́na áma ga vésè be na.» ");
INSERT INTO log_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Dɨ, Pétèró gò logóá drá rìnyí sè dhɨ: «Tágba kòkɨtswá mà dré dràzo túmä́ní mɨ́ be yà dhɨ, má kɨtswá tàdzí ámɨ ga ko.» Gò Yésu nɨ lebèbhá àruka títí dhɨ ɨ̀ dré kókpà tàzoá kònɨ̀nɨ. ");
INSERT INTO log_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Àmvolásà dhɨ, Yésu ɨ̀ dré lɨ̀zo lebèbhá nɨ ɨ́be tsàle àrà rú zìle Gètèsèmánì dhɨ na. Gò dré tàzoá àyɨ dré dhɨ: «Mɨ̀ lɨrɨ́ kònwa, má kòlɨ̀ró adrélé tà zi Gìká tí.» ");
INSERT INTO log_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Dré Pétèró kɨ drìzo Yàkóbhò ɨ́be ɨ̀ndɨ̀ Yòwánɨ̀ be ɨ́ vésè. Gò akódhɨ nɨ togó dré kɨdhózó adrélé kɨzà nya, adrézó lanzìle lavúlé. ");
INSERT INTO log_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Dɨ dré tàzoá àyɨ dré dhɨ: «Áma togó adré ŋòle kɨzà dré, tsàle ndɨ̀ndɨ̀ dràdrà mìle. Mɨ̀ kàdré kònwa, adrélé tàmìga dri.» ");
INSERT INTO log_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Kòlɨ̀ vwàle àyɨ rúsè tsà dre dhɨ, dré dhèzo kìní mi adrélé tà zi Gìká tí, kòkɨtswá mìlásà dhɨ, lókyá kɨzà àdhya nda kòngaró ɨ́ rúsè be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Adré tá tàá dhɨ: «Ábbà, Tátá, mɨ rìnyí ɨ́be kɨtswázó tà títí dhɨ kɨ ꞌo. Mɨ́ kòdo kópò kɨzà àdhya kòdhɨ má vélésè wà. Dɨ, mɨ́ kòꞌo tà má dré adrélé lèle dhɨ kòdhya ko. Be ró dhɨ, mɨ́ kòꞌo tà mɨ́ dré adrélé lèle dhɨ kòdhya.» ");
INSERT INTO log_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Gò dré gòzo áyɨ lebèbhá nda ɨ véna, àyɨ kɨ kisú ayí na. Dré tàzoá Pétèró dré dhɨ: «Sìmónà, mɨ́ adré ayí ko? Mɨ́ kɨtswá tá tsì adrélé tàmìga dri ngbà ꞌí sáà àlo bwà ko? ");
INSERT INTO log_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Lè mɨ̀ kàdré tàmìga dri, adrélé kpà tà zi Gìká tí, kòtayɨ́ró àmɨ tà dré tabhìle, àmɨ kɨ ꞌòzo dhèle tàkonzɨ̀ na dhɨ ko. Bàti, dhyá kɨ togó àtsɨ ró adrézó tà dóro ꞌo. Dɨ, dhyá kɨ rúbhá ɨ́na yàyà.» ");
INSERT INTO log_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Yésu dré gòzo tódhyá lɨ̀le tà zi Gìká tí ngóró dré tá zìle drìdrì dhɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Gò dré gòzo tódhyá gòle àyɨ kɨ kisú ayí na, àyɨ kɨ mì dré tá adrélé ayí ro dhɨ sè. Dɨ ɨ̀ nì tá vélé ɨ̀ nɨ kúlí logó drá ngɨ́nɨ ya dhɨ ko. ");
INSERT INTO log_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Bvóá dhɨ, dré gòzo gòle áyɨ lebèbhá nda ɨ véna vésè nɨ na sè, tàá àyɨ dré dhɨ: «Mɨ̀ adré dhu rè ayí ko, adrézó lovólé? Kɨtswá dre. Lókyá atsá dre. Mɨ̀ nò rè ká! À adré ꞌòle Móndɨ́ nɨ Mvá nɨ lefè tàkonzɨ̀bhá ɨ drɨ́gá. ");
INSERT INTO log_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Mɨ̀ nga, mà kòlɨ̀ró! Dhya adrélépi áma lefè dhɨ atsá dre!» ");
INSERT INTO log_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Gbǎ kòdhwa, Yésu dré rè dhu adréràꞌa tà ta dhɨ ꞌá dhɨ, Yùdásɨ̀, akódhɨ nɨ lebèbhá mudrí-drì-rì dhɨ kɨ àlo dré atsázó. Adrì tá ɨ́ vésè móndɨ́ zyandre angábhá kòwánà kàdrɨ̀ ɨ, tátrɨ́trɨ́ kúlí tadhábhá ɨ ɨ̀ndɨ̀ bhàgo ɨ vélésè dhɨ ɨ be. Àyɨ nda ɨ̀ ru tá sápɨ́ ɨ fa ɨ́be àyɨ drɨ́gá. ");
INSERT INTO log_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yùdásɨ̀ adrélépi ꞌòle Yésu nɨ lefè nda tà tá àyɨ dré dhɨ, ɨ́ nɨ akódhɨ àdhi ꞌɨ yà dhɨ nɨ tadhá àyɨ dré dhɨ kònɨ̀nɨ: «Dhya má dré dra kamúlé dhɨ, akódhɨ ꞌɨ. Mɨ̀ kòru dɨ akódhɨ, drìzoá lɨ̀zo ába, adrézó lɨkɨ́á dóro.» ");
INSERT INTO log_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Dɨ Yùdásɨ̀ nda dré ndɨrɨ áyɨ kisízó ànyɨ Yésu làga, tàá drá dhɨ: «Rábbì!» Dré akódhɨ nɨ kamúzó. ");
INSERT INTO log_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Gò móndyá nda ɨ̀ dré dhèzo Yésu dri, akódhɨ nɨ ru. ");
INSERT INTO log_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Dɨ, dhya adrébhá tá Yésu làga dhɨ kɨ àlo dré ngàzo áyɨ sápɨ́ asé gò, kòwánà kɨ kàdrɨ̀ nɨ màrábà nɨ bí bvwàzo kɨ̀le. ");
INSERT INTO log_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yésu dré tàzoá àyɨ dré dhɨ: «Ma vo kùgú ꞌɨ gò, mɨ̀ dré adrézó alɨ̀le sápɨ́ ɨ́be ɨ̀ndɨ̀ fa ɨ́be kɨtswálé áma ru nɨ? ");
INSERT INTO log_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Kìtú àlo àlo títí ɨ sè dhɨ, má adré tá àmɨ kòfalé, adrélé tà tadhá tépelò na dhɨ, mɨ̀ ru tá ma ko. Dɨ, tà kòdhɨ ɨ̀ atsá kònɨ̀nɨ, kɨtswálé tà tɨsɨ̀le áma tà dri Gìká nɨ Kúlí na dhɨ ɨ̀ kòꞌoró ru be dhɨ bvó.» ");
INSERT INTO log_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Gò akódhɨ nɨ lebèbhá títí dhɨ ɨ̀ dré akódhɨ nɨ tayɨ́zó lapázó. ");
INSERT INTO log_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Kàdhúrà àlo kɨ́tá asólépi ɨ́ rú ngbà ꞌí àlo dhɨ dré ngàzo adrélé Yésu nɨ lebè. À adré tá ꞌòle akódhɨ nɨ ru ká, ");
INSERT INTO log_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","dɨ, dré lapázó ràle bvólɨ́lɨ́ ro, kɨ́tá ɨ́na nɨ tayɨ́. ");
INSERT INTO log_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Gò ɨ̀ dré Yésu nɨ drìzo lɨ̀zo ába kòwánà kɨ kàdrɨ̀ bhàna. Dɨ kòwánà kàdrɨ̀ ɨ, bhàgo ɨ ɨ̀ndɨ̀ tátrɨ́trɨ́ kúlí tadhábhá ɨ́be dhɨ ɨ̀ dré ru kɨmózó títí kònàle. ");
INSERT INTO log_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Dɨ Pétèró ro dhɨ, lebè tá ɨ́na Yésu lárá ro, tsàle byá kòwánà kɨ kàdrɨ̀ nda nɨ bhàꞌálé na. Dré fɨ̀zo lɨrɨ́lé tépelò lɨkɨ́bhá ɨ kòfalé, adrélé àtsɨ́ yo àyɨ ɨ́be. ");
INSERT INTO log_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Kòwánà kàdrɨ̀ nda ɨ bhàgo kàdrɨ̀ nda ɨ́be títí dhɨ ɨ̀ adré tá tà adrélé tàle Yésu rú dhɨ kɨ nda, kɨtswázó akódhɨ nɨ ꞌo dràle dhɨ bvó. Dɨ, ɨ̀ kisú tá àyɨkya tà àlo ko. ");
INSERT INTO log_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Móndɨ́ bǐ dhɨ ɨ̀ adré tá tà ta akódhɨ rú kɨnzò sè. Dɨ, tà ɨ̀ dré adrélé tàle nda ɨ̀ kisú tá ru ko. ");
INSERT INTO log_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Gò móndɨ́ àruka ɨ̀ dré ngàzo tà ta akódhɨ rú kɨnzò sè kònɨ̀nɨ: ");
INSERT INTO log_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«Mà yi akódhɨ adréràꞌa tàá dhɨ: ‹Má nɨ tépelò móndɨ́ ɨ̀ dré sìle nɨ̀ kònɨ̀dhɨ nɨ pfu, gòzo àzya nɨ móndɨ́ ɨ̀ dré sìle nɨ̀ ko dhɨ nɨ si kìtú na àmvolésè.›» ");
INSERT INTO log_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Dɨ, ndɨ̀ndɨ̀ tà ɨ̀ dré tàle akódhɨ rú nda kisú ɨ́na ru ko. ");
INSERT INTO log_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Gò kòwánà kɨ kàdrɨ̀ dré ngàzo áyɨ totó àyɨ kandrá, lizíá Yésu tí dhɨ: «Mɨ́ logó mɨ́na kúlí tà dhya kònɨ ɨ̀ dré adrélé tàle mɨ́ rú kòdhɨ ɨ sè ko?» ");
INSERT INTO log_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Dɨ, Yésu adré tá ɨ́na kɨ́rɨ, kúlí logó àko ró. Gò kòwánà kɨ kàdrɨ̀ nda dré gòzo lizíá tíá dhɨ: «Mɨ Mèsɨ́yà, Gìká kɨtswálépi rúku sè dhɨ nɨ Mváagó ꞌɨ?» ");
INSERT INTO log_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yésu logó drá dhɨ: «Ma ꞌɨ. Dɨ mɨ̀ nɨ Móndɨ́ nɨ Mvá nɨ no adréràꞌa lɨrɨ́lé Gìká rìnyí líyí nɨ drɨ́ágó lésè. Mɨ̀ nɨ kpà akódhɨ nɨ no adréràꞌa agòle ndùrùku bhù na dhɨ ɨ ꞌásè.» ");
INSERT INTO log_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Dɨ kòwánà kɨ kàdrɨ̀ nda dré áyɨ kɨ́tá lasɨ́zó kɨzà dré gò, tàzoá dhɨ: «Mà nɨ dɨ go vélé móndɨ́ àruka kɨtswábhá tà ta akódhɨ rú dhɨ kɨ nda àdho tà sè? ");
INSERT INTO log_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mɨ̀ yi làdhá dré dhàle Gìká rú kòdhɨ àmɨ kɨ bíbhálé sè dre. Mɨ̀ adré dɨ kisùá ngɨ́nɨ?» Dɨ àyɨ títí nda ɨ̀ dré tà ŋòzo akódhɨ dri kɨtswálé dràdrà sè. ");
INSERT INTO log_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Gò àyɨ kɨ àruka ɨ̀ dré ngàzo adrélé tùsú lufú akódhɨ mi. Ɨ̀ dré akódhɨ nɨ mì dròzo gò, adrézó akódhɨ nɨ tisì, adrézó tàá drá dhɨ: «Mɨ́ longó rè tà pròfétà ro ká!» Gò tépelò lɨkɨ́bhá ɨ̀ dré kpà akódhɨ nɨ dòzo, adrélé mì tosálé. ");
INSERT INTO log_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Lókyá nda sè dhɨ, Pétèró tá ɨ́na tàbhu na, bhàꞌálé nda na. Gò mvátòkó àlo kòwánà kɨ kàdrɨ̀ nɨ màrábà ro dhɨ dré atsázó ");
INSERT INTO log_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pétèró nɨ no adréràꞌa àtsɨ́ yo. Dré akódhɨ nɨ nòzo dɨ̀ɨɨ́ gò, tàzoá dhɨ: «Mɨ tá kókpà túmä́ní Yésu Nàzàrétà lésè dhɨ be.» ");
INSERT INTO log_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Dɨ, Pétèró dré ɨ́na tà nda nɨ gàzo rè, tàzoá dhɨ: «Má nì ngalè mɨ́ adré àdho tà ta ya dhɨ ko.» Gò dré ngàzo pfòle bhàꞌálé nda ꞌásè, áyɨ totó láti adrézó afɨ́lé dhɨ ꞌá. Gbǎ kòdhwa, àgólòwa dré tsírà bhèzo. ");
INSERT INTO log_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Mvátòkó nda kònò akódhɨ kònàle dre dhɨ, dré gòzo tàá móndyá adrébhá tá akódhɨ làga dhɨ ɨ dré dhɨ: «Dhya kòndɨ àyɨ kɨ àlo ꞌɨ!» ");
INSERT INTO log_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Dɨ Pétèró dré gòzo tódhyá tà nda nɨ ga rè. Gí ko, àyɨ adrébhá tá Pétèró làga nda ɨ̀ dré tàzoá drá dhɨ: «Mɨ àyɨ kɨ àlo ꞌɨ bàti! Tàko ko, mɨ kókpà móndɨ́ angálépi Gàlìláyà lésè dhɨ ꞌɨ.» ");
INSERT INTO log_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Dɨ Pétèró dré ngàzo mòndrà sɨ, tàzoá dhɨ: «Tátrɨ́trɨ́ kàdré má dri, má kàdré kɨnzò ta dhɨ! Má nì agó mɨ̀ dré adrézó tà nɨ nɨ ta kòdhɨ ko!» ");
INSERT INTO log_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Gbǎ kòdhwa, àgólòwa dré gòzo tsírà bhe vésè nɨ rì sè. Gò kúlí Yésu dré tá tàle Pétèró dré dhɨ dré agázó lána. Tà tá dhɨ: «Drìdrì àgólòwa dré dra tsírà bhèzo vésè be rì dhɨ kandrá dhɨ, mɨ́ nɨ áma ga vésè be na.» Gò Pétèró dré dhèzo adrélé ngòle. ");
INSERT INTO log_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ngá kòwa dre dhɨ, kòwánà kàdrɨ̀ ɨ, tátrɨ́trɨ́ kúlí tadhábhá ɨ túmä́ní bhàgo kàdrɨ̀ ɨ́be títí dhɨ ɨ̀ dré ru yìzo Yésu dri. Dɨ ɨ̀ dré akódhɨ nɨ adròzo gò, drìzoá lɨ̀zo fèá Pìlátò, Rómà kɨ gùvèrènérè drɨ́gá. ");
INSERT INTO log_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Gò Pìlátò dré lizízóá Yésu tí dhɨ: «Mɨ, mɨ ópɨ́ Yúdà ànzɨ kya ꞌɨ?» Yésu logó drá dhɨ: «Ámɨ tàndɨ mɨ́ tà dre.» ");
INSERT INTO log_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Gò kòwánà kàdrɨ̀ nda ɨ̀ dré dhèzo adrélé Yésu nɨ asíkì tà bǐ dhɨ ɨ sè. ");
INSERT INTO log_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Dɨ Pìlátò dré gòzo lizíá tíá dhɨ: «Mɨ́ logó mɨ́na kúlí ko? Mɨ́ yi rè tà títí ɨ̀ dré adrélé tàle mɨ́ rú dhɨ ɨ ká!» ");
INSERT INTO log_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Dɨ, Yésu logó vélé ɨ́na kúlí ko. Gò Pìlátò nɨ lɨ́ndrɨ́ dré gàzo ásà. ");
INSERT INTO log_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kóná àlo àlo títí, gwányá Pásɨkà àdhya tú dhɨ, Pìlátò adré tá dhya ángùdhi bǎdzó na, móndɨ́ zyandre dhɨ ɨ̀ dré adrélé zìle ɨ́ tí dhɨ nɨ trɨ àyɨ dré. ");
INSERT INTO log_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Lókyá nda kònàdhɨ sè dhɨ, agó àlo rú be Bàrábà dhɨ tá bǎdzó na móndɨ́ àruka ɨ́be, ɨ̀ dré tá móndɨ́ kɨ kodzólé lɨgɨ́lé dhɨ sè, ɨ̀ndɨ̀ ɨ̀ dré tá móndɨ́ pfùle dràle dhɨ sè. ");
INSERT INTO log_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Dɨ móndɨ́ zyandre dhɨ ɨ̀ kòmbà tsàle Pìlátò véna dre dhɨ, ɨ̀ dré kɨdhózó adrélé akódhɨ nɨ ti lizí, kòꞌoró ànzyà gà dré tá adrélé ꞌòle àyɨ dré dhɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Dɨ Pìlátò dré àyɨ kɨ lizízó tàzoá dhɨ: «Mɨ̀ adré lèá dhɨ, má kòtrɨ̀ àmɨ dré ópɨ́ Yúdà ànzɨ kya kònɨ̀dhɨ?» ");
INSERT INTO log_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Lizí tá àyɨ kònɨ̀nɨ tàko ko, nì tá tàle dhɨ, kòwánà kàdrɨ̀ ɨ̀ fè tá Yésu ɨ́ drɨ́gá ngbà ꞌí dɨrèma sè dhɨ be. ");
INSERT INTO log_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Dɨ, kòwánà kàdrɨ̀ nda ɨ̀ dré móndyá zyandre nda kɨ ꞌa tɨfɨ́zó, ɨ̀ kòziró Pìlátò tí kòtrɨ̀ró Bàrábà àyɨ dré kòdhya. ");
INSERT INTO log_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Gò Pìlátò dré lizízóá àyɨ tí dhɨ: «Mɨ̀ adré dɨ lèá dhɨ, má kòꞌo dhya mɨ̀ dré adrélé zìle ópɨ́ Yúdà ànzɨ kya ró kònɨ̀dhɨ sè ngɨ́nɨ?» ");
INSERT INTO log_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Dɨ ɨ̀ dré kúlí yòzo tàzoá dhɨ: «Mɨ́ tidí akódhɨ fa kɨpakɨpa dri!» ");
INSERT INTO log_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pìlátò gò lizíá dhɨ: «Akódhɨ ꞌo àdho tà kònzɨ ꞌɨ?» Dɨ ɨ̀ dré gòzo adrélé tetrélé rìnyí sè, adrézó loyóá dhɨ: «Mɨ́ tidí akódhɨ!» ");
INSERT INTO log_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pìlátò adré tá móndyá zyandre nda kɨ togó le ꞌòle kɨnɨ́lé. Dɨ dré Bàrábà nɨ trɨ̀zo àyɨ dré. Dré Yésu nɨ ꞌòzo bhwàle gò, akódhɨ nɨ fèzo kɨtswálé tidílé fa kɨpakɨpa dri dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Gò sòdá ɨ̀ dré Yésu nɨ drìzo fɨ̀zo ába gùvèrènérè nda nɨ dzó kàdrɨ̀ nɨ bhàꞌálé na. Ɨ̀ dré sòdá àruka títí dhɨ kɨ azízó ru amú àyɨ ɨ́be akódhɨ làgásè. ");
INSERT INTO log_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Gò ɨ̀ dré kánzò kǎ asózó rúá, fanzɨ̌ kùtsi ró dhɨ nɨ pàzo kùla ró asólé drìá. ");
INSERT INTO log_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Dɨ ɨ̀ dré ngàzo adrélé mòdo fe drá, adrézó tàá dhɨ: «Mòdo mɨ́ dré, ópɨ́ Yúdà ànzɨ kya nɨ!» ");
INSERT INTO log_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ɨ̀ adré tá akódhɨ nɨ drì tswa kòzó sè, adrézó tùsú lufú rúá. Ɨ̀ adré tá kpà kórókó titì akódhɨ kandrá, sùle ngóró ɨ̀ adré tá akódhɨ nɨ lɨndrɨ̀ bha na tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ɨ̀ kògu akódhɨ kònɨ̀nɨ dre dhɨ, ɨ̀ dré kánzò kǎ nda nɨ avùzo rúásà, gòzo akódhɨ nɨ kɨ́tá kɨ tosó rúá. Gò ɨ̀ dré akódhɨ nɨ drìzo pfòzo ába, kɨtswálé tidílé fa kɨpakɨpa dri dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ɨ̀ dré tá adréràꞌa apfòle kònalésè dhɨ ꞌá dhɨ, ɨ̀ dré agó àlo rú be Sìmónà, angálépi Kìrénè lésè dhɨ nɨ nòzo adréràꞌa agòle amvú lésè. Akódhɨ nda tá Àlɨ̀gɨ̀zándrè kɨ atá Rúfù be dhɨ ꞌɨ. Dɨ ɨ̀ dré akódhɨ nɨ ꞌòzo rìnyí sè adrélé fa kɨpakɨpa Yésu àdhya nɨ do. ");
INSERT INTO log_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Gò ɨ̀ dré Yésu nɨ drìzo lɨ̀zo ába tsàle àrà rú zìle Gòlògótà dhɨ na. (Rú nda kòdhɨ adré lèá tàle dhɨ «Àrà drìfà àdhya».) ");
INSERT INTO log_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Kònàle dhɨ, ɨ̀ dré vínò amúlé àlókò rú zìle mírè dhɨ be dhɨ nɨ fèzo akódhɨ dré mvùle. Dɨ, dré ɨ́na gàzoá rè. ");
INSERT INTO log_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Dɨ ɨ̀ dré akódhɨ nɨ tidízó fa kɨpakɨpa dri gò, dzègé vùzo nìzoá ngalè ɨ̀ nɨ akódhɨ nɨ kɨ́tá kɨ lanzɨ́ àyɨ kòfalésè ngɨ́nɨ ya dhɨ. ");
INSERT INTO log_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Lókyá akódhɨ nɨ tidízó nda tá sáà nzi-drì-su drùbhì sè dhɨ ꞌɨ. ");
INSERT INTO log_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","À tɨsɨ̀ tá tà tà ŋòzo akódhɨ dri dhɨ wárágà dri kònɨ̀nɨ: «Ópɨ́ Yúdà ànzɨ kya». ");
INSERT INTO log_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","À tidí tá kpà kùgubhá rì dhɨ ɨ fa àruka ɨ drǐsè akódhɨ làgásè: àlo nɨ drɨ́ágó nɨ lésè, àzya nɨ lìdzí nɨ lésè.  ");
INSERT INTO log_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Móndyá adrébhá tá lavúlé àrà nda ꞌásè dhɨ ɨ̀ adré tá akódhɨ nɨ lodhá, adrézó àyɨ kɨ drì ya, adrézó tàá dhɨ: «Á! Mɨ tá kɨtswálépi tépelò pfu gòzo sìá kìtú na àmvolésè nɨ, ");
INSERT INTO log_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","mɨ́ así dɨ fa kɨpakɨpa kòdhɨ drìlésè ámɨ tàndɨ nɨ tɨdrɨ́ wà!» ");
INSERT INTO log_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Kòwánà kàdrɨ̀ ɨ tátrɨ́trɨ́ kúlí tadhábhá ɨ́be dhɨ ɨ̀ adré tá kpà akódhɨ nɨ gu kònɨ̀nɨ, adrézó tàá àyɨ kòfalésè dhɨ: «Akódhɨ tɨdrɨ́ móndɨ́ àruka ɨ ꞌí. Dɨ, kɨtswá ɨ́na áyɨ tàndɨ nɨ tɨdrɨ́ bwà ko! ");
INSERT INTO log_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Adré lèá dhɨ, Mèsɨ́yà, ópɨ́ Ɨ̀sèrélè ànzɨ kya kòdhɨ kàsí nyànomvá fa kɨpakɨpa drìlésè, mà kònòró tà nda akódhɨ nɨ kaꞌìzo be dhɨ bvó!» Kùgubhá tidílé akódhɨ be nda ɨ̀ adré tá kpà akódhɨ nɨ lodhá kònɨ̀nɨ. ");
INSERT INTO log_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kìtú rírí sè dhɨ, tínímvá dré bvò nɨ mì dòzo wä́yi, tsàle sáà na kìtú rírí àmvolésè dhɨ na. ");
INSERT INTO log_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Dɨ sáà na nda sè dhɨ, Yésu dré liyízó kúlí ꞌuꞌù sè tàzoá dhɨ: «Èlóyɨ̀, Èlóyɨ̀, lémà sàbàkàtánɨ̀?» Kòdhɨ adré lèá tàle dhɨ: «Áma Gìká, áma Gìká, mɨ́ tayɨ́ ma àdho tà sè?» ");
INSERT INTO log_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Móndɨ́ àruka adrébhá tá kònàle dhɨ ɨ̀ kòyi kúlí nda dre dhɨ, ɨ̀ dré tàzoá dhɨ: «Mɨ̀ yi rè ká! Akódhɨ adré Èlɨ́yà nɨ zi.» ");
INSERT INTO log_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Gò àyɨ kɨ àlo dré ràzo mbèlè ngá vòdhovódho dhɨ nɨ adó, vìnègárì dàzo lána, dròzoá kòzó sílé, tɨngázóá kuru fèle Yésu dré mvùle gò, tàzoá dhɨ: «Mà kòtayɨ́ rè akódhɨ, nòzoá ngalè Èlɨ́yà nɨ atsá akódhɨ nɨ tɨrɨ́ fa kɨpakɨpa drìlésè yà dhɨ.» ");
INSERT INTO log_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Dɨ, Yésu dré trèzo kúlí ꞌuꞌù sè gò, dràzo. ");
INSERT INTO log_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Gbǎ lókyá nda sè dhɨ, kɨ́tá ꞌɨ̀le tépelò nɨ ꞌa lakɨ́zó dhɨ dré lasɨ́zó ꞌa be rì, kɨdhólé drì lésè tsàle pá na. ");
INSERT INTO log_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Rómà kɨ sòdá kɨ kàdrɨ̀ adrélépi áyɨ totó Yésu kandrá dhɨ kònò akódhɨ drà tá ngɨ́nɨ ya dhɨ dre dhɨ, dré tàzoá dhɨ: «Dhya kòdhɨ tá ɨ́na Gìká nɨ Mváagó ꞌɨ bàti!» ");
INSERT INTO log_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Tòkó àruka ɨ tá kpà kònàle, adrélé tà nda kɨ no lárá ro. Àyɨ kòfalé dhɨ tá: Màrɨ́yà Màgàdàlénè, Màrɨ́yà Yàkóbhò kàdhúrà ro dhɨ kɨ andre Yósè be dhɨ, tsàle Sàlómè. ");
INSERT INTO log_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Àyɨ nda ɨ̀ adré tá Yésu nɨ lebè Gàlìláyà na, adrézó tà ꞌo drá. Tòkó àruka bǐ alɨ̀bhá akódhɨ be Yèrúsalémà le dhɨ ɨ tá kpà kònàle be. ");
INSERT INTO log_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Kìtú nda tá kìtú adrézó tà ledé sàbátù kandrá dhɨ ꞌɨ. Dɨ ɨ̀ndró kàndrɨ̀ dre dhɨ, ");
INSERT INTO log_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","agó àlo rú be Yòséfà angálépi Àrìmàtáyà lésè dhɨ dré lɨ̀zo Pìlátò véna. Akódhɨ nda tá Yúdà ànzɨ kɨ bhàgo kàdrɨ̀ kɨ àlo rúku ró dhɨ ꞌɨ. Adré tá kpà ɨ́na Gìká nɨ Òpɨ̀ letè nòle. Dɨ akódhɨ kòtsa Pìlátò véna dre dhɨ, dré Yésu nɨ rúbhá zìzo tíá tirì àko. ");
INSERT INTO log_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pìlátò kòyi Yésu drà dre dhɨ dre dhɨ, akódhɨ nɨ lɨ́ndrɨ́ dré gàzo. Dré sòdá kɨ kàdrɨ̀ azízó, lizízóá tíá ngalè akódhɨ drà dre bàti yà dhɨ. ");
INSERT INTO log_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Kòyi tà nda tá kònɨ̀nɨ dhɨ sòdá kɨ kàdrɨ̀ nda tí dre dhɨ, dré láti fèzo Yòséfà dré rúbhá nda nɨ dòzo. ");
INSERT INTO log_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Dɨ Yòséfà dré kɨ́tá kemve gɨ̀zo lɨ̀zo ába gò, dré rúbhá nda nɨ tɨrɨ́zó fa kɨpakɨpa drìlésè, lambézóá kɨ́tá nda sè gò, lɨ̀zo bhàá mógó àlo gàle kɨ́rà na dhɨ na. Dré kɨ́rà kàdrɨ̀ dhɨ nɨ alɨ́zó bhàle mógó nda tí. ");
INSERT INTO log_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Màrɨ́yà Màgàdàlénè ɨ Màrɨ́yà Yósè nɨ andre ró dhɨ be dhɨ, ɨ̀ nò tá àrà rúbhá nda nɨ bhàzo dhɨ ꞌí. ");
INSERT INTO log_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sàbátù kòlavú dre dhɨ, Màrɨ́yà Màgàdàlénè, Màrɨ́yà Yàkóbhò nɨ andre, ɨ̀ndɨ̀ Sàlómè be dhɨ ɨ̀ dré dò tàdzí be dóro dhɨ nɨ gɨ̀zo, kɨtswázó lɨ̀le dàá Yésu nɨ rúbhá rú dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Dɨ kìtú nɨ àlo pósò àdhya sè, ngá kòwa dre dhɨ, ɨ̀ dré ngàzo drùbhì kɨ́nó láti do adrézó lɨ̀le mógó na. ");
INSERT INTO log_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Láti ꞌá dhɨ, ɨ̀ adré tá lizíá àyɨ kòfalésè dhɨ: «Àdhi nɨ kɨ́rà lɨ mógó tísè mà dré kɨtswázó fɨ̀le lána bwà dhɨ nɨ̀?» ");
INSERT INTO log_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Dɨ, ɨ̀ kòtɨngá mì dre dhɨ, ɨ̀ dré nòzoá dhɨ, à lɨ kɨ́rà kàdrɨ̀ gú nda mógó tísè dre. ");
INSERT INTO log_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ɨ̀ kòfɨ mógó nda na dre dhɨ, ɨ̀ dré kàdhúrà àlo kánzò kemve asólépi ɨ́ rú dhɨ nɨ nòzo, adréràꞌa lɨrɨ́lé mógó nda na drɨ́ágó lésè. Gò àyɨ kɨ togó dré gàzo tirì dré. ");
INSERT INTO log_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Dɨ, akódhɨ dré tàzoá àyɨ dré dhɨ: «Mɨ̀ tayɨ́ àmɨ kɨ togó adrélé gàle tirì dré ko. Mɨ̀ adré Yésu Nàzàrétà lésè, tidílé fa kɨpakɨpa dri dhɨ nɨ nda kòdhya. Akódhɨ kònwa yókódhó. Nga ɨ́na dràdrà ꞌásè dre! Mɨ̀ nò rè àrà tá rúbhá nɨ nɨ bhàzo nɨ ká. ");
INSERT INTO log_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Dɨ mɨ̀ lɨ̀ tàá akódhɨ nɨ lebèbhá ɨ dré túmä́ní Pétèró be dhɨ: ‹Akódhɨ adré lɨ̀le àmɨ kandrána Gàlìláyà na. Kònàle dhɨ, mɨ̀ nɨ akódhɨ nɨ no ngóró dré tá tàle àmɨ dré dhɨ tɨ́nɨ.›» ");
INSERT INTO log_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Dɨ tòkó nda kɨ lɨ́ndrɨ́ dré gàzo bhwǎbhwa, ɨ̀ dré kpà adrézó lyàle lyàlyà gò, ɨ̀ dré ngàzo lapálé mógó nda lésè. Dɨ, ɨ̀ tà tá àyɨkya tà àlo dhya àlo dré ko, ɨ̀ dré tá adrélé ngá ro dhɨ sè. ");
INSERT INTO log_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yésu kònga dràdrà ꞌásè drùbhì kɨ́nó kìtú nɨ àlo pósò àdhya sè dre dhɨ, dré rè zyà agázó Màrɨ́yà Màgàdàlénè ɨ́ dré tá tɨrɨ́ kònzɨ nzi-drì-rì dhɨ kɨ dròzo lásà dhɨ kandrá. ");
INSERT INTO log_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Gò akódhɨ nda dré ngàzo lɨ̀le rúbí nda nɨ longó dhya adrébhá tá túmä́ní Yésu be gò, ɨ̀ dré adrézó àwó ngo, adrézó tongólé akódhɨ nɨ tà sè dhɨ ɨ dré. ");
INSERT INTO log_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Dɨ, àyɨ nda ɨ̀ kòyi tàle dhɨ, Yésu lɨ́drɨ̀ ro, ɨ̀ndɨ̀ Màrɨ́yà nò akódhɨ dre dhɨ dre dhɨ, ɨ̀ dré àyɨkya kaꞌìzoá ko. ");
INSERT INTO log_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Àmvolásà dhɨ, Yésu dré gòzo áyɨ tadhá làsú be twá áyɨ lebèbhá rì dhɨ ɨ dré, ɨ̀ dré tá adréràꞌa lɨ̀le gbàbhú na dhɨ ꞌá. ");
INSERT INTO log_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Dɨ àyɨ nda ɨ̀ dré gòzo rúbí nda nɨ longó àyɨ kɨ arúpi ɨ dré gò, àyɨ nda ɨ̀ dré kpà àyɨ kɨ kúlí kaꞌìzo ko. ");
INSERT INTO log_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kùdù ro dhɨ, Yésu dré gòzo áyɨ tadhá dhya mudrí-drì-àlo nda ɨ dré, ɨ̀ dré tá adréràꞌa lɨrɨ́lé mɨ́sá làgásè dhɨ ꞌá. Gò dré tà tàzo àyɨ dri, àyɨ kɨ tà kaꞌìkaꞌì dré tá adrélé yàyà dhɨ sè, ɨ̀ndɨ̀ àyɨ kɨ togó dré tá adrélé tòmbátòmba dhɨ sè. Tàko ko, ɨ̀ kaꞌì tá àyɨkya dhya akódhɨ nɨ nobhá mì sè akódhɨ nɨ ngàma dràdrà ꞌásè dhɨ àmvolésè dhɨ kɨ kúlí ko. ");
INSERT INTO log_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Gò dré tàzoá àyɨ dré dhɨ: «Mɨ̀ lɨ̀ bvò wä́yi ꞌásè Rúbí Tanɨ longóbe móndyá títí Gìká dré bhàle dhɨ ɨ dré. ");
INSERT INTO log_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Dhya ángùdhi dra Rúbí Tanɨ nda nɨ kaꞌìlepi gò, bàtísimò dòzo dhɨ nɨ adrɨ́. Dɨ, dhya ángùdhi Rúbí Tanɨ nda nɨ kaꞌìlepi ko dhɨ, Gìká nɨ tà bha akódhɨ nda dri. ");
INSERT INTO log_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Gìká nɨ tà twátwa lɨ́ndrɨ́ga ró kònɨ kɨ fe móndyá kaꞌìbhá dhɨ ɨ dré adrélé ꞌòle dhɨ kòdhya: Áma rú sè dhɨ, ɨ̀ nɨ tɨrɨ́ kònzɨ kɨ dro topfòle móndɨ́ ɨ lésè. Ɨ̀ nɨ ti twátwa tɨ́dhɨ́ ro dhɨ kɨ ta. ");
INSERT INTO log_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ɨ̀ nɨ nì kɨ ru àyɨ drɨ́gá. Dɨ ɨ̀ kòmvu lòmà yà dhɨ, lòmà nda kɨtswá àyɨ kɨ ꞌo kònzɨ àlomvá ko. Ɨ̀ nɨ kpà drɨ́gá tobhà dràbhá ɨ rú gò, àyɨ nda ɨ̀ dré gòzo adrɨ́lé.» ");
INSERT INTO log_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Dɨ Mírì Yésu kòtà tà nda ɨ àyɨ dré dre dhɨ, Gìká dré akódhɨ nɨ dòzo bhù na gò, akódhɨ dré lɨrɨ́zó Gìká nɨ drɨ́ágó lésè. ");
INSERT INTO log_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Dɨ akódhɨ nɨ lebèbhá nda ɨ̀ dré ngàzo lɨ̀le Rúbí Tanɨ longóbe àrà títí bvò dri dhɨ ɨ ꞌásè. Mírì adré tá tà ꞌo àyɨ ɨ́be, adrézó tadhá dhɨ, áyɨ kúlí ɨ̀ dré tá adrélé longólé nda tà bàti ꞌɨ, tà lɨ́ndrɨ́ga ró dré fèle àyɨ dré adrélé ꞌòle dhɨ ɨ sè.");
INSERT INTO log_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Atálágó Tèyòfílè, ngóró mɨ́ dré nìle be dhɨ tɨ́nɨ dhɨ, móndɨ́ bǐ dhɨ ɨ̀ tabhì tà ru ꞌobhá àma kòfalé dhɨ kɨ tɨsɨ̀le. ");
INSERT INTO log_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ɨ̀ tɨsɨ̀ ngóró dhya tà nda kɨ nobhá mì sè kɨdhoma nɨ lésè gò, ɨ̀ dré atsázó Gìká nɨ kúlí longóbhá ɨ ró dhɨ ɨ̀ dré tɨtɨ́lé tayɨ́lé àma dré dhɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Dɨ, atálágó, má dré tà títí nda kɨ ndàle nìle kyá àyɨ kɨ kɨdhoma lésè dhɨ sè dhɨ, má mìlésè dhɨ tá kpà dóro má dré tà nda kɨ tɨsɨ̀le mɨ́ dré mìbhalé tí dhɨ. ");
INSERT INTO log_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Má adré ꞌòá kònɨ̀nɨ, mɨ́ kòkɨtswáró nìá tàle dhɨ, tà tadhálé mɨ́ dré dhɨ ɨ tà bàti ꞌɨ dhɨ be. ");
INSERT INTO log_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Lókyá Èródè dré tá adréràꞌa ópɨ́ ro bvò Yùdáyà àdhya drìle dhɨ ꞌá dhɨ, kòwánà àlo rú be Zàkàrɨ́yà dhɨ tá be. Akódhɨ nda tá kòwánà angábhá Àbɨ́yà nɨ súrú lésè dhɨ kɨ àlo ꞌɨ. Akódhɨ nɨ tòkó rú be Èlìzàbétè dhɨ angá tá kpà Àrónà atú adrélépi kòwánà kɨ kàdrɨ̀ ro dhɨ nɨ súrú lésè. ");
INSERT INTO log_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Àyɨ rìti dhɨ kɨ tà tá gyǎgya Gìká mìlésè. Ɨ̀ adré tá tà títí Mírì nɨ tátrɨ́trɨ́ kúlí dré adrélé tàle à kòꞌo dhɨ kɨ ꞌo, tà àlo tɨvɨ̀ àko ró. ");
INSERT INTO log_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Dɨ, àyɨ tá àyɨkya mvá àko. Tàko ko, Èlìzàbétè tá kóndó ꞌɨ, ɨ̀ndɨ̀ àyɨ rìti dhɨ kɨ kóná lavú tá dre. ");
INSERT INTO log_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Kìtú àlo dhɨ, Zàkàrɨ́yà nda adré tá àzí ꞌo kòwánà ro Gìká kandrá. Àngyá ko, lókyá nda tá lókyá kòwánà akódhɨ nɨ súrú lésè dhɨ ɨ̀ dré adrézó àzí ꞌo dhɨ ꞌɨ. ");
INSERT INTO log_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ànzyà gà kòwánà ɨ̀ dré adrélé ꞌòle dhɨ tɨ́nɨ dhɨ, ɨ̀ kɨpè tá akódhɨ dzègé sè, fɨ̀le béndélé za Mírì nɨ tépelò na dhɨ kòdhya. ");
INSERT INTO log_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Dɨ akódhɨ dré tá adréràꞌa béndélé za dhɨ ꞌá dhɨ, móndyá zyandre títí dhɨ ɨ̀ adré tá tà zi Gìká tí kɨvɨ̀ na. ");
INSERT INTO log_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Gò ángéló Mírì àdhya dré ngàzo agálé Zàkàrɨ́yà kandrá, áyɨ totó adrélé àlètárɨ̀ adrézó béndélé za dhɨ nɨ drɨ́ágó lésè. ");
INSERT INTO log_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zàkàrɨ́yà kònò akódhɨ dre dhɨ, akódhɨ nɨ drì dré abɨ́zó nyɨ̌nyɨ gò, tirì dré gàzo akódhɨ léna bǐ. ");
INSERT INTO log_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Dɨ, ángéló nda dré ɨ́na tàzoá drá dhɨ: «Zàkàrɨ́yà, mɨ́ ro ngá ko! Tàko ko, Gìká yi tà mɨ́ dré zìle ɨ́ tí dhɨ dre. Ámɨ tòkó Èlìzàbétè nɨ mváagó ti mɨ́ dré gò, mɨ́ dré rú nɨ nɨ zìzo Yòwánɨ̀. ");
INSERT INTO log_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Akódhɨ nɨ arɨ́ fe mɨ́ dré kólénzé ɨ́be. Móndɨ́ bǐ dhɨ kɨ kókpà lenzé akódhɨ nɨ tìma sè. ");
INSERT INTO log_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Tàko ko, akódhɨ nɨ tà nɨ adré kàdrɨ̀ Mírì mìlésè. Akódhɨ kɨtswá tàdzí vínò ꞌɨ yà, kó ngalè wá àtsɨ́ ꞌɨ yà dhɨ nɨ mvu ko. A nɨ ga Tɨrɨ́ Lólo sè bǐ, kɨdhólé ɨ́ dré adréràꞌa áyɨ andre lé dhɨ ꞌá. ");
INSERT INTO log_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","A nɨ Ɨ̀sèrélè ànzɨ bǐ dhɨ kɨ adrì agòle Mírì àyɨ kɨ Gìká vélé. ");
INSERT INTO log_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","A nɨ adhé alɨ̀le Mírì kandrá, Tɨrɨ́ Lólo atú adrélépi pròfétà Èlɨ́yà le dhɨ nɨ rìnyí sè, kɨtswálé ànzɨ kɨ atá kɨ togó adzá àyɨ kɨ ànzɨ ɨ vélé, ɨ̀ndɨ̀ móndyá adrébhá lɨgɨ́lé dhɨ kɨ togó adzá móndyá gyǎgya kɨ tògyá vélé, kɨtswázó móndɨ́ kɨ tɨvó adrélé gànzi ró Mírì dré be dhɨ bvó.» ");
INSERT INTO log_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Dɨ, Zàkàrɨ́yà dré ángéló nda nɨ lizízó tàzoá dhɨ: «Má nɨ nìá ngalè tà kòdhɨ nɨ ru ꞌo bàti dhɨ ngɨ́nɨ? Àngyá ko, ma màlɨ̀ga ꞌɨ, ɨ̀ndɨ̀ áma tòkó nɨ kóná lavú dre.» ");
INSERT INTO log_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ángéló logó drá dhɨ: «Ma Gàbèrèyélè ꞌɨ. Má adré áma totó Gìká kandrá, adrélé akódhɨ nɨ àzí ꞌo. Akódhɨ amù ma alɨ̀le mɨ́ vélé, rúbí tanɨ kòdhɨ nɨ longó mɨ́ dré. ");
INSERT INTO log_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Dɨ, mɨ́ yi rè ká! Mɨ́ nɨ adré ábhä́bhä́ ro tà ta àko ró, tsàle kìtú tà nda dré dra ru ꞌòzo dhɨ tú. Tàko ko, mɨ́ kaꞌì mɨ́na áma kúlí ɨ ko, tágba kúlí nda ɨ̀ dré dra ru ꞌòzo àyɨ kɨ lókyá sè dhɨ.» ");
INSERT INTO log_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Lókyá nda sè dhɨ, móndyá zyandre nda ɨ̀ adré tá Zàkàrɨ́yà nɨ letè gò, àyɨ kɨ lɨ́ndrɨ́ dré adrézó gàle, dré tá adrélé gìle tépelò na tò dhɨ sè. ");
INSERT INTO log_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Dɨ, kàpfò lásà dre dhɨ, kɨtswá tá ɨ́na tà ta àyɨ véna bwà ko. Gò ɨ̀ dré atógyàzoá dhɨ, ngá agá tá akódhɨ mi toróbɨ́ tɨ́nɨ tépelò na dre. Àngyá ko, akódhɨ atsá tá ɨ́na ábhä́bhä́ ro, adrélé tà ta àyɨ dré drɨ́gá sè. ");
INSERT INTO log_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Akódhɨ nɨ lókyá adrézó àzí ꞌo tépelò na dhɨ kàkɨ́ dre dhɨ, dré nzɨ̀zo ɨ́ bhàna. ");
INSERT INTO log_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Àmvolásà dhɨ, akódhɨ nɨ tòkó Èlìzàbétè dré ꞌa kisúzó gò, dré áyɨ zùzo ꞌa nda be mbǎ nzi. Adré tá kisùá ɨ́ léna dhɨ: ");
INSERT INTO log_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«Mírì ꞌo má dré tà adrélépi dóro ɨ́ mìlésè dhɨ kòdhya. Lókyá kònɨ̀dhɨ sè dhɨ, tɨngá má rúsè tà adrélépi tá kanyò fe má dré móndɨ́ ɨ mi dhɨ dre.» ");
INSERT INTO log_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Èlìzàbétè nɨ mbǎ nɨ nzi-drì-àlo sè dhɨ, Gìká dré ángéló Gàbèrèyélè nɨ mùzo lɨ̀le bhàandre rú zìle Nàzàrétà bvò Gàlìláyà àdhya lé dhɨ na, ");
INSERT INTO log_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","kyánzɨ àlo rú be Màrɨ́yà, àgo tà nìlepi rè ko dhɨ véna. À zɨ̀ tá Màrɨ́yà nda agó àlo rú be Yòséfà, angálépi ópɨ́ Dàwídì nɨ súrú lésè dhɨ dré tòko ró. ");
INSERT INTO log_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ángéló nda kòfɨ Màrɨ́yà véna dre dhɨ, dré tàzoá dhɨ: «Mɨ Mírì dré áyɨ togó tanɨ bhàzo mɨ́ rú nɨ, mòdo mɨ́ dré! Mírì túmä́ní mɨ́ be!» ");
INSERT INTO log_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Dɨ Màrɨ́yà nɨ drì dré abɨ́zó nyɨ̌nyɨ kúlí nda sè gò, dré adrézó kisùá ɨ́ léna ngalè mòdo nda tá àdho mòdo kárá ꞌɨ ya dhɨ. ");
INSERT INTO log_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Dɨ, ángéló nda dré ɨ́na tàzoá drá dhɨ: «Màrɨ́yà, mɨ́ ro ngá ko! Tàko ko, mɨ Gìká nɨ togó tanɨ ɨ́be mɨ́ rú. ");
INSERT INTO log_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Mɨ́ yi rè ká! Mɨ́ nɨ ꞌa kisú gò, mɨ́ dré mváagó tìzo, rú nɨ nɨ zìzo Yésu. ");
INSERT INTO log_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Akódhɨ nɨ tà nɨ adré kàdrɨ̀, ɨ̀ndɨ̀ à nɨ akódhɨ nɨ zi Gìká kurú na bhù na dhɨ nɨ Mváagó ro. Mírì Gìká nɨ akódhɨ nɨ bha adrélé ópɨ́ kàdrɨ̀ ro, ngóró akódhɨ nɨ tábhí Dàwídì tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Akódhɨ nɨ òpɨ̀ nya Ɨ̀sèrélè ànzɨ ɨ dri kóná vésè kólyá. Bàti, akódhɨ nɨ òpɨ̀ nɨ adré kùdù àko.» ");
INSERT INTO log_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Dɨ Màrɨ́yà dré ángéló nda nɨ lizízó tàzoá dhɨ: «Tà kòdhɨ nɨ ru ꞌo ngɨ́nɨ? Tàko ko, má nì rè agó àlo nɨ tà ko.» ");
INSERT INTO log_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Dɨ ángéló nda logó drá dhɨ: «Tɨrɨ́ Lólo nɨ así mɨ́ dri gò, Gìká kurú na bhù na dhɨ nɨ rìnyí dré ámɨ asózó. Ásà dhɨ, à nɨ mvámvá lólo mɨ́ dré dra tìle nda nɨ zi Gìká nɨ Mváagó ro. ");
INSERT INTO log_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Dɨ mɨ́ yi rè ká! Ámɨ aró Èlìzàbétè kisú ɨ́na ꞌa dre. Adré mváagó letè, tágba dré adrézó màlɨ̀ga ꞌɨ dhɨ. Kònɨ̀dhɨ, akódhɨ tá adrélé zìle kóndó ro nda nɨ mbǎ nɨ nzi-drì-àlo dhɨ ꞌɨ. ");
INSERT INTO log_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Tàko ko, Gìká mìlésè dhɨ, tà àlo kɨtswálé ꞌòle bwà ko dhɨ yókódhó.» ");
INSERT INTO log_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Dɨ Màrɨ́yà gò tàá dhɨ: «Ma Mírì nɨ màrábà ꞌɨ. Tà nda kòꞌo ru má dré ngóró mɨ́ dré tàle dhɨ tɨ́nɨ.» Gò ángéló nda dré akódhɨ nɨ tayɨ́zó. ");
INSERT INTO log_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Lókyá nda sè dhɨ, Màrɨ́yà dré ngàzo lɨ̀le sɨ́rɨ́ bhàandre àlo bvò kòngo ró Yùdáyà àdhya lé dhɨ na. ");
INSERT INTO log_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Dré tsàzo fɨ̀le Zàkàrɨ́yà nɨ dzó na gò, mòdo fe Èlìzàbétè dré. ");
INSERT INTO log_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Dɨ Èlìzàbétè dré Màrɨ́yà nɨ mòdo nda nɨ yiràꞌa dhɨ, mvámvá dré ngàzo lána gò, Èlìzàbétè dré gàzo Tɨrɨ́ Lólo sè bǐ. ");
INSERT INTO log_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Dré yòzoá kúlí ꞌuꞌù sè dhɨ: «Gìká bhà tà tanɨ mɨ́ dri tòkó àruka títí dhɨ kya kɨ lavú dre. Bhà kókpà tà tanɨ mvámvá mɨ́ dré dra tìle dhɨ dri dre. ");
INSERT INTO log_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ma tá àdhi ꞌɨ, áma Mírì nɨ andre dré alɨ̀zo má vélé nɨ? ");
INSERT INTO log_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Mɨ́ nò rè ká! Ámɨ mòdo nɨ kúlí dré adhéràꞌa má bílé dhɨ ꞌá dhɨ, mvámvá nga má léna arɨ́ dré. ");
INSERT INTO log_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Kólénzé mɨ́ dré, mɨ́ dré kaꞌìle tàle dhɨ, Mírì nɨ dra tà ɨ́ dré tàle mɨ́ dré dhɨ nɨ ꞌo káyà dhɨ sè.» ");
INSERT INTO log_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Dɨ Màrɨ́yà dré tàzoá dhɨ: «Má adré áma Mírì nɨ tà bha kuru. ");
INSERT INTO log_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Áma togó adré lenzélé Gìká áma tɨdrɨ́lépi dhɨ nɨ rú sè. ");
INSERT INTO log_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Tàko ko, akódhɨ bhe mì áyɨ màrábà tàko nɨ nɨ no. Kɨdhólé nyànomvá dhɨ, móndyá lókyá títí ɨ sè dhɨ kɨ áma zi kólénzé líyí ro. ");
INSERT INTO log_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Àngyá ko, Gìká rìnyí líyí ro dhɨ ꞌo tà kàdrɨ̀ lavúlé dhɨ má dré dre. Akódhɨ nɨ rú lólo. ");
INSERT INTO log_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Adré áyɨ togó dóro tadhá móndyá lókyá títí ɨ sè adrébhá áyɨ ro dhɨ ɨ dré. ");
INSERT INTO log_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","ꞌO tà kàdrɨ̀ ɨ áyɨ drɨ́gá rìnyi ró dhɨ sè dre. Lapé móndyá tà kisùkisù ɨ́be drìkàdrɨ̀ ro dhɨ ɨ. ");
INSERT INTO log_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Tɨrɨ́ ópɨ́ kàdrɨ̀ ɨ àyɨ kɨ lɨrɨ́rà adrézó òpɨ̀ nya dhɨ ɨ drìlésè gò, móndyá tàko kɨ tɨngázó kuru. ");
INSERT INTO log_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Fè ngá dóro ɨ móndyá tàbirí ɨ́be dhɨ ɨ dré nyàle gò, ngábhá kɨ logózó nzɨ̀le drɨ́gálé sè. ");
INSERT INTO log_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Alɨ̀ áyɨ màrábà, Ɨ̀sèrélè ànzɨ kɨ ledé. Tɨvɨ̀ kpà áyɨ togó dóro tadhama Àbàrámà ɨ dré ànzɨ nɨ ɨ́be kóná vésè kólyá dhɨ ko, ngóró dré tá lazílé àma kɨ tábhí ɨ dré dhɨ tɨ́nɨ.» ");
INSERT INTO log_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Màrɨ́yà dré adrézó Èlìzàbétè bhàna mbǎ na gò, dré gòzo nzɨ̀le ɨ́ bhàna. ");
INSERT INTO log_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Èlìzàbétè nɨ lókyá tìzo dhɨ kòkɨtswá dre dhɨ, dré mváagó tìzo. ");
INSERT INTO log_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Akódhɨ nɨ bhàzɨ̌ ɨ aró nɨ ɨ́be dhɨ ɨ̀ kòyi tàle dhɨ, Mírì tadhá tá áyɨ togó dóro drá dhɨ dre dhɨ, ɨ̀ dré ngàzo adrélé lenzélé túmä́ní akódhɨ be. ");
INSERT INTO log_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Mvámvá nda nɨ kìtú nɨ nzi-drì-na akódhɨ nɨ tìma àmvolésè dhɨ sè dhɨ, ɨ̀ dré lɨ̀zo akódhɨ nɨ ꞌo lwàle. Móndɨ́ ɨ̀ adré tá ꞌòle akódhɨ nɨ atá, Zàkàrɨ́yà nɨ rú fe drá ká. ");
INSERT INTO log_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Dɨ, andre nɨ dré ɨ́na tàzoá dhɨ: «Kóko, à nɨ akódhɨ nɨ rú zi Yòwánɨ̀.» ");
INSERT INTO log_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ɨ̀ tà drá dhɨ: «Móndɨ́ rú be kònɨ̀nɨ dhɨ ámɨ súrú na dhɨ yó.» ");
INSERT INTO log_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Gò ɨ̀ dré mvámvá nda nɨ atá nɨ lizízó drɨ́gá sè, nìzoá ngalè akódhɨ lè à kòzi mvámvá nda nɨ rú àdhi ya dhɨ. ");
INSERT INTO log_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Dɨ Zàkàrɨ́yà dré ngá adrézó ngá tɨsɨ̀ drìá dhɨ nɨ zìzo gò, tɨsɨ̀zoá dhɨ: «Akódhɨ nɨ rú Yòwánɨ̀.» Gò àyɨ títí dhɨ kɨ lɨ́ndrɨ́ dré gàzo tà nda sè. ");
INSERT INTO log_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Gbǎ kòdhwa, Zàkàrɨ́yà nɨ kúlí dré fùzo gò, dré kɨdhózó adrélé tà ta, adrézó Gìká nɨ rú bha kùle. ");
INSERT INTO log_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Dɨ tirì dré gàzo àyɨ kɨ bhàzɨ̌ títí dhɨ ɨ léna bǐ. Gò à dré adrézó tà nda kɨ tɨtɨ́ bvò kòngo ró Yùdáyà àdhya ꞌásè wä́yi. ");
INSERT INTO log_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Móndyá títí tà nda kɨ yibhá dhɨ ɨ̀ adré tá tà nda kɨ kisù, adrézó lizíá àyɨ kòfalésè dhɨ: «Mvámvá kòdhɨ nɨ atsá àdhi ró?» Tàko ko, Mírì nɨ rìnyí tá mvámvá nda ɨ́be bàti. ");
INSERT INTO log_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zàkàrɨ́yà, mvámvá nda nɨ atá dré gàzo Tɨrɨ́ Lólo sè bǐ gò, dré ngàzo Gìká nɨ kúlí longó pròfétà àdhya tɨ́nɨ kònɨ̀nɨ: ");
INSERT INTO log_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Rúku kàdré Mírì, Ɨ̀sèrélè ànzɨ kɨ Gìká dré, dré alɨ̀le áyɨ móndyá kɨ lomɨ́, àyɨ kɨ apázó dhɨ sè. ");
INSERT INTO log_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Tàko ko, akódhɨ ꞌo dhya rìnyi ró dra àma kɨ tɨdrɨ́lépi dhɨ apfòle, áyɨ màrábà Dàwídì nɨ súrú lésè dre. ");
INSERT INTO log_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","ꞌO kònɨ̀nɨ ngóró dré tá lazílé kɨ́nó lésè, áyɨ pròfétà lólo dhɨ ɨ tí dhɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Lazí tá dhɨ, ɨ́ nɨ àma kɨ tɨdrɨ́ àma kɨ kàrɨbhá ɨ drɨ́gásè, ɨ̀ndɨ̀ móndyá títí adrébhá togó kònzɨ bha àma rú dhɨ ɨ drɨ́gásè. ");
INSERT INTO log_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ásà dhɨ, tadhá áyɨ togó dóro àma kɨ tábhí ɨ dré dre. Tɨvɨ̀ kpà tà lólo ɨ́ dré bhàle ru yìzo móndyá ɨ́na ɨ́be dhɨ ko. ");
INSERT INTO log_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Tàko ko, sɨ̀ tá mòndrà lazízóá àma kɨ tábhí Àbàrámà dré dhɨ, ");
INSERT INTO log_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ɨ́ nɨ àma kɨ apá àma kɨ kàrɨbhá ɨ drɨ́gásè, mà kàdréró áyɨ tà ꞌo tirì àko, ");
INSERT INTO log_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ngóró móndɨ́ lólo ɨ̀ndɨ̀ gyǎgya ɨ́ mìlésè dhɨ ɨ tɨ́nɨ, àma kɨ lókyá wä́yi sè. ");
INSERT INTO log_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Dɨ mɨ, áma mvá ro nɨ, à nɨ ámɨ zi Gìká kurú na bhù na dhɨ nɨ pròfétà ro. Àngyá ko, mɨ́ nɨ dhe lɨ̀le Mírì kandrána, kɨtswálé láti ledé akódhɨ dré. ");
INSERT INTO log_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Mɨ́ nɨ longóá akódhɨ nɨ móndyá ɨ dré dhɨ, akódhɨ nɨ àyɨ kɨ tàkonzɨ̀ kɨ tri, àyɨ kɨ tɨdrɨ́zó. ");
INSERT INTO log_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Àma kɨ Gìká nɨ ꞌòá kònɨ̀nɨ áyɨ togó dóro ɨ̀ndɨ̀ yàyà dhɨ sè. Ásà dhɨ, a nɨ ngádra amù àma dré bhù lésè ngóró kìtú nɨ apfòapfò tɨ́nɨ, ");
INSERT INTO log_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","kɨtswálé ngá kazá móndyá adrébhá lɨrɨ́lé tínímvá na dhɨ ɨ dré, ɨ̀ndɨ̀ àyɨ adrébhá lɨrɨ́lé lɨ́ndrɨ́ dràdrà àdhya zàle dhɨ ɨ dré, kɨtswálé kpà àma kɨ tidrì láti tà kɨ̀drɨ́kɨ̀drɨ àdhya ꞌásè.» ");
INSERT INTO log_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Dɨ mvámvá nda adré tá mbàle rúbhá sè ɨ̀ndɨ̀ tògyá sè. Adré tá adrélé duku na tsàle lókyá dré apfǒràꞌa Ɨ̀sèrélè ànzɨ ɨ kandrá dhɨ ꞌá. ");
INSERT INTO log_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Lókyá nda sè dhɨ, Rómà kɨ ópɨ́ kàdrɨ̀, Kàyìsárà Àwùgústò dré tòlɨ́ fèzo tàzoá dhɨ, à kòtɨsɨ̀ móndyá wä́yi Rómà kɨ òpɨ̀ zàle dhɨ kɨ rú búkù na. ");
INSERT INTO log_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Rú tɨsɨ̀ma drìdrì nda tá lókyá Kìrìníyò dré tá adréràꞌa gùvèrènérè ro bvò Sìríyà àdhya drìle dhɨ ꞌá. ");
INSERT INTO log_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Gò móndɨ́ àlo àlo títí dhɨ ɨ̀ dré ngàzo lɨ̀le àyɨ kɨ rú ꞌo tɨsɨ̀le àyɨ kɨ tàndɨ kɨ bhàandre ɨ ꞌásè. ");
INSERT INTO log_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Dɨ Yòséfà dré kpà ngàzo bhàandre Nàzàrétà àdhya bvò Gàlìláyà àdhya lé dhɨ lésè, lɨ̀le bhàandre ópɨ́ Dàwídì àdhya rú zìle Bètèlémè, bvò Yùdáyà àdhya lé dhɨ na. Tàko ko, angá tá ɨ́na Dàwídì nɨ súrú lésè. ");
INSERT INTO log_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ɨ̀ lɨ̀ tá kònàle àyɨ kɨ rú ꞌo tɨsɨ̀le túmä́ní Màrɨ́yà, tòkó zɨ̀le akódhɨ dré mòle dhɨ be. Màrɨ́yà nda tá ꞌa be. ");
INSERT INTO log_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ɨ̀ dré tá adréràꞌa Bètèlémè na dhɨ ꞌá dhɨ, Màrɨ́yà nɨ lókyá tìzo dhɨ dré kɨtswázó. ");
INSERT INTO log_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Dɨ dré áyɨ mváagó kàyo ró dhɨ nɨ tìzo, akódhɨ nɨ lambézó kɨ́tá sè, làle ayílé àrà kàꞌwá ɨ̀ dré tá adrézó ngá nya lána dhɨ na. Tàko ko, àrà ɨ̀ dré kɨtswázó ayílé kùmú kɨ dzó na dhɨ tá yókódhó. ");
INSERT INTO log_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Bvò nda na dhɨ, kábilígyà lɨkɨ́bhá àruka ɨ̀ adré tá ayílé mbɨ̀ na, adrélé àyɨ kɨ kábilígyà kɨ lɨkɨ́ ngátsi sè. ");
INSERT INTO log_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Dɨ ángéló Mírì àdhya dré ngàzo agálé àyɨ kandrá, Mírì nɨ lagulagu dré ngá kazázó àyɨ làgásè kúrú gò, ɨ̀ dré lyàzo kwàkwà tirì dré. ");
INSERT INTO log_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Dɨ, ángéló nda dré tàzoá àyɨ dré dhɨ: «Mɨ̀ ro ngá ko! Mɨ̀ yi rè ká! Má alɨ̀ rúbí tanɨ longó àmɨ dré. Dɨ móndyá títí dhɨ kɨ lenzé ásà tò. ");
INSERT INTO log_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ándrò, ngátsi kònɨ̀dhɨ sè dhɨ, à ti àmɨ dré dhya dra móndɨ́ kɨ tɨdrɨ́lépi dhɨ bhàandre Dàwídì àdhya na dre. Akódhɨ nda Mèsɨ́yà ꞌɨ, ɨ̀ndɨ̀ Mírì ꞌɨ. ");
INSERT INTO log_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Mɨ̀ nɨ akódhɨ nɨ ni tà kònɨ̀dhɨ sè: Mɨ̀ nɨ mvá kùrí kǎ lambélé kɨ́tá sè dhɨ nɨ kisú, adréràꞌa ayílé àrà kàꞌwá ɨ̀ dré adrézó ngá nya lána dhɨ na.» ");
INSERT INTO log_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Gbǎ kòdhwa, ángéló lɨ̀zólɨ̀zo bhù lésè dhɨ ɨ̀ dré agázó ángéló nda làga, adrélé Gìká nɨ rú bha kùle, adrézó tàá dhɨ: ");
INSERT INTO log_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Mìlanzìlanzì kàdré Gìká dré kurú na bhù na! Tà kɨ̀drɨ́kɨ̀drɨ kàdré kpà bvò dri móndyá akódhɨ nɨ togó dré adrézó kɨnɨ́lé ásà dhɨ ɨ dré!» ");
INSERT INTO log_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ángéló ɨ̀ kònga kábilígyà lɨkɨ́bhá nda ɨ vélésè gòle bhù na dre dhɨ, àyɨ nda ɨ̀ dré tàzoá àyɨ kòfalésè dhɨ: «Mà kòlɨ̀ dɨ Bètèlémè na, tà ru ꞌòlepi gò Mírì dré tà nɨ nɨ longózó àma dré kòdhɨ nɨ no wà!» ");
INSERT INTO log_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Dɨ ɨ̀ dré ngàzo lɨ̀le sɨ́rɨ́ Bètèlémè na gò, ɨ̀ dré Màrɨ́yà kɨ kisúzó Yòséfà ɨ́be, ɨ̀ndɨ̀ mvá kùrí kǎ adrélépi tá ayílé àrà kàꞌwá ɨ̀ dré adrézó ngá nya lána dhɨ na nda be. ");
INSERT INTO log_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ɨ̀ kònò mvámvá nda dre dhɨ, ɨ̀ dré ngàzo tà ángéló dré tá tàle àyɨ dré akódhɨ nɨ tà sè dhɨ nɨ tɨtɨ́ móndɨ́ bǐ dhɨ ɨ dré. ");
INSERT INTO log_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Móndyá títí tà nda nɨ yibhá dhɨ kɨ lɨ́ndrɨ́ dré gàzo, tà kábilígyà lɨkɨ́bhá nda ɨ̀ dré tàle àyɨ dré dhɨ nɨ tà sè. ");
INSERT INTO log_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Dɨ, Màrɨ́yà dré ɨ́na tà títí nda kɨ zùzo áyɨ togó na, adrézó àyɨ kɨ kisù. ");
INSERT INTO log_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Gò kábilígyà lɨkɨ́bhá nda ɨ̀ dré gòzo gòle, Gìká nɨ mì bhabe lanzìle, ɨ̀ndɨ̀ akódhɨ nɨ rú bhabe kùle, tà títí ɨ̀ dré yìle ɨ̀ndɨ̀ nòle ngóró tá longólé àyɨ dré dhɨ tɨ́nɨ dhɨ kɨ tà sè. ");
INSERT INTO log_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Mvámvá nda nɨ kìtú nɨ nzi-drì-na akódhɨ nɨ tìma àmvolésè dhɨ sè dhɨ, à dré akódhɨ nɨ lwàzo gò, akódhɨ nɨ rú zìzo Yésu, ngóró ángéló dré tá tàle àkò akódhɨ nɨ andre kisú rè ꞌa ko dhɨ ꞌá dhɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Gò Yòséfà ɨ Màrɨ́yà be dhɨ ɨ̀ dré àyɨ kɨ temvézó mvámvá nda nɨ tìma àmvolésè, ngóró Mósè nɨ tátrɨ́trɨ́ kúlí dré adrélé tàle dhɨ tɨ́nɨ. Lókyá nda kàkɨ́ dre dhɨ, ɨ̀ dré mvámvá nda nɨ dòzo lɨ̀zo ába Yèrúsalémà na, kɨtswálé akódhɨ nɨ fe Mírì dré dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Tàko ko, Mírì nɨ tátrɨ́trɨ́ kúlí adré tàá dhɨ: «Lè à kàdré ànzɨàgo títí kàyo ró dhɨ kɨ fe adrélé lólo Mírì dré.» ");
INSERT INTO log_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Kòdhɨ ɨ́be dhɨ, ɨ̀ lɨ̀ kɨtswálé ngá fe Mírì dré, ngóró akódhɨ nɨ tátrɨ́trɨ́ kúlí dré adrélé tàle dhɨ tɨ́nɨ: «À kàdré kòbhòlà rì dhɨ ꞌɨ yà, kó ngalè kòbhòlà ngbòlò rì dhɨ ꞌɨ yà dhɨ kɨ fe.» ");
INSERT INTO log_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Lókyá nda sè dhɨ, agó àlo rú be Sìmèyónà dhɨ tá Yèrúsalémà na. Akódhɨ nda tá móndɨ́ gyǎgya, adrélépi tròle Gìká nɨ tà rú dhɨ ꞌɨ. Adré tá Mèsɨ́yà nɨ letè alɨ̀le Ɨ̀sèrélè ànzɨ kɨ tɨdrɨ́. Akódhɨ tá kpà Tɨrɨ́ Lólo ɨ́be ɨ́ dri. ");
INSERT INTO log_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Tɨrɨ́ Lólo nda longó tá drá dhɨ, kɨtswá rè dràle drìdrì dré Mírì nɨ Mèsɨ́yà nɨ nòzo dhɨ kandrá dhɨ ko. ");
INSERT INTO log_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Dɨ kìtú nda sè dhɨ, Tɨrɨ́ Lólo drì tá akódhɨ lɨ̀le fɨ̀le tépelò na. Yésu nɨ tibhá ɨ̀ kàfɨ́ kɨtswálé akódhɨ nɨ fe Gìká dré ngóró tátrɨ́trɨ́ kúlí dré adrélé tàle dhɨ tɨ́nɨ dre dhɨ, ");
INSERT INTO log_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Sìmèyónà dré mvámvá nda nɨ adózó ɨ́ drɨ́gá gò, Gìká nɨ rú bhàzo kùle, tàzoá dhɨ: ");
INSERT INTO log_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Mírì rúku ró nɨ, nyànomvá dhɨ, mɨ́ nɨ kɨtswá ámɨ màrábà nɨ tayɨ́ dràle tà kɨ̀drɨ́kɨ̀drɨ na, ngóró mɨ́ dré tá lazílé má dré dhɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Tàko ko, má nò dhya mɨ́ dré dra móndɨ́ kɨ tɨdrɨ́zó nɨ áma mì sè dre. ");
INSERT INTO log_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Mɨ́ bhà tá akódhɨ nɨ tà drìdrì, kòkɨtswáró ámɨ tà ꞌo móndyá títí ɨ mi. ");
INSERT INTO log_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Akódhɨ ngádra dra ámɨ ꞌòlepi súrú títí dhɨ ɨ̀ dré nìle dhɨ ꞌɨ. A nɨ kpà ámɨ mìlanzìlanzì tadhá ámɨ súrú Ɨ̀sèrélè ànzɨ ɨ dré.» ");
INSERT INTO log_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Mvámvá nda nɨ atá ɨ andre nɨ be dhɨ kɨ lɨ́ndrɨ́ dré gàzo, tà tàle akódhɨ nɨ tà dri nda kɨ tà sè. ");
INSERT INTO log_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Dɨ Sìmèyónà dré tà tanɨ zìzo Gìká tí àyɨ dri gò, tàzoá Màrɨ́yà, Yésu nɨ andre dré dhɨ: «Mɨ́ nò rè ká! Mvámvá kònɨ̀dhɨ atsá kɨtswálé Ɨ̀sèrélè ànzɨ bǐ dhɨ kɨ ꞌo ledhélé, ɨ̀ndɨ̀ àyɨ bǐ dhɨ kɨ ꞌo ngàle. Akódhɨ nɨ tà nɨ kpà adré tà adrézó tà ta rúá kònzɨ dhɨ ꞌɨ, ");
INSERT INTO log_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","kɨtswálé tà móndɨ́ zyandre dhɨ ɨ̀ dré adrélé kisùle dhɨ ɨ̀ kàpfòró ngádra ꞌá be dhɨ bvó. Dɨ mɨ ró dhɨ, kɨzà nɨ kpà ámɨ tàndɨ nɨ togó so ngóró sápɨ́ tɨ́nɨ.» ");
INSERT INTO log_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Lókyá nda sè dhɨ, pròfétà àlo tòko ró rú be Ánà dhɨ tá kpà tépelò na. Akódhɨ nda tá Fànùwélè, Àsérà nɨ súrú lésè dhɨ nɨ zapi ꞌɨ. Akódhɨ agà tá tà tàndɨ ró. Ɨ̀ gi tá agó dré tá mòle áyɨ kyanzɨ̀ lókyá ꞌá dhɨ be ngbà ꞌí kóná nzi-drì-rì. ");
INSERT INTO log_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Agó nɨ nɨ dràma àmvolésè dhɨ, adré tá ngbú tàyɨ́tòko ró tsàle áyɨ kóná dré tsaràꞌa nyadhɨ-su-drì-su dhɨ ꞌá. Adré tá ngbú adrélé tépelò na, adrélé Gìká nɨ lɨndrɨ̀ bha, adrézó tàbirí mvo, adrézó tà zi akódhɨ tí kìtú vésè, ɨ̀ndɨ̀ ngátsi vésè. ");
INSERT INTO log_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Dɨ lókyá Yésu nɨ tibhá ɨ̀ dré tá adréràꞌa akódhɨ nɨ fe Gìká dré dhɨ ꞌá dhɨ, Ánà nda dré áyɨ kisízó ànyɨ àyɨ làga gò, kɨdhólé adrélé àwoyà fe Gìká dré mvámvá nda nɨ tà sè. Dɨ dré ngàzo adrélé akódhɨ nɨ tà ta móndyá títí adrébhá tá Yèrúsalémà nɨ apama letè dhɨ ɨ dré. ");
INSERT INTO log_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yòséfà ɨ Màrɨ́yà be dhɨ ɨ̀ kòꞌo tà títí Mírì nɨ tátrɨ́trɨ́ kúlí dré adrélé tàle à kòꞌo dhɨ ɨ akɨ́lé dre dhɨ, ɨ̀ dré gòzo nzɨ̀le Yésu be bvò Gàlìláyà àdhya na, tsàle àyɨ kɨ bhàandre Nàzàrétà na. ");
INSERT INTO log_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Kònàle dhɨ, mvámvá nda adré tá mbàle rìnyí sè, adrélé kpà lɨꞌwálé tògyá na. Akódhɨ tá kpà Gìká nɨ togó tanɨ ɨ́be ɨ́ rú. ");
INSERT INTO log_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Kóná àlo àlo títí dhɨ ɨ sè dhɨ, Yésu nɨ tibhá ɨ̀ adré tá lɨ̀le Yèrúsalémà na gwányá Pásɨkà àdhya nɨ tà sè. ");
INSERT INTO log_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Dɨ Yésu nɨ kóná kòtsa mudrí-drì-rì dre dhɨ, ɨ̀ dré ngàzo lɨ̀le akódhɨ be gwányá nda na, ànzyà gà ɨ̀ dré adrélé ꞌòle dhɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Gwányá nda kàkɨ́ dre dhɨ, ɨ̀ dré láti dòzo nzɨ̀zo. Dɨ, Yésu mvámvá ro nda gò ɨ́na adrélé Yèrúsalémà na, áyɨ tibhá ɨ̀ dré atógyà àko ró. ");
INSERT INTO log_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ɨ̀ adré tá àyɨkya kisùá dhɨ, Yésu tá àyɨ kɨ atsíàmu ɨ kòfalé. Ɨ̀ kòto atsí kìtú ndìle dre dhɨ, ɨ̀ dré kɨdhózó akódhɨ nɨ nda àyɨ kɨ aró ɨ kòfalé, àyɨ kɨ arúpi ɨ́be. ");
INSERT INTO log_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Dɨ, ɨ̀ kòndà akódhɨ tɨ́ dre dhɨ, ɨ̀ dré gòzo àyɨ kɨ tapɨ́ gòle akódhɨ nɨ nda Yèrúsalémà na. ");
INSERT INTO log_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Kìtú na àmvolésè dhɨ, ɨ̀ dré akódhɨ nɨ kisúzó tépelò na. Lɨrɨ́ tá tà tadhábhá ɨ kòfalé adrélé àyɨ kɨ yi, adrézó tà lizí àyɨ tí. ");
INSERT INTO log_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Àyɨ títí nda ɨ̀ adré tá akódhɨ nɨ yi síbhálé be ngbo, akódhɨ nɨ tògyá nɨ tà sè, ɨ̀ndɨ̀ kúlí dré tá adrélé logólé dhɨ kɨ tà sè. ");
INSERT INTO log_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Dɨ akódhɨ nɨ tibhá ɨ̀ kònò akódhɨ dre dhɨ, àyɨ kɨ lɨ́ndrɨ́ dré gàzo bhwǎbhwa gò, andre nɨ dré akódhɨ nɨ lizízó: «Áma mvá, mɨ́ ꞌo tsì àma kònɨ̀nɨ àdho tà sè? Mɨ́ nò rè ká! Àma ámɨ atá be dhɨ, mà adré tá ámɨ nda togó be lanzìlanzì.» ");
INSERT INTO log_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Dɨ, Yésu logó àyɨ dré dhɨ: «Mɨ̀ adré tá áma nda àdho tà sè? Mɨ̀ nì tá ko tàle dhɨ, lè tá má kàdré áma Atá nɨ dzó na dhɨ?» ");
INSERT INTO log_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Dɨ, tà dré tàle nda nɨ àndu dré ɨ́na fɨ̀zo àyɨ drìna ko. ");
INSERT INTO log_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Gò Yésu ɨ̀ dré gòzo nzɨ̀le túmä́ní àyɨ ɨ́be Nàzàrétà na. Kònàle dhɨ, akódhɨ adré tá áyɨ bha àyɨ kɨ rìnyí zàle. Dɨ andre nɨ adré tá ɨ́na tà títí nda kɨ zu tayɨ́lé áyɨ togó na. ");
INSERT INTO log_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yésu adré tá mbàle rúbhá sè ɨ̀ndɨ̀ tògyá sè, adrélé lɨ̀le drìdrì. Akódhɨ nɨ tà tá kpà dóro Gìká mìlésè ɨ̀ndɨ̀ móndɨ́ ɨ mìlésè. ");
INSERT INTO log_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Kàyìsárà Tìbèríyò nɨ kóná nɨ mudrí-drì-nzi adrézó Rómà kɨ ópɨ́ kàdrɨ̀ ro dhɨ sè dhɨ, Pòtíyò Pìlátò tá gùvèrènérè bvò Yùdáyà àdhya drìle dhɨ ꞌɨ. Èródè tá ɨ́na ópɨ́ bvò Gàlìláyà àdhya drìle dhɨ ꞌɨ. Akódhɨ nɨ adrúpi, Fìlípò tá ɨ́na ópɨ́ bvò Ìtùráyà àdhya drìle ɨ̀ndɨ̀ Tràkònítì àdhya drìle dhɨ ꞌɨ. Lìsàníyà tá ɨ́na ópɨ́ bvò Àbìlénè àdhya drìle dhɨ ꞌɨ. ");
INSERT INTO log_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Dɨ lókyá Ánà ɨ Kàyáfà be dhɨ ɨ̀ dré tá adréràꞌa kòwánà kɨ kàdrɨ̀ ɨ ró dhɨ ꞌá dhɨ, Gìká nɨ kúlí dré tsàzo Yòwánɨ̀, Zàkàrɨ́yà nɨ mvá véna duku na. ");
INSERT INTO log_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Gò akódhɨ nda dré ngàzo tatsílé bvò wä́yi Yòròdánè làgásè dhɨ ꞌásè longóába móndɨ́ ɨ dré dhɨ, ɨ̀ kòladzá àyɨ kɨ togó gò, bàtísimò dòzo, Gìká kòtrìró àyɨ kɨ tàkonzɨ̀ ɨ be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Dɨ tà nda kòdhɨ ꞌo tá ru ngóró pròfétà Èsáyà dré tá tɨsɨ̀le áyɨ búkù na dhɨ tɨ́nɨ: «Dhya àlo adré kúlí loyó duku na, adrézó tàá dhɨ: ‹Mɨ̀ kòledé láti Mírì dré alɨ̀zo! Mɨ̀ kòlotó láti atsálé pyà akódhɨ dré! ");
INSERT INTO log_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","À nɨ yábhu títí dhɨ kɨ lutú, kòngó títí kàdrɨ̀kàdrɨ̀ ro ɨ̀ndɨ̀ tsàtsà ro dhɨ kɨ lasézó. À nɨ láti gòdhógòdho dhɨ kɨ lotó atsálé pyà, láti bhúrobhúro dhɨ kɨ lutúzó atsálé kpàkpà. ");
INSERT INTO log_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Dɨ móndyá títí dhɨ kɨ tà Gìká dré ꞌòle àyɨ kɨ tɨdrɨ́zó dhɨ nɨ no.›» ");
INSERT INTO log_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Dɨ Yòwánɨ̀ adré tá tàá móndyá zyandre adrébhá apfòle bàtísimò do ɨ́ vélé dhɨ ɨ dré dhɨ: «Àmɨ, nì àtrá kɨ àrèbhá nɨ ɨ, àdhi tadhá àmɨ dré dhɨ, mɨ̀ kòlapá Gìká nɨ kombà adrélépi alɨ̀le dhɨ sílésè dhɨ nɨ̀? ");
INSERT INTO log_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Lè mɨ̀ kàdré tà adrébhá tadhá dhɨ, mɨ̀ ladzá àmɨ kɨ togó dre dhɨ kɨ ꞌo kòdhya. Mɨ̀ kòbhà àmɨ adrélé kisùá àmɨ léna dhɨ ‹Àma àmakya Àbàrámà nɨ ànzɨ ꞌɨ› dhɨ ko. Tàko ko, má adré tàá àmɨ dré dhɨ: Gìká rìnyí ɨ́be kɨtswázó ànzɨ ꞌo topfòle Àbàrámà dré kɨ́rà kònɨ ɨ lésè. ");
INSERT INTO log_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","À ga kùbalú fa kómvó ɨ rú dre. Dɨ à nɨ fa títí adrébhá lòꞌwa dóro ꞌa ko dhɨ kɨ togá lebhélé àtsɨ́ na.» ");
INSERT INTO log_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Dɨ móndyá zyandre nda ɨ̀ adré tá lizíá akódhɨ tí dhɨ: «Lè mà kàdré dɨ àdho tà ꞌo kòdhya?» ");
INSERT INTO log_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Dɨ Yòwánɨ̀ adré tá logóá àyɨ dré dhɨ: «Lè dhya adrélépi kɨ́tá agá lésè dhɨ ɨ́be rì dhɨ kòfè àlo nɨ dhya àkoá dhɨ dré. Dhya adrélépi mányàngá ɨ́be dhɨ kàdré kpà lanzɨ́á móndɨ́ tàbirí ɨ́be dhɨ ɨ dré be.» ");
INSERT INTO log_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Mèdáyɨ̀ lagɨ́bhá ɨ̀ dré kpà alɨ̀zo bàtísimò do gò, ɨ̀ dré akódhɨ nɨ lizízó tàzoá dhɨ: «Tadhálépi, mà kàdré àmakya àdho tà ꞌo kòdhya?» ");
INSERT INTO log_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Yòwánɨ̀ logó àyɨ dré dhɨ: «Mɨ̀ kòzi móndɨ́ kɨ làfa mèdáyɨ̀ sè làgɨ́ ŋòle dhɨ nɨ lavú dhɨ ko.» ");
INSERT INTO log_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Gò sòdá àruka ɨ̀ dré kpà akódhɨ nɨ lizízó tàzoá dhɨ: «Mà kàdré dɨ àmakya àdho tà ꞌo?» Akódhɨ logó àyɨ dré dhɨ: «Mɨ̀ kòtopá dhya àlo nɨ làfa ko. Mɨ̀ kàsíkì kpà dhya àlo kɨnzò sè ko. Àmɨ kɨ togó kàdré kɨnɨ́lé làfa adrélé fèle àmɨ dré àmɨ kɨ àzí sè dhɨ sè.» ");
INSERT INTO log_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Móndyá títí nda ɨ̀ adré tá Yòwánɨ̀ nɨ tà letè nòle, adrézó lizíá àyɨ léna ngalè akódhɨ tá ɨ́na Mèsɨ́yà ꞌɨ yà dhɨ. ");
INSERT INTO log_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Dɨ Yòwánɨ̀ dré tàzoá àyɨ títí ɨ dré dhɨ: «Má adré mána bàtísimò fe àmɨ dré yǐ sè. Dɨ, dhya àlo áma lavúlépi rìnyí sè dhɨ adré ɨ́na alɨ̀le. Má kɨtswá akódhɨ nda nɨ lɨndrɨ̀ sè ko. Má kɨtswá ndɨ̀ndɨ̀ akódhɨ nɨ kámókà bǎ trɨ bwà ko. Akódhɨ nɨ ɨ́na bàtísimò fe àmɨ dré Tɨrɨ́ Lólo sè, ɨ̀ndɨ̀ àtsɨ́ sè. ");
INSERT INTO log_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Akódhɨ ndàkpá ɨ́be ɨ́ drɨ́gá kɨtswázó ngánò awá áyɨ àngbó drìna, lòꞌwa nɨ nɨ lomvózó dàle áyɨ kòbhó na gò, kúyí nɨ nɨ kùzo zàle àtsɨ́ adrélépi adrálé ko dhɨ na.» ");
INSERT INTO log_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yòwánɨ̀ adré tá kpà Rúbí Tanɨ longó móndyá nda ɨ dré, adrézó àyɨ kɨ kodzó kúlí àruka ɨ sè bǐ. ");
INSERT INTO log_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Kòdhɨ ɨ́be dhɨ, Yòwánɨ̀ adré tá ópɨ́ Èródè nɨ ndrɨ, dré tá adrúpi nɨ nɨ tòkó Èròdɨ́yà nɨ dòle mòle dhɨ sè, ɨ̀ndɨ̀ dré tá tà kònzɨ àruka bǐ dhɨ kɨ ꞌòle dhɨ sè. ");
INSERT INTO log_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Gò Èródè dré ɨ́na tà kònzɨ kònɨ̀dhɨ nɨ bhàzo áyɨ tà kònzɨ àruka títí dhɨ ɨ dri: ꞌo Yòwánɨ̀ rùle bhèle bǎdzó na. ");
INSERT INTO log_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Yòwánɨ̀ nɨ rùma kandrá, akódhɨ dré tá adréràꞌa bàtísimò fe móndyá títí ɨ dré dhɨ ꞌá dhɨ, Yésu dré kpà alɨ̀zo bàtísimò do. Dré tá adréràꞌa tà zi Gìká tí dhɨ ꞌá dhɨ, bhù dré ru lanzízó gò, ");
INSERT INTO log_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Tɨrɨ́ Lólo dré asízó rúbhá be sùle kòbhòlà àdhya tɨ́nɨ adhélé akódhɨ dri. Gò kúlí dré apfòzo bhù lésè tàá dhɨ: «Mɨ áma Mváagó má dré lèle tò dhɨ ꞌɨ. Áma togó adré kɨnɨ́lé ámɨ tà sè tò.» ");
INSERT INTO log_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Lókyá Yésu dré áyɨ àzí kɨdhózó dhɨ sè dhɨ, akódhɨ nɨ kóná tá ànyɨ́ànyɨ nyadhɨ-àlo-drì-mudrí. À adré tá akódhɨ nɨ ni Yòséfà nɨ mvá ro. Yòséfà tá ɨ́na Élì nɨ mvá ꞌɨ, ");
INSERT INTO log_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Élì, Màtátà nɨ mvá ꞌɨ, Màtátà, Lévì nɨ mvá ꞌɨ, Lévì, Mèlíkì nɨ mvá ꞌɨ, Mèlíkì, Yànáyɨ̀ nɨ mvá ꞌɨ, Yànáyɨ̀, Yòséfà nɨ mvá ꞌɨ, ");
INSERT INTO log_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yòséfà, Màtàtɨ́yà nɨ mvá ꞌɨ, Màtàtɨ́yà, Àmósà nɨ mvá ꞌɨ, Àmósà, Nàwúmà nɨ mvá ꞌɨ, Nàwúmà, Èsílì nɨ mvá ꞌɨ, Èsílì, Nàgáyɨ̀ nɨ mvá ꞌɨ, ");
INSERT INTO log_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nàgáyɨ̀, Mátà nɨ mvá ꞌɨ, Mátà, Màtàtɨ́yà nɨ mvá ꞌɨ, Màtàtɨ́yà, Sèmèyɨ́nà nɨ mvá ꞌɨ, Sèmèyɨ́nà, Yòsékà nɨ mvá ꞌɨ, Yòsékà, Yódà nɨ mvá ꞌɨ, ");
INSERT INTO log_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yódà, Yòwànánà nɨ mvá ꞌɨ, Yòwànánà, Résà nɨ mvá ꞌɨ, Résà, Zòròbàbélè nɨ mvá ꞌɨ, Zòròbàbélè, Sàlàtɨ̀yélè nɨ mvá ꞌɨ, Sàlàtɨ̀yélè, Nérì nɨ mvá ꞌɨ, ");
INSERT INTO log_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nérì, Mèlíkì nɨ mvá ꞌɨ, Mèlíkì, Ádì nɨ mvá ꞌɨ, Ádì, Kòsámà nɨ mvá ꞌɨ, Kòsámà, Èlàmàdámà nɨ mvá ꞌɨ, Èlàmàdámà, Érè nɨ mvá ꞌɨ, ");
INSERT INTO log_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Érè, Yòsúwà nɨ mvá ꞌɨ, Yòsúwà, Èlɨ̀yèzérè nɨ mvá ꞌɨ, Èlɨ̀yèzérè, Yòrímà nɨ mvá ꞌɨ, Yòrímà, Màtátà nɨ mvá ꞌɨ, Màtátà, Lévì nɨ mvá ꞌɨ, ");
INSERT INTO log_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lévì, Sìmèyónà nɨ mvá ꞌɨ, Sìmèyónà, Yúdà nɨ mvá ꞌɨ, Yúdà, Yòséfà nɨ mvá ꞌɨ, Yòséfà, Yònámà nɨ mvá ꞌɨ, Yònámà, Èlìyàkímà nɨ mvá ꞌɨ, ");
INSERT INTO log_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Èlìyàkímà, Mèléyà nɨ mvá ꞌɨ, Mèléyà, Ménà nɨ mvá ꞌɨ, Ménà, Màtátà nɨ mvá ꞌɨ, Màtátà, Nàtánà nɨ mvá ꞌɨ, Nàtánà, Dàwídì nɨ mvá ꞌɨ, ");
INSERT INTO log_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dàwídì, Yésè nɨ mvá ꞌɨ, Yésè, Yòbédè nɨ mvá ꞌɨ, Yòbédè, Bòwésà nɨ mvá ꞌɨ, Bòwésà, Sálà nɨ mvá ꞌɨ, Sálà, Nàsónà nɨ mvá ꞌɨ, ");
INSERT INTO log_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nàsónà, Àmìnàdábà nɨ mvá ꞌɨ, Àmìnàdábà, Àdìmínà nɨ mvá ꞌɨ, Àdìmínà, Àrínì nɨ mvá ꞌɨ, Àrínì, Èsèrómà nɨ mvá ꞌɨ, Èsèrómà, Fàrésà nɨ mvá ꞌɨ, Fàrésà, Yúdà nɨ mvá ꞌɨ, ");
INSERT INTO log_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yúdà, Yàkóbhò nɨ mvá ꞌɨ, Yàkóbhò, Ɨ̀sákà nɨ mvá ꞌɨ, Ɨ̀sákà, Àbàrámà nɨ mvá ꞌɨ, Àbàrámà, Tárà nɨ mvá ꞌɨ, Tárà, Nàkórà nɨ mvá ꞌɨ, ");
INSERT INTO log_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nàkórà, Sèrúkà nɨ mvá ꞌɨ, Sèrúkà, Ràgáwù nɨ mvá ꞌɨ, Ràgáwù, Fàlékà nɨ mvá ꞌɨ, Fàlékà, Èbérè nɨ mvá ꞌɨ, Èbérè, Sálà nɨ mvá ꞌɨ, ");
INSERT INTO log_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sálà, Kàyɨ̀námà nɨ mvá ꞌɨ, Kàyɨ̀námà, Àràfàkàsádà nɨ mvá ꞌɨ, Àràfàkàsádà, Sémè nɨ mvá ꞌɨ, Sémè, Nówè nɨ mvá ꞌɨ, Nówè, Làmékè nɨ mvá ꞌɨ, ");
INSERT INTO log_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Làmékè, Màtúsalà nɨ mvá ꞌɨ, Màtúsalà, Ènókà nɨ mvá ꞌɨ, Ènókà, Yàrétà nɨ mvá ꞌɨ, Yàrétà, Màlèlélè nɨ mvá ꞌɨ, Màlèlélè, Kàyɨ̀námà nɨ mvá ꞌɨ, ");
INSERT INTO log_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kàyɨ̀námà, Ènósà nɨ mvá ꞌɨ, Ènósà, Sétè nɨ mvá ꞌɨ, Sétè, Àdámà nɨ mvá ꞌɨ, ɨ̀ndɨ̀ Àdámà tá ɨ́na Gìká nɨ mvá ꞌɨ. ");
INSERT INTO log_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Àmvolásà dhɨ, Yésu gàlepi Tɨrɨ́ Lólo sè dhɨ dré agòzo Yòròdánè lésè. Gò Tɨrɨ́ nda dré akódhɨ nɨ drìzo lɨ̀zo ába duku na. ");
INSERT INTO log_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Kònàle dhɨ, Dzáborò dré akódhɨ nɨ tabhìzo lɨtɨ́lé kìtú nyadhɨ-rì. Lókyá nda sè dhɨ, Yésu nya ngá àlomvá ko. Dɨ kìtú nda ɨ̀ kòlavú dre dhɨ, tàbirí dré akódhɨ nɨ ꞌòzo. ");
INSERT INTO log_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Gò Dzáborò nda dré tàzoá drá dhɨ: «Mɨ́ kàdré Gìká nɨ Mváagó ꞌɨ bàti dhɨ, mɨ́ kòtà kɨ́rà kònɨ̀dhɨ dré dhɨ, kòladzá ru atsálé mápà ro.» ");
INSERT INTO log_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Dɨ, Yésu logó drá dhɨ: «Gìká nɨ Kúlí adré tàá dhɨ: ‹Móndɨ́ adré ngbà ꞌí adrélé lɨ́drɨ̀ ɨ́be mápà sè ko.›» ");
INSERT INTO log_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Gò Dzáborò dré akódhɨ nɨ drìzo mbàzo ába àrà kurú na dhɨ na, òpɨ̀ wä́yi bvò àdhya kɨ tadházó drá gbǎ lókyá nda ꞌá. ");
INSERT INTO log_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Dré tàzoá drá dhɨ: «Má nɨ rìnyí fe mɨ́ dré rúku ɨ́be adrézó òpɨ̀ kòdhɨ ɨ drìle títí. Àngyá ko, à tayɨ́ tà nda kòdhɨ ɨ má drɨ́gá, má kòkɨtswáró fèá dhya ángùdhi má dré adrézó lèá fèle drá dhɨ dré. ");
INSERT INTO log_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Dɨ mɨ́ kòtitì ámɨ kórókó má kandrá áma lɨndrɨ̀ bhàzo dhɨ, tà nda kɨ adré títí mɨ́ dré.» ");
INSERT INTO log_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yésu gò logóá drá dhɨ: «Gìká nɨ Kúlí adré tàá dhɨ: ‹Lè mɨ́ kàdré ngbà ꞌí Mírì ámɨ Gìká nɨ lɨndrɨ̀ bha kòdhya. Mɨ́ kàdré kpà lɨ̀sámbò ꞌo ngbà ꞌí akódhɨ nɨ rú sè kalóma.›» ");
INSERT INTO log_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Gò Dzáborò dré akódhɨ nɨ drìzo lɨ̀zo ába Yèrúsalémà na, akódhɨ nɨ bha tépelò nɨ drì kàkú na. Dré tàzoá drá dhɨ: «Mɨ́ kàdré Gìká nɨ Mváagó ꞌɨ bàti dhɨ, mɨ́ wa dhèle bvò dri. ");
INSERT INTO log_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Àngyá ko, Gìká nɨ Kúlí adré tàá dhɨ: ‹Gìká nɨ tòlɨ́ fe áyɨ ángéló ɨ dré ámɨ tà sè, ɨ̀ kàdréró sùle mɨ́ rú be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Àyɨ nda kɨ ámɨ ko kɨ́tó, mɨ́ kòdheró ámɨ pá si kɨ́rà dri ko.›» ");
INSERT INTO log_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Dɨ Yésu gò logóá drá dhɨ: «Gìká nɨ Kúlí adré kókpà tàá dhɨ: ‹Lè mɨ́ kòtabhì Mírì ámɨ Gìká ko.›» ");
INSERT INTO log_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Dɨ Dzáborò kòtabhì Yésu lɨtɨ́lé láti títí ɨ sè kpi dre dhɨ, dré ngàzo akódhɨ nɨ tayɨ́, adrézó lókyá àzya dré kɨtswázó tà ꞌo dhɨ nɨ letè. ");
INSERT INTO log_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Àmvolásà dhɨ, Yésu dré gòzo gòle bvò Gàlìláyà àdhya na Tɨrɨ́ Lólo nɨ rìnyí be wě. Dɨ akódhɨ nɨ rúbí dré laꞌúzó bvó wä́yi nda ꞌásè. ");
INSERT INTO log_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Akódhɨ adré tá tatsílé tà tadhábe Yúdà ànzɨ kɨ lɨ̀sámbò dzó ɨ ꞌásè gò, móndyá títí dhɨ ɨ̀ dré adrézó akódhɨ nɨ rú bha kùle. ");
INSERT INTO log_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Gò Yésu dré lɨ̀zo tsàle Nàzàrétà, bhàandre ɨ́ dré tá mbàzo lána dhɨ na. Sàbátù kàtsá dre dhɨ, dré fɨ̀zo Yúdà ànzɨ kɨ lɨ̀sámbò dzó na, ànzyà gà dré adrélé ꞌòle dhɨ tɨ́nɨ. Dré ngàzo áyɨ totó kɨtswálé Gìká nɨ Kúlí na móndɨ́ ɨ kandrá dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Gò búkù pàle pròfétà Èsáyà àdhya nɨ fèzo drá. Akódhɨ kòkɨnzɨ́ búkù nda dre dhɨ, dré kúlí tɨsɨ̀le kònɨ kɨ kisúzó nàle: ");
INSERT INTO log_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Tɨrɨ́ Mírì àdhya má dri. Tàko ko, akódhɨ zɨ̀ ma alɨ̀le Rúbí Tanɨ longó móndyá lemerè ro dhɨ ɨ dré. Amù ma longóá móndyá bǎdzó na dhɨ ɨ dré dhɨ, a nɨ àyɨ kɨ trɨ, ɨ̀ndɨ̀ móndyá mì kùdúkùdu ró dhɨ ɨ dré dhɨ, a nɨ àyɨ kɨ mì nzi. Amù ma móndyá adrélé mì pfòle dhɨ kɨ apá, ");
INSERT INTO log_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ɨ̀ndɨ̀ longóá móndyá títí ɨ dré dhɨ, kóná Mírì dré dra áyɨ togó dóro tadházó dhɨ atsá dre.» ");
INSERT INTO log_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yésu kònà tà nda ɨ dre dhɨ, dré búkù nda nɨ pàzo logólé lɨ̀sámbò dzó nda nɨ tà lɨkɨ́lépi drɨ́gá gò, lɨrɨ́zó. Móndyá títí dzó nda ꞌá dhɨ kɨ mì tá akódhɨ dri. ");
INSERT INTO log_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Dɨ dré ngàzo tàá àyɨ dré dhɨ: «Ándrò kònɨ̀dhɨ, tà tɨsɨ̀le kònɨ ɨ̀ ꞌo ru, mɨ̀ dré tà nda kɨ yiràꞌa dre.» ");
INSERT INTO log_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Àyɨ títí nda ɨ̀ adré tá kúlí kɨ̀nɨ́kɨ̀nɨ dré tá adrélé tàle dhɨ kɨ yi síbhálé be ngbo, adrézó akódhɨ nɨ tà ta dóro. Ɨ̀ adré tá kpà lizíá àyɨ kòfalésè dhɨ: «Dhya kòndɨ tsì Yòséfà nɨ mvá ꞌɨ ko?» ");
INSERT INTO log_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Dɨ Yésu dré tàzoá àyɨ dré dhɨ: «Má nì dóro tàle dhɨ, mɨ̀ nɨ tògyakúlí kònɨ̀dhɨ nɨ ta má dré: ‹Kódzó, mɨ́ kòtɨdrɨ́ ámɨ tàndɨ.› Mɨ̀ nɨ kpà tàá má dré dhɨ: ‹Mɨ́ kòꞌo tà títí mà dré yìle mɨ́ dré ꞌòle Kàpàrànàwúmà na dhɨ ɨ kònwa ámɨ tàndɨ bha.› ");
INSERT INTO log_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Dɨ má adré tà bàti ta àmɨ dré: À kaꞌì gà pròfétà àlo dhɨ dòle dóro akódhɨ nɨ tàndɨ bha ko na. ");
INSERT INTO log_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Tà bàti ró dhɨ, pròfétà Èlɨ́yà nɨ lókyá ꞌá dhɨ, lókyá Gìká dré kozya kɨkɨ́zó kóná na tàlí sè gò, kàrábhò dré dhèzo bvò wä́yi ꞌásè dhɨ sè dhɨ, tàyɨ́tòkó ɨ̀ ga tá Ɨ̀sèrélè ànzɨ kɨ bvò na bǐ. ");
INSERT INTO log_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Dɨ, tágba dré tá adrézó kònɨ̀nɨ dhɨ, Gìká mù tá Èlɨ́yà lɨ̀le àyɨ nda ɨ véna ko. Mù akódhɨ lɨ̀le ngbà ꞌí tàyɨ́tòkó àlo Sàrèpátà na, bvò Sìdónà àdhya na dhɨ véna. ");
INSERT INTO log_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Kòdhɨ ɨ́be dhɨ, pròfétà Èlísà nɨ lókyá ꞌá dhɨ, móndɨ́ kàrɨ́ dré rùle Ɨ̀sèrélè ànzɨ kɨ bvò na dhɨ ɨ tá be bǐ. Dɨ, tágba kònɨ̀nɨ dhɨ, Gìká tɨdrɨ́ tá àyɨ nda kɨ àlo ko. Tɨdrɨ́ ngbà ꞌí Nàmánà angálépi bvò Sìríyà àdhya lésè dhɨ kòdhya.» ");
INSERT INTO log_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Dɨ móndyá títí lɨ̀sámbò dzó nda ꞌá dhɨ ɨ̀ kòyi tà nda ɨ dre dhɨ, àyɨ kɨ togó dré aswázó tà tàndɨ ró. ");
INSERT INTO log_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Gò ɨ̀ dré ngàzo akódhɨ nɨ dro bhàandre nda ꞌásè. Ɨ̀ dré drìzoá lɨ̀zo ába kòngó bhàandre nda nɨ mòzo drìá dhɨ nɨ gòlòko na, kɨtswálé akódhɨ nɨ tɨkpó dhèle tàbhu nɨ na dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Dɨ, Yésu dré ɨ́na lavúzó àyɨ kòfalésè lyà gò, lɨ̀le. ");
INSERT INTO log_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Àmvolásà dhɨ, Yésu dré lɨ̀zo tsàle Kàpàrànàwúmà, bhàandre àlo Gàlìláyà le dhɨ na. Sàbátù kàtsá dre dhɨ, dré kɨdhózó adrélé móndyá kònàle dhɨ kɨ tadhá àyɨ kɨ lɨ̀sámbò dzó na. ");
INSERT INTO log_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ɨ̀ adré tá akódhɨ nɨ yi síbhálé be ngbo, tà dré adrélé tadhálé dhɨ kɨ tà sè. Tàko ko, akódhɨ nɨ kúlí ɨ tá lanzìlanzì ro. ");
INSERT INTO log_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Lɨ̀sámbò dzó nda ꞌá dhɨ, agó àlo tɨrɨ́ kònzɨ ɨ́be ɨ́ léna dhɨ tá be. Dɨ dré ngàzo trèle, yòzoá kúlí ꞌuꞌù sè dhɨ: ");
INSERT INTO log_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Á! Yésu Nàzàrétà lésè nɨ, tsítsì àma kòfalésè mɨ́ be dhɨ, àdho tà ꞌɨ? Mɨ́ alɨ̀ àma kɨ tà ꞌo akɨ́lé? Má nì mɨ àdhi ꞌɨ ya dhɨ be. Mɨ Dhya lólo Gìká àdhya ꞌɨ!» ");
INSERT INTO log_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Gò Yésu dré ngàzo lɨgɨ́lé tɨrɨ́ kònzɨ nda be, tàzoá dhɨ: «Mɨ́ atsú ámɨ ti! Mɨ́ pfò agó kònɨ̀dhɨ lésè!» Dɨ tɨrɨ́ nda dré agó nda nɨ bhèzo kìní mi móndyá títí ɨ kòfalé gò, pfòzo lásà akódhɨ nɨ tayɨ́ lɨ́ná. ");
INSERT INTO log_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Móndyá títí nda kɨ lɨ́ndrɨ́ dré gàzo bhwǎbhwa gò, ɨ̀ dré adrézó tàá àyɨ kòfalésè dhɨ: «Kònɨ̀nɨ nɨ àdho kúlí lanzìlanzì ɨ̀ndɨ̀ rìnyi ró dhɨ ꞌɨ? Akódhɨ adré ndɨ̀ndɨ̀ tòlɨ́ fe tɨrɨ́ kònzɨ ɨ dré gò, ɨ̀ dré adrézó topfòle!» ");
INSERT INTO log_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Dɨ Yésu nɨ rúbí dré laꞌúzó bvò wä́yi nda ꞌásè. ");
INSERT INTO log_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yésu kàpfò lɨ̀sámbò dzó nda lésè dre dhɨ, dré lɨ̀zo Sìmónà nɨ dzó na. Dɨ, Sìmónà nɨ àdrá adré tá ɨ́na kɨzà nya, akódhɨ nɨ rúbhá dré tá adrélé àtsɨ ró lavúlé dhɨ sè. Gò Yésu nɨ ti lizízó, kòtɨdrɨ́ró tòkó nda be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Dɨ dré tandìzo akódhɨ drìle, lɨgɨ́lé rúbhá àtsɨ́ nda dri gò, rúbhá àtsɨ́ nda dré pfòzo rúásà. Gbǎ kòdhwa, tòkó nda dré ngàzo kɨdhólé ngá fe àyɨ dré nyàle. ");
INSERT INTO log_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Kìtú kòndì dre dhɨ, à dré dràbhá títí drà twátwa ɨ́be dhɨ kɨ adzízó Yésu vélé. Dɨ akódhɨ dré drɨ́gá bhàzo àyɨ àlo àlo títí dhɨ ɨ dri, àyɨ kɨ tɨdrɨ́zó. ");
INSERT INTO log_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Tɨrɨ́ kònzɨ ɨ̀ dré kpà topfòzo móndɨ́ bǐ dhɨ ɨ lésè, adrélé loyóába dhɨ: «Mɨ Gìká nɨ Mváagó ꞌɨ!» Dɨ, akódhɨ adré tá ɨ́na lɨgɨ́lé àyɨ ɨ́be, adrézó kúlí logá àyɨ dré, ɨ̀ dré nìle akódhɨ Mèsɨ́yà ꞌɨ dhɨ be dhɨ sè. ");
INSERT INTO log_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ngá kòwa dre dhɨ, Yésu dré pfòzo lɨ̀le àrà móndɨ́ àko dhɨ na. Móndɨ́ zyandre dhɨ ɨ̀ dré kɨdhózó adrélé akódhɨ nɨ nda gò, ɨ̀ dré akódhɨ nɨ kisúzó. Ɨ̀ adré tá akódhɨ nɨ le kɨkɨ́lé, kòtayɨ́ró àyɨ ko. ");
INSERT INTO log_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Dɨ, Yésu dré tàzoá àyɨ dré dhɨ: «Adré lèá dhɨ, má kòlongó kpà Rúbí Tanɨ Gìká nɨ Òpɨ̀ àdhya bhàandre àruka títí dhɨ ɨ ꞌásè be. Tàko ko, tà nda tà Gìká dré áma amùzo ꞌòá dhɨ ꞌɨ.» ");
INSERT INTO log_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Gò dré gòzo adrélé tatsílé Gìká nɨ kúlí longóbe Yúdà ànzɨ kɨ lɨ̀sámbò dzó àyɨ kɨ bvò le dhɨ ɨ ꞌásè. ");
INSERT INTO log_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Kìtú àlo dhɨ, Yésu totó tá ɨ adrélé Gìká nɨ kúlí longó tä́pä́ríandre Gènèsàrétè àdhya mìle. Móndɨ́ zyandre àyɨ kɨ kɨmóbhá akódhɨ làgásè kúrú dhɨ ɨ̀ adré tá àyɨ kɨ tribe rúásà, ɨ̀ kòkɨtswáró Gìká nɨ kúlí yi be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Yésu dré mì bhèzo kòlóngbò rì dhɨ kɨ no yǐandre nda mìle. Kosyá bhebhá ɨ̀ así tá kòlóngbò nda ɨ lésè, adrélé àyɨ kɨ kɨmbá kɨ mì dzɨ. ");
INSERT INTO log_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Gò Yésu dré mbàzo kòlóngbò nda kɨ àlo adrélépi Sìmónà àdhya ró dhɨ na gò, tàá drá dhɨ, kòkisí kòlóngbò nda vwàle tsà yǐ gàrà rúsè. Dré lɨrɨ́zó lána gò adrélé móndyá zyandre nda kɨ tadhá. ");
INSERT INTO log_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Kòtà tà akɨ́lé dre dhɨ, dré tàzoá Sìmónà dré dhɨ: «Mɨ́ kisí kòlóngbò tä́lí na, mɨ̀ kòbheró àmɨ kɨ kɨmbá ɨ kosyá rùzo.» ");
INSERT INTO log_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Sìmónà logó drá dhɨ: «Mírì, mà bhe kɨmbá ɨ ngá wàle tà wóyá, mà kisú ngá àlo ko. Dɨ, mɨ́ dré tàle mɨ dhɨ sè dhɨ, má nɨ go kɨmbá nda kɨ bhe tódhyá.» ");
INSERT INTO log_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Dɨ ɨ̀ kòbhe dre dhɨ, ɨ̀ dré kosyá rùzo zyandre ró gò, kɨmbá nda ɨ̀ dré kɨdhózó adrélé tɨkɨ́lé. ");
INSERT INTO log_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Gò ɨ̀ dré àyɨ kɨ arúpi kòlóngbò àzya na dhɨ kɨ agózó, ɨ̀ kàlɨ̀ró drɨ́gá bha àyɨ vélé. Ɨ̀ kàtsá dre dhɨ, àyɨ títí dhɨ ɨ̀ dré kosyá lomvózó gàle kòlóngbò rì nda ɨ sè bǐbi, tsàle kòlóngbò nda ɨ̀ dré adrézó ꞌòle arɨ́lé na tɨ́nɨ ká. ");
INSERT INTO log_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Sìmónà Pétèró kònò tà nda dre dhɨ, dré adhézó áyɨ kórókó titì Yésu kandrá, tàzoá dhɨ: «Mírì, mɨ́ kisí mɨ má làgásè. Ma tàkonzɨ̀ líyí ꞌɨ!» ");
INSERT INTO log_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Tà tá kònɨ̀nɨ tàko ko, àyɨ arúpi nɨ ɨ́be dhɨ kɨ lɨ́ndrɨ́ ga tá gagà, kosyá zyandre ɨ̀ dré tá rùle dhɨ kɨ tà sè. ");
INSERT INTO log_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Tà nda tá kókpà kònɨ̀nɨ akódhɨ nɨ àzízɨ̌, Yàkóbhò ɨ Yòwánɨ̀ be, Zèbèdáyò nɨ ànzɨ ɨ dré. Dɨ, Yésu dré tàzoá Sìmónà dré dhɨ: «Mɨ́ ro ngá ko. Kɨdhólé nyànomvá dhɨ, mɨ́ gò vélé adrélé kosyá ru ko. Mɨ́ nɨ go adrélé móndɨ́ kɨ nda kòdhya.» ");
INSERT INTO log_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Dɨ ɨ̀ dré àyɨ kɨ kòlóngbò nda kɨ logózó yǐ gàrà ꞌa, àyɨ kɨ ngá wä́yi dhɨ kɨ tayɨ́zó gò, ɨ̀ dré ngàzo adrélé Yésu nɨ lebè. ");
INSERT INTO log_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Kìtú àlo, Yésu dré tá adréràꞌa bhàandre àlo na dhɨ ꞌá dhɨ, agó àlo kàrɨ́ dré rùle lavúlé dhɨ atsá tá àrà nda ꞌá. Kònò Yésu dre dhɨ, dré adhézó áyɨ mìbhalé bha kìní mi gò, akódhɨ nɨ ti lizízó tàzoá dhɨ: «Mírì, mɨ rìnyí ɨ́be kɨtswázó áma temvé tɨdrɨ́lé, mɨ́ kòlè dhɨ.» ");
INSERT INTO log_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Dɨ Yésu dré áyɨ drɨ́gá kɨdzɨ̀zo akódhɨ nɨ tabè gò, tàzoá dhɨ: «Má lè ꞌí. Mɨ́ kàdré kemve kpɨ́rɨ́kpɨ́rɨ́ wà!» Gbǎ kòdhwa, kàrɨ́ drà nda dré ngàzo rúásà. ");
INSERT INTO log_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Gò Yésu dré lazízóá drìá dhɨ: «Mɨ́ kòlongó tà kòdhɨ dhya àlo dré ko. Be ró dhɨ, mɨ́ lɨ̀ mɨ́na ámɨ tadhá kòwánà dré nòle, ɨ̀ndɨ̀ mɨ́ fè ngá mòbòmà ro Gìká dré ámɨ temvema sè ngóró Mósè nɨ tátrɨ́trɨ́ kúlí dré adrélé tàle dhɨ tɨ́nɨ, tadházóá móndɨ́ ɨ dré dhɨ, mɨ́ adrɨ́ dre káyà dhɨ.» ");
INSERT INTO log_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Dɨ, Yésu nɨ rúbí adré tá ɨ́na laꞌúlé lɨ̀le drìdrì. Móndɨ́ zyandre lavúlé dhɨ ɨ̀ adré tá alɨ̀le akódhɨ nɨ kúlí yi, kòtɨdrɨ́ró kpà àyɨ àyɨ kɨ drà ɨ lésè be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Dɨ, vésè be bǐ, Yésu adré tá ɨ́na pfòle kalóma, kɨtswálé tà ta Gìká be àrà móndɨ́ àko dhɨ na. ");
INSERT INTO log_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Kìtú àlo, Yésu dré tá adréràꞌa móndɨ́ kɨ tadhá dzó àlo na dhɨ ꞌá dhɨ, Fàrìsáyò ɨ tátrɨ́trɨ́ kúlí tadhábhá ɨ́be dhɨ ɨ̀ lɨrɨ́ tá adrélé akódhɨ làga. Àyɨ nda ɨ̀ angá tá bhà títí bvò Gàlìláyà àdhya lé dhɨ ɨ lésè, bvò Yùdáyà àdhya lésè, ɨ̀ndɨ̀ Yèrúsalémà lésè. Yésu tá rìnyí Mírì àdhya kɨtswázó dràbhá kɨ tɨdrɨ́ dhɨ ɨ́be. ");
INSERT INTO log_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Dɨ móndɨ́ àruka ɨ̀ dré agó àlo pá be àbvò ro dhɨ nɨ adózó kíndri dri alɨ̀zo ába. Ɨ̀ adré tá láti nda kɨtswázó fɨ̀le ába dzó nda na, akódhɨ nɨ bha Yésu kandrá dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Dɨ, móndyá zyandre nda kɨ tà sè dhɨ, ɨ̀ kɨtswá tá àyɨkya láti kisú fɨ̀zo ába bwà ko. Dɨ ɨ̀ dré ngàzo mbàle ába dzó nda drìna gò, dzó nda nɨ drì awú, akódhɨ nɨ tɨrɨ́zó sìle kíndri dri Yésu kandrá móndyá zyandre nda ɨ kòfalé. ");
INSERT INTO log_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Dɨ Yésu kònò àyɨ kɨ tà kaꞌìkaꞌì dre dhɨ, dré tàzoá agó pá be àbvò ro nda dré dhɨ: «Áma arúpi, à trì ámɨ tàkonzɨ̀ ɨ dre.» ");
INSERT INTO log_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Gò Fàrìsáyò nda ɨ tátrɨ́trɨ́ kúlí tadhábhá nda ɨ́be dhɨ ɨ̀ dré dhèzo adrélé kisùá àyɨ léna dhɨ: «Dhya kòndɨ tá àdhi ꞌɨ, adrélé Gìká nɨ dha kònɨ̀nɨ nɨ? Àdhi nɨ kɨtswá tàkonzɨ̀ tri nɨ̀, kàdré ngbà ꞌí Gìká ꞌɨ kalóma ko dhɨ?» ");
INSERT INTO log_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yésu dré tà ɨ̀ dré adrélé kisùle nda nɨ nìzo kyá gò, tàzoá dhɨ: «Mɨ̀ adré àmɨkya tà kisù kònɨ̀nɨ àdho tà sè? ");
INSERT INTO log_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Tà kɨtswálé tàle mbèlè agó pá be àbvò ro kònɨ̀dhɨ dré dhɨ, ángùdhi ꞌɨ: ‹À trì ámɨ tàkonzɨ̀ ɨ dre› dhɨ, kó ngalè, ‹Mɨ́ nga, mɨ́ kɨdhó atsí to› dhɨ? ");
INSERT INTO log_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Má adré lèá mɨ̀ kònì dhɨ, Móndɨ́ nɨ Mvá rìnyí ɨ́be adrézó tàkonzɨ̀ tri bvò dri.» Dɨ dré tàzoá agó pá be àbvò ro nda dré dhɨ: «Má adré tàá mɨ́ dré dhɨ: Mɨ́ nga, mɨ́ do ámɨ kíndri, ɨ̀ndɨ̀ mɨ́ nzɨ mɨ́ bhàna!» ");
INSERT INTO log_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Gbǎ kòdhwa, agó nda dré ngàzo móndyá títí ɨ misè, áyɨ kíndri ɨ́ dré tá ayízó drìá dhɨ nɨ do gò, nzɨ̀zo ɨ́ bhàna Gìká nɨ rú bhabe kùle. ");
INSERT INTO log_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Dɨ móndyá títí nda kɨ lɨ́ndrɨ́ dré gàzo bhwǎbhwa gò, ɨ̀ dré ngàzo adrélé Gìká nɨ rú bha kùle. Àyɨ kɨ togó adré tá kpà gàle tirì sè bǐ gò, ɨ̀ dré adrézó tàá dhɨ: «Ándrò, mà nò tà lɨ́ndrɨ́ga ró dhɨ ɨ dre!» ");
INSERT INTO log_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Àmvolásà dhɨ, Yésu dré pfòzo gò, mèdáyɨ̀ lagɨ́lépi àlo rú be Lévì dhɨ nɨ no adréràꞌa lɨrɨ́lé mèdáyɨ̀ lagɨ́rà na. Dré tàzoá drá dhɨ: «Mɨ́ lebè ma!» ");
INSERT INTO log_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Dɨ Lévì nda dré ngàzo áyɨ ngá títí dhɨ kɨ tayɨ́ gò, kɨdhózó adrélé Yésu nɨ lebè. ");
INSERT INTO log_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Bvóá dhɨ, Lévì dré gwányá kàdrɨ̀ dhɨ nɨ ꞌòzo Yésu dré áyɨ dzó na. Gò ɨ̀ dré lɨrɨ́zó mɨ́sá làgásè adrélé ngá nya túmä́ní mèdáyɨ̀ lagɨ́bhá zyandre dhɨ ɨ́be, ɨ̀ndɨ̀ móndɨ́ àruka ɨ́be. ");
INSERT INTO log_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Dɨ, Fàrìsáyò ɨ túmä́ní tátrɨ́trɨ́ kúlí tadhábhá Fàrìsáyò ro dhɨ ɨ́be dhɨ ɨ̀ dré dhèzo adrélé kúlí tɨ Yésu nɨ lebèbhá ɨ rú, adrézó tàá àyɨ dré dhɨ: «Mɨ̀ adré ngá nya adrézó ngá mvu túmä́ní mèdáyɨ̀ lagɨ́bhá ɨ́be ɨ̀ndɨ̀ tàkonzɨ̀bhá ɨ́be àdho tà sè?» ");
INSERT INTO log_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Dɨ Yésu dré logózóá àyɨ dré dhɨ: «Móndyá rúbhá be dóro dhɨ ɨ̀ ndà gà kódzó ko na. Be ró dhɨ, móndyá drà ro dhɨ ɨ̀ adré àyɨkya ndàá àyɨ. ");
INSERT INTO log_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Má alɨ̀ móndyá adrébhá àyɨ kɨ no gyǎgya dhɨ kɨ azí kòdhya ko. Be ró dhɨ, má alɨ̀ mána tàkonzɨ̀bhá kɨ azí kòdhya, ɨ̀ kòladzáró àyɨ kɨ togó agòzo Gìká vélé.» ");
INSERT INTO log_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Gò Fàrìsáyò nda ɨ̀ dré tàzoá Yésu dré dhɨ: «Yòwánɨ̀ nɨ lebèbhá ɨ Fàrìsáyò kya ɨ́be dhɨ ɨ̀ adré tàbirí mvo rä, adrézó tà zi Gìká tí. Dɨ, ámɨ lebèbhá ɨ̀ adré àyɨkya ngá nya, adrézó ngá mvu.» ");
INSERT INTO log_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yésu logó àyɨ dré dhɨ: «Mɨ̀ nɨ kɨtswá tsì móndyá azílé gwányá làmó àdhya lé dhɨ kɨ ꞌo tàbirí mvo, ɨ̀ dré adréràꞌa túmä́ní tòkó líyí be dhɨ ꞌá? Tàdzí ko! ");
INSERT INTO log_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Dɨ, lókyá adrélépi alɨ̀le dhɨ sè dhɨ, à nɨ tòkó líyí nda nɨ tɨngá àyɨ kòfalésè gò, ɨ̀ dré kɨdhózó adrélé tàbirí mvo lókyá nda sè.» ");
INSERT INTO log_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yésu dré kpà adrézó tà ta àyɨ dré kúlí alaala sè, adrézó tàá dhɨ: «Dhya àlo kàdré kɨ́tá àku ró lasɨ́lépi dhɨ ɨ́be dhɨ, asɨ̀ kɨ̀gá kɨ́tá tɨ́dhɨ́ ro dhɨ rúsè, kɨ́tá àku nda nɨ lebhézó ásà ko na. Tàko ko, kòꞌo kònɨ̀nɨ dhɨ, lasɨ́ kɨ́tá tɨ́dhɨ́ nda dre, ɨ̀ndɨ̀ kɨ́tá tɨ́dhɨ́ nɨ kɨ̀gá nda kɨtswá ɨ́na ru amú kɨ́tá àku nda be dóro ko. ");
INSERT INTO log_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kòdhɨ ɨ́be dhɨ, dhya àlo dà vínò tɨ́dhɨ́ ro dhɨ kɨ́nɨ́ dhɨ̀le adrézó vínò lɨkɨ́, akùbhá dre dhɨ ɨ léna ko na. Tàko ko, kòꞌo kònɨ̀nɨ dhɨ, vínò tɨ́dhɨ́ nda nɨ abhò kɨ́nɨ́ àku nda kɨ lasɨ́ gò, vínò dré kutúzó, gò kɨ́nɨ́ nda ɨ̀ dré abɨ́zó títí. ");
INSERT INTO log_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ásà dhɨ, à adré vínò tɨ́dhɨ́ ro dhɨ nɨ da kɨ́nɨ́ tɨ́dhɨ́ ro dhɨ ɨ léna. ");
INSERT INTO log_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Túmä́ní ába dhɨ, dhya àlo vínò àku ró dhɨ nɨ mvùlepi dhɨ gò ɨ́na vínò tɨ́dhɨ́ ro dhɨ nɨ le mvùle ko na. Àngyá ko, adré tàá dhɨ: ‹Vínò àku ró dhɨ adré kɨnɨ́lé tɨ́dhɨ́ ro dhɨ nɨ lavú.›» ");
INSERT INTO log_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sàbátù àlo dhɨ, Yésu ɨ̀ adré tá lavúlé amvú ngánò àdhya ɨ ꞌásè. Dɨ akódhɨ nɨ lebèbhá ɨ̀ dré kɨdhózó adrélé ngánò lòꞌwa vu, adrézó nyɨ̀á àyɨ drɨ́gá, adrézó tsɨ̀á. ");
INSERT INTO log_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Gò Fàrìsáyò àruka ɨ̀ dré tàzoá àyɨ dré dhɨ: «Mɨ̀ adré àmɨkya tà àma kɨ tátrɨ́trɨ́ kúlí dré adrélé logálé sàbátù tú dhɨ nɨ ꞌo àdho tà sè?» ");
INSERT INTO log_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Dɨ Yésu logó àyɨ dré dhɨ: «Mɨ̀ nà rè tàdzí tà Dàwídì dré tá ꞌòle ɨ̀ dré adréràꞌa tàbirí ɨ́be akódhɨ nɨ arúpi ɨ́be dhɨ ꞌá dhɨ ko? ");
INSERT INTO log_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Akódhɨ fɨ tá Gìká nɨ dzó kàdrɨ̀ na, mápà fèle Gìká dré dhɨ nɨ adó nyàle gò, dré kpà fèzoá áyɨ arúpi ɨ dré nyàle. Tákò àma kɨ tátrɨ́trɨ́ kúlí adré tá ɨ́na mápà nda nɨ nyàma logá àyɨ dré. Ngbà ꞌí kòwánà kɨ tá kɨtswá nyàá dhɨ àyɨ.» ");
INSERT INTO log_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Dɨ Yésu gò tàá àyɨ dré dhɨ: «Móndɨ́ nɨ Mvá, Mírì sàbátù àdhya ꞌɨ.» ");
INSERT INTO log_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Sàbátù àzya tú dhɨ, Yésu dré fɨ̀zo Yúdà ànzɨ kɨ lɨ̀sámbò dzó na gò, adrélé móndɨ́ kɨ tadhá. Kònàle dhɨ, agó àlo drɨ́ágó nɨ dré ꞌyòzo ꞌyoꞌyò dhɨ tá be. ");
INSERT INTO log_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Fàrìsáyò ɨ tátrɨ́trɨ́ kúlí tadhábhá ɨ́be dhɨ ɨ̀ adré tá tà ɨ̀ dré kɨtswázó Yésu nɨ asíkì ásà dhɨ nɨ nda. Dɨ ɨ̀ adré tá akódhɨ nɨ mì ga, nòzoá ngalè akódhɨ nɨ agó nda nɨ tɨdrɨ́ sàbátù tú yà dhɨ. ");
INSERT INTO log_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Dɨ, Yésu dré ɨ́na tà ɨ̀ dré tá adrélé kisùle nda kɨ nìzo kyá gò, tàzoá agó drɨ́gá be àꞌyo ró nda dré dhɨ: «Mɨ́ nga ámɨ totó móndyá títí dhɨ kɨ kɨ́tó ꞌá.» Dɨ akódhɨ nda dré ngàzo áyɨ totó. ");
INSERT INTO log_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Gò Yésu dré tàzoá àyɨ dré dhɨ: «Má adré lizíá àmɨ tí dhɨ: Àma kɨ tátrɨ́trɨ́ kúlí adré tà ángùdhi nɨ kaꞌì sàbátù tú dhɨ kòdhya: adrélé tà dóro ꞌo dhɨ, kó ngalè adrélé tà kònzɨ ꞌo dhɨ? Adrélé móndɨ́ tɨdrɨ́ dhɨ, kó ngalè adrélé móndɨ́ pfu dràle dhɨ?» ");
INSERT INTO log_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Dɨ Yésu dré móndyá ɨ́ làgásè kúrú nda kɨ nòzo títí gò, tàzoá agó nda dré dhɨ: «Mɨ́ kɨdzɨ̀ ámɨ drɨ́gá.» Akódhɨ dré kɨdzɨ̀zoá gò, drɨ́gá nɨ nda dré adrɨ́zó. ");
INSERT INTO log_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Dɨ àyɨ nda kɨ togó dré aswázó lavúlé gò, ɨ̀ dré ngàzo adrélé tà ta àyɨ kòfalésè, nìzoá ngalè ɨ̀ nɨ ꞌòá Yésu nɨ tà sè ngɨ́nɨ ya dhɨ. ");
INSERT INTO log_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Kìtú nda kɨ àlo sè dhɨ, Yésu dré lɨ̀zo mbàle kòngó àlo drìna gò, tà ta Gìká be ngá wàle tà. ");
INSERT INTO log_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ngá kòwa dre dhɨ, dré áyɨ lebèbhá kɨ azízó gò, móndɨ́ mudrí-drì-rì dhɨ kɨ kɨpèzo àyɨ kòfalé, àyɨ kɨ zìzo àpóstolò ɨ ró. ");
INSERT INTO log_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Àyɨ nda ɨ̀ tá: Sìmónà (dré rú zìle Pétèró dhɨ), adrúpi nɨ Àndréyà, Yàkóbhò, Yòwánɨ̀, Fìlípò, Bàràtòlòmáyò, ");
INSERT INTO log_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Màtáyò, Tòmá, Yàkóbhò Àlàfáyò nɨ mvá, Sìmónà (adrélé zìle dhya àtsɨ ró áyɨ súrú nɨ tà sè dhɨ ró dhɨ), ");
INSERT INTO log_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yùdásɨ̀ Yàkóbhò nɨ mvá, ɨ̀ndɨ̀ Yùdásɨ̀ Ɨ̀sɨ̀kàrɨ̀yótà (dra Yésu nɨ lefèlepi kàrɨbhá ɨ drɨ́gá dhɨ). ");
INSERT INTO log_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yésu ɨ̀ kàsí àyɨ nda ɨ́be kòngó nda drìlésè dre dhɨ, akódhɨ dré áyɨ kɨkɨ́zó àrà kpàkpà na. Móndɨ́ zyandre lavúlé adrébhá akódhɨ nɨ lebè dhɨ ɨ tá kònàle, túmä́ní móndɨ́ lɨ̀zólɨ̀zo angábhá bvò wä́yi Yùdáyà àdhya lésè, Yèrúsalémà lésè, ɨ̀ndɨ̀ bvò yǐandre mìle, Tírè ɨ làga Sìdónà be dhɨ lésè dhɨ ɨ́be. ");
INSERT INTO log_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ɨ̀ alɨ̀ tá kɨtswálé Yésu nɨ yi, kòtɨdrɨ́ró kpà àyɨ àyɨ kɨ drà ɨ lésè be dhɨ bvó. Móndɨ́ tɨrɨ́ kònzɨ ɨ̀ dré tá adrélé lagùle dhɨ ɨ̀ alɨ̀ tá kpà gò, Yésu dré adrézó àyɨ kɨ tɨdrɨ́. ");
INSERT INTO log_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Dɨ móndyá zyandre títí nda ɨ̀ adré tá láti nda kɨtswázó akódhɨ nɨ tabè. Tàko ko, rìnyí adré tá apfòle lásà, adrélé àyɨ kɨ tɨdrɨ́ títí. ");
INSERT INTO log_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Gò Yésu dré mì bhèzo áyɨ lebèbhá ɨ véna, tàzoá dhɨ: «Kólénzé àmɨ adrébhá lemerè ro nɨ ɨ dré. Tàko ko, Gìká nɨ Òpɨ̀ àmɨkya ꞌɨ! ");
INSERT INTO log_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Kólénzé àmɨ adrébhá tàbirí ɨ́be nyànomvá nɨ ɨ dré. Tàko ko, mɨ̀ nɨ ngá nya pìzo! Kólénzé àmɨ adrébhá àwó ngo nyànomvá nɨ ɨ dré. Tàko ko, mɨ̀ nɨ arɨ́ gu! ");
INSERT INTO log_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Kólénzé àmɨ dré, móndɨ́ ɨ̀ kàdré togó kònzɨ bha àmɨ rú, adrézó àmɨ kɨ ga, adrézó àmɨ kɨ lodhá, adrézó àmɨ kɨ rú ta kònzɨ Móndɨ́ nɨ Mvá nɨ tà sè dhɨ. ");
INSERT INTO log_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Mɨ̀ kàdré lenzélé lókyá nda sè, adrézó ngá to arɨ́ sè! Tàko ko, làgɨ́ múrúngú adré àmɨ kɨ letè bhù na. Àyɨ kɨ tábhí ɨ̀ adré tá kpà pròfétà atú dhɨ kɨ ꞌo kònzɨ kònɨ̀nɨ.» ");
INSERT INTO log_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","«Dɨ, kɨzà àmɨ kɨ ngá ꞌɨ, àmɨ ngábhá ró nɨ ɨ. Tàko ko, mɨ̀ kisú àmɨkya tà àmɨ kɨ togó tɨndrɨ̀lepi dhɨ dre! ");
INSERT INTO log_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Kɨzà àmɨ kɨ ngá ꞌɨ, àmɨ adrébhá ngá nya pìzo nyànomvá nɨ ɨ. Tàko ko, mɨ̀ nɨ adré tàbirí ɨ́be! Kɨzà àmɨ kɨ ngá ꞌɨ, àmɨ adrébhá arɨ́ gu nyànomvá nɨ ɨ. Tàko ko, mɨ̀ nɨ àwó ngo, adrézó tongólé! ");
INSERT INTO log_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Kɨzà àmɨ kɨ ngá ꞌɨ, móndyá títí dhɨ ɨ̀ kàdré àmɨ kɨ rú ta dóro dhɨ. Tàko ko, àyɨ kɨ tábhí ɨ̀ adré tá kpà pròfétà atú kɨnzò ro dhɨ kɨ rú ta dóro kònɨ̀nɨ!» ");
INSERT INTO log_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«Dɨ, má adré mána tàá àmɨ adrébhá áma yi nɨ ɨ dré dhɨ: Lè mɨ̀ kàdré àmɨ kɨ kàrɨbhá kɨ le. Mɨ̀ kàdré móndyá adrébhá togó kònzɨ bha àmɨ rú dhɨ kɨ ꞌo dóro. ");
INSERT INTO log_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mɨ̀ kàdré kpà tà tanɨ zi Gìká tí móndyá adrébhá àmɨ kɨ tatrɨ́ dhɨ ɨ dri. Mɨ̀ kàdré kpà tà zi Gìká tí móndyá adrébhá àmɨ kɨ ꞌo kònzɨ dhɨ ɨ dré. ");
INSERT INTO log_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Dhya àlo kòsa ámɨ kóbhólé àlo dhɨ dhɨ, mɨ́ kògò àzya nɨ nɨ alá akódhɨ dré kpà sàle. Dhya àlo kòtopá ámɨ kɨ́tá kɨdhɨ̀ àdhya dhɨ, mɨ́ kòtayɨ́ kpà akódhɨ ámɨ kɨ́tá agá lésè dhɨ nɨ do. ");
INSERT INTO log_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mɨ́ kàdré ngá fe dhya ángùdhi adrélépi ngá zi mɨ́ tí dhɨ dré. Dhya àlo kòkärí ámɨ ngá dhɨ, mɨ́ kògò zìá tíá ko. ");
INSERT INTO log_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Mɨ̀ kàdré tà ꞌo móndɨ́ ɨ dré ngóró mɨ̀ dré adrélé lèle ɨ̀ kòꞌo àmɨ dré dhɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Mɨ̀ kàdré ngbà ꞌí móndyá adrébhá àmɨ kɨ le dhɨ kɨ le kòdhya dhɨ, mɨ̀ nɨ àdho tà dóro kisú ásà kòdhya? Ndɨ̀ndɨ̀ tàkonzɨ̀bhá ɨ̀ adré móndyá adrébhá àyɨ kɨ le dhɨ kɨ le. ");
INSERT INTO log_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Mɨ̀ kàdré ngbà ꞌí tà dóro ꞌo móndyá adrébhá tà dóro ꞌo àmɨ dré dhɨ ɨ dré dhɨ, mɨ̀ nɨ àdho tà dóro kisú ásà? Ndɨ̀ndɨ̀ tàkonzɨ̀bhá ɨ̀ adré ꞌòá kònɨ̀nɨ. ");
INSERT INTO log_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Mɨ̀ kàdré ngbà ꞌí ngá fe màri ró móndyá kɨtswábhá màri nda nɨ logó àmɨ dré dhɨ ɨ dré dhɨ, mɨ̀ nɨ àdho tà dóro kisú ásà? Ndɨ̀ndɨ̀ tàkonzɨ̀bhá ɨ̀ adré ngá fe màri ró tàkonzɨ̀bhá àruka ɨ dré, àyɨ nda ɨ̀ kògòró màri nda nɨ logó títí àyɨ dré be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Dɨ, mɨ̀ kàdré àmɨkya àmɨ kɨ kàrɨbhá kɨ le, adrézó tà dóro ꞌo àyɨ dré. Mɨ̀ kàdré ngá fe àyɨ dré màri tà kisù àko ró. Dɨ mɨ̀ nɨ làgɨ́ múrúngú kisú ásà. Mɨ̀ nɨ kpà adré Gìká kurú na bhù na dhɨ nɨ ànzɨ ɨ ró. Tàko ko, akódhɨ adré áyɨ togó dóro tadhá móndyá àwoyà nibhá tàle ɨ́ dré ko dhɨ ɨ dré, ɨ̀ndɨ̀ móndyá adrébhá tà kònzɨ ꞌo dhɨ ɨ dré. ");
INSERT INTO log_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mɨ̀ kàdré dɨ móndɨ́ kɨ kɨzà bha, ngóró àmɨ kɨ Atá dré adrélé àmɨ kɨ kɨzà bha dhɨ tɨ́nɨ.» ");
INSERT INTO log_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«Mɨ̀ kàdré móndɨ́ kɨ tàbvó ta ko, Gìká kòtàró kpà àmɨ kɨ tàbvó ko. Mɨ̀ kàdré tà bha móndɨ́ ɨ dri ko, Gìká kòbhàró kpà tà àmɨ dri ko. Mɨ̀ kàdré móndɨ́ kɨ tàkonzɨ̀ tri, Gìká kàdréró kpà àmɨ kɨ tàkonzɨ̀ tri. ");
INSERT INTO log_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mɨ̀ kàdré ngá fe móndɨ́ ɨ dré, Gìká kàdréró kpà ngá fe àmɨ dré. A nɨ ngá ko, mùzoá, kosézóá gàle bǐ gò, dàzoá àmɨ kɨ kánzɨ̀ na. Tàko ko, Gìká nɨ ngá ko fèle àmɨ dré, koma mɨ̀ dré adrézó ngá ko fèle móndɨ́ àruka ɨ dré ásà dhɨ sè.» ");
INSERT INTO log_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yésu dré kpà tà àzya tàzo àyɨ dré kúlí alaala sè, tàzoá dhɨ: «Mì kùdúkùdu àlo dhɨ nɨ kɨtswá tsì mì kùdúkùdu àzya se drìle bwà? Kòꞌo kònɨ̀nɨ dhɨ, àyɨ rìti nda kɨ zakó tsì ledhé bhú na? ");
INSERT INTO log_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Dhya adrélé tadhálé dhɨ lavú dhya adrélépi áyɨ tadhá dhɨ ko. Dɨ, dhya ángùdhi tà tadhálé ɨ́ dré dhɨ kɨ nìlepi títí dhɨ nɨ atsá ɨ́na dhya áyɨ tadhálépi dhɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Mɨ́ adré mɨ́na kayísá kórònyá mvá ámɨ adrúpi mìna dhɨ nɨ no gò, adrézó fa gú mɨ́ mìna dhɨ nɨ atógyà ko àdho tà sè? ");
INSERT INTO log_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Mɨ́ adré ámɨ ꞌo ngɨ́nɨ tàá ámɨ adrúpi dré dhɨ ‹Áma adrúpi, mɨ́ ꞌo má kàpèró kayísá kórònyá mvá mɨ́ mìlésè› dhɨ, tágba mɨ́ dré adrézó fa gú ámɨ tàndɨ mìna dhɨ nɨ no ko dhɨ? Mɨ túrúpfú líyí ꞌɨ! Mɨ́ kàpè rè zyà fa gú nda mɨ́ mìlésè ꞌíká, gò mɨ́ kògòró ngá no dra kɨtswázó kayísá kórònyá mvá nda nɨ apè ámɨ adrúpi mìlésè ndò.» ");
INSERT INTO log_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«Fa dóro ꞌa gà lòꞌwa kònzɨ ko na. Fa kònzɨ ꞌa gà lòꞌwa dóro ko na. ");
INSERT INTO log_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","À adré fa àlo àlo títí dhɨ kɨ ni àyɨ kɨ tàndɨ kɨ lòꞌwa sè. À kɨ fígì lòꞌwa kùtsí sílé ko na. À kɨ kpà vínò lòꞌwa áyɨ̀dhá sílé ko na. ");
INSERT INTO log_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Dhya dóro adré tà dóro ꞌo apfòle tà dóro títí ɨ́ dré zùle áyɨ togó na dhɨ ɨ lésè. Dɨ, dhya kònzɨ adré ɨ́na tà kònzɨ ꞌo apfòle tà kònzɨ títí ɨ́ dré zùle áyɨ togó na dhɨ ɨ lésè. Àngyá ko, akódhɨ nɨ ti adré tà adrélépi gàle akódhɨ nɨ togó na dhɨ kɨ ta kòdhya.» ");
INSERT INTO log_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«Mɨ̀ adré áma zi ‹Mírì, Mírì!› gò, adrézó tà má dré adrélé tàle àmɨ dré dhɨ kɨ ꞌo ko àdho tà sè? ");
INSERT INTO log_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Má nɨ tadhá àmɨ dré ngalè dhya adrélépi alɨ̀le má vélé áma kúlí yi gò adrézó kaꞌìá ꞌòle dhɨ, sù àdhi tɨ́nɨ ya dhɨ. ");
INSERT INTO log_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Akódhɨ nda sù ngóró agó àlo adrélépi tá dzó si gò, bhú nɨ nɨ dhìzo fɨ̀le fɨfɨ̀, pá nɨ nɨ bhàzo kɨ́rà dri dhɨ tɨ́nɨ. Yǐ dré tìzo áyɨ tswa dzó nda rú dhɨ, kɨtswá ɨ́na dzó nda nɨ wu bwà ko, à dré sìle tätä dhɨ sè. ");
INSERT INTO log_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Dɨ, dhya adrélépi áma kúlí yi gò adrézó kaꞌìá ꞌòle ko dhɨ, sù ngóró agó àlo dzó sìlepi bvò mònyá dri, pá nɨ nɨ bha àko ró kɨ́rà dri dhɨ tɨ́nɨ. Yǐ dré tìzo áyɨ tswa dzó nda rú dhɨ, dzó nda dré ndɨrɨ arɨ́zó arɨ́arɨ́ gò, tà nɨ dré akɨ́zó nyɨ̌nyɨ.» ");
INSERT INTO log_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yésu kòtà tà nda ɨ móndɨ́ zyandre ɨ dré akɨ́lé dre dhɨ, dré gòzo lɨ̀le Kàpàrànàwúmà na. ");
INSERT INTO log_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Kònàle dhɨ, Rómà kɨ sòdá kɨ kàdrɨ̀ àlo dhɨ nɨ màrábà dré lèle tò dhɨ tá drà ro ànyɨ́ànyɨ dràdrà mìle. ");
INSERT INTO log_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Dɨ sòdá kɨ kàdrɨ̀ nda kòyi Yésu nɨ rúbí dre dhɨ, dré Yúdà ànzɨ kɨ bhàgo àruka kɨ mùzo Yésu nɨ ti lizí, kàlɨ̀ró áyɨ màrábà nda nɨ tɨdrɨ́. ");
INSERT INTO log_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Àyɨ nda ɨ̀ kòtsa Yésu véna dre dhɨ, ɨ̀ dré akódhɨ nɨ ti lizízó tà tàndɨ ró, tàzoá dhɨ: «Agó kòdhɨ kɨtswá mɨ́ dré lɨ̀zo akódhɨ nɨ màrábà tɨdrɨ́. ");
INSERT INTO log_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Tàko ko, akódhɨ lè àma kɨ súrú tò. ꞌO kpà àma kɨ lɨ̀sámbò dzó sìle dhɨ nɨ̀.» ");
INSERT INTO log_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Dɨ Yésu dré ngàzo adrélé lɨ̀le àyɨ ɨ́be. Dré adréràꞌa ꞌòle tsàle dhɨ ꞌá dhɨ, sòdá kɨ kàdrɨ̀ nda dré áyɨ arúpi kɨ mùzo tàá drá dhɨ: «Mírì, mɨ́ lagù mɨ ko. Má kɨtswá mána ámɨ lɨndrɨ̀ sè ko. Má kɨtswá ndɨ̀ndɨ̀ mɨ́ dré afɨ́zó áma dzó lé dhɨ ko. ");
INSERT INTO log_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Má nò tá kpà dhɨ, má kɨtswá tá lɨ̀le mɨ́ véna ko. Dɨ, mɨ́ kòtà ndɨrɨ kúlí àlo gò, áma màrábà kàdrɨ́ró. ");
INSERT INTO log_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Tàko ko, áma tàndɨ, ma áma kàdrɨ̀ kɨ rìnyí zàle. Ma kpà sòdá ɨ́be má zàle. Má kàdré tàá àyɨ kɨ àlo dré dhɨ ‹Mɨ́ lɨ̀!› dhɨ, adré lɨ̀le. Má kàdré tàá àzya nɨ dré dhɨ ‹Mɨ́ alɨ̀!› dhɨ, adré alɨ̀le. Má kàdré kó tàá áma màrábà dré dhɨ ‹Mɨ́ ꞌo tà kòdhɨ!› dhɨ, adré ꞌòá.» ");
INSERT INTO log_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Dɨ Yésu kòyi tà nda dre dhɨ, akódhɨ nɨ lɨ́ndrɨ́ dré gàzo agó nda nɨ tà sè. Dré áyɨ alázó tàá móndɨ́ zyandre adrébhá áyɨ lebè dhɨ ɨ dré dhɨ: «Má adré tàá àmɨ dré dhɨ: Má kisú rè dhya àlo adrélépi tà kaꞌìkaꞌì ɨ́be kònɨ̀nɨ dhɨ Ɨ̀sèrélè ànzɨ ɨ kòfalé ko.» ");
INSERT INTO log_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Dɨ dhya mùle nda ɨ̀ kògò tsàle bhà na dre dhɨ, ɨ̀ dré kisúzóá dhɨ, màrábà nda adrɨ́ dre. ");
INSERT INTO log_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Àmvolásà dhɨ, Yésu dré ngàzo adrélé lɨ̀le bhàandre àlo rú be Nàyɨ́nà dhɨ na. Akódhɨ nɨ lebèbhá ɨ móndɨ́ zyandre lavúlé dhɨ ɨ́be dhɨ ɨ̀ adré tá lɨ̀le túmä́ní akódhɨ be. ");
INSERT INTO log_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ɨ̀ kòtsa ànyɨ bhàandre nda nɨ zèríbàti dre dhɨ, à adré tá àbvò àlo dhɨ nɨ adó apfòzo ába lɨ̀le mógó na. Dhya dràlepi nda tá tàyɨ́tòkó àlo dhɨ nɨ mváagó àlo kwákwá dhɨ ꞌɨ. Móndɨ́ zyandre lavúlé bhàandre nda lésè dhɨ ɨ̀ adré tá alɨ̀le túmä́ní tòkó nda be. ");
INSERT INTO log_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Dɨ Mírì kònò akódhɨ dre dhɨ, dré kɨzà dòzo áyɨ togó na akódhɨ nɨ tà sè gò, tàzoá drá dhɨ: «Mɨ́ tayɨ́ àwó.» ");
INSERT INTO log_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Dré áyɨ kisízó ànyɨ sèreké tabè. Gò dhya adrébhá tá àbvò nda nɨ adó dhɨ ɨ̀ dré àyɨ kɨ kɨkɨ́zó. Dré tàzoá dhɨ: «Kàdhúrà, má adré tàá mɨ́ dré dhɨ, mɨ́ nga kuru!» ");
INSERT INTO log_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Dɨ dhya dràlepi nda dré ngàzo lɨrɨ́lé gò, kɨdhólé tà ta. Gò Yésu dré akódhɨ nɨ logózó andre nɨ drɨ́gá. ");
INSERT INTO log_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Dɨ tirì dré móndyá títí nda kɨ rùzo gò, ɨ̀ dré ngàzo adrélé Gìká nɨ rú bha kùle, adrézó tàá dhɨ: «Pròfétà kàdrɨ̀ dhɨ apfò àma kòfalé dre! Gìká atsá ɨ́na áyɨ móndyá kɨ lomɨ́!» ");
INSERT INTO log_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Gò Yésu nɨ rúbí nda dré laꞌúzó bhà títí àyɨ làgásè dhɨ ɨ ꞌásè, ɨ̀ndɨ̀ Yúdà ànzɨ kɨ bvò wä́yi ꞌásè. ");
INSERT INTO log_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Àmvolásà dhɨ, Yòwánɨ̀ nɨ lebèbhá ɨ̀ dré tà títí Yésu dré tá adrélé ꞌòle nda kɨ tɨtɨ́zó drá. Gò Yòwánɨ̀ dré áyɨ lebèbhá rì dhɨ kɨ azízó ");
INSERT INTO log_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","mùle lɨ̀le Mírì véna, kɨtswálé akódhɨ nɨ lizí tàzoá dhɨ: «Mɨ Mèsɨ́yà adrélépi tá alɨ̀le dhɨ ꞌɨ? Kó ngalè, mà kàdré dhu rè dhya àzya nɨ letè?» ");
INSERT INTO log_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Dɨ àyɨ nda ɨ̀ kàtsá Yésu vélé dre dhɨ, ɨ̀ dré tàzoá drá dhɨ: «Yòwánɨ̀ Bàtísimò fèlepi amù àma ámɨ lizí: ‹Mɨ dhya adrélépi tá alɨ̀le dhɨ ꞌɨ. Kó ngalè, mà kàdré dhu rè dhya àzya nɨ letè kòdhya?›» ");
INSERT INTO log_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Gbǎ lókyá nda sè dhɨ, Yésu dré móndɨ́ bǐ dhɨ kɨ tɨdrɨ́zó àyɨ kɨ drà ɨ lésè, ɨ̀ndɨ̀ àyɨ kɨ rúbháaswa ɨ lésè. Dré kpà tɨrɨ́ kònzɨ kɨ dròzo topfòle móndɨ́ bǐ dhɨ ɨ lésè. Dré kókpà mì kùdúkùdu bǐ dhɨ kɨ mì nzìzo. ");
INSERT INTO log_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Gò dré logózóá dhya amùle nda ɨ dré dhɨ: «Mɨ̀ gò tà mɨ̀ dré nòle ɨ̀ndɨ̀ mɨ̀ dré yìle kònɨ kɨ tɨtɨ́ Yòwánɨ̀ dré: Mì kùdúkùdu ɨ̀ adré ngá no, mèrèkpè ɨ̀ adré atsí to, móndɨ́ kàrɨ́ dré rùle dhɨ ɨ̀ adré adrɨ́lé, móndɨ́ bíbhálé be kùdúkùdu ró dhɨ ɨ̀ adré tà yi, móndɨ́ dràbhá dre dhɨ ɨ̀ adré angálé dràdrà lésè, ɨ̀ndɨ̀ à adré Rúbí Tanɨ longó lemerèbhá ɨ dré. ");
INSERT INTO log_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Kólénzé dhya ángùdhi dra dhèlepi áma tà sè ko dhɨ dré!» ");
INSERT INTO log_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Dhya Yòwánɨ̀ dré amùle nda ɨ̀ kòlɨ̀ dre dhɨ, Yésu dré kɨdhózó adrélé Yòwánɨ̀ nɨ tà ta móndyá zyandre ɨ dré, adrézó tàá dhɨ: «Mɨ̀ lɨ̀ tá duku na àdho no? Mɨ̀ lɨ̀ kòzó lyǎ dré tá adrélé vìle dhɨ nɨ no? ");
INSERT INTO log_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Mɨ̀ lɨ̀ tá àdho no? Mɨ̀ lɨ̀ móndɨ́ kɨ́tá aveave asólépi ɨ́ rú dhɨ nɨ no? Mɨ̀ yi rè ká! Móndyá adrébhá kɨ́tá làgɨ́ be kàdrɨ̀ dhɨ kɨ tosó, adrézó ngá dò nya dhɨ ɨ àyɨkya ópɨ́ kɨ dzó kàdrɨ̀ ɨ ꞌásè be. ");
INSERT INTO log_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Mɨ̀ lɨ̀ tá dɨ àdho no? Mɨ̀ lɨ̀ pròfétà nɨ no? Àyíya! Má adré tàá àmɨ dré dhɨ: Yòwánɨ̀ nda lavú pròfétà byá. ");
INSERT INTO log_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Tàko ko, akódhɨ dhya tà kònɨ̀dhɨ nɨ tɨsɨ̀zo tà nɨ dri Gìká nɨ Kúlí na dhɨ ꞌɨ: ‹Mɨ́ nò ká! Má nɨ dhya dra áma kúlí longólépi dhɨ nɨ mu lɨ̀le mɨ́ kandrána. Akódhɨ nda nɨ láti ledé mɨ́ dré mɨ́ kandrána.› ");
INSERT INTO log_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Má adré tàá àmɨ dré dhɨ: Móndyá títí tòkó dré tìle dhɨ ɨ kòfalé dhɨ, dhya àlo kàdrɨ̀ Yòwánɨ̀ nda nɨ lavúlépi dhɨ yókódhó. Dɨ, tágba dré adrézó kònɨ̀nɨ dhɨ, dhya tàko lavúlé Gìká nɨ Òpɨ̀ na dhɨ lavú ɨ́na akódhɨ. ");
INSERT INTO log_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Móndyá títí, ndɨ̀ndɨ̀ mèdáyɨ̀ lagɨ́bhá, Yòwánɨ̀ nɨ kúlí yibhá dhɨ ɨ̀ nò tá Gìká nɨ tà nda gyǎgya gò, ɨ̀ dré bàtísimò dòzo Yòwánɨ̀ véna. ");
INSERT INTO log_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Dɨ, Fàrìsáyò ɨ tátrɨ́trɨ́ kúlí tadhábhá ɨ́be dhɨ ɨ̀ gà tá àyɨkya tà Gìká dré tá lèle ꞌòle àyɨ dré dhɨ gò, ɨ̀ dré kpà bàtísimò dòma Yòwánɨ̀ véna dhɨ nɨ gàzo. ");
INSERT INTO log_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Dɨ má nɨ kɨtswá móndyá ándrò kònɨ kɨ tà tadhá àdho ngá rú? Àyɨ nda ɨ̀ sù àdhibhá ɨ tɨ́nɨ? ");
INSERT INTO log_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ɨ̀ sù ngóró ànzɨmvá lɨrɨ́bhá ngá lagɨ́rà na, adrélé kúlí loyó àyɨ kòfalésè dhɨ ɨ tɨ́nɨ. Ɨ̀ adré loyóá dhɨ: ‹Mà tswà lärí àmɨ dré wóyá, mɨ̀ to àmɨkya lärí nda ko. Mà ngo àwó longó wóyá, mɨ̀ ngo àmɨkya àwó ko.› ");
INSERT INTO log_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Tàko ko, Yòwánɨ̀ Bàtísimò fèlepi nda dré alɨ̀zo dhɨ, nya tá mápà ko, mvu kpà vínò ko gò, mɨ̀ dré adrézó tàá dhɨ: ‹Akódhɨ tɨrɨ́ kònzɨ ɨ́be ɨ́ léna.› ");
INSERT INTO log_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Dɨ, ma, Móndɨ́ nɨ Mvá, má dré alɨ̀zo dhɨ, má adré mána ngá nya, adrézó kpà ngá mvu gò, mɨ̀ dré adrézó tàá dhɨ: ‹Dhya kòdhɨ kòvongbolo líyí ꞌɨ, wá lìtsí líyí ꞌɨ, ɨ̀ndɨ̀ mèdáyɨ̀ lagɨ́bhá kɨ arúpi tàkonzɨ̀bhá ɨ́be dhɨ ꞌɨ!› ");
INSERT INTO log_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Dɨ, à adré Gìká nɨ tògyá no gyǎgya, móndyá adrébhá tògyá nda nɨ kaꞌì dhɨ ɨ rú.» ");
INSERT INTO log_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Kìtú àlo dhɨ, Fàrìsáyò kɨ àlo zi tá Yésu lɨ̀le ngá nya ɨ́ bhàna. Yésu dré tsàzo fɨ̀le Fàrìsáyò nda nɨ dzó na gò, lɨrɨ́lé mɨ́sá làga. ");
INSERT INTO log_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Dɨ tòkó àlo tàkonzɨ̀ líyí ro adrélépi bhàandre nda ꞌá dhɨ kòyi Yésu adré tá ngá nya Fàrìsáyò nda bhàna dhɨ dre dhɨ, dré alɨ̀zo mòlàngɨ̀ mvá ledélé àlàbásterè sè, gàlepi màlásɨ̀ sè bǐ dhɨ be. ");
INSERT INTO log_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Dré áyɨ kisízó ànyɨ Yésu àmvolésè akódhɨ nɨ pá làga. Gò dré ngàzo adrélé ngòle, adrélé mìndra da akódhɨ pá, adrézó pá nɨ kɨ atrì áyɨ drìbhɨ́ sè, adrézó pá nda kɨ kamú gò, adrézó màlásɨ̀ da drìá. ");
INSERT INTO log_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Dɨ Fàrìsáyò Yésu nɨ azílépi nda kònò tà nda dre dhɨ, dré dhèzo adrélé kisùá ɨ́ léna dhɨ: «Kònò dhya kònɨ̀dhɨ kàdré tá pròfétà ꞌɨ bàti dhɨ, a nɨ tá nìá ngalè tòkó adrélépi áyɨ tabè nɨ àdhi ꞌɨ ya, ɨ̀ndɨ̀ adré atsílé ngɨ́nɨ ya dhɨ be. Àngyá ko, akódhɨ tàkonzɨ̀ líyí ꞌɨ.» ");
INSERT INTO log_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Gò Yésu dré tàzoá Fàrìsáyò nda dré dhɨ: «Sìmónà, ma tà ɨ́be tàle mɨ́ dré.» Sìmónà nda tà dhɨ: «Tadhálépi, mɨ́ tà wà.» ");
INSERT INTO log_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Dɨ Yésu tà dhɨ: «Móndɨ́ rì dhɨ ɨ̀ do tá làfa agó àlo adrélépi làfa fe màri ró dhɨ véna. Àlo nɨ tá màri ɨ́be làfa lòꞌwa kámá-nzi agó nda véna. Àzya nɨ tá màri ɨ́be làfa lòꞌwa nyadhɨ-rì-drì-mudrí. ");
INSERT INTO log_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Àyɨ rìti nda ɨ̀ dré kɨtswálé màri nda kɨ logó bwà ko dhɨ sè dhɨ, agó nda dré màri àyɨ rú dhɨ kɨ tà tayɨ́zó. Dɨ àyɨ kòfalé dhɨ, dhya ángùdhi nɨ agó nda nɨ le lavúlé dhɨ nɨ̀?» ");
INSERT INTO log_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Sìmónà logó drá dhɨ: «Má adré kisùá dhɨ, dhya adrélépi tá màri kàdrɨ̀ lavúlé dhɨ ɨ́be ɨ́ rú gò, agó nda dré tà nɨ nɨ tayɨ́zó dhɨ ꞌɨ.» Yésu tà drá dhɨ: «Mɨ́ kisù kyá.» ");
INSERT INTO log_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Gò dré áyɨ alázó tòkó nda vélé gò, tàá Sìmónà dré dhɨ: «Mɨ́ adré tòkó kònɨ̀dhɨ nɨ no? Má dré afɨ́zó ámɨ dzó ꞌá dhɨ, mɨ́ afè tá má dré yǐ áma pá dzɨ̀zo dhɨ ko. Dɨ, akódhɨ dzɨ̀ ɨ́na áma pá áyɨ mìndra sè gò, àyɨ kɨ atrìzo áyɨ drìbhɨ́ sè. ");
INSERT INTO log_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Mɨ́ kamú tá ma ko. Dɨ, kɨdhólé má dré afɨ́rà lésè dhɨ, akódhɨ tayɨ́ ɨ́na áma pá kɨ kamuma ko. ");
INSERT INTO log_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Mɨ́ dà tá dò má dri ko. Dɨ, akódhɨ dà ɨ́na màlásɨ̀ má pá. ");
INSERT INTO log_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Dɨ má adré tàá mɨ́ dré dhɨ: À trì akódhɨ nɨ tàkonzɨ̀ zyandre dhɨ ɨ dre. Ásà dhɨ, adré áyɨ lèle kàdrɨ̀ dhɨ nɨ tadhá má dré. Dɨ, dhya ángùdhi tàkonzɨ̀ nɨ nɨ trìzo tsà dhɨ adré ɨ́na áyɨ lèle tadhá tsà.» ");
INSERT INTO log_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Gò Yésu dré tàzoá tòkó nda dré dhɨ: «À trì ámɨ tàkonzɨ̀ ɨ dre.» ");
INSERT INTO log_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Dɨ móndyá adrébhá tá mɨ́sá làgásè túmä́ní akódhɨ be dhɨ ɨ̀ dré dhèzo adrélé tàá àyɨ kòfalésè dhɨ: «Dhya kòndɨ tá àdhi ꞌɨ, adrélé ndɨ̀ndɨ̀ tàkonzɨ̀ tri nɨ?» ");
INSERT INTO log_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Dɨ, Yésu dré gòzo tàá tòkó nda dré dhɨ: «Ámɨ tà kaꞌìkaꞌì tɨdrɨ́ mɨ dre. Mɨ́ lɨ̀ togó be kɨ̀drɨ́kɨ̀drɨ.» ");
INSERT INTO log_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Àmvolásà dhɨ, Yésu dré ngàzo adrélé tatsílé bhàandre ɨ ꞌásè ɨ̀ndɨ̀ bhà tsàtsà ɨ ꞌásè, Rúbí Tanɨ Gìká nɨ Òpɨ̀ àdhya nɨ longóbe móndɨ́ ɨ dré. Akódhɨ nɨ lebèbhá mudrí-drì-rì dhɨ ɨ tá kpà túmä́ní akódhɨ be. ");
INSERT INTO log_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Tòkó àruka dré tá tɨrɨ́ kònzɨ kɨ dròzo àyɨ lésè dhɨ ɨ, ɨ̀ndɨ̀ àyɨ dré tá tɨdrɨ́lé drà lésè dhɨ ɨ tá kpà túmä́ní akódhɨ be. Àyɨ nda ɨ tá: Màrɨ́yà (adrélé zìle Màrɨ́yà Màgàdàlénè, dré tɨrɨ́ kònzɨ nzi-drì-rì dhɨ kɨ dròzo topfòle lásà dhɨ), ");
INSERT INTO log_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Yòwánà (Kúzà, ópɨ́ Èródè nɨ dzó nɨ tà kɨ lɨkɨ́lépi dhɨ nɨ tòkó), Sùsánà, tsàle tòkó àruka bǐ dhɨ ɨ́be. Ɨ̀ adré tá Yésu nɨ ledé akódhɨ nɨ lebèbhá ɨ́be àyɨ kɨ ngá sè. ");
INSERT INTO log_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Kìtú àlo dhɨ, móndɨ́ zyandre lavúlé angábhá bhàandre twátwa ɨ lésè dhɨ ɨ̀ alɨ̀ tá ru kɨmó Yésu làga gò, akódhɨ dré pɨ́dhɨ́gó kònɨ̀dhɨ nɨ pɨ̀zo, tàzoá dhɨ: ");
INSERT INTO log_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Kìtú àlo dhɨ, agó àlo dhɨ pfò tá lɨ̀le kórɨ̀ rɨ áyɨ amvú na. Dré tá adréràꞌa kórɨ̀ rɨ dhɨ ꞌá dhɨ, kórɨ̀ àruka ɨ̀ ledhé tá láti mìle gò, atózóá gò, àrɨ́ ɨ̀ dré tetézóá títí. ");
INSERT INTO log_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Kórɨ̀ àruka ɨ̀ ledhé tá kɨ́rà dri gò, ɨ̀ dré apfòzo ndɨrɨ ꞌyòle, àyɨ kɨ kɨ́drɨ dré yǐ kisúlé ko dhɨ sè. ");
INSERT INTO log_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Kórɨ̀ àruka ɨ̀ ledhé tá kùtsí kòfalé gò, kùtsí nda dré mbàzo ába àyɨ kɨ amó. ");
INSERT INTO log_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Dɨ, kórɨ̀ àruka ɨ̀ ledhé tá àyɨkya kìní dóro dri gò, ɨ̀ dré apfòzo mbàle lòꞌwa ꞌa dóro. Àyɨ àlo àlo títí dhɨ ɨ̀ ꞌa lòꞌwa nyadhɨ-nzi.» Yésu kòtà tà nda dre dhɨ, dré yòzoá dhɨ: «Dhya ángùdhi adrélépi bíbhálé ɨ́be tà yìzo dhɨ kòyi.» ");
INSERT INTO log_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Àmvolásà dhɨ, Yésu nɨ lebèbhá ɨ̀ dré lizízóá akódhɨ tí, ngalè pɨ́dhɨ́gó nda adré tá lèá tàle ngɨ́nɨ ya dhɨ. ");
INSERT INTO log_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Dɨ dré logózóá àyɨ dré dhɨ: «Gìká fè àmɨ dré tògyá áyɨ Òpɨ̀ nɨ tà lùzu ró dhɨ kɨ nìzo. Dɨ, móndyá àruka títí ɨ dré dhɨ, má adré tà ta pɨ́dhɨ́gó sè kɨtswálé: ‹ɨ̀ kàdré gba ngá no yà dhɨ, ɨ̀ kàdréró ngá nda kɨ no dóro ko, ɨ̀ndɨ̀ ɨ̀ kàdré gba tà yi yà dhɨ, ɨ̀ kàdréró tà nda kɨ àndu ni ko.›» ");
INSERT INTO log_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Dɨ Yésu gò tàá àyɨ dré dhɨ: «Pɨ́dhɨ́gó nda nɨ àndu kònɨ̀dhɨ ꞌɨ: Kórɨ̀ rɨ̀le nda, Gìká nɨ kúlí ꞌɨ. ");
INSERT INTO log_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Móndɨ́ àruka ɨ̀ adré kúlí nda nɨ kaꞌì ngóró kórɨ̀ rɨ̀le ledhélé láti mìle nda ɨ tɨ́nɨ. Ɨ̀ kòyi kúlí nda dre dhɨ, Dzáborò adré ndɨrɨ atsálé kúlí nda nɨ tɨngá àyɨ kɨ togó lésè, ɨ̀ kòkaꞌìró adrɨ́zó ko dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Móndɨ́ àruka ɨ̀ adré Gìká nɨ kúlí kaꞌì ngóró kórɨ̀ rɨ̀le ledhélé kɨ́rà dri nda ɨ tɨ́nɨ. Ɨ̀ kòyi kúlí nda dre dhɨ, ɨ̀ adré ndɨrɨ kaꞌìá arɨ́ sè. Dɨ, ɨ̀ dré adrélé kúlí nda nɨ tayɨ́ adrélé tɨ̀le àyɨ kɨ togó na ko dhɨ sè dhɨ, ɨ̀ adré ngbà ꞌí kaꞌìá lókyá tsà sè. Lókyá tà dré adrézó àyɨ kɨ tabhì dhɨ kàtsá dre dhɨ, ɨ̀ adré àyɨ kɨ tà kaꞌìkaꞌì nda nɨ tayɨ́. ");
INSERT INTO log_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Móndɨ́ àruka ɨ̀ adré Gìká nɨ kúlí kaꞌì ngóró kórɨ̀ rɨ̀le ledhélé kùtsí kòfalé nda ɨ tɨ́nɨ. Ɨ̀ kòyi kúlí nda dre dhɨ, gí ko, tà adrébhá àyɨ kɨ togó ꞌo lanzìle dhɨ ɨ, ngá lovó, ɨ̀ndɨ̀ lovó kònzɨ twátwa lɨ́drɨ̀ kòndɨ àdhya ɨ̀ adré kúlí nda nɨ amó gò, ɨ̀ dré adrézó lɨꞌwálé ko, adrézó kpà lòꞌwa ꞌa ko. ");
INSERT INTO log_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Dɨ, móndɨ́ àruka ɨ̀ adré àyɨkya Gìká nɨ kúlí kaꞌì ngóró kórɨ̀ rɨ̀le ledhélé kìní dóro dri nda ɨ tɨ́nɨ. Àyɨ nda ɨ̀ adré kúlí nda nɨ yi togó be gyǎgya ɨ̀ndɨ̀ dóro, adrézó tròle rúá gò, adrézó lòꞌwa ꞌa dóro landè àko ró.» ");
INSERT INTO log_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yésu gò tàá dhɨ: «À dhɨ̀ gà tálà bhàle lɨ̀drɨ́ zàna yà, kó ngalè lángá zàna yà dhɨ ko na. Be ró dhɨ, à adré dhɨ̀á bhàle zá kuru mɨ́sá drìna, kɨtswálé móndyá títí adrébhá afɨ́lé dzó lé dhɨ ɨ̀ kàdréró ngádra no be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Tàko ko, à nɨ tà títí zùle zùzù dhɨ kɨ ꞌo apfòle ngádra ꞌá. À nɨ kpà tà títí lùzu ró dhɨ kɨ ꞌo móndɨ́ ɨ̀ dré nìle dóro. ");
INSERT INTO log_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Dɨ ásà dhɨ, lè mɨ̀ kàdré àmɨ kɨ lɨkɨ́ adrélé tà yi dóro. Àngyá ko, dhya ángùdhi tà nìlepi bǐ dhɨ dré dhɨ, à nɨ tà dré nìle nda kɨ drì tɨmbà. Dɨ, dhya ángùdhi tà nìlepi ko dhɨ dré dhɨ, à nɨ ndɨ̀ndɨ̀ tà tsà dré kisùle nìle dhɨ nɨ tɨngá.» ");
INSERT INTO log_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Gò Yésu nɨ andre ɨ adrúpi nɨ ɨ́be dhɨ ɨ̀ dré alɨ̀zo kɨtswálé akódhɨ nɨ no dhɨ bvó. Dɨ, móndɨ́ zyandre dhɨ kɨ tà sè dhɨ, ɨ̀ kɨtswá tá atsálé rúá bwà ko. ");
INSERT INTO log_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Gò tàzoá drá dhɨ: «Ámɨ andre ɨ ámɨ adrúpi ɨ́be dhɨ ɨ̀ adré àyɨ kɨ totó kɨvɨ̀ na. Ɨ̀ adré ámɨ le nòle.» ");
INSERT INTO log_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Dɨ, Yésu dré logózóá dhɨ: «Áma andre ɨ áma adrúpi ɨ́be dhɨ ɨ, dhya adrébhá Gìká nɨ kúlí yi gò ɨ̀ dré adrézó kaꞌìá ꞌòle dhɨ ꞌɨ.» ");
INSERT INTO log_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Kìtú àlo dhɨ, Yésu tà tá áyɨ lebèbhá ɨ dré dhɨ: «Mà kòzya tä́pä́ríandre nɨ taꞌá na.» Dɨ ɨ̀ dré tombàzo bwátù na gò, ɨ̀ dré kɨdhózó adrélé zyàle. ");
INSERT INTO log_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ɨ̀ dré tá adréràꞌa zyàle dhɨ ꞌá dhɨ, Yésu dré dhèzo adrélé ayí ko. Gbǎ kòdhwa, lyǎandre gú dhɨ dré ngàzo adrélé vìle tä́pä́ríandre nda mi. Yǐ dré ngàzo adrélé gàle bwátù na gò, bwátù nda dré adrézó ꞌòle arɨ́lé. Àyɨ tá ànyɨ́ànyɨ dràdrà mìle. ");
INSERT INTO log_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Gò akódhɨ nɨ lebèbhá nda ɨ̀ dré àyɨ kɨ kisízó ànyɨ làgá, akódhɨ nɨ toró tàzoá dhɨ: «Mírì, Mírì, mà adré dràle!» Dɨ Yésu dré ngàzo lɨgɨ́lé lyǎandre nda dri yǐ adrélépi ru kägbä́ nda be gò, ɨ̀ dré rɨ̀zo gò, ngá dré gòzo bhùle ndiii. ");
INSERT INTO log_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Dɨ Yésu dré áyɨ lebèbhá kɨ lizízó tàzoá dhɨ: «Àmɨ kɨ tà kaꞌìkaꞌì ángwà?» Tirì dré gàzo àyɨ léna bǐ gò, àyɨ kɨ lɨ́ndrɨ́ dré gàzo bhwǎbhwa. Dɨ ɨ̀ dré adrézó lizíá àyɨ kòfalésè dhɨ: «Dhya kòndɨ tá ɨ́na àdhi ꞌɨ, adrélé ndɨ̀ndɨ̀ tòlɨ́ fe lyǎandre ɨ dré yǐandre be gò, ɨ̀ dré adrézó akódhɨ nɨ kúlí kaꞌì ꞌòle nɨ?» ");
INSERT INTO log_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ɨ̀ kòzya tä́pä́ríandre nda nɨ taꞌá na dre dhɨ, ɨ̀ dré tsàzo bvò Gèrásà kya na. Bvò nda bvò Gàlìláyà àdhya tä́pä́ríandre nda nɨ taꞌá lésè dhɨ kandrá. ");
INSERT INTO log_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yésu kàsí bwátù lésè dre dhɨ, agó àlo tɨrɨ́ kònzɨ ɨ́be ɨ́ léna dhɨ dré alɨ̀zo kɨtswálé ru kisú akódhɨ be. Akódhɨ nda angá tá bhàandre àlo ànyɨ àyɨ làga dhɨ lésè. Dɨ, lókyá be vwàvwà ro dhɨ, asó tá vélé kɨ́tá ko, ayí kpà vélé dzó na ko. Adré tá ɨ́na ayílé mógó ꞌásè. ");
INSERT INTO log_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Dɨ kònò Yésu dre dhɨ, dré ngàzo trèle, adhézó akódhɨ pá gò, yòá kúlí ꞌuꞌù sè dhɨ: «Yésu, Gìká kurú na dhɨ nɨ Mváagó, àma kòfalésè mɨ́ be dhɨ, àdho tà ꞌɨ? Má adré ngòle mɨ́ rú, mɨ́ kòꞌoró ma kònzɨ ko!» ");
INSERT INTO log_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Tà tá kònɨ̀nɨ tàko ko, Yésu tà tá tɨrɨ́ kònzɨ nda dri dhɨ, kòpfò agó nda lésè. Àngyá ko, vésè be bǐ, tɨrɨ́ kònzɨ nda adré tá akódhɨ nɨ ru. Tágba à kàdré akódhɨ nɨ drɨ́gá kɨ tɨꞌɨ̀ pá nɨ ɨ́be nyɨ̀rɨ̀ sè, adrézó akódhɨ nɨ lɨkɨ́ dóro yà dhɨ, akódhɨ adré tá nyɨ̀rɨ̀ nda kɨ tɨkɨ́ gò, tɨrɨ́ kònzɨ nda dré adrézó akódhɨ nɨ tɨkpó lɨ̀le duku na. ");
INSERT INTO log_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Gò Yésu dré lizízóá tíá dhɨ: «Ámɨ rú àdhi?» Akódhɨ logó drá dhɨ: «Áma rú ‹Zyandre›.» Tà tá kònɨ̀nɨ tàko ko, tɨrɨ́ kònzɨ zyandre dhɨ ɨ̀ tɨfɨ́ tá akódhɨ léna. ");
INSERT INTO log_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Dɨ tɨrɨ́ kònzɨ nda ɨ̀ dré dhèzo adrélé ngòle Yésu rú, kòmùró àyɨ lɨ̀le bhú kùdù àko dhɨ na ko. ");
INSERT INTO log_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Àyɨ làgana kònànɨ dhɨ, tɨ̀gá kɨ pä̀rí andre adré tá ngá nya kòngó drìna. Dɨ tɨrɨ́ kònzɨ nda ɨ̀ dré Yésu nɨ ti lizízó, kòtayɨ́ró àyɨ lɨ̀le tɨfɨ́lé tɨ̀gá nda ɨ léna. Gò Yésu dré kaꞌìzoá. ");
INSERT INTO log_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Dɨ tɨrɨ́ kònzɨ nda ɨ̀ dré topfòzo agó nda lésè, lɨ̀le tɨfɨ́lé tɨ̀gá nda ɨ léna. Gò tɨ̀gá nda ɨ̀ dré ndìzo títí kòngó nda nɨ gòlòko ꞌásè, ledhélé tä́pä́ríandre na, yǐ mvu gò, todràzo. ");
INSERT INTO log_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Dɨ tɨ̀gá nda kɨ lɨkɨ́bhá ɨ̀ kònò tà lavúlépi nda dre dhɨ, ɨ̀ dré ngàzo ràle rúbí nɨ nɨ longóbe bhàandre na ɨ̀ndɨ̀ gbàbhú ꞌásè. ");
INSERT INTO log_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Gò móndɨ́ zyandre dhɨ ɨ̀ dré apfòzo tà lavúlépi nda nɨ no. Ɨ̀ kàtsá Yésu vélé dre dhɨ, ɨ̀ dré agó tɨrɨ́ kònzɨ kɨ dròzo topfòle lásà nda nɨ kisúzó, adréràꞌa lɨrɨ́lé Yésu làga. Akódhɨ tá kɨ́tá ɨ́be ɨ́ rú ɨ̀ndɨ̀ tà kisùkisù ɨ́be dóro. Dɨ tirì dré àyɨ kɨ ꞌòzo lavúlé. ");
INSERT INTO log_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Gò dhya tà nda nɨ nobhá mì sè dhɨ ɨ̀ dré agó tá tɨrɨ́ kònzɨ ɨ́be nda adrɨ́ tá ngɨ́nɨ ya dhɨ nɨ tɨtɨ́zó àyɨ dré. ");
INSERT INTO log_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Dɨ móndyá zyandre títí bvò Gèrásà kya nda ꞌá dhɨ ɨ̀ dré Yésu nɨ ti lizízó, kòngaró àyɨ kɨ bvò ꞌásè, tirì dré gàle àyɨ léna bǐ dhɨ sè. Dɨ Yésu dré mbàzo bwátù na kɨtswálé lɨ̀le dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Gò agó tɨrɨ́ kònzɨ kɨ dròzo topfòle lásà nda dré Yésu nɨ ti lizízó, ɨ̀ kòlɨ̀ró túmä́ní. Dɨ, Yésu dré ɨ́na akódhɨ nɨ logózó, tàzoá drá dhɨ: ");
INSERT INTO log_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«Mɨ́ nzɨ mɨ́ bhàna, ɨ̀ndɨ̀ mɨ́ tɨtɨ́ tà títí Gìká dré ꞌòle mɨ́ dré dhɨ ɨ móndɨ́ ɨ dré.» Dɨ agó nda dré ngàzo lɨ̀le tà títí Yésu dré ꞌòle ɨ́ dré dhɨ kɨ longóbe bhàandre nda ꞌásè títí. ");
INSERT INTO log_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yésu kàzyá tä́pä́ríandre nda nɨ taꞌá lésè agòle dre dhɨ, móndɨ́ zyandre adrébhá tá akódhɨ nɨ letè dhɨ ɨ̀ dré akódhɨ nɨ kaꞌìzo dòle àyɨ kòfalé dóro. ");
INSERT INTO log_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Gò agó àlo rú be Yàyírò, Yúdà ànzɨ kɨ lɨ̀sámbò dzó nɨ kàdrɨ̀ kɨ àlo ró dhɨ, dré alɨ̀zo adhélé Yésu pá akódhɨ nɨ ti lizí, kòlɨ̀ró ɨ́ bhàna. ");
INSERT INTO log_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Tàko ko, akódhɨ nɨ mvátòkó àlo kwákwá, adrélépi kóná ɨ́be ànyɨ́ànyɨ mudrí-drì-rì dhɨ tá ànyɨ dràdrà mìle. Dɨ Yésu ɨ̀ dré tá adréràꞌa lɨ̀le dhɨ ꞌá dhɨ, móndɨ́ zyandre dhɨ ɨ̀ adré tá akódhɨ nɨ amó, adrézó àyɨ kɨ tribe rúásà. ");
INSERT INTO log_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Dɨ àyɨ nda ɨ kòfalé dhɨ, tòkó àlo kàrɨ́ dré adrézó ràle rúásà kóná be mudrí-drì-rì dhɨ tá be. Akódhɨ nda kɨzá tá ngá ɨ́ drɨ́gásè akɨ́lé títí kódzó ɨ dré wóyá. Dɨ, dhya àlo kɨtswá tá akódhɨ nɨ tɨdrɨ́ bwà ko. ");
INSERT INTO log_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Dɨ dré áyɨ kisízó ànyɨ Yésu àmvolésè gò, akódhɨ nɨ kɨ́tá ti tabè. Gbǎ kòdhwa, kàrɨ́ adrélépi ràle rúásà nda dré akɨ́zó. ");
INSERT INTO log_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Gò Yésu dré lizízóá dhɨ: «Àdhi tabè ma nɨ̀?» Dɨ móndyá títí nda ɨ̀ dré adrézó tàá dhɨ, ɨ̀ ꞌo tá tà nda àyɨ ko. Gò Pétèró dré tàzoá dhɨ: «Mírì, móndyá zyandre kònɨ ɨ̀ adré ámɨ gàrà kɨ kúrú, adrézó àyɨ kɨ tribe mɨ́ rúsè.» ");
INSERT INTO log_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Dɨ, Yésu gò ɨ́na tàá dhɨ: «Dhya àlo tabè ma ꞌí. Tàko ko, má atógyà má rú dhɨ, rìnyí pfò má lésè dre.» ");
INSERT INTO log_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Dɨ tòkó nda kònò, ɨ́ kɨtswá vélé áyɨ zu bwà ko dhɨ dre dhɨ, dré alɨ̀zo lyabe tirì dré adhélé Yésu pá. Dré tɨtɨ́zóá móndyá títí ɨ kandrá dhɨ, ɨ́ tabè tá akódhɨ àdho tà sè ya, ɨ̀ndɨ̀ ɨ́ adrɨ́ gbǎ lókyá nda ꞌá ngɨ́nɨ ya dhɨ. ");
INSERT INTO log_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Dɨ Yésu dré tàzoá drá dhɨ: «Áma zapi, ámɨ tà kaꞌìkaꞌì tɨdrɨ́ mɨ dre. Mɨ́ lɨ̀ togó be kɨ̀drɨ́kɨ̀drɨ.» ");
INSERT INTO log_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yésu dré rè dhu adréràꞌa tà ta dhɨ ꞌá dhɨ, dhya àlo angálépi Yàyírò, lɨ̀sámbò dzó nɨ kàdrɨ̀ nda bhàlésè dhɨ dré atsázó tàá drá dhɨ: «Ámɨ zapi drà dre. Mɨ́ kògò adrélé dhya tà tadhálépi dhɨ nɨ lagù ko.» ");
INSERT INTO log_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Dɨ, Yésu kòyi tà nda dre dhɨ, dré tàzoá Yàyírò dré dhɨ: «Mɨ́ ro ngá ko. Mɨ́ kòkaꞌì ngbà ꞌí kaꞌìkaꞌì gò, akódhɨ kàdrɨ́ró.» ");
INSERT INTO log_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yésu kòtsa Yàyírò bhàna dre dhɨ, dré móndɨ́ àzya kaꞌìzo fɨ̀le ɨ́ be dzó nda na ko. Kaꞌì ngbà ꞌí Pétèró, Yòwánɨ̀, Yàkóbhò, tsàle mvátòkó nda nɨ atá ɨ andre nɨ be dhɨ ɨ kòdhya. ");
INSERT INTO log_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Móndyá títí dzó nda ꞌá dhɨ ɨ̀ adré tá àwó ngo, adrézó tongólé mvámvá nda nɨ tà sè. Dɨ, Yésu dré tàzoá àyɨ dré dhɨ: «Mɨ̀ tayɨ́ àwó. Àngyá ko, akódhɨ drà ko. Adré ɨ́na ayí ko.» ");
INSERT INTO log_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Gò ɨ̀ dré dhèzo adrélé akódhɨ nɨ gu, ɨ̀ dré nìle mvámvá nda drà tá bàti dhɨ sè. ");
INSERT INTO log_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Dɨ, Yésu dré akódhɨ nɨ drɨ́gá rùzo gò, tàzoá kúlí ꞌuꞌù sè dhɨ: «Mvámvá, mɨ́ nga!» ");
INSERT INTO log_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Gbǎ kòdhwa, akódhɨ nɨ lɨ́drɨ̀ dré agòzo gò, dré ngàzo kuru. Gò Yésu dré tàzoá dhɨ, ɨ̀ kòfè drá ngá nyàle. ");
INSERT INTO log_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Dɨ mvámvá nda nɨ atá ɨ andre nɨ be dhɨ kɨ lɨ́ndrɨ́ dré gàzo bhwǎbhwa. Dɨ, Yésu dré lazízóá àyɨ dri dhɨ, ɨ̀ kòlongó tà ru ꞌòlepi nda dhya àlo dré ko. ");
INSERT INTO log_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Àmvolásà dhɨ, Yésu dré áyɨ lebèbhá mudrí-drì-rì dhɨ kɨ azízó gò, rìnyí fèzo àyɨ dré kɨtswázó tɨrɨ́ kònzɨ títí dhɨ kɨ dro móndɨ́ ɨ lésè, ɨ̀ndɨ̀ kɨtswázó móndɨ́ kɨ tɨdrɨ́ àyɨ kɨ drà ɨ lésè. ");
INSERT INTO log_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Dré àyɨ kɨ tibhùzo lɨ̀le Gìká nɨ Òpɨ̀ nɨ tà longóbe, ɨ̀ndɨ̀ dràbhá kɨ tɨdrɨ́be, ");
INSERT INTO log_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","tàzoá àyɨ dré dhɨ: «Mɨ̀ do ngá àlo atsí sè dhɨ ko. Mɨ̀ kòdo kùtù fa ꞌɨ yà, kòmvò ꞌɨ yà, mápà ꞌɨ yà, làfa ꞌɨ yà, kó ngalè kɨ́tá agá lésè dhɨ nɨ àzya ꞌɨ yà dhɨ àmɨ rú ko. ");
INSERT INTO log_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Dzó ángùdhi mɨ̀ dré dra fɨ̀zo lána dhɨ, mɨ̀ kàdré ayílé kònàle tsàle kìtú mɨ̀ dré dra ngàzo bhà nda ꞌásè dhɨ tú. ");
INSERT INTO log_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Bhàandre ángùdhi dra àmɨ kɨ kaꞌìzo dòle lána dóro ko dhɨ na dhɨ, mɨ̀ kòpfò ꞌásà, ɨ̀ndɨ̀ mɨ̀ kòtowá tàpfulɨ́ndrɨ́ àmɨ pásè tadházóá dhɨ, mɨ̀ tayɨ́ àyɨ kɨ tà títí dre.» ");
INSERT INTO log_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Gò Yésu nɨ lebèbhá nda ɨ̀ dré ngàzo adrélé tatsílé bhà àlo àlo ɨ ꞌásè, Rúbí Tanɨ longóbe, ɨ̀ndɨ̀ móndɨ́ kɨ tɨdrɨ́be àrà títí ɨ ꞌásè. ");
INSERT INTO log_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Lókyá nda sè dhɨ, Èródè adrélépi tá ópɨ́ ro bvò Gàlìláyà àdhya drìle dhɨ dré tà títí adrébhá ru ꞌo nda kɨ rúbí yìzo gò, akódhɨ nɨ drì dré adrézó abɨ́lé ásà. Tàko ko, móndɨ́ àruka ɨ̀ adré tá tàá dhɨ, Yòwánɨ̀ Bàtísimò fèlepi angá ɨ́na dràdrà lésè nɨ̀. ");
INSERT INTO log_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Àruka nɨ ɨ̀ adré tá tàá dhɨ, Èlɨ́yà agá móndɨ́ ɨ kandrá nɨ̀. Àruka nɨ ɨ̀ adré kó tá tàá dhɨ, pròfétà atú dhɨ kɨ àlo angá dràdrà lésè nɨ̀. ");
INSERT INTO log_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Dɨ, Èródè dré tàzoá dhɨ: «Áma tàndɨ, má ꞌo Yòwánɨ̀ nɨ drì lìle dhɨ ꞌí. Dɨ dhya má dré adrézó rúbí nɨ nɨ yi kòdhɨ àdhi ꞌɨ?» Gò dré adrézó Yésu nɨ nda nòle. ");
INSERT INTO log_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Àpóstolò Yésu dré tá tibhùle nda ɨ̀ kàgò dre dhɨ, ɨ̀ dré tà títí ɨ̀ dré ꞌòle dhɨ kɨ tɨtɨ́zó drá. Gò akódhɨ dré àyɨ kɨ drìzo lɨ̀zo àyɨ pátí tsàle bhàandre rú zìle Bètèsàyɨ́dà dhɨ na. ");
INSERT INTO log_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Dɨ, móndɨ́ zyandre dhɨ ɨ̀ kòyi tà nda dre dhɨ, ɨ̀ dré ngàzo lɨ̀le akódhɨ vésè. Ɨ̀ kòtsa akódhɨ véna dre dhɨ, dré àyɨ kɨ kaꞌìzo dòle dóro gò, kɨdhózó adrélé Gìká nɨ Òpɨ̀ nɨ tà ta àyɨ dré, adrézó àyɨ adrébhá tá drà ɨ́be dhɨ kɨ tɨdrɨ́. ");
INSERT INTO log_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ɨ̀ndró kàtsá ànyɨ dre dhɨ, akódhɨ nɨ lebèbhá mudrí-drì-rì dhɨ ɨ̀ dré àyɨ kɨ kisízó ànyɨ akódhɨ làga, tàá drá dhɨ: «Àma àrà bhà àko dhɨ ꞌá. Mɨ́ kòfè dɨ láti móndyá zyandre kònɨ ɨ dré lɨ̀zo mányàngá nda àrà ayízó dhɨ ɨ́be, bhà àma làgásè dhɨ ɨ ꞌásè ɨ̀ndɨ̀ gbàbhú ꞌásè.» ");
INSERT INTO log_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Dɨ, Yésu logó àyɨ dré dhɨ: «Àmɨ kɨ tàndɨ, mɨ̀ fè ngá àyɨ dré nyàle dhɨ àmɨ.» Ɨ̀ gò logóá dhɨ: «Àma ngbà ꞌí mápà ɨ́be nzi ɨ̀ndɨ̀ kosyá ɨ́be rì. Mɨ́ adré lèá dhɨ, àma kɨ tàndɨ, mà kòlɨ̀ mányàngá gɨ móndyá zyandre kònɨ ɨ dré títí?» ");
INSERT INTO log_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Àngyá ko, àgo ɨ tá ànyɨ́ànyɨ ngùlù-nzi àrà nda ꞌá.) Dɨ Yésu dré tàzoá áyɨ lebèbhá ɨ dré dhɨ: «Mɨ̀ tukù àyɨ lɨrɨ́lé ngbungbu nyadhɨ-rì-drì-mudrí.» ");
INSERT INTO log_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Dɨ lebèbhá nɨ ɨ̀ dré ꞌòzoá kònɨ̀nɨ gò, móndyá nda ɨ̀ dré lɨrɨ́zó títí. ");
INSERT INTO log_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Dɨ Yésu kàdó mápà nzi nda ɨ kosyá rì nda ɨ́be dre dhɨ, dré mì tɨngázó kurú na bhù na, tà tanɨ zìzo Gìká tí ngá nda ɨ dri. Dré ngá nda kɨ toŋòzo lanzɨ́lé áyɨ lebèbhá ɨ dré, ɨ̀ kòlanzɨ́ró móndyá zyandre nda ɨ dré. ");
INSERT INTO log_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Dɨ àyɨ títí nda ɨ̀ dré nyàzoá pìzo. Gò akódhɨ nɨ lebèbhá ɨ̀ dré àmbí nɨ kɨ lokózó gàle kánzɨ̀ mudrí-drì-rì dhɨ ɨ sè bǐbi. ");
INSERT INTO log_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Kìtú àlo dhɨ, Yésu adré tá tà ta Gìká be kalóma. Akódhɨ nɨ lebèbhá ɨ tá ngbà ꞌí akódhɨ làga àyɨ. Gò dré lizízóá àyɨ tí dhɨ: «Móndɨ́ zyandre dhɨ ɨ̀ adré tàá dhɨ, ma àdhi ꞌɨ?» ");
INSERT INTO log_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ɨ̀ logó drá dhɨ: «Móndɨ́ àruka ɨ̀ adré tàá dhɨ, mɨ Yòwánɨ̀ Bàtísimò fèlepi ꞌɨ. Àruka nɨ ɨ̀ adré tàá dhɨ, mɨ Èlɨ́yà ꞌɨ. Àruka nɨ ɨ̀ adré kó tàá dhɨ, mɨ pròfétà atú dhɨ kɨ àlo angálépi dràdrà lésè dhɨ ꞌɨ.» ");
INSERT INTO log_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Yésu gò lizíá àyɨ tí dhɨ: «Dɨ àmɨ ró dhɨ, mɨ̀ adré àmɨkya tàá dhɨ, ma àdhi ꞌɨ?» Pétèró gò logóá dhɨ: «Mɨ Mèsɨ́yà Gìká dré amùle dhɨ ꞌɨ.» ");
INSERT INTO log_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Gò Yésu dré àyɨ kɨ logázó tà tàndɨ ró, ɨ̀ kòlongóró tà nda dhya àlo dré ko. ");
INSERT INTO log_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Dré tàzoá dhɨ: «Adré lèá dhɨ, Móndɨ́ nɨ Mvá kònya kɨzà lavúlé, ɨ̀ndɨ̀ Yúdà ànzɨ kɨ bhàgo ɨ, kòwánà kàdrɨ̀ ɨ, ɨ̀ndɨ̀ tátrɨ́trɨ́ kúlí tadhábhá ɨ́be dhɨ ɨ̀ kògà akódhɨ rè. Adré kpà lèá dhɨ, à kòpfu akódhɨ dràle gò, kìtú nɨ na sè dhɨ, Gìká kòtɨngáró akódhɨ dràdrà lésè.» ");
INSERT INTO log_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Bvóá dhɨ, Yésu dré tàzoá móndyá títí dhɨ ɨ dré dhɨ: «Dhya àlo kàdré lèá alɨ̀le má vésè dhɨ, lè akódhɨ nda kòtayɨ́ áyɨ tàndɨ nɨ tà, kàdré áyɨ fa kɨpakɨpa adó kìtú àlo àlo títí gò, kàdréró áma lebè. ");
INSERT INTO log_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Tàko ko, dhya ángùdhi adrélépi áyɨ tàndɨ nɨ lɨ́drɨ̀ le tɨdrɨ́lé dhɨ, a nɨ áyɨ lɨ́drɨ̀ nda nɨ ꞌo avɨ̀le. Dɨ, dhya ángùdhi adrélépi ɨ́na áyɨ lɨ́drɨ̀ fe áma tà sè dhɨ, a nɨ áyɨ lɨ́drɨ̀ nda nɨ tɨdrɨ́. ");
INSERT INTO log_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Àngyá ko, dhya àlo kòkisú ngá bvò kòndɨ àdhya ɨ títí gò, áyɨ tàndɨ nɨ tayɨ́zó avɨ̀le dhɨ, akódhɨ nda kisú ɨ́na àdho tà dóro ꞌɨ? ");
INSERT INTO log_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Dhya àlo kàdré kanyò ro áma tà sè ɨ̀ndɨ̀ áma kúlí kɨ tà sè dhɨ, Móndɨ́ nɨ Mvá nɨ kókpà adré kanyò ro akódhɨ nda nɨ tà sè, lókyá ɨ́ dré dra agòzo áyɨ mìlanzìlanzì na, áyɨ Atá nɨ mìlanzìlanzì na, ɨ̀ndɨ̀ ángéló lólo kya na dhɨ tú. ");
INSERT INTO log_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Má adré tà bàti ta àmɨ dré: Móndɨ́ àruka adrébhá àyɨ kɨ totó kònwa nɨ ɨ̀ kɨtswá dràle drìdrì ɨ̀ dré dra Gìká nɨ Òpɨ̀ nòzo dhɨ kandrá ko.» ");
INSERT INTO log_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ànyɨ́ànyɨ kìtú nzi-drì-na kúlí nda ɨ àmvolésè dhɨ, Yésu dré Pétèró kɨ drìzo Yòwánɨ̀ ɨ́be ɨ̀ndɨ̀ Yàkóbhò be, lɨ̀zo àyɨ ɨ́be mbàle kòngó àlo drìna, kɨtswálé tà ta Gìká be. ");
INSERT INTO log_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Dɨ dré adréràꞌa tà ta Gìká be dhɨ ꞌá dhɨ, akódhɨ nɨ mìbhalé nɨ làsú dré ngàzo ru ladzá. Akódhɨ nɨ kɨ́tá ɨ̀ dré kpà atsázó kemve kpɨ́rɨ́kpɨ́rɨ́ lagulagu ró. ");
INSERT INTO log_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Gbǎ kòdhwa, àgo rì, Mósè ɨ Èlɨ́yà be dhɨ ɨ̀ dré agázó làsú be lagulagu ró àyɨ kandrá, adrélé tà ta Yésu be. Ɨ̀ adré tá Yésu nɨ àzí lɨ̀zo dràle Yèrúsalémà na dhɨ nɨ akɨ́ ngɨ́nɨ ya dhɨ nɨ tà ta. ");
INSERT INTO log_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pétèró ɨ arúpi nɨ ɨ́be dhɨ kɨ mì adré tá ayí ro. Dɨ ɨ̀ kòlaró dre dhɨ, ɨ̀ dré Yésu nɨ nòzo lagulagu ró túmä́ní àgo rì adrébhá àyɨ kɨ totó akódhɨ làga nda ɨ́be. ");
INSERT INTO log_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Àgo nda ɨ̀ dré tá adréràꞌa ꞌòle Yésu nɨ tayɨ́ dhɨ ꞌá dhɨ, Pétèró dré tàzoá drá dhɨ: «Mírì, dóro nɨ mà dré adrélé kònwa dhɨ. Mà kòledé wémà na dhɨ ɨ kònwa: àlo nɨ mɨ́ dré, àlo nɨ Mósè dré, ɨ̀ndɨ̀ àlo nɨ Èlɨ́yà dré.» (Akódhɨ nì tá tà ɨ́ dré adrélé tàle dhɨ ko.) ");
INSERT INTO log_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Dré rè dhu adréràꞌa tà ta dhɨ ꞌá dhɨ, ndùrùku dré apfòzo àyɨ kɨ asó rùkù. Dɨ Yésu nɨ lebèbhá nda ɨ̀ dré tá adréràꞌa fɨ̀le ndùrùku nda na dhɨ ꞌá dhɨ, tirì dré àyɨ kɨ ꞌòzo. ");
INSERT INTO log_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Gò kúlí dré apfòzo ndùrùku nda lésè tàá dhɨ: «Kònɨ̀dhɨ áma Mváagó má dré zɨ̀le dhɨ ꞌɨ. Mɨ̀ kòyi akódhɨ!» ");
INSERT INTO log_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","À kòtà tà nda dre dhɨ, ɨ̀ dré nòzoá dhɨ, Yésu tá ɨ́na kalóma. Gò akódhɨ nɨ lebèbhá nda ɨ̀ dré tà nda kɨ zùzo tayɨ́lé àyɨ léna. Lókyá nda sè dhɨ, ɨ̀ tɨtɨ́ tá tà ɨ̀ dré nòle nda ɨ dhya àlo dré ko. ");
INSERT INTO log_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kìtú bvóá dhɨ sè, Yésu ɨ̀ kàsí kòngó nda drìlésè lebèbhá nɨ ɨ́be dre dhɨ, móndɨ́ zyandre lavúlé dhɨ ɨ̀ dré alɨ̀zo ru kisú akódhɨ be. ");
INSERT INTO log_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Gò agó àlo móndyá zyandre nda ɨ kòfalé dhɨ dré ngàzo kúlí yo tàzoá dhɨ: «Tadhálépi, má adré ámɨ ti lizí, mɨ́ kòbheró mì áma mváagó véna. Tàko ko, akódhɨ áma mvá àlo kwákwá dhɨ ꞌɨ. ");
INSERT INTO log_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Tɨrɨ́ kònzɨ àlo dhɨ adré akódhɨ nɨ ru rä gò, dré adrézó trèle ngbǒ ró. Tɨrɨ́ nda dré adrézó akódhɨ nɨ kɨzɨ́ rìnyí sè gò, kápfùtrá dré adrézó apfòle sílásà. Adré ngbà ꞌí akódhɨ nɨ tayɨ́ lókyá tsà gò, gòzo adrélé akódhɨ nɨ ató ɨ́ pálé. ");
INSERT INTO log_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Má lizí tá ámɨ lebèbhá kɨ ti, ɨ̀ kòdroró tɨrɨ́ nda ká. Dɨ, ɨ̀ kɨtswá tá àyɨkya bwà ko.» ");
INSERT INTO log_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Dɨ Yésu logó dhɨ: «Àmɨ, móndyá ándrò tà kaꞌìkaꞌì àko ɨ̀ndɨ̀ àmɨ kɨ tayɨ́bhá lɨtɨ́lé nɨ ɨ, mà nɨ adré vélé àmɨ ɨ́be vwàle lókyá be ángopɨ́? Má nɨ àmɨ kɨ tà mvo vwàle lókyá be ángopɨ́? Mɨ́ adrì ámɨ mvá nda alɨ̀zo ába má vélé.» ");
INSERT INTO log_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Mvámvá nda dré tá adréràꞌa alɨ̀le Yésu vélé dhɨ ꞌá dhɨ, tɨrɨ́ kònzɨ nda dré akódhɨ nɨ bhèzo kìní mi gò, kɨzɨ́zóá rìnyí sè. Dɨ, Yésu dré ɨ́na lɨgɨ́zó tɨrɨ́ kònzɨ nda be, mvámvá nda nɨ tɨdrɨ́zó gò, logózóá atá nɨ véna. ");
INSERT INTO log_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Dɨ móndyá títí nda kɨ lɨ́ndrɨ́ dré gàzo bhwǎbhwa Gìká nɨ tà kàdrɨ̀ sè. Móndyá títí nda ɨ̀ dré tá adréràꞌa síbhálé be ngbo tà títí Yésu dré adrélé ꞌòle dhɨ kɨ tà sè dhɨ ꞌá dhɨ, dré tàzoá áyɨ lebèbhá ɨ dré dhɨ: ");
INSERT INTO log_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Mɨ̀ kòyi tà má dré adrélé tàle àmɨ dré kònɨ̀dhɨ dóro: À nɨ Móndɨ́ nɨ Mvá nɨ lefè kàrɨbhá ɨ drɨ́gá.» ");
INSERT INTO log_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Dɨ, kúlí nda fɨ tá ɨ́na àyɨ drìna ko. Àndu nɨ zù tá ɨ zùzù àyɨ dré, ɨ̀ kòkɨtswáró nìá bwà ko. Ɨ̀ adré tá kpà ngá ro tà nda nɨ lizima Yésu tí dhɨ sè. ");
INSERT INTO log_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Àmvolásà dhɨ, Yésu nɨ lebèbhá ɨ̀ dré dhèzo adrélé tà kayí àyɨ kòfalésè, nìzoá ngalè dhya kàdrɨ̀ lavúlé àyɨ kòfalé dhɨ àdhi ꞌɨ ya dhɨ. ");
INSERT INTO log_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yésu dré tà ɨ̀ dré adrélé kisùle nda nɨ nìzo kyá gò, mvámvá àlo dhɨ nɨ adózó bhàle ɨ́ làga, ");
INSERT INTO log_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","tàzoá àyɨ dré dhɨ: «Dhya ángùdhi adrélépi mvámvá kònɨ̀dhɨ tɨ́nɨ dhɨ nɨ kaꞌì dòle dóro áma rú sè dhɨ, adré áma tàndɨ nɨ kaꞌì kòdhya. Dhya ángùdhi adrélépi áma kaꞌì dòle dóro dhɨ, adré dhya áma amùlepi dhɨ nɨ kaꞌì kòdhya. Tàko ko, dhya tàko lavúlé àmɨ títí ɨ kòfalé dhɨ ɨ́na dhya kàdrɨ̀ lavúlé dhɨ ꞌɨ.» ");
INSERT INTO log_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Gò Yòwánɨ̀ dré tàzoá Yésu dré dhɨ: «Mírì, mà nò tá agó àlo dhɨ adréràꞌa tɨrɨ́ kònzɨ kɨ dro ámɨ rú sè. Dɨ mà dré akódhɨ nda nɨ logázó, dré tá adrélé àma kɨ àlo ꞌɨ ko dhɨ sè.» ");
INSERT INTO log_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Dɨ, Yésu logó drá dhɨ: «Mɨ̀ logá akódhɨ ko. Àngyá ko, dhya ángùdhi adrélépi ru pfu àmɨ ɨ́be ko dhɨ, àmɨ kɨ àlo ꞌɨ.» ");
INSERT INTO log_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Lókyá Yésu nɨ dòzo bhù na dhɨ kàtsá ànyɨ dre dhɨ, akódhɨ dré ɨ́na togó tsɨ̀zo lɨ̀zo Yèrúsalémà na. ");
INSERT INTO log_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Dɨ dré móndɨ́ kɨ mùzo lɨ̀le drìdrì ɨ́ kandrána gò, ɨ̀ dré lɨ̀zo tsàle bhà àlo Sàmàrɨ́yà kya na kɨtswálé àrà ledé akódhɨ dré. ");
INSERT INTO log_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Dɨ, móndyá kònàle dhɨ ɨ̀ dré àyɨkya akódhɨ nɨ kaꞌìma gàzo rè, dré tá adrélé lɨ̀le Yèrúsalémà na dhɨ sè. ");
INSERT INTO log_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Akódhɨ nɨ lebèbhá, Yàkóbhò ɨ Yòwánɨ̀ be dhɨ ɨ̀ kònò tà nda dre dhɨ, ɨ̀ dré tàzoá dhɨ: «Mírì, mɨ́ adré lèá dhɨ, mà kàzí àtsɨ́ asílé bhù lésè, àyɨ kɨ za vèle nyɨ̌nyɨ?» ");
INSERT INTO log_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Dɨ, Yésu dré ɨ́na áyɨ alázó, lawàle àyɨ dri. ");
INSERT INTO log_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Gò ɨ̀ dré lɨ̀zo bhà àzya na. ");
INSERT INTO log_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ɨ̀ dré tá adréràꞌa lavúlé láti ꞌásè dhɨ ꞌá dhɨ, agó àlo dhɨ dré tàzoá Yésu dré dhɨ: «Má nɨ ámɨ lebè àrà títí ángùdhi mɨ́ dré adrézó lɨ̀le dhɨ ɨ ꞌásè.» ");
INSERT INTO log_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yésu logó drá dhɨ: «Kɨ̀lɨ̀wá ɨ àyɨ kɨ bhú ɨ́be. Àrɨ́ ɨ kpà àyɨ kɨ bhà ɨ́be. Dɨ, Móndɨ́ nɨ Mvá ɨ́na àrà dré kɨtswázó áyɨ drì la lovózó dhɨ àko.» ");
INSERT INTO log_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Gò Yésu dré tàzoá agó àzya dré dhɨ: «Mɨ́ lebè ma.» Dɨ, agó nda tà drá dhɨ: «Mírì, mɨ́ kòtayɨ́ rè zyà ma lɨ̀le áma atá nɨ si ꞌíká.» ");
INSERT INTO log_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yésu logó drá dhɨ: «Mɨ́ tayɨ́ móndɨ́ dràbhá dre dhɨ ɨ àyɨ kɨ àbvò kɨ si. Dɨ, mɨ ró dhɨ, mɨ́ lɨ̀ mɨ́na Gìká nɨ Òpɨ̀ nɨ tà longóbe.» ");
INSERT INTO log_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Gò agó àzya dhɨ dré tàzoá dhɨ: «Mírì, má nɨ ámɨ lebè. Dɨ, mɨ́ kòtayɨ́ rè zyà ma lɨ̀le lazílé bhà na ꞌíká.» ");
INSERT INTO log_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Dɨ, Yésu logó drá dhɨ: «Dhya ángùdhi kɨbhó dòlepi kɨtswázó amvú ꞌa gò, gòzo áyɨ alá ngá no ɨ́ àmvolé dhɨ kɨtswá ɨ́na Gìká nɨ Òpɨ̀ sè ko.» ");
INSERT INTO log_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Àmvolásà dhɨ, Mírì Yésu dré áyɨ lebèbhá àruka nyadhɨ-na-drì-mudrí-drì-rì dhɨ kɨ kɨpèzo gò, àyɨ kɨ tibhùzo lɨ̀le rì rì drìdrì ɨ́ kandrána bhàandre wä́yi, ɨ̀ndɨ̀ àrà wä́yi ɨ́ dré tá adrézó ꞌòle lɨ̀le dhɨ ɨ ꞌásè. ");
INSERT INTO log_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Dré tá adréràꞌa àyɨ kɨ tibhù dhɨ ꞌá dhɨ, tà àyɨ dré dhɨ: «Lànyá ka amvú na lavúlé dre. Dɨ, àzibhá adrébhá lànyá nda nɨ lokó dhɨ kɨ àbvò yókódhó. Mɨ̀ kàdré dɨ lànyá nda nɨ líyí nɨ ti lizí, kòmùró àzibhá ɨ lɨ̀le áyɨ lànyá lokó be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Mɨ̀ lɨ̀! Mɨ̀ nò rè ká! Má adré àmɨ kɨ mu ngóró kábilígyà ànzɨ ɨ tɨ́nɨ trú kàlagɨ́ ɨ kòfalé. ");
INSERT INTO log_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mɨ̀ kòdo làfa ꞌɨ yà, kòmvò ꞌɨ yà, kó ngalè kámókà àzya ꞌɨ yà dhɨ atsí sè ko. Láti bhálésè dhɨ, mɨ̀ kòfè mòdo dhya àlo dré ko. ");
INSERT INTO log_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Dzó ángùdhi mɨ̀ dré dra fɨ̀zo lána dhɨ na dhɨ, mɨ̀ kòtà rè zyà dhɨ: ‹Tà kɨ̀drɨ́kɨ̀drɨ kàdré dzó kònɨ̀dhɨ ꞌá.› ");
INSERT INTO log_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Dhya àlo adrélépi tròle tà kɨ̀drɨ́kɨ̀drɨ rú dhɨ kàdré kònàle be dhɨ, tà kɨ̀drɨ́kɨ̀drɨ mɨ̀ dré zìle nda nɨ adré akódhɨ dri. Dɨ, dhya kònɨ̀nɨ dhɨ kàdré yó dhɨ, tà kɨ̀drɨ́kɨ̀drɨ nda nɨ agò àmɨ vélé. ");
INSERT INTO log_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Mɨ̀ kàdré ayílé dzó nda na, adrélé ngá ɨ̀ dré dra fèle àmɨ dré dhɨ kɨ nya ɨ̀ndɨ̀ mvùá. Tàko ko, adré lèá dhɨ, dhya àzí ꞌòlepi dhɨ kònya áyɨ landè. Dɨ mɨ̀ kòlavú dzó àlo àlo ɨ ꞌásè, àrà ayízó dhɨ kɨ ndabe ko. ");
INSERT INTO log_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Bhàandre ángùdhi móndyá lána dhɨ ɨ̀ dré dra àmɨ kɨ kaꞌìzo dòle dóro dhɨ na dhɨ, mɨ̀ kàdré ngá ɨ̀ dré dra bhàle àmɨ kandrá dhɨ kɨ nya. ");
INSERT INTO log_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Mɨ̀ kàdré dràbhá kònàle dhɨ kɨ tɨdrɨ́, adrézó tàá móndyá nda ɨ dré dhɨ: ‹Gìká nɨ Òpɨ̀ atsá ànyɨ àmɨ kòfalé dre.› ");
INSERT INTO log_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Dɨ, bhàandre ángùdhi mɨ̀ dré dra fɨ̀zo lána gò, àmɨ kɨ kaꞌìzo dòle dóro ko dhɨ na dhɨ, mɨ̀ kòpfò bhà nda nɨ láti andre bhálé, tàá àyɨ dré dhɨ: ");
INSERT INTO log_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‹Mà adré ndɨ̀ndɨ̀ àmɨ kɨ bhàandre nɨ tàpfulɨ́ndrɨ́ tròlepi àma pá dhɨ nɨ towá tadházóá dhɨ, mà tayɨ́ àmɨ kɨ tà títí dre. Dɨ, lè mɨ̀ kònì tàle dhɨ, Gìká nɨ Òpɨ̀ atsá ànyɨ dre.› ");
INSERT INTO log_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Má adré tàá àmɨ dré dhɨ: Kìtú Gìká dré dra tàbvó tàzo dhɨ tú dhɨ, a nɨ tà ŋo móndyá bhàandre nda lésè dhɨ ɨ dri, móndyá Sòdómà lésè dhɨ kya kɨ lavú.» ");
INSERT INTO log_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Yésu gò tàá dhɨ: «Kɨzà àmɨ kɨ ngá ꞌɨ, àmɨ Kòràzínàbhá ro nɨ ɨ! Kɨzà kpà àmɨ kɨ ngá ꞌɨ, àmɨ Bètèsàyɨ́dàbhá ro nɨ ɨ! Àngyá ko, má kòꞌo tá tà lɨ́ndrɨ́ga ró má dré ꞌòle àmɨ véna dhɨ ɨ Tírè na ɨ̀ndɨ̀ Sìdónà na dhɨ, kònò móndyá bhàandre nda ɨ ꞌásè dhɨ ɨ̀ asó tá kɨ́tá lirí àyɨ rú kɨ́nó, lɨrɨ́zó àyɨ kɨ drì pfo tópfó sè tadházóá dhɨ, ɨ̀ ladzá àyɨ kɨ togó káyà dhɨ dre. ");
INSERT INTO log_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ásà dhɨ, kìtú Gìká dré dra tàbvó tàzo dhɨ tú dhɨ, a nɨ tà ŋo àmɨ dri móndyá Tírè ɨ lésè Sìdónà be dhɨ kya kɨ lavú. ");
INSERT INTO log_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Dɨ àmɨ Kàpàrànàwúmàbhá ro nɨ ɨ, mɨ̀ adré tsì kisùá dhɨ, Gìká nɨ àmɨ kɨ tà tɨngá tsàle byá kurú na bhù na bàti? Tàdzí ko! A nɨ àmɨ kɨ tà tɨrɨ́ tsàle byá móndyá dràbhá dre dhɨ kɨ àrà na.» ");
INSERT INTO log_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yésu gò tàá áyɨ lebèbhá ɨ dré dhɨ: «Dhya ángùdhi adrélépi àmɨ kɨ kúlí yi dhɨ, adré áma kúlí yi kòdhya. Dhya ángùdhi adrélépi àmɨ kɨ ga dhɨ, adré áma ga kòdhya. Dhya ángùdhi adrélépi áma ga dhɨ, adré dhya áma amùlepi dhɨ nɨ ga kòdhya.» ");
INSERT INTO log_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Àmvolásà dhɨ, móndyá nyadhɨ-na-drì-mudrí-drì-rì nda ɨ̀ dré agòzo arɨ́ be Yésu vélé, tàá dhɨ: «Mírì, ndɨ̀ndɨ̀ tɨrɨ́ kònzɨ ɨ̀ adré tà mà dré adrélé tàle àyɨ dri ámɨ rú sè dhɨ kɨ ꞌo, adrézó àyɨ kɨ bha àma zàle.» ");
INSERT INTO log_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Dɨ Yésu logó àyɨ dré dhɨ: «Má nò Sàtánà adhéràꞌa bhù lésè ngóró bhù lagulagu tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Mɨ̀ yi rè ká! Má fè rìnyí àmɨ dré kɨtswázó nì kɨ ató dàpáyà ɨ́be, ɨ̀ndɨ̀ kɨtswázó àmɨ kɨ kàrɨbhá, Sàtánà nɨ rìnyí wä́yi dhɨ nɨ lavú. Dɨ tà àlo kɨtswá gòle àmɨ kɨ ꞌo kònzɨ ko. ");
INSERT INTO log_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Dɨ, tágba dré adrézó kònɨ̀nɨ dhɨ, mɨ̀ kòlenzé tɨrɨ́ kònzɨ ɨ̀ dré adrélé àyɨ kɨ bha àmɨ zàle dhɨ sè ko. Be ró dhɨ, mɨ̀ kàdré àmɨkya lenzélé Gìká dré àmɨ kɨ rú tɨsɨ̀le bhù na dhɨ sè.» ");
INSERT INTO log_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Lókyá nda sè dhɨ, Yésu gàlepi Tɨrɨ́ Lólo nɨ arɨ́ sè bǐ dhɨ dré tàzoá dhɨ: «Á! Tátá, Mírì bhù kya bvò be nɨ, má adré àwoyà ta mɨ́ dré, mɨ́ dré tà kòdhɨ kɨ zùle tògyabhá ɨ dré ɨ̀ndɨ̀ móndyá tà nibhá ɨ dré gò, tà nda kɨ tadházó ànzɨmvá ɨ dré dhɨ sè. Àyíya, Tátá, tàko ko, tà mɨ́ dré ꞌòle nda tá dóro mɨ́ mìlésè. ");
INSERT INTO log_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Áma Atá tayɨ́ tà títí dhɨ ɨ má drɨ́gá dre. Dhya àlo nìlepi Gìká nɨ Mváagó àdhi ꞌɨ ya dhɨ yókódhó, ngbà ꞌí Gìká Atá nì nɨ̀. Dhya àlo nìlepi Gìká Atá àdhi ꞌɨ ya dhɨ kpà yókódhó. Ngbà ꞌí akódhɨ nɨ Mváagó nì nɨ̀, ɨ̀ndɨ̀ dhya Mváagó nda dré adrézó áyɨ Atá nɨ le tadhálé àyɨ dré dhɨ ɨ̀ nì àyɨ.» ");
INSERT INTO log_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Gò Yésu dré áyɨ alázó tàá ngbà ꞌí áyɨ lebèbhá ɨ dré dhɨ: «Kólénzé àmɨ adrébhá tà mɨ̀ dré adrélé nòle dhɨ kɨ no nɨ ɨ dré! ");
INSERT INTO log_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Àngyá ko, má adré tàá àmɨ dré dhɨ: Pròfétà bǐ dhɨ ɨ ópɨ́ bǐ dhɨ ɨ́be dhɨ ɨ̀ lè tá tà mɨ̀ dré adrélé nòle dhɨ kɨ nòle tò gò, ɨ̀ dré àyɨkya nòzoá ko. Ɨ̀ lè tá kpà tà mɨ̀ dré adrélé yìle dhɨ kɨ yìle tò gò, ɨ̀ dré àyɨkya yìzoá ko.» ");
INSERT INTO log_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Àmvolásà dhɨ, dhya àlo Mósè nɨ tátrɨ́trɨ́ kúlí nìlepi dóro lavúlé dhɨ dré alɨ̀zo tà kònɨ̀dhɨ nɨ lizí Yésu tí, kɨtswázó akódhɨ nɨ tabhì: «Tadhálépi, lè má kòꞌo àdho tà kòdhya kɨtswázó lɨ́drɨ̀ kóná vésè kólyá dhɨ nɨ kisú dhɨ?» ");
INSERT INTO log_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yésu logó drá dhɨ: «Mósè nɨ tátrɨ́trɨ́ kúlí adré tàá ngɨ́nɨ? Mɨ́ adré tátrɨ́trɨ́ kúlí nda nɨ na ngɨ́nɨ?» ");
INSERT INTO log_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Dɨ tátrɨ́trɨ́ kúlí tadhálépi nda logó dhɨ: «Lè mɨ́ kàdré Mírì ámɨ Gìká nɨ le ámɨ togó sè wä́yi, ámɨ lɨ́drɨ̀ sè wä́yi, ámɨ rìnyí sè wä́yi, ɨ̀ndɨ̀ ámɨ tà kisùkisù sè wä́yi. Lè kpà mɨ́ kàdré ámɨ àzya nɨ le ngóró mɨ́ dré adrélé ámɨ tàndɨ nɨ le dhɨ tɨ́nɨ.» ");
INSERT INTO log_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yésu gò tàá drá dhɨ: «Mɨ́ logó kyá. Mɨ́ kòꞌo kònɨ̀nɨ dhɨ, mɨ́ nɨ lɨ́drɨ̀ nda nɨ kisú.» ");
INSERT INTO log_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Dɨ, tátrɨ́trɨ́ kúlí tadhálépi nda lè tá ɨ́na áyɨ bhàle adrélé gyǎgya gò, dré lizízóá Yésu tí dhɨ: «Áma àzya nda ɨ́na àdhi ꞌɨ?» ");
INSERT INTO log_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yésu gò logóá dhɨ: «Kìtú àlo dhɨ, agó àlo dhɨ adré tá sìle Yèrúsalémà lésè lɨ̀le Yèríkò na gò, dré tsàzo fɨ̀le trú kùgubhá ɨ kòfalé. Ɨ̀ dré akódhɨ nɨ ngá wä́yi dhɨ kɨ topázó, akódhɨ nɨ bhwàzo gò, tayɨ́zóá ànyɨ́ànyɨ dràdrà mìle. ");
INSERT INTO log_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Kòwánà àlo dhɨ adré tá kpà asílé láti nda ꞌásè bágɨ́ ro. Kònò agó nda dre dhɨ, dré ɨ́na ngá kɨ̀zo làgásà gò lɨ̀zo. ");
INSERT INTO log_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Bvóá dhɨ, agó àlo Lévì nɨ súrú lésè dhɨ dré kpà atsázó agó nda nɨ no gò, dré kpà ngá kɨ̀zo làgásà gò lɨ̀zo. ");
INSERT INTO log_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Dɨ, Sàmàrɨ́yà agó àlo dhɨ adré tá kpà asílé láti nda ꞌásè gò, dré atsázó àrà nda ꞌá. Kònò agó nda dre dhɨ, dré ɨ́na kɨzà dòzo áyɨ togó na akódhɨ nɨ tà sè. ");
INSERT INTO log_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Dré áyɨ kisízó ànyɨ akódhɨ làga, dò kɨ da vínò be akódhɨ nɨ làzɨ́ ɨ mi gò, làzɨ́ nda kɨ lambézó. Dré akódhɨ nɨ dòzo bhàle áyɨ tàndɨ nɨ púndà dri, lɨ̀zo ába tsàle kùmú kɨ dzó na gò, akódhɨ nɨ limvùzo kònàle. ");
INSERT INTO log_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Kìtú bvóá dhɨ sè dhɨ, dré làfa lòꞌwa rì dhɨ kɨ adózó fèle dzó nda nɨ líyí dré, tàzoá dhɨ: ‹Mɨ́ kòlɨkɨ́ agó kònɨ̀dhɨ dóro. Làfa ángopɨ́ ya mɨ́ dré dra kɨzálé làfa kòndɨ dri akódhɨ nɨ tà sè dhɨ, má nɨ mána logóá mɨ́ dré, má dré dra agǒràꞌa kònwásè dhɨ ꞌá.›» ");
INSERT INTO log_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Gò Yésu dré tátrɨ́trɨ́ kúlí tadhálépi nda nɨ lizízó tàzoá dhɨ: «Mɨ́ mìlésè dhɨ, dhya na nda ɨ kòfalé dhɨ, dhya ángùdhi atsá ɨ́na agó fɨ̀lepi trú kùgubhá ɨ kòfalé nda nɨ arúpi ró nɨ̀?» ");
INSERT INTO log_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Dɨ tátrɨ́trɨ́ kúlí tadhálépi nda logó dhɨ: «Dhya akódhɨ nɨ kɨzà bhàlepi dhɨ ꞌɨ.» Dɨ Yésu tà drá dhɨ: «Mɨ́ lɨ̀, mɨ́ kàdréró kókpà ꞌòá kònɨ̀nɨ.» ");
INSERT INTO log_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yésu ɨ̀ dré tá adréràꞌa lɨ̀le lebèbhá nɨ ɨ́be láti ꞌásè dhɨ ꞌá dhɨ, ɨ̀ dré tsàzo bhà àlo na gò, tòkó àlo rú be Màrátà dhɨ dré akódhɨ nɨ kaꞌìzo dòle dóro ɨ́ bhàna. ");
INSERT INTO log_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mírì kòfɨ dzó nda na dre dhɨ, tòkó nda nɨ amvúpi rú be Màrɨ́yà dhɨ dré lɨrɨ́zó akódhɨ nɨ pá làga, adrélé akódhɨ nɨ kúlí yi. ");
INSERT INTO log_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Dɨ, Màrátà adré tá ɨ́na landúlé àzí wä́yi dré adrélé ꞌòle mányàngá tà sè dhɨ ɨ sè. Dré áyɨ kisízó ànyɨ Yésu làga tàá drá dhɨ: «Mírì, áma amvúpi dré áma tayɨ́lé adrélé àzí wä́yi dhɨ kɨ ꞌo kalóma nɨ, tà nda tà tàko ꞌɨ mɨ́ mìlésè? Mɨ́ kòtà dɨ drá dhɨ, kàlɨ̀ drɨ́gá bha má vélé wà.» ");
INSERT INTO log_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Dɨ, Mírì logó drá dhɨ: «Màrátà, Màrátà, mɨ́ adré mɨ́na ámɨ togó bha lanzìle, adrézó kpà bhàá kuru tà bǐ dhɨ ɨ sè. ");
INSERT INTO log_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Dɨ, tà kɨtswálépi à kòꞌo dhɨ ngbà ꞌí àlo kwákwá. Màrɨ́yà kɨpè ɨ́na tà dóro lavúlé dhɨ kòdhya. À kɨtswá kpà tà nda nɨ tɨngá vélásà bwà ko.» ");
INSERT INTO log_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Kìtú àlo dhɨ, Yésu adré tá tà zi Gìká tí àrà àlo dhɨ na. Kòzi tà akɨ́lé dre dhɨ, akódhɨ nɨ lebèbhá kɨ àlo dré tàzoá drá dhɨ: «Mírì, mɨ́ kòtadhá àma dré tà zìma Gìká tí dhɨ, ngóró Yòwánɨ̀ dré tadhálé áyɨ lebèbhá ɨ dré dhɨ tɨ́nɨ.» ");
INSERT INTO log_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Dɨ Yésu tà àyɨ dré dhɨ: «Mɨ̀ dré adréràꞌa tà zi Gìká tí dhɨ ꞌá dhɨ, mɨ̀ kàdré tàá dhɨ: ‹Àma kɨ Atá, lè móndyá wä́yi dhɨ ɨ̀ kònì dhɨ, mɨ Gìká lólo ꞌɨ dhɨ be. Ámɨ Òpɨ̀ kàtsá móndyá wä́yi ɨ kòfalé wà. ");
INSERT INTO log_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Mɨ́ kàfè àma dré mápà kɨtswálépi àma sè kìtú àlo àlo títí ɨ sè dhɨ wà. ");
INSERT INTO log_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Mɨ́ kòtrì àma kɨ tàkonzɨ̀ ɨ. Tàko ko, àma kɨ tàndɨ mà adré kpà móndyá wä́yi adrébhá tàkonzɨ̀ ꞌo àma rú dhɨ kya kɨ tri. Mɨ́ kòtayɨ́ àma tà dré tabhìle, àma kɨ ꞌòzo dhèle tàkonzɨ̀ na dhɨ ko.›» ");
INSERT INTO log_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yésu gò tàá àyɨ dré dhɨ: «Àruka nɨ, dhya àlo àmɨ kòfalé dhɨ nɨ kɨtswá lɨ̀le áyɨ arúpi véna ngátsi kɨ́tógá sè, tàá drá dhɨ: ‹Áma arúpi, mɨ́ afè má dré mápà na. ");
INSERT INTO log_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Àngyá ko, áma arúpi àlo dhɨ alɨ̀ làwú làvo lésè atsálé má vélé. Dɨ, ma ngá àlo má dré kɨtswálé fèle drá dhɨ àko.› ");
INSERT INTO log_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Dɨ akódhɨ nɨ arúpi dzó nda lé dhɨ nɨ go logóá drá dhɨ: ‹Mɨ́ lagù ma ko. Má asé dzóti dre. Àma áma ànzɨ ɨ́be dhɨ, mà ayí dre. Má kɨtswá ngàle ngá fe mɨ́ dré bwà ko.› ");
INSERT INTO log_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Dɨ, má adré mána tàá àmɨ dré dhɨ: Gba dhya dzó nda lé nda kàdré ngàle ngá fe akódhɨ dré, dré adrélé áyɨ arúpi ꞌɨ dhɨ sè ko yà dhɨ, a nɨ nga ngá títí dré adrélé lèle dhɨ kɨ fe drá, dré adrélé zìá landè àko ró dhɨ sè. ");
INSERT INTO log_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Má adré dɨ tàá àmɨ dré dhɨ: Mɨ̀ kàdré tà zi Gìká tí gò, kòꞌoró tà nda àmɨ dré. Mɨ̀ kàdré ngá nda gò, mɨ̀ kòkisúró. Mɨ̀ kàdré dzóti ga gò, à kònzìró àmɨ dré. ");
INSERT INTO log_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Tàko ko, dhya ángùdhi adrélépi tà zi Gìká tí dhɨ adré kisúá. Dhya adrélépi ngá nda dhɨ adré kisúá. Dhya adrélépi dzóti ga dhɨ dré dhɨ, à adré kpà nzìá. ");
INSERT INTO log_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Àmɨ ànzɨ kɨ atá ro nɨ ɨ, àmɨ kɨ mvá kàdré kosyá zi àmɨ tí dhɨ, mɨ̀ nɨ tsì nì fe drá kòdhya? ");
INSERT INTO log_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Kó ngalè, àmɨ kɨ mvá kàdré tàꞌú bhú zi àmɨ tí dhɨ, mɨ̀ nɨ tsì dàpáyà fe drá kòdhya? ");
INSERT INTO log_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Dɨ àmɨ móndɨ́ kònzɨ ró nɨ ɨ, mɨ̀ kònì adrélé ngá dóro fe àmɨ kɨ ànzɨmvá ɨ dré dhɨ be dhɨ, àmɨ kɨ Atá bhù na dhɨ nɨ Tɨrɨ́ Lólo fe dhya adrébhá zìá ɨ́ tí dhɨ ɨ dré tà tàndɨ ró!» ");
INSERT INTO log_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Kìtú àlo dhɨ, Yésu adré tá tɨrɨ́ kònzɨ dro agó àlo ábhä́bhä́ ro dhɨ lésè. Tɨrɨ́ kònzɨ nda kòpfò lásà dre dhɨ, ábhä́bhä́ nda dré kɨdhózó adrélé kúlí ta gò, móndɨ́ zyandre kònàle dhɨ kɨ lɨ́ndrɨ́ dré gàzo bhwǎbhwa. ");
INSERT INTO log_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Dɨ, àyɨ kɨ àrukabhá ɨ̀ dré àyɨkya tàzoá dhɨ: «Dhya kòdhɨ adré tɨrɨ́ kònzɨ kɨ dro topfòle móndɨ́ ɨ lésè, Bèlèzèbúlè, tɨrɨ́ kònzɨ kɨ kàdrɨ̀ nɨ rìnyí sè.» ");
INSERT INTO log_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Àyɨ kɨ àruka ɨ̀ adré tá akódhɨ nɨ le tabhìle gò, ɨ̀ dré akódhɨ nɨ ti lizízó, kòꞌoró tà àlo lɨ́ndrɨ́ga ró angálépi Gìká vélésè dhɨ. ");
INSERT INTO log_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Dɨ, Yésu dré ɨ́na tà ɨ̀ dré adrélé kisùle nda nɨ nìzo kyá gò, tàzoá àyɨ dré dhɨ: «Òpɨ̀ ángùdhi móndyá zàlá dhɨ ɨ̀ dré adrézó ru lanzɨ́ àyɨ kòfalésè dhɨ, òpɨ̀ nda nɨ tà nɨ akɨ́ títí. Dzó ángùdhi móndyá lá dhɨ ɨ̀ dré adrézó ru lanzɨ́ àyɨ kòfalésè dhɨ, dzó nda nɨ arɨ́ nyɨ̌nyɨ. ");
INSERT INTO log_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Kókpà kòdhɨ tɨ́nɨ, móndyá Sàtánà nɨ rìnyí zàle dhɨ ɨ̀ kàdré ru lanzɨ́ àyɨ kòfalésè dhɨ, akódhɨ nɨ òpɨ̀ nɨ kɨtswá áyɨ totó ngɨ́nɨngɨ́nɨ ró? Má adré tà kòdhɨ nɨ ta, mɨ̀ dré adrélé tàá dhɨ, má adré tɨrɨ́ kònzɨ kɨ dro Bèlèzèbúlè nɨ rìnyí sè dhɨ sè. ");
INSERT INTO log_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Má kàdré mána tɨrɨ́ kònzɨ kɨ dro Bèlèzèbúlè nɨ rìnyí sè dhɨ, àmɨ kɨ lebèbhá ɨ̀ adré dɨ àyɨ kɨ dro àdhi nɨ rìnyí sè? Dɨ ásà dhɨ, àyɨ nda kɨ tà mɨ̀ dré adrélé tàle nda kɨ bvó ta àyɨ. ");
INSERT INTO log_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Dɨ, má kàdré mána tɨrɨ́ kònzɨ kɨ dro Gìká nɨ tàndɨ nɨ rìnyí sè dhɨ, kòdhɨ adré tadhá dhɨ, Gìká nɨ Òpɨ̀ atsá àmɨ kòfalé dre káyà dhɨ. ");
INSERT INTO log_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Agó kòmbá àlo àdzú ngá ɨ́be bǐ dhɨ kàdré áyɨ dzó lɨkɨ́ dhɨ, akódhɨ nɨ ngá títí dhɨ ɨ lɨ́ná. ");
INSERT INTO log_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Dɨ, dhya àzya rìnyi ró akódhɨ nɨ lavúlépi dhɨ kàtsá àdzú bhu akódhɨ be gò, lavúzóá dhɨ, dhya nda nɨ akódhɨ nɨ àdzú ngá dré áyɨ togó bhàzo drìá dhɨ kɨ tɨngá, akódhɨ nɨ ngá títí dhɨ kɨ topázó lanzɨ́lé. ");
INSERT INTO log_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Dhya ángùdhi adrélépi túmä́ní má be ko dhɨ, adré ɨ́na ru pfu má be. Dhya adrélépi móndɨ́ kɨ kɨmó túmä́ní má be ko dhɨ, adré ɨ́na àyɨ kɨ lapé.» ");
INSERT INTO log_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Yésu gò tàá dhɨ: «Tɨrɨ́ kònzɨ àlo dhɨ kòpfò dhya àlo lésè dhɨ, adré anyálé àrà fà ro dhɨ ɨ ꞌásè, àrà ɨ́ dré kɨtswázó lovólé lána dhɨ nɨ ndabe. Dɨ, kòkɨtswá kisúá bwà ko dhɨ, adré tàá dhɨ: ‹Má nɨ go fɨ̀le áma dzó má dré apfòzo lásà dhɨ na.› ");
INSERT INTO log_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Kògò tsàle dre dhɨ, adré kisúá dhɨ, à awá dzó nda nɨ ꞌálé, ngá lána dhɨ kɨ tobhàzo kpǎkpa dre. ");
INSERT INTO log_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Dɨ adré lɨ̀le tɨrɨ́ kònzɨ áyɨ lavúbhá nzi-drì-rì dhɨ kɨ nda lɨ̀zo àyɨ ɨ́be gò, ɨ̀ dré adrézó tɨfɨ́lé adrélé dhya nda léna. Dɨ dhya nda nɨ tà kùdù ro dhɨ vélé kònzɨ wáláká nɨ nɨ lavú.» ");
INSERT INTO log_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yésu dré tá adréràꞌa tà nda kɨ ta dhɨ ꞌá dhɨ, tòkó àlo móndɨ́ zyandre ɨ kòfalé dhɨ dré kúlí yòzo tàzoá drá dhɨ: «Kólénzé tòkó ámɨ todólépi ɨ́ léna gò, bà fèzo mɨ́ dré ndròle dhɨ dré!» ");
INSERT INTO log_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Dɨ, Yésu logó dhɨ: «Lavúlé dhɨ, kólénzé ɨ́na móndyá adrébhá Gìká nɨ kúlí yi gò, ɨ̀ dré adrézó kaꞌìá ꞌòle dhɨ ɨ dré!» ");
INSERT INTO log_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Móndɨ́ zyandre lavúlé dhɨ ɨ̀ dré tá adréràꞌa ru kɨmó Yésu làga dhɨ ꞌá dhɨ, akódhɨ dré ngàzo tàá dhɨ: «Móndyá ándrò kònɨ ɨ kònzɨ. Ɨ̀ adré àyɨkya tà lɨ́ndrɨ́ga ró dhɨ nɨ nda nòle. Dɨ, à kɨtswá tà àzya lɨ́ndrɨ́ga ró dhɨ nɨ ꞌo àyɨ dré nòle dhɨ ko, kàdré ngbà ꞌí pròfétà Yónà àdhya ꞌɨ ko dhɨ. ");
INSERT INTO log_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Tàko ko, ngóró Gìká dré tá áyɨ tà tadhálé Yónà rú Nìnívèbhá ɨ dré dhɨ tɨ́nɨ dhɨ, a nɨ kókpà áyɨ tà tadhá Móndɨ́ nɨ Mvá rú móndyá ándrò nɨ ɨ dré. ");
INSERT INTO log_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Kìtú dra tàbvó tàzo dhɨ tú dhɨ, ópɨ́ kàdrɨ̀ tòko ró bvò tàbhu na dhɨ drìle dhɨ nɨ nga tà bha móndyá ándrò nɨ ɨ dri. Tàko ko, ópɨ́ nda angá tá ɨ́na làwú làvo lésè alɨ̀le ópɨ́ Sòlòmónò nɨ tògyakúlí yi ꞌí. Dɨ mɨ̀ nò rè ká! Dhya kàdrɨ̀ Sòlòmónò nda nɨ lavúlépi dhɨ be kònwárè! ");
INSERT INTO log_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Kòdhɨ ɨ́be dhɨ, kìtú dra tàbvó tàzo dhɨ tú dhɨ, Nìnívèbhá kɨ nga tà bha móndyá ándrò nɨ ɨ dri. Tàko ko, Nìnívèbhá nda ɨ̀ dré tá tà Yónà dré longólé àyɨ dré dhɨ nɨ yìzo dhɨ, ɨ̀ ladzá tá àyɨkya àyɨ kɨ togó ꞌí. Dɨ mɨ̀ nò rè ká! Dhya kàdrɨ̀ Yónà nda nɨ lavúlépi dhɨ be kònwárè!» ");
INSERT INTO log_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","«À dhɨ̀ gà tálà bhàle àrà lùzu ró dhɨ na yà, kó ngalè lɨ̀drɨ́ zàna yà dhɨ ko na. Be ró dhɨ, à adré dhɨ̀á bhàle zá kuru mɨ́sá drìna, kɨtswálé móndyá títí adrébhá afɨ́lé dzó lé dhɨ ɨ̀ kàdréró ngádra no be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ámɨ mì, tálà adrélépi ngádra fe ámɨ rúbhá dré dhɨ ꞌɨ. Ámɨ mì kàdré dóro dhɨ, ámɨ rúbhá wä́yi dhɨ ngádra ꞌá. Dɨ, ámɨ mì kàdré ɨ́na drà ro dhɨ, ámɨ rúbhá wä́yi dhɨ tínímvá na. ");
INSERT INTO log_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Mɨ́ kònò dɨ dóro, ngádra mɨ́ léna dhɨ kàdréró tínímvá ro ko. ");
INSERT INTO log_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Dɨ ásà dhɨ, ámɨ rúbhá wä́yi dhɨ kàdré ngádra ꞌá gò, rúbhá nda nɨ kɨ̀gá àlo dhɨ dré adrézó tínímvá na ko dhɨ, ámɨ rúbhá nda nɨ adré rùkù ngádra kɨ́tó na, ngóró tálà nɨ ngádra dré adrélé ngá kazá mɨ́ dré dhɨ tɨ́nɨ.» ");
INSERT INTO log_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yésu kòtà tà nda ɨ akɨ́lé dre dhɨ, Fàrìsáyò àlo dhɨ dré akódhɨ nɨ zìzo ngá nya ɨ́ bhàna. Yésu dré dɨ lɨ̀zo fɨ̀le dzó nda na gò, lɨrɨ́lé mɨ́sá làga. ");
INSERT INTO log_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Dɨ, Fàrìsáyò nda dré ɨ́na nòzoá dhɨ, Yésu dzɨ̀ drɨ́gá drìdrì ngá nyàma kandrá ko gò, lɨ́ndrɨ́ nɨ dré gàzo tà nda sè. ");
INSERT INTO log_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Gò Mírì dré tàzoá drá dhɨ: «Àmɨ Fàrìsáyò ro nɨ ɨ, mɨ̀ adré àmɨkya kópò kɨ rúbhá dzɨ sǎnɨ̀ kya ɨ́be gò, àmɨ léna dhɨ, mɨ̀ dré adrézó gàle ngá lovó sè bǐ, ɨ̀ndɨ̀ tà kònzɨ sè bǐ. ");
INSERT INTO log_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Àmɨ móndɨ́ azaaza ró dhɨ ꞌɨ! Gìká ngá kɨ rúbhá ledélépi dhɨ, ledé kókpà ngá kɨ ꞌálé ko? ");
INSERT INTO log_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Dɨ mɨ̀ kòfè ngá àmɨ kɨ kópò na ɨ̀ndɨ̀ àmɨ kɨ sǎnɨ̀ na dhɨ ɨ lemerèbhá ɨ dré gò, ngá títí dhɨ ɨ̀ kàtsáró ndǐ àko àmɨ dré. ");
INSERT INTO log_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Àmɨ Fàrìsáyò ro nɨ ɨ, kɨzà àmɨ kɨ ngá ꞌɨ! Mɨ̀ adré ngá nzɨ̌ tsàtsà títí mɨ̀ dré adrélé lokólé àmɨ kɨ amvú na, lanzɨ́lé ꞌa be mudrí dhɨ kɨ àlo fe Gìká dré: ndɨ̀ndɨ̀ àmɨ kɨ ménetè, àmɨ kɨ rúwè, tsàle ngábí twátwa mɨ̀ dré adrélé kidhílé dhɨ ɨ́be. Dɨ, mɨ̀ adré àmɨkya tà gyǎgya ꞌòma ɨ̀ndɨ̀ Gìká nɨ lèma dhɨ kɨ tà tɨvɨ̀. Adré tá lèá dhɨ, mɨ̀ kàdré tà nda kòdhɨ kɨ ꞌo, ngá fèma Gìká dré dhɨ nɨ tɨvɨ̀ àko ró. ");
INSERT INTO log_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Àmɨ Fàrìsáyò ro nɨ ɨ, kɨzà àmɨ kɨ ngá ꞌɨ! Mɨ̀ adré lèá lɨrɨ́lé àrà lɨndrɨ̀ àdhya lɨ̀sámbò dzó ɨ ꞌásè dhɨ ɨ ꞌásè. Mɨ̀ adré kpà lèá dhɨ, à kàdré mòdo fe àmɨ dré lɨndrɨ̀ sè ngá lagɨ́rà ɨ ꞌásè. ");
INSERT INTO log_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Kɨzà àmɨ kɨ ngá ꞌɨ! Àmɨ ngóró mógó rabhá akɨ́lé gò, adrézó tatsílé drìásà ni àko ró dhɨ ɨ tɨ́nɨ.» ");
INSERT INTO log_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Gò tátrɨ́trɨ́ kúlí tadhábhá kɨ àlo dré tàzoá Yésu dré dhɨ: «Tadhálépi, mɨ́ kàdré tà kòdhɨ kɨ ta dhɨ, mɨ́ adré kókpà àma kɨ lodhá.» ");
INSERT INTO log_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Dɨ Yésu logó dhɨ: «Àmɨ tátrɨ́trɨ́ kúlí tadhábhá ro nɨ ɨ, kɨzà kókpà àmɨ kɨ ngá ꞌɨ! Mɨ̀ adré àmɨkya ngá lanzìlanzì kɨtswálé dòle bwà ko dhɨ kɨ tobhà móndɨ́ ɨ dri gò, mɨ̀ dré adrézó ndɨ̀ndɨ̀ drɨ́gámbɨ́lɨ́ so àyɨ kɨ ledézó dhɨ ko. ");
INSERT INTO log_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Kɨzà àmɨ kɨ ngá ꞌɨ! Mɨ̀ adré mógó kɨ tobhà pròfétà ɨ dré, tágba àmɨ kɨ tábhí ɨ̀ dré àyɨ kɨ tupfúzó todràle àyɨ dhɨ. ");
INSERT INTO log_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ásà dhɨ, mɨ̀ adré àmɨkya tadhá dhɨ, mɨ̀ kaꞌì tà àmɨ kɨ tábhí ɨ̀ dré tá ꞌòle nda ɨ. Tàko ko, ɨ̀ tupfú tá àyɨkya pròfétà nda ɨ gò, mɨ̀ dré àmɨkya adrézó àyɨ kɨ mógó kɨ tobhà. ");
INSERT INTO log_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Tà nda sè dhɨ, Gìká tà tá áyɨ tògyá sè dhɨ: ‹Má nɨ pròfétà kɨ tibhù àpóstolò ɨ́be lɨ̀le àyɨ véna. Dɨ, ɨ̀ nɨ àyɨ kɨ àruka kɨ tupfú todràle, adrézó àruka nɨ kɨ mì pfo.› ");
INSERT INTO log_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Dɨ ásà dhɨ, Gìká nɨ pròfétà títí kɨdhólé tupfúlé todràle bvò bhǎrà lésè atsálé ándrò dhɨ kɨ kàrɨ́ nɨ tà zi móndyá ándrò nɨ ɨ tí, ");
INSERT INTO log_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","kɨdhólé Àbélè nɨ kàrɨ́ rú, atsálé Zàkàrɨ́yà pfùle dràle àlètárɨ̀ ɨ kòfalé àrà lólo be dhɨ nɨ kàrɨ́ rú. Àyíya, má adré tàá àmɨ dré dhɨ: Gìká nɨ àyɨ títí nda kɨ kàrɨ́ nɨ tà zi móndyá ándrò nɨ ɨ tí. ");
INSERT INTO log_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Àmɨ tátrɨ́trɨ́ kúlí tadhábhá ro nɨ ɨ, kɨzà àmɨ kɨ ngá ꞌɨ! Mɨ̀ kɨkɨ́ láti adrézó Gìká nɨ tà ni dhɨ dre. Àmɨ kɨ tàndɨ, mɨ̀ fɨ láti nda ꞌásè ko gò, mɨ̀ dré kpà móndyá adrébhá tá lèá fɨ̀le dhɨ kɨ logázó.» ");
INSERT INTO log_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yésu kòtayɨ́ àrà nda dre dhɨ, Fàrìsáyò nda ɨ tátrɨ́trɨ́ kúlí tadhábhá nda ɨ́be dhɨ ɨ̀ dré ngàzo adrélé lɨgɨ́lé akódhɨ be rìnyí sè, adrézó akódhɨ nɨ lizí tà bǐ dhɨ ɨ sè, ");
INSERT INTO log_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","kɨtswázó akódhɨ nɨ ꞌo laꞌɨ̀le kúlí dré tá adrélé tàle dhɨ ɨ sílé dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Lókyá nda sè dhɨ, móndɨ́ lɨ̀zólɨ̀zo lavúlé dhɨ ɨ̀ kɨmó tá ru, tsàle ɨ̀ dré adréràꞌa àyɨ kɨ pá ató àyɨ kòfalésè dhɨ ꞌá. Gò Yésu dré zyà kɨdhózó tà ta áyɨ lebèbhá ɨ dré, tàzoá dhɨ: «Mɨ̀ kàdré àmɨ kɨ lɨkɨ́ tàkú Fàrìsáyò kya nɨ tà sè. Tàkú nda àyɨ kɨ túrúpfú tà ꞌɨ. ");
INSERT INTO log_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Tà bàti ró dhɨ, à nɨ tà títí lùzu ró dhɨ kɨ tadhá ngádra ꞌá. À nɨ kpà tà títí zùle zùzù dhɨ kɨ ꞌo apfòle móndɨ́ ɨ̀ dré nìle dóro. ");
INSERT INTO log_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Dɨ ásà dhɨ, tà mɨ̀ dré tàle tínímvá na dhɨ ɨ, à nɨ yìá ngádra ꞌá. Tà mɨ̀ dré tàle àmɨ kɨ àzya bína kòyàyà sè dzó kɨ ꞌa kɨ̀le dhɨ ɨ ꞌásè dhɨ ɨ, à nɨ longóá dzódrì ɨ lésè. ");
INSERT INTO log_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Áma arúpi ɨ, má adré tàá àmɨ dré dhɨ: Mɨ̀ kòro dhya adrébhá móndɨ́ kɨ rúbhá kɨ tupfú todràle gò, ɨ̀ dré kɨtswázó tà àzya ꞌo bwà ko dhɨ ɨ ko. ");
INSERT INTO log_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Má nɨ dhya kɨtswálépi mɨ̀ dré ròle dhɨ nɨ tadhá àmɨ dré: Mɨ̀ kàdré Gìká, móndɨ́ kɨ rúbhá kɨ tupfuma àmvolésè, adrélépi rìnyí ɨ́be kɨtswázó àyɨ kɨ bhe líferò na dhɨ nɨ ro kòdhya. Àyíya, má adré tàá àmɨ dré dhɨ: Mɨ̀ kàdré akódhɨ nda nɨ ro kòdhya. ");
INSERT INTO log_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","À adré zakó tsì kɨ̀tsɨ̀kɨ́rɨ́nyà nzi dhɨ kɨ lagɨ́ làfa lòꞌwa nzɨ̌ rì dhɨ ɨ sè? Dɨ tágba dré adrézó kònɨ̀nɨ dhɨ, Gìká adré àyɨ nda kɨ àlo nɨ tà tɨvɨ̀ ko. ");
INSERT INTO log_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Kàdré dɨ àmɨ kɨ tà sè dhɨ, akódhɨ nà ndɨ̀ndɨ̀ àmɨ kɨ drìbhɨ́ ɨ títí nànà. Dɨ mɨ̀ kòro ngá ko. Àmɨ kɨ tà lavú kɨ̀tsɨ̀kɨ́rɨ́nyà zyandre dhɨ kya byá! ");
INSERT INTO log_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Má adré tàá àmɨ dré dhɨ: Dhya ángùdhi adrélépi tàá móndɨ́ ɨ kandrá dhɨ ɨ́ kaꞌì ma dre dhɨ, Móndɨ́ nɨ Mvá nɨ kókpà tàá Gìká nɨ ángéló ɨ kandrá dhɨ, ɨ́ kaꞌì akódhɨ nda dre. ");
INSERT INTO log_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Dɨ, dhya ángùdhi adrélépi ɨ́na áma ga móndɨ́ ɨ kandrá dhɨ, má nɨ kókpà akódhɨ nda nɨ ga Gìká nɨ ángéló ɨ kandrá. ");
INSERT INTO log_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Dhya ángùdhi adrélépi kúlí kònzɨ ta Móndɨ́ nɨ Mvá rú dhɨ, Gìká nɨ akódhɨ nda nɨ tàkonzɨ̀ tri. Dɨ, dhya adrélépi ɨ́na làdhá dha Tɨrɨ́ Lólo rú dhɨ, à kɨtswá akódhɨ nda nɨ tàkonzɨ̀ tri ko. ");
INSERT INTO log_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","À kàdré àmɨ kɨ dri tàbvó tàle lɨ̀sámbò dzó kɨ kàdrɨ̀ ɨ kandrásè, ópɨ́ ɨ kandrásè ɨ̀ndɨ̀ móndɨ́ kàdrɨ̀ ɨ kandrásè dhɨ, mɨ̀ kòbhà àmɨ kɨ togó adrélé lanzìle tà mɨ̀ dré dra tàle àmɨ rúsè yà, kó ngalè mɨ̀ nɨ tà nda nɨ ta ngɨ́nɨ ya dhɨ dri dhɨ ko. ");
INSERT INTO log_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Àngyá ko, Tɨrɨ́ Lólo nɨ tà mɨ̀ dré kɨtswálé tàle dhɨ nɨ tadhá àmɨ dré gbǎ lókyá nda sè dhɨ nɨ̀.» ");
INSERT INTO log_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Gò dhya àlo móndyá zyandre nda ɨ kòfalé dhɨ dré tàzoá Yésu dré dhɨ: «Tadhálépi, mɨ́ kòtà áma adrúpi dré dhɨ, kòlanzɨ́ ngá àma kɨ atá dré tayɨ́lé dhɨ ɨ àma dré túmä́ní ɨ́ be.» ");
INSERT INTO log_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Dɨ, Yésu logó drá dhɨ: «Arúpi, àdhi bhà ma adrélé tà àmɨ kòfalé dhɨ kɨ bvó lanzɨ́ dhɨ nɨ̀?» ");
INSERT INTO log_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Gò tàá móndyá títí dhɨ ɨ dré dhɨ: «Mɨ̀ kònò dóro, mɨ̀ kàdréró àmɨ kɨ lɨkɨ́ ngá lovó kárá be títí dhɨ kɨ tà sè. Àngyá ko, dhyá kɨ lɨ́drɨ̀ adré ɨ́na áyɨ totó dhyá kɨ ngá ɨ dri ko, gba à kàdré ngá ɨ́be zyandre ró yà dhɨ.» ");
INSERT INTO log_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Gò dré pɨ́dhɨ́gó kònɨ̀dhɨ nɨ pɨ̀zo àyɨ dré, tàzoá dhɨ: «Ngá líyí àlo dhɨ nɨ amvú ka tá lànyá dóro. ");
INSERT INTO log_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Dɨ akódhɨ dré ngàzo adrélé kisùá ɨ́ léna dhɨ: ‹Má nɨ ꞌòá ngɨ́nɨ? Àrà má dré adrézó áma lànyá bha lɨkɨ́lé dhɨ kɨtswá ko.› ");
INSERT INTO log_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Gò tàá dhɨ: ‹Má nɨ ꞌòá kònɨ̀nɨ: Má nɨ áma kòbhó kɨ awú, àruka nɨ kàdrɨ̀ àyɨ kɨ lavúbhá dhɨ kɨ sìzo gò, áma lànyá wä́yi bhàzo lɨkɨ́lé lána, áma ngá àruka ɨ́be. ");
INSERT INTO log_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Dɨ má nɨ go tàá má léna dhɨ: Ma ngá dóro má dré lokólé dhɨ ɨ́be bǐ. Ngá nda kɨ kɨtswá áma ledé kóná bǐ. Nyànomvá dhɨ, má nɨ rè lovó, adrélé ngá nya, adrézó ngá mvu, adrézó lenzélé.› ");
INSERT INTO log_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Dɨ, Gìká gò ɨ́na tàá drá dhɨ: ‹Mɨ móndɨ́ azaaza ꞌɨ! Ándrò, ngátsi kònɨ̀dhɨ sè dhɨ, à nɨ ámɨ lɨ́drɨ̀ tɨngá. Dɨ ngá mɨ́ dré lokólé mɨ́ dré dhɨ kɨ go adrélé àdhi dré?›» ");
INSERT INTO log_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yésu gò tàá dhɨ: «Tà nda nɨ adré kókpà kònɨ̀nɨ dhya ángùdhi adrélépi ngá lokó áyɨ tàndɨ dré gò, adrézó lemerè ro Gìká véna dhɨ dré.» ");
INSERT INTO log_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Gò Yésu dré tàzoá áyɨ lebèbhá ɨ dré dhɨ: «Tà nda sè dhɨ, má adré tàá ámɨ dré dhɨ: Mɨ̀ kòbhà àmɨ kɨ togó adrélé lanzìle àmɨ kɨ lɨ́drɨ̀ nɨ tà sè ko, ngalè mɨ̀ nɨ dra àdho ngá nya ya dhɨ. Mɨ̀ kòbhà kpà àmɨ kɨ togó adrélé lanzìle àmɨ kɨ rúbhá nɨ tà sè ko, ngalè mɨ̀ nɨ dra àdho asó àmɨ rú ya dhɨ. ");
INSERT INTO log_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Tàko ko, àmɨ kɨ lɨ́drɨ̀ lavú mányàngá byá. Àmɨ kɨ rúbhá lavú kpà kɨ́tá byá. ");
INSERT INTO log_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Mɨ̀ nò rè àrɨ́ ɨ ká. Ɨ̀ kidhí ngá ko na. Ɨ̀ akónà kpà ngá ko na. Àyɨ kúkú àko, ɨ̀ndɨ̀ kòbhó àko. Dɨ, Gìká adré ɨ́na ngá fe àyɨ dré tèle. Dɨ àmɨ kɨ tà lavú tsì àrɨ́ kya ko? ");
INSERT INTO log_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Àmɨ kòfalé dhɨ, àdhi nɨ kɨtswá áyɨ lɨ́drɨ̀ nɨ lókyá nɨ drì tɨmbà tsà, dré adrélé áyɨ togó bha lanzìle dhɨ sè bwà dhɨ nɨ̀? ");
INSERT INTO log_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Dɨ mɨ̀ kòkɨtswá tà mvá tsà kòdhɨ nɨ ꞌo bwà ko dhɨ, mɨ̀ adré dɨ àmɨ kɨ togó bha adrélé lanzìle tà àruka ɨ sè àdho tà sè? ");
INSERT INTO log_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Mɨ̀ nò rè ngalè pfò mbɨ̀ na dhɨ ɨ̀ adré topfòle ngɨ́nɨ ya dhɨ ká. Ɨ̀ ꞌo àzí ko na. Ɨ̀ ledé kpà kɨ́tá ko na. Dɨ, má adré mána tàá àmɨ dré dhɨ: Ndɨ̀ndɨ̀ ópɨ́ Sòlòmónò rúku nɨ ɨ́be títí dhɨ asó tá kɨ́tá aveave pfò nda kɨ àlo àdhya tɨ́nɨ dhɨ ko. ");
INSERT INTO log_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Gìká kàdré kó mbɨ̀ adrélépi ándrò kònwa gò, kìdru dra bhèzoá àtsɨ́ na dhɨ kɨ tosó kònɨ̀nɨ be dhɨ, a nɨ dɨ vélé àmɨ kɨ tosó dóro àyɨ kɨ lavú ngɨ́nɨ? Àmɨ àmɨkya móndɨ́ tà kaꞌìkaꞌì ɨ́be tsà dhɨ ꞌɨ! ");
INSERT INTO log_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Mɨ̀ kòbhà àmɨ kɨ togó adrélé lanzìle, adrézó ndàá nìle ngalè mɨ̀ nɨ dra àdho ngá nya ya, kó ngalè mɨ̀ nɨ dra àdho ngá mvu ya dhɨ ko. ");
INSERT INTO log_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Tàko ko, pàgánò títí bvò kòndɨ àdhya ɨ̀ adré àyɨkya ngá nda kɨ nda kòdhya landè àko ró. Àmɨ kɨ Atá nì kpà tàle dhɨ, àmɨ lovó ɨ́be ngá nda kɨ kisúzó dhɨ be. ");
INSERT INTO log_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Dɨ, mɨ̀ kàdré àmɨkya Gìká nɨ Òpɨ̀ nda kòdhya gò, akódhɨ kòtɨmbàró kpà ngá nda ɨ àmɨ dré. ");
INSERT INTO log_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Àmɨ pä̀rí mvá pabhá má làgásè nɨ ɨ, mɨ̀ kòro ngá ko. Tàko ko, àmɨ kɨ Atá mìlésè dhɨ dóro áyɨ Òpɨ̀ fèzo àmɨ dré. ");
INSERT INTO log_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Dɨ mɨ̀ kòlagɨ́ àmɨ kɨ ngá, làfa nɨ nɨ fèzo lemerèbhá ɨ dré. Mɨ̀ kòledé àmɨ dré tsùngà kɨtswábhá akùle bwà ko dhɨ ɨ. Mɨ̀ kòlokó àmɨ dré ngá làgɨ́ be kàdrɨ̀, kɨtswábhá akɨ́lé bwà ko dhɨ ɨ bhù na. Kònàle dhɨ, kùgú fɨ gà ko na. Órò sì kpà gà ngá ko na. ");
INSERT INTO log_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Tàko ko, àrà ángùdhi àmɨ kɨ ngá làgɨ́ be kàdrɨ̀ dhɨ dré adrézó lána dhɨ na dhɨ, àmɨ kɨ togó nɨ adré kókpà kònàle.» ");
INSERT INTO log_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","«Mɨ̀ kàdré gànzi ró, adrélé àmɨ kɨ káfà ꞌɨ̀le àmɨ kɨ kípílé ꞌá dhɨ ɨ́be, ɨ̀ndɨ̀ àmɨ kɨ tálà dhɨ̀le adrélé kòle dhɨ ɨ́be. ");
INSERT INTO log_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Mɨ̀ kàdré ngóró màrábà adrébhá àyɨ kɨ mírì nɨ letè anzɨ́ràꞌa gwányá làmó àdhya lésè, kònɨ̀ dra atsá dzóti ga dhɨ, ɨ̀ kònzìró akódhɨ dré be dhɨ ɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Kólénzé nɨ adré màrábà àyɨ kɨ mírì dré dra atsázó àyɨ kɨ kisú adréràꞌa tàmìga dri dhɨ ɨ dré! Má adré tà bàti ta àmɨ dré: Akódhɨ nɨ kɨ́tá àzí àdhya nɨ asó ɨ́ rú, àyɨ kɨ ꞌòzo lɨrɨ́lé mɨ́sá làgásè gò, ngá fèzo àyɨ dré nyàle. ");
INSERT INTO log_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Kólénzé nɨ adré àyɨ dré, àyɨ kɨ mírì kòkisú àyɨ adréràꞌa tàmìga dri, gba kàtsá ngátsi kɨ́tógá sè yà, kó ngalè ngátsi kɨ́tógá àmvolésè yà dhɨ! ");
INSERT INTO log_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Dɨ, lè mɨ̀ kònì tà kònɨ̀dhɨ dóro: Dzó líyí kònì tá lókyá ángùdhi kùgú dré kɨtswázó atsálé dhɨ be dhɨ, kònò kɨtswá tá akódhɨ nɨ tayɨ́ áyɨ dzóti ŋo ko. ");
INSERT INTO log_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Dɨ àmɨ ró dhɨ, mɨ̀ kàdré kókpà gànzi ró. Tàko ko, Móndɨ́ nɨ Mvá nɨ atsá sáà mɨ̀ dré adrélé kisùle ko dhɨ sè.» ");
INSERT INTO log_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Gò Pétèró dré akódhɨ nɨ lizízó tàzoá dhɨ: «Mírì, mɨ́ adré ngbà ꞌí kúlí alaala kòdhɨ nɨ ta àma dré àma pátí? Kó ngalè, mɨ́ adré tàá móndyá títí ɨ dré?» ");
INSERT INTO log_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Dɨ Mírì logó dhɨ: «Màrábà tògya ró mírì nɨ dré kɨtswálé kaꞌìle dhɨ, àdhi ꞌɨ? Akódhɨ nda, dhya mírì nɨ dré dra bhàle áyɨ màrábà àruka ɨ drìle, kɨtswálé mányàngá fe àyɨ dré nyàle lókyá kɨtswálépi dhɨ sè dhɨ ꞌɨ. ");
INSERT INTO log_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Màrábà nda nɨ mírì kàtsá akódhɨ nɨ kisú adréràꞌa ꞌòá kònɨ̀nɨ dhɨ, kólénzé nɨ adré akódhɨ dré! ");
INSERT INTO log_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Má adré tà bàti ta àmɨ dré: Akódhɨ nɨ mírì nɨ akódhɨ nɨ bha adrélé áyɨ ngá títí dhɨ ɨ drìle. ");
INSERT INTO log_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Dɨ, màrábà nda kàdré ɨ́na kisùá ɨ́ léna dhɨ ‹Áma mírì adré gìle agòma sè› gò, dré kɨdhózó adrélé màrábà àgo ró ɨ̀ndɨ̀ tòko ró dhɨ kɨ tswa, adrézó ngá nya, adrézó ngá mvu, adrézó kpà wá tsi dhɨ, ");
INSERT INTO log_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","akódhɨ nɨ mírì nɨ atsá kìtú dré adrélé letèle ko dhɨ tú, ɨ̀ndɨ̀ sáà dré adrélé nìle ko dhɨ sè. Dɨ a nɨ akódhɨ nɨ togá, akódhɨ nɨ tà bhàzo adrélé túmä́ní móndyá Gìká nɨ kaꞌìbhá ko dhɨ kya ɨ́be. ");
INSERT INTO log_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Màrábà ángùdhi adrélépi tà áyɨ mírì dré adrélé lèle dhɨ kɨ ni gò, adrézó tà nda kɨ ꞌo ko, adrézó kpà gànzi ró ko dhɨ, à nɨ akódhɨ nda nɨ bhwa vésè be bǐ. ");
INSERT INTO log_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Dɨ, màrábà ángùdhi adrélépi tà nda kɨ ni ko gò, adrézó tà kɨtswábhá à kòbhwà akódhɨ ásà dhɨ kɨ ꞌo dhɨ, à nɨ akódhɨ nda nɨ bhwa vésè be tsà. Tàko ko, dhya ángùdhi tà bǐ dhɨ kɨ fèzo drá dhɨ tí dhɨ, à nɨ tà bǐ dhɨ kɨ zi kòdhya. Dhya ángùdhi tà bǐ dhɨ kɨ bhàzo drɨ́gá dhɨ tí dhɨ, à nɨ tà bǐ lavúlé dhɨ kɨ zi kòdhya.» ");
INSERT INTO log_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","«Má alɨ̀ kɨtswálé àtsɨ́ so bvò dri. Má lè tá dhɨ, àtsɨ́ nda kòko dre! ");
INSERT INTO log_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Dɨ, adré lèá dhɨ, má kòdo rè zyà bàtísimò kɨzà àdhya. Áma togó adré kɨzà nya tò, tsàle lókyá tà nda dré dra ru ꞌòzo kɨtswálé títí dhɨ ꞌá. ");
INSERT INTO log_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Mɨ̀ adré kisùá dhɨ, má alɨ̀ bvò dri kɨtswálé tà kɨ̀drɨ́kɨ̀drɨ fe kòdhya? Kóko! Be ro dhɨ, má adré tàá àmɨ dré dhɨ: Má alɨ̀ mána kɨtswálé tà ru lanzɨ́zó dhɨ nɨ bha móndɨ́ ɨ kòfalé kòdhya! ");
INSERT INTO log_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Tàko ko, kɨdhólé nyànomvá dhɨ, móndɨ́ nzi dzó àlo na dhɨ kɨ ru lanzɨ́ àyɨ kòfalésè: na dhɨ kɨ àyɨ kɨ alá rì dhɨ ɨ rú, ɨ̀ndɨ̀ rì dhɨ kɨ àyɨ kɨ alá na dhɨ ɨ rú. ");
INSERT INTO log_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ɨ̀ nɨ ru lanzɨ́: Atá nɨ áyɨ alá áyɨ mváagó rú, ɨ̀ndɨ̀ mváagó nɨ áyɨ alá áyɨ atá rú. Andre nɨ áyɨ alá áyɨ mvátòkó rú, ɨ̀ndɨ̀ mvátòkó nɨ áyɨ alá áyɨ andre rú. Àdrá nɨ áyɨ alá áyɨ àdramvá rú, ɨ̀ndɨ̀ àdramvá nɨ áyɨ alá áyɨ àdrá rú.» ");
INSERT INTO log_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yésu gò tàá móndyá zyandre nda ɨ dré dhɨ: «Mɨ̀ kàdré ndùrùku no adréràꞌa angálé kìtú dré ndǐrà lésè dhɨ, mɨ̀ adré tàá dhɨ: ‹Gí ko, bhù nɨ dra dhi› gò, bhù nda dré dhìzo bàti. ");
INSERT INTO log_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Lyǎ kàdré avílé tàbhu lésè dhɨ, mɨ̀ adré tàá dhɨ ‹Kìtú nɨ dra ka› gò, dré kàzo bàti. ");
INSERT INTO log_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Àmɨ túrúpfúbhá ꞌɨ! Mɨ̀ nì kó bvò kɨ làsú bhù mìbhalé be dhɨ lanzɨ́lé dhɨ be dhɨ, mɨ̀ kɨtswá dɨ àmɨkya lókyá ándrò kòndɨ nɨ tà ni lanzɨ́lé bwà ko àdho tà sè?» ");
INSERT INTO log_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","«Mɨ̀ kɨtswá adrélé tà kɨ kòfalé ni lanzɨ́lé, adrézó tà gyǎgya kɨpè ꞌòle dhɨ bwà ko àdho tà sè? ");
INSERT INTO log_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Mɨ̀ kàdré lɨ̀le dhya adrélépi ámɨ asíkì dhɨ be tàbvó tǎrà na dhɨ, lè mɨ́ kòndà láti mɨ̀ dré kɨtswázó ru yi akódhɨ be drìdrì mɨ̀ dré tsàzo dhɨ kandrá. Mɨ́ kòꞌo kònɨ̀nɨ ko dhɨ, akódhɨ nɨ ámɨ dri tàbvó tàlepi kandrá, tàbvó tàlepi nda dré ámɨ fèzo pòlísì drɨ́gá gò, akódhɨ nda dré ámɨ bhèzo bǎdzó na. ");
INSERT INTO log_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Má adré tàá mɨ́ dré dhɨ: Mɨ́ kɨtswá apfòle kònalésè ko, tsàle lókyá mɨ́ dré dra màri nda nɨ logózó akɨ́lé títí dhɨ ꞌá.» ");
INSERT INTO log_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Lókyá nda sè dhɨ, móndɨ́ àruka ɨ̀ dré alɨ̀zo Yésu vélé, móndɨ́ àruka Gàlìláyà lésè dhɨ kɨ tupfuma nɨ tà longó drá. Pìlátò ꞌo tá àyɨ nda ɨ tupfúlé todràle, ɨ̀ dré tá adréràꞌa mòbòmà fe Gìká dré dhɨ ꞌá. ");
INSERT INTO log_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Dɨ Yésu dré logózóá àyɨ dré dhɨ: «Mɨ̀ adré kisùá dhɨ, dhya Gàlìláyà lésè nda ɨ̀ ꞌo tá tàkonzɨ̀ móndyá àruka títí Gàlìláyà na dhɨ kya kɨ lavú, ɨ̀ dré kɨzà nyàle todràzo làsú be kònɨ̀nɨ dhɨ sè? ");
INSERT INTO log_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Kóko! Dɨ, má adré mána tàá àmɨ dré dhɨ: Mɨ̀ kòladzá àmɨ kɨ togó ko dhɨ, mɨ̀ nɨ kókpà todrà akɨ́lé títí àyɨ nda ɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Kàdré ngalè dhya mudrí-drì-nzi-drì-na dzó mvumvù Sìlòwámà àdhya dré tá arɨ́zó àyɨ dri àyɨ kɨ tupfú dhɨ kɨ tà sè dhɨ, mɨ̀ adré kisùá dhɨ, àyɨ nda ɨ̀ ꞌo tá tàkonzɨ̀ móndyá àruka títí adrébhá Yèrúsalémà na dhɨ kya kɨ lavú? ");
INSERT INTO log_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Kóko! Dɨ, má adré mána tàá àmɨ dré dhɨ: Mɨ̀ kòladzá àmɨ kɨ togó ko dhɨ, mɨ̀ nɨ kókpà todrà akɨ́lé títí àyɨ nda ɨ tɨ́nɨ.» ");
INSERT INTO log_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yésu gò pɨ́dhɨ́gó kònɨ̀dhɨ nɨ pɨ àyɨ dré, tàzoá dhɨ: «Agó àlo dhɨ bhe tá fígì fa áyɨ amvú vínò àdhya na. Bvóá dhɨ, dré lɨ̀zo lòꞌwa nda sílá ká, dɨ, dré kisúzóá ko. ");
INSERT INTO log_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Gò dré tàzoá amvú nda nɨ lɨkɨ́lépi dré dhɨ: ‹Mɨ́ nò rè ká! Kóná na, má landú lòꞌwa nda kɨ̀le fígì fa kònɨ̀dhɨ sílé ká, dɨ, má dré kisúzóá ko. Mɨ́ ga dɨ akódhɨ. Adré bvò kɨkɨ́ àngyá àdho tà sè?› ");
INSERT INTO log_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Dɨ, amvú lɨkɨ́lépi nda gò logóá drá dhɨ: ‹Mírì, mɨ́ gò rè tayɨ́á kóná kònɨ̀dhɨ sè ká. Má nɨ kìní zàlá dhɨ nɨ agá kúrú gò, mbɨ̀ àŋwá dàzo drìá. ");
INSERT INTO log_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Àruka nɨ, a nɨ go lòꞌwa ꞌa kóná adrélépi alɨ̀le dhɨ sè. Dɨ, kòꞌa ko dhɨ, mɨ́ nɨ kɨtswá ꞌòá gàle.›» ");
INSERT INTO log_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sàbátù àlo dhɨ, Yésu adré tá tà tadhá Yúdà ànzɨ kɨ lɨ̀sámbò dzó kɨ àlo na. ");
INSERT INTO log_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Dɨ tòkó àlo tɨrɨ́ kònzɨ dré rúbhá nɨ nɨ ꞌòzo adrélé drà ro dhɨ tá kpà kònàle. Tɨrɨ́ nda ꞌo tá akódhɨ nɨ àmvò atrúlé vwàle kóná be mudrí-drì-nzi-drì-na gò, akódhɨ dré kɨtswázó áyɨ kɨdzɨ̀ bwà ko. ");
INSERT INTO log_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Dɨ Yésu kònò tòkó nda dre dhɨ, dré akódhɨ nɨ azízó, tàzoá drá dhɨ: «Tòkó, à atrɨ̀ mɨ ámɨ drà lésè dre!» ");
INSERT INTO log_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Dré drɨ́gá bhàzo akódhɨ dri gò, gbǎ kòdhwa, akódhɨ dré áyɨ kɨdzɨ̀zo gò kɨdhólé adrélé Gìká nɨ rú bha kùle. ");
INSERT INTO log_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Dɨ, lɨ̀sámbò dzó nda nɨ kàdrɨ̀ nɨ togó dré aswázó Yésu rú, dré móndɨ́ tɨdrɨ́lé sàbátù tú dhɨ sè. Gò dré tàzoá móndyá zyandre kònàle dhɨ ɨ dré dhɨ: «Kìtú adrézó àzí ꞌo ásà dhɨ ɨ nzi-drì-àlo. Lè mɨ̀ kàdré dɨ alɨ̀le àmɨ kɨ ꞌo tɨdrɨ́lé kìtú nda ɨ sè, kìtú sàbátù àdhya sè ko.» ");
INSERT INTO log_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Dɨ, Mírì logó drá dhɨ: «Àmɨ túrúpfúbhá ꞌɨ! Sàbátù tú dhɨ, àmɨ àlo àlo títí dhɨ ɨ, mɨ̀ adré àmɨ kɨ tí ꞌɨ yà, kó ngalè àmɨ kɨ púndà ꞌɨ yà dhɨ kɨ atrɨ̀ àrà ɨ̀ dré adrézó ngá nya dhɨ lésè, adrézó àyɨ kɨ se lɨ̀le yǐ mvu dhɨ ko? ");
INSERT INTO log_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Adré dɨ tá lèá ko, à kàtrɨ̀ tòkó Àbàrámà nɨ zapi ró Sàtánà dré tá ꞌɨ̀le vwàle kóná be mudrí-drì-nzi-drì-na kònɨ̀dhɨ sàbátù tú dhɨ?» ");
INSERT INTO log_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yésu kòtà tà nda dre dhɨ, akódhɨ nɨ kàrɨbhá títí dhɨ ɨ̀ adré tá vélé kanyò ro. Dɨ, móndyá zyandre títí dhɨ ɨ̀ adré tá àyɨkya lenzélé, tà títí lɨ́ndrɨ́ga ró dré tá adrélé ꞌòle dhɨ kɨ tà sè. ");
INSERT INTO log_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Gò Yésu dré tàzoá dhɨ: «Gìká nɨ Òpɨ̀ sù ngóró àdho tɨ́nɨ? Má nɨ tà nɨ nɨ tadhá àdho ngá rú? ");
INSERT INTO log_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Òpɨ̀ nda sù ngóró mùtádì lòꞌwa dhya àlo dré dòle rɨ̀le áyɨ amvú na dhɨ tɨ́nɨ. Lòꞌwa nda dré apfòzo mbàle atsálé fa tɨ́nɨ gò, àrɨ́ ɨ̀ dré bhà sìzo kólá nɨ ɨ drìna.» ");
INSERT INTO log_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yésu gò tàá dhɨ: «Má nɨ kɨtswá Gìká nɨ Òpɨ̀ nɨ tà tadhá àdho ngá rú? ");
INSERT INTO log_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Òpɨ̀ nda sù ngóró tàkú mvá tsà tòkó àlo dré adólé amúlé fóndro kàdrɨ̀ dhɨ be gò, tàkú nda dré fóndro nda nɨ ꞌòzo avólé títí dhɨ tɨ́nɨ.» ");
INSERT INTO log_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yésu dré tá adréràꞌa lɨ̀le Yèrúsalémà na dhɨ ꞌá dhɨ, adré tá lavúlé tà tadhábe bhàandre ɨ ꞌásè ɨ̀ndɨ̀ bhà tsàtsà ɨ ꞌásè. ");
INSERT INTO log_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Gò móndɨ́ àruka ɨ̀ dré akódhɨ nɨ lizízó tàzoá dhɨ: «Mírì, móndyá dra lɨ́drɨ̀ kóná vésè kólyá dhɨ nɨ kisúbhá dhɨ kɨ ngbà ꞌí adré tsà?» Dɨ Yésu logó àyɨ dré dhɨ: ");
INSERT INTO log_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Mɨ̀ kàdré àmɨ kɨ rìnyí fe títí fɨ̀zo Gìká nɨ Òpɨ̀ na dzóti wàlepi ko dhɨ ꞌásè. Tàko ko, má adré tàá àmɨ dré dhɨ: Móndɨ́ zyandre dhɨ kɨ láti nda kɨtswázó tá fɨ̀le lána ká. Dɨ, ɨ̀ kɨtswá àyɨkya fɨ̀le bwà ko. ");
INSERT INTO log_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Lókyá dzó líyí dré dra ngàzo dzóti asé dhɨ tú dhɨ, a nɨ àmɨ kɨ kɨ kɨvɨ̀ na. Gò mɨ̀ dré kɨdhózó adrélé dzóti ga, adrézó tàá dhɨ: ‹Mírì, mɨ́ nzì àma dré dzóti wà!› Dɨ, a nɨ logóá àmɨ dré dhɨ: ‹Má nì àmɨ ko. Má nì ngalè mɨ̀ angá ángolésè ya dhɨ ko.› ");
INSERT INTO log_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Dɨ mɨ̀ nɨ tàá dhɨ: ‹Mà nya tá ngá, ɨ̀ndɨ̀ mà mvu tá ngá túmä́ní mɨ́ be. Mɨ́ tadhá tá kpà tà àma kɨ láti andre ɨ ꞌásè.› ");
INSERT INTO log_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Dɨ, dzó líyí nda nɨ go logóá àmɨ dré dhɨ: ‹Má nì àmɨ ko. Má nì ngalè mɨ̀ angá ángolésè ya dhɨ ko. Àmɨ tà kònzɨ ꞌobhá títí nɨ ɨ, mɨ̀ nga má mìlésè!› ");
INSERT INTO log_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Dɨ mɨ̀ nɨ Àbàrámà kɨ no, Ɨ̀sákà ɨ́be, Yàkóbhò be, ɨ̀ndɨ̀ pròfétà títí dhɨ ɨ́be Gìká nɨ Òpɨ̀ na gò, àmɨ kɨ bhèzo kɨvɨ̀ na. Kònàle dhɨ, à nɨ adré tongólé, adrézó kpà síkálándrá tsɨ. ");
INSERT INTO log_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Móndɨ́ kɨ alɨ̀ kìtú dré apfǒrà lésè, kìtú dré ndǐrà lésè, kurú lésè, ɨ̀ndɨ̀ tàbhu lésè gò, lɨrɨ́lé mɨ́sá làgásè Gìká nɨ Òpɨ̀ na. ");
INSERT INTO log_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Dɨ, mɨ̀ yi rè ká! Móndɨ́ àruka adrébhá bvólé ro nyànomvá dhɨ kɨ go adrélé drìdrì. Móndɨ́ àruka adrébhá drìdrì nyànomvá dhɨ kɨ go adrélé bvólé ró.» ");
INSERT INTO log_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Lókyá nda sè dhɨ, Fàrìsáyò àruka ɨ̀ dré àyɨ kɨ kisízó ànyɨ Yésu làga, tàá drá dhɨ: «Mɨ́ nga kònwásè lɨ̀le àrà àzya na! Tàko ko, Èródè adré ɨ́na ámɨ le pfùle dràle.» ");
INSERT INTO log_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Dɨ Yésu logó àyɨ dré dhɨ: «Mɨ̀ lɨ̀ tàá kɨ̀lɨ̀wá kòdhɨ dré dhɨ: ‹Ándrò tsàle kìdru dhɨ, má nɨ tɨrɨ́ kònzɨ kɨ dro topfòle móndɨ́ ɨ lésè, adrézó móndɨ́ kɨ tɨdrɨ́ àyɨ kɨ drà ɨ lésè. Kìtú nɨ na sè dhɨ, má nɨ áma àzí ꞌo akɨ́lé títí.› ");
INSERT INTO log_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Dɨ, ándrò, kìdru, tsàle kìtú bvóá dhɨ tú dhɨ, adré lèá dhɨ, má kògò adrélé lɨ̀le drìdrì. Tàko ko, kɨtswá à kòpfu pròfétà àlo dràle àrà twá Yèrúsalémà rúsè dhɨ na dhɨ ko. ");
INSERT INTO log_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Á! Yèrúsalémà, Yèrúsalémà, mɨ adrélépi pròfétà kɨ tupfú todràle, adrézó kpà dhya Gìká dré adrélé amùle mɨ́ vélé dhɨ kɨ lebhé todràle kɨ́rà sè nɨ! Tsàle vésè be ángopɨ́, má lè tá ámɨ ànzɨ kɨ kɨmólé má zàle, ngóró tàꞌú dré adrélé áyɨ ànzɨmvá kɨ kɨmó áyɨ kupfú zàle dhɨ tɨ́nɨ dhɨ? Dɨ, mɨ̀ lè tá àmɨkya ko. ");
INSERT INTO log_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Dɨ mɨ̀ yi rè ká! À tayɨ́ àmɨ kɨ dzó ngbo dre. Má adré tàá àmɨ dré dhɨ: Mɨ̀ gò vélé áma no ko, tsàle lókyá mɨ̀ dré dra tàzoá dhɨ ‹Tà tanɨ kàdré dhya adrélépi alɨ̀le Mírì nɨ rú sè dhɨ dri!› dhɨ ꞌá.» ");
INSERT INTO log_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sàbátù àlo dhɨ, Yésu lɨ̀ tá ngá nya Fàrìsáyò kɨ kàdrɨ̀ kɨ àlo bhàna. Móndyá kònàle dhɨ ɨ̀ adré tá akódhɨ nɨ mì ga. ");
INSERT INTO log_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Gò agó àlo rúbhá tovólépi dhɨ dré alɨ̀zo áyɨ totó Yésu kandrá. ");
INSERT INTO log_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Dɨ Yésu dré lizízóá Fàrìsáyò ɨ tí tátrɨ́trɨ́ kúlí tadhábhá ɨ́be dhɨ: «Àma kɨ tátrɨ́trɨ́ kúlí kaꞌì, à kàdré móndɨ́ kɨ tɨdrɨ́ sàbátù tú dhɨ ꞌí? Kó ngalè, kaꞌì ko?» ");
INSERT INTO log_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Dɨ, ɨ̀ dré àyɨkya adrézó kɨ́rɨ. Dɨ Yésu dré drɨ́gá bhàzo agó nda dri, akódhɨ nɨ tɨdrɨ́zó gò, láti fèzo drá dré lɨ̀zo. ");
INSERT INTO log_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Dré gòzo lizíá àyɨ tí dhɨ: «Dhya àlo àmɨ kòfalé dhɨ kàdré mvámvá ɨ́be yà kó ngalè tí àlo dhɨ ɨ́be yà gò, dré dhèzo bhú na sàbátù tú dhɨ, dhya nda kɨtswá tsì aséá gbǎ kìtú nda sè ko?» ");
INSERT INTO log_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Dɨ, ɨ̀ kɨtswá tá àyɨkya kúlí logó tà nda dri bwà ko. ");
INSERT INTO log_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Gò Yésu dré atógyàzoá dhɨ, móndyá azílé ngá nya nda ɨ̀ adré tá àyɨkya lɨrɨ́rà lɨndrɨ̀ àdhya kɨ kɨpè kòdhya. Dɨ dré tà tadházó àyɨ dré kònɨ̀nɨ: ");
INSERT INTO log_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«À kàdré ámɨ zi gwányá làmó àdhya na dhɨ, mɨ́ kòlɨrɨ́ àrà lɨndrɨ̀ àdhya na ko. Tàko ko, àruka nɨ, dhya ámɨ zìlepi nda zi kpà móndɨ́ àzya ámɨ lavúlépi lɨndrɨ̀ sè dhɨ ꞌí. ");
INSERT INTO log_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Kàdré kònɨ̀nɨ dhɨ, a nɨ alɨ̀ tàá mɨ́ dré dhɨ: ‹Mɨ́ tayɨ́ lɨrɨ́rà kònɨ̀dhɨ dhya kòdhɨ dré.› Dɨ kanyò nɨ ámɨ ꞌo, mɨ́ dré adréràꞌa lɨ̀le lɨrɨ́lé àrà kùdù ro dhɨ na dhɨ ꞌá. ");
INSERT INTO log_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Dɨ, à kàdré ámɨ zi ngá nya dhɨ, mɨ́ kòlɨrɨ́ mɨ́na àrà kùdù ro dhɨ na, kɨtswálé dhya ámɨ zìlepi nda kònɨ̀ atsá dhɨ, kòtàró mɨ́ dré dhɨ: ‹Áma arúpi, mɨ́ nga lɨ̀le lɨrɨ́lé àrà lɨndrɨ̀ àdhya na!› Dɨ tà nda nɨ lɨndrɨ̀ fe mɨ́ dré móndyá títí mɨ̀ dré adrézó lɨrɨ́lé mɨ́sá làgásè túmä́ní àyɨ ɨ́be dhɨ ɨ mìlésè. ");
INSERT INTO log_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Tàko ko, dhya ángùdhi adrélépi áyɨ tà bha kuru dhɨ, Gìká nɨ akódhɨ nda nɨ tà tɨrɨ́ kìní mi. Dɨ, dhya adrélépi áyɨ tà bha kìní mi dhɨ, Gìká nɨ akódhɨ nda nɨ tà tɨngá kuru.» ");
INSERT INTO log_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Gò Yésu dré tàzoá dhya áyɨ azílépi nda dré dhɨ: «Mɨ́ kàdré gwányá ꞌo móndɨ́ ɨ dré dhɨ, gba kàdré kìtú rírí sè yà, kó ngalè ɨ̀ndró sè yà dhɨ, mɨ́ kòzi ámɨ arúpi ɨ ꞌɨ yà, ámɨ adrúpi ɨ ꞌɨ yà, ámɨ aró ɨ ꞌɨ yà, kó ngalè ámɨ bhàzɨ̌ ngábhá ro dhɨ ɨ ꞌɨ yà dhɨ ko. Tàko ko, mɨ́ kàdré ꞌòá kònɨ̀nɨ dhɨ, àyɨ nda kɨ go kpà ámɨ zi ngá nya, tà mɨ́ dré ꞌòle àyɨ dré nda nɨ vúdrì logózó mɨ́ dré. ");
INSERT INTO log_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Dɨ, mɨ́ kàdré gwányá ꞌo dhɨ, mɨ́ kòzi mɨ́na lemerèbhá ɨ, móndɨ́ rúbhá be yàyà dhɨ ɨ, mèrèkpè ɨ, ɨ̀ndɨ̀ mì kùdúkùdu ɨ́be kòdhya. ");
INSERT INTO log_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Dɨ Gìká nɨ tà tanɨ bha mɨ́ dri ásà. Tàko ko, àyɨ nda ngá àko logólé mɨ́ dré. Dɨ, Gìká nɨ ɨ́na tà mɨ́ dré ꞌòle nda nɨ vúdrì logó mɨ́ dré, kìtú móndyá gyǎgya dhɨ ɨ̀ dré dra ngàzo dràdrà ꞌásè dhɨ tú dhɨ nɨ̀.» ");
INSERT INTO log_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Móndyá adrébhá tá mɨ́sá làgásè túmä́ní Yésu be dhɨ kɨ àlo kòyi tà nda dre dhɨ, dré tàzoá drá dhɨ: «Kólénzé nɨ adré dhya dra gwányá nyabhá Gìká nɨ Òpɨ̀ na dhɨ ɨ dré!» ");
INSERT INTO log_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Gò Yésu dré tàzoá drá dhɨ: «Agó àlo dhɨ adré tá gwányá kàdrɨ̀ dhɨ nɨ ꞌo gò, dré móndɨ́ zyandre dhɨ kɨ azízó kɨtswálé ngá nya. ");
INSERT INTO log_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Lókyá gwányá nda nɨ nyàzo dhɨ kòkɨtswá dre dhɨ, dré áyɨ màrábà nɨ mùzo lɨ̀le tàá móndyá ɨ́ dré tá azílé nda ɨ dré dhɨ: ‹Mɨ̀ alɨ̀ wà! Tà títí dhɨ ɨ gànzi ró.› ");
INSERT INTO log_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Dɨ, àyɨ àlo àlo títí nda ɨ̀ dré ngàzo adrélé tàá dhɨ, à kòdo àyɨ kònzɨ ko. Tà logá àyɨ nɨ̀. Dhya drìdrì dhɨ tà tá dhɨ: ‹Má gɨ mána amvú. Adré lèá dhɨ, má kòlɨ̀ nòá. Má adré ámɨ ti lizí, mɨ́ kòdoró ma kònzɨ ko!› ");
INSERT INTO log_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Àzya nɨ tà tá dhɨ: ‹Má gɨ mána tí mudrí dhɨ ɨ. Má adré lɨ̀le tí nda kɨ tabhì. Má adré ámɨ ti lizí, mɨ́ kòdoró ma kònzɨ ko!› ");
INSERT INTO log_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Àzya nɨ tà tá dhɨ: ‹Má mo rè tòkó nyànomvá. Ásà dhɨ, má kɨtswá lɨ̀le kònàle bwà ko.› ");
INSERT INTO log_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Gò màrábà nda dré agòzo ta nda kɨ longó áyɨ mírì dré. Dɨ dzó líyí nda nɨ togó dré aswázó gò, dré tàzoá áyɨ màrábà nda dré dhɨ: ‹Mɨ́ lɨ̀ mbèlè bhàandre nɨ láti andre ɨ ꞌásè ɨ̀ndɨ̀ láti tsàtsà ɨ ꞌásè. Mɨ́ adrì lemerèbhá ɨ, móndɨ́ rúbhá be yàyà dhɨ ɨ, mì kùdúkùdu ɨ, tsàle mèrèkpè ɨ́be, alɨ̀zo àyɨ ɨ́be kònwa.› ");
INSERT INTO log_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Gò màrábà nda dré gòzo agòle tàá dhɨ: ‹Mírì, má ꞌo tà mɨ́ dré tàle dhɨ dre. Dɨ, àrà àngyá dhɨ dhu rè be.› ");
INSERT INTO log_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Dɨ dzó líyí nda dré tàzoá áyɨ màrábà nda dré dhɨ: ‹Mɨ́ lɨ̀ láti gbàbhú na dhɨ ɨ ꞌásè, ɨ̀ndɨ̀ láti amvú làga dhɨ ɨ ꞌásè. Mɨ́ ꞌo móndɨ́ ɨ afɨ́lé rìnyí sè áma dzó lé, áma dzó kògaró móndɨ́ ɨ sè bǐ be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Tàko ko, má adré tàá àmɨ dré dhɨ: Dhya má dré tá azílé drìdrì nda kɨ àlo kɨtswá ɨ́na áma gwányá tabhì nyàle ko.›» ");
INSERT INTO log_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Móndɨ́ zyandre lavúlé dhɨ ɨ̀ adré tá lɨ̀le túmä́ní Yésu be láti ꞌásè. Gò akódhɨ dré áyɨ alázó tàá àyɨ dré dhɨ: ");
INSERT INTO log_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Dhya ángùdhi adrélépi alɨ̀le má vélé gò, dré adrézó áma le áyɨ atá nɨ lavú, áyɨ andre nɨ lavú, áyɨ tòkó nɨ lavú, áyɨ ànzɨ kɨ lavú, áyɨ adrúpi kɨ lavú, áyɨ amvúpi kɨ lavú, ɨ̀ndɨ̀ áyɨ tàndɨ nɨ lɨ́drɨ̀ lavú ko dhɨ, dhya nda kɨtswá adrélé áma lebèlepi ró ko. ");
INSERT INTO log_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Dhya ángùdhi adrélépi áyɨ fa kɨpakɨpa do, adrézó alɨ̀le má vésè dhɨ ko dhɨ, kɨtswá kpà adrélé áma lebèlepi ró ko. ");
INSERT INTO log_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Dhya àlo àmɨ kòfalé dhɨ kàdré dzó mvumvù le sìle dhɨ, adré zakó rè zyà lɨrɨ́lé làfa ɨ́ dré dra dzó nda nɨ sìzo ásà dhɨ nɨ nda nìle ꞌíká, nòzoá ngalè ɨ làfa ɨ́be kɨtswázó dzó nda nɨ si akɨ́lé títí bwà yà dhɨ? ");
INSERT INTO log_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Tàko ko, kòbhà dzó nda nɨ pá gò, kɨtswázó sìá akɨ́lé bwà ko dhɨ, móndyá títí dra dzó nda nɨ nobhá dhɨ kɨ akódhɨ nɨ gu, ");
INSERT INTO log_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","adrézó tàá dhɨ: ‹Mɨ̀ nò ká! Agó kòdhɨ kɨdhó tá dzó sìle gò, dré kɨtswázó sìá akɨ́lé bwà ko!› ");
INSERT INTO log_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Kó ngalè, ópɨ́ àlo dhɨ kàdré ꞌòle lɨ̀le àdzú bhu ópɨ́ àzya be dhɨ, adré zakó rè zyà lɨrɨ́lé kisùá ꞌíká ngalè àyɨ áyɨ sòdá ngùlù-mudrí dhɨ ɨ́be dhɨ kɨ kɨtswá ópɨ́ àzya ɨ sòdá nɨ ngùlù-nyadhɨ-àlo dhɨ ɨ́be adrébhá alɨ̀le dhɨ kɨ lavú bwà yà dhɨ? ");
INSERT INTO log_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Akódhɨ kònò ɨ̀ kɨtswá ko dhɨ, adré móndɨ́ kɨ mu lɨ̀le ópɨ́ àzya nda véna, dré rè dhu adréràꞌa vwàvwà ro dhɨ ꞌá, akódhɨ nɨ ti lizí àdzú kàdréró àyɨ kòfalésè yó. ");
INSERT INTO log_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Kókpà kòdhɨ tɨ́nɨ, dhya ángùdhi àmɨ kòfalé, áyɨ ngá títí dhɨ kɨ gàlepi ko dhɨ, kɨtswá ɨ́na adrélé áma lebèlepi ró ko. ");
INSERT INTO log_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Tàꞌí ngá dóro ꞌɨ. Dɨ, tàꞌí nɨ aswaaswa kòtɨ̀ akɨ́lé lásà dhɨ, à nɨ kɨtswá logóá ngɨ́nɨ? ");
INSERT INTO log_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Akódhɨ nɨ àzí vélé kìní dré yà, kó ngalè kòròsò àŋwá dré yà dhɨ yó. À adré vélé ndɨrɨ kutúákutua. Dhya ángùdhi adrélépi bíbhálé ɨ́be tà yìzo dhɨ kòyi!» ");
INSERT INTO log_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Kìtú àlo dhɨ, mèdáyɨ̀ lagɨ́bhá bǐ dhɨ ɨ ɨ̀ndɨ̀ móndɨ́ bǐ adrélé nòle tàkonzɨ̀bhá ro dhɨ ɨ́be dhɨ ɨ̀ adré tá àyɨ kɨ kisí ànyɨ Yésu làga kɨtswálé akódhɨ nɨ kúlí yi. ");
INSERT INTO log_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Dɨ Fàrìsáyò ɨ tátrɨ́trɨ́ kúlí tadhábhá ɨ́be dhɨ ɨ̀ dré dhèzo adrélé Yésu nɨ ndrɨ, adrézó tàá dhɨ: «Dhya kòdhɨ adré ɨ́na tàkonzɨ̀bhá kɨ kaꞌì, adrézó ngá nya túmä́ní àyɨ ɨ́be!» ");
INSERT INTO log_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Dɨ Yésu dré pɨ́dhɨ́gó kònɨ̀dhɨ nɨ pɨ̀zo àyɨ dré, tàzoá dhɨ: ");
INSERT INTO log_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Dhya àlo àmɨ kòfalé dhɨ kàdré kábilígyà ɨ́be nyadhɨ-nzi gò, àyɨ kɨ àlo dré avɨ̀zo dhɨ, a nɨ ꞌòá ngɨ́nɨ? A nɨ zakó tsì kábilígyà nyadhɨ-su-drì-mudrí-drì-nzi-drì-su nda kɨ tayɨ́ ngálángbá ꞌá gò, lɨ̀zo akódhɨ avɨ̀lepi nda nɨ ndabe, tsàle lókyá dré dra kisúzóá dhɨ ꞌá. ");
INSERT INTO log_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Dɨ kòkisú kábilígyà nda dre dhɨ, a nɨ adóá abhélé ɨ́ kembé, ");
INSERT INTO log_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","nzɨ̀zo ába ɨ́ bhàna arɨ́ sè. Kòtsa dre dhɨ, a nɨ áyɨ arúpi kɨ azí áyɨ bhàzɨ̌ ɨ́be, tàzoá àyɨ dré dhɨ: ‹Mà kòlenzé túmä́ní àmɨ ɨ́be wà! Àngyá ko, má kisú kábilígyà mána avɨ̀lepi nɨ dre.› ");
INSERT INTO log_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Má adré tàá àmɨ dré dhɨ: Kókpà kòdhɨ tɨ́nɨ, arɨ́ adré gàle bhù na bǐ tàkonzɨ̀ líyí àlo áyɨ togó ladzálépi dhɨ nɨ tà sè, arɨ́ móndɨ́ gyǎgya nyadhɨ-su-drì-mudrí-drì-nzi-drì-su avɨ̀bhá ko dhɨ kɨ tà sè dhɨ nɨ lavú.» ");
INSERT INTO log_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","«Kó ngalè, tòkó àlo dhɨ kàdré làfa lòꞌwa ɨ́be mudrí gò àlo nɨ dré avɨ̀zo dhɨ, a nɨ ꞌòá ngɨ́nɨ? A nɨ zakó tsì tálà dhɨ, adrézó áyɨ dzó ꞌálé awá títí adrézó làfa lòꞌwa nda nɨ nda, tsàle lókyá dré dra kisúzóá dhɨ ꞌá. ");
INSERT INTO log_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Dɨ kòkisú dre dhɨ, a nɨ áyɨ arúpi kɨ azí áyɨ bhàzɨ̌ ɨ́be, tàzoá àyɨ dré dhɨ: ‹Mà kòlenzé túmä́ní àmɨ ɨ́be wà! Àngyá ko, má kisú làfa lòꞌwa mána avɨ̀lepi nɨ dre.› ");
INSERT INTO log_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Má adré tàá àmɨ dré dhɨ: Kókpà kòdhɨ tɨ́nɨ, arɨ́ adré gàle ángéló Gìká àdhya ɨ kòfalé bǐ, tàkonzɨ̀ líyí àlo áyɨ togó ladzálépi dhɨ nɨ tà sè.» ");
INSERT INTO log_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yésu gò pɨ́dhɨ́gó kònɨ̀dhɨ nɨ pɨ, tàzoá dhɨ: «Agó àlo dhɨ tá ànzɨàgo ɨ́be rì. ");
INSERT INTO log_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Gò mvá tùgu ró dhɨ dré tàzoá áyɨ atá dré dhɨ: ‹Tátá, mɨ́ afè má dré ngá má dré kɨtswálé kisúlé ámɨ tàyɨlé ro dhɨ ɨ.› Dɨ akódhɨ nɨ atá dré tàyɨlé nda nɨ lanzɨ́zó àyɨ dré kàyo nɨ be. ");
INSERT INTO log_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Gí ko, mvá tùgu nda dré áyɨ ngá títí nda kɨ lagɨ́zó, làfa nɨ nɨ dòzo lɨ̀zo ába làwú làvo na. Kònàle dhɨ, dré ngàzo tatsílé tà swà ꞌobe, làfa ɨ́na nɨ kɨzázó. ");
INSERT INTO log_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Kòkɨzá ngá nda akɨ́lé títí dre dhɨ, kàrábhò dré dhèzo bvò nda na gò, ngá dré kɨtswálé nyàle dhɨ dré vélé adrézó yókódhó. ");
INSERT INTO log_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Dɨ dré ngàzo lɨ̀le àzí lizí ꞌòle bhàmvá àlo bvò nda lé dhɨ véna. Gò bhàmvá nda dré akódhɨ nɨ mùzo lɨ̀le áyɨ amvú na adrélé áyɨ tɨ̀gá kɨ lɨkɨ́. ");
INSERT INTO log_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Mvá tùgu nda tá lovó ɨ́be tò mányàngá tɨ̀gá nda ɨ̀ dré tá adrélé nyàle dhɨ kɨ adózó nyàle. Dɨ, à fè tá drá ngá àlo dré kɨtswálé nyàle dhɨ ko. ");
INSERT INTO log_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Tà nda kòfɨ akódhɨ rú dre dhɨ, dré ngàzo kisùá ɨ́ léna dhɨ: ‹Áma atá nɨ àzibhá ángopɨ́ dhɨ ɨ mányàngá ɨ́be bǐ gò, má dré mána adrézó dràle tàbirí dré dhɨ? ");
INSERT INTO log_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Má nɨ nga nzɨ̀le áma atá bhàna gò, tàá drá dhɨ: Tátá, má ꞌo tàkonzɨ̀ Gìká rú, ɨ̀ndɨ̀ mɨ́ rú. ");
INSERT INTO log_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Kɨtswá vélé mɨ́ dré gòzo adrélé áma zi ámɨ mvá ro dhɨ ko. Mɨ́ kòdo vélé ma ngóró ámɨ àzibhá kɨ àlo tɨ́nɨ.› ");
INSERT INTO log_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Gò dré ngàzo láti do nzɨ̀zo áyɨ atá bhàna. Dré rè dhu adréràꞌa vwàvwà ro bhà rúsè dhɨ ꞌá dhɨ, atá nɨ dré akódhɨ nɨ nòzo, kɨzà dòzo áyɨ togó na akódhɨ nɨ tà sè gò, ràzo dhèle agá akódhɨ nɨ kamú. ");
INSERT INTO log_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Gò mvá tùgu nda dré tàzoá drá dhɨ: ‹Tátá, má ꞌo tàkonzɨ̀ Gìká rú, ɨ̀ndɨ̀ mɨ́ rú. Kɨtswá vélé mɨ́ dré gòzo adrélé áma zi ámɨ mvá ro dhɨ ko.› ");
INSERT INTO log_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Dɨ, atá nɨ dré ɨ́na tàzoá áyɨ màrábà ɨ dré dhɨ: ‹Mɨ̀ adó kánzò avélépi lavúlé dhɨ asólé akódhɨ rú mbèlè. Mɨ̀ adó tróŋó asólé drɨ́gá, kámókà kɨ adózó kpà tosólé pá. ");
INSERT INTO log_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Mɨ̀ asé tí ngbòlò dò ro dhɨ lìle, mà kònyaró gwányá lenzézó lavúlé. ");
INSERT INTO log_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Tàko ko, áma mvá kònɨ̀dhɨ drà tá ɨ́na dràdrà gò, dré gòzo adrɨ́lé! Avɨ̀ tá ɨ́na avɨ̀avɨ̀ gò, má dré gòzo kisúá!› Dɨ ɨ̀ dré kɨdhózó adrélé gwányá ꞌo. ");
INSERT INTO log_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Lókyá nda sè dhɨ, agó nda nɨ mvá kàyo tá amvú na. Dré tá adréràꞌa anzɨ́lé atsálé ànyɨ bhà làga dhɨ ꞌá dhɨ, dré lärí yìzo longó ɨ́be. ");
INSERT INTO log_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Dɨ dré màrábà kɨ àlo azízó gò, lizízóá tíá ngalè kònàle àdho tà ꞌɨ ya dhɨ. ");
INSERT INTO log_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Màrábà nda dré logózóá drá dhɨ: ‹Ámɨ adrúpi anzɨ́ nɨ̀ gò, ámɨ atá dré tí ngbòlò dò ro dhɨ nɨ ꞌòzo lìle, dré gòle akódhɨ nɨ kisú lɨ́ná dhɨ sè.› ");
INSERT INTO log_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Dɨ mvá kàyo nda nɨ togó dré ngàzo aswálé gò, dré ɨ́na fɨ̀ma dzó na dhɨ nɨ gàzo rè. Atá nɨ kòyi tà nda dre dhɨ, dré apfòzo akódhɨ nɨ ti lizí, kòfɨró be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Dɨ, mvá kàyo nda dré ɨ́na logózóá áyɨ atá dré dhɨ: ‹Mɨ́ nò rè ká! Kóná bǐ, má ꞌo àzí mɨ́ dré ámɨ màrábà tɨ́nɨ, ámɨ tòlɨ́ kɨ àlo ŋo àko ró. Dɨ, mɨ́ afè ndɨ̀ndɨ̀ má dré ndrǐ mvá àlo dhɨ, mà kònyaró lenzézó túmä́ní áma arúpi ɨ́be dhɨ ko. ");
INSERT INTO log_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Dɨ, ámɨ mváagó ámɨ ngá títí dhɨ kɨ kɨzálépi akɨ́lé tòkó zàràbhù kɨ tà dri kòdhɨ kànzɨ́ dre dhɨ, mɨ́ dré mɨ́na tí ngbòlò dò ro dhɨ nɨ ꞌòzo lìle drá!› ");
INSERT INTO log_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Atá nɨ gò tàá drá dhɨ: ‹Áma mvá, àma ngbú túmä́ní mɨ́ be. Ngá títí mána ɨ, mɨ́na ꞌɨ. ");
INSERT INTO log_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Dɨ, adré tá lèá dhɨ, mà kòꞌo gwányá lenzézó. Àngyá ko, ámɨ adrúpi kòdhɨ drà tá ɨ́na dràdrà gò, dré gòzo adrɨ́lé! Avɨ̀ tá ɨ́na avɨ̀avɨ̀ gò, mà dré gòzo kisúá!›» ");
INSERT INTO log_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Gò Yésu dré pɨ́dhɨ́gó kònɨ̀dhɨ nɨ pɨ̀zo áyɨ lebèbhá ɨ dré, tàzoá dhɨ: «Ngá líyí àlo dhɨ bhà tá dhya àlo adrélé áyɨ ngá kɨ lɨkɨ́. Gò à dré akódhɨ nda nɨ asíkìzo ngá líyí nda véna, tàzoá dhɨ: ‹Akódhɨ adré ámɨ ngá kɨ kɨzá.› ");
INSERT INTO log_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Dɨ ngá líyí nda dré akódhɨ nɨ azízó, lizízóá tíá dhɨ: ‹Tà má dré adrélé yìle ámɨ tà dri kòdhɨ, àdho tà ꞌɨ? Mɨ́ tà rè má dré, mɨ́ ꞌo àzí bhàle mɨ́ drɨ́gá dhɨ ngɨ́nɨ ya dhɨ ká! Àngyá ko, mɨ́ kɨtswá vélé adrélé áma ngá lɨkɨ́lépi ró ko.› ");
INSERT INTO log_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Dɨ ngá lɨkɨ́lépi nda dré ngàzo kisùá ɨ́ léna dhɨ: ‹Má nɨ ꞌòá ngɨ́nɨ? Tàko ko, áma mírì adré ꞌòle àzí kòndɨ nɨ tɨngá má drɨ́gásè. Áma rìnyí kɨtswá ɨ́na má dré amvú ꞌàzo dhɨ ko. Ngá zizì nɨ tá kpà adré má dri kanyò ro. ");
INSERT INTO log_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Má nì tà má dré dra ꞌòle dhɨ be, à kònɨ̀ dra àzí kòndɨ nɨ tɨngá má drɨ́gásè dhɨ, móndɨ́ ɨ̀ kòkaꞌìró ma dòle àyɨ véna dóro.› ");
INSERT INTO log_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Dɨ dré ngàzo móndyá áyɨ mírì nɨ màri ɨ́be àyɨ rú dhɨ kɨ azí àlo àlo títí. Gò dré lizízóá dhya drìdrì dhɨ tí dhɨ: ‹Áma mírì nɨ màri mɨ́ rú dhɨ ángopɨ́?› ");
INSERT INTO log_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Akódhɨ nda logó dhɨ: ‹Dò òlívè àdhya tsɨ́mangóro nyadhɨ-nzi.› Dɨ ngá lɨkɨ́lépi nda tà drá dhɨ: ‹Mɨ́ adó ámɨ wárágà, lɨrɨ́zó mbèlè tɨsɨ̀á dhɨ: nyadhɨ-rì-drì-mudrí.› ");
INSERT INTO log_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Gò dré lizízóá àzya nɨ tí dhɨ: ‹Mɨ, áma mírì nɨ màri mɨ́ rú dhɨ ángopɨ́?› Akódhɨ logó dhɨ: ‹Ngánò sákɨ̀ nyadhɨ-nzi.› Dɨ ngá lɨkɨ́lépi nda tà drá dhɨ: ‹Mɨ́ adó ámɨ wárágà tɨsɨ̀zoá dhɨ: nyadhɨ-su.› ");
INSERT INTO log_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Àmvolásà, mírì nda kòyi tà áyɨ ngá lɨkɨ́lépi gyǎgya ko nda dré ꞌòle dhɨ dre dhɨ, dré akódhɨ nɨ tà bhàzo kuru, dré tá tà ꞌòle tògyá sè dhɨ sè. Tàko ko, móndyá bvò kòndɨ àdhya ɨ̀ adré àyɨkya tà ꞌo tògyá sè àyɨ kòfalésè, móndyá ngádra àdhya kya kɨ lavú. ");
INSERT INTO log_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Má adré dɨ tàá àmɨ dré dhɨ: Mɨ̀ kàdré móndɨ́ kɨ ꞌo adrélé àmɨ kɨ arúpi ɨ ró làfa bvò kòndɨ àdhya sè, kɨtswálé làfa nda kònɨ̀ dra akɨ́ dhɨ, à kòkaꞌìró àmɨ fɨ̀le bhà dra adrébhá kóná vésè kólyá dhɨ ɨ ꞌásè be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Dhya ángùdhi kɨtswálépi adrélé kaꞌìle tà tsà sè dhɨ, a nɨ kókpà kɨtswá adrélé kaꞌìle tà kàdrɨ̀ sè. Dɨ, dhya adrélépi tà ꞌo gyǎgya tà tsà sè ko dhɨ, a kɨtswá kókpà tà ꞌo gyǎgya tà kàdrɨ̀ sè ko. ");
INSERT INTO log_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Dɨ mɨ̀ kòkɨtswá adrélé kaꞌìle ngá bvò kòndɨ àdhya sè ko dhɨ, àdhi nɨ àmɨ kɨ kaꞌì, ngá tàndɨ bhù àdhya kɨ tayɨ́zó àmɨ drɨ́gá dhɨ nɨ̀? ");
INSERT INTO log_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Mɨ̀ kòkɨtswá kpà adrélé kaꞌìle ngá móndɨ́ àzya àdhya sè ko dhɨ, àdhi nɨ ngá fe àmɨ dré adrélé àmɨkya ró dhɨ nɨ̀? ");
INSERT INTO log_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Màrábà àlo dhɨ kɨtswá mírì rì dhɨ kɨ tà ꞌo lókyá àlo sè bwà ko. Tàko ko, kàdré ꞌòá kònɨ̀nɨ dhɨ, a nɨ àlo nɨ nɨ ga, adrézó àzya nɨ nɨ le. Kó ngalè, a nɨ tro àlo nɨ rú, adrézó àzya nɨ nɨ ayɨ́zè. Dɨ mɨ̀ kɨtswá adrélé Gìká nɨ tà ꞌo, adrézó kpà làfa nɨ tà ꞌo àyɨ kɨ màrábà tɨ́nɨ lókyá àlo sè bwà ko.» ");
INSERT INTO log_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Fàrìsáyò adrébhá tá làfa le tò dhɨ ɨ̀ kòyi tà nda ɨ títí dre dhɨ, ɨ̀ dré dhèzo adrélé Yésu nɨ gu. ");
INSERT INTO log_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Dɨ akódhɨ dré tàzoá àyɨ dré dhɨ: «Mɨ̀ adré àmɨkya àmɨ kɨ bha gyǎgya móndɨ́ ɨ kandrá dhɨ àmɨ. Dɨ, Gìká nì ɨ́na àmɨ kɨ togó be. Àngyá ko, tà móndɨ́ ɨ̀ dré adrélé bhàle kuru àyɨ kòfalé dhɨ, tà gàle gàgà dhɨ ꞌɨ Gìká mìlésè.» ");
INSERT INTO log_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","«À longó tá tà tɨsɨ̀le Mósè nɨ tátrɨ́trɨ́ kúlí na ɨ̀ndɨ̀ pròfétà kɨ búkù ɨ ꞌásè dhɨ ɨ, tsàle Yòwánɨ̀ Bàtísimò fèlepi nɨ lókyá ꞌá. Dɨ kɨdhólé lókyá nda sè dhɨ, à adré Rúbí Tanɨ Gìká nɨ Òpɨ̀ àdhya nɨ longó kòdhya gò, móndyá títí dhɨ ɨ̀ dré adrézó àyɨ kɨ rìnyí fe fɨ̀zo lána. ");
INSERT INTO log_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Dɨ, tágba dré adrézó kònɨ̀nɨ dhɨ, bhù ɨ bvò be dhɨ kɨ kɨtswá akɨ́lé mbèlè lavúlé tà mvá tsà tɨsɨ̀le tátrɨ́trɨ́ kúlí nda léna dhɨ rúsè. ");
INSERT INTO log_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Dhya ángùdhi áyɨ tòkó nɨ tɨngálépi gò gòzo tòkó àzya adó mòle dhɨ, adré ɨ́na múná tà ꞌo. Kòdhɨ ɨ́be dhɨ, dhya ángùdhi tòkó tɨngálé dre dhɨ nɨ adólépi mòle dhɨ, adré kpà múná tà ꞌo.» ");
INSERT INTO log_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yésu gò tàá dhɨ: «Agó àlo ngá líyí ro dhɨ tá be. Adré tá kɨ́tá aveave làgɨ́ kyàkyà dhɨ kɨ asó ɨ́ rú, adrézó ngá dóro nya, adrézó kpà lenzélé kìtú àlo àlo títí ɨ sè. ");
INSERT INTO log_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Dɨ, akódhɨ nda nɨ bhàꞌálé tí dhɨ, à la tá agó àlo lemerè ro rú be Làzárò, adrélépi làzɨ́ ɨ́be bǐ ɨ́ rú dhɨ. ");
INSERT INTO log_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Akódhɨ nda tá lovó ɨ́be tò kɨtswázó ngá kórònyá adrébhá tá ledhélé ngá líyí nda nɨ mɨ́sá drìlésè dhɨ kɨ nya ká. Dɨ, kɨtswá tá ɨ́na bwà ko. Kòkɨ́ ɨ̀ adré tá ndɨ̀ndɨ̀ alɨ̀le akódhɨ nɨ làzɨ́ kɨ mì lembé. ");
INSERT INTO log_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Kùdù ro dhɨ, agó lemerè ro nda dré dràzo gò, ángéló ɨ̀ dré akódhɨ nɨ dòzo lɨ̀zo bhàá ànyɨ Àbàrámà làga. Ngá líyí nda dré kókpà dràzo gò, sìzoá. ");
INSERT INTO log_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Akódhɨ kòkisú ɨ adréràꞌa rúbhá aswálé dràbhá kɨ àrà na dre dhɨ, dré mì tɨngázó Àbàrámà kɨ no làwú làvo na, túmä́ní Làzárò ànyɨ làgá dhɨ be. ");
INSERT INTO log_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Dɨ dré kúlí yòzo tàzoá dhɨ: ‹Tátá Àbàrámà, mɨ́ bhà áma kɨzà wà! Mɨ́ amù Làzárò áyɨ drɨ́gámbɨ́lɨ́ so yǐ na, tɨ̀le áma làdra dri. Àngyá ko, áma rúbhá adré aswálé àtsɨ́ kònɨ̀dhɨ ꞌá tò.› ");
INSERT INTO log_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Dɨ, Àbàrámà logó drá dhɨ: ‹Áma mvá, mɨ́ kisù rè ngá dóro títí mɨ́ dré tá kisúlé mɨ́ dré adréràꞌa lɨ́drɨ̀ be dhɨ ꞌá dhɨ ɨ ká. Dɨ, Làzárò kisú tá ngbà ꞌí tà kònzɨ dhɨ ɨ kòdhya. Nyànomvá dhɨ, à adré dɨ akódhɨ nɨ togó tɨndrɨ̀ kònwa. Dɨ, ámɨ rúbhá adré ɨ́na aswálé. ");
INSERT INTO log_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Kòdhɨ ɨ́be dhɨ, à bhà yábhu andre àma kɨ kòfalé ꞌá àmɨ ɨ́be dre. Ásà dhɨ, dhya adrélépi lèá lavúlé àmɨ véna dhɨ kɨtswá lavúlé bwà ko. À kɨtswá kpà azyálé kònalésè àma vélé dhɨ bwà ko.› ");
INSERT INTO log_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Dɨ ngá líyí nda tà dhɨ: ‹Tátá, kàdré kònɨ̀nɨ dhɨ, má adré ámɨ ti lizí, mɨ́ kòmùró Làzárò lɨ̀le áma atá nɨ dzó na, ");
INSERT INTO log_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","kòlongóró tà áma adrúpi nzi dhɨ ɨ dri, ɨ̀ kàlɨ̀ró kpà àrà rúbháaswa àdhya kònɨ̀dhɨ lé ko.› ");
INSERT INTO log_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Àbàrámà logó drá dhɨ: ‹Àyɨ tà Mósè ɨ̀ dré tɨsɨ̀le pròfétà ɨ́be dhɨ ɨ́be. Ɨ̀ kòyi tà nda ɨ kòdhya.› ");
INSERT INTO log_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Dɨ, ngá líyí nda tà dhɨ: ‹Kóko, Tátá Àbàrámà! Dɨ, dhya àlo ngàlepi dràdrà ꞌásè dhɨ kòlɨ̀ ɨ́na àyɨ véna dhɨ, ɨ̀ nɨ àyɨ kɨ togó ladzá.› ");
INSERT INTO log_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Dɨ, Àbàrámà tà drá dhɨ: ‹Ɨ̀ kòyi Mósè nɨ kúlí pròfétà kya ɨ́be dhɨ ɨ ko dhɨ, tágba dhya àlo kònga dràdrà lésè yà dhɨ, ɨ̀ kɨtswá kpà dhya nda nɨ kúlí yi kaꞌìzoá bwà ko.›» ");
INSERT INTO log_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yésu gò tàá áyɨ lebèbhá ɨ dré dhɨ: «Tà bàti ró dhɨ, tà kɨtswábhá móndɨ́ kɨ ꞌo ledhélé tàkonzɨ̀ na dhɨ kɨ dra atsá. Dɨ, kɨzà nɨ adré kàdrɨ̀ dhya ángùdhi adrélépi tà nda kɨ àndu bha dhɨ dré! ");
INSERT INTO log_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Akódhɨ nda kàdré ndɨ̀ndɨ̀ ànzɨmvá kònɨ kɨ àlo ꞌo dhèle tàkonzɨ̀ na dhɨ, dóro nɨ tá kɨ́rà kàdrɨ̀ ꞌɨ̀le akódhɨ kembé gò, akódhɨ nɨ bhèzo dràle yǐandre na dhɨ. ");
INSERT INTO log_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Dɨ mɨ̀ kàdré àmɨ kɨ lɨkɨ́ be! Ámɨ adrúpi kɨ àlo kòꞌo tàkonzɨ̀ mɨ́ rú dhɨ, mɨ́ kòtadhá akódhɨ nɨ tàkonzɨ̀ nda drá. Akódhɨ kòladzá áyɨ togó tà nda sè dhɨ, mɨ́ kòtrì akódhɨ nɨ tàkonzɨ̀. ");
INSERT INTO log_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Gba kòꞌo tàkonzɨ̀ mɨ́ rú vésè be nzi-drì-rì kìtú àlo sè gò, dré adrézó agòle mɨ́ vélé vésè àlo àlo títí nda ɨ sè adrélé tàá dhɨ ‹Má ladzá áma togó dre› dhɨ, mɨ́ kòtrì akódhɨ nɨ tàkonzɨ̀ nda ɨ títí.» ");
INSERT INTO log_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Àpóstolò ɨ̀ tà Mírì Yésu dré dhɨ: «Mɨ́ kòtɨmbà àma kɨ tà kaꞌìkaꞌì wà.» ");
INSERT INTO log_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Dɨ Mírì logó dhɨ: «Mɨ̀ kàdré tà kaꞌìkaꞌì ɨ́be tsàmvá ngóró mùtádì lòꞌwa tɨ́nɨ dhɨ, mɨ̀ nɨ kɨtswá tàá fa kàdrɨ̀ kònɨ̀dhɨ dré dhɨ ‹Mɨ́ ngɨ mɨ lɨ̀zo ámɨ bhe tɨ̀le yǐandre na› gò, fa nda dré àmɨ kɨ kúlí kaꞌìzo ꞌòle.» ");
INSERT INTO log_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","«Dhya àlo àmɨ kòfalé dhɨ kàdré màrábà adrélépi amvú ꞌa yà, kó ngalè adrélépi kábilígyà lɨkɨ́ yà dhɨ ɨ́be gò, akódhɨ nda dré agòzo amvú lésè dhɨ, dhya nda adré tàá drá ngɨ́nɨ? Adré tsì tàá drá dhɨ: ‹Mɨ́ afɨ́ mbèlè lɨrɨ́lé ngá nya›? ");
INSERT INTO log_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Kóko! Dɨ, adré be ɨ́na tàá dhɨ: ‹Mɨ́ ladhɨ́ ngá má dré kɨtswálé nyàle. Mɨ́ topfó ámɨ kɨ́tá, ngá bhàzo má dré nyàle ɨ̀ndɨ̀ má dré mvùle ꞌíká, gò mɨ́ kògòró mɨ́na nɨ nya, ɨ̀ndɨ̀ mɨ́na nɨ mvu ndò.› ");
INSERT INTO log_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Bvóá dhɨ, mírì nda adré tsì àwoyà ta màrábà nda dré, dré tà tàle ɨ́ dré dhɨ kɨ ꞌòle dhɨ sè ꞌí? Kóko! ");
INSERT INTO log_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Dɨ tà nda kòdhɨ kókpà kònɨ̀nɨ àmɨ dré. Mɨ̀ kòꞌo tà títí tàle àmɨ dré dhɨ ɨ dre dhɨ, mɨ̀ kàdré tàá dhɨ: ‹Àma màrábà tàko dhɨ ꞌɨ. Mà ꞌo ngbà ꞌí tà kɨtswábhá mà dré ꞌòle dhɨ ɨ kòdhya.›» ");
INSERT INTO log_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yésu dré tá adréràꞌa lɨ̀le Yèrúsalémà na dhɨ ꞌá dhɨ, adré tá lavúlé bvò Gàlìláyà àdhya kɨ bvó Sàmàrɨ́yà àdhya be dhɨ ꞌásè. ");
INSERT INTO log_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Dré tá adréràꞌa fɨ̀le bhà àlo na dhɨ ꞌá dhɨ, móndɨ́ mudrí kàrɨ́ dré rùle dhɨ ɨ̀ dré alɨ̀zo kɨtswálé ru kisú ába. Àyɨ nda ɨ̀ dré àyɨ kɨ kɨkɨ́zó vwàvwà ro tsà gò, ");
INSERT INTO log_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","kúlí loyó tàzoá dhɨ: «Yésu, Mírì, mɨ́ bhà àma kɨ kɨzà wà!» ");
INSERT INTO log_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yésu kònò àyɨ dre dhɨ, dré tàzoá dhɨ: «Mɨ̀ lɨ̀ àmɨ kɨ rúbhá kɨ tadhá kòwánà ɨ dré.» Dɨ ɨ̀ dré adréràꞌa lɨ̀le dhɨ ꞌá dhɨ, ɨ̀ dré adrɨ́zó. ");
INSERT INTO log_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Dɨ àyɨ kɨ àlo kònò ɨ́ adrɨ́ dre dhɨ dre dhɨ, dré agòzo Gìká nɨ rú bhabe kùle kúlí ꞌuꞌù sè. ");
INSERT INTO log_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Dré adhézó Yésu pá, áyɨ mì bha kìní mi gò, àwoyà tàzo drá tà dré tá ꞌòle ɨ́ dré nda nɨ tà sè. Dɨ akódhɨ nda tá ɨ́na Sàmàrɨ́yà agó ꞌɨ. ");
INSERT INTO log_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Gò Yésu dré lizízóá móndɨ́ ɨ́ làga dhɨ ɨ tí dhɨ: «Àyɨ adrɨ́bhá kòdhɨ ɨ tá tsì mudrí ko? Dɨ àruka nɨ nzi-drì-su nda ɨ ángwà? ");
INSERT INTO log_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Dhya àlo àyɨ kòfalé agòlepi Gìká nɨ rú bha kùle dhɨ yókódhó, ngbà ꞌí agó súrú twá ro kònɨ̀dhɨ ꞌɨ?» ");
INSERT INTO log_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Gò dré tàzoá agó nda dré dhɨ: «Mɨ́ nga lɨ̀le. Ámɨ tà kaꞌìkaꞌì tɨdrɨ́ mɨ dre.» ");
INSERT INTO log_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Kìtú àlo dhɨ, Fàrìsáyò ɨ̀ lizí tá Yésu tí dhɨ: «Gìká nɨ Òpɨ̀ nɨ atsá ángutú?» Dɨ Yésu logó àyɨ dré dhɨ: «Gìká nɨ Òpɨ̀ adré ɨ́na alɨ̀le ngóró móndɨ́ ɨ̀ dré adrélé ngá letè nòle dhɨ tɨ́nɨ ko. ");
INSERT INTO log_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","À kɨtswá kpà tàá dhɨ ‹Mɨ̀ nò ká, Gìká nɨ Òpɨ̀ kònwa!› yà, kó ngalè ‹Gìká nɨ Òpɨ̀ kònàle!› yà dhɨ ko. Tàko ko, Gìká nɨ Òpɨ̀ àmɨ kòfalé be.» ");
INSERT INTO log_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Dré gòzo tàá áyɨ lebèbhá ɨ dré dhɨ: «Lókyá adrélépi alɨ̀le dhɨ sè dhɨ, mɨ̀ nɨ adré lovó ɨ́be tò kɨtswázó ndɨ̀ndɨ̀ Móndɨ́ nɨ Mvá nɨ kìtú kɨ àlo no. Dɨ, mɨ̀ kɨtswá àmɨkya nòá ko. ");
INSERT INTO log_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Móndɨ́ kɨ tàá àmɨ dré dhɨ ‹Mɨ̀ nò ká, akódhɨ kònàle!› yà, kó ngalè ‹Akódhɨ kònwa!› yà dhɨ. Dɨ, mɨ̀ lɨ̀ àmɨkya ràle àyɨ vésè ko. ");
INSERT INTO log_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Tàko ko, kìtú Móndɨ́ nɨ Mvá dré dra agòzo dhɨ tú dhɨ, a nɨ agò ngóró bhù dré adrélé lagúlé ngá kazá bhù mìbhalé nɨ bvó àlo lésè tsàle bvó nɨ àzya na dhɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Dɨ, adré lèá dhɨ, akódhɨ kònya rè zyà kɨzà lavúlé, ɨ̀ndɨ̀ móndyá ándrò kònɨ ɨ̀ kògà rè zyà akódhɨ. ");
INSERT INTO log_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Lókyá Móndɨ́ nɨ Mvá dré adréràꞌa ꞌòle agòle dhɨ ꞌá dhɨ, tà kɨ adré ngóró Nówè nɨ lókyá ꞌá dhɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Móndɨ́ ɨ̀ adré tá àyɨkya ngá nya, adrézó ngá mvu, adrézó ru mo, adrézó àyɨ kɨ ànzɨ kɨ fe mòle, tsàle kìtú Nówè dré fɨràꞌa bwátù kàdrɨ̀ na dhɨ ꞌá. Gò yǐ lìti andre dré atsázó ngbǒ ró àyɨ kɨ tupfú todràle títí. ");
INSERT INTO log_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Tà nda kɨ adré kpà ngóró Lótò nɨ lókyá ꞌá dhɨ tɨ́nɨ. Móndɨ́ ɨ̀ adré tá àyɨkya ngá nya, adrézó ngá mvu, adrézó ngá gɨ, adrézó ngá lagɨ́, adrézó ngá kidhí, adrézó kpà dzó si. ");
INSERT INTO log_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Dɨ, kìtú Lótò dré apfòzo Sòdómà lésè dhɨ sè dhɨ, àtsɨ́ ɨ bàrútì ɨ́be dhɨ ɨ̀ dré adàzo ngbǒ ró bhù lésè àyɨ kɨ tupfú todràle títí. ");
INSERT INTO log_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Tà nda kòdhɨ kɨ adré kókpà kònɨ̀nɨ kìtú Móndɨ́ nɨ Mvá dré dra apfòzo dhɨ tú. ");
INSERT INTO log_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Kìtú nda sè dhɨ, lè dhya dra adrélépi áyɨ dzó drìna dhɨ kàsí fɨ̀le dzó na, áyɨ ngá kɨ do lapázó ába dhɨ ko. Kókpà kòdhɨ tɨ́nɨ, dhya dra adrélépi amvú na dhɨ kògò nzɨ̀le ɨ́ bhàna ko. ");
INSERT INTO log_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Mɨ̀ kisù rè tà atsálépi Lótò nɨ tòkó rú dhɨ ká! ");
INSERT INTO log_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Dhya ángùdhi adrélépi áyɨ tàndɨ nɨ lɨ́drɨ̀ le lɨkɨ́lé dhɨ, a nɨ áyɨ lɨ́drɨ̀ nda nɨ ꞌo avɨ̀le. Dɨ, dhya ángùdhi adrélépi ɨ́na áyɨ lɨ́drɨ̀ fe dhɨ, a nɨ áyɨ lɨ́drɨ̀ nda nɨ lɨkɨ́. ");
INSERT INTO log_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Má adré tàá àmɨ dré dhɨ: Ngátsi nda sè dhɨ, móndɨ́ rì dhɨ kɨ adré ayílé lángá àlo dri. À nɨ àlo nɨ nɨ do, àzya nɨ nɨ tayɨ́. ");
INSERT INTO log_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Tòkó rì dhɨ kɨ adré ngá ꞌi túmä́ní. À nɨ àlo nɨ nɨ do, àzya nɨ nɨ tayɨ́.»  ");
INSERT INTO log_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Yésu nɨ lebèbhá ɨ̀ gò lizíá dhɨ: «Mírì, tà nda kɨ ru ꞌo ángolé?» Dɨ Yésu logó àyɨ dré dhɨ: «Àrà ángùdhi àbvò dré adrézó lána dhɨ drìle dhɨ, àrɨ́ àgáàga dhɨ kɨ kókpà ru kɨmó kɨtswálé àbvò nda nɨ te.» ");
INSERT INTO log_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Gò Yésu dré pɨ́dhɨ́gó kònɨ̀dhɨ nɨ pɨ̀zo, tadházóá áyɨ lebèbhá ɨ dré dhɨ, lè ɨ̀ kàdré tà zi Gìká tí landè àko ró ngɨ́nɨ ya dhɨ. ");
INSERT INTO log_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Tà dhɨ: «Tàbvó tàlepi àlo dhɨ tá bhàandre àlo dhɨ na. Adré tá ɨ́na Gìká nɨ ro ko, adrézó kpà móndɨ́ kɨ tà kisù ko. ");
INSERT INTO log_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Dɨ tàyɨ́tòkó àlo bhàandre nda ꞌá dhɨ adré tá ɨ́na alɨ̀le akódhɨ vélé rä, adrélé tàá dhɨ: ‹Mɨ́ lanzɨ́ rè tà àma kòfalé áma kàrɨbhá be dhɨ nɨ bvó, tà gyǎgya ꞌòzo má dré dhɨ ká!› ");
INSERT INTO log_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Lókyá be vwàvwà ro dhɨ, tàbvó tàlepi nda adré tá tà nda nɨ ga rè. Dɨ, kùdù ro dhɨ, dré ɨ́na kisùzoá ɨ́ léna dhɨ: ‹Gba má dré adrézó Gìká nɨ ro ko yà, adrézó kpà móndɨ́ kɨ tà kisù ko yà dhɨ, ");
INSERT INTO log_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","má nɨ tà gyǎgya ꞌo tàyɨ́tòkó kòdhɨ dré, dré adrélé áma lagù tò dhɨ sè. Tàko ko, má kòꞌo kònɨ̀nɨ ko dhɨ, akódhɨ nɨ ngbú adrélé alɨ̀le áma drì kɨzá.›» ");
INSERT INTO log_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Dɨ Mírì gò tàá dhɨ: «Mɨ yi rè tà tàbvó tàlepi gyǎgya ko nda dré tàle dhɨ ká. ");
INSERT INTO log_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Dɨ Gìká kɨtswá tsì tà gyǎgya ꞌo móndyá ɨ́ dré zɨ̀le gò ɨ̀ dré adrézó liyílé ɨ́ rú kìtú vésè ɨ̀ndɨ̀ ngátsi vésè dhɨ ɨ dré ko? A nɨ tsì lókyá tigí àyɨ kɨ ledézó? ");
INSERT INTO log_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Má adré tàá àmɨ dré dhɨ: A nɨ tà gyǎgya ꞌo àyɨ dré mbèlè. Dɨ, lókyá Móndɨ́ nɨ Mvá dré dra agòzo dhɨ tú dhɨ, a nɨ tsì móndyá adrébhá áyɨ kaꞌì bàti dhɨ kɨ kisú bvò dri dhɨ ꞌí?» ");
INSERT INTO log_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Gò Yésu dré pɨ́dhɨ́gó kònɨ̀dhɨ nɨ pɨ̀zo móndyá adrébhá tá àyɨ kɨ no gyǎgya gò, adrézó móndyá àruka títí dhɨ kɨ ayɨ́zè dhɨ ɨ dré. ");
INSERT INTO log_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Tà dhɨ: «Àgo rì dhɨ ɨ̀ mbà tá tépelò na kɨtswálé tà ta Gìká be. Àlo nɨ tá Fàrìsáyò ꞌɨ. Àzya nɨ tá mèdáyɨ̀ lagɨ́lépi ꞌɨ. ");
INSERT INTO log_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Dɨ Fàrìsáyò nda totó tá ɨ adrélé tà ta Gìká be ɨ́ léna kònɨ̀nɨ: ‹Á! Gìká, má adré àwoyà ta mɨ́ dré, má dré adrélé móndyá àruka títí dhɨ ɨ tɨ́nɨ ko dhɨ sè. Àyɨ nda ɨ ngá lovó bhabhá ꞌɨ, tà kònzɨ ꞌobhá ꞌɨ, ɨ̀ndɨ̀ múná tà ꞌobhá ꞌɨ. Má adré kpà àwoyà ta mɨ́ dré, má dré adrélé mèdáyɨ̀ lagɨ́lépi kòdhɨ tɨ́nɨ ko dhɨ sè. ");
INSERT INTO log_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Má adré mána tàbirí mvo, adrézó tà zi mɨ́ tí vésè be rì pósò àlo sè. Má adré kpà ngá títí má dré adrélé kisúlé, lanzɨ́lé ꞌa be mudrí dhɨ kɨ àlo fe mɨ́ dré.› ");
INSERT INTO log_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Dɨ, mèdáyɨ̀ lagɨ́lépi nda totó tá ɨ́na ɨ lárá ro, adrélé ndɨ̀ndɨ̀ áyɨ mì le tɨngálé kurú na bhù na ko. Adré tá áyɨ agá di kɨzà dré, adrézó tàá dhɨ: ‹Á! Gìká, ma tàkonzɨ̀ líyí ꞌɨ. Mɨ́ bhà áma kɨzà wà!› ");
INSERT INTO log_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Má adré tàá àmɨ dré dhɨ: Mèdáyɨ̀ lagɨ́lépi nda gò ɨ́na nzɨ̀le ɨ́ bhàna móndɨ́ Gìká dré bhàle gyǎgya dhɨ ró dhɨ nɨ̀. Dɨ, Fàrìsáyò nda nzɨ ɨ́na kònɨ̀nɨ ko. Tàko ko, Gìká nɨ dhya ángùdhi adrélépi áyɨ tà bha kuru dhɨ nɨ tà tɨrɨ́ kìní mi. Dɨ, a nɨ dhya adrélépi áyɨ tà bha kìní mi dhɨ nɨ tà tɨngá kuru.» ");
INSERT INTO log_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Àmvolásà dhɨ, móndɨ́ ɨ̀ adré tá àyɨ kɨ ànzɨmvá kɨ adó alɨ̀zo àyɨ ɨ́be Yésu vélé, kòtabèró àyɨ, tà tanɨ zìzo Gìká tí àyɨ dri be dhɨ bvó. Akódhɨ nɨ lebèbhá ɨ̀ kònò tà nda dre dhɨ, ɨ̀ dré dhèzo adrélé lawàle móndyá nda ɨ dri tà nda sè. ");
INSERT INTO log_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Dɨ, Yésu dré ɨ́na ànzɨmvá nda kɨ azízó ɨ́ vélé gò, tàzoá áyɨ lebèbhá ɨ dré dhɨ: «Mɨ̀ tayɨ́ ànzɨmvá kònɨ ɨ alɨ̀le má vélé. Mɨ̀ logá àyɨ ko. Àngyá ko, Gìká nɨ Òpɨ̀ móndyá adrébhá àyɨ nda ɨ tɨ́nɨ dhɨ ɨ dré. ");
INSERT INTO log_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Má adré tà bàti ta àmɨ dré: Dhya ángùdhi adrélépi Gìká nɨ Òpɨ̀ kaꞌì ànzɨmvá kya tɨ́nɨ ko dhɨ, kɨtswá tàdzí fɨ̀le lána ko.» ");
INSERT INTO log_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Àmvolásà dhɨ, Yúdà ànzɨ kɨ kàdrɨ̀ kɨ àlo dré alɨ̀zo Yésu vélé akódhɨ nɨ lizí, tàzoá dhɨ: «Dhya dóro adrélépi tà tadhá nɨ, lè má kòꞌo àdho tà kòdhya kɨtswázó lɨ́drɨ̀ kóná vésè kólyá dhɨ nɨ kisú dhɨ?» ");
INSERT INTO log_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yésu logó drá dhɨ: «Mɨ́ adré áma zi dhya dóro dhɨ ró àdho tà sè? Dhya adrélépi dóro dhɨ yókódhó, ngbà ꞌí Gìká ꞌɨ kalóma. ");
INSERT INTO log_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Mɨ́ nì tà tátrɨ́trɨ́ kúlí dré adrélé tàle à kòꞌo dhɨ ɨ be: ‹Lè mɨ́ kòꞌo múná tà ko. Mɨ́ kòpfu móndɨ́ dràle ko. Mɨ́ kòkugù ngá ko. Mɨ́ kòtà tà móndɨ́ rú kɨnzò sè ko. Mɨ́ kàdré ámɨ atá nɨ lɨndrɨ̀ bha ámɨ andre be.›» ");
INSERT INTO log_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Dɨ agó nda tà drá dhɨ: «Má lɨkɨ́ tòlɨ́ nda kòdhɨ ɨ títí, kɨdhólé má dré tá adréràꞌa kàdhúrà ro dhɨ ꞌá.» ");
INSERT INTO log_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yésu kòyi tà nda dre dhɨ, dré tàzoá drá dhɨ: «Tayɨ́ rè dhu mɨ́ dré tà àlo kòdhya: Mɨ́ lɨ̀ ámɨ ngá títí dhɨ kɨ lagɨ́, làfa nɨ nɨ lanzɨ́zó lemerèbhá ɨ dré gò, mɨ́ kàdréró ngá làgɨ́ be kàdrɨ̀ dhɨ ɨ́be bhù na. Dɨ mɨ́ alɨ̀ adrélé áma lebè.» ");
INSERT INTO log_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Agó nda kòyi tà nda dre dhɨ, kɨzà dré akódhɨ nɨ ꞌòzo lavúlé, dré tá adrélé ngá ɨ́be zyandre ró dhɨ sè. ");
INSERT INTO log_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yésu kònò akódhɨ tá kɨzà ro dhɨ dre dhɨ, dré tàzoá dhɨ: «Ngábhá kɨ fɨ̀ma Gìká nɨ Òpɨ̀ na dhɨ kòkóròko! ");
INSERT INTO log_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ngá líyí nɨ fɨ̀ma Gìká nɨ Òpɨ̀ na dhɨ ɨ́na kòkóròko lavúlé, kàmílò nɨ fɨ̀ma lavúlé sìndánì nɨ bhálé ꞌásè dhɨ rúsè!» ");
INSERT INTO log_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Gò móndyá kúlí nda kɨ yibhá dhɨ ɨ̀ dré lizízóá dhɨ: «Kàdré kònɨ̀nɨ dhɨ, àdhi nɨ dɨ kɨtswá lɨ́drɨ̀ kóná vésè kólyá dhɨ nɨ kisú nɨ̀?» ");
INSERT INTO log_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yésu logó dhɨ: «Tà kɨtswálé ꞌòle bwà ko móndɨ́ ɨ mìlésè dhɨ, tà Gìká dré kɨtswálé ꞌòle nɨ̀ dhɨ ꞌɨ.» ");
INSERT INTO log_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Gò Pétèró dré tàzoá drá dhɨ: «Mɨ́ nò rè ká! Mà tayɨ́ àma kɨ ngá títí dhɨ ɨ adrézó ámɨ lebè.» ");
INSERT INTO log_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Dɨ Yésu logó àyɨ dré dhɨ: «Má adré tà bàti ta àmɨ dré: Dhya ángùdhi áyɨ dzó ꞌɨ yà, áyɨ tòkó ꞌɨ yà, áyɨ adrúpi ɨ ꞌɨ yà, áyɨ tibhá ɨ ꞌɨ yà, kó ngalè áyɨ ànzɨ ɨ ꞌɨ yà dhɨ kɨ tayɨ́lépi Gìká nɨ Òpɨ̀ nɨ tà sè dhɨ, ");
INSERT INTO log_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","a nɨ ngá nda kɨ vúdrì kisú tsàle vésè be bǐ lókyá kònɨ̀dhɨ sè. Kòdhɨ ɨ́be dhɨ, a nɨ kókpà lɨ́drɨ̀ kóná vésè kólyá dhɨ nɨ kisú lókyá adrélépi alɨ̀le dhɨ sè.» ");
INSERT INTO log_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Àmvolásà dhɨ, Yésu dré áyɨ lebèbhá mudrí-drì-rì dhɨ kɨ drìzo gàrà dri gò, tàzoá àyɨ dré dhɨ: «Mɨ̀ yi rè ká! Mà adré mbàle Yèrúsalémà na. Kònàle dhɨ, tà títí pròfétà ɨ̀ dré tɨsɨ̀le Móndɨ́ nɨ Mvá nɨ tà dri dhɨ kɨ ru ꞌo. ");
INSERT INTO log_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","À nɨ akódhɨ nɨ lefè pàgánò ɨ drɨ́gá. Àyɨ nda ɨ̀ dré akódhɨ nɨ gùzo, lodházóá, tùsú lufúzó mìá, ");
INSERT INTO log_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","tswàzoá gò, pfùzoá dràle. Dɨ kìtú nɨ na sè dhɨ, dré ngàzo dràdrà ꞌásè.» ");
INSERT INTO log_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Dɨ, tà Yésu dré tàle nda kɨ àlo fɨ tá ɨ́na àyɨ drìna ko. Tà nda kɨ àndu zù tá ɨ zùzù àyɨ dré. Dɨ ɨ̀ nì ngalè Yésu adré tá àdho tà ta ya dhɨ ko. ");
INSERT INTO log_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yésu dré tá adréràꞌa tsàle ànyɨ Yèríkò làga dhɨ ꞌá dhɨ, agó àlo mì kùdúkùdu ró dhɨ lɨrɨ́ tá láti làga adrélé ngá zi móndɨ́ ɨ tí. ");
INSERT INTO log_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Akódhɨ nda kòyi móndɨ́ zyandre ɨ adréràꞌa lavúlé dre dhɨ, dré lizízóá ngalè tà nda àdho tà ꞌɨ ya dhɨ. ");
INSERT INTO log_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Gò logózóá drá dhɨ: «Yésu Nàzàrétà lésè dhɨ adré lavúlé nɨ̀.» ");
INSERT INTO log_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Kòyi tà nda dre dhɨ, dré ngàzo adrélé loyóá dhɨ: «Yésu, Dàwídì nɨ Mvá, mɨ́ bhà áma kɨzà wà!» ");
INSERT INTO log_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Móndyá adrébhá lavúlé drìdrì dhɨ ɨ̀ dré adrézó tetrélé akódhɨ dri, kòtayɨ́ró kúlí adrézó kɨ́rɨ. Dɨ, dré gòzo vélé adrélé kúlí loyó wáláká nɨ nɨ lavú: «Dàwídì nɨ Mvá, mɨ́ bhà áma kɨzà wà!» ");
INSERT INTO log_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Gò Yésu dré áyɨ kɨkɨ́zó tàá dhɨ, à kàdrì agó nda alɨ̀zo ába ɨ́ vélé. Akódhɨ nda kàtsá ànyɨ dre dhɨ, Yésu dré lizízóá tíá dhɨ: ");
INSERT INTO log_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«Mɨ́ adré lèá má kòꞌo mɨ́ dré àdho tà kòdhya?» Akódhɨ logó dhɨ: «Mírì, má lè ngá nòle!» ");
INSERT INTO log_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Dɨ Yésu tà drá dhɨ: «Mɨ́ kònò ngá. Ámɨ tà kaꞌìkaꞌì tɨdrɨ́ mɨ dre.» ");
INSERT INTO log_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Gbǎ kòdhwa, akódhɨ dré kɨdhózó adrélé ngá no. Gò dré ngàzo adrélé Yésu nɨ lebè adrézó Gìká nɨ rú bha kùle. Móndyá títí dhɨ ɨ̀ kònò tà nda dre dhɨ, ɨ̀ dré kpà adrézó Gìká nɨ rú bha kùle. ");
INSERT INTO log_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yésu dré fɨ̀zo Yèríkò na gò adrélé lavúlé bhàandre nda ꞌásè. ");
INSERT INTO log_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Dɨ agó àlo rú be Zàkáyò, adrélépi mèdáyɨ̀ lagɨ́bhá kɨ kàdrɨ̀ ro ɨ̀ndɨ̀ ngá líyí ro dhɨ tá kpà bhàandre nda na be. ");
INSERT INTO log_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Akódhɨ nda adré tá lèá nòle ngalè Yésu àdhi ꞌɨ ya dhɨ. Dɨ, móndɨ́ zyandre dhɨ kɨ tà sè dhɨ, kɨtswá tá ɨ́na nòá bwà ko, dré tá mbàle tàli dhɨ sè. ");
INSERT INTO log_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Gò dré ràzo drìdrì mbàle fa rú be sìkòmórò dhɨ drìna, kɨtswálé Yésu nɨ no dhɨ bvó. Tàko ko, akódhɨ nda adré tá ꞌòle lavúlé láti nda ꞌásè. ");
INSERT INTO log_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yésu kàtsá àrà nda ꞌá dre dhɨ, dré mì tɨngázó Zàkáyò nɨ no gò, tàzoá drá dhɨ: «Zàkáyò, mɨ́ así mbèlè. Àngyá ko, adré lèá dhɨ, má kàyí ándrò mɨ́ bhàna.» ");
INSERT INTO log_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Dɨ Zàkáyò dré asízó mbèlè gò, dré Yésu nɨ kaꞌìzo dòle ɨ́ bhàna arɨ́ sè. ");
INSERT INTO log_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Móndyá títí tà nda nɨ nobhá dhɨ ɨ̀ adré tá Yésu nɨ ndrɨ, adrézó tàá dhɨ: «Dhya kòdhɨ lɨ̀ ɨ́na fɨ̀le ayílé tàkonzɨ̀ líyí nɨ dzó na!» ");
INSERT INTO log_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Dɨ, Zàkáyò dré ngàzo áyɨ totó Mírì kandrá tàá drá dhɨ: «Mírì, mɨ́ nò rè ká! Má nɨ áma ngá títí lanzɨ́lé ꞌa be rì dhɨ kɨ àlo fe lemerèbhá ɨ dré. Kòdhɨ ɨ́be dhɨ, má kòkärí móndɨ́ nɨ làfa túrúpfú sè dhɨ, má nɨ làfa nda nɨ logó drá, àzya nɨ nɨ bhàzo drìá vésè be na.» ");
INSERT INTO log_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Dɨ Yésu tà drá dhɨ: «Ándrò, tà tɨdrɨ́zó dhɨ afɨ́ dzó kònɨ̀dhɨ lé dre. Tàko ko, dhya kònɨ̀dhɨ kókpà Àbàrámà nɨ ànzɨ kɨ àlo ꞌɨ. ");
INSERT INTO log_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Àngyá ko, Móndɨ́ nɨ Mvá alɨ̀ kɨtswálé móndyá avɨ̀bhá dhɨ kɨ nda, àyɨ kɨ tɨdrɨ́zó dhɨ bvó.» ");
INSERT INTO log_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Móndyá zyandre nda ɨ̀ dré tá adréràꞌa Yésu nɨ yi dhɨ ꞌá dhɨ, dré gòzo pɨ́dhɨ́gó àlo dhɨ nɨ pɨ àyɨ dré. Tàko ko, akódhɨ tá ànyɨ Yèrúsalémà làga, ɨ̀ndɨ̀ ɨ̀ adré tá àyɨkya kisùá dhɨ, Gìká nɨ Òpɨ̀ nɨ atsá gbǎ lókyá nda sè. ");
INSERT INTO log_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Dɨ tà àyɨ dré dhɨ: «Agó àlo ópɨ́ kɨ súrú lésè dhɨ adré tá ꞌòle lɨ̀le bvò vwàvwà ro dhɨ na, à kòbhàró ɨ adrélé ópɨ́ ro gò, ɨ́ kàgòró adrélé áyɨ òpɨ̀ nya be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Dɨ dré áyɨ màrábà mudrí dhɨ kɨ azízó, làfa lòꞌwa mudrí dhɨ kɨ lanzɨ́zó àlo àlo àyɨ drɨ́gásè gò, tàzoá àyɨ dré dhɨ: ‹Mɨ̀ kàdré àzí ꞌo làfa kònɨ̀dhɨ sè adrézó tɨmbàá, tsàle lókyá má dré dra agòzo dhɨ ꞌá.› ");
INSERT INTO log_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Dɨ, móndyá akódhɨ nɨ bvò nda lé dhɨ ɨ̀ adré tá àyɨkya togó kònzɨ bha akódhɨ rú. Gò ɨ̀ dré móndɨ́ mùzo lɨ̀le akódhɨ vésè tàá dhɨ: ‹Mà adré lèá dhɨ, dhya kòdhɨ kònya òpɨ̀ àma dri dhɨ ko.› ");
INSERT INTO log_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Dɨ, tágba kònɨ̀nɨ dhɨ, à dré akódhɨ nɨ bhàzo ópɨ́ ro gò, dré agòzo. Dré màrábà mudrí ɨ́ dré tá làfa tayɨ́zó àyɨ drɨ́gá nda kɨ azízó gò, àyɨ kɨ lizízó nìzoá ngalè ɨ̀ tɨmbà tá áyɨ làfa nɨ drì ángopɨ́ ya dhɨ. ");
INSERT INTO log_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Dhya drìdrì dhɨ kàtsá dre dhɨ, dré tàzoá dhɨ: ‹Mírì, má ꞌo àzí làfa lòꞌwa mɨ́na sè gò, làfa lòꞌwa mudrí àruka kɨ kisúzó bhàle drìá.› ");
INSERT INTO log_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Dɨ ópɨ́ nda tà drá dhɨ: ‹Áma màrábà dóro nɨ, mɨ́ ꞌo dóro! Mɨ́ dré kɨtswálé má dré kaꞌìle tà mvá tsà sè dhɨ sè dhɨ, má nɨ ámɨ bha adrélé bhàandre mudrí dhɨ ɨ drìle.› ");
INSERT INTO log_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Gò màrábà nɨ rì dré atsázó tàá dhɨ: ‹Mírì, má ꞌo àzí làfa lòꞌwa mɨ́na sè gò, làfa lòꞌwa nzi àruka kɨ kisúzó bhàle drìá.› ");
INSERT INTO log_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Dɨ ópɨ́ nda tà drá dhɨ: ‹Má nɨ ámɨ bha adrélé bhàandre nzi dhɨ ɨ drìle.› ");
INSERT INTO log_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Gò màrábà nɨ na dré atsázó tàá dhɨ: ‹Mírì, làfa lòꞌwa mɨ́na kònɨ̀dhɨ. Má zù tá làfa nda tayɨ́lé kɨ́tá na. ");
INSERT INTO log_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Má adré tá ámɨ ro, mɨ́ dré adrélé agó tòmbá ꞌɨ dhɨ sè. Mɨ́ adré mɨ́na ngá mɨ́ dré bhàle ko dhɨ kɨ do, adrézó kpà ngá mɨ́ dré kidhílé ko dhɨ kɨ akónà.› ");
INSERT INTO log_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Dɨ ópɨ́ nda tà drá dhɨ: ‹Mɨ, màrábà kònzɨ nɨ, má nɨ ámɨ tàbvó ta ámɨ tàndɨ nɨ kúlí sè. Mɨ́ nì tá tàle dhɨ, ma agó tòmbá ꞌɨ dhɨ be. Má adré ngá má dré bhàle ko dhɨ kɨ adó, adrézó ngá má dré kidhílé ko dhɨ kɨ akónà. ");
INSERT INTO log_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Mɨ́ bhà dɨ tá làfa mána dzó adrézó làfa ꞌo lendrélé dhɨ na ko àdho tà sè? Kònò má nɨ tá kɨtswá làfa nda nɨ adó àmupi nɨ be.› ");
INSERT INTO log_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Gò dré tàzoá móndɨ́ ɨ́ làga dhɨ ɨ dré dhɨ: ‹Mɨ̀ do làfa lòꞌwa kòdhɨ akódhɨ drɨ́gásè, fèle dhya adrélépi ába mudrí dhɨ dré.› ");
INSERT INTO log_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Dɨ ɨ̀ tà drá dhɨ: ‹Mírì, akódhɨ nda làfa lòꞌwa ɨ́be mudrí!› ");
INSERT INTO log_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Akódhɨ logó àyɨ dré dhɨ: ‹Má adré tàá àmɨ dré dhɨ: Dhya ángùdhi adrélépi ngá ɨ́be dhɨ dré dhɨ, à nɨ akódhɨ nɨ ngá nda kɨ drì tɨmbà. Dɨ, kàdré ɨ́na dhya adrélépi ngá àko dhɨ nɨ tà sè dhɨ, à nɨ ndɨ̀ndɨ̀ ngá mvá tsà dré adrézó ába dhɨ nɨ do drɨ́gásà. ");
INSERT INTO log_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Dɨ, kàdré áma kàrɨbhá lèbhá tá má kònya òpɨ̀ àyɨ dri ko nda kɨ tà sè dhɨ, mɨ̀ adrì àyɨ alɨ̀zo àyɨ kɨ tilí todràle má kandrá.›» ");
INSERT INTO log_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yésu kòtà tà nda ɨ dre dhɨ, dré gòzo láti do adrézó mbàle Yèrúsalémà na. ");
INSERT INTO log_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Kòtsa ànyɨ bhà rú zìle Bètèfágè ɨ̀ndɨ̀ Bètànɨ́yà dhɨ ɨ kandrá, ànyɨ kòngó Òlívè fa kya làga dre dhɨ, dré áyɨ lebèbhá rì dhɨ kɨ mùzo lɨ̀le drìdrì, ");
INSERT INTO log_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","tàzoá àyɨ dré dhɨ: «Mɨ̀ lɨ̀ bhà àmɨ kandrá kònàdhɨ léna. Mɨ̀ kòfɨ lána dre dhɨ, mɨ̀ nɨ púndà mvá ꞌɨ̀le, à dré dhu rè mbàzo drìá ko dhɨ nɨ kisú. Mɨ̀ atrɨ̀ akódhɨ, alɨ̀zo ába má vélé. ");
INSERT INTO log_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Dhya àlo kòlizí àmɨ tí dhɨ: ‹Mɨ̀ adré trɨ̀á àdho tà sè?› ya dhɨ, mɨ̀ kòtà drá dhɨ: ‹Mírì adré lèá nɨ̀.›» ");
INSERT INTO log_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Dɨ dhya mùle nda ɨ̀ dré lɨ̀zo tà nda nɨ kisú ngóró Yésu dré tá tàle àyɨ dré dhɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ɨ̀ dré tá adréràꞌa púndà mvá nda nɨ atrɨ̀ dhɨ ꞌá dhɨ, púndà nda nɨ líyí ɨ̀ dré lizízóá àyɨ tí dhɨ: «Mɨ̀ adré púndà mvá kòdhɨ nɨ trɨ àdho tà sè?» ");
INSERT INTO log_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ɨ̀ logó dhɨ: «Mírì adré lèá nɨ̀.» ");
INSERT INTO log_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Gò ɨ̀ dré púndà mvá nda nɨ asézó atsázó ába Yésu vélé. Ɨ̀ dré àyɨ kɨ kɨ́tá bhèzo drìá gò, Yésu nɨ ꞌòzo lɨrɨ́lé drìá. ");
INSERT INTO log_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Dɨ akódhɨ dré tá adréràꞌa lɨ̀le dhɨ ꞌá dhɨ, móndɨ́ zyandre dhɨ ɨ̀ adré tá àyɨ kɨ kɨ́tá kɨ lasé láti mǐsè, kòlavúró drìásà be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ɨ̀ kòtsa ànyɨ Yèrúsalémà làga láti adrélépi sìle kòngó Òlívè fa kya drìlésè dhɨ ꞌá dre dhɨ, akódhɨ nɨ lebèbhá zyandre títí dhɨ ɨ̀ dré ngàzo adrélé lenzélé lúlúgyá be, adrézó Gìká nɨ rú bha kùle tà títí lɨ́ndrɨ́ga ró ɨ̀ dré nòle dhɨ kɨ tà sè. ");
INSERT INTO log_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ɨ̀ adré tá tàá dhɨ: «Tà tanɨ kàdré ópɨ́ adrélépi alɨ̀le Mírì nɨ rú sè dhɨ dri! Tà kɨ̀drɨ́kɨ̀drɨ kàdré bhù na, ɨ̀ndɨ̀ rúku kàdré Gìká kurú na bhù na dhɨ dré!» ");
INSERT INTO log_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Gò Fàrìsáyò àruka móndyá zyandre nda ɨ kòfalé dhɨ ɨ̀ dré tàzoá Yésu dré dhɨ: «Tadhálépi, mɨ́ kòlawà ámɨ lebèbhá nɨ ɨ dri, ɨ̀ kòtayɨ́ró kúlí!» ");
INSERT INTO log_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Dɨ Yésu logó dhɨ: «Má adré tàá àmɨ dré dhɨ: Ɨ̀ kòtayɨ́ kúlí dhɨ, kɨ́rà kɨ lúlúgyá ga nɨ̀!» ");
INSERT INTO log_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yésu kòtsa ànyɨ Yèrúsalémà làga bhàandre nda nɨ no dre dhɨ, dré ngàzo ngòle tà nɨ sè, ");
INSERT INTO log_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","tàzoá dhɨ: «Á! Yèrúsalémà, kònò mɨ́ kònì tá tà kɨtswálépi tá tà kɨ̀drɨ́kɨ̀drɨ fe mɨ́ dré lókyá ándrò kònɨ̀dhɨ sè dhɨ be dhɨ! Dɨ, nyànomvá dhɨ, tà nda zù ɨ zùzù mɨ́ dré. ");
INSERT INTO log_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Tàko ko, lókyá nɨ atsá ámɨ kɨ gò, ámɨ kàrɨbhá ɨ̀ dré ámɨ gàrà kɨ̀zo kúrú, ngá tobhàzo kɨtswázó àdzú bhu mɨ́ rú gò, ɨ̀ dré àdzú bhùzo mɨ́ be ámɨ gàrà títí dhɨ ɨ ꞌásè. ");
INSERT INTO log_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ɨ̀ nɨ àmɨ kɨ bhe kɨnyɨ́lé kìní mi, ámɨ ànzɨ mɨ́ lé dhɨ ɨ́be. Ɨ̀ kɨtswá kɨ́rà kɨ àlo tayɨ́ àzya nɨ dri ko. Àngyá ko, mɨ́ nì tá mɨ́na lókyá Gìká dré alɨ̀zo kɨtswálé ámɨ tɨdrɨ́ dhɨ ko.» ");
INSERT INTO log_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Àmvolásà dhɨ, Yésu dré fɨ̀zo tépelò na gò, dré ngàzo móndyá adrébhá tá ngá lagɨ́ kònàle dhɨ kɨ dro topfòle ꞌásà. ");
INSERT INTO log_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Dré tàzoá àyɨ dré dhɨ: «Gìká nɨ Kúlí adré tàá dhɨ: ‹Áma dzó nɨ adré dzó adrézó tà ta má be dhɨ ꞌɨ.› Dɨ, mɨ̀ gò àmɨkya dzó nda nɨ bha adrélé àrà kùgubhá ɨ̀ dré adrézó àyɨ kɨ zu dhɨ ró!» ");
INSERT INTO log_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Kìtú àlo àlo títí ɨ sè dhɨ, Yésu adré tá tà tadhá tépelò na. Kòwánà kàdrɨ̀ ɨ, tátrɨ́trɨ́ kúlí tadhábhá ɨ tsàle Yúdà ànzɨ kɨ drì kobhá ɨ́be dhɨ, ɨ̀ adré tá láti nda kɨtswázó akódhɨ nɨ pfu dràle. ");
INSERT INTO log_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Dɨ, ɨ̀ kɨtswá tá àyɨkya láti kisú bwà ko. Àngyá ko, móndyá títí dhɨ ɨ̀ adré tá akódhɨ nɨ kúlí yi lovó sè. ");
INSERT INTO log_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Kìtú àlo dhɨ, Yésu adré tá móndɨ́ kɨ tadhá tépelò na, adrézó Rúbí Tanɨ longó àyɨ dré. Gò kòwánà kàdrɨ̀ ɨ, tátrɨ́trɨ́ kúlí tadhábhá ɨ ɨ̀ndɨ̀ bhàgo ɨ́be dhɨ ɨ̀ dré alɨ̀zo akódhɨ vélé, ");
INSERT INTO log_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","lizíá tíá dhɨ: «Mɨ́ tà rè àma dré ká: Rìnyí mɨ́ dré adrézó tà kòdhɨ kɨ ꞌo dhɨ angá ɨ́na ángolésè? Àdhi fè rìnyí nda mɨ́ dré nɨ̀?» ");
INSERT INTO log_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yésu logó àyɨ dré dhɨ: «Má nɨ kókpà tà àlo dhɨ nɨ lizí àmɨ tí. Mɨ̀ tà rè má dré ká! ");
INSERT INTO log_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Bàtísimò Yòwánɨ̀ dré fèle dhɨ angá tá ɨ́na ángolésè: Gìká vélésè, kó ngalè móndɨ́ ɨ vélésè?» ");
INSERT INTO log_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Gò ɨ̀ dré dhèzo adrélé tà kayí àyɨ kòfalésè, adrézó tàá dhɨ: «Mà kòtà dhɨ ‹Bàtísimò nda angá Gìká vélésè› dhɨ, akódhɨ nɨ go lizíá àma tí dhɨ: ‹Mɨ̀ kaꞌì dɨ Yòwánɨ̀ ko àdho tà sè?› ");
INSERT INTO log_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Dɨ, mà kòtà kó dhɨ ‹Bàtísimò nda angá móndɨ́ ɨ vélésè› dhɨ, móndyá títí dhɨ kɨ àma kɨ lebhé todràle kɨ́rà sè. Àngyá ko, ɨ̀ adré kaꞌìá dhɨ, Yòwánɨ̀ tá ɨ́na pròfétà ꞌɨ.» ");
INSERT INTO log_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Dɨ ɨ̀ dré logózóá drá dhɨ: «Mà nì ngalè bàtísimò nda angá ángolésè ya dhɨ ko.» ");
INSERT INTO log_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yésu gò tàá àyɨ dré dhɨ: «Kàdré kònɨ̀nɨ dhɨ, má kɨtswá kókpà tàá àmɨ dré ngalè rìnyí má dré adrézó tà nda kɨ ꞌo dhɨ angá ángolésè ya dhɨ ko.» ");
INSERT INTO log_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Gò Yésu dré pɨ́dhɨ́gó kònɨ̀dhɨ nɨ pɨ̀zo móndɨ́ ɨ dré, tàzoá dhɨ: «Agó àlo dhɨ bhe tá vínò áyɨ amvú na. Dré amvú nda nɨ tayɨ́zó vínò lɨkɨ́bhá àruka ɨ drɨ́gá gò, lɨ̀zo atsí na lókyá be vwàvwà ro. ");
INSERT INTO log_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Lókyá vínò lòꞌwa kɨ̀zo dhɨ kòkɨtswá dre dhɨ, dré áyɨ màrábà kɨ àlo mùzo lɨ̀le vínò lɨkɨ́bhá nda ɨ véna, ɨ̀ kòfèró ɨ́ dré lòꞌwa ɨ́na tɨ́nɨ dhɨ be dhɨ bvó. Dɨ, vínò lɨkɨ́bhá nda ɨ̀ dré àyɨkya màrábà nda nɨ tswàzo gò, logózóá nzɨ̀le drɨ́gálé sè. ");
INSERT INTO log_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Gò amvú líyí nda dré màrábà àzya mùzo lɨ̀le àyɨ véna. Dɨ, ɨ̀ dré kpà akódhɨ nda nɨ tswàzo, kanyò fèzo drá gò, logózóá drɨ́gálé sè. ");
INSERT INTO log_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Dré gòzo màrábà nɨ na mu lɨ̀le gò, ɨ̀ dré akódhɨ nda nɨ pfùzo bɨ́ ɨ́be gò, dòzoá bhèle amvú ꞌásè kɨvɨ̀ na. ");
INSERT INTO log_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Dɨ amvú líyí nda kòyi tà nda dre dhɨ, dré kisùzoá ɨ́ léna dhɨ: ‹Má nɨ ꞌòá ngɨ́nɨ? Má nɨ áma mváagó má dré lèle tò dhɨ nɨ mu kòdhya. Àruka nɨ, ɨ̀ nɨ akódhɨ nɨ lɨndrɨ̀ bha.› ");
INSERT INTO log_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Dɨ, vínò lɨkɨ́bhá nda ɨ̀ kònò mváagó nda adréràꞌa alɨ̀le dre dhɨ, ɨ̀ dré tàzoá àyɨ kòfalésè dhɨ: ‹Kònàdhɨ dhya dra amvú kònɨ̀dhɨ nɨ kisúlépi tàyɨlé ro dhɨ ꞌɨ. Mà kòpfu akódhɨ dràle, amvú dré tá kɨtswálé kisúlé tàyɨlé ro nda kàdréró àma dré!› ");
INSERT INTO log_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Dɨ ɨ̀ dré ngàzo akódhɨ nɨ ru bhèle amvú nda ꞌásè kɨvɨ̀ na gò, pfùzoá dràle.» Yésu gò lizíá dhɨ: «Mɨ̀ adré kisùá dhɨ, amvú líyí nda nɨ ꞌòá ngɨ́nɨ àyɨ kɨ tà sè dhɨ? ");
INSERT INTO log_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Akódhɨ nɨ tsa vínò lɨkɨ́bhá nda kɨ tupfú todràle gò, gòzo amvú vínò àdhya nda nɨ tayɨ́ móndɨ́ àruka ɨ drɨ́gá.» Dɨ móndyá zyandre nda ɨ̀ kòyi tà nda dre dhɨ, ɨ̀ dré tàzoá dhɨ: «Tà nda kòdhɨ ɨ̀ kòꞌo ru tàdzí ko!» ");
INSERT INTO log_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Dɨ Yésu dré àyɨ kɨ nòzo dɨ̀ɨɨ́ gò, tàzoá dhɨ: «Tà tɨsɨ̀le Gìká nɨ Kúlí na kònɨ̀dhɨ adré dɨ lèá tàle ngɨ́nɨ? ‹Kɨ́rà dzó sibhá ɨ̀ dré gàle gàgà dhɨ, gò atsálé kɨ́rà agógó dzó nda dré adrézó áyɨ totó drìá dhɨ ró.› ");
INSERT INTO log_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Dhya ángùdhi dra dhèlepi kɨ́rà nda dri dhɨ nɨ ŋo. Kòdhɨ ɨ́be dhɨ, kɨ́rà nda nɨ dhya ángùdhi ɨ́ dré dra adhézó drìá dhɨ nɨ kɨnyɨ́.» ");
INSERT INTO log_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Gbǎ lókyá nda sè dhɨ, tátrɨ́trɨ́ kúlí tadhábhá ɨ kòwánà kàdrɨ̀ ɨ́be dhɨ ɨ̀ dré láti ndàzo kɨtswázó Yésu nɨ ru. Àngyá ko, ɨ̀ nì tá tàle dhɨ, akódhɨ pɨ tá pɨ́dhɨ́gó nda àyɨ rú dhɨ be. Dɨ, ɨ̀ dré tá adrélé móndyá zyandre dhɨ kɨ ro dhɨ sè dhɨ, ɨ̀ dré akódhɨ nɨ tayɨ́zó. ");
INSERT INTO log_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Dɨ ɨ̀ dré ngàzo adrélé Yésu nɨ mì ga gò, móndɨ́ àyɨ kɨ ꞌobhá adrélé móndɨ́ gyǎgya ró dhɨ kɨ mùzo lùzu ró lɨ̀le Yésu véna. Àyɨ nda ɨ̀ adré tá akódhɨ nɨ le ꞌòle laꞌɨ̀le kúlí dré tá adrélé tàle dhɨ ɨ sílé, ɨ̀ kòkɨtswáró akódhɨ nɨ fe Rómà kɨ gùvèrènérè drɨ́gá. ");
INSERT INTO log_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Dɨ ɨ̀ dré akódhɨ nɨ lizízó tàzoá dhɨ: «Tadhálépi, mà nì tàle dhɨ, tà mɨ́ dré adrélé tàle ɨ̀ndɨ̀ tadhálé dhɨ ɨ gyǎgya dhɨ be. Mɨ́ adré móndɨ́ kɨ no twátwa ko. Mɨ́ adré kpà Gìká nɨ tà tadhá tà bàti sè. ");
INSERT INTO log_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Dɨ mɨ́ tà rè àma dré ká: Àma kɨ tátrɨ́trɨ́ kúlí kaꞌì, mà kàdré Kàyìsárà nɨ mèdáyɨ̀ gɨ dhɨ ꞌí? Kó ngalè, kaꞌì ko?» ");
INSERT INTO log_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Dɨ, Yésu dré ɨ́na àyɨ kɨ túrúpfú tà nìzo kyá gò, logózóá àyɨ dré dhɨ: ");
INSERT INTO log_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«Mɨ̀ afè dènárì àlo dhɨ má dré nòle.» Ɨ̀ kòfè làfa lòꞌwa nda drá dre dhɨ, dré lizízóá dhɨ: «Móndɨ́ lɨ́ndrɨ́ kònɨ̀dhɨ tsàle rú tɨsɨ̀le drìá kònɨ̀dhɨ be dhɨ, àdhi àdhya ꞌɨ?» Ɨ̀ logó drá dhɨ: «Kàyìsárà àdhya ꞌɨ.» ");
INSERT INTO log_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Dɨ Yésu tà àyɨ dré dhɨ: «Mɨ̀ kàdré dɨ ngá Kàyìsárà àdhya nɨ fe Kàyìsárà dré, adrézó kpà ngá Gìká àdhya nɨ fe Gìká dré.» ");
INSERT INTO log_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Dɨ ɨ̀ kɨtswá tá akódhɨ nɨ ꞌo laꞌɨ̀le kúlí dré tá tàle móndɨ́ ɨ kandrá dhɨ ɨ sílé bwà ko. Be ró dhɨ, àyɨ kɨ lɨ́ndrɨ́ ga tá kúlí dré logólé nda sè gò, ɨ̀ dré kúlí tayɨ́zó adrézó kɨ́rɨ. ");
INSERT INTO log_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Àmvolásà dhɨ, Sàdùkáyò àruka ɨ̀ dré alɨ̀zo Yésu vélé kɨtswálé tà lizí tíá. (Àyɨ nda ɨ̀ adré tàá dhɨ, ngangà dràdrà ꞌásè dhɨ yókódhó.) Dɨ ɨ̀ tà drá dhɨ: ");
INSERT INTO log_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«Tadhálépi, Mósè tɨsɨ̀ àma dré dhɨ: ‹Agó àlo adrélépi mvá àko dhɨ kòdrà áyɨ tòkó nɨ tayɨ́ dhɨ, lè adrúpi nɨ kòdo tàyɨ́tòkó nda mòle, kɨtswázó ànzɨ ti áyɨ adrúpi dràlepi nda dré.› ");
INSERT INTO log_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Dɨ àgo nzi-drì-rì adrúpi ró dhɨ ɨ tá be. Àyɨ kɨ kàyo dré tòkó àlo dhɨ nɨ mòzo gò, dràzo tólò mvá ti àko ró. ");
INSERT INTO log_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Adrúpi nɨ nɨ rì dré tòkó nda nɨ dòzo mòle gò, dré kpà dràzo tólò mvá ti àko ró. ");
INSERT INTO log_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Tà nda dré kpà ru ꞌòzo kònɨ̀nɨ adrúpi nɨ nɨ na rú, tsàle byá adrúpi nɨ nɨ nzi-drì-rì rú. Àyɨ títí nda ɨ̀ todrà mvá ti àko ró. ");
INSERT INTO log_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Kùdù ro dhɨ, tòkó nda dré kpà dràzo. ");
INSERT INTO log_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Dɨ kìtú móndɨ́ ɨ̀ dré dra ngàzo dràdrà ꞌásè dhɨ tú dhɨ, adrúpi nzi-drì-rì nda ɨ kòfalé dhɨ, tòkó nda nɨ adré tsítsì dhɨ àdhi dré? Àngyá ko, àyɨ títí nda ɨ̀ do tá akódhɨ mòle àyɨ dré tòko ró.» ");
INSERT INTO log_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yésu logó àyɨ dré dhɨ: «Móndyá ándrò kònɨ ɨ̀ adré ru mo, adrézó kpà àyɨ kɨ ànzɨ kɨ fe mòle. ");
INSERT INTO log_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Dɨ, lókyá adrélépi alɨ̀le dhɨ sè dhɨ, móndyá kɨtswábhá Gìká mìlésè ɨ̀ kòngaró dràdrà ꞌásè dhɨ ɨ̀ gò adrélé ru mo ko, adrélé kpà àyɨ kɨ ànzɨ kɨ fe mòle ko. ");
INSERT INTO log_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ɨ̀ kɨtswá kpà gòle dràle ko. Àngyá ko, ɨ̀ nɨ àyɨkya adré ngóró ángéló ɨ tɨ́nɨ. Àyɨ Gìká nɨ ànzɨ ꞌɨ, ànzɨ ngabhá dràdrà ꞌásè dhɨ ꞌɨ. ");
INSERT INTO log_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Dɨ, kàdré ɨ́na ngangà dràdrà ꞌásè dhɨ nɨ tà sè dhɨ, ndɨ̀ndɨ̀ Mósè tadhá tá ngádra ꞌá dhɨ, móndyá dràbhá dre dhɨ kɨ nga dràdrà ꞌásè dhɨ ꞌí. Tàko ko, dré tá fanzɨ̌ adrélépi kòle àtsɨ ró dhɨ nɨ tà tɨsɨ̀zo dhɨ, zi Mírì ‹Gìká Àbàrámà àdhya, Gìká Ɨ̀sákà àdhya, ɨ̀ndɨ̀ Gìká Yàkóbhò àdhya.› ");
INSERT INTO log_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Dɨ Gìká nda Gìká àbvò kya ꞌɨ ko. Be ró dhɨ, akódhɨ ɨ́na Gìká móndyá lɨ́drɨ̀ ro dhɨ kya ꞌɨ. Àngyá ko, akódhɨ mìlésè dhɨ, àyɨ títí nda ɨ lɨ́drɨ̀ ro.» ");
INSERT INTO log_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Dɨ tátrɨ́trɨ́ kúlí tadhábhá kɨ àruka ɨ̀ logó drá dhɨ: «Tadhálépi, mɨ́ tà tà kòdhɨ kyá!» ");
INSERT INTO log_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Dɨ dhya àlo dré gòzo vélé tà tabhì lizílé akódhɨ tí ko. ");
INSERT INTO log_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Gò Yésu dré tàzoá àyɨ dré dhɨ: «À adré tàá dhɨ, Mèsɨ́yà Dàwídì nɨ mvá ꞌɨ dhɨ ngɨ́nɨ? ");
INSERT INTO log_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Tàko ko, Dàwídì nɨ tàndɨ tà tá búkù Yúdà ànzɨ kɨ Longó kya na dhɨ: ‹Mírì Gìká tà áma Mírì dré dhɨ: Mɨ́ alɨ̀ lɨrɨ́lé áma drɨ́ágó lésè, ");
INSERT INTO log_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","tsàle lókyá má dré dra ámɨ kàrɨbhá kɨ bhàzo adrélé ámɨ pá zàle dhɨ ꞌá.› ");
INSERT INTO log_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Kòdhɨ Dàwídì adré Mèsɨ́yà nɨ zi áyɨ Mírì ro. Dɨ Mèsɨ́yà nda nɨ kɨtswá kpà adrélé akódhɨ nɨ mvá ro ngɨ́nɨngɨ́nɨ ró?» ");
INSERT INTO log_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Móndyá zyandre títí dhɨ ɨ̀ dré tá adréràꞌa Yésu nɨ yi dhɨ ꞌá dhɨ, dré tàzoá áyɨ lebèbhá ɨ dré dhɨ: ");
INSERT INTO log_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Mɨ̀ kàdré àmɨ kɨ lɨkɨ́ tátrɨ́trɨ́ kúlí tadhábhá kɨ tà sè. Àngyá ko, àyɨ nda ɨ̀ adré kánzò kàtswákàtswa dhɨ kɨ le asólé àyɨ rú, adrézó tatsílé ába móndɨ́ ɨ kòfalésè. Ɨ̀ adré lèá dhɨ, à kàdré mòdo fe àyɨ dré lɨndrɨ̀ sè ngá lagɨ́rà ɨ ꞌásè. Ɨ̀ adré lèá lɨrɨ́lé àrà lɨndrɨ̀ àdhya lɨ̀sámbò dzó ɨ ꞌásè dhɨ ɨ ꞌásè, adrézó kpà lèá lɨrɨ́lé mɨ́sá lɨndrɨ̀ àdhya gwányá ɨ ꞌásè dhɨ ɨ làgásè. ");
INSERT INTO log_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ɨ̀ adré tàyɨ́tòkó kɨ ngá kɨ kärí títí. Ɨ̀ adré kpà tà zi Gìká tí vwàvwà ro, à kònòró àyɨ be dhɨ bvó. Dɨ kìtú dra tàbvó tàzo dhɨ tú dhɨ, à nɨ tà ŋo àyɨ dri tà tàndɨ ró.» ");
INSERT INTO log_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yésu dré tá adréràꞌa tépelò na dhɨ ꞌá dhɨ, dré mì tɨngázó ngábhá kɨ no adréràꞌa àyɨ kɨ làfa bhe kpúkúbhú adrézó làfa lɨkɨ́ dhɨ na. ");
INSERT INTO log_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Dré kpà tàyɨ́tòkó àlo lemerè ro dhɨ nɨ nòzo làfa lòꞌwa nzɨ̌ tsàtsà rì dhɨ kɨ bheràꞌa lána. ");
INSERT INTO log_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Gò Yésu dré tàzoá dhɨ: «Má adré tà bàti ta àmɨ dré: Tàyɨ́tòkó lemerè ro kòdhɨ bhà ɨ́na làfa kàdrɨ̀, móndyá àruka títí dhɨ kya kɨ lavú. ");
INSERT INTO log_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Tàko ko, àyɨ títí nda ɨ̀ adó àyɨkya àyɨ kɨ ngá kɨ drì fèle kòdhya. Dɨ, tòkó lemerè ro nda adó ɨ́na ngá títí ɨ́ dré tá adrézó ába kɨtswázó adrɨ́lé ásà dhɨ ɨ fèle kòdhya.» ");
INSERT INTO log_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Yésu nɨ lebèbhá àruka ɨ̀ adré tá tépelò nɨ tà ta, kɨ́rà aveave tépelò nda nɨ sìzo ásà dhɨ ɨ́be, ɨ̀ndɨ̀ ngá fèle Gìká dré tépelò nda nɨ ꞌòzo avélé ásà tò dhɨ ɨ́be. Dɨ, Yésu dré ɨ́na tàzoá dhɨ: ");
INSERT INTO log_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«Kàdré ngá mɨ̀ dré adrélé nòle kònɨ kɨ tà sè dhɨ, lókyá adrélépi alɨ̀le dhɨ sè dhɨ, à gò vélé kɨ́rà kònɨ kɨ àlo kisú àzya nɨ dri ko. À nɨ kɨ́rà nda kɨ lebhé títí kìní mi.» ");
INSERT INTO log_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Gò ɨ̀ dré Yésu nɨ lizízó tàzoá dhɨ: «Tadhálépi, tà kòdhɨ kɨ atsá ángutú? Àdho tà nɨ ru ꞌo drìdrì tadházóá dhɨ, tà nda ɨ̀ adré ꞌòle ru ꞌo káyà dhɨ nɨ̀?» ");
INSERT INTO log_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yésu logó dhɨ: «Mɨ̀ kàdré àmɨ kɨ lɨkɨ́ dóro, à kòlɨtɨ́ró àmɨ ko. Tàko ko, móndɨ́ bǐ dhɨ kɨ alɨ̀ áma rú sè adrélé tàá dhɨ: ‹Ma Mèsɨ́yà ꞌɨ!› ɨ̀ndɨ̀ ‹Lókyá kɨtswá dre!› Dɨ, mɨ̀ kòlɨ̀ àmɨkya àyɨ vésè ko. ");
INSERT INTO log_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Mɨ̀ nɨ àdzú kɨ rúbí yi, móndɨ́ kɨ lɨgɨma àyɨ kɨ ópɨ́ ɨ́be dhɨ kɨ rúbí be. Dɨ, mɨ̀ kòtayɨ́ àmɨ kɨ togó adrélé gàle tirì dré ko. Tàko ko, adré lèá dhɨ, tà nda kòdhɨ ɨ̀ kòꞌo rè zyà ru ꞌíká. Dɨ, lókyá kùdù kɨtswá ɨ́na atsálé mbèlè ko.» ");
INSERT INTO log_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Gò tàá àyɨ dré dhɨ: «Súrú kɨ àdzú bhu súrú àruka ɨ́be. Òpɨ̀ kɨ kpà àdzú bhu òpɨ̀ àruka ɨ́be. ");
INSERT INTO log_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kàdíkàdi nɨ bvò kosé rìnyí sè, ɨ̀ndɨ̀ kàrábhò nɨ dhe drà kònzɨ ɨ́be àrà twátwa ɨ ꞌásè. Tà dra tirì febhá dhɨ kɨ ru ꞌo, ɨ̀ndɨ̀ tà kàdrɨ̀ lɨ́ndrɨ́ga ró dhɨ kɨ agá bhù mìbhalé ꞌá. ");
INSERT INTO log_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Dɨ, tà títí nda ɨ kandrá dhɨ, à nɨ àmɨ kɨ turú adrélé mì pfòle. À nɨ àmɨ kɨ lefè tàbvó tàle lɨ̀sámbò dzó ɨ ꞌásè, adrézó àmɨ kɨ lebhé bǎdzó ɨ ꞌásè. Áma tà sè dhɨ, à nɨ àmɨ kɨ tidrì topfòzo àmɨ ɨ́be ópɨ́ kàdrɨ̀ ɨ kandrásè ɨ̀ndɨ̀ gùvèrènérè ɨ kandrásè. ");
INSERT INTO log_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Tà nda nɨ láti nzi àmɨ dré kɨtswázó áma tà mɨ̀ dré nòle ɨ̀ndɨ̀ mɨ̀ dré yìle dhɨ kɨ longó àyɨ dré. ");
INSERT INTO log_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Dɨ ásà dhɨ, mɨ̀ kòbhà àmɨ kɨ togó adrélé lanzìle, adrézó mɨ̀ nɨ tà ta àmɨ rúsè ngɨ́nɨ ya dhɨ nɨ kisù drìdrì dhɨ ko. ");
INSERT INTO log_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Tàko ko, má nɨ mána kúlí fe àmɨ dré kɨtswálé logólé tògyá sè àmɨ kɨ kàrɨbhá ɨ tí, ɨ̀ kòkɨtswáró kayíá ko, ɨ̀ndɨ̀ ɨ̀ kòkɨtswáró tà ta rúásà twá ko dhɨ ma. ");
INSERT INTO log_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ndɨ̀ndɨ̀ àmɨ kɨ tibhá ɨ, àmɨ kɨ adrúpi ɨ, àmɨ kɨ aró ɨ, tsàle àmɨ kɨ arúpi ɨ́be dhɨ kɨ àmɨ kɨ lefè kàrɨbhá ɨ drɨ́gá gò, àmɨ kɨ àruka kɨ tupfúzó todràle. ");
INSERT INTO log_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Móndyá títí dhɨ kɨ togó kònzɨ bha àmɨ rú áma tà sè. ");
INSERT INTO log_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Dɨ, tágba kònɨ̀nɨ dhɨ, àmɨ kɨ drìbhɨ́ kɨ àlo kɨtswá ɨ́na tavɨ̀le ko. ");
INSERT INTO log_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Mɨ̀ kàdré togó tsɨ, adrézó àmɨ kɨ totó tätä dhɨ, mɨ̀ nɨ lɨ́drɨ̀ kisú.» ");
INSERT INTO log_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","«Mɨ̀ kònò sòdá zyandre dhɨ ɨ adréràꞌa Yèrúsalémà nɨ gàrà kɨ kúrú dre dhɨ, mɨ̀ nɨ nìá tàle dhɨ, bhàandre nda nɨ pfùma atsá ànyɨ dre dhɨ be. ");
INSERT INTO log_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Lókyá nda sè dhɨ, lè móndyá dra adrébhá bvò Yùdáyà àdhya na dhɨ ɨ̀ kòlapá ràle kòngó ɨ drìna, àyɨ adrébhá Yèrúsalémà na dhɨ ɨ̀ kàpfò lásà, ɨ̀ndɨ̀ àyɨ adrébhá gbàbhú ꞌásè dhɨ ɨ̀ kòfɨ bhàandre nda na ko. ");
INSERT INTO log_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Tàko ko, kìtú nda kòna kɨ adré kìtú tà ŋòzo móndɨ́ ɨ dri dhɨ ꞌɨ, kɨtswálé tà títí tɨsɨ̀le Gìká nɨ Kúlí na dhɨ ɨ̀ kòꞌoró ru be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Kìtú nda ɨ tú dhɨ, kɨzà nɨ adré kàdrɨ̀ tòkó adrébhá ꞌa ɨ́be dhɨ ɨ dré, ɨ̀ndɨ̀ tòkó adrébhá bà fe ànzɨmvá ɨ dré dhɨ ɨ dré. Kɨzà nɨ adré kàdrɨ̀ lavúlé bvò nda na, ɨ̀ndɨ̀ Gìká nɨ kombà nɨ adré kàdrɨ̀ súrú nda rú. ");
INSERT INTO log_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","À nɨ àyɨ kɨ àruka kɨ tupfú todràle sápɨ́ sè, àruka nɨ kɨ turúzó lɨ̀zo àyɨ ɨ́be bvò títí súrú twá ro dhɨ ɨ ꞌásè. Gò móndyá súrú twá ro dhɨ ɨ̀ dré Yèrúsalémà nɨ atózó àyɨ pálé, tsàle móndyá súrú twá ro nda kɨ lókyá dré akɨ́ràꞌa títí dhɨ ꞌá.» ");
INSERT INTO log_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","«Tà twátwa lɨ́ndrɨ́ga ró dhɨ kɨ agá kìtú mi, mbǎ mi, ɨ̀ndɨ̀ bhìbhínyà ɨ mi. Dɨ súrú títí bvò dri dhɨ kɨ togó kɨ adré kɨzà ro lavúlé, àyɨ kɨ drì dré adrézó abɨ́lé, yǐandre dré dra adrélé ru kägbä́ adrélé kpòrò ꞌo lavúlé dhɨ sè. ");
INSERT INTO log_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Móndɨ́ kɨ dra tirì dré, ɨ̀ dré adréràꞌa tà adrébhá alɨ̀le bvò dri dhɨ kɨ letè dhɨ ꞌá. Àngyá ko, rìnyí bhù na dhɨ kɨ ru kɨzɨ́. ");
INSERT INTO log_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Dɨ lókyá nda sè dhɨ, móndyá títí dhɨ kɨ Móndɨ́ nɨ Mvá nɨ no adréràꞌa alɨ̀le ndùrùku ɨ ꞌásè, rìnyí kàdrɨ̀ be ɨ̀ndɨ̀ mìlanzìlanzì kàdrɨ̀ be. ");
INSERT INTO log_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Dɨ tà nda kòdhɨ ɨ̀ kòkɨdhó adrélé ru ꞌo dre dhɨ, mɨ̀ kòtotó àmɨ àmɨ kɨ drì tɨngá kuru, adrézó gànzi ró. Tàko ko, lókyá Gìká dré dra àmɨ kɨ apázó dhɨ atsá ànyɨ dre.» ");
INSERT INTO log_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Gò Yésu dré tà kònɨ̀dhɨ nɨ tàzo àyɨ dré kúlí alaala sè, tàzoá dhɨ: «Mɨ̀ nò rè fígì fa túmä́ní fa àruka títí dhɨ ɨ́be dhɨ ɨ ká! ");
INSERT INTO log_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Mɨ̀ kàdré àyɨ kɨ bí no adréràꞌa ròle dhɨ, mɨ̀ nì tàle dhɨ, yǐgú ànyɨ dhɨ be. ");
INSERT INTO log_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Kókpà kòdhɨ tɨ́nɨ, lókyá mɨ̀ dré dra tà nda kòdhɨ kɨ nòzo adréràꞌa ru ꞌo dhɨ tú dhɨ, lè mɨ̀ kònì tàle dhɨ, Gìká nɨ Òpɨ̀ ànyɨ káyà dhɨ. ");
INSERT INTO log_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Má adré tà bàti ta àmɨ dré: Móndyá dra adrébhá lɨ́drɨ̀ ɨ́be lókyá nda sè dhɨ ɨ̀ kɨtswá dràle títí drìdrì tà títí nda ɨ̀ dré dra ru ꞌòzo dhɨ kandrá ko. ");
INSERT INTO log_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Bhù ɨ bvò be dhɨ kɨ akɨ́. Dɨ, áma kúlí ɨ̀ kɨtswá àyɨkya tàdzí akɨ́lé ko. ");
INSERT INTO log_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Mɨ̀ kònò dóro, mɨ̀ kòbhàró àmɨ kɨ togó adrélé lanzìle gwányá ꞌòma nɨ tà sè, wá tsìma nɨ tà sè, ɨ̀ndɨ̀ tà bvò kòndɨ àdhya kɨ kisùma nɨ tà sè ko, kìtú tàbvó tàzo nda kòkɨró àmɨ ngbǒ ró ko. ");
INSERT INTO log_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Tàko ko, kìtú nda nɨ atsá móndyá títí bvò dri dhɨ ɨ dré. ");
INSERT INTO log_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Lè mɨ̀ kàdré dɨ tàmìga dri, adrélé tà zi Gìká tí lókyá wä́yi sè, mɨ̀ kòkɨtswáró tà títí adrébhá alɨ̀le nda kɨ lavú, kɨtswázó àmɨ kɨ totó kanyò àko Móndɨ́ nɨ Mvá kandrá.» ");
INSERT INTO log_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Kìtú àlo àlo títí ɨ sè dhɨ, Yésu adré tá tà tadhá tépelò na gò, ngátsi sè dhɨ, dré adrézó pfòle mbàle ayílé kòngó Òlívè fa kya drìna. ");
INSERT INTO log_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Dɨ drùbhì kɨ́nó, móndyá títí dhɨ ɨ̀ adré tá lɨ̀le akódhɨ nɨ yi tépelò na. ");
INSERT INTO log_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Yúdà ànzɨ kɨ gwányá Mápà tàkú àko dhɨ àdhya, adrélé kpà rú zìle Pásɨkà dhɨ adré tá atsálé ànyɨ. ");
INSERT INTO log_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Kòwánà kàdrɨ̀ ɨ tátrɨ́trɨ́ kúlí tadhábhá ɨ́be dhɨ ɨ̀ adré tá láti nda kɨtswázó Yésu nɨ pfu dràle lùzu ró. Tàko ko, ɨ̀ adré tá àyɨkya móndyá zyandre dhɨ kɨ ro. ");
INSERT INTO log_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Dɨ Sàtánà dré fɨ̀zo Yùdásɨ̀ adrélé kpà rú zìle Ɨ̀sɨ̀kàrɨ̀yótà dhɨ na. Akódhɨ nda tá Yésu nɨ lebèbhá mudrí-drì-rì dhɨ kɨ àlo ꞌɨ. ");
INSERT INTO log_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Gò dré ngàzo lɨ̀le tà ta kòwánà kàdrɨ̀ ɨ́be ɨ̀ndɨ̀ tépelò lɨkɨ́bhá kɨ kàdrɨ̀ ɨ́be, ɨ́ nɨ Yésu nɨ lefè àyɨ drɨ́gá ngɨ́nɨ ya dhɨ nɨ tà dri. ");
INSERT INTO log_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Àyɨ nda ɨ̀ dré lenzézó tà nda sè gò, ɨ̀ dré lazízóá dhɨ, ɨ̀ nɨ làfa fe drá. ");
INSERT INTO log_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Dɨ Yùdásɨ̀ dré kaꞌìzoá gò, kɨdhózó adrélé lókyá dóro Yésu nɨ lefèzo àyɨ drɨ́gá dhɨ nɨ nda, móndyá zyandre dhɨ ɨ̀ kònìró ko. ");
INSERT INTO log_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Gwányá Mápà tàkú àko dhɨ àdhya tú dhɨ, kìtú adrézó kábilígyà mvá Pásɨkà àdhya nɨ pfu dràle mòbòmà ro dhɨ dré atsázó. ");
INSERT INTO log_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Dɨ Yésu dré Pétèró kɨ mùzo Yòwánɨ̀ be, tàzoá dhɨ: «Mɨ̀ lɨ̀ ngá ladhɨ́ àma dré gwányá Pásɨkà àdhya nɨ nyàzo.» ");
INSERT INTO log_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ɨ̀ lizí akódhɨ tàzoá dhɨ: «Mɨ́ adré lèá dhɨ, mà kòlɨ̀ ladhɨ́á ángwà?» ");
INSERT INTO log_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Dɨ Yésu logó àyɨ dré dhɨ: «Mɨ̀ kòfɨ bhàandre na dre dhɨ, mɨ̀ nɨ drì si agó àlo adrélépi yǐ do lɨ̀drɨ́ na dhɨ be. Mɨ̀ dhe akódhɨ nda bvó, tsàle dzó dré dra fɨ̀zo lána dhɨ na. ");
INSERT INTO log_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Mɨ̀ kòtà dzó nda nɨ líyí dré dhɨ: ‹Dhya tà tadhálépi dhɨ adré ámɨ lizí: Dzó ꞌa kɨ̀le mà dré kɨtswázó Pásɨkà nya áma lebèbhá ɨ́be dhɨ ángwà?› ");
INSERT INTO log_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Dɨ akódhɨ nda nɨ dzó ꞌa kɨ̀le kàdrɨ̀ kurú na dhɨ nɨ tadhá àmɨ dré. À tobhà mɨ́sá ɨ ngá àruka ɨ́be tayɨ́lé lána dre. Mɨ̀ kòladhɨ́ ngá àma dré kònàle.» ");
INSERT INTO log_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Dɨ ɨ̀ kòlɨ̀ dre dhɨ, ɨ̀ dré tà títí nda kɨ kisúzó ngóró Yésu dré tá tàle àyɨ dré dhɨ tɨ́nɨ. Gò ɨ̀ dré ngá ladhɨ́zó kɨtswázó gwányá Pásɨkà àdhya nɨ nya. ");
INSERT INTO log_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Lókyá kòkɨtswá dre dhɨ, Yésu ɨ̀ dré tsàzo lɨrɨ́lé mɨ́sá làgásè túmä́ní akódhɨ nɨ àpóstolò mudrí-drì-rì dhɨ ɨ́be. ");
INSERT INTO log_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Gò dré tàzoá àyɨ dré dhɨ: «Ma tá lovó ɨ́be tò atsálé nyànomvá dhɨ, mà kònyaró Pásɨkà kònɨ̀dhɨ túmä́ní àmɨ ɨ́be áma kɨzà nyàma kandrá. ");
INSERT INTO log_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Tàko ko, má adré tàá àmɨ dré dhɨ: Má gò vélé nyàá ko, tsàle lókyá tà nɨ nɨ dré dra ru ꞌòzo kɨtswálé títí Gìká nɨ Òpɨ̀ na dhɨ ꞌá.» ");
INSERT INTO log_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Dɨ dré kópò adózó, àwoyà fèzo Gìká dré gò, tàzoá dhɨ: «Mɨ̀ do vínò kópò kònɨ̀dhɨ lé nɨ lanzɨ́lé àmɨ kòfalésè. ");
INSERT INTO log_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Tàko ko, má adré tàá àmɨ dré dhɨ: Má gò vélé vínò mvu ko, tsàle lókyá Gìká nɨ Òpɨ̀ dré dra atsázó dhɨ ꞌá.» ");
INSERT INTO log_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Dré mápà adózó, àwoyà fèzo Gìká dré gò, ŋòzoá fèle áyɨ lebèbhá ɨ dré gò, tàzoá dhɨ: «Kònɨ̀dhɨ áma rúbhá má dré adrélé fèle àmɨ kɨ tà sè dhɨ ꞌɨ. Mɨ̀ nya, ɨ̀ndɨ̀ mɨ̀ kàdré ꞌòá kònɨ̀nɨ adrézó áma tà kisù.» ");
INSERT INTO log_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ngá nyàma àmvolésè dhɨ, dré kókpà ꞌòzoá kònɨ̀nɨ kópò sè. Adó kópò nda, tàzoá dhɨ: «Kópò kònɨ̀dhɨ adré tà tɨ́dhɨ́ Gìká dré bhàle ru yìzo móndɨ́ ɨ́be áma kàrɨ́ kutúlépi àmɨ dré dhɨ sè dhɨ nɨ tà tadhá. ");
INSERT INTO log_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Dɨ, mɨ̀ yi rè ká! Dhya adrélépi ꞌòle áma lefè kàrɨbhá ɨ drɨ́gá dhɨ adré lɨrɨ́lé túmä́ní má be mɨ́sá kònɨ̀dhɨ làga. ");
INSERT INTO log_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Tà bàti ró dhɨ, Móndɨ́ nɨ Mvá nɨ lɨ dràle ngóró Gìká dré tá tà nɨ nɨ bhàle drìdrì dhɨ tɨ́nɨ. Dɨ, kɨzà nɨ ɨ́na adré kàdrɨ̀ dhya dra Móndɨ́ nɨ Mvá nda nɨ lefèlepi dhɨ dré!» ");
INSERT INTO log_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Dɨ ɨ̀ dré kɨdhózó adrélé lizíá àyɨ kòfalésè, ngalè àdhi àyɨ kòfalé dhɨ nɨ tà nda nɨ ꞌo nɨ̀ ya dhɨ. ");
INSERT INTO log_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Gò Yésu nɨ lebèbhá nda ɨ̀ dré dhèzo adrélé tà kayí àyɨ kòfalésè, nìzoá ngalè dhya kàdrɨ̀ lavúlé àyɨ kòfalé dhɨ àdhi ꞌɨ ya dhɨ. ");
INSERT INTO log_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Dɨ Yésu dré tàzoá àyɨ dré dhɨ: «Móndyá bvò kòndɨ àdhya kɨ ópɨ́ ɨ̀ adré àyɨkya òpɨ̀ nya àyɨ dri rìnyí sè. Dhya kàdrɨ̀kàdrɨ̀ àyɨ drìle dhɨ ɨ̀ adré kpà àyɨ kɨ tàndɨ kɨ zi móndɨ́ kɨ ledébhá ɨ ró. ");
INSERT INTO log_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Dɨ, adré lèá dhɨ, àmɨ kɨ tà kàdré kònɨ̀nɨ ko. Be ró dhɨ, lè dhya kàdrɨ̀ lavúlé àmɨ kòfalé dhɨ kàdré àmɨ kɨ tùgumvá tɨ́nɨ. Lè kpà dhya adrélépi àmɨ kɨ drì ko dhɨ kàdré tà ꞌo àmɨ kɨ màrábà tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Àngyá ko, mɨ̀ adré kisùá dhɨ, dhya kàdrɨ̀ lavúlé dhɨ àdhi ꞌɨ: dhya adrélépi ngá nya mɨ́sá na dhɨ, kó ngalè, dhya adrélépi ngá bha nyàle dhɨ? Zakó tá dhya adrélépi ngá nya mɨ́sá na dhɨ ꞌɨ? Dɨ, ma mána àmɨ kòfalé dhɨ ngóró dhya adrélépi tà ꞌo àmɨ dré dhɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Àmɨ ró dhɨ, àmɨ tá ngbú dhya adrébhá túmä́ní má be tà dré adréràꞌa áma tabhì dhɨ ꞌá dhɨ ꞌɨ. ");
INSERT INTO log_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Dɨ má adré àmɨ kɨ bha adrélé òpɨ̀ nya, ngóró áma Atá dré áma bhàle adrélé òpɨ̀ nya dhɨ tɨ́nɨ, ");
INSERT INTO log_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","mɨ̀ kàdréró ngá nya ɨ̀ndɨ̀ ngá mvu áma mɨ́sá làgásè áma Òpɨ̀ na. Kònàle dhɨ, mɨ̀ nɨ lɨrɨ́ lɨrɨ́rà adrézó òpɨ̀ nya dhɨ ɨ drǐsè, adrélé Ɨ̀sèrélè ànzɨ kɨ súrú mudrí-drì-rì dhɨ kɨ tàbvó ta.» ");
INSERT INTO log_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yésu gò tàá dhɨ: «Sìmónà, Sìmónà, mɨ́ yi rè ká! Sàtánà zi tà Gìká tí, kòfèró láti ɨ́ dré àmɨ kɨ tabhìzo, ngóró à dré adrélé ngánò kɨyá dhɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Dɨ, má zi mána tà Gìká tí mɨ́ dré, mɨ́ kòtayɨ́ró ámɨ tà kaꞌìkaꞌì ko dhɨ bvó. Dɨ mɨ́ kògò agòle má vélé dre dhɨ, mɨ́ kòtɨmbà ámɨ adrúpi ɨ àyɨ kɨ tà kaꞌìkaꞌì na.» ");
INSERT INTO log_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Dɨ, Pétèró tà drá dhɨ: «Mírì, ma gànzi ró lɨ̀le bǎ nya, ɨ̀ndɨ̀ lɨ̀le dràle túmä́ní mɨ́ be.» ");
INSERT INTO log_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yésu logó drá dhɨ: «Pétèró, má adré tàá mɨ́ dré dhɨ: Ándrò drìdrì àgólòwa dré dra tsírà bhèzo dhɨ kandrá dhɨ, mɨ́ nɨ áma ga vésè be na tàzoá dhɨ, mɨ́ nì ma ko.» ");
INSERT INTO log_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yésu gò lizíá àyɨ tí dhɨ: «Lókyá má dré tá àmɨ kɨ mùzo lɨ̀le làfa àko, kòmvò àko, ɨ̀ndɨ̀ kámókà àzya àko dhɨ sè dhɨ, ngá àlo dhɨ pɨ tá àmɨ vélé?» Ɨ̀ logó dhɨ: «Kóko.» ");
INSERT INTO log_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Akódhɨ tà àyɨ dré dhɨ: «Dɨ, nyànomvá dhɨ, dhya adrélépi làfa ɨ́be dhɨ, kòdo làfa nda be. Dhya adrélépi kòmvò ɨ́be dhɨ, kòdo kpà be. Dhya adrélépi sápɨ́ àko dhɨ, kòlagɨ́ áyɨ kɨ́tá kɨdhɨ̀ àdhya kɨtswázó sápɨ́ gɨ ɨ́ dré. ");
INSERT INTO log_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Tàko ko, má adré tàá àmɨ dré dhɨ: Lè tà tɨsɨ̀le áma tà dri Gìká nɨ Kúlí na kònɨ̀dhɨ kàtsá má rú: ‹À amú akódhɨ nàle tátrɨ́trɨ́ kúlí ŋobhá ɨ́be.› Tà bàti ró dhɨ, tà tɨsɨ̀le áma tà dri kòdhɨ adré ꞌòle ru ꞌo.» ");
INSERT INTO log_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Akódhɨ nɨ lebèbhá ɨ̀ gò tàá dhɨ: «Mírì, sápɨ́ rì dhɨ ɨ be kònɨ̀dhɨ.» Akódhɨ logó àyɨ dré dhɨ: «Kòdhɨ kɨtswá dre.» ");
INSERT INTO log_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yésu kàpfò kònalésè dre dhɨ, dré lɨ̀zo mbàle kòngó Òlívè fa kya drìna, ànzyà gà dré adrélé ꞌòle dhɨ tɨ́nɨ. Akódhɨ nɨ lebèbhá ɨ̀ dré kpà akódhɨ nɨ lebèzo. ");
INSERT INTO log_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ɨ̀ kòtsa àrà nda na dre dhɨ, dré tàzoá àyɨ dré dhɨ: «Mɨ̀ kàdré tà zi Gìká tí, kòtayɨ́ró àmɨ tà dré tabhìle, àmɨ kɨ ꞌòzo dhèle tàkonzɨ̀ na dhɨ ko.» ");
INSERT INTO log_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Gò dré lɨ̀zo vwàle àyɨ rúsè ànyɨ́ànyɨ ngóró kɨ́rà vìle dhɨ dré adrélé lɨ̀le adhélé dhɨ pɨ́. Dré dhèzo áyɨ kórókó titì, tà zìzo Gìká tí kònɨ̀nɨ: ");
INSERT INTO log_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","«Tátá, mɨ́ kòlè dhɨ, mɨ́ kòdo kópò kɨzà àdhya kòdhɨ má vélésè wà. Dɨ, mɨ́ kòꞌo tà má dré adrélé lèle dhɨ kòdhya ko. Be ró dhɨ, mɨ́ kòꞌo tà mɨ́ dré adrélé lèle dhɨ kòdhya.»  ");
INSERT INTO log_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Gò ángéló àlo bhù lésè dhɨ dré agázó akódhɨ kandrá, rìnyí fe drá. ");
INSERT INTO log_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yésu nɨ togó dré adrélé kɨzà ro lavúlé dhɨ sè dhɨ, dré gòzo adrélé tà zi Gìká tí togó wä́yi sè. Gò kúrì adrélépi apfòle rúásà dhɨ dré atsázó kàrɨ́ tɨ́nɨ, adrélé tɨtɨ̀le kìní mi. ");
INSERT INTO log_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Akódhɨ kòzi tà nda akɨ́lé dre dhɨ, dré ngàzo gòle áyɨ lebèbhá nda ɨ véna, àyɨ kɨ kisú adréràꞌa ayí ko kɨzà dré. ");
INSERT INTO log_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Dɨ dré tàzoá àyɨ dré dhɨ: «Mɨ̀ adré ayí ko àdho tà sè? Mɨ̀ nga adrélé tà zi Gìká tí, kòtayɨ́ró àmɨ tà dré tabhìle, àmɨ kɨ ꞌòzo dhèle tàkonzɨ̀ na dhɨ ko.» ");
INSERT INTO log_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Gbǎ kòdhwa, Yésu dré rè dhu adréràꞌa tà ta dhɨ ꞌá dhɨ, móndɨ́ zyandre dhɨ ɨ̀ dré atsázó. Dɨ dhya rú zìle Yùdásɨ̀, Yésu nɨ lebèbhá mudrí-drì-rì dhɨ kɨ àlo dhɨ adrì tá ɨ́na àyɨ nɨ̀. Gò dré áyɨ kisízó ànyɨ Yésu làga, kɨtswálé akódhɨ nɨ kamú. ");
INSERT INTO log_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Dɨ, Yésu dré tàzoá drá dhɨ: «Yùdásɨ̀, mɨ́ adré tsì Móndɨ́ nɨ Mvá nɨ kamú, kɨtswázó akódhɨ nɨ lefè kàrɨbhá ɨ drɨ́gá bàti?» ");
INSERT INTO log_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Yésu nɨ lebèbhá ɨ̀ kònò tà adrélépi ꞌòle ru ꞌo nda dre dhɨ, ɨ̀ dré akódhɨ nɨ lizízó: «Mírì, mà kòtogá àyɨ sápɨ́ sè wà?» ");
INSERT INTO log_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Gò àyɨ kɨ àlo dré kòwánà kɨ kàdrɨ̀ nɨ màrábà nɨ bí drɨ́ágó lésè dhɨ nɨ bvwàzo kɨ̀le. ");
INSERT INTO log_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Dɨ, Yésu dré ɨ́na tàzoá dhɨ: «Mɨ̀ tayɨ́! Kòdhɨ kɨtswá dre!» Dré agó nda nɨ bí tabèzo, akódhɨ nɨ tɨdrɨ́zó. ");
INSERT INTO log_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Gò Yésu dré tàzoá kòwánà kàdrɨ̀ ɨ, tépelò lɨkɨ́bhá kɨ kàdrɨ̀ ɨ ɨ̀ndɨ̀ bhàgo atsábhá áyɨ ru dhɨ ɨ dré dhɨ: «Ma vo kùgú ꞌɨ gò, mɨ̀ dré adrézó alɨ̀le sápɨ́ ɨ́be ɨ̀ndɨ̀ fa ɨ́be kɨtswálé áma ru nɨ? ");
INSERT INTO log_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Kìtú àlo àlo títí ɨ sè, má adré tá àmɨ kòfalé tépelò na dhɨ, mɨ̀ bhà tá drɨ́gá má rú ko. Dɨ, lókyá kònɨ̀dhɨ àmɨkya ꞌɨ, ɨ̀ndɨ̀ dhya adrélépi áyɨ rìnyí tadhá tínímvá na dhɨ àdhya ꞌɨ.» ");
INSERT INTO log_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Gò ɨ̀ dré Yésu nɨ rùzo, drìzoá lɨ̀zo ába kòwánà kɨ kàdrɨ̀ nɨ dzó na. Dɨ Pétèró adré tá ɨ́na àyɨ kɨ lebè lárá ro. ");
INSERT INTO log_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Àyɨ kɨ àruka ɨ̀ turú tá àtsɨ́ bhàꞌálé nda nɨ kɨ́tó ꞌá gò, ɨ̀ dré lɨrɨ́zó làgásà. Dɨ Pétèró dré kpà lɨrɨ́zó àyɨ kòfalé. ");
INSERT INTO log_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Gò mvátòkó àlo màrábà ro dhɨ dré akódhɨ nɨ nòzo adréràꞌa lɨrɨ́lé àtsɨ́ mìle. Dré mì tɨngbózó drìá gò, tàzoá dhɨ: «Dhya kòndɨ tá kókpà túmä́ní Yésu be.» ");
INSERT INTO log_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Dɨ, Pétèró dré ɨ́na tà nda nɨ gàzo rè, tàzoá dhɨ: «Tòkó, má nì akódhɨ ko.» ");
INSERT INTO log_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Gí ko, dhya àzya dré akódhɨ nɨ nòzo gò, tàzoá dhɨ: «Mɨ kókpà àyɨ kɨ àlo ꞌɨ.» Dɨ Pétèró logó dhɨ: «Kóko, ma ꞌɨ ko!» ");
INSERT INTO log_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ànyɨ́ànyɨ sáà àlo àmvolésè dhɨ, dhya àzya dré gòzo tàá rìnyí sè dhɨ: «Bàti, dhya kòndɨ tá túmä́ní Yésu be! Àngyá ko, akódhɨ kókpà móndɨ́ angálépi Gàlìláyà lésè dhɨ ꞌɨ.» ");
INSERT INTO log_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Dɨ Pétèró logó dhɨ: «Agó, má nì ngalè mɨ́ adré àdho tà ta ya dhɨ ko!» Gbǎ lókyá dré adréràꞌa tà ta dhɨ ꞌá dhɨ, àgólòwa dré tsírà bhèzo. ");
INSERT INTO log_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Gò Mírì Yésu dré áyɨ alázó Pétèró nɨ no dɨ̀ɨɨ́. Dɨ kúlí Mírì dré tá tàle Pétèró dré dhɨ dré agázó lána. Tà tá dhɨ: «Ándrò, drìdrì àgólòwa dré dra tsírà bhèzo dhɨ kandrá dhɨ, mɨ́ nɨ áma ga vésè be na.» ");
INSERT INTO log_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Dɨ Pétèró dré pfòzo kɨvɨ̀ na gò, ngòle kaꞌílé kaꞌikaꞌi kɨzà dré. ");
INSERT INTO log_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Dɨ dhya adrébhá Yésu nɨ lɨkɨ́ dhɨ ɨ̀ adré tá akódhɨ nɨ gu, adrézó akódhɨ nɨ tswa. ");
INSERT INTO log_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ɨ̀ dré akódhɨ nɨ mì dròzo gò, adrézó tàá drá dhɨ: «Mɨ́ tà rè àma dré pròfétà ro dhɨ, ngalè àdhi sa mɨ nɨ̀ ya dhɨ ká!» ");
INSERT INTO log_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Dɨ ɨ̀ adré tá akódhɨ nɨ lodhá kanyò kúlí àruka bǐ dhɨ ɨ sè. ");
INSERT INTO log_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ngá kòwa dre dhɨ, Yúdà ànzɨ kɨ bhàgo kàdrɨ̀ ɨ, kòwánà kàdrɨ̀ ɨ ɨ̀ndɨ̀ tátrɨ́trɨ́ kúlí tadhábhá ɨ́be dhɨ, ɨ̀ dré ru kɨmózó kònàle. Gò Yésu nɨ drìzo pfòle àyɨ nda ɨ kandrá. ");
INSERT INTO log_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Dɨ ɨ̀ dré tàzoá drá dhɨ: «Mɨ́ kàdré Mèsɨ́yà ꞌɨ bàti dhɨ, mɨ́ tà rè àma dré ká!» Yésu logó àyɨ dré dhɨ: «Má kòtà tà nda àmɨ dré dhɨ, mɨ̀ kɨtswá kaꞌìá ko. ");
INSERT INTO log_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Má kòlizí kpà tà àmɨ tí dhɨ, mɨ̀ kɨtswá tàdzí kúlí logó ko. ");
INSERT INTO log_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Dɨ, kɨdhólé nyànomvá dhɨ, Móndɨ́ nɨ Mvá nɨ lɨrɨ́ adrélé Gìká rìnyí líyí nɨ drɨ́ágó lésè.» ");
INSERT INTO log_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Dɨ àyɨ títí nda ɨ̀ lizí tíá dhɨ: «Mɨ dɨ mɨ́na Gìká nɨ Mváagó ꞌɨ?» Yésu logó àyɨ dré dhɨ: «Àmɨ kɨ tàndɨ mɨ̀ tà kyá tàle dhɨ, ma ꞌɨ dhɨ.» ");
INSERT INTO log_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Dɨ ɨ̀ tà dhɨ: «Mà nɨ dɨ go vélé móndɨ́ àruka kɨtswábhá tà ta akódhɨ rú dhɨ kɨ nda àdho tà sè? Àma kɨ tàndɨ, mà yi kúlí apfòlepi akódhɨ nɨ tàndɨ sílésè dhɨ dre!» ");
INSERT INTO log_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Gò àyɨ títí ru kɨmóbhá nda ɨ̀ dré ngàzo Yésu nɨ dri lɨ̀zo ába Pìlátò, Rómà kɨ gùvèrènérè kandrá. ");
INSERT INTO log_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Gò ɨ̀ dré dhèzo adrélé Yésu nɨ asíkì, adrézó tàá dhɨ: «Mà kisú dhya kònɨ̀dhɨ adréràꞌa àma kɨ súrú nɨ kodzó lɨgɨ́lé. Akódhɨ adré ɨ́na Kàyìsárà nɨ mèdáyɨ̀ gɨ̀ma logá móndɨ́ ɨ dré. Adré kpà áyɨ tàndɨ nɨ zi Mèsɨ́yà ro, ɨ̀ndɨ̀ ópɨ́ ro.» ");
INSERT INTO log_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Dɨ Pìlátò dré lizízóá Yésu tí dhɨ: «Mɨ, mɨ ópɨ́ Yúdà ànzɨ kya ꞌɨ?» Yésu logó drá dhɨ: «Ámɨ tàndɨ mɨ́ tà dre.» ");
INSERT INTO log_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Gò Pìlátò dré tàzoá kòwánà kàdrɨ̀ ɨ dré, móndyá zyandre ɨ́be dhɨ: «Má kisú mána tà àlo tà bhàzo agó kònɨ̀dhɨ dri dhɨ ko.» ");
INSERT INTO log_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Dɨ, ɨ̀ gò àyɨkya tàá rìnyí sè dhɨ: «Akódhɨ adré móndɨ́ zyandre dhɨ kɨ kodzó lɨgɨ́lé tà dré adrélé tadhálé dhɨ ɨ sè. Adré ꞌòá kònɨ̀nɨ Yúdà ànzɨ kɨ bvò ꞌásè títí, kɨdhólé Gàlìláyà lésè atsálé kònwa Yèrúsalémà ꞌa.» ");
INSERT INTO log_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pìlátò kòyi tà nda dre dhɨ, dré lizízóá ngalè Yésu móndɨ́ angálépi Gàlìláyà lésè dhɨ ꞌɨ yà dhɨ. ");
INSERT INTO log_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Kòyi tàle dhɨ, akódhɨ tá ópɨ́ Èródè nɨ rìnyí zàle dhɨ dre dhɨ, dré akódhɨ nɨ mùzo Èródè véna. Àngyá ko, akódhɨ nda tá Yèrúsalémà ꞌa lókyá nda sè. ");
INSERT INTO log_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Èródè kònò Yésu dre dhɨ, dré lenzézó lavúlé. Tàko ko, yi tá Yésu nɨ rúbí kɨ́nó gò, adrézó akódhɨ nɨ le nòle tò. Adré tá mì bha kɨtswálé akódhɨ nɨ no tà àlo lɨ́ndrɨ́ga ró dhɨ nɨ ꞌoràꞌa. ");
INSERT INTO log_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Dɨ dré akódhɨ nɨ lizízó tà bǐ dhɨ ɨ sè. Dɨ, Yésu logó ɨ́na drá kúlí àlo ko. ");
INSERT INTO log_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Kòwánà kàdrɨ̀ ɨ tátrɨ́trɨ́ kúlí tadhábhá ɨ́be dhɨ ɨ̀ totó tá àyɨ kònàle adrélé akódhɨ nɨ asíkì rìnyí sè. ");
INSERT INTO log_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Dɨ Èródè ɨ sòdá nɨ ɨ́be dhɨ ɨ̀ dré kpà akódhɨ nɨ ayɨ́zèzo, adrézó akódhɨ nɨ gu. Gò ɨ̀ dré kánzò aveave asózó rúá, gòzo akódhɨ nɨ mu Pìlátò véna. ");
INSERT INTO log_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Dɨ kìtú nda sè dhɨ, Èródè ɨ Pìlátò be atú adrébhá tá kàrɨbhá ro dhɨ ɨ, ɨ̀ dré atsázó vélé arúpi ró. ");
INSERT INTO log_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Gò Pìlátò dré kòwánà kàdrɨ̀ kɨ azízó, Yúdà ànzɨ kɨ drì kobhá ɨ́be, ɨ̀ndɨ̀ móndyá zyandre ɨ́be, ");
INSERT INTO log_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","tàzoá àyɨ dré dhɨ: «Mɨ̀ adrì àmɨkya agó kònɨ̀dhɨ alɨ̀zo ába má vélé tàzoá dhɨ, adré móndɨ́ kɨ kodzó lɨgɨ́lé. Dɨ, mɨ̀ yi rè ká! Má lizí tá akódhɨ àmɨ kandrá gò, má dré mána tà mɨ̀ dré adrézó akódhɨ nɨ asíkì ásà dhɨ nɨ kisúzó vélána ko. ");
INSERT INTO log_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Èródè kisú kpà tà àlo vélána ko. Àngyá ko, logó akódhɨ àma vélé. Dɨ dhya kònɨ̀dhɨ ꞌo tà àlo kɨtswálépi dràdrà sè dhɨ ko. ");
INSERT INTO log_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ásà dhɨ, má nɨ akódhɨ nɨ ꞌo bhwàle gò, trɨ̀zoá lɨ̀le.»  ");
INSERT INTO log_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Dɨ àyɨ títí nda ɨ̀ dré ngàzo kúlí loyó tàzoá dhɨ: «Mɨ́ kòꞌo dhya kòdhɨ dràle! Mɨ̀ kàtrɨ̀ àma dré Bàrábà kòdhya!» ");
INSERT INTO log_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(À bhe tá Bàrábà nda bǎdzó na, móndɨ́ kɨ kodzoma lɨgɨ́lé bhàandre nda ꞌá dhɨ nɨ tà sè, ɨ̀ndɨ̀ móndɨ́ pfùma nɨ tà sè.) ");
INSERT INTO log_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pìlátò dré gòzo tódhyá tàá àyɨ dré dhɨ, ɨ́ lè tá ɨ́na Yésu nɨ trɨ̀le. ");
INSERT INTO log_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Dɨ ɨ̀ dré ngàzo adrélé tetrélé, adrézó loyóá dhɨ: «Mɨ́ tidí akódhɨ fa kɨpakɨpa dri! Mɨ́ tidí akódhɨ!» ");
INSERT INTO log_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pìlátò dré gòzo tàá àyɨ dré vésè nɨ na sè dhɨ: «Akódhɨ ꞌo àdho tà kònzɨ ꞌɨ? Má kisú mána tà àlo kɨtswálépi dràdrà sè dhɨ vélána ko. Ásà dhɨ, má nɨ akódhɨ nɨ ꞌo bhwàle gò, trɨ̀zoá lɨ̀le.» ");
INSERT INTO log_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Dɨ, ɨ̀ dré àyɨkya gòzo tetrélé rìnyí sè tàzoá dhɨ, à kòtidí akódhɨ fa kɨpakɨpa dri gò, àyɨ kɨ kúlí dré lavúzó. ");
INSERT INTO log_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Dɨ Pìlátò dré tà ɨ̀ dré adrélé zìle nda nɨ kaꞌìzo ꞌòle àyɨ dré. ");
INSERT INTO log_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Dré Bàrábà, bhèle tá bǎdzó na móndɨ́ kɨ kodzoma lɨgɨ́lé dhɨ nɨ tà sè ɨ̀ndɨ̀ móndɨ́ pfùma nɨ tà sè nda nɨ trɨ̀zo, ngóró ɨ̀ dré adrélé zìle dhɨ tɨ́nɨ. Dré Yésu nɨ fèzo àyɨ drɨ́gá, ɨ̀ kòꞌoró ngóró ɨ̀ dré adrélé lèle dhɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ɨ̀ dré tá adréràꞌa Yésu nɨ dri lɨ̀zo ába dhɨ ꞌá dhɨ, ɨ̀ dré agó àlo rú be Sìmónà angálépi Kìrénè lésè dhɨ nɨ nòzo adréràꞌa agòle amvú lésè. Dɨ ɨ̀ dré akódhɨ nda nɨ rùzo, fa kɨpakɨpa bhàzo drìá gò, akódhɨ nɨ ꞌòzo fa nda nɨ do lɨ̀zo ába Yésu vésè. ");
INSERT INTO log_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Móndɨ́ zyandre lavúlé dhɨ ɨ̀ adré tá lɨ̀le Yésu vésè. Àyɨ nda ɨ kòfalé dhɨ, tòkó àruka ɨ̀ adré tá àwó ngo, adrézó tongólé Yésu nɨ tà sè. ");
INSERT INTO log_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Dɨ Yésu dré áyɨ alázó tàá àyɨ dré dhɨ: «Àmɨ ànzɨtòkó Yèrúsalémà àdhya nɨ ɨ, mɨ̀ kòngo má sè ko. Be ró dhɨ, mɨ̀ kàdré àmɨkya ngòle àmɨ kɨ tàndɨ ɨ sè, ɨ̀ndɨ̀ àmɨ kɨ ànzɨ ɨ sè. ");
INSERT INTO log_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Àngyá ko, lókyá adrélépi alɨ̀le dhɨ sè dhɨ, à nɨ tàá dhɨ: ‹Kólénzé tòkó kóndó ro tibhá ko, ɨ̀ndɨ̀ bà febhá ànzɨmvá ɨ dré ko dhɨ ɨ dré!› ");
INSERT INTO log_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Lókyá nda sè dhɨ, móndɨ́ kɨ tàá kòngó kàdrɨ̀kàdrɨ̀ ɨ dré dhɨ: ‹Mɨ̀ kàdhé àma dri wà!› adrézó kpà tàá kòngó tsàtsà ɨ dré dhɨ: ‹Mɨ̀ kàbvù àma wà!› ");
INSERT INTO log_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Tàko ko, à kàdré ꞌòá kònɨ̀nɨ fa lɨ́drɨ̀ ro dhɨ rú dhɨ, àdho tà nɨ dɨ vélé atsá fa àꞌyo ró dhɨ rú dhɨ nɨ̀?» ");
INSERT INTO log_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","À adrì tá kpà àgo rì drìkònzɨbhá ro dhɨ ɨ pfùle dràle túmä́ní Yésu be. ");
INSERT INTO log_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ɨ̀ kòtsa àrà adrélé zìle Drìfà ro dhɨ na dre dhɨ, ɨ̀ dré Yésu nɨ tidízó fa kɨpakɨpa dri. Ɨ̀ dré kpà drìkònzɨbhá rì nda kɨ tidízó fa àruka ɨ drǐsè, àlo nɨ Yésu nɨ drɨ́ágó lésè, àzya nɨ lìdzí nɨ lésè. ");
INSERT INTO log_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Gò Yésu dré tàzoá dhɨ: «Tátá, mɨ́ kòtrì àyɨ kɨ tàkonzɨ̀. Àngyá ko, ɨ̀ nì tà ɨ̀ dré adrélé ꞌòle dhɨ ko.» Gò sòdá ɨ̀ dré akódhɨ nɨ kɨ́tá kɨ lanzɨ́zó àyɨ kòfalésè dzègé sè. ");
INSERT INTO log_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Móndyá zyandre nda ɨ̀ totó tá àyɨ adrélé tà nda nɨ no. Yúdà ànzɨ kɨ kàdrɨ̀ ɨ̀ adré tá àyɨkya Yésu nɨ gu, adrézó tàá dhɨ: «Akódhɨ tɨdrɨ́ móndɨ́ àruka ɨ ꞌí. Dɨ kàdré Mèsɨ́yà Gìká dré zɨ̀le dhɨ ꞌɨ bàti dhɨ, kòtɨdrɨ́ áyɨ tàndɨ wà!» ");
INSERT INTO log_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Sòdá ɨ̀ adré tá kpà akódhɨ nɨ gu. Ɨ̀ kisí tá àyɨ ànyɨ akódhɨ làga, vìnègárì fe drá, ");
INSERT INTO log_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","tàzoá dhɨ: «Mɨ́ kàdré ópɨ́ Yúdà ànzɨ kya ꞌɨ bàti dhɨ, mɨ́ tɨdrɨ́ ámɨ tàndɨ wà!» ");
INSERT INTO log_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","À di tá wárágà tà tɨsɨ̀zo drìá dhɨ akódhɨ drìle. À tɨsɨ̀ tá dhɨ: «Kònɨ̀dhɨ ópɨ́ Yúdà ànzɨ kya ꞌɨ.» ");
INSERT INTO log_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Drìkònzɨbhá tidílé Yésu làga nda kɨ àlo adré tá kpà akódhɨ nɨ lodhá, adrézó tàá dhɨ: «Mɨ mɨ́na Mèsɨ́yà ꞌɨ ko? Mɨ́ tɨdrɨ́ dɨ àma túmä́ní ámɨ tàndɨ be wà!» ");
INSERT INTO log_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Dɨ, drìkònzɨbhá àzya dré ɨ́na lawàzo drìá, tàzoá dhɨ: «À ŋò kó tà kɨtswálépi dràdrà sè dhɨ mɨ́ dri akódhɨ àdhya tɨ́nɨ dhɨ, mɨ́ adré dɨ mɨ́na Gìká nɨ ro ko àdho tà sè? ");
INSERT INTO log_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Àma ró dhɨ, à ŋò tà àma dri gyǎgya. Mà adré àmakya tà kɨtswálépi tà mà dré ꞌòle dhɨ ɨ sè dhɨ nɨ kisú. Dɨ, dhya kònɨ̀dhɨ ꞌo ɨ́na tà kònzɨ àlo dhɨ ko.» ");
INSERT INTO log_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Gò dré tàzoá dhɨ: «Yésu, lókyá mɨ́ dré dra fɨ̀zo ámɨ òpɨ̀ na dhɨ tú dhɨ, mɨ́ kòtɨvɨ̀ ma ko.» ");
INSERT INTO log_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yésu logó drá dhɨ: «Má adré tà bàti ta mɨ́ dré: Ándrò, mà nɨ adré túmä́ní mɨ́ be pàràdísò na.» ");
INSERT INTO log_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ànyɨ́ànyɨ kìtú rírí sè dhɨ, tínímvá dré bvò nɨ mì dòzo wä́yi, tsàle sáà na kìtú rírí àmvolésè dhɨ na. ");
INSERT INTO log_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Tàko ko, kìtú tayɨ́ tá ɨ́na ngá kazama. Gò kɨ́tá ꞌɨ̀le tépelò nɨ ꞌa lakɨ́zó dhɨ dré lasɨ́zó ꞌa be rì. ");
INSERT INTO log_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Gò Yésu dré liyízó kúlí ꞌuꞌù sè tàzoá dhɨ: «Tátá, má tayɨ́ áma lɨ́drɨ̀ mɨ́ drɨ́gá.» Kòtà tà nda dre dhɨ, dré dràzo. ");
INSERT INTO log_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Rómà kɨ sòdá kɨ kàdrɨ̀ kònò tà títí lavúbhá nda ɨ dre dhɨ, dré Gìká nɨ rú bhàzo kùle, tàzoá dhɨ: «Dhya kòdhɨ tá ɨ́na móndɨ́ gyǎgya ꞌɨ bàti!» ");
INSERT INTO log_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Móndyá zyandre títí ru kɨmóbhá tà nda nɨ no dhɨ ɨ̀ kònò tà lavúbhá nda ɨ dre dhɨ, ɨ̀ dré ngàzo nzɨ̀le àyɨ kɨ agá dibe kɨzà dré. ");
INSERT INTO log_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Dɨ, móndyá títí Yésu nɨ nibhá dhɨ ɨ túmä́ní tòkó akódhɨ nɨ lebèbhá Gàlìláyà lésè dhɨ ɨ́be dhɨ ɨ̀ totó tá àyɨ adrélé tà nda kɨ no lárá ro. ");
INSERT INTO log_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Yúdà ànzɨ kɨ bhàgo kàdrɨ̀ ɨ kòfalé dhɨ, agó àlo rú be Yòséfà angálépi Àrìmàtáyà, bhàandre àlo Yùdáyà le dhɨ lésè dhɨ tá be. Dɨ, akódhɨ nda kaꞌì tá ɨ́na tà bhàgo àruka títí dhɨ ɨ̀ dré ru yìzo ꞌòzoá dhɨ ko. Akódhɨ tá móndɨ́ dóro ɨ̀ndɨ̀ gyǎgya, adrélépi Gìká nɨ Òpɨ̀ letè nòle dhɨ ꞌɨ. ");
INSERT INTO log_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Dɨ dré lɨ̀zo Pìlátò véna Yésu nɨ rúbhá zi tíá. ");
INSERT INTO log_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pìlátò kòkaꞌì dre dhɨ, Yòséfà dré lɨ̀zo rúbhá nda nɨ tɨrɨ́ fa kɨpakɨpa drìlésè, lambézóá kɨ́tá kemve sè gò, lɨ̀zo bhàá mógó àlo gàle kɨ́rà na, àbvò bhàzo lána rè ko dhɨ na. ");
INSERT INTO log_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Kìtú nda tá kìtú adrézó tà ledé sàbátù kandrá dhɨ ꞌɨ. Dɨ sàbátù adré tá ꞌòle kɨdhólé. ");
INSERT INTO log_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Tòkó alɨ̀bhá tá Gàlìláyà lésè túmä́ní Yésu be nda ɨ̀ lebè tá Yòséfà gò, ɨ̀ dré mógó nda nɨ nòzo, ɨ̀ndɨ̀ à bhà Yésu nɨ rúbhá lána ngɨ́nɨ ya dhɨ nɨ nòzo. ");
INSERT INTO log_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Dɨ ɨ̀ dré gòzo nzɨ̀le gò, dò tàdzí be dóro amúlé màlásɨ̀ be dhɨ nɨ ladhɨ́. Dɨ sàbátù tú dhɨ, ɨ̀ dré lovózó ngóró tátrɨ́trɨ́ kúlí dré adrélé tàle à kòꞌo dhɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Kìtú nɨ àlo pósò àdhya sè dhɨ, tòkó nda ɨ̀ dré ngàzo drùbhì kɨ́nó dò tàdzí be dóro ɨ̀ dré tá ladhɨ́lé nda nɨ do lɨ̀zo ába mógó na. ");
INSERT INTO log_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ɨ̀ kòtsa dre dhɨ, ɨ̀ dré kisúzóá dhɨ, à lɨ kɨ́rà mógó nda tísè dre. ");
INSERT INTO log_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Dɨ, ɨ̀ dré fɨ̀zo lána dhɨ, ɨ̀ kisú àyɨkya Mírì Yésu nɨ rúbhá ko. ");
INSERT INTO log_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Àyɨ kɨ drì dré adréràꞌa abɨ́lé tà nda sè dhɨ ꞌá dhɨ, àgo rì kɨ́tá lagulagu ró dhɨ kɨ asóbhá dhɨ ɨ̀ dré agázó àyɨ kandrá. ");
INSERT INTO log_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Dɨ tirì dré gàzo tòkó nda ɨ léna bǐ gò, ɨ̀ dré tandìzo mìbhalé bha kìní na ró. Dɨ, àgo nda ɨ̀ dré tàzoá àyɨ dré dhɨ: «Mɨ̀ adré dhya lɨ́drɨ̀ ro dhɨ nɨ nda àbvò ɨ kòfalé àdho tà sè? ");
INSERT INTO log_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Akódhɨ kònwa yókódhó. Nga ɨ́na dràdrà ꞌásè dre! Mɨ̀ kisù rè tà dré tá tàle àmɨ dré, dré rè dhu adréràꞌa Gàlìláyà na dhɨ ꞌá dhɨ ká. ");
INSERT INTO log_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Akódhɨ tà tá dhɨ: ‹Adré lèá dhɨ, à kòlefè Móndɨ́ nɨ Mvá tàkonzɨ̀bhá ɨ drɨ́gá, akódhɨ nɨ tidízó dràle fa kɨpakɨpa dri gò, kìtú nɨ na sè dhɨ, akódhɨ dré ngàzo dràdrà ꞌásè.›» ");
INSERT INTO log_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Dɨ kúlí dré tá tàle nda ɨ̀ dré agázó àyɨ léna. ");
INSERT INTO log_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Dɨ ɨ̀ kàgò mógó lésè dre dhɨ, ɨ̀ dré tà títí nda kɨ tɨtɨ́zó àpóstolò mudrí-drì-àlo dhɨ ɨ dré, móndyá àruka títí dhɨ ɨ́be. ");
INSERT INTO log_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Tòkó nda ɨ tá: Màrɨ́yà Màgàdàlénè, Yòwánà, Màrɨ́yà Yàkóbhò nɨ andre, tsàle tòkó àruka ɨ. ");
INSERT INTO log_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Dɨ, tà ɨ̀ dré tɨtɨ́lé nda ɨ̀ sù tá ngóró kúlí azaaza ɨ tɨ́nɨ àpóstolò nda ɨ bína gò, ɨ̀ dré kaꞌìzoá ko. ");
INSERT INTO log_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Dɨ, Pétèró dré ɨ́na ngàzo ràle mógó na. Kòtsa tandìle ngá no dre dhɨ, dré ngbà ꞌí kɨ́tá kàtswákàtswa dhɨ kɨ nòzo kòdhya. Dɨ akódhɨ nɨ lɨ́ndrɨ́ dré gàzo gò, dré gòzo nzɨ̀le ɨ́ bhàna, adrélé lizíá ɨ́ léna ngalè àdho tà ꞌo tá ru nɨ̀ ya dhɨ. ");
INSERT INTO log_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Gbǎ kìtú nda sè dhɨ, Yésu nɨ lebèbhá kɨ rì dhɨ ɨ̀ adré tá lɨ̀le bhà àlo rú be Èmáwù dhɨ na. Bhà nda vwà tá Yèrúsalémà rúsè dhɨ ànyɨ́ànyɨ kìlòméterè mudrí-drì-àlo. ");
INSERT INTO log_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ɨ̀ adré tá tà títí lavúbhá Yèrúsalémà na dhɨ kɨ tɨtɨ́. ");
INSERT INTO log_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ɨ̀ dré tá adréràꞌa tà ta ɨ̀ndɨ̀ tà kayí àyɨ kòfalésè dhɨ ꞌá dhɨ, Yésu nɨ tàndɨ dré áyɨ kisízó ànyɨ àyɨ làga gò, ɨ̀ dré adrézó lɨ̀le túmä́ní àyɨ ɨ́be. ");
INSERT INTO log_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Dɨ, à kɨkɨ́ tá àyɨ kɨ mì, ɨ̀ kòkɨtswáró nìá akódhɨ àdhi ꞌɨ ya dhɨ ko. ");
INSERT INTO log_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yésu dré àyɨ kɨ lizízó tàzoá dhɨ: «Mɨ̀ adré tá àdho tà tɨtɨ́ àmɨ kòfalésè, mɨ̀ dré adréràꞌa atsí to dhɨ ꞌá dhɨ?» Dɨ ɨ̀ dré àyɨ kɨ kɨkɨ́zó gò, àyɨ kɨ mìbhalé dré adrézó kɨzà ro lavúlé. ");
INSERT INTO log_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Àyɨ kɨ àlo rú be Kèlèyópà dhɨ dré logózóá drá dhɨ: «Móndyá títí adrébhá tá Yèrúsalémà na dhɨ ɨ kòfalé dhɨ, mɨ ngbà ꞌí móndɨ́ àlo tà lavúbhá kònàle kìtú kònɨ ɨ sè dhɨ kɨ nìlepi ko dhɨ ꞌɨ?» ");
INSERT INTO log_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yésu lizí dhɨ: «Àdho tà ꞌɨ?» Ɨ̀ logó drá dhɨ: «Tà atsábhá Yésu, Nàzàrétà lésè dhɨ rú dhɨ ꞌɨ. Akódhɨ tá pròfétà rìnyi ró kúlí tàma sè ɨ̀ndɨ̀ tà ꞌòma sè Gìká kandrá ɨ̀ndɨ̀ móndyá títí ɨ kandrá dhɨ ꞌɨ. ");
INSERT INTO log_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Dɨ, kòwánà kàdrɨ̀ ɨ àma kɨ drì kobhá ɨ́be dhɨ ɨ̀ lefè tá àyɨkya akódhɨ, à kòbhàró tà akódhɨ dri kɨtswálé dràdrà sè. Gò ɨ̀ dré akódhɨ nɨ tidízó fa kɨpakɨpa dri. ");
INSERT INTO log_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Mà adré tá àmakya mì bha kisùzoá dhɨ, kònò akódhɨ nɨ tá Ɨ̀sèrélè ànzɨ kɨ apá nɨ̀. Kòdhɨ ɨ́be dhɨ, ándrò kònɨ̀dhɨ, kìtú nɨ na tà títí lavúbhá nda ɨ àmvolésè dhɨ ꞌɨ. ");
INSERT INTO log_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Dɨ tòkó àruka àma kòfalé dhɨ ɨ̀ tɨgá àma kɨ lɨ́ndrɨ́ tà tàndɨ ró. Ɨ̀ lɨ̀ tá drùbhì kɨ́nó mógó na. ");
INSERT INTO log_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Dɨ, ɨ̀ kisú àyɨkya akódhɨ nɨ rúbhá ko. Gò ɨ̀ dré agòzo longóá àma dré dhɨ, ángéló ɨ̀ agá tá àyɨ kandrá tàá àyɨ dré dhɨ, Yésu be lɨ́drɨ̀ ro. ");
INSERT INTO log_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Dɨ àma kɨ arúpi àruka ɨ̀ dré lɨ̀zo mógó na gò, ɨ̀ dré tà nda nɨ kisúzó ngóró tòkó nda ɨ̀ dré tá tàle dhɨ tɨ́nɨ. Dɨ, ɨ̀ nò àyɨkya akódhɨ ko.» ");
INSERT INTO log_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Dɨ Yésu tà àyɨ dré dhɨ: «Á! Àmɨ móndɨ́ azaaza ró nɨ ɨ, mɨ̀ adré tà títí pròfétà ɨ̀ dré longólé dhɨ kɨ kaꞌì mbèlè ko! ");
INSERT INTO log_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Adré tá lèá dhɨ, Mèsɨ́yà kònya kɨzà làsú be kònɨ̀nɨ gò, kòfɨró áyɨ mìlanzìlanzì na dhɨ ko?» ");
INSERT INTO log_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Gò Yésu dré tà títí tɨsɨ̀le áyɨ tà dri Gìká nɨ Kúlí na dhɨ kɨ àndu ngɨ̀zo àyɨ dré, kɨdhólé Mósè nɨ búkù ɨ lésè pròfétà títí dhɨ kya ɨ́be. ");
INSERT INTO log_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ɨ̀ kòtsa ànyɨ bhà ɨ̀ dré tá adrézó lɨ̀le lána dhɨ làga dre dhɨ, Yésu dré áyɨ ꞌòzo ngóró ɨ́ adré tá lavúlé na tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Dɨ, ɨ̀ dré akódhɨ nɨ ti lizízó tà tàndɨ ró tàzoá dhɨ: «Mɨ́ kàdré rè túmä́ní àma ɨ́be. Kìtú ndì dre, ɨ̀ndɨ̀ ngá adré anílé.» Dɨ dré fɨ̀zo dzó na adrélé àyɨ ɨ́be. ");
INSERT INTO log_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ɨ̀ kòlɨrɨ́ túmä́ní mɨ́sá làgásè dre dhɨ, Yésu dré mápà adózó, tà tanɨ zìzo drìá Gìká tí gò, ŋòzoá adrélé fèle àyɨ dré. ");
INSERT INTO log_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Gbǎ kòdhwa, àyɨ kɨ mì dré ru nzìzo gò, ɨ̀ dré akódhɨ nɨ nìzo. Dɨ, dré ɨ́na tavɨ̀zo àyɨ mìlésè. ");
INSERT INTO log_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Gò ɨ̀ dré tàzoá àyɨ kòfalésè dhɨ: «Àma kɨ togó adré tá zakó àtsɨ ró, dré tá adréràꞌa tà ta àma dré láti na, adrézó tà Gìká nɨ Kúlí na dhɨ kɨ àndu ngɨ àma dré dhɨ ꞌá!» ");
INSERT INTO log_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Gbǎ lókyá nda sè dhɨ, ɨ̀ dré ngàzo gòle Yèrúsalémà na. Ɨ̀ kòtsa dre dhɨ, ɨ̀ dré Yésu nɨ lebèbhá mudrí-drì-àlo ru kɨmóbhá móndɨ́ àruka ɨ́be dhɨ kɨ kisúzó. ");
INSERT INTO log_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Àyɨ nda ɨ̀ dré tàzoá dhɨ: «Bàti, Mírì nga dràdrà ꞌásè dre! Agá ɨ́na Pétèró kandrá!» ");
INSERT INTO log_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Gò àyɨ rìti nda ɨ̀ dré tà títí lavúbhá láti na dhɨ kɨ tɨtɨ́zó àyɨ dré. Ɨ̀ tɨtɨ́ tá kpà, ɨ̀ nì tá Yésu àdhi ꞌɨ ya dhɨ, dré tá adréràꞌa mápà ŋo dhɨ ꞌá. ");
INSERT INTO log_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ɨ̀ dré rè dhu adréràꞌa tà nda kɨ ta dhɨ ꞌá dhɨ, Yésu nɨ tàndɨ dré agázó áyɨ totó àyɨ kòfalé gò, tàá àyɨ dré dhɨ: «Tà kɨ̀drɨ́kɨ̀drɨ kàdré àmɨ ɨ́be!» ");
INSERT INTO log_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Dɨ àyɨ kɨ lɨ́ndrɨ́ dré gàzo tirì dré gò, ɨ̀ dré adrézó kisùá dhɨ, ɨ̀ adré móndɨ́ lɨ́ndrɨ́ no kòdhya. ");
INSERT INTO log_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Dɨ, Yésu dré tàzoá àyɨ dré dhɨ: «Àmɨ kɨ drì adré abɨ́lé àdho tà sè? Mɨ̀ adré kpà tà kayí àmɨ léna àdho tà sè? ");
INSERT INTO log_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Mɨ̀ nò rè áma drɨ́gá ɨ áma pá ɨ́be nɨ ɨ ká. Kònɨ̀dhɨ áma tàndɨ ꞌɨ! Mɨ̀ tabè ma atógyàzoá dhɨ, móndɨ́ lɨ́ndrɨ́ zǎ ɨ́be ɨ̀ndɨ̀ fà ɨ́be, ngóró mɨ̀ dré adrélé nòle má dré adrézó ába kòndɨ tɨ́nɨ dhɨ ko.» ");
INSERT INTO log_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Kòtà tà nda dre dhɨ, dré áyɨ drɨ́gá kɨ tadházó áyɨ pá ɨ́be àyɨ dré. ");
INSERT INTO log_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Dɨ, ɨ̀ kɨtswá tá àyɨkya tà nda nɨ kaꞌì dhu rè ko togó kɨ̀nɨ́ dré ɨ̀ndɨ̀ lɨ́ndrɨ́ga dré. Dɨ Yésu dré lizízóá dhɨ: «Àmɨ ngá nyàle dhɨ ɨ́be kònwa?» ");
INSERT INTO log_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Dɨ ɨ̀ dré kosyá ɨ̀ dré lɨbhɨ́lé dhɨ nɨ àmbí fèzo drá. ");
INSERT INTO log_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Gò dré dòzoá nyàle àyɨ mi. ");
INSERT INTO log_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Dɨ dré tàzoá àyɨ dré dhɨ: «Mà dré tá adréràꞌa túmä́ní àmɨ ɨ́be dhɨ ꞌá dhɨ, má tà tá tà kònɨ ɨ àmɨ dré: ‹Adré lèá dhɨ, tà títí tɨsɨ̀le áma tà dri Mósè nɨ tátrɨ́trɨ́ kúlí na, pròfétà kɨ búkù ɨ ꞌásè, ɨ̀ndɨ̀ Yúdà ànzɨ kɨ Longó ɨ ꞌásè dhɨ ɨ̀ kòꞌo ru.›» ");
INSERT INTO log_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Gò dré àyɨ kɨ tògyá nzìzo, ɨ̀ kònìró tà tɨsɨ̀le Gìká nɨ Kúlí na dhɨ kɨ àndu be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Dré tàzoá àyɨ dré dhɨ: «À tɨsɨ̀ tá tà kònɨ ɨ: Mèsɨ́yà nɨ kɨzà nya dràzo gò, kìtú nɨ na sè dhɨ, dré ngàzo dràdrà ꞌásè. ");
INSERT INTO log_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","À tɨsɨ̀ kpà dhɨ, à nɨ kúlí longó akódhɨ nɨ rú sè súrú títí ɨ dré kɨdhólé Yèrúsalémà na tàzoá dhɨ, ɨ̀ kòladzá àyɨ kɨ togó, Gìká kòtrìró àyɨ kɨ tàkonzɨ̀ ɨ be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Àmɨ dhya tà nda kòdhɨ kɨ nobhá mì sè, ɨ̀ndɨ̀ yibhá bíbhálé sè dhɨ ꞌɨ. ");
INSERT INTO log_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Mɨ̀ yi rè ká! Má nɨ mána Tɨrɨ́ Lólo áma Atá dré lazílé dhɨ nɨ amù àmɨ dré. Dɨ àmɨ ró dhɨ, mɨ̀ kàdré adrélé bhàandre ꞌá, tsàle lókyá rìnyí apfòlepi bhù lésè nda dré dra àmɨ kɨ asózó dhɨ ꞌá.» ");
INSERT INTO log_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Gò Yésu dré àyɨ kɨ drìzo lɨ̀zo àyɨ ɨ́be tsàle ànyɨ Bètànɨ́yà làga. Dré drɨ́gá tɨngázó kurú na, tà tanɨ zìzo Gìká tí àyɨ dri. ");
INSERT INTO log_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Dɨ dré adréràꞌa tà tanɨ zi àyɨ dri dhɨ ꞌá dhɨ, dré àyɨ kɨ tayɨ́zó gò, Gìká dré akódhɨ nɨ dòzo bhù na. ");
INSERT INTO log_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Dɨ ɨ̀ dré àyɨkya ledhézó àyɨ kɨ kórókó titì akódhɨ nɨ lɨndrɨ̀ bhàzo gò, ɨ̀ dré gòzo Yèrúsalémà na kólénzé be bǐ. ");
INSERT INTO log_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Dɨ kìtú àlo àlo títí ɨ sè dhɨ, ɨ̀ adré tá tépelò na, adrélé Gìká nɨ rú bha kùle landè àko ró.");
INSERT INTO log_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ngá wä́yi dhɨ kɨ bhàma kandrá dhɨ, Kúlí tá be. Kúlí nda tá túmä́ní Gìká be, ɨ̀ndɨ̀ Kúlí nda tá Gìká ꞌɨ. ");
INSERT INTO log_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Akódhɨ tá túmä́ní Gìká be drìdrì ngá wä́yi dhɨ kɨ bhàma kandrá. ");
INSERT INTO log_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Gìká ꞌo tá akódhɨ ngá wä́yi dhɨ kɨ bha dhɨ kòdhya. Dɨ ngá àlo bhàle akódhɨ àko dhɨ yókódhó. ");
INSERT INTO log_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Lɨ́drɨ̀ tá akódhɨ léna, ɨ̀ndɨ̀ lɨ́drɨ̀ nda tá ngádra ꞌɨ móndɨ́ ɨ dré. ");
INSERT INTO log_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ngádra nda adré kòle tínímvá na, ɨ̀ndɨ̀ tínímvá kɨtswá akódhɨ nɨ lavú bwà ko. ");
INSERT INTO log_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Gìká amù tá dhya àlo rú be Yòwánɨ̀ dhɨ. ");
INSERT INTO log_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Akódhɨ nda alɨ̀ ngádra nda nɨ tà longó, móndyá wä́yi dhɨ ɨ̀ kòkaꞌìró ásà be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yòwánɨ̀ nɨ tàndɨ tá ngádra nda ꞌɨ ko. Dɨ, akódhɨ alɨ̀ ɨ́na ngádra nda nɨ tà longó. ");
INSERT INTO log_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Tàko ko, ngádra bàti adrélépi ngá kazá móndyá wä́yi ɨ dré dhɨ, adré tá alɨ̀le bvò le. ");
INSERT INTO log_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Dɨ dhya adrélépi Kúlí ꞌɨ nda alɨ̀ tá adrélé bvò le. Dɨ, tágba Gìká dré akódhɨ nɨ ꞌòzo bvò nda nɨ bha dhɨ, móndyá bvò nda àdhya ɨ̀ nì akódhɨ ko. ");
INSERT INTO log_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Akódhɨ atsá áyɨ tàndɨ nɨ móndyá ɨ vélé. Dɨ, móndyá akódhɨ àdhya nda ɨ̀ kaꞌì àyɨkya akódhɨ ko. ");
INSERT INTO log_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Tágba kònɨ̀nɨ dhɨ, móndyá wä́yi akódhɨ nɨ kaꞌìbhá, akódhɨ nɨ dòzo àyɨ kɨ togó na dhɨ ɨ dré dhɨ, akódhɨ fè rìnyí ɨ̀ dré atsázó Gìká nɨ ànzɨ ɨ ró. ");
INSERT INTO log_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","À ti ànzɨ nda ɨ ngóró móndɨ́ ɨ̀ dré adrélé ànzɨ ti dhɨ tɨ́nɨ ko, ngóró móndɨ́ ɨ̀ dré adrélé tà le ꞌòle dhɨ tɨ́nɨ ko, ɨ̀ndɨ̀ agó dré adrélé tà le ꞌòle dhɨ tɨ́nɨ ko. Be ró dhɨ, Gìká ti àyɨ atsálé áyɨ ànzɨ ɨ ró dhɨ nɨ̀. ");
INSERT INTO log_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Dhya adrélépi Kúlí ꞌɨ nda atsá tá móndɨ́ ro gò, dré bhà mòzo àma kòfalé adrézó túmä́ní àma ɨ́be. Mà nò akódhɨ nɨ mìlanzìlanzì ꞌí. Mìlanzìlanzì nda, mìlanzìlanzì Gìká nɨ Mváagó àlo kwákwá nda dré kisúlé áyɨ Atá véna dhɨ ꞌɨ. Akódhɨ ga togó tanɨ sè bǐ, ɨ̀ndɨ̀ tà bàti sè bǐ. ");
INSERT INTO log_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Dɨ Yòwánɨ̀ longó tá akódhɨ nda nɨ tà ngádra ꞌá móndɨ́ ɨ dré. Akódhɨ loyó kúlí tàzoá dhɨ: «Kònɨ̀dhɨ dhya má dré tá tà nɨ nɨ tàzo dhɨ ꞌɨ. Má tà tá dhɨ: ‹Dhya adrélépi adhélé má bvó dhɨ kàdrɨ̀ áma lavú. Tàko ko, áma tirà ko dhɨ ꞌá dhɨ, akódhɨ tá ɨ́na be.›» ");
INSERT INTO log_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Akódhɨ nda nɨ togó tanɨ kàdrɨ̀ lavúlé dhɨ sè dhɨ, àma títí, mà kisú tà tanɨ tà tanɨ àzya dri. ");
INSERT INTO log_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Tàko ko, Gìká longó tá áyɨ tátrɨ́trɨ́ kúlí Mósè tí. Dɨ, fè Yésu Krísto áyɨ togó tanɨ tadhá áyɨ tà bàti be dhɨ kòdhya. ");
INSERT INTO log_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Dhya àlo nò tàdzí Gìká ko. Dɨ, akódhɨ nɨ Mváagó àlo kwákwá adrélépi ɨ́na Gìká ro, ɨ̀ndɨ̀ adrélépi áyɨ Atá làga nda, ꞌo Gìká móndɨ́ ɨ̀ dré nìle dhɨ nɨ̀. ");
INSERT INTO log_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yúdà ànzɨ kɨ kàdrɨ̀ Yèrúsalémà na dhɨ ɨ̀ dré kòwánà kɨ mùzo Lévì ɨ́be lɨ̀le Yòwánɨ̀ véna dhɨ, àyɨ nda ɨ̀ lizí tá akódhɨ tí dhɨ: «Mɨ àdhi ꞌɨ?» ");
INSERT INTO log_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Dɨ akódhɨ gà kúlí logoma àyɨ tí dhɨ ko. Dɨ, tà ɨ́na ngádra ꞌá dhɨ: «Ma Mèsɨ́yà ꞌɨ ko.» ");
INSERT INTO log_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ɨ̀ gò lizíá tíá dhɨ: «Mɨ dɨ mɨ́na àdhi ꞌɨ? Mɨ Èlɨ́yà ꞌɨ?» Akódhɨ logó dhɨ: «Kóko, ma Èlɨ́yà ꞌɨ ko.» Ɨ̀ gò lizíá dhɨ: «Mɨ Pròfétà tá tà nɨ nɨ longózó dhɨ ꞌɨ?» Akódhɨ logó dhɨ: «Kóko.» ");
INSERT INTO log_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ɨ̀ gò tàá drá dhɨ: «Mɨ dɨ mɨ́na àdhi ꞌɨ, mà kòkɨtswáró kúlí logó dhya àma kɨ amùbhá dhɨ ɨ dré? Mɨ́ adré tàá ámɨ tàndɨ nɨ tà sè ngɨ́nɨ?» ");
INSERT INTO log_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Dɨ Yòwánɨ̀ logó kúlí ngóró pròfétà Èsáyà dré tá tàle kɨ́nó dhɨ tɨ́nɨ: «Ma dhya adrélépi kúlí loyó duku na dhɨ ꞌɨ. Má adré tàá dhɨ: ‹Mɨ̀ kòlotó láti atsálé pyà Mírì dré!›» ");
INSERT INTO log_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Dhya mùle nda kɨ àruka ɨ tá Fàrìsáyò ꞌɨ. ");
INSERT INTO log_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Dɨ àyɨ nda ɨ̀ gò Yòwánɨ̀ nɨ lizí: «Mɨ́ kàdré mɨ́na Mèsɨ́yà ꞌɨ yà, Èlɨ́yà ꞌɨ yà, kó ngalè Pròfétà ꞌɨ yà dhɨ ko dhɨ, mɨ́ adré dɨ bàtísimò fe àdho tà sè?» ");
INSERT INTO log_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yòwánɨ̀ logó àyɨ dré dhɨ: «Má adré mána bàtísimò fe yǐ sè. Dɨ, dhya àlo mɨ̀ dré nìle ko dhɨ ɨ́na kònwa àmɨ kòfalé. ");
INSERT INTO log_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Akódhɨ nda adré adhélé má bvó dhɨ nɨ̀. Má kɨtswá mána akódhɨ nɨ lɨndrɨ̀ sè ko. Má kɨtswá ndɨ̀ndɨ̀ akódhɨ nɨ kámókà bǎ trɨ bwà ko.» ");
INSERT INTO log_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Tà títí nda kòdhɨ ɨ̀ ꞌo tá ru Bètànɨ́yà na, Yòròdánè nɨ taꞌá na, àrà Yòwánɨ̀ dré tá adrézó bàtísimò fe dhɨ na. ");
INSERT INTO log_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Kìtú bvóá dhɨ sè dhɨ, Yòwánɨ̀ dré Yésu nɨ nòzo adréràꞌa alɨ̀le ɨ́ vélé gò, dré tàzoá dhɨ: «Mɨ̀ nò rè Kábilígyà Mvá Gìká àdhya adrélépi móndyá bvò àdhya kɨ tàkonzɨ̀ tɨngá dhɨ ká! ");
INSERT INTO log_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Kònɨ̀dhɨ dhya má dré tá tà nɨ nɨ tàzo dhɨ ꞌɨ. Má tà tá dhɨ: ‹Agó adrélépi adhélé má bvó dhɨ kàdrɨ̀ áma lavú. Tàko ko, áma tirà ko dhɨ ꞌá dhɨ, akódhɨ tá ɨ́na be.› ");
INSERT INTO log_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Áma tàndɨ, má nì tá akódhɨ àdhi ꞌɨ ya dhɨ ko. Dɨ, má alɨ̀ mána bàtísimò fe yǐ sè, Gìká kòtadháró akódhɨ Ɨ̀sèrélè ànzɨ ɨ dré be dhɨ bvó.» ");
INSERT INTO log_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yòwánɨ̀ gò tàá dhɨ: «Má nò Tɨrɨ́ Lólo asíràꞌa bhù lésè kòbhòlà tɨ́nɨ adhélé adrélé akódhɨ dri. ");
INSERT INTO log_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Áma tàndɨ, má nì tá akódhɨ àdhi ꞌɨ ya dhɨ ko. Dɨ, Gìká áma amùlepi bàtísimò fe yǐ sè dhɨ tà tá má dré dhɨ: ‹Dhya mɨ́ dré dra Tɨrɨ́ Lólo nòzo asíràꞌa adhélé adrélé drìá dhɨ, akódhɨ nda nɨ bàtísimò fe Tɨrɨ́ Lólo sè nɨ̀.› ");
INSERT INTO log_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Dɨ áma tàndɨ, má nò tà nda áma mì sè gò, má dré adrézó longóá ngádra ꞌá dhɨ, akódhɨ nda Gìká nɨ Mváagó ꞌɨ.» ");
INSERT INTO log_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Kìtú bvóá dhɨ sè dhɨ, Yòwánɨ̀ ɨ lebèbhá nɨ ɨ́be rì dhɨ ɨ̀ dré gòzo tódhyá adrélé àrà nda na. ");
INSERT INTO log_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Akódhɨ dré Yésu nɨ nòzo adréràꞌa lavúlé dhɨ, dré tàzoá dhɨ: «Mɨ̀ nò rè Kábilígyà Mvá Gìká àdhya ká!» ");
INSERT INTO log_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Akódhɨ nɨ lebèbhá rì nda ɨ̀ kòyi akódhɨ nɨ kúlí nda dre dhɨ, ɨ̀ dré ngàzo adrélé Yésu nɨ lebè. ");
INSERT INTO log_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Dɨ Yésu dré áyɨ alázó àyɨ kɨ no adréràꞌa áyɨ lebè gò, dré àyɨ kɨ lizízó tàzoá dhɨ: «Mɨ̀ adré àdho nda?» Ɨ̀ tà drá dhɨ: «Rábbì, mɨ́ adré adrélé ángolé?» (Rú «Rábbì» nda kòdhɨ adré lèá tàle dhɨ «Tà tadhálépi».) ");
INSERT INTO log_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Akódhɨ logó àyɨ dré dhɨ: «Mɨ̀ alɨ̀, mɨ̀ nɨ nòá.» Dɨ ɨ̀ dré lɨ̀zo àrà dré tá adrézó adrélé dhɨ nɨ no. Gò ɨ̀ dré adrézó túmä́ní akódhɨ be kìtú nda nɨ àmbí sè títí. Lókyá nda tá ànyɨ́ànyɨ sáà su kìtú rírí àmvolésè dhɨ ꞌɨ. ");
INSERT INTO log_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Àyɨ rì Yòwánɨ̀ nɨ kúlí yibhá gò ɨ̀ dré Yésu nɨ lebèzo nda kɨ àlo tá Àndréyà, Sìmónà Pétèró nɨ adrúpi ꞌɨ. ");
INSERT INTO log_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Dɨ akódhɨ nda dré zyà ngàzo lɨ̀le áyɨ adrúpi Sìmónà nɨ kisú gò, tàzoá drá dhɨ: «Mà kisú Mèsɨ́yà dre.» (Rú «Mèsɨ́yà» nda kòdhɨ adré lèá tàle dhɨ «Krísto».) ");
INSERT INTO log_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Dré Sìmónà nda nɨ drìzo lɨ̀zo ába Yésu véna. Dɨ Yésu dré akódhɨ nɨ nòzo dɨ̀ɨɨ́ gò, tàzoá dhɨ: «Mɨ, Sìmónà, Yòwánɨ̀ nɨ mvá ꞌɨ. À nɨ ámɨ rú zi Kéfà.» (Rú nda kòdhɨ adré lèá tàle dhɨ «Pétèró».) ");
INSERT INTO log_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Kìtú bvóá dhɨ sè dhɨ, Yésu lè tá lɨ̀le bvò Gàlìláyà àdhya na gò, dré láti dòzo lɨ̀zo. Dré Fìlípò nɨ kisúzó gò, tàzoá drá dhɨ: «Mɨ́ lebè ma!» ");
INSERT INTO log_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Fìlípò nda angá tá Bètèsàyɨ́dà, bhàandre Àndréyà kya Pétèró be dhɨ lésè. ");
INSERT INTO log_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Dɨ Fìlípò dré ngàzo lɨ̀le Nàtànàyélè nɨ kisú gò, tàzoá drá dhɨ: «Mà kisú dhya Mósè dré tà nɨ nɨ tɨsɨ̀zo búkù tátrɨ́trɨ́ kúlí àdhya léna, ɨ̀ndɨ̀ pròfétà ɨ̀ dré kpà tà nɨ nɨ longózó dhɨ dre. Akódhɨ nda, Yésu, Yòséfà nɨ mvá Nàzàrétà lésè dhɨ ꞌɨ.» ");
INSERT INTO log_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Dɨ Nàtànàyélè nda tà drá dhɨ: «Ngá dóro nɨ kɨtswá apfòle Nàzàrétà lésè bwà?» Fìlípò logó drá dhɨ: «Mɨ́ alɨ̀ nòá.» ");
INSERT INTO log_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yésu kònò Nàtànàyélè adréràꞌa alɨ̀le ɨ́ vélé dre dhɨ, dré tàzoá akódhɨ nɨ tà sè dhɨ: «Mɨ̀ nò rè Ɨ̀sèrélè mvá bàti kònɨ̀dhɨ. Túrúpfú tà akódhɨ léna yókódhó.» ");
INSERT INTO log_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Dɨ Nàtànàyélè dré Yésu nɨ lizízó tàzoá dhɨ: «Mɨ́ nì ma ngɨ́nɨ?» Yésu logó drá dhɨ: «Drìdrì Fìlípò dré ámɨ azízó, mɨ́ dré tá adréràꞌa fígì kómvó dhɨ ꞌá dhɨ, má nò tá mɨ ꞌí.» ");
INSERT INTO log_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Dɨ Nàtànàyélè tà drá dhɨ: «Rábbì, mɨ Gìká nɨ Mváagó ꞌɨ bàti! Mɨ Ɨ̀sèrélè ànzɨ kɨ Ópɨ́ ꞌɨ!» ");
INSERT INTO log_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Dɨ Yésu logó drá dhɨ: «Mɨ́ adré áma kaꞌì, má dré tàle mɨ́ dré dhɨ má nò tá mɨ fígì kómvó dhɨ sè? Mɨ́ nɨ tà kàdrɨ̀kàdrɨ̀ dra tà kòdhɨ nɨ lavúbhá dhɨ kɨ no!» ");
INSERT INTO log_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Gò tàá dhɨ: «Má adré tà bàti ta àmɨ dré: Mɨ̀ nɨ bhù no ru lanzíràꞌa, adrézó kpà Gìká nɨ ángéló kɨ no adréràꞌa tombàle ɨ̀ndɨ̀ tisílé Móndɨ́ nɨ Mvá drǐsè!» ");
INSERT INTO log_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Kìtú rì àmvolésè dhɨ, à adré tá gwányá làmó àdhya nɨ ꞌo bhàandre Kánà àdhya Gàlìláyà le dhɨ na. Yésu nɨ andre tá kònàle be. ");
INSERT INTO log_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","À zi tá kpà Yésu ɨ lebèbhá nɨ ɨ́be lɨ̀le gwányá nda na. ");
INSERT INTO log_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Dɨ vínò dré akɨ́zó gò, Yésu nɨ andre dré tàzoá drá dhɨ: «Vínò àyɨ dré vélé yó.» ");
INSERT INTO log_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Dɨ Yésu logó drá dhɨ: «Áma andre, mɨ́ adré áma so tà kòdhɨ léna àdho tà sè? Lókyá mána kɨtswá rè ko.» ");
INSERT INTO log_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Dɨ, andre nɨ dré tàzoá màrábà ɨ dré dhɨ: «Mɨ̀ kòꞌo tà ángùdhi akódhɨ dré dra tàle àmɨ dré dhɨ kòdhya.» ");
INSERT INTO log_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Àrà nda ꞌá dhɨ, lɨ̀drɨ́ nzi-drì-àlo ledélé kɨ́rà sè dhɨ ɨ tá be. Lɨ̀drɨ́ làsú be kònɨ̀nɨ nda ɨ sè dhɨ, Yúdà ànzɨ ɨ̀ adré tá yǐ tokó adrézó àyɨ kɨ temvé ásà. Lɨ̀drɨ́ àlo àlo nda kɨ ꞌa adré tá yǐ do ànyɨ́ànyɨ líterè nyadhɨ-nzi. ");
INSERT INTO log_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Dɨ Yésu dré tàzoá màrábà nda ɨ dré dhɨ: «Mɨ̀ tokó yǐ todàle gàle lɨ̀drɨ́ kònɨ ɨ ꞌásè.» Gò ɨ̀ dré tokózóá todàle gàle àyɨ ꞌásè bǐbi. ");
INSERT INTO log_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Yésu dré gòzo tàá àyɨ dré dhɨ: «Mɨ̀ ko nyànomvá lɨ̀zo ába gwányá líyí dré.» Dɨ ɨ̀ dré ꞌòzoá kònɨ̀nɨ. ");
INSERT INTO log_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Gwányá líyí nda nɨ yǐ tabhì dhɨ, àkò yǐ nda ladzá ru atsálé vínò ro dre. Akódhɨ nì tá ngalè vínò nda angá ángolésè ya dhɨ ko. Dɨ, màrábà yǐ nda nɨ kobhá dhɨ ɨ̀ nì àyɨkya be. Dɨ gwányá líyí nda dré dhya tòkó mòlepi dhɨ nɨ azízó, ");
INSERT INTO log_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","tàzoá drá dhɨ: «Móndyá wä́yi dhɨ ɨ̀ adré gà vínò dóro lavúlé dhɨ nɨ fe mvùle ꞌíká. Dɨ à kòmvu tà tàndɨ ró dre dhɨ, ɨ̀ dré gòzo adrélé vínò dóro wä́yi ko dhɨ nɨ fe mvùle ndò. Dɨ, mɨ́ zù mɨ́na vínò dóro lavúlé dhɨ gò afèzoá nyànomvá.» ");
INSERT INTO log_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Kòrɨ̀dhɨ, tà lɨ́ndrɨ́ga ró Yésu dré ꞌòle drìdrì dhɨ ꞌɨ. ꞌO tá tà nda Kánà, bvò Gàlìláyà àdhya lé dhɨ na. ꞌO kònɨ̀nɨ kɨtswázó áyɨ mìlanzìlanzì tadhá gò, akódhɨ nɨ lebèbhá ɨ̀ dré akódhɨ nɨ kaꞌìzo ásà. ");
INSERT INTO log_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Àmvolásà dhɨ, Yésu ɨ̀ dré lɨ̀zo andre nɨ ɨ́be, adrúpi nɨ ɨ́be ɨ̀ndɨ̀ lebèbhá nɨ ɨ́be, tsàle bhàandre Kàpàrànàwúmà àdhya na. Gò ɨ̀ dré adrézó kònàle gìle lókyá be vwàvwà ro tsà. ");
INSERT INTO log_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Yúdà ànzɨ kɨ gwányá Pásɨkà àdhya atsá tá ànyɨ gò, Yésu dré mbàzo Yèrúsalémà na. ");
INSERT INTO log_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Kòfɨ tépelò nɨ bhàꞌálé na dre dhɨ, dré móndɨ́ adrébhá tá tí kɨ lagɨ́ kábilígyà ɨ́be ɨ̀ndɨ̀ kòbhòlà ɨ́be dhɨ kɨ kisúzó, túmä́ní móndɨ́ lɨrɨ́bhá adrélé làfa topfó mɨ́sá ɨ làgásè dhɨ ɨ́be. ");
INSERT INTO log_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Dɨ dré ngàzo fɨ́mbò ledé bǎ sè gò, àyɨ kɨ ladrózó topfòle títí tépelò nda ꞌásè, àyɨ kɨ tí ɨ́be ɨ̀ndɨ̀ àyɨ kɨ kábilígyà ɨ́be. Dré móndyá adrébhá tá làfa topfó nda kɨ làfa arɨ́zó, mɨ́sá àyɨkya kɨ lebhézó kìní mi. ");
INSERT INTO log_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Gò dré tàzoá móndyá adrébhá tá kòbhòlà lagɨ́ nda ɨ dré dhɨ: «Mɨ̀ nga kònwásè àmɨ kɨ ngá kòdhɨ ɨ́be títí! Mɨ̀ kòbhà áma Atá nɨ dzó atsálé àrà adrézó ngá lagɨ́ dhɨ ró ko!» ");
INSERT INTO log_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Dɨ tà tɨsɨ̀le Gìká nɨ Kúlí na kònɨ̀dhɨ dré agázó akódhɨ nɨ lebèbhá ɨ léna: «Áma togó àtsɨ ró ámɨ dzó nɨ tà sè dhɨ nɨ áma za vèle.» ");
INSERT INTO log_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Gò Yúdà ànzɨ kɨ kàdrɨ̀ ɨ̀ dré lizízóá Yésu tí dhɨ: «Mɨ́ nɨ àdho tà lɨ́ndrɨ́ga ró dhɨ nɨ ꞌo tadházóá àma dré dhɨ, Gìká fè mɨ́ dré rìnyí adrézó tà kòdhɨ kɨ ꞌo nɨ̀ dhɨ?» ");
INSERT INTO log_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Dɨ Yésu logó àyɨ dré dhɨ: «Mɨ̀ kòpfu tépelò kònɨ̀dhɨ dhɨ, má nɨ go tɨngáá kìtú na àmvolésè.» ");
INSERT INTO log_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Yúdà ànzɨ nda ɨ̀ gò tàá dhɨ: «Tépelò kònɨ̀dhɨ nɨ sìzo dhɨ do tá kóná nyadhɨ-rì-drì-nzi-drì-àlo. Mɨ́ nɨ dɨ go sìá kìtú na sè ngɨ́nɨngɨ́nɨ ró?» ");
INSERT INTO log_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Dɨ, tépelò Yésu dré tá adrézó tà nɨ nɨ ta dhɨ ɨ́na akódhɨ nɨ rúbhá ꞌɨ. ");
INSERT INTO log_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Akódhɨ nɨ ngàma dràdrà ꞌásè dhɨ àmvolésè dhɨ, kúlí dré tá tàle nda kòdhɨ dré gòzo agálé akódhɨ nɨ lebèbhá ɨ léna. Dɨ ɨ̀ dré tà tɨsɨ̀le Gìká nɨ Kúlí na dhɨ kɨ kaꞌìzo, kúlí Yésu dré tá tàle dhɨ ɨ́be. ");
INSERT INTO log_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yésu dré tá adréràꞌa Yèrúsalémà na gwányá Pásɨkà àdhya nɨ tà sè dhɨ ꞌá dhɨ, móndɨ́ zyandre dhɨ ɨ̀ dré tà lɨ́ndrɨ́ga ró dré adrélé ꞌòle dhɨ kɨ nòzo gò, ɨ̀ dré akódhɨ nɨ kaꞌìzo. ");
INSERT INTO log_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Dɨ, Yésu kaꞌì tá ɨ́na àyɨ nda kɨ tà ko. Tàko ko, nì móndyá títí dhɨ kɨ tà be. ");
INSERT INTO log_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Lè tá à kòtà móndɨ́ kɨ tà akódhɨ dré dhɨ ko. Àngyá ko, nì ɨ́na tà adrélépi móndɨ́ kɨ togó na dhɨ be. ");
INSERT INTO log_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Fàrìsáyò ɨ kòfalé dhɨ, agó àlo rú be Nìkòdémò dhɨ tá be. Akódhɨ tá kpà Yúdà ànzɨ kɨ kàdrɨ̀ kɨ àlo ꞌɨ. ");
INSERT INTO log_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ngátsi àlo sè dhɨ, alɨ̀ tá Yésu vélé gò, tàá drá dhɨ: «Rábbì, mà nì tàle dhɨ, Gìká amù mɨ adrélé áyɨ tà tadhálépi ró nɨ̀ dhɨ be. Àngyá ko, dhya àlo kɨtswá tá tà lɨ́ndrɨ́ga ró mɨ́ dré adrélé ꞌòle dhɨ kɨ ꞌo bwà ko, Gìká kàdré tá túmä́ní akódhɨ be ko dhɨ.» ");
INSERT INTO log_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yésu logó drá dhɨ: «Má adré tà bàti ta mɨ́ dré: Dhya àlo kɨtswá Gìká nɨ Òpɨ̀ no bwà ko, kòtayɨ́ ɨ gòle tìle tódhyá ko dhɨ.» ");
INSERT INTO log_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Dɨ Nìkòdémò lizí tíá dhɨ: «Móndɨ́ agàlepi dre dhɨ nɨ áyɨ tayɨ́ gòle tìle tódhyá ngɨ́nɨngɨ́nɨ ró? A nɨ kɨtswá gòle fɨ̀le áyɨ andre lé gò, gòzo akódhɨ nɨ ti vésè be rì bwà?» ");
INSERT INTO log_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yésu gò logóá drá dhɨ: «Má adré tà bàti ta mɨ́ dré: Dhya ángùdhi tìle yǐ sè ɨ̀ndɨ̀ Gìká nɨ Tɨrɨ́ sè ko dhɨ kɨtswá ɨ́na fɨ̀le Gìká nɨ Òpɨ̀ na bwà ko. ");
INSERT INTO log_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Dhya móndɨ́ dré tìle nɨ̀ dhɨ, akódhɨ nda lɨ́drɨ̀ rúbhá àdhya ɨ́be. Dɨ, dhya Gìká nɨ Tɨrɨ́ dré tìle nɨ̀ dhɨ, akódhɨ nda lɨ́drɨ̀ Tɨrɨ́ àdhya ɨ́be. ");
INSERT INTO log_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Lè ámɨ lɨ́ndrɨ́ kàdré gàle, má dré tàle mɨ́ dré dhɨ ‹Lè mɨ́ kòtayɨ́ mɨ gòle tìle tódhyá› dhɨ sè ko. ");
INSERT INTO log_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Lyǎ adré vìle àrà ángùdhi dré adrézó lèle vìle dhɨ ꞌásè. Gba mɨ́ kàdré kpòrò nɨ nɨ yi yà dhɨ, mɨ́ kɨtswá nìá ngalè lyǎ nda angá ángolésè ya, kó ngalè adré lɨ̀le ángolé ya dhɨ ko. Dɨ tà nda kòdhɨ kókpà kònɨ̀nɨ dhya ángùdhi Gìká nɨ Tɨrɨ́ dré tìle dhɨ nɨ tà sè.» ");
INSERT INTO log_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nìkòdémò gò lizíá tíá dhɨ: «Tà kòdhɨ nɨ kɨtswá ru ꞌo ngɨ́nɨngɨ́nɨ ró?» ");
INSERT INTO log_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yésu logó drá dhɨ: «Mɨ tà tadhálépi kàdrɨ̀ Ɨ̀sèrélè ànzɨ ɨ kòfalé dhɨ ꞌɨ. Dɨ, mɨ́ nì mɨ́na tà kòdhɨ ko? ");
INSERT INTO log_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Má adré tà bàti ta mɨ́ dré: Mà adré tà mà dré nìle dhɨ kɨ ta, adrézó tà mà dré nòle dhɨ kɨ longó kòdhya. Dɨ, mɨ̀ lè àmɨkya tà mà dré adrélé longólé nda kɨ kaꞌìle ko. ");
INSERT INTO log_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Gba má dré adrézó tà bvò kòndɨ àdhya kɨ ta àmɨ dré dhɨ, mɨ̀ adré àmɨkya tà nda kɨ kaꞌì ko. Dɨ má kògò adrélé tà bhù àdhya kɨ ta àmɨ dré dhɨ, mɨ̀ nɨ dɨ tà nda kɨ kaꞌì ngɨ́nɨngɨ́nɨ ró? ");
INSERT INTO log_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Dhya àlo mbàlepi bhù na dhɨ tàdzí yókódhó, ngbà ꞌí Móndɨ́ nɨ Mvá asílépi bhù lésè dhɨ ꞌɨ. ");
INSERT INTO log_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ngóró Mósè dré tá nì ledélé aya sè asólé fa sílé dhɨ nɨ tɨngálé kuru duku na dhɨ tɨ́nɨ dhɨ, adré kpà lèá dhɨ, à kòtɨngá Móndɨ́ nɨ Mvá kuru kònɨ̀nɨ, ");
INSERT INTO log_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","kɨtswálé móndyá wä́yi akódhɨ nɨ kaꞌìbhá dhɨ ɨ̀ kàdréró lɨ́drɨ̀ kóná vésè kólyá dhɨ ɨ́be. ");
INSERT INTO log_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Tàko ko, Gìká dré móndyá wä́yi bvò àdhya kɨ lèle tò dhɨ sè dhɨ, afè áyɨ Mváagó àlo kwákwá dhɨ, kɨtswálé dhya ángùdhi adrélépi akódhɨ nɨ kaꞌì dhɨ kòdràró nyo ko, be ró dhɨ, kàdréró lɨ́drɨ̀ kóná vésè kólyá dhɨ ɨ́be. ");
INSERT INTO log_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Àngyá ko, Gìká amù áyɨ Mváagó bvò kònɨ̀dhɨ lé kɨtswálé tà bha móndyá bvò àdhya ɨ dri ko. Be ró dhɨ, amù akódhɨ kɨtswázó móndyá bvò àdhya kɨ tɨdrɨ́ akódhɨ sè dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Dhya ángùdhi adrélépi Mváagó nda nɨ kaꞌì dhɨ, Gìká kɨtswá tà bhà akódhɨ dri ko. Dɨ, dhya ángùdhi adrélépi Mváagó nda nɨ kaꞌì ko dhɨ, Gìká bhà tà akódhɨ dri dre. Tàko ko, akódhɨ nda kaꞌì Gìká nɨ Mváagó àlo kwákwá dhɨ ko. ");
INSERT INTO log_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Tà Gìká dré adrézó móndɨ́ kɨ tàbvó ta ásà dhɨ, tà kònɨ̀dhɨ ꞌɨ: Ngádra atsá bvò ꞌa dre. Dɨ, móndyá bvò àdhya ɨ̀ lè àyɨkya tínímvá, ngádra nda nɨ lavú. Àngyá ko, tà ɨ̀ dré adrélé ꞌòle dhɨ ɨ kònzɨ. ");
INSERT INTO log_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Dhya ángùdhi adrélépi tà kònzɨ ꞌo dhɨ adré ngádra nda nɨ ga. Dhya nda adré kpà alɨ̀le ngádra nda vélé ko, akódhɨ nɨ tà kònzɨ ɨ̀ kàpfòró ngádra nda ꞌá ko. ");
INSERT INTO log_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Dɨ, dhya ángùdhi adrélépi tà bàti kaꞌì ꞌòle dhɨ adré alɨ̀le ngádra nda vélé, à kòkɨtswáró nòá dhɨ, akódhɨ adré tà ꞌo ngóró Gìká dré adrélé lèle dhɨ tɨ́nɨ.» ");
INSERT INTO log_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Àmvolásà dhɨ, Yésu ɨ lebèbhá nɨ ɨ́be dhɨ ɨ̀ dré gòzo lɨ̀le bvò Yùdáyà àdhya na. Ɨ̀ adré tá túmä́ní kònàle lókyá be tsà gò, akódhɨ dré adrézó bàtísimò fe móndɨ́ ɨ dré. ");
INSERT INTO log_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yòwánɨ̀ adré tá kpà bàtísimò fe Àyɨ̀nónà na, ànyɨ Sàlímà làga, yǐ dré tá adrélé kònàle tò dhɨ sè. Móndɨ́ ɨ̀ adré tá lɨ̀le akódhɨ véna gò, dré adrézó bàtísimò fe àyɨ dré. ");
INSERT INTO log_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Àngyá ko, à ru tá rè Yòwánɨ̀ bhèle bǎdzó na dhɨ ko. ");
INSERT INTO log_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Kìtú àlo dhɨ, Yòwánɨ̀ nɨ lebèbhá ɨ̀ kɨdhó tá adrélé tà kayí àyɨ kòfalésè Yúdà mvá àlo dhɨ be, tà adrézó móndɨ́ kɨ temvé dhɨ nɨ tà dri. ");
INSERT INTO log_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Dɨ ɨ̀ dré lɨ̀zo Yòwánɨ̀ véna tàá drá dhɨ: «Rábbì, dhya mɨ̀ dré tá adrézó ába Yòròdánè nɨ taꞌá na gò mɨ́ dré tà nɨ nɨ longózó dhɨ adré kpà ɨ́na bàtísimò fe. Dɨ nyànomvá dhɨ, móndyá wä́yi dhɨ ɨ̀ adré lɨ̀le vélána.» ");
INSERT INTO log_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Dɨ Yòwánɨ̀ logó dhɨ: «Dhya àlo kɨtswá tà àlo kisú bwà ko, Gìká kòfè tà nda drá nɨ̀ ko dhɨ. ");
INSERT INTO log_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Àmɨ kɨ tàndɨ, mɨ̀ yi ma tǎràꞌa ngádra ꞌá dhɨ: ‹Ma Mèsɨ́yà ꞌɨ ko. Dɨ, Gìká amù ma alɨ̀le drìdrì akódhɨ nda kandrá.› ");
INSERT INTO log_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Dhya adrélépi tòkó mo dhɨ, tòkó líyí ꞌɨ. Dɨ, tòkó líyí nda nɨ arúpi adré ɨ́na áyɨ totó ànyɨ làga, adrélé akódhɨ nɨ yi. Kòyi akódhɨ nɨ kúlí dre dhɨ, adré lenzélé tò. Dɨ ma ró dhɨ, má adré lenzélé kònɨ̀nɨ, ɨ̀ndɨ̀ áma kólénzé nda kàdrɨ̀ lavúlé. ");
INSERT INTO log_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Adré lèá dhɨ, akódhɨ nɨ tà kàdré lɨ̀le drìdrì, dɨ, mána kàdré agòle bvólé ro.» ");
INSERT INTO log_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","«Dhya apfòlepi kurú lésè dhɨ, móndyá wä́yi dhɨ ɨ drìle. Dɨ, dhya apfòlepi bvò kònɨ̀dhɨ lésè dhɨ ɨ́na móndɨ́ bvò àdhya ꞌɨ. Akódhɨ nda adré tà bvò àdhya kɨ ta kòdhya. Dhya apfòlepi bhù lésè nda móndyá wä́yi dhɨ ɨ drìle. ");
INSERT INTO log_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Akódhɨ adré tà ɨ́ dré nòle mì sè ɨ̀ndɨ̀ ɨ́ dré yìle bíbhálé sè dhɨ kɨ longó kòdhya. Dɨ, dhya àlo adré tà akódhɨ dré adrélé longólé nda kɨ kaꞌì ko. ");
INSERT INTO log_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Dhya tà longólé nda kɨ kaꞌìlepi dhɨ adré tadhá dhɨ, Gìká adré tà bàti ta. ");
INSERT INTO log_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Tàko ko, dhya Gìká dré amùle nda adré Gìká nɨ kúlí ta kòdhya. Àngyá ko, Gìká fè akódhɨ gàle áyɨ Tɨrɨ́ sè bǐ. ");
INSERT INTO log_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Gìká Atá adré áyɨ Mváagó nɨ le. Tayɨ́ kpà tà títí dhɨ ɨ akódhɨ drɨ́gá. ");
INSERT INTO log_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Dhya ángùdhi adrélépi Mváagó nda nɨ kaꞌì dhɨ, akódhɨ nda lɨ́drɨ̀ kóná vésè kólyá dhɨ ɨ́be. Dɨ, dhya adrélépi Mváagó nda nɨ ga dhɨ kɨtswá ɨ́na lɨ́drɨ̀ nda nɨ kisú ko. Be ró dhɨ, Gìká nɨ kombà nɨ adré akódhɨ dri nyo.» ");
INSERT INTO log_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Fàrìsáyò ɨ̀ yi tá tàle dhɨ, Yésu adré tá móndɨ́ bǐ dhɨ kɨ ꞌo atsálé áyɨ lebèbhá ɨ ró, adrézó kpà bàtísimò fe àyɨ dré, ɨ̀ndɨ̀ adré tá ꞌòá kònɨ̀nɨ Yòwánɨ̀ àdhya nɨ lavú. (Tà bàti ró dhɨ, Yésu nɨ tàndɨ adré tá bàtísimò fe àyɨ dré nɨ̀ ko. Be ró dhɨ, akódhɨ nɨ lebèbhá ɨ̀ adré tá fèá àyɨ.) Dɨ Yésu kòyi tà adrélé tàle áyɨ tà dri nda dre dhɨ, dré angázó bvò Yùdáyà àdhya lésè gò, láti do gòzo bvò Gàlìláyà àdhya na. ");
INSERT INTO log_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Adré tá lèá dhɨ, akódhɨ kòlavú bvò Sàmàrɨ́yà àdhya ꞌásè. ");
INSERT INTO log_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Dɨ dré lɨ̀zo tsàle bhàandre àlo Sàmàrɨ́yà le, rú zìle Sìkárà dhɨ na, ànyɨ amvú Yàkóbhò dré tá fèle áyɨ mvá Yòséfà dré dhɨ làga. ");
INSERT INTO log_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Kóró Yàkóbhò àdhya tá kònàle be. Yésu dré landèle atsí dré dhɨ sè dhɨ, dré tsàzo lɨrɨ́lé ànyɨ kóró nda làga, ànyɨ́ànyɨ kìtú rírí sè. ");
INSERT INTO log_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Dɨ Sàmàrɨ́yà tòkó àlo dhɨ dré alɨ̀zo yǐ ko gò, Yésu dré tàzoá drá dhɨ: «Mɨ́ afè má dré yǐ mvùle.» ");
INSERT INTO log_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Akódhɨ nɨ lebèbhá ɨ̀ lɨ̀ tá bhàandre na, kɨtswálé ngá gɨ àyɨ dré nyàle.) ");
INSERT INTO log_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Dɨ Sàmàrɨ́yà tòkó nda gò tàá akódhɨ dré dhɨ: «Mɨ́ kàdré kó Yúdà mvá ꞌɨ dhɨ, mɨ́ adré dɨ yǐ zi mvùle ma, Sàmàrɨ́yà tòko ró nɨ tí ngɨ́nɨngɨ́nɨ ró?» (Akódhɨ tà tá kònɨ̀nɨ tàko ko, Yúdà ànzɨ ɨ̀ adré gà ru su Sàmàrɨ́yà ɨ́be ko.) ");
INSERT INTO log_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Dɨ Yésu logó drá dhɨ: «Mɨ́ kònì tá kó rè tà Gìká dré adrélé fèle mɨ́ dré dhɨ be, ɨ̀ndɨ̀ dhya adrélépi yǐ zi mɨ́ tí dhɨ be dhɨ, kònò mɨ́ nɨ tá yǐ zi má tí gò, má dré yǐ adrélépi lɨ́drɨ̀ fe dhɨ nɨ fèzo mɨ́ dré.» ");
INSERT INTO log_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Tòkó nda tà drá dhɨ: «Mírì, mɨ ngá yǐ akózó dhɨ àko, ɨ̀ndɨ̀ kóró alú lavúlé. Mɨ́ nɨ yǐ adrélépi lɨ́drɨ̀ fe nda nɨ kisú ángwà? ");
INSERT INTO log_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Mɨ́ adré kisùá dhɨ, mɨ mɨ́na kàdrɨ̀ àma kɨ tábhí Yàkóbhò nɨ lavú? Akódhɨ nda tayɨ́ kóró kònɨ̀dhɨ àma dré nɨ̀. Akódhɨ nɨ tàndɨ mvu tá yǐ kònwa, túmä́ní ànzɨ nɨ ɨ́be, ɨ̀ndɨ̀ kàꞌwá nɨ ɨ́be.» ");
INSERT INTO log_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Dɨ Yésu logó drá dhɨ: «Dhya ángùdhi adrélépi yǐ kònɨ̀dhɨ nɨ mvu dhɨ, yǐ lovó nɨ go akódhɨ nɨ ꞌo tódhyá. ");
INSERT INTO log_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Dɨ, dhya ángùdhi yǐ má dré dra fèle ɨ́ dré dhɨ nɨ mvùlepi dhɨ, yǐ lovó kɨtswá gòle vélé akódhɨ nɨ ꞌo ko. Bàti, yǐ má dré dra fèle akódhɨ dré nda nɨ atsá akódhɨ léna kidrì adrélépi sèle ko ɨ̀ndɨ̀ adrélépi lɨ́drɨ̀ kóná vésè kólyá dhɨ nɨ fe dhɨ ró.» ");
INSERT INTO log_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Dɨ tòkó nda tà drá dhɨ: «Mírì, mɨ́ afè má dré yǐ nda kòdhya, yǐ lovó kògòró vélé áma ꞌo ko, ɨ̀ndɨ̀ má kògòró vélé alɨ̀le yǐ ko kònwa ko.» ");
INSERT INTO log_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yésu tà drá dhɨ: «Mɨ́ lɨ̀ ámɨ agó nɨ azí, mɨ̀ kàgòró túmä́ní kònwa.» ");
INSERT INTO log_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Tòkó nda logó drá dhɨ: «Ma agó àko.» Dɨ Yésu tà drá dhɨ: «Mɨ́ tà kyá tàle dhɨ, mɨ agó àko dhɨ. ");
INSERT INTO log_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Àngyá ko, mɨ tá àgo ɨ́be nzi, ɨ̀ndɨ̀ agó mɨ́ dré adrézó ába ándrò nɨ, mɨ́na ꞌɨ ko. Tà mɨ́ dré tàle nda, tà bàti ꞌɨ.» ");
INSERT INTO log_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Dɨ tòkó nda tà drá dhɨ: «Mírì, má adré nòá dhɨ, mɨ pròfétà ꞌɨ. ");
INSERT INTO log_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Àma kɨ tábhí ɨ̀ adré tá Gìká nɨ lɨndrɨ̀ bha kòngó kònɨ̀dhɨ dri. Dɨ, àmɨ Yúdà ànzɨ ró dhɨ ɨ, mɨ̀ adré tàá dhɨ, àrà adrézó Gìká nɨ lɨndrɨ̀ bha dhɨ ngbà ꞌí Yèrúsalémà na.» ");
INSERT INTO log_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Dɨ Yésu logó drá dhɨ: «Tòkó, mɨ́ kaꞌì vo rè áma kúlí ká! Lókyá adrélépi alɨ̀le dhɨ sè dhɨ, mɨ̀ gò vélé Gìká Atá nɨ lɨndrɨ̀ bha kòngó kònɨ̀dhɨ dri yà, kó ngalè Yèrúsalémà na yà dhɨ ko. ");
INSERT INTO log_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Àmɨ, Sàmàrɨ́yà ro nɨ ɨ, mɨ̀ adré àmɨkya Gìká nɨ lɨndrɨ̀ bha akódhɨ nɨ nì àko ró. Dɨ, àma Yúdà ànzɨ ró dhɨ ɨ, mà adré àmakya Gìká mà dré nìle be dhɨ nɨ lɨndrɨ̀ bha kòdhya. Àngyá ko, tà adrézó móndɨ́ kɨ tɨdrɨ́ dhɨ angá Yúdà ànzɨ ɨ vélésè. ");
INSERT INTO log_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Lókyá adré alɨ̀le, atsá kpà dre, móndyá adrébhá Gìká Atá nɨ lɨndrɨ̀ bha bàti dhɨ kɨ lɨndrɨ̀ nɨ nɨ bha Tɨrɨ́ na, ɨ̀ndɨ̀ tà bàti na. Tàko ko, Gìká Atá adré móndyá adrébhá áyɨ lɨndrɨ̀ bha kònɨ̀nɨ dhɨ kɨ nda kòdhya. ");
INSERT INTO log_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Gìká Tɨrɨ́ ꞌɨ. Adré dɨ lèá dhɨ, móndyá adrébhá akódhɨ nɨ lɨndrɨ̀ bha dhɨ ɨ̀ kàdré lɨndrɨ̀ nɨ nɨ bha Tɨrɨ́ na ɨ̀ndɨ̀ tà bàti na.» ");
INSERT INTO log_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Tòkó nda gò tàá drá dhɨ: «Má nì tàle dhɨ, Mèsɨ́yà adré alɨ̀le dhɨ be. À adré kpà akódhɨ nɨ rú zi Krísto. Akódhɨ kàtsá dre dhɨ, a nɨ tà títí dhɨ kɨ àndu ngɨ àma dré.» ");
INSERT INTO log_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Dɨ Yésu dré tàzoá drá dhɨ: «Ma adrélépi tà ta mɨ́ be nɨ, ma akódhɨ nda ꞌɨ.» ");
INSERT INTO log_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Gbǎ lókyá nda sè dhɨ, Yésu nɨ lebèbhá ɨ̀ dré agòzo gò, àyɨ kɨ lɨ́ndrɨ́ dré gàzo, ɨ̀ dré akódhɨ nɨ kisúlé adréràꞌa tà ta tòkó àlo be dhɨ sè. Dɨ, tágba kònɨ̀nɨ dhɨ, àyɨ kɨ àlo lizí tá ko tàle dhɨ «Mɨ́ adré àdho nda?» ya, kó ngalè «Mɨ̀ adré tà ta akódhɨ be àdho tà sè?» ya dhɨ. ");
INSERT INTO log_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Dɨ tòkó nda dré áyɨ lɨ̀drɨ́ adrézó yǐ akó ásà dhɨ nɨ tayɨ́zó gò, gòzo bhàandre nda na, tàá móndyá kònàle dhɨ ɨ dré dhɨ: ");
INSERT INTO log_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«Mɨ̀ alɨ̀ agó tà títí má dré ꞌòle dhɨ kɨ tàlepi má dré dhɨ nɨ no! Kònò akódhɨ nda tsì Mèsɨ́yà ꞌɨ ko?» ");
INSERT INTO log_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Dɨ àyɨ nda ɨ̀ dré apfòzo bhàandre nda lésè adrélé alɨ̀le Yésu vélé. ");
INSERT INTO log_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Lókyá nda sè dhɨ, Yésu nɨ lebèbhá ɨ̀ dré akódhɨ nɨ ti lizízó tàzoá dhɨ: «Rábbì, mɨ́ kònya ngá wà!» ");
INSERT INTO log_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Dɨ, akódhɨ logó àyɨ dré dhɨ: «Ma mána ngá nyàle mɨ̀ dré nìle ko dhɨ ɨ́be.» ");
INSERT INTO log_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Dɨ akódhɨ nɨ lebèbhá nda ɨ̀ dré kɨdhózó adrélé lizíá àyɨ kòfalésè dhɨ: «Kònò móndɨ́ atsá ngá adzí akódhɨ dré nyàle dre?» ");
INSERT INTO log_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Dɨ Yésu tà àyɨ dré dhɨ: «Áma mányàngá ɨ́na adrema tà dhya áma amùlepi dhɨ dré adrélé lèle má kòꞌo dhɨ kɨ ꞌo, adrézó akódhɨ nɨ àzí ꞌo akɨ́lé títí dhɨ ꞌɨ. ");
INSERT INTO log_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Mɨ̀ adré zakó tàá dhɨ: ‹Tayɨ́ rè dhu mbǎ su kɨtswázó lànyá akónà amvú ɨ ꞌásè.› Dɨ, má adré tàá àmɨ dré dhɨ: Mɨ̀ kòtɨngá mì adrélé amvú kɨ no wà! Lànyá ka àyɨ ꞌásè kɨtswálé akónàle dhɨ dre. ");
INSERT INTO log_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ndɨ̀ndɨ̀ nyànomvá dhɨ, dhya adrélépi lànyá akónà dhɨ adré áyɨ landè nya. Adré kpà lòꞌwa lokó lɨ́drɨ̀ kóná vésè kólyá dhɨ dré, kɨtswálé dhya adrélépi kórɨ̀ rɨ dhɨ, ɨ̀ndɨ̀ dhya adrélépi lànyá akónà dhɨ be dhɨ ɨ̀ kàdréró lenzélé túmä́ní be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Tògyakúlí adrélépi tàá dhɨ ‹Dhya àlo adré kórɨ̀ rɨ gò, àzya nɨ dré adrézó lokóá› dhɨ, tà bàti ꞌɨ. ");
INSERT INTO log_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Má mù àmɨ adrélé lànyá mɨ̀ dré àzí ꞌòzo ásà ko dhɨ nɨ akónà. Móndɨ́ àruka ɨ̀ ꞌo tá àzí nda landèzo àyɨ gò, mɨ̀ dré adrézó àyɨ kɨ landè nya.» ");
INSERT INTO log_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Dɨ móndɨ́ zyandre Sàmàrɨ́yà ro angábhá bhàandre nda lésè dhɨ ɨ̀ dré Yésu nɨ kaꞌìzo, tà tòkó nda dré tàle akódhɨ nɨ tà dri dhɨ sè. Àngyá ko, tòkó nda tà tá dhɨ: «Akódhɨ tà má dré tà títí má dré ꞌòle dhɨ ɨ.» ");
INSERT INTO log_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Dɨ àyɨ nda ɨ̀ kàtsá Yésu vélé dre dhɨ, ɨ̀ dré akódhɨ nɨ ti lizízó, ɨ̀ kàdréró rè dhu túmä́ní àyɨ ɨ́be. Dɨ akódhɨ dré adrézó kònàle kìtú rì. ");
INSERT INTO log_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Gò móndɨ́ àruka zyandre dhɨ ɨ̀ dré kpà akódhɨ nɨ kaꞌìzo, kúlí dré tàle àyɨ dré dhɨ ɨ sè. ");
INSERT INTO log_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Àyɨ nda ɨ̀ dré tàzoá tòkó nda dré dhɨ: «Mà adré vélé akódhɨ nɨ kaꞌì ngbà ꞌí tà mɨ́ dré tàle akódhɨ nɨ tà dri dhɨ sè ko. Tàko ko, mà yi vélé akódhɨ nɨ kúlí àma kɨ tàndɨ kɨ bíbhálé sè. Mà nì tàle dhɨ, akódhɨ nda dhya adrélépi móndyá bvò àdhya kɨ tɨdrɨ́ dhɨ ꞌɨ bàti dhɨ be.» ");
INSERT INTO log_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Kìtú rì nda ɨ àmvolésè dhɨ, Yésu dré àrà nda nɨ tayɨ́zó gò, lɨ̀zo bvò Gàlìláyà àdhya na. ");
INSERT INTO log_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Akódhɨ nɨ tàndɨ tà tá dhɨ: «À bhà gà pròfétà nɨ lɨndrɨ̀ akódhɨ nɨ tàndɨ nɨ bvò ꞌa ko na.» ");
INSERT INTO log_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Dɨ, tágba kònɨ̀nɨ dhɨ, akódhɨ kòtsa Gàlìláyà na dre dhɨ, móndyá kònàle dhɨ ɨ̀ dré akódhɨ nɨ kaꞌìzo dòle àyɨ kòfalé dóro. Àngyá ko, ɨ̀ lɨ̀ tá kpà Yèrúsalémà na gwányá Pásɨkà àdhya nɨ tà sè gò, ɨ̀ dré tà títí akódhɨ dré tá ꞌòle kònàle dhɨ kɨ nòzo. ");
INSERT INTO log_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Dɨ Yésu dré gòzo tódhyá lɨ̀le Kánà, Gàlìláyà le dhɨ na, àrà dré tá yǐ ladzázó atsálé vínò ro lána dhɨ na. Kònàle dhɨ, dhya kàdrɨ̀ àlo adrélépi Rómà kɨ òpɨ̀ nɨ tà ꞌo dhɨ tá be. Akódhɨ nda nɨ mváagó tá drà ro Kàpàrànàwúmà na. ");
INSERT INTO log_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Dɨ kòyi tàle dhɨ, Yésu angá tá Yùdáyà lésè agòle Gàlìláyà le dhɨ dre dhɨ, dré lɨ̀zo vélána akódhɨ nɨ ti lizí, kòlɨ̀ró Kàpàrànàwúmà na áyɨ mváagó adrélépi dràdrà mìle nda nɨ tɨdrɨ́ be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yésu tà drá dhɨ: «Mɨ̀ kɨtswá àmɨkya áma kaꞌì bwà ko, mɨ̀ kàdré tà lɨ́ndrɨ́ga ró adrébhá Gìká nɨ rìnyí tadhá dhɨ kɨ no ko dhɨ!» ");
INSERT INTO log_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Dhya kàdrɨ̀ nda tà drá dhɨ: «Mírì, mɨ́ alɨ̀ áma mvá dré drǎrà ko dhɨ ꞌá wà!» ");
INSERT INTO log_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Dɨ Yésu logó drá dhɨ: «Mɨ́ nzɨ mɨ́ bhàna. Ámɨ mvá adrɨ́ dre!» Dɨ dhya nda dré kúlí Yésu dré tàle nda nɨ kaꞌìzo gò, ngàzo nzɨ̀le. ");
INSERT INTO log_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Dré tá adréràꞌa láti ꞌá dhɨ, akódhɨ nɨ màrábà ɨ̀ dré arázó atsálé vélá tàá drá dhɨ: «Ámɨ mvá adrɨ́ dre!» ");
INSERT INTO log_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Dɨ dré àyɨ kɨ lizízó ngalè áyɨ mvá nda nɨ rúbhá atsá tá dóro lókyá ángùdhi sè ya dhɨ. Ɨ̀ dré logózóá drá dhɨ: «Rúbhá àtsɨ́ nda nga rúásà agyá, sáà àlo kìtú rírí àmvolésè dhɨ sè.» ");
INSERT INTO log_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Dɨ atá nɨ nda dré nìzoá tàle dhɨ, lókyá nda tá lókyá Yésu dré tàzo ɨ́ dré dhɨ «Ámɨ mvá adrɨ́ dre» dhɨ ꞌɨ dhɨ be. Dɨ akódhɨ ɨ móndyá wä́yi akódhɨ nɨ dzó lé dhɨ ɨ́be dhɨ ɨ̀ dré Yésu nɨ kaꞌìzo. ");
INSERT INTO log_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Kòrɨ̀dhɨ, tà lɨ́ndrɨ́ga ró Yésu dré ꞌòle áyɨ angama Yùdáyà lésè alɨ̀le Gàlìláyà le dhɨ àmvolésè dhɨ nɨ rì ꞌɨ. ");
INSERT INTO log_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Àmvolásà dhɨ, Yésu dré gòzo lɨ̀le Yèrúsalémà na, Yúdà ànzɨ kɨ gwányá kɨ àlo nɨ tà sè. ");
INSERT INTO log_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Bhàandre nda ꞌá, ànyɨ zèríbàti adrélé zìle Kábilígyà kya ró dhɨ làga dhɨ, yǐ àlo ledélé bómà tɨ́nɨ, adrélé rú zìle Èbérè ti sè Bètèzátà dhɨ be. Yǐ nda làgásè kúrú dhɨ, à ledé tá àrà dzó kògbo tɨ́nɨ dhɨ ɨ nzi. ");
INSERT INTO log_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Kònàle dhɨ, dràbhá zyandre lavúlé dhɨ ɨ̀ adré tá ayílé. Àyɨ kòfalé dhɨ tá mì kùdúkùdu ɨ, mèrèkpè ɨ, tsàle móndɨ́ pá be àbvò ro dhɨ ɨ́be. ");
INSERT INTO log_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Àyɨ nda ɨ kòfalé dhɨ, agó àlo ayílépi drà be kóná nyadhɨ-alo-drì-mudrí-drì-nzi-drì-na dhɨ tá be. ");
INSERT INTO log_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yésu kònò akódhɨ nda adréràꞌa ayílé kònàle dre dhɨ, dré nìzoá tàle dhɨ, akódhɨ ayí tá drà be vwàvwà ro dhɨ be. Dɨ dré tàzoá drá dhɨ: «Mɨ́ lè adrɨ́lé?» ");
INSERT INTO log_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Dɨ dràbhá nda logó drá dhɨ: «Mírì, dhya àlo kɨtswálépi áma ledé bwà dhɨ yókódhó. Àngyá ko, lókyá yǐ dré adréràꞌa ru kägbä́ dhɨ ꞌá dhɨ, dhya àlo kɨtswálépi áma do bhèle yǐ na má kàdrɨ́ró ásà dhɨ yó. Má kàdré ꞌòle sìle dhɨ, dhya àzya adré lavúlé sìle má kandrána.» ");
INSERT INTO log_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Dɨ Yésu tà drá dhɨ: «Mɨ́ nga, mɨ́ do ámɨ kíndri, ɨ̀ndɨ̀ mɨ́ kɨdhó atsí to!» ");
INSERT INTO log_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Gbǎ kòdhwa, agó nda dré adrɨ́zó. Dré áyɨ kíndri dòzo gò kɨdhózó adrélé atsí to. Kìtú tà nda dré ru ꞌòzo dhɨ tá sàbátù ꞌɨ. ");
INSERT INTO log_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Dɨ Yúdà ànzɨ kɨ kàdrɨ̀ ɨ̀ dré agó adrɨ́lépi nda nɨ nòzo gò, ɨ̀ dré tàzoá drá dhɨ: «Ándrò kònɨ̀dhɨ, sàbátù ꞌɨ. Àma kɨ tátrɨ́trɨ́ kúlí adré ámɨ kíndri dòma sàbátù tú dhɨ nɨ logá.» ");
INSERT INTO log_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Dɨ, akódhɨ logó àyɨ dré dhɨ: «Dhya áma tɨdrɨ́lépi dhɨ tà má dré dhɨ: ‹Mɨ́ do ámɨ kíndri, ɨ̀ndɨ̀ mɨ́ to atsí.›» ");
INSERT INTO log_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ɨ̀ gò lizíá tíá dhɨ: «Àdhi tà mɨ́ dré dhɨ, mɨ́ kòdo ámɨ kíndri, ɨ̀ndɨ̀ mɨ́ kòto atsí dhɨ nɨ̀?» ");
INSERT INTO log_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Dɨ, agó adrɨ́lépi nda nì ɨ́na ngalè dhya áyɨ tɨdrɨ́lépi nda àdhi ꞌɨ ya dhɨ ko. Tàko ko, Yésu lavú tá móndɨ́ zyandre kònàle dhɨ ɨ kòfalésè lyà. ");
INSERT INTO log_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Àmvolásà dhɨ, Yésu dré agó nda nɨ kisúzó tépelò na gò, tàzoá drá dhɨ: «Mɨ́ nò rè ká! Mɨ́ adrɨ́ nyànomvá dre. Adré dɨ lèá dhɨ, mɨ́ kòtayɨ́ tàkonzɨ̀ ꞌòma, tà kòkóròko lavúlé dhɨ kàtsáró mɨ́ rú ko dhɨ bvó.» ");
INSERT INTO log_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Gò agó nda dré ngàzo lɨ̀le longóá Yúdà ànzɨ kɨ kàdrɨ̀ ɨ dré dhɨ, Yésu tɨdrɨ́ tá ɨ nɨ̀. ");
INSERT INTO log_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Dɨ Yúdà ànzɨ kɨ kàdrɨ̀ nda ɨ̀ dré dhèzo adrélé Yésu nɨ mì pfo, dré tá adrélé tà nda kɨ ꞌo sàbátù tú dhɨ sè. ");
INSERT INTO log_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Dɨ, Yésu dré tàzoá àyɨ dré dhɨ: «Áma Atá adré ngbú adrélé àzí ꞌo atsálé ándrò kònɨ̀dhɨ. Dɨ ma ró dhɨ, má adré kpà àzí ꞌo.» ");
INSERT INTO log_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Dɨ kúlí nda sè dhɨ, Yúdà ànzɨ kɨ kàdrɨ̀ nda ɨ̀ dré gòzo vélé adrélé láti nda, kɨtswázó akódhɨ nɨ pfu dràle dhɨ bvó. Tàko ko, akódhɨ adré tá ngbà ꞌí tòlɨ́ sàbátù àdhya nɨ ŋo kòdhya ko. Adré tá kpà Gìká nɨ zi áyɨ tàndɨ nɨ Atá ro, adrézó áyɨ bha adrélé díri Gìká be. ");
INSERT INTO log_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Dɨ Yésu dré logózóá àyɨ dré dhɨ: «Má adré tà bàti ta àmɨ dré: Gìká nɨ Mváagó kɨtswá tà àlo ꞌo áyɨ drì sè bwà ko. Adré ngbà ꞌí tà áyɨ Atá dré adrélé ꞌòle gò ɨ́ dré adrézó nòá dhɨ kɨ ꞌo kòdhya. Tà ángùdhi Gìká Atá dré adrélé ꞌòle dhɨ, akódhɨ nɨ Mváagó adré kókpà ꞌòá kònɨ̀nɨ. ");
INSERT INTO log_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Tàko ko, Gìká Atá adré áyɨ Mváagó nɨ le gò, adrézó tà títí ɨ́ dré adrélé ꞌòle dhɨ kɨ tadhá drá. Tà bàti ró dhɨ, a nɨ tà kàdrɨ̀ dra tà kòdhɨ kɨ lavúbhá dhɨ kɨ tadhá áyɨ Mváagó nda dré ꞌòle gò, àmɨ kɨ lɨ́ndrɨ́ dré gàzo ásà bhwǎbhwa. ");
INSERT INTO log_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Àngyá ko, ngóró Gìká Atá dré adrélé móndɨ́ dràbhá dre dhɨ kɨ tɨngá dràdrà lésè adrézó lɨ́drɨ̀ fe àyɨ dré dhɨ tɨ́nɨ dhɨ, akódhɨ nɨ Mváagó adré kókpà lɨ́drɨ̀ fe dhya ángùdhi ɨ́ dré adrézó lèá fèle drá dhɨ dré. ");
INSERT INTO log_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Kòdhɨ ɨ́be dhɨ, Gìká Atá adré dhya àlo nɨ tàbvó ta ko. Be ró dhɨ, tayɨ́ ɨ́na rìnyí wä́yi adrézó móndɨ́ kɨ tàbvó ta dhɨ áyɨ Mváagó drɨ́gá. ");
INSERT INTO log_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ꞌO kònɨ̀nɨ kɨtswálé móndyá wä́yi dhɨ ɨ̀ kàdréró áyɨ Mváagó nda nɨ lɨndrɨ̀ bha, ngóró ɨ̀ dré adrélé áyɨ tàndɨ nɨ lɨndrɨ̀ bha dhɨ tɨ́nɨ. Dhya ángùdhi adrélépi Gìká nɨ Mváagó nɨ lɨndrɨ̀ bha ko dhɨ, adré kókpà Gìká Atá akódhɨ nɨ amùlepi dhɨ nɨ lɨndrɨ̀ bha ko. ");
INSERT INTO log_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Má adré tà bàti ta àmɨ dré: Dhya ángùdhi adrélépi áma kúlí yi gò adrézó dhya áma amùlepi dhɨ nɨ kaꞌì dhɨ, akódhɨ nda lɨ́drɨ̀ kóná vésè kólyá dhɨ ɨ́be. Gìká kɨtswá tà bha akódhɨ nda dri ko. Be ró dhɨ, akódhɨ nda apfò dràdrà lésè afɨ́lé lɨ́drɨ̀ le dre. ");
INSERT INTO log_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Má adré tà bàti ta àmɨ dré: Lókyá adré alɨ̀le, atsá kpà dre, móndyá dràbhá dre dhɨ kɨ Gìká nɨ Mváagó nɨ kúlí yi. Dɨ àyɨ dra akódhɨ nda nɨ kúlí yibhá dhɨ kɨ adrɨ́. ");
INSERT INTO log_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Tàko ko, ngóró Gìká Atá dré adrélé rìnyí adrézó lɨ́drɨ̀ fe dhɨ ɨ́be áyɨ tàndɨ léna dhɨ tɨ́nɨ dhɨ, fè kpà rìnyí adrézó lɨ́drɨ̀ fe nda áyɨ Mváagó dré adrézó ába ɨ́ léna. ");
INSERT INTO log_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Fè kókpà rìnyí adrézó móndɨ́ kɨ tàbvó ta dhɨ áyɨ Mváagó nda dré, akódhɨ dré adrélé Móndɨ́ nɨ Mvá ꞌɨ dhɨ sè. ");
INSERT INTO log_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Lè àmɨ kɨ lɨ́ndrɨ́ kàdré gàle tà kòdhɨ sè ko. Àngyá ko, lókyá adrélépi alɨ̀le dhɨ sè dhɨ, móndyá wä́yi dràbhá dre gò ɨ̀ dré adrézó ayílé mógó ɨ ꞌásè dhɨ kɨ Gìká nɨ Mváagó nɨ kúlí yi gò, ");
INSERT INTO log_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ɨ̀ dré topfòzo mógó nda ɨ lésè. Àyɨ tà dóro ꞌobhá dhɨ kɨ nga dràdrà ꞌásè adrɨ́lé. Dɨ, àyɨ tà kònzɨ ꞌobhá dhɨ kɨ àyɨkya nga dràdrà ꞌásè, Gìká kòbhàró tà àyɨ dri be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Má kɨtswá mána tà àlo ꞌo áma drì sè ko. Má adré ngbà ꞌí tàbvó ta ngóró má dré adrélé yìle Gìká vélésè dhɨ tɨ́nɨ. Dɨ tàbvó má dré adrélé tàle nda gyǎgya. Tàko ko, má adré tà má dré adrélé lèle dhɨ kɨ nda ꞌòle kòdhya ko. Be ró dhɨ, má adré mána tà dhya áma amùlepi dhɨ dré adrélé lèle dhɨ kɨ nda ꞌòle kòdhya.» ");
INSERT INTO log_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","«Kònò má kàdré tá áma tàndɨ nɨ tà longó ma dhɨ, áma kúlí kɨtswá tá adré lanzìlanzì ko. ");
INSERT INTO log_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Dɨ, dhya àzya adré áma tà longó nɨ̀. Má nì tàle dhɨ, tà dré adrélé longólé áma tà dri dhɨ, tà bàti ꞌɨ dhɨ be. ");
INSERT INTO log_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Mɨ̀ mù tá móndɨ́ ɨ lɨ̀le Yòwánɨ̀ véna àmɨ, dɨ tà dré longólé áma tà dri dhɨ tá tà bàti ꞌɨ. ");
INSERT INTO log_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Má adré mána áma totó tà móndɨ́ ɨ̀ dré adrélé longólé áma tà dri dhɨ dri ko. Dɨ, má adré tà kòdhɨ nɨ ta, mɨ̀ kòkɨtswáró adrɨ́lé ásà be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yòwánɨ̀ nda tá tálà adrélépi kòle, adrélépi ngá kazá móndɨ́ ɨ dré dhɨ ꞌɨ. Dɨ mɨ̀ kaꞌì tá lenzélé akódhɨ nɨ ngádra nda ꞌá lókyá tsà sè. ");
INSERT INTO log_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Dɨ, ma mána tà kàdrɨ̀ àruka adrébhá áma tà longó dóro lavúlé Yòwánɨ̀ àdhya rúsè dhɨ ɨ́be. Tà nda ɨ, tà áma Atá dré afèle má dré ꞌòle akɨ́lé títí dhɨ ꞌɨ. Tà má dré adrélé ꞌòle nda ɨ̀ adré áma tà longó, adrézó tadhá dhɨ, Gìká Atá amù ma nɨ̀. ");
INSERT INTO log_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Kòdhɨ ɨ́be dhɨ, Gìká Atá áma amùlepi nda adré kpà ɨ́na áma tà longó. Mɨ̀ yi tàdzí akódhɨ nɨ kúlí ko. Mɨ̀ nò kpà tàdzí akódhɨ nɨ mìbhalé ko. ");
INSERT INTO log_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Mɨ̀ adré kpà akódhɨ nɨ kúlí lɨkɨ́ àmɨ léna ko. Tàko ko, mɨ̀ adré àmɨkya dhya dré amùle dhɨ nɨ kaꞌì ko. ");
INSERT INTO log_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mɨ̀ adré tà títí tɨsɨ̀le Gìká nɨ Kúlí na dhɨ kɨ àndu nda nìle kòdhya. Àngyá ko, mɨ̀ adré kisùá dhɨ, mɨ̀ nɨ lɨ́drɨ̀ kóná vésè kólyá dhɨ nɨ kisú Kúlí nda sè. Dɨ Kúlí nda kòdhɨ adré áma tà longó nɨ̀. ");
INSERT INTO log_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Tágba kònɨ̀nɨ dhɨ, mɨ̀ lè àmɨkya alɨ̀le má vélé lɨ́drɨ̀ kisú ko! ");
INSERT INTO log_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Má adré mána rúku nda kisúlé móndɨ́ ɨ vélésè ko. ");
INSERT INTO log_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Dɨ, má nì àmɨ be. Má nì, àmɨ Gìká nɨ lèle àko àmɨ kɨ togó na dhɨ be. ");
INSERT INTO log_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Má alɨ̀ mána áma Atá nɨ rú sè gò, mɨ̀ dré áma kaꞌìzo dòle àmɨ kòfalé ko. Dɨ, dhya àzya kàdré alɨ̀le áyɨ tàndɨ nɨ rú sè dhɨ, mɨ̀ adré àmɨkya akódhɨ nda nɨ kaꞌì dòle dóro. ");
INSERT INTO log_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Mɨ̀ adré rúku nda kisúlé àmɨ kòfalésè. Dɨ, mɨ̀ adré àmɨkya rúku adrélépi angálé Gìká àlo kwákwá dhɨ vélésè dhɨ nɨ nda kisúlé kòdhya ko. Mɨ̀ nɨ dɨ àmɨkya áma kaꞌì ngɨ́nɨngɨ́nɨ ró? ");
INSERT INTO log_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Lè mɨ̀ kòkisù ko tàle dhɨ, má nɨ àmɨ kɨ asíkì áma Atá tí ma dhɨ. Dhya dra àmɨ kɨ asíkìlepi dhɨ, Mósè mɨ̀ dré adrézó mì bha vélána dhɨ ꞌɨ. ");
INSERT INTO log_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kònò mɨ̀ kàdré tá Mósè nɨ kaꞌì bàti dhɨ, mɨ̀ nɨ tá kpà adré áma kaꞌì. Àngyá ko, akódhɨ tɨsɨ̀ tá áma tà kòdhya. ");
INSERT INTO log_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Dɨ mɨ̀ adré kó tà dré tɨsɨ̀le nda kɨ kaꞌì ko dhɨ, mɨ̀ nɨ dɨ àmɨkya áma kúlí kaꞌì ngɨ́nɨngɨ́nɨ ró?» ");
INSERT INTO log_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Àmvolásà dhɨ, Yésu ɨ̀ dré gòzo lebèbhá nɨ ɨ́be Gàlìláyà na gò, ɨ̀ dré zyàzo tä́pä́ríandre Gàlìláyà àdhya nɨ taꞌá na. (À adré kpà tä́pä́ríandre nda nɨ rú zi, tä́pä́ríandre Tìbèríyà àdhya.) ");
INSERT INTO log_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Móndɨ́ zyandre lavúlé dhɨ ɨ̀ adré tá Yésu nɨ lebè, ɨ̀ dré tá adrélé tà lɨ́ndrɨ́ga ró dré adrélé ꞌòle adrézó dràbhá kɨ tɨdrɨ́ dhɨ kɨ no dhɨ sè. ");
INSERT INTO log_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Dɨ Yésu ɨ̀ dré mbàzo lebèbhá nɨ ɨ́be kòngó àlo drìna gò, ɨ̀ dré lɨrɨ́zó. ");
INSERT INTO log_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Yúdà ànzɨ kɨ gwányá Pásɨkà àdhya tá ànyɨ. ");
INSERT INTO log_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Dɨ Yésu kòtɨngá mì móndyá zyandre lavúlé nda kɨ no adréràꞌa alɨ̀le ɨ́ vélé dre dhɨ, dré tàzoá Fìlípò dré dhɨ: «Mà nɨ mápà kisú gɨ̀le móndyá wä́yi kònɨ ɨ̀ dré nyàle dhɨ ángolé?» ");
INSERT INTO log_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Tà tá kònɨ̀nɨ kɨtswázó Fìlípò nɨ tà kaꞌìkaꞌì tabhì. Tàko ko, nì tá ɨ́na tà ɨ́ dré adrélé ꞌòle dhɨ be. ");
INSERT INTO log_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Dɨ Fìlípò logó drá dhɨ: «Tágba mà kàdré tá làfa lòꞌwa kámá-rì dhɨ ɨ́be yà dhɨ, mà kɨtswá tá mápà gɨ móndyá àlo àlo títí nɨ ɨ dré kɨtswálé ndɨ̀ndɨ̀ mvá tsà nɨ nɨ kisú nyàle dhɨ bwà ko.» ");
INSERT INTO log_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Yésu nɨ lebèbhá kɨ àzya, Àndréyà, Sìmónà Pétèró nɨ adrúpi tà drá dhɨ: ");
INSERT INTO log_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«Mváagó àlo kònwánò. Akódhɨ mápà ladhɨ́lé órezè sè dhɨ ɨ́be nzi, ɨ̀ndɨ̀ kosyá ɨ́be rì. Dɨ, ngá kònɨ kɨ àdho ꞌo móndyá zyandre kònɨ̀nɨ nɨ ɨ dré dhɨ?» ");
INSERT INTO log_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Dɨ Yésu gò tàá áyɨ lebèbhá ɨ dré dhɨ: «Mɨ̀ ꞌo móndyá kònɨ ɨ lɨrɨ́lé.» Àrà nda ꞌá dhɨ, mbɨ̀ tá bǐ. Dɨ móndyá nda ɨ̀ dré lɨrɨ́zó. Àgo ɨ tá ànyɨ́ànyɨ ngùlù-nzi. ");
INSERT INTO log_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Dɨ Yésu dré mápà nda kɨ adózó, àwoyà tàzo Gìká dré gò, lanzɨ́zóá móndyá títí nda ɨ dré, ngóró ɨ̀ dré tá lèle nyàle dhɨ tɨ́nɨ. Dré kpà kosyá nda kɨ lanzɨ́zó àyɨ dré kònɨ̀nɨ. ");
INSERT INTO log_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Dɨ àyɨ títí nda ɨ̀ kònya pìzo dre dhɨ, dré tàzoá áyɨ lebèbhá ɨ dré dhɨ: «Mɨ̀ lokó àmbí nɨ, kórònyá nɨ àlo kàbɨ́ró ko.» ");
INSERT INTO log_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Dɨ ɨ̀ dré mápà nzi móndyá ɨ̀ dré nyàle nda kɨ àmbí kɨ lokózó gàle kánzɨ̀ mudrí-drì-rì dhɨ ɨ sè bǐbi. ");
INSERT INTO log_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Dɨ móndyá nda ɨ̀ kònò tà lɨ́ndrɨ́ga ró Yésu dré ꞌòle nda dre dhɨ, ɨ̀ dré ngàzo adrélé tàá dhɨ: «Bàti, dhya kòdhɨ Pròfétà adrélépi tá alɨ̀le bvò le dhɨ ꞌɨ!» ");
INSERT INTO log_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Dɨ Yésu kònò, ɨ̀ adré tá ꞌòle alɨ̀le áyɨ bha ópɨ́ ro rìnyí sè dhɨ dre dhɨ, dré gòzo áyɨ vu lyà, mbàle kalóma kòngó nda drìna. ");
INSERT INTO log_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ɨ̀ndró kàndrɨ̀ dre dhɨ, Yésu nɨ lebèbhá ɨ̀ dré ngàzo sìle tä́pä́ríandre làgana. ");
INSERT INTO log_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ɨ̀ kònò, ngá aní dre, ɨ̀ndɨ̀ Yésu atsá rè àyɨ vélé ko dhɨ dre dhɨ, ɨ̀ dré tombàzo bwátù na gò, kɨdhólé adrélé zyàle tä́pä́ríandre nɨ taꞌá na, kɨtswálé lɨ̀le Kàpàrànàwúmà na. ");
INSERT INTO log_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Lyǎandre adré tá vìle tä́pä́ríandre nda mi gò, yǐ dré adrézó ru kägbä́. ");
INSERT INTO log_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Dɨ ɨ̀ kòlɨ̀ vwàle ànyɨ́ànyɨ kìlòméterè nzi yà, ngalè nzi-drì-àlo yà dhɨ dre dhɨ, ɨ̀ dré Yésu nɨ nòzo adréràꞌa atsí to tä́pä́ríandre drǐsè, adrézó alɨ̀le àyɨ vélé. Gò tirì dré àyɨ kɨ ꞌòzo lavúlé. ");
INSERT INTO log_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Dɨ, Yésu dré ɨ́na tàzoá àyɨ dré dhɨ: «Ma ꞌɨ! Mɨ̀ ro ngá ko!» ");
INSERT INTO log_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ɨ̀ adré tá akódhɨ nɨ le dòle bwátù na. Dɨ gbǎ lókyá nda sè dhɨ, ɨ̀ dré tsàzo tä́pä́ríandre nda nɨ taꞌá na, àrà ɨ̀ dré tá adrézó lɨ̀le dhɨ na. ");
INSERT INTO log_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Kìtú bvóá dhɨ sè dhɨ, móndyá zyandre tayɨ́lé taꞌá lésè nda ɨ̀ dré nòzoá dhɨ, Yésu nɨ lebèbhá ɨ̀ tombà tá bwátù àlo dhɨ na lɨ̀le àyɨ pátí. Ɨ̀ nì tá kpà tàle dhɨ, Yésu mbà tá ɨ́na bwátù nda na ko dhɨ be. ");
INSERT INTO log_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Lókyá nda sè dhɨ, bwátù àruka angábhá bhàandre Tìbèríyà àdhya lésè dhɨ ɨ̀ dré atsázó ànyɨ àrà móndyá nda ɨ̀ dré tá mápà nyàzo Mírì nɨ àwoyà tàma àmvolésè nda làga. ");
INSERT INTO log_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Dɨ móndyá zyandre nda ɨ̀ kònò Yésu ɨ lebèbhá nɨ ɨ́be dhɨ ɨ tá yó dhɨ dre dhɨ, ɨ̀ dré tombàzo bwátù nda ɨ ꞌásè gò, zyàle Kàpàrànàwúmà na kɨtswálé Yésu nɨ nda. ");
INSERT INTO log_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Dɨ ɨ̀ kòkisú Yésu tä́pä́ríandre nda nɨ taꞌá na dre dhɨ, ɨ̀ dré lizízóá tíá dhɨ: «Rábbì, mɨ́ atsá kònwa ángutú?» ");
INSERT INTO log_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yésu logó àyɨ dré dhɨ: «Má adré tà bàti ta àmɨ dré: Mɨ̀ adré áma nda, mɨ̀ dré tà lɨ́ndrɨ́ga ró má dré ꞌòle dhɨ kɨ nòle dhɨ sè ko. Be ró dhɨ, mɨ̀ adré àmɨkya áma nda, mɨ̀ dré mápà nyàle pìzo ásà dhɨ sè. ");
INSERT INTO log_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Dɨ, adré lèá dhɨ, mɨ̀ kàdré àzí ꞌo mányàngá adrélépi ŋwàle ŋwaŋwà dhɨ sè ko. Be ró dhɨ, mɨ̀ kàdré àmɨkya àzí ꞌo mányàngá dra adrélépi kóná vésè kólyá dhɨ sè. Ma, Móndɨ́ nɨ Mvá, má nɨ mányàngá nda nɨ fe àmɨ dré. Tàko ko, Gìká Atá lwà áyɨ àngɨ̀ má rú tadházóá dhɨ, ɨ́ kaꞌì ma káyà dhɨ.» ");
INSERT INTO log_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Dɨ ɨ̀ lizí tíá dhɨ: «Lè mà kòꞌo àdho tà kòdhya kɨtswázó Gìká nɨ àzí ꞌo dhɨ?» ");
INSERT INTO log_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yésu logó àyɨ dré dhɨ: «Àzí Gìká dré adrélé lèle mɨ̀ kòꞌo dhɨ, kònɨ̀dhɨ ꞌɨ: Mɨ̀ kàdré dhya dré amùle dhɨ nɨ kaꞌì.» ");
INSERT INTO log_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Dɨ ɨ̀ gò lizíá tíá dhɨ: «Mɨ́ nɨ àdho tà lɨ́ndrɨ́ga ró dhɨ nɨ ꞌo kòdhya, mà kònòró gò ámɨ kaꞌìzo? Mɨ́ nɨ àdho tà ꞌo? ");
INSERT INTO log_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Àma kɨ tábhí ɨ̀ nya tá mánnà duku na. Ngóró tɨsɨ̀le Gìká nɨ Kúlí na dhɨ tɨ́nɨ: ‹Akódhɨ fè mápà asílépi bhù lésè dhɨ àyɨ dré nyàle.›» ");
INSERT INTO log_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Dɨ Yésu tà àyɨ dré dhɨ: «Má adré tà bàti ta àmɨ dré: Mósè fè mápà asílépi bhù lésè dhɨ àmɨ dré nɨ̀ ko. Dɨ, áma Atá adré ɨ́na mápà tàndɨ asílépi bhù lésè dhɨ nɨ fe àmɨ dré nɨ̀. ");
INSERT INTO log_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Tàko ko, mápà tàndɨ Gìká dré adrélé fèle nda, dhya asílépi bhù lésè adrélé lɨ́drɨ̀ fe móndyá bvò àdhya ɨ dré dhɨ ꞌɨ.» ");
INSERT INTO log_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Dɨ ɨ̀ tà drá dhɨ: «Mírì, mɨ́ kàdré ngbú mápà kòdhɨ nɨ afè àma dré wà!» ");
INSERT INTO log_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yésu gò tàá àyɨ dré dhɨ: «Ma mána mápà adrélépi lɨ́drɨ̀ fe dhɨ ꞌɨ. Dhya ángùdhi adrélépi alɨ̀le má vélé dhɨ, tàbirí kɨtswá tàdzí gòle akódhɨ nɨ ꞌo ko. Dhya ángùdhi adrélépi áma kaꞌì dhɨ, yǐ lovó kɨtswá tàdzí gòle akódhɨ nɨ nde ko. ");
INSERT INTO log_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Dɨ, ngóró má dré tàle àmɨ dré dre dhɨ tɨ́nɨ dhɨ, tágba mɨ̀ dré áma nòzo ꞌí dhɨ, mɨ̀ kaꞌì àmɨkya ma ko. ");
INSERT INTO log_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Móndyá wä́yi áma Atá dré adrélé afèle má dré dhɨ kɨ alɨ̀ má vélé. Dɨ dhya ángùdhi adrélépi alɨ̀le má vélé dhɨ, má kɨtswá tàdzí akódhɨ nɨ dro ko. ");
INSERT INTO log_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Àngyá ko, má así bhù lésè kɨtswálé tà má dré adrélé lèle dhɨ kɨ ꞌo kòdhya ko. Be ró dhɨ, má así mána tà dhya áma amùlepi dhɨ dré adrélé lèle dhɨ kɨ ꞌo kòdhya. ");
INSERT INTO log_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Dɨ tà dhya áma amùlepi nda dré adrélé lèle dhɨ, kònɨ̀dhɨ ꞌɨ: Adré lèá dhɨ, má kòtayɨ́ dhya dré afèle má dré dhɨ kɨ àlo avɨ̀le ko. Adré kpà lèá dhɨ, má kòtɨngá àyɨ nda ɨ títí dràdrà lésè kìtú kùdù sè. ");
INSERT INTO log_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Bàti, tà áma Atá dré adrélé lèle dhɨ, kònɨ̀dhɨ ꞌɨ: Adré lèá dhɨ, dhya ángùdhi adrélépi áyɨ Mváagó nɨ no gò adrézó akódhɨ nɨ kaꞌì dhɨ, dhya nda kàdré lɨ́drɨ̀ kóná vésè kólyá dhɨ ɨ́be. Dɨ má nɨ akódhɨ nɨ tɨngá dràdrà lésè kìtú kùdù sè.» ");
INSERT INTO log_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Dɨ Yúdà ànzɨ nda ɨ̀ dré dhèzo adrélé Yésu nɨ ndrɨ, dré tá tàle dhɨ «Ma mápà asílépi bhù lésè dhɨ ꞌɨ» dhɨ sè. ");
INSERT INTO log_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ɨ̀ adré tá tàá àyɨ kòfalésè dhɨ: «Kòdhɨ tsì Yésu, Yòséfà nɨ mvá ꞌɨ ko? Mà nì akódhɨ nɨ atá, andre nɨ be dhɨ be. Dɨ akódhɨ ꞌo ɨ ngɨ́nɨ adrélé tàá nyànomvá dhɨ, ɨ́ así bhù lésè dhɨ?» ");
INSERT INTO log_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Dɨ Yésu logó àyɨ dré dhɨ: «Mɨ̀ tayɨ́ adrema làndrɨ́ ndrɨ àmɨ kòfalésè dhɨ. ");
INSERT INTO log_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Dhya àlo kɨtswá ɨ́na alɨ̀le má vélé ko, áma Atá áma amùlepi dhɨ kàsé akódhɨ nɨ togó nɨ̀ ko dhɨ. Dɨ má nɨ akódhɨ nda nɨ tɨngá dràdrà lésè kìtú kùdù sè. ");
INSERT INTO log_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ngóró pròfétà ɨ̀ dré tɨsɨ̀le Gìká nɨ Kúlí na dhɨ tɨ́nɨ: ‹Gìká nɨ àyɨ títí dhɨ kɨ tadhá.› Dɨ dhya ángùdhi adrélépi Gìká Atá nɨ yi gò, adrézó tà dré adrélé tadhálé dhɨ kɨ kisú dhɨ, akódhɨ nda adré alɨ̀le má vélé. ");
INSERT INTO log_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Kòdhɨ adré lèá ko tàle dhɨ, dhya àlo nò Gìká Atá dhɨ. Ngbà ꞌí ma angálépi Gìká Atá nda vélésè dhɨ, má nò akódhɨ ma. ");
INSERT INTO log_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Má adré tà bàti ta àmɨ dré: Dhya ángùdhi adrélépi áma kaꞌì dhɨ, akódhɨ nda lɨ́drɨ̀ kóná vésè kólyá dhɨ ɨ́be. ");
INSERT INTO log_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ma mápà adrélépi lɨ́drɨ̀ fe dhɨ ꞌɨ. ");
INSERT INTO log_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Àmɨ kɨ tábhí ɨ̀ nya tá mánnà duku na gò, ɨ̀ dré todràzo. ");
INSERT INTO log_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Dɨ, kònɨ̀dhɨ ɨ́na mápà asílépi bhù lésè dhɨ ꞌɨ. Dhya adrélépi nyàá dhɨ kɨtswá dràle ko. ");
INSERT INTO log_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ma mápà lɨ́drɨ̀ ro asílépi bhù lésè dhɨ ꞌɨ. Dhya ángùdhi adrélépi mápà nda nɨ nya dhɨ, nɨ adré lɨ́drɨ̀ ɨ́be kóná vésè kólyá. Mápà nda kòdhɨ, áma rúbhá má dré dra fèle móndyá bvò àdhya ɨ dré adrɨ́zó dhɨ ꞌɨ.» ");
INSERT INTO log_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Dɨ Yúdà ànzɨ nda ɨ̀ dré ngàzo adrélé tà kayí àyɨ kòfalésè, adrézó tàá dhɨ: «Dhya kòdhɨ nɨ kɨtswá áyɨ rúbhá afè àma dré nyàle ngɨ́nɨngɨ́nɨ ró?» ");
INSERT INTO log_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Dɨ Yésu gò tàá àyɨ dré dhɨ: «Má adré tà bàti ta àmɨ dré: Mɨ̀ kònya Móndɨ́ nɨ Mvá nɨ rúbhá ko, ɨ̀ndɨ̀ mɨ̀ kòmvu akódhɨ nɨ kàrɨ́ ko dhɨ, mɨ̀ kɨtswá àmɨkya adrélé lɨ́drɨ̀ ɨ́be àmɨ léna ko. ");
INSERT INTO log_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Dhya ángùdhi adrélépi áma rúbhá nya, adrézó kpà áma kàrɨ́ mvu dhɨ, akódhɨ nda lɨ́drɨ̀ kóná vésè kólyá dhɨ ɨ́be. Dɨ má nɨ akódhɨ nɨ tɨngá dràdrà lésè kìtú kùdù sè. ");
INSERT INTO log_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Tàko ko, áma rúbhá ngá tàndɨ adrélé nyàle dhɨ ꞌɨ, ɨ̀ndɨ̀ áma kàrɨ́ ngá tàndɨ adrélé mvùle dhɨ ꞌɨ. ");
INSERT INTO log_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Dhya ángùdhi adrélépi áma rúbhá nya, adrézó kpà áma kàrɨ́ mvu dhɨ, akódhɨ nda adré adrélé má léna, ɨ̀ndɨ̀ má adré kpà adrélé akódhɨ léna. ");
INSERT INTO log_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ngóró áma Atá lɨ́drɨ̀ ro dhɨ dré áma amùle dhɨ tɨ́nɨ, ɨ̀ndɨ̀ ngóró má dré adrélé lɨ́drɨ̀ ɨ́be akódhɨ nda sè dhɨ tɨ́nɨ dhɨ, dhya ángùdhi adrélépi áma nya dhɨ nɨ adré kókpà lɨ́drɨ̀ ɨ́be má sè. ");
INSERT INTO log_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ma kònɨ̀dhɨ, mápà asílépi bhù lésè dhɨ ꞌɨ. Àmɨ kɨ tábhí ɨ̀ nya tá mánnà gò, ɨ̀ dré todràzo. Dɨ, dhya adrélépi mápà kònɨ̀dhɨ nɨ nya dhɨ nɨ ɨ́na adré lɨ́drɨ̀ ɨ́be kóná vésè kólyá.» ");
INSERT INTO log_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yésu tà tá tà nda ɨ Kàpàrànàwúmà na, dré tá adréràꞌa tà tadhá Yúdà ànzɨ kɨ lɨ̀sámbò dzó na dhɨ ꞌá. ");
INSERT INTO log_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Dɨ Yésu nɨ lebèbhá ɨ̀ kòyi tà nda ɨ dre dhɨ, àyɨ kɨ àruka bǐ dhɨ ɨ̀ dré tàzoá àyɨ kòfalésè dhɨ: «Tà dré adrélé tadhálé kòdhɨ kòkóròko. Àdhi nɨ kɨtswá yìá kaꞌìle dhɨ nɨ̀?» ");
INSERT INTO log_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yésu dré nìzoá tàle dhɨ, áyɨ lebèbhá nda ɨ̀ adré tá làndrɨ́ ndrɨ tà nda sè dhɨ be gò, dré tàzoá àyɨ dré dhɨ: «Tà kòdhɨ adré tsì àmɨ kɨ ꞌo ledhélé nɨ̀ bàti? ");
INSERT INTO log_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Mɨ̀ nɨ dɨ kisùá ngɨ́nɨ, lókyá mɨ̀ dré dra Móndɨ́ nɨ Mvá nɨ nòzo mbǎràꞌa àrà dré tá adrézó wáláká dhɨ léna dhɨ tú dhɨ? ");
INSERT INTO log_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Gìká nɨ Tɨrɨ́ adré lɨ́drɨ̀ fe nɨ̀. Tà rúbhá àdhya adré ɨ́na tà àlo ꞌo ko. Kúlí má dré tàle àmɨ dré kòdhɨ ɨ kúlí Tɨrɨ́ àdhya ꞌɨ, ɨ̀ndɨ̀ kúlí adrébhá lɨ́drɨ̀ fe dhɨ ꞌɨ. ");
INSERT INTO log_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Dɨ, tágba kònɨ̀nɨ dhɨ, móndɨ́ àruka àmɨ kòfalé dhɨ ɨ̀ kaꞌì àyɨkya ma ko.» Yésu tà tá kònɨ̀nɨ tàko ko, nì tá kɨ́nó lésè ngalè àdhibhá ɨ̀ kɨtswá áyɨ kaꞌì ko ya dhɨ be. Nì tá kpà, àdhi nɨ áyɨ lefè kàrɨbhá ɨ drɨ́gá nɨ̀ ya dhɨ be. ");
INSERT INTO log_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Akódhɨ gò tàá dhɨ: «Tà kòdhɨ sè dhɨ, má tà tá àmɨ dré dhɨ, dhya àlo kɨtswá ɨ́na alɨ̀le má vélé ko, áma Atá kòfè láti akódhɨ dré alɨ̀zo nɨ̀ ko dhɨ.» ");
INSERT INTO log_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Kɨdhólé lókyá nda sè dhɨ, Yésu nɨ lebèbhá bǐ dhɨ ɨ̀ dré akódhɨ nɨ tayɨ́zó gò, ɨ̀ dré gòzo vélé atsílé túmä́ní akódhɨ be ko. ");
INSERT INTO log_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Dɨ Yésu dré lizízóá áyɨ lebèbhá mudrí-drì-rì dhɨ ɨ tí dhɨ: «Àmɨ ró dhɨ, mɨ̀ lè kókpà lɨ̀le àyɨkya tɨ́nɨ?» ");
INSERT INTO log_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Dɨ, Sìmónà Pétèró logó drá dhɨ: «Mírì, mà nɨ lɨ àdhi véna? Mɨ mɨ́na kúlí adrébhá lɨ́drɨ̀ kóná vésè kólyá dhɨ nɨ fe dhɨ ɨ́be. ");
INSERT INTO log_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Àma, mà kaꞌì bàti, ɨ̀ndɨ̀ mà nì tàle dhɨ, mɨ Dhya lólo Gìká àdhya ꞌɨ dhɨ be.» ");
INSERT INTO log_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Dɨ Yésu logó àyɨ dré dhɨ: «Má kɨpè zakó tsì àmɨ mudrí-drì-rì nɨ ɨ ma? Dɨ, tágba kònɨ̀nɨ dhɨ, àmɨ kɨ àlo ɨ́na dzáborò ꞌɨ!» ");
INSERT INTO log_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Adré tá Yùdásɨ̀, Sìmónà Ɨ̀sɨ̀kàrɨ̀yótà nɨ mvá nɨ tà ta kòdhya. Tàko ko, akódhɨ nda, àyɨ mudrí-drì-rì nda kɨ àlo ró dhɨ, adré tá ɨ́na ꞌòle Yésu nɨ lefè kàrɨbhá ɨ drɨ́gá dhɨ nɨ̀. ");
INSERT INTO log_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Àmvolásà dhɨ, Yésu dré gòzo adrélé tatsílé bvò Gàlìláyà àdhya ꞌásè. Adré tá lèá tatsílé bvò Yùdáyà àdhya ꞌásè ko, Yúdà ànzɨ kɨ kàdrɨ̀ kònàle dhɨ ɨ̀ dré tá adrélé láti nda akódhɨ nɨ pfùzo dràle dhɨ sè. ");
INSERT INTO log_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Yúdà ànzɨ kɨ gwányá tàbèrènákolò kya atsá tá ànyɨ. ");
INSERT INTO log_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Dɨ Yésu nɨ adrúpi ɨ̀ dré tàzoá drá dhɨ: «Lè mɨ́ kònga kònwásè lɨ̀le Yùdáyà na, ámɨ lebèbhá wä́yi dhɨ ɨ̀ kònòró kpà tà lɨ́ndrɨ́ga ró mɨ́ dré adrélé ꞌòle dhɨ ɨ be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Dhya àlo kàdré áyɨ le ꞌòle móndɨ́ ɨ dré nìle dhɨ, adré tà ꞌo lùzu ró ko. Mɨ́ dré adrélé tà nda kòdhɨ kɨ ꞌo dhɨ sè dhɨ, mɨ́ tadhá dɨ rè mɨ móndyá wä́yi dhɨ ɨ dré nòle!» ");
INSERT INTO log_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Akódhɨ nɨ adrúpi nda ɨ̀ tà tá kònɨ̀nɨ tàko ko, ɨ̀ adré tá ndɨ̀ndɨ̀ akódhɨ nɨ kaꞌì ko. ");
INSERT INTO log_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Dɨ Yésu dré tàzoá àyɨ dré dhɨ: «Lókyá mána kɨtswá rè ko. Dɨ, àmɨ dré dhɨ, lókyá ángùdhi mɨ̀ dré adrézó lèle lɨ̀le kònàle dhɨ ɨ́na dóro. ");
INSERT INTO log_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Móndyá bvò kòndɨ àdhya ɨ̀ kɨtswá togó kònzɨ bha àmɨ rú ko. Dɨ, ɨ̀ adré àyɨkya togó kònzɨ bha má rú, má dré adrélé tadhá ngádra ꞌá dhɨ, tà ɨ̀ dré adrélé ꞌòle dhɨ ɨ kònzɨ dhɨ sè. ");
INSERT INTO log_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Àmɨ, mɨ̀ lɨ̀ gwányá na. Má kɨtswá rè mána lɨ̀le kònàle ko. Tàko ko, lókyá mána kɨtswá rè ko.» ");
INSERT INTO log_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Kòtà tà nda dre dhɨ, dré gòzo adrélé Gàlìláyà na. ");
INSERT INTO log_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Dɨ, Yésu nɨ adrúpi ɨ̀ kòlɨ̀ gwányá nda na dre dhɨ, akódhɨ dré kpà ngàzo lɨ̀le kònàle. Dɨ, lɨ̀ tá ngádra ꞌásè ko. Be ró dhɨ, lɨ̀ ɨ́na lùzu ró. ");
INSERT INTO log_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Gwányá nda ꞌá dhɨ, Yúdà ànzɨ kɨ kàdrɨ̀ ɨ̀ adré tá akódhɨ nɨ nda, adrézó lizíá dhɨ: «Dhya kòdhɨ ángwà?» ");
INSERT INTO log_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Móndɨ́ zyandre kònàle dhɨ ɨ kòfalé dhɨ, à adré tá ngùrùngùrù ta akódhɨ nɨ tà sè. Àyɨ kɨ àruka ɨ̀ adré tá tàá dhɨ: «Akódhɨ móndɨ́ dóro ꞌɨ.» Àruka nɨ ɨ̀ adré kó tàá dhɨ: «Kóko, adré ɨ́na móndɨ́ zyandre dhɨ kɨ lɨtɨ́.» ");
INSERT INTO log_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Dɨ, dhya àlo adré tá tà ta akódhɨ nɨ tà dri ngádra ꞌá ko, ɨ̀ dré tá adrélé títí Yúdà ànzɨ kɨ kàdrɨ̀ kɨ ro dhɨ sè. ");
INSERT INTO log_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Gwányá nda kòtsa kɨ́tógá nɨ na dre dhɨ, Yésu dré lɨ̀zo tépelò na gò, kɨdhólé adrélé tà tadhá. ");
INSERT INTO log_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Yúdà ànzɨ ɨ̀ adré tá akódhɨ nɨ yi síbhálé be ngbo, adrézó lizíá àyɨ kòfalésè dhɨ: «Dhya kòdhɨ ndà kó tà nìle ko dhɨ, kisú dɨ tògyá adrézó Gìká nɨ tà ni kònɨ̀nɨ dhɨ ngɨ́nɨ?» ");
INSERT INTO log_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Dɨ Yésu dré logózóá àyɨ dré dhɨ: «Tà má dré adrélé tadhálé kòdhɨ ɨ, tà mána ꞌɨ ko. Be ró dhɨ, tà nda ɨ̀ angá àyɨkya Gìká áma amùlepi dhɨ vélésè. ");
INSERT INTO log_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Dhya ángùdhi adrélépi tà Gìká dré adrélé lèle dhɨ kɨ nda ꞌòle dhɨ, akódhɨ nda nɨ nìá ngalè tà má dré adrélé tadhálé nda ɨ̀ angá Gìká vélésè yà, kó ngalè áma tàndɨ vélésè yà dhɨ. ");
INSERT INTO log_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Dhya adrélépi tà adrébhá angálé áyɨ tàndɨ drìlésè dhɨ kɨ tà ta dhɨ, adré rúku nda kisúlé áyɨ tàndɨ dré. Dɨ, dhya adrélépi dhya áyɨ amùlepi dhɨ nɨ rúku nda bhàle dhɨ, adré ɨ́na tà bàti ta. Tà àlo kɨnzò ro akódhɨ léna dhɨ yókódhó. ");
INSERT INTO log_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mósè fè tá tsì tátrɨ́trɨ́ kúlí àmɨ dré ko? Dɨ, dhya àlo àmɨ kòfalé dhɨ adré tà tátrɨ́trɨ́ kúlí nda dré adrélé tàle dhɨ kɨ ꞌo ko. Mɨ̀ adré àmɨkya láti nda kɨtswázó áma pfu dràle àdho tà sè?» ");
INSERT INTO log_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Dɨ móndyá zyandre nda ɨ̀ logó drá dhɨ: «Mɨ tɨrɨ́ kònzɨ ɨ́be mɨ́ léna! Àdhi adré láti nda kɨtswázó ámɨ pfu dràle dhɨ nɨ̀?» ");
INSERT INTO log_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Dɨ Yésu logó àyɨ dré dhɨ: «Má ꞌo ngbà ꞌí tà lɨ́ndrɨ́ga ró àlo dhɨ sàbátù tú gò, àmɨ títí dhɨ kɨ lɨ́ndrɨ́ dré adrézó gàle ásà. ");
INSERT INTO log_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Dɨ, àmɨ ró dhɨ, mɨ̀ adré kókpà àzí ꞌo sàbátù tú. Tàko ko, Mósè fè àmɨ dré tòlɨ́ adrézó àmɨ kɨ ànzɨàgo kɨ lwa gò, mɨ̀ dré adrézó àyɨ kɨ lwa, gba kàdré sàbátù tú yà dhɨ. (Tà bàti ró dhɨ, tòlɨ́ nda angá tá Mósè vélésè ko. Be ró dhɨ, angá ɨ́na àma kɨ tábhí ɨ vélésè drìdrì Mósè nɨ lókyá kandrá.) ");
INSERT INTO log_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Dɨ mɨ̀ kàdré àmɨ kɨ ànzɨàgo kɨ lwa sàbátù tú kɨtswázó Mósè nɨ tátrɨ́trɨ́ kúlí lɨkɨ́ dhɨ, àmɨ kɨ togó adré dɨ aswálé má rú, má dré agó àlo dhɨ nɨ tɨdrɨ́lé wä́yi sàbátù tú dhɨ sè àdho tà sè? ");
INSERT INTO log_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Lè mɨ̀ kàdré móndɨ́ kɨ tàbvó ta ngbà ꞌí tà adrélé nòle mì sè dhɨ ɨ sè ko. Be ró dhɨ, mɨ̀ kàdré àmɨkya tàbvó ta gyǎgya.» ");
INSERT INTO log_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Lókyá nda sè dhɨ, móndyá Yèrúsalémà ꞌa dhɨ kɨ àruka ɨ̀ adré tá tàá àyɨ kòfalésè dhɨ: «Dhya kòdhɨ tsì dhya àma kɨ kàdrɨ̀ ɨ̀ dré adrézó láti nda pfùzoá dràle dhɨ ꞌɨ ko? ");
INSERT INTO log_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Dɨ, mɨ̀ nò rè ká! Akódhɨ adré tà ta ngádra ꞌá gò, ɨ̀ dré adrézó tà àlo ta drá ko! Ɨ̀ nì àyɨkya tàle dhɨ, akódhɨ Mèsɨ́yà ꞌɨ bàti dhɨ be? ");
INSERT INTO log_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Dɨ, lókyá Mèsɨ́yà dré dra atsázó dhɨ sè dhɨ, dhya àlo kɨtswá àrà dré angázó lásà dhɨ nɨ ni ko. Mà nì àmakya àrà dhya kòdhɨ dré angázó lásà dhɨ be.» ");
INSERT INTO log_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Dɨ Yésu dré rè dhu adréràꞌa tà tadhá tépelò na dhɨ ꞌá dhɨ, dré ngàzo kúlí yo tàzoá dhɨ: «Mɨ̀ nì tsì ma be? Mɨ̀ nì àrà má dré angázó lásà dhɨ be? Má alɨ̀ mána áma drì sè ko. Dɨ, dhya áma amùlepi dhɨ adré ngbú adrélé tà bàti ta. Mɨ̀ nì àmɨkya akódhɨ ko. ");
INSERT INTO log_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Dɨ, má nì mána akódhɨ be. Tàko ko, má angá akódhɨ vélésè, ɨ̀ndɨ̀ akódhɨ amù ma nɨ̀.» ");
INSERT INTO log_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Gò Yúdà ànzɨ kɨ kàdrɨ̀ ɨ̀ dré ngàzo adrélé láti nda kɨtswázó akódhɨ nɨ ru. Dɨ, àyɨ kɨ àlo so drɨ́gá akódhɨ rú ko, lókyá nɨ dré tá rè kɨtswálé ko dhɨ sè. ");
INSERT INTO log_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Dɨ, móndyá zyandre nda ɨ kòfalé dhɨ, móndɨ́ bǐ dhɨ ɨ̀ dré akódhɨ nɨ kaꞌìzo. Ɨ̀ adré tá tàá dhɨ: «Lókyá Mèsɨ́yà dré dra atsázó dhɨ sè dhɨ, akódhɨ nɨ tsì tà lɨ́ndrɨ́ga ró dhɨ kɨ ꞌo dhya kòdhɨ àdhya kɨ lavú?» ");
INSERT INTO log_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Fàrìsáyò ɨ̀ dré móndyá zyandre nda kɨ yìzo adréràꞌa ngùrùngùrù ta Yésu nɨ tà dri dhɨ ꞌí. Dɨ àyɨ túmä́ní kòwánà kàdrɨ̀ ɨ́be dhɨ, ɨ̀ dré tépelò lɨkɨ́bhá kɨ àruka kɨ mùzo kɨtswálé akódhɨ nɨ ru. ");
INSERT INTO log_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Gò Yésu dré tàzoá dhɨ: «Ma dhu rè túmä́ní àmɨ ɨ́be lókyá tsà sè. Àmvolásà dhɨ, má nɨ go lɨ̀le dhya áma amùlepi dhɨ véna. ");
INSERT INTO log_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Mɨ̀ nɨ áma nda gò, mɨ̀ dré àmɨkya kɨtswázó áma kisú ko. Àngyá ko, mɨ̀ kɨtswá lɨ̀le àrà má dré adrézó lɨ̀le lána dhɨ na bwà ko.» ");
INSERT INTO log_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Dɨ Yúdà ànzɨ kɨ kàdrɨ̀ nda ɨ̀ dré lizízóá àyɨ kòfalésè dhɨ: «Dhya kòdhɨ adré ꞌòle lɨ̀le ángolé, mà dré kɨtswázó akódhɨ nɨ kisú bwà ko dhɨ? A nɨ lɨ Gìríkì kɨ bvò Yúdà ànzɨ ɨ̀ dré ayɨ́zó dhɨ ɨ ꞌásè, kɨtswálé Gìríkì kɨ tadhá? ");
INSERT INTO log_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Adré lèá tàle ngɨ́nɨ dré adréràꞌa tàá dhɨ: ‹Mɨ̀ nɨ áma nda gò, mɨ̀ dré àmɨkya kɨtswázó áma kisú ko,› ɨ̀ndɨ̀ ‹Mɨ̀ kɨtswá lɨ̀le àrà má dré adrézó lɨ̀le lána dhɨ na bwà ko› dhɨ?» ");
INSERT INTO log_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Gwányá nda nɨ kìtú kùdù, adrélépi kàdrɨ̀ kìtú àruka títí nda kɨ lavú dhɨ sè dhɨ, Yésu dré ngàzo kúlí yo tàzoá dhɨ: «Dhya àlo kàdré yǐ lovó ɨ́be dhɨ, akódhɨ kàlɨ̀ má vélé adrélé yǐ mvu wà. ");
INSERT INTO log_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Dhya ángùdhi adrélépi áma kaꞌì dhɨ, yǐandre adrélépi lɨ́drɨ̀ fe dhɨ nɨ adí apfòle akódhɨ nɨ togó lésè, ngóró Gìká nɨ Kúlí dré adrélé tàle dhɨ tɨ́nɨ.» ");
INSERT INTO log_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Kòdhɨ Yésu adré tá Tɨrɨ́ Lólo móndyá áyɨ kaꞌìbhá dhɨ ɨ̀ dré adrélé ꞌòle kisúlé dhɨ nɨ tà ta kòdhya. Tàko ko, Tɨrɨ́ Lólo nda atsá tá rè ko, Yésu dré tá rè fɨ̀le áyɨ mìlanzìlanzì na ko dhɨ sè. ");
INSERT INTO log_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Móndyá zyandre nda ɨ̀ kòyi Yésu nɨ kúlí nda ɨ dre dhɨ, àyɨ kɨ àruka ɨ̀ dré adrézó tàá dhɨ: «Dhya kòdhɨ Pròfétà ꞌɨ bàti!» ");
INSERT INTO log_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Àruka nɨ ɨ̀ adré tá tàá dhɨ: «Akódhɨ Mèsɨ́yà ꞌɨ!» Dɨ, àruka nɨ ɨ̀ adré kó àyɨkya tàá dhɨ: «Mèsɨ́yà nɨ kɨtswá tsì angálé Gàlìláyà lésè? ");
INSERT INTO log_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Gìká nɨ Kúlí adré zakó tsì tàá dhɨ, Mèsɨ́yà nɨ angá ópɨ́ Dàwídì nɨ súrú lésè, ɨ̀ndɨ̀ Bètèlémè, bhàandre Dàwídì dré angázó lásà dhɨ lésè!» ");
INSERT INTO log_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Dɨ móndyá zyandre nda ɨ̀ dré ru lanzɨ́zó Yésu nɨ tà sè. ");
INSERT INTO log_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Àyɨ kɨ àruka ɨ̀ adré tá lèá dhɨ, à kòru akódhɨ. Dɨ, dhya àlo so drɨ́gá akódhɨ rú ko. ");
INSERT INTO log_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Gò tépelò lɨkɨ́bhá nda ɨ̀ dré gòzo kòwánà kàdrɨ̀ ɨ véna Fàrìsáyò ɨ́be. Dɨ àyɨ nda ɨ̀ dré lizízóá àyɨ tí dhɨ: «Mɨ̀ adrì dhya kòdhɨ agòzo ába ko àdho tà sè?» ");
INSERT INTO log_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Dɨ tépelò lɨkɨ́bhá nda ɨ̀ logó dhɨ: «Dhya àlo adrélépi tà ta dhya kòdhɨ àdhya tɨ́nɨ dhɨ tàdzí yókódhó.» ");
INSERT INTO log_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Dɨ Fàrìsáyò nda ɨ̀ gò lizíá àyɨ tí dhɨ: «Mɨ̀ tayɨ́ kókpà àmɨ akódhɨ nda dré lɨtɨ́lé dre? ");
INSERT INTO log_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Dhya àlo Yúdà ànzɨ kɨ kàdrɨ̀ ɨ kòfalé yà, kó ngalè Fàrìsáyò ɨ kòfalé yà akódhɨ nɨ kaꞌìlepi dhɨ tsì be? ");
INSERT INTO log_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Kóko! Dɨ, móndyá zyandre kòdhɨ ɨ̀ nì àyɨkya Mósè nɨ tátrɨ́trɨ́ kúlí ko. Gìká nɨ tátrɨ́trɨ́ àyɨ dri!» ");
INSERT INTO log_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Fàrìsáyò nda ɨ kòfalé dhɨ, Nìkòdémò atú lɨ̀lepi Yésu véna ngátsi sè dhɨ tá be. Dɨ akódhɨ dré tàzoá àyɨ dré dhɨ: ");
INSERT INTO log_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«Àma kɨ tátrɨ́trɨ́ kúlí kaꞌì tsì tà bhàle dhya àlo dri akódhɨ nɨ yi àko ró, ɨ̀ndɨ̀ tà dré ꞌòle dhɨ nɨ ni àko ró dhɨ ꞌí?» ");
INSERT INTO log_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Dɨ ɨ̀ logó drá dhɨ: «Mɨ kókpà móndɨ́ angálépi Gàlìláyà lésè dhɨ ꞌɨ? Mɨ́ vwa rè tà Gìká nɨ Kúlí dré adrélé tàle dhɨ ɨ ká. Mɨ́ nɨ nòá dhɨ, pròfétà àlo angálépi Gàlìláyà lésè dhɨ yókódhó.»  ");
INSERT INTO log_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Gò àyɨ àlo àlo títí dhɨ ɨ̀ dré ngàzo nzɨ̀le àyɨ bhàꞌásè. ");
INSERT INTO log_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Dɨ Yésu dré lɨ̀zo mbàle kòngó Òlívè fa kya drìna. ");
INSERT INTO log_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ngá kòwa dre dhɨ, dré gòzo lɨ̀le tépelò na gò, móndyá wä́yi dhɨ ɨ̀ dré alɨ̀zo ru kɨmó akódhɨ làga. Akódhɨ dré lɨrɨ́zó gò kɨdhólé adrélé àyɨ kɨ tadhá. ");
INSERT INTO log_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Dɨ tátrɨ́trɨ́ kúlí tadhábhá ɨ Fàrìsáyò ɨ́be dhɨ, ɨ̀ dré tòkó àlo dhɨ nɨ adrìzo alɨ̀zo bhàá móndyá wä́yi ɨ kandrá. Ɨ̀ ru tá akódhɨ nda adréràꞌa múná tà ꞌo agó àlo dhɨ be. ");
INSERT INTO log_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Dɨ ɨ̀ dré tàzoá Yésu dré dhɨ: «Tadhálépi, à kɨ tòkó kònɨ̀dhɨ adréràꞌa múná tà ꞌo agó àlo be dhɨ ꞌá. ");
INSERT INTO log_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mósè fè tá tòlɨ́ tátrɨ́trɨ́ kúlí na tàzoá àma dré dhɨ, mà kàdré tòkó tà ꞌobhá kònɨ̀nɨ dhɨ kɨ lebhé todràle kɨ́rà sè. Dɨ mɨ́ adré mɨ́na tàá tà kòdhɨ sè ngɨ́nɨ?» ");
INSERT INTO log_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ɨ̀ lizí tá akódhɨ kònɨ̀nɨ kɨtswázó akódhɨ nɨ tabhì lɨtɨ́lé, ɨ̀ kòkɨtswáró akódhɨ nɨ asíkì be dhɨ bvó. Dɨ, Yésu dré ɨ́na tandìzo gò, kɨdhólé adrélé ngá tɨsɨ̀ drɨ́gámbɨ́lɨ́ sè kìní mi. ");
INSERT INTO log_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ɨ̀ dré rè dhu adréràꞌa akódhɨ nɨ lizí dhɨ ꞌá dhɨ, dré ngàzo áyɨ totó gò, tàá àyɨ dré dhɨ: «Dhya tàkonzɨ̀ ꞌòlepi tàdzí ko dhɨ kàdré àmɨ kòfalé be dhɨ, akódhɨ nda kòkɨdhó rè zyà tòkó kònɨ̀dhɨ nɨ lebhélé kɨ́rà sè dhɨ nɨ̀.» ");
INSERT INTO log_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Dɨ dré gòzo tódhyá tandìle adrélé ngá tɨsɨ̀ kìní mi. ");
INSERT INTO log_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Dɨ ɨ̀ kòyi kúlí nda dre dhɨ, ɨ̀ dré ngàzo topfòle àlo àlo kɨdhólé màlɨ̀ga ɨ rú, Yésu kɨ tayɨ́ tòkó nda adrélépi áyɨ totó akódhɨ kandrá dhɨ be. ");
INSERT INTO log_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Dɨ Yésu dré ngàzo áyɨ totó lizíá tíá dhɨ: «Tòkó, àyɨ nda ɨ ángwà? Dhya àlo tà bhàlepi mɨ́ dri dhɨ yókódhó?» ");
INSERT INTO log_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Akódhɨ logó dhɨ: «Mírì, dhya àlo yó.» Dɨ Yésu tà drá dhɨ: «Má bhà kókpà tà mɨ́ dri ko. Dɨ mɨ́ lɨ̀, ɨ̀ndɨ̀ kɨdhólé nyànomvá dhɨ, mɨ́ kògò vélé tàkonzɨ̀ ꞌo ko.» ");
INSERT INTO log_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yésu dré gòzo tàá móndyá zyandre ɨ dré dhɨ: «Ma ngádra adrélépi ngá kazá móndyá bvò àdhya ɨ dré dhɨ ꞌɨ. Dhya ángùdhi adrélépi áma lebè dhɨ kɨtswá tàdzí atsílé tínímvá na ko. Be ró dhɨ, a nɨ adré ngádra lɨ́drɨ̀ àdhya ɨ́be.» ");
INSERT INTO log_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Dɨ, Fàrìsáyò ɨ̀ dré ngàzo tàá drá dhɨ: «Mɨ́ adré mɨ́na ámɨ tàndɨ nɨ tà longó mɨ. Tà mɨ́ dré adrélé tàle dhɨ ɨ, tà bàti ꞌɨ ko.» ");
INSERT INTO log_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Dɨ Yésu logó àyɨ dré dhɨ: «Gba má dré adrézó áma tàndɨ nɨ tà longó dhɨ, tà má dré adrélé tàle dhɨ ɨ, tà bàti ꞌɨ. Tàko ko, má nì, má angá ángolésè ya, ɨ̀ndɨ̀ má adré lɨ̀le ángolé ya dhɨ be. Dɨ, mɨ̀ nì àmɨkya ngalè má angá ángolésè ya, kó ngalè má adré lɨ̀le ángolé ya dhɨ ko. ");
INSERT INTO log_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Mɨ̀ adré àmɨkya áma tàbvó ta ngóró móndyá bvò kòndɨ àdhya ɨ̀ dré adrélé tàle dhɨ tɨ́nɨ. Dɨ, má adré mána dhya àlo nɨ tàbvó ta ko. ");
INSERT INTO log_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Kònò má kàdré tá tàbvó ta dhɨ, tàbvó má dré kɨtswálé tàle nda nɨ tá adré gyǎgya. Àngyá ko, má adré tà àlo ꞌo kalóma ko. Be ró dhɨ, áma Atá áma amùlepi dhɨ túmä́ní má be. ");
INSERT INTO log_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","À tɨsɨ̀ tá àmɨ kɨ tàndɨ kɨ tátrɨ́trɨ́ kúlí na tàle dhɨ, móndɨ́ rì tà nobhá mì sè dhɨ ɨ̀ kàdré tà àlo dhɨ nɨ longó kòdhya dhɨ, tà ɨ̀ dré adrélé longólé nda, tà bàti ꞌɨ. ");
INSERT INTO log_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ma, má adré áma tàndɨ nɨ tà longó. Kòdhɨ ɨ́be dhɨ, áma Atá áma amùlepi dhɨ adré kókpà áma tà longó.» ");
INSERT INTO log_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Dɨ ɨ̀ lizí tíá dhɨ: «Ámɨ Atá ángwà?» Yésu gò logóá àyɨ dré dhɨ: «Mɨ̀ nì ma àdhi ꞌɨ yà dhɨ ko, ɨ̀ndɨ̀ mɨ̀ nì áma Atá àdhi ꞌɨ yà dhɨ ko. Kònò mɨ̀ kònì tá ma be dhɨ, mɨ̀ nɨ tá kpà áma Atá nɨ ni.» ");
INSERT INTO log_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yésu tà tá kúlí nda ɨ, dré tá adréràꞌa tà tadhá tépelò na, ànyɨ àrà adrézó ngá fèle Gìká dré dhɨ kɨ lɨkɨ́ dhɨ làga dhɨ ꞌá. Dɨ, dhya àlo ru tá akódhɨ ko, lókyá nɨ dré tá rè kɨtswálé ko dhɨ sè. ");
INSERT INTO log_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yésu dré gòzo tàá àyɨ dré dhɨ: «Má adré ꞌòle lɨ̀le. Mɨ̀ nɨ áma nda gò, mɨ̀ dré àmɨkya todràzo àmɨ kɨ tàkonzɨ̀ na. Mɨ̀ kɨtswá lɨ̀le àrà má dré adrézó lɨ̀le lána dhɨ na bwà ko.» ");
INSERT INTO log_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Dɨ Yúdà ànzɨ ɨ̀ lizí àyɨ kòfalésè dhɨ: «Akódhɨ adré ꞌòle áyɨ pfu dràle? Kòdhɨ vo tà dré adrézó tàá dhɨ: ‹Mɨ̀ kɨtswá lɨ̀le àrà má dré adrézó lɨ̀le lána dhɨ na bwà ko› dhɨ ꞌɨ?» ");
INSERT INTO log_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Dɨ Yésu logó àyɨ dré dhɨ: «Mɨ̀ angá àmɨkya bvò kòndɨ lésè. Dɨ, má angá mána kurú lésè. Àmɨ móndɨ́ bvò kòndɨ àdhya ꞌɨ. Dɨ, ma mána móndɨ́ bvò kòndɨ àdhya ꞌɨ ko. ");
INSERT INTO log_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ásà dhɨ, má tà tá àmɨ dré dhɨ, mɨ̀ nɨ todrà àmɨ kɨ tàkonzɨ̀ na. Tàko ko, mɨ̀ kòkaꞌì, ma Dhya adrélépi be dhɨ ꞌɨ ko dhɨ, mɨ̀ nɨ dra todrà àmɨ kɨ tàkonzɨ̀ na.» ");
INSERT INTO log_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Dɨ ɨ̀ lizí tíá dhɨ: «Mɨ mɨ́na àdhi ꞌɨ?» Yésu gò logóá àyɨ dré dhɨ: «Ma dhya má dré adrézó tàá kɨ́nó lésè dhɨ, ma akódhɨ ꞌɨ nda ꞌɨ. ");
INSERT INTO log_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ma dhu rè tà ɨ́be bǐ tàle àmɨ kɨ tà dri. Ma kpà tà ɨ́be bǐ tàle àmɨ kɨ tàbvó tàzo. Dɨ, dhya áma amùlepi dhɨ adré ngbú adrélé tà bàti ta. Má adré ngbà ꞌí tà má dré yìle akódhɨ nda vélésè dhɨ kɨ ta móndyá bvò kòndɨ àdhya ɨ dré kòdhya.» ");
INSERT INTO log_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Dɨ, ɨ̀ nì tá ko tàle dhɨ, Yésu adré tá áyɨ Atá nɨ tà ta kòdhya dhɨ. ");
INSERT INTO log_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Dɨ Yésu gò tàá àyɨ dré dhɨ: «Lókyá mɨ̀ dré dra ma, Móndɨ́ nɨ Mvá nɨ tɨngázó kuru dhɨ sè dhɨ, mɨ̀ nɨ nìá tàle dhɨ, ma Dhya adrélépi be nda ꞌɨ dhɨ be. Mɨ̀ nɨ kpà nìá tàle dhɨ, má adré tà àlo ꞌo áma drì sè ko dhɨ be. Dɨ, má adré ngbà ꞌí tà áma Atá dré tadhálé má dré dhɨ kɨ ta kòdhya. ");
INSERT INTO log_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Dhya áma amùlepi dhɨ túmä́ní má be. Tayɨ́ ma kalóma ko. Àngyá ko, má adré ngbú tà akódhɨ nɨ togó dré adrézó kɨnɨ́lé ásà dhɨ kɨ ꞌo kòdhya.» ");
INSERT INTO log_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Dɨ Yésu dré tá adréràꞌa tà nda kɨ ta dhɨ ꞌá dhɨ, móndɨ́ bǐ dhɨ ɨ̀ dré akódhɨ nɨ kaꞌìzo. ");
INSERT INTO log_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Dɨ Yésu dré tàzoá Yúdà ànzɨ áyɨ kaꞌìbhá nda ɨ dré dhɨ: «Mɨ̀ kàdré tròle tà má dré adrélé tadhálé dhɨ ɨ rú dhɨ, mɨ̀ nɨ adré áma lebèbhá ꞌɨ bàti. ");
INSERT INTO log_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Dɨ mɨ̀ nɨ tà bàti ni gò, tà bàti nda dré àmɨ kɨ trɨ̀zo wä́yi.» ");
INSERT INTO log_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ɨ̀ logó drá dhɨ: «Àma, àma Àbàrámà nɨ súrú ꞌɨ. Mà atsá rè tàdzí dhya àlo nɨ màrábà ro ko. Dɨ mɨ́ adré mɨ́na tàá dhɨ, à nɨ àma kɨ trɨ dhɨ ngɨ́nɨ?» ");
INSERT INTO log_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Dɨ Yésu logó àyɨ dré dhɨ: «Má adré tà bàti ta àmɨ dré: Dhya ángùdhi adrélépi tàkonzɨ̀ ꞌo dhɨ, akódhɨ nda tàkonzɨ̀ nɨ màrábà ꞌɨ. ");
INSERT INTO log_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Màrábà adré ɨ́na adrélé súrú ꞌá nyo ko. Dɨ, mváagó adré ɨ́na adrélé súrú ꞌá nyo. ");
INSERT INTO log_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Dɨ Gìká nɨ Mváagó kòtrɨ̀ àmɨ dhɨ, mɨ̀ nɨ adré móndɨ́ trɨ̀le bàti dhɨ ɨ ró. ");
INSERT INTO log_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Má nì tàle dhɨ, àmɨ Àbàrámà nɨ súrú ꞌɨ dhɨ be. Dɨ, mɨ̀ adré àmɨkya láti nda kɨtswázó áma pfu dràle, mɨ̀ dré adrélé áma kúlí kaꞌì dòle àmɨ kɨ togó na ko dhɨ sè. ");
INSERT INTO log_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Má adré mána tà áma Atá dré tadhálé má dré dhɨ kɨ ta kòdhya. Dɨ, mɨ̀ adré àmɨkya tà mɨ̀ dré yìle àmɨ kɨ atá vélésè dhɨ kɨ ꞌo kòdhya.» ");
INSERT INTO log_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ɨ̀ gò logóá drá dhɨ: «Àma kɨ atá, Àbàrámà ꞌɨ.» Dɨ Yésu tà àyɨ dré dhɨ: «Mɨ̀ kàdré tá Àbàrámà nɨ ànzɨ ꞌɨ bàti dhɨ, kònò mɨ̀ nɨ tá adré tà Àbàrámà dré ꞌòle dhɨ kɨ ꞌo kòdhya. ");
INSERT INTO log_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Dɨ, nyànomvá dhɨ, mɨ̀ adré àmɨkya láti nda kɨtswázó áma pfu dràle, má dré tà bàti má dré yìle Gìká vélésè dhɨ nɨ tàle àmɨ dré dhɨ sè. Àbàrámà ꞌo tá ɨ́na tà làsú be kònɨ̀nɨ dhɨ ko. ");
INSERT INTO log_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Dɨ, mɨ̀ adré àmɨkya tà ꞌo ngóró àmɨ kɨ atá dré adrélé ꞌòle dhɨ tɨ́nɨ.» Dɨ ɨ̀ logó drá dhɨ: «Àma, àma ànzɨ tìle swà ro dhɨ ꞌɨ ko! Àma kɨ Atá, Gìká ꞌɨ kalóma.» ");
INSERT INTO log_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yésu gò tàá àyɨ dré dhɨ: «Gìká kàdré tá àmɨ kɨ Atá ꞌɨ bàti dhɨ, kònò mɨ̀ nɨ tá adré áma le. Àngyá ko, má angá Gìká vélésè gò, má dré adrézó kònwa akódhɨ nɨ rú sè. Má alɨ̀ mána áma drì sè ko. Be ró dhɨ, akódhɨ amù ma nɨ̀. ");
INSERT INTO log_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Tà má dré adrélé tàle kòdhɨ ɨ̀ adré fɨ̀le àmɨ drìna ko àdho tà sè? Ɨ̀ adré fɨ̀le ko, mɨ̀ dré kɨtswálé áma kúlí yi bwà ko dhɨ sè. ");
INSERT INTO log_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Àmɨ àmɨkya àmɨ kɨ atá Dzáborò nɨ ànzɨ ꞌɨ. Mɨ̀ adré àmɨ kɨ atá nda nɨ lovó le ꞌòle kòdhya. Kɨdhólé kɨdhoma lésè dhɨ, akódhɨ nda dhya adrélépi móndɨ́ kɨ tupfú todràle dhɨ ꞌɨ. Adré kpà tròle tà bàti rú ko, tà bàti dré adrélé akódhɨ léna àlomvá ko dhɨ sè. Dré adréràꞌa kɨnzò ta dhɨ ꞌá dhɨ, adré áyɨ tàndɨ nɨ ti ta kòdhya. Tàko ko, akódhɨ kɨnzò líyí ꞌɨ, ɨ̀ndɨ̀ kɨnzò nɨ atá ꞌɨ. ");
INSERT INTO log_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Dɨ, má dré mána adrélé tà bàti ta dhɨ sè dhɨ, mɨ̀ adré áma kaꞌì ko. ");
INSERT INTO log_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Àmɨ kòfalé dhɨ, àdhi nɨ kɨtswá tsì tàkonzɨ̀ àlo tadhá má rú dhɨ nɨ̀? Dɨ má kàdré tà bàti ta kòdhya dhɨ, mɨ̀ adré áma kaꞌì ko àdho tà sè? ");
INSERT INTO log_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Dhya adrélépi Gìká àdhya ró dhɨ adré ɨ́na Gìká nɨ kúlí yi. Dɨ, mɨ̀ adré àmɨkya áma kúlí yi ko, mɨ̀ dré adrélé Gìká àdhya ró ko dhɨ sè.» ");
INSERT INTO log_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Dɨ Yúdà ànzɨ nda ɨ̀ gò logóá drá dhɨ: «Mà adré zakó tàá kyá tàle dhɨ, mɨ mɨ́na Sàmàrɨ́yà agó ꞌɨ, ɨ̀ndɨ̀ mɨ tɨrɨ́ kònzɨ ɨ́be mɨ́ léna dhɨ!» ");
INSERT INTO log_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Dɨ Yésu logó àyɨ dré dhɨ: «Tɨrɨ́ kònzɨ má léna yókódhó. Be ró dhɨ, má adré mána lɨndrɨ̀ fe áma Atá dré. Dɨ, mɨ̀ adré àmɨkya kanyò fe má dré. ");
INSERT INTO log_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Má adré mìlanzìlanzì nda kisúlé áma tàndɨ dré ko. Dɨ, dhya adrélépi mìlanzìlanzì le fèle má dré dhɨ be. Akódhɨ nda kpà dhya adrélépi tàbvó ta gyǎgya dhɨ ꞌɨ. ");
INSERT INTO log_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Má adré tà bàti ta àmɨ dré: Dhya ángùdhi adrélépi áma kúlí kaꞌì ꞌòle dhɨ kɨtswá tàdzí dràle ko!» ");
INSERT INTO log_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Dɨ Yúdà ànzɨ nda ɨ̀ gò tàá drá dhɨ: «Nyànomvá, mà nì tàle dhɨ, mɨ tɨrɨ́ kònzɨ ɨ́be mɨ́ léna káyà dhɨ be! Àbàrámà drà dre. Pròfétà ɨ̀ todrà kókpà dre. Dɨ, mɨ́ adré mɨ́na tàá dhɨ, dhya adrélépi ámɨ kúlí kaꞌì ꞌòle dhɨ kɨtswá tàdzí dràle ko. ");
INSERT INTO log_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Mɨ́ adré kisùá dhɨ, mɨ mɨ́na kàdrɨ̀ àma kɨ atá Àbàrámà nɨ lavú? Akódhɨ drà dre. Pròfétà ɨ̀ todrà kókpà dre. Mɨ́ adré dɨ kisùá dhɨ, mɨ tá mɨ́na àdhi ꞌɨ?» ");
INSERT INTO log_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Dɨ Yésu gò logóá dhɨ: «Má kàdré tá mìlanzìlanzì nda kisúlé áma tàndɨ dré dhɨ, kònò áma mìlanzìlanzì nda nɨ tá adré tà tàko ró. Dɨ, áma Atá adré ɨ́na áma mì bha lanzìle dhɨ nɨ̀. Akódhɨ nda, dhya mɨ̀ dré adrézó tàá dhɨ, akódhɨ àmɨ kɨ Gìká ꞌɨ dhɨ ꞌɨ. ");
INSERT INTO log_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Mɨ̀ nì àmɨkya akódhɨ ko. Dɨ, má nì mána akódhɨ be. Kònò má kòtà tá dhɨ, má nì akódhɨ ko dhɨ, má nɨ tá adré kɨnzò líyí ꞌɨ àmɨ tɨ́nɨ. Dɨ má nì akódhɨ be, ɨ̀ndɨ̀ má adré akódhɨ nɨ kúlí kaꞌì ꞌòle. ");
INSERT INTO log_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Àmɨ kɨ atá Àbàrámà lenzé tá tò, dré tá kìtú má dré alɨ̀zo dhɨ nɨ nòle dhɨ sè. Akódhɨ nò kìtú nda ꞌí gò, dré lenzézó ásà.» ");
INSERT INTO log_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Dɨ Yúdà ànzɨ nda ɨ̀ tà drá dhɨ: «Ámɨ kóná kòtsa kó rè nyadhɨ-rì-drì-mudrí ko dhɨ, mɨ́ ꞌo mɨ ngɨ́nɨ tàá dhɨ, mɨ́ nò Àbàrámà ꞌí dhɨ?» ");
INSERT INTO log_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Dɨ Yésu logó àyɨ dré dhɨ: «Má adré tà bàti ta àmɨ dré: Àbàrámà nɨ tirà ko dhɨ ꞌá dhɨ, ma tá mána be!» ");
INSERT INTO log_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Dɨ kúlí nda sè dhɨ, ɨ̀ dré ngàzo kɨ́rà kudhú, kɨtswázó akódhɨ nɨ lebhé dràle ásà. Dɨ, Yésu dré ɨ́na áyɨ zùzo gò, pfòle lyà tépelò ꞌásè. ");
INSERT INTO log_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yésu ɨ̀ dré tá adréràꞌa lɨ̀le láti ꞌásè dhɨ ꞌá dhɨ, akódhɨ dré mì bhèzo agó àlo tìle mì kùdúkùdu ró dhɨ nɨ no. ");
INSERT INTO log_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Dɨ akódhɨ nɨ lebèbhá ɨ̀ dré lizízóá dhɨ: «Rábbì, àdhi ꞌo tàkonzɨ̀ agó kònɨ̀dhɨ nɨ tìzo mì kùdúkùdu ró dhɨ nɨ̀? Akódhɨ ꞌo nɨ̀, kó ngalè akódhɨ nɨ tibhá ɨ̀ ꞌo kó àyɨ?» ");
INSERT INTO log_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yésu logó dhɨ: «À ti akódhɨ kònɨ̀nɨ akódhɨ nɨ tàkonzɨ̀ sè yà, kó ngalè akódhɨ nɨ tibhá kɨ tàkonzɨ̀ sè yà dhɨ ko. Be ró dhɨ, à ti akódhɨ kònɨ̀nɨ, à kòkɨtswáró tà Gìká dré adrélé lèle ꞌòle akódhɨ léna dhɨ nɨ no be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Adré lèá dhɨ, mà kàdré dhya áma amùlepi dhɨ nɨ àzí ꞌo kìtú dré adréràꞌa be dhɨ ꞌá. Ngátsi adré ɨ́na alɨ̀le. Lókyá nda sè dhɨ, dhya àlo kɨtswá àzí ꞌo bwà ko. ");
INSERT INTO log_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Má dré adréràꞌa bvò kònɨ̀dhɨ lé dhɨ ꞌá dhɨ, ma ngádra adrélépi ngá kazá móndyá bvò àdhya ɨ dré dhɨ ꞌɨ.» ");
INSERT INTO log_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Yésu kòtà tà nda dre dhɨ, dré tùsú fùzo kìní mi, kùrú anzwázó tùsú nda sè gò, agó mì kùdúkùdu ró nda nɨ mì ndryàzo ásà. ");
INSERT INTO log_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Dré tàzoá drá dhɨ: «Mɨ́ lɨ̀ ámɨ mì dzɨ yǐ ledélé rú zìle Sìlòwámà dhɨ na.» (Rú Sìlòwámà nda kòdhɨ adré lèá tàle dhɨ «Mùle dhɨ».) Dɨ agó nda dré lɨ̀zo áyɨ mì dzɨ kònàle gò, dré nzɨ̀zo adrélé ngá nobe. ");
INSERT INTO log_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Dɨ akódhɨ nɨ bhàzɨ̌ ɨ, túmä́ní móndyá atú akódhɨ nɨ nobhá adréràꞌa ngá zi dhɨ ɨ́be dhɨ, ɨ̀ dré ngàzo adrélé lizíá àyɨ kòfalésè dhɨ: «Agó kònɨ̀dhɨ tsì dhya adrélépi tá lɨrɨ́lé adrélé ngá zi dhɨ ꞌɨ ko?» ");
INSERT INTO log_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Àyɨ kɨ àruka ɨ̀ dré adrézó tàá dhɨ: «Akódhɨ ꞌɨ.» Àruka nɨ ɨ̀ adré kó tàá dhɨ: «Kóko. Akódhɨ ꞌɨ ko. Dɨ, sù akódhɨ tɨ́nɨ.» Dɨ, agó nda dré ɨ́na adrézó tàá dhɨ: «Ma ꞌɨ!» ");
INSERT INTO log_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Dɨ ɨ̀ lizí tíá dhɨ: «Ámɨ mì nzì dɨ ru adrélé ngá no ngɨ́nɨngɨ́nɨ ró?» ");
INSERT INTO log_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Akódhɨ logó àyɨ dré dhɨ: «Agó rú zìle Yésu dhɨ anzwá tá kùrú, áma mì ndryàzo ásà gò, tàzoá dhɨ, má kòlɨ̀ áma mì dzɨ yǐ Sìlòwámà àdhya na. Dɨ má kòlɨ̀ áma mì dzɨ kònàle dre dhɨ, má dré ngàzo adrélé ngá no!» ");
INSERT INTO log_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ɨ̀ gò lizíá tíá dhɨ: «Agó kòdhɨ ángwà?» Gò logóá dhɨ: «Má nì ko.» ");
INSERT INTO log_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Gò ɨ̀ dré agó adrélépi tá mì kùdúkùdu ró nda nɨ drìzo, lɨ̀zo ába Fàrìsáyò ɨ véna. ");
INSERT INTO log_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Kìtú Yésu dré tá kùrú anzwázó gò, agó nda nɨ mì nzìzo dhɨ tá sàbátù ꞌɨ. ");
INSERT INTO log_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Dɨ Fàrìsáyò nda ɨ̀ dré kpà lizízóá akódhɨ tí, ngalè akódhɨ nɨ mì nzì tá ru adrélé ngá no ngɨ́nɨ ya dhɨ. Akódhɨ dré logózóá àyɨ dré dhɨ: «Agó àlo dhɨ ndryà tá áma mì kùrú sè. Dɨ má kòdzɨ̀ áma mì dre dhɨ, má dré kɨdhózó adrélé ngá no.» ");
INSERT INTO log_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Fàrìsáyò nda kɨ àruka ɨ̀ gò adrélé tàá dhɨ: «Dhya tà nda nɨ ꞌòlepi kòdhɨ angá ɨ́na Gìká vélésè ko. Tàko ko, adré sàbátù nɨ tòlɨ́ lɨkɨ́ ko.» Dɨ, àruka nɨ ɨ̀ adré kó tàá dhɨ: «Tàkonzɨ̀ líyí kɨtswá ɨ́na tà lɨ́ndrɨ́ga ró làsú be kònɨ̀nɨ dhɨ kɨ ꞌo bwà ngɨ́nɨngɨ́nɨ ró?» Dɨ ɨ̀ dré ru lanzɨ́zó tà nda sè. ");
INSERT INTO log_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ɨ̀ dré gòzo lizíá agó adrélépi tá mì kùdúkùdu ró nda tí dhɨ: «Mɨ ró dhɨ, mɨ́ adré mɨ́na tàá agó ámɨ mì nzìlepi nda nɨ tà sè ngɨ́nɨ?» Akódhɨ logó dhɨ: «Akódhɨ nda pròfétà ꞌɨ.» ");
INSERT INTO log_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Dɨ, Yúdà ànzɨ kɨ kàdrɨ̀ nda ɨ̀ kaꞌì tá rè ko tàle dhɨ, agó nda tá mì kùdúkùdu ꞌɨ gò, dré gòzo adrélé ngá no dhɨ. Ásà dhɨ, ɨ̀ dré akódhɨ nɨ tibhá kɨ azízó gò, ");
INSERT INTO log_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","lizízóá àyɨ tí dhɨ: «Agó kònɨ̀dhɨ àmɨ kɨ mvá ꞌɨ? Mɨ̀ adré tàá dhɨ, mɨ̀ ti tá akódhɨ mì kùdúkùdu ró? Adré dɨ ngá no nyànomvá ngɨ́nɨngɨ́nɨ ró?» ");
INSERT INTO log_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Dɨ akódhɨ nɨ tibhá nda ɨ̀ logó àyɨ dré dhɨ: «Mà nì tàle dhɨ, kònɨ̀dhɨ àma kɨ mvá ꞌɨ, ɨ̀ndɨ̀ apfò tá mì kùdúkùdu ró dhɨ be. ");
INSERT INTO log_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Dɨ, mà nì ngalè adré nyànomvá ngá no ngɨ́nɨ ya dhɨ ko. Mà nì kpà ngalè àdhi nzì akódhɨ nɨ mì nɨ̀ ya dhɨ ko. Mɨ̀ kòlizí akódhɨ kòdhya. Atsá kàdrɨ̀ dre. A nɨ kɨtswá áyɨ tàndɨ nɨ tà ta bwà.» ");
INSERT INTO log_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Akódhɨ nɨ tibhá nda ɨ̀ tà tá kònɨ̀nɨ, ɨ̀ dré tá adrélé Yúdà ànzɨ kɨ kàdrɨ̀ kɨ ro dhɨ sè. Tàko ko, àyɨ nda ɨ̀ yi tá ru tàzoá dhɨ, ɨ̀ nɨ dhya ángùdhi adrélépi kaꞌìá tàle dhɨ, Yésu Mèsɨ́yà ꞌɨ dhɨ nɨ dro àyɨ kɨ lɨ̀sámbò dzó lésè. ");
INSERT INTO log_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Tà nda sè dhɨ, akódhɨ nɨ tibhá nda ɨ̀ tà tá dhɨ: «Atsá kàdrɨ̀ dre. Mɨ̀ kòlizí akódhɨ kòdhya.» ");
INSERT INTO log_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Dɨ Fàrìsáyò nda ɨ̀ dré gòzo tódhyá agó adrélépi tá mì kùdúkùdu ró nda nɨ azí gò, ɨ̀ dré tàzoá drá dhɨ: «Mɨ́ fè lɨndrɨ̀ Gìká dré. Mà nì tàle dhɨ, agó kòdhɨ tàkonzɨ̀ líyí ꞌɨ dhɨ be.» ");
INSERT INTO log_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Gò logóá dhɨ: «Akódhɨ nda kàdré ɨ́na tàkonzɨ̀ líyí ꞌɨ bàti dhɨ, má nì ko. Má nì ngbà ꞌí tà àlo kònɨ̀dhɨ: Ma tá mì kùdúkùdu ró. Dɨ, nyànomvá dhɨ, má adré ngá no!» ");
INSERT INTO log_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Dɨ ɨ̀ gò lizíá tíá dhɨ: «Akódhɨ nda ꞌo mɨ ngɨ́nɨ? Nzì ámɨ mì ngɨ́nɨ?» ");
INSERT INTO log_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Gò logóá àyɨ dré dhɨ: «Má tà tá àmɨ dré dre. Dɨ, mɨ̀ yi ma ko. Mɨ̀ adré tà nda nɨ le yìle tódhyá àdho tà sè? Mɨ̀ adré kpà lèá atsálé akódhɨ nɨ lebèbhá ɨ ró?» ");
INSERT INTO log_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Dɨ ɨ̀ dré akódhɨ nɨ dhàzo tàzoá dhɨ: «Mɨ mɨ́na dhya kòdhɨ nɨ lebèlepi ꞌɨ! Àma àmakya Mósè nɨ lebèbhá ꞌɨ! ");
INSERT INTO log_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Mà nì tàle dhɨ, Gìká tà tá tà Mósè be dhɨ be. Dɨ, kàdré ɨ́na dhya kòdhɨ nɨ tà sè dhɨ, mà nì ngalè akódhɨ angá ángolésè ya dhɨ ko.» ");
INSERT INTO log_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Dɨ agó nda logó àyɨ dré dhɨ: «Tà kòdhɨ tà kɨtswálépi dhyá kɨ lɨ́ndrɨ́ tɨgá dhɨ ꞌɨ! Mɨ̀ nì àmɨkya ngalè akódhɨ angá ángolésè ya dhɨ ko, tágba dré áma mì nzìzo nɨ̀ dhɨ! ");
INSERT INTO log_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Mà nì tàle dhɨ, Gìká adré tàkonzɨ̀bhá kɨ yi ko dhɨ be. Dɨ, adré ɨ́na móndyá adrébhá tròle áyɨ tà rú, adrébhá tà ɨ́ dré adrélé lèle dhɨ kɨ ꞌo dhɨ kɨ yi kòdhya. ");
INSERT INTO log_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","À yi rè tàdzí ko tàle dhɨ, dhya àlo nzì móndɨ́ tìle mì kùdúkùdu ró dhɨ nɨ mì dhɨ. ");
INSERT INTO log_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Kònò agó kòdhɨ kàngá tá Gìká vélésè ko dhɨ, kɨtswá tá tà àlo ꞌo bwà ko.» ");
INSERT INTO log_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Dɨ ɨ̀ logó drá dhɨ: «À ti mɨ trú tàkonzɨ̀ na bàti! Mɨ́ ꞌo mɨ ngɨ́nɨ, adrélé àma kɨ tadhá dhɨ?» Dɨ ɨ̀ dré akódhɨ nɨ dròzo àyɨ kɨ lɨ̀sámbò dzó lésè. ");
INSERT INTO log_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yésu kòyi tàle dhɨ, ɨ̀ dro tá agó nda dhɨ dre dhɨ, dré akódhɨ nɨ kisúzó gò, lizízóá tíá dhɨ: «Mɨ́ adré Móndɨ́ nɨ Mvá nɨ kaꞌì?» ");
INSERT INTO log_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Agó nda logó dhɨ: «Mírì, mɨ́ tà rè má dré, akódhɨ nda àdhi ꞌɨ ya dhɨ ká, má kòkɨtswáró akódhɨ nɨ kaꞌì be dhɨ bvó.» ");
INSERT INTO log_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yésu tà drá dhɨ: «Mɨ́ nò akódhɨ dre. Akódhɨ dhya adrélépi tà ta mɨ́ be nɨ ꞌɨ.» ");
INSERT INTO log_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Dɨ agó nda tà drá dhɨ: «Mírì, má kaꞌì dre!» Gò dré adhézó áyɨ kórókó titì Yésu kandrá, akódhɨ nɨ lɨndrɨ̀ bhàzo. ");
INSERT INTO log_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Dɨ Yésu dré gòzo tàá dhɨ: «Má alɨ̀ mána bvò kòndɨ lé kɨtswálé tàbvó kònɨ̀dhɨ nɨ ta: Má alɨ̀ kɨtswálé dhya mì kùdúkùdu ró dhɨ ɨ̀ kòkɨtswáró ngá no, ɨ̀ndɨ̀ dhya adrébhá ngá no dhɨ ɨ̀ kàtsáró mì kùdúkùdu ɨ ró.» ");
INSERT INTO log_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Fàrìsáyò àruka adrébhá Yésu làga dhɨ ɨ̀ kòyi kúlí nda dre dhɨ, ɨ̀ dré lizízóá tíá dhɨ: «Àma tsì kókpà mì kùdúkùdu ꞌɨ?» ");
INSERT INTO log_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Dɨ Yésu logó àyɨ dré dhɨ: «Kònò mɨ̀ kàdré tá mì kùdúkùdu ꞌɨ bàti dhɨ, à kɨtswá tá tà bha àmɨ dri àmɨ kɨ tàkonzɨ̀ kɨ tà sè ko. Dɨ, mɨ̀ dré adrélé tàle dhɨ mɨ̀ adré ngá no dhɨ sè dhɨ, àmɨ kɨ tàkonzɨ̀ ɨ dhu rè àmɨ dri be.» ");
INSERT INTO log_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yésu gò tàá dhɨ: «Má adré tà bàti ta àmɨ dré: Dhya adrélépi fɨ̀le kábilígyà kɨ gɨ́rɨ́ na ti nɨ ꞌásè ko, dɨ, adrélépi ɨ́na fɨ̀le láti twá ꞌásè dhɨ, akódhɨ nda kùgú ꞌɨ, ɨ̀ndɨ̀ ngá kärílépi ꞌɨ. ");
INSERT INTO log_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Dɨ, dhya adrélépi fɨ̀le gɨ́rɨ́ nda nɨ ti ꞌásè dhɨ, kábilígyà lɨkɨ́lépi ꞌɨ. ");
INSERT INTO log_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Gɨ́rɨ́ nɨ ti lɨkɨ́lépi adré ti nda nɨ nzi akódhɨ dré gò, kábilígyà ɨ̀ dré adrézó akódhɨ nɨ kúlí yi. Akódhɨ adré áyɨ tàndɨ nɨ kábilígyà kɨ azí àyɨ kɨ rú sè gò, adrézó àyɨ kɨ dri pfòzo àyɨ ɨ́be kɨvɨ̀ na. ");
INSERT INTO log_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Kòꞌo àyɨ pfòle títí dre dhɨ, adré dhèle àyɨ kandrá. Gò kábilígyà nda ɨ̀ dré adrézó lɨ̀le vásà, ɨ̀ dré kúlí nɨ nɨ nìle be dhɨ sè. ");
INSERT INTO log_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Dɨ, kábilígyà nda ɨ̀ kɨtswá tàdzí lɨ̀le móndɨ́ twá ɨ̀ dré nìle ko dhɨ vésè ko. Be ró dhɨ, ɨ̀ nɨ lapá ràle akódhɨ nda kandrásè, ɨ̀ dré kúlí nɨ nɨ nìle ko dhɨ sè.» ");
INSERT INTO log_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yésu tà tá tà nda àyɨ dré kúlí alaala sè. Dɨ, tà dré adrélé tàle nda kɨ àndu fɨ ɨ́na àyɨ drìna ko. ");
INSERT INTO log_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Dɨ Yésu dré gòzo tàá dhɨ: «Má adré tà bàti ta àmɨ dré: Ma gɨ́rɨ́ti kábilígyà ɨ dré dhɨ ꞌɨ. ");
INSERT INTO log_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Móndyá wä́yi alɨ̀bhá drìdrì má kandrá dhɨ ɨ tá kùgubhá ꞌɨ, ɨ̀ndɨ̀ kä́ribhá ꞌɨ. Dɨ, kábilígyà nda ɨ̀ yi tá àyɨ ko. ");
INSERT INTO log_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ma gɨ́rɨ́ti ꞌɨ. Dhya ángùdhi adrélépi afɨ́lé má ꞌásè dhɨ nɨ adrɨ́. Akódhɨ nda nɨ adré afɨ́lé, adrélé pfòle, adrélé kpà ngá kisú nyàle. ");
INSERT INTO log_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Kùgú adré ngbà ꞌí alɨ̀le kɨtswálé ngá kugù, kɨtswálé móndɨ́ kɨ tupfú todràle, ɨ̀ndɨ̀ kɨtswálé tà kɨzá. Dɨ, má alɨ̀ mána móndɨ́ ɨ̀ kàdréró lɨ́drɨ̀ ɨ́be, ɨ̀ndɨ̀ lɨ́drɨ̀ nda kògaró àyɨ léna gagà. ");
INSERT INTO log_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ma kábilígyà lɨkɨ́lépi dóro dhɨ ꞌɨ. Kábilígyà lɨkɨ́lépi dóro nda adré áyɨ lɨ́drɨ̀ fe áyɨ kábilígyà ɨ dré. ");
INSERT INTO log_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Dɨ, kàdré dhya adrélépi ngbà ꞌí àzí ꞌo làfa sè dhɨ nɨ tà sè dhɨ, akódhɨ nda kábilígyà lɨkɨ́lépi ꞌɨ bàti ko. Kábilígyà nda ɨ kpà akódhɨ nɨ tàndɨ àdhya ꞌɨ ko. Akódhɨ kònò kàlagɨ́ adréràꞌa alɨ̀le dhɨ, adré ɨ́na kábilígyà nda kɨ tayɨ́ lapázó. Gò kàlagɨ́ nda dré adrézó kábilígyà nda kɨ turú, adrézó àyɨ kɨ lapé. ");
INSERT INTO log_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Dhya nda adré lapálé, dré adrélé ngbà ꞌí àzí ꞌo làfa sè dhɨ sè, ɨ̀ndɨ̀ dré adrélé kábilígyà nda kɨ tà kisù ko dhɨ sè. ");
INSERT INTO log_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Ma kábilígyà lɨkɨ́lépi dóro dhɨ ꞌɨ. Má nì áma kábilígyà ɨ be, ɨ̀ndɨ̀ áma kábilígyà nda ɨ̀ nì kpà ma be, ");
INSERT INTO log_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ngóró áma Atá dré áma nìle be dhɨ tɨ́nɨ, ɨ̀ndɨ̀ má dré kpà áma Atá nɨ nìle be dhɨ tɨ́nɨ. Má adré áma lɨ́drɨ̀ fe áma kábilígyà nda ɨ dré. ");
INSERT INTO log_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ma kókpà kábilígyà àruka adrébhá gɨ́rɨ́ kònɨ̀dhɨ ꞌá ko dhɨ ɨ́be. Adré lèá dhɨ, má kàdrì àyɨ nda ɨ afɨ́zó àyɨ ɨ́be be. Ɨ̀ nɨ kpà áma kúlí yi gò, kábilígyà títí nda ɨ̀ dré adrézó pä̀rí àlo ró, àyɨ kɨ lɨkɨ́lépi dré kpà adrézó àlo kwákwá. ");
INSERT INTO log_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Áma Atá adré áma le tò, má dré adrélé áma lɨ́drɨ̀ fe kɨtswázó gòle dòá tódhyá dhɨ sè. ");
INSERT INTO log_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Dhya àlo kɨtswá áma lɨ́drɨ̀ tɨngá bwà ko. Dɨ, má adré mána fèá ngóró má dré adrélé lèle ꞌòle dhɨ tɨ́nɨ. Ma rìnyí ɨ́be kɨtswázó fèá, ɨ̀ndɨ̀ ma kpà rìnyí ɨ́be kɨtswázó gòle dòá. Kòrɨ̀dhɨ, tòlɨ́ má dré kisúlé áma Atá vélésè dhɨ ꞌɨ.» ");
INSERT INTO log_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Yésu nɨ kúlí nda ɨ sè dhɨ, Yúdà ànzɨ ɨ̀ dré gòzo tódhyá ru lanzɨ́. ");
INSERT INTO log_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Àyɨ kɨ àruka bǐ dhɨ ɨ̀ adré tá tàá dhɨ: «Akódhɨ tɨrɨ́ kònzɨ ɨ́be ɨ́ léna! Ngá kɨzá akódhɨ nɨ drì dre! Mɨ̀ adré akódhɨ nɨ yi àdho tà sè?» ");
INSERT INTO log_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Dɨ, àruka nɨ ɨ̀ adré kó tàá dhɨ: «Dhya adrélépi tɨrɨ́ kònzɨ ɨ́be ɨ́ léna dhɨ adré ɨ́na kúlí ta kònɨ̀nɨ ko. Tɨrɨ́ kònzɨ nɨ kɨtswá tsì móndɨ́ mì kùdúkùdu ró dhɨ kɨ mì nzi bwà?» ");
INSERT INTO log_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Lókyá kɨdhɨ̀ àdhya sè dhɨ, Yúdà ànzɨ ɨ̀ adré tá gwányá adrézó tépelò nɨ bhàma twá Gìká dré dhɨ nɨ tà kisù dhɨ nɨ ꞌo Yèrúsalémà na. ");
INSERT INTO log_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Dɨ Yésu dré tá adréràꞌa atsílé tépelò nɨ kògbo zìle Sòlòmónò àdhya ró dhɨ ꞌásè dhɨ ꞌá dhɨ, ");
INSERT INTO log_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Yúdà ànzɨ ɨ̀ dré ru kɨmózó akódhɨ làgásè kúrú gò, tàá drá dhɨ: «Mɨ́ nɨ tà kòdhɨ nɨ losó vwàle lókyá be ángopɨ́? Mɨ́ kàdré Mèsɨ́yà ꞌɨ bàti dhɨ, mɨ́ tà rè àma dré ngádra ꞌá ká.» ");
INSERT INTO log_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Dɨ Yésu logó àyɨ dré dhɨ: «Má tà tá tà nda àmɨ dré dre. Dɨ, mɨ̀ kaꞌì àmɨkya ma ko. Tà lɨ́ndrɨ́ga ró má dré adrélé ꞌòle áma Atá nɨ rú sè dhɨ ɨ̀ adré tadhá ngádra ꞌá dhɨ, ma àdhi ꞌɨ ya dhɨ nɨ̀. ");
INSERT INTO log_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Dɨ, mɨ̀ kaꞌì àmɨkya ma ko, mɨ̀ dré adrélé áma kábilígyà ꞌɨ ko dhɨ sè. ");
INSERT INTO log_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Áma kábilígyà ɨ̀ adré áma kúlí yi. Má nì kpà àyɨ be gò, ɨ̀ dré adrézó áma lebè. ");
INSERT INTO log_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Má adré lɨ́drɨ̀ kóná vésè kólyá dhɨ nɨ fe àyɨ dré gò, ɨ̀ dré kɨtswázó tàdzí dràle ko. Dhya àlo kɨtswá kpà àyɨ kɨ topá má drɨ́gásè bwà ko. ");
INSERT INTO log_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Áma Atá àyɨ kɨ afèlepi má dré dhɨ kàdrɨ̀ ngá wä́yi dhɨ kɨ lavú. Dɨ dhya àlo kɨtswá àyɨ kɨ topá áma Atá nda drɨ́gásè bwà ko. ");
INSERT INTO log_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Àma áma Atá be dhɨ ɨ àlo ꞌɨ.» ");
INSERT INTO log_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Gò Yúdà ànzɨ nda ɨ̀ dré gòzo tódhyá kɨ́rà kudhú kɨtswázó Yésu nɨ lebhé dràle ásà. ");
INSERT INTO log_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Dɨ Yésu dré tàzoá àyɨ dré dhɨ: «Má ꞌo tà lɨ́ndrɨ́ga ró dóro bǐ angábhá áma Atá vélésè dhɨ ɨ àmɨ dré nòle dhɨ ꞌí. Dɨ tà nda ɨ kòfalé dhɨ, mɨ̀ adré ꞌòle áma lebhé kɨ́rà sè tà ángùdhi sè?» ");
INSERT INTO log_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Dɨ Yúdà ànzɨ nda ɨ̀ logó drá dhɨ: «Mà adré ámɨ lebhé kɨ́rà sè tà dóro nda kɨ àlo sè ko. Be ró dhɨ, mà adré àmakya ámɨ lebhé kɨ́rà sè, mɨ́ dré adrélé Gìká nɨ lodhá dhɨ sè. Àngyá ko, mɨ móndɨ́ ro nɨ, mɨ́ adré mɨ́na ámɨ ꞌo adrélé Gìká ro!» ");
INSERT INTO log_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Dɨ Yésu logó àyɨ dré dhɨ: «À tɨsɨ̀ zakó tsì àmɨ kɨ tátrɨ́trɨ́ kúlí na dhɨ, Gìká tà tá dhɨ: ‹Àmɨ gìká ꞌɨ!› ");
INSERT INTO log_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Mà nì tàle dhɨ, à kɨtswá tà àlo tɨsɨ̀le Gìká nɨ Kúlí na dhɨ nɨ bhe gàrà dri bwà ko dhɨ be. Dɨ Gìká kòzi kó móndyá áyɨ Kúlí kisúbhá dhɨ ɨ gìká ɨ ró dhɨ, ");
INSERT INTO log_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","mɨ̀ adré dɨ àmɨkya tàá dhɨ, má adré Gìká nɨ lodhá, má dré tàle dhɨ ma Gìká nɨ Mváagó ꞌɨ dhɨ sè dhɨ ngɨ́nɨ? Tà bàti ró dhɨ, Gìká Atá nda bhà ma twá adrélé ɨ́na ró gò, áma amùzo bvò kònɨ̀dhɨ lé dhɨ nɨ̀. ");
INSERT INTO log_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Má kàdré tà áma Atá dré adrélé ꞌòle dhɨ kɨ ꞌo kòdhya ko dhɨ, mɨ̀ kòkaꞌì ma ko. ");
INSERT INTO log_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Dɨ, má kàdré tà nda kɨ ꞌo ꞌí dhɨ, gba mɨ̀ kàdré áma kaꞌì ko yà dhɨ, mɨ̀ kàdré tà lɨ́ndrɨ́ga ró má dré adrélé ꞌòle nda kɨ kaꞌì kòdhya, mɨ̀ kònìró tàle dhɨ, áma Atá má léna, ɨ̀ndɨ̀ ma áma Atá léna dhɨ be.» ");
INSERT INTO log_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Dɨ ɨ̀ dré gòzo adrélé láti nda kɨtswázó akódhɨ nɨ ru. Dɨ, akódhɨ dré ɨ́na ngàzo pfòle lyà àyɨ kòfalésè. ");
INSERT INTO log_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Àmvolásà dhɨ, Yésu dré gòzo lɨ̀le zyàle Yòròdánè nɨ taꞌá na, àrà Yòwánɨ̀ dré tá adrézó bàtísimò fe drìdrì dhɨ na. Dré adrézó kònàle gìle lókyá be vwàvwà ro tsà gò, ");
INSERT INTO log_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","móndɨ́ zyandre dhɨ ɨ̀ dré alɨ̀zo akódhɨ vélé. Ɨ̀ adré tá tàá dhɨ: «Yòwánɨ̀ ꞌo tá ɨ́na tà àlo lɨ́ndrɨ́ga ró dhɨ ko. Dɨ, tà títí dré tá tàle agó kòdhɨ nɨ tà dri dhɨ ɨ tá tà bàti ꞌɨ.» ");
INSERT INTO log_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Dɨ móndɨ́ zyandre dhɨ ɨ̀ dré Yésu nɨ kaꞌìzo kònàle. ");
INSERT INTO log_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Agó àlo rú be Làzárò dhɨ tá drà ro Bètànɨ́yà na. Bètànɨ́yà nda tá kpà bhà akódhɨ nɨ amvúpi ɨ, Màrɨ́yà ɨ Màrátà be dhɨ kya ꞌɨ. ");
INSERT INTO log_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Màrɨ́yà nda kòdhɨ tá tòkó màlásɨ̀ dàlepi Mírì Yésu pá gò, pá nɨ kɨ atrìzo áyɨ drìbhɨ́ sè dhɨ ꞌɨ. Dɨ adrúpi nɨ, Làzárò nda tá drà ro. ");
INSERT INTO log_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Gò akódhɨ nɨ amvúpi rì nda ɨ̀ dré móndɨ́ mùzo lɨ̀le tàá Yésu dré dhɨ: «Mírì, ámɨ arúpi mɨ́ dré lèle tò dhɨ drà ro.» ");
INSERT INTO log_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yésu kòyi rúbí nda dre dhɨ, dré tàzoá dhɨ: «Làzárò nɨ drà kòdhɨ kɨtswá akódhɨ nɨ ꞌo dràle nyo ko. Be ró dhɨ, drà nda atsá ɨ́na akódhɨ rú Gìká kòkisúró mìlanzìlanzì ásà, ɨ̀ndɨ̀ kòbhàró kpà áyɨ Mváagó nɨ mì lanzìle ásà be dhɨ bvó.» ");
INSERT INTO log_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yésu lè tá Màrátà ɨ, amvúpi nɨ Màrɨ́yà be, ɨ̀ndɨ̀ Làzárò be tò. ");
INSERT INTO log_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Dɨ, kòyi tàle dhɨ, Làzárò nda tá drà ro dhɨ dre dhɨ, dré gòzo ɨ́na adrélé àrà ɨ́ dré tá adrézó dhɨ na kìtú rì. ");
INSERT INTO log_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Gò dré tàzoá áyɨ lebèbhá ɨ dré dhɨ: «Mà kògò lɨ̀le Yùdáyà na.» ");
INSERT INTO log_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Dɨ, akódhɨ nɨ lebèbhá nda ɨ̀ tà drá dhɨ: «Rábbì, gí dhu rè ko, Yúdà ànzɨ ɨ̀ dré tá adrézó láti nda kɨtswázó ámɨ lebhé dràle kɨ́rà sè dhɨ. Dɨ, mɨ́ adré mɨ́na ꞌòle gòle kònàle?» ");
INSERT INTO log_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yésu logó àyɨ dré dhɨ: «Kìtú adré kàle sáà mudrí-drì-rì ko? Dhya ángùdhi adrélépi atsílé kìtú sè dhɨ adré dhèle ko, dré adrélé ngádra bvò kòndɨ àdhya nɨ no dhɨ sè. ");
INSERT INTO log_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Dɨ, kàdré ɨ́na atsílé ngátsi sè dhɨ, adré dhèle, dré adrélé ngádra àko ɨ́ léna dhɨ sè.» ");
INSERT INTO log_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Kòtà tà nda dre dhɨ, dré gòzo tàá àyɨ dré dhɨ: «Àma kɨ arúpi Làzárò ko ayí dre. Dɨ, má adré mána lɨ̀le akódhɨ nɨ toró.» ");
INSERT INTO log_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Dɨ lebèbhá nɨ ɨ̀ tà drá dhɨ: «Mírì, akódhɨ kàdré ayí ko dhɨ, a nɨ adrɨ́.» ");
INSERT INTO log_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ɨ̀ adré tá àyɨkya kisùá dhɨ, Yésu adré tá Làzárò nɨ ayí kòma nɨ tà ta kòdhya. Tákò, Yésu adré tá ɨ́na akódhɨ nɨ dràma nɨ tà ta kòdhya. ");
INSERT INTO log_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Dɨ Yésu dré tàzoá àyɨ dré ngádra ꞌá dhɨ: «Làzárò drà dre. ");
INSERT INTO log_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Dɨ àmɨ kɨ tà sè dhɨ, má adré lenzélé má dré tá adrélé kònàle yó dhɨ sè, mɨ̀ kòkɨtswáró áma kaꞌì bàti be dhɨ bvó. Mà kòlɨ̀ dɨ akódhɨ véna.» ");
INSERT INTO log_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Dɨ Tòmá, adrélé kpà rú zìle Làtí dhɨ dré tàzoá Yésu nɨ lebèbhá àruka títí dhɨ ɨ dré dhɨ: «Mà kòlɨ̀ kókpà be, mà kòdràró túmä́ní akódhɨ be!» ");
INSERT INTO log_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yésu kòtsa Bètànɨ́yà na dre dhɨ, dré yìzoá tàle dhɨ, à bhà tá Làzárò ayílé mógó na kìtú su dre. ");
INSERT INTO log_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bètànɨ́yà nda tá ànyɨ Yèrúsalémà làga, ànyɨ́ànyɨ kìlòméterè na. ");
INSERT INTO log_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Dɨ Yúdà ànzɨ bǐ dhɨ ɨ̀ alɨ̀ tá Màrátà ɨ vélé Màrɨ́yà be, kɨtswálé àyɨ kɨ togó tɨndrɨ̀ àyɨ kɨ adrúpi nɨ dràdrà nɨ tà sè. ");
INSERT INTO log_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Dɨ Màrátà kòyi tàle dhɨ, Yésu adré tá alɨ̀le dhɨ dre dhɨ, dré ngàzo lɨ̀le ru kisú ába. Dɨ, Màrɨ́yà lɨrɨ́ tá ɨ́na adrélé dzó na. ");
INSERT INTO log_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Màrátà dré tàzoá Yésu dré dhɨ: «Mírì, kònò mɨ́ kàdré tá kònwa be dhɨ, áma adrúpi kɨtswá tá dràle ko! ");
INSERT INTO log_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Dɨ, ndɨ̀ndɨ̀ nyànomvá dhɨ, má nì tàle dhɨ, Gìká nɨ tà ángùdhi mɨ́ dré dra zìle ɨ́ tí dhɨ nɨ fe mɨ́ dré dhɨ be.» ");
INSERT INTO log_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yésu tà drá dhɨ: «Ámɨ adrúpi nɨ angá dràdrà lésè.» ");
INSERT INTO log_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Dɨ Màrátà logó drá dhɨ: «Má nì tàle dhɨ, a nɨ nga dràdrà ꞌásè kìtú kùdù móndɨ́ ɨ̀ dré dra ngàzo dràdrà ꞌásè dhɨ tú dhɨ be.» ");
INSERT INTO log_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Dɨ Yésu tà drá dhɨ: «Ma dhya adrélépi móndɨ́ kɨ tɨngá dràdrà lésè dhɨ ꞌɨ, ɨ̀ndɨ̀ dhya adrélépi lɨ́drɨ̀ fe àyɨ dré dhɨ ꞌɨ. Dhya ángùdhi adrélépi áma kaꞌì dhɨ, tágba kòdrà yà dhɨ, a nɨ adrɨ́. ");
INSERT INTO log_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Kòdhɨ ɨ́be dhɨ, dhya ángùdhi adrélépi lɨ́drɨ̀ ɨ́be ɨ̀ndɨ̀ adrélépi áma kaꞌì dhɨ, kɨtswá tàdzí dràle kóná vésè kólyá ko. Mɨ́ kaꞌì tà kòdhɨ vélé?» ");
INSERT INTO log_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Dɨ Màrátà logó drá dhɨ: «Àyíya, Mírì, má adré kaꞌìá dhɨ, mɨ Mèsɨ́yà ꞌɨ, Gìká nɨ Mváagó ꞌɨ, ɨ̀ndɨ̀ dhya adrélépi tá alɨ̀le bvò le dhɨ ꞌɨ.» ");
INSERT INTO log_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Màrátà kòtà tà nda dre dhɨ, dré ngàzo lɨ̀le áyɨ amvúpi Màrɨ́yà nɨ azí gò, tàzoá drá kòyàyà sè dhɨ: «Dhya tà tadhálépi dhɨ kònwánò. Adré ámɨ zi.» ");
INSERT INTO log_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Màrɨ́yà kòyi rúbí nda dre dhɨ, dré ngàzo mbèlè lɨ̀le Yésu véna. ");
INSERT INTO log_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yésu fɨ tá rè bhà nda na ko. Dɨ, adré tá dhu rè àrà ɨ̀ dré ru kisúzó Màrátà be dhɨ na. ");
INSERT INTO log_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Dɨ Yúdà ànzɨ adrébhá tá Màrɨ́yà làga dzó na adrélé akódhɨ nɨ togó tɨndrɨ̀ nda, ɨ̀ kònò akódhɨ ngaràꞌa pfòle mbèlè dre dhɨ, ɨ̀ dré kpà ngàzo akódhɨ nɨ lebè. Ɨ̀ adré tá àyɨkya kisùá dhɨ, adré lɨ̀le ngòle mógó drìna. ");
INSERT INTO log_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Màrɨ́yà kòtsa àrà Yésu dré tá adrézó dhɨ na akódhɨ nɨ no dre dhɨ, dré dhèzo akódhɨ pá gò, tàá drá dhɨ: «Mírì, kònò mɨ́ kàdré tá kònwa be dhɨ, áma adrúpi kɨtswá tá dràle ko!» ");
INSERT INTO log_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Dɨ Yésu kònò Màrɨ́yà nda ɨ adréràꞌa ngòle túmä́ní Yúdà ànzɨ alɨ̀bhá ába dhɨ ɨ́be dre dhɨ, akódhɨ nɨ togó dré ŋòzo, adrélé lanzìle tò. ");
INSERT INTO log_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Dré lizízóá dhɨ: «Mɨ̀ bhà akódhɨ nɨ rúbhá ángwà?» Ɨ̀ logó drá dhɨ: «Mírì, mɨ́ alɨ̀ nòá.» ");
INSERT INTO log_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yésu dré ngòzo. ");
INSERT INTO log_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Dɨ Yúdà ànzɨ nda ɨ̀ dré tàzoá dhɨ: «Mɨ̀ nò rè dré akódhɨ nɨ lèle ngɨ́nɨ ya dhɨ ká!» ");
INSERT INTO log_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Dɨ, móndɨ́ àruka àyɨ kòfalé dhɨ ɨ̀ dré tàzoá dhɨ: «Dhya kòdhɨ nzì tá kó agó mì kùdúkùdu ró dhɨ nɨ mì ꞌí dhɨ, kɨtswá tá tsì tà ꞌo Làzárò dré dràzo ko dhɨ bwà ko?» ");
INSERT INTO log_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yésu nɨ togó dré gòzo tódhyá ŋòle gò, dré lɨ̀zo tsàle mógó na. Mógó nda tá gǒ ꞌɨ. À alɨ́ tá kɨ́rà kàdrɨ̀ bhàle tíá. ");
INSERT INTO log_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Dɨ Yésu dré tàzoá dhɨ: «Mɨ̀ zɨ kɨ́rà tíásà.» Dɨ, Màrátà, dhya dràlepi nda nɨ amvúpi tà drá dhɨ: «Mírì, kòndɨ tàdzí nɨ vélé tò. Àngyá ko, akódhɨ ayí mógó na kìtú su dre!» ");
INSERT INTO log_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yésu logó drá dhɨ: «Má tà tá mɨ́ dré dhɨ, mɨ́ kòkaꞌì dhɨ, mɨ́ nɨ Gìká nɨ mìlanzìlanzì no dhɨ ko?» ");
INSERT INTO log_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Dɨ ɨ̀ dré kɨ́rà nda nɨ zɨ̀zo. Gò Yésu dré mì tɨngázó kurú na, tàzoá dhɨ: «Tátá, má adré àwoyà ta mɨ́ dré, mɨ́ dré áma yìle dre dhɨ sè. ");
INSERT INTO log_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Má nì, mɨ́ adré ngbú adrélé áma yi dhɨ be. Dɨ, má tà mána tà kòdhɨ móndyá zyandre má làga kònɨ kɨ tà sè, ɨ̀ kòkɨtswáró kaꞌìá dhɨ, mɨ́ amù ma mɨ.» ");
INSERT INTO log_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Kòtà tà nda dre dhɨ, dré ngàzo kúlí yo tàzoá dhɨ: «Làzárò, mɨ́ apfò kònalésè!» ");
INSERT INTO log_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Dɨ dhya tá dràlepi nda dré ngàzo apfòle. À lambé tá drɨ́gá nɨ ɨ, pá nɨ ɨ́be kɨ́tá kàtswákàtswa dhɨ ɨ sè, drì nɨ nɨ lambézó kɨ́tá àzya sè. Dɨ Yésu dré tàzoá àyɨ dré dhɨ: «Mɨ̀ trɨ akódhɨ, tayɨ́zóá lɨ̀le.» ");
INSERT INTO log_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Dɨ Yúdà ànzɨ alɨ̀bhá tá Màrɨ́yà vélé nda ɨ̀ kònò tà Yésu dré ꞌòle nda dre dhɨ, àyɨ kɨ àruka bǐ dhɨ ɨ̀ dré akódhɨ nɨ kaꞌìzo. ");
INSERT INTO log_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Dɨ, àruka nɨ ɨ̀ dré àyɨkya lɨ̀zo Fàrìsáyò ɨ véna, tà Yésu dré ꞌòle nda nɨ tɨtɨ́ àyɨ dré. ");
INSERT INTO log_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Gò kòwánà kàdrɨ̀ ɨ Fàrìsáyò ɨ́be dhɨ ɨ̀ dré bhàgo kàdrɨ̀ kɨ kɨmózó títí gò, ɨ̀ dré tàzoá dhɨ: «Mà nɨ̀ ꞌòá ngɨ́nɨ? Tàko ko, agó kòdhɨ adré vélé tà lɨ́ndrɨ́ga ró dhɨ kɨ ꞌo bǐ! ");
INSERT INTO log_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Mà kòtayɨ́ akódhɨ adrélé tà ꞌo kònɨ̀nɨ dhɨ, móndyá wä́yi dhɨ kɨ akódhɨ nɨ kaꞌì. Dɨ Rómà kɨ kàdrɨ̀ kɨ àma kɨ tépelò ꞌo pfùle, túmä́ní àma kɨ súrú ɨ́be.» ");
INSERT INTO log_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Dɨ, àyɨ kɨ àlo rú be Kàyáfà, adrélépi tá kòwánà kɨ kàdrɨ̀ ro kóná kònàdhɨ sè dhɨ, dré ngàzo tàá àyɨ dré dhɨ: «Àmɨ, mɨ̀ nì àmɨkya tà àlo ko! ");
INSERT INTO log_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Mɨ̀ nì ko tàle dhɨ, dóro nɨ àmɨ dré dhɨ, dhya àlo dré dràle móndyá wä́yi ɨ dré dhɨ, àmɨ kɨ súrú wä́yi dhɨ kòdràró nyo ko dhɨ?» ");
INSERT INTO log_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Akódhɨ tà tá tà nda áyɨ drì sè ko. Dɨ, dré tá adrélé kòwánà kɨ kàdrɨ̀ ro kóná nda sè dhɨ sè dhɨ, longó tá ɨ́na tà nda pròfétà àdhya tɨ́nɨ tàzoá dhɨ, Yésu nɨ dra Yúdà ànzɨ kɨ súrú nɨ tà sè. ");
INSERT INTO log_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Dɨ, kɨtswá tá ngbà ꞌí dràle súrú nda nɨ tà sè ko, a nɨ kókpà dra kɨtswálé Gìká nɨ ànzɨ ayɨ́bhá àrà títí ɨ ꞌásè dhɨ kɨ kɨmó adrélé súrú àlo ró. ");
INSERT INTO log_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Dɨ kɨdhólé kìtú nda sè dhɨ, Yúdà ànzɨ kɨ kàdrɨ̀ nda ɨ̀ dré ru yìzo kɨtswázó Yésu nɨ pfu dràle. ");
INSERT INTO log_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Dɨ ásà dhɨ, Yésu dré gòzo vélé adrélé atsílé Yúdà ànzɨ ɨ kòfalésè ngádra ꞌásè ko. Dɨ, dré ɨ́na lɨ̀zo àrà ànyɨ duku làga dhɨ na, bhàandre rú zìle Èfàràyɨ́mà dhɨ na gò, ɨ̀ dré adrézó kònàle túmä́ní lebèbhá nɨ ɨ́be. ");
INSERT INTO log_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Yúdà ànzɨ kɨ gwányá Pásɨkà àdhya kàtsá ànyɨ dre dhɨ, móndɨ́ zyandre dhɨ ɨ̀ dré ngàzo gbàbhú lésè lɨ̀le Yèrúsalémà na, kɨtswálé àyɨ kɨ temvé drìdrì gwányá nda kandrá. ");
INSERT INTO log_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Dɨ ɨ̀ adré tá Yésu nɨ nda, adrézó tàá àyɨ kòfalésè tépelò na dhɨ: «Mɨ̀ kisù ngɨ́nɨ? Akódhɨ kɨtswá tsì alɨ̀le gwányá lé ko?» ");
INSERT INTO log_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Dɨ, kòwánà kàdrɨ̀ ɨ Fàrìsáyò ɨ́be dhɨ ɨ̀ fè tá tòlɨ́ tàzoá dhɨ, dhya àlo kònì àrà Yésu dré tá adrézó lána dhɨ be dhɨ, kòtadhá àrà nda àyɨ dré, ɨ̀ kòkɨtswáró akódhɨ nɨ ru be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Tayɨ́ tá kìtú nzi-drì-àlo gwányá Pásɨkà àdhya kandrá gò, Yésu dré lɨ̀zo Bètànɨ́yà na, bhà Làzárò àdhya na. Làzárò nda tá dhya Yésu dré tɨngálé dràdrà lésè dhɨ ꞌɨ. ");
INSERT INTO log_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Dɨ kònàle dhɨ, à dré ngá ladhɨ́zó Yésu dré nyàle. Màrátà adré tá ngá bha móndɨ́ ɨ kandrá. Làzárò tá kpà móndyá lɨrɨ́bhá mɨ́sá làgásè túmä́ní Yésu be dhɨ ɨ kòfalé. ");
INSERT INTO log_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Dɨ Màrɨ́yà dré màlásɨ̀ làgɨ́ kyàkyà ladhɨ́lé tsèrèlè náradà sè dhɨ nɨ adózó, alɨ̀zo ába líterè àlo nɨ kɨ́tógá ꞌásè. Dré màlásɨ̀ nda nɨ dàzo Yésu pá gò, pá nɨ kɨ atrìzo áyɨ drìbhɨ́ sè. Gò màlásɨ̀ nda nɨ tàdzí dré dzó nda nɨ ꞌa dòzo wä́yi. ");
INSERT INTO log_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Dɨ Yùdásɨ̀ Ɨ̀sɨ̀kàrɨ̀yótà, Yésu nɨ lebèbhá kɨ àlo tá kpà kònàle. Akódhɨ nda tá dhya adrélépi ꞌòle Yésu nɨ lefè kàrɨbhá ɨ drɨ́gá dhɨ ꞌɨ. Dɨ kònò tà Màrɨ́yà dré ꞌòle nda dre dhɨ, dré ɨ́na tàzoá dhɨ: ");
INSERT INTO log_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«À kɨtswá tá màlásɨ̀ kòdhɨ nɨ lagɨ́, làfa nɨ nɨ fèzo lemerèbhá ɨ dré ko àdho tà sè? À nɨ tá kɨtswá làfa lòꞌwa kámá-na dhɨ kɨ kisú ásà.» ");
INSERT INTO log_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Tà tá kònɨ̀nɨ dré tá adrélé lemerèbhá kɨ tà kisù dhɨ sè ko. Be ró dhɨ, tà ɨ́na tà nda dré tá adrélé kùgú ꞌɨ dhɨ sè. Tàko ko, akódhɨ tá dhya adrélépi kòmvò adrézó làfa bha lána dhɨ nɨ lɨkɨ́ dhɨ ꞌɨ. Dɨ, adré tá ɨ́na ngá bhàle lána dhɨ nɨ do áyɨ tàndɨ dré. ");
INSERT INTO log_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Gò Yésu dré tàzoá drá dhɨ: «Mɨ́ tayɨ́ tòkó kònɨ̀dhɨ, kàdréró tà dré ꞌòle kòdhɨ nɨ lɨkɨ́ áyɨ togó na tsàle kìtú dra áma rúbhá bhàzo mógó na dhɨ tú! ");
INSERT INTO log_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Mɨ̀ adré ngbú adrélé lemerèbhá ɨ́be àmɨ kòfalé. Dɨ, mɨ̀ kɨtswá ngbú adrélé túmä́ní má be ko.» ");
INSERT INTO log_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Yúdà ànzɨ zyandre dhɨ ɨ̀ kòyi tàle dhɨ, Yésu tá Bètànɨ́yà na dhɨ dre dhɨ, ɨ̀ dré kpà lɨ̀zo kònàle. Ɨ̀ lɨ̀ tá ngbà ꞌí Yésu nɨ tà sè ko. Ɨ̀ lɨ̀ kókpà kɨtswálé Làzárò Yésu dré tɨngálé dràdrà lésè dhɨ nɨ no dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Dɨ kòwánà kàdrɨ̀ ɨ̀ dré kpà ru yìzo kɨtswázó Làzárò nɨ pfu dràle. ");
INSERT INTO log_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Tàko ko, akódhɨ nda nɨ tà sè dhɨ, Yúdà ànzɨ zyandre dhɨ ɨ̀ adré tá àyɨ kɨ tayɨ́, adrézó Yésu nɨ kaꞌì. ");
INSERT INTO log_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Kìtú bvóá dhɨ sè dhɨ, móndɨ́ zyandre alɨ̀bhá gwányá Pásɨkà àdhya lé nda ɨ̀ dré yìzoá tàle dhɨ, Yésu adré alɨ̀le Yèrúsalémà le. ");
INSERT INTO log_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Dɨ ɨ̀ dré mbíra bí kɨ dòzo, topfòzo ába kɨtswálé ru kisú akódhɨ be. Ɨ̀ adré tá loyóá dhɨ: «Òsánà! Tà tanɨ kàdré dhya adrélépi alɨ̀le Mírì nɨ rú sè dhɨ dri! Tà tanɨ kàdré ópɨ́ Ɨ̀sèrélè ànzɨ kya dri!» ");
INSERT INTO log_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Dɨ Yésu dré púndà mvá àlo dhɨ nɨ kisúzó gò, mbàzo lɨrɨ́lé drìá, ngóró tɨsɨ̀le Gìká nɨ Kúlí na dhɨ tɨ́nɨ: ");
INSERT INTO log_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«Mɨ, zapi Sìyónà àdhya nɨ, mɨ́ kòro ngá ko. Mɨ́ nò rè ká! Ámɨ ópɨ́ adré alɨ̀le, lɨrɨ́ ɨ́na púndà mvá dri.» ");
INSERT INTO log_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Lókyá nda sè dhɨ, tà nda kòdhɨ kɨ àndu fɨ tá dhu rè Yésu nɨ lebèbhá ɨ drìna ko. Dɨ Yésu kònga dràdrà ꞌásè fɨ̀le áyɨ mìlanzìlanzì na dre dhɨ, ɨ̀ dré nìzoá tàle dhɨ, à tɨsɨ̀ tá tà nda ɨ Yésu nɨ tà dri gò, à dré tà nda kɨ ꞌòzo akódhɨ dré dhɨ be. ");
INSERT INTO log_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Móndyá zyandre tá Yésu nɨ nobhá Làzárò nɨ azíràꞌa angálé dràdrà lésè, ɨ̀ndɨ̀ apfòle mógó lésè nda ɨ̀ adré tá tà nda nɨ tɨtɨ́. ");
INSERT INTO log_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Dɨ móndɨ́ àruka zyandre dhɨ ɨ̀ kòyi tà lɨ́ndrɨ́ga ró Yésu dré tá ꞌòle nda nɨ rúbí dre dhɨ, ɨ̀ topfò tá kɨtswálé ru kisú akódhɨ be. ");
INSERT INTO log_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Dɨ Fàrìsáyò ɨ̀ dré tàzoá àyɨ kòfalésè dhɨ: «Mɨ̀ nò rè ká! Mà kɨtswá àmakya tà àlo ꞌo bwà ko. Móndyá wä́yi bvò àdhya ɨ̀ adré lɨ̀le akódhɨ vésè!» ");
INSERT INTO log_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Móndyá alɨ̀bhá Yèrúsalémà le kɨtswálé Gìká nɨ lɨndrɨ̀ bha gwányá nda tú dhɨ ɨ kòfalé dhɨ, Gìríkì àruka ɨ tá be. ");
INSERT INTO log_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Dɨ àyɨ nda ɨ̀ dré alɨ̀zo Fìlípò angálépi tá Bètèsàyɨ́dà, Gàlìláyà le dhɨ lésè dhɨ vélé gò, lizíá tíá dhɨ: «Atálágó, mà adré Yésu nɨ le nòle.» ");
INSERT INTO log_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Dɨ Fìlípò dré lɨ̀zo tà nda nɨ ta Àndréyà dré gò, ɨ̀ dré lɨ̀zo rìti tàá Yésu dré. ");
INSERT INTO log_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yésu dré logózóá àyɨ dré dhɨ: «Lókyá Móndɨ́ nɨ Mvá dré dra mìlanzìlanzì kisúzó dhɨ kɨtswá dre. ");
INSERT INTO log_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Má adré tà bàti ta àmɨ dré: Ngánò lòꞌwa kòdhe dràle kìní na ko dhɨ, a nɨ ngbú adré kalóma. Dɨ, lòꞌwa nda kòdhe ɨ́na dràle dhɨ, a nɨ lòꞌwa àruka kɨ ꞌa bǐ. ");
INSERT INTO log_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Dhya ángùdhi adrélépi tròle áyɨ tàndɨ nɨ lɨ́drɨ̀ rú dhɨ, a nɨ áyɨ lɨ́drɨ̀ nda nɨ ꞌo avɨ̀le. Dɨ, dhya adrélépi áyɨ lɨ́drɨ̀ bvò kòndɨ dri dhɨ nɨ ga dhɨ, a nɨ áyɨ lɨ́drɨ̀ nda nɨ lɨkɨ́ adrélé kóná vésè kólyá. ");
INSERT INTO log_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Dhya ángùdhi adrélépi áma tà le ꞌòle áma màrábà tɨ́nɨ dhɨ, lè akódhɨ nda kàdré áma lebè. Àrà ángùdhi má dré adrézó lána dhɨ na dhɨ, áma màrábà nda nɨ adré kókpà be. Dɨ áma Atá nɨ lɨndrɨ̀ fe dhya adrélépi áma tà ꞌo nda dré. ");
INSERT INTO log_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Nyànomvá dhɨ, áma togó adré lanzìle tò. Dɨ má nɨ tàá ngɨ́nɨ? Má nɨ tsì tàá dhɨ, ‹Tátá, mɨ́ tɨdrɨ́ ma lókyá kɨzà àdhya kònɨ̀dhɨ sè› dhɨ? Kóko, má atsá mána kɨtswálé kɨzà nya lókyá kònɨ̀dhɨ sè. ");
INSERT INTO log_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tátá, mɨ́ kòbhà ámɨ rú kùle wà!» Yésu kòtà tà nda dre dhɨ, kúlí dré apfòzo bhù lésè tàá dhɨ: «Má bhà áma rú kùle dre. Má nɨ kpà go tódhyá rú nda nɨ bha kùle.» ");
INSERT INTO log_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Dɨ móndyá zyandre adrébhá tá kònàle dhɨ ɨ̀ kòyi kúlí nda dre dhɨ, ɨ̀ dré adrézó tàá dhɨ: «Kòdhɨ bhù tadí nɨ̀!» Àruka nɨ ɨ̀ adré kó tàá dhɨ: «Ángéló àlo dhɨ tà tà drá nɨ̀!» ");
INSERT INTO log_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Dɨ, Yésu dré tàzoá àyɨ dré dhɨ: «Kúlí kòdhɨ apfò áma tà sè ko. Dɨ, apfò ɨ́na àmɨ kɨ tà sè. ");
INSERT INTO log_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Nyànomvá kònɨ̀dhɨ, lókyá bvò kònɨ̀dhɨ nɨ tàbvó tàzo dhɨ ꞌɨ. Nyànomvá dhɨ, à nɨ ópɨ́ bvò kòndɨ àdhya nɨ dro pfòle. ");
INSERT INTO log_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Dɨ ma ró dhɨ, à kòtɨngá ma kurú na bvò ꞌásè dre dhɨ, má nɨ móndyá wä́yi dhɨ kɨ asé má vélé.» ");
INSERT INTO log_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yésu tà tá tà nda tadházóá dhɨ, ɨ́ nɨ dra dràdrà kárá ángùdhi sè ya dhɨ. ");
INSERT INTO log_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Dɨ móndyá zyandre nda ɨ̀ logó drá dhɨ: «Mà yi tàle dhɨ, tátrɨ́trɨ́ kúlí adré tàá dhɨ, Mèsɨ́yà nɨ adré kóná vésè kólyá dhɨ ꞌí. Mɨ́ adré dɨ mɨ́na tàá dhɨ, lè à kòtɨngá Móndɨ́ nɨ Mvá bvò ꞌásè dhɨ ngɨ́nɨ? Móndɨ́ nɨ Mvá nda àdhi ɨ?» ");
INSERT INTO log_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Dɨ Yésu gò tàá àyɨ dré dhɨ: «Àmɨ dhu rè ngádra ɨ́be àmɨ kòfalé dhɨ lókyá tsà sè. Lè mɨ̀ kàdré atsílé mɨ̀ dré adréràꞌa ngádra nda ɨ́be dhɨ ꞌá, tínímvá kòkɨró àmɨ ko dhɨ bvó. Àngyá ko, dhya adrélépi atsílé tínímvá na dhɨ nì ɨ́na ngalè ɨ́ adré lɨ̀le ángolé ya dhɨ ko. ");
INSERT INTO log_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Mɨ̀ dré adréràꞌa ngádra ɨ́be dhɨ ꞌá dhɨ, mɨ̀ kàdré ngádra nda nɨ kaꞌì, mɨ̀ kàtsáró ànzɨ ngádra àdhya ɨ ró be dhɨ bvó.» Yésu kòtà tà nda ɨ dre dhɨ, dré ngàzo lɨ̀le áyɨ zu àyɨ rúsè. ");
INSERT INTO log_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Tágba Yésu dré tá tà lɨ́ndrɨ́ga ró bǐ dhɨ kɨ ꞌòzo àyɨ mi dhɨ, ɨ̀ kaꞌì tá àyɨkya akódhɨ ko. ");
INSERT INTO log_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Dɨ tà nda kòdhɨ atsá kònɨ̀nɨ, kɨtswálé kúlí pròfétà Èsáyà dré tá tɨsɨ̀le kònɨ ɨ̀ kòꞌoró ru be dhɨ bvó: «Mírì, àdhi kaꞌì kúlí mà dré longólé dhɨ nɨ̀? Àdhi nò tà Mírì dré tadhálé áyɨ drɨ́gá rìnyi ró dhɨ sè dhɨ nɨ̀?» ");
INSERT INTO log_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Dɨ móndɨ́ ɨ̀ kɨtswá tá Yésu nɨ tà kaꞌì bwà ko. Àngyá ko, Èsáyà nda tà tá kpà dhɨ: ");
INSERT INTO log_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«Gìká ꞌo àyɨ kɨ mì adùle, àyɨ kɨ togó ꞌòzo tombálé, ɨ̀ kònòró ngá àyɨ kɨ mì sè ko, ɨ̀ kònìró tà àyɨ kɨ togó na ko, ɨ̀ kàdzáró àyɨ kɨ togó má vélé gò, má dré àyɨ kɨ tɨdrɨ́zó dhɨ ko.» ");
INSERT INTO log_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Èsáyà tà tá tà nda kònɨ̀nɨ tàko ko, nò tá ɨ́na Yésu nɨ mìlanzìlanzì gò, dré akódhɨ nɨ tà tàzo. ");
INSERT INTO log_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Tágba kònɨ̀nɨ dhɨ, móndɨ́ zyandre dhɨ ɨ̀ kaꞌì tá Yésu. Ndɨ̀ndɨ̀ Yúdà ànzɨ kɨ kàdrɨ̀ kɨ àruka ɨ̀ kaꞌì ꞌí. Dɨ, ɨ̀ adré tá àyɨ kɨ tà kaꞌìkaꞌì nda nɨ tà ta ngádra ꞌá ko. Àngyá ko, ɨ̀ adré tá ngá ro, Fàrìsáyò kɨ dra àyɨ kɨ dro lɨ̀sámbò dzó ɨ lésè dhɨ sè. ");
INSERT INTO log_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Tàko ko, ɨ̀ adré tá àyɨkya rúku le kisúlé móndɨ́ ɨ véna, rúku kisúlé Gìká véna dhɨ nɨ lavú. ");
INSERT INTO log_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Àmvolásà dhɨ, Yésu dré kúlí yòzo tàzoá móndyá zyandre ɨ dré dhɨ: «Dhya ángùdhi adrélépi áma kaꞌì dhɨ, adré ngbà ꞌí áma kaꞌì kòdhya ko, adré kókpà dhya áma amùlepi dhɨ nɨ kaꞌì. ");
INSERT INTO log_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Dhya ángùdhi adrélépi áma no dhɨ, adré dhya áma amùlepi dhɨ nɨ no kòdhya. ");
INSERT INTO log_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Má alɨ̀ mána bvò kònɨ̀dhɨ lé adrélé ngádra ró, kɨtswálé dhya ángùdhi adrélépi áma kaꞌì dhɨ kògòró vélé adrélé tínímvá na ko. ");
INSERT INTO log_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Dhya àlo kàdré áma kúlí yi gò, adrézó kaꞌìá ꞌòle ko dhɨ, má adré akódhɨ nda nɨ tàbvó ta ma ko. Tàko ko, má alɨ̀ bvò kònɨ̀dhɨ lé kɨtswálé móndyá bvò àdhya kɨ tàbvó ta ko. Be ró dhɨ, má alɨ̀ mána kɨtswálé móndyá bvò àdhya kɨ tɨdrɨ́. ");
INSERT INTO log_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Dɨ, dhya adrélépi áma ga gò adrézó áma kúlí kaꞌì ko dhɨ, akódhɨ nda nɨ tàbvó tàlepi be. Kúlí má dré tàle dhɨ kɨ akódhɨ nɨ tàbvó ta kìtú kùdù sè dhɨ nɨ̀. ");
INSERT INTO log_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Tàko ko, má tà tá mána kúlí nda ɨ áma drì sè ko. Be ró dhɨ, áma Atá áma amùlepi dhɨ fè ɨ́na tòlɨ́ tàzoá má dré dhɨ, má kòtà àdho tà ꞌɨ ya dhɨ, ɨ̀ndɨ̀ má kòtà tà nda ngɨ́nɨ ya dhɨ nɨ̀. ");
INSERT INTO log_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Dɨ má nì tàle dhɨ, akódhɨ nɨ tòlɨ́ nda adré móndɨ́ kɨ adrì lɨ́drɨ̀ kóná vésè kólyá dhɨ nɨ kisú dhɨ be. Ásà dhɨ, tà ángùdhi má dré adrélé tàle dhɨ, má adré tàá ngóró áma Atá dré tàle má kòtà dhɨ tɨ́nɨ.» ");
INSERT INTO log_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Gwányá Pásɨkà àdhya kandrá dhɨ, Yésu nì tá tàle dhɨ, lókyá ɨ́ dré ngàzo bvò kònɨ̀dhɨ ꞌásè lɨ̀le áyɨ Atá véna dhɨ kɨtswá dre dhɨ be. Lè tá ngbú áyɨ lebèbhá bvò dri dhɨ ɨ tò. Dɨ gò adrélé àyɨ kɨ le tsàle kùdù na. ");
INSERT INTO log_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ɨ̀ndró sè dhɨ, Yésu ɨ lebèbhá nɨ ɨ́be dhɨ ɨ̀ adré tá ngá nya. Dɨ Dzáborò bhà tá tà Yùdásɨ̀ Ɨ̀sɨ̀kàrɨ̀yótà, Sìmónà nɨ mvá nɨ togó na, kòlefèró Yésu kàrɨbhá ɨ drɨ́gá. ");
INSERT INTO log_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yésu nì tá tàle dhɨ, áyɨ Atá tayɨ́ tá tà títí dhɨ ɨ ɨ́ drɨ́gá, ɨ́ angá tá Gìká vélésè, ɨ̀ndɨ̀ ɨ́ adré ꞌòle gòle Gìká véna dhɨ be. ");
INSERT INTO log_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Dɨ dré ngàzo mɨ́sá làgásè, kɨ́tá ɨ́ dré tá asólé kɨ́tá àzya dri dhɨ nɨ avù gò, kɨ́tá àzya adózó dròle áyɨ kípílé ꞌá. ");
INSERT INTO log_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Dré yǐ adózó dàle kòtá na gò, kɨdhózó adrélé áyɨ lebèbhá àlo àlo dhɨ kɨ pá dzɨ, adrézó pá nda kɨ atrì kɨ́tá ɨ́ dré tá dròle áyɨ kípílé ꞌá nda sè. ");
INSERT INTO log_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Kòtsa Sìmónà Pétèró rú dre dhɨ, akódhɨ nda dré tàzoá drá dhɨ: «Mírì, mɨ́ nɨ tsì áma pá dzɨ bàti?» ");
INSERT INTO log_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yésu logó drá dhɨ: «Tà má dré adrélé ꞌòle kònɨ̀dhɨ, mɨ́ nì rè nyànomvá ko. Dɨ, mɨ́ nɨ go tà nda nɨ àndu ni ndò.» ");
INSERT INTO log_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pétèró tà drá dhɨ: «Kóko! Mɨ́ kɨtswá áma pá dzɨ tàdzí ko!» Yésu logó drá dhɨ: «Má kòdzɨ̀ mɨ ko dhɨ, mɨ́ kɨtswá vélé adrélé áma lebèlepi ró ko.» ");
INSERT INTO log_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Dɨ Sìmónà Pétèró tà drá dhɨ: «Mírì, kàdré kònɨ̀nɨ dhɨ, mɨ́ kòdzɨ̀ ngbà ꞌí áma pá kòdhya ko, mɨ́ kòdzɨ̀ kókpà áma drɨ́gá ɨ áma drì be!» ");
INSERT INTO log_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Dɨ Yésu logó drá dhɨ: «Adré lèá dhɨ, dhya áyɨ dzɨ̀lepi dre dhɨ kògò ngbà ꞌí áyɨ pá dzɨ kòdhya. Dɨ akódhɨ nɨ rúbhá wä́yi dhɨ nɨ adré ndǐ àko. Àmɨ, áma lebèbhá nɨ ɨ, àmɨ kemve kpɨ́rɨ́kpɨ́rɨ́. Dɨ, àmɨ títí ko.» ");
INSERT INTO log_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Tà tá kònɨ̀nɨ, dré tá nìle àdhi adré tá ꞌòle áyɨ lefè kàrɨbhá ɨ drɨ́gá nɨ̀ ya dhɨ be dhɨ sè. Ásà dhɨ, tà tá dhɨ: «Àmɨ títí nɨ ɨ kemve ko.» ");
INSERT INTO log_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Dɨ Yésu kòdzɨ̀ àyɨ kɨ pá ɨ akɨ́lé títí dre dhɨ, dré gòzo áyɨ kɨ́tá asó, gòzo lɨrɨ́lé mɨ́sá làga. Dré tàzoá àyɨ dré dhɨ: «Mɨ̀ nì tsì tà má dré ꞌòle àmɨ dré kòdhɨ nɨ àndu be? ");
INSERT INTO log_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Mɨ̀ adré àmɨkya áma zi tà tadhálépi ró, ɨ̀ndɨ̀ Mírì ro. Mɨ̀ adré tà nda nɨ ta kyá, tàko ko, ma kònɨ̀nɨ bàti. ");
INSERT INTO log_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Dɨ ngóró ma, àmɨ kɨ Mírì ro ɨ̀ndɨ̀ àmɨ kɨ tadhálépi ró nɨ, má dré àmɨ kɨ pá dzɨ̀le dhɨ tɨ́nɨ dhɨ, lè mɨ̀ kàdré kókpà àmɨ kɨ adrúpi kɨ pá dzɨ àmɨ kòfalésè. ");
INSERT INTO log_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Tàko ko, má ꞌo tà kòdhɨ àmɨ dré nòle, mɨ̀ kàdréró kókpà ꞌòá ngóró má dré ꞌòle àmɨ dré dhɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Má adré tà bàti ta àmɨ dré: Dhya adrélépi màrábà ro dhɨ lavú áyɨ mírì ko. Dhya mùle dhɨ lavú kpà dhya áyɨ mùlepi dhɨ ko. ");
INSERT INTO log_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nyànomvá dhɨ, mɨ̀ nì tà nda kòdhɨ ɨ be. Dɨ mɨ̀ kàdré tà nda kɨ ꞌo dhɨ, Gìká nɨ tà tanɨ bha àmɨ dri. ");
INSERT INTO log_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Má adré àmɨ wä́yi dhɨ kɨ tà ta kòdhya ko. Má nì mána dhya má dré kɨpèle dhɨ ɨ dóro. Dɨ, adré lèá dhɨ, tà tɨsɨ̀le Gìká nɨ Kúlí na kònɨ̀dhɨ kòꞌo ru: ‹Dhya mà dré áma mápà nyàzo túmä́ní ába dhɨ alá ɨ́na ɨ má rú nɨ̀.› ");
INSERT INTO log_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Má adré tà kòdhɨ nɨ ta àmɨ dré drìdrì tà nda nɨ atsama kandrá, tà nda kònɨ̀ dra ru ꞌo dhɨ, mɨ̀ kòkaꞌìró dhɨ, ma Dhya adrélépi be dhɨ ꞌɨ. ");
INSERT INTO log_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Má adré tà bàti ta àmɨ dré: Dhya ángùdhi adrélépi móndɨ́ má dré mùle dhɨ nɨ kaꞌì dòle dóro dhɨ, adré áma tàndɨ nɨ kaꞌì kòdhya. Dhya ángùdhi adrélépi áma kaꞌì dòle dóro dhɨ, adré dhya áma amùlepi dhɨ nɨ kaꞌì kòdhya.» ");
INSERT INTO log_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yésu kòtà tà nda ɨ dre dhɨ, akódhɨ nɨ togó dré lanzìzo tò gò, dré tàzoá ngádra ꞌá dhɨ: «Má adré tà bàti ta àmɨ dré: Àmɨ kɨ àlo nɨ áma lefè kàrɨbhá ɨ drɨ́gá.» ");
INSERT INTO log_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Dɨ akódhɨ nɨ lebèbhá ɨ̀ dré adrézó ru no, adrélé lizíá àyɨ kòfalésè ngalè adré tá àdhi nɨ tà ta ya dhɨ. ");
INSERT INTO log_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Akódhɨ nɨ lebèbhá nda kɨ àlo dré lèle tò dhɨ, lɨrɨ́ tá adrélé akódhɨ làga. ");
INSERT INTO log_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Dɨ Sìmónà Pétèró dré akódhɨ nda nɨ agózó drɨ́gá sè, kòlizíró Yésu nìzoá ngalè adré tá àdhi nɨ tà ta ya dhɨ. ");
INSERT INTO log_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Dɨ akódhɨ nda dré áyɨ bhèzo Yésu agá lizíá tíá dhɨ: «Mírì, dhya nda àdhi ꞌɨ?» ");
INSERT INTO log_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yésu logó drá dhɨ: «Akódhɨ nda dhya má dré dra mápà kɨ̀gá kònɨ̀dhɨ nɨ sòzo súpù na fèzoá drá dhɨ ꞌɨ.» Dɨ kòso mápà kɨ̀gá nda súpù na dre dhɨ, dré fèzoá Yùdásɨ̀ Ɨ̀sɨ̀kàrɨ̀yótà, Sìmónà nɨ mvá dré. ");
INSERT INTO log_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yùdásɨ̀ kòdo mápà kɨ̀gá nda dre dhɨ, Sàtánà dré ndɨrɨ fɨ̀zo akódhɨ léna. Dɨ Yésu dré tàzoá drá dhɨ: «Tà mɨ́ dré adrélé ꞌòle kòdhɨ, mɨ́ kòꞌo mbèlè.» ");
INSERT INTO log_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Dɨ, dhya àlo àyɨ adrébhá tá mɨ́sá làgásè nda ɨ kòfalé dhɨ nì ngalè Yésu tà tá tà nda drá àdho tà sè ya dhɨ ko. ");
INSERT INTO log_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yùdásɨ̀ dré tá adrélé làfa lɨkɨ́ nɨ̀ dhɨ sè dhɨ, àyɨ kɨ àruka ɨ̀ adré tá kisùá dhɨ, kònò Yésu adré tá tàá drá dhɨ, kòlɨ̀ ngá gɨ àyɨ dré gwányá nɨ tà sè yà, kó ngalè, kòlɨ̀ ngá fe lemerèbhá ɨ dré yà dhɨ. ");
INSERT INTO log_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Dɨ Yùdásɨ̀ kòdo mápà kɨ̀gá nda dre dhɨ, dré ngàzo pfòle kɨvɨ̀ na. Lókyá nda tá ngátsi ꞌɨ. ");
INSERT INTO log_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Dɨ Yùdásɨ̀ kòpfò dre dhɨ, Yésu dré tàzoá dhɨ: «Nyànomvá dhɨ, Gìká nɨ Móndɨ́ nɨ Mvá nɨ mì bha lanzìle. A nɨ kpà áyɨ mìlanzìlanzì tadhá akódhɨ nda rú. ");
INSERT INTO log_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Dɨ Gìká kàdré áyɨ mìlanzìlanzì tadhá akódhɨ rú dhɨ, a nɨ kókpà áyɨ Mvá nda nɨ mì bha lanzìle áyɨ tàndɨ léna. Bàti, a nɨ akódhɨ nɨ mì bha lanzìle nyànomvá. ");
INSERT INTO log_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Áma ànzɨ ɨ, ma dhu rè àmɨ ɨ́be ngbà ꞌí lókyá tsà sè. Mɨ̀ nɨ áma nda. Dɨ, ngóró má dré tá tàle Yúdà ànzɨ ɨ dré dhɨ tɨ́nɨ dhɨ, má adré kpà tàá nyànomvá àmɨ dré dhɨ: Mɨ̀ kɨtswá lɨ̀le àrà má dré adrézó lɨ̀le lána dhɨ na bwà ko. ");
INSERT INTO log_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Má adré tòlɨ́ tɨ́dhɨ́ ro kònɨ̀dhɨ nɨ fe àmɨ dré kòdhya: Mɨ̀ kàdré ru le àmɨ kòfalésè. Ngóró má dré àmɨ kɨ lèle tò dhɨ tɨ́nɨ dhɨ, àmɨ, mɨ̀ kàdré kókpà ru le àmɨ kòfalésè tò. ");
INSERT INTO log_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Mɨ̀ kàdré ru le àmɨ kòfalésè kònɨ̀nɨ dhɨ, móndyá wä́yi dhɨ kɨ nìá tàle dhɨ, àmɨ áma lebèbhá ꞌɨ bàti dhɨ be.» ");
INSERT INTO log_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Gò Sìmónà Pétèró dré tàzoá drá dhɨ: «Mírì, mɨ́ adré lɨ̀le ángolé?» Dɨ Yésu logó drá dhɨ: «Àrà má dré adrézó lɨ̀le lána dhɨ, mɨ́ kɨtswá áma lebè lɨ̀zo lána nyànomvá bwà ko. Dɨ, mɨ́ nɨ go mɨ́na áma lebè lɨ̀zo lána ndò.» ");
INSERT INTO log_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pétèró tà drá dhɨ: «Mírì, má kɨtswá ámɨ lebè nyànomvá bwà ko àdho tà sè? Ma gànzi ró áma lɨ́drɨ̀ fe dràzo mɨ́ dré!» ");
INSERT INTO log_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Dɨ Yésu logó drá dhɨ: «Mɨ́ nɨ tsì ámɨ lɨ́drɨ̀ fe dràzo má dré bàti? Má adré tà bàti ta mɨ́ dré: Drìdrì àgólòwa dré dra tsírà bhèzo dhɨ kandrá dhɨ, mɨ́ nɨ áma ga vésè be na.» ");
INSERT INTO log_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yésu gò tàá àyɨ dré dhɨ: «Mɨ̀ kòtayɨ́ àmɨ kɨ togó adrélé lanzìle ko. Mɨ̀ kàdré Gìká nɨ kaꞌì, adrézó kpà áma kaꞌì. ");
INSERT INTO log_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Áma Atá nɨ dzó na dhɨ, àrà adrézó lána dhɨ ɨ be bǐ. Má adré lɨ̀le kònàle kɨtswálé àrà ledé àmɨ dré. Kàdré tá kònɨ̀nɨ ko dhɨ, kònò má kɨtswá tá tàá àmɨ dré ko. ");
INSERT INTO log_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Dɨ má kòlɨ̀ àrà ledé àmɨ dré dre dhɨ, má nɨ agò àmɨ kɨ do lɨ̀zo àmɨ ɨ́be má bhàna, mɨ̀ kàdréró túmä́ní má be àrà má dré adrézó lána dhɨ na. ");
INSERT INTO log_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Mɨ̀ nì láti lɨ̀zo àrà má dré adrézó lɨ̀le lána dhɨ na dhɨ be.» ");
INSERT INTO log_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tòmá tà drá dhɨ: «Mírì, mà nì ngalè mɨ́ adré lɨ̀le ángolé ya dhɨ ko. Mà nɨ kɨtswá láti nda nɨ ni ngɨ́nɨ?» ");
INSERT INTO log_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Dɨ Yésu logó drá dhɨ: «Ma láti ꞌɨ, tà bàti ꞌɨ, ɨ̀ndɨ̀ lɨ́drɨ̀ ꞌɨ. Dhya àlo kɨtswá lɨ̀le áma Atá véna ko, kàdré lɨ̀le má ꞌásè ko dhɨ. ");
INSERT INTO log_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Mɨ̀ kònì ma be dhɨ, mɨ̀ nɨ kókpà áma Atá nɨ ni be. Kɨdhólé nyànomvá dhɨ, mɨ̀ nì akódhɨ be. Mɨ̀ nò kókpà akódhɨ dre.» ");
INSERT INTO log_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Fìlípò tà drá dhɨ: «Mírì, mɨ́ tadhá àma dré Gìká Atá wà! Kòdhɨ nɨ kɨtswá àma dré.» ");
INSERT INTO log_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Dɨ Yésu logó drá dhɨ: «Fìlípò, ma àmɨ ɨ́be kɨ́nó lésè gò, mɨ́ dré rè áma nìzo ko? Dhya ángùdhi áma nòlepi dhɨ nò áma Atá dre. Mɨ́ adré dɨ mɨ́na tàá dhɨ ‹Mɨ́ tadhá àma dré Gìká Atá wà!› dhɨ ngɨ́nɨ? ");
INSERT INTO log_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Mɨ́ adré tsì kaꞌìá dhɨ, ma áma Atá léna, ɨ̀ndɨ̀ áma Atá má léna dhɨ ko? Kúlí má dré adrélé tàle àmɨ dré kònɨ ɨ, má adré tàá áma drì sè ko. Be ró dhɨ, áma Atá adrélépi adrélé má léna dhɨ adré áyɨ àzí ꞌo nɨ̀. ");
INSERT INTO log_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Lè mɨ̀ kàdré tà má dré adrélé tàle kònɨ kɨ kaꞌì: Ma áma Atá léna, ɨ̀ndɨ̀ áma Atá má léna. Mɨ̀ kàdré tà nda nɨ kaꞌì áma kúlí sè ko dhɨ, mɨ̀ kàdré dɨ kaꞌìá tà lɨ́ndrɨ́ga ró má dré adrélé ꞌòle dhɨ kɨ tà sè. ");
INSERT INTO log_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Má adré tà bàti ta àmɨ dré: Dhya ángùdhi adrélépi áma kaꞌì dhɨ nɨ kpà ɨ́na tà má dré adrélé ꞌòle dhɨ kɨ ꞌo. A nɨ ndɨ̀ndɨ̀ tà kàdrɨ̀ dra tà nda kɨ lavúbhá dhɨ kɨ ꞌo, má dré adrélé lɨ̀le áma Atá véna dhɨ sè. ");
INSERT INTO log_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Má nɨ tà ángùdhi mɨ̀ dré dra zìle áma rú sè dhɨ nɨ ꞌo, áma Atá kòkisúró mìlanzìlanzì áyɨ Mváagó sè be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Bàti, tà ángùdhi mɨ̀ dré dra zìle má tí áma rú sè dhɨ, má nɨ ꞌòá.» ");
INSERT INTO log_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Yésu gò tàá dhɨ: «Mɨ̀ kàdré áma le dhɨ, mɨ̀ nɨ kókpà áma tòlɨ́ kɨ kaꞌì ꞌòle. ");
INSERT INTO log_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Má nɨ tà zi áma Atá tí, kòfèró dhya àzya dra àmɨ kɨ drì tàlepi dhɨ, kàdréró túmä́ní àmɨ ɨ́be kóná vésè kólyá. ");
INSERT INTO log_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Akódhɨ nda, Tɨrɨ́ Lólo adrélépi tà bàti Gìká àdhya nɨ tadhá dhɨ ꞌɨ. Móndyá bvò kòndɨ àdhya ɨ̀ kɨtswá akódhɨ nɨ kisú bwà ko, ɨ̀ dré akódhɨ nɨ nòle ko dhɨ se, ɨ̀ndɨ̀ ɨ̀ dré akódhɨ nɨ nìle ko dhɨ sè. Dɨ, àmɨ ró dhɨ, mɨ̀ nì àmɨkya akódhɨ be, dré adrélé àmɨ ɨ́be dhɨ sè, ɨ̀ndɨ̀ dré dra adrélé àmɨ léna dhɨ sè. ");
INSERT INTO log_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Má kɨtswá àmɨ kɨ tayɨ́ adrélé kɨ̀mvoànzɨ ɨ ró ko. Má nɨ dra agò àmɨ vélé. ");
INSERT INTO log_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Tayɨ́ ngbà ꞌí lókyá tsà, móndyá bvò kòndɨ àdhya ɨ̀ dré gòzo vélé áma no ko. Dɨ, àmɨ ró dhɨ, mɨ̀ nɨ àmɨkya áma no. Má dré adrélé lɨ́drɨ̀ ɨ́be dhɨ sè dhɨ, mɨ̀ nɨ kókpà adré lɨ́drɨ̀ ɨ́be. ");
INSERT INTO log_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Kìtú nda kònàdhɨ tú dhɨ, mɨ̀ nɨ nìá tàle dhɨ, ma áma Atá léna, àmɨ má léna, ɨ̀ndɨ̀ ma àmɨ léna dhɨ be. ");
INSERT INTO log_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Dhya ángùdhi adrélépi áma tòlɨ́ ɨ́be gò, adrézó kaꞌìá ꞌòle dhɨ, akódhɨ nda adré áma le nɨ̀. Áma Atá nɨ dhya adrélépi áma le nda nɨ le. Dɨ má nɨ kókpà akódhɨ nɨ le, adrézó áma tadhá drá.» ");
INSERT INTO log_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yùdásɨ̀, Ɨ̀sɨ̀kàrɨ̀yótà ro ko dhɨ, lizí tíá dhɨ: «Mírì, mɨ́ nɨ ngbà ꞌí ámɨ tadhá àma dré gò, ámɨ tadházó móndyá bvò àdhya ɨ dré ko àdho tà sè?» ");
INSERT INTO log_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Dɨ Yésu logó drá dhɨ: «Dhya ángùdhi adrélépi áma le dhɨ nɨ tà má dré adrélé tadhálé dhɨ kɨ kaꞌì ꞌòle. Áma Atá nɨ akódhɨ nda nɨ le. Dɨ mà nɨ lɨ àma kɨ bhà mo akódhɨ véna, adrézó túmä́ní akódhɨ be. ");
INSERT INTO log_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Dɨ, dhya adrélépi áma le ko dhɨ kɨtswá ɨ́na tà má dré adrélé tadhálé dhɨ kɨ kaꞌì ꞌòle ko. Kúlí mɨ̀ dré adrélé yìle kòdhɨ ɨ, kúlí mána ꞌɨ ko. Be ró dhɨ, kúlí nda ɨ̀ angá áma Atá áma amùlepi dhɨ vélésè. ");
INSERT INTO log_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Má tà tà kòdhɨ ɨ àmɨ dré, má dré rè dhu adréràꞌa àmɨ ɨ́be dhɨ ꞌá. ");
INSERT INTO log_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Dɨ, áma Atá nɨ Dhya dra àmɨ kɨ drì tàlepi dhɨ nɨ amù áma rú sè. Akódhɨ nda, Tɨrɨ́ Lólo ꞌɨ. Kàtsá dre dhɨ, a nɨ tà títí dhɨ kɨ tadhá àmɨ dré gò, adrézó tà títí má dré tàle àmɨ dré dhɨ kɨ ꞌo agálé àmɨ léna dhɨ nɨ̀. ");
INSERT INTO log_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Má adré tà kɨ̀drɨ́kɨ̀drɨ tayɨ́ àmɨ dré. Má adré áma tà kɨ̀drɨ́kɨ̀drɨ fe àmɨ dré kòdhya. Má adré fèá ngóró bvò kònɨ̀dhɨ dré adrélé fèle dhɨ tɨ́nɨ ko. Dɨ mɨ̀ kòtayɨ́ àmɨ kɨ togó adrélé lanzìle ko. Mɨ̀ kàdré kpà ngá ro àlomvá ko. ");
INSERT INTO log_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Mɨ̀ yi tá ma tǎràꞌa àmɨ dré dhɨ: ‹Má adré lɨ̀le, ɨ̀ndɨ̀ má nɨ dra agò àmɨ vélé.› Mɨ̀ kàdré tá áma le bàti dhɨ, kònò mɨ̀ nɨ tá lenzé má dré adrélé lɨ̀le áma Atá véna dhɨ sè. Tàko ko, áma Atá nda kàdrɨ̀ áma lavú. ");
INSERT INTO log_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Má tà tà kòdhɨ ɨ àmɨ dré drìdrì tà nda kɨ atsama kandrá, kɨtswálé tà nda ɨ̀ kònɨ̀ dra ru ꞌo dhɨ, mɨ̀ kòkaꞌìró be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Má kɨtswá gòle tà ta àmɨ ɨ́be vwàvwà ro ko. Àngyá ko, ópɨ́ bvò kòndɨ àdhya adré alɨ̀le. Akódhɨ nda rìnyí àko má drìle. ");
INSERT INTO log_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Dɨ, adré lèá dhɨ, móndyá bvò kòndɨ àdhya ɨ̀ kònì tàle dhɨ, má adré áma Atá nɨ le, ɨ̀ndɨ̀ má adré tà títí dré tàle má kòꞌo dhɨ kɨ ꞌo káyà dhɨ. Mɨ̀ nga, mà kòlɨ̀ró kònwásè!» ");
INSERT INTO log_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Àmvolásà dhɨ, Yésu dré gòzo tàá dhɨ: «Ma vínò fa bàti dhɨ ꞌɨ. Áma Atá, vínò fa nda nɨ lɨkɨ́lépi ꞌɨ. ");
INSERT INTO log_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Adré kólá ángùdhi má rú adrélépi lòꞌwa ꞌa ko dhɨ nɨ ga sèle. Dɨ, kàdré ɨ́na kólá adrélépi lòꞌwa ꞌa dhɨ nɨ tà sè dhɨ, adré kólá nzɨ̌ rúá dhɨ kɨ sɨ, kólá nda kògòró vélé adrélé lòꞌwa ꞌa wáláká nɨ nɨ lavú. ");
INSERT INTO log_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Àmɨ ró dhɨ, mɨ̀ atsá kemve kpɨ́rɨ́kpɨ́rɨ́, kúlí má dré tàle àmɨ dré dhɨ ɨ sè dre. ");
INSERT INTO log_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Lè mɨ̀ kàdré adrélé má léna, ngóró má dré adrélé àmɨ léna dhɨ tɨ́nɨ. Vínò fa nɨ kólá àlo dhɨ kɨtswá ɨ́na lòꞌwa ꞌa áyɨ tàndɨ sè bwà ko, kàdré adrélé vínò fa rú ko dhɨ. Kókpà kòdhɨ tɨ́nɨ, mɨ̀ kɨtswá àmɨkya lòꞌwa ꞌa bwà ko, mɨ̀ kàdré adrélé má léna ko dhɨ. ");
INSERT INTO log_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ma vínò fa ꞌɨ, ɨ̀ndɨ̀ àmɨ kólá nɨ ꞌɨ. Dhya ángùdhi adrélépi adrélé má léna gò má dré adrézó lána dhɨ, akódhɨ nda nɨ lòꞌwa ꞌa bǐ. Tàko ko, mɨ̀ kàdré má rúsè lárá ro dhɨ, mɨ̀ kɨtswá àmɨkya tà àlo ꞌo bwà ko. ");
INSERT INTO log_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Dhya àlo kàdré adrélé má léna ko dhɨ, à nɨ akódhɨ nda nɨ bhe gàrà dri ngóró adrélé kólá bhe dhɨ tɨ́nɨ gò, dré adrézó ꞌyòle. À adré kólá làsú be kònɨ̀nɨ nda kɨ lomvó dàle àtsɨ́ na gò, ɨ̀ dré adrézó vèle. ");
INSERT INTO log_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Dɨ, mɨ̀ kàdré àmɨkya adrélé má léna gò, áma kúlí ɨ̀ dré adrézó àmɨ léna dhɨ, mɨ̀ nɨ kɨtswá tà ángùdhi mɨ̀ dré adrélé lèle dhɨ nɨ zi gò, mɨ̀ dré tà nda nɨ kisúzó. ");
INSERT INTO log_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Mɨ̀ kàdré lòꞌwa ꞌa bǐ dhɨ, kòdhɨ mɨ̀ adré tadhá dhɨ, àmɨ áma lebèbhá ꞌɨ bàti gò, mɨ̀ dré adrézó áma Atá nɨ rú bha kùle ásà. ");
INSERT INTO log_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ngóró áma Atá dré adrélé áma le dhɨ tɨ́nɨ dhɨ, má adré kókpà àmɨ kɨ le. Lè mɨ̀ kàdré dɨ adrélé áma lèle nda na. ");
INSERT INTO log_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Mɨ̀ kàdré áma tòlɨ́ kɨ kaꞌì ꞌòle dhɨ, mɨ̀ nɨ adré áma lèle na, ngóró má dré adrélé áma Atá nɨ tòlɨ́ kɨ kaꞌì ꞌòle, adrézó kpà akódhɨ nɨ lèle na dhɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Má tà tà kòdhɨ ɨ àmɨ dré, mɨ̀ kàdréró áma kólénzé ɨ́be àmɨ léna, ɨ̀ndɨ̀ àmɨ kɨ kólénzé kògaró kɨtswálé títí. ");
INSERT INTO log_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Tòlɨ́ má dré adrélé fèle àmɨ dré dhɨ, tòlɨ́ kònɨ̀dhɨ ꞌɨ: Lè mɨ̀ kàdré ru le àmɨ kòfalésè, ngóró má dré adrélé àmɨ kɨ le dhɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Lèle kàdrɨ̀ lèle àruka títí dhɨ kɨ lavúlépi dhɨ, kònɨ̀dhɨ ꞌɨ: À kòfè dhyá kɨ lɨ́drɨ̀ dhyá kɨ arúpi kɨ tà sè. ");
INSERT INTO log_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Àmɨ áma arúpi ꞌɨ, mɨ̀ kàdré tòlɨ́ má dré adrélé fèle dhɨ kɨ ꞌo dhɨ. ");
INSERT INTO log_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Má adré gòle vélé àmɨ kɨ zi màrábà ɨ ró ko. Àngyá ko, dhya adrélépi màrábà ro dhɨ nì ɨ́na tà áyɨ mírì dré adrélé ꞌòle dhɨ ɨ ko. Dɨ, má adré mána àmɨ kɨ zi arúpi ɨ ró, má dré tà títí má dré yìle áma Atá vélésè dhɨ kɨ tadhálé àmɨ dré dhɨ sè. ");
INSERT INTO log_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Mɨ̀ kɨpè tá ma àmɨ ko. Be ró dhɨ, má kɨpè àmɨ ma, àmɨ kɨ bhàzo adrélé lɨ̀le lòꞌwa ꞌabe, àmɨ kɨ lòꞌwa nda ɨ̀ kàdréró nyo. Dɨ ásà dhɨ, áma Atá nɨ tà ángùdhi mɨ̀ dré dra zìle ɨ́ tí áma rú sè dhɨ nɨ fe àmɨ dré. ");
INSERT INTO log_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Tòlɨ́ mána, tòlɨ́ kònɨ̀dhɨ ꞌɨ: Mɨ̀ kàdré ru le àmɨ kòfalésè.» ");
INSERT INTO log_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","«Móndyá bvò àdhya ɨ̀ kàdré togó kònzɨ bha àmɨ rú dhɨ, mɨ̀ kòtɨvɨ̀ ko tàle dhɨ, àyɨ nda ɨ̀ bhà tá zyà togó kònzɨ má rú ꞌíká. ");
INSERT INTO log_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Mɨ̀ kàdré tá bvò kòndɨ àdhya ró dhɨ, kònò móndyá bvò kòndɨ àdhya kɨ tá adré àmɨ kɨ le móndɨ́ àyɨkya ɨ ró. Dɨ, má kɨpè mána àmɨ apfòle bvò kòndɨ lésè gò, mɨ̀ dré adrézó vélé bvò kòndɨ àdhya ró ko. Ásà dhɨ, móndyá bvò kòndɨ àdhya ɨ̀ adré togó kònzɨ bha àmɨ rú. ");
INSERT INTO log_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Lè mɨ̀ kàdré kúlí má dré tá tàle àmɨ dré kònɨ̀dhɨ nɨ kisù: ‹Dhya adrélépi màrábà ro dhɨ lavú áyɨ mírì ko.› Móndɨ́ ɨ̀ kòpfo áma mì ꞌí dhɨ, ɨ̀ nɨ kókpà àmɨ kɨ mì pfo. Ɨ̀ kòkaꞌì áma kúlí ꞌòle ꞌí dhɨ, ɨ̀ nɨ kókpà àmɨ kɨ kúlí kaꞌì ꞌòle. ");
INSERT INTO log_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ɨ̀ nɨ tà nda kòdhɨ kɨ ꞌo àmɨ rú áma tà sè, ɨ̀ dré dhya áma amùlepi dhɨ nɨ nìle ko dhɨ sè. ");
INSERT INTO log_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Kònò má kàlɨ̀ tá tà ta àyɨ dré ko dhɨ, à kɨtswá tá tà bha àyɨ dri àyɨ kɨ tàkonzɨ̀ sè ko. Dɨ, nyànomvá dhɨ, àyɨ àyɨkya tà àlo ɨ̀ dré kɨtswázó àyɨ kɨ tàrá ga àyɨ kɨ tàkonzɨ̀ sè dhɨ àko. ");
INSERT INTO log_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Dhya ángùdhi adrélépi togó kònzɨ bha má rú dhɨ, adré kókpà bhàá áma Atá rú. ");
INSERT INTO log_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Kònò má kòꞌo tá tà lɨ́ndrɨ́ga ró dhya àzya dré ꞌòle tàdzí ko dhɨ ɨ àyɨ kòfalé ko dhɨ, à kɨtswá tá tà bha àyɨ dri àyɨ kɨ tàkonzɨ̀ sè ko. Dɨ, nyànomvá dhɨ, ɨ̀ nò tà lɨ́ndrɨ́ga ró nda ɨ ꞌí gò, ɨ̀ dré àyɨkya togó kònzɨ bhàzo má rú, ɨ̀ndɨ̀ áma Atá rú. ");
INSERT INTO log_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ɨ̀ ꞌo kònɨ̀nɨ kɨtswálé tà tɨsɨ̀le àyɨ kɨ tátrɨ́trɨ́ kúlí na kònɨ̀dhɨ kòꞌoró ru be dhɨ bvó: ‹Ɨ̀ bhà togó kònzɨ má rú tà àndu àko.› ");
INSERT INTO log_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Má nɨ Dhya dra àmɨ kɨ drì tàlepi dhɨ nɨ amù àmɨ dré áma Atá vélésè. Akódhɨ nda, Tɨrɨ́ Lólo adrélépi tà bàti tadhá, ɨ̀ndɨ̀ adrélépi angálé Gìká vélésè dhɨ ꞌɨ. Dɨ kàtsá dre dhɨ, a nɨ áma tà longó àmɨ dré nɨ̀. ");
INSERT INTO log_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Àmɨ ró dhɨ, mɨ̀ nɨ kókpà áma tà longó móndɨ́ ɨ dré. Tàko ko, àmɨ túmä́ní má be kɨdhólé áma àzí nɨ kɨdhoma lésè.» ");
INSERT INTO log_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","«Má tà tà kòdhɨ ɨ àmɨ dré, mɨ̀ kòkɨtswáró àmɨ kɨ tà kaꞌìkaꞌì tayɨ́ ko. ");
INSERT INTO log_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Tàko ko, à nɨ àmɨ kɨ dro lɨ̀sámbò dzó ɨ lésè. Lókyá adré ndɨ̀ndɨ̀ alɨ̀le, móndyá dra àmɨ kɨ tupfúbhá todràle dhɨ kɨ kisùá dhɨ, ɨ̀ adré àyɨkya tà ꞌo Gìká dré. ");
INSERT INTO log_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ɨ̀ nɨ ꞌòá kònɨ̀nɨ, ɨ̀ dré Gìká Atá nɨ nìle ko dhɨ sè, ɨ̀ndɨ̀ ɨ̀ dré áma nìle ko dhɨ sè. ");
INSERT INTO log_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Má tà tà kòdhɨ ɨ àmɨ dré, kɨtswálé lókyá ɨ̀ dré dra tà nda kɨ ꞌòzo dhɨ kònɨ̀ atsá dhɨ, tà má dré tàle àmɨ dré nda ɨ̀ kàgáró àmɨ léna be dhɨ bvó.» «Má tà tá tà nda ɨ àmɨ dré drìdrì ko, má dré tá dhu rè adrélé àmɨ ɨ́be dhɨ sè. ");
INSERT INTO log_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Nyànomvá dhɨ, má adré lɨ̀le dhya áma amùlepi dhɨ véna. Dɨ, dhya àlo àmɨ kòfalé dhɨ adré lizíá má tí ngalè má adré lɨ̀le ángolé ya dhɨ ko. ");
INSERT INTO log_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Be ró dhɨ, kɨzà adré ɨ́na gàle àmɨ kɨ togó na, tà má dré tàle àmɨ dré nda ɨ sè. ");
INSERT INTO log_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Dɨ, má adré mána tà bàti tà àmɨ dré: Dóro nɨ àmɨ dré dhɨ, má dré lɨ̀le dhɨ. Àngyá ko, má kòlɨ̀ ko dhɨ, Dhya dra àmɨ kɨ drì tàlepi dhɨ kɨtswá alɨ̀le àmɨ vélé ko. Dɨ, má kòlɨ̀ dhɨ, má nɨ mána akódhɨ nda nɨ amù àmɨ vélé. ");
INSERT INTO log_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Akódhɨ kàtsá dre dhɨ, a nɨ móndyá bvò kòndɨ àdhya kɨ tàkonzɨ̀ tadhá àyɨ dré, adrézó Gìká nɨ tà gyǎgya tadhá àyɨ dré, adrézó kpà tàbvó Gìká dré dra tàle dhɨ nɨ tadhá àyɨ dré. ");
INSERT INTO log_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","A nɨ àyɨ kɨ tàkonzɨ̀ tadhá, ɨ̀ dré adrélé áma kaꞌì ko dhɨ sè. ");
INSERT INTO log_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","A nɨ Gìká nɨ tà gyǎgya tadhá, má dré adrélé lɨ̀le áma Atá véna gò, mɨ̀ dré gòzo vélé áma no ko dhɨ sè. ");
INSERT INTO log_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","A nɨ tàbvó Gìká dré dra tàle dhɨ nɨ tadhá, Gìká dré ópɨ́ bvò kòndɨ àdhya nɨ tàbvó tàle dre dhɨ sè. ");
INSERT INTO log_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ma dhu rè tà ɨ́be bǐ tàle àmɨ dré. Dɨ, nyànomvá dhɨ, mɨ̀ kɨtswá rè tà nda kɨ mvo bwà ko. ");
INSERT INTO log_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Dɨ, Tɨrɨ́ tà bàti àdhya nda kàtsá dre dhɨ, a nɨ àmɨ kɨ tidrì tà bàti wä́yi dhɨ léna. Àngyá ko, kɨtswá ɨ́na tà ta áyɨ drì sè ko. Be ró dhɨ, a nɨ ngbà ꞌí tà ɨ́ dré dra yìle dhɨ kɨ ta àmɨ dré kòdhya. A nɨ kókpà tà dra atsábhá dhɨ kɨ longó àmɨ dré. ");
INSERT INTO log_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","A nɨ mìlanzìlanzì fe má dré. Tàko ko, a nɨ tà ɨ́ dré dra kisúlé má vélé dhɨ kɨ do longólé àmɨ dré. ");
INSERT INTO log_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Tà títí áma Atá àdhya ɨ kókpà mána ꞌɨ. Dɨ ásà dhɨ, má tà tá dhɨ, Tɨrɨ́ nda nɨ tà ɨ́ dré dra kisúlé má vélé dhɨ kɨ do longólé àmɨ dré.» ");
INSERT INTO log_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Yésu gò tàá dhɨ: «Tayɨ́ lókyá tsà, mɨ̀ dré gòzo vélé áma no ko. Àmvolásà dhɨ, gí ko, mɨ̀ dré gòzo áma no.» ");
INSERT INTO log_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Dɨ akódhɨ nɨ lebèbhá kɨ àruka ɨ̀ dré lizízóá àyɨ kòfalésè dhɨ: «Adré lèá tàle ngɨ́nɨ? Tà tá dhɨ: ‹Tayɨ́ lókyá tsà, mɨ̀ dré gòzo vélé áma no ko. Àmvolásà dhɨ, gí ko, mɨ̀ dré gòzo áma no.› Tà tá kpà dhɨ: ‹Má adré lɨ̀le áma Atá véna.› ");
INSERT INTO log_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Adré lèá tàle ngɨ́nɨ, dré adréràꞌa tàá dhɨ ‹lókyá tsà› dhɨ ꞌá dhɨ? Mà nì ngalè adré àdho tà ta ya dhɨ ko.» ");
INSERT INTO log_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yésu dré nìzoá tàle dhɨ, ɨ̀ adré tá tà le lizílé ɨ́ tí tà nda dri dhɨ be gò, dré tàzoá àyɨ dré dhɨ: «Mɨ̀ adré lizíá àmɨ kòfalésè ngalè tà má dré tàle nda ɨ̀ adré lèá tàle ngɨ́nɨ ya dhɨ? Má tà tá dhɨ: ‹Tayɨ́ lókyá tsà, mɨ̀ dré gòzo vélé áma no ko. Àmvolásà dhɨ, gí ko, mɨ̀ dré gòzo áma no.› ");
INSERT INTO log_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Má adré tà bàti ta àmɨ dré: Mɨ̀ nɨ àmɨkya àwó ngo adrézó tongólé. Dɨ, móndyá bvò kòndɨ àdhya kɨ àyɨkya lenzé. Àmɨ kɨ togó nɨ kɨzà nya. Dɨ, kɨzà nda nɨ ɨ́na ru ladzá atsálé kólénzé ro. ");
INSERT INTO log_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Tòkó adrélépi ꞌòle tìle dhɨ adré kɨzà nya, akódhɨ nɨ lókyá tìzo dhɨ dré atsálé ànyɨ dre dhɨ sè. Dɨ, kòti dre dhɨ, adré gòle vélé áyɨ kɨzà nda nɨ tà kisù ko. Àngyá ko, adré lenzélé dré mvá tìle apfòle bvò dri dre dhɨ sè. ");
INSERT INTO log_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Tà nda kòdhɨ kókpà kònɨ̀nɨ àmɨ kɨ tà sè. Nyànomvá dhɨ, àmɨ kɨ togó adré gàle kɨzà sè. Dɨ, má nɨ go àmɨ kɨ no gò, àmɨ kɨ togó dré gòzo adrélé lenzélé. Dɨ dhya àlo kɨtswá kólénzé nda nɨ tɨngá àmɨ kɨ togó lésè bwà ko. ");
INSERT INTO log_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Kɨdhólé lókyá nda kònàdhɨ sè dhɨ, mɨ̀ kɨtswá gòle vélé tà àlo lizí má tí ko. Má adré tà bàti ta àmɨ dré: Áma Atá nɨ tà ángùdhi mɨ̀ dré dra zìle ɨ́ tí áma rú sè dhɨ nɨ fe àmɨ dré. ");
INSERT INTO log_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Atsálé nyànomvá kònɨ̀dhɨ dhɨ, mɨ̀ zi rè tà àlo áma rú sè dhɨ ko. Lè mɨ̀ kàdré tà zi áma rú sè gò, mɨ̀ kòkisúró tà nda, àmɨ kɨ kólénzé kògaró kɨtswálé títí be dhɨ bvó.» ");
INSERT INTO log_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","«Má tà tà kòdhɨ ɨ àmɨ dré kúlí alaala sè. Dɨ, lókyá adrélépi alɨ̀le dhɨ sè dhɨ, má kɨtswá gòle vélé tà ta àmɨ dré kònɨ̀nɨ ko. Be ró dhɨ, má nɨ mána áma Atá nɨ tà ta àmɨ dré ngádra ꞌá. ");
INSERT INTO log_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Lókyá nda sè dhɨ, mɨ̀ nɨ adré tà zi áma Atá tí áma rú sè. Má adré tàá ko tàle dhɨ, má nɨ tà nda kɨ zi áma Atá tí àmɨ dré ma dhɨ. ");
INSERT INTO log_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Tàko ko, áma Atá nɨ tàndɨ adré àmɨ kɨ le, mɨ̀ dré adrélé áma le dhɨ sè, ɨ̀ndɨ̀ mɨ̀ dré kaꞌìle dhɨ má angá akódhɨ vélésè dhɨ sè. ");
INSERT INTO log_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Bàti, má angá áma Atá vélésè alɨ̀le bvò kònɨ̀dhɨ lé. Dɨ nyànomvá dhɨ, má adré bvò kònɨ̀dhɨ nɨ tayɨ́, gòzo áma Atá véna.» ");
INSERT INTO log_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Dɨ akódhɨ nɨ lebèbhá ɨ̀ tà drá dhɨ: «Nyànomvá dhɨ, mɨ́ adré vélé tà ta ngádra ꞌá, kúlí alaala sè ko. ");
INSERT INTO log_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nyànomvá dhɨ, mà nì tàle dhɨ, mɨ́ nì tà títí dhɨ ɨ be. Lè kpà à kògò tà àlo lizí mɨ́ tí dhɨ ko. Dɨ ásà dhɨ, mà kaꞌì tàle dhɨ, mɨ́ angá Gìká vélésè káyà dhɨ.» ");
INSERT INTO log_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Dɨ Yésu logó àyɨ dré dhɨ: «Mɨ̀ adré tsì áma kaꞌì nyànomvá? ");
INSERT INTO log_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Mɨ̀ yi rè ká! Lókyá adré alɨ̀le, atsá kpà dre, à nɨ àmɨ kɨ lapé ràle àmɨ àlo àlo títí dhɨ kɨ dzó ɨ ꞌásè. Mɨ̀ nɨ áma tayɨ́ adrélé kalóma. Dɨ, má kɨtswá mána adrélé kalóma ko, áma Atá dré adrélé túmä́ní má be dhɨ sè. ");
INSERT INTO log_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Má tà tà kòdhɨ ɨ àmɨ dré, mɨ̀ kàdréró adrélé tà kɨ̀drɨ́kɨ̀drɨ ɨ́be, mɨ̀ dré adrélé má léna dhɨ sè. Bvò kònɨ̀dhɨ lé dhɨ, mɨ̀ nɨ adré kɨzà nya tò. Dɨ, mɨ̀ kàdré àmɨkya togó tsɨ! Má lavú mána bvò nda dre!» ");
INSERT INTO log_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yésu kòtà tà nda ɨ dre dhɨ, dré mì tɨngázó kurú na bhù na, tàzoá dhɨ: «Tátá, lókyá kɨtswá dre. Mɨ́ bhà ámɨ Mváagó nɨ mì lanzìle wà, ámɨ Mváagó kòbhàró kókpà ámɨ mì lanzìle be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Tàko ko, mɨ́ afè rìnyí akódhɨ dré adrézó móndyá wä́yi ɨ drìle, kòfèró lɨ́drɨ̀ kóná vésè kólyá dhɨ móndyá wä́yi mɨ́ dré afèle ɨ́ dré dhɨ ɨ dré. ");
INSERT INTO log_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Lɨ́drɨ̀ kóná vésè kólyá nda, tà kònɨ ꞌɨ: adrélé mɨ, Gìká bàti àlo kwákwá dhɨ nɨ ni dhɨ, ɨ̀ndɨ̀ adrélé Yésu Krísto mɨ́ dré amùle dhɨ nɨ ni dhɨ. ");
INSERT INTO log_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Má tadhá ámɨ mìlanzìlanzì móndyá bvò dri dhɨ ɨ dré nòle dre. Àngyá ko, má ꞌo àzí mɨ́ dré afèle má dré ꞌòle dhɨ akɨ́lé dre. ");
INSERT INTO log_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Dɨ nyànomvá dhɨ, Tátá, mɨ́ bhà áma mì lanzìle mɨ́ làga, mìlanzìlanzì má dré tá adrézó ába mɨ́ làga drìdrì bvò nɨ bhàma kandrá dhɨ sè wà.» ");
INSERT INTO log_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","«Má tadhá mɨ móndyá mɨ́ dré adólé bvò kòndɨ lésè afèle má dré dhɨ ɨ dré dre. Àyɨ nda ɨ tá mɨ́na ꞌɨ. Dɨ mɨ́ afè tá àyɨ má dré gò, ɨ̀ dré ámɨ kúlí kaꞌìzo ꞌòle. ");
INSERT INTO log_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Nyànomvá dhɨ, ɨ̀ nì tàle dhɨ, tà títí mɨ́ dré afèle má dré dhɨ ɨ̀ angá mɨ́ vélésè dhɨ be. ");
INSERT INTO log_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Tàko ko, má fè àyɨ dré kúlí mɨ́ dré afèle má dré dhɨ ɨ gò, ɨ̀ dré kúlí nda kɨ kaꞌìzo. Dɨ ɨ̀ nì bàti tàle dhɨ, má apfò mɨ́ vélésè dhɨ. Ɨ̀ kaꞌì kpà tàle dhɨ, mɨ́ amù ma mɨ. ");
INSERT INTO log_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Má adré tà zi mɨ́ tí àyɨ nda ɨ dré. Má adré tà zi móndyá bvò àdhya ɨ dré ko. Be ró dhɨ, má adré mána tà zi àyɨ mɨ́ dré afèle má dré nda ɨ dré. Àngyá ko, àyɨ mɨ́na ꞌɨ. ");
INSERT INTO log_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ngá wä́yi mána ɨ kókpà mɨ́na ꞌɨ. Ngá wä́yi mɨ́na ɨ kókpà mána ꞌɨ. Dɨ má kisú mìlanzìlanzì àyɨ nda ɨ sè dre. ");
INSERT INTO log_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Nyànomvá dhɨ, má adré mána lɨ̀le mɨ́ véna. Má gò vélé adrélé bvò kònɨ̀dhɨ lé ko. Dɨ, àyɨ nda ɨ dhu rè àyɨkya bvò kònɨ̀dhɨ lé. Áma Atá lólo nɨ, mɨ́ kàdré àyɨ kɨ lɨkɨ́ ámɨ rú mɨ́ dré afèle má dré dhɨ nɨ rìnyí sè, ɨ̀ kàdréró ngá àlo ró, ngóró mà dré adrélé mɨ́ be ngá àlo ró dhɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Má dré tá adréràꞌa àyɨ ɨ́be dhɨ ꞌá dhɨ, má adré tá àyɨ kɨ lɨkɨ́ ámɨ rú mɨ́ dré afèle má dré nda nɨ rìnyí sè. Má su tá àyɨ rú gò, àyɨ kɨ àlo dré avɨ̀zo ko, kàdré ngbà ꞌí mvá adrélépi tá lɨ̀le dràdrà kisú dhɨ ꞌɨ ko dhɨ. Tà nda kòdhɨ atsá kònɨ̀nɨ, kɨtswálé tà tɨsɨ̀le ámɨ Kúlí na dhɨ ɨ̀ kòꞌoró ru be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Nyànomvá dhɨ, má adré lɨ̀le mɨ́ véna. Dɨ má adré tà kòdhɨ kɨ ta má dré rè dhu adréràꞌa bvò kònɨ̀dhɨ lé dhɨ ꞌá, ɨ̀ kàdréró adrélé áma kólénzé ɨ́be, ɨ̀ndɨ̀ kólénzé nda kògaró àyɨ léna kɨtswálé títí. ");
INSERT INTO log_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Má fè àyɨ dré ámɨ kúlí gò, móndyá bvò kòndɨ àdhya ɨ̀ dré togó kònzɨ bhàzo àyɨ rú, ɨ̀ dré adrélé bvò kòndɨ àdhya ró ko dhɨ sè, ngóró má dré kpà adrélé bvò kòndɨ àdhya ró ko dhɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Má adré tà zi mɨ́ tí, mɨ́ kòtɨngáró àyɨ bvò kòndɨ ꞌásè dhɨ ko. Be ró dhɨ, má adré mána tà zi, mɨ́ kàdréró àyɨ kɨ lɨkɨ́ Dhya kònzɨ nɨ tà sè. ");
INSERT INTO log_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Àyɨ nda ɨ móndɨ́ bvò kòndɨ àdhya ꞌɨ ko, ngóró má dré kpà adrélé móndɨ́ bvò kòndɨ àdhya ꞌɨ ko dhɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Mɨ́ kòbhà àyɨ twá adrélé móndyá lólo mɨ́na ɨ ró tà bàti sè. Ámɨ kúlí, tà bàti nda ꞌɨ. ");
INSERT INTO log_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ngóró mɨ́ dré áma amùle bvò kònɨ̀dhɨ lé dhɨ tɨ́nɨ dhɨ, má adré kókpà àyɨ kɨ mu lɨ̀le bvò nda ꞌásè. ");
INSERT INTO log_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Àyɨ nda kɨ tà sè dhɨ, má adré áma tàndɨ nɨ fe adrélé ámɨ tà ꞌo, ɨ̀ kàtsáró móndyá lólo mɨ́na ɨ ró tà bàti sè.» ");
INSERT INTO log_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","«Má adré ngbà ꞌí tà zi mɨ́ tí àyɨ nda ɨ dré ko. Má adré kókpà tà zi móndyá dra áma kaꞌìbhá àyɨ nda kɨ kúlí sè dhɨ ɨ dré. ");
INSERT INTO log_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Tátá, má adré tà zi, àyɨ títí nda ɨ̀ kàdréró ngá àlo ró, ngóró mɨ́ dré adrélé má léna dhɨ tɨ́nɨ, ɨ̀ndɨ̀ má dré adrélé mɨ́ léna dhɨ tɨ́nɨ. Lè ɨ̀ kàdré kókpà àma léna, móndyá bvò kòndɨ àdhya ɨ̀ kòkaꞌìró dhɨ, mɨ́ amù ma mɨ. ");
INSERT INTO log_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Má fè àyɨ dré mìlanzìlanzì mɨ́ dré afèle má dré dhɨ, ɨ̀ kàdréró ngá àlo ró, ngóró mà dré adrélé mɨ́ be ngá àlo ró dhɨ tɨ́nɨ: ");
INSERT INTO log_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","ma àyɨ léna, ɨ̀ndɨ̀ mɨ má léna. Lè ɨ̀ kàdré kókpà ngá àlo ró kɨtswálé títí, móndyá bvò kòndɨ àdhya ɨ̀ kònìró tàle dhɨ, mɨ́ amù ma mɨ, ɨ̀ndɨ̀ mɨ́ adré àyɨ kɨ le ngóró mɨ́ dré adrélé áma le dhɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Tátá, má adré lèá dhɨ, móndyá mɨ́ dré afèle má dré nda ɨ̀ kàdré túmä́ní má be àrà má dré adrézó lána dhɨ na, ɨ̀ kàdréró áma mìlanzìlanzì no be dhɨ bvó. Mɨ́ afè má dré mìlanzìlanzì nda, mɨ́ dré tá áma lèle drìdrì bvò nɨ bhàma kandrá dhɨ sè. ");
INSERT INTO log_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Áma Atá gyǎgya nɨ, tágba móndyá bvò kòndɨ àdhya ɨ̀ dré ámɨ nìzo ko dhɨ, má nì mána mɨ be. Móndyá áma kaꞌìbhá nda ɨ̀ nì kpà tàle dhɨ, mɨ́ amù ma mɨ dhɨ be. ");
INSERT INTO log_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Má ꞌo mɨ àyɨ nda ɨ̀ dré nìle. Má nɨ kpà go adrélé ámɨ ꞌo ɨ̀ dré nìle, kɨtswálé lèle mɨ́ dré adrézó áma le ásà dhɨ kàdréró àyɨ léna, ɨ̀ndɨ̀ áma tàndɨ má kàdréró àyɨ léna.» ");
INSERT INTO log_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yésu kòtà tà nda ɨ dre dhɨ, ɨ̀ dré ngàzo lɨ̀le lebèbhá nɨ ɨ́be zyàle yábhu rú zìle Kèdrónà dhɨ nɨ taꞌá na. Gò ɨ̀ dré fɨ̀zo amvú àlo òlívè fa kya na. ");
INSERT INTO log_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Dɨ Yùdásɨ̀ adrélépi tá ꞌòle akódhɨ nɨ lefè kàrɨbhá ɨ drɨ́gá dhɨ nì tá kpà àrà nda be. Àngyá ko, Yésu ɨ lebèbhá nɨ ɨ́be dhɨ ɨ̀ adré tá ru kɨmó kònàle rä. ");
INSERT INTO log_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Dɨ Yùdásɨ̀ nda dré Rómà kɨ sòdá zyandre dhɨ kɨ adrìzo ɨ́ vésè, túmä́ní tépelò lɨkɨ́bhá àruka angábhá kòwánà kàdrɨ̀ ɨ vélésè ɨ̀ndɨ̀ Fàrìsáyò ɨ vélésè dhɨ ɨ́be, alɨ̀zo àyɨ ɨ́be. Àyɨ nda ɨ̀ ru tá àtsɨ́ ɨ, tálà ɨ, ɨ̀ndɨ̀ àdzú ngá ɨ́be àyɨ drɨ́gá. ");
INSERT INTO log_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Dɨ Yésu nì tá tà títí adrébhá ꞌòle atsálé ɨ́ rú dhɨ ɨ be gò, dré áyɨ kisízó àyɨ nda ɨ véna, lizíá àyɨ tí dhɨ: «Mɨ̀ adré àdhi nɨ nda?» ");
INSERT INTO log_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ɨ̀ logó drá dhɨ: «Yésu Nàzàrétà lésè dhɨ.» Dɨ Yésu tà àyɨ dré dhɨ: «Ma ꞌɨ.» Yùdásɨ̀ adrélépi akódhɨ nɨ lefè àyɨ drɨ́gá nda totó tá ɨ àyɨ kòfalé. ");
INSERT INTO log_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Dɨ Yésu kòtà dhɨ «Ma ꞌɨ» àyɨ dré dre dhɨ, ɨ̀ dré gòzo bvólé ro ledhélé kìní mi. ");
INSERT INTO log_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Gò Yésu dré gòzo tódhyá lizíá àyɨ tí dhɨ: «Mɨ̀ adré àdhi nɨ nda?» Ɨ̀ tà dhɨ: «Yésu Nàzàrétà lésè dhɨ.» ");
INSERT INTO log_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Dɨ Yésu logó dhɨ: «Má tà tá àmɨ dré dhɨ, ma ꞌɨ dhɨ dre. Mɨ̀ kàdré áma nda kòdhya dhɨ, mɨ̀ tayɨ́ dɨ móndyá kònɨ ɨ lɨ̀le.» ");
INSERT INTO log_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Tà nda kòdhɨ atsá tá kònɨ̀nɨ, kɨtswálé kúlí Yésu dré tá tàle kònɨ̀dhɨ kòꞌoró ru: «Má tayɨ́ dhya mɨ́ dré afèle má dré dhɨ kɨ àlo avɨ̀le ko.» ");
INSERT INTO log_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Gò Sìmónà Pétèró adrélépi tá sápɨ́ ɨ́be dhɨ, dré ngàzo sápɨ́ nda nɨ asé gò, kòwánà kɨ kàdrɨ̀ nɨ màrábà nɨ bí drɨ́ágó lésè dhɨ nɨ bvwàzo kɨ̀le. Màrábà nda nɨ rú tá Màlókò. ");
INSERT INTO log_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Dɨ, Yésu dré tàzoá Pétèró dré dhɨ: «Mɨ́ logó sápɨ́ mɨ́na àrà nɨ na. Adré lèá má kòmvu tsì kópò kɨzà àdhya áma Atá dré afèle má dré mvùle nɨ ko?» ");
INSERT INTO log_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Gò Rómà kɨ sòdá nda ɨ, àyɨ kɨ kàdrɨ̀, tsàle Yúdà ànzɨ kɨ tépelò lɨkɨ́bhá nda ɨ́be dhɨ, ɨ̀ dré Yésu nɨ rùzo adròle. ");
INSERT INTO log_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ɨ̀ dré zyà akódhɨ nɨ drìzo lɨ̀zo ába Ánà, Kàyáfà nɨ andrì bhàna. Kàyáfà nda tá kòwánà kɨ kàdrɨ̀ ꞌɨ kóná nda kònàdhɨ sè. ");
INSERT INTO log_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Akódhɨ nda tá dhya tàlepi Yúdà ànzɨ ɨ dré dhɨ «Dóro nɨ, dhya àlo dré dràle móndyá wä́yi ɨ dré dhɨ» dhɨ ꞌɨ. ");
INSERT INTO log_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Sìmónà Pétèró ɨ Yésu nɨ lebèlepi àzya dhɨ be dhɨ, ɨ̀ adré tá lɨ̀le Yésu vésè. Kòwánà kɨ kàdrɨ̀ nì tá Yésu nɨ lebèlepi nda be go, à dré akódhɨ nɨ tayɨ́zó fɨ̀le Yésu vésè kòwánà kɨ kàdrɨ̀ nda nɨ bhàꞌálé na. ");
INSERT INTO log_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Dɨ, Pétèró totó tá ɨ́na ɨ adrélé kɨvɨ̀ na dzóti làga. Dɨ Yésu nɨ lebèlepi, kòwánà kɨ kàdrɨ̀ dré tá nìle be nda dré pfòzo tà ta mvátòkó adrélépi tá dzóti nda nɨ lɨkɨ́ dhɨ be gò, dré Pétèró nɨ ꞌòzo fɨ̀le. ");
INSERT INTO log_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Gò mvátòkó adrélépi dzóti lɨkɨ́ nda dré lizízóá Pétèró tí dhɨ: «Mɨ tsì dhya kòdhɨ nɨ lebèbhá kɨ àlo ꞌɨ ko?» Dɨ, Pétèró logó dhɨ: «Kóko, ma ꞌɨ ko.» ");
INSERT INTO log_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Àrà nda dré tá adrélé kɨdhɨ̀ ro dhɨ sè dhɨ, màrábà ɨ tépelò lɨkɨ́bhá ɨ́be dhɨ ɨ̀ turú tá àtsɨ́ gò, ɨ̀ dré àyɨ kɨ totózó làgásà adrélé yòá. Dɨ Pétèró dré kpà áyɨ totózó adrélé àtsɨ́ yo àyɨ kòfalé. ");
INSERT INTO log_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Dzó nda na dhɨ, kòwánà kɨ kàdrɨ̀ dré Yésu nɨ lizízó akódhɨ nɨ lebèbhá kɨ tà sè, ɨ̀ndɨ̀ tà dré adrélé tadhálé dhɨ kɨ tà sè. ");
INSERT INTO log_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Dɨ Yésu dré logózóá drá dhɨ: «Má tà tá mána tà ngádra ꞌá móndyá wä́yi dhɨ ɨ kandrá. Vésè wä́yi, má tadhá tá tà lɨ̀sámbò dzó ɨ ꞌásè ɨ̀ndɨ̀ tépelò na, àrà Yúdà ànzɨ wä́yi dhɨ ɨ̀ dré adrézó ru kɨmó nda ɨ ꞌásè. Má tà tá tà àlo dhɨ lùzu ró ko. ");
INSERT INTO log_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Mɨ́ adré dɨ tà lizí má tí àdho tà sè? Lè mɨ́ kòlizí tà móndyá áma kúlí yibhá dhɨ ɨ tí. Àyɨ nda ɨ̀ nì tà má dré tàle dhɨ ɨ dóro.» ");
INSERT INTO log_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yésu kòtà tà nda dre dhɨ, tépelò lɨkɨ́bhá kɨ àlo adrélépi tá ànyɨ làgá dhɨ dré akódhɨ nɨ mì sàzo gò, tàzoá drá dhɨ: «Mɨ́ adré kúlí logó kòwánà kɨ kàdrɨ̀ tí kònɨ̀nɨ?» ");
INSERT INTO log_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Dɨ Yésu logó drá dhɨ: «Má kòtà tà kònzɨ dhɨ, lè mɨ́ kòtadhá tà kònzɨ nda àma dré. Dɨ, má kòtà tà bàti kòdhya dhɨ, mɨ́ adré dɨ áma si àdho tà sè?» ");
INSERT INTO log_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Gò Ánà dré Yésu nɨ mùzo bǎ akódhɨ nɨ adròzo ásà dhɨ ɨ́be ɨ́ rú lɨ̀le Kàyáfà, kòwánà kɨ kàdrɨ̀ véna. ");
INSERT INTO log_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Dɨ Sìmónà Pétèró adré tá ɨ́na àtsɨ́ yo kɨvɨ̀ na. Gò lizízóá tíá dhɨ: «Mɨ tsì akódhɨ nɨ lebèbhá kɨ àlo ꞌɨ ko?» Dɨ Pétèró dré tà nda nɨ gàzo rè, tàzoá dhɨ: «Kóko, ma ꞌɨ ko.» ");
INSERT INTO log_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Gò kòwánà kɨ kàdrɨ̀ nɨ màrábà àlo, adrélépi tá dhya Pétèró dré tá bí bvwàle dhɨ nɨ aró ro dhɨ, dré tàzoá dhɨ: «Má nò tsì mɨ túmä́ní akódhɨ be amvú òlívè fa kya na ko?» ");
INSERT INTO log_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Dɨ Pétèró dré gòzo tódhyá tà nda nɨ ga rè. Gbǎ lókyá nda sè dhɨ, àgólòwa dré tsírà bhèzo. ");
INSERT INTO log_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ngá kòwa dre dhɨ, ɨ̀ dré Yésu nɨ drìzo Kàyáfà bhàlésè, lɨ̀zo ába Rómà kɨ gùvèrènérè nɨ dzó kàdrɨ̀ na. Dɨ, Yúdà ànzɨ Yésu nɨ dribhá nda ɨ̀ fɨ tá àyɨkya dzó kàdrɨ̀ nda na ko, ɨ̀ kàtsáró ndǐ ró ko, ɨ̀ kòkɨtswáró gwányá Pásɨkà àdhya nɨ nya be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Gò Pìlátò dré apfòzo àyɨ vélé, lizíá àyɨ tí dhɨ: «Mɨ̀ adré agó kònɨ̀dhɨ nɨ asíkì àdho tà sè?» ");
INSERT INTO log_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ɨ̀ logó drá dhɨ: «Akódhɨ kàdré tá drìkònzɨ líyí ꞌɨ ko dhɨ, kònò mà kɨtswá tá alɨ̀le akódhɨ nɨ fe mɨ́ drɨ́gá dhɨ ko.» ");
INSERT INTO log_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pìlátò tà àyɨ dré dhɨ: «Àmɨ kɨ tàndɨ mɨ̀ kòdo akódhɨ tàbvó tàle, ngóró àmɨ kɨ tátrɨ́trɨ́ kúlí dré adrélé lèle dhɨ tɨ́nɨ.» Dɨ Yúdà ànzɨ nda ɨ̀ logó drá dhɨ: «À adré móndɨ́ pfùma dràle dhɨ nɨ logá àma dré.» ");
INSERT INTO log_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Tà nda kòdhɨ atsá tá kònɨ̀nɨ, kɨtswálé kúlí Yésu dré tá tàle ɨ́ nɨ ngalè dra dràdrà kárá ángùdhi sè ya dhɨ kòꞌoró ru be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Dɨ Pìlátò dré gòzo fɨ̀le áyɨ dzó kàdrɨ̀ na gò, dré Yésu nɨ azízó, lizízóá tíá dhɨ: «Mɨ, mɨ ópɨ́ Yúdà ànzɨ kya ꞌɨ?» ");
INSERT INTO log_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yésu logó dhɨ: «Tà mɨ́ dré lizílé kòdhɨ angá ámɨ tàndɨ drìlésè? Kó ngalè, dhya àzya tà áma tà mɨ́ dré nɨ̀?» ");
INSERT INTO log_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Dɨ Pìlátò logó dhɨ: «Ma dhu Yúdà mvá ꞌɨ bàti? Ámɨ tàndɨ nɨ súrú ɨ kòwánà kàdrɨ̀ ɨ́be dhɨ, ɨ̀ afè mɨ má drɨ́gá àyɨ. Mɨ́ ꞌo àdho tà ꞌɨ?» ");
INSERT INTO log_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yésu logó dhɨ: «Áma òpɨ̀, òpɨ̀ bvò kòndɨ àdhya ꞌɨ ko. Áma òpɨ̀ kàdré tá òpɨ̀ bvò kòndɨ àdhya ꞌɨ dhɨ, kònò áma màrábà ɨ̀ pfu tá làpfú, má dré dhèzo Yúdà ànzɨ ɨ drɨ́gá ko dhɨ dre. Dɨ, áma òpɨ̀ ɨ́na òpɨ̀ kònwa dhɨ ꞌɨ ko.» ");
INSERT INTO log_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pìlátò lizí tíá dhɨ: «Mɨ dɨ mɨ́na ópɨ́ ꞌɨ?» Dɨ Yésu logó dhɨ: «Mɨ́ tà kyá tàle dhɨ, ma ópɨ́ ꞌɨ dhɨ. À ti ma ɨ̀ndɨ̀ má alɨ̀ bvò kònɨ̀dhɨ lé kɨtswálé tà bàti longó móndɨ́ ɨ dré. Dhya ángùdhi adrélépi tròle tà bàti rú dhɨ adré áma kúlí yi.» ");
INSERT INTO log_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Dɨ Pìlátò tà drá dhɨ: «Tà bàti nda àdho ꞌɨ?» Pìlátò kòtà tà nda dre dhɨ, dré gòzo pfòle kɨvɨ̀ na Yúdà ànzɨ ɨ véna gò, tàá àyɨ dré dhɨ: «Má kisú mána tà àlo tà bhàzo akódhɨ dri dhɨ ko. ");
INSERT INTO log_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Dɨ, gwányá Pásɨkà àdhya tú dhɨ, mɨ̀ adré àkodrà áma ti lizí, má kòtrɨ̀ró àmɨ dré móndɨ́ àlo ꞌɨ̀le bǎdzó na dhɨ. Mɨ̀ adré dɨ lèá dhɨ, má kòtrɨ̀ àmɨ dré ópɨ́ Yúdà ànzɨ kya kòdhɨ?» ");
INSERT INTO log_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Dɨ ɨ̀ dré ngàzo trèle, yòzoá kúlí ꞌuꞌù sè dhɨ: «Akódhɨ ko! Mɨ́ kàtrɨ̀ àma dré Bàrábà kòdhya!» Dɨ Bàrábà nda tá ɨ́na móndɨ́ kɨ kodzólépi lɨgɨ́lé àyɨ kɨ kàdrɨ̀ ɨ rú dhɨ ꞌɨ. ");
INSERT INTO log_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Dɨ Pìlátò dré Yésu nɨ tayɨ́zó drìle bhwàle. ");
INSERT INTO log_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Gò sòdá ɨ̀ dré fanzɨ̌ kùtsi ró dhɨ nɨ pàzo kùla ró asólé akódhɨ dri gò, kánzò kǎ asózó rúá. ");
INSERT INTO log_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Dɨ ɨ̀ dré adrézó alɨ̀le akódhɨ vélé adrélé tàá dhɨ: «Mòdo mɨ́ dré, ópɨ́ Yúdà ànzɨ kya nɨ!» Ɨ̀ adré tá kpà akódhɨ nɨ mì tosá. ");
INSERT INTO log_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Gò Pìlátò dré gòzo tódhyá pfòle kɨvɨ̀ na, tàá Yúdà ànzɨ ɨ dré dhɨ: «Mɨ̀ nò rè ká! Má adré akódhɨ nɨ ꞌo apfòle àmɨ kandrá, mɨ̀ kònìró dhɨ, má kisú mána tà àlo tà bhàzo akódhɨ dri dhɨ ko.» ");
INSERT INTO log_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Dɨ Yésu dré apfòzo kɨvɨ̀ le kùlá ledélé kùtsí sè dhɨ be ɨ́ dri, ɨ̀ndɨ̀ kánzò kǎ be ɨ́ rú. Pìlátò dré tàzoá àyɨ dré dhɨ: «Mɨ̀ nò rè agó kònɨ̀dhɨ ká!» ");
INSERT INTO log_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Dɨ kòwánà kàdrɨ̀ ɨ tépelò lɨkɨ́bhá ɨ́be dhɨ ɨ̀ kònò akódhɨ dre dhɨ, ɨ̀ dré ngàzo adrélé tetrélé, adrézó loyóá dhɨ: «Mɨ́ tidí akódhɨ fa kɨpakɨpa dri! Mɨ́ tidí akódhɨ!» Dɨ, Pìlátò logó àyɨ dré dhɨ: «Àmɨ kɨ tàndɨ, mɨ̀ do akódhɨ tidílé fa kɨpakɨpa dri àmɨ. Ma ró dhɨ, má kisú mána tà àlo tà bhàzo akódhɨ dri dhɨ ko.» ");
INSERT INTO log_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Yúdà ànzɨ ɨ̀ logó drá dhɨ: «Àma, àma tátrɨ́trɨ́ kúlí ɨ́be. Dɨ tátrɨ́trɨ́ kúlí nda adré lèá dhɨ, akódhɨ kòdràdrà dré áyɨ zìle Gìká nɨ Mváagó ro dhɨ sè.» ");
INSERT INTO log_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pìlátò kòyi tà nda dre dhɨ, tirì dré gòzo vélé akódhɨ nɨ ꞌo lavúlé. ");
INSERT INTO log_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Dɨ dré gòzo Yésu nɨ dri fɨ̀zo ába áyɨ dzó kàdrɨ̀ na gò, lizízóá tíá dhɨ: «Mɨ́ angá ángolésè?» Dɨ, Yésu logó ɨ́na kúlí ko. ");
INSERT INTO log_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pìlátò gò tàá drá dhɨ: «Mɨ́ adré tsì kòdhɨ agɨ́lé má tí? Mɨ́ nì ko tàle dhɨ, ma rìnyí ɨ́be ngalè ámɨ trɨ̀zo yà, kó ngalè ámɨ ꞌòzo tidílé fa kɨpakɨpa dri yà dhɨ?» ");
INSERT INTO log_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Dɨ Yésu logó drá dhɨ: «Kònò Gìká kòfè tá rìnyí nda mɨ́ dré ko dhɨ, mɨ́ kɨtswá tá tà àlo ꞌo má rú ko. Ásà dhɨ, dhya áma lefèlepi mɨ́ drɨ́gá dhɨ nɨ tàkonzɨ̀ kàdrɨ̀ mɨ́na nɨ lavú.» ");
INSERT INTO log_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Kɨdhólé lókyá nda sè dhɨ, Pìlátò dré kɨdhózó adrélé láti nda Yésu nɨ trɨ̀zo. Dɨ, Yúdà ànzɨ ɨ̀ dré kúlí yòzo tàzoá dhɨ: «Mɨ́ kòtrɨ̀ agó kòdhɨ dhɨ, mɨ Kàyìsárà nɨ arúpi ꞌɨ ko. Tàko ko, dhya ángùdhi adrélépi tàá dhɨ, ɨ ópɨ́ ꞌɨ dhɨ, adré ɨ́na lɨgɨ́lé Kàyìsárà rú.» ");
INSERT INTO log_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Dɨ Pìlátò kòyi kúlí nda dre dhɨ, dré Yésu nɨ ꞌòzo apfòle kɨvɨ̀ le. Gò dré lɨrɨ́zó lɨrɨ́rà adrézó móndɨ́ kɨ tàbvó ta dhɨ dri, àrà rú zìle Bhàꞌálé kɨ́rà sè dhɨ na. (Àrà nda nɨ rú Èbérè ti sè dhɨ «Gàbátà».) ");
INSERT INTO log_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Lókyá nda tá ànyɨ́ànyɨ kìtú rírí, kìtú adrézó tà ledé gwányá Pásɨkà àdhya dré dhɨ ꞌɨ. Pìlátò dré tàzoá Yúdà ànzɨ ɨ dré dhɨ: «Mɨ̀ nò rè àmɨ kɨ ópɨ́ kònɨ̀dhɨ ká!» ");
INSERT INTO log_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Dɨ ɨ̀ dré gòzo adrélé tetrélé, adrézó loyóá dhɨ: «Akódhɨ kòdràdrà! Kòdràdrà! Mɨ́ tidí akódhɨ fa kɨpakɨpa dri!» Pìlátò lizí àyɨ tí dhɨ: «Má kòtidí tsì àmɨ kɨ ópɨ́ fa kɨpakɨpa dri?» Dɨ kòwánà kàdrɨ̀ ɨ̀ logó dhɨ: «Àma kɨ ópɨ́ àzya yókódhó, ngbà ꞌí Kàyìsárà ꞌɨ kalóma.» ");
INSERT INTO log_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Gò Pìlátò dré Yésu nɨ fèzo àyɨ drɨ́gá, ɨ̀ kòtidíró akódhɨ fa kɨpakɨpa dri be dhɨ bvó. Dɨ ɨ̀ dré Yésu nɨ drìzo lɨ̀zo ába. ");
INSERT INTO log_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Akódhɨ dré áyɨ tàndɨ nɨ fa kɨpakɨpa dòzo lɨ̀zo pfòle ába tsàle àrà adrélé zìle Drìfà ro dhɨ na. (À adré àrà nda nɨ rú zi Èbérè ti sè dhɨ «Gòlògótà».) ");
INSERT INTO log_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Kònàle dhɨ, ɨ̀ dré akódhɨ nɨ tidízó fa kɨpakɨpa nda dri. Ɨ̀ dré kpà móndɨ́ rì àruka kɨ tidízó fa àruka ɨ drǐsè, àlo nɨ Yésu nɨ drɨ́ágó lésè, àzya nɨ lìdzí nɨ lésè, Yésu nɨ tàndɨ kɨ́tógá ꞌá. ");
INSERT INTO log_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pìlátò ꞌo tá wárágà tɨsɨ̀le gò, dìzoá fa kɨpakɨpa nda dri. À tɨsɨ̀ tá drìá dhɨ: «Yésu Nàzàrétà lésè dhɨ, ópɨ́ Yúdà ànzɨ kya.» ");
INSERT INTO log_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Yúdà ànzɨ zyandre dhɨ ɨ̀ dré wárágà nda nɨ nàzo. Tàko ko, àrà Yésu nɨ tidízó fa dri nda tá ànyɨ bhàandre làga, ɨ̀ndɨ̀ à tɨsɨ̀ tá wárágà nda Èbérè ti sè, Làtínò ti sè, ɨ̀ndɨ̀ Gìríkì ti sè. ");
INSERT INTO log_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Dɨ ásà dhɨ, Yúdà ànzɨ kɨ kòwánà kàdrɨ̀ ɨ̀ dré lɨ̀zo tàá Pìlátò dré dhɨ: «Mɨ́ kòtɨsɨ̀ ‹Ópɨ́ Yúdà ànzɨ kya› dhɨ ko. Be ró dhɨ, mɨ́ kòtɨsɨ̀ mɨ́na dhɨ: ‹Agó kònɨ̀dhɨ tà tá dhɨ, ɨ ópɨ́ Yúdà ànzɨ kya ꞌɨ.›» ");
INSERT INTO log_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Dɨ, Pìlátò dré logózóá dhɨ: «Tà má dré tɨsɨ̀le kòdhɨ, má tɨsɨ̀ dre.» ");
INSERT INTO log_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Sòdá ɨ̀ kòtidí Yésu fa kɨpakɨpa dri dre dhɨ, ɨ̀ dré akódhɨ nɨ kɨ́tá kɨ dòzo lanzɨ́lé àyɨ su dhɨ ɨ kòfalésè àlo àlo. Dɨ tayɨ́ tá ngbà ꞌí kɨ́tá kàtswa adrélé asólé kɨ́tá àzya ɨ zàle dhɨ kòdhya. À dhɨ tá kɨ́tá nda ngá àlo ró, kɨdhólé dri lésè tsàle pá na. ");
INSERT INTO log_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Dɨ ɨ̀ dré tàzoá àyɨ kòfalésè dhɨ: «Mà kòlasɨ́ ko. Be ró dhɨ, mà kòvù dzègé sè, nòzoá ngalè a nɨ adré àdhi dré ya dhɨ.» Tà nda kòdhɨ atsá tá kònɨ̀nɨ, kɨtswálé tà tɨsɨ̀le Gìká nɨ Kúlí na kònɨ̀dhɨ kòꞌoró ru: «Ɨ̀ lanzɨ́ áma kɨ́tá ɨ àyɨ kòfalésè, ɨ̀ vù kɨ́tá mána dzègé sè.» Dɨ tà kòdhɨ tà sòdá nda ɨ̀ dré ꞌòle dhɨ ꞌɨ. ");
INSERT INTO log_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ànyɨ Yésu nɨ fa kɨpakɨpa nda làga dhɨ, akódhɨ nɨ andre ɨ̀ adré tá àyɨ kɨ totó, túmä́ní andre nɨ nɨ amvúpi be, Màrɨ́yà Kòlópà nɨ tòkó be, ɨ̀ndɨ̀ Màrɨ́yà Màgàdàlénè be. ");
INSERT INTO log_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Dɨ Yésu kònò áyɨ andre túmä́ní áyɨ lebèlepi ɨ́ dré lèle tò dhɨ be dre dhɨ, dré tàzoá áyɨ andre dré dhɨ: «Tòkó, ámɨ mvá kònɨ̀dhɨ.» ");
INSERT INTO log_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Dré kpà tàzoá áyɨ lebèlepi nda dré dhɨ: «Ámɨ andre kònɨ̀dhɨ.» Dɨ kɨdhólé lókyá nda sè dhɨ, Yésu nɨ lebèlepi nda dré akódhɨ nɨ dòzo lɨkɨ́lé ɨ́ bhàna. ");
INSERT INTO log_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Àmvolásà dhɨ, Yésu kònì, tà títí dhɨ ɨ̀ ꞌo tá ru akɨ́lé dhɨ dre dhɨ, dré tàzoá dhɨ: «Yǐ lovó adré áma ꞌo.» Tà tá kònɨ̀nɨ kɨtswálé tà tɨsɨ̀le Gìká nɨ Kúlí na dhɨ kòꞌoró ru be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Lɨ̀drɨ́ àlo gàlepi vìnègárì sè dhɨ tá kònàle. Dɨ sòdá nda ɨ̀ dré ngá vòdhovódho dhɨ nɨ adózó sòle vìnègárì nda léna, dròzoá fanzɨ̌ rú zìle ɨ̀sópè dhɨ sílé gò, tɨngázóá kuru bhàle Yésu tí. ");
INSERT INTO log_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Dɨ Yésu kòmvu vìnègárì nda dre dhɨ, dré tàzoá dhɨ: «Tà títí dhɨ ɨ̀ ꞌo ru akɨ́lé dre.» Dré drì abhézó gò, áyɨ lɨ́drɨ̀ tayɨ́zó lɨ̀le. ");
INSERT INTO log_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Kìtú nda tá kìtú adrézó tà ledé sàbátù kandrá dhɨ ꞌɨ. Dɨ Yúdà ànzɨ kɨ kàdrɨ̀ ɨ̀ lè tá àyɨkya, sàbátù nda dré àbvò nda kɨ kɨ̀le fa kɨpakɨpa ɨ dri dhɨ ko. Tàko ko, sàbátù nda tá ɨ́na kàdrɨ̀, dré dhèle Pásɨkà tú dhɨ sè. Ásà dhɨ, ɨ̀ dré Pìlátò nɨ ti lizízó, kòꞌoró dhya tidílé fa ɨ dri nda kɨ pá toŋòle, ɨ̀ndɨ̀ àyɨ kɨ àbvò tɨrɨ́lé fa nda ɨ drìlésè. ");
INSERT INTO log_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Dɨ sòdá ɨ̀ dré lɨ̀zo dhya àlo tidílé túmä́ní Yésu be dhɨ nɨ pá kɨ toŋò. Gò ɨ̀ dré kpà dhya àzya tidílé dhɨ nɨ pá kɨ toŋòzo. ");
INSERT INTO log_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Dɨ, ɨ̀ kòtsa Yésu rú dre dhɨ, ɨ̀ dré kisúzóá dhɨ, drà dre. Ɨ̀ toŋò dɨ pá nɨ ɨ ko. ");
INSERT INTO log_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Dɨ, sòdá nda kɨ àlo dré ɨ́na Yésu nɨ sòzo gàrànzɨ ꞌá dɨ̀lɨ̀ sè gò, gbǎ kòdhwa, kàrɨ́ dré apfòzo yǐ be. ");
INSERT INTO log_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Dhya tà nda kòdhɨ kɨ nòlepi mì sè dhɨ adré tà nda kɨ longó nɨ̀. Dɨ tà dré adrélé longólé nda ɨ, tà bàti ꞌɨ. Akódhɨ nda nì tàle dhɨ, ɨ́ adré tà bàti ta dhɨ be. Adré tà nda kɨ longó, mɨ̀ kòkaꞌìró kpà tà nda ɨ be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Tà nda kòdhɨ atsá kònɨ̀nɨ, kɨtswálé tà tɨsɨ̀le Gìká nɨ Kúlí na kònɨ̀dhɨ kòꞌoró ru: «À kɨtswá akódhɨ nɨ fà kɨ àlo ŋo ko.» ");
INSERT INTO log_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Tà àzya Kúlí nda na dhɨ adré kpà tàá dhɨ: «Ɨ̀ nɨ dhya ɨ̀ dré sòle dhɨ nɨ no.» ");
INSERT INTO log_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Àmvolásà dhɨ, agó àlo rú be Yòséfà angálépi Àrìmàtáyà lésè dhɨ dré lɨ̀zo Pìlátò nɨ ti lizí, kòfèró láti ɨ́ dré Yésu nɨ rúbhá dòzo bhàle mógó na. Yòséfà nda tá Yésu nɨ lebèbhá kɨ àlo ꞌɨ. Dɨ, adré tá ɨ́na akódhɨ nɨ lebè lùzu ró, dré tá adrélé Yúdà ànzɨ kɨ kàdrɨ̀ kɨ ro dhɨ sè. Dɨ Pìlátò dré tà nda nɨ kaꞌìzo gò, Yòséfà dré lɨ̀zo rúbhá nda nɨ do. ");
INSERT INTO log_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nìkòdémò atú lɨ̀lepi Yésu véna ngátsi sè dhɨ dré kpà lɨ̀zo Yòséfà be. Akódhɨ nda do tá dò tàdzí be dóro ledélé mírè sè ɨ̀ndɨ̀ àlówè sè dhɨ ànyɨ́ànyɨ kìló nyadhɨ-àlo-drì-mudrí. ");
INSERT INTO log_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Dɨ àyɨ rìti nda ɨ̀ dré Yésu nɨ rúbhá dòzo, lambélé kɨ́tá kàtswákàtswa dhɨ ɨ sè gò, dò nda nɨ dàzo rúá, ànzyà gà Yúdà ànzɨ ɨ̀ dré adrélé ꞌòle àbvò sìzo dhɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Amvú àlo dhɨ tá ànyɨ àrà Yésu nɨ tidízó fa kɨpakɨpa dri nda làga. Amvú nda na dhɨ, à ga tá mógó tɨ́dhɨ́ dhɨ kɨ́rà na. À bhà tá rè móndɨ́ lána ko. ");
INSERT INTO log_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Dɨ kìtú nda dré tá adrélé kìtú adrézó tà ledé sàbátù kandrá dhɨ ꞌɨ sè dhɨ, ɨ̀ndɨ̀ mógó nda dré tá adrélé ànyɨ dhɨ sè dhɨ, ɨ̀ dré Yésu nɨ rúbhá bhàzo kònàle. ");
INSERT INTO log_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Drùbhì kɨ́nó ngá pfùnìpfùnì, kìtú nɨ àlo pósò àdhya sè dhɨ, Màrɨ́yà Màgàdàlénè dré ngàzo lɨ̀le mógó na. Dré nòzoá dhɨ, à tɨngá kɨ́rà mógó nda tísè dre. ");
INSERT INTO log_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Dɨ dré ràzo Sìmónà Pétèró kɨ kisú túmä́ní Yésu nɨ lebèlepi àzya dré lèle tò dhɨ be gò, tàzoá àyɨ dré dhɨ: «À do Mírì mógó lésè lɨ̀zo ába dre. Mà nì ngalè à bhà akódhɨ ángolé ya dhɨ ko!» ");
INSERT INTO log_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Dɨ Pétèró ɨ Yésu nɨ lebèlepi àzya nda be dhɨ ɨ̀ dré ngàzo láti do lɨ̀zo mógó na. ");
INSERT INTO log_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Àyɨ rìti nda ɨ̀ adré tá ràle rarà. Dɨ, Yésu nɨ lebèlepi àzya nda dré ɨ́na ràzo sɨ́rɨ́ tsàle mógó na drìdrì Pétèró kandrána. ");
INSERT INTO log_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Dré tandìzo kɨ́tá kàtswákàtswa tayɨ́lé dhɨ kɨ no mógó na. Dɨ, fɨ tá ɨ́na lána ko. ");
INSERT INTO log_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Sìmónà Pétèró adrélépi tá arálé akódhɨ vésè dhɨ dré kpà atsázó gò, fɨ̀le ndɨrɨ mógó na. Dré kɨ́tá kàtswákàtswa tayɨ́lé nda kɨ nòzo, ");
INSERT INTO log_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","kɨ́tá tá Yésu nɨ drì ndràzo ásà dhɨ be. À pa tá kɨ́tá nda bhàle gàrà dri, àrà twá kɨ́tá kàtswákàtswa nda kya rúsè dhɨ na. ");
INSERT INTO log_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Dɨ Yésu nɨ lebèlepi àzya atsálépi tá drìdrì nda dré kpà fɨ̀zo mógó na. Dré tà nda nɨ nòzo gò, kaꞌìzoá. ");
INSERT INTO log_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Tàko ko, atsálé kònàdhɨ dhɨ, tà tɨsɨ̀le Gìká nɨ Kúlí na dhɨ fɨ tá dhu rè àyɨ drìna ko. Dɨ ɨ̀ nì tá rè ko tàle dhɨ, lè tá Yésu kònga dràdrà ꞌásè dhɨ.) ");
INSERT INTO log_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Gò akódhɨ nɨ lebèbhá nda ɨ̀ dré gòzo nzɨ̀le àyɨ bhàna. ");
INSERT INTO log_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Dɨ, Màrɨ́yà totó tá ɨ́na ɨ adrélé ngòle kɨvɨ̀ na mógó nda làga. Dré tá adréràꞌa ngòle dhɨ ꞌá dhɨ, dré tandìzo ngá no mógó na gò, ");
INSERT INTO log_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ángéló rì kɨ́tá kemve asóbhá àyɨ rú dhɨ kɨ nòzo. Àyɨ nda ɨ̀ lɨrɨ́ tá àrà tá Yésu nɨ rúbhá bhàzo dhɨ ꞌá, àlo nɨ àrà drì nɨ nɨ bhàzo dhɨ lésè, àzya nɨ àrà pá nɨ nɨ bhàzo dhɨ lésè. ");
INSERT INTO log_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Dɨ ɨ̀ dré lizízóá tíá dhɨ: «Tòkó, mɨ́ adré ngòle àdho tà sè?» Akódhɨ logó àyɨ dré dhɨ: «À do áma Mírì dre. Má nì ngalè à bhà akódhɨ ángolé ya dhɨ ko.» ");
INSERT INTO log_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Kòtà tà tà nda dre dhɨ, dré áyɨ alázó Yésu nɨ no adréràꞌa áyɨ totó kònàle. Dɨ, nì tá ɨ́na tàle dhɨ, Yésu ꞌɨ dhɨ ko. ");
INSERT INTO log_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yésu dré lizízóá tíá dhɨ: «Tòkó, mɨ́ adré ngòle àdho tà sè? Mɨ́ adré àdhi nɨ nda?» Màrɨ́yà adré tá ɨ́na kisùá dhɨ, akódhɨ nda tá amvú lɨkɨ́lépi ꞌɨ. Dré dɨ tàzoá drá dhɨ: «Atálágó, mɨ́ kòdo akódhɨ mɨ dhɨ, mɨ́ tà má dré mɨ́ bhà akódhɨ ángolé ya dhɨ, má kòlɨ̀ró akódhɨ nɨ adó.» ");
INSERT INTO log_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yésu tà drá dhɨ: «Màrɨ́yà!» Dɨ Màrɨ́yà dré áyɨ alázó akódhɨ vélé, tàá drá Èbérè ti sè dhɨ: «Ràbbúnì!» (Rú nda kòdhɨ adré lèá tàle dhɨ «Tà tadhálépi».) ");
INSERT INTO log_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Dɨ Yésu tà drá dhɨ: «Mɨ́ ru ma ko. Tàko ko, má mbà rè áma Atá véna ko. Dɨ, mɨ́ lɨ̀ mɨ́na áma adrúpi ɨ véna tàá áyɨ dré dhɨ, má adré mbàle áma Atá adrélépi kpà àmɨ kɨ Atá ro dhɨ véna. Má adré mbàle áma Gìká adrélépi kpà àmɨ kɨ Gìká ro dhɨ véna.» ");
INSERT INTO log_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Dɨ Màrɨ́yà Màgàdàlénè dré lɨ̀zo longóá akódhɨ nɨ lebèbhá ɨ dré dhɨ: «Má nò mána Mírì dre!» Gò dré tà akódhɨ dré tá tàle ɨ́ dré dhɨ kɨ longózó àyɨ dré. ");
INSERT INTO log_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Kìtú nɨ àlo pósò àdhya nda nɨ ɨ̀ndró sè dhɨ, Yésu nɨ lebèbhá ɨ̀ kɨmó tá ru dzó àlo na, dzóti kɨ atsúzó gä́gä́, ɨ̀ dré tá adrélé Yúdà ànzɨ kɨ kàdrɨ̀ kɨ ro dhɨ sè. Dɨ Yésu dré alɨ̀zo áyɨ totó àyɨ kɨ kɨ́tógá ꞌá gò, tàá àyɨ dré dhɨ: «Tà kɨ̀drɨ́kɨ̀drɨ kàdré àmɨ ɨ́be!» ");
INSERT INTO log_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Kòtà tà nda dre dhɨ, dré áyɨ drɨ́gá kɨ tadházó àyɨ dré áyɨ gàrànzɨ be. Dɨ akódhɨ nɨ lebèbhá nda ɨ̀ dré lenzézó tò, ɨ̀ dré àyɨ kɨ Mírì nda nɨ nòle dhɨ sè. ");
INSERT INTO log_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Dɨ Yésu dré gòzo tódhyá tàá àyɨ dré dhɨ: «Tà kɨ̀drɨ́kɨ̀drɨ kàdré àmɨ ɨ́be! Ngóró áma Atá dré áma amùle dhɨ tɨ́nɨ dhɨ, má adré kókpà àmɨ kɨ mu.» ");
INSERT INTO log_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Kòtà tà nda dre dhɨ, dré laꞌa vòzo àyɨ dri gò, tàzoá àyɨ dré dhɨ: «Mɨ̀ kòkisú Tɨrɨ́ Lólo wà! ");
INSERT INTO log_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Dhya ángùdhi mɨ̀ dré dra tàkonzɨ̀ nɨ nɨ trìzo dhɨ, Gìká nɨ kókpà akódhɨ nda nɨ tàkonzɨ̀ tri. Dhya ángùdhi mɨ̀ dré dra tàkonzɨ̀ nɨ nɨ trìzo ko dhɨ, Gìká kɨtswá kókpà akódhɨ nda nɨ tàkonzɨ̀ tri ko.» ");
INSERT INTO log_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Dɨ, Tòmá, adrélé kpà rú zìle Làtí, Yésu nɨ lebèbhá mudrí-drì-rì dhɨ kɨ àlo dhɨ, tá ɨ́na àyɨ kòfalé yókódhó Yésu dré tá alɨ̌ràꞌa. ");
INSERT INTO log_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Dɨ Yésu nɨ lebèbhá àruka nda ɨ̀ dré tàzoá drá dhɨ: «Mà nò Mírì dre!» Dɨ, akódhɨ logó àyɨ dré dhɨ: «Má kònò nä́rì kɨ fúdrì akódhɨ nɨ drɨ́gálé ꞌá, áma drɨ́gámbɨ́lɨ́ sòzo lána gò, áma drɨ́gá sòzo akódhɨ nɨ gàrànzɨ na ko dhɨ, má kɨtswá mána kaꞌìá bwà ko!» ");
INSERT INTO log_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Dɨ kìtú nzi-drì-na àmvolésè dhɨ, Yésu nɨ lebèbhá ɨ̀ dré gòzo tódhyá ru kɨmó dzó nda na. Tòmá tá ɨ́na àyɨ kòfalé be. Tágba à dré tá dzóti nda kɨ atsúzó dhɨ, Yésu dré alɨ̀zo áyɨ totó àyɨ kɨ kɨ́tógá ꞌá gò, tàá àyɨ dré dhɨ: «Tà kɨ̀drɨ́kɨ̀drɨ kàdré àmɨ ɨ́be!» ");
INSERT INTO log_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Gò dré tàzoá Tòmá dré dhɨ: «Mɨ́ so ámɨ drɨ́gámbɨ́lɨ́ kònwa. Mɨ́ nò áma drɨ́gá ɨ. Mɨ́ so kpà ámɨ drɨ́gá áma gàrànzɨ na. Mɨ́ kòtayɨ́ tà kayima gò, adrézó áma kaꞌì!» ");
INSERT INTO log_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Dɨ Tòmá tà drá dhɨ: «Áma Mírì, áma Gìká!» ");
INSERT INTO log_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Gò Yésu dré tàzoá drá dhɨ: «Mɨ́ adré áma kaꞌì, mɨ́ dré áma nòle dre dhɨ sè. Dɨ, kólénzé ɨ́na móndyá adrébhá áma kaꞌì áma no àko ró dhɨ ɨ dré!» ");
INSERT INTO log_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yésu ꞌo tá tà lɨ́ndrɨ́ga ró àruka bǐ dhɨ ɨ áyɨ lebèbhá ɨ mi. À tɨsɨ̀ tà nda ɨ búkù kònɨ̀dhɨ léna ko. ");
INSERT INTO log_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Dɨ, à tɨsɨ̀ tà kòdhɨ ɨ, mɨ̀ kòkaꞌìró dhɨ, Yésu Mèsɨ́yà ꞌɨ, ɨ̀ndɨ̀ Gìká nɨ Mváagó ꞌɨ gò, àmɨ kɨ tà kaꞌìkaꞌì nda sè dhɨ, mɨ̀ kàdréró lɨ́drɨ̀ ɨ́be akódhɨ léna be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Àmvolásà dhɨ, Yésu dré gòzo tódhyá áyɨ tadhá áyɨ lebèbhá ɨ dré tä́pä́ríandre Tìbèríyà àdhya mìle. Tà nda ꞌo ru kònɨ̀nɨ: ");
INSERT INTO log_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Sìmónà Pétèró, Tòmá adrélé kpà rú zìle Làtí dhɨ, Nàtànàyélè angálépi Kánà Gàlìláyà le dhɨ lésè dhɨ, Zèbèdáyò nɨ ànzɨàgo ɨ, tsàle Yésu nɨ lebèbhá rì àruka ɨ́be dhɨ ɨ tá túmä́ní tä́pä́ríandre nda mìle. ");
INSERT INTO log_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Dɨ Sìmónà Pétèró dré tàzoá àyɨ dré dhɨ: «Má adré lɨ̀le kosyá bhe.» Ɨ̀ tà drá dhɨ: «Mà nɨ kpà lɨ túmä́ní mɨ́ be.» Dɨ ɨ̀ dré tombàzo bwátù na gò, lɨ̀le kosyá bhe yǐ nɨ tä́lí na. Dɨ, ngátsi nda sè dhɨ, ɨ̀ kisú tá àyɨkya ngá àlo ko. ");
INSERT INTO log_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ngá kòwa dre dhɨ, Yésu totó tá ɨ adrélé tä́pä́ríandre nda mìle. Dɨ, akódhɨ nɨ lebèbhá ɨ̀ nì tá àyɨkya tàle dhɨ, dhya nda Yésu ꞌɨ dhɨ ko. ");
INSERT INTO log_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Dɨ Yésu dré kúlí yòzo tàzoá àyɨ dré dhɨ: «Áma ànzɨ ɨ, mɨ̀ ru tsì kosyá ꞌí?» Ɨ̀ logó drá dhɨ: «Kóko.» ");
INSERT INTO log_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Dɨ Yésu tà àyɨ dré dhɨ: «Mɨ̀ kòbhe àmɨ kɨ kɨmbá bwátù nɨ drɨ́ágó lésè gò, mɨ̀ kòkisúró kosyá.» Ɨ̀ dré dɨ bhèzoá gò, ɨ̀ dré kɨtswázó kɨmbá nda nɨ asé bwà ko, kosyá dré gàle lána zyandre ró dhɨ sè. ");
INSERT INTO log_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Dɨ Yésu nɨ lebèlepi dré lèle tò dhɨ dré tàzoá Pétèró dré dhɨ: «Mírì ꞌɨ!» Sìmónà Pétèró kòyi akódhɨ tǎràꞌa dhɨ «Mírì ꞌɨ» dre dhɨ, dré kɨ́tá ɨ́ dré tá ngɨ̀le ɨ́ rúsè kɨtswázó kosyá bhe dhɨ nɨ adózó asólé ɨ́ rú gò, áyɨ bhèzo yǐ na. ");
INSERT INTO log_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Yésu nɨ lebèbhá àruka nda ɨ̀ dré kpà gòzo bwátù be, adrélé kɨmbá gàlepi kosyá sè bǐ nda nɨ se àmvòràmvò. Àngyá ko, ɨ̀ vwà tá yǐ mìlésè ko, ngbà ꞌí ànyɨ́ànyɨ méterè nyadhɨ-nzi. ");
INSERT INTO log_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ɨ̀ kòtsa sìle kìní mi dre dhɨ, ɨ̀ dré àtsɨ́ turúlé dhɨ nɨ nòzo, túmä́ní kosyá tobhàle drìá dhɨ ɨ́be, ɨ̀ndɨ̀ mápà be. ");
INSERT INTO log_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Dɨ Yésu dré tàzoá àyɨ dré dhɨ: «Mɨ̀ alɨ̀ kosyá àruka mɨ̀ dré rùle dhɨ ɨ́be.» ");
INSERT INTO log_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Dɨ Sìmónà Pétèró dré mbàzo bwátù na gò, kɨmbá nda nɨ asé apfòle kìní mi. Kɨmbá nda ga tá kosyá kàdrɨ̀kàdrɨ̀ kámá-àlo-drì-nyadhɨ-ri-drì-mudrí-drì-na dhɨ ɨ sè. Dɨ, tágba kosyá nda ɨ̀ dré tá adrézó zyandre ró dhɨ, kɨmbá nda tɨkɨ́ tá ko. ");
INSERT INTO log_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yésu dré tàzoá àyɨ dré dhɨ: «Mɨ̀ alɨ̀ ngá nya.» Akódhɨ nɨ lebèbhá nda kɨ àlo lizí tá ngalè akódhɨ àdhi ꞌɨ ya dhɨ ko. Tàko ko, ɨ̀ nì tàle dhɨ, akódhɨ Mírì ꞌɨ káyà dhɨ be. ");
INSERT INTO log_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Dɨ Yésu dré áyɨ kisízó ànyɨ àyɨ làga, mápà nda nɨ adó lanzɨ́lé àyɨ dré. Dré kpà ꞌòzoá kònɨ̀nɨ kosyá nda ɨ sè. ");
INSERT INTO log_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Dɨ kòrɨ̀dhɨ, vésè nɨ na Yésu dré áyɨ tadházó áyɨ lebèbhá ɨ dré, áyɨ ngàma dràdrà ꞌásè dhɨ àmvolésè dhɨ ꞌɨ. ");
INSERT INTO log_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ɨ̀ kònya ngá dre dhɨ, Yésu dré tàzoá Sìmónà Pétèró dré dhɨ: «Sìmónà, Yòwánɨ̀ nɨ mvá, mɨ́ adré áma le bàti àyɨ kònɨ kya kɨ lavú?» Akódhɨ logó drá dhɨ: «Àyíya, Mírì, mɨ́ nì tàle dhɨ, má adré ámɨ le dhɨ be.» Dɨ Yésu tà drá dhɨ: «Mɨ́ kàdré áma kábilígyà ànzɨ kɨ lɨkɨ́.» ");
INSERT INTO log_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yésu gò akódhɨ nɨ lizí vésè nɨ rì sè tàzoá dhɨ: «Sìmónà, Yòwánɨ̀ nɨ mvá, mɨ́ adré áma le bàti?» Akódhɨ logó drá dhɨ: «Àyíya, Mírì, mɨ́ nì tàle dhɨ, má adré ámɨ le dhɨ be.» Dɨ Yésu tà drá dhɨ: «Mɨ́ kàdré áma kábilígyà kɨ lɨkɨ́.» ");
INSERT INTO log_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yésu gò akódhɨ nɨ lizí vésè nɨ na sè tàzoá dhɨ: «Sìmónà, Yòwánɨ̀ nɨ mvá, mɨ́ adré áma le?» Kɨzà dré Pétèró nɨ ꞌòzo, Yésu dré tá lizílé tíá vésè nɨ na sè dhɨ «Mɨ́ adré áma le?» ya dhɨ sè. Dɨ Pétèró dré logózóá drá dhɨ: «Mírì, mɨ́ nì mɨ́na tà títí dhɨ ɨ be. Mɨ́ nì tàle dhɨ, má adré ámɨ le dhɨ be!» Dɨ Yésu tà drá dhɨ: «Mɨ́ kàdré áma kábilígyà kɨ lɨkɨ́. ");
INSERT INTO log_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Má adré tà bàti ta mɨ́ dré: Mɨ́ dré tá adréràꞌa kàdhúrà ro dhɨ ꞌá dhɨ, mɨ́ adré tá ámɨ tàndɨ nɨ káfà ꞌɨ ámɨ kípílé ꞌá gò, mɨ́ dré adrézó lɨ̀le àrà ángùdhi mɨ́ dré adrézó lèle lɨ̀le lána dhɨ na. Dɨ, mɨ́ kònɨ̀ dra atsá màlɨ̀ga ró dhɨ, mɨ́ nɨ mɨ́na ámɨ drɨ́gá kɨ kɨdzɨ̀ gò, dhya àzya dré ámɨ káfà ꞌɨ̀zo ámɨ kípílé ꞌá, ámɨ drìzo lɨ̀zo mɨ́ be àrà mɨ́ dré lèzo lɨ̀le lána ko dhɨ na.» ");
INSERT INTO log_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yésu tà tá kònɨ̀nɨ tadházóá dhɨ, Pétèró nɨ dra dràdrà kárá ángùdhi sè ya dhɨ, ɨ̀ndɨ̀ akódhɨ nɨ dràdrà nda nɨ lɨndrɨ̀ fe Gìká dré ngɨ́nɨ ya dhɨ. Dɨ Yésu kòtà tà nda dre dhɨ, dré tàzoá drá dhɨ: «Mɨ́ kàdré áma lebè!» ");
INSERT INTO log_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Gò Pétèró dré áyɨ alázó, Yésu nɨ lebèlepi dré lèle tò dhɨ nɨ no adréràꞌa alɨ̀le àyɨ vésè. (Akódhɨ nda tá dhya áyɨ bhèlepi Yésu agá mɨ́sá làga gò, lizíá tíá dhɨ «Mírì, àdhi nɨ ámɨ lefè kàrɨbhá ɨ drɨ́gá nɨ̀?» ya dhɨ ꞌɨ.) ");
INSERT INTO log_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Dɨ Pétèró kònò akódhɨ nda dre dhɨ, dré lizízóá Yésu tí dhɨ: «Mírì, kàdré dɨ dhya kònɨ̀dhɨ nɨ tà sè dhɨ, tà nɨ nɨ adré ngɨ́nɨ?» ");
INSERT INTO log_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yésu logó drá dhɨ: «Má kòlè akódhɨ kàdré lɨ́drɨ̀ ɨ́be tsàle lókyá má dré dra agòzo dhɨ ꞌá dhɨ, kòdhɨ ámɨ tà ꞌɨ? Mɨ, mɨ́ kàdré mɨ́na áma lebè!» ");
INSERT INTO log_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Dɨ tà nda sè dhɨ, rúbí dré laꞌúzó Yésu nɨ kaꞌìbhá ɨ kòfalé tàá dhɨ, akódhɨ nɨ lebèlepi nda kɨtswá ɨ́na dràle ko. Tákò, Yésu tà tá dhɨ, dhya nda kɨtswá dràle ko dhɨ ko. Be ró dhɨ, tà tá ɨ́na dhɨ: «Má kòlè akódhɨ kàdré lɨ́drɨ̀ ɨ́be tsàle lókyá má dré dra agòzo dhɨ ꞌá dhɨ, kòdhɨ ámɨ tà ꞌɨ?» ");
INSERT INTO log_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Yésu nɨ lebèlepi nda, dhya tà nda kòdhɨ kɨ nòlepi mì sè gò, dré adrézó tà nda kɨ longó, adrézó tɨsɨ̀á wárágà kònɨ̀dhɨ léna dhɨ ꞌɨ. Mà nì tàle dhɨ, tà dré adrélé longólé nda ɨ tà bàti ꞌɨ dhɨ be. ");
INSERT INTO log_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yésu ꞌo tá kpà tà àruka ɨ bǐ. Má adré kisùá dhɨ, kònò à kòtɨsɨ̀ tá tà nda ɨ àlo àlo títí búkù ɨ léna dhɨ, àrà búkù nda kɨ tobhàzo bvò kònɨ̀dhɨ lé dhɨ nɨ tá adré yókódhó.");
INSERT INTO log_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Atálágó Tèyòfílè, áma búkù drìdrì dhɨ léna dhɨ, má tɨsɨ̀ tá tà títí Yésu dré ꞌòle ɨ̀ndɨ̀ tadhálé, kɨdhólé áyɨ àzí nɨ kɨdhoma lésè, ");
INSERT INTO log_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","tsàle kìtú áyɨ doràꞌa bhù na dhɨ ꞌá dhɨ ɨ. Drìdrì akódhɨ nɨ dòzo dhɨ kandrá dhɨ, lazí tá tà àpóstolò ɨ́ dré tá kɨpèle dhɨ ɨ dri Tɨrɨ́ Lólo nɨ rìnyí sè. ");
INSERT INTO log_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Tàko ko, akódhɨ nɨ dràma àmvolésè dhɨ, tadhá tá áyɨ tàndɨ vésè be bǐ àyɨ nda ɨ kandrá gò, dré tà bǐ dhɨ kɨ ꞌòzo tadházóá ngádra ꞌá dhɨ, ɨ lɨ́drɨ̀ ɨ́be káyà dhɨ. Agá tá àyɨ kandrá tà ta àyɨ dré Gìká nɨ Òpɨ̀ nɨ tà dri kìtú nyadhɨ-rì. ");
INSERT INTO log_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Kìtú àlo, Yésu dré tá adréràꞌa ngá nya àyɨ ɨ́be dhɨ ꞌá dhɨ, lazí tá tà àyɨ dri kònɨ̀nɨ: «Lè mɨ̀ kònga Yèrúsalémà ꞌásè ko. Be ró dhɨ, mɨ̀ kàdré tà áma Atá dré lazílé gò, má dré tà nɨ nɨ tàzo àmɨ dré dhɨ nɨ letè. ");
INSERT INTO log_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Tàko ko, Yòwánɨ̀ fè tá ɨ́na bàtísimò móndɨ́ ɨ dré dhɨ yǐ sè. Dɨ, tayɨ́ ngbà ꞌí lókyá tsà, mɨ̀ dré àmɨkya bàtísimò kisúzó Tɨrɨ́ Lólo sè.» ");
INSERT INTO log_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Àpóstolò nda ɨ̀ kòkɨmó ru Yésu làga dre dhɨ, ɨ̀ dré lizízóá tíá dhɨ: «Mírì, mɨ́ nɨ go Ɨ̀sèrélè ànzɨ kɨ òpɨ̀ bha áyɨ totó tódhyá gbǎ lókyá kònɨ̀dhɨ sè?» ");
INSERT INTO log_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Dɨ Yésu logó àyɨ dré dhɨ: «Lókyá ɨ̀ndɨ̀ kìtú áma Atá dré bhàle áyɨ tàndɨ nɨ rìnyí sè dhɨ kɨ nìma, àmɨ kɨ tà ꞌɨ ko. ");
INSERT INTO log_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Dɨ, lókyá Tɨrɨ́ Lólo dré dra asízó àmɨ kɨ asó dhɨ tú dhɨ, mɨ̀ nɨ rìnyí kisú. Gò mɨ̀ dré áma tà mɨ̀ dré nòle ɨ̀ndɨ̀ mɨ̀ dré yìle dhɨ kɨ longózó kɨdhólé Yèrúsalémà ꞌa, bvò Yùdáyà àdhya na, bvò Sàmàrɨ́yà àdhya na, tsàle byá bvò nɨ kùdù na.» ");
INSERT INTO log_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Yésu kòtà tà nda ɨ dre dhɨ, Gìká dré akódhɨ nɨ dòzo bhù na àyɨ misè gò, ndùrùku dré akódhɨ nɨ kɨmózó. ");
INSERT INTO log_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Dɨ dré tá adréràꞌa mbàle, ɨ̀ndɨ̀ ɨ̀ dré adréràꞌa ngá no bhù na dhɨ ꞌá dhɨ, àgo rì kɨ́tá kemve asóbhá àyɨ rú dhɨ ɨ̀ dré agázó ngbǒ ró àyɨ mìle gò, ");
INSERT INTO log_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","tàá àyɨ dré dhɨ: «Àmɨ móndyá Gàlìláyà àdhya nɨ ɨ, mɨ̀ totó àmɨ adrélé ngá no bhù na àdho tà sè? Yésu dòle àmɨ vélésè bhù na kòdhɨ nɨ agò làsú be ngóró mɨ̀ dré akódhɨ nɨ nòle mbǎràꞌa bhù na dhɨ tɨ́nɨ.» ");
INSERT INTO log_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Gò àpóstolò nda ɨ̀ dré sìzo kòngó Òlívè fa kya drìlésè, atsí kɨtswálé tòle sàbátù tú bwà dhɨ nɨ to gòzo Yèrúsalémà na. ");
INSERT INTO log_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ɨ̀ kòtsa bhàandre nda na dre dhɨ, ɨ̀ dré fɨ̀zo mbàle dzó ꞌa kɨ̀le kurú na ɨ̀ dré tá adrézó adrélé lána dhɨ na. Àyɨ nda ɨ tá: Pétèró, Yòwánɨ̀, Yàkóbhò, Àndréyà, Fìlípò, Tòmá, Bàràtòlòmáyò, Màtáyò, Yàkóbhò (Àlàfáyò nɨ mvá), Sìmónà (dhya adrélépi tá àtsɨ ró áyɨ súrú nɨ tà sè dhɨ), tsàle Yùdásɨ̀ (Yàkóbhò nɨ mvá). ");
INSERT INTO log_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Àyɨ nda ɨ̀ adré tá ru kɨmó títí, adrélé tà ta Gìká be togó àlo sè landè àko ró. Ɨ̀ adré tá ꞌòá kònɨ̀nɨ túmä́ní tòkó àruka ɨ́be, Màrɨ́yà Yésu nɨ andre be, ɨ̀ndɨ̀ adrúpi nɨ ɨ́be. ");
INSERT INTO log_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Kìtú nda kòna kɨ àlo sè dhɨ, Yésu nɨ kaꞌìbhá ànyɨ́ànyɨ kámá-àlo-drì-nyadhɨ-àlo dhɨ ɨ̀ kɨmó tá ru. Gò Pétèró dré ngàzo áyɨ totó àyɨ kòfalé tàá dhɨ: ");
INSERT INTO log_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«Áma adrúpi ɨ, adré tá lèá dhɨ, tà Tɨrɨ́ Lólo dré tá longólé Dàwídì tí Yùdásɨ̀ nɨ tà dri gò, tɨsɨ̀zoá Gìká nɨ Kúlí na dhɨ kòꞌo ru. Yùdásɨ̀ nda fè tá ɨ́na ɨ dhya Yésu nɨ lebhá rùle dhɨ kɨ adrì dhɨ nɨ̀. ");
INSERT INTO log_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Akódhɨ tá àma kɨ àlo ꞌɨ, ɨ̀ndɨ̀ Mírì tayɨ́ tá àzí kònɨ̀dhɨ àma drɨ́gá akódhɨ be. ");
INSERT INTO log_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Làfa akódhɨ dré kisúlé tà kònzɨ ɨ́ dré ꞌòle nda sè dhɨ sè dhɨ, gɨ tá amvú gò, dhèzo amvú nda na tsílítsili ró, ꞌa lafúlé gò, fɨ́ nɨ ɨ̀ dré adàzo títí kìní mi. ");
INSERT INTO log_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Móndyá títí Yèrúsalémà ꞌa dhɨ ɨ̀ yi tá tà nda nɨ rúbí ꞌí. Ásà dhɨ, ɨ̀ dré amvú nda nɨ rú zìzo àyɨ kɨ bhàti sè ‹Àkèlèdámà›. Rú nda adré lèá tàle dhɨ ‹Amvú kàrɨ́ àdhya›. ");
INSERT INTO log_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Tàko ko, à tɨsɨ̀ tá búkù Yúdà ànzɨ kɨ Longó kya na dhɨ: ‹Lè akódhɨ nɨ bhà kàtsá tándró ro. Lè kpà dhya àlo kòmo bhà àrà nda na ko.› À tɨsɨ̀ kpà dhɨ: ‹Lè móndɨ́ àzya kòdo akódhɨ nɨ àzí akódhɨ nɨ àrà ꞌa.› ");
INSERT INTO log_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Ásà dhɨ, lè mà kòkɨpè móndɨ́ àzya àzí do Yùdásɨ̀ nɨ àrà ꞌa, móndyá adrébhá tá túmä́ní àma ɨ́be lókyá wä́yi mà dré tá adréràꞌa tatsílé Mírì Yésu be dhɨ ꞌá dhɨ ɨ kòfalé. Àyɨ nda ɨ tá àma kòfalé kɨdhólé Yòwánɨ̀ dré bàtísimò fèzo Yésu dré dhɨ sè, atsálé kìtú akódhɨ nɨ doràꞌa àma vélésè dhɨ ꞌá. Adré lèá dhɨ, dhya dra kɨpèle nda kàmú ɨ àma Mírì nɨ tà nobhá mì sè nɨ ɨ́be, mà kàdréró Mírì nɨ ngàma dràdrà ꞌásè dhɨ nɨ tà longó túmä́ní akódhɨ be móndɨ́ ɨ dré.» ");
INSERT INTO log_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Dɨ ɨ̀ dré móndɨ́ rì dhɨ kɨ bhàzo àyɨ kandrá: Yòséfà adrélé kpà rú zìle Bàràsábà, rú àzya be Yúsitò dhɨ, ɨ̀ndɨ̀ Màtɨ́yà be. ");
INSERT INTO log_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Gò ɨ̀ dré tà zìzo Gìká tí kònɨ̀nɨ: «Mírì, mɨ́ nì mɨ́na móndyá títí dhɨ kɨ togó be. Mɨ́ tadhá àma dré dhya mɨ́ dré kɨpèle àyɨ rì kònɨ ɨ kòfalé dhɨ kòdhya, ");
INSERT INTO log_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","akódhɨ nda kòdoró àzí àma adrébhá àpóstolò ro nɨ ɨ kòfalé Yùdásɨ̀ nɨ àrà ꞌa. Tàko ko, Yùdásɨ̀ tayɨ́ ɨ́na àzí nda lɨ̀zo àrà kɨtswálépi ɨ́ dré dhɨ na.» ");
INSERT INTO log_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Gò ɨ̀ dré dzègé vùzo àyɨ rì nda kɨ rú sè. Màtɨ́yà dré lavúzó, gò ɨ̀ dré akódhɨ nɨ bhàzo àpóstolò mudrí-drì-àlo nda ɨ rú. ");
INSERT INTO log_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Kìtú gwányá Pàtèkótè àdhya dré atsázó dhɨ sè dhɨ, Yésu nɨ kaꞌìbhá ɨ̀ kɨmó tá ru adrélé títí àrà àlo dhɨ na. ");
INSERT INTO log_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Gbǎ kòdhwa, kpòrò dré ndròzo bhù lésè ngóró lyǎandre gú dhɨ dré adrélé avílé dhɨ tɨ́nɨ gò, kpòrò nda dré afɨ́zó gàle dzó ɨ̀ dré tá adrézó lɨrɨ́lé lána dhɨ léna. ");
INSERT INTO log_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Gò ɨ̀ dré ngá ngóró àtsɨ́ làdra tɨ́nɨ dhɨ nɨ nòzo ru lanzɨ́ràꞌa asílé lɨrɨ́lé àyɨ àlo àlo títí dhɨ ɨ drǐsè. ");
INSERT INTO log_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Dɨ àyɨ títí dhɨ ɨ̀ dré gàzo Tɨrɨ́ Lólo sè gò, ɨ̀ dré ngàzo adrélé ti twátwa kɨ ta, ngóró Tɨrɨ́ nda dré adrélé bhàle àyɨ tí dhɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Lókyá nda sè dhɨ, móndɨ́ zyandre Yúdà ànzɨ ró angábhá súrú títí bvò drì dhɨ ɨ lésè, adrébhá kpà tròle Gìká nɨ tà rú dhɨ ɨ̀ adré tá adrélé Yèrúsalémà ꞌa. ");
INSERT INTO log_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Dɨ ɨ̀ kòyi kpòrò nda dre dhɨ, ɨ̀ dré ru kɨmózó zyandre ró gò, àyɨ kɨ drì dré abɨ́zó, àyɨ àlo àlo títí dhɨ ɨ̀ dré adrélé àyɨ nda kɨ yi adréràꞌa àyɨ kɨ tàndɨ kɨ ti ta dhɨ sè. ");
INSERT INTO log_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Dɨ àyɨ kɨ lɨ́ndrɨ́ dré gàzo bhwǎbhwa gò, ɨ̀ dré adrézó tàá dhɨ: «Móndyá títí adrébhá tà ta kònɨ ɨ tsì móndɨ́ Gàlìláyà lésè dhɨ ꞌɨ ko? ");
INSERT INTO log_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Dɨ àma àlo àlo títí dhɨ ɨ, mà adré àyɨ kɨ yi adréràꞌa àma kɨ tàndɨ kɨ ti ta ngɨ́nɨngɨ́nɨ ró? ");
INSERT INTO log_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Àma kòfalé dhɨ, móndɨ́ àruka ɨ̀ angá bvò Pàrùtíyà àdhya lésè, Mèdɨ́yà àdhya lésè, Èlámà àdhya lésè, Mèsòpòtàmɨ́yà àdhya lésè, Yùdáyà àdhya lésè, Kàpàdòkɨ́yà àdhya lésè, Pótò àdhya lésè, Àsɨ́yà àdhya lésè, ");
INSERT INTO log_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Fìrìgíyà àdhya lésè, Pàfìlíyà àdhya lésè, Èzèpétò àdhya lésè, àrà ànyɨ Kìrénè làga bvò Lìbíyà àdhya na dhɨ lésè, bhàandre Rómà àdhya lésè, ");
INSERT INTO log_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","tùrù Kùrétè àdhya lésè, ɨ̀ndɨ̀ bvò Àràbɨ́yà àdhya lésè. Àma kɨ àruka ɨ Yúdà ànzɨ ꞌɨ. Àruka nɨ ɨ kó móndɨ́ súrú twá ro Yúdà ànzɨ kɨ Gìká nɨ kaꞌìbhá dhɨ ꞌɨ. Dɨ àma títí, mà adré àyɨ kɨ yi adréràꞌa tà kàdrɨ̀kàdrɨ̀ Gìká dré ꞌòle dhɨ kɨ tà ta àma kɨ tàndɨ kɨ ti sè!» ");
INSERT INTO log_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Dɨ àyɨ títí nda kɨ lɨ́ndrɨ́ adré tá gàle bhwǎbhwa, àyɨ kɨ drì dré kpà adrézó abɨ́lé gò, ɨ̀ dré adrézó lizíá àyɨ kòfalésè dhɨ: «Tà kòdhɨ adré lèá tàle ngɨ́nɨ?» ");
INSERT INTO log_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Dɨ, àyɨ kɨ àruka ɨ̀ adré tá àyɨkya Yésu nɨ kaꞌìbhá nda kɨ gu, adrézó tàá dhɨ: «Ɨ̀ adré dràle wá lìtsí dré!» ");
INSERT INTO log_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Dɨ Pétèró ɨ àpóstolò mudrí-drì-àlo àruka nda ɨ́be dhɨ, ɨ̀ dré ngàzo àyɨ kɨ totó móndyá zyandre nda ɨ kandrá gò, akódhɨ dré kúlí yòzo tàzoá àyɨ dré dhɨ: «Àmɨ Yúdà ànzɨ ró nɨ ɨ, ɨ̀ndɨ̀ àmɨ títí adrébhá adrélé Yèrúsalémà ꞌa nɨ ɨ, mɨ̀ ga rè bíbhálé má vélé ká! Lè mɨ̀ kònì tà adrélépi lavúlé kòdhɨ dóro. ");
INSERT INTO log_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Wá adré móndyá kònɨ kɨ tsi nɨ̀ ngóró mɨ̀ dré adrélé kisùle dhɨ tɨ́nɨ ko. Tàko ko, dhu rè tɨ̀dzɨ́ ꞌɨ. ");
INSERT INTO log_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Be ró dhɨ, tà kòdhɨ ɨ́na tà pròfétà Yòwélè dré tá longólé dhɨ ꞌɨ: ");
INSERT INTO log_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‹Gìká tà dhɨ: Lókyá kùdù sè dhɨ, má nɨ áma Tɨrɨ́ kutú móndyá títí ɨ dri. Dɨ àmɨ kɨ ànzɨàgo ɨ àmɨ kɨ ànzɨtòkó ɨ́be dhɨ kɨ tà longó pròfétà kya tɨ́nɨ. Àmɨ kɨ kàdhúrà kɨ ngá dra agábhá àyɨ mi toróbɨ́ tɨ́nɨ dhɨ kɨ no, ɨ̀ndɨ̀ àmɨ kɨ màlɨ̀ga kɨ toróbɨ́ twátwa dhɨ kɨ abɨ̀. ");
INSERT INTO log_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Lókyá nda sè dhɨ, má nɨ áma Tɨrɨ́ kutú áma màrábà àgo ró ɨ̀ndɨ̀ tòko ró dhɨ ɨ dri gò, ɨ̀ dré adrézó tà longó pròfétà kya tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Má nɨ tà lɨ́ndrɨ́ga ró dhɨ kɨ ꞌo agálé bhù mìbhalé ꞌá, adrézó tà adrébhá áma rìnyí tadhá dhɨ kɨ ꞌo agálé bvò dri: kàrɨ́ nɨ kutú, àtsɨ́ nɨ ko, ɨ̀ndɨ̀ àtsɨ́kà nɨ sa tátá. ");
INSERT INTO log_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Kìtú nɨ ru ladzá atsálé tínímvá ro, ɨ̀ndɨ̀ mbǎ nɨ lɨká kàrɨ́ tɨ́nɨ ꞌíká, gò Mírì nɨ kìtú múrúngú ɨ̀ndɨ̀ rúku ró dhɨ dré atsázó ndò. ");
INSERT INTO log_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Dɨ móndyá títí dra liyíbhá Mírì rú dhɨ kɨ adrɨ́.›» ");
INSERT INTO log_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Pétèró gò tàá dhɨ: «Àmɨ Ɨ̀sèrélè ànzɨ nɨ ɨ, mɨ̀ yi rè áma kúlí nɨ ɨ ká! Gìká tadhá àmɨ dré ngádra ꞌá dhɨ, Yésu Nàzàrétà lésè dhɨ tá dhya ɨ́ dré amùle nɨ̀ dhɨ ꞌɨ, tà twátwa lɨ́ndrɨ́ga ró ɨ́ dré fèle Yésu nda dré ꞌòle àmɨ kòfalé dhɨ ɨ sè, ngóró àmɨ kɨ tàndɨ mɨ̀ dré nìle be dhɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","À lefè tá akódhɨ nda àmɨ drɨ́gá, ngóró Gìká dré tá tà nɨ nɨ bhàle nìzoá drìdrì dhɨ tɨ́nɨ gò, àmɨ túmä́ní móndɨ́ kònzɨ dhɨ ɨ́be dhɨ, mɨ̀ dré akódhɨ nɨ tidízó dràle fa kɨpakɨpa dri. ");
INSERT INTO log_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Dɨ, Gìká dré ɨ́na akódhɨ nɨ tɨngázó dràdrà lésè, akódhɨ nɨ apázó ngáaswa dràdrà àdhya lésè. Àngyá ko, dràdrà nɨ rìnyí kɨtswá tá ɨ́na akódhɨ nɨ ru bwà ko. ");
INSERT INTO log_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Dàwídì tà tá akódhɨ nɨ tà dri dhɨ: ‹Má adré tá ngbú Mírì Gìká nɨ no má kandrá. Àngyá ko, akódhɨ áma drɨ́ágó lésè, má kòlyàró tirì dré àlomvá ko. ");
INSERT INTO log_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Dɨ ásà dhɨ, áma togó adré gàle arɨ́ sè bǐ, ɨ̀ndɨ̀ áma làdra adré lenzélé. Áma rúbhá nɨ kpà adré lɨ́drɨ̀ ɨ́be, má dré adrélé mì bha Mírì véna dhɨ sè. ");
INSERT INTO log_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Tàko ko, mɨ́ kɨtswá mɨ́na áma tayɨ́ móndyá dràbhá dre dhɨ kɨ àrà na ko, ɨ̀ndɨ̀ mɨ́ kɨtswá ámɨ Dhya lólo dhɨ nɨ tayɨ́ ŋwàle mógó na ko. ");
INSERT INTO log_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Mɨ́ ꞌo ma láti lɨ́drɨ̀ àdhya kɨ ni dre. Dɨ mɨ́ nɨ áma fe gàle arɨ́ sè bǐ mà dré adrélé túmä́ní mɨ́ be dhɨ sè.› ");
INSERT INTO log_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Áma adrúpi ɨ, má kɨtswá tàá àmɨ dré ngádra ꞌá dhɨ: Àma kɨ tábhí Dàwídì drà tá ɨ́na sìle gò, akódhɨ nɨ mógó dré adrézó àma kòfalé be atsálé ándrò kònɨ̀dhɨ. ");
INSERT INTO log_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Dɨ, akódhɨ nda tá pròfétà ꞌɨ. Nì tá kpà tà Gìká dré tá lazílé ɨ́ dré mòndrà sè tàle dhɨ, Gìká nɨ áyɨ toyó kɨ àlo bha adrélé ópɨ́ kàdrɨ̀ ro ɨ́ tɨ́nɨ dhɨ be. ");
INSERT INTO log_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Dɨ kònò tà adrélépi tá alɨ̀le dhɨ drìdrì dre dhɨ, dré Mèsɨ́yà nɨ ngàma dràdrà ꞌásè dhɨ nɨ tà longózó tàzoá dhɨ, Gìká kɨtswá akódhɨ nɨ tayɨ́ móndyá dràbhá dre dhɨ kɨ àrà na ko, ɨ̀ndɨ̀ kɨtswá akódhɨ nɨ rúbhá tayɨ́ ŋwàle mógó na ko. ");
INSERT INTO log_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Dɨ Gìká tɨngá Yésu nda dràdrà lésè dre. Àma títí kònɨ ɨ, dhya tà nda nɨ nobhá mì sè dhɨ ꞌɨ. ");
INSERT INTO log_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Dɨ Gìká kòtɨngá akódhɨ nda kurú na bhàle áyɨ drɨ́ágó lésè dre dhɨ, akódhɨ dré Tɨrɨ́ Lólo áyɨ Atá dré tá lazílé dhɨ nɨ kisúzó gò, dré Tɨrɨ́ nda nɨ kutúzó àma dri, ngóró mɨ̀ dré adrélé nòle ɨ̀ndɨ̀ yìle ándrò kònɨ̀dhɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Tàko ko, Dàwídì mbà tá ɨ́na bhù na nɨ̀ ko. Dɨ, tà tá ɨ́na dhɨ: ‹Mírì Gìká tà áma Mírì dré dhɨ: Mɨ́ alɨ̀ lɨrɨ́lé áma drɨ́ágó lésè, ");
INSERT INTO log_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","tsàle lókyá má dré dra ámɨ kàrɨbhá kɨ bhàzo adrélé ámɨ pá zàle dhɨ ꞌá.› ");
INSERT INTO log_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Adré dɨ lèá dhɨ, súrú wä́yi Ɨ̀sèrélè ànzɨ kya ɨ̀ kònì tà kònɨ̀dhɨ dóro: Gìká bhà Yésu mɨ̀ dré tá tidílé fa kɨpakɨpa dri nda kòdhɨ adrélé Mírì ro, ɨ̀ndɨ̀ Mèsɨ́yà ro!» ");
INSERT INTO log_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Móndyá nda ɨ̀ kòyi tà nda ɨ dre dhɨ, àyɨ kɨ togó dré ŋòzo kɨzà dré gò, ɨ̀ dré lizízóá Pétèró ɨ tí àpóstolò àruka ɨ́be dhɨ: «Àma kɨ adrúpi ɨ, adré dɨ lèá dhɨ, mà kòꞌo ngɨ́nɨ?» ");
INSERT INTO log_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pétèró logó àyɨ dré dhɨ: «Àmɨ àlo àlo títí nɨ ɨ, mɨ̀ kòladzá àmɨ kɨ togó gò, bàtísimò dòzo Yésu Krísto nɨ rú sè, Gìká kòtrìró àmɨ kɨ tàkonzɨ̀ ɨ be dhɨ bvó. Dɨ mɨ̀ nɨ Tɨrɨ́ Lólo Gìká dré dra fèle àmɨ dré àngyá dhɨ nɨ kisú. ");
INSERT INTO log_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Tàko ko, tà Gìká dré lazílé kòdhɨ àmɨ dré, àmɨ kɨ ànzɨ ɨ dré, ɨ̀ndɨ̀ móndyá títí adrébhá làwú làvo ꞌásè dhɨ ɨ dré. Tà bàti ró dhɨ, lazikúlí nda móndyá títí Mírì àma kɨ Gìká dré dra azílé dhɨ ɨ dré.» ");
INSERT INTO log_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Dɨ Pétèró dré kúlí àruka bǐ dhɨ kɨ tàzo àyɨ dré, àyɨ kɨ kodzózó tàzoá dhɨ: «Mɨ̀ kòtɨdrɨ́ àmɨ lapázó móndyá ándrò gòdhógòdho nɨ ɨ kòfalésè wà.» ");
INSERT INTO log_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Dɨ àyɨ Pétèró nɨ kúlí kaꞌìbhá dhɨ ɨ̀ dré bàtísimò dòzo. Gò móndɨ́ ànyɨ́ànyɨ ngùlù-na dhɨ ɨ̀ dré ru amúzó Yésu nɨ kaꞌìbhá nda ɨ́be kìtú nda sè. ");
INSERT INTO log_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Dɨ Yésu nɨ kaꞌìbhá nda ɨ̀ adré tá àyɨ kɨ fe adrélé tà àpóstolò ɨ̀ dré tá adrélé tadhálé dhɨ kɨ yi, adrézó ngá àlo ró àyɨ kòfalésè. Ɨ̀ adré tá ngá nya túmä́ní, adrézó tà ta Gìká be landè àko ró. ");
INSERT INTO log_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Àyɨ títí dhɨ kɨ lɨ́ndrɨ́ adré tá gàle bhwǎbhwa, Gìká dré tá adrélé àpóstolò nda kɨ ꞌo adrélé tà twátwa lɨ́ndrɨ́ga ró dhɨ kɨ ꞌo bǐ dhɨ sè. ");
INSERT INTO log_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Móndyá kaꞌìbhá títí nda ɨ̀ adré tá ru amú adrélé ngá àlo ró, adrélé àyɨ kɨ ngá kɨ lanzɨ́ àyɨ kòfalésè. ");
INSERT INTO log_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ɨ̀ adré tá àyɨ kɨ amvú kɨ lagɨ́ àyɨ kɨ ngá ɨ́be, adrézó làfa nɨ nɨ lanzɨ́ àyɨ kòfalésè, ngóró àyɨ kɨ àruka kɨ lemerè dré adrélé dhɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Kìtú àlo àlo títí ɨ sè dhɨ, ɨ̀ adré tá ru kɨmó togó àlo sè tépelò na. Ɨ̀ adré tá kpà mányàngá do nyàle àyɨ kɨ dzó ɨ ꞌásè, adrézó nyàá arɨ́ sè togó ànzɨmvá kya tɨ́nɨ dhɨ be. ");
INSERT INTO log_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ɨ̀ adré tá kpà Gìká nɨ rú bha kùle. Àyɨ kɨ tà tá dóro móndyá títí ɨ mìlésè. Dɨ kìtú àlo àlo títí ɨ sè dhɨ, Mírì adré tá móndɨ́ àruka ɨ́ dré tá adrélé tɨdrɨ́lé dhɨ kɨ amú túmä́ní àyɨ ɨ́be. ");
INSERT INTO log_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Kìtú àlo dhɨ, Pétèró ɨ Yòwánɨ̀ be dhɨ ɨ̀ adré tá mbàle tépelò na sáà na kìtú rírí àmvolésè dhɨ sè, lókyá ànzyà gà adrézó tà zi Gìká tí dhɨ sè. ");
INSERT INTO log_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Lókyá nda sè dhɨ, à adré tá agó àlo tìle mèrèkpè ro dhɨ nɨ adó bhàle tépelò nda nɨ zèríbàti zìle Aveave ró dhɨ làga, ànzyà ɨ̀ dré adrélé ꞌòle kìtú àlo àlo títí ɨ sè dhɨ tɨ́nɨ, kàdréró ngá zi móndɨ́ adrébhá fɨ̀le tépelò na dhɨ ɨ tí. ");
INSERT INTO log_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Dɨ akódhɨ nda kònò Pétèró ɨ Yòwánɨ̀ be adréràꞌa ꞌòle fɨ̀le dre dhɨ, dré kɨdhózó adrélé làfa zi àyɨ tí. ");
INSERT INTO log_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pétèró ɨ Yòwánɨ̀ be dhɨ ɨ̀ dré akódhɨ nɨ nòzo dɨ̀ɨɨ́ gò, Pétèró dré tàzoá drá dhɨ: «Mɨ́ nò rè àma ká!» ");
INSERT INTO log_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Dɨ agó nda dré adrézó àyɨ kɨ no adrézó kisùá dhɨ, ɨ́ nɨ ngá kisú àyɨ drɨ́gásè. ");
INSERT INTO log_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Dɨ, Pétèró dré tàzoá drá dhɨ: «Ma làfa ledélé àrezá sè yà, kó ngalè órò sè yà dhɨ àko. Dɨ, ngá má dré adrézó ába dhɨ, má adré mána fèá mɨ́ dré: Yésu Krísto Nàzàrétà lésè dhɨ nɨ rú sè, mɨ́ nga, mɨ́ kɨdhó atsí to!» ");
INSERT INTO log_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Gò Pétèró dré akódhɨ nɨ drɨ́ágó rùzo, akódhɨ nɨ ꞌòzo ngàle dhɨ bvó. Gbǎ kòdhwa, akódhɨ nɨ pá ɨ kɨ̀lɨ̀kpo nɨ ɨ́be dhɨ ɨ̀ dré tombázó gò, ");
INSERT INTO log_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","dré ngàzo áyɨ totó trà pá dri gò, kɨdhólé atsí to. Dɨ dré adrézó lɨ̀le lowábe, adrélé Gìká nɨ rú bhabe kùle. Gò ɨ̀ dré fɨ̀zo akódhɨ be tépelò na. ");
INSERT INTO log_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Móndyá títí dhɨ ɨ̀ kònò akódhɨ adréràꞌa atsí to, adrézó kpà Gìká nɨ rú bha kùle dre dhɨ, ");
INSERT INTO log_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ɨ̀ dré nìzoá tàle dhɨ, akódhɨ tá mèrèkpè agó adrélépi tá lɨrɨ́lé adrélé ngá zi tépelò nɨ zèríbàti zìle Aveave ró dhɨ làga dhɨ ꞌɨ dhɨ be. Dɨ àyɨ kɨ lɨ́ndrɨ́ dré gàzo bhwǎbhwa gò, ɨ̀ dré adrézó síbhálé be ngbo tà atsálépi akódhɨ nda rú dhɨ sè. ");
INSERT INTO log_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Agó nda dré rè dhu adréràꞌa tròle Pétèró ɨ rú Yòwánɨ̀ be dhɨ ꞌá dhɨ, móndyá zyandre títí nda ɨ̀ dré arázó lɨ́ndrɨ́ga be afɨ́lé àyɨ vélé tépelò nɨ kògbo zìle Sòlòmónò àdhya ró dhɨ lé. ");
INSERT INTO log_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pétèró kònò tà nda dre dhɨ, dré tàzoá móndyá nda ɨ dré dhɨ: «Ɨ̀sèrélè ànzɨ nɨ ɨ, àmɨ kɨ lɨ́ndrɨ́ adré gàle tà kòdhɨ sè àdho tà sè? Mɨ̀ adré kpà àma kɨ no, ngóró mà ꞌo tá àmakya agó kònɨ̀dhɨ atsí to àma kɨ tàndɨ kɨ rìnyí sè yà, kó ngalè mà dré adrélé tròle Gìká nɨ tà rú dhɨ sè yà dhɨ na tɨ́nɨ àdho tà sè? ");
INSERT INTO log_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Gìká Àbàrámà àdhya, Ɨ̀sákà àdhya, ɨ̀ndɨ̀ Yàkóbhò àdhya, Gìká àma kɨ tábhí kya nda bhà áyɨ adhemakandra Yésu nɨ mì lanzìle tà kòdhɨ sè dhɨ nɨ̀. Mɨ̀ lefè tá àmɨkya Yésu nda kɨtswálé dràle gò, akódhɨ nɨ tà gàzo rè Pìlátò kandrá, tágba Pìlátò nda dré tá ɨ́na akódhɨ nɨ lèzo trɨ̀le dhɨ. ");
INSERT INTO log_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Dɨ mɨ̀ gà tá àmɨkya Dhya lólo ɨ̀ndɨ̀ gyǎgya nda gò, móndɨ́ pfùlepi àlo dhɨ nɨ zìzo trɨ̀le àmɨ dré kòdhya. ");
INSERT INTO log_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Dɨ mɨ̀ pfu tá dhya láti nzìlepi móndɨ́ ɨ dré adrɨ́zó nda dràle gò, Gìká dré ɨ́na akódhɨ nɨ tɨngázó dràdrà lésè. Àma dhya tà nda kɨ nobhá mì sè dhɨ ꞌɨ. ");
INSERT INTO log_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Agó mɨ̀ dré adrélé nòle ɨ̀ndɨ̀ nìle kònɨ̀dhɨ bhà ɨ́na áyɨ tà kaꞌìkaꞌì Yésu nɨ rú na gò, rú nda dré akódhɨ nɨ ꞌòzo tombálé. Tàko ko, Yésu nɨ rú nda ɨ túmä́ní tà kaꞌìkaꞌì bhàle rú nda léna dhɨ be dhɨ, ɨ̀ ꞌo agó kònɨ̀dhɨ adrɨ́lé wä́yi, ngóró àmɨ títí mɨ̀ dré adrélé nòle dhɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Áma adrúpi ɨ, má nì tàle dhɨ, tà mɨ̀ dré ꞌòle àmɨ kɨ kàdrɨ̀ ɨ́be Yésu rú nda ɨ, mɨ̀ ꞌo tá tà nìma ko na dhɨ be. ");
INSERT INTO log_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Dɨ, láti nda sè dhɨ, Gìká ꞌo tà ɨ́ dré tá longólé drìdrì áyɨ pròfétà títí dhɨ ɨ tí dhɨ kɨtswálé títí. Longó tá dhɨ, áyɨ Mèsɨ́yà nɨ kɨzà nya. ");
INSERT INTO log_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Adré dɨ lèá dhɨ, mɨ̀ kòladzá àmɨ kɨ togó agòzo Gìká vélé, kòtrìró àmɨ kɨ tàkonzɨ̀ ɨ be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Mɨ̀ kòꞌo kònɨ̀nɨ dhɨ, mɨ̀ nɨ lókyá adrézó àmɨ kɨ togó tɨndrɨ̀ dhɨ nɨ kisú Mírì véna. Akódhɨ nɨ kpà Mèsɨ́yà ɨ́ dré zɨ̀le àmɨ dré drìdrì dhɨ nɨ amù. Akódhɨ nda Yésu ꞌɨ. ");
INSERT INTO log_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Dɨ, adré lèá dhɨ, akódhɨ nda kàdré dhu rè bhù na, tsàle lókyá Gìká dré dra tà títí dhɨ kɨ ꞌòzo atsálé tɨ́dhɨ́ ro dhɨ ꞌá, ngóró dré longólé kɨ́nó lésè áyɨ pròfétà lólo dhɨ ɨ tí dhɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Tàko ko, Mósè tà tá dhɨ: ‹Mírì àmɨ kɨ Gìká nɨ pròfétà àlo má tɨ́nɨ dhɨ nɨ ꞌo apfòle àmɨ kɨ tàndɨ kɨ súrú lésè amùle àmɨ dré. Adré lèá dhɨ, mɨ̀ kàdré tà títí dré dra tàle àmɨ dré dhɨ kɨ yi. ");
INSERT INTO log_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Dɨ, dhya ángùdhi dra pròfétà nda nɨ yìlepi ko dhɨ, Gìká nɨ akódhɨ nda nɨ tɨngá móndyá ɨ́na ɨ kòfalésè gò, akódhɨ nɨ tà ꞌòzo akɨ́lé.› ");
INSERT INTO log_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Tà bàti ró dhɨ, kɨdhólé Sàmùwélè rú dhɨ, pròfétà àlo àlo títí kúlí longóbhá dhɨ ɨ̀ longó tá tà adrébhá ru ꞌo ándrò kònɨ ɨ kòdhya. ");
INSERT INTO log_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Àmɨ ró dhɨ, àmɨ ànzɨ adrébhá tà pròfétà ɨ̀ dré longólé nda kɨ kisú tàyɨlé ro dhɨ ꞌɨ. Mɨ̀ adré kókpà tà Gìká dré bhàle ru yìzo àmɨ kɨ tábhí ɨ́be dhɨ nɨ kisú tàyɨlé ro. Tàko ko, Gìká lazí tá Àbàrámà dré dhɨ: ‹Má nɨ tà tanɨ bha súrú títí bvò àdhya ɨ dri ámɨ ànzɨ ɨ sè.› ");
INSERT INTO log_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Dɨ Gìká kòꞌo áyɨ adhemakandra Yésu nda apfòle dre dhɨ, dré rè zyà akódhɨ nɨ amùzo àmɨ, Ɨ̀sèrélè ànzɨ ɨ vélé ꞌíká, kàdrìró àmɨ àlo àlo títí dhɨ ɨ àmɨ kɨ tà kònzɨ lésè, tà tanɨ bhàzo àmɨ dri be dhɨ bvó.» ");
INSERT INTO log_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pétèró ɨ Yòwánɨ̀ be dhɨ ɨ̀ dré rè dhu adréràꞌa tà ta móndyá zyandre nda ɨ dré dhɨ ꞌá dhɨ, kòwánà ɨ, tépelò lɨkɨ́bhá kɨ kàdrɨ̀, ɨ̀ndɨ̀ Sàdùkáyò ɨ́be dhɨ ɨ̀ dré atsázó àrà nda ꞌá. ");
INSERT INTO log_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Àyɨ kɨ togó adré tá aswálé àpóstolò nda ɨ rú, ɨ̀ dré tá adrélé tà tadhá móndɨ́ ɨ dré dhɨ sè. Àngyá ko, ɨ̀ adré tá Yésu nɨ ngàma dràdrà ꞌásè dhɨ nɨ tà longó, adrézó kpà longóá dhɨ, móndyá Yésu nɨ kaꞌìbhá dhɨ kɨ kókpà nga dràdrà ꞌásè. ");
INSERT INTO log_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Dɨ ɨ̀ dré Pétèró kɨ rùzo Yòwánɨ̀ be bhèle bǎdzó na ngá wàle tà. Tàko ko, kìtú ndì dre. ");
INSERT INTO log_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Dɨ, móndɨ́ àruka bǐ àyɨ kɨ kúlí yibhá dhɨ ɨ̀ kaꞌì tá Yésu gò, móndyá títí Yésu nɨ kaꞌìbhá dhɨ ɨ̀ dré lɨzózó tsàle ànyɨ́ànyɨ ngùlù-nzi. ");
INSERT INTO log_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ngá kòwa dre dhɨ, Yúdà ànzɨ kɨ drì kobhá ɨ, àyɨ kɨ bhàgo ɨ ɨ̀ndɨ̀ tátrɨ́trɨ́ kúlí tadhábhá ɨ́be dhɨ, ɨ̀ dré ru kɨmózó Yèrúsalémà ꞌa. ");
INSERT INTO log_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Àyɨ kòfalé dhɨ tá: kòwánà kɨ kàdrɨ̀ rú zìle Ánà dhɨ, Kàyáfà, Yòwánɨ̀, Àlɨ̀gɨ̀zándrè, tsàle móndɨ́ àruka kòwánà kɨ kàdrɨ̀ nɨ súrú lésè dhɨ ɨ́be. ");
INSERT INTO log_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Dɨ ɨ̀ dré Pétèró kɨ ꞌòzo apfòle Yòwánɨ̀ be àyɨ kandrá gò, ɨ̀ dré lizízóá àyɨ tí dhɨ: «Mɨ̀ ꞌo àmɨkya tà kòdhɨ àdhi nɨ rìnyí sè ya, kó ngalè àdhi nɨ rú sè ya dhɨ?» ");
INSERT INTO log_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Dɨ Pétèró gàlepi Tɨrɨ́ Lólo nɨ rìnyí sè dhɨ dré logózóá àyɨ dré dhɨ: «Àmɨ, Yúdà ànzɨ kɨ kàdrɨ̀ ɨ bhàgo ɨ́be nɨ ɨ, ");
INSERT INTO log_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ándrò kònɨ̀dhɨ, à adré àma kɨ lizí tà dóro ꞌòle mèrèkpè agó àlo dhɨ dré dhɨ nɨ tà sè, ɨ̀ndɨ̀ akódhɨ nda adrɨ́ ngɨ́nɨ ya dhɨ nɨ tà sè. ");
INSERT INTO log_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Adré dɨ lèá dhɨ, àmɨ túmä́ní Ɨ̀sèrélè ànzɨ ɨ́be títí dhɨ ɨ, mɨ̀ kònì tà kònɨ̀dhɨ dóro: Agó kònɨ̀dhɨ adré áyɨ totó rúbhá be dóro àmɨ kandrá, Yésu Krísto Nàzàrétà lésè dhɨ nɨ rú nɨ rìnyí sè. Mɨ̀ tidí tá Yésu nda dràle fa kɨpakɨpa dri gò, Gìká dré ɨ́na akódhɨ nɨ tɨngázó dràdrà lésè. ");
INSERT INTO log_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Akódhɨ nda nɨ tà sè dhɨ, Gìká nɨ Kúlí adré tàá dhɨ: ‹Kɨ́rà àmɨ dzó sibhá ɨ mɨ̀ dré gàle gàgà dhɨ, gò atsálé kɨ́rà agógó dzó nda dré adrézó áyɨ totó drìá dhɨ ró.› ");
INSERT INTO log_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","À adré tà tɨdrɨ́zó dhɨ nɨ kisú móndɨ́ twá Yésu nda rúsè dhɨ na ko. Tàko ko, rú àzya Gìká dré afèle móndyá bvò dri dhɨ ɨ dré kɨtswázó adrɨ́lé ásà dhɨ yókódhó.» ");
INSERT INTO log_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Dɨ Yúdà ànzɨ kɨ bhàgo kàdrɨ̀ nda ɨ̀ kònò Pétèró ɨ Yòwánɨ̀ be adréràꞌa tà ta tirì àko dre dhɨ, àyɨ kɨ lɨ́ndrɨ́ dré gàzo bhwǎbhwa. Àngyá ko, ɨ̀ nò tá dhɨ, àyɨ nda ɨ tá móndɨ́ tàko tà ndabhá nìle ko dhɨ ꞌɨ. Dɨ, ɨ̀ nì kpà tàle dhɨ, àyɨ móndɨ́ adrébhá tá túmä́ní Yésu be dhɨ ꞌɨ dhɨ be. ");
INSERT INTO log_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Dɨ, ɨ̀ dré tá adrélé mèrèkpè agó adrɨ́lépi nda nɨ no adréràꞌa áyɨ totó àyɨ làga dhɨ sè dhɨ, ɨ̀ kɨtswá tá àyɨkya kúlí logó àyɨ tí bwà ko. ");
INSERT INTO log_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Dɨ ɨ̀ dré Pétèró kɨ ꞌòzo pfòle Yòwánɨ̀ be àyɨ kandrásè kɨvɨ̀ na gò, ɨ̀ dré tà nda nɨ ꞌa nyàzo àyɨ kòfalé ");
INSERT INTO log_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","tàzoá dhɨ: «Mà nɨ ꞌòá àgo kòdhɨ kɨ tà sè ngɨ́nɨ? Tàko ko, móndyá títí adrébhá Yèrúsalémà ꞌa dhɨ ɨ̀ nì tàle dhɨ, àyɨ nda ɨ̀ ꞌo àyɨkya tà lɨ́ndrɨ́ga ró dhɨ ꞌí dhɨ be. Mà kɨtswá àmakya kayíá bwà ko. ");
INSERT INTO log_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Dɨ, adré lèá dhɨ, mà kòlogá àyɨ tàzoá dhɨ, ɨ̀ kògò vélé tà ta dhya àlo dré agó kòdhɨ nɨ rú sè ko, tà kòdhɨ nɨ rúbí kògòró laꞌúlé móndɨ́ ɨ kòfalésè lɨ̀le drìdrì ko dhɨ bvó.» ");
INSERT INTO log_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Dɨ ɨ̀ dré gòzo àyɨ nda kɨ azí gò, tà tàma ɨ̀ndɨ̀ tà tadhama Yésu nɨ rú sè dhɨ nɨ logázó àyɨ dré tà tàndɨ ró. ");
INSERT INTO log_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Dɨ, Pétèró ɨ Yòwánɨ̀ be dhɨ ɨ̀ dré logózóá àyɨ tí dhɨ: «Mɨ̀ lanzɨ́ rè tà kònɨ̀dhɨ nɨ bvó ká: Adrélé Gìká nɨ kúlí ga ꞌòle, kɨtswázó àmɨ kɨ kúlí kaꞌì ꞌòle dhɨ, tsì dóro Gìká mìlésè? ");
INSERT INTO log_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Tàko ko, mà kɨtswá àmakya tà mà dré nòle mì sè ɨ̀ndɨ̀ mà dré yìle bíbhálé sè dhɨ kɨ longoma tayɨ́ bwà ko.» ");
INSERT INTO log_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Dɨ bhàgo kàdrɨ̀ nda ɨ̀ dré gòzo kúlí aswaaswa kɨ ta àyɨ dri gò, ɨ̀ dré àyɨ kɨ tayɨ́zó lɨ̀le. Ɨ̀ kisú tá àyɨkya tà àlo tà ŋòzo àyɨ dri dhɨ ko. Tàko ko, móndyá títí dhɨ ɨ̀ adré tá Gìká nɨ rú bha kùle tà ru ꞌòlepi nda nɨ tà sè. ");
INSERT INTO log_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Àngyá ko, mèrèkpè agó adrɨ́lépi lɨ́ndrɨ́ga ró nda nɨ kóná lavú tá ɨ́na nyadhɨ-rì. ");
INSERT INTO log_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","À kòtayɨ́ Pétèró ɨ Yòwánɨ̀ be dre dhɨ, ɨ̀ dré gòzo àyɨ kɨ arúpi Yésu nɨ kaꞌìbhá dhɨ ɨ véna, tà títí kòwánà kàdrɨ̀ ɨ bhàgo ɨ́be dhɨ ɨ̀ dré tàle àyɨ dré dhɨ kɨ tɨtɨ́. ");
INSERT INTO log_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Àyɨ nda ɨ̀ kòyi tà nda ɨ dre dhɨ, ɨ̀ dré ngàzo kúlí yo togó àlo sè tàzoá Gìká dré dhɨ: «Mírì rúku ró bhù kɨ bhàlepi bvò be, yǐandre be, ɨ̀ndɨ̀ ngá títí àyɨ lé dhɨ ɨ́be nɨ, ");
INSERT INTO log_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","mɨ́ longó tá kúlí ámɨ màrábà, àma kɨ tábhí Dàwídì tí Tɨrɨ́ Lólo nɨ rìnyí sè mɨ, tàzoá dhɨ: ‹Súrú títí dhɨ kɨ togó aswá àdho tà sè? Móndyá bvò àdhya ɨ̀ yi ru kɨtswázó tà àngyá ꞌo àdho tà sè? ");
INSERT INTO log_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ópɨ́ kàdrɨ̀ bvò àdhya ɨ̀ lotó àyɨ, ɨ̀ndɨ̀ móndɨ́ kɨ kàdrɨ̀ ɨ̀ kɨmó ru, kɨtswázó ru pfu Mírì Gìká rú, ɨ̀ndɨ̀ akódhɨ nɨ Mèsɨ́yà rú.› ");
INSERT INTO log_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Tà bàti ró dhɨ, bhàandre kònɨ̀dhɨ ꞌá dhɨ, Èródè ɨ Pòtíyò Pìlátò be dhɨ ɨ̀ amú tá ru túmä́ní móndɨ́ súrú twá ro dhɨ ɨ́be ɨ̀ndɨ̀ Ɨ̀sèrélè ànzɨ ɨ́be, kɨtswázó tà ꞌo ámɨ adhemakandra lólo, Yésu mɨ́ dré zɨ̀le dhɨ rú. ");
INSERT INTO log_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ɨ̀ ꞌo kònɨ̀nɨ, kɨtswálé tà mɨ́ dré kisùle ꞌòle kɨ́nó lésè ámɨ rìnyí sè dhɨ ɨ̀ kòꞌoró ru be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Dɨ nyànomvá dhɨ, Mírì, mɨ́ kòyi kúlí aswaaswa ɨ̀ dré adrélé tàle àma rú dhɨ ɨ. Mɨ́ kòfè rìnyí àma ámɨ màrábà ɨ dré, adrézó ámɨ kúlí longó tirì àko. ");
INSERT INTO log_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Mɨ́ kòkɨdzɨ̀ kpà ámɨ drɨ́gá rìnyi ró dhɨ, adrézó móndɨ́ kɨ tɨdrɨ́ àyɨ kɨ drà ɨ lésè, adrézó kpà tà lɨ́ndrɨ́ga ró adrébhá ámɨ rìnyí tadhá dhɨ kɨ ꞌo, ámɨ adhemakandra lólo, Yésu nɨ rú sè.» ");
INSERT INTO log_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ɨ̀ kòzi tà nda ɨ Gìká tí akɨ́lé dre dhɨ, àrà ɨ̀ dré ru kɨmózó lána nda dré ru kɨzɨ́zó. Dɨ ɨ̀ dré gàzo títí Tɨrɨ́ Lólo nɨ rìnyí sè gò, ɨ̀ dré ngàzo adrélé Gìká nɨ kúlí longó móndɨ́ ɨ dré tirì àko. ");
INSERT INTO log_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Móndyá títí Yésu nɨ kaꞌìbhá dhɨ ɨ̀ amú tá ru adrélé ngá àlo ró àyɨ kɨ togó na ɨ̀ndɨ̀ àyɨ kɨ tà kisùkisù na. Dhya àlo àyɨ kòfalé adrélépi tàá dhɨ, ngá ɨ́na ngbà ꞌí ɨ́ dré kalóma dhɨ tá yókódhó. Be ró dhɨ, ɨ̀ adré tá àyɨ kɨ ngá títí dhɨ kɨ lanzɨ́ àyɨ kòfalésè. ");
INSERT INTO log_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Àpóstolò ɨ̀ adré tá Mírì Yésu nɨ ngàma dràdrà ꞌásè dhɨ nɨ tà longó rìnyí kàdrɨ̀ sè. Dɨ àyɨ tá Gìká nɨ togó tanɨ ɨ́be àyɨ rú. ");
INSERT INTO log_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Dhya àlo lemerè ro àyɨ kòfalé dhɨ tá yókódhó. Àngyá ko, àyɨ títí adrébhá amvú ɨ́be yà, kó ngalè dzó ɨ́be yà dhɨ ɨ̀ adré tá ngá nda kɨ lagɨ́, adrézó làfa nɨ nɨ adó alɨ̀zo ");
INSERT INTO log_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","bhàá àpóstolò ɨ kandrá. Dɨ à adré tá làfa nda nɨ lanzɨ́ móndɨ́ àlo àlo ɨ dré ngóró àyɨ kɨ lemerè dré adrélé dhɨ tɨ́nɨ. ");
INSERT INTO log_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Agó àlo rú be Yòséfà angálépi Lévì nɨ súrú lésè, tìle tùrù Kìpírò àdhya na dhɨ tá àyɨ kòfalé. Àpóstolò ɨ̀ fè tá drá rú Bàrànábà. (Rú nda kòdhɨ adré lèá tàle dhɨ «Mvá adrélépi móndɨ́ kɨ togó tɨmbà dhɨ».) ");
INSERT INTO log_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Akódhɨ nda tá amvú àlo dhɨ ɨ́be gò, dré lagɨ́zóá, làfa nɨ nɨ adózó alɨ̀zo bhàá àpóstolò ɨ kandrá. ");
INSERT INTO log_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Agó àlo rú be Ànànɨ́yà dhɨ ɨ tòkó nɨ Sàfírà be dhɨ ɨ tá kpà amvú àlo dhɨ ɨ́be gò, ɨ̀ dré lagɨ́zóá. ");
INSERT INTO log_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Dɨ, Ànànɨ́yà nda dré ɨ́na làfa nɨ àruka tɨngázó zùle áyɨ tàndɨ dré gò, àmbí nɨ nɨ dòzo lɨ̀zo bhàá àpóstolò ɨ kandrá. Dɨ akódhɨ nɨ tòkó nì tá kpà tà nda dóro. ");
INSERT INTO log_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Gò Pétèró dré tàzoá drá dhɨ: «Ànànɨ́yà, mɨ́ tayɨ́ mɨ́na Sàtánà fɨ̀le ámɨ togó na àdho tà sè? Mɨ́ tà kɨnzò Tɨrɨ́ Lólo dré gò, amvú kòdhɨ nɨ làfa àruka tɨngázó zùle ámɨ tàndɨ dré. ");
INSERT INTO log_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Drìdrì mɨ́ dré amvú nda nɨ lagɨ́zó dhɨ kandrá dhɨ, amvú nda tá mɨ́na ꞌɨ ko? Mɨ́ dré lagɨ́zóá dhɨ àmvolésè dhɨ, làfa nda tá mɨ́ drɨ́gá gò, mɨ́ dré tá kɨtswázó tà ángùdhi mɨ́ dré lèle ꞌòle dhɨ nɨ ꞌo ásà dhɨ ko? Mɨ́ ꞌo dɨ mɨ ngɨ́nɨ tà kòdhɨ nɨ kisù ꞌòle kònɨ̀nɨ dhɨ? Mɨ́ tà kɨnzò móndɨ́ ɨ dré ko. Be ró dhɨ, mɨ́ tà mɨ́na kɨnzò Gìká dré.» ");
INSERT INTO log_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ànànɨ́yà kòyi kúlí nda ɨ dre dhɨ, dré dhèzo dràle. Dɨ tirì dré móndyá títí tà nda nɨ yibhá dhɨ kɨ ꞌòzo lavúlé. ");
INSERT INTO log_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Gò kàdhúrà àruka ɨ̀ dré alɨ̀zo akódhɨ nɨ àbvò do lambélé gò, ɨ̀ dré pfòzo sìá. ");
INSERT INTO log_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ànyɨ́ànyɨ sáà na àmvolésè dhɨ, Ànànɨ́yà nɨ tòkó dré afɨ́zó Pétèró ɨ vélé, tà lavúlépi nda nɨ nì àko ró. ");
INSERT INTO log_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pétèró dré lizízóá tíá dhɨ: «Mɨ́ tà rè má dré ká: Mɨ̀ lagɨ́ amvú kòdhɨ làgɨ́ be kòdhòpɨ bàti?» Tòkó nda logó dhɨ: «Àyíya, kòdhɨ làgɨ́ nda ꞌɨ.» ");
INSERT INTO log_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Dɨ Pétèró tà drá dhɨ: «Mɨ̀ ꞌo àmɨ ngɨ́nɨ ru yi ámɨ agó be kɨtswázó Mírì nɨ Tɨrɨ́ tabhì lɨtɨ́lé dhɨ? Mɨ́ nò rè ká! Dhya ámɨ agó nɨ sibhá dhɨ ɨ dzó tí. Ɨ̀ nɨ kókpà ámɨ do pfòzo mɨ́ be.» ");
INSERT INTO log_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Gbǎ kòdhwa, tòkó nda dré dhèzo dràle Pétèró kandrá. Gò kàdhúrà nda ɨ̀ dré afɨ́zó akódhɨ nɨ àbvò kisú. Ɨ̀ dré dòzoá, pfòzo sìá agó nɨ làga. ");
INSERT INTO log_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Dɨ tirì dré móndyá títí Èkèlézyà le dhɨ kɨ ꞌòzo lavúlé, túmä́ní móndyá títí tà nda nɨ yibhá dhɨ ɨ́be. ");
INSERT INTO log_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Àpóstolò ɨ̀ adré tá tà lɨ́ndrɨ́ga ró adrébhá Gìká nɨ rìnyí tadhá dhɨ kɨ ꞌo bǐ móndɨ́ ɨ kòfalé. Móndyá kaꞌìbhá títí dhɨ ɨ̀ adré tá ru kɨmó togó àlo sè tépelò nɨ kògbo zìle Sòlòmónò àdhya ró dhɨ na. ");
INSERT INTO log_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Dɨ, móndɨ́ àruka ɨ̀ adré tá tabhìle ru amú àyɨ ɨ́be ko, tágba móndyá títí dhɨ ɨ̀ dré tá adrézó àyɨ kɨ rú ta dóro dhɨ. ");
INSERT INTO log_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Tágba kònɨ̀nɨ dhɨ, móndɨ́ zyandre àgo ró ɨ̀ndɨ̀ tòko ró dhɨ ɨ̀ adré tá Mírì Yésu nɨ kaꞌì, adrézó ru amú móndyá kaꞌìbhá nda ɨ́be adrélé lɨ̀le drìdrì. ");
INSERT INTO log_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ásà dhɨ, à adré tá dràbhá kɨ do tobhàle lángá ɨ dri ɨ̀ndɨ̀ kíndri ɨ dri láti ɨ bhálésè, kɨtswálé Pétèró kònɨ̀ dra lavú dhɨ, ndɨ̀ndɨ̀ akódhɨ nɨ lɨ́ndrɨ́ kòlavúró àyɨ nda kɨ àruka ɨ drǐsè gò, ɨ̀ kàdrɨ́ró be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Móndɨ́ zyandre angábhá bhàandre ànyɨ Yèrúsalémà làgásè dhɨ ɨ lésè dhɨ ɨ̀ adré tá kpà dràbhá kɨ adó, móndɨ́ tɨrɨ́ kònzɨ ɨ̀ dré adrélé mì pfòle dhɨ ɨ́be, alɨ̀zo àyɨ ɨ́be. Gò àyɨ títí nda ɨ̀ dré adrézó adrɨ́lé. ");
INSERT INTO log_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Dɨ kòwánà kɨ kàdrɨ̀ túmä́ní móndyá títí akódhɨ làga adrébhá Sàdùkáyò ɨ ró dhɨ ɨ́be dhɨ, ɨ̀ adré tá lovó kònzɨ bha àpóstolò nda ɨ rú. ");
INSERT INTO log_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Gò ɨ̀ dré àyɨ kɨ rùzo bhèle bǎdzó móndyá títí ɨ dré dhɨ na. ");
INSERT INTO log_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Dɨ, ngátsi sè dhɨ, ángéló Mírì àdhya dré ɨ́na bǎdzó nda nɨ ti kɨ tinzìzo, àyɨ kɨ adrìzo apfòzo àyɨ ɨ́be gò, tàzoá àyɨ dré dhɨ: ");
INSERT INTO log_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Mɨ̀ lɨ̀ àmɨ kɨ totó tépelò na, adrélé lɨ́drɨ̀ tɨ́dhɨ́ ro kòdhɨ nɨ rúbí longó móndɨ́ ɨ dré.» ");
INSERT INTO log_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Dɨ drùbhì kɨ́nó, ɨ̀ dré lɨ̀zo tépelò na gò, kɨdhólé adrélé móndɨ́ kɨ tadhá, ngóró ángéló nda dré tá tàle àyɨ dré dhɨ tɨ́nɨ. Kòwánà kɨ kàdrɨ̀ nda ɨ móndyá akódhɨ làga dhɨ ɨ́be dhɨ ɨ̀ kòtsa dre dhɨ, ɨ̀ dré Ɨ̀sèrélè ànzɨ kɨ bhàgo kàdrɨ̀ kɨ kɨmózó títí. Gò ɨ̀ dré móndɨ́ kɨ mùzo kɨtswálé àpóstolò nda kɨ adrì bǎdzó lésè. ");
INSERT INTO log_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Dɨ, dhya mùle nda ɨ̀ kòtsa dre dhɨ, ɨ̀ kisú tá àyɨ nda ɨ bǎdzó na ko. Dɨ ɨ̀ dré gòzo gòle tà nda nɨ longó bhàgo kàdrɨ̀ nda ɨ dré, tàzoá dhɨ: ");
INSERT INTO log_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","«Mà dré tsàzo kònàle dhɨ, mà kisú tá dhɨ, à atsú tá bǎdzó nɨ ti ɨ gä́gä́. Mà kisú kpà bǎdzó lɨkɨ́bhá ɨ adréràꞌa àyɨ kɨ totó dzóti nda ɨ kandrá. Dɨ, mà kònzì dzóti nda ɨ dre dhɨ, mà dré àmakya dhya àlo kisúzó ko.» ");
INSERT INTO log_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Dɨ tépelò lɨkɨ́bhá kɨ kàdrɨ̀, kòwánà kàdrɨ̀ ɨ́be dhɨ ɨ̀ kòyi tà nda dre dhɨ, àyɨ kɨ drì dré abɨ́zó gò, ɨ̀ dré adrézó lizíá àyɨ kòfalésè ngalè àdho tà ꞌo tá àpóstolò nda ɨ nɨ̀ ya dhɨ. ");
INSERT INTO log_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Dɨ dhya àlo dré atsázó longóá àyɨ dré dhɨ: «Mɨ̀ yi rè ká! Àgo mɨ̀ dré tá bhèle bǎdzó na dhɨ ɨ̀ totó àyɨ tépelò na, adrélé móndɨ́ kɨ tadhá.» ");
INSERT INTO log_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Gò tépelò lɨkɨ́bhá kɨ kàdrɨ̀ nda ɨ̀ dré ngàzo lɨ̀le móndɨ́ nɨ ɨ́be, àpóstolò nda kɨ adrì alɨ̀zo àyɨ ɨ́be. Dɨ, ɨ̀ adrì tá àyɨ rìnyí sè ko, ɨ̀ dré tá adrélé ngá ro, móndɨ́ zyandre dhɨ kɨ dra àyɨ kɨ lebhé todràle kɨ́rà sè dhɨ sè. ");
INSERT INTO log_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ɨ̀ kàdrì àyɨ dre dhɨ, ɨ̀ dré àyɨ kɨ ꞌòzo apfòle bhàgo kàdrɨ̀ nda ɨ kandrá gò, kòwánà kɨ kàdrɨ̀ dré àyɨ kɨ lizízó tàzoá dhɨ: ");
INSERT INTO log_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","«Mà logá tá àmɨ dré tà tadhama agó kòdhɨ nɨ rú sè dhɨ ko? Dɨ, mɨ̀ nò rè ká! Mɨ̀ ꞌo àmɨkya tà mɨ̀ dré adrélé tadhálé kòdhɨ ayɨ́lé Yèrúsalémà ꞌásè títí dre. Mɨ̀ adré kpà agó kòdhɨ nɨ kàrɨ́ le bhàle àma dri.» ");
INSERT INTO log_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Gò Pétèró ɨ àpóstolò àruka nda ɨ́be dhɨ ɨ̀ dré logózóá dhɨ: «Adré lèá dhɨ, mà kàdré Gìká nɨ kúlí kaꞌì ꞌòle dhɨ kòdhya, móndɨ́ kya ko. ");
INSERT INTO log_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Gìká àma kɨ tábhí kya tɨngá Yésu mɨ̀ dré tá àmɨkya tidílé dràle fa kɨpakɨpa dri dhɨ dràdrà lésè. ");
INSERT INTO log_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Dɨ Gìká dré akódhɨ nda nɨ tɨngázó kurú na bhàle áyɨ drɨ́ágó lésè adrélé ópɨ́ kàdrɨ̀ ro ɨ̀ndɨ̀ móndɨ́ kɨ tɨdrɨ́lépi ró, kòfèró láti Ɨ̀sèrélè ànzɨ ɨ dré àyɨ kɨ togó ladzázó, Gìká kòtrìró àyɨ kɨ tàkonzɨ̀ ɨ be dhɨ bvó. ");
INSERT INTO log_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Àma dhya tà nda kɨ nobhá mì sè dhɨ ꞌɨ, ngóró Tɨrɨ́ Lólo Gìká dré afèle móndyá adrébhá áyɨ kúlí kaꞌì ꞌòle dhɨ ɨ dré dhɨ dré kpà adrélé dhɨ tɨ́nɨ.» ");
INSERT INTO log_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Bhàgo kàdrɨ̀ nda ɨ̀ kòyi tà nda ɨ dre dhɨ, àyɨ kɨ togó dré aswázó tà tàndɨ ró gò, ɨ̀ dré adrézó àyɨ kɨ le ꞌòle todràle. ");
INSERT INTO log_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Fàrìsáyò àlo rú be Gàmàlɨ̀yélè dhɨ tá àyɨ nda ɨ kòfalé. Akódhɨ nda tá tátrɨ́trɨ́ kúlí tadhálépi lɨndrɨ̀ ro móndyá títí ɨ mìlésè dhɨ ꞌɨ. Dɨ dré ngàzo áyɨ totó bhàgo kàdrɨ̀ nda ɨ kòfalé tàá dhɨ, à kòꞌo rè àgo nda ɨ pfòle kɨvɨ̀ na lókyá tsà sè. ");
INSERT INTO log_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Gò dré tàzoá bhàgo nda ɨ dré dhɨ: «Ɨ̀sèrélè ànzɨ nɨ ɨ, mɨ̀ kàdré àmɨ kɨ lɨkɨ́, tà mɨ̀ dré adrélé lèle ꞌòle àgo kòdhɨ ɨ rú dhɨ sè. ");
INSERT INTO log_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Gí rè lavúlé ko, Tèwúdà apfò tá ɨ́na tàá dhɨ, ɨ móndɨ́ kàdrɨ̀ ꞌɨ. Gò móndɨ́ ànyɨ́ànyɨ kámá-su dhɨ ɨ̀ dré ru amúzó akódhɨ be. Dɨ, akódhɨ nɨ pfùzo dràle gò, akódhɨ nɨ lebèbhá nda kɨ lapézó títí gò, àyɨ kɨ tà dré akɨ́zó nyɨ̌nyɨ. ");
INSERT INTO log_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Àmvolásà dhɨ, Yùdásɨ̀ angálépi Gàlìláyà lésè dhɨ dré kpà apfòzo lókyá à dré tá adréràꞌa móndɨ́ kɨ na dhɨ ꞌá gò, dré móndɨ́ zyandre dhɨ kɨ sèzo ɨ́ vésè. Dɨ, akódhɨ nɨ pfùzo kpà dràle gò, akódhɨ nɨ lebèbhá nda kɨ lapézó títí. ");
INSERT INTO log_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Dɨ nyànomvá, má adré tàá àmɨ dré dhɨ: Mɨ̀ kòtro àgo kòdhɨ kɨ tà rú ko. Mɨ̀ tayɨ́ àyɨ lɨ̀le. Tàko ko, tà ɨ̀ dré adrélé lèle ꞌòle dhɨ kàngá móndɨ́ ɨ vélésè dhɨ, a nɨ dra akɨ́lé. ");
INSERT INTO log_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Dɨ, tà nda kàngá ɨ́na Gìká vélésè dhɨ, mɨ̀ kɨtswá àmɨkya àyɨ kɨ kɨkɨ́ bwà ko. Mɨ̀ kàdré dɨ àmɨ kɨ lɨkɨ́, mɨ̀ kòkisúró àmɨ adréràꞌa ru pfu Gìká be ko!» Dɨ bhàgo kàdrɨ̀ nda ɨ̀ dré Gàmàlɨ̀yélè nɨ kúlí kaꞌìzo. ");
INSERT INTO log_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Gò ɨ̀ dré àpóstolò nda kɨ azízó, àyɨ kɨ ꞌòzo bhwàle gò, lazízóá àyɨ dri dhɨ, ɨ̀ kògò vélé tà ta Yésu nɨ rú sè ko. Gò ɨ̀ dré àyɨ kɨ tayɨ́zó lɨ̀le. ");
INSERT INTO log_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Dɨ àpóstolò nda ɨ̀ dré apfòzo bhàgo kàdrɨ̀ nda ɨ vélésè lenzébe lavúlé, Gìká dré tá kaꞌìle ɨ̀ kònya kanyò Yésu nɨ rú nɨ tà sè dhɨ sè. ");
INSERT INTO log_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Dɨ kìtú àlo àlo títí ɨ sè dhɨ, ɨ̀ adré tá tà tadhá tépelò na ɨ̀ndɨ̀ móndɨ́ kɨ dzó ɨ ꞌásè, adrézó Rúbí Tanɨ longó, adrézó tadhá dhɨ, Yésu Mèsɨ́yà ꞌɨ káyà dhɨ. ");
INSERT INTO log_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Lókyá nda kònàdhɨ sè dhɨ, Yésu nɨ kaꞌìbhá ɨ̀ adré tá lɨzólé lɨ̀le drìdrì. Dɨ, àyɨ nda ɨ kòfalé dhɨ, Yúdà ànzɨ adrébhá Gìríkì ti ta dhɨ ɨ̀ dré ngàzo adrélé kúlí tɨ Yúdà ànzɨ adrébhá Èbérè ti ta dhɨ ɨ rú. Ɨ̀ adré tá tàá dhɨ, à adré tá àyɨ kɨ tàyɨ́tòkó kɨ tà tɨvɨ̀, à dré tá adréràꞌa mányàngá lanzɨ́ móndɨ́ ɨ dré kìtú àlo àlo ɨ sè dhɨ ꞌá. ");
INSERT INTO log_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Dɨ àpóstolò mudrí-drì-rì dhɨ ɨ̀ dré móndyá kaꞌìbhá títí dhɨ kɨ kɨmózó gò, tàzoá àyɨ dré dhɨ: «Kɨtswá mà dré Gìká nɨ kúlí tadhama tayɨ́zó, kɨtswázó mányàngá nɨ tà ꞌo dhɨ ko. ");
INSERT INTO log_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Dɨ àma kɨ adrúpi ɨ, lè mɨ̀ kòkɨpè àmɨ kòfalé àgo nzi-drì-rì gabhá Tɨrɨ́ Lólo sè ɨ̀ndɨ̀ tògyá sè, àyɨ kɨ tà dré adrézó dóro móndɨ́ ɨ mìlésè dhɨ ɨ, mà kòtayɨ́ró àzí nda àyɨ drɨ́gá. ");
INSERT INTO log_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Dɨ àma ró dhɨ, mà nɨ àma kɨ fe títí adrélé tà ta Gìká be, adrézó kpà akódhɨ nɨ kúlí tadhá.» ");
INSERT INTO log_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Dɨ móndyá zyandre títí nda ɨ̀ dré tà nda nɨ kaꞌìzo. Gò ɨ̀ dré Sètèfánò, adrélépi tà kaꞌìkaꞌì ɨ́be kàdrɨ̀ ɨ̀ndɨ̀ gàlepi Tɨrɨ́ Lólo sè dhɨ kɨ kɨpèzo, túmä́ní Fìlípò ɨ́be, Pòròkórò be, Nìkànórà be, Tìmónà be, Pàrùménà be, tsàle Nìkòlá angál