﻿USE sofia;
DROP TABLE IF EXISTS sofia.lmd_vpl;
CREATE TABLE lmd_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES lmd_vpl WRITE;
INSERT INTO lmd_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","ꞌRan enni wothiki thoIeccuo oMiccie ukul woThauth, ukul wAprein. ");
INSERT INTO lmd_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Aprein pokwonot oIccaak ana oIccaak pokwonot oIakup ana oIakup pokwonot oIoutha akin opangon, ");
INSERT INTO lmd_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ana oIoutha pokwonot oPparic ana oThara nti iaThthamar ana oPparic pokwonot Accrun ana Accrun pokwonot oRam, ");
INSERT INTO lmd_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ana aRam pokwonot Aminathap ana Aminathap pokwonot oNaccun ana oNaccun pokwonot oCalmon ");
INSERT INTO lmd_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ana oCalomon pokwonot oPuac nti iapari oRaap ana oPuac pokwonot Opet nti iaRauth ana Opet pokwonot oIecce ");
INSERT INTO lmd_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ana oIecce pokwonot ili oThauth. Ana oThauth pokwonot oCiliman, nti ipari oUria, ");
INSERT INTO lmd_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","ana oCiliman pokwonot oRapaam ana oRapaam pokwonot Apia ana Apia pokwonot Acca ");
INSERT INTO lmd_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ana Acca pokwonot oIuccappat ana oIuccappat pokwonot oUram ana oUram pokwonot oUthia ");
INSERT INTO lmd_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ana oUthia pokwonot oIutham ana oIutham pokwonot Aac ana Aac pokwonot Acikkia ");
INSERT INTO lmd_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ana Acikkia pokwonot oManacce ana oManacce pokwonot Amun ana Amun pokwonot oIuccia ");
INSERT INTO lmd_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ana oIuccia pokwonot oIakkunia ana opangon nocaꞌri ica ul wonekittat noththok pen akin onekittat noththok poPapil. ");
INSERT INTO lmd_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Anakka ul wonekittathe noththok poPapil oIakkunia pokwonathe oCcaliththil ana oCcaliththil pokwonot oCerupapil ");
INSERT INTO lmd_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ana oCerupapil pokwonathe Apiuth ana Apiuth pokwonot Aliakkim ana Aliakkim pokwonot Acur ");
INSERT INTO lmd_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","ana Acur pokwonot oCcathuk ana oCcathuk pokwonot Akim ana Akim pokwonot Aliuth ");
INSERT INTO lmd_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ana Aliuth pokwonot Aliacir ana Aliacir pokwonot oMaththan ana oMaththan pokwonot oIakup ");
INSERT INTO lmd_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ana oIakup pokwonot oIuccip olle poMeriom ipokwonot oIeccuo ipakkarako itti oMiccie. ");
INSERT INTO lmd_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ittina thiki ithanthan appik thokat attul ana ikken kocoꞌrin nci nAprein oingkanthet oThauth (14). Ana nci naThauth caꞌri ica ul waik ikwat noththok poPapil, thiki thokat attul ana ikken kocoꞌrin (14). Ana nci nocaꞌri ica ul waik ikwat noththok poPapil oingkanthet oMiccie thiki thokat attul ana ikken kocoꞌrin (14). ");
INSERT INTO lmd_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Lon elli ileret kathar kothokwonta thoIeccuo oMiccie. Onnan pung oMeriom pokat pokkaccakinet oIuccip anaruk akka okin thaththarthuk ikkoik tothun kwincakathe itti kwoppethe mpuꞌran poKanang ikupupure. ");
INSERT INTO lmd_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ana oIuccip olle pung pappokat pul poporot tokït koKapik ana kwꞌrakathe itti kwakinnitto lon lopari oMeriom, akka ul occirok ngngin ana kwiꞌrekathe itti kwathïok nthuꞌran. ");
INSERT INTO lmd_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Anaruk akka kwokat akweret noucce itti kwathïok, auꞌrupa wothothïlettat woIli akkakanthok inthe athintiekathok aiꞌrekathok itti, “Iuccip ukul woThauth, kirrnni ipo nꞌre itti ngkwaneko oMeriom akwothakka pari pang, akka kwoppethe mpuꞌran poKanang ikupupure. ");
INSERT INTO lmd_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ana kwakwono ukul ana ngkwaccie kꞌran itti oIeccuo, akka waꞌret ul wung nti ilon ilokithak.” ");
INSERT INTO lmd_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Elli lokat cik appik othakka itti alomartto lon ila Ili wiꞌret nthon thopul pothernte lon loKapik oka ïcat itti, ");
INSERT INTO lmd_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Iꞌre wꞌrek iakannaꞌrutta ngngin aththik wappet ana wakwono ukul ana waccietta itti Amanauil” ilonu itti 'Kapik kaik naron.' ");
INSERT INTO lmd_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Anakka oIuccip purttat nti inthe, akwokkat ammakka uꞌrupa wothothïlettat woIli wiꞌrethok. Akwonakat pari pung tuan thanung. ");
INSERT INTO lmd_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Anaruk kwakannaꞌrat ngngin puccuk mono apokwonat ukul, akwocciekat kꞌran itti oIeccuo. ");
INSERT INTO lmd_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Anakka oIeccuo pokwontathe nokaꞌran koPeththelam noththok poIouthia nothuput thoIli oIruthuc, ul wꞌrek wakkakathe na cïngkï ummot ngngin aanthan nokaꞌran koUruccelim, ul wen wonat kꞌran itti Macuc ");
INSERT INTO lmd_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","wipittathe itti, “Ili woIouth waik kartha iokwontat? Onïn thimmathe cothot na cïngkï ummot ngngin ana onïn thaat ïnnathaꞌranok ngaꞌrama.” ");
INSERT INTO lmd_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Manakka Ili oIruthuc poccïkathe lon len kuakathe ka nul wung appik nokaꞌran koUruccelim. ");
INSERT INTO lmd_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ana Ili oIruthuc wakkarathe ul appik ittïttïk woul wonoppan toKapik tothun ana ul iangkene lon lothonceꞌret lon cik akwipittat kin itti, “OMiccie paik pakwontat kartha?” ");
INSERT INTO lmd_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Akin iꞌrekathok itti, “Kwaik pakwontat Peththelam noththok poIouthia akka ilen ila pul pothernte lon loKapik perethe itti, ");
INSERT INTO lmd_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Anaruk Peththelam ponoththok poIouthia, ngkwaka prïk tokït konili noththok poIouthia akka ili wanthan nti iul wang iathokatha lon loul woIccereil.’” ");
INSERT INTO lmd_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","AIli oIruthuc akkarat ul ioccot kꞌran itti Macuc thuꞌran, akwipittat kin caꞌri ica cothot cummothe ncik. ");
INSERT INTO lmd_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Kwothïathekin Peththelam akwiꞌrekat kin itti, “Ngkonon annokwantot ukul kicce amma onon thiothe annathiꞌrethin aneo cakuruk anothaꞌranok ngaꞌrama.” ");
INSERT INTO lmd_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Anakka okin thoccïkothe lon loIli oIruthuc akin oingkat. Anakka okin thokat cik ikathar akin eo akin immakat cothot aceo tokït ken icakin thaththimmathe na cïngkï ummot ngngin, mono acocoꞌrat toꞌra wokaꞌran na ukul wokat. ");
INSERT INTO lmd_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Anakka okin thimmat cothot, akin opirakat noka cannan. ");
INSERT INTO lmd_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Anakka akin iꞌriko noppan, okin thimmakathe ukul ana onnan oMeriom ana okin thekathe ungku ncik ana uet toma cik akin aꞌrakanthet ukul ngaꞌrama. Okin thanyathe aꞌruk wen akin ekat ukul aꞌrupu iakin thonanet ionu cekerek crïk, thaap ana oꞌren wokucuk ikakkunako ere amutha ana ngaak iakkunako ere amutha. ");
INSERT INTO lmd_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","AKapik akkakanthet kin ithathantako akiꞌrekat kin lon lonthoththomat itti okin thakorronno opakkinthet oIruthuc, akin okkat ikathar koka akin opakkot noththok pen. ");
INSERT INTO lmd_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Anakka Macuc meot, auꞌrupa wothothïlettat woIli akkakanthet oIuccip ithathantako aiꞌrekathok itti, “Uroki aneko ukul okin onnan aura aeo noththok poMuccir. Ikkoik than puccuk aniꞌrekathung caꞌri icao nan akka Ili oIruthuc paik pakwantot ukul itti kwakkwot.” ");
INSERT INTO lmd_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","AIuccip urokat ngkoꞌra akwonekat ukul ana onnan akwoingkat noththok poMuccir, ");
INSERT INTO lmd_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","nakin thikkot cik mono aIruthuc iat. Ana lon lokakathe ïcat ammakka Ili wothïothe pul pothernte lon loKapik ngngin akka piꞌret itti, “Mpakkarot ukul win noththok poMuccir.” ");
INSERT INTO lmd_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Manakka oIruthuc paththiot itti Macuc mammikkothok, akuakat ka cannan akwiꞌrekat lon lonthomat itti nyukul inyomura inyarran nyonu itti nyangutta appik nnokaꞌran koPeththelam ana manna naꞌran iaik iccik ken, ummo nciki nonyukul inyonu luput leꞌra ana manna inyurunokwonta nomaꞌri ima kwoccïkothe lon noul woMacuc nan. ");
INSERT INTO lmd_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ana lon ila pul pothernte lon loKapik Armia lokakatheik ila kwappiꞌret itti, ");
INSERT INTO lmd_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Kuri kokkuttathe nokaꞌran koRama, ngeme ana thiak thaccokakot cannan, oRail paik poot nyukul nyung ana kwꞌrat itti kwakannapiettat cik, akka okin thellaik nocapu.” ");
INSERT INTO lmd_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Manakka oIruthuc piot, auꞌrupa wothothïlettat woIli akkakanthet oIuccip ithathantako akkwaik noththok poMuccir ");
INSERT INTO lmd_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","aiꞌrekathok itti, “Uroki aneko ukul ana onnan apakkot ngngin noththok poIccereil, akka okin ithokat cik thakkwot ukul thillet.” ");
INSERT INTO lmd_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Akwurokat akwonekat ukul ana onnan akwopakkat kin ngngin noththok poIccereil. ");
INSERT INTO lmd_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Anaruk oIuccip poccïkathe itti Arakkalaoc paik nongili ngoththan oIruthuc noththok poIouthia, kwipathe nꞌre eo noththok pen. Kapik kiꞌrekathok lon lonthoththomat ithathantako ana kwoingkathe noththok poCelïl, ");
INSERT INTO lmd_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ana kwakkakathe ana kwaththikkat cik nokaꞌran koNaccir alokakat ammakka ul wothernte lon loKapik wiꞌret itti, “Kwakkarako itti pul poNaccir.” ");
INSERT INTO lmd_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ana nomaꞌri men oIuanna pomamuthie pakkakathe, akwikkat cik akwerene ul lon ithampang ithonthomat thoIouthia ");
INSERT INTO lmd_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","akwiꞌre itti, “Nopaꞌrine lon ilokithak cik akka ngili ngorothiꞌrot ngakko napuththut.” ");
INSERT INTO lmd_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ana oIuanna akka oIccaia pul pothernte lon loKapik pokat perethe llon itti, “Poꞌre popul paik pakkaro nti ithampang ithonthomat, itti ‘Nokuccenthet Ili kathar cik ana oceꞌrenthok kathar cik.’” ");
INSERT INTO lmd_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ana oIuanna pokat akwakukko eret wokkattathe norua tothamla ana akwiꞌrikakot kuꞌrat ikin ana kwokat cik akwïkïkko aun ana ortte kat. ");
INSERT INTO lmd_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ana ul wokat cik aukkinok nnokaꞌran koUruccelim ana nnaaꞌran woIouthia appik ana nnaꞌran woÜrüthün appik. ");
INSERT INTO lmd_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Anakka ul wokat cik aeret lon len thapat ilokithak ilokat nouce wen, kwikkatheik akwikket kin mamuthie norue toÜrüthün. ");
INSERT INTO lmd_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Anaruk akka oIuanna paththiot itti ul woppot woPriccin ana woCcathukkin wainok athocco mamuthie, kwiꞌrekathekin itti, “Nyukul nyoinyil enyrik, oththa akkiꞌrethenon itti onon thallot thua ka thoKapik ithanthan? ");
INSERT INTO lmd_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Nokkot ngre iakene itti onon thopaꞌrinet lon ilokithak cik. ");
INSERT INTO lmd_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Nokorronno omet kakon itti, ‘Onïn nyukul nyAprein.’ Mpiꞌret non itti Kapik kina oprtto mothok emmi cik amokakat nyukul nyAprein. ");
INSERT INTO lmd_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Nantoccïkot, pul ipathio ponekkethe kïnyït kocemeke ci nolaka lokira. Ana pira ipakorronno okwono nyukul nyoporot pakeccat cik aporrettakat ithik. ");
INSERT INTO lmd_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Mpethet non mamuthie ngngꞌri annopaꞌrine lon ilokithak cik, anaruk okkwi ipaik panthan prïk naun ana mpakannekko nan itti mpakꞌrinok loꞌrk nti wok wung. Ook akkethet non mamuthie ngKanang ikupupure ana nthik. ");
INSERT INTO lmd_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ana akwokkwo ton nnomïl akwïꞌrekat akwollakat liccit akwummo imoporot akunot ittit ana ton akwokꞌre nthik ithakinnio aththik.” ");
INSERT INTO lmd_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ana oIeccuo pakkakathe nnoththok poCelïl akweo norue toÜrüthün akwothocco mamuthie nti ikkun woIuanna. ");
INSERT INTO lmd_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Anaruk oIuanna pikkatheik ere kwꞌranok, ana kwomekathok itti, “Oun akkonu itti mpacco mamuthie nti ikkun wang ana tat akka ainin itti mpethung mamuthie?” ");
INSERT INTO lmd_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","AIeccuo othïanthok tit itti, “Kirrnni aloka inenni menik, akka orit thonu itti orit thakkot ammakka Kapik kongothe itti lakkattat appik.” AIuanna angkat. ");
INSERT INTO lmd_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Menik aIeccuo occat mamuthie nti ikkun woIuanna. Manakka oIeccuo poppot nti iꞌri, arothiꞌrot anyat akwimmakat Kanang koKapik akuo ntan naak ere cülükkür. ");
INSERT INTO lmd_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Apoꞌre akkakat ntothiꞌrot apiꞌre itti, “Ukul win enni ia mpongothe, mpopirat noka nan.” ");
INSERT INTO lmd_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ana Kanang koKapik konekathe oIeccuo ithampang ithonthomat, apul pothopulut othennekkek. ");
INSERT INTO lmd_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","OIeccuo papponat maꞌri arrial weꞌra (40) akkwocoꞌrot nothuꞌrit icïngkï ana ngkoꞌra ana akka kwocothothe maꞌri mothocoꞌro nothuꞌrit, kwokakathe piamat. ");
INSERT INTO lmd_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Akkwi ipennekketto akkakanthok akwiꞌrekathok itti, “Amma oung ukul woKapik, aiꞌret mothok emmi amothakkanung arrakith.” ");
INSERT INTO lmd_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","AIeccuo othïanthok tit itti, “Lokurrakot iatham itti, ‘Pul iponyi pakorronno ikkoik narrakith tulluk anaruk llon ila Kapik iꞌre.’” ");
INSERT INTO lmd_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Apul pothopulut onekathok icarak coman nokaꞌran koUruccelim ikupupure apoceꞌrekathok ci noꞌra wonoppan toKapik. ");
INSERT INTO lmd_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Apiꞌrekathok itti, “Amma oung ukul woKapik, aarre ka kang nci cene aarret nocapu, akka lokurrakot iatham itti, ‘Kapik kathïot uꞌrupa wothothïlettat wung llon lonthoththomat, ana waccinthung nyaun cik, akka akkwo wek mpothok.’” ");
INSERT INTO lmd_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","AIeccuo othïanthok tit itti, “Lokurrat iatham cakuruk itti, ‘Kirrnni enekke Ili Kapik kang.’” ");
INSERT INTO lmd_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Apul pothopulut apponekathok nocoꞌrong cukwit cannan apokenekathok ngili ngonocapu ncik appik ana thrïk then. ");
INSERT INTO lmd_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Apiꞌrekathok itti, “Mpethung aꞌrupu enni appik amma oung akkuethe toca cik tokït kin ana aꞌranin ngaꞌrama.” ");
INSERT INTO lmd_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","AIeccuo othïanthok tit itti, “Pul pothopulut, opaꞌrik ntokït kin akka lokurrakot iatham itti, ‘Aꞌranet Ili Kapik kang ngaꞌrama akka ook pulluk akkarekakine.’” ");
INSERT INTO lmd_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ittina apul pothopulut oththekat naIeccuo, auꞌrupa wothothïlettat woKapik akkakat aikkat cik akatha lon lung. ");
INSERT INTO lmd_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","AIeccuo occïkat itti oIuanna pakin thonekkethe ikorrkkor, akwopakkat noththok poCelïl. ");
INSERT INTO lmd_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Anaruk kwakinnikkat cik nokaꞌran koNaccir, kwoingkathe ana kwaththikkat cik nokaꞌran koKapprnaum ikaik nokuthut korok irapangka toCelïl nocik coCapulun ana coNapththalim. ");
INSERT INTO lmd_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Othakka itti alomartto lon ammakka pul pothernte lon loKapik oIccaia piꞌret akka piꞌret itti, ");
INSERT INTO lmd_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Pothok poCapulun ana pothok poNapththalim ipaik ikathar korok irapangka toCelïl eo norue thokꞌrakan koÜrüthün, Celïl coul iakannoka woIouth, ");
INSERT INTO lmd_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ul iaik iꞌrïmak wimmat kꞌran kocïngkï ikrïk akocco ana iaik nokaꞌran ikonu ngïꞌrïmak wimmat kꞌran kocïngkï akocco.” ");
INSERT INTO lmd_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ana nci nocaꞌri cen oIeccuo pikkatheik akwerene ul akwomet kin itti, “Nopaꞌrine lon ilokithak cik akka ngili ngorothiꞌrot ngakko napuththut.” ");
INSERT INTO lmd_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Anakka oIeccuo pokat cik akwonyaro nokuthut korok irapangka toCelïl, akwimmakat ul weꞌra ionat oththan pen pulukku, ꞌran wen wokat itti oCcamaan iponat kꞌran kothirit itti oPoththuruc ana opang Anthrauc okin thokat akin orret loꞌrok lape irok akka okin thaththokat ul woriape. ");
INSERT INTO lmd_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","AIeccuo omekat kin itti, “Nanthan, nomakothin, anothikkienon ul iacciccokot ul.” ");
INSERT INTO lmd_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Akin oththekat noloꞌrok lape len aththaman akin omakathok. ");
INSERT INTO lmd_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Akwoingkat ncïnang akwappimmakat ul weꞌra ionat oththan ana onnan pen pulukku cakuruk, okin thokat oIakup opei poCepethi ana opang oIuanna, okin thokat cik akin oththan pen oCepethi ikuppuꞌrung konoiꞌri akin okuccet loꞌrok cik lape akwakkarat kin. ");
INSERT INTO lmd_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Menik accokkot akin oththekat naththan pen ana kuppuꞌrung konoiꞌri, akin omakathok. ");
INSERT INTO lmd_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","OIeccuo pikkatheik akwonyaro naꞌran woCelïl akwongkenet ul nomuththun maꞌrama, akwerenekin lon iloporot longili ngoKapik ana akwittiet ul appik iokat wongo. ");
INSERT INTO lmd_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Alon lung opettakat cik noththok poCcuria appik aul ikkat cik annanok ul appik iongo mio kurekkurek, okin itha mio mokat amokꞌrello thiak thiak, okkwion itha uꞌrupa iokithak woꞌrot nan ana okkwion ithapellet ikapa ana okkwion ithaimico, akwittiekat kin. ");
INSERT INTO lmd_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Aul woppot omakathok noththok poCelïl ana Naꞌran iattul ana nokaꞌran koUruccelim ana naꞌran woIouthia ana arrot cik Ürüthün. ");
INSERT INTO lmd_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Anakka oIeccuo pimmat cungkut coul akwokuꞌrat noꞌra wocoꞌrong akwikkat cik. Ul iammakothok wakkakanthok, ");
INSERT INTO lmd_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","kwikkathe cik akwongkenekin akwiꞌre itti, ");
INSERT INTO lmd_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Thethïetta thaka noul ianekket cïkït noKapik akka ngili ngorothiꞌrot ngaka ngen. ");
INSERT INTO lmd_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Thethïetta thaka noul iaik waccokot thiak, akka okin thapiettat cik. ");
INSERT INTO lmd_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Thethïetta thaka noul iakinnipot ka thoura, akka okin thapakkot nocapu enci appik. ");
INSERT INTO lmd_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Thethïetta thaka noul iongothe kathar kothoka thoporot tokït koKapik, akka okin thaththakat. ");
INSERT INTO lmd_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Thethïetta thaka noul ionu thiak thoul, akka okin thipako thiak then. ");
INSERT INTO lmd_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Thethïetta thaka noul ionu mïkït mupupure, akka okin thimma Kapik. ");
INSERT INTO lmd_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Thethïetta thaka noul iakkot kuꞌri, akka okin thamettat itti nyukul nyoKapik. ");
INSERT INTO lmd_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Thethïetta thaka noul iaik waccokiettat thiak nti ithokkot lon iloporot, akka ngili ngorothiꞌrot ngaka ngen. ");
INSERT INTO lmd_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Thethïetta thaka thon amma ul wocungkwot non, ana occokiet non thiak ana eret non ngkarra ana llon lulluk ilokithak nti ilon lin. ");
INSERT INTO lmd_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Nopira noka ana iriko, akka thokketta thon ithrïk thaka tothiꞌrot, nina nan itti okin thocciccokiethe ul wothernte lon loKapik thiak tokït nanon.” ");
INSERT INTO lmd_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Onon thauculoththu ngonocapu. Anaruk amma nguculoththu ngothakkat ngocalang, ngappothikkietta ngira taththa? Ngakonnoka ngoporot pꞌrïn itti ngakkattat ngngre ngꞌrek, ngonu itti ngarretta angocukkarakot cik. ");
INSERT INTO lmd_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Onon kꞌran ikaccieik nocapu ncik appik. Kaꞌran ikaik noꞌra wocoꞌrong kakannamuꞌruttako ncik. ");
INSERT INTO lmd_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ul wakannoccie cuꞌru iconu ngaak tit iacco akin antokuꞌrupot papꞌrek nan, anaruk caka nocürük acina akka acocciene ul cik iaik tuan appik. ");
INSERT INTO lmd_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Menik nokorronno akꞌran kon occo tokït koul othakka itti akin imma ngre ngon ioporot, akin opirane oththe pon porothiꞌrot noka.” ");
INSERT INTO lmd_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Nokorronno ome itti mpaat anathoceꞌre lon lothonceꞌret lon cik loMucca ana thongkene thoul wothernte lon loKapik. Mpakannao itti anathoceꞌre anaruk mpaat itti anathothikkie ïcat. ");
INSERT INTO lmd_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Mpiꞌret non lon ilaik ïcat itti arothiꞌrot intakat cik ana capu, ceꞌrïpïl cella culukku cintat cik ana manna tamping nolon lothonceꞌret lon cik, puccuk alon okakat cik ïcat ilonekkettatheik. ");
INSERT INTO lmd_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ana okkwi iparrothe lon cik lotteik nolon elli ilonekkettatheik ana ongkene ul itti wakkot ammakka ook, kwathikkietta potteik ingili ngorothiꞌrot, anaruk okkwi iporekot ngngin ana ongkene ul cakuruk, kwathikkietta prïk ingili ngorothiꞌrot. ");
INSERT INTO lmd_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Anaruk mpiꞌret non itti amma thikkoik thon thokkot ngkathar ikoporot koKapik thakorronno oka thoppot nolon loul wothongkene lon lothonceꞌret lon cik ana ul woPriccin, onon thakinniꞌriko ingili ngorothiꞌrot.” ");
INSERT INTO lmd_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Onon thoccïkothe maꞌrot thupuththuput itti, ‘Pul pella pakkwot pul ana okkwi ipokkwothe kwanekittat imakkma.’ ");
INSERT INTO lmd_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Anaruk mpiꞌret non itti okkwi ipua ka kopang, kwanekittat imakkma. Ana okkwi manna ipocungkwot pul itti, ‘Pommaik,’ kwonu itti kwanekittat nocuththun coul woIouth ittïttïk akwothakkmako. Anaruk okkwi ipomethe pul itti pakannoka poporot, kwarrettat icꞌrot thothïrïn. ");
INSERT INTO lmd_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Amma ngkwaik pethet Kapik aꞌrupu noruꞌrot taꞌrama mono akwarikot itti opangkang ponu loꞌrek cik naung, ");
INSERT INTO lmd_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","oththe naꞌrupu wothokiot ngüccük cik tokït koruꞌrot taꞌrama annothopakkot ikuꞌri anopangkang kicce antathethet Kapik aꞌrupu wothokiot ngüccük cik wang. ");
INSERT INTO lmd_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Nopakkot ikuꞌri cokoccokot nopul ipanon thaꞌrettot anon thaik ikathar appaik aponekothung imakkma. Okkothe lon len antharthuk ikathar aththeꞌra akka akwethung ili ikkun ianceꞌret lon cik, ana ili wethung ili woul worikorrkkor ana ngkwanekkettat ikorrkkor. ");
INSERT INTO lmd_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Mpiꞌrethung lon ilaik ïcat, itti ngkwannao oppot thapat aththik akkekat papu ipoththeik ipokwentakot nocalak cang.” ");
INSERT INTO lmd_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Onon thoccïkothe maꞌrot itti, ‘Pul pella ipaꞌro nul iari ittat.’ ");
INSERT INTO lmd_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Anaruk mpiꞌret non itti okkwi ipokathat pul ipopari mono apiniekathok, nokatha kwaꞌrothe ngngin noucce. ");
INSERT INTO lmd_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Amma cït cang cothokkun wothothari cakkiethung lon ilokithak, antho nti ica arre akka laka loporot itti cït culukku cellaik akorronno onekot ka appik icoꞌrot. ");
INSERT INTO lmd_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ana amma ukun wang wothothari wakkiethung lon ilokithak, akiot cik akka laka loporot itti ukun wulukku wellaik notheo ngka appik thothïrïn.” ");
INSERT INTO lmd_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Nthoccïkothe cakuruk itti, ‘Okkwi ipothïot pari kwonu itti kwethok kaꞌrmacak kothothïako.’ ");
INSERT INTO lmd_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Anaruk mpiꞌret non itti okkwi ipothïot pari appakannaꞌro mpul, kwaik pakarrannok akwaꞌro nul. Ana okkwi ipipot pul pen, kwaik paꞌro mpul ipittat cakuruk.” ");
INSERT INTO lmd_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Ana onon thoccïkothe thupuththuput cakuruk itti, ‘Nokorronno aurrot thokkwo mio cik aththik anaruk noccot kït nolon ilanon thonekketheik annoIli.’ ");
INSERT INTO lmd_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Anaruk mpiꞌret non itti nokorronno arrma aththik manna nthiꞌrot akka thaporrok na Kapik ikkoik ");
INSERT INTO lmd_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ana okorronno okkwo manna capu akka kaꞌran na akwonekket tacok tung ana manna okorronno okkwo ngkaꞌran koUruccelim akka kaꞌran koKapik Ili irïk. ");
INSERT INTO lmd_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nokorronno arrma nca copul akka manna ngkwomma oprtto kwan cik kulukku athikkie kipuk ana manna othikkie konyï. ");
INSERT INTO lmd_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Alon lon oka tulluk itti ‘Ïï’ ana itti ‘Aa’ ana okkwi iparttothe noꞌron elli laka nopul pothopulut.” ");
INSERT INTO lmd_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Ana onon thoccïkothe cakuruk itti, ‘Cït cakketta ncït ana cïnyït cakketta ncïnyït.’ ");
INSERT INTO lmd_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Anaruk mpiꞌret non itti nokorronno orro ipul ipakkot lon ilokithak. Amma pul pꞌrek pokkworung thounu wokkun wothothari, aprttinok thounu wꞌrek cik. ");
INSERT INTO lmd_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ana okkwi ipongothe itti kwanekothung imakkma othakka itti akwonekothung kret konoka, korronnok akwoneko kret ikiththia ikakuꞌrupakakot cakuruk. ");
INSERT INTO lmd_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ana amma pul porithoꞌrak ponekorung mpuꞌran itti ngkwanekinok aꞌrupu atharothok, arothok ciththan. ");
INSERT INTO lmd_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ana okkwi ipipittothung papꞌrek ethok, kirrnni ꞌrane pul mpapu ipa kwongothe itti kwanekothung.” ");
INSERT INTO lmd_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Ana onon thoccïkothe itti, ‘Nongat ul wꞌrek ana annꞌra ul iathoꞌrak thon.’ ");
INSERT INTO lmd_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Anaruk mpiꞌret non itti nongat ul ianthaik ithoꞌrak ana aꞌrane ul ngaꞌrama iakkiet non thiak. ");
INSERT INTO lmd_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Othakka itti anon oka nyukul nyoththe pon ipaik tothiꞌrot akka ook akkummienthet ul cïngkï appik iakkot lon lokithak ana iakkot lon iloporot ana apiene ul kapik iammakot kathar ika Kapik kongothe ana ul iakannommakot kathar ika Kapik kongothe. ");
INSERT INTO lmd_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Amma onon thongothe ul tulluk iongothenon, ngintha akka annocco ntit? Akka ul iaꞌrntinthet nili akucci wakkot menik cakuruk. ");
INSERT INTO lmd_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ana amma onon thakannomicco ul wꞌrek aththik annomicco opangkangon thulluk, ngintha akka annocco ntit? Ul iomma lon Kapik waik wakannokkot menik cakuruki? ");
INSERT INTO lmd_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ittina noka thoporot ammakka oththe pon porothiꞌrot poporot.” ");
INSERT INTO lmd_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Noꞌrumoik, nokorronno okkot lon iloporot lon tokït koul, othakka itti akin imma non. Amma onon thokkothe ittina, ana onon thakorronno occo lon iloporot nnaththe pon ipaik tothiꞌrot. ");
INSERT INTO lmd_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ana amma ngkwethet pul ipella aꞌrupu cik papꞌrek, kirrnni erene ul, ammakka okkwion ithinnikot lon okkot nomuththun maꞌrama ana iathar othakka itti aul othianekin cik. Mpiꞌret non lon ïcat itti okin ammakka enthrïk thoccot lon len pꞌrin. ");
INSERT INTO lmd_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Anaruk amma aethet pul ipella aꞌrupu cik, kirrnni okorronno manna itti ukun wang wothokure wina nolon ila ukun wothothari waik wakkot, ");
INSERT INTO lmd_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","othakka itti athethet thang oka thamuꞌruttakot ncik. Ittina oththe pang ipimma lon ila ngkwokkothe nthuꞌran pethung lon iloporot.” ");
INSERT INTO lmd_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Ana amma onon aꞌra ngaꞌrama nokorronno oka karkko ul innikot lon, akka okin thongothe itti okin thaꞌra ngaꞌrama akin ocoꞌrot kapik nomuththun maꞌrama ana iathar, othakka itti aul imma kin attattar. Mpiꞌret non lon ïcat itti okin ammakka enthrïk thoccot lon len pꞌrin. ");
INSERT INTO lmd_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Anaruk amma ngkwongothe itti ngkwaꞌra ngaꞌrama iꞌriki noppan aunukkwo kathat aꞌrane oththe porothiꞌrot ngaꞌrama ipakinnimmako, ook ipimma lon ilamuꞌruttakot ncik ook akkethung lon lang. ");
INSERT INTO lmd_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Amma annaꞌra ngaꞌrama nokorronno opakkukkwet lon tit loppot karkko ul iomma Kapik akka okin thapri itti Kapik kaccïkot kin amma akin opakkukket lon tit. ");
INSERT INTO lmd_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nokorronno oka karkken, akka oththe pon porothiꞌrot pina lon lon ila nthongothe, anon tharthuk ipittothok. ");
INSERT INTO lmd_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ittina onon thonu itti nthaꞌra ngaꞌrama ittina, ‘Ngappa pïn ipaik tothiꞌrot, akꞌran kang othiakineik, ");
INSERT INTO lmd_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","angili ngang anthan, alon ila ngkwongothe itti lakkattat, alokkattat nocapu ammakka lokkattathe tothiꞌrot. ");
INSERT INTO lmd_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ethet nïn thuꞌrit ithekko nanïn inenni. ");
INSERT INTO lmd_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Occïkïnthet nïn lon lïn ilokithak akka onïn cakuruk thaccïkanthet okkwion ithokkinthent nïn lon ilokithak. ");
INSERT INTO lmd_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kirrnni apiet nïn ithenekketta anaruk oꞌrethenïn nti ilon lopul pothopulut.’ ");
INSERT INTO lmd_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Amma onon akkaccïkïnthet ul lon ilakin thokkinthet non ilokithak, ana oththe pon porothiꞌrot paccïkïnthet non cakuruk. ");
INSERT INTO lmd_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ana amma onon thakannoccïkïnthet ul lon ilokithak ilakin thokkinthet non, oththe pon pakannoccïkïnthet non lon lon ilokithak cakuruk.” ");
INSERT INTO lmd_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ana amma onon thocoꞌrot nothuꞌrit, annokorronno onthoma toma karkko ul innikot lon, wathikkie toma men mïrrïn othakka itti aul ina nakin itti okin thocoꞌrot nothuꞌrit. Mpiꞌret non lon ilaik ïcat itti okin ammakka enthïrïk thoccot lon len pꞌrin. ");
INSERT INTO lmd_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Anaruk amma ngkwocoꞌrot nothuꞌrit, ilakki toca ana oꞌroko ngaak ");
INSERT INTO lmd_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","othakka itti aul okorronno ina itti ngkwocoꞌrot nothuꞌrit, anaruk aththe pulluk pang akkina ipakinnimmako ook ipimma lon ilamuꞌruttakot ncik ook akkethung lon lang.” ");
INSERT INTO lmd_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Nokorronno aꞌrintinthet ka kon thaꞌrthan cik nocapu, na nangak ana piricirot okïtto, ana na ul wothuꞌran ongwoik akin omunye. ");
INSERT INTO lmd_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Anaruk naꞌrntinthet ka kon thaꞌrthan cik tothiꞌrot na nangak nella ana piricirot okorronno okïtto ana ul wothuꞌran wakorronno ululoik itti wamunye. ");
INSERT INTO lmd_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Akka cïkït cang caka na thaꞌrthan thang thaik cakuruk. ");
INSERT INTO lmd_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Cït corica cakꞌran koka kang. Ana amma kït kang akkimmaik kicce ana ngkwimma kathar ikoporot na akko. ");
INSERT INTO lmd_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ana amma kït kang kakinnimmaik kicce ana ngkwakinnimma kathar ikoporot na akko. Ana amma kꞌran ikaik iaung kaiꞌrïmak ana ngkwaka iꞌrïmak kirrkkir. ");
INSERT INTO lmd_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Pul pella parekine opïngon theꞌra, kwonu itti kwꞌra opït pꞌrek akwongat apꞌrek ana manna itti kwaccokot pulukku ana akwopaꞌrine cik apꞌrek. Ittina lomma itti onon thangat Kapik ana ongat thaꞌrthan.” ");
INSERT INTO lmd_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Ittina mpiꞌret non itti nokorronno opellene lon lothikkoik itti onon thaꞌrko ngimpen ana ako ngimpen. Thikkoik thakonnoka thoporot nothuꞌriri? Ana ka kopul kakannoka koporot noreri? ");
INSERT INTO lmd_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Nantokatha uꞌrupe worothiꞌrot, akka wakannora ana wakannokio ana wella irit cik anaruk icci oththe pon porothiꞌrot akkaꞌrikiekin. Onon thakannoka thoporot cannan nouꞌrupei? ");
INSERT INTO lmd_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Oththa nti ianon iparttot caꞌri culukku nomaꞌri mothikkoik mung amma kwonu nꞌre? ");
INSERT INTO lmd_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Nthontha akka annoccot kït noret? Nantokatha poꞌren porikkwon akka apocokka. Pakannoreko apakie ka ken. ");
INSERT INTO lmd_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Anaruk mpiꞌret non itti manna oCiliman nthaꞌrthan thung ithïrïk, kwakannako eret wopeththere ere poꞌren empi. ");
INSERT INTO lmd_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Amma Kapik kaꞌrumo noraco irakaik inenni ana ngorrot arorrettat ithik, Kapik kakannoꞌrumo nanoni? onon ithonu thoccokot lon loKapik nomïkït thoththeik. ");
INSERT INTO lmd_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ittina nokorronno ona nꞌre anniꞌre itti, ‘Onïn thaꞌrko ngimpen?’ ana ‘Ïkko ngimpen?’ ana ‘Onïn thako ngimpen?’ ");
INSERT INTO lmd_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Akka ul iomma lon loKapik wammakot thuꞌrit ana aꞌrupu wꞌrek, ana oththe pon porothiꞌrot pina itti nthongothe aꞌrupu wen appik. ");
INSERT INTO lmd_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Anaruk cittokït nipitto ngili ngoKapik ana thoporot thung, ana aꞌrupu enni appik weettat non cakuruk. ");
INSERT INTO lmd_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ittina nokorronno ipo nꞌre nolon lorrot akka ngorrot ngakatha lon loka kung. Akka caꞌri culukku conu lon lung prek.” ");
INSERT INTO lmd_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Nokorronno akkma opilin akka onon akkmako cakuruk. ");
INSERT INTO lmd_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Akka ngkathar ikanon akkma ul wꞌrek ngngin, onon thakkmako ngngin cakuruk, ana ngkathar ika annopekie llon iken akka annopekiettane llon lon cakuruk. ");
INSERT INTO lmd_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ngkwontha akka accot kït nokwira ikaik icït copangkang akorronno occot kït nokwoꞌren ikaik icït cang? ");
INSERT INTO lmd_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Taththa akka amet opangkang itti, kirrnni anumminung kwira nti icït angkwonu kwoꞌren icït cang? ");
INSERT INTO lmd_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Oung ipinnikot cik, ummi kwoꞌren nti icït cang aimmaik kicce antummine opangkang kwira nti icït cung. ");
INSERT INTO lmd_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Nokorronno erene ul lon iloporot iakannangkot itti waccïkot akka okin thꞌra ana okin thꞌranon.” ");
INSERT INTO lmd_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Noꞌrungkot nolon ipitto ana lon len lettat non, nokwantot lon ana onon thiot, ana okkwi ipipitto thittarakot ana kwittarakot. ");
INSERT INTO lmd_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Akka okkwi ipipitto lon kwettat ana okkwi ipakwantot kwiot ana okkwi ipipitto thittarakot ana kwittarakot. ");
INSERT INTO lmd_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Oththa nti ianon amma opei pipittothok arrakith, akwethok pothok ");
INSERT INTO lmd_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","ana manna amma kwipittothok pape, akwethok pinyili? ");
INSERT INTO lmd_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ana amma onon manna ithonu lon ilokithak thina akka annethet nyukul nyon aꞌrupu ioporot, oththe pon porothiꞌrot pakannethet okkwion ithipittothok aꞌrupu woppot ipoporori? ");
INSERT INTO lmd_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ittina nokkinthet ul lon ilanon thongothe itti okin thakkinthet non, akka lon lothonceꞌret lon cik loMucca ana loul wothernte lon loKapik langkene ittina.” ");
INSERT INTO lmd_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Niꞌriko nti icürük cokathat icomü akka cürük icape caeo thothïrïn ana kathar ken konyra kaul woppot wakkorit. ");
INSERT INTO lmd_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Anaruk cürük icomü ana kathar ikonu cürük comu kanekarot nothikkoik thothupuththuput ana ul wotteik akkakkorit.” ");
INSERT INTO lmd_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Noꞌrumoik noul wothernte lon loKapik ngkarra. Okin thainenon nyuruun ere lungkat anaruk mïkït men mokithak karkko mipa imongothe itti mamotto ianon puꞌrut puꞌrut. ");
INSERT INTO lmd_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Kira kinako nynyukul nyen. Ul withtho ïce nopira polï ana manna moꞌriompong nopakeki? ");
INSERT INTO lmd_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ammakka menik, pira ipoporot pakwono nyukul nyoporot anaruk pira ipokithak pakwono nyukul nyokithak. ");
INSERT INTO lmd_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Pira ipoporot pakannokwono nyukul nyokithak ana pira ipokithak pakannokwono nyukul nyoporot. ");
INSERT INTO lmd_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kira appik ikannokwono nyukul nyoporot kakuccettat cik akorrettat ithik akokꞌretta. ");
INSERT INTO lmd_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ittina onon thina kin nynyukul nyen.” ");
INSERT INTO lmd_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Annoka ul appik iꞌrethin itti, ‘Ili, Ili,’ wiꞌriko ingili ngorothiꞌrot anaruk okkwi ipakkot lon ila angappa ipaik tothiꞌrot pongothe. ");
INSERT INTO lmd_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ul woppot wiꞌrethin nocaꞌri cothakkmako itti, ‘Ili, Ili, onïn thakannerente lon loKapik ngkꞌran kangi ana okïcce uꞌrupa iokithak nti iul ngkꞌran kangi ana okkot lon loppot ilommaththik ngkꞌran kangi?’ ");
INSERT INTO lmd_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ittina mpiꞌret kin nci nokkït itti, ‘Mpomma non kirrkkir. Nopaꞌroik nti iccik kin onon ul wolon ilokithak.’” ");
INSERT INTO lmd_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Ittina okkwi ipaccïkot lon lin elli ana oreko ngngin kwaka ammakka pul ipinaik ipunot man nocik iconthomat. ");
INSERT INTO lmd_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Anakka kapik kaat aiꞌri oppakat tue akanang ikkat cik akokkurarot anaruk man makannapat akka mokat muntat nokancang. ");
INSERT INTO lmd_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Anaruk okkwi ipaccïkot lon lin mono akwokorronno oreko ngngin, kwaka ammakka pul ipommaik nti ica ipunot man mung nokamur. ");
INSERT INTO lmd_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Anakka kapik kaat angike oppakat tue, akanang ikkat cik akokkurarot. Anakka man mokat makannunta lon loporot akanang ikkat cik akokkurarot cannan aman apat ikkitheththak.” ");
INSERT INTO lmd_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Akka oIeccuo pomarttot lon elli, cungkut coul coprttakatherit noꞌron lothongkene elli, ");
INSERT INTO lmd_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","akka kwongkenet ere pul iponu ngili ikkun ana okorronno oka ammakka ul wen wothongkene lon lothonceꞌret lon cik. ");
INSERT INTO lmd_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Anakka oIeccuo paat ntocoꞌrong, acungkut coul woppot omakathok. ");
INSERT INTO lmd_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Apul pꞌrek akkakat ponat ïnyï noka apeekat ungku ncik tokït kung apiꞌrekathok itti, “Ili, amma oung akkongothe ana ngkwittiethin.” ");
INSERT INTO lmd_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","AIeccuo othiekat ukun akwothantat pul akwiꞌrekat itti, “Mpongothe itti mpittiethung othakka poporot.” Ittina aïnyï ittakanthet pul pen accokkot. ");
INSERT INTO lmd_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ittina aIeccuo iꞌrekathok itti, “Amma ngkweot akorronno iꞌret pul pꞌrek lon elli. Anaruk ngko athokene pul ponoppan toKapik ka kang akiat papu pothokiot nguccuk cik ammakka oMucca piꞌret akenekin itti ngkwothakkat poporot.” ");
INSERT INTO lmd_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Anakka oIeccuo piꞌrikot nokaꞌran koKapprnaum aili woul arrial ukuluk irro (100) akkakanthok, aipittathok itti kwittarothok. ");
INSERT INTO lmd_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Aiꞌrekat itti, “Ili, pul iparekinin paik tuan paka kaik kakꞌrello cannan ana pomma uroko nnonthe.” ");
INSERT INTO lmd_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","AIeccuo iꞌrekathok itti, “Mpanthan anathittiethok.” ");
INSERT INTO lmd_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Aili woul arrial ukuluk irro othïat tit itti, “Ili, mpakannekko nan itti ngkwiꞌriko noppan thanin. Anaruk iꞌre lon tulluk ana pul iparekinin pathakka poporot. ");
INSERT INTO lmd_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Oun cakuruk paik ikkun woili irïk naun, ana ul irro waik inyaun nyin. Mpiꞌret okkwempi itti, ‘Ngko’ ana kwaeo, ana mpiꞌret okkwempeꞌre itti, ‘Aꞌrik’ ana kwao, ana mpiꞌret pul iparekinin itti, ‘Okkothe elli’ ana kwakkot.” ");
INSERT INTO lmd_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Anakka oIeccuo poccïkothe elli, akwoprttakat tit akwiꞌrekat ul iokat cik ammakothok itti, “Mpiꞌret non lon ilaik ïcat, mpakanniot pul pꞌrek aththik noththok poIccereil nthoccokot lon loKapik nocïkït thena. ");
INSERT INTO lmd_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Mpiꞌret non itti ul woppot wanthan na acïngkï ummot ngngin ana na acorungkwot, ana wathikkoik nokamuthe okin Aprein ana oIccaak ana oIakup ingili ngorothiꞌrot. ");
INSERT INTO lmd_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Anaruk okkwion itha ngili ngorothiꞌrot ngokucettanthet thaKapik orret thapat iꞌrïmak akin antoo ana okꞌrellot kïnyït thocipit.” ");
INSERT INTO lmd_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ittina aIeccuo iꞌrekat ili woul irro itti, “Ngko ana ngkwathiot alokkattathe ammakka ngkwonu nocïkït cang itti lakkattat.” Ana pul iparekinok pittakathe nocaꞌri cen. ");
INSERT INTO lmd_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Anakka oIeccuo paat thoPoththuruthon, kwaththiat opïthe poPoththuruc ipopari akwïcat cik iaꞌrangkal akkwongo ippa. ");
INSERT INTO lmd_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","OIeccuo pothntathok ukun alü opaꞌrat cik nti iaak akurokat akwikkat cik akwokkinthet oIeccuo thuꞌrit. ");
INSERT INTO lmd_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Anakka cipin capot, akin onakanthok ul woppot ia uꞌrupa iokithak woꞌrot nan ana kwokïccekathe ntiakin llon ana ittiet ul iokat wongo appik. ");
INSERT INTO lmd_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Elli lokkattathe alomartto lon ila oIccaia pul pothernte lon loKapik piꞌret iatham wung itti, “Kwonekot thokinya thonnon ana kwittietheron nnomio.” ");
INSERT INTO lmd_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Anakka oIeccuo pimmathe ul woppot iccik kung kwiꞌrekathe ul iammakothok lon lonthomat itti okin tharrot nocarkan corok cꞌrek. ");
INSERT INTO lmd_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ittina apul pꞌrek ipangkene lon lothonceꞌret lon cik akkakanthok apiꞌrek itti, “Pul ipangkene, mpammakothung na eo.” ");
INSERT INTO lmd_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","AIeccuo othïanthok tit itti, “Mipa monu kürük na amïcat cik ana uꞌrupe worothiꞌrot wonu nune anaruk ukul wopul iponyi wella kaꞌran cik na aïcat cik angoko.” ");
INSERT INTO lmd_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Apilin nti iul iokat cik ammakothok iꞌrekathok itti, “Ili, korronnon aneo cittokït anothocïkko opappa.” ");
INSERT INTO lmd_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Anaruk oIeccuo piꞌrekathok itti, “Omakothin, kirrnni aul illet ocïkko ul illet.” ");
INSERT INTO lmd_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ittina akwarrat ikuppuꞌrung konoiꞌri aul iammakothok omakathok. ");
INSERT INTO lmd_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ana kanang kakkakathe accokkot norok akokkurarot cannan akikkat cik akokkurarot kuppuꞌrung athopangka thoiꞌri ongkuꞌrot ciki ithiꞌrot aiꞌri ikkat cik angothukkwot ikuppuꞌrung. Anaruk oIeccuo pokat cik inthe. ");
INSERT INTO lmd_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Aul iammakothok oingkat athurttathok, aiꞌrekathok itti, “Ili Ili, oꞌrethenïn oron thaik thathïkïkko ngꞌri.” ");
INSERT INTO lmd_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Akwothïat tit itti, “Onon ithonu thoccokot tholon loKapik nomïkït thotteik, nthontha akka annopelle?” Akurokat kapik akwothirriekat kanang cik ana thopangka thoiꞌri ana cik cokkwathe ka appik. ");
INSERT INTO lmd_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ul woprttakatherit ana wikkatheik aipitto itti, “Pul pokartha empi? Pakanang ana thopangka thoiꞌri occïkot lon len.” ");
INSERT INTO lmd_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Anakka kwaat nocarkan corok cꞌrek opakkot nocik coCethirin aul wꞌrek weꞌra ionat uꞌrupa iokithak ocurarat iaak awokat cik anthan nonupu na awokat aikikkoik. Wokat cik acomokko noul ana ilen akka pul pellanet ipakko ikathar ken. ");
INSERT INTO lmd_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Aul wen iꞌrekat lon mpoꞌre cittan itti, “Ukul woKapik, ngintha akka ngkwongothe nanïn? Ngkwaat cene itti ngkwathokkiet nïn thiak acaꞌri cothakkmako carthuk aoi?” ");
INSERT INTO lmd_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ana iccik ken cïnang cungkut conuththuruk cokat cik acuꞌro. ");
INSERT INTO lmd_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Auꞌrupa iokithak ipittat oIeccuo itti, “Amma ngkwakïccet nïn thapat akïccet nïn icungkut conuththuruk.” ");
INSERT INTO lmd_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","AIeccuo iꞌrekat kin itti, “Noppot thapat.” Auꞌrupa iokithak oppat thapat nti iul ieꞌra aiꞌrikat icungkut conuththuruk acungkut conuththuruk occorat kiththik uo nokuthut korok aniꞌrikikkat iiꞌri anïkïkkat ngꞌri anillekat. ");
INSERT INTO lmd_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Aul iokat cik auꞌre nuththuruk ollat kiththik eo icarak coman, akin otherekanthet ul lon appik lonuththuruk ana ilokkattanthet ul ionat uꞌrupa iokithak. ");
INSERT INTO lmd_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Aul oppat thapat nti icarak coman appik athocurarot iaIeccuo. Anakka ul wimmat oIeccuo akin iꞌrekathok itti, “Ngko, opaꞌroik noththok pïn.” ");
INSERT INTO lmd_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","AIeccuo arrat ikuppuꞌrung konoiꞌri, akwarrat tok cik akwakkakat nokaꞌran koKapprnaum ikokat kaꞌran kung. ");
INSERT INTO lmd_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Aul wꞌrek onakanthok pul pakimico naꞌrangkal. Manakka oIeccuo pimmat thoccokot tholon loKapik nomïkït then akwiꞌrekat pul ipakimico itti, “Ukul, kirrnni opelle, lon ilokithak lang loccïkakothe.” ");
INSERT INTO lmd_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ittina aul wꞌrek iangkene lon lothonceꞌret lon cik erekat nomïkït men itti, “Pul empi paik pacungko Kapik.” ");
INSERT INTO lmd_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","AIeccuo inakat lon ilakin thokat akin okwarttikot nomïkït men akwiꞌrekat kin itti, “Nthontha akka annokwarttikot cik thokwarttikot cik ithokithak nomïkït mon ittina? ");
INSERT INTO lmd_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Liatha akkoporot itti liꞌretta, itti, ‘Lon ilokithak lang loccïkakothe’ ana amma okorronno oka menik aiꞌre itti, ‘Uroki aeoi?’ ");
INSERT INTO lmd_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Anaruk othakka itti annina itti ukul wopul iponyi wonu puꞌran nocapu itti waccïkïnthet ul lon ilokithak.” Akwiꞌrekat pul ipakimico itti, “Uroki aneko aꞌrangkal aeo tuan.” ");
INSERT INTO lmd_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Akimico urokat kapik apoingkat tuan. ");
INSERT INTO lmd_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Anakka cungkut coul cimmat lon elli, akin ipat nꞌre ana okin thopirakanthet Kapik noka ikethet pul iponyi ngili ammakka engi. ");
INSERT INTO lmd_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Anakka oIeccuo pokat cik akweo oththe nokaꞌran ken, kwimmakathe pul ipoccot kꞌran itti oMaththa apikkoik nokaꞌran koul iaꞌrntinthet nili akucci. Akwiꞌrekathok itti, “Omakothin,” aMaththa urokat akwomakathok. ");
INSERT INTO lmd_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Anakka oIeccuo pokat cik akwoꞌrkoik thoMaththan, aul woppot iaꞌrntinthet nili akucci ana ul wꞌrek wolon ilokithak akkakat akin oꞌrkkat cik akin oIeccuo ana ul iammakothok. ");
INSERT INTO lmd_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Anakka ul woPriccin wimmat lon elli, okin thipittathe ul iammakothok itti, “Pul ipangkene pon pontha akka apoꞌrkoik okin oul iaꞌrntinthet nili akucci ana ul wꞌrek wolon ilokithak?” ");
INSERT INTO lmd_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Anakka oIeccuo poccïkothe lon elli akwiꞌrekat kin itti, “Okorronno oka ul ioporot akkongothe itti wittiettat anaruk ul iongo. ");
INSERT INTO lmd_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Anaruk ngkonon annothokwarttikot lon elli itti laik leret ngimpen, ‘Mpongothe itti nthipo thiak ana mpakannangkot aꞌrupu wothokiot ngüccük cik.’ Akka mpaakannao anathakkaro ul ioporot, anaruk ul wolon ilokithak.” ");
INSERT INTO lmd_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ittina aul woIuanna pomamuthie iammakothok akkakat akin ipittat oIeccuo itti, “Ngintha akka anïn ana ul woPriccin ocoꞌrine nothuꞌrit aul iammakothung okorronno ocoꞌro nan?” ");
INSERT INTO lmd_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","AIeccuo othïat tit itti, “Opurukon thopul ipipo thaka ithmeru taththa apul ipipo paik ithoꞌrkït then? Caꞌri canthan ica pul ipipo onekitta nti ithoꞌrkït then akin antocoꞌro nothuꞌrit. ");
INSERT INTO lmd_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Pul pella pakkwo kret ikïpe cït nthan ngkret ikie, akka kret ikokkuttat ncït than kapo ana kakkot cürük cïttïk. ");
INSERT INTO lmd_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Pul pella pipot thrupa ikaꞌruk ikïpe. Amma kwipotherit ana thinya ana thillo kaꞌruk akka kïpe, ana thrupa thallot cik nti ikaꞌruk ana kakïttako. Anaruk thrupa thonu itti thuntat ikaꞌruk ikie athoꞌrungkat cik ana kaꞌruk ikie oꞌrungkot cik.” ");
INSERT INTO lmd_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Anakka kwokat cik akwere lon elli aili wꞌrek akkakat wonocuththun caꞌrama aekat ungku ncik tokït kung aiꞌrekat itti, “Ukul win iopari wiot inaina. Anaruk aꞌrik athonekket ukun nan ana wakkoik.” ");
INSERT INTO lmd_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","AIeccuo urokat akin oingkat akin aththeꞌra ana ul iammakothok womakathok. ");
INSERT INTO lmd_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ana ncïnang, pul pꞌrek ipopari pokat cik ponu luput attul ana ikken keꞌra (12) aüccük ollo nti iaak apakkakat nthoccul koIeccuo apothntat thon thokret kung. ");
INSERT INTO lmd_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Akka kwapperethe nocïkït cung itti, “Amma mpothntot kret kung tulluk ana mpittat.” ");
INSERT INTO lmd_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","AIeccuo olliakat akwimmakathok akwiꞌrekathok itti, “Ukul win, kirrnni opelle thoccokot tholon loKapik nocïkït thang thittiethung.” Pul ipopari pittakathe nci nocaꞌri cen. ");
INSERT INTO lmd_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Anakka oIeccuo piꞌrikot noppan toili akwimmakat ul aee uꞌrumpillang tounge ana ul wokat cik aoo ana okkot camutta, ");
INSERT INTO lmd_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","akwiꞌrekat kin itti, “Nopaꞌroik, ukul wakinnio, anaruk wakko inthe.” Anaruk okin thoccirathok ngngin. ");
INSERT INTO lmd_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Anakka ul wopaꞌrettat cik akwiꞌrikat noppan akwonthat ukul ncik nukun ana wurokathe kapik. ");
INSERT INTO lmd_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Alon len opettakat cik naꞌran wen appik. ");
INSERT INTO lmd_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Anakka oIeccuo poththet nokaꞌran engkꞌre, aul wꞌrek weꞌra wiꞌrimathe omakathok aikkat cik akkakkarok itti, “Ukul woThauth, ipi thiak thïn.” ");
INSERT INTO lmd_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Anakka oIeccuo piꞌrikot noppan aul iꞌrimathe othakkarat iccik kung akwipittat kin itti, “Onon thoccokothe lon nomïkït mon itti mpina ittiet noni?” Akin othïat tit itti, “Ïï, Ili.” ");
INSERT INTO lmd_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ittina akwothntat kït ken akwiꞌrekat itti, “Alokkattanthet non ammakka nthoccokothe lon nomïkït mon itti laka.” ");
INSERT INTO lmd_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Akït ken anyat aIeccuo iꞌrekat kin lon lonthomat itti, “Noccïkot lon elli, apul ella ina nolon elli.” ");
INSERT INTO lmd_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Anaruk okin thoingkathe akin opettat lon cik naꞌran wen appik. ");
INSERT INTO lmd_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Anakka ul ittiettathe wokat cik aeo, pꞌrin, aul wꞌrek onakanthet oIeccuo pul pꞌrek pauꞌrupa iokithak woꞌrot nan ana pommat ere. ");
INSERT INTO lmd_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Anakka uꞌrupa iokithak wokïccettat, pul pen pikkatheik apere ana ul woprttakatherit nolon len akin iꞌrekat itti, “Onïn thakinnimmat lon ammakka elli noththok poIccereil caꞌri cꞌrek.” ");
INSERT INTO lmd_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Anaruk ul woPriccin wiꞌrekathe itti, “OIeccuo pakïcce uꞌrupa iokithak mpuꞌran poili wouꞌrupa iokithak.” ");
INSERT INTO lmd_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","OIeccuo pokkettekathe naꞌran appik akwongkene nomuththun maꞌrama ana ere lon iloporot longili ngoKapik ana ittiet ul nomio imokat kurekkurek appik. ");
INSERT INTO lmd_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Anakka kwimmat cungkut coul, kwipathe thiak then akka okin thokat nothiak ana nthokinyat, okin thokat ere lungkat ilellat opït nan. ");
INSERT INTO lmd_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ittina akwiꞌrekat ul iammakothok itti, “Kopon kokwonot mïl moppot anaruk ul iakio wotte. ");
INSERT INTO lmd_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ittina naꞌrane Ili ngaꞌrama ook iponu kopon ikakecca akwothïot ul ikkwon kung athokio.” ");
INSERT INTO lmd_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","OIeccuo pakkarathe ul wung iammakothok iattul ana ikken keꞌra (12) ana kwekathekin puꞌran akin okïcce uꞌrupa iokithak ngngin ana ittiet ul iongo mmio kurekkurek. ");
INSERT INTO lmd_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","ꞌRan enni woul wung wothothïlettat iattul ana ikken keꞌra, kꞌran kopul porokït itti, oCcamaan (ipoccot kꞌran itti oPoththuruc) ana opang Anthrauc, ana oIakup ukul woCepethi ana opang oIuanna, ");
INSERT INTO lmd_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ana oPilippic ana oPerththolomauc ana oThthoma ana oMaththa ipaꞌrntinthet nili akucci ana oIakup ukul wAlappaoc ana oThthothaoc ");
INSERT INTO lmd_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ana oCcamaan ipokat pongothe lon lothok pung poIccereil ana oIoutha Icikkariuththi ipokerothe oIeccuo nili. ");
INSERT INTO lmd_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Anakka oIeccuo pokat cik akwothïot kin ithattul ana ikken keꞌra kwiꞌrekathe itti, “Nokorronno eo noththok poul iakannoka woIouth ana nokorronno iꞌriko naꞌran wꞌrek woul woCcamirin. ");
INSERT INTO lmd_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Anaruk ngonoine ul woIccereil akka waik ere lungkat ilurttatheik. ");
INSERT INTO lmd_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ana amma anneo annerene ul lon elli itti, ‘Ngili ngorothiꞌrot ngakko napuththut.’ ");
INSERT INTO lmd_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Nittiet ul iongo ana urokie ul illet ana ittiet ul ionat ïnyï noka ana okïcce uꞌrupa iokithak nnoul. Onon thoccot puꞌran pothittiet ul nuthuk ana nthittiet kin nuthuk. ");
INSERT INTO lmd_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Nokorronno oneko thaap ana manna mallong imallio ana manna akucci woththeik ikaꞌruk amma anneo. ");
INSERT INTO lmd_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Nokorronno oneko aꞌruk wokurtti nokurtti kon ana manna kret arttot ana wok ana urrong, akka pul ipareko ponu itti pacco aꞌrupu ia kwongothe. ");
INSERT INTO lmd_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ana nokaꞌran na anon thiꞌrikot nokwantot pul ipoporot annikkoik noppan thanung puccuk annoththekat nokaꞌran ken. ");
INSERT INTO lmd_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ana amma anniꞌriko noppan topul pꞌrek, nomicco ul noppan ten. ");
INSERT INTO lmd_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ana amma ul woruan wikkiet non cik, athomicco thon oka nakin, ana amma ul wonoppan ten wakinnikkienon cik athomicco thon opakkinthet non. ");
INSERT INTO lmd_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Amma pul pella ipikkienon cik ana occïkot lon lon, nokkwe kuꞌrupang noracok amma annoththe nokaꞌran ana nokaman ken, annokene itti onon thꞌrat kin. ");
INSERT INTO lmd_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Mpiꞌret non lon ilaik ïcat itti, thakkmako thopothok poCcothum ana poKamura thaka thopappat nocaꞌri cothakkmako nothakkmako thopothok ipꞌrat ikkienon cik.” ");
INSERT INTO lmd_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Nantoccïkot, mpaik pathïot non ere lungkat ithoꞌrkït thomipa. Ittina noꞌrumoik ana oka thella lon ilokithak. ");
INSERT INTO lmd_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Noꞌrumoik noul, okin thikket non nili ikkun ana onekot non imakkma ana okkwet non tokït koul woIouth nomuththun maꞌrama men. ");
INSERT INTO lmd_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ana nti ilon lin onon thanekittat tokït konili inarran ana inïttïnïttïk annokane nili ana ul iakannoka woIouth lon ilimmakot ngkït. ");
INSERT INTO lmd_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Anaruk amma okin occiccokot non, nokorronno ipo nꞌre itti onon thathiꞌre ngimpen ana manna itti onon thiꞌre lon len tat. Caꞌri cen onon thethettat lon ilanon iꞌre, ");
INSERT INTO lmd_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","akka onon akkakannoka thaik there, anaruk Kanang koththe akkaik kere nti ianon. ");
INSERT INTO lmd_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ukul wakero opang akwokkuttat ana oththan pokkul okero ukul wung akkuttat. Nyukul nyaprttakot iaththangon akin okorronnokin akin ongutta. ");
INSERT INTO lmd_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ul appik wꞌranon nti ilon lin, anaruk okkwi ipoccokothe cïkït ilon puccuk mono alocothakat kwaꞌrettat. ");
INSERT INTO lmd_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Amma okin thoccokiethenon thiak nokaꞌran kꞌrek, nollot nokaꞌran kꞌrek. Mpiꞌret non lon ïcat itti ukul wopul iponyi wakkarttako anon tharthuk omartto ngre naꞌran ncik wonoththok poIccereil. ");
INSERT INTO lmd_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Pul ipangkenetta pakannoka prïk nakkwi ipangkenek ana pul ipareko pakannoka prïk nakkwi iporekierok. ");
INSERT INTO lmd_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Lekko itti pul ipangkenetta paka karkko pul ipangkenek ana okkwi ipareko oka karkko okkwi iporekierok. Ana amma pul iprïk poruan pakkarakot itti Pelecepul ilonu ili wouꞌrupa iokithak, ul iakin thaik tuan wakkarako taththa?” ");
INSERT INTO lmd_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Nokorronno ipo nꞌre nen. Lon appik ilocukkwakot nan linako nan ana ilamuꞌruttakot littako ncik. ");
INSERT INTO lmd_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Lon ila anerenthet non iꞌrïmak nere attattar ana ilerettanthet non thounu nokkwinthet kuri noꞌret. ");
INSERT INTO lmd_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Nokorronno ipo nꞌre nokkwion ithakkwot ka, anaruk okin thakannokkwot utha. Anaruk nipo nꞌre nokkwi ipakkwot utha ana ka ciththothïrïn. ");
INSERT INTO lmd_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Nyaꞌrkang nyeꞌra nyaketta ngkakucci kulukku anaruk ngella ngulukku ngapot cik nocapu aththe pon porothiꞌrot pella kït ken. ");
INSERT INTO lmd_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ana manna wan won wonoꞌra wongantettat appik. ");
INSERT INTO lmd_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ittina nokorronno ipo nꞌre akka onon akkoporot cannan nonyaꞌrkang nyoppot. ");
INSERT INTO lmd_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Okkwi ipiꞌre tokït koul itti kwinan, mpiꞌret tokït kongappa ipaik tothiꞌrot itti mpinak. ");
INSERT INTO lmd_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ana okkwi ipoꞌruminthin kït tokït koul, mpaꞌruminthok kït cakuruk tokït kongappa ipaik tothiꞌrot. ");
INSERT INTO lmd_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Nokorronno ome itti mpaat itti anona thikkoik thoporot nocapu. Mpakannanthan itti mpana thikkoik thoporot nocapu anaruk thothatto. ");
INSERT INTO lmd_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Mpaat itti anathopetto ‘ikkul okin oththan ana ikkul iopari okin onnan ana ikkul iopari okin opïthe ipopari. ");
INSERT INTO lmd_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ana ul woruan thanung waka thoꞌrak thung.’ ");
INSERT INTO lmd_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Okkwi ipongothe oththan naun cannan ana manna onnan kwakannekko nan itti kwaka pin, ana okkwi ipongothe ukul wung iocura ana manna iopari naun cannan kwakannoka pin. ");
INSERT INTO lmd_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Okkwi ipakannangkot itti kwaccokot thiak ana io nti ilon lin kwakannekko nan itti kwaka pul pin. ");
INSERT INTO lmd_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Okkwi ipoꞌrumot nothikkoik thung kuret cik ana okkwi ipurethe thikkoik thung cik nti ilon lin caꞌrumakinok nan. ");
INSERT INTO lmd_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Okkwi ipikkiet non cik kwikkierin cik ana okkwi ipikkierin cik kwikkie okkwi ipothïothin cik. ");
INSERT INTO lmd_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Okkwi ipikkiet pul pothernte lon loKapik cik akka pernte lon loKapik, kwakketta llon iloporot lopul pothernte lon loKapik, okkwi ipikkiet pul cik ipoporot akka poporot kwakketta llon iloporot lopul ipoporot. ");
INSERT INTO lmd_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ana okkwi ipethet okkwi ipotte keththeꞌret koiꞌri akka ook nti iul iammakothin mpiꞌret non itti thokketta thung thakannurat cik.” ");
INSERT INTO lmd_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Anakka oIeccuo pomarttot erene ul iammakothok iattul ana ikken keꞌra, kwoththekathe nokaꞌran ken akwothongkene ana ere lon loKapik naꞌran woCelïl. ");
INSERT INTO lmd_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Anakka oIuanna pomamuthie poccïkothe nti ikorrkkor lon ila aMiccie pokat akwokkot, kwothïathe ul iammakothok ");
INSERT INTO lmd_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","athipittothok itti, “Oung oMiccie ipa oIuanna piꞌret ngngin itti kwaik panthani ana manna itti onïn thaꞌrïkot opilin pꞌrek?” ");
INSERT INTO lmd_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","OIeccuo pothïatherit itti, “Ngonopakkot annothiꞌret oIuanna lon ilanon thimmat ana ilanon thoccïkothe. ");
INSERT INTO lmd_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Okin ithiꞌrimathe thimmat cik, okin ithaimico thaik thanyaro, okin ithonat ïnyï noka thothakkat thoporot, okin ithokat thanuril thaik thaccïkot cik, okin ithillet thurokiettat, ana lon iloporot loIeccuo lerettanet ul iella aꞌrupu cik. ");
INSERT INTO lmd_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Thethïeko thaka noul iakannopaꞌrine lon lin cik.” ");
INSERT INTO lmd_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Anakka ul woIuanna pomamuthie iammakothok wokat cik aeo, oIeccuo pikkatheik akwerene ul lon loIuanna akwiꞌre itti, “Kathakka onon thoinet oIuanna ithampang ithonthomara, ngintha akka onon thoinet itti onon thathokatha? Pul ipaprtto lon cik ere taco torithampang ithonthomat irukwit tukwit ira kanang kaik kauꞌrei? ");
INSERT INTO lmd_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ngintha akka onon thoinet itti onon thathokatha? Pul pakot eret wopeththerei? Okorronno oka menik, okkwion ithako eret wopeththere thaik tuan tonili. ");
INSERT INTO lmd_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ittina ngintha akka onon thoinet itti nthathokatha? Pul pothernte lon loKapiki? Mpiꞌret non itti ïï onon thimmat pul pothernte lon loKapik anaruk mpiꞌret non onon thimmat lon lrïk nopul ipernte lon loKapik. ");
INSERT INTO lmd_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Akka elli lokurrakot iatham leret oIuanna itti, ‘Mpathïot pul pothothïlettat pin tokït kang, okkwi ipathokuccenthung kathar cik.’ ");
INSERT INTO lmd_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Mpiꞌret non lon ilaik ïcat itti, nti iul enni appik iokwontat nti iul iari, pul pella kirrkkir prïk naIuanna pomamuthie anaruk okkwi ipellakot lon len ingili ngorothiꞌrot prïk naak. ");
INSERT INTO lmd_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Nci nomaꞌri ima aIuanna pomamuthie pokat akwernte lon loKapik manna inenni ngili ngorothiꞌrot ngokat akkiettat thiak ana ul wokat annekke itti waneko ngili ngorothiꞌrot mpuꞌran. ");
INSERT INTO lmd_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Akka ul wothernte lon loKapik appik ana lon lothonceꞌret lon cik loMucca lerntethe lon longili ngorothiꞌrot mono aIuanna akkakat. ");
INSERT INTO lmd_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ana amma onon akkangothe itti onon thangkot lon len, oIuanna pomamuthie ook oIlia iperettathe itti kwaik panthan. ");
INSERT INTO lmd_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Okkwi iponu unu itti kwaccïkot, akwoccïkot. ");
INSERT INTO lmd_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Mpungkie ul enni ngngintha? Okin thikkoik ere nyukul nyaik nyikkoik keccuk anyakkakkararo, ");
INSERT INTO lmd_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Onïn thongwinet non unye woremekkin ana onon thꞌrat ukko, onïn theet ngeme ana onon thꞌrat oo.’ ");
INSERT INTO lmd_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ana oIuanna paat akwokorronno oꞌrkoik ana ïkko ngapak ana okin thiꞌret itti, ‘Kwonu uꞌrupa iokithak.’ ");
INSERT INTO lmd_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Oun ukul wopul iponyi mpaat anoꞌrkoik ana anïkko ngapak ana okin thiꞌret itti, ‘Nantokatha pul empi akka ponu kïnyït kothuꞌrit ana pongothe ngapak ana opuruko poul iaꞌrntinthet nili akucci noul ana opuruko poul wolon ilokithak.’ Anaruk thinaik nti ica thinako ngngre.” ");
INSERT INTO lmd_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","AIeccuo ikkat cik akwothirriet ul cik naꞌran na kwokkothe lon ilommaththik loppot akka okin thakannopaꞌrine lon cik ilakin thokat akin okkettet ilokithak. ");
INSERT INTO lmd_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Akwiꞌrekat itti, “Angkre, ul woKuruccin ana ul woPeththcceitha akka onon thaccokot thiak amma lon ilommaththik ilokkattathe ianon lalokkattathe nokaꞌran koCcur ana koCcithon, ul wonaꞌran wen waapaꞌrinet lon cik ilokithak akkomaꞌrot okin thako aꞌrupu iakene itti okin thaik ithmeru ana ipot mucuk ima. ");
INSERT INTO lmd_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Anaruk mpiꞌret non itti Kapik kathipo thiak thoul wonokaꞌran koCcur ana koCcithon nocaꞌri cothakkmako nanon. ");
INSERT INTO lmd_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ana onon, ul wonokaꞌran koKapprnaum, onon thame itti onon thanekittat tothiꞌrori? Okorronno oka menik, onon tharpo thothïrïn. Amma lon ilommaththik ilokkattathe ianon lokat lokkattathe nokaꞌran koCcothum, laaꞌrungkotheik manna nocaꞌri enci. ");
INSERT INTO lmd_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Anaruk mpiꞌret non itti laka loporot cannan nokaꞌran koCcothum nanon nocaꞌri cothakkmako.” ");
INSERT INTO lmd_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Nocaꞌri cen aIeccuo iꞌrekat itti, “Mpapiranung noka, ngappa, Ili worothiꞌrot ana wonocapu, akka ngkwamuꞌruttothe ul inaik nti ima ana inaik kicce lon elli ana ngkwittinet ul iommaik. ");
INSERT INTO lmd_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ïcat, ngappa, elli akka ngkwongothe itti laka. ");
INSERT INTO lmd_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ongappa pin pethin aꞌrupu appik. Pul pella pina ukul, ongappa pulluk akkinak. Ana pul pella pina oththan ukul wuluk akkina oththan ana okkwion itha ukul wongothe itti kwakenekin oththan. ");
INSERT INTO lmd_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Nainin appik, onon itha lon lalkothe ana ithokinyat ana mpangokienon. ");
INSERT INTO lmd_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Noccïkothin annina lon naun, akka mpoporot ana mpoporot cïkït ana onon thangoko. ");
INSERT INTO lmd_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Akka thuppi thin thopappat ana kathar kin koporot.” ");
INSERT INTO lmd_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ana caꞌri cen aIeccuo oppat ikkwon komïl nocaꞌri caCcepith. Aul iammakothok wikkatheik acottot mïl nti ikkwon aꞌrko akka okin thokat thiamat. ");
INSERT INTO lmd_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Anakka ul woPriccin wimmat lon elli, amekathok itti, “Antokatha, ul iammakothung waik wakkot lon ilonu itti lakannokkattat nocaꞌri caCcepith.” ");
INSERT INTO lmd_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","AIeccuo othïat tit itti, “Onon thakannakkakkaro lon iatham ila aThauth ana ul wung thokkothe akka okin thokat thiamari? ");
INSERT INTO lmd_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Kwiꞌrikot noppan toKapik, okin oul wung akin oꞌrkkat arrakith iothun iettathe Kapik iokat itti ul wulluk wonoppan toKapik akkaꞌrko. ");
INSERT INTO lmd_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Onon thannakkakkaro lon lothonceꞌret lon cik iatham loMucca iliꞌre itti ul wonoppan toKapik wareko nocaꞌri caCcepith ana lon len lakorronnoka lamolokoi? ");
INSERT INTO lmd_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Mpiꞌret non itti opilin paik cene prïk nnonoppan toKapik. ");
INSERT INTO lmd_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Atham wiꞌre itti, ‘Mpongothe itti onon thana thiak, mpakannangkot aꞌrupu wothokiot ngüccük cik won.’ Ana amma onon akkokat thinat lon len, onon thakannakkmat ul iammakothin iella lon cik ila moloko. ");
INSERT INTO lmd_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Akka ukul wopul iponyi Ili wocaꞌri caCcepith.” ");
INSERT INTO lmd_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","AIeccuo oththekat nokaꞌran ken akwoingkat nocuththun caꞌrama cen, ");
INSERT INTO lmd_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ana pul pokat cik than ponat ukun waiꞌrilla. Ul woPriccin wikkatheik akin okwancot lon ilakin orukwet oIeccuo ngngin, akin ipittathok itti, “Locoꞌrotheik itti thittiettat thaka nocaꞌri caCcepithi?” ");
INSERT INTO lmd_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","AIeccuo iꞌrekat kin itti, “Amma opilin nti ianon ponu thungkat ana thapothe irok nocaꞌri caCcepith kwakanneo itti kwaccokot akwonthot thapat nti iroki? ");
INSERT INTO lmd_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Pul iponyi akkoporot cannan nothungkat. Ittina locoꞌrotheik itti lon iloporot lakkattat nocaꞌri caCcepith.” ");
INSERT INTO lmd_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ittina kwiꞌrekathe pul pen itti, “Othie ukun ntit.” Akwothiekat ukun ntit athakkakat woporot ammakka aꞌrek iokat woporot. ");
INSERT INTO lmd_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Anaruk ul woPriccin woingkathe athikkat cik nocuththun akin ïꞌrïkat lon itti okin thakkwot oIeccuo tat. ");
INSERT INTO lmd_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Anakka oIeccuo pinat nolon len, akwoththekat nokaꞌran ken. Ul womakathok woppot, ana kwittiekathekin appik ithongat, ");
INSERT INTO lmd_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","akwiꞌrekat kin lon lonthoththomat itti okin thakannongano itti ook okkwen. ");
INSERT INTO lmd_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Elli lokkattathe othakka itti alomartto lon ila pul pothernte lon loKapik oIccaia piꞌret itti, ");
INSERT INTO lmd_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Pul iparekinin empi ipa mpakkarot, okkwi ipa mpongothe, ana ipa mpopirat noka nan. Mpethok Kanang kin, ana kwerene ul appik lon ilocoꞌrotheik. ");
INSERT INTO lmd_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Kwakannokkot poꞌre ikathar ana aꞌretto noul wꞌrek. Kwannere mpoꞌre cittan ikathar. ");
INSERT INTO lmd_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Kwannie pul ka kongo ipella puꞌran cik ere kupir ikapot nocu, ana kwakannie ul ka kongo ella puꞌran ere thik amma athio ithacco ncuꞌru, puccuk alon lung ilocoꞌrotheik alkat ilakannocoꞌrot cik. ");
INSERT INTO lmd_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ngkꞌran kung ul appik wana thoꞌrïkot cik iaak.” ");
INSERT INTO lmd_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ittina akin onakanthok pul ponat uꞌrupa iokithak ana pokat piꞌrimathe cakuruk ana pommat ere ana oIeccuo pittiekathok, othakka itti apere ana immaik. ");
INSERT INTO lmd_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ul woprttakatherit appik ana wiꞌrekathe itti, “Ukul enni waka woThauthi?” ");
INSERT INTO lmd_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Anaruk akka ul woPriccin woccïkothe lon elli, aiꞌrekat itti, “Kwakïcce uꞌrupa iokithak akka Pelecepul ili wouꞌrupa iokithak wethok puꞌran.” ");
INSERT INTO lmd_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","OIeccuo pinakathe lon ilokat ima men ana kwiꞌrekathekin itti, “Amma ngili ngillillakot tit kurekkurek ngintat cik, ana amma kaꞌran ana manna ul woruan willillakot tit kurekkurek, wakannoꞌrungkot cik tothun. ");
INSERT INTO lmd_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Amma pul pothopulut pakïcce pul pothopulut, poprttakothe ika kung. Ittina ngili ngung ngaꞌrungkot cik taththa? ");
INSERT INTO lmd_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ana amma mpakïcce uꞌrupa iokithak mpuꞌran poPelecepul, ul won wakïcce uꞌrupa iokithak mpuꞌran poththa? Ittina ul iammakot non waka ul iakkma non. ");
INSERT INTO lmd_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Anaruk amma mpakïcce uꞌrupa iokithak mpuꞌran poKanang koKapik, ittina ngili ngoKapik ngaik ianon. ");
INSERT INTO lmd_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Pul pella piꞌriko noppan topul iponthomat mparran akwonekothok aꞌrupu pung, kwonu itti kwaccokot pul pen kappak akwïꞌrïkïkkok kicce akwantiꞌriko noppan akwoneko aꞌrupu wung. ");
INSERT INTO lmd_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Okkwi ipakannoka ïnaththeꞌra kwakannongkat lon lin ana okkwi ipakinnittarothin ire kwaik pakïtto ngre ngin. ");
INSERT INTO lmd_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ana ittina mpiꞌret non itti lon ilokithak loul ana thocungkwo ul laccïkakot ncik appik anaruk pul ipacungkwo Kanang koKapik pakannoccïkakinthet lon. ");
INSERT INTO lmd_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Okkwi ipere lon lokithak nokkul wopul iponyi, kwikko paccïkakinthet lon ilokithak, anaruk okkwi ipere lon lokithak noKanang ikupupure, kwakorronno occïkakinthet lon ilokithak, noluput elli ana manna noluput ilanthan. ");
INSERT INTO lmd_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Amma pira poporot ana pakwono nyukul nyoporot, ana amma pira pokithak ana pakwono nyukul nyokithak. Pira pinako nynyukul nyen inya pokwonot. ");
INSERT INTO lmd_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ul ionu karra iurttet pangken cik, onon there lon loporot taththa anon thokithak? Akka thon there lon nnolon iloppathe nocïkït. ");
INSERT INTO lmd_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Pul ipoporot pere lon iloporot nolon iloporot ilaꞌrntakothe iaak, ana pul ipokithak pere lon ilokithak nolon ilokithak ilaꞌrntakothe iaak. ");
INSERT INTO lmd_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Anaruk mpiꞌret non itti nocaꞌri cothakkmako ul wakkmakot nolon len ilella lon cik ilakin theret. ");
INSERT INTO lmd_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Akka llon lang ilere ngkwakorronno akkmako ana llon lang ngkwakkmako.” ");
INSERT INTO lmd_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ittina aul wꞌrek woPriccin ana ul iangkene lon lothonceꞌret lon cik iꞌrekat oIeccuo itti, “Pul ipangkene, onïn thongothe itti ngkwakkinthet nïn lon ilommaththik anïn ina itti ngkwaat nnoKapik.” ");
INSERT INTO lmd_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Akwothïat tit itti, “Onon ul iannoccokot lon loKapik ana nthaul iokithak thipitto lon ilommaththik, lon ilommaththik lella ilakkattanthet non anaruk lulluk ilokkattanthet pul pothernte lon loKapik oIunan akkettat non. ");
INSERT INTO lmd_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ana ammakka oIunan pikkot cik icarak copape iprïk mïngkï mꞌrapuruk ana ngkoꞌra ngꞌrapuruk, ittina ukul wopul iponyi wikkoik ippu mïngkï mꞌrapuruk ana ngkoꞌra ngꞌrapuruk. ");
INSERT INTO lmd_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nocaꞌri ica Kapik athakkma nan, ul wonokaꞌran koNinua waꞌretto ianon akka okin thopaꞌrinet lon cik ilokithak nocaꞌri ica aIunan perenet kin lon loKapik, ana mpiꞌret non itti opilin paik cene prïk naIunan. ");
INSERT INTO lmd_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Nocaꞌri cothakkmako Ili iopari wonoththok poCipa waꞌretto ianon ana wakkma non akka waat nciththan othakka itti athoccïkot lon lothinaik nti ica loCiliman ana inenni opilin paik cene prïk naCiliman. ");
INSERT INTO lmd_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Amma uꞌrupa iokithak woppothe thapat nti ipul, wanyarot cik ithampang ithonthomat akwantot kaꞌran na ikkoik ana wakinniot. ");
INSERT INTO lmd_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ana wiꞌre itti, ‘Mpapakkot ikaman ika mpoththet nan.’ Ana amma waat, wathiot man mella pul tit ana mollakot kicce ana mothettakotheik kicce. ");
INSERT INTO lmd_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Waeo ana wathona uꞌrupa wꞌrek weꞌreꞌrapuruk iokithak cannan aiꞌrikat ipul aikkat cik iaak. Ana thikkoik thopul emprïk thaka thokithak cannan nocaꞌri conomun. Elli akkaka noul enni iokithak.” ");
INSERT INTO lmd_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Anakka oIeccuo pokat cik akwerene ul, onnan ana opangon thocoꞌrathe thapat akin thongothe itti okin therenok. ");
INSERT INTO lmd_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Apilin omekat oIeccuo itti, “Onne ana opangkangon thaik thacoꞌro thapat ana okin thongothe itti okin therenung.” ");
INSERT INTO lmd_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Kwothïanthok tit itti, “Oiaia oththa, ana opangkingon oththan?” ");
INSERT INTO lmd_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Akwothiekat caun noul iammakothok akwiꞌrekat itti, “Oiaia empi ana opangkingon enthi. ");
INSERT INTO lmd_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Akka okkwi ipakkot lon ila ongappa pongothe tothiꞌrot ook opangkin ipopari ana ipocura ana oiaia.” ");
INSERT INTO lmd_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Nocaꞌri cen oIeccuo poingkathe ntuan akwothikkat cik nokuthut korue irapangka toCelïl akwongkene. ");
INSERT INTO lmd_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Acungkut coul oppakat iccik kung akwarrat ikuppuꞌrung konoiꞌri akwikkat cik, ana ul wokat cik acoꞌro nokuthut korue irapangka appik. ");
INSERT INTO lmd_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ana kwerekanthet kin lon loppot nthokkwie lon kuru ncik akwiꞌret kin itti, “Pul pokkwon peot itti pathee mïl. ");
INSERT INTO lmd_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Anakka kwokat cik akwee mïl, amꞌrek apukkat ikathar auꞌrupe akkakat acumat ncik appik. ");
INSERT INTO lmd_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Amꞌrek apukkat nocapu iconat kꞌrimi ikonat nünthü notte noꞌra wen ana mummathe cokoccokot akka mokat noꞌrpu. ");
INSERT INTO lmd_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Anaruk akka cïngkï cuat, cokꞌrekathe ana millekathe akka mellat laka ippu. ");
INSERT INTO lmd_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Amïl mꞌrek apukkat ithoꞌrkït tholï ana lï locokkakathe alonentekat cik amillekat. ");
INSERT INTO lmd_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Anaruk amꞌrek apukkat nocapu icoporot, na mokwonathe mïl mipiet kicce, amꞌrek ipiekat kït ken arrial ukuluk (100) ana amꞌrek arrial wꞌrapuruk (60) ana amꞌrek arrial ana alkaire (30) nomïl imokat merat. ");
INSERT INTO lmd_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Okkwi iponu unu itti kwaccïkot akwoccïkot.” ");
INSERT INTO lmd_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ul wung iammakothok wakkakanthok ana wipittathok itti, “Ngkwerene ul nthokkwie lon kuru ncik akaintha?” ");
INSERT INTO lmd_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ana kwothïanthet kin tit itti, “Lon lothina ngili ngorothiꞌrot ilamuꞌruttakot ncik lettathenon ana lakannettat kin. ");
INSERT INTO lmd_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ana okkwion ithaccïkot lon lin, okin tharttakinthet nan, okin thina lon loppot. Anaruk okkwion ithaik thakannoccïkot lon lin, thanekittat thinaik ithakin thonu thotte. ");
INSERT INTO lmd_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ilen akka anerenekin nthokkwie lon kuru ncik amma anerenekin akka okin thakathacceik akin ikkoik ere okin thakinnimmaik ana akin occïkot lon akin ikkoik ere okin thakannoccïkot lon lꞌrek ana ina lon len. ");
INSERT INTO lmd_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Lon ila pul pothernte lon loKapik ipoccot kꞌran itti oIccaia perethe ul ngngin maꞌrot lokakathe nakin ïcat ila kwiꞌret itti, ‘Onon thaccïkot cik anaruk onon thakinninaik, onon thakathacceik anaruk onon thakinnimmaik. ");
INSERT INTO lmd_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Akka mïkït moul enni monthomat ana unu wen wakannoccïkot cik ana okin thoꞌrumothe kït. Akka amma okonnoka ittina okin thaimmat cik ngkït ken ana occïkot cik nunu wen ana inaik nti ima men ana oprttakoik ana mpathikkiekin thoporot.’ ");
INSERT INTO lmd_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Anaruk kït kon kethïettat akka kakathacce cik, ana unu won wethïettat akka waccïkot cik. ");
INSERT INTO lmd_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Akka mpiꞌret non lon ilaik ïcat itti, ul woppot wothernte lon loKapik womaꞌrot ana ul ioporot tokït koKapik wokat akwantot kathar ikakin imma lon ngngin ila non thaik thakathacce inenni anaruk okin thakinniot, ana othakka itti akin occïkot lon ilanon thaik thaccïkot inenni, anaruk okin thakannoccïkot.” ");
INSERT INTO lmd_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ana kwikkatheik akwere itti, “Noccïkot lon lothokkwie lon kuru ncik lopul ipet mïl lonu lon len itti tat. ");
INSERT INTO lmd_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Amma pul pꞌrek poccïkothe lon longili ngorothiꞌrot ana kwakinnina kicce, pul pothopulut panthan ana panekothok lon ilokat liꞌrikot nocïkït cung. Lon elli locïl icapothe ikathar. ");
INSERT INTO lmd_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Lon locïl icapothe nokꞌrimi lonu itti pul ipaccïkot lon loKapik accokkot akwopirakat noka nocaꞌri cen. ");
INSERT INTO lmd_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Anaruk akka lon len lakinniꞌriko ci nocïkït, lintat cik nomaꞌri motte. Amma lon lꞌrek lainok ilokithak ana thokkiettat thiak nti ithoccïkot lon loKapik, kwapaꞌrine lon len cik accokkot. ");
INSERT INTO lmd_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Lon locïl icapothe ithoꞌrkït tholï lungkwiettat mpul ipaccïkot lon anaruk thirro cïkït nti icarak tholon lothikkoik ana thammikkot thothaꞌrathan thakorronno lon lung iliꞌrikot nocïkït alella ngre cik. ");
INSERT INTO lmd_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Anaruk lon locïl icapothe nocapu icoporot lungkwiettat mpul ipaccïkot lon ana ina kicce. Kwarttot nolon ila kwoccïkothe arrial ukuluk (100) ana arrial wꞌrapuruk (60) ana arrial ana alkaire (30).” ");
INSERT INTO lmd_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","OIeccuo pappererekanthet kin lon lothokkwie lon kuru ncik lꞌrek akwiꞌrekat kin itti, “Ngili ngorothiꞌrot ngungkot pul ipeet mïl imoporot ikkwon kung. ");
INSERT INTO lmd_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Anaruk akka ul wonokworok wokat inthe ngkoꞌra, apul ipꞌrat pul pokkwon akkakat apeekanthok takkaa ikkwon na mïl meerat apoingkat. ");
INSERT INTO lmd_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Anakka mïl mummothe amoingkat ikwonco amokkwat ntit, arakkaa ummat ncik arokkwat ntit cakuruk. ");
INSERT INTO lmd_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Aul iareko ikkwon akkakanthet pul pokkwon aiꞌrekathok itti, ‘Pït pïn, ikkre ngkwakannee mïl imoporot ikkwon kang akka takkaa akkummothe ikkwon.’ ");
INSERT INTO lmd_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Akwothïat tit itti, ‘Pul ipꞌrat lon lin akkokkinthin lon len.’ Aul iareko appipittathok itti, ‘Ngkwongothe itti onïn thaeo anïn othïthot takkaa cik appiki?’ ");
INSERT INTO lmd_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Akwothïat tit itti, ‘Nokorronno akka amma anon ïtho takkaa ana onon thïthot mïl cik ngngin. ");
INSERT INTO lmd_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Nokorronno arocokka mmïl appik acaꞌri cothokio akkakat. Nocaꞌri cen mpiꞌret ul iakio itti, cittokït nokkuttot takkaa annïꞌrïkïkko muꞌrukul muꞌrukul arothokꞌretta, ana annaꞌrntot mïl annona itharak thin thomïl.’” ");
INSERT INTO lmd_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Akwapperekanthet kin lon lothokkwie lon kuru ncik lꞌrek itti, “Ngili ngorothiꞌrot ngungkot core icoththe cannan iceera nocapu. ");
INSERT INTO lmd_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Antoka manna itti core icoththe nonyukul nyokira appik, anaruk amma wummothe wathakka pira pïttïk, ana uꞌrupe manna wanthan athuno nune nan ana ikkoik nouꞌri wen.” ");
INSERT INTO lmd_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ana kwappiꞌrekat kin lon lothokkwie lon kuru ncik lꞌrek icci itti, “Ngili ngorothiꞌrot ngungkot müꞌrükül motteik ima pul ipopari porrethe imꞌre moppot amma akwokkot arrakith anakka mikkot cik aminyakat amothakkakat moppot cannan.” ");
INSERT INTO lmd_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","OIeccuo perenet cungkut coul lon elli appik nthokkwie lon kuru ncik, kwakanniꞌret kin lon lꞌrek ella thokkwie lon kuru ncik. ");
INSERT INTO lmd_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ittina lon lokakathe ïcat ila pul pothernte lon loKapik piꞌret itti, “Mpere lon lin nthokkwie lon kuru ncik, mpakene aꞌrupu iorukot ncik nciki ammakka capu cokuꞌrettat ncik.” ");
INSERT INTO lmd_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","OIeccuo poththekathe noul ana kwoingkathe tuan. Ul iammakothok wakkakanthok aiꞌrekathok itti, “Okenenïn lon lothokkwie lon kuru ncik lorakkaa ikkwon.” ");
INSERT INTO lmd_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Kwothïatherit itti, “Okkwi ipeet mïl imoporot ook ukul wopul iponyi. ");
INSERT INTO lmd_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Kopon konu lon itti capu ncik appik ana lon itti mïl imoporot lonu itti nyukul nyongili ngorothiꞌrot. Takkaa tonu lon itti nyukul nyopul pothopulut, ");
INSERT INTO lmd_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ana pul ipꞌrat lon lopul pokkwon, ook pul pothopulut ana ook ipeet takkaa. Thokio mïl thonu itti caꞌri ica luput ocothakot nan, ana lon itti ul iathokio lonu itti uꞌrupa wothothïlettat woKapik. ");
INSERT INTO lmd_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ana thïtho takkaa ana okꞌre, laka ittina amma aKapik athakkma ul amma luput locothakothe. ");
INSERT INTO lmd_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ukul wopul iponyi wathïot uꞌrupa wung wothothïlettat, athocumo okkwion ithakkiet ul lon ilokithak ana okkwion ithakkot lon ilokithak appik nti ingili ngorothiꞌrot. ");
INSERT INTO lmd_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Okin tharret kin icꞌrot ithik thothothïrïn, nakin oot ana okꞌrellot kïnyït thocipit ngngeme. ");
INSERT INTO lmd_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ittina ul ioporot tokït koKapik wallio ere cothot ingili ngoththan pen. Okkwi iponu unu itti kwaccïkot, akwoccïkot.” ");
INSERT INTO lmd_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Ngili ngorothiꞌrot ngungkot thaꞌrathan thamuꞌruttakot ikkwon. Anakka pul ipareko ikkwon kopul pꞌrek piothe thaꞌrthan then ikkwon apappamuꞌruttat. Ana akka pokat popirat noka paththokettekat aꞌrupu appik akwothokero kopon ken. ");
INSERT INTO lmd_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Attang, ngili ngorothiꞌrot ngungkot pul ipakette aꞌrupu paik pakwantot muccu moriꞌri imallio. ");
INSERT INTO lmd_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Amma kwiothe culukku iconu cekerek crïk kwaeo ana kwothokette aꞌrupu appik ia kwonu akwathokero cuccu cen coriꞌri icallio.” ");
INSERT INTO lmd_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Ana cakuruk, ngili ngorothiꞌrot ngungkot loꞌrak lape ilorrettathe irue irapangka aiꞌriththa ape ncik kurekkurek appik. ");
INSERT INTO lmd_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Anakka ape wiꞌriththat woppot, aul woloꞌrak othat loꞌrak nocarkan. Akin ikkat cik akin ocumo ape ioporot akin ipot inyalünthüng akin orre iokithak. ");
INSERT INTO lmd_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Laka ittina nocaꞌri ica luput ocothakot nan nocapu ncik appik. Uꞌrupa wothothïlettat woKapik wanthan ana wathopetto iul iokithak nti iul ioporot tokït koKapik ");
INSERT INTO lmd_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","arret icꞌrot cothik thothothïrïn na akin oot ana okꞌrellot kïnyït thocipit.” ");
INSERT INTO lmd_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","AIeccuo ipittat kin itti, “Onon thina lon elli appiki?” Akin othïat tit itti, “Ïï.” ");
INSERT INTO lmd_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Kwiꞌrekathekin itti, “Pul ipangkene lon lothonceꞌret lon cik ipongkenettat lon longili ngorothiꞌrot paik ere pul pokaman ipana thaꞌrathan thung thapat ithie ana ithïpe ithokat thaꞌrantakothe athothongkenetta opilingon.” ");
INSERT INTO lmd_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Anakka oIeccuo pomarttot lon lothokkwie lon kuru ncik len, kwoththekathe nokaꞌran ken. ");
INSERT INTO lmd_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Anakka kwokat cik akweo nokaꞌran koNaccir na kupokkothe, kwikkatheik akwappongkene ul nocuththun caꞌrama cen, ana okin thoprttakatherit. Akin ipittat itti, “Pul empi ponat thinaik nti ica enthi ngkartha? Ana puꞌran pothokkot lon ilommaththik elli ngkeren? ");
INSERT INTO lmd_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Okorronno oka ukul enni wopul ipaccatha oꞌreni? Ana okorronno oka onnan iponu kꞌran itti oMeriomi, ana okorronno oka opangon ithonu ꞌran itti oIakup ana oIuccip ana oCcamaan ana oIouthai? ");
INSERT INTO lmd_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Okorronno oka opangon ithari enthi cene uraththungoni? Pul empi piothe lon elli kartha appik?” ");
INSERT INTO lmd_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ittina ul wꞌrakathe lon lung ila kwokat cik akwokkot. Anaruk oIeccuo piꞌrekathekin itti, “Pul pothernte lon loKapik paul wothanung ana wonoththok pung akkakorronno othiane cik tulluk.” ");
INSERT INTO lmd_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ana kwakannokkat lon ilommaththik loppot nokaꞌran ken akka okin thellat thoccokot lon nomïkït. ");
INSERT INTO lmd_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Nocaꞌri cen aIruthuc ili wonoththok poCelïl occïkat lon ila loIeccuo pokat cik akwokkot, ");
INSERT INTO lmd_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","akwiꞌrekat ul wung iokat cïnang itti, “OIuanna pomamuthie empi ïcat purokot nti ithio. Ilen akka puꞌran polon ilommaththik paik parekine iaak.” ");
INSERT INTO lmd_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","OIruthuc pokat poccokothe oIuanna akwïꞌrïkïkkathok akwonekkekathok ikorrkkor nti ilon loIruthia ipokat pari popang oPilippic ipa aIruthuc pappipothok ");
INSERT INTO lmd_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","akka oIuanna perntenok itti, “Lakannoka locoꞌrotheik itti ngkwipot opangkang oPilippic pari oIruthia.” ");
INSERT INTO lmd_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","OIruthuc pokat pongothe itti kwakkwot oIuanna anaruk kwonat nꞌre noul akka okin thokat akin okatha oIuanna ammakka pul pothernte lon loKapik pen. ");
INSERT INTO lmd_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ana nokamuthe kocaꞌri cothokwonta coIruthuc, aukul woIruthia iopari ukkwanthet kin ana oIruthuc popirakathe noka cannan, ");
INSERT INTO lmd_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","akwonekkekanthet ukul lon cik tokït koul itti kwethet ukul papu ipa akwipitto. ");
INSERT INTO lmd_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ana ukul wiꞌrekathe oIruthuc itti, “Ethin ca coIuanna pomamuthie nocaththak inaina,” akka onnan pokat piꞌrethe itti wiꞌre ittina. ");
INSERT INTO lmd_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ili oIruthuc wokat wakannopira noka anaruk kwokat ponekkethe lon cik, ana ul wung woccïkothe. Ittina kwiꞌrekathe itti lakkattat ila ukul wipittot, ");
INSERT INTO lmd_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ana kwothïathe pul pothorro ana paththokiat oIuanna ca cik ikorrkkor. ");
INSERT INTO lmd_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ca coIuanna conakittakathe nocaththak ana cettakathe ukul iopari ana wonekanthet onnan. ");
INSERT INTO lmd_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ul woIuanna iammakothok wakkakathe ana wonekathe kumi koIuanna ana waththocïkkat. Ana okin thoingkathe ana okin thaththiꞌrekat oIeccuo. ");
INSERT INTO lmd_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Anakka oIeccuo poccïkothe lon loIuanna, kwarrathe ikuppuꞌrung konoiꞌri ana kwoingkathe nokaꞌran na ul wellat. Manakka ul woccïkothe itti oIeccuo peot, amakathok ntacok nnaꞌran appik. ");
INSERT INTO lmd_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Anakka oIeccuo porpotheik nocapu nti ikuppuꞌrung konoiꞌri akwimmakat cungkut coul woppot akwipat thiak then ana kwittiekathe okkwion ithokat thongo. ");
INSERT INTO lmd_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Anakka cipin cokat cik acapo, aul wung iammakothok akkakanthok ana wiꞌrekathok itti, “Kaꞌran engki kella ulrit ana ngïꞌrïmak ngaik ngaꞌroik. Omethe ul apettakot cik othakka itti akin eo icarak coman akin othokerine ka ken thuꞌrit akin oꞌrko.” ");
INSERT INTO lmd_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","AIeccuo othïat tit itti, “Okin thonu itti okin thakanneo. Nethet kin aꞌrupu wꞌrek akin oꞌrko.” ");
INSERT INTO lmd_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Aul iammakothok othïat tit itti, “Onïn thonu arrakith ukuluk ana ape weꞌra tulluk.” ");
INSERT INTO lmd_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","AIeccuo iꞌrekat itti, “Nonanin cene.” ");
INSERT INTO lmd_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Akwiꞌrekat ul itti wikkoik noraco. Akwonekat arrakith iukuluk ana ape ieꞌra akwokathakat tothiꞌrot, akwopirakanthet Kapik noka akwomithat iarrakith akwekat ul iammakothok ana ul iammakothok wikkekathe ul arrakith. ");
INSERT INTO lmd_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Okin thoꞌrkkathe appik akin oththakakat, aul iammakothok aꞌrntat nyalünthüng attul ana ikken keꞌra (12) nyothuꞌrit ithokwentakot nan. ");
INSERT INTO lmd_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ul iomura ioꞌrkot thuꞌrit wokat athar ukuluk (5,000) anaruk ul iari ana nyukul inyarran nyokat nyakannongantetta. ");
INSERT INTO lmd_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ittina aIeccuo arriekat ul iammakothok ikuppuꞌrung konoiꞌri akin eo tokït naak nokuthut korok kꞌrek akwiꞌrikot othïot ul ikathar. ");
INSERT INTO lmd_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Anakka kwothïothekin ikathar, kwokuꞌrathe pellek nocoꞌrong akwothaꞌra ngaꞌrama. Anakka cipin capot, kwokat cik than pellek, ");
INSERT INTO lmd_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ana kuppuꞌrung konoiꞌri ikonat ul iammakothok kokat cik ipanan porok irapangka, akothantittakot tit akka kanang kokat cik akokkurarot. ");
INSERT INTO lmd_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ana nothothuput thorrot, oIeccuo pakkakanthet ul iammakothok akkwaik akwonyaro noꞌra woiꞌri ngonorok irapangka. ");
INSERT INTO lmd_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Anakka ul iammakothok wimmarok akwonyaro noꞌra wongꞌri ngonorok irapangka, okin thipathe nꞌre. Akin iꞌrekat itti, “Ikkre purrut,” akin ikkat cik akin oo nnꞌre. ");
INSERT INTO lmd_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Anaruk oIeccuo piꞌrekathekin accokkot itti, “Nopoꞌrathan, oun oIeccuo nokorronno opelle.” ");
INSERT INTO lmd_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","APoththuruc iꞌrekathok itti, “Ili, amma oung, iꞌrethin anainung anonyaro noꞌra woiꞌri.” ");
INSERT INTO lmd_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","AIeccuo iꞌrekathok itti, “Aꞌrik.” Ittina oPoththuruc porpathe nti ikuppuꞌrung, akwonyarat noꞌra woiꞌri akwoingkanthet oIeccuo. ");
INSERT INTO lmd_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Anaruk akka kwimmat kanang, kwipathe nꞌre akwikkat cik akuo thoꞌronthong, akwekat ngeme cittan itti, “Ili, oꞌrethin.” ");
INSERT INTO lmd_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ana accokkot aIeccuo othiekathe ukun ana kwoccokathok akka kwokat cik akwïkïkko ngꞌri, akwiꞌrekathok itti, “Okkwi iponu thoccokot lon loKapik nocïkït thotte, ngintha akka ngkwonanet mïkït meꞌrarit?” ");
INSERT INTO lmd_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Anakka okin tharrothe ikuppuꞌrung, akanang ocoꞌrat. ");
INSERT INTO lmd_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ittina okkwion ithokat cik ikuppuꞌrung aꞌrakanthok ngaꞌrama, akin iꞌre itti, “Oung ukul woKapik ïcarïcat.” ");
INSERT INTO lmd_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Manakka okin tharrothe tok cik, okin thorpathe nocik coCeniccarth. ");
INSERT INTO lmd_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Anakka ul wonoththok pen winat oIeccuo, akin othïanthet ul thon naꞌran wen appik. Ul wonakanthok ul iongo appik ");
INSERT INTO lmd_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","akin ipittat oIeccuo itti kwakorronno ul iongo athnto toꞌron lokret kung, ana okkwion ithothntot kret kung thittakathe. ");
INSERT INTO lmd_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ittina aul wꞌrek woPriccin ana ul iangkene lon lothonceꞌret lon cik akkakanthet oIeccuo nokaꞌran koUruccelim aipittathok itti, ");
INSERT INTO lmd_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Ngintha akka ul iammakothung wꞌranet lon lothathuma thoul ittïttïk woul? Okin thakinnilakko nyaun akin antoꞌrkoik.” ");
INSERT INTO lmd_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","AIeccuo othïanthet kin tit itti, “Ana ngintha akka onon thꞌranet lon loKapik annoccokot lon lothathuma thon? ");
INSERT INTO lmd_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Akka Kapik kiꞌret itti, ‘Othianet oththe ana onne cik,’ ana ‘Okkwi ipattatta oththan ana manna onnan kwonu itti kwakkuttat.’ ");
INSERT INTO lmd_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Anaruk onon thangkene itti, amma pul ponu papꞌrek itti pittarot oththan ana manna onnan ngngin, akwomet kin itti, ‘Aꞌrupu enni wampaik pethet Kapik,’ ");
INSERT INTO lmd_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","kathar engki ikakin othiane oththan ana onnan cik ngngini? Onon thorakket lon loKapik othakka itti annomakot thongkene thothathuma thon. ");
INSERT INTO lmd_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Onon ithongothe itti nthinnikot lon, lon loIccaia pul pothernte lon loKapik laik ïcat ila kwerethenon ngngin itti, ");
INSERT INTO lmd_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Ul enni wathianin cik llon nuthuk, anaruk mïkït men maik ciththan naun. ");
INSERT INTO lmd_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Okin thaꞌranin ngaꞌrama ella mïkït nan, akka okin thangkene thongkene tholon loul ionyi.’” ");
INSERT INTO lmd_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","AIeccuo akkarat cungkut coul akwiꞌrekat kin itti, “Noccïkot anninakat lon len. ");
INSERT INTO lmd_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Aꞌrupu ia pul oꞌrko wakorronno ipie pul nguꞌru, anaruk lon ila pul ere, ilen akkathikkiek pokithak.” ");
INSERT INTO lmd_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ittina aul iammakothok akkakanthok aipittathok itti, “Ngkwina itti ul woPriccin wuat ka akka okin thoccïkothe lon elli?” ");
INSERT INTO lmd_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","AIeccuo othïat tit itti, “Aꞌrupu ia angappa porothiꞌrot pakannee wïthako nti impu llaka len. ");
INSERT INTO lmd_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Nokorronno kin, okin ul itte pangken ana okin thamma kathar. Amma pul ipiꞌrimathe paik pathutho pul ipiꞌrimathe okin aththuththeꞌra thapot ippu.” ");
INSERT INTO lmd_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","APoththuruc iꞌrekat itti, “Okenenïn lon lothokkwie lon kuru ncik.” ");
INSERT INTO lmd_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","AIeccuo ipittat kin itti, “Onon tharthuk thomma lon ila mpaik pereri? ");
INSERT INTO lmd_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nthomma itti aꞌrupu iartta wuo icarak ana nti icarak wakinyakoi? ");
INSERT INTO lmd_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Anaruk lon ila pul ere nti ithon lanthan nocïkït, ana ilen akkathikkiek pokithak. ");
INSERT INTO lmd_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Akka lon ammakka thokwarttikot cik ithokithak ana thokkwot pul ana aꞌro nul iari ittat ana aꞌro nul nuthuk ana thuꞌran ana ammikkot ana thocungkwo, lanthan nocïkït. ");
INSERT INTO lmd_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Lon elli akkathikkie pul pokithak anaruk thoꞌrkoik nynyaun nyongï thakorronno othikkie pul ponyï.” ");
INSERT INTO lmd_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","OIeccuo poththekathe nokaꞌran ken akwoingkat nocik iccik kokaꞌran koCcur ana koCcithon. ");
INSERT INTO lmd_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Apul pꞌrek ipopari ipokat cik than poul woKanaan akkakanthet oIeccuo apakkakkarok mpoꞌre cittan itti, “Ili, ukul woThauth, ipi thiak thin, ukul win iopari waik wiine uꞌrupa iokithak iaik iaak.” ");
INSERT INTO lmd_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","OIeccuo pakinniꞌrekathok lon lꞌrek. Aul iammakothok akkakanthok amekathok itti, “Okïcce pul ipopari empi akka paik pammakot ton apakkakkaro mpoꞌre cittan.” ");
INSERT INTO lmd_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","AIeccuo othïanthet kin tit itti, “Mpothïlanthet lungkat lulluk loul woIccereil ilurttatheik.” ");
INSERT INTO lmd_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Apul ipopari akkakat apeekat ungku ncik tokït kung apiꞌrekat itti, “Ili, ittarothin.” ");
INSERT INTO lmd_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","AIeccuo othïat tit itti, “Lakannoka loporot itti thuꞌrit thanekittat nyukul athettat luk.” ");
INSERT INTO lmd_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Apul ipopari iꞌrekat itti, “Ïï, Ili, anaruk luk manna laꞌrko thuꞌrit ithapukkot opingon nomaththak.” ");
INSERT INTO lmd_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ittina aIeccuo othïat tit itti, “Pul ipopari, ngkwonu thoccokot lon loKapik nocïkït thrïk, ana lon lang lakkattanthung.” Ana ukul wung wittakathe caꞌri cen caꞌri cen. ");
INSERT INTO lmd_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","OIeccuo poththekathe nokaꞌran ken akwoingkat akwomakot kuthut korok irapangka toCelïl akwokuꞌrat tocoꞌrong akwikkat cik. ");
INSERT INTO lmd_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Amungkut moul akkakanthok moppot, ammonat imico ana ul iꞌrimathe, ana ul wꞌrek iommat onyaro lon loporot, ana ul iommat ere, ana aꞌrek akin onekkekanthok tokït kung, akwittiekat kin appik. ");
INSERT INTO lmd_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ul woprttakatherit akka wimmat ul iommat ere awaik aere, ana iokat imico anyaro cakuruk ana iokat wiꞌrimathe awimmat cik. Ana okin thopirakanthet Kapik koIccereil noka. ");
INSERT INTO lmd_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","OIeccuo pakkarathe ul iammakothok akwiꞌrekat kin itti, “Mpipot thiak thoul enni, akka okin thothikkiet maꞌri mꞌrapuruk inenni uraththungon cene ana okin thella alpꞌrek iakin oꞌrko. Mpakannangkot itti mpathïot kin ikathar thiamat, akka akin apukkot ikathar.” ");
INSERT INTO lmd_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Aul iammakothok othïat tit itti, “Oron thiot thuꞌrit kartha cene thoppot thomnther ithekko noul enni?” ");
INSERT INTO lmd_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","AIeccuo ipittat kin itti, “Onon thonu arrakith wornoththa?” Akin othïat tit itti, “Onïn thonu arrakith weꞌreꞌrapuruk ana ape wotteik iarran.” ");
INSERT INTO lmd_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Akwiꞌrekat cungkut coul itti okin thikkoik nocapu. ");
INSERT INTO lmd_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ittina kwonekathe arrakith ieꞌreꞌrapuruk ana ape akwopirakanthet Kapik noka, ana kwomithatherit ana kwikkekathe ul iammakothok aikket ul. ");
INSERT INTO lmd_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Okin thoꞌrkkathe appik ana nthoththakakathe. Ana apotteik ul iammakothok wocumathe thuꞌrit ithokwentakot nan nyalünthüng nyeꞌreꞌrapuruk. ");
INSERT INTO lmd_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Maun moul ioꞌrkot thuꞌrit mokat athar wocoꞌrin (4,000) ella ul iari ana nyukul inyarran tit. ");
INSERT INTO lmd_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Anakka oIeccuo pothïothe ul nokathar, akwarrat ikuppuꞌrung konoiꞌri akwoingkat nokuthut korue irapangka tꞌrek akwakkakat noththok ipoccot kꞌran itti Macithan. ");
INSERT INTO lmd_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ul woPriccin ana ul woCcathukkin wakkakanthet oIeccuo anekkekathok nthipittothok lon itti kwakenekin lon ilommaththik akin ina itti kwaat noKapik. ");
INSERT INTO lmd_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","AIeccuo othïanthet kin tit itti, “Amma cipin capot, anniꞌre itti, ‘Cik cathakka coporot ngorrot inakka cik coꞌre tothiꞌrot,’ ");
INSERT INTO lmd_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ana ingïꞌrïmak anniꞌre itti, ‘Kapik kapo inenni akka cik coꞌre tothiꞌrot ana caththung.’ Onon thina akka annina cik corothiꞌrot ana conocapu, anaruk onon thakinnina lon ilrïk ilaik lakkattat inenni. ");
INSERT INTO lmd_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Onon thaul wolon ilokithak ana ithella thoccokot lon loKapik nomïkït, thipitto lon ilommaththik, lella ilakkattanthet kin lulluk ilommaththik ilokkattanthet pul pothernte lon loKapik oIunan akkakenetta non.” Ittina oIeccuo poththekathe nakin akwoingkat. ");
INSERT INTO lmd_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Anakka okin tharrothe tue irapangka cik aul iammakothok urekat nan oneko arrakith. ");
INSERT INTO lmd_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","AIeccuo iꞌrekat kin itti, “Noꞌrumoik nolon ilao noul woPriccin ana woCcathukkin ilikkoik ere müꞌrükül.” ");
INSERT INTO lmd_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Aul iammakothok erettaranthet lon elli thellek akin iꞌrekat itti, “OIeccuo paik pere ittina akka oron thakannona arrakith.” ");
INSERT INTO lmd_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","OIeccuo pinat nolon ilakin thokat akin eret akwiꞌrekathekin itti, “Onon ithonu thoccokot lon loKapik nomïkït thotte, nthontha akka annerettarne itti onon thella arrakith? ");
INSERT INTO lmd_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Onon tharthuk thakanninaiki? Onon thakannokwarikot arrakith ukuluk ioꞌrikiettat ul athar ukuluki, ana nyalünthüng nyornok inyanon thaꞌrntothe nothuꞌrit ithapukkotheik nani? ");
INSERT INTO lmd_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Onon thakannokwarikot narrakith ineꞌreꞌrapuruk ina ul woꞌrkot athar wocoꞌrin ana nyalünthüng nyothuꞌrit ithapukkotheik nan ithanon thaꞌrntothei? ");
INSERT INTO lmd_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ngintha akka onon thommanet itti mpokat cik anokorronno eret lon larrakith? Anaruk noꞌrumoik nolon ilao noul woPriccin ana woCcathukkin ilokkoik ere müꞌrükül.” ");
INSERT INTO lmd_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ittina okin thinakathe itti kwokat cik akwokorronno erenekin itti okin thaꞌrumo nomüꞌrükül imakkattat narrakith, anaruk itti okin thaꞌrumoik nnothongkene thoul woPriccin ana woCcathukkin. ");
INSERT INTO lmd_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Anakka oIeccuo paat nocik icaik iccik kokaꞌran koKaiccaria Pilippi, kwipittathe ul iammakothok itti, “Ul were itti ukul wopul iponyi oththa?” ");
INSERT INTO lmd_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Akin othïat tit itti, “Opilingon thiꞌre itti oung oIuanna pomamuthie, ana opilingon itti oung oIlia, ana opilingon icci itti oung Armia ana manna pul pꞌrek pothernte lon loKapik.” ");
INSERT INTO lmd_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","AIeccuo ipittat kin itti, “Ana onon thiꞌre itti oun okkwen?” ");
INSERT INTO lmd_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","ACcamaan oPoththuruc othïat tit itti, “Oung oMiccie, ukul woKapik ikaik ïcat.” ");
INSERT INTO lmd_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","AIeccuo othïat tit itti, “Ngwethïettat, Camaan ukul woIunan, pul iponyi akkakannokeneng elli, anaruk ongappa ci tothiꞌrot akkokenerung. ");
INSERT INTO lmd_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ana mpiꞌrethung itti oung oPoththuruc (ilonu itti cik iconthomat). Ana nocik iconthomat enci na anokuꞌre ul ncik ngngin iaccokot lon lin, ana puꞌran pothothïrïn pakannalkot lon len. ");
INSERT INTO lmd_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Mpethung lon ikkun longili ngorothiꞌrot, lon ilakorronno okorronno itti laka nocapu lakorronno okorronnako itti laka tothiꞌrot, ana ilakorronno itti laka nocapu lakorronnako itti laka tothiꞌrot.” ");
INSERT INTO lmd_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ana kwonekkekanthet ul iammakothok lon cik itti okin thakinniꞌret puꞌrek itti ook oMiccie. ");
INSERT INTO lmd_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ana nci nocaꞌri cen oIeccuo pikkatheik akwerene ul iammakothok itti kwonu itti kwaeo nokaꞌran koUruccelim akwothokkiettat thiak llon loppot inyaun nyoul ittïttïk ana ul ittïttïk woul wonoppan toKapik ana ul iangkene lon lothonceꞌret lon cik, ana itti kwonu itti kwakkuttat ana nomaꞌri imꞌrapuruk kurokietta nti ithio. ");
INSERT INTO lmd_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","APoththuruc onekat oIeccuo thocipit pellek akwaꞌrettat naak itti, “Ili, okorronno oka ittina, elli lakannoka naung kirrkkir.” ");
INSERT INTO lmd_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","AIeccuo oprttakat akwiꞌrekat oPoththuruc itti, “Pul pothopulut, opaꞌrik nti iccik kin, ngkwaik palikinin cik ikathar, ngkwella lon loKapik ica, anaruk lon lopul iponyi.” ");
INSERT INTO lmd_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ittina aIeccuo iꞌrekat ul iammakothok itti, “Amma okkwi ipongothe itti kwammakothin, kwonu itti kure noka kung akwoneko thapak thung akwommakothin. ");
INSERT INTO lmd_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Akka okkwi ipongothe itti kwaꞌret thikkoik thung ana kuret cik, anaruk okkwi ipuret thikkoik thung cik nti ilon lin ana kwaꞌret. ");
INSERT INTO lmd_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ngintha akkoporot amma pul pothikkiet capu ncik appik cung anaruk kurethe calak cung cik? Ana ngintha akka pul okucitto ncalak cung? ");
INSERT INTO lmd_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Akka ukul wopul iponyi waik wanthan nthrïk thoththan pung nuꞌrupa wothothïlettat woKapik, ana kwakke ul wululuk llon ilakin thokkothe. ");
INSERT INTO lmd_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Mpiꞌret non lon ilaik ïcat, opilingon nti iul enni iaik wacoꞌro cene thakannille akin tharthuk imma ukul wopul iponyi anthan ngngili ngung.” ");
INSERT INTO lmd_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Anakka maꞌri meot ncik mꞌrakkuruk, oIeccuo pipathe oPoththuruc ana oIakup ana oIuanna opang poIakup, akwonekat kin thellek ci noꞌra wocoꞌrong cukwit. ");
INSERT INTO lmd_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Kwoprttakatheik tokït ken. Kwolliathe toca ere cïngkï, ana eret wung wupukakatheik ere kꞌran kocïngkï cakuruk. ");
INSERT INTO lmd_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","OMucca ana oIlia thummathe ncik akin erekanthet oIeccuo. ");
INSERT INTO lmd_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","APoththuruc iꞌrekat oIeccuo itti, “Ili, loporot akka oron thaik cene. Amma ngkwongothe, ana mpuno müꞌrük mꞌrapuruk, culukku cang ana acꞌrek coMucca ana acꞌrek coIlia.” ");
INSERT INTO lmd_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Anakka kwokat cik akwere, anuththe akkakat nipuk anoꞌrumat kin, apoꞌre akkakat nti inuththe apiꞌrekat itti, “Ukul win enni ia mpongothe ana mpopirat noka nan. Noccïkot lon lung.” ");
INSERT INTO lmd_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Anakka ul iammakothok woccïkothe menik, akin ipat nꞌre akin eekat toma ncik. ");
INSERT INTO lmd_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Anaruk oIeccuo pakkakathe ana kwothantathekin akwiꞌrekat kin itti, “Nurokot kapik nokorronno ipo nꞌre.” ");
INSERT INTO lmd_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Anakka okin thonthot toma ncik, akin othiat pul pella aIeccuo pulluk akkaik akwocoꞌro. ");
INSERT INTO lmd_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Anakka okin thokat cik akin okkaprttako ntan nocoꞌrong, oIeccuo piꞌrekathekin itti, “Nokorronno iꞌret pul pꞌrek lon ila non thimmat puccuk aukul wopul iponyi urokiettakat nti ithio.” ");
INSERT INTO lmd_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Aul iammakothok ipittathok itti, “Ngintha akka ul iangkene lon lothonceꞌret lon cik iꞌrene itti oIlia ponu itti kwanthan tokït naMiccie?” ");
INSERT INTO lmd_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","AIeccuo othïanthet kin tit itti, “Ilaik ïcat itti, oIlia panthan ana kwapakket lon cik appik. ");
INSERT INTO lmd_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Anaruk mpiꞌret non itti, oIlia paat ntit, ana okin thakinninak, ana okin thokkothok lon ilakin thongothe itti okin thakkothok. Ana menik ukul wopul iponyi waik wathoccokiettat thiak inyaun nyen.” ");
INSERT INTO lmd_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ittina ul iammakothok winakathe itti kwokat cik akweret oIuanna pomamuthie akka kwiꞌret itti oIlia paat ntit. ");
INSERT INTO lmd_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Anakka okin thaat nocungkut coul, apul pꞌrek akkakanthet oIeccuo apeekat ungku ncik tokït kung. ");
INSERT INTO lmd_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Apiꞌrekat itti, “Ili win, ipi thiak thokkul win akka wapellellet ikapa ana lon len laccokiethok thiak cannan. Wapukkot ithik appinappin ana iiꞌri. ");
INSERT INTO lmd_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mponanet ul iammakothung ana okin thommakathe ittiet.” ");
INSERT INTO lmd_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","AIeccuo othïat tit itti, “Onon ul iannoccokot lon loKapik ana iaul iokithak, oron thikkoik uraththungon manna kartha? Mpanongkwinthet non ilon manna kartha? Nonanin ukul cene.” ");
INSERT INTO lmd_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","OIeccuo pothirriekathe uꞌrupa iokithak cik ana wirrathe nti ikkul ana ukul wothakkakathe woporot nocaꞌri cen. ");
INSERT INTO lmd_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ittina aul iammakot oIeccuo akkakanthok pellek aipittathok itti, “Ngintha akka onïn thommanet okïccene uꞌrupa iokithak nti ikkul?” ");
INSERT INTO lmd_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Kwothïanthet kin tit itti, “Onon thakannokïcce akka onon thonu thoccokot lon nomïkït thotteik. Mpiꞌret non lon ilaik ïcat, amma onon thonu thoccokot lon nocïkït thotteik ere core icotte onon thiꞌret coꞌrong enci itti, ‘Ngko ncene aeo ceneket’ ana caeo. Lon lella lalkot non. ");
INSERT INTO lmd_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Anaruk uꞌrupa iokithak iammakka enni wakïccetta ngngaꞌrama ana thocoꞌro nothuꞌrit tulluk.” ");
INSERT INTO lmd_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Anakka okin thaat tothun nnoththok poCelïl, oIeccuo piꞌrekathekin itti, “Ukul wopul iponyi waik wathokettat ul. ");
INSERT INTO lmd_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Okin thakkwothok, ana nomaꞌri imꞌrapuruk kurokwietta nti ithio.” Ana ul iammakothok wipathe thiak cannan. ");
INSERT INTO lmd_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Anakka oIeccuo ana ul iammakothok thaat nokaꞌran koKapprnaum, ul iaꞌrantot thaꞌrntot thonoppan toKapik wakkakanthet oPoththuruc. Okin thokat cik akin aꞌrntottot nopul pulukku thinar theꞌra akin ipittathok itti, “Atti pul pang ipangkene panekket thaꞌrntot thonoppan toKapik?” ");
INSERT INTO lmd_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","APoththuruc othïanthok tit itti, “Ïï, kwalekket.” Anakka oPoththuruc paat tuan, aIeccuo ipittathok itti, “Camaan, ngkwiꞌre itti kaththa? Nili nonocapu naꞌrntot thaꞌrntot nakkwengon, noul weni ana amma okorronno oka noul wen, noul wokwaari?” ");
INSERT INTO lmd_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","APoththuruc othïat tit itti, “Noul wokwaat.” AIeccuo iꞌrekathok itti, “Ittina ul wen wellarit. ");
INSERT INTO lmd_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Anaruk othakka itti aron okorronno uekin ka, ngko thorue irapangka arret teme iꞌri aiꞌriththa ape. Oneki pape ponommun ipa ngkwiꞌriththat anyot thon then, ana ngkwiot kakucci kulukku ikekko nothinar thocoꞌrin. Oneki kakucci ken athonekkenthin ithaꞌrntot thonoppan toKapik anekkekanthet ka kang.” ");
INSERT INTO lmd_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Nocaꞌri cen aul iammakot oIeccuo akkakanthok aipittathok itti, “Oththa akkrïk ingili ngorothiꞌrot?” ");
INSERT INTO lmd_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Kwakkarathe ukul iotteik ana kwoceꞌrekathe ithoꞌrkït then. ");
INSERT INTO lmd_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ana kwiꞌrekathekin itti, “Mpiꞌret non lon ilaik ïcat, amma onon thakonnoprttakoik mono othakka ammakka nyukul inyarran, onon thakinniꞌriko kirrkkir ingili ngorothiꞌrot. ");
INSERT INTO lmd_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ittina okkwi ipathikkie ka kung potteik ammakka ukul enni ook akkaka prïk ingili ngorothiꞌrot. ");
INSERT INTO lmd_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ana okkwi ipikkie ukul iotte cik ammakka enni ngkꞌran kin, kwikkien cik. ");
INSERT INTO lmd_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Anaruk amma opilin pokorronnot okkwi ipotte ipoccokothe lon lin ammakka empi akwokkot lon ilokithak kwakkmako cannan nopul ipïꞌrïkakot cna apantorrettat irue irapangka apïkïkko ngꞌri apio. ");
INSERT INTO lmd_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Angkre, ul wonocapu akka lon ilakorronno ul akkot lon ilokithak lonu itti lakaik. Anaruk angkre, pul nalon elli anthan nnan. ");
INSERT INTO lmd_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Amma ukun wang ana manna wek wakorronnong itti ngkwakkot lon ilokithak, okiotheik arre. Akka loporot itti ngkwikkoik nukun wulukku ana wek wulukku nothona tacok attutteꞌra ana nyaun anyunyeꞌra arrettat ithik thothupuththuput. ");
INSERT INTO lmd_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ana amma cït cakorronnong itti ngkwakkot lon ilokithak, antho nti ica arre. Akka loporot itti ngkwikkoik ncït culukku nothona kït akkukkeꞌra aeo ngngin ithik thothupuththuput.” ");
INSERT INTO lmd_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Paththon, nokorronno orakke lon lopilin ntiakin enthi itharran. Akka mpiꞌret non itti uꞌrupa wothothïlettat woKapik wen tothiꞌrot iangwot kin waik iccik kongappa tothiꞌrot ana wiꞌrethok lon appik. ");
INSERT INTO lmd_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ukul wopul iponyi waat itti athoꞌret ul iurttatheik. ");
INSERT INTO lmd_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Onon thakkot taththa amma pul ponu lungkat arrial ukuluk (100), ana thungkat thulukku thuratheik nan? Kwakannoththe nolungkat arrial wocoꞌrin ana alkaire ana ikken ukullacoꞌrin (99) nocoꞌrong akwothokwancot ithulukku ithuratheiki? ");
INSERT INTO lmd_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Mpiꞌret non ilaik ïcat, amma kwiothe kwapira noka cannan nnothungkat ithokat thuratheik nnolungkat ila arrial wocoꞌrin ana alkaire ana ikken ukullacoꞌrin ilokat lakannurat cik. ");
INSERT INTO lmd_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Menik, oththe pon tothiꞌrot pakannangkot itti opilin nti ntiakin itharran itti kurat cik.” ");
INSERT INTO lmd_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Amma opangkang ipanon thoccokothe lon loKapik pokkinthung lon lokithak, ngko athokenek lon lung ilokithak ila kwokkinthung anon theꞌra tulluk. Amma kwoccïkothe lon lang, ana nthopakkothe ikuꞌri nopangkan pꞌrïn. ");
INSERT INTO lmd_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Anaruk amma kwakonnoccïkot ana ꞌra itti kwokkothe lon ilokithak, appona pul pulukku ana manna ul weꞌra othakka itti akin athoccïkot akka anon ere othakka itti ‘alon ilokkattathe inako nan nnul weꞌra ana manna wꞌrapuruk.’ ");
INSERT INTO lmd_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ana amma kwꞌrat occïkot kin, iꞌrethe ul ioccokothe lon loIeccuo iaꞌrntakothe, ana amma kwꞌrat occïkot manna ul ioccokothe lon loIeccuo iaꞌrntakothe, okathak ere pul ipomma lon loKapik ana ammakka pul ipaꞌrntot akucci. ");
INSERT INTO lmd_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Mpiꞌret non lon ilaik ïcat, lon ilanon okorronno okorronno itti laka nocapu, lakorronno okorronnako itti laka tothiꞌrot ana lon ilanon okorronno itti laka nocapu, lakorronnako itti laka tothiꞌrot. ");
INSERT INTO lmd_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Mpappiꞌret non attang itti, amma opilingon theꞌra nti ianon thïꞌrïkot lon nocapu ilakin ipitto ngaꞌrama ongappa pin tothiꞌrot pethet kin. ");
INSERT INTO lmd_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Akka na ul waꞌrntakothe ngkꞌran kin weꞌra ana manna wꞌrapuruk, mpaka ithoꞌrkït then.” ");
INSERT INTO lmd_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","APoththuruc akkakanthet oIeccuo akwipittathok itti, “Ili, mpaccïkïnthet opangkin lon maꞌri mornoththa amma kwokkinthin lon lokithak? Maꞌri meꞌreꞌrapuruki?” ");
INSERT INTO lmd_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","AIeccuo othïat tit itti, “Mpiꞌrethung, okonnoka maꞌri meꞌreꞌrapuruk, anaruk maꞌri arrial wꞌrapuruk ana alkaire orrot tit maꞌri meꞌreꞌrapuruk (490). ");
INSERT INTO lmd_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ittina ngili ngorothiꞌrot ngammakka ili iakkarot ul iareko naak akin ethok kamucu kaꞌrupu iakin thokat thoccot. ");
INSERT INTO lmd_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Manakka ili wurokiet lon lokamucu ncik, akin onakanthok opilin ipa kwonat akucci nan woppot cannan. ");
INSERT INTO lmd_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ana pul pen pellat akucci ia akwokke kamucu ken, ittina aili iꞌrekat itti, ook ana opari ana nyukul nyung ana aꞌrupu appik ia kwonu thanekittat icekerek akin othoketta othakka itti akwokke kamucu. ");
INSERT INTO lmd_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Anaruk pul iponu kamucu noka eekat ungku ncik tokït koili apipittathok itti, ‘Ili win, ocoꞌrinin papotteik, ana mpakkekung kamucu kang appik.’ ");
INSERT INTO lmd_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Aili ipat thiak thung akwokkanthok nti ikamucu akwokarrannathok akweo. ");
INSERT INTO lmd_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Anaruk akka pul pen peot thapat, apiat okarkung pꞌrek ipa kwapponat kamucu nan kakucci wotteik. Kwapathe naak akwikkat cik akwokkwekok akwiꞌrethok itti, ‘Ethin kamucu kin.’ ");
INSERT INTO lmd_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Akarkung pen ipakin oreko apat cik tokït kung akwipittathok itti, ‘Ocoꞌrinin papotteik, ana mpakkekung kamucu kang appik.’ ");
INSERT INTO lmd_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Anaruk kwꞌrakathe ana kwonekathok ana kwonekkekathok ikorrkkor akwikkoik than puccuk akwokkekat kamucu. ");
INSERT INTO lmd_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Anakka ul wꞌrek iarekine ili wimmat lon len ilokat cik okin thipathe thiak cannan ana okin thoingkathe ana okin thaththerekanthet ili lon len ilokat cik appik. ");
INSERT INTO lmd_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ittina aili akkarat pul pen aiꞌrekathok itti, ‘Oung pul ipareko ipokithak, mpokkinung nti ikamucu appik akka ngkwerenin thiak nti icarak. ");
INSERT INTO lmd_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ngkwakannonat thiak thokarkang ipa annoreko ammakka mpipot thiak thangi?’ ");
INSERT INTO lmd_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Aili uakat ka kopul pen aekathok ul worikorrkkor akwothopoko puccuk akwokkekat kamucu ika kwonakot nan. ");
INSERT INTO lmd_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Elli akka ongappa porothiꞌrot okkinthet non thuluk thuluk amma onon thakannoccïkïnthet opangkangon lon nci noucce won.” ");
INSERT INTO lmd_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Anakka oIeccuo pomarttot lon elli, kwoththekathe noththok poCelïl akweo noththok poIouthia nokarkan kꞌrek korirue irapangka toÜrüthün. ");
INSERT INTO lmd_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ul womakathok woppot ana kwittiekathekin ithokat thongo. ");
INSERT INTO lmd_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Aul woPriccin akkakanthok athennekkek, akin ipittathok itti, “Locoꞌrotheik itti pul pathïo pari nolon nuthuki?” ");
INSERT INTO lmd_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","AIeccuo othïat tit itti, “Onon thannakkakkaro lon ilaik iatham woKapik iliꞌret itti, okkwi ipokuꞌret kin ncik ncinomun pokkothekin pul ipocura ana ipopari? ");
INSERT INTO lmd_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ana kwiꞌrekathe itti, ‘Nti ilon elli pul ipocura paththe naththan ana onnan apokattakot okin opari ana okin aththuththeꞌra thaka ka kulukku.’ ");
INSERT INTO lmd_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ittina okin thakannoka theꞌra pꞌrin anaruk okin thulukku. Menik ila Kapik kokottothe tothun pul pella pillorit.” ");
INSERT INTO lmd_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Akin ipittat itti, “Ngintha akka oMucca ponekkenthet lon cik itti pul pethet opari kaꞌrmacak kothothïako akwantothïok?” ");
INSERT INTO lmd_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","AIeccuo othïat tit itti, “OMucca pokorronnot non annothïo ari won akka mïkït mon mokat monthomat. Anaruk lokat lakannoka ittina ncinomun. ");
INSERT INTO lmd_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Anaruk mpiꞌret non itti, pul ipathïo pari appakannaꞌro mpul mono akwothipo apꞌrek kwaik paꞌro mpul ipopari ipittat ana lokithak.” ");
INSERT INTO lmd_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Aul iammakothok iꞌrekathok itti, “Amma lon elli akkaik noul iittettot, loporot itti pul pakinnipo pari.” ");
INSERT INTO lmd_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","AIeccuo othïat tit itti, “Pul pella pangant lon elli, anaruk okin thuluk itha Kapik kethet lon len. ");
INSERT INTO lmd_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Akka opilingon thokwontat thalmoꞌre ana opilingon thathuththakot ana opilingon thꞌrat ipo nti ithoccokot lon longili ngorothiꞌrot. Okkwi ipangat lon elli akwongat.” ");
INSERT INTO lmd_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ittina anyukul inyarran onakittakanthet oIeccuo othakka itti akwonekket nyaun nakin akwaꞌrakat ngaꞌrama nakin. Aul iammakothok othirriekat ul cik ionat nyukul. ");
INSERT INTO lmd_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","AIeccuo iꞌrekat itti, “Nokorronno anyukul inyarran anyanthan naun, nokorronno oceꞌrekin akka ngili ngorothiꞌrot ngoul iammakka enni.” ");
INSERT INTO lmd_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Anakka kwonekkethe nyaun nyung nakin akwaꞌrakat ngaꞌrama nakin akwoingkat. ");
INSERT INTO lmd_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Apul pꞌrek akkakanthet oIeccuo apipittathok itti, “Pul ipangkene, ngintha akka mponu itti mpakkot ipoporot anikkoik thikkoik thothupuththuput?” ");
INSERT INTO lmd_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","AIeccuo othïat tit itti, “Ngintha akka aipittinthin lon iloporot? Pul paik pulukku ipoporot. Amma ngkwongothe itti ngkwikkoik thikkoik thothupuththuput occïkothe lon ila Kapik kethet oMucca.” ");
INSERT INTO lmd_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Apul pen ipittat itti, “Lon liatha?” AIeccuo othïat tit itti, “‘Kirrnni okkwot pul, kirrnni aꞌro mpul ipopari ipittat, kirrnni omunye, kirrnni ocoꞌrot lon ngkarra, ");
INSERT INTO lmd_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","othianet oththe cik ana onne, ana angat ul wꞌrek ammakka ngkwongothe ka kang.’” ");
INSERT INTO lmd_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Apul ipopuꞌrit iꞌrekat itti, “Mpokkothe elli appik, ngintha akkokwentakinthin?” ");
INSERT INTO lmd_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","AIeccuo othïat tit itti, “Amma ngkwongothe itti ngkwathakka poporot, ngko athokette aꞌrupu ia angkwonu appik aikket ul akucci iella aꞌrupu cik, ana ngkwiot thaꞌrthan tothiꞌrot. Ittina antanthan amakothin.” ");
INSERT INTO lmd_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Manakka pul ipopuꞌrit poccïkothe menik, apoingkat appuaka cannan akka kwonat thaꞌrthan thoppot. ");
INSERT INTO lmd_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ittina aIeccuo iꞌrekat ul iammakothok itti, “Mpiꞌret non ilaik ïcat, lonthomat nopul ipapaꞌrthan itti piꞌriko ingili ngorothiꞌrot. ");
INSERT INTO lmd_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Mpappiꞌret non attang, lippappat itti thamla thakko icürük coipra nopul ipapaꞌrthan itti piꞌriko ingili ngoKapik.” ");
INSERT INTO lmd_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Anakka ul iammakothok woccïkothe elli, okin thoprttakathe tit cannan akin iꞌrekat itti, “Oththa akkaꞌrettat?” ");
INSERT INTO lmd_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","AIeccuo okathakat kin akwiꞌrekat itti, “Elli lonthomat nopul iponyi anaruk noKapik, lon appik lakannoka lonthomat.” ");
INSERT INTO lmd_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","APoththuruc othïanthok tit itti, “Onïn thoththet naꞌrupu appik anïn omakothung, ngintha akka anïn okketta ntit?” ");
INSERT INTO lmd_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","AIeccuo iꞌrekat kin itti, “Mpiꞌret non lon ilaik ïcat, nocaꞌri ica ongappa athoprtto lon cik ilie ana ukul wopul iponyi ikkoik noprrok pothrïk thung, onon ithommakothin thikkoik norrok iattul ana ikken keꞌra cakuruk, ana akkma ul woIccereil mothok mothok imattul ana ikken keꞌra. ");
INSERT INTO lmd_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ana okkwi ipoththet nokaman ana napangon ithomura ana ithari ana naththangon ana nannangon ana nonyukul ana opon nti ilon lin kwiot aꞌrupu wen woppot ana Kapik kethok thikkoik thothupuththuput. ");
INSERT INTO lmd_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Anaruk okin thoppot ithaththokat tokït thathoka thoceken, ana okin thoppot ithaththokat thoceken thathoka tokït.” ");
INSERT INTO lmd_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","OIeccuo pappiꞌrekat itti, “Ngili ngorothiꞌrot ngungkwot ere pul pokkwon ipeot ngïꞌrïmak apothokwantot ul iarekinok ikkwon komaa. ");
INSERT INTO lmd_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Akwiat ul akin erekat akwothïat kin topon akin othoreko nthinar thulukku thocaꞌri culukku. ");
INSERT INTO lmd_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Anakka cïngkï cokkothe ukullacoꞌrin cocik corrot, kwoingkathe ana kwimmakathe ul wꞌrek acoꞌro keccuk awella ngre cik. ");
INSERT INTO lmd_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Kwiꞌrekathekin itti, ‘Ngkonon cakuruk annothoreko ikkwon kin ana mpethet non akucci iekkot nan.’ ");
INSERT INTO lmd_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Menik okin thoingkathe. Ana kwapproingkat keccuk acïngkï angko ippa ana akka cokkothe cꞌrapuruk cipin, kwapprokkanthet ul wꞌrek menik. ");
INSERT INTO lmd_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Anakka cïngkï cokkothe ukuluk cipin, akwappoingkat akwothiat opilingon akin ocoꞌrittako akin thellat ngre cik ana kwipittathekin itti, ‘Ngintha akka annocoꞌrittakine cene nokkonokki, nthella ngre cik?’ ");
INSERT INTO lmd_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ana okin thothïanthet pul pen tit itti, ‘Pul pella pethet nïn ngre.’ Ana kwiꞌrekathekin itti, ‘Ngonon annothoreko ikkwon kin.’ ");
INSERT INTO lmd_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Anakka cipin capot, apul iponu kopon iꞌrekat pul ipakatha lon loul iareko itti, ‘Akkari ul iorekot aikket kin akucci wore, okuꞌre nci noul iurneo ikkwon antoine ul iorekot nci ngorrot.’ ");
INSERT INTO lmd_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ana ul iokuꞌret ngre ncik acïngkï cokkothe ukuluk wakkakathe ana woccerekathe thinar thulukku thulukku kurekkurek. ");
INSERT INTO lmd_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ana okkwion thorokït ithorekot nci ngorrot thokat akin ome itti okin akkaaccot akucci woppot noul iurnoreko, anaruk okin thoccerekathe thinar thulukku thulukku kurekkurek ammakka okkwion ithurnoreko thoccot. ");
INSERT INTO lmd_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Anakka okin thocceret appik okin thikkatheik akin aꞌrettakot nopul pokkwon. ");
INSERT INTO lmd_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Akin iꞌrekathok itti, ‘Ul enni iurnoreko, ana okin thocceret akucci arppithie mpangken pïn onïn ithorekot ngre ngïmmïn ana ncïngkï cippa.’ ");
INSERT INTO lmd_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Anaruk kwothïanthet opilin ntit ntiakin tit itti, ‘Pangkin, mpakannokwïethung, orit thaththakanneret itti ngkwareko nthinar thocaꞌri culukku? ");
INSERT INTO lmd_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Oneki akucci wang aeo. Mpongothe itti mpethet pul ipurnoreko ammakka mpethung. ");
INSERT INTO lmd_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Lon lokithak itti mpakkot lon ila mpongothe nakucci wini? Ngkwipot noꞌre akka mpoporot noul wꞌreki?’” ");
INSERT INTO lmd_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ittina aIeccuo iꞌrekat itti, “Okkwion ithokat thoceken thathoka tokït ana okkwion ithokat tokït thathoka thoceken.” ");
INSERT INTO lmd_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Anakka oIeccuo pokat cik akweo okuꞌrot nokaꞌran koUruccelim, kwonekathe ul iammakothok iattul ana ikken keꞌra thocipit, akwiꞌrekat kin itti, ");
INSERT INTO lmd_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Noccïkot, oron thaik thakuꞌrot nokaꞌran koUruccelim ana ukul wopul iponyi waik wathokettat ul ittïttïk woul wonoppan toKapik ana ul iangkene lon lothonceꞌret lon cik. Okin thathorukwethok akin akkmakathok nthio ");
INSERT INTO lmd_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","okin thathethok ul iakannoka woIouth akkothok ngure ngngin ana okkwekok akin okkwothok nothapak anaruk nomaꞌri mꞌrapuruk kurokietta nti ithio.” ");
INSERT INTO lmd_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ittina apari poCepethi akkakanthet oIeccuo nynyukul nyung anyunyeꞌra akweekat ungku ncik tokït koIeccuo, akwipittathok itti kwittarothok. ");
INSERT INTO lmd_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","OIeccuo pipittathok itti, “Ngintha akka ngkwongothe itti mpittarothung ngngin?” Ana pul pothïatherit itti, “Kirrnni nyukul nyin enyi anyikkoik iccik kang ingili ngang, aꞌrek thokkun wothothari ana aꞌrek nthokkun wothokure.” ");
INSERT INTO lmd_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","AIeccuo iꞌrekat kin itti, “Onon thomma lon ilanon thaik thipitto, onon thongothe itti nthaccokot thiak itha mpaik pathoccokot nani?” Akin othïat tit itti, “Ïï onïn thaccokot thiak.” ");
INSERT INTO lmd_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","AIeccuo iꞌrekat kin itti, “Nthaccokot thiak itha mpaik pothocckot anaruk thikkoik thokkun wothothari win ana thokkun wothokure win, okonnoka oun akkethettot, aꞌran enni wonekkettanthet okkwion itha ongappa pipinthet cik.” ");
INSERT INTO lmd_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Anakka opilingon ithattul thoccïkothe lon len okin thuakathe ka kopangon athuththeꞌra. ");
INSERT INTO lmd_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","AIeccuo akkarat kin tothun akwiꞌrekat kin itti, “Onon thina itti nili noul iakonnoka woIouth nonu lon loul wen ikkun ana nili nen inïttïnïttïk narekiekin llon len. ");
INSERT INTO lmd_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Lakannoka ianon anaruk okkwi ipongothe itti kwathakka prïk kwaka pul iparekine opangon thꞌrek. ");
INSERT INTO lmd_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ana okkwi ipongothe itti kwaka tokït kwonu itti kwaka pul iparekinenon. ");
INSERT INTO lmd_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ammakka ukul wopul iponyi wakannao itti wathorekakine anaruk waat itti wathorekine opilingon ana manna ethet thikkoik thung othakka itti aelikko ul woppot nti ilon ilokithak.” ");
INSERT INTO lmd_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Anakka oIeccuo ana ul iammakothok thoththet nokaꞌran kAria aul woppot omakathok. ");
INSERT INTO lmd_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ana ul wꞌrek wokat cik aikkoik nokuthut kokathar weꞌra wiꞌrimathe, anakka okin thoccïkothe itti oIeccuo paik paththeik, akin ikkat cik akin akkakkaro mpoꞌre itti, “Ili, ukul woThauth, ipi thiak thïn.” ");
INSERT INTO lmd_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Acungkut coul othirriekat kin cik itti okin thangkoik, anaruk okin thikkatheik akin okkot mpoꞌre cannan itti, “Ili, ukul woThauth, ipi thiak thïn.” ");
INSERT INTO lmd_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Menik aIeccuo ocoꞌrat akwakkarat kin akwipittat kin itti, “Nthongothe itti mpakkinthet non ngintha?” ");
INSERT INTO lmd_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Akin othïat tit itti, “Ili, ïnthongothe itti onïn thimmaik.” ");
INSERT INTO lmd_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ana oIeccuo pipithe thiak then ana kwothntathekin kït ana okin thimmakatheik accokkot ana okin thomakathok. ");
INSERT INTO lmd_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Anakka oIeccuo ana ul iammakothok okko ciki iccik koUruccelim okin thakkakathe nokaꞌran koPeththppaci nocoꞌrong coCeththun, aIeccuo othïat ul weꞌra nti iul iammakothok, ");
INSERT INTO lmd_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","akwiꞌrekat kin itti, “Ngkonon nokaꞌran engkrïk tokït kon ana amma onon thiꞌrikot tit, onon thathiot ngeꞌringka iopari ngïꞌrïkakotheik mpei. Nokꞌro annonanin. ");
INSERT INTO lmd_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ana amma pul pꞌrek piꞌrethenon lon lꞌrek, anniꞌrethok itti Ili akkiꞌret itti onïn thathokꞌro ana kwathïot ntan accokkot.” ");
INSERT INTO lmd_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Elli lokkattathe othakka itti alon oka ïcat ila pul pothernte lon loKapik piꞌret ngngin itti, ");
INSERT INTO lmd_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Iꞌrethe ul woIccereil itti, ‘Onokatha ili won waik wainenon, woporot cïkït ana warrothe teꞌringka, warrothe teꞌringka iotte.’” ");
INSERT INTO lmd_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Aul iammakothok oingkat akin okkat ammakka oIeccuo piꞌrethekin. ");
INSERT INTO lmd_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Okin thonakathe ngeꞌringka mpei ana ul wokuꞌrupathe eret nan ana oIeccuo parrathe tan akwikkat cik noret neꞌringka iotte. ");
INSERT INTO lmd_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ul woppot wokuꞌrupathe eret cik ikathar ana opilingon ongatho uꞌri wokira akin ipot cik ikathar. ");
INSERT INTO lmd_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Amungkut moul imeot tokït kung ana okkwion ithomakothekin miꞌrekathe mpoꞌre cittan itti, “Athopira noka oka nokkul woThauth.” “Athethïetta oka nakkwi ipanthan ngkꞌran koIli.” “Athopira noka oka noKapik tothiꞌrot.” ");
INSERT INTO lmd_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Anakka oIeccuo piꞌrikot nokaꞌran koUruccelim, aul appik wonokaꞌran oprttakat tit ana wipittathe itti, “Oththa empi?” ");
INSERT INTO lmd_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Aul iokat cik cungkut othïat tit itti, “Ook oIeccuo pul pothernte lon loKapik ponokaꞌran koNaccir noththok poCelïl.” ");
INSERT INTO lmd_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Menik oIeccuo piꞌrikathe noppan toKapik ana kwokïccekathe ul thapat appik iokat cik akette aꞌrupu ana ionat aꞌrupu icekerek. Kwongkuꞌrupathe uppuꞌrung cik ana orrok woul iokat akucitto akucci ana ionat mülükkür icekerek. ");
INSERT INTO lmd_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ana kwiꞌrekathekin itti, “Lokurrakot itti, ‘Man min makkarako itti man maꞌrama anaruk onon thothikkiet thukkie thoul wothuꞌran.’” ");
INSERT INTO lmd_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Aul iꞌrimathe ana ul iaimico akkakanthet oIeccuo noppan toKapik akwittiekat kin. ");
INSERT INTO lmd_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Anaruk akka ul ittïttïk woul wonoppan toKapik ana ul iangkene lon lothonceꞌret lon cik wimmat lon ilokkattathe iloporot ila oIeccuo pokkothe ilaprttakiettot tit ana okin occïkot poꞌre ponyukul inyokat cik noppan toKapik anyiꞌre itti, “Athopira noka oka thokkul woThauth,” menik okin thuakathe ka nolon loIeccuo. ");
INSERT INTO lmd_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Okin thipittathe oIeccuo itti, “Ngkwoccïkothe lon ila nyukul nyaik nyerei?” AIeccuo othïanthet kin tit itti, “Ïï mpoccïkothe. Onon thannakkakkaro lon ilaik iatham? Iliꞌre itti, ‘Oung Kapik akkongkenet nyukul inyako ana inyarran lon ilakin thopiranet Kapik noka ngngin.’” ");
INSERT INTO lmd_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Menik kwoththekathe nakin akwoingkat nokaꞌran koPeththania na kwaꞌrot. ");
INSERT INTO lmd_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ana ingïꞌrïmak akka oIeccuo pokat cik akwopakkot nokaꞌran koUruccelim, kwokat piamat. ");
INSERT INTO lmd_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Kwimmakathe pira popïcït nokuthut kokathar akwoingkat iccik ken itti kwathiththo nyukul nyen akwoꞌrko anaruk kwakanniat papꞌrek nopira ponat natha nulluk. Kwiꞌrekathe pira itti, “Ngkwakorronno appokwono pꞌrïn.” Ncïnang apira onthomakat. ");
INSERT INTO lmd_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Anakka ul iammakothok wimmat elli, akin ikkat cik akin oprttakot tit akin ipitto itti, “Pira popïcït ponthomat accokkot taththa ittina?” ");
INSERT INTO lmd_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","AIeccuo othïanthet kin tit itti, “Mpiꞌret non lon ilaik ïcat, amma onon thonu thoccokot lon loKapik nomïkït nthella mïkït meꞌrarit, onon thakkot lon ammakka lokkattanthet pira. Ana manna amma onon thiꞌrethe coꞌrong itti, ‘Ngko arret ka irok irapangka’ ana lakkattat ammakka onon thiꞌret. ");
INSERT INTO lmd_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ana amma onon thoccokothe lon loKapik nomïkït, onon thacco ilanon ipitto ngngaꞌrama.” ");
INSERT INTO lmd_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","OIeccuo piꞌrikathe noppan toKapik, anakka kwokat cik akwongkene ul ittïttïk woul wonoppan toKapik ana ul ittïttïk woul wakkakanthok, akin ipittathok itti, “Ngkwaik pakkot lon elli ngngili ngiatha? Ana oththa akkethung ngili ngen?” ");
INSERT INTO lmd_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","AIeccuo iꞌrekat kin itti, “Mpipittot non lon lulukku. Amma onon thothïnthin tit ana mpiꞌret non ngngili ngiatha inga mpaik pakkot llon elli. ");
INSERT INTO lmd_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Mamuthie moIuanna maat ngkartha? Maat ntothiꞌrori ana amma okorronno oka ntothiꞌrot noul ionyi?” Okin thikkatheik akin erettarne akin iꞌre itti, “Amma oron thiꞌret itti, ‘Ntothiꞌrot’ ana kwipittot ton itti, ‘Ngintha akka onon thꞌrat occïkïnthok?’ ");
INSERT INTO lmd_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Anaruk amma oron thiꞌret itti, ‘Noul ionyi’ oron thonu nꞌre akka ul okkot ton lon lꞌrek lokithak, akka ul appik wokat aiꞌre itti oIuanna pul pothernte lon loKapik.” ");
INSERT INTO lmd_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ittina akin othïanthet oIeccuo tit itti, “Onïn thomma.” AIeccuo iꞌrekat kin itti, “Mpakinniꞌret non itti ngngili ngiatha inga mpaik pakkot llon elli cakuruk.” ");
INSERT INTO lmd_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ana oIeccuo poꞌrungkwathe nan akwere itti, “Onon thame taththa? Pul pꞌrek pokat cik ponu nyukul nyeꞌra inyomura, akwiꞌrekat ukul irïk itti, ‘Ukul win, ngko athoreko ikkwon kin komaa inenni.’ ");
INSERT INTO lmd_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Aukul othïanthok tit itti, ‘Mpꞌrat,’ anaruk papotte aukul apperekat nocïkït aprttat lon cik aingkat topon. ");
INSERT INTO lmd_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Aththan oingkanthet ukul wung wꞌrek akwiꞌrekat ammakka kwiꞌrethe worokït, aukul othïat tit itti, ‘Pït pin, mpaeo’ anaruk wakannoingkat. ");
INSERT INTO lmd_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Oththa ntiakin aththuththeꞌra ipokkothe lon ila aththan pipittothekin itti okin thakkot?” Akin othïat tit itti, “Okkworokït akkokkothe.” AIeccuo iꞌrekat kin itti, “Mpiꞌret non ilaik ïcat itti ul iaꞌrntinthet nili akucci ana iari iallelle nul nakucci, okin thiꞌriko ingili ngoKapik tokït nanon. ");
INSERT INTO lmd_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Akka oIuanna pomamuthie painet non akwathokenenon kathar ikocoꞌrotheik ana onon thakannoccïkothok anaruk ul iaꞌrntinthet nili akucci ana ul iari iallelle nul nakucci akkoccïkothok. Ana manna onon thimmat lon len, onon thakannopaꞌrine lon cik itti annoccokot lon lung nomïkït.” ");
INSERT INTO lmd_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Noccïkot lon lꞌrek lothokkwie lon kuru ncik lꞌrek, pul pꞌrek pokat cik pocïkkarot kira komaa ikkwon kung ana puꞌrakathe nan ana kwokkathe kaꞌran na akwathuꞌrukot ngiꞌri ngen ana kunathe cüꞌrük na pul ikkoik apangwot cik. Akwekat ul wꞌrek ara tit aikkethok maa nnan imakin thorat amma okin thokiot. Ana kwoingkathe nokurtti. ");
INSERT INTO lmd_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Anakka caꞌri cakko napuththut cothokio, kwothïathe ul iarekinok aine ul iokat cik ara ikkwon athaꞌrntinthok maa ima kwonu itti kwacco. ");
INSERT INTO lmd_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ul ia kwappethet kopon itti wara tit woꞌrumathe ul iarekinok ana wokkwekathe opilin ana okkwot opilin ana okincot opilin cik mmothok. ");
INSERT INTO lmd_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ittina akwappothïanthet kin ul iarekinok wꞌrek woppot ana ul iokat cik ara ikkwon wokkathekin lon ammakka okin thokkinthet pꞌrak porokït. ");
INSERT INTO lmd_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ana menik pꞌrin, kwothïathe ukul wung akwiꞌre itti, ‘Okin thathiane ukul win cik.’ ");
INSERT INTO lmd_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Manakka akka ul iokat ara ikkon wimmat ukul, okin thikkatheik akin erettarne itti, ‘Opei empi ipapakkot nothaꞌrthan thoththan, nanthan urokkwothok aron opakkat nothaꞌrthan thoththan.’ ");
INSERT INTO lmd_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Okin thoccokathok ana okin thonekathok akin orrekathok nti ikkwon komaa akin okkwathok. ");
INSERT INTO lmd_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Amma pul iponu kopon paat, pakkot ul wen ngintha?” ");
INSERT INTO lmd_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ana ul ittïttïk wonoppan toKapik ana ittïttïk woul othïanthok tit itti, “Kwangwo ul iokithak wen ana kwethet ul wꞌrek kopon komaa ara tit iethok maa nocaꞌri cothiththo.” ");
INSERT INTO lmd_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","AIeccuo iꞌrekat kin itti, “Onon thakannakkakkaro lon ilaik iatham woKapik? Iliꞌre itti, ‘Pothok ipa ul iuno wꞌrat nti ipangken pothakkakathe cillang icaceꞌret kunthong tan, Ili Kapik akkokkothe elli ana loprttakietheron tit.’ ");
INSERT INTO lmd_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ittina mpiꞌret non itti ngili ngoKapik nganekittat non ana ngettat ul iaccïkot lon lung ana okkot lon ila Kapik kongothe itti okin thakkot. ");
INSERT INTO lmd_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Okkwi ipꞌrat lon lin kwikkoik ere ul iapukkot nopothok apocottakat, ana okkwi ipa pothok papothe nan kwakakꞌrakot cik.” ");
INSERT INTO lmd_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Anakka ul ittïttïk woul wonoppan toKapik ana ul woPriccin woccïkothe lon lothokkwie lon kuru ncik loIeccuo, okin thinakathe itti kwaik peret kin. ");
INSERT INTO lmd_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Okin thaththongothe itti okin thaccokothok anaruk okin thonat nꞌre nocungkut coul akka ul wonat lon nomïkït itti oIeccuo pul pothernte lon loKapik. ");
INSERT INTO lmd_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","OIeccuo pappiꞌrekat kin lon nthokkwie lon kuru ncik itti, ");
INSERT INTO lmd_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Ngili ngorothiꞌrot ngungkot ere ili iokkinthet opei kamuthe kothïpa. ");
INSERT INTO lmd_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Kwothïathe ul iarekinok athakkakkaro ul iokat wakkarakot itti wanthan ithïpa anaruk wꞌrakathe anthan. ");
INSERT INTO lmd_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ittina akwappothïat ul wung wꞌrek iarekinok akwiꞌrekat kin itti, ‘Niꞌret ul iokat wakkarakot itti anthan accokkot akka mpokkothe thuꞌrit thokamuthe pꞌrïn. Mpongwot kie ana nyumpuꞌrung inyittittathe ana mpokuccethe aꞌrupu cik appik.’ ");
INSERT INTO lmd_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Anaruk ul iokat wakkarakot itti waine kamuthe wakannoccïkat lon loul iarekinok ia kwappothïothe ana wopettakatheik, opilin peot topon kung ana opilin poinet ngre ngung. ");
INSERT INTO lmd_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ana opilingon thocciccokathe ul iarekine ili akin okkwekat kin akin ongwat kin. ");
INSERT INTO lmd_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ana ili wuakathe ka ana wothïathe ul wung irro ana wongwathe ul iongwot ul iarekinok ana okꞌre kaꞌran ken. ");
INSERT INTO lmd_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ana kwiꞌrekathe ul iarekinok itti, ‘Thuꞌrit thokamuthe thokkattathe anaruk okkwion ithakkarakothe thakannekko nan itti okin thakkattanthet lon loporot. ");
INSERT INTO lmd_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ngkonon iathar appik annakkakkaro ul ianon thiothe iathar anthan nokamuthe.’ ");
INSERT INTO lmd_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ittina ul iarekinok woingkathe iathar ana okin thaꞌrntathe ul iokithak ana ioporot iakin thiothe ana kamuthe koppakathe nnul iakin thakkarot nti iathar. ");
INSERT INTO lmd_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Anaruk akka ili waat itti wathokatha ul iakkarakot, wimmakathe pul pꞌrek iopocura pakannako eret wokamuthe kothïpa. ");
INSERT INTO lmd_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Kwiꞌrekathe pul pen itti, ‘Puruko pin, ngkwaat cene taththa angkwakannako eret wokamuthe kothïpa?’ Anaruk pul pen pakanniꞌrekat lon lꞌrek. ");
INSERT INTO lmd_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ittina aili iꞌrekat ul iarekinok itti, ‘Nïꞌrïkïkkok nyaun ana tacok annorrethok thapat iꞌrïmak na ul oot ana okꞌrellot kïnyït thocipit.’ ");
INSERT INTO lmd_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Akka ul woppot wakkarakot anaruk wotteik iumunta ntit aiꞌriko ingili ngoKapik.” ");
INSERT INTO lmd_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ittina aul woPriccin urokat anekkekat lon cik ilakin othipinthet oIeccuo cik akin ïꞌrak ngngin. ");
INSERT INTO lmd_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Akin othïat ul iammakot kin ana ul iongothe lon loIruthuc akin othiꞌret oIeccuo itti, “Pul ipangkene, onïn thina itti oung pul ipiꞌre lon ilaik ïcat ana ngkwangkene lon ilaik ïcat ammakka Kapik kongothe. Ana ngkwakannopellene lon loul ilakin thaik therethung ngngin akka ngkwella kït ken ana ngkwakannokkwine ul kunu ncik itti okin okkwengon. ");
INSERT INTO lmd_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Antiꞌret nïn itti ngkwiꞌre kaththa? Locoꞌrotheik itti oKkaiccer paꞌrntakinthet akuccii, lakannocoꞌrot ciki?” ");
INSERT INTO lmd_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Anaruk oIeccuo pinakathe lon len ilokithak ilakin thonat ima itti okin thïꞌrak, akwiꞌrekat kin itti, “Onon ithongothe itti nthinnikot lon, nthongothe itti nthïꞌran llon akaintha? ");
INSERT INTO lmd_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Nantokenen thinar ithaꞌrntakinthet nili ithanon thaik thaꞌrntinthet oKkaiccer.” Okin thonakanthok thinar, ");
INSERT INTO lmd_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ana kwipittathekin itti, “Purrut poththa empi? Ana kꞌran koththa engki ikokurrakot nan?” ");
INSERT INTO lmd_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Akin othïat tit itti, “PoKkaiccer.” Akwiꞌrekat kin itti, “Nethet oKkaiccer aꞌrupu woKkaiccer ana annethet Kapik aꞌrupu woKapik.” ");
INSERT INTO lmd_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Manakka okin thoccïkothe lon elli, akin oprttakat tit. Ana okin thoththekathe naak akin oingkat. ");
INSERT INTO lmd_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ana caꞌri cen aul woCcathukkin iokat ame itti thuroko nti ithio thella akkakanthet oIeccuo nthipitto. ");
INSERT INTO lmd_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Akin ipittathok itti, “Pul ipangkene, oMucca piꞌret itti amma pul piot nopari appella nyukul ana opang papakkot nan akwokwoninok nyukul. ");
INSERT INTO lmd_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ul wꞌrek wokat cik iccik kïn weꞌreꞌrapuruk wonu oththan pulukku ana onnan pulukku pul porokït pipot apiat appella nyukul, pul porokït popakkathe nan ana piathe appella nyukul cik ana poththekanthet opang nopari. ");
INSERT INTO lmd_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Pul pikkatheik apillillie eꞌre mono athakkakat weꞌreꞌrapuruk. ");
INSERT INTO lmd_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Pul ipopari piathe cakuruk. ");
INSERT INTO lmd_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Antiꞌret nïn, pul ipopari paka pari poththa ntiakin itheꞌreꞌrapuruk nocaꞌri cothuroko nti ithio akka okin appik thopakkukkothe nan?” ");
INSERT INTO lmd_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","OIeccuo pothïanthet kin tit itti, “Onon thommaik akka onon thomma lon ila atham woKapik waik weret ana manna puꞌran poKapik. ");
INSERT INTO lmd_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Nocaꞌri cothuroko nti ithio ul wakinnipo ana wakinnitta, ittina okin thaka ere uꞌrupa wothothïlettat woKapik tothiꞌrot. ");
INSERT INTO lmd_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Anaruk theret lon lothuroko nti ithio, onon thakannakkakkaro lon ilaik iatham, ila Kapik kiꞌrethenoni? ");
INSERT INTO lmd_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Iliꞌre itti, ‘Oun Kapik kAprein ana Kapik koIccaak ana Kapik koIakup.’ Kakannoka Kapik koul iokat willet anaruk Kapik koul iaik ngkït thapat.” ");
INSERT INTO lmd_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Manakka ul woccïkothe lon elli woprttakatherit nothongkene thung. ");
INSERT INTO lmd_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Anakka ul woPriccin woccïkothe itti oIeccuo pangkiet ul woCcathukkin cik akin aꞌrantakat tothun. ");
INSERT INTO lmd_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Apilin ntiakin ipangkene lon lothonceꞌret lon cik ipittat oIeccuo lon nthenekkek itti, ");
INSERT INTO lmd_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Pul ipangkene, lon liatha ilrïk nti ilon lothonceꞌret lon cik ila Kapik kethet oMucca?” ");
INSERT INTO lmd_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","OIeccuo pothïatherit itti, “‘Ongathe Ili Kapik kang nci nocïkït cang appik ana ngka kang appik ana ngngatheꞌre ngang appik.’ ");
INSERT INTO lmd_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Elli akkocittokït ana ilen akkrïk nti ipangken. ");
INSERT INTO lmd_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ana ileꞌra lammakka lorokït itti, ‘Ongathe ul wꞌrek ammakka ngkwongothe ka kang.’ ");
INSERT INTO lmd_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Lon lothonceꞌret lon cik appik ilaik ana ila aul wothernte lon loKapik weret, lakuꞌretta ncik nolon elli ileꞌra.” ");
INSERT INTO lmd_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Anakka ul woPriccin waꞌrntakothe tothun oIeccuo pipittathekin itti, ");
INSERT INTO lmd_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Onon thiꞌre itti oMiccie oththa? Ook ukul woththa?” Akin othïat tit itti, “Ook ukul woThauth.” ");
INSERT INTO lmd_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Kwiꞌrekathekin itti, “Ana tat akka oThauth ipaik pere ngKanang koKapik akwakkarok itti ‘Ili’? Akka kwiꞌret itti, ");
INSERT INTO lmd_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Ili Kapik wiꞌrethe Ili win itti, Ikkik thokkun win wothothari puccuk analkanthung thoꞌrak thang.’ ");
INSERT INTO lmd_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","OThauth pakkarot oMiccie itti, ‘Ili win’ ana tat akka akwoka ukul wung?” ");
INSERT INTO lmd_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Pul pellakathe ipothïnthok tit, nci cïnang pul pellakathe ipappripittathok lon lꞌrek akka okin thonat nꞌre itti okin thappipitto. ");
INSERT INTO lmd_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ittina oIeccuo piꞌrekathe cungkut coul ana ul iammakothok itti, ");
INSERT INTO lmd_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Ul iangkene lon lothonceꞌret lon cik loMucca ana ul woPriccin wikkot cik noprrok poMucca akin ongkene lon lothonceꞌret lon cik. ");
INSERT INTO lmd_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ittina onon thonu itti onon thaccïkot kin ana okkot lon appik ilakin iꞌret non itti onon thakkot. Anaruk nokorronno okkot ilakin okkot akka okin thakonnokkot ilakin thongkenet. ");
INSERT INTO lmd_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Okin thakkiet ul lon lïmïn akin antollo ntit akin okorronno ittarot kin. ");
INSERT INTO lmd_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Lon ilakin okkot appik lakin okkinthet ul othakka itti aimma. Okin nthakkwekot nyamenthuk nyeꞌra nyïttïttïk angꞌrek thokkun wothokure ana angꞌrek nocuthu. Nyamenthuk nyen nyonu lon tit loKapik. Ana okin thako ere wukwirukwit alokene itti okin thothaꞌrane Kapik ngaꞌrama. ");
INSERT INTO lmd_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Okin thongothe aꞌran wothothiakine cik na ul ittïttïk ikkoik nokamuthe ana okin thongothe itti okin thikkoik naꞌran ioporot nomuththun maꞌrama. ");
INSERT INTO lmd_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Okin thongothe itti okin thamiccako keccuk ana okin thongothe itti ul wakkaro kin itti, ‘ul iangkene.’ ");
INSERT INTO lmd_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Anaruk onon thonu itti onon thakannokorronno pul apakkaronon itti, ‘Pul ipangkene’ akka onon thonu pul ipangkene pon pulukku ana onon appik thulukku. ");
INSERT INTO lmd_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ana onon thakannakkaro pul pꞌrek nocapu itti, ‘Ngappa’ akka onon thonu oththe pon pulukku ana kwaik tothiꞌrot. ");
INSERT INTO lmd_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Manna nokorronno okorronno opilin itti kwakkaro non itti, ‘Ili’ akka onon thonu Ili won wulukku ana ook oMiccie. ");
INSERT INTO lmd_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ana okkwi iprïk ntianon paka pul ipittarot opilingon. ");
INSERT INTO lmd_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Akka okkwi ipathikkie ka kung prïk, kwathikkietta potte ana okkwi ipathikkie ka kung potte kwathikkietta prïk. ");
INSERT INTO lmd_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Angkre, ul iangkene lon lothonceꞌret lon cik ana ul woPriccin, onon ithongothe itti nthinnikot lon. Onon thullukkwinthet ul kathat kongili ngorothiꞌrot. Onon ngka kon thakanniꞌriko manna tit ana onon thakannokorronno itti ul wiꞌrikorit. ");
INSERT INTO lmd_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Angkre, nanon onon ul iangkene lon lothonceꞌret lon cik ana onon ul woPriccin, onon ithongothe itti nthinnikot lon. Onon thammikkot muruma annonneko kaman ken. Ana nti ilon elli thakkammako thon thaka thokithak cannan. ");
INSERT INTO lmd_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Angkre, ul iangkene lon lothonceꞌret lon cik ana ul woPriccin, onon ithongothe itti nthinnikot lon. Onon thanyaro nomothok appik ana manna aurrot tok irapangka cik othakka itti anniot opilin akwomakot thongkene thon. Ana amma kwothakkat pon, onon thathikkiek ukul wothothïrïn cannan nanon. ");
INSERT INTO lmd_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Angkre, onon nili inaik nitte ul anaruk onon thomma kathar, akka onon thiꞌre itti, ‘Amma okkwi parrmat ngkꞌran konoppan toKapik, tharrma thung thella lon cik anaruk okkwi iparrmat nthaap thonoppan toKapik, kwonu itti kwaccot kït notharrma thung.’ ");
INSERT INTO lmd_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Onon thomma kathar nthommaik, liatha akkrïk, thaap thonoppan toKapiki? Noppan toKapik irakarranno thaap thonoppan toKapik athoka thupupurei? ");
INSERT INTO lmd_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ana onon thiꞌret cakuruk itti, ‘Okkwi iparrmat ntuꞌrot taꞌrupu wothokiot ngüccük cik ana lon len lella lon cik, anaruk okkwi iparrma naꞌrupu iaik nan, kwonu itti kwaccot kït notharrma thung.’ ");
INSERT INTO lmd_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Onon ul iomma kathar, liatha akkrïk, aꞌrupu wothethet nuthuki? Tuꞌrot toKapik ikathikkie thethet nuthuk thupupurei? ");
INSERT INTO lmd_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ittina okkwi iparrma ntuꞌrot taꞌrupu wothokiot ngüccük cik, kwarrmat ngngin ana kwarrmat naꞌrupu iaik nan appik. ");
INSERT INTO lmd_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ana okkwi iparrma ntupan toKapik, kwarrmat ngngin ana kwarrmat ngKapik ikaik tit. ");
INSERT INTO lmd_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ana okkwi iparrma ngkꞌran korothiꞌrot, kwaik parrma mporrok poKapik ana kwarrmat ngKapik ikaik kikkoik nan. ");
INSERT INTO lmd_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Angkre, ul iangkene lon lothonceꞌret lon cik ana ul woPriccin, onon ithongothe itti nthinnikot lon, onon thethet Kapik aꞌrupu wuluwuluk naꞌrupu kurekkurek iattul attul appik ana aꞌrupu iakkattat ngucul. Anaruk thopaꞌrinet lon cik iloporot cannan lothonceꞌret lon cik ana lothokkot lon ngkathar kocoꞌrotheik, ana lon lothiak ana nthoꞌrumo nolon. Onon thira thareko llon iloporot okorronno opaꞌrine alꞌrek cik. ");
INSERT INTO lmd_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Onon ithitte ul anon thomma kathar, onon thaccot kït naꞌrupu iottotteik wolon lothonceꞌret lon cik annokorronno aꞌrupu ionu itti waccakot wolon lothonceꞌret lon cik. Ana manna anon thomma lon ilanon thaik thakkot. ");
INSERT INTO lmd_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Angkre, ul iangkene lon lothonceꞌret lon cik ana ul woPriccin, onon ithongothe itti nthinnikot lon. Onon thoꞌrillir ere eththeꞌret ana maththak imamenta nthoccul anaruk amoꞌrungkot monyï nti ikarak. ");
INSERT INTO lmd_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Pul poPriccin ipomma kathar, ime eththeꞌret ana maththak nti icarak ana nthaka thoꞌrillir nthapat cakuruk. ");
INSERT INTO lmd_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Angkre, ul iangkene lon lothonceꞌret lon cik ana ul woPriccin, onon ithongothe itti nthinnikot lon. Onon thammakka nupu inokkattanthet cik nopeththere nthapat anaruk nti icarak than annoppathe mummian moul illet ana ka ikokuttat. ");
INSERT INTO lmd_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Onon thammakka menik, ul wakathaccenon nthapat anthoꞌrillir ere ul iakkot lon loporot anaruk nti icarak than, onon thongothe itti nthinnikot lon ana nthonu lon ilokithak. ");
INSERT INTO lmd_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Angkre, ul iangkene lon lothonceꞌret lon cik ana ul woPriccin, onon ithongothe itti nthinnikot lon, onon thunine ul wothernte lon loKapik ana ul iokat woporot tokït koKapik illet maꞌrot nonupu preththere ana okkot thire nan ipreththere cakuruk. ");
INSERT INTO lmd_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Anon iꞌre itti, ‘Amma onïn thappokat cik nomaꞌri ima thiki thïn thokat cik nan, onïn thakorronno ongwot ul wothernte lon loKapik ïnaththungon.’ ");
INSERT INTO lmd_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ittina onon thaik theret ka kon itti onon thiki thoul iongwot ul wothernte lon loKapik. ");
INSERT INTO lmd_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ittina noꞌrungkot nothokkot lon ilokithak annomartto lon ilokithak ila thiki thon itheot thokuꞌret ncik. ");
INSERT INTO lmd_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Inyil ana nyukul nyoinyil, onon thalukkwot thakkmako thothothïrïn taththa? ");
INSERT INTO lmd_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ittina mpaik pathïnthet non ul wothernte lon loKapik ana ul wꞌrek inaik ntima ana ul iangkene. Opilingon thanon ongwo ana okkwet nothapak ana opilingon thanon okkwet nomuththun maꞌrama ana opilingon thanon okïcce nokaꞌran ana annommakot kin naꞌran nakin thollothe. ");
INSERT INTO lmd_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ana ittina ngüccük ngoul illet appik ioporot tokït koKapik nocapu ngapot nanon, okuꞌre ncik noüccük ngApil ipoporot tokït koKapik oingkanthet oCekkeria ukul woParakia ook ipa nthokkwothe ithoꞌrkït thonoppan toKapik ana toruꞌrot tothokinthet Kapik aꞌrupu woüccük cik. ");
INSERT INTO lmd_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Mpiꞌret non ilaik ïcat, elli appik lapot noul iaik inenni.” ");
INSERT INTO lmd_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Uruccelim, Uruccelim, onon ithaik thangwo ul wothernte lon loKapik ana okinco okkwion ithothïlanthet non. Mpokat pongothe maꞌri moppot itti mpaꞌrntot nyukul nyon tothun ammakka thakꞌruk aꞌrntot opeon iuꞌruccu anaruk onon thakannangkot. ");
INSERT INTO lmd_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ana inenni man mon moththettat nan mokïttakot. ");
INSERT INTO lmd_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Akka mpiꞌrethenon itti, onon thakorronno appimman attang puccuk annomekat itti, ‘Athethïe oka nakkwi ipaik panthan ngkꞌran koIli.’” ");
INSERT INTO lmd_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","OIeccuo pokat poththet nokaꞌran konoppan toKapik akwikkat cik akweo, aul iammakothok akkakanthok aiꞌrekathok itti, “Antokatha kaman engki akka kuntat.” ");
INSERT INTO lmd_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","AIeccuo ipittat kin itti, “Onon thimmat aꞌrupu enni appiki? Mpiꞌret non lon ilaik ïcat itti pothok pella pulukku pakwentako nopangken, müntat nocapu mulumuluk appik.” ");
INSERT INTO lmd_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Anakka oIeccuo pokat cik akwikkoik nocoꞌrong coCeththun, ul iammakothok wakkakanthok pellek akin iꞌrekat itti, “Iꞌrethenïn itti lon elli lakaik acintha ana lon liatha ilakene itti ngkwaik pao ana thocothakot tholuput?” ");
INSERT INTO lmd_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","OIeccuo pothïanthet kin tit itti, “Noꞌrumoik akka pul pꞌrek ammikkot non. ");
INSERT INTO lmd_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Akka ul woppot wanthan ngkꞌran kin aiꞌre itti, ‘Oun oMiccie,’ ana wammikkot ul woppot. ");
INSERT INTO lmd_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Onon thaccïkot lon lothoꞌrak ana poꞌre pothoꞌrak, anaruk annokorronno opelle. Lon ila ammakka elli lonu itti lakaik anaruk okorronno oka itti thocothakot pꞌrïn. ");
INSERT INTO lmd_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ul nomoꞌrong appik waprttakarot tit ana ngili ngaprttakarot tit. Tï takaik ana capu caꞌrïntïttako ncik naꞌran woppot. ");
INSERT INTO lmd_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Lon elli appik laka ere amma ukul okꞌrello pul ipaik pakwono. Lon elli appik lakene itti lon ilaik lanthan lantruko ncik. ");
INSERT INTO lmd_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Caꞌri cen onon thanekittane nili annothoccokiettat thiak ana ongutta, ana ul nomoꞌrong appik wꞌra non nti ilon lin. ");
INSERT INTO lmd_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ana nocaꞌri cen ul woppot wacottako nti ithoccokot tholon loKapik nomïkït ana okin thakettetto ana ꞌraro kïnyït ken. ");
INSERT INTO lmd_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ana ul woppot wummot ncik wothernte lon loKapik ngkarra ana okin thammikkot ul woppot. ");
INSERT INTO lmd_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ana lon lulluk ilokithak akka appat cik ana lakorronno thongarot thoul woppot athintat cik nnomïkït. ");
INSERT INTO lmd_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Anaruk okkwi ipoccokothe cïkït ilon puccuk mono alocothakat, kwaꞌrettat. ");
INSERT INTO lmd_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ana lon elli iloporot longili langkenetta capu ncik appik aloka itti loccïkakothe ncik appik noul appik ittina athocothakot antao.” ");
INSERT INTO lmd_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Ittina amma onon thimmat lon ilokithak ilakïttoik noppan toKapik irupupure ila pul pothernte lon loKapik oThanial perethe. Apul ipakkakkaro ina lon len. ");
INSERT INTO lmd_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ittina okkwion ithaik noththok poIouthia akin ollot toꞌra womoꞌrong. ");
INSERT INTO lmd_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ana amma okkwi ipaik toꞌra woman akwokorronno iꞌre itti kwarpot cik ntan itti kwothummo papꞌrek nnoppan. ");
INSERT INTO lmd_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ana okkwi ipaik topon akwokorronno opakkot tuan itti kwathummo kret kothokuꞌrupakot. ");
INSERT INTO lmd_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Lon laka laraththa noul ioppeppethe ana noul iakie nyukul nomaꞌri men. ");
INSERT INTO lmd_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Naꞌrane Kapik ngaꞌrama othakka itti alon len okorronno oka icpo ana manna nocaꞌri caCcepith. ");
INSERT INTO lmd_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Akka ul wathoccokot thiak cannan nocaꞌri cen. Okin thaccokot thiak cannan nothoccokot thiak ithakin thoccokothe ammakka pothok pokuꞌrettat ncik manna inenni, ana thoccokot thiak thella pꞌrïn. ");
INSERT INTO lmd_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ana amma Kapik kakorronno orpet maꞌri men cik mothoccokot thiak, pul pella ipakkoik anaruk nti ilon loul ia Kapik kakkarot kworpet maꞌri men cik. ");
INSERT INTO lmd_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ana nocaꞌri cen amma opilin piꞌrethenon itti, ‘Okatha oMiccie pei’ ana manna itti, ‘Okkweꞌre ceneket’ nokorronno occïkot lon len. ");
INSERT INTO lmd_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Akka ul wanthan iiꞌre itti okin oMiccie ngkarra ana ul wothernte lon loKapik ngkarra akkot lon ilommaththik akin ammikkot ul ngngin ana akin ammikkot manna ul ia Kapik kakkarot amma okin akkiothe kathar ikakin ammikkot kin ngngin. ");
INSERT INTO lmd_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Mpiꞌrethenon acaꞌri cen carthuk anthan. ");
INSERT INTO lmd_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ittina amma opilin piꞌrethenon itti, ‘Kwaik ithampang,’ nokorronno eo than ana manna itti, ‘Kwei noppan’ nokorronno occokot lon len nomïkït. ");
INSERT INTO lmd_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Akka thao thokkul wopul iponyi thimmako ere kꞌran kothuleꞌrak amma tholliot nci na acïngkï ummot ngngin akꞌran ken oingkat ci na acïngkï orungkwot. ");
INSERT INTO lmd_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Na nengki aꞌrntakot papꞌrek paik than piot.” Kwiꞌret elli akwokene itti thao thung thinako nan. ");
INSERT INTO lmd_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Ana amma maꞌri mothoccokot thiak men mocothakothe, ‘Ngïꞌrïmak ngaꞌroik ana kwanok kakannupuka ana mothot mapukkwo ntothiꞌrot ana aꞌrupu worothiꞌrot waꞌrïntïttako ncik appik.’ ");
INSERT INTO lmd_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Nocaꞌri cen alon ilakene itti ukul wopul iponyi waik wanthan lummot ncik tothiꞌrot ana ul wonocapu appik woo. Okin thimma ukul wopul iponyi anthan nonuththe tothiꞌrot mpuꞌran ana nthrïk. ");
INSERT INTO lmd_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ana kwathïot uꞌrupa wothothïlettat wung mpoꞌre pothïpïl cittan akkaro ana aꞌrntot okkwion ithakkarakot nnocapu ncik appik.” ");
INSERT INTO lmd_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Nina lon elli lothokkwie lon kuru ncik lopira popïcït, amma natha nopira popïcït iat ana anocokka, onon thina itti karran kakko napuththut. ");
INSERT INTO lmd_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ittina amma onon thimmat lon len appik, nina nan itti caꞌri coIeccuo cakko napuththut akwokkaprttako. ");
INSERT INTO lmd_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Mpiꞌret non lon ilaik ïcat itti, lon elli lakkattat appik aul enni inenni warthuk ille. ");
INSERT INTO lmd_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Tothiꞌrot ana capu thintat cik anaruk lon lin lakorronno intat cik aththik.” ");
INSERT INTO lmd_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Pul pella ipina lon locaꞌri manna cïngkï, manna uꞌrupa wothothïlettat woKapik tothiꞌrot manna ukul ngka kung anaruk ongappa pulluk akkina. ");
INSERT INTO lmd_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ammakka lokat nocaꞌri coNua, ittina laka menik cakuruk amma ukul wopul iponyi ao. ");
INSERT INTO lmd_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Nomaꞌri akka ngike ngarthuk ao, ul wokat cik aꞌrkoik ana ittetto mono aNua iꞌrikat ikuppuꞌrung konoiꞌri. ");
INSERT INTO lmd_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Okin thaththommat itti ngimpen akkakaik puccuk mono aike akkakat aipat kin appik. Laka ittina amma ukul wopul iponyi ao. ");
INSERT INTO lmd_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ittina ul wakaik weꞌra ikkwon areko, opilin panekitta akin oka akin aththeꞌra, apilin oththetta nan. ");
INSERT INTO lmd_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ul iari wakaik weꞌra wakako nocana, opilin panekitta akin oka aththeꞌra, apilin oththetta nan. ");
INSERT INTO lmd_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ittina noccot kït cik akka onon thomma caꞌri ica Ili won ao nan. ");
INSERT INTO lmd_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Nina nan itti amma pul poruan pappina caꞌri ica pul pothuꞌran ao nan ngkoꞌra, kwangwot cik ana kwakorronno okorronno itti pul pothuꞌran itti pamunyethok aꞌrupu noppan. ");
INSERT INTO lmd_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Menik onon thonu itti onon thokuccekot cik akka ukul wopul iponyi wanthan nocaꞌri icanon thomma itti waik wanthan nan.” ");
INSERT INTO lmd_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Amma pul paik ipareko ipoccokothe lon nocïkït ana pinaik ook pen ipa opït ethet lon ikkun loul iareko tuan thanung. Kwikket ul woruan thuꞌrit nocaꞌri icekkot nan. ");
INSERT INTO lmd_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Laka loporot nopul pen amma opït pokkaprttakot nti imakkren akwathiothok akwokkot ngre papenang. ");
INSERT INTO lmd_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Mpiꞌret non lon ilaik ïcat itti kwethok lon ikkun laꞌrupu wung appik. ");
INSERT INTO lmd_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Anaruk amma pul ipareko pokithak ana piꞌret ka kung itti, ‘Opït pin paccoik,’ ");
INSERT INTO lmd_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ana akwikkoik akwokkwe ul ia kwonu lon len ikkun iareko ana akwoꞌrkoik ana ïkko ngapak okin okkwion itha ngapak ngaik ngakkwot. ");
INSERT INTO lmd_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Opït pung pao nocaꞌri ica pul iparekinok pomma itti kwaik pao nan. ");
INSERT INTO lmd_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Kwakkiethok thiak cannan ana kwathïothok iul iongothe itti winnnikot lon nakin oot ana okꞌrellot kïnyït thocipit.” ");
INSERT INTO lmd_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","OIeccuo poꞌrungkathe nolon akwere akwiꞌre itti, “Ana nocaꞌri cen ngili ngorothiꞌrot ngaka ere nyukul inyoire inyattul, nyonekot muꞌru imonu ngaak iacco anyoingkat thapat anyothocurot ipul ipipo. ");
INSERT INTO lmd_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ana nyukul ukuluk ntiakin nyokat nyommat cik nti ima ana ukuluk ntiakin nyokat nyinaik nti ima. ");
INSERT INTO lmd_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Okin ithommaik thonekathe muꞌru maak iacco tulluk akin okorronno oneko ngaak ngꞌrek arttot nan mmuꞌru mꞌrek. ");
INSERT INTO lmd_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ana okin ithinaik thonekathe ngaak iacco prek mmuꞌru mꞌrek. ");
INSERT INTO lmd_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ana pul ipipo poccatheik cannan ana okin appik thokinyakathe mono oingkat inthe. ");
INSERT INTO lmd_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ana thampang thongkꞌra, apul pꞌrek iꞌrekat mpoꞌre cittan itti, ‘Pul ipipo pei paat nothocurot iaak.’ ");
INSERT INTO lmd_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ana nyukul inyari nyurokathe appik ana nyokuccekathe muꞌru imonu ngaak iaccorit othakka itti amocco preththere. ");
INSERT INTO lmd_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ana okin ithommaik thiꞌrekathe okkwion ithinaik itti, ‘Nethet nïn ngaak iacco ngotte akka muꞌru imonu ngaak iacco maik mille lik nan.’ ");
INSERT INTO lmd_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Akin othïanthet kin tit itti, ‘Aa, ngaak ianïn thonu ngannekko nanïn ana onon thaeo noul iakette ngaak annothokerine ka kon.’ ");
INSERT INTO lmd_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Anaruk akka okin thokat cik ikathar akin othokero ngaak, apul ipipo akkakat. Anyukul ukuluk inyoire inyokat nyokuccekotheik iꞌrikat akin aththut ikamuthe kothïpa. Ana kathat kulukkwathe. ");
INSERT INTO lmd_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ittina papotteik anyukul inyommaik akkakat cakuruk anyakkarat itti, ‘Pït pïn, pït pïn, anyinet nïn kathat.’ ");
INSERT INTO lmd_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Anaruk pul ipipo piꞌrekathekin itti, ‘Mpiꞌret non ilaik ïcat, mpomma non.’” ");
INSERT INTO lmd_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Menik aIeccuo iꞌrekat itti, “Noꞌrumoik akka onon thomma caꞌri ana manna cïngkï ica anao nan.” ");
INSERT INTO lmd_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Ana attang ngili ngorothiꞌrot ngungkwot ere pul ipaik paeo imakkren ciththan, apakkarat ul wung iarekinok akwikkekat kin aꞌrupu wung akin angwot akkwella. ");
INSERT INTO lmd_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ana kwekathe okkulukku akucci naꞌruk ukuluk ana opilin akucci naꞌruk weꞌra ana opilin akucci ngkaꞌruk kulukku Kwikkethekin aꞌruk kurekkurek iakin thekkot nan itti okin thangwot akka kwinat kin papenang, akwoingkat nokurtti kung. ");
INSERT INTO lmd_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ana pul ipoccot akucci naꞌruk ukuluk poingkathe cokoccokot ana kworekiekathe akucci wung ana kwiathe akucci arttot nan aꞌruk ukuluk. ");
INSERT INTO lmd_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ittina cakuruk okkwi ipoccot akucci aꞌruk weꞌra poingkathe ana kworekiekathe ana kwiathe aꞌruk weꞌra arttot nan. ");
INSERT INTO lmd_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Anaruk okkwi ipoccot kaꞌruk kulukku poingkathe ana kwaththipat tupu ana kwocïkkathe akucci wopït pung tit akwangwot. ");
INSERT INTO lmd_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Anakka opït pen pikkot cik than puccuk, kwokkaprttakathe ntan akwipittat kin itti okin thakenek itti okin thokkothe ngimpen nakucci wung. ");
INSERT INTO lmd_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Pul ipappoccot akucci naꞌruk ukuluk ponakathe akucci naꞌruk ukuluk arttot nan. Ana kwiꞌrekathe opït itti, ‘Pït pin, ngkwethin akucci naꞌruk ukuluk, ana mporekiet ana mpiothe aꞌruk ukuluk arttot nan.’ ");
INSERT INTO lmd_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ana opït pothïanthok tit itti, ‘Ngkwokkothe lon loporot, oung pul ipareko ipoporot ana ipaꞌrumo nolon. Ngkwoꞌrumot nolon laꞌrupu wotteik, mpethung lon laꞌrupu woppot ikkun. Aꞌrik athopira noka nopït pang.’ ");
INSERT INTO lmd_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Apul ipoccot akucci aꞌruk weꞌra akkakat cakuruk ana kwiꞌrekathe opït itti, ‘Pït pin, ngkwethin akucci aꞌruk weꞌra ana mporekiet ana mpiothe aꞌruk weꞌra arttot nan.’ ");
INSERT INTO lmd_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Apït othïanthok tit itti, ‘Ngkwokkothe lon loporot, oung pul ipareko ipoporot ana ipaꞌrumo nolon. Ngkwoꞌrumot nolon laꞌrupu wotteik, mpethung lon laꞌrupu ikkun woppot. Aꞌrik athopira noka nopït pang.’ ");
INSERT INTO lmd_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Menik apul ipoccot akucci kaꞌruk kulukku akkakat akwiꞌrekat itti, ‘Pït pin, mpina kicce itti ngkwommaꞌron, ngkwakio kopon ika ngkwakannee ana ngkwakkuttot mïl ima ngkwakannora. ");
INSERT INTO lmd_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ittina mpokat ponat nꞌre ana mpamuꞌruttathe kaꞌruk kakucci ika ngkwethin ippu. Katha, kaꞌruk kang kei.’ ");
INSERT INTO lmd_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Apït othïat tit itti, ‘Oung pul ipareko ipommangka ana iponu ngore, ngkwina itti mpakio kopon ika mpakannee ana mpakkuttot mïl ima mpakannora. ");
INSERT INTO lmd_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ngkwira pethet opilingon akucci akin orekie othakka itti amma mpokkaprttakot ntan anathocco akucci awarttakothe nan.’ ");
INSERT INTO lmd_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Akwiꞌrekat pul iparekinok pꞌrek poka itti, ‘Onekothok kaꞌruk kakucci, ethet okkwi iponu akucci aꞌruk attul. ");
INSERT INTO lmd_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Akka okkwi iponu papꞌrek kwarttakinthet nan ana okkwi iponu aꞌrupu wotteik, kwanekittat manna ia kwonat wotte. ");
INSERT INTO lmd_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Norret pul ipareko empi thapat iꞌrïmak ipella lon cik na akwoot ana okꞌrellot kïnyït thocipit.’” ");
INSERT INTO lmd_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Amma ukul wopul iponyi anthan nthrïk thung ana nuꞌrupa wothothïlettat woKapik appik, ana kwikkoik noprrok pothrïk thung pothakkma. ");
INSERT INTO lmd_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ana ul wonocapu appik waꞌrntakot tokït kung ana kwapetto iul karkko pul ipuꞌre opetto lungkat nti ilicok. ");
INSERT INTO lmd_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Kwipot lungkat thokkun wothothari ana licok thokkun wothokure. ");
INSERT INTO lmd_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Menik Ili wiꞌret okkwion ithaik thokkun wothothari itti, ‘Nanthan, onon itha angappa pin pethïet, nathopakkot nongili ionekkettanthet non cik nci maꞌrot akka capu cokuꞌrettat ncik appik. ");
INSERT INTO lmd_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Akka mpokat piamat ana onon thethin aꞌrupu wꞌrek ampoꞌrkot, ana pica pappokkwothin ana onon thethin ngꞌri ampïkkot, ana mpokat pakwat ana onon thikkierin cik. ");
INSERT INTO lmd_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Mpokat cunthut ana onon thakierin eret, ana mpokat pongo ana onon thokathat lon lin, ana mpokat ikorrkkor ana onon thaththokatha naun.’ ");
INSERT INTO lmd_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ana ul ioporot tokït koKapik wathïnthok tit itti, ‘Ili, ïnthiothung kartha angkwiamat anïn ekathung thuꞌrit, ana manna onïn thiothung kartha apica pokkwothung ïnekathung ngꞌri aïkkat? ");
INSERT INTO lmd_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ana onïn thiothung kartha angkwakwat ïnikkiekathung cik ana manna angkwacunthut ïnakiekathung eret? ");
INSERT INTO lmd_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ana onïn thiothung acintha angkwongo ana manna angkwaik ikorrkkor anïn athokathakat naung?’ ");
INSERT INTO lmd_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ili wathïnthet kin tit itti, ‘Mpiꞌret non ilaik ïcat itti, ilanon thokkinthet opilin pꞌrek ipotte ipammakothin, onon thokkinthin.’ ");
INSERT INTO lmd_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ittina kwiꞌret okkwion ithaik thokkun wothokure itti, ‘Nopaꞌroik nti iccik kin ngonon ithik thothupuththuput, onon ithattattakot nthokꞌro nthik thothupuththuput ithonekkettanthet pul pothopulut cik ana uꞌrupa wothothïlettat wung. ");
INSERT INTO lmd_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Akka mpokat piamat ana onon thakannethin papꞌrek anoꞌrko, ana mpokat papica pokkwothe ana onon thakannethin ngꞌri anïkko, ");
INSERT INTO lmd_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","mpokat pakwat ana onon thakannikkien cik, mpokat cunthut ana onon thakannakien eret, ana mpokat pongo ana onon thakannokatha naun, ana mpokat ikorrkkor ana onon thakannokatha lon lin.’ ");
INSERT INTO lmd_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Okin then thathïot tit itti, ‘Ili, onïn thiothung kartha angkwiamat ana manna apica pokkwothung ana manna angkwakwat ana manna angkwacunthut ana manna angkwongo ana manna angkwaik ikorrkkor ana onïn thakannittarothung?’ ");
INSERT INTO lmd_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ana Ili wathïot tit itti, ‘Mpiꞌret non ilaik ïcat itti ilanon thakannokkinthet okkwi ipotte nti iapangkingon enthi, onon thakannokkinthin.’ ");
INSERT INTO lmd_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ittina okin thaine thakkmako thothupuththuput anaruk okkwion ithoporot tokït koKapik thaeo ithikkoik thothupuththuput.” ");
INSERT INTO lmd_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Anakka oIeccuo pomarttot there lon len appik, kwiꞌrekathe ul iammakothok itti, ");
INSERT INTO lmd_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Onon thina itti nomaꞌri meꞌra kamuthe koThaurrot kaman kꞌrek cik kuroko ncik ana ukul wopul iponyi wathettat ul ikkun akkuttakat nothapak.” ");
INSERT INTO lmd_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ittina aul ittïttïk wonoppan toKapik ana ul ittïttïk woul waꞌrntakathe tothun tuan topul iprïk ponoppan toKapik ipoccot kꞌran itti oKiappa. ");
INSERT INTO lmd_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ana okin therekathe itti okin thaccokot oIeccuo thuꞌran akin okkwothok. ");
INSERT INTO lmd_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Anaruk okin thiꞌrekathe itti, “Ntrun okorronno okkot lon len nomaꞌri mokamuthe akka ul okkot camutta.” ");
INSERT INTO lmd_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Manakka oIeccuo pokat cik nokaꞌran koPeththania tuan topul ipoccot kꞌran itti oCcamaan iponat ïnyï noka, ");
INSERT INTO lmd_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","anakka oIeccuo pokat cik akwothïngkakot kriki kothokkun wothokure iccik kokuppuꞌrung akwoꞌrkoik, apul ipopari pꞌrek akkakat ngngaak iakkunako ere amutha ncuꞌru copreththere ngonu cekerek crïk apunathok ica. ");
INSERT INTO lmd_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Anakka ul iammakothok wimmat lon len, okin thuakathe ka, akin ipittarat lon itti, “Ngintha akka aꞌrupu enni okïttakinthet cik ittina? ");
INSERT INTO lmd_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ngaak ngamutha engngi ngira akkaketta nakucci woppot, akucci ikkettat ul iaiak.” ");
INSERT INTO lmd_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Menik oIeccuo pinakathe nolon len, akwiꞌrekat kin itti, “Ngintha akka nthuanet ka kopul ipopari empi? Akka pokkinthin lon iloporot. ");
INSERT INTO lmd_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ul iaiak wanon thaik tothun appinappin anaruk mpakannoka nanon appinappin. ");
INSERT INTO lmd_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Akka kwoꞌrot ka kin ngaak ngamutha kwokat cik akwokuccekienthet thocïkkako thin cik. ");
INSERT INTO lmd_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Mpiꞌret non lon ilaik ïcat itti na lon iloporot ongkenettat lin nocapu ncik appik, lon ila pul ipopari pokkothe lerettat cakuruk akin okwarttikothok ngngin.” ");
INSERT INTO lmd_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Opilin ntiakin ithattul ana ikken keꞌra, ipoccot kꞌran itti oIoutha Icikkariuththi poingkanthet ul ittïttïk wonoppan toKapik ");
INSERT INTO lmd_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","akwipittat kin itti, “Ngintha akka annethin amma mpoccokiethenon oIeccuo?” Okin thekathok mallong imallio arrial ana alkaire (30). ");
INSERT INTO lmd_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ncïnang oIoutha pikkatheik akwoꞌrïkot caꞌri ica kwoccokiet kin oIeccuo ngngin. ");
INSERT INTO lmd_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ana nocaꞌri corokït cokamuthe karrakith iella müꞌrükül tit ul iammakot oIeccuo wakkakanthet oIeccuo akin ipittathok itti, “Ngkwongothe itti onïn thathokkinthung cik kartha na athoꞌrkot thuꞌrit thokamuthe koThaurrot kaman kꞌrek cik?” ");
INSERT INTO lmd_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Kwiꞌrekathekin itti, “Noine opaththi anniꞌrethok itti, ‘Pul ipangkene piꞌret itti, Caꞌri ica Kapik konekkenthin cik cakko napuththut. Mpaik pathoꞌrkot thuꞌrit thokamuthe koThaurrot kaman kꞌrek cik ïnoul iammakothin tuan thanang.’” ");
INSERT INTO lmd_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ittina ul iammakothok wokkathe ammakka kwiꞌrethekin itti okin thathokkot akin okkat thuꞌrit thokamuthe koThaurrot kaman kꞌrek cik. ");
INSERT INTO lmd_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Anakka cipin capot, oIeccuo pokat cik akwikkoik othïngkakot kriki kothokkun wothokureokin oul iammakothok iattul ana ikken keꞌra iccik kokuppuꞌrung kothuꞌrit. ");
INSERT INTO lmd_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ana akka okin thokat cik akin oꞌrkoik, kwiꞌrekathekin itti, “Mpiꞌret non lon ilaik ïcat itti opilin ntianon pakeron.” ");
INSERT INTO lmd_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ul iammakothok wakorronno opirakat noka nolon len ana okin thikkatheik akin ipittot oIeccuo lon thuluththuluk itti, “Ili, atti okorronno oka oun?” ");
INSERT INTO lmd_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","OIeccuo pothïathe tit itti, “Okkwi ipanïn thaik thathapettot ngngucul nocaththak culukku uraththut ook akkakeron. ");
INSERT INTO lmd_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ukul wopul iponyi wio ammakka lokurrakot iatham woKapik. Anaruk angkre, nopul ipakero ukul wopul iponyi. Laakat loporot nopul pen amma pokat pakorronno okwonta.” ");
INSERT INTO lmd_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ittina aIoutha okkwi ipathokero oIeccuo iꞌrekat itti, “Pul ipangkene, atti okorronno oka oun?” AIeccuo othïanthok tit itti, “Ïï oung ammakka ngkwiꞌret.” ");
INSERT INTO lmd_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Anakka okin thokat cik akin oꞌrkoik, aIeccuo onekat arrakith, akwopirakanthet Kapik noka akwomithat tit akwekat ul iammakothok akwiꞌrekat itti, “Noneko annoꞌrko, ka kin engki.” ");
INSERT INTO lmd_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Kwonekathe keththeꞌret akwopirakanthet Kapik noka ana kwekathekin ana kwiꞌrekathe itti, “Nïkko nan, onon appik. ");
INSERT INTO lmd_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ngüccük ngin engi ngothonekket lon cik nguntanthet ul cik woppot, othakka itti aKapik occïkïnthet kin lon len ilokithak. ");
INSERT INTO lmd_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mpiꞌret non itti mpakorronno appïkko ngapak attang nciki inenni puccuk acaꞌri akkakat ica anïkko nan unnaththungon ingili ngongappa.” ");
INSERT INTO lmd_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Menik okin thongwathe kinye ana okin thoingkathe thapat nocoꞌrong coCeththun. ");
INSERT INTO lmd_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ittina oIeccuo piꞌrekathekin itti, “Ngkoꞌra engi, onon thaththe naun appik nti ilon ilaik lathokkattathin, ammakka lokurrakot itti Kapik kiꞌret itti, ‘Mpakkwo pul ipuꞌre ana cungkut colungkat capettakot cik appik.’ ");
INSERT INTO lmd_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Anaruk amma mpurokiettat nti ithio, mpaeo noththok poCelïl anon tharthuk ao ana oron thincettot ceneket.” ");
INSERT INTO lmd_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","APoththuruc iꞌrekat itti, “Amma okin thantoththe naung appik anaruk mpakannoththe naung kirrkkir.” ");
INSERT INTO lmd_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","AIeccuo iꞌrekat itti, “Mpiꞌrethung lon ilaik ïcat itti, athakꞌruk tharthuk oo ngkoꞌra engi ngkwacukkwo nolon maꞌri mꞌrapuruk itti ngkwomman.” ");
INSERT INTO lmd_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Anaruk oPoththuruc piꞌrekathe itti, “Mpantio iraththeꞌra, mpakorronno ocukkwo nolon itti mpommang kirrkkir.” Ana ul iammakothok wꞌrek wiꞌrekathe cakuruk menik. ");
INSERT INTO lmd_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ittina oIeccuo poingkathe okin oul iammakothok nokaꞌran koCaccimani ana kwiꞌrekathekin itti, “Nikkoik cene aneo tentre anothaꞌra ngaꞌrama.” ");
INSERT INTO lmd_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Kwipathe oPoththuruc ana nyukul nyeꞌra nyoCepethi ana kwikkatheik akwipo thiak ana kwakorronno okakat poporot noka cannan ana oka pïrrïn noka. ");
INSERT INTO lmd_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Menik kwiꞌrekathekin itti, “Cïkït cin cipot thiak ana mpikkoik ere mpio. Nikkoik cene annoccot kït cik unnaththut.” ");
INSERT INTO lmd_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Kwoingkathe papotteik, akworrekat ka nocapu akweekat toca ncik akwaꞌrakat ngaꞌrama itti, “Ngappa pin, amma laka, anekothin thoccokot thiak enthi. Anaruk okonnoka ammakka mpongothe anaruk ammakka ngkwongothe.” ");
INSERT INTO lmd_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ittina kwopakkanthet ul iammakothok ana kwaththiat kin akin theot inthe. Akwiꞌrekat oPoththuruc itti, “Paththon, onon thakorronno occot kït cik manna papotteik unnaththuri? ");
INSERT INTO lmd_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Nikkoik ngkït thapat annaꞌra ngaꞌrama othakka itti annokorronno apot ithennekketta llon ilokithak. Cïkït congothe itti cakkot lon iloporot anaruk ka kokinyat.” ");
INSERT INTO lmd_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ana kwapproingkat thokaꞌran ken attang akwaꞌrakat ngaꞌrama itti, “Ngappa pin, amma lomma itti ngkwakannonekothin thoccokot thiak enthi ana mpaccokot thiak anaruk aloka ammakka ngkwongothe.” ");
INSERT INTO lmd_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Anakka kwokkaprttakot ntan, kwaththiat kin akin thaik inthe attang akka methe mamoccokothekin cannan. ");
INSERT INTO lmd_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Kwoththekathe nakin attang ana kwoingkathe ana kwaththaꞌrakat ngaꞌrama akwokkat maꞌri mꞌrapuruk, akwopakkukkwet lon ila kwaꞌrat ngaꞌrama ngngin tokït. ");
INSERT INTO lmd_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ittina kwopakkanthet ul iammakothok ana kwiꞌrekathekin itti, “Onon tharthuk thaik inthe ana ongokoi? Nontoccïkot, caꞌri cakko napuththut ana ukul wopul iponyi wakettat ul wolon ilokithak. ");
INSERT INTO lmd_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Nuroko, aron eo akka okkwi ipakerothin ul pei panthan.” ");
INSERT INTO lmd_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Anakka oIeccuo pokat cik akwere, aIoutha okkwi ipokat nti iul iattul ana ikken keꞌra akkakat. Kwokat ponat cungkut coul wonu iꞌrittang iukwit wukwit ana muꞌrang, aul ittïttïk wonoppan toKapik ana ul ittïttïk woul akkothïothekin. ");
INSERT INTO lmd_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","OIoutha ipathokerot ul oIeccuo pappokenet ul lon itti, “Okkwi ipa anomicco ïꞌrïkothok topere, ook pen annoccokothok.” ");
INSERT INTO lmd_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Kwoingkanthet oIeccuo accokkot akwiꞌrekathok itti, “Pul ipangkene, taththa?” akwomiccathok ïꞌrïkothok topere. ");
INSERT INTO lmd_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","OIeccuo pothïanthok tit itti, “Opuruko pin, okkothe ila ngkwainet itti ngkwakkot.” Ittina aul othakkarat iccik kung aꞌrumathok accokathok. ");
INSERT INTO lmd_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Menik apilin nti iul iokat cik ammakot oIeccuo othat kïꞌrïttang ikukwit ana kwokianthet pul iparekine pul iprïk ponoppan toKapik kunu cik. ");
INSERT INTO lmd_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","OIeccuo piꞌrekathok itti, “Opakkethe kïꞌrïttang ikaꞌruk akka okin ithangwo ul nïꞌrïttang iukwit wukwit thille nnïꞌrïttang iukwit wukwit. ");
INSERT INTO lmd_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nthomma itti mpakkaro ongappa akwothïanthin uꞌrupa wothothïlettat woKapik athar woppot accokkot athittarothini? ");
INSERT INTO lmd_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Anaruk lon latham laka ïcat taththa iliꞌre itti elli lonu itti laka ngkathar engki?” ");
INSERT INTO lmd_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Menik aIeccuo iꞌrekat cungkut coul itti, “Mpapul pothuꞌran akka onon thainin niꞌrittang ana muꞌrang itti onon thathoccokothini? Mpikikkot cik appinappin noppan toKapik anongkene ana onon thakannoccokothin. ");
INSERT INTO lmd_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Anaruk elli appik lokkattathe aloka ammakka natham noul wothernte lon loKapik nokurrakot itti laka.” Ittina aul iammakothok opellekat oththe naak. ");
INSERT INTO lmd_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Okkwion ithoccokothe oIeccuo thonekanthok pul iprïk ponoppan toKapik oKiappa na ul iangkene lon lothonceꞌret lon cik ana ul ittïttïk woul wokat waꞌrntakothe. ");
INSERT INTO lmd_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Anaruk oPoththuruc pommakothok nciththan mono oingkat ci ithaꞌrapak thokaman kopul iprïk ponoppan toKapik akwikkat cik okin oul iangwot cik akwokatha itti ngempen akkakaik. ");
INSERT INTO lmd_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ul ittïttïk woul wonoppan toKapik ana cuththun coul woIouth ittïttïk appik wikkatheik akwariccat lon ilakin oruket oIeccuo ngngin ngkarra othakka itti akin okkwothok. ");
INSERT INTO lmd_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ul werekathe lon loppot ngkarra ilakin thorukethok ngngin anaruk okin thakanniat lon ilakin thokat cik akin okwariccat ana ul weꞌra wakkakathe tokït koul ");
INSERT INTO lmd_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ana wiꞌrekathe itti, “Pul empi piꞌret itti, ‘Mpakïtto tupan toKapik ana mpuno nomaꞌri mꞌrapuruk.’” ");
INSERT INTO lmd_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ittina apul iprïk ponoppan toKapik urokat kapik akwiꞌrekat oIeccuo itti, “Ngkwaik pakannothïot ilon elli? Lon lointha elli ila ul enni waik werethung ngngin?” ");
INSERT INTO lmd_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Anaruk oIeccuo pangkatheik. Apul iprïk ponoppan toKapik iꞌrekathok itti, “Antokkwo mio emmi ngkꞌran koKapik ikaik ïcat itti ngkwiꞌret nïn lon ilaik ïcat, iꞌrethenïn amma oung oMiccie, ukul woKapik.” ");
INSERT INTO lmd_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","AIeccuo othïat tit itti, “Laik ammakka ngkwiꞌret. Anaruk mpiꞌret non appik itti, noluput ilanthan onon thimma ukul wopul iponyi aikkoik thokkun wothothari wokkwi ipakorronno alkakot ana anthan aikkoik nonuththe norothiꞌrot.” ");
INSERT INTO lmd_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ittina apul iprïk ponoppan toKapik illillat eret wung akkua ka akwiꞌrekat itti, “Kwocungkot Kapik llon elli. Ngintha akka aron appoꞌrïkïnthet itti oron thappoccïkot lon arttot nan? Onon thoccïkothe akka kwocungkwot Kapik. ");
INSERT INTO lmd_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Onon thiꞌre taththa?” Akin othïat tit itti, “Kwonu itti kwakkuttat.” ");
INSERT INTO lmd_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ittina okin thothukkwathok nguk toca ana okkwekok nattal ana mmüccüt ");
INSERT INTO lmd_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","akin iꞌrethok itti, “Miccie, antina itti oththa akkokkworung?” ");
INSERT INTO lmd_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","OPoththuruc pokat cik akwikkoik ithaꞌrapak thokaman kopul ponoppan toKapik iprïk aukul iareko cïnang iopari akkakanthok aiꞌrekat itti, “Oung cakuruk pokat cik onnoIeccuo poCelïl.” ");
INSERT INTO lmd_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Anaruk oPoththuruc pocukkwathe nan tokït ken appik. Akwiꞌre itti, “Mpomma lon ila ngkwaik peret.” ");
INSERT INTO lmd_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ana kwoingkathe icürük cothapat na ukul wꞌrek iareko iopari wimmakathok ana wiꞌrekathe ul iokat cik cïnang itti, “Pul empi pokat cik okin oIeccuo poNaccir.” ");
INSERT INTO lmd_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ana oPoththuruc papprocukkwat nan ana kwarrmakathe itti, “Mpomma pul pen.” ");
INSERT INTO lmd_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ana papotteik, okin ithokat cik akin ocoꞌro cïnang thakkakanthet oPoththuruc akin iꞌrekathok itti, “Oung ïcat nti iakin akka kathar ika ngkwaik pere ngngin ka kene itti onon thaik naththut.” ");
INSERT INTO lmd_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ittina kwikkatheik akwonane ka kung thattatta ana kwarrmakanthet kin itti, “Mpomma pul pen.” Ncïnang athakꞌruk oat. ");
INSERT INTO lmd_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ittina aPoththuruc okwarikat lon ila aIeccuo paperet itti, “Athakꞌruk tharthuk oo, ngkwacukkwo nan itti ngkwomman maꞌri mꞌrapuruk.” Ana kwoingkathe thapat ana kwikkatheik akwoo thiak thiak. ");
INSERT INTO lmd_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ana ngorrot ngïꞌrïmak, aul ittïttïk appik wonoppan toKapik ana ul ittïttïk woul akkakat akin ïꞌrïkat lon itti okin thakkwot oIeccuo. ");
INSERT INTO lmd_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ittina akin ïꞌrïkïkkathok akin onekathok akin ekathok oPilaththoc ipokat ili wonoththok poIouthia. ");
INSERT INTO lmd_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Anakka oIoutha ipokerot oIeccuo pimmat itti oIeccuo pakkmakot, kwopakkekathe cïkït ana kwaththiat itti lon ila kwokkothe lokithak, kwoprttathe lon cik ana kwopakkekanthet ul ittïttïk woul wonoppan toKapik ana ul ittïttïk woul mallong imallio imokat arrial ana alkaire. ");
INSERT INTO lmd_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ana kwiꞌrekathe itti, “Mpokkothe lon ilokithak akka mpokerot pul ipakannokkot lon lꞌrek ilokithak ana paik pathokkuttat.” Akin othïanthok tit itti “Onïn thella kït ken. Oung akkonu lon len ikkun.” ");
INSERT INTO lmd_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","AIoutha orrekat akucci noppan toKapik akwoingkat thapat akwïꞌrïkat thoꞌrak nopira akwokarthat calak cung nthoꞌrak akwiat aꞌriko nopira. ");
INSERT INTO lmd_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Aul ittïttïk woul wonoppan toKapik onekat akucci akin iꞌrekat itti, “Akucci enni weettathe pul othakka itti apokkwot pangken ana ittina lon lothonceꞌret lon cik lonnon lakannangkot itti wanekkettat tothun ittit pakucci worupan toKapik.” ");
INSERT INTO lmd_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ittina okin thïꞌrïkathe lon itti akucci enni akin okero ngkopon kopul ipakkot api akin ocïkkaro ul tit wokwaat. ");
INSERT INTO lmd_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ana ilen akka okin thocciekanthet kaꞌran itti, kopon koÜccük manna inenni. ");
INSERT INTO lmd_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ittina alokakat ammakka pul pothernte lon loKapik Armia papperethe itti, “Okin thonekathe mallong imallio arrial ana alkaire, ncekerek ica ul woIccereil wonekkenthok cik, ");
INSERT INTO lmd_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","itti okin thakero kopon kopul ipakkot api ammakka Ili wawiꞌrethin.” ");
INSERT INTO lmd_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Anakka oIeccuo pocoꞌrot tokït koili oPilaththoc, aili ipittathok itti, “Oung Ili woIouthi?” AIeccuo othïat tit itti, “Laik ammakka ngkwiꞌret.” ");
INSERT INTO lmd_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ul ittïttïk wonoppan toKapik ana ul ittïttïk woul wokat arukwet oIeccuo llon loppot anaruk kwakanniꞌrekat kin lon lꞌrek. ");
INSERT INTO lmd_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","APilaththoc ipittathok itti, “Ngkwakannoccïkot lon elli ilakin thaik tharukwethung ngngini?” ");
INSERT INTO lmd_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Anaruk oIeccuo pakannothïanthok tit llon lꞌrek aththik, oPilaththoc oprttakat tit cannan. ");
INSERT INTO lmd_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ittina thathuma thokat cik oPilaththoc itti kwelikkine ul pul pulukku nti ikorrkkor ipa ul wongothe itti pelikkako nocaꞌri cokamuthe koThaurrot kaman kꞌrek cik. ");
INSERT INTO lmd_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ana caꞌri cen okin thonat pul ikorrkkor ipinakot cannan itti pokithak poccot kꞌran itti oParapac. ");
INSERT INTO lmd_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ana cungkut coul caꞌrntakathe tothun aPilaththoc ipittat kin itti, “Oththa akka onon thongothe itti mpelikkinenon nti iul enni, oParapaci ana amma okorronno oka ook oIeccuo iponu kꞌran itti oMicciei?” ");
INSERT INTO lmd_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ana oPilaththoc pappina kicce itti ul ittïttïk wonoppan toKapik ana ul ittïttïk woul woIccereil, wokat wonanok oIeccuo akka okin thaththonyiranok. ");
INSERT INTO lmd_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Anakka oPilaththoc pokat cik akwikkoik toprrok poili pothakkma akwokathacce lon len, opari pung pothïanthok thon itti, “Kirrnni okkot lon lꞌrek nopul emprïk ipella lon cik ila kwokkothe lokithak akka mporekot thiak maman ngkoꞌra anathantakothok.” ");
INSERT INTO lmd_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Anaruk ul ittïttïk woul wonoppan toKapik ana ul ittïttïk woul werekekathe ul itti okin thipitto oParapac akwelikkakinekin, aIeccuo okkuttat. ");
INSERT INTO lmd_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","APilaththoc ipittat cungkut coul itti, “Oththa akka onon thongothe itti mpelikkinenon nti iul enni weꞌra?” Akin othïat tit itti, “OParapac.” ");
INSERT INTO lmd_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","APilaththoc ipittat kin itti, “Ngintha akka anokkot naIeccuo ipoccot kꞌran itti oMiccie?” Akin othïat tit appik itti, “Nokkwethok nothapak.” ");
INSERT INTO lmd_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","APilaththoc iꞌrekat itti, “Akaintha? Ngintha akka kwokkothe pokithak?” Anaruk okin thiꞌrekathe appik mpoꞌre cittan cannan itti, “Nokkwethok nothapak.” ");
INSERT INTO lmd_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Anakka oPilaththoc pimmat itti lella ila akwokkot ana camutta cokat acuroko, kwonekathe ngꞌri ana kwilakkathe nyaun tokït koul appik. Ana kwiꞌrekathe itti, “Mpella lon ikkun lothokkwot pul empi, onon akkonu lon ikkun.” ");
INSERT INTO lmd_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Aul othïat tit appik itti, “Kirrnni alon lothio thung oka nanïn ana nonyukul nyïn.” ");
INSERT INTO lmd_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ittina kwelikkanthet kin oParapac. Anaruk kwiꞌrekathe itti oIeccuo papoko kicce akwettakat ul irro akin othokkwethok nothapak. ");
INSERT INTO lmd_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ittina ul irro woPilaththoc wonekathe oIeccuo nokaꞌran koili ikrïk na ul irro wokat cik ana waꞌrntakathe appik iccik koIeccuo. ");
INSERT INTO lmd_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ana okin thuekathe oIeccuo eret noka ana okin thakiekathok kret kꞌrek koꞌre konili noul irro, ");
INSERT INTO lmd_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ana okin thotherathe tukwia tolï, akin akiekathok ica. Okin thonekkekanthok kurrong ikkun wothothari akin eekat ungku ncik tokït kung akin okkothok ngure ngngin. Akin iꞌre itti, “Ili woIouth, taththa.” ");
INSERT INTO lmd_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ana okin othukkwothok nguk ana okin thonekathok kurrong akin ikkat cik akin okkwekok ngngin ica. ");
INSERT INTO lmd_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Anakka okin thokkothok ngure ngngin, akin uekathok kret konili noul irro akin opakkekanthok eret wung noka. Ittina okin thipathok akin othokkwethok nothapak. ");
INSERT INTO lmd_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Anakka okin thokat cik akin eo, akin ocurat ipul pꞌrek ponokaꞌran koKirin poccot kꞌran itti oCcamaan ana okin thonekiekathok thapak thoIeccuo mpuꞌran. ");
INSERT INTO lmd_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Okin thakkakathe nokaꞌran ikoccot kꞌran itti Culucutha (ilonu itti kaꞌran kokꞌrintil koca). ");
INSERT INTO lmd_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ana nokaꞌran ken akin eekat oIeccuo ngapak ngocikittakot naꞌrupu wꞌrek wopun aapiet ka ikakꞌrellok cik, anaruk akka oIeccuo pinothe, akwꞌrakat ïkko. ");
INSERT INTO lmd_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Anakka okin thokkwethok nothapak, akin illillat iret wung nthokkwarot moꞌrio. ");
INSERT INTO lmd_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ana ul irro wikkatheik nocapu akin angwothok nothapak. ");
INSERT INTO lmd_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ana toꞌra woIeccuo nothapak, okin thaꞌrekathe lon ilokurrakot ilakin thorukwethok ngngin itti, OIECCUO EMPI ILI WOIOUTH. ");
INSERT INTO lmd_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ana ul wothuꞌran weꞌra wakin thokkwethe nothapak akin oIeccuo cakuruk, apꞌrek nthokkun wothothari ana apꞌrek nthokkun wothokure. ");
INSERT INTO lmd_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ul iokat cik akkette aꞌrupu cïnang wikkatheik aꞌrïntïtto ma ana ocungkwok, ");
INSERT INTO lmd_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","akin iꞌre itti, “Oung ipaik pathokïtto tupan toKapik aunat maꞌri mꞌrapuruki? Oꞌrethe ka kang. Orpu ntan nothapak amma oung ukul woKapik.” ");
INSERT INTO lmd_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ana menik cakuruk ul ittïttïk woul wonoppan toKapik ana ul iangkene lon lothonceꞌret lon cik ana ul ittïttïk woul wikkatheik akkothok ngure ngngin. ");
INSERT INTO lmd_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Akin iꞌre itti, “Kwoꞌrethe opilingon anaruk kwakannoꞌret ka kungi? Amma ook Ili woIccereil, akworpo ntan nothapak inenni ana oron thaccokot lon lung nomïkït. ");
INSERT INTO lmd_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Kwonekkethe cïkït nolon loKapik, kirrnni aKapik oꞌrethok inenni amma kongothok akka kwiꞌret itti, ‘Oun ukul woKapik.’” ");
INSERT INTO lmd_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ana menik cakuruk ul wothuꞌran iarokat cik wokkwettathe nothapak akin aththut wikkatheik acungkwok. ");
INSERT INTO lmd_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Anakka cïngkï angko ippa, ngïꞌrïmak ngoꞌratheik nocapu ncik appik puccuk mono acïngkï okkat cꞌrapuruk. ");
INSERT INTO lmd_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Anakka cïngkï cokkothe cꞌrapuruk cocipin, oIeccuo pakkarathe mpoꞌre cittan itti, “Eli, Eli, lama capakththani?” ilonu itti, “Kapik kin, Kapik kin, ngintha akka ngkwoththenet naun?” ");
INSERT INTO lmd_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Anakka okkwion ithokat cik akin ocoꞌro cïnang thoccïkothe lon len akin iꞌrekat itti, “Kwaik pakkaro oIlia.” ");
INSERT INTO lmd_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ana accokkot apilin ntiakin ollat akwothonakat kret akwothapekat ngngapak ingor akwonekkekat nokwoꞌren ana kwonekkakathenthet oIeccuo tothon itti kwïkko. ");
INSERT INTO lmd_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Apilingon iꞌrekat itti, “Antocoꞌro aron okatha amma oIlia anthan akwathoꞌrethok.” ");
INSERT INTO lmd_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ana oIeccuo pappakkarat mpoꞌre cittan attang akwommottakat. ");
INSERT INTO lmd_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Menik akret ikapettoik konoppan toKapik illakat tit mprak weꞌra, ncik toꞌra mono uat ciki nocapu. Ana capu cikkatheik acoꞌrïntïttako ana amothok ongatta ntopangken. ");
INSERT INTO lmd_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ana nupu noul illet nanyettekathe ana ka koul iupupure woKapik kurokiettakathe nti ithio koppot. ");
INSERT INTO lmd_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Anakka oIeccuo purokot nti ithio, okin thoppathe thapat nti inupu ana okin thoingkathe nokaꞌran ikupupure koUruccelim, akin ummanthet ul ncik woppot. ");
INSERT INTO lmd_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Anakka ili woul arrial ukuluk irro (100) ana okkwion ithokat cik akin angwot oIeccuo thimmat akka capu coꞌrïntïttakot ncik ana lon ilokkattathe appik, okin thipathe nꞌre akin iꞌrekat itti, “Ïcat okat ukul woKapik enni.” ");
INSERT INTO lmd_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ul iari wokat cik than woppot iokat wommakathe oIeccuo noththok poCelïl aittarothok, wokat cik akathacceik nciththan. ");
INSERT INTO lmd_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Opilingon ntiakin thokat oMeriom moMacthelia, ana oMeriom onnan poIakup ana oIuccip, ana onnan ponyukul nyoCepethi. ");
INSERT INTO lmd_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Anakka cipin capot, apul pꞌrek akkakat papaꞌrthan poccot kꞌran itti oIuccip ponokaꞌran koRami ipokat pul ipammakot oIeccuo. ");
INSERT INTO lmd_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Kwoingkanthet oPilaththoc ana kwipittathok kumi koIeccuo ana oPilaththoc pothïathe lon itti okin thethet oIuccip kumi. ");
INSERT INTO lmd_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ana oIuccip ponekathe kumi koIeccuo ana kwoꞌremethekathe ngkret ikie kothocïkkarako ngngin ");
INSERT INTO lmd_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ana kwaththocïkkat ippu irie irapaꞌrathang pocuꞌrol ira kwappokkinthet ka kung ana kwothïathe kaꞌraccak icürük coppu ana kwoingkathe. ");
INSERT INTO lmd_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","OMeriom moMacthelia ana oMeriom mꞌrek, thokat cik akin ikkoik akin oprttakot iccik korupu. ");
INSERT INTO lmd_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ana ngorrot ngen nocaꞌri icokat caCcepith, ul ittïttïk woul wonoppan toKapik ana ul woPriccin akkakanthet oPilaththoc. ");
INSERT INTO lmd_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Akin iꞌrekat itti, “Ili, onïn thokwarikothe lon ila okkwi ipammikkarot piꞌret akka kwokat cik ngkït thapat itti, ‘Mpuroko nti ithio amma mpokkothe maꞌri mꞌrapuruk ippu.’ ");
INSERT INTO lmd_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ittina othïothe thon aul othangwot tupu puccuk amaꞌri okkat mꞌrapuruk. Othakka itti aul iammakothok okorronno omunyek nti ippu akin omekat ul itti pul pen purokiettat nti ithio. Akarra ken okakat kokithat cannan nakorokït.” ");
INSERT INTO lmd_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ittina aPilaththoc iꞌrekat kin itti, “Noneko ul iangwot cik anneo thoppu annokkot tupu kicce othakka itti arokorronno anyattat.” ");
INSERT INTO lmd_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Menik okin thoingkathe ana okin thaththunukkat tupu kicce ana okin thonekkekathe ul cik iangwot tupu. ");
INSERT INTO lmd_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Anakka caꞌri caCcepith ceot ncik ana ngïꞌrïmak nocaꞌri corokït nomaꞌri imeꞌreꞌrapuruk oMeriom moMacthelia ana oMeriom mꞌrek thoingkathe akin othokatha tupu. ");
INSERT INTO lmd_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ana capu cikkatheik acaꞌrïntïttako ncik appik ana uꞌrupa wothothïlettat woIli wakkakathe ntan ntothiꞌrot aingkat noppu ana wopaꞌrekathe kaꞌraccak cik ntoppu ana wikkatheik nokaꞌraccak. ");
INSERT INTO lmd_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ana toca tung tokat cik arollio ere kꞌran kothuleꞌrak thokapik ana eret wung wokat wipuk ippuk ere paꞌra. ");
INSERT INTO lmd_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ana ul iokat cik angwot tupu wipathe nꞌre aikkat cik akkwe ka akin apukkat ka ntit aikkat cik ere ul illet. ");
INSERT INTO lmd_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ittina auꞌrupa wothothïlettat woKapik iꞌrekat ul iari itti, “Nokorronno ipo nꞌre akka mpina itti onon thaik thakwariccat oIeccuo ipokkwettathe nothapak. ");
INSERT INTO lmd_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Kwella cene, kurokiettat ammakka kwappiꞌret. Nanthan annathokatha kaꞌran na kwappïcettatheik. ");
INSERT INTO lmd_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ittina ngkonon cokoccokot annothiꞌret ul iammakothok itti, ‘Kurokiettat nti ithio ana kwaik paeo noththok poCelïl akin tharthuk eo. Ana onon thimmathok than.’ Mpei piꞌrethenon.” ");
INSERT INTO lmd_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ana ul iari wiꞌrikittakathe nthoppu nnꞌre ana nthopira noka ana okin thollathe akin othiꞌrekat ul iammakothok. ");
INSERT INTO lmd_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","AIeccuo ocurat iakin accokkot akwommiccat kin akin occokathok tacok akin ekat ungku ncik tokït kung akin aꞌrakanthok ngaꞌrama. ");
INSERT INTO lmd_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ittina aIeccuo iꞌrekat kin itti, “Nokorronno ipo nꞌre. Ngkonon annothiꞌret opangkingon itti akin eo noththok poCelïl nakin othimmathin.” ");
INSERT INTO lmd_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Anakka ul iari wokat cik ikathar aeo atherene ul iammakot oIeccuo, ul wꞌrek irro iangwot tupu woingkathe nokaꞌran koUruccelim ana okin thaththerekanthet ul ittïttïk woul wonoppan toKapik lon appik ilokat cik. ");
INSERT INTO lmd_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Anakka ul ittïttïk woul wonoppan toKapik wikkot cik okin oul ittïttïk woul, okin thïꞌrïkathe lon cik itti okin thethet ul irro akucci woppot. ");
INSERT INTO lmd_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Akin iꞌret kin itti, “Onon thonu itti onon thiꞌret ul itti, ‘Ul iammakot oIeccuo waat ngkoꞌra ana okin thomunyet kumi anïn thokat inthe.’ ");
INSERT INTO lmd_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Amma lon elli loinet oPilaththoc, onïn therenok anïn oꞌret non nti ilon ilokithak.” ");
INSERT INTO lmd_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ul irro woccathe akucci ana okin thiꞌrekathe lon ilakin thiꞌrettathe itti okin thiꞌre. Ana lon len likkatheik alopettakot cik iul woIouth manna inenni. ");
INSERT INTO lmd_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ittina ul iammakot oIeccuo iattul ana ikken culukku (11) woingkathe tocoꞌrong noththok poCelïl na aIeccuo pappiꞌrethekin itti okin thaeo. ");
INSERT INTO lmd_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Anakka okin thimmarok, akin aꞌrakanthok ngaꞌrama anaruk opilingon thonat lon leꞌrarit. ");
INSERT INTO lmd_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","OIeccuo pothakkarathe iccik ken akwiꞌrekat kin itti, “Ongappa pethin ngili ikkun appik ngolon lorothiꞌrot ana lonocapu. ");
INSERT INTO lmd_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ana ittina ngkonon noul nocapu appik ana annongkenekin othakka itti akin othakka ul immakothin. Annikkekat kin mamuthie ngkꞌran kongappa ana kokkul wung ana koKanang ikupupure, ");
INSERT INTO lmd_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ana annongkenekin itti okin thaccïkot lon appik ila mpiꞌrethenon. Nina nan itti mpakaik nanon appinappin puccuk aluput ocothakat.”");
INSERT INTO lmd_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Thokuꞌre lon ncik tholon iloporot loIeccuo oMiccie, ukul woKapik. ");
INSERT INTO lmd_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Lokurrakot iatham woIccaia pul pothernte lon loKapik itti, “Mpathïot pul pothothïlettat pin tokït kang, ook ipathokuccenthung kathar cik.” ");
INSERT INTO lmd_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Poꞌre popul paik pakkakkaro nti ithampang itti, ‘Nokuccenthet Ili kathar cik, noceꞌrenthok athar cik.’” ");
INSERT INTO lmd_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ittina oIuanna pomamuthie pakkakathe akwikket ul mamuthie ithampang ithonthomat ana akwongkene ul lon lomamuthie mothokkaprttako nti ilon ilokithak ana thoccïkarnthet lon ilokithak. ");
INSERT INTO lmd_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ana nci cïnang ul wonoththok poIouthia appik ana wonokaꞌran koUruccelim woingkanthok, ana okin thokat akin itto lon len ilokithak akin occo mamuthie nti ikkun wung norue toÜrüthün. ");
INSERT INTO lmd_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","OIuanna pakukkot eret wokkattathe norua tothamla ana ïꞌrïkakot kuꞌrat ikin ana kwokat cik akwïkïkko aun ana oꞌrko kat. ");
INSERT INTO lmd_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ana akwerene ul itti, “Pul paik panthan ponu puꞌran prïk naun ana mpakannekko nan manna itti mpee ungku ncik tokït kung anokꞌro loꞌrak lowok wung. ");
INSERT INTO lmd_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Mpethet non mamuthie ngngꞌri, anaruk kwathethet non ngKanang ikupupure.” ");
INSERT INTO lmd_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ana nomaꞌri men oIeccuo pakkakathe nnokaꞌran koNaccir noththok poCelïl, ana oIuanna pekathok mamuthie irue toÜrüthün. ");
INSERT INTO lmd_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Anakka oIeccuo pokat cik akwoppot thapat nti iꞌri, akwimmakat tothiꞌrot attanyattatheik ana Kanang ikupupure akorpot cik naak karkko cülükkür. ");
INSERT INTO lmd_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ana poꞌre pakkakathe nci tothiꞌrot apiꞌre itti, “Oung ukul win, ia mpongothe ana mpopiranet noka.” ");
INSERT INTO lmd_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Nci cïnang Kanang koKapik kothïathok ithampang ithonthomat, ");
INSERT INTO lmd_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ana kwikkatheik than maꞌri arrial weꞌra (40), apul pothopulut ennekkek, ana kwokat cik naꞌrupu woripira ana uꞌrupa wothothïlettat woKapik wakkakathe ana wittarathok. ");
INSERT INTO lmd_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Manakka oIuanna ponekkettathe ikorrkkor, oIeccuo poingkathe noththok poCelïl, akwongkene ul lon iloporot loKapik. ");
INSERT INTO lmd_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Kwiꞌrekathe itti, “Caꞌri caat ana ngili ngoKapik ngakko napuththut ana nthapaꞌrine lon ilokithak cik annoccokot lon loKapik iloporot.” ");
INSERT INTO lmd_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Anakka oIeccuo pokat cik akwokko nokuthut korok irapangka toCelïl, akwimmakat oCcamaan ana opang Anthrauc akin orre loꞌrok lape irok irapangka, akka okin thokat ul iacciccokot ape. ");
INSERT INTO lmd_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ana oIeccuo piꞌrekathekin itti, “Nanthan, annomakothin ana mpathikkienon ul iacciccokot ul ionyi.” ");
INSERT INTO lmd_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Akin oththekat noloꞌrok len lape akin omakathok accokkot. ");
INSERT INTO lmd_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Anakka kweot papotteik, akwimmakat oIakup ukul woCepethi ana opang oIuanna akin thokat cik ikuppuꞌrung konoiꞌri akin okuccet loꞌrok len cik lape. ");
INSERT INTO lmd_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ana kwakkarathekin cokoccokot ana okin thoththekathe naththan pen oCepethi ikuppuꞌrung konoiꞌri okin oul iporekinok ana okin thomakathe oIeccuo. ");
INSERT INTO lmd_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ana okin thoingkathe nokaꞌran koKapprnaum, anakka caꞌri caCcepith caat, oIeccuo poingkathe nocuththun caꞌrama ana kwikkatheik akwongkene ul. ");
INSERT INTO lmd_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ana ul wokat cik aprttakinthet thongkene thung tit, akka kwangkenekin ere pul iponu ngili, annoka ammakka ul iangkene lon lothonceꞌret lon cik. ");
INSERT INTO lmd_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ittina apul pꞌrek akkakat nocuththun caꞌrama iponat uꞌrupa iokithak apiꞌrekat lon mpoꞌre cittan itti, ");
INSERT INTO lmd_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Ngintha akka akkot nanïn, Ieccuo poNaccir? Ngkwaat itti ngkwathongwo nïni? Mpina itti oung okkwen, oung ipupure poKapik.” ");
INSERT INTO lmd_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ncïnang aIeccuo othirriekathok cik akwiꞌrekathok itti, “Angkik, oppothe thapat nti iaak.” ");
INSERT INTO lmd_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Uꞌrupa iokithak wolliekathe pul ikapa ana wekathe poꞌre cittan ana woppathe thapat nti ipul. ");
INSERT INTO lmd_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ul appik woprttakatherit, ana okin thikkatheik akin ipittarot itti, “Nginthappu empi? Thongkene enthi thie ana ngngili. Akka manna kwangkie uꞌrupa iokithak cik, accïkathok.” ");
INSERT INTO lmd_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Alon lung opettakat cik noththok poCelïl appik. ");
INSERT INTO lmd_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Manakka oIeccuo ana ul wung thoththet nocuththun caꞌrama, okin thoingkathe akin oIakup ana oIuanna thoCcamaangon ana thAnthraucon. ");
INSERT INTO lmd_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ana opïthe poCcamaan iopopari pokat iaꞌrangkal akkwongo akwangko ippa, ana okin therekanthet oIeccuo lon lung. ");
INSERT INTO lmd_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ana oIeccuo poingkanthok akwoccokathok ukun akurokiekathok kapik. Lü lopaꞌratheik nti iaak ana kwikkatheik akwokkinthet kin thuꞌrit. ");
INSERT INTO lmd_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ana cipin cen akka cïngkï corungkot, ul wonakanthet oIeccuo ul iongo appik ana ia uꞌrupa iokithak woꞌrot nan. ");
INSERT INTO lmd_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ul wonokaꞌran appik waꞌrntakathe tocürük, ");
INSERT INTO lmd_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ana oIeccuo pittiekathe ul iongat mmio kurekkurek. Kwokïccekathe uꞌrupa iokithak woppot anaruk kwakanno okorronnat uꞌrupa iokithak itti were akka okin thinat itti ook okkwen. ");
INSERT INTO lmd_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ana ingïꞌrïmak nothuput thorrot akka cik cokat carthuk okatto, oIeccuo purokathe nti inthe ana kwoththekathe nokaman ana kwoingkathe nokaꞌran pellek na kwaththaꞌrat ngaꞌrama. ");
INSERT INTO lmd_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ana oCcamaan ana opurukon thoingkathe akin othokwariccathok. ");
INSERT INTO lmd_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Manakka okin thiothok akin iꞌrekathok itti, “Ul appik waik wakwariccathung.” ");
INSERT INTO lmd_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","OIeccuo pothïanthet kin tit itti, “Ntun anteo nocik cꞌrek iccik kokaman ikaik cene anothongkene ul than cakuruk akka ilen akka mpainet.” ");
INSERT INTO lmd_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ittina kwoingkathe noththok poCelïl appik akwongkene ul nomuththun maꞌrama. Ana akwokïcce uꞌrupa iokithak nti iapilingon. ");
INSERT INTO lmd_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Apul pꞌrek akkakanthok ponat ïnyï noka apeekat ungku ncik apipittathok itti, “Amma oung akkongothe ana ngkwittiethin.” ");
INSERT INTO lmd_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","OIeccuo pipathe thiak thung akwothiekat ukun akwothntat pul akwiꞌrekat itti, “Mpongothe itti mpittiethung, othakka poporot.” ");
INSERT INTO lmd_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Nci cïnang aïnyï ittakat accokkot ana kwothakkakathe poporot. ");
INSERT INTO lmd_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","OIeccuo pothïathok ikathar llon lonthomat akwiꞌrekathok itti, ");
INSERT INTO lmd_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Amma ngkweot akorronno iꞌret pul pꞌrek lon elli. Anaruk ngko athokene pul ponoppan toKapik ka kang, akiat papu pothokiot ngüccük cik ammakka oMucca piꞌret akenekin itti ngkwothakkat poporot.” ");
INSERT INTO lmd_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Anaruk kwoingkathe ana kwikkatheik akwere nuthuk ana opettot lon cik ana ittina oIeccuo pommakathe iꞌriko icarak coman ncinokkït anaruk kwikkatheik thomnther. Ana ul wokat cik warthuk aukkwinok nci nomoꞌrong ammakka maik. ");
INSERT INTO lmd_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ana nomaꞌri motte akka oIeccuo popakkothe attang nokaꞌran koKapprnaum, ul woccïkathe itti kwokkaprttakot ntan tuan. ");
INSERT INTO lmd_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ittina ul wakkakathe tocürük woppot ana cik cellakathe icokwentakot manna nocürük thapat. Ana kwikkatheik akwongkenekin. ");
INSERT INTO lmd_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ana ul wꞌrek iomura wocoꞌrin wakkakathe anneko pul ipakimico ana wonakanthok. ");
INSERT INTO lmd_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Okin thakanniat kathar ikakin onekkethok ngngin tokït koIeccuo akka ul wokat cik woppot ana okin thanyathe man ntoꞌra akin orpekat pul naꞌrangkal ia kwokat cik akwïcat cik nan tokït koIeccuo. ");
INSERT INTO lmd_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Anakka oIeccuo pimmat thoccokot tholon loKapik nomïkït men akwiꞌrekat pul ipakimico itti, “Ukul, lon lang ilokithak loccïkakothe.” ");
INSERT INTO lmd_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ana ul wꞌrek iangkene lon lothonceꞌret lon cik wokat cik aikkoik cïnang akin eret nomïkït men itti, ");
INSERT INTO lmd_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Pul empi pontha akka apere ittina? Kwaik pacungkwoik, pul pella ipaccïkïnthet ul lon ilokithak, Kapik kulluk akkaccïkot.” ");
INSERT INTO lmd_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","OIeccuo pinakathe nolon len ngka kung accokkot ilakin thokat cik akin okwarttikot nomïkït men ana kwiꞌrekathekin itti, “Ngintha akka annokwarttikinthet lon elli ittina? ");
INSERT INTO lmd_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Lon liatha akkoporot, itti mpiꞌret pul ipakimico itti, ‘Lon ilokithak lang loccïkakothe,’ ana amma okorronno oka menik mpiꞌre itti, ‘Urokothe kapik aneko aꞌrangkal wang aeoi’? ");
INSERT INTO lmd_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Anaruk elli othakka itti annina itti ukul wopul iponyi wonu puꞌran nocapu itti waccïkïnthet ul lon ilokithak.” Kwiꞌrekathe pul ipakimico itti, ");
INSERT INTO lmd_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Mpiꞌrethung itti, urokothe kapik aneko aꞌrangkal wang aeo tuan.” ");
INSERT INTO lmd_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Menik apul ipakimico urokat kapik aponekat aꞌrangkal wung apoingkat thapat tokït ken appik. Elli loprttakiekathekin tit ana okin thopirakanthet Kapik noka akin iꞌre itti, “Onïn thakinnimma lon caꞌri cꞌrek ammakka elli.” ");
INSERT INTO lmd_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Caꞌri cꞌrek cakuruk aIeccuo oingkat iccik korok. Acungkut coul akkakanthok ana kwikkatheik akwongkenekin lon loKapik. ");
INSERT INTO lmd_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Anakka kwokat cik akweo, kwimmakathe oLaui ukul wAlappaoc aikkoik nokaꞌran koul iaꞌrntinthet nili akucci. AIeccuo iꞌrekathok itti, “Omakothin.” Ana oLaui purokathe kapik ana kwomakathok. ");
INSERT INTO lmd_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Anakka oIeccuo pokat cik akwoꞌrkoik thoLauion, ul woppot iaꞌrntinthet nili akucci ana ul wolon ilokithak wokat cik akin oꞌrkoik okin oIeccuo ana ul iammakothok, ana ul wꞌrek wokat cik woppot ammakathok. ");
INSERT INTO lmd_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Anakka ul iangkene lon lothonceꞌret lon cik woPriccin wimmarok akwoꞌrkoik nnul wolon ilokithak ana ul iaꞌrntinthet nili akucci, okin thipittathe ul iammakothok itti, “Kwontha akka akwoꞌrkoik okin oul wothaꞌrntinthet nili akucci ana ul wolon ilokithak?” ");
INSERT INTO lmd_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Anakka oIeccuo poccïkothe elli, kwiꞌrekathekin itti, “Annoka ul ioporot akkongothe itti wittiettat anaruk ul iongo. Mpakannao anathakkaro ul ioporot mpainet ul wolon ilokithak.” ");
INSERT INTO lmd_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ul iammakot oIuanna pomamuthie ana ul woPriccin wokat wocoꞌrot nothuꞌrit. Anaruk ul wꞌrek wakkakathe ana wipittathe oIeccuo itti, “Ngintha akka ul iammakot oIuanna pomamuthie ana ul woPriccin wocoꞌrinet nothuꞌrit ana ul iammakothung wakannocoꞌro nan?” ");
INSERT INTO lmd_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","AIeccuo othïat tit itti, “Opurukon thopul ipipo thacoꞌro nothuꞌrit taththa apul ipipo paik iakin? Okin thakannocoꞌro nothuꞌrit akka pul ipipo paik ithoꞌrkït then. ");
INSERT INTO lmd_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Anaruk caꞌri canthan ica pul ipipo onekitta nti ithoꞌrkït then akin antocoꞌro nothuꞌrit. ");
INSERT INTO lmd_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Pul pella pakkwo kret ikïpe cït nthan ngkret ikie. Amma kwokkothe menik kret ikie ikokkuttat cït nthan killo pangken ipïpe akokkat cürük cïttïk. ");
INSERT INTO lmd_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ana pul pella pipot thrupa ikaꞌruk ikïpe. Amma kwipotherit ana thinya ana thillo kaꞌruk ana kakittako. Kwonu itti kwipot thrupa ikaꞌruk ikie.” ");
INSERT INTO lmd_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Caꞌri cꞌrek cokat cik caCcepith aIeccuo pokat cik akwokko ikkwon komïl, anakka ul iammakothok wokat cik appo ikkwon okin aththut, wikkatheik acottot mïl aꞌrko. ");
INSERT INTO lmd_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ul woPriccin wiꞌrekathok itti, “Antokatha, ngintha akka akin okkinthet lon ilonu itti lakannokkattat nocaꞌri caCcepith?” ");
INSERT INTO lmd_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","AIeccuo othïanthet kin tit itti, “Onon thakannakkakkaro lon nti atham ileret lon ila aThauth pappokkothe okin oul wungi akka okin thokat thongothe itti okin thaꞌrko thuꞌrit akka okin thokat thiamari? ");
INSERT INTO lmd_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Nomaꞌri mApiththar pul iprïk ponoppan toKapik akka oThauth piꞌrikot noppan toKapik ana kwoꞌrkkathe arrakith iothun iettathe Kapik iokat itti ul wulluk wonoppan toKapik akkaꞌrko, ana kwekathe ul wung cakuruk ana woꞌrkkathe.” ");
INSERT INTO lmd_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ittina aIeccuo iꞌrekat kin itti, “Caꞌri caCcepith colekkattanthet pul iponyi cik, okonnoka pul iponyi akkolekkattanthet caꞌri caCcepith cik. ");
INSERT INTO lmd_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ittina ukul wopul iponyi akka Ili wocaꞌri caCcepith.” ");
INSERT INTO lmd_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ana caꞌri cꞌrek, aIeccuo oingkat nocuththun caꞌrama ana pul pokat cik than ponat ukun waiꞌrilla. ");
INSERT INTO lmd_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Aul wꞌrek woPriccin ikkat cik akin okwancot lon ilakin orukwet oIeccuo ngngin, akin ikkat cik akin occot kït naak amma akwittiethok nocaꞌri caCcepith. ");
INSERT INTO lmd_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","OIeccuo piꞌrekathe pul iponat ukun waiꞌrilla itti, “Urokothe kapik tokït koul.” ");
INSERT INTO lmd_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ittina aIeccuo ipittat kin itti, “Lon liatha akkocoꞌrotheik itti lakkattat nocaꞌri caCcepith, okkot lon iloporori? Ana amma okorronno okkot iloporot, okkot ilokithaki? Okkie thikkoik ciki? Ana amma okorronno okkie cik, okkwori?” Anaruk okin thangkatheik. ");
INSERT INTO lmd_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Kwokathakathekin akua ka nolon lothonthoma ma then. Ana kwiꞌrekathe pul itti, “Othie ukun ntit.” Ana pul pothiekathe ukun ana wothakkakathe woporot. ");
INSERT INTO lmd_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ana ul woPriccin woingkathe thapat, ana okin thaththikkat cik akin oul woIruthuc akin eret itti okin thakkwot oIeccuo tat. ");
INSERT INTO lmd_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","OIeccuo poingkathe nnul iammakothok norok, ana ul wonoththok poCelïl woppot womakathekin. ");
INSERT INTO lmd_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Manakka okin thoccïkothe lon appik ila kwokat cik akwokkot, ul woppot wakkakanthok nci noththok poIouthia ana nokaꞌran koUruccelim ana noththok poIthümia, ana na acïngkï ummot ngngin tokꞌrakan korue toÜrüthün ana ammrththakot cik coCcur ana coCcithon. ");
INSERT INTO lmd_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Anakka ul wokat woppot, kwiꞌrekathe ul iammakothok itti, “Nona kuppuꞌrung konoiꞌri ikotteik akoceꞌre ul ciththan akin okorronno onentethin cik.” ");
INSERT INTO lmd_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Akka kwappittiethe ul woppot ionat mio kurekkurek. Ana okin ithokat thongo thokat akin errettot tokït itti akin othontok. ");
INSERT INTO lmd_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ana na uꞌrupa iokithak wimmathok, wapukkot tokït kung aiꞌre mpoꞌre cittan itti, “Oung ukul woKapik.” ");
INSERT INTO lmd_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Anaruk kwekathekin lon lonthoththomat itti okin thakanniꞌre itti, ook okkwen. ");
INSERT INTO lmd_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","OIeccuo poingkathe iccik kocoꞌrong ana kwakkarathe ul ia kwongothe, ana okin thakkakanthok. ");
INSERT INTO lmd_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ana kwipathe ul cik wothothïlettat wung iattul ana ikken keꞌra, othakka itti akin oka okin aththut ana othakka itti akwothïlet kin akin othongkene ul ");
INSERT INTO lmd_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ana ona puꞌran ipakin okïcce uꞌrupa iokithak ngngin. ");
INSERT INTO lmd_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Okin enthi ithattul ana ikken keꞌra, itha kwapponekkethe cik, oCcaimon (ipa kwocciet kꞌran itti oPoththuruc) ");
INSERT INTO lmd_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ana oIakup ukul woCepethi ana opang oIuanna (okin then itha kwappocciet ꞌran itti Panoroco ilonu itti 'nyukul nyothuleꞌrak'), ");
INSERT INTO lmd_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ana Anthrauc ana oPilippic ana oPerththolomauc ana oMaththa ana oThthoma ana oIakup ukul wAlappaoc ana oThthothaoc ana oCcamaan ipokat pongothe lon lopothok pung, ");
INSERT INTO lmd_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ana oIoutha Icikkariuththi, ipokerot oIeccuo. ");
INSERT INTO lmd_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ittina oIeccuo piꞌrikathe noppan, ana ul wappraꞌrntakat, ana ook ana ul iammakothok thommakathe oꞌrkoik akka okin thokat thiꞌrikothe. ");
INSERT INTO lmd_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Anakka kuꞌri kung koccïkothe lon ilokat cik okin thoingkathe akin othipok ntan akka okin thiꞌret itti, “Kwonu purrut.” ");
INSERT INTO lmd_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ana ul iangkene lon lothonceꞌret lon cik iaat nnokaꞌran koUruccelim wiꞌrekathe itti, “Kwonu puꞌran poili wouꞌrupa iokithak oPelecepul ana kwaik pakïcce uꞌrupa iokithak mpuꞌran pen.” ");
INSERT INTO lmd_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ittina oIeccuo pakkarathekin ana kwiꞌrekathekin nthokkwie lon kuru ncik itti, “Pul pothopulut pakïcce pul pothopulut taththa? ");
INSERT INTO lmd_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Amma ngili ngillillakot tit kurekkurek, ngili ngen ngakannoꞌrungkot cik. ");
INSERT INTO lmd_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Amma ul woruan willillakot tit okin thakannikkoik tothun. ");
INSERT INTO lmd_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ana amma pul pothopulut poprttakothe ika kung ana pakannappoꞌrungkot cik. Ittina puꞌran pung paik pintat cik. ");
INSERT INTO lmd_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Laik ïcat itti pul pella piꞌriko noppan topul iponthomat mpuꞌran akwoneko aꞌrupu wung, kwonu itti kwïꞌrïkïkko pul pen cittokït akwantoneko aꞌrupu. ");
INSERT INTO lmd_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Mpiꞌret non lon ilaik ïcat itti lon ilokithak appik ana thocungkoik thoul thaccïkakinthet kin. ");
INSERT INTO lmd_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Anaruk pul ipacungko Kanang ikupupure kwakannoccïkakinthet lon ilokithak lung thupuththuput.” ");
INSERT INTO lmd_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Kwiꞌret elli akka okin thiꞌrethok itti, “Kwonu uꞌrupa iokithak.” ");
INSERT INTO lmd_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Onnan poIeccuo ana opangon thakkakathe ana okin thocoꞌrathe thapat akin othïat pul pꞌrek itti pathakkarok. ");
INSERT INTO lmd_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ana ul wokat cik woppot ammrththakothok, ana okin thomekathok itti, “Onne ana opangkangon thaik thapat thakwariccathung.” ");
INSERT INTO lmd_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Akwipittat kin itti, “Oththa ongaia ana opangkingon?” ");
INSERT INTO lmd_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ana kwokathakathe ul iokat cik ammrththakothok ana kwiꞌrekathe itti, “Ongaian enthi ana opangkingon enthi. ");
INSERT INTO lmd_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Okkwi ipakkot ngre ngoKapik ook opangkin ipocura ana ipopari ana ongaia pin.” ");
INSERT INTO lmd_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ana oIeccuo pikkatheik cakuruk akwongkene ul iccik korok. Ana cungkut coul woppot caꞌrantakathe ammrththakathok, akwarrat ikuppuꞌrung konoiꞌri akwikkat cik tit ana ul appik wokat cik nokuthut korok. ");
INSERT INTO lmd_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Kwongkenekathekin lon loppot nthokkwie lon kuru ncik ana kwikkatheik akwongkenekin itti, ");
INSERT INTO lmd_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Nantoccïkot, pul pokkwon peot itti pathee mïl. ");
INSERT INTO lmd_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Anakka pokat apee mïl, amꞌrek apukkat ikathar, auꞌrupe akkakat acumat ncik appik. ");
INSERT INTO lmd_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Amꞌrek apukkat nokꞌrimi ikonat nünthü notte. Ana mummathe cokoccokot akka mokat noꞌrpu. ");
INSERT INTO lmd_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Anaruk akka cïngkï cuat, auꞌruccu womïl okꞌrat ana wonthomakathe akka mellat laka ippu. ");
INSERT INTO lmd_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Amïl mꞌrek apukkat ithoꞌrkït tholï amocokkakat alï okarthat ana makannokwonat. ");
INSERT INTO lmd_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Anaruk amꞌrek mapukkathe nocapu icoporot. Mummathe amocokkakat ana mokwonathe mïl mipiet kicce, amꞌrek ipiekat kït ken arrial ana alkaire (30), ana amꞌrek arrial wꞌrakkuruk (60) ana amꞌrek arrial ukuluk (100).” ");
INSERT INTO lmd_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","AIeccuo iꞌrekat itti, “Okkwi iponu unu itti kwaccïkot, akwoccïkot.” ");
INSERT INTO lmd_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Anakka kwokat cik prek, ul wung wothothïlettat iattul ana ikken keꞌra ana opilingon ithokat ammrththakathok ipittathok lon lothokkwie lon kuru ncik. ");
INSERT INTO lmd_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Akwomekat kin itti, “Kumitta kongili ngoKapik kokenettat non anaruk pꞌrak iparon thakannoka uraththungon, piꞌrettat lon appik nthokkwie lon kuru ncik. ");
INSERT INTO lmd_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Othakka itti, ‘Okin thantokathacce lon ngkït anaruk okin thakannina, ana okin thaccïkot lon ana okin thamma, akka amma okin thoccïkothe ana okin thaprttakoik nti ilon ilokithak ana okin thaccïkakinthet lon ilokithak.’” ");
INSERT INTO lmd_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ittina aIeccuo iꞌrekathekin itti, “Onon thomma lon lothokkwie lon kuru ncik elli? Ana onon thantinakat lon lothokkwie lon kuru ncik lꞌrek ilaik tat? ");
INSERT INTO lmd_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Pul ipee, ook pul ipaik pangkene lon loKapik. ");
INSERT INTO lmd_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ul wꞌrek waik ammakka mïl imothithiekotheik ikathar. Amma okin thoccïkothe lon, pul pothopulut panthan accokkot aponekat kin lon ilakin thoccïkothe nnomïkït men. ");
INSERT INTO lmd_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Opilingon thammakka mïl imapukkothe nokꞌrimi, okin thaccïkot lon akin opirakat noka. ");
INSERT INTO lmd_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Anaruk akka lon lakannoccokot cik nomïkït, lon len lakinnikkoik puccuk. Ana amma thokkiettat thiak thaat nti ilon len okin thapaꞌrineik accokkot. ");
INSERT INTO lmd_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ana opilingon, thammakka mïl imapukkothe ithoꞌrkït tholï, okin thaccïkot lon, ");
INSERT INTO lmd_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","anaruk thirro mïkït nti ikarak nolon lothikkoik enthi ana thammikkarakot thothaꞌrthan ana thongat thaꞌrupu wꞌrek thiꞌriko nomïkït cakuruk athokïttat lon loKapik. ");
INSERT INTO lmd_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ana ul wꞌrek wammakka mïl imerat nocik icoporot, okin thaccïkot lon akin angkat, akin okkwoniekat mïl arrial ana alkaire ana aꞌrek arrial wꞌrapuruk ana aꞌrek arrial ukuluk nomïl imokat mettat.” ");
INSERT INTO lmd_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ana kwiꞌrekathekin itti, “Onon thaccie thik annappokuꞌrupot cerok nani ana manna onekket thoceken copapꞌreki? Onon thakorronno onekket cik noꞌret athoccieiki? ");
INSERT INTO lmd_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Akka lon ilamuꞌruttakot ncik linako nan ana ilocukkwakot nan littako ncik. ");
INSERT INTO lmd_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Okkwi iponu unu itti kwaccïkot cik akwoccïkot.” ");
INSERT INTO lmd_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ana kwiꞌrekathekin cakuruk itti, “Nokkwine lon kunu ncik kicce ilanon thaik thaccïkot, akka lon ilanon okkot lakkattanthet non ana manna arttakot nan. ");
INSERT INTO lmd_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Okkwi ipakkwine thongkene thin kunu ncik, kwina arttot nan, ana okkwi ipakorronno occïkot lon lin, antoka manna itti kwina kwanekittat thina then.” ");
INSERT INTO lmd_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ana kwiꞌrekathekin cakuruk itti, “Ngili ngoKapik ngammakka lon elli. Pul peet mïl. ");
INSERT INTO lmd_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ngkoꞌra ana icïngkï core cocïl caik cacokka antoka manna itti kwomma itti caik cacokka tat. ");
INSERT INTO lmd_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Lon len lakkattat pellek, capu cummiet tꞌre cittokït aroingkat ikwonco arokkat tartta, arokkat cïl. ");
INSERT INTO lmd_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ana amma mïl moꞌriat ana thuput thaat thothokio, kwaneko kiꞌrittang akwothokiat.” ");
INSERT INTO lmd_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Kwappiꞌrekat cakuruk itti, “Ngintha akka oron ungkwie ngngili ngoKapik ngngin, ana manna thokkwie lon kuru ncik thiatha itharon eret ngngin? ");
INSERT INTO lmd_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ngili ngoKapik ngungkot core icoththe cannan iceera inocapu. ");
INSERT INTO lmd_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Anaruk amma ceerat cacokka acothakkakat pira pïttïk ipangken, apokkat uꞌri wïttïttïk auꞌrupe ikkat cik irnek ten.” ");
INSERT INTO lmd_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","OIeccuo pokat cik akwerenekin nthokkwienekin lon kuru ncik loppot ammakka elli ilokat aliniekin lon. ");
INSERT INTO lmd_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Kwakannerenekin lon lꞌrek aththik okorronno okkwienekin lon kuru ncik anaruk amma okin thaik threk okin oul iammakothok akwerenekin lon kicce okorronno okkwienekin lon kuru ncik. ");
INSERT INTO lmd_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ana caꞌri cen cipin akwiꞌrekat ul iammakothok itti, “Ntun arrot nocarkan corok cꞌrek.” ");
INSERT INTO lmd_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Akin oththekat nocungkut coul akin arriekathok ikuppuꞌrung konoiꞌri ana ul wꞌrek womakathok nuppuꞌrung wonoiꞌri wꞌrek cakuruk. ");
INSERT INTO lmd_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ana kanang kakkakathe akikkat cik akokkurarot cannan, athopangka thoiꞌri ongkuꞌrot ciki ithiꞌrot aiꞌri ikkat cik angothukkwot ikuppuꞌrung akikkat cik ere kuo thoꞌronthong. ");
INSERT INTO lmd_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ana oIeccuo pappokat cik akwïcat thoceken cokuppuꞌrung akweot inthe, ana ul iammakothok wurttathok aiꞌrekathok itti, “Pul ipangkene, ngkwella thiak thïn akka onïn thaik thïkïkko ngꞌri?” ");
INSERT INTO lmd_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Akurokat kapik akwothirriekat kanang cik akwiꞌrekat thopangka thoiꞌri itti, “Angkik ana itti ocoꞌri.” Ana kanang kangkatheik accokkot ana cik cokkwathe ka appik. ");
INSERT INTO lmd_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ana kwiꞌrekathe ul iammakothok itti, “Onon thontha akka annopelle? Onon tharthuk thella thoccokot lon loKapik nomïkïri?” ");
INSERT INTO lmd_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ana okin thipathe nꞌre akin okkwe ka akin ikkat cik akin ipittararot itti, “Oththa empi? Akka manna kanang ana thopangka thoiꞌri thaccïkothok.” ");
INSERT INTO lmd_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Okin tharrathe tok cik akin eo nocik coCcethirin. ");
INSERT INTO lmd_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Anakka oIeccuo porpotheik nti ikuppuꞌrung konoiꞌri, apul pꞌrek akkakat nonupu ponat uꞌrupa iokithak noka apathocurot iaak. ");
INSERT INTO lmd_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Pul pen pikikkot cik nonupu ana manna pul pellat ipïꞌrïkïkkok nynyol. ");
INSERT INTO lmd_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Okin thokat akin ïꞌrïkïkkok appinappin nyaun ana tacok anaruk kwokat cik akwommotho nyol nnonyaun ana nnoracok. Pul pellat iponthomat cannan othakka itti apalkothok. ");
INSERT INTO lmd_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Kwokat cik akwaalle nonupu ana imuꞌrol icïngkï ana ingkoꞌra ana kwokat cik akwokontotto kuri ana akwokecce ka kung mmothok. ");
INSERT INTO lmd_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Anakka kwimmat oIeccuo nciththan akwollat taak akwekat ungku ncik tokït kung. ");
INSERT INTO lmd_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Kwiꞌrekathe mpoꞌre cittan itti, “Ngintha akka ngkwimmathe naun, Ieccuo, ukul woKapik korothiꞌrot, arrma ngkꞌran koKapik itti ngkwakannokkiethin thiak.” ");
INSERT INTO lmd_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Akka oIeccuo pappiꞌrethe uꞌrupa iokithak itti, “Uꞌrupa iokithak, oppothe thapat nti ipul empi.” ");
INSERT INTO lmd_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Menik aIeccuo ipittathok itti, “Ngkwoccot kꞌran itti oththa?” Akwothïanthok tit itti, “Mpoccot kꞌran itti ‘cungkut’ akka onïn thoppot.” ");
INSERT INTO lmd_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ana kwipittathe oIeccuo attang ana attang itti kwakannothïot kin thapat nocik enceꞌre. ");
INSERT INTO lmd_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ana iccik kocoꞌrong cïnang, cungkut conuththuruk cokat cik acuꞌro. ");
INSERT INTO lmd_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ana uꞌrupa iokithak wipittathe oIeccuo itti, “Othïothenïn inuththuruk, akorronno anïn iꞌrikikkorit.” ");
INSERT INTO lmd_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Kwokorronnathe uꞌrupa iokithak ana woppathe thapat nti ipul ana wiꞌrikikkathe inuththuruk. Ana nuththuruk athar weꞌra (2,000) noccorathe uo nokuthut korok ana napukkathe irok ana nïkïkkathe ngꞌri. ");
INSERT INTO lmd_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Pꞌrak ipuꞌre nuththuruk pollathe ana paththiꞌrekat ul lon len icarak coman ana iaik nomipit, ana wakkakathe itti wathokatha lon len. ");
INSERT INTO lmd_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Manakka okin thainet oIeccuo, okin thaththiat pul iponat uꞌrupa iokithak noka apikkoik appakot eret ana pothakkat poporot ca, ana okin thipathe nꞌre. ");
INSERT INTO lmd_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Pꞌrak ipokat pimmat, piꞌrekathe ul lon ilokkattathe nopul iponat uꞌrupa iokithak. Ana okin therekanthet kin lon lonuththuruk cakuruk. ");
INSERT INTO lmd_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ittina ul wiꞌrekathe oIeccuo itti kwaththe nocik cen. ");
INSERT INTO lmd_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Anakka oIeccuo pokat cik akwarrot ikuppuꞌrung konoiꞌri, pul ipapponat uꞌrupa iokithak pipittathok itti pamakothok. ");
INSERT INTO lmd_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","OIeccuo pꞌrakanthok anaruk kwiꞌrekathe itti, “Ngko tuan thanang athiꞌret kuꞌri kang lon appik ila Ili wokkinthung, ana tat akka wipot thiak thang.” ");
INSERT INTO lmd_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ittina pul poingkathe ana pikkatheik aperene ul Naꞌran iattul lon loppot ila oIeccuo pokkinthok. Ana ul appik woprttakathe tit. ");
INSERT INTO lmd_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Anakka oIeccuo parrothe tok cik irapangka attang akweo nocarkan corok cꞌrek ngkuppuꞌrung konoiꞌri, ul woppot waꞌrntakathe iccik kung iccik korok. ");
INSERT INTO lmd_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Opilin nti inili nonocuththun caꞌrama poccot kꞌran itti oIairoc akkakat nocik cen. Manakka kwimmat oIeccuo, akwapat iracok tung. ");
INSERT INTO lmd_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Kwipittathok nthiak akwiꞌrekathok itti, “Ukul win iotteik iopari waik wio, ana ngkwanthan athonekket nyaun nan othakka itti akkoik.” ");
INSERT INTO lmd_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ittina oIeccuo poingkathe akin aththeꞌra. Ana cungkut coul woppot comakathok ana cikkatheik aconentekot cik iccik kung. ");
INSERT INTO lmd_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ana pul ipopari pokat nocik cen ponat luput attul ana ikken keꞌra (12), aüccük ollo nti iaak. ");
INSERT INTO lmd_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Kworttekot thiak cannan akwoincene ul ittiet ul itti akwothakka poporot ana kwokïttathe akucci cik ia kwonat appik itti akwothakka poporot anaruk kwothakkakathe pongo cannan. ");
INSERT INTO lmd_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Manakka poccïkothe lon loIeccuo, pakkakathe nthoccul koIeccuo ithoꞌrkït thoul apothntat thon thokret koIeccuo, ");
INSERT INTO lmd_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","akka kwerethe nocïkït cung itti, “Amma mpothntot kret kung ana mpittat.” ");
INSERT INTO lmd_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ngüccük ngocoꞌrathe nti iaak accokkot ana kwinakathe noka kung itti kwothakkat poporot ngüccük ngocoꞌrot. ");
INSERT INTO lmd_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","OIeccuo pinakathe nan itti puꞌran peot nti iaak ana kwolliakathe ul ana kwipittathekin itti, “Oththa akkothntot kret kin?” ");
INSERT INTO lmd_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ul iammakothok wiꞌrekathok itti, “Ngkwimmat itti ul woppot waik wanentethung cik, ana tat akka aipitto itti, ‘Oththa akkothntorin?’” ");
INSERT INTO lmd_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Anaruk oIeccuo pikkatheik akwolliakot cik othakka itti akwimma pul ipothntot kret. ");
INSERT INTO lmd_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Pul ipopari pen pinat itti pittathe papathe iracok toIeccuo apokkwe ka nꞌre ana piꞌrekathe oIeccuo lon appik ilaik ïcat. ");
INSERT INTO lmd_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","AIeccuo iꞌrekathok itti, “Ukul win, thoccokot tholon loKapik nocïkït thang thittiethung. Ngko amio opaꞌrik naung.” ");
INSERT INTO lmd_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Manakka oIeccuo pokat cik akwere, ul wꞌrek wakkakathe ntuan toIairoc, ili wonocuththun caꞌrama ana wiꞌrekathe itti, “Ukul wang wiot. Ana ngkwakinyie pul ipangkene pothen?” ");
INSERT INTO lmd_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","AIeccuo okorronno okkwanthet lon ilakin thiꞌret kunu ncik akwiꞌrekat ili wonocuththun caꞌrama itti, “Kirrnni opelle occokothe lon loKapik nocïkït.” ");
INSERT INTO lmd_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ana kwakannokarrnnat itti pul pꞌrek pamakothok, oPoththuruc pulluk ana oIakup ana oIuanna opang poIakup. ");
INSERT INTO lmd_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Manakka okin theot tuan toili wonocuththun caꞌrama, oIeccuo pimmakathe cungkut coul iokat cik aoo mpoꞌre cittan. ");
INSERT INTO lmd_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Kwiꞌrikathe noppan ana kwiꞌrekathekin itti, “Nthontha akka annoo ana annothukkwo ka ncik? Ukul wakinnio anaruk waik inthe.” ");
INSERT INTO lmd_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Anaruk okin thoccirathok ngngin. Anakka kwothïothekin thapat appik, kwipathe oththan pokkul ana onnan ana ul iammakothok iakin thokat aththut, ana okin thiꞌrikathe na ukul wokat cik. ");
INSERT INTO lmd_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Kwonthathe ukul ncik ana kwiꞌrekathok ngkarru kung itti, “Thaliththa koum,” ilonu itti, “Ukul ioththeik, mpiꞌrethung itti urokothe kapik.” ");
INSERT INTO lmd_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ana ukul wurokathe accokkot ana wikkatheik anyaro. Ukul waronat luput attul ana ikken keꞌra. Okin thikkatheik akin oprttakot tit nnꞌre. ");
INSERT INTO lmd_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ana oIeccuo piꞌrekathekin lon lonthoththomat itti okin thakinniꞌret pul pꞌrek lon elli ana kwiꞌrekathekin itti okin thethet ukul aꞌrupu wꞌrek aꞌrko. ");
INSERT INTO lmd_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","OIeccuo poththekathe nocik cen ana kwoingkathe nokaꞌran kung ikokat kaꞌran koNaccir, ana ul iammakothok woingkathe okin aththut. ");
INSERT INTO lmd_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Anakka caꞌri caCcepith caat, kwikkatheik akwongkenekin nocuththun caꞌrama ana okin ithoccïkothe lon lung thikkatheik akin oprttakot tit. Ana okin thipittarathe itti, “Pul empi piothe lon elli kartha? Thinaik nti ica thiatha enthi ithettathok akka manna kwaik pakkot lon ilommaththik. ");
INSERT INTO lmd_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Okorronno oka ook pul ipaccatha oꞌreni? Okorronno oka ukul woMeriomi ana opang oIakup ana oIuccip ana oIouthai ana oCcamaani? Okorronno oka opangon ithari itharon thaik cenei?” Ana okin thꞌrakathe lon lung. ");
INSERT INTO lmd_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","OIeccuo piꞌrekathekin itti, “Pul pothernte lon loKapik pothiakinet cik naꞌran appik anaruk kwakannothiakineik nokaꞌran kung ana nokuꞌri kung ana noul woruan thanung.” ");
INSERT INTO lmd_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Kwommat okkot lon ilommaththik ceneket, anaruk kwonekkekathe nyaun noul wotteik iongo ana kwothikkiekathekin thoporot. ");
INSERT INTO lmd_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ana kwokat cik akwoprttakot tit akka okin thellat thoccokot lon loKapik nomïkït. Ittina oIeccuo poingkathe akwonyaro naꞌran akwongkene. ");
INSERT INTO lmd_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Kwakkarathe okin ithattul ana ikken keꞌra (12) akwothïlekat kin theꞌra theꞌra naꞌran kurekkurek ana kwekathekin ngili akin okïcce uꞌrupa iokithak. ");
INSERT INTO lmd_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ana kwiꞌrekathekin lon lonthoththomat itti, “Nokorronno oneko alpꞌrek aththik nokurtti kon, noneko kurrong kulluk. Nokorronno oneko thuꞌrit ngkaꞌruk nokurtti ana akucci iaꞌruk. ");
INSERT INTO lmd_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Nako wok annokorronno oneko eret arttot nan.” ");
INSERT INTO lmd_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ana kwiꞌrekathekin cakuruk itti, “Amma onon thiꞌrikot tuan topul, nikkoik noppan ten puccuk annoththekat nokaꞌran ken. ");
INSERT INTO lmd_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ana amma ul wonokaꞌran ken wakinnikkienon cik ana okorronno occïkot lon, annokkwe tuꞌrupang noracok ton amma annoththe nokaꞌran ken, aloka lon ilimmat lon ngkït itti okin thꞌrat lon lon.” ");
INSERT INTO lmd_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Okin thoingkathe akin ongkene ul itti wapaꞌrine lon ilokithak cik. ");
INSERT INTO lmd_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ana okin thokïccekathe uꞌrupa iokithak woppot nnoul ana oꞌro ul ngaak iupupure woppot ana okin thothikkiekathekin thoporot. ");
INSERT INTO lmd_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","AIli oIruthuc occïkat lon len, akka kꞌran koIeccuo kokat kinakot ncik appik. Opilingon thokat cik akin ere itti, “OIuanna pomamuthie purokot nti ithio, ana ilen akka puꞌran polon ilommaththik paik parekine iaak.” ");
INSERT INTO lmd_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ana opilingon iꞌre itti, “Ook oIlia.” Ana opilingon iꞌre itti, “Ook pul pothernte lon loKapik ammakka pul pꞌrek nti iul wothernte lon loKapik womaꞌrot wothupuththuput.” ");
INSERT INTO lmd_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Anaruk akka Ili oIruthuc poccïkothe lon elli, kwiꞌrekathe itti, “OIuanna pomamuthie ipa mpokiothe ca akkurokot nti ithio.” ");
INSERT INTO lmd_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Akka oIruthuc ngka kung akkiꞌret itti oIuanna paccokittat akwïꞌrïkïkkako, ana oIuanna poccokittakathe ana kwonekkettakathe ikorrkkor. Kwokkothe elli nti ilon loIruthia pari popang oPilippic ipa kwappipothok. ");
INSERT INTO lmd_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Akka oIuanna pokat akwerene oIruthuc itti, “Lon elli lakannoka locoꞌrotheik itti ngkwipo pari popangkang.” ");
INSERT INTO lmd_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","OIruthia puakathe ka koIuanna itti kwakkwothok anaruk kwommat itti kwakkwothok tat ");
INSERT INTO lmd_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","akka oIruthuc ponat nꞌre noIuanna akwaꞌrettanthok akka kwinarok itti kwokat pul ipoporot pupupure. Anakka oIruthuc poccïkothe akka oIuanna ere, alon ocikittanthok ca anaruk kwokat pongothe itti kwaccïkot lon lung. ");
INSERT INTO lmd_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","OIruthia piathe caꞌri ica kwokat cik akwokwancot. Nokamuthe kocaꞌri cothokwonta thoIruthuc, oIruthuc pakkarathe ul ittïttïk ana nili noul irro ana ul ionu lon ikkun wonoththok poCelïl. ");
INSERT INTO lmd_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ana ukul iopari woIruthia wukkwathe ana wopiriekathe oIruthuc noka ana ul wung iakin thokat cik akin oꞌrko thuꞌrit. AIli oIruthuc iꞌrekat ukul iapari itti, “Ipittothin papu ipa ngkwongothe ana mpethung.” ");
INSERT INTO lmd_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ana kwonekkekanthet ukul lon cik akwiꞌrekat itti, “Papu ipa ngkwipittothin mpethung, antoka manna ngili ngin appꞌrut.” ");
INSERT INTO lmd_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ukul woppathe thapat ana wiꞌrekathe onnan itti, “Ngintha akka anipitto?” Annan iꞌrekathok itti, “Ipitti ca coIuanna pomamuthie.” ");
INSERT INTO lmd_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ukul woingkanthet Ili oIruthuc ana wipittathok itti, “Mpongothe itti ngkwethin ca coIuanna pomamuthie nocaththak inaina.” ");
INSERT INTO lmd_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ili wappakannapira noka cannan, anaruk akka kwapponekkethe lon cik, ana ul wung woccïkothe ana ilen akka kwakannangkot itti kwꞌrane lon lokkul. ");
INSERT INTO lmd_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Nci cïnang kwothïathe pul pothorro llon lonthoththomat itti kwathokiot ca coIuanna. Pul pothorro poingkathe ana pokiathe oIuanna ca cik ikorrkkor. ");
INSERT INTO lmd_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ana ponakathe ca coIuanna nocaththak. Ana kwekathe ukul ana wekathe onnan. ");
INSERT INTO lmd_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Anakka lon len loccïkakothe, ul woIuanna iammakothok wakkakathe ana wonekathe kumi ana waththocïkkat. ");
INSERT INTO lmd_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ana ul wothothïlettat waꞌrntakathe iccik koIeccuo ana okin therekanthok lon appik ilakin thokkothe ana ilakin thongkenet. ");
INSERT INTO lmd_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Anakka ul wokat cik aeo ana anthan, okin thommakathe itti okin thaꞌrko thuꞌrit tat. Akwiꞌrekat kin itti, “Ntun thellek thomnther annothongoko papotteik.” ");
INSERT INTO lmd_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ittina okin tharrathe kuppuꞌrung konoiꞌri ana okin thoingkathe cinokaꞌran thellek na ul wellat. ");
INSERT INTO lmd_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Anaruk ul woppot wimmakathekin akka akin eo ana wakkakathe nnaꞌran appik allat tokït ken aingkat nokaꞌran tokït koIeccuo ana ul wung iammakothok awarthuk ao. ");
INSERT INTO lmd_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Manakka oIeccuo porpotheik nocapu nti ikuppuꞌrung konoiꞌri, akwimmakat cungkut coul woppot, akwipat thiak then akka okin thokat ere lungkat ilella opït nan. Ittina kwikkatheik akwongkenekin lon loppot. ");
INSERT INTO lmd_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Nocaꞌri cen cipin cokat capot ana ul iammakothok wakkakanthok, ana wiꞌrekathok itti, “Kaꞌran engki kella ulrit ana cik ceot. ");
INSERT INTO lmd_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Omethe ul apettakot cik othakka itti akin eo naꞌran iccik konnon akin othokerine ka ken alpꞌrek akin oꞌrko.” ");
INSERT INTO lmd_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Anaruk kwothïatherit itti, “Nethet kin alpꞌrek akin oꞌrko.” Okin thiꞌrekathok itti, “Elli lonu itti pul pareko anok mormor apantokero arrakith iekko noul enni appik.” ");
INSERT INTO lmd_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","AIeccuo ipittat kin itti, “Ngkonon annothokatha, onon thonu arrakith wornoththa?” Anakka okin thiothe akin iꞌrekat itti, “Arrakith ukuluk ana ape weꞌra.” ");
INSERT INTO lmd_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","AIeccuo omekat kin itti okin thikkie ul cik appik mungkut mungkut noraco iricci. ");
INSERT INTO lmd_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Okin thikkiekathe ul cik nocapu mungkut, meꞌra culukku arrial ukuluk ana acꞌrek arrial weꞌra ana alkaire. ");
INSERT INTO lmd_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ana oIeccuo ponekathe arrakith ukuluk ana ape weꞌra akwokathakat tothiꞌrot ana kwopiriekathe Kapik ana kwomithathe iarrakith ana kwekathe ul iammakothok akin ikket ul. Ana cakuruk kwummathe ape weꞌra ana kwillillanthet kin tit appik. ");
INSERT INTO lmd_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ana okin thoꞌrkkathe appik ana okin thoththakakathe. ");
INSERT INTO lmd_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ana ul iammakothok wocumathe arrakith ana ape iokwentakot nan nyalünthüng attul ana ikken keꞌra oppappat. ");
INSERT INTO lmd_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ana maun moul iomura iokat woꞌrkot cik wokat athar ukuluk (5,000). ");
INSERT INTO lmd_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","AIeccuo iꞌrekat ul wung iammakothok accokkot itti warrot ikuppuꞌrung konoiꞌri akin eo tokït kung eo Peththcceitha akwiꞌrikot opettot ul cik, nci cïnang kwothïathe ul ikathar. ");
INSERT INTO lmd_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Anakka kwopettothe ul cik akwoingkat iccik kocoꞌrong akwothaꞌra ngaꞌrama. ");
INSERT INTO lmd_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Anakka cipin capot, kuppuꞌrung konoiꞌri kokat cik ipanan porok irapangka ana kwokat cik nocarkan corok prek. ");
INSERT INTO lmd_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","OIeccuo pimmakathe ul iammakothok akuppuꞌrung konoiꞌri attakin akka kanang kokat akaukkukkot kin. Ana cik cokat thothuput thorrot, oIeccuo pakkakathe nakin akwonyaro noꞌra woiꞌri. Ana kwokat cik ere kwaik parrot kin cik, ");
INSERT INTO lmd_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","anaruk akka okin thimmarok akwonyaro noꞌra woiꞌri, akin iꞌrekat nomïkït men itti, “Ook purrut.” Akin ikkat cik akin oo, ");
INSERT INTO lmd_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","akka okin appik thimmarok okin thipathe nꞌre. Kwiꞌrekathekin accokkot itti, “Nopoꞌrathan, oun ana thakorronno opelle.” ");
INSERT INTO lmd_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ana kwarrathe ikuppuꞌrung konoiꞌri akin aththungon, ana kanang kokapik kocoꞌrathe ana okin thoprttakatherit cannan. ");
INSERT INTO lmd_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Akka okin thokat thakinnina lon ilommaththik ila oIeccuo pokkothe akka kwoꞌrikiet ul woppot arrakith wotte ana ape akka mïkït men mokat munukkwakothe. ");
INSERT INTO lmd_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Manakka okin tharrotheik, akin orpat cik nocik coCeniccarth, akin ïꞌrïkat kuppuꞌrung konoiꞌri nan ");
INSERT INTO lmd_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Manakka okin thorpot nti ikuppuꞌrung konoꞌri ul winakathe oIeccuo. ");
INSERT INTO lmd_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ana okin thopellekathe ntan oppo naꞌran ennꞌre appik akin onnekinok ul iongo naꞌrangkal na akin thoccïkothe itti kwaik. ");
INSERT INTO lmd_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ana naꞌran appik na kweot nomoꞌrong, akin ipot ul iongo keccuk. Akin ipittothok itti kwakorronno ul iongo athonto manna toꞌron lokret kung. Ana okin appik ithothntot thittakathe. ");
INSERT INTO lmd_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ul woPriccin ana ul wꞌrek woul iangkene lon lothonceꞌret lon cik iaat nokaꞌran koUruccelim aꞌrntakat iccik koIeccuo ");
INSERT INTO lmd_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","akin immakat ul iammakothok wꞌrek aꞌrko thuꞌrit akin thakinnilakko nyaun ammakka thathuma thoul woIouth. ");
INSERT INTO lmd_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Ul woPriccin ana ul woIouth appik wakannoꞌrkoik amma okin thakinnilakko nyaun ammakka thathuma thoul wen ittïttïk. Okin thimmakathe ul wung wꞌrek aꞌrko thuꞌrit nyaun nyonyï ");
INSERT INTO lmd_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Amma okin thaat ngkeccuk okin thakannoꞌrkoik amma okin thakinnilakko. Ana okin thangwot thathuma thꞌrek ammakka itti ome maththak mothuꞌrit.) ");
INSERT INTO lmd_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Aul woPriccin ana ul iangkene lon lothonceꞌret lon cik ipittat oIeccuo itti, “Ul iammakothung wontha akka akannoccot kït nothathuma thothiki akka okin thaik thaꞌrko thuꞌrit akin thakinnilakko?” ");
INSERT INTO lmd_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Akwothïat tit itti, “Lon loIccaia pul pothernte lon loKapik lokat ïcat akka perethenon ithinnikot lon ammakka lokurrakot iatham wung itti, ‘Ul enni wathianin cik llon nuthuk, anaruk mïkït men maik ciththan naun. ");
INSERT INTO lmd_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Okin thaꞌranin ngaꞌrama ella mïkït nan, okin thangkene thongkene thoul ionyi.’ ");
INSERT INTO lmd_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Onon thopaꞌrinet lon loKapik cik ana onon thoꞌrumot nothathuma thothiki.” ");
INSERT INTO lmd_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ana kwiꞌrekathekin itti, “Onon thina akka annopaꞌrine lon loKapik cik othakka itti annoccot kït nothathuma thon. ");
INSERT INTO lmd_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","OMucca piꞌret itti, ‘Othianet oththe cik ana onne’ ana ‘Okkwi ipattatta oththan ana onnan kwonu itti kwakkuttat.’ ");
INSERT INTO lmd_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Anaruk onon thangkene itti amma pul ponu papꞌrek itti kwittarot oththan ngngin ana manna onnan kwiꞌret kin itti, ‘Aꞌrupu enni ampongothe itti mpittarot non ngngin anaruk wothethet Kapik nuthuk,’ ");
INSERT INTO lmd_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Lakene itti onon thakannangkot itti kwittarot oththan ana onnan. ");
INSERT INTO lmd_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Menik onon thaik thꞌra lon loKapik amma annoccokot thathuma thon. Ana onon thaik thakkot lon loppot ammakka elli.” ");
INSERT INTO lmd_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","AIeccuo akkarat cungkut coul akwiꞌrekat kin itti, “Nantoccïkothin appik, nantoccïkot lon lin anninakat lon len. ");
INSERT INTO lmd_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Aꞌrupu ia pul othurukkwet icarak wakannothikkiek pokithak anaruk lon ila pul ere, ilen akkathikkiek pokithak. ");
INSERT INTO lmd_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Amma okkwi iponu unu itti kwaccïkot, akwoccïkot.” ");
INSERT INTO lmd_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Manakka kwoththet nocungkut coul, kwiꞌrikathe noppan, aul iammakothok ipittathok lon lothokkwie lon kuru ncik. ");
INSERT INTO lmd_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","AIeccuo ipittat kin itti, “Onon tharthuk thomma lon ila mpaik pereri? Onon tharthuk ina itti aꞌrupu wella iuo icarak copul wathikkiek pokithaki? ");
INSERT INTO lmd_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Akka wakanneo nocïkït anaruk waeo icarak ana nti icarak wakinyakot cik.” (Akka oIeccuo piꞌret ittina akkwaik akwiꞌre itti, “Thuꞌrit appik thoporot.”) ");
INSERT INTO lmd_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Kwikkatheik akwere itti, “Lon ila pul iꞌre ana okkot ilen akkathikkiek pokithak. ");
INSERT INTO lmd_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Akka lon ilokithak ammakka itti, thokwarttikot cik ithokithak ana thaꞌro nul nuthuk ana thuꞌran ana thokkwot pul ana thaꞌro nul iari ittat ");
INSERT INTO lmd_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ana thrïk nan ana thonyira ana karra ana thocungkoik ana thona cïkït cokithak ana thipot ka thoura ana thommaik thokorronno pul apoka pokithak. Akka lon elli appik lanthan nocïkït copul. ");
INSERT INTO lmd_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Lon elli appik ilokithak lanthan nti icarak alothikkiekat pul pokithak.” ");
INSERT INTO lmd_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","OIeccuo poththekathe nocik cen ana kwoingkathe nocik coCcur. Kwiꞌrikathe noppan ana kwokat pakannangkot itti pul pꞌrek pina na kwaik, anaruk ul winakathe na kwokat. ");
INSERT INTO lmd_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Anakka pul ipopari iponat ukul iotteik iopari ia uꞌrupa iokithak woꞌrot nan poccïkothe lon lung pakkakanthok ana papathe iracok tung. ");
INSERT INTO lmd_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Pul ipopari iponat thiki noul woKrik ana pokwontathe nocik coPiniccia noththok poCcuria pipittothe oIeccuo itti kwakïccenok uꞌrupa iokithak nnokkul wung. ");
INSERT INTO lmd_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","AIeccuo iꞌrekathok nthokkwie lon kuru ncik itti, “Kirrnni anyukul oꞌrko thuꞌrit appik itha anyongothe tokït akka lakannoka loporot itti thuꞌrit thanekittat nyukul athettat luk.” ");
INSERT INTO lmd_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Apul ipopari othïat tit itti, “Ïcat Ili win, anaruk luk ilaik thoceken cokuppuꞌrung manna laꞌrko thuꞌrit ithapukkot nyukul.” ");
INSERT INTO lmd_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Akwiꞌrekathok itti, “Nti ilon lang elli ngko, uꞌrupa iokithak woththet nokkul wang.” ");
INSERT INTO lmd_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Apul ipopari oingkat tuan ana paththiat ukul aïcat cik naꞌrangkal auꞌrupa iokithak wopaꞌrot cik nti iak. ");
INSERT INTO lmd_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ittina aIeccuo oththekat nocik coCcur akwoingkat okko nokaꞌran koCcithon uo nca norok irapangka toCelïl ana okkette Naꞌran iattul. ");
INSERT INTO lmd_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ul wꞌrek wonekanthok pul ipauril ana pomma ere ana okin thipittathok itti kwanekket ukun wung nopul. ");
INSERT INTO lmd_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Akwonekathok thocipit nti ithoꞌrkït thocungkut coul, aIeccuo onekkekat maun thounu akwopathok nguk ana othntok thuꞌre. ");
INSERT INTO lmd_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Akwonthat kït tothiꞌrot akwothukwat cokwa akwiꞌrek itti, “Apaththa” ilaik itti, “Anyothe.” ");
INSERT INTO lmd_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Nci cïnang aunu wopul anyat ana thuꞌre erekat ana kwikkatheik akwere nci nokkït. ");
INSERT INTO lmd_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","AIeccuo iꞌrekat kin lon lonthoththomat itti akin okorronno erene opilin aththik. Kwopakkukkenthet kin tit maꞌri moppot itti okin thakorronno ere lon len, anaruk okin theret nci nokkït. ");
INSERT INTO lmd_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ul wokat cik aprttakot tit aiꞌrekat itti, “Kwokkothe lon appik loporot ook manna pothikkiet pul ipauril apoccïkot cik ana ipommat nthuꞌre apere.” ");
INSERT INTO lmd_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Nomaꞌri men acungkut cꞌrek crïk aꞌrntakat. Okin thellat aꞌrupu iakin oꞌrko, aIeccuo akkarat ul iammakothok iccik kung ana kwiꞌrekathekin itti, ");
INSERT INTO lmd_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Mpipot thiak thoul enni akka okin thonu maꞌri mꞌrapuruk onïn aththut cene ana aꞌrupu wella iakin oꞌrko. ");
INSERT INTO lmd_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Amma mpothïothekin nokathar ntï okin thapukkot ikathar, akka opilingon thaat nciththan.” ");
INSERT INTO lmd_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Aul iammakothok othïat tit itti, “Pul piot thuꞌrit kartha cene thomnther thekko nakin?” ");
INSERT INTO lmd_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","AIeccuo ipittat kin itti, “Onon thonu arrakith wornoththa?” Akin othïat tit itti, “Weꞌreꞌrapuruk.” ");
INSERT INTO lmd_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Akwiꞌrekat cungkut coul itti okin thikkoik nocapu. Ana akka kwummot arrakith ieꞌreꞌrapuruk akwopirakanthet Kapik noka akwomithat tit, akwekat ul iammakothok aikket ul. ");
INSERT INTO lmd_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Okin thonat ape wotte iarran cakuruk kwopirakanthet Kapik noka akwiꞌrekat ul iammakothok itti willilline ulrit. ");
INSERT INTO lmd_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ul woꞌrkkathe ana woththakakathe. Ana ul iammakothok wocumathe thuꞌrit ithokwentakot nan nyalünthüng nyeꞌreꞌrapuruk. ");
INSERT INTO lmd_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ul wokat cik caꞌri cen athar wocoꞌrin (4,000) maun moul iomura tulluk. Anakka kwothïothekin ikathar, ");
INSERT INTO lmd_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","akwarrat ikuppuꞌrung konoiꞌri akin oul iammakothok ana okin thoingkathe nocik coThalamutha. ");
INSERT INTO lmd_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ul woPriccin wakkakathe aikkat cik aipittot oIeccuo lon itti kwakkinthet kin lon ilommaththik, okin thipittot elli othakka itti akin ennekkek. ");
INSERT INTO lmd_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Akwothukwat cokwa kiththik mono akwiꞌrekat itti, “Ngintha akka ul enni ipittine lon ilommaththik? Mpiꞌret non ilaik ïcat, lon ilommaththik lella ilakkattanthet kin.” ");
INSERT INTO lmd_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Akwoththekat nakin, akwarrat ikuppuꞌrung konoiꞌri akwoingkat nokuthut korok kꞌrek. ");
INSERT INTO lmd_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ul iammakothok wurekathe nan itti waneko arrakith arttot nan, okin thonat wulukku tulluk ikuppuꞌrung konoiꞌri. ");
INSERT INTO lmd_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","AIeccuo iꞌrekat kin lon nthokkwie lon kuru ncik itti, “Noꞌrumoik nolon ilao noul woPriccin ana woIruthuc ilokkoik ere müꞌrükül.” ");
INSERT INTO lmd_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Okin therettaranthet akin iꞌrekat itti, “Kwiꞌret ittina akka oron thella arrakith.” ");
INSERT INTO lmd_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","AIeccuo inakat nolon len akka okin therethe akwipittat kin itti, “Onon thontha akka annere itti onon thella arrakith? Onon tharthuk immaik ana inaiki? Ma mon marthuk monthomari? ");
INSERT INTO lmd_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Onon thonu kït ana komma immaiki ana unu ana womma occïkot ciki? Onon thakannokwarikori? ");
INSERT INTO lmd_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Akka mpomithinet ul iarrakith iokat athar ukuluk, nyalünthüng nyornoththa inyaꞌrntakothe nyothuꞌrit ithokwentuttakot nan?” Akin othïat tit itti, “Attul ana ikken keꞌra.” ");
INSERT INTO lmd_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","AIeccuo iꞌrekat itti, “Anakka mpomithinet ul iarrakith ieꞌreꞌrapuruk iokat athar wocoꞌrin, nyalünthüng nyornoththa inyanon thaꞌrntothe nyothuꞌrit ithokwentuttakot nan?” Akin othïat tit itti, “Nyeꞌreꞌrapuruk.” ");
INSERT INTO lmd_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Akwiꞌrekat kin itti, “Onon tharthuk inaiki?” ");
INSERT INTO lmd_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Akin akkakat ciki Peththcceitha, aul wꞌrek onakat pul piꞌrimathe akin ipittat oIeccuo itti kwathntok. ");
INSERT INTO lmd_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","OIeccuo ponekathe pul ipiꞌrimathe nnukun akwoingkathok ngngin nocipit coricarak coman. Anakka kwothukkwothok nguk ikït ana onekket nyaun nyung naak, akwipittathok itti, “Ngkwimmat papꞌreki?” ");
INSERT INTO lmd_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Akwokathakat ithiꞌrot akwomekat itti, “Mpimmat ul, wungkot ere kira kaik kanyaro.” ");
INSERT INTO lmd_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","AIeccuo apponekkekat nyaun nyung ikït kopul. Caꞌri cen kït kanyathe apimmakat cik, akwimmakat aꞌrupu ncik appik papenang. ");
INSERT INTO lmd_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","OIeccuo pothïathok tuan akwiꞌrekathok itti, “Kirrnni eo icarak coman.” ");
INSERT INTO lmd_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","OIeccuo ana ul iammakothok thoingkathe naꞌran iaik iccik kokaꞌran koKaiccaria Pilippi. Anakka okin thokat cik akin eo, aIeccuo ipittat kin itti, “Ul were itti oun oththa?” ");
INSERT INTO lmd_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Akin othïat tit itti, “Opilingon there itti, oung oIuanna pomamuthie ana opilingon itti, oIlia ana opilingon itti, oung pul pꞌrek noul wothernte lon loKapik.” ");
INSERT INTO lmd_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ana kwipittathekin itti, “Ana onon thiꞌre itti oun oththa?” APoththuruc othïat tit itti, “Oung oMiccie.” ");
INSERT INTO lmd_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","AIeccuo iꞌrekat kin itti, “Okin thakannerene pul pꞌrek lon lung.” ");
INSERT INTO lmd_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Kwikkatheik akwongkenekin itti ukul wopul iponyi wonu itti wareko thiak maꞌri moppot ana ul ittïttïk woul ana ul ittïttïk woul wonoppan toKapik ana ul iangkene lon lothonceꞌret lon cik wꞌrak ana kwonu itti kwakkuttat ana nomaꞌri mꞌrapuruk kuroko nti ithio. ");
INSERT INTO lmd_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Kwerethe elli nci nokkït ana oPoththuruc onekat oIeccuo thocipit pellek akwikkat cik akwere naak. ");
INSERT INTO lmd_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Anaruk akka oIeccuo poprttakot cik akwokathakat ul iammakothok, akwaꞌrettat naPoththuruc itti, “Ollu ntokït kin, pul pothopulut. Ngkwella lon loKapik ica cang anaruk ngkwonu lon loul ionyi.” ");
INSERT INTO lmd_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Akwakkarat cungkut coul ana ul iammakothok akwiꞌrekat kin itti, “Amma opilin pongothe itti kwamakothin kwonu itti kure noka kung akwoneko thapak thung akwomakothin. ");
INSERT INTO lmd_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Okkwi ipongothe itti kwaꞌret thikkoik thung, kuret cik anaruk okkwi ipurethe thikkoik thung cik nti ilon lin ana nti ilon iloporot loKapik, kwaꞌret. ");
INSERT INTO lmd_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ngintha akkoporot amma pul pothikkiet capu ncik appik cung ana kurethe calak cung cik? ");
INSERT INTO lmd_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ngintha akka apul okucitto ncalak cung? ");
INSERT INTO lmd_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Okkwi ipothianin cik ana othiane lon lin cik nti iul enni iaꞌro nul nuthuk ana tholon ilokithak, ukul wopul iponyi waꞌruminthok kït nothokkaprttako thung nthrïk thoththan ana nuꞌrupa wothothïlettat woKapik iupupure.” ");
INSERT INTO lmd_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Akwiꞌrekat kin itti, “Mpiꞌret non ilaik ïcat itti opilingon thꞌrek ithaik thacoꞌro cene thakannille aththik, akin tharthuk imma ngili ngoKapik aanthan mpuꞌran.” ");
INSERT INTO lmd_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Anakka kwikkot cik maꞌri mꞌrakkuruk akwipat oPoththuruc ana oIakup ana oIuanna akwoingkat kin ngngin thellek ci noꞌra wocoꞌrong. Ana kwoprttakatheik tokït ken nan. ");
INSERT INTO lmd_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ana eret wung wikkatheik allio thollio thapul pella pimet kret akolliat ittina nocapu ncik appik. ");
INSERT INTO lmd_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ana ncïnang oIlia ana oMucca ummat ncik tokït ken akin ikkat cik akin erene oIeccuo. ");
INSERT INTO lmd_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","APoththuruc omekat oIeccuo itti, “Pul ipangkene loporot itti oron thikkoik cene. Tun uno müꞌrük mꞌrapuruk, culukku cang ana culukku coMucca ana culukku coIlia.” ");
INSERT INTO lmd_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Kwommat ila akwiꞌre akka okin thaththonat nꞌre cannan. ");
INSERT INTO lmd_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Nci cïnang anuththe oꞌrumat kin apoꞌre akkakat nti inuththe apiꞌre itti, “Ukul win enni ia mpongothe, noccïkothok.” ");
INSERT INTO lmd_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Anakka okin tholliakotheik akin okinnimmakat pul pꞌrek, oIeccuo pulluk. ");
INSERT INTO lmd_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Anakka okin thokat cik akin uo ntan nnocoꞌrong, aIeccuo iꞌrekat kin itti okin thakanniꞌret pul pꞌrek ilakin thimmat puccuk aukul wopul iponyi urokat nti ithio. ");
INSERT INTO lmd_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Okin thangwathe lon len nomïkït men akin ere itti, “Ngintha akkonu itti, thuroko nti ithio?” ");
INSERT INTO lmd_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ana okin thipittathe itti, “Ngintha akka ul iangkene lon lothonceꞌret lon cik iꞌrene itti oIlia ponu itti kwanthan tokït naMiccie?” ");
INSERT INTO lmd_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","AIeccuo othïat tit itti, “Ii itti, oIlia panthan cittokït akwopakket lon cik appik. Ngintha akka lokurrakinet iatham itti ukul wopul iponyi wonu itti waccokot thiak cannan ana ul wꞌrak? ");
INSERT INTO lmd_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Anaruk mpiꞌret non, oIlia paat ana okin thokkwothok lon ilakin thaththongothe, ammakka lokurrakot alerethok.” ");
INSERT INTO lmd_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Anakka okin thainet ul iammakothok wꞌrek akin immakat cungkut coul iccik ken akin opllarot lon okin oul iangkene lon lothonceꞌret lon cik. ");
INSERT INTO lmd_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ana accokkot akka ul appik wimmat oIeccuo aprttakat tit cannan akin ollat taak othomiccok. ");
INSERT INTO lmd_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Akwipittat kin itti, “Ngintha akka onon opllarot nan anaththungon?” ");
INSERT INTO lmd_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Apul pꞌrek nti icungkut coul othïat tit itti, “Pul ipangkene, mponanung ukul win wauꞌrupa iokithak woꞌrot nan ana wakannokorronno itti were. ");
INSERT INTO lmd_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Amma uꞌrupa iokithak wen woꞌrot naak worrethok nocapu, kuꞌre pok nti ithon ana okꞌrellot kïnyït thocipit akwollat ikapa. Mpipittothe ul iammakothung itti okin thakïcce uꞌrupa iokithak wen ana okin thommakathe okïcce.” ");
INSERT INTO lmd_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","AIeccuo othïat tit itti, “Nantokatha ul enni iakorronno occokot lon loKapik nomïkït. Oron thikkoik uraththut manna kartha? Mparukot ilon lon manna kartha? Onanin ukul cene.” ");
INSERT INTO lmd_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Akin onakanthok ukul. Akka uꞌrupa iokithak wimmat oIeccuo alliekat ukul ikapa accokkot apat nocapu aththaththarakat, auꞌre pok nti ithon. ");
INSERT INTO lmd_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","AIeccuo ipittat oththan pokkul, itti, “Wonu maꞌri mornoththa akkot ittina?” Akwothïat tit itti, “Nci ammakka wotteik. ");
INSERT INTO lmd_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Uꞌrupa iokithak waarrethok ithik ana iꞌri appinappin itti wakkwothok. Anaruk amma oung akkakkot lon, ipi thiak thïn aittarot nïn.” ");
INSERT INTO lmd_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","AIeccuo iꞌrekat itti, “Amma oung akkakkot lon? Lon appik lathakkane pul lippappat amma poccokothe lon loKapik nocïkït.” ");
INSERT INTO lmd_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Aththan pokkul iꞌrekat accokkot mpoꞌre cittan itti, “Mpoccokothe lon loKapik nocïkït. Ittarothin anokïtto lon ila annokorronnon anoccokot lon loKapik nocïkït.” ");
INSERT INTO lmd_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Anakka oIeccuo pimmat cungkut acollo othokatha ilokkattathe, akwothirriekat uꞌrupa iokithak cik itti, “Uꞌrupa iammie ul nthon ana othikkiekin nuril, mpiꞌrenon itti, noppot thapat nti iaak, nokorronno appopakkot iaak caꞌri cꞌrek.” ");
INSERT INTO lmd_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Auꞌrupa iokithak ekat ngeme nti ikkul alliekat ikapa arrekat ukul nocapu appat thapat nti ikkul. Akul ikkat cik ere wiot. Aul woppot iꞌrekat itti, “Kwiot.” ");
INSERT INTO lmd_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Anaruk oIeccuo poccokathe ukun wung akurokwiekathok kapik acoꞌrat. ");
INSERT INTO lmd_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Anakka oIeccuo piꞌrikot noppan aul iammakothok ipittathok pellek itti, “Onïn thannokïcce uꞌrupa iokithak nti ikkul akaintha?” ");
INSERT INTO lmd_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Akwothïat tit itti, “Uꞌrupa iokithak ionu pangken empi wakïccetta ngaꞌrama tulluk.” ");
INSERT INTO lmd_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Akin oththekat nokaꞌran ken akin oingkat okko nocik coCelïl. OIeccuo pappakannangkot itti pul pꞌrek pina nakin thaik, ");
INSERT INTO lmd_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","akka kwokat cik akwongkene ul iammakothok. Akwiꞌrekat kin itti, “Ukul wopul iponyi waik wathokettat ul ionyi. Okin thakkwothok ana nomaꞌri mꞌrapuruk wuroko nti ithio.” ");
INSERT INTO lmd_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Anaruk okin thommat ila kwiꞌrethekin ana okin thonakathe nꞌre ipittothok. ");
INSERT INTO lmd_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Okin thakkakathe ciki nokaꞌran koKapprnaum. Akka kwokat noppan, akwipittat kin itti, “Ngintha akka onon thokat cik annopllarot ngngin ikathar?” ");
INSERT INTO lmd_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Anaruk okin thangkatheik akka okin thokat cik akin opllarot nokathar mai itti oththa akkrïk. ");
INSERT INTO lmd_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Akwikkat cik akwakkarat ul iammakothok iattul ana ikken keꞌra akwiꞌrekat kin itti, “Okkwi ipongothe itti kwathakka prïk, cittokït kwonu itti kwaka potteik ana orekine ul appik.” ");
INSERT INTO lmd_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Akwonekat ukul iotteik akwoceꞌrekat ithoꞌrkït then. Akwonekat nokapen akwiꞌrekat kin itti, ");
INSERT INTO lmd_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Okkwi ipikkiet opilin cik nti iakkwion enthi itharran ngkꞌran kin kwikkierin cik ana okkwi ipikkierin cik, kwaik pakinnikkien cik anaruk kwaik pikkie okkwi ipothïothin cik.” ");
INSERT INTO lmd_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","AIuanna iꞌrekathok itti, “Pul ipangkene, onïn thimmat pul pꞌrek apokïcce uꞌrupa iokithak ngkꞌran kang ana onïn thoceꞌrerok akka kwannoka ponnon.” ");
INSERT INTO lmd_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","AIeccuo iꞌrekat kin itti, “Nokorronno oceꞌrek. Pul pella ipakkot lon ilommaththik ngkꞌran kin ana nomaꞌri motte apapperethin llon ilokithak. ");
INSERT INTO lmd_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Akka pul ipakannꞌraron ook ponnon. ");
INSERT INTO lmd_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Mpappiꞌret non lon ilaik ïcat itti okkwi ipethet non keththeꞌret koiꞌri ngkꞌran kin akka onon ul woMiccie, kwakannuret thocco lon iloporot lung cik.” ");
INSERT INTO lmd_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Ana amma opilin pokorronnot okkwion itharran ithoccokothe lon lin ammakka enthi akin okkot lon ilokithak laka loporot itti kwarrettat irok irapangka ncna caꞌrettanok icalak. ");
INSERT INTO lmd_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Amma ukun wang wakorronnong akkot lon ilokithak, okiotheik akka loporot itti ngkwikkoik nukun wulukku nothona nyaun nyeꞌra ana ngkwaeo ngngnin ithik thothothïrïn ithomma io. ");
INSERT INTO lmd_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Na nangak inaꞌrko kin okorronno ille ana thik thakinnio. ");
INSERT INTO lmd_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ana amma wek wang wakorronnong itti ngkwakkot lon ilokithak, okiotheik akka loporot itti ngkwikkoik ponu wek wulukku nothona tacok teꞌra ana ngkwarrettat ngngin ithik thothothïrïn. ");
INSERT INTO lmd_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Na nangak inaꞌrko kin okorronno ille ana thik thakannio. ");
INSERT INTO lmd_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ana amma cït cang cakorronnong itti ngkwakkot lon ilokithak, onthotheik nti ica akka loporot itti ngkwaeo ingili ngoKapik ncït culukku, nothona kït keꞌra ana ngkwarrettat ngngin ithik thothothïrïn. ");
INSERT INTO lmd_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","‘Na nangak inaꞌrko kin okorronno ille ana thik thakannio.’ ");
INSERT INTO lmd_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Onon appik thathikkietta thoꞌrillir nthik. ");
INSERT INTO lmd_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Nguculoththu ngoporot anaruk amma ngothakkat ngocalang, ngappothikkietta ngira taththa? Nikkoik thoꞌrillir tokït koKapik ana oka ilon iloporot noulon ithun.” ");
INSERT INTO lmd_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","OIeccuo poththekathe nokaꞌran ken ana kwoingkathe nocik coIouthia ana arrot cik Iürüthün. Acungkut coul appakkakat naak attang ana kwongkenekathekin ammakka appinappin. ");
INSERT INTO lmd_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ul wꞌrek woul woPriccin akkakat appennekkekathok nthipitto itti, “Locoꞌrotheik itti pul pathïo pari pungi?” ");
INSERT INTO lmd_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Akwothïanthet kin tit itti, “OMucca piꞌrethenon taththa?” ");
INSERT INTO lmd_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Akin iꞌrekat, itti, “OMucca pokorronnot itti pul ipocura pakurrine pul ipopari kaꞌrmacak kothothïako akwantothïok.” ");
INSERT INTO lmd_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","AIeccuo iꞌrekat kin itti, “Lokat akka mïkït mon mokat monthomat ana ittina oMucca pokurrinet non lon lothonceꞌret lon cik elli. ");
INSERT INTO lmd_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Anaruk nci nothokuꞌre capu ncik, ‘Kapik kokkothe pul ipocura ana ipopari.’ ");
INSERT INTO lmd_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Ilen akka pul ipocura oththene naththan ana onnan ");
INSERT INTO lmd_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ana okin aththuththeꞌra thathakka ka kulukku.’ Ittina okin thakannoka theꞌrarit anaruk okin thulukku pꞌrïn. ");
INSERT INTO lmd_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ittina ila Kapik kokottothe apul ella ipillorit.” ");
INSERT INTO lmd_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Anakka okin thappropakkot tuan, aul iammakothok ipittathok lon len. ");
INSERT INTO lmd_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Akwothïat tit itti, “Okkwi ipothïot pari pung ana akwappipo apꞌrek kwaik paꞌro nnul iari ittat. ");
INSERT INTO lmd_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ana amma pul ipopari pothïot olle ana akwothitta napꞌrek kwaik paꞌro ul iomura ngngin ionu ari.” ");
INSERT INTO lmd_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ul wokat cik annane oIeccuo nyukul inyarran itti akwathonekket nyaun nakin anaruk ul iammakothok wikkatheik aꞌretto nakin. ");
INSERT INTO lmd_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Anakka oIeccuo pimmat elli akuakat ka. Akwiꞌrekat kin itti, “Nokorronno nyukul inyarran anyainin, nokorronno oceꞌrekin akka ngili ngoKapik ngoul iammakka enni. ");
INSERT INTO lmd_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Mpiꞌret non ilaik ïcat itti okkwi ipannocco ngili ngoKapik ammakka nyukul inyarran, kwanniꞌrikorit.” ");
INSERT INTO lmd_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ana kwonakathe nyukul thocarak cung akwonekkekat nyaun nakin akwethïekat kin. ");
INSERT INTO lmd_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Akka oIeccuo purokot akweo, apul pꞌrek ollat taak apekat ungku ncik tokït kung apipittat itti, “Pul ipangkene ipoporot, ngintha akka anokkot aniot thikkoik thothupuththuput?” ");
INSERT INTO lmd_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","AIeccuo othïat tit itti, “Ngintha akka akkarinin itti pul ipoporot? Pul pella ipoporot, Kapik kulluk akkoporot pellek. ");
INSERT INTO lmd_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ngkwina lon ila Kapik kiꞌret itti, ‘Kirrnni okkwot pul, kirrnni aꞌro mpul ipittat, kirrnni omunye, kirrnni ere lon ngkarra, kirrnni okwïet, othianet onne ana oththe cik.’” ");
INSERT INTO lmd_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Apul pen iꞌrekat itti, “Pul ipangkene, mpokkothe elli appik nciki akka mpokat ampotte.” ");
INSERT INTO lmd_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","AIeccuo okathakathok akwongakathok akwiꞌrekat itti, “Laik lulukku langkwarthuk okkot, ngko athokette aꞌrupu wang iangkwonu appik aikket ul iella aꞌrupu cik ana ngkwipo thaꞌrthan tothiꞌrot, anthan antathomakothin.” ");
INSERT INTO lmd_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Nolon elli aroca topul oprttakat cik. Akwoingkat akua ka cannan akka kwokat papaꞌrthan. ");
INSERT INTO lmd_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","AIeccuo okathakat ul iammakothok ammrththakot cik akwiꞌrekat kin itti, “Lonthomat itti pul ipapaꞌrthan piꞌriko ingili ngoKapik.” ");
INSERT INTO lmd_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Aul iammakothok oprttakanthet lon lung anaruk oIeccuo pappiꞌrekat kin itti, “Nyukul nyin, thiꞌriko ingili ngoKapik thommaththik. ");
INSERT INTO lmd_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Lippappat itti thamla thakko icürük coipra nopul ipapaꞌrthan itti piꞌriko ingili ngoKapik.” ");
INSERT INTO lmd_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ul iammakothok woprttakatherit cannan akin erettarne itti, “Oththa akkaꞌrettat?” ");
INSERT INTO lmd_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","AIeccuo okathakat kin akwiꞌrekat itti, “Elli lonthomat nopul iponyi anaruk noKapik, lon appik lakannoka lonthomat.” ");
INSERT INTO lmd_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","APoththuruc iꞌrekathok itti, “Onïn thoththet naꞌrupu appik othakka itti anïn omakothung.” ");
INSERT INTO lmd_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","AIeccuo othïat tit itti, “Mpiꞌret non lon ilaik ïcat, okkwi ipoththet nokaman kung ana opangon ithomura ana ithari ana oththan ana onnan ana nyukul nyung ana opon, nti iaun ana nti ilon iloporot loIeccuo ");
INSERT INTO lmd_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","kwacco kaman koppot ana opangon ithomura ana ithari ana onnan ana nyukul ana opon ana thokkiettat thiak ana noluput ilanthan thikkoik thothupuththuput. ");
INSERT INTO lmd_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Anaruk ul woppot iaik tokït inenni wathoka thoceken ana ul woppot iaik thoceken inenni wathoka tokït.” ");
INSERT INTO lmd_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Okin thokat ikathar akin okuꞌrot nokaꞌran koUruccelim aIeccuo pokat tokït ken ana ul iammakothok oprttakat tit ana ul wꞌrek iokat ammakot kin wonat nꞌre, akwappakkarat ul iammakothok iattul ana ikken keꞌra thocipit akwappiꞌrekat kin ilaik lathainok. ");
INSERT INTO lmd_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Akwiꞌrekat itti, “Noccïkot, oron thaik thakuꞌrot nokaꞌran koUruccelim ana ukul wopul iponyi wakettat ul ittïttïk woul wonoppan toKapik ana ul iangkene lon lothonceꞌret lon cik. Okin thakkmak itti kwakkuttat akin ekathok ul iakonnoka woIouth, ");
INSERT INTO lmd_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","okin ithakkothok ngure ngngin ana othukkothok nguk, okkwekok ana okkwothok. Ana nomaꞌri mꞌrapuruk kwuroko nti ithio.” ");
INSERT INTO lmd_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","OIakup ana oIuanna nyukul nyoCepethi nyakkakanthok akin iꞌrekat itti, “Pul ipangkene, onïn thongothe itti ngkwittarot nïn.” ");
INSERT INTO lmd_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Akwipittat kin itti, “Ngintha akka onon thongothe itti mpakkinthet non?” ");
INSERT INTO lmd_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Akin othïat tit itti, “Kirrnni okkulukku nti ianïn akwikkoik thokkun wothothari wang ana opilin thokkun wothokure nothrïk thang.” ");
INSERT INTO lmd_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","AIeccuo iꞌrekat kin itti, “Onon thomma ilanon thaik thipitto, onon thïkko nti ikeththeꞌret ika anïkko ntiri thaccokot thiak itha mpaik pathoccokot nani ana manna occo mamuthie ima ampoccori?” ");
INSERT INTO lmd_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Akin othïat tit itti, “Ïï onïn thaccokot thiak.” AIeccuo iꞌrekat kin itti, “Onon thïkko nti ikeththeꞌret ika anïkko ntiri ana occo mamuthie ima mpoccori, ");
INSERT INTO lmd_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","anaruk thikkoik thokkun win wothothari ana manna wothokure oun akkakorronno iꞌre. Aꞌran enni woul wonekkettanthet kin cik.” ");
INSERT INTO lmd_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Manakka okin ithattul thoccïkothe elli akin uakat ka koIakup ana koIuanna. ");
INSERT INTO lmd_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","OIeccuo pakkarathekin tothun akwiꞌrekat kin itti, “Onon thina ul inako itti wanili noul iakonnoka woIouth nonu lon loul wen ikkun ana nili nen inïttïnïttïk narekiekin llon len. ");
INSERT INTO lmd_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Lakannoka ittina ianon. Okkwi ipongothe itti kwathakka prïk ianon kwonu itti kwarekine opangon thꞌrek, ");
INSERT INTO lmd_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ana okkwi ipongothe itti kwathakka cittokït kwonu itti kwathakka piak poul appik. ");
INSERT INTO lmd_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Akka manna oun ukul wopul iponyi wakannao itti wathorekakine anaruk itti wathoreko ana manna io othakka itti aelikko ul woppot nti ilon ilokithak.” ");
INSERT INTO lmd_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ittina akin akkakat nokaꞌran kAria. Anakka oIeccuo ana ul iammakothok ana cungkut coul thokat cik akin oththe nocik apul pꞌrek piꞌrimathe poccot kꞌran oPerththemaoc ukul woThthimaoc wokat cik aikkoik nocipit cokathar akwipittot ul aꞌrupu. ");
INSERT INTO lmd_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Akka kwoccïkothe itti oIeccuo poNaccir, akwikkat cik akwakkaro mpoꞌre cittan itti, “OIeccuo ukul woThauth ipi thiak thin.” ");
INSERT INTO lmd_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Akin erekat naak thoppot itti kwangkoik anaruk kwikkathik akwakkakkaro cannan itti, “Ukul woThauth ipi thiak thin.” ");
INSERT INTO lmd_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","AIeccuo ocoꞌrat akwiꞌrekat itti, “Nakkarok.” Akin akkarat pul ipiꞌrimathe, “Opoꞌrathan aurokot kapik, occiri, kwaik pakkarong.” ");
INSERT INTO lmd_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Akworrekat kret kung ika akwokuꞌrupakot nocipit akwirrat ntacok oine oIeccuo. ");
INSERT INTO lmd_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","AIeccuo ipittathok itti, “Ngintha akka ongkwongothe itti mpakkinthung?” Apul ipiꞌrimathe iꞌrekat itti, “Pul ipangkene, mpongothe itti mpimmaik.” ");
INSERT INTO lmd_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","AIeccuo iꞌrekathok itti, “Ngko, thoccokot lon loKapik nocïkït cang thothikkierung poporot.” Nci cïnang akwimmakat cik akwomakat oIeccuo nokathar ken. ");
INSERT INTO lmd_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Anakka okin okko ciki iccik koUruccelim okin thakkakathe nokaꞌran koPeththppaci ana koPeththania nocoꞌrong coCeththun, aIeccuo othïat ul weꞌra nti iul iammakothok, ");
INSERT INTO lmd_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","akwiꞌrekat kin itti, “Ngkonon nokaꞌran engkrïk tokït kon ana amma anniꞌrikorit, onon thiot ngeꞌringka iotte ngïꞌrïkakot ana ngarthuk arrakot tan annokꞌro annonanin cene. ");
INSERT INTO lmd_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ana amma pul pꞌrek pipittothenon itti, ‘Onon thaik thakꞌro ngeꞌringka iotte akaintha?’ anniꞌrethok itti, ‘Ili akkiꞌret itti onïn thathokꞌro ana kwathïot ntan accokkot.’” ");
INSERT INTO lmd_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Akin oingkat akin othiat ngeꞌringka iotte ngïꞌrïkakothe nocürük thapat ikathar. Akka okin thokꞌrot ");
INSERT INTO lmd_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","aul wꞌrek wokat cik acoꞌro cïnang ipittat kin itti, “Ngintha akka annokꞌrine ngeꞌringka iotte?” ");
INSERT INTO lmd_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Akin othïat tit ammakka oIeccuo piꞌrethekin ana ul wokorronnathekin akin eo. ");
INSERT INTO lmd_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Akka okin thonanet oIeccuo ngeꞌringka iotte akin ongkuꞌrupat eret nan wen neꞌringka iotte akwarrat tan akwikkat cik noret. ");
INSERT INTO lmd_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ul woppot wongkuꞌrupathe eret wen cik ikathar ana opilingon ongatho uꞌri wokira nti ipon akin ipot cik ikathar. ");
INSERT INTO lmd_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ana okkwion itheot tokït ana okkwion ithomakothekin thiꞌrekathe mpoꞌre cittan itti, “Athopira noka oka noKapik tothiꞌrot.” “Athethïetta oka nakkwi ipanthan ngkꞌran koIli!” ");
INSERT INTO lmd_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“Athethïetta oka nongili iaik nganthan ngongappa ponnon oThauth.” “Athopira noka oka noKapik tothiꞌrot.” ");
INSERT INTO lmd_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","AIeccuo iꞌrikat nokaꞌran koUruccelim ana kwoingkathe noppan toKapik. Akwokathaccekat aꞌrupu appik anaruk akka cik cokat ceot kwopakkathe nokaꞌran koPeththania okin oul wung iattul ana ikken keꞌra. ");
INSERT INTO lmd_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ngorrot ngen akka okin thokat cik akin oththe nokaꞌran koPeththania oIeccuo pokakathe piamat. ");
INSERT INTO lmd_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Akwimmakat pïcït natha nan akwoingkat akwothokathakat amma ponat nyukul nyen, akka kweot iccik ken akwokinniat papꞌrek nan anaruk natha nulluk akka okorronno oka thuput thopira itti partha. ");
INSERT INTO lmd_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ncïnang akwiꞌrekat pira itti, “Apul pella ipaꞌrko nyukul nyang nocaꞌri cꞌrek.” Aul iammakothok occïkat akka kwiꞌret. ");
INSERT INTO lmd_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Anakka okin thiꞌrikot nokaꞌran koUruccelim oIeccuo piꞌrikathe noppan toKapik ana kwokïccekathe okkwion ithokat cik akin okette aꞌrupu ana ithonat aꞌrupu icekerek ceneket. Kwongkuꞌrupathe uppuꞌrung cik woul iokat akucitto akucci ana orrok wokkwion ithokat akin okette mülükkür. ");
INSERT INTO lmd_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ana kwakanno okorronnat okkwion ithonat aꞌrupu iaketta akin okko noppan toKapik. ");
INSERT INTO lmd_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Anakka kwongkenet kin akwiꞌrekat itti, “Lokurrakot itti, ‘Man min makkarako itti man maꞌrama moul appik.’ Ana onon thothikkiet man moul wothuꞌran.” ");
INSERT INTO lmd_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ul ittïttïk woul wonoppan toKapik ana ul iangkene lon lothonceꞌret lon cik occïkat elli akin ikkat cik akin okwancot kathar ikakin okkwothok ngngin akka okin thapellenok, akka ul appik woprttakinthet thongkene thung tit. ");
INSERT INTO lmd_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Anakka cipin capot akin oingkat thapat nti icarak coman conokaꞌran koUruccelim. ");
INSERT INTO lmd_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ana ngïꞌrïmak akka okin thokat cik akin omakot kathar akin immakat pïcït apponthomat ncik ilaka len. ");
INSERT INTO lmd_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","APoththuruc okwarikat pira akwiꞌrekat oIeccuo itti, “Pul ipangkene, antokatha pira popïcït ipangkwattat ponthomat.” ");
INSERT INTO lmd_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","AIeccuo opakkekat tit itti, “Noccokot lon loKapik nomïkït. ");
INSERT INTO lmd_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Mpiꞌret non ilaik ïcat, amma opilin piꞌrethe coꞌrong enci itti, ‘Ngko arret ka kang irok irapangka,’ ana ella lon tit leꞌra nocïkït, anaruk ngkwoccokothe lon nocïkït itti ila ngkwiꞌret itti lathakka ana lakkattanthung. ");
INSERT INTO lmd_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ittina mpiꞌret non itti, ilanon thipittot ngngaꞌrama nonekket nomïkït itti nthiot ana lakanenon. ");
INSERT INTO lmd_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ana amma annocoꞌro annaꞌra ngaꞌrama anthonu lon lꞌrek nomïkït mon napilingon noccïkot kin othakka itti aththe pon porothiꞌrot occïkïnthet non lon lon ilokithak cakuruk.” ");
INSERT INTO lmd_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ana amma onon thakannoccïkïnthet kin lon ilokithak ilakin thokkinthet non, oththe pon pakannoccïkïnthet non lon lon ilokithak cakuruk. ");
INSERT INTO lmd_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Akin okkaprttakat nokaꞌran koUruccelim anakka oIeccuo pokat cik akwonyaro noppan toKapik, ul ittïttïk woul wonoppan toKapik ana ul iangkene lon lothonceꞌret lon cik ana ul ittïttïk woul akkakanthok. ");
INSERT INTO lmd_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Akin ipittathok itti, “Ngngili ngiatha ingakkot llon elli? Ana oththa akkethung ngili itti ngkwakkot elli?” ");
INSERT INTO lmd_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","AIeccuo opakkekanthet kin tit itti, “Mpipittot non lon lulukku. Nothïnthin tit ana mpakenenon itti ngngili ngiatha akka anokkot nelli. ");
INSERT INTO lmd_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Mamuthie moIuanna mokat nnoKapiki ana amma okorronno oka nnoKapik ana noul ionyi? Niꞌrethin.” ");
INSERT INTO lmd_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Akin erekat thellek akin iꞌrekat itti, “Amma oron thiꞌret itti, ‘NoKapik’ kwipittot ton itti, ‘Ana onon thonin akka nthꞌrat occokot lon lung nomïkït mon?’ ");
INSERT INTO lmd_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Anaruk oron thakinniꞌre itti, ‘Noul ionyi.’” Okin theret elli akka okin thonat nꞌre noul akka ul winat itti oIuanna pokat pul pothernte lon loKapik ïcarïcat. ");
INSERT INTO lmd_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Menik akin othïanthet oIeccuo tit itti, “Onïn thomma.” AIeccuo iꞌrekat itti, “Oun cakuruk pakanniꞌret non itti ngngili ngiatha akka anokkot nelli.” ");
INSERT INTO lmd_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Nci cïnang kwikkatheik akwerenekin okkwienekin lon kuru cik itti, “Pul pꞌrek pokat cik pocïkkarot kira komaa ikkwon kung apuꞌrakat nan ana kwokkanthet kaꞌran na akwathuꞌrukot ngꞌri ngen ana kwapprunat kaꞌran na pul ikkoik apangwot maa. Akwekat ul wꞌrek ara tit aikkethok maa nnan imakin thorat amma okin thokiot. Ana kwoingkathe nokurtti. ");
INSERT INTO lmd_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ana nocaꞌri cothokio akwothïanthet ul iara wen pul pung iparekinok itti pathaꞌrntot aꞌrupu nakin ioꞌriat. ");
INSERT INTO lmd_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Anaruk okin thoccokathok akin okkwekathok akin opakkekathok nyaun ncürük. ");
INSERT INTO lmd_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Akwothïanthet kin pul ipareko pꞌrek akin okkwat ci ca ana okkiet thiak lon lokithak. ");
INSERT INTO lmd_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Akwappothïat apꞌrek icci, akin okkwat opaththi pen. Akwappothïat opilingon thoppot, akin okkwekat opilingon ana ongwo opilingon. ");
INSERT INTO lmd_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Akwokwentakanthet pul pulukku ipa akwothïot, ukul wung ia kwongothe. Ana kwothïathe ukul wung pꞌrïn ocothot akwopri okin thathiane cik akka ukul wung. ");
INSERT INTO lmd_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Anaruk ul woropon werekathe ithun itti, ‘Ook empi ipapakkot naꞌrupu woththan ton okkwothok ana aꞌrupu wung wathakka wonnon.’ ");
INSERT INTO lmd_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ittina okin thonekathok akin okkwathok akin orrekathok thapat nti ikkwon. ");
INSERT INTO lmd_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ngintha akka pul pokkwon okkot? Kwanthan akwongwo ul worikkwon akwethet ul wꞌrek kopon. ");
INSERT INTO lmd_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Onon thakorronno akkakkaro lon ilaik iatham woKapiki? Liꞌre itti, ‘Pothok ipa ul iuno wꞌrat nti ipangken pothakkakathe cillang icaceꞌret kunthong tan. ");
INSERT INTO lmd_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ili wokkothe elli ana loprttakietheron tit.’” ");
INSERT INTO lmd_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Okin thokat thongothe itti okin thaccokothok akka okin thinat itti thokkwie lon kuru ncik, thokat cik atheret kin. Anaruk okin thonat nꞌre nocungkut coul ana okin thoththekathe naak ana okin thoingkathe. ");
INSERT INTO lmd_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ana nomaꞌri motte, akin othïat ul wꞌrek woPriccin ana ul iongothe lon loIruthuc itti wathïꞌrak llon. ");
INSERT INTO lmd_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Okin thakkakanthok akin iꞌrekat itti, “Pul ipangkene, onïn thina itti oung pul ipiꞌre lon ilaik ïcat ngkwella nꞌre nopul iponyi, ngkwakannokkwine lon loul kunu ncik itti okin okkwengon, anaruk ngkwangkene lon ilaik ïcat ammakka Kapik kongothe. Locoꞌrotheik itti oKkaiccer paꞌrntakinthet akucci? ");
INSERT INTO lmd_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Onïn thaꞌrintinthoki, onïn thakannaꞌrintinthoki?” Anaruk aIeccuo inakat itti okin thongothe itti okin thaccokothok llon len, akwiꞌrekat itti, “Ngintha akka annenekkene itti onon thaccokinthin? Nantokenen thinar anokatha.” ");
INSERT INTO lmd_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Akin onakat kakucci akwipittat kin itti, “Purrut poththa empi? Ana kꞌran koththa engki?” Akin othïat tit itti, “poKkaiccer.” ");
INSERT INTO lmd_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Nci cïnang aIeccuo iꞌrekat kin itti, “Nethet oKkaiccer aꞌrupu woKkaiccer ana woKapik annethet Kapik.” Ana okin thoprttakatherit naak. ");
INSERT INTO lmd_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ittina aul woCcathukkin iame itti thuroko nti ithio thellaik akkakanthet oIeccuo nthipitto. ");
INSERT INTO lmd_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Akin ipittat itti, “Pul ipangkene, oMucca pokurrinet nïn itti amma opang popul piot nopari ana pella nyukul, opang ponu itti kwapakkot nan akwokwonine opang ipiot nyukul. ");
INSERT INTO lmd_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Caꞌri cen ul wꞌrek wokat cik weꞌreꞌrapuruk woththan pulukku. Okkwi iprïk pipot pari akwiat, akkwella nyukul. ");
INSERT INTO lmd_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ana akkwi ipomakothok opakkat nopari ana kwiathe cakuruk akkwella ukul lokakathe menik napang ipomakothe. ");
INSERT INTO lmd_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Nti iul ieꞌreꞌrapuruk ionu oththan pulukku, opilin pellat ipokwonot ukul nti ipul ipopari. Ana pul ipopari piathe acakuruk. ");
INSERT INTO lmd_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Nocaꞌri cothuroko nti ithio pari paka poththa nti iakin? Akka pokat pittat nnul weꞌreꞌrapuruk.” ");
INSERT INTO lmd_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","AIeccuo othïat tit itti, “Onon thommaik akka onon thomma lon latham wopuꞌran poKapiki? ");
INSERT INTO lmd_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Amma okin ithillet thurokot nti ithio okin thakannipo ana okin thakinnitta, okin thaka ere uꞌrupa wothothïlettat woKapik tothiꞌrot. ");
INSERT INTO lmd_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ana nolon lothuroko nti ithio onon thakannakkakkaro lon lokerung kopira ipokat apokꞌro iatham woMuccai akka Kapik kiꞌrethok itti, ‘Oun Kapik kApreim ana Kapik koIccaak ana Kapik koIakupi’? ");
INSERT INTO lmd_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Kwakannoka Kapik koul illet, anaruk Kapik koul iaik ngkït thapat. Onon thamoloko cannan.” ");
INSERT INTO lmd_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Apilin nti iul iangkene lon lothonceꞌret lon cik loKapik akkakat akwoccïkat kin akin eret lon len. Akwinakat itti oIeccuo pothïnthet ul woCcathukkin tit papenang akwipittathok itti, “Nti ilon appik ilonekkettatheik ilonthomat loKapik, liatha akkoporot cannan?” ");
INSERT INTO lmd_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","AIeccuo othïat tit itti, “Elli akkoporot cannan, ‘Ul woIccereil, noccïkot Ili Kapik konnon, Ili wulukku. ");
INSERT INTO lmd_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ongathe Ili Kapik kang ncïkït cang appik ana ngka kang appik ana ngatheꞌre ngang appik ana mpuꞌran pang appik.’ ");
INSERT INTO lmd_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ana ilamakot liꞌre itti, ‘Ongathe ul wꞌrek ammakka ngkwongothe ka kang.’ Lella iloporot cannan nelli aluleꞌra.” ");
INSERT INTO lmd_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Apul ipangkene lon lothonceꞌret lon ncik othïat tit itti, “Loporot pul ipangkene, lon lang laik ïcat itti Kapik kulukku ana akꞌrek kella, anaruk ook pulluk. ");
INSERT INTO lmd_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ongathok ncïkït cang appik ana ngatheꞌre ngang appik ana mpuꞌran pang appik, ana ongat ul wꞌrek ammakka ngkwongothe ka kang ilen akkoporot cannan naꞌrupu appik iokꞌrettanet Kapik ana aꞌrupu wothokinthet Kapik ngüccük cik.” ");
INSERT INTO lmd_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Anakka oIeccuo pimmat itti kwothïotherit nthinaik nti ica, akwiꞌrekathok itti, “Ngkwakannoka ciththan nongili ngoKapik.” Ana nci cïnang ul wꞌrek wellakathe itti wappipittothok lon lꞌrek. ");
INSERT INTO lmd_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Anakka oIeccuo pokat cik akwongkene noppan toKapik, kwipittathe itti, “Taththa akka ul iangkene lon lothonceꞌret lon cik iꞌrene itti oMiccie ukkul woThauth? ");
INSERT INTO lmd_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","OThauth ngka kung peret ngKanang ikupupure itti, ‘Ili Kapik wiꞌrethe Ili win, Ikkik thokkun wothothari win puccuk anonekkekat thoꞌrak thang thoceken coracok tang.’ ");
INSERT INTO lmd_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","OThauth ngka kung pakkarot oMiccie itti, ‘Ili win’ ana tat akka akwoka ukul wung?” Cungkut coul coccïkathok okkwinok kunu ncik akin thopirat noka. ");
INSERT INTO lmd_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Akka kwongkenet kin akwiꞌrekat itti, “Noꞌrumoik noul iangkene lon lothonceꞌret lon cik okin thongothe itti okin thanyaro neret iukwirukwit ana omiccako keccuk ");
INSERT INTO lmd_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ana ikkoik naꞌran wothothiakine cik nomuththun maꞌrama ana nokamuthe. ");
INSERT INTO lmd_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Okin thammikkot muruma ana onnekot kin kaman ken ana aꞌra ngaꞌrama aul imma kin appik, ul ammakka enni wakkiettat thiak cannan.” ");
INSERT INTO lmd_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","AIeccuo pokat cik akwikkoik akwokathacce ul iannekket akucci nokaꞌran kothaꞌrntot akucci iaꞌrntakinthet ngre ngonoppan toKapik, ul iaꞌrthan woppot wonekkekathe akucci woppot. ");
INSERT INTO lmd_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Anaruk pul pꞌrek ipa curuma pakannoka papaꞌrthan pakkakathe aponekkekat akucci weꞌra wokït. ");
INSERT INTO lmd_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","AIeccuo akkarat ul iammakothok akwiꞌrekat kin itti, “Mpiꞌret non ilaik ïcat, pul empi ipa curuma ponekkethe akucci woppot cannan noul appik. ");
INSERT INTO lmd_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Okin thonekkethe nothaꞌrthan then, anaruk curuma enci icopari icella aꞌrupu cik conekkethe nnaꞌrupu ia kwonat appik, iarokat cik itti kwikkoik ngngin.” ");
INSERT INTO lmd_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Anakka kwokat cik akwoththe nokaꞌran konoppan toKapik, apilin nti iul iammakothok iꞌrekathok itti, “Pul ipangkene, antokatha, akka mothok imïttïmïttïk ana kaman kopeththere.” ");
INSERT INTO lmd_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","AIeccuo othïat tit itti, “Onon thimmat kaman engki ikïttïttïk appiki? Pothok pella pulukku pakwentako nopangken, müntat nocapu mulumuluk appik.” ");
INSERT INTO lmd_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Anakka oIeccuo pokat cik akwikkoik nocoꞌrong coCeththun icakatha noppan toKapik, oPoththuruc ana oIakup ana oIuanna ana Anthrauc ipittathok therek itti, ");
INSERT INTO lmd_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Iiꞌrethenïn itti lon elli lakaik acintha? Ana lon liatha ilakene itti lon elli lathokaik?” ");
INSERT INTO lmd_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","AIeccuo iꞌrekat kin itti, “Noꞌrumoik akka apilin ammikkot non. ");
INSERT INTO lmd_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Okin thoppot thanthan ngkꞌran kin akin iꞌre itti, ‘Oun oMiccie’ ana okin ammikkot ul woppot. ");
INSERT INTO lmd_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Nokorronno ona nꞌre amma onon thoccïkothe itti thoꞌrak thaik ana karra kothoꞌrak, lon ila ammakka elli lakaik anaruk caꞌri carthuk anthan. ");
INSERT INTO lmd_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ul nomoꞌrong mꞌrek aprttakot iul wonomoꞌrong mꞌrek ana ngili ngaprttakarot tit. Thaꞌrïntïttako thocapu ncik appik thakaik naꞌran woppot ana tï takaik. Elli laka ere thokꞌrellako thokkul iakwonta thonomun. Lon elli lakene itti lon ilaik lanthan lantruko ncik. ");
INSERT INTO lmd_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Onon thonu itti onon thaꞌrumoik. Onon thikkettat nili ana akin okkwet non nomuththun maꞌrama. Onon thanekittat tokït konili inarran ana inïttïnïttïk nti ilon lin. Anaruk loporot othakka itti annokenekin lon lin. ");
INSERT INTO lmd_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ana lon iloporot loIeccuo lonu itti langkenetta ul nomothok appik cittokït. ");
INSERT INTO lmd_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Amma onon thocciccokittathe ana onekittat imakkma, nokorronno ipo nꞌre itti onon thathiꞌre itti tat. Niꞌre lon ilettathenon nocaꞌri cen itti onon thiꞌre, akka onon akkakannoka thaik there, anaruk Kanang ikupupure. ");
INSERT INTO lmd_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ukul wakero opang akwokkuttat ana oththan pokkul okero ukul wung akkuttat. Nyukul nyaprttakot iaththangon akin okorronno kin akin ongutta. ");
INSERT INTO lmd_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ul appik wꞌranon nti ilon lin, anaruk okkwi ipoccokothe cïkït ilon puccuk mono alocothakat ana kwaꞌrettat.” ");
INSERT INTO lmd_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Amma onon thimmat lon lothokïttakoik lurokot nokaꞌran ika lon akkira akkakannoka nan (aul iakkakkaro iatham ina lon len) nokorronno okin ithaik noththok poIouthia akin ollot toꞌra womoꞌrong. ");
INSERT INTO lmd_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Nokorronno okorronno opilin ipaik toꞌra woman mung itti kuo ntan akwiꞌriko noppan itti kwummo papꞌrek. ");
INSERT INTO lmd_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ana okkwi ipaik topon akwokorronno opakkot tuan itti kwathummo kret kothongkuꞌrupakot. ");
INSERT INTO lmd_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Laka laraththa noul ioppeppethe ana iokwonot. ");
INSERT INTO lmd_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Naꞌra ngaꞌrama othakka itti alon elli okonnoka nothuput thoricpo, ");
INSERT INTO lmd_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","akka ul waccokot thiak cannan nomaꞌri men. Okin thaccokot thiak cannan nothiak ithakin thoccokothe ammakka Kapik kokuꞌret capu ncik, ana thoccokot thiak ammakka enthi thella pꞌrïn. ");
INSERT INTO lmd_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ana amma Kapik kakorronno orpet maꞌri men cik mothoccokot thiak, pul pella pakwentako. Anaruk nti ithocumorit thoul ia kwocumot tit, kwathikkienet kin muththumuththut. ");
INSERT INTO lmd_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ana nocaꞌri cen amma opilin piꞌrethung itti, ‘Okatha oMiccie pei’ ana itti ‘Okatha okkweꞌre ceneket,’ nokorronno occïkot lon len. ");
INSERT INTO lmd_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Akka ul wanthan iiꞌre itti okin oMiccie ngkarra ana ul wothernte lon loKapik ngkarra akkot lon ilommaththik akin ammikkot ul ngngin ana akin ammikkot manna ul ia Kapik kakkarot amma okin akkiothe kathar ikakin ammikkot kin ngngin. ");
INSERT INTO lmd_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ittina noꞌrumoik mperenet non lon appik acaꞌri cen carthuk anthan.” ");
INSERT INTO lmd_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Anaruk nomaꞌri imomakothe maꞌri mothiak ‘ngïꞌrïmak ngaꞌroik, ana kwanok kakannupuka ");
INSERT INTO lmd_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ana mothot mapukkwo ntothiꞌrot ana aꞌrupu worothiꞌrot waꞌrïntïttako ncik appik.’ ");
INSERT INTO lmd_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Caꞌri cen ul ionyi wimma ukul wopul iponyi anthan nti inuththe mpuꞌran ana nthïrïk. ");
INSERT INTO lmd_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ana kwathïot uꞌrupa wothothïlettat wung aꞌrntot okkwion ithakkarakot nnocapu ncik appik.” ");
INSERT INTO lmd_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Inenni nina lon lopira popïcït amma natha nopira popïcït iat ana anocokka, onon thina itti karran kakko napuththut. ");
INSERT INTO lmd_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ittina amma onon thimmat lon len alokkattat onon thina itti lon len laik napuththupuththut. ");
INSERT INTO lmd_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Mpiꞌret non ïcarïcat itti lon elli lakkattat appik aul enni inenni warthuk ille. ");
INSERT INTO lmd_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Tothiꞌrot ana capu thintat cik anaruk lon lin lakorronno intat cik aththik.” ");
INSERT INTO lmd_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Pul pella manna pina caꞌri cen ana cïngkï cen manna uꞌrupa wothothïlettat woKapik ci tothiꞌrot womma ana manna ukul ngka kung ukul acakuruk womma, oththan pulluk akkina. ");
INSERT INTO lmd_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Noꞌrumoik ana ikkoik ngkït thapat akka onon thomma itti caꞌri canthan acin. ");
INSERT INTO lmd_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Likkoik ere pul paik paeo imakkren, kwaththe nokaman kung, kwakwentot ul iarekinok iere ngen kurekkurek ana kwiꞌret pul ipangwot cik nocürük itti kwangwot cik. ");
INSERT INTO lmd_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ittina noꞌrumoik akka onon thomma itti pul poruan pakkaprttako ntan acin, cipini ana amma okorronno oka cipin ana thampang thongkꞌrai, ana manna athakꞌruk ooi ana manna ngïꞌrïmak nthuput thorrori? ");
INSERT INTO lmd_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Amma ook akkat omolittorit korronno okorronnok itti kwathiot non inthe. ");
INSERT INTO lmd_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ila aniꞌret non, mpaik mperene ul appik, ‘Noccot kït cik.’” ");
INSERT INTO lmd_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Anakka maꞌri mellat ncik meꞌra mokamuthe koThaurrot kaman kꞌrek cik ana kamuthe karrakith iella müꞌrükül tit, ul ittïttïk woul wonoppan toKapik ana ul iangkene lon lothonceꞌret lon cik wokat cik akwantot kathar nthuꞌran ikakin occokot oIeccuo ngngin akin okkwothok. ");
INSERT INTO lmd_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Akin iꞌrekat itti, “Anaruk okorronno oka nomaꞌri mokamuthe akka ul urokie camutta.” ");
INSERT INTO lmd_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Anakka oIeccuo pokat cik nokaꞌran koPeththania tuan topul ipoccot kꞌran itti oCcamaan iponat ïnyï noka, akwothïngkakot kriki kothokkun wothokure iccik kokuppuꞌrung akwoꞌrkoik, apul ipopari akkakat ncuꞌru caak iokkattathe noꞌren wamutha ionat cekerek coppot ana panyathe cuꞌru camutha ana punanthet oIeccuo ica. ");
INSERT INTO lmd_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ul wꞌrek iokat cik cinang wikkatheik aerettarne itti, “Ngintha akka ngaak ngamutha okïttakinthet cik? ");
INSERT INTO lmd_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ngaakettat nakucci woppot iekko akucci wothuput thulukku thopul iporekot aettat ul iaiak iella aꞌrupu cik.” Okin thothirriekathe pul ipopari cik kiththik. ");
INSERT INTO lmd_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","AIeccuo iꞌrekat kin itti, “Nokorronnok, thontha akka annattak? Kwokkinthin lon lopereththere. ");
INSERT INTO lmd_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ul iaiak iella aꞌrupu wꞌrek wanon thaik annaththungon appinappin ana nthittarot kin nomaꞌri ima nthongothe itti nthittarot kin. Anaruk mpakannoka unaththungon appinappin. ");
INSERT INTO lmd_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Kwokkothe ila kwekkot nan kwakkot. Kwunothe ngaak ngamutha noka kin acik carthuk othakka itti akwokuccenthet thocïkkako thin cik. ");
INSERT INTO lmd_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Mpiꞌret non lon ilaik ïcarïcat na lon iloporot loIeccuo ongkenettat nocapu ncik appik lon ila pul ipopari empi pokkothe lerettat cakuruk ana ul wakwarttikothok ngngin.” ");
INSERT INTO lmd_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ittina aIoutha Icikkariuththi opilin nti ipꞌrak ipattul ana ikken keꞌra oingkanthet ul ittïttïk woul wonoppan toKapik akwothokerot kin oIeccuo. ");
INSERT INTO lmd_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Nili nopirakathe noka akka okin thoccïkothe lon elli ana okin thonekkekanthet oIoutha lon cik itti okin thethok akucci. Ittina oIoutha pikkatheik akwokwancot kathar ika akwoccokiethok nili ngngin. ");
INSERT INTO lmd_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Nocaꞌri cocittokït cokamuthe karrakith iella müꞌrükül tit, ammakka thathuma thokat itti okin thakkwot thungkat thothokinthe Kapik papu poüccük cik, aul iammakothok ipittathok itti, “Ngkwongothe itti nthathokkinthung cik kartha nathoꞌrkot thuꞌrit thokamuthe koThaurrot kaman kꞌrek cik?” ");
INSERT INTO lmd_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ittina kwothïathe ul iammakothok weꞌra akwiꞌrekat kin itti, “Ngkonon nokaꞌran koUruccelim ana onon thacurot ipul ipocura aponneko thongkuꞌrong ngngꞌri tit annomakothok. ");
INSERT INTO lmd_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ana na akwiꞌriko, niꞌret pul poruan itti, ‘Pul ipangkene paik pipitto itti, Man min miatha imanïn athoꞌrkot thuꞌrit tit thokamuthe koThaurrot kaman kꞌrek cik nul iammakothin?’ ");
INSERT INTO lmd_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Kwakenenon man mïttïk maik toꞌra mokuccettanthet cik kicce. Nokkinthet ka konnon cik nan.” ");
INSERT INTO lmd_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Aul iammakothok oingkat aeo nokaꞌran koUruccelim akin othiat lon ammakka oIeccuo piꞌrethekin, akin okuccekat thuꞌrit thokamuthe koThaurrot kaman kꞌrek cik. ");
INSERT INTO lmd_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Anakka cipin capot aIeccuo akkakat nul wung iattul ana ikken keꞌra. ");
INSERT INTO lmd_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Manakka okin thokat cik akin othïngkakot iriki kothokkun wothokure iccik kokuppuꞌrung kothuꞌrit akin oꞌrkoik, kwiꞌrekathe kin itti, “Mpiꞌret non lon ilaik ïcat opilin nti ianon pakeron, okkwi ipanïn thaik thaꞌrkoik ïnaththeꞌra.” ");
INSERT INTO lmd_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Okin thakorronno okakat thoporot noka akin ikkat cik akin iꞌrekathok thuluk thuluk itti, “Atti okorronno oka oun?” ");
INSERT INTO lmd_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Akwiꞌrekat kin itti, “Opilin nti ianon ithattul ana ikken keꞌra. Okkwi ipanïn thaik thathapettot ngngucul nocaththak culukku ïnaththeꞌra. ");
INSERT INTO lmd_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ukul wopul iponyi wio ammakka lokurrakot iatham. Anaruk angkre nopul ipathoccokiet ul ukul wopul iponyi. Laakat loporot amma pul pen pokat pakannokwonta.” ");
INSERT INTO lmd_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Anakka okin thokat cik akin oꞌrkoik aIeccuo onekat arrakith akwopirakanthet Kapik noka akwomithat tit akwekat ul iammakothok akwiꞌrekat kin itti, “Nocco ka kin engki annoꞌrko.” ");
INSERT INTO lmd_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Akwonekat keththeꞌret akwopirakanthet Kapik noka akwekat kin ana okin thïkkathe nan appik. ");
INSERT INTO lmd_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Akwiꞌrekat kin itti, “Ngüccük ngin engi ngothonekket lon cik nguntanthet ul cik woppot. ");
INSERT INTO lmd_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Mpiꞌret non lon ilaik ïcat itti mpakannappïkko ngapak attang puccuk acaꞌri cen akkakat amma anïkko ingie ingili ngoKapik.” ");
INSERT INTO lmd_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Manakka okin thongwot kinye akin oppat thapat akin oingkat ci nocoꞌrong coCeththun. ");
INSERT INTO lmd_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","AIeccuo iꞌrekat, kin itti, “Onon appik thaththe naun, akka lokurrakot itti, ‘Mpakkwot pul ipuꞌre lungkat ana lungkat lapettakot cik.’ ");
INSERT INTO lmd_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Anaruk amma mpurokot nti ithio mpaeo tokït kon noththok poCelïl ana oron thincettot ceneket.” ");
INSERT INTO lmd_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","APoththuruc iꞌrekathok itti, “Okin thantoththe naung appik ana mpakorronno oththe naung.” ");
INSERT INTO lmd_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","AIeccuo iꞌrekathok itti, “Mpiꞌrethung lon ilaik ïcat itti athakꞌruk tharthuk oo ngkoꞌra engi maꞌri meꞌra ngkwacukkwo nolon itti ngkwoman maꞌri mꞌrapuruk.” ");
INSERT INTO lmd_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Anaruk oPoththuruc popakkekatherit itti, “Oun manna pantio iraththeꞌra mpakannocukko nolon itti mpomang.” Akin opakkekat tit menik appik. ");
INSERT INTO lmd_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Akin oingkat nokaꞌran koCaccimani, aIeccuo iꞌrekat ul iammakothok itti, “Nikkoik cene, anaꞌra ngaꞌrama.” ");
INSERT INTO lmd_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Akwipat oPoththuruc ana oIakup ana oIuanna thellek, ana kwakorronno okakat poporot noka cannan ana oka pïrrïn. ");
INSERT INTO lmd_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ana kwiꞌrekathekin itti, “Thiak thoꞌrothin cik cannan ere mpio. Nikkoik cene annoccot kït cik.” ");
INSERT INTO lmd_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Akwoingkat papotteik akwapat nocapu akwaꞌrakat ngaꞌrama itti, amma kathar akkokat cik acaꞌri enci cothoccokot thiak opaꞌroik naak. ");
INSERT INTO lmd_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Akwiꞌrekat itti, “Appa, ngappa pin, lon appik lippappat naung. Onekothin thoccokot thiak enthi, annoka ammakka mpongothe, anaruk ammakka ngkwongothe.” ");
INSERT INTO lmd_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Anakka kwokkaprttakinet ul iammakothok akwothiat kin akin thakko inthe. Akwiꞌrekat oPoththuruc itti, “Camaan, ngkwaik inthei? Ngkwakinnikkoik manna ngkït thapat cïngkï culukkui? ");
INSERT INTO lmd_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Noccot kït cik ana aꞌra ngaꞌrama othakka itti annokorronno apot ithennekketta. Cïkït congothe anaruk ka kokinyat.” ");
INSERT INTO lmd_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Akwappopakkat than akwaꞌrakat ngaꞌrama ammakka mai. ");
INSERT INTO lmd_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Anakka kwokkaprttakot, kwaththiat kin inthe attang, akka kït ken konat methe nan ana okin thommakathe lon ilakin iꞌrethok. ");
INSERT INTO lmd_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Akwokkaprttakat nocaꞌri icꞌrapuruk akwiꞌrekat kin itti, “Ntharthuk thaik inthei ana ongokoi? Mekkot pꞌrin, caꞌri caat. Nokatha, ukul wopul iponyi waik wathokettat ul wolon ilokithak. ");
INSERT INTO lmd_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Nuroko ureo, okkwi ipaik pathokeron peei paat.” ");
INSERT INTO lmd_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Anakka oIeccuo pokat cik akwere, aIoutha okkwi ipokat nti iul iattul ana ikken keꞌra akkakat. Kwokat ponat cungkut coul wonu iꞌrittang iukwit wukwit ana muꞌrang. Okin thothïlathe nul ittïttïk woul wonoppan toKapik ana ul iangkene lon lothonceꞌret lon cik ana ul ittïttïk woul. ");
INSERT INTO lmd_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Inenni okkwi ipathokeron pokenet kin itti, “Okkwi ipa anomicco ïꞌrïkothok topere, ook pen, annoccokothok annipothok ciththan annoꞌrumo naak.” ");
INSERT INTO lmd_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Anakka oIoutha paat akwoingkat iccik koIeccuo akwiꞌrekathok itti, “Pul ipangkene,” akwomiccathok ïꞌrïkothok topere. ");
INSERT INTO lmd_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ittina aul othakkarat iccik kung aꞌrumathok accokathok. ");
INSERT INTO lmd_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Anaruk opilin pokat akwocoꞌro pothathe kiꞌrittang ikukwit nti ikaꞌruk akwokiat pul iparekine pul iprïk ponoppan toKapik kunu cik. ");
INSERT INTO lmd_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","AIeccuo iꞌrekat kin itti, “Onon thaat niꞌrittang ana urrong itti nthathoccokothin ere pul pothuꞌrani? ");
INSERT INTO lmd_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Mpokat cik ianon appinappin anongkene ul noppan toKapik, ana onon thakorronno occokothin. Anaruk lon latham woKapik lonu itti lakkattat.” ");
INSERT INTO lmd_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Aul wung iammakothok ollat appik oththe naak. ");
INSERT INTO lmd_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ana pul pꞌrek pokuꞌrit pokat cunthut ana pokuꞌrupakothe kret noka tulluk appokat cik apommakot oIeccuo. Akka okin thoccokothe pul pen, ");
INSERT INTO lmd_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","akret apat apoththekat nan apollat cunthut. ");
INSERT INTO lmd_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Okin thonekanthet oIeccuo pul iprïk ponoppan toKapik ana ul ittïttïk woul wonoppan toKapik appik ana ul ittïttïk woul ana ul iangkene lon lothonceꞌret lon cik waꞌrntakathe appik tothun. ");
INSERT INTO lmd_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","OPoththuruc pommakathok nciththan mono oingkat ciki ithaꞌrapak thokaman kopul iprïk ponoppan toKapik. Kwikkatheik ceneket akwïkot thik akin oul iangwot cik. ");
INSERT INTO lmd_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ul ittïttïk woul wonoppan toKapik ana cuththun coul woIouth ittïttïk appik wokat cik akwancot lon ilakin oruket oIeccuo ngngin othakka itti akin okkwothok anaruk okin thakanniat lon lꞌrek aththik. ");
INSERT INTO lmd_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Okin thoppot ithorukwethok ngkarra anaruk lon len lokat kurekkurek. ");
INSERT INTO lmd_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Apilingon urokat kapik, akin ikkat cik akin orukwethok ngkarra. Akin ere itti, ");
INSERT INTO lmd_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Onïn thoccïkothe akwere itti, ‘Mpakïtto man moKapik emmi imuntat nyaun nyoul ionyi ana nomaꞌri mꞌrapuruk mpuno amꞌrek imakannunta inyaun nyoul ionyi.’” ");
INSERT INTO lmd_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Lon lothorukwet ngkarra then manna thokat kurekkurek. ");
INSERT INTO lmd_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Apul iprïk ponoppan toKapik urokat kapik tokït ken, akwipittat oIeccuo lon itti, “Ngkwaik pakannothïnthet thorukwet tit itha ul enni waik warukwethung ngngini?” ");
INSERT INTO lmd_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Anaruk oIeccuo pangkatheik kwakanniꞌrekat lon lꞌrek. Apul iprïk ponoppan toKapik, appipittathok itti, “Oung oMiccie ukul woKapik ikanïn thaik thapirane noka pelleki?” ");
INSERT INTO lmd_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","AIeccuo iꞌrekat itti, “Ïï oun. Ana ngkwimma ukul wopul iponyi aikkoik thokkun wothothari wokkwi ipakorronno alkakot ana anthan nonuththe norothiꞌrot.” ");
INSERT INTO lmd_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Apul iprïk ponoppan toKapik illat kret kung akwokene thuaka thung, aiꞌrekat itti, “Oron thongothe ul immat lon ngkït arttot nan wothentha? ");
INSERT INTO lmd_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Onon thoccïkothe ila kwocungkot Kapik ngngin. Onon thiꞌre taththa?” Akin iꞌrekat appik itti kwonu itti kwakkuttat. ");
INSERT INTO lmd_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ittina apilingon ikkat cik akin othukkwothok nguk ana ïꞌrïkïkkothok kret toca akin okkwekok akin iꞌre itti, “Iꞌrethenïn mpuꞌran poKapik, oththa akkokkworung?” Ana ul iangwot cik wonekathok ana wokkwekathok. ");
INSERT INTO lmd_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Anakka oPoththuruc pokat cik parthuk ithaꞌrapak apilin nti iul iari iarekine pul iprïk ponoppan toKapik akkakat akwoppo cïnang. ");
INSERT INTO lmd_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Manakka kwimmat oPoththuruc akwïkot thik akwokathakathok papenang. Akwiꞌrekathok itti, “Oung cakuruk pokat annoIeccuo poNaccir.” ");
INSERT INTO lmd_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Anaruk akwocukkwat nan, akwiꞌrekat itti, “Mpomma lon ila ngkwaik peret.” Akwoingkat icürük thapat. ");
INSERT INTO lmd_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Anakka ukul iopari iareko wapprimmathok cïnang, appiꞌrekat ul iokat cik cïnang acoꞌro itti, “Opaththi empi ook opilin ntiakin.” ");
INSERT INTO lmd_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Akwappocukkat nan. Ana papotteik, akin ithokat cik akin ocoꞌro napuththut iꞌrekat oPoththuruc itti, “Ïcat oung opilin pen akka oung poCelïl.” ");
INSERT INTO lmd_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ittina kwikkatheik akwonane ka kung thattatta ana kwarrmakanthet kin itti, “Mpomma pul emprïk ipanon thaik theret.” ");
INSERT INTO lmd_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Nci cïnang athakꞌruk othikkiekat maꞌri meꞌra athoo, ittina oPoththuruc okwarikat ila oIeccuo piꞌrethok itti, “Amma thakꞌruk tharthuk oo maꞌri meꞌra, angkwacukko nan itti ngkwinan maꞌri mꞌrapuruk.” Akwokwarikat lon len akwikkat cik akwoo. ");
INSERT INTO lmd_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ana ngorrot ngïꞌrïmak ul ittïttïk woul wonoppan toKapik okin oul ittïttïk woul ana ul iangkene lon lothonceꞌret lon cik ana cuththun coul woIouth ittïttïk appik ïꞌrïkat lon akin ïꞌrïkïkkat oIeccuo akin onekanthok ili oPilaththoc. ");
INSERT INTO lmd_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","APilaththoc ipittathok itti, “Oung ili woIouthi?” AIeccuo othïat tit itti, “Laik ammakka ngkwiꞌret.” ");
INSERT INTO lmd_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Aul ittïttïk woul wonoppan toKapik orukwekathok llon loppot. ");
INSERT INTO lmd_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","APilaththoc appipittathok attang itti, “Ngkwaik pakannothïnthet ul enni tiri? Antokatha lon loronththa ilakin thaik thorukwethung ngngin.” ");
INSERT INTO lmd_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Anaruk oIeccuo pakannothïat tit aPilaththoc oprttakat tit. ");
INSERT INTO lmd_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ittina thathuma thokat cik nokamuthe koThaurrot kaman kꞌrek cik itti nili nelikko pul nti ikorrkkor ipa ul ipitto itti pelikkako. ");
INSERT INTO lmd_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ana pul pꞌrek pokat cik ikorrkkor ipoccot kꞌran itti oParapac akin oul ionu thukungkun ithokat thongwothe ul icamutta. ");
INSERT INTO lmd_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Acungkut coul akkakat acipittat oPilaththoc itti kwakkinthet kin ammakka akwokkettet appinappin. ");
INSERT INTO lmd_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","APilaththoc ipittat itti, “Onon thongothe itti mpelikkinenon ili woIouthi?” ");
INSERT INTO lmd_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Kwappina kicce itti ul ittïttïk woul wonoppan toKapik wokat wonanok oIeccuo akka okin thokat thua ka kung. ");
INSERT INTO lmd_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Anaruk ul ittïttïk woul wonoppan toKapik werekekathe ul itti akin ipittot oPilaththoc itti akwelikkinekin oParapac. ");
INSERT INTO lmd_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","APilaththoc ipittat kin attang itti, “Mpakkot taththa nopul ipa annakkaro itti ili woIouth?” ");
INSERT INTO lmd_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Akin iꞌrekat mpoꞌre cittan itti, “Nokkwethok nothapak.” ");
INSERT INTO lmd_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","OPilaththoc ipittat kin itti, “Akaintha ngintha akka kwokkothe pamoloko?” Anaruk okin thikkatheik akin okkot poꞌre cittan akin iꞌre itti, “Nokkwothok nothapak.” ");
INSERT INTO lmd_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","OPilaththoc pangkathe itti kwapirie ul noka ana kwelikkanthet kin oParapac. Akwothïat oIeccuo akwothopoko ana okkuttat nothapak. ");
INSERT INTO lmd_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ul irro wonekathe oIeccuo nokaꞌran koili ikrïk ana okin thakkarathe mungkut moul irro appik ");
INSERT INTO lmd_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Akin akiekathok kret kothlo ere maa ika nili ako, akin otheranthok tukwia tolï, akin akiekathok ica ere ili. ");
INSERT INTO lmd_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Akin ikkat cik akin akkakkarok itti, “Ili woIouth, taththa.” ");
INSERT INTO lmd_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Akin okkwekok ca ngkurrong ana othukkwothok nguk ana irrinok cik nungku akin innikot itti nthaꞌranok ngaꞌrama. ");
INSERT INTO lmd_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Anakka okin thocothothe okkothok ngure naak kicce okin thuekathok kret ikothlo ere maa akin akiekathok kret kung akin ipathok thapat akin othokkwethok nothapak. ");
INSERT INTO lmd_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ana ikathar akin ocurat iaCcamaan ponokaꞌran koKirin akkwokat oththan pAlekenther ana oRuppuc. Kwokat akwoppo cinang akwanthan nti ipira thapat akweo icarak coman ana ul irro wonekiekathok thapak mpuꞌran. ");
INSERT INTO lmd_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Akin onakat oIeccuo nokaꞌran ikoccot kꞌran itti Culucutha, (ilonu itti kaꞌran kokꞌrintil koca). ");
INSERT INTO lmd_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Akin oIeccuo ngapak ngonu aꞌrupu wꞌrek tit apiet thokꞌrellako thoka cik anaruk kwꞌrakathe. ");
INSERT INTO lmd_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ana okin thokkwekathok nothapak ana okin thillillathe iret wung nthokkwot moꞌrio nan akin okatha itti okkwen akkaneko kia. ");
INSERT INTO lmd_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Akka okin thokkwethok nothapak acïngkï cokkothe ukullacoꞌrin cocik corrot. ");
INSERT INTO lmd_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Lon ilakin thorukwethok ngngin lokurrakathe noꞌra wothapak itti, ILI WOIOUTH. ");
INSERT INTO lmd_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Okin thongwathe ul wothuꞌran nothapak weꞌra okin aththungon opilin thokkun wothothari ana opilin thokkun wothokure. ");
INSERT INTO lmd_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ana okin ithokat cik akin okkette cïnang thikkatheik akin ocungkok ana oꞌrïntïtto ma ana erenok itti, “Oung ipaik pathokïtto tupan toKapik auno nomaꞌri mꞌrapuruki? ");
INSERT INTO lmd_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Orpu ntan nnothapak aꞌret ka kang.” ");
INSERT INTO lmd_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ana cakuruk ul ittïttïk woul wonoppan toKapik ana ul iangkene lon lothonceꞌret lon cik nerettaranthet akin okkot ngure naak akin iꞌre itti, “Kwoꞌrethe ul wꞌrek anaruk kwomma oꞌret ka kung. ");
INSERT INTO lmd_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kirrnni aMiccie empi poIccereil orpo ntan nothapak othakka itti unimma unoccokot lon lung nomïkït.” Okin ithokkwettathe nothapak akin aththungon thikkatheik akin ocungkok cakuruk. ");
INSERT INTO lmd_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Anakka cïngkï angko ippa ngïꞌrïmak ngoꞌratheik nocapu ncik appik puccuk mono acïngkï okkat cꞌrapuruk cipin. ");
INSERT INTO lmd_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ana nocïngkï cꞌrapuruk cocipin cen aIeccuo eekat ngeme mpoꞌre cittan itti, “Eloi, Eloi, lama capakththani?” ilonu itti, “Kapik kin, Kapik kin ngkwoththet naun akaintha?” ");
INSERT INTO lmd_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Anakka ul wꞌrek iokat cik acoꞌro cïnang woccïkothe lon len okin thakanninakat lon len akin iꞌrekat itti, “Nokkwo kunu ncik kwaik pakkaro pul ipernte lon loKapik oIlia.” ");
INSERT INTO lmd_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Apilin ollat mono okwothonakat kret akwothapekat ngngapak ingor akwonekkekat nokwoꞌren akwekat oIeccuo itti kwïkko. Akwiꞌrekat itti, “Ntrun antokorronnok pellek unokatha amma oIlia anthan akworpethok cik nothapak.” ");
INSERT INTO lmd_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","AIeccuo othukat cokwa mpoꞌre cittan akwommottakat. ");
INSERT INTO lmd_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Akret ikapettoik konoppan toKapik illakat tit mprak weꞌra, ncik toꞌra mono uat ciki nocapu. ");
INSERT INTO lmd_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Anakka ili woul arrial ukuluk irro iokat cik acoꞌro tokït koIeccuo woccïkothe akka kwet ngeme ana akka kwiot akwiꞌrekat itti, “Ïcat pul empi pokat ukul woKapik.” ");
INSERT INTO lmd_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ul iari wꞌrek wokat cik, akathacceik nciththan. Ana nti iakin oMeriom moMacthelia, ana oMeriom onnan poIakup ipotte ana poIuccip, ana oCcaluma. ");
INSERT INTO lmd_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ul iari enni akkommakothok ana ittarothok akka kwokat noththok poCelïl. Ul wꞌrek iari wokat cik cakuruk woppot iomakothok ntan nokaꞌran koUruccelim. ");
INSERT INTO lmd_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Caꞌri cokat cik cothokuccekot cik (ilonu itti acaꞌri caCcepith carthuk anthan). Manakka cipin cokat cik acapo, ");
INSERT INTO lmd_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","oIuccip poRami ipokat iprïk icuththun coul woIouth ittïttïk ana ipokat cik akwoꞌrïkot ngili ngoKapik, poingkanthet oPilaththoc ella nꞌre akwipittathok kumi koIeccuo. ");
INSERT INTO lmd_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","OPilaththoc poprttakathe tit akka kwoccïkothe itti oIeccuo piot akwakkarat ili woul irro ana kwipittathok itti amma oIeccuo piot akkumman. ");
INSERT INTO lmd_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Anakka kwinat lon len noili woul irro itti oIeccuo piot akwekat oIuccip kumi koIeccuo. ");
INSERT INTO lmd_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ittina oIuccip pokerathe kret kie akwoꞌremethekathok ngngin ana kwaththocïkkathok ippu ipaꞌranthang pocuꞌrol. Akwothïat kaꞌraccak tocürük coppu. ");
INSERT INTO lmd_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","OMeriom moMacthelia ana oMeriom onnan poIuccip thimmakathe na kwocïkkakot. ");
INSERT INTO lmd_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Anakka caꞌri caCcepith ceot ncik, oMeriom moMacthelia ana oMeriom onnan poIakup ana oCcaluma thokerathe ngaak ngamutha itti okin thathoꞌro kumi koIeccuo. ");
INSERT INTO lmd_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ana ingïꞌrïmak nocaꞌri corokït nomaꞌri imeꞌreꞌrapuruk acïngkï coppot ana okin thokat cik nokathar akin eo thoppu, ");
INSERT INTO lmd_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","akin ikkat cik akin ipittararot itti, “Oththa akkapaꞌrenerit pothok cik noppu?” ");
INSERT INTO lmd_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Anaruk akka okin thokathat cik akin immakat pothok ipokat pïttïk appopaꞌrettat cik noppu. ");
INSERT INTO lmd_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Manakka okin thiꞌrikot ippu akin immakat pul pokuꞌrit pakot kret kipuk apikkoik nthokkun wothothari woul iari ana okin thipathe nꞌre. ");
INSERT INTO lmd_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Apiꞌrekat kin itti, “Nokorronno opelle. Onon thaik thakwancot oIeccuo poNaccir ipokkwuttathe nothapak, okkurokot nti ithio kwakannoka cene nokatha kaꞌran nakin thaththïcethok cik. ");
INSERT INTO lmd_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Anaruk ngkonon annothiꞌret ul iammakothok ana oPoththuruc ‘kwaeot tokït kon noththok poCelïl anon tharthuk eo nanon othimmathok ammakka kwiꞌrethenon.’” ");
INSERT INTO lmd_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Akin ikkat cik akin okkweka ana oprttakot tit akin oppat thapat akin ollat nti ippu ana okin thakanniꞌrekat opilin akka okin thonat nꞌre. ");
INSERT INTO lmd_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Anakka oIeccuo purokot ngïꞌrïmak nocaꞌri corokït conomaꞌri meꞌreꞌrapuruk kummanthet oMeriom moMacthelia ncik cittokït okkwi ipa kwokïccet uꞌrupa iokithak weꞌreꞌrapuruk ntit. ");
INSERT INTO lmd_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Kwoingkathe ana kwaththerekanthet kin ithokat akin oIeccuo ithokat ithemeru ana oo. ");
INSERT INTO lmd_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Anakka okin thoccïkothe itti oIeccuo purokot ana itti kwimmarok okin thakannoccokat lon len nomïkït. ");
INSERT INTO lmd_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Apotteik aIeccuo appummanthet kin theꞌra noul iokat cik ammakothok ngka prek, akka okin thokat cik akin onyaro icarak coman. ");
INSERT INTO lmd_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Okin thopakkathe akin erekanthet opilingon anaruk okin thakannoccokat lon len nomïkït. ");
INSERT INTO lmd_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Nomaꞌri motte aIeccuo ummanthet ul iammakothok iattul ana ikken culukku akin thokat cik akin oꞌrkoik, akwothirriekat kin cik akka okin thellat thoccokot lon nomïkït ana thonthomat mïkït men akka okin thꞌrat occïkot lon lokkwion ithimmarok akka kurokot ntit nti ithio. ");
INSERT INTO lmd_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Kwiꞌrekathe kin itti, “Ngkonon nocapu ncik appik annothongkene ul appik lon iloporot loKapik. ");
INSERT INTO lmd_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Okkwi ipoccokothe lon iloporot nocïkït ana occo mamuthie kwaꞌrettat ana okkwi ipakannoccokot lon iloporot nocïkït kwakkmako. ");
INSERT INTO lmd_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ana ul ioccokothe lon loKapik wakkot lon ilommaththik, okin okïcce uꞌrupu iokithak ngkꞌran kin ana okin there karru koul wꞌrek. ");
INSERT INTO lmd_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Okin thacciccokot inyil nyaun nyen ana ïkko ngee iokithak angokorronno okkot kin loꞌrek, okin thanekket nyaun noul iongo ana wathakka woporot.” ");
INSERT INTO lmd_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Anakka Ili oIeccuo perenet kin kwonekittakathe tothiꞌrot ana kwikkatheik thokkun wothothari woKapik. ");
INSERT INTO lmd_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Aul iammakothok oingkat athongkene naꞌran appik ana Ili worekathe akin aththungon ana kwokenekathe itti lon lung laik ïcat llon ilommaththik ilakin thokat akin okkot.");
INSERT INTO lmd_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Pangkin oThiappiloc, ul woppot wokurrot lon ana aꞌrupu iokat cik ïcat tokït konnon. ");
INSERT INTO lmd_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Okin thokurrot lon ammakka lerettanet nïn nul immat lon ncinomun ana okin ithongkenet lon loKapik. ");
INSERT INTO lmd_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ana inakka oun ngka kin pommakothe lon appik nci nomun kicce, mpongothe itti mpakurrot cene othettot cik kicce anokurrinung oThiappiloc pul iprïk, ");
INSERT INTO lmd_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","othakka itti aina anganna lon ilaik ïcat ila ngkwappongkenettat. ");
INSERT INTO lmd_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Nocaꞌri coIruthuc ili woIouthia, pul pꞌrek pokat cik ponoppan toKapik poccot kꞌran itti oCekkeria ipokat ikuthuk koul wonoppan toKapik wApia ana opari Alicepeth pokat cakuruk pothiki thoul wonoppan toKapik worikuthuk kArun. ");
INSERT INTO lmd_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Okin oththuththeꞌra thokat thoporot tokït koKapik ana nthoccokothe lon loIli appik iliꞌrettat ana nthoꞌrumot nolon ilamakittat papenang. ");
INSERT INTO lmd_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Anaruk okin thellat nyukul akka Alicepeth pokat papucung ana okin aththeꞌra thokat thukkwat. ");
INSERT INTO lmd_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Caꞌri cꞌrek caCekkeria pokat cik akwokkot ngre noppan toKapik ammakka ook pul ponoppan toKapik nocaꞌri cung icapinthok ");
INSERT INTO lmd_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","kwokat pummuntat nthokkwo moꞌrio ammakka thathuma thoul wonoppan toKapik thokat akweo noppan toIli akwothokꞌre ngaꞌra iokkunako amutha. ");
INSERT INTO lmd_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Anakka caꞌri caat cothokꞌre ngaꞌra iakkunako amutha, ul iaꞌra ngaꞌrama wokat cik waꞌrantakothe thapat aꞌra ngaꞌrama. ");
INSERT INTO lmd_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ittina auꞌrupa wothothïlettat woIli ummanthok ncik, acoꞌrat thokkun wothothari woruꞌrot tonoppan toKapik na ngaꞌra iakkunako ngokat akꞌrettat. ");
INSERT INTO lmd_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Anakka oCekkeria pimmat uꞌrupa wothothïlettat woKapik akwirrat tit akwipat nꞌre. ");
INSERT INTO lmd_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Anaruk uꞌrupa wothothïlettat woKapik wiꞌrekathok itti, “Cekkeria, kirrnni ipo nꞌre. Kapik koccïkothe ngaꞌrama ngang, opari pang Alicepeth pakwoninung ukul iocura ana ngkwaccie kꞌran itti oIuanna. ");
INSERT INTO lmd_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Kwapirieng noka ana ul woppot wapirane thokwonta thung noka ");
INSERT INTO lmd_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","akka kwaka prïk tokït koIli. Kwakannïkko ngapak ana Kanang ikupupure kaka naak nciki icarak connan. ");
INSERT INTO lmd_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Kwakkaprtto ul woIccereil woppot nti ilon ilokithak apakkinthet Ili Kapik ken. ");
INSERT INTO lmd_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ana kweo tokït koIli iKanang ikupupure ana puꞌran popul pothernte lon loKapik oIlia ana kwapakket mïkït moththan ponyukulon ikuꞌri nynyukul nyen, ana kwakkaprtto ul iokat wꞌrat lon ilocoꞌrotheik angkot lon lothina cik nti ica loul woKapik. Kwakuccenthet thanthan thoIli ul cik.” ");
INSERT INTO lmd_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","ACekkeria ipittat uꞌrupa wothothïlettat woKapik itti, “Mpina itti laik ïcat taththa? Mpukkwat ana opari pin pukkwat.” ");
INSERT INTO lmd_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Uꞌrupa wothothïlettat woKapik wothïanthok tit itti, “Oun oCepereil. Mpaik pacoꞌro tokït koKapik ana mpothïlathe anathiꞌrethung lon elli iloporot. ");
INSERT INTO lmd_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Anaruk inakka ngkworakket lon lin ilathokaik ïcat nocaꞌri cen, ngkwannere puccuk alon ila mpiꞌrethung othakkakat.” ");
INSERT INTO lmd_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Caꞌri cen ul wokat cik aꞌrïkot oCekkeria thapat aprttakot tit itti ngintha akka kwoccinet cik puccuk noppan toKapik. ");
INSERT INTO lmd_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Anakka kwoppothe thapat kwommakathe erenekin akwikat cik akwere nyaun akin inakat itti kwimmathe loꞌrek noppan toKapik anaruk kwoꞌrungkwathe pomma nthon. ");
INSERT INTO lmd_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Anakka maꞌri mung mothokkot ngre noppan toKapik momttathe kwopakkothe tuan. ");
INSERT INTO lmd_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Anakka lon len lomttathe ana nomaꞌri motte apari Alicepeth oppekathe ana kwikkatheik noppan anok ukuluk okorronno oppot thapat. ");
INSERT INTO lmd_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Kwiꞌrekathe itti, “Ili akkokkinthin elli, kokenerin thongat thung nomaꞌri emmi ana kwopaꞌrenin thothia cik thin tokït koul.” ");
INSERT INTO lmd_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Nokwanok ikꞌrakkuruk aKapik othïat uꞌrupa wothothïlettat wung ioccot kꞌran itti oCepereil ciki nokaꞌran koNaccir ikaik noththok poCelïl, ");
INSERT INTO lmd_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","nokkul ioiꞌre iakannaꞌrutta ngngin aththik woccot kꞌran itti oMeriom iokat wokkaccakinet pul ipoccot kꞌran itti oIuccip thiki thoThauth. ");
INSERT INTO lmd_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Uꞌrupa wothothïlettat woKapik woingkanthok aiꞌrekat itti, “Taththa okkwi ipa Kapik kongothe cannan, Ili waik naung.” ");
INSERT INTO lmd_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","OMeriom pipanthet lon len nꞌre akwoprttakanthet thomicco then tit. ");
INSERT INTO lmd_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Anaruk uꞌrupa wothothïlettat woKapik wiꞌrekathok itti, “Meriom, kirrnni ipo nꞌre, oung pul ipa Kapik kongothe. ");
INSERT INTO lmd_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ngkwappet ana ngkwakwono ukul iocura ana ngkwaccie kꞌran itti oIeccuo. ");
INSERT INTO lmd_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Kwaka prïk ana kwakkarako itti ukul wokkwi ipaik cittothiꞌrot. Ili Kapik wethok prrok poththan oThauth, ");
INSERT INTO lmd_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ana kwathakka ili wothiki thoIakup thupuththuput ana ngili ngung ngakannomttat thupuththuput.” ");
INSERT INTO lmd_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","AMeriom ipittat uꞌrupa wothothïlettat woKapik itti, “Elli lathakka taththa akka mparthuk poiꞌre ana mpomma pul ipocura?” ");
INSERT INTO lmd_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Auꞌrupa wothothïlettat woKapik othïat tit itti, “Kanang ikupupure kanthan naung ana puꞌran poKapik korothiꞌrot paka naung. Ilen akka ukul iakwonta nti iaung wakkarako itti ukul woKapik. ");
INSERT INTO lmd_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ana manna Alicepeth pokuꞌri kang poppethe ipa ul wokat cik aere itti kwokat pucung. Ana kwoppethe ponu anok wꞌrakkuruk. ");
INSERT INTO lmd_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Akka lon lella ilalkothe Kapik.” ");
INSERT INTO lmd_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","AMeriom othïat tit itti, “Oun pul iparekine Ili. Alothakkanin menik ammakka ngkwiꞌret.” Auꞌrupa wothothïlettat woKapik oththekat naak. ");
INSERT INTO lmd_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Caꞌri cen oMeriom purokathe akwiꞌrikittakat okuꞌrot nokaꞌran noththok poIouthia. ");
INSERT INTO lmd_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Akwoingkat tuan thoCekkerian akwomiccat Alicepeth. ");
INSERT INTO lmd_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Anakka Alicepeth poccïkothe poꞌre poMeriom aukul ikkat cik aurttuko nti icarak aKanang ikupupure oꞌrat nAlicepeth. ");
INSERT INTO lmd_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Akwiꞌrekat lon mpoꞌre cittan itti, “Oung akkethïettat nti iul iari appik ana ukul iathokwono wethïettat. ");
INSERT INTO lmd_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Turuk itti ngintha akka mpongakinthet ittina, itti onnan poIli painin? ");
INSERT INTO lmd_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Akka poꞌre pothomicco thang poꞌrorin iunu aukul ikkat cik aurttuko nthopira noka nciki icarak. ");
INSERT INTO lmd_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Pul pethïekothe cik ipoccokothe lon loKapik nocïkït ila Ili wiꞌrethung lathakka ïcat.” ");
INSERT INTO lmd_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","AMeriom iꞌrekat itti, “Mpopiranet Ili noka nci noucce win ");
INSERT INTO lmd_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ana kanang kin kopiranet Kapik noka akka ook pothoꞌret thin ");
INSERT INTO lmd_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","akka kwokwarikothin ipa piak pung. Inenni thiki enthi appik thakkaron itti pul ipa Kapik kethïetheik. ");
INSERT INTO lmd_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Akka okkwi ipakannalkakot pokkinthin lon lrïk kꞌran kung kupupupure. ");
INSERT INTO lmd_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Thiak thung thaine ul iothianok cik thiki thiki. ");
INSERT INTO lmd_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Kwokkothe ngre mpuꞌran pung ana kwopettothe ul cik iipot ka thoura ana iongothe lon loka ken. ");
INSERT INTO lmd_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Kworpethe nili cik nnorrok wen anaruk kwoꞌrumot noul ia ul wella kït ken. ");
INSERT INTO lmd_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Kwoththikiethe ul iamat naꞌrupu woppot ioporot anaruk kwothïlethe aꞌrthan ikathar nyaun incürük. ");
INSERT INTO lmd_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Kwittarothe piak pung iparekinok oIccereil, ana kwokwarikathe itti kwipo thiak thung. ");
INSERT INTO lmd_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ana ammakka kwonekkenthet Aprein ongappa ponnon lon cik ana thiki thung thupuththuput.” ");
INSERT INTO lmd_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","OMeriom pikkatheik okin Alicepeth anok wꞌrapuruk akwopakkat tuan thanung. ");
INSERT INTO lmd_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Anakka caꞌri cainet Alicepeth itti kwakwono akwokonat ukul iocura. ");
INSERT INTO lmd_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ul wonocürük ana kuꞌri kung woccïkathe itti Ili wipot thiak thung nthokkinthok lon iloporot ana okin thopirakathe noka okin aththungon. ");
INSERT INTO lmd_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Anakka ukul wothikkiet maꞌri mormor okin thakkakathe akin athokekkiet ana okin thokat thongothe itti okin thaccie kꞌran koththan itti oCekkeria ");
INSERT INTO lmd_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","anaruk onnan piꞌrekathe itti, “Aa, kwaccietta kꞌran itti oIuanna.” ");
INSERT INTO lmd_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Aul iꞌrekathok itti, “Pul pella nti ikuꞌri kang iponu kꞌran ammakka engki.” ");
INSERT INTO lmd_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ittina akin erekanthet oththan pokkul inyaun itti akwiꞌrekin itti ukul wacco kꞌran itti okkwen. ");
INSERT INTO lmd_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Akwipittat kuruthut akwokurrot nan itti, “Kꞌran kung itti oIuanna.” Aul oprttakat tit appik. ");
INSERT INTO lmd_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Nci cïnang athon thoththan pokkul anyat ana thuꞌre thung apprikat akwikkat cik akwere lon lothomereket Kapik. ");
INSERT INTO lmd_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ul wonocürük wipathe nꞌre appik ana ul wikkatheik aeret lon len appik naꞌran wonoththok poIouthia. ");
INSERT INTO lmd_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ana okkwion ithoccïkothe lon len thikkatheik akin oprttakot tit akin ipittarot lon itti, “Ukul enni wathothakka ngintha amma wocokkat?” akka ukun woIli Kapik wokat naak. ");
INSERT INTO lmd_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","AKanang ikupupure oꞌrat naththan oCekkeria akwikkat cik akwere lon ilanthan akwiꞌrekat itti, ");
INSERT INTO lmd_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Athopira noka oka noIli, Kapik koIccereil akka kwaat ana kwelikkot ul wung. ");
INSERT INTO lmd_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Kwonekkenthet ton pul cik mpuꞌran prïk pathoꞌret ton pothiki thoThauth. ");
INSERT INTO lmd_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ammakka kwiꞌrethe ul wothernte lon lung womaꞌrot. ");
INSERT INTO lmd_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Itti kwaꞌret ton nnothoꞌrak thonnon ana nti inyaun nyoul iꞌrat ton. ");
INSERT INTO lmd_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Okkwokenet ongappan thonnon thoporot ana nthoccot kït nothonekket lon cik thung ithupupure, ");
INSERT INTO lmd_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","thonekket lon cik itha kwonekketheik okin ongappa ponnon Aprein. ");
INSERT INTO lmd_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Itti kwakkieron cik nti inyaun nyothoꞌrak thonnon ana okwokorronnoron aron ella nꞌre. ");
INSERT INTO lmd_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ana oka thupupure ana thoporot tokït kung thupuththuput ammakka oron thaik.” ");
INSERT INTO lmd_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Ana oung ukul win, ngkwakkarako itti pul pothernte lon loKapik kocittothiꞌrot ngkwaeo tokït koIli akuccenthok kathar, ");
INSERT INTO lmd_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","atherene ul wung lon lothoꞌrettat itti laka nthoccïkarnthet lon ilokithak. ");
INSERT INTO lmd_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Elli akka Kapik konnon konu thiak thonnon. Ana nti ithiak enthi oMiccie paineron ntothiꞌrot ere cïngkï amma acoppo. ");
INSERT INTO lmd_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","OMiccie pathere lon ilaik ïcat ilaka ere kꞌran kocïngkï ikathocciene ul cik iaik iꞌrïmak ana ionu nꞌre nothille kwakkot lon elli itti akwipot ton ikathar kothikkoik thoporot tokït koKapik.” ");
INSERT INTO lmd_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ana ukul wokat cik acokka ana athakka wonthomat iKanang ikupupure, ana kwikkatheik ithampang ithonthomat puccuk mono akwummat ncik tokït koul woIccereil. ");
INSERT INTO lmd_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ana nomaꞌri men aIli oKkaiccer Akocoththoc othïat lon lonthoththomat itti ul appik iaik nomothok imaik inyaun nyongili ngoRoma wonu itti wakurro ꞌran wen iatham woIli woRoma. ");
INSERT INTO lmd_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Thokurro ꞌran enthi thocittokït akka oKirnioc pokat ili wonoththok poCcuria. ");
INSERT INTO lmd_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Aul appik oingkat naꞌran wen athokurro ꞌran wen. ");
INSERT INTO lmd_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ittina oIuccip poingkathe acakuruk nokaꞌran koNaccir noththok poCelïl akweo Peththelam noththok poIouthia nokaꞌran na Ili oThauth pokwontathe akka kwokat thiki thoThauth. ");
INSERT INTO lmd_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Kweot tentre akwothokurrot kꞌran kung akin oMeriom iponomittanthok itti kwittanok ana caꞌri cen oMeriom pappoppethe. ");
INSERT INTO lmd_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Anakka okin thokat tentre acaꞌri akkakat cokkul itti wakwonta ");
INSERT INTO lmd_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ana oMeriom pokwonathe ukul wung wonothire wocura ana kwoꞌremethekathe ukul ikret akwïcïekat cik iththuk nokuppuꞌrung ika aꞌrupu worua oꞌrko taco nan akka kaꞌran kakkellanet kin ikaman ika ul ikkoik tit nakucci. ");
INSERT INTO lmd_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ul iuꞌre aꞌrupu worua wꞌrek wokat cik ipira thapat ana okin thokat akin angwot aꞌrupu worua ngkoꞌra iccik kokaꞌran koPeththelam. ");
INSERT INTO lmd_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ana uꞌrupa wothothïlettat woIli wummanthet kin ncik ana kꞌran kothrïk thoIli occat nakin ana okin thipathe nꞌre cannan. ");
INSERT INTO lmd_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Anaruk uꞌrupa wothothïlettat woKapik wiꞌrekathekin itti, “Nokorronno ipo nꞌre. Mponanet non lon iloporot ana lakane ul appik. ");
INSERT INTO lmd_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Inenni nokaꞌran koThauth pul pokwontanet non ipaꞌret non, ook oMiccie Ili. ");
INSERT INTO lmd_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ana lon elli lakenenon ngok, onon thathiot ukul woꞌremethettat ikret ana wïcettatheik iththuk nokuppuꞌrung ika aꞌrupu worua oꞌrkot taco nan.” ");
INSERT INTO lmd_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ana accokkot, auꞌrupa wothothïlettat woKapik woppot akkakat ntothiꞌrot akin omereket Kapik akin iꞌre itti, ");
INSERT INTO lmd_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Thrïk thaine Kapik korothiꞌrot cittan ana alon oka loporot nocapu noul ia kwongothe.” ");
INSERT INTO lmd_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Anakka uꞌrupa wothothïlettat woKapik woththet nakin, wokuꞌrathe tothiꞌrot, ul iuꞌre aꞌrupu worua wikkatheik aerettine itti, “Ton eo ci Peththelam aron othokatha lon elli ilokkattathe ila Ili wiꞌretheron lon len.” ");
INSERT INTO lmd_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ittina okin thoingkathe akin iat oMeriom ana oIuccip ana ukul awïcatheik nokuppuꞌrung iththuk ika aꞌrupu worua oꞌrkot taco. ");
INSERT INTO lmd_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Anakka okin thimmat akin opettat lon cik lokkul ilakin thiꞌrettanet, ");
INSERT INTO lmd_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ana ul ioccïkothe appik woprttakatherit nolon ila ul iuꞌre aꞌrupu worua wiꞌrethekin. ");
INSERT INTO lmd_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Anaruk oMeriom poccokathe lon len appik nocïkït cung akwokwarttikot. ");
INSERT INTO lmd_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ul iuꞌre aꞌrupu worua wopakkathe amereket Kapik ana opirane noka nolon appik ilakin thimmat ana occïkot ana ilokat cik ïcat ammakka okin thiꞌrettathe. ");
INSERT INTO lmd_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Anakka oIeccuo pothikkiet maꞌri mormor ana nocaꞌri cothokekkiethok kwocciettakathe kꞌran itti oIeccuo kꞌran ika uꞌrupa wothothïlettat woKapik wethok akkwarthuk oppettat. ");
INSERT INTO lmd_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Anakka caꞌri cen caat cothonthukko ammakka lon lothonceꞌret lon cik loMucca liꞌret, oIuccip okin oMeriom thonekathe oIeccuo nokaꞌran koUruccelim akwothettat Ili. ");
INSERT INTO lmd_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ammakka lokurrakot ilon lothonceꞌret lon cik loIli itti, “Ukul wonothire iocura wonu itti wettat Ili.” ");
INSERT INTO lmd_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ana okin cakuruk thoingkathe itti okin thathethet Ili aꞌrupu wothokiot ngüccük cik ammakka lokurrakot ilon lothonceꞌret lon cik loIli, “Mülükkür meꞌra ana amma annoka mülükkür ana waka minthang meꞌra imarran.” ");
INSERT INTO lmd_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Caꞌri enci puꞌrek pokat cik nokaꞌran koUruccelim poccot kꞌran itti oCcamaan kwokat poporot tokït koKapik. Kwokat cik akwoꞌrïkot Kapik akoꞌret ul woIccereil ana Kanang ikupupure kokat naak. ");
INSERT INTO lmd_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Kanang ikupupure kakkiꞌrethok itti kwannio akkwarthuk imma oMiccie ipa Ili wonekkethe lon len cik. ");
INSERT INTO lmd_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Kwiꞌrikettat noppan toKapik mpuꞌran poKanang koKapik. Caꞌri ica oMeriom ana oIuccip thonat ukul oIeccuo noppan toKapik akwothokkattanthet lon lothathuma ammakka laik iatham wothonceꞌret lon cik. ");
INSERT INTO lmd_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","OCamaan ponekathe oIeccuo nokapen ana kwopirakanthet Kapik noka akwiꞌrekat itti, ");
INSERT INTO lmd_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Ili, ngkwoꞌrumot nolon lang ila ngkwokat ponekketheik ana inenni kirrnni piak pang apio appopirat noka. ");
INSERT INTO lmd_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Akka mpimmat ngkït kin pul ipa ngkwapponekketheik itti pathoꞌret ul, ");
INSERT INTO lmd_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ipa ngkwappokuccethe cik tokït koul appik. ");
INSERT INTO lmd_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Kwaka kꞌran ikacciene ul cik iannoka woIouth ana kwaka thrïk thoul wang woIccereil.” ");
INSERT INTO lmd_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","OIuccip ana oMeriom thoprttakatherit nolon ilerettathe ukul. ");
INSERT INTO lmd_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ittina aCcamaan pethïekathekin akwiꞌrekat oMeriom itti, “Ukul enni wakorronno ul woppot noththok poIccereil iꞌrarok akïtto ana woppot iongothe lon lung aꞌrungkot cik. Walon ilothïlathe nnoKapik ana ul woppot wꞌra lon lung. ");
INSERT INTO lmd_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Othakka itti alon inako nan ilamuꞌruttakot ncik nomïkït moppot ana thiak thethung cïkït icarak ere kiꞌrittang.” ");
INSERT INTO lmd_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Pul pꞌrek pokat cik pothernte lon loKapik Anna pul ipopari ukul woPanuil ponopothok pAccir. Kwokat cik pukkwat, kwikkot cik akin olle luput leꞌreꞌrapuruk akka okin thittettot ");
INSERT INTO lmd_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","anaruk olle piathe akwokwentakat curuma mono aluput othakkakat arrial wocoꞌrin ana ikken kocoꞌrin (84). Kwannokorronno noppan toKapik aththik anaruk kwokat cik akwaꞌraꞌra ngaꞌrama ngkoꞌra ana icïngkï, ocoꞌro nothuꞌrit ana aꞌra ngaꞌrama. ");
INSERT INTO lmd_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Caꞌri cen kwakkakanthet kin tokït ken akwekat Kapik thopira noka akwerekanthet ul lon lokkul appik iokat cik akin oꞌrïkot itti pul ipathoꞌret ul wonokaꞌran koUruccelim. ");
INSERT INTO lmd_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Anakka oMeriom ana oIuccip thokkothe lon appik ilonu itti lakkattat ammakka lon lothonceꞌret lon cik loIli, okin thopakkathe noththok poCelïl nokaꞌran ken koNaccir. ");
INSERT INTO lmd_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ana ukul wocokkakathe athakkakat wonthomat. Wokat winaik nti ica ana thoporot thoKapik thokat nan. ");
INSERT INTO lmd_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Lokat cik itti amma thuput thaat ithie oththan ana onnan thaeo nokaꞌran koUruccelim akin thokkot kamuthe koThaurrot kaman kꞌrek cik. ");
INSERT INTO lmd_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Anakka kwokkothe luput attul ana ikken keꞌra (12) akin oingkanthet kamuthe ammakka lokat cik. ");
INSERT INTO lmd_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Anakka kamuthe komttathe okin thurokathe akin opakkot tuan nokaꞌran koNaccir anaruk ukul woththettakathe nan thoceken nokaꞌran koUruccelim ana okin thommat nan. ");
INSERT INTO lmd_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Akin opri itti kwaik iul iakin thaik nokurtti, okin thoingkathe okkwot caꞌri culukku. Ittina akin ikkat cik akin okwancothok nokuꞌri ken ana napurukon. ");
INSERT INTO lmd_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Anakka okin thanniothok okin thopakkathe ciki nokaꞌran koUruccelim akin othokwancothok. ");
INSERT INTO lmd_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Anakka maꞌri mothakkat mꞌrapuruk akin okwancothok akin othiathok noppan toKapik akwikkoik ithoꞌrkït thoul iangkene akwoccïkot kin ana ipitto kin lon. ");
INSERT INTO lmd_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Okkwion ithoccïkothok thokat cik akin oprttakot tit nothinaik thung ana nothothïlet tit tholon lung. ");
INSERT INTO lmd_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Anakka oththan akin onnan thimmarok okin thoprttakatherit. Annan iꞌrekathok itti, “Ukul wïn, ngkwokkinthet nïn ittina akaintha? ïnthokat cik ïnokwancothung ïnoththe amïkït mellat ikarak.” ");
INSERT INTO lmd_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Aukul ipittat itti, “Ngintha akka anthokat cik annokwancinthin? Nthomma itti mponu itti mpaka toppan tongappai?” ");
INSERT INTO lmd_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Akin ommakat ila kwonu itti kwiꞌret kin. ");
INSERT INTO lmd_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ittina okin thoingkathe nokaꞌran koNaccir ana kwoccïkathe lon len. Anaruk onnan pangwathe lon len appik nocïkït cung. ");
INSERT INTO lmd_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ittina oIeccuo pocokkakathe, athinaik thung nti ica arttakot nan ana Kapik kongakathok ana ul cakuruk wongakathok. ");
INSERT INTO lmd_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ana noluput attul ana ikken ukuluk (15) longili woili irïk oThiperioc poKkaiccer wonoththok poRoma ana aꞌran appik. Ana caꞌri cen oPilaththoc oPunththioc pokat ili wonoththok poIouthia, ana oIruthuc oka ili cakuruk wonoththok poCelïl. Ana oPilippic opang poIruthuc pokat ili wonoththok poIththoria ana poThthïrïkinoththoc, ana oLiaccanoc oka ili iotte wonoththok poIpilina. ");
INSERT INTO lmd_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ana Anan ana oKiappa oka ul ittïttïk wonoppan toKapik caꞌri cen alon loKapik akkakanthet oIuanna ukul woCekkeria akwokat cik ithampang. ");
INSERT INTO lmd_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Kwoingkathe naꞌran iccik korue toÜrüthün appik akwerene ul lon lomamuthie akwiꞌret kin itti, “Nopaꞌrine lon ilokithak cik annocco mamuthie ana Kapik kaccïkïnthet non lon lon ilokithak.” ");
INSERT INTO lmd_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ammakka lokurrakot iatham wolon loIccaia pul pothernte lon loKapik itti, “Poꞌre popul paik pakkakkaro nti ithampang itti, ‘Nokuccenthet Ili kathar noceꞌrenthok athar cik. ");
INSERT INTO lmd_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Lupuꞌru lonu itti laꞌruntettat ana moꞌrong arppippithietta ana cik ica thorokokkok opeꞌriccakot cik Athar iompaꞌrot cik wanceꞌriettat cik ana athar ionu muꞌrol tit wapekietta. ");
INSERT INTO lmd_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ana thoꞌret thoKapik thaul ionyi imma appik.’” ");
INSERT INTO lmd_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","AIuanna iꞌrekat cungkut coul iaat itti wathocco mamuthie nti ikkun wung itti, “Nyukul nyoinyil enyrïk, oththa akkiꞌrethenon itti onon thallot thua ka thoKapik ithanthan? ");
INSERT INTO lmd_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Nokkot ngre iakene itti onon thopaꞌrinet lon ilokithak cik. Nokorronno omet kakon itti, ‘Onïn nyukul nyAprein.’ Mpiꞌret non itti Kapik kina oprtto mothok emmi cik amokakat nyukul nyAprein. ");
INSERT INTO lmd_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Nantoccïkot, pul ipathio ponekkethe kïnyït kocemeke nolaka lokira. Ana pira ipakorronno okwono nyukul nyoporot, pakeccat cik aporrettakat icꞌrot.” ");
INSERT INTO lmd_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Acungkut coul ipittat itti, “Ana ngimpen akka onïn okkot?” ");
INSERT INTO lmd_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","AIuanna othïat tit itti, “Okkwi iponu eret weꞌra akwethet okkwi ipellaik, ana okkwi iponu thuꞌrit kwonu itti kwakkot menik cakuruk.” ");
INSERT INTO lmd_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Aul iaꞌrntinthet nili akucci akkakat acakuruk itti wathocco mamuthie. Akin ipittat itti, “Pul ipangkene, ngintha akka ïnokkot?” ");
INSERT INTO lmd_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Akwiꞌrekat kin itti, “Nokorronno aꞌrntot akucci woppot nopangken ianthonu itti nthaꞌrnttot.” ");
INSERT INTO lmd_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ittina ul wꞌrek irro ipittathok itti, “Ana onïn thakkot ngimpen?” Akwothïat tit, “Nokorronno oththikot ul akucci ana okorronno ereket ul ngkarra. Noꞌrïkot akucci won tulluk iakin ethet non.” ");
INSERT INTO lmd_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ul wokat cik aꞌrïkot oMiccie itti kwanthan ana okin thokat akin oprttakot tit akin opri ikkre oIuanna akkaka oMiccie. ");
INSERT INTO lmd_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","AIuanna iꞌrekat kin appik itti, “Mpethet non mamuthie ngngꞌri, anaruk okkwi iponu puꞌran cannan nnaun panthan, mpakannekko nan manna itti mpakꞌro loꞌrak lowok wung. Kwethet non mamuthie ngKanang ikupupure ana nthik thothakkma. ");
INSERT INTO lmd_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ana akwokkwo ton nnomïl akwïꞌrekat akwollakat liccit akwummo imoporot akunot ittit ana ton akwokꞌre nthik ithakinnio aththik.” ");
INSERT INTO lmd_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ana oIuanna perekanthet ul lon loKapik loppot akwaꞌretto nakin itti okin thaprtto lon len cik. ");
INSERT INTO lmd_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Anaruk akka oIuanna paꞌrettot naIruthuc ili wonoththok poCelïl akka kwipot oIruthia pari popang ana nolon lꞌrek loppot ilokithak ila kwokkothe ");
INSERT INTO lmd_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ana oIruthuc papprarttat nolon ilokithak akka kwonekkethe oIuanna ikorrkkor. ");
INSERT INTO lmd_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Anakka ul wocceret mamuthie appik oIeccuo poccathe mamuthie cakuruk. Anakka kwokat cik akwaꞌra ngaꞌrama arothiꞌrot anyat. ");
INSERT INTO lmd_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","AKanang ikupupure uat ntan naak kungkot cülükkür. Apoꞌre akkakat ntoKapik apiꞌre itti, “Oung ukul win ia mpongothe ana mpopiranet noka.” ");
INSERT INTO lmd_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","OIeccuo ponat luput arrial ana attul (30) akka kwokuꞌret ngre ngung ncik tokït koul appik. Ittina ul wokat ame itti oIeccuo ukul woIuccip. OIuccip ukul wEli, ");
INSERT INTO lmd_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli ukul woMaththathath, oMaththathath ukul woLaui, oLaui ukul woMelekki, oMelekki ukul woIna, oIna ukul woIuccip, ");
INSERT INTO lmd_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","oIuccip ukul woMaththathia, oMaththathia ukul wAmoc, Amoc ukul woNaum, oNaum ukul wAcceli, Acceli ukul woNacai, ");
INSERT INTO lmd_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","oNacai ukul woMath, oMath ukul woMaththathia, oMaththathia ukul woCcamai, oCcamai ukul woCoccec, oCoccec ukul woIotha, ");
INSERT INTO lmd_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","oIoutha ukul woConan, oConan ukul woRecca, oRecca ukul woCerupapil, oCerupapil ukul woCcaliththil, oCcaliththil ukul woNiri, ");
INSERT INTO lmd_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","oNiri ukul woMelekki, oMelekki ukul wAthi, Athi ukul woKkuccum, oKkuccum ukul wAlmotham, Almotham ukul woÏr, ");
INSERT INTO lmd_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","oÏr ukul woCeccua, oCeccua ukul wEliacir, oEliacir ukul woIorim, oIorim ukul woMaththathath, oMaththathath ukul woLaui, ");
INSERT INTO lmd_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","oLaui ukul woCcomoun, oCcomoun ukul woIoutha, oIoutha ukul woIuccip, oIuccip ukul woConam, oConam ukul wAliakkim, ");
INSERT INTO lmd_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Aliakkim ukul woMalia, oMalia ukul woMinan, oMinan ukul woMaththatha, oMaththatha ukul woNathan, oNathan ukul woThauth, ");
INSERT INTO lmd_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","oThauth ukul woIecce, oIecca ukul wOpet, Opet ukul woPuac, oPuac ukul woCalmon, oCalmon ukul woNaccun, ");
INSERT INTO lmd_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","oNaccun ukul wAminathap, Aminathap ukul woRam, oRam ukul wAccrun, Accrun ukul woPparic, oPparic ukul woIoutha, ");
INSERT INTO lmd_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","oIoutha ukul woIakup, oIakup ukul woIccaak, oIccaak ukul wAprein, Aprein ukul woThthera, oThthera ukul woNaur, ");
INSERT INTO lmd_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","oNaur ukul woCcoroc, oCcoroc ukul woRau, oRau ukul woPalec, oPalec ukul wApir, Apir ukul woCcela, ");
INSERT INTO lmd_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","oCcela ukul woKinan, oKinan ukul wArppakaccath, Arppakaccath ukul woCcam, oCcam ukul woNua, oNua ukul woLamak, ");
INSERT INTO lmd_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","oLamak ukul woMiththuccila, oMiththuccila ukul wAnuk, Anuk ukul woCarit, oCarit ukul woMalalel, oMalalel ukul woKkinan, ");
INSERT INTO lmd_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","oKkinan ukul wAnuc, Anuc ukul woCceth, oCceth ukul wAtham, Atham ukul woKapik. ");
INSERT INTO lmd_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","OIeccuo ponat Kanang koKapik noka akka kwokkaprttakot nnorue irapangka toÜrüthün ana Kanang ikupupure kipathok ithampang ithonthomat ");
INSERT INTO lmd_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","na pul pothopulut pennekkethok than maꞌri arrial weꞌra (40). OIeccuo papponat maꞌri arrial weꞌra (40) akkwocoꞌrot nothuꞌrit icïngkï ana ngkoꞌra ana akka kwocothothe maꞌri mothocoꞌro nothuꞌrit, kwokakathe piamat. ");
INSERT INTO lmd_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Apul pothopulut iꞌrekathok itti, “Amma oung ukul woKapik, iꞌrethe pothok empi apothakka arrakith.” ");
INSERT INTO lmd_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","AIeccuo othïat tit itti, “Lokurrakot itti, ‘Pul iponyi pannikkoik narrakith tulluk.’” ");
INSERT INTO lmd_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Apul pothopulut apponekathok noꞌra wocoꞌrong ana accokkot apokenekathok ngili ncik appik ngonocapu. ");
INSERT INTO lmd_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Apiꞌrekathok itti, “Mpethung ngili engi appik ana thrïk then akka ngettathin ana mpethet pul ipa mpongothe itti mpethet ");
INSERT INTO lmd_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","ana amma ngkwaꞌranin ngaꞌrama ngili ngathakka ngang appik.” ");
INSERT INTO lmd_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","AIeccuo othïanthok tit itti, “Lokurrakot itti, ‘Aꞌranet Ili, Kapik kang ngaꞌrama arekanthok pellek.’” ");
INSERT INTO lmd_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Pul pothupulut ponekathok nokaꞌran koUruccelim ana noꞌra wonoppan toKapik, apul pothopulut iꞌrekathok itti, “Amma oung ukul woKapik orre ka kang nci cene. ");
INSERT INTO lmd_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Akka lokurrakot itti, ‘Kapik kathïot uꞌrupa wothothïlettat wung angwothung papenang. ");
INSERT INTO lmd_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ana waccinthung nyaun cik akka tacok okkwo mpothok.’” ");
INSERT INTO lmd_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","AIeccuo othïanthok tit itti, “Liꞌrettat itti, ‘Kirrnni enekke Ili, Kapik kang.’” ");
INSERT INTO lmd_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Anakka pul pothopulut pomarttot thennekke thung poththekathe naIeccuo itti kwappiothok caꞌri cꞌrek. ");
INSERT INTO lmd_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","OIeccuo popakkathe noththok poCelïl mpuꞌran poKanang ikupupure ana lon lung lopettakatheik appik itti kwaat noththok. ");
INSERT INTO lmd_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Kwongkenekathe nomuththun maꞌrama ana ul appik womerekekathok. ");
INSERT INTO lmd_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Kwoingkathe nokaꞌran koNaccir na kupokkothe ana nocaꞌri caCcepith kwiꞌrikathe nocuththun caꞌrama ammakka kwokat akwokkettet. Ana kurokathe kapik akwakkakkaro lon nti iatham. ");
INSERT INTO lmd_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Akin ekathok atham wopul pothernte lon loKapik oIccaia. Akwanyat akwiat kaꞌran ikokurrakot nan itti, ");
INSERT INTO lmd_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Kanang koIli kaik naun, akka kakkarorin anerene ul lon iloporot iella alpꞌrek. Kwothïothin anotherene ul iaik ikorrokkor lon lothelikkako ana anyinthet ul kït iꞌrimathe ana oꞌret ul iokwïettathe. ");
INSERT INTO lmd_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ana Kapik kothïothin anathiꞌre itti thuput thung thaat itha kwoꞌret ul wung nan.” ");
INSERT INTO lmd_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ittina akunukkwat atham, akwopakkekanthet pul ipethok akwikkat cik akwerenekin lon loKapik. Aul appik iokat cik nocuththun caꞌrama oceꞌrekat kït naak. ");
INSERT INTO lmd_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Akwiꞌrekat kin itti, “Lon latham enni inenni lothakkat ïcat ammakka nthoccïkothe.” ");
INSERT INTO lmd_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Aul ikkat cik aerethok lon loporot appik ana okin thoprttakathe tit nnolon iloporot ilaat nti ithon thung akin ikkat cik akin ipitto itti, “Okoronno oka ukul woIuccip enni?” ");
INSERT INTO lmd_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","AIeccuo iꞌrekat kin itti, “Mpina ïcat itti onon thiꞌrethin lon elli itti, ‘Pul ipittiet ul, ittiethe ka kang cittokït, okkothe lon cene nokaꞌran kang ilanïn thoccïkothe itti ngkwokkothe nokaꞌran koKapprnaum.’” ");
INSERT INTO lmd_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Akwoꞌrungkat nolon akwere akwiꞌrekat itti, “Mpiꞌret non lon ilaik ïcat itti pul pothernte lon loKapik pannoka pongakothe nokaꞌran kung. ");
INSERT INTO lmd_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Mpapakkenthet non tit itti muruma mokat cik moppot noththok poIccereil nocaꞌri copul pothernte lon loKapik oIlia ana noluput ilꞌrapuruk ana appꞌrut tï toꞌratheik noththok. ");
INSERT INTO lmd_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Icci oIlia pappannothïlanthet pul pꞌrek nti akin anaruk Kapik kothïothok nocuruma icokat nokaꞌran ikoccot kꞌran itti Carepath noththok poCcithon. ");
INSERT INTO lmd_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ana ul wokat cik woppot ionat ïnyï noka nocaꞌri copul pothernte lon loKapik, icci pul pellat nti iakin ipothikkiettat poporot oNaman ponoththok poCcuria tulluk.” ");
INSERT INTO lmd_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Anakka ul appik woccïkothe lon ila oIeccuo peret iokat nocuththun caꞌrama wuakathe ka. ");
INSERT INTO lmd_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Okin thurokathe akin othïathok thapat nti icarak coman akin onekathok noꞌra wocoꞌrong ica ul wokat wunot kaman othakka itti akwothorrettat nocapu ntan. ");
INSERT INTO lmd_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Anaruk kwokkathe icungkut coul akwoingkat. ");
INSERT INTO lmd_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ittina kuathe thaiken nokaꞌran koKapprnaum noththok poCelïl ana caꞌri cokat caCcepith ana kwikkatheik akwongkene ul. ");
INSERT INTO lmd_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Okin thoprttakanthet thongkene thung tit akka lon lung lonat lon longili tit. ");
INSERT INTO lmd_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Nocuththun caꞌrama cen pul pꞌrek pokat cik pauꞌrupa iokithak woꞌrot nan akwekat kuri cittan, auꞌrupa iokithak iꞌrekat nti iaak itti, ");
INSERT INTO lmd_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ee Ieccuo poNaccir, ngintha akka ngkwongothe nanïn? Ngkwaththopeꞌriccot nïn ciki? Mpina itti oung okkwen, oung ipupupure ipa Kapik kothïothe.” ");
INSERT INTO lmd_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","AIeccuo othirriekathok cik itti, “Angkik oppothe thapat nti iaak.” Ittina auꞌrupa iokithak orrekat pul nocapu tokït ken appik appat thapat nti iaak okorronno ipiek ka kongo. ");
INSERT INTO lmd_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ul appik woprttakatherit ana akin erettarne itti, “Thongkene thointha enthi? Ngili ana puꞌran, kwiꞌret uꞌrupa iokithak lon ana waccïkothok ana woppathe thapat.” ");
INSERT INTO lmd_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ana lon lung lopettakathe cik naꞌran appik nokaꞌran ken. ");
INSERT INTO lmd_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","OIeccuo poththekathe nocuththun caꞌrama ana kwoingkathe thoCcamaangon. Opïthe poCcamaan ipopari pokat pongo akwango ippa ana okin thipittathe oIeccuo itti kwittarothok. ");
INSERT INTO lmd_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ittina aIeccuo ikkat cik iccik kung akwothirriekat lü cik nti iaak alopaꞌrat cik. Kurokathe accokkot akwikkat cik akwokkinthet kin thuꞌrit. ");
INSERT INTO lmd_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Anakka cïngkï cokat cik acorungko, ul wonakanthet oIeccuo ul iongo mmio kurekkurek ana kwonnekkekathe nyaun nakin appik akwaꞌrakanthet kin ngaꞌrama ana okin thittakathe. ");
INSERT INTO lmd_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Uꞌrupa iokithak woppot woppopporekathe thapat nti iul mmpoꞌre cittan aiꞌre itti, “Oung ukul woKapik.” Anaruk oIeccuo pothirriekathekin cik ana kwakorronno okorronnat kin itti okin there akka okin thinarok itti ook oMiccie. ");
INSERT INTO lmd_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ana akka cik cokattot, oIeccuo poingkathe nokaꞌran pellek. Ul wokat cik akwancothok anakka waat na kwokat okin thikkatheik akin oꞌramittothok cik itti kwannoththe nakin. ");
INSERT INTO lmd_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Anaruk oIeccuo piꞌrekathekin itti, “Mponu itti mpere lon iloporot longili ngoKapik naꞌran wꞌrek acakuruk, akka ilen akka mpothïlanthet.” ");
INSERT INTO lmd_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ana kwikkatheik nocuththun caꞌrama noththok poIouthia akwere lon loKapik. ");
INSERT INTO lmd_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Caꞌri cꞌrek cokat cik aIeccuo pokat cik akwocoꞌro iccik korok irapangka toCeniccarth aul oꞌrntüttothok accïkot lon loKapik ");
INSERT INTO lmd_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Kwimmakathe uppuꞌrung wonoiꞌri weꞌra nokuthuthu korok irapangka aul iangwo ape woththet nan ana wokat cik aime loꞌrak iliꞌriththako nape. ");
INSERT INTO lmd_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Kwarrathe ikuppuꞌrung kulukku ikokat koCcamaan ana kwipittathok itti kwathothakkaret papotteik nokuthuthu korok irapangka ana kwikkatheik tit akwongkene ul. ");
INSERT INTO lmd_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Anakka kwomarttot lon kwiꞌrekathe oCcamaan itti, “Othakkarethe kuppuꞌrung konoiꞌri ipnan porok arret loꞌrok lape iꞌri aiꞌriththa ape.” ");
INSERT INTO lmd_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","ACcamaan othïanthok tit itti, “Pul ipangkene, onïn thorekot cannan nokkꞌrokkꞌra ana onïn thanniꞌriththa papꞌrek. Anaruk mparret loꞌrok laape iꞌri ammakka ngkwiꞌret.” ");
INSERT INTO lmd_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Anakka okin thorrethe loꞌrok iꞌri ammakka kwiꞌrethekin okin thiꞌriththakathe ape woppot aloꞌrok lape ikkat cik ere lammotta. ");
INSERT INTO lmd_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ittina akin akkarat opaththon then thꞌrek ithokat ikuppuꞌrung kꞌrek itti okin thanthan akin athittarot kin, akin akkakat akin oppeppekat ape uppuꞌrung aureꞌra aikkat cik ere wuo thoꞌronthong. ");
INSERT INTO lmd_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Anakka oCcamaan oPoththuruc pimmat menik akwirrat cik tokït koIeccuo akwiꞌrekat itti, “Opaꞌrik nti iccik kin, Ili, akka oun pul ipokithak.” ");
INSERT INTO lmd_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Akka ook ana opilingon ithakin thokat ithun thoprttakatherit nothiꞌriththa thaape iakin thiꞌriththat. ");
INSERT INTO lmd_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","OIakup ana oIuanna thokat nyukul nyoCepethi, okin thokat akin ongutte ape okin oCcaimon. Okin thoprttakatherit cakuruk. AIeccuo iꞌrekat oCcamaan itti, “Kirrnni ipo nꞌre nciki inenni ngkwaka pul pothiꞌriththa ul.” ");
INSERT INTO lmd_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ittina okin thothathe uppuꞌrung wonoiꞌri nomarkan morok irapangka akin oththekat naꞌrupu appik akin omakathok. ");
INSERT INTO lmd_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Anakka oIeccuo pokat cik nokaꞌran kꞌrek koricarak coman, apul akkakat cïnang ponat ïnyï noka. Akka pimmat oIeccuo apekat ungku ncik ana toca ncik apipittathok itti, “Ili, amma oung akkongothe ana ngkwittiethin.” ");
INSERT INTO lmd_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","AIeccuo othiekat ukun akwothanthok akwiꞌrekat itti, “Mpongothe itti mpittiethung, othakka poporot.” Ittina aïnyï ittakanthok accokkot. ");
INSERT INTO lmd_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ittina aIeccuo iꞌrekathok lon lonthomat itti, “Kirrnni iꞌret pul pꞌrek lon elli anaruk ngko athokene pul ponoppan toKapik ka kang akiat papu pothokiot nguccuk cik ammakka oMucca piꞌret akenekin itti ngkwothakkat poporot.” ");
INSERT INTO lmd_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ana lon loIeccuo lappaththakatheik cannan itti kwaik pittiet ul ana ul wakkakathe athoccïkot lon lung ana othakka thoporot nomio men. ");
INSERT INTO lmd_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Anaruk oIeccuo pikkatheik akwoththeththe noul akweo nokaꞌran pellek akwothaꞌra ngaꞌrama. ");
INSERT INTO lmd_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Caꞌri cokat cik aIeccuo pokat akwongkene, aul woPriccin ana ul iangkene lon lothonceꞌret lon cik akkakat naꞌran appik wonoththok poCelïl ana poIouthia ana nokaꞌran koUruccelim ana okin thokat cik akin ikkoik iccik kung cinang. Ana Ili wekathok puꞌran akwittiet ul iongo. ");
INSERT INTO lmd_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ul wꞌrek iomura wakkakathe anneko pul ipakimico naꞌrangkal ana okin thennekkekathe itti okin thiꞌrikok ngngin noppan akin onekkethok cik tokït koIeccuo. ");
INSERT INTO lmd_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Okin thakinniat kathar ikakin iꞌrikok ngngin noppan akka cungkut coul cokat coppot, okin thokuꞌrathe toꞌra woman akin anyathe man ntoꞌra akin orpekat pul naꞌrangkal ia kwokat cik akwïcat cik nan tokït koIeccuo icungkut coul. ");
INSERT INTO lmd_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Akka oIeccuo pimmat thoccokot tholon loKapik nomïkït men kwiꞌrekathe kimico itti, “Puruko pin, lon lang ilokithak loccïkakothe.” ");
INSERT INTO lmd_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Aul woPriccin ana ul iangkene lon lothonceꞌret lon cik ikkat cik aeret nomïkït itti, “Oththa empi pacungko Kapik? Pul pella paccïkïnthet ul lon, Kapik kulluk.” ");
INSERT INTO lmd_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","OIeccuo pinakathe lon ilakin thokat cik akin okwarttikot akwipittat kin itti, “Nthontha akka annokwarttikot lon elli nomïkït mon? ");
INSERT INTO lmd_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Liatha akkoporot itti liꞌretta itti, ‘Lon ilokithak lang loccïkakothe’ ana amma okkorronno oka menik mpiꞌre itti, ‘Urokothe kapik aeoi’? ");
INSERT INTO lmd_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Anaruk othakka itti annina itti ukul wopul iponyi wonu puꞌran nocapu itti waccïkïnthet ul lon ilokithak,” akwiꞌrekat pul ipakimico itti, “Mpiꞌrethung itti urokothe kapik aneko aꞌrangkal aeo tuan.” ");
INSERT INTO lmd_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Akurokat accokkot akwocoꞌrat tokït ken, akwonekat aꞌrangkal ia kwokat cik akwïcat cik nan akwoingkat taun akkwopiranet Kapik noka. ");
INSERT INTO lmd_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ul appik wikkatheik aprttakot tit iokat cik cïnang akin opirakanthet Kapik noka. Okin thonat nꞌre akin iꞌrekat itti, “Onïn thimmat lon lommaththik inenni.” ");
INSERT INTO lmd_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Akka oIeccuo pothikkiet kimico koporot, kwoppathe thapat akwoingkat akwimmakat pul ipaꞌrntot akucci noul poccot kꞌran itti oLaui akkwaik nokaꞌran koul iaꞌrntinthet nili akucci, aIeccuo iꞌrekathok itti, “Omakothin.” ");
INSERT INTO lmd_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","ALaui urokat kapik, akwoththekat naꞌrupu appik akwomakathok. ");
INSERT INTO lmd_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ittina oLaui pokkanthet oIeccuo thuꞌrit tuan thanung ana ul woppot iaꞌrntinthet nili akucci ana opilingon thokat cik akin oꞌrkoik okin aththut, ");
INSERT INTO lmd_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Anaruk ul woPriccin ana ul iangkene lon lothonceꞌret lon cik woPriccin wikkathe cik aꞌretto noul iammakot oIeccuo itti, “Ngintha akka annoꞌrikineik nul iaꞌrntinthet nili akucci ana ul wolon ilokithak?” ");
INSERT INTO lmd_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","OIeccuo pothïanthet kin tit itti, “Annoka ul ioporot akkongothe itti wittiettat anaruk ul iongo. ");
INSERT INTO lmd_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Mpakannao anathakkaro ul ioporot anaruk mpainet ul wolon ilokithak aine Kapik.” ");
INSERT INTO lmd_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Aul wꞌrek iꞌrekat oIeccuo itti, “Ul iammakot oIuanna waancoꞌro nothuꞌrit ana aꞌra ngaꞌrama ana cakuruk ul iammakot lon loul woPriccin anaruk ul wang iammakothung waik waꞌrkoik ana ïkkoik.” ");
INSERT INTO lmd_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","OIeccuo popakkenthet kin tit itti, “Onon thaceꞌrene purukon thopul ipipo nothuꞌrit apul ipipo paik ithoꞌrkït theni? ");
INSERT INTO lmd_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Anaruk caꞌri canthan, nomaꞌri men amma pul ipipo ponekittat ntokït kin, akin antocoꞌro nothuꞌrit.” ");
INSERT INTO lmd_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","AIeccuo iꞌrekat kin lon nthokkwie kuru ncik itti, “Pul pella pillo kret ikie apokkwo cït nthan ngkret ikïpe. Amma kwokkothe menik kwillo kret ikie akka kret ikie kannokattakot ngkret ikïpe. ");
INSERT INTO lmd_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ana pul pella pipot thrupa ikaꞌruk ikïpe. Amma kwipotherit ana thinya ana thillo kaꞌruk ana kakittako. ");
INSERT INTO lmd_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Thrupa thonu itti thittat ikaꞌruk ikie ikokkattathe nouꞌrat. ");
INSERT INTO lmd_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ana pul pella ipïkko ngapak ingïpe ana ïkko angꞌrek ingie ana kwiꞌrekathe itti, ‘Ngapak ingïpe akkoporot nangie.’” ");
INSERT INTO lmd_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Nocaꞌri cꞌrek cokat cik caCcepith aIeccuo pokkot ikkwon imïl ana ul iammakothok wikkatheik auot mïl ana ocottot akin oꞌrko. ");
INSERT INTO lmd_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Aul wꞌrek woPriccin ipittat itti, “Onon thontha akka annokkot lon ilonu itti lakannokkattat nocaꞌri caCcepith?” ");
INSERT INTO lmd_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","OIeccuo popakkenthet kin tit itti, “Onon thakannakkakkaro lon nti iatham ila aThauth pappokkothe akka okin thokat thiamat nul wungi? ");
INSERT INTO lmd_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Kwiꞌrikot noppan toKapik akwummat arrakith iothun iettathe Kapik iokat itti ul wulluk wonoppan toKapik akkaꞌrko akwoꞌrkkat ana kwekathe ul wung cakuruk ana woꞌrkkathe.” ");
INSERT INTO lmd_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Menik aIeccuo iꞌrekat kin itti, “Ukul wopul iponyi akka Ili wocaꞌri caCcepith.” ");
INSERT INTO lmd_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ana nocaꞌri cꞌrek caCcepith akwoingkat nocuththun caꞌrama ana kwokat cik akwongkene ana pul pokat cik than ponat ukun wothothari waiꞌrilla. ");
INSERT INTO lmd_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ul woPriccin ana ul iangkene lon lothonceꞌret lon cik wokat cik akwancot lon ilakin orukwet oIeccuo ngngin, menik akin ikkat cik akin okathaccek kicce amma akwittiet pul nocaꞌri caCcepith. ");
INSERT INTO lmd_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Anaruk oIeccuo pinat lon len ilakin thonat nomïkït men ana kwiꞌrekathe pul iponat ukun waiꞌrilla itti, “Urokothe kapik tokït koul.” Ana kurokathe kapik akwocoꞌrat. ");
INSERT INTO lmd_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ittina aIeccuo iꞌrekat kin itti, “Mpipittot non lon, liatha akkocoꞌrotheik itti lakkattat nocaꞌri caCcepith, itti okkot iloporori? Ana amma okorronno okkot iloporot ana ilokithaki? Okkie pul ciki ana amma okorronno okkie cik okkwori?” ");
INSERT INTO lmd_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","AIeccuo okathakat kin appik akwiꞌrekat pul itti, “Othie ukun ntit.” Apul okkat menik aukun othakkakat woporot kirrkkir. ");
INSERT INTO lmd_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Anaruk okin thaththuaka ana okin thikkatheik akin erettarane itti okin thakkot ngimpen naIeccuo. ");
INSERT INTO lmd_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Caꞌri cen oIeccuo pokuꞌrathe tocoꞌrong akwothaꞌra ngaꞌrama ana kwaꞌrakathe ngaꞌrama nokkꞌrokkꞌra. ");
INSERT INTO lmd_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Akka ngorrot ngothakkat, akwakkarat ul iammakothok ana kwipathe ul cik iattul ana ikken keꞌra, okin then itha kwothikkiet ul wothothïlettat ");
INSERT INTO lmd_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","ana ꞌran wen itti, oCcamaan (iponat kꞌran itti oPoththuruc) ana opang Anthrauc, ana oIakup ana oIuanna, ana oPilippic ana oPerththolomauc ");
INSERT INTO lmd_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ana oMaththa ana oThthoma ana oIakup ukul wAlappaoc, ana oCcamaan ipokat pongothe lon loththok pung, ");
INSERT INTO lmd_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ana oIoutha ukul woIakup, ana oIoutha Icikkariuththi ipokerathe oIeccuo nili. ");
INSERT INTO lmd_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Kuathe ntan nnocoꞌrong akin oul wung iammakothok akin ocoꞌrat nothampang. Ul iammakothok wokat cik woppot ana ul cakuruk woppot iaat nnoththok poIouthia ana nokaꞌran koUruccelim ana naꞌran iaik iccik korok irapangka toCcur ana toCcithon, ");
INSERT INTO lmd_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","okin ithaat itti okin thathoccïkot lon lung ana ittiettat nomio men. Okkwion itha uꞌrupa iokithak wokkiethe thiak appik thittakathe. ");
INSERT INTO lmd_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ana ul appik wannekkekathe itti wathntok akka puꞌran pokat cik apanthan nti iaak apittiet kin appik. ");
INSERT INTO lmd_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Akwokathakat ul iammakothok akwiꞌrekat itti, “Thethïetta thaka thon onon ithella aꞌrupu cik akka ngili ngoKapik ngaka ngon. ");
INSERT INTO lmd_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Thethïetta thaka thon onon ithiamat inenni akka onon thaththakat. Thethïetta thaka thon onon ithaik thoo inenni, akka onon thathocciro. ");
INSERT INTO lmd_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Thethïetta thaka thon amma ul wꞌrat non ana ꞌra non nti iccik ken ana ocungko non ana ꞌra ꞌran won nti ilon lokkul wopul iponyi. ");
INSERT INTO lmd_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Nopira noka caꞌri cen ana iththrako akka thocco thon tholon iloporot thaka thrïk tothiꞌrot. Akka kathar ken ika aththangon thokkinthet ul wothernte lon loKapik lon ngngin. ");
INSERT INTO lmd_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Anaruk angkre, ul ithathaꞌrathn akka onon thoccot lon lon pꞌrïn. ");
INSERT INTO lmd_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Angkre, nanon ithoththakathe inenni, akka onon thathiama. Angkre, nanon onon ithaik thacciro inenni, akka onon thathoccokot thiak ana oo. ");
INSERT INTO lmd_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Angkre, nanon amma ul omereket non, akka oththangon thokat akin omereket ul wothernte lon loKapik ngkarra.” ");
INSERT INTO lmd_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Anaruk mpiꞌret non okkwion ithaccïkothin, nongat ul iꞌrat non, nokkinthet ul iꞌrat non lon loporot. ");
INSERT INTO lmd_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Nipittot Kapik akethïe ul iattatta non, naꞌrane ul ngꞌrama iakkinthet non lon ilokithak. ");
INSERT INTO lmd_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Amma pul pꞌrek pokkworung thounu, appoprttinok thounu thꞌrek ana amma opilin ponekothung kret ikiththia ikakuꞌrupakot, korronnok akwoneko kret konoka cakuruk. ");
INSERT INTO lmd_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ethet okkwi ipipittothung aꞌrupu ia kwongothe ana amma opilin ponekothung papꞌrek pang akorronno okkaprttothok. ");
INSERT INTO lmd_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Nokkinthet ul lon ammakka onon thongothe itti wakkinthet non. ");
INSERT INTO lmd_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Amma ngkwongothe ul iongothung, thocco tholon iloporot thang thaka thiatha ithakanung cik? Akka manna ul ionu lon ilokithak wangat ul iongothekin. ");
INSERT INTO lmd_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ana amma ngkwokkinthet ul lon loporot iakkinthung lon iloporot lang liatha ilathokanung cik? Akka manna ul ionu lon ilokithak waik wakkot menik cakuruk. ");
INSERT INTO lmd_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ana amma ngkwethet pul pꞌrek aꞌrupu wokamucu mono aꞌrikothok itti kwakkenung kamucu kang kiatha ikakanung cik naak? Akka manna ul ionu lon ilokithak wakkene ul aꞌrupu akin oꞌrïkat cik itti okin thakketta appik. ");
INSERT INTO lmd_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Anaruk ongathe ul iꞌrarung ana okkinthet kin lon loporot, ethet kin aꞌrupu akorronno oꞌrïkot cik itti okin thakkarttinung, ittina thocco tholon iloporot thon thaka thrïk ana onon thaka nyukul nyoKapik ikaik cittothiꞌrot akka kwoporot lon noul iakannopiranok noka ana iokithak. ");
INSERT INTO lmd_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ona thiak ammakka Kapik oththe pon ponu thiak.” ");
INSERT INTO lmd_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Amma ngkwakorronno ethet ul wꞌrek lon moloko ana ngkwakorronno ethettat lon moloko. Amma ngkwannakkma ul wꞌrek ana ngkwannakkmako. Noccïkïnthet ul lon ilokithak alon lon occïkakot. ");
INSERT INTO lmd_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Amma onon thethet ul aꞌrupu ana onon thethettat cakuruk. Akka amma ngkwethet aꞌrupu nuthuk ana ngkwiot woppot ntit cakuruk.” ");
INSERT INTO lmd_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","AIeccuo iꞌrekat lon elli okkwienekin kuru ncik itti, “Pul ipiꞌrimathe pathutho pul ipiꞌrimathei? Okin thakannapot ippu aththuththeꞌrai? ");
INSERT INTO lmd_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Akka pul ipangkenetta pakannoka prïk nakkwi ipangkenek. Anaruk okkwi ipongkenettat kicce paka ammakka pul ipongkenerok. ");
INSERT INTO lmd_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ngkwontha akka accot kït nokwira ikaik icït copangkang akorronno occot kït nokwoꞌren ikaik icït cang? ");
INSERT INTO lmd_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Taththa akka amet opangkang itti, ‘Pangkin, kirrnni anumminung kwira nti icït cang,’ angkwakinnimma kwoꞌren icït cang? Oung ipongothe itti ngkwinnikot lon, ummi kwoꞌren nti icït cang cittokït aimmaik kicce antummine opangkang kwira nti icït cung.” ");
INSERT INTO lmd_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Pira pella ipoporot pakwono nyukul nyokithak ana pira pella ipokithak pakwono nyukul nyoporot. ");
INSERT INTO lmd_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kira kurekkurek kinako nyukul nyen inyakokwono. Ul wakinniththo ïce nopira polï ana moꞌriompong nopira pakek. ");
INSERT INTO lmd_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Pul ipoporot pere lon iloporot nolon iloporot ilaik nocïkït cung, pul ipokithak pere lon ilokithak nolon ilokithak ilaik nocïkït cung. Akka thon there lon iloppathe nocïkït.” ");
INSERT INTO lmd_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Nthontha akka annakkaron itti, ‘Ili, Ili,’ anon okorronno okkot ila aniꞌret non? ");
INSERT INTO lmd_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Okkwi ipainin mono occïkot lon lin ana akworeko ngngin, mpakenenon itti lon len laka tat. ");
INSERT INTO lmd_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Kwaka ere pul ipokat cik apuno man ana pipanthet millang cik nocik icoporot. Akka ngike ngaat ana ngokkwathe man ngka anaruk ngannoꞌrïntïttat akka mokat muntat papenang. ");
INSERT INTO lmd_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Anaruk okkwi ipaccïkot lon lin ana akwokorronno oreko ngngin, kwikkoik ere pul ipunot man mung nothampang nuthuk okorronno ipinthet millang cik nouttu, ana akka ngike ngaat angokkwat man ngka amapat thapo thokïtheththak.” ");
INSERT INTO lmd_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Anakka oIeccuo pocothothe lon elli aul occïkot, kwiꞌrikathe nokaꞌran koKapprnaum. ");
INSERT INTO lmd_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ana kwaththiat pul iparekine ili woul arrial ukuluk irro woRoma ipa kwokat pongothe cannan appongo ana pikkoik ere pio. ");
INSERT INTO lmd_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Aili occïkat lon loIeccuo athïanthok ul wꞌrek ittïttïk woul woIouth itti kwanthan akwathittienthok pul iparekinok. ");
INSERT INTO lmd_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Anakka ul wen woinet oIeccuo akin erekanthok thiaththiak itti, “Pul empi pekkot nan itti ngkwittienthet ukul. ");
INSERT INTO lmd_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Akka kwongothe ul wonnon woIouth ana manna kuninet ton cuththun caꞌrama.” ");
INSERT INTO lmd_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ittina aIeccuo oingkat okin aththungon. Akka oIeccuo okko iccik koman moili, aili woul arrial ukuluk irro othïat opurukon okin othiꞌret oIeccuo itti, “Ili, kirrnni okinya itti ngkwanthan akka mpakannekko nan itti ngkwiꞌriko noppan thanin. ");
INSERT INTO lmd_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ilen akka mpokathat ka kin itti mpakanneko nan itti mpainung. Anaruk iꞌre lon tulluk ana pul iparekinin pathakka poporot. ");
INSERT INTO lmd_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Oun cakuruk paik inyaun nyoili wꞌrek ana mponu ul waik inyaun nyin. Mpiꞌret okkwempi itti, ‘Ngko’ ana kwaeo, ana okkwempꞌre itti, ‘Aꞌrik’ ana kwao, ana mpiꞌret pul iparekinin itti, ‘Okkothe elli’ ana kwakkot.” ");
INSERT INTO lmd_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Akka oIeccuo poccïkothe elli akwoprttakat tit nolon loili akwolliakat ul iokat cik ammakothok akwiꞌrekat itti, “Mpiꞌret non itti mpakanniot thoccokot tholon loKapik nocïkït thena ammakka thoili enni manna noththok poIccereil.” ");
INSERT INTO lmd_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ittina aul iokat cik wothïlathe opakkat tuan okin othiat pul iparekine ili appothakkat poporot. ");
INSERT INTO lmd_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ittina papotteik aIeccuo oingkat icarak coman icoccot kꞌran itti Nain akin oul iammakothok ana cungkut coul woppot icomakothekin. ");
INSERT INTO lmd_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Manakka okin okko ci tocürük coricarak coman, acungkut coul akkakat ngngeme ana mpul ipiot, ukul iokat iulukkuppu nannan ana onnan pokat curuma. ");
INSERT INTO lmd_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Akka Ili oIeccuo pimmat pul ipopari pen, kwipathe thiak then cannan ana kwiꞌrekathok itti, “Kirrnni oo.” ");
INSERT INTO lmd_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ana kwoingkathe iccik kopul ipiot akwothntat kuppuꞌrung ikonat kumi nan aul iokat cik anneko ocoꞌrat. AIeccuo iꞌrekat kumi itti, “Mpiꞌrethung itti oung emprïk ipokuꞌrit urokwothe kapik.” ");
INSERT INTO lmd_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Apul ipappiot urokat kapik apikkat cik apere, aIeccuo iꞌrekat pul ipopari itti, “Ipi ukul wang.” ");
INSERT INTO lmd_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Akin irrat mïkït nti ikarak appik akin opirakanthet Kapik noka akin iꞌrekat itti, “Pul pothernte lon loKapik iprïk pummothe ncik ithoꞌrkït thonnon inenni.” Akin iꞌrekat itti, “Kapik kaat kaththittarot ul wung.” ");
INSERT INTO lmd_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Lon elli loIeccuo lappaththakatheik noththok poIouthia appik ana naꞌran appik. ");
INSERT INTO lmd_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ul woIuanna iammakothok werekanthet oIuanna lon len appik ana aIuanna pakkarathe ul iammakothok weꞌra ");
INSERT INTO lmd_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ana kwothïathekin noIli akin othipittothok itti, “Oung oMiccie ipa oIuanna piꞌret itti kwaik panthani ana amma okorronno oka oung, onïn thaꞌrïkot opilin pꞌrek paik panthani?” ");
INSERT INTO lmd_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Akka ul waat naIeccuo okin thiꞌrekathe itti, “OIuanna pomamuthie pothïothenïn itti onïn thipittothung itti, ‘Oung oMiccie ipanïn thaik thaꞌrïkori ana amma okorronno oka oung, onïn thaꞌrïkot opilin pꞌreki?’” ");
INSERT INTO lmd_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Caꞌri cen oIeccuo pappittiethe ul iongat mmio ana okïcce uꞌrupa iokithak noul ana immiek ul cik woppot iokat cik wiꞌrimathe. ");
INSERT INTO lmd_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Akwiꞌrekat ul ia oIuanna pappothïothe itti, “Ngkonon opakkot annothiꞌret oIuanna lon ilanon thoccïkothe ana ilanon thimmat, ul ïꞌrïmathe wimmat cik ana iaimico waik wanyaro ana ionat ïnyï noka wittiettathe ana ul iokat nuril waik waccïkot cik ana okin ithillet thurokiettat nti ithio ana lon iloporot loKapik lerettanet ul iella aꞌrupu wꞌrek. ");
INSERT INTO lmd_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Thethïeko thaka noul iakannopaꞌrine lon lin cik.” ");
INSERT INTO lmd_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Akka ul weot iammakot oIuanna, oIeccuo pikkatheik akwerene cungkut coul lon loIuanna akwiꞌrekat kin itti, “Kathakka onon thoinet oIuanna ithampang ithonthomara, ngintha akka onon thoinet itti onon thathimma? Pul iponyi ipaprtto lon cik ere taco torithampang ithonthomat irukwit tukwit ira kanang kaik kauꞌrei? ");
INSERT INTO lmd_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Onon theot thaththokatha ngintha? Pul pakot eret wopeththerei? Ana ul manna iako eret ialio ana iikkoik thikkoik thothaꞌrthan ana waka ikaman ikopeththere ana wikkoik naꞌran woporot ana wonu aꞌrupu appik. ");
INSERT INTO lmd_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Anaruk ngintha akka onon thoinet itti onon thathokatha? Pul pothernte lon loKapiki? Mpiꞌret non itti ïï anaruk pul empi prïk nopul pothernte lon loKapik. ");
INSERT INTO lmd_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ook ipa atham werethe itti, ‘Mpathïot pul pothothïlettat pin tokït kang okkwi ipathokuccenthung kathar cik.’ ");
INSERT INTO lmd_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Pul pella ipokwontat nocapu cene appik iprïk naIuanna anaruk okkwi ipotteik nti iul worothiꞌrot kwrïk naIuanna.” ");
INSERT INTO lmd_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ul ioccïkothe lon loIuanna appik ana ul anganna iaꞌrntinthet nili akucci okin akkokat ithoccokathe lon loKapik ila Kapik kongothe itti lakkattat ana okin thoccot mamuthie nti ikkun woIuanna. ");
INSERT INTO lmd_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Anaruk ul woPriccin ana ul iangkene lon lothonceꞌret lon cik loul wꞌrat occïkot Kapik ana lon lung ana okin thannocco mamuthie nti ikkun woIuanna. ");
INSERT INTO lmd_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","OIeccuo pappiriꞌrekat itti, “Mpungkwie ul enni ngngintha? Okin thammakka ngintha? ");
INSERT INTO lmd_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Okin thaik ere nyukul inyarran nyaik nyikkoik keccuk anyerene opangon mpoꞌre cittan akin ome itti, ‘Onïn thaik thangwine non kinye koremekkin ana onon thaik thakorronno ukko, onïn theet ngeme ana onon thaik thakorronno oo.’ ");
INSERT INTO lmd_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Akka oIuanna pomamuthie paat akkwokat cik akwannortteik ana ïkko ngapak, akin omekathok itti, ‘Kwonu uꞌrupa iokithak.’ ");
INSERT INTO lmd_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ana ukul wopul iponyi waat aꞌrko thuꞌrit ana ïkko ngapak ana onon thiꞌret itti, ‘Kwonu kïnyït kothuꞌrit ana kwongothe ngapak, ana ook opuruko poul iaꞌrntinthet nili akucci ana opuruko poul wolon ilokithak.’ ");
INSERT INTO lmd_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Anaruk ul appik iammakot wokenet itti thinaik nti ica thinako ngngre ngen.” ");
INSERT INTO lmd_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Menik apul pꞌrek poul woPriccin akkarat oIeccuo tuan itti okin thathoꞌrko thuꞌrit, akwoingkat tuan topul poPriccin ana kwikkatheik othïngkakot kriki kothokkun wothokure iccik kokuppuꞌrung kothuꞌrit. ");
INSERT INTO lmd_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ana nokaꞌran ken pul ipopari pꞌrek pokat cik than ipalle nul nuthuk, kwokat pinat nan itti oIeccuo paik paꞌrko thuꞌrit tuan topul poPriccin, ittina kwonakathe ngaak ngamutha ncuꞌru. ");
INSERT INTO lmd_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Anakka pokat apocoꞌro thoccul koIeccuo noracok tung akwoo angeme ngung oththapat noracok akwikkat cik akukukkwinthok ngeme noracok nuwan wung ana kwikkatheik akuntenthok ngaak ngamutha nan. ");
INSERT INTO lmd_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Akka pul poPriccin ipakkarothe oIeccuo tuan pimmat pul ipopari akka apokkot, akwiꞌrekat noucce wung itti, “Amma pul empi pappokat pul pothernte lon loKapik ïcat painat itti pul ipopari empi pia ipaathntok ana pokithak polon ilokithak.” ");
INSERT INTO lmd_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","AIeccuo opakkekanthok tit itti, “Camaan mponu loꞌrek laniꞌrethung.” ACcamaan othïanthok tit itti, “Pul ipangkene, iꞌrethin.” ");
INSERT INTO lmd_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","AIeccuo iꞌrekathok itti, “Pul pꞌrek pappethet ul weꞌra akucci ngkamucu itti okin thathopakkenthok, opilin poccot arrial ukuluk maꞌri ukuluk (500) ana opilin arrial weꞌra ana alkaire (50). ");
INSERT INTO lmd_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Aul aureꞌra ommakat okkene pul iponat okucci nakin. Apul okkanthet kin ntit.” AIeccuo ipittat itti, “Oththa nti akin akkangat pul ipokkinet kin nti akucci cannan ntiakin aththuththeꞌra?” ");
INSERT INTO lmd_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","ACcamaan othïat tit itti, “Okkwi ipa kwokkinet ntit iponat woppot.” AIeccuo omekathok itti, “Ngkwothïotherit oceꞌret cik papenang.” ");
INSERT INTO lmd_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","AIeccuo okathakat pul ipopari akwiꞌrekat oCcamaan itti, “Ngkwimmat pul ipopariri? Mpaat tuan thanang. Ngkwannethin ngꞌri ngoththeik anilakko ntacok anaruk pul ipopari empi pimethin tacok ngngeme ngorïkït kung ana ukukkwothin tacok nuan wung. ");
INSERT INTO lmd_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ngkwannommiccon papenang ammakka mpaat tuan thanang anaruk ammakka pul ipopari empi paat pannocoꞌro nti ithokatha lon lin. ");
INSERT INTO lmd_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Anaruk oung ngkwannoꞌrokin manna ngaak ica anaruk kunothin ngaak ngamutha noracok. ");
INSERT INTO lmd_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ilen akka aniꞌrenthung itti lon ilokithak lung loppot loccïkakinthok akka thongat thung thoppot cannan anaruk okkwi ipoccïkakïnthet lon ilokithak lotte ponu thongat thotte.” ");
INSERT INTO lmd_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ittina aIeccuo iꞌrekat pul ipopari itti, “Ngko mpoccïkïnthung lon ilokithak lang.” ");
INSERT INTO lmd_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Aul ikkot cik nokuppuꞌrung kothuꞌrit wikkatheik aerekot nomikït men itti, “Oththa empi manna ipaccïkïnthet ul lon ilokithak?” ");
INSERT INTO lmd_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","AIeccuo iꞌrekat pul ipopari itti, “Thoccokot lon loKapik nocïkït thang akkopaꞌrenung lon ilokithak lang cik ana ngkwaeo pupupure.” ");
INSERT INTO lmd_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Anakka lon len lomttathe oIeccuo poingkathe onyaro nomoꞌrong ammakka maik akwongkene ul lon iloporot longili ngoKapik ana ul wung wothothïlettat iattul ana ikken keꞌra wokat cik akin aththut. ");
INSERT INTO lmd_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ana cakuruk ul iari wꞌrek ia kwokïccet uꞌrupa iokithak nan ana ia kwittiethe nomio ammakka oMeriom iponat kꞌran itti oMacthelia okkwi ipa oIeccuo pokïccet uꞌrupa iokithak nan weꞌreꞌrapuruk. ");
INSERT INTO lmd_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ana oIona opari poKucci ook iponu lon ikkun loruan toIli oIruthuc, ana oCuccana ana opilingon thꞌrek thoppot. Ul iari enni wokat aittarot kin llon ilakin thongothe. ");
INSERT INTO lmd_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Anakka ul wokat cik aꞌrntakot mungkut mungkut naꞌran woppot kurekkurek oIeccuo perekanthet kin lon nthokkwie lon kuru ncik. ");
INSERT INTO lmd_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Pul pokkwon peot itti pathee, akka kwokat akwee mïl, amꞌrek apukkat ikathar aul ocukkarat cik auꞌrupe ocumat appik. ");
INSERT INTO lmd_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Amꞌrek apukkat nokꞌrimi akka mummothe acïngkï okꞌrekat akka ngun ngellat nan. ");
INSERT INTO lmd_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Amïl mꞌrek apukkat ithoꞌrkït tholï akka mocokkat alï okiꞌrittat cik amillekat. ");
INSERT INTO lmd_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ana icci amꞌrek mapukkathe nocapu icoporot. Mummathe amokwonat mïl mipiet kicce, kït ken arrial ukuluk (100).” Akka kwiꞌret elli, akwappiꞌrekat mpoꞌre cittan itti, “Okkwi iponu unu itti kwaccïkot akwoccïkot.” ");
INSERT INTO lmd_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Aul iammakothok ipittathok itti lon lothokkwie lon kuru ncik elli lonu itti ngintha? ");
INSERT INTO lmd_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","AIeccuo iꞌrekat kin itti, “Onon thokenettat kumitta kongili ngoKapik anaruk ul wꞌrek wakenetta lon nthokkwie lon kuru ncik. ‘Okin thakathacceik anaruk okin thakannimma, okin thaccïkot anaruk okin thakannina.’” ");
INSERT INTO lmd_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Lon elli ilakene lon lothokkwietta kuru ncik lonu itti, cïl lon loKapik. ");
INSERT INTO lmd_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Mïl imapukkothe ikathar mungkwot okkwion ithaccïkot lon loKapik ana pul pothopulut panthan aponekat kin nomïkït othakka itti akin okorronno occokot lon loKapik nomïkït akin oꞌrettat. ");
INSERT INTO lmd_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ana imapukkothe nokꞌrimi mungkwot ul ioccokothe lon loKapik nomïkït nthopira noka anaruk akka lon lakannoccokot cik nomïkït, lon len lakinnikkoik puccuk. Okin thoccokot lon nomïkït papotte anaruk amma thokkiettat thiak thainet kin ana okin thapaꞌrine cik. ");
INSERT INTO lmd_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Mïl imapukkothe ilï mungkwot ul ioccïkothe lon loKapik ana akka akin ikkoik, thirro mïkït nti ikarak tholon lothikkoik lonocapu ana thaꞌrthan ana thopira noka thaꞌrupu wonocapu thanomot kin cik akin okorronno upokkat ilon loKapik. ");
INSERT INTO lmd_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Anaruk mïl imapukkothe nocapu icoporot mungkot okkwion ithaccïkothe lon loKapik akin oꞌrumat nan nomïkït appang akin okkat lon iakin iloporot ana lakwono pangken.” ");
INSERT INTO lmd_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Pul pella paccie cuꞌru cothik ithacco akwantokuꞌrupot cerok nan ana manna onekket thoceken copapꞌrek akwokorronno onekket noꞌret othakka itti aul immaik iꞌriko noppan. ");
INSERT INTO lmd_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Akka lon ilamuꞌruttakot linako nan ana ilocukkwakot nan littako ncik ana manna oka attattar. ");
INSERT INTO lmd_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ittina nokkwo kunu ncik papenang. Okkwi ipaccïkot lon lin, kwarttakinthet nan, kwina arttot nan. Anaruk okkwi ipannoccïkot lon lin, ila kwina lotteik lanekittathok.” ");
INSERT INTO lmd_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Onnan poIeccuo ana opangon thakkakanthok akin othokathak, anaruk okin thanniat kathar ikakin immak ngngin akka cungkut coul cokat cik coppot. ");
INSERT INTO lmd_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Apilin iꞌrekat oIeccuo itti, “Onne okin opangkangon thaik thapat thaik thakwariccathung.” ");
INSERT INTO lmd_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","AIeccuo othïat tit itti, “Ongaia ana opangkingon okin ul iaccïkot lon loKapik akin okkat lon len.” ");
INSERT INTO lmd_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Caꞌri cꞌrek cokat cik aIeccuo iꞌrekat ul iammakothok itti, “Ntun arrot tomarakan mꞌrek morok irapangka.” Okin tharrathe ikuppuꞌrung ana okin thoingkathe. ");
INSERT INTO lmd_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Akka okin eo ngkuppuꞌrung konoiꞌri oIeccuo poingkathe inthe. Kanang kakkakathe norok irapangka akokkuro akatta cik akuppuꞌrung konoiꞌri ikkat cik ere kuo thoꞌronthong ana okin thokakatheik ithiak ithokithak. ");
INSERT INTO lmd_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ul iammakothok woingkathe ana wurttathok aiꞌrekathok itti, “Pul ipangkene, pul ipangkene, oron thaik thathïkïkko ngꞌri.” Kurokathe kapik akwothirriekat kanang kokapik cik ana thopangka thoiꞌri cik acik okkwat ka cik appik. ");
INSERT INTO lmd_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","AIeccuo ipittat ul iammakothok itti, “Thoccokot lon loKapik nomïkït mon thaik kartha?” Aul wung iammakothok ikkat cik aipittararot lon nnꞌre itti, “Oththa empi? Kwothirriethe kanang kokapik cik ana ngꞌri ana lon lung loccïkakathe.” ");
INSERT INTO lmd_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ana okin thoingkathe akin arrat tok cik irapangka tonocik coCcethirin icaik arrot cik noththok poCelïl. ");
INSERT INTO lmd_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Manakka oIeccuo porpotheik nocarkan corok irapangka akwocurat ipul ponat uꞌrupa iokithak ipa pokat nokaꞌran koCcethirin. Pul pen ponu luput loppot appokat cik apikikkoik cunthut ana kwannikikkoik tuan anaruk kwokat cik akwikikkoik nonupu. ");
INSERT INTO lmd_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Manakka kwimmat oIeccuo akwekat ngeme, akwapat iracok tung akwiꞌrekat mpoꞌre cittan itti, “Ieccuo ukul woKapik korothiꞌrot, ngintha akka ngkwongothe naun? Occïkothin korronno occokiethin thiak.” ");
INSERT INTO lmd_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Akka oIeccuo pokat piꞌrethe uꞌrupa iokithak itti wappot thapat nti ipul. Uꞌrupa iokithak wawokat cik apukko naak ana manna aul ïꞌrïkïkkok tacok ana nyaun ana akwanguttat anaruk kwokat akwommotho nyol inya kwïꞌrïkïkkakot ngngin ana uꞌrupa iokithak wokat aittethok ithampang thapat. ");
INSERT INTO lmd_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","AIeccuo ipittat pul pen itti, “Ngkwoccot kꞌran itti oththa?” Apothïat tit itti, “Kꞌran kin itti ‘cungkut’ akka onïn thoppot.” ");
INSERT INTO lmd_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Auꞌrupa iokithak ipittat oIeccuo lon thiaththiak itti kirrnni othïot kin thothïrïn. ");
INSERT INTO lmd_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ana cungkut conuththuruk cokat cik cïnang iccik kocoꞌrong anuꞌro. Ana uꞌrupa iokithak wipittathe oIeccuo itti kwakorronno kin akin iꞌriko inuththuruk ana oIeccuo poccïkanthet kin. ");
INSERT INTO lmd_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Akka uꞌrupa iokithak woppothe thapat nti ipul, wiꞌrikikkathe inuththuruk ana nuththuruk noccorathe uo nokuthut korok anorttapat iꞌri ana nïkïkkathe ngꞌri. ");
INSERT INTO lmd_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Cïnang ul iokat cik auꞌre nuththuruk wimmat akka nuththuruk nillet okin thollathe kiththik akin othiꞌrekat ul icarak coman ana iaik nomipit. ");
INSERT INTO lmd_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ana ul wakkakathe thapat athokatha lon len ilokat cik. Akka okin thaat iccik koIeccuo okin thaththiat pul ipapponat uꞌrupa iokithak noka aweot nti iaak ana kwokat akwikkoik iccik koIeccuo akkwakot eret ana akkwoporot ca ana okin thonat nꞌre. ");
INSERT INTO lmd_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Okkwion ithaththimmat lon len therekanthet ul lon tat akka oIeccuo pothikkiet pul iponu uꞌrupa iokithak poporot. ");
INSERT INTO lmd_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Menik aul appik wonocik coCcethirin omekat oIeccuo itti kwapaꞌroik noththok pen akka nꞌre noꞌrot nakin. Ittina aIeccuo arrat ikuppuꞌrung konoiꞌri akwoingkat. ");
INSERT INTO lmd_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Apul ipa uꞌrupa iokithak wokat woꞌrot nan ummat akwipittat oIeccuo itti okin thaeo akin aththungon anaruk oIeccuo popakkekanthok tit itti, ");
INSERT INTO lmd_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Opakkothe tuan athiꞌret ul appik lon ila Kapik kokkinthung.” Ittina pul popakkathe ana paththerekanthet ul nokaꞌran engkꞌre appik lon ila oIeccuo pokkinthok. ");
INSERT INTO lmd_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Manakka oIeccuo pokkaprattakot nokaꞌran koKapprnaum attang na kwapparrothe ngngin, ul wopirakanthok noka cannan akka okin thokat cik akin oꞌrïkothok. ");
INSERT INTO lmd_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ittina apul pꞌrek poccot kꞌran itti oIairoc ipokat ili wonocuththun caꞌrama akkakat apapat noracok toIeccuo akwipittathok nthiak itti kwanthan tuan thanung ");
INSERT INTO lmd_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","akka ukul wung iopari iulukku wonat luput attul ana ikken keꞌra (12) wokat wongo ana wommaththik ere wio. Akka oIeccuo pokat cik ikathar akweo ul wokkakathe woppot aꞌrntüttothok. ");
INSERT INTO lmd_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Pul pꞌrek ipopari pokat cik angüccük opellelle nti iaak luput attul ana ikken keꞌra (12), kwikkethe ul ittiet ul akucci appik othakka itti aittiethok ana pul pellat ipothikkierok poporot. ");
INSERT INTO lmd_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Pul ipopari pakkakathe nthoccul koIeccuo ana pothntathe thon thokret kung ana ngüccük ngocoꞌrathe nti iaak accokkot. ");
INSERT INTO lmd_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","AIeccuo ipittat itti, “Oththa akkothntorin?” Akin ocukkwat nan appik aPoththuruc iꞌrekat itti, “Pul ipangkene, ul wunukwothung ana waik wanentekot cik iccik kang.” ");
INSERT INTO lmd_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Anaruk oIeccuo piꞌrekathe itti, “Pul pꞌrek pothntorin akka mpina itti puꞌran peot nti iaun.” ");
INSERT INTO lmd_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Anakka pul ipopari pina itti pinakot nan pakkakathe apokkweka ana papathe iracok toIeccuo tokït koul appik ana perekanthet oIeccuo lon ila kwothntinok ana kwittakathe. ");
INSERT INTO lmd_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ittina aIeccuo iꞌrekathok itti, “Ukul win, thoccokot tholon loKapik nocïkït cang thittiethung. Ngko lon loporot.” ");
INSERT INTO lmd_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Anakka oIeccuo pokat cik akwere, apul pꞌrek akkakat ntuan toili wonocuththun caꞌrama ioccot kꞌran itti oIairoc, appiꞌrekat itti, “Ukul wang wiot ana ngkwannommie pul ipangkene.” ");
INSERT INTO lmd_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Anakka oIeccuo poccïkothe lon len akwiꞌrekat oIairoc itti, “Kirrnni opelle, occokothe lon loKapik nocïkït ana ukul wang iopari wathakka woporot.” ");
INSERT INTO lmd_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Anakka kwaat tuan toIairoc, kwꞌrakathe itti pul pꞌrek piꞌriko noppan akin aththut anaruk oPoththuruc ana oIuanna ana oIakup ana oththan ana onnan pokkul iiot tulluk. ");
INSERT INTO lmd_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ul wokat aoo cannan aIeccuo iꞌrekat kin itti, “Nangkoik, kwakannio anaruk kwaik inthe.” ");
INSERT INTO lmd_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Okin thoccirathok ngngin akka okin thinat nan itti ukul wawiot. ");
INSERT INTO lmd_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Anaruk oIeccuo poccokathe ukul ukun ana kwiꞌrekathe itti, “Ukul win, urokothe kapik.” ");
INSERT INTO lmd_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ukul wokkatheik ana wurokathe kapik accokkot. Ittina oIeccuo piꞌrekathekin itti okin thethet aꞌrupu wꞌrek aꞌrko. ");
INSERT INTO lmd_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Aththan akin onnan thoprttakathe tit anaruk kwiꞌrekathekin lon lonthomat itti okin thanniꞌret pul pꞌrek lon elli. ");
INSERT INTO lmd_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Anakka oIeccuo pakkarot ul wung ithun wothothïlettat iattul ana ikken keꞌra, kwekathekin ngili ingakin okïcce uꞌrupa iokithak ngngin ana ittiet ul iongo ngngin. ");
INSERT INTO lmd_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ana kwothïathekin akin othongkene lon longili ngoKapik ana ittiet ul iongo. ");
INSERT INTO lmd_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Kwiꞌrekathekin itti, “Nokorronno oneko alpꞌrek aththik nokurtti kon, nokorronno oneko kurrong ana kaꞌruk konokurtti ana thuꞌrit ana akucci ana eret weꞌra. ");
INSERT INTO lmd_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ana man imanon thiꞌrikot tit, nikkoik tit puccuk annoththekat nokaꞌran ken. ");
INSERT INTO lmd_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ana amma ul nokaꞌran ken wakinnikkienon cik, nokkwe tuꞌrupang cik nnoracok ton amma annoththe nokaꞌran ken aloka lon ilimmat lon ngkït itti okin thꞌrat lon lon.” ");
INSERT INTO lmd_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ittina okin thurokathe akin oingkat naꞌran akin ikkat cik akin ongkene lon iloporot loIeccuo ana ittiet ul iongo naꞌran appik. ");
INSERT INTO lmd_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","AIruthuc ili wonoththok poCelïl occïkat lon ilokat cik appik. Alon ocikittakanthok ca akka opilingon thokat cik akin ere itti oIuanna purokot nti ithio, ");
INSERT INTO lmd_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ana opilingon iꞌre itti pul pothernte lon loKapik oIlia pummothe ncik ana opilingon iꞌre icci itti pul pothernte lon loKapik pothupuththuput purokot nti ithio cakuruk. ");
INSERT INTO lmd_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Anaruk oIruthuc piꞌrekathe itti, “OIuanna pampokiothe ca cik ana okkwen pꞌrek empi ampappoccïkot lon len?” Ana kwokat cik akwokwantot kathar ika akwimmak ngngin. ");
INSERT INTO lmd_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Anakka ul wung wothothïlettat wokkaprttakot ntan okin therekanthet oIeccuo lon ilakin thokkothe. Menik kwipathekin ana okin thellek thoingkathe nokaꞌran koPeththcceitha ");
INSERT INTO lmd_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","anaruk ul wawinat nan ana womakathok. Kwikkiekathe ul cik akwikkat cik akwerenekin lon longili ngoKapik ana kwittiekathe ul iokat cik wongothe itti wittiettat. ");
INSERT INTO lmd_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Anakka cipin cokat capot, ul wothothïlettat wung wakkakanthok aiꞌrekathok itti, “Omethe ul apettakot cik, akin eo naꞌran iccik konnon akin othokwancot thuꞌrit thꞌrek akin oꞌrko ana kaꞌran nakin ïcat akka kaꞌran engki kaik thomnther.” ");
INSERT INTO lmd_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","AIeccuo iꞌrekat kin itti, “Nethet kin apꞌrek akin oꞌrko.” Akin othïat tit itti, “Onïn thonu arrakith ukuluk tulluk ana ape weꞌra. Ngkwongothe itti oron thathokerine ul enni appik thuꞌriri?” ");
INSERT INTO lmd_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ul iomura iokat cik ceneket athar ukuluk (5,000). OIeccuo piꞌrekathe ul iammakothok iattul ana ikken keꞌra itti, “Nikkiekin cik nocapu mungkut mungkut ana icungkut culukku aul oka arrial weꞌra ana alkaire (50).” ");
INSERT INTO lmd_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Aul iammakothok ikkiekat ul cik ammakka kwiꞌret. ");
INSERT INTO lmd_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","OIeccuo ponekathe arrakith ukuluk ana ape weꞌra akwokathakat cik tothiꞌrot ana kwopirakanthet Kapik noka ana kwomithathe iarrakith ana kwekathe ul iammakothok aikket ul. Ana cakuruk kwummathe ape weꞌra ana kwillillanthet kin tit appik. ");
INSERT INTO lmd_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ul woꞌrkkathe thuꞌrit aththakakat appik aul iammakothok aꞌrntat thuꞌrit ithokwentakot nan oppappat nyalünthüng attul ana ikken keꞌra. ");
INSERT INTO lmd_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ana caꞌri cꞌrek aIeccuo pokat cik akwaꞌra ngaꞌrama akin oul iammakothok iattul ana ikken keꞌra akwipittat kin itti, “Ul waik wame itti oun oththa?” ");
INSERT INTO lmd_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Akin othïat tit itti, “Ul waik wame itti oung oIuanna pomamuthie apilingon thame itti oIlia ana apilingon ome itti pul pothernte lon loKapik pomaꞌrot purokot nti ithio.” ");
INSERT INTO lmd_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","AIeccuo ipittat ul wothothïlettat wung itti, “Ana onon there tat? Onon thame itti oun oththa?” APoththuruc iꞌrekat itti, “Oung oMiccie pothïlathe noKapik.” ");
INSERT INTO lmd_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Menik aIeccuo iꞌrekat kin itti okin thakorronno iꞌret puꞌrek itti ook okkwen. ");
INSERT INTO lmd_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Akwiꞌrekat itti, “Ukul wopul iponyi wonu itti wakkiettat thiak cannan ana ul ittïttïk woul ana ul ittïttïk woul wonoppan toKapik ana ul iangkene lon lothonceꞌret lon cik wꞌrak ana wonu itti wakkuttat ana wurokietta nti ithio nomaꞌri imꞌrapuruk.” ");
INSERT INTO lmd_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ana kwiꞌrekathekin appik itti, “Okkwi ipongothe itti kwamakot lon lin kwonu itti kure noka kung ana oneko thapak thung appinappin akwomakothin. ");
INSERT INTO lmd_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Okkwi ipongothe itti kwaꞌret thikkoik thung akure noka kung. Anaruk okkwi ipurethe thikkoik thung cik nti ilon lin kwaꞌret. ");
INSERT INTO lmd_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ngintha akkoporot amma pul pothikkiet capu ncik appik cung ana kurethe calak cung cik? ");
INSERT INTO lmd_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Okkwi ipella lon lin ana ella kït kolon lin, oun ukul wopul iponyi wella kït kolon lung caꞌri ica anthan nthrïk thung ana nthrïk thoththan ana thouꞌrupa wothothïlettat woKapik. ");
INSERT INTO lmd_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Mpiꞌret non lon ïcat itti ul wꞌrek waik cene wannille aththik akin tharthuk imma ngili ngoKapik.” ");
INSERT INTO lmd_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Anakka maꞌri meot ncik mormor nocaꞌri ica kweret nan, kwipathe oPoththuruc ana oIuanna ana oIakup akwokuꞌrat kin ngngin toꞌra wocoꞌrong akin othaꞌra ngꞌrama. ");
INSERT INTO lmd_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Anakka kwokat cik akwaꞌra ngaꞌrama toca tung toprttakatheik ana eret wung ollio ere thuleꞌrak thokapik. ");
INSERT INTO lmd_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Aul iomura weꞌra oMucca ana oIlia, ");
INSERT INTO lmd_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ummat ncik nthrïk akin erene oIeccuo. Okin thokat cik akin eret kathar ika oIeccuo paik pathio ngngin nokaꞌran koUruccelim. ");
INSERT INTO lmd_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","OPoththuruc okin opurukon thokat inthe anaruk akka okin thurttat nti inthe akin immakat thrïk thoIeccuo ana opilingon theꞌra akin ocoꞌro akin aththut. ");
INSERT INTO lmd_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Anakka ul weꞌra iomura wokat cik aththe naIeccuo aPoththuruc iꞌrekat oIeccuo itti, “Pul ipangkene, loporot itti oron thikkoik cene. Tun uno müꞌrük mꞌrapuruk culukku cang ana culukku coMucca ana culukku coIlia.” Kwokat pommat itti kwaik peret ngimpen. ");
INSERT INTO lmd_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Anakka kwokat cik akwere, nuththe nakkakathe nakin anoꞌrumat kin ana okin thipathe nꞌre akka okin thiꞌrikot inuththe. ");
INSERT INTO lmd_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Apoꞌre akkakat nti inuththe apiꞌre itti, “Ukul win enni ia mpakkarot itti wakkot ngre ngin ana nthaccïkot lon lung.” ");
INSERT INTO lmd_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Akka poꞌre peret akin immakat oIeccuo akkwaik pellek. Caꞌri cen ul iammakothok wangkatheik llon len aththung okin thakinniꞌrekat pul pꞌrek lon ilakin thimmat. ");
INSERT INTO lmd_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ana ngorrot ngen akka okin thuot ntan ntocoꞌrong acungkut coul ocurarat iaak. ");
INSERT INTO lmd_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Apul pꞌrek ipocura akkarat nti ithoꞌrikït thoul apakkaro oIeccuo mpoꞌre itti, “Pul ipangkene, mpipittothung itti ngkwakathanin ukul win enni iulukku. ");
INSERT INTO lmd_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Auꞌrupa iokithak woꞌrot nan ana amma woꞌrot naak walliethok ikapa ana wicethok tit puccuk akwapat nocapu arre ntit ana okkiethok thiak kicce ana woo mpoꞌre cittan ana wuꞌre pok nti ithon ana wannokorronnok ana waik wakïttok. ");
INSERT INTO lmd_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ana mpipittothe ul iammakothung itti okin thakïccenenïn anaruk okin thannokïccekat nan.” ");
INSERT INTO lmd_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","AIeccuo iꞌrekat itti, “Nantokatha, onon ul iakannoccokot lon loKapik nomïkït ana tholon ilokithak tulluk. Oron thikkoik aththut manna kartha?” Akwiꞌrekat pul itti, “Nakut ukul wang cene.” ");
INSERT INTO lmd_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Anakka ukul wokat athakkarot iccik koIeccuo auꞌrupa iokithak iꞌrikat ikkul arrekat nocapu. AIeccuo othirriekat uꞌrupa iokithak cik aththekat nokkul akwekat oththan. ");
INSERT INTO lmd_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Aul iokat cik cïnang appik oprttakanthet lon len tit lopuꞌran poKapik. Anakka okin thokat akin oprttakinthet lon len tit appik ila oIeccuo pokkothe kwiꞌrekathe ul iammakothok itti, ");
INSERT INTO lmd_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Noccïkot lon papenang ila mpaik piꞌret non itti, ukul wopul iponyi waik wathokettat ul.” ");
INSERT INTO lmd_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Anaruk okin thanninakat lon len. Lokat lamuꞌruttakothekin othakka itti akin okorronno ina ana okin thonat nꞌre ipitto lon len. ");
INSERT INTO lmd_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Aul iammakothok ikkat cik apllarot llon itti, oththa akkaka prïk. ");
INSERT INTO lmd_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","AIeccuo inakat lon ilakin thonat nomïkït men akwonekat ukul iotteik akwoceꞌrekat iccik kung. ");
INSERT INTO lmd_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Akwiꞌrekat kin itti, “Okkwi ipikkiet ukul cik enni iotteik ngkꞌran kin kwikkierin cik ana okkwi ipikkierin cik kwikkiet okkwi ipothïothin cik. Akka okkwi ipotteik ianon appik ook akkrïk.” ");
INSERT INTO lmd_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","AIuanna iꞌrekat itti, “Pul ipangkene, ïnthimmat aul wꞌrek okïcce uꞌrupa iokithak ngkꞌran kang ana onïn thoceꞌrerok akka kwannoka uraththungon.” ");
INSERT INTO lmd_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","AIeccuo iꞌrekat kin itti, “Nokorronno oceꞌrek akka pul ipannꞌra lon lon, ook ponnon.” ");
INSERT INTO lmd_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Manakka caꞌri cakat acokko napuththut itti oIeccuo panekittat tothiꞌrot akwonekkekat lon cik itti kuroko eo nokaꞌran koUruccelim. ");
INSERT INTO lmd_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ana kwothïathe ul wothothïlettat tokït kung nokaꞌran koCcamirin itti akin othokuccenthok aꞌrupu cik. ");
INSERT INTO lmd_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Anaruk ul wonokaꞌran ken wꞌrakathe ikkiek cik akka kwokat cik akweo nokaꞌran koUruccelim. ");
INSERT INTO lmd_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Anakka ul iammakothok ionat ꞌran itti oIakup ana oIuanna thimmat lon len akin ipittat oIeccuo itti, “Ili, loporot itti onïn thipitto thik ntothiꞌrot athathokꞌrekini?” ");
INSERT INTO lmd_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Anaruk oIeccuo polliakathekin akwothirriekat kin cik ");
INSERT INTO lmd_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ana okin thoingkathe nokaꞌran kꞌrek. ");
INSERT INTO lmd_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Anakka okin thokat cik akin onyaro ikathar apuꞌrek iꞌrekat oIeccuo itti, “Mpamakothung na aeo.” ");
INSERT INTO lmd_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","AIeccuo othïanthok tit itti, “Mipa monu kürük imuꞌrol ikakin ikkoik tit ana uꞌrupe wonu nune anaruk ukul wopul iponyi wella kaꞌran na anekket ca.” ");
INSERT INTO lmd_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Akwiꞌrekat opilin pꞌrek itti, “Omakothin.” Anaruk pul pothïanthok tit itti, “Ili, korronnon anothocïkko opappa kappak.” ");
INSERT INTO lmd_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","AIeccuo othïanthok tit itti, “Kirrnni aul illet ocïkko ul illet anaruk ngko atherene opilingon lon longili ngoKapik.” ");
INSERT INTO lmd_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ana icci apilin appiꞌrekat itti, “Ili, mpamakothung anaruk korronnon anopakkot anothiꞌret ul woruan itti mpei paik paeo pꞌrin.” ");
INSERT INTO lmd_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","AIeccuo othïanthok tit itti, “Pul ipongothe itti pamakothin ana apappopakkinthet lon lung ilipe, pannekko nan itti kwareko ingili ngoKapik, pikkoik ere pul ipara apolliakot thoceken aporakat tapak topaꞌrot cik.” ");
INSERT INTO lmd_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Anakka lon elli locothakothe, aIli oIeccuo ocumat ul arrial wꞌrapuruk ana alkaire ana ikken keꞌra (72) ana kwothïlekathekin tokït kung theꞌra theꞌra ana naꞌran appik ia kwokat cik akweo nan. ");
INSERT INTO lmd_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Akwiꞌrekat kin itti, “Kopon kokwonot mïl moppot anaruk ul iakio wotte. Nipittot pul pokkwon apothïot ul iakio ikkwon kung. ");
INSERT INTO lmd_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ngkonon, mpaik pathïot non ere lungkat laik ithoꞌrkït thomipa. ");
INSERT INTO lmd_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Nokorronno oneko kaꞌruk kakucci ana kaꞌruk konokurtti ana wok ana okorronno omicco pul pꞌrek nokathar. ");
INSERT INTO lmd_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Amma anniꞌriko noppan topul pꞌrek, niꞌret ul wonoppan ten cittokït itti, ‘AKapik ethïet kaman engki cik.’ ");
INSERT INTO lmd_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Amma pul pothomicco paik iul wonoppan ten, thomicco thon thaꞌro naak, ana amma pul pothomicco pella, thomicco thon thapakkinthet non. ");
INSERT INTO lmd_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Nikkoik iman men, annoꞌrko thuꞌrit ithakin ethet non akka pul ipareko ponu itti pacco aꞌrupu nti ire ngung. Nokorronno urttuko nti ikaman annoince iakꞌrek. ");
INSERT INTO lmd_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Amma onon akkiꞌrikot noththok pꞌrek mono akin ikkienon cik, noꞌrko thuꞌrit ithakin thonekkethe tokït kon itti onon thaꞌrko. ");
INSERT INTO lmd_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Nittiet ul iongo iaik cïnang, niꞌret kin itti, ‘Ngili ngoKapik ngakko napuththut iccik kon.’ ");
INSERT INTO lmd_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Anaruk amma onon thiꞌrikot nokaꞌran kꞌrek mono akin okorronno ikkienon cik, ngkonon ikathar konokaꞌran ken anniꞌre itti, ");
INSERT INTO lmd_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Manna tuꞌrupang tonoththok pon irocciccokothe nïn, onïn thakkwenthet non cik nnoracok tïn. Anaruk nina nan itti ngili ngoKapik ngaik napuththut.’ ");
INSERT INTO lmd_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Anaruk mpiꞌret non itti thakkmako thokaꞌran koCothum thaka thopappat nothonceꞌret lon cik ithaka nokaꞌran ikꞌrat ikkienon cik.” ");
INSERT INTO lmd_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Angkre, ul woKuruccin, angkre, ul woPeththecceitha, akka amma lon ilommaththik ilokat lokkattathe ianon lokat lokkattathe nokaꞌran koCcur ana koCcithon, ul wonaꞌran wen waapaꞌrinet lon cik ilokithak akkomaꞌrot ana waakenet nthako eret iillillakot ana ipot mucuk ima. ");
INSERT INTO lmd_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Kapik kathipo thiak thoul wonokaꞌran koCcur ana koCcithon nocaꞌri cothakkmako nanon. ");
INSERT INTO lmd_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Onon enthrïk thonokaꞌran koKapprnaum onon thame itti onon thanekittat tothiꞌrori? Aa, onon thaarrettat thothïrïn.” ");
INSERT INTO lmd_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Kwappiꞌrekat ul immakothok itti, “Okkwi ipoccïkothe lon lon kwoccïkothe lon lin ana okkwi ipꞌrat lon lon kwꞌrat lon lin ana okkwi ipꞌrarin kwꞌrat okkwi ipothïothin.” ");
INSERT INTO lmd_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Anaruk akka ul wung iammakothok iarrial wꞌrapuruk ana alkaire ana ikken keꞌra wokkaprttakot awopirakat noka wiꞌrekathok itti, “Ili, uꞌrupa iokithak wokat cik manna accïkot lon lïn amma ïnere ngkꞌran kang.” ");
INSERT INTO lmd_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","AIeccuo iꞌrekat kin itti, “Mpimmat pul pothopulut apapo ntothiꞌrot ere thuleꞌrak ithallio. ");
INSERT INTO lmd_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ana mpethet non puꞌran annokakꞌrot inyil cik ana ünü ana alkot puꞌran popul pothopulut. ");
INSERT INTO lmd_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Anaruk nokorronno opira noka itti uꞌrupa iokithak waccïkot lon lon anaruk nopira noka itti ꞌran won wokurrakot tothiꞌrot.” ");
INSERT INTO lmd_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Caꞌri cen aIeccuo opirakat noka noKanang ikupupure, akwiꞌrekat itti, “Mpopiranung noka, ngappa pin, Ili worothiꞌrot ana wonocapu, akka ngkwamuꞌruttothe ul lon elli inaik nti ima ila mpiꞌrethe ul win iammakothin, akene ul iammakka nyukul inyarran. Ïcat ngappa, elli akka ngkwongothe itti laka. ");
INSERT INTO lmd_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ongappa pethin aꞌrupu appik. Pul pella pina ukul, oththan pokkul pulluk akkinak. Ana pul pella pina oththan, ukul wulluk akkinak ana okkwion itha ukul wongothe itti wakenekin oththan.” ");
INSERT INTO lmd_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ittina akwolliakat ul iammakothok akwiꞌrekat kin akka okin thokat thellek itti, “Kït kethïettat ikaik kakathacce lon ilanon thaik thakathacce. ");
INSERT INTO lmd_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nantoccïkot aniꞌret non, ul woppot wothernte lon loKapik ana nili nokat nongothe itti nimma lon ilonon thaik thakathacce ana nakinnimma ana occïkot lon ilanon thaik thaccïkot ana nthakorronno occïkot.” ");
INSERT INTO lmd_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Apul pꞌrek ipangkene lon lothonceꞌret lon cik, urokat kapik akwipittat oIeccuo lon ngeꞌri itti akwiꞌriththak ngngin akwiꞌrekat itti, “Pul ipangkene, ngintha akka anokkot aniot thikkoik thothupuththuput?” ");
INSERT INTO lmd_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","AIeccuo iꞌrekathok itti, “Liatha akkokurrakot iatham wolon lothonceꞌret lon cik? Ana lon len lonu ittirat?” ");
INSERT INTO lmd_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Apul iꞌrekat itti, “Liꞌrettat itti, ‘Ongathe Ili Kapik kang ncïkït cang appik ana ngka kang appik ana ngatheꞌre ngang appik ana mpuꞌran pang appik’ ana ‘Ongathe ul wꞌrek ammakka ngkwongothe ka kang.’” ");
INSERT INTO lmd_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","AIeccuo iꞌrekathok itti, “Ngkwothïotherit papenang. Okkothe elli ana ngkwikkoik thupuththuput.” ");
INSERT INTO lmd_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Anaruk pul pappongothe itti prrot noka kung akwiꞌrekat oIeccuo itti, “Ana okkwen akkapul ponocuruk cin?” ");
INSERT INTO lmd_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","AIeccuo othïat tit nthokkwie lon kuru ncik itti, “Puꞌrek pokat cik apao nnokaꞌran koUruccelim apeo nokaꞌran kAria ana pocurakathe iul wothuꞌran. Ul wothuꞌran wuekathok eret ana okkwekok akin oththekat naak akwomma ngka ere kwio. ");
INSERT INTO lmd_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Apul ponoppan toKapik akkakat apokkat ikathar ken, manakka pimmat pul emprïk apokkat ciththan apoingkat. ");
INSERT INTO lmd_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Apul pꞌrek akkakat cakuruk ponoul woLaui iareko noppan toKapik manakka paat nokaꞌran kopul pen, apokkat ciththan akwoingkat. ");
INSERT INTO lmd_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Anaruk apul poul woCamirin pokat cik apeo nokurtti, apakkakat na pul pokat cik anakka pimmarok apipat thaik thung. ");
INSERT INTO lmd_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Akwoingkat akwocukkwat cik iccik kung akunat ngapak ïnyï ana ngaak akwïꞌrïkïkkanthok ïnyï kicce akwarriekathok teꞌringka akwoingkathok ngngin akwothonekkekathok ikaman ika ul aallerit nakucci akwokathakat lon lung. ");
INSERT INTO lmd_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ana ngorrot ngen akummat akucci weꞌra akwekat pul pokaman akwiꞌrekathok itti, ‘Okatha lon lopul empi akka mpaik paeo ana amma mpokkaprttakot mpathokkenung akucci ia ngkwokïttothe naak.’” ");
INSERT INTO lmd_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","AIeccuo ipittat pul ipangkene lon lothonceꞌret lon cik itti, “Pul piatha nti iul iꞌrapuruk ponocuruk copul ipapothe inyaun nyoul wothuꞌran apopokat?” ");
INSERT INTO lmd_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Apul ipangkene lon lothonceꞌret lon cik othïat tit itti, “Pul ipipot thiak thung.” AIeccuo iꞌrekathok itti, “Ngko athokkot ammakka pul pen.” ");
INSERT INTO lmd_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Anakka oIeccuo pokat cik ikathar akin oul iammakothok okin thakkakathe nokaꞌran na pul ipopari pokat ipoccot kꞌran itti oMarththa apikkiekat kin cik tuan. ");
INSERT INTO lmd_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ponat opang pꞌrek ipopari poccot kꞌran itti oMeriom ipikkot cik iccik koIeccuo akwoccïkot lon lung. ");
INSERT INTO lmd_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Anaruk oMarththa pokat piꞌrikothe akwokkot thuꞌrit ithokat thonu itti thakkattat. Kwakkakanthet oIeccuo akwiꞌrekathok itti, “Ili, ngkwannimma akka opangkin poththet naun pellek anokkot ngrei, lon len lannoka ere kwokwïethini? Iꞌrethok akwathittarothin.” ");
INSERT INTO lmd_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","AIeccuo othïanthok tit itti, “Marththa, Marththa, ngkwiꞌrikothe llon loppot ana ngkwonu kït nolon loppot. ");
INSERT INTO lmd_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Anaruk lon lulukku ilonu itti laccakot kït nan ana opangkang oMeriom poccokothe iloporot ntit, ana lakorronno onekittathok.” ");
INSERT INTO lmd_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Caꞌri cꞌrek aIeccuo ikkat cik akwaꞌra ngaꞌrama nokaꞌran kꞌrek. Anakka kwomarttot thaꞌra ngaꞌrama apilin pꞌrek nti iul iammakothok iꞌrekathok itti, “Ili, ongkene nïn thaꞌra ngaꞌrama ammakka oIuanna pongkenet ul iammakothok wung.” ");
INSERT INTO lmd_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","AIeccuo iꞌrekat kin itti, “Amma annaꞌra ngaꞌrama anniꞌre ittina, ‘Ngappa pïn, akꞌran kang othiakineik angili ngang anthan, ila ngkwongothe itti lakkattat, alokkattat nocapu ammakka lokkattathe tothiꞌrot. ");
INSERT INTO lmd_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ethet nïn thuꞌrit ithekko nïn nocïngkï enci. ");
INSERT INTO lmd_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Occïkïnthet nïn lon lïn ilokithak akka onïn cakuruk thaccïkanthet okkwion ithokkinthent nïn lon ilokithak kirrnni apiet nïn ithenekketta.’” ");
INSERT INTO lmd_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ittina aIeccuo iꞌrekat kin itti, “Oththa akkonu opuruko nti ianon mono akwoinok thampang thongkꞌra akwiꞌrethok itti, ‘Puruko pin, ethin arrakith wꞌrapuruk ");
INSERT INTO lmd_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","akka opuruko pin pꞌrek painin nti ikurtti ana mpella alpꞌrek anethok akwoꞌrko.’ ");
INSERT INTO lmd_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ana apuruko pung ponoppan othïanthok tit nnoppan itti, ‘Kirrnni ommien cik. Mpunukkothe kathat pꞌrïn ana mpaik naꞌrangkal ïnonyukul nyin mpamma uroko anethung papꞌrek.’ ");
INSERT INTO lmd_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Mpiꞌret non itti, amma pul pꞌrat uroko akwethet pul thuꞌrit itti opuruko, kuroko akwethok akka kwommierok cik. ");
INSERT INTO lmd_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ilen akka aniꞌrenthet non itti noꞌrungkot nan ipitto ana lon len lettat non, nokwantot lon ana onon thiot, ana okkwi ipipitto thittarakot ana kwittarakot. ");
INSERT INTO lmd_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Akka okkwi ipipitto lon pettat ana okkwi ipakwantot piot ana okkwi ipipitto thittarakot ana kwittarakot. ");
INSERT INTO lmd_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Oththan poththa nti ianon amma opei pipittothok pape akwethok pinyil? ");
INSERT INTO lmd_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ana manna amma kwipittot cin akwethok künü? ");
INSERT INTO lmd_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Amma onon manna ithonu lon ilokithak thina akka annethet nyukul nyon aꞌrupu ioporot, oththe pon porothiꞌrot pakannethet okkwion ithipittothok Kanang ikupupurei?” ");
INSERT INTO lmd_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ana oIeccuo pokat cik akwokïcce uꞌrupa iokithak nnopul ipokat pommat ere. Manakka uꞌrupa iokithak wollot nti ipul pen aperekat aul irrat mïkït nti ikarak. ");
INSERT INTO lmd_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Anaruk apilingon iꞌrekat itti, “Kwaik pakïcce uꞌrupa iokithak ngkꞌran koPelecepul ili wouꞌrupa iokithak.” ");
INSERT INTO lmd_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Apilingon ennekkekathok nthipittothok lon ilommaththik. ");
INSERT INTO lmd_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","OIeccuo pinat lon ilokat ima men ana kwiꞌrekathekin itti, “Ngili illillakot tit kurekkurek ngintat cik, ana amma ul woruan willillakot kurekkurek wakannoꞌrungkot cik. ");
INSERT INTO lmd_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Amma pul pothopulut poprttakothe ika kung, ngili ngung ngaꞌrungkot cik taththa? Mpiꞌret elli akka onon thaik thame itti mpaik pakïcce uꞌrupa iokithak mpuꞌran poPelecepul. ");
INSERT INTO lmd_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ana amma mpakïcce uꞌrupa iokithak mpuꞌran poPelecepul, ul won iammakot non wakïcce uꞌrupa iokithak mpuꞌran poththa? Ittina okin thathakka ul iakkma non. ");
INSERT INTO lmd_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Anaruk amma oun akka akïcce uꞌrupa iokithak mpuꞌran poKapik ittina lakene itti ngili ngoKapik ngaik ithoꞌrkït thon.” ");
INSERT INTO lmd_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","AIeccuo iꞌrekat itti, “Amma pul iponthomat mparran pakot uꞌrotto ana nyumurra ana paik pangwot kaman kung, pul pella pamunye aꞌrupu wung. ");
INSERT INTO lmd_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Anaruk amma pul pꞌrek iponthoththomat paꞌrumothok mono apalkothok paneko aꞌrupu wothoꞌrak wung appik ia kwapponekkethe cïkït nan ana kwillillo iaꞌrupu ia kwonat okin opilingon.” ");
INSERT INTO lmd_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","AIeccuo appiꞌrekat itti, “Okkwi ipanïn thannoka aththut lakenen itti kwꞌrat lon lïn ana okkwi ipakinnittarothin ire kwaik pakïtto ngre ngin.” ");
INSERT INTO lmd_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Amma uꞌrupa iokithak waat nti ipul, waeo nocik iconthomat akwantot kaꞌran ika aikkoik nan. Anamma wanniot weret noucce wung itti, ‘Mpapakkot iman ima mpoththet nan.’ ");
INSERT INTO lmd_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ana amma wokkaprttakot wathiot man mollakot kicce ana mothettakotheik ");
INSERT INTO lmd_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ana waeo ana wanthan nuꞌrupa wꞌrek weꞌreꞌrapuruk iokithak cannan naak akin iꞌriko ipul ana okin thikkoik than. Ana pul ipakin thoꞌrot nan paka pokïtheththak cannan nocaꞌri conomun.” ");
INSERT INTO lmd_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Anakka oIeccuo pokat cik akwere, apul pꞌrek ipopari nti ithoꞌrkït thoul iꞌrekat itti, “Athoporot oka nopul ipopari ipokwonorung ana akieng ngïmmïk.” ");
INSERT INTO lmd_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","AIeccuo iꞌrekat itti, “Anaruk thopira noka thaka cannan nakkwion ithaik thaccïkot lon loKapik ana oreko ngngin.” ");
INSERT INTO lmd_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Anakka ul wokat aunukwot oIeccuo kwiꞌrekathekin itti, “Ul enni wolon ilokithak wipitto lon ilommaththik anaruk lella ilettat kin, lulluk ilommaththik ilokkattanthet oIunan. ");
INSERT INTO lmd_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ana ammakka oIunan pul pothernte lon loKapik pokat lon ilommaththik loul woNinua, ittina ukul wopul iponyi waka lon ilommaththik loul iaik inenni. ");
INSERT INTO lmd_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ili iopari wonoththok poCipa wurokot kapik nocaꞌri cothonceꞌret lon cik okin oul iaik inenni ana kwathokenekin itti nthokkothe lon moloko. Akka kwaat nci nacapu ciththan akwathoccïkot lon lothinaik nti ica loili ioccot kꞌran itti oCiliman. Ana inenni cene kwaik iprïk naIli oCiliman. ");
INSERT INTO lmd_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Nocaꞌri cothonceꞌret lon cik amma Kapik athonceꞌrenthet ul lon cik nocapu, ul wonokaꞌran koNinua wurokot kapik ana waceꞌrenthet non lon cik itti lon lon lamoloko, akka okin thokkaprttakot nti ithokkot lon ilokithak caꞌri ica oIunan pul pothernte lon loKapik perenet kin ana inenni cene kwaik iprïk naIunan.” ");
INSERT INTO lmd_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","AIeccuo appiꞌrekat itti, “Pul pella paccie thik nocuꞌru iconu ngaak iacco apantokuꞌrupot cerok nan ana manna onekket thoceken copapꞌrek. Anaruk kwwonu itti kwanekket cik attattar othakka itti amma okkwion ithanthant nthapat akin immaik. ");
INSERT INTO lmd_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Cït corica cakꞌran koka kang. Ana amma cït cang coporot ana ngkwimma kathar ikoporot na akko. Anaruk amma cokithak ana ngkwakinnimma kathar ikoporot na akko. ");
INSERT INTO lmd_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Nokkwo kunu ncik, akꞌran ikaik ianon okorronno oka ngïꞌrïmak. ");
INSERT INTO lmd_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ittina amma ka kang koppathe kꞌran, ana ngkwina kathar na aeo ana ngïꞌrïmak ngella, ka kang kaka koporot ere kꞌran amma akoccieik naung.” ");
INSERT INTO lmd_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Anakka oIeccuo pomarttot lon lung, apul pꞌrek nti iul woPriccin akkarathok tuan thanung akin othoꞌrkoik akin aththut, ittina oIeccuo piꞌrikathe noppan ana kwaththikkat cik nokuppuꞌrung kothuꞌrit. ");
INSERT INTO lmd_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Anaruk pul poPriccin pinakathe nan ana kwoprttakatherit akka oIeccuo pannilakko ammakka thathuma then akkwarthuk oꞌrkoik. ");
INSERT INTO lmd_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","AIli oIeccuo iꞌrekathok itti, “Ul woPriccin, onon thame eththeꞌret won ana maththak nthapat anaruk mïkït mon moppappathe thukungkun ana aꞌrupu iokithak. ");
INSERT INTO lmd_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Onon thomaik nti ima, lakannoka itti Kapik ikokkothe thapat kokkothe icarak than cakuruki? ");
INSERT INTO lmd_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Nome ikarak kon nthethet ul iella aꞌrupu cik ana onon thathakka thoporot noka appik. ");
INSERT INTO lmd_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Angkre, ul woPriccin akka onon thethet Kapik aꞌrupu wuluwuluk naꞌrupu kurekkurek iattul attul appik ana aꞌrupu iakkattat ngucul. Anaruk annopaꞌrine lon ilocoꞌrothe cik ana thongat thoKapik. Onon thira thaꞌrungkot nothethet Kapik aꞌrupu wuluwuluk nnaꞌrupu iaara, anaruk nokorronno ure naꞌrupu ioporot. ");
INSERT INTO lmd_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Angkre, ul woPriccin, akka onon thongothe aꞌran ioporot nomuththun maꞌrama ana nthongothe itti ul wamicco non keccuk. ");
INSERT INTO lmd_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Angkre, akka onon thungkot nupu noul ionyi inamuꞌruttakot icapu ana ul wacukkarot cik awomma itti okin thaik thacukkarot nupu cik inoppappathe ka ikokuttat.” ");
INSERT INTO lmd_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Apul pꞌrek nti iul iangkene lon lothonceꞌret lon cik iꞌrekat itti, “Pul ipangkene, akka menik ngkwaik pacungko nïn llon elli cakuruk.” ");
INSERT INTO lmd_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","AIeccuo othïat tit itti, “Angkre, onon ul iangkene lon lothonceꞌret lon cik, akka onon thakkiet ul lon loppot ilalkothekin ana onon manna thakorronno othie caun culukku itti onon thittarot kin. ");
INSERT INTO lmd_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Angkre, nanon akka onon akkuno nonupu preththere noul wothernte lon loKapik illet maꞌrot. ");
INSERT INTO lmd_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Onon thakene itti onon thongothe lon ila thiki thon thokkothe itti locoꞌrotheik okin thongwot ul wothernte lon loKapik ana onon thakkot nupu nopreththere. ");
INSERT INTO lmd_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ilen akka Kapik kerethe noucce wung itti, ‘Mpathïnthet kin ul wothernte lon lin ana ul wothothïlettat win aꞌrek akin ongwo ana aꞌrek akin occokiet thiak.’ ");
INSERT INTO lmd_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ilen akka ul wonomaꞌri emmi akkaka wonu lon louccuk ngoul wothernte lon lin iongwuttat nci ammakka capu ncik appik cokuꞌrettat ncik ");
INSERT INTO lmd_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","nnothokkuttat thApil oingkanthet oCekkeria okin ithonguttathe ithoꞌrkït thonoppan toKapik ana tuꞌrot tothokꞌret aꞌrupu wothokiot ngüccük cik. Ïï mpiꞌrethenon itti, ul wonomaꞌri emmi ien akkacco lon len ikkun appik. ");
INSERT INTO lmd_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Angkre, ul iangkene lon lothonceꞌret lon cik akka onon thullukkwinthet ul kathar ikiniekin lon loKapik. Onon ngka kon thanniꞌriko ana onon thoceꞌret okkwion ithaik thenekke itti okin thiꞌriko ilon loKapik.” ");
INSERT INTO lmd_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Anakka oIeccuo poththet nocik cen, aul woPriccin ana ul iangkene lon lothonceꞌret lon cik ikkat cik akin olikinok lon cik nci nokkït ana ipittittothok lon nuthuk. ");
INSERT INTO lmd_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Akin oꞌrïkothok amma akwiꞌre lon lꞌrek moloko akin occokothok. ");
INSERT INTO lmd_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Anakka cungkut coul woppot caꞌrntakothe tothun ana opilingon thꞌrek thikkatheik akin ocukkwarot pangken cik, aIeccuo iꞌrekat ul iammakothok cittokït itti, “Noꞌrumoik nolon ilanthan noul woPriccin ilammakka müꞌrükül ilammikkot ul. ");
INSERT INTO lmd_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Lon appik ilocukkwakot nan linako nan ana ilamuꞌruttakot littako ncik ");
INSERT INTO lmd_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ana ilanon therethe iꞌrïmak laccïkakot icïngkï ana ilerettathe thonu noppan lakkuttanthet kuri noꞌret.” ");
INSERT INTO lmd_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Akwappiꞌrekat itti, “Opuruko pingon, nokorronno ipo nꞌre nokkwion ithakkwot ka ana okin thakannappokkot lon lꞌrek. ");
INSERT INTO lmd_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Anaruk mpakenenon okkwion ithanon opellene. Nopellene okkwi ipakkwot ka ana kwonu puꞌran itti kwarrethung ciththothïrïn. Mpiꞌret non itti ook akka annopellene. ");
INSERT INTO lmd_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Nyaꞌrkang nyukuluk nyakannoketta nakucci weꞌrai? Anaruk ngella ngulukku ngurettat nan ngKapik. ");
INSERT INTO lmd_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Wan won wonoꞌra wongantettat appik. Ittina nokorronno ipo nꞌre akka onon akkoporot cannan nonyaꞌrkang.” ");
INSERT INTO lmd_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","AIeccuo appiꞌrekat itti, “Mpiꞌret non lon ïcat itti okkwi ipiꞌre tokït koul itti kwinan, ukul wopul iponyi wiꞌre itti winak tokït kouꞌrupa wothothïlettat woKapik. ");
INSERT INTO lmd_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ana okkwi ipoꞌruminthin kït tokït koul, mpaꞌruminthok kït tokït kouꞌrupa wothothïlettat woKapik. ");
INSERT INTO lmd_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ana okkwi ipere llon lokithak nokkul wopul iponyi, lon lung laccïkakot anaruk okkwi iperet Kanang ikupupure llon ilokithak lon ilokithak lung lakorronno occïkakot. ");
INSERT INTO lmd_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Amma onon thonekittathe nomuththun maꞌrama ana tokït konili ana ul ionu lon ikkun, nokorronno ipo nꞌre itti nthrrot noka kon tat ana manna itti onon thiꞌre itti tat. ");
INSERT INTO lmd_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Akka Kanang ikupupure kakenenon caꞌri cen itti nthiꞌre tat.” ");
INSERT INTO lmd_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Apul pꞌrek nti icungkut coul iꞌrekat oIeccuo itti, “Pul ipangkene, iꞌrethe opangkin akwopettinin aꞌrupu wopappa ianïn opakkot nan.” ");
INSERT INTO lmd_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","AIeccuo othïanthok tit itti, “Pangkin, oththa akkonekkethin cik itti mpakꞌrinenon lon lon ana illillinenon iaꞌrupu won ianon thopakkothe nan?” ");
INSERT INTO lmd_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ittina akwappiꞌrekat kin itti, “Nokkwo kunu ncik ana oꞌrumoik nolon lothrïk nan ncik appik akka thikkoik thopul iponyi thannoka itti pul pana thaꞌrthan thoppot.” ");
INSERT INTO lmd_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Akwerekanthet kin lon elli nthokkwie lon kuru ncik itti, “Capu cꞌrek cokat cik copul ipapaꞌrthan cokwonot mïl moppot. ");
INSERT INTO lmd_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Akwiꞌrekat noucce itti, ‘Ngintha akka anokkot? Mpella kaꞌran ika anipot mïl tit.’ ");
INSERT INTO lmd_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ittina akwiꞌrekat ka kung itti, ‘Katha elli akka anokkot mpangwo irit win appik anuno aꞌrek ittïttïk ana ien akka anipot mïl tit appik ana aꞌrupu wꞌrek. ");
INSERT INTO lmd_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ana caꞌri cen anopira noka anomekat ka kin itti, Ngkwonu aꞌrupu woppot wakanno omttat aththaman noluput ilanthan. Okathacce lon nuthuk, oꞌrku thuꞌrit ana ïcat cik ana apira noka.’ ");
INSERT INTO lmd_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Anaruk aKapik iꞌrekathok itti, ‘Katha oung emprïk ngkwommaik nti ica. Ngkoꞌra engi ngkwaik pio ana oththa akkapakkot naꞌrupu ia ngkwipinthet ka kang cik?’ ");
INSERT INTO lmd_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Laka ittina noul ipinthet ka ken aꞌrupu cik anaruk okin thannïꞌrïko lon len okin oKapik loporot.” ");
INSERT INTO lmd_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ittina aIeccuo iꞌrekat ul iammakothok itti, “Ilen akka aniꞌrenthet non itti nokorronno opellene lon lothikkoik thon itti ngimpen akka annoꞌrko ana ngimpen akka annako. ");
INSERT INTO lmd_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Akka thikkoik akkoporot cannan nothuꞌrit ana ka akkoporot cannan noret. ");
INSERT INTO lmd_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Nantokatha nongkorak akka nakannora ana nakannokio ana nella irit cik iakin ipot mïl tit anaruk Kapik akkaꞌrikiekin. Onon thoporot cannan nouꞌrupe. ");
INSERT INTO lmd_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Oththa nti ianon iparttot caꞌri culukku nomaꞌri mothikkoik mung amma kwonu nꞌre? ");
INSERT INTO lmd_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Inakka onon thomma arttot caꞌri culukku nothikkoik thon, ngintha akka onon opellene itti onon thaꞌrko ngimpen ana ako ngimpen? ");
INSERT INTO lmd_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Nantokatha tat akka poꞌren ocokka. Pakannoreko apakie ka ken. Anaruk mpiꞌret non itti manna oCiliman nthaꞌrthan thung ithrïk, kwakannako eret wopeththere ere poꞌren empi. ");
INSERT INTO lmd_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Amma Kapik kaꞌrumo noraco irakaik inenni ana ngorrot arorrettat ithik, Kapik kakannoꞌrumo nanoni? onon ithonu thoccokot lon loKapik nomïkït thoththeik. ");
INSERT INTO lmd_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ittina nokorronno onekket mïkït naꞌrupu ianon oꞌrko ana ïkko, nokorronno opellene lon len. ");
INSERT INTO lmd_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Akka ul wonocapu ncik appik iomma lon loKapik wammakot aꞌrupu ammakka enni appik anaruk oththe pon pina itti nthongothe aꞌrupu wen. ");
INSERT INTO lmd_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Anaruk nipitto ngili ngoKapik ana aꞌrupu enni wettat non.” ");
INSERT INTO lmd_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Lungkat lin, nokorronno ona nꞌre akka oththe pon popirat noka itti kwethet non ngili ngung. ");
INSERT INTO lmd_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Okette aꞌrupu ia ngkwonu aikket ul iella aꞌrupu cik. Aꞌrntinthet ka kang aꞌruk wothaꞌrthan tothiꞌrot ithakorronno okïttako ana na athoꞌrumako nan ana pul pothuꞌran pella ipamunye ana na nangak nella inacukwiet. ");
INSERT INTO lmd_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Akka cïkït cang caka na thaꞌrthan thang thaik cakuruk.” ");
INSERT INTO lmd_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","AIeccuo aꞌrungkat noꞌron akwere itti, “Okuccekinthet ngre cik karkkopul ipakot eret wore ana kꞌran kothik kung kocciettat. ");
INSERT INTO lmd_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Oka ammakka ul iaik waꞌrikot opït pen amma akwokkaprttako ntan nti ithïpa akin ina akka akin anyinok kathat koricürük aththaman. ");
INSERT INTO lmd_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Laka loporot noul iareko tuan itti opït pen poruan pathiot kin akin thaik ngkït thapat amma kwaat, mpiꞌret non lon ilaik ïcat ook ngka kung kwako eret wore ana kwikkiekin cik, akwikkekat kin thuꞌrit akin oꞌrko. ");
INSERT INTO lmd_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Okin thapira noka cannan amma kwaththiot kin ngkït thapat amma manna kwantanthan thampang thongkꞌra cannan. ");
INSERT INTO lmd_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Anaruk nina nan itti, amma pul poruan pappina caꞌri ica pul pothuꞌran paik panthan nan, kwira pannokorronno pul pothuꞌran apiꞌriko noppan. ");
INSERT INTO lmd_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ittina nokuccekot cik cakuruk akka ukul wopul iponyi wanthan nocaꞌri icanon thomma itti kwaik pao nan.” ");
INSERT INTO lmd_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","APoththuruc ipittat Ili oIeccuo lon itti, “Ili, ngkwaik peret nïn llon ilokkwiettat kuru ncik ellii? Okorronno oka meniki, ngkwaik peret ul appiki?” ");
INSERT INTO lmd_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","AIli oIeccuo othïat tit itti, “Pul ipaccokot lon ana ipinaik nti ica ana okuccet loncik papenang, ook okkwi ipa pul iprïk onekket cik ipakatha lon loul iarekinok apethet kin thuꞌrit nocaꞌri icoporot. ");
INSERT INTO lmd_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Laka loporot cannan nopul ipareko pen ipa apït athiot akwokkot ngre papenang amma kwokkaprttakot ntan. ");
INSERT INTO lmd_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ittina mponu itti mpiꞌret non ïcat itti opït pethok lon lokaman ikkun appik. ");
INSERT INTO lmd_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Anaruk amma pul ipareko popri itti, ‘Opït pin paccoik kwannao aththaman,’ akwikkat cik akwokkwe ul iareko iomura ana iari ana akwikkoik akwoꞌrko thuꞌrit ana ïkko ngapak ana okkwiet ka kung ngapak. ");
INSERT INTO lmd_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Menik opït popul ipareko panthan nocaꞌri ana nocïngkï ica pul ipareko pomma nan itti kwaik panthan nan. Ana amma kwaat kwaccokiethok thiak cannan akworrekathok iul iannoccïkot lon nomïkït. ");
INSERT INTO lmd_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Pul ipareko ipina ngre ngopït ana pannokuccekinthet cik manna okorronno oreko ngre inga apït ponu itti ngarekitta, kwapoko cannan. ");
INSERT INTO lmd_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Anaruk okkwi ipommat ngre ngopït ana ipakkot lon moloko, kwapoko uꞌret wotteik. Ana amma opilin peettathe aꞌrupu woppot aꞌrupu woppot wipittakothok ana okkwi ipoccokiettathe aꞌrupu woppot, ana kwipittakot aꞌrupu woppot cannan.” ");
INSERT INTO lmd_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","AIeccuo appiꞌrekat itti, “Mpaat paththokwot thik nocapu tholon lothonceꞌret lon cik ana mpappongothe itti amma thokurathe ana thaik thacco. ");
INSERT INTO lmd_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Mponu itti mpaccokot thiak cannan. Mpannoka poporot noka ana mpaꞌrungkot pannoka poporot noka puccuk athoccokot thiak omttakat. ");
INSERT INTO lmd_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Nthame itti ikkre mpaat nocapu anona thikkoik thoporori? Aa, mpiꞌret non itti, okonnoka thikkoik thoporot anaruk thopettakorit. ");
INSERT INTO lmd_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Nciki inenni oingkat puccuk, ul woruan waik ukuluk willakorit weꞌra ana wꞌrapuruk, ieꞌra wꞌra lon lopangon ithꞌrapuruk ana iꞌrapuruk wꞌra lon lopangon itheꞌra. ");
INSERT INTO lmd_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Okin thillillako tit oththan ponyukul pꞌra lon lonyukul ana nyukul nyꞌra lon loththan pen, ana onnan pꞌra lon lonyukul inyari ana nyukul inyari nyꞌra lon lonnan pen, ana opïthe pꞌra lon lari wonyukul nyung ana ari wonyukul nyung wꞌra lon lonnan polle.” ");
INSERT INTO lmd_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Akwiꞌrekat cungkut coul itti, “Amma onon thimmat anuththe aꞌrntakot ithiꞌrot na acïngkï arungko, anniꞌre itti kapik kaik kapo ana kapo ïcat. ");
INSERT INTO lmd_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ana amma kanang okkurarot nthokkun wothothari amma akatha nacïngkï ummot ngngin, nthame itti cik caik cathakka cippa ana ïcat cathakka cippa. ");
INSERT INTO lmd_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Onon ithongothe itti nthinnikot lon, onon thina akka annina cik corothiꞌrot ana conocapu. Ngintha akka nthommanet lon ilaik inenni?” ");
INSERT INTO lmd_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Nthontha akka nthꞌrat okwarttikinthet ka kon lon iloporot annokkot? ");
INSERT INTO lmd_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Amma pul pꞌrek porukwethung mpapꞌrek, akwancot kathar ikanon okꞌro lon len anon thaik nokathar anneo imakkma. Amma onon thannokꞌro lon naththeꞌra, ana kwanekothung tokït kopul ipakkma ana pul ipakkma pethung pul iprro ana pul iprro parrethung ikorrkkor. ");
INSERT INTO lmd_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ana amma ellrïk lokkattathe mono arrettat ikorrkkor ngkwannoppot thapat kirrkkir puccuk aeekat kin akucci wokït iokwentakot.” ");
INSERT INTO lmd_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Caꞌri cen ul wꞌrek wokat cik iꞌrethe oIeccuo lon loul wonoththok poCelïl ia ili oPilaththoc pongwot caꞌri icakin thokat akin ethet Kapik aꞌrupu wothokiot ngüccük cik noppan toKapik. ");
INSERT INTO lmd_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","AIeccuo othïat tit itti, “Ntheret nomïkït mon itti ul enni wonoththok poCelïl wokat wolon ilokithak cannan noul wꞌrek appik woCelïl akka okin thokkiettathe thiak ngkathar ngngki? ");
INSERT INTO lmd_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Mpiꞌret non itti annoka menik, anaruk amma onon thannopaꞌrine lon cik ilokithak onon thille appik cakuruk. ");
INSERT INTO lmd_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Laka laraththa noul iokat willet iattul ana ikken mormor (18) ia kaman ikukwit kukwit kapothe nan korikꞌral koCiluam? Nthame itti okin thokat tholon ilokithak cannan noul iaik nokaꞌran koUruccelim appiki? ");
INSERT INTO lmd_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Mpiꞌret non itti annoka menik anaruk amma onon thannopaꞌrine lon cik ilokithak cik ana onon thille appik.” ");
INSERT INTO lmd_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","OIeccuo piꞌrekathe ul lon elli okkwie kuru ncik, itti, “Pul pꞌrek pokat cik ponat pira popïcït ittak akwoingkat itti kwothiththo nyukul nyen anaruk kwakanniat nyukul. ");
INSERT INTO lmd_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Menik apul iꞌrekat pul ipakathanok lon lottak itti, ‘Luput lothakkat lꞌrapuruk anaukko cene itti mpiththo ïcït nopïcït anaruk anokorronno incet aththik. Okiotheik, ngintha akka apokittinthet karak cik?’ ");
INSERT INTO lmd_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Apul ipakatha lon lottak iꞌrekathok itti, ‘Opït pin, antokorronno thuput thulukku anorane cik anipot pocok tit. ");
INSERT INTO lmd_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Amma pokwonot nyukul thuput ithanthan laka loporot. Ana amma pannokwono antokiot cik.’” ");
INSERT INTO lmd_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ana nocaꞌri caCcepith aIeccuo pappokat cik akwongkene ul lon nocuththun caꞌrama. ");
INSERT INTO lmd_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ana pul pꞌrek ipopari pokat cik cïnang ipa uꞌrupa iokithak wothikkiet kimico ana ponu luput attul ana ikken mormor (18) pappuꞌrumakot cik ana pommat ocoꞌrot tit kirrkkir. ");
INSERT INTO lmd_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Anakka oIeccuo pimmarok akwakkarathok tokït koul akwomekathok itti, “Pul ipopari, ngko ngkwothikkiettat poporot nomio mang.” ");
INSERT INTO lmd_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ittina akwonekkekat nyaun naak apul ocoꞌrat tit accokkot akwopirakanthet Kapik noka. ");
INSERT INTO lmd_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Apul iprïk ponocuththun caꞌrama uakat ka akka oIeccuo pittiethe pul ipopari nocaꞌri caCcepith apiꞌrekat ul itti, “Maꞌri maik mꞌrakkuruk mongre nanthan annittiettat nan annoka nocaꞌri caCcepith.” ");
INSERT INTO lmd_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","AIli iꞌrekathok itti, “Onon ithinnikot lon, opilin nti ianon pannokꞌro ngura ngung ana ngeꞌringka nothoꞌrak nocaꞌri caCcepith akwothïkkïe ngꞌrii? ");
INSERT INTO lmd_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Pul ipopari empi pothiki thAprein ipa pul pothopulut pïꞌrïkïkkot thupuththuput luput attul ana ikken mormor lakannoka loporot itti kwelikkako nti iloꞌrak nocaꞌri caCcepethi?” ");
INSERT INTO lmd_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Anakka kwiꞌret lon elli, aul appik iꞌrat lon lung othiakat cik anaruk ul wopirakathe noka appik nolon ilopreththere ila kwokat akwokkot. ");
INSERT INTO lmd_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ittina aIeccuo iꞌrekat itti, “Ngili ngoKapik ngungkot ngintha ana ngintha akka anungkie ngngin? ");
INSERT INTO lmd_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ngili ngoKapik ngungkot core icoththe cannan iceera nocapu. Pacokka apothakkakat pira ana uꞌrupe wuno nune nouꞌri wen.” ");
INSERT INTO lmd_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","AIeccuo appipittat lon itti, “Ngintha akkungkot ngili ngoKapik? ");
INSERT INTO lmd_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ngili ngoKapik ngikkoik ere müꞌrükül ima pul ipopari pocikittot mmꞌre moppot mono amꞌre inyakat ncik appik.” ");
INSERT INTO lmd_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ittina aIeccuo oingkat okko ikarkoman ana naꞌran akwongkene akka kwokat cik akweo nokaꞌran koUruccelim. ");
INSERT INTO lmd_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Apul pꞌrek ipittathok itti, “Ili, ul wathoꞌrettat wotteik tulluki?” AIeccuo othïanthet kin tit itti, ");
INSERT INTO lmd_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Noꞌrumoik annina akka anniꞌriko nti icürük cokathat icomü akka mpiꞌret non itti, ul woppot wenekke itti wiꞌriko anaruk okin thakinniꞌriko. ");
INSERT INTO lmd_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Amma pul pokaman purokot mono unukkwot kathat ana nthacoꞌro thapat annakkakkaro ana annuet cik itti, ‘Paththi, anyinet nïn kathat.’ Anaruk kwathïot tit itti, ‘Mpommanon, ana manna itti onon thaat ngkartha.’ ");
INSERT INTO lmd_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ana onon thiꞌre itti, ‘Oron thoꞌrkot cik tothun ana ngkwongkenet iathar nakaman kïn kaik.’ ");
INSERT INTO lmd_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ana kwathïot tit itti, ‘Mpommanon, ana manna itti onon thaat ngkartha. Nopaꞌroik ntokït kin, onon ul appik iakkot lon ilokithak.’ ");
INSERT INTO lmd_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Caꞌri cen onon thoo ana okꞌrellot kïnyït thocipit amma onon thimat Aprein ana oIccaak ana oIakup ana ul appik wothernte lon loKapik ingili ngorothiꞌrot anon ngka kon thorrettathe thapat. ");
INSERT INTO lmd_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ul wanthan na acïngkï ummot ngngin ana na acorungkwot ana nthokkun wothokure amma akatha na acïngkï ummot ngngin ana thokkun wothothari amma akatha na acïngkï ummot ngngin ana wathikkoik nokamuthe ingili ngoKapik. ");
INSERT INTO lmd_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Okkwion ithaik tokït inenni thathoka thoceken ana okkwion ithaik thoceken inenni thathoka tokït.” ");
INSERT INTO lmd_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Caꞌri cen aul wꞌrek woPriccin akkakanthet oIeccuo aiꞌrekathok itti, “Opaꞌrik ncene aeo imakkren oIruthuc pongothe itti kwakkwothung.” ");
INSERT INTO lmd_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","AIeccuo othïanthok tit itti, “Ngkonon aniꞌret pul emprïk ipokithak itti mpakïcce uꞌrupa iokithak ana ittiet ul iongo inenni ana ngorrot ana nomaꞌri imꞌrapuruk mpamartto lon lin. ");
INSERT INTO lmd_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Anaruk mpaik nokathar inenni ana ngorrot ana nomaꞌri imomakothe mpiꞌret non ïcarïcat itti, pul pella pothernte lon loKapik piot nokaꞌran koka nokaꞌran koUruccelim.” ");
INSERT INTO lmd_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Uruccelim, Uruccelim, oung ipangwo ul wothernte lon loKapik ana okincot ul cik iothïlanthet non antokatha maꞌri mornoththa ima mpenekket itti mpaꞌrntot non tothun ammakka thakuꞌruk aꞌrntot opeon iuꞌruccu ana onon thꞌrat. ");
INSERT INTO lmd_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Nokatha kaman kon kei koththettanet non nan thellek. Mpiꞌret non ïcat itti onon thakinnimman attang puccuk acaꞌri akkakat ica anniꞌret itti, ‘Athethïe oka nopul ipaat ngkꞌran koIli.’” ");
INSERT INTO lmd_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Caꞌri cꞌrek caCcepith caIeccuo pappeot tuan topul pꞌrek iprïk nti iul woPriccin akin thoꞌrkoik. Kwokat akwoccurat kït nan papenang. ");
INSERT INTO lmd_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Cïnang apul pꞌrek ocoꞌrat tokït koIeccuo poththakathe tacok cik. ");
INSERT INTO lmd_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","AIeccuo ipittat ul woPriccin ana ul iangkene lon lothonceꞌret lon cik akwiꞌrekat kin itti, “Lon locoꞌrotheik itti pul pittiettat nocaꞌri caCcepithi? ana amma okorronnok itti ïï pakinnittiettari?” ");
INSERT INTO lmd_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Anaruk okin thangkatheik menik aIeccuo onekat pul akwittiekat akwothïat ikathar. ");
INSERT INTO lmd_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ittina kwipittathekin itti, “Amma opilin nti ianon ponu ukul ana manna ngura ngapothe irok nocaꞌri caCcepith, ngkwakannontho nti iroki?” ");
INSERT INTO lmd_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ana okin thellakathe ilakin iꞌre. ");
INSERT INTO lmd_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Anakka oIeccuo pinat itti ul iakkarakot wummo aꞌran iathiakine cik wocittokït aikkoik nan akwokkwiekanthet kin lon kuru ncik itti, ");
INSERT INTO lmd_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Amma opilin pakkarothung kamuthe kothipa kirrnni ikkoik nokaꞌran ikathiakine cik akka opilin pikko paththoka pakkarakot cakuruk ipathiakine cik naung. ");
INSERT INTO lmd_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Akka pul poruan ipakkarot non aththuththeꞌra panthan ana pamethung itti, ‘Urokinet pul empi nokaꞌran engki apikkoik.’ Ittina athiakat cik aurokat athikkat cik thoceken. ");
INSERT INTO lmd_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Anaruk amma ngkwakkarakothe kamuthe kꞌrek ikkik ciththoceken ana amma pul ipakkarorung paat ana pamethung itti, ‘Opuruko pin, aꞌrik athikkoik nokaꞌran ikoporot.’ Ittina ngkwaka pothiakinet cik tokït kopuruko pangon ithakkarakot appik. ");
INSERT INTO lmd_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Akka okkwi ipathikkie ka kung prïk kwathikkietta potte, ana okkwi ipathikkie ka kung potte kwathikkietta prïk.” ");
INSERT INTO lmd_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ittina aIeccuo iꞌrekat pul ipakkarro ul itti, “Amma ngkwokkothe thuꞌrit korronno akkarot opuruko pangon ana opangkangon ana ul ionu kaman iccik kang iaaꞌrthan akka amma ngkwakkarot kin ana okin thaꞌrkoik ana okin thakkarothung kamuthe ken cakuruk ana ittina ngkwokkettat pꞌrïn. ");
INSERT INTO lmd_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Anaruk amma ngkwonu kamuthe akkari ul iella aꞌrupu cik ana ianiꞌrilla ana iaimico ana iꞌrimathe ");
INSERT INTO lmd_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ana ngkwethïettat cik. Akka okin thomma ethung lon iloporot, Kapik akkethung lon iloporot nocaꞌri ica ul ioporot uroko nti ithio.” ");
INSERT INTO lmd_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Anaruk akka puꞌrek nti iul iokat cik nokuppuꞌrung kothuꞌrit okin oIeccuon poccïkothe lon len akwiꞌrekat oIeccuo itti, “Thethïe thaka nopul ipaꞌrkoik nokamuthe ingili ngoKapik.” ");
INSERT INTO lmd_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","AIeccuo othïat tit itti, “Pul pꞌrek pokkothe kamuthe mono apakkarat ul woppot. ");
INSERT INTO lmd_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ana nocaꞌri cokamuthe kwothïathe ul wung iarekinok athiꞌret ul iokat wakkarakot itti, ‘Wanthan akka thuꞌrit thokuccettatheik pꞌrïn appik ana kamuthe kaik kathokkattat.’ ");
INSERT INTO lmd_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Anaruk okin appik thikkatheik akin ere lon kurekkurek ilannokorronnokin itti okin thaeo. Opaththi porokït piꞌret itti, ‘Mpurno okero kopon ana mpaik pathokatha ana ngkwakorronnon aneo.’ ");
INSERT INTO lmd_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Apilin iꞌrekat itti, ‘Mpurno okero nyura attul inyarako ngngin ana mpaik pathenekke ana ngkwakorronnon aneo.’ ");
INSERT INTO lmd_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Apilin iꞌrekat itti, ‘Mpurnnipo pari ana mpaik pakannanthan.’ ");
INSERT INTO lmd_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Apul ipareko okkaprttakat ntan apathiꞌrekat opït. Ittina apul poruan uakat ka apothïat pul ipareko itti, ‘Ngko cokoccokot akkatte iathar ittïttïk ana iarran woricarak coman aipo ul ntan cene iella aꞌrupu cik ana ul iomma onyaro ana iiꞌrimathe ana ul iaimico.’ ");
INSERT INTO lmd_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Apul ipareko iꞌrekat opït itti, ‘Lon ila ngkwiꞌret itti lakkattat lokkattathe appik anaruk icci lꞌrek lappokkattat.’ ");
INSERT INTO lmd_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Apït iꞌrekat pul ipareko itti, ‘Ngko akkette iathar ittïttïk ana iarran wokaman aiꞌret ul anthan puccuk akaman kin oppakat nul. ");
INSERT INTO lmd_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Mpiꞌrethung itti pul pella nti iul iakkarakot pinot thuꞌrit enthi aththik.’” ");
INSERT INTO lmd_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ul wakat cik cungkut coppot ammakot oIeccuo akwoprttakat kin akwiꞌrekat itti, ");
INSERT INTO lmd_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Amma opilin painin ana kwakannongathin cannan naththan ana onnan ana opari ana nyukul nyung ana opangon ithomura ana ithari ana manna thikkoik thung, kwannothakka pul pin ipammakothin. ");
INSERT INTO lmd_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Okkwi ipakannangkot itti kwaccokot thiak ana io nti ilon lin kwannothakka pul pin ipammakothin. ");
INSERT INTO lmd_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Nantome itti opilin pongothe nti ianon itti kuno man mïttïk ana mukwit. Kwannikkoik kappak akwothangante cekerek caꞌrupu iunta ngngin akwokatha itti amma kwonu akucci woppot iamarttinok ngrei? ");
INSERT INTO lmd_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Akka amma kwokkothe millang mono akwomma omartto thuno, okkwi ipimma lon len paccirok ngngin ");
INSERT INTO lmd_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","akwiꞌre itti, ‘Opaththi empi purokiet man ncik itti kuno ana kwomakathe omartto.’ ");
INSERT INTO lmd_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Nantome itti ili waik wathorro iili wꞌrek, wannikkoik athangante ul worithoꞌrak wung akwokatha itti amma ook akkarro ili wen ionu ul worithoꞌrak athar arrial (20,000) nul wung worithoꞌrak iaik athar attuli (10,000)? ");
INSERT INTO lmd_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Akka amma lalkothok itti kwannorro iaak kwathïot pul apothipitto lon lothopakkot ikuꞌri akkwarthuk ciththan. ");
INSERT INTO lmd_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Laik menik cakuruk okkwi ipannopaꞌrine lon cik appik, kwannothakka pul pin ipammakothin.” ");
INSERT INTO lmd_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Nguculoththu ngoporot anaruk amma ngothakkat ngocalang, ngappothikkietta ngira taththa? ");
INSERT INTO lmd_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ngannoka ngoporot nocapu ana nopocok anaruk nguntat cik. Okkwi iponu unu itti kwoccïkot akwoccïkot.” ");
INSERT INTO lmd_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Caꞌri cꞌrek cokat cik aul iaꞌrntinthet nili akucci ana ul wolon ilokithak wokat cik iccik koIeccuo accïkot lon lung. ");
INSERT INTO lmd_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Anaruk ul woPriccin ana ul iangkene lon lothonceꞌret lon cik ikkat cik aerekot itti, “Pul empi pikkiet ul cik ionu lon ilokithak ana okin oꞌrkoik akin aththungon.” ");
INSERT INTO lmd_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Menik aIeccuo iꞌrekat lon okkwie kuru ncik itti, ");
INSERT INTO lmd_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Nantome itti amma opilin nti ianon ponu lungkat arrial ukuluk (100) mono athungkat thulukku urat cik ntipangen. Kwannoththe nolungkat ilarrial wocoꞌrin ana alkaire ana ikken ukulacoꞌrin (99) akwothokwantot thungkat ithulukku ithuratheik ipira thapat puccuk akwiari? ");
INSERT INTO lmd_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ana amma kwiothe kwapira noka akwonekat tocalak ");
INSERT INTO lmd_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","akwopakkat ngngin tuan. Ittina amma kweot tuan kwakkaro opurukon ana ul wonocürük appik akwomet kin itti, ‘Nanthan unopira noka akka mpiothe thungkat thin ithokat thuratheik.’ ");
INSERT INTO lmd_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Mpiꞌret non itti laka menik cakuruk, thopira noka thakaik tothiꞌrot mpul pulukku ipakkoik nti ilon ilokithak noul iaik arrial wocoꞌrin ana alkaire ana ikken ukullacoꞌrin ioporot iannangkot itti okin thakkaprttako nti ilon iokithak.” ");
INSERT INTO lmd_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Nantome itti amma pul ipopari ponu akucci attul ana kuretheik nan kulukku kwannothoccie thik ana ollaik noppan appik ana okwantot cik kicce kicce puccuk akwiari? ");
INSERT INTO lmd_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ana amma kwiothe kwakkaro opurukon ana ul wonocürük akwomet kin itti, ‘Nanthan unopira noka akka mpiothe ka kucci kin ikakkuratheik.’ ");
INSERT INTO lmd_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Mpiꞌret non itti, ittina cakuruk uꞌrupa wothothïlettat woKapik wapira noka nopul ipokkarttakot nti ilon ilokithak.” ");
INSERT INTO lmd_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","AIeccuo appikkat cik akwere okkwie lon kuru ncik itti, “Puꞌrek pokat cik ponu nyukul nyeꞌra. ");
INSERT INTO lmd_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Aukul iotte iꞌrekat oththan itti, ‘Pappa, opettinet nïn iaꞌrupu aethin ain.’ Ana kwillillanthet kin iaꞌrupu. ");
INSERT INTO lmd_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Aukul iotteik ikkat cik papotteik aꞌrntat aꞌrupu wung appik ia kwoccot akwoingkat ngngin ci noththok poka akwokïttat aꞌrupu wung cik nuthuk appik ia konat. ");
INSERT INTO lmd_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Manakka kwokïttothe aꞌrupu wung cik appik arï oꞌrat cik noththok pen appik tommaththik arï ikkat cik arokkwothok akka kwellat papꞌrek cik ipa kwoꞌrko. ");
INSERT INTO lmd_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Menik akwoingkat akwothorekat nopul pꞌrek ponoththok pen ipothïathok topon itti akwothoꞌrilikie nuththuruk thuꞌrit. ");
INSERT INTO lmd_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ana kwappongothe itti kwaꞌrko thuꞌrit thonuththuruk itha kwokat cik akwikket anaruk pul pellakathe ipethok. ");
INSERT INTO lmd_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Anaruk kwopakkekathe lon nocïkït akwiꞌrekat itti, ‘Ul wornoththa iapappa porekiet tuan ana thuꞌrit thaik thoppot ana cene anio ntï. ");
INSERT INTO lmd_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mpaeo anopakkinthet opappa anomethok itti, Pappa, mpokkothe lon moloko tokït koKapik ana tokït kang. ");
INSERT INTO lmd_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Mpakannoka pekkot nan itti mpakkarako itti ukul wang. Othikkien pul iparekinung.’ ");
INSERT INTO lmd_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ittina akurokat akwopakkanthet oththan. Anaruk akka kwokat cik akkwarthuk ciththan, oththan pimmakathok athiak oppakat nocïkït thokkul wung. Akwollat taak akwïꞌrïkathok topere. ");
INSERT INTO lmd_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Aukul iꞌrekathok itti, ‘Pappa, mpokkothe lon moloko tokït koKapik ana tokït kang. Ana mpannekko itti mpakkarako itti ukul wang.’ ");
INSERT INTO lmd_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Anaruk oththan piꞌrekathe ul iorekot tuan itti, ‘Nona eret iie iopeththere annakiek cokoccokot. Nakiek callong nocaun ana wok iracok. ");
INSERT INTO lmd_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Nona ngura iotte iittathe annokkwot. Ntürün oꞌrkoik ana ukkwo. ");
INSERT INTO lmd_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Akka ukul win enni wokat wiot ana wokkot cik ana wokat wuratheik ana wincathe.’ Ittina akin ikkat cik akin oꞌrkoik ana ukkwo. ");
INSERT INTO lmd_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Anaruk ukul wung irïk wellat ntopon manakka akko napuththut tuan accïkat ciririk ana ngïca. ");
INSERT INTO lmd_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ittina kwakkarathe pul pꞌrek ipareko tuan ana kwipittathok itti, ‘Ngintha akkaik tuan?’ ");
INSERT INTO lmd_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Apul ipareko othïnthok tit itti, ‘Opangkang paat ana oththe pokkwinthok ngura iotte iittathe akka kwokkaprttakot poporot.’ ");
INSERT INTO lmd_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ukul irïk wuakathe ka ana wꞌrakathe iꞌriko noppan. Menik oththan poppanthok thapat akuethok itti kwiꞌriko noppan. ");
INSERT INTO lmd_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Anaruk kwiꞌrekathe oththan itti, ‘Antokatha luput elli appik mpokat anorekinung cannan ere piak ana mpannarrot lon lang cik aththik ana ngkwakannethin manna ïmït wulukku anokkwot ïnnoꞌrko ïnopuruko pingon. ");
INSERT INTO lmd_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Anaruk akka ukul wang enni ioccot aꞌrupu wung appik ana waththokïttot cik akin oul iari iaꞌro nul nuthuk ana waat tuan ana ngkwokkwinthok ngura iotte iittathe.’ ");
INSERT INTO lmd_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Aththan iꞌrekathok itti, ‘Ukul win, ngkwaik iraththeꞌra appinappin ana aꞌrupu win appik ien wang. ");
INSERT INTO lmd_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Anaruk oron thonu itti oron thakkot kamuthe ana opira noka akka opangkang empi pappuratheik ana kwincathe ana kwappokat piot ana kwokkot cik.’” ");
INSERT INTO lmd_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","AIeccuo iꞌrekat ul iammakothok itti, “Pul pꞌrek pokat cik papaꞌrthan ana ponat pul iporekinok aul onakanthok lon itti pul iparekinok paik pakïttïnok thaꞌrthan. ");
INSERT INTO lmd_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ittina apul ipapaꞌrthan akkarathok akwipittathok itti, ‘Lon liatha elli ila mpaik paccïkot aul erethung ngngin? Okenen ngintha akka ngkwokkothe akka ngkwannapporekinin pꞌrïn.’ ");
INSERT INTO lmd_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Apul ipareko erekat noucce itti, ‘Ngintha akka anokkot inenni akka opït pin paik panekothin ngre? Ana mpomma ipot cik ana mpothiat cik ipittot ul aꞌrupu.’ ");
INSERT INTO lmd_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Akwiꞌrekat itti, ‘Mpina lon ila anokkot akka amma kwopaꞌrerin cik nore aul ina akka aikkien cik tuan thanen.’ ");
INSERT INTO lmd_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Menik akwakkarat ul iokat wannokke aꞌrupu wopït pung akwipittat okkwi porokït itti, ‘Ngkwonu kamucu kornoththa ikokwentakot nocalak cang kopït pin?’ ");
INSERT INTO lmd_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Apaththi pen othïat tit itti, ‘Kokwentakot melun maak ngoceththun arrial ukuluk maꞌri mormor (800).’ Apul iparekinok iꞌrekathok itti, ‘Oneki kaꞌrmacak akurro itti ngkwokwentakinet melun maak ngoceththun arrial ukuluk maꞌri mocoꞌrin (400).’ ");
INSERT INTO lmd_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Akwappipittat opilin itti, ‘Ana ngkwokwentakinet kamucu kornok?’ Akwiꞌrekathok itti, ‘Mpokwentakinet othan womïl kathar kulukku (1000).’ Apul ipareko iꞌrekathok itti, ‘Oneki kaꞌrmacak akurro itti ngkwokwentakinet arrial ukuluk maꞌri moromor (800).’ ");
INSERT INTO lmd_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Opït pen pomerekekathe pul ipakannoreko ncïkït culukku nothinangka. Akka ul wonocapu enci winangka okkot lon lonocapu. Anaruk ul wongili ngoKapik wannoka winangka llon lonocapu.” ");
INSERT INTO lmd_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","AIeccuo iꞌrekat itti, “Nokkot thuruko nthaꞌrthan thon thonocapu akka amma thaꞌrthan thomarttakot annina akka annikkiettaik ikaman kothupuththuput. ");
INSERT INTO lmd_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Okkwi ipoꞌrumot nolon ilotteik kwaꞌrumo nolon iloppot cakuruk ana okkwi ipannoꞌrumo nolon ilotte kwannoꞌrumo nolon iloppot. ");
INSERT INTO lmd_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ittina amma ngkwappannoꞌrumo nolon lonocapu papenang, oththa akkethung lon lothaꞌrthan ithaik ïcat? ");
INSERT INTO lmd_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ana amma ngkwannoꞌrumo naꞌrupu wopul pꞌrek oththa akkethung aꞌrupu wang itti ngkwaꞌrumo nan? ");
INSERT INTO lmd_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Pul pella ipareko parekine nili neꞌra kwonu itti kwꞌra ili wꞌrek akwongat aꞌrek ana manna itti kwoccokot wulukku akworakke aꞌrek. Ittina lomma itti onon thangat Kapik ana ongat thaꞌrthan.” ");
INSERT INTO lmd_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Manakka ul woPriccin woccïkothe lon elli okin thikkathe cik akin okkothok ngure ngngin akka okin thaththongothe akucci. ");
INSERT INTO lmd_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","AIeccuo iꞌrekat kin itti, “Onon thathikkie ka kon thoporot tokït koul anaruk Kapik kina ilaik nomikït mon. Akka lon ila ul okatha itti loporot lella lon cik tokït koKapik.” ");
INSERT INTO lmd_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Lon lothonceꞌret lon cik loMucca lokat cik ana ul wothernte lon loKapik werntet puccuk mono aIuanna pomamuthie akkakat. Nci cïnang alon iloporot longili ngoKapik antikkat cik alongkenetta ana ul woppot waik wennekke itti waeo ingili ngoKapik. ");
INSERT INTO lmd_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Tothiꞌrot ana capu thintat cik aththaman anaruk tamping tella tulukku irintat cik nolon lothonceꞌret lon cik. ");
INSERT INTO lmd_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Okkwi ipathïo pari pung itti akwappipo apꞌrek kwaik paꞌro nul iari ittat. Ana okkwi ipipot pari pothïlat kwaik paꞌro nul iari ittat.” ");
INSERT INTO lmd_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","AIeccuo ikkat cik akwere icci itti, “Pul pꞌrek pokat cik papaꞌrthan ana pakot eret ionu cekerek crïk ana ikkoik nokaꞌran ikopeththere ana akwoꞌrko thuꞌrit thothiot ana okkot kamuthe appinappin. ");
INSERT INTO lmd_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ana pul pꞌrek pokat cik poccot kꞌran itti oLiaccir pokat papiak pellat papꞌrek cik ana ponat ïnyï noka ana ul wokat cik annennekok annekkethok tocürük copul ipapaꞌrthan. ");
INSERT INTO lmd_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ana pokat apoꞌrïkot itti paꞌrko thuꞌrit itha apukkot cik noküpppüꞌrüng kopul ipapaꞌrthan. Ana luk lokat cik alacceccenok ïnyï. ");
INSERT INTO lmd_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Acaꞌri akkakat apul ipa piak iat auꞌrupa wothothïlettat woKapik onekathok tothiꞌrot na Aprein paik apul ipapaꞌrthan iat cakuruk akwocïkkakat. ");
INSERT INTO lmd_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Apul ipapaꞌrthan onthat kït nciki thothïrïn na kwokat cik akwoccokot thiak akwimmakat Aprein ciththan ana oLiaccir iccik kung. ");
INSERT INTO lmd_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Akwakkarat kin itti, ‘Ngappa pin Aprein, ipi thiak thin othïnthin oLiaccir akwothape caun ngꞌri akwonekkenthin nothuꞌre akka mpaik paccokot thiak cannan icꞌrot enci.’ ");
INSERT INTO lmd_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Anaruk Aprein pothïanthok tit itti, ‘Ukul win, antokwarttikot itti akka ngkwokat parthuk io, ngkwonat aꞌrupu wang ioporot appik ana oLiaccir puruk ponat aꞌrupu wulluk iokithak appik anaruk inenni cene kwopirat noka ana ngkwaik paccokot thiak. ");
INSERT INTO lmd_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ana icci inenni oron thonu thupuꞌru thukwit thopettot iaron thannokorronno opilin nti ianïn itti kwarrot cik ntan itti kwainenon ana cakuruk nti ianon pul pella parrot cik ntan itti painenïn.’ ");
INSERT INTO lmd_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Apul ipokat papaꞌrthan appothïat tit itti, ‘Pappa, amma menik mpipittothung itti othïothe oLiaccir tuan topappa. ");
INSERT INTO lmd_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Akka mponu opangkingon ukuluk akwotherenekin othakka itti akin akorronno anthan cakuruk nokaꞌran engki kothoccokot thiak.’ ");
INSERT INTO lmd_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Aprein iꞌrekathok itti, ‘Okin thonu oMucca ana ul wothernte lon loKapik kirrnni akin occïkot kin.’ ");
INSERT INTO lmd_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Apul ipapaꞌrthan iꞌrekat Aprein itti, ‘Aa, pappa, amma puꞌrek purokot nti ithio mono apoinekin okin thaccïkothok akin opaꞌranthet lon iokithak cik.’ ");
INSERT INTO lmd_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Aprein appiꞌrekathok itti, ‘Amma okin thannoccïkot lon loMucca ana ul wothernte lon loKapik okin thannokkwine lon lꞌrek kunu ncik ana antoka manna itti pul pꞌrek purokot nti ithio.’” ");
INSERT INTO lmd_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","AIeccuo iꞌrekat ul iammakothok itti, “Laik ilakorronno ul akkot lon ilokithak akka lon ammakka elli lonu itti lakaik anaruk angkre nopul ipana lon len. ");
INSERT INTO lmd_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Laka loporot naak itti kwaꞌrettane cna icalak akwantorrettat irok irapangka nothokorronno kin akin okkiet opilin nti iakkwion itharran lon ilokithak. ");
INSERT INTO lmd_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ittina noꞌrumo noka kon. Amma opangkang pꞌrek pokkothe lon lokithak aꞌretti naak ana amma kwocottakot ntit accïkïnthok. ");
INSERT INTO lmd_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Antoka manna itti kwokkinthung lon lokithak maꞌri meꞌreꞌrapuruk nocaꞌri culukku, mono akwainung akwomethung itti ‘Mpopaꞌrinet lon cik,’ accïkïnthok lon ilokithak.” ");
INSERT INTO lmd_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Aul wothothïlettat woIeccuo ipittathok itti, “Arttinthet nïn nothoccokot lon lang nomïkït.” ");
INSERT INTO lmd_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","AIeccuo othïanthet kin tit itti, “Amma onon akkonu thoccokot tholon loKapik thotteik ere core icoththe, nthamet pira itti, ‘Uroki ncü athocïkko ka kang irok irapangka,’ ana paccïkot non. ");
INSERT INTO lmd_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Nantome itti opilin ponu pul iparanok ana manna uꞌre lungkat. Amma paat nti ikkwon opït pamethok itti, ‘Aꞌrik aththikkoik aꞌrko thuꞌriri’? ");
INSERT INTO lmd_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Lannoka menik anaruk kwiꞌrethok itti, ‘Okuccenthin thuꞌrit cik aꞌrikothin anoꞌrkoik kappak amma mpoꞌrkot cik antoꞌrkoik.’ ");
INSERT INTO lmd_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Kwapirie pul ipareko noka akka kwokkothe lon iliꞌrettathok itti kwakkori? Kwannopiriek noka. ");
INSERT INTO lmd_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ittina menik onon cakuruk amma onon thokkothe lon ilanon thaththiꞌrettathe itti nthakkot onon nthira thiꞌre cakuruk itti, ‘Onïn ul iareko tulluk onïn thannekko nan itti ïnthapirietta noka.’” ");
INSERT INTO lmd_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Anakka oIeccuo pokat cik akweo nokaꞌran koUruccelim okko nokwen konoththok poCcamira ana noththok poCelïl. ");
INSERT INTO lmd_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ana akka kwokat cik akwiꞌriko icarak coman, kwocurathe iul attul wonat ïnyï noka acoꞌrat ciththan ");
INSERT INTO lmd_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","aikkat akkaro mpoꞌre cittan itti, “OIeccuo pul ipangkene, ipi thiak thïn.” ");
INSERT INTO lmd_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Anakka kwimmat kin akwiꞌrekat itti, “Ngkonon annothokene ul wonoppan toKapik ka kon.” Anakka okin thokat cik akin eo akin othiat ka ken akin thothakkat thoporot. ");
INSERT INTO lmd_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Akka opilin nti iakin paththiot itti kwothakkat poporot, kwokkaprttakathe ntan akwopirakanthet Kapik noka mpoꞌre cittan. ");
INSERT INTO lmd_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Akworrekat ka kung iracok toIeccuo akwopirakanthok noka ana kwokat poul wonoththok poCcamirin. ");
INSERT INTO lmd_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","AIeccuo iꞌrekat itti, “Okin thakorronno othikkietta thoporot attuli? Ana opilingon thꞌrek thaik kren ukulacoꞌrin? ");
INSERT INTO lmd_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Pul pella ipokkaprttakot itti pathopirane Kapik noka ook empi pokwat.” ");
INSERT INTO lmd_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","OIeccuo piꞌrekathok itti, “Uroki aeo akka thoccokot tholon loKapik thang nocïkït thothikkierung poporot.” ");
INSERT INTO lmd_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Aul wꞌrek woPriccin ipittat oIeccuo itti, “Ngili ngoKapik nganthan acintha.” AIeccuo iꞌrekat kin itti, “Ngili ngoKapik ngakorronno anthan nuthuk nci nokkït angimmako. ");
INSERT INTO lmd_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Pul pella ipiꞌre itti, ‘Katha ngei cene’ ana manna itti, ‘Katha ngeꞌre ceneket’ akka ngili ngoKapik ngaik ianon.” ");
INSERT INTO lmd_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Menik akwiꞌrekat ul iammakothok itti, “Caꞌri canthan icanon okwancot cik ngngin itti nthimma caꞌri culukku nocaꞌri cokkul wopul iponyi anaruk onon thakinnimma. ");
INSERT INTO lmd_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ul wꞌrek wakaik iiꞌret non itti, ‘Katha kwei’ ana itti, ‘Katha kweꞌre ceneket,’ anaruk nokorronno omakot kin. ");
INSERT INTO lmd_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Akka ukul wopul iponyi amma anthan nocaꞌri cung caka ere thuleꞌrak ithallio ntothiꞌrot athocciekat cik tothiꞌrot appik nci thocipit puccuk oingkat thocipit ceꞌrek. ");
INSERT INTO lmd_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Anaruk kwonu cittokït itti kwaccokot thiak cannan ana ul iaik inenni wꞌrak. ");
INSERT INTO lmd_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ana ammakka lokat nocaꞌri coNua, lakaik nocaꞌri cokkul wopul iponyi cakuruk. ");
INSERT INTO lmd_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Nocaꞌri cen ul wokat cik aꞌrkoik ana ïkko ngapak ana ittetto puccuk mono acaꞌri akkakat, aNua iꞌrikat ikuppuꞌrung konoiꞌri angike akkakat mono ongwat kin appik ithokat thanniꞌriko ikuppuꞌrung. ");
INSERT INTO lmd_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Lokat cik cakuruk menik nocaꞌri coLot, ul wokat cik aꞌrkoik ana ïkko ngapak ana okette ana okero ana ora ana uno. ");
INSERT INTO lmd_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Anaruk caꞌri ica oLot poththet nokaꞌran koCcothum aKapik orrekat thik ana monyïk molik ntothiꞌrot mono amokꞌrekat kin appik ithokat nokaꞌran koCcothum. ");
INSERT INTO lmd_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Laka menik caꞌri ica ukul wopul iponyi ummot ncik. ");
INSERT INTO lmd_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Nocaꞌri cen pul pella ipaik ci toꞌra woman mung imonu aꞌrupu tit aporpot cik ntan itti pathummo aꞌrupu. Ana menik pul pella ipaik topon piꞌre itti papakkot tuan apothummo aꞌrupu wꞌrek. ");
INSERT INTO lmd_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Nantokwarikot lon lopari poLot. ");
INSERT INTO lmd_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Okkwi ipome itti kwaꞌrumo nothikkoik thung kuret cik ana okkwi ipuret thikkoik thung cik kwangwot. ");
INSERT INTO lmd_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Mpiꞌret non itti, ngkoꞌra ngen ul waka weꞌra naꞌrangkal ulukku apꞌrek panekitta apꞌrek oththetta nan. ");
INSERT INTO lmd_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ana ul iari weꞌra iakakot mïl ithun, pꞌrek panekitta ana apꞌrek oththetta nan.” ");
INSERT INTO lmd_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","“Ul weꞌra iomura iareko ikkwon pꞌrek panekitta ana apꞌrek paththetta nan.” ");
INSERT INTO lmd_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Aul wung imakothok ipittathok itti, “Ili, elli lakaik kartha?” AIeccuo othïanthet kin tit itti, “Na ka ikiot kaik nengki naꞌrntakot nan.” OIeccuo pothïotherit llon elli akwokene itti thao thung thinako nan. ");
INSERT INTO lmd_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ittina aIeccuo iꞌrekat ul iammakothok lon nthokkwie kuru ncik, akwokenekin itti okin nthonu itti okin thaꞌra ngaꞌrama appinappin okorronno ocoꞌro ntit. ");
INSERT INTO lmd_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Akwiꞌrekat kin itti, “Pul pꞌrek pokat cik nokaꞌran kꞌrek, ponu lon lothonceꞌret lon cik ikkun pokat cik apokorronno opellene Kapik ana manna okorronno occot kït noul. ");
INSERT INTO lmd_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ana pul ipopari pꞌrek pokat nokaꞌran ken pacuruma ana pokat apoincene pul pothonceꞌret lon cik apipittittothok itti, ‘Onceꞌrenthet nïn lon cik onïn opul pꞌrek panïn thonu lon lokithak onïn aththut.’ ");
INSERT INTO lmd_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Apul ipanceꞌret lon cik pikkatheik maꞌri moppot apꞌrat okkot lon lꞌrek anaruk kwiꞌrekathe ka kung itti, ‘Antoka manna itti mpannopellene Kapik ana manna ul ionyi. ");
INSERT INTO lmd_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Anaruk akka curuma enci caik caukkinin, mponu itti mpakꞌrinok lon lung akka amma mpannittarothok ana cakkinthin poꞌre ica.’” ");
INSERT INTO lmd_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ana Ili wiꞌrekathe itti, “Nantoccïkot lon ila pul ipannonceꞌret lon cik ipakwïettot akka piꞌret. ");
INSERT INTO lmd_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Kapik kannonceꞌrenthet ul wung ia kwakkarot lon ciki, ioo ngkoꞌra ana icïngkï? Kaꞌrungkot nan opakkukkwet kini? ");
INSERT INTO lmd_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Mpiꞌret non itti kwaccot kït nan itti lon len lonceꞌrettatheik ana cokoccokot, anaruk amma ukul wopul iponyi waat, wathiot ul nocapu awoccokothe lon loKapik nomïkïri?” ");
INSERT INTO lmd_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","OIeccuo papprokkwiekat lon kuru ncik akweret ul iakatha ka ken itti okin thoporot tokït koKapik ana akin okatha ul appik itti wokithak. ");
INSERT INTO lmd_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Ul wꞌrek weot weꞌra itti wathaꞌra ngaꞌrama noppan toKapik, opilin noul woPriccin ana opilin noul iaꞌrntot akucci. ");
INSERT INTO lmd_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Apul poPriccin urokat kapik ana paꞌrakanthet ka kung ngaꞌrama itti, ‘Kapik kin mpopirat noka akka mpannoka ammakka ul wꞌrek, woluꞌran ana iakkot lon ilokithak ana iaꞌro nari woul, ana manna ammakka pul empi ipaꞌrintinthet nili akucci. ");
INSERT INTO lmd_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Mpacoꞌro nothuꞌrit maꞌri meꞌra nomaꞌri imeꞌreꞌrapuruk ana mpillillo iaꞌrupu appik ia Kapik kethin kurekkurek attul attul anethet Kapik nan puluk puluk.’ ");
INSERT INTO lmd_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Anaruk pul ipaꞌrntot akucci pocoꞌrothe ciththan ciththan napilingon. Ana kwipathe nꞌre okatha tothiꞌrot ana kwonekkekathe ukun topere akkwannoka poporot noka akwiꞌrekat itti, ‘Kapik, ipi thiak thin, oun pul polon ilokithak.’” ");
INSERT INTO lmd_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ittina aIeccuo iꞌrekat itti, “Mpiꞌret non itti pul ipaꞌrntot akucci akkeot tuan poporot tokït koKapik, akka okkwi ipathikkie ka kung prïk kwathikkietta potte ana okkwi ipathikkie ka kung potte kwathikkietta prïk.” ");
INSERT INTO lmd_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ul wokat cik cakuruk annane oIeccuo nyukul inyarran othakka itti akwethïenekin. Anakka ul iammakothok wimmat menik okin thothirriekathe ul cik ionat nyukul. ");
INSERT INTO lmd_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Anaruk oIeccuo pakkarathe nyukul inyarran anyainok ana kwiꞌrekathe itti, “Nokorronno nyukul inyarran anyao naun nokorronno oceꞌrekin akka ngili ngoKapik ngoul iammakka okin. ");
INSERT INTO lmd_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Mpiꞌret non lon ilaik ïcat itti, okkwi ipannocco ngili ngoKapik ammakka nyukul inyarran, kwanniꞌrikorit.” ");
INSERT INTO lmd_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Aili wꞌrek woul woIouth ipittat oIeccuo itti, “Pul ipangkene ipoporot, ngintha akka anokkot aniꞌriko ithikkoik thothupuththuput?” ");
INSERT INTO lmd_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","AIeccuo othïanthok tit itti, “Ngkwakkakkaron itti pul ipoporot akaintha? Pul pella poporot Kapik kulluk akkoporot. ");
INSERT INTO lmd_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ngkwina lon ilattuli ilonthomat ila Kapik kethet oMuccai iliꞌre itti, ‘Kirrnni aꞌro nul iari ittat, kirrnni okkwot pul, kirrnni omunye, kirrnni ere lon ngkarra, othianet oththe ana onne cik.’” ");
INSERT INTO lmd_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Aili iꞌrekat itti, “Mpokkothe lon ellrïk appik amparthuk potteik.” ");
INSERT INTO lmd_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Manakka oIeccuo poccïkothe ila kwiꞌret akwiꞌrekathok itti, “Lon laik lulukku langkwarthuk okkot, okette aꞌrupu appik ethet ul iella alpꞌrek cik akucci ana ngkwaka paꞌrthan tothiꞌrot ittina aina akka amakothin.” ");
INSERT INTO lmd_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Manakka kwoccïkothe elli kuakathe ka cannan akka kwokat paꞌrthan prïk. ");
INSERT INTO lmd_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","AIeccuo okathakathok akwiꞌrekat itti, “Lommaththik itti pul ipapaꞌrthan piꞌriko ingili ngoKapik. ");
INSERT INTO lmd_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Anaruk lippappat itti thamla thakko icürük coipre nopul ipapaꞌrthan itti piꞌriko ingili ngoKapik.” ");
INSERT INTO lmd_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Okkwion ithoccïkothe lon len ipittat oIeccuo itti, “Amma ittina oththa akkaꞌrettat?” ");
INSERT INTO lmd_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","AIeccuo othïat tit itti, “Lon ilonthomat nopul iponyi lakannoka lonthomat noKapik.” ");
INSERT INTO lmd_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","APoththuruc iꞌrekat oIeccuo itti, “Onïn thoththet naꞌrupu appik ïnomakothung.” ");
INSERT INTO lmd_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","AIeccuo iꞌrekat kin itti, “Mpiꞌret non lon ilaik ïcat, okkwi ipoththet nokaman kung ana nopari pung ana napangon ana naththan ana onnan ana nyukul nyung nti ilon longili ngoKapik ");
INSERT INTO lmd_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","kwacco lon loppot iloporot nothikkoik thung cene inenni ana kwacco thikkoik thothupuththuput noluput ilanthan.” ");
INSERT INTO lmd_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","AIeccuo onekat ul wothothïlettat wung iattul ana ikken keꞌra thocipit akwiꞌrekat kin itti, “Noccïkot, oron thaik thakuꞌrot nokaꞌran koUruccelim ana lon appik ila ul wothernte lon loKapik ilerethe ukul wopul iponyi laik lathothakka ïcat. ");
INSERT INTO lmd_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Kwaik pathettat ul iakonnoka woIouth okin thaccirok ngngin ana ocungkok ana othukkothok nguk ana okkwekok ana okkwothok ");
INSERT INTO lmd_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ana nomaꞌri mꞌrapuruk kuroko nti ithio.” ");
INSERT INTO lmd_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Aul woIeccuo iammakothok okinninakat lon len ila oIeccuo paik peret akka lon len lokat lamuꞌruttakothekin. ");
INSERT INTO lmd_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Annakka oIeccuo pokat cik akweo nokaꞌran kAria, apul pꞌrek pokat cik piꞌrimathe apikkoik nokuthut kokathar apipittot ul aꞌrupu. ");
INSERT INTO lmd_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Manakka pul pen poccïkothe aul okkot poꞌre aeo apul pen ipittat itti, “Ngintha akkaik.” ");
INSERT INTO lmd_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Akin iꞌrekathok itti oIeccuo poNaccir paik paeo. ");
INSERT INTO lmd_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Akwikkat cik akwakkakkaro oIeccuo itti, “Ukul woThauth, ipi thiak thin.” ");
INSERT INTO lmd_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Aul iokat cik tokït othirriekathok cik aiꞌrekathok itti, “Angkik,” anaruk kwikkatheik akwokkot poꞌre cannan itti, “Ukul woThauth, ipi thiak thin.” ");
INSERT INTO lmd_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","OIeccuo pocoꞌrathe akwiꞌrekat kin lon lonthomat itti, “Nonakok cene.” Anakka kwaat iccik koIeccuo aIeccuo iꞌrekat pul pen itti, ");
INSERT INTO lmd_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ngkwongothe itti mpakkinthung ngintha?” Akwothïat tit itti, “Ili, mpongothe itti mpimmaik.” ");
INSERT INTO lmd_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","AIeccuo iꞌrekathok itti, “Thoccokot lon loKapik nocïkït cang thimmierung cik.” ");
INSERT INTO lmd_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ncïnang akwimmakat cik ana kwomakathe oIeccuo akwopirakanthet Kapik noka. Anakka ul appik wimmat akin ikkat cik akin opirane Kapik noka. ");
INSERT INTO lmd_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","OIeccuo piꞌrikathe nokaꞌran kAria ana kwokat cik akwokko ikathar cinang. ");
INSERT INTO lmd_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Apul pꞌrek pokat cik ipa ili woul iaꞌrntot akucci poccot kꞌran itti oCcakka papaꞌrthan. ");
INSERT INTO lmd_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Kwokat cik pongothe itti kwimma itti oIeccuo okkwen anaruk kwokat cik puththut puththut akkwannimmakat cik akka ul wokat cik woppot. ");
INSERT INTO lmd_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ittina akwollat tokït koIeccuo kwarrat topira popïcït itti akwina akka akwimma oIeccuo akka kwokat cik pathokko ikathar ken. ");
INSERT INTO lmd_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Manakka oIeccuo paat nokaꞌran ken akwocoꞌrat akwokathakat tothiꞌrot akwiꞌrekat oCcakka itti, “Aꞌrik uintan cokoccokot mpaik paeo tuan thanang inenni.” ");
INSERT INTO lmd_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ittina akworpat accokot ana kwikkiekathe oIeccuo cik tuan nthopira noka cannan. ");
INSERT INTO lmd_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Aul appik immakat lon len ana wikkatheik aꞌrettakot itti oIeccuo peot tuan topul polon ilokithak akin othikkoik okin aththut. ");
INSERT INTO lmd_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Anaruk oCcakka pocoꞌrathe kapik ana kwiꞌrekathe Ili itti, “Ili, occïkothin caꞌri enci inenni mpaik pillo iaꞌrupu win appꞌrut anikket ul iella aꞌrupu cik, ana amma mpokwïethe opilin ana mpakkekok maꞌri mocoꞌrin arttot nan.” ");
INSERT INTO lmd_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","AIeccuo iꞌrekat itti, “Inenni thoꞌret thaat tuan topul empi akka ook cakuruk ukul wAprein. ");
INSERT INTO lmd_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Akka ukul wopul iponyi waat itti wathokwantot ana oꞌret ul iuratheik.” ");
INSERT INTO lmd_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Anakka okin thokat cik akin occïkot lon elli, kwappiꞌrekat kin lon okkwie kuru ncik akka kwokat cik akwokko napuththut iccik konokaꞌran koUruccelim ana ul wikkatheik aiꞌre itti ngili ngoKapik ngaik nganthan inenni. ");
INSERT INTO lmd_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Kwiꞌrekathe itti, “Pul pꞌrek prïk pokat cik peot nocoꞌrong ciththan othakka itti akwothothikkiettatta ili irïk akwantokkaprttako ntan tuan. ");
INSERT INTO lmd_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ana kwakkarathe ul attul iarekinok akwikkekat kin akucci ana kwiꞌrekathe kin itti, ‘Nocco akucci enni annorekie ananthan.’ ");
INSERT INTO lmd_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Anaruk ul wung wokat wꞌrarok ana wothïathe ul nocoꞌrong na kwaththothakka ili athiꞌre itti, ‘Onïn thannangkot itti pul empi pathakka ili wïn.’ ");
INSERT INTO lmd_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Anaruk kwothakkakathe ili ana kwokkaprttakathe ntan tuan ana kwothïanthet ul ia kwappethet akucci itti warekie, akwokatha itti ngimpen akka okin thokkothe ngngin. ");
INSERT INTO lmd_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Apul porokït akkakat apiꞌrekat itti, ‘Pït pin, akucci wang ia ngkwethin warttakothe nan attul.’ ");
INSERT INTO lmd_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Apït pung iꞌrekat itti, ‘Ngkwokkothe lon loporot, pul iparekinin ipoporot. Ana inakka ngkwoꞌrumot nongere engngi ngoththeik papenang ia ngkwoccot, ittina mpanekkethung ili waꞌran attul.’ ");
INSERT INTO lmd_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Apilin akkakat akwiꞌrekat itti, ‘Pït pin, akucci wung warttakothe nan ukuluk.’ ");
INSERT INTO lmd_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Aili iꞌrekathok itti, ‘Ngkwacco aꞌran ukuluk akatha lon len.’ ");
INSERT INTO lmd_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Apilin pꞌrek akkakat akwiꞌrekat itti, ‘Pït pin, akucci wang wei ia ngkwethin mpïꞌrïkothe ikret. ");
INSERT INTO lmd_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Mpokat ponu nꞌre nang akka ngkwommaththik pella thiak nocïkït ngkwonnekot ul aꞌrupu iakannoka wang ana okio aꞌrupu ia ngkwannee.’ ");
INSERT INTO lmd_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Apït othïat tit itti, ‘Mpakkmang nti ilon lang, oung pul ipareko ipokithak. Ngkwina kicce itti mpommaththik pella thiak ana mpaaneko aꞌrupu iannoka win, ana mpakio aꞌrupu ia mpannee? ");
INSERT INTO lmd_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ngintha akka ngkwannorekiene akucci win othakka itti amma mpaat anoneko mpangken iparttakothe nan?’ ");
INSERT INTO lmd_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ittina akwiꞌrekat okkwion ithokat cik akin acoꞌro cïnang itti, ‘Nonekothok akucci annethet pul iponu akucci attul.’ ");
INSERT INTO lmd_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Akin iꞌrekat itti, ‘Pït pïn, pul empeꞌre ponu attul.’ ");
INSERT INTO lmd_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Akwopakkekanthet kin tit itti, ‘Mpiꞌret non itti, Okkwi iponu woppot kwettat arttot nan anaruk okkwi ipellaik kwanekittat manna ia konu appik. ");
INSERT INTO lmd_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Anaruk okin ithathoꞌrak thin ithannangkot itti mpaka ili wen, nona kin annongwot kin tokït kin cene.’” ");
INSERT INTO lmd_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Anakka oIeccuo piꞌret lon elli, akwoingkat okuꞌrot nokaꞌran koUruccelim. ");
INSERT INTO lmd_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Manakka akwokko ciki iccik konokaꞌran koPeththppaci ana Peththania nocoꞌrong coCeththun, kwothïathe ul weꞌra nti iul iammakothok akwiꞌrekat kin itti, ");
INSERT INTO lmd_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Ngkonon nokaꞌran tokït kon ana amma anniꞌriko tit onon thathiot ngeꞌringka iotte ngïꞌrïkakot ia pul pella parrothe tan. Nokꞌro annonanin. ");
INSERT INTO lmd_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Amma pul pꞌrek pipittothe non itti, ‘Onon thaik thakꞌro ngeꞌringka akaintha?’ anniꞌrethok itti, ‘Ili akkiꞌret itti onïn thathokꞌro.’” ");
INSERT INTO lmd_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Okin ithokat thothïlathe thoingkathe ana okin thaththiat ammakka oIeccuo piꞌrethekin. ");
INSERT INTO lmd_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Anakka okin thokat cik akin okꞌro ngeꞌringka aul ionu ngeꞌringka ipittat kin itti, “Nthontha akka anokꞌro ngeꞌringka?” ");
INSERT INTO lmd_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Akin othïat tit itti, “Ili akkiꞌret itti onïn thakꞌro.” ");
INSERT INTO lmd_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Okin thonakanthet oIeccuo ngeꞌringka iotte akin ipanthok eret cik tan akin arriekathok tan. ");
INSERT INTO lmd_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Akka akweo, aul ikkat cik aipinthok eret cik ikathar akwonyaro nan. ");
INSERT INTO lmd_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Anakka kwaat iccik kokaꞌran na kathar kokkot uo thaiken nocoꞌrong coCeththun, ul iammakothok appik wikkatheik apirane Kapik noka nolon mpoꞌre cittan appik ilommaththik ilakin thimmat aiꞌre itti, ");
INSERT INTO lmd_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Athethïetta oka noili iaik wanthan ngkꞌran koIli.” “Athomicco oka tothiꞌrot ana thrïk oine Kapik tothiꞌrot.” ");
INSERT INTO lmd_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Aul wꞌrek woPriccin iꞌrekat oIeccuo itti, “Pul ipangkene, othirriethe ul cik iammakothung wang akin angkoik.” ");
INSERT INTO lmd_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","AIeccuo iꞌrekat itti, “Mpiꞌret non amma okin akkangkot cik ana mothok moo.” ");
INSERT INTO lmd_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Manakka akwokko iccik konokaꞌran koUruccelim akwimmakat kaꞌran akwikkat cik akwoot pothok ");
INSERT INTO lmd_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ana kwiꞌrekathe itti, “Lokithak cannan inenni itti ul wang womma itti ngimpen akkananekin thomicco. Anaruk inenni lamuꞌruttakot nokït kon. ");
INSERT INTO lmd_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Maꞌri mainenon amma thoꞌrak thang okkwot karrang naung ana nopothok poUruccelim ana ullukkinthet non cik naꞌran appik ana okkwet non ithoꞌrkït. ");
INSERT INTO lmd_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Okin thoꞌrumathung akin okakꞌrathung cik nocapu, oung ana nyukul inyanon thaik. Ana okin thannokwento pothok pulukku topangken akka onon thomma caꞌri coKapik ica akainenon nan.” ");
INSERT INTO lmd_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ittina oIeccuo piꞌrikathe noppan toKapik ana kwikkatheik akwokïccet ul thapat iokat cik akettet aꞌrupu. ");
INSERT INTO lmd_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Akwiꞌrekat ul itti, “Lokurrakot itti, ‘Man min maꞌrama’ ana onon thothikkiet moul wothuꞌran.” ");
INSERT INTO lmd_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ana oIeccuo pikkatheik akwongkene noppan toKapik. Ana ul ittïttïk woul wonoppan toKapik ana ul iangkene lon lothonceꞌret lon cik ana ul wꞌrek ittïttïk wikkatheik akwariccat kathar ika kin okkwothok ngngin ");
INSERT INTO lmd_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","anaruk okin thakinniat kathar ikakin okkot lon len ngngin akka ul waik woppot accïkot lon ila oIeccuo pokat cik akwere. ");
INSERT INTO lmd_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Nocaꞌri cꞌrek caIeccuo pokat cik akwongkene ul noppan toKapik ana akwerene kin lon iloporot loKapik, ul ittïttïk woul wonoppan toKapik ana ul iangkene lon lothonceꞌret lon cik nul ittïttïk akkakat naak ");
INSERT INTO lmd_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","aiꞌrekathok itti, “Iꞌrethenïn ngkwaik pangkene ngngili ngiatha ana oththa akkethung ngili ngen?” ");
INSERT INTO lmd_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","AIeccuo omekat kin itti, “Mponu thipitto anipittot non. Niꞌrethin, ");
INSERT INTO lmd_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","mamuthie moIuanna mokat ntothiꞌrori ana amma okorronno oka ntothiꞌrot ana mokat nopul iponyi?” ");
INSERT INTO lmd_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Akin ikkat cik akin erettarne thellek akin iꞌre itti, “Amma oron thiꞌret itti, ‘Ntothiꞌrot’ ana kwiꞌretton itti, ‘Onon thontha akka onon thannoccokot lon lung nomïkït?’ ");
INSERT INTO lmd_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ana amma oron thiꞌret itti, ‘Nopul iponyi’ ana ul appik wakinco oron mothok akka okin thoccokothe lon itti oIuanna pokat pul wothernte lon loKapik.” ");
INSERT INTO lmd_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ittina akin othïanthok itti, “Onïn thomma itti maat ngkeren.” ");
INSERT INTO lmd_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","AIeccuo iꞌrekat kin itti, “Mpakinniꞌret non itti ngngili ngiatha inga mpaik pakkot llon elli cakuruk.” ");
INSERT INTO lmd_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Akwikkat cik akwerene ul okkwie lon kuru ncik akwiꞌre itti, “Pul pꞌrek peet maa apekat ul wꞌrek ara, amma okin thokiot akin ethok motte nan akwoingkat nokurtti imakkren akwoccat cik. ");
INSERT INTO lmd_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Anakka caꞌri caat cothokio apothïat pul pung iparekinok itti akin ethok aꞌrupu iakin thethok. Anaruk okin thokkwekathe pul iparekinok mono othïat ikathar nyaun ncürük. ");
INSERT INTO lmd_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Akwothïat pul ipareko pꞌrek anaruk okin thokkwekathe ana okkiet thiak akin othïat nyaun ncürük. Akwappothïat apꞌrek akin ipiekathok ka kongo akin othïathok nyaun ncürük. ");
INSERT INTO lmd_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ana icci akwappothïat apꞌrek ana okin thokkwekathe ana okin thorrekathe thapat nti ikkwon. ");
INSERT INTO lmd_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ittina apul iponu kopon iꞌrekat itti, ‘Ngintha akka anokkot? Mpathïot ukul win ia mpongothe amma manna okin othiane cik.’ ");
INSERT INTO lmd_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Anaruk akka okin thimmat ukul akin ikkat cik akin erethok. Akin iꞌre itti, ‘Ook empi ipapakkot naꞌrupu, ntrun okkwot athaꞌrthan thung oka thonnon.’ ");
INSERT INTO lmd_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ittina akin orrekathok thapat nti itharak akin okkwathok. Pul iponu kopon pakkot kin ngintha? ");
INSERT INTO lmd_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Kwanthan ana kwathongwo ul iara kopon kokira komaa akwekat ul wꞌrek kopon ken.” Anakka ul woccïkothe elli, akin iꞌrekat itti, “Alon elli okorronno oka aththik.” ");
INSERT INTO lmd_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","AIeccuo okathakat kin akwipittat kin lon itti, “Lon ilokurrakot itti, ‘Pothok ipa ul iuno wꞌrat ipen akkathakkat cillang.’ Lonu itti ngintha? ");
INSERT INTO lmd_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Okkwi ipapothe nopothok pen kwacotta kicce, anaruk okkwi ipa pothok papothe nan kwakakꞌrakot cik.” ");
INSERT INTO lmd_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ul iangkene lon lothonceꞌret lon cik ana ul ittïttïk woul wonoppan toKapik wokat wongothe itti waccokothok akka okin thinat itti thokkwie lon kuru ncik enthi thokat cik atheret kin. Anaruk okin thonat nꞌre noul. ");
INSERT INTO lmd_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Anakka okin thokat cik akin occot kït naak, okin thothïathe ul iattet lon ainok akin innikot itti okin ul ioporot othakka itti akin iꞌrak llon ila akwiꞌre othakka itti akin occokiethok nili nonoththok. ");
INSERT INTO lmd_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ittina aul iattet lon ipittathok itti, “Pul ipangkene, onïn thina itti oung pul ipiꞌre lon ilaik ïcat ana ongkene lon ilocoꞌrotheik ana ngkwakannokkwine ul kunu ncik anaruk ngkwangkene lon loKapik ammakka kongothe. ");
INSERT INTO lmd_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Locoꞌrotheik itti onïn thaꞌrntinthet oKkaiccer akucci ana amma okorronno oka menik locoꞌrotheiki?” ");
INSERT INTO lmd_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Anaruk oIeccuo pinakathe lon len ana kwiꞌrekathekin itti, ");
INSERT INTO lmd_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Nantokenen thinar. Purrut poththa empi ana kꞌran engki nokakucci?” ");
INSERT INTO lmd_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Akin othïanthok tit itti, “PoKkaiccer.” Ittina aIeccuo iꞌrekat kin itti, “Nethet oKkaiccer aꞌrupu woKkaiccer ana woKapik annethet Kapik.” ");
INSERT INTO lmd_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Okin thommakathe occokothok tokït koul nolon ila kwiꞌret, ittina okin thangkatheik ana oprttakot tit nolon ila kwothïotherit ngngin. ");
INSERT INTO lmd_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Aul wꞌrek woCcathukkin iokat ame itti pul pakannuroko nti ithio akkakanthet oIeccuo akin athipittothok lon len. ");
INSERT INTO lmd_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Akin ipittathok itti, “Pul ipangkene, oMucca pokurrinet nïn itti amma pul ipocura piot nopari appella nyukul ana lonu itti opang papakkot nopari pen akwokwonine opang nyukul. ");
INSERT INTO lmd_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ana inenni ul wꞌrek wokat cik weꞌreꞌrapuruk woththan pulukku, opaththi ponothon piathe nnopari appellat nyukul cik. ");
INSERT INTO lmd_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Apang pꞌrek opakkat nopari apappiat cakuruk akwella nyukul cik. ");
INSERT INTO lmd_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Apang pꞌrek appopakkat nan menik akwiat cakuruk alon len okakat nakin ithokat theꞌreꞌrapuruk. Okin thillekathe appik akin thella nyukul. ");
INSERT INTO lmd_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ana pꞌrin apul ipopari iat cakuruk. ");
INSERT INTO lmd_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ana amma caꞌri caat ica ul uroko nti ithio, pari paka poththa? Akka ul wopakkothe nan weꞌreꞌrapuruk.” ");
INSERT INTO lmd_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","AIeccuo othïat tit itti, “Thittetto thoul iaik nocapu cene. ");
INSERT INTO lmd_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Anaruk ul iekkot nan itti wuroko nti ithio ana ikkoik thupuththuput wonu itti wannitta ana ipo ari. ");
INSERT INTO lmd_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Akka okin thikkoik ere uꞌrupa wothothïlettat woKapik ana okin thannille ana okin nyukul nyoKapik akka okin thuroko nti ithio. ");
INSERT INTO lmd_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ana nolon lopira ipokat cik apokꞌro, lon lung oMucca ngka kung piꞌret itti ul illet wuroko nti ithio attang akka kwakkarot Ili itti, ‘Kapik kAprein ana Kapik koIccaak ana Kapik koIakup.’ ");
INSERT INTO lmd_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Lon elli lonu lon itti Kapik kothikkoik kakannoka kothio akka okin appik thaik thikkoik iaak.” ");
INSERT INTO lmd_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Aul wꞌrek iangkene lon lothoceꞌret lon cik othïat tit itti, “Pul ipangkene, ngkwiꞌret lon papenang.” ");
INSERT INTO lmd_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Apul ellakat ipappipittothok lon lꞌrek. ");
INSERT INTO lmd_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ittina aIeccuo iꞌrekat kin itti, “Ana tat akka akin iꞌrene itti oMiccie ukul woThauth? ");
INSERT INTO lmd_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","OThauth ngka kung piꞌret iatham woMocumur itti, ‘Ili Kapik wiꞌrethe Ili win itti, Ikkik thokkun wothothari win. ");
INSERT INTO lmd_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Puccuk analkanthung thoꞌrak thang anocukkarat kin cik.’ ");
INSERT INTO lmd_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","OThauth pakkarot oMiccie itti, ‘Ili win’ ana tat akka akwoka ukul wung?” ");
INSERT INTO lmd_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Anakka ul appik wokat cik accïkot lon, aIeccuo iꞌrekat ul iammakothok tokït koul itti, ");
INSERT INTO lmd_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Noꞌrumoik noul iangkene lon lothonceꞌret lon cik. Okin thongothe itti okin thanyaro neret iukwirukwit ana omiccako keccuk ana ikkoik naꞌran iathiakine cik nomuththun maꞌrama ana nokamuthe. ");
INSERT INTO lmd_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Okin thiꞌrikikko ikaman komuruma akin onneko aꞌrupu wen appik, ana aꞌra ngaꞌrama ngukwit. Ul ammakka enni wakkmako thakkmako thokithak cannan.” ");
INSERT INTO lmd_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","AIeccuo pokat cik akwikkoik akwokathacce ul iannekket akucci nokaꞌran kothaꞌrntot akucci iaꞌrntakinthet ngre ngonoppan toKapik, ul iaꞌrthan woppot wonekkekathe akucci woppot. ");
INSERT INTO lmd_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Kwimmakathe pul pꞌrek ipopari ipokat curuma apponekkethe akucci weꞌra wokït. ");
INSERT INTO lmd_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","AIeccuo iꞌrekat itti, “Mpiꞌret non lon ilaik ïcat, curuma enci icopari akkonekkethe akucci woppot noul enni appik. ");
INSERT INTO lmd_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ul enni appik wonekkethe aꞌrupu nnaꞌrupu iakin thonu woppot anaruk curuma enci icopari conekkethe nnaꞌrupu ia kwonat appik itti kwikkoik ngngin.” ");
INSERT INTO lmd_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ul iammakothok wꞌrek wikkatheik aeret thire thomothok imuntat ntupan toKapik ana thire then ithokkattathe nnaꞌrupu iettathe Kapik. Anaruk oIeccuo piꞌrekathekin itti, ");
INSERT INTO lmd_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Mothok emmi appik imanon okathacce, caꞌri cꞌrek canthan canon okinnimma pothok pulukku pokwentakot topangken, müntat nocapu mulumuluk appik.” ");
INSERT INTO lmd_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Akin ipittathok itti, “Lon len lakaik acintha? Ana lon liatha ilakene itti lon elli lathokaik?” ");
INSERT INTO lmd_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Akwothïanthet kin tit itti, “Noꞌrumoik annokorronno occïkïnthet ul wꞌrek itti wammikkot non aththik, akka ul woppot wanthan ngkꞌran kin akin iꞌre itti, ‘Oun oMiccie,’ ana ‘Nocaꞌri cen akkwaik akwokko apuththuththut,’ anaruk annokorronno occïkot kin. ");
INSERT INTO lmd_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ana amma onon thoccïkothe lon lothoꞌrak ana aul othattarorit, nokorronno ipo nꞌre. Lon elli lonu itti lakaik cittokït, anaruk thocothakot thakorronno oka itti thakko napuththut.” ");
INSERT INTO lmd_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ittina kwiꞌrekathekin itti, “Ul wonomoꞌrong wathattarorit, ana ngili ngothattarorit. ");
INSERT INTO lmd_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Capu caꞌrïntïttako ncik ana tï takaik ana mio makaik naꞌran appik ammakka waik ana aꞌrupu wꞌrek ipietto nꞌre ana lon lothoꞌrarot cik ana lon ilakene lon lanthan ntothiꞌrot. ");
INSERT INTO lmd_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Anaruk alon elli larthuk othakka appik, okin thikko thacciccokot non ana okkiet non thiak. Okin thanekot non nomuththun maꞌrama ana ikorrkkor, ana onon thanekittat tokït konili ana elli appik nti ilon lin. ");
INSERT INTO lmd_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Elli lakkattat othakka itti anon okanekin lon ilakin imma ngkït. ");
INSERT INTO lmd_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Anaruk nokorronno ipo nꞌre itti nthathiꞌre tat amma annothïnthet kin ilon. ");
INSERT INTO lmd_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Akka mpethet non lon ana thinaik nti ima othakka itti amma annerene ul iꞌrat non akin occïkot lon lon. ");
INSERT INTO lmd_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ana oththen ana opangkangon ana ul wokuꞌri kon ana opuruko pangon thakettenon ana opilingon thangutta. ");
INSERT INTO lmd_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ul appik wꞌranon nti ilon lin. ");
INSERT INTO lmd_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Anaruk kwan kella ikapot cik nocapu nnoca. ");
INSERT INTO lmd_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ngonoccokot mïkït tangattang, ana onon thaꞌret ka kon.” ");
INSERT INTO lmd_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Amma onon thimmat ul irro wokkwethe kaꞌran koUruccelim ithoꞌrkït onon thina itti thokïttakoik then thakko napuththut. ");
INSERT INTO lmd_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ittina ul iaik noththok poIouthia akin ollo okuꞌrot tomoꞌrong ana ul iaik icarak coman akin oppot thapat ana okkwion ithaik thapat nti icarak coman akin oꞌrungkot. ");
INSERT INTO lmd_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Akka caꞌri enci cothakkma othakka itti alon othakka appik ilokurrakot itti lathoka. ");
INSERT INTO lmd_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Laka lokitheththak noul iari ioppeppethe ana ul iakie nomaꞌri men. Ul wareko thiak cannan noththok akka Kapik kua ka koul. ");
INSERT INTO lmd_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Opilingon thanguttat ithoꞌrak ana opilingon niꞌrittang iukwit wukwit ana opilingon onekittat ikorrkkor nomoꞌrong appik. Kaꞌran koUruccelim kakakꞌrakot cik nul iakonnoka woIouth puccuk amaꞌri moul iakannoka woIouth omttakat.” ");
INSERT INTO lmd_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Lon ilakene lon lakaik lakkattanthet cïngkï ana kwanok ana mothot. Ana nocapu nomoꞌrong appik ul wannoka woporot ana opellene okin thoccïkothe poꞌre ponok inapangka inïttïnïttïk. ");
INSERT INTO lmd_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ul appik wipo nꞌre nen cannan nolon ilaik lanthan nocapu ncik appik akka tothiꞌrot taik taꞌrïntïttako ncik appik. ");
INSERT INTO lmd_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Nocaꞌri cen ukul wopul iponyi wimmakot inuththe anthan mpuꞌran ana nthrïk. ");
INSERT INTO lmd_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ana amma lon ellrïk uroko ncik, nonthot ma kapik ana okwiccekot cik akka thoꞌrettat thon therik thakko napuththut.” ");
INSERT INTO lmd_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Kwiꞌrekathekin lon elli nthokkwie kuru ncik itti, “Nantokatha pira popïcït ana kira kꞌrek appik. ");
INSERT INTO lmd_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Amma onon thimmat natha nen aniat, onon thina itti karran kakko napuththut. ");
INSERT INTO lmd_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ngkathar engki amma onon imma lon elli alokkattat anon ina nan itti ngili ngoKapik ngakko napuththut. ");
INSERT INTO lmd_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Mpiꞌret non lon ilaik ïcat itti, lon elli appik lathakka aul wonomaꞌri emmi wannille. ");
INSERT INTO lmd_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Tothiꞌrot ana capu thintat cik anaruk lon lin lakorronno intat cik aththik.” ");
INSERT INTO lmd_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Noꞌrumoik akka anon okorronno iꞌrikikke kakon ilon lonocapu ammakka itti thïkko ngapak ana thirro mïkït nti ikarak nolon lothikkoik akka caꞌri canthan anon thomma nan. ");
INSERT INTO lmd_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Akka caine ul appik iaik nocapu. ");
INSERT INTO lmd_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Noꞌrumoik, naꞌra ngaꞌrama othakka itti anon olukkot thoꞌrarot cik tholon ilaik lanthan ana annina akka annocoꞌro tokït kokkul wopul iponyi.” ");
INSERT INTO lmd_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","OIeccuo pokat cik akwongkene noppan toKapik appinappin ana cipin akwokuꞌrot nocoꞌrong coCeththun ");
INSERT INTO lmd_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","ana ul waukkathe ngngꞌrïmak athoccïkot thongkene thung noppan toKapik. ");
INSERT INTO lmd_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Akka caꞌri caat cokamuthe karrakith iella müꞌrükül tit ikoccot kꞌran itti Kamuthe koThaurrot kaman kꞌrek cik kokat akokko napuththut, ");
INSERT INTO lmd_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ul ittïttïk woul wonoppan toKapik ana ul iangkene lon lothonceꞌret lon cik wikkatheik akwariccat kathar ikakin okkwot oIeccuo ngngin. Anaruk okin thokat akin opellene ul. ");
INSERT INTO lmd_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ittina pul pothopulut piꞌrikathe iaIoutha ipoccot kꞌran itti Icikkariuththi opilin nti iul wung wothothïlettat iattul ana ikken keꞌra. ");
INSERT INTO lmd_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ana oIoutha poingkanthet ul ittïttïk woul wonoppan toKapik ana okin ithangwot tupan taꞌrama ana okin therekathe itti tat akka akwokerot kin oIeccuo. ");
INSERT INTO lmd_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Okin thopirakathe noka ana okin thongakathe itti okin thethok akucci. ");
INSERT INTO lmd_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","AIoutha angkat ana kwikkatheik akwokwncot caꞌri ica akwoccokiet oIeccuo nili ngngin aul ella woppot. ");
INSERT INTO lmd_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ittina acaꞌri akkakat cokamuthe karrakith iella müꞌrükül tit ana thokkwinthet Kapik thungkat thokamuthe koThaurrot kaman kꞌrek cik. ");
INSERT INTO lmd_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","OIeccuo pothïathe oPoththuruc ana oIuanna akwiꞌrekat kin itti, “Ngkonon annothokkot cik na aron othoꞌrkot thuꞌrit thokamuthe koThaurrot kaman kꞌrek cik.” ");
INSERT INTO lmd_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Akin ipittathok itti, “Ngkwongothe itti onïn thathokkot cik kartha?” ");
INSERT INTO lmd_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","AIeccuo othïanthet kin itti, “Ngkonon nokaꞌran koUruccelim ana onon thacurot ipul ipocura aponneko ngꞌri ngkummuk annomakothok iman na akwiꞌriko. ");
INSERT INTO lmd_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Anniꞌret pul pen itti, ‘Pul ipangkene piꞌret itti, Man maik kartha ima anathoꞌrkot thuꞌrit thokamuthe koThaurrot kaman kꞌrek cik tit onïn oul iammakothin?’ ");
INSERT INTO lmd_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ana kwakenenon man maik toꞌra mïttïk mokuccettathe cik kicce, annokkot cik naron athoꞌrkot thuꞌrit thokamuthe kothaurrot kaman kꞌrek cik.” ");
INSERT INTO lmd_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Okin thoingkathe akin othïat lon ammakka oIeccuo papperenet kin ana okin thokkathe cik papenang ana okin thokkathe thuꞌrit thokamuthe koThaurrot kaman kꞌrek cik. ");
INSERT INTO lmd_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Anakka cik caat cothoꞌrko thuꞌrit aIeccuo ana ul wung wothothïlettat ikkat cik othïngkarakot iriki wonyaun nyothokure ammrththakot kokuppuꞌrung kothuꞌrit. ");
INSERT INTO lmd_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ana oIeccuo piꞌrekathekin itti, “Mpongothe itti mpaꞌrko thuꞌrit enthi thokamuthe koThaurrot kaman kꞌrek cik unaththungon amparthuk occokot thiak. ");
INSERT INTO lmd_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Akka mpiꞌret non itti mpakannappoꞌrko thuꞌrit unaththungon attang puccuk angili ngoKapik akkakat.” ");
INSERT INTO lmd_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ittina aIeccuo onekat keththeꞌret akwopiriekat Kapik noka, akwiꞌrekat kin itti, “Noneko annïkko ikkettot appik. ");
INSERT INTO lmd_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Akka mpiꞌret non itti mpakannappïkko ngapak engki attang nciki inenni puccuk angili ngoKapik akkakat.” ");
INSERT INTO lmd_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ana kwonekathe arrakith akwopiriekat Kapik noka akwomithat tit akwekat kin akwiꞌrekat kin itti, “Ka kin engki ikettathenon nokkot menik annokwarttikothin.” ");
INSERT INTO lmd_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Anakka okin thoꞌrkot cik akwonekat keththeꞌret akwiꞌrekat itti, “Keththeꞌret engki kothonekket lon cik ilie ila Kapik kokkothe ngüccük ngin inguntanthet non cik. ");
INSERT INTO lmd_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Anaruk okkwi ipaik pathokerothin ul onïn thaik thaꞌrko thuꞌrit ïnaththeꞌra nokuppuꞌrung kulukku. ");
INSERT INTO lmd_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ukul wopul iponyi wio ammakka Kapik konekkenthok cik anaruk angkre nopul ipakerok.” ");
INSERT INTO lmd_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Okin thikkatheik akin ipittarot itti oththa akkikko pakkot lon elli. ");
INSERT INTO lmd_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Akin ikkat cik akin aꞌretto cakuruk itti, “Oththa akkaka prïk nti iaron?” ");
INSERT INTO lmd_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","AIeccuo iꞌrekat kin itti, “Nili noul iakonnoka woIouth narekie ul thiak thiak anaruk ul warthuk wakkarokin itti ul ioporot. ");
INSERT INTO lmd_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Anaruk nokorronno oka menik, pul iprïk ntianon apoka ere ukul iotteik ana okkwi iponu lon lonoththok ikkun paka ere pul iparekine ul. ");
INSERT INTO lmd_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Oththa akrïk, okkwi ipikkoik nokuppuꞌrung aul iareko orekinok ana amma okorronno oka menik okkwi iparekine ul akrïki? Onon thiꞌre itti okkwi ipikkoik nokuppuꞌrung akrïk anaruk mpei cene ithoꞌrkït thon ammakka pul iparekinenon. ");
INSERT INTO lmd_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Onon thocoꞌrothin appik akka mpokat ilon ilokithak. ");
INSERT INTO lmd_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ana ammakka ongappa pethin ngili ikkun mpakkinthet non cakuruk ammakka kwokkinthin ");
INSERT INTO lmd_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ittina oron thaꞌrkoik ana ïkkoik uraththungon nokuppuꞌrung kin kothuꞌrit ingili ngngin ana annikkoik norrok annakkma ul mothok mothok moul woIccereil iattul ana ikken keꞌra.” ");
INSERT INTO lmd_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","AIeccuo iꞌrekat oCcamaan itti, “Camaan, antoccïkot, pul pothopulut pipittot itti penekkenon appik ere pul amma apïꞌre mïl nti nartta. ");
INSERT INTO lmd_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Anaruk mpaꞌranung ngaꞌrama itti athoccokot lon loKapik nocïkït cang okorronno apot cik ana amma ngkwokkaprttakot ntan apoꞌrie opangkangon than ithoccokot lon loKapik nocïkït.” ");
INSERT INTO lmd_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Anaruk oCcamaan pothïanthet oIeccuo tit itti, “Orit thaeo ikorrkkor iraththeꞌra ana iththille iraththeꞌra cakuruk.” ");
INSERT INTO lmd_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","AIeccuo othïanthok tit itti, “Poththuruc, mpiꞌrethung lon ilaik ïcat itti, athakꞌruk tharthuk oo ngkoꞌra engi ngkwacukkwo nolon itti ngkwomman maꞌri mꞌrapuruk.” ");
INSERT INTO lmd_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ittina aIeccuo ipittat itti, “Katha akka mpothïothenon nokurtti anthellat aꞌruk wakucci ana aꞌruk wokurtti ana wok iracok, onon nthonat thiak thaꞌrupu wꞌreki?” Akin othïat tit itti, “Onïn thellat thiak thaꞌrupu wꞌrek.” ");
INSERT INTO lmd_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","AIeccuo iꞌrekat kin itti, “Ana inenni okkwi iponu kaꞌruk kakucci akwoneko ana manna kaꞌruk kokurtti akwoneko ana okkwi ipella kiꞌrittang ikukwit akwarot kret kung icekere akwokero kꞌrittang. ");
INSERT INTO lmd_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Lokurrakot itti, ‘Kwokuttakothe nul iokithak.’ Ana mpiꞌrethenon itti lakaik naun ilokurrakot ana ïcat ilokurrakot ilerethin laik lathakka.” ");
INSERT INTO lmd_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Aul iammakothok iꞌrekat itti, “Okatha cene Ili, iꞌrittang wei cene weꞌra.” AIeccuo othïanthet kin itti, “Lekkot.” ");
INSERT INTO lmd_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","AIeccuo oingkat nocoꞌrong coCeththun ammakka akwokkettet appinappin aul iammakothok omakathok. ");
INSERT INTO lmd_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Anakka kweot nokaꞌran ken akwiꞌrekat kin itti, “Naꞌra ngaꞌrama akka anon apot ilon lothenekketta tholon ilokithak.” ");
INSERT INTO lmd_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Akwoththekat nakin akwoingat ciththan papotteik akweekat ungku ncik akwaꞌrakat ngaꞌrama itti, ");
INSERT INTO lmd_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Ngappa, amma ngkwongothe, onekothin thoccokot thiak enthi, annoka ammakka mpongothe, anaruk ammakka ngkwongothe.” ");
INSERT INTO lmd_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Uꞌrupa wothothïlettat woKapik wakkakanthok ntothiꞌrot ana wikkatheik amerekethok itti kwapoꞌrathan. ");
INSERT INTO lmd_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","OIeccuo pokat nothiak akwaꞌrakat ngaꞌrama cannan ana nguttetta ngikkatheik angoththopot cik nocapu nti iaak ere ngüccük. ");
INSERT INTO lmd_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Anakka kurokot nnaꞌrama kwopakkanthet ul iammakothok ana kwaththiat akin thaik inthe akka okin thokat ithiak cakuruk. ");
INSERT INTO lmd_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Anakka oIeccuo poinet kin akwipittat kin itti, “Ngintha akka annoine inthe? Nuroko annaꞌra ngaꞌrama othakka itti anon okkorronno apot ilon lothenekketta tholon ilokithak.” ");
INSERT INTO lmd_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Manakka oIeccuo pokat cik akkwarthuk paik perenekin, acungkut coul akkakat ana pul ipoccot kꞌran itti oIoutha nti iul wung iattul ana ikken keꞌra akkwonat kin akwothakkarat iccik koIeccuo akwomiccathok ïꞌrïkothok topere. ");
INSERT INTO lmd_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Anaruk oIeccuo pipittathok itti, “Ioutha, ngkwaat itti ngkwathokerot nili ukul wopul iponyi nthomicco ïꞌrïkarot toperei?” ");
INSERT INTO lmd_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Anakka ul iammakot oIeccuo wimmat lon ilaik lathokkattat, akin ipittat oIeccuo itti, “Ili, ïnthaꞌrumot kin niꞌrittangi?” ");
INSERT INTO lmd_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Apilin nti iul iammakothok okiat kunu cik kopul iparekine pul iprïk ponoppan toKapik kothokkun wothothari. ");
INSERT INTO lmd_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Anaruk oIeccuo piꞌrekathekin itti, “Lekkot pꞌrïn.” Ana kwothantathe kunu nukun wung ana kopakkatherit koporot. ");
INSERT INTO lmd_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ittina aIeccuo iꞌrekat ul ittïttïk woul wonoppan toKapik ana okin ithangwot cik noppan toKapik ana ul ittïttïk woul iainok itti, “Nthame itti oun pul ipaurrot lon cik akka onon thainin mmuꞌrang ana iꞌrittang iukwit wukwiri? ");
INSERT INTO lmd_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Mpokat cik unaththungon appinappin noppan toKapik ana anthakannoccokothin. Anaruk caꞌri con enci ica annokkot lon ilanon thongothe itti onon thakkot amma pul pothopulut okkwi iponu puꞌran poïꞌrïmak paik ire.” ");
INSERT INTO lmd_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ittina akin occokathok akin onekathok tuan topul iprïk ponoppan toKapik. OPoththuruc pokat cik akwommakot kin nciththan. ");
INSERT INTO lmd_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Anaruk akka okin thokwothe thik nocaꞌrakat akin ïkot oPoththuruc pikkatheik iakin. ");
INSERT INTO lmd_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Aukul ioiꞌre iareko immakat oPoththuruc akwïkot thik akwokathakathok kicce aiꞌrekat itti, “Pul empi pokat cik akin oIeccuo.” ");
INSERT INTO lmd_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Anaruk kwocukkathe nan akwiꞌret itti, “Ukul, mpommak.” ");
INSERT INTO lmd_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Papotteik apul pꞌrek appiꞌrekat oPoththuruc itti, “Ngkwokat cik onaththeꞌra.” APoththuruc iꞌrekat itti, “Pul empi okonnoka oun.” ");
INSERT INTO lmd_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ana okin thokkothe cïngkï culukku apul pꞌrek appiꞌrekat itti, “Kwokat cik okin oIeccuo akka ook pul ponoul woCelïl.” ");
INSERT INTO lmd_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","APoththuruc iꞌrekat itti, “Mpomma lon ilanon thaik theret” ana akka kwokat cik akwere, athakꞌruk oat. ");
INSERT INTO lmd_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ittina aIli oprttakat cik akathakat oPoththuruc. Menik aPoththuruc okwarikat lon ila Ili wokat wiꞌrethok itti, “Inenni athakꞌruk tharthuk oo, ngkwacukkwo nolon itti ngkwinan maꞌri mꞌrapuruk.” ");
INSERT INTO lmd_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","APoththuruc oingkat thapat akwikkat cik akwoo puccuk. ");
INSERT INTO lmd_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ana ul iokat cik angwot oIeccuo wikkatheik akkothok ngure ngngin ana akkwekok. ");
INSERT INTO lmd_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Akin ïꞌrïkïkkothok kret toca akin nthipittothok itti, “Oththa akkokkworung?” ");
INSERT INTO lmd_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ana okin ocungkok ngkꞌret koppot. ");
INSERT INTO lmd_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ana ngorrot ngïꞌrïmak aul ittïttïk woul wonoppan toKapik ana ul iangkene lon lothonceꞌret lon cik ikkat cik tothun aIeccuo onekittakat tokït ken. ");
INSERT INTO lmd_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Akin ipittat oIeccuo itti, “Iꞌrethenïn amma oung oMicce?” AIeccuo othïanthet kin tit itti, “Amma mpiꞌrethenon ana onon thannoccïkot lon lin. ");
INSERT INTO lmd_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ana amma mpipittothenon lon ana onon thannothïnthin tit. ");
INSERT INTO lmd_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ana nci inenni ukul wopul iponyi wikkoik noprrok thokkun wothothari woKapik ikrïk.” ");
INSERT INTO lmd_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Akin appik ipittathok itti, “Oung ukul woKapiki?” Akwothïat tit itti, “Locoꞌrotheik ilanon thiꞌret itti oun ukul woKapik.” ");
INSERT INTO lmd_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ittina akin iꞌrekat itti, “Oron thongothe ul immat lon ngkït arttot nan wothentha? Oron thoccïkothe nothuꞌre thung.” ");
INSERT INTO lmd_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ittina aul iokat cik appik urokot kapik anekanthet oPilaththoc oIeccuo. ");
INSERT INTO lmd_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ana okin thikkatheik akin oruket oIeccuo lon itti, “Onïn thiothe pul empi apongkene ul lon ilakorronnokin akin okkot lon moloko. Kwiꞌret itti okin thannoccïkot lon lonili, ana akwomet ul itti okin thakorronno aꞌrintinthet oKkaiccer akucci ana akwiꞌret ka kung itti ook oMiccie Ili wonnon.” ");
INSERT INTO lmd_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ittina aPilaththoc ipittathok itti, “Oung ili woIouthi?” AIeccuo othïat tit itti, “Laik ammakka ngkwiꞌret.” ");
INSERT INTO lmd_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ittina aPilaththoc iꞌrekat ul woul wonoppan toKapik ana ul appik akwiꞌrekat kin itti, “Mpanniot lon lꞌrek ilamoloko ila anoruket pul empi ngngin.” ");
INSERT INTO lmd_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Anaruk okin thikkatheik akin ere itti, “Kwokat cik akwongkene ana ereket ul nthongkene thung noththok poIouthia appik. Kwokuꞌret ncik nnoththok poCelïl ana inenni kwei paat ci noththok cene cakuruk.” ");
INSERT INTO lmd_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Manakka oPilaththoc poccïkothe elli akwipittat itti, “Pul empi ponoththok poCelïli?” ");
INSERT INTO lmd_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Anakka kwinat itti oIeccuo ponoththok poCelïl ipa Ili oIruthuc ponat ikkun, kwothïanthet oIruthuc oIeccuo. ");
INSERT INTO lmd_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Manakka oIruthuc pimmat oIeccuo, akwopirakat noka akka kwappongothe nci nan itti kwimmak akka kwappoccïkothe lon ilerettathok ana kwokat pongothe itti kwimma lon ilommaththik alokkattat nti ikkun wung. ");
INSERT INTO lmd_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Akwikkat cik akwipittot oIeccuo lon loppot anaruk oIeccuo pannothïanthok tit. ");
INSERT INTO lmd_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ul ittïttïk woul wonoppan toKapik ana ul iangkene lon lothonceꞌret lon cik wokat cik acoꞌro aerethok ana orukwethok lon ilokithak. ");
INSERT INTO lmd_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ittina oIruthuc ana ul wung irro thikkatheik akin ocoꞌro ana okkothok ngure ngngin ana occirok ngngin. Okin thakiekathok kret kopeththere akin othïanthok oPilaththoc. ");
INSERT INTO lmd_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Caꞌri cen oIruthuc okin oPilaththoc thokkwathe thuruko akka tokït okin thaththꞌrarot. ");
INSERT INTO lmd_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","APilaththoc akkarat ul ittïttïk woul wonoppan toKapik ana nili ana ul appik. ");
INSERT INTO lmd_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ana kwiꞌrekathekin itti, “Onon thonanin pul empi itti paik pangkene ul moloko ana mpipittothok lon tokït kon ana mpanniot lon lꞌrek ilaik moloko naak. ");
INSERT INTO lmd_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","OIruthuc manna panniat lon naak ana kwokkaprttinet ton ngok ntan ana ammakka onon thimmat itti pul empi pannokkot lon ilamoloko ilekko nan itti kwakkuttat. ");
INSERT INTO lmd_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ana ittina mpakkwekok akwelikkako.” ");
INSERT INTO lmd_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Akka kwokat ponu itti kwelikkinekkin pul pulukku nti ikorrkkor nokamuthe koThaurrot kaman kꞌrek cik. ");
INSERT INTO lmd_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Okin thiꞌrekathe mpoꞌre pulukku itti, “Okkwothok, alikkinenïn oParapac.” ");
INSERT INTO lmd_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(OParapac papponekkettathe ikorrkkor akka kwenekket itti kwereket ul nokaꞌran koUruccelim ana okkwot pul.) ");
INSERT INTO lmd_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","OPilaththoc pokat pongothe itti kwapelikko oIeccuo, akwapperekanthet kin. ");
INSERT INTO lmd_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Anaruk okin thikkatheik akin okkot poꞌre akin iꞌre itti, “Nokkwethok nothapak, nokkwethok nothapak.” ");
INSERT INTO lmd_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Akwappipittat kin othikkie maꞌri mꞌrapuruk opakkenthet kin itti, “Akaintha? Ngintha akka pul empi pokkothe akka mpakinniot lon ila anakkmak ngngin mpakkwekok anelikkok.” ");
INSERT INTO lmd_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Anaruk ul wikkatheik akkot poꞌre itti pakkuttat nothapak apoꞌre pen alkat lon ilokat cik. ");
INSERT INTO lmd_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ittina aPilaththoc okkanthet kin ammakka okin thongothe. ");
INSERT INTO lmd_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ana kwelikkanthet kin pul ipakin thaththongothe itti pelikkako nti ikorrkkor ipappokkothe camutta ana okkwot pul ana kwokkathe naIeccuo ilakin thongothe. ");
INSERT INTO lmd_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Anakka okin thokat cik akin eo oIeccuo ngngin akin iat oCcamaan ponokaꞌran koKirin akkwokat cik akwao ntopon ana okin thonekiekathok thapak akwomakot oIeccuo nthoceken. ");
INSERT INTO lmd_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Acungkut coul cokat acomakothok ana ul iari wokat cik akkwe tomïkït aoot oIeccuo. ");
INSERT INTO lmd_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","AIeccuo oprttakat kin akwiꞌrekat kin itti, “Nyukul inyari nyonokaꞌran koUruccelim, nokorronno oothin anaruk noot ka kon ana nyukul nyon. ");
INSERT INTO lmd_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Akka caꞌri cꞌrek cao canon iꞌre itti, ‘Loporot noul iaucung ana kïmmïk ikannakatta nan.’ ");
INSERT INTO lmd_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ittina ‘Okin thiꞌret moꞌrong itti, Noꞌrot nïn cik! ana iꞌret lorokokkok itti, Noꞌrumot nïn.’ ");
INSERT INTO lmd_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Amma ul okkot lon elli acik coporot, okin thakkot taththa amma cik cokithak?” ");
INSERT INTO lmd_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Aul wꞌrek weꞌra cakuruk onekittakat okin oIeccuo ionat thuꞌran akin othokkwettat nolapak. ");
INSERT INTO lmd_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Anakka okin thaat nokaꞌran ikoccot kꞌran itti kꞌrintil koca nakin thokkwethe oIeccuo nothapak okin oul ieꞌra ionat thuꞌran apꞌrek nthokkun wothothari ana pꞌrek nthokkun wothokure. ");
INSERT INTO lmd_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","OIeccuo piꞌrekathe itti, “Ngappa, occïkïnthet kin lon ilokithak akka okin thomma ilakin thaik thakkot.” Ana ul irro willillathe iret nthokkwo moꞌrio. ");
INSERT INTO lmd_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Aul ikkat cik akathaccek anili nen ikkat cik anoccirok ngngin. Akin iꞌre itti, “Kwoꞌrethe ul wꞌrek, akwoꞌret ka kung amma ook oMiccie ipa Kapik kakkarot.” ");
INSERT INTO lmd_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Aul irro cakuruk akkakat ana wikkathe cik akkothok ngure ngngin ana wekathok ngapak ingor. ");
INSERT INTO lmd_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Akin iꞌre itti, “Amma oung ili woIouth, oꞌrethe ka kang.” ");
INSERT INTO lmd_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ana lon lokat cik lokurrakot toꞌra wung nokuruthut itti, ILI ENNI WOUL WOIOUTH. ");
INSERT INTO lmd_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Apul pꞌrek nti iul wothuꞌran ipokkwettathe nothapak ocungkat oIeccuo itti, “Oꞌrethe ka kang aꞌrekat nïn cakuruk amma oung oMiccie.” ");
INSERT INTO lmd_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Anaruk apilin othirriekathok cik itti, “Ngkwannopellene Kapiki? Unthaik ilon lulukku. ");
INSERT INTO lmd_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Orit thoccot lon moloko nti ilon lorit ilarit thokkothe anaruk pul empi pella lon ila kwokkothe ila moloko.” ");
INSERT INTO lmd_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ittina akwiꞌrekat oIeccuo itti, “Okwarikothin amma aiꞌriko ingili.” ");
INSERT INTO lmd_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","AIeccuo othïanthok tit itti, “Mpiꞌrethung ilaik ïcat itti orit thaka iraththeꞌra tothiꞌrot inenni.” ");
INSERT INTO lmd_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ana cïngkï cokat cuat ippa angïꞌrïmak oꞌrat cik nocapu puccuk mono acïngkï okkat cꞌrapuruk cipin. ");
INSERT INTO lmd_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Acïngkï oꞌruttakat angïꞌrïmak oꞌrat cik. Akret ikapettoik ikokat cik akaꞌriko noppan toKapik akillakat tit mprak weꞌra. ");
INSERT INTO lmd_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","AIeccuo akkarat mpoꞌre cittan itti, “Ngappa, mpanekket kanang kin kothikkoik inyaun nyang.” Akwothukwat cokwa akwiat. ");
INSERT INTO lmd_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Anakka ili woul arrial ukuluk irro wimmat lon ilokkattathe akwopirakanthet Kapik noka aiꞌrekat itti, “Ïcat pul empi pellat lon cik ilamoloko.” ");
INSERT INTO lmd_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Menik ul appik iaꞌrantakothe itti wimma lon ilokat cik wikkatheik akkwe tomïkït men ana okin thoingkathe. ");
INSERT INTO lmd_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Anaruk okkwion appik ithinarok ana ul iari iommakothok noththok poCelïl wocoꞌrathe ciththan akathacce lon len. ");
INSERT INTO lmd_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Pul pꞌrek pokat cik poccot kꞌran itti oIuccip poRami ipokat iprïk icuththun coul woIouth ittïttïk, pul ipoporot tokït koKapik ");
INSERT INTO lmd_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","ana kwokat pannangkot lon ila nili nonocuththun nokat niꞌret ana lon ilakin thokkothe. Kwokat ponokaꞌran koIouthia ikoccot kꞌran itti Rami. Kwokat cik akwoꞌrïkot ngili ngoKapik. ");
INSERT INTO lmd_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Kwoingkanthet oPilaththoc akwipittathok kumi koIeccuo. ");
INSERT INTO lmd_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ittina akwonekat kumi akwoꞌremethekat ngkret ika ul ocïkkarko ngngin akwothocïkkat ippu ipaꞌranthang pocuꞌrol pie pannocïkkako pul pꞌrek tit. ");
INSERT INTO lmd_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Okat nocaꞌri cothokuccekot cik caꞌri caCcepith cokat napuththut caik cao. ");
INSERT INTO lmd_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ana ul iari iommakothe oIeccuo nnoththok poCelïl womakathe oIuccip akin immakat tupu ana tat akka kumi koIeccuo kïcettatheik tit. ");
INSERT INTO lmd_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ittina okin thoingkathe tuan akin othocikitto ngaak cik ana amutha akin athoꞌro kumi koIeccuo anaruk okin thikkatheik tuan nocaꞌri caCcepith ammakka thathuma thaik itti pul pella ipareko nocaꞌri caCcepith. ");
INSERT INTO lmd_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ana nocaꞌri corokït nnomaꞌri imeꞌreꞌrapuruk ana ngïꞌrïmak aul iari onekat ngaak iakin thocikittot cik akin oingkat thoppu. ");
INSERT INTO lmd_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Okin thaththiat kaꞌraccak kopaꞌrettat cik ntoppu. ");
INSERT INTO lmd_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Anaruk akka okin thiꞌrikot ippu, okin thakanniat kumi koIli oIeccuo. ");
INSERT INTO lmd_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Anakka okin thokat cik akin oprttakot tit nolon len, aul wꞌrek weꞌra iomura ummat ncik wakot eret wallio ere kꞌran kothuleꞌrak thokapik acoꞌrat iccik ken. ");
INSERT INTO lmd_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Aul iari ipat nꞌre nen ana wirriekathe toma cik nocapu anaruk ul wen iomura wiꞌrekathekin itti, “Ngintha akka annokwariccanthet okkwi ipaik ngkït thapat iul illet? ");
INSERT INTO lmd_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Okkwella cïnang kurokot nti ithio nokwarikot lon ila kwappiꞌrethenon akka kwokat cik noththok poCelïl itti, ");
INSERT INTO lmd_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Ukul wopul iponyi waul wolon ilokithak occokot ana wakkwettat nothapak ana nomaꞌri imꞌrapuruk wuroko nti ithio.’” ");
INSERT INTO lmd_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Menik akin okwarikat lon lung. ");
INSERT INTO lmd_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Akka okin thokkaprttakot nthoppu akin erekanthet ul iattul ana ikken culukku ana ul wꞌrek appik lon ilokat cik. ");
INSERT INTO lmd_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ul iokat cik oMeriom moMacthelia ana oIona ana oMeriom onnan poIakup ana opilingon thꞌrek ithakin thokat aththut akka okin therenet ul wung wothothïlettat. ");
INSERT INTO lmd_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Anaruk okin thaththꞌrat occïkot lon loul iari, akka lon len lokat cik alokathako ere lon nuthuk lella lon cik. ");
INSERT INTO lmd_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ana oPoththuruc purokathe ana kwollathe thoppu. Ana kwirratheik noppu akwokathakat ippu ana kwimmakathe kret ika aIeccuo pappocïkkakot ngngin akkaik pellek. Ittina kwopakkathe tuan ana kwikkatheik akwoprttakat tit nolon len. ");
INSERT INTO lmd_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ana nocaꞌri cen aul wꞌrek weꞌra iammakot oIeccuo wokat cik aeo nokaꞌran ikoccot kꞌran itti Amaoc ikokat ciththan papotteik nokaꞌran koUruccelim. ");
INSERT INTO lmd_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Okin thokat cik akin erettine lon appik ilokat cik lokkattathe. ");
INSERT INTO lmd_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Anakka okin thikkot cik akin erettine, aIeccuo ngka kung akkakat akwikkat cik akin onyaro okin auththungon. ");
INSERT INTO lmd_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Anaruk Kapik kakkongwothekin mïkït nti ikarak itti okin thannina itti ook oIeccuo. ");
INSERT INTO lmd_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Akwipittat kin itti, “Ngintha akka onon thaik thanyaro anneret?” Akin ocoꞌrat akin thannoka thopirat noka akin irrat cik ee ma ncik nocapu. ");
INSERT INTO lmd_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Apilin ntiakin poccot kꞌran itti oKalapiuc ipittat oIeccuo itti, “Oung pellek akkie cene nokaꞌran koUruccelim pomma lon ilokkattathe nomaꞌri emmi?” ");
INSERT INTO lmd_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","AIeccuo ipittat kin itti, “Ngintha akkokat cik.” Akin othïat tit itti, “Ilokkattathe naIeccuo poNaccir ipokat pul pothernte lon loKapik ipinat cik nthere lon ana ngre tokït koKapik ana tokït koul appik. ");
INSERT INTO lmd_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ana ul ittïttïk woul wonoppan toKapik ana nili nonnon nonekot oIeccuo ana nethet nili noRoma akin akkmak itti kwakuttat, ana okin thokkwekathok nothapak ");
INSERT INTO lmd_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","anaruk onïn thokat ïnoꞌrïkot cik itti ook akkelikko ul woIccereil ana maꞌri mei mokkothe mꞌrapuruk ammakka kwiot. ");
INSERT INTO lmd_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Anaruk ul wꞌrek iari iokat cik ammakothok wirriet nïn mïkït nti ikarak itti okin theot thoppu ngïꞌrïmak ");
INSERT INTO lmd_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ana okin thakanniot kumi koIeccuo. Ana okin thiꞌrethenïn itti uꞌrupa wothothïlettat woKapik wumminthet kin ncik ana wiꞌret itti oIeccuo paik ngkït thapat. ");
INSERT INTO lmd_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ittina ul wꞌrek iomura nti ianïn woingkathe ana okin thaththiat ammakka ul iari wiꞌrethenïn anaruk okin thannimmak.” ");
INSERT INTO lmd_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Kwiꞌrekathekin itti, “Nthontha akka nthommaik ittina ana nthannoka thacokoccokot nthoccokot lon nomïkït ila ul wothernte lon loKapik weret. ");
INSERT INTO lmd_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Nthomma itti oMiccie ponu itti kwaccokot thiak llon elli akwantiꞌriko ithrïk thungi?” ");
INSERT INTO lmd_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Menik aIeccuo ikkat cik akwerenekin lon ilerethok iatham woKapik ana ilokurrakot cakuruk nci natham woMucca oingkanthet natham noul wothernte lon loKapik appik. ");
INSERT INTO lmd_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Anakka okin thaat iccik koricarak coman nakin thaik thaeo, aIeccuo ikkat cik ere kwaik paeo ciththan. ");
INSERT INTO lmd_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Anaruk okin thokkaprttathe oIeccuo akin iꞌrekathok itti, “Ton ikkoik akka cik ceot.” Ana kwoingkathe akin othikkoik okin auththungon. ");
INSERT INTO lmd_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Anakka kwikkot cik nokuppuꞌrung kothuꞌrit akin aththeꞌran oIeccuo ponekathe arrakith ana kwopirakanthet Kapik noka ana kwomithathe tit akwikkat cik akwikket kin. ");
INSERT INTO lmd_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ittina kït ken kimmakathe cik ana okin thinakathe oIeccuo ana kwintakatheik ntokït ken. ");
INSERT INTO lmd_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Okin thikkatheik akin erettarne itti, “Orit thokat thannopira noka akka kwokat cik akwerenerit ana ongkene atham wolon iloporori?” ");
INSERT INTO lmd_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Okin thurokathe akin opakkat nokaꞌran koUruccelim akin othiat ul wung wothothïlettat iattul ana ikken culukku ana opilingon ithokat cik okin aththungon akin thaik tothun. ");
INSERT INTO lmd_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Akin iꞌrekat ul ieꞌra itti, “Ïcat Ili wurokot ana wumminthet oCcamaan ncik.” ");
INSERT INTO lmd_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ana ul ieꞌra wikkatheik aerenekin lon ilokkattathe ikathar ana tat akka okin thinat oIeccuo nthomitho iarrakith. ");
INSERT INTO lmd_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Anakka okin thokat cik akin ere aIeccuo ummanthet kin ncik ngka kung ithoꞌrkït then akwiꞌrekat kin itti, “Ntharaththa atti nthoporot?” ");
INSERT INTO lmd_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Anaruk okin thirratherit ana ipo nꞌre akin ikkat cik ere okin thimmat purrut. ");
INSERT INTO lmd_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","AIeccuo iꞌrekat kin itti, “Ngintha akka onon opellene ana nthontha akka nthakannoccokot lon nomïkït itti mpaik ngkït thapat? ");
INSERT INTO lmd_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Nokatha nyaun nyin ana tacok tin, ka kin engki nantothnton anninan, purrut pella ka ana mummian ammakka mponu.” ");
INSERT INTO lmd_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Akka kwiꞌret lon len akwokenekat kin nyaun nyung ana tacok tung. ");
INSERT INTO lmd_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Anaruk okin thaththakannoccokat lon len akka okin thaththokat thopirat noka cannan ana nthoprttakotherit ana oIeccuo pipittathekin itti, “Onon thonu alepꞌrek cene iaꞌrttai?” ");
INSERT INTO lmd_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ana akin thekathok pape paputtat. ");
INSERT INTO lmd_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ana kwonekathe ana kwoꞌrkkathe tokït ken. ");
INSERT INTO lmd_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Akwiꞌrekat kin itti, “Elli ila mpappiꞌrethenon akka mpokat unaththungon. Lon appik lomarttakot ammakka lerettathin iatham wolon lothonceꞌret lon cik woMucca ana inatham noul wothernte lon loKapik ana iatham woMocumur.” ");
INSERT INTO lmd_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ittina kwanyanthet kin ma othakka itti akin ina atham woKapik. ");
INSERT INTO lmd_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Akwiꞌrekat kin itti, “Elli akkokurrakot itti oMiccie paccokot thiak ana kuroko nti ithio nomaꞌri imꞌrapuruk. ");
INSERT INTO lmd_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ana lon lothokkarttako nti ilon ilokithak ana thoccïkarnthet lon ilokithak lakaik ngkꞌran koIeccuo ana liꞌrettat ul appik okuꞌre ncik nokaꞌran koUruccelim. ");
INSERT INTO lmd_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ana onon thimmat lon elli appik ngkït kon ana mpongothe itti onon thatherene opilingon thꞌrek. ");
INSERT INTO lmd_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ana mpaik pathothïnthet non ila ngappa papponekketheik, anaruk nikkoik nokaꞌran koUruccelim puccuk Kanang ikupupure akkakanthet non akoppappakat ianon mpuꞌran ntothiꞌrot.” ");
INSERT INTO lmd_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Anakka kwipothekin thapat nokaꞌran koPeththania akwonthat nyaun kapik akwethïekat kin. ");
INSERT INTO lmd_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Anakka kwokat cik akwethïekin kwoththekathe nakin akwonekittakat tothiꞌrot. ");
INSERT INTO lmd_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ittina okin thikkatheik akin aꞌranok ngaꞌrama ana okin thopakkathe nokaꞌran koUruccelim akin thopirat noka anganna. ");
INSERT INTO lmd_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ana okin thikikkatheik noppan toKapik appin akin aꞌrane Kapik ngaꞌrama.");
INSERT INTO lmd_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ncinomun papꞌrek pellat cik, lon lokat cik ana lon lokat cik noKapik. ");
INSERT INTO lmd_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ana ncinomun kwokat cik okin oKapik. ");
INSERT INTO lmd_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ana Kapik kokkathe aꞌrupu appik nti ikkun wolon len ana papella ipokat cik pokkattathe aukun wolon len wakonnokkot. ");
INSERT INTO lmd_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Thikkoik thaat nnolon ana thikkoik then ithen akkanane ul kꞌran ikimmiekin cik appik. ");
INSERT INTO lmd_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Kꞌran kaccieik iꞌrïmak, ana ngïꞌrïmak ngannalkot kꞌran ken. ");
INSERT INTO lmd_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Pul pꞌrek pakkakathe ipa Kapik kothïothe ponat kꞌran itti oIuanna. ");
INSERT INTO lmd_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Kwaat itti akwatherene ul lon lokꞌran ken ikainet ul, othakka itti aul appik occokot lon nomïkït nti ilon loIuanna. ");
INSERT INTO lmd_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ook ngka kung pakannoka kꞌran ikacco, kwaat itti akwatherene ul lon lopul ipethekkin kꞌran ikacco. ");
INSERT INTO lmd_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Kꞌran ikacco ikaik ïcat ikacciene ul cik appik kokat cik akao nocapu. ");
INSERT INTO lmd_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Lon lokat cik nocapu antoka manna itti capu ncik appik cokkattathe nti ikkun wung anaruk capu commarok. ");
INSERT INTO lmd_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Kwainet pothok ipokat pung anaruk ul wung wakinnikkiek cik. ");
INSERT INTO lmd_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Anaruk okkwion ithikkierok cik ana ithoccokothe lon lokꞌran kung nomïkït, kwokorronnathekin akin othakka nyukul nyoKapik, ");
INSERT INTO lmd_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","nyukul inya akorronno okwonta nti iul ionyi ana akka ul ionyi wongothe itti okin thakwonta anaruk okin thokwontat noKapik. ");
INSERT INTO lmd_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Lon lothakkakathe ka kopul iponyi akikkat cik iaron. Oron thimmat thrïk thung, thrïk thung pulluk pen okkwi ipaat naththan, nthoporot thoppot ana lon ilaik ïcat. ");
INSERT INTO lmd_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","OIuanna pocoꞌrothok ntherethok llon ilaik ïcat akwiꞌre mpoꞌre cittan itti, “Ook empi ipa mpiꞌret lon len itti, ‘Okkwi ipamakothin prïk naun akka kwokat cik tokït naun.’” ");
INSERT INTO lmd_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ana nti ithoporot thung ithoppot, kwethïetheron cik arttot nomaꞌri moppot. ");
INSERT INTO lmd_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Akka lon lothonceꞌret lon cik loKapik lakkethet ton nti ikkun woMucca ana thoporot ana lon ilaik ïcat laIeccuo oMiccie akkonat. ");
INSERT INTO lmd_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Pul pella pimmat Kapik kirrkkir. Anaruk ukul wung wulluk, iammakka Kapik ïcat ana iaik iccik kung, ien akkiniet ton Kapik. ");
INSERT INTO lmd_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Lon elli ila Iuanna pomamuthie peret ngka kung akka ul ittïttïk woIouth wonokaꞌran koUruccelim wothïothe ul wonoppan toKapik ana ul woLaui akin othipittothok itti ook okkwen. ");
INSERT INTO lmd_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Kwakonnocukkwat nolon anaruk kwiꞌret ncinokkït itti, “Mpannoka oMiccie.” ");
INSERT INTO lmd_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Akin ipittathok itti, “Ana oung okkwen? Oung oIliai?” Ana kwiꞌrekathe itti, “Mpakannoka oIlia.” Ana okin thipittathok itti, “Ana oung pul ipernte lon loKapiki?” Kwothïanthet kin tit itti, “Aa.” ");
INSERT INTO lmd_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ittina pꞌrïn akin iꞌrekathok itti, “Ana oung okkwen? Iꞌrethenïn lon ilanïn onekine ul iothïothenïn. Ngkwiꞌre itti oung oththa?” ");
INSERT INTO lmd_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","OIuanna pothïatherit llon lopul pothernte lon loKapik oIccaia iliꞌre itti, “Oun poꞌre ipaik pakkakkaro nti ithampang, apiꞌre itti, ‘Nokkinthet Ili kathar kocoꞌrotheik.’” ");
INSERT INTO lmd_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ittina ul woPriccin iarothïlathe, ");
INSERT INTO lmd_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ipittat oIuanna itti, “Ana ngkwonin akka aethet ul mamuthie amma ngkwannoka oMiccie ana manna okonnoka oIlia ana manna okonnoka pul pothernte lon loKapik?” ");
INSERT INTO lmd_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","AIuanna othïat tit itti, “Mpethet non mamuthie ngngꞌri, anaruk opilin paik ianon ipanon thomma. ");
INSERT INTO lmd_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ook ipamakothin ook ipa mpakannekko nan itti mpakꞌrinok loꞌrak lowok.” ");
INSERT INTO lmd_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Elli appik lokkattathe nokaꞌran koPeththania nokuthut korue toÜrüthün nthokarkan nacïngkï ummot ngngin, na aIuanna pokat akwikket ul mamuthie. ");
INSERT INTO lmd_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ngorrot ngen oIuanna pimmakathe oIeccuo akwanthan naak akwiꞌrekat itti, “Nantokatha, thungkat thoKapik okkwi ipapaꞌre lon ilokithak cik nnocapu. ");
INSERT INTO lmd_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ook ipa mpokat cik aneret akka mpiꞌret itti, ‘Pul ipamakothin prïk naun akka kwokat cik amparthuk okwonta.’ ");
INSERT INTO lmd_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Manna inenni oun ngka kin mpommak itti kwaka okkwen anaruk lon ila mpaik pikkenthet ul mamuthie ngngꞌri othakka itti aul woIccereil inak.” ");
INSERT INTO lmd_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ittina aIuanna iꞌrekat lon ila kwimmat itti, “Mpimmat Kanang ikupupure akuo ntothiꞌrot ere cülükkür akoꞌrat naak. ");
INSERT INTO lmd_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Mpakannainarok anaruk okkwi ipothïothin anathikket ul mamuthie ngngꞌri, akkiꞌrethin itti pul ipanon thaik thakathecce, Kanang koKapik kaꞌro nan akikkat cik naak, ook ipikket ul mamuthie ngKanang ikupupure. ");
INSERT INTO lmd_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Mpimmat ana mpaik piꞌre ila mpimmat itti ook ukul woKapik.” ");
INSERT INTO lmd_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ana ngorrot ngen, oIuanna pokat cik akwocoꞌro nnul iammakothok weꞌra. ");
INSERT INTO lmd_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Kwimmakathe oIeccuo akwoppo cïnang. Ana kwiꞌrekathe itti, “Nokatha thungkat thoKapik theꞌre.” ");
INSERT INTO lmd_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Anakka ul iammakothok ieꞌra woccïkothe akwiꞌre lon elli, okin thomakathe oIeccuo. ");
INSERT INTO lmd_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Manakka oIeccuo polliakothe, akwimmakat kin akin omakothok akwipittat kin itti, “Ngintha akka annokwariccat?” Okin thiꞌrekathe itti, “Pul ipangkene, kaman kang kaik kartha?” ");
INSERT INTO lmd_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Akwiꞌrekat kin itti, “Nanthan annathokatha.” Menik akin oingkat akin othokathakat na kwokat akwikkoik ana okin thikkatheik cipin cen okin aththut ana cïngkï cokat cocoꞌrin cocipin. ");
INSERT INTO lmd_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Anthrauc opang poCamaan oPoththuruc okin nti iakin itheꞌra ithoccïkothe lon ila Iuanna piꞌret akin omakathok. ");
INSERT INTO lmd_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Lon ila Anthrauc pokkothe cittokït itti kwiothe opang poCamaan akwerekanthok itti, “Onïn thiothe oMiccie okkwi ipa Kapik kothiothe.” ");
INSERT INTO lmd_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ana kwonakathok na aIeccuo. Ana oIeccuo pokathakathok ana kwiꞌrekathe itti, “Ngkwoccot kꞌran itti oCamaan ukul woIuanna. Ngkwakkarako itti oCcappa” (ilonu itti oPoththuruc). ");
INSERT INTO lmd_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ana ngorrot ngen, oIeccuo piꞌrekathe itti kwaeo noththok poCelïl ana kwiathe oPilippic ana kwiꞌrekathok itti “Omakothin.” ");
INSERT INTO lmd_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","OPilippic pokat ponokaꞌran koPeththcceitha ammakka Anthrauc ana oPoththuruc. ");
INSERT INTO lmd_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","OPilippic piathe oNaththanail akwiꞌrekathok itti, “Onïn thiothe okkwi ipa oMucca pappokurrot lon len iatham wothonceꞌret lon cik ana ipa ul wothernte lon loKapik wokurrot lon len cakuruk itti oIeccuo poNaccir, ukul woIuccip.” ");
INSERT INTO lmd_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","ANaththanail ipittat itti, “Lon lꞌrek lakaik iloporot lanthan nokaꞌran koNacciri?” APilippic omekathok itti, “Aꞌrik aththokatha.” ");
INSERT INTO lmd_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Anakka oIeccuo pimmat oNaththanail akwanthan naak, akwiꞌrekat itti, “Katha okkwempi paIccereil ïcarïcat ipella loꞌrek moloko manna lotte.” ");
INSERT INTO lmd_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","ANaththanail ipittathok itti, “Ngkwinan taththa?” AIeccuo othïat tit itti, “Mpimmarung akka ngkwokat cik icuꞌre copïcït, aPilippic parthuk akkarong.” ");
INSERT INTO lmd_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","ANaththanail iꞌrekat lon mpoꞌre cittan itti, “Pul ipangkene, oung ukul woKapik, oung Ili woIccereil.” ");
INSERT INTO lmd_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","AIeccuo iꞌrekat itti, “Ngkwoccokothe lon nocïkït akka mpiꞌret itti mpimmathung icuꞌre copïcïri? Ngkwimma lon lommaththik nolon elli.” ");
INSERT INTO lmd_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","AIeccuo apparttat nan itti, “Mpiꞌret non lon ilaik ïcat, onon thimma tothiꞌrot tanyattatheik ana uꞌrupa wothothïlettat woKapik awaik akuꞌrot ana uo ntan nokkul wopul iponyi.” ");
INSERT INTO lmd_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ana nocaꞌri icꞌrapuruk athïpa thꞌrek okakat cik nokaꞌran koKana ikaik noththok poCelïl ana onnan poIeccuo oingkat than. ");
INSERT INTO lmd_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ana oIeccuo ana ul iammakothok thaththakkarakothe thïpa then cakuruk. ");
INSERT INTO lmd_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Anakka ngapak ngomttathe noul, annan poIeccuo iꞌrekathok itti, “Ngapak ngomttathe.” ");
INSERT INTO lmd_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","AIeccuo iꞌrekat itti, “Pul ipopari, ngkwiꞌrethin pothentha? Caꞌri cin carthuk anthan.” ");
INSERT INTO lmd_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Annan iꞌrekat ul iareko itti, “Nokkot ila akwiꞌret non.” ");
INSERT INTO lmd_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ana ummuk woiꞌri wokat cïnang iccik ken wꞌrakkuruk wokkattathe nomothok, ammakka lon lothonceꞌret lon cik loIouth ileret ummuk iothuntakot ana iannothuntako. Kulukku kokat akoneko ngꞌri ngoppot. ");
INSERT INTO lmd_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","AIeccuo iꞌrekat ul iareko itti, “Noppeppet ngꞌri ummuk,” akin oppeppekat. ");
INSERT INTO lmd_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ittina akwiꞌrekat kin itti, “Nokkwot ngꞌri ngotte nan annethet pul pothïpa.” Okin thokkathe menik ana ");
INSERT INTO lmd_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","pul pothïpa pinathe ngꞌri ioporttakot cik angothokkat ngapak, kwommat na ngaat ngngin anaruk ul iareko iokkuret ngꞌri winat nan. Ittina kwakkarathe pul ipipot thocipit, ");
INSERT INTO lmd_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","akwiꞌrekathok itti, “Ul appik wanane ul ngapak ioporot akin antonanekin ngꞌri ngokwonyi akin thoththakathe pꞌrïn anaruk ngkwangwothe ngapak cik ioporot manna ina.” ");
INSERT INTO lmd_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Lon elli lokat lon ilommaththik lonomun nolon ilommaththik ila oIeccuo pokkothe nokaꞌran koKana noththok poCelïl. Kwokenekathe ul iammakothok thrïk thung ana woccokathe lon lung nomïkït men. ");
INSERT INTO lmd_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Anakka lon elli locothakothe akin uat nokaꞌran koKapprnaum akin onnan ana opangon ana ul iammakothok. Okin thikkatheik than maꞌri motte. ");
INSERT INTO lmd_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Anakka caꞌri cokamuthe koul woIouth koThaurrot kaman kꞌrek cik kokat napuththut, aIeccuo okuꞌrat nokaꞌran koUruccelim. ");
INSERT INTO lmd_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ana kwaththiat ul akette kie ana lungkat ana mülükkür noppan toKapik ana opilingon thokat cik akin ikkoik nouppuꞌrung akin okwicitto akucci. ");
INSERT INTO lmd_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","OIeccuo pummathe pua akwokïccekat kin appik llungkat ana kie noppan toKapik. Kworrekathe kït kakucci koul iokat cik akwicitto akucci ana okuꞌrupot uppuꞌrung wen cik. ");
INSERT INTO lmd_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Akwomekat ul iakette mülükkür itti, “Nattet aꞌrupu enni thapat ncene. Nokorronno othikkie man mongappa kaꞌran kocekerek caꞌrupu.” ");
INSERT INTO lmd_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Aul iammakothok okwarikat itti lokurrakot itti, “Thiak thoman moKapik thaik thakkwothin.” ");
INSERT INTO lmd_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ittina aul ittïttïk woIouth ipittathok itti, “Lon lang liatha ilommaththik ilakene puꞌran ipakkot lon elli ngngin?” ");
INSERT INTO lmd_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","AIeccuo othïanthet kin tit itti, “Nokïtto tupan toKapik enti ana mpuno prek attang nomaꞌri mꞌrapuruk.” ");
INSERT INTO lmd_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Aul ittïttïk woIouth othïat tit itti, “Muntat luput arrial weꞌra ana ikken kꞌrakkuruk (46) ame itti ngkuno nomaꞌri mꞌrapuruke?” ");
INSERT INTO lmd_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Anaruk tupan toKapik ira kwerethe tokat ka kung. ");
INSERT INTO lmd_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Anakka kurokot nti ithio, aul iammakothok okwarikat lon ila kwiꞌret. Ittina akin occokat lon nomïkït lAtham woKapik ana ila oIeccuo peret. ");
INSERT INTO lmd_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Anakka kwokat cik nokaꞌran koUruccelim nokamuthe koThaurrot kaman kꞌrek cik, ul woppot wimmakathe lon ilommaththik ila kwokat cik akwokkot ana woccokathe lon nomïkït lokꞌran kung. ");
INSERT INTO lmd_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Anaruk oIeccuo pakannonekket cïkït nakin akka kwinat kin appik. ");
INSERT INTO lmd_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Kwokat pakannangkot itti opilin piꞌrethok itti ul warat akka kwinat itti ngimpen akkokat nomïkït moul ionyi. ");
INSERT INTO lmd_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Puꞌrek pokat cik poul woPriccin poccot kꞌran itti oNikkothemoc, kwokat nocuththun coul woIouth ittïttïk. ");
INSERT INTO lmd_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Kwainet oIeccuo ngkoꞌra akwiꞌrekathok itti, “Pul ipangkene, onïn thina itti oung pul ipangkene ipaat noKapik akka pul pella ipakkot lon ilommaththik ila ngkwaik pakkot amma Kapik kella naung.” ");
INSERT INTO lmd_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","AIeccuo othïat tit itti, “Mpiꞌrethung lon ilaik ïcat, amma pul pakannokwonta attang kwakinnimma ngili ngoKapik.” ");
INSERT INTO lmd_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","ANikkothemoc ipittat oIeccuo itti, “Pul pakwonta taththa appukkwat thomocco? Kwappopakkot icarak connan attang othakka itti akwokwontai?” ");
INSERT INTO lmd_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","AIeccuo othïat tit itti, “Mpiꞌrethung lon ilaik ïcat, pul pella piꞌriko ingili ngoKapik amma kwakannokwonta ngngꞌri ana ngKanang koKapik. ");
INSERT INTO lmd_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Pul iponyi pacco ka nannan ana naththan anaruk Kanang koKapik kakwono kanang ikaik iaron. ");
INSERT INTO lmd_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Onon thonu itti nthakannoprttakinthet lon lin tit ila mpiꞌret, ‘Onon thonu itti nthakwonta attang.’ ");
INSERT INTO lmd_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Kanang kakkurot na kongothe itti kakkurot, onon thaccïkot poꞌre pen, anaruk onon nthamma na kaik kanthan ngngin ana na kaik kaeo. Ittina ngkwamma itti pul pakwonta noKanang koKapik tat.” ");
INSERT INTO lmd_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","ANikkothemoc iꞌrekat itti, “Elli laka taththa?” ");
INSERT INTO lmd_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","AIeccuo othïat tit itti, “Oung pul ipangkene poIecceril. Ana ngkwakannina lon ellii? ");
INSERT INTO lmd_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Mpiꞌrethung lon ilaik ïcat, onïn theret lon ilanïn thina ana onïn thacoꞌrot lon ilanïn thimmat anaruk icci onon thakannangkot itti onon thaccïkot lon ilanïn iꞌret non. ");
INSERT INTO lmd_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Mperenet non lon laꞌrupu wonocapu ana onon thꞌrat occokot lon len nomïkït ana onon thantoccokot lon nomïkït taththa amma mperenet non laꞌrupu worothiꞌrot? ");
INSERT INTO lmd_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Pul pella ipokat tothiꞌrot, ukul wulluk wopul iponyi akkaat ntothiꞌrot. ");
INSERT INTO lmd_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ana ammakka oMucca ponthothe pinyil kapik ithampang ithonthomat, ittina ukul wopul iponyi wonu itti wanthuttat kapik cakuruk, ");
INSERT INTO lmd_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","othakka itti okkwi ipoccokothe lon lukkul wen nocïkït akwiot thikkoik thothupuththuput. ");
INSERT INTO lmd_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Akka Kapik kongothe ul ncik nocapu appik mono akekat kin ukul wung iulukku, othakka itti amma okkwi ipoccokothe lon lokkul wen nocïkït akwokorronno io anaruk akwikkoik thupuththuput. ");
INSERT INTO lmd_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Akka Kapik kakannothïot ukul wung nocapu ncik appik othakka itti athakkma ul nocapu anaruk itti athoꞌret kin. ");
INSERT INTO lmd_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Okkwi ipoccokothe lon lokkul wen nocïkït kwakorronno akkmako anaruk okkwi ipakorronno occokot, kwakkmako ntit akka kwakanno occokot lon lokkul woKapik iulukku nocïkït. ");
INSERT INTO lmd_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Okin thakkmako ngkathar engki, kꞌran ikimmiettoik kaat nocapu ncik appik, anaruk ul wꞌrat aangat lon loïꞌrïmak akka lon ilakin thokkothe lokat lokithak. ");
INSERT INTO lmd_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Okkwi ipakkot lon ilokithak kwaꞌrat kꞌran ikacco ana kwakannanthan nokꞌran ikacco akka kwapelle itti lon lung linako nan. ");
INSERT INTO lmd_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Anaruk okkwi ipakkot lon loporot kwanthan nokꞌran othakka itti alinako nan itti lon ila kwokkothe lokkattathe mpuꞌran poKapik.” ");
INSERT INTO lmd_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Anakka elli locothakothe oIeccuo ana ul iammakothok thoingkathe nocipit conoththok poIouthia, akwikkat cik than akin aththungon akwikket ul mamuthie. ");
INSERT INTO lmd_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","OIuanna pokat cik cakuruk akwikket ul mamuthie nokaꞌran kEnun iccik koCcalim akka ngꞌri ngokat cik than ngoppot ana ul wokat cik aukkwo than woppot athoccere mamuthie. ");
INSERT INTO lmd_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Lon elli lokat cik aIuanna parthuk onekkettat ikorrkkor. ");
INSERT INTO lmd_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ul woIuanna iammakothok wꞌrek wikkatheik aꞌrettaro nan okin opul pꞌrek poIouth noꞌron lothothunto. ");
INSERT INTO lmd_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Opilingon noul iammakot oIuanna akkakanthet oIuanna akin iꞌrekathok itti, “Pul ipangkene, opaththi ipanon thokat cik annaththeꞌra nokarkan kꞌrek koUruthun ipa ngkwerethe paik pikket ul mamuthie ana ul appik waik waukkwinok athoccere mamuthie.” ");
INSERT INTO lmd_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","OIuanna pothïatherit itti, “Pul pacco aꞌrupu amma Kapik kethok tulluk. ");
INSERT INTO lmd_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ana onon thina nan akka mpiꞌret itti, ‘Mpakannoka oMiccie anaruk mpothïlathe tokït kung.’ ");
INSERT INTO lmd_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Pul ipocura ipipot, ook pꞌre popul ipopari ipittat. Opuruko ipaat ithïpa thopul ipipot paꞌrïkot cik ana occïkot lon lung akwopirakat noka cannan amma akwoccïkot poꞌre popul ipipot. Mpopirat noka inenni pꞌrin. ");
INSERT INTO lmd_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Kwonu itti kwaka prïk, ana mponu itti mpaka potte. ");
INSERT INTO lmd_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Okkwi ipanthan ntothiꞌrot prïk naꞌrupu appik, okkwi ponocapu paka ponocapu ana kwere ere pul ponocapu. Okkwi ipaat ntothiꞌrot prïk noul ana aꞌrupu appik. ");
INSERT INTO lmd_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Kwerethe lon ila kwimmat ana occïkot anaruk pul pella poccïkïnthok lon lung. ");
INSERT INTO lmd_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Pul ipoccïkothe lon len, pocoꞌrothe lon itti Kapik kiꞌre lon ïcat. ");
INSERT INTO lmd_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Akka pul ipa Kapik kothïothe pere lon loKapik akka Kapik kethettot Kanang ikupupure koppot. ");
INSERT INTO lmd_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Oththan pokkul pongothe ukul ana kwethok lon ikkun wung appik. ");
INSERT INTO lmd_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Okkwi ipoccokothe lon nocïkït lokkul, kwiot thikkoik thothupuththuput ana okkwi ipꞌrat occïkot lon lokkul, kwakanniot thikkoik thothupuththuput akka thuaka thoKapik thaꞌrungkot naak.” ");
INSERT INTO lmd_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Aul woPriccin occïkat itti ul wokat cik aukkine oIeccuo ana kwokat cik akwikket kin mamuthie ana ul iammakothok wakot cik arttakat nan woppot noul woIuanna. ");
INSERT INTO lmd_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ana ilokat cik ïcat itti, okonnoka oIeccuo akkokat cik akwikket ul mamuthie anaruk ul iammakothok akkokat cik aikket ul mamuthie. ");
INSERT INTO lmd_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Manakka oIeccuo poccïkothe lon len kwoththekathe noththok poIouthia akwopakkat attang noththok poCelïl. ");
INSERT INTO lmd_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Anakka kwokat cik akweo ikathar, kwapponu itti kwappo noththok poCcamira. ");
INSERT INTO lmd_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ittina kwakkakathe nokaꞌran ikoccot kꞌran itti Cukar noththok poCcamira iccik kocapu ica oIakup pethet opei oIuccip. ");
INSERT INTO lmd_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ana tok toIakup tokat cik ceneket ana oIeccuo pappokinyanet kurtti akwikkat cik iccik korok. Ana cïngkï cokat acangko ippa. ");
INSERT INTO lmd_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Anakka pul ipopari poul woCamirin paat thorok itti pathokkwo ngꞌri, oIeccuo piꞌrekathok itti, “Ethin ngꞌri anïkko.” ");
INSERT INTO lmd_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Ul iammakothok waweot icarak coman athokette thuꞌrit.) ");
INSERT INTO lmd_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Apul ipopari poCamirin iꞌrekathok itti, “Oung pul poul woIouth ana oun pul poul woCamirin ana ngkwipittothin itti mpethung ngꞌri taththa?” (Akka ul woIouth wakïnnïkkarot ngꞌri okin ul woCamirin.) ");
INSERT INTO lmd_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","AIeccuo othïanthok tit itti, “Amma ngkwinat thethet nuthuk thoKapik ana okkwi ipaik pipittothung ngꞌri itti kwïkko, ngkwipittothok ana kwethung ngꞌri ngothikkoik thothupuththuput.” ");
INSERT INTO lmd_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Apul ipopari iꞌrekat itti, “Ili, ngkwella papu ipakkura ngꞌri nti irok ana tok tukwit. Ngkwiot ngꞌri ngothikkoik thupuththuput kartha?” ");
INSERT INTO lmd_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Oung akkrïk nangappa pïn oIakupi ipethet nïn tok enti, ira kwïkkot ngꞌri ntit ana nyukul nyung ana aꞌrupu worua wungi? ");
INSERT INTO lmd_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","AIeccuo othïat tit itti, “Okkwi ipïkko ngꞌri noiꞌri engi, pica pappokkwothok attang, ");
INSERT INTO lmd_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","anaruk okkwi ipïkko ngꞌri ianethok, pica pakorronno appokkwothok, akka ngꞌri ia anethok ngathakka cakuꞌrang coiꞌri icallo ngꞌri thothupuththuput.” ");
INSERT INTO lmd_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Apul ipopari iꞌrekathok itti, “Ili, ethin ngꞌri ngen othakka itti apica okorronno okkwothin ana anokorronno anthan thorok itti mpathokkwo ngꞌri attang.” ");
INSERT INTO lmd_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Akwiꞌrekat pul ipopari itti, “Ngko athakkaro olle pang annanthan annaththeꞌra.” ");
INSERT INTO lmd_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Apul ipopari othïat tit itti, “Mpella pꞌre.” AIeccuo omekathok itti, “Ïcat, lon ila ngkwiꞌret laik ïcat. ");
INSERT INTO lmd_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Lon ilaik ïcat itti ngkwonat eꞌre ukuluk ana pul ipanon thaik ina okorronno oka pꞌre pang. Ittina ila ngkwiꞌret laik ïcat.” ");
INSERT INTO lmd_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Apul ipopari iꞌrekat itti, “Ili, mpakatha ere ngkwapul potherente lon loKapik. ");
INSERT INTO lmd_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ongappan thoul woCamiria thokat cik akin aꞌrat ngaꞌrama nocoꞌrong enci anaruk onon ul woIouth thiꞌret itti kaꞌran nanïn thonu itti ïnthaꞌrat ngaꞌrama kaik nokaꞌran koUruccelim.” ");
INSERT INTO lmd_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","AIeccuo iꞌrekat itti, “Pul ipopari, occïkothe lon lin, caꞌri cꞌrek caik canthan ica anon okorronno aꞌranthet Kapik ongappa ngaꞌrama nocoꞌrong enci ana manna nokaꞌran koUruccelim. ");
INSERT INTO lmd_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Onon thoul woCcamirin thaꞌrane aꞌrupu ngaꞌrama ianon thomma, onïn ul woIouth thaꞌrane aꞌrupu ngaꞌrama ianïn thina akka thoꞌrettat thanthan noul woIouth. ");
INSERT INTO lmd_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Anaruk caꞌri caik canthan ana cei caat amma ul iaꞌra ngaꞌrama ïcarïcat aꞌrane ongappa ngaꞌrama ngkanang ana llon ilaik ïcat akka okin ithaꞌra ngaꞌrama ammakka enthi akka ongappa paik pakwantot. ");
INSERT INTO lmd_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Kapik kaKanang ana okkwion ithaꞌranok ngaꞌrama thonu itti okin thaꞌra ngaꞌrama ngkanang ana lon ilaik ïcat.” ");
INSERT INTO lmd_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Apul ipopari iꞌrekat itti, “Mpina itti oMiccie paik panthan okkwi ipa Kapik kaik kathiot, ana amma kwaat kwakeneron lon ncik appik.” ");
INSERT INTO lmd_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ittina aIeccuo iꞌrekat itti “Oun pen ipaik perenung.” ");
INSERT INTO lmd_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ana ittina aul iammakothok okkaprttakat ntan akin oprttakat tit akka okin thaththiothok akwerene pul ipopari. Anaruk pul pella ipipittathe itti, “Ngintha akkaik?” Ana manna itti, “Ngkwerene pul empi akaintha?” ");
INSERT INTO lmd_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ittina apul ipopari oththekat nokummuk koiꞌri ikakkwaththokkwo ngngꞌri apollat opakkat icarak coman apiꞌrekat ul itti, ");
INSERT INTO lmd_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Nantanthan, annathokatha pul pꞌrek piꞌrethin lon ncik appik ila mpokkothe, pul pen pikko paka oMicciei?” ");
INSERT INTO lmd_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ul wakkakathe nti icarak coman appik athokatha oIeccuo. ");
INSERT INTO lmd_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","OIeccuo pappakannoꞌrko papꞌrek aththik, aul iammakothok iꞌrekathok itti, “Pul ipangkene, oꞌrku aꞌrpꞌrek.” ");
INSERT INTO lmd_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Anaruk kwomekathekin itti, “Mponu thuꞌrit itha anoꞌrko thanon thomma.” ");
INSERT INTO lmd_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ul iammakothok wikkatheik aerettarne itti, “Opilin paththoka ponanok thuꞌriri?” ");
INSERT INTO lmd_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","AIeccuo iꞌrekat itti, “Thuꞌrit thin thokkot lon ila okkwi ipothïothin pongothe ana omartto ngre ngung. ");
INSERT INTO lmd_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Onon thonu lon lanniꞌre itti, ‘Anok wokwentakot wocoꞌrin aul antokioi?’ Anaruk mpiꞌret non itti, nantokatha opon wathuput thaat pꞌrïn itti wakecca. ");
INSERT INTO lmd_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ana pul ipakio poccot aꞌrupu nti ithokio, ana kwaik paꞌrntot mïl mothikkoik thothupuththuput othakka itti akkwi ipee ana okkwi ipakio opira noka aththuththeꞌra. ");
INSERT INTO lmd_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ittina lon iliꞌrettat itti, ‘Okkulukku pee ana opilin pakio’ laik ïcat. ");
INSERT INTO lmd_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Mpothïothenon annothokio aꞌrupu ianon thakannora. Opilingon thorekot ngre ngonthomat cannan ana onon thathokio aꞌrupu wore ngen.” ");
INSERT INTO lmd_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ul woppot woCcamirin woricarak coman cen woccokathe lon loIeccuo nomïkït men akka pul ipopari piꞌret itti, “Kwiꞌrethin lon ila mpokkothe appik.” ");
INSERT INTO lmd_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Anakka ul woCcamirin wainok womekathok itti kwikkoik okin aththut ana kwikkatheik maꞌri meꞌra. ");
INSERT INTO lmd_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ana nti ilon lung ila kweret, ul warttakathe nan woppot ana woccokathe lon lung nomïkït men. ");
INSERT INTO lmd_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Okin thiꞌrekathe pul ipopari itti, “Onïn thaik thakannoccokot lon nomïkït mïn nti ilon ila ngkwiꞌret tulluk anaruk nti ilon ila anïn thoccïkothe nunu wïn, ana onïn thina pꞌrïn itti pul empi pothoꞌret ul ncik appik.” ");
INSERT INTO lmd_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Anakka kwikkot cik maꞌri meꞌra, kwoingkathe noththok poCelïl. ");
INSERT INTO lmd_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Cene oIeccuo ngka kung pappiꞌret itti pul pothernte lon loKapik paul wung wakannothianok cik nokaꞌran kung. ");
INSERT INTO lmd_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Anakka kwaat noththok poCelïl, ul wonoththok poCelïl wikkiekathok cik lon loporot, akka okin thokat thimmat lon ila kwokkothe nokaꞌran koUruccelim nokamuthe koThaurrot kaman kꞌrek cik akka okin thokat than. ");
INSERT INTO lmd_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","OIeccuo pappropakkat nokaꞌran koKana attang noththok poCelïl na kwoprttot ngꞌri cik athakkakat ngapak. Ana pul pꞌrek pokat cik than parekine ili irïk ana ponat ukul wongo ana wokat nokaꞌran koKapprnaum. ");
INSERT INTO lmd_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Manakka pul empi poccïkothe itti oIeccuo paat nnoththok poIouthia ana kwaik noththok poCelïl, kwoingkanthok ana kwipittathok itti kwanthan akwathothikkienok ukul woporot, iokat cik ere wio. ");
INSERT INTO lmd_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","AIeccuo iꞌrekathok itti, “Ul enni onon thakanno occokot lon loKapik nomïkït mon amma nthakannimma lon ilommaththik lokkattathe.” ");
INSERT INTO lmd_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Apul iparekine ili pen omekat itti, “Ili tit eo aukul warthuk io.” ");
INSERT INTO lmd_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","AIeccuo othïat tit itti, “Opakkothe, ukul wang wakkoik.” Apul occïkat lon loIeccuo apopakkat tuan. ");
INSERT INTO lmd_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Anakka kwokat nokathar akwopakkot tuan, aul iarekinok tuan okttat iaak llon itti ukul wang iocura wokkot cik. ");
INSERT INTO lmd_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Anakka kwipittothekin itti ukul wothakkat woporot acin, okin thiꞌrekathok itti, “Lü locoꞌrot nti iaak meccin icïngkï ippa.” ");
INSERT INTO lmd_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ittina aththan pokkul inakat itti caꞌri cen ica oIeccuo piꞌrethok itti, “Ukul wang wakkoik.” Ana menik ook ana ul woruan thanung occokat lon nomïkït loKapik. ");
INSERT INTO lmd_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Lon ilommaththik elli ileꞌra ila Ieccuo pokkothe akka kwaat noththok poIouthia akweo noththok poCelïl. ");
INSERT INTO lmd_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Nomaꞌri motteik oIeccuo pokuꞌrathe nokaꞌran koUruccelim nokamuthe koul woIouth. ");
INSERT INTO lmd_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ana ciki icarak coman conokaꞌran koUruccelim, kꞌral kokat iccik kokathat kolungkat konat kꞌran ngkarru koIpranin itti kꞌral koPeththictha ikokkwettathe ithoꞌrkït nucu ukuluk. ");
INSERT INTO lmd_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ul woppot wokakkat cik aïcaccat cik than ana anna ul than iongo ana iꞌrimathe ana iaimico akin oꞌrïllïkot ngꞌri iauro. ");
INSERT INTO lmd_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ana caꞌri cꞌrek uꞌrupa wothothïlettat woIli wokat cik than aꞌrïntïtto ngꞌri ana okkwi iporpot tit cittokït aiꞌri ngaꞌrïntïttakot kwittat nnomio ima kwonat. ");
INSERT INTO lmd_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Pul pꞌrek pokat cik than pongo luput arrial ana alkaire ana ikken mormor (38). ");
INSERT INTO lmd_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Anakka oIeccuo pimmarok akwïcat cik, akwinakat itti pul pen pokat cik ittina luput loppot akwipittat pul pen itti, “Ngkwongothe itti ngkwathakka poporori?” ");
INSERT INTO lmd_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Apul ipongo othïat tit itti, “Pul pella ipittarothin itti parpekin ikꞌral amma ngꞌri ngoꞌrïntïttakot ncik. Amma mpenekket itti mparpo ikꞌral anothïot opilin poththethe tokït kin.” ");
INSERT INTO lmd_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ittina aIeccuo iꞌrekathok itti, “Urokothe kapik, aneko aꞌrangkal wang aeo.” ");
INSERT INTO lmd_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Apul othakkakat poporot accokkot ana ponekathe aꞌrangkal ana poingkathe. Lon elli lokkattathe nocaꞌri caCcepith, ");
INSERT INTO lmd_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ana ul woIouth wiꞌrekathe pul ipothakkat poporot itti, “Caꞌri enci caCcepith ana lon lothonceꞌret lon cik lakannokorronnung itti ngkwaneko aꞌrangkal wang.” ");
INSERT INTO lmd_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Anaruk pul piꞌrekathe itti, “Pul ipothikkierin poporot piꞌrethin itti, ‘Oneki aꞌrangkal wang aeo.’” ");
INSERT INTO lmd_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Okin thipittathok itti, “Pul piatha pen ipiꞌrethung itti oneki aꞌrangkal wang aeo?” ");
INSERT INTO lmd_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Pul ipothakkat poporot pappommat kꞌran kwokkwi ipittiethok akka oIeccuo pappiꞌrikot icungkut coul icokat cik cïnang. ");
INSERT INTO lmd_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ana nomaꞌri motte oIeccuo paththiathok noppan toKapik akwiꞌrekathok itti, “Antoccïkot, katha ngkwothakkat poporot kirrnni appokkot lon lꞌrek ilokithak akka alꞌrek ainung ilokithak cannan.” ");
INSERT INTO lmd_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Pul poingkathe ana paththiꞌrekat ul woIouth itti, oIeccuo akkothikkierok poporot. ");
INSERT INTO lmd_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ittina ul woIouth wikkatheik akkiet oIeccuo thiak akka kwittiethe pul pen nocaꞌri caCcepith. ");
INSERT INTO lmd_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","OIeccuo piꞌrekathekin itti, “Ongappa paik pareko appinappin ana manna inenni ana oun cakuruk paik pareko.” ");
INSERT INTO lmd_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ana nti ilon elli ul woIouth wikkatheik akwancot kathar ikakin okkwothok ngngin, okorronno oka itti akka kwarrothe lon lacaꞌri caCcepith cik tulluk, anaruk akka kwokat cik akwakkaro Kapik itti oththan pung, ana akwarppithie ka kung ngKapik. ");
INSERT INTO lmd_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","OIeccuo pothïanthet kin tit itti, “Mpiꞌret non ilaik ïcat, ukul wakannokkot ngre nti ica cung pellek, wakkot ngre ia kwimmat oththan akwokkot, akka ngre ia aththan okkot ukul wakkot cakuruk. ");
INSERT INTO lmd_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Oththan pokkul pongothe ukul ana kwakenek lon ila akwokkot appik. Ana oththan pokkul pakene ukul manna aꞌrupu wïttïttïk nenni ia akwokkot nnothittiet pul empi. Ana onon thaprttakot tit ïcarïcat. ");
INSERT INTO lmd_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ana ammakka oththan purokie ul illet nti ithio ana ethet kin thikkoik, ana cakuruk ukul wethet okkwion thikkoik itha kwongothe itti kwethet. ");
INSERT INTO lmd_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ana icci oththan pokkul pakannakkma pul pꞌrek anaruk kwethet ukul lon lothakkma cik appik ikkun, ");
INSERT INTO lmd_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","othakka itti aul appik othiane ukul cik ammakka okin thothianet oththan cik. Okkwi ipakannothiane ukul cik kwakannothiane oththan cik ipothïothok. ");
INSERT INTO lmd_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Mpiꞌret non lon ilaik ïcat itti, okkwi ipaccïkot lon lin ana occokot lon nocïkït lokkwi ipothïothin kwikkoik thothupuththuput ana kwakannakkamako kwarrothe thio cik akweo nothikkoik. ");
INSERT INTO lmd_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Mpiꞌret non lon ilaik ïcat itti, caꞌri caik canthan ana manna cei caat amma okin ithillet occïkot poꞌre pokkul woKapik ana okkwion ithoccïkothe thakkoik. ");
INSERT INTO lmd_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ana inakka oththan pokkul akkonu puꞌran pothikkoik ika kung, kwethet ukul wung puꞌran pothikkoik cakuruk ika kung. ");
INSERT INTO lmd_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ana kwethok lon lothakkma ikkun akka ook ukul wopul iponyi. ");
INSERT INTO lmd_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Nokorronno oprttakot tit noꞌron elli akka caꞌri caik canthan caul appik iaik impu occïkot poꞌre pung ");
INSERT INTO lmd_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ana okin thappot thapat ana okkwion ithokkothe lon loporot thuroko akin oꞌrungkat cik, ana okkwion ithokkothe lokithak thuroko akin akkmakat. ");
INSERT INTO lmd_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Mpakannokkot lon lꞌrek ngka kin pellek, mpakkma ammakka anoccïkot aliꞌrettathin ana thakkma thin thocoꞌrotheik akka mpakannangkot itti mpapirie ka kin noka anaruk okkwi ipothïothin.” ");
INSERT INTO lmd_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Amma oun akkopri itti mperet lon lin ngka kin there thin thakannoka ïcat. ");
INSERT INTO lmd_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Opilin pꞌrek paik peret lon lin ana mpina itti theret lon lin ilon lang laik ïcat. ");
INSERT INTO lmd_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Onon thothïnthet oIuanna ul ana kwerenet kin lon ilaik ïcat. ");
INSERT INTO lmd_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Okonnoka itti mpongothe theret ithoul ionyi erethin ngngin anaruk mpiꞌret elli othakka itti annoꞌrettat. ");
INSERT INTO lmd_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","OIuanna pokat kꞌran kothik ikoccot akocciekat cik ana onon thopirakathe noka ngkꞌran kothik thung papotteik. ");
INSERT INTO lmd_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Anaruk mponu papꞌrek prïk iperethe nolon loIuanna. Akka ngre ia ngappa pethin itti mpamartto ana iampaik pakkot ngakene itti ongappa pothïothin. ");
INSERT INTO lmd_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ana ongappa ipothïothin perethe lon lin ngka kung. Onon thakannoccïkot poꞌre pung ana manna imma ka kung, ");
INSERT INTO lmd_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ana manna lon lung lella ianon akka onon thakannoccokot lon nomïkït lokkwi ipa kwothïothe. ");
INSERT INTO lmd_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Onon thakkakkarot natham noKapik kicce akka onon thiꞌre itti amma nthakkakkarot ana onon thiot thikkoik thothupuththuput. Natham nen neret lon lin, ");
INSERT INTO lmd_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ana icci onon thꞌrat ainin anniot thikkoik. ");
INSERT INTO lmd_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Mpakannangkot thopirie noka thoul ionyi ");
INSERT INTO lmd_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","anaruk mpina non. Mpina itti onon thella thongat thoKapik nomïkït mon. ");
INSERT INTO lmd_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Mpaat ngkꞌran kongappa ana onon thꞌrarin anaruk amma opilin paat ngkꞌran kung onon thangat lon lung. ");
INSERT INTO lmd_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Onon thaccokot lon nomïkït taththa amma onon thapirarne noka, anaruk onon thaik thannokwantot thopira noka ithaik thanthan nakkwi ipa Kapik tulluk? ");
INSERT INTO lmd_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Anaruk nokorronno iꞌre itti mparukwet non tokït kongappa. OMucca akkarukwet non, ook ipanon thonekkethe mïkït nan. ");
INSERT INTO lmd_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Amma onon thaththoccokothe lon loMucca nomïkït mon onon thaaccokothe alin akka ila kwokurrot kwerethin ngngin. ");
INSERT INTO lmd_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Anaruk onon thaccokot lon ila aniꞌret non taththa amma onon thakonnoccokot lon nomïkït ilokurrakot?” ");
INSERT INTO lmd_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ana nomaꞌri motte oIeccuo parrathe nocarkan cꞌrek corok irapangka toCelïl ironu kꞌran cakuruk itti tok irapangka toThipiria, ");
INSERT INTO lmd_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","ana ul woppot womakathok akka okin thimmat lon ilommaththik ila kwokkothe noul iongo. ");
INSERT INTO lmd_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","AIeccuo okuꞌrat noꞌra wocoꞌrong akwikkat cik okin oul iammakothok. ");
INSERT INTO lmd_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Kamuthe koul woIouth koThaurrot kaman kꞌrek cik kokat akokko napuththut. ");
INSERT INTO lmd_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Anakka oIeccuo pokathat cik akwimmakat ul woppot anthan naak, akwiꞌrekat oPilippic itti, “Oron thakerine ul enni thuꞌrit kartha akin oꞌrko?” ");
INSERT INTO lmd_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Kwipittot elli othakka itti akwenekkek anaruk kwappinat ila kwaik pathokkot. ");
INSERT INTO lmd_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","APilippic othïanthok tit itti, “Tat akka manna akucci iarekitta ngngin anok mormor wakannokero thuꞌrit thekko noul enni itti okkulukku pinot manna thoththe.” ");
INSERT INTO lmd_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Apilin nti iul iammakothok ipoccot kꞌran itti Anthrauc opang poCcamaan oPoththuruc iꞌrekat itti, ");
INSERT INTO lmd_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Ukul wꞌrek wei wonu arrakith ukuluk ana ape weꞌra, anaruk wekko noul taththa enni ioppot ittina?” ");
INSERT INTO lmd_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","AIeccuo iꞌrekat kin itti, “Nikkie ul cik.” Ana taco tokat cik toppot nokaꞌran ken ana ul wikkatheik nan, ul iomura wokat athar ukuluk (5,000). ");
INSERT INTO lmd_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","OIeccuo ponekathe arrakith akwopirakanthet Kapik noka, athikkettakat ul ikkiettat cik ammakka okin ipittot. Kwokkathe ammakka menik nape. ");
INSERT INTO lmd_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Anakka ul woꞌrkot cik mono oththakakat, kwiꞌrekathe ul iammakothok itti, “Naꞌrntot thuꞌrit ithokwentakot nan. Nokorronno okorronno itti thakïttakot cik thoththe.” ");
INSERT INTO lmd_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ittina okin thaꞌrntathe thuꞌrit ithokwentakot nan akin oppeppekat nyalünthüng attul ana ikken keꞌra narrakith iokat ukuluk ia ul ioꞌrkot nan wokwentako. ");
INSERT INTO lmd_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Anakka ul wimmat lon ilommaththik ila oIeccuo pokkothe, okin thikkatheik akin ere itti, “Ïcarïcat pul empi pothernte lon loKapik ipokat ponu itti panthan nocapu ncik appik.” ");
INSERT INTO lmd_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","AIeccuo inakat itti okin thaik thathothikkiek ili mpuꞌran akwoingkat tocoꞌrong ngka kung pellek. ");
INSERT INTO lmd_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Anakka cipin capot aul immakothok uat thorok irapangka, ");
INSERT INTO lmd_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","akin arrat ikuppuꞌrung konoiꞌri akin arrot tok irapangka eo nokaꞌran ikoccot kꞌran itti Kapprnaum. Anakka okin thokat cik akin eo, ittina ngïꞌrïmak ngokat ngoꞌrot cik ana oIeccuo papparthuk anthan nakin. ");
INSERT INTO lmd_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Akanang ikkat cik akokkurarot cannan ana ngꞌri ngikkatheik athapllarot ongkuꞌrot ciki ithiꞌrot thokapik. ");
INSERT INTO lmd_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Anakka okin tholliethe kuppuꞌrung konoiꞌri ipanan porok irapangka, akin immakat oIeccuo akwonyaro noꞌra woiꞌri akwanthan nakin ana okin thipathe nꞌre. ");
INSERT INTO lmd_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Anaruk kwiꞌrekathekin itti, “Oun ana nthakorronno opelle.” ");
INSERT INTO lmd_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Okin thokat thongothe itti okin tharriethok ikuppuꞌrung. Ana akka okin thokkothe ellrïk okin thaththiat itti okin thaat nokꞌran nakin thokat cik akin eo. ");
INSERT INTO lmd_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ana ngorrot ngen aul iokwentakot nokuthut korok inakat itti kuppuꞌrung kulukku kokat cik ceneket, ana oIeccuo pappakannarrot tit okin oul immakothok, anaruk weot thellek. ");
INSERT INTO lmd_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ana uppuꞌrung wonoiꞌri wꞌrek wakkakathe nokaꞌran koThipiria acoꞌrat iccik kokaꞌran na ul woꞌrkothe thuꞌrit itha oIeccuo popiranet Kapik noka nan. ");
INSERT INTO lmd_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Anakka ul waththiot itti oIeccuo ana ul immakothok wella ikuppuꞌrung konoiꞌri okin tharrathe iuppuꞌrung wen akin oingkat nokaꞌran koKapprnaum akin othokwantot oIeccuo. ");
INSERT INTO lmd_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Anakka okin thiothok nocarkan corok, okin thipittathok itti, “Pul ipangkene, ngkwaat cene acintha?” ");
INSERT INTO lmd_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","AIeccuo othïat tit itti, “Mpiꞌret non ilaik ïcat, onon thaik thakwancothin okorronno oka itti akka onon thimmat lon ilommaththik anaruk akka onon thoꞌrkot thuꞌrit ana onon thoththakathe. ");
INSERT INTO lmd_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Nokorronno orekine thuꞌrit ithakïttako anaruk norekine thuꞌrit ithikkoik thupuththuput itha ukul woKapik ethet non. Akka Kapik kethok lon len ikkun itti kwakkot.” ");
INSERT INTO lmd_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ana okin thipittathok itti, “Onïn thakkot taththa ïnokkot ngre inga Kapik kongothe?” ");
INSERT INTO lmd_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","AIeccuo omekat kin itti, “Ngre ngoKapik ngaik itti ngkwaccokot lon nocïkït lokkwi ipa kwothïothe.” ");
INSERT INTO lmd_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ittina akin ipittathok, itti, “Lon liatha ilakene ilommaththik ïnïmma ïnoccokot lon lang nomïkït? Ngintha akka akkot? ");
INSERT INTO lmd_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Thiki thïn thomaꞌrot thoꞌrkot thuꞌrit ithoccot kꞌran itti manna ithampang ithonthomat, ammakka lokurrakot itti, ‘Kwethet kin thuꞌrit ntothiꞌrot akin oꞌrko.’” ");
INSERT INTO lmd_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","OIeccuo piꞌrekathekin itti, “Mpiꞌret non lon ilaik ïcat, okorronno oka oMucca akkethet non thuꞌrit ntothiꞌrot anaruk ongappa pin akkethet non thuꞌrit ithaik ïcat ntothiꞌrot. ");
INSERT INTO lmd_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Akka thuꞌrit thoKapik thakkwi ipanthan ntothiꞌrot ana ethet capu ncik appik thikkoik thung.” ");
INSERT INTO lmd_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Akin iꞌrekat itti, “Pul ipangkene, nciki inenni ethet nïn thuꞌrit enthrïk.” ");
INSERT INTO lmd_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","AIeccuo iꞌrekat itti, “Oun thuꞌrit thothikkoik. Okkwi ipainin tï takorronno okkwothok ana okkwi ipoccokothe lon lin nocïkït cung pica pakorronno appokkwothok. ");
INSERT INTO lmd_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Anaruk ammakka mpiꞌrethenon itti, onon thimmarin ana icci onon thꞌrat occokot lon lin nomïkït mon. ");
INSERT INTO lmd_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Okkwion itha ongappa ethin thainin ana okkwi ipainin mpakannokïccek. ");
INSERT INTO lmd_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Akka mpakannanthan ntothiꞌrot itti mpathokkot lon ila mpongothe, anaruk itti anothokkot ilakkwi ipothïothin itti mpathokkot. ");
INSERT INTO lmd_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ana ilen elli ila okkwi ipothïothin pongothe itti mpakannuret opilin cik aththik nti iakkwion itha kwethin appik ana cakuruk itti anurokiekin nocaꞌri cothakkma. ");
INSERT INTO lmd_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Akka lon ila oNgappa pongothe itti okkwi ipainet ana occokot lon len nocïkït piot thikkoik thothupuththuput, ana mpurokiek nti ithio nocaꞌri cothakkamako.” ");
INSERT INTO lmd_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ul woIouth wikkatheik aerekot noꞌron ila kwiꞌret itti, “Oun thuꞌrit ithaat ntothiꞌrot.” ");
INSERT INTO lmd_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Okin thiꞌrekathe itti, “Okonnoka oIeccuo empi, ukul woIuccip ana onnan paron thinai? Taththa akka akwiꞌre itti, ‘Mpaat ntothiꞌrot’?” ");
INSERT INTO lmd_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","AIeccuo othïat tit itti, “Nokorronno erekot. ");
INSERT INTO lmd_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Pul pella ipainin amma ongappa ipothïothin pakannonakok, ana mpurokiek nti ithio nocaꞌri cothakkamako. ");
INSERT INTO lmd_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Lokurrakot inatham noul wothernte lon loKapik itti, ‘Okin appik thaKapik ongkene.’ Ana okkwi ipaccïkot lon longappa ana ina lon naak painin. ");
INSERT INTO lmd_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Pul pella ipimmat Kapik anaruk okkwi ipaat noKapik, ook pulluk akkimmat oththan. ");
INSERT INTO lmd_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Mpiꞌret non lon ilaik ïcat okkwi ipaccokot lon nocïkït pikkoik thupuththuput. ");
INSERT INTO lmd_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Oun thuꞌrit thothikkoik. ");
INSERT INTO lmd_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Thiki thon thoꞌrkot thuꞌrit ithoccot kꞌran itti mannaa ithampang ithonthomat, ana icci okin thillet akka mannaa mokat makannoka thuꞌrit thothikkoik. ");
INSERT INTO lmd_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Anaruk thuꞌrit thei ithaat ntothiꞌrot itha pul oꞌrko ana pakannio. ");
INSERT INTO lmd_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Oun arrakith wothikkoik iaat ntothiꞌrot. Ana okkwi ipaꞌrko narrakith enni kwakkoik thupuththuput. Arrakith enni waka kin ikanethet thikkoik thoul wonocapu ncik appik.” ");
INSERT INTO lmd_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ittina aul woIouth ikkat cik aꞌrettakot cannan aiꞌre itti, “Pul empi pethet ton ka kung aron oꞌrko taththa?” ");
INSERT INTO lmd_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","AIeccuo iꞌrekat kin itti “Mpiꞌret non lon ilaik ïcat amma ngkwakannoꞌrko ka kokkul wopul iponyi ana ïkko ngüccük, ngkwella thikkoik. ");
INSERT INTO lmd_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Anaruk okkwi ipaꞌrko ka kin ana ïkko ngüccük ngin kwonu thikkoik thothupuththuput ana mpurokiek nocaꞌri cothakkamako. ");
INSERT INTO lmd_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Akka ka kin ana ngüccük ngin thathuꞌrit ïcarïcat. ");
INSERT INTO lmd_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Okkwi ipaꞌrko ka kin ana ïkko ngüccük ngin kwaꞌrungkot iaun ana mpaꞌrungkot iaak. ");
INSERT INTO lmd_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ana ammakka ongappa ipaik pothïothin ana mpaik akka kwaik, ittina okkwi ipaꞌrko ka kin kwakkoik nti iaun. ");
INSERT INTO lmd_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Thuꞌrit enthi ithaat ntothiꞌrot. Thiki thon thoꞌrkot thuꞌrit thomannaa ana okin thillet anaruk okkwi ipaꞌrko nothuꞌrit enthi kwakkoik thupuththuput.” ");
INSERT INTO lmd_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Kwiꞌret lon elli akkwokat cik akwongkene nocuththun caꞌrama nokaꞌran koKapprnaum. ");
INSERT INTO lmd_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Anakka ul woppot nti iul iammakothok woccïkothe thongkene enthi aiꞌrekat itti, “Thongkene enthi thonthomat cannan. Oththa akkangkot?” ");
INSERT INTO lmd_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","AIeccuo inakat nan itti ul iammakothok wokat cik aꞌrettakinthet thongkene then akwiꞌrekat kin itti, “Alin elli luethenon ka ciki? ");
INSERT INTO lmd_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Laka taththa nanon amma annimma ukul wopul iponyi akuꞌrot tothiꞌrot, aeo na wokat ncinnan? ");
INSERT INTO lmd_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Kanang koKapik keettot thikkoik, ka kella lon cik, lon ila mperenet non lakanang kathikkoik. ");
INSERT INTO lmd_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ana icci opilingon thꞌrek thaik ianon thakonnoccokot lon nomïkït men.” Akka oIeccuo pinat nan ncimaꞌrot okkwion ithakannoccokot lon nocïkït ana okkwi ipathokerok. ");
INSERT INTO lmd_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Kwoꞌrungkathe nan akwere itti, “Ilen elli akka mpiꞌrenthet non itti pul pella painin amma ongappa pannethin ngok.” ");
INSERT INTO lmd_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Nci nocaꞌri enci ul iammakothok woppot wocottakathe nti iaak ana wꞌrakathe ommakothok. ");
INSERT INTO lmd_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","AIeccuo ipittat kin ithattul ana ikken keꞌra itti, “Onon thongothe itti onon thaeo cakuruki, okorronno oka meniki?” ");
INSERT INTO lmd_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","ACcamaan oPoththuruc othïanthok tit itti, “Ili, onïn thaine oththa? Akka oung akkonu lon lothikkoik lothupuththuput. ");
INSERT INTO lmd_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Onïn thoccokothe lon nomïkït ana onïn thina itti oung ipupure poKapik.” ");
INSERT INTO lmd_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","AIeccuo othïat tit itti, “Oun akkakannakkaronon ithattul ana ikken keꞌrai? Ana icci okkulukku ntianon pothakkat pul pothopulut.” ");
INSERT INTO lmd_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Kwokat akweret oIoutha ukul woCcaman coIcikkariuththi, okkwi ipokat ntiakin ithattul ana ikken keꞌra, anaruk nomaꞌri mꞌrek ook ipathokerok. ");
INSERT INTO lmd_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Anakka elli lomttathe aIeccuo oingkat naꞌran koCelïl othakka itti akwoka ciththan nnoththok poIouthia akka ul woIouth wokat cik aꞌrïkothok itti wakkwothok. ");
INSERT INTO lmd_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Anaruk akka caꞌri cokamuthe koMüꞌrük koul woIouth kokat akokko napuththut, ");
INSERT INTO lmd_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","apangon thoIeccuo iꞌrekathok itti, “Ngkwonu itti ngkwaththe nokaꞌran engki aeo noththok poIouthia othakka itti aul iammakothung imma lon ilommaththik ilakkot. ");
INSERT INTO lmd_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Pul pella ipongothe itti pathakka pul iprïk tokït koul ana aporeko nthuꞌran. Ana inakka ngkwaik pakkot lon ammakka elli, okene ul ka kang nocapu ncik appik.” ");
INSERT INTO lmd_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Opangon manna thaththakannoccokot lon lung nomïkït men. ");
INSERT INTO lmd_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ittina aIeccuo iꞌrekat kin itti, “Caꞌri cin icekkot nan carthuk anthan anaruk nanon maꞌri mekkot nan appik nuthuk. ");
INSERT INTO lmd_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Capu ncik appik cakannꞌranon anaruk cꞌrarin akka mperethe lon ila ul waik wakkot nocapu lokithak. ");
INSERT INTO lmd_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ngkonon nokamuthe. Mparthuk paik pakanneo nokamuthe akka naun caꞌri cin icekkot nan carthuk anthan.” ");
INSERT INTO lmd_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Anakka kwiꞌrethekin lon elli akwikkat cik noththok poCelïl. ");
INSERT INTO lmd_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Anakka opangon theot nokamuthe, oIeccuo poingkathe nokamuthe cakuruk nthuꞌran. ");
INSERT INTO lmd_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Nocaꞌri cokamuthe ul woIouth wokat cik akwancathok aipitto itti, “Pul empꞌre paik kartha?” ");
INSERT INTO lmd_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ul wokat cik aerethok, opilingon thokat akin iꞌre itti “Ook pul ipoporot.” Opilingon thothïatherit itti, “Aa, kwammikkot ul.” ");
INSERT INTO lmd_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Anaruk pul pellat ipiꞌrethe lon tokït koul mpoꞌre cittan akka okin thokat akin opellene ul woIouth ionu lon ikkun. ");
INSERT INTO lmd_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Anakka kamuthe kokat ere kamattat pꞌrin aIeccuo iꞌrikat ithꞌrapak thonoppan toKapik akwikkat cik akwongkene. ");
INSERT INTO lmd_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ul woIouth woprttakatherit aikkat cik aipitto itti, “Pul empi piothe thinaik enthi kartha appakannongkenetta?” ");
INSERT INTO lmd_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","AIeccuo othïat tit itti, “Thongkene thin thakannoka thin thaat nakkwi ipothïothin. ");
INSERT INTO lmd_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Amma okkwi ipongothe itti kwakkot lon ila Kapik kongothe, kwina itti thongkene enthi thaat noKapik ana manna okkorronno oka naun ana noun. ");
INSERT INTO lmd_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Okkwi iperet lon loka kung, kwaik pakwantinthet ka kung thothiakine cik, anaruk okkwi iparekine thoporot thokkwi ipothïothok, lon lung locoꞌrotheik lella karrarit. ");
INSERT INTO lmd_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","OMucca pakannethet non lon lothonceꞌret lon ciki? Ana icci pul pella nti ianon ipoccokothe itti kwareko ngngin, ngintha akka onon thonganthet itti nthakkwinthin?” ");
INSERT INTO lmd_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Aul omekathok itti, “Ngkwonu uꞌrupa iokithak, oththa akkongothe itti kwakkwothung?” ");
INSERT INTO lmd_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","AIeccuo iꞌrekat kin itti, “Mpokkothe lon lulukku ilommaththik ana onon thoprttakatherit appik. ");
INSERT INTO lmd_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Icci oMucca ponanet non lon lothokekkot ana antoka manna itti ook akkakannona anaruk thiki thon ana onon thokekkiethe nyukul nyon nocaꞌri caCcepith. ");
INSERT INTO lmd_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Inenni amma ul wonu itti wakekkiettat nocaꞌri caCcepith othakka itti alon lothonceꞌret lon cik loMucca anguttat onon thontha akka annua ka kin nothothikkie pul poporot nocaꞌri caCcepith? ");
INSERT INTO lmd_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Nokorronno akkma pul ipa nthimmat tulluk, nakkma pul llon ilaik ïcat ana locoꞌrotheik.” ");
INSERT INTO lmd_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ana nolon len ul wꞌrek wonokaꞌran koUruccelim wikkatheik aipitto itti, “Okoronnoka pul empi ipakin thaik thakwancot itti okin thakkwori? ");
INSERT INTO lmd_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Kwaik pere ncinokkït ana okin thaik thakanniꞌrethok lon lꞌrek. Nili nina nan ïcat itti ook oMicciei? ");
INSERT INTO lmd_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Anaruk onïn thina itti pul empi pokeren, akka amma oMiccie anthan pul pella pina itti ook pokeren.” ");
INSERT INTO lmd_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ittina oIeccuo pikkatheik akwongkene icci noppan toKapik akwiꞌrekat itti, “Ïï onon thinan ana onon thina itti oun pokeren. Mpakannoka cene akka mpongothe itti mpaka cene ngka kin anaruk okkwi ipothïothin paik ïcat ana onon thommak ");
INSERT INTO lmd_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","anaruk mpinak akka mpaat naak ana kwothïothin.” ");
INSERT INTO lmd_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ittina akin enekkekat itti okin thaccokothok, anaruk pul pellat iponekkethe ukun naak akka caꞌri cung cokat carthuk. ");
INSERT INTO lmd_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ana icci ul wokat cik woppot ioccokothe lon lung nomïkït men ana wiꞌrekathe itti, “Amma oMiccie akkaat kwakkot lon ilommaththik loppot nnopul empii?” ");
INSERT INTO lmd_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Aul woPriccin occïkat aul erethok llon elli. Ittina ul ittïttïk woul wonoppan toKapik ana ul woPriccin othïat ul iangwot tupan toKapik athoccokothok. ");
INSERT INTO lmd_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","OIeccuo piꞌrekathe itti, “Oron thakaik oron aththut maꞌri motte ana mpaine okkwi ipothïothin. ");
INSERT INTO lmd_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Onon thakwariccathin anaruk onon thakanniothin ana na mpaik onon thakannanthan.” ");
INSERT INTO lmd_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Aul woIouth erettaranthet itti, “Pul empi pongothe itti paeo kartha othakka itti aron okorronno iothok? Kwaeo na ul wonnon iopettakotheik iul iakannoka ul woIouthi akwothongkene ul iakannoka woIouthi? ");
INSERT INTO lmd_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Kwappongothe itti kwiꞌre itti kaththa akka kwiꞌret itti, ‘Onon thakwariccathin ana onon thakanniothin’ ana ‘Na mpaik onon thakannanthan’?” ");
INSERT INTO lmd_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ana nocaꞌri icïrïk ica kamuthe kocothakothe nan, oIeccuo purokathe akwiꞌrekat lon mpoꞌre cittan itti, “Okkwi ipa pica paik pakkwot akwainin akwathïkko ngꞌri. ");
INSERT INTO lmd_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Okkwi ipoccokothe lon lin nocïkït cung nue noiꞌri ngothikkoik nallo nti iaak ammakka atham wiꞌret.” ");
INSERT INTO lmd_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Kwokat cik akweret Kanang koKapik ikakin athocco ithoccokothe lon lung nomïkït. Kanang koKapik kokat karthuk ettat kin akka oIeccuo pokat parthuk pakannothikkietta prïk. ");
INSERT INTO lmd_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Anakka ul woccïkothe lon lung, wꞌrek wiꞌrekathe itti, “Ïcat pul empi papul pothernte lon loKapik.” ");
INSERT INTO lmd_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Aꞌrek iꞌrekat itti, “Ook oMiccie.” Ana icci apilingon ipittat itti, “OMiccie panthan noththok poCelïl taththa? ");
INSERT INTO lmd_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Atham wakinniꞌre itti oMiccie panthan noul woThauthi ana nokaꞌran koPeththelami na Thauth pikkot ciki?” ");
INSERT INTO lmd_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ul willillakatherit nti ilon loIeccuo ");
INSERT INTO lmd_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","opilingon thokat thongothe itti okin thaccokothok anaruk pul pellat iponekkethe ukun naak. ");
INSERT INTO lmd_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ul iangwot tupan toKapik wopakkanthet ul ittïttïk woul wonoppan toKapik ana ul woPriccin ithipittothekin itti, “Onon thontha akka onon thakannonakok cene?” ");
INSERT INTO lmd_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Aul iangwot cik iꞌrekat itti, “Pul pella iperet kirrkkir ammakka pul empi ere.” ");
INSERT INTO lmd_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Aul woPriccin othïat tit itti, “Kwammikkothenon cakuruki?” ");
INSERT INTO lmd_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Onon thimmat itti opilin nti inili ana manna ul woPriccin poccokothe lon lung nocïkïri? ");
INSERT INTO lmd_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Aa, pul pella anaruk ul enni wattattakot akka womma lon lothonceꞌret lon cik loMucca. ");
INSERT INTO lmd_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","ONikkothemoc ipokat poinet oIeccuo ana ipokat poul woPriccin pipittot itti, ");
INSERT INTO lmd_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Lon lothonceꞌret lon cik lakkma pul kappaki apparthuk inako lon lung ila kwokkothei?” ");
INSERT INTO lmd_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Okin thothïanthok tit itti, “Ngkwonoththok poCelïl cakuruki? Okatha iatham ana ngkwathiot itti pul pothernte lon loKapik pella panthan noththok poCelïl.” ");
INSERT INTO lmd_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ittina okin thopettakatheik kurekkurek oince ikaman ken. ");
INSERT INTO lmd_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Anaruk oIeccuo poingkathe nocoꞌrong coCeththun. ");
INSERT INTO lmd_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ana ngïꞌrïmak ngorrot ngen kwappropakkat noppan toKapik ana ul appik wakkakanthok akwikkat cik ithoꞌrkït then ana kwikkatheik akwongkenekin. ");
INSERT INTO lmd_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Aul iangkene lon lothonceꞌret lon cik ana ul woPriccin onakat pul ipopari noppan poccokittathe mpul ipocura akin aꞌro ana okin thoceꞌrekathe pul ipopari tokït koIeccuo ana tokït koul. ");
INSERT INTO lmd_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Akin iꞌrekat oIeccuo itti, “Pul ipangkene, pul ipopari empi poccokittathe apaꞌro mpul ipocura. ");
INSERT INTO lmd_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Lon lothonceꞌret lon cik loMucca liꞌret itti pul ammakka empi pakincakot cik mmothok, ngkwiꞌre taththa?” ");
INSERT INTO lmd_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Okin thokat akin ipittot oIeccuo lon elli othakka itti akin ïꞌrak ana akin iot kathar ikakin orukwethok ngngin. Anaruk oIeccuo pocukkwatheik nocapu akwikkat cik akwakurroik nocapu ncaun. ");
INSERT INTO lmd_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Anakka okin thokat cik akin ommiek nthipitto lon, kwocoꞌrathe kapik akwiꞌrekat kin itti, “Amma opilin ntianon pella lon cik ilokithak akwoꞌro pul ipopari empi cittokït mpothok.” ");
INSERT INTO lmd_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Akwappocukkwat cik attang akwokurro nocapu. ");
INSERT INTO lmd_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ana okkwion ithoccïkothe lon ila oIeccuo piꞌret okin thoincekathe thuluththuluk, ul iukkwat cottokït apilingon antomakot puccuk mono aIeccuo okwentakat pellek okin opul ipopari pen apocoꞌro cïnang. ");
INSERT INTO lmd_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","OIeccuo pocoꞌrathe kapik ana kwiꞌrekathe pul ipopari itti, “Okin thartha? Pella ipakkmarungi?” ");
INSERT INTO lmd_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Apul ipopari othïat tit itti, “Aa pul pella, pït pin.” AIeccuo iꞌrekathok itti, “Mpakannakkmang ngko apaꞌrine thikkoik ithokithak cik.” ");
INSERT INTO lmd_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ana oIeccuo pappererekanthet ul attang akwiꞌrekat kin itti, “Oun kꞌran ikimmie capu cik appik. Okkwi ipamakothin kwakannonyaro iꞌrïmak ana kwana kꞌran ikimmie cik kothikkoik.” ");
INSERT INTO lmd_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Aul woPriccin iꞌrekathok itti, “Ngkwaik peret thoka kang ana theret thoka kang enthrïk thakannoka ïcat.” ");
INSERT INTO lmd_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","AIeccuo othïat tit itti, “Antoka manna itti mpaik peret thoka kin ana ila mpaik peret ka kin ngngin laik ïcat akka mpina na mpaat ngngin ana na mpaik paeo. Anaruk onon thomma na mpaat ngngin ana na mpaik paeo. ");
INSERT INTO lmd_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Onon thakkma ul ngkathar ikaul ionyi akkma ngngin anaruk mpakannakkma ul. ");
INSERT INTO lmd_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Anaruk amma mpakkma, thakkma thin thocoꞌrotheik akka mpakannoka prek nore engi, onïn thaik ïnongappa okkwi ipothïothin. ");
INSERT INTO lmd_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ilon lothonceꞌret lon cik lon lokurrakot itti amma ul weꞌra werethe nolon ana theret then thaka ïcat. ");
INSERT INTO lmd_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Mperet nolon loka kin pellek, pul pꞌrek iperet nolon loka kin ook ongappa okkwi ipothïothin.” ");
INSERT INTO lmd_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ittina akin ipittathok itti, “Oththe paik kartha?” AIeccuo othïanthet kin tit itti, “Onon thomman ana manna ongappa, amma onon thaththinan, onon thainat ongappa cakuruk.” ");
INSERT INTO lmd_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Kweret lon elli akka kwokat cik akwongkene noppan toKapik iccik kokaꞌran kothaꞌrntot akucci iaꞌrntakinthet ngre ngonoppan toKapik. Pul pellat ipaꞌrumothok itti paccokothok akka caꞌri cung cokat carthuk. ");
INSERT INTO lmd_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","AIeccuo appiꞌrekat kin attang itti, “Mpaik paeo ana onon thakwariccathin, ana onon thillet ilon lon ilokithak. Ana na aneo onon thakannao nokaꞌran ken.” ");
INSERT INTO lmd_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Elli lokorronnathe ul woIouth aipitto itti, “Kwakkwot ka kungi? Ilen akka akwiꞌrene itti, na aneo, onon thakannao nokaꞌran keni?” ");
INSERT INTO lmd_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Anaruk kwoꞌrungkathe nolon akwiꞌre itti, “Onon thonocapu thaiken ana oun porothiꞌrot. Onon thonocapu enci. Anaruk mpakannoka ponocapu enci. ");
INSERT INTO lmd_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Mpiꞌrethenon itti onon thillet ilon lon ilokithak amma onon thakannoccokot lon nomïkït itti oun okkwi ipa mpaik piꞌre itti oun, onon thillet ilon lon ilokithak kirrkkir.” ");
INSERT INTO lmd_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Okin thipittathok itti, “Oung oththa?” AIeccuo othïanthet kin itti, “Oun pul ipa mpiꞌrethenon nci nomun itti mpaka. ");
INSERT INTO lmd_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mponu loppot ila anerenenon nothakkma non. Anaruk okkwi ipothïothin akkiꞌre lon ilaik ïcat ana ila mpoccïkothe naak mperene ul nocapu ncik appik.” ");
INSERT INTO lmd_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Okin thaththakannina itti kwokat cik akwerenthet kin oththan pung. ");
INSERT INTO lmd_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ittina aIeccuo iꞌrekat kin itti, “Caꞌri icanon okkwot ukul wopul iponyi mono onthot nothapak, onon thina itti oun okkwi ipa aniꞌre itti oun ana mpakannokkot lon lꞌrek pellek anaruk mpaik pere tulluk ila ongappa pongkenerin. ");
INSERT INTO lmd_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Okkwi ipothïothin paik naun, kwakorronno okorronnonon thellek, akka mpakkettet lon ilapiriek noka appinappin.” ");
INSERT INTO lmd_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Anakka kweret lon elli, ul woppot woccokathe lon lung nomïkït. ");
INSERT INTO lmd_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","AIeccuo iꞌrekat ul woIouth ioccokothe lon lung nomïkït itti, “Amma onon thoꞌrungkwothe ithongkene thin, onon thaka ul ïcarïcat iammakothin. ");
INSERT INTO lmd_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ana onon thina lon ilaik ïcat ana lon ilaik ïcat lelikko non nti ilon ilokithak.” ");
INSERT INTO lmd_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Okin thothïanthet oIeccuo tit itti, “Onïn thathiki thAprein ana onïn thokat thakorronno oka iak wopilin. Ana tat akka aiꞌre itti onïn thelikkako?” ");
INSERT INTO lmd_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","AIeccuo othïanthet kin tit itti, “Mpiꞌret non ilaik ïcat itti okkwi ipakkot lon ilokithak kwapiak polon ilokithak. ");
INSERT INTO lmd_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Iak wonu kaꞌran cik ikuꞌri okorronno oka kothupuththuput, anaruk ukul wonu aꞌran cik ikuꞌri wothupuththuput. ");
INSERT INTO lmd_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ittina amma ukul woKapik welikkot non ana onon thelikkako kirrkkir. ");
INSERT INTO lmd_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Mpina itti onon thathiki thAprein, anaruk onon thaik thakwantot kathar ikanon okkwothin ngngin akka lon lin lella kaꞌran nomïkït mon. ");
INSERT INTO lmd_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Mpaik perenenon lon ila ongappa pokenerin ana onon thakkot ilanon thoccïkothe naththen.” ");
INSERT INTO lmd_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Akin othïat tit itti, “Ongappa pïn Aprein.” AIeccuo iꞌrekat kin itti, “Amma onon akkakkokat nyukul nyAprein, onon thaakkothe lon ammakka Aprein pokkothe. ");
INSERT INTO lmd_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ammakka lon laik onon thongothe itti nthakkwothin, pul iperenet non lon ilaik ïcat ila mpoccïkothe noKapik. Aprein pakannokkot lon ammakka lon elli. ");
INSERT INTO lmd_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Onon thaik thakkot lon ila oththen thokkettethe.” Akin othïanthok tit itti, “Onïn thakorronno oka nyukul nyorittak, ongappa pïn pulukku ook Kapik ngka kung.” ");
INSERT INTO lmd_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","OIeccuo piꞌrekathekin itti, “Amma Kapik kokat oththe pon, onon thira thangathin akka mpaat noKapik ana mpei cene. Mpakannao ngkathar kin, anaruk kwothïothin. ");
INSERT INTO lmd_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ngintha akka onon thommanet occïkïnthet lon lin ila mpaik pere? Laik ittina akka onon thakorronno okkwine lon lin kunu ncik. ");
INSERT INTO lmd_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Oththe pon pul pothopulut ana nthongothe itti onon thamakot lon ila oththe pon pongothe. Kwokat pul ipangutte ul ncimaꞌrot ana kwonat karra ana kwappokat pꞌrat lon ilaik ïcat akka kwellat lon ilaik ïcat nocïkït. Amma akwammikkot, kwere lon lulluk loka kung ana ook pokarra ana ook oththan poul iere karra appik. ");
INSERT INTO lmd_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Anaruk akka mperenenon lon ilaik ïcat ana ilen akka onon thꞌrat occokinthet lon lin ila mpaik pere. ");
INSERT INTO lmd_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Oththa ntianon akkakenen itti mponu lon lokithak? Amma mpaik perenenon lon ilaik ïcat, ngintha akka annokorronno occokinthet lon nomïkït? ");
INSERT INTO lmd_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Okkwi iponu oththan paKapik kwaccïkot lon ila Kapik iꞌre. Lon ilakorronnonon annokorronno occïkïnthet lon lin itti akka onon thakannoka thoKapik.” ");
INSERT INTO lmd_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Aul woIouth iꞌrekat oIeccuo itti, “Lon lïn lakannoka ïcat itti ngkwonoul woCcamirin ana ngkwannoka pïn ana ngkwonu uꞌrupa iokithaki?” ");
INSERT INTO lmd_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","AIeccuo iꞌrekat kin itti, “Mpella uꞌrupa iokithak anaruk mpothianet ongappa cik ana onon thakorrnno othianok cik. ");
INSERT INTO lmd_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Mpaik pakorronno okwantinthet ka kin thrïk anaruk opilin paik pakwantinthet ana ook okkwi ipa athakkma. ");
INSERT INTO lmd_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Mpiꞌret non ilaik ïcat itti okkwi ipoꞌrumot nolon lin, kwakannio aththik.” ");
INSERT INTO lmd_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Menik aul woIouth iꞌrekat itti, “Onïn thantrina pꞌrïn itti ngkwonu uꞌrupa iokithak. Aprein piot ana ul wothernte lon loKapik willet cakuruk. Ana tat akka aiꞌre itti pul ipaccïkot lon lang pannio aththik? ");
INSERT INTO lmd_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Oung akkrïk nangappa pïn Apreini? Kwiot ana ul wothernte lon loKapik cakuruk willet. Ngkwaik pame itti oung oththa?” ");
INSERT INTO lmd_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","AIeccuo iꞌrekat kin itti, “Amma mpaik pathikkie ka kin prïk, lon len lella lon cik. Ongappa ipanon thaik thiꞌre itti ook oththe pon ook ipathikkien prïk. ");
INSERT INTO lmd_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Onon thommak anaruk mpinak. Ana amma mpiꞌret itti mpommak, mpaka ponu karra karkkon anaruk mpinak ana mpoꞌrumot nolon lung. ");
INSERT INTO lmd_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Oththe pon Aprein popirakathe noka akka nothokwarttikot caꞌri cothao thin akka kwimmat akwopirakat noka. Kwimmakathe maꞌri mothanthan min ana kwopirakathe noka.” ");
INSERT INTO lmd_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Aul woIouth iꞌrekathok itti, “Ngkwarthuk manna okkot luput arrial weꞌra ana alkaire (50), ana ngkwiꞌre itti ngkwimmat Aprein taththa?” ");
INSERT INTO lmd_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","AIeccuo othïanthet kin tit itti, “Mpiꞌret non ilaik ïcat, mpokat cik Aprein parthuk akwonta.” ");
INSERT INTO lmd_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Menik aul ocumat mothok itti wakincok, anaruk kurakathekin akwopaꞌrat cik noppan toKapik. ");
INSERT INTO lmd_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Anakka oIeccuo pokat cik nokathar, kwimmakathe pul piꞌrimathe ammakka pokwontat nti icarak connan. ");
INSERT INTO lmd_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Aul iammakothok ipittathok itti, “Pul ipangkene, oththa akkokkothe lon ilokithak mono apul empi okwontakanthet piꞌrimathe? Ooki ana amma okorronno oka ook oththangoni?” ");
INSERT INTO lmd_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","AIeccuo othïanthet kin tit itti, “Okorronno oka oththangon ana manna okorronno oka pul pen akkokkothe lon lokithak, anaruk elli lothakkat ittina othakka itti angre ngoKapik immakot ithikkoik thung. ");
INSERT INTO lmd_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Inakka cïngkï carthuk orungko, oron thonu itti oron thakkot ngre ngokkwi ipothïothin. Ngkoꞌra ngaik ngao ana pul pella ipareko ingkoꞌra. ");
INSERT INTO lmd_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ana inakka mpaik nocapu, oun kꞌran ikaccie cik nocapu appik.” ");
INSERT INTO lmd_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Manakka oIeccuo piꞌret lon elli, kwothukkwathe nguk nocapu ana kwoukkwathe nonunthu ana kwothathe pul ipiꞌrimathe ikït. ");
INSERT INTO lmd_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Kwiꞌrekathe pul pen itti, “Ngko, athilakko ikït ikꞌral ikoccot kꞌran itti Ciluam” (ilonu itti 'thothïot'). Ana pul poingkathe ana paththilakkat ana pakkakathe tuan appimmat cik. ");
INSERT INTO lmd_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ul wonocürük cung ana okkwion ithokat akin okathacceccek akka akwipittittot ul aꞌrupu, wikkatheik aprttakot tit ana aipittarot itti, “Annoka pul empi ipokat cik apipittitto aꞌrupu ikathari?” ");
INSERT INTO lmd_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ul wꞌrek wiꞌrekathe itti ook pul pen ipokat ipiꞌrimathe. Ana aꞌrek iꞌre itti, “Okorronno oka ook kungkworok nuthuk.” Anaruk kwiꞌrekathe ul itti, “Oun ipokat piꞌrimathe.” ");
INSERT INTO lmd_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Okin thipittathok itti, “Ngkwimmat cik taththa?” ");
INSERT INTO lmd_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Kwothïanthet kin tit itti, “Pul pꞌrek poccot kꞌran itti oIeccuo poukkwot ngacok ana kwothathin ikït. Ana kwiꞌrekathin itti ngko athilakko toca ikꞌral koCiluam. Ana mpoingkathe ana mpaththilakkat toca ana mpimakatheik.” ");
INSERT INTO lmd_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ana okin thipittathok itti, “Pul pen paik kartha?” Ana kwiꞌrekathekin itti, “Mpomma na kwaik.” ");
INSERT INTO lmd_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Okin thonakanthet ul woPriccin pul ipokat piꞌrimathe. ");
INSERT INTO lmd_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Caꞌri ica oIeccuo poukkwot nunthu nan ana anyinthet pul ipokat piꞌrimathe kït cokat caCcepith. ");
INSERT INTO lmd_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ana ul woPriccin wipittathok cakuruk itti kwimmat cik tat, ana pul ipokat piꞌrimathe pothïanthet kin tit itti, “Kwothothin ngacok ikït ana mpaththilakkat ana mpimmakatheik ina.” ");
INSERT INTO lmd_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Aul wꞌrek woPriccin iꞌrekat itti, “Pul empi paKapik akkakorronno othïot akka pakorronno oꞌrumo nolon lothonceꞌret lon cik locaꞌri caCcepith.” Anaruk aꞌrek wiꞌrekathe itti, “Pul polon ilokithak pakkot lon elli ilommaththik taththa?” Ittina okin onakathe lon leꞌrarit. ");
INSERT INTO lmd_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ittina pꞌrïn akin appopakkanthet pul ipokat piꞌrimathe akin ipittathok itti, “Ngkwiꞌre itti oththa akka akkanyinthung kït? Kït kang akka kwanyothe.” Apul othïanthet kin tit itti, “Ook pul pothernte lon loKapik.” ");
INSERT INTO lmd_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Anaruk ul ittïttïk woIouth wokat wꞌrat angkot lon itti pul empi pokat piꞌrimathe ana pimmat cik akin akkaro oththan ana onnan kappak. ");
INSERT INTO lmd_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Akka oththan ana onnan thaat akin ipittat kin itti, “Ukul won enni? Ien enni ianon thiꞌret itti wokwontat wiꞌrimathei? Ana tat akka wei wimmat cik inenni?” ");
INSERT INTO lmd_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Aththan ana onnan popul ipiꞌrimathe othïanthet kin tit itti, “Onïn thina itti ook ukul wïn ana wokwontat wiꞌrimathe. ");
INSERT INTO lmd_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Anaruk onïn thomma tat akka kwimmat cik, ana manna onïn thomma okkwi ipimmierok cik, nipittothok, kwocokkat ana kwina ere lon loka kung.” ");
INSERT INTO lmd_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Oththangon thaththiꞌret lon elli akka okin thokat cik akin opellene ul woIouth akka wonekkethe lon cik itti okkwi ipiꞌret itti oIeccuo ook oMiccie kwapaꞌrettaik nocuththun caꞌrama. ");
INSERT INTO lmd_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ana ilen akka oththangon thiꞌrenet itti, “Kwocokkat nipittothok.” ");
INSERT INTO lmd_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Aul ittïttïk woIouth appakkarat pul pen ipiꞌrimathe akin iꞌrekathok itti, “Iꞌrethenïn tokït koKapik ikrïk itti ngkwiꞌre lon ilaik ïcat. Akka onïn thina itti pul ipimmierung cik polon ilokithak.” ");
INSERT INTO lmd_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Apul othïat tit itti, “Mpomma amma ook polon ilokithak ana manna itti kwannoka polon ilokithak, lulukku ila mpina tulluk itti mpokat piꞌrimathe anaruk inenni mpimmat cik.” ");
INSERT INTO lmd_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Aul ittïttïk woIouth ipittathok itti, “Ngintha akka kwokkinthung? Ana tat akka kwimmierung cik?” ");
INSERT INTO lmd_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Akwothïanthet kin tit itti, “Mpiꞌrethenon ntit akkumman ana onon thꞌrat occïkot. Ngintha akka annappipittine itti nthappoccïkot? Nthongothe itti onon thathakka ul iammakothok cakuruki?” ");
INSERT INTO lmd_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ana ul woIouth wocungkwathok ana wiꞌrekathe itti, “Oung pul pung ipamakothok, anaruk onïn thaul iammakot oMucca. ");
INSERT INTO lmd_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Onïn thina kicce itti Kapik kerenet oMucca, anaruk onïn thomma manna na pul empi paat ngngin.” ");
INSERT INTO lmd_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Apul ipokat piꞌrimathe iꞌrekat kin itti, “Lon lon lointha ellrïk, onon thomma na kwaat ngngin anaruk kwanyinthin kït. ");
INSERT INTO lmd_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Oron thina itti Kapik kakannoccïkot ul wolon ilokithak. Anaruk kaccïkot ul iongothe lon lung ana iakkot lon ila kwongothe. ");
INSERT INTO lmd_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ammakka capu cokuꞌrettat ncik pul pella manna ipoccïkothe itti pul panyittanthet kït ipokwontat piꞌrimathe. ");
INSERT INTO lmd_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Amma pul empi pappakannoka poKapik pakannokkothe lon elli.” ");
INSERT INTO lmd_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Aul woIouth ittïttïk iꞌrekat pul ipokat piꞌrimathe itti, “Ngkwokwonttat ana upokkot ilon ilokithak, ngkwonu itti ngkwangkenenïn lon lꞌreki?” Okin thokïccekathok nnocuththun kirrkkir. ");
INSERT INTO lmd_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ana oIeccuo poccïkathe itti okin thokïccerok nnocuththun anakka kwiothok, kwiꞌrekathok itti, “Ngkwaccokot lon nocïkït lokkul wopul iponyii?” ");
INSERT INTO lmd_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Apul ipokat piꞌrimathe ipittathok itti, “Ook oththa pït pin, iꞌrethin othakka itti anoccokot lon lung nocïkït.” ");
INSERT INTO lmd_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","AIeccuo iꞌrekathok itti, “Ngkwimmarok ntit ana kwaik perenung.” ");
INSERT INTO lmd_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ittina apul pen iꞌrekat itti, “Ili, mpoccokothe lon lang nocïkït.” Ana kwaꞌrakanthet oIeccuo ngaꞌrama. ");
INSERT INTO lmd_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","OIeccuo piꞌrekathe itti, “Mpaat nocapu appik anathakkma ul, othakka itti aul iꞌrimathe immaik ana ul immat cik aiꞌrimat.” ");
INSERT INTO lmd_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ul wꞌrek woPriccin iokat cik okin aththut woccïkathe akka kwiꞌret lon len, aipittat itti, “Ngimpene? Onïn thiꞌrimathe cakuruke?” ");
INSERT INTO lmd_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","AIeccuo othïanthet kin tit itti, “Amma onon thaththiꞌrimathe, onon thakorronno okat tholon ilokithak. Anaruk onon thaik thinnikot itti onon thimmat cik ittina lon ilokithak laꞌrungkotheik.” ");
INSERT INTO lmd_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","AIeccuo iꞌrekat itti, “Mpiꞌret non lon ilaik ïcat, pul ipanniꞌriko nti icürük cokuthuk, akwullo karrang, okkathuꞌran emprïk ana pul ipaththikot aꞌrupu. ");
INSERT INTO lmd_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Pul ipiꞌriko nti icürük cokuthuk, ook opït polungkat. ");
INSERT INTO lmd_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ana pul ipangwot cik panyinok kathat ana lungkat laccïkot poꞌre pung. Kwakkaro lungkat lung nnꞌran wen akwoppiekat thapat. ");
INSERT INTO lmd_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ana amma kwoppiethe thapat nti iththuk, kwaeo tokït ken alantomakothok ana laccïkothok akka lina poꞌre pung. ");
INSERT INTO lmd_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Anaruk lakorronno omakot pul ipa lomma, ana lallot pul pen akka lomma poꞌre popul pen.” ");
INSERT INTO lmd_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","OIeccuo perenet kin lon elli okkwie lon kuru ncik anaruk okin thannina lon ila kwokat cik akwerenekin. ");
INSERT INTO lmd_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ittina aIeccuo appiꞌrekat kin itti, “Mpiꞌret non lon ilaik ïcat, Oun cürük cokuthuk na lungkat okko. ");
INSERT INTO lmd_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Okin appik ithaat amparthuk ao akin innikot itti okin ul iuꞌre, okin thothuꞌran ana ithaththikot aꞌrupu anaruk lungkat lakorronno occïkot kin. ");
INSERT INTO lmd_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Oun cürük ana okkwi ipokkot icürük cen kwaꞌrettat. Kwiꞌriko noppan ana oppot thapat akwoppo icürük ana kwiot thuꞌrit. ");
INSERT INTO lmd_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Pul iponu thuꞌran pao tulluk itti pathomunye ana ongwaro ana okïttoik anaruk mpaat itti akin ona thikkoik thonu thethïettat. ");
INSERT INTO lmd_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Oun pul ipuꞌre ipoporot. Pul ipuꞌre ipoporot pangat itti pio nti ilon lolungkat lung. ");
INSERT INTO lmd_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Pul iponakattat itti puꞌre pakannoka ammakka opït polungkat akka amma pul pen pimmat mipa amanthan ana papaꞌrine lungkat cik ana pallo ana mipa mallot tolungkat amoꞌrumat amopettat cik. ");
INSERT INTO lmd_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Pul pen pallo akka kwakannoka pul polungkat ana kwella kït ken. ");
INSERT INTO lmd_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Oun pul ipuꞌre ipoporot, mpina lungkat lin ana lungkat lin linan cakuruk ");
INSERT INTO lmd_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ammakka ongappa pinan ana mpina ongappa ana mpio nti ilon lolungkat lin. ");
INSERT INTO lmd_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Mponu lungkat lꞌrek lella ilakorronno oka nti iththuk kolungkat elli. Mponu itti mpanakin cakuruk. Laccïkothin ana laka ithun iththuk kulukku ana pul ipuꞌre paka pulukku. ");
INSERT INTO lmd_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ongappa pongothin akka mpangkothe itti mpio anappuroko attang. ");
INSERT INTO lmd_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Pul pella panekothin thikkoik thin anaruk oun pellek ngka kin akkongothe itti mpio. Oun akkonu puꞌran itti mpakorronno ka kin itti mpio ana mponu puꞌran itti mpurokie ka kin nti ithio. Lon ila mpaik pere langappa akkiꞌrethin itti mpakkot.” ");
INSERT INTO lmd_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Anakka kwiꞌret lon elli aul woIouth appillillakat tit attang. ");
INSERT INTO lmd_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ul woppot nti iakin wiꞌrekathe itti, “Uꞌrupa iokithak woꞌrot naak ana kwipot purrut. Ngintha akka aron occïkïnthet lon lung?” ");
INSERT INTO lmd_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Anaruk ul wꞌrek wiꞌrekathe itti, “There thung enthi thakannoka thopul ipa uꞌrupa iokithak woꞌrot nan. Uꞌrupa iokithak wanyot kït kopul ipiꞌrimathei?” ");
INSERT INTO lmd_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ittina acaꞌri cokamuthe kothothuntet tupan toKapik akkakat nokaꞌran koUruccelim. Ana cik cokat icpo, ");
INSERT INTO lmd_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","oIeccuo pokat cik akwonyaro ithꞌrapak tonoppan toKapik ithrara ithonat kꞌran itti Thrara thoCiliman. ");
INSERT INTO lmd_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ul woIouth waꞌrntakathe iccik kung aiꞌre itti, “Ngkwaprttakiet nïn tit manna kartha? Amma oung oMiccie aiꞌret nïn nci nokkït.” ");
INSERT INTO lmd_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","AIeccuo othïanthet kin itti, “Mpiꞌrethenon, anaruk onon thakorronno occokot lon lin nomïkït. Lon ilommaththik ila anokkot ngkꞌran kongappa leret lon lin. ");
INSERT INTO lmd_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Anaruk onon thakannoccokot lon lin nomïkït akka onon thakannoka lungkat lin. ");
INSERT INTO lmd_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Lungkat lin laccïkot poꞌre pin ana mpina ana linan ana lammakothin. ");
INSERT INTO lmd_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Mpethet kin thikkoik thothupuththuput ana okin thakorronno intat cik ana pul pella panekothin kin. ");
INSERT INTO lmd_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ongappa ipethin kin akkïrïk naꞌrupu appik, ana pul pella ipaneko kin ntikkun wongappa. ");
INSERT INTO lmd_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Oun ana ongappa onïn thulukku.” ");
INSERT INTO lmd_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Aul woIouth apponekat mothok attang itti wakincothok cik. ");
INSERT INTO lmd_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Anaruk oIeccuo piꞌrekathekin itti, “Mpokenet non lon loppot ilommaththik nangappa, liatha akka onon thongothe itti nthakincothin cik ntit?” ");
INSERT INTO lmd_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Aul woIouth othïanthok tit itti, “Onïn thakorronno angkot itti onïn thakincothung cik nti ire ioppot ia ngkwokkothe anaruk akka ngkwaik pakatha ka kang ngkwaKapik anaruk ngkwapul iponyi.” ");
INSERT INTO lmd_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","OIeccuo pothïanthet kin tit itti, “Lakorronno okurrako ilon lothonceꞌret lon cik lon na Kapik kiꞌrethe itti, ‘Ul ionu lon ikkun wꞌrek itti onon apik’? ");
INSERT INTO lmd_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Lon loKapik lakkarot ul wen itti apik ana lon loKapik laik ïcat appinappin. ");
INSERT INTO lmd_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Oun ipa angappa pakkarot ana othïot nocapu ncik appik, ana tat akka annorukwethin llon itti mpiꞌret itti, ‘MpaKapik’? Othakka itti akka mpiꞌret itti, ‘Oun ukul woKapiki’? ");
INSERT INTO lmd_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Amma mpaik pakorronno okkot ngre ngongappa annokorronno occokot lon lin nomïkït mon. ");
INSERT INTO lmd_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Anaruk amma mpaik pakkot ana manna onon thantokorronno occokot nomïkït mon, noccokot lon ilommaththik lꞌrek ilanon thina itti ongappa paik iaun ana mpaik iaak.” ");
INSERT INTO lmd_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Menik okin thenekkekathe itti okin thaccokot oIeccuo anaruk kurakathekin akwoingkat. ");
INSERT INTO lmd_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ittina oIeccuo parrathe tue toÜrüthün cik akweo nokaꞌran na aIuanna pomamuthie pokat cik akwikket ul mamuthie nomaꞌri morokït. OIeccuo pikkot cik nan ");
INSERT INTO lmd_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ana ul woppot wakkakanthok. Okin thiꞌrekathe itti, “OIuanna pomamuthie pakorronno okkot lon ilommaththik, anaruk lon ila kwerethe pul empi ngngin lokat ïcat appik.” ");
INSERT INTO lmd_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ana ul woppot woccokathe lon loIeccuo nomïkït. ");
INSERT INTO lmd_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Pul pꞌrek pokat cik poccot kꞌran itti oLiaccir. Pokat pongo ana kwokat ponokaꞌran koPeththania ipokat kaꞌran koMeriom ana opang ipopari oMarththa. ");
INSERT INTO lmd_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","OMeriom ipa apang oLiaccir paik nonthe pongo ook oMeriom ipoꞌrot Ili amutha ana ukukkwot tacok toIli nuan wung. ");
INSERT INTO lmd_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ittina apangon thoLiaccir othïanthet oIeccuo thon itti, “Ili, okkwi ipa ngkwongothe pongo.” ");
INSERT INTO lmd_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Anakka oIeccuo poccïkothe elli akwiꞌrekat itti, “Thonga enthi thakorronno ocothakot itti kwio. Anaruk othakka itti aKapik othikkietta krïk ana athrïk aine ukul wung nti ithio then.” ");
INSERT INTO lmd_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","OIeccuo pokat pongothe oMarththa ana opang ipopari ana opang pen ipocura oLiaccir. ");
INSERT INTO lmd_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Anakka oIeccuo poccïkothe itti oLiaccir pongo, kwapprikkat cik nokaꞌran na kwokat maꞌri meꞌra icci. ");
INSERT INTO lmd_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Menik kwiꞌrekathe ul iammakothok itti, “Ntun eo opakkot noththok poIouthia.” ");
INSERT INTO lmd_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Anaruk okin thiꞌrekathe itti, “Pul ipangkene, onïn thapri itti ul woIouth wira wakincothung cik tentre ana ngkwappopakkinthet kin tat?” ");
INSERT INTO lmd_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","AIeccuo othïat tit itti, “Mpapri itti caꞌri conu kït komïngkïrit attul ana ikken keꞌra? Ittina okkwi ipanyaro icïngkï kwakorronno ommukko nopothok akka kwimmaik ngkꞌran kocïngkï conocapu. ");
INSERT INTO lmd_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Anaruk amma akwonyaro ngkoꞌra kwammukko akka kꞌran ikaccienok cik kella.” ");
INSERT INTO lmd_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Akka oIeccuo piꞌret elli, akwapparttat nan itti, “Opuruko ponnon oLiaccir pakko inthe anaruk mpaik paeo anothurttok.” ");
INSERT INTO lmd_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Aul iammakothok iꞌrekathok itti, “Ili, amma kwaik inthe ana kurtta.” ");
INSERT INTO lmd_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","OIeccuo pappokat akwere itti oLiaccir piot anaruk ul immakothok wokat wommat akin ome itti kwakko inthe nuthuk. ");
INSERT INTO lmd_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ittina kwiꞌrekathekin nci nokkït itti, “OLiaccir piot, ");
INSERT INTO lmd_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ana nti ilon lon mpopirat noka akka mpellat tentre naak othakka itti annoccokot lon nomïkït. Ntrun oinok.” ");
INSERT INTO lmd_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","OThthoma ipokat poccot kꞌran cakuruk itti Tharo iꞌrekat ul woIeccuo iammakothok wꞌrek itti, “Ntun eo cakuruk othakka itti aron othille uraththut.” ");
INSERT INTO lmd_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Anakka oIeccuo paat, kwaththiat oLiaccir akkwiot ntit akkwonu maꞌri mocoꞌrin ippu. ");
INSERT INTO lmd_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Kaꞌran koPeththania kokat kannoka ciththan nokaꞌran koUruccelim, ");
INSERT INTO lmd_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ul woppot woIouth wawoinet oMarththa okin opang oMeriom athipitto kin akka opang pen pokat piot. ");
INSERT INTO lmd_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Anakka oMarththa poccïkothe itti oIeccuo paik panthan, kwoingkathe thapat akwothocurot iaak, anaruk oMeriom pikkatheik tuan. ");
INSERT INTO lmd_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","AMarththa iꞌrekat oIeccuo itti, “Ili, amma ngkwappokat cik cene ana opangkin pannaiot. ");
INSERT INTO lmd_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Anaruk mpina itti manna inenni Kapik kethung ilaipitto.” ");
INSERT INTO lmd_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","AIeccuo iꞌrekat oMarththa itti, “Opangkang puroko attang.” ");
INSERT INTO lmd_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Amarththa othïat tit itti, “Mpina itti kuroko attang nocaꞌri cothurttuko.” ");
INSERT INTO lmd_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","AIeccuo iꞌrekathok itti, “Oun thuroko ana thikkoik. Ana okkwi ipoccokothe lon lin nocïkït kwakkoik antoka manna itti kwiot, ");
INSERT INTO lmd_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ana okkwi ipaik ngkït thapat ana kwoccokothe lon lin nocïkït kwakorronno io, ngkwaccokot lon elli nocïkïri?” ");
INSERT INTO lmd_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Akwothïanthet oIeccuo tit itti, “Ili, mpoccokothe lon nocïkït itti, oung oMiccie, ukul woKapik okkwi ipokat ponu itti kwanthan nocapu ncik appik.” ");
INSERT INTO lmd_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Anakka kwiꞌrethe oIeccuo lon elli akwoingkat akwothakkarat opang ipopari oMeriom thocipit. Akwiꞌrekathok itti, “Pul ipangkene paik cene ana kwaik pipittong.” ");
INSERT INTO lmd_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Manakka oMeriom poccïkothe lon elli akurokat kapik accokkot akwoingkanthok. ");
INSERT INTO lmd_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","OIeccuo pokat parthuk iꞌriko icarak coman kwokat nokaꞌran na aMarththa paththocurot iaak. ");
INSERT INTO lmd_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Anakka ul woIouth iathipitto oMeriom wimmat tat akka kwurokot accokkot akweo thapat, okin thomakathok akin iꞌre itti ikkre kwaik pathoot thoppu. ");
INSERT INTO lmd_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Manakka oMeriom peot nokaꞌran na oIeccuo pokat cik, kwimmakathe oIeccuo ana kwapathe iracok tung akwiꞌrekat itti, “Ili, amma ngkwappokat cik cene ana opangkin pannaiot.” ");
INSERT INTO lmd_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Anakka oIeccuo pimmat oMeriom akwoo ana ul woIouth iaat akin aththut aoo cakuruk kwokakathe piccillang ka ana kwakorronno okakat poporot noka. ");
INSERT INTO lmd_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","AIeccuo ipittat itti, “Onon thocïkkarorok kartha?” Akin othïanthet oIeccuo tit itti, “Ili, aꞌrik athokatha.” ");
INSERT INTO lmd_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","OIeccuo pikkatheik akwoo. ");
INSERT INTO lmd_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ittina aul woIouth iꞌrekat itti, “Nantokatha akka kwongothok.” ");
INSERT INTO lmd_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Anaruk opilin ntiakin piꞌrekathe itti, “Okorronno oka ook ipanyinthet pul ipa piꞌrimathe kïri, kwakannokorronnot oLiaccir itti kwakorronno ioi?” ");
INSERT INTO lmd_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Acïkït okꞌrellat oIeccuo attang ana kwoingkathe thoppu thocuꞌrol ipaꞌranthang. Tupu tokat tunukkakothe ngkaꞌraccak. ");
INSERT INTO lmd_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Kwiꞌrekathekin itti, “Nopaꞌre pothok cik.” Anaruk oMarththa opang popul ipiot piꞌrekathe itti, “Ili, kwiot ponu maꞌri mocoꞌrin ana kwaththoka pakkunakot.” ");
INSERT INTO lmd_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","AIeccuo iꞌrekat itti, “Mpappakanniꞌret non itti amma okkwi ipoccokothe lon loKapik nocïkït ana kwimma thrïk thoKapiki?” ");
INSERT INTO lmd_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Okin thopaꞌrekathe pothok cik aIeccuo okathakat tothiꞌrot akwiꞌrekat itti, “Ngappa, mpopiranung noka akka ngkwoccïkothin. ");
INSERT INTO lmd_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Mpina itti ngkwaccïkothin appinappin, anaruk mpiꞌret elli othakka itti aul enni iaik wacoꞌro cene ina itti oung akkothïothin.” ");
INSERT INTO lmd_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Anakka oIeccuo piꞌret elli, kwakkarathe mpoꞌre cittan itti, “Liaccir, oppothe thapat.” ");
INSERT INTO lmd_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Apul ipappiot oppat thapat ana nyaun ana tacok tokat toꞌremethettat nneret wothocïkkako ana kret kulukkwothok toca. OIeccuo piꞌrekathekin itti, “Nokꞌrothok eret akweo.” ");
INSERT INTO lmd_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ul woppot woIouth iaat itti wathokatha oMeriom anakka wimmat lon ila oIeccuo pokkothe, woccokathe lon lung nomïkït men. ");
INSERT INTO lmd_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Anaruk opilingon thoingkanthet ul woPriccin akin iꞌrekat kin lon ila oIeccuo pokkothe. ");
INSERT INTO lmd_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ittina aul ittïttïk woul wonoppan toKapik ana ul woPriccin thakkaranthe cuththun coul woIouth ittïttïk. Akin ipittat itti, “Ngintha akka oron okkot? Pul empi paik pakkot lon ilommaththik loppot. ");
INSERT INTO lmd_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Amma oron thakorronnok akwokkot ittina ana ul appik waccokot lon lung nomïkït, ana ul woRoma wanthan ana waneko tupan toKapik appik ana ul wonnon appik.” ");
INSERT INTO lmd_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Opilin nti iakin poccot kꞌran itti oKiappa ook ipokat pul iprïk ponoppan toKapik nothuput then piꞌrekathe itti, “Onon thomma lon lꞌrek aththik. ");
INSERT INTO lmd_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Onon thomma itti laka loporot itti pul pulukku pine ul woppot ana okorronno oka itti ul woppot wille, aintakat ciki?” ");
INSERT INTO lmd_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kwakorronno iꞌre elli ngka kung anaruk ammakka pul iprïk ponoppan toKapik nothuput then perethe lon ilaik lanthan itti oIeccuo piot nothapak nti ilon loul woIouth, ");
INSERT INTO lmd_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ana okorronno oka tulluk itti kwine ul woIouth anaruk kwine nyukul inyopettakotheik nyoKapik othakka itti akwaꞌrnttot kin tothun akwothikkiekin thulukku. ");
INSERT INTO lmd_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ana nocaꞌri cen anili noIouth ikkat cik anipot lon cik ilakin okkwot oIeccuo ngngin. ");
INSERT INTO lmd_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","OIeccuo pikkatheik akwokorronno onyaro ncinokkït iul woIouth. Ana kwoingkathe nokaꞌran koIppraim ikokat iccik koka kothampang ithonthomat ana kwikkatheik than okin oul iammakathok. ");
INSERT INTO lmd_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Anakka caꞌri cokamuthe koul woIouth koThaurrot kaman kꞌrek cik kokat cik akokko napuththut, ul woppot wakkakathe nokaꞌran koUruccelim athimet lon len ilokithak cik akamuthe koThaurrot kaman kꞌrek karthuk ao. ");
INSERT INTO lmd_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Okin thikkatheik akin akwariccat oIeccuo, anakka okin thocoꞌrot ithꞌrapak thonoppan toKapik okin thikkatheik akin ipittararot itti, “Atti kwanthan nokamuthe cung?” ");
INSERT INTO lmd_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Anaruk ul ittïttïk woul wonoppan toKapik ana ul woPriccin wokat wonekkethe lon cik itti amma opilin piothe oIeccuo, akwathiꞌret kin othakka itti akin athoccokothok. ");
INSERT INTO lmd_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Anakka maꞌri mellat ncik mꞌrakkuruk akamuthe koThaurrot kaman kꞌrek cik okkattat, oIeccuo popakkathe nokaꞌran koPeththania na kwappurokiethe oLiaccir nti itho. ");
INSERT INTO lmd_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Thuꞌrit thokkattakathe nti ithothiane oIeccuo cik athettakathok aMarththa ikkat cik akwittarot kin ana oLiaccir pokat cik nti iakin ithokat akin othïngkakot iriki wokkun wothokure iccik kung nokuppuꞌrung kothuꞌrit cakuruk. ");
INSERT INTO lmd_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Menik oMeriom ponekathe cuꞌru camutha ionu cekerek crïk ana kunanthet oIeccuo noracok ana kwikkatheik akukukkwot nnuan wung. Ana man moppakathe utha wamutha iakkunako irruk. Amutha wokat wokkattathe nnopoꞌren ipoccot kꞌran itti narth. ");
INSERT INTO lmd_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Apilin nti iul immakothok ipoccot kꞌran itti oIoutha Icikkariuththi, ipathokerot ul oIeccuo pokat cik cakuruk akwiꞌrekat itti, ");
INSERT INTO lmd_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Ngintha akka aron okïttinthet ngaak engi cik ingira ngaketta nakucci woppot aikkettat ul iaiak. Amutha wonu cekerek cakucci iarekako ngngnin thuput.” ");
INSERT INTO lmd_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Kwanniꞌre lon elli othakka itti kwonu thiak thoul iaiak anaruk akka kwonat thuꞌran ana kwokat pul ipoccokothe kaꞌruk kakucci, ana kwokat akwomunye akucci iokat ikaꞌruk. ");
INSERT INTO lmd_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","OIeccuo piꞌrekathe itti, “Nokorronnok, kwappangwotheik itti akwathocïkkon ngngin. ");
INSERT INTO lmd_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Onon thonu ul iaiak ithoꞌrkït thon appinappin anaruk mpakorronno oka ithoꞌrkït thon appinappin.” ");
INSERT INTO lmd_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Anakka ul woIouth winat nan itti oIeccuo pokat ceneket, woingkathe athokathak ana okorronno oka oIeccuo tulluk anaruk okin thaththokatha oLiaccir cakuruk ipa oIeccuo pappurokiet nti ithio. ");
INSERT INTO lmd_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ul ittïttïk woul wonoppan toKapik wipathe lon cik ila akin okkwot oLiaccir ngngin cakuruk, ");
INSERT INTO lmd_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","akka ook akkokorronnot ul woIouth woppot apaꞌrine lon loul wonoppan toKapik cik, accokot lon loIeccuo nomïkït. ");
INSERT INTO lmd_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ana ngorrot ngen, aul iaat nokamuthe occïkat itti oIeccuo paik ikathar paik panthan nokaꞌran koUruccelim. ");
INSERT INTO lmd_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Okin thongathathe uꞌri wokira kothemur akin oingkat othocurarot iaak akin iꞌre mpoꞌre cittan itti, “Ton opirane Kapik noka korothiꞌrot.” “Athethïetta oka nakkwi ipaik panthan ngkꞌran koIli.” “Athethïetta oka noili woIccereil.” ");
INSERT INTO lmd_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","OIeccuo piathe ngeꞌringka ngotte ana kwarratheran ammakka lokurrakot itti, ");
INSERT INTO lmd_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Ul woIccereil, nokorronno ipo nꞌre, nantokatha ili won waik wanthan, warrothe teꞌringka iotte.” ");
INSERT INTO lmd_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Caꞌri cen ul iammakothok warommat lon len, anaruk akka oIeccuo purokot nti ithio ana othikkietta prïk, akin antokwarikat lon ilokat lokurrakot iatham woKapik ierethe lon lung ana okin thokkanthok lon len. ");
INSERT INTO lmd_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ana ul iokat cik okin aththeꞌran akka kwakkarot oLiaccir nti ippu akurokiekathok nti ithio wikkatheik apettot lon len cik appik. ");
INSERT INTO lmd_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ul woppot woingkathe athokathak akka wokat woccïkothe lon ila kwokkothe ilommaththik. ");
INSERT INTO lmd_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ittina ul woPriccin werettaranthet itti, “Oron thaik thakorronno okkot lon lꞌrek. Nantokatha akka ul waik wamakothok nocapu ncik appik.” ");
INSERT INTO lmd_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ul wꞌrek iakorronno oka woIouth waat itti wathaꞌra ngaꞌrama nocaꞌri cokamuthe. ");
INSERT INTO lmd_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ul iakorronno oka woIouth wen wakkakanthet oPilippic ipokat ponokaꞌran koPeththcceitha ikaik noththok poCelïl akin ipittathok itti, “Pït pïn, ïnthongothe itti onïn therene oIeccuo.” ");
INSERT INTO lmd_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","OPilippic poingkathe akwothiꞌret Anthrauc, ana Anthrauc ana oPilippic thopakkathe akin othiꞌret oIeccuo. ");
INSERT INTO lmd_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","AIeccuo othïanthet kin itti, “Caꞌri caat cokkul wopul iponyi itti wathikkietta wïrïk. ");
INSERT INTO lmd_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Mpiꞌret non lon ilaik ïcat itti amma core cocïl cakannapot nocapu mono acio caꞌrungkwot cik cïl culukku anaruk amma ciot cakwono mïl moppot. ");
INSERT INTO lmd_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Pul ipongothe thikkoik thung kuret cik, ana okkwi ipꞌrat thikkoik thung nocapu enci thanguttanthok cik thikkoik thothupuththuput. ");
INSERT INTO lmd_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Okkwi iparekinin ponu itti kwamakothin ana na mpaik pul iparekinin ponu itti pakaik. Ongappa pathikkie okkwi iparekinin pothiakinet cik. ");
INSERT INTO lmd_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Mpaik piirro cïkït nti icarak cannan ana mpomma akka aniꞌre, ‘Ngappa oꞌrethin nolon ilaik lainin’? Anaruk ilen akka mpainet nocaꞌri enci. ");
INSERT INTO lmd_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ngappa, athrïk oka nokꞌran kang.” Ittina apoꞌre akkakat ntothiꞌrot apiꞌre itti, “Mpethet thrïk ana mpappethet thrïk attang.” ");
INSERT INTO lmd_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Manakka ul woccïkothe lon len aiꞌrekat itti thuleꞌrak thoKapik apilingon iꞌre itti uꞌrupa wothothïlettat woKapik waik werenok. ");
INSERT INTO lmd_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","OIeccuo piꞌrekathekin itti, “Poꞌre empi itti apittarot non, pakorronno oka pin. ");
INSERT INTO lmd_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Inenni caꞌri cothakkmako cene nocapu ana inenni pul pothopulut ili wonocapu enci wakïccettat thapat. ");
INSERT INTO lmd_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Anaruk amma mponthuttathe nothapak mpanyine ul kathar appik ainin.” ");
INSERT INTO lmd_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Kwiꞌret elli akwokene thio itha kwaik pathio. ");
INSERT INTO lmd_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Aul iꞌrekat itti, “Onïn thinat nti iatham wothonceꞌret lon cik itti oMiccie pakinnio thupuththuput ana tat akka appiꞌre itti ukul wopul iponyi wio? Oththa ukul wopul iponyi?” ");
INSERT INTO lmd_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Menik aIeccuo iꞌrekat kin itti, “Kꞌran kaik kathocciek papotte okorronno oka puccuk nonyaro inakka onon thonu kꞌran ikaccieik aïꞌrïmak ngarthuk oꞌroik. Pul ipanyaro iꞌrïmak pomma na kwaik paeo. ");
INSERT INTO lmd_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Onoccokot lon nomïkït lokꞌran ikaccieik inakka onon thonu, othakka itti anon oka nyukul nyokꞌran ikaccieik.” Anakka kwomarttot there kwoththekathe nakin ana kwintakatheik. ");
INSERT INTO lmd_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Anaruk antoka manna itti oIeccuo pokkothe lon ilommaththik tokït ken, okin thokat thakorronno occokat lon lung nomïkït. ");
INSERT INTO lmd_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Elli lokkattathe othakka itti alon ila pul pothernte lon loKapik oIccaia papiꞌret ngngin oka ïcat itti, “Ili, oththa akkoccokothe lon nomïkït ilanïn theret. Ana oththa akkimmat puꞌran pang iprïk?” ");
INSERT INTO lmd_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Okin thakorronno occokat lon nomïkït nti ilon lꞌrek attang ammakka pul ipernte lon loKapik oIccaia perethekin ngngin imakkren, ");
INSERT INTO lmd_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Kwiꞌrimiethekin kït ana onthomiet kin mïkït othakka itti akin okorronno immaik ngkït ana manna inaik mmïkït men ana oprttakoik ana mpittiet kin.” ");
INSERT INTO lmd_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","oIccaia piꞌret elli akka kwimmat thrïk thoIeccuo ana ilen akka kwerenthet oIeccuo. ");
INSERT INTO lmd_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ul iokat cik woppot ittïttïk woIouth woccokothe lon loIeccuo nomïkït anaruk okin thokat akin okorronno ere lon loIeccuo nci nokkït akka okin thokat akin opellene ul woPriccin akka akïccekin nocuththun caꞌrama. ");
INSERT INTO lmd_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Okin thaththongothe thomerekattat thoul nnothomerekattat thoKapik. ");
INSERT INTO lmd_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","OIeccuo piꞌrekathekin lon mpoꞌre cittan itti, “Okkwi ipoccokothe lon nocïkït lin, kwakorronno occokot lon lin tulluk anaruk kwoccokothe lon lokkwi ipothïothin. ");
INSERT INTO lmd_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ana amma akwokathaccen, kwimma okkwi ipothïothin. ");
INSERT INTO lmd_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Mpaat nocapu ncik appik ammakka kꞌran ikaccieik othakka itti okkwi ipoccokothe lon lin okorronno ikkoik iꞌrïmak. ");
INSERT INTO lmd_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Amma opilin poccïkothe lon ana kwakorronno oꞌrumo nan, mpakarronno akkma akka mpakorronno ao itti mpathakkma capu ncik appik anaruk mpaat anathoꞌret ul. ");
INSERT INTO lmd_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Thakkma thaik thokkwi ipꞌrarin ana ꞌra lon lin ila anere, lon len ila mperet lathakkmak nocaꞌri cothakkmako. ");
INSERT INTO lmd_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Mpakorronno ere ngka kin anaruk ongappa ipothïothin akkakenen itti ngintha akka aniꞌre ana mpiꞌre tat. ");
INSERT INTO lmd_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Mpina kicce itti lon lung lanekarot nothikkoik thothupuththuput. Anaruk lon ilaniꞌre laNgappa akkiꞌrethin itti mpiꞌre.” ");
INSERT INTO lmd_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Anakka kamuthe koThaurrot kaman kꞌrek cik kokuntakinet caꞌri culukku, oIeccuo pinat itti caꞌri cung caat itti kwaththe nocapu ncik appik akwoine oththan. Kwokat pongothe ul wung immakothok nomaꞌri ima kwokat cik nan nocapu, ana inenni kwongothekin kirrkkir. ");
INSERT INTO lmd_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Okin thokat cik akin oꞌrko thuꞌrit thocipin ana pul pothopulut piꞌrikathe iaIoutha poIcikkariuththi ukul woCcaman othakka itti akwokero oIeccuo. ");
INSERT INTO lmd_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","OIeccuo pinat itti oththan pethok puꞌran polon appik ana itti kwaat noKapik ana kwaine Kapik. ");
INSERT INTO lmd_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","OIeccuo purokathe nothuꞌrit akuekat kret cik ika kwappakot nopangken akwïꞌrïkat kret kꞌrek kottakarran ikin akwothukukkot ngngꞌri. ");
INSERT INTO lmd_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Akwunat ngꞌri nocaththak cïttïk akwikkat cik akwime tacok toul immakothok akwukukkwot ngkret ika kwokat pokkwethe ikin. ");
INSERT INTO lmd_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Anakka kwainet oCcamaan iponu kꞌran itti oPoththuruc, kwiꞌrekathok itti, “Ili win, ngkwaik pathime tacok tini?” ");
INSERT INTO lmd_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","AIeccuo othïanthok tit itti, “Ngkwomma lon ila mpaik pakkinthung anaruk nomaꞌri imanthan ngkwina.” ");
INSERT INTO lmd_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","OPoththuruc pꞌrakathe, akwiꞌrekat itti, “Ngkwakorronno ime tacok tin.” OIeccuo pothïathe tit itti, “Amma mpakorronno imenung tacok tang ana ngkwakorronno oka pin.” ");
INSERT INTO lmd_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","OCcamaan oPoththuruc pothïathe tit itti, “Ili, kirrnni imenin tacok tulluk, anaruk imenin nyaun ana ca cakuruk.” ");
INSERT INTO lmd_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","OIeccuo pothïatherit itti, “Pul ipopakkot ponu itti pimetta tacok tulluk, ka kung appik kella nguꞌru. Ana onon ul win iammakothin, onon thannoka appik thupupure.” ");
INSERT INTO lmd_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Akka kwinat okkwi ipokat cik pathokerok, ana ilen akka kwiꞌrenet itti onon thannoka appik thupupure. ");
INSERT INTO lmd_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Anakka kwomarttot thimenekin tacok kicce akwakat kret kung, akwopakkat nokaꞌran kung akwikkat cik akwipittat kin itti, “Onon thina lon ila mpokkinthet noni? ");
INSERT INTO lmd_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Onon thakkaron itti, ‘Pul ipangkene,’ ana itti, ‘Ili’ ana laik ïcat akka mpamenik. ");
INSERT INTO lmd_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Inenni onon thimmat akka oun Ili won ana pul ipangkene pon pimet tacok ton, onon cakuruk thonu itti onon thimentarene tacok. ");
INSERT INTO lmd_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Mpokenet non othakka itti annokkot ammakka mpokkinthet non. ");
INSERT INTO lmd_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Mpiꞌret non lon ilaik ïcat itti pul pella ipareko paka prïk nopul ipa kworekine, ana manna pul ipothïlathe pakorronno oka prïk nopul ipothïothok. ");
INSERT INTO lmd_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ana inenni onon thina lon elli amma onon thokkothe ana onon thethïettat.” ");
INSERT INTO lmd_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Mpaik pakorronno eret non appik, mpina okin itha mpumot nti ianon. Anaruk elli lokkattathe othakka itti alothakka ila atham wiꞌret itti, ‘Okkwi ipanïn thaik thaꞌrko thuꞌrit pakeron.’ ");
INSERT INTO lmd_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Mpaik piꞌret non inenni alarthuk othakka, akka amma lothakkat annoccokot lon nomïkït itti oun oMiccie. ");
INSERT INTO lmd_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Mpiꞌret non lon ilaik ïcat itti okkwi ipikkiet pul cik ipa mpothïothe kwikkierin cik, ana okkwi ipikkierin cik kwikkiet okkwi ipothïothin cik.” ");
INSERT INTO lmd_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Anakka kwiꞌret lon elli, cïkït cokat acirro nti icarak akwiꞌrekat itti, “Mpiꞌret non lon ilaik ïcat itti opilin nti ianon paik pathokeron.” ");
INSERT INTO lmd_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Aul immakothok ikkat cik akathaccetto, othakka itti akin ina itti okkwen akka oIeccuo pokat cik akweret. ");
INSERT INTO lmd_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Opilin nti iul iammakot oIeccuo ook ipa oIeccuo pongothe, pokat cik akwothïngkakot cik thokkun wothokure iccik koIeccuo nokuppuꞌrung kothuꞌrit. ");
INSERT INTO lmd_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","OCcamaan ipoccot kꞌran cakuruk itti oPuththuruc auꞌrekat ca akwiꞌrekat pul ipammakot oIeccuo ipokat iccik kung itti, “Antipittothok itti kwaik peret oththa.” ");
INSERT INTO lmd_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Apul pen ipammakot oIeccuo othïngkakot oIeccuo akwipittathok itti, “Ili, oththa pen?” ");
INSERT INTO lmd_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","OIeccuo pothïatherit itti, “Ook ipa mpaik pathethet arrakith enni amma mpothapet.” OIeccuo pothapekathe arrakith ngngucul ana kwekathe oIoutha Icikkariuththi ukul woCcamaan. ");
INSERT INTO lmd_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Anakka oIoutha poccot arrakith, apul pothopulut iꞌrikat iaak. Ittina aIeccuo iꞌrekathok itti, “Okkothe ila ngkwonu itti ngkwakkot cokoccokot.” ");
INSERT INTO lmd_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Pul pella ipinat lon itti oIeccuo piꞌrenthok ittina akain nokaꞌran kothuꞌrit. ");
INSERT INTO lmd_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Anaruk oIoutha pokat pul ipaccokot akucci wen, ittina opilingon thokat cik akin ome itti ikkre oIeccuo pokat akwomethok itti kwakero papꞌrek pokamuthe ana manna itti kwethet ul iaik nothiak. ");
INSERT INTO lmd_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Manakka oIoutha poccot arrakith, akwoppat thapat ana cik cokat ingkoꞌra. ");
INSERT INTO lmd_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Anakka kweot, aIeccuo iꞌrekat itti, “Inenni ukul wopul iponyi waik wathothikkietta wrïk ana Kapik kothikkiettat krïk iaak. ");
INSERT INTO lmd_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ana amma Kapik kothikkiettat krïk iaak ana Kapik kathikkie ukul wrïk iaak ana kathikkiek prïk accokkot. ");
INSERT INTO lmd_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Nyukul nyin, oron thakaik aththut maꞌri motte. Onon thakwariccathin ana ammakka mpiꞌrethe ul woIouth, mpiꞌret non inenni, nokaꞌran na mpaik paeo onon thakannanthan. ");
INSERT INTO lmd_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Lon lin ilonthomat ilie ila aniꞌret non itti nongarot. Ammakka mpongothenon, onon thonu itti nthangarot cakuruk. ");
INSERT INTO lmd_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ittina ul appik wina itti onon ul iammakothin amma onon thongarothe.” ");
INSERT INTO lmd_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","OCcamaan ipoccot kꞌran cakuruk itti oPoththuruc ipittathok itti, “Ili, ngkwaik paeo kartha?” Ana oIeccuo pothïatherit itti “Orit thakanneo iraththeꞌra ina, anaruk ngkwamakothin nomaꞌri imanthan.” ");
INSERT INTO lmd_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","APoththuruc ipittat itti, “Ngintha akkakorronno okorronnon itti mpamakothung ina, Ili? Mpio nti ilon lang.” ");
INSERT INTO lmd_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","AIeccuo othïat tit itti, “Ngkwokuccekotheik ïcat itti ngkwio nti ilon lini? Mpiꞌrethung lon ilaik ïcat itti athakꞌruk tharthuk oo ngkoꞌra engi ngkwacukkwo nolon maꞌri mꞌrapuruk itti ngkwomman.” ");
INSERT INTO lmd_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Nokorronno ïrro mïkït nti ikarak. Nonekket cïkït noKapik ana naun acakuruk. ");
INSERT INTO lmd_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Kaman kaik koppot tuan na ongappa, amma okat karra ana mpakorronno iꞌret non. Mpaik paeo tentre anothokuccenthet non kaꞌran cik. ");
INSERT INTO lmd_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ana amma mpokuccenthet non kaꞌran cik kicce ana mpakkaprttako ntan anathipo non aron oka uraththungon, othakka itti annoka na mpaik. ");
INSERT INTO lmd_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Onon thina kathar ika anekot non na mpaik paeo.” ");
INSERT INTO lmd_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","OThthoma piꞌrekathok itti, “Ili, onïn thomma na ngkwaik paeo, ana onïn thina kathar taththa?” ");
INSERT INTO lmd_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","AIeccuo othïat tit itti, “Oun kathar ana lon ilaik ïcat ana thikkoik. Pul pella paine ongappa amma kwakonnoppo naun. ");
INSERT INTO lmd_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Amma onon thaththinan kicce itti oun okkwen ana onon thina ongappa cakuruk. Nci inenni onon thinak ana onon thimmarok.” ");
INSERT INTO lmd_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","OPilippic piꞌrekathe itti, “Ili, okenenïn ongappa ana lekkot.” ");
INSERT INTO lmd_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","AIeccuo othïat tit itti, “Pilippic, ngkwommani ana manna mpokat cik ithoꞌrkït thon nomaꞌri emmi appik? Okkwi ipimmarin, kwimmat ongappa. Ngintha akka aiꞌrene itti, ‘Okenenïn ongappa?’ ");
INSERT INTO lmd_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ngkwakorronno occokot lon nocïkït itti mpaik iangappa ana ongappa paik iauni? Lon ila mpaik perenenon lakorronno oka lin. Anaruk longappa ipaik iaun akkaik pakkot ngre ngung. ");
INSERT INTO lmd_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Occokothe lon lin nocïkït amma aniꞌre itti mpaik iangappa ana ongappa paik iaun, ana manna nongre ia mpokkothe. ");
INSERT INTO lmd_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Mpiꞌret non lon ilaik ïcat, okkwi ipoccokothe lon lin nocïkït, kwakkot lon ila mpokat cik anokkettet. Kwakkot manna lïrïk nelli akka mpaik paine ongappa. ");
INSERT INTO lmd_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ana mpakkot ilanon ipitto ngkꞌran kin, othakka itti aukul onane oththan thrïk. ");
INSERT INTO lmd_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nipittothin lon ilanon thongothe ngkꞌran kin ana mpakkinthet non.” ");
INSERT INTO lmd_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Amma onon thongothin, onon thaccïkot lon lin. ");
INSERT INTO lmd_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ana mpipittot ongappa, ana kwethet non opilin akwittarot non ana oka nanon thupuththuput, ");
INSERT INTO lmd_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Kanang ikupupure kolon ilaik ïcat. Okkwion ithakorronno occokot lon lung nomïkït thakorronno ikkiek cik akka nthakinnimmak ana manna nthommak. Anaruk onon thinak, akka kwaik ianon inenni ana kwaka nanon nomaꞌri imanthan. ");
INSERT INTO lmd_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Mpakorronno okorronnonon ere nyukul inya aththan ana onnan piot nan anaruk mpainenon. ");
INSERT INTO lmd_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Nomaꞌri motte ul ncik appik wakorronno appimman anaruk onon thimman. Akka mpaik ngkït thapat ana onon thakaik ngkït thapat cakuruk. ");
INSERT INTO lmd_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Nocaꞌri cen, onon thina itti mpaik iangappa ana onon thaik iaun ana mpaik ianon. ");
INSERT INTO lmd_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Okkwi ipoccïkothe lon lin ana kwaik pareko ngngin, kwongothin. Ana okkwi ipongothin, ongappa pangathok ana mpangathok cakuruk ana mpakenek ka kin.” ");
INSERT INTO lmd_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ittina aIoutha (okonnoka oIoutha ngoIcikkariuththi) iꞌrekat itti, “Ili, ngkwontha akka ngkwongothe itti ngkwakenenïn ka kang ana akorronno okene ul nocapu ncik appik.” ");
INSERT INTO lmd_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","OIeccuo pothïatherit itti, “Amma pul pongothin ana pammakot thongkene thin, ongappa pin pangathok ana onïn thainok ana onïn thikkoik ïnaththut. ");
INSERT INTO lmd_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Okkwi ipakorronno ongathin, kwakorronno ommakot thongkene thin. Lon elli ilanon thaik thaccïkot lakorronno oka lin, lon longappa ipothïothin. ");
INSERT INTO lmd_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Mpaik perenenon elli appik inakka mpaik parthuk uraththungon. ");
INSERT INTO lmd_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Anaruk okkwi ipittarot non, ook Kanang ikupupure, okkwi ipa ongappa othïot ngkꞌran kin, kwangkenenon aꞌrupu appik ana okwarikiet non lon appik ila mpiꞌrethenon. ");
INSERT INTO lmd_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Mpaththenenon nothomicco, mpethet non thomicco thin. Mpaik pakorronno ethet non ammakka capu ncik appik ethet non. Nokorronno okorronno mïkït mon amirro nti ikarak, nokorronno ipo nꞌre. ");
INSERT INTO lmd_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Onon thoccïkothe aniꞌre itti, ‘Mpaik paeo ana mpaik painenon.’ Amma onon thongothin ana onon thaka thopirat noka itti mpaik paine ongappa, akka ongappa prïk naun. ");
INSERT INTO lmd_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Mpiꞌrethenon alarthuk othakka, othakka itti amma lothakkat annoccokot lon nomïkït. ");
INSERT INTO lmd_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Mpakorronno erenenon lon loppot, akka pul pothopulut ili wonocapu ncik appik enci waik wanthan. Mpakorronno oka inyaun nyung, ");
INSERT INTO lmd_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","anaruk capu ncik appik conu itti cina itti mpongothe ongappa ana mpakkot lon ila ongappa piꞌrethin itti mpakkot. Nuroko aron eo.” ");
INSERT INTO lmd_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Oun pira ipakwono nyukul nyoporot ïcat ana ongappa akkakatha lon lokira. ");
INSERT INTO lmd_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Kwathiot uꞌri wokira cik appik iakorronno okwono ana uꞌri iakwono akwokwet othakka itti akwono nyukul nyoppot. ");
INSERT INTO lmd_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Onon thothikkiettat thoꞌrillir nti ilon ila mperenet non. ");
INSERT INTO lmd_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Noꞌrungkwot iaun ana mpaꞌrungkwot ianon. Kuꞌri kopira kella ikakwono prek, konu itti kaka nopira ana ittina onon thakorronno okkot lon lꞌrek amma onon thella iaun. ");
INSERT INTO lmd_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Oun pira ana onon uꞌri wopira. Amma pul poꞌrungkwothe iaun ana mpoꞌrungkwothe iaak, kwakkot lon loporot loppot. Ana okkwi ipella iaun kwakorronno okkot lon lꞌrek. ");
INSERT INTO lmd_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ana amma okkwi ipakorronno oꞌrungkwot iaun, kwarretta ere kuꞌri kopira ikonthomat, ammakka kuꞌri ken kummuntat cik akorrettat ithik akokꞌro. ");
INSERT INTO lmd_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Amma onon thoꞌrungkwothe iaun ana lon lin laꞌrungkwot ianon, ana amma nthipittot lon lꞌrek, onon thiot. ");
INSERT INTO lmd_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Elli lanane ongappa thrïk itti onon thakkot lon loppot iloporot ammakka kira ikakwono nyukul nyoporot ana annokene ka kon itti onon ul iammakothin. ");
INSERT INTO lmd_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ammakka ongappa pongothin, mpongothenon. Ittina noꞌrungkwot ithongat thin. ");
INSERT INTO lmd_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Amma onon thaccïkot lon lin, onon thaꞌrungkwot ithongat thin ammakka mpoccïkothe lon longappa ana aꞌrungkot ithongat thung. ");
INSERT INTO lmd_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Mperenet non elli anothikkienon thopirat noka llon lin ana thopira noka thon oka thoporot kirrkkir. ");
INSERT INTO lmd_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Lon lin ilonthomat itti nongarot ammakka mpongothe non. ");
INSERT INTO lmd_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Thongarot thella thrïk cannan nothongat itti pul piine opuruko pungon.” ");
INSERT INTO lmd_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Onon opuruko pingon amma onon thakkot lon ila aniꞌret non itti nthakkot. ");
INSERT INTO lmd_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Mpakorronno appakkaronon itti iak pꞌrin akka iak womma ila apït paik pakkot. Anaruk mperenenon ammakka opuruko pingon ana mperenet non lon appik ila ongappa pongkenerin. ");
INSERT INTO lmd_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Onon thakorronno onekkethin cik anaruk oun akkonekkethenon cik annokkot lon loporot ammakka pira ipakwono nyukul nyoporot thupuththuput. Ana ongappa pethet non ilanon ipitto ngkꞌran kin. ");
INSERT INTO lmd_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Lon lin ila aniꞌret non ilonthomat itti onon thangarot. ");
INSERT INTO lmd_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Amma ul wonocapu ncik appik wantꞌra non, nina nan itti wꞌrarin cittokït. ");
INSERT INTO lmd_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ana amma onon thocapu ncik appik, cangat non itti onon thung. Anaruk onon thakorronno oka thocapu ncik appik akka mpakkarot non nti iakin nocapu ncik appik. Ilen akka ul wocapu ncik appik wꞌranet non. ");
INSERT INTO lmd_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nokwarttikot lon ila mpiꞌrethenon itti, ‘Pul ipareko pella prïk nopul ipa akworekine.’ Amma okin thoccokiethin thiak ana okin thaccokiet non thiak cakuruk. Ana amma okin thoccïkothe lon ila mpongkenet kin ana okin thaccïkot lon lon cakuruk. ");
INSERT INTO lmd_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Okin thakkot non menik nti ilon lokꞌran kin akka okin thomma okkwi ipothïothin. ");
INSERT INTO lmd_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Amma mpokat pakorronno anthan ana erenekin, okin thakorronno okat thamoloko llon ilokithak. Inenni okin thella lon cik ilakin orrot noka ken ngngin. ");
INSERT INTO lmd_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Okkwi ipꞌrarin, kwꞌrat ongappa cakuruk. ");
INSERT INTO lmd_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Amma mpappakorronno okkot lon ithoꞌrkït then ila pul pella pokkothe nan, okin thakorronno occot lon itti okin thokithak. Anaruk inenni okin thimmat lon ilommaththik ila mpokkothe anaruk okin tharthuk thꞌrarin ana ꞌra ongappa. ");
INSERT INTO lmd_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Anaruk elli lokkattathe othakka itti alothakka ammakka lokurrakot iatham wothonceꞌret lon cik len iliꞌre itti, ‘Lon lella ilakin thꞌrathin nan.’ ");
INSERT INTO lmd_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Amma okkwi ipittararot paat ipa anothïnthet non nangappa, Kanang ikupupure ikaik ïcat ikanthan naak, kerenenon lon lin. ");
INSERT INTO lmd_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Anaruk onon thonu itti onon theret cakuruk akka oron thokat cik uraththungon ncinomun.” ");
INSERT INTO lmd_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Mperenet non lon elli appik othakka itti annokorronno urttat cik. ");
INSERT INTO lmd_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Okin thathokïccet non thapat nocuththun caꞌrama, caꞌri caik canthan ica ul iangwonon ome itti okin thaik thakkinthet Kapik lon loporot. ");
INSERT INTO lmd_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Okin thakkot menik akka okin thomma ongappa ana manna okin thomman. ");
INSERT INTO lmd_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Mpiꞌrethenon lon elli othakka itti amma caꞌri cen caat anon okwarikot itti mpokat piꞌrethenon lon len. Mpokat pakinniꞌret non lon elli ncinomun akka oron thaththokat aththut.” ");
INSERT INTO lmd_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Anaruk inenni mpaik paine okkwi ipothïothin, ana manna pul pella nti ianon ipipittothin itti, ‘Ngkwaik paeo kereni?’ ");
INSERT INTO lmd_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Onon thakorronno oka thoporot noka akka mperenet non lon elli. ");
INSERT INTO lmd_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Anaruk mpaik perenenon lon ilaik ïcat, loporot nanon itti mpaeo akka amma mpakorronno eo okkwi ipittarot non pakorronno anthan. Anaruk amma mpeot ana mpathothïnthet non ngok. ");
INSERT INTO lmd_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Amma kwaat, kwangkene ul wonocapu lon lolon ilokithak ana ongkenekin itti okin thaka thoporot tat tokït koKapik ana ongkenekin lon lothakkma thoKapik. ");
INSERT INTO lmd_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Kwakenekin lon lothokithaka then akka okin thakorronno occokot lon lin nomïkït. ");
INSERT INTO lmd_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ana kwakenekin lon lothoka thoporot then tokït koKapik akka mpaik paine ongappa nanon okorronno appimman. ");
INSERT INTO lmd_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ana kwakenekin lon lothakkma thoKapik akka Kapik kakkmat pul pothopulut ntit ili wonocapu. ");
INSERT INTO lmd_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Mponu lon lanerenenon loppot inenni anaruk lalkot non. ");
INSERT INTO lmd_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Anaruk amma Kanang kolon ilaik ïcat anthan, kwangwot non ilon iloporot appik. Anaruk kere lon tulluk ila koccïkothe ana kerenenon lon ilaik lathanthan. ");
INSERT INTO lmd_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Kanang ken ikupupure kananin thrïk akka kaneko lon ila mponu itti mpiꞌret non akokenenon. ");
INSERT INTO lmd_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Aꞌrupu wongappa appik ien win, ilen akka mpiꞌrenet itti Kanang ikupupure kaneko nnolon lin akokenenon.” ");
INSERT INTO lmd_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Papotteik onon thakinnimman ana papotteik onon thimman.” ");
INSERT INTO lmd_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Aul iammakothok wꞌrek ikkat cik aerettarne itti, “Ngintha akkonu itti, ‘Papotteik onon thakorronno appimman ana papotteik onon thappimman,’ ana ngintha akka akwiꞌrene itti, ‘Akka mpaik paine ongappa pin’?” ");
INSERT INTO lmd_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Okin thoꞌrungkwathe nan akin ipitto itti, “Ngintha akkonu itti, ‘papotteik’? Oron thomma lon ila kwaik pere.” ");
INSERT INTO lmd_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","OIeccuo pinat nan itti okin thongothe itti okin thipittothok lon len, akwiꞌrekat kin itti, “Onon thaik thipittarot lon ila mpiꞌret itti, ‘Papotteik onon thakorronno imman ana papotteik onon thappimmani’? ");
INSERT INTO lmd_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Mpiꞌret non lon ilaik ïcat itti onon thangkꞌriko ana oo anaruk aul wonocapu ncik appik occiro ana opira noka. Onon thipo thiak anaruk thiak thon thaprttakoik ana thathakka thopira noka. ");
INSERT INTO lmd_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ka kakꞌrello pul ipopari amma apokwono ana ka kakꞌrellok akka caꞌri cung caat itti kwakwono anaruk amma ukul wokwontat kure nothokꞌrellako akka kwopirat noka nokkul itti wokwontathe nocapu appik. ");
INSERT INTO lmd_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ittina inenni caꞌri cothoccokot thiak con enci, anaruk mpappimma non ana onon thapira noka ana pul pella panekot non thopira noka thon. ");
INSERT INTO lmd_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Caꞌri cen onon thakorronno appipittothin papꞌrek aththik. Mpiꞌret non lon ilaik ïcat itti ongappa pethet non aꞌrupu appik ia annipitto ngkꞌran kin. ");
INSERT INTO lmd_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ana manna inenni onon thakorronno ipitto lon lꞌrek ngkꞌran kin aththik. Nipitto ana onon thacco ana thopira noka thaka thoporot kirrkkir. ");
INSERT INTO lmd_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Mpokat anere nthokkwie lon kuru ncik ana caꞌri canthan ica anokorronno erenenon nthokkwie lon kuru ncik anaruk mperenenon lon longappa nci nokkït. ");
INSERT INTO lmd_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Caꞌri cen, onon thipitto lon ngkꞌran kin. Mpaik pakorronno iꞌre itti mpipittinthet non ongappa nti ianon. ");
INSERT INTO lmd_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Aa, ongappa ngka kung pongothenon akka onon thongothin ana onon thoccokothe lon nomïkït itti mpaat noKapik. ");
INSERT INTO lmd_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Mpaat nangappa anao nocapu appik ana inenni mpaik paththe nocapu appik anopakkinthet ongappa.” ");
INSERT INTO lmd_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ittina aul woIeccuo iammakothok iꞌrekat itti, “Inenni ngkwaik pere lon nci nokkït, ngkwaik pakorronno ere okkwie lon kuru ncik. ");
INSERT INTO lmd_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ittina onïn thimmat itti ngkwina lon appik ana lakorronnoka manna itti ngkwipittakot lon lꞌrek, elli lakorronnonïn, anïn occokot lon nomïkït itti ngkwaat noKapik.” ");
INSERT INTO lmd_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","AIeccuo iꞌrekat itti, “Onon thantroccokot lon loKapik nomïkït mon ocothot pꞌrïn. ");
INSERT INTO lmd_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Anaruk caꞌri caik cao ana caat manna amma anon opettakot cik ikaman kon kurekkurek, onon thaththe naun pellek, anaruk mpakorronno oka pellek, ongappa paik naun. ");
INSERT INTO lmd_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Mpiꞌrethenon lon elli itti annapot mïkït cik. Onon thaccokiettat thiak cene nocapu ncik appik anaruk nopoꞌrathan, akka mpalkothe lon lonocapu appik.” ");
INSERT INTO lmd_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Manakka oIeccuo piꞌret lon elli, akwokathakat tothiꞌrot akwiꞌrekat itti, “Pappa, caꞌri cei caat pꞌrin ethet ukul wang thrïk othakka itti aukul wang ina akka ethung thrïk. ");
INSERT INTO lmd_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Akka ngkwethok ngili ikkun ngolon loul appik itti akwethet kin thikkoik thothupuththuput okkwion itha ngkwethok. ");
INSERT INTO lmd_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Thikkoik thothupuththuput itti akin inang, oung pellek ipaKapik ikaik ïcat, ana oIeccuo oMiccie ipa ngkwothïothe. ");
INSERT INTO lmd_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Mpokenet ul thrïk thang nocapu nthomartto ngre ia ngkwethin itti mpakkot. ");
INSERT INTO lmd_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ana inenni, ngappa, ethin thrïk nci na ngkwaik itharit thonat nci maꞌrot acapu appik carthuk okuꞌretta ncik.” ");
INSERT INTO lmd_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Mpokenet ul ia ngkwethin cene nocapu itti oung okkwen. Okin thokat thang ana ngkwethin kin ana okin thoccïkothe lon lang. ");
INSERT INTO lmd_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ana inenni okin thina itti aꞌrupu ncik appik ia ngkwethin waat naung. ");
INSERT INTO lmd_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Mpethet kin lon ila ngkwethin ana okin thoccokothe. Okin thinat ïcat itti mpaat naung ana okin thoccokothe lon nomïkït itti oung akkothïothin. ");
INSERT INTO lmd_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Mpaꞌranekin ngaꞌrama, anaruk mpaik pakorronno aꞌrane ul wocapu ncik appik anaruk mpaik paꞌrane okkwion itha ngkwethin akka okin thang. ");
INSERT INTO lmd_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ila mponu appik lang ana ila ngkwonu appik lin. Ana thrïk thainin nti iakin. ");
INSERT INTO lmd_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Mpaik pakorronno ikkoik nocapu ncik appik puccuk anaruk okin tharthuk thaik nocapu ncik appik ana mpaik painung. Ngappa ipupupure, angwothekin mpuꞌran pokꞌran kang, kꞌran ika ngkwethin othakka itti akin oka thulukku ammakka orit thulukku. ");
INSERT INTO lmd_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Caꞌri ica mpokat ïnaththut mpangwothekin ana oꞌrumo nakin ngkꞌran ika ngkwethin, opilin pellat ipuratheik tulluk okkulukku iponu itti kurat cik othakka itti alon okaik ammakka lokurrakot iatham woKapik. ");
INSERT INTO lmd_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Mperik painung anaruk mpiꞌre elli amparthuk paik nocapu othakka itti akin oppappat nthopira noka thin. ");
INSERT INTO lmd_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mpethet kin lon lang ana ul wonocapu enci wꞌrat akka okin thannoka thonocapu enci ammakka mpakannoka ponocapu enci. ");
INSERT INTO lmd_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Thaꞌra ngaꞌrama thin annoka itti aneko kin nocapu anaruk othakka itti angwot kin nti inyaun nyopul pothopulut. ");
INSERT INTO lmd_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Okin thakorronno oka thonocapu ncik appik ammakka mpakorronno oka ponocapu. ");
INSERT INTO lmd_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Othikkiekin thupupure llon ilaik ïcat, lon lang laik ïcat. ");
INSERT INTO lmd_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ammakka ngkwothïothin nocapu ana mpothïothekin nocapu cakuruk. ");
INSERT INTO lmd_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Mpakuccet ka kin cik anoreko nti ilon len othakka itti akin okuccekot cik cakuruk akin orekinung ïcat.” ");
INSERT INTO lmd_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Mpaik pakorronno aꞌranekin ngaꞌrama thellek. Mpaik paꞌrane okkwion cakuruk ithathoccokot lon lin amma okin thoccïkothe lon len. ");
INSERT INTO lmd_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Othakka itti akin oka thulukku appik, ngappa, ammakka ngkwaik iaun, mpaik iaung. Ana akin oka iarit othakka itti aul appik occokot lon nomïkït itti oung akkothïothin. ");
INSERT INTO lmd_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Mpethet kin thrïk itha ngkwethin othakka itti akin oka thulukku ammakka orit thulukku. ");
INSERT INTO lmd_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Mpaka iakin ana ngkwaka iaun, ittina okin thathakka thulukku othakka itti aul nocapu ina itti ngkwothïothin ana ngkwongothekin ammakka ngkwongothin. ");
INSERT INTO lmd_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ngappa, mpongothe itti ul ia ngkwethin wanïn oka aththut na anoka akin imma thrïk thin, thrïk itha ngkwethin akka ngkwongothin nci nomun acapu carthuk okuꞌretta ncik. ");
INSERT INTO lmd_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ngappa ipoporot, ul wonocapu wommang, mpinang ana okin thina itti ngkwothïothin. ");
INSERT INTO lmd_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mpokenerung kin ana mpaꞌrungkwot nan okeneng kin, athongat thang itha ngkwongothin oka iakin, ana oun ngka kin anoka iakin.” ");
INSERT INTO lmd_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Anakka oIeccuo pomarttot thaꞌra ngaꞌrama, kwoingkathe okin oul iammakothok arrot thupuꞌru thoKithurun. Nthocipit cothupuꞌru cꞌrek, kaꞌran kꞌrek kokat cik than konat kira koceththun, aIeccuo iꞌrikat tit akin oul iammakothok. ");
INSERT INTO lmd_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","OIoutha ipokerothe oIeccuo nili pinat nokaꞌran ken akka oIeccuo pokat than maꞌri moppot akwikikkoik than okin oul iammakothok. ");
INSERT INTO lmd_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ittina oIoutha pakkakathe cïnang nnul irro ana nili nꞌrek noul ittïttïk woul wonoppan toKapik ana ul woPriccin okin thokat akin onneko lik noꞌren ana arran. ");
INSERT INTO lmd_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ana akka oIeccuo pinat lon appik ilokat cik lathothakka, kwoppanthet kin thapat ana kwipittathekin itti, “Oththa akka annokwantot?” ");
INSERT INTO lmd_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Akin othïat tit itti onïn thaik thakwantot “OIeccuo poNaccir.” AIeccuo iꞌrekat kin itti, “Oun ook.” Ana oIoutha ipokerothok ul pokat cik akin ocoꞌro aththut. ");
INSERT INTO lmd_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Manakka oIeccuo piꞌret itti, “Oun pen,” akin opakkat thomeken akin apukkat nocapu appik. ");
INSERT INTO lmd_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Akwappipittat kin attang itti, “Oththa akka anon okwantot?” Akin iꞌrekat itti, “Onïn thaik thakwantot oIeccuo poNaccir.” ");
INSERT INTO lmd_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","AIeccuo iꞌrekat kin itti, “Akka mpiꞌrethenon itti oun ook. Amma onon thaik thakwantothin nokorronno aul enni eo.” ");
INSERT INTO lmd_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Elli lothakkat othakka itti alon lung ila kwappiꞌret othakka itti, “Mpakorronno uret opilin cik ntiakin itha ngkwethin.” ");
INSERT INTO lmd_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ittina aCcamaan oPoththuruc iponat kiꞌrittang ikukwit akwothat akwokiat kunu koMalkkac pul iparekine pul iprïk ponoppan toKapik. ");
INSERT INTO lmd_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","AIeccuo iꞌrekat oPoththuruc itti, “Opakkethe kiꞌrittang ikukwit ikaꞌruk, mpira pakorronno occokot thiak itha ngappa pothïothin itti mpaccokori?” ");
INSERT INTO lmd_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ittina aul irro ana ili wen ana nili nꞌrek noul woIouth occokat oIeccuo, akin ïꞌrïkïkkathok ");
INSERT INTO lmd_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","akin onakathok cittokït tokït kAnnan ipokat opïthe poKiappa pul iprïk ponoppan toKapik nothuput then. ");
INSERT INTO lmd_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","OKiappa ipappomethe ul woIouth itti laka loporot itti pul pio pulukku nti ilon loul appik. ");
INSERT INTO lmd_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","OCcamaan oPoththuruc ana pul ipammakothok wꞌrek thokat cik akin ommakot oIeccuo. Anakka pul ipammakothok pen pokat pinakot mpul iprïk ponoppan toKapik, kwiꞌrikathe okin oIeccuo ithaꞌrapak thonoppan topul iprïk ponoppan toKapik, ");
INSERT INTO lmd_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","anaruk oPoththuruc pokat cik akwoꞌrïkot cik thapat. Pul ipammakothok pꞌrek ipa pul iprïk ponoppan toKapik pokat pinat akkakat thapat aperekanthet ukul iopari iokat cik angwot cürük akwiꞌrikiekat oPoththuruc noppan. ");
INSERT INTO lmd_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Aukul iopari iokat icürük ipittat oPoththuruc itti, “Ngkwakorronno oka opilin nti iul iammakothoki, oung pai?” APoththuruc othïat tit itti, “Mpakorronno oka ïnaththungon.” ");
INSERT INTO lmd_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Cik cokat cirruk ana ul iarekine ul ana ul iangwot cik ikkat cik aïkot thik ana oPoththuruc pokat cik cïnang cakuruk akin aththungon akwïkot thik. ");
INSERT INTO lmd_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Apul iprïk ponoppan toKapik ipittat oIeccuo lon loul iammakothok ana lon lothongkene thung. ");
INSERT INTO lmd_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","AIeccuo othïanthok tit itti, “Mperenet ul appik nci nokkït ana mpokat cik anongkekkene nomuththun maꞌrama ana manna noppan toKapik na ul woIouth wokat aꞌrntattakot. Lella ila mpiꞌret nthuꞌran. ");
INSERT INTO lmd_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Nthontha akka annipittothin lon? Nipittot okkwion ithoccïkothe akka anere, okin thina ila mperet.” ");
INSERT INTO lmd_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Manakka oIeccuo piꞌret lon len apul ipangwot cik ipokat iccik kung okkwathok toca. Apiꞌrekathok itti, “Kathar engki akka erene pul iprïk ponoppan toKapik ngngini?” ");
INSERT INTO lmd_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","AIeccuo iꞌrekathok itti, “Amma mpiꞌret lon moloko akenen ila mpiꞌret moloko ana amma mpiꞌret lon oceꞌret cik, ngintha akka ngkwokkwinin?” ");
INSERT INTO lmd_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ittina Annan pothïathok naKiappa pul iprïk ponoppan toKapik akkwꞌrikikkakot. ");
INSERT INTO lmd_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Anakka oPoththuruc pokat cik akkwaik akwïkot thik akin appipittathok itti “Ngkwakorronno oka opilin nti iul iammakothoki oung pai?” Akwocukkat nan akwiꞌrekat itti, “Mpakorronno oka poul wothothïlettat wung.” ");
INSERT INTO lmd_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Apul pꞌrek iparekine pul iprïk ponoppan toKapik pokat kuꞌri kopul ipa oPoththuruc pappokiothe kunu cik, iꞌrekathok itti, “Mpannimmathung nokaꞌran kokira koceththuni?” ");
INSERT INTO lmd_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","APoththuruc appocukkwat nan, caꞌri cen athakꞌruk oa. ");
INSERT INTO lmd_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ana ngïꞌrïmak aul woIouth ipat oIeccuo ntuan toKiappa akin oingkathok ngngin tuan toili woRoma. Anaruk okin thakorronno iꞌrikat noppan ten akka okin thaththꞌrat itti okin thipot lon ilokithak noka ken akka okin okorronno oꞌrko thuꞌrit thokamuthe koThaurrot kaman kꞌrek cik. ");
INSERT INTO lmd_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","APilaththoc akkakanthet kin thapat akwipittat kin itti, “Lon liatha ila non thorukwethe pul empi ngngin?” ");
INSERT INTO lmd_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Akin othïanthok tit itti, “Amma kwappakorronno okkot lon moloko, onïn thakorronno onanung ngok cene.” ");
INSERT INTO lmd_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","APilaththoc iꞌrekat kin itti, “Nonekok annakkmak llon lothonceꞌret lon cik lon.” Akin othïat tit itti, “Onïn thella lon cik itti onïn thakkwot pul pꞌrek.” ");
INSERT INTO lmd_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Elli lokkattathe othakka itti alothakka ammakka oIeccuo piꞌret akweret thio thung itha kwaik pio. ");
INSERT INTO lmd_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","APilaththoc opakkat noppan toili akwakkarat oIeccuo akwipittathok itti, “Oung ili woIouthi?” ");
INSERT INTO lmd_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","AIeccuo ipittathok itti, “Lon ellrik langi, ana amma okorronno oka lang opilingon therenung lon lini?” ");
INSERT INTO lmd_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","APilaththoc othïanthok tit itti, “Ngkwame itti oun pul poIouthi? Ul wang ana ul ittïttïk woul wonoppan toKapik akkonarung, ngintha akka ngkwokkothe pamoloko?” ");
INSERT INTO lmd_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","AIeccuo iꞌrekat itti, “Ngili ngin ngakorronno oka ngonocapu ncik appik enci. Amma ngangokat ngonocapu ncik appik enci, ul iarekinin wrrothe naun itti ul woIouth wakorronno occokothin. Anaruk inenni ngili ngin ngonokaꞌran pellek.” ");
INSERT INTO lmd_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","APilaththoc omekat itti, “Ittina ngkwailina.” AIeccuo othïat tit itti, “Ngkwiꞌre itti mpaili. Ilen akka mpokwontanet ana ilen akka mpainet nocapu appik anathokene lon ilaik ïcat. Ana okkwi ipaik ilon ilaik ïcat, kwoccïkothin.” ");
INSERT INTO lmd_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","APilaththoc ipittat itti, “Ngintha akkonu itti lon ilaik ïcat?” Akka oPilaththoc piꞌret lon len, akwoppat thapat akwomekat ul woIouth attang itti, “Mpakanniot lon lꞌrek ilokithak nopul empi ila anakkmak ngngin. ");
INSERT INTO lmd_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Anaruk thathuma thon itti mpelikkinenon pul pꞌrek nti ikorrkkor nokamuthe koThaurrot kaman kꞌrek cik, onon thongothe itti mpelikkinenon ili woIouthi?” ");
INSERT INTO lmd_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Akin okkwat kuri itti, “Kirrnni elikkok, elikkinet nïn oParapac.” OParapac pokat pokkothe camutta akwereket ul nongili. ");
INSERT INTO lmd_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ittina aPilaththoc iꞌrekat ul wung itti okin thaneko oIeccuo akin othokkwekok. ");
INSERT INTO lmd_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Aul irro otherat tukwia tolï akin onekkekanthet oIeccuo ica. Akin akiekathok kret kothlo ere maa ika nili ako ");
INSERT INTO lmd_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ana okin thokat akin aukkwo akin okkwekok akin omethok itti, “Taththa Ili woIouth.” ");
INSERT INTO lmd_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","OPilaththoc appoppat thapat aiꞌrekat ul woIouth itti, “Mpaik pananenon ngok akka mpanniot lon ilakorronnok akwakkmako.” ");
INSERT INTO lmd_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Anakka oIeccuo poppothe thapat akkwakot lï ica lokkattathe ere cupul coili ana kret ikothlo ere maa, aPilaththoc omekat kin itti, “Nokathane pul pei.” ");
INSERT INTO lmd_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Manakka ul ittïttïk woul wonoppan toKapik ana ul iangwot tupan toKapik thimmat oIeccuo akin ikkat cik akin iꞌrekat lon mpoꞌre cittan itti, “Nokkwethok nothapak nokkwethok nothapak.” Anaruk oPilaththoc pothïanthet kin tit itti, “Nonekok annokkwethok nothapak akka mpakinniot lon ila anakkmak ngngin.” ");
INSERT INTO lmd_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Aul woIouth oꞌrungkat nolon aiꞌre itti, “Onïn thonu lon lothonceꞌret lon ncik ana ammakka lon len kwonu itti kwakkwettat nothapak akka kwiꞌrethe ka kung itti ook ukul woKapik.” ");
INSERT INTO lmd_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Manakka oPilaththoc poccïkothe lon elli akwipat manna nꞌre cannan ");
INSERT INTO lmd_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","akwopakkat noppan tung. Akwipittat oIeccuo itti, “Ngkwaat ngkartha?” Anaruk oIeccuo pangkatheik. ");
INSERT INTO lmd_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","APilaththoc iꞌrekathok itti, “Ngkꞌrat erenini?” Akwapprttat nan itti, “Ngkwomma itti mponu ngili ikkun itti mpelikkong ana manna itti mpakkwethung nothapaki?” ");
INSERT INTO lmd_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","AIeccuo othïat tit itti, “Ngkwakannonat puꞌran amma pappanettathung ntothiꞌrot. Ittina okkwi ipethin oung ikkun ponu lon lokithak cannan.” ");
INSERT INTO lmd_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ncïnang aPilaththoc enekkekat itti kwelikko oIeccuo anaruk ul woIouth wikkatheik aꞌretto itti, “Amma ngkwelikkot pul empi mono apeo ngkwakorronno oka opuruko poKaiccer akka okkwi ipiꞌret ka kung itti kwaili kworakket lon loKaiccer.” ");
INSERT INTO lmd_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Manakka oPilaththoc poccïkothe menik akwonakat oIeccuo thapat akwikkat cik noprrok pothakkma nocaꞌrakat conili iconat kꞌran itti Kapaththa ngKarru koIpranin. ");
INSERT INTO lmd_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Caꞌri cen cokat cothokuccekinthet kamuthe koThaurrot kaman kꞌrek cik ana cik cokat icïngkï ippa, aPilaththoc iꞌrekat ul woIouth itti, “Nokatha ili won wei cene.” ");
INSERT INTO lmd_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Anaruk okin thiꞌrekathe lon mpoꞌre cittan itti, “Opaꞌrek cik, opaꞌrek cik, nokkwethok nothapak.” APilaththoc ipittat itti, “Mpakkwinthet non ili woni?” Aul ittïttïk woul wonoppan toKapik iꞌrekat itti, “Onïn thella ili cik, oKkaiccer pulluk.” ");
INSERT INTO lmd_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Menik aPilaththoc eekat kin oIeccuo akwothokkwettat nothapak. Ittina aul irro onekat oIeccuo. ");
INSERT INTO lmd_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","AIeccuo onekat thapak itha akwothokkwettat nan, akwoingkat ngngin nokaꞌran ikoccot kꞌran itti kꞌrintil koca ilonu itti Culucutha ngKarru koIpranin. ");
INSERT INTO lmd_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Okin thokkwekathok nothapak nokaꞌran koCulcutha nnul wꞌrek weꞌra, opilin nthokkun wothokure ana opilin nthokkun wothothari ana oIeccuo ithoꞌrkït then. ");
INSERT INTO lmd_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","APilaththoc aꞌrekat lon nothapak lokurrakot itti, OIECCUO PONACCIR ILI WOIOUTH. ");
INSERT INTO lmd_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ul woppot woIouth wakkakkarathe lon len akka kaꞌran na aIeccuo pokkwettathe nothapak kokat napuththut nokaꞌran koUruccelim ana lon lalokurrakot ngkarru koul woIpranin ana koul woKrïk ana koul woRoma. ");
INSERT INTO lmd_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Aul ittïttïk woul wonoppan toKapik aꞌrettat naPilaththoc akin omekathok itti, “Kirrnni okurro itti, ‘Ili woIouth’ anaruk okurri itti pul empi piꞌret itti paIli woIouth.” ");
INSERT INTO lmd_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","APilaththoc iꞌrekat itti, “Lon ila mpokurrot mpokurrot pꞌrïn.” ");
INSERT INTO lmd_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Manakka ul irro wokkwethe oIeccuo nothapak akin onekat kret kung akin illillat tit mprak wocoꞌrin akin onekat wululuk ana akin onekat kret kulukku ikokat kannettettat ana kokat muang nci tompara mono uat ci noracok. ");
INSERT INTO lmd_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Akin iꞌrekat itti, “Ntrun okorronno illillorit, ntrun okkwot moꞌrio nan unokatha itti okkwen akkaneko.” Elli lothakkakathe ammakka atham wiꞌret itti lakkattat itti, “Okin thillillo iret win ana okkwot moꞌrio nokret kin konoka.” Elli akka ul irro wokkothe. ");
INSERT INTO lmd_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ana iccik kothapak itha oIeccuo pokkwettathe nan, onnan pokat cik akwocoꞌro nan ana opang ponnan ipopari ana oMeriom opari poKklopa ana oMeriom moMacthelia. ");
INSERT INTO lmd_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Anakka oIeccuo pimmat onnan akwocoꞌro cïnang akin opul pothothïlettat pung ipa kwappongothe cannan, kwiꞌrekathe onnan itti, “Pul ipopari, okatha ukul wang enrik.” ");
INSERT INTO lmd_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ana kwomekathe pul pothothïlettat pung itti, “Okatha onne perik.” Nci cïnang apul pung pothothïlettat emprïk onekat oMeriom tuan thanung. ");
INSERT INTO lmd_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ittina oIeccuo pinakathe itti lon appik lomttathe ana itti lon latham laik lathokkattat ammakka lokurrakot, akwiꞌrekat itti, “Pica paik pakkwothin.” ");
INSERT INTO lmd_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ana cakkolok cokat cik cïnang conat ngapak tit ior oppat, akin othapekat ngkret akin onekkekat nokwoꞌren akin okuꞌrekanthet oIeccuo ithon. ");
INSERT INTO lmd_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Anakka oIeccuo pinothe ngapak engrïk iokat ngor akwiꞌrekat itti, “Locothakothe pꞌrïn,” akuekat tocaik, akwokorronnat utha aeo nti iaak. ");
INSERT INTO lmd_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Caꞌri cen cokat caꞌri cothokuccekinthet caꞌri caCcepith cik icokat nokamuthe koThaurrot kaman kꞌrek cik. Anakka ul woIouth wakorronno angkot itti ummi wakwentako nothapak, okin thomekathe oPilaththoc itti ocottothe tacok toul iokkwettathe nothapak ana orpet kin cik nolapak akka okin thokat thꞌrat itti caꞌri caCcepith cathiot kin nolapak menik. ");
INSERT INTO lmd_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ittina aul irro akkakat akin ocottanthet okkworokit tacok ipa pokkuttathe nothapak akin oIeccuo ana topiling cakuruk. ");
INSERT INTO lmd_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Anakka okin thaat naIeccuo akin athiat itti kwiot ntit akin okorronnat ocottot tacok. ");
INSERT INTO lmd_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Apul pꞌrek nti iul irro ekat oIeccuo iunyït ngkathuk angüccük oppat aththaman ana ngꞌri. ");
INSERT INTO lmd_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Pul ipimmat lon len piꞌrekathe lon ana lon lung ila kwiꞌret laik ïcat ana kwinat itti kwiꞌret lon ïcat itti annoccokot lon len nomïkït. ");
INSERT INTO lmd_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Elli lokat cik othakka itti alon latham othakka ilokurrakot itti, “Cummian cung cella icacothako” ");
INSERT INTO lmd_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","ana ammakka lokurrakot nokaꞌran iatham wꞌrek cakuruk itti, “Okin thakatha okkwi iperat.” ");
INSERT INTO lmd_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Anakka oIeccuo piot, oIuccip ponokaꞌran koRami ipappokat pul pothothïlettat poIeccuo nthuꞌran akka kwonat nꞌre noul woIouth akkakat akwipittat oPilaththoc kumi koIeccuo itti kwakorronnok akwoneko. Ana oPilaththoc poccïkanthok akwakkakat akwonekat kumi koIeccuo. ");
INSERT INTO lmd_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Okin thokat cik okin oNikkothemoc ipappoinet oIeccuo thongkꞌra akkwonat kilu arrial (30) ana attul kamutha ana ngaak iakkunako ere amutha. ");
INSERT INTO lmd_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Akin onekat kumi koIeccuo akin oꞌremethekat kumi ikret akin okkat amutha nan kicce ikret kothocïkkararo. ");
INSERT INTO lmd_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ana nokaꞌran ikakin thaththokkwethe oIeccuo nothapak, kaꞌran kokira kotteik kꞌrek kokat cik than ana konat tupu tit tie takorronno ocïkkakot pul pꞌrek tit aththik. ");
INSERT INTO lmd_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Anakka caꞌri cokat coul woIouth cothokuccekinthet caꞌri caCcepith cik ana tupu tokat napuththut, okin thocïkkathe oIeccuo tit. ");
INSERT INTO lmd_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ana ngïꞌrïmak nocaꞌri corokït nomaꞌri imeꞌreꞌrapuruk, aMeriom moMacthelia oingkat thoppu ana ngïꞌrïmak ngokat cik akwimmakat pothok appopaꞌrettat cik ntoppu. ");
INSERT INTO lmd_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Akwollat oine oCcamaan oPoththuruc ana pul pothothïlettat pꞌrek ipa oIeccuo pappongothe, akwomekat kin itti, “Okin thonekot Ili nti ippu ana oron thomma nakin thonekkethok.” ");
INSERT INTO lmd_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","APoththuruc okin opul pothothïlettat poIeccuo pꞌrek oingkat thoppu. ");
INSERT INTO lmd_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Okin thokat akin opellettot tit aththuththuꞌra anaruk pul pothothïlettat poIeccuo pꞌrek purrathe oPoththuruc apakkakat thoppu tokït naak. ");
INSERT INTO lmd_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Apirrat cik, apokathakat cik ana pimmakathe eret iokat woꞌremethettathe oIeccuo awaik ceneket anaruk pakinniꞌrikat irpu than. ");
INSERT INTO lmd_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Anakka oPoththuruc ipokat thoceken paat, kwiꞌrikathe ippu ana kwimmakathe eret iokat woꞌremethettathe oIeccuo awaik ceneket, ");
INSERT INTO lmd_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ana kret ika kwocïkkakot ngngin ikokat noca coIeccuo kothettakotheik nokaꞌran kung pellek. ");
INSERT INTO lmd_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Apul pothothïlettat ipokat paat tokït iꞌrikat cakuruk ana pimmakathe ana poccokathe lon nocïkït. ");
INSERT INTO lmd_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Okin thaththarthuk thakinnina lon latham iliꞌre itti oIeccuo puroko nti ithio.) ");
INSERT INTO lmd_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ul iammakothok aureꞌra opakkat tuan na akin thokat akin ikkoik. ");
INSERT INTO lmd_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Anaruk oMeriom moMacthelia pocoꞌrothe thapat norupu akwoo. Anakka kwoot kwirratheik akwokathakat ippu, ");
INSERT INTO lmd_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","akwimmakat uꞌrupa wothothïlettat woKapik weꞌra wakot eret wipuk aikkoik nokaꞌran na ka koIeccuo kokat cik, opilin nthoca ana opilin nthoracok. ");
INSERT INTO lmd_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Auꞌrupa wothothïlettat woKapik wen ipittathok itti, “Pul ipopari ngkwontha akka aoo?” Akwiꞌrekat kin itti, “Okin thonekot Ili win ana mpomma nakin thonekkethok.” ");
INSERT INTO lmd_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Akka kwiꞌret menik akwolliakat thoceken cung akwimmakat oIeccuo akwocoꞌro ana kwommat itti oIeccuo. ");
INSERT INTO lmd_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","AIeccuo iꞌrekathok itti, “Pul ipopari, ngkwontha akka aoo? Ngkwaik pakwantot oththa?” AMeriom pokat cik akwopri pul pokarak, akwomekat pul pen itti, “Pït pin, amma oung akkonekorok, akenen na angkwonekkethok anothonekok.” ");
INSERT INTO lmd_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","AIeccuo iꞌrekathok itti, “Meriom.” Ameriom oprttakat iaak akwiꞌrekat mpoꞌre cittan itti, “Ropuni.” (Ilonu ngKarru koIpranin itti pul ipangkene.) ");
INSERT INTO lmd_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","AIeccuo iꞌrekathok itti, “Kirrnni occokothin akka mparthuk pakorronno opakkinthet ongappa anaruk ngkoinet opangkingon, aiꞌret kin itti ‘Mpaik pakuꞌrinthet ongappa pin ana pon ana Kapik kin ana kon.’” ");
INSERT INTO lmd_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","AMeriom moMacthelia opakkanthet ul woIeccuo iammakothok llon, akwiꞌrekat kin itti, “Mpimmat Ili oIeccuo.” Ana kwiꞌrekathekin lon ila oIeccuo perenok. ");
INSERT INTO lmd_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ana caꞌri cen cipin nocaꞌri corokït nomaꞌri imeꞌreꞌrapuruk, ul iammakothok wokat noppan nokaꞌran kulukku ana athat wunnukkwakothe kicce akka okin thonat nꞌre noul woIouth. OIeccuo pummanthet kin ncik akwocoꞌrat ithoꞌrkït then akwomiccat kin itti, “Ntharaththa?” ");
INSERT INTO lmd_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Manakkka kwomiccot kin akwokenekat kin nyaun ana iunyït, aul iammakothok opirakat noka cannan akka okin thimmat Ili oIeccuo. ");
INSERT INTO lmd_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","AIeccuo appomiccat kin akwiꞌrekat itti, “Ntharaththa? Ana ammakka ongappa pothïothin mpantappothïot non.” ");
INSERT INTO lmd_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Manakka kwiꞌret lon elli, akwokwat utha nakin, akwꞌrekat kin itti, “Nocco Kanang ikupupure. ");
INSERT INTO lmd_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Amma onon thoccïkïnthet opilingon lon ilokithak, laccïkakot ana amma onon thakannoccïkïnthet opilingon lon ilokithak ana lakannoccïkakot.” ");
INSERT INTO lmd_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ana nocaꞌri cen, pul ipammakothok nti iul attul ana ikken keꞌra iponat kꞌran itti oThthoma (ponat kꞌran cakuruk itti Tharo) papellat nocaꞌri ica oIeccuo paat nan. ");
INSERT INTO lmd_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Aul iammakothok wꞌrek iꞌrekathok itti, “Onïn thimmat Ili oIeccuo.” AThthoma omekat kin itti, “Mpakorronno occokot lon len nocïkït aththik amma mpakinnimma kaꞌran konyuppa nonyaun nyung ana othonto kaꞌran konyuppa mmaun min, ana othonto iunyït.” ");
INSERT INTO lmd_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Anakka maꞌri meot ncik meꞌreꞌrapuruk, aul iammakothok appaꞌrntakat noppan tulukku attang ana caꞌri cen aThthoma pokat cik akin aththungon ana athat wokat wunukkwakot kicce, aIeccuo akkakat akwocoꞌrat ithoꞌrkït then akwommiccat kin itti, “Ntharaththa?” ");
INSERT INTO lmd_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Akwiꞌrekat oThthoma itti, “Onekkethe caun cene, antokatha nyaun nyin. Othie ukun athonto iunyït win. Kirrnni ona mïkït meꞌra ilon, occokothe lon nocïkït.” ");
INSERT INTO lmd_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","AThthoma iꞌrekat itti, “Ili win ana Kapik kin.” ");
INSERT INTO lmd_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","AIeccuo iꞌrekathok itti, “Ngkwoccokothe lon nocïkït pꞌrin akka ngkwimmarini? Thopira noka thaka noul ioccokothe lon nomïkït akin thakinnimma lon lꞌrek.” ");
INSERT INTO lmd_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","OIeccuo pokkothe lon loppot ilommaththik tokït koul iammakothok, ilakannokurrakot iatham enni. ");
INSERT INTO lmd_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Anaruk elli lokurrakot othakka itti anon occokot lon nomïkït itti oIeccuo ook oMiccie ana ukul woKapik ana nthoccokot lon nomïkït, onon thiot thikkoik thothupuththuput ngkꞌran kung. ");
INSERT INTO lmd_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Manakka elli locothakothe aIeccuo appummanthet ul iammakothok ncik attang nokuthut korok irapangka toCelïl (iroccot kꞌran cakuruk itti tok irapangka toThipiria). Kumminthet kin ncik ngkathar engki. ");
INSERT INTO lmd_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ana caꞌri ica kumminthet kin okin thaththokat tothun oCcamaan oPoththuruc ana oThthoma iponat kꞌran itti Tharo ana oNaththanail ponokaꞌran koKana koCelïl, ana nyukul nyoCepethi ana ul woIeccuo iammakothok wꞌrek weꞌra. ");
INSERT INTO lmd_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","ACcamaan oPoththuruc iꞌrekat kin itti, “Mpaik paeo iape.” Akin iꞌrekathok itti, “Oron thaeo unnaththut.” Akin oingkat akin arrat ikuppuꞌrung konoiꞌri, anaruk caꞌri cen ngkoꞌra okin thakorronno occokat papꞌrek aththik. ");
INSERT INTO lmd_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ana ngngïꞌrïmak aIeccuo ocoꞌrat nokuthut korok, aul iammakothok wakinninakat itti ook oIeccuo. ");
INSERT INTO lmd_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Akwakkarat kin akwomekat kin itti, “Paththon, nthella ape wottei?” Akin omekat oIeccuo itti, “Papella.” ");
INSERT INTO lmd_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Akwomekat kin itti, “Norret loꞌrak lape thokkun wothothari wokuppuꞌrung konoiꞌri ana nthiꞌriththa ape.” Manakka okin thorrethe loꞌrak than, akin iꞌriththakat ape akin ommakat otho akka ape wokat woppot cannan. ");
INSERT INTO lmd_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Apul ipammakot oIeccuo ipa kwappongothe iꞌrekat oPoththuruc itti, “Katha Ili.” Anakka oPoththuruc poccïkothe lon itti, “Katha Ili” akwïꞌrïkakat kret kung ikïn akworpat iꞌri (akka kwokat puetheik). ");
INSERT INTO lmd_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Aul immakothok wꞌrek akkakat ngkuppuꞌrung konoiꞌri akin otho loꞌrak aloppathe ape tit akka okin thaththakonnoka ciththan nokuthut korok. ");
INSERT INTO lmd_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Anakka okin thorpotheik nocapu akin immakat monyïk mothik amonu ape nan ana arrakith. ");
INSERT INTO lmd_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","AIeccuo omekat kin itti, “Nona ape wotte nape ianon thiꞌriththat.” ");
INSERT INTO lmd_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","ACcamaan oPoththuruc arrat ikupppuꞌrung konoiꞌri akwothat loꞌrak lape tomarakan ana lonat ape tit ittïttïk arrial weꞌreꞌrapuruk ana alkaire ana ikken kꞌrapuruk (153) ana loꞌrak lape lakorronno ommottakat nape iokat tit woppot. ");
INSERT INTO lmd_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","AIeccuo iꞌrekat kin itti, “Nanthan annathoꞌrko thuꞌrit thorrot.” Opilin pellakathe nti iul iammakothok ipipittot itti, “Oung oththa” akka okin thaththina itti ook Ili oIeccuo. ");
INSERT INTO lmd_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","AIeccuo onekat arrakith akwekat kin, akwonekat ape cakuruk akwekat kin. ");
INSERT INTO lmd_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ana nocaꞌri nci oIeccuo pothikkiet maꞌri mꞌrapuruk akwumminthet ul iammakothok ncik ammakka kurokot nti ithio. ");
INSERT INTO lmd_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Anakka okin thoꞌrkot cik, aIeccuo iꞌrekat oCcamaan oPoththuruc itti, “Camaan ukul woIuanna, ngkwongothin cannan nolon elli appiki?” Akwothïanthok tit itti, “Ïï Ili win, ngkwinan itti mpongothung.” AIeccuo omekathok itti, “Oꞌrkie lungkat lin cik kicce.” ");
INSERT INTO lmd_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Akwappipittathok attang itti, “Camaan ukul woIuanna, ngkwongothini?” Akwothïanthok tit itti, “Ïï Ili win, ngkwinan itti mpongothung.” AIeccuo iꞌrekathok itti, “Okatha lon lolangkat lin.” ");
INSERT INTO lmd_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ana kwothikkiekathe maꞌri mꞌrapuruk akwipittothok itti, “Camaan ukul woIuanna, ngkwongothini?” APoththuruc uakat ka akka oIeccuo pipittothok lon othikkie maꞌri mꞌrapuruk itti, “Ngkwongothini?” Akwomekathok itti, “Ili win, ngkwina lon appik ana ngkwina itti mpongothung.” AIeccuo iꞌrekathok itti, “Oꞌrkie lungkat lin cik. ");
INSERT INTO lmd_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Mpiꞌret non lon ilaik ïcat itti caꞌri ica ngkwokat puꞌrit, ngkwokat ako eret ngkarkkang ana aeo na ngkwongothe itti ngkwaeo. Anaruk amma ngkwothakkat thomocco, ngkwathie nyaun akin akieng eret ana okin onekothung na ngkwꞌrat eo.” ");
INSERT INTO lmd_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","OIeccuo piꞌret elli akwokene thio itha oPoththuruc athio ana itha akwethet Kapik thrïk ngngin. Akwomekat oPoththuruc itti, “Omakothin.” ");
INSERT INTO lmd_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","APoththuruc olliakat akwimmakat itti pul ipammakot oIeccuo ipa oIeccuo pappongothe paik pammakot kin nthoceken, ook ipothïngkarakothe oIeccuo caꞌri icakin thokat akin oꞌrko thuꞌrit thocipin ana ipiꞌrethe oIeccuo itti, “Pul ipangkene, oththa akkaik pathokerong?” ");
INSERT INTO lmd_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Anakka oPoththuruc pimmarok akwiꞌrekat oIeccuo itti, “Ili win, ana lon loIuanna tat?” ");
INSERT INTO lmd_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","AIeccuo othïanthet oPoththuruc tit itti, “Amma oun akkongothe itti kwikkoik puccuk anakkakat, ngkwiꞌre taththa? Omakothin tulluk.” ");
INSERT INTO lmd_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Alon opettakat cik itti pul ipammakot oIeccuo empi pakinnio. Anaruk oIeccuo pakorronno omet oPoththuruc itti pakinnio anaruk kwomethok itti, “Amma oun akkongothe itti kwikkoik puccuk anokkaprttakat, ngkwontha oung?” ");
INSERT INTO lmd_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Pul poIeccuo ipammakothok empi ipokat cik akka lon lokkattathe ana ook akkokurrot. Onïn thina itti lon lung laik ïcat. ");
INSERT INTO lmd_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Lon laik loppot ila oIeccuo pokkothe anaruk amma lalokurrakothe appik ana mpakathe ere capu ncik appik cella kaꞌran cik na natham ikkoik inokurrakot.");
INSERT INTO lmd_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Pangkin oThiappiloc, iatham win worokït mperenthung aꞌrupu appik ila oIeccuo pokkothe ana ongkene nomaꞌri ima kurokiet ngre cik ");
INSERT INTO lmd_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","mono acaꞌri akkakat ica kwonekittathe nan tothiꞌrot. Ana akka kwarthuk onekittat tothiꞌrot, kwethet ul wung wothothïlettat lon lonthoththomat ngKanang ikupupure iakwapocumot nti ipangken. ");
INSERT INTO lmd_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ana akka kwoccokothe thiak kicce ana okkuttat, oIeccuo pikkatheik maꞌri arrial weꞌra (40) ana kummanthet ul enni ncik ana kwongkenekathe ngkathar koppot itti kwokat pakinnio. Kummanthet ul wothothïlettat wung ncik maꞌri moppot, akwerekanthet kin lon longili ngoKapik. ");
INSERT INTO lmd_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ana nocaꞌri cꞌrek akka kwokat cik akwoꞌrkoik okin aththungon, kwekathe lon elli ilonthomat itti, “Nokorronno oththe nokaꞌran koUruccelim anaruk noꞌrïkot thethet nuthuk itha ongappa ponekkenthet lon cik, ithanon thoccïkothe anerenenthet non. ");
INSERT INTO lmd_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Akka oIuanna pomamuthie pethet non mamuthie ngngꞌri anaruk nomaꞌri motteik, onon thacco mamuthie ngKanang ikupupure.” ");
INSERT INTO lmd_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ittina akka okin thokat ithun akin ipittat oIeccuo itti, “Ngkwaik pathopakkenthet ul woIccereil ngili?” ");
INSERT INTO lmd_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","AIeccuo iꞌrekat kin itti, “Lakannoka lon itti onon thina luput ana manna maꞌri ima ngappa ponekketheik mpuꞌran pung. ");
INSERT INTO lmd_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Anaruk onon thacco puꞌran amma Kanang ikupupure kaat nanon ana onon thaka ul win iimmat lon ngkït ana onon akkaka ierene opilingon lon lin nokaꞌran koUruccelim ana noththok poIouthia ana noththok poCcamira ana nocapu ncik appik.” ");
INSERT INTO lmd_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Anakka kwiꞌrethekin lon elli, kwonekittakathe tothiꞌrot ntokït ken, akin okathaccek ana nuththe noꞌrumathok akin okinnimmakathok. ");
INSERT INTO lmd_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Akin ikkat cik akin okathacceik tothiꞌrot akka oIeccuo pokat cik akwokuꞌrot tothiꞌrot. Ittina aul wꞌrek weꞌra iomura akkakat accokkot wakot eret wipuk acoꞌrot kin. ");
INSERT INTO lmd_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Aiꞌrekat kin itti, “Ul woCelïl, ngintha akka annocoꞌrine cen annokathacce tothiꞌrot, oIeccuo pen ikkalu iponekittathenon, akwonekittat tothiꞌrot kwakkaprttako ntan ammakka nthimmarok akwokuꞌrot tothiꞌrot.” ");
INSERT INTO lmd_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ittina okin thopakkathe nokaꞌran koUruccelim nocoꞌrong coCeththun icokat cakannoka ciththan nokaꞌran koUruccelim. ");
INSERT INTO lmd_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Anakka okin thaat akin okuꞌrat noppan toꞌra nakin thokat akin ikkoik. Okkwion ithokat thokat, oPoththuruc, oIuanna, oIakup, Anthrauc, oPilippic, oThthoma, oPerththolomauc, oMaththa, oIakup ukul wAlappaoc, oCcamaan ipokat pongothe lon loththok, ana oIoutha ukul woIakup. ");
INSERT INTO lmd_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Okin thokat akin aukko tothun appinappin akin oul iari wꞌrek ana oMeriom onnan poIeccuo ana opangon thoIeccuo ithomura akin aꞌra ngaꞌrama. ");
INSERT INTO lmd_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Nomaꞌri men oPoththuruc purokathe kapik ithoꞌrkït thoul ioccokothe lon loKapik, awaik mungkut mungkut arrial waꞌrakkuruk (120). ");
INSERT INTO lmd_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Ana kwiꞌrekathe itti, “Pangkingon, lon latham woKapik lonu itti lakkattat ila Kanang ikupupure kerenet oThauth lon loIoutha ook iponu ul ikkun ioccokothe oIeccuo. ");
INSERT INTO lmd_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ook ipokat oron aththungon ana kwokat iere uraththungon ngulukku ngoKapik.” ");
INSERT INTO lmd_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Ana akucci ia oIutha poccot nti ilon lung ilokithak, kwokerathe kopon na kwokorthothe calak cung akwiat akwapat akwekat ca ncik acarak othakakat cik anukkuk opporekat thapat. ");
INSERT INTO lmd_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ul appik wonokaꞌran koUruccelim woccïkathe lon len, ana wocciekathe kaꞌran ken kꞌran itti, Akkelthama ikonu itti 'capu coüccük.' ");
INSERT INTO lmd_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ana oPoththuruc piꞌrekathe itti, “Lokurrakot iatham woMocumur itti, ‘Akaꞌran kung ella pul ipikkoik nan, Ana opilin oneko kaꞌran kung kore ngung.’ ");
INSERT INTO lmd_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Menik laka itti pul pummunta nti iul iokat cik uraththungon nocaꞌri ica oIeccuo pokat iaron, ");
INSERT INTO lmd_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","nci nomamuthie moIuanna oingkanthet nocaꞌri ica oIeccuo ponekittat nanïn akwonekittat tothiꞌrot. Akka opilin nti ianïn ponu itti paka ianïn anïn otherene opilingon lon lothuroko thoIeccuo nti ithio.” ");
INSERT INTO lmd_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ittina okin thonekkekathe ul weꞌra cik, oIuccip iponat kꞌran itti oParccapa (iponat kꞌran cakuruk itti oIucththoc) ana oMaththiac. ");
INSERT INTO lmd_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Menik akin aꞌrakat ngaꞌrama itti, “Ili Kapik, ngkwina mïkït mïn appik, okenenïn nti iul enni weꞌra piatha nti akin ipa ngkwummot ntit ");
INSERT INTO lmd_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ipaneko ngre ngopul pothothïlettat pung ipa oIoutha poththet nan akweo nokaꞌran na kwonu itti kwaeo.” ");
INSERT INTO lmd_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ittina okin thokkwothe moꞌrio ana mapanthet oMaththiac akwarttakat noul wung wothothïlettat iattul ana ikken culukku akin okkat attul ana ikken keꞌra. ");
INSERT INTO lmd_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Anakka caꞌri caat coIouth cokamuthe kothokio mïl, okin thokat thaꞌrntakothe ithun nokaꞌran kulukku. ");
INSERT INTO lmd_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ittina apoꞌre pꞌrek akkakat accokkot pokanang akokkurarot koppot ntothiꞌrot ana koppakathe man nakin thokat cik akin ikkoik. ");
INSERT INTO lmd_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Okin thimmakathe aꞌrupu wꞌrek wungkot luꞌre lolik ana wakkakathe aꞌrat noꞌra wen kurekkurek appik ammakka okin thokat cik. ");
INSERT INTO lmd_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Kanang ikupupure koppappakathe iakin ana okin thikkatheik akin ere ngkarru ikakin thokat thommat ere ammakka Kanang kiniet kin. ");
INSERT INTO lmd_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Caꞌri cen ul woIouth ionat nꞌre noKapik nomoꞌrong appik imaik nocapu wokat cik aikkoik nokaꞌran koUruccelim. ");
INSERT INTO lmd_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Anakka okin thoccïkothe poꞌre pen, acungkut coul akkakat tothun acikkat cik acoprttakot tit akka okin kurekkurek thoccïkothe aul ioccokothe lon loKapik aere ngkarru koul iokat cik accïkot lon len. ");
INSERT INTO lmd_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ittina aul oprttakat tit, akin ipittat itti, “Ul enni woCelïl iaik werei? ");
INSERT INTO lmd_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ana tat akka oron occïkot akin ere ngkarru konnon. ");
INSERT INTO lmd_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Oron thoPrththon ana thoMathion ana thoIlamion ana ul iaik noththok poMaccappaththomia ana iaik noththok poIouthia ana poKkapthokkia ana Piniththic ana pAccia, ");
INSERT INTO lmd_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ana poPricia ana poMippilia ana poMuccir ana aꞌran wꞌrek woLipia iaik iccik koKirin ana ul iaat nokaꞌran koRoma, ");
INSERT INTO lmd_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","(Ul woIouth ana ul ioccokothe lon nomïkït ila ul woIouth woccokothe) ana ul wonocrakan corirok coKkrit ana Muththu anïn occïkot akka akin ere ngkarru kïn ana akin eret lon ilommaththik ila Kapik kokkothe.” ");
INSERT INTO lmd_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Okin thikkatheik akin oprttakot tit ana akin ipittarot itti, “Lon elli lonu itti kaththa?” ");
INSERT INTO lmd_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Opilingon thokkathe ngure nakin akin iꞌrekat itti, “Okin thïkkot ngapak ngoppot.” ");
INSERT INTO lmd_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ittina oPoththuruc purokathe kapik okin oul wung wothothïlettat iattul ana ikken culukku, akwikkat cik akwerene ul mpoꞌre cittan itti, “Ul woIouth ana onon appik ithaik cene nokaꞌran koUruccelim, nokorronnon anerenenon lon elli, noccïkothin annokkwat unu ncik nolon ila niꞌret non. ");
INSERT INTO lmd_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ul enni wonnïkko ngapak ammakka onon thiꞌret, cïngkï cokkothe ukullacoꞌrin cocik corrot. ");
INSERT INTO lmd_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ilen elli akka pul pothernte lon loKapik oIoil pappiꞌret akka kwiꞌret itti, ");
INSERT INTO lmd_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Nocaꞌri cothocothakot Kapik kiꞌret itti, Mpethet ul appik Kanang kin ikupupure. Nyukul inyomura ana inyari nyere lon ammakka ul wothernte lon loul woKapik, ul wang iomura wimma lon ilaik ana ul iocokkat wathantako thathantako. ");
INSERT INTO lmd_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ana manna noul iarekinin iomura ana iari, mpethet ul Kanang ikupupure nomaꞌri men ana okin there ammakka ul wothernte lon loul woKapik. ");
INSERT INTO lmd_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Mpakene lon ilommaththik tothiꞌrot ana lon ilakene lon nocapu thaiken, ngüccük ana thik ana kucuk keththung ere konïca. ");
INSERT INTO lmd_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Cïngkï cathakka ngïꞌrïmak ana kwanok kaꞌriat cik ere ngüccük, acaꞌri carthuk anthan icïrïk ana cothrïk thoIli. ");
INSERT INTO lmd_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ana okkwi ipaꞌra ngaꞌrama ngkꞌran koIli kwaꞌrettat.’” ");
INSERT INTO lmd_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","APoththuruc apperekanthet kin akwiꞌrekat itti, “Ul woIccereil, noccïkot lon elli, oIeccuo poNaccir pokat pul ipa Kapik kekkiet nan nanon nthokkot thung lon ilommaththik ana lon ilakene pangken ammakka onon ngka kon thina. ");
INSERT INTO lmd_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Pul empi pettathenon ikkun llon laKapik kinat nan ana ul iokithak wittarothenon ana onon thokkwothok nthokkwethok nothapak. ");
INSERT INTO lmd_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Anaruk Kapik kurokierok nti ithio ana elikkok nti ithoccokot thiak thothio, akka thio thellat puꞌran itti thaꞌrungkot naak. ");
INSERT INTO lmd_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","OThauth paperethok akkwiꞌret itti, ‘Mpimmathe Ili tokït kin. Akka waik thokkun wothothari win, Mpakorronno appipo nꞌre. ");
INSERT INTO lmd_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ittina cïkït cin copirat noka ana mpapirane Kapik noka, ana ka kin cakuruk kikkoik nthoꞌrïkot cik, ");
INSERT INTO lmd_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","akka ngkwannoththe naun aniat ciki ippu, ana manna ngkwannokorronno piak pang apokutta. ");
INSERT INTO lmd_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ngkwokenerin athar wothikkoik, ana ngkwakorronnon anopira noka tokït kang.’ ");
INSERT INTO lmd_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Pangkingon, mperenenon ncinokkït itti, opiki ponnon Ili oThauth piot ana kwocïkkakot ana tupu tung tei cene manna inenni. ");
INSERT INTO lmd_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Anaruk kwokat pul pothernte lon loKapik ana kwinat itti Kapik konekkenthok lon cik, nthakkwo mio itti kwanekket pul pothiki thung noprrok pung. ");
INSERT INTO lmd_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ana akka kwinat lon ilathokaik, kwerethe thuroko thoMiccie cakuruk itti Kapik kannokorronnok ippu ana manna ka kung kannokutta. ");
INSERT INTO lmd_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Kapik kurokiet oIeccuo nti ithio ana onïn thimmat lon len ngkït kïn. ");
INSERT INTO lmd_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Kapik kothikkierok pothiakinet cik ana kwoccot Kanang ikupupure ika Kapik kokat konekkethe lon cik itti kethok ana kwekatheron ana iken akka onon thaik thakathacce ana occïkot. ");
INSERT INTO lmd_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","OThauth pappannokuꞌrot tothiꞌrot anaruk kwappiꞌret icci itti, ‘Ili Kapik wiꞌrethe Ili win itti, Ikkik thokkun wothothari win, ");
INSERT INTO lmd_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","puccuk analkanthung thoꞌrak thang, acukkwarat kin cik ntacok tang.’ ");
INSERT INTO lmd_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Ittina kirrnni aul woIccereil ina itti, Kapik kokkothe oIeccuo ipanon thokkwethe nothapak Ili ana oMiccie.” ");
INSERT INTO lmd_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Manakka ul woccïkothe lon elli, okin thikkat cik akin oprttakot tit akin iꞌrekat oPoththuruc ana opilingon nti iul wung wothothïlettat itti, “Pangkingon, ngintha akka onïn okkot?” ");
INSERT INTO lmd_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","APoththuruc othïat tit itti, “Nokkaprttako nti ilon ilokithak annocco mamuthie ngkꞌran koIeccuo oMiccie, alon lon ilokithak occïkakinthet non. Ana Kapik kethet non Kanang ikupupure. ");
INSERT INTO lmd_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Akka thonekket lon cik itha Kapik konekketheik thon ana thonyukul nyon ana thoul iaik ciththan, ul appik ia Ili Kapik konnon kakkaro.” ");
INSERT INTO lmd_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","OPoththuruc perekanthet kin ana aꞌretto nakin llon loppot lonthoththomat itti, “Noꞌret ka kon nti ilon loul iokithak wonomaꞌri emmi.” ");
INSERT INTO lmd_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ana Kapik karttathe noul ioccokathe lon loIeccuo nomïkït ana woccathe mamuthie. Okin thokat athar wꞌrapuruk (3,000) iarttakothe noul. ");
INSERT INTO lmd_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Okin thiꞌrikathe ilon lothongkene loul wothothïlettat woIeccuo akin aukko tothun akin oꞌrko thuꞌrit ithun ana thuꞌrit thoIli thocipin ana aꞌra ngaꞌrama. ");
INSERT INTO lmd_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ul wothothïlettat woIeccuo wokkathe lon ilommaththik loppot ana ul appik woprttakatherit nolon len. ");
INSERT INTO lmd_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Okin ithoccokathe lon loKapik thokakathe ithun ana akin ikkettot aꞌrupu ana okkot lon appik tothun. ");
INSERT INTO lmd_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Akin okette aꞌrupu wen akin ikket ul aꞌrupu iellat aꞌrupu cik. ");
INSERT INTO lmd_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Okin thikkatheik akin ocurttot noppan toKapik appinappin. Ana akin oꞌrko thuꞌrit thoIli thocipin tothun ana okin thoꞌrkothe ikaman mmïkït moporot, ");
INSERT INTO lmd_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","aul wꞌrek omerekat Kapik ana opira noka nothoporot thoul iakin thaik. Ana Ili wikkatheik arttot ul nakin appinappin iokat cik aꞌrettat. ");
INSERT INTO lmd_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Caꞌri cꞌrek cokat cik, aPoththuruc ana oIuanna thokat cik akin eo noppan toKapik nocïngkï caꞌrama acïngkï cokkothe cꞌrapuruk cipin. ");
INSERT INTO lmd_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ittina ul wꞌrek wokat cik aneko pul pokat pꞌrek pokat pakimico nci ammakka pokwontat, ana kwokat akwonekkettat icürük icaeo noppan toKapik coccot kꞌran itti 'cürük icopeththere,' pul pen pokat apipittittot ul akucci amma waat itti wathaꞌra ngaꞌrama noppan toKapik. ");
INSERT INTO lmd_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Anakka kwimmat oPoththuruc ana oIuanna akin iꞌriko noppan toKapik, akwipittat kin akucci. ");
INSERT INTO lmd_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","APoththuruc ana oIuanna thokathakathok ciki ikït, aPoththuruc iꞌrekathok itti, “Antokatha nïn.” ");
INSERT INTO lmd_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ittina akwokathakat kin papenang akwiꞌre itti kwaik pacco papꞌrek nakin. ");
INSERT INTO lmd_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","APoththuruc iꞌrekathok itti, “Mpella mallong imallio ana manna thaap anaruk mpethung ia mponu, ngkꞌran koIeccuo oMiccie poNaccir, uroki anyaro.” ");
INSERT INTO lmd_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Akwoccokathok nukun wothothari akurokiekathok kapik awek othakkakat woporot. ");
INSERT INTO lmd_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Akwikkat cik akwirrot kapik noracok ana akwonyaro. Ittina akwomakat kin noppan toKapik akwonyaro ana akworottopo akwomereket Kapik nthopira noka. ");
INSERT INTO lmd_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Anakka ul wimmarok akwonyaro ana omereket Kapik, ");
INSERT INTO lmd_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","akin inakathok itti ook ipikikkoik tocürük conoppan toKapik icoccot kꞌran itti 'cürük icopeththere' akwipittot ul aꞌrupu ana okin thoprttakatherit ana irro mïkït nti ikarak nolon ilokkattanthok. ");
INSERT INTO lmd_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Pul ipipitto pꞌrakatheik naPoththuruc ana oIuanna. Ul appik waprttakatherit ana wollathe takin ithrara thoCiliman irokat noppan toKapik. ");
INSERT INTO lmd_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Anakka oPoththuruc pimmat lon len akwiꞌrekat itti, “Ul woIccereil, ngintha akka anon oprttakinthet tit nolon elli? Ngintha akka annokathaccenenïn ere onïn akkonyarien pul empi mpuꞌran pïn ana manna akka onïn thaik thikkoik thikkoik thoKapik? ");
INSERT INTO lmd_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Kapik kAprein ana koIccaak ana koIakup, Kapik kongappan akkothikkiet pul iparekinok prïk oIeccuo ipanon thethet nili akwothokkuttat, ana onon thocukkwot nolon itti onon thinak tokït koPilaththoc ipiꞌret itti kwelikkok. ");
INSERT INTO lmd_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Onon thocukkwot nolon itti nthina okkwi ipupupure ana ipoporot tokït koKapik, annipitto itti okkwi ipangwo ul pelikkako. ");
INSERT INTO lmd_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Onon thokkwothe pul iponu thikkoik ikkun anaruk Kapik kurokierok nti ithio. Onïn thimmat ngkït kïn. ");
INSERT INTO lmd_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Nthoccokot lon loKapik nocïkït ngkꞌran koIeccuo pul empi ipanon thimmat ana onon thinak pothakkat poporot. Lon ila nthimmat ana ina, lokkattathe nthoccokot lon nocïkït lokꞌran kung, okat thoccokot lon nocïkït loIeccuo akkokorronnorok akwothakka poporot, ammakka onon appik thimmat.” ");
INSERT INTO lmd_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","APoththuruc apperekat akwiꞌre itti, “Pangkingon, mpina inenni itti lon ilanon ana nili non thokkothe naIeccuo, nthokkothe anthommat lon lꞌrek. ");
INSERT INTO lmd_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Anaruk kathar engki akka Kapik kokkothe llon ila kiꞌret nul wothernte lon loKapik itti oMiccie pung pathoccokot thiak. ");
INSERT INTO lmd_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Nopaꞌrine lon ilokithak cik onnopakkinthet Kapik, othakka itti alon lon ilokithak occïkakinthet non ");
INSERT INTO lmd_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","othakka itti akwothïot oMiccie ipokat ponekkettanethet non cik ana manna oIeccuo. ");
INSERT INTO lmd_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Kwonu itti kwaꞌrungkot tothiꞌrot puccuk acaꞌri akkakat ica Kapik othikkie aꞌrupu appik wie ammakka kwonekkethe lon cik maꞌrot nul wung wothernte lon loKapik iupupure. ");
INSERT INTO lmd_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Akka oMucca piꞌret itti, ‘Ili Kapik kon wananenon pul pothernte lon loKapik pammakka oun nti iul won, onon thonu itti nthaccïkot lon appik ila akwerenenon. ");
INSERT INTO lmd_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Okkwi ipꞌrat occïkothok kwapaꞌrettaik nti iul wung.’ ");
INSERT INTO lmd_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","OCcamuil ana ul wꞌrek wothernte lon loKapik iomakothok okin therethe maꞌri emmi. ");
INSERT INTO lmd_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ana onon thanyukul nyoul wothernte lon loKapik ana nyothonekket lon cik ila Kapik konekkethe cik okin oththen ammakka kwiꞌrethe Aprein itti, ‘Nti ithiki thang enthi, mpethïet ul cik nocapu appik.’ ");
INSERT INTO lmd_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Anakka Kapik kurokiet oIeccuo pul iparekinok, kwothïathok nanon cittokït akwothethïenon, nthoprttonon cik nti iathar won iokokithak annopakkinthet Kapik.” ");
INSERT INTO lmd_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Anakka oPoththuruc ana oIuanna thokat cik akin erene ul, menik aul akkakat wonoppan toKapik ana ili woul iangwot cik ana ul woCathukkin. ");
INSERT INTO lmd_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Okin thokat thannopira noka akka oPoththuruc ana oIuanna thokat cik akin ongkene ul lon lothuroko thoIeccuo ana itti okkwion ithoccokothe lon lung thuroko. ");
INSERT INTO lmd_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Okin thoccokathekin akin onekkeket kin ikorrkkor akin aꞌriekat kin cik akka cik cokat ceot. ");
INSERT INTO lmd_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Anaruk ul ioccïkothe lon len woccokathe lon loKapik nomïkït ana wokat maun athar ukuluk (5,000). ");
INSERT INTO lmd_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ana ngorrot ngen, nili ana ul ittïttïk woul ana ul iangkene lon lothonceꞌret lon cik waꞌrntakathe nokaꞌran koUruccelim. ");
INSERT INTO lmd_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anan pul iprïk ponoppan toKapik ana oKiappa thokat cik ceneket ana cakuruk oIuanna ana Alekenther ana ul appik wokuꞌri ittïttïk woul wonoppan toKapik. ");
INSERT INTO lmd_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Okin thakkarathe oPoththuruc ana oIuanna ana okin thikkatheik akin ipittot kin lon itti, “Onon thokkothe lon elli ngkꞌran koththa ana manna mpuꞌran poththa?” ");
INSERT INTO lmd_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Menik aPoththuruc ngKanang ikupupure noka akwiꞌrekat kin itti, “Nili ana ul ittïttïk woul, ");
INSERT INTO lmd_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","amma onïn thakkarakot itti onïn thipittakot lon iloporot ilokkattanthet nopul ipokat cik kimico ana tat akka pothikkiettat poporot, ");
INSERT INTO lmd_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ittina onon thonu itti nthina lon elli, onon ana ul appik woIccereil, ana laik itti pul empi ipacoꞌro tokït kon pothakkat poporot ngkꞌran koIeccuo oMiccie poNaccir ipanon thokkwothe nothapak anaruk Kapik kurokierok nti ithio. ");
INSERT INTO lmd_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","OIeccuo ook ipa atham woKapik werethe itti, ‘Ook pothok pocillang ipoporot ipanon ul iuno wꞌrat, ana pothakkathe cillang icrïk.’ ");
INSERT INTO lmd_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Thoꞌrettat thannincat nopul pꞌrek akka kꞌran kꞌrek kella nocapu ika Kapik kethet ul ikaron oꞌrettat ngngin.” ");
INSERT INTO lmd_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Anakka okin thimmat kathar ika Poththuruc ana oIuanna theret ngngin, akin inakat okin thokat ul iannokurro. Anaruk okin thoprttakathe tit ana okin thaththiat itti ul enni wokat okin oIeccuo. ");
INSERT INTO lmd_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Anaruk akka okin thokat akin okathacce pul ipothakkat poporot akka apocoꞌro okin oPoththuruc ana oIuanna, okin thellakathe lon lꞌrek ilakin appiꞌre. ");
INSERT INTO lmd_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ittina okin thiꞌrekathekin itti okin thaeo nnoppan toCuththun coul woIouth ittïttïk ana okin thikkatheik akin erettarne. ");
INSERT INTO lmd_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Akin ipittarat itti, “Oron thakkot taththa noul enni? Akka ul appik wonokaꞌran koUruccelim wimmat lon ilommaththik ilakin thokkothe ana oron thannocukko nolon ilokkattathe. ");
INSERT INTO lmd_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Anaruk ntrun oceꞌre lon len akka alopettakot cik iul appik, oron thiꞌret kin lon lonthoththomat itti akin oceꞌre therene ul ana okorronno ongkene ul ngkꞌran koIeccuo.” ");
INSERT INTO lmd_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ittina okin thakkarathekin nthapat akin iꞌrekat kin lon lonthoththomat itti akin okorronno ongkene ul ana manna erene ngkꞌran koIeccuo. ");
INSERT INTO lmd_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Anaruk oPoththuruc ana oIuanna thiꞌrekathekin itti “Nipittot kakon liatha akkocoꞌrotheik itti onïn thaccïkot non ïnokorronno Kapiki? ");
INSERT INTO lmd_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Akka onïn thannocoꞌro nti ilon ilanïn thimmat ana occïkot nunu wïn.” ");
INSERT INTO lmd_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Menik akin appiꞌrekat kin lon lonthoththomat cannan akin okorronnat kin akin eo. Okin thokat thanniot kathar ikakin akkma kin ngngin akka ul wokat appik apirane Kapik noka nti ilon ilokkattathe. ");
INSERT INTO lmd_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Akka pul ipothikkiettat poporot llon ilommaththik ponat luput larrothe arrial weꞌra cik (40). ");
INSERT INTO lmd_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Anakka oPoththuruc ana oIuanna thelikkakot okin thopakkanthet ul wen akin erekanthet kin lon ila ul ittïttïk wonoppan toKapik ana ul ittïttïk woul wiꞌrethekin. ");
INSERT INTO lmd_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Anakka okin thoccïkothe akin ikkat cik akin aꞌrane Kapik ngaꞌrama mpoꞌre cittan itti, “Ili Kapik, ngkwokkothe tothiꞌrot ana capu ana nok inapangka ana aꞌrupu appik tit. ");
INSERT INTO lmd_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ngkweret ngKanang ikupupure nthon thopul iparekinung ongappa pïn oThauth itti, ‘Ngintha akka ul wokat wuanet ka? Ana ipot lon cik ilokithak? ");
INSERT INTO lmd_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Nili nonocapu nurokwot ana naꞌrntakothe ithun anorro iIli, ana iakkwi poꞌruttat ngaak.’ ");
INSERT INTO lmd_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","OIruthuc ana oPilaththoc oPunththioc ana ul iakonnoka woIouth ana ul woIccereil waꞌrntakathe nokaꞌran engki aprttakot ipul iparekinung ipupure oIeccuo ipa ngkwothikkiet oMiccie. ");
INSERT INTO lmd_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Okin thokkothe ila puꞌran pang ana ila ngkwonekketheik itti lakkattat alarthuk okkattat. ");
INSERT INTO lmd_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ana inenni Ili, katha kathar ikakin thaik thïꞌrïlenïn ngngin, ethet nïn puꞌran pang onïn iak wang ïnnere lon lang ella nꞌre. ");
INSERT INTO lmd_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Othie ukun aittiet ul iongo ana okkot lon ilommaththik ngkꞌran kokkul wang ikupupure oIeccuo.” ");
INSERT INTO lmd_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Anakka okin thaꞌrat ngaꞌrama akaꞌran ikakin thokat cik tit kikkatheik akaꞌrïntïttako ncik. Ana Kanang ikupupure koꞌrathe nakin appik ana okin thikkatheik akin ere lon loKapik ella nꞌre. ");
INSERT INTO lmd_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ana okin appik ithoccokothe lon loKapik thonat lon lulukku nomïkït men ana ima. Okin thokat akin illillo iaꞌrupu appik ithun iakin thonu, pul pellat ipiꞌre itti aꞌrupu ia kwonu wung pellek. ");
INSERT INTO lmd_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ul wothothïlettat woIeccuo wikkatheik aere lon lothuroko thoIli oIeccuo nti ithio mpuꞌran poKapik, ana thoporot thoKapik thoppot thokat nakin appik. ");
INSERT INTO lmd_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Pul pellat iakin ipiꞌre itti pellat papꞌrek. Akka ul ionat mapu ana manna kaman wokat cik akette kaman kꞌrek ken ana mapu anane ul wothothïlettat wung akucci wen ");
INSERT INTO lmd_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","akin ipot tokït ken aikkettat okkwion ithella aꞌrupu cik. ");
INSERT INTO lmd_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ammakka oIuccip poul woLaui ponoththok poKupruc pokkothe ook ipa ul wothothïlettat woIeccuo wakkarot itti oParnapa ilonu itti 'ukul wothittarot.' ");
INSERT INTO lmd_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Kwokerot kopon kung ana capu ana kwonakathe akucci akwonekkekat tokït koul wothothïlettat woIeccuo. ");
INSERT INTO lmd_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Anaruk pul pꞌrek pokat cik poccot kꞌran itti Anania ana opari itti oCceppira thokettet mapu men cakuruk imakin thaththonat. ");
INSERT INTO lmd_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Akin erettaranthet akin opari itti kwammothot akucci wꞌrek cik woka kung ana aꞌrek akwonekanthet ul wothothïlettat woIeccuo akwonekkekat tokït ken. ");
INSERT INTO lmd_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Menik aPoththuruc iꞌrekathok itti, “Anania, ngkwontha akka pul pothopulut peot nocïkït cang ana ngkwammikkothe Kanang ikupupure ana ngkwamuꞌruttot akucci wꞌrek ia ngkwokerot ncapu ana naꞌrupu ia ngkwonat ana ngkwiꞌret itti ngkwonat appik. ");
INSERT INTO lmd_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Capu cokat cang angkwarthuk okero pai? Ana akka kokettat akucci wokat wannoka wangi? Ngintha akkokorronnorung akkot lon elli? Ngkwannammikkot pul iponyi anaruk ngkwammikkothe Kapik.” ");
INSERT INTO lmd_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Anakka Anania poccïkothe lon elli, akwapat akwiat. Aul ioccïkothe ipat nꞌre nolon len ilokkattathe. ");
INSERT INTO lmd_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ittina aul iouꞌrit akkakat aïꞌrïkïkkathok kicce anekathok athocïkkathok. ");
INSERT INTO lmd_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Anakka mïngkï meot ncik mꞌrapuruk apari akkakat noppan akkwommat itti ngimpen akkokat cik. ");
INSERT INTO lmd_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","OPoththuruc ipittathok itti, “Antiꞌrethin, cekerek enci icanon thokerot capu ngngin annolle pangi?” Akwiꞌrekathok itti, “Ïï icen enci.” ");
INSERT INTO lmd_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","APoththuruc iꞌrekathok itti, “Onon therethe ithun annolle pang itti onon thenekke Kanang koIli akaintha? Okatha cene, ul enni waat nthapat waththocïkko olle pang ana okin thapponekong cakuruk akin othocïkkong.” ");
INSERT INTO lmd_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ncïnang akwapat noracok toPoththuruc akwiat, menik aul wꞌrek iouꞌrit iꞌrikat ntan noppan athiathok akkwiot ana wonekathok athocïkkok iccik kolle. ");
INSERT INTO lmd_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ittina aul ioccokothe lon loIeccuo ipat nꞌre appik ana ul ioccïkothe lon len ilokkattathe. ");
INSERT INTO lmd_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ul wothothïlettat woIeccuo wokkathe lon iloporot ana lon ilommaththik iul. Ana ul appik ioccokothe lon loIeccuo nomïkït wikkatheik aꞌrntattakot ithrara thoCiliman iokat wokat noppan toKapik ");
INSERT INTO lmd_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Apul ellakat nthapat iponat thiak itti piꞌriko iakin anaruk ul appik wikkatheik aeret kin llon loporot. ");
INSERT INTO lmd_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Anaruk ul iomura ana iari appik warttakathe nan ithoccokot lon loIli woppot. ");
INSERT INTO lmd_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Lon ila ul wothothïlettat woIeccuo wokkothe lokarnnathe ul aanna ul iongo akin ipot nonaꞌrangkal ana nouppuꞌrung ikathar othakka itti amma oPoththuruc okko ikathar arenek tung oꞌro nakin akin othakka thoporot. ");
INSERT INTO lmd_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ul wokat cik aukko nnaꞌran appik iokat iccik kokaꞌran koUruccelim akin onna ul iongo ana ul iauꞌrupa iokithak woꞌrot nan ana ul wen wittiettakathe appik. ");
INSERT INTO lmd_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ittina apul iprïk ponoppan toKapik ana ul wung ittïttïk iokat mothok moul woCcathukkin wonyirakathe itti okin thaik thakannomerekattat. ");
INSERT INTO lmd_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Okin thocciccokathe ul wothothïlettat woIeccuo ana okin thonekkekathe ikorrkkor. ");
INSERT INTO lmd_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Anaruk ngkoꞌra auꞌrupa wothothïlettat woIli anyat kathat korikorrkkor ana woppiekathekin thapat nti ikorrkkor. ");
INSERT INTO lmd_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Ana wiꞌrekathekin itti, “Ngkonon noppan toKapik annongkene ul lon lothikkoik ithie.” ");
INSERT INTO lmd_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ana ingïꞌrïmak akin iꞌrikat noppan toKapik ammakka okin thiꞌrettathe akin ikkat cik akin ongkene ul. Anakka pul iprïk ponoppan toKapik ana ul wung appik waat okin thakkarathe cuththun coul woIouth ittïttïk ana ul ittïttïk woul woIccereil ana okin thothïathe ul iangwot cik itti wathona ul wothothïlettat woIeccuo nti ikorrkkor. ");
INSERT INTO lmd_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Anaruk akka okin thaat nokaꞌran korikorrkkor akin okinniat ul wothothïlettat woIeccuo ikorrkkor ana okin thopakkathe akin otherekanthet cuththun itti, ");
INSERT INTO lmd_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Onïn thaththiot kathat kulukkwakot kicce, ana ul iangwot cik waik wangwot cik anaruk akka onïn thanyothe athat, onïn thakanniot pul pꞌrek noppan.” ");
INSERT INTO lmd_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Anakka okin thoccïkothe lon len aili irïk woul iangwot noppan toKapik ana ili irïk woul wonoppan toKapik akin oprttakat tit akin iꞌre itti ngintha akkaik panthan nolon elli. ");
INSERT INTO lmd_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ittina apul pꞌrek akkakat apiꞌrekat kin itti, “Nantoccïkothin, ul ianon thonekkethe ikorrkkor waik wangkene ul noppan toKapik.” ");
INSERT INTO lmd_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ana ili irïk woul iangwot cik noppan toKapik ana ul wung thoingkathe ana okin thonakathe ul wothothïlettat kicce kicce annoka mpuꞌran akka okin thonat nꞌre noul akka akinco kin imothok. ");
INSERT INTO lmd_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Anakka okin thonat ul wothothïlettat, okin thonakathekin tokït koCuththun coul woIouth ittïttïk apul iprïk ponoppan toKapik athipipittot kin lon. ");
INSERT INTO lmd_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Apul iprïk ponoppan toKapik iꞌrekat kin itti, “Onïn thiꞌrethenon lon lonthoththomat itti, onon thannongkene ul lon ngkꞌran engki aththik ana onon thoppethe lon cik nokaꞌran koUruccelim ana onon thongothe itti onon tharret lon nocalak cïn loüccük ngopul empi.” ");
INSERT INTO lmd_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","APoththuruc ana ul wung wothothïlettat wꞌrek othïanthet kin itti “Onïn thaccïkot lon loKapik onïn thannoccïkot lon lopul iponyi. ");
INSERT INTO lmd_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Kapik kongappan kurokiet oIeccuo nti ithio, ook ipanon thokkwothe nthokkwethok nothapak. ");
INSERT INTO lmd_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ook ipa Kapik konekkethe thokkun wung wothothari nokaꞌran ikoporot ana othikkiek ili ana pul pothoꞌrettot othakka itti akwokorronno ul woIccereil akkaprttako nti ilon ilokithak ana akwoccïkïnthet kin lon ilokithak. ");
INSERT INTO lmd_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Onïn thimmat lon appik ngkït kïn ana cakuruk Kanang ikupupure kimmat ika Kapik kethet ul iaccïkothok.” ");
INSERT INTO lmd_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Anakka okin thoccïkothe lon len akin uakat ka cannan ana omekat appik itti okin thangwo kin. ");
INSERT INTO lmd_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Anaruk pul pꞌrek poPriccin ipoccot kꞌran itti oKamalail, pul ipangkene lon lothonceꞌret lon cik ana ipa ul othiane cik llon appik purokathe kapik tokït kocuththun coul woIouth ittïttïk apiꞌrekat ul itti nantonekot ul enni thapat papotteik. ");
INSERT INTO lmd_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ittina apiꞌrekat kin itti, “Ul woIccereil, nina lon elli papenang ilanon thaik thathokkinthet ul enni. ");
INSERT INTO lmd_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Nomaꞌri mꞌrek imeot, oThthothac purokwot ncik akwinnikat itti ook ili irïk ana ul woccïkathe lung maun arrial ukuluk maꞌri mocoꞌrin (400) anaruk kwokkuttakathe ana ul wung iokat ammakothok wopettakatheik ana lon len lintakatheik. ");
INSERT INTO lmd_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ana oIutha poul woCelïl pummat ncik cakuruk nomaꞌri mothothangante ul akwerekanthet ul amakathok woppot ana kwokkuttakathe ana ul iammakothok wopettakatheik appik. ");
INSERT INTO lmd_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Anaruk inenni tokït kon, mpiꞌret non itti nokorronno ul enni nokorronno akin eo akka amma lon ilakin okkot lopul iponyi lintat cik. ");
INSERT INTO lmd_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Anaruk amma noKapik, onon thamma akka annoceꞌre ul enni onon thathiot ka kon annothatto iKapik.” ");
INSERT INTO lmd_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ana okin thoccïkathe lon lung ana okin thakkarathe ul wothothïlettat woIeccuo akin okkwekat kin akin ekat kin lon lonthoththomat itti okin thannere ngkꞌran koIeccuo ana okin thelikkathekin. ");
INSERT INTO lmd_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ana ul wothothïlettat woIeccuo woththekathe nocuththun coul woIouth ittïttïk awopirat noka akka Kapik kiothekin nakin thekkot nothokinya ithakin thokkiettathe thiak nti ikꞌran koIeccuo. ");
INSERT INTO lmd_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Nci nocaꞌri cen okin thikkatheik akin ongkene ul noppan toKapik ana ikaman appinappin, okin thakannocoꞌrat nti ithongkene ana erene ul lon iloporot loIeccuo ana itti oIeccuo ook oMiccie. ");
INSERT INTO lmd_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ana nomaꞌri men akka ul iammakothok oIeccuo wokat cik arttakot nan, ul woIouth iokat aere karru koIunanin wikkatheik aerekot noul woIouth iokat aere karru ken koIpranin. Akin iꞌre itti muruma men maik mannikkettat nnothuꞌrit ithokat cik athaꞌrntakinthet muruma appinappin. ");
INSERT INTO lmd_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ittina aul wung iammakothok iattul ana ikken keꞌra aꞌrntakat appik tothun akin iꞌrekat itti, “Lakannoka loporot nanïn itti onïn thapaꞌrine lon lothongkene lon loKapik cik anïn okatha lon lothuꞌrit. ");
INSERT INTO lmd_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Pangkingon, noneko ul weꞌreꞌrapuruk nti ianon ia nthimmat itti wella lon ilokithak cik ana wonu Kanang ikupupure noka ana winaik ntima annethet kin ngre engngi. ");
INSERT INTO lmd_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Anïn iꞌrikot nothaꞌra ngaꞌrama ana ongkene lon loKapik.” ");
INSERT INTO lmd_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Lon elli lopiriekathe ul noka appik. Okin thummathe oIciththippanuc pul iponat thoccokot thoIeccuo nocïkït thoppot ana Kanang ikupupure, ana cakuruk oPilippic ana oProkkoroc ana oNikkanoroc ana oThthimon ana oPariminac, ana oNikkolaoc pAnththakkia ipokat pothakkat pul kathar koul woIouth ana kwoccokathe lon nocïkït loIeccuo. ");
INSERT INTO lmd_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ana okin thonakanthet kin ul wothothïlettat woIeccuo anekket nyaun nakin aꞌrakanthet kin ngaꞌrama. ");
INSERT INTO lmd_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ittina lon loKapik lopettakatheik. Maun moul iammakot oIeccuo marttakathe nan nokaꞌran koUruccelim ana ul woppot wonoppan toKapik occïkat lon lothoccokot lon nomïkït. ");
INSERT INTO lmd_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","OIciththippanuc ipa Kapik kethet thoporot ana puꞌran ana kwonakathe puꞌran poppot akwikkat cik akwokkot lon ilommaththik iul. ");
INSERT INTO lmd_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ittina aul wꞌrek wonocuththun caꞌrama icoccot kꞌran itti cuththun coul ielikkakot thikkatheik akin opllarot okin oIciththippanuc. Okin thokat ul woIouth iaat nokaꞌran koKirin ana nokaꞌran koIcikkantharia, ana opilingon cakuruk noththok poKilikkia ana pAccia. ");
INSERT INTO lmd_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Anaruk okin thannalkathok akka Kanang ikupupure kethethok thinaik nti ica itha kweret ngngin. ");
INSERT INTO lmd_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ittina okin therekekanthet ul wꞌrek itti wathere ngkarra itti, “Onïn thoccïkothe aIciththippanuc ocungkwo Kapik ana oMucca.” ");
INSERT INTO lmd_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Akin erekekat ul ana ul ittïttïk woul ana ul iangkene lon lothonceꞌret lon cik. Okin thoꞌrumathe oIciththippanuc ana okin thoccokathok akin onakathok tokït koCuththun coul woIouth ittïttïk. ");
INSERT INTO lmd_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Akin ipat ul cik iathocoꞌrot lon ngkarra akin iꞌre itti, “Kwannocoꞌro nti ithocungkwo tupan toKapik irupupure ana nti ithocungko lon lothonceꞌret lon cik. ");
INSERT INTO lmd_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ana onïn thoccïkothe cakuruk akwere itti oIeccuo empi poNaccir pathokïtto kaꞌran engki kaꞌrama ana kwaprtto thathumaik itha oMucca ponekkenthet ton cik.” ");
INSERT INTO lmd_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ittina ul iokat cik aikkoik cïnang noCuththun coul woIouth ittïttïk wokathakathe oIciththippanuc toca ana okin thimmakathe toca tung ere toca touꞌrupa wothothïlettat woKapik. ");
INSERT INTO lmd_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ittina pul iprïk ponoppan toKapik pipittathe oIciththippanuc itti, “Lon ila ul werethung ngngin laik ïcari?” ");
INSERT INTO lmd_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Akwothïat tit itti, “Pangkingon ana ongappan noccïkothin, Kapik ikrïk kumminthet ongappa ponnon Aprein ncik akka kwokat cik akkwarthuk noththok poMaccappaththomia akkwarthuk urokot nokaꞌran kAran. ");
INSERT INTO lmd_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Akiꞌrekathok itti, ‘Uroki aththe noththok pang ana noul wang aeo noththok ipa anokeneng.’ ");
INSERT INTO lmd_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ittina akwoththekat noththok poPapilonia akurokat nnokaꞌran kAran. Anakka oththan piot Kapik kothïathok ntan cene noththok empi nanon thaik inenni. ");
INSERT INTO lmd_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Kapik kokat kannethok kaꞌran engki itti kaka kung manna cipit cotteik nnan. Anaruk Kapik konekkenthok lon cik itti ook ana thiki thung thana capu. Anaruk caꞌri cen Aprein manna pokat pellat ukul cik. ");
INSERT INTO lmd_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","AKapik iꞌrekathok itti, ‘Thiki thang thaka kwat noththok poka ipakannoka pen ana thaka iak iarekine ul ana okin thakkiettat thiak llon ilokithak luput arrial ukuluk maꞌri mocoꞌrin (400). ");
INSERT INTO lmd_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Anaruk mpakkma ul iakin thaik tharekine ana okin thappot thapat noththok pen akin athaꞌranin ngaꞌrama nokaꞌran engki.’ ");
INSERT INTO lmd_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ittina Kapik konekkekanthet Aprein lon cik llon lothokekkot ana Aprein pokwonathe oIccaak ana kwokekkiekathok akkwonu maꞌri mormor akka kwokwontat. Ana oIccaak pokwonathe oIakup ana kwokekkiekathok ana oIakup pokekkiekathe nyukul nyung inyattul ana ikken keꞌra ammakka thiki thongappan thonnon.” ");
INSERT INTO lmd_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","AIciththippanuc erekat akwiꞌre itti, “Nyukul nyoIakup nyokat nyannopira noka napang pen oIuccip ana okin thokerathok akwonekittakat akwothothakkakat piak noththok poMuccir anaruk Kapik kakkokat naak. ");
INSERT INTO lmd_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Ana koꞌrekathok nti ilon appik ilokithak ana kekathok thinaik nti ica ana iniek lon iloporot loPoroun ili wonoththok poMuccir. Menik oPoroun wothikkiekathok pul ipakatha lon lopothok ana kaman kung appik. ");
INSERT INTO lmd_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ittina tï tommaththik taccokïttot thaik toꞌratheik noththok poMuccir appik ana noththok poKanaan ana pul pellakathe nti inyukul nyoIakup ipiot thuꞌrit. ");
INSERT INTO lmd_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Anakka oIakup poccïkothe itti thuꞌrit thaik noththok poMuccir, kwothïathe nyukul ngung ongappan thonnon anyothokathiek akka caꞌri cen akin antimma pothok poMuccir nocaꞌri corokït. ");
INSERT INTO lmd_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Anakka okin thapakkothe attang, aIuccip erekanthet opangon itti ook okkwen ana oPoroun pinakathe kuꞌri koIuccip. ");
INSERT INTO lmd_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Menik AIuccip othïanthet oththan oIakup thon ana kuꞌri kung appik akin anthan. Okin thokat arrial wꞌrapuruk ana alkaire ana ikken ukuluk (75). ");
INSERT INTO lmd_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ittina oIakup poingkathe noththok poMuccir na kwiothe ana nyukul ngung ongappan thonnon. ");
INSERT INTO lmd_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Okin thonekittakathe nnoththok poMuccir akin othocïkkako nokaꞌran koCcekkim kaꞌran ika Aprein pappokerothe nyukul nyAmur nakucci.” ");
INSERT INTO lmd_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","AIciththippanuc erekat akwiꞌre itti, “Anakka caꞌri okko napuththut ica Kapik kakkonekkenthet Aprein lon cik itti kakkinthok lon nan ila kakkonekkenthok cik, amaun moul ikkat cik amarttakot nan cannan noththok poMuccir. ");
INSERT INTO lmd_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Aili wꞌrek iee opakkat noili ngonoththok poMuccir iommat oIuccip itti ook okkwen. ");
INSERT INTO lmd_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ana wikkatheik akkiet ul woIccereil thiak ana akin opaꞌre oththan ana onnan ponyukul cik othakka itti anyukul ille. ");
INSERT INTO lmd_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ana nocaꞌri cen aMucca okwontakat ana kwokat popeththere cannan ana kwikkatheik anok wꞌrapuruk thoththangon ana okin thokat cik, akin anguttethok tuan thanen. ");
INSERT INTO lmd_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Anakka okin thoppiethok thapat, ukul iopari woPoroun wonekathok athupothathok athikkiekathok ukul wung. ");
INSERT INTO lmd_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","OMucca pocokkakathe ana kwongkenettakathe thinaik nti ica appik thoul woMuccir ana kwappinangka ere papenang ana okkot ngre. ");
INSERT INTO lmd_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Anakka oMucca pokkothe luput arrial weꞌra (40) kwomekathe ica cung itti kwathokatha ul wung woIccereil. ");
INSERT INTO lmd_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Menik kwimmakathe pul poMuccir apokkiet pul poIccereil thiak ana kwoingkathe akwothaꞌrettinok ana kwokkwathe pul poMuccir mono apiat. ");
INSERT INTO lmd_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","OMucca piꞌrekathe noucce wung itti ul wung wira wina itti Kapik konarok itti akwathoꞌret kin anaruk okin thommat. ");
INSERT INTO lmd_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ana ngorrot ngen aMucca iat ul wꞌrek weꞌra woIccereil athatto akwiꞌrekat itti kwapakket kin ikuꞌri akwiꞌrekat kin itti, ‘Ul woIccereil, onon thakuꞌri ana ngintha akka anniettine ka kongo?’ ");
INSERT INTO lmd_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Anaruk pul ipokat apokkiet opang thiak othïat oMucca apiꞌrekat itti, ‘Oththa akkothikkierung ili ana pul ipakkma nïn? ");
INSERT INTO lmd_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ngkwongothe itti ngkwakkwothin ammakka ngkwokkwothe pul poMuccir mecceni?’ ");
INSERT INTO lmd_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Manakka oMucca poccïkothe elli akwollat eo noththok poMithian na kwaththikkat cik than akwipat pari akwokwonat nyukul than nyeꞌra inyomura.” ");
INSERT INTO lmd_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","AIciththippanuc oꞌrungkat nan puccuk akwere akwiꞌre itti, “Anakka luput leot ncik arrial weꞌra (40) auꞌrupa wothothïlettat woKapik ummanthet oMucca ncik ithampang ithonthomat iccik kocoꞌrong coCcina ithik thokat cik athocco nopira apira okorronno. ");
INSERT INTO lmd_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Manakka kwimmat lon len akwikkat cik akwoprttakot tit akwoingkat iccik ken akwothokatha akwoccïkat poꞌre poKapik apiꞌre itti, ");
INSERT INTO lmd_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Oun Kapik koththen Kapik kAprein ana oIccaak ana oIakup.’ Ittina aMucca ipat nꞌre akwikkat cik akwokkwe ka ana kwommakathe okatha cik. ");
INSERT INTO lmd_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","AKapik iꞌrekathok itti, ‘Ue wok nti iracok tang akka kaꞌran engkrïk ika ngkwaik pacoꞌro nan kupupure. ");
INSERT INTO lmd_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Mpimmat thiak itha ul win waik waccokot noththok poMuccir ana mpoccïkothe ngeme ngen, ana mpuot ntan ntothiꞌrot anathoꞌret kin ana ngkwanthan anothïothung noththok poMuccir.’ ");
INSERT INTO lmd_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Ana oMucca empi ipa ul wung wꞌrat lon len akka okin thiꞌrethok itti, ‘Oththa akkothikkierung ili ana pul ipakkma nïn?’ Ook ipa Kapik kothïothe akwoka ili wen ana pul ipaꞌret kin nthittarot thouꞌrupa wothothïlettat woKapik iumminthok ncik nopira ipokat cik apokꞌro. ");
INSERT INTO lmd_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ook iponat ul thapat noththok poMuccir ana kwokkothe lon ilommaththik ana nocapu noththok poMuccir nokuthut korok irapangka tocakak ana kwokkathe lon len luput arrial weꞌra (40) ithampang ithonthomat. ");
INSERT INTO lmd_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","OMucca pen ipiꞌrethe ul woIccereil itti, ‘Kapik kanekkenthet non pul pꞌrek pothernte lon loKapik nti ianon pammakka oun nti iul wonnon.’ ");
INSERT INTO lmd_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","OMucca ipokat cik akin oulon iokat thiki thonnon ithampang ithonthomat ana uꞌrupa wothothïlettat woKapik ierenok nocoꞌrong coCcina okin ongappan thonnon. Kwoccot lon lothikkoik akwathokeneron. ");
INSERT INTO lmd_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Anaruk ongappan thonnon thꞌrat occïkothok ana manna okin thꞌrarok ana mïkït men mopakkothe noththok poMuccir. ");
INSERT INTO lmd_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Okin thiꞌrethe Arun itti, ‘Okkinthet nïn kapik kïn ikaeo tokït kïn akka onïn thomma ngimpen akkoꞌrot naMucca iponat nïn nnoththok poMuccir.’ ");
INSERT INTO lmd_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Caꞌri cen cokat icakin thokkothe purrut ipungkwot ngura, akin aꞌrane ngaꞌrama ana okin okeccenthet aꞌrupu wothokiot ngüccük cik ana okene papu pen thothia cik ipakin thokkothe nyaun nyen. ");
INSERT INTO lmd_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Anaruk Kapik kokorronnathekin akin ongat lon ilokithak akin aꞌrane manna mothot morothiꞌrot ngaꞌrama. Elli laik ammakka lokurrakot iatham woul wothernte lon loKapik ila Kapik kiꞌret itti, ‘Ul woIccereil, onon thokeccethe aꞌrupu wothokinthet Kapik ngüccük cik luput arrial weꞌra ithampang, anaruk onon thannethin. ");
INSERT INTO lmd_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Onon thonekkethe purrut poMalok ana cothot coKapik kon oRamppan aꞌrupu ianon thokkothe nyaun nyon othakka itti annaꞌrane ngaꞌrama. Ittina mpathïot non ikwat ciththan nnoththok poPapil.’” ");
INSERT INTO lmd_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","AIciththippanuc erekat akwiꞌre itti, “Ana thiki thonnon ul woIccereil wonat cüꞌrük ika kothampang icakene itti Kapik kaik ica oMucca pokkothe ammakka Kapik kiꞌrethok ana ammakka thungkwo itha kwokenerok. ");
INSERT INTO lmd_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ana noluput ilomakothe, akka oCeccua pokat ili wothiki thonnon akka okin thorrot iul ia Kapik kokïccenet kin nnaꞌran wen. Okin thokat cik akin onneko cüꞌrük akin oince ngngin naꞌran iie. Ana coꞌrungkathe than puccuk mono acaꞌri coili oThauth akkakat, ");
INSERT INTO lmd_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","okkwi ipa Kapik kopiranet noka ana oThauth pipittathe Kapik itti kunine ul woIccereil man na aꞌrat ngaꞌrama. ");
INSERT INTO lmd_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Anaruk oCiliman akkunanthok man men. ");
INSERT INTO lmd_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Anaruk Kapik kakkannikkoik ikaman ika ul ionyi wunot nyaun nyen. Pul pothernte lon loKapik piꞌret itti, ");
INSERT INTO lmd_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Tothiꞌrot taporrok pin ana capu na anonekket tacok arapikot. Aili iꞌrekat cakuruk itti, man maraththa imanon thongothe itti nthuninin? Ana manna itti kaꞌran kiatha ika anapikot nan? ");
INSERT INTO lmd_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Oun akkakannokkot aꞌrupu enni appiki?’ ");
INSERT INTO lmd_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Onon enthi ithonthomat ma ana mïkït ana ithannoccïkot lon loKapik nthammakka oththeni, onon thalikine Kanang ikupupure cik appinappin. ");
INSERT INTO lmd_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Pul pothernte lon loKapik piatha ipa aththen thannokkiet thiak? Okin manna thongwot okkwion ithiꞌret lon lothao thokkwi ipoporot tokït koKapik kirrkkir. Ana inenni nthokerorok ana okkwothok. ");
INSERT INTO lmd_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Onon ithoccot lon lothonceꞌret lon cik nti ikkun wouꞌrupa wothothïlettat woKapik anaruk onon thꞌrat oreko ngngin.” ");
INSERT INTO lmd_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Anakka ul ittïttïk wonoppan toKapik woccïkothe lon ila kwiꞌret, okin thuakathe ka akin ollat ntaak akin okꞌrellot kïnyït thocipit. ");
INSERT INTO lmd_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Anaruk oIciththippanuc papponat Kanang ikupupure noka cannan, akwokathakat tothiꞌrot akwimmakat thrïk thoKapik ana oIeccuo akwocoꞌro nthokkun wothothari woKapik. ");
INSERT INTO lmd_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ittina akwiꞌrekat itti, “Mpimmat tothiꞌrot tanyot ana ukul wopul iponyi waik wacoꞌro nthokkun wothothari woKapik.” ");
INSERT INTO lmd_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ittina akin oꞌrumat unu wen ana okin thurokathe kapik akin okkot poꞌre cittan ana ollot taak. ");
INSERT INTO lmd_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Akin othathok thapat nokaꞌran koUruccelim akin othokincothok cik mmothok, aul iokat cik iimmat lon len uekat eret wen akin eekat pul pꞌrek popuꞌrit ikkun iponu kꞌran itti oCcaul. ");
INSERT INTO lmd_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Anakka okin thokat cik akin okincok, oIciththippanuc pikkatheik akwaꞌra ngaꞌrama itti, “Ili oIeccuo, occothin kanang kin.” ");
INSERT INTO lmd_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ittina akwapat nocapu ee ungku ncik akwekat ngeme itti, “Ili oIeccuo, occïkïnthet kin lon ilokithak nti ilon elli ilakin thokkothe.” Anakka kwiꞌret elli akwiat. ");
INSERT INTO lmd_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Ana oCcaul piꞌrekathe itti oIciththippanuc itti kwio okkuttat nti ikkun. Nocaꞌri cen, thoccokiettat thiak thoul ioccokothe lon loIeccuo thurokathe ncik nokaꞌran koUruccelim, aul opettakat cik appik ioccokothe lon loIeccuo noththok poIouthia ana poCcamira, aul wothothïlettat woIeccuo wuluk okwentakat. ");
INSERT INTO lmd_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ana ul wꞌrek ioccokothe lon loIeccuo cannan woathe oIciththippanuc cannan ana wocïkkathok. ");
INSERT INTO lmd_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ittina oCcaul pikkatheik akwopettot ul cik ioccokothe lon loIeccuo. Kwikkatheik akwonyaro ikaman kulukkuluk akwocciccokot ul iomura ana iari akwothutho akwipot ikorrkkor. ");
INSERT INTO lmd_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ittina aul iokat wopettakotheik naꞌran wꞌrek ikkat cik akin ongkene lon loKapik naꞌran appik nakin theot. ");
INSERT INTO lmd_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","OPilippic puathe nokaꞌran kokat cik noththok poCcamira ana kwikkatheik akwongkene ul lon loMiccie than. ");
INSERT INTO lmd_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ul wokkwanthet lon lung unu ncik papenang akka wimmat lon ilommaththik ila aPilippic pokkothe. ");
INSERT INTO lmd_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Uꞌrupa iokithak wokat cik appore nti iul woppot ana wokat aoo mpoꞌre cittan ana ul wothakkakathe woporot woppot iaimico ana iathurukkwo cakuruk. ");
INSERT INTO lmd_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ittina aul appik nokaꞌran koUruccelim opirakat noka. ");
INSERT INTO lmd_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Pul pꞌrek pokat cik nokaꞌran ken poccot kꞌran itti oCcamaan pappokkinthet ul woCcamira thurukut nokaꞌran ana oprttakiet ul tit noththok poCcamira appik. Kwokat akwome itti ook puluk akkrïk ana kwina lon ncik appik. ");
INSERT INTO lmd_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ana ul appik iarran ana ittïttïk wikkatheik ammakothok aiꞌre itti, “Pul empi ponu puꞌran poKapik ana ook akkaka prïk.” ");
INSERT INTO lmd_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ana okin thomakathok akka kwocikittinet kin ma llon lothurukut ila akwokkettet thupuththuput. ");
INSERT INTO lmd_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Anaruk akka okin thoccokothe lon loPilippic ila kwongkenet iloporot loIeccuo longili ngoKapik ana kꞌran koIeccuo oMiccie, okin thoccathe mamuthie appik, ul iari ana iomura. ");
INSERT INTO lmd_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","ACcamaan occokat lon nocïkït akwoccat mamuthie cakuruk ana kwomakathe oPilippic naꞌran appik na kwonyaro ana kwikkatheik akwoprttakot tit nolon ila kwimmat ilokkattathe ilommaththik appik. ");
INSERT INTO lmd_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Anakka ul wothothïlettat woIeccuo woccïkothe nokaꞌran koUruccelim itti ul wonoththok poCcamira woccokothe lon loIeccuo, akin othïat oPoththuruc ana oIuanna. ");
INSERT INTO lmd_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Anakka okin thaat noththok akin aꞌrakanthet ul ngaꞌrama itti akin occo Kanang ikupupure nomïkït men ");
INSERT INTO lmd_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","akka Kanang ikupupure kokat kannainekin akka okin thoccot mamuthie tulluk ngkꞌran koIli oIeccuo. ");
INSERT INTO lmd_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ittina oPoththuruc ana oIuanna thonekkekathe nyaun nakin akin aꞌrakanthet kin ngaꞌrama ana okin thoccathe Kanang ikupupure. ");
INSERT INTO lmd_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Manakka oCcamaan pimmat itti okin thoccot Kanang ikupupure nti inyaun nyoul wothothïlettat, akwekat kin akucci. ");
INSERT INTO lmd_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Akwiꞌrekat kin itti, “Nethin puꞌran emprïk othakka itti okkwi ipa anonekket nyaun nan akwocco Kanang ikupupure nti ikkun win.” ");
INSERT INTO lmd_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","APoththuruc iꞌrekathok itti, “Nokïttako annakucci wang akka ngkwakatha ere itti ngkwakero thoporot thoKapik nakucci wang. ");
INSERT INTO lmd_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ngwella ngre cik cene ilon loKapik akka cïkït cang cakannoka coꞌrillir tokït koKapik. ");
INSERT INTO lmd_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Opaꞌrinet lon ilokithak cik lang aꞌrane Ili ngaꞌrama amma manna aKapik occïkïnthung lon elli ila ngkwokwarttikothe nocïkït. ");
INSERT INTO lmd_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Mpimmat itti ngkwonu thonyira nocïkït ana lon ilokithak lꞌrikikkorung.” ");
INSERT INTO lmd_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ittina aCcamaan iꞌrekat oPoththuruc itti, “Aꞌranet Kapik ngaꞌrama, alon ila ngkwiꞌret okorronno oka nin cik.” ");
INSERT INTO lmd_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Anakka oPoththuruc ana oIuanna thocothothe lon ana thongkene tholon iloporot loIeccuo, okin thopakkathe nokaꞌran koUruccelim. Ana nokathar opakkot nokaꞌran koUruccelim okin thokat akin erene ul lon loIeccuo naꞌran woppot iaik noththok poCcamirin. ");
INSERT INTO lmd_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Auꞌrupa wothothïlettat woIli iꞌrekat oPilippic itti, “Ui nca opakkot thokkun wothothari amma akatha na acïngkï ummot ngngin amakot kathar ikaat nnokaꞌran koUruccelim akeo nokaꞌran koKaca.” ");
INSERT INTO lmd_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ittina akurokat akweo ana ikathar, akwocurat ipul poul wonoththok pAththiuppia ipathuththakot. Pul pen pokat prïk ingili ngoKanthakka ili iopari wonoththok pAththiuppia ook iponat prit pakucci ikkun appik appaat appaththaꞌra ngaꞌrama nokaꞌran koUruccelim. ");
INSERT INTO lmd_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Anakka kwokat cik akwopakkot nokaꞌran kung, kwokat ithurumpil ithathuthako mapprththa akwikkoik akwakkakkaro iatham wopul pothernte lon loKapik oIccaia. ");
INSERT INTO lmd_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Kanang koKapik iꞌrekat oPilippic itti, “Ngko accot thurumpil entheꞌre cik.” ");
INSERT INTO lmd_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ittina oPilippic piꞌrikittakathe ana kwoccïkathe apul akkakkaro iatham wopul pothernte lon loKapik oIccaia akwipittathok itti, “Atti ngkwina lon ila ngkwaik pakkakkaro?” ");
INSERT INTO lmd_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Apul iꞌrekat itti, “Mpina taththa apul pella ipangkenen lon len.” Kwiꞌrekathe oPilippic itti kwarrot tothurumpil akwikkoik iccik kung. ");
INSERT INTO lmd_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Pul pen pokat cik apakkakkaro lon nti iatham woKapik iliꞌre itti, “Kwanekitta ere thungkat ithaik inyaun nyoul thakuttat, ana ere thungkat ithaik inyaun nyoul ithaik thathokettat tua, thangkoik icci, kwakanniꞌre lon lꞌrek aththik. ");
INSERT INTO lmd_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Okin thokkiethok thiak ana okwïethok. Oththa akkeret thiki thung? Akka thikkoik thung thonekittat nnocapu.” ");
INSERT INTO lmd_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Apul ipathuththakot appipittat oPilippic itti, “Iꞌrethin, pul pothernte lon loKapik paik peret oththa cene paik peret ka kungi ana amma okorronno oka ka kung kwaik peret pul pꞌrek pokai?” ");
INSERT INTO lmd_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Menik aPilippic okuꞌrekanthok lon cik nolon len iatham woKapik ana kwikkatheik akwerenok lon iloporot loIeccuo. ");
INSERT INTO lmd_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Anakka okin thokat cik nokathar, akin iat kaꞌran kꞌrek konu ngꞌri apul pen iꞌrekat oPilippic itti, “Katha ngꞌri ngei cene mpakannocco mamuthie akaintha?” ");
INSERT INTO lmd_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","APilippic iꞌrekathok itti, “Amma ngkwoccokothe lon ncïkït appik ngkwacco mamuthie.” Apul ipathuththakot othïat tit itti, “Mpoccokothe lon nocïkït itti oIeccuo oMiccie ook ukul woKapik.” ");
INSERT INTO lmd_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ana kwiꞌrekathe pul ipallillie capprththa itti kwacoꞌro ana okin aththuththeꞌra thorpathe nocapu akin orpat iꞌri ana oPilippic pekathok mamuthie. ");
INSERT INTO lmd_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Manakka okin thokat cik akin okuꞌrot nti iꞌri, Kanang koIli konekathe oPilippic ana pul ipathuththakot pakinnimmakathok pꞌrin anaruk poingkathe appopirat noka cannan. ");
INSERT INTO lmd_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Anaruk oPilippic paththiat ka kung nokaꞌran kAcuthuth ana kwonyarathe nomoꞌrong appik akwongkene lon iloporot loIeccuo puccuk mono akwoingkat nokaꞌran koKaiccaria. ");
INSERT INTO lmd_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","OCcaul pokat pommaththik papillietto ana iꞌrille itti kwangwo ul iammakot lon loili oIeccuo. Kwoingkanthet pul iprïk ponoppan toKapik ");
INSERT INTO lmd_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ana kwipittathok itti kwethok taꞌrmacak akweo ngngin nomuththun maꞌrama nokaꞌran koThimacakka othakka itti amma akwiot ul than antoka manna iomura ana iari iaik ilon lokathar koIli oIeccuo akwocciccokot akwothipot kin ikorrkkor nokaꞌran koUruccelim. ");
INSERT INTO lmd_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Anakka akwokko iccik koThimacakka athuleꞌrak thꞌrek akkakat ntothiꞌrot accokkot athammrththakathok. ");
INSERT INTO lmd_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Akwapat nocapu akwoccïkat poꞌre apiꞌrethok itti, “Caul, Caul, ngintha akka accokienthin thiak?” ");
INSERT INTO lmd_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","ACcaul ipittat itti, “Oung oththa, Ili?” Apoꞌre othïanthok tit itti, “Oun oIeccuo ipa ngkwaik paccokiet thiak. ");
INSERT INTO lmd_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Anaruk inenni urokothe kapik aeo icarak coman athoccïkot lon ila ngkwonu itti ngkwakkot.” ");
INSERT INTO lmd_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ittina aul iokat cik anyaro okin oCcaul ocoꞌrot akin oprttakat tit. Okin thokat akin occïkot poꞌre anaruk pul pellat ipakin thimmat. ");
INSERT INTO lmd_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ittina aCcaul urokat kapik nocapu anaruk akka kwanyothe kït akwokorronno immakat papꞌrek. Menik akin othuthathok akin oingkat nokaꞌran koThimacakka. ");
INSERT INTO lmd_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ana kwikkatheik maꞌri mꞌrapuruk akkwiꞌrimathe ana okonnoꞌrkoik ana manna ïkko ngꞌri. ");
INSERT INTO lmd_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ana nokaꞌran koThimacakka, pul pꞌrek pokat cik than pung ipammakot lon loIeccuo poccot kꞌran itti Anania. AKapik akkarathok ithathantako itti, “Anania.” Akwothangkat itti, “Oi Ili.” ");
INSERT INTO lmd_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","AIli iꞌrekathok itti, “Ngko tuan toIoutha ikathar ikocoꞌrotheik accungkur aipitto pul pokaꞌran koTharccic poccot kꞌran itti oCcaul. Kwaik paꞌra ngaꞌrama. ");
INSERT INTO lmd_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ana Caul pathantakothe itti kwimmat pul ipoccot kꞌran itti Anania appaat ana ponekkethe nyaun naak apaꞌranok ngaꞌrama itti akwimmaik.” ");
INSERT INTO lmd_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Anania othïat tit itti, “Ili, mpoccïkothe lon lopul empi ana lon appik ila kwiet ul wang ka kongo nokaꞌran koUruccelim. ");
INSERT INTO lmd_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ana paat cene llon noul ittïttïk woul wonoppan toKapik itti kwathocciccokot ul appik iaik wangante kꞌran koIeccuo akwipot ikorrkkor.” ");
INSERT INTO lmd_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Anaruk Ili wiꞌrekathe Anania itti, “Ngko akka pul empi paun akkakkarot itti akwotherene ul iakonnoka ul woIouth lon lin ana nili nen ana ul woIccereil. ");
INSERT INTO lmd_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Mpakenek tat akka akwokkiettat thiak nti ikꞌran kin.” ");
INSERT INTO lmd_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Anania poingkathe tuan toIoutha akwiꞌrikat noppan. Kwonekkekathe nyaun naCcaul akwiꞌrekathok itti, “Pangkin, Ili oIeccuo ipumminthung ncik ikathar akka ngkwokat cik anthan wothïothin othakka itti aimmaik ana ona Kanang ikupupure noka woppot.” ");
INSERT INTO lmd_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ncïnang aꞌrupu wꞌrek apat nti ikït koCcaul wungkwot aꞌrincikol ana kwimmakatheik ana kurokathe kapik ana kwoccathe mamuthie. ");
INSERT INTO lmd_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ana kwoꞌrkkathe thuꞌrit ana puꞌran popakkanthok ikkwa ana kwikkatheik maꞌri motte nokaꞌran koThimacakka akin oul woIeccuo iammakothok. ");
INSERT INTO lmd_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ana kwikkatheik akwere nomuththun maꞌrama itti oIeccuo ukul woKapik. ");
INSERT INTO lmd_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Aul appik ioccikothe lon ila kweret woprttakatherit ana wikkathe aipitto itti, “Okorronno oka pul empi ipokkothe lon lokithak noul nokaꞌran koUruccelim iangante kꞌran koIeccuoi? Ana kwannao cene itti kwathocciccokot ul akwipot ikorrkkori ana onekine ul ittïttïk woul wonoppan toKapiki?” ");
INSERT INTO lmd_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Anaruk oCcaul pikkatheik akwarttakot nan noꞌron lothere lon iloporot loIeccuo ana kwokenekathe ul woIouth lon nokaꞌran koThimacakka itti oIeccuo ook oMiccie. ");
INSERT INTO lmd_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Anakka maꞌri meot ncik moppot, aul woIouth orumettarat itti okin thakkwothok, ");
INSERT INTO lmd_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","anaruk oCcaul pinakathe nolon len. Ana okin thikkatheik akin occot kït cik thokathar ikaeo nokaꞌran koUruccelim icïngkï ana ngkoꞌra othakka itti akin okkwothok. ");
INSERT INTO lmd_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Anaruk ul wꞌrek iammakothok wonekanthok lon ngkoꞌra ana worpekathok thapat oppiek icuruk cokunthong ngalunthung. ");
INSERT INTO lmd_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Manakka oCcaul paat nokaꞌran koUruccelim kwoingkanthet ul iammakot oIeccuo anaruk okin thipathe nꞌre nung, okin thakorronno onekket cïkït naak itti pul ipammakot oIeccuo. ");
INSERT INTO lmd_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Anaruk oParnapa pipathok ana kwonekanthok ul wothothïlettat woIeccuo ana kwerekanthet kin lon loCcaul tat akka kwimmathe Ili oIeccuo ikathar akkwaik akeo nokaꞌran koThimacakka ana tat akka Ili oIeccuo werenok ana tat akka kwongkenet lon loIeccuo ella nꞌre. ");
INSERT INTO lmd_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ittina oCcaul pikkatheik akin aththungon akin onyaro nokaꞌran koUruccelim akwerene ul lon loKapik ngkꞌran koIli oIeccuo nci nokkït. ");
INSERT INTO lmd_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Kwokat akwerene ul woIouth iere karru koIunanin ana opllarot llon anaruk okin thokwancathe kathar itti okin itti thakkwothok. ");
INSERT INTO lmd_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Anakka ul ioccokothe lon loIeccuo winat lon len okin thoingkathe nokaꞌran koKaiccaria akin antothïothok nokaꞌran koTharccic. ");
INSERT INTO lmd_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ittina aul appik ioccokothe lon loIeccuo noththok poIouthia ana noththok poCelïl ana noththok poCcamira wikkatheik woporot noka. Okin thikkatheik akin othakka thonthomat ilon loIeccuo ana okin thittarakothe ngKanang ikupupure, okin tharttakathe nan ithoccokot lon loKapik ana thikkatheik akin ikkoik akin thonu nꞌre noIli. ");
INSERT INTO lmd_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Manakka oPoththuruc pokat cik akwonyaro nomoꞌrong, kwoingkathe nokaꞌran ikoccot kꞌran itti Lutha akwothokatha ul woKapik. ");
INSERT INTO lmd_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ana kwiathe pul pꞌrek than poccot kꞌran itti Iniac pakimico pomma uroko nnaꞌrangkal luput mormor (8). ");
INSERT INTO lmd_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","OPoththuruc piꞌrekathok itti, “Iniac, oIeccuo oMiccie pothikkierung poporot. Urokothe kapik aneko kuppuꞌrung kang ikaïcat nan.” Menik kurokathe accokkot. ");
INSERT INTO lmd_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Aul appik iaik nokaꞌran koLutha ana koCcaron wimmakathok ana woccokathe lon loIli nomïkït. ");
INSERT INTO lmd_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ana nokaꞌran koIappa pul pꞌrek ipoccokothe lon loIeccuo ipopari ipoccot kꞌran itti Thapiththa ngkarru koIpranin ana oThorkkac ngkarru koKrik ilonu itti wallir, ook ipakkettet lon iloporot ana akwittarot ul iaraco. ");
INSERT INTO lmd_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ana nocaꞌri cen pokakathe pongo ana piathe ana okin thopakkiekathok ngkathar kothathum thoIouth kicce ana akin onekkekathok noppan toꞌra. ");
INSERT INTO lmd_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Kaꞌran koLutha kokat iccik koIappa anakka ul iammakot oIeccuo woccïkothe itti oPoththuruc paik nokaꞌran koLutha, okin thothïanthok opilingon theꞌra akin othiꞌrethok itti, “Ainet nïn aththaman.” ");
INSERT INTO lmd_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","OPoththuruc poingkathe akin aththungon anakka okin theot akin onekathok toꞌra noppan. Ul wꞌrek wokat cik ia ollen thillet nan acoꞌrothok aoo ana ongkenek eret ia oThapiththa pappokkothe akka okin thokat cik akin aththungon akkwarthuk io. ");
INSERT INTO lmd_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ittina aPoththuruc othïat kin thapat appik inoppan ana kwocukkwathe nocapu akwaꞌra ngaꞌrama ana kwokathakathe ukul iot, ana kwiꞌrekathe itti, “Thapiththa, urokothe kapik.” Ana kwanyathe kït ana kwimmakathe oPoththuruc ana kurokathe kapik. ");
INSERT INTO lmd_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","APoththuruc ittarathok akwonyaro ana kwakkarathe ul iammakot lon loIeccuo ana muruma ana kwonakanthet kin oThapiththa akkwakannio. ");
INSERT INTO lmd_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Lon len lappaththatheik appik nokaꞌran koIappa appik ana ul woppot woccokathe lon loIli. ");
INSERT INTO lmd_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ana oPoththuruc pikkatheik nokaꞌran koIappa maꞌri motteik okin opul ipoccot kꞌran itti oCcamaan ipokat apocucco uꞌrat. ");
INSERT INTO lmd_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Pul pꞌrek pokat cik nokaꞌran koKaiccaria poccot kꞌran itti oKurnilioth kwokat ili woul arrial ukuluk irro wonoththok poIiththalia. ");
INSERT INTO lmd_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ook ana ul woruan thanung appik thokat akin aꞌrane Kapik ngaꞌrama ana opellene Kapik, kwokat akwittarot ul iellat aꞌrupu cik ana aꞌrane Kapik ngaꞌrama appinappin. ");
INSERT INTO lmd_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ana caꞌri cꞌrek, acïngkï cokkothe cꞌrapuruk cipin, akwathantakat itti kwimmat uꞌrupa kicce wothothïlettat woKapik ainok ana wakkarorok itti, “Kurnilioth.” ");
INSERT INTO lmd_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","AKurnilioth okathakat uꞌrupa nnꞌre ana kwiꞌrekathe itti, “Ili, ngintha akkaik?” Ana uꞌrupa wothothïlettat woKapik wothïanthok itti, “Ngaꞌrama ngang ana lon iloporot ilakkinthet ul appik lainet Kapik tothiꞌrot. ");
INSERT INTO lmd_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Okwantothe ul weꞌra iomura athïot nokaꞌran koIappa akin othona pul ipoccot kꞌran itti oCcamaan iponu kꞌran cakuruk itti oPoththuruc. ");
INSERT INTO lmd_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Kwaik tuan topul ipacucco uꞌrat ipoccot kꞌran itti oCcamaan ana kaman kung kaik nokuthut korok irapangka.” ");
INSERT INTO lmd_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Anakka uꞌrupa wothothïlettat woKapik woththet naak, oKurnilioth pakkarathe ul weꞌra wung iarekinok ana pul iprïk ipapellene Kapik ana orekinok ana ipokat pul pothoꞌrak. ");
INSERT INTO lmd_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Kwiꞌrekathekin lon ilokat cik ana kwothïathekin nokaꞌran koIappa. ");
INSERT INTO lmd_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ana ngorrot ngen icïngkï ippa, okin thoingkathe, anakka akin okko iccik kokaꞌran koIappa, oPoththuruc pokuꞌrothe toꞌra woman akwothaꞌra ngaꞌrama. ");
INSERT INTO lmd_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ana kwiamakathe ana kwangkathe itti kwaꞌrkoik anakka okin thokat cik akin okkinthok thuꞌrit, kwiongkathe inthe. ");
INSERT INTO lmd_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Kwimmakat tothiꞌrot attanyot ana papꞌrek ere kret kïttïk apuo ntan nocapu ana poccokittathe nthomipit amumocoꞌrin. ");
INSERT INTO lmd_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Aꞌrupu wokat tit worua appik, aꞌrupu iauro nocapu ana uꞌrupe appik worithiꞌrot. ");
INSERT INTO lmd_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Menik apoꞌre iꞌrekathok itti, “Poththuruc, uroki angwo aꞌrupu enni aꞌrko.” ");
INSERT INTO lmd_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","APoththuruc iꞌrekat itti, “Ili win, mpannortte aꞌrupu iothun ammakka thathuma thin thoIouth thaik.” ");
INSERT INTO lmd_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Apoꞌre pen appiꞌrekathok itti, “Kirrnni iꞌre aꞌrupu appik itti wakannoka woꞌrillir ia Kapik kothikkiet woꞌrillir.” ");
INSERT INTO lmd_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Lon elli lokkattathe maꞌri mꞌrapuruk ana kret ikïttïk konekittakathe tothiꞌrot accokkot. ");
INSERT INTO lmd_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Anakka oPoththuruc pokat cik akwoprttakinthet lon lothathantakorit itha kwappathantakot, aul ieꞌra ia oKurnilioth pothïothe tuan toCamaan ocoꞌro icürük. ");
INSERT INTO lmd_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Akin ipittat itti pul ipoccot kꞌran itti, “OCcamaan ana cakuruk itti oPoththuruc paik cenei?” ");
INSERT INTO lmd_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Manakka oPoththuruc pokat cik akkwarthuk akwokwarttikot lon lothathantakot, Kanang koKapik kiꞌrekathok itti, “Camaan, ul wꞌrek wꞌrapuruk waik wipittong. ");
INSERT INTO lmd_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Urokwi auo thaiken kirrnni opelle itti ngkwaeo naththungon akka oun akkothïothekin naung.” ");
INSERT INTO lmd_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","OPoththuruc puathe thaiken ana kwiꞌrekathekin itti, “Oun ipanon thaik thipitto, ngintha akka onon thainet?” ");
INSERT INTO lmd_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Aul othïanthok itti, “OKurnilioth ili woul irro akkothïothenïn, ook pul ipoporot iponu nꞌre noKapik, ana ul woIouth wongothok. Uꞌrupa wothothïlettat woKapik wiꞌrethok itti kwakkarong ainok tuan thanung othakka itti akwoccïkot lon ila ngkwonu itti ngkwiꞌrethok.” ");
INSERT INTO lmd_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Menik aPoththuruc ikkiekat kin cik tuan. Ana ngorrot ngen, oPoththuruc purokathe akin aththungon ana ul wꞌrek wonokaꞌran koIappa ioccokothe lon loIeccuo omaka kin. ");
INSERT INTO lmd_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ana ngorrot ngen ngꞌrek okin thakkakathe nokaꞌran koKaiccaria. Ana oKurnilioth pokat cik akwoꞌrïkot kin ana kwakkarathe kuꞌri kung ana opurukon thꞌrek ithaik iccik kung. ");
INSERT INTO lmd_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Anakka oPoththuruc pokat cik akwiꞌriko noppan nakin, oKurnilioth pocurathe iaak ana kwekathe üngkü ncik nocapu akwaꞌrakanthok ngaꞌrama. ");
INSERT INTO lmd_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Anaruk oPoththuruc purokiekathok kapik ana kwiꞌrekathe itti, “Ocoꞌrothe kapik oun iponyi nuthuk.” ");
INSERT INTO lmd_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Anakka okin thokat cik akin ere, oPoththuruc poingkathe noppan ana kwiathe ul noppan woppot. ");
INSERT INTO lmd_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ana kwiꞌrekat kin itti, “Onon thina kicce itti lon lothonceꞌret lon cik lꞌrat itti ul woIouth wacikittako nul iannoka woIouth ana pul poIouth panniꞌriko noppan toul iannoka woIouth. Anaruk Kapik kiꞌrethin itti mpannokatha ul appik ere wokithak ana wannoka woꞌrillir. ");
INSERT INTO lmd_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ana akka mpothïlanthet itti mpanthan, mpaat anokorronno aꞌrettakot. Mpantipittot noni, ngintha akka nthothïnthet itti mpaine?” ");
INSERT INTO lmd_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","OKurnilioth piꞌrekathok itti, “Nomaꞌri mocoꞌrin imeot mpokat cik tuan thanin anaꞌra ngaꞌrama acïngkï cokkothe cꞌrapuruk cocipin, apul pꞌrek ocoꞌrat tokït kin ponu eret wallio ere kꞌran kocïngkï, ");
INSERT INTO lmd_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","apiꞌrekat itti, ‘Kurnilioth, Kapik koccïkïnthung ngaꞌrama ngang ana kokwarikothe thikket thang nuthuk itha ngkwokat cik aikket ul iella aꞌrupu. ");
INSERT INTO lmd_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Othinthet oCcamaan ipoccot kꞌran cakuruk itti oPoththuruc nokaꞌran koIappa, kwaik tuan toCcamaan pul ipacucco uꞌrat iponu kaman nokuthut korok irapangka.’ ");
INSERT INTO lmd_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ittina ilen akka mpothïnthet lon accokkot itti ngkwanthan ana loporot akka ngkwoccïkothe lon ana ngkwaik cene. Ana oron thei tokït koKapik appik aron occïkot lon ila Ili wiꞌrethung itti ngkwathiꞌret nïn.” ");
INSERT INTO lmd_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Menik oPoththuruc pikkatheik akwere akwiꞌre itti, “Inenni mpakatha itti Kapik kakkinthet ul lon lulukku appik okorronno opetto iakin ");
INSERT INTO lmd_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","anaruk kangkot ul appik ionu nꞌre nung ana iakkot lon ilocoꞌrothe cik. ");
INSERT INTO lmd_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Onon thina lon ila Kapik kothïnthet ul woIccereil, ileret lon iloporot lothomicco loIeccuo oMiccie ook ipa aIli woul appik. ");
INSERT INTO lmd_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Onon thina itti ngimpen akkokkattathe noththok poIouthia nciki noththok poCelïl caꞌri ica oIuanna pomamuthie pongkenet lon lomamuthie ");
INSERT INTO lmd_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","ana tat akka Kapik kethet oIeccuo poNaccir Kanang ikupupure ana puꞌran ana tat akka kwonyarot naꞌran akwokkot lon iloporot ana akwittiet ul iapul potholut poꞌrot nan akka Kapik kokat naak. ");
INSERT INTO lmd_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Onïn thimmat ngkït kïn ila kwokkothe nocoꞌrong poIouth ana Uruccelim ook ipakin thokkwothe nothapak. ");
INSERT INTO lmd_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Anaruk Kapik kurokiekathok nti ithio nomaꞌri imꞌrapuruk ana ul wimmakathok. ");
INSERT INTO lmd_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Anaruk ul wakannimmakathok appik anaruk onïn ul immat lon ngkït ia Kapik kakkarot ana onïn ithoꞌrkot thuꞌrit ithun nocaꞌri ica kurokot nti ithio. ");
INSERT INTO lmd_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Kwiꞌrethenïn lon lonthomat itti onïn thangkene ul lon loKapik ana erene ul itti Kapik konekkethok cik itti ook akka athonceꞌrenthet ul lon cik illet ana iannille. ");
INSERT INTO lmd_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ook ipa ul appik wothernte lon loKapik werethe lon len itti okkwi ipoccokothe lon lung lon ilokithak lung laccïkakinthok ngkꞌran koIeccuo.” ");
INSERT INTO lmd_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Anakka oPoththuruc pokat cik akkwarthuk akkwaik akwere, Kanang ikupupure kakkakathe noul appik ioccïkothe lon loKapik. ");
INSERT INTO lmd_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Aul ioccokothe lon loIeccuo iokat ul woIouth iaat okin oPoththuruc oprttakat tit akka Kanang ikupupure kaul iakonnoka woIouth woccot cakuruk. ");
INSERT INTO lmd_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Akka okin thoccïkothe akin ere ngkarru ikakin thommat ere ana omereket Kapik ana opirane noka. ");
INSERT INTO lmd_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Ittina aPoththuruc iꞌrekat itti, “Opilin pakaik ipiꞌre itti ul wakorronno occo mamuthie ngꞌri akin thoccot Kanang ikupupure ammakka oron thoccori?” ");
INSERT INTO lmd_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ittina kwiꞌrekathe itti okin thacco mamuthie ngkꞌran koIeccuo. Ana okin thipittathok itti kwikkoik, okin aththungon maꞌri motteik. ");
INSERT INTO lmd_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ul wothothïlettat woIeccuo ana ul wꞌrek ioccokothe lon loIeccuo noththok poIouthia appik occïkat itti ul iakonnoka ul woIouth woccokothe lon loKapik. ");
INSERT INTO lmd_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Anakka oPoththuruc peot okuꞌrot nokaꞌran koUruccelim, aul woIouth iokat ioccokothe lon loIeccuo aꞌrettat iaak ");
INSERT INTO lmd_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","aiꞌrekat itti, “Ngkweot tuan toul iannoka woIouth ana nthoꞌrkot cik naththungon.” ");
INSERT INTO lmd_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","OPoththuruc perekanthet kin ilokat cik appik anganna ilokkattathe itti, ");
INSERT INTO lmd_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Mpokat cik nokaꞌran koIappa anaꞌra ngaꞌrama, anakka mpokat cik anaꞌra ngaꞌrama anathantakat itti mpimmat papu pꞌrek pïttïk ere kret koccokittathe nthomipit mocoꞌrin auo ntan ntothiꞌrot anthan na mpaik. ");
INSERT INTO lmd_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ana mpokathakathe kicce ana mpaththiat itti wokat aꞌrupu worua woripira thapat appik, iartta iauro ana uꞌrupe appik. ");
INSERT INTO lmd_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ana mpoccïkathe poꞌre pꞌrek apiꞌrethin itti, ‘Poththuruc uroki, akkwot papꞌrek aꞌrko.’ ");
INSERT INTO lmd_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ana mpothïatherit itti, ‘Ili, mpannortte aꞌrupu iakannoka woꞌrillir ana manna mannonekket ithon thin caꞌri culukku.’ ");
INSERT INTO lmd_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Apoꞌre apperekanthin attang itti, ‘Kirrnni iꞌret aꞌrupu appik itti wakonnoka woꞌrillir ia Kapik kokkothe woꞌrillir.’ ");
INSERT INTO lmd_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Alon len opakkat tit maꞌri mꞌrapuruk, aꞌrupu wen opakkat tothiꞌrot. ");
INSERT INTO lmd_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Menik aul iꞌrapuruk iokat wothïlathe naun nnokaꞌran koKaiccaria ocoꞌro iccik koman na mpokat cik anikkoik. ");
INSERT INTO lmd_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Kanang koKapik kiꞌrekathin itti kirrnni ꞌra itti mpamakot kin, ul enni iꞌrakkuruk ioccokothe lon loIeccuo womakathenïn ana onïn thiꞌrikathe noppan topul pen ipoccot kaꞌran itti oKurnilioth. ");
INSERT INTO lmd_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Kwerekanthet nïn tat akka kwimmat uꞌrupa wothothïlettat woKapik aiꞌrethok itti, ‘Othïnthet oCcamaan thon, ipoccot kꞌran cakuruk itti oPoththuruc nokaꞌran koIappa akwanthan. ");
INSERT INTO lmd_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Kwerenung lon iloporot ilaꞌrethung oung ana kuꞌri kang.’ ");
INSERT INTO lmd_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Anakka mpikkot cik anere, Kanang ikupupure kakkakathe nakin ammakka kokat kainet ton ncinomun. ");
INSERT INTO lmd_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ittina anokwarikat lon ila Ili wokat wiꞌret itti, ‘OIuanna pomamuthie pethettot mamuthie ngꞌri anaruk onon thathocco mamuthie ngKanang ikupupure.’ ");
INSERT INTO lmd_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ana amma Kapik kethet kin thethet ithaccura nuthuk ammakka kethet ton ithoccokothe lon loIli oIeccuo oMiccie, oun oththa akka aniꞌre itti mpalkot lon loKapik?” ");
INSERT INTO lmd_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Manakka okin thoccïkothe lon elli, akin ellakat ilakin ꞌra llon loPoththuruc ana okin thopiranthet Kapik noka. Akin iꞌre itti, “Linako nan cakuruk itti Kapik kokorronnot ul iakonnoka woIouth apaꞌrine lon ilokithak cik acco thikkoik thothupuththuput.” ");
INSERT INTO lmd_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ana okkwion ithoccokothe lon loIeccuo ithopettakinthet thokkiettat thiak cik ithainet kin akka oIciththippanuc pokkuttathe okin thoingkathe noththok poPiniccia ana noththok poKupruc ana kaꞌran kAnththakkia. Okin thokat akin erene ul woIouth wulluk lon loIeccuo. ");
INSERT INTO lmd_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Anaruk opilingon nti iakin ithoccokothe lon loIeccuo ithokat thonoththok poKupruc ana wononokaꞌran koKirin oingkat nokaꞌran kAnththakkia akin ikkat cik akin erene ul lon iloporot loIli oIeccuo iannoka woIouth. ");
INSERT INTO lmd_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ana puꞌran poIli pokat nakin ana ul woccokathe lon loIli oIeccuo woppot ana wopakkanthet Ili woppot. ");
INSERT INTO lmd_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ul ioccokothe lon loIeccuo iokat nokaꞌran koUruccelim woccïkathe lon ilokat cik akin othïat oParnapa nokaꞌran kAnththakkia. ");
INSERT INTO lmd_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Anakka kweot ana kwimmakathe lon lothoporot thoKapik ana kwopirakathe noka ana kwikkatheik akwerenekin itti okin thaꞌrungkwot tit ncïkït culukku. ");
INSERT INTO lmd_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","OParnapa pokat poporot ana kwonu Kanang ikupupure koppot noka ana kwonu thoccokot lon nocïkït ana ul woppot woccokathe lon loIli. ");
INSERT INTO lmd_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ittina oParnapa poingkathe akwothokwancot oCcaul nokaꞌran koTharccic, ");
INSERT INTO lmd_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ana akka kwiothok kwonakathok nokaꞌran kAnththakkia akin okkot cuththun okin oul ioccokothe lon loIeccuo ana okin thongkenekathe ul lon woppot. Ana ul iammakothok wociettakathe kꞌran cittokït itti Micciin nokaꞌran kAnththakkia. ");
INSERT INTO lmd_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ana nomaꞌri men aul wꞌrek wothernte lon loKapik akkakat nnokaꞌran koUruccelim akin akkakat nokaꞌran kAnththakkia. ");
INSERT INTO lmd_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Apul pꞌrek nti iakin wothernte lon loKapik poccot kꞌran itti Akapoc ocoꞌrat kapik ngKanang ikupupure akwiꞌrekat itti tï takaik nocoꞌrong coRoma appik. Tï ammakka enti tokat cik nocaꞌri ica oKklauthioc pokat cik noili ana tikko takaik cene nomaꞌri imanthan cakuruk ittina. ");
INSERT INTO lmd_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Aul iammakothok erekat threk itti okin thacintinthet ul iaik noththok poIouthia alpꞌrek. ");
INSERT INTO lmd_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Elli ilakin thokkothe, okin thaꞌrntothe akucci ana okin thothïathe oParnapa ana oCcaul ngngin akin onekine ul ittïttïk woul wocungkut coul ioccokothe lon loIeccuo nokaꞌran koUruccelim. ");
INSERT INTO lmd_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ana nocaꞌri cen aIli oIruthuc ikkat cik acciccokot ul wꞌrek noul ioccokothe lon loIeccuo othakka itti akkiet kin thiak. ");
INSERT INTO lmd_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Kwokkwothe oIakup opang poIuanna ngkꞌrittang ikukwit. ");
INSERT INTO lmd_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Anakka kwimmat itti lon len lopiriet ul woIouth noka, kwoccokathe oPoththuruc cakuruk. Lon len lokkattathe nocaꞌri cokamuthe karrakith iella müꞌrükül tit. ");
INSERT INTO lmd_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Anakka kwoccokothok akwonekkekathok ikorrkkor, aul irro iokat mungkut mocoꞌrin ana cungkut culukku conat ul wocoꞌrin akin angwothok akamuthe koThaurrot kaman kꞌrek cik komarttakot akwantothipittakot lon tokït koul. ");
INSERT INTO lmd_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ittina oPoththuruc pikkatheik ikorrkkor ana ul ioccokothe lon loIeccuo wikkatheik aꞌranok ngaꞌrama appinappin. ");
INSERT INTO lmd_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ana ngkoꞌra aIruthuc parthuk ona oPoththuruc akwothipittakot lon tokït koul ngorrot ngen, oPoththuruc pokat inthe ana nili nokat cik anangwothok akkwaik ithoꞌrkït then akkwïꞌrïkïkkakot nynyol nyeꞌra ana ul irro inangwot cik acoꞌro icürük cothapat. ");
INSERT INTO lmd_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Menik accokkot auꞌrupa wothothïlettat woIli ummanthet oPoththuruc ncik ngkꞌran kothik akkwathok nti inthe aiꞌrekathok itti, “Uroki cokoccokot.” Ittina anyol apukkat nnonyaun. ");
INSERT INTO lmd_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Auꞌrupa wothothïlettat woKapik iꞌrekathok itti, “Aki eret ana wok ana ïꞌrïko kuꞌrat korikin.” Ana oPoththuruc pokkathe ammakka wiꞌrethok. Uꞌrupa wothothïlettat woKapik wappiꞌrekathok itti, “Omakothin.” ");
INSERT INTO lmd_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","OPoththuruc pomakathok thapat nti ikorrkkor ana kwommat itti ngimpen akka uꞌrupa wothothïlettat woKapik waik wokkot ana lon len laik ïcari ana kwokat akwere itti kwathantakot. ");
INSERT INTO lmd_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Okin thoppathe noul iokat cik angwot cik akin akkakat nokathat kopaponte ipanekarot icarak coman coUruccelim. Kathat kanyanthet kin prek ana okin thoppatherit. Anakka okin thomakothe kathar papotte, uꞌrupa wothothïlettat woKapik woththekathe naak accokkot. ");
INSERT INTO lmd_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ittina oPoththuruc inakat nan itti kwokat akwokorronno athantako akwiꞌrekat itti, “Inenni Kapik kothïnthin uꞌrupa wothothïlettat wung athoꞌrethin nti ilon loIruthuc ana nti ilon ila ul woIouth waik waꞌrikot itti lakkattat naun.” ");
INSERT INTO lmd_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Menik akka kwinat lon ilaik, kwoingkathe tuan toMeriom onnan poIuanna ipoccot kꞌran cakuruk itti oMarkkoc na ul woppot wokat awaꞌrntakothe ana wokat aꞌra ngaꞌrama. ");
INSERT INTO lmd_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","APoththuruc okkwat kathat othakka itti akin anyinok, aukul iopari iorekot ioccot kꞌran itti oRotha oingkat athanyo. ");
INSERT INTO lmd_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Anakka woccïkothe poꞌre poPoththuruc, apirakat noka ana wollathe opakkot tit okorronno anyo athiꞌre itti, “OPoththuruc paik icürük.” ");
INSERT INTO lmd_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Okin thiꞌrekathe ukul iopari itti, “Ngkwonu purruri?” Anakka ukul iopari wꞌrat ere itti oPoththuruc, akin iꞌrekat itti, “Aththoka uꞌrupa wothothïlettat woKapik (okorronno oka oPoththuruc).” ");
INSERT INTO lmd_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Anaruk oPoththuruc poꞌrungkwathe nan akwokkwe kathat puccuk akin anyat anakka okin thimmarok okin thikkatheik akin oprttakattit. ");
INSERT INTO lmd_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","APoththuruc onthanthekin ukun kapik itti okin thangkoik okorronnokkot poꞌre ana kwerekanthet kin tat akka Ili kelikkorok nti ikorrkkor ana kwiꞌrekathekin itti, “Niꞌret oIakup ana ul ioccokothe lon loIeccuo wꞌrek lon len,” ana kwoththekathe nakin akweo nokaꞌran kꞌrek. ");
INSERT INTO lmd_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ana ngïꞌrïmak alon ommakekat ul irro aikkat cik aprttakot tit aere itti ngintha akka ainet oPoththuruc. ");
INSERT INTO lmd_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ana oIruthuc pokwancathe oPoththuruc ana kwanniathok ana kwipittathe ul iokat cik angwot cik lon ilokat cik akwiꞌrekat lon lonthomat itti okin thangutta. Ittina aIruthuc urokat nnoththok poIouthia akwoingkat nokaꞌran koKaiccaria akwothikkat cik than papotte. ");
INSERT INTO lmd_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Ana kwikkatheik akwaꞌretto nul wonokaꞌran koCcur ana koCcithon. Ittina aul wonokaꞌran koCcur ana koCcithon ïꞌrïkat lon ithun ana okin thakkakathe akin oingkanthet Ili oIruthuc akin othopakket kuꞌri cik okin aththut. Ana akka oPilacoththoc ili wung ittarothok wanginthet ul lon lothopakkot ikuꞌri, okin thokat thonu itti okin thapakkot ikuꞌri akka okin thokat akin occere thuꞌrit nnoththok pung. ");
INSERT INTO lmd_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ana nocaꞌri icakin thokat cik thatherene ili nan, Ili oIruthuc akat eret wung woili ana kwikkatheik noprrok pung akwerene ul appik. ");
INSERT INTO lmd_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ul wokkwathe kuri itti, “Poꞌre empi pakannoka popul iponyi, poꞌre empi pokapik.” ");
INSERT INTO lmd_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ncïnang auꞌrupa wothothïlettat woIli akkakat athikkiekat ili pongo anangak oꞌrakkathok icarak akwiat. Akka kwinnikothe itti kwrïk noKapik. ");
INSERT INTO lmd_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Anaruk ul wikkatheik arttakot nan ithoccokot lon loIeccuo ana lon loKapik appaththakat cik naꞌran appik. ");
INSERT INTO lmd_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Anakka oParnapa ana oCcaul thomarttot ngre ngen, okin thokkaprttakathe ntan nokaꞌran koUruccelim okin oIuanna ipoccot kꞌran itti oMarkkoc akwittarot kin. ");
INSERT INTO lmd_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ana iul ioccokothe lon loIeccuo nokaꞌran kAnththakkia, ul wothernte lon loKapik ana ul iangkene wokat cik, oParanapa ana oCcomoun (ipoccot kꞌran itti cakuruk itti oNeicer ilonu itti pul iponyi), ana oLukkioc (ponokaꞌran koKirin), ana oManain (ipupokkot okin oIruthuc tothun), ana oCcaul. ");
INSERT INTO lmd_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Anakka okin thokat cik akin aꞌrane Ili ngaꞌrama ana ocoꞌro nothuꞌrit, Kanang ikupupure kiꞌrekathekin itti, “Nokirrnninthin oParnapa ana oCcaul akin oreko ngre ia mpakkarinet kin itti okin thathoreko.” ");
INSERT INTO lmd_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Anakka okin thomarttot thoccokot thocoꞌro nothuꞌrit ana aꞌra ngaꞌrama okin thonekkekathe nyaun nakin ana okin thothïathekin ikathar. ");
INSERT INTO lmd_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Kanang ikupupure kothïathekin ikathar akin oingkat nokaꞌran koCulukkia ana nthan okin thoingkate arrot cik iconthomat corithoꞌrikït thorok irapangka icoccot kꞌran itti Kupruc. ");
INSERT INTO lmd_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Anakka okin thaat nokaꞌran koCalamic, okin thongkenekathe lon loKapik nomuththun maꞌrama moul woIouth. Ana oIuanna ipoccot kꞌran cakuruk itti oMarkkoc pokat akin aththut akwittarot kin. ");
INSERT INTO lmd_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Akin akkakat okko nocik iconthomat corithoꞌrikït thorok irapangka icoccot kꞌran itti Pappoc na akin thiothe pul poIouth iponu thurukut ana pul pothernte lon loKapik ngkarra ipoccot kꞌran itti ParIeccuo. ");
INSERT INTO lmd_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ana opuruko iponu kꞌran itti oCericio oPaoluc. Ili oCericio oPaoluc pokat pinaik ntica ana wothïllakanthet oParnapa ana oCcaul akka kwokat pongothe itti kwaccïkot lon loKapik. ");
INSERT INTO lmd_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Anaruk oParIeccuo iponat kꞌran kꞌrek itti Elimac ngkarru koul woKrik kokat akwaꞌretto iaParnapa ana oPoluc othakka itti aili oPaoluc okorronno occokot lon loKapik nocïkït. ");
INSERT INTO lmd_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ittina oCcaul ipoccot kꞌran itti oPoluc papponat Kanang ikupupure noka akwokathakat Elimac akwiꞌrekat itti, ");
INSERT INTO lmd_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Oung ukul wopul pothopulut ana ngkwalikine lon cik iloporot ana ngkwoppethe lon noucce lulluk ilaiꞌriththa ul ngngin. Ngkwaprtto lon cik loIli ilaik ïcat athikkie karra. ");
INSERT INTO lmd_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ana inenni Ili waik wathattattang, ngkwiꞌrimat ana ngkwannimma manna imma kꞌran kocïngkï nomaꞌri motte.” Ncïnang ngïꞌrïmak ngoꞌrumathe pul pen ngenthung ana kwikkatheik akwamarththakot cik akwokwantot cik othakka itti apul pꞌrek othokok nukun. ");
INSERT INTO lmd_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Anakka ili oCericio oPaoluc wimmat lon ilokkattathe, kwoccokathe lon loKapik akwoprttakat tit nolon loIli ilongkenettat. ");
INSERT INTO lmd_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","OPoluc ana ul iakin thokat cik tharrathe ikuppuꞌrung konoiꞌri akin oththekat nokaꞌran koPappoc akin oingkat nokaꞌran koPerca noththok poMippilia na oIuanna ipoccot kꞌran cakuruk itti oMarkkoc pappoththet nakin akwopakkot nokaꞌran koUruccelim. ");
INSERT INTO lmd_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ana nokaꞌran koPerca akin thoingkathe nokaꞌran kAnththakkia ikaik iccik koPiccithia. Ana nocaꞌri caCcepith okin thoingkathe nocuththun caꞌrama akin ikkat cik. ");
INSERT INTO lmd_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Anakka lon lakkakkarakot nti iatham wolon lothonceꞌret lon cik loMucca ana nti iatham woul wothernte lon loKapik, anili nonocuththun caꞌrama othïanthet kin thon itti, “Pangkingon, amma onon akkonu lon lꞌrek ilittarot ul, annere.” ");
INSERT INTO lmd_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ittina aPoluc urokat kapik akwonthat ukun kapik akwiꞌrekat itti, “Ul woIccereil ana ul iannoka ul woIouth iaꞌrane Kapik ngaꞌrama, noccïkothin. ");
INSERT INTO lmd_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Kapik koul woIccereil kakkarot ongappan thonnon kokat noul ana arttot nakin nocaꞌri ica ul wokat noththok poMuccir ana kwonakathekin ntan mpuꞌran pung ipakorronno alkakot ");
INSERT INTO lmd_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","ana kangwothekin luput arrial weꞌra (40) ithampang ithonthomat. ");
INSERT INTO lmd_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ana kwopaꞌret ul cik mothok meꞌreꞌrapuruk nnoththok poKanaan ana kwekathe ul wung mothok men akin opakkot nan amoka men. ");
INSERT INTO lmd_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Lon elli appik lonekot luput arrial ukuluk maꞌri mocoꞌrin ana arrial weꞌra ana alkaire (450). Anakka elli locothakothe, Kapik konakanthet kin nili nothoceꞌret lon cik anakkma kin puccuk mono acaꞌri akkakat copul pothernte lon loKapik oCcamuil. ");
INSERT INTO lmd_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Menik aul ipittat ili iakatha lon len ana lon lopothok appik ana Kapik kekathekin oCcaul ukul woKkic wonopothok poPeniemin okkwi ipathoka ili wen luput arrial weꞌra (40). ");
INSERT INTO lmd_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Anakka oCcaul popaꞌrot cik, kwonekkekathe oThauth cik ili wen. Kiꞌrekathe itti, ‘Mpiothe oThauth ukul woIecce pul ipacïkït cin caik nan, kwakkot lon appik ila mpongothe itti kwakkot.’ ");
INSERT INTO lmd_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Kapik konakathe oIeccuo ipathoꞌret ul nti ithiki thoThauth ammakka kokat konekkethe lon cik. ");
INSERT INTO lmd_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ana akka oIeccuo pokat parthuk ao, oIuanna pongkenet ul woIccereil itti wapaꞌrine lon cik ilokithak akin occo mamuthie appik. ");
INSERT INTO lmd_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Anakka oIuanna pokat cik akwomartto ngre ngung, kwiꞌrekathekin itti, ‘Onon thiꞌre itti oun oththa? Okorronno oka oun pen ipa annoꞌrïkot anaruk kwaik panthan ana oun manna pannekko nan itti mpakiꞌrinok loꞌrak lowok woriracok.’” ");
INSERT INTO lmd_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","APoluc ikkat akwere itti, “Pangkingon, nyukul nyAprein ana onon ithannoka ul woIouth ana ithaꞌrane Kapik ngaꞌrama, lon elli loKapik lothoꞌrettat lainetton. ");
INSERT INTO lmd_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ul woUruccelim ana nili nen thommat oIeccuo, anaruk nthakkmak okin thothikkiekathe lon ïcat loul wothernte lon loKapik ilakkakkarakot nocaꞌri caCcepith appinappin. ");
INSERT INTO lmd_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Antoka manna itti okin thakinniot lon moloko ilakin okkwothok ngngin. Okin thipittathe oPilaththoc itti kwakkwothok. ");
INSERT INTO lmd_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Manakka okin thokkothe lon appik ilerethok, okin thorpekathok cik ntan nnothapak ana okin thocïkkathok ippu. ");
INSERT INTO lmd_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Anaruk Kapik kurokiekathok nti ithio, ");
INSERT INTO lmd_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ana ul wung immakothok wimmakathok maꞌri moppot iaat akin aththut nnoththok poCelïl akin ao nokaꞌran koUruccelim. Ana inenni okin thaul immat lon ngkït woul wonnon. ");
INSERT INTO lmd_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Onïn therenenon lon iloporot loIeccuo, ila Kapik konekkenthet ongappan thonnon cik ");
INSERT INTO lmd_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","kothikkienet ton ïcat ana nyukul nyen nthurokie oIeccuo nti ithio. Ammakka lokurrakot iatham woMocumur itti, ‘Oung ukul win inenni mpothakkanung oththe.’ ");
INSERT INTO lmd_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ana nthere lon itti Kapik kurokiet oIeccuo nti ithio, ana kannokorronnako itti akokuttat liꞌrettat ngkathar engki, ‘Mpethung thupupure ana thethïetta ithonekkettanthet oThauth cik.’ ");
INSERT INTO lmd_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Liꞌrettat naꞌran wꞌrek itti, ‘Ngkwakannappokorronno okkwi ipupure pang akwokutta.’ ");
INSERT INTO lmd_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Akka oThauth pokkothe lon ila Kapik kongothe itti kwakkot iul wung, kwiathe akwocïkkakat okin oththangon, ka kung kokuttakathe ippu. ");
INSERT INTO lmd_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Anaruk okkwi ipa Kapik kurokiet nti ithio pakannokutta ka. ");
INSERT INTO lmd_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Ittina pangkingon, mpongothe itti onon thina itti onïn thaik thangkenenon itti lon ilokithak lon laccïkakot ngkꞌran koIeccuo. ");
INSERT INTO lmd_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ana onon thonu itti nthina itti okkwi ipoccokothe lon len nocïkït kwaccïkakinthet lon lung ilokithak ila lon lothonceꞌret lon cik loMucca lakonnoccïkïnthok. ");
INSERT INTO lmd_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Nina nan itti lon ila pul pothernte lon loKapik papperet lakonnoka nanon iliꞌre itti, ");
INSERT INTO lmd_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Onokatha, onon ithakkot ngure noKapik, noparttakot tit annillekat, akka mpakkot lon lꞌrek inenni ilanon okorronno occokot nomïkït antoka manna pul pꞌrek piꞌrethenon.’” ");
INSERT INTO lmd_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Anakka oPoluc ana oParnapa thokat cik akin eo oththe nocuththun caꞌrama, ul wiꞌrekathekin itti okin thatherenthet lon elli attang nocaꞌri caCcepith icanthan. ");
INSERT INTO lmd_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Manakka lon lomarttakot ul woppot woIouth ana iokat wannoka woIouth iaꞌrane Kapik ngaꞌrama womakathe oPoluc ana oParnapa akin erekanthet kin itti okin thaꞌrungkot ithoporot thoKapik. ");
INSERT INTO lmd_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ana nocaꞌri caCcepith icomakothe, ul wakkakathe nti icarak coman appik athoccïkot lon loIli. ");
INSERT INTO lmd_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Anakka ul woIouth wimmat cungkut coul ana okin thonyirakathe ana okin thikkatheik akin aꞌrettakot nolon ilakin theret ana ocungkwo oPoluc llon lokithak. ");
INSERT INTO lmd_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ittina oPoluc ana oParnapa thothïanthet kin ella nꞌre itti, “Lokat loporot cannan itti lon loKapik lerettanenon tokït anaruk onon thei thꞌrat lakene itti onon thannekko nan itti onon thacco thikkoik thothupuththuput ana onïn thapakkinthet ul iakonnoka woIouth. ");
INSERT INTO lmd_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Akka elli akka Ili wiꞌrethenïn itti, ‘Mpothikkiet non kꞌran koul iannoka woIouth, othakka itti annona thoꞌretta nocapu ncik appik.’” ");
INSERT INTO lmd_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Anakka ul iakonnoka woIouth woccïkothe lon len, okin thopirakathe noka akin othiakanthet lon loIli cik ana okin itha Kapik kakkarothe thikkoik thothupuththuput thoccokothe lon loKapik nomïkït. ");
INSERT INTO lmd_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Lon loKapik lopettakatheik naꞌran appik ana ul woccïkathe appik. ");
INSERT INTO lmd_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Anaruk ul woIouth wikkatheik aereket nili nonokaꞌran ana ul iari iokat wakannoka woIouth iokat aꞌrthan ana iokat aꞌrane Kapik ngaꞌrama naPoluc okin oParnapa, ana okin thikkatheik akin occokiet oPoluc ana oParnapa thiak ana okin thokïccekathekin nokaꞌran ken. ");
INSERT INTO lmd_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ittina okin thokkwathe tuꞌrupang noracok ana topakkanthet ul iꞌrat kin ana okin thoingkathe nokaꞌran ikoccot kꞌran itti Ikkonia. ");
INSERT INTO lmd_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ana ul iammakothok wopirakathe noka ana Kanang koKapik iupupure wokat nakin. ");
INSERT INTO lmd_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Anakka oPoluc ana oParnapa thaat nokaꞌran koIkkonia, okin thoingkathe nocuththun caꞌrama ammakka oPoluc ana oParnapa okkettet. Okin thongkenekathe ul lon loKapik, ana ul woIouth ana iakonnoka woIouth woccokathe lon loKapik nomïkït. ");
INSERT INTO lmd_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Anaruk ul woIouth iꞌrat occokot lon loIeccuo wocikittanthet ul iakonnoka woIouth lon ima, akin ꞌra ul ioccokothe lon loIeccuo nomïkït. ");
INSERT INTO lmd_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ittina oPoluc ana oParnapa thikkatheik maꞌri moppot akin ongkene ul lon loIli ella nꞌre, ana Kapik kekathekin puꞌran akin ikkat cik akin okkot lon ilommaththik ilokenet itti lon lothoporot thoKapik lokat ïcat. ");
INSERT INTO lmd_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ana ul wonokaꞌran willillakatherit mungkut meꞌra aꞌrek wokat okin oul woIouth ana aꞌrek wokat okin oul wothothïlettat woIeccuo. ");
INSERT INTO lmd_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ittina ul woIouth ana iakonnoka woIouth ana nili nen thiꞌrekathe itti okin thie oPoluc ana oParnapa ka kongo ana okin thokincathekin mmothok. ");
INSERT INTO lmd_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Anaruk oPoluc ana oParnapa thinakathe nolon len ana okin thollathe eo nokaꞌran koLicththra ana koTherpa ikokat noththok poLikkonia ana naꞌran iaik iccik ken. ");
INSERT INTO lmd_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ana okin thoꞌrungkothe akin ongkene lon iloporot loIeccuo than. ");
INSERT INTO lmd_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ana nokaꞌran koLicththra, pul pꞌrek pappokat cik than pakimico nci ammakka pokwontat ana ponnonyaro aththik. ");
INSERT INTO lmd_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ana pikkatheik apoccïkot akka oPoluc erene ul ana oPoluc pokathakathok ana kwimmakathe itti kwonu thoccokot lon loIeccuo nocïkït ana kwathakka poporot. ");
INSERT INTO lmd_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Akwiꞌrekathok mpoꞌre cittan itti, “Ocoꞌrothe kapik accokkot,” apul urokwat ana pikkatheik aponyaro. ");
INSERT INTO lmd_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Anakka cungkut coul cimmat lon ila oPoluc pokkothe, okin thokkwathe kuri ngkarru koul woLikkonia itti, “Kapik kungkwiet ka kung mpul iponyi ana kainet ton.” ");
INSERT INTO lmd_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ana okin thocciekathe oParnapa kꞌran itti oCappic kꞌran kokapik ken. Ana oPoluc itti Armic akka kwokat pul ipothïllathe pokapik ken, ana akka kwokat akwere cannan napilingon. ");
INSERT INTO lmd_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ana man mothaꞌrane oCappic ngaꞌrama mokat thapat nti icarak coman. Ana pul poman mothaꞌrane oCappic ngaꞌrama monnat nyura ana poꞌren akwonakat icürük coricarak coman akka ook ana ul wung thongothe itti okin thakinthet oPoluc ana oParanapa aꞌrupu wothokiot ngüccük cik. ");
INSERT INTO lmd_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Anakka ul wothothïlettat, oPoluc ana oParnapa thoccïkothe lon len okin thillillathe eret nnoka akka okin thoccïkothe aul ocungko Kapik nthokinthet kin aꞌrupu wothokiot ngüccük cik ithokat thannoka then anaruk thoKapik tulluk, akin ollat tocungkut akin aꞌretto itti, ");
INSERT INTO lmd_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Ul ngintha akka annokkinthet ittina? Onïn ul ionyi ammakka onon, onïn thaik thonanet non lon iloporot loIeccuo, itti nthapaꞌrine lon cik illella lon cik, annopakkinthet Kapik ikaik ïcat ikokkothe tothiꞌrot ana capu ana tok inapangka ana okkot aꞌrupu appik tit. ");
INSERT INTO lmd_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Kokorronnot ul womaꞌrot appik akkot lon ilakin thongothe itti okin thakkot. ");
INSERT INTO lmd_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Anaruk kwokat akwokene itti kwaik nthoporot thung, nthapie kapik ana nthora cükkü ana ethet non thuꞌrit itharako ana kethet non thuꞌrit thoppot annoꞌrko ana kopiriet non noka.” ");
INSERT INTO lmd_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Mommakathe oceꞌre cungkut coul llon len itti wangwinekin aꞌrupu wothokiot ngüccük cik anaruk akka okin therenet kin ittaꞌrene akin antocoꞌro. ");
INSERT INTO lmd_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ittina ul wꞌrek woIouth wakkakathe nokaꞌran kAnththakkia ana koIkkonia ana werekanthet cungkut coul acoprttakat iaPoluc ana okin thokincathok mmothok mono akin othathok thapat nokaꞌran koLicththra akin iꞌre itti kwiot pꞌrin. ");
INSERT INTO lmd_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Anaruk akka ul iammakot oIeccuo waꞌrntakathe iccik kung kurokathe ana kwopakkathe icarak coman. Ana ngorrot ngen, ook ana oParnapa thoingkathe nokaꞌran ikoccot kꞌran itti Therpa. ");
INSERT INTO lmd_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Menik okin thongkenekathe lon iloporot loIeccuo nokaꞌran koTherpa ana ul woppot womakathe lon iloporot loIeccuo. Ana okin thopakkathe nokaꞌran koLicththra ana nokaꞌran koIkkonia ana kAnththakkia noththok poPiccithia, ");
INSERT INTO lmd_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","akin opoꞌrie ul iammakothok than ana omareket kin akin oꞌrungkot ilon lothoccokot lon iloporot loIeccuo nomïkït, akin iꞌrekat kin itti, “Oron thonu itti thakkette ilon ilokithak aron tharthuk iꞌriko ingili ngoKapik ioporot.” ");
INSERT INTO lmd_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","OPoluc ana oParnapa thokat akin onekket ul cik ittïttïk woul iakatha lon loul ioccokothe lon loIeccuo ana akin aꞌrane ngaꞌrama naꞌran ana ocoꞌro nti ithuꞌrit appik ana ethet kin ikkun woIli iakin thonekkethe cïkït nan. ");
INSERT INTO lmd_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Anakka oPoluc ana oParnapa theot nokaꞌran noththok poPiccithia akin akkakat noththok poMippilia. ");
INSERT INTO lmd_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ana okin thongkenekathe lon loKapik nokaꞌran koPerca ana okin thoingkathe nokaꞌran kAththalia. ");
INSERT INTO lmd_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ana nnan okin tharrathe tok irapangka akin eo nokaꞌran kAnththakkia ana na ul iammakot lon loKapik waꞌranet kin ngaꞌrama akka okin thocothothe ngre ngen nthoporot thoKapik. ");
INSERT INTO lmd_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Manakka okin theot, akin aꞌrntat ul ioccokothe lon loIeccuo tothun akin erekanthet kin lon ila Kapik kokkothe nti inyaun nyen ana tat akka kanyinet ul iakonnoka woIouth kathar kothoccokot lon loKapik. ");
INSERT INTO lmd_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ana okin thikkatheik ceneket puccuk okin oul iammakot oIeccuo. ");
INSERT INTO lmd_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ul wꞌrek wuot ntan nnoththok poIouthia aeo nokaꞌran kAnththakkia akin ikkat cik akin ongkene ul ioccokothe lon loIeccuo itti, “Onon thannoꞌrettat amma onon thannokekkot ammakka lon lothonceꞌret lon cik loMucca.” ");
INSERT INTO lmd_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Lon len lokorronnathe oPoluc ana oParnapa akin aꞌretto ana opllarot okin oulon. Ittina akin ummat oPoluc ana oParnapa ana opilingon ithoccokothe lon loIeccuo itti akin eo nokaꞌran koUruccelim akin otheret lon lothokekkot okin oul wothothïlettat woIeccuo wꞌrek iaik nokaꞌran koUruccelim ana ul ittïttïk woul ioccokothe lon loIeccuo. ");
INSERT INTO lmd_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ul ioccokothe lon loIeccuo wothïathekin ikathar, anakka okin thokat cik akin eo, okin thokkathe nocik coPiniccia ana coCcamira akin erene ul ioccokothe lon loIeccuo tat akka ul iakonnoka woIouth woccokothe lon loIeccuo. Lon elli lopiriekathe ul noka cannan. ");
INSERT INTO lmd_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Anakka okin thaat nokaꞌran koUruccelim ul wothothïlettat woIeccuo ana ul ioccokothe lon loIeccuo ana ul ittïttïk woul ioccokothe lon loIeccuo wikkiekathekin cik papenang. Okin therekanthet kin lon appik ila Kapik kokkothe nti inyaun nyen. ");
INSERT INTO lmd_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Menik aul wꞌrek woPriccin ioccokothe lon loIeccuo urokat kapik akin iꞌrekat itti, “Ul iannoka woIouth wonu itti wakekkot ana oꞌrumo nolon lothonceꞌret lon cik loMucca.” ");
INSERT INTO lmd_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Aul wothothïlettat woIeccuo ana ul ittïttïk woul oingkat nocuththun akin othokatha lon len. ");
INSERT INTO lmd_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Anakka okin theret puccuk aPoththuruc urokat kapik akwiꞌrekat kin itti, “Pangkingon, onon thina itti nomaꞌri imeot Kapik kakkarorin nti ianon itti aul iannoka woIouth occïkot lon iloporot loIeccuo nti ithon thin akin occokat nomïkït men. ");
INSERT INTO lmd_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ana Kapik ikina mïkït moul kokenet lon itti kongothe ul iannoka woIouth kwethet kin Kanang ikupupure ammakka kethet ton cakuruk. ");
INSERT INTO lmd_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Kwannopetto iaron ana kwannopetto iakin akka kwimet mïkït men nthoccokot lon lung nomïkït then. ");
INSERT INTO lmd_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ittina onon thontha akka nthongothe itti nthennekke Kapik nthonekket lon ilïmïn nokalak koul iammakothok ilalkothekin ana manna ilalkothe ongappan maꞌrot itti okin thakkot? ");
INSERT INTO lmd_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Akka oron thinan itti oron appik thaꞌrettat ngkathar kulukku nthoporot thoIli oIeccuo ammakka okin oꞌrettat cakuruk.” ");
INSERT INTO lmd_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Ul wangkatheik appik akin occïkot lon loPoluc ana loParnapa akin eret lon ilommaththik ila Kapik kokkinthet ul iannoka woIouth nynyaun nyen. ");
INSERT INTO lmd_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Anakka okin thomarttot lon len, aIakup urokat kapik akwiꞌrekat itti, “Pangkingon, nantokkwinin kunu ncik. ");
INSERT INTO lmd_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","OPoththuruc perenet non lon locaꞌri ica Kapik koinet ul iannoka woIouth cittokït othakka itti akothakkaro opilingon nti iakin akin othakka thung. ");
INSERT INTO lmd_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ana lon loul wothernte lon loKapik laik leret lon elli ammakka lokurrakot inatham nen itti, ");
INSERT INTO lmd_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Amma elli locothakothe ana mpakkaprttako ana mpathuno cüꞌrük coThauth mpuno aꞌran ionguttat anoceꞌrekat cik. ");
INSERT INTO lmd_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Othakka itti aul wꞌrek appik aine Ili, ana ul appik iannoka woIouth ia mpakkarot wainin. Oun Ili piꞌre elli.’ ");
INSERT INTO lmd_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Mpokenet lon elli nci maꞌrot. ");
INSERT INTO lmd_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Ilen akka anokatha itti oron thannarittinthet ul iannoka ul woIouth nolon lïmïn iaik waine lon loKapik. ");
INSERT INTO lmd_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Oron thira thakurrinekin aron iꞌret kin itti okin thacoꞌro nti ithoꞌrko kapa kaꞌrupu ionguttanet ꞌran, ana itti nokorronno aꞌro nul nuthuk, ana nokorronno oꞌrko kapa kaꞌrupu iannokeccetta ikalak ana okorronno ïkko ngüccük ngen. ");
INSERT INTO lmd_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Lon lothonceꞌret lon cik loMucca longkenettat ncinomun naꞌran appik ana akkakkarako nomuththun maꞌrama appinappin nocaꞌri caCcepith.” ");
INSERT INTO lmd_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Menik aul wothothïlettat woIeccuo ana ul ittïttïk woul ana ul iccokothe lon loIeccuo appik ïꞌrïkat lon lulukku itti okin thummo ul wꞌrek wen akin othïot kin nokaꞌran kAnththakkia akin oPoluc ana oParanapa. Akin ummat ul weꞌra iomura oIoutha iponat kꞌran cakuruk itti oParccapa ana oCcila, ul wen wokat ittïttïk woul ioccokothe lon loIeccuo nti iapangon appik. ");
INSERT INTO lmd_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Akin othïat kin ngkaꞌrmacak engki, Onïn ul wothothïlettat woIeccuo ana ul ittïttïk ana opangkangon, Onïn thothïnthet ul iannoka woIouth ioccokothe lon loIeccuo nokaꞌran kAnththakkia ana noththok poCcuria ana poKilikkia: Thomicco. ");
INSERT INTO lmd_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Onïn thoccïkathe itti ul wꞌrek weot nnanïn cene ana wuethe non kaik ilon ilakin therenet kin llon ilaprttakiet kin tit ana oikkwaro kin ma. ");
INSERT INTO lmd_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ittina onïn appik thïꞌrïkot lon itti onïn thummo ul wꞌrek anïn othïnthet non okin opangkingon oPoluc ana oParanapa, ");
INSERT INTO lmd_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ul wen iorekot thiak cannan nti ikꞌran koIli oIeccuo oMiccie. ");
INSERT INTO lmd_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ittina ilen akka onïn thaik thathïnthet oIoutha ana oCcila akin othiꞌret non lon nthon then itti lon ilanïn thokurrinet non laik ïcat. ");
INSERT INTO lmd_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Laka loporot noKanang ikupupure ana naron itti kakorronno okorronno itti lon lainenon lïmïn nnolon ilaron thonu itti oron nthakkot ilaik itti, ");
INSERT INTO lmd_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","nocoꞌro nti ithoꞌrko kapa kaꞌrupu ionguttanet ꞌran, nokorronno ïkko ngüccük, nokorronno oꞌrko kapa kaꞌrupu iannokeccetta ikalak, nokorronno aꞌro nul nuthuk. Nokwantot kathar ikanon opaꞌrine aꞌrupu iongantettat cik appik. Thararot. ");
INSERT INTO lmd_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Aul iothïlathe oingkat nokaꞌran kAnththakkia akin akkarat ul tothun appik ioccokothe lon loIeccuo akin ummat kaꞌrmacak ikonu lon tit ilakin thothïlathe ngngin. ");
INSERT INTO lmd_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Aul akkakkarat lon len aul opirakat noka nolon len ilokat alomereket kin. ");
INSERT INTO lmd_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","AIoutha okin oCcila ithaththokat ul wothernte lon loKapik erekat lon loppot akin omereket ul ngngin ana opoꞌriekin than. ");
INSERT INTO lmd_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Anakka okin thikkot papotteik, aul iakin thaik thoccokothe lon loIeccuo othïat kin ikathar lon loporot akin opakkinthet okwion ithokat thothïothekin. ");
INSERT INTO lmd_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","35","Anaruk oPoluc ana oParnapa thoꞌrungkatheik nokaꞌran kAnththakkia, nakin ana opilingon thoppot thikkatheik akin ongkenet ana ere lon loIli. ");
INSERT INTO lmd_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ana papotteik aPoluc iꞌrekat oParnapa itti, “Aꞌrik ireo noul naꞌran appik iarit thaththongkenet lon loIeccuo irothokatha itti okin tharaththa.” ");
INSERT INTO lmd_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Ana OParnapa pangkathe itti kwipo oIuanna ipoccot kꞌran cakuruk itti oMarkkoc akin eo okin aththungon. ");
INSERT INTO lmd_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Anaruk oPoluc pokathakathe ere loporot itti okin thakannipok akka kwappoththet nakin noththok poMippilia ana kwappannoreko ana kwannittarot kin ire. ");
INSERT INTO lmd_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Akin aꞌrettat akin oParnapa cannan mono akin illakat tit aParnapa onekat oMarkkoc akin oingkat okko irok eo noththok poKupruc. ");
INSERT INTO lmd_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Anaruk oPoluc ponekathe oCcila akin oingkat aul ioccokothe lon loIeccuo ipittat Kapik itti kaka naak aiꞌrekathok itti, “Athoporot thoKapik oka naung.” ");
INSERT INTO lmd_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ana kwoingkathe okko noththok poCcuria ana poKilikkia na kwikkot cik akwopoꞌrie mungkut than moul ioccokothe lon loIeccuo kurekkurek. ");
INSERT INTO lmd_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","OPoluc ana oCcila thoingkathe nokaꞌran koTherpa ana nokaꞌran koLicththra na oThimiththaoc pul ipammakot oIeccuo pokat ngkaman. Onnan pokat poul woIouth ipoccokothe lon loIeccuo anaruk oththan pokat poul iannoka woIouth. ");
INSERT INTO lmd_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Ul ioccokothe lon loIeccuo wonokaꞌran koLicththra ana koIkkonia werethok llon loporot. ");
INSERT INTO lmd_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","OPoluc pappongothe itti kwipok akin othonyaro akin aththeꞌra ana ilen akka kwokekkiekanthok akka ul woIouth iokat cik nomoꞌrong cïnang thinat oThimiththaoc papenang itti kwokat pannokekkot akka oththan pappannoka poul woIouth. ");
INSERT INTO lmd_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Anakka okin thokat cik akin okkette nomoꞌrong, okin thokat akin erene ul ioccokothe lon loIeccuo. Okin thokat akin erenekin lon ila ul wothothïlettat woIeccuo ana ul ittïttïk ilakin thïꞌrïkothe tothun nokaꞌran koUruccelim itti okin thonu itti okin thaꞌrumo nan. ");
INSERT INTO lmd_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ittina ul ioccokothe lon loIeccuo wopoꞌriettakathe than ithoccokot lon nomïkït aikkat cik arttakot nan appinappin. ");
INSERT INTO lmd_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","OPoluc akin opurukon thoingkathe okko nocik coPricia ana coKalaththia akka Kanang ikupupure kokat kiꞌrethekin itti okin thakorronno eo naꞌran wonoththok pAccia. ");
INSERT INTO lmd_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Anakka okin thaat nokwen konoththok poMiccia okin thennekkekathe itti okin thiꞌriko noththok poPithinia anaruk Kanang ikupupure koIeccuo koꞌramittathekin than itti okin thanniꞌriko. ");
INSERT INTO lmd_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Akin okkat noththok poMiccia akin oingkat uo nokaꞌran koThthruac. ");
INSERT INTO lmd_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ana ingkoꞌra aPoluc athantakat itti kwimmakat pul pꞌrek ponoththok poMakthonia apocoꞌro apipittothok nthiak itti, “Aꞌrik noththok poMakthonia athittarot nïn.” ");
INSERT INTO lmd_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Anakka oPoluc pimmat lon len anïn urokat kapik anïn oingkat noththok poMakthonia anïn iꞌrekat itti Kapik kakkarot nïn itti onïn thathongkenekin lon iloporot loIeccuo. ");
INSERT INTO lmd_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Onïn tharrathe kuppuꞌrung konoiꞌri nokaꞌran koThthruac anïn oingkat irok irapangka ïnnoingkat noththok poCcamoththrakkia ana ngorrot ngen ïnnoingkat nokaꞌran koNiappolic. ");
INSERT INTO lmd_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ana nceneket onïn thoingkathe nokaꞌran koPilippi kaꞌran ikokat inyaun nyoRoma ana onïn thikkatheik than maꞌri ammut. ");
INSERT INTO lmd_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ana nocaꞌri caCcepith onïn thoththekathe nokaꞌran koPilippi anïn eo nokwanthang korue nanïn thokat inome itti onïn thiot kaꞌran kaꞌrama. Onïn thikkathe cik nocapu ïnikkat cik ïnerene ul iari iaꞌrantakothe cïnang. ");
INSERT INTO lmd_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ana opilin nti iakin ithokat akin occïkot lon pokat pul ipopari ponat kꞌran itti oLithia ponokaꞌran koThiaththira pokat apokette eret iotholo ionat cekerek crïk ana kwokat akwaꞌrane Kapik ngaꞌrama aKapik anyanthok cïkït akwoccïkat lon loPoluc. ");
INSERT INTO lmd_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Anakka kwoccot mamuthie okin oul wung woruan appik kwakkarathenïn itti onïn thaeo tuan thanung ana kwiꞌrekathe itti, “Nanthan annathikkoik tuan thanin amma onon akkakatha itti oun pul ipoccokothe lon loIli.” Ana kwoꞌramittathenïn than ana onïn thoccïkathe lon lung. ");
INSERT INTO lmd_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ana caꞌri cꞌrek anïn thokat cik ïneo nokaꞌran kaꞌrama ïnnocurat ikkul iopari iarekine pul ionat uꞌrupa iokithak ana wakorronnok akwerene ul lon ilaik lathanthan. Ana wokat cik amonane ul wung akucci woppot nti ilon elli. ");
INSERT INTO lmd_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ukul wen iopari womakathe oPoluc ana onïn thꞌrek ana wikkatheik aere mpoꞌre cittan itti, “Ul enni iarekine Kapik ikrïk waik werenenon lon lokathar annoꞌrettat.” ");
INSERT INTO lmd_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ukul wen woꞌrungkwathe nolon len maꞌri moppot. Menik oPoluc puakathe ka kokkul iopari wen akwoprttakathok akwiꞌrekat uꞌrupa iokithak itti, “Mpiꞌrethung ngkꞌran koIeccuo oMiccie oppothe thapat nti iaak.” Nocaꞌri cen uꞌrupa iokithak oppat thapat nti ikkul ipopari accokkot. ");
INSERT INTO lmd_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Manakka ul ia ukul enni wokat arekine waththiot itti kathar iakin iot akucci ngngin kocoꞌrot, okin thoccokathe oPoluc ana oCcila ana okin thonekanthet kin nili keccuk. ");
INSERT INTO lmd_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Okin thonakathe oPoluc ana oCcila tokït konili inanceꞌret lon cik akin iꞌrekat nili itti, “Ul enni woIouth ana okin thaik thakkot lon lokithak nokaꞌran konnon. ");
INSERT INTO lmd_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Okin thaik thangkene ul thathuma ithonu itti thannokkattat nul woRoma ana oron thakannangkot ana okorronno oreko ngngin.” ");
INSERT INTO lmd_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Cungkut coul caꞌrntakathe acatta oPoluc ana oCcila ana nili nonokaꞌran iꞌrekat itti okin thue eret akin opoko. ");
INSERT INTO lmd_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Anakka okin thokkwettat cannan okin thorettakathe ikorrkkor, apul ipakatha lon loul ikorrkkor iꞌrettakat itti paꞌrumo nakin papenang. ");
INSERT INTO lmd_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Anakka pul ipakatha lon loul ikorrkkor poccïkothe lon lonili kworrekathe oPoluc okin oCcila cinoppan than ana orpenekin tacok ioꞌren othakka itti akin okorronno onyaro. ");
INSERT INTO lmd_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ana thampang thongkꞌra oPoluc ana oCcila thikkatheik akin aꞌrane Kapik ngaꞌrama ana ongwo kinye ana ul wꞌrek iokat ikorrkkor wokat akkwinekin kunu ncik accïkot kin. ");
INSERT INTO lmd_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Ana accokkot acapu ikkat cik acoꞌrïntïttako ncik acoꞌrïntïttat korrkkor ncik appik, athat worikorrkkor anyetakat cik appik, anyol inyïꞌrïkïkkakot nul apukkat nocapu appik. ");
INSERT INTO lmd_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Anakka pul ipakatha lon loul ikorrkkor purttat nti inthe akwothat kꞌrittang kung ikukwit akwomekat itti kwakkwot ka kung akka kwaththiot athat waꞌran worikorrkkor awaik ncürük appik. Kwokat akwome itti ul worikorrkkor wopellet nti ikorrkkor appik. ");
INSERT INTO lmd_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Anaruk oPoluc piꞌrekathok mpoꞌre cittan itti, “Kirrnni io ka kongo akka onïn thaik cene appik.” ");
INSERT INTO lmd_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Apul ipakatha lon loul ikorrkkor ipittat thik othakka itti akwimma cik ngngin akwollat ngngin noppan ikorrkkor akwocukkwat cik tokït koPoluc okin oCcila akwikkat cik akwokkwe ka. ");
INSERT INTO lmd_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Menik akwonakat kin thapat akwiꞌrekat kin itti, “Pït pin, ngintha akka anokkot anoꞌrettat?” ");
INSERT INTO lmd_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","APoluc ana oCcila iꞌrekathok itti, “Occokothe lon loIli oIeccuo nocïkït ana ngkwaꞌrettat ana ul woruan thanang appik.” ");
INSERT INTO lmd_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ittina okin therekanthok lon loIli ana ul iaik thanung appik. ");
INSERT INTO lmd_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Caꞌri cen ngkoꞌra apul ipakatha lon loul ikorrkkor ponekathekin akwimekanthet kin ïnyï. Nci cïnang pul ipakatha ul ikorrkkor ana ul woruan thanung thoccathe mamuthie. ");
INSERT INTO lmd_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Pul ipakatha lon loul ikorrkkor ponekathekin tuan thanung akwonakanthet kin thuꞌrit, ana kwokat popirat noka akka ook ana ul woruan thanung appik thoccokothe lon loKapik. ");
INSERT INTO lmd_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Anakka cïngkï cuat anili inanceꞌret lon cik othïanthet nili inarran llon itti ili iakatha lon loul ikorrkkor welïkko oPoluc ana oCcila. ");
INSERT INTO lmd_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Apul ipakathe lon loul ikorrkkor iꞌrekat oPoluc ana oCcila itti, “Nili inanceꞌret lon cik wiꞌret itti mpelïkko non ana nthaeo lon loporot.” ");
INSERT INTO lmd_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Anaruk oPoluc piꞌrekathe itti, “Okin thokkwethenïn tokït koul ana manna onïn thoul woRoma ana orret nïn ikorrkkor ana inenni okin thongothe itti okin thelïkko nïn nthuꞌrani? Kirrnni akin anthan ngka ken akin athelïkko nïn.” ");
INSERT INTO lmd_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Anili inarran othïanthet nili inanceꞌret lon cik lon lopul porikorrkkor, anakka okin thoccïkothe lon itti oPoluc ana oCcila thokat ul woRoma okin thipathe nꞌre. ");
INSERT INTO lmd_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Nili nakkakanthet kin nerekanthet kin thiak then nti ikarak itti nthaccïkot kin ana okin thipathekin nti ikorrkkor akin iꞌrekat kin itti okin thapaꞌro cik nokaꞌran koPilippi. ");
INSERT INTO lmd_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Anakka oPoluc ana oCcila thelïkkakot nti ikorrkkor okin thoingkathe tuan thoLithia nakin thincettothe okin oul ioccokothe lon loIeccuo ana okin thopoꞌriekathekin than akin oingkat. ");
INSERT INTO lmd_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Anakka okin thokkot nokaꞌran kAmppipolic ana nokaꞌran kApolinia akin akkakat nokaꞌran koThocculunukkia na ul woIouth wonat cuththun caꞌrama. ");
INSERT INTO lmd_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","OPoluc piꞌrikathe nocuththun caꞌrama ammakka akwokkettet ana kwerekathe okin aththungon aCcepith wꞌrapuruk akwongkene lon nti inatham nolon loKapik. ");
INSERT INTO lmd_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Akwongkene ana iꞌret kin itti oMiccie papponu itti kwaccokot thiak ana uroko nti ithio. Akwiꞌrekat kin itti, “OIeccuo ipa mpaik perenenon lon len ook oMiccie.” ");
INSERT INTO lmd_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ul wꞌrek woIouth wangkathe lon loPoluc ana oCcila mono amakat lon len ana ul woppot iannoka ul woIouth iaꞌrane Kapik ngaꞌrama woccokothe lon loKapik ana ul iari wꞌrek ittïttïk ionu lon ikkun cakuruk. ");
INSERT INTO lmd_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Anaruk ul wꞌrek woIouth wonyirakathe ana waꞌrntathe ul wꞌrek iokithak worikathar nuthuk akin okkat cungkut akin erekanthet kin akin ikkat cik akin okkot camutta, okin thollathe tokaman koIaccun akin okwantot oPoluc okin oCcila itti akin onane cungkut coul. ");
INSERT INTO lmd_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Anaruk akka okin thanniot oPoluc okin oCcila okin thothathe oIaccun ana ul ioccokothe lon loIeccuo akin thonekanthet kin nili nokaꞌran koThocculunukkia akin aꞌretto akin ome itti, “Nokatha ul enni wipothe thukungkun cik nocapu ncik appik ana okin thei thaat cene inenni ");
INSERT INTO lmd_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ana oIaccun pikkiet kin cik tuan thanung. Okin appik thꞌrat lon loili oKkaiccer akin ome itti ili wꞌrek waik woccot kꞌran itti oIeccuo.” ");
INSERT INTO lmd_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Anakka okin thoccïkothe lon len, ul appik ana ul ittïttïk wonokaꞌran koThocculunukkia wuakathe ka. ");
INSERT INTO lmd_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Anaruk nili nelikkathe oIaccun ana ul ioccokothe lon loIeccuo akka okin thethet kin akucci iakin thakkmakot ngngin. ");
INSERT INTO lmd_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Caꞌri cen ngkoꞌra aul ioccokothe lon loIeccuo othïat oPoluc akin oCcila nokaꞌran koPiria. Anakka okin okko tentre okin thoingkathe nocuththun caꞌrama coIouth. ");
INSERT INTO lmd_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Ana ul nokaꞌran koPiria wokat wongothe cannan itti waccïkot lon noul woThocculunukkia okin thokkwinet lon loKapik kunu ncik papenang ana okin thikkatheik akin okwancot iatham woKapik appinappin akin opekie llon loPoluc akin okatha amma lon ila oPoluc peret laik ïcat. ");
INSERT INTO lmd_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Menik aul woppot woIouth occokat lon loKapik ana cakuruk ul iari iannoka woIouth ana iokat waꞌrthan ana iokat apellene Kapik ana ul woppot iomura iannoka woIouth. ");
INSERT INTO lmd_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Anakka ul woIouth iokat cik nokaꞌran koThocculunukkia woccïkothe itti oPoluc paik pangkene lon loIeccuo nokaꞌran koPiria okin thomakathok tentre cakuruk, akin ikkat cik akin orumet ul naak. ");
INSERT INTO lmd_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ul ioccokothe lon loKapik wothïathe oPoluc caꞌri cen nokuthut korok irapangka anaruk oThimiththaoc okin oCcila okwentakat nokaꞌran koPiria. ");
INSERT INTO lmd_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Ittina ul iaththarot oPoluc wonakathok nokaꞌran kAthina ana wopakkanthet oThimiththaoc ana oCcila lon naPoluc itti akin occothok cik accokkot. ");
INSERT INTO lmd_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Anakka oPoluc pokat cik akwoꞌrïkot oThimiththaoc okin oCcila nokaꞌran kAthina kuakathe ka cannan nonikkilan ina kwimmat noppatheik nokaꞌran kAthina appik. ");
INSERT INTO lmd_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ittina kwerekanthet kin nocuththun caꞌrama ana ul iannoka woIouth iaꞌrane Kapik ngaꞌrama ana erene ul keccuk appinappin ana erene ul appik iaik than. ");
INSERT INTO lmd_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Okin thopllarathe llon ncungkut coul inaik nti ica wApikkurin ana woRoakkin ana opilingon thipittathe itti, “Pempi paik papo thon taththa?” Pilingon iꞌre itti, “Kwaik peret Kapik ikaik prek.” Okin thiꞌret elli akka oPoluc pokat akweret lon iloporot loIeccuo thuro nti ithio. ");
INSERT INTO lmd_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ittina okin thipathok akin onakathok nocuththun cAeroppakoc nakin thipittathok itti “Onïn thongothe itti onïn thina thongkene thang enthi ithie ithangkwaik pangkene. ");
INSERT INTO lmd_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ngkwaik pananenïn lon ilie nocik cïn ilanïn thannoccïkot caꞌri cꞌrek ana onïn thongothe itti onïn thina lon len.” ");
INSERT INTO lmd_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Ul wonokaꞌran kAthina ana ul wokwat iokat cik nokaꞌran kAthina wokat akorronno okkot ngre ngꞌrek, anaruk wokat aikkoik cinang aeret lon ilie ana occïkot. ");
INSERT INTO lmd_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Menik aPoluc urokat kapik nocuththun cAeroppakoc akwiꞌrekat itti, “Ul wonokaꞌran kAthina mpimmat naꞌran won appik itti onon thaꞌrane kapik ikaik prek ngaꞌrama. ");
INSERT INTO lmd_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Akka mponyarot icarak coman mpokathaccekathe aꞌrupu ianon aꞌrane angaꞌrama, ana mpiathe tuꞌrot taꞌrama tokurrakot nan itti, LAINE KAPIK IKOMMAKO. Kapik ikommako ikanon thaik thaꞌrane ngaꞌrama anon thomma iken akka mpaik patherenthet non lon len. ");
INSERT INTO lmd_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Kapik ikokkothe capu ncik appik ana aꞌrupu iaik tit appik, iken Ili worothiꞌrot ana wonocapu ncik appik ana kannikkoik nonupan noKapik inuntat nyaul ionyi. ");
INSERT INTO lmd_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ana kannorekakine nyaun nyoul ionyi akka kwannangkot papꞌrek. Kwethet ul thikkoik thung ana utha ana aꞌrupu wꞌrek appik. ");
INSERT INTO lmd_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Kapik kokkothe ul appik iaik nocapu nopul pulukku othakka itti akin ikkoik nocapu ana kwokkanthet kin maꞌri ana cïngkï ana onekkenthet kin aꞌran nakin thonu itti okin thikkoik.” ");
INSERT INTO lmd_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","OPoluc pikkathe cik akwere akwiꞌre itti, “Kapik kokkothe lon elli appik othakka itti apul iponyi okwantothok akiothok, kwannoka ciththan naron. ");
INSERT INTO lmd_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Akka oron thaik iaak nthonyaro thonnon ana thikkoik thonnon. Ana ammakka opilingon nti ianon ithathettot lon cik thiꞌret itti, ‘Oron thanyukul nyung.’ ");
INSERT INTO lmd_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Ana inakka oron thanyukul nyoKapik oron thonu itti oron thannokwarttikot itti Kapik kungkot thaap ana manna mallong ana manna mothok ana manna purrut ipokkattathe mpuꞌran popul iponyi ana nthinaik thopul iponyi. ");
INSERT INTO lmd_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Maꞌrot Kapik kellat kït kolon ilokithak loul anaruk inenni komethe ul appik naꞌran appik lon lonthoththomat itti wapaꞌrine lon cik lon ilokithak. ");
INSERT INTO lmd_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Akka kwonekkethe caꞌri cik ica akwathakkma capu ncik appik okorronno okwïet pul mpul ipa kwonekketheik ana kwokenet ul appik itti pul pen okkwen nthurokwiek nti ithio.” ");
INSERT INTO lmd_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Anakka okin thoccïkothe lon lothuroko nti ithio apilingon orakkekat lon len anaruk opilingon thiꞌrekathe itti, “Onïn thongothe itti onïn thappoccïkot lon lang noꞌron elli attang.” ");
INSERT INTO lmd_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ncinang aPoluc oththekat nocuththun. ");
INSERT INTO lmd_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Ana ul wotteik wothakkakathe ul iammakot kin akin occokat lon nomïkït loIeccuo. Ana nti iul wen oThiniccioc pul ipokat nti icungkut coul wAeroppakoc ana ipopari ipoccot kꞌran itti oThamaric ana opilingon thꞌrek. ");
INSERT INTO lmd_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ittina aPoluc oththekat nokaꞌran kAthina akwoingkat nokaꞌran koKurunthuc. ");
INSERT INTO lmd_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Kwaththiat pul pꞌrek than poccot kꞌran itti Akkila ponoul woPiniththic okkwi ipokat purnanthan noththok poIththalia okin opari iponat kꞌran itti oPricikkila akka ili oKklauthioc oKkaiccer pokat papponekkethe lon cik itti ul woIouth wapaꞌroik noththok poRoma appik. OPoluc poingkanthet kin akwothokatha kin, ");
INSERT INTO lmd_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ana akka oPoluc pokat pina okkot müꞌrük moeret akkwarthuk ina oKkila ammakka okin thokkothe, kwikkatheik okin aththungon tuan thanen ana okin thikkatheik akin okkettet müꞌrük moret. ");
INSERT INTO lmd_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","OPoluc pikatheik akwerentene ul nocuththun caꞌrama nomaꞌri maCcepith, kwokat cik akwokwancot kathar ika akwokorronno ul woIouth ana iannoka woIouth angat lon loIeccuo. ");
INSERT INTO lmd_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Anakka oCcila ana oThimiththaoc thaat noththok poMakthonia, aPoluc pokat akwongkene ul woIouth nomaꞌri mung appik ana erene kin kicce itti oIeccuo ook oMiccie. ");
INSERT INTO lmd_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Anaruk akka ul woIouth wꞌrat lon loPoluc ana ocungkok kwokkwathe tuꞌrupang nnoracok tung akwiꞌrekat kin itti, “Lon ilainenon laka nokalak kon pꞌrin mpella lon ncalak cin pꞌrin ilokithak. Nciki inenni mpaine ul iannoka wIouth.” ");
INSERT INTO lmd_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Ittina aPoluc oththekat nocuththun caꞌrama akwoingkat napuththut cinang tuan koThiththoc oIucththoc ipokat pannoka ponoul woIouth ipokat akwaꞌrane Kapik ngaꞌrama ");
INSERT INTO lmd_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Aili wonocuththun caꞌrama ionat kꞌran itti oKkricppoc occokat lon loIli ook ana ul woruan thanung appik ana ul woppot wonokaꞌran koKurunthuc ioccïkothe lon loPoluc woccokathe lon loKapik ana woccathe mamuthie. ");
INSERT INTO lmd_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Ngkoꞌra ngꞌrek aIli akkakanthet oPoluc ithathantako akiꞌrekathok itti, “Kirrnni ipo nꞌre, ere kirrnni angkoik. ");
INSERT INTO lmd_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Akka mpaik naung ana pul pella paccokothung itti pieng ka kongo akka mponu ul woppot waik nokaꞌran koKurunthuc.” ");
INSERT INTO lmd_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Ittina aPoluc pikkatheik than thuput ana anok wꞌrakuruk akwongkenekin lon loKapik. ");
INSERT INTO lmd_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Anakka oKkalion pothakkat ili noththok poKrik, ul woIouth waꞌrntakathe ntaPoluc akin onekathok nokaꞌran kothonceꞌret lon cik. ");
INSERT INTO lmd_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Akin iꞌrekat itti, “Pul empi paik perene ul itti waꞌrane Kapik ngaꞌrama ngkathar ikannomakot lon lothonceꞌret lon cik.” ");
INSERT INTO lmd_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Anakka oPoluc okuccekot cik itti kwiꞌre lon, aili oKkalion iꞌrekat ul woIouth itti, “Amma onon akkonu loꞌrek ilokkattathe lokithak laakat loporot itti mpaccïkïnthet non annerenin. ");
INSERT INTO lmd_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Anaruk inakka lon lothopllarot noꞌran ana nolon lothonceꞌret lon cik lon, noꞌro lon len ngka kon, mpannakkma lon ammakka elli.” ");
INSERT INTO lmd_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ana kwokïccekathekin nti iman mothonceꞌret lon cik. ");
INSERT INTO lmd_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Menik okin oprttakat ia ili wonocuththun caꞌrama oCocaththanic akin okkwekathok tokït koman kothonceꞌret lon cik. Anaruk oKkalion pellat kït ken. ");
INSERT INTO lmd_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","OPoluc pikkatheik papotteik nokaꞌran koKurunthuc. Ncïnang akwoththekat napangon ilon loKapik akwoingkat noththok poCcuria arrot tok irapangka akin oPricikkila ana oKkila. Ana akka kwarthuk eo, akwokekat ca nokaꞌran koKangkkaria thokeko thokat thothonekket lon cik ila kwokat ponekketheik. ");
INSERT INTO lmd_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Okin thakkakathe nokaꞌran kApuccuc na aPoluc poththet noPricikkila ana Akkila. Akweo nocuththun caꞌrama akwotherene ul woIouth. ");
INSERT INTO lmd_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Anakka okin thipittothok itti kwikkoik papotteik akin aththut akwꞌrakat. ");
INSERT INTO lmd_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Anaruk akka kweot, akwonekkekanthet kin lon cik itti, “Mpakkaprttako ntan amma Kapik akkongothe.” Akwoththekat nokaꞌran kApuccuc akweo nokaꞌran koKaiccaria ikuppuꞌrung konoiꞌri. ");
INSERT INTO lmd_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Anakka kworpotheik nokaꞌran koKaiccaria, kwokuꞌrathe akwothomicco ul ioccokothe lon loIeccuo nokaꞌran koUruccelim akwantuo nokaꞌran kAnththakkia. ");
INSERT INTO lmd_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Anakka kwikkot cik nokaꞌran kAnththakkia papotteik, kurokathe okkette naꞌran woKalaththia ana woPricia akwerene ul iammakothok lon ilothopoꞌriekin than appik. ");
INSERT INTO lmd_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Ana caꞌri cen pul pꞌrek poIouth ponat kꞌran itti Apolloc ponokaꞌran koIcikkantharia ipaat nokaꞌran kApuccuc, kwokat pina ere lon papenang ana ina lon latham woKapik. ");
INSERT INTO lmd_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Kwokat pongkenettat kathar koIli, ana kwongkenet opilingon ana ere ngkathar koporot koKanang ikupupure lon loKapik antoka manna itti kwinat mamuthie moIuanna tulluk. ");
INSERT INTO lmd_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ana kwikkatheik akwere akkwella nꞌre nocuththun caꞌrama. Anakka oPricikkila ana oKkila thoccïkothe akwere, okin thakkarathok tuan thanen ana okin therekanthok kathar kolon loKapik papenang. ");
INSERT INTO lmd_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Anakka Apolloc pokat pongothe itti kwaeo noththok poKrik aul ioccokothe lon loIeccuo nokaꞌran kApuccuc okurranthet ul ioccokothe lon loIeccuo noththok poKrik kaꞌrmacak akin othïat Apolloc ngngin akin ikkiek cik papenang. Anakka kweot tentre lalokat loporot cannan akka kwittarothe ul ioccokothe lon loIeccuo nthoporot thoKapik. ");
INSERT INTO lmd_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Akka kwokat palkothe ul woIouth nthopllarot akwokenekat kin tokït koul appik llon nti iatham ipupure itti oIeccuo ook oMiccie. ");
INSERT INTO lmd_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Anakka Apolloc pokat nokaꞌran koKurunthuc, aPoluc okkat ikathar ikokkot noththok pAccia akwakkakat nokaꞌran kApuccuc. Kwaththiat ul ioccokothe lon loIeccuo wꞌrek ");
INSERT INTO lmd_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ana kwipittathekin itti, “Onon thoccot Kanang ikupupure akka onon thoccokothe lon loIeccuoi?” Akin othïat tit itti “Aa, onïn thannoccïkot manna itti Kanang kaik ikupupure.” ");
INSERT INTO lmd_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Menik aPoluc appipittat itti, “Ana mamuthie mia imanon thoccot?” Akin othïat tit itti, “Onïn thoccot mamuthie moIuanna.” ");
INSERT INTO lmd_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","APoluc iꞌrekat kin itti, “Mamuthie moIuanna mokat mothopaꞌrine lon cik ilokithak. Kwiꞌrekathe ul itti okin thaccokot nomïkït lokkwi ipaik pammakittothok ook oIeccuo.” ");
INSERT INTO lmd_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Anakka okin thoccïkothe lon elli akin appik occat mamuthie ngkꞌran koIli oIeccuo. ");
INSERT INTO lmd_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Manakka oPoluc ponekkethe nyaun nakin aKanang ikupupure oꞌrat nakin ana okin thikkatheik ere karru ikakin thaththoma ere ana okin thikkathe cik akin ere lon loKapik. ");
INSERT INTO lmd_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ana ul wokat cik attul ana ikken keꞌra iomura. ");
INSERT INTO lmd_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","OPoluc piꞌrikathe nocuththun caꞌrama ana kwerekathe than anok wꞌrapuruk ella nꞌre, kwokat cik akwongkene lon longili ngoKapik akin opllarot othakka itti akin occokot lon loIeccuo nomïkït. ");
INSERT INTO lmd_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Anaruk opilingon thꞌrakathe lon lung ana okin thorrekathe lon loKapik ana eret kathar koIeccuo llon ilokithak. Ittina oPoluc poththekathe nakin. Kwonekathe ul iammakot lon loIeccuo ana kwikkatheik akwongkenet kin noppan tothongkene toccot kꞌran itti Thiranoc. ");
INSERT INTO lmd_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Thongkene enthi thoꞌrungkatheik luput leꞌra, othakka itti aul woIouth appik ana ul iannoka woIouth iaik ceneket noththok pAccia occïkot lon loIli. ");
INSERT INTO lmd_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Kapik kethet oPoluc puꞌran akwokkat lon ilommaththik laik pellek anganna. ");
INSERT INTO lmd_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Menik aul onnekat eret ia oPoluc pocciccokothe annekket noul iongo aittiet kin ngngin ana uꞌrupa iokithak woththeththekathe noul. ");
INSERT INTO lmd_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ul wꞌrek woIouth iokat anyalle nomoꞌrong akïcce uꞌrupa iokithak noul, wokat angantet kꞌran koili oIeccuo noul ia uꞌrupa iokithak woꞌrot nan. Okin thokat cik akin iꞌre itti, “Ngkꞌran koIeccuo ipa oPoluc paik pangkene lon len, mpiꞌret non itti nthappot thapat.” ");
INSERT INTO lmd_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Nyukul nyeꞌreꞌrapuruk nyoLickkao ipokat pul iprïk poul wonoppan toKapik nyokat anyokkettet lon len. ");
INSERT INTO lmd_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ana caꞌri cꞌrek auꞌrupa iokithak iꞌrekat kin itti, “Onïn thina oIeccuo ana onïn thina oPoluc anaruk onon okkwen ngon.” ");
INSERT INTO lmd_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ittina apul iponat uꞌrupa iokithak noka irrat takin mono okkwekat kin mono alkat kin akin opellekat nnoppan munthut ana nïnyï ana aüccük ollo noka. ");
INSERT INTO lmd_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Anakka lon len linakot nan nnul woIouth ana ul iannoka woIouth iokat nokaꞌran kApuccuc, wipathe nꞌre appik ana okin thothiakanthet kꞌran koIli oIeccuo cik cannan. ");
INSERT INTO lmd_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ul wakkakathe woppot ioccokothe lon loIeccuo akin ikkat akin ere lon len ilokithak tokït koul ilakin okkettet. ");
INSERT INTO lmd_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Aul wolurukut aꞌrntat natham nen nothurukut akin okꞌrekat tokït koul appik akin othangantekat cekerek ica natham ekko inokꞌrot akin othiat itti cekkot akucci athar arrial weꞌra ana alkaire (50,000). ");
INSERT INTO lmd_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ngkathar engki, lon loIli lappaththakatheik ciththan ana alarttakot nan cannan. ");
INSERT INTO lmd_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Anakka lon lokatthathe appik aPoluc urokat akwaeo nokaꞌran koUruccelim okko noththok poMakthonia ana poKrik akwiꞌrekat itti, “Ina akka mpaik paeo tentre, mponu itti mpakatha ponokaꞌran koRoma cakuruk.” ");
INSERT INTO lmd_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Akwothïat ul wung weꞌra ittarothok, oThimiththaoc ana Aracththoc noththok poMakthonia akwikkoik apotteik noththok pAccia. ");
INSERT INTO lmd_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Ana nocaꞌri cen ul urokiekat camutta nti ilon lokathar koIli. ");
INSERT INTO lmd_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Ana pul pꞌrek pokat poccot kꞌran itti oThimiththrioc okkwi ipokat akwokkot urrut wottotteik wonoppan tokapik ikopari Arththamic nnomallong. Arththamic ana opilingon ithokat akin okkot lon elli thiathe akucci woppot. ");
INSERT INTO lmd_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Kwakkarathe ul wung appik iakin thaik ire ngulukku ana ul ionu ngre ngungkot ngen akwiꞌrekat itti, “Ul iomura, onon thinan itti oron thincet akucci woppot nnore engi. ");
INSERT INTO lmd_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ana onon thimmat ana occïkot tat akka oPoluc perenet ul woppot ana opaꞌriekin ma cik nokaꞌran cene kApuccuc ana manna noththok pAccia appik akkwiꞌre itti aꞌrupu ikokkattathe nynyaun wannoka Kapik ïcat ana oron thannaꞌrane ngaꞌrama. ");
INSERT INTO lmd_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Amma ul woꞌrungkothe nan occïkot lon lung, okin theret ngre ngïn llon lokithak. Ana cakuruk itti tupan irïttïk tokapik ikopari Arththamic tellako kït ken. Ana ul iaik waꞌrane Arththamic ngaꞌrama inenni naꞌran appik wAccia ana nocapu ncik appik warakke Arththamic itti kapik ikrïk.” ");
INSERT INTO lmd_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Anakka ul iakin oreko woccïkothe lon len, akin uakat ka cannan akin ikkat cik akin okkot poꞌre cittan akin iꞌre itti, “Arththamic ponokaꞌran kApuccuc prïk.” ");
INSERT INTO lmd_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ana papotteik akaꞌran urokiekat camutta. Aul ollat taKaioc ana Arcciththrikkoc, aul iokat ammakot oPoluc iokat nomothok poMakthonia aththuththeꞌra akin ollat oPoluc ngngin akin onakat kin nokaꞌran na ul aꞌrntattakot. ");
INSERT INTO lmd_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","APoluc omekat itti kwaeo nocungkut aul iammakot oIeccuo oꞌramittathok itti kwanneo. ");
INSERT INTO lmd_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Ana manna nili nꞌrek nonoththok opuruko pungon othïanthok thon akin oꞌramittathok cakuruk itti kwanneo nokaꞌran ken. ");
INSERT INTO lmd_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Cungkut coul caccocikkittakathe lon ima opilingon thokat akin okkot poꞌre akin ongante lon prek ana opilingon ongante alꞌrek. Ul woppot wommat itti okin thaththokkot ngimpen ceneket. ");
INSERT INTO lmd_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ul woIouth wothïathe Alekenther tokït koul itti akwere lon ilaik ana kwomekathekin itti okin thangkoik akwina akka akworrot nolon. ");
INSERT INTO lmd_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Anaruk akka okin thinarok itti kwoul woIouth okin thokkathe poꞌre tothun ittaꞌrene itti, “Arththamic ponokaꞌran kApuccuc prïk.” ");
INSERT INTO lmd_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Apul ipakurrine ili woricarak coman angkiekat ul cik akwiꞌrekat kin itti, “Ul wonokaꞌran kApuccuc, ul wonocapu ncik appik womma itti pothok pApuccuc akkaik pangwot tupan tokapik tArththamici? Ana kaꞌran akkaik kangwot purrut pung ipapot ntothiꞌrori? ");
INSERT INTO lmd_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Ana inakka lon elli ilaik ïcat lomma ocukkwako nan, onon thonu itti nthangkoik ana okorronno okkot camutta. ");
INSERT INTO lmd_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Onon thonat ul enni cene aureꞌra okin thannomunye alpꞌrek nnoppan tokapik konnon Arththamic ana manna ocungkwok. ");
INSERT INTO lmd_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Ittina amma oThimiththrioc ana ul iakin orekon ithakkot kaman komallong thorukwethe puꞌrek lon ilokithak kaꞌran kothonceꞌret lon cik kei akin ommakot kathar kothonceꞌret lon cik. ");
INSERT INTO lmd_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ana amma onon thonu lon lꞌrek loka lonu itti nili nakotto aneret lon len. ");
INSERT INTO lmd_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Oron thikko thakkmako nti icamutta icokkattathe inenni. Ittina oron thamma orrot nolon len akka oron thella lon cik ilakorronno aron okkot camutta.” ");
INSERT INTO lmd_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Ana kwiꞌrekathe ul itti waeo ana okin thoingkathe nonupan nen. ");
INSERT INTO lmd_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Anakka camutta coul comttathe aPoluc akkarat ul iammakot oIeccuo, anakka kwerenet kin kicce lon lothopoꞌriekin than. Kwomekat kin itti, “Mpei paeo,” akwurokat akweo noththok poMakthonia. ");
INSERT INTO lmd_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Kwokkathe nocik cen akwerene ul ioccokothe lon lo oIeccuo akwopoꞌriekin than puccuk akwakkakat noththok poKrik ");
INSERT INTO lmd_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","na kwikkot cik anok wꞌrapuruk. Anakka kwokat akwokuccekot cik itti kwaeo noththok poCcuria kwoccïkathe itti ul woIouth wokat wonekkethe lon cik itti wakkwothok, ittina kwoprttathe lon cik ana kwopakkathe noththok poMakthonia. ");
INSERT INTO lmd_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Ul iokat cik aittarothok wokat oCcupaththroc ukul woParc ponoul woPiria, ana Arcciththrikkoc ana oCcokkonttoc ponoul woThocculunukkia, ana oKaioc ponoul woTherpa, ana oThimiththaoc, ana oThikikkoc ana oThthroppimoc noththok pAccia. ");
INSERT INTO lmd_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Aul enni oingkat tokït kïn nokaꞌran koThthruac akin othoꞌrïkat nïn than. ");
INSERT INTO lmd_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Anaruk akka onïn thocothothe kamuthe karrakith iella müꞌrükül tit, onïn tharrathe ikuppuꞌrung konoiꞌri anïn oingkathe nokaꞌran koPilippi noththok poMakthonia, ana nomaꞌri ukuluk ïnoccat kin cik nokaꞌran koThthruac na nïn thikkot cik maꞌri meꞌreꞌrapuruk. ");
INSERT INTO lmd_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Nocaꞌri cocittokït conomaꞌri imeꞌreꞌrapuruk onïn thaat tothun anïn athoꞌrko thuꞌrit thothokwarttikot oIeccuo. OPoluc perekanthet ul anaruk kwokat cik akwaeo ngorrot ngen, kwikkatheik akwere puccuk mono athampang thongkꞌra akkakat. ");
INSERT INTO lmd_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Muꞌru imaccie thik mokat moppot iman imokat toꞌra woman nanïn thokat cik anïn eret. ");
INSERT INTO lmd_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Ukul wꞌrek iokuꞌrit ionat kꞌran itti Apiththikkoc wokat cik aikkoik icürük coriplak poman ana wikkatheik aththukwot akka oPoluc pokat cik akwere puccuk. Anakka kweot inthe cannan akwapat nci toꞌra woman imokat toꞌra wokaman keꞌra mono akwiat. ");
INSERT INTO lmd_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","APoluc uat ntoꞌra akwonekat ukul wen nokapen akwiꞌrekat itti, “Nokorronno opelle kwannio.” ");
INSERT INTO lmd_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Ittina aPoluc opakkat tit toꞌra akwaꞌrakat ngaꞌrama nothuꞌrit thothokwarttikot oIeccuo akwoꞌrkkat. Akka kwoꞌrkot pꞌrïn, akwerekat puccuk mono acïngkï uakat akwoingkat. ");
INSERT INTO lmd_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Ul wonekathe ukul iokuꞌrit tuan akkwannio ana okin thokat thopirat noka cannan. ");
INSERT INTO lmd_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Onïn tharrathe ikuppuꞌrung koniꞌri anïn arrat anïn oingkat nokaꞌran kAccuc nanïn thokat thathipo oPoluc nthan. Kwokkothe lon elli akka kwokat akweo tentre ntacok. ");
INSERT INTO lmd_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Anakka kwaththiot nïn nokaꞌran kAccuc onïn thipathok ngkuppuꞌrung konoiꞌri ïnnoingkat nokaꞌran koMiththilini. ");
INSERT INTO lmd_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Ngorrot ngen onïn thurokathe ncïnang ïnnoingkat ana onïn thokkathe nocik coKkaioc. Ana ngorrot ngen onïn thakkakathe noththok poCcamoc ana ngorrot ngen onïn thakkakathe nokaꞌran koMiliththoc. ");
INSERT INTO lmd_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","OPoluc piꞌrekathe itti kwaeo okko nokaꞌran kApuccuc othakka itti akwokorronno occoik noththok pAccia akka kwokat akwattakoik akweo nokaꞌran koUruccelim nocaꞌri cokamuthe kothokio mïl moIouth. ");
INSERT INTO lmd_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Anakka oPoluc paat nokaꞌran koMiliththoc, kwothïanthet ul ittïttïk woul ioccokothe lon loIeccuo thon noppan toKapik nokaꞌran kApuccuc itti okin thainok nokaꞌran koMiliththoc. ");
INSERT INTO lmd_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Anakka okin thaat akwiꞌrekat kin itti, “Onon thina papenang tat akka mpikkot cik ithoꞌrkït thon maꞌri emmi appik unnaththut nci nocaꞌri cocittokït akka mpaat noththok pAccia. ");
INSERT INTO lmd_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Mporekinet Ili nci nocïkït ana ngngeme ikït ana antoka manna itti mpokat pennekkettat anganna nul woppot woIouth. ");
INSERT INTO lmd_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Ana onon thina itti mpannoceꞌre lon nanon iloporot anaruk mpongkenethenon ncinokkït ana ikaman kon. ");
INSERT INTO lmd_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Mpokenet ul woIouth ana ul iannoka woIouth itti okin thonu itti okin thaine Kapik nthocoꞌro nti ilon ilokithak akin occokot lon loIli wonnon oIeccuo. ");
INSERT INTO lmd_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Ana inenni mpomma lon ilaik lathainin nokaꞌran koUruccelim anaruk mponu itti mpaccïkot lon loKanang ikupupure. ");
INSERT INTO lmd_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ila mpina tulluk itti naꞌran ia mpokkettet tit appik Kanang ikupupure kokat akïꞌrïlen itti korrkkor ana thoccokiettat thiak thaik thacurot iaun. ");
INSERT INTO lmd_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Anaruk mpella kït kothikkoik thin anaruk amma mpamartto ngre ia Ili oIeccuo pethin, ngre itti mpere lon iloporot loIeccuo ana thoporot thoKapik. ");
INSERT INTO lmd_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Inenni mpina itti pul pella nti ianon itha ampongenet lon longili ngoKapik pappimman attang. ");
INSERT INTO lmd_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Ilen akka aniꞌrenthet non inenni itti mpella lon lopilin nocalak cin pꞌrïn. ");
INSERT INTO lmd_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Akka mpongkenet non lon loKapik kicce appik. ");
INSERT INTO lmd_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Noccot kït noꞌron loka kon ana noul ia Kanang ikupupure konekkenthet non cik itti onon thakatha lon len. Noka ul iuꞌre ul ioccokothe lon loIeccuo ia kwokerot ngüccük ngung. ");
INSERT INTO lmd_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Mpina itti amma mpeot ul wothongkene ngkarra wiꞌriko ianon ere mipa amma miꞌrikot ilicok apettat ul cik ioccokothe lon loIeccuo. ");
INSERT INTO lmd_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ana manna ul wꞌrek wuroko nti ianon aere ngkarra othakka itti akin opaꞌre ul iammakot oIeccuo ma cik ammakot kin. ");
INSERT INTO lmd_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Ittina noꞌrumoik nokwarttikot akka mpokat anerentenenon luput lꞌrapuruk nokkonokki ana nokkꞌrokkꞌra ngeme ikït.” ");
INSERT INTO lmd_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","APoluc oꞌrungkat nolon akwiꞌrekat itti, “Inenni mpethet non Kapik ikkun ana lon lothoporot thung ilapoꞌrienon than annoine ul iothikkiettat wupupure woKapik. ");
INSERT INTO lmd_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Mpannongat mallong imallio ana manna thaap ana manna eret wopilin. ");
INSERT INTO lmd_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Onon thina kicce itti mporekot nynyaun nyin othakka itti aniot akucci anokatha ngka kin anokathakat ul ianïn thaik. ");
INSERT INTO lmd_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Lon ila mpokkothe appik mpongkenet non itti ngre iommaththik ammakka engi oron thonu itti oron thittarot ul iella alpꞌrek, nokwarikot lon ila oIeccuo piꞌret nthon thung itti. ‘Thethïeko thaka thoppot nothethet ul aꞌrupu nothocco aꞌrupu.’” ");
INSERT INTO lmd_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Anakka oPoluc piꞌret lon elli kweekat ungku ncik akin aththut appik akin aꞌrakat ngaꞌrama. ");
INSERT INTO lmd_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Okin thoathe appik akka okin thokat akin thokat cik akin omiccok ïꞌrïkïkkarothok topere. ");
INSERT INTO lmd_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Lon iloiet kin cannan ila kwiꞌret itti okin thannappimmak pꞌrïn. Ittina okin thomakathok nokuppuꞌrung konoiꞌri. ");
INSERT INTO lmd_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Anakka onïn thillakot tit ïnoul wApuccuc ittïttïk onïn thoingkathe okko irok irapangka eo noththok poKkoc. Ana ngorrot ngen onïn thoingkathe noththok poRothoc ana nceneket anïn oingkat nokaꞌran koPaththara. ");
INSERT INTO lmd_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Onïn thaththiat kuppuꞌrung konoiꞌri ikokat cik akeo noththok poPiniccia okko irok irapangka. ");
INSERT INTO lmd_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Anakka onïn thimmat pothok poKupruc ïnthuathe nca opakkot nthokkun wothothari amma akatha na acïngkï ummot ngngin ana onïn thoingkathe noththok poCcuria okko irok irapangka. Onïn thocoꞌrathe nokaꞌran koCcur na kuppuꞌrung konoiꞌri korpethe aꞌrupu cik. ");
INSERT INTO lmd_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Onïn thoingkathe nokuthut korok irapangka anïn ikkat cik ïnnoul iammakot oIeccuo maꞌri meꞌreꞌrapuruk ana ngKanang koKapik ikupupure okin thikkathe cik akin oot oPoluc itti kwakannokuꞌrot Uruccelim. ");
INSERT INTO lmd_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Ana akka maꞌri mïn momttathe onïn thurokathe nokurtti kïn. Aul iammakot oIeccuo ana oparion ana opeion thaththarat nïn anïn eekat ungku ncik nokuthut korok ïnaꞌrakat ngaꞌrama. ");
INSERT INTO lmd_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Anakka onïn thillakot tit pꞌrïn, onïn tharrathe ikuppuꞌrung konoiꞌri ana okin thopakkathe icarak coman. ");
INSERT INTO lmd_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Onïn thoingkathe nokaꞌran koCcur ana onïn thocoꞌrathe nokaꞌran koPaththolimaic ïnorpat cik ïnomiccat ul ioccokothe lon loIeccuo anïn ikkat cik caꞌri culukku. ");
INSERT INTO lmd_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Ana ngorrot ngen ïnnoingkat ïnnakkakat nokaꞌran koKaiccaria ïnnikkat cik tuan toPilippic pul pothongkene lon loIeccuo nti iakkwion itheꞌreꞌrapuruk ithokat thummuntettat itti okin thikket ul thuꞌrit. ");
INSERT INTO lmd_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Kwonat nyukul nyocoꞌrin inyari inyannitta inyokat anyerente lon loKapik. ");
INSERT INTO lmd_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Anakka onïn thikkot cik maꞌri moppot apuꞌrek pothernte lon loKapik akkakat ponat kꞌran itti Akapoc puot ntan nnoththok poIouthia. ");
INSERT INTO lmd_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Apul pothernte lon loKapik akkakat nanïn aponekat kuꞌrat nti ikin koPoluc akwïꞌrïkïkkat ntacok tung ana nyaun ana kwiꞌrekathe itti, “Kanang ikupupure kiꞌret itti, ‘Ul woIouth woUruccelim wïꞌrïkïkko pul pokuꞌrat engki ana okin thethok ul iannoka woIouth ikkun.’ ” ");
INSERT INTO lmd_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Anakka onïn thoccïkothe lon len onïn ana ul tentre thoathe oPoluc cannan itti kwannokuꞌrot nokaꞌran koUruccelim. ");
INSERT INTO lmd_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Ittina aPoluc othïanthet kin tit itti, “Onon thontha akka annoo ana ipien thiak nocïkït mpokuccekothe cik annoka tulluk itti mpïꞌrïkïkkako anaruk itti mpiot nokaꞌran koUruccelim nolon loIeccuo.” ");
INSERT INTO lmd_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Anakka kwꞌrat occïkot lon lïn, lellakathe ilanïn okkot ana onïn thomekathe tulluk itti, “Alon ila Ili wongothe itti lakkattat alokkattat.” ");
INSERT INTO lmd_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Ana akka elli locothakothe, anïn okuccekat cik ïnnoingkat okuꞌrot Uruccelim. ");
INSERT INTO lmd_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Ul iammakothok wꞌrek nnokaꞌran koKaiccaria wittarathenïn ana wonakathenïn tuan toManaccon na thokat thathikkoik. Kwokat ponoththok poKupruc ana pul ipommakothe oIeccuo ncinomun. ");
INSERT INTO lmd_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Anakka onïn thaat Uruccelim, opangkingon ilon loIeccuo thikkiekathenïn cik papenang. ");
INSERT INTO lmd_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Ngorrot ngen oPoluc akin oplingon nti ianïn thoinkathe akin othokatha oIakup. Ana ul ittïttïk woul ioccokothe lon loIeccuo nokaꞌran koUruccelim wokat cik appik. ");
INSERT INTO lmd_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","OPoluc pomiccathekin akwerekanthet kin lon kicce appik ila Kapik kokkinthet ul iannoka woIouth ngngre ia kwokkothe. ");
INSERT INTO lmd_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Anakka okin thoccïkothe lon elli, akin opirakanthet Kapik noka nolon len. Akin iꞌrekat oPoluc itti, “Pangkin ngkwimmat tat akka ul woIouth woccokothe lon loIeccuo athar woppot ana okin cakuruk thomakathe lon lothonceꞌret lon cik loMucca. ");
INSERT INTO lmd_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Okin therettanet itti ngkwongkenet ul woIouth iaik nnul iannoka woIouth itti akin ocottako nti ilon ilocoꞌrothe cik loMucca aiꞌret kin itti okin thakorronno okekkiet nyukul nyen ana okorronno omakot lon lothathuma then. ");
INSERT INTO lmd_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Ngintha akka aron okkot? Okin thaccïkot aththaman itti ngkwaat, ");
INSERT INTO lmd_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","ittina nokko ilanïn iꞌrethung. Ul waik wocoꞌrin ionekkenthet lon cik. ");
INSERT INTO lmd_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Oneki ul enni annokattakot ilon lothonthukko akkenekin akucci akin okeko. Ittina ul wina itti lon lella ilaik ïcat ilon ilakin ul waik werethung ngngin anaruk onon cakuruk thaik thammakot lon lothonceꞌret lon cik loMucca. ");
INSERT INTO lmd_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Anaruk okkwion ithannoka ul woIouth ithoccokothe lon loIeccuo onïn thokurrinet kin itti okin thacoꞌro nti ithoꞌrko kapa kaꞌrupu ionguttanet ꞌran ana ngüccük ana kapa kaꞌrupu iannokeccetta ikalak ana thaꞌro nul nuthuk.” ");
INSERT INTO lmd_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Ngorrot ngen oPoluc ipat ul akwothothunthakat okin aththut. Ittina kwoingkathe noppan toKapik akwothokene maꞌri mokamuthe kothonthukko macothakot acin ana ul enni wethet aꞌrupu wothokiot ngüccük cik. ");
INSERT INTO lmd_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Anakka maꞌri imeꞌreꞌrapuruk mokat cik amomattat pꞌrïn, ul wꞌrek woIouth noththok pAccia wimmakathe oPoluc noppan toKapik. Okin therekekathe ul accokathok, ");
INSERT INTO lmd_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","akin iꞌre mpoꞌre cittan itti, “Ul woIccereil, nittarot nïn, pul empi pikkaik pangkene ul naꞌran appik lon ilokithak naron ana nolon lothonceꞌret lon cik loMucca ana nokaꞌran engki ana cakuruk kwonat ul iannoka woIouth noppan toKapik ana kwokïttathe kaꞌran engki ikokat kupupure.” ");
INSERT INTO lmd_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","(Okin thaththimmat oThthroppimoc ipokat ponoul wApuccuc icarak coman, akin iꞌrekat itti ikkre oPoluc ponarok noppan toKapik.) ");
INSERT INTO lmd_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Ana ul wurokathe ncik nokaꞌran appik ana wakkakathe ollo ntan akin aꞌrntakat na oPoluc akin occokathok akin othathok thapat nnoppan toKapik akin unukkat athat. ");
INSERT INTO lmd_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Anakka okin thokat akin okwantot kathar ikakin okkwothok ngngin, lon loingkanthet ili irïk woul irro woRoma itti ul woricarak coman coUruccelim appik waik icamutta. ");
INSERT INTO lmd_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Aili irïk woul irro ummat nili nꞌrek inarran noul irro ana ul wꞌrek irro akin ollat uo thocamutta. Anakka camutta coul cimmat ili irïk woul irro woRoma ana ul wung irro, akin ocoꞌrat okorronno okkwe oPoluc. ");
INSERT INTO lmd_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Ili irïk woul irro wakkakathe accokat oPoluc aiꞌrekat itti, “Nïꞌrïkïkkok nynyol nyeꞌra.” Menik akwipittat itti ook okkwen ana ngimpen akka kwokkothe. ");
INSERT INTO lmd_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Ul wocamutta wikkatheik aꞌrettakot kurekkurek, anakka ili irïk woul irro wanniot lon ilocoꞌrotheik akka camutta coul cokat cik, akwiꞌrekat itti oPoluc panekittat nokaꞌran koul irro. ");
INSERT INTO lmd_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Anakka oPoluc okko ci norupet okwokuꞌrot toꞌra, aul arttat nocamutta acothakkakat cïttïk aul irro onekathok tocalak ntokït kocamutta coul. ");
INSERT INTO lmd_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Aul iokat cik ammakothok ikkat cik aꞌretto puccuk ame itti, “Nokkwothok nokkwothok.” ");
INSERT INTO lmd_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Anakka ul irro wokat cik anekot oPoluc ikaman koul irro aPoluc ipittat ili irïk woul irro itti, “Mpiꞌret non lon lꞌreki?” Aili iꞌrekathok itti, “Ngkwere karru koul woKriki? ");
INSERT INTO lmd_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Annoka oung pul ponoul woMucciri ipokkothe camutta mono oingkat nul athar wocoꞌrin ithampang ithonthomari ionat kꞌran itti ul iangwo ul maꞌrot apotteiki?” ");
INSERT INTO lmd_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","APoluc othïanthok tit itti, “Oun pul ponoul woIouth ponokaꞌran koTharccic noththok poKilikkia pothok ipinakot papenang. Korronnon anerene ul.” ");
INSERT INTO lmd_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Akwokorronnathok aPoluc ocoꞌrat norupet akwonthanthet ul ukun kapik anakka ul wangkot cik akwerekanthet kin ngkarru koIpranin. ");
INSERT INTO lmd_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Pangkingon ana ongappan, nantokkwine lon lothrrot nocalak cin unu ncik.” ");
INSERT INTO lmd_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Anakka okin thoccïkothe akwerenekin ngkarru koIpranin ana okin thangkatheik icci. Ittina aPoluc iꞌrekat kin itti, ");
INSERT INTO lmd_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Oun pul ponoul woIouth ana mpokwontathe nonokaꞌran koTharccic noththok poKilikkia anaruk mpupokkothe cene noththok empi ana mpongkenettathe ikkun woKamalail mpongkenettat lon lothonceꞌret lon cik longappan thonnon papenang ana mpokat pongothe Kapik cannan ammakka onon cene inenni appik. ");
INSERT INTO lmd_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Mpoccokiethe ul thiak manna ongwo iammakot kathar koIeccuo ana occiccokot ul iomura ana iari anonekket ikorrkkor. ");
INSERT INTO lmd_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Ana manna cakuruk pul iprïk ponoppan toKapik ana nili nꞌrek nimmat lon ngkït ken. Ana manna mpoincenet kin anonekot kin lon anonekine opangkingon nokaꞌran koThimacakka ana mpeot tentre anothona ul ianekkettat ikorrkkor nokaꞌran koUruccelim akin othoccokiettat thiak.” ");
INSERT INTO lmd_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","APoluc ikkat cik akwere itti, “Ana icïngkï ippa akka anokko ciki iccik koThimacakka akꞌran kꞌrek occat naun ntothiꞌrot kipuk ippuk. ");
INSERT INTO lmd_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Mpapathe nocapu anoccïkat poꞌre apiꞌrethin itti, ‘Caul, Caul, ngkwontha akka accokiethin thiak?’ ");
INSERT INTO lmd_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Anipittat itti, ‘Ili, oung oththa?’ Apoꞌre pen iꞌrekat itti, ‘Oun oIeccuo poNaccir ipa ngkwaik paccokiet thiak.’ ");
INSERT INTO lmd_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Ul ianïn thokat cik wimmat kꞌran ken anaruk okin thannina itti pokkwen ipokat aperenenin. ");
INSERT INTO lmd_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Anipittat poꞌre pen itti, ‘Ngintha akka anokkot, Ili win?’ AIli iꞌrekathin itti, ‘Urokothe kapik aiꞌriko nokaꞌran koThimaccakka ana ngkwerettane lon appik ilonekkattanthung cik itti ngkwakkot.’ ");
INSERT INTO lmd_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Aul ianïn thokat cik ipathin nynyaun akin onekathin nokaꞌran koThimacakka ampiꞌrimathe akka kꞌran kakkiꞌrimathin. ");
INSERT INTO lmd_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Apul pꞌrek ipoccot kꞌran itti Anania akkakat apathokathakat naun, pul ipoporot iponat nꞌre noKapik ana ipoꞌrumot nolon lothonceꞌret lon cik ana pinakot papenang ana ul woIouth wothianok cik appik iaik noththok pen. ");
INSERT INTO lmd_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Kwocoꞌrathe iccik kin akwiꞌrekathin itti, ‘Pangkin oPoluc, immaik.’ Ittina animmakat cik caꞌri cen. ");
INSERT INTO lmd_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Apul pen iꞌrekat itti, ‘Kapik kongappa ponnon kakkarorung itti ngkwina lon lung ana imma oMiccie ipoporot tokït koKapik ana occïkot lon nti ithon thung. ");
INSERT INTO lmd_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Ngkwerene ul lon lung appik ila ngkwimmat ana occïkot. ");
INSERT INTO lmd_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ngintha akka ngkwaik pappoꞌrïkot? Urokothe kapik acco mamuthie apaꞌre lon lang cik ilokithak, aꞌrane Kapik ngaꞌrama.’” ");
INSERT INTO lmd_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","APoluc ikkat cik akwere itti, “Anakka mpopakkothe nokaꞌran koUruccelim ana mpokat anaꞌra ngaꞌrama noppan toKapik anathantakat ");
INSERT INTO lmd_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","itti mpimmat aIli erenin aiꞌrekathin itti, ‘Oththe nokaꞌran koUruccelim aththaman akka ul wannoccïkot lon lang ilerethin.’ ");
INSERT INTO lmd_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Anothïat tit itti, ‘Ili, ul enni winanan itti mponyallet nomuththun maꞌrama anipot ul ikorrkkor ana okkwekin ithoccokothe lon lang. ");
INSERT INTO lmd_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Mpokat cik akka ul wokkwothe oIciththippanuc ipiot nti ilon lang, mpokat cik aniꞌrilet kin lon ilakin okkot ana oun akkokat cik anangwot eret woul iokat akkwothok.’ ");
INSERT INTO lmd_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Ittina aIli iꞌrekathin itti, ‘Ngo, mpaik pathïothung ciththan noul iannoka woIouth.’” ");
INSERT INTO lmd_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Ul wocamutta wokkwanthet oPoluc kunu ncik kicce puccuk mono akwiꞌrekat lon elli menik akin urokiekat poꞌre attang akin okkat poꞌre itti, “Nopaꞌrek cik nocapu kwannekko nan itti kwakkoik.” ");
INSERT INTO lmd_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Anakka okin thokat cik akin okkot poꞌre ana orre eret wen ana orret tuꞌrupang ithiꞌrot thokapik. ");
INSERT INTO lmd_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Aili irïk woul irro omekat itti oPoluc panekittattent ul irro akwipittakot lon nthopoko othakka itti akwina itti ul woIouth wontha akka akkot poꞌre naak ittina. ");
INSERT INTO lmd_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Anakka ul irro wothorok ana ïꞌrïkïkkok itti kwapoko, aPoluc iꞌrekat ili woul arrial ukuluk irro iokat acoꞌro iccik kung itti “Locoꞌrotheik nanon itti nthakkwe pul ponoul woRoma ipannincat itti kwokkothe lon lꞌrek molokoi?” ");
INSERT INTO lmd_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Anakka ili woul arrial ukuluk irro woccïkothe menik waththerekanthet ili irïk woul irro, aili woul arrial ukuluk irro iꞌrekat ili irïk itti, “Ngintha akka ngkwaik pathokkot, pul empi poul woRoma.” ");
INSERT INTO lmd_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Aili irïk woul irro oingkanthet oPoluc ana wipittathok itti, “Iꞌrethin oung pul poul woRomai?” APoluc othïat tit itti, “Ïï.” ");
INSERT INTO lmd_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Aili irïk woul irro othïanthok itti, “Mponekkethe akucci woppot anocco kaꞌrmacak kopul poRoma.” Ana oPoluc piꞌrekathok itti, “Anaruk mpokwontat pul poRoma.” ");
INSERT INTO lmd_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Aul ocottakat aththaman iarokat itti waik wathipittot oPoluc lon, aili irïk woul irro ipat nꞌre akka kwaththiot itti kwonekkethe pul poul woRoma ikorrkkor. ");
INSERT INTO lmd_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Ana ngorrot ngen aili irïk woul irro angkat itti kwina lon ila ul woIouth worukwenthet oPoluc ngngin akwopelikkat oPoluc nti iloꞌrak akwakkarat ul ittïttïk woul wonoppan toKapik ana cuththun coul woIouth ittïttïk appik. Akwonakat oPoluc akwoceꞌrekathok tokït ken. ");
INSERT INTO lmd_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","APoluc okathakat cuththun coul woIouth ittïttïk akwiꞌrekat itti, “Pangkingon, mpikkot cik ana okkot ana orekine Kapik ncïkït culukku manna inenni.” ");
INSERT INTO lmd_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Menik apul iprïk ponoppan toKapik Anania iꞌrekat ul iokat cik acoꞌro iccik koPoluc itti okin thakkwokok thon. ");
INSERT INTO lmd_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","APoluc iꞌrekathok itti, “Kapik kakkwokung oung ipinnikot lon. Ngkwikkoik ere kunthong ikipuk ikimentat kicce. Ngkwikkoik ceneket akkman ammakka lon lothonceꞌret lon cik liꞌret ana icci oung ngka kang akorronno omakot lon lothonceꞌret lon cik llon elli ila ngkwiꞌret itti mpakkutta.” ");
INSERT INTO lmd_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Okkwion ithokat akin ocoꞌro iccik koPoluc thiꞌrekathe itti, “Oung emprïk ngkwacungkwo pul iprïk ponoppan toKapiki?” ");
INSERT INTO lmd_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","APoluc othïat tit itti, “Pangkingon mpappommat itti kwokat pul iprïk ponoppan toKapik akka lokurrakot itti, ‘Kirrnni eret ili woul won llon ilokithak.’” ");
INSERT INTO lmd_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","OPoluc pappinat itti ul iaik nocuththun coul woIouth wokat mothok meꞌra tit, pꞌrek poul woCcathukkin ana pꞌrek poul woPriccin, akwiꞌrekat lon mpoꞌre cittan nokaꞌran kocuththun coul woIouth ittïttïk itti, “Pangkingon, oun poPriccin ukul wopul poPriccin mpaik pocoꞌro cene tokït konili nothonceꞌret lon cik akka mpoccokothe lon nocïkït itti thuroko nti ithio thaik.” ");
INSERT INTO lmd_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Anakka kwiꞌret lon elli athopllarot urokat ncik nul woPriccin ana woCcathukkin ana ul willakatherit nocuththun mungkut meꞌra. ");
INSERT INTO lmd_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","(Cungkut coul woCcathukkin ciꞌre itti thuroko nti ithio thella ana manna uꞌrupa wothothïlettat woKapik wella ana manna aꞌrupu iella ka, anaruk ul woPriccin woccokothe lon len appik nomïkït men.) ");
INSERT INTO lmd_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Apoꞌre okuꞌrat ciki ithiꞌrot thokapik aul wꞌrek iangkene lon lothonceꞌret lon cik loul woPriccin urokat kapik akin ikkat cik akin aꞌretto cannan akin iꞌrekat itti, “Oron thanniot lon ilokithak ila pul empi pokkothe, ngintha akkaik amma uꞌrupa wothothïlettat woKapik ana manna papꞌrek ipella ka perenok?” ");
INSERT INTO lmd_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Aul ikkat cik antere cannan mono aili irïk woul irro ipat nꞌre athïat ul wung irro akka okin omotto iaPoluc anakathok nti ithoꞌrkït then mpuꞌran anakok ikaman koul irro. ");
INSERT INTO lmd_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Ana ngkoꞌra ngen aIli ocoꞌrot iccik koPoluc akiꞌrekathok itti, “Opoꞌrithan ammakka ngkwerenet ul lon lin nokaꞌran koUruccelim menik ngkwonu itti ngkweret nokaꞌran koRoma cakuruk.” ");
INSERT INTO lmd_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Ngorrot ngen ul woIouth wïꞌrïkathe lon len tothun akin okkwat mio itti okin thannoꞌrkoik ana ïkko alpꞌrek aththik akin okkwot oPoluc kappak. ");
INSERT INTO lmd_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Ul iokat wokkothe lon len wokat woppot nomaun arrial weꞌra (40). ");
INSERT INTO lmd_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Okin thoingkanthet ul ittïttïk woul wonoppan toKapik ana ul ittïttïk woul akin iꞌrekat itti, “Onïn thïꞌrïkot lon ana okkwo mio itti onïn thannoꞌrkoik puccuk ïnokkwat oPoluc. ");
INSERT INTO lmd_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Onon ana cuththun coul woIouth ittïttïk nthonu itti nthiꞌret ili irïk woul irro akwakkarot oPoluc nocuththun attang othakka itti annipittothok lon. Onïn thokuccekotheik, onïn thakkwothok akkwarthuk anthan cene.” ");
INSERT INTO lmd_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Anaruk akka ukul wopang poPoluc ipopari woccïkothe lon len woingkathe ikaman koul irro athiꞌrekat oPoluc. ");
INSERT INTO lmd_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Menik aPoluc akkarat ili wꞌrek woul irro akwiꞌrekathok itti, “Oneki ukul enni anekine ili irïk woul irro, konu lon lakwiꞌrethok.” ");
INSERT INTO lmd_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Ittina wonekanthet ili ukul aili iꞌrekat ili irïk itti, “OPoluc ipaik ikorrkkor pothïothin nukul enni iocura itti mpananung akka wonu lon lꞌrek lakwiꞌrethung.” ");
INSERT INTO lmd_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Aili irïk woul irro occokat ukun wokkul athathok thocipit apittathok itti, “Ngintha akka ngkwonu itti ngkwiꞌrethin.” ");
INSERT INTO lmd_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Aukul iꞌrekat itti, “Ul woIouth wïꞌrïkot lon itti okin thipittothung itti ngkwananekin oPoluc ngorrot tokït kocuththun coul woIouth ittïttïk akin appipittothok lon papenang. ");
INSERT INTO lmd_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Anaruk kirrnni occïkïnthet kin itti ngkwananekin oPoluc nocuththun akka ul woppot manna wekko arrial weꞌra waik warukwinthok. Okin thokkwot mio itti okin thannoꞌrkoik ana okorronno ïkko ngꞌri akin tharthuk okkwothok. Okin thokuccekotheik ana okin thaik thaꞌrïkot thothïot thang tit tulluk.” ");
INSERT INTO lmd_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Aili irïk woul irro elikkat ukul aeo aiꞌrekathok tulluk itti, “Kirrnni iꞌret opilin itti ngkwerenin.” ");
INSERT INTO lmd_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Aili irïk woul irro akkarat ul irro weꞌra ittarothok akwomekat kin itti, “Nokuccet ul irro cik arrial ukuluk maꞌri meꞌra (200) aeo kicce ngkoꞌra amma cïngkï cokkothe ukullacoꞌrin nokaꞌran koKaiccaria, ana ul irro cakuruk mapprththa arrial wꞌrapuruk ana alkaire (70) iarrothe mapprththa, ana ul arrial ukuluk maꞌri meꞌra iokuccettatheik (200) nathuk. ");
INSERT INTO lmd_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Nokuccenthet oPoluc mapprththa cik imaneko kin akweo poporot akwonekittane ili irïk oPpelek.” ");
INSERT INTO lmd_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Akwokurranthet ili irïk kaꞌramacak ittina, ");
INSERT INTO lmd_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Lon elli naun oKklauthioc koLicciac, Laine ili irïk oPpelek: Mpamiccong. ");
INSERT INTO lmd_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Pul empi pokat poccokittathe nul woIouth ana okin thokat cik thakkwothok, anaruk mponakathe ul irro win ana mpoꞌrekathok, ana mpaththiot itti ook ponoul woRoma. ");
INSERT INTO lmd_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Ana mpangkathe itti mpina lon ilakin orukwethok ngngin ana mponakathok tokït kocuththun coul woIouth ittïttïk. ");
INSERT INTO lmd_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Ana mpathtthiot itti lon ilakin thaik tharukwethok ngngin lothonceꞌret lon cik ana lella ilakin orukwethok ngngin ilekko nan itti kwakkuttat ana manna lella ila kwonekkettat ikorrkkor ngngin. ");
INSERT INTO lmd_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Ana manna mpoccïkothe itti okin thonekkethe lon cik itti okin thongothe itti okin thakkwothok ana mpothïnthung ngok aththaman ana mpiꞌrethe ul iaik warukwethok akin ainung akin onanung lon lung ilakin orukwethok ngngin. ");
INSERT INTO lmd_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Ittina aul irro occïkat lon loili irïk woul irro akin onekat oPoluc ngkoꞌra akin oingkat nokaꞌran kAnththippaththric. ");
INSERT INTO lmd_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Ana ngorrot ngen aul irro opakkat tuan ana ul irro iaurrothe ipat oPoluc akin oingkat nokaꞌran koKkaicceria. ");
INSERT INTO lmd_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Anakka maat nokaꞌran koKaiccaria akin ekat oPoluc ili oPpelek ana kaꞌramacak ika ili wothïothekin ngngin. ");
INSERT INTO lmd_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Aili akkakkarat ikaꞌramacak akwipittat oPoluc itti, “Ngkwo noththok piatha?” Ana oPoluc pothïanthok tit itti, “Mponoththok poKilikkia.” ");
INSERT INTO lmd_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Aiꞌrekat oPoluc itti, “Mpaccïkot lon lang amma ul iorukwethung waat.” Akwiꞌrekat ul irro itti okin thangwot oPoluc tuan toili irïk oIruthuc ikorrkkor. ");
INSERT INTO lmd_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Anakka maꞌri meot ncik ukuluk, apul iprïk ponoppan toKapik Anania ana ul ittïttïk woul woIouth uat nokaꞌran koKaiccaria ana pul iporrot noul lothonceꞌret lon cik oTherththolec akin onakat ili oPpelek lon ilakin thorukethe oPoluc ngngin. ");
INSERT INTO lmd_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Anakka oPoluc pakkarakothe tokït koPpelek, pul iporrot noul oTherththolec pikkatheik akworukwet oPoluc llon akwiꞌret ili oPpelek itti, “Ili oPpelek, onïn thopirat noka nongili ngang ia ngwethet nïn ïnikkoik thoporot ana ngkwothikkiet lon loporot ilokat moloko noththok ponnon. ");
INSERT INTO lmd_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Ana onïn thopiranung noka nolon len ila ngkwokkothe noththok appik. ");
INSERT INTO lmd_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Anaruk mpannangkot itti mperenung lon loppot anaruk mpipittothung itti ngkwaccokot cïkït accïkïnthet nïn lon lïn nomaꞌri emmi motte. ");
INSERT INTO lmd_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Onïn thiothe pul empi ponu thukungkun, apereket ul iul woIouth nocapu ncik appik. Ook ca cocungkut icoccot kꞌran itti ‘Ul iammakot pul poNaccir.’ ");
INSERT INTO lmd_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Ana cakuruk kwokat pathikkie tupan toKapik irupupure tokithak ana onïn thoccokathok. ");
INSERT INTO lmd_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Anaruk ili woul irro ioccot kꞌran itti oLicciac wonekathe nïn ngok nti ikkun mpuꞌran. ");
INSERT INTO lmd_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Ana amma ngkwipittothok ana ngkwathiot itti lon lïn laik ïcat ilanïn thorukwethok ngngin.” ");
INSERT INTO lmd_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Aul woIouth angkat lon loTharththeloc akin omekat itti laik ïcat. ");
INSERT INTO lmd_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Anakka ili oPpelek wiꞌrethe oPoluc itti kwere, kwiꞌrekathe itti, “Mpina itti oung akkaik pakkma ul enni, ana ittina mpongothe mprrot noka kin. ");
INSERT INTO lmd_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Ana ngkwina akka aiot lon ngka kang, mponu inenni maꞌri attul ana ikken keꞌra ammakka mpokat pokuꞌrothe tentre nokaꞌran koUruccelim ampaththaꞌrane Kapik ngaꞌrama. ");
INSERT INTO lmd_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Ul iorukwethin llon wanniothin anaꞌretto iul wꞌrek noppan toKapik ana manna nocuththun caꞌrama ana manna nokaꞌran kꞌrek icarak coman. ");
INSERT INTO lmd_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ana okin thella lon cik ilakin okeneng ilakin thaik tharukwethin ngngin inenni. ");
INSERT INTO lmd_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Anaruk laik ïcat itti mpaꞌrane Kapik kongappan thonnon ngaꞌrama ammakka pul ipaik pammakot kathar kolon loIeccuo ikakin thaik thiꞌre itti karra. Mpaik paccot kït nolon appik ilangkothe lon lothonceꞌret lon cik loMucca ana ilokurrakot inatham noul wothernte lon loKapik, ");
INSERT INTO lmd_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","ana mponu thoꞌrïkot cik then itti thuroko nti ithio thakaik thoul iupupure ana iokithak. ");
INSERT INTO lmd_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Ana itti mpaik pakwantot kathar ika anopoꞌrathan ngngnin anoꞌrungkot pupure noucce tokït koKapik ana tokït koul.” ");
INSERT INTO lmd_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","OPoluc poꞌrungkathe nolon akwikkat cik akwiꞌre itti, “Mponu luput loppot ampella nokaꞌran koUruccelim, ana mpaat ponanet ul win aꞌrupu akin ikket ul iella aꞌrupu cik ana cakuruk anathethet Kapik aꞌrupu wothokiot ngüccük cik. ");
INSERT INTO lmd_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Ana ul woIouth waththiothin ampocothe thonthukkako ampaik ithaꞌrapak thonoppan toKapik. Ul wellat ianïn thokat cik onïn aththut ana mpellat icungkut cꞌrek cocamutta. ");
INSERT INTO lmd_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Anaruk ul wꞌrek waik nnoul woIouth nnoththok pAccia, okin ithonu itti nthanthan tokït kang akin erenung ilakin thorukethin ngngin amma laik. ");
INSERT INTO lmd_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Ana manna okkwion ithaik cene thira there lon ilokithak ilakin thiothin ngngin akka mpocoꞌrot tokït kocuththun coul woIouth ittïttïk cene. ");
INSERT INTO lmd_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Katha lon lulluk elli ilulukku ila mperethe tokït ken ilanon thaik tharukwethin inenni ana ilen itti akka mpoccokothe lon nocïkït itti ul wuroko nti ithio.” ");
INSERT INTO lmd_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Ana oPpelek pappinat kicce lon loul iakkarako itti kathar koIeccuo akwocoꞌrat tokït koul imakkma akwiꞌrekat itti, “Amma ili irïk woul irro waat ioccot kꞌran itti oLicciac ana mpakatha itti mpakkothung tat.” ");
INSERT INTO lmd_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Akwiꞌrekat ili wꞌrek woul arrial ukuluk irro itti wangwot oPoluc anaruk akwokorronno akwoppot thapat ana opakkot noppan pellek ana okorronno oceꞌre opurukon akin okatha naak ana manna okkinthok lon ila kwongothe. ");
INSERT INTO lmd_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Ana nomaꞌri motteik aPpelek akkakat akin opari oThruccila ana opari pappokat poul woIouth. APpelek akkarat oPoluc occïkat lon lung lothoccokot lon loIeccuo oMiccie nocïkït. ");
INSERT INTO lmd_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Anakka oPoluc pokat cik akweret thoporot tokït koKapik, ana thoccokot ka ana thakkma ithaik thanthan, aPpelek ipat nꞌre akwiꞌrekat itti, “Lekkot, ngko. Amma oun akkaththiot lon laik ana mpakkarong.” ");
INSERT INTO lmd_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Ana oPpelek pokat ponat lon ica itti oPoluc pethok akucci wotte ana kwikkatheik akwakkakkaro appinappin akwerntenok. ");
INSERT INTO lmd_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Anakka luput leot ncik leꞌra, aili oPorkkioc oPocththoc opakkat noili nokaꞌran koPpelek anaruk akka oPpelek pappongothe itti kwapirie ul woIouth noka akwoththekanthet kin naPoluc ikorrkkor. ");
INSERT INTO lmd_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Akka oPocththoc paat noththok poIouthia othakka itti akwathothakka ili, kwikkatheik maꞌri mꞌrapuruk nokaꞌran koKaiccaria akwantokuꞌrot nokaꞌran koUruccelim ");
INSERT INTO lmd_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","na ul ittïttïk woul wonoppan toKapik ana ul ittïttïk woIouth werenthok lon ilakin thokat akin orukwet oPoluc ngngin. ");
INSERT INTO lmd_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Akin uekat ili oPocththoc akin ipittathok itti kwathïnthet kin oPoluc ntan nokaꞌran koKaicceria akin othïothok Uruccelim. Anaruk okin thonat lon ica itti okin tharukinthok akin okkwothok nokathar. ");
INSERT INTO lmd_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","APocththoc othïanthet kin tit itti, “OPoluc pikkoik ikorrkkor tentre nokaꞌran koKaiccaria anaruk mpaik papakkot than nomaꞌri emmi. ");
INSERT INTO lmd_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Anili non nꞌrek anthan ïneo aththut anothere amma pul pen akkokkothe lon lokithak.” ");
INSERT INTO lmd_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Anakka kwikkot cik tentre akin aththut maꞌri attul akuat opakkot nokaꞌran koKaiccaria ana ngorrot ngen akwothikkat nokaꞌran kolon lothonceꞌret lon cik akwothïat lon itti okin thakkaro oPoluc. ");
INSERT INTO lmd_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Anakka oPoluc paat aul woIouth iaat nokaꞌran koUruccelim aꞌrntakat naak akin orukwekathok llon loppot lokitheththak anaruk okin thommakathe okene itti lon len lokat cik tat. ");
INSERT INTO lmd_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","APoluc urokat akworrot noka kung akwiꞌrekat itti, “Mpannokkot lon ilokithak noppan toKapik ana nolon lothonceꞌret lon cik loul woIouth ana naKkaiccer.” ");
INSERT INTO lmd_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","OPocththoc pangkathe itti kwapirie ul woIouth noka akwipittat oPoluc lon itti, “Ngkwongothe itti ngkwakuꞌrot Uruccelim aul woIouth othonceꞌrenthung lon cik elli tentrei?” ");
INSERT INTO lmd_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","APoluc othïat tit itti, “Mpaik pacoꞌro nokaꞌran kothakkma koKkaiccer na lon lin lonu itti laceꞌrettat cik. Ngkwina papenang itti lon lella ilokithak ila mpokkinthet ul woIouth. ");
INSERT INTO lmd_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Ana amma okin thonat lon itti mpokkothe lon ilokithak ïcat manna ilekkot nan itti mpio ana mpakorronno opellene thio. Ana amma ilakin orukwethin ngngin lakorronno oka ïcat, pul pella ponu lon itti pethin kin ikkun. Mparinthet oKkaiccer lon lin othakka itti akwoccïkot lon lin.” ");
INSERT INTO lmd_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","APocththoc eretteranthet okin oul ittarothok ire akin iꞌrekathok itti, “Ngkwipittot itti ngkwongothe itti ngkwaine Kkaiccer, ngkwanekittane oKkaiccer.” ");
INSERT INTO lmd_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Anakka maꞌri meot ncik motteik aili irïk Akrippac ana pul ipopari oPernic akkakat nokaꞌran koKaiccaria akin omicco oPocththoc. ");
INSERT INTO lmd_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Anakka okin thokat akin ikkoik than maꞌri motteik oPocththoc perekanthok lon loPoluc ipaik ikorrkkor akwiꞌrekathok itti, “Puꞌrek paik cene paPpelek pampoththet nan ikorrkkor. ");
INSERT INTO lmd_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Anakka mpeot Uruccelim aul ittïttïk woul wonoppan toKapik ana ul ittïttïk woul woIouth werekanthin lon lopul empi ana okin thorukwethok ana okin thiꞌrekathin itti konu itti kwakkmako. ");
INSERT INTO lmd_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Ana mpiꞌrekathekin itti lon ilaik noul woRoma lonu itti pul pannokkuttat nuthuk amma pannorukwettat llon lꞌrek ana okin okorronnok akworrot noka kung. ");
INSERT INTO lmd_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Anakka okin thaat cene mpikkathe cik nokaꞌran kolon lothoceꞌret lon cik accokkot mpakorronno occoik aththik ana mpakkarathe pul pen ngorrot ngen. ");
INSERT INTO lmd_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Ana ul iorukwethok llon werekathe lon len, ana lellakathe ilekkot nothorukettot ithakin thorukethok ngngin itha mpokat anoccot kït nan itti okin tharukwethok ngngin. ");
INSERT INTO lmd_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Anaruk okin thonat lon lothoccokot lon nomïkït loKapik akin opllarot ngngin lopul iponu kꞌran itti oIeccuo ipiot ana oPoluc pokat akwome itti kwiot anaruk kwaik ngkït thapat pannio. ");
INSERT INTO lmd_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Ana mpommat itti mpipitto lon elli tat, ittina mpipittathe oPoluc amma kwongothe itti kwokuꞌrot Uruccelim akin appotheret lon lothorukwettat thung than. ");
INSERT INTO lmd_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Anaruk akka oPoluc pothïnthet ili irïk oKkaiccer lon lung itti kwakathanok lon elli, mpiꞌrekathok itti kwikkoik puccuk anothïanthok oKkaiccer.” ");
INSERT INTO lmd_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","AIli oKrippac iꞌrekat oPocththoc itti, “Mpongothe itti mpaccïkot lon lopul empi.” APocththoc iꞌrekathok itti, “Ngkwaccïkothok ngorrot.” ");
INSERT INTO lmd_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Ana ngorrot ngen aIli Akrippac okin oPernic okkat kamuthe kïttïk noppan tocuththun nul ittïttïk woul irro, ana wikkoik aul okkwet kin ithoꞌrkït ittïttïk nokaꞌran koKaiccaria ana nili noul irro aili oPocththoc othïat ul akkarat oPoluc akin onakathok. ");
INSERT INTO lmd_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","OPocththoc iꞌrekat itti, “Ili Akrippac ana ul iaik cene appik, pul empi cene paul woIouth nokaꞌran koUruccelim ana nokaꞌran koKaiccaria cene wiꞌret mpoꞌre cittan itti ponu itti pakkuttat. ");
INSERT INTO lmd_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Mpaththiot itti kwannokkot lon lꞌrek lokithak ilakorronno itti kwakkuttat anaruk inakka kwothïnthet ili oKkaiccer nokaꞌran koRoma itti kwakathanok lon ana ilen akka mpiꞌrenet itti mpathïothok nokaꞌran koRoma. ");
INSERT INTO lmd_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Anaruk mpella lon ila anokurrine ili oKkaiccer ileret lon loPoluc. Ilen akka mponarok cene tokït kon appik ana cannan tokït kang Ili Akrippac othakka itti aniot lon lꞌrek ila anokurro. ");
INSERT INTO lmd_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Akka lakannoka loporot naun itti mpathïot pul ipaik ikorrkkor appella lon ilorukwettathok ngngin.” ");
INSERT INTO lmd_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Ittina Akrippac iꞌrekat oPoluc itti “Ngkwonu itti ngkwere arrot noka kang.” Ittina aPoluc onthat ukun kapik akwikkat cik akwere akrrot noka kung akwiꞌrekat itti, ");
INSERT INTO lmd_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Ili Akrippac, mpakatha ka kin ere mponu prran akka mpaik pacoꞌro tokït kang inenni ampaik anrrot noka kin nothorukwet appik itha ul woIouth worukwethin ngngin, ");
INSERT INTO lmd_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","ana manna cannan akka ngkwina thathuma thoul woIouth ana thopllarot llon ithakin thaik thapllarot. Ittina mpipittothung itti ngkwakkwinin kunu ncik okorronno attakoik. ");
INSERT INTO lmd_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Ul woIouth appik wina kathar kothikkoik thin ammakka mpotteik, nci ammakka mpurokot ncik nokaꞌran kin na ampupokkothe ana cakuruk nokaꞌran koUruccelim. ");
INSERT INTO lmd_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Okin thinan nci maꞌrot ana manna okin ngka ken there lon ilakin thimmat ana occïkot lin, amma okin akkongothe, laik itti okin thina itti mpokat pul poPriccin icungkut icokat commaththik nomungkut imokat cik. ");
INSERT INTO lmd_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Ana inenni mporukwettathe akka mpaik paꞌrïkot lon ila Kapik konekkenthet ongappan cik. ");
INSERT INTO lmd_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Ana thonekket lon cik enthi ithen akka mothok moul woIccereil iattul ana ikken keꞌra maik maꞌrïkot itti lon len lathakka akin thaik akin aꞌrane Kapik ngaꞌrama ngkoꞌra ana icïngkï. Ili win, thoꞌrikot cik akkokorronnot ul woIouth arukwethin. ");
INSERT INTO lmd_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Onon ithaik cene, nthontha akka nthꞌrat onekket lon nocïkït itti Kapik kurokie ul illet? ");
INSERT INTO lmd_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Oun cakuruk pokat anokwarttikot itti mpakkot lon ncik appik anꞌra oIeccuo ponokaꞌran koNaccir. ");
INSERT INTO lmd_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Ana ilen accok akka mpokkothe nokaꞌran koUruccelim. Ana llon ikkun nnoul ittïttïk woul wonoppan toKapik, mpipothe ul woKapik woppot ikorrkkor itti okin ithokat thakkmakot thangutta ana mpangkothe lon len itti okin thangutta. ");
INSERT INTO lmd_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Mponyarot maꞌri moppot nomuththun maꞌrama anocciccokot kin anothakkma kin ana onentet kin than akin ocungko oIeccuo. Mpokat pua ka ken manna anikkat cik anomakot kin ci naꞌran woul wꞌrek woka anothokkiet kin thiak.” ");
INSERT INTO lmd_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","APoluc ikkat cik akwerenekin itti, “Ana nokurtti kꞌrek, ampokat cik aneo nokaꞌran koThimacakka amponu kaꞌrmacak nnonili ikkun ana koul ittïttïk woul wonoppan toKapik. ");
INSERT INTO lmd_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Ana cik cokat acïngkï angko ippa, ili win, ana mpokat cik nokathar animmakat kꞌran akkaat ntothiꞌrot kipuk ippuk nocïngkï akoccat naun ana noul ianïn thokat cik aththut. ");
INSERT INTO lmd_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Onïn thapukkwathe nocapu appik ana mpoccïkathe apoꞌre erenin ngkarru koIpranin apiꞌre itti, ‘Caul, Caul ngkwontha akka accokiethin thiak? Lokithak itti ngkworro iaun.’ ");
INSERT INTO lmd_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Ittina anipittat itti, ‘Ili, oung oththa?’ Apothïat tit itti, ‘Oun oIeccuo ipaccokiet thiak. ");
INSERT INTO lmd_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Uroki acoꞌrot kapik mpumminthung ncik itti anothikkieng pul iparekinin ana pul ipathere lon lin ammakka ngkwimmat ana ila anokeneng. ");
INSERT INTO lmd_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Mpaꞌrethung nti inyaun nyoul wang ana nyoul iannoka woIouth. Mpaik pathïothung nakin ");
INSERT INTO lmd_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","anyinthet kin kït ana aukkwot kin nti iꞌrïmak anakin nokꞌran ana nti ikkun wopul pothopulut anakin ikkun woKapik itti alon len ilokithak occïkakot ana akin iot kaꞌran ithoꞌrkït thokkwion ithothakkat thupupure nthoccokot lon lin nomïkït men.’” ");
INSERT INTO lmd_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","APoluc ikkat cik akwerenekin akwiꞌre itti, “Ili Akrippac, mpokat pannꞌra lon len ilaat ntothiꞌrot. ");
INSERT INTO lmd_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Mpongkenet ul woThimacakka cittokït anantongkene ul nokaꞌran koUruccelim ana noththok poIouthia, ana ul iakonnoka woIouth appik anomet kin itti okin thapaꞌrine lon ilokithak cik akin okkaprttakine Kapik ana okkot ngre iakene itti okin thocoꞌrot nti ilon ilokithak. ");
INSERT INTO lmd_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Ilen akka ul woIouth woꞌruminthin noppan toKapik itti okin thakkwothin. ");
INSERT INTO lmd_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Anaruk Kapik kittarothin manna inenni, ana mpaik pacoꞌro anerene okin itharran ana ul ioccokkat cakuruk. Mpaik pere lon ila oMucca peret ana ul wothernte lon loKapik theret itti lathokaik, ");
INSERT INTO lmd_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","itti oMiccie paccokot thiak ana kwaka pul ipuroko cittokït nti iul iilet ana kwangkene ul woIouth ana ul iannoka woIouth appik kathar kothoꞌrettat.” ");
INSERT INTO lmd_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Anakka oPoluc piꞌret elli, aPocththoc iꞌrekat lon mpoꞌre cittan itti, “Poluc, ngkwonu purrut thakkakkaro thang thaik thikïttïnung ngathꞌre ngang.” ");
INSERT INTO lmd_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","APoluc othïanthok tit itti, “Ili oPocththoc, lon ila mpaik pere laik ïcat ana laik ipangken. ");
INSERT INTO lmd_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Akka Ili Akrippac ia mpaik perene ella nꞌre wina lon elli appik ana mpina itti loꞌrek lella ila kwomma akka lon len lannokkattat imakkren nthuꞌran. ");
INSERT INTO lmd_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Ili Akrippac, ngkwoccokothe lon loul wothernte lon loKapiki? Mpina itti ngkwoccokothe lon len.” ");
INSERT INTO lmd_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Akrippac iꞌrekat oPoluc itti, “Ngkwapri itti ngkwathikkien pul ipoccokothe lon loMiccie accokkot ittinai?” ");
INSERT INTO lmd_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","APoluc othïat tit itti, “Amma accokkot ana manna okorronno oka accokkot mpongothe itti kannothikkieng prek anaruk ul appik iaik waccïkot lon lin itti athakka ammakka oun llon ila mpaik tit anaruk annoka iloꞌrak ila mpaik tit.” ");
INSERT INTO lmd_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","AIli Akrippac ana oPocththoc ana pul ipopari oPernic urokat ana ul iokat cik aikkoik akin aththungon mono aingkat. ");
INSERT INTO lmd_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Akin erettaranthet akka okin thokat cik akin eo akin iꞌrekat itti, “Pul empi pannokkot lon lꞌrek ilokithak ilakorronnok itti kwakkuttat ana onekkettat ikorrkkor.” ");
INSERT INTO lmd_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Akrippac iꞌrekat oPocththoc itti, “Pul empi pokat ponu itti pelikkako amma pokat pannothïnthet ili oKkaiccer lon lung.” ");
INSERT INTO lmd_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Anakka lon lïꞌrïkakot itti onïn thaeo noththok poIththalia, oPoluc ana ul wꞌrek iokat ikorrkkor wettakathe ili woul irro ionat kꞌran itti oIulioc okkwi iponat lon ikkun loul irro arrial ukuluk (100) ionat kꞌran itti 'ul irro woKkaiccer.' ");
INSERT INTO lmd_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Onïn tharrathe kuppuꞌrung konoiꞌri konokaꞌran kAthramith anïn eo arrot nokuthut korok irapangka ikaik noththok pAccia. Ana onïn thokuccekatheik itti onïn thaeo thorok irapangka. Ana Arcciththrikkoc pokat poul wonoththok poMakthonia nokaꞌran koThocculunukkia pokat ïnnaththut. ");
INSERT INTO lmd_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Ana ngorrot ngen onïn thakkakathe nokaꞌran koCcithon ana ili oIulioc wokat woporot naPoluc akwokorronnat oPoluc akwoine opurukon akin ittarothok naꞌrupu ia kwongothe. ");
INSERT INTO lmd_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Ncïnang onïn thapproingkat attang thorok irapangka okko iccik kocik iconthomat corirok irapangka coKupruc akka kanang kokat kommakethenïn. ");
INSERT INTO lmd_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Anakka onïn thokkot noththok poKilikkia ana poMippilia onïn thorpatheik nokuthut korok irapangka tokaꞌran koMira irokat noththok poLikkia. ");
INSERT INTO lmd_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Aili woul irro iat ngkuppuꞌrung koniꞌri ikat nnokaꞌran koIcikkantharia akeo noththok poIththalia ana kwarriekathenïn tit. ");
INSERT INTO lmd_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Kuppuꞌrung koniꞌri koingkathenïn ngngin kiccekicce maꞌri moppot akka kanang kokat kommakethenïn mono anïn akkakat nokaꞌran koKinithic. Anakka kanang kokat kommakethenïn itti onïn thaeo, onïn thokkathe iccik kocarkan corok irapangka toCalmon nocik iconthomat corirok irapangka coKkrit na kanang kokat kotte. ");
INSERT INTO lmd_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Onïn thoingkathe omakot carkan coKkrit mpuꞌran kiththik mono anïn akkakat nokaꞌran ikoporot na uppuꞌrung wonoꞌri nakin ocoꞌrittako iccik kokaꞌran koLiccaia. ");
INSERT INTO lmd_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Maꞌri moingkathe moppot ana thonyaro thïn noiꞌri thokat thommaththik ana kamuthe koThoccïkarnthet lon ilokithak kokat keot ncik. Ittina oPoluc perekanthet kin lon len itti, ");
INSERT INTO lmd_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Ul, mpaik pakathe ere kurtti konnon kaik kathothakka kommaththik, kikko kieron ka kongo ana kuppuꞌrung konnon konoiꞌri kurat cik ana aꞌrupu iaik tit appik ana manna ka konnon cakuruk.” ");
INSERT INTO lmd_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Anaruk ili woul arrial ukuluk irro wꞌrakathe occïkot lon loPoluc accïkot lon lopul ipallillie kuppuꞌrung konoiꞌri ana pul iponu kuppuꞌrung konoiꞌri. ");
INSERT INTO lmd_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Ana akka kaꞌran na kuppuꞌrung konoiꞌri kocoꞌrot kokat kannoka koporot itti ul wikkoik nan icpo, ul wiꞌrekathe appik itti, “Ntrun oththe nokaꞌran engki aron eo nokaꞌran koPinic aron othikkoik than icpo.” Kaꞌran koPinic kokat nocarkan noththok poKkrit ikakatha tok irapangka iraik na cïngkï orungko. Kaꞌran ken kokat koporot auppuꞌrung wonoiꞌri ikkoik than icpo. ");
INSERT INTO lmd_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Anakka kanang kopappat kaat nthokkun wothothari amma akatha na acïngkï ummot ngngin, okin thomekathe itti lathakkanet kin loporot pꞌrïn itti okin thaeo. Ittina okin thonthathe paponte ipakin ipakorronno kuppuꞌrung akocoꞌro iꞌri akin oingkat omakot carkan conoththok poKkrit. ");
INSERT INTO lmd_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Anaruk papotteik akanang akkakat kommaththik na acïngkï ummot ngngin nocik iconthomat corithoꞌrikït thorok irapangka akokkurat kin. ");
INSERT INTO lmd_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Kanang koceꞌrekathe kuppuꞌrung konoiꞌri ana kommakathe eo na anïn thokat thongothe itti onïn thaeo, ittina onïn thokorronnathe kanang akipo kuppuꞌrung na kokat cik akeo. ");
INSERT INTO lmd_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Anakka onïn thokkot nocik iconthomat corithoꞌrikït thorok irapangka icoccot kꞌran itti Kautha, onïn thothathe kuppuꞌrung konoiꞌri ikotte ika anïn thokat anïn othutho thoceken cokuppuꞌrung ikrïk mpuꞌran ïnonthat ikuppuꞌrung koniꞌri ikrïk. ");
INSERT INTO lmd_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Okin thokkiekathe loꞌrak thoceken cokuppuꞌrung akin ïꞌrïkarot tothun. Okin thonat nꞌre akka kanang othïot kin nocarkan coLipia akin iꞌrakat ithamur. Ittina okin thorpekathe paponte icuꞌre cokuppuꞌrung irok othakka akuppuꞌrung ollo kiccekicce ngkanang akin okorronat kuppuꞌrung konoiꞌri akanang itte. ");
INSERT INTO lmd_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Kanang kaꞌrungkwothe menik puccuk, ana ngorrot ngen okin thikkatheik akin orrekat aꞌrupu ia ikuppuꞌrung kokat akonneko irok irapangka. ");
INSERT INTO lmd_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Ana nomaꞌri imꞌrapuruk okin thorrekathe aꞌrupu wokuppuꞌrung wꞌrek nynyaun nyen. ");
INSERT INTO lmd_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Manakka onïn thikkot cik maꞌri moppot anïn thannimma cïngkï ana mothot, ana kanang kokat cik akokkurarot cannan, amïkït mïn ellakat ikarak pꞌrin anïn ellakat lon lolon itti onïn thaik thakkoik. ");
INSERT INTO lmd_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Anakka ul wikkot cik maꞌri moppot ntï aPoluc urokat kapik akwiꞌrekat kin itti, “Ul onon thira thaaccïkothe lon lin annokorronno uroko noththok poKkrit ana onon thokorronno okïttot aꞌrupu enni. ");
INSERT INTO lmd_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Anaruk mperenenon itti thakorronno ipo nꞌre akka pul pella nti ianon puret ka kung cik anaruk kuppuꞌrung konoiꞌri kuluk akkakïttako. ");
INSERT INTO lmd_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Maman ngkoꞌra uꞌrupa wothothïlettat woKapik kin ika mpaik parekine wocoꞌrot iccik kin, ");
INSERT INTO lmd_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","aiꞌrekat itti, ‘Poluc, kirrnni opelle ngkwonu itti ngkwaka tokït koili oKkaiccer nokaꞌran kothonceꞌret lon cik ana Kapik kethet non thikkoik appik oung ana ul ianon thaik theo anaththut appik nothoporot thung.’ ");
INSERT INTO lmd_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Ittina nokorronno irro mïkït nti ikarak akka mpoccokothe lon nocïkït loKapik itti lakaik ammakka kwiꞌrethin. ");
INSERT INTO lmd_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Anaruk oron thee ka ncik nocik iconthomat corithoꞌrikït thorok irapangka aron iꞌrakat.” ");
INSERT INTO lmd_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Anakka maꞌri mothakkat attul ana ikken kocoꞌrin (14), onïn thokat iiꞌri norok irapangka tAthria irokat ithoꞌrïkït tonoththok poKrik ana poIththalia. Ana thampang thongkꞌra aul iallillie kuppuꞌrung konoiꞌri okathakat ere onïn thakko napuththut nocarkan corirok. ");
INSERT INTO lmd_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Akin onekat thoꞌrak thakin thïꞌrïkothe paponte nan akin ennekke thokwit thorok irapangka akin iat thukwit thekkot uꞌricil arrial wꞌrakkuruk (120) uo thoꞌronthong. Ana papotteik akin appennekkekat akin iat thukwit thothakkat uꞌricil arrial wocoꞌrin ana alkaire (90) uo thoꞌronthong. ");
INSERT INTO lmd_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Ana okin thipathe nꞌre akka kuppuꞌrung konoiꞌri ee ka muꞌrol iꞌri ana nthoceken cokuppuꞌrung konoiꞌri akin orpekat paponte ipaceꞌre kuppuꞌrung irok wocoꞌrin akin aꞌrakanthet Kapik ngaꞌrama itti acïngkï ua. ");
INSERT INTO lmd_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Aul iallillie kuppuꞌrung konoiꞌri iꞌrekat itti wura akin orpekat kuppuꞌrung konoiꞌri ikotte iiꞌri akin innikot itti okin thathorpet aꞌrponte cik iaceꞌre kuppuꞌrung konoiꞌri irok irapangka ikrïk ntokït. ");
INSERT INTO lmd_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Anaruk oPoluc piꞌrekathe ili woul arrial ukuluk irro ana ul iallillie kuppuꞌrung itti, “Amma ul iallillie kuppuꞌrung konoiꞌri wella ikuppuꞌrung cene ana oron thannoꞌrettat.” ");
INSERT INTO lmd_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Menik aul irro ommothat loꞌrak iloccokothe kuppuꞌrung konoiꞌri ikotte cik akin okorronnat akapot iiꞌri. ");
INSERT INTO lmd_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Anakka cik cokat carthuk okatto oPoluc piꞌrekathe ul itti waꞌrkoik akwiꞌrekat itti, “Nomaꞌri attul ana ikken kocoꞌrin onon thokat thellat mïkït ikarak ana nthoꞌrungkathe ntï, nthannoꞌrkkat pꞌrek aththik. ");
INSERT INTO lmd_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Ineni mpiꞌret non itti ngonon oꞌrko thuꞌrit thotte. Nthonu itti nthaꞌrko annokkoik. Pul pella pio ka kongo aththik.” ");
INSERT INTO lmd_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Anakka kwerenet kin lon elli kwonekathe arrakith akwaꞌrakanthet Kapik ngaꞌrama tokït ken akwomithat tit akwikkat cik akwoꞌrko aꞌrek. ");
INSERT INTO lmd_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Okin appik thopoꞌriettakathe than akin oꞌrkkat thuꞌrit ngka ken. ");
INSERT INTO lmd_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Onïn ithokat ikuppuꞌrung konoiꞌri maun arrial ukuluk maꞌri meꞌra ana ikken arrial wꞌrapuruk ana alkaire ana ikken kꞌrakkuruk (276). ");
INSERT INTO lmd_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Anakka okin thoꞌrkot thuꞌrit mono omanakat, okin thoorrekathe mïl irok irapangka nti ikuppuꞌrung konoiꞌri akothakka kippappat. ");
INSERT INTO lmd_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Anakka cïngkï cuat aul iallillie kuppuꞌrung konoiꞌri ommakat kaꞌran nakin okko anaruk akka okin thimmat carkan cotteik akin iꞌrekat itti okin thathïot kuppuꞌrung konoiꞌri nan amma okin akkathïo. ");
INSERT INTO lmd_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Akin okeccekat loꞌrak ilonat aꞌrponte nan thoꞌronthong irok irapangka akin oththekat nan irok irapangka. Okin thokellekathe loꞌrak ilïꞌrïkot kwoꞌren ikaprtto kuppuꞌrung amma okin ollillie. Okin thonthathe kret kapik ikallillie kuppuꞌrung konoiꞌri ngkanang akin oprttat eo ngngin tocarakan. ");
INSERT INTO lmd_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Anaruk kuppuꞌrung keekathe ca ncarkan cokamur akommakat eo. Ana cuꞌre cen cikkatheik acocotta akka thopangka thoiꞌri thokat cik athokkwe cannan. ");
INSERT INTO lmd_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Ana ul irro wiꞌrekathe itti wangwo ul worikorrkkor akka aththouththa aeo tomarakan apelle. ");
INSERT INTO lmd_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Anaruk ili woul arrial ukuluk irro wawongothe itti wakkie oPoluc cik ana kwoceꞌrekathe ul irro nolon len. Kwiꞌrekathe itti okkwion ithina oththouththa akin irrot tomarakan tokït. ");
INSERT INTO lmd_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Ana opilingon omakittot kin nouruthut ana nomprak wokuppuꞌrung ikokïttakot. Ittina okin thoingkathe appik tomarakan. ");
INSERT INTO lmd_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Manakka onïn thaat tocarakan appik thoporot, apilin iꞌrekat nïn itti cik iconthomat corithoꞌrikït thorok irapangka coccot kꞌran itti Malththa. ");
INSERT INTO lmd_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Aul wonocik cen okkanthet nïn lon loporot anganna, okin thikkiet nïn cik ana okin thokwanthet nïn thik akka kapik kokat cik akapo ana cik cokat cik cirruk. ");
INSERT INTO lmd_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Anakka oPoluc pokat cik akwaꞌrntot oꞌren akworret ithik alü okïccekat pinyil apapꞌrilakat nokkun apokꞌrathok. ");
INSERT INTO lmd_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Anakka ul woncik iconthomat corirok irapngka cen wimmat pinyil apapꞌrilako nokkun woPoluc akin erettaranthet itti, “Pul empi paththoka ipangwo ul akka amma kwokkot cik nti irok irapangka anaruk lon lothonceꞌret lon cik lannokorronnok.” ");
INSERT INTO lmd_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Anaruk oPoluc pokkwathe pinyil nokkun apapat ithik aloꞌrek ellakat ilainok. ");
INSERT INTO lmd_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Okin thokat akin oꞌrïkothok itti kwaththakat cik ana manna itti kwapot nocapu piot anakka okin thoꞌrïkothe cik ittaꞌrene puccuk mono okathakat itti loꞌrek lella akin oprttat lon len cik nak akin iꞌrekat itti kapik engki. ");
INSERT INTO lmd_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Cïnang nocik cen oPappilioc ili wonocik cen wonat lampang napuththut. Kwikkiekathenïn cik maꞌri mꞌrapuruk akwokkinthet nïn lon loporot. ");
INSERT INTO lmd_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Ana oththan poPappilioc pappokat noppan pongo ana kwokat akwangko ippa ana opre. APoluc iꞌrikathok noppan akwonekkekat nyaun naak akwaꞌrakat ngaꞌrama akwothakkakat poporot. ");
INSERT INTO lmd_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Anakka oPoluc pokkothe menik aul akkakanthok iongo wonocik iconthomat corirok irapngka cen appik akwittiet kin. ");
INSERT INTO lmd_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Okin thopiriet nïn noka ngkathar koppot, anakka onïn thokat anïn uroko pꞌrïn, okin thipanthet nïn aꞌrupu ikuppuꞌrung konoiꞌri ianïn thongothe. ");
INSERT INTO lmd_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Anakka anok wothakkat wꞌrapuruk onïn tharrathe kuppuꞌrung konoiꞌri ikokkwothe cpo cinang nocik coMalththa. Kuppuꞌrung ken kokat koIcikkantharia ana tokït kokuppuꞌrung kwoꞌren kꞌrek kokat cik kokkattathe ere kapik ikokat laro ithonat ꞌran itti oKkacththo ana oPolluk. ");
INSERT INTO lmd_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Ana onïn thorpatheik nokaꞌran koCarakkoc anïn ikkat cik nan maꞌri mꞌrapuruk. ");
INSERT INTO lmd_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Anïn urokat nthan anïn eo omakot carkan corok mono anïn akkakat nokaꞌran koRikion noththok poIththalia ana ngorrot ngen akanang akkakat nthokkun wothothari amma akatha na acïngkï ummot ngngin ïnnakkakat nokaꞌran koPuththuli nocaꞌri culukku. ");
INSERT INTO lmd_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Onïn thiathe ul ioccokothe lon loIeccuo wꞌrek than akin omekat nïn itti onïn thikkoik nakin maꞌri meꞌreꞌrapuruk. Ittina onïn thakkakathe nokaꞌran koRoma. ");
INSERT INTO lmd_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Ana ul ioccokothe lon loIeccuo woccïkathe nokaꞌran koRoma itti onïn thaat ana okin thakkakathe thapat noththok akin othocurot ianïn nokaꞌran kApiuc ikokat kaꞌran kokeccuk. Opilingon thaththiat nïn nokaꞌran koccot kꞌran itti Aꞌran Wꞌrapuruk Ikkakoik tit. Ana akka oPoluc pimmat kin kwopirakanthet Kapik noka ana kwopoꞌriettakathe than. ");
INSERT INTO lmd_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Anakka onïn thaat nokaꞌran koRoma akin ikkiekat oPoluc cik nokaꞌran pellek ana pul pꞌrek angwothok othakka itti akka akura. ");
INSERT INTO lmd_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Anakka maꞌri mꞌrapuruk meot ncik, oPoluc pakkarathe ul woIouth ittïttïk. Anakka okin thaꞌrntakothe tothun, aPoluc iꞌrekat kin itti, “Pangkingon, antoka manna itti mpannokkinthet ul wonnon lon lꞌrek lokithak aththik ana manna thathuma thothiki itheot thonnon anaruk ul woIouth woccokothin nokaꞌran koUruccelim ana okin thethin ul woRoma ikkun. ");
INSERT INTO lmd_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Okin thokathaccet ilon lin ana okin thomekathe itti okin thel