﻿USE sofia;
DROP TABLE IF EXISTS sofia.llu_vpl;
CREATE TABLE llu_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES llu_vpl WRITE;
INSERT INTO llu_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Talisibaralaa sulia aebara na Jesus Christ e futa mai faasia. Nia futa mai ana aebara a David na aaofia na e futa mai ana aebara a Abraham. ");
INSERT INTO llu_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Haia, talisibaralaa na nia lea sulia bali nia wane hafali mai ana Abraham. A Abraham wela nia na a Aesak, a Aesak wela nia na a Jakob, a Jakob wela nia na a Juda fai nia teni haasi ana gi. ");
INSERT INTO llu_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Haia, a Juda wela nia gi na a Peres fai nia ni Sera. (Tee daaro hatana ni Tama.) Haia, a Peres wela nia na a Hesron, a Hesron wela nia na a Ram. ");
INSERT INTO llu_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","A Ram wela nia na a Aminadab, a Aminadab wela nia na a Nason, a Nason wela nia na a Salmon. ");
INSERT INTO llu_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","A Salmon wela nia na a Boas, haia tee nia hatana ni Rahab. A Boas wela nia na a Obed, haia tee nia hatana ni Rut. A Obed wela nia na a Jesi. ");
INSERT INTO llu_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","A Jesi wela nia na a David na aaofia gera Israel. A David wela nia na a Solomon, haia tee nia afe baa a Iuraea i nao. ");
INSERT INTO llu_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","A Solomon wela nia na a Rihoboam, a Rihoboam wela nia na a Abaeja, a Abaeja wela nia na a Asa. ");
INSERT INTO llu_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","A Asa wela nia na a Jehosafat, a Jehosafat wela nia na a Joram, a Joram wela nia na a Iusaea. ");
INSERT INTO llu_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","A Iusaea wela nia na a Jotam, a Jotam wela nia na a Ehas, a Ehas wela ni a Hesekaea. ");
INSERT INTO llu_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","A Hesekaea wela nia na a Manase, a Manase wela nia na a Emon, a Emon wela nia na a Josaea. ");
INSERT INTO llu_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","A Josaea wela nia na a Jekonaea fai nia teni haasi ana gi na gera futa i nao suifetei na maalimaea gera gi da ngalia tooa i Israel fui fera i Babilon. ");
INSERT INTO llu_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Si kada tooa Israel da too na i Babilon naa, Sialtiel wela a Jekonaea kafi futa. Haia, Sialtiel wela nia na a Serababel. ");
INSERT INTO llu_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","A Serababel wela nia na a Abaeud, a Abaeud wela nia na a Elaeakim, a Elaeakim wela nia na a Aso. ");
INSERT INTO llu_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","A Aso wela nia na a Sadok, a Sadok wela nia na a Akim, a Akim wela nia na a Eliud. ");
INSERT INTO llu_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","A Eliud wela nia na a Elaesa, a Elaesa wela nia na a Matan, a Matan wela nia na a Jakob. ");
INSERT INTO llu_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","A Jakob wela nia na a Josef aarai ni Mary tee nia Jesus na gera alangia laugo ana Christ, sulia nia naa na wane a God e filia uria aaofialaa. ");
INSERT INTO llu_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Haia, hafali mai ana Abraham lea mai ka dao ana David na aaofia, aakwala ma fai uunita wane. Sui ka hafali mai ana David na aaofia lea mai ka dao ana si kada baa maalimaea gi da ngalia tooa i Israel gi fui Babilon, ta aakwala ma fai uunita wane. Haia, sui ka hafali ana si kada tooa Israel da lea fui Babilon lea mai ka dao ana si kada Christ nia futa, ta aakwala ma fai uunita wane lau. ");
INSERT INTO llu_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Na futalana mai a Jesus Christ e urii: Si kada gera aalu faafia ni Mary na tee nia a Jesus fuana a Josef, ma e langi daaro si too oogu ua, ni Mary ka haitamana nia e iiana naa sulia na Aanoedoo Aabu. ");
INSERT INTO llu_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ma a Josef, na wane na da aalu faafia fuana, nia ka manata uria ka lugatai nia, sulia ni nia na wane oꞌolo. Sui ka oote nia ana faaꞌidalana, ma ka manata uria ka lugatai aagwalaa ana. ");
INSERT INTO llu_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Sui si kada nia e manata ua go ana sulia si doo nae gi, na ensel a Lord e faatai fuana i laona teo bolelaa ka urii, <<Josef ae, oe wane ana aebara a David, osi mou ana aadelana ni Mary uria na afe oe. Sulia ni nia e iiana sulia na Aanoedoo Aabu. ");
INSERT INTO llu_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ma nia tara ka faafutaa tee wela wane, ma ni oe oko alangia ana a Jesus (na malutana <Faamouri>), sulia ni nia tara ka faamouria na tooa nia gi faasia na aade taꞌalaa gera gi.>> ");
INSERT INTO llu_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ma si doo naa gi e fuli hai ka faamamanaa si doo baa gi a Lord e faarongoa mai ana, si kada na profet baa e bae urii, ");
INSERT INTO llu_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","<<Tee haari tara ka iiana ma ka faafutaa tee wela wane, ma daka alangia ana a Emanuel.>> Haia, si malutana hata nae: <<A God e too fai gia.>> ");
INSERT INTO llu_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ma si kada a Josef e aada, nia ka iili naa sulia si doo nae gi na ensel a Lord e haeda fuana. Ma nia ka aadea ni Mary. ");
INSERT INTO llu_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Sui taa, daaro si too oogu ua go lea ka dao ana si kada ni Mary e faafutaa tee wela wane. Ma a Josef ka alangia ana a Jesus. ");
INSERT INTO llu_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ana si kada a Herod e aaofia ana naa, a Jesus ka futa i Betlehem, na fera i laona na lolofaa i Judea. Ma e langi si tau go i buira, teni wane gi faasia i taelana hato na da haitamana na bubulu gi, gera ka dao mai i laona na fera baita i Jerusalem. ");
INSERT INTO llu_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ma gera ka ledi ma daka urii, <<Nia fai na wela baa e futa ma tara ka hau ana aaofia gera na Jiu gi? Sulia si kada gemelu too ua mai i taelana hato, melu ka rikia naa fe bubulu ana na mamalafooa ana futalana mai, ma melu ka lea mai uria na boururulaa usia.>> ");
INSERT INTO llu_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ma si kada a Herod na aaofia e rongoa si doo nae, na manatana ka langi si diana sulia, ma na tooa i Jerusalem gi laugo. ");
INSERT INTO llu_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ma nia ka soea na fataabu baita gi ma na wane faatolomai gi ana kwaieresia gi, fuana daka oogu mai, ma nia ka ledi gera urii, <<I fai naa na Christ baa tara ka futa mai ana?>> ");
INSERT INTO llu_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ma gera oolisia daka bae urii, <<I Betlehem baa, na fera laona lolofaa i Judea. Sulia na kekedelaa profet urii, ");
INSERT INTO llu_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","<Betlehem ae, na fera laona lolofaa i Juda, ni oe langi osi toꞌou i matangana fera naonao gi i Juda, sulia tee wane baita tara ka lea mai faasi oe, eeri ka talaia na tooa nau gi i fera Israel.>>> ");
INSERT INTO llu_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ma a Herod ka soea mai na wane dao nae gi faasia taelana hato uria na bae aagwalaa, ma ka daotoona si kada taa na da rikia ana fe bubulu baa. ");
INSERT INTO llu_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ma nia ka oodu gera kou fui Betlehem, ka bae urii, <<Molu lea, molu ka nani tatangai uria na wela naa. Ma lea molu ka daotoona, molu ka faarongo nau mai, eeri ni nau laugo kuka lea uria boururulaa usia.>> ");
INSERT INTO llu_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Ma i buira a Herod e bae urinae sui, gera ka lea na ada. Ma ana si kada gera dao sulia na tala, gera ka rikia lau fe bubulu baa daka rikia laugo mai i taelana hato. Gera ka eele asianaa ana si kada gera rikia ana. Ma fe bubulu naa ka eeta i nao ada lelea ka mamalo i ootofana na gula baa a Jesus e teo ana. ");
INSERT INTO llu_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Gera ruu i luma, ma daka rikia na wela fai nia ni tee nia ni Mary. Gera boururu usia na wela nae, ma daka ifingia na wai gera gi, ma daka falea si falelaa gi fuana: si malefo, ma na ai initoo na hasuna e moko diana, ma na gwai moko diana gi. ");
INSERT INTO llu_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Sui gera ka ooli na ada sulia ta tala eꞌete uria fera gera, sulia a God ka bae fifii fuada i laona teo bolelaa, ma ka haea langi dasi ooli lau siana a Herod. ");
INSERT INTO llu_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ma i buira na wane nae gi da ooli na ada fui fera gera, na ensel a Lord ka faatai fuana a Josef i laona na teo bolelaa, ma ka bae urii, <<Josef ae, o tatae, oko ngalia na wela naa fai nia ni tee nia, molu ka tafi uria i Ejipt, ma molu ka too mai i seenae lea ka dao ana si kada nau ku haea molu ka ooli lau mai. Sulia a Herod e nani uria na wela naa eeri ka haungia ana.>> ");
INSERT INTO llu_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ma a Josef e tatae ma ka ngalia na wela fai nia ni tee nia ni Mary, ma daalu ka lea laona rodo uria maefera i Ejipt. ");
INSERT INTO llu_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ma gera too i seenae lea a Herod ka mae. Si doo nae e faamamanaa si taa baa a Lord e haea fuana na profet baa ka bae urii, <<I nau ku soea mai na Wela nau faasia i Ejipt.>> ");
INSERT INTO llu_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ma si kada Herod na aaofia e haitamana wane nae gi na da lea mai faasia taelana hato da malaꞌoe nia, na rakena ka hasu asianaa. Ma nia ka falea baelana fuana wane ni oomea nia gi hai daka haumaeli teefou ana gala wela wane gi i Betlehem ma ana maefera galigalia gi sui. Nia eeresida hasa daka haungia gala wela wane na langi dasi dao ua ana roo fe ngali, iilingia si baea baa na wane baa gi sulia si kada fe bubulu e faatai ana. Manatana a Herod hasa nia tara ka haungia a Christ ana si iililaa urinae. ");
INSERT INTO llu_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Nia urinae hai ka faamamanaa si taa baa a Jeremaea na profet nia haea ua na mai ka bae urii, ");
INSERT INTO llu_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","<<Gera rongoa lingeena si doo nae lea mai faasia na fera i Rama, na lingeena suungimaea baita, sulia ni Rasel e aangisia gala wela nia gi. Si kada nia e aangi ana, e langi so ta wane ka faabona nia, sulia na wela nia gi da mae teefou.>> ");
INSERT INTO llu_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ma i buira a Herod e mae naa, na ensel a Lord ka faatai lau i laona teo bolea fuana a Josef i Ejipt, ");
INSERT INTO llu_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ma ka bae urii, <<Josef ae, o tatae oko ngalia na wela fai nia ni tee nia ni Mary, molu ka ooli naa uria i Israel, sulia na tooa baa da hasi uria na haungilana na wela naa, da mae naa.>> ");
INSERT INTO llu_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ma a Josef e tatae ma ka ngalia na wela fai nia ni Mary na tee nia, ma gera ka ooli naa uria i Israel. ");
INSERT INTO llu_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Sui si kada a Josef e rongoa a Akilas e talana na maa nia a Herod ana aaofialaa i Judea, nia ka mou ana toolaa i seenae. Ma na ensel ka bae lau fuana i laona na teo bolelaa, hai gera ka lea ada uria na lolofaa i Galili. ");
INSERT INTO llu_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nia na gera ka too i fera Nasaret i laona lolofaa naa i Galili. Haia, ka faamamanaa si taa baa na profet baa gi da haea urii, <<Tara daka alangia ana na wane faasia i Nasaret.>> ");
INSERT INTO llu_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ma ana si kada nae, a John Siuabu e dao mai, ma ka hafalia na funaolaa i laona na aanogwou i Judea ka bae urii, ");
INSERT INTO llu_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","<<Muka oolitai manata faasia na aade taꞌalaa gamu gi, sulia na Initooa i Langi e dao garangi naa.>> ");
INSERT INTO llu_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","A John naa na wane baa a profet Aesea e bae mai sulia ka urii, <<Tee wane e rii i laona na aanogwou ka urii, <Na Lord e dao! Muka aade aagau ana na tala maasi nia, ma muka olosia na tala fuana.>>> ");
INSERT INTO llu_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","A John e oofi ana na maku ana iifuna doo fai ae na da alangia ana na kamel, ma ka kania na kakabe ana ungana bulumakau i liitana, ma na fanga nia na siko gi ma na wewedua. ");
INSERT INTO llu_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ma na tooa oro gi daka lea mai siana faasia na fera baa i Jerusalem ma na fera gi sui i laona lolofaa i Judea ma faasia na fera gi sui garangia na kafo i Jodan. ");
INSERT INTO llu_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ma gera ka faarongo ana si aade taꞌalaa gera gi, ma nia ka siuabu gera i laona kafo i Jodan. ");
INSERT INTO llu_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ma si kada a John e rikia na wane oro ni Farisi gi ma na Sadusi gi da lea laugo mai siana hai nia ka siuabu gera, nia ka bae fuada ka urii, <<I gamu mu iilingia go agamu na loi gi! Ni tei naa e haea muka bobola uria tafilaa faasia na kwakwaelaa na a God tara ka falea e garangi dao na? ");
INSERT INTO llu_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Muka iilia si doo gi na ka faatainia gamu mu oolitai manata mamana naa faasia na aade taꞌalaa gamu gi. ");
INSERT INTO llu_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ma langi musi manata urii i laona lio gamu gi, <I gami naa na tooa mi futa mai ana kwalafaa a Abraham naa. Afetai ta kwakwaelaa faasia God ka dao ani gami.> Haia, i nau ku haea fuagamu, a God e bobola go ana fai nia ka ngalilana na fou na gi ma ka haungainia ana kwalafaa a Abraham gi! ");
INSERT INTO llu_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ana si kada naa, God e aade aagau naa uria kwakwaelaa, iilingia ta wane baa e dau ana matau ma ka aade aagau uria na tabalilana ai gi. Ma na ai gi sui go na langi dasi fusia ta fufue ai diana gi, tara nia ka tabalida ma ka ui anida i laona eere. ");
INSERT INTO llu_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","<<Nau ku siuabu gamu ana kafo hai ka faatainia i gamu mu oolitai manata naa faasia na aade taꞌalaa gamu gi. Haia, ma tee wane aai na e lea mai burigu, tara nia ka siuabu gamu ana na Aanoedoo Aabu ma ana eere. Ma i nia e baita ka tasa liufi nau, ma i nau langi kusi diana bobola fai nia na ngalilana na tae silipa nia gi. ");
INSERT INTO llu_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ma nia e aade aagau uria na ketolana tooa gi sui, iilingia ta wane baa e tagalangainia na mige doo diana gi faasia na ungedoo gi. Ma i nia ka oogua na mige doo diana gi i laona beu nia ni taingailaa. Ma na ungedoo gi, nia ka suungida i laona na eere na e totoo si mae.>> ");
INSERT INTO llu_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ana si kada nae, a Jesus e lea mai faasia i Galili uria kafo i Jodan siana a John hai a John ka siuabu nia. ");
INSERT INTO llu_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ma a John ka iili uria na bulasilana na manatana a Jesus, ka urii, <<E bobola fai nia ni oe na oko siuabu nau, ma oko lea mai taari amu siagu uria kuka siuabu oe nae.>> ");
INSERT INTO llu_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ma a Jesus e oolisia ka bae urii, <<Boroi ana, o iilia fasi mai amu si doo naa fuagu. Sulia ana iililana si doo naa, goro ka iilia doo gi sui na a God e dooria.>> Ma a John ka aala naa faafia. ");
INSERT INTO llu_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ma ana si kada a Jesus e siuabu sui, nia ka tatae mai faasia i kafo. Ma i langi ka ifi fuana, ma nia ka rikia na Aanoedoo a God e sifo mai iilingia fe bola ma ka oo i fafona. ");
INSERT INTO llu_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ma si lingee doo faasia i langi ka bae urii, <<I nia naa na tefe Wela nau. I nau ku rakediana ani nia, ma kuka eele asianaa suli nia.>> ");
INSERT INTO llu_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","I buira na doo naa, na Aanoedoo Aabu e talaia a Jesus uria aanogwou hai a Satan ka iilitoona. ");
INSERT INTO llu_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ma a Jesus e aabu fanga sulia fai aakwala fe dani gi ma fai aakwala fe rodo, ma nia ka fiolo asianaa. ");
INSERT INTO llu_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Seenae, a Satan ka lea mai siana, ka bae urii, <<Lea so ni oe na Wela a God, oko haea fuana na fou naa gi ka hau ana beredi.>> ");
INSERT INTO llu_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ma a Jesus e oolisia ka urii, <<Na Kekedelaa Aabu e haea, <E afetai fuana na wane so ka mouria ana si fanga go ana taifilia. Sulia nia ka mouri naa mone ana si baea gi sui na a God e haeda.>>> ");
INSERT INTO llu_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Sui a Satan ka ngalia lau a Jesus uria i gwouna Beu Aabu nia a God i fera aabu i Jerusalem. ");
INSERT INTO llu_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ma ka bae urii fuana, <<Lea so ni oe na Wela a God, oko lofo i hae gano, sulia na Kekedelaa Aabu e bae urii, <A God ka oodua mai na ensel nia gi siamu, ma gera ka hako oe ana abada, hai so na aemu gi boroi kasi fotongai ana ta fou.>>> ");
INSERT INTO llu_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ma a Jesus e oolisia ka urii, <<Ma na Kekedelaa Aabu e bae urii laugo, <E langi osi iilitoona a Lord na God oe.>>> ");
INSERT INTO llu_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Sui a Satan ka ngalia lau a Jesus uria i gwouna tefe tolo e fane asianaa, ma ka faatainia na initooa gi sui ana molaagali ma na babaitaa fuana a Jesus. ");
INSERT INTO llu_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ma a Satan ka bae urii, <<Na doo naa gi sui go kuka faleda fuamu lea so oko boururu i maana aegu.>> ");
INSERT INTO llu_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ma a Jesus e oolisia ka urii, <<Satan ae, o lea tau amu faasi nau! Sulia na Kekedelaa Aabu e haea, <Tee taifilia a Lord God oe go na oko fooasia ma oko rao fuana.>>> ");
INSERT INTO llu_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Sui ana si kada nae, a Satan ka lea naa faasia a Jesus. Ma na ensel gi daka lea mai, ma daka adomi nia naa. ");
INSERT INTO llu_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Si kada a Jesus e rongoa gera aalua naa a John i laona na beu ni kanilaa, nia ka lea fuana Galili. ");
INSERT INTO llu_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Haia, nia kasi too i laona fera nia i Nasaret. Nia e lea, ka too ana i Kapaneam, na fera i ninimana na aasi i Galili, ana na lolofaa i Sebulun ma i Naftali. ");
INSERT INTO llu_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Nia e iili urinae eeri ka faamamanaa na baelana profet Aesea baa e urii, ");
INSERT INTO llu_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","<<Na fera Sebulun ma na fera Naftali na e too sulia tala fuana aasi ma ka too ta bali ana kafo i Jodan i Galili, na tooa maadiu gi da too ana. ");
INSERT INTO llu_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Na tooa gi na gera too laona na rorodoa, tara daka rikia raralaa baita. Haia, ni tei gera na gera too i laona na fera rorodoa ana maea, na raralaa ka talafi gera.>> ");
INSERT INTO llu_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ita ana si kada nae, a Jesus ka ainitalo ana faarongolaa nia ka urii, <<Muka aabulo faasia na aade taꞌalaa gamu gi, sulia na Initooa i Langi e dao garangi naa!>> ");
INSERT INTO llu_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ana si kada a Jesus e liliu sulia na aasi i Galili, nia ka rikia a Simon (na e alangia ana a Peter) fai nia a Andrew na haasina. Daaro dee adaaro ana moge daaro i laona na aasi sulia daaro na roo wane da dedee gi. ");
INSERT INTO llu_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ma a Jesus ka bae urii fuadaaro, <<Moro lea mai fai nau, ma kuka faatolomai gomoro ana deelaa uria tooa gi hai so i gera laugo daka manata mamana ana a God.>> ");
INSERT INTO llu_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ma ana si kada nae ua go, daaro ka tafusia na adaaro na moge daaro gi, ma daaro ka lea na adaaro fai nia. ");
INSERT INTO llu_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Sui a Jesus e lea lau kou ma ka rikia lau ta roo wane gi lau, a James ma a John na roo wela a Sebedi gi. Daaro too adaaro i laona na baru fai nia maa daaro a Sebedi, ma gera kauraa na furai gera gi. A Jesus ka soe daaro. ");
INSERT INTO llu_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ma ana si kada nae ua go, daaro ka tafusia na adaaro na baru fai nia na maa daaro, ma daaro ka lea na adaaro fai nia a Jesus. ");
INSERT INTO llu_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","A Jesus e liufia na fera gi i laona lolofaa i Galili, ma ka faatolomainia na tooa gi laona na Beu Aabu ni figulaa gera Jiu gi. Ma nia ka ainitalo ana na Faarongolaa Diana sulia na Initooa a God, ma ka guraa na tooa gi na da mataia ana mataia eꞌete gi sui na e haungi gera. ");
INSERT INTO llu_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ma na uunuunulaa gi sulia a Jesus ka talofia fera gi sui i laona lolofaa i Siria, ma tooa oro gi na da matai ana mataia eꞌete oro gi daka ngalida mai siana. Na tooa gi na aagalo taꞌa gi e kwaeda, ma tooa gi na aeda ka mae, ma na tooa gi na da uura, gera lea mai siana. Ma Jesus ka gurada teefou. ");
INSERT INTO llu_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ma na tooa oro asianaa laugo daka lea sulia Jesus ana si kada nae. Tooa faasia Galili, Dekapolis, Jerusalem, Judea, ma faasia na bali aai ana kafo i Jodan. ");
INSERT INTO llu_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Si kada a Jesus e rikia na figua baita, nia ka raa i gwouna fe tataea, ma ka gwouru i hae gano. Ma na oote fafurongo nia gi daka figu galia, ");
INSERT INTO llu_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ma nia ka hafalia na faatolomailada, ka urii, ");
INSERT INTO llu_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","<<Oilakea fuada tooa na da haitamana gera siofaa i maana a God, sulia na Initooa a God na doo gera. ");
INSERT INTO llu_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","<<Oilakea fuada tooa na da liobukonu, sulia a God tara ka falea na eelelaa fuada. ");
INSERT INTO llu_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","<<Oilakea fuada tooa na da faatoꞌou gera i talada, sulia tara daka ngalia si doo na a God e bae aalualu ana. ");
INSERT INTO llu_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","<<Oilakea fuada tooa na da dooria asianaa iililaa na oꞌoloa, sulia a God ka kwaiꞌadomi gera iililaa. ");
INSERT INTO llu_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","<<Oilakea fuada tooa na da rakediana fuana tooa eꞌete gi, sulia a God tara ka rakediana laugo fuada. ");
INSERT INTO llu_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","<<Oilakea fuada tooa na da folaa i lioda, sulia tara gera ka rikia God. ");
INSERT INTO llu_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","<<Oilakea fuada tooa na da rao uria na fanualama i matangana tooa, sulia a God tara ka alangi gera ana na wela nia gi. ");
INSERT INTO llu_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","<<Oilakea fuada tooa na da nonifii sulia na iililana si doo oꞌolo gi, sulia na Initooa a God na doo gera. ");
INSERT INTO llu_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","<<Oilakea fuagamu, si kada na tooa gi da suge faafi gamu ma daka kwalangai gamu ma daka maalimae gamu, sulia gamu naa fafurongo nau gi. ");
INSERT INTO llu_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Muka noni hahala ma muka eele agamu, sulia a God tara ka falea si kwaiaraa baita na e taingainia fuagamu i langi. Sulia gera maalimaea laugo na profet baa gi i nao.>> ");
INSERT INTO llu_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","A Jesus e tasa dongaa ana baelana ka urii, <<Na aasi naa e faamamasia na fanga fuagamu. Haia, ma ni gamu laugo muka iilingia na aasi uria faadianalana na tooa gi sui. Ma lea so na mamasialana na aasi naa ka langi faasia ana, e afetai hasa tesi doo hai so ka faamamasia lau. Ma ka langi si diana naa uria iililana lau ana tesi doo, ma nia diana fuana muka ui ania naa agamu i maa, eeri na tooa gi daka fali na ada i fafona. ");
INSERT INTO llu_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","<<I gamu mu iilingia laugo na laeta fuana na tooa gi sui. Na luma gi na da tolea i gwouna fe tataea e afetai ka aagwa. ");
INSERT INTO llu_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","E langi ta wane si faaharua na kwesu, sui ka aalua ana i farana na teu. Ma nia e ngalia, ka kulua taari ana si gula i langi, hai ka tala fuana na tooa gi sui i laona na luma. ");
INSERT INTO llu_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ma ka urinae laugo, na laeta gamu ka rara i nao ana na tooa gi sui eeri ana si kada gera rikia na doo diana gi na mu iilia, gera kafi baelafea na Maa gamu na e too mai i langi. ");
INSERT INTO llu_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","<<E langi musi manata hasa ni nau ku lea mai uria na faasuilana na kwaieresia nia gi a Moses ma na faatolomaia gera na profet gi. I nau kusi lea mai uria na faasuilada, ma ku lea mai taari uria na faamamanalana na faatolomaia gera nae gi. ");
INSERT INTO llu_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Muka manatatoona si doo naa, si kada na i langi ma na molaagali da too ua, langi tesi doo toꞌou ana na Kwaieresia gi kasi sui lea ka dao ana si kada na doo gi sui ka sui. ");
INSERT INTO llu_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Nia naa, so ni tei naa e langi si roosulia ta kwaieresia toꞌou, ma ka toolamainia teni wane daka iili sulia, tara a God ka aalu nia ana si gula iꞌisi ana na Initooa i Langi. Ma ni tei na ka roosulia na kwaieresia gi ma ka toolamainia fuana teni tooa gi uria na roosulilana iilingi nia, tara i nia ka baita i laona na Initooa i Langi. ");
INSERT INTO llu_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","I nau ku haea fuagamu, lea gamu langi si iilia diana liufia na wane faatolomai gi ana kwaieresia gi ma na Farisi gi ana iililaa sulia si doo gi a God e dooria, e afetai muka bobola fai nia na ruulaa laona na Initooa i Langi. ");
INSERT INTO llu_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","<<I gamu mu rongoa sui na si doo na da haea fuada na koo gia gi i nao baa e urii, <Langi osi hau wane. So ni tei na e hau wane, tara gera ka ngali nia i naona na wane ni keketolaa.> ");
INSERT INTO llu_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Haia, si kada naa, ni nau ku haea fuagamu, so ni tei na e rakehasuia na haasina, tara gera ka ngali nia i naona na wane ni keketolaa. Ma ni tei na ka haea fuana na haasina, <Ni oe na doo tatagwai go ana>, tara gera ka ngalia i naona na wane ni keketolaa gi. Ma ni tei na ka alangia na haasina ana, <Na doo nue>, tara i nia ka lea oto i laona na eere na langi kasi mae. ");
INSERT INTO llu_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Nia naa, lea so o aade aagaua na ana si falelaa oe fuana a God i fafona na fuliere, sui ma oko manatatoona langi kasi folaa ua i matanga moro haasimu sulia na garolaa oe, ");
INSERT INTO llu_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","o tafusia si falelaa oe i nao na fuliere, sui oko ooli ma oko bae kwaimaani fasi fai nia. Sui i buri, ofi ooli mai ma ofi falea si falelaa oe fuana a God. ");
INSERT INTO llu_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","<<Ma lea so ta wane ka ngali oe i naona na wane ni keketolaa faafia tesi doo, oko bae kwaimaani fasi fai nia, si kada langi moro kasi dao ua. Sulia lea moro dao naa, nia tara ka fale oe na ana fuana na wane ni keketolaa, ma i nia ka fale oe lau fuana na wane polis, ma i buira gera ka aalu oe i laona na beu ni kanilaa. ");
INSERT INTO llu_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","I nau ku haea fuamu, tara oko too i seenae lea ka dao ana si kada oko duu teefou na ana na duulaa oe gi. ");
INSERT INTO llu_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","<<I gamu muka rongoa sui si doo da haea, <E langi osi ooe.> ");
INSERT INTO llu_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Haia, si kada naa, i nau ku haea fuagamu, so ni tei na e bubungia ta geni ana si lio ni ooelaa, i nia e ooea sui naa i liona. ");
INSERT INTO llu_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Nia naa, lea na bali maa aaolo oe e faagaro oe, lafua oko ui ania amu faasi oe. Sulia nia tee diana fuamu hai oko ui ania na bali ana na nonimu, aata gera ka ui ania na nonimu loulou i laona na eere ana na gula ni maea. ");
INSERT INTO llu_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ma lea na bali aba aaolo oe e faagaro oe, oko lafua ma oko ui ania amu faasi oe. Sulia tee diana hai oko ui ania na bali ana na nonimu, aata gera ka ui ania na nonimu loulou i laona na eere ana na gula ni maea. ");
INSERT INTO llu_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","<<Ma gera haea laugo mai i nao, <So ni tei ka lugasia na afe nia, nia ka falea na kekedelaa ana na kwailugasilaa fuana.> ");
INSERT INTO llu_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Haia, si kada naa i nau ku haea fuagamu, lea so ta geni afe e langi si ooe, sui ma na aarai nia ka lugasia, ma geni naa ka too wane lau, na aarai nia baa i nao e falea na garolaa ana ooea fuana. Ma na wane aai naa e aadea e ooea naa laugo. ");
INSERT INTO llu_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","<<I gamu muka rongoa laugo na doo na da haea fuada na tooa gi i nao ua na mai, <E langi osi aaburongo na bae aalualu oe, oko iilia si taa na o aalafuu ana uria na iililana fuana na Lord.> ");
INSERT INTO llu_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Haia, si kada naa, i nau ku haea fuagamu, langi osi aalafuu ana si kada o bae aalualu ana. Ma langi osi kwaiagi ana i langi, sulia nia naa si gula ni gwourua a God na Aaofia. ");
INSERT INTO llu_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ma osi kwaiagi ana molaagali, sulia nia naa si gula a God ni aalulana ana na aena. Ma osi kwaiagi ana Jerusalem, sulia nia naa fera nia na Aaofia baita ka tasa. ");
INSERT INTO llu_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ma langi osi kwaiagi ana ketemu, sulia e afetai oko haungainia tee si iifu i ketemu ka kwakwaoa ma langi ka bubulua. ");
INSERT INTO llu_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","E diana fuamu oko haea go amu, <Iiuka>, ma langi, <E langi.> Ma lea oko haea lau tesi doo, si doo nae e lea na mai faasia a Satan na wane taꞌa.>> ");
INSERT INTO llu_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","A Jesus e tasa dongaa ana baelana ka urii, <<I gamu mu rongoa sui naa baa da haea urii, <Lea ta wane ka labasia na maana ta wane aai, gera ka labasia maana wane nae laugo. Ma gwe lifo laugo uria na duulana gwe lifo.> ");
INSERT INTO llu_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Haia, si kada naa i nau ku haea fuagamu, langi osi duua tesi doo na ta wane e iilia taꞌalaa fuamu. Lea so ta wane e fidalia na babali aaolo oe, oko faalamainia na bali babali mouli oe hai ka fidalia laugo. ");
INSERT INTO llu_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ma lea so ta wane ka ngali oe uria na keketoa uria ngalilana na maku ruruu oe, oko falea laugo na maku tekwa oe fuana. ");
INSERT INTO llu_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ma lea so ta wane ka suungainia oko ngalia na oke doo nia sulia tee kade tala, oko ngalia lau sulia ruana kade tala. ");
INSERT INTO llu_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ma lea ta wane gania tesi doo siamu, oko falea amu fuana. Ma si kada ta wane ka dooria na ngalilangalaa ana tesi doo siamu, oko falelanga ana fuana. ");
INSERT INTO llu_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","<<Gamu mu rongoa sui naa laugo baa da bae urii, <Muka rakediana agamu fuada na ruana gamu gi, ma muka maasusuala ada na maalimaea gamu gi.> ");
INSERT INTO llu_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Haia, si kada nae, nau ku haea fuagamu, muka rakediana fuada na maalimaea gamu gi, ma muka fooa fuada ni tei gera na da faanonifii gamu, ");
INSERT INTO llu_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","eeri muka hau ana na wela nia na Maa gamu mai i langi. Sulia nia e haungainia na hato, ma ka talafia na tooa taꞌa gi ma na tooa diana gi ka bobola sui go, ma ka falea na uuta fuada ni tei gera na da iilia doo diana gi ma fuada ni tei gera na da iilia si doo taꞌa gi. ");
INSERT INTO llu_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Lea so muka rakediana go agamu fuada na tooa gi na da rakediana fuagamu, a God langi kasi kwaiarangai gamu go. Sulia na tooa faafefe ni gonitai malefolaa baa ana takisi boroi, gera da iilia laugo si doo nae! ");
INSERT INTO llu_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ma lea mu bae diana go agamu fai nia na ruana gamu gi, langi musi eꞌete go faasia na tooa gi sui. Sulia na tooa gi i uugita gi boroi da iilia laugo si doo nae! ");
INSERT INTO llu_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Muka oꞌolo teefou naa iilingia na Maa gamu i langi e oꞌolo teefou.>> ");
INSERT INTO llu_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ma a Jesus ka bae urii lau, <<Muka susuli gamu, aata muka iilia go agamu na doo diana gamu gi eeri wane gi daka rikia ma daka manata baita ani gamu. Lea mu iili urinae, afetai asianaa hasa muka ngalia ta kwaiaraa faasia na Maa gamu mai langi. ");
INSERT INTO llu_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Lea oe falea na falelaa uria adomilana tooa siofaa, langi osi faatainia fuana tooa gi hai so daka baelafe oe. Sulia na malutana na tooa da susuge ana aabulolada nia urinae. Gera kwaiꞌadomi fuana tooa siofaa gi laona Beu Aabu gi ma sulia na tala baita gi laugo, eeri tooa gi sui daka baelafe gera. Haia, ma nau ku haea fuagamu, tara a God ka langi si falea ta kwaiaraa fuada, sulia gera ngalia sui naa na kwaiaraa gera gi. ");
INSERT INTO llu_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Haia, ma ni oe, si kada oko falea tesi doo fuana kwaiꞌadomilaa ana, langi osi faatainia fuana ta wane, hai so ta ruana amu boroi langi kasi haitamana naa. ");
INSERT INTO llu_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Si kada oe o falea tesi doo fuana ta wane, oko aagwa go, hai ta wane lau kasi rikia, ma langi so ka haitamana. Sui boroi ana, na Maa oe na e nii mai langi naa nia rikia si taa gi na oe aadea, tara nia naa ka falea si kwaiaraa fuamu.>> ");
INSERT INTO llu_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Jesus ka bae urii lau, <<Si kada mu fooa, langi musi iilingia tooa susuge na da fooa go ada eeri na tooa gi daka rikida. Sulia ana si kada gera fooa, gera dooria asianaa takelaa lao Beu Aabu ni figulaa ma langi sulia tala baita gi eeri na tooa gi daka riki gera. Haia, nau ku haea fuagamu, gera ngalia sui naa na kwaiaraa gera gi faasia na tooa na gera tangoda. ");
INSERT INTO llu_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ma ni oe, si kada o fooa ana, oko lea uria tesi gula na e too banitai ma oko too i seenae, ma oko haea fooalaa oe gi fuana God na ta wane langi kasi rikia. Sui boroi ana langi ta wane kasi riki oe kada oko fooa ana, tara Maa oe na nii mai langi na tara ka riki gamu. Haia, ma tara ni nia laugo na ka kwaiarangai oe fuana si taa gi na oe iilida. ");
INSERT INTO llu_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","<<Si kada mu fooa ana, langi molu si iilingia lau tooa i uugita. Sulia si kada gera fooa ana, gera bae tekwa asianaa, ma langi gera kasi haitamana filoa na taa gi na gera haeda. Manatada hasa lea gera fooa tekwa urinae, tara God ka rongo gera. ");
INSERT INTO llu_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ma ni gamu, langi musi aade iilingi gera, sulia Maa gamu mai langi nia e haitamana sui ua na ana si taa gi na gamu dooria, suifetei mufi gania. ");
INSERT INTO llu_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","<<Haia, si kada molu fooa ana, molu ka bae urii, <Maa gami i langi ae, gami dooria hasa tooa gi sui daka faabaitaa hatamu, sulia nia e aabu asianaa. ");
INSERT INTO llu_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Na Initooa oe ka lea mai, ma na kwaidooria oe daka aadea na i aano iilingia i langi. ");
INSERT INTO llu_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","O falea mai si fanga ka bobola sulia dani. ");
INSERT INTO llu_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Oko manata lukea na aade taꞌalaa gami gi iilingia mika manata lukea na aade taꞌalaa gera wane gi da iilia fuagami. ");
INSERT INTO llu_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Oko firi ani gami faasia na iilitooa. Ma oko dilangai gami faasia a Satan.> ");
INSERT INTO llu_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","<<Haia, lea gamu manata lukea tei na e aade taꞌa fuagamu, tara Maa gamu mai langi nia ka manata luke gamu laugo. ");
INSERT INTO llu_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ma lea gamu si manata lukea ni tei na e iilia si taꞌalaa fuagamu, tara Maa gamu mai langi kasi manata luke gamu laugo.>> ");
INSERT INTO llu_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","A Jesus ka bae urii lau, <<Ana si kada gamu aabu fanga ana uria fooalaa rigita, langi musi iilingia tei gera na da sugea tooa ana aabulolada. Sulia si kada gera aabu fanga ana, gera ka faabilia na maada, ma gera ka aada mala tooa da liobukonu hai na tooa gi daka riki gera, ma daka tangoda. Haia, ma ni nau ku haea fuagamu, na tooa na afetai gera ka ngalia ta kwaiaraa lau, sulia tooa gi gera falea sui naa na kwaiaraa gera ana tangoladalaa. Ma God langi kasi falea laugo ta kwaiaraa fuada. ");
INSERT INTO llu_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Haia, ma ni oe, kada oe aabu fanga, oko sisiu amu, ma oko kafa amu iilingia oe iilia sulia dani, ");
INSERT INTO llu_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","eeri ta wane kasi aada haitamamu na oe aabu fanga. Ma sui boroi ana ta wane kasi aada haitamamu, tara Maa oe i langi e riki oe, ma tara nia ka falea na kwaiaraa fuamu uria na taa gi na oe o iilida. Nia naa na wane na e haitamana riki oe sulia dani, sui boroi ana osi haitamana riki nia.>> ");
INSERT INTO llu_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Sui, a Jesus ka bae urii lau, <<Musi taingainia na ooganilaa gamu gi i seegi lao molaagali ana na gula na susubu ma na burolaa ka nagaa ma na tooa bebeli ka belia. ");
INSERT INTO llu_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Muka taingainia na ooganilaa gamu gi i langi taari, si gula susubu ma na buro kasi nagaa, ma na wane bebeli langi dasi belia. ");
INSERT INTO llu_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Sulia fai na ooganilaa gamu gi nia too ana, na manataa gamu gi sui ka too laugo i seenae. ");
INSERT INTO llu_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","<<Na maamu e iilingia na laeta fuana nonimu. Lea na maamu e gwagwalifolaa, na nonimu laugo ka folaa naa. ");
INSERT INTO llu_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ma lea na maamu e rorodoa, na nonimu laugo ka rorodoa. Haia, lea na laeta na e too ani gamu e rorodoa go ana, na rorodolaa nae kafi baita fetei.>> ");
INSERT INTO llu_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","A Jesus ka bae lau urii, <<Afetai ta wane ka rao fuana roo aarai gi. I nia ka maasusuala ana ta aarai ma ka rakediana fuana ta aarai aai. I nia ka aaburongo baelana ta aarai ma ka roosulia ruana aarai aai. Afetai hasa muka rao fuana a God ma na malefo. ");
INSERT INTO llu_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","<<Nia naa, nau ku haea fuagamu, e langi musi manata aꞌabo ana fanga fai nia na gwoulaa na gamu mouri ana, ma langi na maku fuana noni gamu. Na mouria naa e diana ka liufia na fanga? Iiuka. Na noni doo naa e diana ka liufia na maku? Iiuka. ");
INSERT INTO llu_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Aada muka rikia fasi na manu gi i mamangaa. E langi dasi fasia go tesi doo ma langi dasi taingai go i laona ta babala gi. Sui, a Maa gamu i langi ka aada go ana suli gera. Haia, i gamu mu diana ka liufia na manu gi? Iiuka. ");
INSERT INTO llu_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Gamu langi musi haitamana ka faatekwaa na mourilaa gamu ana manata aꞌabolaa. ");
INSERT INTO llu_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","<<Ma uria taa naa mu ka manata aꞌabo sulia na maku gi? Aada muka rikia fasi na taelana na tage ai gi. Gera langi dasi rao go, ma e langi dasi haungainia go teni maku ada. ");
INSERT INTO llu_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ma nau ku haea fuagamu, boroi ana a Solomon na aaofia baa e todadoo ma ka too ana na doo oro gi, langi ta maku ana kasi diana go iilingia na tage ai naa gi. ");
INSERT INTO llu_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","A God e faaofia na laua kwasi, na laua na e too i taraꞌena ma i bobongi ka mae laugo ana ma ka harufia i laona eere. Tara a God ka langi si manatatoona laugo na faaofilaa gamu? Na manata mamanalaa gamu e toꞌou asianaa. ");
INSERT INTO llu_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","<<Nia naa, langi musi manata aꞌabo urii, <Na fanga ma na gwoulaa ma langi na maku nau tara ka lea mai faasia i fai?> ");
INSERT INTO llu_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Haia, na doo nae gi na tooa gi i uugita da manata aꞌabo ana sulia dani. Ma na Maa gamu mai langi e haitamana go ana na mu dooria na doo nae gi sui. ");
INSERT INTO llu_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Muka manata ngado ka tasa ana na Initooa a God taari fai nia na doo oꞌolo gi. Muka manata ngado ana si doo naa gi ka liufia na doo eꞌete gi sui, ma tara nia ka falea na doo naa gi sui na mu dooria fuagamu. ");
INSERT INTO llu_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Nia naa, langi musi manata aꞌabo uria i bobongi. Sulia fe dani i bobongi ka too laugo ana si aꞌabolaa nia gi fuana i talana. Langi si bobola hai muka oofua si aꞌabolaa gi i bobongi fai nia na aꞌabolaa gi ana fe dani i taraꞌena.>> ");
INSERT INTO llu_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ma Jesus ka bae urii lau, <<Langi molu si ketoa ta wane, eeri a God ka langi si keto gamu. ");
INSERT INTO llu_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Lea molu ketoa ta wane, a God ka keto gamu lau go urinae. Haia, si kwaieresia taa na mu ketoa ana ta wane, na kwaieresia nae laugo na tara God ka keto gamu ana. ");
INSERT INTO llu_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Oe go, lea ta wane e iilia go si gala doo garo, oko ketoa na amu ana. Sui langi osi manata go sulia na garolaa baita gi na oe iilida? Oe o iilingia na wane baa e dooria lafua si ooronga doo laona maana ta wane aai, ma ka langi si haitamana ana si tofi ai na e nii i laona maana. ");
INSERT INTO llu_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Oe haitamana asianaa uria haelana fuana ruana amu urii, <Ruana ae, nau ku dooria lafua si ooronga doo na e too la maamu.> Sui ma langi musi manata go uria lafulana tofi ai baita na e too la maamu i talamu. ");
INSERT INTO llu_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Oe o aada mala o olo go amu, sui na manatalaa oe nia eꞌete asianaa. Oe o tafusia fasi na taꞌalaa gamu gi. Lea sui, ofi bobola uria kwaiꞌadomilaa kou ana ta wane eꞌete uria na garolaa nia gi. ");
INSERT INTO llu_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","<<Ma langi musi falea doo aabu gi fuana kui gi, sulia tara gera aabulo ma daka aꞌala gamu. Ma langi molu si falea na lalaungia gamu gi fuana boso gi, aata gera ka buu faafia go ada.>> ");
INSERT INTO llu_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Jesus e bae urii lau, <<Lea so ta wane e fooa fuana God ma ka gania uria tesi doo, God haitamana ka falea go ana fuana. Ma so ni tei na e nanisia tesi doo ma ka fooa fuana God, God haitamana ka faatainia fuana. Haia, ma so ni tei na e lea mai ma ka kidikidi ana maa ana Beu nia a God, tara a God ka ifingia na maa fuana. ");
INSERT INTO llu_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Sulia ni tei naa e gania God, tara nia ka falea fuana. Haia, ma ni tei naa e nanisia tesi doo, nia ka lea mai siana a God, ma ka daotoona. Ma ni tei naa e fooa fuana a God iilingia na wane baa e kidikidi ana maa ana luma ruana nia, tara a God ka ifi uria na adomilana. ");
INSERT INTO llu_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","<<Haia, nau ku soeledi gamu tooa na muka too ana wela gi. Utaa? Lea na wela oe e lea mai siamu ma ka gani oe uria fanga, tara haitamana oko falea go amu na fou fuana? Afetai! ");
INSERT INTO llu_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ma lea nia ka gani oe uria iia, tara oko falea na loi fuana? Afetai! ");
INSERT INTO llu_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Haia, ma sui boroi ana na aabulolaa gamu gi ka taꞌa, muka haitamana muka falea go agamu doo diana gi fuana wela gamu gi. Haia, na Maa gamu mai langi nia liufi gamu sui uria falelana doo diana gi fuana tei gera na da gania. ");
INSERT INTO llu_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","<<So tesi taa na mu dooria tooa eꞌete gi daka aadea fuagamu, nia laugo na muka aadea fuagera. Sulia nia naa na malutana na faatolomailaa ana kwaieresia a Moses gi ma gera profet gi sui.>> ");
INSERT INTO llu_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","A Jesus ka bae urii lau, <<Muka ruu kou ana maehagaa na e toꞌou, sulia na maehagaa na e baita ma ka rereba nia lea uria na maea. Ma na lealana sulia e waluda go ana, ma na tooa oro asianaa na da lea sulia na tala nae. ");
INSERT INTO llu_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Haia, ma na maehagaa na e toꞌou ma ka logo nia lea uria na mouria, ma na lealaa sulia ka afetai, ma aange wane go naa da lea sulia.>> ");
INSERT INTO llu_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Jesus ka bae urii laugo, <<Muka susuli gamu faasia na profet susuge gi. Muka susuli gamu sulia gera da aada mala tooa diana, sui taa na manatalada na e iilingia kui kwasi gi na daka dooria labasilaa gamu. ");
INSERT INTO llu_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Haia, ma tara muka aada haitamada go amu na profet susuge nae gi ana si doo taꞌa gi na gera iilida gi. Sulia na kwaletotore afetai daka fusia ta fufue doo diana ana. ");
INSERT INTO llu_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ma na ai diana ka fungu laugo ana fufue doo diana gi, ma na ai taꞌa gi ka fungu laugo ana fufue doo taꞌa gi. ");
INSERT INTO llu_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ai diana afetai ka fungu ana fufue doo taꞌa, ma na ai taꞌa e afetai ka fungu ana fufue doo diana. ");
INSERT INTO llu_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Na ai gi sui go na langi dasi fusia ta fufue doo diana gi, gera ka tabalida ma daka ui ania i laona eere. ");
INSERT INTO llu_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Nia naa, nau ku haea fuagamu, tara muka aada haitamana na profet susuge naa gi ana si doo gi na gera iilida gi.>> ");
INSERT INTO llu_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","A Jesus e bae urii lau, <<Langi lau na tooa gi sui na da haea fuagu, <Lord ae! Lord ae!>, daka ruu ana na Initooa i Langi. Ma ni tei gera ana na da iili sulia na kwaidooria nia a Maa nau i langi go ana taari, daka ruu i laona na Initooa i Langi. ");
INSERT INTO llu_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ma na tooa oro gi daka bae urii fuagu ana fe dani ketolaa nae, <Lord ae, i gemelu haea na baelana a God ana na hatamu, ma melu ka taria na aagalo taꞌa gi ana na hatamu, ma melu ka iilia doo oro ni kwelelaa ana hatamu.> ");
INSERT INTO llu_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Sui, tara nau kuka bae urii fuada, <Nau kusi haitamamolu. I gomolu na tooa taꞌa gi. Molu lea tau kou faasi nau!> ");
INSERT INTO llu_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","<<Nia naa, na tooa gi sui na da rongoa si baea nau naa gi ma daka iili sulia, da iilingia na wane liotoo na e tolea na luma nia i fafona na fou. ");
INSERT INTO llu_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Na uuta baita ka aru, ma na kafo gi ka busu, ma na ooru baita ka kwaea na luma nae, ma boroi ana, na luma nae kasi asia go, sulia e ngado i fafona na fou. ");
INSERT INTO llu_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","<<Sui ma na tooa gi sui na da rongoa na baea nau naa gi ma dasi iili sulia, da iilingia na wane nue na e tolea na luma nia i fafona oone. ");
INSERT INTO llu_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Na uuta baita ka aru, ma na kafo gi ka busu, ma na ooru baita ka kwaea na luma nae, ma na luma nae ka asia ma ka oogosi teefou naa.>> ");
INSERT INTO llu_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ana si kada Jesus e faatolomainia tooa gi ana si doo naa gi sui, gera ka kwele asianaa. ");
INSERT INTO llu_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Sulia gera ka aada haitamana Jesus nia e eꞌete faasia faatolomai gera ana kwaieresia a Moses gi. A Jesus e too ana mamanaa si kada nia e faatolomai ana. ");
INSERT INTO llu_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Si kada Jesus e sifo mai ana faasia i gwouna fe uuo nae, na figulaa baita gi daka lea mai sulia. ");
INSERT INTO llu_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ma tee wane na fura e haungia noina e lea mai, ma ka boururu naona Jesus, ma ka bae urii, <<E aarai ae, lea so o maabe, nau ku haitamana oko bobola go amu uria guralagulaa.>> ");
INSERT INTO llu_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Sui a Jesus e tekwala kou na abana, ma ka hamosia wane nae, ma ka bae urii, <<Nau ku dooria. Nonimu ka mafo naa.>> Ma ana si kada nae ua go, na nonina wane naa ka mafo naa. ");
INSERT INTO llu_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","A Jesus ka bae urii fuana, <<Langi osi faarongo ana ta wane lau, ma o lea olo siana na fataabu, eeri ka rikia na nonimu naa e diana naa ma ka faalu naa faasia si mataia baa e haungi oe. Haia, i buira lea oko falea kwaisuusia oe iilingia baa a Moses e haea i laona na kwaieresia nia gi, eeri na tooa gi sui daka haitamana na nonimu e diana sui naa.>> ");
INSERT INTO llu_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ma ana si kada Jesus e dao ana fera Kapaneam, tee wane naonao ana wane ni firua gera Rom, nia e lea mai siana Jesus, ma ka gania fuana ka adomia, ");
INSERT INTO llu_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ka urii, <<Wane baita ae, na wane ni raoa nau e matai asianaa, ma ka teo go ana, ma ka lalafusia gelolana noina, ma na nonina ka fii asianaa.>> ");
INSERT INTO llu_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesus ka bae urii fuana, <<Diana go ana, nau tara kuka lea mai uria luma oe eeri kuka guraa.>> ");
INSERT INTO llu_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ma wane naonao naa ka bae lau urii fuana Jesus, <<E wane baita ae, nau langi kusi faorana eeri kuka gonitai oe i laona luma nau. O haea go amu mai si baea, sulia lea oe haea boroi amu mai si baea, na wane raoa nau nia tara ka akwaa naa. ");
INSERT INTO llu_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nau ku haitamana oe bobola oko aade go amu si doo nae, sulia nau laugo nau ku too nunufana wane baita nau, ma teni wane gi laugo gera ka too i nunufagu. Ma lea ku haea fuana ta wane, <Lea o iilia si doo naa,> nia ka iilia naa. Ma lea ku urii, <Lea mai,> nia ka lea mai.>> ");
INSERT INTO llu_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ma si kada Jesus e rongo si doo naa, nia ka kwele asianaa. Ma nia aabulo fuana tooa na gera lea sulia, ka bae urii fuada, <<Nau ku haea fuagamu, nau langi kusi rikia ta wane manata mamana urii ani gamu tooa i Israel. ");
INSERT INTO llu_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ma nau ku haea fuagamu, tara tooa oro na langi dasi Jiu gera ka lea mai i langi faasia fera oro lao molaagali uria adolaa ana doo diana gi fai nia na koo gia Jiu gi a Abraham, Aesak, ma Jakob. ");
INSERT INTO llu_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Haia, tara orolada Jiu gi na hasa gera ka ado ana si doo diana gi ana i langi, tara God ka kwae tari gera uria gula rorodoa. Ma si kada gera too ana si gula nae, gera ka aangi ma daka girigiri na lifoda.>> ");
INSERT INTO llu_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ma Jesus e kariabulo lau fuana wane baita nae, ka bae urii fuana, <<O ooli kou. Nau ku iilia si doo na o gania, sulia oe manata mamana ani nau.>> Ma ana si kada nae ua go, na wane rao baa ka akwaa naa. ");
INSERT INTO llu_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ma ana tefe dani, a Jesus e lea mai i luma a Peter. Si kada Jesus e ruu i luma, nia ka rikia fungo geni a Peter e teo, na tatasua e haungia. ");
INSERT INTO llu_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ma a Jesus e hamo uria abana na geni naa. Ma ana si kada nae ua go, na tatasua naa e sui faasia. Nia ka akwaa naa, ma ka tatae ka hasi fanga na ana fuana Jesus. ");
INSERT INTO llu_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ma si kada e haulafia, na tooa i fera naa gera ka ngalia mai tooa oro siana na aagalo taꞌa gi da adosida. Ma Jesus ka taria aagalo taꞌa nae gi faasida ana baelana go ana. Ma nia ka guraa laugo tooa matai gi sui. ");
INSERT INTO llu_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Si kada nia iilia ana si doo nae gi, nia faamamanaa baelana na profet Aesea nia kedea ka bae urii, <<Na wane naa nia ngalia na mataia na e haitamana ka faamakeso gia asianaa mamana, ma nia ka faasuia mataia gi na haitamana ka labasia na noniga.>> ");
INSERT INTO llu_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Haia, kada Jesus e rikia tooa oro gera koni mai gali nia, nia ka bae urii fuana oote fafurongo nia gi, <<Golu faifolo uria bali aasi aai loko.>> ");
INSERT INTO llu_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ana si kada nae go ana, tee wane faatolomai ana kwaieresia gi e lea mai siana Jesus ka bae urii, <<Faatolomai ae, nau ku lea fai oe so i fai na o lea uria.>> ");
INSERT INTO llu_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Kada Jesus e rongoa si doo naa, nia ka bae urii, <<Si doo naa langi kasi waluda. Na kui kwasi gi da too ana na kilu gera gi uria teolaa, ma na manu gi laugo daka too ana na nui gera gi. Haia, ma ni nau na Wela nia Iimola gi, langi go ta luma agu fuana toolaa ana.>> ");
INSERT INTO llu_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ma tee wane ana fafurongo nia gi, nia e bae fuana Jesus ka urii, <<Wane baita ae, o lugasi nau ku ooli fasi fui fera nau, eeri kuka aada sulia na maa nau lealea nia mae, kuka aalua. Sui kufi ooli mai uria lealaa fai oe.>> ");
INSERT INTO llu_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesus e oolisia ka bae urii, <<Langi. O lea na mai fai nau ana si kada nae. O faalamainia na tooa gi na langi dasi too ana mouria faasia a God gera ka aalua na ada na iimola mae gera gi.>> ");
INSERT INTO llu_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ma a Jesus ka tae laona baru fai nia oote fafurongo nia gi. ");
INSERT INTO llu_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ma ana si kada gera sigi tau na mai naa, halo ka dao mai aliꞌali, ma na aasi ka tongatonga ma ka moꞌoi faafia na baru. Ma na baru ka garangi kuruu. Haia, ma Jesus nia e teo go ana lao baru. ");
INSERT INTO llu_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Na fafurongo nia gi daka faaada, daka bae urii, <<Lord ae! O faamouri golu! Golu garangi mae.>> ");
INSERT INTO llu_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ana si kada nae Jesus ka bae urii fuada, <<Utaa na molu ka mou? Gomolu molu si manata mamana go ani nau.>> Jesus e bae urinae fuada sui, nia ka take, ma ka bae rigita fuana ooru ma na nafo eeri daka too aaroaro. Ma ana si kada nae ua go, na ooru ma na nafo daaro ka too aaroaro. ");
INSERT INTO llu_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ma na fafurongo nia gi daka kwele asianaa, ma gera ka bae urii, <<Wane utaa naa? Sui boroi ana ooru ma na nafo da roosulia baelana!>> ");
INSERT INTO llu_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Haia, si kada gera dao naa ta bali aasi aai ana maefera i Gadara, Jesus ka kwaitodai fai nia roo wane na aagalo taꞌa e too ada. Roo wane naa gi daaro too mai laona mae oba ni aalu wane maelaa i laona. Ma sulia maa daaro e susuala asianaa, nia naa e aadea ta wane kasi dao garangia go si gula na daaro too ana. ");
INSERT INTO llu_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ana si kada aagalo nae gi e too ana roo wane naa, daaro rikia Jesus, daka rii urii, <<Wela nia a God ae, taa naa dooria oko iilia ani gemelu? Utaa? Oe lea mai uria faafiilaa melu i nao suifetei si kada na faafiilaa ka dao?>> ");
INSERT INTO llu_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ana si kada nae, na boso oro gi da fanga ada garangia i seenae. ");
INSERT INTO llu_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Na aagalo nae gi gera ingo ana Jesus daka urii, <<Lea o kwae tari gemelu, o oodu gemelu fui laona boso loko gi.>> ");
INSERT INTO llu_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ma Jesus ka bae urii fuana aagalo nae gi, <<Molu lea naa!>> Ma gera ka hagatafa, daka lea naa fui laona boso nae gi. Haia, ma boso nae gi teefou gera laetoli na sulia kamena tolo nae fui lao aasi baa. Ma gera ka mae teefou i seenae. ");
INSERT INTO llu_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Haia, ma na tooa na gera aada sulia boso nae gi gera ka lalao fui fera gera. Ma gera ka uunuunu sulia si doo gi a Jesus e iilia, ma na taa naa e fuli fuana na roo wane baa fai nia na aagalo baa gi. ");
INSERT INTO llu_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ma na tooa sui ana maefera nae daka lea sui mai uria rikilana Jesus. Ana si kada gera dao siana, gera ka ingo ani nia eeri ka lea faasia fera gera. ");
INSERT INTO llu_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Haia, a Jesus fai nia na oote fafurongo nia gi da tae lao baru, ma gera faifolo lau ana mae aasi. Ma si kada gera dao naa i fera nia, ");
INSERT INTO llu_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","teni tooa gi gera ka ngalia mai tee wane na nonina e mae fafona iifitai siana Jesus, eeri ka guraa. Ma si kada Jesus e rikia na manata mamanalaa gera, nia ka bae urii fuana wane na nonina e mae, <<Osi mou, nau ku manata lukea sui naa na taꞌalaa oe gi na o iilida.>> ");
INSERT INTO llu_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ana si kada nae, teni wane faatolomai ana kwaieresia gi gera ka manata urii, <<Wane nae nia e bae tataga ana God, sulia nia ka manata lukea aade taꞌalaa gi iilingia nia a God naa.>> ");
INSERT INTO llu_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ma Jesus, sulia nia e aada haitamana go ana manatalada, nia ka bae urii fuada, <<Utaa na manatalagamu ka taꞌa urinae? ");
INSERT INTO llu_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Nia waluda go ana fuana haelanalaa fuana wane naa, <Nau ku manata lukea naa na aade taꞌalaa oe gi.> Ma ka afetai fuana haelana fuana, <O take, oko fali.> ");
INSERT INTO llu_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Haia, ni nau, na Wela nia Iimola gi, nau ku too ana mamanaa lao molaagali naa uria na manata lukelana doo taꞌa gi. Ma tara kuka faatainia fuagamu eeri muka aada haitamana i nau ku too ana mamanaa nae.>> Ma Jesus ka bae urii fuana wane nae na nonina e mae, <<O take i langi, oko lukumia na iifitai oe, oko ngalia oko ooli luma oe.>> ");
INSERT INTO llu_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ana si kada nae ua go, wane naa ka take ma ka ooli naa fui luma nia. ");
INSERT INTO llu_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Si kada na tooa gi da rikia taa na Jesus e iilia, gera ka mou. Ma daka baelafea God sulia nia falea si mamanaa urinae fuana na tooa. ");
INSERT INTO llu_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Si kada a Jesus e tafusia si gula nae, nia ka rikia tee wane hatana Matthew. Wane nae e gwouru ana si gula ni raoa nia ana na gonilaa malefo ana takisi. Ma a Jesus ka bae urii fuana, <<O lea mai fai nau.>> Ma a Matthew e take, ma ka lea naa fai nia. ");
INSERT INTO llu_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ma si kada a Jesus e fanga i luma nia a Matthew, teni wane faafefe gi na gonilana takisi ma na wane taꞌa gi aai da dao ma da fanga fai nia a Jesus ma na oote fafurongo nia gi. ");
INSERT INTO llu_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ma si kada na Farisi gi da rikia si doo naa, gera ka ledia na oote fafurongo nia gi daka urii, <<Uria taa naa na wane faatolomai doo gomolu ka fanga ana fai nia na wane taꞌa gi urinae?>> ");
INSERT INTO llu_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","A Jesus e rongoa si doo naa, ma ka bae urii, <<Na tooa gi na da akwaa dasi dooria go na wane ni guralaa, na tooa gi na da matai taari da dooria na wane ni guralaa. ");
INSERT INTO llu_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Molu manata fasi na malutana si Kekedelaa Aabu baa e urii, <I nau ku dooria na rakediana gamu, langi lau na kwaisuusilaa gamu gi ana doo kwasi gi.> I nau kusi lea mai uria na soelada na tooa oꞌolo gi, ma i nau ku lea mai uria na soelada na tooa gi na aabulolada e taꞌa.>> ");
INSERT INTO llu_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Buira si doo naa gi, na oote fafurongo a John Siuabu gi gera ka lea mai siana Jesus, gera ka bae urii, <<Gemelu fai nia gera Farisi gi melu haitamana aabu fangalaa uria fooalaa rigita. Ma utaa na oote fafurongo oe gi langi dasi iilia si doo nae?>> ");
INSERT INTO llu_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Haia, Jesus e oolisi gera ka urii, <<Ana si kada nae, na oote fafurongo nau gi da uusulia na oote ruana ana tee wane na kafi aarai ana fafangaa ana bara. Haia, ana si kada urinae, e afetai hasa ruana nia gi gera ka liobukonu langi so gera ka aabu fanga. Haia, ana si kada tara nia ka lea ana faasi gera, gera kafi liobukonu ma dafi aabu fanga. Nia na si kada nau ku too ua fai nia oote fafurongo nau gi, langi gera dasi aabu fanga. ");
INSERT INTO llu_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","<<Haia, faatolomai faalu nau langi si bobola molu ka dolalia fai nia faatolomai kwali gera wane baita gomolu gi. Lea molu iili urinae, nia uusulia wane baa e ngalia si mani maku faalu, ma ka saumodea ana si gula e kakari ana si kwali maku ruruu nia. Tara si mani maku faalu na haitamana ka hau ana toꞌou, ma ka asia go ana faasia si kwali maku ruruu nae. Ma lea nia kakari tara si mae karilaa nae ka baita liufia i nao. ");
INSERT INTO llu_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ka urinae laugo si kada ta wane e ngalia si waen faalu ma ka faafungua lao kwali botele gi na gera haungainia ana ungana nanigot. Si kada waen faalu nia e furafura, tara fe botele naa gi ka foga go ada ma na waen ka igitai. Ma na ungedoo kwali nae ka taꞌa na ana. Haia, waen faalu, gera ka oongia lau go i laona fe botele faalu gi ana unga nanigot eeri roo si doo nae gi gera ka diana sui. ");
INSERT INTO llu_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Si kada Jesus e faarai ua, tee wane baita ana tooa Jiu gi e lea mai. Ma nia ka boururu i naona Jesus, ma ka bae urii, <<Na haari nau kafi mae go. Nau ku dooria oko lea mai eeri oko aalua abamu faafia hai ka mouri ana.>> ");
INSERT INTO llu_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ma Jesus fai nia oote fafurongo nia gi daka lea fai nia wane nae. ");
INSERT INTO llu_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ma ana si kada da lea ua go ada, tee inite aai matai ana abu sura e haungia sulia aakwala ma roo fe ngali, nia e lea mai buira a Jesus, ma ka hamosia kakamuna maku tekwa nia. ");
INSERT INTO llu_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Totongenao, geni naa e manata ka urii, <<Sui boroi ana lea so ku hamosia na kakamuna maku nia a Jesus, nau kuka akwaa naa.>> ");
INSERT INTO llu_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Kada nia hamosia ana kakamuna maku nia, Jesus ka kari aabulo, ma ka rikia na geni nae, ma ka bae urii fuana, <<Osi manata aꞌabo lau. Oko akwaa naa, sulia o manata mamana ani nau.>> Ma ana si kada nae ua go, si mataia nae ka sui naa faasia. ");
INSERT INTO llu_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Si kada Jesus fai nia oote fafurongo nia gi gera dao i luma nia wane baita baa, gera ka rikia tooa gi gera uufia na au ana maea, ma na tooa oro lau go gera koni seenae, ma daka aangi. ");
INSERT INTO llu_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ma Jesus ka bae urii fuana tooa nae gi, <<Gomolu sui go molu haga i maa. Wela geni naa e langi si mae iilingia na molu manata fuana, ma nia e teo go ana.>> Sui gera rongoa Jesus nia bae urinae, gera ka waela go ada ani nia. ");
INSERT INTO llu_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ma i buira na tooa gi daka lea faasia, a Jesus ka ruu kou, ma ka hamo uria na abana haari nae, ma nia ka tatae. ");
INSERT INTO llu_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Buira si doo na a Jesus e iilia, na uunuunulaa sulia kafi talofia fera gi sui i seenae. ");
INSERT INTO llu_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Buira Jesus e lea kou faasia gula nae, tee roo wane maa rodo daka lea i buira Jesus, daaro ka rii ma daaro ka bae urii, <<Wane na futa ana kwalafaa a David na aaofia ae, o manatai gemere!>> ");
INSERT INTO llu_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ma ana si kada Jesus e ruu i laona tee luma, roo wane maa rodo nae gi daaro ka ruu laugo i buira. Ma Jesus ka bae urii fuadaaro, <<Haia, gomoro moro manata mamana ani nau hai kuka bobola uria guralana na maamoro naa?>> Ma daaro oolisia daaro ka bae urii, <<Iiuka, Lord.>> ");
INSERT INTO llu_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ma a Jesus ka hamosia na maadaaro, ka bae urii, <<Sulia na moro manata mamana, si doo nae ka fuli mamana naa fuamoro.>> ");
INSERT INTO llu_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ma na maada ka aada naa, ma Jesus e bae rigita fuadaaro langi daaro si faarongo ana ta wane. ");
INSERT INTO llu_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ma sui ana si kada daaro haga kou ana, daaro kafi uunuunu mone adaaro sulia Jesus siana tei na daaro kwaitodai fai nia i laona bali lolofaa nae. ");
INSERT INTO llu_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Haia, ma si kada roo wane baa gi daaro haga kou, teni wane gi gera ka ngalia mai tee wane lau siana Jesus. Na fakana wane nae e ato, sulia tee aagalo taꞌa e adosia. ");
INSERT INTO llu_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ma a Jesus ka taria aagalo taꞌa nae faasia wane nae. Sui, na wane naa ka bae laugo ana. Ma na tooa na da koni ana si kada nae, gera ka kwele asianaa ana, ma gera ka bae urii, <<Langi golu si rikia ua mai tesi doo urii i fera gia i Israel!>> ");
INSERT INTO llu_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Sui na Farisi gi daka bae tolingia ada Jesus daka urii ada, <<Wane baita gera aagalo gi na e falea mamana fuana wane naa ka taria ana aagalo gi.>> ");
INSERT INTO llu_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ma si kada Jesus e liliu ana fera gi ma na maefera gi, nia ka faatolomai lao Beu Aabu ni figulaa gera gi, ma ka funao ana na Faarongolaa Diana sulia Initooa God, ma ka guraa tooa da matai ana mataia eꞌete kwailiu gi sui. ");
INSERT INTO llu_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ma a Jesus ka bubungia tooa naa, ma ka kwaimanatai asianaa fuada sulia da makeso ma daka manata aꞌabo asianaa uria si doo e oro, ma ka langi ta wane uria adomilada. Gera iilingia sipsip gi e langi ada ta wane uria aadalaa sulida. ");
INSERT INTO llu_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Haia, nia naa Jesus ka bae urii fuana oote fafurongo nia gi, <<Na tooa gi na da dooria manata mamana, gera iilingia na doo oro gi i laona na hara uria gonilana. Sui taa, na wane ni rao gi na langi gera si oro urii gonilaa. ");
INSERT INTO llu_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Haia, lea doo muka fooa ma muka gania God na e too ana raoa eeri ka oodua mai wane ni raolaa gi fai gamu.>> ");
INSERT INTO llu_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","A Jesus e soea na aakwala ma roo wane ni fafurongo nia gi siana, ma ka falea na mamanaa fuada uria na tarilana na aagalo taꞌa gi ma uria na guralana na mataia eꞌete kwailiu gi sui. ");
INSERT INTO llu_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ma nia naa na hatada na aakwala ma roo wane Aposol nia gi: Na eetana, a Simon (na nia ka alangia ana a Peter), ma na haasina a Andrew, ma a James, ma a John, roo wela nia gi a Sebedi. ");
INSERT INTO llu_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ma a Filip, ma a Batolomiu, ma a Tomas, ma a Matthew, na wane baa ni gonilana malefo ana takisi, ma a James na wela nia a Alfeas, ma a Tadeas, ");
INSERT INTO llu_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ma a Simon na wane ana figua na da hasi uria tarilana na initooa faasia i Rom, ma a Judas Iskariot na e falea Jesus fuana maalimaea nia gi. ");
INSERT INTO llu_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ma a Jesus e falea na aakwala ma roo wane nae gi, ka urii, <<E langi molu si lea i matangada tooa maadiu gi, ma molu si ruu i laona na bali fera na tooa gi i Samaria. ");
INSERT INTO llu_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Molu lea go amolu i siada na tooa gi i Israel, na da iilingia na sipsip gi na da langi ada. ");
INSERT INTO llu_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ma si kada molu lea ana, molu ka funao urii, <Na Initooa i Langi e dao garangi naa!> ");
INSERT INTO llu_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ma molu ka guraa na tooa matai gi, ma molu ka tataea na tooa mae gi, ma molu ka faamafoa na tooa gi na fura e labasida, ma molu ka taria na aagalo taꞌa gi. I gomolu molu ngali oꞌoni, nia naa molu ka falea oꞌoni laugo. ");
INSERT INTO llu_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","Na wane ni raoa, nia bobola gera ka aadasulia. Nia naa ana si kada mu lea, langi musi manata aꞌabo uria daulaa faafia tesi malefo. Langi molu si ngalia ta wai. Ma langi molu si ngalia roo sote ma langi tatae silipa gi, langi so ta kubou. ");
INSERT INTO llu_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","<<Haia, lea molu dao ana fera, molu aada uria ta wane na e dooria gonitai gamu uria i laona luma nia. Ma muka too fai nia wane nae lea ka dao ana si kada molu lea faasia maefera nae. ");
INSERT INTO llu_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ma ana si kada molu ruu i laona ta luma, molu bae urii fuana tooa nae gi da too i seenae, <Si fanualama ka too fai gamu.> ");
INSERT INTO llu_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Lea na tooa laona luma nae gera ka kwaimaani fai gamu, tara na fanualama ka too ani gera. Ma lea e langi, sui boroi ana molu ka haea fuada, tara na fanualama kasi too go faida. ");
INSERT INTO llu_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Haia, ma lea molu dao ana fera ma langi ta luma ma ka langi ta wane si maabe go uria gonitailamolu, ma langi daka noni eela uria rongolana baelamolu, haia molu lea faasia gula nae. Ma ana si kada molu lea faasia ana, molu ka kwae tafusia si gano faasia ae molu, eeri ka faatainia tara a God ka falea kwakwaea fuana tooa ana fera nae. ");
INSERT INTO llu_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ma ni nau ku bae doo mamana fuamolu, ana fe dani a God tara ka ketoa ana molaagali, si kwakwaelaa na nia tara ka falea fuana tooa naa na e baita ka tasa, liufia si kwakwaea baa a God tara e falea fuana tooa taꞌa baa gi i laona roo maefera baa gi i Sodom fai i Gomora.>> ");
INSERT INTO llu_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ma Jesus e bae lau urii, <<Gamu faarongo diana, nau ku oodu gamu kou uria na afetailaa. Sulia mu lea uusulia na sipsip gi siana tooa taꞌa gi na da uusulia na kui kwasi gi na da doori labasi gamu. Nia naa, muka aadaada diana, sui muka hahaore laugo. ");
INSERT INTO llu_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Muka aadasuli gamu, sulia teni wane tara daka dumuli gamu, ma daka talai gamu siana wane ni keketolaa, ma gera ka rabusi gamu i laona Beu Aabu ni figulaa gera gi. ");
INSERT INTO llu_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Aena sulia na mu lea suli nau, tara gera ka lafi gamu siana wane baita ma na aaofia gera gi eeri gera ka keto gamu. Ma ana si kada gera iili urinae naa, muka faatalo na ana na Faarongolaa Diana fuada ma fuana teni tooa maadiu gi faasia Jiu. ");
INSERT INTO llu_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Kada gera ngali gamu i naona wane ni keketolaa, langi musi manata aꞌabo uria tesi taa na muka haea ma tara muka bae utaa ana, sulia God ana tara ka falea si baea fuana muka haea ana si kada nae. ");
INSERT INTO llu_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Tara langi molu si faarai taifili gamu naa. Na Aanoedoo a God na Maa gamu mai langi naa tara ka faahaitamadoo gamu. ");
INSERT INTO llu_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","<<Wane oro tara daka ngalia waihaasi gera gi na da manata mamana ani nau fuana tooa eeri gera ka haungida. Ma wane oro gi laugo tara daka iili urinae laugo ana wela gera gi na gera manata mamana ani nau. Ma wela oro gi laugo tara gera ka maalimaea na maa fai nia ni tee, ma gera ka ngali gera siana tooa uria haungilada. ");
INSERT INTO llu_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Tara tooa oro da eekwatai gamu sulia gamu na fafurongo nau gi. Ma lea so ni tei ani gamu na ka manata mamana dongaa lelea ka dao ana na iꞌisilaa, God tara ka faamouri nia. ");
INSERT INTO llu_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Lea tooa ana tee fera da maalimae gamu, muka tafi, muka lea faasia maefera nae aliꞌali, molu ka lea lau amolu uria ta fera aai. I nau ku haea fuagamu, e afetai molu ka faasuia ua go na raolaa gamu ana maefera gi Israel, i nao ana i nau, na Wela nia Iimola gi, tara kuka dao mai. ");
INSERT INTO llu_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","<<Haia, na wela sukulu e langi kasi baita liufia na wane na e faatolomai nia. Ma na wane ni rao e langi kasi baita liufia na aarai baita nia. ");
INSERT INTO llu_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Nia e diana fuana wela sukulu tara ka uusulia na wane faatolomai nia. Ma laugo si doo na e haungia na wane baita, tara ka haungia laugo na wane raoa nia gi. Ma lea so ni nau, na wane baita gamu, gera alangi nau ana Bielsebul na wane baita gera aagalo taꞌa gi, haia, ma ni gamu, tara gera ka alangi gamu ana ta hata na e taꞌa ka tasa.>> ");
INSERT INTO llu_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","A Jesus e bae lau fuada na oote fafurongo nia gi ka urii, <<E langi molu si mou ana na tooa gi. Si doo gi sui na tooa gi da haufinia, tara a God ka faatainia. Ma na doo aagwa gi sui, a God tara ka faataloa. ");
INSERT INTO llu_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ma na doo naa gi na ku haeda fuagamu i laona na rodo, muka haeda lau go ana dani. Ma si doo na ku fuarotainia fuagamu, muka faataloa fuada na tooa gi sui. ");
INSERT INTO llu_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ma e langi musi moungia na tooa gi na da haumaelia na noni, sui ma ka afetai uria na haumaelilana na aanoedoo. Muka moungia a God sulia nia naa e bobola fai nia na faafunuilana na aanoedoo ma na noni doo i laona na gula ana maea. ");
INSERT INTO llu_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ma na manu toꞌou gi boroi na da liu toꞌou go ana, e afetai uria tefe manu ada ka asia i aano lea so na Maa gamu i langi e langi kasi faalamainia. ");
INSERT INTO llu_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Haia, ma na fita iifuna na i ketemu boroi, a God e haitamada sui go. ");
INSERT INTO llu_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Nia naa e langi musi mou, sulia i gamu mu liu baita ka tasa liufia na manu toꞌou oro gi! ");
INSERT INTO llu_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","<<Ma so ni tei na e haea fuana na tooa gi hasa nia e manata mamana ani nau, i nau ku haea urinae laugo fuana na Maa nau i langi. ");
INSERT INTO llu_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ma so ni tei na e kwaigoloi ani nau i maana tooa gi, i nau ku haea kwaigoloi ani nia laugo fuana na Maa nau i langi.>> ");
INSERT INTO llu_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ma a Jesus ka bae urii lau, <<Langi musi manata haea hasa nau ku lea mai uria ngalilana mai na fanualama fuana molaagali. Nau langi kusi ngalia mai fanualama. Nau ku lea mai eeri ni tei gera na langi gera kasi manata mamana ani nau, tara gera ka firu fai nia na tooa nau gi. ");
INSERT INTO llu_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","36","Na maalimaea nia wane, nia naa na aebara nia. Sulia tara wane daraa gi daka firu fai nia maa gera gi. Ma na geni haari gi daka firu fai nia ni tee gera gi. Haia, na geni fungao gi tara gera ka firu fai nia fungo gera gi. ");
INSERT INTO llu_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","<<So ni tei na e rakediana ana na maa nia ma langi ni tee nia liufi nau, nia langi kasi faoragu. Ma so ni tei na e rakediana ana na wela nia gi ka liufi nau, nia langi kasi faoragu. ");
INSERT INTO llu_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ma so ni tei na kasi ngalia na airarafolo ana nonifiilaa nia ma kasi lea suli nau, nia langi kasi faoragu. ");
INSERT INTO llu_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ma so ni tei na e hasi uria na mourilaa, tara ka mae, ma so ni tei na e lugasia na mourilana uri nau, tara nia ka mouri. ");
INSERT INTO llu_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","<<Ma so ni tei na ka gonitai gamu, nia ka gonitai nau laugo. Ma so ni tei na e gonitai nau, nia ka gonitainia laugo a God na e fale nau mai. ");
INSERT INTO llu_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ma so ni tei na ka gonitai nia na profet sulia na wane nae e rao fuana a God, tara nia ka ngalia na kwaiaraa iilingia na profet. Ma so ni tei na ka gonitainia na wane oꞌolo sulia na wane nae e oꞌolo, tara nia ka ngalia na kwaiaraa iilingia na wane oꞌolo. ");
INSERT INTO llu_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ma lea so ta wane ka falea si mae kafo gwari mone ana fuana ta tee wane ada na oote fafurongo nau naa gi, i sulia i nia na fafurongo nau, nau ku bae mamana ana fuagamu, i nia tara ka ngalia naa mone si kwaiaraa.>> ");
INSERT INTO llu_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Kada Jesus e faarai fuana aakwala ma roo fafurongo nia gi sui, nia ka lea lau uria ainitalongailana Faarongolaa Diana fai nia faatolomailana tooa ana maefera gi galigalia i seenae. ");
INSERT INTO llu_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Si kada a John Siuabu e too i laona na beu ni kanilaa, nia ka rongoa na raoa gi na Christ e iilia, ma nia ka oodua teni wane ana oote fafurongo nia gi daka lea siana Jesus. ");
INSERT INTO llu_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ma gera ledia daka bae urii, <<O faarongo mai. Ni oe naa na wane naa a John e haea tara ka dao mai, langi melu kwaimaasia lau amelu ta wane aai eꞌete?>> ");
INSERT INTO llu_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ma a Jesus e oolisida ka urii, <<Molu ooli, ma molu ka faarongoa a John ana si doo naa gi molu rongoda ma molu ka rikida. ");
INSERT INTO llu_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Na tooa gi na maada e rodo, daka aada lau. Ma na tooa gi na aeda e mae, daka fali lau. Ma na tooa gi na fura e labasida, na nonida ka mafo lau. Ma na tooa gi na aalingada e boko, daka rongo lau. Ma na tooa na da mae gi, daka mouri lau. Ma na Faarongolaa Diana baa, nau ku bae naa sulia fuana tooa siofaa gi. ");
INSERT INTO llu_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ma oilakea fuana ni tei na e langi kasi manata ruarua ani nau.>> ");
INSERT INTO llu_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Si kada na oote fafurongo nia gi a John da ooli naa, a Jesus ka bae sulia a John siagera na figua nae, ka urii, <<Si kada baa molu lea i laona na aanogwou siana a John, na taa baa molu manata hasa molu ka rikia? Tee wane e manata ruarua katau, iilingia na rade na e gelogelo ana ooru? Langi, John nia langi kasi wane urinae. ");
INSERT INTO llu_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Haia, na taa naa molu lea uria rikilana? Ta wane e oofi ana maku diana gi? Langi, sulia na tooa da oofi ana maku diana gi gera too ada i laona na luma diana gi. ");
INSERT INTO llu_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Na taa naa molu lea uria rikilana? Na profet? Iiuka! Ma i nau ku faarongo gamu, i gamu mu rikia na wane e liufia na profet gi. ");
INSERT INTO llu_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Sulia a John naa na wane na Kekedelaa Aabu e bae sulia ka urii, <A God e haea: I nia naa na wane ni ngali baea nau. Ma i nau ku fale nia i nao ani oe hai ka aade aagau ana tala fuamu.> ");
INSERT INTO llu_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nau ku bae fuagamu, a John Siuabu e baita ka liufia na tooa gi sui na da too i laona molaagali naa. Sui ka urinae boroi ana, ni tei na e toꞌou i laona na Initooa i Langi, nia naa e baita ka liufi nia. ");
INSERT INTO llu_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Haia, talaꞌae mai ana si kada John e hafalia ainitalo ana Faarongolaa Diana lea ka dao i taraꞌena, na tooa ramo gi da firu uria ruulaa i laona na Initooa i Langi. ");
INSERT INTO llu_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Na faatolomailaa sulia kwaieresia a Moses gi ma na faatolomaia gera profet gi gera bae mai sulia na Initooa a God, nia e too lea ka dao ana si kada John. ");
INSERT INTO llu_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Gera haea a Elaeja na profet tara ka ooli lau mai. Ma diana fuana molu ka manata mamana hasa a John nia na Elaeja baa. ");
INSERT INTO llu_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Molu fafurongo diana ana si baelaa nau nae gi. ");
INSERT INTO llu_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","<<Haia, gomolu na tooa gi na molu too ana si kada naa, molu eꞌete asianaa! Molu iilingia roo bubulutaa ana gala wela gi gera gwouru i maana na uusia ma gera ka rii fuada kwailiu urii, ");
INSERT INTO llu_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","<Gemelu, kada melu nguulia nguu ana eelea, langi molu si wae go! Haia, ana si kada melu nguulia nguu ana liobukonua, gomolu si liobukonu go, ma langi molu si aangi go!> ");
INSERT INTO llu_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Gomolu urinae, sulia ana si kada John e lea mai, nia e aabu fangaa ma nia ka langi si gwou waen. Ma na tooa gi daka uga ma gera ka bae urii, <Na wane na e too ana tee aagalo taꞌa.> ");
INSERT INTO llu_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Nia e urinae laugo sulia ana si kada nau, na Wela nia Iimola gi, nau ku lea mai, nau ku haitamana kuka fanga ma kuka gwou waen. Ma na tooa gera ka bae laugo urii, <Molu rikia! Nia haitamana fangalaa baita asianaa, ma ka gwou baita asianaa ana waen! Ma na ruana nia gi na gera tooa taꞌa iilingia tooa faafefe gi na da liu uria koni malefolaa ana takisi.> Haia, ma nau ku haea fuagamu, na tooa gi na da roosulia na liotooa a God, daka faatainia a God naa nia e oꞌolo.>> ");
INSERT INTO llu_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Buira Jesus bae urinae sui, nia ka talaꞌae uria bae ngatafilanalaa na maefera baa gi nia iilia mai na doo oro ana na kwaibalatana gi ana, sulia tooa ana maefera nae gi gera lalafusia oolitai manatalaa faasia taꞌalaa gera gi. ");
INSERT INTO llu_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Jesus ka bae urii, <<Kwaimanatai fuana tooa ana roo maefera i Koresin ma i Betsaeda. Kwaimanatai fuagamu sulia langi molu si oolitai manata. Na doo kwaibalatana gi ku iilida mai lao fera gamu gi, lea so nau ku iilida mai i Taea ma i Saedon urinae, tooa gi seenae gi gera ka aangi naa fuana God nae, eeri ka faamouri gera faasia na taꞌalaa gera gi. Ma lea so urinae, gera ka oofi ana maku taꞌa gi ma gera ka uusubili ana nonida ana fua eeri daka faatainia oolitai manatalaa gera. ");
INSERT INTO llu_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Doo mamana na nau ku haea fuagamu, ana fe dani tara God nia ka ketoa tooa, tara nia ka kwae gamu ka baita liufia tooa baa faasia i Taea ma i Saedon. ");
INSERT INTO llu_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Haia, ma fuagamu tooa i Kapaneam, sui boroi ana molu doori baelafelamolu i talamolu fui langi, tara God ka ui ani gamu fuana gula ana maea. Sulia na doo kwaibalatana baa gi ku iilida i maefera gamu gi, lea so kuka iilia mai urinae i Sodom, boro tooa i Sodom daka oolitai manata ma na fera gera ka too ua go ana. ");
INSERT INTO llu_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Nia naa, nau ku haea fuagamu ana fe dani na tara God ka ketoa ana tooa gi sui, tara si kwakwaelaa na tara God ka falea fuana tooa i Sodom tara ka toꞌou faasia si kwakwaelaa na tara nia ka falea fuagamu.>> ");
INSERT INTO llu_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ana si kada nae, a Jesus e fooa ka bae urii, <<Maa ae, ni oe na Lord usia i langi ma na molaagali, i nau ku baelafe oe, sulia o haufinia si doo naa gi faasia na tooa liotoo gi ma na tooa haitamadoo gi. Ma o faatainia amu fuada na tooa na langi dasi haitamadoo gi. ");
INSERT INTO llu_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Iiuka Maa ae, na doo nae gi e urinae sulia na kwaidooria oe.>> ");
INSERT INTO llu_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ma Jesus ka bae urii fuana na figua, <<Na Maa nau e falea sui naa na doo gi sui fuagu. Ma e langi ta wane kasi haitamagu, na Wela nia, taifilia na Maa go ana naa e haitamagu. Ma e langi ta wane kasi haitamana go na Maa, taifili nau, na Wela nia go ana, ku haitamana, ma taifili gera laugo na ku filida uria na faatailanalaa fuada. ");
INSERT INTO llu_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","<<I gamu sui na mu makeso i sulia na mu ngali gulua, muka lea mai siagu, eeri kuka falea na mamalolaa fuagamu. ");
INSERT INTO llu_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ma muka adomi nau uria na raolaa nau, ma tara kuka faatolomai gamu, sulia na liogu e neena ma ka harofaia, ma muka daotoona na mamaloa fuana na mango miu. ");
INSERT INTO llu_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Sulia na raoa na ku falea fuagamu e halahala ma ka waluda.>> ");
INSERT INTO llu_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Haia, ana si kada nae ana tee maedani Sabat, Jesus fai nia oote fafurongo nia gi da lea, ma daka liu folosia tee raoa ana witi na doo iilingia raes. Ma ana si kada nae, oote fafurongo nia gi da fiolo, ma gera ka fusia funge doo gi, ma gera ka ania. ");
INSERT INTO llu_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ma teni wane ana Farisi gera rikida. Ma gera ka ngatafia Jesus daka urii, <<Oe rikia! Na fafurongo oe gi da iilia si raolaa ana maedani Sabat na kwaieresia golu nia e bae luia!>> ");
INSERT INTO llu_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ma Jesus e oolisida ka urii, <<Utaa? Gomolu iidumia taa baa David e iilia laugo i nao, ma e langi go? Haia, tee mae dani, David fai nia oote wane ana oomea nia gi, gera fiolo asianaa. ");
INSERT INTO llu_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ma a David ka ruu laona Beu Aabu nia a God, nia fai nia oote wane nia gi gera ka ania beredi aabu. Haia, ma si doo naa langi kasi oꞌolo ana kwaieresia gi sulia taifili gera fataabu gi go ana na gera haitamana anilana beredi nae.>> ");
INSERT INTO llu_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ma Jesus ka bae lau ka urii, <<Utaa? Gomolu si iidu go si kwaieresia gi sulia fataabu gi baa gera rao laona Beu Aabu a God ana maedani Sabat? Gera lau go gera si roosulia na kwaieresia sulia na maedani Sabat. Sui, nia diana go ana. ");
INSERT INTO llu_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Haia, nau haea fuagamu doo baita ka tasa liufia na Beu Aabu a God, nia e nii naa i seegi fai gamu. ");
INSERT INTO llu_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Haia, God nia bae urii, <I nau ku dooria na rakediana gamu, langi lau na kwaisuusilaa gamu gi ana doo kwasi gi.> Ma lea so molu ka haitamana si malutana si doo naa, nia afetai fuana molu ka ketoa tooa nau gi na langi gera si garo go. ");
INSERT INTO llu_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Sulia nau, na Wela nia Iimola gi, nau naa na Lord usia maedani Sabat.>> ");
INSERT INTO llu_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ma si kada a Jesus e lea faasia si gula naa, nia ka lea i laona tee Beu ni figulaa. ");
INSERT INTO llu_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ma tee wane abana e mae e too i seenae lao Beu nae. Ma teni wane da soeledia Jesus daka urii, <<Utaa? Nia bobola go ana fuana guralana wane matai gi ana Sabat?>> Gera soeledia urinae eeri gera ka daotoona tesi doo uria feengilana Jesus ana. ");
INSERT INTO llu_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ana si kada nae, Jesus ka soeledi gera lau urii, <<Molu faarongo nau fasi, lea ta wane agamu ta sipsip ana e asia laona ta kilu ana Sabat, nia ka lafia ana fe dani nae, ne baa? ");
INSERT INTO llu_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Gomolu haitamana a God manata hasa wane nia na tofungae doo liufia na sipsip. Haia, sulia wane nia na tofungae doo urinae, nia e langi si garo uria iililana tesi doo diana fuana ma adomilana ta wane ana Sabat.>> ");
INSERT INTO llu_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ana si kada nae ua go, Jesus ka kari aabulo fuana wane na abana e mae, ka bae urii, <<O tekwala abamu.>> Ma wane nae e tekwala na abana. Ma ana si kada nae ua go, na abana baa e mae ka diana laugo ana iilingia ruana bali aba aai. ");
INSERT INTO llu_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ma ana si kada Farisi gi gera rikia si doo naa, gera ka haga teefou i maa. Ma gera ka bae oofu naa uria haungilana Jesus. ");
INSERT INTO llu_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Si kada Jesus e rongoa go ana na gera bae oofu eeri gera ka haungia, nia ka lea naa faasia fera nae. Ma na tooa oro gera ka lea sulia Jesus, ma nia ka guraa tooa oro na da matai, ma daka akwaa teefou. ");
INSERT INTO llu_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ma Jesus ka bae luida langi gera si uunuunu suli nia siana ta wane lau. ");
INSERT INTO llu_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Nia ka iili urinae eeri ka faamamanaa na baelana God baa profet Aesea nia haea ka urii, ");
INSERT INTO llu_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","<<Na wane naa, nau ku aadafilia eeri ka iilia raoa nau laona molaagali. Nau ku rakediana fuana, ma kuka eele asianaa sulia. Tara kuka oodua kou na Aanoedoo nau eeri ka too fai nia. Haia, na wane naa nia ka faatainia doo oꞌolo gi fuagera tooa maadiu gi faasia gera Jiu. ");
INSERT INTO llu_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nia langi kasi too susuala ma langi kasi rii tekwa ma nia tara langi kasi bae rereba ana sulia tala baita gi. ");
INSERT INTO llu_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nia tara langi kasi eekwatainia na tooa siofaa ma tooa makeso. Ma tara nia ka tasa dongaa rao ka dao ana si kada nia olosia sui na doo gi fuana na tooa. ");
INSERT INTO llu_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ana na wane naa, tooa oro faasia na fera gi sui, tara gera ka manata mamana ana. ");
INSERT INTO llu_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Sui i buira, teni tooa da ngalia mai tee wane siana Jesus uria guralana. Wane naa, aagalo taꞌa e susuku ana ma na maana ka rodo ma fakana ka ato. Ma Jesus ka guraa na wane nae, ma nia ka aada ma ka babae naa lau. ");
INSERT INTO llu_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ana si kada doo nae liu ana, tooa gi gera ka kwele asianaa, ma gera ka ledi gera kwailiu, <<Utaa? Na wane naa nia na wane baa na a God e aadafilia ma tara ka futa mai ana aebara David na aaofia oto na?>> ");
INSERT INTO llu_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ma si kada teni Farisi gi da rongoa si doo nae gi, gera ka bae urii, <<Langi go. Langi lau ni nia naa. Nia e tari aagalo go ana sulia Bielsebul na naofe wane ana aagalo gi na e falea na mamanaa nae fuana aadelana si doo nae gi.>> ");
INSERT INTO llu_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Sui Jesus nia haitamana go ana si manata gi i lioda, ma nia ka bae urii fuada, <<Lea so na tooa faasia tee maefera gera ka firu fai gera kwailiu, tara gera ka labasi gera i talada. Ma lea so tooa ana tee aebara go na gera ka firu fai gera kwailiu, tara gera ka labasi gera i talada laugo nae. ");
INSERT INTO llu_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Haia, a Satan e urinae laugo. Lea ta bubulutaa ana a Satan ka firu fai nia ta bubulutaa aai a Satan laugo, tara daka tagala kwailiu naa, ma tara gera ka labasida i talada. ");
INSERT INTO llu_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","<<Haia, molu haea a Bielsebul ka falea na mamanaa fuagu eeri kuka tari aagalo ana. Haia, ma na mamanaa ni tei mone ana na molu haea na tooa gamu gi gera tari aagalo ana? Nia faatainia gomolu garo asianaa. ");
INSERT INTO llu_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","<<Nau ku haea fuagamu, e langi lau Bielsebul na e falea na mamanaa fuagu eeri kuka tari aagalo ana naa. Aanoedoo nia a God na e falea na mamanaa na fuagu, ma nia ka faatainia fuagamu na Initooa nia God e dao na mai faafi gamu. ");
INSERT INTO llu_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","<<Haia, lea so ta wane ka dooria lealaa i laona luma nia ta wane rigita uria belilana tesi doo diana nia gi, taa naa tara nia ka aadea? Nia ka kani faafia wane rigita naa fasi suifetei nia kafi ruu laona luma nia ma kafi ngalia doo nia gi lao luma nia. Haia, si doo nae na ku aadea ana Satan. ");
INSERT INTO llu_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","<<Ni tei na e langi kasi lea fai nau, nia naa na maalimaea nau. Ma ni tei na langi kasi rao oofu fai nau uria talailana mai teni tooa gi siana a God, nia naa e tagalangai nia tooa nau gi. ");
INSERT INTO llu_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","32","Sulia nia urinae, nau ku haea fuagamu, doo taꞌa gi sui go na wane e aadea ma na doo taꞌa nia ka haea, tara God haitamana ka manata lukea. Ma lea ta wane ka bae taꞌa fuagu na Wela nia Iimola gi, tara God e haitamana ka manata lukea. Haia, ma so ni tei na e bae tataga ana Aanoedoo Aabu, God tara ka langi si manata lukea naa, sui boroi ana si kada naa, langi tesi kada ka nii ua mai.>> ");
INSERT INTO llu_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","A Jesus ka bae lau urii, <<Gomolu haitamana lea molu too ana ai diana, na fufuana boro ka diana laugo. Ma lea molu too ana ai taꞌa, na fufuana boro ka taꞌa naa laugo. Urinae laugo ana tooa. Sulia doo diana gi e lea mai faasia na tooa diana, ma doo taꞌa gi e faasia na tooa taꞌa. ");
INSERT INTO llu_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Haia, ma ni gamu mu uusulia na loi gi. Ma afetai asianaa molu ka haea tesi doo ka diana, sulia na manatalaa gamu gi e taꞌa. Si taa naa e too laona manatalaa wane, nia naa e hagatafa mai na wane e faarai ana. ");
INSERT INTO llu_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Na wane nae e diana, na baelana laugo tara ka diana. Ma na wane na e taꞌa, na baelana laugo ka taꞌa. ");
INSERT INTO llu_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","<<Nau ku haea fuagamu, si kada ana keketolaa, God tara ka ketoa tooa gi sui lao molaagali fuana si baelaa taꞌa gi gera haeda. ");
INSERT INTO llu_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ma tara a God ka ketoa tooa ana baelada i talada. Lea baelaa nia ta wane e diana, a God kasi kwae nia. Ma lea baelaa nia ta wane e taꞌa, a God tara ka kwae nia.>> ");
INSERT INTO llu_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Sui teni faatolomaia ana kwaieresia gi ma teni Farisi, gera lea mai siana Jesus, gera ka bae urii fuana, <<Faatolomai ae, gemelu dooria asianaa oko aadea ta mamalafooa kwaibalatana eeri mika rikia agami.>> ");
INSERT INTO llu_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","A Jesus ka bae urii fuada, <<Gomolu na tooa na molu too i laona molaagali si kada nae, molu iilia asianaa doo taꞌa oro gi, ma langi molu si manata naa fuana a God! Molu ka dooria rikia na mamalafooa. Nau langi kusi aadea go ta mamalafooa fuagamu. Ma na mamalafooa tara molu ka rikia na doo na e iilingia na doo baa na e fuli fuana profet Jona i nao. ");
INSERT INTO llu_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","A Jona e too laona rakena gwasasu sulia oolu fe dani ma oolu fe rodo. Haia, ma ni nau, na Wela nia Iimola gi, tara kuka urinae laugo. Tara nau kuka too laona gano sulia oolu fe dani ma oolu fe rodo. ");
INSERT INTO llu_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ma ana si kada tara a God e ketoa na tooa gi, na tooa na da too i Niniva tara da take eeri gera ka uunuunu sulia na garolaa gamu gi. Tara gera aade urinae, sulia gera oolitai manata naa faasia na taꞌalaa gera gi ana si kada Jona e funao ana fuagera. Ma tee wane e baita ka liufia Jona nia too na i see fai gamu. Sui ka urinae boroi, gamu langi musi oolitai manata faasia na taꞌalaa gamu gi. ");
INSERT INTO llu_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Haia, ma na aaofia geni i Siba, tara nia e take laugo uria uunuunulaa sulia na garolaa gamu. Inite aai naa nia aade urinae sulia nia lea mai faasia fera nia na e tau uria na rongolana Solomon na aaofia. Ma tee wane e baita liufia a Solomon e too go ana fai gamu. Sui ka urinae boroi ana, gomolu langi molu si dooria go na rongolana.>> ");
INSERT INTO llu_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","A Jesus ka bae urii lau, <<Ana si kada aagalo taꞌa e lea ana faasia na wane, nia ka lea ma ka liu go ana lao fera aanogwou eeri ka nani uria si gula ni mamaloa nia. Ma lea nia e langi si daotoona tesi gula, ");
INSERT INTO llu_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","nia ka bae urii fuana i talana, <Nau ku ooli naa agu uria si gula nau baa ku lea mai faasia.> Haia, nia ooli mai dao, ka rikia gula nia baa gera olosia ma gera ka salofia sui naa, ma ka gwou go ana. ");
INSERT INTO llu_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Sui nia ka lea, ma ka ooli ka talaia lau mai ta fiu aagalo na da taꞌa asianaa liufi nia. Daalu lea mai, daalu ka ruu lau i laona wane baa. Ana si kada urinae, wane baa kafi taꞌa ka tasa liufia baa i nao. Haia, tara nia ka urinae laugo fuagamu na tooa taꞌa na mu too i laona molaagali ana si kada naa.>> ");
INSERT INTO llu_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ana si kada Jesus e faarai ua fuana tooa gi, ni tee nia fai nia oote haasina gi gera ka dao mai. Ma gera ka take go ada i maa, ma gera ka soe mai uria hai gera ka faarai fai nia. ");
INSERT INTO llu_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ma tee wane ana tooa nae ka bae urii fuana Jesus, <<Ni tee oe fai nia oote haasimu gi gera take go mai ada i maa, ma daka doori faarai fai oe.>> ");
INSERT INTO llu_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jesus ka oolisia urii, <<Nau ku haea ni tei naa ni tee nau ma na haasigu gi.>> ");
INSERT INTO llu_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ana si kada nae, Jesus ka susu fuana oote fafurongo nia gi, ma ka bae urii, <<Gamu riki fasi. Gera naa da iilingia na tee nau gi ma na haasigu gi. ");
INSERT INTO llu_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Sulia so ni tei naa e aade sulia si kwaidooria a Maa nau mai langi, nia na haasigu, ma na waiwane nau, ma ni tee nau.>> ");
INSERT INTO llu_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ana fe dani nae laugo, a Jesus e haga kou faasia luma nae, ma e lea i ninimana na aasi, ma ka gwouru uria faatolomailaa. ");
INSERT INTO llu_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ma sulia na figua baita asianaa gi da figu gali nia, nia ka tae i laona tee baru, ma ka gwouru i laona, ma na tooa gi daka take kou i hara. ");
INSERT INTO llu_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Sui i nia ka faarongo gera ana doo oro gi ana si baea oomelawanelaa gi, ka urii, <<Tee wane e lea uria na fasilana mige doo nia gi i laona raoa nia. ");
INSERT INTO llu_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ma ana si kada nia tagalangainia mige doo gi, teni mige doo gi daka asi gera sulia na tala, ma na manu gi da lea mai ma daka ani teefou ana. ");
INSERT INTO llu_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ma teni mige doo gi lau daka asida ana si gula foulaa gi, si gula na hae gano kasi oolo. Ma daka bulao aliꞌali mai, sulia na hae gano e rauraua. ");
INSERT INTO llu_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ma si kada na hato e tae mai, e hatofia, ma daka kuku, sulia e langi dasi too ana ta lali doo rigita. ");
INSERT INTO llu_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ma teni mige doo gi aai da asida i matangana na kwaletotore gi, na e tae ma ka nuku faafia na ai gi. ");
INSERT INTO llu_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","9","Ma teni mige doo gi lau da asida i laona hae gano diana, ma da tae daka fungu. Teni funge doo gi da too ana tee talange mige doo gi, ma teni funge doo aai daka too ana oono finite mige doo gi, ma teni mige doo gi lau da too ana oolu finite mige doo gi. Muka manata diana sulia si oomelawanea nae.>> ");
INSERT INTO llu_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Na oote fafurongo nia gi da lea mai siana, ma daka ledia urii, <<Uria taa na o bae fuana na tooa gi ana si baea oomelawanea gi?>> ");
INSERT INTO llu_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","A Jesus e oolisida ka urii, <<Nau ku lukea naa na doo haufini gi sulia na Initooa i Langi fuagamu, sui fuagera naa ka langi. ");
INSERT INTO llu_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ma so ni tei na e too ana doo gi, a God tara ka fale baita ana, eeri nia ka too ana doo oro ka fono go. Ma so ni tei na e langi kasi too ana tesi doo, a God ka lafua faasi nia si taa toꞌou na e too ana faasi nia. ");
INSERT INTO llu_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Haia, i nau ku bae fuada ana si baea oomelawanelaa gi, eeri ana daka aada, e langi dasi rikia, ma boroi ana daka fafurongo, e langi dasi haitamana go. ");
INSERT INTO llu_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","<<God e bae i nao suli gera ana si kada a Aesea e kedea ka urii, <I gera da fafurongo, sui taa, e afetai daka haitamana. Ma i gera ka aada, sui taa, e afetai daka rikia. ");
INSERT INTO llu_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Sulia na manatada e rorodoa ana, ma daka gutaa ada na aalingada, ma daka maa afu ada. Lea langi, daka rikia ana na maada, ma daka rongoa ana na aalingada, ma daka haitamana ana na lioda, ma daka aabulo uri nau, ma i nau kuka faamouri gera.>>> ");
INSERT INTO llu_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ma a Jesus ka bae lau urii, <<E oilakea asianaa fuamolu, sulia na maamolu e aada, ma na aalingamolu daka fafurongo. ");
INSERT INTO llu_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Doo mamana nau ku haea fuagamu, na profet oro gi ma na wane oꞌolo gi da doori rikilana si doo naa gi mu rikida, sui ka langi dasi rikia, ma da dooria na rongolana na doo naa gi gamu rongoda, ma e langi dasi rongoa. ");
INSERT INTO llu_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","<<Muka fafurongo naa uria na malutana si baea oomelawanea na sulia na wane na e fafasi. ");
INSERT INTO llu_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Teni tooa na da rongoa na faarongolaa sulia na Initoo i Langi, sui langi dasi haitamana, sulia a Satan e lea mai, ma ka laua na baelana a God na gera rongoa. Gera iilingia na mige doo na da asida sulia na tala ma na manu gi daka ania. ");
INSERT INTO llu_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ma na gano foulaa, nia iilingia na tooa gi na da rongoa na baelana a God, ma daka ngalia naa, ma daka noni hahala uria. ");
INSERT INTO llu_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Sui taa, na manata mamanalaa gera e langi si ngado iilingia na lalina ai e langi si rigita. Nia naa si kada taꞌalaa ma langi faanonifiilaa e dao mai sulia na faarongolaa baa, gera ka lugasia na baelana a God naa. ");
INSERT INTO llu_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ma teni tooa gera rongoa na faarongolaa baa, ma daka manata mamana. Sui gera manata aꞌabo ka tau uria na mouria ana si kada naa lao molaagali, ma daka rakediana ana malefo. Nia na aadea langi dasi iilia na doo diana gi. Gera iilingia na mige doo na e tae i matanga na kwaletotore ma langi kasi fusia na funge doo. ");
INSERT INTO llu_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ma teni tooa da rongoa na faarongolaa, ma gera ka haitamana, ma daka iilia doo diana oro gi. Gera iilingia na mige doo gi na e tae i laona hae gano diana. Ma nia ka fungu ana funge doo gi, teni funge doo daka too ana na talange mige doo, ma teni funge doo da too ana na oono finite mige doo, ma teni funge doo aai da too ana na oolu finite mige doo.>> ");
INSERT INTO llu_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","A Jesus ka haea lau tee oomelawanea aai fuada, ka urii, <<Na Initooa i Langi e iilingia na wane na e fasia na mige doo nia gi i laona na raoa nia. ");
INSERT INTO llu_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ma ana tefe rodo, si kada na tooa gi da teo ada, na maalimaea nia e lea mai ma ka fasia teni mige lolo taꞌa gi i matangana na mige doo diana nia gi. Sui nia ka lea na ana. ");
INSERT INTO llu_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ma si kada na mige doo diana gi da bulao mai ma daka hafali fungu, na mige lolo taꞌa baa gi daka bulao laugo. ");
INSERT INTO llu_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Na wane ni rao nia gi daka lea mai siana, ma daka ledi urii, <Aarai ae, ni oe o fasia na mige doo diana gi baa. Sui na lolo loko gi e lea mai faasia i fai?> ");
INSERT INTO llu_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ma nia e oolisida ka urii, <Ta maalimaea naa e iilia si doo nae.> Ma na wane ni rao nia gi daka ledia urii, <Ni oe o dooria melu lea ma melu ka failia na lolo gi?> ");
INSERT INTO llu_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Nia e oolisida ka urii, <Langi, aata ana si kada molu failia na lolo loko gi, molu ka labasia laugo teni ai diana gi fai nia. ");
INSERT INTO llu_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Molu aalu daaro tae oofu na adaaro lea ka dao ana si kada ni gonidoolaa. Ma ana si kada nae, nau tara kuka haea fuana na wane gi na da gonidoo kuka urii: Molu kwaia na lolo gi i nao, ma molu ka kani oofulangaida ma molu ka suungia. Sui molu ka kwaia na doo diana gi ma molu ka ngalia mai fui i laona babala ni taingaia nau.>>> ");
INSERT INTO llu_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Sui a Jesus ka haea lau tee oomelawanea ka urii, <<Na Initooa i Langi e urii: Tee wane e ngalia mige ai toꞌou asianaa, na gera alangia ana mastad, ma ka fasia i laona na raoa nia. ");
INSERT INTO llu_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ma sui boroi ana na mige doo naa ka toꞌou asianaa ana na mige doo gi sui, si kada e tae mai, nia ka hau ana na ai baita ana ai gi sui i laona na raoa nae. Ma si kada e hau ana na ai baita, na manu gi daka tolea ada na nui gera gi ana na harana ai nae.>> ");
INSERT INTO llu_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Sui a Jesus ka bae lau ana si oomelawanea aai ka urii, <<Na Initooa i Langi e iilingia na iisi uria na faafufulana na beredi. Na geni e ngalia ma ka dolalia ana na fulaoa lelea na kumu nae ka fufu go.>> ");
INSERT INTO llu_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","A Jesus e bae sulia na doo naa gi sui go fuada na figua ana si oomelawanea gi. ");
INSERT INTO llu_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Nia iili urinae eeri ka faamamanaa si baelaa a God na profet e kedea ka urii, <<I nau tara ku bae ana si oomelawanea gi fuana tooa gi. Ma tara kuka haea si doo gi na e aagwa e hafalia ua mai ana si kada ku haungainia ana na molaagali.>> ");
INSERT INTO llu_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Sui a Jesus ka tafusia na figua nae ma ka ruu i luma. Ma na oote fafurongo nia gi daka dao mai siana ma daka bae urii, <<O inifitaa fasi fuagami na oomelawanea baa sulia na lolo nae gi i laona na raoa.>> ");
INSERT INTO llu_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","I nia e oolisida ka urii, <<Na wane na e fasia na mige doo diana gi, nia naa ni nau, na Wela nia Iimola gi. ");
INSERT INTO llu_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ma na raoa naa na molaagali, ma na mige doo diana naa na tooa nia gi na Initooa i Langi. Ma na lolo gi nae na tooa nia gi a Satan. ");
INSERT INTO llu_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ma na maalimaea na e fasia na lolo gi, nia naa a Satan. Ma si kada ana gonidoolaa naa na suilana na molaagali, ma na wane naa gi da gonidoo naa na ensel gi. ");
INSERT INTO llu_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Si kada na wane ni rao gi da gonia na lolo gi ma daka suungia i laona na eere, ka urinae laugo ana suilana na molaagali. ");
INSERT INTO llu_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Tara nau ku oodua na ensel gi, ma daka gonia tooa gi sui na da iilia doo taꞌa gi ma na tooa gi na da faagaroa na tooa aai gi, ma na ensel gi daka lafuda faasia na initooa nau. ");
INSERT INTO llu_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ma gera daka ui ani gera i laona eere, si gula na tara gera ka aangi ma daka girigiria na lifoda. ");
INSERT INTO llu_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Haia, na tooa oꞌolo gi daka sina iilingia na hato i laona na Initooa nia na Maa gera. Molu ka manata diana sulia na doo nae.>> ");
INSERT INTO llu_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","A Jesus ka bae laugo urii fuada na oote fafurongo nia gi, <<Na Initooa i Langi e iilingia na malefo baita na e too aagwa i laona na raoa. Ma si kada tee wane e rikia, nia ka aagwatainia laugo ana. Ma nia ka eele asianaa, ma ka lea ma ka faafoli ana na doo nia gi sui, ma ka folia na raoa nae, eeri ka too ana na malefo baita nae. ");
INSERT INTO llu_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","<<Haia, na Initooa i Langi ka iilingia laugo na wane fofoli na e nani uria na doo diana gi na e liu baita. ");
INSERT INTO llu_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Si kada nia ka daotoona tefe doo na liulana ka baita asianaa, nia ka lea, ka faafoli ana na doo nia gi sui, ma kafi folia. ");
INSERT INTO llu_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","<<Na Initooa i Langi e iilingia laugo na furai na da dee ana i laona na aasi ma daka kwaia ana iia kwalukaela eꞌete gi sui. ");
INSERT INTO llu_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ma si kada e fungu, na wane gi na daka dee da lakwainia i hara, ma daka gwouru i hae gano. Sui daka gonia na iia diana gi laona koko gi, ma daka ui ania na iia aai taꞌa gi. ");
INSERT INTO llu_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Nia ka urinae laugo ana suilana na molaagali. Na ensel gi da lea mai, ma daka tolingia na tooa taꞌa gi faasia na tooa diana gi. ");
INSERT INTO llu_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ma na tooa taꞌa gi, daka ui ani gera i laona na eere, ma i seenae gera ka aangi ma daka girigiri lifo.>> ");
INSERT INTO llu_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Sui a Jesus e ledida ka bae urii, <<Gomolu molu haitamana si doo nae gi?>> Ma gera oolisia daka urii, <<Iiuka.>> ");
INSERT INTO llu_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ma a Jesus ka bae urii fuada, <<Nia naa na wane faatolomai gi sui ana na kwaieresia gi na da hau ana na wane fafurongo ana na Initooa i Langi, da iilingia na wane na e too ana na luma ma ka ngalia mai na doo faalu gi fai nia na doo kwali gi faasia si gula ni taingaia nia.>> ");
INSERT INTO llu_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ana si kada Jesus e baea ana si oomelawanea nae gi sui, nia ka lea naa faasia maefera nae. ");
INSERT INTO llu_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ma nia ka ooli lau mai ana maefera nia. Ma nia ka lea i laona Beu Aabu ni figulaa uria faatolomailana tooa. Ma ana si kada tooa gi da rongoa, gera ka kwele asianaa, ma gera ka bae urii, <<Na haitamadooa nia e ita mai faasia i fai? Ma ni tei naa e falea mamanaa fuana uria aadelana doo kwaibalatana naa gi? ");
INSERT INTO llu_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Golu haitamana go agolu wane naa nia na wela a Josef go ana, na wane ni haitamana haungailana doo gi ana ai gi, ma tee nia ni Mary. Na haasina gi na a James, Josef, Simon, ma Judas go ana. ");
INSERT INTO llu_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ma na waiwane nia gi gera too go ada fai golu i see. Utaa na nia ka liotoo asianaa urii?>> ");
INSERT INTO llu_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ma ana si kada nae, gera ka oote gera ana a Jesus. Sui Jesus ka bae urii fuada, <<Na profet e afetai fuana wane futa nia gi fai nia na wane aefera nia gi, gera ka manata baita ana nia. Tooa eꞌete ana taari haitamana gera ka manata baita ana.>> ");
INSERT INTO llu_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ma a Jesus ka langi si aade doo kwaibalatana oro gi ana maefera nia, sulia na tooa naa gi gera oote gera manata mamana ana. ");
INSERT INTO llu_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Haia, ana si kada nae, a Herod Antipas na aaofia i Galili, nia e rongoa faarongolaa sulia Jesus, ");
INSERT INTO llu_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ma nia ka bae urii fuana tooa na gera rao fai nia, <<Wane naa nau ku rongoa faarongolaa sulia naa i nia a John Siuabu oto naa, e mouri lau. Na nia naa ka too ana mamanalaa uria iililana doo kwaibalatana nae gi.>> ");
INSERT INTO llu_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Si kada John e mouri ua ana, Herod naa e aadea ni Herodias na afe nia na haasina a Filip. Ma a John langi kasi aalafaafia, ma ka ngatafia Herod. Nia naa a Herod ka oodua teni wane eeri gera ka dumulia John ma gera ka kani nia, ma daka aalua lao beu ni kanilaa. Herod e iilia si doo naa sulia na afe nia Herodias naa e dooria. ");
INSERT INTO llu_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ana si kada John e too lao beu ni kanilaa, Herod ka dooria uria haumaelilana, sui ma ka mou ana tooa gi, sulia gera haea a John nia ta wane ana profet gi. ");
INSERT INTO llu_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Sui ana, tefe maedani, Herod ka haungainia tee fafangaa baita uria manatatoolana fe maedani nia futa ana. Ana fafangaa nae, na haari ni Herodias e lea mai ka wae fuana Herod fai nia oote ruana nia gi eeri gera ka bubungia. Si kada Herod e rikia haari na e wae, nia ka eele asianaa fuana. ");
INSERT INTO llu_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ma nia ka bae aalualu naa fuana haari nae urii, <<Nau tara kuka falea tesi taa go ana na o gani nau uria.>> ");
INSERT INTO llu_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Haia, ni tee nia na haari naa e faarongoa haari nia ka bae urii, <<Haia, o gani, oko bae urii, <Nau ku dooria o falea mai gwouna a John Siuabu fuagu ana si kada nae naa. Oko aalua mai fafona ta karao.>>> Ma na haari naa e iili urinae. ");
INSERT INTO llu_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ma si kada Herod e rongoa si doo naa, nia ka liobukonu asianaa. Sui boroi ana, nia ka iilia naa mone ana, sulia i nia e bae aalualu ma na oote ruana nia gi gera ka rongoa sui naa. ");
INSERT INTO llu_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ma nia ka oodua oote wane rao nia gi lea daka olea mai gwouna a John Siuabu lao beu ni kanilaa. ");
INSERT INTO llu_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ma gera ka ngalia mai gwouna John fafona karao ma gera ka falea naa fuana haari ni Herodias. Ma na haari naa e ngalia ka falea naa fuana ni tee nia. ");
INSERT INTO llu_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Kada oote fafurongo a John gi da rongoa si doo naa, gera lea mai, gera ka ngalia nonina uria aalulana lao na kwaingeia. Sui, gera lea gera ka faarongoa a Jesus ana. ");
INSERT INTO llu_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Si kada a Jesus e rongoa si doo nae e fuli sulia a John, nia ka tafusia si gula nae, ma ka lea taifili nia ana baru uria si gula na e langi ta wane kasi too ana. Na tooa gi da rongoa si doo naa a Jesus e iilia, ma gera ka tafusia na fera gera gi, ma da fali i buira sulia tala. ");
INSERT INTO llu_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ma si kada a Jesus e oolo ma ka rikia na figua baita, nia ka kwaimanatai fuada, ma ka guraa na tooa gi ani gera na da matai. ");
INSERT INTO llu_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ma i haulafia nae, na oote fafurongo nia gi da lea mai siana, ma daka bae urii, <<Si gula nae e langi si too garangia ta fera, ma ka garangi rodo naa. O oodua na figua naa eeri daka lea na ada, hai daka lea ada uria na maefera gera gi uria folilana ada tesi fanga.>> ");
INSERT INTO llu_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","A Jesus e oolisida ka urii, <<Gera dasi lea. Gomolu naa molu falea tesi fanga uria anilana.>> ");
INSERT INTO llu_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ma gera oolisia urii, <<Gemelu melu too go ana lima fe beredi ma roo gwe iia.>> ");
INSERT INTO llu_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ma a Jesus ka bae urii fuada, <<Molu ngalida mai i seenaa siagu.>> ");
INSERT INTO llu_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ma nia ka oodua na tooa gi daka gwouru i aano i fafona na laua. Sui nia ka ngalia na lima fe beredi baa gi ma roo gwe iia baa gi. Ma ka aada alaa uria i langi, ma ka tangoa a God. Sui i nia ka niia fe beredi nae gi, ma ka falea fuada na oote fafurongo nia gi, ma daka tolingia fuada na tooa nae gi. ");
INSERT INTO llu_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Na tooa nae gi sui daka fanga lea daka aabusu naa. Sui na oote fafurongo nia gi daka gonia na fanga na e oore i laona tee aakwala ma roo koko lea ka fungu go. ");
INSERT INTO llu_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ma na tooa gi baa da fanga e bobola fai nia lima tooni wane, ma e langi dasi iidumia lau na geni ma na wela gi. ");
INSERT INTO llu_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","A Jesus e oodua na oote fafurongo nia gi daka tae i laona na baru ma daka lea i nao ani nia fui bali aasi aai, si kada nia e faaolia na tooa baa gi. ");
INSERT INTO llu_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ma i buira nia e faaolia na tooa baa gi, nia ka raa taifili nia i gwouna fe uuo uria na fooalaa. Ma ana fe rodo nae, i nia ka too ana taifili nia i seenae. ");
INSERT INTO llu_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ma si kada nae, na baru baa ka nia tau naa faasia i hara ma na nanafo gi ka kwaea sulia e naofia na ooru. ");
INSERT INTO llu_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ma ana kada rodo i ofaidani, a Jesus ka fali na mai i fafona na kafo, ma ka lea na mai siada. ");
INSERT INTO llu_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ma si kada gera riki nia e fali mai i fafona na kafo, daka mou asianaa. Ma i gera ka rii urii, <<Na aagalo!>> Ma gera ka aararai. ");
INSERT INTO llu_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ma aliꞌali a Jesus ka bae siada ka urii, <<Molu langi molu si mou! I nau go ana naa.>> ");
INSERT INTO llu_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ma a Peter e oolisia ka urii, <<Lord ae, lea so ni oe mamana naa naa, o bae mai suli nau hai kuka lea kou siamu i fafona na kafo naa.>> ");
INSERT INTO llu_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","A Jesus ka bae urii, <<O lea mai.>> Sui a Peter e sifo faasia na baru baa, ma ka hafali fali i fafona na kafo siana a Jesus. ");
INSERT INTO llu_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Sui ana si kada nia ka rikia na ooru e baita, nia ka mou ma ka hafali kuruu naa i laona na kafo. Ma nia ka rii ka urii, <<Lord ae, o faamouri nau!>> ");
INSERT INTO llu_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ma e aliꞌali go a Jesus ka fale aba kou fuana, ka dau ani nia, ma ka bae urii, <<Na fiitoolaa oe e toꞌou asianaa. Uria taa na oko manata ruarua?>> ");
INSERT INTO llu_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ma ana si kada daaro tae naa i laona na baru, na ooru ka aaroaro naa. ");
INSERT INTO llu_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Sui na tooa na da too i laona na baru, daka boururu i naona Jesus, ma daka bae urii, <<I oe na Wela nia a God mamana naa.>> ");
INSERT INTO llu_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ma si kada gera faafolo lao aasi, daka oolo ana tee maefera gera alangia ana Genesaret. ");
INSERT INTO llu_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ma na tooa gi ana maefera nae gera ka aada haitamana a Jesus. Ma gera ka fale baea fuana teni maefera gi lau sulia Jesus eeri tooa nae gi daka soea mai tooa matai gi gera ka lea mai siana. Ma gera ka ngalia mai tooa matai oro gi siana. ");
INSERT INTO llu_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ma na tooa na gera ka gania Jesus eeri so ka faalamainia na tooa matai nae gi gera ka hamosia mone ada na kakamuna na maku nia. Haia, ma ni tei gera na da hamosia maku nia, gera ka akwaa naa. ");
INSERT INTO llu_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Sui teni Farisi ma na faatolomai gi ana kwaieresia gi, gera ka lea mai faasia i Jerusalem siana Jesus uria soeledilanalaa. ");
INSERT INTO llu_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Gera ka bae urii, <<Utaa na oote fafurongo oe gi langi gera kasi lea sulia na malutaa gera koo gia gi ua mai nao na gera sau aba suifetei gera kafi fanga?>> ");
INSERT INTO llu_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesus e oolisi gera ka urii, <<Gamu laugo, utaa na molu ka lea amolu sulia malutaa gamu gi i talagamu ma langi molu kasi lea sulia kwaieresia a God gi? ");
INSERT INTO llu_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Sulia God e bae uria, <Muka manata baita ana maa gamu gi ma ni tee gamu gi.> Ma nia ka bae urii lau, <So ni tei na e bae tolingia na maa nia ma ni tee nia, nia bobola fai nia gera ka haumaelia!> ");
INSERT INTO llu_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Sui boroi ana, molu haea hasa lea so ta wane ka too ana teni si doo na e bobola nia ka falea uria adomilana ana maa nia ma ni tee nia, sui ka bae, <Nau tara ku falea si doo naa fuana God,> ");
INSERT INTO llu_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","nia naa molu haea hasa langi kasi bobola uria adomilaa daaro. Nia naa gomolu faatolomainia na tooa fuana gera ka aaburongo ana kwaieresia a God gi ma daka roosulia na faatolomaia gomolu. ");
INSERT INTO llu_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Haia, gomolu haea molu roosulia God, ma nia langi kasi mamana go. Nia naa, si taa naa Aesea na profet nia e bae sulia mai nao baa nia e mamana naa. ");
INSERT INTO llu_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Nia ka bae urii, <God e haea: Tooa naa da faabaita nau go ada ana baelada, ma na mourilada e nia tau faasi nau. ");
INSERT INTO llu_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Na kwaieresia gera gi i talada go ana na gera faatolomainia ana tooa, sui gera ka haea ada na faatolomailaa nau gi. Ma sulia gera aade urinae, na fooalaa na gera aadea fuagu na doo tatagwai go ana.>>> ");
INSERT INTO llu_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Haia, Jesus e soea mai na tooa oro siana, ma ka bae urii fuada, <<Molu ka fafurongo diana eeri molu ka haitamana. ");
INSERT INTO llu_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Langi lau si doo na e ruu kou i laona fakana wane na e faabilia mourilana. Langi! Haia, si doo na e haga mai faasia fakana wane ana na e faabilia na mourilana wane.>> ");
INSERT INTO llu_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Sui na oote fafurongo a Jesus gi gera ka idu mai siana, gera ka bae urii fuana, <<Si doo baa gi o haeda baa, na Farisi gi gera ka rongoa, ma na manatada ka langi kasi diana sulia.>> ");
INSERT INTO llu_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ma Jesus e oolisida ka urii, <<Tara God e labasia na faatolomaia garo gi sui na e langi kasi lea mai faasi nia iilingia ta wane na e kwai faililana na doo taꞌa na da bulao mai garangia na nia kasi fasida. ");
INSERT INTO llu_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Haia, langi molu si manata aꞌabo ana Farisi nae gi. Sulia gera da uusulia go ada na wane maa rodo na e talaia na tooa maa rodo lau. Ma molu ka haitamana laugo, lea ta wane na maana e rodo ma ka talaia laugo ta wane na maana e rodo, tara daaro sui go daaro ka asi daaro i laona mae kilu.>> ");
INSERT INTO llu_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ma Peter ka bae urii fuana Jesus, <<O inifitaa fasi mai na malutana baelaa baa gi o kafi haeda go kou baa fuamelu.>> ");
INSERT INTO llu_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesus e oolisia ka bae urii, <<Gomolu naa na kete molu e rorodoa laugo mala ni gera? ");
INSERT INTO llu_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Utaa na langi molu si haitamana si doo naa gi? Haia, si doo na e ruu kou laona fakana wane, tara ka lea dongaa na ana i laona rake, ma i buri tara ka haga lau go mai ana faasia la noni. ");
INSERT INTO llu_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Haia, ma si baea taꞌa gi na e haga mai faasia fakana wane, nia na e ita mai faasia laona manatana wane. Nia naa, si doo nae ana na e haitamana ka faataꞌa na mourilana wane. ");
INSERT INTO llu_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Doo mala manata taꞌa gi, hauwanelaa, ooeoelaa, aade taꞌalaa fai nia ta wane, sugelaa faafia ta wane, belilana tesi doo ta wane, fai nia na uunuunu dongaalaa taꞌa sulia teni wane. Haia, ma si doo nae gi e haga mai faasia lao manatalana wane. ");
INSERT INTO llu_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Si doo nae gi haitamana ka faabilia ana mourilana wane. Sui na sau abalaa i naona fangalaa iilingia na malutaa na kokoo gia gi da faatolomai gia mai ana, sui boroi ana ta wane langi kasi aade sulia, na mourilana kasi taꞌa go.>> ");
INSERT INTO llu_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","A Jesus e tafusia si gula nae, ma ka lea uria na bali fera i Taea ma i Saedon. ");
INSERT INTO llu_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ma tee geni ana tooa maadiu gi i Kanan e lea mai siana, ma ka rii urii, <<Aaofia ae, oe na Aaofia ana kwalafaa a David, o manatai nau mai! Na aagalo taꞌa naa e adosia na haari nau, ma ka nonifii asianaa.>> ");
INSERT INTO llu_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","A Jesus e langi kasi oolisia go ana tesi baea. Ma na oote fafurongo nia gi daka lea mai siana Jesus, ma daka urii, <<O oodu nia ka lea kou amu, sulia ni nia e rii ka lea dongaa go ana i buri golu.>> ");
INSERT INTO llu_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","A Jesus ka bae fuana geni nae ka urii, <<A God e fale nau go mai ana uria na tooa Jiu gi na da iilingia na sipsip gi na da langi ada.>> ");
INSERT INTO llu_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Sui na geni nae e lea mai, ma ka boururu na ana i maana aena ka urii, <<Wane baita ae, o adomi nau mai!>> ");
INSERT INTO llu_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","A Jesus e oolisia ka urii, <<E langi kasi oꞌolo uria ngalilana na fanga gera na wela gi ma daka ui ania fuana na kui gi.>> ");
INSERT INTO llu_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Na geni nae ka urii, <<Iiuka. Sui, na kui gi boroi haitamana daka ania go ada na mumuduna fanga na e asia faasia na tafe gera na wane gi na da hareda.>> ");
INSERT INTO llu_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Sui a Jesus e oolisia ka urii, <<Geni ae, na manata mamanalaa oe e baita asianaa! Ma na doo na o gania, nau kuka falea fuamu.>> Ma na haari nia ka akwaa na ana si kada nae. ");
INSERT INTO llu_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Kada Jesus e lea mai faasia maefera nae, nia ka ooli mai sulia tala na e liu kamena aasi i Galili. Ma nia ka tae gwouna tefe uuo, ma ka gwouru seenae. ");
INSERT INTO llu_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ma ana si kada nae, tooa oro gi asianaa gera ka lea mai siana. Ma gera ka ngalia laugo mai tooa oro gera matai gi, teni tooa aeda e mae ma na abada ka mae, tooa maada ka rodo, ma tooa fakada ka ato. Gera aaluda i naona aena a Jesus, ma nia ka gurada, ma gera ka akwaa teefou. ");
INSERT INTO llu_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ma na tooa nae gi na gera koni uria bubulaa, gera ka kwele asianaa ana si kada gera rikia wane gi na fakada e ato ma daka faarai lau, ma tooa na aeda e mae ma na abada e mae gera ka diana lau, ma ni tei gera na langi gera si fali diana gera ka fali diana naa, ma na tooa na maada e rodo gera ka aada lau. Ma sulia na gera rikia si doo nae gi, gera kafi hae initoo ana God gera Israel. ");
INSERT INTO llu_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Sui a Jesus ka soea oote fafurongo nia gi siana, ka urii fuada, <<Nau ku kwaimanatai asianaa fuana tooa naa, sulia gera too fai golu oolu maedani e sui naa, ma na fanga gera gi ka sui naa. Haia, ma ni nau langi kusi dooria oodu gera fui fera gera gi ana si kada gera fiolo ana, aata ta wane ada makeso ma ka asimaelia sulia tala.>> ");
INSERT INTO llu_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Oote fafurongoa nia gi gera oolisia daka bae urii fuana, <<I laona fera gwou urii tara golu ka daotoona na fanga i fai eeri ka bobola fai nia tooa oro urii?>> ");
INSERT INTO llu_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ma Jesus e soeledi gera ka urii, <<Fita fe beredi na molu too ana?>> Fafurongo nia gi da oolisia gera ka bae urii fuana, <<Fiu fe doo, fai nia aange gwe iia gi go ana na melu too ana.>> ");
INSERT INTO llu_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ana si kada nae, Jesus ka haea tooa gi gera ka gwouru i aano. ");
INSERT INTO llu_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Sui, nia ka ngalia fiu fe beredi fai nia gwe iia nae gi, ka baelafea God. Sui nia ka niia, sui ka falea fuana abada oote fafurongo nia gi, eeri gera ka tolingia fuana tooa nae gi. ");
INSERT INTO llu_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ma tooa nae gi sui go da fanga, ma gera ka aabusu. Buira gera fanga sui, na oote fafurongo gi gera ka faafungua fiu koko ana oorengana fanga na e oore. ");
INSERT INTO llu_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Tooa na da ania fanga naa, gera fai tooni wane. Langi gera si iidumia go na geni ma na wela gi. ");
INSERT INTO llu_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Haia, ma buira gera fanga sui, Jesus kafi oodu gera i fera gera gi. Ma nia fai nia oote fafurongo nia gi gera ka sifo ma gera ka tae laona tee baru gera ka lea uria maefera gera alangia ana Magadan. ");
INSERT INTO llu_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Haia, teni Farisi fai nia teni Sadusi gi gera ka lea mai siana Jesus uria iilitoolana go ada, ma gera ka soeledia eeri ka iilia ta mamalafooa eeri ka faatainia God naa e oodu nia ka lea mai. ");
INSERT INTO llu_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jesus e oolisida ka bae urii fuada, <<Ana si kada na hato e suu, lea mu rikia na barobaro gi e kekeroa, muka haitamana uuta tara ka langi si aru bobongi. ");
INSERT INTO llu_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Haia, ma i ubongi, lea mu rikia na barobaro gi e kekeroa ma ka bulua, muka haitamana naa tara uuta ka aru. Haia, gamu haitamana asianaa aada haitamanalaa tara ka uuta, langi ka langi. Sui e langi molu si haitamana aada haitamanalana malutana si doo gi na molu rikida ana si kada naa. ");
INSERT INTO llu_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Gamu tooa i taraꞌena na mu aadea doo taꞌa oro gi ma langi musi manata mamana go ana God. Molu ka dooria rikilana mamalafooa. Haia, ma ni nau tara kusi aadea go ta mamalafooa fuagamu. Na mamalafooa go ana na kuka iilia fuana molu ka rikia, nia naa na kwaibalatana na e fuli fuana a Jona i nao.>> Buira Jesus e bae urinae sui, nia ka lea na ana faasi gera. ");
INSERT INTO llu_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ana si kada Jesus fai nia oote fafurongo nia gi gera faifolo uria bali aasi loko, na fafurongo nia gi dasi too ana tefe beredi sulia daka manata buro ana ngalilana fai gera. ");
INSERT INTO llu_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ma Jesus ka bae urii fuagera, <<Muka aada suli gamu faasia si iisi na e faafufua ana beredi gera Farisi gi ma na Sadusi gi, aata ka too ani gamu laugo.>> ");
INSERT INTO llu_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ma ana si kada na fafurongo nia gi gera rongoa na baelaa nae gi, gera ka bae na ada sulia i matanga gera taifilida, ma sulia gera manata hasa Jesus nia e bae sulia beredi mamana, ma gera ka urii, <<Boro Jesus e bae urinae sulia langi golu si ngalia mai tefe beredi oto naa!>> ");
INSERT INTO llu_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ma sulia Jesus nia e haitamana go ana manatalada oote fafurongo nia gi, nia ka bae urii, <<Utaa naa molu ka manata aꞌabo asianaa sulia na molu si ngalia mai tefe beredi? Haia, na manata mamanalaa gomolu e toꞌou asianaa! ");
INSERT INTO llu_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Utaa? Kete molu e rorodoa ua? Boro molu manata buro na ana lima fe beredi baa gi ku hangonia ana lima tooni wane, ma molu ka faafungua koko oro ana fanga baa gi e oore. ");
INSERT INTO llu_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ma boro molu manata buro naa laugo ana fiu fe beredi go baa na kuka hangonia ana fai tooni wane ma molu ka faafungua koko oro baa gi ana fanga e oore gi. ");
INSERT INTO llu_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Utaa naa langi molu si haitamana taa gi na ku bae sulia? Langi lau na beredi baa ku bae sulia. Taa ku haea naa na molu susuli gamu faasia na iisi na faafufulaa ana beredi gera Farisi gi ma na Sadusi gi.>> ");
INSERT INTO llu_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Buira nia bae urinae sui, na fafurongo gi gera kafi haitamana taa na Jesus e bae sulia. Nia bae ana sulia faatolomaia gera Farisi gi ma na Sadusi gi. ");
INSERT INTO llu_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Si kada a Jesus e dao ana na lolofaa i Sesarea Filipae, nia ka ledia na oote fafurongo nia gi ka urii, <<Ni tei naa na tooa gi da alangi nau ana, na Wela nia Iimola gi?>> ");
INSERT INTO llu_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","I gera da oolisia daka urii, <<Teni tooa gi da haea a John Siuabu, ma teni tooa gi aai da haea a Elaeja. Ma teni tooa gi lau da haea a Jeremaea langi ta wane ana profet aai gi.>> ");
INSERT INTO llu_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Sui a Jesus e ledida ka urii, <<Haia, ma ni gomolu mone, molu alangi nau ani ni tei?>> ");
INSERT INTO llu_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ma a Simon Peter e oolisia ka urii, <<I oe naa na Christ, na Wela nia a God momouria.>> ");
INSERT INTO llu_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ma a Jesus ka bae ka urii, <<Simon na wela nia John ae, e oilakea fuamu. Sulia ta wane kasi faatainia si doo naa fuamu. Na maa nau i langi na e faatainia fuamu. ");
INSERT INTO llu_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ma i nau ku haea fuamu, i oe a Peter, na malutana baa na fou, ma i fafona na fou naa i nau kuka haungainia na soefaataia nau. Ma na rigitalana na maea langi kasi bobola uria saitasalaa ana. ");
INSERT INTO llu_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ma i nau ku falea na kii gi ana maa ana Initooa i Langi fuamu. Ma tesi taa na o luia laona molaagali, gera ka luia laugo i langi. Ma tesi taa na o faalamainia i laona molaagali, gera ka faalamainia laugo mai i langi.>> ");
INSERT INTO llu_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Sui a Jesus ka bae fifii fuada oote fafurongo nia gi, ka langi dasi faarongoa ta wane hasa i nia naa na Christ. ");
INSERT INTO llu_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ita ana si kada nae ka lea, a Jesus ka hafali bae faafolaalilana fuada na oote fafurongo nia gi ka urii, <<I nau kuka lea fui Jerusalem. Ma na wane naonao gi ma na fataabu baita gi, ma na wane faatolomai gi ana kwaieresia gi, tara gera ka faafii nau. Ma daka haungi nau. Ma ana ooula fe dani, i nau kuka tatae lau uria na mouria.>> ");
INSERT INTO llu_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ma a Peter ka talai nia, ma e ngatafia ka urii, <<Lord ae, a God ka luia! Na doo naa gi ka langi si fuli fuamu!>> ");
INSERT INTO llu_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ma a Jesus e kari aabulo, ma ka bae urii fuana a Peter, <<Satan ae, o lea tau amu faasi nau! I oe o take suusi nau. Sulia na manatalamu e ita mai faasia na tooa gi go ana. E langi lau faasia a God.>> ");
INSERT INTO llu_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Sui a Jesus ka bae urii fuada oote fafurongo nia gi, <<Lea so ta wane ka dooria na lealaa i burigu, nia ka lugasia na kwaidooria nia gi. Ma nia ka ngalia na airarafolo nia ana nonifiilaa, ma ka lea mai suli nau. ");
INSERT INTO llu_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Sulia, ni tei na e dooria ka tala faamouri nia ana, tara ka mae. Ma so ni tei na e mae urii nau, ka mouri naa. ");
INSERT INTO llu_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Utaa? E diana fuana na wane, lea so i nia e ngalia na molaagali loulou, sui ma ka mae? Langi! Ma langi tesi doo na wane ka falea, hai so ka ngalia na mouria nia lau. ");
INSERT INTO llu_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Sulia nau, na Wela nia Iimola gi, garangia kuka lea mai fai nia na ensel nau gi, ana Initooa nia na Maa, ma tara nau ku falea na kwaiaraa langi na kwaelaa fuada na tooa gi sui sulia si doo na da iilia. ");
INSERT INTO llu_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Doo mamanaa nau ku haea fuagamu, teni tooa amolu langi gera si mae lelea daka riki nau kuka dao mai uria na aaofialaa.>> ");
INSERT INTO llu_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Na oonona fe dani i buri, a Jesus e talaia a Peter ma na roo waihaasina gi a James ma a John taifili gera uria i gwouna tefe tolo e fane. ");
INSERT INTO llu_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ma si kada gera aada kou, gera ka rikia na maana a Jesus e tatala. Na maana e rara iilingia na hato, ma na maku nia gi ka kwakwaoa asianaa. ");
INSERT INTO llu_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ma na oolu wane fafurongo naa gi daka rikia a Moses fai nia a Elaeja da faarai adaaro fai nia a Jesus. ");
INSERT INTO llu_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ma a Peter ka bae urii kou fuana a Jesus, <<Lord ae, nia diana asianaa na golu ka too na agolu i seegi. Lea so o dooria, i nau kuka tolea ta oolu babala, tee doo fuamu, ta doo fuana a Moses, ma tee doo aai fuana a Elaeja.>> ");
INSERT INTO llu_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ma ana si kada a Peter e bae ua go ana urinae, tesi barobaro na e sinasina ka sifo mai faafi gera, ma daka rongoa na lingee doo ka bae mai urii faasia laona na barobaro nae, <<Nia naa na Wela rakediana nau na ku noni eele sulia. Molu rongo nia!>> ");
INSERT INTO llu_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ma si kada na oote fafurongo nia gi da rongoa na lingee doo naa, gera ka mou asianaa ma gera ka teo na ada faafia na maada i hae gano. ");
INSERT INTO llu_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ma a Jesus e dao siada, ma ka hamotooda, ka bae urii, <<Molu tatae. Langi molu si mou.>> ");
INSERT INTO llu_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Haia, ana si kada daalu aada, daalu si rikia naa ta wane aai, tee taifilia a Jesus go. ");
INSERT INTO llu_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ma ana si kada daalu sifo mai faasia i gwouna fe tolo nae, a Jesus e bae fifii fuagera ka urii, <<E langi molu si faarongoa ta wane ana si doo nae gi molu rikia, lelea ka dao ana si kada nau, na Wela nia Iimola gi, kuka tatae ana faasia na maea.>> ");
INSERT INTO llu_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Oolu fafurongo nia gi gera ka ledia daka urii, <<Utaa na faatolomai gi ana kwaieresia gi gera haea tara a Elaeja ka ooli lau mai suifetei na wane baa a God e aadafilia kafi lea mai?>> ");
INSERT INTO llu_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","A Jesus e oolisida ka urii, <<Nia mamana. Elaeja naa ka ooli mai nao, eeri ka adomia tooa uria na aade aagaulaa. ");
INSERT INTO llu_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ma i nau ku haea lau fuagamu, a Elaeja nia e dao sui na mai. Sui na tooa langi dasi aada haitamana go. Nia naa, gera ka aadea go ada doo taꞌa gi ani nia sulia na kwaidoorilaa gera gi. Ma gera tara gera ka aade urinae laugo ani nau.>> ");
INSERT INTO llu_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ana si kada oolu fafurongo nae gi gera rongoa, gera kafi haitamana John Siuabu naa a Jesus nia manata uria naa, si kada nia ka bae ana. ");
INSERT INTO llu_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Si kada Jesus fai nia oolu fafurongo nia gi daalu sifo mai fui aena tolo, na tooa oro gi gera koni ana, ma tee wane e lea mai, ka boururu maana aena Jesus, ma ka bae urii, ");
INSERT INTO llu_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","<<Wane baita ae, o manatai nia mai na wela wane nau, na sulia uura e haungi nia. Na mataia naa haitamana ka aadea ka nue, ma ana si kada e oro nia asi nia naa lao eere ma i laona kafo laugo. ");
INSERT INTO llu_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nau ku ngalia mai siana oote fafurongo oe gi. Sui ka afetai asianaa fuagera uria ka guralana.>> ");
INSERT INTO llu_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Haia, Jesus ka bae urii fuada, <<I gomolu na tooa na mu too si kada nae, na aabulolamolu e taꞌa asianaa, ma langi molu si manata mamana go ana God. Nau ku noni eela fuana toolaa fai gomolu. Molu ngalia mai na wela nae siagu.>> ");
INSERT INTO llu_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ma Jesus ka bae taria na aagalo taꞌa nae faasia wela nae ana baelana. Ma na wela nae ka akwaa na ana si kada nae ua go. ");
INSERT INTO llu_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Sui, na fafurongo gi gera ka lea aagwa siana Jesus, ma gera ka ledia daka urii, <<Utaa naa ka afetai fuamelu uria na tarilana na aagalo taꞌa naa faasia na wela baa?>> ");
INSERT INTO llu_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ma a Jesus oolisida ka bae urii, <<E urinae, sulia na manata mamanalaa gomolu e kukuru asianaa. Haia, ma ni nau ku haea fuagamu, lea so na manata mamanalaa gomolu ana a God ka baita ka uusulia boro ana ta mige ai toꞌou na gera alangia ana mastad, gomolu haitamana molu ka aadea go amolu na taa na nia e afetai. Lea so ka urinae, fe tolo loko boro haitamana molu ka idua faasia fuilaa ana baelamolu. Haia, ma lea molu manata mamana ana mamanaa ana God, langi tesi doo kasi afetai fuana muka aadea. ");
INSERT INTO llu_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Haia, na gwounge aagalo taꞌa urinae na afetai ka haga, lea langi molu kasi fooa fai nia aabu fangalaa.>> ");
INSERT INTO llu_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ma ana si kada oote fafurongo nia gi gera oogu mai i Galili, Jesus ka bae urii fuada, <<I nau, na Wela nia na Iimola gi, tara gera ka fale nau fuana maalimaea nau gi, ");
INSERT INTO llu_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","eeri gera ka haungi nau. Haia, ana ooula fe dani, tara kuka mouri lau.>> Ma si kada oote fafurongo gi gera rongoa Jesus e bae urinae, gera ka liobukonu asianaa. ");
INSERT INTO llu_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ana si kada Jesus fai nia oote fafurongo nia gi gera lea mai uria maefera i Kapaneam, na wane gi gera koni malefo ana takisi fuana Beu Aabu a God, gera lea siana Peter, daka soeledia, <<Wane faatolomai gomolu e haitamana ka falea laugo si malefo na melu liu uria konilanalaa na fuana Beu Aabu nia a God?>> ");
INSERT INTO llu_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ma a Peter oolisida, <<Iiuka, nia haitamana ka falea.>> Haia, ma si kada a Peter e ruu ana i luma, Jesus ka soeledia fasi ka urii, <<Simon ae, oe manata utaa? Tei naa na aaofia gi ana molaagali gera haitamana daka konia si malefo faasida? Na wela gera gi i talada, ma langi faasia tooa eꞌete gi?>> ");
INSERT INTO llu_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Peter oolisia ka urii, <<Faasia tooa eꞌete gi.>> Ma Jesus ka urii, <<Nia nae, wela gera na aaofia gi gera langi dasi falea go na takisi naa. Nia naa, lea nau kusi falea boroi na takisi fuana Beu Aabu nia na Maa nau, nia e diana go ana. ");
INSERT INTO llu_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ma sui boroi ana ka urinae, e langi kasi diana golu ka labasia na manata gera gi fuagolu. Haia, o lea i laona aasi, oko aao mai. Haia, gwe iia na o tafoa i nao, oko aafanganga na fakana. Ma tara oko rikia si malefo na e bobola fai goro uria na folilana takisi uria tee fe ngali. Ngalia si malefo nae, ma oko falea fuada.>> ");
INSERT INTO llu_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ana si kada nae, oote fafurongo nia gi gera ka lea mai siana Jesus ma gera ka soeledia daka urii, <<Ni tei na e baita ka tasa lao Initooa a God i langi?>> ");
INSERT INTO llu_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ana si kada nae, a Jesus ka soea tee gala wela siana, ma ka faatakea i matangada. ");
INSERT INTO llu_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ma nia ka bae urii, <<Doo mamana nau ku haea fuamolu, lea langi molu si oolisia na aabulolaa molu ma langi molu si faatoꞌou gomolu mala gala wela gi, langi molu si bobola uria ruulaa laona Initooa i Langi. ");
INSERT INTO llu_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Haia, ma ni tei na e faatoꞌou nia i talana mala gala wela naa, tara nia ka aalu wane baita laona Initooa a God. ");
INSERT INTO llu_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ma so ni tei na e gonitainia ta gala wela mala kele gala wela na sulia wane nae nia manata mamana ani nau, nia ka aadea naa fuagu. ");
INSERT INTO llu_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","<<Lea ta wane ka faagaroa ta gala wela ana wela naa gi, nia diana fuana wane nae gera ka kulua ta fou baita i luana, sui ngalia daka ui ania lao aasi. ");
INSERT INTO llu_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kwaimanatai fuana tooa i laona molaagali sulia si doo oro uria faagaroladalaa doo nae gi tara ka lea dongaa, ma kwaimanatai asianaa fuana wane na tara ka aadea si doo nae gi eeri ka faagaro ana tooa. ");
INSERT INTO llu_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","<<Nia naa, lea so na abamu ma langi na aemu ka faagaro oe, oko taba muusia amu, oko ui ania. Sulia e diana fuamu hai so oko ruu i laona Initooa i Langi fai nia na kuru aba ma langi ae, aata daka ui ani oe laona eere na e afetai ka mae. ");
INSERT INTO llu_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ma lea so na maamu e faagaro oe, oko lafua amu, oko ui ania. Sulia nia e diana fuamu hai so oko ruu i laona Initooa i Langi fai nia tee bali maa, aata daka ui ani oe fai nia roo bali maa i laona eere afetai ka mae.>> ");
INSERT INTO llu_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","Ma Jesus ka bae urii lau, <<Langi molu si sinitainia na gala wela naa gi. Sulia na ensel gera gi da nii mai langi fai nia a God na Maa nau, gera aada suli gera. ");
INSERT INTO llu_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","<<Haia, lea so ta wane ka too ana tee talange sipsip, ma tee doo ada ka langi ana, ma taa na tara wane naa ka aadea? Wane naa tara ka lugasia sikwa aakwala ma sikwa sipsip gi ana si gula gera fanga ana, ma ka lea ka nanisia tee sipsip na e langi ana. ");
INSERT INTO llu_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Si kada nia daotoona ana, nia eele ka tasa liufia na eelelaa na fai nia na sipsip nia gi na da too ua naa. ");
INSERT INTO llu_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Haia, na Maa gamu mai langi, nia e manata laugo urinae sulia nia langi kasi dooria fuana ta gala wela naa gi ka funu sulia na aade taꞌalaa nia gi.>> ");
INSERT INTO llu_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","A Jesus ka bae urii fuana oote fafurongo nia gi, <<Lea so na haasimu ka iilia tesi doo ka garo fuamu, o lea siana, oko faarongoa ana na garolaa nia i matangamoro taifili gomoro. Ma lea nia ka fafurongo uri oe, moro ka kwaimaani lau. ");
INSERT INTO llu_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ma lea nia kasi fafurongo uri oe, oko talaia ta tee wane langi ta roo wane fai oe, hai daaro ka faamamanaa si doo gi sui na o haea, hai oko iili sulia ta Kekedelaa Aabu e haea, <Na roo wane ma langi ta oolu wane hai daka faamamanaa.> ");
INSERT INTO llu_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ma lea nia ka oote nia ni fafurongolaa urii gera, oko faarongoa ana na figulaa gera na tooa a God gi. Ma lea na figulada na tooa nia a God gi boroi, nia kasi fafurongo go uri gera, oko aade iilingia ta wane maadiu ani nia ma langi ta wane taꞌa na e gonia na malefo ana takisi. ");
INSERT INTO llu_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","<<Doo mamana nau ku haea fuagamu, tesi taa na molu luia laona molaagali, gera ka luia laugo i langi. Ma tesi taa na molu faalamainia i laona molaagali, gera ka faalamainia laugo i langi. ");
INSERT INTO llu_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","<<Nau ku haea lau fuamolu, lea so ta roo wane ani gomolu daaro ka aalafaafia tesi doo i laona molaagali ma daaro ka fooa uria, na Maa nau i langi tara nia ka falea fuadaaro. ");
INSERT INTO llu_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Sulia lea so ta roo wane ma langi ta oolu wane daka oofu ana ta gula ana na hatagu, nau kuka too laugo i seenae fai gera.>> ");
INSERT INTO llu_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","A Peter e dao siana a Jesus ma ka ledia ka urii, <<Lord ae, fita si kada na kuka haitamana manata lukelana ana haasigu si kada nia e iilia tesi doo taꞌa fuagu? Lea ka dao ana fiu si kada?>> ");
INSERT INTO llu_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ma a Jesus e oolisia ka urii, <<I nau ku haea fuamu, langi lau fiu si kada, ma ana si kada gi sui go taari na oko manata luke ana. ");
INSERT INTO llu_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Sulia na Initooa i Langi e iilingia ta aaofia na e dooria na olosilana na ngalilangalaa gi fai nia na wane ni rao nia gi. ");
INSERT INTO llu_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Haia, na eetana wane ni raoa e dao mai na e ngalilanga ana si malefo oro asianaa. ");
INSERT INTO llu_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ma na wane ni rao nae ka langi kasi bobola naa fai nia na duulana na ngalilangalaa nia, ma na aaofia ka oodu nia eeri daka faafoli ani nia fai nia na afe nia ma na wela nia gi ma na doo nia gi sui uria na duulana na ngalilangalaa nia. ");
INSERT INTO llu_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","<<Ma na wane ni rao nae lea mai ka boururu i nao ana na aaofia, ma ka gania ka urii, <Oko gwaromaabe fasi fai nau, haia tara kuka duua na doo oe gi sui.> ");
INSERT INTO llu_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ma na aaofia ka kwaimanatai fuana, ma nia ka manata lukea na ngalilangaa nia hai kasi duua naa, ma ka faalamainia ka lea na ana. ");
INSERT INTO llu_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","<<Haia, ma si kada na wane nae e haga kou i maa, nia ka toodaa tee wane aai ana na wane ni rao gi na e ngalilanga ana aange si gale malefo siana. I nia ka dumulia, ma ka hafalia na ini lualana, ma ka bae urii, <O duua na doo gi na o ngalilanga ana siagu!> ");
INSERT INTO llu_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","<<Ma wane ni rao nae ka boururu, ma ka gania ka urii, <Oko gwaromaabe fasi fai nau, ma tara kuka duu fuamu.> ");
INSERT INTO llu_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","<<Sui nia ka oote nia, ma ka ngali nia ma ka aalu nia i laona na beu ni kanilaa, lelea ka duua go na ngalilangaa nae. ");
INSERT INTO llu_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ma si kada teni wane ni rao aai gi da rikia na doo naa, na manatalada ka asia asianaa. Ma daka lea siana na aaofia, ma daka faarongoa ana na doo gi sui. ");
INSERT INTO llu_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","<<Ma na aaofia ka soea mai na eeta na wane ni rao nae, ma ka bae urii, <I oe na wane taꞌa asianaa! I nau ku manata lukea na ngalilangaa oe baa gi sui, sulia o gani nau uria. ");
INSERT INTO llu_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Haia, ma ni oe so oko kwaimanatai fuana na wane ni rao aai nae, iilingia baa ku iilia laugo fuamu.> ");
INSERT INTO llu_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ma na aaofia nae ka rakehasu asianaa, ma ka falea uria na kwaelana i laona na beu ni kanilaa, lelea nia ka duua go na doo gi sui na e ngalilanga ana.>> ");
INSERT INTO llu_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ma a Jesus ka faasuia si oomelawanelaa nae ka urii, <<Ma nia naa si aadelaa na Maa nau i langi tara ka iilia fuagamu, lea so langi musi manata luke mamanaa na haasi gamu gi.>> ");
INSERT INTO llu_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Si kada a Jesus e faasuia baelana, nia ka lea faasia lolofaa nae i Galili. Ma nia ka lea folo ana kafo i Jodan ma kafi dao ana maefera nae gi i Judea. ");
INSERT INTO llu_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ma na tooa oro asianaa gera lea sulia. Haia, ma na orolana tooa na na gera matai, ma Jesus ka gurada ma gera ka akwaa. ");
INSERT INTO llu_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ma teni Farisi gi gera lea laugo mai uria na iilitoolana go ada Jesus. Ma gera ledia, daka urii, <<Utaa? Ana kwaieresia gia gi, nia diana go ana fuana wane ka lugasia na afe nia uria tesi doo boroi ana na nia e dooria?>> ");
INSERT INTO llu_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesus oolisida ka urii, <<Uria taa na langi molu si manata diana sulia doo gi mu iidumida laona Kekedelaa Aabu? Na Kekedelaa Aabu nia urii, <Ana hafalilana mai, God e haungainia tooa gi na doo wane ma na doo geni.> ");
INSERT INTO llu_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ma na Kekedelaa Aabu e haea laugo urii, <Sulia si doo nae, na wane ka tafusia na maa nia fai nia tee nia, ma ka too oofu fai nia na afe nia, ma daaro ka aalua tee doo.>>> ");
INSERT INTO llu_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ma Jesus ka bae urii laugo. <<Haia, na wane fai nia na afe nia daaro langi lau roo doo, ma daaro tee doo naa. Nia naa, na doo a God e kani oofu sui naa urinae, e langi si diana fuana ta wane ka lukea.>> ");
INSERT INTO llu_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ma na Farisi gi gera ledia lau daka bae urii, <<Haia, ma tee kwaieresia a Moses e bae urii, <Lea ta wane e dooria ka lugasia na afe nia, nia ka kedea si abe doo ni kwailugasilaa, sui ka falea fuana afe nia, sui nia kafi lugasia.> Haia, ma uria taa naa Moses ka faalamainia fuana tooa gi gera ka aade urinae?>> ");
INSERT INTO llu_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesus ka bae urii fuada, <<Moses e faalamainia fuagamu Jiu gi fuana lugasilana afe gamu gi, sulia afetai muka haitamana. Sui boroi ana ka urinae, i nao mai ana si kada God e haungainia ana wane ma na geni, nia langi si urinae. ");
INSERT INTO llu_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Haia, ma ni nau ku haea fuagamu, lea afe nia ta wane langi kasi ooe go ana, ma na aarai nia ka lugasia ma ka aadea ta geni aai lau, na wane naa ka garo ana ooeoelaa.>> ");
INSERT INTO llu_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Buira Jesus e bae urinae fuada sui, oote fafurongo nia gi daka bae urii fuana, <<Haia, ma lea afetai asianaa fuana wane ka lugasia afe nia urinae, diana fuana wane ka langi si aade geni.>> ");
INSERT INTO llu_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ma Jesus ka urii fuada, <<Na aai faatolomailaa na haea wane kasi aarai, langi lau fuana tooa gi sui uria lealaa sulia. Na doo fuana tooa na God e falea si faatolomailaa na fuada go ana na gera ka lea sulia. ");
INSERT INTO llu_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Golu ka haitamana laugo teni wane langi dasi aarai gi, sulia hafali ana si kada gera futa mai ana tesi doo langi si olo laona na nonida, nia na aadea langi dasi bobola fuana aarailaa. Ma teni wane langi dasi aarai sulia na wane gi da haungainia na nonida na aadea langi gera si bobola na fuana aarailaa. Haia, ma teni wane aai mone langi gera si aarai sulia gera i talada ana dooria daka too ada faasia aberosiladalaa eeri daka iilia ada raoa a God fuana hae initoolaa ana. Ma ni tei naa e dooria ka lea sulia na faatolomailaa naa, nia diana nia ka iilia na ana si kada nae naa.>> ");
INSERT INTO llu_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ma i buira si doo naa, teni tooa gera ngalia mai na gala wela gi siana Jesus eeri ka aalua abana i faafida ma ka fooa faafida. Ma na oote fafurongo nia gi gera ka ngatafida. ");
INSERT INTO llu_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ma a Jesus ka bae urii fuada, <<Muka faalamainia na gala wela gi daka lea ada mai siagu, musi luida na. Sulia ni tei naa na manata mamanalaa nia ka iilingia gala wela, nia ka bobola uria toolaa lao Initooa nia a God.>> ");
INSERT INTO llu_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Sui a Jesus e aalua na abana i fafona gala wela nae gi, ma ka faadiana gera. Sui, nia ka lea na ana. ");
INSERT INTO llu_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ana tesi kada, tee wane e lea mai siana Jesus ma ka ledi urii, <<Faatolomai ae, si taa diana na kuka aadea eeri kuka ngalia na mouria firi?>> ");
INSERT INTO llu_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","A Jesus ka bae urii fuana, <<Utaa na oko ledi nau sulia na dianalaa? Tee Wane go ana na e diana. Lea o dooria oko too ana mouria firi fai nia God, o aade sulia na kwaieresia nia gi na nia e haeda.>> ");
INSERT INTO llu_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Haia, na wane nae ka ledia lau a Jesus ka urii, <<Kwaieresia taa gi?>> A Jesus ka oolisia urii fuana, <<Osi hauwane, osi ooe, osi belia tesi doo, osi suge faafia ta wane. ");
INSERT INTO llu_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ma oko manata baita ana maa oe ma ni tee oe. Ma oko rakediana fuana wane aefera oe iilingia fuamu i talamu.>> ");
INSERT INTO llu_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Sui wane naa ka bae urii fuana Jesus, <<Doo nae gi nau ku iilida sui na mai. Utaa? Si taa lau eeri kuka iilia lau?>> ");
INSERT INTO llu_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ma Jesus oolisia ka urii fuana, <<Lea o dooria too diana teefou, lea oko faafoli ana doo oe gi sui, ngalia si malefo nae oko falea fuana tooa siofaa, ma tara oko too ana todadoo i langi. Sui ofi lea mai suli nau.>> ");
INSERT INTO llu_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ma ana si kada wane daraa nae e rongoa na doo nae gi, na liona ka bukonu asianaa naa, sui ka lea na ana, sulia nia na wane rikidoo asianaa. ");
INSERT INTO llu_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ma a Jesus ka bae urii fuana oote fafurongo nia gi, <<Nau ku haea fuagamu, nia e afetai fuana wane rikidoo ka ruu i laona Initooa i Langi. ");
INSERT INTO llu_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Haia, ma ni nau ku haea laugo fuagamu, nia e afetai fuana doo fai ae baita so ka ruu ana mae ogilaa. Ma afetai ka tasa hasa ta wane na e rikidoo ka ruu i laona Initooa a God.>> ");
INSERT INTO llu_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Haia, ma ana si kada oote fafurongo nia gi gera rongoa na doo nae gi, gera ka kwele asianaa, ma gera ka bae urii, <<Haia, ma lea afetai fuana tooa gera rikidoo urinae, tei mone ana ka bobola uria ngalilana mouria firi?>> ");
INSERT INTO llu_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ma ana si kada Jesus e bae, nia ka bubu oꞌolo kou fuana oote fafurongo nia gi, ma ka bae urii, <<Sui boroi ana nia ka afetai fuamolu, e langi kasi afetai go fuana a God.>> ");
INSERT INTO llu_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ana si kada nae, Peter ka soeledia Jesus ka urii, <<Ma ni gemelu mone? Sulia melu lugasia na doo gemelu gi sui, ma melu ka lea naa suli oe. Haia, ma si taa naa tara God ka falea fuamelu?>> ");
INSERT INTO llu_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ma a Jesus e oolisia urii fuagera, <<Nau ku haea fuagamu, ana si kada tara God e aalua molaagali faalu, tara ni nau, na Wela nia Iimola gi, nau kuka gwouru ana gula ni gwourua nau uria na ketolana tooa gi sui. Ana si kada nae, gomolu aakwala ma roo wane fafurongo nau gi, tara molu ka gwouru fai nau ana gula ana initoo ni gwogwourua uria ketolana tooa gi ana aakwala ma roo aebara gera Israel. ");
INSERT INTO llu_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Haia, ma ni tei na e lugasia luma nia, ma na haasina ma na waiwane nia, ma na maa fai nia ni tee nia, ma oote wela nia gi, langi so ta gano ana, sulia nia ka lea suli nau, na wane nae tara nia ka ngalia doo diana oro liufia si doo baa gi nia too ana i nao. Ma tara a God ka falea mouria firi fuana laugo. ");
INSERT INTO llu_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ma tooa oro na da baita si kada nae, tara daka toꞌou. Ma tooa oro na da faatoꞌou gera si kada nae, tara daka baita.>> ");
INSERT INTO llu_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","A Jesus ka bae lau urii fuana oote fafurongo nia gi, <<Na Initooa i Langi e iilingia na wane na e too ana gano, ma e lea i ofaidani uria na soelana wane gi uria na raolaa i laona na raoa nia. ");
INSERT INTO llu_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ma nia ka aalafaafia na folilada ana si malefo na e bobola fuana fe hato, ma ka ooduda naa uria raolaa laona na raoa nia. ");
INSERT INTO llu_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","<<Ma i ubongi ua, nia ka lea lau, ma ka rikia teni wane aai gi da take go ada i laona uusia ma langi dasi iilia go tesi doo. ");
INSERT INTO llu_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ma nia ka urii fuada, <I gomolu laugo, molu lea, molu ka rao i laona na raoa nau, ma i nau tara kuka foli gomolu.> ");
INSERT INTO llu_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ma gera ka lea naa. <<Ma i initooa na hato ma ana si kade hato na e lea naa uria haulafia, i nia ka lea lau, ma ka iilia laugo si doo baa. ");
INSERT INTO llu_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ma i haulafi i nia e lea ma ka daotoona teni wane gi na da take go ada i uusia. Ma i nia e ledida ka urii, <Uria taa na molu ka take go amolu i seenaa sulia fe hato loulou nae, ma langi molu si iilia go tesi doo?> ");
INSERT INTO llu_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","<<Ma gera oolisia daka urii, <Sulia e langi ta wane kasi soe gemelu go.> <<Ma nia ka bae urii fuada, <I gomolu laugo, molu lea, ma molu ka rao i laona na raoa nau.> ");
INSERT INTO llu_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","<<Ma si kada na hato e suu, na wane na e too ana raoa, ka bae urii fuana na wane baita ana na raoa nia, <O soea mai na wane ni rao gi ma oko foli gera ana na malefo gera gi. O hafali ana na wane baa gi ku soeda iꞌisi lea ka dao ana na wane baa gi ku soe totongenao.> ");
INSERT INTO llu_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","<<Na wane ni rao baa gi na nia e soeda i haulafi, da dao mai ma nia ka folida ana si malefo na e bobola fuana fe hato fuana tee wane. ");
INSERT INTO llu_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ma si kada na wane baa gi na nia e soeda mai i nao da dao mai, da manata hasa tara nia ka foli gera ka tee baita. Sui taa, ni gera sui go gera ngalia go si malefo na e bobola fuana fe hato fuana tee wane. ");
INSERT INTO llu_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ma si kada gera ngalia ana, gera ngunungunu fuana na wane na e too ana na raoa, daka bae urii, ");
INSERT INTO llu_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","<Na wane naa gi o soeda mai i buri da rao go ada sulia si kada toꞌou, ma oko folida ka bobola laugo fai gemelu na melu ngali gulua ana na raolaa sulia fe hato loulou nae na e hato fifii.> ");
INSERT INTO llu_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","<<Ma nia e oolisia tee wane ada ka urii, <Ruana ae, i nau kusi faafefe oe go. I oe o aalafaafia na raolaa uria tee si malefo go baa. ");
INSERT INTO llu_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","O ngalia na folilaa oe ma oko lea naa. I nau ku dooria na falelaa ana na wane na ku soea i iꞌisi ka iilingia laugo na ku fale fuamu. ");
INSERT INTO llu_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ma i nau ku too ana babaitaa uria na iililana tesi doo na ku doori iilia ana na malefo nau i talagu. Ni oe o kwaifii sulia nau ku fale doo baita agu fuana wane ete loko gi?>>> ");
INSERT INTO llu_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ma i iꞌisi a Jesus ka bae urii, <<Nia naa, na wane na e isi, tara ka eeta lau i nao. Ma na wane na e eeta i nao, tara nia ka isi lau.>> ");
INSERT INTO llu_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Si kada Jesus e lea fui Jerusalem, nia ka talaia oote fafurongo nia gi gera ka lea garangi nia taifilida, ma nia ka faarai fuada taifilida ka urii, ");
INSERT INTO llu_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","<<Molu fafurongo diana mai fuagu. Golu lea kou fui Jerusalem nae. Ma tee wane tara ka fale nau, nau wela nia Iimola gi, fuana fataabu baita gi ma gera na faatolomai gi ana kwaieresia gi, eeri gera ka keto taꞌa ani nau uria na haumaelagu. ");
INSERT INTO llu_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ma tara gera ka fale nau fuana tooa maadiu gi, ma i gera tara daka malaꞌiteꞌite nau, ma gera ka rabusi nau. Sui tara gera ka fotoi nau i fafona airarafolo uria haungilagu. Haia, ma ana ooula maedani, tara nau kuka mouri lau.>> ");
INSERT INTO llu_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Buira doo nae, afe nia a Sebedi fai nia na roo wela nia gi a James ma a John gera ka dao mai uria rikilana Jesus. Na geni nae e lea mai, ka boururu i naona Jesus, ma ka gania uria iililanalaa si doo fuana roo wela nia gi. ");
INSERT INTO llu_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ma a Jesus ka soeledia geni na ka urii, <<Taa naa o dooria?>> Nia ka bae urii, <<Nau ku dooria o bae aalualu fuagu oko faalamainia roo wela nau naa gi daka gwouru garangi oe, ta wane ka gwouru i bali aaolo amu, ma ta wane i bali mouli amu, si kada o Aaofia i laona Initoo oe.>> ");
INSERT INTO llu_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ana si kada nae, Jesus ka bae urii fuana wela nae gi, <<Si doo na moro gania, gomoro langi moro si haitamana go na malutana. I gomoro moro bobola go amoro uria nonifiilaa iilingi nau tara ku nonifii?>> Ma daaro ka bae urii, <<Iiuka, gemere bobola go amere.>> ");
INSERT INTO llu_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesus ka bae urii lau fuadaaro, <<Nia mamana tara si doo naa ka dao ani gomoro. Haia, ma fuana taa wane na ka gwouru i bali aaolo agu ma taa wane i bali mouli agu iilingia na moro dooria, langi lau ni nau naa ku aadafilia. Taifilia Maa nau mai langi go ana e haitamana ka falea fuana ni tei gera na nia aadafilida sui naa.>> ");
INSERT INTO llu_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Kada na aakwala fafurongo aai gi gera rongoa si doo naa, rakeda ka hasu asianaa fuana roo waihaasina nae gi. ");
INSERT INTO llu_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Nia naa, Jesus ka soe gera sui go mai siana, ka bae urii, <<Gomolu haitamana sui na gera tooa baita gi lao molaagali na gera dooria asianaa ooroilana tooa gera gi. Haia, na tooa kwaitalai gi gera ka haitamana asianaa suungailana tooa gera gi uria iililana si taa na gera dooria. ");
INSERT INTO llu_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Haia, ma ni gamu, langi musi iilia si doo nae. Lea ta wane ani gamu dooria ka baita, nia ka hau ana wane ni rao fuagamu sui. ");
INSERT INTO llu_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Iiuka, lea ta wane ani gamu dooria ka baita fuagamu, nia ka aalua wane rao oꞌoni fuagamu sui. ");
INSERT INTO llu_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Nia ka iili mala ni nau, nau Wela nia Iimola gi. Sulia nau kusi lea mai eeri na tooa gi gera ka rao fuagu. Ma nau ku lea mai uria raolaa fuana tooa gi sui, ma kuka falea na mourilagu uria na faamourilana na tooa oro.>> ");
INSERT INTO llu_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Haia, ana si kada Jesus fai nia oote fafurongo nia gi da lea ua kou fui Jerusalem, gera ka liufia na kou maefera i Jeriko. Ma si kada gera ka lea faasia na fera nae, na tooa oro asianaa gera lea mai sulida. ");
INSERT INTO llu_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ma na roo wane maada e rodo daaro gwouru kamena tala. Ma si kada daaro rongoa Jesus e lea mai sulia tala, daaro ka rii naa, daaro ka urii, <<Oe na aaofia ana kwalafaa a David, o manatai gemere mai!>> ");
INSERT INTO llu_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ma si kada na tooa gi gera rongo daaro, gera ka ngatafi daaro ma gera ka urii, <<Moro too aaroaro!>> Sui si kada gera bae urinae, daaro kafi rii baita tasa lau urii, <<Oe Aaofia ana kwalafaa David, o manatai gemere mai>> ");
INSERT INTO llu_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ma si kada Jesus e rongo daaro rii mai urinae, nia ka take, ma ka soeda mai, ma ka ledida ka urii, <<Taa na moro dooria nau kuka iilia fuamoro?>> ");
INSERT INTO llu_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Daaro oolisia daka urii fuana, <<Gemere dooria oko aadea tesi doo fuamere eeri na maa mere ka aada lau.>> ");
INSERT INTO llu_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Haia, a Jesus e kwaimanatai asianaa fuadaaro, ma nia ka hamosia maa daaro gi. Ma ana si kada nae ua go, na maa daaro gi ka aada naa, ma daaro ka lea naa fai nia Jesus. ");
INSERT INTO llu_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ma a Jesus ma na oote fafurongo nia gi gera dao garangia naa i Jerusalem, ana fera i Betfeis, i gwouna fe uuo i Olivtri. I seenae, a Jesus ka falea roo wane ana na oote fafurongo nia gi, daaro ka eeta i nao, ");
INSERT INTO llu_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ma ka bae fuadaaro ka urii, <<Moro lea ana fera loko na moro naofia kou, ma tara moro ka daotoona tee doo fai ae na hatana na dongki, da kani faafia i seenae fai nia na galena. Moro luke daaro, ma moro ka ngalia mai siagu. ");
INSERT INTO llu_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ma lea ta wane ka haea tesi doo fuamoro, moro ka haea fuana moro ka urii, <Na Lord naa e dooria.> Ma tara aliꞌali nia ka faalamainia fuamoro.>> ");
INSERT INTO llu_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Si doo naa e fuli hai ka faamamanaa si taa baa na profet e haea ka urii, ");
INSERT INTO llu_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","<<Molu ka haea fuana tooa gi i Jerusalem muka urii, <Rikia fasi. Na Aaofia gamu e lea na mai siagamu. I nia e faatoꞌou nia, ma ka tae mai i fafona na gale dongki.>>> ");
INSERT INTO llu_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ma na roo wane naa gi ana na oote fafurongo nia gi, daaro ka eeta naa i nao ma daaro iilia naa si doo naa gi a Jesus e haea fuadaaro hai daaro ka iilia. ");
INSERT INTO llu_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Daaro talaia mai na dongki nae ma na galena, ma daka hamatainia na maku gera gi i fafona galena, ma a Jesus ka tae i fafona. ");
INSERT INTO llu_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ma na tooa oro asianaa da hamatainia na maku gera sulia na tala, ma teni tooa gi da tabalia na aba senge ana niu gi, ma daka hamatainia sulia na tala uria faabaitalana Jesus. ");
INSERT INTO llu_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Na figua baita gi na da eeta i nao ana a Jesus ma daka isi kou i buira, daka rii ma daka urii, <<Na baelafelaa fuana kwalafaana a David na aaofia! God ka faadiana na wane na e lea mai ana hatana na Lord! Gia ka baelafea a God!>> ");
INSERT INTO llu_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ma si kada a Jesus e dao i Jerusalem, na fera ka ngalu asianaa, ma teni tooa gi da ledida daka urii, <<Ni tei naa?>> ");
INSERT INTO llu_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ma na figua nae gi daka urii, <<Nia a Jesus na profet, na wane faasia na fera i Nasaret i laona na lolofaa i Galili.>> ");
INSERT INTO llu_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Si kada Jesus e lea ma ka dao laona labata ana Beu Aabu nia a God, nia ka taria na tooa gi gera uusi ada i seenae. Ma nia ka faaꞌasiaa na tafe gi na wane nae gi na da tatala ana na malefo, ma ka faaꞌasiaa na doo gi ni gwourulaa gera tooa gi na da faafoli ana na bola gi. ");
INSERT INTO llu_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ma Jesus ka bae urii fuana tooa nae gi, <<Na Baelana God i laona Kekedelaa Aabu nia bae urii, <Na Beu Aabu nau naa, gera alangia ana beu ni fooa.> Haia, ma ni gamu mu aadea ka hau na ana beu gera tooa bebeli gi!>> ");
INSERT INTO llu_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ana si kada nae, teni tooa maada e rodo, ma teni tooa aeda e mae, gera lea mai siana Jesus laona labata na i maana Beu Aabu a God, ma nia ka gurada teefou. ");
INSERT INTO llu_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Haia, ma na fataabu baita gi ma na faatolomai gi ana kwaieresia gi, gera ka rakehasu asianaa si kada gera rikia doo diana gi na a Jesus e iilia, ma gera ka rongoa gala wela gi da rii daka urii, <<Baelafea na Aaofia na e futa mai ana aebara a David na aaofia.!>> ");
INSERT INTO llu_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Haia, na fataabu baita gi ma na faatolomai gi, gera ka bae urii fuana Jesus, <<Oe rongoa taa na gera haea? Utaa na langi osi baeluida?>> Ma Jesus ka oolisida urii, <<Iiuka, nau ku rongoa. Ma baelafelagu e diana asianaa. Langi molu si iidumia go baelaa baa laona Kekedelaa Aabu? Nia e bae urii, <Oe o toolamainia na gala wela eeri daka baelafe oe i talamu.>>> ");
INSERT INTO llu_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Sui i buira, Jesus fai nia oote fafurongo nia gi gera ka lea faasia i Jerusalem, ma gera ka lea fuana i Betani. Ma si kada rodo e dao, gera ka teo i seenae. ");
INSERT INTO llu_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ubongia ana ruana maedani, si kada Jesus fai nia oote fafurongo nia gi gera ooli mai fuana i Jerusalem, a Jesus ka fiolo. ");
INSERT INTO llu_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ma nia ka rikia tee ai figi e take ninimana tala, ma ka lea i aena, sui ka langi si rikia ta fufue doo, ma na abana gi go ana. Ma nia ka bae urii fuana ai figi nae, <<Sulia langi osi aalua ta fufue doo, haia ita ana si kada na langi osi fungu lau!>> Ma ana si kada nae ua go, na ai nae ka mae naa. ");
INSERT INTO llu_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Kada fafurongo gi da rikia si doo nae, gera ka kwele asianaa. Ma gera ka ledia urii, <<Taa naa e aadea na ai naa ka mae aliꞌali go ana naa?>> ");
INSERT INTO llu_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Haia, Jesus ka oolisida ka urii, <<Nau ku haea fuagamu, lea molu manata mamana ma langi molu si manata ruarua, gomolu haitamana molu ka iilia go amolu doo baita gi liufia si doo na ku iilia ana ai figi naa. Lea so molu ka haea fuana fe tolo naa, <O lea, oko too la aasi,> haia nia tara ka lea na ana. ");
INSERT INTO llu_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Haia, lea molu manata mamana ana God, tesi ta boroi ana molu gania i laona fooalaa, God haitamana nia ka falea fuagamu.>> ");
INSERT INTO llu_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Haia, ana si kada a Jesus e ooli lau laona labata ana Beu Aabu a God uria faatolomailana tooa, na fataabu baita gi ma teni wane baita gera Jiu gi gera ka lea mai siana. Ma gera ka soeledia urii, <<Haia na mamanaa utaa na o too ana oko iilia ana si raoa naa gi? Ma ni tei na e falea mamanaa nae fuamu?>> ");
INSERT INTO llu_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ma a Jesus e oolisida ka urii, <<Haia, nau laugo nau ku soeledi gamu fasi uria tesi doo. Lea molu oolisi nau, tara nau laugo kuka haea tei na e falea mamanaa fuagu kuka iilia ana doo nae gi. ");
INSERT INTO llu_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Utaa? Tei naa e falea mamanaa fuana John ka siuabua ana tooa, a God, langi wane go ana?>> Ana si kada nae, gera ka bae ada i talada, gera ka urii, <<Lea golu haea God naa e falea mamanaa fuana John ka iilia, tara Jesus ka soeledi golu urii, <Ma utaa naa molu si manata mamana ana John?> ");
INSERT INTO llu_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ma lea golu haea urii, <Wane go ana na falea mamanaa fuana John ka siuabua ana tooa, langi lau God,> tara tooa gi daka rakehasu fuagolu.>> Gera mou, sulia na tooa gi da haea a John nia na profet. ");
INSERT INTO llu_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Nia na gera ka oolisia urii go ada fuana Jesus, <<Gemelu lalafusia ni tei naa e haea fuana John ka siuabua tooa.>> Ma Jesus ka bae urii fuada, <<Haia, urinae, nau laugo kusi haea fuagamu ni tei naa e falea na mamanaa naa fuagu.>> ");
INSERT INTO llu_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ma a Jesus e bae lau ka urii, <<Molu manata utaa sulia si doo naa? Tee wane e too ana roo wela wane. Ma i nia e lea siana na wela i nao, ma ka bae urii fuana, <Alakwa nau ae, taraꞌena o lea ma oko rao i laona na raoa golu baa.> ");
INSERT INTO llu_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","<<Ma i nia e oolisia ka urii, <I nau ku oote nau.> Ma sui i buri, nia ka bulasia na manataa, ma ka lea naa i laona na raoa. ");
INSERT INTO llu_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ma i buri, na maa ka lea lau siana na ruana wela aai, ma ka haea laugo tesi baea baa. Ma na wela aai naa e oolisia ka urii, <I nau tara kuka lea.> Ma sui nia ka langi si lea go. ");
INSERT INTO llu_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","<<Haia, ni tei adaaro naa na e iilia si doo baa na maa daaro e dooria?>> Ma gera da oolisia daka urii, <<Na wela baa i nao.>> Ma a Jesus ka bae urii fuada, <<Doo mamana nau ku haea fuagamu, na wane taꞌa gi na da gonia na malefo ana na takisi ma na geni ooeoe gi, tara gera ruu ada i laona na Initooa a God i nao ani gamu. ");
INSERT INTO llu_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Sulia a John Siuabu baa e dao na mai siagamu uria na faatailana na tala ana oꞌoloa, sui langi musi manata mamana go ani nia. Haia, na wane faafefe gi na da gonia malefo ana na takisi ma na aai ooeoe gi gera ka manata mamana ada ani nia. Ma sui boroi ana muka rikia na doo nae gi, langi musi oolitai manata go, ma langi musi manata mamana go ani nia.>> ");
INSERT INTO llu_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","A Jesus e bae lau fuada ka urii, <<Molu rongoa fasi tee si baea oomelawanea naa lau. Tee wane e fasia na raoa. Ma nia ka haungainia rara galia, ma ka elia tee kilu uria na felesilana na fufue ai gi uria na waen, ma ka tolea tee luma uria na fololaa. Sui nia ka aalua na raoa nia nae i abada teni wane gi na da rao i hara gi, ma ka lea ana uria tee aefera aai. ");
INSERT INTO llu_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ma si kada ni gonidoolaa e dao, nia ka oodua na wane ni rao nia gi siada na wane baa gi na nia e faalamainia na raoa baa fuada, uria ta bali fufue ai nia. ");
INSERT INTO llu_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","<<Ma na wane nae gi na e faalamainia na raoa na fuada da daua na wane ni rao nia gi, ma gera ka rabusia tee wane, ma ruana wane aai gera ka haumaelia naa, ma ooula wane aai gera ka uia na ana fou uria haungilana. ");
INSERT INTO llu_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Sui nia ka oodua lau teni wane oro ni rao gi lau siada liufia i nao. Ma na wane nae gi na e faalamainia na raoa fuada, daka aade urii baa laugo ada. ");
INSERT INTO llu_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ma i iꞌisi, nia ka oodua na wela wane nia siada. Ma nia ka manata urii, <Gera tara daka manata baita go ada ana na wela nau.> ");
INSERT INTO llu_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","<<Sui ma ana si kada na wane nae gi da rikia na wela nia, daka bae kwailiu naa fuada daka urii, <Nia naa na wela nia na wane na e too ana na raoa naa. Golu haumaelia, eeri golu ka ngalia agolu na doo nia naa gi sui.> ");
INSERT INTO llu_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ma gera dau ana ma daka ui ania i maa faasia na raoa nae, ma daka haumaelia. ");
INSERT INTO llu_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","<<Nia naa si kada na wane na e too ana na raoa e dao mai, si taa naa nia tara ka iilia fuana na wane nae gi?>> ");
INSERT INTO llu_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ma gera oolisia daka urii, <<Nia ka haumaelia na wane taꞌa nae gi, ma nia ka faalamainia na raoa nia fuana teni wane aai gi, na tara daka falea ta bali aai fuana ana si kada ana gonidoolaa.>> ");
INSERT INTO llu_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ma a Jesus ka bae urii fuada, <<Utaa naa musi rongo diana go ana Kekedelaa Aabu baa e urii, <Si fou baa na wane gi na da tolea na beu da oote gera ana, nia naa e hau ana si fou initoo ka tasa. Ma si doo naa, a Lord naa e iilia, ma ka diana asianaa.> ");
INSERT INTO llu_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","<<Ma nia naa ku haea fuagamu, a God tara ka lafua na Initooa nia faasi gamu, ma ka falea ana fuada na tooa gi na daka roosuli nia. ");
INSERT INTO llu_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","So ni tei na e asia fafona na fou naa, tara fou na ka labasia naa. Ma so ni tei naa na fou nae ka asia i fafona, nia ka maga ngisingisia naa.>> ");
INSERT INTO llu_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ma si kada na fataabu baita gi ma na Farisi gi gera rongoa si oomelawanelaa nae gi, gera ka aada haitamana a Jesus e bae suli gera. ");
INSERT INTO llu_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Nia naa gera dooria gera ka dumulia. Sui taa, gera ka mou sulia na tooa oro gi gera koni ana si kada nae, sulia na tooa gi gera ka manata fuana Jesus i nia na profet. ");
INSERT INTO llu_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","A Jesus e bae lau ana oomelawanea fuada na tooa gi ka urii, ");
INSERT INTO llu_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","<<Na Initooa i Langi e urii: Tee aaofia e haungainia na fangaa ana baraa na fuana na alakwa nia na aarai ana. ");
INSERT INTO llu_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ma i nia ka oodua na wane raoa nia gi siada na wane gi na i nia e soeda mai uria na fangaa nae, hai daka lea mai. Sui daka oote gera ada ni lealaa mai. ");
INSERT INTO llu_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","<<Sui i nia ka oodua lau teni wane ni rao, ka bae urii fuada, <Molu ka faarongo na wane naa gi ku soeda, na fangaa nau e aade aagau sui naa. Nau ku haungia sui naa na bulumakau baita nau gi ma na gale bulumakau diana nau gi, ma na doo gi sui e aade aagau sui naa. Molu lea na mai ana na fangaa.> ");
INSERT INTO llu_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","<<Sui langi dasi dooria go roolaa sulia, ma daka lea eꞌete ada. Tee wane e lea na ana uria laona raoa nia, ma ta wane aai e lea ana uria i laona na sitoa nia. ");
INSERT INTO llu_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ma teni wane aai gi da ngiria na wane ni rao nae gi, daka kwaeda, ma daka haumaelida. ");
INSERT INTO llu_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ma na aaofia naa ka rakehasu asianaa, ma nia ka oodua na wane oomea nia gi, ma daka haungia na wane nae gi na da haumaelia na wane ni rao nia gi. Ma daka suungia na fera baita gera. ");
INSERT INTO llu_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","<<Sui i nia ka bae urii fuada na wane ni rao nia gi, <Na fangaa e aade aagau naa, sui na wane baa gi ku soeda, dasi faorana lealaa mai uria na fangalaa fai gemelu. ");
INSERT INTO llu_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Molu lea sulia na tala gi, ma molu ka soea mai na tooa gi sui na molu daotooda, daka lea mai ana fangaa naa.> ");
INSERT INTO llu_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ma na wane ni rao gi daka lea sulia na tala gi, ma da oofua mai na tooa gi sui na da daotooda. Ma na fangaa ana na baraa nae ka fungu ana tooa diana gi ma na tooa taꞌa gi. ");
INSERT INTO llu_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","<<Sui si kada na aaofia e dao mai uria na rikilana na tooa gi na da dao, nia ka rikia tee wane na e langi kasi oofi ana na aai maku ana na baraa. ");
INSERT INTO llu_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ma na aaofia ka ledia ka urii, <Ruana ae, o ruu mai utaa i seenaa naa, doo na langi osi oofi go ana na maku ana na baraa?> Ma na wane nae ka langi si bae go. ");
INSERT INTO llu_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","<<Sui na aaofia ka haea fuana na wane ni rao nia gi ka urii, <Molu kani faafia na abana ma na aena wane naa, ma molu ka ui ani nia i laona na gula rorodoa na i maa ana si gula ana aangilaa ma na girigiri lifoa.> ");
INSERT INTO llu_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Sulia na tooa oro gi na a God e soeda, sui taa na aange tooa go na e filida.>> ");
INSERT INTO llu_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Na wane Farisi gi da lea ma daka haungainia na manataa uria na faagarolana a Jesus ana si doo gi na nia e haeda. ");
INSERT INTO llu_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ma gera ka oodua teni fafurongo gera gi fai nia teni wane gi a Herod siana a Jesus. Ma daka bae urii, <<Faatolomai ae, i gemelu melu haitamana i oe o haea na doo mamana gi, ma oko faatolomai mamanaa sulia na malutaa nia a God. Ma ka langi osi manata aꞌabo go sulia na doo gi na tooa gi da haea suli oe, sulia e langi osi manata baita go ana na babaitaa gera na tooa gi. ");
INSERT INTO llu_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Nia naa, o haea fasi mai na manatalamu fuamelu. Nia bobola go ana ana kwaieresia gia Jiu gi hai melu ka falea na malefo ana na takisi fuana na aaofia i Rom, na hatana a Sisa, ma e langi?>> ");
INSERT INTO llu_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ma a Jesus e haitamana sui naa na manatalaa taꞌa gera, ma ka bae urii, <<I gomolu na wane susuge gi, uria taa na molu ka hasi uria na faagarolagu? ");
INSERT INTO llu_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Molu faatainia fasi na malefo na molu folia ana na takisi.>> Ma gera ka ngalia mai tee fe malefo, daka faatainia fuana. ");
INSERT INTO llu_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ma nia ka ledi gera ka urii, <<Na nununa ni tei naa e nii i fafona malefo naa? Ma na hatana ni tei naa?>> ");
INSERT INTO llu_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ma gera oolisia daka urii, <<A Sisa.>> Ma a Jesus ka bae urii fuada, <<Molu oolifainia si doo nia gi a Sisa fuana a Sisa, ma molu ka oolifainia si doo nia gi a God fuana a God.>> ");
INSERT INTO llu_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ma si kada gera rongoa ana na oolisilana nae e diana urinae, gera ka kwele asianaa, ma daka tafusi nia, daka lea na ada. ");
INSERT INTO llu_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ma ana fe dani nae laugo, teni Sadusi gi gera lea mai siana Jesus. Na Sadusi gi gera haea wane afetai ka tatae lau buira nia e mae naa. Si kada gera dao siana Jesus, gera ka soeledia daka urii, ");
INSERT INTO llu_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","<<Faatolomai ae, kwaieresia Moses gi nia bae urii, <Lea ta wane e mae faasia afe nia, ma langi daaro si too go ana ta wela naa, haasina haitamana ka aadea go ana na geni nae. Ma lea daaro ka too ana teni wela ana si kada nae, na wela nae gi wela nia wane baa e aadea na geni naa i nao sui ka mae faasia, sui boroi ana gera ka futa ana haasina.> ");
INSERT INTO llu_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Haia, tee aebara ani golu Jiu gi gera too ana fiu waihaasina. Haia, na uulunao e aadea tee haari. Haia, ma ana si kada daaro si too ua ana ta wela, wane nae ka mae na ana. ");
INSERT INTO llu_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ruana wane ka aadea geni naa. Haia, ma ka langi daaro si too ua ana ta wela laugo, ma nia ka mae naa laugo ana. Ooula wane ka aadea lau, ka mae laugo. Nia urinae lelea fiu waihaasina nae gi, gera mamae ka sui. ");
INSERT INTO llu_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Buira bare waihaasina naa gi gera mae, geni naa ka mae naa laugo. ");
INSERT INTO llu_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Haia, ma na geni na nia aadea mai fiu waihaasina naa gi. Lea urinae, si kada tooa gi da tatae faasia maea, tara ni tei ana fiu waihaasina nae gi naa aarai nia mamana?>> ");
INSERT INTO llu_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesus e oolisi gera ka urii, <<Gomolu naa langi molu si haitamana go na Kekedelaa Aabu ma langi molu si haitamana go si taa naa God e haitamana ka iilia. Nia naa e aadea molu ka garo asianaa. ");
INSERT INTO llu_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Sulia i buira tataea faasia tooa gi da mae, nia langi go ta aade genia ma ta toowanea. Sulia ana si kada nae, tara tooa gi gera ka too na ada mala na ensel a God gi i langi. ");
INSERT INTO llu_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Haia, ma na baelaa sulia tooa da mae tara daka tatae lau, God e haea ua na mai. Ma ni gomolu langi molu si manatatoona go taa gi baa molu iidumida laona Kekedelaa Aabu? ");
INSERT INTO llu_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ana kada baa God e bae fuana Moses sulia koo gia baa gi Jiu baa gera mae ua na mai baa, nia bae urii, <I nau naa a God a Abraham, ma a God a Aesak, ma a God a Jakob.> Haia, na malutana na baelana nae, sui boroi ana daalu da mae naa, a God e haitamana daalu mouri ua go ada fai nia.>> ");
INSERT INTO llu_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ma ana si kada tooa oro na gera koni galia Jesus da rongoa si doo nae gi, gera ka kwele asianaa ana faatolomailaa nia. ");
INSERT INTO llu_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ana si kada na Farisi gi da rongoa a Jesus e faabonaa na Sadusi gi, gera oofu mai siana. ");
INSERT INTO llu_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ma tee wane ada na faatolomai ana kwaieresia gi, nia ka iiliili uria faagarolaa a Jesus ana si ledilaa ka urii, ");
INSERT INTO llu_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","<<Wane faatolomai ae, na kwaieresia taa na e baita liufia kwaieresia gia gi?>> ");
INSERT INTO llu_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ma a Jesus e oolisia ka urii, <<Oko rakediana fuana a Lord na God oe ana na liomu teefou, ma ana na mangomu teefou, ma ana na manatalamu teefou. ");
INSERT INTO llu_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Nia naa na kwaieresia totongenao ma ka baita tasa. ");
INSERT INTO llu_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ma ruana kwaieresia e iilingia laugo e urii, <Oko rakediana fuana na tooa aefera oe, iilingia o rakediana ani oe i talamu.> ");
INSERT INTO llu_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ma na kwaieresia gi sui go faasia a Moses ma na faatolomaia gera na profet gi gera lea sui go mai faasia na roo kwaieresia naa gi.>> ");
INSERT INTO llu_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ana si kada teni Farisi gi da koni galia Jesus, nia ka soeledi gera ka urii, ");
INSERT INTO llu_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","<<Gomolu haea ni tei na Christ na wane na God e aadafilia uria Aaofialaa, e futa mai ana?>> Gera ka oolisia urii, <<Tara Christ ka futa mai ana aebara a David na aaofia.>> ");
INSERT INTO llu_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Sui a Jesus ka ledi gera lau, <<Lea so nia ka futa go ana ana aebara a David na aaofia, uria taa na Aanoedoo Aabu ka falea na manatalaa fuana a David ka alangia wane ana Lord? Sulia a David e bae urii mai nao, ");
INSERT INTO llu_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","<A God e bae urii fuana Lord nau: Oko gwouru i bali aaolo ani nau, eeri oko initoo fai nau maasia si kada tara kuka saitasa ana maalimaea oe gi.> ");
INSERT INTO llu_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Haia, ma lea David na aaofia e alangia Christ ana Lord nia, na Christ ka sifo utaa mai faasia na kwalafaa nia a David go ana?>> ");
INSERT INTO llu_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ma ana si kada nae, langi ta wane ani gera ka bobola uria oolisilanalaa tesi doo. Ma gera ka ida na ada uria soeledilana Jesus lau. ");
INSERT INTO llu_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","A Jesus e bae fuana na tooa gi na da figu mai ma na oote fafurongo nia gi ka urii, ");
INSERT INTO llu_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","<<Na wane faatolomai doo ana kwaieresia gi ma na Farisi gi gera too mamanaa uria na faatolomailaa ana kwaieresia a Moses gi. ");
INSERT INTO llu_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Nia naa, molu ka roosuli gera ma molu ka iilia na doo gi sui na da haea fuamolu. Sui taa, e langi molu si iilia na doo na gera iilida, sulia langi dasi iili go sulia si doo na da bae sulia. ");
INSERT INTO llu_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Gera falea si raolaa oro na e afetai fuana na tooa gi, iilingia da kania na oko gulu gi faafida, sui langi dasi maabe go uria kwaiꞌadomilaa tooa gi uria na koulana. ");
INSERT INTO llu_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","<<Ma gera iilia na doo gi sui hai so na tooa gi daka rikida. Molu rikia fasi na rebe doo baita gi na da kedea na Kekedelaa Aabu gi ana na daka kania i maadara ma i abada. Ma molu ka rikia fasi amolu na maku gera gi e fisira tekwa. ");
INSERT INTO llu_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ma daka dooria asianaa na gwourulaa ana si gula initoo ana na fangaa gi, ma si gula initoo gi ni gwourulaa i laona Beu Aabu gi. ");
INSERT INTO llu_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ma daka dooria asianaa ana na faabaitalada i maana uusia gi, ma na alangilada ana wane Faatolomai gi. ");
INSERT INTO llu_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","<<Haia, ma e langi kasi diana uria na alangilagamu ana na wane faatolomai doo, sulia gomolu too go ana tee wane Faatolomai doo, ma i gomolu na bare waidoorana gi sui go. ");
INSERT INTO llu_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ma e langi musi alangia ta wane la molaagali na ana na maa gamu, sulia i gamu mu too go ana tee Maa na e too mai langi. ");
INSERT INTO llu_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ma e langi dasi alangi gamu ana na wane baita, sulia i gamu mu too go ana tee wane baita, ma i nia naa nau, na Christ. ");
INSERT INTO llu_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Lea so ta wane na ka baita i matangagamu, nia ka aalua na wane ni rao. ");
INSERT INTO llu_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ma so ta wane ka faabaita nia i talana, a God tara ka faatoꞌou nia. Ma so ta wane ka faatoꞌou nia i talana, tara a God ka faabaita nia.>> ");
INSERT INTO llu_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Ma Jesus ka bae lau urii, <<E taꞌa asianaa fuagamu na faatolomai gi ana kwaieresia gi ma i gamu laugo na Farisi gi na tooa susuge! Tara a God e kwae gamu, sulia gamu muka bilakea na maa ana Initooa i Langi suusia na tooa. Gamu laugo langi musi dooria go hasa molu ka ruu lao Initooa a God, ma molu ka suusia tooa na da haasi uria ruulaa. ");
INSERT INTO llu_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","E taꞌa fuagamu na faatolomai gi ana kwaieresia gi ma i gamu na Farisi gi na mu aadea na doo gi eeri tooa gi gera ka hae e gamu na tooa diana gi. Sui taa, tara God ka kwae gamu, sulia mu faafefe ana gwe oru gi ma muka laua na luma gera gi fuagamu. Sui boroi ana molu ka urinae, molu ka iilia fooalaa tekwa gi, eeri na tooa gi gera ka haea gamu na tooa a God. Tara na kwakwaelaa gamu gi ka baita ka tasa, sulia mu iili urinae. ");
INSERT INTO llu_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","E taꞌa fuagamu na faatolomai gi ana kwaieresia gi ma i gamu na Farisi gi na tooa susuge na gamu aadea tooa gi eeri gera ka haea gamu na tooa diana gi. Haia, tara God ka kwae gamu, sulia mu uulafu asianaa ana galilaa gula gi sui, lao aasi ma i la tolo, uria daotoolana ta wane, eeri ka lea suli gamu. Haia, ma ana si kada wane naa e lea go suli gomolu, molu kafi aade aagau go ani nia uria lealaa fuana si gula ana maea. Haia, ma na kwakwaelaa nia tara ka tasa liufi gomolu sulia na aabulolana e taꞌa liufi gomolu sui naa. ");
INSERT INTO llu_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","<<Haia, ni gamu mu iilingia na wane maa rodo gi na da talaia na tooa. Nia naa, tara a God ka kwae gamu asianaa. Sulia mu faatolomainia tooa gi urii, <So ni tei na e tofe ma ka bae urii: Mamana mai ana Beu Aabu a God, nia e diana go ana lea nia langi kasi iilia si taa naa nia tofe uria. Ma lea nia bae urii: Mamana mai siana gold loko laona Beu Aabu nia God, nia naa e aabu asianaa uria oilana tofelaa nia.> ");
INSERT INTO llu_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Gamu maa rodo ma muka nue asianaa. Taa naa na e baita, na gold ma langi na Beu Aabu naa na e aadea gold na ka aabu? Na Beu Aabu a God na e baita liufia na gold! ");
INSERT INTO llu_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ma laugo muka faatolomai nia na tooa gi urii, <So ni tei naa e tofe ma ka bae urii: Mamana mai fafona fuli eere, nia diana go ana lea so nia langi si iilia taa naa nia haea. Ma lea nia bae urii: Mamana mai siana kwaisuusia na e too fafona fuli eere, nia na e aabu ka tasa uria oilana tofelaa nia baa.> ");
INSERT INTO llu_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Gamu mu iilingia na tooa maa rodo, sulia gamu mu ooewanea asianaa. Si taa naa e baita, kwaisuusilaa ma langi na fuli eere naa na e aadea si kwaisuusilaa naa ka aabu? Na fuli eere naa e initoo liufia na kwaisuusilaa. ");
INSERT INTO llu_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Haia, nia nae, lea so ni tei na e tofe ma ka haea fuli eere, tama nia haea na fuli eere loko fai nia doo gi sui na e too i fafona fuli eere nae. ");
INSERT INTO llu_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ma so ni tei na e tofe, ma ka haea Beu Aabu nia a God, nia urinae tama nia haea na God na e too laona Beu Aabu nae naa. ");
INSERT INTO llu_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ma lea ta wane ka tofe ana langi, tama nia haea fuli gwouru nia God nae, ma God laugo. ");
INSERT INTO llu_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","<<E taꞌa fuagamu na faatolomai gi ana kwaieresia gi ma i gamu na Farisi gi, mu susuge ana aadelaa gamu gi, ma tara God ka kwae gamu. Gamu falea tangafulu ana si doo gi fuana God ana gala si doo gi na mu fasida laona raoa gamu gi, sui langi musi manata aꞌabo go uria roosulilana faatolomailaa baita ana kwaieresia gi. Na faatolomailaa baita gi ana kwaieresia gi e bae urii, <Wane ka iilia na doo gi sui na e olo fuana tooa aai. Nia ka kwaimanatai fuana tooa ma ka haea si doo mamana gi.> Muka iilia na doo nae gi, fai nia na doo toꞌou gi i laona kwaieresia gi laugo. ");
INSERT INTO llu_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Gamu iilingia na wane maa rodo na e talaia na tooa. Gamu haitamana go agamu manata aꞌabolaa uria lealaa sulia gala si doo gi laona kwaieresia gi. Sui gamu langi musi manata aꞌabo go ana si doo baita gi laona kwaieresia gi. Kada mu iili urinae, si doo na nia aada mala molu lafua go amolu si lolo faasia si taa naa mu gwoufia, sui muka gwoufia go amolu na subu baita baa. ");
INSERT INTO llu_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","<<Gamu na faatolomai gi ana kwaieresia gi ma i gamu na Farisi gi na mu haitamana aadelana si doo gi eeri tooa gi gera ka hae diana ani gamu. Haia, tara God ka kwae gamu, sulia mu dooria na doo oro gi ma muka bebeli. Gamu iilingia ta wane e manata go ana uria tagasilana noina kakao ni gwou gi ma na doo gi ni fangalaa, ma i laoda gera bilia asianaa. ");
INSERT INTO llu_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Gamu na Farisi gi na maa gamu e iilingia rodo! Mu oolisia na manatalaa gamu gi ka faalu eeri muka haitamana tagasilana laona kakao gi ma na tatae doo gi ni fanga. Lea na manatalaa gamu ka faalu, na aabulolaa gamu ka faalu laugo. ");
INSERT INTO llu_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","<<Gamu na faatolomai gi ana kwaieresia ma i gamu na Farisi gi, mu aadea tooa gi gera ka haea gamu na tooa diana gi. Sui taa, tara God ka kwae gamu, sulia gamu mu iilingia kwaingeia gi na gera haungai diana ana bali maa, ma i laona e fungu ana ogi fai nia na nonina tooa na gera mae ma daka fura gi naa. ");
INSERT INTO llu_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Si doo naa nia mamana ani gamu, sulia si taa gi na gamu iilia gi nia aada diana asianaa maana tooa gi. Haia, na manatalaa gamu ka taꞌa asianaa, ma gamu ka haitamana na sugelana tooa. ");
INSERT INTO llu_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","30","<<Gamu na faatolomai gi ana kwaieresia gi, ma i gamu laugo na Farisi gi, gamu haitamana aadelana na doo gi fuana tooa gi gera ka haea gamu tooa diana asianaa. Sui taa, tara God ka kwae gamu, sulia mu haea lea so molu ka too ana si kada i nao, langi gamu kasi adomia go na koo gamu gi uria haungilana na profet gi. Sui muka aalua na fou diana ni faamanatatoolaa i fafona kwaingeia gera profet gi ma na tooa diana gi i nao. ");
INSERT INTO llu_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Haia, nia faatainia gamu naa na kwalafaa na koo taꞌa gamu na da haungia na profet gi i nao. ");
INSERT INTO llu_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Haia, ma lea urinae, gamu laugo mu aadea na agamu si doo nae! ");
INSERT INTO llu_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","I gamu naa na aabulolaa gamu e iilingia na loi gi. E afetai asianaa hasa molu ka tafi faasia si kwakwaelaa ana eere i gula ni maea. ");
INSERT INTO llu_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Haia, si doo nau ku iilia tara nau ku oodua teni profet ma teni wane haitamadoo ma teni faatolomai gi siagamu. Haia ma ni gera na tara bali ada muka haumaelida ma muka fotoida ana airarafolo. Haia, ma bali ada tara muka dumulida ma muka rabusida i laona Beu Aabu ni fooa gamu gi, ma muka tari kwailiu ani gera faasia lao maefera gamu gi. ");
INSERT INTO llu_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Nia naa aadea tara a God ka kwae gamu faafia na haumaelilana na tooa gi sui, talaꞌae mai ana maelana Ebol na wane oꞌolo lea mai ka dao ana maelana Sekaraea, wela a Barakaea na gamu na Jiu gi mu haumaelia matanga na Beu Aabu a God ma na fuli eeri. ");
INSERT INTO llu_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nau ku haea fuagamu na kwakwaea uria maelana tooa nae gi sui tara ka too i fafo gamu tooa ana kadamanga naa.>> ");
INSERT INTO llu_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ma Jesus e aada kou fuana fera i Jerusalem, ma ka bae urii, <<Tooa i Jerusalem ae! Gamu baa mu uia fou gi uria haumaelilana na profet gi baa na a God e falea fuagamu. Kada oro nau ku doori muka lea mai siagu, haia kuka aada suli gamu iilingia na kakaraikua baa e gonitainia na galena gi farana kukubana. Sui taa, langi molu si dooria go. ");
INSERT INTO llu_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Haia, mu rongoa, tara God ka tafusia na Beu Aabu nia i fera gamu, ma na Beu nia ka gwou go ana. ");
INSERT INTO llu_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Haia, ma ni nau ku haea laugo, tara langi musi riki nau lau lea ka dao ana si kada gamu muka bae suli nau, muka urii, <A God ka faadianaa na wane na e lea mai ana na hatana a Lord.>>> ");
INSERT INTO llu_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ma i buira Jesus e bae urinae sui, nia ka lea faasia Beu Aabu nia a God. Ma ana si kada a Jesus e lea kou, na fafurongo nia gi gera ka lea mai siana, ma gera ka bae urii, <<Wane baita ae, aada oko rikia fasi amu na Beu Aabu diana naa gi.>> ");
INSERT INTO llu_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jesus ka bae urii fuada, <<Iiuka. Beu nae gi e diana. Sui taa, nau ku hae fuagamu, sui boroi ana molu rikia na Beu loko gi, tara tesi fou kasi too i fafo ta fou. Tara daka aatoli teefou i hae gano.>> ");
INSERT INTO llu_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Buira, Jesus ka tae gwouna fe uuo i Olivtri, ma ana si kada nia e gwouru ana, oote fafurongo nia gi gera ka lea mai siana, ma gera ka too taifili gera. Ma gera ka soeledia Jesus urii, <<Si kadamanga taa na tara na doo naa gi o haeda fuamelu tara ka dao mai? Haia, ma si taa naa tara ka dao mai eeri ka faatainia kada oe uria oolilaa mai fai nia si kada tara na molaagali na ka funu ana?>> ");
INSERT INTO llu_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","5","A Jesus e oolisi gera ka urii fuada, <<Muka aada suli gamu, sulia tooa oro gi na tara gera lea mai i nunufana hatagu, ma gera ka suge gamu, daka bae urii, <Nau na Christ na wane baa God e aadafilia.> Ma ana si kada gera aadea ana si doo nae gi, tara na tooa oro gi gera ka manata mamana ana sugelaa gera nae gi. Haia, ma ni gamu, muka aada suli gamu, aata ta wane ada ka suge gamu ma muka manata mamana ana sugelaa gera gi. ");
INSERT INTO llu_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ma tesi doo lau, tara muka rongoa lingeena firulaa ana teni fera garangi gi ma na uunuunulaa gi sulia firulaa gi ana teni fera tau mai laugo. Ka urinae boroi ana, langi molu si manata aꞌabo sulida. Si doo urinae gi tara ka dao na mone mai ana, sui langi lau hasa nia urinae go na suilana molaagali naa. ");
INSERT INTO llu_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ma tara teni tooa daka firu fai nia teni tooa aai gi, ma teni initooa daka firu fai nia teni initooa aai gi. Ma tara na uunifioloa gi daka liu ma daka toea wane oro lao molaagali, ma tara na aanuanu gi daka geloa fera gi sui lao molaagali naa laugo. ");
INSERT INTO llu_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Sui boroi ana si doo naa gi gera ka dao mai urinae, nia na hafalilana go ana si kada gi ana afetaia gi nae. Ma si doo nae gi e iilingia go ana na geni faafuta e hafali fiiwela. ");
INSERT INTO llu_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","<<Haia, ana si kada nae laugo, tara na tooa ana maefera eꞌete kwailiu lao molaagali naa, langi gera kasi doori gamu, sulia gamu na tooa nau. Ma tara teni wane ada gera ka dumuli gamu, ma gera ka fale gamu fuana maalimaea gamu gi uria kwaelagamulaa ma uria haumaelilagamulaa. ");
INSERT INTO llu_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ma sulia si doo naa, tara tooa oro gi na da manata mamana ana God, tara langi gera si tasa dongaa ana manata mamanalaa. Ma tara tooa gi da marasitai gera kwailiu. Ma tara gera ka fale gera na tooa a God fuana maalimaea gera gi. ");
INSERT INTO llu_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Haia, ma ana si kada nae, tara teni profet susuge oro gi gera ka dao mai, ma tara gera ka talaia ma daka sugea tooa oro gi ma gera ka lea sulia na faatolomailaa garo gera gi. ");
INSERT INTO llu_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ma tara na aade doo garo ka oro asianaa. Ma sulia si doo naa, tara na rakedianalaa gera tooa oro gi ka makeso. ");
INSERT INTO llu_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Sui boroi ana ka urinae, so ni tei na ka tasa dongaa uria lealaa sulia God lelea ka dao isingana si kadamanga nae, nia naa tara God ka faamouri nia. ");
INSERT INTO llu_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ma si Faarongolaa Diana naa sulia Initooa a God, tara gera ka ainitalo ana lao molaagali fuana tooa gi sui. Buira naa, isingana molaagali kafi dao mai. ");
INSERT INTO llu_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","<<Gamu tara muka rikia tesi doo taꞌa asianaa uria kwaetolingilana God tara gera ka faatakea laona Beu Aabu a God. Haia, si doo na profet Daniel e bae ua na mai sulia i nao.>> (Tei na o iidumia baelaa naa gi Jesus sulia na doo naa, oko manata diana sulia malutana uria haitamalana.) ");
INSERT INTO llu_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Haia, Jesus ka bae urii lau, <<Kada muka rikia ana si doo naa gi ka dao mai, na tooa na da too i laona lolofaa nae Judea, gera ka tafi aliꞌali naa uria i tolo gi. ");
INSERT INTO llu_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ana si kada nae, lea ta wane ka too mai i maa ana luma nia, nia ka tafi aliꞌali, ma nia ka langi si manata lau uria ruulaa lau lao luma nia uria ngalilana tesi doo ana gi. ");
INSERT INTO llu_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ma ni tei na e too mai ana laona raoa, nia langi kasi ooli na lau mai luma urii tesi maku ana. ");
INSERT INTO llu_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kwaimanatailaa baita asianaa fuada bare geni na da iiana gi ma daka faasusufia gala wela bibiu gi ana si kada nae, sulia e afetai asianaa gera ka tafi aliꞌali. ");
INSERT INTO llu_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Haia, molu ka fooa ma molu ka gania God eeri langi molu si tafi ana kada ana gwagwaria ma langi maedani ana Sabat. ");
INSERT INTO llu_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Taꞌalaa naa gi na tara ka dao mai ana si kada nae, tara ka liufia na taꞌalaa gi na e sui na mai nao hafali mai ana si kada God e haungainia mai ana na molaagali lea mai ka dao i taraꞌena. Ma i buri, langi naa lau ta taꞌalaa baita urinae ka dao lau mai. ");
INSERT INTO llu_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Lea so God e langi kasi kurusia si kada ana taꞌalaa baita urinae, tara ta wane kasi mouri! Ma sulia God e dooria faamourilana tooa nia gi na e aadafilida, nia naa ka aade aagau uria na kurusilana si kada urinae. ");
INSERT INTO llu_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","24","<<Ma sui tara teni wane da haea gera naa na profet ma langi gera naa na Christ. Sui boroi ana, gera susuge asianaa. Ma tara gera aadea doo kwaibalatana baita gi fuana tooa gi gera ka kwele ana ma daka manata mamana ana sugelaa gera gi. Sui boroi ana, tooa na God e aadafilida sui naa, langi gera si manata mamana ana sugelaa gera nae gi. Haia, langi musi manata mamana ana na wane na nia bae urii, <Rikia fasi, nia naa na Christ i seegi!> ma langi, <Nia naa i seenae!> ");
INSERT INTO llu_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Nia nae, sui boroi ana si doo naa gi langi gera kasi dao gi ua mai, nau ku haea na agu fuagamu i nao eeri muka haitamana. ");
INSERT INTO llu_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","27","<<Ana si kada nau, na Wela nia Iimola gi, ku ooli mai, tara tooa gi sui gera ka riki nau. Iilingia laugo na mu haitamana rikilana sinamaaru kada e sina mai bali taelana hato lea ka dao mai bali suulana hato lao mamangaa. Haia, lea teni tooa gi gera bae urii fuagamu, <Na Christ e too lao aanogwou,> langi molu si lea uria si gula nae. Langi lea teni tooa da bae urii fuagamu, <Christ baa e aagwa i seegi,> langi molu si manata mamana ana baelaa urinae gi. ");
INSERT INTO llu_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","<<So i fai na noina wane mae gi ka too ana, si gula nae naa tara na manu baita gi da oofu ana uria anilana. ");
INSERT INTO llu_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","<<I buira si kada na taꞌalaa nae gi e sui, tara na hato ka talaꞌae rorodoa, ma na sinali ka langi si tala na mai, ma na bubulu gi na da too i laona mamangaa gera ka aasi gera. Haia, ma na doo kwekwesu gi la mamangaa tara gera ka lea garo kwailiu na ada. ");
INSERT INTO llu_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Buira si doo naa gi, na mamalafooa ana oolilagu mai kafi faatai mai lao mamangaa. Ma ana si kada nae go ana, tooa gi sui i laona molaagali, daka aangi sulia daka riki nau ku ooli mai fafona barobaro lao mamangaa ma tara nau kuka lea mai fai nia rigitaa nau fai nia na raralaa baita nau. ");
INSERT INTO llu_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ma tara na bungu ka aangi baita uria soelana na tooa nau gi na nau ku aadafilida sui naa. Ana si kada nae, tara nau kuka oodua mai ensel nau gi eeri gera ka talaia mai tooa nau gi sui ana maefera gi sui lao molaagali. ");
INSERT INTO llu_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","<<Nia diana fuana molu ka haitamana tesi faatolomailaa sulia ai na gera alangia ana figi. Kada harana ai naa nia fufurunga, muka haitamana naa si kada laona fe ngali fuana doo gi sui ka tae diana nia garangi naa. ");
INSERT INTO llu_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Haia, ana si kada nau ku garangi ooli mai ana, nia urinae laugo. Sulia kada gamu rikia si doo gi sui ana fe dani taꞌa baita baa nau ku haea sui naa fuagamu nia urinae, tara gamu ka haitamana naa si kada fuana fe dani iꞌisi nia dao garangi na mai. ");
INSERT INTO llu_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nau ku haea fuagamu, tara si doo nae gi ka dao mai kada teni wane ana uunitee wane gi ana si kada naa gera si mae ua. ");
INSERT INTO llu_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Na doo gi sui mai langi ma i laona molaagali tara gera ka sui. Haia, ma na baelagu go naa e totoo si sui. ");
INSERT INTO llu_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","<<Langi ta wane si haitamana si kada tara kuka ooli mai ana. Na ensel gi laugo dasi haitamana, ma ni nau, na Wela, boro kusi haitamana. A God na Maa ana na nia e haitamana. ");
INSERT INTO llu_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Na oolilagu tara ka iilingia si doo baa gi e fuli ana si kada baa a Noa. ");
INSERT INTO llu_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ana fe dani baa gi i nao ana na iigwaa baa, na tooa gi da fanga ma daka gwou ada gi, ma na wane gi ma na geni gi daka aade gera ada kwailiu, lea ka dao go ana fe dani baa na a Noa ka lea i laona na faka baa. ");
INSERT INTO llu_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Boroi ana, gera lalafusia ua na taa naa ka dao mai, lea ka dao ana si kada na iigwaa baa e dao mai ka lauda na ana. Ma nia tara ka dao mai laugo urii ana si kada kuka dao mai ana. ");
INSERT INTO llu_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ana si kada nae, roo wane daaro rao i laona na raoa. Ma nau ku ngalia tee wane fai nau, ma ta wane aai kuka tafusia. ");
INSERT INTO llu_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ma roo geni gi laugo daaro rao adaaro, ma tee aai kuka ngalia, ma ruana aai kuka tafusia. ");
INSERT INTO llu_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Muka aadaada diana, sulia mu lalafusia fe dani taa na nau, na Lord gamu, kuka dao mai ana. ");
INSERT INTO llu_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Muka manatatoona si doo naa gi, lea so na wane ana luma e haitamana go ana si kada na wane bebeli tara ka dao mai ana, nia ka aadaada diana ma ka langi si faalamainia na wane bebeli nae ka ruu mai lao luma nia. ");
INSERT INTO llu_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","I nia naa, muka kwaimaasi laugo, sulia tara nau ku dao mai ana si kada na langi musi haitamana ana.>> ");
INSERT INTO llu_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Haia, Jesus ka bae lau urii fuana oote fafurongo gi, <<Golu ka aada haitamana ana gwounge wane raoa utaa na nia too ana manata dianalaa eeri wane baita nia ka haitamana manata ngadolaa ani nia urinae. Kada wane baita nia e aade aagau uria lealaa, nia ka soea mai wane raoa nia, ka aalu nia eeri ka aada sulia teni wane raoa aai gi laona luma, ma na fale fangalaa fuada ana si kada diana. ");
INSERT INTO llu_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Haia, oilakea fuana wane raoa diana, si kada wane baita nia ka ooli mai ma ka riki nia tasa dongaa go ana ana aadelana raoa nia gi. ");
INSERT INTO llu_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Doo mamana nau ku haea fuagamu, tara wane baita ka eele asianaa, ma tara nia ka aalu nia fuana wane rao diana ka aadasulia si doo nia gi teefou. ");
INSERT INTO llu_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","<<Haia, lea nia wane rao taꞌa, tara buira wane baita nia e lea, tara nia ka manata urii, <Tara na wane baita nau afetai ka ooli aliꞌali mai.> ");
INSERT INTO llu_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ma sulia nia manata urinae, tara nia ka hau oꞌonilaa ana wane raoa baa gi na wane baita nia aalu nia uria aadalaa sulida. Ma tara nia ka fanga ma ka gwou fai nia tooa na gera gwou lilinge oro sulia dani. ");
INSERT INTO llu_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Haia, ma tara nia tona boro ana tee fe dani ma na kade hato loko na wane raoa na langi kasi aade aagau go ana maasia, na wane baita nia ka dao na mai. ");
INSERT INTO llu_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ma tara na wane baita nia ka kwae nia baita asianaa, ma ka aalu nia fai nia tooa na da taꞌa gi. Ma si kada nia ka too ana si gula nae, nia ka aangi dongaa go ana fai nia na girigiri lifolaa.>> ");
INSERT INTO llu_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ma a Jesus e bae laugo urii, <<Ana si kada na ku ooli lau mai ana, tara na Initooa i Langi ka iilingia na aakwala haari da ngalia na laeta ni kwesulaa gera gi, ma daka lea uria kwaitodailaa fai nia fungao. ");
INSERT INTO llu_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ma ta lima haari ada da ooewanea, ma ta lima aai ada da liotoo. ");
INSERT INTO llu_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Na haari ooewanea nae gi da ngalia na laeta gera gi ni kwesulaa, sui langi dasi ngalia go tesi gwai ka bobola fuana faaharulaa fai gera. ");
INSERT INTO llu_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ma na aai liotoo naa gi da ngalia na gwai baita uria faaharulaa fai nia na laeta gera gi ni kwesulaa. ");
INSERT INTO llu_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ma na fungao nae e langi kasi dao aliꞌali, ma na haari nae gi na maada ka teteolaa teefou ma daka teo na ada. ");
INSERT INTO llu_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","<<Ma i initoona na rodo, na tooa gi da rii daka urii, <Na fungao baa e dao na mai! Molu lea, ma molu ka kwaitodai fai nia.> ");
INSERT INTO llu_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Na aakwala haari nae gi da tatae, ma daka faaharua na laeta gera gi ni kwesulaa. ");
INSERT INTO llu_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ma na haari ooewanea nae gi daka bae urii fuada na haari liotoo gi, <Molu falea tesi gwai ni harulaa amelu, sulia na gwai gemelu gi ni harulaa e garangi sui naa.> ");
INSERT INTO llu_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","<<Sui gera oolisida daka urii, <E langi, sulia nia e langi si bobola naa fai golu sui. Molu lea amolu fuana ta beu ni folia uria folilana tesi gwai ni harulaa amolu.> ");
INSERT INTO llu_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ma si kada gera lea ada ana uria na folilaa, na fungao nae ka dao mai. Ma na haari nae gi na da aade aagau daka lea na ada fai nia uria na fangaa ana na baraa. Ma sui na maa ka balika naa. ");
INSERT INTO llu_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","<<Ma i buira na haari aai baa gi daka dao laugo mai, daka urii, <Aarai ae! O ifingia kou na maa uri gemelu! ");
INSERT INTO llu_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ma na fungao nae e oolisida ka urii, <Doo mamana nau ku haea fuagamu, i nau ku lalafusi gomolu.>>> ");
INSERT INTO llu_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ma a Jesus ka faasuia na oomelawanea naa ka urii, <<Nia naa, molu ka aadaada diana, sulia molu lalafusia fe dani langi si kada tara kuka dao lau mai ana.>> ");
INSERT INTO llu_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Sui a Jesus ka haea lau si oomelawanea naa fuana na oote fafurongo nia gi ka urii, <<Ana si kada tara ku ooli mai ana, na Initooa i Langi e iilingia tee wane baa e lea ana tee lealaa, ma ka soea na wane ni rao nia gi, ma ka aalua na doo nia gi i abada. ");
INSERT INTO llu_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ma nia ka falea lima si malefo fuana tee wane. Ma fuana ta wane aai, nia ka falea roo si malefo. Ma fuana ta wane aai, nia ka falea tee si malefo. Nia e falea ka bobola naa fai nia na haitamadoolaa gera gi. Sui nia ka lea na ana ana lealaa nia. ");
INSERT INTO llu_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ma na wane nae na e ngalia na lima si malefo, nia ka raoa ana, ma ka todadoo ta lima si malefo lau. ");
INSERT INTO llu_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ma na wane baa e ngalia na roo si malefo, nia ka raoa laugo ana, ma ka toda ta roo si malefo lau. ");
INSERT INTO llu_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Haia, ma na wane baa na e ngalia tee si malefo, nia ka lea, ma ka elia tee kilu i laona na hae gano, ma ka haufinia ana si malefo baa na aarai baita nia e falea fuana. ");
INSERT INTO llu_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","<<Ma i buira si kada e tau, na aarai baita gera baa ka ooli mai, ma ka inifainia na malefo baa gi fai gera. ");
INSERT INTO llu_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ma na wane baa na e ngalia lima si malefo, e ngalia lau mai ta lima si malefo lau, ma ka bae urii, <Aarai baita ae, i oe o aalua lima si malefo i abagu. O rikia fasi, nau ku toda ta lima si malefo lau.> ");
INSERT INTO llu_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","<<Ma na aarai baita nia e oolisia ka urii, <Oe wane ni rao diana nau. Nau ku haitamana kuka manata ngado ani oe! I oe o rao diana ana si doo toꞌou gi, nia naa i nau kuka aalu oe oko baita usia na doo oro gi. O lea mai, ma oko eele amu fai nau.> ");
INSERT INTO llu_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","<<Ma na wane baa na e ngalia roo si malefo ka dao laugo mai. Ma ka bae urii, <Aarai baita ae, i oe o aalua go roo si malefo i abagu. O rikia fasi, i nau ku toda lau ta roo si malefo lau.> ");
INSERT INTO llu_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","<<Ma na aarai baita nia e oolisia ka urii, <Oe wane ni rao diana nau, nau ku haitamana manata ngado ani oe! I oe o rao diana ana si doo toꞌou gi. Nia naa tara nau kuka aalu oe oko baita usia na doo oro gi. O lea mai, ma oko eele amu fai nau.> ");
INSERT INTO llu_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","<<Sui na wane baa na e ngalia tee si malefo, ka dao mai. Ma i nia ka bae urii, <Aarai baita ae, i nau ku haitamana ni oe na wane na baelamu e rigita. Oko gonia na doo gi go amu ana na gula gi na e langi osi fasia, ma oko ngalia go amu si doo gera tooa eꞌete gi. ");
INSERT INTO llu_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nia naa ku mou, ma ku lea ma ku haufinia na malefo baa oe baa i laona na hae gano. O aada fasi si malefo oe baa ta naa.> ");
INSERT INTO llu_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","<<Ma na aarai baita nia e oolisia ka urii, <I oe na wane ni rao taꞌa ma oko noni eela. O manata go amu na ku goni doo ana si gula na e langi kusi fasia, ma ku ngalia go agu si doo gera tooa eꞌete gi. ");
INSERT INTO llu_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Lea oe manata urinae, oe so oko aalua amu na malefo nau i laona si gula ni aalulana malefo hai ka oro, hai so si kada ku ooli mai ana, i nau kuka ngalia na malefo nae ma na malefo sarenga fai nia gi.> ");
INSERT INTO llu_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","<<Sui na aarai baita nae ka bae urii fuana na wane ni rao nia gi lau, <Molu ngalia na malefo naa faasi nia, ma molu ka falea fuana na wane na e too ana tee aakwala malefo. ");
INSERT INTO llu_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Sulia na tooa gi sui na da too ana tesi doo gi, tara nau kuka falea lau teni si doo lau fuada, eeri daka too ana doo oro gi. Ma so ni tei na e langi kasi too ana tesi doo, boroi ana nia ka too ana tesi doo toꞌou, tara nau kuka lafua faasi nia. ");
INSERT INTO llu_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ma na wane ni raoa nae, molu ui ania i maa laona na rorodoa, si gula ana aangilaa ma na girigiri lifoa.>>> ");
INSERT INTO llu_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","A Jesus ka bae lau urii fuada na oote fafurongo nia gi, <<Si kada nau, na Wela nia Iimola gi, tara ku ooli lau mai uria na aaofialaa fai nia na ensel gi, tara kuka gwouru ana si gula ni gwogwourua na Aaofia. ");
INSERT INTO llu_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ma na tooa gi sui faasia na fera gi sui tara daka oofu mai i naogu. Ma tara nau kuka inifitaa na tooa gi sui, iilingia ta wane baa e aadasulia na sipsip gi e inifitaa na sipsip gi faasia na nanigot gi. ");
INSERT INTO llu_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ma nau kuka aalua na tooa oꞌolo gi i bali aaolo ani nau ma na tooa taꞌa gi i bali mouli ani nau. ");
INSERT INTO llu_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","<<Sui nau kuka bae urii fuada ni tei gera na da too i bali aaolo nau, <Gomolu naa na tooa na Maa nau e faadianaa gi. Molu ruu mai i laona Initooa i Langi na e aade aagau ana fuagamu ita ua na mai ana na hafalilana na molaagali ua mai. ");
INSERT INTO llu_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Sulia si kada ku fiolo ana, muka falea si fanga fuagu. Ma si kada ku maeligwou ana, muka falea si kafo fuagu. Ma boroi ana nau na wane dao faasia ta fera eꞌete, muka soe nau fui lao luma gamu gi. ");
INSERT INTO llu_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ma si kada e langi agu tesi maku, muka fale maku fuagu. Ma si kada ku matai, muka aadasuli nau. Ma si kada ku too i laona na beu ni kanilaa, muka maatoogu.> ");
INSERT INTO llu_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","<<Sui na tooa oꞌolo gi daka oolisia ka urii, <Lord ae, si kada taa na melu riki oe o fiolo ma melu ka hangoni oe, langi si kada taa na o maeligwou ma melu ka falea si kafo fuamu? ");
INSERT INTO llu_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ma si kada taa na ni oe na wane dao faasia na fera eꞌete ma melu ka soe oe i luma, langi si kada taa na e langi amu tesi maku ma melu ka fale maku fuamu? ");
INSERT INTO llu_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ma si kada taa na melu rikia na o matai ana, langi o too ana i laona na beu ni kanilaa ma melu ka lea uria na maatoolamu?> ");
INSERT INTO llu_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","<<Ma tara nau kuka oolisida kuka urii, <Doo mamana nau ku haea fuagamu, si kada molu iilia tesi doo urinae fuana ta wane toꞌou ana haasigu naa gi, molu iilia naa fuagu.> ");
INSERT INTO llu_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","<<Sui tara nau kuka bae urii fuada na tooa na da too i bali mouli ani nau, <Molu ka lea tau kou faasi nau. A God tara ka kwae gamu. Ma molu ka lea laona na eere na e totoo firi, na a God e aade aagau ana fuana a Satan ma na ensel taꞌa nia gi. ");
INSERT INTO llu_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Sulia i nau ku fiolo, ma molu si falea go tesi fanga agu. Ma si kada ku maeligwou, molu si falea go tesi kafo fuagu. ");
INSERT INTO llu_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ma si kada nau ku dao mai, molu si soe nau go fuana luma gamu gi. Ma si kada e langi agu tesi maku, langi molu si fale maku go fuagu. Ma si kada ku matai ma ku too i laona na beu ni kanilaa, langi molu si aada go suli nau.> ");
INSERT INTO llu_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","<<Ma i gera laugo daka oolisia daka urii, <Lord ae, si kada taa na melu riki oe o fiolo, langi o maeligwou, langi oe na wane dao, langi ka langi amu tesi maku, langi o matai langi o too i laona na beu ni kanilaa, ma langi melu si adomi oe go?> ");
INSERT INTO llu_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","<<Ma tara nau kuka oolisida urii, <Doo mamana nau ku haea fuagamu, si kada gamu oote gamu kwaiꞌadomilaa fuana na tooa toꞌou naa gi, molu si adomi nau laugo.>>> ");
INSERT INTO llu_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","<<Sui gera ka lea na ada uria na kwaelaa na e totoo firi, ma na tooa oꞌolo gi gera ka lea uria na mouria firi.>> ");
INSERT INTO llu_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Si kada Jesus e faatolomainia ana afutana si doo naa gi sui, nia ka bae urii fuana oote fafurongo nia gi, ");
INSERT INTO llu_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","<<Gomolu haitamana sui naa, na roo fe ubongia suifetei fe dani fangaa gia baa hatana Lofoagaua. Ma ana si kada nae naa, tara gera ka fale nau ana, nau na Wela nia Iimola gi, fuana maalimaea nau gi, eeri gera ka fotoi nau ana i fafona airarafolo.>> ");
INSERT INTO llu_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ma na fataabu baita gi ma na tooa baita gera Jiu gi, gera ka oogu laona luma baita nia na fooanigwou na hatana a Kaeafas. ");
INSERT INTO llu_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ma gera ka faarai oofu, eeri gera ka daotoona tesi kada ana fuana gera ka dumulia a Jesus ma daka haungia ana aagwalaa go ana. ");
INSERT INTO llu_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ma gera ka bae kwailiu urii, <<Langi golu si dumulia ana fe dani ana fafangaa, aata tooa gi gera ka firu fai golu.>> ");
INSERT INTO llu_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ma Jesus fai nia na oote fafurongo nia gi, gera lea kou fuana i Betani, gera ka too i laona luma a Simon, na wane baa na fura e haungia i nao. ");
INSERT INTO llu_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ana si kada Jesus e fanga ana, tee geni e lea mai siana, fai nia tee bii diana na e fungu ana gwai ni gwailaa na folilana e baita. Nia lea mai, ma ka igitainia i fafona ketena Jesus. ");
INSERT INTO llu_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ma ana si kada na fafurongo nia gi da rikia, rakeda ka hasu, ma gera ka bae ada i talada urii, <<Utaa naa geni naa ka labasia gwai diana naa? ");
INSERT INTO llu_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Gwai naa, lea so golu ka faafoli ana, tara si malefo baita na tara golu ka ngalia ana. Haia, si malefo nae golu ka ngalia uria adomilana tooa siofaa!>> ");
INSERT INTO llu_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ma sulia Jesus e haitamana go ana taa na gera bae sulia, nia ka bae urii fuada, <<Uria taa na molu ka bae urinae ma molu ka faaꞌida geni naa? Si doo diana asianaa na nia aadea fuagu naa. ");
INSERT INTO llu_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Sulia na tooa siofaa gi gera too fai gamu sulia dani go ana. Haia, ma ni nau si kada kukuru go ana na ku too ana fai gamu. ");
INSERT INTO llu_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Haia, ma na geni naa, ana si kada nia igitainia ana gwai naa faafia na nonigu, nia e aade aagau ani nau maasia aalulagulaa i laona kwaingeia ana fe dani maelagu. ");
INSERT INTO llu_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Haia, ma ni nau ku haea fuagamu, ana fera gi sui lao molaagali na tara na Faarongolaa Diana gera ainitalongainia ana, tara si taa na geni naa e aadea fuagu gera ka rongoa naa laugo uria na manatatoolana ana.>> ");
INSERT INTO llu_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Buira si doo naa gi sui, tee wane ana aakwala ma roo wane fafurongo a Jesus hatana a Judas Iskariot e lea siada na fataabu baita gi. ");
INSERT INTO llu_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ma e soeledi gera ka urii, <<Lea ni nau ku falea a Jesus fuamolu, taa naa tara molu ka falea fuagu?>> Ma gera ka iidumia oolu aakwala si malefo ma gera ka falea fuana. ");
INSERT INTO llu_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Talaꞌae ana si kada nae, Judas ka aadaada naa uria si kada eeri ka bobola fuana ka falea a Jesus fuada. ");
INSERT INTO llu_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Haia, ana eetana maedani ana Fangaa ana Lofoagaua gera Jiu gi, gera haitamana gera ania ana beredi na e langi ta iisi i laona. Ma na oote fafurongo gi da lea mai siana Jesus. Ma gera ka ledia urii, <<Oe dooria i fai na tara melu ka aade aagaua na fanga ana Fangaa ana Lofoagaua fuamu?>> ");
INSERT INTO llu_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ma a Jesus ka bae urii fuada, <<Molu lea fuana Jerusalem. Ana si kada molu dao siana wane na nau ku bae sulia, molu ka bae urii fuana, <Faatolomai gemelu e haea si kada nia e dao garangi naa. Haia, nia bae lau go mai urii, Gemelu na oote fafurongo nau gi tara melu ka aadea na Fangaa naa ana Lofoagaua i luma oe.>>> ");
INSERT INTO llu_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Haia, kada na fafurongo gi da lea, ma gera ka faarai fai nia na wane naa iilingia a Jesus e haea fuada, gera ka aade aagau na ana fafangaa nae. ");
INSERT INTO llu_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ma i haulafia, Jesus e gwouru i seenae uria fangalaa fai nia na oote fafurongo nia gi na aakwala ma roo wane. ");
INSERT INTO llu_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ma si kada gera fanga ana, Jesus ka bae urii fuada, <<Doo mamana nau haea fuagamu, tara ta wane ani gamu ka fale nau fuana maalimaea nau gi.>> ");
INSERT INTO llu_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Kada oote fafurongo gi gera rongoa si doo naa, gera ka liobukonu asianaa. Haia, tee wane ani gera kafi talaꞌae soeledia Jesus ka urii, <<Lord ae, oe haitamana si doo uri nau afetai kuka iilia ani oe, ne baa?>> Haia, daalu sui go naa daalu bae urinae. ");
INSERT INTO llu_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Haia, Jesus ka urii, <<Tee wane amolu, na wane nae ka fanga oofu fai nau, nia naa tara ka fale nau fuana maalimaea nau gi. ");
INSERT INTO llu_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Nau, na Wela nia Iimola gi, tara nau kuka mae iilingia na Kekedelaa Aabu e haea sui na mai nao. Ma kwaimanatai asianaa fuana na wane na tara ka fale nau fuana maalimaea nau gi. Nia e diana fuana wane naa so langi kasi futa ua go mai.>> ");
INSERT INTO llu_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ana si kada nae, Judas baa, na wane na tara ka falea Jesus fuana maalimaea nia gi, nia ka bae urii, <<Oe haitamana na si doo uri nau afetai kuka iilia ani oe, ne baa?>> Ma a Jesus ka bae urii fuana, <<Oe i talamu ana na o haea nae.>> ");
INSERT INTO llu_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ma ana si kada gera fanga ana, a Jesus e ngalia fe beredi, ma nia ka baelafea a God, sui ka niia, ma ka falea fuana na oote fafurongo nia gi, ma ka bae urii, <<Molu ngalia, molu ka ania, i nia naa na nonigu.>> ");
INSERT INTO llu_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Sui nia ka ngalia na teteu ni gwoulaa, ma ka baelafea a God, sui ka falea fuada, ma ka bae urii, <<Gomolu gwoufia, i gomolu sui go. ");
INSERT INTO llu_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Nia naa na abugu na a God e kani faafia na gwalulaa faalu ana, sulia na abugu tara ka iigwa fuana tooa oro gi, eeri a God ka manata lukea na aade taꞌalaa gi. ");
INSERT INTO llu_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Doo mamana nau ku haea fuamolu, i nau kusi gwoufia lau na waen naa lea ka dao ana fe dani kuka gwoufia na waen faalu fai gomolu i laona na Initooa a Maa nau.>> ");
INSERT INTO llu_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Sui gera nguulia fe nguu, sui daka lea uria fe uuo na da alangia ana Olivtri. ");
INSERT INTO llu_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ma a Jesus ka bae urii fuada, <<Ana fe rodo naa, tara gomolu sui go tara molu ka tafusi nau ma molu ka tafi faasi nau. Sulia na Kekedelaa Aabu baa e haea urii, <Tara a God ka haumaelia na wane na e aadasulia na sipsip gi, ma na sipsip gi sui tara daka tagala.> ");
INSERT INTO llu_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Sui i buira tara nau kuka tatae lau uria mouria, nau kuka eeta i nao ani gomolu uria i Galili.>> ");
INSERT INTO llu_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ma a Peter e oolisia ka urii, <<Nau afetai kuka lea faasi oe, boroi ana tooa naa gi daka lea faasi oe!>> ");
INSERT INTO llu_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ma a Jesus ka bae urii fuana a Peter, <<Nau ku haea fuamu, i nao ana na kakaraikua ka ai i laona fe rodo naa i taraꞌena, ni oe tara oko haea ana oolu si kada na o lalafusi nau.>> ");
INSERT INTO llu_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ma a Peter e oolisia ka urii, <<Sui boroi ana kuka mae fai oe, e afetai kuka haea hasa ku lalafusi oe!>> Ma na oote fafurongo aai gi sui go, gera bae laugo urinae doo. ");
INSERT INTO llu_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Sui a Jesus e lea fai gera oote fafurongo nia gi ana tesi gula da alangia ana Getsemani, ma nia ka bae urii fuada, <<Molu gwouru amolu i seegi ana si kada nau ku lea kou i see loko uria na fooalaa.>> ");
INSERT INTO llu_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ma nia ka talaia a Peter ma na roo wela a Sebedi gi fai nia, ma ka hafalia na liobukonulaa ka tasa. ");
INSERT INTO llu_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ma nia ka bae urii fuada, <<Na liogu e bukonu asianaa, ma ka bobola naa fai nia na maelagu. Muka too i seenaa, ma muka aada fai nau.>> ");
INSERT INTO llu_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Sui nia ka idu toꞌou lau faasi daalu, ma ka boururu lea na maadarana ka totoona na hae gano, ma ka fooa ka urii, <<Maa ae, lea so ka waluda go ana, oko lafua amu na nonifiilaa naa faasi nau. Sui boroi ana, e langi lau na kwaidooria nau, sulia na kwaidooria oe go ana taari.>> ");
INSERT INTO llu_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Sui a Jesus ka ooli i siana na oolu fafurongo nia gi, ma ka riki daalu teo naa, ma ka bae urii fuana a Peter, <<Peter ae, e utaa na molu si aada mone amolu fai nau sulia ta tee si kadamanga? ");
INSERT INTO llu_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Molu aada, ma molu ka fooa, aata molu ka liu i laona taꞌalaa. Sulia gomolu dooria iilia na doo diana, sui taa na nonidoo gomolu na e makeso.>> ");
INSERT INTO llu_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jesus ka lea lau, ma ka fooa ana ruana si kada ka urii, <<Maa ae, lea langi bobola uria suusilaa na nonifiilaa naa faasi nau, diana go ana, nau ku roo na mone sulia na kwaidooria oe.>> ");
INSERT INTO llu_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ma si kadamanga e ooli mai siadaalu na oote fafurongo nia gi, nia e rikia daalu teo lau, sulia na maada e teteolaa asianaa. ");
INSERT INTO llu_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ma Jesus e lea lau faasida, ma ka fooa lau ana ooluna si kadamanga, ka haea laugo na baea baa gi i nao. ");
INSERT INTO llu_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Sui i nia ka lea lau siadaalu na oolu fafurongo nia gi, ma ka bae urii fuadaalu, <<Gomolu teo ua? Ma molu ka mamalo ua? Molu aada fasi, e garangia naa si kada hai daka fale nau, na Wela nia Iimola gi laona abada na tooa da aade taꞌa gi. ");
INSERT INTO llu_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Molu tatae, golu lea naa. Molu rikia na wane baa ka fale nau nia e dao na mai.>> ");
INSERT INTO llu_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ma ana si kada a Jesus e bae ua, a Judas, tee wane ana aakwala ma roo fafurongo nia baa gi, e dao na mai. Ma na wane oro gi da lea mai fai nia, ma gera dau mai ana naefe gi ma na subi gi. Ma na fataabu baita gi ma na wane baita ana tooa, na da oodu gera mai. ");
INSERT INTO llu_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ma Judas e falea sui naa si mamalafooa fuada ka urii, <<Na wane na tara ku nonoia, nia naa na wane molu dumulia.>> ");
INSERT INTO llu_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ma aliꞌali nia e lea olosia naa siana a Jesus ma ka bae urii, <<Wane faatolomai ae, si aaroaro ka too fai oe.>> Sui ka nonoia. ");
INSERT INTO llu_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ma a Jesus ka bae urii fuana, <<Ruana ae, oko iilia doo nae aliꞌali.>> Sui gera idu garangia mai, ma da dumulia a Jesus, ma daka dau ngasi naa faafi nia. ");
INSERT INTO llu_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ma tee wane ana fafurongo a Jesus gi ka lafua na naefe nia, ma ka kwaea na wane rao nia na fooanigwou, ma ka taba muusia naa na bali ana aalingana. ");
INSERT INTO llu_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ma a Jesus ka bae urii fuana, <<O aalua amu naefe oe i fuilaa, sulia ni tei gera na da firu ana naefe, tara daka mae laugo ana naefe. ");
INSERT INTO llu_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Osi haitamana go lea so ku soea na Maa nau, nia kafi oodua mai na ensel oro gi liufia aakwala ma roo oomea? ");
INSERT INTO llu_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Lea so ka urinae, tara ka langi gera si faamamanaa na Kekedelaa Aabu baa na e haea doo nae gi tara ka fuli ani nau.>> ");
INSERT INTO llu_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Sui a Jesus ka bae urii fuana tooa, <<Utaa na molu lea mai fai nia na naefe gi ma na subi gi uria na dumulilagu iilingia nau naa na wane hauwane? Sulia dani nau ku gwouru go agu i Beu Aabu a God, ma kuka faatolomai doo, sui musi dumuli nau. ");
INSERT INTO llu_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Na doo naa gi teefou e fuli urinae hai ka faamamanaa na kekedelaa gera na profet gi ana Kekedelaa Aabu.>> Sui na oote fafurongo nia gi sui go da eekwatainia, ma daka tafi na ada. ");
INSERT INTO llu_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ma na tooa na gera dumulia a Jesus, gera ka talai nia fui lao luma a Kaeafas, na fooanigwou. Ma na wane faatolomai ana kwaieresia gi fai nia na oote wane baita gi laugo, gera figu i seenae. ");
INSERT INTO llu_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ma a Peter e lea sulida ma e lea tau laugo ana, ma ka dao laugo i laona na lalabata ana na luma nia fooanigwou, ma ka ruu kou i laona labata, ma ka gwouru siana tooa da folo, eeri nia ka rikia taa naa daka iilia ana a Jesus. ");
INSERT INTO llu_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ma na fataabu baita gi fai nia na figua ana wane baita gi sui go daka manata uria teni si baea ni susuge gi sulia a Jesus, na e bobola fai nia ka faamaelia. ");
INSERT INTO llu_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Sui ka langi dasi daotoona tesi doo. Ma na wane oro boroi da bae susuge gi da lea laugo mai. Sui i buri, tee roo wane susuge daaro tae mai, daaro ka bae urii, ");
INSERT INTO llu_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","<<Na wane naa nia e bae urii, <I nau ku haitamana na oogosilana na Beu Aabu a God, ma kuka tolea faalu laugo agu ana i laona oolu fe dani.>>> ");
INSERT INTO llu_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Sui na fooanigwou e tatae ka bae urii fuana a Jesus, <<Utaa, langi osi oolisia go tesi doo, ana doo taꞌalaa naa daaro haea sulia na taꞌalaa oe gi?>> ");
INSERT INTO llu_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Sui, a Jesus ka bona go ana. Ma na fooanigwou ka bae lau urii, <<I nau ku ledi oe ana hatana a God momouria, hai oko haea fuagami hasa i oe a Christ na Wela nia a God, ma e langi?>> ");
INSERT INTO llu_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","A Jesus ka bae urii fuana, <<Nia naa nae o haea nae. Haia, doo mamana nau ku haea fuagamu, ita ana si kada naa ka ooli alaa, muka riki nau, na Wela nia Iimola gi, kuka gwouru i bali aaolo ana a God na e rigita ka tasa, ma kuka lea mai i fafona barobaro gi i langi.>> ");
INSERT INTO llu_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Sui na fooanigwou e karia na maku nia, sulia nia rakehasu asianaa, ma ka urii, <<Nia e bae tataga ana a God. Si taa na golu ka nani lau uria? Golu rongoa sui naa si bae tatagalaa na nia e iilia. ");
INSERT INTO llu_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Muka manata utaa?>> Ma gera oolisia daka urii, <<Nia e iili taꞌa na e bobola fuana nia ka mae.>> ");
INSERT INTO llu_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Sui da ngisufia maana, ma daka kwaea. Ma teni wane da fidalia, daka urii, ");
INSERT INTO llu_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","<<Christ ae, lea oe naa ta profet, oko haea mai, ni tei naa e fidali oe nae?>> ");
INSERT INTO llu_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ma a Peter e gwouru i maa i laona lalabata, ma tee haari ni rao e lea mai siana ka bae urii, <<I oe laugo o too fai nia a Jesus, na wane naa faasia i Galili.>> ");
INSERT INTO llu_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Sui a Peter ka tofe i maada ka urii, <<I nau kusi haitamana si doo naa o haea.>> ");
INSERT INTO llu_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Sui, nia ka haga kou i maa. Ma tee haari rao aai laugo e rikia, ma ka bae urii fuana tooa nae gi gera too seenae, <<Na wane naa laugo e too fai nia a Jesus na wane naa faasia i Nasaret.>> ");
INSERT INTO llu_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ma a Peter ka tofe lau, ka urii, <<Nau ku aalafuu mamana e langi kusi haitamana na wane naa.>> ");
INSERT INTO llu_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ma e langi si tau go i buira, na wane gi da take i seenae da lea siana a Peter, ma daka bae urii fuana, <<I oe laugo tee wane ani gera mamana naa naa, sulia na lingeena baelamu naa e faatai oe.>> ");
INSERT INTO llu_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Si kada nae nia ka aalafuu lau ka urii, <<Lea nau ku suge, tara a God ka kwae nau. I nau langi kusi haitamana na wane naa.>> Ma aliꞌali na kakaraikua ka ai. ");
INSERT INTO llu_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ma a Peter ka manatatoona si baea baa a Jesus e haea, <<I nao ana na kakaraikua ka ai i laona fe rodo naa i taraꞌena, ni oe oko haea ana oolu si kada na o lalafusi nau.>> Si kada a Peter e manatatoona si doo nae, nia ka haga kou i maa, ma ka aangi lea ka igiꞌigilaa go. ");
INSERT INTO llu_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kada e ofaidani naa, na fataabu baita gi sui fai gera na wane baita gi, daka faarai naa sulia a Jesus uria daka hau utaa ana. ");
INSERT INTO llu_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Sui gera kania, ma daka talaia siana na a Paelat, na wane initoo faasia i Rom. ");
INSERT INTO llu_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Haia, a Judas, na wane baa e falea Jesus fuana maalimaea nia gi, ana si kada nia e haitamana gera ketoa naa a Jesus fuana na maelana, i nia ka oolitai manata, ma ka oolifainia na oolu aakwala si malefo baa gi fuagera na fataabu baita gi ma na wane baita gi, ma ka bae urii, ");
INSERT INTO llu_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","<<I nau ku fualangaa naa, sulia ku falea na wane oꞌolo uria na maelana.>> Sui gera oolisia daka urii, <<E urinae tara ka utaa fuagami? Sulia bali nae, na bali oe ana nae.>> ");
INSERT INTO llu_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ma a Judas ka ui ania na malefo nae gi i laona na Beu Aabu nia a God, ma ka lea na ana. Nia e lea kou i maa, ma ka lio na ana i talana. ");
INSERT INTO llu_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ma na fataabu baita gi, daka ngalia na malefo nae, ma daka bae urii, <<E langi si bobola golu ka aalua na malefo naa fai nia na malefo ana na Beu Aabu nia a God, sulia si malefo naa na malefo ana hauwanelaa naa.>> ");
INSERT INTO llu_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ma gera ka faarai sui, gera ka folia ana tesi gano, na gano tee wane e haungai teu. Ma gera ka oolisia gano na uria bae uria aalulana wane mae gi ana tooa na langi gera kasi Jiu i laona. ");
INSERT INTO llu_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","I aena naa, gera ka alangia ana si gano naa ana si gano ana abu lelea ka dao i taraꞌena. ");
INSERT INTO llu_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Urinae, gera ka faamamanaa si baea na profet Jeremaea e haea ka urii, <<Gera ngalia na oolu aakwala malefo baa, na malefo baa na tooa gi i Israel da folia ana na wane, ");
INSERT INTO llu_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ma daka falea uria folilana na gano nia na wane e haungainia teu gi, iilingia na Lord e haea fuagu.>> ");
INSERT INTO llu_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ma a Jesus ka take i naona a Paelat, na wane initoo faasia i Rom. Ma a Paelat ka ledia ka urii, <<I oe na Aaofia gera Jiu gi?>> A Jesus e oolisia ka urii, <<Nia naa nae o haea nae.>> ");
INSERT INTO llu_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Si kada na fataabu baita gi ma na wane baita gi gera feengia a Jesus, nia e langi si oolisida ana tee si baea. ");
INSERT INTO llu_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Sui a Paelat ka bae urii fuana, <<Osi rongo go na doo taꞌa oro naa gi gera hae oe ana?>> ");
INSERT INTO llu_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Sui, a Jesus langi kasi oolisida go ana tesi baea. Nia naa a Paelat ka kwele asianaa ana. ");
INSERT INTO llu_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Si kada nae, si kada fangaa gera Jiu gi da alangia ana <<Lofoagaua>>. Ma wane initoo faasia i Rom e haitamana ka lukea kou ta wane faasia na beu ni kanilaa, ni tei naa gera Jiu gi da dooria. ");
INSERT INTO llu_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ma ana si kada nae, tee wane e too laugo laona beu ni kanilaa na hatana a Barabas, na tooa gi sui da haitamana. ");
INSERT INTO llu_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Nia naa, si kada na tooa gi gera figu mai, Paelat ka ledida ka urii, <<Ni tei naa mu dooria hai ku lukea fuagamu, a Barabas ma langi a Jesus na da alangia ana a Christ?>> ");
INSERT INTO llu_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Nia e bae urinae, sulia nia e haitamana na wane baita gi ana Jiu gi gera falea a Jesus fuana sulia gera kwaifii ana. ");
INSERT INTO llu_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ma si kada Paelat e gwouru ana si gula ni keketoa, na afe nia ka falea tesi baea fuana ka urii, <<Langi osi aadea tesi doo ana na wane oꞌolo naa. Sulia i nau ku teo bole ma ku nonifii asianaa suli nia i laona fe rodo naa.>> ");
INSERT INTO llu_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ma na fataabu baita gi ma na wane baita gi gera bae aalingana na tooa, eeri daka gania a Paelat uria ka lukea a Barabas, ma ka aalua a Jesus uria maea. ");
INSERT INTO llu_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ma a Paelat ka soeledida na figua lau ka urii, <<Ni tei ani daaro na gamu dooria hai kuka lugasia?>> Ma gera oolisia daka urii, <<A Barabas.>> ");
INSERT INTO llu_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","A Paelat ka bae urii, <<Ma si taa naa tara kuka iilia ana a Jesus, na da alangia ana a Christ?>> I gera sui daka bae urii, <<O fotoia i fafona airarafolo.>> ");
INSERT INTO llu_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ma a Paelat ka bae urii lau, <<Uria taa? Tesi taa taꞌa na nia e iilia?>> Sui gera rii baita daka urii, <<Fotoia i fafona airarafolo.>> ");
INSERT INTO llu_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ma si kada a Paelat e rikia e afetai ka iilia naa tee si doo, ma na firua ka garangi hafali, nia ka ngalia si kafo ma ka saufia na abana i nao ada na tooa, ka bae urii, <<I nau e langi kusi dooria na maelana na wane naa. Bali nae, na bali gomolu naa nae.>> ");
INSERT INTO llu_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Na figua teefou gera oolisia, daka urii, <<Na maelana ka too faafi gami ma faafia na wela gami gi.>> ");
INSERT INTO llu_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Haia, a Paelat e faahaga kou a Barabas fuada, ma ka oodua na wane oomea nia gi daka rabusia a Jesus. Sui nia ka falea uria na fotoilana i fafona na airarafolo. ");
INSERT INTO llu_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ma na wane ni oomea nia Paelat gi, gera talaia a Jesus i laona na beu nia Paelat, ma na oomea nae teefou gera ka figua mai galia Jesus. ");
INSERT INTO llu_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ma gera ka lafua na maku nia, ma daka faaruufia ana si maku kekeroa. ");
INSERT INTO llu_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Sui gera ka ngalia na eregwou ana kwaletotore ma gera ka aalua fafona ketena, ma gera ka falea tee hage ai eeri ka dau ana i bali aba aaolo nia iilingia nia naa aaofia. Ma gera boururu fuana ma daka onionga ana, daka urii, <<Mouri ka tau, aaofia gera na Jiu gi.>> ");
INSERT INTO llu_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ma gera ka ngisufia, ma daka ngalia na hage ai baa, ma gera ka kwaea na ketena. ");
INSERT INTO llu_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Si kadamanga gera onionga ana e sui, gera ka lafua lau na maku baa, ma daka faaruufia lau ana maku nia gi, sui daka talaia kou uria na fotoilana i fafona na airarafolo. ");
INSERT INTO llu_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ma si kada gera lea ana, daka rikia tee wane faasia i Saeren, na hatana a Simon. Ma na wane ni oomea gi daka oodua hai ka koua na airarafolo fuana a Jesus. ");
INSERT INTO llu_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Sui gera dao ana si gula da alangia ana i Golgota. (Na malutana baea Golgota <<Na Lelete>>.) ");
INSERT INTO llu_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","I seenae, da falea na waen na da dolalia ana ai afae fuana a Jesus. Ma a Jesus ka gwoutoona, sui ma ka langi kasi gwoufia go. ");
INSERT INTO llu_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Sui gera ka fotoia i fafona na airarafolo, ma da tolingia na maku nia gi, da lalaba ana daisi uria. ");
INSERT INTO llu_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Sui gera gwouru ma daka aadaada go ada ");
INSERT INTO llu_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ma i ootofana na ketena gera aalua na kedelaa ka urii, <<Na wane naa a Jesus, na aaofia gera na Jiu gi.>> ");
INSERT INTO llu_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Sui, gera fotoia laugo roo wane bebeli gi ana na airarafolo gi fai nia, ta wane i bali aaolo ana, ma ta wane ana bali mouli. ");
INSERT INTO llu_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ma na tooa gi na da liu, gera ka kwaelangainia gwouda, ma daka bae tataga kou fuana a Jesus, ma daka bae urii, ");
INSERT INTO llu_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","<<I oe o haea oko oogosia na Beu Aabu nia a God ma oko tole faalu lau ana sulia oolu fe dani go. Haia, lea so i oe na Wela nia a God, oko faamouri oe fasi i talamu, oko sifo mai faasia na airarafolo naa.>> ");
INSERT INTO llu_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ma na fataabu baita gi gera ka onionga ana urinae laugo, fai gera na wane faatolomai ana kwaieresia gi ma na wane baita, daka urii, ");
INSERT INTO llu_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","<<I nia e faamouria na tooa eꞌete gi, sui ka langi si haitamana ka faamouri nia i talana. Lea so nia na Aaofia gia na Jiu, nia ka sifo mai faasia na airarafolo, eeri gia ka manata mamana ani nia. ");
INSERT INTO llu_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","I nia e fiitoo ana a God, ma ka haea urii, <I nau naa na Wela nia a God.> Golu aadaada hai so golu ka rikia a God tara ka dooria faamouria ma langi langi.>> ");
INSERT INTO llu_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ma i daaro roo wane taꞌa na da fotoia fai nia, daaro bae tataga laugo ani nia urinae. ");
INSERT INTO llu_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","E ita ana na initoona na hato lea ka dao i haulafi, na mae rodo ka afu faafia na aefera teefou. ");
INSERT INTO llu_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ma i haulafi, a Jesus ka rii baita ka urii, <<Eli, Eli, lema sabaktani.>> Na malutana baa, <<God nau ae, God nau ae, uria taa na oko lugasi nau?>> ");
INSERT INTO llu_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ma teni tooa da too garangi, gera rongoa, ma gera ka bae urii, <<I nia e soea a Elaeja.>> ");
INSERT INTO llu_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ma tee wane ada e lalao ka ngalia mai tesi fulo, ma ka faafungua ana na waen afae, ma ka uusuia ana si ai, ma ka falea fuana hai nia ka gwoufia. ");
INSERT INTO llu_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ma na teni tooa aai gi lau gera ka urii, <<Too ana, golu ka aada fasi a Elaeja ka dao mai uria na faamourilana ma langi langi.>> ");
INSERT INTO llu_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Sui, a Jesus e rii baita lau, ma ka mae naa. ");
INSERT INTO llu_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ma si maku na e bokosia na gula aabu i laona Beu Aabu nia a God e seka ana roo si doo e ita mai i langi lea ka dao i aano. Ma na aanuanu ka liu, ma na fou gi ka foga, ");
INSERT INTO llu_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ma teni kwaingeia gi daka ifi, ma na rae oro gi ana tooa a God na da mae naa, daka mouri lau. ");
INSERT INTO llu_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ma gera ka haga faasia kwaingeia gera gi. Ma i buira a Jesus ka tatae laugo, daka ruu i fera aabu i Jerusalem. Ma na tooa oro gi daka riki gera. ");
INSERT INTO llu_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ma na wane baita ana oomea na e haungia a Jesus fai nia na oomea nia, si kada gera rikia na aanuanu ma na doo eꞌete gi sui laugo na e fuli, gera ka mou asianaa ma daka bae urii, <<Nia e mamana asianaa, i nia na Wela a God.>> ");
INSERT INTO llu_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ma teni geni oro gi na gera lea i buira a Jesus ita mai i Galili ma gera adomia, gera too laugo i seenae ma daka aadaada tau laugo mai ada. ");
INSERT INTO llu_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Na aai ada na ni Mary faasia i Magdala, ma ni Mary na tee nia a James ma a Josef, ma afe nia a Sebedi, ma oote geni gi lau. ");
INSERT INTO llu_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ana si kada e haulafia naa garangia rodo, tee wane rikidoo e lea mai. Nia tee wane faasia i fera i Arimetea, ma na hatana a Josef. Ma nia tee wane fafurongo a Jesus laugo. ");
INSERT INTO llu_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ma nia e lea siana a Paelat ma ka gania na nonina a Jesus. A Paelat e haea daka falea fuana. ");
INSERT INTO llu_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ma a Josef e ngalia na nonina a Jesus, ma ka afua ana si maku kwakwaoa faalu. ");
INSERT INTO llu_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Sui nia ka aalua i laona na kwaingeia faalu nia, na gera garua i laona na fou baita. Sui nia e bokosia na maana na kwaingeia nae ana si fou baita, sui ka lea na ana. ");
INSERT INTO llu_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ni Mary faasia Magdala ma ni Mary aai, daaro too gwouru i maa ana na kwaingeia. ");
INSERT INTO llu_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ma ana fe dani lau fe dani i buira Fraede fe dani Sabat, na fataabu baita gi ma na Farisi gi gera oofu uria faarai oofulaa fai nia a Paelat. ");
INSERT INTO llu_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ma gera ka bae urii fuana, <<Wane baita ae, gemelu manatatoona kada wane susuge baa nia mouri ua, nia bae urii, <Nau tara kuka mouri lau ana ooula fe dani!> ");
INSERT INTO llu_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Haia, lea doo oko faarongo wane oe gi lea gera ka fofolo siana na kwaingeia lea ka dao ana ooula maedani. Langi si diana na oote fafurongo nia gi gera ka ngalia ada na nonina, ma gera ka aagwa ada, sui gera ka sugea tooa, daka haea Jesus e mouri lau. Haia, oe haitamana hasa lea gera suge urinae, tara ka taꞌa asianaa nae liufia si sugelaa baa gi nia sugea mai ana tooa.>> ");
INSERT INTO llu_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ma a Paelat ka urii fuagera, <<Haia, lea urinae, gomolu naa molu aadafilia teni wane ana oomea nau gi eeri gera ka lea fofolo, ma gera ka fofolo diana usia na kwaingeia nae.>> ");
INSERT INTO llu_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Haia, ma ana si kada fataabu baita gi ma na Farisi gi gera rongoa si doo nae, gera aade aagau na ada, gera ka lea naa siana na kwaingeia. Ma si kada gera dao ana gula nae, gera ka aalua na mamalafooa ana kwaingeia naa, haia lea ta wane ka idua boro na maa ana kwaingeia, gera ka haitamana. Ana si kada nae laugo, gera ka aalua wane fofolo gi. ");
INSERT INTO llu_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","I buira fe dani ni mamaloa ana na Sabat, si kada e dani maakafukafua ua ana na Sandei i ubongi, ni Mary faasia i Magdala ma ni Mary aai baa, daaro ka lea siana na kwaingeia baa uria rikilana. ");
INSERT INTO llu_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ma aliꞌali na aanuanu baita ka gelo, ma tee ensel nia a Lord ka sifo mai faasia i langi, ma ka geloa na fou baa faasia na maana na kwaingeia, ma ka gwouru i fafona. ");
INSERT INTO llu_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Na rikilana e iilingia na sinamaaru ma na maku nia gi e kwakwaoa asianaa. ");
INSERT INTO llu_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ma ana si kada na wane fofolo gi da rikia, gera ka mou asianaa, ma gera ka lelebe, ma da iilingia na ada na wane mae gi. ");
INSERT INTO llu_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ma na ensel nae ka bae urii fuadaaro na roo geni nae gi, <<Langi moro si mou. I nau ku haitamana moro nani uria a Jesus baa gera haungia i fafona na airarafolo. ");
INSERT INTO llu_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","I nia e langi kasi too naa i seegi. I nia e mouri naa lau naa iilingia baa e haea fuagamu. Moro lea mai seenaa, ma moro ka rikia amoro si gula baa nia e teo ana. ");
INSERT INTO llu_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Haia, moro lea aliꞌali naa, ma moro ka faarongoa na oote fafurongo nia gi urii, <A Jesus e mouri naa lau, ma ka lea naa i nao ani gomolu uria i Galili, ma tara molu ka riki nia naa i seenae.> Ma moro ka manatatoona si doo nae ku haea fuamoro.>> ");
INSERT INTO llu_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ma aliꞌali daaro tafusia naa kwaingeia, sulia daaro mou. Ma sui boroi ana, daaro ka eele asianaa. Ma daaro ka lea aliꞌali uria na faarongolaa na oote fafurongo nia gi. ");
INSERT INTO llu_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ma ana si kada nae, a Jesus e toodaa daaro, ka bae urii, <<Na fanualama ka too fai gomoro.>> Ma daaro ka lea mai siana, ma daaro ka boururu usia ma daaro ka dau kou i aena. ");
INSERT INTO llu_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ma a Jesus ka bae urii fuadaaro, <<Langi moro si mou. Moro lea, ma moro ka faarongoa na haasigu gi hai daka lea uria i Galili. Ma tara gera ka riki nau naa i seenae.>> ");
INSERT INTO llu_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Haia, ana si kadamanga roo geni gi gera ooli kou sulia na tala, teni wane ana wane fofolo naa gi gera lea naa faasia kwaingeia Jesus, ma gera ooli naa fui Jerusalem. Si kada gera dao ana maefera baita nae, gera ka uunuunu naa sulia si doo gi sui na gera rikia siana fataabu baita gi. ");
INSERT INTO llu_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ma si kada na fataabu baita ma teni tooa baita gi lau ana gera Jiu gi gera ka faarai oofu sui, gera ka falea si malefo baita fuana wane ni fofolo gi. ");
INSERT INTO llu_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Kada gera falea ana si malefo na fuada wane fofolo naa, gera ka bae urii, <<Molu ka suge urinae fuana wane gi sui, <Kada melu teo ana la rodo, na oote fafurongo a Jesus gi daka lea mai, ma gera ka belia na nonina.>>> ");
INSERT INTO llu_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ma na tooa baita naa gi gera bae laugo urii, <<Lea Paelat e rongoa si doo naa, langi molu si manata aꞌabo lau, sulia tara gemelu naa melu ka olosia fuana, eeri langi nia kasi rakehasui gomolu.>> ");
INSERT INTO llu_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ma si kada wane fofolo naa gi gera ngalia na malefo nae gi sui, gera ka lea, ma daka iilia na ada si doo gi na fataabu baita gi ma na wane baita gi gera Jiu gera haea fuada. Haia, ma na uunuunulaa naa ana suge ka galida sui na Jiu gi lea mai lea ka dao i taraꞌena. ");
INSERT INTO llu_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Na aakwala ma tee wane fafurongo gi da lea naa fui Galili, uria tee fe uuo nae a Jesus e haea fuada hai daka lea uria. ");
INSERT INTO llu_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ma si kada gera riki nia ana, gera ka boururu usia boroi ana teni wane ada daka manata ruarua. ");
INSERT INTO llu_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Sui a Jesus ka dao mai siada, ka bae urii, <<A God e falea sui naa na mamanaa gi sui i langi ma i laona molaagali fuagu. ");
INSERT INTO llu_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Nia naa, molu ka lea, ma molu ka faatolomai na tooa gi sui i maefera gi sui, hai daka hau ana na tooa fafurongo nau gi. Ma molu ka siuabu gera ana hatana na Maa ma na Wela ma na Aanoedoo Aabu. ");
INSERT INTO llu_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ma molu ka faatolomaida eeri gera ka roosulia na doo gi sui na ku eeresia gamu ana naa. Ma i nau ku too fai gamu lea ka dao ana na suilana na molaagali.>>");
INSERT INTO llu_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Na hafalilana mai na Faarongolaa Diana naa sulia a Jesus Christ na Wela nia a God e urii: ");
INSERT INTO llu_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","E talaꞌae iilingia baa a Aesea na profet na e kekedea si doo na a God e haea fuana a Christ ka urii, <<Tara nau ku oodua kou na wane ni ngali baea nau i nao ani oe, eeri ka aade aagau ana tala fuamu. ");
INSERT INTO llu_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Tee wane e rii i laona na aanogwou ka urii, <Na Lord e dao na mai! Muka aade aagau ana na tala maasi nia, ma muka olosia na tala fuana.>>> ");
INSERT INTO llu_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Urinae a John Siuabu e dao mai i aanogwou, ma ka funao ka bae fifii fuana na tooa gi eeri daka oolitai manata ma daka siuabu, eeri a God ka manata lukea na aade taꞌalaa gera gi. ");
INSERT INTO llu_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ma na tooa oro gi faasia na lolofaa i Judea ma na fera i Jerusalem, da lea mai uria rongolana na baelana John. Gera ka faarongo ana na aade taꞌalaa gera gi, ma nia ka siuabu gera i laona kafo i Jodan. ");
INSERT INTO llu_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","A John e ofi ana na maku ana iifuna doo fai ae na da alangia ana na kamel, ma ka kania na kakabe ana na ungana na bulumakau i liitana, ma ka ania na siko gi ma na wewedua. ");
INSERT INTO llu_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ma a John ka bae urii fuana tooa gi, <<Tee wane tara ka lea mai i burigu, ma i nia e baita ka tasa liufi nau, ma i nau kusi faorana uria na agwaarolaa uria na lukelana na tae silipa nia. ");
INSERT INTO llu_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Haia, i nau ku siuabu gamu go agu ana na kafo, sui tara nia ana na ka siuabu gamu ana na Aanoedoo Aabu.>> ");
INSERT INTO llu_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","E langi si tau laugo i buira doo nae gi, a Jesus e dao mai faasia na fera i Nasaret i laona na lolofaa i Galili, ma ka dao mai siana a John. Ma a John ka siuabu nia i laona na kafo i Jodan. ");
INSERT INTO llu_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ma ana si kada a Jesus e tatae mai faasia laona na kafo, i nia ka rikia na lofo halo e ifi ma na Aanoedoo Aabu ka sifo mai faafi nia iilingia fe bola. ");
INSERT INTO llu_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ma tesi lingee doo e talo mai faasia i langi ka urii, <<Ni oe naa na wela rakediana nau, nau ku eele asianaa suli oe.>> ");
INSERT INTO llu_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ma ana si kada nae ua go, na Aanoedoo Aabu ka talaia Jesus fui aanogwou. ");
INSERT INTO llu_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ma nia ka too i seenae sulia fai aakwala fe dani, ma a Satan ka iilitoona. Na doo kwasi gi da too laugo seenae, ma na ensel gi daka lea mai, daka aadasuli nia. ");
INSERT INTO llu_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","I buira na da aalua sui naa a John i laona na beu ni kanilaa, a Jesus ka lea i Galili ma ka ainitalo ana na Faarongolaa Diana faasia a God. ");
INSERT INTO llu_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","I nia ka bae urii, <<Si kada e dao naa, ma na Initooa a God e dao garangi na mai. Muka oolitai manata faasia na aade taꞌalaa gamu gi, ma muka manata mamana ana na Faarongolaa Diana naa.>> ");
INSERT INTO llu_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ma ana si kada a Jesus e lea i kamena na aasi i Galili, nia ka rikia a Simon fai nia haasina a Andrew. Daaro dedee adaaro ana moge daaro laona na aasi nae, sulia daaro na roo wane da dedee gi. ");
INSERT INTO llu_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ma a Jesus ka bae urii fuadaaro, <<Moro lea mai fai nau, ma langi molu si nani naa uria iia go ana, sulia i nau tara ku toolamainia na nanilaa uria na tooa gi fuamoro eeri gera laugo tara daka lea mai fai nau.>> ");
INSERT INTO llu_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ma si kada nae ua go, daaro ka lugasia naa na moge daaro gi, ma daaro ka lea fai nia. ");
INSERT INTO llu_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ma si kada a Jesus e lea toꞌou lau kou, nia ka rikia a James fai nia a John, na roo wela a Sebedi gi. Daaro gwouru adaaro i laona na baru, ma daaro ka kauraa furai adaaro. ");
INSERT INTO llu_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ma si kada a Jesus e riki daaro go, nia ka soe daaro naa, ma daaro ka tafusia na maa daaro a Sebedi i laona na baru fai nia na wane ni rao gi, ma daaro ka lea naa fai nia a Jesus. ");
INSERT INTO llu_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","A Jesus fai nia na oote fafurongo nia gi da dao ana fera i Kapaneam. Ma ana maedani Sabat, a Jesus ka lea laona na Beu Aabu ni figulaa ma ka faatolomaidoo. ");
INSERT INTO llu_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ma na tooa gi daka kwele asianaa ana na faatolomaia nia, sulia nia e faatolomai mala na wane na e too ana na mamanaa, ma ka eꞌete asianaa faasia na wane faatolomai gi ana na kwaieresia gi. ");
INSERT INTO llu_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ma ana si kada nae laugo, tee wane na aagalo taꞌa e adosia, nia e ruu mai laona na Beu Aabu nae. Ma nia ka rii ka urii, ");
INSERT INTO llu_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","<<Jesus ae! Ni oe na wane faasia i Nasaret! Na taa naa tara oko iilia ani gemelu? Ni oe o lea mai uria na faafunuilamelulaa naa? I nau ku haitamamu go agu, ni oe na wane Aabu nia a God!>> ");
INSERT INTO llu_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ma a Jesus e bae susuala fuana na aagalo taꞌa nae ka urii, <<O bona amu, ma oko haga mai i maa faasia na wane na na!>> ");
INSERT INTO llu_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ma na aagalo taꞌa nae e rii ma ka lebesia na wane nae, ma ka haga tafa na mai faasia. ");
INSERT INTO llu_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ma na tooa gi sui na da oogu i seenae, daka kwele asianaa, ma daka ledi kwailiu ani gera daka urii, <<Na taa naa e urii? Ta faatolomaia faalu oto mone na e too ana na rigitaa urii naa. Sulia na aagalo taꞌa gi boroi, i nia e oodu gera ma daka roosulia na baelana.>> ");
INSERT INTO llu_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Haia, na uunuunu sulia a Jesus ka talofi aliꞌali fuana na lolofaa teefou nae i Galili. ");
INSERT INTO llu_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jesus fai nia a James ma a John ma teni tooa lau, gera lea kou faasia na Beu Aabu ni figulaa, daka lea fai nia a James ma a John uria luma gera a Simon ma a Andrew. ");
INSERT INTO llu_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ma na fungo geni a Simon e matai ana tatasua, ma ka teo go ana i laona na iifitai nia. Si kada a Jesus e dao ana luma nae, gera faarongo ana siana. ");
INSERT INTO llu_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ma nia ka lea siana geni nae, ma ka dau i abana, ma ka faatataea. Ma na tatasulaa nae ka sui faasia, ma nia ka falea fanga fuada. ");
INSERT INTO llu_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ma ana fe haulafia nae, si kada na hato e suu, na tooa gi da ngalia mai siana a Jesus na tooa matai gi sui ma na tooa gi sui na aagalo taꞌa gi da adosida laugo. ");
INSERT INTO llu_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ma tooa gi sui faasia fera nae daka figu mai i maana na luma nae. ");
INSERT INTO llu_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ma a Jesus ka guraa na tooa oro gi na da matai ana na matailaa oro eꞌete gi. Ma nia ka taria laugo na aagalo taꞌa oro gi. Ma i nia ka langi si faalamainia na aagalo taꞌa nae gi dasi bae, sulia gera da haitamana sui go naa i nia naa ni tei. ");
INSERT INTO llu_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","I ofaidani ana bobongi si kada e rorodoa ua, a Jesus e tatae, ma ka haga kou i maa faasia na luma nae, ma ka lea uria na fooalaa ana tesi gula nae e aaroaro. ");
INSERT INTO llu_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ma a Simon fai nia na ruana nia gi da lea, ma daka nani uri nia. ");
INSERT INTO llu_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ma si kada daalu daotoona, daalu ka bae urii fuana, <<Na tooa gi da nani uri oe.>> ");
INSERT INTO llu_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ma a Jesus e oolisida ka urii, <<Golu ka lea lau ana teni fera aai gi garangi i seegi, eeri kuka funao laugo fuada, sulia aena si doo nae na kuka lea mai laona molaagali naa.>> ");
INSERT INTO llu_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ma i nia e lea laona na maefera gi sui i laona na lolofaa na i Galili, ma ka funao i laona Beu Aabu ni figulaa gera gi, ma ka taria na aagalo taꞌa gi faasia tooa oro gi. ");
INSERT INTO llu_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Tee wane na fura e ania nonina e lea mai siana a Jesus, ma ka boururu ma ka ingo nia ka urii, <<Lea so o dooria, oko faamafoa fasi na nonigu naa.>> ");
INSERT INTO llu_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ma a Jesus e kwaimanatai asianaa fuana, ma ka tekwalaa na aba kou ma ka hamosia na wane nae, ka bae urii, <<Nau ku dooria agu. Na nonimu naa ka mafo naa!>> ");
INSERT INTO llu_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ma aliꞌali go na fura nae ka sigi naa faasi nia, ma na nonina ka mafo teefou naa. ");
INSERT INTO llu_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ma a Jesus ka oodua na wane nae ka lea na ana, ma ka bae fifii fuana ka urii, ");
INSERT INTO llu_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","<<Langi osi faarongoa lau ta wane ana si doo na ku iilia ani oe naa. O lea, oko faatai na nonimu siana na fataabu, ma oko falea na kwaisuusia na a Moses e eeresia eeri ka falea na faamamanalaa fuana na tooa gi sui naa na nonimu e mafo naa.>> ");
INSERT INTO llu_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Sui, na wane nae e lea, ma ka uunuunu ana sulia si taa baa a Jesus e iilia ani nia ana si gula gi sui. Nia naa, ka afetai naa fuana a Jesus uria na lea faatailaa i laona na fera gi, ma ka too go ana i maa ana si gula aaroaro gi. Ka urinae boroi ana, na tooa gi faasia na fera gi sui daka lea go mai ada i siana. ");
INSERT INTO llu_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Na aange fe dani i buira, a Jesus e ooli lau mai uria i Kapaneam. Ma na faarongolaa suli nia ka tagala hasa i nia e too go ana i fera. ");
INSERT INTO llu_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Urinae na tooa oro gi asianaa daka figu mai siana Jesus lelea na luma na nia e too ana ka fungu asianaa, ma ka langi naa tesi gula ni toolaa i laona luma. Ma i maa boroi, na tooa oro gi asianaa da figu laugo ana. Ma a Jesus ka funao fuada. ");
INSERT INTO llu_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ma ana si kada nae laugo tee fai wane gi da lea mai, daka ngalia mai tee wane na nonina e mae. ");
INSERT INTO llu_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ma sulia na figua baita nae, nia naa ka afetai naa fuada uria na ngalilana kou siana Jesus. Urinae daalu ka raa i fafona luma fai nia na wane nae. Ma daalu ka tafangia tee maekwadaa baita i fafona luma i ootofana si gula nae a Jesus e too ana, ma daalu ka faasifoa na wane nae i fafona iifitai nia siana a Jesus. ");
INSERT INTO llu_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ma si kada a Jesus e rikia na manata mamanalaa gera nae, nia ka bae urii fuana na wane noni mae nae, <<Ruana ae, nau ku manata lukea naa na aade taꞌalaa oe gi.>> ");
INSERT INTO llu_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ma si kada nae, teni wane faatolomai ana kwaieresia gi da gwouru laugo i seenae, ma daka manata ada urii fuada i talada, ");
INSERT INTO llu_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","<<Uria taa na wane naa ka bae urinae? I nia e bae tataga ana God nae! E langi ta wane si bobola fai nia na manata lukelana na aade taꞌalaa gi, tee taifilia a God go ana na ka bobola fai nia!>> ");
INSERT INTO llu_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ma ana si kada nae laugo a Jesus ka haitamana go ana si manataa gera loko gi i lioda, ma nia ka bae urii fuada, <<Uria taa na molu ka manata urinae? ");
INSERT INTO llu_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Nia e waluda go ana uria na haelana fuana na wane naa na nonina e mae, <Nau ku manata lukea naa na aade taꞌalaa oe gi,> sulia langi molu si rikia hasa kuka too ana rigitaa uria iililanalaa. Sui taa, nia e afetai uria na haelana, <O tatae, oko ngalia na iifitai oe, ma oko fali,> sulia tara molu ka rikia hasa kuka too ana mamanaa uria iililanalaa, langi e langi. ");
INSERT INTO llu_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","I nau ku iilia si doo aai na e afetai naa uria na faamamanalana fuamolu hasa nau, na Wela nia Iimola gi, ku too ana na mamanaa lao molaagali naa uria na manata lukelana na aade taꞌalaa gi.>> Ma i nia ka bae urii fuana na wane nae na nonina e mae, ");
INSERT INTO llu_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","<<I nau ku haea fuamu, o tatae, ngalia na iifitai oe, oko lea naa i fera oe.>> ");
INSERT INTO llu_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ma na wane nae e tatae i maada, ma kafi ngalia na iifitai nia ma ka lea naa. Ma i gera sui daka kwele asianaa, ma daka silia a God urii, <<Langi golu si rikia ua mai tesi doo urii!>> ");
INSERT INTO llu_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","A Jesus e lea ooli lau i kamena na aasi i Galili. Ma tee figua baita daka lea mai siana, ma i nia ka hafalia na faatolomai fuada. ");
INSERT INTO llu_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ma ana si kada nia e liu kou, nia ka rikia a Livae na wela a Alfeas e gwouru go ana si gula nia ni gonilana na malefo ana na takisi. Ma a Jesus ka bae urii fuana, <<O lea mai fai nau.>> Ma a Livae e tatae ma ka lea na ana fai nia. ");
INSERT INTO llu_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ma i buira na a Jesus e soea sui, i nia e lea ka fanga i luma nia a Livae. Ma na wane faafefe oro gi ana wane goni malefo ana na takisi, ma na wane taꞌa gi aai, da fanga laugo fai nia a Jesus ma na oote fafurongo nia gi. Sulia na tooa oro urinae gi na da lea fai nia. ");
INSERT INTO llu_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ma na wane gi na da faatolomai ana kwaieresia gi na da Farisi laugo, si kada gera rikia naa a Jesus e fanga fai nia na wane gi na da gonia na malefo ana na takisi ma na wane taꞌa gi aai, daka ledia na oote fafurongo nia gi daka urii, <<Uria taa na nia ka fanga fai gera na wane taꞌa loko gi?>> ");
INSERT INTO llu_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ma si kada a Jesus e rongoa si doo nae, nia ka bae urii fuada, <<E langi lau na wane na e akwaa na e dooria na wane na e kwaifaamouri, ma ni tei gera na da matai taari daka dooria na wane urinae eeri ka gura gera. Urinae, i nau kusi lea mai uria na soelana na tooa na toolada e oꞌolo gi, ma ku lea mai taari uria na soelada na tooa taꞌa gi.>> ");
INSERT INTO llu_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ana tesi kada na oote fafurongo nia gi a John Siuabu ma na Farisi gi da aabu fanga. Ma teni tooa gi da lea mai, ma daka ledia a Jesus daka urii, <<Uria taa naa na oote fafurongo a John gi ma na oote fafurongo gera na Farisi gi daka aabu fanga, ma na oote fafurongo oe gi ka langi?>> ");
INSERT INTO llu_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ma a Jesus e oolisida ka urii, <<Na tooa gi na da kwairoꞌoi ana ta baraa langi dasi aabu fanga si kada wane fungao e too ua ana fai gera. Afetai daka aabu fanga si kada na nia e too ua ana fai gera. ");
INSERT INTO llu_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Sui, tara ka dao ana si kada tooa eꞌete da lafua na fungao faasi gera, ma ana fe dani nae taari gera dafi aabu fanga. ");
INSERT INTO llu_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","<<E langi ta wane so ka modea ta maku na e udaꞌuda naa fai nia si maku na e faalu. Sulia lea so nia ka iilia si doo nae, si maku faalu nae ka lafi karia na maku nae e udaꞌuda naa, ma ka haungainia na maekwadaa na baita. ");
INSERT INTO llu_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ma muka haitamana naa na waen da taingainia i laona na ungana na nanigot, e afetai ta wane ka aalua na waen faalu i laona na ungedoo kwali. Sulia lea so i nia ka iilia si doo urinae, si kada na waen nae ka furafura mai, nia ka fogea na ungedoo kwali nae, ma na waen nae ma na ungedoo nae ka taꞌa sui go. Nia naa aadea i nia ka aalua na waen faalu i laona na ungedoo faalu laugo.>> ");
INSERT INTO llu_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ana tee maedani ana Sabat, a Jesus ma na oote fafurongo nia gi da tasa sulia na tala na e liu i laona na raoa ana doo iilingia raes. Ma si kada gera liu ana, na fafurongo nia gi daka fusia funge doo gi. ");
INSERT INTO llu_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ma na Farisi gi daka bae urii fuana a Jesus, <<O rikia fasi! Uria taa na oote fafurongo oe gi daka iilia si doo naa na kwaieresia e luia ana maedani ana Sabat?>> ");
INSERT INTO llu_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Ma a Jesus e oolisida ka urii, <<Gamu langi molu si iidu haitamana go si doo baa a David e iilia si kada baa a Abiata na wane e fooanigwou? Si kada baa a David ma na wane nia gi da fiolo, sulia langi ada tesi fanga. Ma nia ka lea i laona na Beu Aabu nia a God, ma ka ania na beredi nae da falea sui naa fuana a God. Ma e aabu asianaa fuana a David ma na wane nia gi uria na anilana na beredi nae, sulia taifilia go na fataabu gi go ana na daka haitamana anilana. Ma sui a David ka ania go ana ma ka falea laugo fuada na wane nia gi, ma daka ania.>> ");
INSERT INTO llu_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Sui a Jesus ka bae urii fuada, <<A God e haungainia maedani ana Sabat fuana na tooa gi. I nia langi kasi haungainia na tooa gi fuana maedani ana Sabat. ");
INSERT INTO llu_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","I aena naa nau, na Wela nia Iimola gi, ku too ana na mamanaa usia si maedani ana Sabat lau.>> ");
INSERT INTO llu_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Sui a Jesus e lea lau i laona na Beu Aabu ni figulaa, ma tee wane na abana e mae e too i seenae. ");
INSERT INTO llu_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ma teni tooa gi i seenae, daka dooria feengilana a Jesus. Nia na aadea gera ka bubu suli nia, hai so daka rikia lea so i nia ka guraa na wane nae ana maedani ana Sabat. ");
INSERT INTO llu_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ma a Jesus ka bae urii fuana na wane nae na abana e mae, <<O take mai i seegi i nao ana na tooa naa gi sui go.>> ");
INSERT INTO llu_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Sui a Jesus ka ledi gera ka urii, <<Si taa naa na kwaieresia golu e faalamainia hai golu ka iilia ana maedani ana Sabat? E faalamainia na iililana si doo diana gi ma langi na iililana si doo taꞌa gi? E faalamainia na faamourilana ta wane, langi na haumaelilana ta wane?>> Sui ka langi dasi oolisia go ana tesi doo. ");
INSERT INTO llu_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","A Jesus e rakehasu, ma ka aada galigali gera, sui taa e kwaimanatai lau fuada sulia da garo asianaa i laona na lioda, ma na mangoda ka ngasi laugo. Sui i nia ka bae urii fuana na wane nae, <<O tekwala mai na abamu.>> Ma nia ka tekwalaa na abana go, ma na abana ka diana naa lau. ");
INSERT INTO llu_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Sui na Farisi gi da haga kou i maa, ma daka bae oofu fai nia teni wane ana gule tooa a Herod gi, ma daka haungainia teni manata gi uria haumaelilana a Jesus. ");
INSERT INTO llu_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Sui a Jesus fai nia oote fafurongo nia gi daka lea uria na aasi i Galili, ma na tooa oro gi daka lea i buira. I gera da lea mai faasia na bali fera i Galili ma i Judea, ");
INSERT INTO llu_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ma faasia i Jerusalem ma i Idumea, ma faasia na bali fera loko gi da ooli fui taelana hato ana kafo i Jodan. Ma teni tooa da lea mai faasia na fera gi galia na fera i Taea ma i Saedon. Na figua baita nae da lea mai i siana a Jesus, sulia da rongoa si doo baita gi na i nia e iilida. ");
INSERT INTO llu_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","A Jesus ka haea fuana na oote fafurongo nia gi hai daka aade aagau ana ta baru, aata na tooa gi daka beresia, sulia na figua nae e baita asianaa. ");
INSERT INTO llu_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Sulia nia e guraa na tooa oro gi, nia naa na tooa gi na mataia gi e haungida daka suungai gera kou hai so daka hamosia mone ada a Jesus. ");
INSERT INTO llu_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ma si kada na tooa gi na aagalo taꞌa gi e adosida da riki nia, daka boururu i nao ani nia ma daka rii ka urii, <<I oe na Wela nia a God!>> ");
INSERT INTO llu_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ma a Jesus ka bae luida ana na aagalo taꞌa nae gi, hai ka langi dasi faarongoa lau ta wane ani nia. ");
INSERT INTO llu_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Sui a Jesus e raa kou gwouna tee fe uuo, ma ka soea na wane gi na nia doorida, ma gera ka lea mai siana. ");
INSERT INTO llu_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ma nia ka aadafilia na aakwala ma roo wane, ma ka alangi gera ana aposol gi. Ma nia ka bae urii fuada, <<Nau ku aadafili gamu eeri muka too fai nau ma kuka oodu gamu laugo uria na funaolaa. ");
INSERT INTO llu_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ma molu ka too ana na mamanaa uria na tarilana na aagalo taꞌa gi.>> ");
INSERT INTO llu_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Haia, na hatada na aakwala ma roo wane na nia e filida: A Simon (na a Jesus e faahataa laugo ana a Peter), ");
INSERT INTO llu_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ma a James ma a John na wela a Sebedi gi (na a Jesus e alangi daaro ana Boneges, na malutana na wane gi na da iilingia na kwakwanga), ");
INSERT INTO llu_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ma a Andrew, ma a Filip, ma a Batolomiu, ma a Matthew, ma a Tomas, ma a James na wela nia a Alfeas, ma a Tadeas, ma a Simon na wane ana tee gule tooa gera Jiu na da dooria tarilana na tooa i Rom faasia Israel, ");
INSERT INTO llu_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ma a Judas Iskariot na wane baa na e falea Jesus fuana maalimaea nia gi. ");
INSERT INTO llu_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Sui a Jesus ka ooli i fera. Ma na tooa oro gi daka figu laugo mai, ma ka langi naa tesi kada hai so a Jesus ma na oote fafurongo nia gi uria na fangalaa. ");
INSERT INTO llu_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ma si kada na tooa futa nia gi da rongoa si doo nae, i gera ka lea uria, sulia da rongoa na tooa gi da bae daka urii, <<I nia e ooewanea naa.>> ");
INSERT INTO llu_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ma teni wane faatolomai doo gi ana na kwaieresia na da lea mai faasia i Jerusalem daka bae urii, <<Na wane baita ana na aagalo taꞌa gi na hatana a Bielsebul naa e too fai nia a Jesus naa! Ma a Jesus ka taria na aagalo taꞌa gi ana na mamanaa na wane baita nae ana aagalo taꞌa gi naa.>> ");
INSERT INTO llu_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Nia naa, a Jesus ka soeda mai siana ka bae urii fuada ana si baea oomelawanea gi ka urii, <<A Satan na molu alangia ana a Bielsebul i nia ka tari utaa ani nia i talana? ");
INSERT INTO llu_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Haia, lea so na initooa ka firu fai nia i talana, tara na initooa nae e afetai ka oofu. ");
INSERT INTO llu_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ma lea so na wane ma na afe nia ma na wela nia gi da firu fai gera i talada, tara e afetai daalu ka oofu. ");
INSERT INTO llu_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ma na initooa a Satan ka urinae laugo. Lea so na initooa nia ka firu fai nia i talana, tara na initooa nae ka tagala ma ka funu go ana. ");
INSERT INTO llu_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","<<Ma a Satan e iilingia laugo ta wane rigita. E afetai ta wane aai ka ruu i laona na luma nia ta wane rigita ma ka ngalia si doo nia gi faasia, lea so i nia langi kesi kani faafia fasi na wane rigita nae i nao. ");
INSERT INTO llu_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","<<Doo mamana nau ku haea fuagamu, na aade taꞌalaa gi sui ma na bae tatagalaa gi sui na tooa gi da iilida, a God ka bobola uria manata lukelana go ana. ");
INSERT INTO llu_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Haia, so ta wane ka bae tataga fuana na Aanoedoo Aabu, tara God kasi manata lukea, sulia i nia naa na aade taꞌalaa na e totoo firi.>> ");
INSERT INTO llu_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","A Jesus e haea si doo naa sulia na tooa gi da haea nia e too ana na aagalo taꞌa. ");
INSERT INTO llu_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ma i buira doo nae gi, ni tee nia a Jesus ma na haasina gi, daka dao naa. Ma gera ka take go ada i maana luma, ma daka fale baea kou fuana ma daka ledi uri nia. ");
INSERT INTO llu_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Na tooa oro gi asianaa na da gwouru gali nia ma daka faarongo nia daka urii, <<Ni tee oe ma na haasimu gi da nii mai i maa, i gera da doori riki oe.>> ");
INSERT INTO llu_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ma a Jesus e oolisida ka urii, <<Ni tei naa ni tee nau ma na haasigu gi?>> ");
INSERT INTO llu_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Sui nia ka aada kou fuana na tooa gi na da gwouru gali nia, ma ka bae urii, <<Nia naa na tooa da iilingia ni tee nau ma na haasigu gi! ");
INSERT INTO llu_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Sulia ni tei go ana na e iilia si doo gi na a God e dooria, i nia naa iilingia na haasigu, ma na waiwane nau, ma ni tee nau.>> ");
INSERT INTO llu_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ana tesi kada lau a Jesus e faatolomai i kamena aasi i Galili. Ma na tooa oro asianaa daka figu gali nia, ma i nia ka tae i laona tee baru, ma ka gwouru i laona, ma ka lea toꞌou i kafo. Ma na tooa gi daka take kou i kamena kafo. ");
INSERT INTO llu_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ma a Jesus e faatolomainia si doo oro gi fuada ana si baea oomelawane gi ka urii, ");
INSERT INTO llu_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","<<Molu fafurongo fasi! Tee wane e lea ka fasia na mige doo nia gi i laona raoa nia. ");
INSERT INTO llu_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ma si kada nia e tagalangainia ana na mige doo nae gi, teni mige doo gi da asida sulia na tala, ma na manu gi da lofo mai, ma daka anida teefou. ");
INSERT INTO llu_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ma teni mige doo gi da asida ana si gula foulaa, si gula na gano kasi baita. Ma da tae aliꞌali sulia na gano e rauraua. ");
INSERT INTO llu_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Haia, si kada na hato e tae mai, nia ka hatofia na ai nae gi, ma daka kuku laugo ada, sulia na lali doo gi kasi lea oolo. ");
INSERT INTO llu_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ma teni mige doo gi da asida i matangana na kwaletotore gi, na e tae mai ma ka nuku faafia na ai gi, ma ka langi dasi fungu go. ");
INSERT INTO llu_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ma teni mige doo gi lau e asia i laona na gano na e diana, ma da tae mai ma daka fungu ana doo oro gi. Ma teni doo gi daka fungu ana oolu finite doo gi, ma teni doo gi daka fungu ana oono finite mige doo gi, ma teni doo gi lau daka fungu ana tee talange doo gi.>> ");
INSERT INTO llu_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Sui a Jesus ka isia baelana urii, <<Muka manata diana sulia si doo nae gi na mu rongoda gi.>> ");
INSERT INTO llu_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Si kada a Jesus e too ana taifilia, na bali ana wane gi na da rongoa na baelana daka lea mai siana fai nia na aakwala ma roo fafurongo nia gi, ma daka ledi nia eeri ka lukea fuada na malutana na baea ni oomelawanea baa gi. ");
INSERT INTO llu_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ma nia ka oolisi gera ka urii, <<A God e faatainia sui naa si doo aagwa gi sulia na Initooa nia fuagamu. Haia, ma na tooa gi na da too i maa ana Initooa nia, nau kuka haea si doo gi sui fuada ana si oomelawanea gi, ");
INSERT INTO llu_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","eeri daka aadaada boroi, ma langi dasi aada haitamana go tesi doo, ma da fafurongo boroi, ma ka langi dasi rongo haitamana go tesi doo. Sulia lea so daka aada haitamana ma daka rongo haitamana, gera ka aabulo fuana a God, ma tara nia ka manata lukea na aade taꞌalaa gera gi.>> ");
INSERT INTO llu_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Sui a Jesus ka bae urii fuada, <<Gamu langi molu si haitamana go si oomelawanelaa naa? Lea so molu si haitamana go si oomelawanelaa naa, tara molu kafi haitamana utaa ana oomelawanelaa aai? ");
INSERT INTO llu_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Na wane baa na e fasi doo, nia e fasia na baelana a God. ");
INSERT INTO llu_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ma teni tooa gi na da rongoa na baelana God, da iilingia na mige doo gi na e asia i sulia na tala. Ma si kada da rongo, a Satan e lea mai, ma ka lafua laugo ana faasida. ");
INSERT INTO llu_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ma teni tooa gi lau da iilingia na mige doo gi na da asida ana si gula foulaa, ma da rongoa na baelana God ma aliꞌali da ngalia, ma daka eele asianaa. ");
INSERT INTO llu_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Sui taa, e langi dasi too ana ta lali diana doo. Nia naa da mouri go ada sulia si kada toꞌou. Ma si kada na afetaia ma na nonifiilaa e dao mai i nunufana na faarongolaa nae, daka lugasia na ada na baelana God. ");
INSERT INTO llu_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ma teni tooa gi aai da iilingia na mige doo gi na da asida i matangana na kwaletotore gi. I gera rongoa na baelana God, ");
INSERT INTO llu_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","sui taa, da manata aꞌabo ada sulia si doo gi ana mouria gera, ma daka manata baita ana na malefo, ma doo naa gi e iilingia na kwaletotore gi e nuku faafia na mige doo nae, ma langi dasi fungu go ana ta fufue doo. ");
INSERT INTO llu_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ma teni tooa gi lau da iilingia na mige doo gi na da asida i laona si gano diana. I gera rongoa si baelana God ma daka roosulia, ma daka fungu ana fufue doo gi. Teni doo ana na oolu finite doo, ma teni doo na oono finite doo, ma teni doo na tee talange doo.>> ");
INSERT INTO llu_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ma a Jesus ka bae lau urii fuada, <<E utaa? Ta wane e ngalia mai na kwesu ma ka aalua ana i farana na teu langi na iifitai? Langi go. Nia ka aalua i fulina i langi! ");
INSERT INTO llu_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Urinae tesi doo na da haufinia, tara a God ka aalua ana si gula folaa. Ma si doo na da foda faafia, tara a God ka faatainia. ");
INSERT INTO llu_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Muka manata diana sulia si doo gi na mu rongoa.>> ");
INSERT INTO llu_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ma a Jesus ka bae lau urii fuada, <<Muka manata diana sulia si doo gi na mu rongoa. A God ka keto gamu laugo iilingia si ketolaa na gamu iilia ana tooa eꞌete gi, sui ka baita lau. ");
INSERT INTO llu_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ma na wane na e too ana teni si doo gi, a God tara ka falea doo oro gi fuana. Ma na wane na e langi kasi too ana tesi doo, a God tara ka lafua lau si doo toꞌou boroi ana na i nia e too ana.>> ");
INSERT INTO llu_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","A Jesus ka bae laugo urii, <<Na Initooa a God e iilingia na wane na e fasia si mige doo gi i laona na raoa nia. ");
INSERT INTO llu_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Nia ka teo ana ana fe rodo ma ka aada ma ka liliu ana ana dani, ma sulia si kada nae na mige doo gi e bulao ana ma ka tae ana. Sui na wane nae kasi haitamana laugo ana na doo na e aadea ka tae. ");
INSERT INTO llu_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Na gano i talana naa e faataea na ai nae gi ma ka faafungu ana fufue doo gi. Na fufurungana e bango mai i nao, sui na funge doo, ma i buri na mige doo gi kafi bango mai. ");
INSERT INTO llu_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ma si kada na mige doo nae gi e moua, na wane nae ka hafalia na tabalilana na funge doo gi, sulia e dao na ana si kada ni gonidoolaa.>> ");
INSERT INTO llu_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","A Jesus e ledi lau ka urii, <<Tara si taa naa golu ka bolangainia ana na Initooa nia a God? Ma langi ta si oomelawane taa na golu ka inifitaa ana? ");
INSERT INTO llu_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Nia e urii: Tee wane e ngalia na migena mastad, na e toꞌou ka tasa ana migena ai gi sui, ma ka fasia lao gano. ");
INSERT INTO llu_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ma i buira nia e fasia sui, na migedoo baa ka tae ma ka hau ana na ai baita ka liufia na ai oro gi. Ma ka too ana na hare ai baita gi, ma na manu gi da lofo mai ma da haungainia na nui gera gi ana.>> ");
INSERT INTO llu_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","A Jesus e bae fuana na tooa gi ana si oomelawanelaa nae gi urinae, ma e haea si doo gi na e bobola fai nia daka haitamana. ");
INSERT INTO llu_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ma nia e bae fuada ana si baea oomelawane gi sui go. Sui si kada na e too ana taifili nia fai nia na oote fafurongo nia gi, nia ka faafolaalia na doo gi sui fuada. ");
INSERT INTO llu_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","I haulafia ana fe dani nae, a Jesus e bae urii fuana oote fafurongo nia gi, <<Golu lea fasi fui bali aasi aai loko.>> ");
INSERT INTO llu_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ma da tafusia na figua nae, ma daka lea fai nia a Jesus i laona na baru nae nia e gwouru i laona. Teni baru gi aai laugo da too i seenae. ");
INSERT INTO llu_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ma na ooru baita e tae mai ma na nanafo gi ka hafalia na lealaa mai i laona na baru, ma ka garangi kuruu naa. ");
INSERT INTO llu_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ma a Jesus e teo mai ana i buira na baru, ma ka bogou ana na doo ni bogoulaa. Ma na oote fafurongo nia gi da faaada nia ma daka bae urii, <<Wane baita ae, golu garangi golu ka mae naa! Osi manata aꞌabo go urii?>> ");
INSERT INTO llu_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ma a Jesus e tatae ma ka bae rigita fuana na ooru ka urii, <<Oko too aaroaro naa!>> Ma ka bae laugo fuana na nanafo gi ka urii, <<Molu ka ngado naa!>> Urinae ua go, na ooru baa ka aaroaro, ma na folaa ka asia naa. ");
INSERT INTO llu_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ma nia ka bae urii fuana oote fafurongo nia gi, <<Uria taa na molu ka mou asianaa? I gomolu molu si manata mamana ua?>> ");
INSERT INTO llu_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ma gera ka mou ma daka ledi kwailiu ani gera daka urii, <<Wane taa naa? Na ooru ma na nanafo gi boroi daka roosuli nia!>> ");
INSERT INTO llu_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","A Jesus fai nia na fafurongo nia gi, da faifolo ana na aasi i Galili, ma daka dao ana na bali aasi aai nae ana na lolofaa i Gerasa. ");
INSERT INTO llu_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ma si kada a Jesus e sifo faasia na baru, tee wane na aagalo taꞌa e adosia ka lea mai faasia na mae oba ni aalulana wane mae gi, ma ka lea mai i siana. ");
INSERT INTO llu_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Na wane nae e too i laona na kwaingeia nae gi, ma e langi ta wane so ka bobola fai nia na kanilana ana tesi oko ana seni. ");
INSERT INTO llu_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Sulia si kada oro gi, da kani na faafia na abana ma na aena ana seni, sui nia ka muusia go ana na seni nae gi ma ka magaa go ana na kakai halo nae gi i aena. Ma e langi ta wane kasi rigita bobola fai nia na ngirilanalaa. ");
INSERT INTO llu_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ma fe rodo gi ma fe hato gi, nia e too i matangana na kwaingeia gi ma i laona na tolo gi, ma nia ka rii ma ka kwai nia ana i talana ana na fou gi. ");
INSERT INTO llu_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Si kada nia e too tau ua mai, nia ka rikia a Jesus, ma ka lalao mai, ma ka boururu i nao ani nia. ");
INSERT INTO llu_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ma nia ka rii baita ka urii, <<A Jesus ae, ni oe na Wela a God na e too mai i langi. Na taa naa o doori iilia ani nau? Oko aalangai i maana a God osi falea si kwakwaelaa fuagu!>> ");
INSERT INTO llu_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","(Nia e bae urinae sulia a Jesus e bae urii fuana, <<Aagalo taꞌa ae, o haga mai i maa faasia na wane naa.>>) ");
INSERT INTO llu_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Sui a Jesus e ledia ka urii, <<Ni tei naa hatamu?>> Ma i nia e oolisia ka urii, <<Na hatagu a Oomea gi, sulia i gemelu melu oro.>> ");
INSERT INTO llu_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ma nia ka gania a Jesus hai so ka langi si oodu gera faasia na bali fera nae. ");
INSERT INTO llu_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ma tee ferae boso baita da too laugo i kamena na uuo loko, ma daka fanga go ada. ");
INSERT INTO llu_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ma na aagalo nae gi da gania a Jesus daka urii, <<O fale gemelu fuana na boso loko gi hai so melu ka ruu amelu i laoda.>> ");
INSERT INTO llu_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ma a Jesus ka faalamai gera, ma na aagalo taꞌa nae gi da haga mai, ma daka lea daka ruu i laona na boso nae gi. Na ferae boso nae e bobola fai nia na roo tooni boso, ma da lalao i oobina fou naa, ma daka asia fui laona na aasi nae, ma daka lola teefou. ");
INSERT INTO llu_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Haia, wane nae gi na da aadasulia na boso nae gi, daka tafi, ma daka faarongo ana si doo nae i fera nae ma na fera toꞌou galigalia gi. Ma na tooa gi daka lea uria na rikilana si doo na e fuli. ");
INSERT INTO llu_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ma ana si kada da dao siana a Jesus, daka rikia na wane baa na aagalo taꞌa oro gi da adosia e gwouru go ana seenae, ma nia ka oofi naa ma ka manata oꞌolo naa. Ma na tooa gi daka mou asianaa. ");
INSERT INTO llu_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ma na tooa gi na da rikia si doo nae e fuli, da uunuunu sulia i siada na tooa gi, ma da uunuunu laugo sulia na boso nae gi. ");
INSERT INTO llu_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ma i buri, na tooa nae gi daka gania a Jesus eeri ka lea faasia na bali fera gera. ");
INSERT INTO llu_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ma si kada a Jesus e tae laona na baru, na wane baa na aagalo taꞌa gi da adosia i nao, nia ka gania uria na lealaa fai nia. ");
INSERT INTO llu_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","A Jesus ka langi si faalamainia, ma ka bae urii fuana, <<O ooli i fera siana na tooa oe gi, ma oko faarongo gera ana si doo gi sui na Lord e aadea fuamu ma na kwaimanataia nia fuamu.>> ");
INSERT INTO llu_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ma na wane nae e lea, ma ka faarongoa na tooa gi ana lolofaa i Dekapolis ana si doo gi sui na a Jesus e iilia fuana. Ma na tooa gi sui daka kwele asianaa. ");
INSERT INTO llu_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","A Jesus e faafolo lau kou uria ta bali aasi, ma ana si kada nia ka dao ana, na tooa oro gi daka figu gali nia. ");
INSERT INTO llu_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ma tee wane ada na wane olosi doo gi i laona na Beu Aabu ni figulaa i fera loko, hatana a Jaeras, ka lea mai. Ma si kada e rikia a Jesus, nia ka boururu i maana aena, ");
INSERT INTO llu_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ma e gania ka urii, <<Na gala haari nau e garangi mae naa. O lea mai, ma oko aalua mone amu na abamu i fafona hai so ni nia ka akwaa ma ka mouri.>> ");
INSERT INTO llu_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ma a Jesus ka lea naa fai nia. Ma na figua baita da lea i buira ma daka kwaiberesi gali nia. ");
INSERT INTO llu_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ma tee inite aai e nia laugo i seenae na abu sura e haungia sulia tee aakwala ma roo fe ngali sui naa. ");
INSERT INTO llu_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ni nia ka nonifii asianaa, ma boroi ana nia ka nagaa na malefo nia gi sui fuana na wane ni kwaiguralaa oro gi, na toolana kasi diana go. E taꞌa taari ka tasa asianaa. ");
INSERT INTO llu_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ma si kada ni nia e rongoa na uunuunua sulia a Jesus, ni nia ka lea mai i buira i matangana na figua nae, ma ka hamosia na maku ruruu nia a Jesus. ");
INSERT INTO llu_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Sulia nia e manata urii, <<Lea so kuka hamosia mone agu na maku nia, nau kuka diana naa.>> ");
INSERT INTO llu_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ma si kada nia e hamosia na maku nia, aliꞌali na abu na e tafangi nia ka sui naa, ma nia ka madafia i laona na nonina hasa ni nia e nonilaa naa faasia na mataia nia. ");
INSERT INTO llu_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ma ana si kada nae ua go, a Jesus e haitamana na mamanaa nia e gura ta iimola. Ma i nia ka aabulo i matangana na figua nae, ma ka ledida ka urii, <<Ni tei naa e hamosia kou na maku nau?>> ");
INSERT INTO llu_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ma na oote fafurongo nia gi da oolisia daka urii, <<I oe o rikia go amu na tooa oro naa gi da figu kwaiberesi gali oe. Uria taa na oko ledi uria ni tei naa e hamosi oe?>> ");
INSERT INTO llu_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Sui a Jesus e aada go ana gali nia hai so ka rikia ni tei nae e iilia si doo nae. ");
INSERT INTO llu_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Haia, na inite nae e haitamana si doo nae e fuli fuana, ma nia ka lea mai ma ka lelebe ana moulaa, ma ka boururu i maana aena a Jesus. Ma ni nia ka faarongoa ana doo mamana gi sui suli nia. ");
INSERT INTO llu_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ma a Jesus ka bae urii fuana, <<Inite ae, God e gura oe sulia na oe manata mamana ani nau. O lea naa, ma osi manata aꞌabo, ma oko nonilaa naa faasia na mataia oe.>> ");
INSERT INTO llu_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ma si kada a Jesus e bae ua go ana, teni wane gi da dao mai faasia na luma a Jaeras, ma daka bae urii fuana a Jaeras, <<Na haari oe baa e mae naa. Osi faaꞌaberosia lau na wane faatolomai doo naa.>> ");
INSERT INTO llu_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Haia, a Jesus kasi fafurongo go uria si doo na da haea, ma ka bae na ana urii fuana a Jaeras, <<Langi osi mou lau. Oko manata mamana amu.>> ");
INSERT INTO llu_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ma i nia kasi faalamainia ta wane ka lea fai nia, taifilia go a Peter, ma a James, ma a John na haasina a James. ");
INSERT INTO llu_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ma si kada da dao i luma nia a Jaeras, a Jesus ka rongoa na ngalulaa fai nia na aangilaa ma na suungimaelaa e baita. ");
INSERT INTO llu_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ma nia ka ruu kou, ma ka bae urii fuada, <<Uria taa na molu aangi ma muka suungimae? Na wela naa langi nia kasi mae, ni nia e teo go ana.>> ");
INSERT INTO llu_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Sui, gera daka waela ada ana a Jesus. Ma i nia e eeresi gera i maa, ma ka talaia na maa nia ma ni tee nia na wela nae, ma na oote fafurongo nia gi na da too fai nia, ma daalu ruu ana bali luma na wela nae e too ana. ");
INSERT INTO llu_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ma nia ka dau ana na abana na wela nae, ma ka bae urii fuana, <<Talita kom!>> Na malutana e urii, <<Gala haari ae, i nau ku haea fuamu o tatae!>> ");
INSERT INTO llu_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ma ni nia ka tatae, ma ka take, ma ka fali. Na wela nae tee aakwala ma roo fe ngali ana go na e sui naa. Ma ni gera daka kwele asianaa ana si doo naa. ");
INSERT INTO llu_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Sui a Jesus ka bae luida eeri ka langi dasi faarongolana ta wane lau ana si doo nae. Ma ka haea gera ka falea tesi fanga fuana na wela baa hai ka ania. ");
INSERT INTO llu_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","A Jesus fai nia na oote fafurongo nia gi, da tafusia na gula nae ma daka ooli uria fera nia. ");
INSERT INTO llu_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ma ana maedani ana Sabat, nia ka faatolomai i laona na Beu Aabu ni figulaa. Ma tooa oro gi da rongo nia, ma daka kwele asianaa. Ma gera ledida kwailiu ani gera daka urii, <<Na wane naa e ngalia mai ana si doo naa gi i fai? Ma na liotooa taa na da falea fuana naa? Ma nia e iili utaa ana si doo ni kwelelaa ana gi nae? ");
INSERT INTO llu_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Nia na wane ni toleluma go ana, na alakwa baa ni Mary naa, ne baa? Ma na haasina gi na a James, ma a Josef, ma a Judas, ma a Simon, ne baa? Ma na waiwane nia gi da too go ada i seenaa.>> Ma daka oote gera ani nia. ");
INSERT INTO llu_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ma a Jesus ka bae urii fuada, <<Na tooa gi ana fera gi sui da haitamana daka faabaitaa na profet. Haia, ma na tooa gi ana fera nia i talana ma na tooa futa nia gi afetai daka faabaita nia.>> ");
INSERT INTO llu_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ma nia kasi bobola naa fai nia na iililana lau si doo kwaibalatana go oro ana i seenae. I nia e aalua go ana na abana faafia ta aange tooa matai gi ma ka gura gera. ");
INSERT INTO llu_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ma nia ka kwele asianaa sulia na tooa gi da langi dasi manata mamana. Sui a Jesus e lea ana maefera gi galigalia i seenae, ma ka faatolomai ana na tooa gi. ");
INSERT INTO llu_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Nia ka soea mai na aakwala ma roo wane ni fafurongo nia gi siana, ma i nia ka falea na mamanaa fuada uria tarilana na aagalo taꞌa gi, ma ka ooduda teefou, na roo wane gi daaro ka lea oofu. ");
INSERT INTO llu_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ma a Jesus ka bae fifii fuada ka urii, <<E langi molu si ngalia ta si doo uria na leaa naa, taifilia kubou go na molu ngalia. Ma langi molu si ngalia tesi fanga, ma langi ta wai, ma langi tesi malefo. ");
INSERT INTO llu_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Molu ka haingia na tae silipa, sui ka langi molu si ngalia roo si maku ruruu. ");
INSERT INTO llu_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ma si kada ta wane e gonitai gamu, molu ka too fai nia lea ka dao ana si kada molu tafusia na fera nae. ");
INSERT INTO llu_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ma lea molu dao ana na fera ma na tooa gi i seenae langi dasi gonitai gamu ma ka langi dasi dooria go fafurongolaa molu, molu ka lea amolu faasida. Ma molu ka kwae tafusia na aafuafui gano faasia na tae silipa molu gi uria na faatailana naa fuada tara a God ka keto gera.>> ");
INSERT INTO llu_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ma ni gera da lea ma da funao hai so na tooa gi daka oolitai manata faasia na aade taꞌalaa gera gi. ");
INSERT INTO llu_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ma daka taria na aagalo taꞌa oro gi, ma daka gwaia na tooa matai oro ma daka gura gera laugo. ");
INSERT INTO llu_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Haia, a Herod na aaofia e rongoa si doo naa gi, sulia na hatana a Jesus e talofia na fera gi sui. Ma teni tooa gi daka haea, <<A John Siuabu e mouri lau! Nia naa i nia ka aadea doo kwaibalatana gi.>> ");
INSERT INTO llu_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ma teni tooa gi lau daka haea, <<I nia a Elaeja.>> Ma teni tooa aai gi daka bae urii, <<I nia ta profet, iilingia na profet baa gi i nao mai.>> ");
INSERT INTO llu_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ma si kada a Herod e rongoa si doo naa gi, nia ka bae urii, <<A John na wane baa ku oodua wane oomea gi uria iri muusilana na ketena, e tatae lau faasia na maea.>> ");
INSERT INTO llu_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Sulia a Herod i talana na e kwaiodui sui uria na dumulilana a John, ma daka aalua i laona na beu ni kanilaa. A Herod e iilia si doo naa sulia nia ka aadea ana ni Herodias, na afe nia a Filip na haasina. ");
INSERT INTO llu_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","A Herod e aalua a John i laona na beu ni kanilaa, sulia nia e bae urii fuana a Herod, <<Na kwaieresia e luia osi aadea na afe nia na haasimu.>> ");
INSERT INTO llu_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ma si lio taꞌa ni Herodias ka asia asianaa fuana a John, ma ka dooria na haumaelilana, sui ma ka afetai fuana, ");
INSERT INTO llu_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","sulia a Herod ka suusi nia, sulia nia e moungia a John, sulia nia ka haitamana nia na wane oꞌolo ma na wane e aabu. Haia, a Herod e dooria asianaa na rongolana a John, boroi ana i nia ka manata aꞌabo ana si kada gi na e rongoa ana. ");
INSERT INTO llu_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Sui ni Herodias e daotoona si kada diana nia. Ana fe dani na a Herod e faabaita fe dani na e futa ana, i nia e haungainia tee fangaa fuada na wane baita nia gi, ma na wane baita nia gi ana oomea, ma na wane naonao gi na da too i laona i lolofaa Galili. ");
INSERT INTO llu_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ma si kada na haari nia ni Herodias e ruu mai ma ka wae, a Herod ma na wane nia gi na da fanga fai nia daka eele baita asianaa sulia. Ma a Herod ka bae urii fuana na haari nae, <<O gani nau mai uria tesi doo na o dooria, ma nau kuka falea fuamu.>> ");
INSERT INTO llu_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ma i nia e bae aalangai ana aalafuu fuana ka urii, <<Tesi taa naa o gani uria, nau kuka falea fuamu. Boroi ana ta bali ana na initooa nau.>> ");
INSERT INTO llu_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ma na haari ka haga kou i maa ka lea naa siana ni tee nia, ka bae urii, <<Tesi taa naa tara ku gani uria?>> Ma ni tee nia e oolisia ka urii, <<Na ketena a John Siuabu.>> ");
INSERT INTO llu_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ma na haari nae e ooli aliꞌali siana a Herod, ma ka gania ka urii, <<I nau ku dooria oko falea mai na ketena a John Siuabu fuagu i fafona ta karao ana si kada naa.>> ");
INSERT INTO llu_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ma a Herod ka liobukonu asianaa sulia si doo nae. Sui taa, sulia si bae aalangaia na nia e iilia i maada na wane gi na da fanga fai nia, i nia kasi luia naa faasia. ");
INSERT INTO llu_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ma nia ka oodua tee wane fofolo uria ngalilana mai na ketena a John. Ma na wane nae ka lea i laona na beu ni kanilaa, ma ka iri muusia na luana a John, ");
INSERT INTO llu_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ma ka ngalia mai na ketena i fafona na karao, ma ka falea fuana na haari nae, ma ni nia ka falea fuana ni tee nia. ");
INSERT INTO llu_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ma si kada na oote fafurongo nia gi a John da rongoa si doo naa, gera lea mai ma daka ngalia na nonina ma daka aalua i laona na kwaingeia. ");
INSERT INTO llu_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Na aposol gi da ooli mai, ma daka figu siana a Jesus, ma daka faarongo nia ana si doo gi na da iilida ma daka faatolomainia gi. ");
INSERT INTO llu_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jesus fai nia na oote fafurongo nia gi, gera abero asianaa, sulia na tooa oro gi da dao mai ma daka ooli kou ada. Ma Jesus fai nia na oote fafurongo nia gi, gera langi dasi too na ana ta si kada boroi uria na fangalaa. Nia naa, a Jesus ka bae urii fuada, <<Molu lea mai fai nau uria tesi gula aaroaro eeri golu ka mamalo fasi agolu.>> ");
INSERT INTO llu_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ma da lea taifili gera ana baru uria tesi gula aaroaro. ");
INSERT INTO llu_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Sui, na tooa oro gi faasia na fera gi sui da aada haitamada, ma daka lalao i nao ani gera, ma daka dao ada i seenae. ");
INSERT INTO llu_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ma si kada a Jesus e oolo mai ana, nia ka rikia na figua baita, ma ka kwaimanatai asianaa fuada, sulia gera da iilingia na sipsip gi na e langi ada ta wane aadasuli gera. Ma nia ka faatolomai gera ana si doo oro gi. ");
INSERT INTO llu_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ma si kada na hato e teo folo naa, na oote fafurongo nia gi daka lea mai siana, ma daka bae urii, <<Si gula naa e langi ta wane kasi too ana, ma na hato ka teo folo naa. ");
INSERT INTO llu_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","O oodua na tooa naa gi daka lea na ada, eeri daka lea ana si gula galigali naa gi na tooa gi da too ana ma ana na fera gi, eeri daka folia ada tesi fanga.>> ");
INSERT INTO llu_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Sui i nia e oolisida ka urii, <<I gomolu molu falea tesi fanga ada.>> Ma i gera daka bae urii fuana, <<E utaa ni oe o dooria melu ka lea, melu ka falea mai ta roo talange si malefo uria folilana mai teni beredi oro ka bobola fai nia hangoniladalaa ana?>> ");
INSERT INTO llu_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ma a Jesus ka ledi gera ka bae urii, <<Fita fe beredi na molu too ana? Lea molu ka aada fasi.>> Ma si kada da daotoona, daka bae urii, <<Lima fe beredi go fai nia na roo gwe iia.>> ");
INSERT INTO llu_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Sui a Jesus ka haea fuana oote fafurongo nia gi hai daka haea fuada na tooa gi daka gwouru i hae gano ana bubulutaa wane gi i fafona na laua. ");
INSERT INTO llu_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ma gera ka gwouru i hae gano ana talange wane gi i laona teni bubulutaa ma lima aakwala wane gi i laona teni bubulutaa aai. ");
INSERT INTO llu_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ma Jesus e ngalia na lima fe beredi nae gi ma na roo gwe iia nae gi, ma ka aada alaa uria i langi, ma ka baelafea a God. Ma nia e niia fe beredi nae gi, ma ka falea fuada na oote fafurongo nia gi, hai daka tolingia fuada na tooa gi. Ma nia ka tolingia laugo na roo gwe iia nae gi fuada sui. ");
INSERT INTO llu_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ma na tooa gi sui daka fanga, ma daka aabusu naa. ");
INSERT INTO llu_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Sui na oote fafurongo nia gi daka gonia na oorongana na beredi ma na iia na e oore, ma daka faafungua na tee aakwala ma roo koko gi. ");
INSERT INTO llu_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Na lima tooni wane na da fanga. ");
INSERT INTO llu_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ma i buira si doo naa, a Jesus e faataea na oote fafurongo nia gi i laona na baru, ma daka lea i nao ani nia uria na fera i Betsaeda, na e too mai ana ta bali aai ana na aasi nae. Ma i nia ka too ua kou hai so ka haea fuana na figua nae hai daka lea na ada. ");
INSERT INTO llu_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ma i buira i nia e aalualu ana tooa gi sui, nia ka lea uria tee fe uuo hai ka fooa ana. ");
INSERT INTO llu_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ma si kada e hafali rodo mai, na baru baa e nia naa i oogotouna na aasi, ma a Jesus e too ua go ana taifili nia i hara. ");
INSERT INTO llu_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ma i nia e rikia na oote fafurongo nia gi da uulafu asianaa ana na falutalaa, sulia da naofia na ooru. Ma ana kade rodo i ofaidani, a Jesus ka fali i fafona na kafo, ma ka lea mai siada. Ma nia ka garangi so ka tasa ana faasida. ");
INSERT INTO llu_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Sui, ana si kada da riki nia e fali i fafona na kafo, i gera da manata hasa nia na aagalo. Ma daka rii, ");
INSERT INTO llu_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","sulia gera sui go da mou asianaa ana si kada da riki nia ka fali i fafona kafo. Ma a Jesus e aliꞌali ka bae kou fuada ka urii, <<I nau go ana naa! Langi molu kasi mou.>> ");
INSERT INTO llu_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Sui nia ka tae i laona na baru fai gera, ma na ooru ka aaroaro naa. Ma ni gera daka kwele asianaa, ");
INSERT INTO llu_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","sulia e langi dasi haitamana na malutana na hangonilada na lima tooni wane baa gi ana lima fe beredi go. Sulia na manata gera gi e kukuru asianaa. ");
INSERT INTO llu_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","I gera da faifolo ana na aasi nae ma daka oolo ana bali maefera i Genesaret, ma gera ka terengainia na baru i seenae. ");
INSERT INTO llu_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ma si kada da tafusia na baru, na tooa nae gi aliꞌali daka aada haitamana ua go a Jesus. ");
INSERT INTO llu_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ma na tooa gi da lalao i bali fera loulou nae, ma daka ngalia mai na tooa matai gi i fafona na tafe gi, uria si gula taa na da rongoa a Jesus e nia ana. ");
INSERT INTO llu_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ma si gula gi sui na a Jesus e lea ana, na tooa gi daka ngalia mai na tooa matai gi uria i maana usia gi, ma da gania a Jesus fuana na tooa matai gi daka hamosia mone ada na aena maku tekwa nia. Ma na tooa gi sui na da hamosia, da akwaa naa. ");
INSERT INTO llu_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Teni Farisi gi ma teni wane faatolomai gi ana na kwaieresia, da lea mai faasia i Jerusalem, ma daka figu galia a Jesus. ");
INSERT INTO llu_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ma gera ka rikia teni wane ada na oote fafurongo nia gi dasi saufia go na abada suifetei fangalaa iilingia na malutaa gera na Farisi gi na da haea hai so na tooa gi Jiu daka iilia. ");
INSERT INTO llu_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Sulia na Farisi gi, ma na tooa aai gi i Jiu gi laugo, e afetai daka fanga lea so e langi dasi saufia na abada eeri ka iilingia na koo gera gi da toolamainia na mai. ");
INSERT INTO llu_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ma si kada da folia mai na fanga gi faasia na usia, e afetai daka fanga ua lea langi dasi saufia fasi, sulia na malutaa gera. Ma daka lea sulia na malutaa oro gera gi iilingia na saufilana na teteu gi ma na kuki gi ma na fofo gi.) ");
INSERT INTO llu_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ma na Farisi gi ma na wane faatolomai gi ana na kwaieresia, daka ledia a Jesus daka urii, <<Uria taa naa na oote fafurongo oe gi dasi roosulia na faatolomaia naa na koo gia gi da aalua mai fuaga, sulia ka langi dasi saufia go na abada i nao sui dafi fanga?>> ");
INSERT INTO llu_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ma nia e oolisida ka urii, <<A Aesea e bae mamana si kada baa i nia e bae suli gamu. I gamu naa na wane susuge gi, iilingia na nia e kedea ka urii, <God e haea, na tooa naa gi da faabaita nau go ada ana si baea gera gi, ma na manatada e nia tau faasi nau. ");
INSERT INTO llu_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Gera da fooasi nau oꞌoni go ada, sulia i gera da toolamainia ada na kwaieresia gera gi go ana, ma daka haea kwaieresia nau gi!> ");
INSERT INTO llu_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","<<Gamu mu aaburongo agamu na kwaieresia nia gi a God, ma muka roosulia agamu na faatolomaia gera gi na wane gi.>> ");
INSERT INTO llu_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ma a Jesus ka bae lau urii fuada, <<I gamu mu haitamana asianaa na bulasilana na kwaieresia a God gi ma muka roosulia agamu na malutaa gamu gi. ");
INSERT INTO llu_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Sulia a Moses e bae ka urii, <Oko manata baita ana na maa oe ma ana ni tee oe.> Ma <So ni tei na e kwalangia na maa nia ma langi ni tee nia, gera ka haumaelia.> ");
INSERT INTO llu_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Sui taa, i gamu mu faatolomainia hasa lea ta wane e too ana tesi doo na e haitamana ka adomia ana maa nia ma langi ni tee nia, ma ka bae urii, <Nau tara ku falea si doo naa fuana a God,> ");
INSERT INTO llu_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","diana go ana fuana nia ka langi si adomia naa na maa nia ma langi ni tee nia. ");
INSERT INTO llu_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ma urinae, na faatolomaia na gamu aalua e faalangia na baelana a God. Ma si doo oro urinae gi naa na mu iilida.>> ");
INSERT INTO llu_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Sui a Jesus e soea lau mai na figua siana, ma ka bae urii fuada, <<Gamu sui go, mu fafurongo mai uri nau, ma muka haitamana. ");
INSERT INTO llu_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","E langi tesi doo na ta wane e ania, na e falea na garolaa fuana. Ma si doo ana aade taꞌalaa gi na e ita mai faasia na liona wane taari, nia ana na ka falea na garolaa fuana.>> ");
INSERT INTO llu_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ma si kada a Jesus e tafusia na figua nae, nia ka ruu i luma, ma na oote fafurongo nia gi da ledia eeri nia ka inifitaa si baea nae gi. ");
INSERT INTO llu_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ma a Jesus ka bae urii fuada, <<Haia, i gomolu laugo molu kasi haitamana go? Tesi doo na wane e ania e afetai ka falea na garolaa fuana, ");
INSERT INTO llu_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","sulia si fangaa e langi kasi lea i laona na liona. E lea ana i laona na rakena, ma ka hagatafa laugo ana i maa faasia na nonina.>> Ana si baea nia a Jesus naa, nia e haea na fanga gi sui e diana fuana anilana. ");
INSERT INTO llu_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ma a Jesus ka bae lau urii, <<Si doo na ta wane e iilia ma ka haea na e falea na garolaa fuana. ");
INSERT INTO llu_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Sulia na manatalaa taꞌa gi e mango mai faasia i laona na liona na wane, na e aadea nia ka aadea si doo taꞌa gi, ma nia ka beli, ma nia ka haumaelia ta wane, ");
INSERT INTO llu_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ma ka ooeoe, ma nia ka agu doo, ma nia ka iilia doo taꞌa oro gi, ma ka malaꞌoea na tooa gi, ma ka kwaifii, ma ka uunuunu susuge ana taꞌa sulia ta wane, ma nia ka faabaitabaita nia i talana, ma nia ka nue. ");
INSERT INTO llu_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Haia, na doo taꞌalaa nae gi sui e haga mai faasia na manatalana, ma ka falea na garolaa fuana.>> ");
INSERT INTO llu_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Sui a Jesus e tafusia si gula nae ma ka lea uria na bali fera i Taea. Ma nia e ruu ana i laona tee luma sulia i nia langi kasi dooria ta wane ka haitamana i nia e too i seenae, sui taa e afetai i nia ka aagwa. ");
INSERT INTO llu_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ma tee geni na haari nia na aagalo taꞌa e adosia e rongoa na uunuunu gi suli nia, ma ka lea mai aliꞌali, ma ka boururu i maana na aena a Jesus. ");
INSERT INTO llu_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ma na geni nae, i nia na geni maadiu faasia i Fonisia laona lolofaa i Siria. Ma ni nia e gania a Jesus eeri ka taria na aagalo taꞌa nae faasia na haari nia. ");
INSERT INTO llu_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ma a Jesus ka bae ana si oomelawanea naa fuana ka urii, <<Mika hangonia fasi agami na wela gi i nao. E langi kasi diana hasa gia ka ui ania na fanga gera na wela gi fuana na kui gi.>> ");
INSERT INTO llu_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ma na geni nae e oolisia ka urii, <<Aarai ae, na kui gi boroi da haitamana daka ania oorongana fanga na e asia i farana na tafe gera na wela gi.>> ");
INSERT INTO llu_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Sui a Jesus ka bae urii fuana, <<Sulia si oolisilaa nae, oko ooli amu i fera oe. Na aagalo taꞌa baa e lea naa faasia na haari oe.>> ");
INSERT INTO llu_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ma ni nia e ooli i fera, ma ka rikia na haari nia e teo go ana i laona na iifitai. Ma na aagalo taꞌa baa ka lea mamana naa faasia. ");
INSERT INTO llu_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Sui a Jesus e tafusia na bali fera nae i Taea ma ka tasa fuana fera i Saedon ma na bali fera i Dekapolis, ma ka sifo kou fuana na aasi i Galili. ");
INSERT INTO llu_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ma teni tooa gi i seenae da ngalia mai tee wane na aalingana e boko ma na fakana ka ato siana Jesus, ma daka gania a Jesus eeri nia ka aalua na abana i fafona na wane nae. ");
INSERT INTO llu_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ma a Jesus ka talaia uria si gula taifili nia faasia na figua, ma nia ka ruungainia na kakauna abana gi i laona na aalingana na wane nae. Ma nia ka ngisu ana na kakauna, ma ka hamosia na meana na wane nae. ");
INSERT INTO llu_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Sui nia ka ada alaa fui langi ma e asimango baita ka bae urii fuana, <<Efata!>> Ma na malutana <<O ifi naa!>> ");
INSERT INTO llu_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ma ana si kada nae, na aalingana na wane nae ka ifi naa ma na fakana ka aafaafa naa, ma ka hafalia bae folaalaa naa. ");
INSERT INTO llu_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Sui a Jesus ka luia na tooa gi langi dasi faarongoa lau ana ta wane lau. Sui taa, i nia e luida fifii boroi ana, ma na tooa gi daka bae sulia ka lea dongaa na ana. ");
INSERT INTO llu_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ma na tooa gi na da rongoa, daka kwele asianaa ma daka bae urii, <<Nia e iilia si doo gi sui ka diana asianaa! Nia e haungainia na wane na aalingana e boko boroi ka rongo naa, ma na wane na fakana e ato boroi ka bae naa lau.>> ");
INSERT INTO llu_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Langi si tau i buira doo naa gi, tee figua baita aai ka figu mai. Ma si kada e langi na ada tesi fanga, a Jesus ka soea na oote fafurongo nia gi i siana ma ka bae urii, ");
INSERT INTO llu_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","<<Nau ku kwaimanatai naa fuana na tooa naa gi, sulia da too siagu sulia oolu maedani ma ka langi na ada tesi fanga. ");
INSERT INTO llu_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ma lea so da fiolo ma kuka faaoli gera i fera, gera tara daka asi gera sulia tala, sulia bali ada na fera gera gi e too tau.>> ");
INSERT INTO llu_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ma na oote fafurongo nia gi daka bae urii, <<Sui taa, tara ta wane ka daotoona tesi fanga i fai i laona na aanogwou urinae hai ka bobola fai nia na hangonilana na tooa oro naa urii gi?>> ");
INSERT INTO llu_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ma a Jesus e ledida ka urii, <<Ta fita fe beredi na molu too ana?>> Ma gera ka oolisia daka urii, <<Fiu fe beredi.>> ");
INSERT INTO llu_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ma a Jesus ka haea fuana na figua nae daka gwouru i aano. Sui, nia ka ngalia na fiu fe beredi nae gi ma ka baelafea a God, sui ka niia ma ka falea fuana oote fafurongo nia gi, hai daka tolingia fuana na tooa gi. ");
INSERT INTO llu_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ma gera too laugo ana aange gwe iia toꞌou gi. Ma a Jesus e falea laugo si baelafea fuana a God, ma ka haea fuana na oote fafurongo nia gi daka tolingia laugo fuana na tooa nae gi. ");
INSERT INTO llu_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Gera fanga lea daka aabusu go. Ma i buri, na oote fafurongo nia gi sui daka gonia na mumuduna fanga gi na e oore i laona fiu koko gi lea ka fungu. ");
INSERT INTO llu_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ma na figua nae e bobola fai nia na fai tooni wane. Sui a Jesus ka faaoli gera, ");
INSERT INTO llu_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ma nia fai nia na oote fafurongo nia gi gera aliꞌali daka tae i laona tee baru ma daka lea uria na bali fera i Dalmanuta. ");
INSERT INTO llu_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ma teni Farisi gi da lea mai, ma daka oolisusuu fai nia a Jesus, ma da dooria hai daka iilitoona. Nia naa daka gania hai so i nia ka iilia tesi doo ni kwaibalatana ana hai so ka faatainia mamana a God na e fale nia mai. ");
INSERT INTO llu_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Sui a Jesus e asimango baita, ma ka bae urii, <<Uria taa na tooa gi ana uuni wane naa daka gani uria tesi kwaibalatana? I nau ku haea na doo mamana fuagamu, e langi kusi faatainia go fuana na uuni wane naa.>> ");
INSERT INTO llu_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ma nia e tafusi gera, ma ka tae laugo ana i laona na baru, ma ka faifolo uria ta bali aasi aai. ");
INSERT INTO llu_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Na oote fafurongo nia gi da manata buro uria na ngalilana mai teni fe beredi gi, ma tee fe beredi go na da too ana i laona na baru. ");
INSERT INTO llu_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ma a Jesus e bae fifii fuada ka urii, <<Molu ka aadasuli gamu faasia na iisi fuana beredi gera na Farisi gi ma a Herod.>> ");
INSERT INTO llu_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ma gera ka bae sulia si doo naa i matangada kwailiu ma daka urii, <<I nia e bae urinae sulia langi golu si ngalia mai tee fe beredi.>> ");
INSERT INTO llu_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ma si kada a Jesus e haitamana gera da lafusia ada nia e bae ana sulia na faatolomaia taꞌa gera na Farisi gi ma a Herod, nia ka bae urii, <<Uria taa na molu ka bae sulia e langi molu si ngalia mai tee fe beredi? E langi molu si haitamana ua? Na liogamu e rorodoa ua? ");
INSERT INTO llu_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","E utaa? I gomolu too ana maa, sui ka langi molu si rikia go? Ma molu ka too ana aalinga, sui ka langi molu si rongoa go? E utaa? E langi molu si manatatoona go, ");
INSERT INTO llu_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","si kada baa ku niia ana lima fe beredi baa gi fuada na lima tooni wane baa gi? Ma na fita koko baa molu gonia na mumuduna fanga baa uria i laona lea ka fungu?>> Ma gera oolisia daka urii, <<Na tee aakwala ma roo doo.>> ");
INSERT INTO llu_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ma a Jesus e ledi lau ka urii, <<Ma si kada baa ku niia ana fiu fe beredi baa gi fuada na fai tooni wane baa gi, na fita koko baa molu gonia na mumuduna fanga uria i laona lea ka fungu?>> Ma gera oolisia daka urii, <<Na fiu doo.>> ");
INSERT INTO llu_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ma nia ka bae urii fuada, <<E utaa? E langi molu si haitamana ua nae?>> ");
INSERT INTO llu_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","I gera da dao ana na fera i Betsaeda, ma teni tooa gi daka ngali mai tee wane na maana e rodo ma da gafea a Jesus hai ka hamosia. ");
INSERT INTO llu_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ma i nia e dau i abana na wane nae, ma ka talaia uria i maa faasia na fera nae. Ma a Jesus e ngisu usia na maana na wane nae, ma nia ka aalua na abana faafi nia. Sui, nia e ledia ka urii, <<I oe o rikia ta si doo?>> ");
INSERT INTO llu_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ma na wane baa e aada alaa ma ka bae urii, <<I nau ku rikia na tooa gi, da iilingia na ai gi da fali.>> ");
INSERT INTO llu_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Sui a Jesus ka aalua lau na abana faafia na maana na wane nae. Ma na wane nae ka aada mamana, ma ka riki folaa na ana na doo gi sui. ");
INSERT INTO llu_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ma a Jesus ka oodu nia naa uria na luma nia, ma ka bae urii fuana, <<E langi osi lea ua uria fera nae.>> ");
INSERT INTO llu_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Sui a Jesus ma na oote fafurongo nia gi daka lea uria na fera gi galia na fera i Sesarea Filipae. Ma ana si kada gera fali ana, nia ka ledia na oote fafurongo nia gi ka urii, <<Na tooa gi da haea ni nau ni tei naa?>> ");
INSERT INTO llu_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ma gera oolisia daka urii, <<Teni tooa gi da haea ada ni oe naa a John Siuabu, ma teni tooa aai gi da haea ada oe a Elaeja, ma teni tooa aai gi lau daka haea ada oe ta wane ada na profet gi.>> ");
INSERT INTO llu_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ma a Jesus e ledida lau ka urii, <<Ma gamu mone, ni tei na molu haea ana ni nau?>> Ma a Peter e oolisia ka urii, <<I oe a Christ, na wane a God e filia uria aaofialaa.>> ");
INSERT INTO llu_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ma a Jesus e bae fifii fuada ka urii, <<E langi molu si faarongo lau ta wane suli nau.>> ");
INSERT INTO llu_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Sui a Jesus ka talaꞌae faatolomainia na oote fafurongo nia gi ka urii, <<Nau, na Wela nia Iimola gi, tara ku nonifii ana si doo oro gi. Ma na wane naonao gi, ma na fataabu baita gi, ma na wane faatolomai doo gi ana na kwaieresia, tara daka oote gera ani nau. Ma tara daka haumaeli nau, ma ana ooula fe dani, nau tara kuka mouri lau.>> ");
INSERT INTO llu_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ma nia ka bae folaa sulia si doo nae. Ma a Peter e talai nia toꞌou kou, ma ka ngatafia. ");
INSERT INTO llu_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Sui a Jesus e aabulo ma ka aada fuana oote fafurongo nia gi, ma ka ngatafia a Peter ka urii, <<Satan ae, o lea tau fasi nau. Na manatalaa oe naa na manatalaa gera na tooa gi go ana, e langi lau na manatalaa nia a God.>> ");
INSERT INTO llu_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Sui a Jesus ka soea mai na figua nae ma na oote fafurongo nia gi siana, ma ka bae urii, <<Lea so ta wane ka dooria ka lea mai fai nau, i nia langi kasi hasi uria na kwaidooria nia i talana. Ma nia ka ngalia na airarafolo nia ana nonifiilaa, ma ka lea mai i suli nau. ");
INSERT INTO llu_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Sulia so ni tei na e dooria ka oogani ana na mourilana, tara nia ka mae. Ma so ni tei naa ka mae fuagu ma fuana na Faarongolaa Diana, i nia ka too ana mouria firi. ");
INSERT INTO llu_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Tesi taa diana fuana ta wane lea so na molaagali naa sui na doo nia, sui kafi mae naa? Langi si diana fuana! ");
INSERT INTO llu_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Langi tesi doo na ta wane ka falea uria na oolifailana ana na mouria nia. ");
INSERT INTO llu_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ma lea so ta wane e ida ani nau ma na baelagu i laona na uuni dani taꞌa gi ana tooa naa gi e langi dasi fooasia a God, tara nau, na Wela nia Iimola gi, kuka ida laugo ani nia ana si kada i nau ku dao mai i laona na taloa na Maa nau fai nia na ensel aabu gi.>> ");
INSERT INTO llu_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ma a Jesus ka bae lau ka urii, <<I nau ku haea naa fuagamu, teni wane amolu i seenaa e langi dasi mae lea daka rikia na Initooa nia a God ka dao mai ana na rigitaa.>> ");
INSERT INTO llu_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","I buira oonona maedani, a Jesus ka talaia a Peter ma a James ma a John, ma daalu tae uria gwouna tee fe tolo na e fane, si gula gera ka too ana taifili gera. Ma ana si kada da aadasia, a Jesus ka tatala i nao ani gera i seenae, ");
INSERT INTO llu_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ma na maku nia gi ka sinasina ka kwakwaoa asianaa, ma e langi kasi bobola naa hai so ta wane i laona molaagali ka saufia na maku gi ka urinae. ");
INSERT INTO llu_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ma na oolu fafurongo nae gi da rikia a Elaeja ma a Moses daaro ka dao faatai i nao ani gera ma daaro ka bae fai nia a Jesus. ");
INSERT INTO llu_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ma a Peter ka bae urii fuana a Jesus, <<Aarai ae, e diana asianaa golu ka too agolu i seenaa. I gemelu ka tolea ta oolu babala gi, tee doo fuamu, ma tee doo fuana a Moses, ma ta tee doo aai fuana a Elaeja.>> ");
INSERT INTO llu_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","A Peter e bae urinae, sulia e langi kasi haitamana naa tesi doo na ka haea, sulia gera mou asianaa. ");
INSERT INTO llu_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ma tesi barobaro e dao faatai mai ma ka afu faafi gera ana na nunufilana. Ma tesi lingee doo e talo mai faasia na barobaro nae ka urii, <<Nia naa na Wela nau na ku rakediana ana. Molu ka fafurongo urii nia!>> ");
INSERT INTO llu_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ma gera ka aada aliꞌali gali gera, ma dasi rikia naa ta wane fai gera, tee taifilia go a Jesus. ");
INSERT INTO llu_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Si kada da sifo mai faasia fe tolo nae, a Jesus ka bae luida ka urii, <<Langi molu si faarongoa ta wane ana si doo na molu rikia, lea ka dao ana si kada ni nau, na Wela nia Iimola gi, kuka tatae go faasia na maea.>> ");
INSERT INTO llu_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ma gera ka roosulia na baelana, ma daka bae ada sulia i matangada kwailiu daka urii, <<Na taa naa na malutana na tataelaa faasia na maea?>> ");
INSERT INTO llu_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ma gera ka ledia daka urii, <<Uria taa na wane faatolomai gi ana kwaieresia gi daka haea a Elaeja ka ooli fasi ana i nao?>> ");
INSERT INTO llu_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ma a Jesus e oolisida ka urii, <<A Elaeja ka dao mamana go mai i nao, hai so ka aade aagau ana na doo gi sui. Sui uria taa lau na Kekedelaa Aabu ka haea hasa na Wela nia Iimola gi ka nonifii baita ma na tooa gi daka oote gera ani nia? ");
INSERT INTO llu_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","I nau ku haea fuamolu, a Elaeja e dao naa, ma sui na tooa gi daka aadea naa si doo gi na da doori iilia ani nia, iilingia na Kekedelaa Aabu e haea suli nia.>> ");
INSERT INTO llu_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ma si kada da dao mai siada na oote fafurongo aai gi, daka rikia tee figua baita da too gali gera. Ma teni wane faatolomai gi ana na kwaieresia da oolisusuu fai gera. ");
INSERT INTO llu_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ma si kada na tooa gi da rikia a Jesus, i gera ka kwele asianaa ma da lalao kou uria na bae dianalaa fai nia. ");
INSERT INTO llu_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ma a Jesus ka ledia na oote fafurongo nia gi ka urii, <<Na taa naa molu oolisusuu fai gera sulia?>> ");
INSERT INTO llu_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ma tee wane i laona na figua nae e oolisia ka urii, <<Faatolomai ae, i nau ku ngalia mai na alakwa nau i siamu. Na aagalo taꞌa e adosia ma ka langi si bae naa. ");
INSERT INTO llu_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ma si kada na aagalo taꞌa nae e dao ani nia, ka ui ani nia i aano. Ma na fakana ka ngingisulaa, ma ka gigiri lifo, ma na nonina ka gagaꞌai teefou. Ma i nau ku gania na oote fafurongo oe gi eeri daka taria na aagalo taꞌa nae, sui ma ka afetai fuada.>> ");
INSERT INTO llu_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ma a Jesus e haea fuada ka urii, <<I gamu langi musi manata mamana ua! Nau ku noni eela uria toolaa fai gamu. Ma nau ku lafusia ta fita si kada lau na kuka too ana fai gamu. Talaia mai na wela nae siagu.>> ");
INSERT INTO llu_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ma da ngalia mai na wela baa siana a Jesus. Ma si kada na aagalo nae e rikia a Jesus, nia ka ui ania na wela nae i aano, ma ka lada ma na fakana ka ngingisulaa naa. ");
INSERT INTO llu_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ma a Jesus ka ledia na maa nia na wela nae ka urii, <<E tau utaa na mai i aangita naa ni nia e urii?>> Ma i nia e oolisia ka urii, <<E ita ua mai si kada e toꞌou ana. ");
INSERT INTO llu_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ma si kada oro na e ui ani nia i laona na eere ma i laona na kafo hai so ka haumaelia. Haia, lea so ka bobola go ana fuamu, oko manatai gemere mai ma oko adomi gemere.>> ");
INSERT INTO llu_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ma a Jesus ka bae urii, <<Iiuka, lea so ni oe ana i talamu o bobola fai nia! Na doo gi sui e waluda go ana fuana ni tei naa e manata mamana.>> ");
INSERT INTO llu_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ma aliꞌali na maa nia na wela nae ka rii urii, <<I nau ku manata mamana go agu! Sui taa, o adomi nau mai, hai so na manata mamanalaa nau ka rigita!>> ");
INSERT INTO llu_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ma si kada a Jesus e rikia na figua nae da figu na mai gali gera, i nia ka bae urii fuana na aagalo taꞌa nae, <<I oe na aagalo na o aadea aalingana wela naa ka boko ma na fakana ka ato, i nau ku eeresi oe oko haga mai faasia, ma osi ruufi nia lau.>> ");
INSERT INTO llu_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ma na aagalo na ka rii, ma ka lebetainia na wela nae, ma ka haga na mai i maa faasia. Ma na wela nae na rikilana ka iilingia na ana na wane e mae, ma na tooa oro daka bae urii, <<I nia e mae naa.>> ");
INSERT INTO llu_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Sui, a Jesus ka dau ana na abana na wela, ma ka tataea, ma nia ka take. ");
INSERT INTO llu_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ma si kada a Jesus e ruu i luma, na oote fafurongo nia gi daka ledi aagwa ani nia daka urii, <<Uria taa na ka afetai fuamelu uria na tarilana na aagalo baa?>> ");
INSERT INTO llu_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ma a Jesus e oolisida ka urii, <<Fooalaa taifilia go na e bobola fai nia tarilana na aagalo urii, e langi lau tesi doo.>> ");
INSERT INTO llu_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Sui Jesus ma na oote fafurongo nia gi da tafusia si gula nae, ma daka liufia na bali fera i Galili. Ma a Jesus ka langi si dooria so ta wane ka haitamana si gula na e too ana, ");
INSERT INTO llu_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","sulia nia e faatolomainia ana oote fafurongo nia gi ka urii, <<Nau, na Wela nia Iimola gi, tara daka fale nau fuana wane gi. Haia, i gera daka haumaeli nau. Ma ana ooula maedani, tara nau kuka tatae lau uria mouria.>> ");
INSERT INTO llu_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Sui taa, na fafurongo nia a Jesus gi dasi haitamana na malutana si baelana, ma sui daka mou go ada uria na ledilanalaa. ");
INSERT INTO llu_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ma si kada da dao ana fera i Kapaneam, ma daka ruu i luma, Jesus ka ledia na oote fafurongo nia gi ka urii, <<Na taa baa molu oolisusuu mai ana, sulia na tala?>> ");
INSERT INTO llu_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Sui langi dasi haea tesi doo, sulia da oolisusuu mai hasa ni tei ani gera na ka baita ka liufi gera sui. ");
INSERT INTO llu_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Haia, a Jesus e gwouru, ma ka soea mai na aakwala ma roo fafurongo nia gi siana, ma ka bae urii, <<So ni tei na e dooria ka naonao, i nia ka aalu nia ka isi ma i nia na wane ni rao fuada na tooa gi sui.>> ");
INSERT INTO llu_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Sui a Jesus ka talaia mai tee wela, ma ka faatakea i matangada. Nia ka oofia na wela nae ma ka bae urii fuada, ");
INSERT INTO llu_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","<<So ni tei naa ka gonitainia ta wela toꞌou urii ana na hatagu, nia ka gonitai nau laugo. Ma so ni tei naa ka gonitai nau, nia langi si gonitai nau lau i taifili nau, i nia e gonitainia naa laugo a God na e oodu nau mai.>> ");
INSERT INTO llu_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","A John e bae urii fuana a Jesus, <<Wane Faatolomai ae, gemelu melu rikia tee wane e taria na aagalo taꞌa gi ana na hatamu, ma melu ka lui nia si iilia si doo nae, sulia nia e langi lau ta wane ana oofulaa golu.>> ");
INSERT INTO llu_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ma a Jesus ka bae urii, <<E langi molu si lui nia, sulia ni tei naa e iilia tesi doo kwaibalatana ana na hatagu, e afetai kafi haea lau tesi doo taꞌa suli nau. ");
INSERT INTO llu_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Sulia ta wane na e langi kesi maalimaea ani golu, nia wane agolu. ");
INSERT INTO llu_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","I nau ku haea na doo mamana fuamolu, ta wane na e falea si mae kafo fuamolu sulia gomolu na tooa nau gi, tara nia ka ngalia mamana naa na kwaiaraa nia. ");
INSERT INTO llu_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ma lea so ta wane ka faagaroa ta wela ana wela toꞌou naa gi na da manata mamana ani nau, e diana fuana daka kania ta fou baita i luana ma daka ui ania i laona na aasi. ");
INSERT INTO llu_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Nia naa, lea so na abamu e faagaro oe, taba muusia amu. E diana fuamu hai so oko too katau ana na mouria i langi fai nia na kuri aba, aata oko sifo i laona si gula ana kwakwaelaa fai nia na roo abamu gi, si gula na eere e totoo si mae. ");
INSERT INTO llu_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Ma lea so na aemu ka faagaro oe, oko taba muusia amu. E diana fuamu hai oko too tau amu ana na mouria i langi, fai nia na kuri ae, aata oko sifo i laona si gula ana na kwaelaa fai nia na roo aemu gi. ");
INSERT INTO llu_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ma lea so na maamu e faagaro oe, oko lafua amu. E diana fuamu hai so oko ruu i laona na Initooa nia a God fai nia tee bali maa, aata oko sifo i laona si gula ana na kwaelaa fai nia na roo bali maa gi. ");
INSERT INTO llu_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ma si gula nae, na waawaa gi na da ania na tooa gi langi dasi mae, ma na eere na e suungia ana na tooa gi e totoo si mae. ");
INSERT INTO llu_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","<<Sulia daka aalua na eere i fafona na tooa gi sui, iilingia na aasi e liufia i laona si fanga. ");
INSERT INTO llu_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","<<Ma na aasi na doo diana, sui taa lea so na mamasialana e langi ana faasia, e afetai daka iilia ana tesi doo hai so ka aasilaa lau. <<Urinae laugo, muka faadiana tooa gi iilingia na aasi e faadiana na fanga. Ma muka too ana fanualama fai gamu kwailiu.>> ");
INSERT INTO llu_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Sui a Jesus e tafusia si gula nae, ma ka lea uria na bali fera i Judea, ma ka faifolo ana na kafo i Jodan. Ma na tooa oro gi daka figu mai siana, ma i nia ka faatolomai gera, iilingia na e ita ka iilia na mai. ");
INSERT INTO llu_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ma teni Farisi gi da lea siana a Jesus, ma daka iiliili uria faagarolana, daka urii, <<Na kwaieresia gia gi e faalamainia go ana na wane uria ka lugasia go ana na afe nia?>> ");
INSERT INTO llu_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ma a Jesus e oolisida ka urii, <<Na taa naa a Moses e kwaieresia ana?>> ");
INSERT INTO llu_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ma daka bae urii, <<A Moses e faalamainia na wane ka kedea si abe doo ana na kwailugasilaa, ma ka falea fuana na afe nia hasa nia ka lugasia naa.>> ");
INSERT INTO llu_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ma a Jesus ka bae urii, <<A Moses e kedea si kwaieresia naa fuagamu sulia e afetai uria faatolomailaa gamu. ");
INSERT INTO llu_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Sui ana hafalilana mai, si kada a God e haungainia na doo gi sui, i nia ka haungainia na doo wane ma na doo geni. ");
INSERT INTO llu_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Nia naa, na wane ka tafusia na maa nia fai nia ni tee nia, ma ka too oofu fai nia na afe nia, ");
INSERT INTO llu_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ma daaro ka hau ana na tee doo go. Nia naa laugo daaro si roo doo, ma daaro ka tee doo naa. ");
INSERT INTO llu_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Nia naa, si doo na a God e kani oofua sui naa urinae, e langi si diana fuana ta wane ka lukea.>> ");
INSERT INTO llu_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ma si kada a Jesus fai nia na oote fafurongo nia gi da ooli i luma, daka ledi nia uria si doo naa. ");
INSERT INTO llu_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ma i nia e oolisia ka urii, <<Ta wane na e lugasia na afe nia ma ka aadea lau ta aai eꞌete, nia e ooeoe naa faafia na afe nia. ");
INSERT INTO llu_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ma urinae laugo, lea so ta geni e lugasia na aarai nia ma ka aadea lau ta wane eꞌete, ni nia e ooeoe naa faafia na aarai nia.>> ");
INSERT INTO llu_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Teni tooa gi da ngalia mai na wela toꞌou gi siana a Jesus hai so ka hamosi gera, sui taa na oote fafurongo nia gi daka ngatafi gera. ");
INSERT INTO llu_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ma si kada a Jesus e rikia si doo naa, nia ka rakehasu, ma ka bae urii fuada, <<Molu faalamainia na wela gi daka lea ada mai siagu, ma langi molu si luida. Sulia ni tei naa e manata mamana ka iilingia gala wela, nia ka bobola uria toolaa lao Initooa nia a God. ");
INSERT INTO llu_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","I nau ku haea na doo mamana fuagamu, so ta wane na e langi kasi manata mamana iilingia na gala wela, i nia e afetai ka ruu i laona na Initooa nia a God.>> ");
INSERT INTO llu_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ma nia ka oofia naa na wela nae gi, ma ka aalua na abana faafi gera ma ka faadiana gera. ");
INSERT INTO llu_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Si kada a Jesus e hafalia lea lau go ana, tee wane e lalao mai siana ma ka boururu i naona. Ma nia ka ledia ka urii, <<Wane faatolomai diana ae, tesi taa naa kuka iilia eeri kuka too ana na mouri firi?>> ");
INSERT INTO llu_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ma a Jesus e oolisia ka urii, <<Uria taa naa oko haea nau ku diana? Sulia langi ta wane si diana go, tee taifilia a God go na e diana. ");
INSERT INTO llu_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Haia, ni oe o haitamana na kwaieresia gi baa e urii, <Osi hauwane, ma oe osi ooeoe, ma osi beli, ma osi suge faafia ta wane, ma osi faafefea ta wane, ma oko manata baita ana na maa oe ma ni tee oe.>>> ");
INSERT INTO llu_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ma i nia ka bae urii, <<Wane Faatolomai ae, e ita ana si kada ku toꞌou mai, ku roosulia teefou naa kwaieresia nae gi sui go.>> ");
INSERT INTO llu_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ma a Jesus e aada kou fuana ma ka rakediana ani nia, ma ka bae urii, <<Tesi doo go na e langi ua. O lea, oko faafoli ana na doo oe gi sui, oko ngalia si malefo nae, oko falea fuana na tooa siofaa gi, ma tara oko kafi too ana na todadoo i langi. Sui oko lea mai suli nau.>> ");
INSERT INTO llu_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ma si kada na wane nae e rongoa go si doo nae gi, na maana ka asia. Ma nia ka lea na ana fai nia na liobukonua, sulia i nia na wane rikidoo asianaa. ");
INSERT INTO llu_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Sui a Jesus ka aada fuana na oote fafurongo nia gi, ma ka bae urii, <<E afetai asianaa fuana na wane rikidoo gi tara daka ruu laona Initooa nia a God.>> ");
INSERT INTO llu_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ma na oote fafurongo nia gi daka kwele asianaa ana si baea nia nae gi. Sui a Jesus ka bae lau urii, <<Oote wela nau gi ae, e afetai fuana na ruulaa laona Initooa a God. ");
INSERT INTO llu_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","E afetai ka tasa lau fuana ta wane rikidoo ka ruu i laona na Initooa a God, faasia na doo fai ae baita so ka ruu i maana ta mae ogilaa.>> ");
INSERT INTO llu_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ma na oote fafurongo nia gi daka kwele asianaa, ma da bae fuada kwailiu daka urii, <<Tara ni tei gera ana na daka mouri?>> ");
INSERT INTO llu_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ma a Jesus e bubu kou fuada ka bae urii, <<Si doo naa e afetai fuada na wane gi, ma fuana a God e langi si afetai go. Na doo gi sui e waluda go ana fuana a God.>> ");
INSERT INTO llu_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ma a Peter ka bae urii fuana, <<Sui gemelu naa, melu tafusia sui naa na doo gemelu gi sui, ma melu ka lea na mai suli oe naa!>> ");
INSERT INTO llu_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ma a Jesus e oolisia ka urii, <<Iiu, nau ku haea fuagamu, so ni tei na e lugasia na luma nia, ma langi na haasina gi, ma langi na waiwane nia gi, ma langi na maa nia, ma langi ni tee nia, ma langi na wela nia gi, ma langi na gano nia, i nunufagu ma na Faarongolaa Diana, ");
INSERT INTO llu_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","tara nia ka ngalia lau si doo nae gi ka oro ka liufia si kada naa. Nia tara ka ngalia ana si doo oro gi ana na luma gi, ma na haasina gi, ma na waiwane gi, ma ni tee gi, ma na wela gi, ma na gano. Ma tara nia ka nonifii laugo. Ma ana si kada na tara ka dao mai, tara nia ka too ana mouri firi. ");
INSERT INTO llu_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Haia, na tooa oro gi na da eeta i nao si kada naa, tara daka isi, ma na tooa oro gi na da isi si kada naa, tara daka eeta i nao.>> ");
INSERT INTO llu_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jesus fai nia na oote fafurongo nia gi da lea lau sulia na tala uria i Jerusalem, ma a Jesus ka eeta i nao ada. Ma na oote fafurongo nia gi daka kwele asianaa, ma na tooa gi aai na da lea kou i burida daka mou asianaa. Ma a Jesus ka talai lau na oote fafurongo nia gi i kele tau kou, ma ka faarongo gera ana si doo gi na tara ka fuli fuana. ");
INSERT INTO llu_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","I nia ka bae urii, <<Fafurongo! Golu lea i Jerusalem, ma tara daka fale nau na Wela nia Iimola gi fuada na fataabu baita gi ma na wane faatolomai gi ana na kwaieresia. Ma i gera tara daka keto nau uria na maelagu, ma daka fale nau fuada na tooa maadiu gi. ");
INSERT INTO llu_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ma na tooa nae gi tara daka faawaela ani nau, ma daka ngisufi nau, ma daka rabusi nau, ma daka haungi nau. Ma ana ooula maedani, nau tara kuka tatae lau faasia na maea.>> ");
INSERT INTO llu_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sui a James ma a John, na roo wela a Sebedi, daaro lea mai siana a Jesus ma daaro ka bae urii, <<Wane Faatolomai ae, i gemere mere dooria oko iilia tesi doo na mere gani oe uria.>> ");
INSERT INTO llu_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ma a Jesus e ledi ka urii, <<Na taa na moro dooria kuka iilia fuamoro?>> ");
INSERT INTO llu_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ma daaro oolisia daaro ka urii, <<Oe o faalamainia ta wane ani gemere ka gwouru i bali aaolo amu ma ta wane i bali mouli amu, si kada na o Aaofia ana i laona na Initooa oe.>> ");
INSERT INTO llu_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ma a Jesus ka bae urii, <<I gomoro moro lalafusia si doo na moro gani uria. I gomoro moro bobola go amoro uria nonifiilaa iilingi nau tara ku nonifii?>> ");
INSERT INTO llu_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ma daaro oolisia daaro ka urii, <<Gemere mere bobola go amere uria na iililana.>> Ma a Jesus ka bae urii fuadaaro, <<Haia, tara gomoro moro nonifii iilingi nau. ");
INSERT INTO llu_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Sui taa, langi kusi filia ni tei naa ka gwouru i bali aaolo agu ma i bali mouli agu. A God ana na ka falea si gula nae gi fuada ni tei gera na nia e aade aagau ada a maasida.>> ");
INSERT INTO llu_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ma si kada na aakwala wane fafurongo aai gi da rongoa si doo naa, daka rakehasuia a James ma a John. ");
INSERT INTO llu_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ma a Jesus e oofu gera ma ka bae urii, <<Gomolu molu haitamana na wane baita gi ana na tooa maadiu gi, da dooria asianaa ooroilana tooa gera gi, ma na wane naonao gera gi daka haitamana asianaa suungailana tooa uria iililana si doo gera dooria. ");
INSERT INTO llu_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Sui boroi ana, si doo nae ka langi si urinae i matanga molu. Lea so ta wane amolu e dooria ka baita, i nia ka hau ana na wane ni rao gomolu. ");
INSERT INTO llu_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ma so ni tei naa e dooria ka eeta i nao, i nia ka rao oꞌoni fuada na tooa gi sui. ");
INSERT INTO llu_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Sulia nau, na Wela nia Iimola gi boroi, e langi kusi lea mai eeri na tooa gi daka rao fuagu. I nau ku lea mai taari eeri kuka rao fuana na tooa gi sui, ma kuka falea na mourilagu uria na faamourilana na tooa oro.>> ");
INSERT INTO llu_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ma a Jesus fai nia na oote fafurongo nia gi da dao ana fera i Jeriko. Ma si kada gera da tafusia na fera nae fai nia na figua baita nae, tee wane na maana e rodo e gworu go ana i ninimana na tala uria na ganilana. Na hatana a Batimeas na wela nia a Timeas. ");
INSERT INTO llu_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ma si kada nia e rongoa a Jesus na wane i Nasaret e lea mai, nia ka rii ka urii, <<A Jesus ae, oe na aaofia ana kwalafaa a David, o manatai nau mai.>> ");
INSERT INTO llu_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ma na tooa gi daka lui nia, ma daka haea fuana hai so nia ka too aaroaro. Sui, i nia e rii baita ka tasa fetei ka urii, <<Aaofia ana na kwalafaa a David ae, o manatai nau mai!>> ");
INSERT INTO llu_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","A Jesus e take ma ka bae urii, <<Molu soea mai.>> Ma gera soea na wane nae, daka urii, <<Oko eele amu! Oko tatae, sulia Jesus e soe oe.>> ");
INSERT INTO llu_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ma nia ka lafua maku ruruu baita nia, ma ka tatae aliꞌali, ma ka lea siana Jesus. ");
INSERT INTO llu_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesus e ledia ka urii, <<Taa naa oko dooria kuka iilia fuamu?>> Ma na wane maa rodo nae e oolisia ka urii, <<Aarai baita ae, nau ku dooria kuka aada lau.>> ");
INSERT INTO llu_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesus ka bae urii, <<Haia, o lea naa. Oko aada lau sulia o manata mamana ani nau.>> Ma aliꞌali na maana ka aada lau, ma nia ka lea na sulia a Jesus sulia na tala. ");
INSERT INTO llu_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Si kada a Jesus ma na oote fafurongo nia gi da dao ana fera i Betfeis ma i Betani, i siana gwe tolo da alangia ana Olivtri, na e too garangia na fera i Jerusalem, i nia ka oodua na roo wane ana fafurongo nia gi daka lea i nao. ");
INSERT INTO llu_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ma i nia ka bae urii fuadaaro, <<Moro lea ana fera loko moro naofia kou, ma si kada moro dao seenae, tara moro ka rikia tee gale doo fai ae na hatana na dongki na e langi ta wane kasi tae ua i fafona, da kania go ada i seenae. Moro lukea ma moro ka talaia mai i see. ");
INSERT INTO llu_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ma lea ta wane e ledi gomoro, <Uria taa na moro ka iilia si doo naa?>, moro ka haea fuana, <A Lord naa e dooria, ma tara i nia ka oolifai aliꞌali laugo mai ana i seenaa.>>> ");
INSERT INTO llu_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ma daaro lea, ma daaro ka rikia tee gale dongki da kania go ada i ninimana na tala i maana tee luma. Ma si kada daaro lukea ana, ");
INSERT INTO llu_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","teni wane gi na da take i seenae daka ledi daaro, daka urii, <<Na taa na moro lukea na gale dongki na uria?>> ");
INSERT INTO llu_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ma daaro oolisia iilingia baa a Jesus e haea fuadaaro, ma na wane nae gi daka faalamainia fuadaaro. ");
INSERT INTO llu_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ma daaro ka talaia mai na gale dongki nae siana Jesus, ma daaro ka hamatainia na maku daaro gi i fafona, ma a Jesus ka tae i fafona. ");
INSERT INTO llu_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Na tooa oro gi da hamatainia na maku ruruu gera gi i sulia na tala, ma teni tooa aai gi daka tabalia na hare ai gi, ma daka hamatainia sulia na tala. Gera iilia si doo naa uria faabaitalana Jesus. ");
INSERT INTO llu_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ma na tooa gi na da eeta i nao, fai nia tooa gi na da isi, da rii daka urii, <<Baelafea fuana a God! Ma a God ka faadiana ana na wane naa e lea mai ana na hatana a Lord! ");
INSERT INTO llu_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ma a God ka faadiana ana na daolana mai na Initooa na e iilingia na initooa a David na kokoo gia! Gia baelafea a God!>> ");
INSERT INTO llu_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","A Jesus e ruu i laona na fera i Jerusalem, ma ka lea i laona labata na Beu Aabu nia a God, ma ka aadaada loko, ma ka rikia na doo gi sui. Sui, i nia ka lea na ana uria i Betani fai nia na aakwala ma roo fafurongo nia baa gi, sulia e garangi rodo naa. ");
INSERT INTO llu_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ma ana fe dani i buira, si kada a Jesus ma na oote fafurongo nia gi da ooli na mai ana faasia i Betani, a Jesus ka fiolo. ");
INSERT INTO llu_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ma nia e aada kou, ma ka rikia tee ai uuluulua na da alangia ana na figi. Ma nia ka lea garangia eeri ka rikia hasa ta fufue doo ka too ana. Sui, si kada e dao aena, nia ka rikia go ana na abana gi, sulia si kada nae e langi lau si kada nia na ai nae figi uria na fungulaa. ");
INSERT INTO llu_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ma a Jesus ka bae urii fuana na ai figi nae, <<Ta wane kasi ania lau ta fufue doo ani oe!>> Ma na oote fafurongo nia gi daka rongoa si doo nae. ");
INSERT INTO llu_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ma si kada da dao ana i Jerusalem, a Jesus ka lea i laona labata ana Beu Aabu nia a God, ma ka taria na tooa gi sui na da fofoli, ma na tooa gi na da faafoli ana si doo gi i laona labata ana Beu Aabu nia a God. Ma i nia ka faaꞌasiaa na tefolo gi na wane nae gi na da tatala ana na malefo, ma ka faaꞌasiaa na doo gwourulaa gera tooa gi na da faafoli ana na bola gi. ");
INSERT INTO llu_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ma nia langi kasi faalamainia ta wane ka ngalia tesi doo i laona na labata ana Beu Aabu nia a God. ");
INSERT INTO llu_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ma nia ka faatolomainia na tooa gi, ka bae urii, <<A God e haea i laona na Kekedelaa Aabu ka urii, <Na Beu nau, da alangia ana na Beu ni fooalaa fuana na tooa ana fera gi sui.> Sui i gamu muka bulasia agamu ana si gula gera na wane bebeli gi.>> ");
INSERT INTO llu_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Sui, na fataabu baita ma na wane faatolomai gi ana na kwaieresia gi, da rongoa si doo naa, ma daka nani uria tesi aadelaa uria na haungilana a Jesus. Ma gera ka moungi nia, sulia na figua teefou nae da kwele asianaa ana na faatolomaia nia. ");
INSERT INTO llu_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ma i haulafi, a Jesus ma na oote fafurongo nia gi daka lea faasia i Jerusalem. ");
INSERT INTO llu_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","I ubongia ana fe dani i buri, si kada a Jesus ma na oote fafurongo nia gi da gula kou sulia na tala, daka rikia na ai figi baa. Na ai baa e kuku naa lea ka sifo go sulia na lalina gi. ");
INSERT INTO llu_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ma a Peter ka manatatoona si doo baa a Jesus e iilia ana, ma ka bae urii fuana, <<Wane faatolomai ae, o rikia fasi na ai figi baa o ngatafia baa, nia e mae naa!>> ");
INSERT INTO llu_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ma a Jesus e oolisia ka urii, <<Molu ka manata mamana ana a God. ");
INSERT INTO llu_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nau ku haea fuagamu, lea so molu ka bae urii fuana fe tolo naa, <O tatae ma oko ui ani oe i laona na aasi,> ma e langi molu si manata hala i laona na liomolu, ma molu ka manata mamana ana si doo na molu haea ka fuli, si doo nae ka fuli go ana fuamolu. ");
INSERT INTO llu_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Nia naa, nau kuka haea fuamolu urii, si kada molu fooa ma molu ka gani uria tesi doo, molu ka manata mamana hasa molu ka ngalia naa, ma tara a God ka falea go ana tesi doo na molu gani uria. ");
INSERT INTO llu_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Haia, si kada molu fooa, molu ka manata lukea tesi doo taꞌalaa na ta wane e iilia ani gomolu, eeri na Maa gomolu naa e too mai i langi ka manata lukea laugo na doo taꞌalaa gomolu gi.>> ");
INSERT INTO llu_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","A Jesus ma na oote fafurongo nia gi, gera ooli lau mai uria i Jerusalem. Ma si kada a Jesus e fali kou i laona labata ana Beu Aabu nia a God, na fataabu baita gi ma na wane faatolomai gi ana na kwaieresia gi, ma na wane naonao gi daka lea mai siana. ");
INSERT INTO llu_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ma gera ledi nia daka urii, <<Na mamanaa taa na o too ana uria na iililana si doo naa gi? Haia, ma ni tei naa e falea na mamanaa naa fuamu?>> ");
INSERT INTO llu_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ma a Jesus e oolisida ka urii, <<Haia, nau ku ledi gomolu fasi laugo ana tesi doo. Lea molu oolisia, nau kufi faarongo gomolu ana na mamanaa na ku too ana uria na iililana si doo naa gi. ");
INSERT INTO llu_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Haia, molu haea fasi fuagu, na mamanaa na a John e too ana uria na siuabulaa e ita mai faasia i fai? E ita mai faasia a God, langi e ita mai faasia na wane gi go ana?>> ");
INSERT INTO llu_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ma gera ka hafalia na oolisusuulaa i matangada kwailiu daka urii, <<Taa naa golu ka haea? Lea so golu oolisia golu ka urii, <Faasia a God,> nia tara ka bae urii, <Ma sui uria taa na molu kasi manata mamana ana a John?> ");
INSERT INTO llu_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ma langi si diana laugo fuana golu ka bae urii, <E ita mai faasia na wane gi go ana.>>> (Sulia gera da moungia na tooa gi, sulia na tooa gi sui da haitamana a John nia na profet mamana.) ");
INSERT INTO llu_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Nia naa, da oolisia a Jesus ma daka urii, <<I gemelu melu lalafusia.>> Ma a Jesus ka bae urii fuada, <<I nau boroi kusi faarongo go ana na mamanaa taa na ku iilia ana si doo naa gi.>> ");
INSERT INTO llu_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Sui a Jesus e bae fuada ana si baea oomelawanelaa ka urii, <<Tee wane e fasia na raoa. Ma nia ka haungainia rara galia, ma ka elia tee kilu uria na felesilana na fufue ai gi uria na waen, ma ka tolea tee luma uria na fololaa. Sui nia ka aalua na raoa nia nae i abada teni wane gi na da rao i hara gi, ma ka lea ana uria ta aefera aai. ");
INSERT INTO llu_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ma si kada na raoa nae e moua, nia ka oodua na wane ni rao nia siada na wane gi ni rao i hara nia, eeri daka falea mai na bali ana na doo gi na da gonia. ");
INSERT INTO llu_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Sui na wane ni rao nae gi da ngiria, ma daka rabusia, ma daka oolifai oꞌoni go ada ani nia. ");
INSERT INTO llu_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Sui na wane baa na e too ana na raoa nae ka oodua lau ta wane ni rao aai. Ma na wane ni rao i hara baa gi da rabusia ketena, ma daka iili taꞌa asianaa ana. ");
INSERT INTO llu_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Sui na wane baa na e too ana na raoa nia, ka oodua lau ta wane ni rao aai, ma daka haumaelia naa. Ma daka aade urinae laugo ana na wane oro gi aai na e ooduda i buri. Da rabusia teni wane gi, ma daka haumaelia teni wane gi aai. ");
INSERT INTO llu_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Haia, ma tee wane go naa na e too uria na oodulana, tee fe wela rakediana nia na wane nae. Ma nia ka oodu nia, ka manata urii, <I gera tara ka manata baita ana wela nau.> ");
INSERT INTO llu_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Sui taa, na wane ni rao i hara nae gi da bae fuada kwailiu daka urii, <Nia naa na wela nia na wane baa e too ana na raoa. Lea mai golu ka haumaelia, hai so golu ka too na agolu ana si doo nia gi sui.> ");
INSERT INTO llu_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ma gera ngalia na wela nae, daka haumaelia, sui daka ui ania na noina i maa faasia laona na raoa nae.>> ");
INSERT INTO llu_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ma a Jesus e ledi ka urii, <<Tesi taa na wane na e too ana na raoa nae tara ka iilia? Tara nia e dao mai, ka haumaelia na wane nae gi, sui ka falea na raoa nia nae i abada teni wane eꞌete gi. ");
INSERT INTO llu_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","E utaa? Molu si iidumia si Kekedelaa Aabu baa e bae urii, <Si fou na wane rao gi ana tolebeulaa na da oote gera ana, nia ka hau ana si fou initoo ka tasa. ");
INSERT INTO llu_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","A Lord naa e iilia si doo naa, ma na rikilana ka diana asianaa.>>> ");
INSERT INTO llu_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Na wane naonao gera Jiu gi daka dooria dumulia a Jesus, sulia da haitamana naa a Jesus e haea si bae oomelawane nae uria bangalilada. Sui taa, gera mou ana na figua nae, ma daka tafusia, ma daka lea na ada. ");
INSERT INTO llu_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Teni wane naonao gi da oodua teni Farisi gi ma teni wane gi ana na wane nia gi a Herod uria na ledilana a Jesus hai daka faagaro nia. ");
INSERT INTO llu_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Haia, i gera dao siana, ma daka bae urii, <<Wane Faatolomai ae, gemelu melu haitamana si doo o haeda na doo mamana gi sui go, ma osi manata aꞌabo go sulia si taa gi na wane gi da manata sulia. Ma e langi osi manata go uria na baitalana na tooa. Ni oe o toolamainia go amu na mamanaa sulia na kwaidooria nia a God fuana na tooa gi. Haia, o haea fasi fuamelu! E utaa? Na kwaieresia gia, nia e luia na falelana na malefo ana na takisi fuana na wane initoo ana aefera i Rom? E utaa? Nia bobola melu ka falea, langi e langi?>> ");
INSERT INTO llu_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Sui taa, a Jesus e haitamana go ana si malaꞌoelaa gera, ma nia ka oolisia ka urii, <<Uria taa na molu ka hasi uria na faagarolagu? Molu ngalia fasi mai ta rebe malefo, ku rikia fasi.>> ");
INSERT INTO llu_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ma gera ka ngalia mai tee fe doo, ma nia ka ledi gera ka urii, <<Na nununa ni tei naa? Ma na hatana ni tei naa?>> Ma gera oolisia daka urii, <<Na nununa ma na hatana na aaofia i Rom.>> ");
INSERT INTO llu_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ma a Jesus ka bae urii, <<Molu falea si doo nia gi na aaofia i Rom fuana na aaofia i Rom, ma molu ka falea si doo nia gi a God fuana a God.>> Ma gera ka kwele asianaa ani nia. ");
INSERT INTO llu_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sui, teni Sadusi gi da lea mai siana a Jesus. Na tooa naa na tooa na da haea hasa na tooa gi e afetai daka tatae lau faasia na maea. ");
INSERT INTO llu_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Ma gera ledia a Jesus daka bae urii, <<Wane Faatolomai ae, a Moses e kedea na kwaieresia naa fuaga ka baea urii, <Lea so ta wane e mae, ma na afe nia ka mouri ua, sui ka langi kasi too na ana ta wela, na haasina na wane nae ka aadea lau na aai oru nae, hai so daaro ka too ana na wela fuana na wane na e mae.> ");
INSERT INTO llu_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Haia, ana tesi kada, fiu waihaasi too go ada. Ma na wane i nao e aade geni, ma ka langi kasi too ua go ana ta wela, ma ka mae na ana. ");
INSERT INTO llu_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Sui na ruana wane ka aadea lau na geni baa, ma i nia e langi si too laugo ana ta wela, ma ka mae laugo ana. Sui ooula wane ka urinae laugo. ");
INSERT INTO llu_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ma ka urinae laugo fuana oote waihaasina naa gi i buri. Na fiu waihaasina nae gi sui go na da aadea geni nae, ma ka langi dasi too sui go ana ta wela, ma daka mae sui go. Ma i isi, na geni nae ka mae naa laugo. ");
INSERT INTO llu_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Haia, ana si maedani na tooa mae gi sui tara gera tatae faasia maea, ni tei ani gera nae na afe nia baa? Sulia i gera fiu wane nae gi sui go baa da aadea.>> ");
INSERT INTO llu_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ma a Jesus ka oolisida ka urii, <<I gomolu molu garo asianaa, sulia molu si haitamana go na Kekedelaa Aabu gi ma na rigitalana a God. ");
INSERT INTO llu_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Sulia, ana si kada na tooa mae gi da tatae lau uria na mouria, i gera iilingia na ada na ensel gi i langi, ma e langi naa ta faarailaa ma ta faatoowanelaa. ");
INSERT INTO llu_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Haia, nau ku faatolomai doo sulia na tataelaa faasia na maea. E utaa? I gomolu molu si iidumia go i laona na kekedelaa nia a Moses, ana si gula baa sulia na eere e harufia na ai baa? A God ka bae fuana a Moses ka urii, <I nau naa God nia a Abraham, ma God nia a Aesak, ma God nia a Jakob.> ");
INSERT INTO llu_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Na malutana urii, na tooa nae gi na da mae naa, a God e haea nia ua na God gera, sulia gera da mouri ua fai nia. Nia naa, gomolu ka garo asianaa!>> ");
INSERT INTO llu_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ma tee wane faatolomai ana kwaieresia gi e rongoa si baea nae gi. Ma nia ka haitamana na dianalana na oolisilaa nia a Jesus fuana na wane ana Sadusi gi. Nia naa, nia ka lea mai, ka ledia a Jesus ka urii, <<Na kwaieresia taa na e baita tasa liufia na kwaieresia gi sui?>> ");
INSERT INTO llu_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ma a Jesus e oolisia ka urii, <<Na kwaieresia baita ka tasa e urii, <Tooa gi Jiu ae, muka fafurongo fasi! A Lord na God gia, nia tee Lord taifili nia go. ");
INSERT INTO llu_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Muka rakediana ani nia ana lio gamu teefou, ma ana mango gamu teefou, ma ana manata gamu teefou, ma ana rigitaa gamu teefou.> ");
INSERT INTO llu_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ma na ruana si kwaieresia ka urii, <Muka rakediana ana na tooa na da too garangi gamu, iilingia laugo na o rakediana fuamu i talamu.> E langi lau ta kwaieresia na e baita tasa liufi na roo kwaieresia naa gi.>> ");
INSERT INTO llu_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ma na wane faatolomai ana kwaieresia gi ka bae urii fuana a Jesus, <<Wane faatolomai ae, na oolisilaa oe e diana asianaa. Nia ka mamana, tee taifilia a Lord go ana na a God, ma e langi naa ta God eꞌete lau. ");
INSERT INTO llu_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ma tooa gi daka rakediana ani nia ana na liogera teefou, ma ana na manata gera teefou, ma ana na rigitaa gera teefou. Ma gera ka rakediana ana na tooa gi na da too garangi gera iilingia da rakediana ani gera i talagera. E diana tasa fuana wane ka roosulia roo kwaieresia nae gi, ka liufia na kwaisuusilaa ana doo fai ae gi ma teni si doo gi lau fuana a God.>> ");
INSERT INTO llu_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ma a Jesus e riki haitamana na liotoolaa nia, ma ka bae urii fuana, <<Oe too garangia naa na Initooa nia a God.>> Ma buira si doo nae, i gera daka mou go ada uria na ledilana lau a Jesus. ");
INSERT INTO llu_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Si kada a Jesus e faatolomai i laona na Beu Aabu nia a God, nia ka ledi urii, <<E utaa, na wane faatolomai gi ana na kwaieresia gi daka haea a Christ naa na wane ana na kwalafaa nia a David? ");
INSERT INTO llu_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Na Aanoedoo Aabu baa e faabae a David ka urii, <A God e bae urii fuana Lord nau: Oko gwouru i seegi i bali aaolo ani nau, maasia kuka saitasa ana na maalimaea oe gi.> ");
INSERT INTO llu_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","A David ana i talana na e soea a Christ ka urii, <Lord.> Nia naa, nau ku ledi go gomolu, utaa naa Christ na kwalafaa nia a David go ana?>> Na figua baita nae da eele asianaa si kada daka fafurongo ana a Jesus. ");
INSERT INTO llu_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ma nia ka faatolomainia fuada ka urii, <<Muka aadasuli gamu faasia na faatolomai gi ana kwaieresia gi, sulia gera dooria liliulaa fai nia maku ruruu tekwa gi, ma daka dooria laugo hasa na tooa gi da hae baita ani gera i maana usia gi, ");
INSERT INTO llu_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ma daka dooria gwourulaa ana naofe gula ni gwourulaa i laona Beu Aabu gi ni figulaa ma ana si gula diana gi kada ana fafangaa gi. ");
INSERT INTO llu_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Sui, tooa baa da belia na luma gera oru gi, ma daka fooa tetekwa gi eeri na tooa gi da tangoda. Haia, na faatolomai gi ana kwaieresia gi, na kwakwaelaa gera tara e baita ka tasa!>> ");
INSERT INTO llu_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Si kada a Jesus e gwouru garangia na gula ni fale malefolaa i laona na Beu Aabu nia a God, nia ka rikia tooa na da falea teni malefo gera gi. Ma na wane oro na daka rikidoo gi daka falea si malefo oro. ");
INSERT INTO llu_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Sui, nia ka rikia tee oru siofaa asianaa. Nia ka lea mai, ma ka falea roo si mige malefo toꞌou. ");
INSERT INTO llu_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ma a Jesus ka soea mai na oote fafurongo nia gi, ma ka bae urii fuada, <<Doo mamana nau ku haea fuamolu, si taa naa gwe oru siofaa e falea, nia baita ka tasa liufia tooa nae gi sui na gera fale malefo baita. ");
INSERT INTO llu_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Sulia tooa rikidoo, gera falea go ada ta bali toꞌou ana rikidoo gera gi. Sui, gwe oru siofaa naa nia e fale teefou na ana si doo gi na nia e too ana uria na mourilana ana.>> ");
INSERT INTO llu_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Si kada a Jesus e tafusia na Beu Aabu nia a God, tee wane ana na oote fafurongo nia gi ka bae urii fuana, <<Wane Faatolomai ae, o rikia fasi amu na fou diana naa gi ma na beu diana naa gi!>> ");
INSERT INTO llu_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ma a Jesus e oolisia ka urii, <<Haia, i oe o rikia na beu baita naa gi? E langi ta tesi fou i seenaa tara ka too lau i fulina. I gera sui go daka tagala i aano.>> ");
INSERT INTO llu_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ma kada a Jesus e gwouru fafona tolo Olivtri na e too i ootofana na Beu Aabu nia a God, a Peter, ma a James, ma a John, ma a Andrew taifili daalu, daalu lea mai siana, ma daalu ka ledia urii, ");
INSERT INTO llu_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","<<O haea fasi fuamelu, i aangita na si doo naa gi tara ka dao mai? Ma ta si taa na tara ka fuli eeri ka faatainia si kada uria si doo naa gi sui ka fuli e dao naa?>> ");
INSERT INTO llu_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ma a Jesus ka bae urii fuada, <<Molu ka aadaada diana ma molu si faalamainia ta wane ka talai garo ani gomolu. ");
INSERT INTO llu_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Sulia na tooa oro gi tara daka dao mai ana na hatagu, ma daka bae urii, <Ni nau naa na a Christ!> Ma daka talai garo ana na tooa oro gi. ");
INSERT INTO llu_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ma si kada molu rongoa na firua gi, ma na uunuunua sulia na firua gi, e langi molu si too ana mango lelebelaa. Si doo urinae gi ka dao mai, sui taa na suilana na doo gi sui ka langi ua. ");
INSERT INTO llu_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Na aefera gi daka firu fai gera kwailiu, ma na initooa gi daka firu fai gera kwailiu. Ma na aanuanu gi ka liu ana si gula gi sui, ma na uunifioloa gi ka liu. Ma si doo nae gi e iilingia go ana na geni faafuta e hafali fiiwela. ");
INSERT INTO llu_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","<<Ma i gomolu molu ka aadaada diana. Sulia teni tooa gi tara daka dumuli gomolu ma daka ngali gomolu uria na ketolamolulaa sulia molu manata mamana ani nau. Tara gera ka rabusi gomolu i laona na Beu Aabu ni figulaa gi. Ma molu ka take i naofana ada na aaofia gi ma na wane initoo gi, uria na faarongolaa ana na Faarongolaa Diana. ");
INSERT INTO llu_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ma muka bae sulia na Faarongolaa Diana fuada na tooa gi sui i nao ana na suilana na molaagali. ");
INSERT INTO llu_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ma si kada da dumuli gomolu, ma daka ngali gomolu uria na ketolamolulaa, e langi molu si manata aꞌabo uria si baea tara molu ka haea. Molu haea go amolu si baea gi na Aanoedoo Aabu e falea fuamolu ana si kada nae e dao mai. Sulia si baea gi na tara molu ka haea, e langi lau na baelamolu i talamolu. Si baea nae gi tara ka lea mai faasia na Aanoedoo Aabu. ");
INSERT INTO llu_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ma na wane gi tara gera falea na haasida gi i talada uria maelada. Ma na maa gi daka aade urinae laugo fuada wela gera gi. Ma na wela gi tara gera falea na maa gera gi ma ni tee gera gi uria maelada. ");
INSERT INTO llu_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ma na tooa gi sui tara daka maasusuala ani gomolu, sulia gomolu na tooa nau gi. Haia, ma lea ni tei na ka manata mamana ani nau lea ka dao ana fe dani iꞌisi, i nia ka mouri naa. ");
INSERT INTO llu_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","<<Ma tara ni gomolu na molu ka rikia na Doo Taꞌa na tara ka faafunuia na doo gi, e take ana si gula aabu.>> (Si baea fuana na wane na e iiduidu e urii: oko manata diana ana na malutana si doo naa.) <<Sui na tooa gi na da too ana na bali fera i Judea, daka tafi uria i gwouna na tolo gi. ");
INSERT INTO llu_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ma na wane na e too i maa ana na luma nia kasi ruu lau mai uria i laona na luma nia uria ngalilana tesi doo. ");
INSERT INTO llu_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ma na wane na e too i laona na raoa nia, ka langi si ooli lau i fera uria na maku ruruu nia. ");
INSERT INTO llu_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ma ana fe dani nae gi, tara ka taꞌa fuada na aai iiana gi, ma ka taꞌa laugo fuada na aai gi na da too ana na wela bibiu gi. ");
INSERT INTO llu_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Molu ka fooa fuana a God eeri doo naa gi ka langi si dao mai ana si kada ana na uuni gwagwaria. ");
INSERT INTO llu_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Sulia na taꞌalaa ana fe dani nae gi tara ka taꞌa ka liufia tesi doo taꞌa na tooa gi laona molaagali da haitamana, e ita ua mai ana hafalilana si kada a God e haungainia na molaagali lea ka dao ana si kada naa. Ma e langi tesi doo kasi urinae lau. ");
INSERT INTO llu_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ma lea so a God kasi kurusia fe dani nae gi, e afetai na wane gi ka mouri. Ma i nia e kurusia fe dani nae gi uria na dianalada na tooa nia gi na e filida. ");
INSERT INTO llu_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","<<Haia, lea ta wane ka bae urii fuamolu, <Molu rikia fasi, i nia naa na Christ,> ma langi ka bae urii, <Molu rikia fasi, i nia naa loko,> langi molu si manata mamana ani nia. ");
INSERT INTO llu_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Sulia na wane susuge gi na da haea gera na Christ, tara daka dao mai fai nia na wane susuge gi da haea gera ana na profet gi. Ma daka iilia doo kwaibalatana gi, eeri lea so ka waluda go ana, daka talai garo ana na tooa gi na a God e filida. ");
INSERT INTO llu_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Muka aadaada diana! I nau ku faarongo gomolu sui naa i nao sui si doo naa gi kafi dao. ");
INSERT INTO llu_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","<<Ma si kada na afetailaa e sui, na hato ma na sinali tara e langi kasi tala. ");
INSERT INTO llu_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ma na bubulu gi tara daka asida faasia i langi. Ma na doo gi i langi, daka lea garo. ");
INSERT INTO llu_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Sui, nau na Wela nia Iimola gi, kufi dao faatai mai. I nau ku dao mai fai nia na rigitaa baita ma na raralaa baita i fafona na barobaro gi. ");
INSERT INTO llu_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ma tara kuka falea na ensel gi fuana molaagali loulou, eeri daka gonia na tooa na a God e filida.>> ");
INSERT INTO llu_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Sui, Jesus ka hae ana si oomelawanea ka urii, <<Molu manata fasi sulia na ai figi gi. Kada mu rikia na abada e ngongosala, muka haitamana na kada fuana agoꞌagoa nia e dao garangi naa. ");
INSERT INTO llu_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ka urinae laugo, si kada mu rikia si doo naa gi tara ka dao mai, muka haitamana na oolisilagu e garangi naa. ");
INSERT INTO llu_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Doo mamana nae nau ku haea fuagamu, si doo naa gi tara ka dao mai suifetei tooa gi sui na da mouri ana si kada naa dasi mae ua. ");
INSERT INTO llu_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Tara langi ma na molaagali naa daka funu. Haia, tee baelagu go na afetai ka funu. ");
INSERT INTO llu_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","<<Langi ta wane so ka haitamana si kada tara kuka ooli mai ana. Na ensel gi i langi boroi dasi haitamana, ma so i nau, na Wela boroi, kusi haitamana laugo. A God na Maa taifili nia go na e haitamana. ");
INSERT INTO llu_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Molu ka aadaada diana, ma molu ka kwaimaasi, sulia molu lalafusia i aangita naa si kada nae ka dao mai ana. ");
INSERT INTO llu_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Nia ka iilingia ta wane na e lea ana fera tau, ma ka aalua na luma nia i abada na wane ni raoa nia gi, ma ka haea fuana na wane na e aadasulia na maa eeri ka aadaada diana. ");
INSERT INTO llu_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Nia naa, molu ka aadaada diana, sulia e langi molu si haitamana si kada na aarai baita ana na beu ka dao mai. I nia ka dao mai i haulafi oto, ma langi i initoona na rodo, ma langi i ofaidani, ma langi ana i ubongi. ");
INSERT INTO llu_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ma lea nia e dao aliꞌali mai, nia ka taꞌa asianaa lea nia ka daotoomolu si kada na molu teo ana. ");
INSERT INTO llu_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ma si doo nae nau ku haea fuamolu, nia doo nae na kuka haea laugo fuada na tooa gi sui e urii: Molu ka aadaada diana!>> ");
INSERT INTO llu_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Haia, ana na Fangaa ana Lofoagaua, na Jiu gi da haitamana anilana na beredi na e langi ta iisi i laona. Ma roo fe dani i nao ana na Fangaa baa, na fataabu baita gi, ma na wane faatolomai gi ana na kwaieresia gi gera ka haungainia manata uria na dumuli aagwalaa ma na haumaelilana a Jesus. ");
INSERT INTO llu_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","I gera ka bae urii laugo ada, <<E langi golu si iilia ana si kada ana Fangaa, aata na tooa gi daka firu fai golu.>> ");
INSERT INTO llu_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Si kada a Jesus e too i laona maefera i Betani, nia ka fanga ana i laona luma nia a Simon na wane na fura e haungia i nao. Ma ta tee geni ka lea mai siana fai nia na bii diana na e fungu ana na gwai na da alangia ana nad, ma na liulana ka baita asianaa. Ni nia e ifingia na maana botele nae, ma ka igitainia na gwai moko diana nae i fafona na ketena a Jesus. ");
INSERT INTO llu_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ma teni tooa gi na da too i seenae daka rakehasu, ma daka bae fuada kwailiu daka urii, <<Uria taa naa ka nagaa na gwai moko diana naa? ");
INSERT INTO llu_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Utaa naa nia si faafoli ana uria tesi malefo baita, eeri ka ngalia si malefo nae ka falea fuana na tooa siofaa gi?>> Ma gera ka ngatafia. ");
INSERT INTO llu_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Sui taa, a Jesus e rongoa, ka bae urii, <<Molu aalua e too ana! Uria taa na molu ka iinokesi nia? Ni nia e iilia si doo diana asianaa fuagu. ");
INSERT INTO llu_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Na tooa siofaa gi da too go ada fai gamu katau. Ma lea so molu dooria, molu ka adomi gera go amolu ana tesi kada. Haia, ma ni nau kusi too tau go siamolu. ");
INSERT INTO llu_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ni nia e iilia si doo na ni nia e bobola fai nia na iililana. Nia e igitainia na gwai moko diana naa i nonigu i nao ana maelagu uria na aade aagaulaa uria na aalulagu. ");
INSERT INTO llu_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Doo mamana nau ku haea fuamolu, ana si gula gi sui i laona molaagali na da bae sulia na Faarongolaa Diana naa ana, si doo naa nia e iilia tara daka bae laugo sulia uria na manatoolana ani nia.>> ");
INSERT INTO llu_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Sui a Judas Iskariot, tee wane ada na aakwala ma roo fafurongo nia gi, e lea i siada na fataabu baita gi, eeri ka faarongo ada tara nia falea a Jesus fuada. ");
INSERT INTO llu_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ma i gera ka eele asianaa sulia si doo na nia e haea, ma da bae aalualu uria falelana si malefo fuana. Ma a Judas ka hafalia na aadalaa uria tesi kada diana uria na falelana a Jesus fuada. ");
INSERT INTO llu_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ana eetana fe dani ana na Fangaa ana na beredi na e langi ta iisi laona, fe dani na da haumaelia ana na gale sipsip uria na Fangalaa ana na Lofoagaua, na oote fafurongo nia gi a Jesus daka bae urii fuana, <<I fai naa o dooria melu ka lea ma melu ka aade aagau ana na Fangaa ana na Lofoagaua fuamu?>> ");
INSERT INTO llu_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Sui a Jesus ka bae fuana tee roo wane ada ka urii, <<Moro ruu i laona Jerusalem nae, ma tee wane na e ngalia na doo ni ngalilana na kafo tara ka tooda gomoro. Moro ka lea i buira, ");
INSERT INTO llu_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ma ta luma na i nia e ruu i laona, moro lea sulia, moro ka bae urii fuana na wane na e too ana na luma nae, <Na wane Faatolomai e haea, na kade luma i fai hai so i nia ka ania ana na Fangalaa ana na Lofoagaua fai nia na fafurongo nia gi?> ");
INSERT INTO llu_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ma tara nia ka faatainia tee kade luma baita na e too i langi. I seenae na doo gi sui na ana, ma ka kwaimaakwali naa. Ma moro ka aade aagau ana na doo gi sui fuagolu i seenae.>> ");
INSERT INTO llu_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Haia, na roo wane fafurongo nae gi daaro lea, ma daaro ka dao fera Jerusalem nae, ma daaro ka rikia na doo gi sui e iilingia naa a Jesus baa e haea fuadaaro. Ma daaro ka aade aagau na ana doo gi sui uria na Fangalaa ana na Lofoagaua. ");
INSERT INTO llu_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Sui i haulafi, a Jesus ka dao mai fai nia na aakwala ma roo wane fafurongo nia gi. ");
INSERT INTO llu_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ma si kada gera fanga, a Jesus ka bae urii, <<Na doo mamana nau ku haea fuamolu, tee wane amolu tara ka fale nau fuana na maalimaea nau gi, ma na wane nae e fanga go ana fai nau ana si kada naa.>> ");
INSERT INTO llu_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ma na oote fafurongo nia gi daka hafalia na liobukonulaa ma daka ledia a Jesus, ta wane sui ta wane, ka urii, <<E utaa? E langi nau oto, ne?>> ");
INSERT INTO llu_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ma a Jesus e oolisida ka urii, <<I nia naa tee wane amolu na aakwala ma roo wane fafurongo nau gi, ma i nia naa ta wane na ka aalua si beredi nia i laona na fofo fai nau. ");
INSERT INTO llu_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ma nau, na Wela nia Iimola gi, tara kuka mae iilingia na Kekedelaa Aabu gi e haea suli nau. Sui taa, kwaimanatai asianaa fuana na wane na tara ka fale nau fuana na maalimaea nau gi! E diana go fuana na wane nae so nia kasi futa go mai.>> ");
INSERT INTO llu_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ma si kada gera fanga ana, a Jesus e ngalia tee beredi, ma ka baelafea a God, sui ka niia, ma ka falea fuana na oote fafurongo nia gi, ka bae urii, <<Molu ngalia, molu ka ania, i nia naa na nonigu.>> ");
INSERT INTO llu_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Sui i nia ka ngalia na teteu, ma ka baelafea a God, sui ka falea fuada, ma gera sui da gwou. ");
INSERT INTO llu_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ma i nia ka bae urii, <<Nia naa na abugu na e iigwa fuada na tooa oro gi uria haungainia na gwalulaa faalu nia a God. ");
INSERT INTO llu_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Doo mamana nau ku haea fuamolu, nau kusi gwoufia lau na waen naa lelea ka dao ana fe dani kuka gwoufia na waen faalu i laona na Initooa nia a God.>> ");
INSERT INTO llu_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Sui daka nguulia fe nguu, sui daka lea uria na tolo Olivtri. ");
INSERT INTO llu_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","A Jesus ka bae urii fuada, <<I gomolu sui go tara molu ka tafusi nau ma molu ka tafi. Sulia na Kekedelaa Aabu baa e haea urii, <Tara a God ka haumaelia na wane na e aadasulia na sipsip gi, ma na sipsip gi sui tara daka tagala.> ");
INSERT INTO llu_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Sui, i buira tara nau kuka tatae lau uria na mouria, i nau kuka eeta i nao ani gomolu uria na i Galili.>> ");
INSERT INTO llu_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ma a Peter e oolisia ka urii, <<Boroi ana na oote wane aai naa gi sui go daka lea faasi oe, e afetai kuka lea faasi oe!>> ");
INSERT INTO llu_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ma a Jesus e bae ka urii fuana a Peter, <<Nau ku haea fuamu. I nao ana na kakaraikua ka ai ana roo si kada i laona fe rodo naa i taraꞌena, i oe oko haea ana oolu si kada hasa o lalafusi nau.>> ");
INSERT INTO llu_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ma a Peter e oolisi rigita ana ka urii, <<Sui boroi ana kuka mae fai oe, e afetai kuka haea hasa ku lalafusi oe!>> Ma na oote fafurongo aai gi sui go, daka haea laugo tee si doo nae. ");
INSERT INTO llu_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Sui a Jesus fai nia na oote fafurongo nia gi, i gera ka lea uria na tesi gula da alangia ana Getsemani. Si kada gera dao, a Jesus ka bae urii fuada, <<Molu gwouru amolu i seenaa si kada ku fooa agu.>> ");
INSERT INTO llu_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Sui nia ka talaia a Peter ma a James ma a John fai nia. Ma nia ka liobukonu asianaa. ");
INSERT INTO llu_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ma i nia ka bae urii fuada, <<Na liogu e bukonu ka baita asianaa, ma ka bobola ka haumaeli nau. Molu too i seenaa, molu ka aadaada.>> ");
INSERT INTO llu_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ma nia ka iidu toꞌou kou, ma ka asi nia i hae gano, ma ka fooa hai so lea e bobola go ana, si nonifiilaa ka tasa ana faasi nia. ");
INSERT INTO llu_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ma i nia e fooa ka urii, <<Maa ae, na doo gi sui e waluda go ana fuamu. O lafua amu na nonifiilaa naa faasi nau. Sui taa, e langi lau si kwaidooria nau, na kwaidooria oe ana.>> ");
INSERT INTO llu_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Sui a Jesus ka ooli mai, ma ka daotoona na oolu wane fafurongo nia baa gi da teo ada. Ma nia ka bae urii fuana a Peter, <<Simon ae, e utaa? Ni oe oko teo amu naa? E utaa? Langi osi bobola go fuana na aadalaa fai nau sulia ta tee si kade rodo mone ana?>> ");
INSERT INTO llu_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ma i nia ka bae urii fuadaalu, <<Molu ka aadaada ma molu ka fooa, aata a Satan ka faagaro gomolu. Sulia gomolu dooria iilia na doo diana, sui na nonimu gi e makeso.>> ");
INSERT INTO llu_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ma a Jesus ka lea lau faasi daalu ma ka fooa, ma ka haea laugo tee si baea baa gi. ");
INSERT INTO llu_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Sui nia ka ooli lau mai siada, ma ka daotooda da teo lau, sulia na maada e teteolaa asianaa. Ma e langi daalu si haitamana na tesi doo na daalu ka haea fuana. ");
INSERT INTO llu_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ma si kada i nia e ooli lau mai ana ooluna si kada, nia ka bae urii fuada, <<I gomolu molu teo ua ma molu ka mamalo ua? Na bobola naa nae! Si kade hato nae e dao na mai! Molu rikia fasi, tara gera ka fale nau naa, na Wela nia Iimola gi, i abana na wane taꞌa gi. ");
INSERT INTO llu_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Molu tatae, golu lea naa. Molu rikia fasi, na wane baa e fale nau fuana na maalimaea nau gi, nia e dao na mai!>> ");
INSERT INTO llu_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Si kada Jesus e bae ua go ana, a Judas, na tee wane ana na aakwala ma roo wane fafurongo nia gi ka dao na mai fai nia tee figua baita faasia na fataabu baita gi, ma na wane baita gi, ma na wane faatolomai gi ana na kwaieresia gi. Ma figua baa da ngalia mai na naefe gi ma na subi gi, ma gera ka dao mai fai nia. ");
INSERT INTO llu_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ma na wane nae na tara ka fale Jesus fuada, nia ka falea sui naa si mamalafooa fuana na figua nae ka urii, <<Na wane na tara ku nonoia, nia na wane na molu dooria. Molu ka dumulia, molu ka talaia ana.>> ");
INSERT INTO llu_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ma si kada a Judas e dao, nia ka lea na kou siana a Jesus, ma ka bae urii, <<Wane Faatolomai ae!>> Ma nia ka nonoia naa. ");
INSERT INTO llu_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ma da dumulia naa a Jesus, ma daka ngiri rigita naa ani nia. ");
INSERT INTO llu_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Haia, ma ana si kada nae, tee wane na e take garangi go ana e lafua na naefe nia, ma ka kwae muusia ana na aalingana na wane raoa nia na fooanigwou. ");
INSERT INTO llu_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ma a Jesus ka bae urii fuada, <<Gomolu molu lea mai fai nia na naefe gi ma na subi gi uria na daulagu, iilingia so i nau ta wane bebeli? ");
INSERT INTO llu_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","I nau ku faatolomai go agu siamolu sulia dani i laona na Beu Aabu nia a God, sui langi molu si dumuli nau go. Haia, si doo nae na gamu iilia, nia ka faamamana na Kekedelaa Aabu.>> ");
INSERT INTO llu_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Sui na oote fafurongo nia gi sui gera tafusia, ma daka tafi na ada. ");
INSERT INTO llu_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ma tee wane daraa na e oofi go ana ana maku folo, e lea mai buira a Jesus. Ma daka hasi uria na dumulilana laugo. ");
INSERT INTO llu_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ma nia ka lugasia na maku nia nae, ma talu ka tafi na ana. ");
INSERT INTO llu_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Sui gera ka talaia a Jesus uria i luma nia na wane fooanigwou. Ma na fataabu baita gi, ma na wane baita gi, ma na wane faatolomai gi ana na kwaieresia gi, daalu figu i seenae. ");
INSERT INTO llu_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ma a Peter e isi tau kou, ma ka ruu laugo laona na labata ana luma i maa ana na luma nia na wane fooanigwou, ma ka gwouru ana seenae fai gera na wane fofolo gi, ma ka hara ana i ninimana na eere. ");
INSERT INTO llu_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ma na fataabu baita gi ma na wane baita gi sui daka hasi uria na daotoolana tesi doo taꞌa uria feengilaa ana Jesus hai so daka haumaelia, sui ma ka langi dasi daotoona go tesi doo. ");
INSERT INTO llu_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ma na tooa oro gi daka suge faafia a Jesus, sui na uunuunua gera gi ka langi si bobola go. ");
INSERT INTO llu_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Sui teni wane da take, ma daka suge faafia Jesus urii, ");
INSERT INTO llu_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","<<I gemelu melu rongoa i nia e bae urii, <Tara nau ku oogosia na Beu Aabu a God naa na wane gi go ana na da haungainia, haia ma ana na oolu fe dani, i nau kuka tolea ta doo aai, na e langi lau na wane gi na da haungainia.>>> ");
INSERT INTO llu_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ma i gera boroi, na uunuunua gera gi kasi bobola go. ");
INSERT INTO llu_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ma na wane fooanigwou e take i nao ani gera, ma e ledia a Jesus ka urii, <<E utaa? I oe osi too go ana tesi baea uria na oolisilana ana si baelaa naa gi na tooa naa gi da haea suli oe?>> ");
INSERT INTO llu_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Sui a Jesus ka bona go ana, ma ka langi si oolisia go. Ma na fooanigwou e ledia lau ka urii, <<E utaa? I oe naa na Christ, na Wela nia a God initooa?>> ");
INSERT INTO llu_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ma a Jesus e oolisia ka urii, <<Iiuka, i nau na naa. Ma i oe tara oko rikia na Wela nia Iimola gi ka gwouru i bali aba aaolo ana na God ana rigitaa, ma i nia ka lea mai faasia i langi i fafona na barobaro gi.>> ");
INSERT INTO llu_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Sui na wane fooanigwou nae e karia na maku tekwa nia uria ka faatainia na rakehasulaa nia, ma ka bae urii, <<Golu kesi dooria lau ta si baea ni faamamanalaa! ");
INSERT INTO llu_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","I gomolu molu ka tala rongoa naa si baelaa taꞌa nia gi nae! Molu manata utaa suli nia?>> Ma i gera sui go daka haea hasa i nia e garo naa, ma i nia e bobola fai nia daka haumaeli nia naa. ");
INSERT INTO llu_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ma teni tooa ada daka hafalia na ngisufilana a Jesus, ma daka kani bokosia na maana ma daka gumulia. Ma daka bae urii, <<O haea fasi ni tei na e gumuli oe nae?>> Ma na wane fofolo gi daka talaia ma daka fidalia. ");
INSERT INTO llu_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","A Peter e too ua go ana i laona na labata ana luma i maa si kada tee aai ada na haari ni rao nia gi na wane fooanigwou e lea mai. ");
INSERT INTO llu_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ma si kada ni nia ka rikia a Peter na e hara ana, nia ka ada oꞌolo kou fuana, ma ka bae urii, <<I oe laugo baa o too fai nia a Jesus, na wane baa faasia na maefera i Nasaret.>> ");
INSERT INTO llu_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Sui a Peter e kwaigoloi ka urii, <<I nau ku lalafusia, ma e langi kusi haitamana na doo na o bae sulia.>> Ma i nia ka haga kou i maa. Ma ana si kada nae ua go, na kakaraikua ka ai naa. ");
INSERT INTO llu_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ma na haari ni rao nae e riki nia lau i seenae, ma ka bae urii fuada na tooa na da take galigalia seenae, <<I nia na tee wane ada laugo naa!>> ");
INSERT INTO llu_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ma a Peter ka tofea laugo. Ma si kada toꞌou i buira, na tooa nae gi na da take garangi daka bae urii lau fuana a Peter, <<Ni oe e afetai oko tofea hasa oe e langi lau ta wane ada, sulia ni oe laugo naa o lea mai faasia na bali fera i Galili.>> ");
INSERT INTO llu_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Sui a Peter e bae aalafuu ka urii, <<A God ka falea na kwaelaa fuagu lea so ni nau kusi bae mamana! I nau e langi kusi haitamana na wane na molu bae sulia!>> ");
INSERT INTO llu_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ma ana si kada nae ua go, na kakaraikua ka aangi ana ruana si manga. Ma a Peter ka manatatoona si baea baa a Jesus e haea fuana baa e urii, <<I nao ana na kakaraikua ka aangi ana roo si kada, i oe oko haea o lalafusi nau ana oolu si kada.>> Ma si kada a Peter e manatatoona si doo nae, nia ka aangi na ana. ");
INSERT INTO llu_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","I ofaidani ua, na fataabu baita gi da oofu aliꞌali mai fai gera na wane baita gi ma na wane faatolomai gi ana na kwaieresia gi ma na figua ana na wane ni keketo gi, ma daka haungai manataa naa. Sui gera ka kania a Jesus ana seni, ma daka talaia kou uria falelana fuana a Paelat na wane baita faasia a Rom. ");
INSERT INTO llu_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ma a Paelat e ledia urii, <<E utaa? I oe naa na Aaofia gera tooa i Jiu gi naa?>> Ma a Jesus e oolisia ka urii, <<I oe o haea naa nae.>> ");
INSERT INTO llu_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Na fataabu baita gi daka feengia ana doo oro gi. ");
INSERT INTO llu_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ma a Paelat e ledia lau ka urii, <<O rongoa fasi na doo oro gi na da haea suli oe! Utaa naa osi oolisia go?>> ");
INSERT INTO llu_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Sui, a Jesus kasi oolisia go ana tesi baea boro, ma a Paelat ka kwele asianaa. ");
INSERT INTO llu_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Haia, ana na Fangaa ana Lofoagaua gi sui, a Paelat e haitamana ka faahaga ta wane faasia laona na beu ni kanilaa naa na tooa gi da gani uria. ");
INSERT INTO llu_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ma ana si kada nae, tee wane na hatana a Barabas e too laugo i laona na beu ni kanilaa fai nia na wane taꞌa gi na da hau wane laona na firua. ");
INSERT INTO llu_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ma si kada na figua gi da figu mai, daka gania a Paelat uria si doo naa e ita ka iilia mai ana si kada urinae. ");
INSERT INTO llu_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ma i nia e ledi gera ka urii, <<I gomolu molu dooria hai so nau kuka faahaga na Aaofia gamu na tooa gi i Jiu fuagamu?>> ");
INSERT INTO llu_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Sulia nia e haitamana sui naa na fataabu baita gi da falea mai a Jesus siana sulia da kwaifii ani nia. ");
INSERT INTO llu_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Sui taa, na fataabu baita gi da baenaona na figua hai so daka gania a Paelat hai ka faahaga mai a Barabas fuada. ");
INSERT INTO llu_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ma a Paelat ka bae lau urii fuada na figua, <<Lea urinae, tesi taa na tara kuka iilia ana na wane na molu alangia ana na Aaofia gamu na tooa gi i Jiu?>> ");
INSERT INTO llu_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ma gera rii daka urii, <<Oko haungia, oko fotoi fafona na airarafolo!>> ");
INSERT INTO llu_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ma a Paelat e ledida ka urii, <<Uria taa? Si garolaa taa naa nia e iilia?>> Ma gera rii ka baita tasa lau daka urii, <<Fotoi i fafona na airarafolo!>> ");
INSERT INTO llu_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ma a Paelat e faahaga kou a Barabas fuada, sulia nia e dooria ka faadianaa na manatalana na figua. Sui nia ka falea a Jesus uria na rabusilana ma ka falea uria na fotoilana i fafona na airarafolo. ");
INSERT INTO llu_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Na wane ana oomea gi daka talaia naa a Jesus i laona na labata ana luma nia na wane baita, ma da soea mai na wane ana oomea gi sui. ");
INSERT INTO llu_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ma gera ka faaruufia ana tee maku kekeroa tekwa, ma daka eꞌerea na tee eregwou ana na torakaukau, ma daka aalua i ketena iilingia ta aaofia. ");
INSERT INTO llu_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Sui daka iilifainia na faabaitalana ma da bae urii, <<Na Aaofia gera i Jiu gi, o mouri ka tau!>> ");
INSERT INTO llu_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Sui daka kwaea ketena ana ai, ma gera ka ngisufia, ma daka boururu i naofana iilingia gera faabaita nia. ");
INSERT INTO llu_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ma si kada gera faawaela ana sui, gera ka lafua na maku kekeroa tekwa naa faasia, sui daka faaruufia ana maku nia ua go. Sui gera ka talaia naa uria na fotoilana i fafona na airarafolo. ");
INSERT INTO llu_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ma ana si kada gera lea ana sulia na tala, da daotoona tee wane hatana a Simon e lea mai ana faasia si maefera ete uria i Jerusalem. Ma na wane oomea gi da suungainia hai so ka koua na airarafolo nia a Jesus. A Simon nae, i nia na maa nia a Aleksanda ma Rufus. Nia na wane faasia na fera Saeren. ");
INSERT INTO llu_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ma gera talaia kou a Jesus uria tesi gula na da alangia ana i Golgota. Ma na malutana e urii, <<Na Lelete.>> ");
INSERT INTO llu_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ma gera ka falea na waen na da dolalia fai nia tee ai gera alangia ana na mira, sui a Jesus langi kasi gwoufia go. ");
INSERT INTO llu_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ma da fotoinia i fafona na airarafolo. Sui gera ka tolingia na maku nia gi i matangada kwailiu, daka lalaba ana na daisi hai so daka daotoona ni tei ada ka ngalia ana tesi maku. ");
INSERT INTO llu_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Gera fotoi nia i fafona na airarafolo ana na kade hato i ubongi. ");
INSERT INTO llu_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ma gera ka aalua tesi kekedelaa suli nia daka urii, <<Na Aaofia gera na tooa gi i Jiu.>> ");
INSERT INTO llu_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Ma gera ka fotoinia laugo roo wane bebeli gi i fafona na roo airarafolo gi fai nia a Jesus, tee wane i bali aaolo ana ma tee wane aai i bali mouli ana. ");
INSERT INTO llu_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ma na tooa naa gi da liu, gera ka kwaelangainia na gwouda, ma daka bae tataga kou fuana a Jesus, ma daka bae urii, <<Oii! I oe baa o haea tara oko oogosia na Beu Aabu nia a God, ma oko tolea laugo i laona na oolu fe dani! ");
INSERT INTO llu_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","O faamouri oe fasi i talamu ma oko sifo mai faasia na airarafolo!>> ");
INSERT INTO llu_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ma na fataabu baita gi ma na wane faatolomai gi ana na kwaieresia gi, daka bae urinae laugo. Ma gera ka bae onionga ana a Jesus, ma daka bae urii fuada kwailiu, <<I nia e faamouria tooa eꞌete gi, sui e langi kasi bobola uria na faamourilana i talana! ");
INSERT INTO llu_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Golu rikia fasi agolu lea so nia a Christ, na Aaofia gami na tooa gi i Jiu, ma tara ka sifo mai si kada naa ua go faasia na airarafolo, hai golu ka manata mamana ani nia!>> Ma na roo wane aai baa gi na da fotoida i fafona na airarafolo gi fai nia a Jesus, daaro boro daaro bae tataga laugo ani nia. ");
INSERT INTO llu_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","E ita initoona na hato, na lolofaa nae loulou ka rorodoa, lelea ka dao ana kade hato i haulafi. ");
INSERT INTO llu_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ma ana na kade hato nae i haulafi, a Jesus e rii baita ma ka urii, <<Eloi, Eloi, lama sabaktani?>> Ma na malutana si baelaa nae gi e urii, <<God nau ae, God nau ae, uria taa na oko lugasi nau?>> ");
INSERT INTO llu_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ma teni tooa gi na da too i seenae daka rongoa, ma daka bae urii, <<Molu fafurongo fasi, i nia e soe uria a Elaeja!>> ");
INSERT INTO llu_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ma tee wane ada e lalao kou, ma ka faafungu tesi fulo ana na waen afae, ma ka aalua i maana si ai, ma ka falea kou i maana ngiduna a Jesus hai so i nia ka gwoufia, ma ka bae urii, <<Golu aada fasi lea so a Elaeja ka lea mai ma ka lafu nia mai aano faasia na airarafolo!>> ");
INSERT INTO llu_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ma a Jesus e rii baita, sui ka mae naa. ");
INSERT INTO llu_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ma na maku na e bokosia na gula aabu i laona na Beu Aabu nia a God e kakari ita mai i langi lea ka dao i aano. ");
INSERT INTO llu_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ma na wane baita gera gi na wane ni oomea gi, na e take i seenae i aena na airarafolo, e rongoa na riilana ma ka rikia na maelana, i nia ka bae urii, <<Na wane naa na Wela nia a God mamana go!>> ");
INSERT INTO llu_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ma teni geni gi da too laugo tau kou, ma daka aada go ada kou. Ma gera naa ni Mary na e faasia fera Magdala ma ni Mary na tee nia a James na wela i buri ma a Joses, ma ni Salome. ");
INSERT INTO llu_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","I gera laugo da lelea i buira a Jesus ana si kada nia e too ua ana i Galili, ma daka adomi nia. Ma na geni oro gi laugo, na da lea mai fai nia uria i Jerusalem, da too laugo i seenae. ");
INSERT INTO llu_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Ma i haulafia na naa, a Josef na wane faasia na fera i Arimetea e lea mai. Nia naa tee wane ada na wane baita gi, ma ka kwaimaasi laugo uria na rikilana Initooa nia a God. I nia e rakea ma ka lea i siana a Paelat, ma ka gani uria na nonina a Jesus, sulia fe dani nae fe dani ana na aade aagaulaa ka maasia maedani ana Sabat. ");
INSERT INTO llu_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ma a Paelat ka kwele ana na rongolana a Jesus e mae naa. Ma nia ka soea na wane baita ada na wane ni oomea gi ma ka ledia lea so a Jesus ka mae katau ua naa. ");
INSERT INTO llu_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ma i buira, a Paelat e rongoa na wane baita nae e haea nia e mae naa, a Paelat kafi faalamainia a Josef hai ka ngalia na nonina a Jesus. ");
INSERT INTO llu_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Sui a Josef ka folia tesi maku kwakwaoa, ma ka lafua na nonina a Jesus i aano, ma ka afua ana si maku nae, ma ka aalua i laona na kwaingeia na da garumia i laona na fou. Sui ka gelua tee fou baita ma ka bokosia na maana na kwaingeia nae. ");
INSERT INTO llu_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ma ni Mary na faasia i Magdala ma ni Mary na tee nia a Joses daaro bubu go adaaro, ma daaro ka rikia si gula na da aalua ana a Jesus. ");
INSERT INTO llu_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","I buira maedani ana Sabat e sui, ana maedani Sandei, ni Mary na e faasia fera i Magdala ma ni Mary na tee nia a James, ma ni Salome, da folia mai na doo mokomoko diana gi uria na gwailana ana nonina a Jesus. ");
INSERT INTO llu_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","I ofaidani ua ana Sandei, daka lea mai siana na kwaingeia. ");
INSERT INTO llu_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Si kada gera lea, gera ka ledi gera kwailiu daka urii, <<Ni tei naa tara ka gelua na fou baa faasia i maana na kwaingeia?>> Sulia na fou nae e baita asianaa. ");
INSERT INTO llu_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Sui taa, si kada gera dao ana, daka rikia na fou baa gera gelua sui naa. ");
INSERT INTO llu_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ma si kada da ruu kou i laona na kwaingeia, daka rikia tee wane daraa e oofi ana maku kwakwaoa ma ka gwouru ana i bali aaolo ana si gula baa da aalua ana a Jesus. Ma daalu ka mou asianaa. ");
INSERT INTO llu_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ma i nia ka bae urii, <<E langi molu si mou. I nau ku haitamana molu nani uria a Jesus, na wane i Nasaret, na da haungia i fafona na airarafolo. I nia e langi si too naa i seenaa. Sulia nia e tatae naa faasia maea! Molu lea mai, molu ka rikia na gula baa gera aalu nia ana. ");
INSERT INTO llu_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Haia, molu lea kou siada oote fafurongo nia baa gi fai nia a Peter, ma molu ka falea si faarongolaa naa fuada, <A Jesus e lea naa i nao maasi gomolu i Galili, ma tara molu ka riki nia naa i seenae iilingia baa e haea sui fuagamu.>>> ");
INSERT INTO llu_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ma na geni nae gi da haga kou i maa, ma daka lalao naa faasia na kwaingeia nae, sulia da mou ma daka lelebe asianaa. Langi dasi haea naa tesi doo fuana ta wane sulia da mou asianaa. ");
INSERT INTO llu_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","I ofaidani ana Sandei, a Jesus e mouri lau ma ka faatai fuana ni Mary Magdala, na aai baa a Jesus e taria na fiu aagalo taꞌa baa gi faasia. ");
INSERT INTO llu_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ma ni Mary e lea siada na fafurongo nia gi. Gera da liodila ma daka aangi. Ma ni Mary e faarongo ana fuada. ");
INSERT INTO llu_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ma ana si kada da rongoa naa a Jesus e mouri, ma nia ka rikia naa, e langi dasi manata mamana go ani nia. ");
INSERT INTO llu_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ma i buri lau, a Jesus ka faatai eꞌete laugo ana fuana ta roo wane fafurongo aai gi, si kada daaro lea naa sulia na tala faasia i Jerusalem. ");
INSERT INTO llu_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ma daaro ooli mai ma daaro ka faarongoa na oote fafurongo aai baa gi, sui taa e langi dasi manata mamana go. ");
INSERT INTO llu_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ma i buira naa, a Jesus ka faatai fuana na aakwala ma tee wane ana fafurongo nia baa gi si kada gera fanga ada. Ma i nia ka ngatafi gera sulia e langi dasi manata mamana, ma sulia i gera da aufaka asianaa uria na manata mamanalaa ana na tooa gi na da riki nia naa i buira na mouri oolilana. ");
INSERT INTO llu_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ma i nia ka bae urii fuada, <<Muka lea i laona na molaagali sui, ma muka ainitalo ana Faarongolaa Diana fuana na tooa gi sui. ");
INSERT INTO llu_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ma so ni tei naa e manata mamana ma ka siuabu, tara nia ka mouri. Ma so ni tei na e langi kasi manata mamana, i nia ka mae. ");
INSERT INTO llu_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ma na tooa gi na da manata mamana, daka too ana mamana uria iililana si mamalafooa naa gi na e urii: I gera daka taria na aagalo taꞌa gi ana na hatagu, ma daka bae ana na baelaa eꞌete gi. ");
INSERT INTO llu_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ma lea gera koua na loi gi ma langi daka gwoufia na doo bubulo, tesi doo kasi iili gera go. Ma lea gera aalua na abada i fafona na tooa matai gi, gera ka akwaa lau.>> ");
INSERT INTO llu_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","I buira na a Jesus na Lord e bae fai gera, i nia ka lea naa uria i langi, ma ka gwouru i bali aaolo ana a God. ");
INSERT INTO llu_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ma na oote fafurongo nia gi da lea, ma daka funao ana si gula gi sui, ma a Lord ka rao fai gera. Ma ka falea na mamanaa fuada uria iililana doo kwele gi hai so ka faamamanaa na doo na da funaolaa e mamana.");
INSERT INTO llu_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","A Tiofilas ae, na tooa oro da kekede sulia si doo gi sui na e fuli i matangamelu. ");
INSERT INTO llu_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Gera daka kedea si doo gi na gia rongoa faasia na iimola gi na da rikia si doo naa gi totongenao ma daka faataloa na faarongolaa nae fuaga. ");
INSERT INTO llu_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Nia naa wane baita ae, i nau ku manata hasa e diana hai so ku kekede sulia si doo naa gi fuamu, sulia i nau ku nanisi diana na ana si doo naa gi sui ita mai ana hafalilana uunuunua naa. ");
INSERT INTO llu_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ma i nau ku kede sulida si doo naa gi eeri oko haitamana na mamanalada teefou si doo nae gi sui na da toolamainia fuamu. ");
INSERT INTO llu_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ana si kada a Herod e aaofia ana lolofaa i Judea, tee fataabu na hatana a Sekaraea e too laugo ana si kada nae, ma i nia e too ana figulaa ana fooalaa na hatana Abaeja. Na afe nia ni Elisabet laugo e lea mai faasia na aebara nae da fataabu na da ita mai ana Aaron. ");
INSERT INTO llu_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Na mourilaa daaro sui e oꞌolo ma ka diana i maana God, sulia daaro rongosuli diana asianaa ana na kwaieresia fai nia na baefifilaa a Lord gi teefou. ");
INSERT INTO llu_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ma tesi doo go, daaro langi daaro si too go ana ta wela sulia ni Elisabet na e abaꞌato. Ma daaro na aarai nia a Sekaraea daaro ka waro naa laugo. ");
INSERT INTO llu_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Tee maedani a Sekaraea e lea i Beu Aabu a God, sulia si kada nae na kada na figulaa a Sekaraea uria na iililana raoa gera fataabu. ");
INSERT INTO llu_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Na malutana lea doo na fataabu gi da iilia uria na aadafililana ta fataabu lau, na e urii: lea doo daka uinia daisi uria na fililana ni tei faalu na eeri ka iilia lau na raoa nia fataabu uria na suungilana ai moko diana i fafona fuliere i laona Beu Aabu a God. Ana si kada da aadafilia a Sekaraea, nia ka ruu i laona Beu Aabu, ");
INSERT INTO llu_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","ma na tooa gi na da too i maa daka fooa ana si kada hato nae nia e suungia ana na ai moko diana. ");
INSERT INTO llu_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Sui tee ensel a Lord ka faatai fuana, ka take i bali aaolo ana fuliere nae. ");
INSERT INTO llu_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Kada Sekaraea e aadasia na ensel nae, nia e tona ma ka mou asianaa. ");
INSERT INTO llu_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Sui na ensel nae ka bae urii fuana, <<Sekaraea, langi osi mou! A God e rongoa na lingeena fooalaa oe, ma na afe oe ni Elisabet tara ka faafutaa tee wela wane. Oko alangia ana John. ");
INSERT INTO llu_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Tara oko eele asianaa, ma na tooa gi laugo daka eele ana si kada nia e futa mai ana! ");
INSERT INTO llu_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Sulia nia na wane baita i maana God. Nia ka langi si gwoufia ta waen ma langi so ta gwoulaa bubulo. Ma ana si kada nia e futa mai, nia ka fungu na ana Aanoedoo Aabu. ");
INSERT INTO llu_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Nia tara ka oolifainia mai na tooa oro gi i Israel fuana Lord na God gera. ");
INSERT INTO llu_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ma tara nia ka eeta na mai i nao ana a Lord, ma tara ka rigita iilingia a profet Elaeja baa. Ni tei gera na da oolisusuu, i nia ka ooguda lau, eeri na maa gi ma na wela gera gi daka rakediana fuada kwailiu. Ma tara nia ka adomia na tooa na da aaburongo, eeri daka manata ooli ma daka iilia doo oꞌolo gi. Ma tara nia ka aade aagau ana na tooa a Lord, eeri daka maasia na lealana mai.>> ");
INSERT INTO llu_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sui a Sekaraea ka bae urii fuana ensel nae, <<Tara kuka haitamana utaa ana mamanalana si doo naa? Sulia i nau fai nia na afe nau, mere waro sui naa.>> ");
INSERT INTO llu_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Na ensel e oolisia ka bae urii: <<I nau a Gebriel, na ku too fai nia God sulia dani. Haia, a God naa e oodu nau mai, eeri kuka faarai fai oe ma kuka faarongo oe ana si faarongolaa diana naa. ");
INSERT INTO llu_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Haia, ma ni oe osi manata mamana go ana si faarongolaa nau na oto naa, si faarongolaa na tara oko rikia na mamanalana ana si kada na a God e aalua eeri ka fuli ana. Ma sulia na osi manata mamana ana baelagu, na fakamu ka ato ma langi osi faarai tafa lelea ka dao ana si kada na doo na ku bae i nao ana fuamu naa ka mamana.>> ");
INSERT INTO llu_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ana si kada nae na tooa gi na da too maasia Sekaraea daka kwele asianaa, sulia nia too tau mai i laona Beu Aabu. ");
INSERT INTO llu_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ma si kada a Sekaraea e lea mai i maa siana tooa nae gi, na fakana ka ato na ana, ma ka langi si faarai naa fai nia na tooa nae gi. Urinae go na tooa gi sui daka manata na urii: <<E langi si langi, i nia e rikia ta faataia i laona Beu Aabu.>> Sulia na fakana e ato, ma nia ka faarai go ana ana abana fuana tooa. ");
INSERT INTO llu_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ma ana si kada fe dani nia gi uria na raolaa i Beu Aabu e sui naa, a Sekaraea kafi ooli fui fera nia. ");
INSERT INTO llu_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ma e langi si tau i buira, na afe nia ni Elisabet ka iiana naa, ma ka langi si liliu naa i maa faasia luma daaro sulia lima fe sinali, ");
INSERT INTO llu_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","ma nia ka bae urii, <<Si kada naa, a Lord e adomi nau naa, ma ka lafua faasi nau na idalaa baa ku too mai laona ana abaꞌatolaa na e iili nau i maana tooa gi.>> ");
INSERT INTO llu_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Si kada ni Elisabet e too iiana sulia oono fe sinali e sui, a God ka oodua mai ensel Gebriel fuana tee maefera i Galili da alangia ana i Nasaret. ");
INSERT INTO llu_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Nia e ngalia mai si faarongoa fuana tee haari na da baetoona fuana wane na hatana a Josef eeri ka aadea. A Josef e lea mai faasia na kwalafaa a David na aaofia. Na hatana haari nae ni Mary. ");
INSERT INTO llu_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Na ensel e lea mai, ka bae urii fuana, <<Ubongi diana! A Lord e too fai oe, ma ka faadiana oe ka baita asianaa!>> ");
INSERT INTO llu_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Kada ni Mary e rongoa na baelana ensel nae, nia ka manata aꞌabo, ma ka nanisia na malutana si baelaa nae gi na ensel e haea fuana. ");
INSERT INTO llu_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Sui na ensel ka bae lau urii fuana, <<Mary ae, langi osi mou, sulia God e rakediana asianaa fuamu. ");
INSERT INTO llu_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Aena nana tara oko iiana, ma oko faafutaa tee wela wane, ma oko alangia ana Jesus. ");
INSERT INTO llu_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ma na babaitaa nia tara ka tasa ana wane gi sui, ma daka alangi nia ana Wela a God mai i langi liu. A Lord God ka falea nia ka Aaofia iilingia koo nia a David. ");
INSERT INTO llu_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ma nia ka too ana aaofialaa fuagera Jiu gi na kwalafuta ana Jakob totoo firi, ma na Initooa nia ka langi si sui!>> ");
INSERT INTO llu_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ma ni Mary ka bae urii fuana ensel nae, <<I nau ku haari ua go agu urii naa. Tara na baea naa gi o haeda fuagu na tara ka mamana utaa?>> ");
INSERT INTO llu_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ma na ensel e oolisia ka urii, <<Na Aanoedoo Aabu na tara ka sifo mai faafi oe, ma na mamanaa God ka too fai oe. Aena nana na Wela Aabu naa, tara daka alangi nia ana na Wela a God. ");
INSERT INTO llu_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Oe o haitamana ni aaia oe ni Elisabet. Na iimola gi sui da haea nia e afetai na fuana ka too ana ta wela. Sui i taraꞌena nia e iiana naa, ma fe sinali naa na oono naa fe sinali nia naa, sui boroi ana nia ka waro. ");
INSERT INTO llu_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Sulia e langi tesi doo so ka afetai ana God.>> ");
INSERT INTO llu_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ma ni Mary ka bae urii, <<Nau ku dooria si doo naa gi na o haeda ka dao mamana mai fuagu, sulia ni nau na geni raolaa a Lord.>> Si kada ni Mary e bae urinae sui, na ensel kafi lea na ana. ");
INSERT INTO llu_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ana si kada nae, ni Mary ka aade aagau, ma ka lea aliꞌali naa uria tee fera toꞌou i tolo ana bali lolofaa i Judea. ");
INSERT INTO llu_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Kada nia e dao, nia ka ruu i luma a Sekaraea, ma ka bae kwaiofeia fuana ni Elisabet. ");
INSERT INTO llu_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ma si kada ni Elisabet e rongoa na baelana ni Mary, na wela nae i nia e iiana ana ka gelo i rakena. Ma na Aanoedoo Aabu ka fungulia ni Elisabet, ");
INSERT INTO llu_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ma nia ka bae baita ma ka urii, <<Na oilakea fuamu liufia na geni gi sui, ma ka oilakea laugo fuana na wela na o iiana ana. ");
INSERT INTO llu_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Uria taa na si doo baita naa ka fuli fuagu, hasa ni tee nia na Lord nau ka lea mai uria na maatoolagu? ");
INSERT INTO llu_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Sulia si kada ku rongoa go na baelaa oe gi, na wela na ku iiana ana naa ka gelogelo lao rakegu sulia nia e eele asianaa. ");
INSERT INTO llu_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ka oilakea laugo fuamu sulia o manata mamana ana baelana a God fuamu tara ka fuli.>> ");
INSERT INTO llu_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ma ni Mary ka bae urii, <<Na mourilagu e silia a Lord, ");
INSERT INTO llu_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ma na mangogu e eele sulia a God na e faamouri nau. ");
INSERT INTO llu_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Nau ku sili agu suli nia, sulia nia ka manatatoogu i nau na geni ku neena go agu, ma ku too go agu uria na raolaa fuana. E ita i taraꞌena ka ooli alaa, na tooa gi sui daka haea i nau ku too ana oilakea e baita, ");
INSERT INTO llu_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","sulia na doo baita naa gi na God ana rigitalana sui e iilia fuagu. Ma na hatana e aabu. ");
INSERT INTO llu_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","E ita i taraꞌena ka ooli alaa sulia na kwalafaa gi sui, i nia e faatainia kwaimanataia nia fuana tooa gi sui na da manata baita ani nia. ");
INSERT INTO llu_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","I nia e tekwalaa na abana na e rigita asianaa, ma ka tagalangainia na tooa gi na da tango gera i talada eeri langi dasi iilia doo taꞌa gi na daka manata ana. ");
INSERT INTO llu_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","I nia e faasifoa na aaofia initoo gi faasia na fuli gwourua gera gi, ma ka faaꞌinitooa tooa da neena gi. ");
INSERT INTO llu_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Na tooa da fiolo, nia e hangoni gera ana doo diana gi, ma ka faasiofaa tooa da todadoo gi. ");
INSERT INTO llu_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Nia e manatatoona na bae aalangaia nia e iilia fuana koo gia gi, ma ka adomi gia na tooa nia gi i Israel. ");
INSERT INTO llu_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","I nia e langi si manata buro ana na faatailana kwaimanataia nia fuana Abraham, ma fuaga na kwalafaa nia gi totoo firi!>> ");
INSERT INTO llu_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ni Mary e too fai nia ni Elisabet e bobola fai nia oolu fe sinali, ma nia kafi ooli fui fera nia. ");
INSERT INTO llu_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Si kada ni Elisabet uria na faafutalaa e dao naa, i nia ka kwalafia tee wela wane. ");
INSERT INTO llu_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Na tooa kwaimaani nia gi ma na tooa gi sui go ana aebara nia, da rongoa si aadelaa diana naa a Lord e iilia fuana, ma daka eele baita asianaa faafia. ");
INSERT INTO llu_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Na wela nae e futa mai, na fiu maedani e sui go, daka roosulia na malutaa gera Jiu gi uria ole-marikolana. Ma daka dooria alangi nia ana Sekaraea sulia na hatana maa nia. ");
INSERT INTO llu_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Sui ni tee nia ka oolisida urii, <<Langi musi alangia ana hata nae! Na hatana a John.>> ");
INSERT INTO llu_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ma na tooa gi sui gera oolisi nia daka urii, <<Langi ta wane ana aebara gomoro na e too ana hata nae.>> ");
INSERT INTO llu_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Sui daka faarai ana abada, daka falea mamalafooa fuana maa nia a Sekaraea, ma daka ledia uria hata taa na e dooria daka alangia ana wela naa. ");
INSERT INTO llu_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sui a Sekaraea ka soe uria tee si abe doo ni kekedelaa, ma ka kekede urii, <<Na hatana wela naa a John.>> Na tooa gi sui daka kwele asianaa. ");
INSERT INTO llu_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ma ana si kada nae laugo, na fakana Sekaraea ka ifi naa, ma ka silia naa a God. ");
INSERT INTO llu_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ma na tooa gi sui go na da oogu mai seenae, daka mou asianaa, ma na faarongolaa sulia na doo nae gi ka talofia na tooa da too i tolo gi i laona lolofaa i Judea gi teefou. ");
INSERT INTO llu_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ma na tooa gi sui go na da rongoa doo nae gi daka manata galida, ma daka bae urii, <<Na wela naa, tara nia hau ana wane taa?>> Gera da bae urinae, sulia gera haitamana na mamanaa a God e too fai nia wela nae. ");
INSERT INTO llu_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","A Sekaraea na maa a John e fungu ana Aanoedoo Aabu, ma ka ainitalongainia na faarongolaa nia a God ka bae urii, ");
INSERT INTO llu_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","<<Gia ka silia a Lord, na God gera tooa Jiu. Nia e lea mai uria na adomilaga na tooa nia, ma uria na faamourilaga. ");
INSERT INTO llu_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Nia e falea fuaga tee Faamouria na e too ana rigitaa baita, na e lea mai faasia kwalafaa a David na aaofia, na wane ni raolaa a Lord. ");
INSERT INTO llu_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Nia e bae i nao ua na mai fuaga i nao ua ana si doo naa gi, ana baelana profet aabu gi i nao, ");
INSERT INTO llu_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","eeri nia ka faamouri gia faasia na maalimaea gia gi ma faasia na initooa gera na tooa gi na da sinatai gia. ");
INSERT INTO llu_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Nia ka bae i nao ua na mai tara nia ka faatainia na kwaimanatailaa nia fuana koo gia gi, ma nia ka manatatoona na bae aalualua aabu nia gi, ");
INSERT INTO llu_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","e iilia fuana koo gia a Abraham i laona bae aalafuulaa nia fuana, na tara nia ka dilangai gia faasia na maalimaea gia gi, ");
INSERT INTO llu_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","eeri gia ka rao fuana ma langi gia si mou, ");
INSERT INTO llu_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ma eeri gia ka too oꞌolo i naona sulia dani.>> ");
INSERT INTO llu_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ma Sekaraea ka bae urii fuana wela nia, <<Ni oe wela nau ae, daka alangi oe ana profet nia God na e baita ka tasa. Ma oe oko eeta i nao ana Lord, eeri oko aade aagau ana tala maasi nia. ");
INSERT INTO llu_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ma eeri oko faarongoa na tooa nia gi, na tara daka too ana mouria si kada a God ka manata luke ana na doo fualangaa gera gi. ");
INSERT INTO llu_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","A God gia, i nia e kwaimanatai ma ka harofaia. I nia ka faamouri gia, iilingia nia ka tataea hato ana ubongi gi. ");
INSERT INTO llu_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ma nia e adomi gia, eeri langi gia si moungia na maea, ma eeri gia ka haitamana aabulo dianalaa ana fanualama.>> ");
INSERT INTO llu_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Haia, na wela nae ka baita ana noni, ma na manatana ka rigita teefou. Ma si kada nia e baita, nia ka too i aanogwou lelea ka dao ana fe dani nia e hagatafa faatai fuana tooa gi i Israel. ");
INSERT INTO llu_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ana si kada nae, na wane initoo ana fera baita i Rom na hatana a Ogastas, nia e aalua si kwaieresia fuana tooa gi sui, eeri daka lea i fera koo gera gi uria na kedelana hatada. ");
INSERT INTO llu_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ma si kada na eetana kekedelaa na gera iilia, a Kwirinias na e initoo usia lolofaa i Siria. ");
INSERT INTO llu_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ma na tooa gi sui go daka lea uria na kedelana hatada, tee wane uria aefera nia, ma tee wane uria aefera nia. ");
INSERT INTO llu_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ma a Josef e lea laugo mai faasia na fera nia i Nasaret ana lolofaa i Galili, ma ka lea fuana lolofaa i Judea uria na aefera a David na Aaofia na gera alangia ana i Betlehem, sulia a Josef nia na wane ana kwalafaa a David. ");
INSERT INTO llu_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","A Josef e lea uria na kedelana na hatana fai nia ni Mary, na geni baa da aalu faafia fuana. Ma ana si kada nae, ni Mary e iiana naa. ");
INSERT INTO llu_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ma ana si kada daaro too i Betlehem, i nia e aade aagau uria faafutalaa naa. ");
INSERT INTO llu_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ma nia ka faafuta na wela wane uulunao nia, ma ka afua ana si maku gi, ma ka faateoa i laona si lifu ni hangoni bulumakau, sulia daaro too go adaaro i laona babala fuana doo fai ae gi, sulia e langi ta luma eeri daaro ka too ana. ");
INSERT INTO llu_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Haia, na tooa da aadasulia sipsip gi, gera da too garangia laugo na fera nae, ma gera ka aadasulia na sipsip gera gi i lao rodo. ");
INSERT INTO llu_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ma na ensel a God ka faatai fuada, ma na raralana a God ka talafi gera, ma gera ka mou asianaa. ");
INSERT INTO llu_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ma na ensel nae ka bae urii fuada, <<Langi musi mou. Sulia nau ku ngalia mai faarongolaa diana na e faaeleele asianaa fuana na iimola gi sui. ");
INSERT INTO llu_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Sulia taraꞌena na Faamouria gamu e futa i laona aefera a David, ma i nia na Christ na Lord. ");
INSERT INTO llu_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ma na mamalafooa fuagamu e urii: Tara muka rikia tee wela bibiu na da afua ana maku gi ma ka teo ana si lifu ni hangoni bulumakau.>> ");
INSERT INTO llu_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ma ana si kada nae, molee ensel faasia i langi da faatai ma daka silia a God daka urii, ");
INSERT INTO llu_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","<<Na initooa fuana a God i langi, ma na fanualama fuana tooa gi i aano na God e rakediana fuada.>> ");
INSERT INTO llu_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","I buira na ensel gi da ooli naa fui langi, na wane aadasuli sipsip nae gi da faarai kwailiu fuada daka urii, <<Golu lea fasi uria i Betlehem eeri golu ka rikia fasi si doo naa gi naa a God e bae sulia fuagolu.>> ");
INSERT INTO llu_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ma gera ka lea aliꞌali, ma daka daotoona ni Mary fai nia a Josef, ma daka rikia na wela bibiu na e teo ana si lifu ni hangoni bulumakau. ");
INSERT INTO llu_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ma si kada gera riki nia, gera ka faataloa naa si doo nae gi na ensel e haea fuada sulia na wela naa. ");
INSERT INTO llu_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ma na iimola gi da rongoa daka kwele asianaa ana si uunuunua naa gera faarongo ana. ");
INSERT INTO llu_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ma ni Mary e manatatoona si doo naa gi, ma ka manata fifii sulida katau. ");
INSERT INTO llu_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ma na wane aadasuli sipsip gi da ooli, ma daka baelafea a God faafia si doo gi sui na gera rongoa ma daka rikia laugo na e iilingia mamana naa si doo gi na ensel e haea fuada. ");
INSERT INTO llu_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Haia, ana fe wiki i buira, ana si kada da ole-mariko ana wela nae, daaro alangia ana a Jesus, na hata baa na ensel e falea ua go fuana si kada ni Mary e langi kasi iiana ua. ");
INSERT INTO llu_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Haia, si kada e dao fuana a Josef fai nia ni Mary daaro ka faafaalu naa iilingia na kwaieresia baa a Moses e haea naa. Urinae go, daaro ka ngalia na wela nae fui Jerusalem eeri daaro ka falea fuana Lord, ");
INSERT INTO llu_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","iilingia baa da kedea sui na i laona kwaieresia a Lord gi da urii, <<Na uulunao wela wane daka falea fuana Lord.>> ");
INSERT INTO llu_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Daaro ka falea laugo ta kwaisuusia ana ta roo fe faofao langi ta roo fe bola, iilingia na kwaieresia a Lord e dooria. ");
INSERT INTO llu_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ma ana si kada nae, tee wane hatana a Simion e too i Jerusalem. I nia na wane diana, ma ka faamou ana God, ma ka too ni kwaimaasilaa uria si kada a God ka faamouria na tooa i Israel. Ma na Aanoedoo Aabu na e too fai nia, ");
INSERT INTO llu_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ma ka haea nia ka mouri lea ka dao ana si kada nia ka rikia na Christ na a Lord e bae aalangai ana fuada. (Na malutana <<Christ>> nia na wane na a God e filia uria aaofialaa.) ");
INSERT INTO llu_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Na Aanoedoo Aabu e talaia Simion ka lea fui Beu Aabu a God, ma nia ka daotoona a Josef fai nia ni Mary kada daaro ngalia mai na wela bibiu nae a Jesus eeri daaro ka iilia na doo gi na kwaieresia e dooria. ");
INSERT INTO llu_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Haia, a Simion ka koua na wela naa i abana, ma ka baelafea God ka urii, ");
INSERT INTO llu_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","<<Lord ae, si kada nae na bae aalangaia oe baa e mamana naa. Nia naa, kufi bobola naa uria maelaa, ma nau ku eele asianaa. ");
INSERT INTO llu_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Sulia si kada nae, i nau ku rikia na agu ana maagu i talagu na wane na o falea mai eeri ka faamouria na tooa gi. ");
INSERT INTO llu_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Nia naa wane na oe o aade aagau naa, eeri tooa gi sui tara daka rikia. ");
INSERT INTO llu_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Wane ni faamourilaa naa, nia iilingia na kwesu, sulia tara nia ka faatainia na kwaidooria oe fuana tooa maadiu gi. Ma tara nia ka faabaita gami tooa Jiu gi, na tooa oe.>> ");
INSERT INTO llu_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ma na maa ma ni tee nia, daaro ka kwele asianaa kada daaro rongoa na doo nae gi a Simion e haea sulia na wela nae. ");
INSERT INTO llu_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ma a Simion e faadiana daalu. Sui nia ka bae urii fuana ni Mary, tee nia wela nae, <<Na wela naa na wela a God e aadafilia ua go mai naa, na tooa oro gi i Israel tara daka too ana mouria suli nia, ma na orolada laugo tooa gi i Israel tara daka mae sulia da lalafusi nia. I nia na mamalafooa, eeri ka faatainia na orolana tooa gi na da oolisusuu ma daka take usia God, ");
INSERT INTO llu_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ma ka faatainia na manata haufini gera gi. Ma na liobukonua baita tara ka dao i liomu ka iilingia ta naefe ka toea na mangomu.>> ");
INSERT INTO llu_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Haia, tee oru geni e too laugo ana si kada nae, na hatana ni Ana, ma i nia tee profet laugo ma ka waro naa. Nia naa na haari nia a Faniuel faasia na aebara a Asa. Ana haarilana, nia e afe ma ka too fai nia aarai nia sulia fiu fe ngali go, ma ana si kada nae nia kwalu aakwala ma fai fe ngali. ");
INSERT INTO llu_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Nia too go ana i Beu Aabu a God uria na aabu fangalaa ma na fooalaa fuana God sulia dani ma rodo. ");
INSERT INTO llu_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ana si kade hato nae laugo, nia e dao laugo, ma ka baelafea God, ma ka faarai sulia na wela nae fuana tooa gi sui go na da too go ada maasia si kada a God ka faamouria tooa i Israel. ");
INSERT INTO llu_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Si kada a Josef fai nia ni Mary daaro faasuia na doo gi sui na kwaieresia a Lord e haea, daaro ka ooli naa fui fera daaro i Nasaret maefera laona lolofaa i Galili. ");
INSERT INTO llu_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Na wela nae e baita mai, ma ka rigita ma ka liotoo laugo. Ma a God ka faadiana nia ma ka too fai nia. ");
INSERT INTO llu_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ana fe ngali gi sui, na maa nia ma ni tee nia a Jesus daaro lea fui fera baita i Jerusalem uria fe dani baita ana na Fafangaa ana Lofoagaua. ");
INSERT INTO llu_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ma si kada a Jesus e dao ana aakwala ma roo fe ngali, daalu lea na ana fafangaa nae iilingia na malutada. ");
INSERT INTO llu_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","I buira fafangaa na e sui, na maa nia ma ni tee nia daaro ka ooli na adaaro, ma a Jesus ka too ua go ana kou i Jerusalem, ma langi daaro si haitamana go. ");
INSERT INTO llu_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Daaro manata adaaro hasa i nia e lea naa fai nia na figua nae, ma daaro ka lea na adaaro sulia fe hato loulou nae. Sui daaro fi hafalia nanilaa uri nia i matangada na iimola futa daaro gi ma na ruana daaro gi. ");
INSERT INTO llu_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ma si kada daaro nani, ma daaro si riki nia, daaro ka ooli lau uria nanilaa lau mai i Jerusalem. ");
INSERT INTO llu_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ma e dao ana ooluna fe dani, daaro kafi daotoona laona Beu Aabu a God. I nia e gwouru ana fai gera na wane faatolomai gi gera Jiu, ma ka fafurongoda ana, ma ka leledi gera ana. ");
INSERT INTO llu_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ma na iimola gi sui na da rongo nia, gera ka kwele asianaa ana haitamadooa nia ma ana si oolisilaa nia gi. ");
INSERT INTO llu_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ma si kada a Josef ma ni Mary daaro rikia, daaro ka kwele asianaa. Ma ni tee nia ka bae urii fuana, <<Wela nau ae, uria taa na oko iilia si doo naa fuamere? Na maa oe ma ni nau mere nani mai uri oe, ma mere ka manata aꞌabo asianaa.>> ");
INSERT INTO llu_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ma a Jesus e oolisi daaro ka urii, <<Uria taa na moro ka manata aꞌabo ma moro ka nani mai uri nau? E utaa? Langi moro si haitamana go na i nau ku too agu i laona Beu nia Maa nau?>> ");
INSERT INTO llu_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Haia, ma i daaro langi daaro si haitamana go na malutana si baelaa na i nia e haea fuadaaro. ");
INSERT INTO llu_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Sui a Jesus ka ooli fai daaro fui Nasaret ma ka roo naa suli daaro. Ma ni tee nia ka gonitainia ma ka manata naa uria si doo nae gi sui go katau. ");
INSERT INTO llu_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ma a Jesus ka baita mai ana noni, ma na liotooa nia ka baita laugo mai, ma a God ka rakediana fuana ma na tooa gi daka rakediana laugo fuana. ");
INSERT INTO llu_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ana si kada nae, nia dao na ana aakwala ma lima fe ngali na a Taebirias na initoo mai ana fera baita i Rom, ma a Pontias Paelat ka initoo usia i Judea, ma a Herod na wane initoo usia i Galili, ma a Filip na haasina ka baita usia i Iturea ma Trakonaetis, ma a Lisanias ka baita usia i Abilin. ");
INSERT INTO llu_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Si kada nae laugo, a Anas ma a Kaeafas na roo fooanigwou gi ana fera nae i Jerusalem. Ma ana si kada nae, na baelana a God e dao siana a John na wela a Sekaraea, si kada nia e too na i laona aanogwou. ");
INSERT INTO llu_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ma a John ka liliu ana fera gi galigalia kafo i Jodan. Ma i nia ka bae urii fuana iimola gi, <<Muka aabulo faasia na garolaa gamu gi, ma gamu ka siuabu, eeri a God ka manata lukea na garolaa gamu gi.>> ");
INSERT INTO llu_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Nia e iilingia baa na profet Aesea e kedea ka urii, <<Tee wane e rii i laona aanogwou ka urii, <Na Lord e dao! Muka aade aagau ana na tala maasi nia, ma muka olosia na tala fuana! ");
INSERT INTO llu_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ma muka dedea na kuruotea gi, ma muka faanenebaa na tolo gi ma na tataea gi. Ma molu ka olosia na tala eꞌeo gi, ma molu ka faamaemaea na tala kwalukiboa gi. ");
INSERT INTO llu_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ma na iimola gi sui tara daka rikia na wane faamouri na a God e falea mai.>>> ");
INSERT INTO llu_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Iimola oro gi da lea mai siana a John eeri ka siuabu gera. Ma a John ka bae urii fuada, <<Ni gamu mu iilingia go agamu na loi gi! Ni tei na e haea muka bobola uria tafilaa faasia na kwakwaelaa na tara a God ka falea e garangi dao naa? ");
INSERT INTO llu_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Mu iilia na doo gi na e faatainia mu aabulo mamana naa faasia na aabulolaa taꞌa gamu gi taari! Ma langi musi manata urii i laona lio gamu gi, <I gami na tooa mi futa mai ana kwalafaa a Abraham naa. Afetai ta kwakwaelaa faasia God ka dao ani gami.> Haia, nau ku haea fuagamu, nia e waluda go ana fuana God ka ngalia si fou gi ma ka haungainia ana kwalafaa a Abraham gi! ");
INSERT INTO llu_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ana si kada naa, God e aade aagau naa uria kwakwaelaa, iilingia ta wane baa e dau ana matau ma ka aade aagau uria na tabalilana ai gi. Ma na ai gi sui go na langi dasi fusia ta fufue ai diana gi, nia ka tabalida ma ka ui anida i laona eere.>> ");
INSERT INTO llu_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Sui na iimola gi da ledia a John daka urii, <<Tara si taa naa melu ka iilia?>> ");
INSERT INTO llu_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ma i nia e oolisida ka urii, <<So ni tei na e too ana roo si maku ruruu, i nia ka falea ruana si doo fuana ta wane aai na e langi si too ana ta maku ruruu. Ma lea ta wane e too ana na fanga gi, i nia ka tolingida.>> ");
INSERT INTO llu_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ma teni wane faafefe gi ni gonilana na malefo ana na takisi na da dao laugo mai uria na siuabulaa, ma da ledi nia daka urii, <<Wane faatolomai ae, tara si taa na melu ka iilia?>> ");
INSERT INTO llu_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ma a John e oolisida ka urii, <<Muka gonia go si malefo na e bobola fai nia si malefo na kwaieresia e haea. E langi molu si gani liufia si malefo nae.>> ");
INSERT INTO llu_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ma teni wane ni oomea gi da ledi nia laugo daka urii, <<Ma i gemelu mone, na taa naa tara melu ka iilia?>> Ma i nia ka bae urii fuada, <<Molu kasi suungainia ta wane eeri ka falea si malefo nia fuamolu. Ma langi molu si suge faafia ta wane. Ma molu ka eele naa faafia si malefo na da foli gomolu ana.>> ");
INSERT INTO llu_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ma na manatalada na iimola gi ka baita asianaa sulia a John , sulia da manata ada hasa i nia na Christ. ");
INSERT INTO llu_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Sui a John e bae ka urii fuada, <<I nau ku siuabu gamu go agu ana na kafo, sui tee wane aai tara ka lea mai na e baita ka liufi nau. Ma i nau boroi langi kusi faorana na lukelana na tae silipa nia. Ma i nia tara ka siuabu gamu ana Aanoedoo Aabu ma ana eere. ");
INSERT INTO llu_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ma i nia e aade aagau naa uria na ketolana iimola gi sui, ka iilingia ana ta wane baa e tagalangai nia na mige doo diana gi faasia na ungedoo gi. Ma i nia ka oogua na mige doo diana gi i laona na beu nia ni taingailaa, ma ka suungia na ungedoo gi laona na eere na e langi kasi mae.>> ");
INSERT INTO llu_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ma a John ka bae sulia na Faarongolaa Diana fuada ana na baelaa oro gi urinae, ma ka aare gera eeri daka oolisia malutada. ");
INSERT INTO llu_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ma ana si kada nae laugo a John e bae rigita asianaa fuana Herod, na wane na e baita usia si lolofaa nae, sulia a Herod e aadea ni Herodias, na afe haasina, ma ka iilia si doo taꞌa oro gi laugo. ");
INSERT INTO llu_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ma si doo na e taꞌa ka tasa na Herod e iilia naa, e ngalia John ma ka aalua lao beu ni kanilaa. ");
INSERT INTO llu_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ma i buira na iimola gi sui da siuabu ka sui naa, a Jesus e lea mai, ka siuabu laugo. Ma ana si kada nia e fooa ana, na halo ka ifi. ");
INSERT INTO llu_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ma na Aanoedoo Aabu e sifo mai faafi nia iilingia fe bola, ma ka take faafia a Jesus. Ma si lingee doo e talo mai faasia i langi ka urii, <<I oe naa na tee fe wela rakediana nau. I nau ku eele asianaa suli oe.>> ");
INSERT INTO llu_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ana kada a Jesus e oolu aakwala fe ngali, i nia ka hafali liu naa uria faatolomailaa. Haia, na tooa gi sui da manata hasa a Jesus i nia na wela a Josef go ana. A Josef nae na e futa mai ana Hilae. ");
INSERT INTO llu_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","A Hilae e futa ana Matat, a Matat ka futa ana Livae, a Livae ka futa ana Melkae, a Melkae ka futa ana Janae, a Janae ka futa ana Josef. ");
INSERT INTO llu_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","A Josef na wela a Matataeas, a Matataeas ka futa ana Emos, a Emos ka futa ana Neham, a Neham ka futa ana Eslae, a Eslae ka futa ana Nagae. ");
INSERT INTO llu_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","A Nagae na wela a Meata, a Meata ka futa ana Matataeas, a Matataeas ka futa ana Semein, a Semein ka futa ana Josek, a Josek ka futa ana Joda. ");
INSERT INTO llu_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","A Joda na wela a Joanan, a Joanan ka futa ana Risa, a Risa ka futa ana Serababel, a Serababel ka futa ana Sialtiel, a Sialtiel ka futa ana Nirae. ");
INSERT INTO llu_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","A Nirae na wela a Melkae, a Melkae ka futa ana Adae, a Adae ka futa ana Kosam, a Kosam ka futa ana Elmadam, a Elmadam ka futa ana Ere. ");
INSERT INTO llu_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","A Ere na wela a Josua, a Josua ka futa ana Eliesa, a Eliesa ka futa ana Jorim, a Jorim ka futa ana Matat, a Matat ka futa ana Livae. ");
INSERT INTO llu_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","A Livae na wela a Simion, a Simion ka futa ana Juda, a Juda ka futa ana Josef, a Josef ka futa ana Jonam, a Jonam ka futa ana Elaeakim. ");
INSERT INTO llu_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","A Elaeakim na wela a Milia, a Milia ka futa ana Mena, a Mena ka futa ana Matata, a Matata ka futa ana Netan, a Netan ka futa ana David (na aaofia). ");
INSERT INTO llu_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","A David na wela a Jesi, a Jesi ka futa ana Obed, a Obed ka futa ana Boas, a Boas ka futa ana Salmon, a Salmon ka futa ana Nason. ");
INSERT INTO llu_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","A Nason na wela a Aminadab, a Aminadab ka futa ana Admin, a Admin ka futa ana Anae, a Anae ka futa ana Hesron, a Hesron ka futa ana Peres, a Peres ka futa ana Juda. ");
INSERT INTO llu_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","A Juda na wela a Jakob, a Jakob ka futa ana Aesak, a Aesak ka futa ana Abraham, a Abraham ka futa ana Tera, a Tera ka futa ana Neho. ");
INSERT INTO llu_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","A Neho na wela a Sirag, a Sirag ka futa ana Riu, a Riu ka futa ana Pileg, a Pileg ka futa ana Eba, a Eba ka futa ana Sela. ");
INSERT INTO llu_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","A Sela na wela a Keinan, a Keinan ka futa ana Afaksad, a Afaksad ka futa ana Siem, a Siem ka futa ana Noa, a Noa ka futa ana Lamek. ");
INSERT INTO llu_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","A Lamek na wela a Metusala, a Metusala ka futa ana Enok, a Enok ka futa ana Jered, a Jered ka futa ana Mahelalel, a Mahelalel ka futa ana Keinan. ");
INSERT INTO llu_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","A Keinan na wela a Enos, a Enos ka futa ana Set, a Set ka futa ana Adam na wela God. ");
INSERT INTO llu_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Na Aanoedoo Aabu e fungulia a Jesus, ma a Jesus ka ooli mai faasia na kafo i Jodan, ma na Aanoedoo Aabu ka talaia uria laona aanogwou. ");
INSERT INTO llu_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ma a Satan ka iilitoona i seenae sulia fai aakwala fe dani. Ma sulia fe dani nae gi, a Jesus ka langi si ania go tesi fanga, ma nia ka fiolo asianaa naa. ");
INSERT INTO llu_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ma a Satan ka bae urii fuana, <<Lea so ni oe na Wela a God, o haea fuana si fou naa ka hau ana na beredi.>> ");
INSERT INTO llu_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ma a Jesus e oolisia ka urii, <<Na Kekedelaa Aabu e haea, <Na wane langi kasi mouri ana fanga taifilia.>>> ");
INSERT INTO llu_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Sui a Satan ka talaia uria si gula na e fane, ma ana si kada toꞌou go, nia ka faatainia fuana na initooa gi sui ana molaagali. ");
INSERT INTO llu_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ma nia ka bae urii fuana a Jesus, <<Tara nau ku falea na initooa naa gi sui go ma na doo diana naa gi sui go fuamu. Sulia na doo naa gi na doo nau gi sui go, ma i nau kuka bobola eeri kuka faleda sui go fuana wane taa na ku filia. ");
INSERT INTO llu_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ma lea so o boururu ma oko fooasi nau, i nau kuka falea na doo naa gi sui go fuamu.>> ");
INSERT INTO llu_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ma a Jesus e oolisia ka urii, <<Na Kekedelaa Aabu e haea, <Tee taifilia a Lord na God oe go na oko fooasia ma oko rao fuana.>>> ");
INSERT INTO llu_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Sui a Satan ka talai nia lau uria na fera baita baa i Jerusalem, ma ka faatakea ana tesi gula na e too asianaa i langi i fafona na Beu Aabu a God. Ma i nia ka bae urii fuana a Jesus, <<Lea so ni oe na Wela a God, oko lofo kou i aano faasia i seegi. ");
INSERT INTO llu_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Sulia na Kekedelaa Aabu e haea, <A God tara ka falea mai na ensel nia gi hai so daka folo usi oe.> ");
INSERT INTO llu_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ma, <I gera daka hako oe, eeri na aemu boroi kasi fotongai ana ta fou.>>> ");
INSERT INTO llu_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ma a Jesus e oolisia ka urii, <<Na Kekedelaa Aabu e bae urii laugo, <Langi osi iilitoona a Lord na God oe.>>> ");
INSERT INTO llu_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","I buira, a Satan e iilitoona a Jesus ana si doo naa gi sui, nia ka lea naa faasia a Jesus sulia si kada totoꞌou go. ");
INSERT INTO llu_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ma na rigitaa ana na Aanoedoo Aabu e too naa fai nia a Jesus, ma i nia ka ooli naa uria na lolofaa na i Galili. Ma na uunuunua suli nia e liufia i laona na bali lolofaa nae loulou. ");
INSERT INTO llu_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ma nia ka faatolomai i laona na Beu Aabu ni figulaa gera gi, ma na iimola gi sui daka baelafe nia. ");
INSERT INTO llu_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Sui a Jesus ka lea fui Nasaret, si fera baa nia e baita mai ana. Ma ana fe dani Sabat, nia ka lea i laona na Beu Aabu ni figulaa iilingia na malutaa nia. Ma nia ka take uria na iidumilana na Kekedelaa Aabu, ");
INSERT INTO llu_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ma gera falea fuana na kekedelaa na profet Aesea e kedea. Ma nia e ifingia, ma ka daotoona si gula na Aesea e kedea ka bae urii, ");
INSERT INTO llu_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","<<Na Aanoedoo a Lord e too naa faafi nau, sulia nia e aadafili nau eeri kuka bae sulia na Faarongolaa Diana fuana tooa siofaa gi. Ma nia ka fale nau mai eeri kuka ainitalongainia na noniharailaa fuana tooa gi na da too i laona na beu ni kanilaa, ma kuka guraa na iimola gi na maada e rodo. Ma eeri kuka faanonilaa na tooa gi na da iinokesida, ");
INSERT INTO llu_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ma hai so ku faatalo ana si kada e dao na mai ana si kada a Lord ka faamouria na iimola nia gi.>> ");
INSERT INTO llu_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Si kada a Jesus e iidumia sui, nia ka bilakea na kedelaa nae, ma ka oolifainia fuana na wane na e aadasulia, ma ka gwouru uria faatolomailaa. Ma na tooa gi sui na da too i laona na Beu Aabu nae, daka bubu baita fuana. ");
INSERT INTO llu_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ma i nia e hafalia na baelaa fuada ka urii, <<Si Kekedelaa Aabu naa e fuli mamana naa i taraꞌena, ana kada na molu rongoa ku iidumia kou fuamolu.>> ");
INSERT INTO llu_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ma na tooa gi sui daka tangoa, ma daka kwele asianaa ana bae dianalana. Ma daka bae urii, <<E utaa? I nia wela baa a Josef go ana naa?>> ");
INSERT INTO llu_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ma a Jesus ka bae urii fuada, <<I nau ku haitamana tara gomolu molu ka haea si baea urii fuagu, <Wane kwaifaamouri ae, o gura oe fasi i talamu.> Ma tara molu ka bae laugo urii fuagu, <O iilia fasi seegi fera oe si doo baa gi melu rongoda o iilida mai ana fera i Kapaneam.>>> ");
INSERT INTO llu_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Sui a Jesus ka bae lau urii, <<I nau ku haea na doo mamana gi fuagamu, e afetai daka gonitainia na profet i laona fera nia i talana. ");
INSERT INTO llu_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","I nau ku haea lau fuagamu, na geni oro Jiu gi na da oru da too i Israel ana si kada a Elaeja e too ana. Ma si kada baa na uuta ka langi si aru sulia oolu fe ngali ma oono sinali, ma na fioloa baita ka liu laugo ana fera gia gi sui. ");
INSERT INTO llu_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Sui a God e langi si falea a Elaeja siana ta aai ani gera i Israel. I nia e fale nia go ana i siana tee aai oru maadiu na e too i Serefat fera laona lolofaa i Saedon. ");
INSERT INTO llu_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ma na tooa oro Jiu gi i Israel na fura e haungida ana si kada a Elaesa nia e profet. Sui nia kasi guraa go ta wane ada. Tee taifilia a Neman na wane maadiu baa faasia fera i Siria go na Elaesa e guraa.>> ");
INSERT INTO llu_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ma si kada da rongoa si doo naa, na tooa gi sui i laona na Beu Aabu daka rakehasu. ");
INSERT INTO llu_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ma gera ka tatae, ma daka taria a Jesus faasia na fera nae. Ma da talaia a Jesus uria gwouna na tataea na da haungainia na fera gera i fafona, eeri daka ui ania a Jesus i hae gano eeri ka mae. ");
INSERT INTO llu_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Sui taa, i nia e kwaidolali go ana i matangana na figua nae, ma ka lea na ana faasida. ");
INSERT INTO llu_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Sui a Jesus e lea fui Kapaneam, tee maefera ana lolofaa nae i Galili, ma tee maedani ana Sabat nia ka faatolomainia tooa gi i seenae. ");
INSERT INTO llu_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ma na tooa na da figu mai siana, daka kwele asianaa ana faatolomailaa nia gi, sulia a Jesus e faarai ana mamana baita. ");
INSERT INTO llu_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ma i laona Beu Aabu ni figulaa nae, tee wane e too ana aagalo taꞌa, nia ka gwouru laugo. Nia e rii baita ka urii, ");
INSERT INTO llu_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","<<Jesus wane i Nasaret ae, nau ku haitamamu ni oe na wane aabu a God. Taa naa o dooria oko iilia ani gemelu? Oe o lea na mai uria haungilamelu?>> ");
INSERT INTO llu_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","A Jesus e faabona aagalo taꞌa nae, ka bae urii, <<O too aaroaro, oko haga mai faasia wane nae!>> Ma aliꞌali na aagalo taꞌa nae ka ui ania wane nae i hae gano i naona figua naa, ma kafi hagatafa faasia. Ma na wane nae kafi too diana lau. ");
INSERT INTO llu_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Na tooa na da rikia si doo naa, daka kwele baita asianaa, ma daka ledi gera kwailiu daka bae urii, <<Si baea taa gi na e urii? Ana mamanaa fai nia rigitaa nia e oodua na aagalo taꞌa gi, ma daka hagatafa teefou mai i maa!>> ");
INSERT INTO llu_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ma na uunuunua sulia Jesus kafi talo ana maefera gi sui galigalia si lolofaa nae. ");
INSERT INTO llu_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Sui a Jesus e lea faasia na Beu Aabu ni figulaa, ma ka lea i luma a Simon. Haia, na fungo geni a Simon e matai ana tatasua baita ana si kada nae. Ma gera ka gania Jesus eeri ka guraa. ");
INSERT INTO llu_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","A Jesus e lea ka take i ninimana iifitai nia geni naa, kafi oodua na tatasulaa nae faasia. Ma na inite nae ka akwaa naa, ma ka lea ka rao naa uria si fanga fuada. ");
INSERT INTO llu_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ana si kada na hato e suu naa, tooa oro gi da ngalia mai siana a Jesus na ruana gera gi na mataia eꞌete kwailiu e haungida. Ma a Jesus ka aalua abana faafida, ma ka gurada teefou. ");
INSERT INTO llu_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Aagalo taꞌa oro laugo da hagatafa faasia tooa oro, ma daka rii urii, <<Ni oe na Wela a God.>> Ma a Jesus ka luia aagalo taꞌa nae gi eeri langi dasi faarai, sulia gera haitamana sui naa i nia na Christ na wane a God e aadafilia uria Aaofialaa. ");
INSERT INTO llu_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ubongi mae galogalo, a Jesus e lea faasia maefera Kapaneam, ka lea uria si gula aaroaro. Sui na tooa gi daka hafali nanisi nia, ma si kada gera daotoona, gera ka haea fuana langi kasi lea faasia na maefera nae. ");
INSERT INTO llu_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Sui a Jesus ka bae urii fuada, <<Nau ku ngalia mai na Faarongolaa Diana sulia Initooa a God, eeri kuka ainitalo ana i laona maefera gi sui. Sulia aena si Faarongolaa Diana naa na a God oodu nau mai.>> ");
INSERT INTO llu_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ma a Jesus ka ainitalo ana Faarongolaa Diana i laona Beu Aabu ni figulaa gi laona lolofaa nae. ");
INSERT INTO llu_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ana tee fe dani si kada a Jesus e take i kamena na aasi i Galili, na tooa oro gi da bibingi mai siana uria rongolana na baelana a God. ");
INSERT INTO llu_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ma i nia ka rikia na roo baru gera wane dedee gi da lafia ka too go ana i malitakwa, si kada gera saufia ada na furai gera gi. ");
INSERT INTO llu_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ma a Jesus e tae i laona baru nia a Simon, ma ka soe nia hai ka uusungai toꞌou kou ana faasia hara. Ma a Jesus e gwouru i laona na baru nae, ma ka faatolomai doo fuada na tooa gi. ");
INSERT INTO llu_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ma si kada i nia e faasuia na baelana, nia ka bae urii fuana a Simon, <<Molu uusungainia lau kou na baru uria si gula oolo, sui molu ka aala ana na furai gomolu gi uria kwailana mai na iia gi.>> ");
INSERT INTO llu_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ma a Simon e oolisia ka urii, <<Faatolomai ae, i gemelu melu rao rigita sulia fe rodo loulou nae, sui melu si kwaia go ta iia. Sui boroi ana, sulia na o haea naa, i nau kuka aala na agu furai gi.>> ");
INSERT INTO llu_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ma si kada da aala ana na furai nae gi, daka kwaia na iia oro asianaa, ma na furai gi ka garangi muu naa. ");
INSERT INTO llu_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Sui gera ka garumia na wane kwaimaani gera gi i laona ta baru aai eeri daka lea mai daka adomi gera. I gera da dao ma daka kwaia na roo baru nae gi ana iia lelea daka garangi kuruu go. ");
INSERT INTO llu_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ma si kada a Simon Peter e rikia si doo nae, nia lea mai ka boururu i naona a Jesus, ma ka bae urii, <<Lord ae, o lea kou amu faasi nau! I nau na wane fualangaa!>> ");
INSERT INTO llu_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","I nia fai nia na wane nae gi da too siana, daka kwele asianaa ana iia oro na da kwaia. ");
INSERT INTO llu_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ma na wane da rao fai nia a Simon, na hatada a James ma a John na roo wela a Sebedi, daaro kwele asianaa laugo. Ma a Jesus ka bae urii fuana a Simon, <<Langi osi mou. I nao, oe o nanisia iia, sui e ita i taraꞌena ka ooli alaa, oko nanisia na iimola gi eeri daka manata mamana ana God.>> ");
INSERT INTO llu_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ma si kada daalu dao naa i hara, da lafia na baru gi sulia oone, ma daka tafusia na doo gi sui, daka lea na ada fai nia a Jesus. ");
INSERT INTO llu_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ana tee maedani a Jesus e too i laona tee maefera, ma tee wane na fura e haungia e too laugo i seenae. Si kada nia e rikia a Jesus, nia ka lea mai siana, ka boururu i naona, ma ka gania ka bae urii, <<Aarai ae, lea so oko dooria go amu, oko gura nau fasi.>> ");
INSERT INTO llu_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Sui a Jesus e tagaa kou na abana, ka hamosia noina, ma ka bae urii, <<Iiuka, nau ku dooria. O mafo naa.>> Ma aliꞌali i buira si baelaa nae gi a Jesus e haea, na mataia nae ka sigi naa faasia wane nae. ");
INSERT INTO llu_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Sui a Jesus e oodua kou na wane nae ka bae urii fuana, <<Langi osi faarongoa lau ana ta wane ana si doo nae gi. Ma o lea fasi amu siana na fataabu, oko faatainia na nonimu fuana, eeri nia ka haitamana naa o akwaa naa. Sui o lea oko iili sulia na kwaisuusia a Moses e haea sulia wane na fura e sigi faasia eeri oko faamamana fuana tooa gi sui na mataia na i nonimu e sigi naa.>> ");
INSERT INTO llu_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Sui ka urinae boroi, na faarongolaa sulia si doo naa gi a Jesus e iilida e talofia si gula oro gi, ma na tooa oro gi daka lea mai siana uria rongolana si faatolomailaa nia gi, ma eeri a Jesus ka gurada laugo faasia na mataia gi na e haungida. ");
INSERT INTO llu_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ma si kada oro gi, a Jesus e tafusia na tooa gi, ma ka lea fuana si gula aaroaro uria fooalaa. ");
INSERT INTO llu_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Tee maedani kada Jesus e faatolomai ana, teni Farisi gi fai nia wane faatolomai gi ana kwaieresia gi, gera gwouru laugo i seenae, da lea mai faasia maefera baita gi sui ana lolofaa i Galili, ma i Judea, ma faasia i Jerusalem. Ma na rigitalaa a God ka too faafia Jesus, eeri nia ka guraa tooa gi na da matai. ");
INSERT INTO llu_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ma teni wane da koua mai i fafona iifitai tee wane na noni maea e haungia. Gera da hasi tatangai uria ruulaa i luma fai nia, eeri daka aalua i naona Jesus, eeri nia ka guraa. ");
INSERT INTO llu_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Sui taa, sulia na figulaa nae e baita asianaa, na oote ruana nia na wane naa dasi bobola naa uria ruulaa kou i luma siana Jesus. Seenae, daalu ka koua wane nae, daka lea fai nia i fafo luma, ma daka tafangia tee maekwadaa baita, daka faasifoa mai na wane nae i fafo iifitai siana Jesus. ");
INSERT INTO llu_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ma si kada a Jesus e rikia na manata mamanalaa gera, nia ka bae urii fuana wane na nonina e mae, <<Ruana ae, nau ku manata lukea naa na aade taꞌalaa oe gi.>> ");
INSERT INTO llu_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ma na wane faatolomai gi ana kwaieresia gi fai nia Farisi gi daka ngunungunu fuada kwailiu daka bae urii, <<Na wane naa, na wane utaa na ka bae tataga ana a God urii? Sulia taifilia God go na e bobola uria manata lukelana aade taꞌalaa gi.>> ");
INSERT INTO llu_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesus e haitamana si manata nae gi i lioda, ma nia ka bae urii fuada, <<Uria taa na muka manata urinae? ");
INSERT INTO llu_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Nau ku haea fuagamu, nia e waluda go ana uria haelana fuana wane naa, <Nau ku manata lukea naa na aade taꞌalaa oe gi.> Ma ka afetai asianaa fuana haelana fuana wane naa, <O take, oko fali.> ");
INSERT INTO llu_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Haia si kada nae tara nau ku faatainia fuamolu urii, nau, na Wela nia Iimola gi, nau ku too ana mamanaa laona molaagali uria manata lukelana aade taꞌalaa gi.>> Sui a Jesus ka bae urii fuana wane noni mae naa, <<Nau ku haea fuamu, o take, ngalia iifitai oe, oko lea i fera.>> ");
INSERT INTO llu_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ma na wane nae aliꞌali nia ka take i naoda, ka ngalia iifitai na e teo i fafona, ma ka ooli fera fai nia si baelafea baita fuana God. ");
INSERT INTO llu_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ma gera teefou daka kwele, ma daka mou laugo. Ma gera ka baelafea a God daka urii, <<Si doo baita asianaa na golu rikia i taraꞌena.>> ");
INSERT INTO llu_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Buira si doo naa, a Jesus e haga kou, ma ka rikia a Livae, na wane goni malefo ana takisi, e gwouru ana si gula uria ngalilana takisi. A Jesus ka bae urii fuana, <<O lea mai fai nau.>> ");
INSERT INTO llu_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","A Livae e take, ma ka faiburi ana doo nia gi teefou, ka lea fai nia Jesus. ");
INSERT INTO llu_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Sui a Livae ka haungainia tee fangaa baita fuana Jesus i luma nia, ma ana si kada nae laugo na tooa oro da goni malefo ana takisi fai nia teni tooa gi laugo gera fanga fai nia Jesus. ");
INSERT INTO llu_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Teni Farisi ma wane faatolomai ana kwaieresia gi da rakehasu, daka bae urii fuana oote fafurongo nia a Jesus gi, <<Utaa naa muka fanga ma muka gwou oofu fai nia tooa faafefe da goni takisi ma na tooa taꞌa urii gi?>> ");
INSERT INTO llu_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","A Jesus e oolisida ka bae urii, <<Tooa gi na langi dasi matai, gera dasi dooria go ta wane kwaifaamouria, tooa na da matai taari da dooria. ");
INSERT INTO llu_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nau kusi lea mai uria soelana tooa da oꞌolo, ma na tooa na aabulolada e taꞌa taari uria oolitai manatalaa.>> ");
INSERT INTO llu_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Teni tooa da bae urii fuana Jesus, <<Ana si kada oro, na oote fafurongo a John gi da aabu fanga uria fooalaa rigita, ma na fafurongo gera Farisi gi ka urinae laugo. Sui utaa naa na oote fafurongo oe gi daka fanga ma daka gwou go ada?>> ");
INSERT INTO llu_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesus e oolisida ka bae urii, <<Fafurongo nau gi da iilingia tooa baa da soeda uria fangalaa fai nia na wane na e aarai faalu ana fe dani e aarai ana. Si kada da too fai nia, daalu ka fanga ma daka gwou kwaimaani fai nia. ");
INSERT INTO llu_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Sui tara ka dao ana si kada na wane eꞌete gi da ngalia na wane aarai faalu faasi daalu. Ana si kada nae naa, daalu kafi liobukonu, ma daka aabu fanga.>> ");
INSERT INTO llu_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Sui a Jesus e bae oomelawane fuada laugo urii, <<Nia kasi bobola fuana muka karia si maku e faalu uria tailaa fai nia si maku na e kwali. Lea so muka iili urinae, muka karia si maku e faalu, ma si maku na e faalu kasi aada diana go fai nia na maku kwali. ");
INSERT INTO llu_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ma langi so muka ngalia na waen faalu ma muka oongia i fuilaa kwali ana ungana nanigot, ka langi laugo. Lea so muka iili urinae, si kada waen faalu e fufu, nia ka karia fuilaa kwali, ma waen baa e labasia fai nia wai ana. ");
INSERT INTO llu_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Nia naa, waen faalu muka aalua na mone i laona unga doo faalu. ");
INSERT INTO llu_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ma langi ta wane kasi dooria gwoufilana waen faalu buira nia e gwoutoona kwali waen e sui. Sui nia ka bae urii, <Kwali waen naa e gwou diana tasa.>>> ");
INSERT INTO llu_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Tee maedani ana Sabat, Jesus fai nia oote fafurongo nia gi da lelea ma daka liu folosia tee raoa ana doo iilingia raes. Ma si kada gera liu ana, na fafurongo nia gi daka fusia teni funge doo gi, ma gera ka ania. ");
INSERT INTO llu_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ma si kada wane gi ana Farisi gi da rikia, gera ka bae urii, <<Utaa na molu ka iilia si doo na kwaieresia e luia faasia na iililana ana maedani Sabat?>> ");
INSERT INTO llu_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesus e oolisida ka urii, <<Utaa? Langi musi iidumia go si doo baa David fai nia oote wane oomea nia gi da aadea kada baa gera fiolo? ");
INSERT INTO llu_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Nia ruu laona Beu Aabu a God, ma ka ngalia fe beredi baa gi da kwaisuusi ana fuana God, ma ka ania, ma ka falea laugo fuana oote wane nia gi. Nia e iili urinae boroi ana na kwaieresia e luia ta wane si ania beredi nae, sulia taifilia na fataabu gi taari na da bobola uria anilana.>> ");
INSERT INTO llu_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Sui a Jesus e iꞌisia baelana ka urii, <<Nau, na nau Wela nia Iimola gi, na ku baita usia na maedani Sabat.>> ");
INSERT INTO llu_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ma ana tee maedani Sabat laugo, Jesus ka lea lao Beu Aabu ni figulaa ma ka faatolomai. Ma tee wane e too laugo i seenae na bali aba aaolo nia e mae. ");
INSERT INTO llu_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Haia, teni faatolomai ana kwaieresia gi ma na Farisi gi, gera da too laugo i seenae, ma gera ka bubu sulia Jesus lea ka iilia tesi doo ana Sabat, eeri daka feengi nia ana garolaa. Nia naa gera bubungia laugo ada lea nia ka guraa ana maedani Sabat. ");
INSERT INTO llu_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ma Jesus e haitamana go ana manatada, ma nia ka bae urii fuana wane nae na abana e mae, <<Tatae, oko take mai.>> Ma wane nae ka tatae, ma ka lea mai siana Jesus. ");
INSERT INTO llu_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ma Jesus ka bae urii fuana Farisi gi ma na faatolomai gi ana kwaieresia gi, <<Nau ku ledi gamu naa, taa na kwaieresia gia nia faalamainia fuagolu tala ana golu ka iilia ana maedani Sabat? Golu ka kwaiꞌadomi, langi golu faafii? Golu faamouria ta wane, langi golu ka haungia?>> ");
INSERT INTO llu_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jesus e bae urinae sui, nia ka bubu fuada, sui ka bae urii fuana wane na abana e mae, <<Tekwalaa mai abamu.>> Ma nia ka tekwalaa, ma na abana ka diana naa laugo ana. ");
INSERT INTO llu_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Si kada gera rikia, na rakeda ka hasu asianaa, ma gera ka bae oofu uria tesi doo, eeri daka iilia ana Jesus. ");
INSERT INTO llu_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ana si kada nae Jesus ka tae uria gwouna fe tolo uria fooalaa. Ma i laona fe rodo loulou nae, i nia ka fooa fuana God. ");
INSERT INTO llu_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Haia ana ubongi, nia ka soea mai oote fafurongo nia gi siana, ma ka aadafilia aakwala wane ma roo wane ma ka alangida ana Aposol gi. ");
INSERT INTO llu_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Na hatada: Simon na Jesus falea ruana hata Peter fuana, ma Andrew na haasina, ma James, ma John, ma Filip, ma Batolomiu, ");
INSERT INTO llu_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ma Matthew, ma Tomas, ma James na wela Alfeas, ma Simon na wane ana tooa baa gera dooria kwaetaria tooa i Rom faasia Israel, ");
INSERT INTO llu_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ma Judas na wela a Alfeas, ma Judas Iskariot na wane baa tara ka falea laugo a Jesus fuana maalimaea nia gi. ");
INSERT INTO llu_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","A Jesus e sifo mai faasia i gwouna na totoloa nae fai nia na aakwala ma roo Aposol nia gi, ma ka take ana si gula neneba fai nia na figua baita nae ana fafurongo nia gi. Ma na iimola oro asianaa gi na da lea mai faasia lolofaa i Judea ma na fera baita i Jerusalem, ma na fera gi i Taea ma i Saedon na e too i kamena na aasi, da too laugo i seenae. ");
INSERT INTO llu_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Gera da lea mai uria na rongolana a Jesus ma eeri a Jesus ka gura gera faasia na mataia gera gi. Ma na iimola gi na da too ana aagalo taꞌa, gera da lea laugo mai. Ma a Jesus ka gura gera. ");
INSERT INTO llu_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Na iimola gi sui da iiliili uria na hamosilana a Jesus, sulia na mamanaa e lea kou faasi nia uria guralana na tooa gi sui. ");
INSERT INTO llu_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","A Jesus ka aada kou fuana oote fafurongo nia gi ma ka bae urii, <<Ka oilakea fuagamu tooa na mu siofaa, sulia na Initooa a God na doo gamu. ");
INSERT INTO llu_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ka oilakea fuagamu tooa na mu fiolo si kada naa, sulia tara muka aabusu. Ka oilakea fuagamu tooa na mu aangi ana si kada naa, sulia tara muka waela. ");
INSERT INTO llu_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","<<Ka oilakea fuagamu lea so na iimola gi daka maasusuala ani gamu ma daka sinitai gamu ma daka bae tataga fuagamu, sulia mu roosuli nau na Wela nia Iimola gi. ");
INSERT INTO llu_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Muka noni hahala ma muka wae i laona na eelelaa si kada na doo nae gi e fuli fuagamu, sulia na kwaiaraa baita e maasi gamu i langi. Sulia na koo gera gi da iilia laugo si doo taꞌa urinae gi i nao fuana profet gi. ");
INSERT INTO llu_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","<<Sui taa, ka taꞌa asianaa fuagamu na iimola gi na mu too ana todadoo si kada nae, sulia i gamu mu too na ana na waludalaa si kada naa. ");
INSERT INTO llu_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ka taꞌa asianaa fuagamu na iimola gi na mu fanga aabusu ana si kada naa, sulia tara muka fiolo. Ma ka taꞌa asianaa fuagamu na iimola gi na mu waela ana si kada naa, sulia tara muka liodila ma muka aangi. ");
INSERT INTO llu_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","<<Ma ka taꞌa asianaa fuagamu si kada na iimola gi da haediana ani gamu, sulia na kokoo gera gi da iilia laugo si doo nae gi fuada na profet susuge gi.>> ");
INSERT INTO llu_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","A Jesus e faatolomai laugo ka urii, <<I nau ku haea fuagamu na iimola gi na mu rongo sulia baelagu, muka hasidiana fuana na maalimaea gamu gi ma muka iilia si dianaa fuada iimola gi na da maasusuala ani gamu. ");
INSERT INTO llu_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ma muka fooa fuana a God uria ka faadiana na iimola gi na da haea na doo taꞌa gi suli gamu, ma muka fooa fuada na iimola gi na da iili doo taꞌa gi fuagamu. ");
INSERT INTO llu_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ma lea so ta iimola ka fidalia na babalimu, muka faalamainia ka fidalia laugo ta bali babali aai. Ma lea so ta iimola ka ngalia na maku ruruu baita gamu, muka falea laugo na maku ruruu aai toꞌou gamu fuana. ");
INSERT INTO llu_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ma muka falea tesi doo na ta wane e gani gamu uria. Ma lea so ta wane ka ngalia tesi doo ana doo gamu gi, langi musi gani lau eeri nia ka oolifainia fuamu. ");
INSERT INTO llu_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Tesi taa na o dooria na ta wane eꞌete gi daka iilia fuamu, oko iilia laugo fuada. ");
INSERT INTO llu_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","<<Ma lea so gamu ka hasi diana go agamu ada na iimola gi na da hasi diana ani gamu, tara langi musi ngalia go tesi kwaiaraa. Sulia na tooa taꞌa gi boroi da hasi diana laugo ada na iimola gi na da hasi diana ani gera. ");
INSERT INTO llu_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ma lea so mu aade diana go agamu fuada na iimola gi na da aade diana fuagamu, tara langi musi ngalia na kwaiaraa. Sulia na iimola taꞌa gi boroi da iili urinae laugo. ");
INSERT INTO llu_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ma lea so gamu fale doo go agamu fuada na iimola gi, ma muka maasia laugo na duulana, tara langi musi ngalia na kwaiaraa. Sulia na iimola taꞌa gi boroi da iili laugo urinae fuada na iimola taꞌa gi, eeri daka duua laugo fuada. ");
INSERT INTO llu_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","I gamu muka hasi diana ada na tooa maalimaea gamu gi ma muka iili diana fuada, ma gamu ka fale doo ma langi musi maasia na duulana. Lea gamu ka iili urinae, tara gamu ka ngalia na kwaiaraa baita, ma muka hau ana na wela a God gi na e initoo ka tasa. Sulia i nia e aade diana fuada na iimola gi na langi dasi tango nia ma na iimola taꞌa gi. ");
INSERT INTO llu_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Muka kwaimanatai, ka iilingia laugo na Maa gamu na e kwaimanatai. ");
INSERT INTO llu_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","<<Langi musi ketoa ta wane eꞌete, aata a God ka keto gamu laugo. Ma langi musi haea na kwaelaa fuana teni iimola eꞌete gi, ma a God ka langi si falea laugo na kwakwaelaa fuagamu. Muka manata lukea na iimola gi, ma a God ka manata luke gamu laugo. ");
INSERT INTO llu_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Muka fale doo fuada na iimola gi, ma a God ka fale doo laugo fuagamu. Ma a God ka falea si falelaa na e liufia na doo gi sui fuagamu. Ma si doo orolaa na gamu falea fuada na iimola eꞌete gi, tara a God ka falea urinae laugo fuagamu.>> ");
INSERT INTO llu_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","A Jesus e haea laugo si oomelawanea naa fuada ka urii, <<Ta wane na maana e rodo e afetai ka talaia lau ta wane laugo na maana e rodo. Lelea so ka iilia si doo nae, ni daaro sui go daaro ka asi daaro i laona kilu. ");
INSERT INTO llu_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Haia, ta wane na e fafurongo e afetai ka baita ka liufia na wane na e faatolomai fuana. Ma lea na wane fafurongo e ngali teefou ana na doo gi sui na wane faatolomai e fale naa fuana, i nia ka iilingia naa na wane faatolomai nia. ");
INSERT INTO llu_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","<<Gamu too ana fualangaa baita gi, sui taa gamu ngatafia na agamu teni wane aai na da too ana garolaa toꞌou. Gamu iilingia tee wane e rikia mumudui ai i laona na maana na ruana nia, sui taa nia kasi rikia go si kade ai baita na e nia i laona na maana i talana. ");
INSERT INTO llu_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ma gamu haea fuana wane eꞌete urii, <Langi osi iilia doo na e taꞌa.> Sui langi molu si manata aꞌabo go uria na fualangaa baita gi na molu iilia. Molu tafusia fasi na taꞌalaa gamu gi. Lea sui, molu fi bobola uria kwaiꞌadomilaa kou ana ta wane ete uria na garolaa nia gi.>> ");
INSERT INTO llu_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","A Jesus e haea laugo si oomelawanea naa fuada ka urii, <<Na ai na e tae diana, e afetai ka fungu ana ta fufue doo taꞌa gi. Ma e urinae laugo na ai na e tae taꞌa, e afetai ka fungu ana na fufue doo diana gi. ");
INSERT INTO llu_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","I gia haitamana na ai gi sui go ana na fufue doo gi na e fungu ana. Ma e afetai so ta wane ka fusia na fufuana ai diana faasia na kwaletotore. ");
INSERT INTO llu_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Haia, na wane diana e iilia laugo na doo diana gi ita mai manatana na e diana. Ma na wane taꞌa e iilia laugo na doo taꞌa gi ita mai i manatana na e taꞌa. Sulia na doo gi na e too i laona na manatalana ta wane, nia nae haga mai i maa ana baelana.>> ");
INSERT INTO llu_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ma Jesus e baea lau ka urii, <<Uria taa, ana si kada molu bae fai nau ana, molu ka alangi nau ana Lord, sui langi molu si iilia go sulia na doo gi na ku haeda fuamolu? ");
INSERT INTO llu_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","So ni tei na e lea mai siagu, ma ka rongo sulia na baelagu, ma ka iili sulia, nau kuka faatainia, nia na gwounge wane utaa. ");
INSERT INTO llu_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Nia e iilingia na wane na e tolea luma nia, ma nia ka elia ka lea oolo, ma ka aalu ngado ana luma nia nae fafona fou. Haia, ma ana si kada na uuta e aru, ma na kafo ka busu mai, e afetai ka busutainia, sulia nia e tolea luma nia i fafona fou. ");
INSERT INTO llu_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ma na wane na e rongoa na baelagu, ma ka langi si iili sulia, nia iilingia wane na e tolea luma nia fafona gano, ma ka langi si eli oolo ana. Si kada kafo e busu mai, ma ka toea luma nae, luma naa e asia, ma ka taꞌa teefou naa.>> ");
INSERT INTO llu_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Si kada a Jesus e faasuia na baelana fuana iimola gi, nia ka lea naa uria na fera i Kapaneam. ");
INSERT INTO llu_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ma tee wane i seenae e matai baita ma ka garangi mae. Na wane na nia na wane raoa nia tee wane baita gera na wane ni oomea gi faasia na fera baita i Rom. Ma wane baita nae e rakediana ana na wane raoa nia. ");
INSERT INTO llu_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ma si kada na wane baita nae e rongoa naa a Jesus e dao mai, i nia ka falea teni wane baita gi ada na tooa Jiu gi, eeri daka soea Jesus ka lea mai eeri ka guraa na wane ni rao nia nae. ");
INSERT INTO llu_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Si kada gera dao siana a Jesus, daka ingo, daka urii, <<Na wane baita naa e bobola fai nia oko adomia na wane rao nia, boroi ana daaro na wane maadiu gi. ");
INSERT INTO llu_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Sulia wane baita nae e rakediana asianaa fuaga na Jiu gi, ma ka tolea tee Beu Aabu ni figulaa fuagami i seegi.>> ");
INSERT INTO llu_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Urinae a Jesus ka lea naa fai gera. Ma si kada nia e dao garangia na kou na luma, na wane baita nae i Rom ka falea lau kou na ruana nia gi eeri daka faarongo urii ani nia, <<Aarai baita ae, osi too abero lau. I nau kusi faorana hai so oko lea mai i laona luma nau. ");
INSERT INTO llu_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ma i nau boroi kusi faorana laugo uria na lealaa kou siamu i talagu. O bae go amu ma na wane ni rao nau ka akwaa naa. ");
INSERT INTO llu_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nau ku haitamana ni oe o bobola go amu uria iililana doo nae, sulia i nau i talagu na wane ku rao i farana na wane baita gi laugo faafi nau, ma ku too ana na wane ni oomea gi na da rao i farana na baitalaa nau. Ma lea so nau kuka eeresia ta wane nae ka urii, <O lea,> i nia ka lea. Ma lea so kuka eeresia ta wane aai loko ku urii, <O lea mai,> i nia ka lea mai. Ma lea so nau ku eeresia ta wane ni rao oꞌoni kuka urii, <O iilia si doo naa,> i nia ka iilia naa.>> ");
INSERT INTO llu_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Si kada a Jesus e rongoa si doo nae, i nia ka kwele asianaa. Ma nia e aabulo ma ka bae urii fuada na iimola gi na da lea i buira, <<I nau ku haea fuagamu, i nau kusi rikia ua ta wane na e manata mamana ka urii, sui boro ana i Israel ka langi laugo.>> ");
INSERT INTO llu_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ma na wane ni ngali baea nae gi da ooli uria i luma nia na wane baita baa, ma daka rikia na wane matai baa e akwaa naa. ");
INSERT INTO llu_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ma e langi si tau go i buira si doo nae gi, a Jesus fai nia na oote fafurongo nia gi ma teni tooa oro gi laugo da lea uria tee fera da alangia ana i Nen. ");
INSERT INTO llu_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ma si kada i nia e dao garangia na maehaga ana na fera nae, tee figua da ngalia mai tee wane e mae, daka lea na mai i maa. Haia, na wane mae nae, i nia na alakwa muutaia nia tee aai oru. Ma na figua baita da lea mai fai nia uria aalulana. ");
INSERT INTO llu_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ma si kada a Jesus na Lord e rikia na aai oru nae, nia ka kwaimanatai asianaa fuana, ma ka bae urii, <<Langi osi aangi.>> ");
INSERT INTO llu_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Sui nia ka lea kou, ma ka hamosia na rae nae, ma na wane gi na da ngalia rae nae daka take ngado naa. Sui a Jesus ka bae urii, <<Wane daraa ae, i nau ku haea fuamu, oko tatae!>> ");
INSERT INTO llu_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ma na wane daraa baa ka tatae naa, ma ka hafali babae. Sui a Jesus ka fale nia kou fuana ni tee nia. ");
INSERT INTO llu_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ma na tooa gi na gera rikia si doo naa, daka kwele asianaa ma daka baelafea a God, daka urii, <<Tee profet baita e hagatafa mai i matangaga naa. A God e dao na mai uria faamourilaga na iimola nia gi.>> ");
INSERT INTO llu_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ma na uunuunulaa naa sulia a Jesus, e talo i laona si kade lolofaa nae loulou ma na bali ani fera nae gi galigalia. ");
INSERT INTO llu_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ana si kada na fafurongo a John gi da faarongo nia sulia na raolana a Jesus, a John ka soea mai na roo wane ana fafurongo nia gi siana, ");
INSERT INTO llu_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ma ka oodu daaro kou siana a Jesus na Lord uria ledilanalaa urii, <<Ni oe naa na wane na a John faarongo gami tara ka dao mai, ma langi mika maasia lau ta wane eꞌete?>> ");
INSERT INTO llu_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ma ana si kada daaro dao siana a Jesus, daaro ka soeledi nia urii, <<A John Siuabu e oodu gemere mai siamu uria na ledilamulaa, ni oe naa na wane John e haea tara ka dao mai, ma langi mika maasia lau ta wane eꞌete?>> ");
INSERT INTO llu_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ma ana si kada nae laugo, a Jesus e guraa tooa matai oro gi, ma nia ka taria na aagalo taꞌa gi faasia na tooa, ma ka guraa na tooa na maada e rodo. ");
INSERT INTO llu_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Nia naa, a Jesus ka bae urii fuadaaro, <<Moro ooli kou, moro ka faarongoa John ana doo naa gi na moro rikida ma moro ka rongoda i seegi taraꞌena. Tooa maa rodo, daka aada naa. Ma tooa tero, daka fali naa. Ma tooa na fura e haungida, daka mafo naa. Ma tooa na aalingada e boko, daka rongo naa. Ma tooa na da mae, daka mouri lau. Haia, ma na Faarongolaa Diana, nau ku talamatainia sui naa fuana na tooa siofaa gi. ");
INSERT INTO llu_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Botalaa ana ni tei na na manatana e langi si hala ani nau.>> ");
INSERT INTO llu_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","I buira na roo fafurongo nae gi a John da ooli, a Jesus ka hafali bae sulia a John fuana tooa gi na da figu ka urii, <<Ana si kada molu lea i laona aanogwou siana John, si taa naa molu lea uria na rikilana i seenae? Ta wane na e manata ruarua iilingia na abana rade na e gelogelo ana ooru? Langi! John nia langi kasi wane urinae. ");
INSERT INTO llu_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Haia, taa naa molu lea uria na rikilana? Ta wane na e ruufia maku logalogaa? Langi! Sulia na tooa gi na da oofi urinae, da todadoo, ma daka too i laona luma diana asianaa gi. ");
INSERT INTO llu_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Molu faarongo nau mai. Si taa naa mu lea kou uria na rikilana? Na profet? Iiuka, nia na profet mamana! Sui taa, i nia e liufia na profet gi teefou ua baa gi mai i nao. ");
INSERT INTO llu_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","A John naa baa da kekede sulia i laona Kekedelaa Aabu ana si kada a God e bae urii, <Aada fasi, i nau ku oodua kou tee wane bae i nao, eeri nia ka aade aagau ana tala i nao fuamu.>>> ");
INSERT INTO llu_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","A Jesus ka bae lau urii, <<I nau ku haea fuagamu, a John naa i nia na tofungana wane ma ka liufia na wane gi naa sui na gera futa mai i laona molaagali naa. Sui ka urinae boroi ana, na iimola gi na da faatoꞌou gera i laona na Initooa a God, i gera naa da baita ka tasa faasia a John.>> ");
INSERT INTO llu_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Tooa gi sui na da rongoa baelana, e tasa ana tooa goni malefo ana takisi gi, si kada gera da rongo sulia baelana a Jesus, daka haitamana tala nia a God e oꞌolo ma ka mamana, ma gera sui daka siuabu ana a John. ");
INSERT INTO llu_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Haia, na wane Farisi gi fai nia wane faatolomai gi ana kwaieresia gi, da oote gera go ana siuabulaa ana John, sulia dasi dooria go na roolaa sulia si kwaidoorilaa a God e aade aagau ana fuada. ");
INSERT INTO llu_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ma a Jesus ka bae lau urii fuada, <<Tara taa naa kuka bolangainia fai nia na uunita wane naa gi i kada naa? Ma na malutada e utaa? ");
INSERT INTO llu_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Gera da iilingia na gala wela na da figu i maana uusia ana roo figulaa, ma daka rii kwailiu fuada, <Gemelu melu uufi au, ma molu si wae go sulia. Ma melu ka nguulia na nguu lau ni maea fuamolu, ma muka langi si kwaimanatai go.> ");
INSERT INTO llu_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Kada a John Siuabu e dao mai, nia e aabu fanga ma langi si gwoufia waen, ma molu ka haea i nia e too ana aagalo taꞌa. ");
INSERT INTO llu_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Sui ana si kada i nau na Wela nia Iimola gi ku dao mai, nau kuka fanga oofu ma kuka gwou fai nia tooa gi, ma molu ka bae urii laugo, <Molu rikia! Nia haitamana fangalaa baita asianaa ma ka gwou baita asianaa ana waen, ma nia ka kwaimaani fai nia tooa faafefe da goni malefo ana takisi ma teni tooa aabulolada e taꞌa laugo.> ");
INSERT INTO llu_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Sui taa, tooa gi da roosulia na liotooa a God, daka faatainia a God e oꞌolo.>> ");
INSERT INTO llu_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Tee wane ada na Farisi gi hatana a Simon, nia e soea a Jesus eeri ka fanga fai nia. Haia, a Jesus ka lea i luma nia, ma ka gwouru naa uria na fangalaa. ");
INSERT INTO llu_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ma tee geni na aabulolana taꞌa e too laugo i laona na fera nae. Ma si kada na geni nae e haitamana a Jesus e fanga i laona luma nia na Farisi nae, ni nia ka ngalia mai tee bii diana na e fungu ana gwai na e mokomoko diana asianaa. ");
INSERT INTO llu_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ma nia e ruu i luma, ka take i buira a Jesus i ninimana aena, ma ka aangi ma ka faagwinia na aena a Jesus ana na kafona maana. Sui nia ka uusua ana na iifuna ketena, ma ka nonoia, sui nia ka ikia ana gwai mokomoko diana baa i fafona aena. ");
INSERT INTO llu_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ma si kada na wane Farisi baa e soea kou a Jesus, e rikia si doo nae, nia ka manata ana urii, <<Lea so na wane naa i nia na profet, i nia ka haitamana aabulolana geni na e taꞌa asianaa.>> ");
INSERT INTO llu_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Sui a Jesus e haitamana na manatalaa na wane Farisi nae, ma nia ka bae urii fuana, <<Simon ae, tesi doo na ku doori faarongo oe ana.>> Ma a Simon ka urii, <<Haia, Faatolomai ae, o faarongo nau mai ana.>> ");
INSERT INTO llu_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","A Jesus ka bae urii fuana, <<Tee roo wane daaro ngalia na malefo faasia na tee wane na e faalamainia tooa gi daka ngalilanga ana malefo siana. Tee wane e ngalilanga ana lima talange malefo, ma ta wane aai ka ngalilanga ana lima aakwala malefo. ");
INSERT INTO llu_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ma i daaro sui go daaro si bobola uria na duulana si malefo nae gi, ma na wane nae e faalamainia ngalilanga fuadaaro ka manata lukea sui go na ngalilangaa daaro nae gi. Urinae, ni tei ani daaro na e rakediana ka tasa fuana wane na e falea si malefo nae gi fuadaaro?>> ");
INSERT INTO llu_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ma a Simon e oolisia ka urii, <<I nau ku manata hasa na wane aai nae baa e ngalia si malefo baita.>> Ma a Jesus ka bae urii, <<Na oolisilaa oe e oꞌolo naa.>> ");
INSERT INTO llu_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Sui a Jesus e aabulo fuana na geni baa ma ka bae urii fuana a Simon, <<O rikia fasi na geni naa. Si kada nau ku ruu mai i luma oe, osi falea go tesi kafo fuagu uria na saufilana na aegu. Sui ni nia ana e saufia na aegu ana na kafona maana ma ka uusua ana na iifuna ketena. ");
INSERT INTO llu_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Haia, oe osi gonitai nau go ana na nonoilagu. Sui ni geni naa e ita ana si kada baa ku ruu mai i luma naa, ni nia ka nonoia na aegu ka lea dongaa go ana. ");
INSERT INTO llu_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ma ni oe laugo osi gwaia go na ketegu ana tesi gwai, ma ni geni naa, nia e ikia na aegu ana na gwai mokomoko diana. ");
INSERT INTO llu_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Nia naa ku haea fuamu, na rakedianalaa baita nia ani nau e faatainia na garolaa oro nia gi e aaluke sui naa. Sui taa, so ni tei na garolaa nia na da manata lukea ka toꞌou, na rakedianalaa nia ka toꞌou laugo.>> ");
INSERT INTO llu_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Sui a Jesus ka bae urii fuana na geni nae, <<Nau ku manata lukea na garolaa oe gi.>> ");
INSERT INTO llu_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ma teni iimola gi aai na da too i seenae, daka rakehasuia Jesus, ma daka bae urii i matangada kwailiu, <<Ni tei naa na wane naa, na ka manata lukea laugo na garolaa gi urii?>> ");
INSERT INTO llu_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Sui a Jesus ka bae urii lau fuana na geni nae, <<O lea naa, ma langi osi manata aꞌabo. A God e faamouri oe sulia oe o manata mamana.>> ");
INSERT INTO llu_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ma i buira si doo nae gi, a Jesus ka lea naa i laona na maefera totoꞌou gi ma na fera baita gi, ma ka faatalo ana na Faarongolaa Diana sulia na Initooa nia a God. Ma na aakwala ma roo wane fafurongo nia gi laugo da lea fai nia, ");
INSERT INTO llu_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ma teni geni gi laugo na a Jesus e taria na aagalo taꞌa gi ma na mataia gi laugo faasi gera. Ma ni gera naa ni Mary na geni faasia na maefera i Magdala, nia na aai nae a Jesus e taria na fiu aagalo taꞌa gi faasia, ");
INSERT INTO llu_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ma ni Joana na afe nia a Kusa na wane baita gera na wane gi na da rao i laona na luma a Herod na aaofia, ma ni Susana, ma teni geni oro gi lau. Na geni nae gi na da adomia a Jesus ma na oote fafurongo nia gi ana na aaludooa gera gi ma na todadoo gera gi i talada. ");
INSERT INTO llu_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Na iimola oro gi da figu mai siana a Jesus. Da lea mai faasia maefera eꞌete kwailiu gi sui. A Jesus ka bae oomelawanea urii fuada, ");
INSERT INTO llu_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","<<Tee wane e lea ka fasia mige doo i laona raoa nia. Ma ana si kada nia e ui tagalangainia mige doo gi, teni mige doo gi daka asi gera sulia na tala. Ma na tooa gi da liu daka buu faafida, ma na manu gi daka ania naa laugo. ");
INSERT INTO llu_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Haia, teni mige doo gi daka asida i fafo gano foulaa. Ma ana si kada da bulao mai ana, gera ka aliꞌali ka kuku ua go i sulia si gano nae e langi si gwini. ");
INSERT INTO llu_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Haia, teni mige doo aai gi daka asida i matangana na torakaukau gi. Ma na torakaukau gi da bulao mai fai nia na mige doo diana, ma daka nuku faafia na ai gi. ");
INSERT INTO llu_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Haia, teni mige doo aai gi daka asida i fafona gano diana, ma daka bulao, ma daka fungu ana fufue doo oro lelea ka doo oro asianaa.>> Ma a Jesus ka faasuia baelana ka urii, <<Molu ka manata diana ana oomelawanea naa.>> ");
INSERT INTO llu_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Sui na oote fafurongo a Jesus gi da ledi nia uria na malutana si oomelawanelaa nae, ");
INSERT INTO llu_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ma nia e oolisida ka urii, <<A God e falea fuagamu na haitamadooa sulia si doo afetai gi sulia na initooa nia. Sui fuana tooa aai gi sui go, gera ka rongo go ada ana oomelawanea gi, hai so lea daka bubu boroi, langi dasi rikia go, ma lea daka rongoa boroi, e langi dasi haitamana.>> ");
INSERT INTO llu_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Haia, a Jesus ka bae lau urii, <<Na malutana na oomelawanea nae: Na mige doo, i nia iilingia na baelana a God. ");
INSERT INTO llu_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Na mige doo gi na da asida sulia na tala, i nia e iilingia teni tooa na da rongoa baelana a God, ma a Satan e lea mai ka lafua baelaa nae faasi gera. Nia naa e aadea daka langi dasi manata mamana uria mouria. ");
INSERT INTO llu_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ma na mige doo gi na da asida i fafona gano na e foulaa e iilingia na tooa da rongoa baelana a God ma daka ngalia fai nia na eelelaa go ana. Sui daka manata mamana ana sulia si kada kukuru go. Sui lea na iilitooa e dao go, daka langi dasi manata mamana naa. ");
INSERT INTO llu_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Mige doo gi na da asida i matangana na torakaukau gi, e iilingia tooa na da rongo, ma daka manata aꞌabo ada ana doo eꞌete gi, mala na todadooa ma na eelea tatagwai lao molaagali na ka suu faafida. Nia naa e aadea langi dasi bobola uria iililana raolaa diana fuana a God. ");
INSERT INTO llu_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Na mige doo na da asida i fafona na gano na e diana, e iilingia tooa na da rongoa baelana God, ma daka manata mamana asianaa. Ma gera daka roosulia na baelana naa. Langi gera dasi mamalo ana manata mamanalaa, ma daka bobola uria iililana raolaa oro fuana a God.>> ");
INSERT INTO llu_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","A Jesus ka bae lau urii, <<E langi ta wane si faaharua na laeta, sui ka aalua go ana farana ta teu. Nia ka kulungainia na mone i langi taari eeri na wane na e ruu mai i luma ka rikia ua go. ");
INSERT INTO llu_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Nia ka urinae laugo ana na faatolomaia naa gi i sulia God nia e too haufini ua naa, bobongi ana ta maedani ka hagatafa folaa mai. Ma tesi baea na da suu faafia, bobongi ka bango tafa teefou naa laugo. ");
INSERT INTO llu_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Nia naa muka fafurongo diana, sulia ni tei na e manata mamana ana baelana a God, tara nia ka haitama doo oro lau. Ma ni tei na e langi si manata mamana ana, langi nia kasi haitamana baelaa na nia e rongoa.>> ");
INSERT INTO llu_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","I buira, ni tee nia a Jesus fai nia na haasina gi da dao mai ma daka doori rikilanalaa, sui ka afetai fuada uria idu garangilanalaa sulia na iimola oro gi da figu galia a Jesus ana si kada nae. ");
INSERT INTO llu_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ma tee wane i laona figua nae ka bae urii fuana Jesus, <<Ni tee oe fai nia na oote haasimu gi da take go ada i maa, ma daka doori riki oe.>> ");
INSERT INTO llu_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","A Jesus ka bae urii fuada sui, <<Ni tei gera na da rongo ma daka roosulia baelana God, i gera naa na ni tee nau gi ma na haasigu gi.>> ");
INSERT INTO llu_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Tesi kada, a Jesus fai nia na oote fafurongo nia gi, daalu tae i laona tee baru ma nia ka bae urii fuada, <<Golu faafolo fasi fui bali aasi loko.>> Ma daalu ka hafali faafolo naa. ");
INSERT INTO llu_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ma ana si kada da lea ua ana, a Jesus ka teo ana. Ana si kada nae, na ooru baita e dao, ma na nafo gi ka baita ma ka garangi kuruumainia na baru daalu. ");
INSERT INTO llu_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Fafurongo nia gi daalu faaada a Jesus daka urii, <<Aarai ae! Golu garangi mae naa!>> Sui a Jesus ka tatae ka bae fifii fuana ooru ma na nafo suangalua, ma daka roosuli nia. Ma ka aaroaro baita laugo ana. ");
INSERT INTO llu_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Sui a Jesus ka ngatafia oote fafurongo nia gi ka urii, <<Utaa na musi manata mamana ani nau?>> Ma i gera daka kwele ma daka mou, ma daka ledi gera kwailiu, <<Na wane taa naa? Nia e falea go ana baelana, ma na ooru baita fai nia nafo baita daaro ka roo naa suli nia.>> ");
INSERT INTO llu_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Sui Jesus fai nia oote fafurongo nia gi da faafolo laona aasi nae lea daka dao ana lolofaa nae i Gerasa ana bali aasi loko faasia i Galili. ");
INSERT INTO llu_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Si kada a Jesus e sifo kou i hara faasia baru, nia ka kwaitodai fai nia tee wane faasia gula nae. Na wane nae, na aagalo taꞌa gi da too ani nia, ma ka talu go ana sulia si kada e tau na mai, ma ka langi si too laugo i laona ta luma. Nia ka teo ngado go mai ana i laona mae oba fuana aalulana tooa mae gi. ");
INSERT INTO llu_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Si kada oro gi sui na mai, gera kani faafia roo aena ma abana gi, ma daka aalua wane uria fofololaa gi suusia. Sui, ka muusia go ana na kanilaa nae gi ma na aagalo taꞌa nae gi daka tari nia na kou fui laona aanogwou. Haia, si kada nia e rikia go a Jesus, nia ka rii baita, ma ka boururu na i maana aena Jesus, ma ka rii urii, <<Jesus ae, Wela God initoo, taa naa o dooria ani nau? I nau ku gani oe aata oko falea na kwakwaelaa faafi nau.>> Nia e haea si baea nae gi sulia Jesus e oodua na aagalo taꞌa baa gi e too ani nia ka hagatafa faasia. ");
INSERT INTO llu_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesus ka ledia, <<Ni tei na hatamu?>> Ma nia e oolisia ka urii, <<Hatagu a Lului Wane.>> Nia ka oolisi urinae sulia na aagalo taꞌa oro na da ruufi nia. ");
INSERT INTO llu_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Na aagalo taꞌa nae gi daka gania Jesus faasia oodulada fui laona gulu ni kwaelaa. ");
INSERT INTO llu_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Haia, na boso oro da fanga ada i kame na tolo garangi laugo si gula nae. Ma na aagalo taꞌa nae gi daka gania a Jesus hai daka lea ada fui laona boso nae gi. Ma a Jesus ka faalamaini gera naa. ");
INSERT INTO llu_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Gera ka hagatafa na mai faasia na wane baa, ma daka ruufia na na boso baa gi teefou. Na langoi boso baa gi teefou daka lalao i oobina fou naa fui laona aasi, ma daka lola teefou naa. ");
INSERT INTO llu_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ana si kada wane fofolo usia boso nae gi da rikia si doo nae gi, daka tafi ma daka uunuunu na sulia i laona maefera baita ma i laona maefera toꞌou galigali gi laugo i seenae. ");
INSERT INTO llu_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Na iimola gi na da rongoa, da hagatafa uria rikilana si doo nae e fuli. Ma ana si kada gera dao mai siana Jesus, daka rikia na wane nae na aagalo taꞌa e lafu naa faasi nia ma ka gwouru go ana i maana aena a Jesus, nia ka oofi naa, ma na manataa oꞌolo gi ka too naa ani nia. Ma gera sui daka mou. ");
INSERT INTO llu_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Haia, tooa na da rikia si kada baa a Jesus e taria na aagalo taꞌa nae gi faasia na wane naa, gera uunuunu na sulia fuagera. ");
INSERT INTO llu_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Sui afutana tooa nae da too ana lolofaa nae da gania Jesus hai ka lea ana faasia fera gera, sulia gera mou asianaa. Sui a Jesus ka tae naa i laona baru uria lealaa. ");
INSERT INTO llu_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Na wane baa na aagalo taꞌa e lafu faasi nia, e ingo ana Jesus, <<O faalamai nau eeri kuka lea agu fai oe.>> Ma a Jesus e oodu nia ka bae urii fuana, ");
INSERT INTO llu_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","<<O ooli amu na i fera oe, oko faarongo ana si doo nae gi a God e iilida fuamu.>> Sui, na wane nae ka ooli naa fui fera, ma ka faarai na sulia si doo nae gi a Jesus e iilida fuana. ");
INSERT INTO llu_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Sui ana si kada a Jesus e ooli lau mai fuana ta bali aasi aai, na iimola gi da maasi nia ma daka eele baita asianaa uria na rikilanalaa. ");
INSERT INTO llu_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ma tee wane hatana Jaeras ka dao mai. Na wane nae i nia na wane kwaiꞌadomi i laona Beu Aabu ni figulaa. Nia e lea mai ka boururu i maana aena Jesus, ma ka ingo na ana Jesus eeri nia ka lea fai nia fui luma nia. ");
INSERT INTO llu_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Sulia tee fe haari muutaia nia na e matai, ma ka garangi mae naa. Tee aakwala ma roo fe ngali go na e baita na mai sulia. Ma ana si kada a Jesus e lea fai nia ana, na iimola oro da lulu gali nia. ");
INSERT INTO llu_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ma tee geni na abu sura e haungi nia e too laugo i see nae. Na mataia taꞌa nae e haungia na geni nae sulia aakwala ma roo fe ngali na e sui naa. Ma ka nagaa na todadoo nia teefou fuana teni wane uria daka gura nia ma ka langi si mamana go fuana. ");
INSERT INTO llu_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Haia, na geni naa ka fali mai i buira Jesus, ma ka hamotoona fifisina maku a Jesus, ma na abu tafa nae ka sui na ana si kada nae. ");
INSERT INTO llu_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","A Jesus ka ledi, <<Ni tei na e hamotoogu?>> Ana si kada nae na figua nae teefou da tofe go ada. Ma a Peter ka bae urii, <<Aarai ae, tooa oro na da bibingi oe naa.>> ");
INSERT INTO llu_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Sui Jesus ka bae urii, <<Taa wane na e hamotoogu, sulia ku haitamana ana si kada na mamanaa nau ka gura ta iimola.>> ");
INSERT INTO llu_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Na geni nae e haitamana Jesus e daotoona naa, ma nia ka fali mai ma ka lelebe ma ka mou, ma nia ka boururu i maana aena a Jesus. Ma si kada tooa oro nae gi da aadaada ani nia, nia ka faarongo teefou na ana si doo na e iilida gi, ma nia ka akwaa naa lau go. ");
INSERT INTO llu_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","A Jesus ka bae urii fuana, <<Inite ae, God e gura oe sulia na o manata mamana ani nau. Oko lea na kou amu, ma langi osi manata abo.>> ");
INSERT INTO llu_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Si kada a Jesus e bae ua urinae, tee wane e dao na mai faasia luma a Jaeras, ka faarongoa Jaeras ka urii, <<Na haari oe e mae naa. Langi osi faaꞌaberosia lau na wane faatolomai.>> ");
INSERT INTO llu_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ma a Jesus e rongoa, ma ka bae urii fuana a Jaeras, <<Langi osi mou. Lea o manata mamana amu, tara haari oe ka diana laugo ana.>> ");
INSERT INTO llu_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ana si kada gera dao kou ana i luma, a Jesus ka talaia a Peter fai nia a John ma a James fai nia maa ma ni tee nia na wela nae go, daka ruu i luma. A Jesus ka luia ta iimola lau si lea fai daalu i luma. ");
INSERT INTO llu_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ma na figua nae sui teefou da suungimaea ma daka aangisia na wela nae. Sui Jesus ka bae luida ka urii, <<Musi aangi lau. Na wela naa nia langi si mae, nia ka teo go ana. ");
INSERT INTO llu_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ma gera daka waelasia ada Jesus, sulia gera haitamana na wela naa nia e mae mamana naa. ");
INSERT INTO llu_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Sui a Jesus ka dau i abana na wela nae, ma ka bae baita urii, <<Wela ae, o tatae!>> ");
INSERT INTO llu_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ma na mangona ka ooli lau mai, ma nia ka tatae. Ma a Jesus ka haea fuada eeri daka falea tee si fanga fuana. ");
INSERT INTO llu_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ni tee nia fai nia na maa nia wela nae, da kwele baita asianaa ana si doo nae. Sui a Jesus ka bae luida langi dasi bae lau sulia doo nae gi fuana ta wane. ");
INSERT INTO llu_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","A Jesus e soea mai na aakwala ma roo wane fafurongo nia gi siana. Ma nia ka falea na rigitaa ma na mamanaa fuada uria guralana mataia gi ma na tarilana aagalo taꞌa gi. ");
INSERT INTO llu_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Nia ka oodu gera kou uria faatalolana Initooa a God ma na guralana tooa matai. ");
INSERT INTO llu_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ma nia ka bae fifii fuada ka urii, <<E langi molu si dau ana tesi doo ana lealaa gamu naa. Musi ngalia ta wai ma tesi fanga, si malefo boro ka langi laugo, ai fuana kubou, ma tesi maku ni oolisilaa boro ka langi laugo. ");
INSERT INTO llu_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ma luma taa na da gonitai gomolu, molu ka too ngado naa i laona tee luma nae lea ka dao ana si kada na molu ka lea ana. ");
INSERT INTO llu_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Lea ta maefera na da langi dasi gonitai gomolu, molu ka lea amolu faasida, ma molu ka tafusia aafuafui gano faasia lofo ae molu, uria na faatailana naa fuada tara a God ka keto gera.>> ");
INSERT INTO llu_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ma na oote fafurongo nae gi da lea, ma daka liufia na fera gi sui fuana baelaa sulia Faarongolaa Diana sulia a God ma fai nia guralana tooa gi ana gula gi sui. ");
INSERT INTO llu_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ana si kada nae laugo, a Herod Antipas na Aaofia i Galili, nia e rongoa na faarailaa gi sulia doo gi na a Jesus e iilida. Ma na manatana ka kaubare, sulia teni wane gi da haea nia a John Siuabu na e mouri lau, ");
INSERT INTO llu_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ma teni wane daka haea nia a Elaeja na profet, ma teni tooa lau daka haea nia ta profet aai ua mai i nao na e tatae lau faasia na maea. ");
INSERT INTO llu_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","A Herod ka bae urii, <<Na wane taa naa da bae sulia naa? Sulia a John baa ku furi muusia sui naa na ketena.>> Haia, ita i kada nae a Herod ka dooria asianaa naa rikilana a Jesus. ");
INSERT INTO llu_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Haia, si kada na aakwala ma roo wane fafurongo nia a Jesus, daalu ooli na mai, daalu ka uunuunu sulia doo gi na da iilida. Sui, a Jesus fai nia fafurongo nae gi, daalu ka lea taifilida fui fera i Betsaeda. ");
INSERT INTO llu_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Sui si kada na figua gi da rongoa naa a Jesus e dao, gera laugo daka lea suli nia. Ma a Jesus e gonitainida, ma ka bae sulia na Initooa a God fuada, ma ka faamouria na iimola ani gera na da matai. ");
INSERT INTO llu_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ma i haulafi, na aakwala ma roo wane fafurongo nia gi daka lea mai siana ma daka bae urii, <<O faaolia na figua naa eeri daka lea ada ana fera naa gi, ma daka daotoona ada tesi fanga fai nia ta gula ni teolaa, sulia i seegi si gula e langi ta iimola kasi too go ana naa.>> ");
INSERT INTO llu_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Sui a Jesus ka bae urii fuada, <<I gomolu molu fale tesi fanga fuada uria anilana.>> Ma gera oolisia daka urii, <<I gemelu na melu too go ana lima fe beredi ma na roo gwe iia. E utaa? I oe o dooria melu ka lea uria folilana mai tesi fanga fuana na figua baita naa?>> ");
INSERT INTO llu_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Na figua na e bobola fai nia na lima tooni wane na da too i seenae. A Jesus ka bae urii fuana na oote fafurongo nia gi, <<Molu haea fuada daka gwouru i aano ana oogulaa ana iimola gi ana lima aakwala ana tee figua.>> ");
INSERT INTO llu_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","I buira na oote fafurongo gi da iilia si doo nae sui, na tooa gi sui da gwouru naa. ");
INSERT INTO llu_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Sui a Jesus ka ngalia na lima fe beredi nae gi ma na roo gwe iia nae gi, ma nia ka aada alaa uria langi ma ka tangoa a God. Sui nia ka niia na beredi gi, ma ka falea fuana na oote fafurongo nia gi eeri daka tolingia fuada na iimola gi. ");
INSERT INTO llu_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","I gera sui da fanga ma daka aabusu asianaa. Ma na oote fafurongo nia gi daka gonia na oorongana fanga na e oore i laona aakwala ma roo koko gi lelea fungu. ");
INSERT INTO llu_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Tesi kada a Jesus e fooa ana taifilia, ma na oote fafurongo nia gi daka lea mai siana, ma nia ka ledi gera ka urii, <<Na iimola gi da haea i nau ni tei naa?>> ");
INSERT INTO llu_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ma da oolisia ka urii, <<Teni iimola gi da haea hasa i oe a John Siuabu. Ma teni iimola gi lau da haea ada hasa i oe a Elaeja. Ma teni iimola gi aai lau da haea hasa ni oe tee wane ada na profet gi i nao ua na mai na e mouri ooli lau.>> ");
INSERT INTO llu_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ma a Jesus e ledi gera ka urii, <<Ma i gomolu mone, molu haea i nau ni tei naa?>> A Peter e oolisia ka urii, <<I oe naa na Christ, na wane na a God e filia uria Aaofialaa.>> ");
INSERT INTO llu_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Sui a Jesus ka bae fifii fuada eeri langi dasi faarongoa lau ta wane ana si doo nae. ");
INSERT INTO llu_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ma i nia ka bae laugo urii, <<I nau, na Wela nia Iimola gi tara kuka nonifii baita ana doo oro gi. Ma na wane baita gi ma na fataabu baita gi ma na wane faatolomai gi ana na kwaieresia gi, daka sinatai nau. Ma daka haumaeli nau, sui ana ooula fe dani, a God tara ka tatae nau faasia na maea.>> ");
INSERT INTO llu_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ma Jesus ka bae lau urii fuada sui go, <<Lea so ta iimola e dooria na lealaa mai fai nau, i nia langi kasi hasi uria na kwaidooria nia i talana. Ma nia ka ngalia na airarafolo ana fiilaa nia sulia dani, ma ka lea mai suli nau. ");
INSERT INTO llu_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Sulia so ni tei naa e dooria ka oogani ana na mourilana i talana, tara nia ka mae. Haia, ma so ni tei naa e lugasia na mourilana uria na dianalagu, i nia ka mouri. ");
INSERT INTO llu_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Langi si diana fuana ta wane na ka ngalia mai na doo oro gi i laona molaagali, sui taa nia ka mae ma ka lea i laona eere. ");
INSERT INTO llu_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Haia, lea ta wane e ida lau sulia manata mamanalaa nia ani nau ma na faatolomaia nau, tara nau kuka ida laugo suli nia ana si kada kuka dao mai fai nia na baitalaa gami a God na Maa ma na ensel nia gi. ");
INSERT INTO llu_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ma nau ku haea doo mamana fuamolu, teni tooa amolu, langi dasi mae lelea daka rikia na Initooa nia a God e dao mai.>> ");
INSERT INTO llu_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Tee fe wiki i buira i nia e haea doo nae gi, a Jesus e talaia a Peter ma a John ma a James, ma da raa i gwouna tee fe uuo uria na fooalaa. ");
INSERT INTO llu_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ma si kada a Jesus e fooa ana, na maana ka tatala ma na maku nia gi ka kwakwaoa ma ka sinasina asianaa. ");
INSERT INTO llu_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ma aliꞌali tee roo wane daaro ka too laugo i seenae ma daka bae adaaro fai nia. I daaro na a Moses ma a Elaeja. ");
INSERT INTO llu_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ma daaro daaro dao faatai mai i laona na raralaa i langi, ma daaro ka bae fai nia a Jesus sulia na faamamanalana na manatalaa nia a God na tara nia ka iilia ana na maelana i Jerusalem. ");
INSERT INTO llu_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ma a Peter ma na roo ruana nia gi, daka teo liu ada. Sui ana si kada da aada, daka rikia na raralana a Jesus ma na roo wane gi na da take fai nia. ");
INSERT INTO llu_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ma ana si kada na roo wane nae gi daaro tafusia naa a Jesus, a Peter ka bae urii fuana, <<Aarai ae, nia diana asianaa na golu ka too naa agolu i seegi. Tara melu ka tolea ta oolu babala, tee doo fuamu, ta doo fuana a Moses, ma ta tee doo aai fuana a Elaeja.>> (I nia e lalafusia laugo ana si doo na i nia e haea.) ");
INSERT INTO llu_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ma si kada a Peter e bae ua go ana, tesi barobaro e dao ma ka nunufi gera. Ma na oolu wane fafurongo gi daka mou ana si kada na barobaro nae e dao mai faafi gera. ");
INSERT INTO llu_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ma tee lingee doo ka bae mai faasia i laona na barobaro nae ka urii, <<Nia naa na Wela nau na ku filia naa. Molu ka fafurongo nia!>> ");
INSERT INTO llu_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ma si kada na lingee doo nae e faasuia na baelana, a Jesus go ana taifilia na e too fai nia na oolu fafurongo nia gi i seenae. Ma daalu ka bonatainia naa si doo nae, ma ana si kada nae e langi dasi faarongoa go ta iimola ana si doo nae gi na da rikida. ");
INSERT INTO llu_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Sui fe dani buira si doo nae gi, a Jesus fai nia oolu fafurongo nia gi daalu ka sifo mai faasia gwouna fe uuo na a Jesus e malalia ana, ma na tooa oro gi da kwaitodai fai nia a Jesus. ");
INSERT INTO llu_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ma tee wane faasia na figua na e rii ka bae urii, <<Faatolomai ae, nau ku gani oe, o taria aagalo taꞌa na faasia na wela nau, sulia i nia na tee fe wela muutaia nau. ");
INSERT INTO llu_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Na aagalo taꞌa e dao ana ka faatona, ma ka rii baita, ma ka ui ania i aano, ma na aalitafa ka kwalutafa i fakana. Si kada nia e haungia, nia ka afetai asianaa uria suilaa faasia. ");
INSERT INTO llu_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nau ku gania fafurongo oe gi uria tarilana faasia, ma ka afetai fuada uria iililana.>> ");
INSERT INTO llu_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","A Jesus e bae urii, <<Gamu tooa na aabulolaa gamu e taꞌa, ma musi manata mamana ana a God. E afetai kuka too fai gamu katau. Nau ku noni eela naa ani gamu.>> Sui nia ka bae urii fuana wane nae, <<O ngalia mai na wela oe nae i see.>> ");
INSERT INTO llu_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ana si kada na wela naa e dao mai ana si gula nae a Jesus e take ana, na aagalo taꞌa naa e hamo uria wela naa, kafi ui ania i hae gano, ma ka lebesia naa. A Jesus e ngatafia aagalo taꞌa naa kafi hagatafa faasia wela nae, ma na toolana wela naa kafi diana, ma a Jesus kafi falea wela na fuana maa nia. ");
INSERT INTO llu_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ma na tooa na da figu, daka kwele baita asianaa ana si rigitaa a God. Si kada na tooa gi da kwele ua go ada ana si doo nae gi a Jesus e iilida, nia ka bae urii fuana oote fafurongo nia gi, ");
INSERT INTO llu_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","<<Langi musi manata buro ana si doo na ku haea fuagamu. Nau, na Wela nia Iimola gi, tara daka fale nau fuana abana tooa da keketo.>> ");
INSERT INTO llu_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Sui na fafurongo nia gi langi dasi haitamana si taa naa si manata ana si baea nae gi nia e haea. God e haufinia na malutana si baea nae gi faasida. Ma daalu laugo da mou uria ledilana sulia si malutaa nae. ");
INSERT INTO llu_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Sui na oolisusuua ka liu i matangana na fafurongo a Jesus gi, sulia ni tei ani gera na wane naonao i matangada. ");
INSERT INTO llu_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ma sulia Jesus e haitamana si manataa gi lioda, nia ka ngalia tee wela, ma ka faatakea i ninimana, ");
INSERT INTO llu_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ma ka bae urii fuada, <<So ni tei na ka gonitainia wela nae sulia na manata mamanalaa nia ani nau, nia ka gonitai nau lau go. Ma so ni tei na ka gonitai nau, nia ka gonitainia laugo a God na e oodu nau mai. Sulia ni tei naa e faatoꞌou nia i talana i matanga gamu, nia na wane e naonao.>> ");
INSERT INTO llu_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Sui a John ka bae urii, <<Aarai ae, gemelu rikia tee wane e taria na aagalo taꞌa ana hatamu, ma melu ka luia faasia iililanalaa, sulia i nia kasi too oofu fai golu.>> ");
INSERT INTO llu_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","A Jesus ka bae urii fuada, <<E langi musi lui nia, sulia ni tei na langi kasi take bokota gia, i nia na wane naa fai gia.>> ");
INSERT INTO llu_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Si kada e dao garangi naa eeri a Jesus ka tatae i langi, nia ka manata teefou naa uria lealaa fui Jerusalem. ");
INSERT INTO llu_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ma nia ka falea teni wane gi daka eeta i nao ani nia. Gera lea ma daka dao ana tee fera ana na lolofaa i Samaria eeri daka aade aagau ana na doo gi sui maasi nia. ");
INSERT INTO llu_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Sui taa, na iimola gi i seenae langi dasi dooria go na gonitailana, sulia i nia na wane Jiu na e lea ana uria i Jerusalem. ");
INSERT INTO llu_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ma si kada na roo wane fafurongo gi a James ma a John daaro rikia si doo naa, daaro ka bae urii fuana, <<Lord ae, e utaa? I oe o dooria mere ka gani uria ta eere faasia i langi eeri ka haungi gera?>> ");
INSERT INTO llu_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Sui a Jesus e aabulo ma ka ngatafida. ");
INSERT INTO llu_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ma daka lea na ada uria ta fera eꞌete. ");
INSERT INTO llu_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ma ana si kada gera lea naa sulia na tala, tee wane ka bae urii fuana a Jesus, <<Nau ku lea fai oe so i fai na o lea uria.>> ");
INSERT INTO llu_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","A Jesus ka bae urii fuana, <<Si doo naa langi kasi waluda. Na kui kwasi gi da too ana na kilu gera gi uria teolaa, ma na manu gi laugo daka too ana na nui gera gi. Haia, i nau na Wela nia Iimola gi, langi kusi too ana ta luma hai so kuka teo ana.>> ");
INSERT INTO llu_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ma a Jesus ka bae urii fuana ta wane aai, <<O lea mai i fai nau.>> Sui na wane nae ka bae ana urii, <<Aarai ae, o faalamaini nau eeri kuka lea, ku aalua fasi na maa nau.>> ");
INSERT INTO llu_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ma a Jesus e oolisia ka urii, <<O faalamainia na tooa gi na langi dasi too ana mouria faasia a God daka aalua na ada na iimola mae gera gi. I oe mone, o lea, oko faataloa na Initooa nia a God.>> ");
INSERT INTO llu_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ma ta wane aai lau ka bae urii, <<Aarai ae, i nau ku lea i burimu. Sui taa, o faalamaini nau hai so ku lea ma kuka aalualu fasi fuada na iimola nau gi i fera.>> ");
INSERT INTO llu_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","A Jesus ka bae urii fuana, <<Tee wane na e hafalia na lealaa fai nau, sui taa nia e manata asianaa sulia na doo gi na e tafusida, i nia langi kasi bobola fai nia a God na Aaofia nia.>> ");
INSERT INTO llu_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","I buira na doo naa gi, a Jesus na Lord e filia fiu aakwala ma roo wane, ma ka falea daka lea roo wane - roo wane eeri daka lea i nao ana fuana fera gi sui go na i nia e manata uria lealaa ana gi. ");
INSERT INTO llu_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ma i nia ka bae urii fuada, <<Na tooa gi na da aade aagau naa uria manata mamanalaa ana a God, gera iilingia na doo oro gi i laona na hara uria gonilana. Sui taa, na wane gi ni gonilana na doo nae gi na e langi dasi oro. Nia naa, muka gania a God eeri ka falea mai na wane ni raolaa gi fai gamu. ");
INSERT INTO llu_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Molu lea naa. I nau ku oodu gamu iilingia na gala sipsip gi i matangada na kui kwasi gi, sulia iimola oro gi da dooria labasilaa gamu. ");
INSERT INTO llu_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","E langi musi ngalia tesi malefo ma langi ta wai ni aalu malefo i laona ma langi ta tae silipa. Ma ka langi musi abero ana baelaa fai nia ta iimola sulia tala. ");
INSERT INTO llu_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ma si kada mu ruu ana ta luma, muka bae urii, <Na fanualama ka too fai gamu na iimola gi i laona na luma naa.> ");
INSERT INTO llu_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ma lea na wane na e too i seenae ka dooria laugo na fanualama, na fanualama gamu ka too ana fai nia na wane nae. Ma lea so ka langi, na fanualama nae ka ooli laugo mai fuagamu. ");
INSERT INTO llu_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Muka too i laona na luma nae, ma muka ania tesi fanga ma muka gwoufia si doo na da falea fuagamu. Sulia na wane na e rao ka ngalia go ana na folilaa nia. Ma langi musi idu faasia ta luma uria ta luma aai lau. ");
INSERT INTO llu_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","<<Ma si kada mu dao ana ta fera ma daka gonitai gamu, muka ania tesi fanga taa na da falea fuagamu. ");
INSERT INTO llu_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ma muka guraa na iimola matai gi i laona na fera nae, ma muka bae urii fuana na iimola gi i seenae, <Si initooa a God e dao garangi gamu naa.> ");
INSERT INTO llu_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ma lea mu dao ana ta fera ma langi dasi gonitai gamu, muka lea sulia na tala gi i laona na fera nae ma muka bae urii, ");
INSERT INTO llu_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","<Na aafuafui gano ana na fera gamu na e kau boroi ana na lofo aemelu, melu ka kwae tafusia na kou. Nia naa na mamalafooa ana ngatafilaa gami ani gamu. Molu ka manatatoona si doo naa: Si initooa a God e dao garangi gamu naa.> ");
INSERT INTO llu_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","I nau ku haea fuagamu, ana fe Dani ni keketolaa, tara a God ka falea na kwakwaea fuana na fera taꞌa baa i Sodom. Sui tara nia ka falea na kwakwaea baita ka tasa fuana fera nae liufia fera Sodom!>> ");
INSERT INTO llu_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","A Jesus e bae urii, <<Aangilaa ma na suungimaea tara ka dao ani gamu na mu too i fera Koresin. Ma ni gamu na mu too i fera i Betsaeda ka urinae laugo. Sulia si doo kwaibalatana gi ku aadea fuagamu, lea so daka aadea i Taea ma i Saedon i nao, na tooa gi i seenae boro daka gwouru i aano, ma daka ruufafi gera ana si maku ana too bilia, ma daka uusua nonida ana fua, eeri ka faatainia gera oolitai manata sui na faasia aade taꞌalaa gera gi. ");
INSERT INTO llu_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Haia, ana fe dani a God tara ka keketoa na molaagali, si kwakwaelaa gamu tara ka tasa liufia na tooa gi i Taea fai nia Saedon. ");
INSERT INTO llu_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Haia, gamu na too i Kapaneam, na manata gamu baa haea a God tara ka iigini gamu uria Initooa i Langi. Sui taa, tara nia ka ui ani gamu fui si gula ni maea.>> ");
INSERT INTO llu_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Sui a Jesus ka bae urii fuana oote fafurongo nia gi, <<So ni tei na ka rongo suli gamu, nia ka rongo suli nau laugo. Ma so ni tei ka oote nia ani gamu, nia ka oote nia ani nau laugo. Ma so ni tei ka oote nia ani nau, nia ka oote nia laugo ana a God na e oodu nau mai.>> ");
INSERT INTO llu_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ma na fiu aakwala ma roo wane baa gi da lea naa. Ma ana si kada gera ooli mai, daka eele asianaa ma daka bae urii, <<Lord ae, na aagalo taꞌa gi boroi da roosuli gemelu si kada melu tarida ana na hatamu!>> ");
INSERT INTO llu_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","A Jesus e oolisida ka urii, <<I nau ku rikia a Satan e asia ka iilingia ta sinamaaru faasia i langi. ");
INSERT INTO llu_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Molu fafurongo fasi! I nau ku falea naa na rigitaa fuagamu eeri muka haitamana falilaa i fafona na loi gi ma na doo ala gi. Ma si kada muka daotoona na rigitaa nia gi sui a Satan na maalimaea, e afetai daka falea na fiilaa fuagamu. ");
INSERT INTO llu_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Sui taa, e langi musi eele lau sulia na aagalo taꞌa gi da roosuli gamu. Muka eele agamu sulia a God e kedea naa na hatagamu i langi.>> ");
INSERT INTO llu_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ma ana si kadamanga nae, Aanoedoo Aabu e faaelea a Jesus, ma nia ka bae urii, <<Maa ae, oe Lord usia i langi ma i aano fuu. Nau ku baelafe oe, sulia na o faatainia amu na doo nae gi fuana tooa da iilingia wela toꞌou gi, ma oko haufinia si doo naa gi faasia tooa da liotoo ma tooa da bubu haitamana si doo oro gi. Iiuka Maa, na doo nae gi e urinae na sulia na kwaidooria oe ua na mai i nao.>> ");
INSERT INTO llu_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Sui a Jesus ka bae urii, <<A Maa nau e falea sui na doo gi sui fuagu. Ma taifilia a Maa go na e haitamagu na Wela nia. Ma tee taifilia laugo na Wela nia taifili nia go na e haitamana a Maa nia, ma tee taifili gera go na Wela nia e aadafilia fuana ka faatainia fuada, na gera haitamana na Maa.>> ");
INSERT INTO llu_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Sui a Jesus e aabulo fuana oote fafurongo nia gi taifilida, ka bae urii, <<Oilakea fuagamu sulia mu rikia si doo naa gi i taraꞌena. ");
INSERT INTO llu_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nau ku hae fuagamu, profet oro ma na aaofia oro laugo da dooria rikilana si doo naa gi mu rikia i taraꞌena, sui ka afetai fuada. Ma daka dooria asianaa laugo na rongolana si taa gi na mu rongoa i taraꞌena, sui ka afetai laugo fuada.>> ");
INSERT INTO llu_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Tee wane faatolomai ana na kwaieresia gi e lea mai siana a Jesus uria na iilitoolana, ma ka bae urii, <<Wane faatolomai ae, si taa naa nau tara ku iilia eeri kuka too ana na mouria firi?>> ");
INSERT INTO llu_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ma a Jesus e oolisia ka urii, <<Taa naa na Kekedelaa Aabu gi da haea? Ma o iidumi utaa ada?>> ");
INSERT INTO llu_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ma na wane nae e oolisia ka urii, <<Oko rakediana ana a God na Lord oe, ana liomu teefou ma na mangomu teefou ma na rigitalamu teefou. Ma oko rakediana fuana na iimola gi lau ana aefera oe ka iilingia laugo o rakediana fuamu i talamu.>> ");
INSERT INTO llu_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ma a Jesus e bae ka urii, <<Si oolisilaa oe nia mamana. O iilia si doo nae, ma oko mouri.>> ");
INSERT INTO llu_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Sui taa, na wane faatolomai nae ana kwaieresia gi e ida laugo, ma nia ka ledia lau a Jesus ka urii, <<Ni tei naa na wane aefera nau gi?>> ");
INSERT INTO llu_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ma a Jesus e oolisia ka urii, <<Tee wane Jiu e too mai i Jerusalem ma ka lea uria i Jeriko. Ma si kada nia e lea ua ana sulia na tala, na wane bebeli gi daka haungia, ma daka laua na doo nia gi sui fai nia na maku nia gi. Ma daka rabusia lelea ka garangi mae, ma daka lugasia, daka lea na ada faasia. ");
INSERT INTO llu_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ma ana si kada nae, tee fataabu e lea go sulia na tala nae, ma si kada e rikia na wane baa, nia ka tasa laugo ana sulia ta bali tala aai, ma ka lea naa. ");
INSERT INTO llu_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Sui tee wane kwaiꞌadomi i laona na Beu Aabu a God e lea laugo mai sulia na tala nae. Ma ana si kada nia e dao i seenae, nia ka rikia na wane baa. Sui i nia laugo ka tasa ana faasia ana ta bali tala aai, ma ka lea naa. ");
INSERT INTO llu_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Sui tee wane faasia na lolofaa maadiu i Samaria e lea laugo mai sulia na tala nae. Si kada nia e rikia na wane baa, nia ka kwaimanatai asianaa fuana. ");
INSERT INTO llu_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ma nia ka lea mai siana, ma ka igitainia na gwai ma na waen faafia na maala nia gi, ma ka afua. Sui nia ka faataea i fafona na hosi nia, ma ka ngalia naa fuana tee beu na da foli uria na toolaa i laona, ma ka aadasulia i seenae. ");
INSERT INTO llu_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ma ana ruana fe dani, nia ka lafua roo fe rebe malefo, ma ka falea fuana na wane na e aadasulia na beu nae, ma ka bae urii fuana, <O aadasulia na wane naa, ma si kada ku ooli lau mai ana, nau kuka duua fita si malefo na o nagaa fuana.>>> ");
INSERT INTO llu_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Sui a Jesus ka bae urii, <<I oe o manata utaa? Ni tei ani daalu na oolu wane naa gi na i nia na wane aefera nia na wane baa na wane bebeli gi da kwaea?>> ");
INSERT INTO llu_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ma na wane faatolomaia nae ana kwaieresia gi e bae lau ka urii, <<Na wane na e kwaimanatai fuana.>> Ma a Jesus e oolisia ka urii, <<O lea, oko iili urinae laugo.>> ");
INSERT INTO llu_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Si kada a Jesus ma na oote fafurongo nia gi da lea ana, daka dao ana tee maefera, ma tee geni na hatana ni Mata ka gonitainia a Jesus uria i laona na luma nia. ");
INSERT INTO llu_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ma na haasina ni Mary ka gwouru garangia na aena a Jesus na Lord, ma ka fafurongo ana uria na faatolomailaa nia gi. ");
INSERT INTO llu_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ma ni Mata na manatalana ka asia sulia ni nia go ana na e iilia na raoa gi sui go i luma. Ma nia ka lea mai siana a Jesus, ka bae urii fuana, <<Lord ae, e utaa? Oe osi manata aꞌabo go sulia na haasigu na e tafusi nau go ana kuka iilia go agu na raoa naa gi sui taifili nau? O haea fuana eeri i nia ka lea mai ka adomi nau laugo!>> ");
INSERT INTO llu_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ma a Lord e oolisia ka urii, <<Mata ae, ni oe o manata aꞌabo ma na manatalamu ka abero sulia na doo oro gi asianaa. ");
INSERT INTO llu_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Haia, ma tesi doo go na e initoo. Ni Mary ana na e filia ana oꞌoloa, ma e afetai ta wane ka lafua naa faasia.>> ");
INSERT INTO llu_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ana tee maedani, a Jesus e fooa ana, ana tesi gula. Ma si kada e fooa sui, tee wane ada na oote fafurongo nia gi ka bae urii fuana, <<Lord ae, o faatolomai gami ana fooalaa, iilingia na a John e faatolomainia laugo na oote fafurongo nia gi.>> ");
INSERT INTO llu_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","A Jesus ka bae urii fuada, <<Si kada mu fooa ana, muka bae urii, <Maa ae, gami dooria tooa gi sui daka faabaitaa na hatamu sulia nia e aabu asianaa. Na Initooa oe ka dao mai. ");
INSERT INTO llu_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ma oko falea fasi mai fuagami na fanga na e bobola fuagami sulia dani. ");
INSERT INTO llu_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ma oko manata lukea na aade taꞌalaa gami gi sulia i gami mi manata lukea na iimola gi sui na da iilia si aade taꞌa gi fuagami. Ma osi eekwatai gami uria na iilitooa.>>> ");
INSERT INTO llu_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ma a Jesus ka bae ana tesi oomelawanea urii fuana na oote fafurongo nia gi, <<Lea so ta wane ani gomolu ka lea siana na ruana nia lao initoona na rodo, ma ka bae urii fuana, <Ruana ae, o falea fasi mai ta oolu fe beredi fuagu. ");
INSERT INTO llu_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Sulia tee wane ruana agu na e too mai ana fera tau, ka dao mai siagu. Sui ka langi kusi too ana tesi fanga hai kuka falea fuana.> ");
INSERT INTO llu_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ma lea na ruana nia nae e langi si lea mai i maa, ma ka bae urii, <Langi osi aberotai nau! Na maa e bilake naa, ma na wela nau gi melu ka teo sui naa. Afetai kuka tatae lau uria falelana tesi doo fuamu.> ");
INSERT INTO llu_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Haia, i nau ku haea fuamolu, boroi ana so i nia ka langi si doori iililana tesi doo, lea so na wane nae e gania ka tasa dongaa go ana, na wane aai na i luma ka tatae ma ka falea go ana na doo gi sui na nia e doorida. Ma i nia iilia langi lau sulia na wane nae na ruana nia, ma sulia go ana na i nia langi kasi ida uria ganilaa. ");
INSERT INTO llu_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Nia na ku haea si doo naa fuamolu. Molu gani, ma molu ka ngalia si doo na molu gani uria. Molu ka nani, ma molu ka rikia si doo na molu nani uria. Molu ka kidikidi, ma na maa ka ifi fuamolu. ");
INSERT INTO llu_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Sulia na tooa gi sui na da gani, daka ngalia na doo na da gania. Ma na tooa gi sui na da nani, daka rikia na doo na da nani uria. Ma na tooa gi sui na da kidikidi, na maa ka ifi fuada. ");
INSERT INTO llu_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","<<Ma ni tei ani gomolu na maa gi, lea so ta wela oe ka gania iia, langi osi falea na loi fuana! ");
INSERT INTO llu_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ma lea so na wela oe e gani uria tee fe faleke karaikua, langi osi falea ana ta subu fuana! ");
INSERT INTO llu_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Sui boroi ana na molu ka taꞌa, i gomolu molu haitamana na falelana si doo diana gi fuana wela gomolu gi. Ma na Maa na i langi e rakediana baita ka tasa. Nia naa, nia ka falea na Aanoedoo Aabu fuada na tooa gi na da gani nia uria!>> ");
INSERT INTO llu_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ana tesi kada, Jesus e taria tee aagalo faasia tee wane fakana e ato. Ma si kada aagalo na e tafi faasia, nia ka bae lau. Ma na tooa oro na da figu, gera ka kwele. ");
INSERT INTO llu_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ma teni wane ada gi gera ka bae urii, <<Nia tari aagalo ana Bielsebul na wane baa e initoo usia na aagalo gi. Nia naa e falea mamanaa naa fuana ka tari aagalo ana.>> ");
INSERT INTO llu_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ma teni tooa ani gera, da dooria faamalaꞌoelana a Jesus. Ma gera ka gania hai nia ka aadea ta doo kwaibalatana eeri ka faatainia na nia e lea mamana mai faasia a God. ");
INSERT INTO llu_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ma sulia na a Jesus e haitamana go ana na manatalada, nia ka bae urii fuagera, <<Lea so ta initooa ka firu fai gera i talada, na initooa nae ka funu. Ma lea so ta aebara da firu fai gera i talada, gera ka tagalangai gera naa. ");
INSERT INTO llu_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Haia, ma so na initooa a Satan lea so ka firu fai nia i talana, tara na initooa nae ka labasia i talana. Nau ku haea si doo naa gi sulia molu haea nau ku tari aagalo ana mamanaa a Bielsebul. ");
INSERT INTO llu_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Haia, ma lea ku tari aagalo ana mamanaa a Bielsebul, mamanaa tei mone ana na bali amolu gi na da tari aagalo gi ana? Sulia si doo naa gi, nia e faatainia i gomolu molu garo. ");
INSERT INTO llu_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ma ni nau ku taria aagalo gi ana mamanaa a God. Haia, ka faatainia fuagamu na Initooa a God e dao mai siagamu.>> ");
INSERT INTO llu_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Jesus ka bae lau ana tesi oomelawanea ka urii, <<Lea na wane ramo e aade aagau ana raunga ni firu nia gi ma ka folo usia luma nia, e afetai ta wane ka labasia na doo nia gi i laona luma nia. ");
INSERT INTO llu_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ma lea so ta wane na e rigita ka tasa ani nia e lea mai ma ka firu fai nia ma ka tasa ana, tara na wane nae ka ngali teefou na ana doo ni firua nia gi e fiitooda, ka tolingia teefou na doo gi sui fuana ruana nia gi. ");
INSERT INTO llu_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","<<Haia, ni tei naa e langi kasi lea suli nau, nia na maalimaea nau. Ma ni tei na langi kasi adomi nau uria oofulana mai tooa gi siana God, nia ka tagalangai gera na faasia God.>> ");
INSERT INTO llu_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","A Jesus ka bae lau urii, <<Si kada aagalo taꞌa e lea faasia ta wane, nia ka liliu i aanogwou, ma ka nani uria ta gula hai ka too lau ana. Ma lea nia nani ka langi naa, nia ka manata urii, <Boro nau ku ooli lau siana wane baa na ku too mai siana i nao ma kuka lea mai faasia.> ");
INSERT INTO llu_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Si kada nia e ooli mai ka dao, nia ka rikia si gula baa gera salofia ma daka olosia sui naa. ");
INSERT INTO llu_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Si kada nia e rikia urinae sui, nia ka ooli ma ka talaia lau mai ta fiu aagalo taꞌa ka tasa liufia, daalu lea mai, daalu ka too naa laona wane baa. Ana si kada nae, na taꞌalana wane nae ka taꞌa ka liufia i nao.>> ");
INSERT INTO llu_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Si kada Jesus e haea si doo naa gi fuada sui, tee inite aai laona figua naa e rii ka bae urii, <<Na geni na e kwalafi oe ma ka faasusufi oe, nia e eele ka tasa.>> ");
INSERT INTO llu_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Sui taa, a Jesus e oolisia ka bae urii, <<Langi go. Tei gera na da rongoa baelana God ma gera ka iili sulia baelana, gera naa da eele ka tasa.>> ");
INSERT INTO llu_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ma kada tooa oro gera figu mai garangia a Jesus, nia ka bae urii fuagera, <<Gamu na uuni wane naa, gamu na uuni wane taꞌa. Sulia mu doori rikilana doo kwaibalatana, ma ka afetai muka rikia ta doo kwaibalatana. Ma tara muka rikia go agamu na doo kwaibalatana iilingia na doo baa e fuli fuana profet Jona. ");
INSERT INTO llu_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Sulia Jona e iilingia ta mamalafooa fuana tooa i Niniva. Ka urinae laugo ani nau, na Wela nia Iimola gi, kuka iilingia laugo ta mamalafooa fuana tooa naa ana si kada nae. ");
INSERT INTO llu_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ma ana maedani tara a God ka ketoa ana tooa, na geni aaofia baa ana maefera i Siba, tara nia ka take ma ka faatainia na doo taꞌalaa gamu tooa ana uuni wane naa, sulia na aabulolaa gamu e garo asianaa. Nia e lea tau na mai faasia suilana molaagali uria rongolana haitamadooa a Solomon. Sui taa, tee wane na e baita ka tasa liufia a Solomon e too i see i taraꞌena, ma gamu si rongo nia go. ");
INSERT INTO llu_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ka urinae laugo ana si kada God tara ka ketoa ana tooa. Na tooa i Niniva tara gera ka faatainia na doo taꞌalaa gamu ana fe dani ni keketoa, sulia gera aabulo sui na faasia si garolaa gera gi, si kada gera rongoa a Jona e funao ana fuada. Haia, wane baita ka tasa liufia a Jona e too naa i seegi i taraꞌena, sui langi gamu musi oolitai manata go.>> ");
INSERT INTO llu_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","A Jesus ka bae urii, <<Langi ta wane na e faaharua na laeta, sui nia ka haufinia ana, ma langi ka aalua ana farana ta teu. Kada nia e faaharua laeta sui, nia ka aalua na mone ana gula ni aalu laetalaa, eeri ni tei na e ruu mai lao luma, nia haitamana ka rikia raralana. ");
INSERT INTO llu_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Na maamu e iilingia laeta fuana nonimu. Lea na maamu e gwagwalifolaa, na nonimu laugo ka folaa. Ma lea na maamu e rorodoa, na nonimu laugo ka rorodoa. ");
INSERT INTO llu_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Nia naa, oko susulia na laeta na e too ani oe, aata ka rorodoa go ana. ");
INSERT INTO llu_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Lea na nonimu teefou ka folaa ma ta bali amu kasi too lao rorodoa, oe o folaa teefou naa iilingia na laeta baa e talafi oe ana raralana.>> ");
INSERT INTO llu_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ana si kada Jesus e faasuia ana baelana, tee wane ana Farisi gi ka soea uria fangalaa i luma nia. A Jesus ka lea fai nia, ma ka gwouru naa uria fangalaa. ");
INSERT INTO llu_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ma na Farisi na ka kwele asianaa sulia nia e rikia a Jesus e langi kasi fuloa na abana i nao suifetei na fangalaa. ");
INSERT INTO llu_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ma Jesus na Lord ka bae urii fuana, <<Gamu Farisi gi mu manata aꞌabo asianaa uria taufilana bali maa ana teteu ni gwou gi ma na doo ni fanga gamu gi go. Sui taa, i laona na manatalaa gamu gi e fungu ana doo taꞌa gi sui. ");
INSERT INTO llu_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Gamu mu nue asianaa! God, na wane na e haungainia na bali maa ana si doo gi sui, nia e haungainia laugo na bali lalo. ");
INSERT INTO llu_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Haia, mu falea si taa gi na e too i laona teteu ni gwou gamu gi fai nia si taa gi na e ni laona doo ni fanga gamu gi fuana tooa siofaa eeri si doo gamu gi sui ka faalu. ");
INSERT INTO llu_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","<<Kwaimanatai asianaa fuagamu Farisi gi i sulia mu falea go agamu fuana a God ta bali ana tangafuluna mumuduna si fanga gi na mu fasia laona raoa gamu gi. Sui taa, langi musi manata aꞌabo go uria olosilana toolaa gamu gi fai nia na wane aefera gamu gi ma na rakedianalaa gamu gi fuana God. Nia e diana na muka iilia gala si doo nae gi, ma muka manatatoona laugo si doo baita gi. ");
INSERT INTO llu_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","<<Kwaimanatai asianaa fuagamu Farisi gi, sulia si kada mu lea lao Beu Aabu ni figulaa, muka dooria gwourulaa ana fuli ni gwourua ana babaitaa. Ma ana si kada mu lea i maana usia gi, muka dooria tooa gi gera ka faaꞌinitoo gamu. ");
INSERT INTO llu_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Kwaimanatai fuagamu Farisi gi, sulia mu iilingia na kwaingeia gi na langi dasi uia ana fou, ma si kada wane gi da liu i fafoda, langi dasi aada haitamana.>> ");
INSERT INTO llu_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Sui tee wane ana faatolomai ana kwaieresia gi ka bae urii, <<Faatolomai ae, si kada oe bae urinae, o bae labasi gemelu laugo nae.>> ");
INSERT INTO llu_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ma Jesus ka bae urii, <<Kwaimanatai laugo fuagamu faatolomai gi ana kwaieresia gi, sulia mu haungainia kwaieresia afetai oro gi fuana tooa, ma ka afetai fuada uria roosulilana, ma langi musi adomia gera laugo. ");
INSERT INTO llu_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Kwaimanatai laugo fuagamu sulia mu haungainia doo diana gi fafona kwaingeia gera profet gi ka aada diana asianaa, na profet baa gi na koo gamu gi da haungida. ");
INSERT INTO llu_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Sulia si doo nae gi, na nia ka faatainia na mu aalafaafia si iililaa taꞌa nae gi na koo gamu gi da aadeda fuada. Sulia gera haungida ma ni gamu muka uia na kwaingeia gera gi. ");
INSERT INTO llu_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ma sulia tesi doo laugo, na God ana liotooa nia, nia ka bae urii, <Nau tara kuka oodua kou na profet ma na aposol gi siada, sui gera ka haungia bali ada, ma gera ka iinokesia laugo ta bali ada.> ");
INSERT INTO llu_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Aena nana naa, tooa gi ana uuni wane naa tara daka ketoda faafia na haungilana na profet gi e ita ua mai ana hafalilana molaagali. ");
INSERT INTO llu_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Talaꞌae mai ana maelana Ebol lea mai ka dao ana maelana Sekaraea na wane baa gera haungia laona Beu Aabu a God, i matangana fuliere ma na fuli aabu. Doo mamana na nau ku haea fuagamu, tara na tooa ana uuni wane na gera ka ketoda faafia maelana tooa naa. ");
INSERT INTO llu_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","<<Kwaimanatai fuagamu faatolomai ana kwaieresia gi, sulia mu haufinia na mamanalaa sulia a God, hai so na tooa langi dasi haitamana. Langi musi manata mamana ana, ma muka suusia na tooa uria haitamanalaa.>> ");
INSERT INTO llu_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Haia, ana si kada Jesus nia e lea naa faasia fera nae, na wane faatolomai gi ana kwaieresia gi ma na Farisi gi gera ka talaꞌae aaefara, ma daka ledia ana si doo oro. ");
INSERT INTO llu_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ma gera ka malaꞌoea a Jesus uria daotoolana tesi taa nia e haea ka garo. ");
INSERT INTO llu_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ana tesi kada, tooa oro asianaa, e bobola fai nia teni tooni da figu mai uria rongolana Jesus. Ma Jesus ka bae urii fuana oote fafurongo nia gi, <<Muka aadasuli gamu faasia na manata taꞌa gera Farisi gi, sulia da haitamana sugelana tooa ana maluta taꞌa gera gi. ");
INSERT INTO llu_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Si taa gi na wane e haufinia, tara daka faatainia go ada. Ma si doo haufini gi, gera ka haitamana laugo. ");
INSERT INTO llu_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ma si taa gi na mu haea i laona rorodoa, gera ka rongoa lao dani. Haia, ma si taa gi na mu fuarotainia lao aalingana ta wane ana ta gula banitai taifili gomoro, gera ka ainitalo ana fuana wane gi, sui daka rongoa sui.>> ");
INSERT INTO llu_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Haia, Jesus ka bae urii lau, <<Nau ku haea fuagamu oote ruana nau, langi musi moungia ni tei gera na da haungia na noni gamu, ma i buira gera ka lafusia tesi taa taꞌa lau daka iilia ani gamu. ");
INSERT INTO llu_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ma i nau ku faatainia fuagamu wane aai na fuana muka moungia: muka moungia a God. Sulia nia naa na e haitamana ka haungia noni gamu, ma ka too laugo ana mamanaa uria ui anilagamu laona gula ni kwakwaea. Iiuka, nau ku haea fuagamu, God naa na muka moungia. ");
INSERT INTO llu_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","<<Na manu totoꞌou gi, gera haitamana faafoli go ada uria si malefo toꞌou. Manu gi daka toꞌou boroi ada, God e afetai ka manata buro ana tee fe manu ani gera. ");
INSERT INTO llu_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Sui boroi na iifuna ketemu, God e haitamana laugo. Aena nana langi musi mou, sulia God e manata baita ana tooa ka liufia na manu oro gi.>> ");
INSERT INTO llu_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Sui a Jesus ka bae urii lau, <<Nau ku haea fuagamu, lea ta wane e faatalo ana tooa gi uria nia na fafurongo nau, na Wela nia Iimola gi, tara kuka uunuunu laugo suli nia i naona ensel a God gi. ");
INSERT INTO llu_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ma lea ta wane ka kwaigoloi ani nau siana wane gi, nau laugo tara kuka kwaigoloi ana wane nae naona ensel a God gi. ");
INSERT INTO llu_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","<<Haia, lea ta wane ka bae taꞌa suli nau, a God haitamana ka manata lukea go ana. Sui lea ta wane ka bae taꞌa sulia Aanoedoo Aabu, a God e afetai ka manata lukea wane nae. ");
INSERT INTO llu_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","<<Ma tara gera ka ngali gamu uria ketolagamu i laona Beu Aabu gi ni figulaa nia langi naona wane baita gi. Ana si kada nae, langi musi mou, ma langi so muka manata aꞌabo uria si baelaa taa gi na tara muka haea ma muka oolisi gera ana. ");
INSERT INTO llu_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Sulia ana si kada nae, na Aanoedoo Aabu ana tara ka faatolomai gamu ana si doo gi na tara muka haeda.>> ");
INSERT INTO llu_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Tee wane i laona na figua nae e bae urii fuana a Jesus, <<Faatolomai ae, o haea fuana na aua nau hai ka tolingia na doo gemere gi na maa gemere e tafusia fuamere.>> ");
INSERT INTO llu_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ma a Jesus e oolisia ka urii, <<Ruana ae, ni tei naa e falea na mamanaa fuagu uria na ketolana ma na tolingilana na doo nae gi i matanga moro?>> ");
INSERT INTO llu_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ma i nia ka bae urii fuada sui, <<Muka manata diana, aata gamu ka lulugoni. Sulia na mourilana wane mamana e langi si ngado i fafona na malefo ma langi na todalaa.>> ");
INSERT INTO llu_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Sui a Jesus ka uunuunu sulia si baea oomelawane naa fuada ka urii, <<Tee wane todadoo e too ana tesi gano diana na e fasi doo i laona, ma ka gonia na doo diana oro gi e faasia. ");
INSERT INTO llu_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ma nia ka hafalia manatalaa i talana i liona ka urii, <Tara kuka iili utaa naa? Sulia nau kusi too ana tesi gula uria na taingailana na doo gi na ku gonida. ");
INSERT INTO llu_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Si doo na tara kuka iilia e urii: Tara kuka oogosia na babala ni taingaia nau gi, ma kuka tolea lau ta doo faalu gi na e baita. Ma i nau kufi taingainia na mige doo nau gi ma teni si doo gi lau i seenae. ");
INSERT INTO llu_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Sui nau ku bae lau urii fuagu i talagu, Oilakea asianaa fuamu! Ni oe o too na ana na doo diana oro gi na o doorida sulia fe ngali oro gi nae. O too mamalo na amu! Oko fanga diana amu, ma oko gwou amu, ma oko iilia na doo nae gi eeri na mourilamu ka eele sulia.> ");
INSERT INTO llu_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Sui taa, a God e bae urii fuana, <I oe o nue asianaa! Laona fe rodo naa i taraꞌena naa na oko mae, ma tara ni tei na ka nauhata ana na doo gi sui na o taingaida fuamu i talamu na?>>> ");
INSERT INTO llu_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ma Jesus e isia na faatolomailaa nae ka urii, <<Si doo naa tara ka fuli urinae fuada na iimola gi na da taingainia na doo gi sui fuada i talada, ma ka langi dasi too ana na bali todadoo na a God e manata uria.>> ");
INSERT INTO llu_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Sui Jesus ka bae urii fuana oote fafurongo gi, <<Nau ku haea fuagamu, langi molu si manata aꞌabo uria si taa na tara molu ka ania fai nia si taa na tara molu ka oofi ana. ");
INSERT INTO llu_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Sulia na mouria naa e diana tasa liufia na fanga, ma na noni naa e diana ka tasa liufia na maku. ");
INSERT INTO llu_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Aada muka rikia na manu gi i mamangaa, langi gera si too aꞌabo go uria raolaa ana ta raoa. Ma langi dasi koni fanga go, ma dasi haungainia go ta babala ni aalu fanga gi. Sui a God ka hangoni gera go ana. Haia, ma ni gamu, a God e manata baita ani gamu liufia manu gi. Nia naa, God e hangoni gamu laugo. ");
INSERT INTO llu_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","<<Ma boroi ana muka manata aꞌabo ana mourilaa gamu, e afetai go hasa muka aadea na mourilagamu so ka tekwa lau kou. ");
INSERT INTO llu_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Haia, ma lea so gamu ka langi si bobola go uria aadelana gala si doo urinae gi, uria taa na muka manata aꞌabo ana doo eꞌete gi? ");
INSERT INTO llu_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","<<Aada muka rikia fasi tage ai gi na da taga kwailiu go ada. Gera langi dasi rao go, ma langi dasi haungainia go ta maku. Ma nau ku haea fuagamu, gera aada diana ka tasa liufia maku eꞌete gi na a Solomon na Aaofia e ruufida gi. ");
INSERT INTO llu_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Haia, na tage ai gi gera too go ada sulia si kada kukuru, sui daka ui anida laugo ada laona eere. Sui ka urinae boro, a God ka faaofi gera ana si doo diana ka tasa. Haia, ma gamu manata hasa God ka langi si faaruufi gamu na ana ta maku? Na manata mamana gamu e toꞌou. ");
INSERT INTO llu_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","<<Haia, ma langi molu si manata aꞌabo asianaa uria si ta na muka ania ma langi so muka gwoufia. ");
INSERT INTO llu_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Sulia na tooa uugita gi na da haitamana manata aꞌabolaa uria doo naa gi sulia dani. Haia, ma ni gamu naa, na Maa gamu nia e haitamana ua na mai na mu dooria doo nae gi. ");
INSERT INTO llu_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Haia, lea doo muka manata agamu uria si Initooa a God, nia kafi falea fuagamu si doo nae gi na mu doorida.>> ");
INSERT INTO llu_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Sui a Jesus ka bae urii lau, <<Oote fafurongo nau ae, boroi ana gamu mu iilingia na aabui sipsip toꞌou, e langi musi mou, sulia a God na Maa e eele asianaa uria na falelana Initooa nia fuagamu. ");
INSERT INTO llu_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Muka faafoli ana na doo gamu gi sui, ma muka falea si malefo ana fuada na iimola siofaa. Lea so muka iilia si doo nae, tara muka too ana si doo diana i langi gi na e afetai ka fura. Haia, muka taingainia na todadoo gamu gi i langi, si gula na e afetai daka sui, ma si gula na wane bebeli gi dasi dao ana, ma ka langi ta susubu si labasida. ");
INSERT INTO llu_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Sulia molu ka manata sulia na gula na todadoo gamu e too ana. ");
INSERT INTO llu_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","<<Muka too ni aadaada maasia si taa gi na tara ka dao mai. Ma muka ruufia na maku gamu gi, ma na laeta gamu gi ka kwesu, ");
INSERT INTO llu_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","iilingia na wane rao gi na da maasia na wane baita gera ka ooli mai faasia ta fafangaa ana baraa. Si kada i nia e dao mai lao rodo ma ka kidikidi, aliꞌali daka ifingia na maa fuana. ");
INSERT INTO llu_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ka oilakea fuada na wane raoa gi na wane baita gera e daotooda da aada ua go ada maasia si kada nia e ooli mai ana. I nau ku haea na doo mamana gi fuagamu, i nia ka aade aagau, ma ka faagwourufida sui, ma ka raodoo fuada. ");
INSERT INTO llu_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ka oilakea fuada lea so nia ka daotooda gera kwaimaasimaasia, boroi ana so ka dao mai ana i initoona rodo ma langi i ofaidani! ");
INSERT INTO llu_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ma muka manatatoona si doo naa, lea so na wane ana luma e haitamana si kada na wane bebeli ka dao mai ana, e afetai na wane bebeli ka ruu i luma nia. ");
INSERT INTO llu_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","I gamu laugo muka too ni kwaimaasilaa sulia i nau, na Wela nia Iimola gi, tara nau kuka dao mai ana si kada na mu manata na daolagu tara katau ua go mai ana.>> ");
INSERT INTO llu_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","A Peter ka bae urii, <<Lord ae, e utaa? I oe o haea si oomelawanea naa fuamelu go ana naa ma langi fuana na iimola gi sui?>> ");
INSERT INTO llu_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","A Lord e oolisia ka urii, <<Ni tei naa na wane ni rao na e liotoo ma ka rao oꞌolo? I nia naa na aarai baita ka aalua ka baita usia na wane raoa gi aai, ka falea na fanga fuada ana si kada ni fale fangalaa. ");
INSERT INTO llu_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Haia, oilakea fuana na wane raoa nae na wane baita e daotoona i nia e iilia si doo nae gi ana si kada nia e dao mai ana i luma nia! ");
INSERT INTO llu_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","I nau ku haea na doo mamana fuagamu, na wane baita ka aalu nia ka baita usia na doo nia gi sui. ");
INSERT INTO llu_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Sui taa, ka taꞌa asianaa lea so na wane raoa nae ka manata urii, <Na wane baita nau e too mai ka tau ua go ana naa,> ma ka hafalia na kwaelana na wane raoa aai gi ma na geni raoa gi, ma ka fanga na ana ma ka gwou na ana lelea na gwouna ka rorodoa go. ");
INSERT INTO llu_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Sui na wane baita ka dao mai ana tee fe dani na i nia kasi manata go hasa i nia ka dao ana, ma ana si kada nae i nia e lalafusia go ana. Na wane baita ka kwai nia ana doo baita, ma ka aalu nia ana si gula gera iimola gi na langi dasi manata mamana. ");
INSERT INTO llu_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","<<Ma na wane ni rao na e haitamana go ana si taa na wane baita nia e dooria eeri ka iilia, sui taa, i nia kasi aade aagau ma kasi iilia go tesi doo na wane baita e dooria, tara daka rabusi baita ani nia. ");
INSERT INTO llu_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Haia, ma na wane ni rao aai na e langi kesi haitamana go na doo na wane baita nia e dooria, ma ka iilia tesi doo na e bobola fai nia daka rabusi nia, i nia tara daka rabusi toꞌou go ada ani nia. <<Lea a God e falea si oro fuana tee wane, God ka dooria laugo si oro faasia. Ma lea so a God e falea doo oro ka tasa fuana ta wane aai, nia ka dooria laugo si oro ka tasa faasia.>> ");
INSERT INTO llu_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","A Jesus ka bae lau urii, <<I nau ku lea mai uria na suungilana na molaagali, ma i nau ku dooria na eere nae ka talaꞌae haru naa! ");
INSERT INTO llu_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nau ku too ana tee siuabulaa na tara ku ngalia na e faafiia asianaa na mourilagu, ma e afetai ku eele lelea na siuabulaa nae ka sui go! ");
INSERT INTO llu_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","E utaa? I gamu mu manata hasa i nau ku dao uria na ngalilana mai na fanualama uria laona molaagali? Langi! Na tolilaa ana na ku ngalia mai. ");
INSERT INTO llu_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","E ita ana si kada naa ka ooli alaa, na luma ana lima iimola gi ka toli. Na oolu iimola ta bali ma na roo iimola ta bali. ");
INSERT INTO llu_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Na maa gi daka oolisusuu fai nia na alakwa gera gi, ma na wane daraa gi daka oolisusuu fai nia na maa gera gi. Ma na tee gi daka oolisusuu fai nia na haari gera gi, ma na haari gi daka oolisusuu fai nia na tee gera gi. Ma na fungo aai geni gi daka oolisusuu fai nia na geni fungao gera gi, ma na geni fungao gi daka oolisusuu fai nia na fungo geni gera gi.>> ");
INSERT INTO llu_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesus ka bae urii laugo fuana tooa gi, <<Lea mu rikia barobaro e tae mai i suulana hato, muka haitamana na tara na uuta ka aru. Ma nia ka aru mamana naa. ");
INSERT INTO llu_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Haia, ma lea na ooru e bango alaa mai, muka haitamana laugo tara ka agoꞌago. Ma tara ka agoꞌago mamana naa. ");
INSERT INTO llu_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Gamu tooa mu haitamana asianaa sugelaa, sulia mu haitamana aadaada i mamana fai nia na molaagali naa, ma muka aada haitamana laugo si mamalafooa gi. Sui taa, langi molu si aada haitamana si doo gi na e dao mai ana si kada nae.>> ");
INSERT INTO llu_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Jesus ka bae ka urii lau, <<Uria taa na langi molu si aadafilia amolu si doo diana gi fuana molu ka iilida? ");
INSERT INTO llu_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Lea so ta wane ka ngali oe uria na ketolamu siana wane ni keketo gi, ma i naona ua moro fi dao siana wane keketo gi, o iiliili uria olosilana si manata na i matanga moro. Sulia lea langi moro si iilia si doo nae, ma nia ka ngali oe siana wane ni keketo gi, ma buira gera keto oe sui, gera kafi fale oe fuana wane kakani wane gi, ma na wane kakani wane gi dafi aalu oe lao beu ni kanilaa. ");
INSERT INTO llu_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Haia, ma ni nau ku haea fuagamu, lea urinae, e afetai oko haga faasia beu ni kanilaa naa lelea oko falea si malefo isi oe na e too uria kwakwaea.>> ");
INSERT INTO llu_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ma ana si kada nae laugo, teni tooa gi da too i seenae da faarongoa a Jesus sulia na tooa gi faasia i Galili, na a Paelat e haumaelida, si kada gera kwaisuusi ada fuana God. ");
INSERT INTO llu_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Haia, a Jesus ka baea urii, <<Utaa? Sulia da haumaelia naa na tooa naa gi urinae, i gamu mu manata hasa i gera na tooa na aade taꞌalaa gera gi e baita ka liufia na tooa gi sui go i Galili nae? ");
INSERT INTO llu_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","E langi go! Ma i nau ku haea fuagamu, lea so e langi musi oolitai manata faasia na aade taꞌalaa gamu gi, i gamu sui go naa tara muka mae laugo iilingi gera. ");
INSERT INTO llu_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","I gamu mu manata utaa sulia na aakwala ma kwalu iimola baa gi i fera i Saelom na beu baita e asia faafi gera ma ka haumaelida naa? E utaa? Gamu mu manata hasa si doo nae e faatainia naa hasa i gera naa na tooa taꞌa ka liufia na tooa gi sui go na da too i laona fera i Jerusalem? ");
INSERT INTO llu_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Langi! Ma nau ku haea fuagamu, lea so e langi musi oolitai manata faasia na garolaa gamu gi, i gamu sui laugo na tara muka mae laugo iilingi gera.>> ");
INSERT INTO llu_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Sui a Jesus ka faarongo gera ana si baea oomelawanelaa naa ka urii, <<Tee wane e fasia tee ai na da alangia ana na figi na e tae i laona na raoa nia. Ana tesi kada, i nia e lea ma ka nani uria teni fe fufue doo gi i gwouna ai nae, sui nia ka langi si rikia go ta fufue doo. ");
INSERT INTO llu_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ma nia ka bae urii fuana na wane na e rao i laona na raoa nia nae, <O aada fasi, oolu fe ngali na ku lea mai uria na nanilaa uria na fufue ai gi, sui ka langi kusi rikia go tee fe doo. Haia, o tabalia na amu! Uria taa na ka too go ana uria na suusilana si gano uria na raolaa?> ");
INSERT INTO llu_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Sui na wane ni rao nae e oolisia ka bae urii, <Aarai baita ae, o faalamainia na ai naa ka too fasi ana sulia ta tee fe ngali na mone ana. Tara nau ku elia ta kilu tekwa galia, ma kuka aalua teni tafutafu i aena eeri ka faadiana na gano naa. ");
INSERT INTO llu_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Haia, lea na ai naa ka fungu ana ta fufue ai gi ana fe ngali loko, ka diana naa. Ma lea ka langi, ofi tabalia amu.>>> ");
INSERT INTO llu_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ana tee maedani ana Sabat, Jesus e faatolomai i laona tee Beu Aabu ni figulaa. ");
INSERT INTO llu_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ma tee geni e too i seenae na matai ana aagalo taꞌa na e iilia na ogina ka bou sulia aakwala ma kwalu fe ngali, ma ka lalafusia take oꞌololaa. ");
INSERT INTO llu_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ma si kada Jesus e rikia, nia ka bae urii fuana, <<Oe o akwaa naa faasia si mataia na e haungi oe.>> ");
INSERT INTO llu_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ma nia ka aalua abana gi fafona ogina, ma ana si kada nae ua go, na geni nae ka take oꞌolo, ma ka baelafea God. ");
INSERT INTO llu_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ma si kada wane baita nae ana Beu Aabu naa e rikia a Jesus e iilia si doo nae fuani geni naa ana maedani Sabat, na rakena ka hasu, ma ka bae urii fuana tooa nae gi, <<Oono fe maedani na fuana muka iililana si raolaa gamu gi. Haia, ana fe dani nae gi laugo, muka lea mai uria guralaa. Langi musi lea mai uria guralaa ana maedani Sabat.>> ");
INSERT INTO llu_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ma a Jesus na Lord e oolisia ka bae urii, <<Gamu mu haitamana asianaa na sugelaa. Sulia lea molu too ana bulumakau ma langi ta dongki, molu haitamana molu ka lukeda molu ka talaida fui kafo uria faagwoufiladalaa ana maedani Sabat. ");
INSERT INTO llu_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Haia, ma na geni naa, i nia na aai ana aebara koo gia Abraham laugo, ma Satan ka kani mai faafia sulia aakwala ma kwalu fe ngali. Haia, ma e diana fuana kuka guraa si mataia naa faasia ana maedani Sabat.>> ");
INSERT INTO llu_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Si kada Jesus nia bae urinae, na maalimaea nia gi gera ka ida asianaa ma na tooa gi gera kafi eele ada sulia si doo diana gi na Jesus nia e aadeda. ");
INSERT INTO llu_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Haia, Jesus e soeledia na tooa gi ka bae urii, <<Taa na si Initooa God e iilingia? Ma si doo taa na tara kuka bolangainia ana fuana ka folaa fuagamu? ");
INSERT INTO llu_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Nia e iilingia na mige doo toꞌou na wane e ngalia ma ka fasia laona raoa. Sui nia ka tae mai ma ka hau ana ai baita, ma na manu gi daka lea mai, gera ka too, ma daka haungainia na nui gera gi ana harana gi.>> ");
INSERT INTO llu_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ma a Jesus ka bae lau urii, <<Doo taa na tara kuka bolangainia ana Initooa a God? ");
INSERT INTO llu_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Nia iilingia na iisi uria faafufulana na beredi, na ta geni e ngalia ma ka dolalia fai nia fulaoa lelea na kumu nae ka fufu go.>> ");
INSERT INTO llu_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Si kada a Jesus e lea fui Jerusalem, nia ka liufia na maefera baita gi ma na maefera toꞌou gi, ma ka faatolomai doo fuada tooa oro gi. ");
INSERT INTO llu_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ma tee wane e ledia ka urii, <<Aarai ae, utaa? Tara aange wane go na God ka faamouri gera?>> A Jesus e oolisia ka urii, ");
INSERT INTO llu_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","<<Nau ku haea fuagamu, muka hasi rigita eeri muka ruu ana na maa na e logo. Sulia na tooa oro gi daka hasi uria na ruulaa, sui ka afetai fuada. ");
INSERT INTO llu_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Sulia na ruulana i langi e urinae laugo: Na wane baita ana luma ka tatae ma ka bilakea na maa. Ma tara gamu take mai i maa ma muka kidikidi ana maa, ma muka bae urii, <Aarai ae, o ifi kou urii gami.> Sui nia ka oolisia ka urii, <Nau langi kusi haitama gamu ma langi kusi haitamana si gula na gamu lea mai faasia.> ");
INSERT INTO llu_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Sui tara mu oolisia muka urii, <I gami mi fanga naa fai oe ma mika gwou naa fai oe, ma oko faatolomai naa i laona na fera gami gi.> ");
INSERT INTO llu_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Sui nia ka bae urii, <I gamu na tooa taꞌa gi, muka lea tau kou faasi nau. I nau kusi haitamagamu ma langi kusi haitamana si gula na gamu ita mai ana.> ");
INSERT INTO llu_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","<<Ma si kada mu rikia a Abraham ma a Aesak ma a Jakob ma na profet gi sui i laona Initooa a God, ma ni gamu na daka ui ani gamu i maa, tara muka aangi ma muka girigiri lifo! ");
INSERT INTO llu_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ma na tooa gi tara daka dao mai faasia i taelana hato ma i suulana hato ma faasia i bali alaa ma i bali toli, ma gera ka oogu ana fangaa loko i laona Initooa a God. ");
INSERT INTO llu_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Sulia na tooa gi na da isi si kada naa, tara daka eeta i nao. Ma na tooa aai gi na da eeta i nao si kada naa, tara daka isi.>> ");
INSERT INTO llu_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ana si kada nae, teni Farisi gi da lea mai siana Jesus, ma gera ka bae urii fuana, <<O lea faasia i see fuana ta fera eꞌete, sulia Herod na aaofia nia e doori ka haungi oe.>> ");
INSERT INTO llu_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ma Jesus ka bae urii, <<A Herod e iilingia na kui kwasi sulia nia e malaꞌoe asianaa. Haia, molu lea siana, molu ka bae urii fuana, i nau tara kuka tasa dongaa ua go agu fai nia tari aagalolaa fai nia guralana tooa da matai gi. Haia, i buira kafi haungi nau. ");
INSERT INTO llu_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Sui ka urinae boroi ana, nau kuka tasa dongaa agu ana lealaa nau fui Jerusalem i taraꞌena ma i bobongi ma teni fe dani lau. Sulia langi si bobola fuana gera ka haungia na profet ana fera eꞌete, ma tee taifilia i Jerusalem go.>> ");
INSERT INTO llu_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ma Jesus ka bae lau urii, <<Tooa i Jerusalem ae! Gamu baa mu uia fou gi uria haumaelilana na profet gi na God e ooduda mai fuagamu. Si kada oro nau ku doori muka lea mai siagu eeri kuka aadasuli gamu mala kakaraikua e obia na galena gi farana kukubana. Sui langi musi dooria go. ");
INSERT INTO llu_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Haia, ana si kada nae, tara God ka lea faasi gamu ma ka eekwatainia na Beu Aabu nia i fera gamu. Ma i nau ku haea fuagamu, tara langi musi riki nau lau lea ka dao ana si kada gamu muka bae urii, <God ka faadiana na wane na e lea mai ana hatana a Lord.>>> ");
INSERT INTO llu_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ana tee maedani Sabat, Jesus e lea uria fangalaa ana tee luma nia wane baita ana Farisi gi. Ma ana si kada nae, na tooa gi daka aadaada uria rikilana si taa gi na tara nia ka iilia. ");
INSERT INTO llu_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Haia, ma tee wane na roo abana gi ma na roo aena gi da fungufungu, nia e lea mai sia Jesus. ");
INSERT INTO llu_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ma Jesus ka soeledia na Farisi gi ma na faatolomai gi ana kwaieresia gi ka urii, <<Na kwaieresia gia gi da faalamainia gia ka guraa ta wane matai ana Sabat, ma langi?>> ");
INSERT INTO llu_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Sui gera langi dasi oolisia go ana tesi doo. Sui Jesus ka hamosia wane matai baa, ma nia ka akwaa naa, ma Jesus ka faalamainia ka lea na ana. ");
INSERT INTO llu_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Sui Jesus ka soeledi gera ka urii, <<E utaa? Lea so ta wela amu langi ta bulumakau amu ka asia i laona ta kilu ana maedani Sabat, oe o haitamana go amu oko lea oko lafia go amu i langi, ne baa?>> ");
INSERT INTO llu_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Haia, ana si kada Jesus e ledi urinae, langi ta wane kasi oolisia go ana tesi doo. ");
INSERT INTO llu_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ma si kada a Jesus e rikia na tooa gi na da dao mai ana fangalaa ma daka filia ada si gula initoo ni gwourua gera gi, nia ka haea si baea oomelawane naa fuada ka urii, ");
INSERT INTO llu_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","<<Si kada ta wane e soe oe uria ta fangaa ana baraa, e langi osi gwouru ana si gula diana, aata daka soea laugo ta wane na e baita ka tasa ani oe. ");
INSERT INTO llu_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ma na wane na e soe gomoro mai ka dao, ma ka bae urii fuamu, <O tatae, sulia na wane naa ka gwouru i seegi.> Seenae, oe oko ida asianaa sulia da idu oe oko gwouru ana si gula fuana na tooa siofaa. ");
INSERT INTO llu_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Haia, si kada ta wane e soe oe, oko gwouru amu ana si gula ana faatoꞌoulaa eeri si kada na wane na e soe oe mai e dao, nia ka bae urii fuamu, <Ruana ae, o idu aala mai uria si gula diana naa.> Urinae, i nia ka faabaita oe nae i maada na tooa gi na molu figu i seenae. ");
INSERT INTO llu_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Sulia na wane na e faabaita nia i talana, daka faatoꞌou nia. Ma na wane na e faatoꞌou nia i talana, daka faabaita nia.>> ");
INSERT INTO llu_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Sui a Jesus ka bae urii fuana na wane na e haungainia na fangalaa nae, <<Si kada o haungainia ta fangaa, langi osi soea go amu mai na ruana oe gi ma na aebara oe, ma langi na wane todadoo gi na da too garangi oe. Sulia tara gera haitamana daka haungainia ta fafangaa urinae ma gera soe oe laugo uria duulana laugo si doo na o iilia. ");
INSERT INTO llu_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Si kada o haungainia ta fangaa, oko soea mai na tooa siofaa gi, ma na tooa gi na aeda ma langi na abada e mae, ma na tooa gi na maada e rodo. ");
INSERT INTO llu_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Lea o iili urinae, ka oilakea fuamu. Sui boroi ana langi dasi duu fuamu, tara a God naa ka duua fuamu ana, si kada na tooa oꞌolo gi da tatae lau faasia na maea.>> ");
INSERT INTO llu_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ma ana si kada nae, tee wane ana tooa gi na da gwouru uria fangalaa e rongoa si taa naa Jesus e haea, nia ka bae urii, <<Si oilakea fuana tooa gi na tara daka fanga ana maoma na laona Initooa nia a God.>> ");
INSERT INTO llu_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ma Jesus ka bae urii, <<Ana tesi kada tee wane e haungainia tee maoma baita ma ka soea mai tooa oro uria fangalaa. ");
INSERT INTO llu_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ma ana si kada na doo gi e aade aagau naa, nia ka oodua wane rao nia ka lea uria soelana mai tooa gi na nia e haea fuada gera ka lea mai. Nia bae urii, <Molu lea na mai sulia na doo gi e aade aagau sui naa.> ");
INSERT INTO llu_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Sui gera ka talaꞌae haea doo gi na e suusida na daka langi dasi lea mai. Tee wane e bae urii, <Nau ku folia tesi gano, ma ku doori lea fasi uria rikilana. O faarongo nia, nau ku kwaimanatai asianaa.> ");
INSERT INTO llu_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ma ruana wane ka bae urii, <Nau ku folia aakwala bulumakau ana si kada nae, ma nau ku doori lea kuka rikida fasi, gera da rao diana ma langi. O faarongo nia nau ku kwaimanatai kusi lea go kou.> ");
INSERT INTO llu_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ma ooula wane ka bae urii, <Nau kufi aadegeni go, ma ka afetai asianaa fuagu uria lealaa mai. O faarongo nia nau ku kwaimanatai.> ");
INSERT INTO llu_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Kadamanga na wane raoa naa e ooli mai, ma ka faarongo ana wane baita nia ana si doo nae gi, wane baita naa e rakehasu asianaa, ka bae urii fuana wane ni raoa nia, <O lea aliꞌali sulia tala baita gi ma sulia tala toꞌou gi, oko talaia mai tooa siofaa, ma na tooa da tero, ma na tooa na maada gi e rodo, ma na tooa na aeda e mae.> ");
INSERT INTO llu_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Si kada wane raoa nae e ooli mai, nia ka bae urii fuana wane baita, <Aarai ae, si doo baa gi o haeda fuagu, nau ku iilida sui naa, ma si gula ni gwourua ana fafangaa oe e langi si fungu ua ana tooa.> ");
INSERT INTO llu_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Wane baita na ka bae lau urii, <O lea lau sulia gala tala gi na da too tau, oko soea lau mai teni tooa eeri na luma nau ka fungu. ");
INSERT INTO llu_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Haia, nau ku haea fuamu, e afetai fuana ta wane ana tooa baa ku soeda mai i nao daka ania tesi fanga ana maoma nau naa.>>> ");
INSERT INTO llu_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ana tesi kada, na figua baita da lea fai nia a Jesus. Ma i nia e aabulo fuada, ka bae urii, ");
INSERT INTO llu_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","<<Ta wane na e doori hau ana na fafurongo nau, i nia ka rakediana ani nau liufia na maa nia ma ni tee nia ma na afe nia ma na wela nia gi ma na haasina gi ma na waiwane nia gi ma ni nia i talana laugo. ");
INSERT INTO llu_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ma so ni tei na e langi kasi ngalia na airarafolo nia ma ka langi kasi lea mai i burigu, e afetai nia ka hau ana na wane ni fafurongo nau. ");
INSERT INTO llu_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","<<Lea so ta wane ani gamu e dooria ka tolea ta luma baita, nia ka gwouru ma ka manata fasi sulia tara ta fita si malefo na nia ka too ana eeri ka bobola fai nia na faasuilana na luma nae. ");
INSERT INTO llu_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Lea nia si iili urinae, ma ka aalua naa na faangadoa ana na luma nae sui, ma na tooa gi da rikia i nia langi kasi too ana tesi malefo na e bobola uria na faasuilana, tara gera ka faawaela ani nia ma daka bae urii, ");
INSERT INTO llu_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","<Na wane naa e hafalia na tolelana na luma, sui ka langi si bobola fai nia na faasuilana.> ");
INSERT INTO llu_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","<<Ma lea so ta aaofia na e lea fai nia tee aakwala tooni wane ni oomea nia gi uria na firulaa fai nia ta aaofia aai, na e lea mai fai nia na roo aakwala tooni wane ni oomea nia gi. Nia ka gwouru fasi ma ka manata fasi sulia aata na bali oomea nia ka langi si rigita si bobola go uria na firulaa fai nia na oomea nia na aaofia aai nae. ");
INSERT INTO llu_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ma lea e langi, i nia ka falea ta wane ana eeri ka lea ma ka gani uria na fanualama i matanga daaro, ana si kada da too tau ua mai. ");
INSERT INTO llu_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Urinae laugo, so ta wane ani gamu na e langi kasi eekwatainia na doo nia gi sui, e afetai ka hau ana ta wane ni fafurongo nau.>> ");
INSERT INTO llu_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Jesus ka bae urii lau, <<Na aasi nia na doo diana. Sui taa, lea na mamasialana e lea faasia, e afetai oko ooli lau fai nia. ");
INSERT INTO llu_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Haia, ma langi kasi diana naa fuana aadelana ana tee si doo. Sui boroi ana lea gera dolalia fai nia gano lao raoa, langi so gera ka aalua fai nia tafutafu gi na e haitamana ka fura ma ka aadea gano ka diana. Ma nia bobola go ana fuana daka ui ania na ada. Haia, molu fafurongo diana sulia si baelaa nae gi.>> ");
INSERT INTO llu_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ana tee maedani, na wane oro gi na da wane faafefe ni gonilana na malefo ana na takisi, ma na tooa taꞌa gi laugo da dao uria na fafurongolana a Jesus. ");
INSERT INTO llu_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ma na Farisi gi ma na wane faatolomai ana kwaieresia da hafalia na ngunungunulaa daka urii, <<Na wane naa e gonitainia na tooa taꞌa gi ma ka fanga na ana fai gera!>> ");
INSERT INTO llu_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Nia nae a Jesus ka baea ana si oomelawanea gi fuada ka urii, ");
INSERT INTO llu_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","<<Lea so ta wane ani gamu e too ana tee talange sipsip gi ma tee doo ada ka langi ana, tara si taa naa na wane nae ka iilia? Nia ka tafusia na sikwa aakwala ma sikwa sipsip nae gi ma ka lea ka nani uria tee doo aai na e langi ana lelea ka daotoona go. ");
INSERT INTO llu_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ma si kada nia e daotoona, nia ka eele asianaa ma ka koua i gwouna abana, ");
INSERT INTO llu_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ma ka ngalia mai i fera. Sui i nia ka soea mai na oote ruana nia gi ma na wane aefera nia gi eeri daka figu mai, ma ka bae urii fuada, <Nau ku eele asianaa sulia ku daotoona naa na sipsip nau baa e langi ana. Nia naa molu ka noni hahala fai nau!>>> ");
INSERT INTO llu_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ma a Jesus e bae lau ka urii, <<I nau ku haea fuagamu, na eelea baita ka urinae laugo i langi faafia tee wane na e garo ma ka manata ooli, ka liufia na sikwa aakwala ma sikwa iimola gi na da oꞌolo go ada.>> ");
INSERT INTO llu_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ma Jesus e baea si oomelawanea aai, ka urii, <<Lea so ta geni na e too ana ta aakwala rebe malefo gi ma ta tee fe doo ada ka langi ana, tesi taa tara na ni nia ka iilia? Ni nia ka faaharua ta kwesu, ma ka salofia na luma nia, ma ka nani ana si gula gi sui lelea ka daotoona go. ");
INSERT INTO llu_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ma si kada e daotoona naa, nia ka soea na ruana nia gi ma na iimola aefera nia gi daka figu mai siana ma nia ka bae urii fuada, <Ni nau ku eele asianaa sulia ku daotoona naa na rebe malefo nau baa e langi ana. Nia naa molu ka noni hahala fai nau!>>> ");
INSERT INTO llu_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ma a Jesus e bae lau ka urii, <<I nau ku haea fuagamu, si doo nae ka urinae laugo i langi. Na ensel nia gi a God da eele asianaa faafia tee wane na e taꞌa, sui ka manata ooli.>> ");
INSERT INTO llu_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ma Jesus e baea lau ana tesi oomelawanea ka urii, <<Tee wane e too ana roo wela wane. ");
INSERT INTO llu_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Na wela i buri ka bae urii fuana na maa nia, <Maa ae, o falea mai na bali ai nau ana na aaludooa golu.> Haia, na wane nae ka tolingia naa na aaludooa gera i matangana na roo alakwa nia gi. ");
INSERT INTO llu_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ma i buira aange fe dani sui, na alakwa baa i buri ka faafoli na ana na bali aai nia ana aaludooa gera, ma ka lea na ana fai nia si malefo nia. Ma nia ka lea na ana uria na fera tau, ma ka nagaa teefou na ana na malefo nia gi ana na toolaa taꞌa. ");
INSERT INTO llu_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ma i buira na e faasuia naa na malefo nia, na fioloa baita ka liu ana na bali fera nae, ma nia ka langi si too naa ana tesi doo. ");
INSERT INTO llu_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ma nia ka lea siana tee wane ana fera nae uria raolaa, ma na wane nae ka fale nia uria na raolaa bilia ana aadalaa sulia na boso nia gi. ");
INSERT INTO llu_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ma nia e dooria hasa ka ania mone ana tesi mudui fanga ana na fanga gera na boso gi, sulia ta wane i seenae kasi falea go tesi fanga fuana. ");
INSERT INTO llu_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Sui si kada nia e manata diana, nia ka bae urii fuana i talana, <Na wane ni rao nia gi na maa nau da fanga lelea daka aabusu, ma i nau naa ku fiolo na agu uria na maea naa! ");
INSERT INTO llu_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nia diana nau ku ooli siana maa nau, ma kuka bae urii fuana, Maa ae, nau ku aade taꞌa fuana a God ma fuamu laugo. ");
INSERT INTO llu_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nau kusi faorana naa oko alangi nau ana na wela oe. O faalamai nau kuka rao naa agu fuamu iilingia ta wane ni raoa oe.> ");
INSERT INTO llu_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ma nia e tatae ka ooli siana maa nia. <<Si kada nia e dao tau ua kou faasia i fera, na maa nia e aada kou, ka riki nia. Ma nia ka kwaimanatai asianaa ana na wela nia. Ma nia ka lalao kou ma ka ofia mai na wela nia ma ka nonoia. ");
INSERT INTO llu_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ma na wela nia nae ka bae urii fuana, <Maa ae, i nau ku aade taꞌa fuana a God ma fuamu laugo. Nau kusi faorana naa oko alangi nau lau ana wela oe.> ");
INSERT INTO llu_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Sui na maa nia e soea na wane ni rao nia gi ka urii, <Molu aliꞌali! Molu ngalia mai na maku tekwa na e diana ka tasa ma molu ka faaofi nia ana. Ma molu ka aalua fe ringe ana kakauna abana, ma molu ka aalua na tae silipa gi i aena. ");
INSERT INTO llu_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Lea sui, molu lea, molu ka haumaelia mai na gale bulumakau kobu baa eeri golu ka haungainia si fangaa ma golu ka eele agolu. ");
INSERT INTO llu_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Sulia na wela nau naa e iilingia nia e mae naa, sui nia ka mouri ooli lau. Ma nia ka iilingia nia ka langi ana, sui kuka riki nia lau.> Ma na fangaa nae ka hafali naa. ");
INSERT INTO llu_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","<<Ma ana si kada nae, na wela aai baa i nao e too ua mai ana i laona na raoa. Ma si kada nia e ooli mai ma ka dao garangia na mai na luma, nia ka rongoa na lingeena na lalabalaa ma na waelaa. ");
INSERT INTO llu_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ma nia ka soea tee wane ada na wane ni rao gi ma ka ledia uria na taa loko da hasi fai nia. ");
INSERT INTO llu_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ma na wane ni rao nae e oolisia ka urii, <Na haasimu baa e ooli na mai i fera, ma na maa oe ka haumaelia naa na gale bulumakau kobu baa, sulia na haasimu e mouri diana lau ma ka ooli mai ka dao naa.> ");
INSERT INTO llu_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ma na wela i nao ka rakehasu asianaa, ka langi si ruu na kou i luma. Ma na maa nia ka haga mai i maa, ma ka ingo ani nia kou uria na ruulaa i luma. ");
INSERT INTO llu_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Sui nia e oolisia na maa nia ka bae urii, <O rikia fasi, i nau naa ku rao fuamu iilingia ta wane ni rao oꞌoni oe sulia fe ngali naa gi, ma ku roosulia na baelamu gi. Sui boroi ana, osi falea mone amu ta gale nanigot fuagu hai so kuka haungainia agu tesi fangaa fai nia na ruana nau gi! ");
INSERT INTO llu_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Sui na wela aai oe naa, nia e nagaa na aaludooa oe ana na geni ooeoe gi, ma si kada e ooli mai ka dao i fera, oko haumaelia amu na gale bulumakau kobu baita diana baa fuana!> ");
INSERT INTO llu_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ma na maa nia e oolisia ka urii, <Wela nau ae, ni oe o too ka tau go amu fai nau i seenaa, ma na doo nau gi sui naa, na doo oe gi laugo. ");
INSERT INTO llu_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Sui taa, golu haungainia naa mone agolu ta fangaa ma golu ka eele agolu, sulia na haasimu e iilingia ka mae naa, sui nia ka mouri ooli lau. Ma i nia e langi ana naa, sui si kada naa golu ka riki nia lau.>> ");
INSERT INTO llu_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","A Jesus ka bae lau ana oomelawanea fuada na oote fafurongo nia gi urii, <<Tee wane todadoo e too ana tee wane ni rao na e aalua ka baita usia na doo nia gi. Ma na tooa gi daka haea fuana na wane todadoo nae hasa na wane nia nae e faafefe ma ka nagaa go ana na doo nia gi. ");
INSERT INTO llu_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ma na aarai baita nae ka soe nia mai ma ka ledia ka urii, <Na taa naa na ku rongoa ani oe? O kedea na fita si malefo nau gi sui na o rao ana, sulia ni oe osi baita naa usia na doo nau gi.> ");
INSERT INTO llu_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","<<Ma na wane faafefe nae ka manata i talana urii, <Na wane baita nau e faasui nau naa faasia na raoa nau. Tesi taa naa kuka iilia ana raolaa faalu? Nau kusi rigita naa bobola fai nia na elilana na kilu gi, ma ku ida laugo agu uria na ingolaa. ");
INSERT INTO llu_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Nau ku haitamana si doo na tara kuka iilia eeri si kada ku sui faasia ana raoa nau naa, na iimola gi daka gonitai nau go ada i laona luma gera gi.> ");
INSERT INTO llu_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","<<Ma nia ka soea mai na wane gi na da ngalilanga siana na wane baita nia, ma ka bae urii fuana na eetana wane, <Fita si doo na o ngalilanga ana siana na wane baita nau?> ");
INSERT INTO llu_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Nia e oolisia ka urii, <Tee talange bii doo baita ana oel.> Ma na wane faafefe nae ka bae urii fuana, <Na abe doo ana na ngalilangaa oe naa. O gwouru ma oko kedea go na lima aakwala.> ");
INSERT INTO llu_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ma nia ka bae urii fuana na ruana wane, <Ma ni oe, fita si doo na o ngalilanga ana?> Nia e oolisia ka urii, <Na tee tooni luelue ana mige doo gi uria na beredi.> Ma na wane faafefe nae ka bae urii fuana, <Na abe doo ana na ngalilangaa oe naa, o kedea go na kwalu talange doo.> ");
INSERT INTO llu_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ma na wane baita nia ka baelafe nia uria si liotooa na nia e iilia. Sulia na iimola gi ana molaagali naa da liotoo ka tasa ana na dongana na molaagali naa ka liufia na iimola gi ana na raralaa. ");
INSERT INTO llu_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","<<I nau ku haea fuagamu, muka falea na rikidooa gamu uria kwaiꞌadomilana wane eꞌete, ma tara a God e gonitai gamu i langi na gula e totoo firi. ");
INSERT INTO llu_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","<<So ni tei na e rao diana ana si doo toꞌou gi, nia ka rao diana laugo ana si doo baita gi. Ma so ni tei na e rao taꞌa ana si doo toꞌou gi, nia ka rao taꞌa laugo ana si doo baita gi. ");
INSERT INTO llu_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Nia naa, lea langi musi rao diana ana na todadoo gi lao molaagali, a God ka langi si manata ngado laugo ani gamu fai nia na todadoo mamana. ");
INSERT INTO llu_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ma lea musi rao diana ana si doo nia ta wane eꞌete, a God ka langi si falea laugo si doo fuagamu i langi. ");
INSERT INTO llu_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","<<Langi ta wane ni rao na ka rao fuana roo wane baita eꞌete gi. Lea urinae, tara nia ka ngidu auꞌau fuana ta wane baita ma ka rakediana ana fuana ta wane baita aai. Ma langi nia ka rao diana ana fuana ta wane ma ka eekwatainia ana ta wane aai. Nia naa, e afetai so muka rao fuana a God ma na malefo ana tee si kada.>> ");
INSERT INTO llu_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Si kada Farisi gi da rongoa si doo naa, gera ka aaefara ana Jesus, sulia gera tooa da dooria asianaa na malefo. ");
INSERT INTO llu_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jesus ka bae urii fuagera, <<Gamu boroi mu iilia doo diana i nao na tooa gi, eeri gera ka baelafe gamu. Sui taa, a God e haitamana go ana mango gamu gi. Sulia si taa na na wane e manata baita ana, God e langi kasi manata baita go ana.>> ");
INSERT INTO llu_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Jesus ka bae lau urii, <<Na kwaieresia Moses gi ma na kekedelaa gera profet gi e rao mai lea ka dao ana si kada John Siuabu e dao ana. Haia, ma talaꞌae mai ana John, na talongailana Faarongolaa Diana sulia Initooa a God. Ma na tooa oro daka hasi uria ruulana mai. ");
INSERT INTO llu_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Sui taa, kwaieresia e afetai ka funu. Lea so i langi fai nia na molaagali da funu, nia waluda liufia tesi baea toꞌou i laona na kwaieresia ka funu. ");
INSERT INTO llu_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","<<So ta wane ka lugasia afe nia ma ka aadea lau ta aai faalu, nia e ooe naa. Ma lea ta wane ka aadea na aai na da lugasia, nia ka ooe naa laugo.>> ");
INSERT INTO llu_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","A Jesus ka baea tesi oomelawanea ma ka urii, <<Tee wane rikidoo na e oofi ana na maku diana gi na liulada e baita, ma ka too ana na dianaa sulia dani. ");
INSERT INTO llu_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ma tee wane siofaa na maala gi e haru susufu ana nonina, na hatana a Lasaros, e gwouru go ana i aena na maa ana luma nia na wane initoo nae. ");
INSERT INTO llu_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ma Lasaros e dooria hai so ka ania mone ana na oorongana na fanga na e asia faasia na tafe ni fanga na wane initoo nae. Ma si kada a Lasaros e gwouru i aano, na kui gi boroi da dao mai, daka meelia na maala nia gi. ");
INSERT INTO llu_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Haia, na wane siofaa nae ka mae, ma na ensel gi daka ngali nia siana a Abraham uria na fangaa baita i langi. Sui na wane initoo ka mae laugo, ma daka aalua naa. ");
INSERT INTO llu_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","I nia ka too ana na fiilaa baita ana si gula ana nonifiilaa too firi. Ma nia ka aada alaa kou ma ka rikia tau kou a Abraham ma a Lasaros ka too ana siana. ");
INSERT INTO llu_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ma nia ka rii kou fuana a Abraham ma ka urii, <Koo nau a Abraham ae, o manatai nau mai. O falea mai a Lasaros, eeri ka kanoa mone mai ana na kakauna abana ana tesi kafo ma ka faagwaria mone ana na meagu, sulia i nau ku too na ana na fiilaa i laona na eere naa.> ");
INSERT INTO llu_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Sui a Abraham ka bae urii fuana, <Wela nau ae, o manatatoona fasi amu si kada baa o mouri mai ana, i oe o too ana na doo diana oro gi, ma a Lasaros ka too go ana ana na doo taꞌa gi. Sui ana si kada nae, ni nia ka too na ana na eelea i seenaa, si kada oko too amu ana na nonifiilaa. ");
INSERT INTO llu_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ma tee dari baita e too i matanga golu, ma ka langi si bobola fai nia ta wane ka tasa kou uria i bali aai naa faasia i seenaa. Ma ka langi si bobola laugo fuana wane ka folo mai siamelu.> ");
INSERT INTO llu_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","<<Ma nia e oolisia ka urii, <Koo ae, nau ku ingo ani oe kou hai so oko oodua a Lasaros uria luma nia na maa nau, ");
INSERT INTO llu_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","eeri ka bae fifii fuada na lima haasigu gi, aata daka lea laugo mai ana si gula ni nonifiilaa.> ");
INSERT INTO llu_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Sui a Abraham e oolisia ka urii, <Na kekedelaa gi a Moses ma na profet gi e too sui go ana. Nia bobola fuana daka fafurongoa.> ");
INSERT INTO llu_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ma nia ka bae urii, <Koo nau a Abraham ae, e langi. Lea so ta wane na e mouri ooli lau ma ka lea i siada taari, gera daka manata ooli faasia na aabulolaa taꞌa gera gi.> ");
INSERT INTO llu_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ma a Abraham ka bae urii fuana, <Lea e langi dasi fafurongo na kekedelaa a Moses ma na profet gi, e afetai go daka manata mamana boroi ana so ta wane ka tatae lau faasia na maea.>>> ");
INSERT INTO llu_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","A Jesus e bae urii fuana oote fafurongo nia gi, <<Si doo gi na e aadea na wane gi gera ka iili doo taꞌa, tara gera ka dao mai, ma tara ka taꞌa asianaa fuana wane na e aadea gera ka fuli! ");
INSERT INTO llu_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Nia e diana fuana go na lea so daka ngalia ta fou baita daka kania i luana, sui daka ngalia daka ui ani nia lao aasi, aata lea ka faataꞌafia ta wela ana wela toꞌou naa gi lao aade taꞌalaa. ");
INSERT INTO llu_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Haia, ma ni gamu muka aadasuli gamu! <<Lea so na haasimu e aadea doo taꞌa gi, o ngatafia. Lea nia oolitai manata, o manata luke nia. ");
INSERT INTO llu_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ma lea na aabulolana e taꞌa fuamu ana fiu si kada ana tee fe dani, sui nia ka lea laugo mai siamu ana fiu si kada ma ka haea, <Nau ku oolitai manata naa,> oko manata luke nia naa.>> ");
INSERT INTO llu_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Na fafurongo nia gi da bae urii fuana a Jesus na Lord, <<O faarigitaa na manata mamanalaa gami.>> ");
INSERT INTO llu_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ma a Jesus e oolisida ka urii, <<Lea so muka too ana manata mamanalaa toꞌou boroi ana iilingia ta mige doo na e toꞌou asianaa, muka haitamana go agamu uria na baelaa fuana ta ai, <Oko lafu fe lalimu ma oko tae kou i laona na aasi.> Ma nia tara ka roosulia go ana na baelamu. ");
INSERT INTO llu_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","<<Lea so ta wane ani gamu ka too ana ta wane ni rao na e elia na hae gano ma langi ka aadasulia na sipsip gi, ma si kada nia e ooli mai faasia i hara, e utaa? Tara oko haea go amu fuana eeri ka lea aliꞌali mai ma ka fanga fasi? ");
INSERT INTO llu_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Langi! Tara oko bae urii fuana, <O kukia mai na fanga nau, sui oko oofi faalu mai, oko rao fuagu, lea ku fanga ma ku gwou sui. I buri, ofi fanga ma ofi gwou amu.> ");
INSERT INTO llu_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Haia, ma ni oe o tangoa na wane ni rao nae sulia nia e iilia si doo naa gi o oodua uria? Langi! ");
INSERT INTO llu_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ka urinae laugo fuagamu. Si kada gamu iilia sui naa si doo gi sui na a God e oodu gamu uria, muka bae urii, <I gami na wane oꞌoni ni raolaa gi go ana, gami mi iilia go agami na raoa gami gi.>>> ");
INSERT INTO llu_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","A Jesus e lea uria i Jerusalem, ma ka liu matangana i Samaria ma i Galili. ");
INSERT INTO llu_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ma si kada nia e dao ana tee maefera toꞌou, nia ka daotoona tee aakwala wane na fura e haungida. I gera da take tau mai, ");
INSERT INTO llu_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ma daka rii baita mai daka urii, <<Jesus na Aarai baita ae, o manatai gami mai!>> ");
INSERT INTO llu_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ma si kada a Jesus e rikida, nia ka bae urii, <<Gamu lea, muka faatai nonigamu gi i siada na fataabu gi, eeri daka haitamana hasa na nonigamu gi da mafo naa.>> Ma si kada da lea ana, na nonida ka mafo naa teefou. ");
INSERT INTO llu_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Si kada tee wane ada e rikia na nonina e mafo naa, nia ka ooli mai ma ka rii baita ma ka baelafea a God. ");
INSERT INTO llu_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ma nia ka boururu i maana na aena a Jesus ma ka tangoa. Nia na wane maadiu faasia i Samaria. ");
INSERT INTO llu_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ma a Jesus e bae urii, <<E utaa? Na aakwala wane baa na nonida e mafo baa. Ma ta sikwa wane aai da nia ada i fai? ");
INSERT INTO llu_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Utaa? Langi lau ta wane na ka ooli mai uria na baelafelana a God, ma tee taifilia go na wane maadiu naa?>> ");
INSERT INTO llu_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ma a Jesus ka bae urii fuana, <<O tatae, oko lea na amu. A God e guraa oe sulia ni oe o manata mamana ani nau.>> ");
INSERT INTO llu_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Teni wane ana Farisi gi da soeledia Jesus daka urii, <<Si kada taa na tara Initooa nia a God ka dao mai?>> Ma a Jesus e oolisida ka urii, <<Na Initooa a God langi kasi dao mai eeri so tooa daka rikia. ");
INSERT INTO llu_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ma e langi ta wane so ka bae urii, <Aada fasi, nia naa!> Ma langi urii, <Nia loko!> Sulia na Initooa a God e too i laona liona tooa gi.>> ");
INSERT INTO llu_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Sui a Jesus ka bae urii fuana oote fafurongo nia gi, <<Si kada tara ka dao mai, si kada tara muka dooria rikilana tee fe dani ana dani nau, na Wela nia Iimola gi. Sui langi musi rikia. ");
INSERT INTO llu_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ma teni wane gi tara daka bae urii fuagamu, <Aada fasi, nia loko!> Ma langi urii, <Aada fasi, nia naa!> Haia, langi molu si lea fuana aadalaa uria. ");
INSERT INTO llu_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Sulia na oolilaa nau mai tara ka iilingia na sinamaaru na e sina folosia na mamangaa ma na raralana ka talafia sui lao mamangaa loulou. ");
INSERT INTO llu_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ma suifetei na oolilaa nau mai, tara kuka nonifii ma na tooa gi tara gera ka oote gera ani nau. ");
INSERT INTO llu_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Si kada tara kuka ooli mai ana e iilingia laugo ana si kada a Noa. ");
INSERT INTO llu_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Si kada a Noa, na tooa gi da fafanga ma daka gwou, ma wane gi ma na geni gi gera da aade gera gi. Sui daka tona ana fe dani a Noa e tae ana lao faka ma na iigwa e iigwa mai, ma ka haumaelida teefou. ");
INSERT INTO llu_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Haia, si kada tara kuka ooli mai ana, e uusulia laugo na maedani baa a Lot, sulia tooa gi da fafanga, ma gera gwou, gera ka faafoli, gera uusiusia, gera fafasi, ma gera ka totole beu. ");
INSERT INTO llu_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Sui daka tona ana fe dani a Lot e lea faasia i Sodom, ma na eere ka sifo na mai faasia i langi ka haru maelida teefou. ");
INSERT INTO llu_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Tara ka urinae laugo ana fe dani kuka ooli mai ana. ");
INSERT INTO llu_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","<<Ma ana fe dani nae, na wane na e too mai i maa ana luma nia, langi kasi ruu lau mai i laona uria ngalilana doo nia gi. Ka urinae laugo fuana wane na e ni mai hara, langi kasi ooli lau mai i luma. ");
INSERT INTO llu_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Gamu ka manatatoona afe a Lot. ");
INSERT INTO llu_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","So ni tei na e dooria ka dau faafia na mourilana fuana i talana, tara nia ka mae. Ma so ni tei na ka lugasia na mourilana, tara nia ka mouri mamana naa. ");
INSERT INTO llu_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nau ku haea fuagamu, ana fe rodo nae tara roo wane na da teo laona tee iifitai, ta wane tara kuka ngalia, ma ta wane tara ka too. ");
INSERT INTO llu_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Roo geni gi daaro rao oofu, ta geni kuka ngalia, ma ta geni ka too.>> ");
INSERT INTO llu_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Sui na oote fafurongo nia gi gera ledia daka urii, <<Lord ae, fai nae?>> Ma a Jesus e oolisida ka urii, <<So i fai na rae e too ana, na manu gi laugo gera ka oogu seenae.>> ");
INSERT INTO llu_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","A Jesus e faarongoa na oote fafurongo nia gi ana si baea oomelawane naa, eeri ka faatainia fuada gera ka fooa sulia dani ma langi dasi fiitala. ");
INSERT INTO llu_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Nia ka bae urii, <<Tee wane ni keketolaa e too ana tee fera, ma e langi kasi moungia a God ma e langi kasi haebaita go ana ta wane. ");
INSERT INTO llu_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ma tee geni oru i laona na fera nae e lea mai sulia dani siana uria ingolaa ma ka bae urii, <I nau ku dooria oko keketo ana oꞌoloa fuagu uria na maalimaea nau.> ");
INSERT INTO llu_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ma sulia si kada e tau, na wane ni keketolaa nae kasi aala go faafia. Sui i buri nia ka bae urii fuana i talana, <Sui boroi ana nau kusi moungia go a God ma langi kusi haebaita go ana ta wane, ");
INSERT INTO llu_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","tara nau ku keketo oꞌolo na agu fuana na aai oru na e faaꞌabero nau ka lea ngado go mai ana, aata ni nia ka faaulafu nau ana na oolilagulaa mai!>>> ");
INSERT INTO llu_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ma a Jesus na Lord ka bae urii, <<Muka rongoa fasi si doo na wane ni keketo taꞌa nae e haea. ");
INSERT INTO llu_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Utaa? A God kasi falea go na oꞌolo fuana na iimola aadafilia nia gi na da aangi fuana ana fe hato ma fe rodo? Utaa? Nia kasi adomi aliꞌali go ani gera? ");
INSERT INTO llu_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nau ku haea fuagamu, i nia ka fale aliꞌali ana na oꞌoloa fuada. Ma si kada nau na Wela nia Iimola gi ku ooli mai ana lao molaagali, tara kuka daotoona agu aange tooa gi na da manata mamana.>> ");
INSERT INTO llu_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","A Jesus e haea na oomelawane naa fuada teni tooa gi na da manata ngado ani gera i talada hasa da oꞌolo ma daka sinitainia teni tooa aai gi, ka urii, ");
INSERT INTO llu_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","<<Tee roo wane da lea i laona na Beu Aabu a God uria na fooalaa. Tee wane na Farisi, ma ta wane aai na wane faafefe na e goni na malefo ana takisi. ");
INSERT INTO llu_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Na Farisi nae e take taifilia nia, ma ka fooa urii, <God ae, i nau ku tango oe sulia e langi kusi iilingia na wane aai eꞌete gi sui. Sulia gera da beli ma da iilia na doo taꞌa gi ma daka ooe. Nau langi kusi iilingia na wane taꞌa loko na e gonia na malefo ana takisi. ");
INSERT INTO llu_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nau ku aabu fanga ana roo si kada laona tee fe wiki, ma ku falea na tangafulu ana na doo nau gi na ku toda fuamu.> ");
INSERT INTO llu_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","<<Sui na wane na e gonia na malefo ana na takisi, nia e take tau mai ana. Ma nia kasi aada kou uria i langi, sulia ni nia e ida laugo ana. Ma nia ka faatainia na rakebukonulaa ka gumulia na ruruuna, ma ka bae urii, <God ae, oko manatai nau mai, i nau na wane fualangaa!>>> ");
INSERT INTO llu_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ma a Jesus e bae laugo urii, <<Nau ku haea fuagamu, na wane aai na e rakebukonu naa, a God e faaꞌoꞌolo ana si kada nia e ruu kou i maa. Haia, ma na Farisi ka langi. Sulia na tooa gi na da faabaita gera i talada, a God tara ka faatoꞌou gera. Ma na tooa gi na da faatoꞌou gera i talada, a God tara ka faabaita gera.>> ");
INSERT INTO llu_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ma teni tooa gi gera ngalia mai gala wela gera gi siana Jesus, eeri ka aalua abana fafona gwouda ma ka faadiana gera. Ma si kada oote fafurongo nia gi da rikia, gera ka ngatafida. ");
INSERT INTO llu_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Sui Jesus ka soea mai gala wela nae gi siana, ma ka bae fuana oote fafurongo nia gi ka urii, <<Muka faalamainia na gala wela gi daka lea mai ada siagu, langi musi luida, sulia ni tei naa e manata mamana ka iilingia gala wela, nia ka bobola uria toolaa lao Initooa nia a God. Nia naa, langi musi luida faasia lealaa mai siagu. ");
INSERT INTO llu_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Doo mamana nau ku haea fuagamu, so ni tei na e langi kasi manata mamana iilingia na gala wela, nia langi kasi bobola uria toolaa laona Initooa nia a God.>> ");
INSERT INTO llu_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Tee wane baita gera Jiu e ledia a Jesus ka bae urii, <<Faatolomai diana ae, si doo taa na kuka aadea eeri kuka too ana mouria na langi kasi sui?>> ");
INSERT INTO llu_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesus e oolisia ka bae urii, <<Utaa na oko haea nau ku diana? E langi ta wane kasi diana, ma ta taifilia a God go. ");
INSERT INTO llu_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Oe o haitamana kwaieresia God nia urii, <Langi osi ooe, osi hauwane, osi beli, osi suge faafia ta wane, ma oko manata baita ana maa oe ma ni tee oe.>>> ");
INSERT INTO llu_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Wane nae e oolisia ka bae urii, <<Ana toꞌoulagu mai lea ka dao i taraꞌena, nau ku aade mai sulia kwaieresia nae gi sui.>> ");
INSERT INTO llu_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ma si kada Jesus nia rongoa si doo nae, nia ka bae urii fuana, <<Tesi doo lau ua fuamu oko aadea. Lea kou, oko faafoli ana doo oe gi sui, ngalia si malefo nae gi, oko falea fuana tooa na da siofaa, eeri oko too ana rikidooa i langi. Sui oko lea mai suli nau.>> ");
INSERT INTO llu_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ma si kada wane nae e rongoa si doo nae, na liona ka dila asianaa, sulia nia na wane rikidoo. ");
INSERT INTO llu_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ma si kada Jesus nia rikia wane nae na liona e dila, nia ka bae urii, <<Nia tara ka afetai asianaa fuana tooa na da rikidoo gera ka ruu i laona Initooa a God. ");
INSERT INTO llu_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ma e afetai ka tasa asianaa fuana ta wane na e rikidoo so ka ruu laona Initooa a God faasia na doo fai ae baita so ka ruu i laona mae kwakwada ana ogilaa.>> ");
INSERT INTO llu_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Haia, si kada tooa na da rongo si baelaa nae gi, gera ka ledia daka bae urii, <<Lea nia afetai urinae, ni tei mone ana na tara ka ngalia na mouria firi?>> ");
INSERT INTO llu_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ma Jesus ka oolisia ka urii, <<Si doo nae nia ka afetai fuana wane, sui taa fuana God nia langi kasi afetai.>> ");
INSERT INTO llu_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ma a Peter ka bae urii fuana Jesus, <<Ma ni gemelu mone? Sulia gemelu melu lugasia teefou na ana afutana si doo gemelu gi ma melu ka lea na mai suli oe.>> ");
INSERT INTO llu_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesus ka bae urii, <<Iiuka. Ma ni nau ku haea fuagamu, so ni tei na e lugasia luma nia, afe nia, bare haasina gi, maa nia ma ni tee nia, ma na wela nia gi i nunufana Initooa nia a God, ");
INSERT INTO llu_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","tara nia ka toda si doo oro laona molaagali na liufia si doo baa gi nia lugasida. Haia, ana mouria faalu na e lea mai, tara wane nae ka ngalia na mouria firi.>> ");
INSERT INTO llu_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ma si kada Jesus nia lea fai nia oote fafurongo nia gi taifili gera, nia ka bae urii fuada, <<Golu lea agolu kou i Jerusalem eeri gera ka faafonoa si doo baa gi na profet gi da kedea suli nau na Wela nia Iimola gi ana. ");
INSERT INTO llu_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Tara gera ka fale nau laona abana tooa da maadiu gi eeri gera daka onionga ani nau, ma daka kwalangi nau, ma daka ngisufi nau. ");
INSERT INTO llu_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Gera ka rabusi nau, ma gera ka haumaeli nau. Sui ana ooulana fe dani, tara nau kuka mouri lau.>> ");
INSERT INTO llu_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Sui na oote fafurongo gi langi gera kasi haitamana go baelaa nae gi a Jesus e haeda, sulia God e haufinia na malutana faasida. Nia naa e aadea gera dasi haitamana taa na Jesus nia bae sulia gi. ");
INSERT INTO llu_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Si kada Jesus e dao garangia maefera i Jeriko, tee wane maa rodo e gwouru i ninimana tala. Ma sulia dani nia soe malefo siana tooa. ");
INSERT INTO llu_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ma si kada nia rongoa wane oro gi da liu siana, nia ka soeledi gera ka bae urii, <<Taa nae?>> ");
INSERT INTO llu_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ma gera oolisia daka bae urii, <<A Jesus na wane baa faasia i Nasaret na e lea mai.>> ");
INSERT INTO llu_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ma wane maa rodo nae nia ka rii ma ka bae urii, <<Jesus ae, oe na Aaofia ana kwalafaa a David, o manatai nau!>> ");
INSERT INTO llu_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ma tooa na da eeta i nao daka ngatafia, ma gera daka haea nia ka too aaroaro. Sui nia kafi rii baita tasa ma ka bae urii, <<Oe Aaofia ana kwalafaa David, o manatai nau.>> ");
INSERT INTO llu_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Sui Jesus e take ma ka haea fuagera hai daka talai nia mai siana. Si kada nia dao garangia, Jesus ka ledia, ");
INSERT INTO llu_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","<<Taa naa o dooria kuka aadea fuamu?>> Haia, wane maa rodo baa ka bae urii, <<Aarai ae, nau ku doori hai so kuka aada lau agu.>> ");
INSERT INTO llu_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesus ka bae urii fuana, <<Oko aada naa. God e guraa oe sulia o manata mamana ani nau.>> ");
INSERT INTO llu_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ma aliꞌali nia ka aada naa, ma ka lea fai nia a Jesus, ma ka tangoa a God. Ma si kada tooa gi da rikia, gera ka baelafea God. ");
INSERT INTO llu_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","A Jesus e dao i Jeriko ma ka tasa kou. ");
INSERT INTO llu_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ma tee wane baita gera na wane faafefe gi na da gonia na malefo ana takisi, na hatana a Sakias, wane todadoo baita. ");
INSERT INTO llu_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ma nia ka hasi uria na rikilana a Jesus. Sui ka afetai, sulia nia e kukuru asianaa ma ka langi si rikia a Jesus sulia na figua e bokosi nia. ");
INSERT INTO llu_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Haia, nia ka lalao kou i nao ana figua nae, ma ka raa i gwouna tee ai eeri ka rikia a Jesus na e lea mai sulia na tala. ");
INSERT INTO llu_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Si kada a Jesus e dao ana si gula nae, nia ka aada alaa kou ma ka rikia a Sakias, ma ka bae kou fuana ka urii, <<Sakias ae, o sifo aliꞌali mai, sulia nau tara kuka too i luma oe i taraꞌena.>> ");
INSERT INTO llu_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","A Sakias ka eele asianaa ma ka sifo aliꞌali mai ma ka gonitainia naa a Jesus laona luma nia. ");
INSERT INTO llu_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Na tooa gi sui da rikia si doo naa, ma daka ngunungunu daka urii, <<A Jesus e lea naa uria na toolaa fai nia na wane taꞌa.>> ");
INSERT INTO llu_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Sui a Sakias e tatae, ma ka bae urii fuana a Jesus na Lord, <<Aarai baita ae, tara nau ku falea bali ana na todadoo nau fuana na tooa siofaa gi. Ma lea so ku ngali tasa mai ta wane ana tesi doo, nau tara kuka duu fuana ana fai si doo.>> ");
INSERT INTO llu_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ma a Jesus ka bae urii fuana, <<I taraꞌena a God e faamouria na wane nae, sulia na wane naa e manata mamana ana God iilingia manata mamanalaa na koo gia a Abraham. ");
INSERT INTO llu_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","I nau na Wela nia Iimola gi ku lea mai uria nanisilana na tooa gi na da lea garo eeri kuka faamouri gera.>> ");
INSERT INTO llu_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Si kada tooa gi gera fafurongoa ua go ada baelana Jesus, nia ka tasa dongaa ana baelana, ma ka bae lau ana si oomelawanea. Ma Jesus e dao garangia naa i Jerusalem, ma na tooa gi manatada baa hasa si kada tara God ka hau ana Aaofia, nia garangi naa. ");
INSERT INTO llu_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Nia na aadea Jesus ka bae urii fuada, <<Tee wane ana aebara initoo, nia aade aagau uria lealaa siana tee aaofia baita e too tau mai, eeri ka gania uria na baitaa ma na initooa haia ana si kada nia ka ooli mai ana nia kafi aaofia fuana fera nia. ");
INSERT INTO llu_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ma suifetei nia kafi lea, nia ka soea mai aakwala wane ni raoa nia gi siana, ka falea si malefo baita fuada, ka bae urii, <Muka rao ana si malefo nae, eeri muka ngalia lau si malefo gi maana maasi nau.> ");
INSERT INTO llu_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ma na tooa nia gi na wane initoo naa, gera sinatai nia, ma daka falea teni wane hai gera ka bae fai nia aaofia baita sulia langi dasi dooria go fuana wane naa ka aaofia fuagera. ");
INSERT INTO llu_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","<<Sui ka urinae boroi ana, na aaofia baita naa e aalua wane nae ka aaofia na ana fuada, ma ana si kada nia ooli mai, nia ka soe uria wane ni raoa baa gi e fale malefo fuada, eeri ka daotoona fita si malefo lau na gera toda maana si malefo baa e falea fuagera. ");
INSERT INTO llu_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Haia, na wane rao totongenao e lea mai, ka bae urii, <Aarai ae, nau ku todaa aakwala si malefo lau fonea si malefo baa o falea fuagu.> ");
INSERT INTO llu_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ma wane initoo nae ka bae urii fuana, <Oe wane rao diana. Sulia ku haitamana kuka manata ngado amu ana si doo toꞌou gi, haia urinae nau ku aalu oe oko baita usia aakwala maefera.> ");
INSERT INTO llu_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Sui ruana wane ni rao e lea mai ka bae urii, <Aarai ae, nau ku todaa lau lima si malefo lau fonea si malefo baa o faleda fuagu.> ");
INSERT INTO llu_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ma wane initoo ka bae urii fuana <Oe tara oko baita usia lima maefera.> ");
INSERT INTO llu_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Buira, ooluna wane ni rao ka lea lau mai, ka bae urii, <Aarai ae, si malefo oe baa gi na ku ngalia, kuka afu agu faafia ana maku. ");
INSERT INTO llu_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Sulia nau ku mou ani oe wane susuala. Oko haitamana ngalilana si doo wane ete gi, ma oko haitamana ngalilana laugo fanga faasia raoa gera wane aai gi.> ");
INSERT INTO llu_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Sui wane initoo na ka bae urii fuana, <Oe wane rao taꞌa. Nau ku keto oe ana si baelaa oe gi. Oe haea hasa nau wane ku susuala, ma kuka ngalia si doo langi lau na doo nau gi, ma kuka ngalia si fanga faasia raoa teni wane gi. ");
INSERT INTO llu_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Lea oe manata urinae, utaa na langi osi ngalia si malefo nau, ma oko aalua amu laona si gula ni aalu malefolaa, eeri si kada ku ooli mai ana, kuka ngalia tesi malefo toꞌou i maana?> ");
INSERT INTO llu_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Sui wane initoo nia ka bae urii fuana tooa na da take seenae, <Molu ngalia si malefo naa faasia, molu ka falea fuana wane na e too ana aakwala si malefo.> ");
INSERT INTO llu_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Gera ka bae urii, <Nia e too na ana aakwala si malefo.> ");
INSERT INTO llu_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ma wane initoo e oolisia ka urii, <Nau ku haea fuagamu so ni tei na e iili diana ana si doo na gera da falea fuana, gera haitamana daka falea lau teni si doo fuana lau. Ma so ni tei naa langi si iili diana ana si taa naa gera falea fuana, sui boroi ana si ta toꞌou na nia too ana, haitamana gera ka lafua faasia. ");
INSERT INTO llu_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Haia, ma fuana maalimaea nau gi baa da oote gera ani nau kuka aaofia fuada, talaida mai, muka haungida siagu see.>>> ");
INSERT INTO llu_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Buira a Jesus e bae urinae sui, nia ka eeta naa i nao fui i Jerusalem. ");
INSERT INTO llu_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ma si kada nia dao garangia fera i Betfeis ma i Betani siana gwe uuo da alangia ana Olivtri, nia ka oodua roo fafurongo nia gi i nao, ka bae urii, ");
INSERT INTO llu_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","<<Moro lea fuana maefera na golu rikia kou loko, tara moro ka rikia tee gale dongki na ta wane kasi tae ua i fafona, gera kania i seenae. Moro lukea, moro ka talaia mai siagu. ");
INSERT INTO llu_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Lea ta wane ka ledi gomoro, <Uria taa na moro ka lukea dongki naa?> Moro ka bae urii fuana, <Aarai baita gemere e dooria.>>> ");
INSERT INTO llu_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Haia, roo wane naa daaro lea, daaro ka daotoona iilingia Jesus e haea naa. ");
INSERT INTO llu_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Si kada daaro lukea ana na dongki naa, na wane gi ana dongki daka bae urii, <<Uria taa na moro ka lukea?>> ");
INSERT INTO llu_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Daaro ka bae urii, <<Sulia Aarai gemere e dooria.>> ");
INSERT INTO llu_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ma daaro ka talaia na mai siana Jesus, ma daaro ka aalua teni maku daaro gi i fafona ogina na dongki nae, ma gera ka adomia Jesus eeri ka gwouru i fafona. ");
INSERT INTO llu_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ma si kada Jesus e lea kou ana sulia tala, tooa gi daka regweta teni maku gera gi lau sulia tala eeri ka fali i fafona. ");
INSERT INTO llu_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ma ana si kada nia dao garangia i Jerusalem ana si gula na tala e sifo toli ana fe uuo i Olivtri, na tooa oro ana fafurongo nia gi da nia i seenae, ma gera ka talaꞌae baelafea God ana si riilaa baita, faafia si doo baita gi gera rikia. ");
INSERT INTO llu_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ma gera ka bae urii, <<God ka faadiana na aaofia na e lea mai ana hatana a Lord. Ma si fanualama ka too i langi. Gia ka baelafea a God!>> ");
INSERT INTO llu_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ma teni Farisi gera ni laugo i seenae, ma gera ka bae urii fuana Jesus, <<Faatolomai ae, o haea fuana oote fafurongo oe naa gi, gera ka too aaroaro.>> ");
INSERT INTO llu_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ma a Jesus ka oolisida urii, <<Nau ku haea fuagamu, lea gera too aaroaro, na fou nae gi tara gera ka tasa dongaa fuana baelafelana a God.>> ");
INSERT INTO llu_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ma ana si kada Jesus e dao garangia Jerusalem, nia ka aada kou, ma ka rikia na maefera nae, ma ka aangi sulia na liona e bukonu fuana tooa na gera nia i seenae. ");
INSERT INTO llu_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ma ka bae urii, <<Nia diana lea so molu ka haitamana i taraꞌena na malutana e talaia wane uria fanualama. Sui taa, i taraꞌena na gamu ka lalafusia. ");
INSERT INTO llu_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Si kada tara ka dao mai, hai na maalimaea gamu gi gera ka lea mai gera ka firu fai gamu, ma gera ka boko usi gamu, muka lalafusia na tafilaa. ");
INSERT INTO llu_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ma gera ka tagalangainia fera gamu gi ma na tooa gi sui laona. Ma tesi fou boro kasi too ana si gula na gera too ana. Daka labasia fera gamu, sulia langi musi haitamana si kada fuana God ka lea mai ana uria faamourilaa gamu.>> ");
INSERT INTO llu_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Si kada Jesus e ruu kou laona labata ana Beu Aabu a God, nia ka taria na tooa da faafoli. ");
INSERT INTO llu_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ma nia ka bae urii fuagera, <<Ana na kedea ua na mai laona Kekedelaa Aabu, God e bae urii, <Na Beu nau, da alangia ana na beu ni fooa.> Sui gamu mu aadea ka iilingia na ana ta beu ni aagwalaa gera tooa bebeli.>> ");
INSERT INTO llu_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ma ana fe dani gi sui, Jesus e faatolomai i laona Beu Aabu nia a God. Ma gera na fataabu baita gi ma wane faatolomai gi ana kwaieresia gi ma teni wane baita ana Jiu gi, gera hasi uria haungilana Jesus. ");
INSERT INTO llu_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Sui gera ka lafusia iililanalaa, sulia tooa gi gera too fai nia sulia dani, uria rongolana faatolomaia nia. ");
INSERT INTO llu_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ana tee fe maedani, Jesus e faatolomai fuana tooa gi i laona Beu Aabu a God. Ma nia ka faatalo laugo sulia si Faarongolaa Diana. Ma ana si kadamanga nae, na fataabu baita gi ma wane faatolomai gi ana kwaieresia gi fai teni wane baita gi laugo, gera lea mai siana Jesus. ");
INSERT INTO llu_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ma gera ka soeledi nia urii, <<Na mamanaa utaa naa o too ana oko iilia ana doo naa gi naa? Ma ni tei naa e falea mamanaa nae fuamu?>> ");
INSERT INTO llu_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Seenae, Jesus ka bae urii fuada, <<Nau boroi, ku dooria ku soetoomolu fasi laugo ana tesi soetoolaa. ");
INSERT INTO llu_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Utaa? Ni tei naa falea mamanaa fuana John ka siuabu ana tooa gi--God, langi na wane go ana?>> ");
INSERT INTO llu_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Seenae, gera ka bae naa sulia i matangada kwailiu gera daka urii, <<Lea so golu ka bae urii, <A God naa, nia falea mamanaa nae fuana,> seenae tara Jesus ka bae urii, <Lea urinae, utaa naa molu si manata mamana ana John?> ");
INSERT INTO llu_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ma langi lea so golu ka bae urii, <Na wane gi go ana na da falea na mamanaa fuana,> tara na tooa gi daka ui fou ani golu naa eeri daka haumaeli golu, sulia ni gera da manata mamana ana John nia ta profet laugo.>> ");
INSERT INTO llu_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","I seenae, gera ka oolisia Jesus daka urii, <<Gemelu langi melu si haitamana naa.>> ");
INSERT INTO llu_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Seenae Jesus ka bae urii lau fuagera, <<Haia, nau boroi tara kusi faarongo gomolu ana mamanaa utaa na nau ku too ana na kuka iilia ana doo nae gi naa.>> ");
INSERT INTO llu_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","I buira, Jesus ka faarongo gera lau ana si oomelawanea naa, ka urii, <<Tesi manga, tee wane initoo nia fasia tee raoa ai, ma nia ka faalamainia teni wane gi daka rao fasi ada lao raoa ai nia nae. Ma ni nia ka lea ana tee fera e too tau ka too sulia si kada tau. ");
INSERT INTO llu_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Sui ka dao na ana si kada na raoa doo nae moua, wane initoo nae ka falea tee wane ni rao nia eeri ka ngalia mai tesi ta ana si doo gi na e fasia lao raoa. Sui si kada wane ni rao nae e dao lao raoa ai nae, na tooa nae gi daka kwaea, sui daka faaoli oꞌoni ani nia siana wane initoo nia. ");
INSERT INTO llu_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Haia, wane initoo nae ka falea lau ruana wane ni rao aai. Sui wane nae laugo gera daka kwaea laugo, gera da kwalangia ka taꞌa asianaa, ma gera ka faaoli oꞌoni ani nia laugo. ");
INSERT INTO llu_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","I seenae, wane initoo nae ka falea lau ooula wane ni rao nia, ma gera ka kwae laugo ka maala, ma daka uini nia faasia si gula nae. ");
INSERT INTO llu_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","I buira, na wane initoo nae ka manata urii, <Tesi taa lau tara kuka iilia? Boro tara nau ku falea na agu na wela wane nau na ku liohau asianaa na ana. Haia, tara nia naa na tooa naa gi tara daka manata baita ana.> ");
INSERT INTO llu_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Sui si kada tooa na da rao ana raoa ai naa, da rikia na wane nae, gera ka bae urii i matangada kwailiu, <Nia naa na wela mamana nia na wane initoo baa mone nae, tara nia naa na ka ngali ana raoa ai nae. Golu haungia eeri ka mae ana, fuana golu ka ngalia na agolu na raoa ai na fuagolu.> ");
INSERT INTO llu_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Sui gera daka kwae taria wane nae i maa faasia lao raoa ai baa, ma daka haumaelia.>> Ma Jesus ka faarongo gera lau ka urii, <<Si taa lau na tara na wane initoo na too ana raoa ai nae ka iilia lau ana tooa naa? ");
INSERT INTO llu_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Tara nia ka lea mai, ka haumaelia tooa nae gi. Sui ka aalua na ana na raoa ai nae fuana teni tooa eꞌete gi naa ana fuana daka rao lau ana.>> Si kada tooa naa gi da rongoa si baelaa nae gi a Jesus, gera ka bae naa urii, <<Langi nae, e afetai ka urinae!>> ");
INSERT INTO llu_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Sui Jesus ka aada rigita fuada, ka bae urii, <<Urinae, si taa go na malutana si baea na lao Kekedelaa Aabu baa e bae urii, <Si fou baa na wane gi daka tole beu ana gera langi dasi dooria naa, sui nia e tae mai ka aalua fou initoo ka tasa ana luma?> ");
INSERT INTO llu_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ma so ni tei naa e asi nia fafona si fou nae, tara ka maga nia naa. Ma so ni tei na fou naa ka asia faafi nia, na nonina ka maga teefou.>> ");
INSERT INTO llu_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ana si kada nae, na fataabu baita gi fai nia na wane faatolomai gi ana kwaieresia gi, gera kafi aada haitamana si baea Jesus e haea suli gera, ma gera ka dooria daka dumulia ana si kada nae. Sui daka mou laugo ada ana tooa gi. ");
INSERT INTO llu_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ma na tooa baita gi gera ka iiliili uria daotoo dianalaa ana ta tala uria dumulilana Jesus. Seenae, daka folia teni wane eeri daka suge ana soeledilanalaa a Jesus. Sulia gera dooria daka feengia ana tesi doo na kasi oꞌolo eeri daka bobola uria falelanalaa kou fuana wane baita faasia i Rom. ");
INSERT INTO llu_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","I gera da dao siana, ma daka bae urii, <<Wane faatolomai ae, gemelu melu haitamana i oe o haea na doo mamana gi, ma osi manata aꞌabo go sulia na baitalana na iimola. Ma o faatolomainia amu na mamana sulia na kwaidoorilaa nia a God fuana na tooa gi. ");
INSERT INTO llu_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Urinae ka utaa? Nia e bobola go ana fuagolu hai golu ka fale malefo ana takisi fuana aaofia na i Rom ma e langi?>> ");
INSERT INTO llu_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ma Jesus e aada haitamana na malaꞌoe gera, ma nia ka bae urii, ");
INSERT INTO llu_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","<<Faatainia fasi mai tee fe malefo naa fuagu.>> Ma si kada gera ngalia mai si malefo fuana, nia e ledi gera ka urii, <<Haia, ni tei naa nununa naa i fafona malefo naa? Ma na hatana ni tei naa?>> Haia, gera oolisia daka urii, <<Na aaofia i Rom naa.>> ");
INSERT INTO llu_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ma Jesus ka bae urii fuada, <<Lea urinae, si taa na doo nia aaofia i Rom, molu ka oolifainia fuana aaofia i Rom. Ma si taa na doo nia God, molu ka oolifainia fuana a God.>> ");
INSERT INTO llu_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ma gera ka too aaroaro, sulia gera kwele asianaa ana si oolisilaa nae a Jesus. Ma gera ka langi si bobola na ana hai so daka malaꞌoea lau ana tesi doo i maana tooa gi. ");
INSERT INTO llu_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sui teni wane gi ana na Sadusi gi da lea mai siana a Jesus. Tooa baa gera haea hasa na tooa da mae naa, e afetai gera tatae faasia na maea. Ma daka ledi nia urii, ");
INSERT INTO llu_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","<<Wane faatolomai ae, na kwaieresia na a Moses e aalua fuagami e urii, <Lea ta wane e aadegeni, sui ka mae ma na afe nia ka oru, ma daaro si too go ana ta wela, na haasina ka aadea lau na aai oru nae, eeri daaro ka too ana ta wela fuana na wane aai baa e mae.> ");
INSERT INTO llu_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","<<Haia, tee fiu waihaasina nae gi. Na wane i nao e aadegeni, sui ka langi si too ua ana ta wela, ma ka mae laugo ana. ");
INSERT INTO llu_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ma na ruana wane ka aadea lau na aai oru nae, ");
INSERT INTO llu_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ma sui na ooula wane laugo. Ma ka urinae sui go fuadaalu na fiu waihaasina nae gi. Ma gera dasi too sui go ana ta wela ma daka mae sui go. ");
INSERT INTO llu_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ma i buri, na aai oru baa ka mae. ");
INSERT INTO llu_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Haia, ana fe dani na tooa mae gi tara daka tatae lau uria na mouria, ni tei adaalu na aarai nia mamana geni naa? Sulia daalu sui go daalu aadea.>> ");
INSERT INTO llu_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ma a Jesus e oolisida ka urii, <<Ana si kada naa, na wane gi ma na geni gi gera aarai ma daka afe. ");
INSERT INTO llu_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Sui ana si kada aai na e nia ua mai, na wane gi ma na geni gi na gera faorana fai nia na tataelaa faasia na maea ma daka too na ana na mouria firi, e langi dasi aarai ma dasi afe lau. ");
INSERT INTO llu_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Sulia i gera da iilingia na ada na ensel gi, ma e afetai na daka mae. I gera na wela nia gi naa a God, sulia da tatae faasia na maea. ");
INSERT INTO llu_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","<<Haia, ma na kekedelaa nia a Moses e faafolaalia na ana fuaga hasa na tooa mae gi, daka mouri lau. Sulia si kada baa a God e faatai ana fuana a Moses ana eere baa ka harufia fe ai toꞌou baa, a Moses e alangia a Lord ana, <A God baa a Abraham, ma a God a Aesak, ma a God a Jakob.> ");
INSERT INTO llu_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Na malutana e urii: Teni tooa gi da mae naa, gera fooasia ua a God, sulia gera mouri ua fai nia.>> ");
INSERT INTO llu_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ma teni wane adaalu gi na wane faatolomai ana kwaieresia gi, gera ka bae urii, <<Wane faatolomai ae, na oolisilaa oe naa e diana asianaa!>> ");
INSERT INTO llu_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ma gera mou naa uria ledilaa lau. ");
INSERT INTO llu_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Sui a Jesus ka ledi urii fuada, <<Utaa baa gera ka haea a Christ nia wela e lea mai faasia na kwalafaa a David? ");
INSERT INTO llu_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Sui a David e tala haea ana i laona Kekedelaa Sam gi, <A God e bae urii fuana Lord nau: Oko gwouru i bali aaolo ani nau, ");
INSERT INTO llu_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","maasia si kada tara kuka adomi oe uria saitasalaa ana maalimaea oe gi.> ");
INSERT INTO llu_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Haia, a David mone e alangi nia ana Lord, sui tara Christ ka aalua wela nia utaa?>> ");
INSERT INTO llu_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Si kada tooa oro gi da fafurongoa, a Jesus ka bae urii fuana na oote fafurongo nia gi, ");
INSERT INTO llu_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","<<Muka aadasuli gamu faasia na faatolomai gi ana kwaieresia gi, sulia gera dooria liliulaa fai nia maku ruruu tekwa gi, ma daka dooria laugo hasa na tooa gi da hae baita ani gera i maana usia gi, ma daka dooria gwourulaa ana naofe gula ni gwourulaa i laona Beu Aabu gi ni figulaa, ma si gula diana gi kada ana fafangaa gi. ");
INSERT INTO llu_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Sui tooa baa da belia na luma gera oru gi, ma daka fooa tetekwa gi eeri na tooa gi da tangoda. Haia, na faatolomai gi ana kwaieresia gi na kwakwaelaa gera tara e baita ka tasa.>> ");
INSERT INTO llu_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Si kada Jesus e too ua i Beu Aabu a God, nia ka aadaada, ma ka rikia wane rikidoo gi da lea mai uria fale malefolaa lao fuli ni fale malefoa. ");
INSERT INTO llu_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ma nia ka rikia laugo tee gwe inite na aarai nia e mae naa. Ni oru nae e siofaa asianaa. Nia ka lea mai, ma ka falea roo fe mige malefo toꞌou. ");
INSERT INTO llu_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ma Jesus ka bae urii, <<Doo mamana nau ku haea fuagamu, si taa na gwe oru siofaa na nia e falea, nia baita ka tasa liufia tooa na gera fale malefo baita. ");
INSERT INTO llu_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Sulia tooa rikidoo, gera falea go ada ta bali toꞌou ana rikidooa gera gi. Sui gwe oru siofaa naa nia e fale teefou na ana si doo gi na nia e too ana uria mourilaa ana.>> ");
INSERT INTO llu_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ma teni wane gi ana na oote fafurongo nia gi, gera tangoa na Beu Aabu a God, sulia na aadasilana e diana asianaa ana si fou diana gi na da kasia ana, ma ana si falelaa gi laugo na da falea fuana a God laugo. Sui a Jesus ka bae urii fuada, ");
INSERT INTO llu_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","<<Si doo naa gi sui go na mu rikida naa, tara fe dani e dao mai e langi tesi fou si too go i fulina, da aatoli teefou i aano!>> ");
INSERT INTO llu_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ma gera ka soetoona daka urii, <<Wane faatolomai ae, i aangita naa si doo nae gi ka dao mai ana? Ma si mamalafooa taa na ka dao fasi i nao eeri ka faatainia nia e garangi fuli naa?>> ");
INSERT INTO llu_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ma a Jesus e oolisida ka urii, <<Muka aadaada diana, aata gera ka talai garo ani gamu, sulia na wane oro gi tara daka dao mai ana hatagu, ma gera ka susuge urii, <I nau naa na Christ!> Ma gera ka haea laugo, <Si kada baa naa na e dao naa!> Langi musi lea sulida. ");
INSERT INTO llu_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ma langi musi mou ana si kada mu rongoa na oomea ma na firua baita gi, sulia si doo nae gi ka fuli fasi i nao. Sui boroi ana si doo nae gi sui go ka fuli, na suilana na molaagali e langi kasi garangi ua. ");
INSERT INTO llu_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ma tara teni gule tooa gi daka firu fai nia teni gule tooa gi aai, ma teni initooa gi daka firu fai nia teni initooa gi aai. ");
INSERT INTO llu_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ma na aanuanu baita gi ka dao, ma na fioloa gi, ma na uuni mataia baita asianaa gi ka liu ana fera gi sui, ma si doo baita eꞌete gi ni moungilana ka hagatafa mai faasia lao lofo langi uria mamalafooa. ");
INSERT INTO llu_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ma i nao ana si doo nae gi ka fuli, tara daka iilia si doo taꞌa gi ani gamu sulia mu roosuli nau. Tara gera ka kani gamu, ma daka faafii gamu, ma daka fale gamu fui laona na Beu Aabu ni figulaa gi uria na iilitoolagamu, ma daka aalu gamu i laona na beu ni kanilaa, ma daka ngali gamu i naona wane initoo gi uria ketolaa gamu. ");
INSERT INTO llu_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Nia naa si kada diana na fuagamu eeri muka faataloa na Faarongolaa Diana nia a God. ");
INSERT INTO llu_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ma musi manata aꞌabo lau uria si taa naa muka oolisida ana. ");
INSERT INTO llu_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Sulia nau tara ku falea sui naa fuagamu si baea gi ana na liotooa, ma e langi ta wane ana maalimaea gamu gi so ka ngenge gamu ma ka langi si tofea si doo gi na mu haea. ");
INSERT INTO llu_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ma na maa gamu gi, ma ni tee gamu gi, ma na haasigamu gi, ma na tooa futa gamu gi, ma na ruana gamu gi, tara daka fale gamu fuana na wane initoo gi. Ma teni wane ani gamu daka haumaelida. ");
INSERT INTO llu_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Na tooa gi sui daka maasusuala ani gamu i nunufagu. ");
INSERT INTO llu_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Sui boroi ana, afetai ta tesi iifu toꞌou ana na ketemu ka langi ana. ");
INSERT INTO llu_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Muka take ngasi ana manata mamanalaa gamu gi, ma tara muka mouri.>> ");
INSERT INTO llu_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ma Jesus ka bae lau urii fuada, <<Si kada mu rikia na wane ni firua gi da aala galia Jerusalem, muka haitamana naa tara gera ka tagalangainia na fera baita nae. ");
INSERT INTO llu_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Haia, si kada baa, tooa na gera too i Judea gera daka tafi teefou fui gwouna fe tolo gi. Ma tooa na da totoo lao mae fera baita naa, gera ka tafi fasia. Haia, ma tooa na da too galigalia mai langi dasi ooli lau mai fuana fera baita naa. ");
INSERT INTO llu_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Sulia kadamanga nae kadamanga ana kwakwaea eeri ka faafonoa si taa gi baa gera kekede sulia i laona Kekedelaa Aabu. ");
INSERT INTO llu_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ana si kada nae, kwaimanatailaa baita fuana geni gi na da iiana ma na geni na da faasusufia gala wela gi. Ma si kwaimanatailaa baita laugo tara ka daofia na fera naa, sulia tara a God ka kwaea na tooa gi i seenae. ");
INSERT INTO llu_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Bali ada tara daka haumaeli gera ana naefe. Haia, ma bali ani gera tara gera dumulida ma gera ka kani faafida ma gera ka ngalida fuana fera eꞌete gi. Ma na tooa na gera langi dasi Jiu tara daka labasia fera baita i Jerusalem lea ka dao ana isingana si kada gera gi. ");
INSERT INTO llu_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","<<Si doo eꞌete gi ka fuli fuana na hato ma na sinali ma na bubulu gi. Ma na tooa gi sui ana na aefera baita gi sui i laona na molaagali daka fiitala, ma daka mou ana na kukuru ma na baitalana na aasi ma na nanafo gi. ");
INSERT INTO llu_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ma na tooa gi daka mangosuu sulia daka mou asianaa, si kada da maasia ana si doo naa gi ka fuli mai faafia na molaagali sui. Sulia na doo gi i lofo langi daka lea garo. ");
INSERT INTO llu_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Lea sui, i nau na Wela nia Iimola gi, tara kufi dao faatai. Nau ku dao mai fai nia na rigitaa baita ma na raralaa baita i fafona na barobaro gi. ");
INSERT INTO llu_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ma si kada na doo naa gi e hafali fuli, muka take ma muka aada alaa, sulia na wane kwaifaamouri gamu e dao garangi na mai.>> ");
INSERT INTO llu_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Sui Jesus ka haea si oomelawanea na fuada urii, <<Muka manata fasi sulia ai figi fai nia ai gi sui lau i seegi. ");
INSERT INTO llu_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Kada mu rikia na abada e ngongosala, muka haitamana na kada fuana agoꞌagoa nia garangi naa. ");
INSERT INTO llu_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ka urinae laugo, si kada mu rikia si doo naa gi ka dao mai, muka haitamana naa si kada fuana God ka Aaofia nia dao garangi naa. ");
INSERT INTO llu_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Doo mamana nau ku haea fuagamu, tara si doo nae gi ka dao mai suifetei tooa na da mouri ana si kada naa dasi mae ua. ");
INSERT INTO llu_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Tara i langi ma na molaagali naa daka funu, sui taa na baelagu go naa ka langi kasi funu. ");
INSERT INTO llu_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","<<Muka aadaada diana aata muka roo ana fangaa baita gi ma na gwou baitalaa ma na manata aꞌabolaa gi ana na mouria naa i laona molaagali, aata fe dani nae ka dao faatona gamu iilingia ta tori. ");
INSERT INTO llu_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Sulia si doo nae gi ka dao mai faafia na tooa gi sui, ana si gula gi sui i laona molaagali. ");
INSERT INTO llu_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Muka aadaada diana ma muka fooa ana si kada gi sui, eeri muka too ana na rigitaa uria na mourilaa i laona si doo nae gi na ka fuli. Ma eeri muka si ida si kada gamu take i naogu.>> ");
INSERT INTO llu_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ma fe dani gi sui nae, a Jesus e faatolomai nia tooa gi laona Beu Aabu a God. Ma i haulafi gi nia ka lea uria gwouna fe uuo i Olivtri. ");
INSERT INTO llu_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Haia, ma ana fe ubongi maegalogalo gi sui, tooa oro daka dao mai laona Beu Aabu a God uria rongolana baelana Jesus. ");
INSERT INTO llu_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Haia, si kada ana Fangaa gera Jiu gi ana Lofoagaua nia garangi naa. Ana fangaa naa, gera haitamana anilana beredi na langi gera si aalua ta iisi ana. ");
INSERT INTO llu_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ma na fataabu baita gi ma na wane faatolomai gi ana kwaieresia gi, gera ka manata uria haungi aagwalaa ana Jesus, sulia gera moungia na tooa gi. ");
INSERT INTO llu_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ma a Satan ka dao i laona manatana a Judas Iskariot ta wane ana aakwala wane ma na roo wane fafurongoa baa gi a Jesus. ");
INSERT INTO llu_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Nia naa Judas ka lea siana fataabu baita gi ma na wane naonao gi ana tooa na da aadasulia Beu Aabu a God, ma ka haea fuada nia haitamana ka kwaiꞌadomi uria dumulilana a Jesus. ");
INSERT INTO llu_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ma gera ka eele asianaa ma daka bae tara daka fale si malefo fuana. ");
INSERT INTO llu_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas ka aalafaafia ma ka talaꞌae aadalaa uria si kada na tooa langi dasi too fai nia Jesus eeri ka fale nia fuada. ");
INSERT INTO llu_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Haia, fe dani e dao na mai na tooa Jiu gi da haitamana anilana beredi na e langi ta iisi i laona, fe dani fuana haungilana gala sipsip gi ma na aade aagaulaa ana fanga fuana na Fangaa ana Lofoagaua. ");
INSERT INTO llu_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ma Jesus ka oodua Peter fai nia John ka bae urii fuadaaro, <<Moro lea, moro ka aade aagau ana si fanga fuana golu ka ania ana na Fangaa ana Lofoagaua.>> ");
INSERT INTO llu_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Daaro ka ledi urii ana Jesus, <<Fai naa o dooria mere ka aade aagau ana?>> ");
INSERT INTO llu_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesus oolisi daaro ka bae urii, <<Si kada moro dao kou ana i fera, tara moro ka kwaitodai fai nia tee wane e toolua na kufi doo uria ngali kafolaa. Moro ka lea suli nia uria luma na nia lea uria. ");
INSERT INTO llu_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Moro ka bae urii fuana wane ana luma, <Na wane faatolomai e bae mai urii fuamu: Ni fai na kade luma fuana kuka ania ana na Fangaa ana Lofoagaua fai nia na fafurongo nau gi?> ");
INSERT INTO llu_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ma tara na wane nae nia ka faatainia kade luma baita ana luma nae e too i langi, si gula na doo gi gera aade aagau, ma seenae moro ka aade aagau ana fanga.>> ");
INSERT INTO llu_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Haia, daaro ka lea naa, daaro ka daotoona doo gi sui mala Jesus e haea fuadaaro. Ma daaro ka aade aagau na ana fanga i seenae. ");
INSERT INTO llu_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","E dao ana si kada uria na anilana na Fangaa ana Lofoagaua, ma a Jesus fai nia na aposol nia gi, daka gwouru na ana si gula ni fangalaa. ");
INSERT INTO llu_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ma i nia ka bae urii fuada, <<I nau ku dooria asianaa na anilana na Fangaa naa ana Lofoagaua fai gomolu, sui kufi nonifii agu. ");
INSERT INTO llu_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Sulia nau ku haea fuamolu, e afetai kuka ania na Fangaa ana Lofoagaua lau, lelea ka dao ana si kada ana faamamanalana i laona na Initooa a God.>> ");
INSERT INTO llu_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Sui a Jesus e ngalia na teteu ma ka baelafea a God. Sui nia ka bae urii fuada, <<Muka ngalia, ma muka ado ana i matangamolu. ");
INSERT INTO llu_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nau ku haea fuamolu, ita i taraꞌena ka ooli aala, nau kusi gwoufia lau na waen naa, lelea ka dao ana si kada na Initooa a God ka dao mai.>> ");
INSERT INTO llu_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Sui a Jesus e ngalia na beredi, ma ka baelafea a God, sui nia ka niia, ma ka falea fuada. Ma ka bae urii, <<Nia naa na nonigu na ku falea fuagamu. Muka iilia si doo naa uria na manatatoolagu.>> ");
INSERT INTO llu_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","I buira na fangalaa, nia e ngalia na teteu ma ka aade urinae laugo, ka bae urii, <<Na teteu naa na teteu ana gwalulaa faalu nia a God ana na abugu na e iigwa fuagamu. ");
INSERT INTO llu_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","<<Sui aada fasi! Na wane na tara ka fale nau fuana maalimaea nau gi, nia e gwouru go ana fai nau i seegi ana si gula naa ni fangalaa. ");
INSERT INTO llu_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Sulia i nau, na Wela nia Iimola gi, tara ku mae na mone iilingia na a God e dooria na mai fuagu. Sui taa, e taꞌa asianaa fuana na wane na e fale nau fuana maalimaea nau gi!>> ");
INSERT INTO llu_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ma gera hafalia na ledi kwailiulaa i matangada uria ni tei ada na tara ka iilia si doo nae. ");
INSERT INTO llu_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ma na oote fafurongo nia gi da oolisusuu laugo i matangada kwailiu uria ni tei ada na e baita ka tasa. ");
INSERT INTO llu_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ma a Jesus ka bae urii fuada, <<Na wane initoo gi ana na molaagali naa, da too ana na baitaa usia na tooa gera gi, ma da suungaida eeri daka roosuli gera. Ma daka dooria na tooa gi daka alangi gera ana na wane kwaimaani gera na tooa gi. ");
INSERT INTO llu_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Haia, ma ni tei ani gamu na e baita, ka iilingia na wane na e toꞌou. Ma na wane na e kwaitalai, ka iilingia na wane ni rao. ");
INSERT INTO llu_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","E utaa? Ni tei na e baita, na wane na e gwouru uria na fangalaa, ma langi na wane na e rao fuana? Na wane na e gwouru naa e baita. Haia, ni nau ku too i matanga gamu iilingia na wane na e rao. ");
INSERT INTO llu_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","<<Gamu mu too fai nau i laona na iilitooa nau gi sui. ");
INSERT INTO llu_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Iilingia a Maa nau e falea sui naa si initooa fuagu, ka urinae laugo i nau ku falea initooa fuagamu, ");
INSERT INTO llu_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","eeri muka fanga fai nau ma muka gwou fai nau i laona Initooa nau. Ma i gamu muka gwouru ana si gula ni gwourua gi ana na initooa, ma muka baita usia na aakwala ma roo aebara baa gi i Israel.>> ");
INSERT INTO llu_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Sui a Jesus e bae urii fuana Peter, <<Simon Peter ae! O fafurongo fasi. A God e faalamainia naa a Satan eeri ka iilitoo molu sui, iilingia ta wane na e rao i hara ka inifitaa na mige doo diana gi faasia na ungedoo taꞌa gi. ");
INSERT INTO llu_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Sui taa, Simon ae, nau ku fooa naa fuamu, eeri na fiimamanalaa oe kasi funu. Ma ana si kada na o manata ooli lau mai fuagu, oko faarigitaa na tooa aai gi na da manata mamana ani nau.>> ");
INSERT INTO llu_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ma a Peter e oolisia ka urii, <<Lord ae, nau ku aade aagau go agu uria lealaa fai oe i laona beu ni kanilaa ma na maelaa fai oe!>> ");
INSERT INTO llu_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ma a Jesus e oolisia ka urii, <<Peter ae, nau ku haea fuamu, i taraꞌena i laona fe rodo naa, ma i naona na kakaraikua e ai, tara oko haea ana oolu si kada hasa o lalafusi nau.>> ");
INSERT INTO llu_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Sui a Jesus ka bae urii fuana na oote fafurongo nia gi, <<E utaa? Si kada baa ku oodu gamu kou ma ka langi musi too ana tesi malefo ma langi ta wai ma langi ta tae silipa, molu kukuru ana tesi doo baa?>> Ma da oolisia daka urii, <<Langi go.>> ");
INSERT INTO llu_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ma Jesus ka bae urii, <<Haia, ana si kada nae, so ni tei naa e too ana tesi malefo langi ta wai, nia ka ngalia ana. Ma ni tei naa e langi si too ana ta naefe ni firulaa, nia ka faafoli ana na maku ruruu baita nia ma ka folia ta naefe. ");
INSERT INTO llu_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Haia, ni nau ku haea si doo naa fuamolu sulia na Kekedelaa Aabu baa suli nau baa urii, <Daka oofu nia fai gera na wane taꞌa gi.> Si doo naa tara e fuli naa fuagu sulia na kekedelaa gi sui go suli nau tara e fuli mamana.>> ");
INSERT INTO llu_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ma na oote fafurongo nia gi daka bae urii, <<Lord ae, o rikia fasi, gia too na ana tee roo naefe ni firulaa i see!>> Ma i nia e oolisida ka urii, <<E bobola naa nae!>> ");
INSERT INTO llu_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","A Jesus fai nia na oote fafurongo nia gi da tafusia na fera baita nae, ma daka lea naa uria fe uuo da alangia Olivtri iilingia da iilia sulia dani. ");
INSERT INTO llu_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ma si kada da dao ana si gula nae, nia ka bae urii fuada, <<Muka fooa aata Satan ka iilitoo gamu.>> ");
INSERT INTO llu_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Sui a Jesus e lea toꞌou kou faasida ka bobola fai nia tee fe uilaa ana fou, ma ka boururu i aano ma ka fooa. ");
INSERT INTO llu_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Nia ka bae urii, <<Maa ae, lea so na doorilamu, oko lafua amu na teteu naa ana nonifiilaa naa faasi nau. Sui langi lau na kwaidooria nau naa, na kwaidooria oe ana.>> ");
INSERT INTO llu_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ma tee ensel faasia i langi e dao mai, ma ka faarigita nia. ");
INSERT INTO llu_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ma si kada na liona ka fii asianaa, i nia ka fooa rigita lau. Ma na iꞌida na nonina ka iigwa i aano iilingia na gwigwire abu. ");
INSERT INTO llu_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ma si kada e tatae faasia na fooalaa, nia ka ooli siana na oote fafurongo nia gi. Gera da teo ada, i aena da liodila asianaa. ");
INSERT INTO llu_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ma a Jesus ka bae urii fuada, <<Uria taa na molu ka teo? Molu tatae ma molu ka fooa, eeri Satan ka langi si iilitoo molu.>> ");
INSERT INTO llu_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Si kada Jesus e bae ua go ana faida, tee figua baita daka dao na mai. Ma tee wane ada na oote fafurongo nia baa gi na hatana a Judas na e eeta mai i nao ada. Ma nia e dao mai siana a Jesus uria na nonoilana. ");
INSERT INTO llu_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Sui a Jesus ka bae urii fuana, <<Judas ae, e utaa? Oe o falea na Wela nia Iimola gi fuana na maalimaea nia ana na nonoilana?>> ");
INSERT INTO llu_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ma si kada na oote fafurongo nia gi na da too fai nia a Jesus, daka rikia si doo naa, daka bae urii, <<Lord ae! E utaa? Melu kwaeda ana na naefe gemelu baa gi ni firulaa?>> ");
INSERT INTO llu_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ma tee wane ada, ka kwaea tee wane ni rao nia na fooanigwou, ma ka taba muusia naa na bali aalinga aaolo nia. ");
INSERT INTO llu_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Sui a Jesus ka bae urii, <<Langi molu si iilia si doo nae!>> Ma nia ka hamosia na aalingana na wane nae, ma ka faamafoa naa. ");
INSERT INTO llu_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Sui a Jesus ka bae fuada na fataabu baita gi ma na wane gi na da folo usia na Beu Aabu a God ma na wane baita gi na da lea mai nae uria na dumulilana, ka urii, <<Utaa? Nau ta wane bebeli naa eeri molu ka dumuli nau mai fai nia na naefe ni firulaa gi ma na subi gi? ");
INSERT INTO llu_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nau ku too go agu siagamu i laona na Beu Aabu a God sulia dani, sui langi molu si hasi go uria na dumulilagu. Sui si kada gamu naa nae, si kada ana na rigitaa ni rorodoa na Wane Taꞌa e initoo ana.>> ");
INSERT INTO llu_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Sui gera ka dumulia naa a Jesus, ma daka talaia naa i laona na luma nia na fooanigwou. Ma a Peter ka lea laugo kou i burida ana ta kade tala tau laugo ana faasida. ");
INSERT INTO llu_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ma tee eere da oogumaana i initoona na kade luma i maa, ma a Peter ka gwouru naa fai nia na tooa gi na da gwouru galia na eere nae. ");
INSERT INTO llu_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ma si kada tee haari ana na haari ni rao gi e rikia a Peter e gwouru i seenae garangi na eere nae, ni nia ka aada diana ana ma ka bae urii, <<Na wane naa e too laugo fai nia a Jesus.>> ");
INSERT INTO llu_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Sui a Peter ka kwaigoloi ka urii, <<Geni naa ae, nau kusi haitamana na wane nae!>> ");
INSERT INTO llu_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ma langi si tau laugo i buira, tee wane ka rikia a Peter ma ka bae urii, <<Ni oe tee wane ada laugo naa!>> Sui a Peter e oolisia ka urii, <<Wane nau ae, nau e langi.>> ");
INSERT INTO llu_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ma ana tesi kada lau i buira, tee wane lau ka bae rigita ka urii, <<Nia mamana. Na wane naa e too laugo fai nia a Jesus, sulia nia laugo na wane faasia i Galili!>> ");
INSERT INTO llu_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Sui a Peter e oolisia ka urii, <<Wane nau ae, nau ku lalafusia na doo na o bae sulia!>> Ma si kada nia e bae ua go ana, na karaikua ka ai naa. ");
INSERT INTO llu_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ma na Lord e aabulo ma ka aada kou fuana a Peter. Ma a Peter ka manatatoona naa si baea baa a Lord e haea fuana baa urii, <<I nao ana karaikua e ai, oko kwaigoloi ani nau sulia oolu si kada haea hasa o lalafusi nau.>> ");
INSERT INTO llu_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ma a Peter e haga kou i maa ma ka aangi i sulia na liodilalaa baita asianaa. ");
INSERT INTO llu_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ma na wane ni oomea gi na da folo galia a Jesus, da faawaela ana ma daka rabusia. ");
INSERT INTO llu_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ma da kani bokosia na maana, ma daka ledi nia daka urii, <<O haea fasi ni tei na e kwae oe nae?>> ");
INSERT INTO llu_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ma da haea si baelaa tataga oro gi laugo fuana. ");
INSERT INTO llu_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ma i ofaidani ua, na wane baita gi ana Jiu ma na fataabu baita gi ma na wane faatolomai gi ana na kwaieresia gi da bae oofu, ma daka talaia mai a Jesus siada. ");
INSERT INTO llu_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ma daka bae urii fuana, <<O haea fuamelu. Ni oe na Christ naa na wane God e filia uria Aaofialaa?>> Ma nia e oolisida ka urii, <<Lea so ku haea fuagamu, e afetai muka manata mamana ani nau. ");
INSERT INTO llu_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ma lea so ku ledi gamu ana tesi doo, e afetai muka oolisia. ");
INSERT INTO llu_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Haia, ma e ita ana si kada naa ka ooli alaa, nau na Wela nia Iimola gi ku gwouru i bali aba aaolo ana a God na e rigita ka tasa.>> ");
INSERT INTO llu_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ma i gera sui go da ledia daka urii, <<Utaa? I oe na Wela nia a God naa?>> Ma nia e oolisida ka urii, <<Nia naa nae molu tala haea sui naa nae.>> ");
INSERT INTO llu_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ma daka bae urii, <<Langi tesi faamamanalaa lau na golu dooria. Sulia golu tala rongoa sui naa agolu na baelana!>> ");
INSERT INTO llu_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ma na figua nae teefou da tatae ma daka talaia a Jesus siana a Paelat uria na keketolana. ");
INSERT INTO llu_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ma da hafalia na feengilana daka urii, <<Gemelu melu daotoona na wane naa e bae alingana na tooa gami gi. Ma ka haea fuada, dasi falea na malefo ana na takisi fuana na Aaofia i Rom, ma ka haea hasa i nia na Christ, na wane na a God e filia uria Aaofialaa.>> ");
INSERT INTO llu_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ma Paelat ka ledia ka urii, <<Utaa? Ni oe naa Aaofia gera Jiu gi?>> Ma a Jesus e oolisia ka urii, <<Nia naa nae o haea nae.>> ");
INSERT INTO llu_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Sui a Paelat ka bae urii fuada na fataabu baita gi ma na figua nae, <<I nau kusi daotoona go tesi garolaa ana na wane naa fuana haumaelilanalaa.>> ");
INSERT INTO llu_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Sui daka bae rigita ka tasa daka urii, <<I nia e gaea na tooa gi i Judea ana na faatolomaia nia gi. E ita mai i Galili lelea ka dao naa i seenaa.>> ");
INSERT INTO llu_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ma si kada a Paelat e rongoa si doo naa, nia ka ledi gera ka urii, <<Utaa? Na wane naa e lea mai faasia i Galili naa?>> ");
INSERT INTO llu_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ma si kada nia e haitamana naa a Jesus e lea mai faasia na gula na a Herod e baita usia, nia ka fale nia siana a Herod. Sulia a Herod e too laugo i Jerusalem ana si kada nae. ");
INSERT INTO llu_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ma si kada a Herod e rikia a Jesus, nia ka eele asianaa, sulia nia e rongoa go ana na uunuunulaa sulia, ma ka kwaimaasi ka tau na mai uria na rikilana. Ma nia e dooria rikia a Jesus ka iilia tesi doo ni kwelelaa ana. ");
INSERT INTO llu_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","A Herod e ledia ana si doo oro gi, sui a Jesus kesi oolisia go ana tesi doo. ");
INSERT INTO llu_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ma na fataabu baita gi ma na wane faatolomai gi ana na kwaieresia gi, da take i seenae, daka feengia naa a Jesus. ");
INSERT INTO llu_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Sui a Herod ma na wane ni oomea nia gi daka faawaelaa ada ana a Jesus ma daka bae tataga fuana. Ma daka faaruufia ana tee maku tekwa diana, ma daka ooli lau fai nia fuana a Paelat. ");
INSERT INTO llu_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ma e ita ana fe dani nae, a Herod ma a Paelat daaro kafi oofu lau uria kwaimaanilaa. I nao, i daaro na roo maalimaea gi. ");
INSERT INTO llu_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","A Paelat e oofua na fataabu baita gi ma na wane naonao gi ma na tooa gi. ");
INSERT INTO llu_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ma ka bae urii fuada, <<I gamu mu talaia mai na wane naa siagu, ma muka haea i nia e gaea na tooa gi. Sui nau ku ledi nia i maamolu, ma langi kusi daotoona go tesi garolaa ani nia ana si doo naa gi na mu feengia ana. ");
INSERT INTO llu_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ma a Herod boroi kesi daotoona go tesi garolaa ani nia, sulia nia ka oolifaini nia laugo ana mai. Na wane naa kesi iilia go tesi doo na e garo eeri i nia ka mae. ");
INSERT INTO llu_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Nia naa, nau kuka falea eeri daka rabusia. Sui kuka falea ka lea na ana.>> ");
INSERT INTO llu_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Haia, ana na Fangaa ana Lofoagaua gi, a Paelat ka lugasia tee wane na e too i laona na beu ni kanilaa fuada na Jiu gi sulia na malutaa gera. ");
INSERT INTO llu_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Sui ni gera sui go da rii daka urii, <<Na wane naa ka mae! Ma oko lugasia mai amu a Barabas fuamelu!>> ");
INSERT INTO llu_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","A Barabas da aalua i laona na beu ni kanilaa sulia i nia e hafalia na firua baita i laona na fera baita nae, ma i nia ka hauwane laugo. ");
INSERT INTO llu_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","A Paelat e dooria ka lugasia a Jesus, ma ka soeledia lau kou na figua nae. ");
INSERT INTO llu_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Sui daka rii ka lea dongaa daka urii, <<Molu haumaelia! Molu ka fotoi nia i fafona na airarafolo!>> ");
INSERT INTO llu_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ma a Paelat ka bae urii lau fuada ana ooluna si kada, <<Uria taa? Tesi garolaa taa na nia e iilia? Nau kusi daotoona go tesi doo na nia e iilia eeri i nia ka mae. Nau ku falea eeri daka rabusia, sui kuka lugasia na agu ka lea na ana.>> ");
INSERT INTO llu_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Sui gera rii ka lea dongaa fuana daka fotoia a Jesus i fafona na airarafolo. Ma na riilaa gera ka saitasa naa. ");
INSERT INTO llu_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ma a Paelat ka falea na kwaelaa na da gani nia uria. ");
INSERT INTO llu_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ma nia ka lugasia a Barabas na wane baa da dooria, na wane baa da aalua i laona na beu ni kanilaa sulia hafalilana na firua baita, ma na hauwanelaa. Sui a Paelat ka falea a Jesus fuada, sulia na kwaidooria gera fuana. ");
INSERT INTO llu_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ma i gera daka talaia a Jesus uria na maelaa. Ma si kada da lea ana, daka daotoona tee wane hatana a Simon faasia na fera i Saeren, e lea mai i Jerusalem faasia i hara. Da dumulia ma daka aalua na airarafolo i gwouna abana, ma daka suungai nia hai ka toolua i buira a Jesus. ");
INSERT INTO llu_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ma tee figua baita daka lea i burina. Ma teni geni gi i laona na figua nae daka suunimae ma daka aangisia. ");
INSERT INTO llu_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","A Jesus e aabulo fuada ma ka bae urii, <<Geni naa gi i Jerusalem ae! Langi musi aangisi nau. Muka aangisi gamu agamu i talagamu ma na wela gamu gi. ");
INSERT INTO llu_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Sulia e dao na ana fe dani gi na tooa gi daka bae urii, <Ka oilakea fuada na geni gi na da abaꞌato, ma na geni gi na e langi dasi faafuta, ma ka langi dasi faasusu!> ");
INSERT INTO llu_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ma si kada nae naa na tooa gi tara daka bae urii fuana na tolo gi, <Muka asi gamu mai faafi gami.> Ma daka bae urii fuana na tolo gi, <Muka haufini gami mai.> ");
INSERT INTO llu_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Sulia lea da iilia si doo naa ani nau na wane naa ku oꞌolo, tara daka iilia si doo gi na e taꞌa ka tasa fuagamu na mu too ana na aade taꞌalaa.>> ");
INSERT INTO llu_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ma da ngalia laugo tee roo wane da iilia si doo garo gi, uria na haumaelilada fai nia a Jesus. ");
INSERT INTO llu_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ma si kada da dao ana si gula na da alangia ana <<Na Lelete>>, daka fotoia a Jesus i fafona na airarafolo. Ma na roo wane baa gi na da iilia doo garo gi, gera ka fotoi daaro laugo i fafona roo airarafolo gi, tee wane ka too i bali aaolo ana a Jesus, ma ta wane aai ka too i bali mouli ani nia. ");
INSERT INTO llu_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ma a Jesus ka bae urii, <<Maa ae, oko manata luke gera, sulia da lalafusia si doo na da iilia.>> Ma daka lalaba ana na daisi uria na maku nia gi, ma daka tolingia i matangada. ");
INSERT INTO llu_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Na tooa gi na da take i seenae daka bubu go ada, ma na wane naonao gi i Jiu da faawaela ana daka urii, <<Nia e faamouria na tooa eꞌete gi. Lea so i nia na Christ, na wane na a God e aadafilia uria Aaofialaa, nia e bobola uria ka faamouri nia fasi i talana.>> ");
INSERT INTO llu_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ma na wane ni oomea gi da faawaela laugo ana, ma da lea kou siana ma daka falea na waen afae fuana. ");
INSERT INTO llu_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ma daka bae urii, <<Lea ni oe na Aaofia gera na tooa gi i Jiu, oko faamouri oe fasi i talamu!>> ");
INSERT INTO llu_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ma daka kedea si baea naa gi i fafona na gwouna daka urii, <<Nia naa na Aaofia gera Jiu gi.>> ");
INSERT INTO llu_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ma tee wane ana na roo wane baa gi na da fotoia fai nia a Jesus e bae tataga fuana ka urii, <<Utaa? Ni oe na Christ naa naa? Oko faamouri oe i talamu ma ni gemere laugo!>> ");
INSERT INTO llu_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Sui na ruana wane e bae susuala ka urii, <<Utaa? I oe osi moungia go a God? Golu bobola go agolu sulia da haungi golu. ");
INSERT INTO llu_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Sui taa, goro mone, na kwaelaa naa e oꞌolo go ana naa sulia goro ngalia naa na maana si doo taꞌa na goro iilida gi. Haia, ma ni nia go na e langi kasi iilia go tesi doo na e garo.>> ");
INSERT INTO llu_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ma i nia ka bae urii fuana a Jesus, <<Jesus ae, oko manatatoogu i lao Initooa oe.>> ");
INSERT INTO llu_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ma a Jesus ka bae urii fuana, <<Nau ku haea na si doo mamana fuamu, i taraꞌena oko too fai nau i langi.>> ");
INSERT INTO llu_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","E ita initoona na hato, na lolofaa nae loulou ka rorodoa, lelea ka dao ana kade hato i haulafi. ");
INSERT INTO llu_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ma na maku baita na e bokosia na gula aabu i laona na Beu Aabu a God ka kakari ana roo bali doo. ");
INSERT INTO llu_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ma a Jesus e rii baita ka urii, <<Maa ae, nau ku falea kou na mangogu fuamu.>> Nia ka haea si baea naa sui, ma ka mae naa. ");
INSERT INTO llu_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ma na wane baita ana na wane ni oomea gi e rikia si doo naa, ma i nia ka baelafea a God, ka urii, <<E mamana, nia na wane diana!>> ");
INSERT INTO llu_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ma si kada na tooa nae gi na da figu i seenae uria na bubulaa da rikia na maelana a Jesus, i gera sui go daka ooli na ada i fera gera gi. Ma daka gumulia na ruruuda uria faatainilana na liodilalaa gera. ");
INSERT INTO llu_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ma na tooa gi sui na da haitamana a Jesus, fai nia na geni gi na da lea i burina faasia i Galili, da take tau go ada, ma daka rikia go ada si doo nae gi sui. ");
INSERT INTO llu_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Haia, tee wane faasia na fera i Arimetea i laona na lolofaa Judea, na hatana a Josef e too laugo i seenae. Ma i nia na wane oꞌolo ma na wane diana, ma nia ka kwaimaasi laugo uria na daolana na Initooa a God. Ma sui boroi ana i nia na wane ada na wane baita gi ana Jiu, nia kasi aala go faafia si doo gi na da haea ma daka iilia ana Jesus. ");
INSERT INTO llu_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Nia ka lea siana a Paelat, ma ka gania uria na nonina a Jesus. ");
INSERT INTO llu_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Sui nia ka lafua na nonina a Jesus, ma ka afua ana si maku kwakwaoa. Ma ka aalua i laona na kwaingeia faalu na da elia i laona na fou baita. ");
INSERT INTO llu_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ma fe dani nae Fraede. Ma na dani ni mamalolaa e garangi hafali naa. ");
INSERT INTO llu_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Na geni gi na da lea mai buira a Jesus faasia i Galili, da lea laugo fai nia a Josef. Ma daka rikia na kwaingeia nae, ma daka rikia na aalulana a Jesus i laona. ");
INSERT INTO llu_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Sui daka ooli i fera, ma daka aade aagau ana gwai gi ma na doo moko diana gi uria na uusulana ana nonina a Jesus. Ma ana dani na Sabat daka mamalo ada, iilingia na kwaieresia e haea. ");
INSERT INTO llu_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ma i ofaidani ua ana na Sandei, na geni gi da ngalia na gwai moko diana gi na da aade aagau ana, ma daka lea naa i maana na kwaingeia. ");
INSERT INTO llu_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ma daka rikia kwaingeia na e ifi na ana, sulia na fou langi kasi too na i maana na kwaingeia baa. ");
INSERT INTO llu_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ma gera ka ruu kou ma langi dasi rikia naa na nonina a Jesus na Lord. ");
INSERT INTO llu_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ma si kada da manata ua go ada sulia si doo naa, tee roo ensel na da oofi ana na maku na e sinasina asianaa, daaro ka faatai, daka take i ninimada. ");
INSERT INTO llu_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Na geni nae gi daka mou asianaa, ma daka boururu i aano. Sui na roo wane nae gi daaro ka bae urii fuada, <<Uria taa na molu ka nani uria na wane na e mouri go ana i laona bae fuana na tooa mae gi? ");
INSERT INTO llu_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","I nia langi si too naa i see, nia e mouri lau naa. Molu manatatoona fasi, i nia e faarongo gomolu sui na ana, si kada baa e too ua ana fai gamu i Galili. Nia e bae urii baa, ");
INSERT INTO llu_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","<Tara daka fale nau na Wela nia Iimola gi fuana na wane taꞌa gi, ma daka haungi nau i fafona na airarafolo, sui ana ooluna fe dani, i nau kuka mouri lau.>>> ");
INSERT INTO llu_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Sui na geni nae gi daka manatatoona na baelana. ");
INSERT INTO llu_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ma daka ooli faasia na kwaingeia, ma daka faarongoa ana na aakwala ma tee wane ana fafurongo nia baa gi ma teni tooa eꞌete gi laugo. ");
INSERT INTO llu_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Na geni nae gi na da faarongoa na aposol nia gi, naa ni Mary faasia i Magdala ma ni Joana ma ni Mary na tee nia a James ma teni geni gi lau. ");
INSERT INTO llu_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Sui na aposol gi daka manata hasa na geni nae gi da bae aata go ada, ma ka langi dasi manata mamana go ani gera. ");
INSERT INTO llu_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Sui a Peter e tatae ma ka lalao uria maana kwaingeia. Ma i nia e maakele kou, ma ka langi si rikia go tesi doo. Na maku kwakwaoa gi go ana na e too. Sui nia ka ooli, ma ka kwele asianaa ana sulia si doo naa. ");
INSERT INTO llu_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ana fe dani nae, roo wane ana oote fafurongo nia gi a Jesus, daaro ka lea uria na fera i Emeas. E bobola fai nia tee aakwala kilometer faasia i Jerusalem. ");
INSERT INTO llu_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ma daaro ka faarai adaaro sulia si doo nae gi sui na e fuli. ");
INSERT INTO llu_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ma si kada daaro faarai, a Jesus e lea garangi daaro mai ma ka fali laugo fai daaro. ");
INSERT INTO llu_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Daaro ka riki nia go adaaro, sui daaro langi si aada haitamana go. ");
INSERT INTO llu_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Sui a Jesus ka bae urii fuadaaro, <<Na taa naa moro faarai amoro sulia si kada na moro fali mai ana naa?>> Ma daaro take ngado, ma daaro ka liodila. ");
INSERT INTO llu_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ma tee wane adaaro na hatana a Kleopas, e bae ka urii, <<Nau ku manata taifili oe go na o too i Jerusalem ma oko lalafusia go amu si doo naa gi e fuli sulia fe dani nae gi.>> ");
INSERT INTO llu_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ma a Jesus e ledida ka urii, <<Si doo taa gi?>> Ma daaro oolisia, daaro ka urii, <<Si doo nae gi na da aadea ana a Jesus, na wane baa faasia i Nasaret. Na wane nae, nia na profet, na wane ni baelaa talana a God, sulia a God ma na tooa gi lau da manata sulia na baelana e rigita ma na raolana ka baita asianaa. ");
INSERT INTO llu_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Na fataabu baita gami gi ma na wane initoo gi, da fale nia eeri ka mae, ma gera ka fotoia i fafona na airarafolo. ");
INSERT INTO llu_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ma gemelu melu ka manata amelu hasa i nia naa tara ka faanonilaa na tooa gi i Israel. Ma laugo, na ooluna fe dani naa na i taraꞌena i buira si doo naa. ");
INSERT INTO llu_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ma melu ka kwele asianaa sulia teni geni gi ana figua gemelu, da lea siana na kwaingeia. ");
INSERT INTO llu_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Sui ka langi dasi rikia na nonina. Ma gera da ooli mai, daka haea gera aadasia na ensel gi na da faarongo gera ana i nia e mouri lau. ");
INSERT INTO llu_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ma teni wane gi lau ana figua gemelu da lea laugo siana na kwaingeia nae, ma daka daotoona nia e mamana naa, iilingia na geni nae gi da haea. Haia, ma gera ka langi si rikia a Jesus.>> ");
INSERT INTO llu_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ma a Jesus ka bae urii fuadaaro, <<Moro nue asianaa! Ma na manatalaa moro kasi aliꞌali go uria na manata mamanalaa ana si doo baa gi na Profet gi da haea ua na mai. ");
INSERT INTO llu_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","A Christ ka nonifii fasi, sui kafi ruu ana na baitaa nia.>> ");
INSERT INTO llu_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ma a Jesus ka faatolomai daaro ana si doo baa gi da haea suli nia i laona na Kekedelaa Aabu gi. E hafali ana na kekedelaa nia gi a Moses ma na kekedelaa gera gi na Profet. ");
INSERT INTO llu_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ma si kada daalu dao garangia na fera na daalu lea uria, a Jesus ka mala hasi uria ka tasa ana. ");
INSERT INTO llu_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Sui daaro ka bae luia, daaro ka bae urii, <<O too na amu fai gemere, sulia na hato e kukuru naa ma ka garangi rodo naa.>> Ma nia ka lea na ana fai daaro. ");
INSERT INTO llu_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Si kada nia e gwouru uria fangalaa fai daaro, nia e ngalia fe beredi, ma ka baelafea a God, sui ka niia na beredi nae, ma ka falea fuadaaro. ");
INSERT INTO llu_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Si kada daaro rikia doo nae, daaro aada haitamana, sui nia ka funu laugo ana faasi daaro. ");
INSERT INTO llu_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ma daaro faarai kwailiu fuadaaro, daaro ka urii, <<Si kada baa e bae ana fai goro sulia na tala, ma ka faatolomai nia na Kekedelaa Aabu gi fuagoro, goro eele asianaa.>> ");
INSERT INTO llu_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ma ana si kada nae ua go, daaro tatae, daaro ka ooli lau uria Jerusalem. Ma daaro ka daotoona na aakwala ma tee wane fafurongo baa gi da figu go ada, fai nia teni tooa gi lau. ");
INSERT INTO llu_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ma gera bae urii fuadaaro, <<A Lord e mouri lau mamana naa! Sulia nia e faatai fuana a Simon!>> ");
INSERT INTO llu_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ma daaro ka uunuunu laugo siadaalu sulia si doo baa gi e fuli i sulia na tala, ma sulia si kada daaro aada haitamana ana si kada nia e niia ana fe beredi. ");
INSERT INTO llu_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Si kada roo wane nae gi da uunuunu ua go adaaro fuada, a Jesus e faatai ka take i matangada, ma ka bae urii fuada, <<Si fanualama ka too fai gamu.>> ");
INSERT INTO llu_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ma gera tona ma daka mou asianaa sulia da manata hasa da rikia ta aagalo. ");
INSERT INTO llu_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Sui a Jesus ka bae urii, <<Taa naa aadea molu ka mou? Ma utaa naa molu ka manata hala? ");
INSERT INTO llu_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Aada molu ka rikia roo abagu gi fai nia na roo aegu gi. I nau go ana naa. Mu hamotoona fasi mai na nonigu, eeri muka haitamana, sulia na aagalo langi kasi too ana ogi gi fai nia mariko iilingia na molu rikia nau ku too ana.>> ");
INSERT INTO llu_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Buira nia haea si doo nae gi sui, nia ka faatainia na fuilaa maefuta ana roo abana gi ma na roo aena gi fuada. ");
INSERT INTO llu_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ma gera ka eele asianaa fai nia na kwelelaa. Sui boroi ana, gera si fiitala ua go ada, sulia langi dasi haitama diana ua ana. Ma a Jesus ka bae lau urii fuada, <<Gomolu aalua tesi fanga?>> ");
INSERT INTO llu_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ma gera ka falea si mani iia fuana. ");
INSERT INTO llu_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ma nia ngalia, ma ka ania i naoda. ");
INSERT INTO llu_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Sui nia ka bae lau urii fuada, <<Si doo naa gi doo ku haea ua na mai ana fuagamu si kada ku too ua mai ana fai gamu. Si doo naa gi sui baa da kekede suli nau ana laona kwaieresia Moses gi, ma i laona kekedelaa gera profet gi ma i laona Sam gi, tara ka dao mamana na mai.>> ");
INSERT INTO llu_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Sui a Jesus ka adomi gera eeri daka haitamana na Kekedelaa Aabu. ");
INSERT INTO llu_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Nia ka bae urii fuada, <<Gera kedea suli nau a Christ tara kuka nonifii ma ana ooluna fe dani nau ku tatae lau faasia na maea. ");
INSERT INTO llu_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ma e ita mai Jerusalem, ma ka dao ana fera gi sui, muka bae sulia na oolitai manatalaa ma na manata lukelaa na doo aade taꞌalaa gi ana na hatagu. ");
INSERT INTO llu_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ma ni gamu naa mu faatalo sulia si doo naa gi. ");
INSERT INTO llu_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ma tara i nau i talagu, tara kuka falea fuagamu si doo na Maa nau e bae aalualu ana. Ma tara muka kwaimaasi i Jerusalem lelea na rigitaa faasia i langi ka sifo mai faafi gamu.>> ");
INSERT INTO llu_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Sui nia ka talaida naa faasia i laona fera baita nae, lelea daka dao ana fera i Betani, ma nia ka uua na abana i langi, ma ka faadiana gera. ");
INSERT INTO llu_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ma si kada nia e faadiana gera ua, nia ka tafusi gera, ma ka raa na ana fui langi. ");
INSERT INTO llu_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ma daka fooasi nia, sui daka ooli na ada i Jerusalem fai nia na eelelaa baita. ");
INSERT INTO llu_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ma ana si kada oro gi go gera too go ada i laona na Beu Aabu a God, uria na baelafelana a God.");
INSERT INTO llu_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ita ua na mai i nao ana na haungailana na molaagali, si Baea e too naa, ma nia ka too na mai fai nia a God. Ma na Baea naa, nia naa a God. ");
INSERT INTO llu_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ana hafalilana, na Baea naa e too na mai fai nia a God. ");
INSERT INTO llu_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ma ani nia na a God e haungainia na doo gi sui. Ma e langi tee si doo ana doo naa gi sui a God e haungainia ka langi ani nia. ");
INSERT INTO llu_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Mouria e ita mai faasia na Baea naa. Ma na mouria naa na e iilingia na kwesu fuana tooa gi. ");
INSERT INTO llu_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ma na kwesu naa e tala i laona na rorodoa, ma na rorodoa ka langi si faamaea. ");
INSERT INTO llu_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","A God e falea mai tee wane, na hatana a John Siuabu, ");
INSERT INTO llu_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ka lea mai uria na faarongolana na tooa gi ana na kwesu naa. Nia e lea mai ka faarongo gera ana, hai so na tooa gi sui daka rongoa ma daka manata mamana. ");
INSERT INTO llu_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ma a John i talana langi lau na kwesu, nia e lea mai hai ka faarongo ana na kwesu nae. ");
INSERT INTO llu_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Sui, na kwesu mamana nae kafi lea mai i laona molaagali ma ka talafia na tooa gi sui. ");
INSERT INTO llu_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ma si Baea naa e too naa i laona molaagali. A God e haungainia na molaagali naa ani nia, ma boroi ana, na tooa gi gera ka langi si aada haitamana go. ");
INSERT INTO llu_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Nia e dao mai i fera nia, sui na tooa nia gi langi dasi gonitai nia go. ");
INSERT INTO llu_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Haia, teni tooa gi daka gonitai nia ma daka manata mamana ani nia, ma nia ka falea na mamanaa fuada uria haulaa ana na wela nia a God gi. ");
INSERT INTO llu_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Gera dasi hau ana wela nia gi a God ana futalaa ana ta maa naa i laona molaagali, sulia a God ana i talana naa nia na Maa gera. ");
INSERT INTO llu_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Si Baea e hau ana iimola, ma ka too siaga. Nia e rakediana asianaa fuana tooa gi, ma na baelana ka mamana teefou. Gami rikia naa na initooa nia na e too ana sulia nia na wela muutaia a God na Maa. ");
INSERT INTO llu_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","A John Siuabu e faarongo ana suli nia, si kada baa e bae baita ka urii, <<Nia naa na wane baa ku bae sulia baa ku bae urii, <Na wane na e lea mai i burigu, nia e baita ka tasa liufi nau, sulia i nia e too ua na mai i nao, suifetei kufi futa.>>> ");
INSERT INTO llu_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ma sulia na dianalana baita, i nia ka falea na doo diana gi fuaga sui sulia dani. ");
INSERT INTO llu_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","A God e falea laugo na kwaieresia nia gi fuaga ana a Moses. Sui ka falea mai na dianalaa ma na mamanalaa ana a Jesus Christ. ");
INSERT INTO llu_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","E langi ta wane kasi rikia a God. Tee taifilia go na Wela nia a God, na e bobola fai nia a God na Maa ma ka too fai nia, nia naa nia ka faatainia a God fuaga. ");
INSERT INTO llu_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Na wane baita gi ana tooa Jiu gi i Jerusalem, gera ka oodua na fataabu gi ma na wane kwaiꞌadomi gera fataabu gi eeri daka ledia a John urii, <<Ni oe ni tei?>> ");
INSERT INTO llu_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ma a John e oolisida folaa ka urii, <<I nau langi lau na Christ, na wane baa a God e filia uria aaofialaa.>> ");
INSERT INTO llu_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Sui gera ka ledia lau urii, <<Haia, ma ni oe ni tei mone ana naa? Oe a Elaeja?>> Ma i nia e oolisida lau ka urii, <<I nau e langi.>> Ma gera ledia lau daka urii, <<Haia, ni oe na profet, na gami maasia?>> Ma a John e oolisida ka urii, <<E langi.>> ");
INSERT INTO llu_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ma gera ka ledi isi lau ani nia daka urii, <<Haia, urinae ni oe ni tei ana naa? O haea mai tesi doo fuamelu eeri melu ka faarongoa ana na wane gi na da oodu gemelu mai. Tesi taa na oko haea mai suli oe i talamu?>> ");
INSERT INTO llu_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ma a John ka oolisida ana baelaa baa gi a profet Aesea e kedea ka urii, <<I nau na wane baa e rii i laona na aanogwou ka urii, <A Lord e dao na mai! Muka olosia na tala fuana.>>> ");
INSERT INTO llu_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ma na wane naa gi faasia na Farisi gi, gera ledi nia lau daka urii, ");
INSERT INTO llu_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","<<Ma uria taa na oko siuabua na tooa, lea so ni oe e langi lau na Christ, langi a Elaeja, ma langi na profet baa?>> ");
INSERT INTO llu_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ma a John e oolisida ka urii, <<I nau ku siuabu go agu ana na kafo. Haia, ma tee wane na molu lalafusia e take go ana i matanga molu. ");
INSERT INTO llu_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","I nia naa na wane na e lea mai i burigu, sui taa kusi faorana uria na lukelana na tae silipa nia gi.>> ");
INSERT INTO llu_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ma si doo naa gi sui e fuli i Betani na fera i bali taelana hato ana kafo i Jodan, si gula baa a John e siuabu ana. ");
INSERT INTO llu_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ana fe dani i buri, a John e rikia a Jesus e lea mai siana, ma ka haea fuana tooa gi, <<Muka rikia, i nia naa na wane na e iilingia na gale sipsip ni kwaisuusilaa nia a God, na e lafua na aade taꞌalaa gera tooa gi i laona na molaagali. ");
INSERT INTO llu_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","I nia naa na wane baa nau ku bae sulia ana si kada baa ku bae urii, <Tee wane tara ka lea mai i burigu. I nia e baita ka tasa liufi nau, sulia i nia e too ua na mai i nao suifetei nau kufi futa.> ");
INSERT INTO llu_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","I nao mai, nau langi kusi aada haitamana ni tei naa, ma boroi ana nau ku lea mai ma kuka siuabu ana na kafo eeri na tooa i Israel daka haitamana.>> ");
INSERT INTO llu_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ma a John ka bae lau urii, <<I nau ku rikia na Aanoedoo Aabu e sifo mai i langi iilingia fe bola, ma ka oo i fafona. ");
INSERT INTO llu_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","I nao mai, nau langi kusi aada haitamana ua. Sui a God na e fale nau mai hai kuka siuabu ana na kafo, nia ka bae urii fuagu, <Ni oe tara oko rikia na Aanoedoo Aabu ka sifo mai ma ka oo i fafona tee wane. I nia naa na wane nae tara ka siuabu ana na Aanoedoo Aabu.>>> ");
INSERT INTO llu_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ma a John ka bae lau urii, <<I nau ku rikia naa, ma kuka haea fuagamu, i nia naa na Wela nia a God.>> ");
INSERT INTO llu_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ma ana tee fe dani lau i buri, a John e take laugo i seenae fai nia na roo wane ana fafurongo nia gi. ");
INSERT INTO llu_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ma a Jesus e liu ana. Si kada a John e rikia, nia ka bae urii, <<Nia naa na Gale Sipsip nia a God.>> ");
INSERT INTO llu_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ma na roo wane fafurongo nia gi da rongoa si doo nae, ma daaro ka lea na adaaro sulia a Jesus. ");
INSERT INTO llu_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ma a Jesus e aabulo, ma ka riki daaro daaro lea suli nia, ma nia ka ledi daaro ka urii, <<Na taa naa moro nani uria?>> Ma daaro oolisia daaro ka urii, <<Rabae ae, oe o too i fai?>> (Na malutana Rabae <<na wane faatolomai>>.) ");
INSERT INTO llu_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ma i nia e oolisia ka urii, <<Moro lea mai, eeri moro ka rikia.>> Ma daaro ka lea fai nia, ma daaro ka rikia si gula na e too ana. Ma daaro ka too fai nia sulia fe hato nae. Ma si kade hato nae e bobola na fai nia i haulafia. ");
INSERT INTO llu_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ma tee wane adaaro na a Andrew, na aua nia a Simon Peter. ");
INSERT INTO llu_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ma a Andrew kafi lea ma ka daotoona a Simon na haasina, ma ka faarongo nia ka urii, <<I gemere mere daotoona na Mesaea.>> Na malutana si baea naa na <<Christ>>, na wane baa a God e filia uria aaofialaa. ");
INSERT INTO llu_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Sui i nia ka talaia a Simon siana a Jesus. Ma a Jesus ka bubungia, ma ka bae urii, <<I oe a Simon, na wela nia a John. I nau ku alangi oe ana a Keifas.>> (Na hata nae e bobola laugo ana fai nia a Peter, ma na malutana <<na fou>>.) ");
INSERT INTO llu_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Sui ana ruana fe dani, Jesus ka manata uria lealaa uria lolofaa Galili, ma nia ka daotoona a Filip, ma ka bae urii fuana, <<O lea mai fai nau.>> ");
INSERT INTO llu_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip nia na wane faasia Betsaeda maefera Andrew fai nia Peter. ");
INSERT INTO llu_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Haia, a Filip e daotoona Nataniel, ma ka faarongo nia ka urii, <<Gemelu daotoona wane baa a Moses e kede sulia laona kwaieresia gi ma na profet gi laugo baa gera kede sulia. Nia a Jesus na wela a Josef faasia i Nasaret.>> ");
INSERT INTO llu_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ma a Nataniel ka bae urii, <<Oe o manata tesi doo diana ka lea mai faasia i Nasaret?>> Ma Filip e oolisia ka bae urii fuana, <<Lea mai oko tala rikia amu.>> ");
INSERT INTO llu_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Si kada Jesus e rikia Nataniel e lea mai siana, nia ka bae sulia ka urii, <<Na wane naa nia bobola asianaa na fuana gera ka alangi nia ana wane Jiu mamana, sulia e langi ta sugelaa ani nia!>> ");
INSERT INTO llu_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataniel e oolisia ka urii, <<Oe o haitamagu utaa?>> Ma a Jesus e oolisia ka bae urii fuana, <<Nau ku riki oe i aena ai figi suifetei a Filip kafi soe oe.>> ");
INSERT INTO llu_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ma si kada Nataniel e rongoa si doo naa, nia ka bae urii, <<Faatolomai ae, ni oe naa na Wela a God! Oe na aaofia gami tooa Jiu!>> ");
INSERT INTO llu_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesus ka urii fuana, <<Oe ofi manata mamana go nae sulia baa nau ku haea nau ku riki oe i aena ai figi? Haia, nau ku haea fuamu, tara oe oko fi rikia si doo baita gi liufia si doo naa.>> ");
INSERT INTO llu_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Sui Jesus ka bae lau fuada urii, <<Doo mamana nau haea fuagamu, tara muka rikia i langi ka ifi ma tara muka rikia laugo na ensel a God gi da raa aala fui langi ma gera ka sifo mai fafogu, i nau na Wela nia Iimola gi.>> ");
INSERT INTO llu_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Buira roo maedani sui, tee baraa ka liu ana tee maefera na hatana Kena i laona lolofaa i Galili. Ma ni tee nia a Jesus e too laugo i seenae ana si kada naa. ");
INSERT INTO llu_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ma gera ka soea laugo mai a Jesus fai nia na oote fafurongo nia gi uria na baraa nae. ");
INSERT INTO llu_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ma si kada tooa da gwou ma na waen gera ka sui, ni tee nia a Jesus ka bae urii fuana, <<Gera langi dasi too na ana ta waen.>> ");
INSERT INTO llu_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ma a Jesus e oolisia ka urii, <<Tee ae, langi osi oodu nau uria aadelana tesi doo. Sulia si kada nau e langi ua.>> ");
INSERT INTO llu_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ma ni tee nia a Jesus ka bae urii fuana na wane ni rao gi, <<Molu iili sulia tesi doo na nia e haea fuamolu.>> ");
INSERT INTO llu_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ma na oono botele baita gi ni ngali kafolaa da haungainia ana fou e too i seenae, uria na sau abalaa fuana na tooa gi sulia na malutaa gera Jiu. ");
INSERT INTO llu_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ma a Jesus ka bae urii fuana na wane ni rao gi, <<Molu oongia na botele gi ana na kafo.>> Ma gera ka oongida lea ka fungu. ");
INSERT INTO llu_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Sui nia ka bae urii fuada, <<Molu taofia si kafo, ma molu ka falea fuana na wane baita ana na fangaa.>> Ma gera ka falea fuana, ");
INSERT INTO llu_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ma i nia ka gwoutoona na kafo nae, na ka hau na ana na waen. Ma nia ka langi si haitamana na waen naa e lea mai faasia i fai. Haia, na wane ni rao gi na da taofia mai na kafo nae na da haitamana sui. Sui na wane baita na ka soea mai na fungao nae. ");
INSERT INTO llu_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Ma ka bae urii fuana, <<Na tooa gi sui da falea na waen diana i nao, ma i buira na tooa gi da gwou baita sui, dafi falea na waen aai na kasi diana asia go. Haia, oe o taingainia amu na waen diana asianaa lea ka dao na ana si kada naa!>> ");
INSERT INTO llu_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Nia naa na eetana si doo kwaibalatana a Jesus. Nia e iilia i Galili, i laona na fera i Kena. Seenae nia ka faatainia na initooa nia, ma na oote fafurongo nia gi daka manata mamana ana. ");
INSERT INTO llu_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ma i buri, a Jesus fai nia ni tee nia ma na haasina gi ma na oote fafurongo nia gi, daka lea uria na fera i Kapaneam. Ma gera too i seenae sulia aange fe dani. ");
INSERT INTO llu_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Haia, ma garangia naa na Fangaa ana Lofoagaua gera na tooa i Jiu gi, ma a Jesus ka lea uria na fera baita i Jerusalem. ");
INSERT INTO llu_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ma i laona labata nae ana Beu Aabu nia a God, nia ka rikia na wane gi da faafoli ana na bulumakau gi ma na sipsip gi ma na bola gi uria kwaisuusilaa. Ma nia ka rikia laugo na wane gi gera tatalalaa ana na malefo da gwouru ada i ninimana na tafe gera gi. ");
INSERT INTO llu_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ma nia ka haungainia doo ni kwaelaa ana kwale oko gi, ma ka taria na bulumakau gi ma na sipsip gi ma na doo gi sui faasia laona labata ana Beu Aabu. Ma ka faaꞌasiaa na tafe gera na wane gi ni tatalalaa ana na malefo ma ka tagalangainia na malefo gera gi. ");
INSERT INTO llu_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ma nia ka kwae taria na wane gi na da faafoli ana na bola gi ka urii, <<Molu ngalia na doo nae gi i maa! Langi molu si haungainia na Beu a Maa nau ana uusia!>> ");
INSERT INTO llu_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ma na oote fafurongo nia gi daka manatatoona na Kekedelaa Aabu baa e bae urii, <<God ae, na rakedianaa nau fuana na Beu oe e iilingia na eere e ago i laona mangogu.>> ");
INSERT INTO llu_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Sui na wane baita gera Jiu gi da ledia a Jesus daka urii, <<Tesi doo kwaibalatana taa na tara o iilia eeri ka faamamana ni oe o too ana mamanaa uria iililaa na doo naa?>> ");
INSERT INTO llu_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ma a Jesus e oolisida ka urii, <<Lea so muka oogosia na Beu Aabu naa, tara i nau kuka faatakea lau i laona oolu fe dani.>> ");
INSERT INTO llu_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ma gera ledi nia lau daka urii, <<I oe oko faatakea lau i laona oolu fe dani? E ngalia fai aakwala ma oono fe ngali na da tolea ana na Beu Aabu naa a God!>> ");
INSERT INTO llu_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Haia, ma na Beu Aabu na a Jesus e bae sulia naa na nonina ana. ");
INSERT INTO llu_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ma ana si kada a God e tatae nia ana faasia na maea, na oote fafurongo nia gi dafi manatatoona nia e haea si doo naa, ma dafi manata mamana ana na Kekedelaa Aabu ma na doo na a Jesus e haea. ");
INSERT INTO llu_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ma si kada a Jesus e too i Jerusalem ana na Fangaa ana Lofoagaua, na tooa oro gi da manata mamana ani nia sulia gera rikia na doo kwaibalatana gi na nia e iilida. ");
INSERT INTO llu_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Sui ka urii boro ana, a Jesus langi kasi fiitoo go ani gera, sulia nia e haitamana teefou ani gera sui. ");
INSERT INTO llu_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Sui boroi ana ta wane langi kasi faarongo nia ana tesi doo sulia na tooa, nia haitamana sui naa na doo gi teefou laona manatalada. ");
INSERT INTO llu_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","2","Ana tesi kada, tee wane baita gera Jiu gi e lea mai siana Jesus. Na wane nae hatana a Nikodimas, nia ta wane ana Farisi gi. Nia lea mai siana Jesus laona rodo, ka bae urii fuana, <<Faatolomai ae, gami haitamana oe na wane faatolomai na a God e oodua mai. Sulia na doo kwaibalatana gi na o aadeda, afetai ta wane ka aadea lea so God ka langi si too fai nia. ");
INSERT INTO llu_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","A Jesus ka oolisia bae urii fuana, <<Doo mamana nau ku haea fuamu, afetai so ta wane ka rikia Initooa God lea nia langi kasi futa faalu lau.>> ");
INSERT INTO llu_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ma Nikodimas e soeledia Jesus ka urii, <<Tara na wane e baita na ka futa lau mai utaa? Afetai asianaa fuana wane naa ka ooli lau laona rakena ni tee nia, sui kafi futa lau mai!>> ");
INSERT INTO llu_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesus ka bae urii fuana, <<Doo mamana nau ku haea fuamu. Afetai asianaa fuana ta wane ka ruu laona Initooa a God lea nia langi kasi futa ana kafo ma na Aanoedoo Aabu. ");
INSERT INTO llu_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Kada wane e futa ana na maa fai nia ni tee, nia hau ana wane. Haia, ma ni tei na ka futa ana Aanoedoo a God, nia ka aalua wane faalu. ");
INSERT INTO llu_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Langi osi kwele sulia nau ku haea fuamu gamu futa faalu lau. ");
INSERT INTO llu_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Na Aanoedoo Aabu e iilingia na ooru. Sulia sui boroi oko rongoa na ooru, langi osi rikia go e lea mai faasia i fai langi e lea uria i fai. Ma na Aanoedoo Aabu laugo, langi osi rikia e oolisi utaa ana wane fuana ka aalua na wane faalu.>> ");
INSERT INTO llu_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodimas ka soeledia lau ka urii, <<Si doo naa gi ka mamana utaa?>> ");
INSERT INTO llu_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesus e oolisia ka urii fuana, <<Oe naa, oe na faatolomai baita gera Jiu gi naa. Ma utaa naa langi osi haitamana go na malutana si doo naa gi? ");
INSERT INTO llu_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Doo mamana nau ku haea fuamu, gami faarongo ana si doo gi mi haitamana ma mika rikia. Ma langi ta wane ani gamu kasi manata mamana go. ");
INSERT INTO llu_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Haia, ma lea langi musi manata mamana ana na doo gi ku faarongo gamu ana molaagali naa, tara gamu kafi manata mamana utaa ani nau lea ku faarongo gamu ana na doo gi mai langi? ");
INSERT INTO llu_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ma i nau, na Wela nia Iimola gi go ana naa ku haitamana na taa gi na gera aadeda mai langi, sulia nau ku sifo mai faasia i langi. Ma ka langi naa lau ta wane na e lea i langi.>> ");
INSERT INTO llu_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Iilingia ana si kada baa i nao, a Moses e haungainia na loi ni kai aaeani baa i laona na aanogwou ma ka uua i langi i gwouna na ai baa. Ma ka urinae laugo, gera ka uua na Wela nia Iimola gi i langi, ");
INSERT INTO llu_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","eeri ni tei gera na da manata mamana ani nia, daka ngalia na mouria firi. ");
INSERT INTO llu_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Sulia a God e rakediana asianaa ana na tooa gi sui i laona molaagali, nia naa ka falea mai tee fe Wela muutaia nia, eeri ni tei gera na da manata mamana ani nia, langi daka si mae, ma tara gera ka ngalia mouria firi. ");
INSERT INTO llu_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Sulia a God langi si falea mai na Wela nia i laona molaagali uria na ketolaa na tooa gi, ma nia e falea mai uria na faamourilada taari. ");
INSERT INTO llu_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ma so ni tei na e manata mamana ana na Wela nia, a God kasi keto nia. Ma so ni tei na e langi kasi manata mamana ani nia, a God e keto nia sui naa, sulia i nia kasi manata mamana ana tee fe Wela muutaia nia. ");
INSERT INTO llu_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Na keketolaa e urii, na Wane na e iilingia na kwesu e dao na mai i laona na molaagali, sui taa na tooa gi daka rakediana ada ana na rorodoa faasia na kwesu, sulia na aabulolada e taꞌa. ");
INSERT INTO llu_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Sulia ni tei na aabulolana e taꞌa, nia ka oote nia ana kwesu, ma nia ka langi si dooria lealaa mai fuana kwesu, sulia langi kasi dooria aabulo taꞌalaa nia gi ka faatai. ");
INSERT INTO llu_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ma so ni tei na e iilia si doo na e oꞌolo, nia ka lea mai fuana kwesu, eeri na kwesu ka faatainia na doo gi na nia iilida e lea sulia a God. ");
INSERT INTO llu_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ma i buira, Jesus fai nia oote fafurongo nia gi da lea fui Judea, ma gera ka too i seenae. Ma gera ka siuabua na tooa gi seenae. ");
INSERT INTO llu_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ma ana si kada nae, a John laugo e siuabua na tooa ana maefera i Aenon garangia Salim. John e siuabuda seenae sulia si gula na kafo e oro ana. Haia, ma tooa oro gi laugo daka lea siana uria siuabulaa. ");
INSERT INTO llu_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Ana si kada nae, langi gera kasi aalua ua John laona beu ni kanilaa.) ");
INSERT INTO llu_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Haia, ana si kada nae, teni wane ana oote fafurongo John gi gera oolisusuu fai nia tee wane ani gera Jiu gi sulia na maluta gera Jiu gi sulia na saufilana nonida eeri ka faalu naona God. ");
INSERT INTO llu_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Haia, oote fafurongoa John gi gera lea siana John, ma gera ka soeledia daka urii, <<Faatolomai ae, oe haitamana wane baa na e take fai oe bali loko ana kafo Jodan, na oko haea doo diana gi suli nia? Haia, si kada nae, nia e siuabua na tooa, ma na tooa oro gi daka lea sui naa siana!>> ");
INSERT INTO llu_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ma a John e oolisida ka urii, <<Na wane e too ana go ana si taa na a God e falea fuana. ");
INSERT INTO llu_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Gamu mu rongoa sui naa baa nau ku haea fuagamu, nau langi lau na Christ na wane aadafililana a God naa. Nau wane ku lea mai nao uria ainitalolaa ana faarongolaa suli nia. ");
INSERT INTO llu_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","A Christ e iilingia na wane baa e aarai faalu. Ma ni nau ku iilingia na ruana nia wane aarai faalu ana baraa. Ma na oote fafurongo nia gi, gera iilingia na geni baa na wane na e aadea. Nia naa, na geni nae tara nia too fai nia na aarai nia. Ma na ruana nia na wane aarai faalu nae, nia ka eele asianaa si kada na wane aarai faalu e dao ana baraa nia. Ma ka urinae laugo ani nau. Nau ku eele asianaa si kada nae sulia Jesus e too na ana fafurongo oro. ");
INSERT INTO llu_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","A Christ, tara gera ka faabaitaa. Ma ni nau, tara gera ka faatoꞌou nau lau.>> ");
INSERT INTO llu_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Haia, ma na wane na e lea mai faasia langi, nia e baita ka tasa liufia wane gi sui. Na wane ana molaagali naa, nia na wane fuana molaagali naa. Ma nia ka haitamana baelaa sulia dongana molaagali naa. Haia, ma na wane na e lea mai faasia i langi, nia baita ka tasa liufia wane gi sui. ");
INSERT INTO llu_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Nia ka faarai folaa sulia taa na nia e rikia ma ka rongoa faasia i langi. Sui ka urinae boroi ana, langi ta wane kasi dooria go manata mamanalaa ana si taa gi na nia e haeda. ");
INSERT INTO llu_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Haia, ma na wane na e manata mamana ana taa naa na nia e haea, na wane naa nia ka faatainia taa na God e haea nia mamana. ");
INSERT INTO llu_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Haia, ma na wane na God e oodua mai faasia langi, nia ka ainitalongainia baelana God, sulia God e falea teefou na Aanoedoo Aabu nia eeri ka adomia. ");
INSERT INTO llu_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Na wane naa nia na Wela nia God. Ma a God ka aalu nia ka baita fuana na doo gi sui, sulia nia e rakediana asianaa naa fuana. ");
INSERT INTO llu_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ma so ni tei na e manata mamana ana na Wela naa, nia ka too ana mouria firi. Ma ni tei na langi kasi manata mamana ana Wela naa, nia langi kasi ngalia mouria firi. Tesi doo lau tara a God ka kwakwaea. ");
INSERT INTO llu_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Haia, a Jesus fai nia oote fafurongo nia gi gera ka lea faasia i Judea, ma gera ka lea fui Galili. Gera lea, sulia Jesus e haitamana na Farisi gi gera rongoa hasa nia aadea wane oro gi asianaa gera lea suli nia liufia a John Siuabu, ma ka tasa dongaa fai nia siuabulada. Sui, a Jesus langi kasi siuabu go ta iimola. Na fafurongo nia gi ana na da iilia. ");
INSERT INTO llu_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ma si kada gera lea kou fui Galili, gera ka liufolo ana lolofaa i Samaria. ");
INSERT INTO llu_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ma gera ka dao ana tee maefera na hatana Saeka i laona na lolofaa i Samaria, na e too garangia na gano na a Jakob e falea fuana a Josef na wela nia i nao ua mai. ");
INSERT INTO llu_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ma na mae kafo elilana a Jakob e too i seenae. Ma a Jesus e noni daola ana na leaa, ma nia ka gwouru ana ninimana na kafo elilana nae. Ma si kada nae, nia e bobola naa fai nia na initoona na hato. ");
INSERT INTO llu_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Haia, ma na oote fafurongo nia gi gera ka lea i fera nae uria na foli fangalaa. Ma tee geni faasia i Samaria ka lea mai uria na tafo kafolaa. Ma a Jesus ka bae urii fuana, <<O falea mai si kafo, ku gwou fasi.>> ");
INSERT INTO llu_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ma na geni nae e oolisia ka urii, <<I oe na wane i Jiu, ma ni nau na aai i Samaria. Utaa naa oko gani nau uria gwoulaa?>> Nia e bae urinae sulia na tooa i Jiu gi langi dasi kwaimaani fai nia na tooa i Samaria gi. ");
INSERT INTO llu_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ma a Jesus e oolisia ka urii, <<Lea so oko haitamana na taa na a God e falea, ma oko haitamana ni tei na e gani oe uria si kafo, tara oko gani nau amu ma nau kuka falea na kafo ana mouria fuamu.>> ");
INSERT INTO llu_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ma na geni nae ka bae urii fuana, <<Aarai ae, oe e langi amu ta doo ni taofilana kafo, ma na elilana laugo ka oolo asianaa. Tara oko daotoona na kafo naa ana mouria i fai? ");
INSERT INTO llu_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Na koo gia a Jakob na e falea na mae kafo elilana naa fuaga. Ma i nia fai nia na wela nia gi ma na doo fai ae nia gi, gera gwou faasia na kafo elilana naa. Haia, ma ni oe langi osi manata go hasa oe o baita ka liufia a Jakob, langi utaa?>> ");
INSERT INTO llu_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ma a Jesus ka bae urii, <<Ni tei na e gwoufia na kafo naa, nia haitamana ka maeligwou laugo ana. ");
INSERT INTO llu_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ma so ni tei na e gwoufia na kafo na nau ku falea, e afetai ka maeligwou lau. Ma na kafo naa i nau ku falea fuana ka hau ana na kafo busuna na e falea na mouria firi fuana.>> ");
INSERT INTO llu_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ma na geni naa ka bae urii, <<Wane baita ae, o falea na kafo nae fuagu, hai ka langi kusi maeligwou lau, ma e langi kusi lea lau mai i see uria na ngali kafolaa.>> ");
INSERT INTO llu_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ma a Jesus ka bae urii fuana, <<O lea, oko soea mai na aarai oe, ma moro ka ooli mai i see.>> ");
INSERT INTO llu_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ma na geni naa e oolisia ka urii, <<Nau langi kusi too ana ta aarai.>> A Jesus ka bae urii, <<Oe o bae mamana ana si kada o haea langi osi too ana ta aarai. ");
INSERT INTO llu_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Sulia ni oe o toowane ana na lima wane, ma na wane aai na o too fai nia si kada nae, nia langi lau na aarai oe mamana. Na doo mamana naa o haea fuagu.>> ");
INSERT INTO llu_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ma na geni naa e oolisia ka urii, <<Wane baita ae, nau ku manata i oe na profet. ");
INSERT INTO llu_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Haia, na koo gami gi i Samaria da fooasia a God i gwouna fe tolo naa. Ma ni gamu na tooa i Jiu gi muka haea si gula uria na fooasilana a God naa i Jerusalem.>> ");
INSERT INTO llu_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ma a Jesus ka bae fuana ka urii, <<Inite ae, o manata mamana ani nau, tara si kada ka dao mai fuana na tooa gi langi dasi fooasia na Maa i gwouna fe tolo naa ma langi so i Jerusalem. ");
INSERT INTO llu_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","I gamu na tooa i Samaria gi mu lalafusia go agamu ni tei na mu fooasia. Ma ni gami na tooa i Jiu gi mi haitamana ni tei na mi fooasia, sulia na mouria e lea mai faasi gami. ");
INSERT INTO llu_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ma si kada ka dao mai ma e dao sui naa, hai na tooa na da fooa mamana daka fooasia na Maa ana na aanoedoo ma ana na mamanalaa. Sulia nia e fooalaa na a Maa e dooria. ");
INSERT INTO llu_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","A God, nia na Aanoedoo, ma ni tei gera na da fooa fuana, daka fooa ana na mangoda, ma daka fooa ana mamanalaa.>> ");
INSERT INTO llu_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ma na geni nae ka bae urii fuana, <<I nau ku haitamana na wane na a God e filia na gera alangia ana a Christ, tara ka dao mai. Ma si kada nia ka dao mai ana, tara ka faarongo gia ana na doo gi sui.>> ");
INSERT INTO llu_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","A Jesus e oolisia ka urii, <<I nau naa i nia.>> ");
INSERT INTO llu_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ma ana si kada nae, na oote fafurongo nia gi gera ka dao na mai, ma gera ka kwele asianaa sulia gera rikia a Jesus e bae ana fai nia na geni naa. Sui, ta wane adaalu e langi kasi ledia go na geni naa, <<Na taa na o dooria?>>, ma langi ka ledia a Jesus, <<Uria taa na oko bae fai nia na geni naa?>> ");
INSERT INTO llu_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ma na geni baa ka lugasia na doo nia ni ngali kafolaa, ma ka ooli i fera, ma ka bae urii fuana na tooa gi i seenaa, ");
INSERT INTO llu_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","<<Molu lea mai, eeri molu ka rikia amolu tee wane na e faarongo nau ana na doo gi sui na nau ku iilida. Nia boro wane aadafililana baa a God oto?>> ");
INSERT INTO llu_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ma gera tafusia na maefera baa, ma daka lea mai siana a Jesus. ");
INSERT INTO llu_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ma ana si kada nae, na oote fafurongo nia gi da soea a Jesus daka urii, <<Wane faatolomai ae, o ania amu tesi fanga!>> ");
INSERT INTO llu_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ma a Jesus e oolisida ka urii, <<I nau ku too ana na fanga nau ni anilana na mu lalafusia.>> ");
INSERT INTO llu_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ma na oote fafurongo gi daka ledi gera kwailiu daka urii, <<Boro ta wane e ngali fanga mai fuana oto?>> ");
INSERT INTO llu_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ma a Jesus ka bae urii fuada, <<Na fanga nau naa na roosulilana na baelana a God naa e fale nau mai, ma na faasuilana na raoa gi na e falea fuagu uria iililana. ");
INSERT INTO llu_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Haia, ma ni gamu mu too ana na tesi tarafulalaa baa e urii, <Fai fe sinali lau, suifetei na uuni soogonilaa.> Haia, ma ni nau ku haea fuagamu, muka aada fasi ana na tooa gi na da lea mai. Gera ka iilingia na raoa baita i hara, na e moua naa ma ka kwaimaasi naa uria na soogonilana. ");
INSERT INTO llu_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ma na wane naa ka soogonia na aaludooa, da folia naa. Ma nia ka oogua naa na aaludooa uria na mouria firi, eeri na wane na e fasi ma na wane na e soogoni doo, daaro ka eele oofu. ");
INSERT INTO llu_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ma si tarafulalaa e mamana ka urii, <Tee wane e fasi, ma ta wane aai ka soogoni.> ");
INSERT INTO llu_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","I nau ku oodu gamu uria na soogonilana na doo gi laona raoa na e langi musi rao ana. Sulia teni wane aai gi ana na da rao ana, ma ni gamu ana muka ngalia dianalana raolada.>> ");
INSERT INTO llu_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ma na tooa oro gi i laona na fera naa ana na lolofaa naa i Samaria daka manata mamana ana a Jesus, sulia na geni naa e haea, <<I nia e faarongo nau ana si doo gi sui na ku iilida.>> ");
INSERT INTO llu_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ma si kada gera ka lea mai siana a Jesus, daka gania hai ka too lau siada. Ma a Jesus ka too lau i seenae sulia roo maedani. ");
INSERT INTO llu_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ma na tooa oro gi lau daka manata mamana sulia na faarongolaa nia gi a Jesus. ");
INSERT INTO llu_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ma gera ka haea fuana na geni baa daka urii, <<Haia, gami mi manata mamana naa nae, langi lau sulia na doo baa gi o haeda fuagami, ma sulia gami ana i talagami mi rongoa na baelana laugo. Ma mika haitamana i nia mamana naa na Faamouri mamana ana na tooa gi sui.>> ");
INSERT INTO llu_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Buira Jesus fai nia oote fafurongo nia gi gera too ana maefera naa sulia roo maedani sui, gera ka lea fui Galili. ");
INSERT INTO llu_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jesus i talana ana na e bae urii, <<Na tooa faasia fera nia na profet, langi gera kasi manata baita go ani nia.>> ");
INSERT INTO llu_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ma si kada a Jesus e ooli mai fui Galili, na tooa gi seenae da gonitai nia, sulia gera ka lea laugo i Jerusalem ana Fangaa ana Lofoagaua, ma daka rikia na doo gi a Jesus e aadeda i seenae. ");
INSERT INTO llu_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Sui, Jesus ka ooli lau fuana i Kena na fera i Galili, na gula baa nia bulasia kafo ka hau ana waen. Ma ana si kada nia too ana i seenae, na alakwa nia tee wane initoo faasia i Kapaneam e matai baita asianaa. ");
INSERT INTO llu_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ma ana si kada wane naa e rongoa Jesus e lea naa faasia i Judea ma ka ooli lau mai fui Galili, nia ka lea mai uria rikilana Jesus eeri ka gani nia uria lealaa fai nia fui Kapaneam uria guralana alakwa nia, sulia e matai ka garangi mae. ");
INSERT INTO llu_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Buira wane na e bae urinae sui, Jesus ka bae urii fuana, <<Gamu dooria go agamu rikilana doo kwaibalatana gi uria kwelelaa ana gi suifetei gamu kafi manata mamana ani nau.>> ");
INSERT INTO llu_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Sui boroi ana Jesus ka bae urinae, na wane naa ka tasa dongaa go ana uria baelaa urii fuana Jesus, <<Wane naonao ae, o lea fasi mai fai nau, aata na wela nau ka mae.>> ");
INSERT INTO llu_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesus ka bae urii fuana, <<O ooli amu, na alakwa oe e akwaa naa.>> Ma na wane naa ka lea, sulia nia e manata mamana ana na baelana Jesus. ");
INSERT INTO llu_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ma si kada nia e lea ua kou ana sulia tala, na wane raoa nia gi gera ka lalao mai uria faarongolanalaa, ma gera ka bae urii, <<Wane naonao ae, na wela oe baa, nia akwaa naa, ma ka mouri naa!>> ");
INSERT INTO llu_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ma na wane initoo nae ka soeledi gera, <<Kade hato taa naa na alakwa nau e akwaa ana?>> Ma gera oolisia daka bae urii, <<Na tatasua e sui faasia i aasoa i roogi.>> ");
INSERT INTO llu_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ma na maa nia wela naa e haitamana si kade hato baa na a Jesus e haea na ana si baelaa baa gi nae. Haia, i buira si doo naa, na wane initoo naa fai nia na tooa nia gi sui go, gera ka manata mamana ana Jesus. ");
INSERT INTO llu_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Haia, nia naa na ruana si doo kwaibalatana Jesus e aadea ana si kada nia ooli mai ana faasia Judea fui Galili nae. ");
INSERT INTO llu_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","I buira si doo naa gi, Jesus ka lea fui Jerusalem, ana tee fanga gera Jiu gi. ");
INSERT INTO llu_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","I Jerusalem, tee lama e too garangia na mae haga gera sipsip. Haia, ma ana baelaa i Hebru, gera alangia na lama nae ana Betsaeda. Ma na lima taofa tekwa naa gi da too abana lama nae. ");
INSERT INTO llu_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Tooa oro asianaa na gera teo laona taofa nae gi. Tooa gi na gera matai ana kwalukaela mataia eꞌete gi kwailiu: tooa maada e rodo, tooa tero, ma tooa abada ma na aeda ka mae. ");
INSERT INTO llu_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ma tee wane e teo fai gera i seenae, nia matai sulia oolu aakwala ma kwalu fe ngali. ");
INSERT INTO llu_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ma Jesus e rikia e teo go ana ana si gula naa, ma nia ka haitamana na nia matai ka tau asianaa, ma nia ka soe ledia wane nae ka urii, <<Oe dooria oko akwaa?>> ");
INSERT INTO llu_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ma na wane matai nae e oolisia Jesus ka urii, <<Wane baita ae, langi ta wane fuana ka ngali nau kou fui laona lama ana si kada na kafo e ngalungalua. Ana si kada gi sui, kada ku hasi ua fuana lealaa laona kafo naa, ta wane ka lea na ana i nao faasi nau.>> ");
INSERT INTO llu_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ma Jesus ka bae urii, <<O tatae i langi, oko koua na iifitai oe, ma oko fali amu.>> ");
INSERT INTO llu_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ma si kada nae ua go, na wane naa ka diana naa, ma nia ka tatae, ma ka koua na iifitai nia, ma ka lea na ana. Ma fe dani nae fe dani Sabat. ");
INSERT INTO llu_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Nia naa, na wane baita gera Jiu gi gera ka bae urii fuana wane na e akwaa, <<Taraꞌena na mae dani Sabat, ma e aabu asianaa ana kwaieresia gia gi fuana oko koua na iifitai oe.>> ");
INSERT INTO llu_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Wane nae ka bae urii fuada, <<Na wane na e faaꞌakwaa nau naa e haea kuka koua iifitai nau ma kuka fali.>> ");
INSERT INTO llu_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ma gera ka ledi nia lau daka urii, <<Wane taa na e haea oko aadea si doo naa?>> ");
INSERT INTO llu_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Sui, na wane naa ka lalafusia laugo ana a Jesus, sulia na wane oro asianaa na gera too ana si gula nae. Ma a Jesus ka lea na ana i matangada. ");
INSERT INTO llu_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ma i buri na ana, a Jesus kafi kwaitodai fai nia i laona Beu Aabu a God, ma ka bae urii fuana, <<O fafurongo, kada naa, oe diana naa lau. Haia, oko oolitai manata faasia aade taꞌalaa oe gi, aata tara tesi doo ka haungi oe lau. Si doo nae tara ka taꞌa ka tasa liufia si doo na e haungi oe sui na mai.>> ");
INSERT INTO llu_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ana si kada wane naa e haga i maa faasia na Beu Aabu a God, nia ka lea siana tooa baita gera Jiu gi, ma ka bae urii fuagera, <<A Jesus baa e aadea kuka akwaa lau.>> ");
INSERT INTO llu_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ma ana si kada nae, gera ka talaꞌae na maalimaelaa Jesus sulia nia e guraa na wane naa ana maedani Sabat. ");
INSERT INTO llu_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ma Jesus ka bae urii fuagera, <<Iilingia Maa nau na e rao sulia dani, haia ma ni nau kuka rao laugo.>> ");
INSERT INTO llu_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Haia, ma sulia na baelaa nae gi, nia aadea tooa baita gera Jiu gi na manatada ka rigita asianaa fuana gera ka haumaelia ada a Jesus. Langi lau sulia nia langi si manata baita ana maluta gi sulia na Sabat taifilia na gera ka doori haungi nia. Ma laugo sulia nia e haea a God naa na Maa nia. Ma sulia e urinae, nia e faatainia hasa nia e bobola fai nia a God. ");
INSERT INTO llu_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ma Jesus e oolisida ka urii, <<Doo mamana nau ku haea fuagamu. Nau, na Wela nia God, e afetai kuka iilia si doo i talagu. Nau ku haitamana kuka iilia go agu si doo gi na ku rikia siana Maa nau nia iilida. Si taa gi na Maa nau e iilida, nia laugo na nau kuka iilida. ");
INSERT INTO llu_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Sulia Maa nau nia rakediana fuagu, ma nia ka faatainia fuagu na doo gi sui na nia e iilida. Ma tara nia ka faatainia laugo fuagu na raoa baita gi lau na nia haitamana ka iilida, eeri ana si kada nau ku iilida laugo na doo nae gi, tara muka kwele asianaa. ");
INSERT INTO llu_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","A Maa nau e haitamana ka tataea tooa da mae ma ka faamouri gera. Haia, si doo urinae laugo na tara ni nau, nau Wela nia, kuka iilia laugo. Tara ni nau kuka falea mouria laugo fuana ni tei gera na ku aadafilida. ");
INSERT INTO llu_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","A Maa nau taifilia langi kasi ketoa ta wane. Sulia nia falea sui naa na mamanaa uria ketolaa. ");
INSERT INTO llu_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Nia falea si doo naa fuagu eeri na tooa gi sui gera ka manata baita ani nau, iilingia laugo na gera manata baita ana na Maa nau. Haia, ni tei na e langi kasi manata baita ani nau, nia langi kasi manata baita laugo ana Maa nau, na e oodu nau mai. ");
INSERT INTO llu_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","<<Doo mamana nau ku haea fuagamu. Lea so ni tei na e rongoa na baelagu gi ma ka manata mamana ana a God na e oodu nau mai, nia ka too ana mouria firi. A God e langi kasi ketoa naa. Ma boroi ana na noina tara ka mae, nia e mouri katau katau. ");
INSERT INTO llu_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Doo mamana nau ku haea fuagamu, si kadamanga tara e dao mai ma nia ka dao na mai, fuana ni tei gera na da mae naa, daka rongo nau, nau Wela nia God. Ma ni tei gera na da fafurongo nau, tara gera ka mouri lau. ");
INSERT INTO llu_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Sulia Maa nau, nia na gwoufutana na mouria. Haia, ma nia falea na mamanaa fuagu eeri ni nau laugo na gwoufutana na mouria sulia ni nau na Wela nia. ");
INSERT INTO llu_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ma nia ka falea na mamanaa fuagu eeri kuka ketoa ana tooa gi. Sulia ni nau naa, nau Wela nia Iimola gi. ");
INSERT INTO llu_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Langi musi kwele ana doo naa, sulia si kadamanga tara ka dao mai fuana tooa na da mae tara gera ka rongo nau, ");
INSERT INTO llu_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ma gera ka haga mai faasia na kwaingeia gera gi eeri ni tei gera na da aadea si doo diana gi, gera ka tatae mai ma gera ka too ana mouria. Ma ni tei gera na da aadea doo taꞌa gi, tara gera ka tatae mai, ma tara gera ka too ana kwakwaea. ");
INSERT INTO llu_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","<<Nau langi kusi iilia tesi doo sulia manatagu i talagu. Nau ku haitamana kuka keketoa tooa sulia si taa na nau ku rongoa a God e haea fuagu. Na keketolaa nau nia e oꞌolo teefou, sulia nau kusi hasi uria iililana doo sulia doorilagu i talagu, ma ku iilia go agu sulia na taa gi na a God na e oodu nau mai e dooria. ");
INSERT INTO llu_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","<<Lea so ni nau kuka faarongo ana si doo suli nau i talagu, tara ta wane langi kasi manata mamana go ana faarongolaa nau. ");
INSERT INTO llu_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Tee wane na e too go ana, nia ana na e faarongo ana si taa na nia e haitamana suli nau. Ma i nau ku haitamana si taa na nia faarongo ana suli nau e mamana teefou. ");
INSERT INTO llu_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Haia, ma ni gamu naa, mu oodua kou wane gamu gi siana a John eeri muka soeledia. Haia, ma si taa naa na nia faarongo gamu ana, na doo mamana gi sui go. ");
INSERT INTO llu_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Haia, ma ni nau naa, nau langi kusi dooria go faarongoa urinae gi faasia na wane hasa ka faarongo ana tesi doo suli nau. Nau ku bae go agu fuagamu urinae eeri muka manata mamana ana, ma mu kafi too ana mouria faalu. ");
INSERT INTO llu_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Haia, a John e uusulia ta laeta baa e tala diana. Haia, ma ana si kada totou, gamu ka eele sulia si taa gi na nia haeda. ");
INSERT INTO llu_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Nau ku too laugo ana si doo fuana ka faamamana a Maa nau na e oodu nau mai. Haia, si doo na nia liufia na doo gi na a John nia faarai sulida. Haia, si doo nae gi naa na raoa naa gi na ku iilida sulia a Maa na e faleda fuagu kuka iilida. ");
INSERT INTO llu_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","38","Haia, ma a Maa na e oodu nau mai, nia i talana ana na e faarongo ana na doo naa gi sui suli nau. Sui gamu langi musi manata mamana go ani nau. Haia, ma aena si doo nae, nia faatainia gamu langi musi rongo nia ua ma langi musi riki nia ua. Ma na baelana e langi kasi too go i laona manatalagamu. ");
INSERT INTO llu_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Gamu naa, gamu manata hasa tara muka ngalia na mouria firi sulia mu iidumia katau na mai ana Kekedelaa Aabu gi. Haia, na Kekedelaa Aabu nae gi nia faatainia doo mamana gi sui suli nau. ");
INSERT INTO llu_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Haia, ka urinae boroi ana, gamu langi musi dooria go lealaa mai siagu fuana kuka faamouri gamu. ");
INSERT INTO llu_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","<<Ma ni nau naa, nau langi kusi nani uria wane fuana bae baitalaa ani nau. ");
INSERT INTO llu_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Haia, ma ni nau ku haitamana ni gamu langi musi manata go uria rakedianalaa fuana God. ");
INSERT INTO llu_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Haia, ma ni nau naa, nau ku lea mai sulia kwaidoorilana Maa nau, sui langi musi doori nau go. Haia, ma lea so ta wane ka lea mai ana sulia kwaidoorilaa nia i talana, molu ka dooria amolu. ");
INSERT INTO llu_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Haia, ma ni gamu na mu dooria agamu tooa gamu gi gera ka tango gamu. Ma e langi musi dooria go na iililana doo diana gi hai so a God ka tango gamu. Sulia mu urinae, nia afetai asianaa naa fuana molu ka manata mamana ani nau. ");
INSERT INTO llu_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Langi si diana molu ka manata hasa ni nau naa tara kuka faatainia na taꞌalaa gamu gi i nao na Maa nau. Nau langi. Haia, Moses baa, na e kedea na kwaieresia gi na molu manata mamana ana, tara nia ana na ka faatainia na taꞌalaa gamu gi. ");
INSERT INTO llu_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Haia, gamu langi si manata mamana asianaa ana Moses, sulia langi molu si manata mamana laugo ani nau. Sulia a Moses naa e kekede mai suli nau. ");
INSERT INTO llu_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Haia, ma sulia langi molu si manata mamana ana taa naa Moses e kedea suli nau ana, nia naa ka afetai asianaa fuana muka manata mamana ana si taa gi na ku haea fuagamu.>> ");
INSERT INTO llu_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ma i buri, a Jesus ka faifolo ana na aasi i Galili na da alangia lau ana aasi i Taebirias. ");
INSERT INTO llu_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ma tee figua baita e lea i burina, sulia da rikia na doo kwaibalatana gi na nia e iilia ana na guralada na tooa matai gi. ");
INSERT INTO llu_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ma a Jesus ka raa i gwouna tee fe uuo, ma ka gwouru i aano fai nia na oote fafurongo nia gi. ");
INSERT INTO llu_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ana si kada nae, na Fangaa ana na Lofoagaua gera na Jiu e garangi naa. ");
INSERT INTO llu_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","A Jesus e aada gali nia, ma ka rikia na figua baita da dao mai siana, ma ka bae urii fuana a Filip, <<Tara golu ka foli tesi fanga i fai eeri golu ka hangonia na tooa naa gi sui?>> ");
INSERT INTO llu_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","I nia e baea si doo naa eeri ka iilitoona a Filip, sulia nia ka haitamana sui naa si doo na nia tara ka iilia. ");
INSERT INTO llu_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ma a Filip e oolisia ka urii, <<Na roo talange malefo boroi kasi bobola naa fai nia na folilana na fanga hai so daka fanga totoꞌou boroi ada ana.>> ");
INSERT INTO llu_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ma tee wane fafurongo aai, a Andrew na aua nia a Simon Peter, e bae ka urii, ");
INSERT INTO llu_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","<<Tee wela wane i seenaa e too go ana lima fe beredi ma roo gwe iia. Sui taa, e afetai ka bobola fai nia na tooa oro naa gi.>> ");
INSERT INTO llu_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ma a Jesus e haea fuada ka urii, <<Molu haea fuana na tooa gi daka gwouru i aano.>> Na laua oro na e too i seenae. Ma na tooa gi sui daka gwouru i aano, ma e bobola fai nia na lima tooni wane. ");
INSERT INTO llu_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ma a Jesus e ngalia fe beredi nae gi ma ka baelafea a God, ma ka tolingia fuana na tooa gi na da gwouru i seenae. Ma nia ka iili urinae laugo ana gwe iia nae gi. Ma i gera sui go da ngali ka bobola fai nia na doorilada. ");
INSERT INTO llu_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ma si kada da aabusu naa, nia ka bae urii fuana na oote fafurongo nia gi, <<Molu gonia na mumuduna na fanga gi na e oore eeri langi golu si naga tesi doo.>> ");
INSERT INTO llu_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ma gera ka goni teefou ana, ma daka faafungua tee aakwala ma roo koko ana na mumuduna na fanga na e oore ana na lima fe beredi baa gi, na da ania. ");
INSERT INTO llu_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ma ana si kada na tooa gi da rikia si doo kwaibalatana na a Jesus e iilia, daka bae urii, <<Na profet baa na tara ka dao mai laona na molaagali mamana naa naa!>> ");
INSERT INTO llu_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ma a Jesus ka lea na ana faasi gera i gwouna fe uuo taifilia, sulia i nia e haitamana gera garangi lea na mai uria na suungailana hai so i nia na aaofia gera. ");
INSERT INTO llu_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ma i haulafi ana si kada na hato garangi ka suu, na oote fafurongo nia gi gera ka sifo na ada kamena aasi. ");
INSERT INTO llu_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ma gera ka tae laona tee baru, ma gera ka aato folo ana aasi fuana maefera gera alangia ana Kapaneam. Ma na rodo ka rodo na mai. A Jesus e langi kasi lea go faida. ");
INSERT INTO llu_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ma e dao ana si kada nae na ooru ka dao mai ma na kafo ka tongatonga asianaa. ");
INSERT INTO llu_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ma ana si kada gera dao ana tauruarua, gera aada kou, ma gera ka rikia a Jesus e fali mai i fafona kafo, ma ka lea garangia na mai na baru. Ma na oote fafurongo gi gera ka mou asianaa. ");
INSERT INTO llu_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ma a Jesus ka bae urii kou fuadaalu, <<Langi molu si mou! Nau go ana naa!>> ");
INSERT INTO llu_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ma i buira si doo naa, nia ka tae fai daalu, ma gera ka eele asianaa. Ma e langi si tau, gera ka dao ana maefera na gera lea uria. ");
INSERT INTO llu_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ma kada e dani mai, na tooa oro na da too ua i bali aasi aai loko, gera ka aada haitamana tee baru go ana na e too i nao. Ma gera ka haitamana laugo Jesus langi kasi lea fai nia na oote fafurongo nia gi. Ma gera ka haitamana laugo na fafurongo gi gera lea go ada faasia. ");
INSERT INTO llu_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Sui, teni baru mai faasia i Taebirias, gera lea mai, gera ka oolo ana si gula baa Jesus e baelafea God faafia na fanga baa gi, sui kafi falea fuana tooa oro baa gi. ");
INSERT INTO llu_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Si kada na figua nae dasi rikia a Jesus ma langi na oote fafurongo nia gi, gera taelia na baru gi, daka lea, daka nani uria a Jesus i Kapaneam. ");
INSERT INTO llu_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ma si kada gera daotoona ana bali aasi aai nae, daka ledi nia urii, <<Wane faatolomai ae, si kada taa na o dao i seenaa?>> ");
INSERT INTO llu_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ma a Jesus e oolisida ka urii, <<Doo mamana nau ku haea fuagamu, gamu mu nani uri nau sulia mu ania fe beredi baa gi ma muka aabusu, ma e langi lau sulia mu haitamana na malutana na doo kwaibalatana baa gi na ku iilia. ");
INSERT INTO llu_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Langi musi rao uria na fanga na tara ka molea laugo ana. Muka rao uria na fanga aai na e falea mouria firi. Nia naa na fanga na nau, na Wela nia Iimola gi, ku falea fuagamu, sulia a God na Maa e faatainia na nia naa e oodu nau mai.>> ");
INSERT INTO llu_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Sui na tooa gi da ledi nia urii, <<Na taa naa melu ka iilia eeri melu ka iilia na raoa nia a God e dooria fuamelu?>> ");
INSERT INTO llu_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ma Jesus e oolisida ka urii, <<Na kwaidooria nia a God e urii: Muka manata mamana ana na wane na nia e falea mai.>> ");
INSERT INTO llu_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ma gera ka ledi nia lau urii, <<Tesi doo kwaibalatana taa na oko aadea hai so melu ka rikia ma melu ka manata mamana ani oe? Tesi taa na oko iilia? ");
INSERT INTO llu_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Na koo gia gi da ania na beredi baa na da alangia ana <mana> i laona na aanogwou, iilingia baa da kedea naa urii, <I nia e falea na fanga faasia i langi fuada uria na anilana.>>> ");
INSERT INTO llu_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ma a Jesus ka bae urii fuada, <<Doo mamana nau ku haea fuagamu, a Moses langi baa e falea na beredi faasia i langi fuagamu. Na Maa nau ana baa e falea na fanga mamana faasia i langi fuagamu. ");
INSERT INTO llu_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Sulia na fanga na a God e falea naa na wane na e sifo mai faasia i langi ma ka falea na mouria fuana na tooa gi i laona molaagali.>> ");
INSERT INTO llu_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ma gera ka bae urii fuana, <<Aarai baita ae, e ita i taraꞌena ka lea, oko falea na fanga naa fuagami.>> ");
INSERT INTO llu_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Sui a Jesus ka bae urii, <<I nau naa na fanga ana mouria. Ma so ni tei na e lea mai siagu e afetai ka fiolo lau, ma ni tei na e manata mamana ani nau e afetai ka maeligwou lau. ");
INSERT INTO llu_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Haia, ma ni nau ku haea sui naa fuagamu. Sui boroi ana na muka riki nau, gamu langi musi manata mamana go ani nau. ");
INSERT INTO llu_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Tooa gi sui go na Maa nau e faleda fuagu, tara gera ka lea sui go mai siagu. Ma so ni tei na e doori lea mai siagu, nau langi kusi oote nau ani nia. ");
INSERT INTO llu_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Nia urinae, sulia nau ku sifo mai faasia i langi, e langi lau fuana iililana si doo sulia kwaidoorilagu i talagu. Nau ku lea mai uria iililana si taa na a God na e oodu nau mai e dooria. ");
INSERT INTO llu_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Taa na a God e dooria nana langi kusi tagalangai nia tesi doo ana tooa gi sui na nia faleda fuagu, eeri ana maedani isi nau kuka fi tataeda uria na mouria. ");
INSERT INTO llu_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","A God na Maa nau nia dooria so ni tei gera na gera aada haitamagu ma gera ka manata mamana ani nau, gera ka ngalia mouria firi ma i nau tara kuka taeda uria mouria ana maedani isi.>> ");
INSERT INTO llu_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ma na tooa gi gera ka hafalia na ngunungunulaa suli nia, sulia na nia e bae urii, <<I nau naa na fanga na e sifo mai faasia i langi.>> ");
INSERT INTO llu_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ma daka bae urii fuada kwailiu, <<Na wane naa a Jesus na wela nia a Josef go ana, ma golu ka haitamana go agolu na maa nia ma ni tee nia. Ma e utaa naa nia ka haea ana hasa nia e sifo mai faasia i langi?>> ");
INSERT INTO llu_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ma a Jesus e oolisida ka urii, <<Molu aalua faasia na ngunungunulaa i matangamiu. ");
INSERT INTO llu_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","E langi ta wane so ka lea mai siagu lea na Maa nau na e fale nau mai e langi kasi talai nia mai i siagu. Ma tara nau kuka tataea uria na mouria ana fe dani iꞌisi. ");
INSERT INTO llu_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Na profet gi da kede daka urii, <A God ka faatolomainia tooa gi sui go.> Ma so ni tei na e rongoa na Maa ma ka ngalia na haitamadooa faasi nia, gera ka lea mai siagu. ");
INSERT INTO llu_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ma e langi ta wane ka rikia na Maa. Tee taifilia na wane na e ita mai faasia a God go na e rikia naa na Maa. ");
INSERT INTO llu_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Doo mamana nau ku haea fuagamu, so ni tei na e manata mamana, nia ka too ana na mouria firi. ");
INSERT INTO llu_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ma i nau naa na fanga ana na mouria. ");
INSERT INTO llu_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Na koo gamu gi da ania na beredi baa na da alangia ana <mana> i laona aanogwou, ma gera ka mae go ada. ");
INSERT INTO llu_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Sui na fanga na e sifo mai faasia i langi, so ta wane na e ania, e afetai nia ka mae. ");
INSERT INTO llu_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ma i nau naa na fanga ana na mouria faasia i langi. Lea so ta wane ka ania na fanga naa, i nia ka mouri too ka tau. Ma na fanga nae naa na marikogu, na ku falea eeri na tooa gi i laona molaagali daka mouri.>> ");
INSERT INTO llu_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ma na tooa gi daka hafali oolisusuu i matangada kwailiu ma daka bae urii, <<Na wane naa ka fale utaa ana na marikona fuaga uria anilana?>> ");
INSERT INTO llu_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ma a Jesus ka bae urii fuada, <<Doo mamana nau ku haea fuagamu, lea so e langi musi ania na marikogu ma e langi musi gwoufia na abugu, e afetai muka too ana na mouria. ");
INSERT INTO llu_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ma so ni tei na e ania na marikogu ma ka gwoufia na abugu, nia ka too ana na mouria firi, ma i nau tara kuka tataea ana fe dani iꞌisi. ");
INSERT INTO llu_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Sulia na marikogu naa na fanga mamana, ma na abugu naa na gwoulaa mamana. ");
INSERT INTO llu_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ma so ni tei na ka ania na marikogu ma ka gwoufia na abugu, nia ka too ani nau, ma i nau kuka too ani nia. ");
INSERT INTO llu_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","A God na Maa momouri, nia naa e falea nau mai. Ma i nau kuka mouri laugo suli nia. Nia naa, so ni tei na e ani nau, nia ka mouri laugo suli nau. ");
INSERT INTO llu_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ma nia naa na fanga na e sifo mai faasia i langi. Ma e langi kasi iilingia beredi baa na koo gia gi da ania ma daka mae naa. Sui, so ni tei na e ania na fanga naa, nia ka mouri too ka tau.>> ");
INSERT INTO llu_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesus e haea ana si doo naa gi si kada nia faatolomai ana i lao Beu Aabu ni figulaa i Kapaneam. ");
INSERT INTO llu_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ma na orolada na oote fafurongo nia gi na da rongoa na doo na gi a Jesus e haea, ma daka bae urii, <<Na faatolomaia nia naa e afetai asianaa. Tei naa tara ka manata mamana?>> ");
INSERT INTO llu_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ma a Jesus e haitamana na oote fafurongo nia gi da ngunungunu sulia si doo naa, ma nia ka bae urii fuada, <<E utaa? Si baea nae gi e naga gamu? ");
INSERT INTO llu_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","E utaa lea so muka riki nau, na Wela nia Iimola gi, kuka ooli uria si gula baa ku too mai ana i nao? ");
INSERT INTO llu_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Na doo na e falea na mouria, nia na na Aanoedoo Aabu. Ma na rigitaa nia wane na doo tatagwai go ana. Ma si baea gi na ku haea fuagamu naa na e ngalia mai na Aanoedoo Aabu na e falea na mouria. ");
INSERT INTO llu_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Sui ka urinae boroi, teni wane ani gamu e langi dasi manata mamana go.>> Sulia ita ua na mai i nao, a Jesus e haitamana sui naa ni tei ani gera na e langi si manata mamana, ma ni tei na tara ka fale nia fuana na maalimaea nia gi. ");
INSERT INTO llu_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ma nia ka bae lau urii, <<Nia naa baa ku haea sui naa ana fuagamu e langi ta wane so ka lea mai siagu, lea so na Maa nau kasi faawaludaa fuana.>> ");
INSERT INTO llu_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ma e ita ana si kada nae, orolada na oote fafurongo nia gi da aabulo eꞌete na ada, ma e langi dasi lea naa fai nia. ");
INSERT INTO llu_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ma a Jesus e ledia na aakwala ma roo wane fafurongo nia gi ka urii, <<E utaa? I gomolu laugo molu dooria lea faasi nau?>> ");
INSERT INTO llu_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ma a Simon Peter e oolisia ka urii, <<Lord ae, ni tei lau melu ka lea siana? Ni oe naa na o too ana na baea gi ana na mouria firi. ");
INSERT INTO llu_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Haia, i gemelu melu manata mamana ma melu ka haitamana ni oe naa na Wane Aabu na o lea mai faasia a God.>> ");
INSERT INTO llu_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ma a Jesus e bae urii, <<Nau naa ku aadafili gamu na aakwala ma roo wane. Ma sui boroi ana ka urinae, tee wane ani gamu nia iilingia na aagalo taꞌa.>> ");
INSERT INTO llu_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ana si kada Jesus e bae urinae, nia e manata go ana fuana Judas nae, wela Simon Iskariot. Sulia Judas sui boroi ana nia ta wane ana aakwala ma roo wane fafurongo nia gi, ni nia naa tara ka falea Jesus fuana maalimaea nia gi. ");
INSERT INTO llu_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ma i buira na doo naa gi, Jesus ka liu galia go ana maefera i Galili gi sulia nia langi kasi dooria lealaa ua fui Judea sulia na wane baita ana Jiu gi seenae gera dooria haungilana. ");
INSERT INTO llu_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ma tee fafangaa gera Jiu gi nia garangi naa. Ma gera alangia na fafangaa naa <<Oobala gi>>. ");
INSERT INTO llu_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Haia, na haasina Jesus gi gera ka lea mai siana, ma gera ka bae urii fuana, <<Ae. O lea fui Judea fuana oko faatainia teni doo kwaibalatana eeri oote fafurongo oe gi gera ka rikia. ");
INSERT INTO llu_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Sulia lea ta wane e dooria hasa na tooa daka rongoa na hatana ma daka haitamana, langi nia kasi iilia tesi doo ka aagwa. Lea o iilia si doo baita oro gi, nia diana go na o lea oko iili faatai ana eeri na molaagali sui gera ka haitamana.>> ");
INSERT INTO llu_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Na haasina gi gera bae urinae fuana sulia gera boro langi gera kasi manata mamana go ani nia. ");
INSERT INTO llu_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Haia, Jesus ka bae urii fuagera, <<Nia e langi si dao ua ana si kada nau eeri kuka iilia na doo nae gi. Haia, ma ni gamu mamalana go ana si kada molu iilia ana doo gi molu dooria. ");
INSERT INTO llu_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Tooa la molaagali na e afetai gera ka maani uula ani gamu. Ma ni nau, gera ka maani uula ada ani nau, sulia nau ku hae faatai ana si taa gi na gera iilia ka taꞌa gi. ");
INSERT INTO llu_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Molu lea amolu ana fafangaa. Haia, ma ni nau tara nau langi kusi lea go, sulia e langi si dao ua ana si kada nau.>> ");
INSERT INTO llu_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Nia bae urinae sui, ma nia ka too lau i Galili. ");
INSERT INTO llu_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","I buira haasina Jesus gi gera lea na ada uria fangaa baita nae i Jerusalem, Jesus ka lea i burida. Ma nia e lea aagwa go ana, aata ta wane ka haitamana. ");
INSERT INTO llu_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ma na wane baita gera Jiu gi gera ka nanisia nuina na fafangaa, ma gera ka ledia daka urii, <<Nia i fai na wane baa?>> ");
INSERT INTO llu_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ma tooa oro asianaa gera bae aagwa suli nia daka urii, <<Na wane baa nia wane diana.>> Ma teni wane aai gi gera ka haea, <<Nia talaia wane oro uria lealaa sulia na sugelaa nia gi.>> ");
INSERT INTO llu_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Sui boroi ana gera ka bae urinae, langi ta wane ada kasi faarai tafa go ana manatalaa gera nae gi sulia Jesus, sulia gera mou ana tooa baita ana Jiu gi. ");
INSERT INTO llu_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Na fangaa na nia lea sulia fai maedani e sui naa, ma a Jesus kafi ruu kou laona labata na Beu Aabu nia a God, ma kafi talaꞌae faatolomainia na tooa. ");
INSERT INTO llu_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ma na wane baita gi kada gera rongoa, gera ka kwele asianaa ana faatolomailaa nia. Ma gera ka urii, <<Wane na langi kasi sukulu go mai ana ta fera. Ma e utaa na nia ka haitamana na doo gi sui?>> ");
INSERT INTO llu_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ana si kada Jesus e rongo gera, nia e oolisi gera ka bae urii, <<Si faatolomailaa nau langi lau na doo nau, na doo a God ana na e oodu nau mai. ");
INSERT INTO llu_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Tei na e dooria ka iilia kwaidoorilana a God, tara nia ka haitamana si taa na nau ku faatolomainia ana tooa, nia e lea mai faasia God, ma e langi lau na manataa nau gi i talagu go ana na nau ku faarongo ana. ");
INSERT INTO llu_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Lea wane e ainitalo go ana ana si doo sulia na manataa nia gi i talana, nia dooria go ana fuana tooa gi daka tango nia. Ma na wane na e dooria tooa gi gera ka tangoa na wane na e oodu nia mai nia nana na wane mamana, ma langi nia kasi haitamana sugelaa.>> ");
INSERT INTO llu_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Sui Jesus ka bae lau urii, <<Moses e falea na kwaieresia gi fuagamu. Ma langi ta wane ani gamu kasi lea go sulia kwaieresia nae gi. Haia, ma uria taa na molu ka doori haumaeli nau?>> ");
INSERT INTO llu_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ma na tooa na gera koni ana si gula nae, gera ka bae urii, <<Oe naa, aagalo taꞌa e nii ani oe! Tei naa e doori haumaeli oe?>> ");
INSERT INTO llu_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","A Jesus e oolisi gera ka urii, <<Nau ku iilia go tesi doo kwaibalatana baa ana maedani Sabat, sui molu ka kwele asianaa ana. ");
INSERT INTO llu_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","23","Ma ni gamu haitamana hasa a Moses e falea tee kwaieresia fuamolu, fuana gala wela wane gamu gi gera ka ole-mariko. (E langi lau a Moses na e talaꞌaea, na koo gamu gi ua mai nao taari.) Ma ana si kada mu lea sulia kwaieresia nae, gamu ka haitamana aadea wela wane gi ana fe dani gi, sui boroi ana fe dani ana Sabat. Sui e utaa na molu ka rakehasui nau kada baa ku guraa wane baa ana mae dani ana Sabat? ");
INSERT INTO llu_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Muka lugasia keketolaa taꞌa na ita mai ana doo mu rikia go agamu. Ma muka keketo ana oꞌoloa.>> ");
INSERT INTO llu_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ma teni tooa gi i Jerusalem gera ka bae urii, <<Boro na wane naa oto baa na wane baita gi da dooria haungilana? ");
INSERT INTO llu_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Aada fasi! Wane naa nia bae faatai go ana, ma langi gera si haea go tesi doo suusi nia. Gera ka haitamana oto nia naa Christ, na wane aadafililana baa God uria aaofialaa! ");
INSERT INTO llu_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Sui taa, lea na Christ e lea mai, tara ta wane langi kasi haitamana si gula na nia e lea mai faasia. Ma na wane naa, golu haitamana go agolu gula na nia e lea mai faasia.>> ");
INSERT INTO llu_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Haia, ma ana si kada nae, Jesus e faatolomainia na tooa laona Beu Aabu a God. Ma nia e bae baita ka urii, <<Nia mamana nae molu haitamagu ma molu ka haitamana si gula taa na ku lea mai faasia? Haia, nau langi kusi lea mai ana na mamanaa nau i talagu! Ma ni nia na e oodu nau mai, nia e hae doo mamana gi sui. Haia, ma ni gamu langi musi haitamana go naa. ");
INSERT INTO llu_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ma ni nau ku haitamana, sulia nia na e oodu nau mai, ma kuka lea mai faasia.>> ");
INSERT INTO llu_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ana si kada nae, na wane baita gi gera ka doori dumulilana, ma ka afetai. Sulia nia langi si dao ua ana si kada eeri gera ka aade urinae ana. ");
INSERT INTO llu_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Sui boroi ana gera ka dooria aadea si doo nae, orolana tooa i laona figua nae gera ka manata mamana ani nia. Ma gera ka bae urii, <<Nia naa na Christ, sulia langi ta wane kasi aadea na doo kwaibalatana nia gi lea nia langi si Christ.>> ");
INSERT INTO llu_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Haia, ana si kada na Farisi gi da rongoa tooa gi gera fuaro aagwa ada sulia a Jesus urinae, gera fai nia na fataabu baita gi gera ka oodua kou teni wane fofolo gi na gera folo usia Beu Aabu a God eeri gera ka dumulia ana si kada nae. ");
INSERT INTO llu_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ma a Jesus ka bae urii, <<Nau na tara kuka too fai gamu go agu ana si kada kukuru, ma tara nau kuka ooli laugo agu siana na wane na e oodu nau mai. ");
INSERT INTO llu_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Sui tara molu ka nanisi nau, ma tara ka afetai molu ka daotoogu. Sulia e afetai molu ka dao ana si gula na nau tara kuka too ana.>> ");
INSERT INTO llu_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ma na wane baita Jiu gi gera ka bae ada i matangada kwailiu urii, <<Wane naa tara ka lea fui fai naa eeri golu ka langi si riki nia? Utaa? Tara nia ka lea ana fuana fera gera Grik gi, na gula gi teni tooa aga gi da too mai ana, eeri ka faatolomai gera sui? ");
INSERT INTO llu_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ma nia ka haea laugo tara golu ka nanisia, ma tara langi golu si riki nia, sulia langi golu kasi haitamana daolaa ana si gula na tara nia ka too ana. Haia, ma na taa na e nii la manatana si kada nia bae urinae ana?>> ");
INSERT INTO llu_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Haia, ma ana fe dani isi ana fangaa naa, nia fe dani initoo ka tasa. Ma ana fe dani nae, Jesus e take, ma ka bae baita ka urii, <<So ni tei na e maeligwou, nia ka lea mai siagu ka gwou ana. ");
INSERT INTO llu_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","So ni tei na e manata mamana ani nau, tara nia ka uusulia si taa baa na Kekedelaa Aabu e haea, <Na kafo momouria tara ka iigwa mai faasia na mourilana.>>> ");
INSERT INTO llu_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jesus e haea si doo na sulia Aanoedoo Aabu naa tara ka lea mai siada ni tei gera na da manata mamana ana. Haia, ma ana si kada nae, God langi kasi oodua ua mai na Aanoedoo Aabu siana tei gera na da manata mamana, sulia Jesus langi kasi tae ua eeri ka ooli mai fui langi. ");
INSERT INTO llu_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Teni wane ana figua naa, gera rongoa baelana a Jesus, gera ka urii, <<Wane naa nia na gwounge profet baa na gia maasia!>> ");
INSERT INTO llu_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ma teni wane aai gi gera ka haea, <<Nia na Christ na wane aadafililana baa a God uria aaofialaa!>> Haia, ma teni wane lau, gera ka haea, <<Na wane aadafililana e langi kasi lea mai faasia i Galili! ");
INSERT INTO llu_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Sulia na Kekedelaa Aabu e haea a Christ tara ka futa mai ana kwalafaa a David na aaofia, ma ka futa i Betlehem, maefera David e too laugo ana.>> ");
INSERT INTO llu_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Haia, na tooa naa gi langi gera kasi aalua go tesi manatalaa sulia Jesus. ");
INSERT INTO llu_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ma bali ana wane gi gera dooria asianaa gera ka dumulia Jesus, sui ma ka langi ta wane ka iilia tesi doo ana. ");
INSERT INTO llu_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Na tooa fofolo baa gi langi gera si dumulia go Jesus, ma gera ooli kou siana fataabu baita gi ma na Farisi gi. Ma si kada gera dao naa, na fataabu baita gi ma na Farisi gi daka bae urii, <<Utaa na langi molu si ngalia mai?>> ");
INSERT INTO llu_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ma gera oolisida urii, <<Sulia gemelu kwele asianaa ani nia, sulia langi ta wane aai kasi faarai urinae.>> ");
INSERT INTO llu_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Na Farisi gi gera ka bae urii fuada, <<Boro gomolu, molu manata mamana laugo amolu ana sugelaa nia gi? ");
INSERT INTO llu_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ta wane ana wane baita golu baa gi langi ta Farisi, gera si manata mamana go ana! ");
INSERT INTO llu_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Na figua nae go ana na gera manata mamana ani nia. Ma gera langi dasi haitamana go na kwaieresia a Moses gi. Nia urinae tara a God ka kwakwaeda.>> ");
INSERT INTO llu_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Haia, ma tee wane ani gera Farisi hatana a Nikodimas baa e lea mai siana Jesus i nao. Nia ka bae urii fuana na Farisi aai gi, ");
INSERT INTO llu_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","<<Na kwaieresia golu gi e urii, golu ka rongo diana ana si taa na wane e haea, ma golu ka haitamana diana ana taa na nia aadea suifetei golu kafi ketoa uria na kwakwaea.>> ");
INSERT INTO llu_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","53","Ma gera ka bae urii fuana Nikodimas, <<Utaa? Oe laugo ta wane faasia i Galili? Lea oko iidu diana ana Kekedelaa Aabu, oko rikia i talamu. Langi ta profet hasa tara ka lea mai faasia i Galili!>> ");
INSERT INTO llu_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Haia, ma ana si kada na tooa gi sui da ooli naa uria na luma gera gi, a Jesus ka tae uria gwouna fe uuo da alangia ana Olivtri. ");
INSERT INTO llu_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ma i ofaidani ana fe dani i buri, nia ka ooli lau uria na Beu Aabu nia a God. Ma na figua baita gera figu gali nia, ma i nia e gwouru, ma ka faatolomaida. ");
INSERT INTO llu_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ma na wane faatolomai gi ana kwaieresia gi ma na Farisi gi gera ka ngalia mai tee geni na gera ka daotoona ana ooelaa. Ma daka faatakea i matangada. ");
INSERT INTO llu_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ma daka bae urii fuana a Jesus, <<Wane faatolomai ae, na geni naa da daotoona ana ooelaa. ");
INSERT INTO llu_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Haia, ma i laona na kwaieresia gi na a Moses e falea fuaga, e haea hasa na geni urii, daka uimaelia ana na fou uria haungilana. Ma na taa naa o haea sulia?>> ");
INSERT INTO llu_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Gera haea si doo naa uria daotoolana tesi doo, eeri daka feengia ana Jesus. Ma a Jesus e agwaaro ana i aano, ma ka kekede ana ana kakauna na abana i fafo gano. ");
INSERT INTO llu_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ma si kada da ledi nia ka lea dongaa go ana, nia e take, ma ka bae urii fuada, <<So ni tei ani gamu na e langi kasi aade taꞌa, nia ka uia ana tesi fou totongenao.>> ");
INSERT INTO llu_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Sui, nia ka agwaaro lau, ma ka kekede lau i fafo gano. ");
INSERT INTO llu_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ma si kada gera rongoa si doo naa, gera ka lea naa ada, tee wane sui ta tee wane, e hafali ana na wane waro gi. Ma gera ka tafusia a Jesus ka too na taifili nia fai nia na geni baa na e take ua go ana i seenae. ");
INSERT INTO llu_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ma i nia ka take lau, ma ka bae urii, <<Geni naa ae, na tooa baa gi da nia naa i fai? E utaa? Ta wane ada kasi oore naa hai so ka keto oe?>> ");
INSERT INTO llu_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ma nia e oolisia ka urii, <<Wane baita ae, e langi naa ta wane.>> Ma a Jesus ka bae urii fuana, <<Haia, i nau boroi, langi kusi keto oe. O lea na amu, ma langi osi aade taꞌa lau.>> ");
INSERT INTO llu_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesus ka bae lau urii fuana Farisi gi, <<I nau naa, nau ku iilingia na kwesu fuana tooa gi laona molaagali naa. Wane na e lea mai suli nau, nia langi si liu i laona rorodoa. Nia ka liu laona raralaa, ma ka too ana mouria firi.>> ");
INSERT INTO llu_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ma na Farisi gi gera ka bae urii fuana, <<Oe amu i talamu ana na o faarongo ani oe. Nia naa afetai fuana melu ka manata mamana ana na baelamu.>> ");
INSERT INTO llu_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesus ka bae urii, <<Langi go. Sui boroi ana nau ku faarongo ani nau i talagu, taa gi na nau ku haeda nia e mamana, sulia nau ku haitamana si gula taa na nau ku lea mai faasia, ma i fai na tara kuka lea uria. Haia, ma ni gamu, langi musi haitamana go si gula nau ku lea mai faasia, ma si gula tara kuka lea uria. ");
INSERT INTO llu_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Gamu mu ketoa si doo gi sulia manatalaa wane la molaagali naa go ana. Haia, ma ni nau, langi kusi ketoa ta wane. ");
INSERT INTO llu_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ma lea nau ku ketoa ta wane, nau ku ketoa sulia si manata oꞌolo. Nau kusi ketoa ta wane taifili nau, ma i gemere sui go a Maa na e oodu nau mai na mere iilia. ");
INSERT INTO llu_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Na kwaieresia gamu gi e haea sui naa, lea roo wane da haea tee si doo sulia si doo, si taa na daaro haea nia mamana. ");
INSERT INTO llu_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nau ku faarongo ani nau i talagu, ma na Maa na e oodu nau mai, nia laugo na e faarongo go ani nau.>> ");
INSERT INTO llu_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Sui, gera ka soeledia Jesus gera ka urii, <<Maa oe e ni fai?>> Jesus oolisi gera ka urii, <<Gomolu na langi molu si haitamagu ma langi na Maa nau. Lea so molu haitamagu, molu ka haitamana laugo a Maa nau.>> ");
INSERT INTO llu_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesus e haea na doo naa gi ana si kada nia faatolomainia ana tooa i laona Beu Aabu a God, i laona si kade Beu na gera aalua ana bokosi gi na gera aalua ana na falelaa gi i laona. Haia, ma ana si kada nae, langi ta wane hasa ka dumulia, sulia nia e langi kasi dao ua ana si kada nia. ");
INSERT INTO llu_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesus ka bae urii lau fuagera, <<Nau tara kuka lea ma tara muka nanisi nau. Ma tara muka mae, ma a God kasi lukea go si aade taꞌalaa gamu gi. Ma e afetai molu ka lea ana si gula na nau tara kuka lea uria.>> ");
INSERT INTO llu_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Haia, na tooa baita gera Jiu gi gera ka bae urii, <<Nia haea tara afetai go golu ka lea uria si gula na nia tara ka lea uria. Utaa? Tara nia ka haungi nia ana i talana oto?>> ");
INSERT INTO llu_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","A Jesus e oolisi gera ka bae urii, <<Gomolu naa, molu lea mai faasia na aanofuu naa. Ma ni nau naa, nau ku lea mai faasia i langi. Gomolu naa faasia na molaagali naa. Ma ni nau langi lau faasia na molaagali. ");
INSERT INTO llu_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Nia naa, nau ku haea sui na tara muka mae, ma a God kasi lukea lau si aade taꞌalaa gamu gi. Nia mamana nae, lea langi molu si manata mamana ana ni nau na wane kuka too ita ua mai ana hafalilaa.>> ");
INSERT INTO llu_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Sui gera soeledia daka urii, <<Oe ni tei naa?>> Ma Jesus e oolisida ka bae urii, <<Nau nana si doo naa na ku haea ua na mai fuagamu totongenao laona faatolomailaa nau. ");
INSERT INTO llu_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nau ku too ana na doo oro asianaa na ku haitamana kuka haea suli gamu fuana ketolaa gamulaa urida. Wane na nia e oodu nau mai, nia naa na wane mamana. Haia, ma si taa na nia haea fuagu, nia naa nau haea fuana wane gi sui.>> ");
INSERT INTO llu_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ma gera langi dasi haitamana go na a Jesus e bae sulia a Maa nia mai i langi. ");
INSERT INTO llu_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Nia naa, nia ka bae urii fuada, <<Si kada mu aalu nau, na Wela nia Iimola gi, fafona airarafolo, tara muka haitamagu na nau na wane kuka too ita ua mai ana hafalilaa. Ma ana si kada nae, tara muka haitamana na nau langi kusi iilia tesi doo sulia na manatalagu i talagu. Sui si doo gi na Maa e faatolomai nau ana, nia na nau ku haeda fuagamu. ");
INSERT INTO llu_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Haia, ma Maa na e oodu nau mai naa, nia e too fai nau sulia dani. Nia langi kasi lugasi nau, sulia nau ku iilia si doo gi na e faaele nia sulia dani.>> ");
INSERT INTO llu_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ma tooa oro gi gera ka manata mamana ana Jesus si kada gera rongo nia haea si doo naa gi. ");
INSERT INTO llu_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Sui a Jesus ka bae urii fuana tooa gi na gera manata mamana ani nia, <<Lea so muka aade sulia na faatolomailaa nau gi, gamu muka aalu wane fafurongo nau gi mamana naa. ");
INSERT INTO llu_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ma lea so ka urinae, tara muka haitamana si doo mamana gi sulia God, haia, ma na doo mamana nae gi na tara ka aade gamu muka too nonilaa.>> ");
INSERT INTO llu_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Gera oolisia Jesus, gera ka urii, <<Gami na tooa ana kwalafaa a Abraham na. Langi melu si rao oꞌoni lau fuana ta wane. Utaa naa oko haea tara mika too nonilaa?>> ");
INSERT INTO llu_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesus ka bae urii lau fuada, <<Doo mamana nau ku haea fuagamu. Tooa na gera roosulia na maluta taꞌa gi, na maluta taꞌa nae gi naa ka baita ani gera, ma gera ka rao oꞌoni na ada i farana. ");
INSERT INTO llu_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Na wane na e too nonilaa, nia na wane e futa ana aebara, ma ka too ana mamanaa uria toolaa laona luma maa nia. Ma na wane na e rao go ana, nia langi si too mamana ana aebara. ");
INSERT INTO llu_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Nia naa, lea ni nau, na Wela nia God, ku faanonilaa gamu, nia na tara gamu kafi nonilaa mamana. ");
INSERT INTO llu_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nau ku haitama gamu na tooa ana kwalafaa a Abraham. Sui boroi ana ka urinae, molu ka dooria haungilagu, sulia langi molu si dooria go lealaa sulia na faatolomailaa nau gi. ");
INSERT INTO llu_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nau ku bae sulia si taa na Maa nau nia faatainia fuagu. Haia, ma ni gamu mu iilia si taa gi na maa gamu e haeda fuagamu.>> ");
INSERT INTO llu_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Gera oolisi Jesus daka urii, <<Maa gami naa na a Abraham!>> Jesus ka urii fuada, <<Lea so ni gamu na kwalafaa a Abraham gi mamana, muka iilia laugo si doo gi nia aadeda gi. ");
INSERT INTO llu_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Haia, ma ni nau ku haea go agu si doo mamana gi fuagamu sulia dani ana si doo gi na ku rongoa mai faasia a God. Sui molu ka dooria amolu na haumaelilagulaa. Sui a Abraham langi kasi aadea go si doo urinae. ");
INSERT INTO llu_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Gamu mu aadea laugo si doo gi na maa gamu e aadeda naa.>> Gera ka bae urii fuana, <<Taifilia a God go na Maa gemelu, ma gemelu naa na wela nia gi mamana.>> ");
INSERT INTO llu_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesus oolisida ka bae urii, <<Lea so a God na Maa gamu mamana, muka rakediana laugo fuagu, sui muka langi go. Nau naa ku lea mai faasia God, ma ana si kada nae, nau ku too fai gamu i see. Nau langi kusi lea mai sulia na doorilagu i talagu. A God naa e oodu nau mai. ");
INSERT INTO llu_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Utaa naa langi molu si rongo haitamana baelagu gi? Nia sulia langi molu si dooria go rongolana. ");
INSERT INTO llu_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Haia, gamu naa, na maa gamu naa a Satan. Nia naa, molu ka dooria iililana na doo gi iilingia nia iilida gi. A Satan na nia na wane fuana hauwanelaa na sulia nia ita ka iilia ua na mai. Ma nia ka lalafusia na mamanaa, sulia nia langi si too ana tesi taa gi na e mamana ani nia. Si kada nia sugea ana ta wane, nia naa nae na aabulolana go ana, sulia nia na wane fuana sugelaa naa, ma nia na maa nia na sugelaa gi sui. ");
INSERT INTO llu_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Haia, doo mamana nau ku haea fuagamu, si doo nae na aadea langi molu si dooria go na manata mamanalaa ani nau. ");
INSERT INTO llu_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Haia, ma ni tei ani gamu na e haitamana ka faatainia na taa na nau ku aade ka taꞌa ana? Langi! Haia, ma utaa na langi molu si manata mamana ani nau si kada nau ku haea doo mamana gi fuagamu? ");
INSERT INTO llu_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Haia, ni tei gera na da ita mai siana God, gera haitamana daka rongo sulia na baelana. Haia, ma ni gamu naa, gamu langi musi ita mai ana God. Ma nia naa e aadea langi gamu si dooria fafurongolaa.>> ");
INSERT INTO llu_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Sui, gera ka bae urii fuana Jesus, <<Si taa baa melu haea suli oe nia mamana baa melu haea oe wane faasia Samaria, ma oko too ana na aagalo taꞌa.>> ");
INSERT INTO llu_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesus oolisida ka bae urii, <<Langi go, i nau e langi kusi too ana ta aagalo. Ma nau ku faaꞌinitoo ana Maa nau, ma ni gamu langi musi faaꞌinitoo go ani nau. ");
INSERT INTO llu_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ma ni nau naa, nau langi kusi dooria go tooa gi gera ka hae initoo ani nau. A Maa nau na e dooria fuana tooa gi gera ka hae initoo ani nau. Ma ni nia naa laugo na tara ka keketo ana oꞌololaa. ");
INSERT INTO llu_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Doo mamana nau ku haea fuagamu, so ni tei na e aade sulia faatolomaia nau, tara nia langi kasi mae.>> ");
INSERT INTO llu_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Sui gera oolisia Jesus gera ka bae urii, <<Gemelu kafi haitamamu nae, oe o too ana aagalo! Sulia koo gia a Abraham nia mae naa, ma na profet gi laugo gera ka mae. Utaa na oko haea lea wane aade sulia faatolomaia oe, nia tara ka langi si mae? ");
INSERT INTO llu_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Koo gia Abraham nia na wane baita, sui nia ka mae go ana. Haia, ma ni oe naa, oe manata hasa oe o baita liufia Abraham? Ma na profet gi laugo na gera mae. Haia, ma ni oe na oe ni tei naa?>> ");
INSERT INTO llu_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","A Jesus e oolisi gera ka urii, <<Lea so ni nau go ana ku hae initoo ani nau talagu, si initooa nau nia tatagwai go ana. Haia, na wane fuana ka hae initoo ani nau, nia naa a Maa nau, na molu haea nia na God gamu. ");
INSERT INTO llu_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Sui boroi ana, langi molu si haitamana go a God. Ma ni nau, nau ku haitamana. Ma lea nau ku haea nau langi kusi haitamana, nau tara kuka iilingi gamu na mu haitamana sugelaa asianaa. Haia, ma ni nau ku haitama diana asianaa na ana, ma kuka aade sulia baelana. ");
INSERT INTO llu_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Haia, na koo gamu Abraham nia eele asianaa sulia tara nia ka rikia na lealaa nau mai. Ma nia ka rikia naa, ma ka eele asianaa sulia.>> ");
INSERT INTO llu_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ma gera ka bae lau urii fuana, <<Nwalae! Lima aakwala fe ngali kasi sui ua ani oe, sui oko haea o rikia Abraham?>> ");
INSERT INTO llu_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesus e oolisi gera ka bae urii, <<Doo mamana nau ku haea fuagamu: Si kada Abraham langi kasi futa ua, nau naa nau ku too naa.>> ");
INSERT INTO llu_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ana si kada nae, gera ka ngalia na fou gi uria uimaelilanalaa sulia nia bae urinae. Sui, nia ka aagwa nia faasi gera, ma ka lea faasia na Beu Aabu. ");
INSERT INTO llu_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Si kada a Jesus e liliu ana, nia ka rikia tee wane na maana e rodo ita ua mai ana si kada e futa ana. ");
INSERT INTO llu_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ma na oote fafurongo nia gi da ledi nia daka urii, <<Wane faatolomai ae, na aade taꞌalana ni tei naa e aadea na maana na wane naa ka rodo ita ua na mai ana futalana? Na aade taꞌalaa nia i talana langi na aade taꞌalana na maa nia ma ni tee nia?>> ");
INSERT INTO llu_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ma a Jesus e oolisida ka urii, <<Na maa rodoa na e haungia, langi lau sulia na aade taꞌalaa nia i talana ma langi na aade taꞌalana na maa nia ma ni tee nia. Na maana e rodo hai muka rikia na rigitalana a God e rao ani nia. ");
INSERT INTO llu_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Gia ka iili dongaa ana na raoa nia gi a God na e fale nau mai, ana si kada e dani ua. Sulia na rodo e garangi naa, si kada baa langi ta wane kasi rao naa. ");
INSERT INTO llu_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Si kada ku too ana i laona molaagali, nau ku iilingia na kwesu baita fuana na tooa.>> ");
INSERT INTO llu_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ma i buira a Jesus e haea si doo naa, nia ka ngisu i hae gano, ma ka buia mamago ana si ngisu, ma ka uusua ana na maana na wane nae. ");
INSERT INTO llu_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ma a Jesus ka bae urii fuana, <<O lea oko taufia na maamu i laona na lobo i Siloam.>> (Si hata naa, na malutana <<Eeresia>>.) Ma na wane nae e lea ka taufia na maana, ma nia ka aada. ");
INSERT INTO llu_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ma na tooa gi fera nia ma na tooa gi na da riki nia baa e gani doo go ana i nao, daka ledida kwailiu, <<Nia na wane baa e gwouru ma ka gani doo go ana naa?>> ");
INSERT INTO llu_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ma teni tooa gi daka urii, <<I nia naa naa.>> Ma teni tooa gi lau daka bae urii, <<I nia e langi naa, ma nia mone e aada iilingia.>> Ma na wane nae i talana ka bae urii, <<I nau na wane baa naa naa.>> ");
INSERT INTO llu_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ma gera ka ledia, <<Na maamu e aada utaa naa?>> ");
INSERT INTO llu_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ma nia e oolisida ka urii, <<Na wane na hatana a Jesus na e haungainia si mamago, ma ka uusua ana na maagu. Ma nia ka haea fuagu ku lea kuka taufia na maagu i laona na lobo i Siloam. Sui nau ku lea, ma si kada ku taufia ana na maagu, na maagu ka aada naa.>> ");
INSERT INTO llu_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ma gera ka ledia lau urii, <<I nia e nii i fai?>> Ma nia e oolisida ka urii, <<Nau ku lalafusia.>> ");
INSERT INTO llu_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ma i buri, gera talaia na wane baa siana na Farisi gi. ");
INSERT INTO llu_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Haia, ma fe dani nae a Jesus e haungainia ana mamago, ma ka guraa na maana na wane naa, fe dani Sabat. ");
INSERT INTO llu_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ma na Farisi gi da ledia lau na wane naa e utaa naa e aadea ka aada naa. Ma nia ka haea urii fuada, <<A Jesus e aalua mamago faafia na maagu. Sui ku taufia na maagu, ma na maagu ka aada naa.>> ");
INSERT INTO llu_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ma teni wane ada na Farisi gi daka bae urii, <<Na wane naa na e iilia si doo naa, e langi si lea mai faasia a God, sulia nia langi kasi roosulia na kwaieresia sulia na Sabat.>> Ma teni wane lau daka urii, <<Na wane na e taꞌa so ka iili utaa ana si kwaibalatana baita urinae gi?>> Ma langi dasi aala go ada sulia doo nae. ");
INSERT INTO llu_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Sui na Farisi gi daka ledi urii lau ana na wane nae, <<Haia, oe naa o haea a Jesus e guraa na maamu, na taa na o haea suli nia?>> Ma nia ka urii, <<I nia na profet.>> ");
INSERT INTO llu_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ma na wane baita ana Jiu gi, da oote gera ana manata mamanalaa hasa na maana e rodo ua na mai. Ma gera ka soea mai na maa nia ma ni tee nia. ");
INSERT INTO llu_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ma gera ka ledi daaro urii, <<Na wela gomoro naa? Gomoro haea hasa na maana e rodo ua ana si kada e futa mai ana. Ma si taa naa e aadea nia ka aada naa si kada naa?>> ");
INSERT INTO llu_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ma na maa nia ma ni tee nia daaro oolisida daka urii, <<Gemere mere haitamana nia na wela gemere, ma mere ka haitamana na maana e rodo ua mai ana si kada e futa ana. ");
INSERT INTO llu_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Sui taa, mere lalafusia si taa naa e aadea ka aada naa, langi ni tei na e guraa na maana. Molu ledi nia kou, sulia nia e baita naa ma nia ka bae ana i talana!>> ");
INSERT INTO llu_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Na maa nia fai nia ni tee nia daaro haea si doo naa sulia daaro mou ana na wane baita gi ana Jiu. Sulia gera da kwaialafaafi sui naa, hasa lea ta wane e haea a Jesus naa na Christ, na wane baa a God e filia, langi dasi faalamainia ka ruulaa i laona Beu Aabu ni figulaa gi. ");
INSERT INTO llu_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Nia naa na maa nia fai nia ni tee nia daaro ka haea, <<I nia e baita naa. Molu ledia kou!>> ");
INSERT INTO llu_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Sui gera ka soea lau mai na wane baa na maana e rodo i nao, ma gera ka bae urii fuana, <<O bae aalangai i nao na a God tara oko haea naa doo mamana gi naa! Gemelu haitamana na wane naa na wane taꞌa.>> ");
INSERT INTO llu_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ma na wane naa e oolisida ka urii, <<I nau ku lalafusia i nia na wane taꞌa ma e langi. Tesi doo ku haitamana naa go agu e urii, na maagu e rodo i nao, sui ana si kada naa nau kuka aada naa.>> ");
INSERT INTO llu_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ma gera ka ledia lau urii, <<Na taa na nia e iilia ani oe? Ma nia ka guraa utaa ana maamu?>> ");
INSERT INTO llu_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ma na wane naa e oolisida ka urii, <<I nau ku haea sui naa fuagamu baa, sui langi molu si rongoa go. Uria taa naa molu ka doori rongoa lau? I gomolu laugo molu dooria molu ka hau ana wane fafurongo nia gi oto mone?>> ");
INSERT INTO llu_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Gera bae tataga fuana ma daka urii, <<Ni oe na wane fafurongo nia. I gemelu na wane fafurongo nia gi a Moses ana naa. ");
INSERT INTO llu_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Sulia gemelu melu haitamana a God e bae fuana a Moses. Sui na wane naa, melu lalafusia nia lea mai faasia i fai!>> ");
INSERT INTO llu_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ma na wane naa e oolisida ka urii, <<Nau ku kwele asianaa ani gomolu. Sulia nia e guraa na maagu, sui molu ka haea langi molu si haitamana go amolu i fai na nia lea mai faasia. ");
INSERT INTO llu_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Golu sui, golu haitamana a God langi kasi fafurongo uria na tooa taꞌa gi. Nia e fafurongo ana uria na tooa gi na da hae baita ani nia, ma daka iilia si taa gi na nia e dooria hai gera ka iilia. ");
INSERT INTO llu_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","E ita ua mai ana hafalilana na molaagali, e langi gia si rongoa ua hasa ta wane ka guraa na maana na wane na e rodo ita ana si kada e futa ana. ");
INSERT INTO llu_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ma lea so na wane naa e langi si lea mai faasia a God, e afetai nia ka iilia ta si doo urinae.>> ");
INSERT INTO llu_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ma gera ka rakehasu asianaa, ma gera ka bae urii fuana, <<Ni oe o taꞌa asianaa ita ua mai ana futalamu! Utaa na oko hasi uria na faatolomai doo fuamelu?>> Sui gera ka langi si faalamainia naa uria na ruulaa i laona Beu Aabu ni figulaa gi. ");
INSERT INTO llu_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Sui a Jesus e rongoa gera iilia si doo naa fuana na wane naa. Ma nia ka daotoona ma ka bae urii, <<Ni oe o manata mamana ana na Wela nia Iimola gi?>> ");
INSERT INTO llu_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ma na wane naa e oolisia ka urii, <<Aarai ae, o faarongo nau, ni tei nae, hai kuka manata mamana ani nia?>> ");
INSERT INTO llu_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ma a Jesus ka bae urii fuana, <<Ni oe o riki nia sui naa, ma i nia naa na o bae fai nia ana si kada nae.>> ");
INSERT INTO llu_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ma na wane naa ka haea, <<Lord ae, i nau ku manata mamana naa ani oe.>> Ma nia ka boururu i hae gano i maana aena a Jesus. ");
INSERT INTO llu_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","A Jesus ka bae urii, <<I nau ku lea mai i laona na molaagali naa uria na ketolaa, eeri na tooa gi na maada e rodo, tara daka aada lau, ma na tooa na da aada, tara na maada ka rodo lau.>> ");
INSERT INTO llu_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ma teni wane ada na Farisi gi na da too i seenae fai nia, da rongoa e haea si doo naa, ma daka ledia, <<Ni oe haea na maa melu e rodo laugo?>> ");
INSERT INTO llu_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ma a Jesus e oolisida ka urii, <<Lea so gamu ka iilingia na wane maa rodo gi, langi molu si garo. Sui taa, molu haea gomolu aada haitamana na doo mamana gi. Nia na aadea molu ka garo asianaa.>> ");
INSERT INTO llu_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","A Jesus e haea fuana na oote fafurongo nia gi ka urii, <<Doo mamana nau ku haea fuagamu, na wane na langi kasi ruu ana maehaga laona na baa gera na sipsip gi, ma ka ruu go mai ana i buira na baa, i nia na wane bebeli. ");
INSERT INTO llu_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ma na wane aai naa na e ruu mai ana maehaga, i nia naa na wane na e aadasulia na sipsip gi. ");
INSERT INTO llu_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Na wane fofolo ka ifingia na maehaga na baa fuana, ma na sipsip gi daka rongoa na lingeena. I nia e soe hatada na sipsip nia gi ma ka talaida i maa. ");
INSERT INTO llu_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ma si kada nia e talaia na sipsip nia gi sui i maa, nia ka eeta i nao ada, ma gera ka lea i buira sulia da rongo haitamana na lingeena. ");
INSERT INTO llu_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ma e afetai daka lea i buira ta wane ete. I gera daka tafi faasi nia, sulia langi dasi rongo haitamana na lingeena.>> ");
INSERT INTO llu_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Si kada Jesus e baea si oomelawanea naa fuada, gera langi dasi haitamana go na malutana. ");
INSERT INTO llu_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Nia naa, a Jesus ka bae lau urii, <<Doo mamana nau ku haea fuagamu, i nau ku iilingi na maa uria na ruulaa ana fuana na sipsip gi. ");
INSERT INTO llu_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Na wane baa gi da dao mai i nao ani nau, gera iilingia na wane bebeli gi, ma na sipsip gi langi dasi roo go suli gera. ");
INSERT INTO llu_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","I nau ku iilingia na maehaga uria na ruulaa. Ma so ni tei na e ruu mai ani nau, nia ka mouri. Tara nia ka ruu mai ma ka ruu kou ma ka daotoona na doo diana gi. ");
INSERT INTO llu_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Na wane bebeli e dao go mai ana uria na belilaa ma na hauwanelaa ma na kwailabasidoolaa. I nau ku dao mai eeri muka too ana na mouria na e diana ka tasa. ");
INSERT INTO llu_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","<<I nau ku iilingia laugo ta wane na e aada diana sulia sipsip gi. Ma nau kuka aade aagau uria maelaa usia na sipsip nau gi. ");
INSERT INTO llu_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ma na wane aai na e rao uria na folilaa ma na sipsip gi langi doo nia gi, si kada nia ka rikia na kui kwasi e lea mai, nia ka tafusia na sipsip gi, ma ka tafi na ana. Ma na kui kwasi e lea mai ka haungia teni sipsip gi ma ka tagalangaia teni sipsip aai gi. ");
INSERT INTO llu_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Na wane nae e tafi na ana sulia nia e rao go ana uria folilaa, ma ka langi si oga nia go uria na sipsip gi. ");
INSERT INTO llu_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","I nau ku aada diana usia sipsip gi, ma kuka maabe uria maelaa fuana sipsip nau gi. Ma gera ka haitamagu, ma i nau kuka haitamada laugo, iilingia laugo a Maa e haitamagu ma i nau laugo ku haitamana laugo. ");
INSERT INTO llu_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ma teni sipsip nau gi laugo na langi gera kasi too ua laona baa, gera na sipsip nau gi laugo. Ma tara kuka ngalida laugo mai. Ma gera ka rongo haitamana lingeegu. Haia, ma tara gera ka too oofu laona tee aabui sipsip nau fai nia na sipsip na da too ua na mai. Ma tara kuka aadasulida teefou. ");
INSERT INTO llu_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","<<Na Maa e rakediana fuagu, sulia nau ku eekwatainia na mourilagu uria na maelaa eeri kuka mouri lau. ");
INSERT INTO llu_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Langi ta wane hasa ka haungi nau, lea langi kusi lugasia fuana. Ma nia naa na kwaidoorilagu. Nau ana i talagu nau ku too ana mamanaa uria lugasilagu i talagu uria maea ma uria mouria laugo. Haia, si doo naa na Maa nau haea kuka aadea.>> ");
INSERT INTO llu_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ma ana si kada nae, tooa Jiu gi langi gera kasi aalua na tesi manatalaa sulia Jesus sulia si doo gi na nia e haeda. ");
INSERT INTO llu_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Orolada gera haea, <<Wane naa e nue ma ka too ana aagalo taꞌa. Langi molu si fafurongoa!>> ");
INSERT INTO llu_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Haia, ma teni tooa ada gera ka bae urii, <<Na wane na e too ana aagalo e afetai ka bae urii loko! Ma na wane na e too ana aagalo e afetai ka guraa tooa maada e rodo ma gera ka aada lau!>> ");
INSERT INTO llu_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ana si kada ana uuni gwagwaria, na Jiu gi gera figu i Jerusalem uria Fangaa ana Faaabulana Beu Aabu a God. ");
INSERT INTO llu_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ma Jesus e too laugo laona labata ana Beu Aabu nae, ma ka liliu go ana i laona taofa a Solomon. ");
INSERT INTO llu_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Haia, ma ana si kada tooa gi gera rikia, gera ka koni mai siana, ma gera ka soeledia daka urii, <<Gami kwaimaasi ka tau asianaa. O haea oꞌolo ana fuagami! Oe naa na Christ, na wane aadafililana a God uria aaofialaa ma e langi?>> ");
INSERT INTO llu_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","A Jesus e oolisida ka urii, <<Nau ku haea sui naa fuagamu, sui langi molu si dooria go na manata mamanalaa ani nau. Si raoa naa gi ku aadeda naa na Maa nau na e haea kuka aadeda, gera ka faatainia nau ni tei. ");
INSERT INTO llu_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Sui molu si dooria go na manata mamanalaa, sulia gamu naa gamu langi lau na sipsip nau gi. ");
INSERT INTO llu_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Na sipsip nau gi na da fafurongo uria na lingeena baelagu, ma i nau kuka haitamada ma daka lea i burigu. ");
INSERT INTO llu_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ma kuka falea na mouria firi fuada, ma e afetai daka mae. Ma e afetai ta wane ka lauda faasi nau. ");
INSERT INTO llu_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Na Maa nau na e falea na sipsip naa gi fuagu, nia e baita ka liufia na doo gi sui. Ma e afetai ta wane ka laua na sipsip naa gi faasi nia. ");
INSERT INTO llu_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","I nau fai nia a Maa, gemere tee doo go.>> ");
INSERT INTO llu_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ma ana si kada nae, na tooa gi gera ka konia lau mai na fou gi eeri gera ka uimaelia Jesus. ");
INSERT INTO llu_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ma Jesus ka soeledi gera urii, <<I gamu mu rikia sui naa si raoa diana oro gi na i nau ku iilia faasia na Maa. Haia, ma si raoa taa ana na raoa naa gi na mu dooria haungilagu faafia?>> ");
INSERT INTO llu_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Gera ka oolisia urii, <<Gemelu si ui oe faafia na raoa diana gi o aadeda. Melu dooria ui oe faafia o bae tataga ana God. Sulia oe na wane go ana, ma oko haea oe a God!>> ");
INSERT INTO llu_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesus e oolisi gera lau ka urii, <<Na baelaa gi e too laona Kwaieresia gamu, a God e haea ka urii, <I gamu na God gi.> ");
INSERT INTO llu_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Haia, ma ni golu haitamana na doo gi sui i laona Kekedelaa Aabu, nia mamana teefou katau. Haia, a God e alangia na koo gia ana god gi. Gera na tooa na God e bae fuada. ");
INSERT INTO llu_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Nau naa, nau wane Maa e aadafilia ma ka oodu nau mai laona molaagali naa. Haia, ma e utaa na molu ka haea nau ku bae tataga ana God si kada ku haea ana nau Wela nia? ");
INSERT INTO llu_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Lea nau langi kusi aadea na raoa gi na Maa nau e dooria kuka aadea, langi musi manata mamana go ani nau. ");
INSERT INTO llu_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Sui lea nau ku iilia na raoa gi na Maa e dooria, molu ka manata mamana mone amolu ana si raoa nae gi, sui boroi ana molu ka langi si manata mamana ana si taa gi na nau ku haeda fuagamu. Lea so molu ka aadea na doo naa gi, tara muka haitamana diana na Maa e too i lalo ani nau ma i nau laugo ku too i lalo ana Maa.>> ");
INSERT INTO llu_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ma ana si kada nae laugo, gera ka dooria daua Jesus, sui nia ka haufini nia na ana faasi gera. ");
INSERT INTO llu_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ma Jesus ka ooli lau i bali kafo ana Jodan, ma nia ka too i seenae ana si gula baa John e siuabua ana tooa gi i nao. ");
INSERT INTO llu_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ma na tooa oro asianaa gera lea mai siana Jesus, ma gera ka bae fuagera kwailiu daka urii , <<A John langi kasi aadea go teni doo kwaibalatana, sui na doo gi nia bae sulia ana wane naa, nia e mamana sui go.>> ");
INSERT INTO llu_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ma na tooa oro gi ana gula naa gera ka manata mamana ana a Jesus. ");
INSERT INTO llu_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Tee wane hatana a Lasaros e matai. I nia e too i fera Betani fai nia na roo waigeni nia ni Mary ma ni Mata. ");
INSERT INTO llu_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ni Mary nae baa e ikia na aena a Jesus na Lord ana na gwai momoko, ma ka uusua ana na iifuna ketena. Haia, na waiwane nia a Lasaros na e matai. ");
INSERT INTO llu_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ma na roo geni naa gi da fale baea uria a Jesus daka urii, <<Lord ae, na ruana rakediana oe baa e matai.>> ");
INSERT INTO llu_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ma si kada a Jesus e rongoa si doo naa, nia ka bae urii fuana na fafurongo nia gi, <<A Lasaros langi kasi mae ana mataia naa. Na mataia naa e haungia hai ka faatainia na baitalana a God ma eeri na tooa gi daka faaꞌinitoo nau na Wela nia a God ana.>> ");
INSERT INTO llu_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Haia, a Jesus e rakediana ana a Lasaros ma na roo waiwane nia gi ni Mata ma ni Mary. ");
INSERT INTO llu_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Sui boroi ana, si kada a Jesus e rongoa a Lasaros e matai naa, nia ka too lau ana si gula nae e too ana, sulia roo fe dani. ");
INSERT INTO llu_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Sui a Jesus ka bae urii fuana oote fafurongo nia gi, <<Golu ooli lau uria i Judea.>> ");
INSERT INTO llu_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ma na oote fafurongo nia gi da oolisia daka urii, <<Faatolomai ae, e langi kasi tau go baa, na tooa i Jiu gi da dooria na haungilamu ana fou. Sui oko dooria laugo na oolilaa i seenae?>> ");
INSERT INTO llu_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ma a Jesus ka bae urii, <<Ana tee fe hato na hato e tala ita i ubongi lea ka dao i haulafi. Lea so ta wane ka liu ana si kada na hato e tala, afetai ka taafainia, sulia nia e rikia na folaalana na molaagali naa. ");
INSERT INTO llu_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Sui laugo lea ta wane e galo i laona rodo, nia ka taafainia, sulia e langi ta folaalaa fuana.>> ");
INSERT INTO llu_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ma a Jesus ka bae lau urii, <<Na ruana golu baa a Lasaros e teo naa, ma tara nau ku lea, kuka faaadaa.>> ");
INSERT INTO llu_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ma na oote fafurongo nia gi da oolisia daka urii, <<Lord ae, lea so nia ka teo go ana, tara ka diana lau.>> ");
INSERT INTO llu_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Na malutana na baelaa a Jesus hasa a Lasaros e mae naa. Sui gera manata hasa i nia e teo mamana. ");
INSERT INTO llu_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Nia naa, a Jesus ka faarongo folaa ana fuada ka urii, <<A Lasaros e mae naa. ");
INSERT INTO llu_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ma uria na dianalaa gamu, nau ku eele sulia kusi too siana, hai molu ka manata mamana ani nau. Haia, golu lea siana.>> ");
INSERT INTO llu_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","A Tomas (na gera alangia ana <Na Iu>) ka bae urii fuana na oote fafurongo gi, <<Golu lea agolu fai nia na faatolomai, eeri golu ka mae laugo fai nia!>> ");
INSERT INTO llu_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ma si kada a Jesus e dao ana, fai fe dani e sui naa i buira na gera aalua ana a Lasaros. ");
INSERT INTO llu_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Na fera Betani e too garangia i Jerusalem, e bobola fai nia oolu kilometer. ");
INSERT INTO llu_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ma tooa oro i Judea gi da dao uria na maatoolana ni Mata ma ni Mary, uria na faagwagwarilana na manata daaro sulia na waiwane daaro e mae. ");
INSERT INTO llu_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ma si kada ni Mata e rongoa a Jesus e dao mai, nia ka lea uria rikilana. Ma ni Mary ka too go ana i luma. ");
INSERT INTO llu_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ni Mata ka bae urii fuana a Jesus, <<Lord ae, lea so oko too go amu i seenaa, afetai na waiwane nau ka mae. ");
INSERT INTO llu_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Boroi ana, ni nau ku haitamana si kada naa boroi ana, a God haitamana ka falea go ana tesi taa na o gani nia uria.>> ");
INSERT INTO llu_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ma a Jesus ka bae urii fuana, <<Na waiwane oe tara ka mouri lau.>> ");
INSERT INTO llu_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ma ni nia e bae fuana a Jesus ka urii, <<Nau ku haitamana tara nia ka mouri lau ana fe dani iꞌisi.>> ");
INSERT INTO llu_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ma a Jesus ka bae urii fuana, <<I nau naa na ku tataea na tooa gi ma ku falea lau na mouria fuada. So ni tei na e manata mamana ani nau, nia ka mouri, boroi ana so nia ka mae naa. ");
INSERT INTO llu_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ma so ni tei na e mouri ua ma ka manata mamana ani nau, e afetai nia ka mae. Haia, ma ni oe, o manata mamana ana si doo naa?>> ");
INSERT INTO llu_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ma nia e oolisia ka urii, <<Iiuka, Lord. I nau ku manata mamana ana i oe naa na Christ, na Wela nia a God na gami maasia na ka lea mai i laona molaagali.>> ");
INSERT INTO llu_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ma i buira naa ni Mata e haea si doo naa, ni nia ka ooli ma ka soe aaroaro ana na haasina ni Mary, ma ka bae urii fuana, <<Na faatolomai e dao naa, ma nia ka doori riki oe.>> ");
INSERT INTO llu_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ma si kada ni Mary e rongoa si doo naa, nia e tatae ma ka lea aliꞌali siana. ");
INSERT INTO llu_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Haia, a Jesus kasi dao ua mai fera, e too ua go ana mai ana si gula baa ni Mata e daotoona ana. ");
INSERT INTO llu_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ma na tooa gi na da too i luma fai nia ni Mary uria na faagwagwarilana na manatana, da lea laugo i buira si kada da rikia e tatae ma ka lea aliꞌali kou i maa. Gera da manata ada hasa ni nia e lea siana na kwaingeia uria na aangilaa i seenae. ");
INSERT INTO llu_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ma si kada ni Mary e dao ana si gula nae a Jesus e too ana, nia ka rikia ma ka boururu i maana aena, ma ka bae urii, <<Lord ae, lea so oko too go amu i seenaa, na waiwane nau e afetai ka mae.>> ");
INSERT INTO llu_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ma a Jesus e rikia ni Mary e aangi ma na tooa gi naa da lea mai fai nia da aangi laugo, ma nia ka kwaimanatai ma ka liobukonu asianaa. ");
INSERT INTO llu_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ma a Jesus e ledi gera ka urii, <<Fai na molu aalua ana?>> Gera oolisia ka urii, <<Lord ae, o lea mai ma oko rikia amu.>> ");
INSERT INTO llu_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ma a Jesus ka aangi. ");
INSERT INTO llu_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ma na tooa i Jiu gi daka bae fuagera kwailiu urii, <<Gamu rikia agamu na rakedianalaa baita nia fuana a Lasaros!>> ");
INSERT INTO llu_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ma teni tooa ada lau daka bae urii, <<I nia e guraa na wane maana e rodo. Uria taa nia kasi luia a Lasaros faasia na maea?>> ");
INSERT INTO llu_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","A Jesus ka liobukonu asianaa lau, ma ka lea siana na kwaingeia. Na kwaingeia nae, na faaluma nae fai nia tee gwe fou baita na da aalua usia na maana. ");
INSERT INTO llu_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ma a Jesus e ooduda ka urii, <<Molu lafua na fou naa!>> Ma ni Mata na waiwane nia na wane na e mae, e oolisia ka urii, <<Lord ae, na fai fe dani e sui naa i buira na aalulana. Nia ka moko taꞌa naa nae!>> ");
INSERT INTO llu_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ma a Jesus ka bae urii fuana, <<I nau ku haea sui na fuamu baa lea so oe o manata mamana ani nau, tara oko rikia na baitalana a God.>> ");
INSERT INTO llu_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ma gera ka lafua na fou nae. Sui a Jesus e aada alaa i langi ma ka fooa urii, <<Maa ae, nau ku baelafe oe sulia o fafurongo na mai urii nau. ");
INSERT INTO llu_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","I nau ku haitamana na o fafurongo urii nau sulia dani. I nau ku haea si doo naa hai na tooa naa gi i see daka manata mamana ana na o oodu nau mai.>> ");
INSERT INTO llu_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ma i buira na e haea si baea naa, nia ka rii baita ka urii, <<Lasaros ae, o haga mai i maa!>> ");
INSERT INTO llu_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ma na wane na e mae naa ka mouri lau ma ka haga na mai i maa. Ma na roo aena gi ma na roo abana gi da afua ana na maku ni afulana na wane mae, ma na maana da afua laugo. Ma a Jesus ka bae urii fuada, <<Molu lukea na maku naa gi faasia, ma molu ka lugatainia.>> ");
INSERT INTO llu_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ma na tooa oro i Jiu gi na da dao mai siana ni Mary, gera rikia si doo naa a Jesus e iilia, ma daka manata mamana ani nia. ");
INSERT INTO llu_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Haia, ma bali ani gera, da ooli siana Farisi gi ma gera ka uunuunu suli taa gi na Jesus e aadea. ");
INSERT INTO llu_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Haia, na Farisi gi ma na fataabu baita gi gera ka oofu uria baelaa fai nia na wane baita gi, ma gera ka bae urii, <<Taa na tara golu ka aadea ana wane naa? Sulia doo kwaibalatana oro gi naa na nia e aadeda. ");
INSERT INTO llu_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ma lea golu ka lugasia wane naa ka tasa dongaa go ana, tara na tooa oro gi daka manata mamana ana, ma tara na wane baita gi faasia i Rom tara gera ka rakehasui golu naa. Ma lea urii nae, tara gera ka tagalangainia na Beu Aabu a God, ma gera ka labasia na maefera gia!>> ");
INSERT INTO llu_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ma tee wane ani gera hatana a Kaeafas na fooanigwou ana si kada nae ka bae urii, <<Gomolu boro molu nue asianaa! ");
INSERT INTO llu_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Gomolu si haitamana go nia diana fuana ta wane ka mae, eeri gera ka langi si haungia wane gi sui?>> ");
INSERT INTO llu_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Haia, ma si baelaa na Kaeafas nia e haea naa, langi lau na doo i manatana taifilia. Sulia nia na fooanigwou ana si kada nae, ma nia naa a God ka aalua na manatalaa nae i liona. Haia, si baelaa nia haea sulia Jesus tara nia ka mae uria kwaiꞌadomilana na tooa i Jiu gi. ");
INSERT INTO llu_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ma nia langi kasi mae usia na wane i Jiu gi go ana taifilida. Nia mae eeri na wela God gi sui na gera too ana fera gi sui, gera ka oofu fai gera na Jiu gi eeri ka aalua tee oofuofua. ");
INSERT INTO llu_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ma hafali ana fe dani na Kaeafas haea si baelaa nae gi, gera ka talaꞌae na haungailana si manata oro fuana gera ka haungia a Jesus. ");
INSERT INTO llu_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Sulia si doo nae, a Jesus ka langi si liu faatai ana lolofaa i Judea. Ana si kada nae, nia ka lea faasia si gula nae, ma ka lea fai nia oote fafurongo nia gi gera ka lea gera ka too ana ta fera garangia na aanogwou na hatana i Ifrem. ");
INSERT INTO llu_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ana si kada nae, nia garangia na maedani ana Fangaa ana Lofoagaua gera Jiu gi. Ma na tooa oro gera ka lea kou fui Jerusalem i naona na Fangaa naa uria iililana ada teni si doo sulia na maluta gera gi eeri gera ka faalu i maana God suifetei kafi dao ana maedani Fangaa. ");
INSERT INTO llu_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ma na tooa gi gera ka nanisia Jesus. Ma ana si kada nae, gera oofu sui mai i laona labata ana Beu Aabu a God, gera ka ledi gera kwailiu daka urii, <<Utaa? Gomolu manata tara nia ka dao mai ana Fangaa? Boro langi go oto!>> ");
INSERT INTO llu_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Gera bae urinae sulia na fataabu baita gi ma na Farisi gi gera aalu baea siana tooa urii, lea ta wane ka haitamana gula Jesus nia e too ana, nia ka faarongo gera ana eeri gera ka dumulia. ");
INSERT INTO llu_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Si kada oono maedani ua i naona Fangaa ana Lofoagaua, Jesus fai nia na oote fafurongo nia gi gera ooli lau fui Betani, na maefera a Lasaros baa a Jesus e faamouria faasia na maea. ");
INSERT INTO llu_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Gera aade aagau ana si fanga i seenae fuana Jesus. Lasaros laugo na ta wane ada na tooa na gera soe mai uria fangalaa oofu fai nia a Jesus. Ma ni Mata ka toia fanga fuagera. ");
INSERT INTO llu_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ma ni Mary ka ngalia mai tee botele ana gwai ni gwailaa na da alangia ana <<nad>>, na folilana e baita asianaa. Ni Mary e ngalia mai ka igitainia i fafona roo aena a Jesus gi uria faabaitalana. Sui ni Mary ka uusua roo aena Jesus gi ana iifuna. Ma ana si kada nae, na luma naa ka fungu ana momokofana diana na gwai naa. ");
INSERT INTO llu_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Haia, a Judas Iskariot, na fafurongo baa tara ka falea a Jesus fuana maalimaea nia gi, nia e bae kou ka urii, ");
INSERT INTO llu_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","<<Utaa naa nia langi kasi faafoli ana na gwai diana naa? Na gwai naa lea so nia ka faafoli ana, tara nia ka ngalia ana si malefo e bobola fai nia si folilaa ta wane e rao uria sulia tee fe ngali. Haia, si malefo nae haitamana oko ngalia oko adomia na tooa siofaa.>> ");
INSERT INTO llu_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judas e haea si doo na langi lau sulia nia manata uria adomilana tooa na gera siofaa. Ma sulia go ana nia ta wane fuana belilaa. Haia, ma ni nia laugo na wane fuana aadalaa sulia wai malefo gera fafurongo gi. Ma si kada gi sui, nia haitamana ka labasia go ana si malefo fuana i talana. ");
INSERT INTO llu_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ana si kada nae, Jesus ka bae urii, <<Langi osi suusia lau na geni naa! Ma nau ku dooria nia ka taingainia mai na gwai naa uria uusulana ana nonigu si kada gera aalu nau ana. ");
INSERT INTO llu_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ma tooa na da siofaa gera too go ada fai gamu sulia dani. Haia, ma ni nau tara nau langi kusi too tau lau fai gamu.>> ");
INSERT INTO llu_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Tooa oro gi gera rongoa Jesus e too i Betani ma gera ka lea siana. Gera lea langi lau sulia Jesus go ana taifilinia too i fera nae. Ma gera lea laugo uria rikilana Lasaros baa a Jesus e faamouri nia faasia maea. ");
INSERT INTO llu_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Ma na orolana tooa i Jiu gi gera lugasia na fataabu baita gi ma gera ka manata mamana na ada ana Jesus sulia nia faamouria a Lasaros faasia na maea. Nia naa, na fataabu baita gi gera ka manata laugo uria na haungilana a Lasaros iilingia laugo na gera manata uria haungilana a Jesus. ");
INSERT INTO llu_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Sui ana ruana fe dani, tooa oro na gera lea mai ana Fangaa baa, gera rongoa a Jesus e lea mai fui Jerusalem. ");
INSERT INTO llu_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Gera lea, daka ngalia mai abana niu gi, ma gera ka lea mai uria kwaitodailaa fai nia Jesus. Ma gera ka rii daka urii, <<Baelafea a God! A God ka faadianaa ana na wane na e lea mai ana hatana a Lord. A God ka faadianaa na aaofia gia i Israel.>> ");
INSERT INTO llu_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Si kada nae, Jesus e ngalia tee doo fai ae na hatana dongki, ma ka tae mai i fafona. Si doo na nia faamamanaa ua go mai si taa naa na Kekedelaa Aabu e haea baa e urii, ");
INSERT INTO llu_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","<<Gamu tooa i Jerusalem, langi musi mou! Mu rikia na aaofia gamu na e tae mai i fafona gale dongki.>> ");
INSERT INTO llu_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Haia, ma ana si kada nae, na fafurongo gi langi gera si haitamana ua si doo naa. Sui i buira Jesus e mouri lau ma ka ooli fui langi ana, gera kafi manatatoona na Kekedelaa Aabu suli nia ma si taa naa daka aadea ana. ");
INSERT INTO llu_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Na tooa na gera too fai nia Jesus si kada nia soea Lasaros faasia la kwaingeia ma ka aadea ka mouri lau, gera faarongo ana si doo nae fuana tooa oro. ");
INSERT INTO llu_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Nia na aadea tooa oro gi gera ka lea mai uria kwaitodailaa fai nia Jesus. Gera lea sulia gera rongoa sui na Jesus e aadea si doo kwaibalatana nae. ");
INSERT INTO llu_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ma si kada nae, na Farisi gi gera ka bae urii ada fuada kwailiu, <<Molu rikia! Sui boroi ana golu ka haungainia manata oro gi, nia e afetai naa. Sulia wane oro gi gera lea na ada sulia na wane naa!>> ");
INSERT INTO llu_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Teni tooa gi faasia i Gris da too laugo i matangada na tooa gi na da lea uria i Jerusalem uria na fooalaa ana fe dani baita nae gi. ");
INSERT INTO llu_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","I gera da lea siana a Filip, na wane faasia i Betsaeda i laona na lolofaa i Galili, ma da bae urii fuana, <<Aarai ae, i gemelu melu doori rikia a Jesus.>> ");
INSERT INTO llu_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Sui a Filip e lea, ka faarongoa a Andrew, ma daaro ka lea ma daaro ka faarongoa a Jesus. ");
INSERT INTO llu_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ma a Jesus e oolisi daaro ka urii, <<Si kada nau na Wela nia Iimola gi e dao naa hai kuka too ana na initooa. ");
INSERT INTO llu_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Doo mamana nau ku haea fuagamu. Lea so ta tee mige ai e langi si asia i laona na hae gano ma kasi mae go, na mige ai nae ka too ua tee doo go ana. Ma lea so nia ka mae taari, nia kafi kwalafia na mige doo oro gi. ");
INSERT INTO llu_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ma so ta wane ka rakediana ana na mourilana i talana, tara nia ka mae go ana. Haia, ma lea so ta wane ka falea na mourilana i laona na molaagali naa, tara nia ka ngalia na mouria faalu na e langi si sui. ");
INSERT INTO llu_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ma so ta wane e dooria na raolaa fuagu, nia ka lea suli nau, eeri ka aalua na wane ni rao nau, ma ka too ana si gula na ku too ana. Ma na Maa nau ka faabaitaa na wane na e rao fuagu. ");
INSERT INTO llu_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","<<Ma si kada naa, na liogu e bukonu, ma tesi taa na tara kuka haea? Nau tara kuka bae urii, <Maa ae, osi faalamainia si kada naa ka dao mai faafi nau?> Langi. Sulia nia naa si doo na nau ku lea mai uria, hai kuka liu ana si kada naa ana na nonifiilaa. ");
INSERT INTO llu_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Maa ae, oko hae initoo ana na hatamu.>> Ma ana si kada nae, tesi lingee doo e bae mai faasia i langi ka urii, <<I nau ku ngalia sui na mai na initooa fuana na hatagu, ma i nau tara kuka iilia lau.>> ");
INSERT INTO llu_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ma na figua nae da take i seenae, da rongoa na lingee doo nae, ma teni tooa ada daka haea ada na kukuru. Ma teni tooa gi aai daka bae urii, <<Tee ensel naa e bae mai fuana!>> ");
INSERT INTO llu_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Sui a Jesus ka bae urii fuada, <<Na lingee doo na e bae mai, e langi lau uria na dianalagu, e bae mai uria na dianalaa gamu ana. ");
INSERT INTO llu_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ma e dao na ana si kada hai so a God ka ketoa na tooa gi i laona na molaagali naa. Ma si kada naa, a God ka lafua a Satan na wane baita ana na molaagali naa. ");
INSERT INTO llu_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ma ana si kada tara gera da tatae nau, i nau tara kuka soea mai na tooa gi sui siagu.>> ");
INSERT INTO llu_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","(Ma ana si baea naa gi, i nia e faatainia go ana na ai maea na i nia ka mae ana.) ");
INSERT INTO llu_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Haia, na tooa gi gera ka bae urii, <<Na Kekedelaa Aabu gia e haea na Christ tara langi kasi mae. Haia, ma ni oe, oko haea tara gera ka uua Wela nia Iimola gi. Haia, ma ni tei naa na Wela nia Iimola gi?>> ");
INSERT INTO llu_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesus e oolisida ka urii, <<Nau ku iilingia na kwesu baita. Ana si kada totoꞌou na nau ku too ua ana fai gamu. Nia naa, muka roosulia na baelagu si kada na ku too ua ana fai gamu eeri muka aada haitamana na tala diana. Sulia ni tei na e lea lao rorodoa tara ka lalafusia fai na nia lea uria. ");
INSERT INTO llu_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Si kada na kwesu e too ua ana fai gamu, muka manata mamana ana eeri muka aalua wela ana raralaa gi.>> Jesus e haea si doo nae gi, sui nia ka lea na ana faasi gera, ma ka haufini nia na ana faasi gera. ");
INSERT INTO llu_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Sui boroi ana Jesus ka aadea doo kwaibalatana oro gi ma gera ka rikia, sui gera langi dasi manata mamana go ani nia. ");
INSERT INTO llu_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Si doo naa gi nia urinae, eeri ka faamamana na baelaa a profet Aesea e haea ua na mai ana i nao ka mamana, baa nia bae urii, <<Lord, gera langi gera kasi manata mamana go ana baelaa gi na mi ainitalongainia, ma gera langi si aada haitamana laugo na mamanaa oe na o faatainia fuada.>> ");
INSERT INTO llu_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ma ana si kada langi gera kasi haitamana manata mamanalaa ana urinae, baelana God na Aesea nae e ainitalo ua mai ana i nao nia kafi mamana. ");
INSERT INTO llu_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Laona Kekedelaa Aabu, a God e bae urii, <<Nau ku faabokoa naa na maada eeri langi gera kasi rikia. Nau ku faangasia na manatalada eeri langi gera kasi haitamana. Nau ku aade urinae ada eeri gera ka langi si haitamana kari aabulolaa lau mai uri nau fuana kuka faamouri gera.>> ");
INSERT INTO llu_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","A Aesea e haea si doo naa gi sulia nia rikia sui na initooa nia a Jesus, ma nia ka bae sulia. ");
INSERT INTO llu_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Sui boroi ana ka urinae, wane baita oro ana Jiu gi na gera manata mamana ana Jesus. Sui langi gera kasi bae go sulia fuana wane eꞌete gi, sulia gera moungia na Farisi gi, aata gera ka luida faasia ruulaa ana ta Beu Aabu ni figulaa. ");
INSERT INTO llu_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Gera manata aꞌabo asianaa uria aadelana si doo fuana wane go ana uria eelelaa sulia. Sui langi gera si manata aꞌabo go uria aadelana si doo fuana God eeri ka eele sulia. ");
INSERT INTO llu_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Haia, Jesus e bae baita ma ka urii, <<Lea so ta wane e manata mamana ani nau, nia ka manata mamana laugo ana a God na e oodu nau mai. ");
INSERT INTO llu_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ma lea ta wane ka riki nau, nia ka rikia a God laugo na e oodu nau mai. ");
INSERT INTO llu_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nau ku lea mai laona molaagali naa uusulia ta kwesu fuana tooa, eeri ni tei gera na gera manata mamana ani nau, langi gera kasi too laona rorodoa. ");
INSERT INTO llu_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ma so ni tei na e rongoa baelagu ma langi kasi aade sulia, langi nau na wane ketoa, sulia nau langi kusi lea mai i laona molaagali naa uria ketolaa. Ma nau ku lea mai uria faamourilana tooa gi taari. ");
INSERT INTO llu_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Wane na langi kasi doori nau ma langi kasi dooria aadelaa sulia doo gi ku haeda, tara tesi doo ka ketoa nia e too ana. Na baea nau gi, nia na tara ka ketoa ana fe dani isi. ");
INSERT INTO llu_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Si doo na nia mamana, sulia si kada nau ku babae ana, nau langi kusi bae sulia si doo sulia manatagu i talagu. Na Maa na e oodu nau mai naa, nia haea fuagu si taa naa fuana kuka haea ma kuka bae sulia. ");
INSERT INTO llu_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ma i nau ku haitamana, tooa gera ka ngalia na mouria firi faasia na baelana. Haia, tesi taa na nau ku haea, nia naa si taa naa Maa e haea fuagu eeri kuka ainitalongainia.>> ");
INSERT INTO llu_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Tee fe dani i nao ana na Fangaa ana Lofoagaua, a Jesus e haitamana naa si kada nia e garangi dao naa hai ka tafusia na molaagali naa ma ka lea siana na Maa. I nia rakediana ana na oote fafurongo nia gi na da too i laona na molaagali naa, ma nia e rakediana fuada lelea ka dao i iꞌisi. ");
INSERT INTO llu_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ma a Jesus fai nia na oote fafurongo nia gi da fanga ada i haulafia. Ma a Satan e aalua na manatalaa sui naa i laona na liona a Judas, na wela a Simon Iskariot, hai ka falea a Jesus fuana maalimaea nia gi. ");
INSERT INTO llu_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","A Jesus e haitamana na Maa e falea sui naa na mamanaa gi sui fuana. Ma nia ka haitamana laugo, nia e lea mai faasia a God, ma tara ka ooli laugo siana a God. ");
INSERT INTO llu_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Nia naa, a Jesus ka tatae faasia si gula ni fangalaa ma ka lafua na maku ruruu nia, ma ka kania na maku ni uusunonilaa i liitana. ");
INSERT INTO llu_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Sui nia ka igitainia si kafo i laona na fofo, ma ka saufia na aena oote fafurongo nia gi, ma ka uusuda ana maku na e kania i liitana. ");
INSERT INTO llu_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ma si kada e dao ana a Simon Peter, nia ka bae urii fuana a Jesus, <<Lord ae, tara oko saufia na aegu naa?>> ");
INSERT INTO llu_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ma a Jesus e oolisia ka urii, <<Ana si kada naa, oe lalafusia si doo naa nau ku iilia, sui i buri tara oe kafi haitamana.>> ");
INSERT INTO llu_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ma a Peter ka bae urii, <<Nau mone, langi osi saufia na aegu!>> A Jesus e oolisia ka urii, <<Lea e langi kusi saufia na aemu, oe langi lau na fafurongo nau.>> ");
INSERT INTO llu_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ma a Peter e oolisia ka urii, <<Lord, osi saufia lau taifilia na aegu go ana. Oko saufia laugo na abagu ma na ketegu!>> ");
INSERT INTO llu_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","A Jesus ka bae urii, <<So ni tei e sisiu sui naa, na nonina e faalu teefou naa, ma e langi kesi siufia lau na nonina teefou. Nia ka saufia go ana taifilia na aena. Gomolu sui go molu faalu, ma tee wane go amolu na e langi si faalu.>> ");
INSERT INTO llu_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","A Jesus e haitamana sui naa ni tei naa ka fale nia fuana na maalimaea gi, ma nia naa nia ka bae urii, <<I gomolu sui go molu faalu, ma tee wane go amolu na e langi si faalu.>> ");
INSERT INTO llu_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ana si kada Jesus e saufia aeda sui, nia ka ruufia lau maku ruruu nia sui, nia ka ooli ka gwouru fai gera. Ma nia ka soeledida ka urii, <<Gomolu haitamana malutana si doo na nau ku aadea fuamolu nae? ");
INSERT INTO llu_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Na malutana nia urii: Gomolu molu alangi nau ana Faatolomai fai nia Lord gamu, ma ka bobola asianaa fuana molu ka alangi nau urinae, sulia nau na faatolomai ma i nau na wane baita gamu. ");
INSERT INTO llu_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ma sui boroi ana i nau na faatolomai ma i nau na wane baita gamu, nau kufi saufia go na aegamu. Ma gamu laugo, muka saufia na aegamu kwailiu laugo. ");
INSERT INTO llu_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nau ku iilia si doo nae fuagamu eeri ni gomolu laugo molu ka iilia laugo iilingi nau. ");
INSERT INTO llu_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Doo mamana nau ku haea fuagamu, na wane rao nia e langi kasi baita liufia wane baita nia. Haia, na wane na e ngali faarongoa langi kasi baita liufia na wane na e oodu nia. ");
INSERT INTO llu_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Muka haitamana diana ana si taa gi na nau ku haea fuagamu. Ma lea so muka aade sulia laugo, tara muka eele mamana. ");
INSERT INTO llu_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","<<Nau ku haea si doo naa gi langi lau fuagamu sui. Nau ku haitamana go agu ni tei gera na nau ku aadafilida. Ma nau ku haitamana tee wane ani gamu tara ka fale nau fuana maalimaea nau gi, eeri ka faamamana si Kekedelaa Aabu baa e urii, <Na wane na mere fanga oofu ana si fanga nau, nia laugo ana tara ka maalimaea ani nau.> ");
INSERT INTO llu_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Si doo na e langi kasi dao ua mai, ma e diana fuana nau kuka haea fuagamu ana si kada nae, haia lea ana si kada nia ka dao mai tara muka manata mamana ana ni nau na nau ku haea fuagamu. ");
INSERT INTO llu_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Doo mamana nau ku haea fuagamu, so ni tei na e gonitai tei gera na nau ku ooduda kou, nia ka gonitai nau naa laugo. Ma so ni tei na e gonitai nau, nia ka gonitai nia a God na e oodu nau mai laugo.>> ");
INSERT INTO llu_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","I buira Jesus e bae urinae sui, nia ka liobukonu asianaa. Ma nia ka faarongo folaa na ana fuana oote fafurongo nia gi ka urii, <<Doo mamana nau ku haea fuagamu naa. Tee wane ani gamu tara nia ka fale nau kou fuana maalimaea nau gi.>> ");
INSERT INTO llu_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ana si kada nae, na oote fafurongo gi gera ka bubu kwailiu naa fuagera, sulia langi gera si haitamana ni tei naa a Jesus e bae sulia. ");
INSERT INTO llu_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ma tee wane ana oote fafurongo nia gi baa Jesus e rakediana fuana, nia naa e gwouru garangia a Jesus. ");
INSERT INTO llu_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ma a Simon Peter ka faatainia si mamalafooa fuana fafurongo nae eeri ka ledia Jesus uria ni tei na Jesus e bae sulia. ");
INSERT INTO llu_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Na fafurongo naa ka idu garangia kou Jesus, ma ka bae toꞌou fuana ka urii, <<Lord ae, tei na wane naa o bae sulia?>> ");
INSERT INTO llu_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","A Jesus e oolisia ka urii, <<A doo baa tara nau ku taufia si beredi ana supsup, sui kuka falea fuana. Wane na nau ku aadea si doo nae fuana, nia naa na wane nae.>> Ma si kada Jesus e taufia si beredi ana supsup, sui ka falea fuana Judas wela Simon Iskariot. ");
INSERT INTO llu_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ana si kada nae ua go Judas ka ngalia si beredi naa, Satan ka ruufia. Ma a Jesus ka bae urii fuana, <<O aliꞌali fai nia si doo na o iilia.>> ");
INSERT INTO llu_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ma na fafurongo gi na gera gwouru galia na tafe ni fanga naa, gera ka lalafusia utaa naa Jesus ka bae urinae fuana Judas. ");
INSERT INTO llu_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ma sulia Judas nia na wane e aadasulia na wai malefo gera, bali ana fafurongo gi gera manata ada hasa Jesus e haea fuana Judas haia lea ka folia mai teni fanga na gera dooria fuana fangaa nae, ma langi nia lea ka ngalia mai teni doo eeri gera ka falea fuana tooa siofaa. ");
INSERT INTO llu_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Buira Judas e ngalia si fanga baa, nia ka haga aliꞌali i maa. Ma ana si kada nae nia e rodo naa. ");
INSERT INTO llu_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Si kada a Judas e lea naa, a Jesus ka bae urii, <<Si kada naa, na initooa nau, na Wela nia Iimola gi, ka faatai naa, ma na initooa nia a God ka faatai naa ani nau. ");
INSERT INTO llu_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ma lea so na initooa nia a God ka faatai naa ani nau, a God ka faatai aliꞌali ana na initooa nau ani nia i talana. ");
INSERT INTO llu_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Wela nau gi ae, nau langi kusi too tau go fai gamu. Tara muka nani uri nau, sui i nau ku haea fuagamu na doo baa gi ku haea sui naa fuana wane baita gi ana Jiu baa e urii, <Afetai muka lea ana si gula na nau ku lea ana.> ");
INSERT INTO llu_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ma na kwaieresia faalu ku falea fuagamu e urii: Muka rakediana ani gamu kwailiu, iilingia na rakediana nau fuagamu. ");
INSERT INTO llu_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ma lea so muka too ana na rakediana fuagamu kwailiu, tara na tooa gi sui daka haitamana i gamu naa na fafurongo nau gi.>> ");
INSERT INTO llu_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Sui a Simon Peter e ledia Jesus ka urii, <<Lord ae, i fai na tara oko lea uria?>> Jesus e oolisia ka urii, <<Si gula na tara nau ku lea uria, gamu langi musi haitamana lealaa fai nau. Ma buri, tara muka lea mai burigu.>> ");
INSERT INTO llu_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Sui a Peter e ledia lau urii, <<Lord ae, taa naa e aadea ka afetai fuamelu uria lealaa fai oe ana si kada naa? Sulia nau ku aade aagau uria na maelaa eeri kuka adomi oe.>> ");
INSERT INTO llu_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesus ka bae urii fuana, <<Nia e mamana oe o aade aagau uria oko mae uria adomilagulaa? Doo mamana nau ku haea fuamu. Tara oe haea oko lalafusi nau, suifetei na kakaraikua e aangi, tara oko haea o lalafusi nau sulia oolu si kada.>> ");
INSERT INTO llu_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","A Jesus ka bae urii fuana oote fafurongo nia gi, <<Langi musi manata aꞌabo ma na manatalagamu kasi asia. Muka manata mamana ana a God, ma muka manata mamana laugo ani nau. ");
INSERT INTO llu_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Si gula ni toolaa e oro i laona na beu a Maa nau. Haia, ma i nau ku lea uria na aade aagau ana si gula fuagamu. Afetai kuka haea si doo naa fuagamu, lea so e langi si urinae. ");
INSERT INTO llu_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ma i buira na nau ku lea ma kuka aade aagau ana si gula fuagamu, nau tara kuka ooli mai ma kuka talai gamu fuagu i talagu, eeri i fai na nau ku too ana, i gamu muka too laugo ana. ");
INSERT INTO llu_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ma i gamu mu haitamana go agamu na tala na e lea uria si gula na ku lea uria.>> ");
INSERT INTO llu_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ma a Tomas e bae urii, <<Lord ae, i gemelu melu lalafusia si gula na o lea uria. Tara melu ka haitamana utaa ana na tala?>> ");
INSERT INTO llu_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ma a Jesus e oolisia ka urii, <<I nau naa na Tala ma na Mamanaa ma na Mouria. E afetai ta wane so ka lea siana a God na Maa lea so e langi si lea suli nau. ");
INSERT INTO llu_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ma lea so muka haitamagu mamana naa, muka haitamana laugo na Maa nau. Ita ana si kada naa ka lea, i gamu mu haitamana naa na Maa nau ma muka riki nia naa.>> ");
INSERT INTO llu_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ma a Filip ka bae urii, <<Lord ae, gami dooria agami oko faatainia fasi na Maa fuagami.>> ");
INSERT INTO llu_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ma a Jesus e oolisia ka urii, <<Filip ae, nau ku too fai gamu ka tau naa, ma osi haitamagu ua go amu? So ni tei na e riki nau, nia e rikia naa na Maa laugo. Uria taa na oko haea hai kuka faatainia lau na Maa? ");
INSERT INTO llu_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","E utaa? Osi manata mamana go ana i nau ku too i lalo ana na Maa, ma na Maa laugo e too i lalo ani nau? Si baea naa gi na ku haea fuagamu, e langi lau na baea nau gi i talagu. Na Maa na e too ani nau naa e iilia ana na raoa nia. ");
INSERT INTO llu_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Muka manata mamana ana si doo naa, i nau ku too i lalo ana na Maa, ma na Maa e too i lalo ani nau. Lea langi, muka manata mamana ana si doo naa sulia na raoa naa gi na ku iilida. ");
INSERT INTO llu_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Doo mamana nau ku haea fuagamu, so ni tei na e manata mamana ani nau, ka iilia laugo na raoa naa gi na nau ku iilida. Ma nia ka iilia si raoa baita gi fetei, sulia i nau ku lea siana na Maa. ");
INSERT INTO llu_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","So tesi taa na muka gania siana a Maa ana hatagu, tara nau kuka iilia, eeri si kada tooa gera rikia, gera ka aada haitamana a Maa naa e baita asianaa. ");
INSERT INTO llu_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Tesi taa na muka gani nia uria sulia gamu tooa nau, tara nau kuka iilia tesi taa na mu gania.>> ");
INSERT INTO llu_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","A Jesus e bae lau ka urii, <<Lea so gamu ka rakediana ani nau, tara muka roosulia na kwaieresia nau gi. ");
INSERT INTO llu_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","I nau tara kuka gania na Maa, ma i nia tara ka falea mai na Wane kwaiꞌadomi fuagamu, ma tara nia ka too firi fai gamu. ");
INSERT INTO llu_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","I nia na Aanoedoo Aabu na e faatainia na mamanaa sulia a God. Ma na tooa gi na dasi manata mamana gera ka langi si gonitai nia go, sulia langi dasi rikia ma langi dasi haitamana go. Haia, ma ni gamu, mu haitamana, sulia i nia e too fai gamu ma ka too ani gamu. ");
INSERT INTO llu_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","<<Haia, si kada ku lea ana, afetai kuka tafusi gamu iilingia na wela iinomae gi. I nau tara kuka ooli laugo mai siagamu. ");
INSERT INTO llu_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ana si kada toꞌou go ana, na tooa gi na dasi manata mamana, tara dasi riki nau lau. Sui i gamu mone, tara muka riki nau laugo agamu. Ma sulia nau ku mouri, i gamu laugo muka mouri. ");
INSERT INTO llu_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ma ana si kada nae, tara muka haitamana i nau ku too i lalo ana na Maa nau, ma i gamu muka too i lalo ani nau, ma i nau ku too i lalo ani gamu. ");
INSERT INTO llu_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","<<Ma so ni tei na e roosulia na kwaieresia nau gi, i nia naa na wane na e rakediana ani nau. Ma so ni tei na e rakediana ani nau, na Maa nau ka rakediana laugo ani nia, ma i nau laugo ku rakediana ani nia, ma kuka faatai nau i talagu fuana.>> ");
INSERT INTO llu_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","A Judas (a Iskariot ka langi) ka soeledia ka urii, <<Lord ae, utaa na gemelu go ana na tara melu haitamana mika riki oe, haia na tooa gi na dasi manata mamana tara gera ka langi si riki oe?>> ");
INSERT INTO llu_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","A Jesus e oolisia ka urii, <<Lea so ta wane na e rakediana ani nau, i nia ka roosulia na faatolomai nau gi. Ma na Maa nau ka rakediana ani nia, ma gemere na Maa nau, mere ka lea mai siana ma mere ka too fai nia. ");
INSERT INTO llu_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ma so ni tei na e langi kasi rakediana ani nau, i nia kasi roosulia na faatolomailaa nau gi. Ma na faatolomailaa nau gi na molu rongoa e langi lau na doo nau i talagu. Sulia nia e ita mai faasia na Maa, na e oodu nau mai. ");
INSERT INTO llu_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","<<I nau ku haea si doo naa gi fuagamu ana si kada ku too ua ana fai gamu. ");
INSERT INTO llu_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Na Maa tara ka oodua mai na Aanoedoo Aabu ana hatagu eeri ka kwaiꞌadomi gomolu. Tara nia ka toolamainia na doo gi sui fuagamu, ma ka faamanatatoo gamu ana doo gi sui na ku faarongo gamu ana. ");
INSERT INTO llu_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","<<I nau ku tafusia na fanualama nau fuagamu. Na fanualama nau na ku falea fuagamu, nia langi si iilingia na fanualama i laona molaagali. Nia naa, langi musi manata aꞌabo ma langi musi mou. ");
INSERT INTO llu_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Gamu rongoa sui baa na baelagu urii, <Tara nau ku lea, ma kuka ooli laugo mai siagamu.> Lea so muka rakediana fuagu, tara muka eele sulia nau kuka lea siana Maa, sulia nia e baita ka tasa liufi nau. ");
INSERT INTO llu_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nau ku haea naa si doo naa gi suifetei ka dao mai, eeri ana si kada e dao mai ana, tara gamu kafi manata mamana. ");
INSERT INTO llu_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Nau langi kusi faarai tau lau fai gamu, sulia a Satan na wane baita ana molaagali naa, nia garangi dao na mai. Sui nia e langi kasi baita usi nau. ");
INSERT INTO llu_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ma i nau i talagu, nau kuka aadea si doo gi sui sulia si taa na Maa e haeda fuagu uria na aadelana eeri na tooa ana molaagali naa gera ka haitamana i nau ku rakediana fuana Maa. <<Haia, golu tatae, golu lea naa faasia i seegi.>> ");
INSERT INTO llu_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","A Jesus ka bae urii lau fuana na oote fafurongo nia gi, <<I nau naa na inifui ai mamana, ma na Maa nau na wane na e rao ana na raoa. ");
INSERT INTO llu_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ma i nia e haitamana ka tabalia na hare ai gi faasi nau na langi gera kasi fungu, ma ka tagasia na hare ai gi na gera fungu hai so daka fungu diana. ");
INSERT INTO llu_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Haia, ma ni gamu mu faalu sui na ana na faatolomailaa nau gi fuagamu. ");
INSERT INTO llu_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Muka too oofu fai nau, haia ma i nau kuka too oofu fai gamu. Na hare ai e afetai ka fungu i talana, lea e langi kasi too oofu ana na inifui ai. Ma ka urinae laugo ani gamu, e afetai muka iilia na doo diana gi lea so langi musi too ani nau. ");
INSERT INTO llu_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","<<I nau naa na inifui ai, ma i gamu naa na hare ai gi. Ma lea so ni tei na e too ani nau, ma i nau kuka too ani nia, nia tara haitamana ka fungu ana fufue ai oro gi. Ma lea so muka langi si too ani nau, e afetai muka iilia tesi doo diana. ");
INSERT INTO llu_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ma lea so ni tei na langi kasi too ani nau, nia e iilingia ta hare ai na da ui ania ma ka ago. Ma na hare ai urinae, daka ngalia ma daka ui ania i laona na eere ka harufia ana. ");
INSERT INTO llu_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ma lea so muka too ani nau, ma na baelagu ka too ani gamu, muka gania tesi doo na gamu dooria, ma i nau tara kuka falea fuagamu. ");
INSERT INTO llu_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ma na rao diana oro na gamu iilia, nia e faatainia na initooa a Maa nau. Ma nia na aadelana muka hau ana na oote fafurongo nau gi. ");
INSERT INTO llu_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","I nau ku rakediana ani gamu iilingia na Maa na e rakediana ani nau. Nia naa, muka too ngado i laona na rakedianaa nau. ");
INSERT INTO llu_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ma lea so muka roosulia na kwaieresia nau gi, muka too ngado i laona na rakedianaa nau, iilingia laugo nau ku roosulia na kwaieresia nia gi na Maa nau, ma ku too ngado i laona na rakedianaa nia. ");
INSERT INTO llu_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","<<Nau ku haea si doo naa fuagamu eeri muka eele asianaa iilingia na eelelaa nau. ");
INSERT INTO llu_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ma na kwaieresia nau, nia e urii: Muka rakediana ani gamu kwailiu, iilingia nau laugo na ku rakediana ani gamu. ");
INSERT INTO llu_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Langi ta rakedianalaa kasi liufia si rakedianalaa na wane na ka falea na mourilana fuana ruana nia gi eeri ka faamourida. ");
INSERT INTO llu_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ma i gamu naa na ruana nau gi, lea so gamu ka iilia na doo gi na ku eeresi gamu uria. ");
INSERT INTO llu_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Haia, i nau kusi alangi gamu lau ana na wane ni rao gi, sulia na wane ni rao e langi kasi haitamana si doo na wane baita nia e iilia. I nau ku alangi gamu ana na ruana nau gi, sulia nau ku faarongo gamu sui na ana si doo gi sui na ku rongoa mai faasia na Maa nau. ");
INSERT INTO llu_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Haia, gamu langi musi fili nau, i nau naa ku fili gamu eeri muka iilia na doo diana oro gi, iilingia na ai na e fungu ana fufue doo ka lea dongaa. Ma tara na Maa ka falea tesi doo na muka gani uria ana na hatagu. ");
INSERT INTO llu_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ma na kwaieresia nau e urii: Muka rakediana ani gamu kwailiu. ");
INSERT INTO llu_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","<<Lea na tooa i laona molaagali naa gera maasusuala ani gamu, muka manatatoona i nau naa gera maasusuala ani nau totongenao. ");
INSERT INTO llu_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Lea so ni gamu laugo gamu na tooa taꞌa i laona molaagali naa, tara gera ka rakediana ani gamu naa, sulia mu uusuli gera. Sui taa, nau ku aadafili gamu sui naa, eeri muka eꞌete faasia tooa taꞌa gi i laona molaagali. Gamu langi musi iilingi gera, ma nia naa aadea gera langi dasi doori gamu. ");
INSERT INTO llu_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Muka manatatoona taa gi baa ku haeda sui na fuagamu. Na wane rao e langi kasi baita ana wane baita nia. Haia, ma ni tei gera na gera faafii nau, gera ka faafii gamu laugo, ma ni tei gera na gera roosulia na baelagu, tara gera ka roo laugo sulia baelagamu. ");
INSERT INTO llu_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Haia, ma tara gera faafii gamu urinae sulia gamu na tooa nau. Gera ka aade urinae laugo sulia gera langi dasi haitamana a God na e oodu nau mai. ");
INSERT INTO llu_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ma lea langi kusi lea mai lao molaagali ma langi kusi faarongo gera ana urinae, langi gera si too ana aade taꞌalaa. Haia, ma ana si kada naa, nia e afetai naa fuana ni tei ka haea nia langi kasi garo, sulia nau ku lea mai ma kuka haea sui naa fuada. ");
INSERT INTO llu_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ma ni tei na e oote nia ani nau, nia ka oote nia laugo ana Maa nau. ");
INSERT INTO llu_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ma lea ni nau kusi aadea ua go mai na raoa gi na gera riki nau ku aadeda sui naa na langi ta wane lau hasa tara ka iilida, lea nia urinae, langi gera kasi too ana aade taꞌalaa. Ma ana si kada naa, sui boroi ana gera ka rikia sui na si taa na nau ku iilida, gera maasusuala gemere go a Maa nau. ");
INSERT INTO llu_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Si doo naa ka dao mai, eeri na Kekedelaa ana Kwaieresia gera gi ka mamana ana baelaa baa nia, urii, <Gera maasusuala oꞌoni go ada ani nau.> ");
INSERT INTO llu_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","<<Na Aanoedoo Aabu tara nia ka lea mai ma ka adomi gamu. Ma tara nia ka faatainia si doo mamana gi sulia a God. Tara nau ku oodua mai siagamu faasia a Maa. Ana si kada nia lea mai, nia ka ainitalo ani nau. ");
INSERT INTO llu_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Haia, ma ni gamu laugo tara muka ainitalo ani nau, sulia golu too oofu ita mai ana si kada nau ku hafalia ana raoa nau.>> ");
INSERT INTO llu_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","A Jesus e bae lau ka urii, <<Nau ku haea sui si doo naa gi fuagamu eeri na manata mamanalaa gamu ka ngasi. ");
INSERT INTO llu_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Gamu na tara gera ka lui gamu faasia la Beu Aabu ni figulaa gera gi. Ma tara nia ka dao ana si kada, lea ta wane e haumaeli gamu, nia ka manata hasa nia e iilia si doo a God e dooria. ");
INSERT INTO llu_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Tara tooa gi gera ka iilia si doo nae gi ani gamu, sulia gera langi gera si haitamana a Maa, ma langi gera kasi haitamagu laugo. ");
INSERT INTO llu_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Haia, ma ni nau ku haea naa agu si doo naa gi fuagamu eeri ana si kada gera talaꞌae iilia si doo naa gi ani gamu, tara muka manatatoona na baea nau ku haeda sui naa fuagamu.>> Jesus ka bae lau urii, <<Si doo naa gi nau langi kusi haea ua mai i nao fuagamu. Sulia nau ku too ua fai gamu. ");
INSERT INTO llu_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Haia, ana si kada nae, nau ku garangi ooli na siana a God na e oodu nau mai naa. Ka urinae boroi ana, langi ta wane agamu kasi soeledi nau ua sulia fai na tara kuka lea uria. ");
INSERT INTO llu_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ana si kada naa, na lio gamu ka bukonu asianaa, sulia nau ku haea si doo naa gi fuagamu. ");
INSERT INTO llu_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ma nau ku haea fuagamu, nia e diana asianaa fuagamu na nau tara kuka lea faasi gamu urinae. Sulia lea nau langi kusi lea, na Aanoedoo Aabu na tara ka lea mai uria na adomilamolu tara ka langi si lea go mai siamolu. Sui si kada ku lea, nau tara kuka oodua mai siagamu. ");
INSERT INTO llu_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Haia, ana si kada nia ka dao mai, nia na tara ka faatainia fuana tooa la molaagali gera manata garo sulia na aadea taꞌalaa, ma sulia na oꞌololaa, ma sulia na keketolaa. ");
INSERT INTO llu_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Gera garo sulia na aade taꞌa, sulia langi gera si manata mamana ani nau. ");
INSERT INTO llu_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ma gera garo sulia na oꞌololaa, sulia tara kuka ooli siana Maa ma langi molu si riki nau lau. ");
INSERT INTO llu_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ma gera garo sulia na keketolaa, sulia a God e ketoa naa sui wane taꞌa na e initoo usia molaagali naa. ");
INSERT INTO llu_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","<<Haia, i nau ku too ana na doo oro gi uria na haelana fuagamu, sui langi kusi haeda aata ka gulu faafi gamu ana si kada naa. ");
INSERT INTO llu_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Sui taa, ana si kada na Aanoedoo Aabu na e faatolomai ana mamanalaa e dao mai, i nia tara ka faatainia na doo gi sui fuagamu. Ma tara i nia langi kasi bae i talana, ma i nia ka bae sulia na doo gi na e rongoa faasia a God. Ma ka bae sulia si doo gi na tara ka dao mai. ");
INSERT INTO llu_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","I nia ka faaꞌinitoo nau, sulia tara nia ka ngalia na baelaa nau gi ma ka faarongo gamu ana. ");
INSERT INTO llu_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ma na doo gi sui na Maa nau, nia na doo nau gi laugo. Nia baa kuka haea tara na Aanoedoo Aabu ka ngalia mai na baelaa nau gi ma ka faarongo gamu ana.>> ");
INSERT INTO llu_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","A Jesus ka bae lau urii, <<Ana si kada totoꞌou, tara langi musi riki nau. Sui ana si kada totoꞌou laugo, tara muka riki nau lau.>> ");
INSERT INTO llu_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ma teni wane gi ana oote fafurongo gi gera ledi gera kwailiu, gera ka urii, <<Si taa na manataa ana si baelaa naa nia e haea naa, <Ana si kada totoꞌou tara langi musi riki nau, ma ana si kada totoꞌou laugo, tara molu ka riki nau lau>? Ma nia ka haea lau, <Sulia nau ku lea siana Maa.>>> ");
INSERT INTO llu_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ma na fafurongo nia gi gera ka ledi gera kwailiu lau uria, <<Taa na manataa ana si baea, <Ana si kada totoꞌou?> Golu lalafusia taa naa nia ka bae sulia.>> ");
INSERT INTO llu_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Sui a Jesus e haitamana gera dooria gera ka ledia, ma nia ka bae urii fuada, <<Gamu manata sulia baa nau ku haea, <Ana si kada totoꞌou, langi molu si riki nau. Haia, ma si kada totoꞌou laugo, tara muka riki nau lau.> Haia, si doo nae na molu ledi gomolu i talamolu uria? ");
INSERT INTO llu_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Doo mamana nau ku haea fuamolu. Tara ana si kada nae, muka aangi baita. Haia, ma tooa taꞌa ana molaagali, gera ka eele ada. Tara muka liobukonu, sui i buira, tara na liobukonulaa gamu ka sui ma tara muka eele lau. ");
INSERT INTO llu_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Gamu haitamana kada na geni e garangia faafuta, nia ka liobukonu, sulia nia dao na ana si kada ni fiilaa. Haia, si kada nia faafutaa na wela e sui, nia ka manata buro na ana si fiilaa baa sulia nia e eele na ana sulia na wela nia e futa naa. ");
INSERT INTO llu_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Gamu urinae laugo. Ana si kada nae go ana na mu liobukonu. Sui, tara nau kuka riki gamu lau, ma tara muka eele asianaa. Haia, ma si eelea naa, langi ta wane kasi bobola uria lafulaa naa faasi gamu. ");
INSERT INTO llu_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ana si kada nae, tara langi gamu si gani nau na uria tee si taa. Doo mamana nau ku haea fuagamu, so tesi doo muka gania siana a Maa ana hatagu, tara nia ka falea fuagamu. ");
INSERT INTO llu_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ita mai baa lea mai ka dao i taraꞌena, gamu langi si gania go a Maa nau ana hatagu uria tesi doo. Haia, lea doo muka gania a Maa nau, tara nia ka falea fuagamu, eeri muka eele asianaa.>> ");
INSERT INTO llu_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Jesus ka bae lau urii, <<Nau ku haea ana si doo naa gi fuagamu ana si oomelawanelaa gi. Haia, ma tara si kada ka dao mai fuana langi kusi bae ana si oomelawanelaa lau, ma tara kuka bae oꞌolo go agu sulia a Maa fuagamu. ");
INSERT INTO llu_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ana si kada nae, tara gamu i tala gamu ana na haitamana muka gania agamu i nunufana hatagu uria tesi doo. Haia, ma ni nau ku haea fuagamu tara nau langi kusi gani naa uria tesi doo fuagamu. ");
INSERT INTO llu_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Tara ka urinae naa sulia a Maa ana i talana na e rakediana fuagamu, sulia muka rakediana fuagu ma sulia mu manata mamana ana naa i nia e oodu nau mai. ");
INSERT INTO llu_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","I nao, nau ku lea mai faasia a Maa uria la molaagali naa. Haia, si kada nae, nau ku lugasia na molaagali, ma kuka ooli lau siana a Maa.>> ");
INSERT INTO llu_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Sui na fafurongo nia gi gera ka bae urii fuana, <<Ana si kada na ofi bae folaa fuagami, sulia langi osi bae ni oomelawane. ");
INSERT INTO llu_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Si kada nae, gami kafi haitamana ni oe o haitamana na doo gi sui, sulia lea ta wane langi kasi soeledi oe boro, oe haitamana si taa na e nii la manatana. Haia, ma nia na aadea mika manata mamana ana God na e oodu oe mai.>> ");
INSERT INTO llu_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ma a Jesus ka bae urii fuagera, <<Utaa? Gomolu kafi manata mamana ani nau nae? ");
INSERT INTO llu_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Haia, nia dao na ana si kada tara gamu sui muka tagala faasi nau. Ma tara muka tafi uria fera gamu gi sulia si doo na tara gera ka aadea ani nau. Sui ni nau langi kusi too taifili nau, sulia a Maa na e too fai nau. ");
INSERT INTO llu_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nau ku haea si doo naa gi fuagamu eeri muka too ana uuni diana i laona mourilagamu, sulia gamu mu too oofu fai nau, sui boroi ana muka too lao molaagali ma tara gera ka faanonifii asianaa ani gamu. Ma langi musi mou, sulia nau ku liufia sui naa na mamanaa ma na rigitaa ana molaagali naa.>> ");
INSERT INTO llu_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Si kada Jesus e bae urinae sui, nia ka aada alaa i langi, ma ka bae urii, <<Maa ae, e dao na ana si kada hai oko faaꞌinitoo nau, hai ni nau kuka faaꞌinitoo oe. ");
INSERT INTO llu_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Sulia o falea naa na mamanaa fuagu faafia na tooa gi sui hai so kuka falea na mouria firi fuada na tooa gi na o faleda fuagu. ");
INSERT INTO llu_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Haia, nia naa na mouria firi: Hai so na tooa gi daka haitamamu na tee God mamana, ma daka haitamagu a Jesus Christ na o oodu nau mai. ");
INSERT INTO llu_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","I nau ku faatainia na initooa oe i laona molaagali, ma nau ku faasuia na raoa baa na o oodu nau mai uria iililana. ");
INSERT INTO llu_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Maa ae, si kada naa, nau ku too i maamu. Oko faabaita nau ana si initooa na nau ku too mai ana fai oe i nao ana na haungailana na molaagali. ");
INSERT INTO llu_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","<<I nau ku faatolomai suli oe fuana na tooa gi i laona molaagali na oe o faleda fuagu. I gera na tooa oe gi, ma i oe o faleda fuagu mai. I gera ka roosulia na baelamu. ");
INSERT INTO llu_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ma si kada naa, gera haitamana na doo gi sui na o faleda fuagu da lea sui mai faasi oe. ");
INSERT INTO llu_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Sulia i nau ku haea fuada si baea gi na o falea fuagu, ma gera ka manata mamana naa. Ma gera ka haitamana mamana naa i nau ku lea mai faasi oe, ma daka manata mamana ana na o fale nau mai. ");
INSERT INTO llu_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","<<Ma i nau ku fooa fuada. I nau langi kusi fooa lau fuana na tooa taꞌa, ku fooa go agu fuada na tooa gi na o faleda mai fuagu, sulia i gera na tooa oe gi. ");
INSERT INTO llu_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ma si doo nau gi sui, gera na doo oe gi lau go, ma si doo oe gi sui, na doo nau gi laugo. Ma na initooa nau e faatai naa ani gera. ");
INSERT INTO llu_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","I nau kusi too tau naa i laona molaagali, i nau tara ku lea na kou siamu. Haia, ma i gera ana na da too ua i laona molaagali. Maa Aabu ae, o aadasuli gera ana na mamanaa na hatamu na hata baa o falea fuagu, hai so i gera daka hau ana tee doo iilingia ni oe ma ni nau, goro tee doo laugo. ");
INSERT INTO llu_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ma si kada baa ku too fai gera, nau ku aada suli gera ana mamanaa ana hatamu, na hata baa o falea fuagu. Ma e langi ta wane ada kasi langi ana go. Tee taifilia go na wane baa na e langi ana, hai so ka faamamanaa na Kekedelaa Aabu. ");
INSERT INTO llu_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","I nau tara kuka lea kou siamu, sui taa ku haea agu si doo naa gi ana si kada ku too ua ana i laona na molaagali, eeri gera ka eele asianaa iilingia na eelelaa nau. ");
INSERT INTO llu_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ma i nau ku falea sui naa na baelamu fuada, ma na tooa gi i laona molaagali daka maasusuala ani gera sulia na fulida e langi naa la molaagali iilingia na fuligu laugo e langi naa i laona na molaagali. ");
INSERT INTO llu_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nau langi kusi gani oe eeri oko lafuda faasia la molaagali, ma ku gani oe eeri oko suusi gera faasia na Wane Taꞌa. ");
INSERT INTO llu_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ma na fulida e langi naa i laona molaagali, iilingi na fuligu laugo e langi na la molaagali. ");
INSERT INTO llu_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Haia, oko faaabu gera fuamu ana na mamanaa. Na baelamu naa na mamanaa. ");
INSERT INTO llu_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","I nau ku oodu gera uria na faatolomailaa fuana na tooa gi, iilingia laugo o oodu nau laugo mai uria i laona molaagali. ");
INSERT INTO llu_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ma uria na dianalada, i nau ku faaabu nau i talagu fuamu, eeri ni gera laugo daka faaabu mamana gera i talada fuamu. ");
INSERT INTO llu_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Nau kusi fooa go agu fuada taifili gera. I nau ku fooa laugo fuana na tooa gi na tara gera manata mamana ani nau sulia na faarongolaa gera. ");
INSERT INTO llu_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ma i nau ku fooa hai so gera ka aalua tee doo go. Maa ae, i gera ka too i lalo ani goro iilingia laugo na o too ani nau, ma i nau ku too ani oe. I gera ka aalua tee doo, eeri na tooa na i laona molaagali gera ka manata mamana ana na o fale nau mai. ");
INSERT INTO llu_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","I nau ku falea fuada na initooa baa o falea fuagu laugo, hai so gera ka aalua tee doo iilingia i oe ma ni nau goro tee doo go. ");
INSERT INTO llu_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","I nau ku too ani gera ma ni oe oko too ani nau, eeri i gera ka tee doo teefou, ma eeri na tooa gi i laona molaagali daka haitamana naa o oodu nau mai ma o rakediana ani gera iilingia na o rakediana laugo ani nau. ");
INSERT INTO llu_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","<<Maa ae, i nau ku dooria na tooa gi na o falea fuagu daka too fai nau ana si gula na ku too ana, eeri daka rikia na initooa nau na o falea fuagu. Sulia i oe o rakediana ani nau i nao ua ana na haungailana na molaagali. ");
INSERT INTO llu_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Maa oꞌolo nau ae, sui boroi ana na tooa taꞌa gi i lao molaagali langi dasi haitamamu, i nau ku haitamamu go agu, ma na oote tooa fafurongo nau naa gi gera haitamana na o oodu nau mai. ");
INSERT INTO llu_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","I nau ku faarongo gera naa ani oe. Ma i nau kuka tasa dongaa go ana, eeri na rakedianaa oe fuagu ka too laugo i lalo ani gera ma ni nau laugo kuka too i lalo ani gera.>> ");
INSERT INTO llu_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Buira Jesus e fooa sui, nia fai nia na oote fafurongo nia gi gera haga kou, ma gera ka lea folo ana dede da alangia ana Kidron. Ma gera lea ana si gula na da aalua uria raoa ana ai gi. ");
INSERT INTO llu_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Haia, ma a Judas, na tara ka falea Jesus fuana maalimaea nia gi, nia ka haitamana naa si gula nae. Sulia kada oro Jesus fai nia na oote fafurongo gi gera lea ngado seenae. ");
INSERT INTO llu_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Nia naa a Judas ka talaia kou wane gi fuana firua faasia Rom fai nia na wane gi na gera fofolo galia na Beu Aabu a God. Na fataabu baita gi ma na Farisi gi naa da oodu gera. Haia, na tooa na da lea mai, gera dau faafia na kwesu gi ma na raunga ni firu gi. ");
INSERT INTO llu_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ma sulia a Jesus e haitamana sui na doo gi na tara ka dao ana, nia ka fali kou maasida, ma ka soeledi gera ka urii, <<Tei naa molu nanisia?>> ");
INSERT INTO llu_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Gera oolisia daka urii, <<Gemelu nanisia a Jesus, na wane baa faasia i Nasaret.>> Jesus ka bae urii, <<Nau naa.>> Haia, ma Judas na wane baa e talaida kou siana Jesus, nia e take laugo i seenae fai gera. ");
INSERT INTO llu_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ana si kada a Jesus e bae urii, <<Nau naa>>, na tooa naa gi gera dudu, ma gera ka asi gera hae gano. ");
INSERT INTO llu_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Sui a Jesus ka soeledi gera lau ka urii, <<Tei naa molu nanisia naa?>> Ma gera ka urii lau, <<Gemelu nanisia Jesus, na wane baa faasia i Nasaret.>> ");
INSERT INTO llu_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesus ka bae urii fuada, <<Nau ku haea sui na fuagamu, <Nau naa.> Lea ni nau naa na molu nanisi nau mai urinae, molu lugasia oote wane nae gi, gera ka lea ada.>> ");
INSERT INTO llu_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Jesus e haea si doo nae eeri ka faamamana si taa na nia haea sui na mai suli gera, baa nia bae urii, <<Maa ae, langi ta wane ana wane nau naa gi o faleda mai fuagu ka langi ana.>> ");
INSERT INTO llu_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ma Simon Peter e aalua tee naefe, nia ka lafia ma ka kwae ana, ma ka kwae muusia aalinga aaolo nia na wane ni rao nia na fooanigwou. Wane raoa nae hatana a Malakas. ");
INSERT INTO llu_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ma Jesus ka bae urii fuana Peter, <<O oolifainia amu na naefe na i fuilaa! Oe manata hasa tara nau langi kusi ruu laona si kada afetailaa naa a Maa nau na e falea fuagu?>> ");
INSERT INTO llu_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Sui na wane fofolo gi ma na wane ana oomea gi fai nia na wane baita gera, gera dumulia a Jesus ma daka kani faafia roo abana gi. ");
INSERT INTO llu_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ma gera ka talaia Jesus siana Anas totongenao sulia nia na fungo a Kaeafas, na fooanigwou ana fe ngali nae. ");
INSERT INTO llu_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Haia, a Kaeafas baa e haea fuana wane baita gera Jiu gi fuana tee wane ka mae usia tooa. ");
INSERT INTO llu_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Haia, Simon Peter fai nia tee fafurongo aai daaro ka lea sulia a Jesus. Haia, ruana fafurongo, na fooanigwou nae e haitama diana ana. Ma nia ka lea dongaa naa buira Jesus lea ka too mai laona labata ana luma nia na fooanigwou. ");
INSERT INTO llu_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Haia, ma Peter ka take go ana mai i maa. Sui ruana wane fafurongo naa fooanigwou e haitamana, nia ka haga kou i maa, ma ka bae fuana geni na e folo usia maa, eeri ka talaia mai Peter i lalo. ");
INSERT INTO llu_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ana si kada Peter e ruu mai, na geni naa ka bae urii fuana, <<Oe laugo boro ta wane ana fafurongo nia na wane na da ngalia mai oto naa!>> Peter oolisia ka bae urii, <<Nau e langi!>> ");
INSERT INTO llu_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Sulia si kada nae si kada ana gwagwaria, na tooa ni rao gi fai nia na wane fofolo gi, gera ka oogumaana eere ma gera ka take ada galia, ma a Peter e take laugo fai gera i seenae, ma ka faaꞌagoꞌago ana na nonina. ");
INSERT INTO llu_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Na fooanigwou e ledia Jesus ka urii, <<Tei gera na fafurongo oe gi? Haia, ma na taa gi na o faatolomai gera ana?>> ");
INSERT INTO llu_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesus e oolisia ka urii, <<Nau ku faarai sulia si doo gi sui eeri tooa gi sui gera ka rongoa. Nau langi kusi haufinia go tesi doo kada ku faatolomai nia na tooa. Nau ku iilia si doo nae sulia dani laona Beu Aabu ni figulaa gi, ma i Beu Aabu nia a God i seegi, eeri ana si kada tooa gi da oofu mai, gera ka rongoa. Haia, ma ni nau langi kusi bae aagwa go ana tesi doo. ");
INSERT INTO llu_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Uria taa na oko soeledi nau urinae? O ledia amu tooa na gera rongoa taa gi na ku haea fuada. Gera naa da haitamana taa gi na ku haea fuagera.>> ");
INSERT INTO llu_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Kada Jesus e bae urinae, tee wane ana tooa fofolo gi e lea mai ma ka fidalia, ma ka bae urii, <<Uria taa na oko bae urinae fuana fooanigwou?>> ");
INSERT INTO llu_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesus ka oolisia kou urii, <<Lea so ni nau ku haea tee si doo na nia garo, oko haea na doo na ku garo ana. Haia, ma lea langi kusi haea go tesi doo garo, e utaa naa oko fidali nau?>> ");
INSERT INTO llu_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Buira si doo naa, Anas ka oodua kou Jesus siana Kaeafas na fooanigwou. Ma na abana gi gera kani ua faafia. ");
INSERT INTO llu_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ma si kada Peter e take ma ka harangia ua ana nonina, tooa na gera take i seenae fai nia gera ka bae urii fuana, <<Oe ta wane ana oote fafurongo nia na Wane naa gera ketoa naa?>> Ma Peter e kwaigoloi ana ka bae urii, <<Langi, nau langi!>> ");
INSERT INTO llu_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ma tee wane ana wane raoa fooanigwou e too laugo seenae. Na wane naa nia na wane futa wane raoa baa a Peter e kwae muusia na aalingana, ma nia ka bae urii, <<Iiuka! Kada baa gera dumulia ana Jesus, nau ku riki oe fai nia.>> ");
INSERT INTO llu_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Peter ka bae urii, <<Langi! Langi lau ni nau naa.>> Ana si kada nae na kakaraikua ka ai naa. ");
INSERT INTO llu_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ma ana mae galogalo i ubongia, gera ka talaia kou a Jesus faasia luma a Kaeafas, daka talaia fui lao luma nia a Paelat, na wane baita ana si gula nae. Kada nae, wane baita gera Jiu gi gera ka take go ada kou i maa, sulia lea gera ruu laona luma wane na nia langi lau na wane Jiu, gera manata hasa tara gera ka bilia i maana a God. Ana si kada nae, gera dooria gera ka too faalu maasia anilanalaa na Fangaa ana Lofoagaua. ");
INSERT INTO llu_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Haia, a Paelat e haga kou siada i maa, ma ka soeledi urii, <<Uria taa na molu ka talaia mai wane na uria na ketolanalaa faafia?>> ");
INSERT INTO llu_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Gera oolisia daka bae urii, <<Wane naa nia e aadea na doo taꞌa gi na melu ka talaia mai siamu naa. Lea langi, e afetai melu ka talaia mai siamu.>> ");
INSERT INTO llu_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Paelat ka bae urii fuagera, <<Haia, lea urinae, mu talaia kou, molu ka ketoa amolu sulia na taa na kwaieresia gamu gi e haea.>> Gera ka bae urii, <<Na kwaieresi gamu gi i Rom na melu too i farana, nia e luia melu si haungia ta wane.>> ");
INSERT INTO llu_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Nia urinae, eeri ka faamamana taa gi baa a Jesus e haea sui naa sulia na maelana. Sulia na tooa faasia i Rom, gera haitamana haungilana na wane gi i fafona airarafolo. ");
INSERT INTO llu_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","A Paelat ka ooli lau uria i laona na beu nia, ma ka soe uria a Jesus, ma ka ledia ka urii, <<E utaa? I oe naa na Aaofia gera na tooa gi Jiu?>> ");
INSERT INTO llu_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ma a Jesus e ledia kou ka urii, <<E utaa? Si ledilaa naa e lea mai faasi oe i talamu, langi teni tooa aai gi na da faarongo oe ani nau?>> ");
INSERT INTO llu_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ma a Paelat e bae lau ka urii, <<E utaa? I oe o manata hasa i nau na wane i Jiu naa? Na tooa oe gi ana i talada ma na fataabu baita gi naa da talai oe mai siagu. Na taa taꞌa na o iilia?>> ");
INSERT INTO llu_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ma a Jesus e oolisia ka urii, <<Na initooa nau e langi lau laona molaagali naa. Ma lea so na initooa nau na doo laona molaagali, na tooa nau gi daka firu usi nau faasia na falelagu fuada na wane naonao gi i Jiu. Na initooa nau e langi lau na doo i seenaa.>> ");
INSERT INTO llu_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ma a Paelat e ledi nia ka urii, <<E utaa? I oe ta aaofia naa?>> Ma a Jesus e oolisia ka urii, <<I oe naa o haea i nau na aaofia. I nau ku futa ma kuka dao mai i laona na molaagali naa uria tee si doo go, uria na baelaa sulia na mamanaa. Haia, so ni tei na e dooria na doo mamana, i nia ka fafurongo nau.>> ");
INSERT INTO llu_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Sui a Paelat ka ledia lau urii, <<Ma na taa naa na mamanaa?>> Haia, a Paelat ka ooli lau i maa siana tooa, ma ka bae urii fuagera, <<Nau langi kusi daotoona tesi taꞌalaa ana wane naa. ");
INSERT INTO llu_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ma sulia na malutaa gamu, nau kuka lukea tee wane fuagamu ana kada ana Fangaa ana Lofoagaua. Haia, utaa? Gomolu dooria nau kuka lukea na aaofia gamu Jiu gi?>> ");
INSERT INTO llu_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ma gera ka rii baita gera ka bae urii, <<Langi! Na wane naa, langi osi lukea! Gemelu dooria oko lukea mai a Barabas!>> Haia, a Barabas nia naa wane bebeli. ");
INSERT INTO llu_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Sui a Paelat ka falea Jesus fuada wane ana oomea gi, ma ka haea gera ka rabusia baita. ");
INSERT INTO llu_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ma gera ka erea na eregwou ana torakaukau, ma gera ka aalua i ketena Jesus. Sui gera ka faaruufia ana maku kekeroa, iilingia ta aaofia. ");
INSERT INTO llu_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Sui gera ka lea mai siana ma daka urii, <<Ni oe naa na aaofia gera Jiu gi!>> Ma gera ka fidalia. ");
INSERT INTO llu_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ma a Paelat e haga lau kou siana tooa oro na gera figu, ka bae urii, <<Nau tara ku ngalia mai wane naa siagamu, eeri muka haitamana nau langi kusi rikia go tesi taꞌalaa ani nia.>> ");
INSERT INTO llu_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Sui, a Jesus ka haga mai maa, ma ka too ana na eere gwou ana torakaukau ma na maku kekeroa. Ma Paelat ka bae urii fuada, <<Aada fasi na wane naa!>> ");
INSERT INTO llu_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ma ana si kada fataabu baita gi ma na wane fofolo usia Beu Aabu a God gera rikia, gera kafi rii baita lau ma daka urii, <<Oko haungia! Fotoia i fafona airarafolo!>> Paelat ka bae urii, <<Haia, lea urinae, molu ngalia, muka fotoia fafona airarafolo. Haia, ma ni nau, nau langi kusi daotoona tesi taꞌalaa ani nia.>> ");
INSERT INTO llu_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Tooa gi gera ka bae urii fuana a Paelat, <<Gemelu too ana kwaieresia fuana wane urii nia ka mae. Sulia i nia e haea nia na wela a God.>> ");
INSERT INTO llu_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Si kada a Paelat e rongoa doo naa, nia ka mou asianaa liufia naa i nao. ");
INSERT INTO llu_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ma nia ka ooli lau i beu ka soeledia a Jesus ka urii, <<Oe wane faasia i fai naa?>> Ma Jesus langi kasi haea go tesi doo. ");
INSERT INTO llu_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","A Paelat ka bae lau urii fuana, <<Utaa? Oe langi osi dooria go baelaa fai nau? Oe langi si haitamana go, i nau ku too ana mamanaa uria haelana gera ka luke oe, langi gera ka haungi oe i fafona airarafolo?>> ");
INSERT INTO llu_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","A Jesus e oolisia ka bae urii, <<Nia mamana ni oe o too ana mamanaa fuana oko iili urinae ani nau. Haia, ma a God naa e falea na mamanaa nae fuamu. Nia naa, na wane na nia fale nau fuamu nia aadea si doo e taꞌa ka tasa.>> ");
INSERT INTO llu_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ana si kada Paelat e rongoa baelana Jesus, nia ka nani uria tesi doo nia ka aadea eeri ka lukea. Sui na Jiu gi gera rii baita gera ka urii, <<Lea o lukea wane naa, oe langi osi bali fai nia na aaofia i Rom. Sulia lea ta wane haea nia na aaofia, nia suusia na aaofia i Rom.>> ");
INSERT INTO llu_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Kada Paelat e rongoa baelaa nae gi sui, nia ka talaia kou Jesus i maa, ka gwouru ana si gula ni keketolaa na da alangia ana <<Taetae ana fou>>, ma na baelaa Hebru <<Gabata>>. ");
INSERT INTO llu_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ma maedani ana maleoa fe dani naona Fangaa ana Lofoagaua, ma e dao naa i aasoa. Ma Paelat ka bae urii fuana tooa, <<Aada fasi na aaofia gamu.>> ");
INSERT INTO llu_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ma na tooa gi gera rii daka bae urii, <<Haungia! Haungia! Fotoia ana airarafolo!>> A Paelat e ledi gera lau ka urii, <<Utaa? Na aaofia gamu na gamu dooria kuka fotoia ana airarafolo?>> Ana si kada nae, na fataabu baita gi daka oolisia urii, <<Nia langi lau na aaofia gami. Taifilia tee aaofia na i Rom go na aaofia gami!>> ");
INSERT INTO llu_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ma Paelat ka falea Jesus fuana tooa ana oomea eeri gera ka fotoia ana airarafolo. Ma gera ka talaia na a Jesus naa kou. ");
INSERT INTO llu_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ma nia ka lea ka toolua na airarafolo nia i talana uria si gula na hatana Golgota ana baelaa gera Jiu gi. (Na malutana hatana gula baa e <<Na Lelete>>.) ");
INSERT INTO llu_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ma i seenae gera ka fotoia ana airarafolo. Ma roo wane laugo da fotoia i seenae, tee wane ana taa bali ma tee wane ana ta bali, ma Jesus ka too ana airarafolo na e take i lalo. ");
INSERT INTO llu_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ma a Paelat e kedea si mamalafooa ma daka aalua i gwouna airarafolo a Jesus. Na baea nae gi nia kedea e urii, <<Jesus faasia i Nasaret, Aaofia gera Jiu gi.>> ");
INSERT INTO llu_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Si gula na gera aalua ana airarafolo na gera fotoia ana Jesus langi kasi too tau go faasia i Jerusalem maefera gera Jiu gi. Ma na tooa oro ana Jiu gi gera iidumia si mamalafooa naa. Haia, ma si mamalafooa na laugo gera ka kedea ana oolu baelaa eꞌete gi. Baelaa gera Jiu gi, baelaa gera Rom, ma na baelaa gera Gris gi. ");
INSERT INTO llu_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ma na fataabu baita gi gera ka bae urii fuana Paelat, <<Langi osi kedea <Aaofia gera Jiu gi>! O kedea urii, <Nia i talana ana na e haea, i nau na Aaofia gera Jiu gi>>>. ");
INSERT INTO llu_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Sui a Paelat e oolisida ka bae urii, <<Si taa na ku kedea sui naa, nia ka too na ana urinae.>> ");
INSERT INTO llu_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ma i buira na tooa ana oomea gi gera fotoia a Jesus i fafona airarafolo sui, gera ka ngalia na maku nia gi, ma gera ka tolingi ana fai doo fuana na fai wane ada. Ma na maku ruruu baita nia, na e langi ta mae tailaa ana, gera fao loulou go ada ana. ");
INSERT INTO llu_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ma na wane ana oomea gi gera ka bae urii fuagera kwailiu, <<Golu langi si kari nagalana lau si maku naa. Golu daisi uria, lea ni tei na daisi e dao siana nia naa ka ngalia.>> Nia e urinae eeri ka faamamana na Kekedelaa Aabu baa nia urii, <<Gera tolinigia na maku nau gi fuada, ma gera ka daisi uria si maku ruruu nau.>> Si doo naa gi na wane ana oomea gi gera aadea. ");
INSERT INTO llu_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Tei gera na gera take i aena airarafolo a Jesus, ni tee nia Jesus, ma na haasina tee nia Jesus, ma ni Mary afe a Klopas, fai nia ni Mary faasia Magdala. ");
INSERT INTO llu_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Haia, ma na fafurongo baa a Jesus e rakediana fuana, nia take laugo i seenae fai nia ni tee nia a Jesus. Si kada Jesus e rikia ni tee nia fai nia wane fafurongo na nia rakediana fuana daaro take garangia, nia ka bae urii fuana ni tee nia, <<Tee ae, na wela oe naa.>> ");
INSERT INTO llu_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Sui, nia ka bae urii lau fuana wane fafurongo nae, <<Nia naa ni tee oe.>> Ma e hafali ana kade hato nae, na wane fafurongo nae ka talaia naa ni tee nia Jesus fui luma nia uria aadasulilana. ");
INSERT INTO llu_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","I buira si doo naa gi sui, Jesus ka haitamana na raoa nia gi e sui teefou naa. Ma nia ka faamamana na Kekedelaa Aabu ana baelaa nia urii, <<Nau ku maeligwou.>> ");
INSERT INTO llu_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ma ana si gula nae gera aalua tee tiu e fungu ana waen afae. Ma gera ngalia tesi fulo, ma gera ka haufia lao tiu i waen naa, sui gera ka aalua maana si ai, sui gera ka falea uria fakana Jesus. ");
INSERT INTO llu_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ana si kada Jesus e gwoufia sui, nia ka bae urii, <<Sui naa.>> Buira nia haea si baea nae gi sui, gwouna ka asikuleu ma kafi mae. ");
INSERT INTO llu_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ma i buira si doo naa gi sui, tooa baita gera Jiu gi gera lea mai ma gera ka soeledia Paelat haia ka faalamaini fuana wane ana oomea gi gera ka lea daka oia na aeda oolu wane nae gi gera fotoida ana airarafolo gi, eeri gera ka mae aliꞌali. Sulia gera dooria daka lafua na nonida faasia na airarafolo gi ana fe dani nae. Sulia fe dani naa fe dani ni aade aagaulaa gera Jiu gi maasia maedani Sabat. Ma langi dasi dooria wane mae gi gera ka kulu ana airarafolo ana dani Sabat. Sulia na dani Sabat nae nia na tofungana maedani gera Jiu gi. ");
INSERT INTO llu_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Haia, na wane ana oomea gi da lea mai, gera ka oia aena roo wane aai baa gi na da fotoia i fafona airarafolo gi. ");
INSERT INTO llu_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ma ana si kada gera dao siana Jesus, gera ka daotoona nia e mae sui na ana. Nia naa, langi gera kasi moꞌoia lau na aena Jesus. ");
INSERT INTO llu_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Sui ka urinae boro, tee wane ani gera naa e dooria ka faamamana diana ana, nia ka ngalia sua, ma ka labua ana gagarona Jesus. Ma gera ka rikia na abu ma na kafo e iigwa mai. ");
INSERT INTO llu_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Nau ku rikia si doo naa, ma kuka uunuunu sulia eeri gamu sui muka manata mamana laugo. Si taa naa nau ku haea nia mamana, ma kuka haitamana na baelagu nia mamana naa. ");
INSERT INTO llu_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ma si doo nae gi e urii nae, eeri ka faamamanaa si Kedelaa Aabu baa nia bae urii, <<Tesi ogi ana si moꞌoi.>> ");
INSERT INTO llu_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ma ta bali Kekedelaa Aabu laugo nia urii, <<Tara na tooa gi gera ka bubungia na wane na gera labua na nonina.>> ");
INSERT INTO llu_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ma i buira si doo naa gi, a Josef na wane faasia i Arimetea, nia lea mai ka gania Paelat uria nonina Jesus eeri ka ngalia. A Josef baa, nia ta wane fafurongo a Jesus laugo, sui taa e haufini naa, sulia e mou ana na wane baita gera Jiu gi. Haia, a Paelat ka faalamainia, ma nia e lea mai ka ngalia. ");
INSERT INTO llu_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ma Nikodimas baa na e lea siana Jesus lao rodo i nao baa, nia ka lea fai nia Josef, ma ka ngalia fai aakwala kilo ana doo moko diana gi fuana aalulana fai nia nonina wane mae. Na hatana doo na <<mira>> fai nia <<alos>>. ");
INSERT INTO llu_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Roo wane naa gi daaro ka ngalia nonina Jesus, ma daaro ka afua ana si maku kwakwaoa diana fai nia na doo moko diana nae gi. Gera aadea si doo naa sulia malutaa gera Jiu gi ana aade aagaulaa ana wane mae uria aalulana laona kwaingeia. ");
INSERT INTO llu_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Haia, ma ana si gula na gera haungia ana Jesus, na raoa e ni seenae, gula gera fasia ana ai gi. Haia, ma tee kwaingeia e too laugo ana si gula nae uria aalulana nonina wane mae. Ma na kwaingeia nae na doo faalu go ana, langi gera si aalua ua ta wane i laona. ");
INSERT INTO llu_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ma ana si kada nae fe dani gera Jiu gi uria aade aagaulaa maasia maedani Sabat. Ma fe dani Sabat nia garangi naa. Ma roo wane nae daaro lea, daaro ka aalua nonina Jesus i laona kwaingeia nae, sulia nia too garangi go ana. ");
INSERT INTO llu_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","I ofaidani ana na Sandei si kada rodo ua, ni Mary faasia Magdala e lea i maana na kwaingeia ma ka rikia na fou baa gera aalua usia na maana, e lafu naa. ");
INSERT INTO llu_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ma nia ka lalao aliꞌali siana a Simon Peter ma na wane fafurongo baa a Jesus e rakediana ana, ma ka bae urii fuadaaro, <<Teni wane gi da ngalia naa na noina a Lord faasia na kwaingeia, ma melu ka lalafusia naa i fai na gera aalua ana.>> ");
INSERT INTO llu_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Sui a Peter ma na wane fafurongo aai baa, daaro ka lea naa uria i kwaingeia. ");
INSERT INTO llu_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ma daaro ka lalao, sui ma na wane fafurongo aai baa na e lalao aliꞌali ka liufia a Peter, ma ka dao ana i maana kwaingeia i nao. ");
INSERT INTO llu_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","I nia e agwaaro, ma ka rikia na maku kwakwaoa baa gi, sui ma langi kasi ruu go i laona. ");
INSERT INTO llu_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ma a Simon Peter e dao mai i buri, ma ka lea olosia naa uria i laona na kwaingeia. I nia ka rikia na maku kwakwaoa baa gi e too go ana i seenae, ");
INSERT INTO llu_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","fai nia si maku baa gera afua ana ketena a Jesus. Si maku nae e langi kesi too go fai nia na maku kwakwaoa nae gi, sulia gera eegwea naa, ma nia e too taifilia. ");
INSERT INTO llu_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ma i buri, na wane aai baa na e dao i maana kwaingeia i nao, ka ruu laugo. I nia e rikia ma ka manata mamana ana. ");
INSERT INTO llu_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ma daaro ka langi daaro si haitamana ua na Kekedelaa Aabu baa e haea hasa i nia tara nia ka mouri lau faasia na maea. ");
INSERT INTO llu_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ma i buira si doo naa, na roo fafurongo naa gi daaro ka ooli na adaaro. ");
INSERT INTO llu_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ma ni Mary ka take ua i maa na kwaingeia, ma ka aangi go ana. Ma ana si kada nia aangi ana, nia agwaaro ka aada kou laona kwaingeia. ");
INSERT INTO llu_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ma nia ka rikia na roo ensel gi daaro ruufia maku kwakwaoa. Ma na roo ensel nae gi daaro gwouru ana si gula na nonina Jesus e teo ana i nao, ta doo ana si gula na ketena e too ana ma ta doo ana si gula na aena gi e too ana. ");
INSERT INTO llu_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Roo ensel nae gi daaro ka soeledia ni Mary urii, <<Geni ae, uria taa na oko aangi?>> Ma nia e oolisida ka urii, <<Na nonina Lord nau naa, gera ngalia faasia see, ma i nau ku lalafusia i fai naa gera aalua ana.>> ");
INSERT INTO llu_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Buira nia bae urinae sui, nia ka kariabulo ma ka rikia tee wane ka take go ana, ma nia langi kasi aada haitamana wane naa nia a Jesus go ana. ");
INSERT INTO llu_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ma Jesus ka soeledi nia ka urii, <<Geni ae, uria taa na oko aangi? Ma ni tei naa o nanisia?>> Ma ni Mary e manata ana hasa ta wane na e aadasulia na raoa nae. Ma nia ka urii fuana, <<Wane baita ae, lea ni oe naa o ngalia kou na nonina Lord nau, nau ku dooria o faarongo nau ana i fai na o aalua ana, eeri kuka lea ngalia agu.>> ");
INSERT INTO llu_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Sui, a Jesus ka bae urii fuana, <<Mary ae!>> Ma ni Mary e kari aabulo, ma ka aada kou, ma ka aada haitamana, ma ka bae urii fuana, <<O Raboni ae!>> Haia, ma ana baelaa nae gera Jiu gi ana baelaa na <<Raboni>>, si manata ana <<Wane Faatolomai>>. ");
INSERT INTO llu_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Haia, ma Jesus ka bae urii fuana, <<Langi osi hamosi nau, sulia nau kusi ooli ua siana na Maa i langi. O ooli siana na haasigu gi, oko faarongo gera, tara nau ku ooli naa siana Maa nau ma na Maa gera. Nia naa a God nau ma a God gera.>> ");
INSERT INTO llu_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Sui ni Mary faasia Magdala ka ooli, ma ka faarongo ana oote fafurongo gi ana na nia e rikia a Lord. Ma ni Mary ka uunuunu laugo siada sulia si taa gi na Jesus e haea fuana. ");
INSERT INTO llu_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Haia, i haulafi ana na Sandei, na oote fafurongo gi da oofu i laona tee luma, ma daka bilakea na maa gi usi gera, ma daka sabia laugo na maa gi, sulia da mou ana na wane baita gi ana tooa i Jiu. Ma a Jesus e faatai ka take i matangada. I nia ka bae urii, <<Si fanualama ka too fai gamu.>> ");
INSERT INTO llu_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ma i buira na e haea si baea naa, nia ka faatainia na roo abana gi ma na gagarona fuada. Ma na oote fafurongo gi daka eele asianaa si kada gera rikia a Lord. ");
INSERT INTO llu_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ma a Jesus ka bae urii lau fuada, <<Na fanualama ka too fai gamu. Iilingia na Maa e oodu nau mai, nau ku oodu gamu laugo.>> ");
INSERT INTO llu_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","A Jesus e haea si baea naa, sui ka ufu faafi gera ma ka bae urii, <<Muka ngalia na Aanoedoo Aabu. ");
INSERT INTO llu_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Lea molu manata lukea na aade taꞌalaa na tooa gi, tara a God ka manata lukeda. Ma lea molu si manata lukeda, a God ka langi si manata lukeda.>> ");
INSERT INTO llu_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ma tee wane ada na aakwala ma roo wane fafurongo gi na hatana a Tomas na gera alangia ana na Iu, e langi kesi too fai gera ana si kada na a Jesus e dao ana. ");
INSERT INTO llu_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ma na oote fafurongo gi na da too, daka bae urii fuana a Tomas, <<I gemelu melu rikia a Lord.>> Sui a Tomas ka bae urii fuada, <<Lea so ku rikia na kida baa gi i fuilaa na nila gi i abana, ma ku hamotoona na kida nae gi, ma ku ruungainia na kakauna abagu i laona na mae doo baa i gagarona taari, kufi manata mamana ana. Ma lea langi kusi iilia go na doo nae, nau langi kusi manata mamana ana.>> ");
INSERT INTO llu_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ma ana fiuna fe dani i buri, na oote fafurongo baa gi da figu laugo i laona na beu baa, ma a Tomas e too naa fai daalu. Ma gera da sabia na maa gi laugo. Sui a Jesus e faatai mai, ma ka take i matangada, ma ka bae urii, <<Si fanualama ka too fai gamu.>> ");
INSERT INTO llu_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Sui a Jesus ka bae urii fuana a Tomas, <<Tomas ae, o aalua na kakaumu i seenaa, ma oko rikia na roo abagu gi. Sui oko tekwalaa mai na abamu ma oko ruungainia na kakaumu i laona mae maala naa i gagarogu. O aalua na manata halalaa, ma oko manata mamana!>> ");
INSERT INTO llu_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ma a Tomas e oolisia ka urii, <<I oe na Lord nau ma a God nau.>> ");
INSERT INTO llu_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ma a Jesus ka bae urii fuana, <<Ni oe o manata mamana go amu sulia o riki nau. Ka oilakea fuana ni tei gera na langi dasi riki nau, ma daka manata mamana go ada ani nau.>> ");
INSERT INTO llu_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Si doo kwaibalatana oro gi na a Jesus e iilia lau i maana na oote fafurongo nia gi, e langi kusi kedea go i laona buka naa. ");
INSERT INTO llu_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Nau ku kedea na doo naa gi eeri muka manata mamana ana a Jesus naa na Christ na wane baa a God e filia uria aaofialaa, ma i nia naa na Wela nia a God. Ma hai so muka too ana na mouria firi i nunufana a Jesus, sulia na manata mamanalaa gamu gi. ");
INSERT INTO llu_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","I buri doo naa, a Jesus ka faatai lau fuada na oote fafurongo nia gi i ninimana na aasi i Taebirias. Ma si doo nae e fuli urii: ");
INSERT INTO llu_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","A Simon Peter, ma a Tomas na da alangia ana na Iu, ma a Nataniel na wane faasia i Kena i Galili, ma na roo wela nia gi a Sebedi, ma na roo wane fafurongo gi lau, da oofu. ");
INSERT INTO llu_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ma a Simon Peter ka bae urii fuada na oote wane nae gi, <<I nau ku lea dee agu naa.>> Ma i gera haea fuana daka urii, <<I gemelu laugo melu ka lea mai fai oe.>> Haia, gera lea, daka taelia na baru. Sui, ana fe rodo nae e langi dasi kwaia go tee gwe iia. ");
INSERT INTO llu_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ma ofaidani, a Jesus ka take naa i ninimana na aasi. Ma na oote fafurongo nia gi langi dasi aada haitamana go. ");
INSERT INTO llu_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Sui a Jesus ka soe kou fuada ka urii, <<Oote wane ae, utaa? Gomolu molu kwaia ta iia?>> Ma gera ka oolisia urii, <<Langi go!>> ");
INSERT INTO llu_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ma i nia ka bae urii, <<Molu asia na furai gomolu i bali aaolo ana na baru, ma tara molu ka kwaia teni gwe iia.>> Ma gera ka asia na furai, ma ka afetai naa uria na kwailana sulia na iia e oro asianaa. ");
INSERT INTO llu_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Sui na fafurongo baa a Jesus e rakediana ana, ka bae urii fuana a Peter, <<A Lord loko!>> Ma si kada a Simon Peter e rongoa si doo naa, nia ka oofi ana na maku tekwa nia, sulia nia e lafua na ana na maku nia, ma ka aru la kafo, ma ka aaranga uria hara. ");
INSERT INTO llu_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ma na oote fafurongo aai gi daka lea na mai i hara ana na baru. Ma daka lafia naa na furai na e fungu ana iia, sulia gera langi dasi too tau go faasia i hara, e bobola go ana fai nia tee talange fe fale aelaa faasia i hara. ");
INSERT INTO llu_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ma si kada gera sifo i hara, daka rikia tee eere e talafa naa fai nia naa iia i laona fai nia teni fe beredi gi laugo. ");
INSERT INTO llu_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ma a Jesus ka bae urii fuada, <<Molu ngalia mai teni gwe iia gi ana iia na molu kwaida.>> ");
INSERT INTO llu_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","A Simon Peter e lea kou i laona na baru, ma ka lafia mai na furai nae i hara. Na furai nae e fungu ana na iia baita gi sui go, tee talange ma lima aakwala ma oolu gwe iia. Sui boroi ana na iia ka oro urinae i laona na furai, na furai nae kasi foga go. ");
INSERT INTO llu_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ma a Jesus ka bae urii fuada, <<Molu lea mai, molu ka fanga amolu.>> Sui langi ta wane ada kasi ledia go urii, <<I oe ni tei naa?>> Sulia gera haitamana go ada i nia a Lord. ");
INSERT INTO llu_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ma a Jesus e fali kou siana na beredi, ma ka falea fuada na oote fafurongo nia gi, ma ka aade urinae laugo ana gwe iia gi. ");
INSERT INTO llu_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Nia naa na ooula si kada na a Jesus e faatai ana fuada na oote fafurongo nia gi i buira na e tatae faasia na maea. ");
INSERT INTO llu_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ma si kada da fanga sui na ana, a Jesus ka bae urii fuana a Simon Peter, <<Simon na wela a John ae, oe o rakediana ani nau ka liufia na fafurongo naa gi da rakediana ani nau?>> Ma i nia e oolisia ka urii, <<Iiuka, Lord. I oe o haitamana go amu na ku rakediana ani oe.>> Ma a Jesus ka bae urii fuana, <<Oko aadasulia na gale sipsip nau gi.>> ");
INSERT INTO llu_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ma a Jesus ka bae urii lau fuana ana ruana si kada, <<Simon na wela nia a John ae, oe o rakediana ani nau?>> Ma i nia e oolisia ka urii, <<Iiuka, Lord. I oe o haitamana go amu na ku rakediana ani oe.>> Sui a Jesus ka bae urii fuana, <<Oko aadasulia na sipsip nau gi.>> ");
INSERT INTO llu_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ma a Jesus ka bae urii lau ana ooluna si kada, <<Simon na wela nia a John ae, oe o rakediana ani nau?>> Ma a Peter ka liodila naa, sulia a Jesus e ledi nia ana ooluna si kada ka urii, <<Oe o rakediana ani nau?>> Ma a Peter ka bae urii fuana, <<Lord ae, i oe naa o haitamana na doo gi sui, ma oko haitamana go amu na nau ku rakediana ani oe!>> Ma a Jesus ka bae urii fuana, <<Oko aadasulia na sipsip nau gi. ");
INSERT INTO llu_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Doo mamana nau ku haea fuamu, si kada o daraa ana, o oofi amu i talamu ma oko lea amu i talamu ana si gula na o doori lea uria. Sui ana si kada tara o waro ana, oe oko tekwala na abamu gi, ma ta wane eꞌete naa ka kani faafi oe, ma ka talai oe kou uria si gula taa na e langi osi doori lea uria.>> ");
INSERT INTO llu_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","A Jesus e haea si doo naa, eeri ka faatainia na maelaa na tara a Peter ka mae ana, na ka faaꞌinitooa ana a God. Sui a Jesus ka bae urii fuana, <<O lea mai i burigu.>> ");
INSERT INTO llu_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ma a Peter e kariabulo, ma ka rikia na fafurongo baa na a Jesus e rakediana fuana. Nia wane na e gwouru garangia Jesus si kada gera fanga, ma ka ledia urii, <<Lord ae, tei naa tara ka fale oe fuana na maalimaea oe gi?>> ");
INSERT INTO llu_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Haia, ana si kada a Peter e rikia, nia ka ledia a Jesus urii, <<Lord ae, taa naa tara ka dao ana wane nae?>> ");
INSERT INTO llu_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","A Jesus e oolisia ka urii, <<Sui boroi ana lea so nau ku dooria na wane naa ka mouri ana lelea kuka ooli mai, haia si doo na langi lau si doo fuamu. Ma ni oe, o lea mai amu suli nau.>> ");
INSERT INTO llu_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Haia, na uunuunu ka tagala fuana na fafurongo a Jesus gi. Gera haea na fafurongo nae tara nia ka langi si mae. Haia, ma Jesus langi kasi haea tara wane na langi kasi mae. Nia bae urii go ana baa, <<Sui boroi ana lea so nau ku dooria na wane naa ka mouri ana lea ka dao ana si kada nau ku ooli mai, haia si doo naa langi lau si doo fuamu.>> ");
INSERT INTO llu_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Haia, na fafurongo na Peter e soeledia Jesus sulia naa, nia naa e uunuunu sulia doo naa gi sui naa, ma ka kededa. Ma gemelu haitamana si taa gi na nia bae sulia nia e mamana naa. ");
INSERT INTO llu_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Si doo oro gi lau a Jesus e aadeda. Ma lea so gera ka kekede teefou, nau ku manata na molaagali naa boro langi kasi bobola fuana aalulanalaa na buka gi na da kedea doo nae gi i laona.");
INSERT INTO llu_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","A Tiofilas ae, i laona kekedelaa nau baa totongenao, nau ku kekede sulia si doo baa gi sui na a Jesus e iilida ma ka faatolomainia, hafali mai ana si kada nia talaꞌae ana raolaa nia, ");
INSERT INTO llu_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","lea ka dao ana fe dani baa a God e ngali nia uria i langi. Ma suifetei nia kafi tae uria i langi, i nia ka falea si baelaa fifii gi ana mamanaa nia na Aanoedoo Aabu, fuada na wane gi na nia e filida fuana aposol nia gi. ");
INSERT INTO llu_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Haia, fai aakwala fe dani buira na maelana lau, ana si kada oro gi nia ka faatainia i talana fuada na aposol gi, ma nia ka iilia si doo gi hai ka faamamana nia e mouri. Gera ka riki nia, ma nia ka faarai fai gera sulia na Initooa a God. ");
INSERT INTO llu_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ma ana si kada gera oofu ana, a Jesus ka falea na kwaieresilaa naa fuada ka urii, <<Langi molu si tafusia i Jerusalem. Molu maasia na falelaa na a Maa nau e bae aalualu ana, ma molu ka rongoa ku bae sui na mai sulia. ");
INSERT INTO llu_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","A John e siuabua na tooa gi ana kafo, ma e langi kasi tau, tara muka siuabu ana na Aanoedoo Aabu.>> ");
INSERT INTO llu_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ma ana si kada na aposol gi da oofu lau fai nia a Jesus, gera ka soeledia daka bae urii, <<Lord ae, tara si kada taa naa oko oolifainia na initooa fuana na tooa i Israel gi?>> ");
INSERT INTO llu_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ma a Jesus e oolisida ka urii, <<Langi lau na doo fuagamu uria na haitamalana fe dani gi ma si kada gi urinae, sulia a Maa nau na ana e aalua sui na ana si kada fuana doo naa gi ka dao mai. ");
INSERT INTO llu_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Haia, i gamu mone, tara muka ngalia na mamanaa si kada na Aanoedoo Aabu ka dao mai faafi gamu. Ma tara muka uunuunu suli nau seegi i Jerusalem, ma ana fera gi sui i Judea ma i Samaria, ma ka dao mai ana fera gi sui laona na molaagali.>> ");
INSERT INTO llu_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ma i buira nia e haea si doo naa gi sui, a God ka ngali nia uria i langi. Ma si kada gera bubu ua go ada, si barobaro ka haufini nia naa faasi gera. ");
INSERT INTO llu_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ma si kada gera da aada alaa ua go ada fui langi si kada e lea ana, na roo wane da oofi ana maku kwakwaoa gi aliꞌali mai daaro ka take naa siada. ");
INSERT INTO llu_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ma daaro ka bae urii fuada, <<Gamu tooa i Galili gi, utaa naa mu take go agamu i seenaa ma muka aada alaa go agamu fua la mamangaa? A Jesus naa na a God e ngalia faasi gamu uria i langi, tara nia ka ooli laugo mai iilingia na molu rikia e tae uria i langi.>> ");
INSERT INTO llu_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Sui na aposol gi gera ka ooli fui i Jerusalem faasia gwouna fe tolo na da alangia ana Olivtri, na e bobola fai nia tee kilometer faasia Jerusalem. ");
INSERT INTO llu_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ma si kada gera dao ana i Jerusalem, gera ka raa uria na kade luma na gera too ana. Ma na hatana na wane nae gi: a Peter, ma a John, ma a James, ma a Andrew, ma a Filip, ma a Tomas, ma a Batolomiu, ma a Matthew, ma a James na wela a Alfeas, ma a Simon na wane ana na bare wane baa da dooria na tarilana na wane gi ana tooa i Rom gi, ma a Judas na wela nia a James. ");
INSERT INTO llu_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Haia, gera oofu nae iilingia gera iilia sulia dani uria na fooalaa oofu fai nia teni geni gi laugo ma ni Mary na tee nia a Jesus, fai nia na haasina a Jesus gi. ");
INSERT INTO llu_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ma e langi kasi tau, na tooa da manata mamana gi gera ka oogu mai. Ma gera bobola fai nia talange iimola ma roo aakwala. Ma a Peter e take ka bae urii fuada, ");
INSERT INTO llu_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","<<Oote waihaasi nau gi, afetai na Kekedelaa Aabu sulia a Judas ka langi si fuli, sulia na Aanoedoo Aabu e bae ana David sulia a Judas, na wane baa e talaia na tooa baa gi uria dumulilana Jesus. ");
INSERT INTO llu_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Haia, a Judas nia ta wane ani golu, sulia a Jesus e aadafili nia laugo uria iililana na raoa naa fai golu.>> ");
INSERT INTO llu_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(A Judas baa e ngalia si malefo baa uria na aade taꞌalaa nia, ma ka folia ana si gano. Ma ana si gano nae, nia asi nia, ma ka mae, ma ka foga i oogotouna ma na oogona ka busu tafa i maa. ");
INSERT INTO llu_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ma na tooa gi na gera too i Jerusalem daka rongoa taa na e aadea Judas, ma gera ka alangia si gano nae ana baelaa gera <<Akeldama>>. Haia, na malutana si baelaa nae <<Gano ana Abu>>.) ");
INSERT INTO llu_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ma a Peter e bae lau ka urii, <<Iilingia baa gera kedea laona buka Sam gi nia urii, <Na luma nia ka gwou ma langi dasi faalamainia ta wane haia ka too i laona.> Haia, ma tesi kekedelaa laugo nia urii, <Diana fuana ta wane lau hai ka oolisia, eeri ka iilia si raolaa nia baa.> ");
INSERT INTO llu_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","<<Haia, e diana fuana ta wane ka oofu fai golu uria na faarailaa sulia na tataelana Lord Jesus faasia na maea. Na wane nae ta wane ana wane baa gi da liliu oofu naa fai golu ana si kada baa a Jesus e liliu ua ana fai golu, hafali mai ana si kada John e ainitalo ana siuabulaa, ma ka too fai golu lea mai ka dao ana fe dani a God e ngalia ana Jesus faasi golu uria i langi.>> ");
INSERT INTO llu_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ma gera ka aadafilia roo wane. Na hatana ta wane a Josef, na gera alangia ana Barsabas ma gera ka alangia laugo ana Justus. Ma na hatana na ruana wane aai a Mataeas. ");
INSERT INTO llu_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Sui gera fooa daka urii, <<Lord ae, oe naa o haitamana manatalana iimola gi sui. Haia, o faatainia mai fuagami ana si kada naa ni tei ana roo wane naa gi na o aadafilia, ");
INSERT INTO llu_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","eeri ka iilia na raoa na ana aposol na a Judas e lugasia ma ka lea na ana uria si gula nia bobola uria ni toolaa nia.>> ");
INSERT INTO llu_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ma i buira na gera fooa sui, gera ka inala hai gera ka daotoona tei ana roo wane naa gi na a God e aadafilia, ma gera ka aadafilia a Mataeas hai ka fonea aakwala ma tee aposol. ");
INSERT INTO llu_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ma ana fe dani baita na da alangia ana Pentekos e dao mai, na tooa naa gi da manata mamana da oogu ana tee si gula. ");
INSERT INTO llu_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ma aliꞌali si lingee doo iilingia na ooru baita ka dao mai faasia i langi, ma ka fungulia na luma na gera gwouru ana. ");
INSERT INTO llu_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ma gera ka rikia na doo gi aada mala na meamea eere gi, ma na doo nae gi e tagala ma ka dau i fafona tooa nae gi sui da too i seenae. ");
INSERT INTO llu_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ma na Aanoedoo Aabu ka funguli gera teefou, ma gera ka hafali bae ana na baelaa eꞌete gi iilingia na Aanoedoo Aabu e faabae gera ana. ");
INSERT INTO llu_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Haia, ana si kada nae, na tooa i Jiu gi na da fooasia a God, gera too laugo i Jerusalem. I gera faasia na aefera baita gi sui la molaagali. ");
INSERT INTO llu_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ma si kada gera rongoa ana si lingee doo naa, tooa oro gi gera ka oogu. Ma gera ka kwele asianaa, sulia na tooa manata mamana gi da bae ana na baelaa gera gi sui. ");
INSERT INTO llu_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ma sulia gera kwele asianaa, gera ka bae urii, <<Na tooa na da bae urinae, gera tooa i Galili sui go naa. ");
INSERT INTO llu_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Sui utaa naa mika rongo gera daka bae ana baelaa gami gi? ");
INSERT INTO llu_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Sulia gami mi lea mai faasia fera i Partia, ma i Media, ma i Elam, ma i Mesopotemia, ma i Judea, ma i Kapadosia, ma i Pontus, ma i Asia, ");
INSERT INTO llu_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ma faasia i Frigia, ma i Pamfilia, ma i Ejipt, ma faasia fera gi i Libia garangia i Saeren, ma teni tooa aga mi lea mai faasia i Rom. ");
INSERT INTO llu_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Haia, ma bali amelu da futa mai Jiu gi, ma bali amelu lau da hau ana Jiu i buira. Ma teni tooa aga da faasia i Krit, ma faasia i Arabia, ma golu ka rongoa na tooa nae da faataloa na doo ni kwelelaa ana gi na a God e iilia, ma gia rongo haitamana ana baelaa gera, na baelaa mamana gia gi i talaga!>> ");
INSERT INTO llu_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Gera ka kwele asianaa, ma gera lalafusia na doo naa na gera rikia. Ma gera ka ledi gera i talada daka urii, <<Taa naa malutana e urii?>> ");
INSERT INTO llu_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Haia, ma bali ana tooa ada, gera ka bae faawaelaa ada daka urii, <<Boro gera gwou baita asianaa ana waen oto, ma keteda ka garo.>> ");
INSERT INTO llu_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Sui a Peter e take fai nia aakwala ma tee aposol gi, ma ka bae baita fuana figua ka urii, <<Gamu na haasigu na i Jiu gi, ma i gamu na tooa gi sui na mu too i Jerusalem, mu fafurongo mai uri nau hai kuka faarongo gamu ana malutana si doo naa. ");
INSERT INTO llu_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Na tooa naa langi dasi ooewanea ana gwou baitalaa, iilingia na molu manata uria. Sulia nia kafi dao go ana sikwana kade hato i ubongia nae. ");
INSERT INTO llu_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Haia, ma na doo naa, nia baa a Joel na profet e bae ua na mai sulia baa ka urii, ");
INSERT INTO llu_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","<A God ka bae urii, Ana maedani isi gi, tara nau kuka falea na Aanoedoo Aabu nau fuana tooa gi sui. Haia, na alakwa gamu gi ma na haari gamu gi tara gera ka ainitalo ana baelagu. Ma na wane daraa gamu gi tara gera ka rikia na faataia gi, ma na wane waro gamu gi tara gera ka rikia si doo gi ana teo bolea gera gi. ");
INSERT INTO llu_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Iiu, ka urinae laugo fuana tooa gi na da rao fuagu, na wane gi ma na geni gi, tara kuka falea na Aanoedoo Aabu nau fuada ana si kada nae gi, hai ni gera laugo daka ainitalo ana baelagu. ");
INSERT INTO llu_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ma nau tara kuka iilia na doo kwaibalatana gi la mamangaa i langi, ma kuka iilia na doo ni kwelelaa gi ana i aano la molaagali. Ma na tooa tara gera ka rikia na abu ma na eere ma na kuduui hasu. ");
INSERT INTO llu_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ma na hato tara ka rorodoa, ma na sinali tara ka kekeroa mala abu, suifetei fe dani baita na a Lord tara ka ketoa ana tooa gi sui kafi dao mai. ");
INSERT INTO llu_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Haia, ni tei na e soe uria kwaiꞌadomilaa faasia a God, tara nia ka mouri.>>> ");
INSERT INTO llu_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Sui a Peter ka bae lau urii, <<Gamu tooa i Israel, muka fafurongoa na baelaa naa gi! A Jesus faasia i Nasaret, nia na wane na a God e oodu mai. A God ka faamamana fuagamu ana si doo ana kwelelaa ana gi ma na mamalafooa gi na a God e iilida mai ani nia. Gamu i talagamu mu haitamana sui naa si doo naa, sulia e fuli i see, i matangamiu. ");
INSERT INTO llu_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Haia, ma God e haitamana sulia ma ka dooria hasa tara daka falea Jesus fuagamu haia muka haungia sulia muka faalamainia fuana tooa na aabulolada e taꞌa gera ka fotoia i fafona airarafolo. ");
INSERT INTO llu_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Sui a God ka tataea lau faasia na maea, ma ka luke nia faasia na rigitaa ana maea, sulia e afetai hasa na maea ka kani faafia a Jesus. ");
INSERT INTO llu_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Sulia a David a bae urii suli nia, <I nau ku rikia a Lord i nao agu ana si kada gi sui, ma i nia e too fai nau, aata kuka daotoona afetailaa. ");
INSERT INTO llu_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ma sulia si doo naa, na liogu ka halahala, ma na baelagu gi ka fungu ana eelea. Sulia boroi ana nau naa ta wane go ana ma tara kuka mae, langi kusi manata aꞌabo, sulia kuka haitamana hasa a God ka aadasuli nau. ");
INSERT INTO llu_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Sulia, a God ae, e afetai oko eekwataia nau uria na gula ni maea, ma afetai oko lugasi nau, na wane ni raoa aabu oe ka fura la kwaingeia. ");
INSERT INTO llu_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ma oko faatainia sui naa fuagu na tala gi na e lea uria na mouria. Ma ana na toolamu fai nau, tara oko faafungu nau ana eelelaa.>>> ");
INSERT INTO llu_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Ma a Peter e bae lau urii, <<Oote wai haasi nau ae, nau ku faarai folaa fuamolu sulia na koo gia a David na aaofia. Nia e mae, ma gera ka aalua naa. Ma na kwaingeia nia ka too garangi golu go ana i see i taraꞌena. ");
INSERT INTO llu_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","I nia na profet, ma nia ka haitamana go ana na bae aalualua a God fuana. A God ka bae aalafuu fuana tara ka aalua ta wane ana ooliolitana David na aaofia tara ka aaofia iilingi nia. ");
INSERT INTO llu_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","A David ka rikia sui na taa na tara a God ka iilia, ma nia ka bae sulia na tataelana na wane aadafililana a God faasia na maea ka bae ka haea lau langi kasi lugasi nia i laona gula ana maea, ma na noina ka langi kasi fura. ");
INSERT INTO llu_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","A Jesus baa, a God e tataea faasia na maea, ma i gemelu sui go na melu rikia ana urinae. ");
INSERT INTO llu_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","A God na Maa nia, e tataea a Jesus uria si gula ana initooa, ma a God ka falea na Aanoedoo Aabu fuana iilingia baa nia bae aalualu ana. Haia, ma na doo naa na molu rikia ma molu ka rongoa i taraꞌena naa na Aanoedoo Aabu naa e falea mai fuamelu. ");
INSERT INTO llu_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Sulia langi lau a David na e tatae uria i langi. Sulia a David e bae ana urii, <A Lord e bae urii fuana Lord nau, O gwouru i bali aaolo ani nau, ");
INSERT INTO llu_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","lea ka dao ana si kada kuka saitasa ana na maalimaea oe gi.> ");
INSERT INTO llu_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Haia, gamu tooa i Israel, muka haitama diana ana a Jesus na nau ku bae sulia baa molu fotoia i fafona na airarafolo, a God ka aalu nia ka Lord ma na wane aadafililana a God!>> ");
INSERT INTO llu_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ma ana si kada na tooa gi da rongoa si doo naa, na mangoda ka lelebe. Ma daka bae urii fuana a Peter fai nia na oote aposol gi, <<Oote haasi gi ae, si taa naa tara melu ka iilia?>> ");
INSERT INTO llu_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","A Peter e oolisida ka urii, <<I gamu sui muka oolitai manata faasia na aabulo taꞌalaa gamu gi, ma muka siuabu ana hatana a Jesus Christ, eeri a God ka manata lukea na aabulo taꞌalaa gamu gi, ma ka falea na Aanoedoo Aabu nia fuagamu. ");
INSERT INTO llu_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Sulia na bae aalualua a God fuagamu ma fuana wela gamu gi ma fuana tei gera na da too tau mai ma ni tei gera na a Lord ma God gia e soe gera fuana.>> ");
INSERT INTO llu_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","A Peter e haea na doo naa gi fuada fai nia si baelaa ni kwaiareilaa oro gi lau ka urii, <<Muka aadasuli gamu i talagamu faasia na kwaelaa na e lea mai fuana na tooa taꞌa gi!>> ");
INSERT INTO llu_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ma na tooa oro gi daka manata mamana ana na baelana, ma daka siuabu. Ma ana fe dani nae, e bobola fai nia na oolu tooni iimola na da ruu lau mai i laona na figua nae. ");
INSERT INTO llu_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ma ana maedani gi sui, gera ka fafurongoa na faatolomailaa gera na aposol gi, fai nia toolaa oofu ma na fanga aabulaa oofu, ma ka fooalaa oofu. ");
INSERT INTO llu_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ma na aposol gi da iilia doo kwaibalatana oro gi ma na doo gi ni kwelelaa ana gi, ma na tooa gi sui daka arefo. ");
INSERT INTO llu_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ma na tooa gi na da manata mamana, gera ka tasa dongaa fai nia na oofuofua kwaimaani, ma daka ado fai gera kwailiu ana si doo gera gi. ");
INSERT INTO llu_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Haia, gera daka faafoli laugo ana na aaludoolaa gera gi ma na gano gera gi, ma daka tolingia na malefo gi daka ngalia i matangada kwailiu, sulia si taa na tee wane adaalu e dooria. ");
INSERT INTO llu_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ma gera ka oofu sulia dani i laona na Beu Aabu a God. Ma gera ka fanga oofu kwaimaani i laona luma gera gi, ma si kada gera oofu urinae, gera ka eele asianaa fai nia na faatoꞌoulaa. ");
INSERT INTO llu_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ma gera ka silia a God, fai nia na noni hahalalaa sulia na tooa gi sui da hae diana ada. Haia, ma sulia dani, a Lord e faamouria na tooa faalu, ma gera ka ruu mai la oofuofua gera na tooa da manata mamana. ");
INSERT INTO llu_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Haia, ana tee maedani, Peter fai nia a John daaro lea uria Beu Aabu a God ana ooluna kade hato i haulafi, sulia kade hato nae kada hato uria fooalaa. ");
INSERT INTO llu_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ma tee wane nonina e mae ana kada e futa ua go mai ana, sulia dani gera ngalia daka aalua i maana mae haga ana Beu Aabu. (Na maehaga nae, gera alangia ana <<Mae Haga Nuulaa>>.) Sulia dani, nia gwouru i seenae hai ka gani malefo ana siana tei gera na da ruu kou laona Beu Aabu. ");
INSERT INTO llu_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ma ana si kada nia rikia Peter fai John daaro ruu kou, nia ka gani daaro eeri daaro ka falea tesi doo fuana. ");
INSERT INTO llu_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ma daaro ka bubu tete fuana, ma a Peter ka bae urii fuana, <<O bubu tete ani gemere.>> ");
INSERT INTO llu_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ma nia ka bubungi daaro, ka manata ana baa hasa tara ka ngalia tesi doo faasi daaro. ");
INSERT INTO llu_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Sui a Peter ka bae urii fuana, <<Nau langi kusi too go ana tesi malefo. Sui tara nau kuka falea fuamu na taa na nau ku too ana. Haia, ana hatana a Jesus Christ faasia Nasaret, nau ku haea o tatae ma oko fali!>> ");
INSERT INTO llu_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Sui a Peter e dau ana na aba aaolo nia, ma ka tataea. Ma aliꞌali na aena gi teefou ka rigita, ");
INSERT INTO llu_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ma nia ka lofo alaa, ma ka take ana roo aena gi, ma kafi hafali fafali kwailiu. Ma nia ka ruu kou fai daaro fui lao Beu Aabu, e fali ma ka lofolofo fai nia na sililana a God. ");
INSERT INTO llu_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ma na tooa gi da nii seenae, si kada gera riki nia fali ma ka silia a God, ");
INSERT INTO llu_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ma si kada gera aada haitamana nia na wane gani doo baa lea doo ka gwouru i maana maehaga ana Beu Aabu, gera ka kwele asianaa ana. ");
INSERT INTO llu_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Si kada nae wane na ka abiꞌabi asianaa na ana Peter ma John, na tooa oro gi daka kwele asianaa ma gera ka lalao siada laona taofa baa gera alangia ana <<Taofa a Solomon>>. ");
INSERT INTO llu_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Si kada a Peter e rikia na tooa nae gi, nia ka bae urii fuada, <<Gamu tooa i Israel gi, utaa naa molu ka kwele ana si doo naa, ma molu ka bubungi gemelu naa amolu? Gomolu manata hasa na mamanaa gemelu i tala melu ma na toolaa aabu gemelu ka guraa ana wane naa hai ka fali? ");
INSERT INTO llu_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Na God baa Abraham, Aesak, ma Jakob gera fooasia, na God baa koo gia gi, baa e falea na initooa aabu fuana a Jesus, na wane raoa nia. Sui molu ka falea amolu a Jesus fuana na wane baita gi. Ma si kada a Paelat e ketoa, gomolu ka oote gomolu amolu ani nia, ma molu ka hae taꞌa amolu ana si kada baa Paelat e manata uria lukelana. ");
INSERT INTO llu_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","A Jesus naa na wane aabu ma na wane diana, sui molu ka oote gomolu amolu ani nia, ma molu ka gania amolu a Paelat uria na lukelana wane na e hauwane. ");
INSERT INTO llu_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Haia, ma ni gomolu molu haungia a Jesus na wane gwoufutana na mouria. Sui a God ka tataea faasia na maea, ma melu ka riki mamanalana si doo naa. ");
INSERT INTO llu_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Na mamanalana hatana a Jesus na e falea na rigitaa fuana wane na aena gi e mae naa. Taa naa molu rikia ma molu ka haitamana, a God e aadea ana fiimamanalaa ana hatana a Jesus, sulia fiimamanalaa ana Jesus naa e aadea na wane naa ka diana urinae, ma molu ka rikia sui. ");
INSERT INTO llu_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","<<Haia, oote waihaasi nau gi ae, nau ku haitamana gomolu fai nia na wane baita gamu gi molu aade urinae ana Jesus, sulia molu lalafusidoo. ");
INSERT INTO llu_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Sulia a God e haea ua na mai i nao ana na profet gi sui hasa tara na wane aadafilia nia tara ka nonifii. Haia, nia urinae hai ka faamamanaa na baelana God. ");
INSERT INTO llu_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Haia, molu oolitai manata naa, ma molu ka aabulo fuana God, hai nia ka manata lukea na aabulolaa taꞌa gamu gi, ");
INSERT INTO llu_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ma eeri a Lord tara ka faadianaa na aanoedoo gamu gi ma nia tara ka oodua mai a Jesus na Christ na wane aadafililana baa fuagamu. ");
INSERT INTO llu_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Nia tara ka too ua mai ana i langi lea ka dao ana si kada a God ka faafaalua ana doo gi sui iilingia nia e haea ua na mai ana oote profet aabu nia gi. ");
INSERT INTO llu_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Sulia a Moses e haea, <A God na Lord gamu tara ka oodua kou tee profet siagamu iilingia laugo na nia e oodu nau mai. Nia tara ta wane ana tooa gia Jiu gi. Molu ka roosulia na taa gi na nia e haea fuagamu. ");
INSERT INTO llu_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","So ni tei na langi kasi roosulia na taa naa na profet nae e haea, tara a God ka tookita faasia tooa nia gi ma ka kwaea.> ");
INSERT INTO llu_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Haia, a Samuel ma na profet aai gi na da lea mai i buri, na gera too ana na faarongolaa na faasia a God, da ainitalongainia laugo taa naa da fuli na mai ana si kada naa. ");
INSERT INTO llu_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Na bae aalafuua gi a God ana profet nia gi na doo fuagamu. Ma muka ado ana laugo fai nia na koo gamu gi ana si baea aalualua a God fuada, iilingia nia e haea fuana Abraham ka bae urii, <Ana na ooliolitamu gi, tara kuka faadianaa tooa gi sui i laona molaagali.> ");
INSERT INTO llu_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Nia naa, God ka aadafilia mai ma ka oodua mai na wane ni raoa nia siagamu totongenao, eeri ka faadiana gamu ana faaabulolaa gamu faasia na aadelaa taꞌa gamu gi.>> ");
INSERT INTO llu_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ana si kada a Peter fai nia a John daaro faarai ua ana fuana tooa, teni fataabu gi ma na wane baita ana wane da fofolo usia Beu Aabu a God fai nia teni Sadusi gi, gera ka dao mai siadaaro. ");
INSERT INTO llu_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Gera rake hasu sulia na roo aposol naa gi daaro faatolomainia na tooa sulia a Jesus e tatae faasia na maea, na faamamanalana urinae, na tooa gi laugo na da mae tara daka tatae laugo faasia na maea. ");
INSERT INTO llu_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Nia naa aadea gera ka dumuli daaro ma daka aalu daaro laona beu ni kanilaa, daaro ka too i seenae maasia ruana mae dani, sulia nia e haulafia naa. ");
INSERT INTO llu_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ma na tooa oro na gera rongoa baelaa daaro, gera ka manata mamana. Haia, na tooa na gera manata mamana ana si kada nae, nia bobola fai nia lima tooni wane. ");
INSERT INTO llu_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Sui ana bobongi, na wane naonao gi ma na wane baita gera Jiu gi ma na faatolomai gi ana kwaieresia gi, gera ka oofu i Jerusalem. ");
INSERT INTO llu_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Gera oofu fai nia a Anas na Fooanigwou, ma a Kaeafas, ma a John, ma a Aleksanda fai nia teni wane gi lau ana aebara na ana Fooanigwou. ");
INSERT INTO llu_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Sui gera faatakea a Peter fai nia a John i nao ani gera, ma gera ka soeledi daaro daka urii, <<Gomoro guraa utaa ana na wane tero naa? Na mamanaa taa na moro too ana fai nia na hatana ni tei na moro iilia ana?>> ");
INSERT INTO llu_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ma a Peter e fungu ana Aanoedoo Aabu, ma ka bae urii fuada, <<Wane baita gi ae, ");
INSERT INTO llu_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","lea so molu ka soeledi gemere taraꞌena sulia na aadelaa diana na mere iilia fuana wane na aena e mae, ma utaa naa nia ka diana, ");
INSERT INTO llu_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","nia bobola fuana molu ka haitamana, ma i gamu sui na tooa gi i Israel bobola fuana molu ka haitamana laugo, hasa na wane na molu rikia e akwaa ma ka take na siamolu naa, nia e akwaa ana mamanaa ana hatana a Jesus Christ faasia i Nasaret, baa molu haungia i fafona airarafolo, ma a God ka tataea faasia na maea. ");
INSERT INTO llu_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","A Jesus baa na Kekedelaa Aabu e bae sulia ka urii, <Na fou baa na i gomolu na wane tole luma gi na mu haea e langi kasi diana e hau na ana na fou na e diana ka tasa uria tolelumalaa.> ");
INSERT INTO llu_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Taifili nia go na e haitamana ka faamouria na tooa, langi lau ta wane laona molaagali na a God e oodua eeri ka faamouri gia ana.>> ");
INSERT INTO llu_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ma na wane baita gi ana oofuofua nae, gera ka kwele asianaa ana Peter ma John, sulia langi daaro kasi mou ana bae raraꞌalaa, ma gera ka kwele laugo ana haitamadoolaa daaro roo wane langi dasi sukulu go, ma dafi haitamana daaro roo wane da liliu oofu fai nia a Jesus. ");
INSERT INTO llu_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ma gera ka lalafusia na haelana lau tesi doo, sulia na wane baa daaro guraa e take laugo fai daaro. ");
INSERT INTO llu_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Nia naa, gera ka oodua a Peter ma a John fai nia na wane nae, daalu ka haga faasia gula ni oogulaa. Sui, gera ka bae fasi ada sulia taa naa tara gera ka aadea ana Peter ma John. ");
INSERT INTO llu_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ma gera ka bae urii, <<Taa naa tara golu ka aadea ana roo wane naa gi? Sulia na tooa gi sui go na da too i Jerusalem da haitamana sui go na doo kwaibalatana na daaro iilia, langi golu si bobola uria tofelana. ");
INSERT INTO llu_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Haia, ma fuana si doo na ka langi kasi talo fuana teni tooa lau, golu haea fuadaalu langi daalu si bae lau sulia hatana Jesus fuana teni iimola lau.>> ");
INSERT INTO llu_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Sui gera ka soea lau mai a Peter ma a John, gera ka bae fifii urii fuadaaro, <<Gomoro langi moro si bae naa lau ma langi moro si faatolomai naa lau sulia a Jesus.>> ");
INSERT INTO llu_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ma a Peter fai nia a John, daaro oolisi gera daaro ka urii, <<Molu manata fasi na taa naa na e oꞌolo i maana a God, ana roolaa suli gamu, langi roolaa sulia a God. ");
INSERT INTO llu_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Sulia i gemere e afetai mere ka too naa faasia baelaa sulia na taa naa mere rikia i talamere ma mere ka rongoa.>> ");
INSERT INTO llu_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ma na oofuofua na ana wane baita gi gera ka bae rigita lau fuadaaro, sui gera ka luke daaro. Sulia e afetai gera ka kwae daaro, sulia na tooa gi sui, gera baelafea asianaa a God faafia si taa naa e fuli. ");
INSERT INTO llu_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Sulia na wane na daaro guraa, nia bobola fai nia ana fai aakwala fe ngali ma ka tasa. ");
INSERT INTO llu_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Haia, ana si kada gera lukea a Peter ma a John, daaro ka ooli lau siana bubulutaa gera, ma daaro ka faarongo gera ana taa gi na fataabu baita gi ma na wane baita gi gera haea. ");
INSERT INTO llu_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ana si kada gera rongoa, gera ka fooa fuana a God daka urii, <<Lord ae, ni oe naa haungainia na mamangaa ma na molaagali ma na aasi ma na doo gi sui i laona na doo nae gi. ");
INSERT INTO llu_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ma oko falea na Aanoedoo Aabu oe fuana koo gami a David na wane raoa oe eeri ka bae urii, <Utaa naa na tooa maadiu gi gera ka rakehasu asianaa ma daka manata uria iili taꞌalaa fuana a God, sui afetai daka iilia mone? ");
INSERT INTO llu_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Na aaofia gi gera ka aade aagau ani gera talada ma na wane baita gi gera ka oofu uria firulaa fai nia a Lord ma na wane aadafililana nia.> ");
INSERT INTO llu_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Sulia a Herod ma a Pontias Paelat daaro oofu laona fera nae fai nia tooa na langi dasi Jiu gi ma na tooa gi i Israel laugo. Gera oofu uria falelana kwaelana fuana Jesus, na wane rao aabu oe baa o aadafilia. ");
INSERT INTO llu_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Gera oofu uria aadelana na doo gi sui iilingia o manata ua na mai, sulia ana mamanaa oe ma na kwaidoorilamu fuana ka fuli urinae naa. ");
INSERT INTO llu_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ma ana si kada nae Lord ae, oko rikia fasi si baelaa fifii gera gi, ma oko falea mai na rigitaa oe fuagami na wane ni raoa oe gi, eeri mika bae raraꞌa ana baelamu. ");
INSERT INTO llu_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","O faatainia mai na mamanaa ni guralaa oe, eeri daka rikia ana aadelana doo kwaibalatana gi ma na doo ni kwelelaa ana gi, ana hatana wane raoa aabu oe a Jesus.>> ");
INSERT INTO llu_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ma ana si kada gera faasuia na fooalaa, si gula na gera oofu ana ka igiꞌigi. Ma a God ka faafungu gera ana Aanoedoo Aabu, ma gera ka bae raraꞌa naa sulia baelana a God. ");
INSERT INTO llu_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ma na tooa gi sui na da manata mamana, gera ka oofu ana tesi manatalaa fai nia tesi lio. Ma e langi ta wane na e too ana tesi doo so ka haea ana si doo nia i talana, sulia gera ado sui ana si doo gera gi sui. ");
INSERT INTO llu_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ma na aposol gi ka ainitalongainia raraꞌa ana tataelana Lord Jesus faasia na maea, ma a God ka faadiana gera asianaa sui go. ");
INSERT INTO llu_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Haia, ma e langi ta wane la bubulutaa na hasa ka dooria ana tesi doo, sulia ni tei ani gera na da too ana gano langi so ta luma, gera ka faafoli ana, sui gera ka ngalia mai si malefo nae, ");
INSERT INTO llu_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","daka falea fuana aposol gi, gera ngalia daka tolingia fuada sui sulia si kwaidoorilaa gera gi. ");
INSERT INTO llu_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ma a Josef tee wane ana kwalafaa a Livae baa e futa i Saeprus baa na aposol gi da alangia ana Banabas (malutana wane faagwagwari lio), ");
INSERT INTO llu_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","nia e faafoli ana tee si gano nia, ka ngalia si malefo nae, ka falea fuana na aposol gi. ");
INSERT INTO llu_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Haia, tee wane hatana a Ananias, ma na afe nia hatana ni Safira, daaro too laugo ana bubulutaa nae. Ma daaro ka faafoli laugo ana bali ana gano daaro. ");
INSERT INTO llu_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Sui nia ka aalua ana ta bali malefo aai fuadaaro, sui nia ka ngalia go mai ana ta bali malefo aai ka falea fuana aposol gi. Ma na afe nia ka haitamana naa. ");
INSERT INTO llu_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ma a Peter ka bae urii fuana, <<Ananias ae, uria taa na oko lugasia Satan ka talai oe, ma e aade oe oko sugea na Aanoedoo Aabu ana haufinilana bali ana malefo baa o ngalia? ");
INSERT INTO llu_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Suifetei ofi faafoli ana na gano baa, nia na doo oe. Ma buira o faafoli ana, si malefo na o ngalia uria si doo naa, na doo oe, ma haitamana oko aadea amu ana tesi doo sulia na kwaidooria oe. Sui utaa na oko manata urinae laona manatalamu? Oe langi osi sugea wane, oe o sugea a God!>> ");
INSERT INTO llu_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Si kada Ananias e rongoa si doo naa, nia asi nia i aano ma ka mae naa. Ma na tooa gi da rongoa si doo naa, gera ka mou asianaa. ");
INSERT INTO llu_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Haia, na wane daraa gi da ruu mai, gera ka afua nonina. Sui gera ka ngalia i maa, ma daka aalua. ");
INSERT INTO llu_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Sui e bobola fai nia oolu kade hato i buira, na afe nia ka ruu mai, ma langi kasi haitamana laugo ana taa naa e fuli. ");
INSERT INTO llu_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ma a Peter ka bae urii fuana, <<Faarongo nau, si malefo baa sui naa na oe fai nia na aarai oe moro ngalia mai naa uria na gano gomoro baa moro faafoli ana?>> Ma nia oolisia ka urii, <<Iiu, nia sui naa naa.>> ");
INSERT INTO llu_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Haia, a Peter ka bae lau urii fuana, <<Uria taa na oe fai nia na aarai oe moro ka suge fuana na Aanoedoo Aabu a God, ma moro manata hai so nia kasi falea kwakwaea fuamoro? Na wane baa gi na da aalua mai na aarai oe, da take ua go ada i aena maa ana si kada nae. Ma tara gera ka ngali oe laugo.>> ");
INSERT INTO llu_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ma aliꞌali na geni na ka asi nia laugo i aano i maana aena a Peter, ma ka mae naa. Ma na wane daraa baa gi da ruu mai, ma gera ka rikia nia mae naa, gera ka ngalia i maa, ma lea daka aalua laugo i ninimana aarai nia. ");
INSERT INTO llu_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Na soefaataia sui ma teni tooa aai gi laugo, da rongoa si doo naa, ma gera ka mou asianaa. ");
INSERT INTO llu_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Na aposol gi da iilia si doo oro gi ni kwelelaa ana i matangana na tooa gi. Ma na tooa manata mamana gi sui daka dao oofu i laona kade Beu Aabu a God na da alangia ana Taofa a Solomon. ");
INSERT INTO llu_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ma e langi ta wane na kasi manata mamana kasi oofu faida, sui boroi ana na tooa gi daka hae baita ani gera. ");
INSERT INTO llu_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Sui, na tooa oro gi asianaa ana na wane gi ma na geni gi, daka manata mamana ana na Lord, ma daka oofu laugo i laona na bubulutaa nae. ");
INSERT INTO llu_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ma sulia si taa gi na aposol gi da iilia, na tooa gera ka koua na tooa matai gi uria aalulada sulia na tala gi fafona na iifitai gera gi, eeri si kada a Peter e liu ana, i nia ka nunufi gera mone ana eeri daka akwaa. ");
INSERT INTO llu_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ma na tooa oro gi daka lea mai faasia na fera gi galia i Jerusalem, da ngalia mai na tooa gera gi na da matai fai nia na tooa gi aai na aagalo taꞌa gi da adosi gera, ma gera sui daka akwaa. ");
INSERT INTO llu_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Sui na Fooanigwou fai nia na tooa nia gi, na gera too i laona bubulutaa ana Sadusi, gera ka kwaifii asianaa ana na aposol gi, ma gera ka manata uria aadelana tesi doo ana aposol gi. ");
INSERT INTO llu_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ma gera dumulida, ma gera ka aaluda laona beu ni kanilaa. ");
INSERT INTO llu_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Haia, ana fe rodo nae, na ensel a Lord e lea mai, ma ka ifingia na maa gi ana beu ni kanilaa nae, ma ka talaida i maa, ma ka bae urii fuada, ");
INSERT INTO llu_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","<<Molu lea, molu ka take la labata ana Beu Aabu nia a God, molu ka faarongo ana tooa sulia na mouria faalu naa.>> ");
INSERT INTO llu_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Haia, na aposol gi gera ka roosulia, ma i ubongia mae galogaloa, gera ka lea i laona na Beu Aabu a God, ma gera ka talaꞌae faatolomailaa. Haia, na Fooanigwou fai nia tooa nia gi gera ka soea mai wane baita gera Jiu gi uria oofulaa uria faarailaa. Ma gera ka fale baea fuana na wane ana oomea gi daka talaia mai na aposol gi faasia la beu ni kanilaa siada. ");
INSERT INTO llu_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Sui si kada na wane ana oomea gi da dao kou, langi dasi rikia naa ta aposol i laona beu ni kanilaa. Ma gera ooli daka faarongo ana wane baita gi daka urii, ");
INSERT INTO llu_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","<<Ana si kada melu dao kou siana beu ni kanilaa, melu rikia na tooa fofolo gi gera bilake ngasi asianaa ana maa gi ma gera ka folo go ada maana maa gi. Sui melu ifi, melu ka aada i laona beu, sui langi melu si rikia ta wane i laona.>> ");
INSERT INTO llu_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Kada na fataabu baita gi ma na wane baita ana na wane fofolo gi usia Beu Aabu a God gera rongoa si doo naa, gera ka lalafusia na taa na e aadea na aposol gi. ");
INSERT INTO llu_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Sui tee wane e ruu mai, ka bae urii fuada, <<Molu fafurongo fasi, na wane baa gi molu aaluda i laona beu ni kanilaa, gera take na ada la labata ana Beu Aabu a God, ma daka faatolomainia na ada tooa gi!>> ");
INSERT INTO llu_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Sui, na wane baita gera wane fofolo gi fai nia na wane nia gi, da lea daka ooli mai fai nia na aposol gi. Langi dasi kwaeda lau uria oolilaa mai, sulia gera mou ana tooa gi aata gera ka uida ana fou. ");
INSERT INTO llu_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ma si kada gera talaia mai na aposol gi ma daka faatakeda i maada na wane baita gi na gera oofu, na Fooanigwou ka bae fuagera ka urii, ");
INSERT INTO llu_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","<<Gemelu melu bae lui gomolu langi molu si faatolomai lau ana hatana Jesus. Sui, na faatolomaia gamu naa e tagala sui naa i laona fera i Jerusalem. Ma molu ka feengi gemelu hasa gemelu naa melu haungia ka mae!>> ");
INSERT INTO llu_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Sui a Peter fai nia na aposol gi gera oolisia daka urii, <<Nia oꞌolo fuana melu ka roosulia a God, ma langi na iimola gi go ana. ");
INSERT INTO llu_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ma i buira na molu haumaelia a Jesus i fafona na airarafolo, a God gera na koo gia gi ka tataea faasia na maea. ");
INSERT INTO llu_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ma a God e tatae nia uria i bali aaolo ani nia eeri ka kwaitalai ma ka faamouri, eeri ka falea si kada fuana tooa i Israel gi uria oolitai manatalaa hai a God ka manata lukea na garolaa gera gi. ");
INSERT INTO llu_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Haia, ni gemelu melu rikia na doo naa gi ma melu ka faamamana, gemelu fai nia na Aanoedoo Aabu na a God e fale mai fuana ni tei gera na da roosulia.>> ");
INSERT INTO llu_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ma ana si kada na wane naa gi laona oofuofua gera wane baita gi gera rongoa si doo naa, gera ka rakehasu asianaa, ma gera ka dooria uria haumaelilana na aposol gi. ");
INSERT INTO llu_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Sui tee wane ani gera wane baita gi ana oofua naa, na wane ana Farisi hatana a Gamaliel na wane faatolomai ana kwaieresia gi ma nia na wane tooa gi da manata baita asianaa ana. Nia take, ka haea gera ka oodua fasi ada na aposol naa gi i maa fuana si kada totou. ");
INSERT INTO llu_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Sui, nia ka bae urii fuana na wane baita nae gi, <<Gomolu tooa i Israel gi, molu manata diana sulia na taa naa tara molu ka aadea ana oote wane naa gi. ");
INSERT INTO llu_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Sulia langi si tau go kou, a Tedas e lea mai, ka haea nia ta wane baita asianaa, ma e bobola fai nia fai talange wane na gera lea sulia. Ma e langi kasi tau, na tooa gi gera haungia, ma na fafurongo nia gi gera ka tagala teefou, haia na raolaa baa nia iilia ka sui naa lau go ana. ");
INSERT INTO llu_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Sui buira a Judas na wane i Galili ka lea lau mai ana si kada gera kedea ana hatana tooa gi sui. Ma na tooa oro gi gera na lea sulia, sui da haungia laugo. Ma na fafurongo nia gi, daka tagala laugo ada. ");
INSERT INTO llu_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Haia, ma sulia na doo na fafurongo nia a Jesus gi gera iililaa, nau ku haea fuamolu, langi molu si aadea tesi doo ada. Molu lugasida. Lea na manataa ma na raoa na gera aadea na doo nia iimola go ana, doo tara ka funu laugo ana. ");
INSERT INTO llu_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ma lea so ka lea mai faasia a God, e afetai molu ka take usi gera, ma tara molu ka daotoona molu ka firu fai nia a God.>> Ma na wane baita gi daka roosulia baelana a Gamaliel. ");
INSERT INTO llu_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Sui gera ka oolifainia lau mai na aposol gi, ma daka haea fuana wane fofolo gi daka rabusi gera. Ma daka luida langi daalu si bae lau sulia na hatana a Jesus. Sui, gera ka lugasi gera. ");
INSERT INTO llu_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ma ana si kada na aposol gi da lea faasia na wane baita gi, gera ka eele asianaa, sulia a God e manata gera faorana uria nonifiilaa sulia na hatana a Jesus. ");
INSERT INTO llu_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ma ana maedani gi sui, na aposol gi gera ka liu i laona Beu Aabu a God ma i laona luma gera tooa gi, ma gera ka faatolomai ma gera ainitalongainia na Faarongolaa Diana sulia a Jesus na wane aadafililana a God. ");
INSERT INTO llu_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ma ana si kada nae, na tooa na da manata mamana ana a Jesus da oro. Ma na ugalaa ka liu i matanga gera Jiu na da bae ana na baelaa i Hebru fai nia na Jiu na da bae ana na baelaa i Grik. Na bali aai nae da bae ana baelaa i Grik, da uga hasa na bali Jiu na gera bae ana baelaa i Israel langi dasi adomia go na oru geni gera gi ana na fanga ma na malefo na da tolingia sulia dani. ");
INSERT INTO llu_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ma na aakwala ma roo wane aposol gi, gera ka soea mai tei gera na da manata mamana, daka bae urii, <<Langi si diana melu ka abero amelu ana na tolingilanalaa na malefo golu gi, ma melu ka manata buro na amelu ana na ainitalongailana baelana a God. ");
INSERT INTO llu_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Haia, nia urinaa oote waihaasi gi, molu filia ta fiu wane i matanga gamu na mu haitamada gera fungu ana Aanoedoo Aabu ma daka liotoo, hai daka baita fuana si raoa naa. ");
INSERT INTO llu_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Haia, ma ni gemelu, melu ka rao tee bali na amelu ana fooalaa ma na ainitalongailana baelana a God.>> ");
INSERT INTO llu_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ma na tooa nae gi da figu gera ka eele kada gera rongoa si doo naa, ma gera ka filia a Stefen, na wane na manata mamanalaa nia e rigita ma na Aanoedoo Aabu ka fungu ani nia. Ma gera ka filia laugo a Filip ma a Prokorus ma a Nikanor ma a Timon ma a Parmenas ma a Nikolas na wane faasia i Antiok na e lea sulia faatolomailaa gera Jiu gi, boroi ana nia langi kasi futa mai ana ta wane Jiu. ");
INSERT INTO llu_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Sui, na figua gera ka talaida mai siana na aposol gi, ma na aposol gi gera ka fooa fai gera ma daka aalua abada faafia na gwouda. ");
INSERT INTO llu_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ma na baelana a God ka tagala. Ma na tooa Jerusalem gi na da manata mamana daka oro asianaa mai, ma na fataabu oro gi laugo, gera ka manata mamana. ");
INSERT INTO llu_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","A Stefen nia na wane a God e faadiana ana ma ka too ana na mamanaa uria aadelana doo kwaibalatana oro gi ma na doo ni kwelelaa ana gi i matangana tooa gi. ");
INSERT INTO llu_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ma teni wane gi gera ka oote gera ana a Stefen. I gera ka too la bubulutaa da alangia ana <<Na Beu Aabu gera tooa da too nonilaa>>. Teni wane ani gera na Jiu gi faasia Saerenia ma Aleksandria. I gera fai nia teni Jiu gi faasia i Silisia ma Asia, gera ka hafalia oolisusuulaa fai nia a Stefen. ");
INSERT INTO llu_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ma na Aanoedoo Aabu ka falea na liotooa fuana a Stefen, eeri si kada nia e bae ana, e afetai ta wane ka oolisia. ");
INSERT INTO llu_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Sui gera ka folia teni wane haia daka haea, <<Gemelu rongoa nia bae tataga ana Moses fai nia a God.>> ");
INSERT INTO llu_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Kada tooa gi ma na wane baita gi ma na faatolomai ana kwaieresia gi da rongoa si doo naa, gera ka rakehasu asianaa, ma gera lea mai siana Stefen, daka dumulia, ma gera ka talaia mai siana figulaa gera tooa baita gi. ");
INSERT INTO llu_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Sui gera ka soea mai teni wane gi haia daka suge faafia. Gera ka bae urii, <<Sulia dani na wane naa e bae tataga ana Beu Aabu a God fai nia na kwaieresia a Moses gi. ");
INSERT INTO llu_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Melu ka rongoa nia haea tara a Jesus wane i Nasaret tara ka oogosia na Beu Aabu a God ma ka oolisia laugo na maluta gia naa gi a Moses e faleda fuaga.>> ");
INSERT INTO llu_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ma na tooa na gera gwouru laona oofuofua naa, daka bubutete ana Stefen, ma gera ka rikia na maana e aada ana mala ta ensel. ");
INSERT INTO llu_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Sui na Fooanigwou e soeledia a Stefen ka bae urii, <<Na doo naa gi gera feengi oe ana gi naa, nia mamana?>> ");
INSERT INTO llu_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","A Stefen e oolisida ka urii, <<Oote waihaasi ma oote maa gi, molu fafurongo nau fasi! A God ana initooa e faatai fuana koo gia a Abraham si kada nia too ua i Mesopotemia, suifetei nia lea kafi too i Haran. ");
INSERT INTO llu_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","A God ka bae urii fuana, <O lugasia na aebara oe ma na fera oe, oko lea uria na fera na tara kuka faatainia fuamu.> ");
INSERT INTO llu_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Sui nia ka lea faasia fera nia ma ka lea ka too i Haran. Ma buira na maa nia Abraham e mae, a God ka haea nia ka idu mai uria fera na gia too na ana naa. ");
INSERT INTO llu_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Haia, a God e langi kasi falea ta bali ana gano naa fuana a Abraham, ta bali totou boro hai so a Abraham ka nauhata boro ana ka langi laugo. Sui a God ka bae aalualu fuana tara ka falea fuana, eeri si gano nae tara si gano nia na ana nae, fai nia na ooliolitana. Ma si kada God e bae aalualu fuana, a Abraham e langi kasi too ua ana ta wela. ");
INSERT INTO llu_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","A God ka bae urii fuana, <Na ooliolitamu gera ka too ana fera na langi lau na fera gera, ma seenae tara gera ka aalu gera ana wane ni rao oꞌoni gi. Ma tara na tooa gi daka aade taꞌa fuada sulia fai talange fe ngali. ");
INSERT INTO llu_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Sui tara kuka falea kwakwaelaa fuana tooa na da rao fuada. Ma i buri, tara na ooliolitamu daka hagatafa mai faasia fera nae, ma gera ka fooasi nau i seegi.> ");
INSERT INTO llu_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Sui a God ka falea na maluta sulia na ole-marikolaa, uria na mamalafooa ana na bae aalualulaa nia fuana Abraham. Haia, a Abraham e ole-mariko ana Aesak, kwalu maedani i buira nia e futa. Haia, a Aesak ka ole-mariko ana wela nia a Jakob, ma a Jakob ka ole-mariko ana aakwala ma roo wela nia gi na gera naa na koo gia gi. ");
INSERT INTO llu_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","<<Haia, a Josef nia ta wane ana aakwala ma roo wane nae gi, sui na aua nia gi gera ka kwaifii ani nia, ma gera ka faafoli ana fuana na tooa da lea fui Ejipt hai nia ka hau ana wane rao oꞌoni. Ma God e too fai nia, ");
INSERT INTO llu_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ma ka ngali nonilaa ana laona afetailaa nia gi. Sulia si kada nia dao siana Fero, na aaofia i Ejipt, a God ka falea na liotooa fuana ma ka adomi nia hai a Fero ka dooria, ma Fero ka aalu nia ka baita laona initooa nia ma ka aalu nia laugo eeri ka baita usia na doo nia gi sui. ");
INSERT INTO llu_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ma si kada na uunifioloa baita e liu laona fera i Ejipt ma i Kanan, nia ka falea na afetailaa baita. Ma na koo gia gi ka afetai asianaa fuada uria daotoolana tesi fanga. ");
INSERT INTO llu_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Haia, ma ana si kada a Jakob e rongoa na fanga e nii i Ejipt, nia ka oodua na wela nia gi (na koo gia gi), gera ka lea totongenao i seenae. ");
INSERT INTO llu_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Sui ana si kada gera lea lau ana, a Josef ka aadea na aua nia gi gera ka haitamana. Ma Fero laugo ka haitamana aebara a Josef. ");
INSERT INTO llu_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ma Josef ka fale baea uria a Jakob na maa nia ka haea nia fai nia na aebara nia gi sui gera ka lea mai fui i Ejipt. Haia, ma na aebara nae gera fiu aakwala ma lima iimola. ");
INSERT INTO llu_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Haia, a Jakob ka lea uria Ejipt, ma i seenae nia fai nia na wela nia gi gera ka mae naa. ");
INSERT INTO llu_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Na nonida gera ngalida, daka aaluda i Sekem si gano baa Abraham e folia faasia aebara a Hamor ana si malefo. ");
INSERT INTO llu_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","<<Ma ana si kada garangi naa fuana a God ka faamamanaa na bae aalualua nia aadea fuana Abraham, na tooa golu gi na gera too i Ejipt gera ka oro asianaa. ");
INSERT INTO llu_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ana si kada nae, na aaofia faalu, na e langi kasi haitamana tesi maluta sulia a Josef, e talaꞌae baita usia i Ejipt. ");
INSERT INTO llu_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Nia ka sugea na koo gia gi, ma ka aade taꞌa asianaa naa fuada, ma ka luida langi dasi aalua wela bibiu gera gi luma haia gera ka mae ada. ");
INSERT INTO llu_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ma ana si kada nae naa, a Moses e futa mai ana, na wela aada diana. Ma ni tee nia e suluia go sulia oolu fe sinali go i luma nia. ");
INSERT INTO llu_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ma si kada ni tee nia e ngali nia ana faasia luma nia, na haari a Fero ka ngalia ma ka suluia iilingia ta wela wane ana. ");
INSERT INTO llu_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ma gera ka faatolomai nia ana maluta ma na liotooa gera tooa i Ejipt. Ma nia ka hau ana wane baita ana baelana ma na aabulolana. ");
INSERT INTO llu_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","<<Ma ana si kada a Moses e baita mai ka dao ana fai aakwala fe ngali, nia ka manata uria daotoolana tooa nia gi ana kwalafaa a Israel. ");
INSERT INTO llu_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ma si kada nia dao ana, nia ka rikia tee wane Jiu na wane Ejipt e iili taꞌa fuana. Ma nia lea kou uria adomilana ma ka haungia na wane nae i Ejipt. ");
INSERT INTO llu_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","(Nia ka manata sulia na tooa nia gi bobola fuana gera ka haitamana tara a God ka aade nia fuana ka luke gera faasia na kanilaa, sui langi dasi haitamana go.) ");
INSERT INTO llu_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Sui ana tee fe dani lau, nia ka rikia roo wane Jiu gi daaro firu, ma nia ka iili uria falelana aaroaroa i matanga daaro ka bae urii, <Moro rongo fasi, gomoro naa roo waihaasina gi naa. Uria taa na moro ka firu?> ");
INSERT INTO llu_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Sui tee wane ani daaro na e iili taꞌa fuana ta wane aai ka uusungainia a Moses, ka bae urii, <Tei naa aalu oe oko baita fuamere, ma oko aalu wane ni keketolaa fuamere? ");
INSERT INTO llu_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Oe dooria oko haungi nau laugo iilingia baa o haungia na wane baa i Ejipt i roogi?> ");
INSERT INTO llu_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Kada Moses e rongoa si doo naa, nia ka tafi faasia i Ejipt lea ka too na ana i Midian, ma i seenae na afe nia ka faafutaa roo wela wane. ");
INSERT INTO llu_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","<<Haia, i buira fai aakwala fe ngali e sui, na ensel ka faatai fuana Moses lao meamea kwesu ana eere na e agofia na ai na e too garangia fe tolo i Saenae i laona aanogwou. ");
INSERT INTO llu_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moses ka kwele asianaa ana si doo na nia e rikia, ma ka idu garangia kou na ai nae, hai ka riki diana ana. Sui nia ka rongoa na lingeena a Lord, ");
INSERT INTO llu_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","e urii, <I nau na God gera koo oe gi, God a Abraham, ma a Aesak ma a Jakob.> Ma a Moses ka lelebe ma ka oote nia ni aada, sulia nia e mou asianaa. ");
INSERT INTO llu_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ma a Lord ka bae urii fuana, <Lafua na tatae silipa oe gi faasia na aemu gi, sulia si gula na oe take ana, na gano aabu. ");
INSERT INTO llu_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nau ku rikia na faafiilaa e taꞌa asianaa gera iilia ana tooa nau na gera too i Ejipt, ma kuka rongoa na lingeena na aangilaa gera gi. Nia naa nau kuka sifo mai fuana kuka adomi gera. O lea na kou i Ejipt, sulia nau ku oodu oe.> ");
INSERT INTO llu_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","<<Haia, a Moses na baa tooa Israel gi gera oote gera ana, ma daka bae urii fuana baa, <Tei naa aalu oe oko baita usi gami, ma oko aalu wane ni keketolaa fuagami?> Nia baa a God e oodua mai hai ka baita ma ka lukeda fai nia si kwaiꞌadomilaa faasia na ensel baa e faatai fuana laona ai baa e harufia. ");
INSERT INTO llu_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ma a Moses ka talaia tooa Jiu gi faasia i Ejipt ma ka iilia si doo kwaibalatana gi ma doo gi ni kwelelaa ana gi i Ejipt ma laona aasi na da alangia <Aasi Kekeroa>, ma i laona aanogwou sulia fai aakwala fe ngali. ");
INSERT INTO llu_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","A Moses naa laugo baa e bae urii fuana tooa i Israel, <A God tara ka oodua mai tee profet siagamu, iilingia na nia e oodu nau mai siagamu, ma nia nae tara ta wane ua go ana tooa gamu gi.> ");
INSERT INTO llu_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Haia, a Moses baa e too fai nia tooa i Israel ana oofuofua baa la aanogwou, nia ka too fai nia na koo gia gi ma fai nia na ensel baa e faarai fai nia i gwouna fe tolo baa i Saenae. Ma nia ka ngalia naa si faarongolaa ana mouria faasia God eeri ka falea fuaga. ");
INSERT INTO llu_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","<<Sui, na koo gia gi gera ka oote gera go na roolaa sulia a Moses. Ma gera ka aabulo ada faasia, ma gera doori oolilaa ada fui Ejipt. ");
INSERT INTO llu_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Gera ka bae urii fuana Aaron, <O haungainia teni god fuamelu, eeri gera ka talai gemelu. Sulia melu lalafusia taa na e iilia a Moses, na wane baa e talai gemelu mai faasia i Ejipt.> ");
INSERT INTO llu_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ma gera ka haungainia na nununa bulumakau uria fooasilana ada, ma na narelana na kwaisuusia fuana, ma gera ka aadea na maoma uria na faabaitalana doo na gera haungainia i talada. ");
INSERT INTO llu_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","I aena na gera aade urinae, a God ka aabulo faasi gera, ma ka lugasida eeri gera ka fooasia na ada na bubulu gi i langi, iilingia baa na profet da kedea daka urii, <Gamu tooa i Israel, langi lau na doo fuagu uria na haungilana na doo ana mouria ma na kwaisuusilaa ana sulia fai aakwala fe ngali laona aanogwou. ");
INSERT INTO llu_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Na babala na molu ngalia fai gamu ana naa doo fuana na god Molok fai nia nununa bubulu na god gamu baa gera alangia ana Refan, gera na nunui doo gi molu haungaida uria fooasilada. Ma sulia si doo nae gi, tara nau kuka oodu gamu kou liufia fera i Babilon.> ");
INSERT INTO llu_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","<<Na koo gia gi gera aalua laugo na babala a God fai gera lao aanogwou. Gera haungainia sulia si taa naa God e haea fuana a Moses ma ka faatainia fuana. ");
INSERT INTO llu_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","I buira, na koo gia gi da ngalia na babala naa faasia maa gera gi. Ma gera ka koua kou faida si kada gera lea fai nia a Josua ma gera ka ngalia si gano gi faasia na tooa gi na a God e kwaetarida i nao gera. Ma na babala nae e too i seenae lea ka dao ana si kada a David na aaofia. ");
INSERT INTO llu_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Ma a God ka eele sulia a David, ma nia ka gania God haia ka faalamania ka tolea ta beu fuana a God a Jakob. ");
INSERT INTO llu_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Sui, ma a Solomon ana naa e tolea beu fuana. ");
INSERT INTO llu_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","<<Haia, ma a God tofungana mamana e langi kasi too i laona luma na iimola gi da tolea. Sulia na profet e bae urii, ");
INSERT INTO llu_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","<A Lord e bae urii, Na fera i langi na gula ni gwourulaa ana initooa nau, ma na molaagali na gula ni uurilaa nau. Haia, langi ta luma na gamu haitamana tolelana naa e bobola uria kuka too i laona. ");
INSERT INTO llu_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Sulia i nau naa ku haungainia na doo nae gi sui.>>> ");
INSERT INTO llu_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Ma a Stefen e bae lau ka urii, <<Sui boroi ana gamu naa tooa gi Jiu, na mango gamu e ngasi iilingia na tooa maadiu gi, ma na mourilagamu gi ka rorodoa. Nia naa e aadea langi musi doori rongolana ma na aadelaa sulia baelana a God. Sulia mu iilingia koo gamu gi, sulia muka iiliili laugo uria takelaa usia Aanoedoo Aabu. ");
INSERT INTO llu_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Na koo gamu gi daka iinokesia na profet gi sui. Sulia i nao ua mai gera ka haungia na wane ni faarongolaa gi a God, na gera ainitalo ana lealana mai na wane rao oꞌolo nia a God. Haia, ma ana si kada nae, muka fale nia fuana na maalimaea nia gi, ma muka haumaelia. ");
INSERT INTO llu_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Haia, ma ni gamu baa, mu ngalia na kwaieresia a God gi baa na ensel gi da faleda mai fuagamu, sui langi molu si roo go sulia!>> ");
INSERT INTO llu_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Haia, ana si kada na wane baita gi laona oofulaa naa gera rongoa a Stefen, na rakeda ka ngengelaa asianaa, ma gera ka ala makwaaru fuana sulia gera rakehasuia asianaa. ");
INSERT INTO llu_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ma a Stefen, sulia nia fungu ana Aanoedoo Aabu, nia aada alaa uria i langi ma ka rikia na initooa a God, ma ka rikia laugo a Jesus e take i bali aba aaolo ana a God. ");
INSERT INTO llu_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ma a Stefen ka bae urii, <<Aada fasi! I nau ku rikia na fera i langi e ifi, ma na Wela nia Iimola gi e take i bali aba aaolo ana a God!>> ");
INSERT INTO llu_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ma si kada na wane baita gi da rongoa si doo naa, daka bokosia na aalingada, ma daka rii baita, ma daka oogururu faafi nia. ");
INSERT INTO llu_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ma daka ui ani nia uri maa faasia i laona na fera, ma daka hafalia na uilana ana fou gi. Na wane gi na da uia ana fou gi, daka lafua na maku tekwa gera gi ma daka aalua i siana tee wane daraa na hatana a Saul. ");
INSERT INTO llu_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ma si kada gera uia ana, a Stefen e fooa ka urii, <<Lord Jesus, oko ngalia na mangogu.>> ");
INSERT INTO llu_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ma nia e boururu i aano, ma ka bae baita ka urii, <<Lord, oko manata lukea na garolaa gera naa!>> Buira nia e haea si doo naa sui, nia ka mae naa. ");
INSERT INTO llu_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Haia, a Saul ka aalafaafia maelana a Stefen. Ma teni rafoe wane gi gera ngalia, daka aalua nonina a Stefen, ma daka aangisia asianaa. Ma ana fe maedani nae ua go, na soefaataia i Jerusalem ka hafalia na nonifiilaa, sulia na iinokesilaa e baita. Ma na tooa gi sui na da manata mamana (na aposol gi ka langi), gera ka tagala teefou uria fera gi i laona lolofaa i Judea ma i Samaria. ");
INSERT INTO llu_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Haia, a Saul ka hasi asianaa uria labasilana na soefaataia. Ma ka ruu i laona luma gi uria abalangailana ni tei gera na da manata mamanaa ana a Jesus, wane gi ma na geni gi laugo, ma ka aalu gera lao beu ni kanilaa. ");
INSERT INTO llu_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ma na tooa gi na da manata mamanaa, gera ka tagala ana fera gi sui. Ma si kada gera liu ana, gera ka ainitaloa na baelana a God. ");
INSERT INTO llu_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","A Filip e lea uria tee maefera baita laona lolofaa i Samaria, ma ka ainitalo ana Christ fuana tooa gi i seenae. ");
INSERT INTO llu_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ma na tooa gi i seenae, si kada gera ka rongoa na baelana Filip ma daka rikia laugo na doo kwaibalatana gi na nia e iilida, gera ka fafurongoa mamana taa gi na Filip nia e haea gi. ");
INSERT INTO llu_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Sulia nia e taria aagalo taꞌa gi faasia tooa oro gi, ma daka rii baita ana si kada da haga mai faasida. Ma na tooa na nonida e mae ma tooa gi da tero, nia e gurada teefou. ");
INSERT INTO llu_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ma na tooa i Samaria gi gera ka eele baita asianaa. ");
INSERT INTO llu_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Haia, la fera nae, tee wane e too i seenae hatana a Simon, ma e tau na mai nia faakwelea na tooa i Samaria ana raoa nia na aagalo gi. Ma ka haea nia ta wane baita asianaa. ");
INSERT INTO llu_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ma na tooa gi sui i fera nae, na tooa baita gi ma tooa toꞌou gi laugo, gera ka fafurongo nia, ma gera ka haea nia na wane e too ana mamana faasia a God, ma gera ka alangia ana <<Mamanaa baita>>. ");
INSERT INTO llu_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Gera fafurongo nia sulia e tau na mai nia e iilia raoa nia nae gi ana aagalo. ");
INSERT INTO llu_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Haia, ma ana si kada gera ka rongoa a Filip e bae sulia na Faarongolaa Diana sulia na Initooa a God ma a Jesus Christ, gera ka manata mamana, ma gera ka siuabu, wane gi ma na geni gi laugo. ");
INSERT INTO llu_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","A Simon laugo ka manata mamana, ma ka siuabu. I buira, nia ka too fai nia a Filip. Ma si kada nia e rikia a Filip e iilia na doo kwaibalatana gi ma na doo gi ni kwelelaa ada gi, nia ka kwele asianaa. ");
INSERT INTO llu_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Haia, na aposol gi na gera too ua i Jerusalem, ana si kada gera rongoa tooa i Samaria gera manata mamana ana na baelana a God, gera ka oodua a Peter fai nia a John siada. ");
INSERT INTO llu_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Si kada daaro dao ana, daaro ka fooa fuana tooa nae gi da manata mamana hai gera ka ngalia na Aanoedoo Aabu. ");
INSERT INTO llu_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Sulia na Aanoedoo Aabu e langi kasi sifo ua faafia ta wane ada. Haia, ma ni gera mone da siuabu sui na ana hatana Lord Jesus. ");
INSERT INTO llu_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Sui a Peter ma John daaro ka aalua aba daaro gi i fafoda, ma gera kafi ngalia na Aanoedoo Aabu. ");
INSERT INTO llu_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Haia, ana si kada a Simon e rikia na aposol gi da aalua abada i faafida, ma gera ka ngalia na Aanoedoo Aabu, nia ka ngalia si malefo ka hasi uria falelanalaa fuana a Peter ma a John, ");
INSERT INTO llu_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ka bae urii, <<Moro falea si mamanaa naa fuagu hai lea doo ku aalua na abagu i fafona ta wane, tara nia ka ngalia laugo na Aanoedoo Aabu.>> ");
INSERT INTO llu_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Sui a Peter e oolisia ka urii, <<Nia e bobola fuana si malefo oe fai nia ni oe moro ka funu, sulia o manata hasa na falelaa nia a God na doo uria folilana ana malefo. ");
INSERT INTO llu_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Haia, ma ni oe langi osi bobola go uria raolaa fai gemelu, sulia na manatalamu langi kasi oꞌolo i naona a God. ");
INSERT INTO llu_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","O oolitai manata naa faasia si manatalaa taꞌa oe nae gi, ma oko fooa fuana Lord eeri ka manata luke oe faasia manatalaa taꞌa oe gi. ");
INSERT INTO llu_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Sulia nau ku riki oe o kwaifii taꞌa asianaa, ma oko too i farana kanilaa ana aade taꞌalaa.>> ");
INSERT INTO llu_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Sui a Simon ka bae urii fuana Peter ma a John, <<Moro fooa fuana Lord fuagu, eeri tesi doo ana doo naa gi na moro haeda kasi dao ani nau.>> ");
INSERT INTO llu_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ma i buira, a Peter fai nia a John daaro faarai sulia na taa gi na daaro haitamana ana Jesus ma daaro ka bae sulia baelana a Lord. Sui daaro ka ooli fui Jerusalem. Ma ana oolilaa daaro, daaro ka ainitalo ana Faarongolaa Diana ana maefera oro gi i Samaria. ");
INSERT INTO llu_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ma tee ensel a Lord e faarai fuana a Filip ka urii, <<O aade aagau, oko lea i bali alaa sulia na tala too i Jerusalem ka lea uria Gasa.>> (Tala nae, langi gera kasi lea naa sulia.) ");
INSERT INTO llu_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Ma a Filip ka aade aagau, ma ka lea. Haia, ma tee wane baita faasia i Etiopia e lea laugo mai sulia tala nae e ooli uri fera nia. Na wane naa nia na wane uria aadalaa sulia na malefo nia na aaofia ni geni i Etiopia. Nia too mai Jerusalem ana fooalaa fuana a God, sui ka ooli na ana fera laona doo ni lealaa nia na hosi nae e abalangainia. Ma si kada nia lea ana, nia gwouru, ka iidumia ana buka na profet Aesea e kedea. ");
INSERT INTO llu_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Sui na Aanoedoo Aabu ka bae urii fuana Filip, <<Lea, oko too garangia na wane loko.>> ");
INSERT INTO llu_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ma a Filip e lalao kou siana, ma ka rongoa nia iidumia ana buka profet Aesea, ma ka soeledia ka bae urii, <<Oe haitamana na taa na oe o iidumia?>> ");
INSERT INTO llu_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ma na wane baita naa e oolisia ka urii, <<Tara kuka haitama utaa ana, lea langi ta wane haia ka talamatai nia fuagu?>> Ma nia ka soea a Filip eeri ka raa kou siana hai ka gwouru fai nia. ");
INSERT INTO llu_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Haia, na Kedelaa Aabu na nia e iidumia, nia urii, <<Nia iilingia na sipsip na gera talaia uria na haungilana, ma nia langi kasi haea tesi baea sulia e iilingia na gale sipsip kada gera olea ana iifuna ma langi si aangi. ");
INSERT INTO llu_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ma daka faawaelaa ada ana asianaa, ma gera ka keto nia ana sugelaa gi. Haia, ma ka langi laugo ta wane haia ka haea tesi doo sulia na ooliolitana gi, sulia na mourilana la molaagali e sui naa.>> ");
INSERT INTO llu_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Haia, na wane baita naa ka bae urii fuana Filip, <<Faarongo nau, tei naa profet naa e bae sulia? Suli nia i talana, langi sulia ta wane ete ana?>> ");
INSERT INTO llu_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ma a Filip ka talaꞌae faarailaa fuana sulia na Faarongolaa Diana sulia a Jesus, hafalia ana si kade Kekedelaa Aabu naa. ");
INSERT INTO llu_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ma ana si kada gera lea sulia tala, gera ka liu ootofana tee kafo. Ma na wane baita naa ka bae urii fuana Filip, <<Na kafo naa, taa naa lui nau langi kusi siuabu?>> ");
INSERT INTO llu_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Ma a Filip ka bae urii fuana, <<Oe haitamana oko siuabu go amu, lea so oko manata mamana ana a Jesus ana mourilamu teefou.>> Nia oolisia ka urii, <<Iiuka, nau ku manata mamana ana Jesus Christ nia na Wela a God.>> ");
INSERT INTO llu_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Sui na wane baita na ka haea hosi naa ka take ngado, ma daaro Filip daaro ka sifo laona kafo, ma Filip ka siuabua. ");
INSERT INTO llu_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Haia, si kada daaro tae mai ana faasia la kafo, na Aanoedoo a Lord lea mai ka ngalia aliꞌali na ana a Filip. Ma na wane baita naa ka langi si riki nia naa lau. Ma nia ka lea dongaa na ana, fai nia na eelelaa baita. ");
INSERT INTO llu_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ma a Filip ka dao aliꞌali na ana i Asotus, ma ka liufia maefera i seenae gi fai nia ainitalongailana na Faarongolaa Diana ana fera nae gi, lea ka dao i fera Sesarea. ");
INSERT INTO llu_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ma ana si kada nae laugo, a Saul ka tasa dongaa fai nia na baelaa nia gi uria na haungilana oote fafurongo a Lord gi. Ma nia ka lea siana na Fooanigwou, ");
INSERT INTO llu_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ma ka gania haia nia ka kedea ta faarailaa fuana na wane baita gi ana Beu Aabu ni Figulaa gi i Damaskus, hai gera ka faalamainia uria nanilaa uria na tooa na da manata mamana ana a Lord, ma lea nia daotoona ta wane langi ta geni urinae, nia ka bobola uria na dumulilada ma ka ooli mai faida fui Jerusalem. ");
INSERT INTO llu_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ma ana si kada nia lea fui Damaskus ma ka dao garangia na kou i fera, aliꞌali na raralaa faasia lao mamangaa ka rara gali nia. ");
INSERT INTO llu_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ma i nia ka asi nia i hae gano, ma nia ka rongoa tee lingee doo ka bae urii fuana, <<Saul, Saul! Uria taa na oko iinokesi nau?>> ");
INSERT INTO llu_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sui a Saul e oolisia ka urii, <<Lord, oe ni tei naa?>> Ma na lingee doo naa e oolisia ka urii, <<I nau a Jesus, na wane na o iinokesia. ");
INSERT INTO llu_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Haia, o tatae, oko lea i fera haia daka faarongo oe ana si taa na fuana oko iilia.>> ");
INSERT INTO llu_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ma na wane nae gi na da lea fai nia a Saul, gera ka too ngado, ma langi dasi haea ta baea. Ni gera mone da rongoa na lingee doo nae, ma langi dasi rikia go ta wane. ");
INSERT INTO llu_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sui a Saul e tatae mai, ma ka kwalia na maana gi, ma ka afetai fuana haia so ka rikia tesi doo. Ma gera dau ana abana, gera ka talaia uria i Damaskus. ");
INSERT INTO llu_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ma sulia oolu maedani naa, Saul langi kasi rikia ana tesi doo. Ma sulia oolu maedani nae gi laugo, ma ka langi si ania tesi fanga, nia ka langi si gwoufia tesi kafo. ");
INSERT INTO llu_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Haia, tee fafurongo a Jesus hatana a Ananias e too laugo i Damaskus, ma nia e rikia a Lord ana faataia. Ma a Lord ka bae urii fuana, <<Ananias ae.>> Ma a Ananias e oolisia ka urii, <<Lord ae, nau naa.>> ");
INSERT INTO llu_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","A Lord ka bae urii fuana, <<O aade aagau, oko lea uria na tala na gera alangia ana <Tala Oꞌolo>, ma oko lea uria luma a Judas, oko soeledia uria tee wane faasia i Tarsus hatana a Saul. Nia e fooa ana nae, ");
INSERT INTO llu_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ma nia ka rikia tee wane ana faataia hatana a Ananias e ruu mai siana ma ka aalua na abana gi faafia eeri na maana gi ka aada lau.>> ");
INSERT INTO llu_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Sui a Ananias e oolisia ka urii, <<Lord ae, tooa oro gi asianaa gera uunuunu siagu sulia wane naa ma na doo taꞌa oro gi nia e iilia fuana tooa oe gi i Jerusalem. ");
INSERT INTO llu_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ma i nia e lea mai i seegi i Damaskus naa eeri nia ka dumulia ni tei gera na da fooasi oe, sulia na fataabu baita gi da faalamainia fuana.>> ");
INSERT INTO llu_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","A Lord e oolisia ka bae urii fuana, <<O lea amu, sulia i nau naa ku aadafili nia hai ka rao fuagu ma ka ainitalongainia na hatagu siada tooa maadiu gi ma na aaofia gi ma fuana tooa i Israel gi laugo. ");
INSERT INTO llu_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Haia, tara i nau ana i talagu na tara kuka faatainia fuana taa gi na tara nia ka nonifii ana gi sulia na ainitalolaa ani nau.>> ");
INSERT INTO llu_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Sui a Ananias e lea ka ruu siana i luma nae, ma ka aalua abana gi fafona Saul, ma ka bae urii, <<Wai haasi Saul ae, a Jesus na Lord i talana na e oodu nau mai. Nia baa e faatai fuamu sulia na tala ana si kada baa o lea mai see. Nia ka oodu nau mai, eeri oko aada lau ma oko fungu ana Aanoedoo Aabu.>> ");
INSERT INTO llu_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ma aliꞌali na doo mala na uunufae iia gi ka asia faasia na maana a Saul, ma nia ka aada lau. Sui nia e tatae, ka take, ma ka siuabu. ");
INSERT INTO llu_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ma buira nia fanga sui, na nonina kafi rigita lau. Ma a Saul ka too fai nia na fafurongo gi i Damaskus sulia aange maedani. ");
INSERT INTO llu_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ma nia ka lea aliꞌali uria Beu Aabu ni Figulaa, ma ka talaꞌae baelaa naa sulia a Jesus, <<I nia na Wela nia a God.>> ");
INSERT INTO llu_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Haia, tei gera na da rongo nia, gera ka kwele asianaa, ma gera ka ledida kwailiu daka urii, <<Na wane naa baa e too i Jerusalem, ma ka haungia ni tei gera baa da fooasia a Jesus? Ma nia e lea mai see eeri ka dumulida ma ka talaida siana na fataabu baita gi.>> ");
INSERT INTO llu_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Sui na baelana a Saul ka rigita asianaa ma ka faamamana a Jesus nia na wane aadafililana a God. Ma e urinae, na Jiu gi na gera too i Damaskus, gera ka lalafusia na oolisilanalaa ana tesi doo. ");
INSERT INTO llu_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ma i buira maedani oro gi e sui, na Jiu gi gera ka oofu uria haungailana teni si manata eeri gera ka haungia a Saul. ");
INSERT INTO llu_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Haia, ana dani ma na rodo gera ka folo usia na maehaga ana fera nae eeri gera ka haungia. Sui a Saul ka rongo aalinga ana manata gera gi. ");
INSERT INTO llu_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ma ana tee fe rodo, na fafurongo nia gi da ngalia, daka faasifoa laona na lulue uria i maa ana mae kwakwada gwouna sulufou na gera uia galia ana fera nae. ");
INSERT INTO llu_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ma a Saul ka lea i Jerusalem, ma ka iiliili uria lea oofulaa fai gera na tooa na da manata mamana ana a Jesus. Sui langi gera kasi manata mamana ana hasa nia na fafurongo a Jesus laugo, ma gera ka mou ani nia. ");
INSERT INTO llu_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Haia, a Banabas e lea mai, ka talaia siana na aposol gi, ma ka faarongo gera ana na a Saul e rikia a Lord sulia tala, ma a Lord ka faarai laugo fuana. Nia ka faarongo gera laugo ana a Saul na e bae raraꞌa sulia a Jesus i Damaskus. ");
INSERT INTO llu_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ma gera kafi manata mamana, ma a Saul kafi too fai gera, ma ka liufia fera i Jerusalem, ma ka bae raraꞌa sulia a Jesus. ");
INSERT INTO llu_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ma nia ka bae ma ka oolisusuu fai nia na Jiu gi na gera bae ana baelaa Grik, ma gera ka iiliili uria haungilana. ");
INSERT INTO llu_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ma ana si kada na tooa gi na da manata mamana da rongoa si doo naa, gera ka talaia a Saul uria i Sesarea, ma gera ka oodua uria i Tarsus. ");
INSERT INTO llu_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Haia, na soefaataia i Judea ma i Galili ma i Samaria, gera kafi too ana fanualama ana si kada nae. Ma na soefaataia ka rigita ma ka baita lau ana tooa oro gi na gera manata mamana. Nia urinae, sulia na Aanoedoo Aabu e adomi gera, ma gera ka manata baita ana a Lord. ");
INSERT INTO llu_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ma a Peter ka lea ana maefera oro gi, ma ana tesi kada nia ka lea i Lida uria na daotoolana tooa a God gi na gera too i lao maefera nae. ");
INSERT INTO llu_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Haia, i seenae, nia ka daotoona tee wane hatana a Aeneas, na nonina e mae, ma ka lalafusia tataelaa faasia na iifitai nia sulia kwalu fe ngali. ");
INSERT INTO llu_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ma a Peter ka bae urii fuana, <<Aeneas ae, Jesus Christ tara ka gura oe ana si kada nae. O tatae, oko lukumia na iifitai oe.>> Ma aliꞌali a Aeneas ka tatae. ");
INSERT INTO llu_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ma na tooa gi sui na gera too i Lida ma i Saron, gera rikia, ma gera ka manata mamana ana a Lord. ");
INSERT INTO llu_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Haia, i Jopa, tee geni na e manata mamana e too i seenae, na hatana ni Tabita. (Ana baelaa i Grik ni Dorkas, ma na malutana na doo fai ae gera alangia ana <<dia>>.) Nia e iilia asianaa si doo diana oro gi ma ka adomia asianaa laugo na tooa na da siofaa. ");
INSERT INTO llu_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ma ana si kada naa, nia e matai, ma ka mae. Haia, gera saufia nonina, sui gera ka ngalia uria kade luma i langi, ma gera ka faateofia i seenae. ");
INSERT INTO llu_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Haia, na fera nae Jopa langi kasi tau go faasia i Lida, ma ana si kada na tooa na da manata mamana gi da rongoa a Peter e too i Lida, gera ka oodua roo wane gi siana fai nia na baelaa naa gi urii, <<O lea aliꞌali mai siamelu.>> ");
INSERT INTO llu_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Sui a Peter e lea fai daaro. Ma si kada nia e dao ana, gera ka talaia uria kade luma nae i langi. Na oru geni gi sui go, da oofu siana a Peter i seenae, ma daka aangi, ma gera ka faatainia na maku oro gi na geni nae e taida si kada nia e mouri ua ana. ");
INSERT INTO llu_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Sui a Peter ka oodu gera teefou haia daka haga i maa faasia kade luma nae, ma nia ka boururu, ka fooa. Sui nia ka aabulo fuana nonidoo nae, ka bae urii fuana, <<Tabita ae, o tatae.>> Ma na geni nae ka kwalia maana ma si kada nia e aada kou, nia ka rikia a Peter, ma nia e tatae ma ka gwouru. ");
INSERT INTO llu_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ma a Peter ka dau ana na abana, ma ka adomi nia ka tatae. Sui nia ka soea mai na oru geni baa gi fai nia na tooa aai na da manata mamana gi, ma ka faatainia ni Dorkas na e mouri naa. ");
INSERT INTO llu_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Sui na uunuunulaa sulia na doo naa ka talofia fera i Jopa loulou, ma na tooa oro gi gera ka manata mamanaa ana a Lord. ");
INSERT INTO llu_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ma a Peter ka too i Jopa sulia fe dani oro fai nia na wane hatana Simon, na wane rao ana ungana doo fai ae gi. ");
INSERT INTO llu_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ma tee wane i Sesarea na hatana a Kornelius, nia na wane baita ana wane ni oomea gi i Rom na gera alangia ana <<Oomea i Itali>>. ");
INSERT INTO llu_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Nia na wane na e hae baita ana a God, ma ka fooasia laugo sulia dani. Nia fai nia na aebara nia gi teefou, gera fooasia a God, ma ka iili doo diana oro gi uria adomilana tooa siofaa gera Jiu gi laugo. ");
INSERT INTO llu_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Haia, ma e bobola fai nia ooula kade hato i haulafi ana tee fe dani, nia ka rikia tee faataia na e faatai folaa ana na ensel a God e lea mai ma ka bae urii fuana, <<Kornelius ae.>> ");
INSERT INTO llu_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ma nia e bubu tete ana ensel nae, ma ka mou, ma ka urii, <<Wane baita ae, taa naa oe o dooria?>> Ma na ensel naa e oolisia ka urii, <<God e eele asianaa faafia na fooalaa oe gi fai nia na aade dianalaa oe gi ana adomilana na tooa siofaa gi, ma nia ka langi si manata buro uria na oolisilamu. ");
INSERT INTO llu_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Haia, o oodua teni wane ana si kada nae fui Jopa eeri daka soea mai tee wane hatana a Simon Peter. ");
INSERT INTO llu_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Nia e too i laona luma nia tee wane e rao ana ungana doo fai ae gi hatana a Simon baa na luma nia e too i fakana aasi.>> ");
INSERT INTO llu_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Na ensel naa e faarai urinae fuana sui, ka lea na ana. Ma a Kornelius ka soea roo wane ana wane gi na da rao i laona luma nia fai nia tee wane ana oomea nia, na wane na nia e fooasia laugo a God. ");
INSERT INTO llu_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ma nia ka faarongo gera ana na doo nia rikia ma ka rongoa. Sui nia ka oodu gera fui Jopa. ");
INSERT INTO llu_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Sui ana ruana maedani, kada daalu lea ua kou ana ma daalu ka garangi dao na kou ana maefera i Jopa, a Peter ka raa i fafo luma uria fooalaa i aasoa. ");
INSERT INTO llu_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ma nia ka fiolo ma ka doori fanga. Ma ana si kada gera aade aagau ua ana fanga, nia ka rikia na faataia. ");
INSERT INTO llu_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Nia ka rikia i langi e ifi, ma ka rikia na doo iilingia maku rereba na gera faasifoa mai uria la molaagali ana fai susui doo gi. ");
INSERT INTO llu_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Haia, laona maku nae na doo momouria gi ma doo fai ae gi, doo aangoango gi, ma na manu kwasi gi. ");
INSERT INTO llu_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Sui nia ka rongoa tee lingee doo ka bae urii fuana, <<Peter ae, tatae oko haungida, ma oko anida.>> ");
INSERT INTO llu_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ma a Peter e oolisia ka bae urii, <<Lord ae, langi asianaa go, sulia nau langi kusi ania na doo na e mola ma ka bilia.>> ");
INSERT INTO llu_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Sui na lingee doo naa ka bae lau urii fuana, <<Langi osi hae mola ma langi bilia ana tesi taa na a God e haea e diana uria anilana.>> ");
INSERT INTO llu_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Oolu si kadamanga na doo na e faatai ana urinae, sui daka oolifainia laugo ada fui langi. ");
INSERT INTO llu_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ma a Peter ka manata sulia malutana faataia na nia rikia. Ma ana si kada nae laugo, na wane baa gi a Kornelius e ooduda mai, gera ka soeledi uria luma a Simon, ma gera ka dao naa maana maehaga. ");
INSERT INTO llu_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Sui gera soe daka urii, <<Taa wane hatana Simon Peter e too i see?>> ");
INSERT INTO llu_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Ma ana si kada nae, a Peter e manata ua go ana sulia na faataia nae nia rikia sulia nia dooria ka haitamana na malutana. Ma na Aanoedoo Aabu ka bae urii fuana, <<Fafurongo fasi, na oolu wane da dao i see, gera nani uri oe. ");
INSERT INTO llu_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Tatae, oko sifo siadaalu, ma langi osi manata ruarua uria lealaa fai daalu, sulia nau naa ku oodu daalu mai.>> ");
INSERT INTO llu_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Sui a Peter e sifo kou siadaalu, ka bae urii, <<I nau naa wane baa na molu ledi uria. Haia, ma na taa na molu lea mai uria?>> ");
INSERT INTO llu_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Gera oolisia daka bae urii, <<Kornelius na wane baita ana oomea naa e oodu gemelu mai. Nia na wane diana, ma ka fooasia laugo a God. Ma na tooa i Jiu gi sui gera ka manata baita asianaa ani nia. Haia, ma tee ensel a God e haea fuana eeri ka soe oe uria i luma nia, haia ka rongoa tesi taa na tara oko haea.>> ");
INSERT INTO llu_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ma a Peter ka soea kou wane nae gi i luma, eeri daalu ka teo fai nia ana fe rodo nae. Sui ubongi ana ruana maedani, nia e aade aagau, ma ka lea fai daalu ma fai nia teni wane gi na da manata mamana faasia i Jopa. ");
INSERT INTO llu_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ana fe dani buira, gera ka dao i Sesarea na gula a Kornelius e maasi nia ana. Ma na tooa futa nia gi ma na ruana nia gi na e soeda mai, gera laugo daka maasia fai nia a Kornelius. ");
INSERT INTO llu_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Ma si kada Peter hasa e ruu kou, a Kornelius ka kwaitodai fai nia, ma ka asi nia maana aena Peter, ma ka boururu usia. ");
INSERT INTO llu_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Sui Peter ka faatataea ka bae urii, <<O take, sulia ni nau na wane laugo.>> ");
INSERT INTO llu_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ma Peter e faarai fai nia a Kornelius, ma daaro ka ruu kou luma. Ma nia ka rikia tooa oro gera figu. ");
INSERT INTO llu_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ma nia ka bae urii fuada, <<Gomolu molu haitama diana sui go ana na kwaieresia gemelu Jiu gi e luia langi melu si ruu lao luma gomolu gi, ma langi melu si iili oofu ana tesi doo fai gamu tooa na langi molu si Jiu. Sui a God ka faatainia fuagu langi kusi manata ta wane ana wane bilia. ");
INSERT INTO llu_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Nia naa aadea nau ku lea mai ana si kada na oe soe nau mai, ma langi kusi lea mai fai nia ta manata ruarualaa. Haia, nau ku ledi gamu, uria taa na molu ka kwaiodui kou uri nau?>> ");
INSERT INTO llu_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","A Kornelius e oolisia ka urii, <<Oolu maedani e sui na kou, i nau ku fooa agu i luma nau i haulafi urinae, ma aliꞌali tee wane oofi ana maku sinasina ka take i naofagu, ");
INSERT INTO llu_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ma ka bae urii, <Kornelius ae, God e rongoa fooalaa oe, ma ka rikia na raolaa diana oe gi ana adomilana na tooa siofaa. ");
INSERT INTO llu_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","O oodua ta wane ka lea i Jopa eeri ka soea mai tee wane hatana Simon Peter. Nia e too siana a Simon na wane baa e rao ana ungana doo fai ae gi, ma na luma nia e too i fakana aasi.> ");
INSERT INTO llu_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Nia naa, i nau aliꞌali kuka kwaiodui kou uri oe. Ma oe oko diana asianaa na oko lea mai. Haia, a God e too fai golu sui, ma melu ka kwaimaasi uria rongolana tesi taa na a Lord e dooria oko haea.>> ");
INSERT INTO llu_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","A Peter e bae ka urii, <<I nau ku haitama diana na ana, a God e rikia na tooa gi sui ka bobola sui go, ma e langi kasi eefaa wane gi. ");
INSERT INTO llu_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","So ni tei ka manata baita ana a God ma ka iilia si doo oꞌolo gi, nia naa na wane na a God e dooria, boroi ana ta aebara taa na e lea mai faasia. ");
INSERT INTO llu_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Molu haitamana naa na baelaa a God e falea fuana na tooa i Israel gi sulia na Faarongolaa Diana ana na fanualama na a Jesus Christ e falea. I nia na Lord fuana tooa gi sui. ");
INSERT INTO llu_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Molu ka haitamana naa laugo na doo baita baa gi e fuli i Israel, hafali mai i Galili, buira baa a John e faatolomai sulia na siuabulaa. ");
INSERT INTO llu_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ma molu ka haitamana naa laugo sulia a Jesus na wane i Nasaret, ma molu ka haitamana laugo a God ka falea na Aanoedoo Aabu ma na mamanaa fuana. A Jesus e lea ana gula oro gi, ma ka iilia na doo diana gi ma ka guraa na tooa gi da too i farana kanilaa a Satan, sulia a God e too fai nia. ");
INSERT INTO llu_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","I gemelu melu rikia na doo nae gi a Jesus e iilida i Israel ma i Jerusalem. Sui gera ka haumaeli nia ada ana fotoilana i fafona airarafolo. ");
INSERT INTO llu_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Sui, a God ka tataea faasia na maea ana ooluna fe dani, ma ka faatai nia fuamelu. ");
INSERT INTO llu_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Nia langi si faatai lau fuana tooa gi sui, ma nia e faatai go ana fuamelu na tooa gi na a God e filid