﻿USE sofia;
DROP TABLE IF EXISTS sofia.llg_vpl;
CREATE TABLE llg_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES llg_vpl WRITE;
INSERT INTO llg_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Sososan Manetualain nakadadaꞌdik lalai no daebafok, no isi nala. ");
INSERT INTO llg_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Lelek ndia, daebafok bei taa dadi, ma basan bei mana bebebik neu esa. Hambu oe nai basa mamanak lalaꞌen. Ma makiu-mumuuk, mboti nala oe ndia. Manetualain Dula Dale Malalaon laa-laa nai oe lain. ");
INSERT INTO llg_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Boe ma, Manetualain kokolak, nae, “Musi hambu manggaledok.” Ana kokolak nateꞌe boe ma, manggaledok dadi leo. ");
INSERT INTO llg_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Ana nita manggaledok ndia, boe ma Ndia dalen namahoko, huu hata fo Ana taon ndia so, memak malole. Boe ma, Ana tada manggaledok ndia no makiuk, fo esa-esako no ndia fai hehelin. ");
INSERT INTO llg_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Ana foi manggaledok ndia, nade ‘leledok’, ma, makiuk ndia, ‘leꞌodaek’. Fai kaesan ndindia. ");
INSERT INTO llg_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","7","Boe ma, Manetualain kokolak seluk, nae, “Musi hambu mamana louk, fo tada kofeꞌe oe. Huu ndia, de hambu oe nai babaꞌek lain, ma hambu oe nai babaꞌek dae.” Ana kokolak basa leondia, boe ma oe ndia, nabaꞌe neu dua. ");
INSERT INTO llg_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Ana foi babaꞌek lain ndia, nade ‘lalai’. Fai kaduan ndindia. ");
INSERT INTO llg_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Boe ma, Manetualain kokolak seluk bali, nae, “Oe manai babaꞌek dae ndia, musi nakabubua nai mamanak esa, fo ela hambu dae madak.” Kokolak basa leondia, boe ma hambu dae madak leo. ");
INSERT INTO llg_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","De dae madak ndia, Ana foin naꞌde ‘madak lain’; ma oe mana makabubuak ndia, Ana foin naꞌde ‘tasi’. Nita basa sila, boe ma Ndia dalen namahoko, huu hata fo Ana taon ndia so, memak malole. ");
INSERT INTO llg_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Boe ma, Manetualain kokolak seluk bali, nae, “Madak lain, musi namoli sesele-ngganggalik. Musi hambu sesele-ngganggalik mana maboak, kadeꞌek, ma, mana madoo momodok. Ela sesele-ngganggali kala esa-esako, kalua buna-boan, tungga esa-esak numban.” Ana kokolak basa leo ndia, boe ma basa sesele-ngganggali kala, dadi. ");
INSERT INTO llg_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Nai madak lain, sesele-ngganggali kala, kalua sila buna-boan tungga esa-esako numban. Nita basa sila, boe ma Ndia dalen namahoko, huu hata fo Ana taon ndia so, memak malole. ");
INSERT INTO llg_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Fai katelun ndindia. ");
INSERT INTO llg_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","15","Basa de, Manetualain kokolak seluk bali, nae, “Nai lain ele, musi hambu bua manggaledok mata-mata kala, fo ala tao manggaledo daebafok ia. Musi hambu mana tao manggaledok nai fai leledon, ma feꞌek nai fai leodaen. Basa sala dadik tanda, fo ela bisa hingga faik, teuk, ma fai hanas no fai oefaak.” Ana kokolak nateꞌe, boe ma basa bua manggaledo kala sila, ala dadi. ");
INSERT INTO llg_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Ana tao bua manggaledo inahuuk dua. Inahuuk nalan seli, nasaꞌa nai fai leledon, ma kadiꞌik, nasaꞌa nai fai leꞌodaen. Ndia boe oo, Ana tao ndu kala. ");
INSERT INTO llg_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Ana heti bua sala sila lai lalai, fo ala lasaꞌa leni daebafok mai. ");
INSERT INTO llg_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Ala lasaꞌa lai fai leledok ma lasaꞌa, lai fai leꞌodaen. No leondiak, de ala tada manggaleꞌdok neme makiuk mai. Nita basa sila, boe ma Ndia dalen namahoko, huu hata fo Ana taon ndia so, memak malole. ");
INSERT INTO llg_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Fai kahaan ndindia. ");
INSERT INTO llg_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Boe ma, Manetualain kokolak seluk bali nae, “Musi hambu banda mata-mata kala, fo lasoda lahenu oe. Ma musi hambu mbuik mata-mata kala, fo ala laa lai daebafok lain.” ");
INSERT INTO llg_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Boe ma, Ana nakadadaꞌdik basa iꞌa mata-mata kala, ma banda inahuuk mana masoda, lai oe dale. Ndia boe oo, nakadadaꞌdik basa mbuik mata-mata kala, fo mana laa lai lalai. Nita basa sila, boe ma Ndia dalen namahoko, huu hata fo Ana taon ndia so, memak malole. ");
INSERT INTO llg_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Ana kokolak fee babaꞌe-babatik, neu basa banda la sila, nae, “Iꞌa kala musi lamanoꞌu, fo tao lahenu oe sudi nai bee. Ma mbui kala, musi ala lamanoꞌu boe.” ");
INSERT INTO llg_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Fai kaliman ndindia. ");
INSERT INTO llg_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","25","Boe ma, Manetualain kokolak seluk bali, nae, “Musi hambu banda mata-mata kala, fo lasoda lai madak lain. Fo leo, banda nakaboik, banda fui, ma banda mana lae-lodok nai dae, esa-esak no ndia numban.” Ana kokolak basa leondia boe ma, hambu basa banda la sila leo. Nita basa sila, boe ma Ndia dalen namahoko, huu hata fo Ana taon ndia so, memak malole. ");
INSERT INTO llg_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Manetualain kokolak seluk nae, “Mai ita tao hataholi tungga Ita mataon. Ela ala lakaneni, ma ala heti basa iꞌa kala, malai tasi dale, basa mbui kala malai lalai, basa banda nakaboi kala, ma basa banda feꞌe kala, fo mana masoda lai daebafok.” ");
INSERT INTO llg_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Boe ma, Ana nakadadadik hataholi tungga Ndia mataon. Ana nakadadadik touk ma inak. ");
INSERT INTO llg_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","De Ana kokolak fee sala babaꞌe-babatik, nae, “Ei musi bonggi mala makadotok, fo tao mahenu daebafok ia, ma heti sala. Au boe oo fee hak neu ei, fo makaneni iꞌa kala, mbui kala, ma basa banda la, malai madak lain. ");
INSERT INTO llg_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Mamanene matalolole! Au fee ei nanaꞌak mata-mata kala nai daebafok ia. Fo ndia: sesele-ngganggali maboa kala, kadeꞌe kala, ma mana madoo momoꞌdo kala. ");
INSERT INTO llg_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Au boe oo, fee basa sesele-ngganggalik mata-mata kala, fo ala dadik neu banda la nanaꞌan. Hambu nanaꞌak soaneu banda nakaboik, banda fui, banda mana lae-loꞌdok, ma mbui kala.” Ana kokolak basa leondia boe ma, hambu basa nanaꞌa mata-mata kala sila leo. ");
INSERT INTO llg_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Nita basa sila, boe ma Ndia dalen namahoko, huu hata fo Ana taon ndia so, memak lolen ana seli. Fai kaneen ndindia. ");
INSERT INTO llg_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","No leondiak, Manetualain tao nala lalai, ma daebafok, no basa isi nala. ");
INSERT INTO llg_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Ana tao nabasa sala, boe ma foꞌa mai, nandaa no fai kahitun, de Ana hahae. ");
INSERT INTO llg_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Ana tao fai kahitun dadik neu fai inahuuk, neme fai-fai feꞌe kala sila mai. Ana hetin leondiak, huu Ana tao basa Ndia uen so, boe ma nai fai kahitun Ana hahae aon. ");
INSERT INTO llg_vpl VALUES ("GN2_4a","002_2_4a","GEN","2","4a","4a","Manetualain nakadadadik lalai ma daebafok, tutuin leo ndiak. ");
INSERT INTO llg_vpl VALUES ("GN2_4b","002_2_4b","GEN","2","4b","4b","Lelek fo MANETUALAIN bei fo Ana mulai nakadadaꞌdik lalai no daebafok ndia, ");
INSERT INTO llg_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","6","bei taa hambu sesele-ngganggalik esa boe, huu Ana bei taa nakonda uda. Lelek ndia, kada hambu oe mana masambulak neme dae dale mai, fo nakataba daebafok. Ma hataholi bei taa, fo ana tao osi. ");
INSERT INTO llg_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Basa boe ma, MANETUALAIN Ana haꞌi nala dae fa, de Ana taon dadik hataholi. Boe ma, Ana fuu ani hahaen neni hataholi ndia idu bolon dale neu, de hataholi ndia nasoda tutik. ");
INSERT INTO llg_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Basa ndia, boe ma MANETUALAIN tao nala osi esa, nai dae Eden boboan dulu. De Ana fee hataholi ndia, leo nai osi ndia laladan. ");
INSERT INTO llg_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Nai osi ndia dalek, Ana nakamomolik ai malole mata-mata kala, fo hataholi laꞌan, na, malada. Ana nakamomolik ai matak dua boe, nai osi ndia laladan. Mete ma hataholi naꞌa ai esak ndia boan, na, ana nasoda nakandoo. Tehuu, mete ma hataholi naꞌa ai esa fꞌeꞌek ndia boan bali, na, ana bisa bubuluk bee ndia malole, ma bee ndia manggalauk. ");
INSERT INTO llg_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Hambu lee esa, faa nakataba osi ndia, ma ana faa neni deak neu. De ana baꞌen neu haa. ");
INSERT INTO llg_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Ndia baꞌe kaesan, naꞌde Pison. Baꞌek ndia, ana eo ndule dae Hawila, fo hambu lilo-mbilas noꞌuk, ");
INSERT INTO llg_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","fo lilo-mbila isi-isik, hambu ai daa kaboo menik, ma hambu batu manggadilak. ");
INSERT INTO llg_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Lee ndia, baꞌe kaduan, nade Gihon. Baꞌek ndia, ana eo ndule dae Kus. ");
INSERT INTO llg_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Ndia baꞌe katelun, naꞌde Tigris. Baꞌek ndia, ana dadik too, nai dae Asyur boboan dulu. Baꞌe kahaan, nade Efrat. ");
INSERT INTO llg_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","MANETUALAIN fee hataholi ndia, leo nai Eden laladan, fo ana nakaneni neulalau osi ndia. ");
INSERT INTO llg_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Boe ma, Ana palenda hataholi ndia, nae, “O bole muꞌa basa ai boak sudi bee, neme basa ai malai osi ia dalek. ");
INSERT INTO llg_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Tehuu, hambu ai esa, fo o taa bole muꞌan. Fo ndia, ai ndia fo nafada bee ndia malole, ma bee ndia manggalauk. Mete ma o muꞌan, na, neu ko o mate.” ");
INSERT INTO llg_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Boe ma, MANETUALAIN kokolak seluk, nae, “Taa malole, mete ma hataholi ia, mesa kana nasoda. De Au sangga tao feen, nonoon esa, fo nandaa non.” ");
INSERT INTO llg_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","20","MANETUALAIN laꞌu nala dae fa, de Ana tao nala banda, ma mbuik mata-mata kala. Basa de, Ana neni banda la, ma mbui kala sila, leu hataholi ndia, fo suek ana foi nade nala. Boe ma, hataholi ndia, foi banda la, ma mbui kala esa-esako naden. Tehuu, ndia mesa kana bei taa hambu nonook esa boe, fo nandaa non. ");
INSERT INTO llg_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Basa ndia, boe ma MANETUALAIN tao hataholi ndia, ana sunggu namanee. Ledoeik ana sunggu, boe ma Lamatuak haꞌi nala kaihusu duin esa, de ana tatana falik hinak ndia. ");
INSERT INTO llg_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Neme duik ndia mai, Ana taon dadik inak. Boe ma, Ana fee inak ndia neu hataholi ndia. ");
INSERT INTO llg_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Nita inak ndia boe ma, nae, “Awii! Ia dei! Ia bei fo nandaa no au! Ndia duin sama leo au duing. Ma ndia ao mbaan boe oo, sama leo au aombaang boe. Huu, ndia ndia, dadi neme touk mai, de, au foin, nade ‘inak’.” ");
INSERT INTO llg_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Huu ndia, de touk ana laꞌo ela ndia ina-man, fo neu nasoda dalek esa no saon, huu dua sala, dadik esa so. ");
INSERT INTO llg_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Faik ndia, dua sala lakahola holi-holik, tehuu ala tala lameda mae fa boe. ");
INSERT INTO llg_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Neme basa banda la, fo MANETUALAIN nakadadadi kala lai daebafok ia, mengge malela masapepeko ana seli. Laꞌi esa, mengge natane inak ndia, nae, “Teteꞌbes, do? Manetualain kaꞌi nae, ‘Ei taa bole miꞌa ai boak, neme ai la manai osi ia, hetu?’ ” ");
INSERT INTO llg_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","3","Inak ndia, bala, nae, “Taa! Ai bole miꞌa! Tehuu, kada ai esa nai osi laladan, na, Manetualain kaꞌi ai taa bole miꞌan. Ana nae, ai taa bole miꞌan, ma taa bole koi laꞌe boan, te neu ko, ai mate.” ");
INSERT INTO llg_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Tehuu, mengge ndia nataa, nae, “Wei, ndia taa tetebes! Ei taa mate! ");
INSERT INTO llg_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Memak Manetualain kaꞌi leondiak, na, huu Ana bubuluk so, mete ma ei miꞌa ai boak ndia, na, ei dadik malelak sama leo Ndia. Fo ei bubuluk bee ndia malole, ma bee ndia manggalauk.” ");
INSERT INTO llg_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Boe ma, inak ndia suli, te ai ndia lolen seli, ma boan nonook leo ladan ana seli. De ana duduꞌa nae, “Mete ma au uꞌa ai boak ia, na, neu ko au dadik malelak.” Boe ma, ana seu nala ai boak ndia, de naꞌa. Basa ndia de neni fee saon, de ana naꞌa boe. ");
INSERT INTO llg_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Dua sala laꞌa basa boe ma bei fo ala bubuluk, ala lakahola holi-holik. Huu ndia de ala nato akidook, fo ala babaa neu sila makaholan. ");
INSERT INTO llg_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Ledo boꞌbon ndia, boe ma lamanene MANETUALAIN Ana laꞌo-laꞌo nai osi ndia. Boe ma, dua sala leu kekek, leu ai la dean, fo suek MANETUALAIN taa nita sala. ");
INSERT INTO llg_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Tehuu MANETUALAIN noke touk ndia, nae, “Wei! Adam, o nai bee?” ");
INSERT INTO llg_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Touk ndia nataa, nae, “Au amanene Lamatuak halan nai ia. Tehuu, au mae huu au akahola. Huu ndia, de au alai uu kekek.” ");
INSERT INTO llg_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Boe ma, MANETUALAIN nae, “See nafada nae o makahola? Talobee? Neu ko o muꞌa ai boak fo Au kaꞌik ndia, hetu?” ");
INSERT INTO llg_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Ana nataa nae, “Inak ia, fo Manetualain feen nanonoo no au ndia, ndia ndia, fee ai boak ndia de au uꞌa!” ");
INSERT INTO llg_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Basa boe ma, MANETUALAIN kokolak no inak ndia, nae, “Hatina de o tao leondiak?” Boe ma, inak ndia nataa nae, “Huu mengge kedi nala au! Huu ndia, de au uꞌa ai boak ndia leo.” ");
INSERT INTO llg_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Basa ndia, boe ma, MANETUALAIN sumba-soo mengge ndia, nae, “Huu o tataom ia, de Au huku o. Neme basa banda feꞌe kala mai, kada o mesa nggo hambu sumba-sook leo iak. Mulai neme hatematak ia mai losa o mate, kada o malae-lodok, munik o kalam, ma kada o muꞌa nai dae. ");
INSERT INTO llg_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Au tao o mua inak ia, ama musu makandoo. Leo ndiak boe, ei dua nggei numbu-sadu mala. O numbu-sadu mala, neu ko ala kiki hataholi ei tingga dean. Tehuu, ndia numbu-sadun esa, neu ko ana tao nakalulutu o langgam.” ");
INSERT INTO llg_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Basa ndia, boe ma Manetualain nafada inak ndia, nae, “Neu ko Au tamba o doidosom neu faik fo o mailu, ma tamba hedis neu faik fo o bonggi. Tehuu mae leondiak boe oo, o bei mahiik makandoo o saom. Ma ndia ana heti o.” ");
INSERT INTO llg_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Boe ma, Manetualain nafada touk ndia nae, “O taa tungga Au palendang, tehuu tungga kada o saom hihiin, losa o muꞌa ai boak ndia, fo Au kaꞌik ndia. De o boe oo hambu huhukuk, ma dae boe oo, hambu huhukuk. Mulai neme hatematak ia mai, losa o mate, o musi maue-maleꞌdi mbilu-mbuse foi dae, bei fo o bisa muꞌa. Ma maue-maledi no leo ndiak, bei fo o hambu masoda. ");
INSERT INTO llg_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Mae o sele-nggali mata-mata kala, tehuu, dae kada ana kalua dila-nggauk mesan. ");
INSERT INTO llg_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Boe ma, o maue-maledi mbilu-mbuse, bei fo dae fee o muꞌa. O musi maue-maledi mbilu mbuse leondiak, losa o mate. Au akadadadik o muma dae mai. De, mete ma o mate, na, o fali muni dae muu, seluk bali.” ");
INSERT INTO llg_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Basa ndia, boe ma Adam foi saon, nade ‘Hawa’ (fo ndandaan nae, ‘kasoꞌdak’, huu ndia ndia, basa hataholi masoda kala inan.) ");
INSERT INTO llg_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Boe ma, MANETUALAIN tao baloꞌa-papakek, neme banda louk mai, fo papaken papake dua sala. ");
INSERT INTO llg_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Boe ma, MANETUALAIN kokolak, nae, “Hatematak ia, hataholi la bubuluk bee ndia malole, ma bee dia manggalauk, sama leo Ita. Boso losak sila boe oo, leu laꞌa ai boak ndia, fo ana fee sala lasoda lakandoo.” ");
INSERT INTO llg_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Basa boe ma, Ana husi heni sala, leme osi Eden ndia mai, de ala leni mamana feꞌek leu, fo lasoda leme dae buna-boan mai. ");
INSERT INTO llg_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Ana husi heni sala, boe ma Lamatuak nadenu Ndia ata kalida nala leme nusa-sodak mai, fo leu lanea nai osi ndia boboan dulu. Ala toꞌu tafa nana leleuk neu-mai, fo mana mbilak leo haꞌi ia. Lamatuak nadenu sala kena dalak mana dalek neu, huu taa nau ala seu lala ai boak, fo mana fee sala lasoda lakandoo. ");
INSERT INTO llg_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Laꞌi esa, Adam neu sunggu no saon Hawa. Boe ma, inak ndia nailu. Basa boe ma, ana bonggi nala ana tou-anak esa. Boe ma, nae, “Au bonggi ala ana tou-anak esa so, huu MANETUALAIN fali nala au so.” Basa de ana foi kakanak ndia, nade Kaen (fo ndandaan nae ‘taon deak neu’). ");
INSERT INTO llg_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Boe ma, Hawa bonggi ana tou-anak esa bali. De ana foin, nade Habel. Neu faik fo dua sala, inahuu so, boe ma Habel hoo banda, ma Kaen tao osi. ");
INSERT INTO llg_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Laꞌi esa, Kaen neni ndia osin buna-boan luma, fo neni fee MANETUALAIN. ");
INSERT INTO llg_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Habel boe oo, neni ndia biꞌilombo ina nala ana sososa nala. Ana hala biꞌilombo sila, boe ma ana neni mbaa neulau ndoos, fee Manetualain. Nita leondiak, boe ma MANETUALAIN dalen namahoko, neu Habel no ndia tunu-hotu nala. ");
INSERT INTO llg_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Tehuu, tana hii Kaen no ndia tunu-hotun ndia. Boe ma, Kaen luli nalan seli, losa matan meluk. ");
INSERT INTO llg_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","De MANETUALAIN kokolak neu Kaen, nae, “Heeh, Kaen! Hatina de o mamanasa leondiak? Talobee, de o matam meluk leondiak? ");
INSERT INTO llg_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Mete ma o tao malole, na, neu ko Au simbok o no malole boe. Tehuu mta neuk! Mete ma o tao manggalauk, na, neu ko manggalauk ndia naꞌa nasafali o, sama leo meo kobo lafo. De mete ma, o mahiik tao manggalauk, na, malolenak o timba heni mema kana leo!” ");
INSERT INTO llg_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Laꞌi esa, Kaen fufudi Habel, nae, “Fadi aa! Mai fo ita lalaꞌok teni osi teu.” Ala losa ndia, boe ma kada nggengge neuk, Kaen tao nisa fadin. ");
INSERT INTO llg_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Boe ma, MANETUALAIN natane Kaen, nae, “Heeh, Kaen! O fadim nai bee?” Kaen nataa nae, “Au taa bubuluk ndia nai bee! Maehetuk au ia, mana toꞌu ndia ein, do?” ");
INSERT INTO llg_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Boe ma MANETUALAIN kokolak, nae, “Hatina de o tao manggalauk leondiak? Boso mae hetuk, o bisa mafuni faꞌdim daan neu dae, tehuu Au ita basan so! ");
INSERT INTO llg_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Hatematak ia, sumba-sook laꞌeneu o so. Huu ledoeik o tao misa fadim, dae ndia musi nala daan so. De hatematak ia, dae ndia taa bisa fee o masoda so bali. ");
INSERT INTO llg_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Mete ma o tao osi, na, dae taa fee o buna-boak, hata esa boe. Mulai neme hatematak ia mai, o soa kada maleu-laak muu-mai, leo hataholi mana toꞌa-taak, fo mana sangga sodak nai daebafok ia.” ");
INSERT INTO llg_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Tehuu, Kaen sapa MANETUALAIN kokolan ndia, de nae, “Awii! Manetualain aa! Talobee, de Manetualain fee sumba-sook ndia belan seli, losa au taa lemba abeꞌin so.” ");
INSERT INTO llg_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Huu Manetualain husi heni au, uma mamanak ia mai, de neu ko au dook uma Manetualain mai. Au soa kada aleu-laak uni suꞌdi bee uu. Boe ma, neu ko sudi see natonggo no au, na, ana tao nisa au.” ");
INSERT INTO llg_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Tehuu, MANETUALAIN nataa bala nae, “Taa leondiak! See tao nisa o, na neu ko Au hukun belan laꞌi hitu!” Boe ma LAMATUAK tao tanda neu Kaen, fo suek hataholi la bubuluk, suek hataholi la bubuluk, ala taa bole tao lisan. ");
INSERT INTO llg_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Boe ma, Kaen laꞌo ela mamanak ndia, de neni dook neu neme MANETUALAIN mai. Ana laꞌok losa mamanak esa, nai osi Eden boboan dulu. Mamanak ndia, nade Nod, fo ndandaan nae, ‘mandolo folek’. Basa boe ma, ana leo neu ndia. ");
INSERT INTO llg_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Basa ndia, boe ma Kaen sao, de saon nailu. Boe ma, ana bonggi ana tou-anak esa, fo ala foin, nade Henok. Boe ma, Kaen ana nambadedei nggolok esa. De ana foi nggolok ndia, nade Henok, tungga ndia anan naden. ");
INSERT INTO llg_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Boe ma, Henok anan ndia, Irad. Irad anan, Mehuyael. Mehuyael anan, Metusael. Ma Metusael anan, Lamek. ");
INSERT INTO llg_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamek saon dua. Esa, naꞌde Ada, ma esa, naꞌde Sila. ");
INSERT INTO llg_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada anan, naꞌde Yabal. Ndia numbu-saꞌdu nala manahoo banda. Ala lasoꞌda lali-lali, ma ala leo nai uma temak. ");
INSERT INTO llg_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Faꞌdin, naꞌde Yubal. Ndia numbu-saꞌdu nala, mana makaminak musiik, pake kinuk ma bua musiik, sama leo sasanu. ");
INSERT INTO llg_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Lamek saon Sila, ana bonggi Tubal Kaen. Ndia numbu-saꞌdu nala, ala daꞌdik tuka besi, fo ala tao bua mata-matak, neme besi, ma liti mai. Tubal Kaen feton, naꞌde Naama. ");
INSERT INTO llg_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Laꞌi esa, Lamek ana sosoꞌuk aon, neu saon dua sala matan, nae, “Dua nggei mamanene dei! Isinaak tou-anak esa ana sangga tao au, tehuu, au tao isan. ");
INSERT INTO llg_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Hataholi fo ana tao nisa Kaen, ana hambu huhukuk laꞌi hitu. Tehuu, mete ma hambu hataholi ana sangga bala au, na, ala hambu huhukuk laꞌi 77.” ");
INSERT INTO llg_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adam saon Hawa, bonggi ana tou-anak esa seluk. Boe ma, ala foi kakanak ndia, naꞌde Set (fo ndandaan nae, ‘loo feen’), huu Hawa nae, “Manetualain loo fee au kakanak ia, fo nggati Habel, fo Kaen ana tao nisak ndia so.” ");
INSERT INTO llg_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Set inahuu de ana sao, boe ma, ana hambu ana tou-anak esa, nade Enos. Faik ndia, hataholi la mulai lakaluku-lakatele leu MANETUALAIN. ");
INSERT INTO llg_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","2","Lelek Manetualain nakadadaꞌdik hataholi, Ana tao sala mataon leo Ndia matao hehelin. Ana nakadadadik touk ma inak, de Ana foi sala, nade “hataholi”, ma Ana fee sala babaꞌe-babatik. Hataholi sososak, naden Adam. Ia ia, Adam numbu-sadu nala: ");
INSERT INTO llg_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adam teun 130 so, boe ma ana hambu ana touanak esa, fo ndia mata-aon leo ndia aman. Boe ma, ana foi kakanak ndia, naꞌde Set. ");
INSERT INTO llg_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Basa ndia boe ma, Adam bei nasoda seluk teuk 800, ma ana hambu seluk, ana touanak, ma inanak. ");
INSERT INTO llg_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Ana mate neu faik fo teun 930 so. ");
INSERT INTO llg_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Set teun 105, boe ma ana hambu ana tou-anak esa, nade Enos. ");
INSERT INTO llg_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Boe ma, Set bei nasoda teuk 807, ma ana hambu seluk, ana touanak, ma inanak. ");
INSERT INTO llg_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Ana mate neu faik fo teun 912 so. ");
INSERT INTO llg_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enos teun 90, boe ma ana hambu ana touanak esa, nade Kenan. ");
INSERT INTO llg_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Basa ndia, de Enos bei nasoda seluk teuk 815, ma ana hambu seluk, ana touanak, ma inanak. ");
INSERT INTO llg_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Ana mate neu faik fo teun 905 so. ");
INSERT INTO llg_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenan teun 70, boe ma ana hambu ana touanak esa, nade Mahalalel. ");
INSERT INTO llg_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Basa ndia, de Kenan bei nasoda seluk teuk 840, ma ana hambu seluk ana tou-anak, ma inanak. ");
INSERT INTO llg_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Ana mate neu faik fo teun 910 so. ");
INSERT INTO llg_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalalel teun 65, boe ma ana hambu ana touanak esa nade Yared. ");
INSERT INTO llg_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Basa ndia, de Mahalalel bei nasoda seluk teuk 830, boe ma ana hambu seluk, ana touanak, ma inanak. ");
INSERT INTO llg_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Ana mate neu faik fo teun 895 so. ");
INSERT INTO llg_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yared teun 162, boe ma ana hambu ana touanak esa, nade Henok. ");
INSERT INTO llg_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Basa ndia, de Yared bei nasoda seluk teuk 800, ma ana hambu seluk, ana touanak, ma inanak. ");
INSERT INTO llg_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Ana mate neu faik fo ndia teun 962 so. ");
INSERT INTO llg_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Faik fo Henok teun 65, boe ma ana hambu ana tou-anak esa, nade Metusalak. ");
INSERT INTO llg_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Basa ndia, de Henok nasoda dalek esa no Manetualain teuk 300 seluk. Ma ana hambu seluk, ana touanak, ma inanak. ");
INSERT INTO llg_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","24","Ana nasoda dalek esa nakandoo no Manetualain. Teun 365, boe ma ana mopo, huu Manetualain soꞌun neni lain neu. ");
INSERT INTO llg_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Metusalak teun 187, boe ma ana hambu ana touanak esa, nade Lamek. ");
INSERT INTO llg_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Basa ndia, boe ma Metusalak bei nasoda teuk 782 bali, ma ana hambu seluk, ana touanak, ma inanak. ");
INSERT INTO llg_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Ana mate neu teun 969 so. ");
INSERT INTO llg_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamek teun natun 182, boe ma ana hambu ana touanak esa. ");
INSERT INTO llg_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Lamek foi kakanak ndia, nade Noh, huu nae, “Neu ko kakanak ia, ana kokoe-nanasi, ma ana tao namahoko ita dale nala, neme ita taue-taosa mbilu-mbuse nai dae ia, fo Manetualain sumba-soon so.” ");
INSERT INTO llg_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Basa ndia, Lamek bei nasoda teuk 595 bali, ma ana hambu seluk, ana touanak, ma inanak. ");
INSERT INTO llg_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Boe ma, ana mate neu teun 777 so. ");
INSERT INTO llg_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noh teun 500, boe ma ana hambu ana touanak telu, sila: Sem, Yafet ma Ham. ");
INSERT INTO llg_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Faik ndia, hataholi la boe lamanoꞌu so. Boe ma, ala lasoda latanggenggelak, nai daebafok sudi bee. Sila boe oo, ala bonggi lala ana inana kala. ");
INSERT INTO llg_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Manetualain Ana tou-ana nala, lita hataholi inana nala, manaꞌa hiak. Boe ma, ala hii sala, de ala sao lala sala. ");
INSERT INTO llg_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Boe ma, MANETUALAIN nae, “Au manggu ua hataholi sodan manggalaun ia. Au Dulang fo fee sala lasoda ndia, taa nau fee sala lasoda lakandoo so bali. Ala musi mate. De, dei fo kada ala lasoda kada losa teun natun esa dua hulu.” ");
INSERT INTO llg_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Mulai neme lelek ndia mai, ma lelek mana tutungga kala sila, hambu hataholi ao inahuu-madema nai daebafok so. Faik fo Manetualain Ana touana nala, sao lala hataholi daebafok ana inana nala, boe ma ala bonggi lala hataholi fo ana seli sila, fo ndia, palani-palani musu la, fo nananitak nai tutui lele uluk. ");
INSERT INTO llg_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Faik ndia, MANETUALAIN nita hataholi manai daebafok, manggalaun ana seli so. Dale nala, duduꞌa kaꞌda manggalauk mesan. ");
INSERT INTO llg_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Boe ma, MANETUALAIN Ana fale dalen, huu Ana nakadadadik hataholi la so, fo ala leo lai daebafok ia. Dedeak ndia, ana tao nala MANETUALAIN dalen hedis nalan seli. ");
INSERT INTO llg_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Huu ndia, de Ana kokolak nae, “No leondiak, na, neu ko Au tao akalulutu hataholi, fo Au akadadadik ala sala so, nai daebafok ia. Au tao akalulutu basa mbui kala, ma banda feꞌe kala boe. Huu Au fale dalek, huu Au tao ala sala so.” ");
INSERT INTO llg_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Tehuu kada Noh mesa kana, tao namahoko MANETUALAIN dalen. ");
INSERT INTO llg_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Noh tutuin leo iak: Ndia ana touana nala telu, fo, sila Sem, Yafet, ma Ham. Noh nasoda no ndoos, ma taa tao manggalauk. Lelek ndia, kada ndia mesa kana neulauk. Ana nasoda dekak no Manetualain. ");
INSERT INTO llg_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","12","Tehuu Manetualain nita basa hataholi feꞌe kala manggalauk mesan. Nai sudi bee mesan, hataholi la dala sodan nakalulutuk nalan seli. Manetualain nita hataholi la lai daebafok ia, manggalauk mesan. ");
INSERT INTO llg_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Boe ma, Manetualain nafada Noh nae, “Nai sudi bee, kada Au ita hataholi manggalauk mesan. De, Au aketun ae, Au sangga tao akalulutu basa daebafok ia, no basa isi nala. ");
INSERT INTO llg_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","De, leoiak, Noh! Hatematak ia, o tao mala ofa inahuuk esa neme ai matea mai. Nai ofak ndia dalek, o tao kama-kama la. Boe ma, o tao ter neu ofak ndia. ");
INSERT INTO llg_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ofak ndia, o taon nalun meter natun esa telu hulu telu, ma loan meter dua hulu dua, ma deman meter sanahulu telu. ");
INSERT INTO llg_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Tehuu tao ofak ndia mbunin titisan deman meter seselik esa no lindin. O baꞌe ofak ndia neu tadak telu lain neu. Boe ma, tao lelesu esa nai ofak boboan. ");
INSERT INTO llg_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Masanenedak neulalau! Dei fo Au akonda faa tuak, fo tao nakalulutu basa masodak malai daebafok ia, losa taa ela hata esa boe. ");
INSERT INTO llg_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Tehuu Au nau mbaꞌa heheluk ua o. Dei fo o maso noꞌu mua o saom, o ana mala, ma o fetofeu mala, mini ofak ndia dalek miu. ");
INSERT INTO llg_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Neme basa banda la mai, o musi hele mala pasan esa-esak, fo, muni sala leni ofak ndia dalek leu, suek ala lasoda noꞌu lo o. Sama leo banda nakaboik, mbui kala, ma banda mana lae-loꞌdo kala, fo suek basa sala lasoda. ");
INSERT INTO llg_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","O musi muni nanaꞌa mata-mata kala, neni ofak ndia dalek neu, soaneu ei, ma soaneu banda la.” ");
INSERT INTO llg_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Basa boe ma, Noh tao tungga, sama leo basa Manetualain palendan ndia. ");
INSERT INTO llg_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Basa ndia, boe ma LAMATUAK kokolak no Noh, nae, “Au suli uni suꞌdi bee uu, tehuu kada o mesa nggo dalem ndoos. Huu ndia, de o mua o sao-ana mala mini ofak ndia dalek miu leo. ");
INSERT INTO llg_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","3","Neme basa banda mata-mata kala sila, fo bole ei miꞌan, ma mini fee Au, na, o muni pasan hitu-hituk neni ofak ndia dalek neu. Neme basa mbuik mata-mata kala, muni pasa hitu-hituk boe. Tehuu neme banda feꞌe kala mai, na, muni kada pasan esa-esak. No leondiak, na, banda la, ma mbui kala sila, dadik bini, fo hambu sala taa-taa. ");
INSERT INTO llg_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Masanenedak neulalau, baa! Faik hitu bali, te Au akonda uda taa no hahaen, leledo-leꞌodaek, faik haa hulu. No leondiak, Au tao akamate basa masodak malai madak lain, fo Au tao ala sala so.” ");
INSERT INTO llg_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Boe ma, Noh tao tungga sama leo basa MANETUALAIN pelendan ndia. ");
INSERT INTO llg_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Faik fo faa tuak mai ndia, Noh teunnatun nee so. ");
INSERT INTO llg_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Basa boe ma Noh no saon, ma ana nala, ma fetofeu nala, leni ofak ndia dalek leu, suek lasoda leme faa tuak ndia mai. ");
INSERT INTO llg_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Noh neni basa mbuik mata-mata kala, ma banda feꞌe kala, esa-esak no ndia pasan neni ofak dale leu, fo neme hataholi bole naꞌa, ma neme hataholi taa bole naꞌa, tungga MANETUALAIN palendan ndia. ");
INSERT INTO llg_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Basa faik hitu, boe ma faa nggangga mai, de ana mboti nala daebafok ia. ");
INSERT INTO llg_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Nandaa no Noh teun natun nee, seli bulak dua, ma faik sanahulu hitu, boe ma faa mai! Faik ndia, nonook leo bali lalai natahuꞌak, de oen nggangga dae mai. Ma basa oe matak malai dae dale, ala kadi, de oe nasambumbulak deak mai. ");
INSERT INTO llg_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Boe ma, uda konda leledo-leꞌodaek, taa no hahaen, losa faik haa hulu. ");
INSERT INTO llg_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Tehuu faik ndia, boe ma Noh, saon, ma ana nala telu sala, fo Sem, Yafet, ma Ham, ma ndia feto-feu nala, basa sala ala leni ofak dalek leu. ");
INSERT INTO llg_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Ala maso noꞌu lo banda la, fo banda nakaboik, banda fui, banda mana lae-loꞌdok, mbui kala, ma banda feꞌe kaliꞌda kala. ");
INSERT INTO llg_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","16","Pasan esa-esak neme basa mana masoda kala, ala leni ofak dale leu, lo Noh, sama leo Manetualain palendan neu ndia. Ledoeik basa sala, maso so, boe ma LAMATUAK nggoe ofak ndia lelesun. ");
INSERT INTO llg_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","19","Uda belak konda nakandoo, losa faik haa hulu, boe ma faa boe hene namadema, losa ofak bonu. Oe hene nakandoo, losa ana mboti nala lete madema la. ");
INSERT INTO llg_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Oe ndia, hene taa no hahaen, losa deman meter hitu nai letek mboin. ");
INSERT INTO llg_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","23","No leondiak, boe ma basa masodak malai madak lain, fo ndia: hataholi, banda nakaboik, banda fui, banda mana lae-lodok, ma mbui kala, mate basa sala. Ela kada Noh no basa malai ofak ndia dalek, lasoda. ");
INSERT INTO llg_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Oe ndia, taa no leleꞌen losa faik natun esa lima hulu. ");
INSERT INTO llg_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Tehuu Manetualain taa nafalende heni Noh asa, no basa banda la malai ofak ndia. Boe ma, Ana fee ani nafumbu, fo tao naleꞌe faa ndia. ");
INSERT INTO llg_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Boe ma, Ana tatana basa oe mata kala, malai daebafok, ma Ana fee uda hahae, neme lalai mai. ");
INSERT INTO llg_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","De oe leꞌe nakandoo. Basa faik natun esa lima hulu, boe ma oe taa demak nalan seli so. ");
INSERT INTO llg_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Nandaa no bulak kahitun seli faik sanahulu hitu, boe ma ofak ndia hala neu lete madema esa lain, naden Ararat. ");
INSERT INTO llg_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Oe leꞌe nakandoo losa bulak kasanahulun fain esa, boe ma lete kala mboi nala sadu. ");
INSERT INTO llg_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Seli faik haa hulu, boe ma Noh soi ofak jendelan esa. ");
INSERT INTO llg_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","De ana mboꞌi mbui kaa esa. Mbuik ndia, laa nakandoo neu-mai, losa oe ana leꞌe tetebes. Ana taa fali neni ofak neu so. ");
INSERT INTO llg_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Boe ma, Noh mboꞌi seluk lunda esa bali, fo sangga ana bubuluk oe ndia, leꞌe tetebes so, do beik. ");
INSERT INTO llg_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Tehuu, huu oe bei mboti nala basan, de mbuik ndia taa hambu mamana sasaꞌek. De ana fali neni ofak neu. Noh look liman, de ana simbo falik mbuik ndia, neni ofak dale neu. ");
INSERT INTO llg_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Noh nahani faik hitu bali, de ana mboꞌi seluk mbuik ndia. ");
INSERT INTO llg_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Ledo bobon ndia, mbuik ndia fali neni Noh neu, ma neni ai setun dok esa, fo bei fo ana tutu nalan. Basa boe ma, Noh bubuluk, oe leꞌe tetebes so. ");
INSERT INTO llg_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Ana nahani faik hitu bali, boe ma ana mboꞌi seluk mbui lunda ndia. Tehuu oek ia, mbuik ndia taa fali so. ");
INSERT INTO llg_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Faik fo Noh teun natun nee ma esa, fo laꞌeneu bula kaesan fain esa, k oe leꞌe tetebes so. Boe ma Noh soi ofak jendelan, de ana suli nafeok, tehuu dae mada so. ");
INSERT INTO llg_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Losa bulak kaduan fain kadua hulu hitun, bali, boe ma dae mada ndoos so. ");
INSERT INTO llg_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Basa boe ma, Manetualain kokolak no Noh nae, ");
INSERT INTO llg_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Noh! Hatematak ia, ei basa nggei konda leo mima ofak ia mai. ");
INSERT INTO llg_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Kalua heni basa banda la sila! Fo ndia: banda nakaboik, banda fui, banda mana lae-lodok, ma mbui kala. Ela basa sala boe lamanoꞌu, fo tao lahenu daebafok ia.” ");
INSERT INTO llg_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","19","Basa boe ma, Noh no saon, ana nala, ma fetofeu nala, basa sala kalua leme ofak ndia mai. Basa banda la sila, kalua, esa-esak no ndia numban. ");
INSERT INTO llg_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Boe ma, Noh nakatotodok batu, fo tao mei tunu-hotuk fee LAMATUAK. Noh haꞌi nala esa-esak neme banda la, fo bole paken neu tunu-hotuk, de ana hala sala, ma ana tunu sala neu mei tunu-hotuk ndia lain, fo dadik tanda makasi neu LAMATUAK. ");
INSERT INTO llg_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Faik fo LAMATUAK hae laꞌe tunu-hotuk ndia naboo meni, boe ma dalen namahoko. De Ana duduꞌa nae, “Mulai neme hatematak ia mai, Au taa sumba-soo daebafok ia bali, huu hataholi manggalaun. Mae kada ala duduꞌa manggalauk neme kadiꞌi anan mai, tehuu Au taa tao akalulutu basa masoda kala so, sama leo Au taok ndia so. ");
INSERT INTO llg_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Mete ma daebafok ia bei nai ia, na, basa fai-fai la laꞌok lakandoo, tungga ndia heti-heun. Fo ndia: fai sele-nggalin ma fai ketu-kolun, fai makasufun ma fai hanan, fai hanan ma fai oefaan, leledok ma leꞌodaek.” ");
INSERT INTO llg_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Manetualain fee babaꞌe-babatik, neu Noh ma ana nala, de Ana kokolak nae, “Ei bonggi mala makadotok, fo tao mahenu daebafok ia seluk bali. ");
INSERT INTO llg_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Neu ko basa banda fui la, mbui kala ma iꞌa kala, ala bii ei. Ei ndia musi heti sala. ");
INSERT INTO llg_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Ei bole miꞌa basa banda la sila mbaan, sama leo ei miꞌa sesele-ngganggali kala buna-boan boe. Au fee basa ia leu ei. ");
INSERT INTO llg_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Kada ei taa bole miꞌa mbaa fo bei kadaak, huu banda samanen nai daan. ");
INSERT INTO llg_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","6","Au tao hataholi tungga Au mataong. Huu ndia, de taa bole tao nisa hataholi. Mete ma, hambu hataholi, do banda, fo ana tao nisa hataholi, na musi tao misan boe. Heti-heuk ia neme Au mai. ");
INSERT INTO llg_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Ei musi bonggi makadotok, fo tao mahenu seluk daebafok ia bali.” ");
INSERT INTO llg_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Manetualain tuti seluk Ndia kokolan, nae, ");
INSERT INTO llg_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Hatematak ia, Au sangga mbaꞌa Au hehelung ua ei, losa ei numbu-sadu mala boe. ");
INSERT INTO llg_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Heheluk ia, laꞌeneu basa masodak lalaꞌen, fo ndia banda nakaboik, banda fui, ma mbui kala. Kekeꞌun neun, basa mana kaluak lalaꞌen lo ei, leme ofak ndia mai. ");
INSERT INTO llg_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Au hehelung ndia, leoiak: Au taa sangga haitua faa tuak mai bali so, fo tao nakalulutu basa masodak, ma tao nakalulutu basa daebafok ia. ");
INSERT INTO llg_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","13","Au tao Au elung neu lalai, suek ana dadik tanda nasanenedak neu Au hehelung, fo taa hambu namaketuk neu ei, ma basa masoda kala lai daebafok ia. ");
INSERT INTO llg_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","17","Mete ma hambu koꞌas nai lalai, boe ma elus lane, na, neu ko ndia nasanenedak Au hehelung ae: neu ko faa tuak taa tao nakalulutu basa masoꞌda kala so. No leondiak, Au hehelung fo taa mana basak ndia, nanambaꞌak soaneu ei so, ma basa mana masodak lalaꞌen.” ");
INSERT INTO llg_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Noh ana nala fo mana kalua leme ofak ndia mai, fo sila: Sem, Yafet ma Ham. (Ham ndia, na, Kanaꞌan aman). ");
INSERT INTO llg_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Basa hataholi malai daebafok numbu-sadu nala, leme Noh ana katelu nala mai. ");
INSERT INTO llg_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noh hataholi mana tao ue daek. Ndia ndia hataholi sososak, fo mana tao osi anggol. ");
INSERT INTO llg_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Laꞌi esa, ana ninu anggol, losa ana mafuk belak nalan seli. Boe ma, ana oꞌdu heni ndia baloꞌa papaken, de ana sunggu lololi nakahola holi-holik, neme ndia uma teman dale. ");
INSERT INTO llg_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ledoeik Ham nita aman nakaholan ndia, boe ma nalai deak neu, de neu nafada kaꞌan Sem no Yafet. ");
INSERT INTO llg_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Boe ma, dua sala haꞌi lala lafa esa, de dua sala lofan lakalolonda kana, neu sila alu nala. Boe ma, ala laꞌo lasadedeak leni uma temak ndia dalek leu, de ala mboti lala sila aman. No leondiak, taa lita sila aman nakaholan ndia. Boe ma, ala deak leu. ");
INSERT INTO llg_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Ledoeik Noh mamafun mulai lea, boe ma ana bubuluk ana mulianan tataon ndia. ");
INSERT INTO llg_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","De ana kokolak, nae, “Heeh! Kanaꞌan! Au sumba-soo o! Neu ko o dadik kaꞌa mala atan! ");
INSERT INTO llg_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Koa-kiok neu LAMATUAK! Ela Ana fee babaꞌe-babatik fee Sem! Tehuu ela Kanaꞌan dadik Sem atan. ");
INSERT INTO llg_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Ela Manetualain boe tao namaloloa Yafet daen; Ma ndia numbu-sadu nala, lasoda mole-dame, lo Sem numbu-sadu nala. Tehuu ela Kanaꞌan, dadik Yafet atan.” ");
INSERT INTO llg_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Mulai neme basa faa tuak ndia, Noh bei nasoda seluk losa teuk natun telu lima hulu. ");
INSERT INTO llg_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Ana mate neu faik fo ndia teun natun sio lima hulu. ");
INSERT INTO llg_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Basa faa tuak, boe ma Noh ana nala, hambu numbu-sadu kala, fo ndia numbu-saduk neme Sem, Yafet ma Ham mai. ");
INSERT INTO llg_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","5","Yafet numbu-sadu nala, sila: Gomer, Magok, Madai, Yawan, Tubal, Mesek ma Tiras. Esa-esako no ndia dedeꞌan, sila leon, ma sila dae hehelin. Gomer numbu-sadu nala, sila: Askenas, Rifat ma Togarma. Yawan numbu-sadu nala, sila: Elisa, Tarsis, hataholi Kitim asa, ma Dodanim, fo ala leo lai tasibifi kala. ");
INSERT INTO llg_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ham numbu-sadu nala, sila: Kus, Misram, Put, ma Kanaꞌan. ");
INSERT INTO llg_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kus numbu-sadu nala, sila: Seba, Hawila, Sabta, Raema ma Sabteka. Raema numbu-saꞌdu nala, Syeba no Dedan. ");
INSERT INTO llg_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kus ana touanan, ndia Nimrod, fo malangga musu palani makasosoak. ");
INSERT INTO llg_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Ndia lanin neme LAMATUAK mai, losa ndia boe oo, dadik manasombu banda fo ana seli. Huu ndia, de hataholi la lateme kokolak lae, “Ela ana dadik mana sombu malelak leo Nimrod, fo ana hambu ndia ana selin neme LAMATUAK mai.” ");
INSERT INTO llg_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Sososan, ndia dae babaꞌen mulai neme Babel, Erek Akad, ma Kalne. Sila basa sala lai Sinear ");
INSERT INTO llg_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Neme ndia mai, ana koasa seluk Asyur. Basa boe ma, ana nambadedei kota Niniwe, Rehobot-Ir, Kala, ");
INSERT INTO llg_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ma Resen fo nai Niniwe no Kala laladan. Basa sala, kota inahuuk mesan. ");
INSERT INTO llg_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misraim numbu-sadu nala, fo sila, hataholi Ludim, Anamim, Lehabim, Naftuhim, ");
INSERT INTO llg_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patrusim, Kasluhim, ma Kaftorim. Hataholi Kasluhim ndia, na, sila hataholi Filistin asa bei-baꞌi nala. ");
INSERT INTO llg_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaꞌan, ana kaꞌan, ndia Sidon. Kanaꞌan boe oo, ana dadik neu hataholi Het, ");
INSERT INTO llg_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Yebusi, Amori, Girgasi, ");
INSERT INTO llg_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hiwi, Arki, Sini, ");
INSERT INTO llg_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arwadi, Semari, ma Hamati sala bei-baꞌi nala. Kanaꞌan numbu-sadu nala, latanggenggelak losa dook, ");
INSERT INTO llg_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","losa sila dae too nala, mulai neme Sidon mai, nakandoo neni Gerar neu, losa nai Gasa. Neme ndia mai, neni Sodom, Gomora, Adma, ma Seboim, losa nai Lasa. ");
INSERT INTO llg_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Sila basa sala ndia, Ham numbu-sadu nala. Esa-esak no ndia dedeꞌan, ma leon, ma dae hehelin. ");
INSERT INTO llg_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Yafet kaꞌan Sem, ana dadik hataholi Eber asa bei-baꞌi nala. ");
INSERT INTO llg_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sem numbu-sadu nala, sila: Elam, Asyur, Arpaksad, Lud ma Aran. ");
INSERT INTO llg_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aran numbu-sadu nala, sila: hataholi Us, Hul, Geter, ma Mas. ");
INSERT INTO llg_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arpaksad anan, Sela. Sela anan, Eber. ");
INSERT INTO llg_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eber ana hambu ana tou-anak dua. Kaꞌak naꞌde Pelek, (fo ndandaan nae, ‘latanggenggelak’), huu faik ndia, hataholi la latanggelak nai daebafok. Faꞌdin, nade Yoktan. ");
INSERT INTO llg_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yoktan numbu-sadu nala, sila: Almodad, Selef, Hasar-Mawet, Yera, ");
INSERT INTO llg_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Usal, Dikla, ");
INSERT INTO llg_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Syeba, ");
INSERT INTO llg_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Hawila, ma Yobab. Sila basa sala ia, Yoktan numbu-sadu nala. ");
INSERT INTO llg_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Sila mamana leleon ndia, mulai neme Mesa, nakandoo losa nai Sefar, fo ndia mamana lete kala lai dulu. ");
INSERT INTO llg_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Sila basa sala sila, Sem numbu-sadu nala. Esa-esak no ndia dedeꞌan, sila leon, ma sila dae hehelin. ");
INSERT INTO llg_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Basa sila, Noh numbu-sadu nala, esa-esako no ndia leo hehelin. Faik fo faa tuak nateꞌe, sila ndia latanggenggelak tao lahenu daebafok. ");
INSERT INTO llg_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Nai lele uluk ele, basa hataholi malai daebafok ia, ala kokolak lenik kada dedeꞌak esa. ");
INSERT INTO llg_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Faik fo sila nggelok, ala mulai lali leni dulu leu, ala losa lai dae matetuk esa, nai Sinear, boe ma ala leo leu ndia. ");
INSERT INTO llg_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","4","Sila basa sala lala halak lae, “Wei! Tolanoo nggalei! Mai ita tambadedeik tala kota inahuuk esa. Ita musi tao batubata, fo basa, na, ata hotun losa natea. Ma ata takatotodok batubata la sila lenik ter. Basa na, ata tambadedei uma madema katataꞌdak esa, fo mbunin losa lalai, suek ita hambu nadek. Ela ita dadik nusa inahuuk fo taa natanggenggelak.” ");
INSERT INTO llg_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Boe ma, LAMATUAK konda, de Ana titilo sudik kota ndia, ma uma madema katatadak, fo ala lambadedein ndia. ");
INSERT INTO llg_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Boe ma, Ana kokolak, nae, “Basa hataholi la ia, nusak esa, ma ala kokolak lenik dedeꞌak esa. Hata fo ala taok hatematak ia, bei fo kada mulai ngganggani kaesan. Mbila binesak, mete ma basa sala lakabubua leu esa, leo hatematak ia, na, neu ko ala bisa kada tao sudi hata. ");
INSERT INTO llg_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Malolenak Ita konda, fo tao kofeꞌek sila dedeꞌa nala, suek sila taa bubuluk esa no esa kokolan.” ");
INSERT INTO llg_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Boe ma, Lamatuak konda, de Ana tao babalik sila dedeꞌa nala. No leondiak, Ana tao hataholi la sila, latanggenggelak leni basa mamanak lai daebafok ia. Boe ma, ala taa tao lakandoo kota ndia. ");
INSERT INTO llg_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Huu ndia, de ala foi kota ndia, nade Babel (fo hihii sama leo dedeꞌa deꞌek esa, fo ndandaan nae, ‘lakandaa’). Huu LAMATUAK tao babalik sila dedeꞌan, ma fee sala latanggenggelak leni sudi bee leu, lai daebafok ia. ");
INSERT INTO llg_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Ia Sem numbu-sadu nala. Faik fo faa tuak nateꞌe teuk dua, nandaa no Sem teun natun esa, boe ma ana hambu ana tou-anak esa, nade Arpaksad. ");
INSERT INTO llg_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Basa ndia, de ana bei nasoda seluk teuk natun lima, ma ana hambu seluk, ana touanak, ma inanak. ");
INSERT INTO llg_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arpaksad teun telu hulu lima, boe ma ana hambu ana touanak esa, nade Sela. ");
INSERT INTO llg_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Basa ndia, boe ma Arpaksad bei nasoda seluk teuk natun haa ma telu, de ana hambu seluk, ana tou-anak, ma inanak. ");
INSERT INTO llg_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sela teun telu hulu, boe ma ana hambu ana touanak esa, nade Eber. ");
INSERT INTO llg_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Basa ndia, boe ma Sela bei nasoda seluk teuk natun haa ma telu, ma ana hambu seluk, ana touanak, ma inanak. ");
INSERT INTO llg_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eber teun telu hulu haa, boe ma ana hambu ana touanak esa, nade Pelek. ");
INSERT INTO llg_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Basa ndia, de, Eber bei nasoda seluk teuk natun haa ma telu hulu, ma ana bei hambu seluk, ana touanak, ma inanak. ");
INSERT INTO llg_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pelek teun telu hulu, boe ma ana hambu ana touanak esa, nade Rehu. ");
INSERT INTO llg_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Basa ndia, de Pelek bei ana nasoda seluk teuk natun dua ma sio, ma ana hambu seluk, ana touanak, ma inanak. ");
INSERT INTO llg_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Rehu teun telu hulu dua, boe ma ana hambu ana touanak esa, nade Seruk. ");
INSERT INTO llg_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Basa ndia, de Rehu bei nasoda seluk teuk natun dua ma hitu, ma ana hambu seluk, ana touanak, ma inanak. ");
INSERT INTO llg_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Seruk teun telu hulu, boe ma ana hambu ana touanak esa, nade Nahor. ");
INSERT INTO llg_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Basa ndia, de Seruk bei nasoda seluk teuk natun dua, ma ana hambu seluk, ana touanak, ma inanak. ");
INSERT INTO llg_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahor teun dua hulu sio, boe ma ana hambu ana touanak esa, nade Tera, ");
INSERT INTO llg_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Basa ndia, de Nahor bei nasoda seluk teuk natun esa sanahulu sio, ma ana hambu seluk, ana touanak, ma inanak. ");
INSERT INTO llg_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tera teun hitu hulu lenak, boe ma ana hambu ana touanak telu, nade Abram, Nahor ma Haran. ");
INSERT INTO llg_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Ia Tera numbu-sadu nala. Tera ana nala, sila Abram, Nahor, ma Haran. Haran ana hambu ana touanak esa, nade Lot. ");
INSERT INTO llg_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haran maten nai ndia nggolo fuafuni kedihusen, nade Ur, nai hataholi Kasdim daen. Ana mate, tehuu aman Tera bei kasodak. ");
INSERT INTO llg_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram sao Sarai. Nahor sao Haran ana inanan, nade Milka. Haran boe oo, hambu anak esa, naꞌde Yiska. ");
INSERT INTO llg_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Tehuu Sarai ana tedi, de taa bisa bonggi. ");
INSERT INTO llg_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Laꞌi esa, Tera no ndia anan Abram, ndia fetofeun Sarai, ma umbun Lot, ala kalua laꞌo ela nggolo Ur. Faik ndia, ala sangga leni dae Kanaꞌan leu. Tehuu losa nusa Haran boe ma, ala leo kada ndia. ");
INSERT INTO llg_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Nai ndia, Tera maten neu faik fo teun natun dua ma lima so. ");
INSERT INTO llg_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Faik ndia, LAMATUAK kokolak no Abram so, nae, “Abram! O laꞌo ela o nggolom, o bobonggim, ma o amam uman. O muni mamanak esa muu, fo dei fo Au atudun neu o. ");
INSERT INTO llg_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Neu ko, Au fee babaꞌe-babatik neu o. Ma numbu-sadu mala, neu ko ala boe lamanoꞌu, ma ala dadik hataholi nusak ana seli, losa hataholi la lalelak o nadem. Basa ndia, na o dadik babaꞌe-babatik, neu hataholi feꞌek. ");
INSERT INTO llg_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Neu ko, Au fee babaꞌe-babatik neu hataholi, fo ana mana fee babaꞌe-babatik neu o. Tehuu, Au sumba-soo neu hataholi, fo ana sumba-soo o. Mamanene neulalau! Huu neu ko basa hataholi nusa kala lai daebafok ia, ala hambu babaꞌe-babatik huu o.” ");
INSERT INTO llg_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","5","Faik ndia, Abram teun hitu hulu lima. Ndia no saon Sarai, ma ndia faꞌdin anan Lot, ma basa ndia bua pusaka nala, ma basa hataholi mana tao ue sala, fo ana hambu sala nai kota Haran. Boe ma, Abram asa laꞌo ela Haran, de leni mamanak fo LAMATUAK nafada ndia so. De, ala laꞌo lakandoo, losa mamanak esa, nade Kanaꞌan. ");
INSERT INTO llg_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Losa ele, boe ma Abram laꞌok ndule dae ndia, losa dekak no nggolok esa, nade Sikem. Boe ma, ala leo tataak deka no ai inahuuk esa, nai More. Faik ndia, hataholi Kanaꞌan asa, ala bei leo lai ndia. ");
INSERT INTO llg_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Nai ndia, LAMATUAK natudu Mataon neu Abram. Ana nae, “Dei fo Au fee dae babaꞌek ia, neu o numbu-sadu mala.” Basa boe ma, Abram nakatotodok batu fo nambadedei mei batu, de ana paken dadik mei tunu-hotuk soaneu LAMATUAK, fo Ana natudu Mataon neme ndia. ");
INSERT INTO llg_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Basa ndia, boe ma Abram ana lali neni letek manai kona, boe ma ana leo tataak nai mamanak esa nai nggolo Betel no nggolo Ai laladan. Nai ndia, ana nambadedei mei tunu-hotuk, de ana nakaluku-nakatele neu LAMATUAK. ");
INSERT INTO llg_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Basa ndia, boe ma ana lali-lali mamanak, losa nai dae Negeb, nai Kanaꞌan kona. ");
INSERT INTO llg_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Faik esa, boe ma ndoes ana seli nai dae Kanaꞌan. Huu ndia, de Abram asa, laꞌo boe dook lena bali, leni kona leu bali, losa nai nusa Masir. Ala leo tataak leme ele. ");
INSERT INTO llg_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Neu faik fo ala sangga leni nusa Masir dalek leu, boe ma ana nafada saon Sarai, nae, “Sarai. O ia, manaꞌa hiak. ");
INSERT INTO llg_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","De, mete ma hataholi Masir lita o manaꞌan leoiak, na, neu ko ala tao lisa au, huu au ia, o saom. No leondiak, ala bisa haꞌi lala o. ");
INSERT INTO llg_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","De, malolenak, o mafaꞌda sala mae, au ia, o naam. No leondiak, ala taa tao lisa au, tehuu, neu ko ala malole lo au, huu o.” ");
INSERT INTO llg_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Abram asa losa Masir, boe ma hataholi la, lita inak ndia manaꞌa hiak. ");
INSERT INTO llg_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Manek pegawe nala litan, boe ma ala kokolak inak ndia manaꞌan, neu manek matan. De, ala loo inak ndia neni manek uman neu. ");
INSERT INTO llg_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Boe ma, manek malole no Abram, huu Sarai. De manek palasen Abram. Fo ndia: biꞌilombo, biꞌiaek, sapi, banda keledei, ma banda onta. Ndia boe oo, palasen, ata touk ma inak. ");
INSERT INTO llg_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Tehuu huu ana haꞌi nala hataholi saon, neni uman neu, de, LAMATUAK huku mata-matak neu manek ndia, ma, ndia uma isi nala. ");
INSERT INTO llg_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Boe ma, manek noke Abram, de natane nae, “Abram! O tao leobeek neu au ia? Hatina de o taa mafada mae inak ndia, o saom? ");
INSERT INTO llg_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Tehuu o mae, o fetom ndia! Elabaꞌik au haꞌi alan, fo ana daꞌdik neu au saong! Ia, o saom ia. Hatematak ia, muan leo, ma boke heok meme au matang mai!” ");
INSERT INTO llg_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Basa boe ma, manek ana palenda pegawe nala, de ala husi heni Abram, no saon, ma lo basa sila bua nala, leme nusak ndia mai. ");
INSERT INTO llg_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Basa ndia, boe ma Abram laꞌo ela Masir, de ana fali neni dae Negeb neu. Neu no saon, ma basa hata-pusaka nala. Fadin anan Lot, ana tungga no sala boe. ");
INSERT INTO llg_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram ndia, namasuꞌi nalan seli. Ndia banda nakaboi nala, ma lilo-fula, lilo-mbila nala, noꞌun seli. ");
INSERT INTO llg_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Neme Negeb mai ana huꞌa lali-lali, de ana fali neni nggolo Betel no nggolo Ai lalaꞌdan neu. Makahulun, ana leo nitak neme ndia so. ");
INSERT INTO llg_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Ma ndia boe oo nambadedei mei tunu-hotuk neme ndia so. Boe ma, ana nakaluku-nakatele neu LAMATUAK neme ndia. ");
INSERT INTO llg_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lot, fo mana tungga noꞌu no Abram ndia, kabanda nakaboik noꞌuk, ma ndia hataholi mana tao ue-ledi nala, noꞌuk boe. ");
INSERT INTO llg_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","7","Tehuu mamanak ndia, taa maloa soaneu Abram no Lot, ma basa sila hata-pusaka nala, fo ala lasoda sama-sama lai ndia. Boe ma, Abram no Lot manahoo nala latoka, huu naꞌu nai mamanak ndia, taa dai soaneu sila banda nala. (Faik ndia, hataholi Kanaꞌan ma hataholi Feris, ala bei leo lai ndia boe.) ");
INSERT INTO llg_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Boe ma, Abram nafada ndia anan, nae, “Lot aa! Ita ia bobonggik. Boso losak ita taa malole esa no esa, ma ita hataholi mana tao ue-ledi nala lahuu lakandoo. ");
INSERT INTO llg_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","De malolenak kada ita kofeꞌe leo. Mamanak ia maloa. De, mete ma o hele mala dae babaꞌek kii, na, au haꞌi ala babaꞌek kona. Tehuu, mete ma o hele mala dae babaꞌek kona, na, au haꞌi ala babaꞌek kii.” ");
INSERT INTO llg_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Boe ma, Lot ana susuli nafeok. De nita lee Yarden bafan henuk no oe, losa nggolo Soar. Mamanak ndia, dae mamina leo LAMATUAK osin, ma leo dae Masir. (Faik ndia, LAMATUAK bei taa tao nakalulutu kota Sodom no Gomora. De, dae ndia, bei neulauk.) ");
INSERT INTO llg_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","De Lot hele nala basa dae, manai lee Yarden bafan ndia. Boe ma, dua sala kofeꞌe. Basa de Lot neni dulu neu. ");
INSERT INTO llg_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Tehuu, Abram ana leo nakandoo nai dae Kanaꞌan. Boe ma, Lot neu leo nai nggolo-nggolok, mana deka no kota Sodom nai lee Yarden bafan. ");
INSERT INTO llg_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Tehuu, hataholi Sodom asa manggalaun ana seli, ma ala taa nau lamanene LAMATUAK. ");
INSERT INTO llg_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Faik fo Lot no Abram ala kofeꞌe, boe ma LAMATUAK nafaꞌda Abram, nae, “Abram! Hena o suli sudik ndule basa mamanak, fo neme o mambadeik ndia mai. Mete neulalau dea-matak, kii-konak. ");
INSERT INTO llg_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Basa dae fo o mitak ndia, neu ko Au feen neu o, ma o numbu-sadu mala, fo ana dadik neu ei pusaka mala losa dodoon neu. ");
INSERT INTO llg_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Neu ko Au tao o numbu-sadu mala, noꞌun leo salaek malai tasibifi. Losa hataholi la, taa bisa hingga lala o numbu-sadu mala dedesin. ");
INSERT INTO llg_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Hatematak ia, o laꞌo ndule tungga dae ia nalun ma loan. Huu neu ko basa sila, Au feen neu o!” ");
INSERT INTO llg_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Basa ndia, boe ma Abram asa lali, de leu leo seluk leme mamanak, fo deka no ai inahuu kala malai Mamre, deka no nggolo Hebron. Boe ma, ana nambadedei mei tunu-hotuk, fo ana nakaluku-nakatele neu LAMATUAK nai ndia. ");
INSERT INTO llg_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Faik ndia, hambu manek haa lakabubua, fo ndia: Amrafel, mane nusa Sinear; Ariok, mane nusa Elasar; Kedarlaomer, mane nusa Elam; ma Tideal, mane nusa Goyim. ");
INSERT INTO llg_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Faik ndia, hambu mane feꞌek lima lakabubua boe, fo ndia: Bera, mane nusa Sodom; Birsa, mane nusa Gomora; Sinab, mane nusa Adema; Semeber, mane nusa Seboim; ma mane nusa Bela (hatematak ia, nade nusa Soar). Boe ma, mane kahaa kala ala latati lo mane feꞌek kalima kala sila. ");
INSERT INTO llg_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Manek kalima kala sila, ala lakabubua lo soldadu nala, lai Sidim bafan (fo hatematak ia lae Tasi Kamates). ");
INSERT INTO llg_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Natatik ndia, natahuhuun leoiak: makahulun, manek kalima kala sila lataa, neu mane Kedarlaomer losa teuk sanahulu dua. Tehuu neu teu kasanahulu telun, boe ma ala musu lon. ");
INSERT INTO llg_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Faik fo losa teu kasanahulu haan, boe ma Mane Kedarlaomer no ndia nonoo mane katelu kala sila, ala mai lo sila soldadu nala. Boe ma, ala tati senggi nusak hida, fo ndia: hataholi Refaim nai nusa Asterot-Kamaim, hataholi Susim nai nusa Ham, hataholi Emim nai nusa Sawe-Kiryataim, ");
INSERT INTO llg_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ma hataholi Hori fo manai lete Seir, losa mamana nes El Paran bifin. ");
INSERT INTO llg_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Basa de, ala fali tungga dala feꞌek losa En Mispat, (fo hatematak ia, nade Kades). Basa ndia, boe ma ala tao lakalulutu hataholi Amalek nusan, ma hataholi Amori mana leo nai nusa Haseson-Tamar. ");
INSERT INTO llg_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","9","Boe ma, mane kalima kala sila, ala heti soldaꞌdu nala leme Sidim bafan, de latati lo mane kahaa kala sila. ");
INSERT INTO llg_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Nai bafak ndia, hambu dano ter noꞌuk. Faik fo ala latati ndia, mane Sodom no mane Gomora lo soldaꞌdu nala lalai. Luma ala tuꞌda leni dano ter dalek leu, ma luma lalai letek leu. ");
INSERT INTO llg_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","De mane kahaa kala sila, ala senggi sala, boe ma lamoa lala basa bua nala, ma nanaꞌa kala, leme Sodom ma Gomora mai. Basa de, ala fali. ");
INSERT INTO llg_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Tehuu, Abram anan Lot, ana leo nai Sodom. Boe ma, mane kahaa kala sila ala humu leni Lot asa, ma lamoa lala basa bua nala. ");
INSERT INTO llg_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Tehuu posi heni hataholi esa, de nalai neu nafada Abram, fo hataholi Ibrani ndia. Faik ndia, Abram leo deka-deka no Mamre ai inahuu nala. Mamre, fo hataholi Amori, no tolanoo nala, Eskol ma Aner, ala dadik Abram bubuan. ");
INSERT INTO llg_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Faik fo Abram namanene lae, hataholi la humu lala fadin anan Lot so, boe ma ana nakabubua nala ndia ata nala fo dale katemak neun, ma mana matati malela kala. Basa sala hataholi natun telu sanahulu falu. Boe ma, ala leu husi mane kahaa kala sila, losa nggolo Dan, fo doon ana seli nai kii ele. ");
INSERT INTO llg_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Nai ndia, Abram ana baꞌe ndia hataholi nala, neu bubuak hiꞌda. Leꞌodaen ndia boe, ala leu sambu hataholi la sila, tehuu hambu luma lalai. De ala husi lakandoo sala, losa nggolo Hoba, nai kota Damsik boboan kii. ");
INSERT INTO llg_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","No dalak ndia, Abram hambu falik Lot, no ndia hataholi nala, ma basa sila bua nala, ma hataholi feꞌe kala boe. ");
INSERT INTO llg_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Faik fo Abram senggi mane kahaa kala sila, de ana fali, boe ma mane Sodom ana mai soluk Abram, neme Sawe bafan (fo hataholi la lateme lae, Manek Bafan). ");
INSERT INTO llg_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Faik ndia, Melkisedek, mane kota Salem, ma ndia boe oo, malangga anggama neme Manetualain fo Manai Lain Seli. Ana mai neni fee Abram, loti ma anggol. ");
INSERT INTO llg_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","20","Basa boe ma, ana kokolak fee babaꞌe-babatik neu Abram, nae, “Manetualain Manai Lain Seli, fo mana tao lalai no daebafok ndia, Ana fee babaꞌe-babatik neu o. Koa-kiok neu Manetualain, fo Ana fee o senggi musu la.” Basa ndia, boe ma Abram baꞌe fee Melkisedek babaꞌek esa, neme sanahulu mai neme basa hata, fo ana namoa fali kala sila. ");
INSERT INTO llg_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Basa ndia, boe ma mane Sodom kauk neu Abram, de nae, “Ama Abram. Au hule fo ama fee falik au hataholi nggala, tehuu Ama soa basa bua fo Ama mamoa mala kala sila.” ");
INSERT INTO llg_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Tehuu, Abram nataa, nae, “Au soo neu MANETUALAIN Manai Lain Seli, fo Mana tao lalai no daebafok, ");
INSERT INTO llg_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","ae, au taa nau haꞌi hata esa boe, neme o bua mala mai. Mae aba dook esa boe oo, au taa haꞌin. No leondiak, o taa kokolak mae, ‘Abram suꞌin ndia, na, huu au.’ ");
INSERT INTO llg_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Au taa toꞌa hata esa boe. Kada au hataholi nggala, ala pake basa bee soo, na, taon neu basan leo. Ma ela au nonoo ketelu nggala ia, Aner, Eskol, ma Mamre, ala haꞌi lala sila babaꞌen dei.” ");
INSERT INTO llg_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Basa ndia, boe ma LAMATUAK natudu Mataon neu Abram. Boe ma, Ana nae, “Abram! O boso bii. Huu Au ndia sili heni o muma o musu mala mai. Ma Au fee o nanala inahuuk.” ");
INSERT INTO llg_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","3","Tehuu Abram nae, “Eeh, Manetualain. Mae Lamatuak fee au noꞌuk boe oo, sosoan taa. Huu au anang taa, fo ana fee au numbu-saꞌduk. De, hambu pusaka noꞌuk, fo tao neu hata? Mae leobee boe oo au atang, Eliasar neme Damsik mai, ana hambu basa sala.” ");
INSERT INTO llg_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Tehuu, LAMATUAK nataa nae, “Taa leondiak! Huu o ana hehelim ndia, hambu pusaka ndia, tehuu taa ndia ata ndia.” ");
INSERT INTO llg_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Boe ma, Ana noo Abram deak neu, de Ana nae, “Hatematak ia o suli lalai muu. Hena o mita nduu kala sila. O bisa hingga sala do? Dei o fo numbu-saꞌdu mala noꞌu nala leo nduu kala sila.” ");
INSERT INTO llg_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Boe ma, Abram simbok LAMATUAK kokolan ndia. Boe ma LAMATUAK cap nala ndia, nae hataholi ia dale ndoos, huu Abram namahelen neu Ndia. ");
INSERT INTO llg_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Basa ndia, boe ma LAMATUAK tuti seluk, nae, “Au ia, Manetualain. Au ndia, ua o kalua muma nggolo Ur, nai hataholi Kasdim asa daen. Ma Au ndia, fee dae ia, dadik neu o pusakan.” ");
INSERT INTO llg_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Tehuu Abram natane, nae, “Leo bee LAMATUAK? Neme bee mai au bisa bubuluk ae, neu ko dae ia, dadik neu au pusakang?” ");
INSERT INTO llg_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Boe ma Ana nataa, nae, “Leoiak! Mai ita tao tataos esa, fo mfo baꞌa hata Au kokolang isinaak ndia. Hatematak ia, o muu haꞌi fee Au: sapi ina esa, biꞌiae ina esa, ma biꞌilombo mane esa. Basa sala musi teuk beketeluk. Basa, na, muu haꞌi kateu esa bali, ma lunda esa.” ");
INSERT INTO llg_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Boe ma, Abram neu haꞌi nala basa banda la sila. Ana seseli baꞌe duak sapi ndia, biꞌiaek, ma biꞌilombo. Boe ma, ana heti mbaa la sila, baꞌe duak leu dae, esa nasale no esa, de ana dadik ombak dua. Tehuu tana dada mbui kala sila. ");
INSERT INTO llg_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Boe ma, mbui manaꞌa banda kamate sala mai, de lasuu laꞌa heni mbaa la sila. Tehuu Abram husi heni sala. ");
INSERT INTO llg_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Ledoeik ledo tesa, boe ma Abram sunggu namanee. Ana nalameꞌi kikiu mumuuk mboti nalan, losa ana bii nalan seli. ");
INSERT INTO llg_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","15","Boe ma, Manetualain nafadan nae, “Abram! Neu ko o masoda losa mamalasi malan seli, ma, mate mua ndoo-ndoo, bei fo latoi neulalau o. Tehuu o numbu-sadu mala, neu ko leu tai nai hataholi feꞌek nusan. Neu ko hataholi nusak leme nusak ndia mai, ala tao sala daꞌdik ata, boe ma ala tuni-ndeni sala, ala doidoso lalan seli, losa teuk natun haa. Tehuu, neu ko Au huku hataholi nusak ndia. Boe ma, Au ua o numbu-sadu mala, kalua leme ndia mai, ma ala leni sila basa hata pusaka nala makadotok. ");
INSERT INTO llg_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Dei fo Au heti, fo neu o numbu-sadu dope kaliman, na, ala fali ia mai seluk bali. Hatematak ia, hataholi Amori la, leo lai dae ndia. Hataholi la ia manggalauk, tehuu bei taa manggalauk nalan seli. Tehuu mete ma, o umbu-ana mala fali ia mai, na, Au pake sala, fo huku nakalulutu hataholi Amori la. Huu faik ndia, sila manggalau nala lena susudik so.” ");
INSERT INTO llg_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Ledoeik leꞌodae so, boe ma, nggengge laꞌo dae esa namasu, ma mbele esa mbila, de dua sala lakababalek lesik mbaa nakadadala kadua kala sila laladan. ");
INSERT INTO llg_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Faik ndia, boe ma LAMATUAK tao heheluk no Abram. Ana nafadan nae, “Au helu, neu ko Au fee dae babaꞌek ia, neu o numbu-saꞌdu mala, mulai neme lee Masir mai, losa lee Efrat, ");
INSERT INTO llg_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","ma dae hataholi Keni, Kenas, Kadmon, ");
INSERT INTO llg_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Het, Feris, Refaim, ");
INSERT INTO llg_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amori, Kanaꞌan, Girgasi, ma Yebus enan.” ");
INSERT INTO llg_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","3","Faik ndia, Abram fali neme Masir mai so, de ana leo teuk sanahulu nai Kanaꞌan so. Saon Sarai, bei taa hambu anak. Sarai ata ina Masir esa, nade Hagar. Laꞌi esa, Sarai kokolak no Abram, nae, “Kaꞌa aa! LAMATUAK kena au ana manang so. De malolenak, kaꞌa muU sunggu mua au atang Hagar ndia, fo suek ana bonggi fee au.” Boe ma, Abram tao tungga saon kokolan. De Sarai fee Hagar, daꞌdik neu Abram sao mulin. ");
INSERT INTO llg_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Boe ma, Abram neu sunggu no Hagar, de inak ndia nailu. Tehuu, neu faik fo Hagar ana bubuluk ndia nailu, boe ma ana koao, de ana tao Sarai neu belin taa. ");
INSERT INTO llg_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Boe ma, Sarai kokolak no Abram, nae, “Au ndia fee o ata ndia, fo ana dadik neu o sao mulim. Tehuu, inak ndia bubuluk ndia nailu, boe ma ana tao au uu beling taa. Ia, o salam basa ia! Neme naa, fo ela LAMATUAK naketu ita dua nggata dedeꞌan ia. Bei fo o bubuluk!” ");
INSERT INTO llg_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abram nataa, nae, “Leoiak! O ia, sao uluk. Tehuu ndia, kaꞌda o atam. De o maena koasa neu ndia. De o sangga mae tao hata neu ndia boe oo, neme kaꞌda o mai!” Basa boe ma, Sarai tao Hagar taa no hadak, losa nalai. ");
INSERT INTO llg_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Ana nalai losa mamana nees. Boe ma, LAMATUAK atan esa neme nusa-sodak mai, de ana hambun dekak no oe matak manai dalak maneni Sur neu. ");
INSERT INTO llg_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Boe ma, nae, “Wei! Hagar, fo Sarai atan! Hatina de o nai ia? O muma bee mai, ma o sangga bee muu?” Boe ma, Hagar nataa nae, “Au alai laꞌo ela au malangga inang.” ");
INSERT INTO llg_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Boe ma, LAMATUAK atan kokoen, nae, “Leoiak! Malolenak o fali muni o malangga inam muu. Ana tao o leobeek boe oo, kaꞌda simbo kana. ");
INSERT INTO llg_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","O boso bii. Dei fo Au tao o numbu-sadu mala dadik makadotok, losa hataholi tala hingga lala sala. ");
INSERT INTO llg_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Hatematak ia o mailu ia so. O bonggi ana touanak esa. O musi foin, naꞌde Ismael (hihii sama leo dedeꞌa deꞌek feꞌek esa ndandaan nae, ‘Lamatuak namanene’), huu Lamatuak namanene o tanim so. ");
INSERT INTO llg_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Tehuu kakanak ndia inahuu mai, tehuu ana nasoda dook no tolanoo nala. Huu ndia sama leo ndala fui ia, fo taa tungga nalelak palenda. Ana musu no sudi see, ma basa hataholi la ala musu lasafali lo ndia.” ");
INSERT INTO llg_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Hagar namanene basa leondia, boe ma ana kokolak nai dalen, nae, “Au ita LAMATUAK so, fo Ana mete ma nanea au.” Boe ma, ana mulai noke Manetualain, pake nadek “Lamatuak mana faduli au.” ");
INSERT INTO llg_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Huu ndia, de hataholi la ala foi oe matak ndia, nade, BeerLahai Roi, fo ndandaan nae, “Oe matak neme Ndia fo kasodak mai, fo mana faduli au.” Oe ndia, mamanan nai nggolo Kades no nggolo Beret laladan. Oe matak ndia, bei nai ndia losa hatematak ia. ");
INSERT INTO llg_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Basa ndia, boe ma Hagar fali. Boe ma, ana bonggi ana touanak esa. Abram foin, nade Ismael. ");
INSERT INTO llg_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Faik fo Hagar bonggi Ismael, Abram teun falu hulu nee so. ");
INSERT INTO llg_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Ledoeik Abram teun sio hulu sio, LAMATUAK mai Mataon neu Abram. Boe ma, Ana kokolak nae, “Au ia, Manetualain fo Mana Koasa Manai Lain Seli. O musi tungga makandoo Au hihiing, ma masoda no ndoos. ");
INSERT INTO llg_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Au sangga mbaꞌa hehelu ua o, ma tao o numbu-sadu mala boe lamanoꞌu.” ");
INSERT INTO llg_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Boe ma Abram sendek de nakatele losa dae. Boe ma, Manetualain kokolak nakandoo, nae, ");
INSERT INTO llg_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","5","“Au tao heheluk ua o, leoiak: neu ko o dadik hataholi nusak noꞌuk bei-baꞌi nala. Huu ndia, de o nadem ta Abram so, (ndandaan nae, ‘amak fo naden nananita-nalelak)’, tehuu Abraham (fo ndandaan nae, ‘nusak noꞌuk bei-baꞌin’). ");
INSERT INTO llg_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Dei fo Au tao o numbu-sadu mala, boe lamanoꞌu. Ma dei fo Au tao hataholi nusak noꞌuk, leme sila mai, ma soꞌu manek noꞌuk, leme numbu-sadu kala sila mai. ");
INSERT INTO llg_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Au toꞌu ahele Au hehelung ua o, ma o numbu-sadu mala. Heheluk ia, taa namaketu, huu Au ia, o mua o numbu-sadu mala Manetualain. ");
INSERT INTO llg_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Basa dae Kanaꞌan ia, neu ko Au feen neu o, ma o numbu-sadu mala. Hatematak ia, kada o leo tataak nai ia. Tehuu, neu ko o numbu-sadu mala hambu dae Kanaꞌan ia, losa dodoon neu. Ma neu ko, Au boe oo, dadik sila Manetualain. ");
INSERT INTO llg_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","10","Tehuu o, ma o numbu-sadu mala boe oo, musi toꞌu mahele heheluk ia, no dale katema-tuak. Basa tou kala, musi ala sunat. ");
INSERT INTO llg_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","13","Hatematak ia, basa tou kala mulai neme faik falu mai, musi sunat. O bobonggi mala, ma basa o hataholi mana tao ue-ledi mala, ma ata fo o hasa mala kala leme nusa feꞌek mai, basa sala musi sunat. Sunat ndia, dadik neu ita dua nggata, tanda hehelun, fo nakadita nai ei ao mala. ");
INSERT INTO llg_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Touk bee ndia taa sunat, na, taa masok nai Au hehelunmg ia, ma taa maso dadik Au hataholing.” ");
INSERT INTO llg_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Basa ndia, boe ma Manetualain kokolak nakandoo, nae, “Mulai neme hatematak ia, o boso moke o saom mae Sarai bali, tehuu moke mae Sara leo. ");
INSERT INTO llg_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Neu ko, Au fee babaꞌe-babatik noꞌuk neu Sara, fo ana bonggi fee o, ana tou-anak esa. Tetebes! Dei fo Sara dadik nusa noꞌuk bei-baꞌi nala. Ma dei fo Au soꞌu mane noꞌuk, neme ndia numbu-sadu nala mai.” ");
INSERT INTO llg_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Boe ma, Abraham sendek de nakatele losa dae. Tehuu, ana hika nai dalen. Ana duduꞌa nae, “Toulasi kakaluk teuk natun esa leo au ia, na, bei ana hambu anak bali? Ma Sara namalasi duduu dae, teuk sio hulu, na, neme bee mai, ana bei bisa bonggi?” ");
INSERT INTO llg_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Boe ma, nafada Manetualain, nae, “Lamatuak. Ela kada Ismael mesa kana, hambu au pusakang boe oo, taa dadi hata-hata.” ");
INSERT INTO llg_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Tehuu Manetualain nataa, nae, “Taa! Huu neu ko o saom Sara, bonggi touanak esa. O foin, nade Isak. Au hehelung, neu ko ana konda neu ndia, ma ndia numbu-sadu nala, losa dodoon neu. ");
INSERT INTO llg_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Au boe oo amanene hata fo o moke fee Ismael. Huu ndia, de Au boe oo feen babaꞌe-babatik, ma Au tao amanoꞌu ndia numbu-saꞌdu nala. Neu ko, hambu mane leo sanahulu dua leme ndia numbu-saꞌdu nala mai. Ma neu ko ndia numbu-saꞌdu nala ala dadik nusak nananita-nalelak. ");
INSERT INTO llg_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Mae leondiak boe oo, Au tao heheluk soaneu kada o anam Isak. Neu ko teuk mana maik ia, meda fain leo ia, Sara ana bonggin so.” ");
INSERT INTO llg_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Kokolak basa leondia, boe ma Manetualain laꞌo ela Abraham. ");
INSERT INTO llg_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","27","Faik ndia, boe ma Abraham tao tungga tutik, Manetualain palendan ndia. De ana sunat. Basa de ana sunat Ismael, ma basa touk manai ndia uman dale. Ana sunat basa ata tou kala boe. Faik ndia, Abraham teun sio hulu sio so, ma Ismael teun sanahulu telu. ");
INSERT INTO llg_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Faik esa, Abraham leo dekak no ai inahuu kala, nai Mamre. LAMATUAK mai natudu Mataon neu ndia neme ndia. Tutuin leoiak: faik ndia ledo natobi nala nanggatuuk sangga ani, neme uma teman matan. ");
INSERT INTO llg_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Leꞌdoeik Abraham botik matan, boe ma nita hataholi telu lambadeik lai ele. Boe ma, ana nalai lai-lai neu solu kasa. Ana sendek, ");
INSERT INTO llg_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","de nae, “Ama nggalei! Mete ma ama sala nau, na, tuli tataak nai au tendang dei. Mae kada minu oe hiak boe oo, malole. ");
INSERT INTO llg_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Ama sala hahae ao mala miu saok dei. Dei fo kakana kala haꞌi oe, fo mai safe ama sala ei nala. ");
INSERT INTO llg_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Dei fo au uu tao nanaꞌak fee ama sala, fo hambu balakaik fa, bei fo ama sala laꞌok makandoo. Au amahoko, huu bisa au ono-lau ama sala.” Lataa, lae, “Ndia malole boe. Makasi. Ai tuli.” ");
INSERT INTO llg_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Boe ma, Abraham nalai neni uma teman dalek neu, de nafaꞌda Sara, nae, “Lai-lai! Haꞌi mala hade uu neulauk saku esa, fo tao loti.” ");
INSERT INTO llg_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Boe ma, nalai neni sapi nala neu, de ana hele nala, sapi ana maao esa. De ana nadenu atan hala sapi ndia. ");
INSERT INTO llg_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Boe ma, Abraham haꞌi kamba oe, keju, ma mbaa fo bei fo nana nasuk ndia, de nenin neu hataholi mana mai kala sila. Neu leꞌdoeik fo ala laꞌa, ana nambadeik neu ai huun de ana ono-lau sala. ");
INSERT INTO llg_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Boe ma, ala latanen lae, “Abraham! O saom Sara nai bee?” Ana nataa, nae, “Nai uma temak dale.” ");
INSERT INTO llg_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Boe ma, esa neme katelu kala sila kokolak, nae, “Meda teu manamaik, Au fali maing. Faik ndia, na, o saom Sara, bonggi ana touanak esa so.” Ledoeik ala kokolak lae leo ndia, de Sara namanene neme lelesu dean mai. ");
INSERT INTO llg_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Faik ndia, Abraham no Sara namalasi nalan seli so, ma Sara taa hambu bulak so. ");
INSERT INTO llg_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Sara namanene ala kokolak leondiak boe ma, ana hika nai dalen. Ma ana duduꞌa nae, “Aweꞌek! Au amalasi nggonggofek leo iak, ma au saong nabeꞌbok so. Neme bee mai, ai bei mahiik dadik neu masao beuk, fo sangga anak bali?” ");
INSERT INTO llg_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Boe ma, LAMATUAK natane Abraham, nae, “Hatina de Sara hika? Ana duduꞌa nae, hata fo Au kokolak ndia, taa bisa dadi huu ndia lasik so, do? ");
INSERT INTO llg_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Au ia, LAMATUAK! Taa hambu hata fo Au taa bisa taon! Masanenedak neulalau, baa! Dei fo mete ma teu manamaik, Au fali maing, na, Sara bonggi touanak esa so.” ");
INSERT INTO llg_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sara namanene leondia, boe ma ana bii, de ana nalelesi, nae, “Au taa hika, maa!” Tehuu, MANETUALAIN nataa nae, “Memak isinaak, o hika so.” ");
INSERT INTO llg_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Boe ma, hataholi kateluk manamai kala sila, sangga laꞌo leni kota Sodom leu. De Abraham noo sala losa dala laladak. Neme ndia mai, ala bisa lita kota Sodom. ");
INSERT INTO llg_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Boe ma, LAMATUAK kokolak nai dalen, nae, “Malolenak, Au tui Abraham, hata fo Au sangga tao. ");
INSERT INTO llg_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Huu ndia numbu-sadu nala, neu ko ala boe lamanoꞌu, ma ala dadik hataholi nusak fo ana seli. Ma ndia boe oo, dei fo dadik babaꞌe-babatik neu basa nusak malai daebafok ia. ");
INSERT INTO llg_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Au hele alan so, fo nanoli ndia ana nala, ma hataholi feꞌe kala, fo ala tungga lakandoo LAMATUAK dalan sodan, suek lasoda lo ndoos, ma taa lasapepeko. Mete ma ala tao leondiak, na, Au tao atetu Au hehelu ua Abraham.” ");
INSERT INTO llg_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Boe ma, LAMATUAK nafada Abraham, nae, “Leoiak! Au amanene hataholi noꞌu kala, haluao laꞌeneu hataholi la, malai Sodom ma Gomora. Sila manggalaun seli susudik so. ");
INSERT INTO llg_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Huu ndia, de Au konda mai, fo sangga palisak aong, basa hata fo Au amanenek ndia so, tetebes do taa. Mete ma taa, na, dei fo Au bubuluk. ");
INSERT INTO llg_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Ledoeik LAMATUAK bei kokolak no Abraham, tehuu hataholi mana mai kadua kala sila, laꞌok lakandoo leni kota Sodom leu. ");
INSERT INTO llg_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abraham neu deka-deka no Lamatuak, de ana kokoe, nae, “Leobee? Ama sangga tao nakalulutu laꞌi esak, hataholi ndoos ma hataholi manggalauk, do? ");
INSERT INTO llg_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Leo hambu hataholi ndoos 50, lai kota ndia dalek, na Ama ana bei nau tao nakalulutu sala boe? Do Ama taa tao nakalulutu kota ndia, huu sila. ");
INSERT INTO llg_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ama boso tao leondiak! Boso losak hataholi ndoo sala, mate tungga, huu Ama nau tao nakalulutu hataholi manggalau kala sila. Ama ndia dadik Manamaketu dedeꞌak, nai lalai ma daebafok. Ma Ama mesa kana bubuluk, ndia taa ndoos.” ");
INSERT INTO llg_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","LAMATUAK nataa nae, “Leo Au hambu hataholi ndoos 50 nai kota Sodom, na, Au taa huku kota ndia, huu hataholi sila.” ");
INSERT INTO llg_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Boe ma, Abraham kokolak seluk, nae, “Ama, au oke ambon, leo au bisa kokolak fa seluk bali. Au ia, kada hataholi nggoak, fo taa bubuluk hata esa boe. ");
INSERT INTO llg_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Leo taa hambu hataholi ndoos lima hulu, tehuu kada hambu 45, na, leo bee? Leo haꞌi heni kada hataholi lima lai ndia, na, Ama bei nau tao nakalulutu kota ndia, do?” Manetualain nataa nae, “Leo Au hambu hataholi ndoos haa hulu lima lai ndia, na, Au taa tao akalulutu kota ndia.” ");
INSERT INTO llg_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Basa de Abraham ana kokoe seluk nae, “Leo hambu kada hataholi ndoos haa huluk, na, leobee, Ama?” Boe ma, Ana nataa nae, “Leo hambu haa hulu, na, Au taa huku sala.” ");
INSERT INTO llg_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Abraham kokoe nakandoo seluk nae, “Ama, boso mamanasa, tehuu, leo hambu hataholi ndoos kada telu huluk, na, leobee?” Ana nataa, nae, “Leo Au hambu telu hulu, na, Au taa huku sala.” ");
INSERT INTO llg_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abraham ana kokoe seluk nae, “Ama boso mamanasa mete ma au atane seluk fa. Mete ma hambu kada hataholi dua huluk, na, leobee?” Boe ma, Ana nataa, nae, “Leo hambu dua hulu, na, Au taa tao akalulutu kota ndia. ");
INSERT INTO llg_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Boe ma, Abraham ana nggoe kokolan nae, “Ama! Au kokolak laꞌi esa seluk bali, tehuu boso mamanasa au, baa! Leobee mete ma hambu kada hataholi ndoos sanahuluk?” Boe ma, Ana nataa, nae, “Leo Au hambu hataholi ndoos sanahulu lai ndia, na Au taa tao akalulutu kota ndia.” ");
INSERT INTO llg_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Kokokolak basa leondia, boe ma Ana laꞌo nakandoo, de Abraham fali. ");
INSERT INTO llg_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Leꞌdoeik Manetualain bei nakokola no Abraham, tehuu Ndia ata kadua nala, laꞌok lakandoo leni kota Sodom leu. Ala losa ele, tehuu ledo sangga tesa so. Faik ndia, Lot bei nanggatuuk nai kota lelesu mason. Ana nita hataholi kadua kala sila, boe ma neu solu kasa. Boe ma, ana sendek, de nakatele neu mata nala. ");
INSERT INTO llg_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Boe ma, ana kokolak nae, “Ama nggalei! Mai fo tuli tataak miu au umang dei. Ela ama sala safe ei mala, ma sunggu nai ele. Foꞌa fafain, bei fo ama sala laꞌo makandoo.” Tehuu ala lataa, lae, “Makasi. Boso tao masambutek! Ela ai sunggu miu kota moon leo.” ");
INSERT INTO llg_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Tehuu Lot kokoe nakandoo sala, losa ala nau leo tataak nai ndia uman. Boe ma, Lot tunu loti, ma ana sadia mei, de ala laꞌa noꞌu. ");
INSERT INTO llg_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Hataholi mana mai kala bei taa leu sunggu, tehuu tou Sodom asa, inahuu-kadiꞌik basa sala mai eꞌo lala Lot uman. ");
INSERT INTO llg_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Ala eki taa no haꞌdak neu Lot, lae, “Heeh, Lot! Tou kadua kala isinaak sila lai bee? Tao sala deak mai, huu ai sangga saꞌe sala!” ");
INSERT INTO llg_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Boe ma, Lot deak neu, de ana kena lelesu. ");
INSERT INTO llg_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Ana kokolak nae, “Tolanoo nggalei! Ei boso tao manggalauk leo ndiak, neu au hataholi mana mai nggala. ");
INSERT INTO llg_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Hena ei mamanene, baa! Au ana inana nggala dua bei ao tema. Au fee dua sala leu ei. Ei sangga mae tao hata neu sala boe oo, neme kada ei mai. Sadi ei boso tao hata-hata neu au hataholi mana mai nggala ia, huu tungga ita hadan, na au musi anea neulalau sala.” ");
INSERT INTO llg_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Tehuu hataholi Sodom asa sila, ala eki, lae, “O boso seseok tungga! Huu o ia, kada hataholi mana taik nai ia! O hataholi deak, de o taa hak heti ai. Malolenak o boke heok muma ia mai. Mete ma taa soo na, ai tao o belan lena neme hataholi kadua kala sila mai!” Basa de, ala timba heni Lot, boe ma basa sala, tumbu landaa, fo sangga tao lakalulutu lelesu ndia. ");
INSERT INTO llg_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Tehuu, hataholi kaduak mana mai kala sila, ala look lima nala, boe ma ala hela Lot neni uma dale neu, de ala nggoe lelesu. ");
INSERT INTO llg_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Boe ma dua sala tao lamboke hataholi Sodom asa mata nala, de losak ala lafadadabak sangga lelesu, tehuu taa hambu sana. ");
INSERT INTO llg_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","13","Basa boe ma, hataholi kaduak mana mai kala sila, ala kokolak lo Lot, lae, “Lot! LAMATUAK bubuluk kota ia manggalaun so. De Ana haitua ai mai, fo sangga tao makalulutu basa kota ia. De, o bei kabobonggik feꞌek nai kota ia, do taa? Mete ma hambu ana touanak do inanak, do manefeuk, do sudi see, na, muu mua sala kalua leme kota ia mai leo!” ");
INSERT INTO llg_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Boe ma, Lot neu natonggo no sangga mana dadik neu ndia manefeun dua, de nafada sala nae, “Mamanene neulalau! Hatematak ia ei kalua lai-lai mima kota ia mai leo, huu LAMATUAK sangga tao nakalulutun ia” so! Lot nakalalamba ndia. ");
INSERT INTO llg_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Foꞌa fafain, boe ma Manetualain ata kadua nala sila, lakaseti Lot asa, fo ala kalua lai-lai leo. Ala lae, “Lot! Foꞌa leo! Hela mua o saom, ma ana inana kadua kala sila, fo malai leo. Laꞌo ela kota ia. Boso losak ei mate nggoa-nggoa, ma makalulutuk mia kota ia.” ");
INSERT INTO llg_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Tehuu, Lot bei nakaeꞌesok. Naa te LAMATUAK nau nasalaꞌe sala. Huu ndia, de hataholi mana mai kadua kala sila, toꞌu lala lima nala, de ala hela Lot, saon, ma ana inana kadua nala, de loo sala kalua leme kota ndia mai. ");
INSERT INTO llg_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Boe ma, esa neme kaduak mana mai kala sila, palenda nae, “Malai lai-lai, fo miu sangga sodak leo! Boso suli dea! Boso hahae nai bafak! Malai ndaꞌe makandoo mini letek ele miu, fo suek ei boso mate!” ");
INSERT INTO llg_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Tehuu, Lot bala nae, “Awii, ama aa! Boso leondiak! ");
INSERT INTO llg_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Memak ama fali masalaꞌe mala ai so. Tehuu, letek ndia doon seli! Naafo, ai bei taa losa ele, tehuu soe husi hambu ai, nai dala lalaꞌdak so. ");
INSERT INTO llg_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Ama suli dei. Hambu nggolo kadiꞌik esa, taa dook neme ia mai. Nggolok ndia, sosoan taa fa boe. De mete ma, ama nau soo, na, ela ai miu sangga soda kada nai ndia leo.” ");
INSERT INTO llg_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Ana nataa, nae, “Neu! Miu leo! Neu ko au taa tao akalulutu nggolok ndia. ");
INSERT INTO llg_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","De, hatematak ia, malai lai-lai ele miu leo! Huu au taa bisa tao hata-hata esa boe, mete ma, ei bei taa losa nai ele.” Mulai neme faik ndia mai, hataholi la, ala foi nggolok ndia, nade Soar, fo ndandaan nae, ‘kadiꞌik’. ");
INSERT INTO llg_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Neu ledoeik, ledo mulai sadu, boe ma Lot asa losa Soar. ");
INSERT INTO llg_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Nggengge neuk LAMATUAK nggangga haꞌi, ma balerang mana mbilak, konda leme lalai mai, neni Sodom ma Gomora neu. ");
INSERT INTO llg_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","LAMATUAK tao nakalulutu basa kota, ma nggolok lalaꞌen malai dae babaꞌek ndia, ma basa kasodak malai ndia, fo ndia: hataholi, banda, ma sesele-nggali kala. ");
INSERT INTO llg_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Ledoeik fo ala lalai, tehuu Lot saon suli dea neu, de nggengge neuk, ana dadik dii masik. ");
INSERT INTO llg_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Foꞌa fafain boe ma, Abraham neni seluk mamanak, fo laꞌikesan nambadeik neme ndia, fo ana kokoe LAMATUAK. ");
INSERT INTO llg_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Boe ma, ana suli dae neu neni Sodom ma Gomora, ma basa bafak ndia. Ana mete, tehuu sudi nai bee mesan, haꞌi masuk bubuak-bubuak, hene neni lalai neu. Ma haꞌi naꞌa basa-basan. ");
INSERT INTO llg_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Manetualain Ana tulun Lot kalua neme mamanak, fo nanahukuk ndia mai, huu Ana nasaneda Ndia hehelun neu Abraham. ");
INSERT INTO llg_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Faik ndia, Lot bii leo nakandoo nai nggolo Soar. Huu ndia, de ana no ana ina-ana kadua nala sila, huꞌa leni letek leu. Boe ma, ala leo lai luak esa. ");
INSERT INTO llg_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Laꞌi esa, inana kaꞌak kokolak no fadin, nae, “Ndule basa ia, taa hambu touk esa, fo ana bisa mai sao nala ita. Ma taa dook so, te ama boe namalasi, ma taa bisa hambu anak seluk so. ");
INSERT INTO llg_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","De, malolenak, ita fee ama ninu mafuk. Basa, na, ita sunggu ton, fo ela ita bisa tuti ama numbu-sadu nala.” ");
INSERT INTO llg_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Boe ma, leꞌodaen ndia, ala fee aman ninu mafuk oe anggol. Basa boe ma, inana kaꞌak neu sunggu no aman. Tehuu toulasik mafuk nalan seli, losa taa bubuluk ana tao hata no ndia ana inanan so. ");
INSERT INTO llg_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Foꞌa boe ma, kaꞌak nafada fadin, nae, “Fadi aa! Leꞌodaek au sunggu ua ama so. Leꞌodaen ia, na, o babaꞌem. Dei fo ita tao mafuk ama seluk bali, boe ma fadi muu sunggu muan leo. No leondiak, ita dua nggata hambu anak noꞌu, fo tuti ama numbu-sadun.” ");
INSERT INTO llg_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Leꞌodaen ndia boe oo, ala tao mafuk sila aman seluk bali. Boe ma, ana mulianak maso neu sunggu no aman. Tehuu toulasik mafuk nalan seli, losak taa bubuluk ana tao hata no ana inanan so. ");
INSERT INTO llg_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","No leondiak, boe ma dua sala lailu leme sila ama bonggi hehelin mai. ");
INSERT INTO llg_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Basa boe ma, inana kaꞌak bonggi nala ana touanak esa. Boe ma, ana foin, nade Moab (fo hihii leo dedeꞌa deꞌek Ibrani esa, fo ndandaan nae, ‘ana dadi neme aman mai’.). Ndia ndia, daꞌdik hataholi Moab asa hatematak ia, baꞌi makababalen. ");
INSERT INTO llg_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Boe ma, inana fadik bonggi nala ana touanak esa. De, Ana foin, nade Ben Ami (ndandaan nae, ‘kakanak neme au hataholing mai’). Ndia ndia, dadik hataholi Amon nala hatematak ia, baꞌi makababalen. ");
INSERT INTO llg_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Basa ndia, boe ma Abraham huꞌa neme Mamre mai, neni dae Negeb, fo manai kona neu, de ana leo nai nggolo Kades no nggolo Syur laladan. Tehuu taa dook boe ma, ana huꞌa neni nggolo Gerar neu. ");
INSERT INTO llg_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Boe ma, nafada hataholi la lai ele nae, Sara ndia, na, ndia feton. Huu ndia de, Abimelek mane Gerar, nadenu ndia hataholi nala, leu haꞌi lala Sara, de lon neni manek uma manen neu. ");
INSERT INTO llg_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Leꞌodaek esa, boe ma Manetualain natudu Mataon neu manek nai meꞌis dale. Ana kokolak, nae, “O sangga mate ia so! Huu o haꞌi mala hataholi saon.” ");
INSERT INTO llg_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","5","Tehuu, Abimelek nataa, nae, “Manetualain! Au bei taa koi laꞌe inak ndia. Ma au boe oo, bei taa asala uan. Abraham mesa kana nafada nae, inak ndia, ndia feton! Ma inak ndia boe oo, manaku leondiak boe. Huu ndia, de au fee leu haꞌi lalan no dale malalaok. De, Manetualain boso fee salak neu au!” ");
INSERT INTO llg_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Boe ma, Manetualain nataa nae, “Memak Au bubuluk o dalem malalaok. Ma Au ndia akalelee, fo o boso koi laꞌe inak ndia. No leondiak, na, o boe oo, taa tao salak neu Au. ");
INSERT INTO llg_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Hatematak ia, o haitua falik inak ndia neni saon neu. Au mana kokolang ndia. De, moken fo ana hule-haladoi fee o, fo ela o boso mate. Tehuu mete ma o taa fee falik inak ndia, na, masanenedak neulalau! Huu o, ma basa o hataholi mala, dei fo ei mate ia so.” ");
INSERT INTO llg_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Foꞌa fafain, boe ma manek noke basa ndia pegawe nala, de ana tui ndia meꞌin. Boe ma, basa sala bii. ");
INSERT INTO llg_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Boe ma, manek noke Abraham, de natanen, nae, “Au tao asala o hata, losak o tao soe au, ma au lauinggung? O taa bole tao dedeꞌa taa malole leoiak. ");
INSERT INTO llg_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","O duduꞌa hata, losak o tao leoiak?” ");
INSERT INTO llg_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Boe ma, Abraham nataa nae, “Ama manek! Au duduꞌa, ae ei basa nggei hataholi taa malelak Manetualain. De, neu ko hambu hataholi fo sangga ana tao nisa au, fo ela ana haꞌi nala au saong. ");
INSERT INTO llg_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Memak au kokolak tetebes, ae au fetong ndia. Huu ai dua nggai ama esa, tehuu ai inan kofeꞌe. Huu ndia, de ai masaok. ");
INSERT INTO llg_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","De, faik fo Manetualain nadenu ai miu tai nai tou nusan, au afada au saong ae, ‘Mete ma ita teni sudi bee teu, boe ma hambu hataholi latane ita dua nggata natututin, de, mete ma o sue au, na, mataa mae, ita dua nggata feto-naak.’ ” ");
INSERT INTO llg_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","16","Basa boe ma, mane Abimelek fee falik Sara. Boe ma, ana kokolak no Sara, nae, “Hatematak ia, au bae o kaꞌam doi lilo fulak lifun esa, fo dadik buti, au taa tao sala hata-hata ua o. Ela basa hataholi la, bubuluk leondiak!” Boe ma, manek kokolak no Abraham, nae, “Abraham! Au nusang ia, nanasoik neu o. O sangga mae muu leo nai sudi bee boe oo, bole.” Basa ndia, de ana fee Abraham sapi, biꞌiaek-biꞌilombo, ma ata touk no inak. ");
INSERT INTO llg_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Makasososan LAMATUAK kena basa ina kala ana mana nala, fo mana leo nai Abimelek dae babaꞌen, huu ana namoa nala Abraham saon. Tehuu, manek ana fee falik Sara neni saon, boe ma Abraham ana hule-haladoi, fo Manetualain Ana soi seluk ina kala ana mana nala, de ala bisa bonggi bali. ");
INSERT INTO llg_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","7","Basa ndia, boe ma MANETUALAIN fee babaꞌe-babatik neu Sara, tungga Ndia hehelun. Sara nailu nai Abraham fai lasin dale so. Nandaa no fain, boe ma ana bonggi ana touanak esa. De Abraham foi kakanak ndia, nade Isak (ndandaan nae, ‘ana hika’). Sara kokolak nae, “Manetualain tao nala au hika, huu hatematak ia, au amahoko. Hataholi la duduꞌa lae, au taa bonggi nai au fai lasing dale leoiak. Naa te, mae au saong namalasi duduu dae, tehuu au bei bisa bonggi feen. De, hatematak ia, see namanene dedeꞌak ia, na, neu ko ana hika tungga no au boe.” Ledoeik Isak faik falu, boe ma Abraham sunat ndia, tungga Manetualain palendan. ");
INSERT INTO llg_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Basa boe ma, Isak boe inahuu. Ledoeik sangga finan, boe ma Abraham tao feta inahuuk. ");
INSERT INTO llg_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","10","Laꞌi esa, Sara nita Abraham sao mulin anan Ismael, nambue nakaseseꞌbok Isak. Nita leondia, boe ma Sara kokolak no saon, nae, “Husi heni ata Masir ndia no anan! Huu au taa nau ata ndia anan, simbo pusaka hata esa boe. Kada au anang mesa kana, hambu basa sala.” ");
INSERT INTO llg_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Abraham namanene Sara kokolak nae leondia, boe ma ana nameda taa malole, huu Ismael, na, ndia anan boe. ");
INSERT INTO llg_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Tehuu Manetualain kokolak no Abraham nae, “Bam! O boso duduꞌa o sao mulin no ndia anan ndia. Tungga kada Sara hihiin leo, huu o hambu numbu-saduk fo Au heluk ndia so, nesik Isak. ");
INSERT INTO llg_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Tehuu, Au boe oo, feebabaꞌe-babatik neu o sao mulim anan, huu ndia boe oo, o ana hehelim. Dei fo ndia numbu-sadu nala, dadik hataholi nusak esa.” ");
INSERT INTO llg_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Neu foꞌa fafain, boe ma Abraham tao lepa-ngge fee Hagar, de ana londa oe boto esa neu alun. Boe ma, ana mboꞌi inak ndia no anan Ismael, de ala laꞌok ndule dae nees, dekak no Beer Syeba. ");
INSERT INTO llg_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Ledoeik sila oe nininun basan, boe ma Hagar ana laꞌo ela anan neu ai anak esa saꞌon. ");
INSERT INTO llg_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Boe ma, ana duduꞌa nai dalen dale, nae, “Au taa bisa akatataka ala so bali, ita kakanak ia maten.” Basa, de ana heok neu nanggatuuk, meda meter lima hulu neme kakanak ndia mai. Boe ma, namatani nakaleleu. ");
INSERT INTO llg_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Manetualain boe oo namanene Ismael hala tanin, de Ndia atan esa neme nusa-sodak mai, de noke Hagar, nae, “Hagar! Hatina de o dale hedi leoiak? Boso bii, huu Manetualain namanene kakanak ndia tanin so. ");
INSERT INTO llg_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Hatematak ia, o foꞌa, fo muu mete kakanak ndia. Matetea ndia dalen, huu dei fo Au sangga tao ndia numbu-sadu nala, dadik hataholi nusak esa fo ana seli.” ");
INSERT INTO llg_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Basa boe ma, Manetualain tao namaneu ndia matan, losak nita oe matak esa nai ele, de neu diꞌa oe neu boto ndia, fo ana fee kakanak ndia ninu. ");
INSERT INTO llg_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","21","Boe ma, Ismael no inan leo lai mo salaek Paran. Ana inahuu mai, de ana dadik mana kou malelak nalan seli. Basa ndia, boe ma inan nakasasao kana no inana Masir esa. Basa ia la dadi, huu Manetualain no Ismael. ");
INSERT INTO llg_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Faik ndia, mane Abimelek, no ndia malangga musun, nade Fikol, ala mai latonggo lo Abraham. Manek kokolak nae, “Abraham! Ai bubuluk so, Manetualain no o. Huu ndia, de o tao sudi hata boe oo, basan ana daꞌdi. ");
INSERT INTO llg_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","De hatematak ia, au oke o soo neu Manetualain matan, mae, o taa masapepeko au, ma au umbu-ana nggala. Sama leo au tao malole neu o, na, o boe oo musi tao malole neu au nusang ia.” ");
INSERT INTO llg_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abraham nataa, nae, “Hei! Au soo.” ");
INSERT INTO llg_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Tehuu basa ndia boe ma, Abraham nafada manek, nae, “Ama manek hataholi nala, ala lamoa lala au oe matang esa.” ");
INSERT INTO llg_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Manek namanene leondia, boe ma ana nataa nae, “Aah! Bei fo au amanene dedeꞌak ia. Tehuu hatina de ama taa au neme makahulun mai? Au taa bubuluk see tataon ndia.” ");
INSERT INTO llg_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","28","Basa ndia, de Abraham no Abimelek lambaꞌa heheluk. Boe ma, Abraham hele nala sapi ma biꞌilombo, de ana feen neu manek. Basa de, ana hele nakadaik nala biꞌilombo tenak hitu bali. ");
INSERT INTO llg_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Boe ma, manek natanen, nae, “Hatina de o tao leondiak?” ");
INSERT INTO llg_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Abraham nafadan nae, “Ama manek, simbok mala biꞌilombo tena kahitu kala ia, fo dadik tanda nae, ama manek manaku, au kali ala oe matak ia.” ");
INSERT INTO llg_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Huu dua sala, ala soo leme ndia, boe ma ala foi mamanak ndia, nade Beer Syeba. Ndia ndandaan nae, ‘Oe mata Soo’. ");
INSERT INTO llg_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Ala soo lateꞌe, boe ma mane Abimelek no ndia malangga musun, ala fali leni sila nusa Filistin leu. ");
INSERT INTO llg_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Basa ndia, boe ma Abraham sele ai tamariska nai Beer Syeba. Mulai neme faik ndia mai, ai ndia dadik nasanenedak neu Abraham, de, ana nakaluku-nakatele neu LAMATUAK fo Kasodak losa dodoon neu. ");
INSERT INTO llg_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Basa boe ma, Abraham leo tataak losa dook, nai hataholi Filistin nusan. ");
INSERT INTO llg_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Taa dook bali, boe ma Manetualain uku-sudi Abraham, fo sangga nita ndia namanene neu Lamatuak, do taa. Boe ma, Manetualain noken nae, “Abraham!” Ana nataa, nae, “O, Manetualain.” ");
INSERT INTO llg_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Basa de, Manetualain nadenun, nae, “Mamanene neulalau! O haꞌi mala o ana kisam ndia, fo o suen malan seli ndia. Muan neni dae Moria neu, fo o taon dadik tunu-hotuk fee Au. Losa ele, bei fo Au atudu o ndia mamanan, nai letek esa lain.” ");
INSERT INTO llg_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Foꞌa fafain, boe ma Abraham tati nala ai nanaꞌa haꞌi. De ana hehengge ai sila, ma ana fuan neu banda keledei lain. Boe ma, ndia no Isak, ma ndia atan dua, ala laꞌo leni mamanak fo Manetualain nafadak ndia so. ");
INSERT INTO llg_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Ala laꞌo-laꞌo, boe ma neu binesan, Abraham nita mamanak ndia neme dook mai. ");
INSERT INTO llg_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Ana nafada ata kadua kala sila, nae, “Ei dua nggei mahani tataak kada ia, mia banda keledei ia, baa! Au, ma au anang sangga mini lain ele miu, fo sangga makaluku-makatele neu Manetualain. Basa ndia, na, dei fo ai fali ia mai bali.” ");
INSERT INTO llg_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Boe ma, Abraham haꞌi nala ai nanaꞌa haꞌi soaneu tunu-hotuk, de ana fuan neu Isak alun. Ma ndia mesa kana neni dopek, ma haꞌi suꞌuk mana mbilak. Ledoeik dua sala belaꞌo, ");
INSERT INTO llg_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","boe ma Isak noke aman, nae, “Ama aa!” Aman nataa, nae, “Hata, Isak?” Isak natane nae, “Ama aa. Ita sangga tao tunu-hotuk. Nai ia hambu ai, ma haꞌi. Tehuu biꞌilombo ana fo ata paken dadik neu tunu-hotuk ndia, nai bee?” ");
INSERT INTO llg_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abraham nataa, nae, “Ana-nggo ei! Dei fo Manetualain mesa kana fee Ndia biꞌilombo anan fo paken dadik neu tunu-hotuk.” Boe ma, dua sala, ndaꞌe lakandoo. ");
INSERT INTO llg_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Ledoeik ala losa mamanak fo Manetualain nafadak ndia, boe ma Abraham nakatotodok batu, fo tao mei mamana tunu-hotuk. Basa de, ana heti ai nanaꞌa haꞌi leu mei batu ndia lain. Boe ma, ana mbaꞌa anan, de ana nakalelengga kana neu ai nanaꞌa haꞌi lain. ");
INSERT INTO llg_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Boe ma, ana lesu nala dopek, fo sangga hala anan. ");
INSERT INTO llg_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Tehuu nggengge neuk, LAMATUAK atan nanggou neme lalai mai, nae, “Wei! Bam! Mahani dei!” Ana nataa, nae, “Hatina, Manetualain?” ");
INSERT INTO llg_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Boe ma, halak ndia nae, “Boso tao misa kakanak ndia! Boso tao hata-hata neun! Hatematak ia Au bubuluk ae o tebe-tebe tungga Au hihiing huu o mahehele fee Manetualain o ana kisam ndia, fo ana dadik tunu-hotuk.” ");
INSERT INTO llg_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Basa ndia, boe ma Abraham nita biꞌilombo mane esa susulan kai nai ai anak esa baꞌe nala. Boe ma, neu haꞌi nala tutik biꞌilombo ndia, de ana tunun dadik tunu-hotuk fee Manetualain nggati ndia anan. ");
INSERT INTO llg_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","De Abraham foi mamanak ndia, nade, ‘Dei fo Lamatuak sadia hata fo paluu.’ Huu ndia, de losa hatematak ia, hataholi la lae, “Nai LAMATUAK leten lain ndia, dei fo Ana sadia fee hata fo paluu.” ");
INSERT INTO llg_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Basa boe ma, Lamatuak atan nanggou seluk bali neme lalai mai, nae, ");
INSERT INTO llg_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“LAMATUAK mesa kana nafada nae: ‘Au soo ua Au nade heheling, leoiak: ‘O mahehele so, fo fee o ana kisam ndia neu Au, fo daꞌdik tunu-hotuk. Huu ndia, de ");
INSERT INTO llg_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","dei fo Au fee babaꞌe-babatik makadotok neu o, ma o numbu-sadu mala. Dei fo ala tamba lamanoꞌu, losa taa hambu hataholi hingga nala sala, sama leo nduuk malai lalai, ma salaek malai tasibifi. O umbu-ana mala, dei fo ala senggi sila musu nala. ");
INSERT INTO llg_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Neme o numbu-saꞌdu mala mai, dei fo basa hataholi nusa kala malai daebafok, ala hambu babaꞌe-babatik, huu o tungga Au palendang so.’ ” ");
INSERT INTO llg_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Basa ndia, boe ma Abraham no Isak konda fali leni ata kadua nala sila leu, de ala laꞌo noꞌu leni Beer Syeba leu. Boe ma, Abraham ana leo nai ele. ");
INSERT INTO llg_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Laꞌi esa, Abraham namanene lae ndia fadin Nahor saon, Milka bonggi nala ana kala. ");
INSERT INTO llg_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Ana kaꞌak, nade Us. Fadi nala, nade Bus ma Kemuel (fo Aran aman). ");
INSERT INTO llg_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Boe ma, hambu Kesed, Haso, Pildas, Yidlas, ma Betuel. ");
INSERT INTO llg_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuel ndia, na, Ribka aman. ");
INSERT INTO llg_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Tehuu Nahor hambu tamba kakana kala, neme ndia sao nakaboin mai, nade Reuma. Ana bonggi nala Teba, Gaham, Tahas, ma Maaka. ");
INSERT INTO llg_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","2","Mate Sara neu teun natun esa dua hulu hitu so. Faik fo ana mate ndia, Abraham asa, leo lai nggolo Kiryat-Arba (fo ndia Hebron), nai dae Kanaꞌan. Abraham namatani nakaleleu, ma ana beꞌe saon fo mana matek ndia so. ");
INSERT INTO llg_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Boe ma, Abraham neu natonggo no hataholi Het asa, de ana kokolak nae, ");
INSERT INTO llg_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Au ia kada mana taik nai ei lalada mala. Au daeng taa fo atoi au saong. De mete ma ei nau, na, mboꞌi au hasa ala ei daem fa, fo suek au atoin neu ndia.” ");
INSERT INTO llg_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Ala lataa lae, ");
INSERT INTO llg_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Leoiak, Ama! Doo-doo basa ia, ai tao ama, leo ai aman fo ai fee hadak tebe-tebe. De, kada ama hele aom leo, dae bee ndia neulaun ana seli, fo nandaa no ama hihiin. Kada ai simbo kana no malole, tehuu taa hambu mana taa nau.” ");
INSERT INTO llg_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Boe ma, Abraham nambadeik, de ana nakatele fo fee hadak neu madaek, fo hataholi Het asa. ");
INSERT INTO llg_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Boe ma an nae, “Mete ma ei simbok au kokolang isinaak ndia, na, au oke ei tulun kokolak mia toulasi Sohar ana tou-anan, Efron. ");
INSERT INTO llg_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Moken, mete ma bisa, na, ana seꞌo ndia luan, nade Makpela, fo manai ndia osin bifin ndia. Noke belin sudi hida boe oo, au bae. Au nau bae ketu belin neu ei basa nggei matan, fo suek dae ndia dadik neu au ena heheling. Au sangga taon neu ai mamana laten.” ");
INSERT INTO llg_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Faik ndia, Efron nanggatuuk tungga no hataholi Het asa nai ndia, de namanene Abraham kokolan ndia. Boe ma, nambadeik, de nataa Abraham neu basa lasi kala matan, nae, ");
INSERT INTO llg_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Boso leo ndiak ama! Kada leoiak. Au fee osi ndia, ma lua Makpela neu ama. De muu matoi ama saom neu ndia leo. Au fee dae ndia, neu ama neu au hataholi nggala matan, fo ela basa sala ala dadik sakasii!” ");
INSERT INTO llg_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Boe ma, Abraham nakatele bali neu hataholi Het asa mata nala. ");
INSERT INTO llg_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","De ana kokolak no Efron, nae, “Leondiak boe oo neulauk, tehuu ei basa nggei mamanene au kokolang dei. Au nau tifa ketu dae ndia, fo suek au atoi au hataholi nggala leu ndia.” ");
INSERT INTO llg_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","15","Efron nataa, nae, “Dae ndia belin kaꞌda doi lilo fulak natun haa! Soa hata ita dua nggata, esa kokoe esa neu-mai, no kada doik fa ndia? Ama muu matoi saom neu ndia leo.” ");
INSERT INTO llg_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abraham nakaheik dae ndia belin, tungga Efron kokolan. De, hataholi Het asa ala sakasii, Abraham ana hingga doi lilo fulak natun haa, de ana baen neu Efron nai ndia. ");
INSERT INTO llg_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","19","De, no leondiak, Abraham hambu Efron daen, fo dadik neu ndia ena hehelin. Fo ndia, dae manai Makpela, dekak no Mamre. Ana tifa ketu dae ndia no osin, ma luan, no basa ai la. Basa lasi hataholi Het asa, dadik sakasii lae, dae ndia no basa isi nala, Abraham ena hehelin. Basa ndia, boe ma Abraham neu natoi Sara neu lua Makpela, dekak no Mamre (fo ndia Hebron), nai Kanaꞌan. ");
INSERT INTO llg_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","No leondiak, osi ndia, ma luak fo makahulun hataholi Het asa daen, hatematak ia, ana dadik neu Abraham dae hehelin, de ana paken dadik neu mamana lates. ");
INSERT INTO llg_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham teun naluk losa namalasi nalan seli. Ma LAMATUAK nanea neulalaun, boe ma Ana feen nasoda no soda-molek. ");
INSERT INTO llg_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","3","Abraham kahataholi namahehelen esa, fo ana nakaneni basa ndia hata-heton. Laꞌi esa, Abraham noke nalan, de nae, “Mamanene matalolole! Au oke o soo mate munik MANETUALAIN naden. Fo ndia Manetualain mana tao lalai ma daebafok. Mae, o taa bole haꞌi inanak neme hataholi Kanaꞌan asa mai, fo makasasao kana neu au anang Isak. ");
INSERT INTO llg_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Tehuu, o musi muni au nusa heheling muu, fo nai au bobonggi nggala. O sangga nai ndia, inanak esa, fo takasasao kana no au anang.” ");
INSERT INTO llg_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Basa ndia, boe ma ata ndia natane Abraham, nae, “Hei, Ama! Tehuu leobee, mete ma inanak ndia taa nau tungga ia mai? Mete ma leondiak, na, au musi ua ama anan, fo neu sao nai ele, do leobee?” ");
INSERT INTO llg_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abraham nataa, nae, “O masanenedakneulalau! Mae talobee boe oo, o taa bole mua au anang neni ele neu! ");
INSERT INTO llg_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Masanenedak huu LAMATUAK toꞌu koasa nai lalai, fo, Ana no au kalua uma au nusa fuafuni-kedi huseng mai, de Ana no au losa dae ia. Ma Ana mbaꞌa heheluk no au, nae, ‘Dei fo Au fee basa dae ia neu o numbu-sadu mala.’ De, boso bii! Kada muu leo. Huu dei fo Lamatuak nadenu Ndia atan neme lalai mai, fo soi dalak fee o, fo bisa matonggo mua inanak ndia, fo sangga mana dadik au anang saon. ");
INSERT INTO llg_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Mete ma inanak ndia taa nau tungga o ia mai, na, o makamboꞌik muma soo ndia mai. Mae leobee boe oo, o boso mua au anang ele neu.” ");
INSERT INTO llg_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","De ata ndia soo neu Abraham, nae dei fo ana tao tungga basa Abraham hihiin. ");
INSERT INTO llg_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Boe ma, ata ndia hele nala banda onta sanahulu. Basa de, ana fua bua malole mata-mata kala leu banda onta la sila. Boe ma ana laꞌo neni Nahor kotan nai Mesapotamia neu. ");
INSERT INTO llg_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Basa de, ata ndia losa nai kota ndia. Boe ma, ana fee banda onta nala hahae leme kota bifin, dekak no oe matak esa. Faik ndia ledo bobok so, de nandaa no inana kala mai, ndui oe nai oe matak ndia. ");
INSERT INTO llg_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Boe ma, ata ndia hule-haladoi, nae, “LAMATUAK, au malanggang Abraham Manetualain. Tulun soi dalak, fo ela au lalaꞌong ia, hambu buna-boa malole. Matudu Lamatuak dale malolen neu neu au malanggang, ma masaneda ndia hehelun neu au. De, ela au atonggo ua inanak, fo sangga mana dadik Isak saon. ");
INSERT INTO llg_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Manetualain, au ambadeik nai oe matak ia boboan. De inana kala leme kota mai, ndui oe lai ia. ");
INSERT INTO llg_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","De, au oke leoiak: mete ma au kokolak ua inanak esa, ae, ‘Ina aa! Tulun makonda o uloem, fo au inu oe fa dei.’ Mete ma ana nataa, nae, ‘Ama minu leo! Ma dei fo au fee ama banda onta nala linu boe.’ Na, ndia ana dadik tanda nae, inanak ndia fo Manetualain hele nalan Isak saon! No tanda leondiak, na, au bubuluk ae, Manetualain natudu Ndia dale malolen neu au malanggang Abraham.” ");
INSERT INTO llg_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","16","Ana bei taa hule-haladoi nateꞌe, tehuu inanak esa mai so. Naden Ribka. Ndia ndia, Abraham fadin Nahor no saon Milka, umbun. Ribka aman, nade Betuel. Ribka ndia manaꞌa hiak, ma bei aotema. Ana konda neni oe matak ndia dalek neu, de ana diꞌa oe neni uloen neu, boe ma ana hene fali lain mai. ");
INSERT INTO llg_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Ribka losa lain leondia, boe ma Abraham atan nalai neni ndia neu. Boe ma, noke nae, “Ina. Tulun fee au inu fa dei.” ");
INSERT INTO llg_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Inanak ndia nataa, nae, “Minu leo ama!” Boe ma, ana nakonda lai-lai ndia uloen, de ana fee ata ndia ninu. ");
INSERT INTO llg_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Ninu basa boe ma, inanak ndia nae, “Ela au ndui oe fee ama banda onta nala linu losa lakabete.” ");
INSERT INTO llg_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Boe ma, ana neu mboꞌa oe elak neu banda la mamana nininun. De ana konda-hene lai-alai neu ndui oe neme oe matak ndia dalek mai, fo ana fee basa banda onta la linu, losa lakabete. ");
INSERT INTO llg_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Abraham atan nambadeik nee-nee, de, ana pasak matan neu inanak ndia tataon. Ana duduꞌa nae, “Inanak ia, fo Lamatuak helek ndia, do?” ");
INSERT INTO llg_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Basa onta la, linu losa lakabete. Boe ma, ata ndia haꞌi nala ndeli idu lilo mbilas esa, ma liti lilo mbilas pasan esa, de ana fee neu inanak ndia. ");
INSERT INTO llg_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Boe ma, ata ndia natane, nae, “Ina aman, nade see? Leo bisa, na, au sunggu tataak nai ina aman uman.” ");
INSERT INTO llg_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Inanak ndia nataa, nae, “Au amang nade Betuel. Au baꞌing Nahor, ma au being, Milka. ");
INSERT INTO llg_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Nai ai uman hambu mamana susungguk dai neu ama sala. Ma hambu naꞌu noꞌuk fo ama banda mala laꞌa, ma naꞌu feꞌek fo ala luꞌu leu lain.” ");
INSERT INTO llg_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Ata ndia nakatele, de ana nakaluku-nakatele neu LAMATUAK. ");
INSERT INTO llg_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Boe ma ana kokolak, nae, “Kokoak neu Lamatuak! Lamatuak soi dalak so fee au, losa au hambu atonggo akandoon ua malangga Abraham bobonggin nai ia. No leondiak, Lamatuak natudu dale malolen neu au malanggang Abraham, ma tao natetu hehelun neu au so.” ");
INSERT INTO llg_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Boe ma, inanak ndia, nalai fali lai-lai, de ana tui basa uma isi nala, hata fo mana dadik ndia so. ");
INSERT INTO llg_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Ribka naan, nade Laban. Ledoeik ana nita bua lilo-mbilas ndia, ma namanene Ribka tutuin, boe ma Laban nalai lai-lai deak neu, de neu natonggo no ata ndia, fo bei nambadeik no ndia banda onta nala, dekak no oe matak ndia. ");
INSERT INTO llg_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Boe ma, Laban kokolak nae, “Ama! LAMATUAK no ama losa ia no sodak. De, boso mambadeik muu deak ndia! Mai fo teni ai uman teu. Ai sadia mala kama so. Nanaꞌak soaneu ama banda onta nala, boe oo makadotok.” ");
INSERT INTO llg_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Basa boe ma, Abraham atan tungga Laban, de ana maso neni Betuel uman neu. Laban asa, tulun lakonda bua fufua kala, leme banda onta la lain mai. Ala leni oe boe, fo ata ndia, no hataholi nala, safe ei nala. ");
INSERT INTO llg_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Ledoeik ala tao nanaꞌak neu mei, boe ma ata ndia nae, “Ai sangga miꞌa ia so, tehuu au oke palamisi fo sangga afada au dedeꞌang esa dei.” Laban nataa nae, “Ama kokolak leo.” ");
INSERT INTO llg_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Ata ndia nae, “Au ia, ei baꞌim Abraham atan. ");
INSERT INTO llg_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","LAMATUAK fee babaꞌe-babatik makadotok neu au malanggang, losa ana namasuꞌi atu-atu. Lamatuak feen lilo-mbilas-lilo-fulak, ata touk ma inak, ma banda makadotok, fo ndia: sapi, banda onta, banda keledei, ma biꞌiae-biꞌilombo. ");
INSERT INTO llg_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Faik fo au malangga nggala sao tou sao inak lamalasi so, boe ma ina Sara bonggi fee malangga Abraham ana tou-anak esa. Dei fo ndia simbo basa malangga Abraham pusaka nala. ");
INSERT INTO llg_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","De, malangga Abraham nadenu au soo, ae, ‘O taa bole haꞌi inana Kanaꞌan, fo makasasao kana neu au anang Isak. ");
INSERT INTO llg_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Tehuu, o musi haꞌi inanak neme au bobonggi heheling mai, fo dadik neu ndia saon.’ ");
INSERT INTO llg_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Boe ma, au atane au malanggang, ae, ‘Mete ma inanak ndia, taa nau tungga au, na leobee?’ ");
INSERT INTO llg_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Au malanggang nataa nae, ‘LAMATUAK fo au tungga taa-taa Ndia hihiin-nanaun, dei fo nadenu Ndia atan neme nusa-sodak mai, soi dalak fee o, fo ela o hambu inanak neme au bobonggi heheling mai, fo ana dadik au anang saon. ");
INSERT INTO llg_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Tehuu mete ma au bobonggi nggala, taa nau mboꞌi inanak ndia, ia mai, na, o makamboꞌik muma soo ndia mai.’ ");
INSERT INTO llg_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","De, isinaak au losa oe matak ndia, boe ma au hule-haladoi nai au daleng dale, ae, ‘LAMATUAK, fo au malanggang Abraham Manetualain. Tulun soi dalak, fo ela au lalaꞌong ia, hambu buna-boak malole. Ela au atonggo ua inanak, fo sangga mana daꞌdik Isak saon. ");
INSERT INTO llg_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Manetualain, au ambadeik nai oe matak ia bifin. De inana kala leme kota mai, ndui oe nai ia. De, au oke leo iak: mete ma au kokolak ua inanak esa, ae, ‘Ina aa! Tulun makonda o uloen, fo fee au inu oe fa dei.’ ");
INSERT INTO llg_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Mete ma inanak ndia nataa, nae, ‘Ama minu leo! Ma dei fo au fee ama banda onta la linu boe.’ Ndia dadik tanda nae, inanak ndia fo Manetualain Ana hele nalan so, fo ana dadik neu au malangga muling saon! ");
INSERT INTO llg_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Au bei taa hule-haladoi ateꞌe, tehuu ina Ribka mai so, neni ndia uloen, de ana ndui oe nai oe matak ndia. Ana hene losa lain leondia, boe ma au oke, ae, ‘Ina aa, fee au inu fa dei.’ ");
INSERT INTO llg_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Boe ma, nakonda ndia uloen lai-lai, de nae, ‘Ama minu leo! Ma dei fo au fee ama banda onta nala linu boe.’ De au inu, ma au banda onta nggala linu boe. ");
INSERT INTO llg_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Boe ma, au atanen, ae, ‘Ina aman, nade see?’ Ana nataa nae, ‘Au amang nade Betuel. Au baꞌing Nahor. Ma au being Milka.’ Basa boe ma, au papaken ndeli neu idun, ma odu liti lilo-mbilas pasan esa neu liman. ");
INSERT INTO llg_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Boe ma, au akatele fo akaluku-akatele neu Lamatuak, ae, ‘Kokoa-kikiok neu Lamatuak! MANETUALAIN Ana soi dalak fee au, de losa au atonggo akandoon ua malangga Abraham bobonggin nai ia. Ma au atonggo akandoo ua inanak, fo sangga manadaꞌdik neu au malangga muling Isak saon.’ ");
INSERT INTO llg_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","De, hatematak ia, mete ma ama sala nau matudu ei susuem neu au malanggang Abraham, na, mafada no kada manggaledok. Ma mete ma taa, na, mafada no manggaleꞌdok boe, fo ela au bubuluk au musi tao hata.” ");
INSERT INTO llg_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Ata ndia kokolak nateꞌe, boe ma Laban no Betuel lae, “Mete ma LAMATUAK heti nalan leondiak so, na, ai sangga mae leobee bali. ");
INSERT INTO llg_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Ribka nai ia. Moke malan, fo muan neni ele neu leo. Ela ana dadik neu bai Abraham feto-feun, tungga hata fo LAMATUAK hetin basan so.” ");
INSERT INTO llg_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Namanene leo ndia, boe ma Abraham atan nakatele losa dae, de noke makasi neu LAMATUAK. ");
INSERT INTO llg_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Boe ma, ana haꞌi kalua bua lilo mbilas-lilo fulak, ma baloꞌa papake malole la, de ana feen neu Ribka. Ndia boe oo, ana fee Ribka naan ma inan, bua mabeli la. ");
INSERT INTO llg_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Basa ndia, boe ma Abraham atan no ndia hataholi nala, ala laꞌa feta. De ala sunggu leme ndia. Foꞌa fafain, boe ma ala foꞌa, de ata ndia nafada maumak, nae, “Au oke makamboꞌik, fo mete ma bisa, na, hatematak ia, ai sangga fali mini au malanggan miu.” ");
INSERT INTO llg_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Tehuu, Ribka naan ma inan lae, “Tehuu sangga laꞌo lai-lai tao hata? Ela Ribka ana leo no ai faik sanahulu leo ndia dei. Basa, na, mian miu leo.” ");
INSERT INTO llg_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Tehuu ata ndia nataa, nae, “Awii! Boso makalelee au! Huu LAMATUAK fali nala au so, losa au atonggo ua malangga mulik saon. De, ina sala mboꞌi ai, fo ai fali miu mafada malanggan dei.” ");
INSERT INTO llg_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Ala lataa, lae, “Leoiak! Naa, mai fo tatane takandoon neu Ribka leo. Ndia hihiin leobeek?” ");
INSERT INTO llg_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Boe ma, ala loken, de latanen, lae, “Ribka! Hatematak ia, neme kada o mai. O muu tungga memak mua hataholi la ia, do leobee?” Boe ma inanak ndia nataa, nae, “Au nau tungga leo.” ");
INSERT INTO llg_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","60","Boe ma, ala mboꞌi Ribka, ma ndia ata inan mana makaneni ndia neme kadiꞌi anan mai, de leu lo Abraham ata nala. Boe ma, ala kokolak fee Ribka babaꞌe-babatik, lae, “Ribka! Ai mamahena Manetualain Ana fee o bonggi mala makadotok, fo o numbu-sadu mala dei fo ala dadik lifu-lifuk. Ma ai mamahena boe, fo o numbu-sadu mala senggi musu la!” ");
INSERT INTO llg_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Basa ndia, boe ma Ribka no ndia ata ina nala, lafafaꞌu sila baloꞌa nala, de ala saꞌe banda onta, ma ala laꞌo tutik, tungga Abraham ata nala. ");
INSERT INTO llg_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Isak leo nai dae Negeb. Faik ndia, bei fo ana fali neme oe mata Beer Lahai Roi mai. ");
INSERT INTO llg_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Ledo bobok esa, ana kalua neme uma teman mai, fo ana lalaꞌok sangga ani. Ana botik matan, boe ma nita banda onta la mai. ");
INSERT INTO llg_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ledoeik Ribka nita Isak, de ana konda lai-lai neme ndia banda ontan mai. ");
INSERT INTO llg_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Boe ma, natane Abraham atan, nae, “Ama! Touk ndia fo mana laꞌok neme ele mai ndia, see ndia?” Ata ndia nataa, nae, “Au malangga muling ndindia.” Boe ma, Ribka haꞌi nala lafa-anan, de ana lalaan neu matan. ");
INSERT INTO llg_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Ata ndia nafada basan neu Isak. ");
INSERT INTO llg_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Boe ma, Isak no Ribka leni inan uma teman dale leu, de dua sala ala sao. Isak sue Ribka nalan seli, de taa dale hedi inan mamaten so. ");
INSERT INTO llg_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham sao seluk no inak esa, nade Ketura. ");
INSERT INTO llg_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ketura bonggi feen, ana kala nade: Simran, Yoksan, Medan, Midian, Isbak, ma Sua. ");
INSERT INTO llg_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yoksan ana nala, Seba no Dedan. Dedan numbu-saꞌdu nala, sila: hataholi Asyur, hataholi Letus, ma hataholi Leum. ");
INSERT INTO llg_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midian ana nala: Efa, Efer, Henok, Abida ma Eldaa. Sila basa sala Ketura numbu-sadu nala. ");
INSERT INTO llg_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","6","Faik fo Abraham bei nasoda, ana baꞌe fee Hagar no Ketura ana nala, esa-esako no ndia hatan. Basa de nadenu sala, fo ala leu leo lai dae Kanaꞌan boboan dulu, fo ela ala dook lo anan Isak. Tehuu basa ndia hata pusaka nala, ana feen neu Isak. ");
INSERT INTO llg_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Abraham maten neu ndia teun natun esa hitu hulu lima so. ");
INSERT INTO llg_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","10","Boe ma, ndia ana nala Isak no Ismael latoin neu lua Makpela, fo dekak no Mamre. Makahulun Abraham hasa nala osi ndia neme hataholi Het, fo ndia Sohar anan, Efron. Makahulun, sila latoi Sara neme luak ndia boe. ");
INSERT INTO llg_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Abraham mate boe ma, Manetualain fee babaꞌe-babatik neu Isak, losa nasoda no mole-dame. Faik ndia, Isak ana leo dekak no oe matak, nade Beer Lahai Roi. ");
INSERT INTO llg_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ia Ismael tutuin. Ndia ndia, Abraham no sao mulin Hagar anan. Hagar ndia, na, Sara atan neme Masir mai. ");
INSERT INTO llg_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","16","Ismael ana nala touk sanahulu dua. Ia sila nade nala betungga neme kaꞌak mai losa mulik, sila ndia: Nebayot, Kedar, Adbeel, Mibsam, Misma, Duma, Masa, Hadad, Tema, Yetur, Nafis, ma Kedma. Kakana kala sila, dadik bei-bai neu hataholi nusak sanahulu dua, esa-esako no ndia nusa hehelin. Ala foi nusa kala sila, esa-esak tungga sila bei-baꞌi nala naden. ");
INSERT INTO llg_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismael mate neu teun natun esa telu hulu hitu so. ");
INSERT INTO llg_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Tehuu ndia numbu-sadu nala, esa musu no esa. Boe ma, ala leo latanggenggela mulai neme Hawila losa Syur, fo natoo no nusa Masir, nakandoo losa Asyur. ");
INSERT INTO llg_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Ia Abraham anan Isak tutuin. ");
INSERT INTO llg_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Faik fo Isak ana sao Ribka, Isak teun haa hulu. Ribka aman, Betuel, ma naan, Laban. Sila ndia, hataholi Aram leme Padan Aram mai. ");
INSERT INTO llg_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Ribka taa hambu anak. Huu ndia, de Isak hule-haladoi neu Manetualain, fo noke Ana soi Ribka ana manan. Manetualain namanene ndia huhule-haladoin, boe ma Ribka nailu. ");
INSERT INTO llg_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Naa te, ana nailu kakanak dua. Tehuu kakana kala sila, lambue lafitik lakandoo lai inan tein dale. Boe ma, Ribka natatanek nai dalen dale, nae, “Hatina de kakana kadua kala leoiak?” Boe ma, ana natane LAMATUAK. ");
INSERT INTO llg_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","De, LAMATUAK nataa, nae, “Nai O teim dale, hambu hataholi nusak dua, ala musu lakandoo. Dei fo mulik balakain, lena heni kaꞌak. Ma kaꞌak ana ue-leꞌdi fee mulik.” ");
INSERT INTO llg_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Ledoeik fain losa, boe ma Ribka bonggi nala ana tou-anak kaduak. ");
INSERT INTO llg_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Ana kaꞌak aon mbilas, ma basa ao-inan kabuluk. Huu ndia, de ala foin nade, Esau (hihii leo dedeꞌa feꞌek, fo ndandaan nae ‘kabuluk’). ");
INSERT INTO llg_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Basa ndia, bei fo fadik kalua. Tehuu, ana toꞌu kaꞌan ei tingga dean. Huu ndia, de ala foin nade, Yakob (hihii leo, dedeꞌa deꞌe feꞌek fo ndandaan nae, ‘toꞌu ei tinggadeak’). Faik fo bonggi dua sala, Isak teun nee hulu so. ");
INSERT INTO llg_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Faik fo kakana kadua kala sila inahuu mai, Esau dadik mana sombu banda fo ana seli. Ana nahiik leo nai nula dale. Tehuu Yakob ndia, mana neeneek, ma nahiik nahani kada uma. ");
INSERT INTO llg_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isak hihiin naꞌa mbaa banda fui. Huu ndia, de ana sue Esau lena. Tehuu, Ribka ana sue Yakob lena. ");
INSERT INTO llg_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Laꞌi esa, ledoeik Yakob nasu fufue, tehuu Esau bei fo fali neme sombu banda fui mai. Ana manggu ma ana ndoe nalan seli. ");
INSERT INTO llg_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Boe ma, noke Yakob nae, “Fadi aa! Fee o fufue mbilam nana nasuk manai ulek ndia fa dei, fo au uꞌa dei! Huu au ndoe alan seli.” (Huu ndia, loken na lae, Edom, fo hihii leo dedeꞌa deꞌe feꞌek fo ndandaan nae ‘mbilas’.) ");
INSERT INTO llg_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Boe ma, Yakob nataa nae, “Hei, kaꞌa. Tehuu fee au, kaꞌa hak kaꞌan neu au dei!” ");
INSERT INTO llg_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau nataa, nae, “Sokolaa hak kaꞌak ndia neu naa! O soam leo. Huu au ndoe alan seli ia so. O soꞌde masiꞌa fufue ndia fo munin mai leo, huu au asuu uꞌa ia so.” ");
INSERT INTO llg_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Tehuu Yakob kokolak bali, nae, “Kaꞌa mahani dei! Kaꞌa soo dei, mae, kaꞌa fee au hak kaꞌak ndia so.” Boe ma, Esau soo leondiak. ");
INSERT INTO llg_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Basa de Yakob sode feen fufue nana nasuk ndia, ma loti, de Esau naꞌa-ninu. Basa boe ma, ana foꞌa laꞌo. No leondiak, Esau fee hiak heni, ndia hak kaꞌan. ");
INSERT INTO llg_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Laꞌi esa, hambu fai ndoen ana seli, nai nusak ndia, sama leo fai ndoen neu lelek fo Abraham bei kasodan. De, Isak neu noke Abimelek, fo, hataholi Filistin manen, suek ana bisa nakamboꞌi kana, bisa leo nai Gerar. ");
INSERT INTO llg_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Ana tao leondiak, huu LAMATUAK natudu Mataon neun, nae, “O boso muni Masir muu. Dei fo au atudu o mamana feꞌek. ");
INSERT INTO llg_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","4","Mete ma o leo tataak nai mamanak ndia, na, dei fo Au sama-sama ua o, ma fee o babaꞌe-babatik mata-matak. Dei fo Au tao o numbu-sadu mala, boe lamanoꞌu, sama leo nduuk malai lalai. Ma Au fee o, ma o numbu-sadu mala, basa dae babaꞌek ia no nusan. Neme o numbu-sadu mala mai, dei fo basa hataholi nusa kala malai daebafok, ala hambu babaꞌe-babatik. No leondiak, Au tao atetu Au hehelung neu o amam, Abraham. ");
INSERT INTO llg_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Au tao basa ia, huu o amam tungga Au hihii-nanaung, Au palendang ma Au heti-heung so.” ");
INSERT INTO llg_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","De Isak leo tataak nai Gerar. ");
INSERT INTO llg_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Ribka ndia manaꞌa hiak. De, ledoeik hataholi la malai ndia litan, boe ma ala latatanek laꞌeneu ndia. Tehuu, Isak nataa, nae, “Ribka ndia, na, au fetong.” Ana bii, naafo ana manaku nae ndia saon, na, dei fo hataholi sila tao lisan, fo ala haꞌi lala Ribka. ");
INSERT INTO llg_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Isak leo doo-doo neme ele, boe ma laꞌi esa, manek titilo nesik jenela, de nita Isak no Ribka, ala laholuk ma laiduk. ");
INSERT INTO llg_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Boe ma, ana nadenu hataholi la leu loke lala Isak, de ana kasilanggan nae, “Isak! Au bubuluk no teteben so, huu inak ndia, memak o saom! Tehuu, hatina de o mae, o fetom ndia?” Boe ma, Isak nataa, nae, “Leoiak, ama! Au bii, naafo au ae, au saong ndia, boe ma dei fo hataholi la tao lisa au.” ");
INSERT INTO llg_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Boe ma, manek nae, “Mete ma hambu hataholi nai ia, sunggu no o saom, na, neu ko o soli salak neu ai! Hatina de o tao leondiak neu ai?” ");
INSERT INTO llg_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Basa ndia, boe ma Abimelek fee nasanenedak no hala belak neu ndia lau-inggu nala, nae, “Ei basa-nggei masanenedak neulalau! Ei see ndia mambalani tao hataholi ia, do saon, na, dei fo au huku akamaten.” ");
INSERT INTO llg_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Faik ndia, Isak sele-nggali nai nusak ndia boe. De ana hambu falik buna-boan laꞌi natun esa, huu LAMATUAK abaꞌe-babatik. ");
INSERT INTO llg_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Ndia suꞌin ana boe tamba nakandoo, losa ana namasuꞌi atu-atu. ");
INSERT INTO llg_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Ndia sapi nala ma biꞌiae-biꞌilombo nala, tamba lamanoꞌu. Ndia hataholi nala tamba lamanoꞌu boe, losa hataholi Filistin asa, ala dale hedin. ");
INSERT INTO llg_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Makahulun, Isak aman Abraham asa, kali oe matak noꞌuk so. Tehuu hataholi Filistin asa, leu lakadofu basa oe mata kala sila lenik dae. ");
INSERT INTO llg_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Boe ma, mane Abimelek kokolak no Isak, nae, “Isak! Malolenak o laꞌo ela nusak ia leo. Huu o koasam lena heni ai so.” ");
INSERT INTO llg_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Basa ndia, boe ma Isak ana heok neme ndia mai, de neu leo seluk nai Gerar bafan. ");
INSERT INTO llg_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Boe ma, ana kali seluk oe mata kala, fo ala lakadofu kala sila so. Ma ana foi oe mata kala sila, tungga nade kala, fo aman ana foi sala so. ");
INSERT INTO llg_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Isak ata nala, kali oe matak nai Gerar bafan ndia, de ala kali laꞌe oe matan, de nasambumbulak deak mai. ");
INSERT INTO llg_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Manahoo Gerar asa, ala latoka lo Isak manahoo nala, huu oe ndia. Ala lae, “Ia, ai oen!” Huu ndia, de Isak foi oe matak ndia, nade Esek, fo ndandaan nae, ‘latoka’. ");
INSERT INTO llg_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Basa ndia, de Isak hataholi nala, kali lala oe matak esa bali. Tehuu, ala latoka seluk, huu oe matak ndia. Huu ndia, de Isak foi oe matak ndia, naꞌde, Sitna (fo ndandaan ‘lahuu’). ");
INSERT INTO llg_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Basa ndia, boe ma ana laꞌo ela mamanak ndia, de ana kali oe mata feꞌek esa bali. Oek ia, ala taa latoka so. Huu ndia, de Isak foi oe matak ndia, nade, Rehobot fo ndandaan nae, ‘mamana loak’. Ma ana kokolak nae, “Hatematak ia, Lamatuak fee ita leo nai dae loak. Boe ma, nai ia, bei o ita boe mamanoꞌu.” ");
INSERT INTO llg_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Neme ndia mai, boe ma Isak asa, ala laꞌo bali, fo sangga leu leo lai Beer Syeba. ");
INSERT INTO llg_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Leꞌodaen ndia, boe ma LAMATUAK natudu Mataon neu ndia, de Ana kokolak nae, “Isak! Au ia, o amam Abraham Manetualain. De, o boso bii, huu Au anea o. Dei fo Au fee o babaꞌa-babatik. Ma o numbu-sadu mala, dei fo ala boe lamanoꞌu. Au tao leoiak, huu Au hehelung neu o amam.” ");
INSERT INTO llg_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Boe ma, Isak nakatotodok batu, de nambadedei mei tunu-hotuk neu ndia. Boe ma, noke makasi neu LAMATUAK nai mamanak ndia. Ana leo neme ndia, ma hataholi nala, mulai kali oe matak bali. ");
INSERT INTO llg_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Faik ndia mane Abimelek neme Gerar mai. Ana sama-sama no ndia nonoon, Ahusat, ma ndia malangga musun, Fikol, mai latonggo lo Isak. ");
INSERT INTO llg_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Boe ma, Isak natane, nae, “Ama manek! Makahulun, ei husi kalua heni ai so. De, hatematak ia, ei sangga mai tao hata bali?” ");
INSERT INTO llg_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Boe ma, ala lataa lae, “Leoiak! Hatematak ia ai bubuluk mae, Lamatuak nanea o. Huu ndia, de ai duduꞌa mae, malolenak ita dua nggata tao heheluk leoiak: o soo mae, ");
INSERT INTO llg_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","ei taa tao manggalauk neu ai, sama leo ai taa tao manggalauk neu ei. Memak ai dalen malole neu ei. Huu ndia, de fain ei kalua no mole-dame neme ai daen mai. Ai bubuluk tetebes, LAMATUAK ndia fee babaꞌe-babatik neu ei.” ");
INSERT INTO llg_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Boe ma, Isak tao feta fee sala, de basa sala laꞌa-linu noꞌu. ");
INSERT INTO llg_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Foꞌa fafain boe ma, ala lasook. Basa de Isak mboꞌi sala, ma ala laꞌo lo mole-dame. ");
INSERT INTO llg_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Faik ndia, Isak hataholi mana tao ue-ledi nala, mai lafada laꞌeneu ala kali oe matak, lae, “Ama! Ai hambu oe so.” ");
INSERT INTO llg_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Boe ma, Isak foi oe matak ndia nade, Syeba, fo ndandaan nae, ‘soo’. De ala foi kota ia, nade Beer Syeba, losa hatematak ia. ");
INSERT INTO llg_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Faik fo Esau teun haa hulu, boe ma ana sao inanak dua leme leo Het mai. Esak ndia, Beeri anan, nade Yudit. Ma esa bali, Elon anan, nade Basmat. ");
INSERT INTO llg_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Ina kadua kala sila, tao lala Isak no Ribka dale nala hedis. ");
INSERT INTO llg_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Faik fo Isak namalasi, ma matan kelembuak nalan seli so, de noke ana kaꞌan, fo ana suen lena, nae, “Sau! O mai ia dei!” Esau nataa nae, “Hatina, ama?” ");
INSERT INTO llg_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isak nafadan nae, “Leoiak! Au ia, amalasi so. Au taa bubuluk faik bee fo au mate. ");
INSERT INTO llg_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","De, muu haꞌi mala o manala mala, fo muu sombu fee au banda fui esa dei. ");
INSERT INTO llg_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Basa na, muu tunu-nasu malan malada-malada, tungga au hihiing, fo munin mai au. Dei fo au uꞌa basa, na, bei fo au fee o babaꞌe-babatik. Mete ma au fee basa babaꞌe-babatik na, ela au mate boe oo, malole ndia.” ");
INSERT INTO llg_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Basa boe ma, Esau kalua neu sombu banda. Tehuu Ribka namanene Isak kokolan ndia boe. ");
INSERT INTO llg_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Boe ma, Ribka neu nafada Yakob, nae, “Wei! Ako aa! O mamanene neulalau! Isinaak bei fo, au amanene amam kokolak no Esau, leoiak: ");
INSERT INTO llg_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘O muu sombu mala banda fui, fo tunu-nasu malan malada-malada, fee au. Mete ma au uꞌa basa so, na dei fo au fee o babaꞌe-babatik, neu LAMATUAK matan.’ ");
INSERT INTO llg_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","De, o mamanene neulalau! Tungga tebe-tebe mua au palendang ia. ");
INSERT INTO llg_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Hatematak ia, o muni ita mamana biꞌiae-biꞌilombo nala muu, fo hele mala biꞌiae mandaak maao dua. Basa na, hala sala, fo haꞌi mala mbaa nala, de muni sala mai au. Dei fo au tunu-nasun, tungga amam hihiin. ");
INSERT INTO llg_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Mete ma au tunu-nasu ala sala, na, o muni fee amam, fo ana naꞌa. Basa, na, bei fo ana fee o babaꞌe-babatik dei, bei fo ana mate. No leondiak, o ndia hambu babaꞌe-babatik ndia. De, taa ndia o kaꞌam.” ");
INSERT INTO llg_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Tehuu, Yakob kokolak no inan, nae, “Ina aa! Dedeꞌan na, kaꞌa Sau aon kabuluk, tehuu au, na momoik! ");
INSERT INTO llg_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Naafo dei fo ama nafaloe laꞌe au aong, de ana bubuluk memak au kedin. Boe ma, ana sumba-soo au!” ");
INSERT INTO llg_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Tehuu inan nataa, nae, “Ako aa! O boso bii. Fee basan mai au, dei fo au heti ndia. Mete ma amam sumba-soo o, na dei fo au lemba alan! Hatematak ia, o muu haꞌi mala biꞌiae kala sila leo.” ");
INSERT INTO llg_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Basa ndia, de Yakob neu hele nala biꞌiae kala sila, boe ma ana hala sala, de neni sala neu inan. Ribka tunu-nasun tungga Isak hihiin, ");
INSERT INTO llg_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","ma ana haꞌi nala Esau baloꞌa papake neulaun, de ana papaken neu Yakob. ");
INSERT INTO llg_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Ndia boe oo, ana mboti Yakob liman, ma lesuhaꞌin, pake biꞌiaek ndia bulun. ");
INSERT INTO llg_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Boe ma, ana fee Yakob nanaꞌa malada ndia, ma loti fo ana tao nalak ndia. ");
INSERT INTO llg_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","De Yakob neni nanaꞌak ndia fee aman. Ana kokolak nae, “Ama! Au mai ia so.” Isak nataa, nae, “Heeh? Tehuu, o ia see?” ");
INSERT INTO llg_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Tehuu Yakob nae, “Au ia, ama ana kaꞌan, Esau! Au tao tungga hata fo ama isinaak madenu au ndia. Foꞌa fo muꞌa leo. Au tunu-nasu ala mbaa, fo au humu alan neme nula dale. Muꞌa basa na, ama fee au babaꞌe-babatik leo!” ");
INSERT INTO llg_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Boe ma, Isak kokolak nae, “O ia ana seli, maa! Huu o bisa hambu banda lai-lai leondiak?” Yakob nataa, nae, “Au hambu ia, huu LAMATUAK fo ama nakaluku-nakatele neun ndia, tulun au.” ");
INSERT INTO llg_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Boe ma, Isak ana noke Yakob, nae, “O mai deka-deka, fo au afaloe sudik o! O ia tetebes Esau, do?” ");
INSERT INTO llg_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","De Yakob neu deka-deka no aman, boe ma toulasik mulai nafaloen. De ana kokolak nae, “Halak ia, sama leo Yakob halan! Tehuu limak ia, Esau liman.” ");
INSERT INTO llg_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Tehuu, Isak taa bubuluk Yakob ndindia, huu liman kabuluk leo Esau. Huu faik fo ana sangga fee babaꞌe-babatik neu Yakob, ");
INSERT INTO llg_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","ana natane seluk bali, nae, “O ia, tetebes Esau, do?” Yakob nataa, nae, “Tetebes, ama!” ");
INSERT INTO llg_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Basa boe ma, Isak kokolak nae, “Loo mbaa la sila mai, fo au sangga uꞌa. Basa, na, au fee obabaꞌe-babatik.” Boe ma, Yakob loo mbaa neu ndia, ma ana fee anggol oek fo ninu. ");
INSERT INTO llg_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Basa ndia, boe ma aman kokolak nae, “Ana nggo ei! Mai deka-deka mai ia, fo idu au.” ");
INSERT INTO llg_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Leꞌdoeik Yakob neu deka-deka de ana iꞌdun, boe ma Isak hae laꞌe Esau baloꞌan boon. Boe ma, ana kokolak fee babaꞌe-babatik neu Yakob nae, “Au anang boon, sama leo moo naꞌu fo LAMATUAK feebabaꞌe-babatik neu ndia so. ");
INSERT INTO llg_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Ela Manetualain nakonda dinis neme lalai mai, fo ana tao o osi mala, dadik dae mamina! Ela Ana fee o hade makadotok, ma anggol boak henu-henuk. ");
INSERT INTO llg_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Hataholi nusa kala ala dadik neu o atam, Ma leo-leo la lakatele fee hadak neu o. O palenda basa o tolanoo mala, ma ala sendek lunggulangga nala, lai o matam. See ana sumba-soo o, na, sila boe oo ala hambu sumba-sook. Ma see fee o babaꞌe-babatik, na, sila boe oo ala hambu babaꞌe-babatik. ");
INSERT INTO llg_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Ledoeik Isak fee babaꞌe-babatik nateꞌe, de Yakob bei fo kalua laꞌo ela aman, boe ma kaꞌan Esau fali neni ndia banda sosombu nalan. ");
INSERT INTO llg_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Boe ma, ana tunu-nasu, de neni fee aman. Ana kokolak nae, “Ama! Foꞌa fo muꞌa leo. Huu au tunu-nasu ala mbaa, fo au sombu alak ndia so. Muꞌa basa, na, ama fee au babaꞌe-babatik leo.” ");
INSERT INTO llg_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Boe ma, Isak namanggonggoak, de natane nae, “Heeh? Tehuu o ia, see bali?” Esau nataa, nae, “Au ia, Sau! Ama ana ulun.” ");
INSERT INTO llg_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Boe ma, Isak mulai dele, de natane, nae, “Mete ma leondiak, na, isinaak ndia, see neni fee au mbaa ndia, de au uꞌa so? Basa de au feen babaꞌe-babatik. De taa bisa feꞌa heni babaꞌe-babatik ndia so bali.” ");
INSERT INTO llg_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Esau namanene aman kokolak nae leondia, boe ma dalen hedis, de nakaleleu, ma ana kokolak natingga, nae, “Awii! Ama aa! Fee au babaꞌe-babatik boe, ama!” ");
INSERT INTO llg_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Boe ma, Isak nae, “Faꞌdim ana mai keꞌdi nala au, de namanaꞌo neni obabaꞌe-babatim so.” ");
INSERT INTO llg_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Boe ma, Esau kokolak bali nae, “Ana kedi nala au laꞌi dua ndia so. Sososan ana kedi nala, au hak kaꞌang. De hatematak ia, ana kedi bali nala, au babaꞌe-babating. Huu ndia, de nade ‘Yakob’ (fo ndandaan nae, ‘toꞌu ei tinggadean’, ma ndandaan feꞌen nae, ‘mana masapepekok’). Tehuu, ama bei kababaꞌe-babatik seluk, fo fee au, do?” ");
INSERT INTO llg_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isak nataa, nae, “Au soꞌu alan ana dadik neu o malanggan. Ma basa ndia tolanoo nala, ala dadik ndia ata nala so. Au feen hade makadotok, ma anggol oek henu-henuk. De, ana nggo ei! Hatematak ia, bei hambu babaꞌe-babatik hata bali, fo fee o?” ");
INSERT INTO llg_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Namanene leo ndia, boe ma Esau nambue kokoe nakandoo aman, nae, “Ama babaꞌe-babatin kada esak, do? Neu ko ama bei bisa sangga fee au babaꞌe-babati feꞌek. Mae kada babaꞌe-babatik kadiꞌik boe oo, ndia malole!” Boe ma ana mulai namatani bali. ");
INSERT INTO llg_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Basa ndia, boe ma Isak nataa bala nae, “O soꞌdam dei fo dook neme osi dae mamina mai, huu taa hambu dinis konda neme lalai mai, fo ana tao nakataba dae. ");
INSERT INTO llg_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","O tafam dei fo tao nasoda o. Tehuu, mae leobee boe oo, o dadik ata neu fadim. Kada mete ma o bisa laban ndia, na, bei fo o makamboꞌik muma ndia liman mai.” ");
INSERT INTO llg_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esau namanasa Yakob nalan seli, huu ndia fadin namoa nala ndia babaꞌe-babatin. Tehuu, ana duduꞌa nae, “Taa dook so bali, tehuu ama mate. De, kaꞌda mahani. Dei fo basa bebeꞌen, na, au tao isan!” ");
INSERT INTO llg_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","43","Ledoeik Ribka namanene Esau dala duduꞌan ndia, boe ma ana noke Yakob, de nae, “Mamanene neulalau! Kaꞌam sangga bala ndia dale hedin, fo sangga tao nisa o. De, o malai lai-lai muni toꞌom Laban nai Haran muu. ");
INSERT INTO llg_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Leo mala dook fa nai ele, losa kaꞌam tana namanasa o so bali. ");
INSERT INTO llg_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Mete ma ana nafalende heni hata fo o tataom neu ndia, dei fo au adenu hataholi leu loke falik o. Huu au taa nau au anang dua sala, ala mopo nai faik esa.” ");
INSERT INTO llg_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Boe ma, Ribka kokolak no Isak, nae, “Au mbela ua Esau saon hataholi Het asa sila! Mete ma Yakob sao nala inana Het bali, na, malolenak kaꞌda au mate leo.” ");
INSERT INTO llg_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Boe ma, Isak noke Yakob, boe ma ana feen babaꞌe-babatik ma nanolin, nae, “Mamanene neulalau! O boso sao inana Kanaꞌan. ");
INSERT INTO llg_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Tehuu o muni Padan Aram muu, nai baꞌim Betuel uman. O muu sao mala toꞌom Laban ana inanan esa. ");
INSERT INTO llg_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Manetualain Mana Koasa Manai Lain fee babaꞌe-babatik neu o, fo o umbu-ana mala ala boe lamanoꞌu, ma o numbu-saꞌdu mala dadik hataholi nusak fo ana seli. ");
INSERT INTO llg_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Manetualain hehelun neu Abraham ana konda neu o numbu-saꞌdu mala. O maena dae fo Manetualain Ana helu feen neu Abraham so.” ");
INSERT INTO llg_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Kokolak basa leo ndia, boe ma Isak mboꞌi Yakob neni Padan Aram neu, neni toꞌon Laban ma baꞌin Betuel uman neu. ");
INSERT INTO llg_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esau namanene lae Isak fee Yakob babaꞌe-babatik so, ma ana kaꞌin taa bole sao inana Kanaꞌan. Ndia boe oo namanene lae, ndia aman nadenu fadin neu sao toꞌon ana inanan esa, nai Padan Aram. ");
INSERT INTO llg_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Basa de Yakob namanene aman ma inan palendan, de ana laꞌo neni Padan Aram neu. ");
INSERT INTO llg_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","No leondiak, Esau boe oo bubuluk nae, aman taa hii sao nala fo hataholi Kanaꞌan asa. ");
INSERT INTO llg_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","De, Esau neni ama inahuun Ismael neu, boe ma ana sao bali nala, Ismael anan, nade Mahalat. Mahalat ndia, na, Nebayot feton. ");
INSERT INTO llg_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Boe ma, Yakob laꞌo ela Beer Syeba, de sangga neni Haran neu. ");
INSERT INTO llg_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Ledoeik ledo tesa, boe ma ana losa mamanak esa, de ana sunggu neu ndia. Ledoeik ana sangga sunggu, ana haꞌi nala batu esa, de ana taon daꞌdik neu kailunu. ");
INSERT INTO llg_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Leꞌodaen ndia, ana nalameꞌi, nita edak esa nambadeik neu dae, ma mbedan losa lalai. Boe ma, Manetualain ata nala leme nusa-sodak mai, ala konda-hene edak ndia. ");
INSERT INTO llg_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Nai meꞌis ndia, Yakob nita LAMATUAK nambadeik nai ndia boboan, boe ma Ana kokolak, nae, “Au ia LAMATUAK, fo o baꞌim Abraham no amam Isak Manetualain. Dei fo Au fee o ma o numbu-sadu mala dae ia. ");
INSERT INTO llg_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Dei fo o numbu-sdu mala noꞌun leo afu ia. Ma dei fo ala latanggenggelak leni sudi bee leu, nai basa mamanak lalaꞌen. Neme o numbu-saꞌdu mala mai, dei fo hataholi nusak noꞌu kala lai daebafok, ala hambu babaꞌe-babatik. ");
INSERT INTO llg_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Masanenedak neulalau! O muni sudi bee muu, na, Au sama-sama ua o, ma Au anea o. Dei fo Au ua falik o muni nusak ia mai. Au taa ela o mesang. Ma dei fo Au tao atetu basa Au hehelung neu o.” ");
INSERT INTO llg_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Yakob foꞌa leondia, boe ma nae, “Bei fo au bubuluk ae, LAMATUAK nai ia boe!” ");
INSERT INTO llg_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Ma ana bii, de ana duduꞌa, nae, “Wei! Mamanak ia, tao nala au aong mumulu. Neu ko Manetualain uman nai ia! Ma ia, lelesun neni nusa-sodak neu.” ");
INSERT INTO llg_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Foꞌa fafain, boe ma Yakob foꞌa, de, ana haꞌi nala batu fo ana paken dadik kailunu ndia, nambadedei kana fo ana dadik neu tanda nasanenedak. Boe ma, ana diꞌa mina neu batu ndia lain, de ana nakaluku-nakatele neu Lamatuak. ");
INSERT INTO llg_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ana foi mamanak ndia, nade Betel, fo ndandaan nae, ‘Lamatuak uman’. (Makahulun, mamanak ndia, nade Lus.) ");
INSERT INTO llg_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Basa ndia, boe ma Yakob soo, nae, “Mete ma Manetualain sama-sama no au, ma nanea au nai au dalang ia, ma Ana fee au nanaꞌak ma baloꞌa papakek, ");
INSERT INTO llg_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","losa au fali ua sodak, na, dei fo Lamatuak dadik neu au Manetualaing. ");
INSERT INTO llg_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Batu fo au ambadedein ia, dadik mamana nakaluku-nakatelek neu Manetualain. Ma basa hata fo Manetualain fee au, dei fo au fee fali kasa babaꞌek esa neme sanahulu mai.” ");
INSERT INTO llg_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Basa ndia, boe ma Yakob laꞌo nakandoo neni dulu neu. ");
INSERT INTO llg_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Faik esa, nita oe matak esa deka nai nggolok esa. Deka-deka nai ndia, hambu biꞌiaek-biꞌilombo bubuak telu, lahani fo bisa linu oe nai ndia. Tehuu, hambu batu inahuuk esa nana tatanak neu oe matak ndia. ");
INSERT INTO llg_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Tungga natetemek, na, mete ma basa biꞌiae-biꞌilombo la lakabubua so, na bei fo manahoo la koꞌo heok batu ndia, fo ala ndui oe fee banda la sila linu. Linu lateꞌe, na, ala tatana seluk batu ndia neu oe matak bali. ");
INSERT INTO llg_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Boe ma, Yakob neu natane manahoo la sila nae, “Wei! Ei mima bee mai?” Ala lataa lae, “Ai ia, mima nggolo Haran ia mai.” ");
INSERT INTO llg_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Yakob natane bali, nae, “Ei malelak au toꞌong Laban, do? Ndia ndia, Nahor anan.” Ala lataa, lae, “Ai malela kana.” ");
INSERT INTO llg_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Yakob natane bali, nae, “Ndia bei kasodak, do?” Ala lataa lae, “Toulasik bei kasodak ma neulauk. Hena suli huu, ndia ana inanan ndia ele, nade, Rahel, hoo neni ndia biꞌiae-biꞌilombo nala mai fo linu oe lai ia. O mahani kada ia leo.” ");
INSERT INTO llg_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Yakob kokolak bali nae, “Hatematak ia, ledo bei madema. De, malolenak banda la bee lakabubua lai ia so, na, ei fee sala linu leo. Basa, na, ei hoo mini sala leni mok leu, fo laꞌa naꞌu bali.” ");
INSERT INTO llg_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Tehuu lae, “Wei, taa bisa leondiak! Ai musi mahani basa manahoo la, lo sila banda nala lakabubua lai ia dei. Bei fo ai koꞌo heok batu ndia, fo fee banda la linu.” ");
INSERT INTO llg_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Yakob bei kola-kola no hataholi la sila, tehuu Rahel losa no aman biꞌiae-biꞌilombo nala. Ndia ndia, nateme hoo banda la sila. ");
INSERT INTO llg_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Ledoeik Yakob nita Rahel, no ndia biꞌiae-biꞌilombo nala, de ana neu koꞌo heok oe matak ndia tatanan. Boe ma, ana fee toꞌon banda nala linu. ");
INSERT INTO llg_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Yakob neu holu nala Rahel, de ana idun, ma namatani. ");
INSERT INTO llg_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Ana tui Rahel, nae, “Fadi aa! Au ia, o amam fetom Ribka anan.” Boe ma, Rahel nalai fali, fo neu nafada aman. ");
INSERT INTO llg_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Laban namanene Rahel tutuin laꞌeneu Yakob, fo feton Ribka anan ndia, boe ma ana nalai neu solu kana. Ala latonggo leondia, boe ma Laban holu nalan de ana iꞌdu, boe ma no Yakob neni uma neu. Nai ele, Yakob ana tui basan neu Laban. ");
INSERT INTO llg_vpl VALUES ("GN29_14a","002_29_14a","GEN","29","14a","14a","Boe ma, Laban kokolak nae, “Memak tetebes! Ita dua nggata bobonggik!” ");
INSERT INTO llg_vpl VALUES ("GN29_14b","002_29_14b","GEN","29","14b","14b","Faik fo Yakob leo no sala losa bulak esa, ");
INSERT INTO llg_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","boe ma Laban kokolak non, nae, “Leoiak, Ako! Au taa nau o tao ues hiak fee au, huu ita dua nggata bobonggik. O moke o nggadim baꞌu bee?” ");
INSERT INTO llg_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Na, Laban ndia, ana inana nala dua. Kaak nade Lea, ma fadik nade Rahel. ");
INSERT INTO llg_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea matan mana mamalek. Tehuu, Rahel matan manaꞌa hiak, ma aon lolen seli. ");
INSERT INTO llg_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yakob sue Rahel. De, ana nataa Laban nae, “Au tao ue-ledis fee toꞌo teuk hitu, sadi toꞌo makasasaok au ua Rahel.” ");
INSERT INTO llg_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Boe ma, Laban nataa, nae, “Au akaheik! Neme kada au akasasaok Rahel no hataholi feꞌek, na, malolenak no o, fo bobonggi hehelik! De o leo kada ia, fo tao ue-leꞌdis fee au.” ");
INSERT INTO llg_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Boe ma, Yakob tao ues teuk hitu, fo bisa ana hambu Rahel. Tehuu, ana sue mate-mate no Rahel, de teuk hitu ndia, nameda sama leo faik hidak. ");
INSERT INTO llg_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Seli teuk hitu, boe ma Yakob nasanenedak neu Laban, nae, “Toꞌo! Au tao ues fee toꞌo teuk hitu ia so, de hatematak ia makasasaok au ua Rahel leo.” ");
INSERT INTO llg_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Boe ma, Laban tao feta kabin, de ana hoka basa hataholi la malai nusak ndia. ");
INSERT INTO llg_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","27","Leꞌodaen ndia, Laban taa fee Rahel, tehuu ana fee Lea maso neni Yakob uma teman dale neu. De, Yakob ana sunggu non. Foꞌa boe ma, bei fo Yakob bubuluk nae, ndia sao Lea. Boe ma, Yakob taa simbok Laban tataon, de nae, “Hatina de toꞌo maeok au? Au tao ues mbilu-mbuse teuk hitu fo au hambu Rahel! Tehuu hatina de toꞌo nggatin neu Lea?” Boe ma, Laban nataa, nae, “O boso mamanasa leondia! Tungga ai hadan nai ia, na, fadik taa bole sao nakahuluk neme kaꞌak mai. De malolenak kada leoiak! O mahani losa feta kabin ia, basa faik hitu dei. Bei fo o hambu Rahel, sadi o tao ues fee au teuk hitu bali.” Boe Laban fee ndia ata inan esa, nade Silpa, fo ana dadik neu Lea atan. ");
INSERT INTO llg_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yakob nakaheik. Huu ndia, de basa feta faik kahitun, bei fo Laban nakasasaok Rahel no Yakob. ");
INSERT INTO llg_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Laban ana fee ndia ata inan esa bali, nade Bilha, fo ana dadik Rahel atan. ");
INSERT INTO llg_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Boe ma, Yakob neu sunggu no Rahel. Ana sue Rahel lena heni Lea. De ana tao ues tamba teuk hitu fee ndia aliaman. ");
INSERT INTO llg_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Tehuu LAMATUAK bubuluk Yakob sue Rahel lena Lea, de Ana mboꞌi Lea bonggi. Tehuu Rahel taa hambu anak. ");
INSERT INTO llg_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Boe ma, Lea nailu, de ana bonggi ana tou-anak esa. Ana foin nade, Ruben (fo ndandaan, ‘nita au toꞌa-taang’), huu ana nae, “Memak LAMATUAK nita au toꞌa-taang. Huu ndia, de hatematak ia, au saong nau mbali au boe.” ");
INSERT INTO llg_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Basa ndia, boe ma Lea nailu seluk bali, de ana hambu ana tou-anak esa. Ana foi kakanak ndia, nade, Simeon, (fo ndandaan meda nae, ‘hataholi namanene so’), huu nae, “LAMATUAK namanene so, nae au saong taa mbali au. Huu ndia, de Ana fee au anak esa bali.” ");
INSERT INTO llg_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Basa ndia, boe ma Lea ana nailu seluk bali, de ana hambu ana touanak esa bali. Ana foi kakanak ndia, nade, Lewi, huu ana nae, “No kakanak ia au dedeꞌang basan so. Neu ko au saong dei fo nanambaꞌak no au, huu au bonggi feen ana touanak telu so.” ");
INSERT INTO llg_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Basa ndia, boe ma Lea ana nailu seluk bali, de ana hambu ana touanak esa. Ana foi kakanak ndia nade, Yahuda (fo ndandaan meda nae, ‘koa-kiok’). Huu ana nae, “Oek ia, au nau koa-kio LAMATUAK!” Basa ndia, boe ma Lea taa bonggi so. ");
INSERT INTO llg_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Tehuu Rahel bei taa hambu anak. Huu ndia, de ana dale hedi kaꞌan. Boe ma, ana kokolak no saon nae, “Kaꞌa aa! Fee au anak dei! Mete ma taa, na, malolenak kada au mate leo.” ");
INSERT INTO llg_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Boe ma, Yakob nasapala kana, nae, “O maehetuk au ia Lamatuak, fo bisa fee o anak?” ");
INSERT INTO llg_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Boe ma, Rahel kokolak nae, “Leoia! Malolenak ama haꞌi mala au atang, Bilha. Muu sunggu muan, fo ana bonggi fee au anak.” ");
INSERT INTO llg_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Boe ma, ana fee Bilha neu saon, de Yakob sunggu non. ");
INSERT INTO llg_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Basa boe ma Bilha nailu, de ana bonggi ana touanak esa. ");
INSERT INTO llg_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Boe ma, Rahel ana kokolak nae, “Manetualain namanene au huhule-haladoing so. Huu ndia, de Ana fee au ana touanak esa. Manetualain naketu au dedeꞌang no ndoos so.” De ana foi kakanak ndia, nade, Dan (fo ndandaan nae, ‘naketu dedeꞌak’). ");
INSERT INTO llg_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Basa ndia, boe ma Bilha nailu seluk bali, de ana hambu ana touanak esa bali. ");
INSERT INTO llg_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Boe ma, Rahel kokolak nae, “Au akasusudik ua au kaꞌang, de au senggin.” Huu ndia, ana foi kakanak ndia, nade, Naftali (fo ndandaan nae, ‘nakasusudik’). ");
INSERT INTO llg_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Faik fo Lea nameda taa hambu anak so bali, boe ma ana fee ndia atan Silpa neu saon, fo ana saon. ");
INSERT INTO llg_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Boe ma, Silpa bonggi ana touanak esa. ");
INSERT INTO llg_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","De Lea kokolak nae, “Au ua-naleng malole so.” Huu ndia, de ana foi kakanak ndia, nade Gad (fo ndandaan nae, ‘ua-nale malole’). ");
INSERT INTO llg_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Boe ma, Silpa, ana bonggi seluk touanak esa bali. ");
INSERT INTO llg_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","De Lea kokolak nae, “Wei! Hatematak ia, bei fo au amahoko! Mete te, dei fo basa ina kala kokolak lae, au hambu nanalak seli.” Huu ndia, de ana foi kakanak ndia nade Aser (fo ndandaan nae, ‘namahoko’). ");
INSERT INTO llg_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Laꞌi esa, nandaa no fai kokoluk, de Ruben neni nula dale neu, de ana hambu akidook esa fo hataholi la lae, ana tao inak bisa bonggi. Boe ma, nenin neu inan Lea. Nita leo ndia, boe ma Rahel noke Lea, nae, “Kaꞌa aa! Fee au akidook fa, fo Ruben nenik ndia dei.” ");
INSERT INTO llg_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Tehuu Lea nataa nae, “Weih! O ia, ana seli so! O mamoa mala au saong so. De hatematak ia, o nau mamoa mala akidook ndia, neme au anang mai bali? O ia, mamaem taa!” Tehuu Rahel kokolak, nae, “Leoiak, kaꞌa. Mete ma au hambu akidook ndia, na, leꞌodaen ia, o bole sunggu mua Yakob.” Boe ma, Lea nakaheik. ");
INSERT INTO llg_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Ledobobon ndia, Yakob fali neme osi mai. Boe ma, Lea neu natonggo non, de ana kokolak nae, “Kaꞌa Ako aa! O musi sunggu mua au leꞌodaen ia! Huu au bae memak o unik au anang akidoon.” De leꞌodaen ndia boe oo, Yakob ana sunggu no Lea. ");
INSERT INTO llg_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Boe ma, Manetualain namanene Lea huhule-haladoin. Huu ndia de nailu, boe ma ana bonggi ana tou-ana kaliman. ");
INSERT INTO llg_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","De Lea foi kakanak, naꞌde Isaskar (fo ndandaan nae, ‘bae sosotak’), huu ana nae, “Manetualain Ana bae au sosotang, huu au fee Silpa, ana sao au saong.” ");
INSERT INTO llg_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Basa ndia, boe ma Lea nailu bali, de ana bonggi ana tou-ana kaneen. ");
INSERT INTO llg_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Ana kokolak nae, “Manetualain Ana fee hiak au bua neulauk. De hatematak ia, au saong musi fee hadak neu au, huu au bonggi feen ana tou-anak nee.” Huu ndia, de ana foi kakanak, nade Sebulon (fo ndandaan nae, ‘fee haꞌdak’). ");
INSERT INTO llg_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Basa ndia, boe ma Lea ana bonggi ana ina-anak esa, de ana foin, naꞌde Dina. ");
INSERT INTO llg_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Boe ma, Manetualain nasaneꞌda Rahel, de Ana namanene ndia huhule-haladoin. Huu ndia, Ana soi ndia ana manan. ");
INSERT INTO llg_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Basa ndia, boe ma Rahel ana nailu, de ana bonggi nala ana tou-anak esa. Ana nae, “Manetualain Ana soꞌu nggali heni au mamaeng so.” ");
INSERT INTO llg_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","De ana foi kakanak ndia, naꞌde, Yusuf, (fo ndandaan nae, ‘noke bali’), huu ana nae, “Au oke fo Manetualain fee au ana tou-anak esa bali.” ");
INSERT INTO llg_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Faik fo Rahel bonggi Yusuf so, boe ma Yakob kokolak no Laban, nae, “Toꞌo! Leo bisa na, au sangga fali uni au nusang uu dei. ");
INSERT INTO llg_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ela au ua falik au sao nggala ma au ana nggala. Toꞌo bubuluk au tao ue-ledis mbilu-mbuse fee toꞌo, de au bae ketu sala so. Huu ndia, de hatematak ia, au hak sila so.” ");
INSERT INTO llg_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Basa boe ma, aliaman nataa, nae, “Ana-nggo ei! O mamanene dei. Au neuk basan so, boe ma au bubuluk ae, Manetualain fee au bbaꞌe-babatik huu o. ");
INSERT INTO llg_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Hatematak ia, o sangga moke baꞌu bee, na, au bae! Sadi o leo mahele nai ia, ma tao ue-ledis makandoo fee au.” ");
INSERT INTO llg_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yakob nataa, nae, “Toꞌo mita aom so, au tao ue-leꞌdis tingga-tingga. Huu ndia, de toꞌo banda nala, boe lamanoꞌu lakandoo. ");
INSERT INTO llg_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Faik fo au bei taa mai ndia, toꞌo hata nala taa noꞌuk nalan seli. Tehuu, hatematak ia, toꞌo kamasuꞌik so. Manetualain fee babaꞌe-babatik neu toꞌo, huu au ue-leding. Hatematak ia fain losa so, fo au sangga tao ue-leꞌdis fee au sao-ana nggala.” ");
INSERT INTO llg_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Laban natane, nae, “De au musi bae leo beek neu o?” Yakob nataa, nae, “Toꞌo boso fee au hata-hata. Dei fo au akaboi akandoo toꞌo banda nala, sadi au bisa tao dedeꞌak esa. ");
INSERT INTO llg_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Makamboꞌik au, fo faik ia boe oo, au uni toꞌo banda nala uu, fo hele ala biꞌiae-biꞌilombo. Mana taa kokotok, ma taa kekeꞌa kala, na, toꞌo enan. Tehuu kokotok ma kekeꞌa kala, na, ela au hambu sala. Ma au haꞌi ala biꞌilombo nggeok boe. Ela basa sila baen neu au sosotang. ");
INSERT INTO llg_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Nai fai makabuin, dei fo toꞌo bisa bubuluk au ia ndoos, do taa. Sudi faik bee, toꞌo bisa mai palisak au banda nggala. Mete ma hambu mita biꞌiae taa kokotok, do taa kekeꞌak, do biꞌilombo fulak, na, toꞌo bubuluk memak mae au amanaꞌo ala toꞌo banda nala.” ");
INSERT INTO llg_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laban nakaheik, nae, “Hei! Leo ndiak leo.” ");
INSERT INTO llg_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Tehuu faik ndia boe oo, Laban tada heni basa banda kokotok, kekeꞌak, ma biꞌilombo nggeok. Boe ma, nadenu ndia ana nala lakaneni banda la sila. ");
INSERT INTO llg_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Boe ma, leni banda la sila leni mamanak esa leu, fo doon laꞌo eik faik telu, neme Yakob mai. De, Yakob bei nakaboi aliaman biꞌiae-biꞌilombo ela kala. ");
INSERT INTO llg_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Basa ndia, boe ma Yakob tati nala ai ndanak neme ai matak telu mai, de ana lufa loun tao kekela-kekelak. ");
INSERT INTO llg_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Ana tao ai nanakekelak ndia, neu banda la sila mamana nininun. Banda la lahiik lasaok lai mamana nininuk. ");
INSERT INTO llg_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","De, faik fo banda la lasaok neu ai nana kekelak ndia matan, boe ma ana nala, ala kalua mai tehuu bulu nala kokotok ma kekeꞌak. ");
INSERT INTO llg_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Boe ma, faik fo Laban banda nala sangga lasaok, na Yakob ana fee sala lasale leni banda kokotok ma kekeꞌak leu. Boe ma, ana nala kalua tehuu kokoto kala, ma kekeꞌa kala, de ndia banda heheli nala lamanoꞌu. Boe ma ana tada heni sala leme Laban banda nala mai. ");
INSERT INTO llg_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Faik fo banda balakai kala lasaok, na, Yakob tao ai nanakekelak kala sila neu mata nala, nai sila mamana nininun. ");
INSERT INTO llg_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Tehuu mete ma banda mana mamale kala lasaok, na, taa tao ai sila neu sala. De, Laban ana hambu banda mana mamale kala. Tehuu, Yakob hambu basa banda balakai kala. ");
INSERT INTO llg_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Boe ma Yakob dadik namasuꞌi atu-atu. Ndia biꞌiae nala, biꞌilombo nala, banda onta nala, banda keledei nala, ma ata nala, noꞌun seli. ");
INSERT INTO llg_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Laꞌi esa, Yakob namanene Laban ana nala, lakokola lae, “Yakob namasuꞌi atu-atu, huu ana kao namada ita aman hata nala.” ");
INSERT INTO llg_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yakob boe oo, nita ndia aliaman matan mamada ndoos, ma taa malole no ndia, fo taa sama leo makahulun so bali. ");
INSERT INTO llg_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Basa ndia, boe ma Manetualain kokolak no Yakob, nae, “Hatematak ia, fain losa so. De, o musi fali muni o ina-ama mala muu. Dei fo Au sama-sama ua o.” ");
INSERT INTO llg_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Basa ndia, boe ma Yakob neu noke Rahel ma Lea, fo ala mai latonggo lo ndia nai banda la mamanan nai mok. ");
INSERT INTO llg_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Boe ma, ana nafada sala, nae, “Fai makabuin ia, au ita ei amam matan kada mamada ndoos so, neu au. Ma ndia taa malolole no au so bali, fo sama leo makahulun. Tehuu Manetualain fo au amang, nakaluku-nakatele neu Ndia, Ana sama-sama no au. ");
INSERT INTO llg_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Ei dua nggei bubuluk, doo-doo basa ia, au tao ue-ledis mbilu-mbuse alan seli, fee ei amam! ");
INSERT INTO llg_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Tehuu mae leondia boe oo, ana nambue kedi nala au taa-taa. Ana nggati au sesebang losa lai sanahulu. Mae leondiak boe oo, Manetualain nanea nahele au. ");
INSERT INTO llg_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Faik fo ei amam kokolak, nae, ‘Banda kokoto kala, dadik sesebak,’ boe ma banda la sila ala bonggi basa sala kokotok. Fai seluk, ana kokolak bali, nae, ‘Hatematak ia, banda kekeꞌa kala, dadik neu au sesebang’, boe ma banda la sila, bonggi basa sala kekeꞌak. ");
INSERT INTO llg_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Manetualain tao leondiak, fo ela Ana haꞌi nala ei amam banda nala, fo feen neu au. ");
INSERT INTO llg_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Laꞌi esa, faik fo banda la fai sasaon, au ita nai au meꞌing dale, basa banda mane mana sao kala sila, hambu kekeꞌak ma kokotok. ");
INSERT INTO llg_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Boe ma, Manetualain ata nala leme nusa-sodak mai, loke au nai meꞌis dale, lae, ‘Wei! Yakob!’ Boe ma au ataa, ae, ‘Hata, Manetualain?’ ");
INSERT INTO llg_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Boe ma, nafada nae, ‘Mete dei! Basa banda mane mana sao kala sila, kada hambu kekeꞌak ma kokotok. Au ndia heti basa sila. Huu Au ita hata fo Laban taon neu o so. ");
INSERT INTO llg_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Au ia, Manetualain fo Au atudu Mataong neu o neme Betel. Nai ele, o mambadedei batu esa, boe ma o diꞌa mina neu lain, de o makaluku-makatele neu Au. Boe ma, o mbaꞌa heheluk mua Au muma ndia. Hatematak ia, o musi laꞌo ela nusak ia, fo fali muni o inama mala nusan muu leo.’ ” ");
INSERT INTO llg_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Rahel no Lea lamanene basa, de lataa lae, “Neu! Kada ai tungga! Huu ai hata nala taa so, nai ai ama Laban uman. ");
INSERT INTO llg_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Doo-doo basa ia, na, toulasik tao ai leo hataholi feꞌek. Ana seꞌo heni basa ai, ma naꞌa heni ai belin so. ");
INSERT INTO llg_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Basa hata fo Manetualain haꞌin neme Laban ndia mai, hatematak ia, dadik neu ita, ma ita ana nala pusakan. De mete ma, Manetualain nae leobee, na, kada ai tungga mesan!” ");
INSERT INTO llg_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Basa ndia, boe ma Yakob mulai nafafaꞌu ndia bua nala. Boe ma, ana nakahehenek ndia sao-ana nala leu basa banda onta la, de ana hoo no basa ndia banda nala, ma ana fua neni bua nala fo ana hambu sala leme Padan Aram, de ana fali neni dae Kanaꞌan neu. ");
INSERT INTO llg_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Faik ndia, Laban nggute ndia biꞌilombo nala bulun. Boe ma, Rahel namanaꞌo neni aman bua dodoki sosonggo nala. ");
INSERT INTO llg_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yakob asa laꞌo no nee-neek leo, ma taa nafada aliaman. ");
INSERT INTO llg_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Ana neni basa ndia hata nala, de ala laꞌok lai-lai lesik lee ina, boe ma lasale leni lete Gilead leu. ");
INSERT INTO llg_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Seli faik telu, boe ma Laban hambu halak nae, Yakob asa, lalai so. ");
INSERT INTO llg_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Boe ma, Laban nakabubua nala ndia hataholi nala, de leu husi tungga ndia manefeun. Ala husi losa faik hitu, bei fo hambu sala leme lete kala manai Gilead. ");
INSERT INTO llg_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Leꞌodaen ndia, boe ma Manetualain natudu Mataon neu Laban nai meꞌis dale. Ana nae, “Laban! Mete ma o kokolak mua Yakob, na, manea neulalau o bafam.” ");
INSERT INTO llg_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Leꞌodaen ndia, Yakob nambadedei uma temak neme lete Gilead. Boe ma, Laban nambadedei sila uma teman taa dook neme ndia mai. ");
INSERT INTO llg_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Basa ndia, boe ma Laban mai natonggo no Yakob. Boe ma, ana kokolak nae, “Heh! Yakob! Hatina de o malai mua au ana inana nggala no nee-neek leoiak? Sama leo o mamoa mala sala leme musu dale. ");
INSERT INTO llg_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Talobee de o malai no nee-neek, fo taa mafada au so! Mete ma o mafada au no malole, na, neu ko au tao feta takasoe, fo ai mia ei pake meko-labu, bei fo mboꞌi ei laꞌo. ");
INSERT INTO llg_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","O salam esa bali, ndia, o taa fee au lelak fo idu au umbu-ana nggala, bei fo mboꞌi sala. O tataom ndia, nggoan ana seli! ");
INSERT INTO llg_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","No lofoanak au bisa tao soe o! Tehuu leꞌodaek, Manetualain fo o amam nakaluku-nakatele neu Ndia, Ana kaꞌi au nae, mete ma au kokolak ua o, na, au musi anea neulalau au bafang. ");
INSERT INTO llg_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Memak au bubuluk, ae, o laꞌo huu o mahiik sangga fali. Tehuu hatina de, o musi mamanaꞌo muni au bua dodoki sosonggo nggala?” ");
INSERT INTO llg_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yakob nataa, nae, “Toꞌo boso mamanasa au! Au laꞌo no nee-neek ndia, huu au bii, boso losak toꞌo nakalelee nala kakana kala ia, na, talobee?” ");
INSERT INTO llg_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Tehuu Yakob taa bubuluk, saon Rahel ndia namanaꞌo neni bua dodoki sosonggo kala sila. De, ana nae, “Toꞌo! Soaneu bua dodokik sosonggo kala sila, na, kada sangga sala leo! Mete ma, hambun nai see, na, huku nisan. Palisak basan leo! Mete ma hambu toꞌo bua pusaka feꞌen, na, haꞌi fali kana. Ela basa hataholi la ia, dadik sakasii.” ");
INSERT INTO llg_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Boe ma, Laban neu palisak esa-esako uma teman. Sososan Yakob uma teman. Basa ndia, de, neni Lea uma teman neu. Boe ma, ata ina kadua kala sila uma tema nala. Tehuu tana hambu bua dodokik sosonggo kala sila. Babasan, de ana maso neni Rahel uma teman dale neu. ");
INSERT INTO llg_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rahel nafuni bua dodoki sosonggo kala sila lai banda onta bebelan buin, de nanggatuuk neu lain. Laban palisak lutu-lutuk nai Rahel uma teman, tehuu tana hambu sala. ");
INSERT INTO llg_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rahel kokolak no aman, nae, “Ama boso mamanasa. Au taa bisa ambadeik, huu au hambu bulak.” Boe ma, Laban nasanggak bali, tehuu taa hambu bua dodoki sosonggo kala sila. ");
INSERT INTO llg_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Boe ma, Yakob daan saꞌe, de nasapalak Laban, nae, “Au tao manggalauk hata neu toꞌo? Losa toꞌo husi au, nonook leo au hataholi manggalauk! ");
INSERT INTO llg_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Toꞌo palisak basa au bua nggala so. De toꞌo hambu hata? Hena taon neu mata ia, fo ita basa-nggata tita! Fo ela hataholi la ia laketu, bua sala sila, see enan. ");
INSERT INTO llg_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Teuk dua hulu, au kuli-kuli fee toꞌo so. Faik fo au anea toꞌo banda nala, taa hambu esa kalaheni boe. Au taa uꞌa esa boe. ");
INSERT INTO llg_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Mete ma hambu banda fui tao nisa toꞌo bandan esa, na, au taa afaꞌda toꞌo, tehuu au nggatin. Ma mete ma hataholi la lamanaꞌo toꞌo bandan, na, toꞌo fee au nggati, mae au salang taa ndia. ");
INSERT INTO llg_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Leledok, na, ledo hotu au. Leꞌodaek na, au dele manilik. Au beꞌe losa au taa bisa sunggu, huu au anea toꞌo banda nala. ");
INSERT INTO llg_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Memak tetebes teuk dua hulu! Au tao ue-ledis teuk sanahulu haa, fo hambu toꞌo ana inana nala. Basa ndia, de au tao ues teuk nee bali, fo bisa hambu au banda nggala. Toꞌo mambue nggati taa-taa au seseꞌbang losa laꞌi sanahulu, naa te au tao ues kuli-kuli doo basa ndia. ");
INSERT INTO llg_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Uak Manetualain, fo baꞌi Abraham no ama Isak lakaluku-lakatele neun, Ana nanea au. Mete ma, taa, na, neu ko toꞌo husi heni au ua lima louk so. Tehuu Manetualain taa nakambombokek matan neu au totoꞌang, ma Ndia nita basa au ue-leꞌding. Huu ndia de leꞌodaek, Ana mai nasaneneꞌdak toꞌo.” ");
INSERT INTO llg_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laban namanene basa Yakob kokolan leondia, boe ma ana nataa, nae, “Leoiak! Ina kadua kala sila, au ana nggala. Kakana kala fo ala bonggi kala sila, basa sala au umbu nggala, ma basa banda la ia au enang. Basa hata fo o mitam nai ia, memak au enang. Tehuu au sangga tao hata? Au taa bisa akalelee sala. ");
INSERT INTO llg_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","De, malolenak, dua nggata mbaꞌa heheluk. Ma ita musi tasoda tungga heheluk ndia.” ");
INSERT INTO llg_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Basa ndia, boe ma Yakob haꞌi nala batu inahuuk esa, de nambadedein neu ndia, fo ana daꞌdik neu tanda heheluk. ");
INSERT INTO llg_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Boe ma, Yakob nadenu ndia hataholi nala, fo leu lakaduduluk batu, de ala lakatotodok batu la sila. Boe ma, basa sala langgatuuk laꞌa dekak lo batu la sila. ");
INSERT INTO llg_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Boe ma, Laban foi batu nana nakatotodok ndia, nae, Yegar Sahaduta. Tehuu Yakob foin, nade, Galed. ");
INSERT INTO llg_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Boe ma, Laban nae, “Batu nana nakatotodok ia, dadik sakasii neu ita dua nggata.” Huu ndia de mamanak ndia, nade Galed. ");
INSERT INTO llg_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Laban boe oo, foi mamanak ndia, nade Mispa (fo hihii leo dedeꞌa deꞌe feꞌek fo ndandaan nae, ‘mamana nanea madema’), huu ana kokolak nae, “Dei fo LAMATUAK mesa kana nanea ita dua nggata, fo mae ita komododook boe oo, ita taa bole laꞌolena heheluk ia. ");
INSERT INTO llg_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Mete ma o tao manggalauk neu au ana nggala ia, do sao ina feꞌe kala, na, neu ko au taa bubuluk. Tehuu masanenedak! Manetualain dadik sakasii neu o ma au. ");
INSERT INTO llg_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","52","Hena mete batu nambadedeik ia, ma batu nana nakatotodo kala. Masanenedak, huu batu la ia, dadik to boe. O taa bole lena seli batu la ia, fo tao manggalauk neu au. Ma au boe oo, taa bole lena seli batu la ia, fo tao manggalau neu o. ");
INSERT INTO llg_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Ita mbaꞌa heheluk ia, pake ita bei-baꞌi nala Manetualain, fo ndia o baꞌim Abraham, ma au baꞌing Nahor Manetualain. Dei fo Ndia mesa kana dadik manamaketuk fo naketu ita dua nggata dedeꞌan.” Yakob namanene basa leondia, boe ma ana soo mate, pake Manetualain naden, fo ndia aman Isak nakaluku-nakatele neun. ");
INSERT INTO llg_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Basa ndia, boe ma Yakob hala banda, de ana nenin dadik neu tunu-hotuk fee Manetualain nai letek ndia lain. Boe ma, noke basa hataholi la, de basa sala laꞌa, ma ala beꞌe leme ndia losa fafain. ");
INSERT INTO llg_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Foꞌa fafain, boe ma Laban neu holu, ma ana idu basa ndia umbu-ana nala. Basa de ana kokolak fee babaꞌe-babatik neu sala, de ana fali neni ndia nusan neu. ");
INSERT INTO llg_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Basa ndia, boe ma Yakob asa laꞌo lakandoo. Boe ma, Manetualain ata nala leme nusa-sodak mai latonggo lon. ");
INSERT INTO llg_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Ledoeik nita sala, boe ma ana kokolak, nae, “Ia, Manetualain soldadu nala mamana hahaen nai ia, maa!” Huu ndia, de ana foi mamanak ndia nade, Mahanaim (fo ndandaan nae, ‘mamana hahaek dua’). ");
INSERT INTO llg_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Basa ndia, boe ma Yakob nadenu ndia hataholi nala luma, laꞌok lakahuluk leni nusa Edom leu (fo ndia Seir), fo lafada kaꞌan Esau, lae, Yakob sangga mai ndia so. ");
INSERT INTO llg_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Yakob nafada ndia hataholi nala, nae, “Ei miu mafada au kaꞌang Esau mae leo ia: ‘Malangga Esau! Ama atan, fo fadim Yakob, haitua soda-molek noꞌun seli neu ama. Neme au lalaꞌong makahulun mai, losa hatematak ia, ama atan ndia, ana leo nai toꞌo Laban uman. ");
INSERT INTO llg_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Hatematak ia, ama atan ia, kasapik, banda keledei, biꞌiae-biꞌilombo, ma ata touk ma inak. Au haitua hataholi la ia lakahuluk, fo fee halak neu ama, laꞌeneu au mamaing. Au amahena, ama mahiik simbok ai no dale malenggak.’ ” Boe ma, hataholi la sila, ala laꞌo. ");
INSERT INTO llg_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Faik fo ala fali leni Yakob mai, ala lafaꞌda, lae, “Ai matonggo mia ama kaꞌan Esau so. Hatematak ia, ana mai no touk natun haa, fo sangga natonggo no ama.” ");
INSERT INTO llg_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Yakob namanene leondia, de dalen nduka-ndukak, ma ana bii nalan seli. Boe ma, ana baꞌe ndia hataholi nala ma basa banda nala, ala daꞌdik bubuak dua. ");
INSERT INTO llg_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Ana duduꞌa, nae, “Mete ma Esau mai fo ana sambu bubua kaesan, na, bubua kaduan bisa lalai leu sangga sodak.” ");
INSERT INTO llg_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Basa ndia, boe ma Yakob hule-haladoi, nae, “Manetualain aa! Manetualain fo au baꞌing Abraham no au amang Isak, ala lakaluku-lakatele neu O. Mamanene au dei! Fain, Manetualain nadenu au fali uni au bobonggi nggala mai nai nusak ia. Manetualain helu nae, dei FO Manetualain heti tao neulalau basan. ");
INSERT INTO llg_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Au taa andaa simbok Manetualain sususen, ma Manetualain dale kateman neu au. Makahulun, faik fo au lena lee Yarden ia, kada au uni teteꞌe-aik. Tehuu hatematak ia, au fali maing uni hataholi ma banda bubuak dua. ");
INSERT INTO llg_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Au bii, naafo kaꞌa Esau mai sambu tao nisa ai basa nggai. De, au oke, fo Manetualain nasalaꞌe nala au, ma basa au sao-ana nggala, neme kaꞌa Esau mai. ");
INSERT INTO llg_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Manetualain ndia helu nae, Manetualain fee babaꞌe-babatik makadotok neu au, ma tao au numbu-sadu nggala tamba lamanoꞌu, sama leo salaek malai tasibifik, fo hataholi la taa bisa hingga sala so bali.” ");
INSERT INTO llg_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Boe ma, Yakob sunggu neu mamanak ndia. Foꞌa mai, boe ma ana sadia banda fo sangga ana feen neu kaꞌan. ");
INSERT INTO llg_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Ana hele nala biꞌiae ina natun dua, biꞌiae mane dua hulu, biꞌilombo ina natun dua, biꞌilombo mane dua hulu, ");
INSERT INTO llg_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","banda onta ina telu hulu ma ana bei manasusu kala, sapi ina haa hulu, sapi mane sanahulu, banda keledei ina dua hulu, ma banda keledei mane sanahulu. ");
INSERT INTO llg_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Boe ma, ana baꞌe banda la sila, esa-esako no numban ma ndia bubuan. De ana fee esa-esako no manahoon. Ana nafada sala, nae, “Ei laꞌok makahuluk. Dei fo au tungga dea. Tehuu ei musi manea fo bubuak esa dook fa neme bubua feꞌek mai.” ");
INSERT INTO llg_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Boe ma, Yakob palenda manahoo la, neme bubua kaesan, nae, “Mete ma au kaꞌang Esau mai natonggo no ei, ma natane nae, ‘O sangga muni bee muu? O ia, see atan? Banda la ia, see enan?’ ");
INSERT INTO llg_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Na, ei musi mataa, mae, ‘Banda la ia, ama atan Yakob enan. Ana haitua fee kaꞌan, malangga Esau. Tehuu ndia mesa kana bei tungga dea.’ ” ");
INSERT INTO llg_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","20","Ndia boe oo palenda leondiak neu basa manahoo bubua feꞌe kala, nae, “Mete ma matonggo mia kaꞌa Esau so, na, ei palasen banda la sila neun. Boe ma ei mafadan mae, au tungga dea.” Yakob duduꞌa, nae, mete ma ana fee basa banda la sila neu Esau, na, dei fo Esau dalen makasufu neu ndia. ");
INSERT INTO llg_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","De, ana haitua banda la sila lakahuluk. Tehuu leꞌodaen ndia, ana bei nahani nai ndia. ");
INSERT INTO llg_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Leꞌodaen ndia, Yakob foꞌa, boe ma ana heti saon dua sala, ndia sao nakaboin dua sala, ma ndia ana kasanahulu esa, fo ala lena lee Yabo selik leu. ");
INSERT INTO llg_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Basa sala losa selik, boe ma ana haitua basa ndia pusaka nala ele leu. ");
INSERT INTO llg_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Tehuu Yakob mesa kana nahani ndia. Basa boe ma, touk esa mai, de naule non losa lolembilak. ");
INSERT INTO llg_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Ledoeik touk ndia nameda elabaꞌik senggin, boe ma ana habo fee Yakob ikoain, losa ndia dui sesesun posi henin neme ndia mamana nanggatutuun mai. ");
INSERT INTO llg_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Boe ma, touk ndia nae, “Mboꞌi au leo, huu baꞌianak bali te ledo sangga sadu ia so.” Tehuu Yakob nataa, nae, “O kokolak fee au babaꞌe-babatik dei, bei fo au mboꞌi o!” ");
INSERT INTO llg_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Boe ma, touk ndia natane, nae, “O nade see?” Ana nataa nae, “Yakob.” ");
INSERT INTO llg_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Boe ma, touk ndia ana kokolak nae, “O naꞌdem taa Yakob so bali. Tehuu mulai neme hatematak ia, hataholi la loke o, na, lae, ‘Israꞌel’ (fo ndandaan ‘naule no Manetualain’). Huu o maule-heluk laban hataholi, ma Manetualain, losa o senggi. ");
INSERT INTO llg_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Boe ma, Yakob natane, nae, “O naꞌdem see?” Tehuu touk ndia nataa nae, “O nau matane au naꞌdeng, fo tao neu hata?” Basa boe ma ana kokolak fee babaꞌe-babatik fee Yakob neme ndia. ");
INSERT INTO llg_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Boe ma, Yakob kokolak nae, “Au ita Manetualain matan no au mata heheling, tehuu au bei asoda.” Huu ndia, de ana foi mamanak ndia, nade Peniꞌel, fo ndandaan nae, ‘Manetualain matan’. ");
INSERT INTO llg_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Ledo sadu so, neu ledoeik Yakob laꞌo ela mamanak ndia. Tehuu ana laꞌok doka-dokak, huu ndia ikoain heok sala. ");
INSERT INTO llg_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Huundia de losa hatematak ia, hataholi Israꞌel asa taa laꞌa mbaa ikoaik, huu Lamatuak tutu tao nasala sila baꞌin Yakob dui ikoain. ");
INSERT INTO llg_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Faik ndia, Yakob nita Esau mai no ndia bubuan, hataholi natun haa. Boe ma, ana babaꞌe ana nala esa-esak neu ina nala. ");
INSERT INTO llg_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Ana heti fo sao nakaboi kadua nala sila lo ana nala, ala laꞌok tungga mata. Boe ma, Lea no ndia ana nala, bei fo Rahel no ndia anan, Yusuf, lakabuik teteꞌen. ");
INSERT INTO llg_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Tehuu Yakob laꞌok nai mata neme sila basa sala mai. Ledoeik sangga dekak lo kaꞌan, boe ma ana sendek lunggu-langgan, de nakatele losa dae, laꞌi hitu. ");
INSERT INTO llg_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Tehuu ledoeik Esau nita fadin, boe ma nalai neu natonggo no Yakob, de ana holu nalan, boe ma ana idun, de dua sala lamatani. ");
INSERT INTO llg_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Ledoeik Esau nita ina kala lo ana nala, boe ma natane, nae, “Tehuu basa hataholi la ia, see?” Yakob nataa, nae, “Sila ndia, hataholi la fo Manetualain fee au, fo kaꞌa atam ia.” ");
INSERT INTO llg_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Basa ndia, sao nakaboi nala, ma ana nala, ala mai lakatele leu Esau. ");
INSERT INTO llg_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Boe ma, Lea no ana nala, mai kauk leu Esau. Mateꞌen Yusuf no inan Rahel lakatele leu Esau. ");
INSERT INTO llg_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Basa boe ma, Esau natane, nae, “Banda bubuak fo isinaak o haituak ndia, na, ndia ndandaan hata?” Boe ma, Yakob nataa nae, “Leoiak, kaꞌa! Au fee basa sala leu kaꞌa, fo ela kaꞌa simbok au no dale loak.” ");
INSERT INTO llg_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Tehuu Esau bala nae, “Fadi Yakob! Au hata nggala noꞌuk boe. De o boso fee au hata-hata.” ");
INSERT INTO llg_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Boe ma, Yakob nataa, nae, “Kaꞌa boso tao leondiak! Kaꞌa musi simbon, fo dadik tanda nae, kaꞌa simbok au no dale malenggak. Huu ledoeik au ita huhumen isinaak ndia, nonook leo au ita Manetualain huhumen. ");
INSERT INTO llg_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","De, au oke no hadak, fo ela kaꞌa simbok mala, au fefee hiang ia, fo sosoan taa fa boe. Huu Manetualain neulaun seli no au, huu ndia, de Ana fee basa hata fo au paluun.” Yakob kokoe nakandondoo henin, losa nau taa nau, Esau simbok banda sila. ");
INSERT INTO llg_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Basa ndia, boe ma Esau kokolak nae, “Mete ma leondiak, na, mahehele, fo ita laꞌo leo! Dei fo au ua ei.” ");
INSERT INTO llg_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Tehuu Yakob nataa, nae, “Bosok, kaꞌa! Kaꞌa mita matam, kakana kala bei kadiꞌik de tala bisa laꞌok lai-lai. Ma banda manabonggi beu kala, noꞌuk boe. Mete ma ita takaseti sala laꞌo lai-lai, na kada nai faik esa dalen, mate basa sala. ");
INSERT INTO llg_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","De, malolenak, kaꞌa sala lakahuluk leo. Dei fo ai basa nggai laꞌok fa-fa tungga dea. Dei fo au uu tilo kaꞌa sala lai Seir.” ");
INSERT INTO llg_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esau kokolak bali nae, “Mete ma leondiak, na, au laꞌo ela au hataholing luma lo o, fo ala latudu dalak neu ei.” Tehuu Yakob nae, “Kaꞌa boso tao nasambutek! Dedeꞌa inahuun ndia, au bubuluk kaꞌa simbok au.” ");
INSERT INTO llg_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Esau namanene leondia, boe ma ana laꞌo ela sala, de ana fali neni Seir neu. ");
INSERT INTO llg_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Tehuu Yakob neni Sukot neu. Nai ndia, ana tao uma, ma ana tao lalae soaneu basa banda nala. Huu ndia de mamanak ndia, ala foin nade Sukot (fo ndandaan nae, ‘uma dea’). ");
INSERT INTO llg_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Babasan, de Yakob asa losa no sodak neme Padan Aram mai, leni nggolo Sikem leu, nai nusa Kanaꞌan. Boe ma, ala lambadedei uma temak, deka-deka no nggolok ndia. ");
INSERT INTO llg_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Dae ndia, fo Yakob ana nambadedei uma temak ndia, ana tifa ketun neme Hemor, fo Sikem aman, doi lilo fulak natun esa. ");
INSERT INTO llg_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Nai ndia, ana nakatotodok batu tao mei tunu-hotuk. Boe ma, ana foi mamanak ndia, nade El-Elohe-Israꞌel, fo ndandaan nae, ‘Manetualain ndia, na, Israꞌel Manetualain’. ");
INSERT INTO llg_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Laꞌi esa, Yakob no Lea ana inanan Dina, neu tilo inana kala malai nusak ndia. ");
INSERT INTO llg_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Nusak ndia manen, nade Hemor, neme leo Hewi mai. Ndia ana touanan, nade Sikem. Laꞌi esa, Sikem nita Dina, boe ma ana nalai noon, de ana sao nakaseti kana. ");
INSERT INTO llg_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Sikem dalen tuda neu Dina, de ana suen nalan seli. De Sikem kokolak malole non, fo suek Dina bala ndia susuen. ");
INSERT INTO llg_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Huu ndia, de Sikem nafada aman, nae, “Ama! Tulun muu matane Dina fee au, fo au saon.” ");
INSERT INTO llg_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yakob namanene hambu hataholi ana sao nakaseti ndia ana inanan, tehuu kada ana nee-nee, ma taa tao hata-hata. Huu faik ndia, ndia ana touana nala, lanea banda lai mok. De, ana nahani losa basa sala fali dei. ");
INSERT INTO llg_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Faik ndia Sikem no aman Hemor, ala leni Yakob leu, fo sangga latane Dina. ");
INSERT INTO llg_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Nandaa, no dua sala bekola, boe ma Yakob ana nala fali leme mook mai. Ala lamanene Sikem sao nakaseti sila feton leondia, boe ma dale nala hedis, ma ala luli lalan seli. Boe ma, ala lae, “Tatao leondiak, taa nandaa nai Israꞌel. De ai taa bole simbok hataholi tao manggalauk leondiak.” ");
INSERT INTO llg_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Boe ma, Hemor kokoe Yakob asa, nae, “Tolanoo Yakob! Au anang Sikem dalen nahiik tebe-tebe no tolanook ana inanan. De, au oke fo makamboꞌik au anang saon. ");
INSERT INTO llg_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Leo bisa, na ita ana nala lahaꞌi kala. Ei ana touana nala, sao ai ana inana nala. Ma ai ana touana nala, sao ei ana inana nala, ");
INSERT INTO llg_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","ma ela ei leo mabali ao mia ai nai ia. Ei nana mboꞌik leo sudi nai bee, ma danggan fo hambu hata nai ia.” ");
INSERT INTO llg_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","12","Basa ndia, boe ma Sikem kokolak no Dina aman, ma kaꞌa nala, nae, “Ei sangga mae moke sudi hata, na au tungga. Ei nau moke ndia doi kena mamaen, ma ndia belin sudi baꞌubee, na au bae. Sadi ei mboꞌi fo au sao ei feton.” ");
INSERT INTO llg_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Tehuu Yakob ana nala, bubuluk Sikem sao nakasetik sila feton Dina so. De ala lataa pepekok Sikem, ma ndia aman Hemor. ");
INSERT INTO llg_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Boe ma ala lataa lae, “Ai taa bisa makasasaok ai feton no hataholi taa mana sunat! Ndia tao nakamamaek ai! ");
INSERT INTO llg_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Tehuu ndia dala kaluan leoiak: Basa ei tou kala inahuu-kadiꞌik, musi sunat sama leo ai. ");
INSERT INTO llg_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Mete ma ei tao leondiak so, na, bei fo ita bisa tahaꞌi kala. Ma ai boe oo bisa leo sama-sama mia ei nai ia, fo ata dadik hataholi nusak esa. ");
INSERT INTO llg_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Tehuu mete ma ei taa tungga ai hihiin, ma taa nau sunat, na, dei fo ai haꞌi falik ai feton, boe ma, ai laꞌo heok mima ia mai.” ");
INSERT INTO llg_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Hemor no Sikem simbok no malole sila kokolan ndia. ");
INSERT INTO llg_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Tehuu Sikem taa nau nahani so bali, huu ana sue mate no Dina. Basa hataholi malai nusak ndia, ala fee hadak neu Sikem. ");
INSERT INTO llg_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","De, Hemor no Sikem leni mamana tao dedeꞌak leu, nai nggolok lelesu inan, de ala lakokola lo basa hataholi malai nusak ndia, lae, ");
INSERT INTO llg_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Basa tolanoo nggalei! Hataholi Israꞌel asa ia, lahiik lasoda mole lo ita. De ela ala leo sama-sama lo ita nai nusak ia. Nusak ia loan dai soaneu ita basa nggata. Ita bisa tahaꞌik to sila inanan. Sila boe oo bisa lasaok lo ita ana inana nala. ");
INSERT INTO llg_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Ala loke kada dedeꞌak esak, neme ita mai. Ndia, basa ita tou kala musi sunat leo sila. ");
INSERT INTO llg_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Mete ma ita tasoda takabubua so, na, dei fo basa sila banda nala, ma hata nala, dadik ita pusakan boe, hetu? De, malolenak ita simbok sila hihiin. Mai ita basa nggata, sunat sama-sama leo! Makaheik, do?” ");
INSERT INTO llg_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Boe ma, basa hataholi mana makabubuak lai ndia, lakaheik neu Hemor no Sikem kokolan ndia. De basa tou kala malai nusak ndia, ala sunat landaa. ");
INSERT INTO llg_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Neu fai katelun, faik fo basa mana sunat hinan bei heꞌdis, boe ma Dina kaꞌa nala, Simeon no Lewi, hela lala sila tafa nala, de ala maso no nee-neek leni nggolok dale leu. Boe ma, ala tao lisa basa tou kala. ");
INSERT INTO llg_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Ala tao lisa Hemor no Sikem boe. Boe ma, ala loo Dina kalua neme Sikem uman mai, de ala fali. ");
INSERT INTO llg_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Basa ndia, boe ma Yakob ana feꞌe nala, maso leni nusak ndia leu, de ala lamoa lala nusak ndia isin. Ala luli, huu hataholi sao nakasetik sila feton nai ndia. ");
INSERT INTO llg_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Ala lamoa lala basa hataholi la bua nala, leme uman nala dalek mai, ma ala hoo leni basa banda nala, leme mook. ");
INSERT INTO llg_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Ala haꞌi leni basa ina kala, ma ana nala, ma lamoa leni basa nusak ndia bua mabeli nala. ");
INSERT INTO llg_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Ledoeik Yakob bubuluk dedeꞌak ndia, boe ma ana kokolak no Simeon ma Lewi, nae, “Ei tao tatao nggoak hata ia so? Kada tao makatotoꞌak au! Dei fo hataholi Kanaꞌan, hataholi Peris, ma basa hataholi manai dae babaꞌek ndia, ala lamanasa mate lo ita. Sila hataholi nala noꞌuk, tehuu ita hataholi nala kada lumak. Mete ma ala mai sambu ita, na, ita takalulutuk leo, maa.” ");
INSERT INTO llg_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Tehuu, lataa no nasak, lae, “Ama! Ama mae hetuk, ai nau, ela ala tao ai feton, dadik ina kalabik!” ");
INSERT INTO llg_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Basa ndia, boe ma Manetualain kokolak no Yakob, nae, “Au ia, Manetualain, fo Au atudu Au Mataong neu o, neu faik fo o malai muma kaꞌam Esau mai. Hatematak ia, o huꞌa leo, fo muni Betel muu. Losa ele, na, o mambadedeik mei tunu-hotuk fee Au. Basa na, o leo muu ndia leo.” ");
INSERT INTO llg_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","3","Basa ndia, boe ma Yakob kokolak no basa uma isi nala, nae, “Hatematak ia, ita basa nggata sangga laꞌo teni Betel teu. Makahulun, faik fo au nai au totoꞌang dale, de Manetualain Ana fali nala au neme ndia. Au sangga ambadedeik mei tunu-hotuk esa nai ndia. De, hatematak ia, ei nggali heni basa ei bua dodoki sosonggo mala. Tao malalao ei ao-ina mala, ma nggati heni ei baloꞌa papake nala, huu ita sangga takaluku-takatele neu Manetualain.” ");
INSERT INTO llg_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Boe ma, ala fee heni basa sila bua dodoki sosonggo nala, ma basa loloꞌe kala. De Yakob natoi heni basa bua sala sila, neu ai inahuuk esa huun, dekak no nggolo Sikem. ");
INSERT INTO llg_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Faik fo Yakob bubua nala laꞌo leme Sikem mai, boe ma Manetualain fee sala namemeda bibiik neu hataholi la manai basa nusak ndia, losa ala taa lambalani tao manggalalauk neu Yakob asa. ");
INSERT INTO llg_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Boe ma, Yakob no basa ndia bubuan, losa no sodak nai Betel (fo makahulun, nade Lus), nai dae Kanaꞌan. ");
INSERT INTO llg_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Nai ndia, Yakob nambadedei mei batu tunu-hotuk. Boe ma, ana foi mamanak ndia nade El Betel, (fo ndandaan nae, ‘Manetualain Betel’), huu makahulun Manetualain natudu Mataon neu Yakob neme ndia, neu faik fo nalai neme kaꞌan mai. ");
INSERT INTO llg_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Dekak no nggolo Betel, hambu ai ina esa, fo hataholi la, ala foin nade Alon Bakut, fo ndia ndandaan nae, ‘ai makaleleuk’. Ana hambu nadek ndia, huu Ribka ina kokoꞌon, nade Debora, maten, de latoin neme ai ndia huun. ");
INSERT INTO llg_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Faik fo Yakob fali neme Padan Aram mai, Manetualain natudu Mataon bali, ma Ana feen babaꞌe-babatik. ");
INSERT INTO llg_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Lamatuak kokolak, nae, “Mulai neme hatematak ia mai, o nadem taa Yakob so bali. Tehuu, Au fee o nade beuk, fo ndia, Israꞌel. ");
INSERT INTO llg_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Au ia, Manetualain fo Mana Koasa Manai Lain Seli. De, o bonggi, maumbu, makadotok leo! Dei fohataholi nusa kala kalua leme o numbu-sadu mala mai. Ma, dei fo o bonggi mala mane kala. ");
INSERT INTO llg_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Nusak fo Au fee o baꞌim Abraham, ma amam Isak ndia so, hatematak ia, Au feen neu o, ma o numbu-saꞌdu mala.” ");
INSERT INTO llg_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","14","Manetualain kokolak basa leondia, boe ma Yakob nambadedei dii batu esa neu ndia, fo ela ana dadik neu tanda nasanenedak neu Manetualain hehelun ndia. Boe ma, ana diꞌa anggol oek, ma mina neu batu lain, de ana nakaluku-nakatele neu Manetualain. ");
INSERT INTO llg_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Mamanak ndia, ana foin nade Betel. ");
INSERT INTO llg_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Basa ndia, boe ma Yakob asa laꞌo ela Betel. Faik fo ala bei doo-doo ana, lo Efrata, (fo ndia Betlehem), naa te Rahel fai bobonggin losa. Tehuu ana bonggi nakaleleꞌok. ");
INSERT INTO llg_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Ledoeik ana bei nakanasa nalan seli, boe ma ina mana makabobonggik nafadan nae, “Ina Rahel! Tao matetea o dalem, huu ina hambu ana touanak esa bali!” ");
INSERT INTO llg_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Ledoeik sangga ketu Rahel ani hahaen, boe ma ana foi kakanak ndia nade, Ben-Oni, (fo ndandaan nae, ‘kakana doidosok’). Basa ndia, boe ma ana mate. Tehuu Yakob ana foi kakanak ndia, nade Benyamin (fo ndandaan nae, ‘kakana lima kona’). ");
INSERT INTO llg_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Basa boe ma, ala latoi Rahel neu dalak bifin, fo mana sangga neni Efrata neu (fo hatematak ia, naden Betlehem). ");
INSERT INTO llg_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Boe ma, Yakob nambadedei batu lates esa neu ndia. Losa faik ia boe oo, Rahel batu laten ndia, bei nai dia. ");
INSERT INTO llg_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Basa ndia, boe ma Yakob ana huꞌa lali-lali nakandoo. Laꞌi esa, ana nambadedei uma temak neme manara Eder boboan. ");
INSERT INTO llg_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Faik fo leme ndia, Ruben ana sunggu no aman sao nakaboin, Bilha. Yakob bubuluk dedeꞌak ndia. Yakob ana touna nala sanahulu dua. ");
INSERT INTO llg_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Lea ana nala, Ruben (Yakob ana ulun), Simeon, Lewi, Yahuda, Isaskar, ma Sebulon. ");
INSERT INTO llg_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Rahel ana nala, Yusuf ma Benyamin. ");
INSERT INTO llg_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Rahel atan Bilha, ana nala, Dan ma Naftali. ");
INSERT INTO llg_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Boe ma, Lea atan Silpa ana nala, Gad, ma Aser. Bonggi kakana kala ia, leme Padan Aram. ");
INSERT INTO llg_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Basa ndia, boe ma Yakob neu tilo aman Isak neme Mamre dekak no nggolo Kiriat Arba (ndia hatematak ia, nade Hebron). Makahulun, baꞌin Abraham leo neme ndia boe. ");
INSERT INTO llg_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","29","Isak nasoda losa ndia teun natun esa falu hulu, bei fo maten. Boe ma, ndia ana nala, Esau ma Yakob, ala latoin. ");
INSERT INTO llg_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Ia Esau numbu-sadu nala. Ndia nade feꞌen Edom boe. ");
INSERT INTO llg_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau sao ina Kanaꞌan dua. Esa, hataholi Het, ndia Elon ana inanan, naꞌde Ada. Kaduan, hataholi Hewi, nade Oholibama. Ndia aman, nade Anah, ma ndia baꞌin, nade Sibeon. ");
INSERT INTO llg_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Esau sao Ismael ana inanan esa boe, nade Basmat. Basmat anan, nade Nebayot. ");
INSERT INTO llg_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Esau sao ulun, Ada, bonggi Elifas. Basmat bonggi Rehuel. ");
INSERT INTO llg_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Boe ma, Oholibama bonggi Yeus, Yalam ma Kora. Bonggi basa Esau ana nala, leme Kanaꞌan. ");
INSERT INTO llg_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Laꞌi esa, Esau huꞌa neni nusa feꞌek neu, fo dook neme Yakob mai. Ana no ndia sao-ana nala, hataholi manatao ue-ledis, banda la, ma basa ndia hata nala. ");
INSERT INTO llg_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Esau kofeꞌe no Yakob, huu sila banda nala noꞌun seli, de ala lasoda lakaseꞌe lai nusak ndia. ");
INSERT INTO llg_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Boe ma, Esau (ndia Edom), neu leo nai lete-letek manai Seir. ");
INSERT INTO llg_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Ia, Esau numbu-sadu nala, fo lae, ‘hataholi Edom’. Ala leo lai dae babaꞌe lete-letek nai Seir. ");
INSERT INTO llg_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","13","Esau saon Ada, ana bonggi ana touanak esa nade Elifas. Elifas ana touanan lima, sila: Teman, Omar, Sefo, Gatam ma Kenas. Elifas sao nakaboin, nade Timna. Ana bonggi ana tou-anak esa, nade Amalek. Esau saon Basmat, bonggi ana tou-anak esa, nade Rehuel. Rehuel hambu ana touanak haa, sila: Nahat, Sera, Syama, ma Misa. ");
INSERT INTO llg_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Esau saon Oholibama, na, ndia Anah anan, fo Sibeon umbun ndia, ana bonggi ana touanak telu, sila: Yeus, Yalam ma Kora. ");
INSERT INTO llg_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","16","Esau umbu-ana nala lababaꞌe dadik leo noꞌuk. Esa-esako no ndia mane leon. Esau ana ulun Elifas, ana nala mane leo Teman, mane leo Omar, mane leo Sefo, mane leo Kenas, mane leo Kora, mane leo Gatam, ma mane leo Amalek. Basa sala sila, Esau saon Ada numbu-sadu nala. ");
INSERT INTO llg_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Esau anan Rehuel, ana nala dadik mane leo Nahat, mane leo Sera, mane leo Syama, ma mane leo Misa. Basa sala, Esau saon Basmat numbu-sadu nala. ");
INSERT INTO llg_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Esau saon Oholibama ana nala, dadik mane leo Yeus, mane leo Yalam, ma mane leo Kora. ");
INSERT INTO llg_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Basa leo la sila, Esau numbu-sadu nala. ");
INSERT INTO llg_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Nai mamanak ndia, hambu hataholi Hori esa, nade Seir. Ndia ana nala lababaꞌek, de ala dadik leo noꞌuk. Esa-esak no ndia mane leon. Boe ma, ndia ana nala, dadi mane leo Lotan, mane leo Sobal, mane leo Sibeon, mane leo Anah, mane leo Dison, mane leo Eser, ma mane leo Disan. ");
INSERT INTO llg_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotan ana nala, sila, Hori no Heman (Lotan feton, nade Timna). ");
INSERT INTO llg_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobal ana nala, sila: Alwan, Manahat, Ebal, Sefo, ma Onam. ");
INSERT INTO llg_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Sibeon ana nala, sila, Aya, ma Anah. Anah ndia, natonggo no oe mata matoꞌbik nai moo salaek, neu faik fo ana hoo ndia aman banda keledei nala. ");
INSERT INTO llg_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","26","Anah ana inanan, sila, Oholibama, ma ana touana nala, ndia, Dison. Dison ana nala, sila: Hemdan, Esban, Yitran, ma Keran. ");
INSERT INTO llg_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Eser ana nala, sila, Bilhan, Saꞌawan, ma Akan. ");
INSERT INTO llg_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disan ana nala, Us ma Aran. ");
INSERT INTO llg_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","De, mane leo mane leo hataholi Hori la, sila: Lotan, Sobal, Sibeon, Anah, Dison, Eser ma Disan. Basa sala leo lai Seir. ");
INSERT INTO llg_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Faik fo nusa Israꞌel manen bei taa, tehuu nai dae Edom hambu manek so. Sila nade nala latutungga aok, ndia: ");
INSERT INTO llg_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela, fo Beor anan, ana dadik manek nai kota Dinhaba. ");
INSERT INTO llg_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela maten, boe ma Yobab nggatin, dadi manek. Ndia aman, nade Sera neme nggolo Bosra mai. ");
INSERT INTO llg_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yobab maten, boe ma Husam nggatin dadik manek. Husam ndia, neme hataholi Teman asa nusan mai. ");
INSERT INTO llg_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husam maten, boe ma Hadad nggatin dadik manek. Aman, nade Bedad neme nggolo Awit mai. (Ndia ndia, senggi hataholi Midian neu faik ala latati leme Moab.) ");
INSERT INTO llg_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadad maten, boe ma Samla nggatin dadik manek. Samla ndia, neme nggolo Masreka mai. ");
INSERT INTO llg_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samla maten, boe ma Saul nggatin daꞌdi manek. Saul ndia, neme nggolo Rehobot mai, nai lee bifin. ");
INSERT INTO llg_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Saul maten, boe ma Baal Hanan nggatin dadik manek. Aman, nade Akbor. ");
INSERT INTO llg_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Baal Hanan maten, boe ma Hadar nggatin dadik manek. Hadar ndia, neme nggolo Pau mai. Saon, nade Mehetabel. Mehetabel aman, nade Matret. Ma ndia baꞌin, nade Mesahab. ");
INSERT INTO llg_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","De, mane leo mane leo neme Esau mai, sila: Timna, Alwa, Yetet, Oholibama, Ela, Pinon, Kenas, Teman, Mibsar, Magdiel, ma Iram. Ala esa-esako foi sila nade hehelin, neu sila nusa nala. De, basa sila, Esau numbu-sadu nala, fo hataholi Edom asa tutuin. ");
INSERT INTO llg_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","2a","Ia Yakob asa tutuin. Fain, Yakob neu leo seluk bali nai dae Kanaꞌan. Ndia, aman Isak mamana leleon neme makahulun mai. ");
INSERT INTO llg_vpl VALUES ("GN37_2b","002_37_2b","GEN","37","2b","2b","Faik ndia, Yakob anan esa neme saon Rahel mai, nade Yusuf. Ndia teun sanahulu hitu, de no kaꞌa nala lateme leu lanea noꞌu sila biꞌiae-biꞌilombo nala. Ndia kaꞌa nala, anak neme Yakob saon Bilha ma Silpa mai. Tehuu Yusuf ia, ana lateme nafada aman, laꞌeneu kaꞌa nala tatao-nonoꞌi nala. ");
INSERT INTO llg_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Faik fo bonggi Yusuf, Yakob namalasi so. Huu ndia, de ana sue Yusuf lena heni ndia ana feꞌe nala. Laꞌi esa, Yakob fee seu badu naluk malole hiak esa soa nue Yusuf. ");
INSERT INTO llg_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Kaꞌa nala lita aman sue Yusuf lena heni sila, de ala lamanasan lalan seli, losa tala nau kokolak malolen lon so bali. ");
INSERT INTO llg_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","7","Leꞌodaek esa, Yusuf nalameꞌi. Boe ma ana tui mein ndia neu kaꞌa nala nae, “Wei! Ei mamanene dei! Au alameꞌi ae ita basa-nggata mbaꞌa hade-gandum nai osi dale. Boe ma au hadeng nambadeik lido-lido. Tehuu ei hade mala lambadeik eꞌo, de kauk au enang.” Kaꞌa nala lamanene leondia, boe ma ala boe lamanasan bali. ");
INSERT INTO llg_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","De ala kasilangga Yusuf lae, “Amakee! O maehetuk o sangga dadik malanggan fo palenda ai, bae?” Ala lamanasa ndia lalan seli, huu ana nafada meꞌis ndia. ");
INSERT INTO llg_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Basa ndia, boe ma Yusuf nalameꞌi seluk bali. Boe ma nafada kaꞌa nala, nae, “Wei! Au alameꞌi bali. Au ita ledo, bulak, ma nduuk sanahulu esa. Basa sala lakatele neu au.” ");
INSERT INTO llg_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Boe ma, Yusuf neu tui meꞌis ndia neu aman ma kaꞌa nala. Tehuu aman kasilanggan no hala belak nae, “Meꞌi leo hatak ndia! O duduꞌa maehetuk au, ma inam, ma kaꞌa-faꞌdi mala, ai mai fo idu o eim? O hihiim dei!” ");
INSERT INTO llg_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","De Yusuf kaꞌa nala ala dale hedi ndia lalan seli. Tehuu aman duduꞌa doak meꞌis ndia. ");
INSERT INTO llg_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Boe ma, faik esa, Yusuf kaꞌa nala leni sila aman biꞌiae-biꞌilombo nala losa dekak no nggolo Sikem. ");
INSERT INTO llg_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Taa dook boe ma, aman nae, “Usu aa! Kaꞌam asa lanea biꞌiae-biꞌilombo la deka-deka nai Sikem. De, mahehele, fo muu tilo sala dei.” Boe ma, Yusuf nataa nae, “Hei, ama.” ");
INSERT INTO llg_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Boe ma, aman nae, “O muu dei, fo tilo o kaꞌa mala ma au biꞌiae-biꞌilombo-nggala. Ala talobee so, na, o fali mai mafada au.” Boe ma, Yusuf laꞌo ela dae Hebron moon, de neu nakandoo losa nai Sikem. ");
INSERT INTO llg_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Losa ele, de ana sangga nafeo kasa nai mook ndia. Basa de, ana natonggo no hataholi esa, de hataholi ndia natanen nae, “O sangga hata?” ");
INSERT INTO llg_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Boe ma, Yusuf nataa nae, “Ama. Au sangga au kaꞌa nggala. Ala hoo biꞌiae-biꞌilombo sangga naꞌu deka-deka nai ia. Ama mita sala boe, do?” ");
INSERT INTO llg_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Boe ma, hataholi ndia nafadan nae, “Ala taa lai ia so. Huu lae, ala sangga leni deka-deka lai nggolo Dotan.” Basa boe ma, Yusuf neu tungga kaꞌa nala, losa nita sala leme Dotan. ");
INSERT INTO llg_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Tehuu, Yusuf bei nai dook, tehuu ala litan so. Boe ma, ala lala halak, fo sangga tao lisan. ");
INSERT INTO llg_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Boe ma, sila esa nafada esa nae, “Ei mita dei. Malangga mana malameꞌik mai so! ");
INSERT INTO llg_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","De, mai leo fo ata tao tisan. Basa, na, ata mbian neni oe mata madak ndia dale neu. Dei fo ata tafada ama, tae, banda fui la laꞌa henin so! Bei fo ita tita ndia meꞌi nala sila leobee!” ");
INSERT INTO llg_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Kaꞌan Ruben namanene leondia, boe ma ana sangga dalak fo sangga ana nasalaꞌe Yusuf. Boe ma, ana nafada fadi nala nae, “Wei! Boso ata tao tisan, bae! ");
INSERT INTO llg_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Malolenak kada ata mbian neni oe mata madak dale neu. Nai ia mamana nes, de taa hambu hataholi bubuluk. Sadi boso tao madaan.” Ana kokolak leondia, na, huu ana sangga mboꞌi heni Yusuf, fo nadenun fali. ");
INSERT INTO llg_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Boe ma, ledoeik Yusuf losa sila, boe ma kaꞌa nala ala humu lalan, de ala luꞌi heni baꞌdu malolen ndia. ");
INSERT INTO llg_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Basa ndia, boe ma ala hela loloson, de ala timban neni oe mata madak ndia dalek neu. ");
INSERT INTO llg_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Basa boe ma ala fali leu laꞌa. Ala bei laꞌa-laꞌa, tehuu nggengge neuk, ala lita hataholi bubuak esa mai. Hataholi bubua kala sila banda onta nala, fua leni bua danggan, leo ai daa kaboo menik, bumbu-fani, ma akidoo mata-matak. Naa te, bubuak ndia hataholi Ismael asa leme nggolo Gilead mai, fo ala sangga leni dook leu nai Masir. ");
INSERT INTO llg_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Basa ndia, boe ma Yahuda nafada kaꞌa-faꞌdi nala nae, “Wei! Malolenak kada leo iak. Ata boso tao tisan. Ndia nanalan taa? Mae leobee boe oo, ita taa bisa tafuni tala ndia daan. ");
INSERT INTO llg_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Malolenak ata seꞌon neu hataholi Ismael asa sila. Mae ita taon leobee boe oo, ita bei fadi bonggin ndia. Huu ndia, de boso ata tao tahedin, bae!” Boe ma, basa sala lakaheik ndia kokolan ndia. ");
INSERT INTO llg_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Basa ndia boe ma ndandaak no hataholi mana dangga nala sila, ala lesik ndia, boe ma Yusuf kaꞌa nala helan neme oe matak ndia dalek mai. Boe ma, ala seꞌon neu hataholi Ismael sila, belin doi lilo fulak dua hulu. Basa ndia, boe ma ala loo Yusuf neni Masir neu. ");
INSERT INTO llg_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Faik fo ala seꞌo Yusuf ndia, naa te Ruben taa bubuluk. De ledoeik ana fali neni oe matak ndia neu, boe ma ana nggengge nalan seli, huu Yusuf taa kana so bali. Boe ma, ana sisii baloꞌa papaken manai aon, huu dalen hedis nalan seli. ");
INSERT INTO llg_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Boe ma, ana fali neni faꞌdi nala neu de nae, “Awii! Kakanak taa kana so bali nai ndia! De hatematak ia, au tao hata bali?” ");
INSERT INTO llg_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Basa de ala hala lala biꞌiaek esa, de ala haꞌi lala Yusuf baꞌdu malolen ndia, de ala dinan neni daak dale neu. ");
INSERT INTO llg_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Boe ma, ala haꞌi lala badu kaꞌdaak ndia, de lenin neu sila aman, de ala lafada lae, “Ama aa! Ai hele mala badu ia. Hena ama mita suꞌdi kana dei. Naafo fadi Usu badun ia.” ");
INSERT INTO llg_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Nita badu ndia, boe ma Yakob nalela tuti kana. Boe ma, nataa nae, “Awii! Memak au anang badun ia. Taa bubuluk banda fui ana sii nalan neme bee. Awii! Au anang maten so!” ");
INSERT INTO llg_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Basa ndia, boe ma Yakob sisii badun, de ana pake karon akinaak, huu ana dale hedi nalan seli. Boe ma, namatani nakaleleu nakandoo ndia anan, losa doon seli. ");
INSERT INTO llg_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Basa ndia boe ma ana touana nala ma ana inana nala kokoen, tehuu taa lala sana. Ana nae, “Taa! Au bisa dale heꞌdi losa mate, huu au taa bisa afalende heni kakanak esak ia.” Boe ma, Yakob dale heꞌdi nakandoo, huu nasaneda ndia anan Yusuf maten so. ");
INSERT INTO llg_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Faik fo Yakob bei dale hedi leondia, naa te hataholi manadanggan sila losa Masir so. Boe ma ala seꞌo Yusuf neu hataholi inahuuk esa, nade Potifar. Ndia ndia, mane Masir malangga mana manean. ");
INSERT INTO llg_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Basa ndia, boe ma Yahuda laꞌo ela ndia kaꞌa-faꞌdi nala, de neu leo no ndia nonoon Hira, nai nggolo Adulam. ");
INSERT INTO llg_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Nai ndia, hambu touk esa, hataholi Kanaꞌan, ndia naden Sua. Yahuda nahiik no Sua ana inanan esa, boe ma dua sala sao. Basa ndia, boe ma ana bonggi ana touana kala latutunggak. ");
INSERT INTO llg_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Ana uluk, ala foin nade, Er. ");
INSERT INTO llg_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Boe ma, kaduan, ala foin nade, Onan. ");
INSERT INTO llg_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Basa de katelun, nade Sela. Faik fo bei taa bonggi Sela, tehuu ala huꞌa leni nggolo feꞌek leu so, nade Kesib. ");
INSERT INTO llg_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Faik fo ana uluk, Er, inahuu so. Boe ma, Yahuda neu natane feen inanak esa, nade Tamar. Basa de dua sala sao. ");
INSERT INTO llg_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Tehuu Er manggalaun ana seli. Huu ndia, de Manetualain huku nisan. Huu ndia, de Er ana mate, tehuu taa ela anak. ");
INSERT INTO llg_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Basa ndia, boe ma Yahuda nadenu ndia ana kaduan nae, “Onan! O kaꞌam maten, tehuu anan taa. De, hatematak ia, tungga lasi kala hadan, na, o musi nggati kaꞌam fo sao mala ndia saon. Fo ela o fee kaꞌam numbu-saꞌduk.” ");
INSERT INTO llg_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Onan bubuluk hadak ndia so. Tehuu ana taa nau fee kaꞌan Er numbu-saꞌduk. De mete ma ana sunggu no Tamar, na nakalalambu heni ndia binin, fo ela Tamar boso bonggi. ");
INSERT INTO llg_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Onan tatao leondian, tao nala Manetualain luli nalan seli! Huu ndia, de Manetualain huku nisan. ");
INSERT INTO llg_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Faik fo Yahuda nita ndia ana kadua nala sao Tamar de mate sala, boe ma dadik ana bii. Ana duduꞌa nae, boso losak ndia ana mulin Sela sao nala Tamar bali, boe ma maten boe. Huu ndia, de neu nafada ndia fetofeun Tamar, nae, “Ana-nggo ei. Malolenak o fali muni o inamam muu leo. Dei fo au anang Sela inahuu so, na, bei fo o fali mai, fo sao ndia.” Boe ma, Tamar fali. ");
INSERT INTO llg_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Taa dook bali, boe ma mate Yahuda saon. De ana dale heꞌdi losa basa fai fafaluk. Boe ma, ana noke ndia nonoon Hira, fo dua sala leni nggolo Timna leu. Nai ndia, hataholi la nggute biꞌilombo bulu, fo seꞌo. ");
INSERT INTO llg_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Boe ma, hataholi la lafada Tamar lae, “O aliamam neni Timna neu, fo ana tungga feta nggute biꞌilombo bulu.” ");
INSERT INTO llg_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Faik ndia Yahuda ana-mulin Sela inahuuk so. Tehuu Tamar bubuluk so, nae, aliaman taa nau ana sao Sela. Boe ma, Tamar sangga dalak fo noke ndia hak. De ana oꞌdu heni ndia bua ina-falun, de ana nggati baloꞌa papake malole. Ana pake lafanak fo ana lalaa neu langgan ma matan. Boe ma, ana nanggatuuk neu nggolo Enaim lelesu inan, fo nandaa no dalak neni Timna neu. ");
INSERT INTO llg_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Leꞌdoeik Yahuda nesik lelesu ina ndia, boe ma ana nita inak esa. Nae hetuk ina kalabik ndia, huu Tamar heo-hilu no baloꞌan, de ana babaa matan bali. ");
INSERT INTO llg_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Yahuda taa duꞌa nae, inak ndia, ndia fetofeun. De, neu deka-deka no inak ndia, de natanen nae, “Wei! Mete ma au ua o, na, o moke baꞌu bee?” Tamar nataa nae, “Neu! Neme kada Ama hihiin mai.” ");
INSERT INTO llg_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Yahuda kokoe nae, “Leo bee, mete ma au fee o biꞌiaek esa?” Boe ma, Tamar bala nae, “Hei, Ama. Sadi fee au toꞌu bua namahehelek esa dei. Losa sudi faik bee bei fo Ama haitua biꞌiaek ndia mai.” ");
INSERT INTO llg_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","19","Boe ma, Yahuda natane bali nae, “Au fee o bua namahehelek hata?” Tamar nataa nae, “Ama ela cap fo mana londa-londak ndia, ma ndia talin ndia Ama lesuhaꞌin ndia. Ma ela teteꞌe-aik ndia boe.” Yahuda namanene leondia, boe ma ana fee bua sala sila neu ndia. De, dua sala sunggu sama-sama. Basa ndia, boe ma Tamar fali. Ana oꞌdu heni ndia baloꞌa malolen ndia, ma ndia lafanan ndia, de ana pake seluk ndia baloꞌa papake ina falun. Naa te, Tamar nailu so. ");
INSERT INTO llg_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Taa dook so bali, boe ma Yahuda noke tulun ndia nonoon Hira, nae, “O muni biꞌiaek ia fee ina kalabik ndia, nai Enaim ele, fo haꞌi falik au bua nggala fo ana toꞌuk ndia.” Hira neu losa ele, de natane neu-mai, tehuu taa natonggo no inak ndia. ");
INSERT INTO llg_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Boe ma, ana natane hataholi la malai ndia kala, nae, “Wei! Ei mita ina kalaꞌbik esa, ana nateme nanggatuuk nai lelesu ina ia, do? Ana nai bee bae?” Tehuu lataa lae, “Ama, ina kalabik taa nai ia.” ");
INSERT INTO llg_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Boe ma, Hira fali neni Yahuda neu. Ana nafadan nae, “Au taa atonggo ua inak ndia. Au asanggak, tehuu hataholi la lai ele lafaꞌda lae, nai mamanak ndia, taa hambu ina kalabik.” ");
INSERT INTO llg_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yahuda nataa nae, “Ela bua sala sila leo, fo ana soan leo! Sadi hataholi la boso lakamamaek ita! Huu au nau bae so, tehuu ita taa tatonggo to ndia.” ");
INSERT INTO llg_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Seli bulak telu, boe ma hataholi neu nafada Yahuda nae, “O fetofeun Tamar ndia, ana tao aon dadik ina kalaꞌbik. De hatematak ia, nailu so.” Yahuda namanene leondia, boe ma ana luli nalan seli. Boe ma, ana palenda hataholi ndia, nae, “Muu hela mua inak ndia mai, fo hotu kanalao kana!” ");
INSERT INTO llg_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Boe ma, leu hela lo Tamar mai, tehuu ana kalua heni cap no teteꞌe-aik. De nadenu ala leu lafaꞌda ndia aliaman lae, “Ama, tulun palisak bua sala ia dei. Hataholi maena cap ma teteꞌaik ia, ana tao nailu au.” ");
INSERT INTO llg_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yahuda nita bua sala sila, boe ma ana nalelak tuti kana, de nae, bua sala ia ndia enan. Boe ma, nafada nae, “Memak inak ndia taa sala. Au ndia sala. Tetebes ndia Huu ndia, de au musi akasasao kana no au anang Sela. Tehuu au ndia taa nau. Mboꞌi henin leo!” Basa boe ma, Yahuda taa nakabubua so bali no Tamar. ");
INSERT INTO llg_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Tamar fai bobonggin losa, boe ma ana bonggi kakana kaduak. ");
INSERT INTO llg_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Faik ana bonggi, anak esa lima ana deak mai. Boe ma, ina makabobonggik mbaꞌa aba mbilas neu liman. Ana nae, “Ia ndia uluk.” ");
INSERT INTO llg_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Tehuu kakanak ndia ana hela falik liman. Boe ma, ndia nonoo kaduan kalua nakahuluk. Ina makabobonggik ndia nafada neu kakanak ndia, nae, “Wei, o ia balakain ana seli. Huu ndia de o makaseseti makahuluk deak mai.” De ala foi kakanak ndia, nade Peres (ndandaan nae, ‘nakaseseti deak mai’). ");
INSERT INTO llg_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Basa, bei fo fadik nana mbaꞌa aba mbilas ndia kalua. Ala foin naꞌde, Sera (fo ndandaan nae, ‘mbila manggadedek’). ");
INSERT INTO llg_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","2","Fain hataholi Ismael asa, loo Yusuf neni Masir neu. Nai ndia, hambu hataholi inahuuk esa, nade Potifar. Ndia ndia, malanggan neme basa soldadu mana maneak nai mane Masir uma manen. Basa boe ma, Potifar hasa nala Yusuf neme hataholi manadangga nala mai, de ana dadik ata nai ndia uman. Nai ndia, LAMATUAK fali nala Yusuf, losa basa ndia ue-ledin dadik no malole. ");
INSERT INTO llg_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Ndia malanggan nita Yusuf ue-ledin neulauk, boe ma ana bubuluk no teteꞌben LAMATUAK fali nala Yusuf. ");
INSERT INTO llg_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Huu ndia, de, ndia malanggan hii Yusuf, ma namahelen. Boe ma, ana soꞌu Yusuf dadik mandor nai ndia uman. Ndia boe oo, ana fee Yusuf nakaneni ndia uman no basa ndia pusaka nala. ");
INSERT INTO llg_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Huu Yusuf leo nai ndia, de Manetualain fee ndia malanggan, fo hataholi Masir ndia babaꞌe-babatik. Ndia uma isi nala, ndia pusaka nala, ndia osin, ma ndia ue-leꞌdin, basan dadi no malole. ");
INSERT INTO llg_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Boe ma, faik fo Potifar nita Yusuf nakaneni basa ue-ledin no malole, de ana taa duduꞌa hata-hata so bali, de, nalelak kada naꞌa. Faik ndia, Yusuf mataon lolen seli. ");
INSERT INTO llg_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Ana leo nai ele bei taa dook nalan seli, tehuu Potifar saon dalen tuda neun so. Boe ma, ana kokoe Yusuf fo sangga ana sunggu non. ");
INSERT INTO llg_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Tehuu Yusuf taa nau. De nataa nae, “Boso leondiak, Ina! Huu au malanggang Potifar, fee au koasa fo au akaneni basa ndia ue-ledin. ");
INSERT INTO llg_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Nai uma ia, taa hambu hataholi so bali fo ana toꞌu koasa lena heni au. Huu malanggan fee au akaneni basa-basan. Kada ina, na, taa. Talobee fo au bisa tao manggalauk leoiak! Ndia laꞌban Manetualain hihiin!” ");
INSERT INTO llg_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Mae leondiak boe oo, tungga-tungga faik, malanggan ndia saon nambue kokoe nakandoo. Tehuu Yusuf taa mbali sana. ");
INSERT INTO llg_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Boe ma laꞌi esa, de Yusuf maso neni uma dale neu, fo sangga ana susuli ndia ue-leꞌdin. Faik ndia, taa hambu hataholi feꞌek nai uma. ");
INSERT INTO llg_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Boe ma, ndia malanggan saon mai de ana toꞌu nala Yusuf badun, de ana hela nalan, de nae, “Mai leo! Hatematak ia ela kada ita dua nggata. Mai leo fo dua-nggata teu sunggu.” Tehuu Yusuf taa nau. Boe ma, ana nafoki, losa posi heni ndia badun. Boe ma nalai deak neu. Tehuu inak ndia, bei ana toꞌu nahele badu ndia. ");
INSERT INTO llg_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Ledoeik Potifar saon nita Yusuf nalai deak neu, laꞌo ela badun, ");
INSERT INTO llg_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","15","boe ma ana nanggou hataholi mana tao ue-ledi sala, de nafaꞌda nae, “Wei! Ei mai dei! Isinaak, tou Ibrani ndia, ana maso neni au kamang dale neu. Ana sangga tao manggalauk neu au, tehuu au eki tingga-tingga. Ia, ana laꞌo ela ndia badun, de nalai deak neu. Au saong ia, neni hataholi hada manggalauk ia, fo kada ana tao nakamamaek ita!” ");
INSERT INTO llg_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Boe ma Potifar saon toꞌu nahele badu ndia, losa saon fali. ");
INSERT INTO llg_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Nandaa no saon fali, boe ma ana tuin nae, “Kaꞌa aa! Hataholi Ibrani ndia fo Kaꞌa nenin ia mai ndia, isinaak ana maso neni au kamang dale neu, fo sangga ana sao nakasetik au! ");
INSERT INTO llg_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Tehuu au eki atingga oke hataholi la. Boe ma, ana nalai neu fuik, laꞌo ela ndia badun ia.” ");
INSERT INTO llg_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Potifar namanene saon tutuin leondia, boe ma ana luli nalan seli. ");
INSERT INTO llg_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","De nadenu hataholi la leu humu lala Yusuf. Boe ma, ala taon neni manek buin dale neu. ");
INSERT INTO llg_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Tehuu LAMATUAK taa nafalende heni Yusuf. Huu ndia, de, LAMATUAK Ana tulu-fali nalan nakandoo, losa bui ndia malanggan hii Yusuf nalan seli. ");
INSERT INTO llg_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Boe ma, ana namahele Yusuf. Huu ndia, de ana fee Yusuf nakaneni basa hataholi bui la, ma basa ue-ledis manai ndia kala. ");
INSERT INTO llg_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","De malanggan taa mbali nakaneni hata-hata so bali, nai bui ndia. LAMATUAK tulu-fali nala Yusuf, de ana tao basa ue-leꞌdin nai bui ndia, dadi malole. ");
INSERT INTO llg_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","3","Faik ndia, hambu malangga mana makanenik dua lai mane Masir uma manen. Esak, ana nakaneni manek nininun, ma esa bali, ana nakaneni manek lotin. Dua sala tao lasala manek. Huu ndia, de manek luli, losa ana tao sala leni bui dale leu. De dua sala leo kama esa lo Yusuf. ");
INSERT INTO llg_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Boe ma, malangga bui ndia, palenda Yusuf fo nakaneni pegawe kadua kala sila. Ala leo lai ndia losa teuk esa do dua. ");
INSERT INTO llg_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Leodaek esa, pegawe kadua kala sila lalameꞌi. Esa-esako no ndia meꞌi hehelin. Ma meꞌis ndia ndandaan nala kofeꞌe. ");
INSERT INTO llg_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Foꞌa mai, boe ma Yusuf mai, de nita dua sala mata nala mana dale hedik. ");
INSERT INTO llg_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Boe ma ana natane sala nae, “Hatina de, leledon ia ei dua nggei mata mala bei male leondiak?” ");
INSERT INTO llg_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ala lataa lae, “Leꞌodaek ai malameꞌi, tehuu ai taa bubuluk ndandaan.” Yusuf kokolak nae, “Taa hambu hataholi ana bubuluk meꞌi sala ndandaan, tehuu kada Manetualain mesa kana. Hena ei tuin dei. Dei fo au sangga bubuluk ndia ndandaan neme Manetualain mai.” ");
INSERT INTO llg_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Basa ndia, boe ma hataholi mana makaneni manek nininun, tui nae, “Leoiak. Nai au meꞌing au ita ai anggol esa, ");
INSERT INTO llg_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","baꞌek telu. Ai ndia tutik nadoo, nabuna, naboa mangginggikk losa latuk. ");
INSERT INTO llg_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Boe ma au ita, au toꞌu manek nggalaa nininun. Boe ma au haꞌi ala anggol boan, de au heꞌen neni manek nggalaan dale neu. Basa ndia, boe ma au loo fee manek ninu.” ");
INSERT INTO llg_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yusuf namanene leondia, boe ma ana nafada nae, “Ama. Meꞌis ndia ndandaan leoiak: baꞌe kateluk ndia, na ndandaan faik telu. ");
INSERT INTO llg_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Nai faik telu ia, dei fo manek kalua heni ama neme bui ia mai. Boe ma ana soꞌu falik ama, fo makaneni seluk ndia nininun leo makahulun. ");
INSERT INTO llg_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Mete ma, ama ua-nalen malole leondiak so, na, boso mafalende heni au baa! Mete ma ama sue au, na, tulun mafada manek, fo ndia boe oo ana kelua heni au uma mamanak ia mai. ");
INSERT INTO llg_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Huu tungga teteꞌben, ala haꞌi lakasetik au uma hataholi Ibrani nggolon mai. Nai ia boe oo, au taa tao manggalauk hata-hata. Naa te ala tao au uni bui ia dalek uu, nonook leo au ia hataholi manggalauk.” ");
INSERT INTO llg_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Hataholi mana makaneni loti namanene nala meꞌis ndia ndandaan neulauk leondia, boe ma ana tui Yusuf nae, “Fadi aa. Au boe oo, alameꞌi leoiak: au suu lembeneu telu lakatotodok. ");
INSERT INTO llg_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Nai lembeneu manai lain, isin manek kokin mata-mata kala. Tehuu mbui kala mai, de laꞌa heni basa kokis sila leme au langgang lain.” ");
INSERT INTO llg_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yusuf namanene leondia, boe ma ana nataa, nae, “Ama meꞌin lembeneu kateluk sila, ndandaan faik telu boe. ");
INSERT INTO llg_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Nai faik telu ia, dei fo manek nadenu hataholi mai tete heni ama langgan. Boe ma, ala loloꞌe ama aon neu dii. De mbui kala mai laꞌa heni basa ama mbombolam.” ");
INSERT INTO llg_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Seli faik telu, nandaa no manek fai bobonggin, boe ma ana tao feta inahuuk fee basa ndia pegawe nala. Ana palenda fo ala leu kalua heni pegawe kadua kala sila, leme bui dale mai. ");
INSERT INTO llg_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Basa ndia, boe ma ana soꞌu fali pegawe mana makaneni manek nininun, neu ndia pangga makahulun, fo ana nakaneni manek nininun. ");
INSERT INTO llg_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Pegawe mana makaneni manek lotin ndia, ala londa lisan, sama leo Yusuf kokolan. ");
INSERT INTO llg_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Tehuu pegawe mana makaneni manek nininun ndia, taa nasaneda Yusuf so bali. Ana nafalende henin so. ");
INSERT INTO llg_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Seli teuk dua, boe ma mane Masir nalameꞌi. Ndia meꞌin, ana nambadeik nai lee Nil bifin. ");
INSERT INTO llg_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Nggengge, tehuu nita sapi maao hitu. Lou nala manggadilak. Ala kalua leme lee ndia mai, de laꞌa naꞌu lai ndia. ");
INSERT INTO llg_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Basa boe ma, sapi feꞌek hitu bali, leme lee ndia mai. Ao nala nggoda mana bebebok. Ala lambadei deka-deka lo sapi maꞌao la sila. ");
INSERT INTO llg_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Boe ma, sapi kahitu nggofa kala sila, kodo heni sapi kahitu maꞌao la sila. Boe ma manek nggengge, de ana foꞌa. ");
INSERT INTO llg_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Taa dook bali, boe ma ana namanee seluk. Boe ma ana nalameꞌi bali. Ana nita hade mbule neuk hitu ala kalua leme huu maꞌao esa mai. ");
INSERT INTO llg_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Boe ma nita, hade mbule langgak hitu bali, mana malek so, huu ala laꞌe ani matoꞌbik. ");
INSERT INTO llg_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Boe ma, basa hade mbule langga kala sila kodo heni basa hade mbule neuk kahitu kala sila. Basa boe ma, manek ana nggengge. Bei fo ana bubuluk, ana nalameꞌi seluk bali. ");
INSERT INTO llg_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Foꞌa fafain, boe ma manek nameda taa malole. De ana palenda hataholi la leu loke lala basa ndolu malela kala, ma hataholi malelak malai Masir. De ana tui ndia meꞌin neu sala, tehuu taa hambu esa ana bisa bubuluk meꞌis ndia ndandaan. ");
INSERT INTO llg_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Boe ma, pegawe mana makaneni manek nininun ndia, bei fo nasaneda Yusuf. Boe ma ana nafada manek, nae, “Ama manek. Au musi manaku au salang. ");
INSERT INTO llg_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Makahulun, faik fo ama luli au, ma au nonoong, de tao ai mini bui dale miu, ");
INSERT INTO llg_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","de leꞌodaek esa, boe ma ai dua nggai malameꞌi. Esa-esako no ndia meꞌin, ma ndandaan kofeꞌe. ");
INSERT INTO llg_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Nai bui ndia dalek, hambu hataholi Ibrani esa bei muli-soluk. Malangga bui soꞌun ana daꞌdik malangga mana makaneni nai bui ndia. Ai tui ai meꞌin neu ndia. Boe ma nafada meꞌis sila ndandaan. ");
INSERT INTO llg_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Tetebes ama manek soꞌu falik au, ma au nonoong ndia, nana huku nisak. De, basa ndia ndandaan sama leo hataholi Ibrani ndia kokolan!” ");
INSERT INTO llg_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Mane namanene leondia, boe ma ana nadenu hataholi lai-lai leu haꞌi Yusuf neme bui mai. Boe ma, Yusuf neu tao neulalau ao-inan, de ana nggati baloꞌa papaken, de ana neu nasale manek. ");
INSERT INTO llg_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Ana losa boe ma, manek kokolak nae, “Taꞌeanak aa! Au alameꞌi, tehuu taa hambu hataholi esa boe ana bisa nafada meꞌis ndia ndandaan. Tehuu hambu hataholi nafada au nae o bisa.” ");
INSERT INTO llg_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Boe ma Yusuf nataa nae, “Ama manek. Au boe oo taa bubuluk hata-hata. Kada Manetualain mesa kana bisa nafada no teteben meꞌis ndia ndandaan. Neu ko Ana nau nafada ama dedeꞌa neulauk.” ");
INSERT INTO llg_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Basa boe ma, manek tui nae, “Nai au meꞌing ndia, au ambadeik nai lee Nil bifin. ");
INSERT INTO llg_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Boe ma hambu sapi maꞌao hitu, ma lou nala manggadilak. Ala kalua leme lee ndia mai, de ala laꞌa naꞌu lai lee ndia bifin. ");
INSERT INTO llg_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Boe ma hambu sapi feꞌek hitu mai. Tehuu sapi la sila nggoda mana bebebok. Nai dae Masir ia, au bei taa ita itak sapi nggodak mata leondia! ");
INSERT INTO llg_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Tehuu au amanggonggoak alan seli! Huu kada nggengge boe ma sapi nggodak kahitu kala sila, kodo heni basa sapi maꞌao kahitu kala sila. ");
INSERT INTO llg_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Ala kodo basa, tehuu sapi la sila bei nggodak lahele. Boe ma au nggengge de au foꞌa. ");
INSERT INTO llg_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","23","Basa ndia, boe ma au amanee seluk bali, boe ma au alameꞌi seluk. Au ita hade mbule neuk hitu, ala kalua leme huu maꞌao esa mai. Boe ma, au ita hade mbule langgak hitu bali, mana male kala so, huu ala laꞌe ani matobik. ");
INSERT INTO llg_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Boe ma basa, hade mbule langga kala sila, kodo heni basa hade mbule neuk kahitu kala sila. Basa ndia, boe ma au foꞌa. De, au tui meꞌis ndia neu hataholi malela kala. Tehuu, taa hambu hataholi esa boe ana bisa nafada ndandaan.” ");
INSERT INTO llg_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Boe ma Yusuf nafada nae, “Ama manek. Meꞌi kadua kala sila ndandaan kada esak. Manetualain nafada memak ama manek, hata fo Ndia sangga taon. ");
INSERT INTO llg_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Meꞌis ndia ndandaan leoiak: sapi maꞌao kahitu kala sila, ma hade mbule neuk kahitu kala sila, ndia fai nakabeten teuk hitu. Sila ndandaan kada esak. ");
INSERT INTO llg_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Boe ma, sapi nggoda mana bebebok sila, ma hade mbule langgak kahitu kala sila, ndia fai ndoen teuk hitu. ");
INSERT INTO llg_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","De, Manetualain nafada memak hata fo Ndia sangga tao. Ndia sama leo au kokolang isinaak ndia so. ");
INSERT INTO llg_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Dei fo, ita hambu fai nakabeten losa teuk hitu nai basa mamanak fo nai nusa Masir ia. ");
INSERT INTO llg_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","31","Basa ndia, bei fo ita hambu fai ndoen losa teuk hitu. Dei fo fai ndoen ndia ana seli. Losa taa hambu nanaꞌak so bali nai nusak ia. Basa hataholi la ndoe lalan seli, losa ala taa bisa lasaneda fai nakabeten ndia bali. ");
INSERT INTO llg_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Naa! Ama manek hambu meꞌis losa laꞌi dua ndia, ndia ndandaan nae, Manetualain Ana heti memak so. Taa dook so bali, tehuu hata fo Ana hetik ndia, mulai dadi so. ");
INSERT INTO llg_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Huu ndia, de au fee duduꞌak leoiak: malolenak ama manek sangga mala hataholi malelak esa, fo ana bisa nakaneni no malole. Boe ma, soꞌu malan fo ana heti neulalau nusak ia. ");
INSERT INTO llg_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Nai fai nakabeten teuk hitu ndia, malolenak ama manek soꞌu mala hataholi feꞌek esa bali, fo ana nakaduduluk buna-boa lena kala. Buna-boak sila, baꞌe limak fo mbeda babaꞌek esa. ");
INSERT INTO llg_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Ala musi tungga ama manek palendan, fo ala haꞌi hade neme basa nggolo kala malai Masir mai. Boe ma, ala musi mbeꞌda hade sila lai mbole kala fo lanea neulalau sala. ");
INSERT INTO llg_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Fo, dei fo fai ndoen teu kahitu kala losa, na, ita bei kananaꞌak. Ma hetin leondiak, fo taa hambu hataholi mate no ndoes.” ");
INSERT INTO llg_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Manek no ndia pegawe inahuu nala lamanene Yusuf kokolak leondia, boe ma ala tungga Yusuf duduꞌan ndia. ");
INSERT INTO llg_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Boe ma manek kokolak nae, “Manetualain Dulan koasa memak Yusuf ia so. Huu ndia de ita taa bisa hambu hataholi feꞌek so, fo ana lena heni ndia.” ");
INSERT INTO llg_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Boe ma manek kokolak no Yusuf, nae, “Manetualain nafaꞌda basa ia neu o so. Hatematak ia, bei fo ai bubuluk mae, o ia malelak. Boe ma, o duduꞌam lena heni basa hataholi la. ");
INSERT INTO llg_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Huu ndia de hatematak ia, au soꞌu ala o dadik neu au lima konang. Dei fo basa au lau-inggu nggala tungga o palendam. Tehuu kada au mesang lena heni o.” ");
INSERT INTO llg_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","42","Basa ndia, boe ma manek odu nala ndia ndeli tendan, de ana odun neu Yusuf lima kuꞌun. Boe ma, ana kokolak nae, “No ia, au soꞌu ala o, dadik neu au lima konang nai basa nusa Masir ia.” Boe ma ana papake badu nalu bangganaꞌuk esa neu Yusuf, ma ana bokolii tali lilo mbilas neu lesuhaꞌin. ");
INSERT INTO llg_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Basa ndia, de ana fee ndia nggili ndala neulau kaduan neu, fo Yusuf saꞌe. Hambu hataholi nalaik nesik mata, ma nanggou taa-taa nae, “Wei! Soi dalak bou! Fee haꞌdak! Hambu hataholi inahuuk ana sangga nesik ia!” No tatao leondiak, manek soꞌu nala Yusuf dadik ndia lima konan nai dae Masir. ");
INSERT INTO llg_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Basa ndia, boe ma manek kokolak no Yusuf nae, “Leoiak. O bubuluk memak au ia manek. Tehuu au afada memak basa hataholi malai Masir ia, ae, mete ma o taa mboꞌi na, ala taa bole tao hata-hata.” ");
INSERT INTO llg_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Basa boe ma manek foi Yusuf nade, Safnat Panea, tungga hataholi Masir asa naden. Ndia boe oo ana nakasasaok Yusuf no inak esa, nade Asnat. Yusuf aliaman, nade Potifera. Ndia ndia, mana makaneni anggama nai Kota On. No leondiak, Yusuf dadik hataholi inahuuk nai Masir. ");
INSERT INTO llg_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Faik fo ala soꞌu Yusuf ndia, na, ndia teun telu hulu so. Basa ndia, de ana laꞌok ndule basa mamanak nai Masir. ");
INSERT INTO llg_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Nai fai nakabeten teuk hitu ndia, osi la buna-boan noꞌun ana seli. ");
INSERT INTO llg_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Boe ma, Yusuf nakaduduluk buna-boa lena kala sila, de ana mbedan. Buna-boa hade neme mamana kala, mana dekak no kota sudi bee, na, ana mbedan neu mbolek manai kota ndia. ");
INSERT INTO llg_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Hade nana nakadudulu nala kala ndia, noꞌun seli. Sama leo salaek malai tasibifi, sudi-tai nala sala so bali. ");
INSERT INTO llg_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Fai ndoen bei taa losa, tehuu Yusuf saon Asnat bonggi ana touanak dua. ");
INSERT INTO llg_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Boe ma, Yusuf kokolak nae, “Manetualain tao nala au afalende heni au doidosong, neu faik fo au kalua uma au amang uman mai.” Huu ndia, de ana foi ndia ana ulun nade, Manase (fo hihii leo dedeꞌa deꞌe feꞌek fo ndandaan nae ‘nafalende henin’.) ");
INSERT INTO llg_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Faik fo ana hambu ana kaduan, boe ma ana kokolak bali nae, “Au hambu doidosok noꞌun seli nai mamanak ia. Tehuu Manetualain fee au babaꞌe-babatik so, ma au hambu anak nai ia.” Boe ma ana foi kakanak ndia, nade Efraim. ");
INSERT INTO llg_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Basa ndia, boe ma fai nakabete teuk kahitu kala sila lateꞌe. ");
INSERT INTO llg_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","De fai ndoen teu kahitu kala sila, mulai mai, ndandaak no hata fo makahulun Yusuf nafada mema kana ndia. Nai mamana feꞌek, hataholi la ndoe so. Tehuu nai basa mamanak nai Masir, hambu nanaꞌak. ");
INSERT INTO llg_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Doo-doo, boe ma hataholi Masir asa, mulai ndoe. Boe ma, leu loke nanaꞌak nai manek. De manek nadenu sala leni Yusuf leu, fo tungga Yusuf palendan. ");
INSERT INTO llg_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Tehuu fai ndoen ndia boe napadaka, losa basa mamanak nai Masir ala ndoe. Boe ma, Yusuf mulai buka basa mbole kala, de ana seꞌo haꞌde neu hataholi Masir asa. ");
INSERT INTO llg_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Basa ndia, boe ma hataholi la leme sudi bee mai, ala mai hasa nanaꞌak nai Yusuf nai Masir. Huu fai ndoen ndia, tetebes nanabiik nalan seli. ");
INSERT INTO llg_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Faik ndia, Ama Yakob namanene hataholi la lae, hambu hade nai Masir, boe ma ana kokolak no ana nala nae, “Ana nggala ei! Hatina de kada ei manggua nadok leoiak! ");
INSERT INTO llg_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Au amanene so, lae, hambu nanaꞌak nai Masir. De malolenak ei miu hasa nai ele dei, fo boso ata mate to ndoes.” ");
INSERT INTO llg_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Basa boe ma, Yusuf kaꞌa kasanahulu nala, lahehele fo sangga leu hasa nanaꞌak nai Masir. ");
INSERT INTO llg_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Tehuu Yakob taa nau mboꞌi sala loo Yusuf fadin mulianan, Benyamin, neu noꞌu no sala. Huu ana duduꞌa nae, “Boso losak kakanak ndia hambu soe bali!” ");
INSERT INTO llg_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Huu hataholi la sudi lai bee, lamanene so boe, lae, hambu nanaꞌak nai Masir. Huu ndia de hataholi noꞌu kala leu hasa lai ele. Fai ndoen ndia losa nai dae Kanaꞌan so boe. Boe ma Yakob ana nala, leu hasa nai ele. ");
INSERT INTO llg_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Faik ndia, Yusuf dadik mane Masir lima konan so. Mete ma hataholi la leme sudi bee mai, fo ala sangga hasa hade, na, Yusuf seꞌo neu sala. Huu ndia, de faik fo kaꞌa nala losa, boe ma ala leu sendek lunggulangga nala, fo, fee hadak neu ndia, losa mata nala, deta dae. ");
INSERT INTO llg_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","8","Faik fo nita sala, boe ma ana nalela kasa tutik. Tehuu Yusuf tao aon sama leo hataholi Masir, huu ndia de, ala taa lalela kana. Boe ma ana natane sala taa no hadak, nae, “Ei ia mima bee mai?” Boe ma ala lataa lae, “Ai mima Kanaꞌan mai. Ai mai sangga hasa nanaꞌak nai Ama wakil.” ");
INSERT INTO llg_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Boe ma Yusuf nasaneda ndia meꞌin makahulun ndia. De ana nakabibii kasa nae, “Au taa amahele! Neu ko ei basa nggei ia, mana memete-mamaku kala. Ei mai sangga bubuluk dae Masir buin, fo suek ei sambu masafali ai, hetu!” ");
INSERT INTO llg_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Tehuu lataa lae, “Taa, ama! Ai ia, kada Ama ata mala. Tebe-tebe kada ai mai hasa nanaꞌak. ");
INSERT INTO llg_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Ai basa nggai ia, ama esa. Ai taa mana memete-mamaku kala, ama! Ai hataholi neulauk.” ");
INSERT INTO llg_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Tehuu Yusuf boe kokolak natingga bali nae, “Heh! Masapepekok! Boso pepeko au! Memak ei ia tetebes mana memete-mamaku kala, maa. Neu ko ei mai fo sangga bubuluk nusak ia buin!” ");
INSERT INTO llg_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Boe ma ala sapa lae, “Taa, ama! Ai kada ama ata mala, fo mima Kanaꞌan mai. Ai tolanoo kala sanahulu dua, ma ama esa. Ai fadi mulianan, nahani no ama, ma esa bali, taa kana so.” ");
INSERT INTO llg_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Boe ma Yusuf nataa nasafali, nae, ‘Taa! Tetebes hata fo au kokolak isinaak ndia so! Ei ia memak mana memete-mamaku kala. ");
INSERT INTO llg_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Naa! Ei musi fee buti dei, fo au bubuluk ae, ei kokolam isinaak ndia, memak tetebes do taa. Au soo! Mete ma ei fadi mulianam ndia, taa neni ia mai, na, ei taa bole laꞌo ela nusak ia! ");
INSERT INTO llg_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","De, ei hele mala hataholi esa fo neu nala ei fadi mulianam ndia, neni ia mai. Feꞌe kala, au kena sala. Au nau ita ei kokolam ndia tetebes do taa. Mete ma taa, na, ei ia memak mana memete-mamaku kala.” ");
INSERT INTO llg_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Boe ma, Yusuf nadenu kena sala, faik telu leu bui dale. ");
INSERT INTO llg_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Neu faik katelun, boe ma Yusuf kokolak no sala leme bui dale, nae, “Au ia, hataholi esa, mana bii Manetualain. Ma au tungga Ndia hihiin-nanaun taa-taa. De, suek ei bisa masoda, na, au sangga mboꞌi ei, tehuu no heheluk esa. ");
INSERT INTO llg_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Mete ma ei kokolak ndoos, na, ei musi matudu buti neu au. Ndia dalan leoiak: au kena hataholi esa nai bui dale. Feꞌe kala, fali fo mini nanaꞌak fee ei bobonggi nala. Huu ala lahani ei fali mini nanaꞌak. ");
INSERT INTO llg_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Boe ma, ei mia ei fadim ndia mai, fo ana dadik buti nae, ei ia hataholi ndoos, fo suek boso au huku isa ei.” Ala lamanene leondia, boe ma lakaheik. ");
INSERT INTO llg_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Boe ma, ala kokolak esa no esa lae, “Naa! Hatematak ia, bei fo ita laꞌe babalak neme fain ita sala-singgo nala mai, fo, ndia ita tao ita fadin ndia. Ita tita ndia doidosi nalan seli, losa ndia noke tulu-falik, tehuu ita taa mbali sana. Huu ndia, de hatematak ia, ita doidoso leoiak.” ");
INSERT INTO llg_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ruben nasaneneꞌda kasa, nae, “Wei! Fadi nggalei! Makahulun au kaꞌi ei so, fo boso tao hata-hata neu kakanak ndia, hetu! Tehuu ei taa mbali au kokolang ndia. Huu ndia, de, hatematak ia, ita lemba tala Yusuf daan leo, maa.” ");
INSERT INTO llg_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Ala lakokola leondia, tehuu tala bubuluk lae, Yusuf ana bubuluk sila dedeꞌan boe. Huu, leꞌdoeik Yusuf kokolak no sala nenik dedeꞌa Masir, fo basa na, mana kokola, ana saluan neni dedeꞌa Ibrani neu. ");
INSERT INTO llg_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Yusuf namanene ala kokolak leondia, boe ma ana foꞌa laꞌo ela sala, de mesa kana neu namatani nai mamana feꞌek. Ana namatani nateꞌe, boe ma ana fali neu sala, de ana nadenu hataholi ala mbaꞌa lala Simeon neu sila tolanoo nala matan. ");
INSERT INTO llg_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Basa ndia, boe ma Yusuf palenda ndia pegawe nala, fo ladai hade neu kaꞌa nala karo nala, ma ladai falik esa-esako doin neu karo nala bafan. Ndia boe oo nadenu fee sala lepa-nggee. Boe ma, pegawe la sila, ala tao tungga Yusuf palendan. ");
INSERT INTO llg_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Basa ndia, boe ma Yusuf kaꞌa nala, fua karon haꞌde la sila, leu sila banda keledei nala. Boe ma, ala laꞌo. ");
INSERT INTO llg_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Leu dala laladak boe ma, ala hahae. De, esa neme sila mai sefi heni tali karon, fo sangga ana fee ndia banda keledein naꞌa. Tehuu, ana nita ndia doin nai hade lain. ");
INSERT INTO llg_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Ana nggengge nalan seli, de nanggou kaꞌa nala nae, “Awii! Ei mai mita ia dei! Te ita soe ia so, maa! Ala fee falik au doing nai au karong dale.” Ala lita leondia, boe ma lamanggonggoak, hu ala bii lalan seli. Boe ma, ala lakokola lae, “Manetualain tao hata neu ita ia so bali?” ");
INSERT INTO llg_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Boe ma, ala laꞌo lakandoo. Losa Kanaꞌan, boe ma ala tui aman, basa hata ana laꞌe neu sala. ");
INSERT INTO llg_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Ala lafada lae, “Ama aa! Mane Masir lima konan ndia, ana seli maa. Ndia kokolan, taa no hadak nalan seli. Ana nae ai ia, miu memete-mamakuk ndia nusan.” ");
INSERT INTO llg_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Tehuu ai mataa mae, ‘Taa! Ai ia kada hataholi ndoos, fo, taa mana memete-mamakuk. ");
INSERT INTO llg_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Ai hataholi neulauk. Ai basa nggai tolanook sanahulu dua, fo, ama esa. Kaꞌda esa maten so, ma mulianak nahani no ama nai Kanaꞌan.’ ");
INSERT INTO llg_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Boe ma, Ama ndia, nae, ‘Au sangga soba sudik, ei ia hataholi ndoos do taa! Ei esa musi mahani ia. Feꞌe kala fali leni fee bobonggi nala hade, fo suek boso ala mate lo ndoes. ");
INSERT INTO llg_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Ei Musi mia ei fadim, mai dei. No leondiak, bei fo au bubuluk ei ia taa mana memete-mamaku kala, tehuu memak ei hataholi ndoos. Boe ma, au bisa mboꞌi ei tolanoom fo au kenak ndia so. Ma au mboꞌi ei, sudi mini bee miu, nai nusak ia.” ");
INSERT INTO llg_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Tui basa boe ma, ala mulai ofe sila karo nala isi nala. Nggengge neuk ala lita esa-esako doin, bei nai karon dale. Yakob no basa ndia ana nala lita leondia, boe ma ala bii lalan seli. ");
INSERT INTO llg_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Basa ndia, boe ma Yakob kokolak no sala nae, “Ei ia, tao mamopo au ana nggala. Yusuf taa kana so bali, ma Simeon leondiak boe. Hatematak ia boe oo, ei sangga mia Benyamin bali? Ei ia, tebe-tebe sangga kada tao doidoso au!” ");
INSERT INTO llg_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Boe ma Ruben kokolak no aman, nae, “Ama aa! Fee Benyamin neu au leo. Au ndia tanggon natataan. Au helu, dei fo au ua fali kana neu Ama. Tehuu mete ma taa, na, ela Ama ana tao nisa au ana touana nggala dua sala.” ");
INSERT INTO llg_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Tehuu Yakob kokolak bala nae, “Taa bisa! Ei taa bole mia Benyamin. Huu kaꞌan Yusuf, maten so. Hatematak ia, ela kada ndia mesa kana so. Mete ma ana hambu soe nai dala lalaꞌdak, na, ei boe tao tamba makatotoꞌak au, losa au loe au late daeng dale uu.” ");
INSERT INTO llg_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Faik ndia, fai ndoen boe napadaka nai Kanaꞌan bali. ");
INSERT INTO llg_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Yakob bobonggi nala, laꞌa labasa nanaꞌak, fo fain ana nala lenin leme Masir mai. Boe ma, ana nafada sala, nae, “Ana nggalei! Malolenak ei fali mini Masir miu, fo hasa seluk hade soa ita dei.” ");
INSERT INTO llg_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Tehuu Yahuda nataa nae, “Ama! Fain mane Masir lima konan ndia nasaneneꞌdak ai no hala belak, nae, ai taa bole matudu ai matan neu ndia, mete ma ai taa mia ama ana mulianan ia! ");
INSERT INTO llg_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","De ama musi mboꞌi Benyamin, fo ana tungga ai dei. Bei fo ai nau miu hasa nanaꞌak fee ama. ");
INSERT INTO llg_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Tehuu mete ma ama taa nau ai mia Benyamin neu, na, ai taa nau miu boe. Huu hataholi Masir ndia kokolan leondiak, na.” ");
INSERT INTO llg_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Boe ma Yakob nafada sala nae, “Hatina de ei mafada hataholi ndia so, mae ei fadim bei esa bali! Ei sangga kada tao nakatotoꞌak au!” ");
INSERT INTO llg_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Boe ma, ala kokoe lae, “Ama aa! Hataholi ndia nambue natane nakandondoo henin, fo ana sangga bubuluk ai, ma ai bobonggi nala. Ana natane nae, ‘Leobee? Ei aman bei, kasodak, do? Ei bei kafadi tou feꞌek bali, do?’ Boe ma, ai mae hata bali! No nakasetik ai kokolak ndoos leo. Huu see bubuluk nae, ndia sangga nadenu ai mia ai fadin ele neu?” ");
INSERT INTO llg_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","9","Boe ma, Yahuda kokolak seluk bali nae, “Ama! Mboꞌi kakanak ndia leo. Au helu, mete ma dadik hata-hata neun, na, ela au ndia lemba nggati ndia. Mete ma au taa ua fali kana no soꞌdak neu ama, na, ela ama fua salak ndia neu au losa mate. De ama mboꞌi kakanak ndia leo, huu ai sangga laꞌo ia so. Malolenak ai laꞌo lai-lai, fo boso hambu esa mate no ndoes. ");
INSERT INTO llg_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Hena leo ai taa mahani dook basa leoia, na, neu ko ai fali laꞌi dua so.” ");
INSERT INTO llg_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Basa boe ma sila aman nae, “Mete ma leondiak, na, kada ei tao leoiak. Miu haꞌi mala ita daen buna-boan fo neulaun seli. Ndia: fani oe, bumbu-fani, ai daa kaboo menik, akidoo salap, kanari, ma fufue nula feꞌe kala. De minin neu mane Masir lima konan, fo mae, ia ai nenenin ndia ia. ");
INSERT INTO llg_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Ei boe oo mini doik dedesin bekelaꞌi duak, huu ei musi fee falik doik, fo fain ei hambu sala leme ei karo nala dale ndia. Fama hataholi la sila, ala mbeda lasala doi kala sila. ");
INSERT INTO llg_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Ei boe oo, mia ei fadim, tehuu mia fali kana lai-lai baa! ");
INSERT INTO llg_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Au hule-haladoi, fo Manetualain fo Koasan Ana selin ndia, tao nala Mane Masir lima konan ndia, nameda kasian neu ei. Losa ana nau, fee falik Benyamin ma Simeon neu ei, fo ei basa nggei fali noꞌu. Tehuu, mete ma au anang musi mopon, na, ela au lemba toꞌa-taak ndia akandondoo henin leo.” ");
INSERT INTO llg_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Basa ndia, boe ma ala lakaduduluk lala bua neneni kala sila, ma doi kala sila, fo ala lenin neni Masir neu. Ala loo Benyamin boe. Losa ele, de leu lasale Yusuf. ");
INSERT INTO llg_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Leꞌdoeik Yusuf nita Benyamin ma ndia kaꞌa nala, boe ma nadenu ndia malangga mana makanenik, nae, “Heh! Mua hataholi la ia leni au umang leu! Boe ma, muu hala mala sapi esa, fo tunu-nasu malan malaꞌda. Huu dei fo ala laꞌa leledok lo au.” ");
INSERT INTO llg_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Boe ma, malangga mana makanenik ndia, tungga Yusuf palendan. De ana noo sala leni Yusuf uman leu. ");
INSERT INTO llg_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Ledoeik ala belaꞌo leni Yusuf uman leu, boe ma kaꞌa nala, bii lalan seli. Nai dala laladak, ala lakokola lae, “Wei! Hatina de ana nadenu loo ita teni ia mai? Naafo, ana sangga tao nakatatoꞌak ita, huu fain doi kala fo ala fee fali kasa leme ita karo nala dale sila. Ala taok loo ita ia mai, fo kada nggengge neuk ala humu lala ita, fo ala tao ita dadik neu sila atan. Basa boe ma, ala lamoa lala basa ita banda keledei nala.” ");
INSERT INTO llg_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Huu ndia de, ledoeik ala dekak lo Yusuf uman, boe ma ala kokolak lo malangga makanenik ndia, lae, ");
INSERT INTO llg_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Ama! Ai moke ambon, huu fain ai mai hasa mitak nanaꞌak neme ia. ");
INSERT INTO llg_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","22","Boe ma, ledoeik fo ai fali nggolok miu, ai hahae mima dalak fo sangga sunggu. Boe ma ai sefi karo nala, fo sangga fee banda la laꞌa, naa te, hambu falik ai esa-esak doi hasa haden ndia, neme karon dale. Ai taa bubuluk see ndia taon neu ndia! Tehuu hatematak ia, ai mini falik basa doi kala sila. De, ama boso mamanasa bou! Ela ama bubuluk, hatematak ia ai boe oo, mini doi feꞌek bali, fo sangga hasa nanaꞌa beuk.” ");
INSERT INTO llg_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Boe ma, malangga mana makanenik ndia, nae, “Ei kada nee-nee leo! Boso bii! Fama ei Manetualain ndia, fee ua-nale malole neu ei nai karo nala sila dalek. Fain, au simbo ala basa ei doi mala, maa. Ei hutan taa so!” De ana mboꞌi heni Simeon neni sila neu. ");
INSERT INTO llg_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Boe ma, basa sala maso leni Yusuf uman dale leu. De malangga mana makanenik ndia, fee sala oe fo ala safe lalalao ei nala. Ndia boe oo, fee sila banda keledei nala laꞌa. ");
INSERT INTO llg_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Boe ma, nafada sala nae, “Dei fo ei miꞌa leledok mia maklanggan.” Ledoeik ala bei lahani Yusuf mai, de ala heti memak sila bua neneni nala. ");
INSERT INTO llg_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Yusuf losa leondia, boe ma basa sala ala sendek lunggulangga nala leu matan. De ala loo sila bua neneni nala, neun. ");
INSERT INTO llg_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Boe ma Yusuf natane sala nae, “Leobee? Ei malole do? Talobee no ei ama lasin ndia? Ndia malole boe, do?” ");
INSERT INTO llg_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ala lataa lae, “Ama ata lasin, fo ai ama bonggin ndia, malole, Ama.” Boe ma ala lakatele fo ala fee hadak neu ndia bali. ");
INSERT INTO llg_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Basa ndia, boe ma Yusuf ana suli ndule sala, losa ana nita fadin Benyamin. Sila dua sala ndia, ama esa, ma ina esa. Boe ma nae, “Wei! Ia ndia ei faꞌdi mulianan, fo fain ei tuik ndia so, hetu?” Basa de ana kokolak no Benyamin nae, “Ana nggo ei! Au hule-haladoi fo Manetualain fee babaꞌe-babatik makadotok neu o.” ");
INSERT INTO llg_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Yusuf nita Benyamin, boe ma ndia dale haladoin hihii ana tuꞌda deak mai. Huu ana sue nala fadin seli. Ana taa bisa nakatataka nala dalen so. Boe ma, ana laꞌo lai-lai ela sala, de ana maso neni kaman dale neu, boe ma namatani nasakekeꞌdu nai ndia. ");
INSERT INTO llg_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Ana namatani nateꞌe, boe ma ana neu nalou oe, de ana tao natesa dalen. Ana kalua neu natonggo no sala, de nadenu hataholi nala leu sadia mei nanaꞌak. ");
INSERT INTO llg_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Boe ma, ala tao fee Yusuf naꞌa nai mei hehelik esa. Ndia kaꞌa-fadi nala, laꞌa lai mei feꞌek. Ndia pegawe hataholi Masir asa, laꞌa lai sila mei hehelin boe. Huu hataholi Masir asa, lameda nunute langgatuuk laꞌa seseok lo hataholi Ibrani. ");
INSERT INTO llg_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Malangga mana makanenik ndia, ana hetin so, fo Yusuf kaꞌa-fadi nala, langgatuuk lasale Yusuf. Ana heti sala tungga teu nala, mulai neme uluk losa fadi mateꞌateisusuk. Ledoeik lita hehetik ndia, boe ma ala heran. ");
INSERT INTO llg_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Boe ma, Yusuf ana heti fo hataholi mana ono-lau kala haꞌi fee ndia kaꞌa-fadi nala nanaꞌak neme ndia mei hehelin mai. Basa sala simbo noꞌun sama. Tehuu mana ono-lau kala, fee Benyamin enan, noꞌun lena heni kaꞌa nala laꞌi lima. Basa boe ma, ala laꞌa-linu losa ala lakabete lalan seli. ");
INSERT INTO llg_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Ala laꞌa basa, boe ma Yusuf ana nakukutuk malangga mana makanenik, nae, “Wei! O muu madai hade neu hataholi la esa-esak karon losa henuk. Basa na, o tao seluk sila doi nala neu esa-esak karon dale. ");
INSERT INTO llg_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Boe ma, o haꞌi mala au moo lilo fulang, fo taon neu kakana mulianak ndia karon.” Boe ma, ana neu tao tungga Yusuf palendan ndia. ");
INSERT INTO llg_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Neu foꞌa fafai kikiuanan, boe ma Yusuf mboꞌi sala, fo ala leni nanaꞌak lenik sila banda keledei nala. ");
INSERT INTO llg_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Ala laꞌo bei taa losa dook nalan seli neme kota mai, boe ma Yusuf nafada malangga mana makanenik ndia, nae, “O malai lai-lai tungga hataholi la sila. Mete ma o matonggo mua sala, na, o mae leoia: ‘Hatina de ei dale mala manggalauk neu toulasik? De ei bala ndia malolen no manggalauk leoiak! ");
INSERT INTO llg_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Talobee, de ei dale mala leoiak de bisa mamanaꞌo mini malanggan moo lilo fulan? Ei taa bubuluk, do? Ndia taa kaꞌda moo nininuk! Ana pake mook ndia fo ana sangga bubuluk hataholi la ua-nalen. Mook ndia, ndolu ndia! Ei tataom ia, memak manggalaun ana seli!” ");
INSERT INTO llg_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Basa boe ma, malangga mana makanenik ndia neu nalai tungga sala, de losa ana hambu sala. Boe ma, nafaꞌda sala tungga Yusuf kokolan isinaak ndia. ");
INSERT INTO llg_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Boe ma, ala taa simbok de lae, “Ama hihiin leobeek ia? Ai soo. Ai taa tao manggalauk leondiak! ");
INSERT INTO llg_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Ama mesa kana bubuluk, hetu? Fain doi kala manai ai karo nala sila dalek, ai fee fali kana neu ama so, hetu? De talobee fo ai bisa mamanaꞌo malanggan lilo fulan neme ndia uman mai! Taa bisa! ");
INSERT INTO llg_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Ama palisak leo! Hambu buas ndia nai see karon, na, huku nisan leo! Ma ela ai feꞌe kala ia, daꞌdik neu malanggan atan leo.” ");
INSERT INTO llg_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Boe ma, malangga mana makanenik ndia, nae, “Taa! Kada leoiak. Mete ma mook ndia nai see, na, ndia daꞌdik au atang. Feꞌe kala bole fali.” ");
INSERT INTO llg_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Boe ma ala lakonda lai-lai karo nala sila, de ala sefi mema kasa. ");
INSERT INTO llg_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Boe ma, malangga mana makanenik palisak lutu-lutuk, mulai neme kaꞌak karon losa fadik ena. De ana hambu moo lilo fulak ndia neme Benyamin karon. ");
INSERT INTO llg_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Benyamin kaꞌa nala lita leondia, boe ma dale nala heꞌdis. Ala fua falik karo nala sila leu banda keledei la lain, de ala pode fali leni kota leu. ");
INSERT INTO llg_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Ledoeik, ala losa Yusuf uman, tehuu ndia bei nai ndia. Boe ma, ala sendek lunggulangga nala leu ndia matan. ");
INSERT INTO llg_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Boe ma, Yusuf nasapala kasa, nae, “Heh! Hatina de ei tao leoiak neu au! Ei taa bubuluk hataholi inahuuk leo au ia, bisa pake ndolu fo sangga bubuluk hataholi buin?” ");
INSERT INTO llg_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yahuda nataa nae, “Awii! Manetualain lufa nakaholak ai sala nala so. De ai sangga mae hata bali, ama! Ai sangga masalaꞌe ai aon talobee bali. Mete ma ama, nau kena ai faꞌdi mulianan ia, na, malolenak ama kena ai basa nggai. Haꞌi mala ai basa nggai daꞌdik neu ama atan leo.” ");
INSERT INTO llg_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Yusuf nataa nae, “Taa! Hambu mook ndia nai see na, ndia ndia, ana daꞌdik neu au atang! Ei feꞌe kala, au mboꞌi ei, de fali mini ei aman miu leo!” ");
INSERT INTO llg_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Basa ndia, boe ma Yahuda neu deka-deka no Yusuf, de ana kokolak nae, “Ama wakil! Au bubuluk ama koasan sama leo manek. Huu ndia de boso mamanasa au dei. Huu au oke palamisi fo au kokolak fa ua ama. ");
INSERT INTO llg_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Afik ama matane ai mae, ‘Ei aman ma ei fadin esa bei nai ndia, do?’ ");
INSERT INTO llg_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Boe ma, ai mataa mae, ai aman namalasi so. Ma ai fadi mulianan esa. Faik fo bonggi ndia, ama lasik so. Fadi mulianak ndia, kaꞌa bonggin esa, tehuu ndia taa kana so. Dua sala inan maten so. De, hatematak ia, ela kada fadi mulianak mesa kana so. Huu ndia, de ai aman suen nalan seli.’ ");
INSERT INTO llg_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Boe ma ama madenu ai mia ai fadin ndia, fo ama bisa mitan. ");
INSERT INTO llg_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Boe ma ai mataa mae, kakanak ndia taa bisa laꞌo ela aman. Mete ma ana laꞌo elan, na, ai aman maten ndia so. ");
INSERT INTO llg_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Tehuu ama mataa, mae, ‘Mete ma ei taa mia ei faꞌdim ndia, na, ei taa bisa mita au matang so bali.’ ");
INSERT INTO llg_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Basa boe ma, ai fali losa ai aman, boe ma ai mafadan basa ama kokolan ndia. ");
INSERT INTO llg_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Doo-doo boe ma, basa ai nanaꞌan. De ai aman nadenu ai mini Masir mai seluk fo hasa nanaꞌak bali. ");
INSERT INTO llg_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Tehuu ai bala mae, ‘Ama aa! Ai taa bisa mini ele miu so bali. Huu manek lima konan ndia, nafada basa so, nae, mete ma ai taa mia ai fadi muliana ndia, na, ai taa bisa mita ndia matan so. De ai fadi mulianan musi tungga dei, bei fo ai laꞌo.’ ");
INSERT INTO llg_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Basa ndia, boe ma ai aman kokolak bali nae, ‘Ei bubuluk so, hetu? Au saong, Rahel ndia, kada anan duak. ");
INSERT INTO llg_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Ana uluk taa kana so. Neu ko banda fui la, kodo henin so. Huu ndia de losa hatematak ia, au taa ita sana so. ");
INSERT INTO llg_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Mete ma ei haꞌi mala ana mulianak ia neme au mai bali, boe ma, ana hambu soe na, ei boe tao makatotoꞌak nai au fai lasing dale, de au mate tutik. ");
INSERT INTO llg_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Huu ndia, Ama wakil, de mete ma au fali uni ama uu, ma au taa ua fadi mulianak ia, na neu ko ai aman maten ndia so. Huu ndia samanen nanambaꞌak no kakanak ndia. Ma ndia namalasi nalan seli, losa mete ma ai boe tao makatotoꞌa kana, na, neu ko maten. ");
INSERT INTO llg_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Nakalenak bali, au aheluk ua ama ae, au tanggon kakanak ndia. Au aheluk ua au aman, ae mete ma, au taa ua falik kakanak ndia neu ndia, na, ela au lemba salak ndia losa mate. ");
INSERT INTO llg_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","De au oke leoiak, ama ela au leo nai ia nggati ndia, fo kada au mesang dadik Ama atan. Ela ana fali no kaꞌa nala. ");
INSERT INTO llg_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Mete ma kakanak ndia taa tungga, na, au taa bisa fali boe. Au taa bisa akatataka ita ama doidoso losa maten.” ");
INSERT INTO llg_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Yusuf namanene leondia, boe ma dalen ana noe losa taa bisa nakatataka nala so bali, neu ndia pegawe nala matan. Huu ndia de, nadenu sala ala deak leu, fo ela ndia mesa kana no ndia kaꞌa-fadi nala. No leondiak, ana bisa manaku nae, see ndia. ");
INSERT INTO llg_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Boe ma, pegawe la sila deak leu, de Yusuf namatani nakaleleu natingga, losa hataholi Masir asa lai kama ndia deak, ala lamanene. Ma, hataholi la malai manek uman lamanene boe. ");
INSERT INTO llg_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Boe ma, Yusuf nafada manggaleꞌdok neu tolanoo nala nae, “Wei! Kaꞌa-fadi nggalei! Au ia Yusuf, ei talanoom! Ama bei kasodak, hetu?” Kaꞌa-fadi nala lamanene leondia, boe ma ala bii lalan seli, losa tala bisa kokolak hata-hata bali. ");
INSERT INTO llg_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Boe ma, Yusuf kape kasa, nae, “Wei! Ei hoꞌdok mai mata ia dei.” Boe ma ala leu dekak lo Yusuf, de ana kokolak seluk bali, nae, “Au ia Yusuf, fo fain ei seꞌo heni au uni Masir uu. ");
INSERT INTO llg_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Memak ei seꞌo heni au. Tehuu ei boso bii, ma boso matoka fee salak esa no esa bali. Naa te, Manetualain mesa kana ndia no au ia mai, akahuluk neme ei mai. Fo no leondiak, Ana pake au fo asalaꞌe hataholi noꞌuk, fo boso ala mate lo ndoes. ");
INSERT INTO llg_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Hatematak ia, fai ndoen bei fo ana laꞌok teuk dua ia. Bei ela teuk lima bali. Neu faik ndia, hataholi la tala foi dae, tala sele-nggali, ma tala hambu buna-boak hata-hata. ");
INSERT INTO llg_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Tehuu Manetualain noo nakahuluk au neme ei mai so, fo ela hambu neme ei mai, ma ei umbu-ana nala, lasoda. ");
INSERT INTO llg_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","De, teteben na, ei tataon taa ia, fo au losa ia, tehuu Manetualain tatao ndia. Ndia ndia tao au dadik manek lima konan nai Masir. Boe ma, au dadik manek malangga uma-loon, nai manek uma manen. Taa hambu hataholi feꞌek inahuun lena heni au. ");
INSERT INTO llg_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Hatematak ia, fali lai-lai leo, fo mafaꞌda au kokolang ia neu ama, mae leoia: ‘Ama anan Yusuf ndia, bei kasodak! Ana dadik hataholi inahuuk nai nusa Masir so. Ndia boe oo, noke ama neni Masir neu lai-lai. ");
INSERT INTO llg_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Dei fo ama bole leo nai dae babaꞌek Gosen, fo dekak no ndia. Mamanak ndia neulauk ma maloa. De ama bisa makaboi basa ama biꞌilombo, biꞌiae kala ma sapi la. Boe ma, ana noke ama mai mua umbu-ana mala, ma uma isi mala, ma basa sila pusaka nala, fo leo nakandoo nai ele. ");
INSERT INTO llg_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Mete ma ama nai Gosen, na, ana bisa nakaboi ama nai ele, huu fai ndoen bei teuk lima bali. De, dei fo ana heti, fo ama mua bobonggi mala, ma basa ama banda mala taa toꞌa hata-hata esa boe.’ ” ");
INSERT INTO llg_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Yusuf nafada basa, boe ma ana kokolak bali, nae, “Hatematak ia, ei mita matam so, hetu? Boe ma o, Benyamin. Au ia, memak Yusuf. ");
INSERT INTO llg_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","De mafada ita aman mae, au koasang nai Masir ia, inahuun ana seli. Ma tui ama boe, basa hata fo o mitam so. Basa ndia na, ei mia ama lai-lai mai leo!” ");
INSERT INTO llg_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Boe ma, ana holu nala fadin Benyamin, de dua sala lamatani. ");
INSERT INTO llg_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Ndia boe oo, ana holu nala kaꞌa nala, de ana idu esa-esa. Basa ndia, bei fo ala mulai lakokola lon. ");
INSERT INTO llg_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Basa ndia, boe ma ledoeik manek no ndia pegawe nala lamanene Yusuf kaꞌa-fadi nala mai, boe ma basa sala lamahoko. ");
INSERT INTO llg_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Basa ndia, boe ma manek kokolak no Yusuf nae, “Yusuf aa! Mafada o kaꞌa-fadi mala, fo ala fua leni hade neu sila banda keledei nala, fo leni Kanaꞌan leu. ");
INSERT INTO llg_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Boe ma madenu sala loo aman ma basa bobonggi nala, fo huꞌa mai leo. Dei fo au fee sala dae neulauk manai lain seli nai Masir, fo ala bisa lasoda lai ele, ma laꞌa dae ndia buna-boan. ");
INSERT INTO llg_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Boe ma mafada sala, fo ala leni memak nggili hida neme ia mai, fo dei fo ala fua lala kakana kadiꞌi kala ma ama nala. ");
INSERT INTO llg_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Boso duduꞌa pusaka fo ala taa bisa luꞌa leni sala, huu basa neulauk manai lain seli lai Masir ia, dei fo ala hambu sala.” ");
INSERT INTO llg_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Yusuf namanene leondia, boe ma ana fee sala nggili luma ma lepa-ngge soaneu nai dalak, tungga manek palendan. Ma, ndia kaꞌa-fadi nala lafafaꞌu, fo ala fali tungga manek palendan. ");
INSERT INTO llg_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Yusuf fee sala esa-esak baloꞌa papake beuk pasan esa. Tehuu ana fee Benyamin doi lilo fulak natun telu, ma baloꞌa papake beuk pasan lima. ");
INSERT INTO llg_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Ndia boe oo, haitua fee aman baloꞌa papake neulauk nalan seli nai Masir, fo ala fua sala leu banda keledei sanahulu. Ana fee nakadai, haꞌde, loti ma nanaꞌak mata-matak bali, nai banda keledei sanahulu, fo dadik neu lepa-ngge neu sila fali main leni Masir mai. ");
INSERT INTO llg_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Basa ndia, boe ma ana mboꞌi sala fali, ma nasaneneꞌda kasa nae, “Ei boso matoka nai dalak, baa!” ");
INSERT INTO llg_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Basa boe ma, ala fali leni aman leu, nai Kanaꞌan. ");
INSERT INTO llg_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Losa ele, boe ma ala lafada aman lae, “Ama aa! Ama anan Yusuf bei kasodak. Ana dadik hataholi inahuuk, de ana palenda nai Masir!” Yakob namanene leondia, boe ma ana nado namanggonggoak, ma taa namahele sila kokolan ndia. ");
INSERT INTO llg_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Tehuu ledoeik ala lafada basa Yusuf kokolan, ma ana nita nggili la fo Yusuf haituak ndia, fo sangga fua loo ndia neni Masir neu, bei fo ana mulai namahele. ");
INSERT INTO llg_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Boe ma ana kokolak nae, “Awii! Au anang bei kasodak maa! Naa, leondiak, bei fo au amahoko! Au musi uu tilon dei, bei fo au bisa mate ua mole-dame.” ");
INSERT INTO llg_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Basa ndia, boe ma Yakob nafafaꞌu ndia bua nala, boe ma ala laꞌo ela Kanaꞌan. Losa neu nggolo Barseba, boe ma ana hala banda, de ana tao tunu-hotuk, fee Manetualain fo neme makahulun mai aman Isak ana nakaluku-nakatele neu Ndia. ");
INSERT INTO llg_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Boe ma leꞌodaek esa, ana nalameꞌi. Nai meꞌis ndia, ana namanene Manetualain noken nae, “Wei! Yakob! Yakob! O foꞌa leo, fo mamanene!” Yakob nataa nae, “Hatina?” ");
INSERT INTO llg_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Manetualain nae, “Au ia, Manetualain fo o aman nakaluku-nakatele neu Au neme makahulun mai. O boso bii muni Masir muu, huu dei fo Au tao o numbu-saꞌdu mala, dadik hataholi nusak inahuuk nai ele. ");
INSERT INTO llg_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Dei fo Au sama-sama ua o teni Masir teu. Ma dei fo Au boe oo ua falik o numbu-sadu mala fali leni Kanaꞌan leu. Dei fo neu faik fo o mate, o anam Yusuf ndia hambu o ani hahae mateꞌen.” ");
INSERT INTO llg_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Basa ndia, boe ma Yakob no ndia ana nala laꞌo ela nggolo Barseba. Boe ma, ala lakasasaꞌe kana no sao-anan nala, leu nggili la lain fo mane Masir ana haitua kala sila so. ");
INSERT INTO llg_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","7","Boe ma, ala haꞌi leni basa sila pusaka nala, ma basa sila banda nala, fo ala dadik leu sila ena heheli nala neme dae Kanaꞌan. Boe ma, Yakob no ndia ana touana nala, ndia ana ina-anan, ma basa ndia umbu-solo nala, laꞌo leni Masir leu. ");
INSERT INTO llg_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Yakob bobonggi nala mana tungga Masir leu, ndia: Ruben, fo ana uluk. ");
INSERT INTO llg_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Ndia ana nala: Henok, Palu, Heston, ma Karmi. ");
INSERT INTO llg_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeon, ma ndia ana nala, sila: Yemuel, Yamin, Ohad, Yakin, ma Sohar. Ma Saul boe, fo ndia anan neme saon ina Kanaꞌan, mai. ");
INSERT INTO llg_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Lewi, no ndia ana nala, sila: Gerson, Kehat, ma Merari. ");
INSERT INTO llg_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yahuda, ma ndia ana nala, sila: Sela, Peres, ma Sera. Yahuda ana feꞌen, Er ma Onan, tehuu mate sala so lai Kanaꞌan. Ndia boe oo, no Peres ana nala, ndia Hesron, ma Hamul. ");
INSERT INTO llg_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isaskar, ma ndia ana nala, sila: Tola, Pua, Ayub, ma Simron. ");
INSERT INTO llg_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Sebulon, ma ndia ana nala, sila: Sered, Elon ma Yahleel. ");
INSERT INTO llg_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Basa sila ndia, Yakob no saon Lea ana bonggi nala, faik fo ala leo leme Mesapotamia. Hambu ana inanak boe, nade Dina. De Yakob no Lea numbu-sadu nala, basa sala hataholi telu hulu telu. ");
INSERT INTO llg_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Boe ma, hambu ndia ana nala leme ndia sao feꞌe nala mai. Sila: Gad, ma ndia ana nala: Sifion, Hagi, Suni, Esbon, Eri, Arodi, ma Areli. ");
INSERT INTO llg_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Aser, ma ndia ana nala, sila: Yimna, Yiswa, Yiswi, Beria, ma sila feton, nade Sera. Hambu Beria ana nala boe: sila Heber ma Malkiel. ");
INSERT INTO llg_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Basa sala, hataholi sanahulu nee. Ndia Yakob no saon Silpa umbu-ana nala. Silpa ndia, na ata fo Laban ana fee ana ina-anan Lea, fo Yakob sao mulin ndia. ");
INSERT INTO llg_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Boe ma, hambu Yakob sao feꞌen bali, nade, Rahel. Ana bonggi anak dua, Yusuf ma Benyamin. ");
INSERT INTO llg_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Faik ndia, Yusuf sao Asnat nai Masir so. Ndia aliaman ndia, malangga anggama nai kota On. Ndia naden Potifera. Boe ma, Yusuf no Asnat ana nala, Efraim ma Manase. ");
INSERT INTO llg_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benyamin tungga neni Masir neu boe, no ndia ana nala: Bela, Beker, Asibel, Gera, Naaman, Ehi, Ros, Mupim, Hupim ma Ared. ");
INSERT INTO llg_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Boe ma, Yakob no ndia saon Rahel numbu-sadu nala, hambu hataholi sanahulu haa. ");
INSERT INTO llg_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Basa boe ma, bei hambu saon esa bali, nade Bilha. Sila ana nala, ndia, Dan, ma Naftali. Dan anan naꞌde Husim. ");
INSERT INTO llg_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Naftali no ndia ana nala: Yasel, Guni, Yeser ma Silem. ");
INSERT INTO llg_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Yakob ma ndia saon Bilha numbu-sadu nala ndia, hataholi hitu. Bilha ndia, na, Rahel atan fo ana hambun neme aman Laban mai. ");
INSERT INTO llg_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","De, Yakob numbu-sadu nala, basa sala maneni Masir leu, hambu hataholi nee hulu nee. Bei taa hingga ndia feto-feu nala. ");
INSERT INTO llg_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Tamba no Yusuf ana nala fo nanabonggi kala lai Masir, hataholi dua. De Yakob no bobonggi nala mana leo lai Masir, basa sala hataholi hitu hulu. ");
INSERT INTO llg_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Ala sangga dekak lo Masir, boe ma Yakob nadenu anan Yahuda laꞌok nakahuluk, de neu noke Yusuf, fo ana mai natonggo no aman nai Gosen. Leꞌdoeik ala losa Gosen, ");
INSERT INTO llg_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","boe ma Yusuf saꞌe nala ndia nggilin, de neu natonggo no aman nai ndia. Ledoeik ala latonggo, boe ma Yusuf ana holu nala aman, de namatani nala doon seli. ");
INSERT INTO llg_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Boe ma, Yakob kokolak no Yusuf nae, “Ana Yusuf aa! Hatematak ia, au mesa nggau ita o so. Ma au bubuluk so, o bei kasodak. Huu ndia, de mae au mate hatematak ia boe oo, malole.” ");
INSERT INTO llg_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Boe ma, Yusuf nafada kaꞌa-fadi nala nae, “Au musi uu afada manek, ae au bobonggi nggala mai leme Kanaꞌan mai so. ");
INSERT INTO llg_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","De, dei fo au afada ae, ei ia hataholi mana makaboi biꞌilombo ma sapi. Huu ndia, de ei boe oo mini ei banda nala, ma pusaka mala leme Kanaꞌan mai. ");
INSERT INTO llg_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Mete ma manek noke ei, ma natane ei, nae ei mateme tao hata, ");
INSERT INTO llg_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","na, ei mataa leo mae, ei basa-nggei ia mana makaboi banda neme ei kadiꞌi-anam mai, sama leo ei bei-baꞌi mala. No leondiak, dei fo nadenu ei leo nai dae babaꞌek Gosen.” Yusuf nafada leondia, huu hataholi Masir asa lameda nunute, mete ma ala leo lakabubua lo manahoo la. ");
INSERT INTO llg_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","2","Basa boe ma, Yusuf no ndia tolanoo nala hataholi lima, leu lasale manek. Yusuf nalelela kasa, nae, “Ama manek! Au amang ma au kaꞌa-fadi nggala, mai leme Kanaꞌan mai so. Ala mai lo sila biꞌiae-biꞌilombo nala, sapi nala, ma basa sila bua nala. Hatematak ia sila basa sala lai dae babaꞌek Gosen so.” ");
INSERT INTO llg_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Boe ma, manek natane sala nae, “Ei tataon hata?” Ala lataa, lae, “Ai ia manahoo sama leo ai bei-baꞌi nala. ");
INSERT INTO llg_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Hatematak ia, nai dae Kanaꞌan fai hanan ana seli, losa taa hambu nanaꞌak ma naꞌu so. Huu ndia, de ai mini nusak ia mai, fo leo tataak. Ai boe oo mini ai banda nala. Hatematak ia, ai moke ama manek fo makamboꞌik ai leo nai dae babaꞌek Gosen, fo ai makaboi ai banda nala lai ndia.” ");
INSERT INTO llg_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Boe ma, manek nafada ndia hihiin neu Yusuf, nae, “Hatematak ia, o amam ma kaꞌa-fadi mala lai ia so. ");
INSERT INTO llg_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","De ala bole tao nusak ia sama leo sila nusa hehelin. Au bubuluk, dae Gosen ndia, dae babaꞌek neulaun seli nai nusak ia. De malolenak, ala leo lai ele leo. Ma, mete ma neme sila mai, ala lakaneni lalelak banda no malole, na, ela ala lakaneni au enang lai ndia boe.” ");
INSERT INTO llg_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Basa ndia, boe ma Yusuf nalelelak aman neu manek. Boe ma, Yakob hule-haladoi noke fo Manetualain fee babaꞌe-babatik neu manek. ");
INSERT INTO llg_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Manek ndia natane Yakob, nae, “Ama teuk hida ia so?” ");
INSERT INTO llg_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yakob nataa, nae, “Au asoda teuk natun esa telu hulu ia so, ma au taa leo ahele nai mamanak esa. Au bei-baꞌi nggala leondiak boe. Mete ma nakasaman no sila, na au teung kekeꞌun lena heni sila, tehuu henuk no doidosok.” ");
INSERT INTO llg_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Boe ma Yakob nateꞌa manek. Tehuu ledoeik ana bei taa laꞌo, noke Manetualain fee babaꞌe-babatik neu manek bali. ");
INSERT INTO llg_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Boe ma, Yusuf tungga manek kokolan, de ana natudu fee sala mamanak nai dae babaꞌek Gosen. Mamanak ndia neulaun seli. (Dei fo ala foi mamanak ndia, nade ‘Rameses’.) Basa ndia, boe ma Yusuf aman ma ndia kaꞌa-fadi nala, leo lakandoo lai ndia. ");
INSERT INTO llg_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Basa boe ma, Yusuf sadia nanaꞌak fo nakaboi aman, kaꞌa-fadi nala, ma basa sila sao-ana nala, mulai neme inahuuk losa kakana ana kala. ");
INSERT INTO llg_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Faik ndia, fai ndoen napadaka nalan seli, losa sudi nai bee, taa hambu nanaꞌak so bali. Neme Masir mai losa Kanaꞌan, hataholi la bekundole so. Taa bisa tao hata-hata so bali, huu ala ndoe lalan seli. ");
INSERT INTO llg_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Basa de, hataholi la leme sudi bee mai nai Masir, ma basa mamanak nai Kanaꞌan, leu hasa nanaꞌak nai Yusuf. Boe ma, ana nakaduduluk nala basa doi kala sila, de neu mbeꞌda sala neu manek uman. ");
INSERT INTO llg_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Faik ndia, hataholi Masir asa ma hataholi Kanaꞌan asa doi nala basa sala so. Huu ndia de taa bisa hasa nanaꞌak so. Basa boe ma, ala mai lasale lala Yusuf, fo loke lae, “Ama wakil aa! Fee ai nanaꞌak dei, fo boso ai mate mia ndoes. Huu ai doin basan so.” ");
INSERT INTO llg_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Boe ma, Yusuf nataa nae, “Mete ma memak ei doim taa so, na, tao leoiak: fee ei banda mala mai, fo tukan neu nanaꞌak.” ");
INSERT INTO llg_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Basa boe ma, ala fee sila banda nala neu Yusuf, fo ala tukan neu nanaꞌak, fo ndia sila ndala nala, sila biꞌilombo nala, sila biꞌiae nala, sila sapi nala, ma sila banda keledei nala. Huu teuk ndia, Yusuf helu leo ndiak so. ");
INSERT INTO llg_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Manafali boe ma, ala fali mai sala bali leni Yusuf mai, lae, “Ama wakil aa! Ai kokolak ndoos leo. Ai doin ma ai bandan, ama ana seseluk nala basa sala so. De hatematak ia, taa hambu hata-hata so. Ela kada ai ao nala, ma ai dae nala, ");
INSERT INTO llg_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","de boso fee ai mate. Mete ma ai mate, na, see ndia nakaneni dae la sila? Malolenak, ama wakil haꞌi mala ai dadik ama ata nala. Ma ama boe oo haꞌi mala ai daen fo daꞌdik neu ama enan. De ama fee ai bini fo ai sele fee ama. Boe ma, ai sosotam ma ai daen ndia, ama ana nggatin no kada nanaꞌak leo, fo sadi ai boso mate!” ");
INSERT INTO llg_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Huu fai ndoen ana boe napadaka, de basa hataholi Masir asa, seꞌo heni basa dae nala. De Yusuf hasa nala basa dae manai Masir, fo dadik neu manek pusakan. ");
INSERT INTO llg_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","No leondiak, de basa lau-inggu Masir, ala dadik manek ata nala. ");
INSERT INTO llg_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Tehuu, neme basa sala mai, Yusuf taa hasa malangga anggama la dae nala, huu manek fee sala nanaꞌak nakandoo. Huu ndia, de, ala taa paluu seꞌo sila dae nala. ");
INSERT INTO llg_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Faik ndia, boe ma Yusuf kokolak no lau-inggu la nae, “Hatematak ia, ei dadik manek ata nala so. Basa ei dae mala, au hasa ala sala fee manek so. De ei haꞌi mala bini la ia, fo miu sele sala leu dae la sila leo. ");
INSERT INTO llg_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Boe ma, dei fo ama ketu-kolu malan, na, ei baꞌe lima kana. Babaꞌek esa feen neu manek. Ela babaꞌek haa, ei taon neu bini, ma mia ei uma isi mala miꞌa.” ");
INSERT INTO llg_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Ala lataa lae, “Ama masalaꞌe mala ai so, huu ndia de ai moke makasi. Ai nau dadik ama manek ata nala leo.” ");
INSERT INTO llg_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Boe ma, Yusuf tao heti-heuk ndia, dadik hadak nai nusa Masir. Huu ndia, de neme basa hade fo lau-inggu la koluk ndia, ala baꞌe lima kana. Babaꞌek esa feen neu manek, ma babaꞌek haa ala pake hehelin. Kada malangga anggama la dae nala, manek taa hasa sala. Ala pake lakandoon haꞌdak ndia. ");
INSERT INTO llg_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Mulai neme faik ndia mai, hataholi Israꞌel asa leo lakandoo lai Masir, nai dae babaꞌek Gosen. Ala dadik hataholi kamasuꞌik, ma sila numbu-saꞌdu nala boe lamanoꞌu. ");
INSERT INTO llg_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yakob bei nasoda nai Masir teuk sanahulu hitu bali, losa ndia teun basan dadik neu natun esa haa hulu hitu. ");
INSERT INTO llg_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Faik fo ndia mamaten sangga deka-deka, boe ma ana noke Yusuf fo nafadan nae, “Ana Usu aa! Au ameda taa dook so, huu Manetualain noke falik au. De, au oke, fo mete ma o sue au, na o soo fo o boso matoi au nai dae Masir ia. ");
INSERT INTO llg_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","O musi mua falik au mbombolang neni o bei-baꞌi mala mamanan laten neu, fo matoi au nai ndia. Ndia ama hihiin ndindia.” Boe ma, Yusuf nataa nae, “Hei, ama! Mete ma ama nau leondiak, na, kada au tungga leo.” ");
INSERT INTO llg_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Boe ma, Yakob kokolak nae, “Mete ma, leondiak na, hatematak ia o soo dei, fo mae o tungga ama hihiin.” Basa boe ma, Yusuf soo tungga Yakob kokolan ndia. Boe ma, Yakob sendek lunggulanggan neu koi lain, de ana hule-haladoi noke makasi neu Manetualain. ");
INSERT INTO llg_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Taa dook so bali, boe ma hataholi mai nafada Yusuf nae, ndia aman namahedi belak so. De ana noo ana nala dua sala, fo Manase ma Efraim, fo leu tilo sila bain Yakob. ");
INSERT INTO llg_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Faik fo Yakob namanene Yusuf asa mai so, boe ma ana nakatataka aon fo nanggatuuk neu koi lain. ");
INSERT INTO llg_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Boe ma, ana nafada Yusuf nae, “Ana Usu aa! Manetualain fo Ndia koasan ana seli ndia, fain Ana natudu mata-aon neu au neme nggolo Lus nai dae Kanaꞌan. Ana helu au neme ndia, ");
INSERT INTO llg_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","nae, ‘Dei fo Au tao o umbu-ana nala, boe lamanoꞌu, fo o numbu-saꞌdu mala, dadik hataholi nusak inahuuk. Dei fo Au fee nusak ia neu o numbu-sadu mala, fo dadik neu sila pusaka nala, losa daeinak babasan.’ ");
INSERT INTO llg_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Hatematak ia, o anam Efraim ma Manase ndia, sila hak leoiak: Au uni Masir, tehuu sila dua sala lai ele so. Mae leondiak boe oo, tehuu hatematak ia, au tao dua sala sama leo au ana heheling, leo Ruben ma Simeon. ");
INSERT INTO llg_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Tehuu, mete ma o hambu anak bali, na ndia, o anam ndia leo. Au taa tao sila leo au anang. De, ela ala simbo sila pusakan, neme sila kaꞌa nala Efraim ma Manase mai leo. ");
INSERT INTO llg_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Au tao leondiak, fo asaneꞌda o inam Rahel. Faik fo ita fali teme Mesapotamia mai, fo teni Kanaꞌan teu, tehuu inam mate bonggi lenggu neme dalak dekak no nggolo Efrata, nai dae Kanaꞌan. Faik ndia, au dale heꞌdi alan seli! Boe ma, au atoin neu dalak bifin, fo sangga neni nggolo Efrata neu.” (Nggolok ndia, hatematak ia, ala foin, nade Betlehem.) ");
INSERT INTO llg_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","10","Yakob kokolak basa boe ma, ana botik matan, de nita Yusuf ana nala lai ndia. Ana namalasi so, ma ndia mata nala kelembuak so. Huu ndia, de ana natane Yusuf nae, “Wei! Ia, see ana nala ia?” Boe ma, Yusuf nataa nae, “Ia ndia, ana kala fo Manetualain fee au nai Masir ia.” Yakob ana kokolak nae, “Mete ma leondiak na, o mua sala deka-deka lo au dei, fo au hule-haladoi oke Manetualain fee sala babaꞌe-babatik.” Boe ma, Yusuf noo kakana kala sila, leu deka-deka lo Yakob, de ana holu ma idu sala. ");
INSERT INTO llg_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Boe ma, ana kokolak no Yusuf nae, “Doo basa ia, kada au duduꞌa ae, au taa atonggo ua o so. Tehuu hatematak ia, Manetualain tao lena henin seli, losa au bei bisa ita o ana mala boe.” ");
INSERT INTO llg_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Basa boe ma, Yusuf koꞌo heok ana nala leme Yakob mai, boe ma ana sendek lunggulanggan de matan losa dae, neu aman matan. ");
INSERT INTO llg_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Basa boe ma, Yusuf foꞌa, de ana fee ana nala lambadeik deka-deka leu aman matan. Ana tao ana ulun, Manase, neu Yakob boboa konan, ma ana kaduan, Efraim, neu Yakob boboa kiin. ");
INSERT INTO llg_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Tehuu, leꞌdoeik Yakob sangga lalaa liman, fo noke babaꞌe-babatik fee dua sala, boe ma ana lali lima konan de ana taon neu Efraim langgan, ma ana tao lima kiin neu kaꞌan Manase langgan lain. ");
INSERT INTO llg_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Boe ma, ana hule-haladoi noke Manetualain fee babaꞌe-babatik neu Yusuf nae, “O baꞌim Isak aman Abraham, ma baꞌim Isak mesa kana ndia, dua sala tungga lakandoo Manetualain hihiin. Manetualain boe oo, nakaboi au neme au muli-solung mai losa hatematak ia. ");
INSERT INTO llg_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Ana nakamboꞌik au neme basa soe mata-mata kala mai. De au boe oo, oke fo Ana fee babaꞌe-babatik neu kakana kala ia, ma sila numbu-sadu nala. Boe ma, mete ma ala hule-haladoi neu Manetualain, na, ala seseik nakandondoo henin baꞌi Abraham, baꞌi Isak ma au naꞌdeng. Fo ela sila numbu-sadu nala, boe lamanoꞌu, fo dadik hataholi nusak inahuuk, nai daebafok ia.” ");
INSERT INTO llg_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Tehuu, faik fo nita aman ana tao ndia liman konan ndia, neu fadik Efraim langgan, boe ma ana toꞌu nala aman liman ndia, de ana lalin neu kaꞌak Manase langgan. ");
INSERT INTO llg_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Ana nafada aman nae, “Ama aa! Boso tao leondiak, huu ndia ndia, fadik Efraim. Ndia taa uluk. Ama musi tao lima konam neu kaꞌak Manase langgan, huu ana uluk hak ndia.” ");
INSERT INTO llg_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Tehuu aman Yakob taa nau. Boe ma, ana nae, “Ana nggo ei! Memak au bubuluk. Huu dei9 fo Manase dadik ana seli, ma ndia numbu-saꞌdu nala, boe lamanoꞌu, losa ala dadik hataholi nusa inahuuk. Tehuu faꞌdin Efraim ndia, dei fo ana seli lena heni kaꞌan. Ma ndia numbu-sadu nala, dei fo makadotok nalan seli losa ala dadik hataholi nusak noꞌuk, ma ana seli.” ");
INSERT INTO llg_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Basa boe ma, nafada kakanak kadua kala sila, nae, “Mete ma, hataholi Israꞌel asa loke Manetualain babaꞌe-babatik neu hataholi, na, ala seseik ei dua nggei nadem boe, lae, ‘Ela leobee na, Manetualain fee o babaꞌe-babatik, sama leo Ana fee babaꞌe-babatik neu Efraim ma Manase.’ ” No leondiak, Yakob seseik fadik Efraim naden, nakahuluk neme kaan Manase naden mai. ");
INSERT INTO llg_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Basa boe ma, Yakob nafada Yusuf, nae, “Ana nggo ei! Taa dook so huu au mate. Tehuu dei fo Manetualain fali nala ei, boe ma Ana noo falik ei, mini ei bei-baꞌi mala nusan neu. ");
INSERT INTO llg_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Tehuu hatematak ia, au fee o, lena heni au fee o kaꞌa-faꞌdi mala. Huu au fee akadaik o letek manai Kanaꞌan, fo makahulun au haꞌi alan neme hataholi Amori la mai, neu faik fo au atati ua sala.” ");
INSERT INTO llg_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Basa ndia, boe ma Yakob nadenu noke basa ndia ana nala. Ana nafada nae, “Ana nggalei! Mai fo makabubua deka-deka mia au nai ia dei. Au sangga afada ei, esa-esako dala sodan nai fai makabuin.” ");
INSERT INTO llg_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Boe ma, Yakob mulai nafada memeak ndia ana nala nae, “Leoiak! Yakob ana nala! Mai, fo mambadeik eꞌo mala au. Mamanene ei amam Israꞌel ia, sangga kokolak. ");
INSERT INTO llg_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben! O ia, au ana ulung! O ia, au bebeꞌi-balakaing, ma au lima konang. Hataholi la fee o hadak nalan seli so. ");
INSERT INTO llg_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Tehuu o dalem lofoanak nanggongga, fo taa bubuluk o hihiim ndia leobee. Kaꞌda nggenggeneuk o muu sunggu mua au saong Bilha, de tao manggenggeo amam koin. Huu ndia, de o pangga kaꞌan tuda memak! ");
INSERT INTO llg_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeon maLewi! Ei dua nggei leoesak! Ei dua nggei lofoanak nalan seli, mambue feꞌa tafa, fo tao hataholi la doidoso. ");
INSERT INTO llg_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Ei namahokon ndia, tati ketu sapi ei mbimbiin, losa ala lendo lala mamates kada mamanan. Ma ei manggalaun bali, ndia ei mamenggu ei nisi mala, bei fo ei tao misa hataholi. Huu ndia, de au taa nau mbali ei kokola mala. Au boe oo, taa nau seseok ua ei dedeꞌa mala. ");
INSERT INTO llg_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","De hatematak ia, au sumba-soo ei daa saꞌem ndia, huu ana seli susudik! Ma ei nasam fo taa no kasian fa boe. Dei fo ei musi lemba aom ei manggalaun ndia. Dei fo Manetualain mbia ei numbu-sadu mala kii-konak. Boe ma, ala leo latanggelak lai sudi bee, nai dae Israꞌel. ");
INSERT INTO llg_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Yahuda! O naꞌdem ndandaan nae, ‘koa.’ O kaꞌa-fadi mala dei fo ala koa o, ma ala kauk fee haꞌdak neu o. O boe oo, tuni-ndeni mala o musu mala, losa ala taa bisa soꞌuk langga nala. ");
INSERT INTO llg_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","O ia, leo meoasu mulik manai lain seli, fo ana bisa sangga aon nanaꞌak. O boe oo, sama leo meoasu mane, fo ana nakambimbii aon fo sangga ana sunggu, taa hambu esa nambalani dunggu o. O boe oo, sama leo meoasu ina, fo ana nanea ana nala; de taa hambu hataholi nambalani neu tao mata-mata kasa. O leo ndiak boe. Hataholi la, ala bii o, ma ala taa lambalani tao mata-matak neu o. ");
INSERT INTO llg_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Dei fo o ia, toꞌu palenda. O numbu-sadu mala toꞌu palenda latutunggak, losa dei fo hambu esa mana hak basan seli, Ana nanggatuuk toꞌu palenda ndia. Boe ma, basa hataholi nusa kala, kauk ma lamanene neu Ndia. ");
INSERT INTO llg_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Dei fo o masoda no namahokok. O hii hata, na hambun! O sangga mae tao sudi hata boe oo, ana daꞌdi! Huu o banda nala, ma osi la buna-boa nala, boe lamanoꞌu losa nanangganggalik. ");
INSERT INTO llg_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","O nanaꞌa-nininu mala, malada-malada, losa taa hambu mana basak. ");
INSERT INTO llg_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sebulon! O dae pusakan maloa hiak, ma dekak no tasi, losa natoo no kota Sidon. Ofa kala leme basa bee mai, fo ala nggali naka nala no sodak lai namo ndia. ");
INSERT INTO llg_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","15","Isaskar! O ia, sama leo banda keledei balakaik, ma o langga batun ana seli. Mete ma o sunggu nai dalak, na, see bisa nakaseti o foꞌa fo laꞌok makandoo. Tehuu mete ma o mita nggolok ndia neulauk nai ele, na taa nadenu boe oo, o lemba mala o buan fo o muni ndia muu leo. Huu ndia, de, o leondiak leo! ");
INSERT INTO llg_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan! O nadem ndandaan nae, ‘mana maketu’. Boe ma, o ia, ma o numbu-sadu mala sila ndia dei fo laketu o hataholi nusa Israꞌel dedeꞌan, taa mana benu selik. ");
INSERT INTO llg_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","O ia boe oo, malelak leo mengge kalasok, fo ana sunggu nai dalak bifin. Mete ma, hataholi saꞌe ndala nesik ndia, na, nggengge neuk, o kiki mala ndala ei dean mbimbiin, losa manasaꞌek tuda. ");
INSERT INTO llg_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Ou MANETUALAIN! Au hule-haladoi fo O masalaꞌe mala ai basa nggai. ");
INSERT INTO llg_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gad! O naꞌdem liin hihii sama leo ‘sambu’. Dei fo naꞌo la sambu o, tehuu o sambu masafali sala. ");
INSERT INTO llg_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Aser! Dei fo osim buna-boan neulau hiak, losa o bisa tao kokis, neulau kala ma malada fo mane kala ala hasa nai o. ");
INSERT INTO llg_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naftali! O ia, sama leo nusa mana malai neu fuik, fo taa hambu hataholi heti o. O boe oo, bonggi mala ana kala manaꞌa hia kala. ");
INSERT INTO llg_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yusuf! O sama leo ai longgek mana namak, fo ana nasoda dekak no oe. O baꞌe nala, nama leni tembo madema lain leu. ");
INSERT INTO llg_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Hambu hataholi boe, ala mbia sila dale heꞌdin neu o, sama leo musu la kou o. ");
INSERT INTO llg_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Tehuu Manetualain fo au akaluku-akatelek neu Ndia, Ana fali nala o. Huu ndia, de Ana tao natea o limam losa o bisa kou masa fali sala, mae neme doon ana seli mai. O bisa senggi sala, huu Manetualain Ana fali nala o, huu memak Ndia koasan ana seli tebe! Huu ndia, de au asalai neu Ndia. Huu Ndia ndia, nanea au. ");
INSERT INTO llg_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Dei fo Ndia nanea o boe. Ma Ana fee babaꞌe-babatik neu o, neme lalai mai, babaꞌe-babatik neme daebafok mai, ma babaꞌe-babatik fo bonggi anak makadotok, ma taa kamaheꞌdi kala. ");
INSERT INTO llg_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Lete kala taa manamopok. Ma au babaꞌe-babating feen neu o ia, noꞌun lena heni basa lete kala! Ela basa babaꞌe-babatik ia, nanangganggak neu o, huu o lena heni neme basa o kaꞌa-fadi mala mai. ");
INSERT INTO llg_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benyamin! O kambalanin sama leo busa fui mana ndoek ia. Bei fafai anak, naa te ana neu sombu, fo ana humu nala ndia nanaꞌan so. Tehuu mete ma leꞌodae, na, ana neu babaꞌe nanaꞌa ela kala, neu ana nala. O numbu-sadu mala, ana seli leondiak boe!” ");
INSERT INTO llg_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Leondia leo, Yakob nafada memak, ana nala dala sodan nai fai makabuin, esa-esak no ndia numbu-sadu nala. Sila basa sala sila, lakonda leo Israꞌel sanahulu dua. ");
INSERT INTO llg_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","30","Yakob noke ndia ana nala, de ana hehelu, nae, “Taa dook so, huu au mate ia so. Mete ma au mate, na ei musi miu matoi au nai Baꞌi Abraham mamana laten. Lates ndia nai luak, fo dekak no nggolo Makpela ma Mamre, nai dae Kanaꞌan. Makahulun Baꞌi Abraham hasa nala luak ndia no osin, fo ana taon neu mamana lates. Ana tifa ketun neme hataholi leo Het, fo naden Efron. ");
INSERT INTO llg_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Nai ndia, ala latoi ita Baꞌin Abraham ma bei Sara, au amang Isak, ma au inang Ribka. De, ei musi matoi au nai ndia, neu au saong Lea boboan. ");
INSERT INTO llg_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Ei boso mafalende henin matoi au neu luak ndia, fo Baꞌi Abraham hasa nalan so.” ");
INSERT INTO llg_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Yakob ana kokolak nateꞌe leondia, boe ma ana sunggu seluk neu koi lain, boe ma maten. ");
INSERT INTO llg_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Boe ma, Yusuf holu nala aman, de namatani nakaleleu. Boe ma, ana idun bali-bali. ");
INSERT INTO llg_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Basa ndia, boe ma Yusuf palenda hataholi mana makaneni mamate, fo ala tao akidook neun, suek tao Yakob mbombolan nahele leondiak. ");
INSERT INTO llg_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Boe ma, hataholi la lakaneni mbombolak ndia losa faik haa hulu, tungga sila natetemen. De basa hataholi Masir asa tungga lamatani Yakob mamaten boe. Ala tao leondiak losa faik hitu hulu, sama leo sila hataholi inahuun maten. ");
INSERT INTO llg_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Basa fai kahitu hulun, boe ma Yusuf nafada manek pegawe nala nae, “Mamanene! Au oke fo ei mini au kokolang ia, neu manek mae leoia: ");
INSERT INTO llg_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Faik fo au amang sangga maten, ana noke fo au uu atoi ndia mbombolan nai dae Kanaꞌan. De au oke manek nakamboꞌik au uu atoi au amang. Basa na, bei fo au fali ia mai.’ ” ");
INSERT INTO llg_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Manek namanene leondia, boe ma nataa nae, “Mete ma o helu amam leondiak so, na, muu matoin nai ele leo.” ");
INSERT INTO llg_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Boe ma, Yusuf neu natoi aman. Hataholi noꞌu kala leu tunggan boe, fo ndia manek pegawa nala ma basa hataholi inahuu nala malai Masir. ");
INSERT INTO llg_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Yusuf kaꞌa-fadi nala, ma basa sila hataholi mana tao ue-ledi nala, tungga leu latoi Yakob boe. Ela kala manai Gosen, kada sila sao nala ma ana kadiꞌi kala, ma sila banda nala. ");
INSERT INTO llg_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Soldadu noꞌu kala tungga boe. Hambu ala pake nggili, ma hambu ala saꞌe ndala. Huu mana tungga kala sila, noꞌun seli, de hataholi mana laꞌo eik tungga mamate nalun seli. ");
INSERT INTO llg_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Basa sala laꞌok losa ala lena lee Yarden, nai mamanak esa nade Atad. Hataholi la lateme mai femba hade lai ndia. Boe ma, Yusuf asa lamatani lakaleleu aman mamaten leme ndia, de ala beꞌe faik hitu bali. ");
INSERT INTO llg_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Leꞌdoeik hataholi Kanaꞌan malai ndia kala lita ala dale hedi leondiak, boe ma ala kokolak lae, “Wei! Ei mita dei. Hataholi Masir asa tatao bebeꞌen dale heꞌdin ana seli bali! Ala lamatani losa leondiak.” Huu ndia, de ala foi mamanak ndia, nade Abel-Misraim. Ndia ndandaan, nae, ‘hataholi Masir asa dale hedin’. ");
INSERT INTO llg_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Boe ma, Yakob ana nala tao tungga sama leo sila hehelun ndia. ");
INSERT INTO llg_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Boe ma, ala koꞌo leni Yakob mbombolan, fo leu latoin nai luak dekak no nggolo Makpela ma Mamre. Abraham hasa nala mamanak ndia so, neme hataholi leo Het mai, nade Efron, fo ana dadik neu sila mamana laten. ");
INSERT INTO llg_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Yusuf no ndia kaꞌa-fadi nala latoi lateꞌe aman, boe ma ala fali Masir leu. Leondiak boe basa hataholi feꞌe kala mana tungga leu latoi, lo sila. ");
INSERT INTO llg_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Ala losa Masir leondia, boe ma Yusuf kaꞌa nala ala mulai bii, huu sila aman taa kana so, de ala lakokola lae, “Wei! Ei duduꞌa dei! Leo Yusuf ana bei nambeda dalek neu ita, fo ana bala ita tatao manggalaun neu ndia, na, leobee?” ");
INSERT INTO llg_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Boe ma, ala lala halak fo ala haitua Yusuf halak, lae leoia: “Ama wakil. Ai bei masaneda faik fo ita aman bei kasodak ndia, ana nadenu ai ");
INSERT INTO llg_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","fo mafada ama mae, ‘Usu musi fee ambon neu ndia kaꞌa nala sala nala. Huu makahulun sila tao manggalauk neu ndia. Ai boe oo masaneda ita aman nakaluku-nakatele neu Manetualain neme makahulun mai. Ai dadik Manetualain ata nala. Huu ndia de hatematak ia, ai mai moke ambon, huu ai basa nggai tao masala Ama so.’ ” Yusuf namanene leondia, boe ma ana namatani. ");
INSERT INTO llg_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Basa boe ma, ndia kaꞌa nala mai aon, de ala sendek lunggulangga nala leu matan, de ala kokolak lae, “Ela ama ana tao ai, dadik ama atam leo.” ");
INSERT INTO llg_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Tehuu Yusuf nafada sala nae, “Kaꞌa nggalei! Ei boso bii bali! Kada Manetualain mesa kana naena hak huku hataholi. Tehuu au ia, taa. ");
INSERT INTO llg_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Makahulun, memak ei mala halak so, fo sangga tao manggalauk neu au. Tehuu Manetualain tao nasafalik ei hihii manggalaum ndia, dadik neulauk. Huu ndia, de Ana soꞌu nala au daꞌdik hataholi inahuuk, fo hataholi noꞌu kala bisa lasoda. ");
INSERT INTO llg_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","De hatematak ia, au afada ei so, fo boso bii bali. Huu au helu, dei fo au mbali ei, ma basa ei ana mala.” No kokolak malolole leondiak, de Yusuf tao natesa kaꞌa nala dale. ");
INSERT INTO llg_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Basa ndia, boe ma Yusuf leo nakandoo nai Masir, no basa ndia kaꞌa-faꞌdi nala. Ana nasoꞌda losa teun natun esa sanahulu. ");
INSERT INTO llg_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Ana bei hambu nita Efraim umbu-ana nala. Ma ndia mesa kana nakaboi Manase umbu nala, fo ndia Makir ana nala, ");
INSERT INTO llg_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Yusuf nafada kaꞌa nala, nae, “Kaꞌa nggalei! Au amemedak, au fai mamateng deka-deka so. Tehuu au amahele, neu ko Manetualain nakaboi ei. Ndia ndia, dei fo Ana no ei kalua mima nusak ia mai. Ndia ndia, Ana nalangga ei fali mini nusak fo Ana soo helu neu Baꞌi Abraham, Baꞌi Isak, ma ama Yakob.” ");
INSERT INTO llg_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Boe ma, Yusuf noke ndia bobonggi nala ala soo, lae, “Ei musi helu au. Mete ma losa faik fo Manetualain Ana no falik ei, mini nusak ndia miu, na, ei musi mini au dui-loung.” ");
INSERT INTO llg_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Basa boe ma, Yusuf maten nai Masir neu teun natun esa sanahulu. Boe ma, ala tao akidook neu ndia mbombolan, de ala taon neni kopan dale neu. ");
INSERT INTO llg_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","2","Susulak ia, tui laꞌeneu Yesus Karistus, fo Hataholi ndia, Manetualain helu mema kana, neme makahulun mai so, fo sangga haituan mai. Ndia ndia, baꞌi Abraham ma mane Dauk numbu-sadun. Mulai neme baꞌi Abraham losa mane Dauk, hambu dope sanahulu haa. Susula nadek bei-baꞌi nala, leoiak: Abraham bonggi Isak, Isak bonggi Yakob, Yakob bonggi Yahuda no ndia kaꞌa fadi nala, ");
INSERT INTO llg_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yahuda bonggi Peres no Sera (sila inan, nade Tamar), Peres bonggi Herson, Herson bonggi Ram, ");
INSERT INTO llg_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram bonggi Aminadab, Aminadab bonggi Nahason, Nahason bonggi Salmon, ");
INSERT INTO llg_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon bonggi Boꞌas (inan nade Rahab), Boꞌas bonggi Obet (inan nade Rut) Obet bonggi Isai, ");
INSERT INTO llg_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isai bonggi Dauk. ");
INSERT INTO llg_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","11","Neme Dauk mai, losa faik ndia, hataholi nusa Israel nana fua henik leni Babel leu, hambu dope sanahulu haa bali, fo ndia: Dauk bonggi Soleman (inan ndia makahulun Uria saon). Soleman bonggi Rehabeam, Rehabeam bonggi Abia, Abia bonggi Asaf, Asaf bonggi Yosafat, Yosafat bonggi Yoram, Yoram bonggi Usia, Usia bonggi Yotam, Yotam bonggi Ahas, Ahas bonggi Heskia, Heskia bonggi Manase, Manase bonggi Amos, Amos bonggi Yosias, Yosias bonggi Yekonya, ma ndia fadi nala, fo neu faik ala fua sala leni Babel leu. ");
INSERT INTO llg_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","16","Faik, fo sila nanafuak leni Babel leu losa Yesus, hambu dope sanahulu haa bali, ndia: Yekonya bonggi Saltiel, Saltiel bonggi Serubabel, Serubabel bonggi Abihut, Abihut bonggi Elyakim, Elyakim bonggi Asor, Asor bonggi Sadok, Sadok bonggi Akim, Akim bonggi Eliut, Eliut bonggi Eliasar, Eliasar bonggi Matan, Matan bonggi Yakob, Yakob bonggi Yusuf. Yusuf ndia, sao nala Maria. Boe ma Maria ndia bonggi nala Yesus Karistus. ");
INSERT INTO llg_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","De, mulai neme Abraham mai, losa Dauk, hambu dope sanahulu haa; neme Dauk mai, losa ala fua sala leni Babel leu, hambu dope sanahulu haa; ma neme Babel mai, losa bonggi Karistus, hambu dope sanahulu haa. ");
INSERT INTO llg_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Maria bonggi Yesus ndia, na tutuin leoiak: Maria nafufudik no Yusuf so. Dua sala bei ta sunggu lakabubua, leo masao kala, naa te, Maria nailu neme Manetualain Dula Dale Malalaon mai so. ");
INSERT INTO llg_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ledoeik Yusuf bubuluk leondiak, boe ma ana sangga tao naketu sila dua sala natututin. Tehuu taa nau tao nakamamaek Maria nai hataholi noꞌuk mata nala, huu ndia dalen malalaok. Huu ndia de ana sangga tao naketun kada no neneek. ");
INSERT INTO llg_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Boe ma, ledoeik ana bei duduꞌa neu-mai, leꞌodaek esa ana nalameꞌi. Nai meꞌis ndia dalek, nita Manetualain atan neme nusa-sodak mai nafadan, nae, “Wei Yusuf! O ia, mane Dauk numbu-sadun. O boso makandaa sao mala Maria. Huu, kakanak manai ndia tein dalek ndia, Lamatuak Dulan tataon ndia. ");
INSERT INTO llg_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Dei fo, Maria bonggi kakana touanak esa. Basa na, o musi foin nade Yesus, huu neu ko, Ndia tao nasoda Manetualain hataholin nala leme sila salan nala mai.” ");
INSERT INTO llg_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Dedeꞌak ia neu ko dadi leondiak, huu Manetualain nafada mema kana neme makahulun mai so. Ana pake nitak Ndia mana kokolan Yesaya fo sulak nae, ");
INSERT INTO llg_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Ei mamanene baa! Dei fo inanak esa bei aotema, naa te nailu. Basa de, ana bonggi kakana touanak esa. Ala foin nade Imanuel.” (Nai dedeꞌa Ibrani, ‘Imanuel’ ndandaan nae: Manetualain no ita basa nggata.) ");
INSERT INTO llg_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yusuf nalameꞌi basa, boe ma ana foꞌa. De, ana tao tungga tutik Manetualain hehelun ndia. Ana haꞌi nala Maria dadik neu ndia saon, ");
INSERT INTO llg_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","tehuu, taa sunggu nakabubua non leo masaok ia, losa Maria bonggi heni Kakanak ndia. Bonggi basa boe ma, Yusuf foi Kakanak ndia nade Yesus. ");
INSERT INTO llg_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Lelek bonggi Yesus nai nggolo Betlehem nai propinsi Yudea, mane Herodes toꞌu palenda. Faik ndia, hataholi luma leme dook dulu ele mai, leni kota Yerusalem leu. Sila ndia, hataholi malelak mana mete nduuk. ");
INSERT INTO llg_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ledoeik ala losa Yerusalem, ala latane neu-mai, lae, “Hataholi Yahudi la manen fo bei fo bonggin ndia, nai bee, bae? Ai mita nduuk esa nai dulu ele so, natudu tanda nae, Ndia nanabonggik so. Huu ndia de, ai mai fo sangga makaluku-makatele neun.” ");
INSERT INTO llg_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ledoeik mane Herodes namanene sila kokolan leondiak, boe ma dalen nameda taa malole. Huu ndia de, basa hataholi malai Yerusalem lameda leondiak boe. ");
INSERT INTO llg_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Basa boe ma, mane Herodes nakabubua nala malangga anggama Yahudi la malanggan nala, ma basa mese anggama la, de natane sala, nae, “Hena ei mafada au dei! Karistus, fo Manetualain helu mema kana ndia, sangga bonggin nai bee bae?” ");
INSERT INTO llg_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Boe ma lataa lae, “Papa manek, nai nggolo Betlehem, nai propinsi Yudea. Huu Lamatuak mana kokolan Mika sulak mema kana so, neme makahulun mai, leoiak: ");
INSERT INTO llg_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Wei, ei hataholi Betlehem asa, manai propinsi Yudea ele. Ei boso maehetuk, ei nggolom ndia, kada nggolo kadiꞌi anak, fo sosoa-ndandaan taa. Tehuu dei fo hataholi ina-huuk esa neme ndia mai. Dei fo Ana dadik mana hoo neu Au hataholi Israel asa.’ ” ");
INSERT INTO llg_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Namanene basa leondiak, boe ma mane Herodes noke no neneek, hataholi malelak mana mete nduu kala. Boe ma natane sala faik bee ndia, ala lita nduuk ndia sadu nai lalai. Boe ma ala lafadan. ");
INSERT INTO llg_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Basa de, ana haitua sala leni Betlehem leu ma nafada sala nae, “Ei miu, fo sangga mafeok Kakanak ndia nai ele. Mete ma ei matonggo mian so, na, fali mai mafada au. Huu au boe oo, sangga uu akaluku-akatele neun.” ");
INSERT INTO llg_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Lamanene basa manek kokolan, boe ma leu. De, lita seluk nduuk fo makahulun litak kana nai dulu ele. Nduuk ndia sadu neu sila matan, boe ma ana laꞌok, de hahae ndandaak neu Kakanak ndia mamana leleon lain. ");
INSERT INTO llg_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Lita leondiak, boe ma ala lamahoko lalan seli. ");
INSERT INTO llg_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ala dudi leni uma ndia dalek leu, de lita Kakanak ndia ma inan Maria. Boe ma ala sendek lunggulanggan nala, fo lakaluku-lakatele leu Ndia. Basa de ala lofa sila mbomboti hadia bua mabeli la, de ala feen neu Kakanak ndia. Ala fee lilo mbilas, ma kamanyan, ma aidaa boo menik. ");
INSERT INTO llg_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Taa dook, boe ma ala hambu meꞌis neme Manetualain mai, nae, “Ei boso fali mini mane Herodes miu bali.” Huu ndia de ala fali leni nusa nala leu, tungga dala feꞌek. ");
INSERT INTO llg_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ledoeik hataholi malela mete nduuk kala fali, boe ma Lamatuak atan esa neme nusa-sodak mai, nafada Yusuf nai meꞌis dale nae, “Wei, Usu aa! Foꞌa lai-lai leo! Koꞌo mala Kakanak ndia ma mua inan, fo malai mini Masir ele miu. Leo mahele mima ndia, losa Au afada fai hida ei bole fali, huu mane Herodes sanggan, fo sangga tao nisa Kakanak ndia!” ");
INSERT INTO llg_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Boe ma Yusuf foꞌa, de no sao-anan leꞌodaen ndia boe, lalai leni Masir leu. ");
INSERT INTO llg_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ala leo lai ele losa Herodes maten. No leondiak na, Manetualain kokolan dadi, sama leo Ndia mana kokolan Hosea nafada memak neme makahulun mai so, nae, “Au oke falik Au Anang, fo kalua neme Masir mai.” ");
INSERT INTO llg_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ledoeik mane Herodes bubuluk nae, hataholi malela mana mete nduuk kala, laꞌeo kana, boe ma ana luli nalan seli. Ana palenda ndia soldadun nala, nae, “Mini nggolo Betlehem ma nggolo-nggolo mana dekak lai ndia. Tao misa basa kakana touana kadiꞌiana kala, fo teu nala teuk dua dae neu.” Herodes palenda leondiak, huu nasaneda hataholi malela kala sila tutui nala. Ana hinggan mulai neme sososan fo lita nduuk sadu nai lalai. ");
INSERT INTO llg_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Basa dedeꞌa kala ia dadi, tungga hata fo Manetualain mana kokolan Yeremia sulak mema kana neme makahulun mai so, nae, ");
INSERT INTO llg_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Hambu hataholi namatani nasakekedu nai kota Rama. Rahel nakaleleu, huu mate basa anan nala. Taa nau hataholi mai kokoen, huu ndia anan nala taa kasa so.” ");
INSERT INTO llg_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Doo-doo, boe ma mane Herodes maten. Faik ndia Yusuf asa bei lai Masir. Boe ma Manetualain atan esa neme nusa-sodak mai, ana mai natudu mata-aon neu ndia nai meꞌis dale. ");
INSERT INTO llg_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ata ndia nae, “Wei, Usu aa! Foꞌa leo! Mua falik Kakanak ndia no inan, mini Israel miu leo. Huu hataholi mana sangga tao nisa Kakanak ndia, maten so.” ");
INSERT INTO llg_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Namanene leondiak, boe ma Yusuf foꞌa, de noo fali kasa leni Israel leu. ");
INSERT INTO llg_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Tehuu ledoeik namanene nae, hatematak ia Herodes anan Arkalaus toꞌu palenda nai propinsi Yudea, boe ma ana bii fali neni ndia neu. De Manetualain palendan tungga meꞌis esa bali, nae, “Yusuf, o boso leo nai Yudea.” Huu ndia, de, neu leo nai propinsi Galelea, ");
INSERT INTO llg_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","nai nggolok esa nade Nasaret. No leondiak, Manetualain kokolan ndia dadi matetuk so, tungga hata fo Ndia mana kokolan sulak mema kana so, nae, “Dei fo ala loken na lae, Hataholi Nasaret.” ");
INSERT INTO llg_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Faik fo, Yesus ina-huu so, boe ma Yohanis Mana Salanik mulai nanoli hataholi la lai mamana nes, nai propinsi Yudea. ");
INSERT INTO llg_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ana nafada nae, “Tolanoo susue nggalei! Ei musi manaku ma laꞌo ela ei sala mala, fo fali mini Manetualain miu leo. Huu, hatematak ia, basa hataholi la bisa maso dadik Manetualain hataholin nala so.” ");
INSERT INTO llg_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Makahulun Manetualain mana kokolan esa, nade Yesaya sulak so, laꞌeneu Yohanis, nae, “Dei fo hambu hataholi mana manggouk nai mamana nes, nae, ‘Basa hataholi mahehele, fo tao neulalau dalak, fo soluk Manetualain mamain! Tao mandoo dalak soaneu Ndia!’ ” ");
INSERT INTO llg_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohanis ia dala sodan sama leo Lamatuak mana kokola makahulun nala. Ndia baloꞌa papaken, nana taok neme banda onta bulun mai. Kalikeen, nana taok neme banda loun mai. Ndia nanaꞌa-nininun, lamak ma fani oe nula. ");
INSERT INTO llg_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Faik ndia hataholi noꞌu kala mai fo sangga latonggo lo Yohanis. Ala mai leme Yerusalem, ma basa propinsi Yudea isin. Sila boe oo, leme nggolo kala mana dekak no lee Yarden. ");
INSERT INTO llg_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ala lalengga dalen nala, ma manaku basa sila sala-singgon nala, basa de, Yohanis salani sala leme lee Yarden. ");
INSERT INTO llg_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Faik ndia, hataholi la leme partei anggama Farisi, ma partei anggama Saduki boe, ala mai fo loke Yohanis salani sala. Tehuu ledoeik ana nita sala, boe ma nasapala kasa, nae, “Heh! Ei ia sama leo mengge fo masapepekok! Dei fo Manetualain huku ei, huu ei tatao-nonoꞌi manggalau mala. Weih! Boso maehetuk ei bisa malai kalua mima Ndia huhukun mai. ");
INSERT INTO llg_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","De, malolenak ei fali mini Manetualain miu, ma laꞌo ela basa ei sala-singgo mala. Basa ndia, na, ama tao dedeꞌa malole, sama leo ai huuk mana maboa boa malole. ");
INSERT INTO llg_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Boso maehetuk ei sodak so, huu ei ia, baꞌi Abraham numbu-sadun. Mamahele au! Huu Manetualain bisa tao nala batu la ia, dadik neu baꞌi Abraham numbu-sadun. ");
INSERT INTO llg_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Mata neuk baa! Huu Hataholi mana toꞌu taka, nahehele fo sangga kekeko ai huuk boa taak. Kekeko basa, boe ma Ana mbian neni haꞌi dale neu. ");
INSERT INTO llg_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Hatematak ia au salani ei unik oe, fo dadik tanda, nae, ei heok masadea ela ei sala-singgo mala so. Tehuu dei fo Hataholi esa ana seli lena heni au, sangga mai. Mae kada dadik neu Ndia nadedenun boe oo, au taa andaa. Dei fo Ana tao nahenu ei dale mala no Lamatuak Dula Dale Malalaon. Ndia boe oo, tao nalalao ei, sama leo hataholi pake haꞌi fo hotu kadafuk. ");
INSERT INTO llg_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Huu Ana toꞌu oko henuk no isik, fo sangga daꞌi heni uun. Basa na Ana tao isi kala leni karon dale neu. Tehuu, Ana mbia henin uu kala leni haꞌi dale leu, fo mana mbilak taa no mana basak.” ");
INSERT INTO llg_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Faik ndia, Yesus loe neme Galelea mai neni lee Yarden neu. Ana mai noke Yohanis salani Ndia, ");
INSERT INTO llg_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","tehuu Yohanis taa nau. Ana sapa nae, “Talobee de au musi salani Lamatuak? Taa kasafalik ia do? Lamatuak musi salani au dei. Huu au paluuk ndindia, maa!” ");
INSERT INTO llg_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Tehuu Yesus nataa nae, “Taa hata-hata. Huu, soaneu hatematak ia, na, ela kaꞌa ndia salani Au. No leondiak na, ita tungga Manetualain hihii-nanaun.” Namanene leondiak, boe ma Yohanis nataa nae, “Kada neme Lamatuak mai.” De ana salani Yesus. ");
INSERT INTO llg_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Salani nateꞌe, boe ma Yesus kalua neme lee dale mai. Tehuu kada nggengge neuk, lalai natahuꞌak. Boe ma nita Manetualain Dulan konda neu Ndia, sama leo lunda mai saꞌe neu Ndia. ");
INSERT INTO llg_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Boe ma lamanene Manetualain nahala neme lalai mai, nae, “Ndia ia, Au Ana susueng. Ana tao namahoko Au daleng taa-taa.” ");
INSERT INTO llg_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Basa ndia, boe ma Manetualain Dulan noo Yesus neni mamana nes neu, fo suek nitu la malanggan fufudi-oꞌodon. ");
INSERT INTO llg_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Boe ma Ana puasa nai ndia, leledok haa hulu ma leꞌodaek haa hulu. Ana ndoe nalan seli. ");
INSERT INTO llg_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ledoeik Ana ndoe leondiak, boe ma nitu la malangga ina-huun mai fufudi-oꞌodon, nae, “O ia tebe-tebe Manetualain Anan do? Mete ma tetebes, na, palenda batu la ia, fo dadik neu nanaꞌak leo.” ");
INSERT INTO llg_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Tehuu Yesus nataan nae, “Nana sulak nai Manetualain Susula Malalaon dale, nae: ‘Hataholi taa nasoda nenik kada nanaꞌak. Tehuu sila boe oo, musi lamanene Manetualain Dedeꞌa-kokolan, ma tao tungga Ndia hihii-nanaun.’ ” ");
INSERT INTO llg_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Boe ma, nitu ndia noo Yesus neni kota Yerusalem neu, fo Lamatuak kota malalaon ndia. Basa de, ndia noo Yesus hene neni Uma Ina Huhule-haladoik mbunin lain neu. ");
INSERT INTO llg_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Boe ma nitu nae, “Mete ma tebe-tebe Manetualain Anan O, na, O makaboku sudik dae muu. Huu, nana sulak nai Manetualain Susula Malalaon nae, ‘Dei fo Manetualain palenda ata nusa-sodan nala, fo lanea O.’ Nai Manetualain Susula Malalaon boe nana sulak, nae, ‘Dei fo ala latanee lala O, lenik sila lima nala, fo suek O aom taa hedis, ma taa laꞌe batu boe.’ ” ");
INSERT INTO llg_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Tehuu Yesus nataan nae, “Nana sulak nai Manetualain Susula Malalaon boe nae, ‘Manetualain ndia, o Lamatuam. Huu ndia de, o boso soban.’ ” ");
INSERT INTO llg_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Boe ma nitu ndia, noo Yesus neni letek madema esa lain neu. De, ana natudu basa nusa kala manai daebafok, ma basa nula nambu nala. ");
INSERT INTO llg_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Natudu basa sila, boe ma nitu nafada nae, “Sadi O sendek lunggulanggam, fo makaluku-makatele neu au, na, dei fo au fee basa sila leu O.” ");
INSERT INTO llg_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Tehuu Yesus nasapala kana, nae, “Heh, nitu! O malai heok ia! Huu Manetualain Susula Malalaon nafada nae, ‘O musi makaluku-makatele neu Manetualain, ma o musi kada tao ues fee Ndia.’ ” ");
INSERT INTO llg_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Namanene leondiak, boe ma nitu laꞌo ela Yesus. Tehuu Manetualain ata nusa-sodan nala mai, fo ono-lau Ndia. ");
INSERT INTO llg_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Faik ndia, mane Herodes nandee Yohanis Mana Salanik neni bui dale neu. Ledoeik Yesus namanene leondiak, boe ma Ana fali neni Galelea neu. ");
INSERT INTO llg_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Neni Ndia nggolon Nasaret neu, boe ma Ana laꞌo nakandoo, fo neu leo nai nggolo Kapernaum. Nggolok ndia, nai dano Galelea bifin, fo nai Sebulon ma Naftali daen. ");
INSERT INTO llg_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","No leondiak, Ana tao tungga hata fo Manetualain mana kokolan Yesaya sulak mema kana so, nae, ");
INSERT INTO llg_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sebulon daen, ma Naftali daen, fo dekak nai dano Galelea, nai lee Yarden boboan. Hataholi taa Yahudi la leo lai ndia. ");
INSERT INTO llg_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Lasoda lai makiuk dale, tehuu hatematak ia, ala lita Manggaledok so. Huu hatematak ia, Manggaledok nasaꞌa so soaneu basa hataholi la fo bei ta lalelak Manetualain.” ");
INSERT INTO llg_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Neme faik ndia mai, Yesus mulai nanoli hataholi la, nae, “Ei musi heok masadea ma laꞌo ela ei sala-singgo mala, fo masoda malalaok leo! Huu hatematak ia, basa hataholi la bisa maso dadik Manetualain hataholin nala so. ");
INSERT INTO llg_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Faik esa, Yesus laꞌok tungga dano Galelea bifin. Ana natonggo no hataholi dua kaꞌa-fadi kala. Esak nade Simon, tehuu hataholi lateme loken lae, Petrus. Ma fadin nade Anderias. Ala dala iꞌak leme dano dale, huu dua sala sila mana tao tasi. ");
INSERT INTO llg_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Boe ma Yesus noke sala, nae, “Wei, mai tungga Au leo! Ei mateme sangga iꞌak, tehuu hatematak ia, Au sangga anoli ei, fo dadik miu mana sangga samanek.” ");
INSERT INTO llg_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Lamanene basa leondiak, boe ma dua sala laꞌo ela dala nala, de ala tungga tutik Yesus. ");
INSERT INTO llg_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Basa ndia, boe ma Yesus laꞌok nakandoo doo-doo fa bali, boe ma nita Sabadeus ana nala. Kaꞌak naden Yakobis, ma ndia fadin nade Yohanis. Dua sala lo aman tao neulalau mbuꞌa nala leme ofak dale. Boe ma Yesus noke nala dua sala fo tunggan. ");
INSERT INTO llg_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Lamanene leondiak, boe ma ala laꞌo ela sila aman, ma sila ofan, de ala tungga tutik Ndia. ");
INSERT INTO llg_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Basa ndia, boe ma Yesus laꞌok ndule propinsi Galelea, fo Ana nanoli nai hataholi Yahudi la uma huhule-haladoin dale. Ana nanoli laꞌeneu Manetualain Hala Malolen, ma nafada dalan leobeek, fo hataholi bisa tungga Manetualain palendan. Ma Ndia boe oo, tao nahai basa hataholi la leme hedis mata-mata kala mai. ");
INSERT INTO llg_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Taa dook boe, halak laꞌeneu Yesus tataon ndia, nana tui-benggak nafeok losa nusa Siria. Basa boe ma, hataholi la loo sila hataholi kamahedi nala mata-mata kala, leni Ndia leu. Sila boe oo, loo hataholi nitu nalak, mulu biꞌik, ma luꞌuk. Boe ma Ana tao nahai basa sala. ");
INSERT INTO llg_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Faik ndia, hataholi makadoto kala mai tunggan. Ala mai leme propinsi Galelea, ma leme dae babaꞌek Kota Sanahulu, fo lae, Dekapolis. Hambu luma leme kota Yerusalem, leme propinsi Yudea, ma leme lee Yarden boboan mai. ");
INSERT INTO llg_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ledoeik Yesus nita hataholi makadotok ala mai tunggan, boe ma Ana hene neni lete anak esa lain neu, de nanggatuuk neu ndia. Ndia ana mana tungga nala fo Ana hele nala kala sila, leu deka-deka, fo lamanenen. ");
INSERT INTO llg_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Basa de, Ana mulai nanoli sala, nae, ");
INSERT INTO llg_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Hataholi mana toꞌa-taa kala ua-nale nala malole, huu Manetualain ndia mesa kana sila Mane malolen. ");
INSERT INTO llg_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Hataholi mana nameda dale hedi kala, ua-nale nala malole, huu Manetualain mesa kana ndia kokoe sala. ");
INSERT INTO llg_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Hataholi kadiꞌi-taidae kala, ua-nale nala malole, huu neu ko ala simbo basa babaꞌe-babatik fo Manetualain helun so. ");
INSERT INTO llg_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Hataholi fo mana dokodoe nalan seli neu Manetualain dala ndoon, ua-nale nala malole, huu neu ko Ana tao natetu hihiin nala. ");
INSERT INTO llg_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Hataholi mana matudu namemeda kasia nala, ua-nale nala malole, huu neu ko Manetualain tuda kasian neu sala. ");
INSERT INTO llg_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Hataholi dale malalao kala, ua-nale nala malole, huu neu ko sila mesa kasa bisa lita Manetualain. ");
INSERT INTO llg_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Hataholi mana tao mole-dame sila, ua-nale nala malole, huu neu ko Manetualain nae, ‘Sila ndia, Au anang.’ ");
INSERT INTO llg_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Hataholi mana hambu doidosok, huu ala tungga Manetualain, ua-nale nala malole, huu Lamatuak ndia mesa kana, sila Mane malolen. ");
INSERT INTO llg_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Mete ma hataholi feꞌek tao doidoso ei, huu ei tungga Au, na, ei boe oo ua-nale mala malole boe. Mete ma ala kokolak manggalauk neu ei, ma tui pepekok fo tao laboo ei nade mala, na, ei boe oo ua-nale mala malole. ");
INSERT INTO llg_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Mae leondiak, tehuu ei musi kada tao mamahoko ei dale mala, huu Manetualain sadia bala fee ei babaꞌe mala makadotok nai nusa-sodak. Tehuu masanenedak bou! Taa kada ei mesa nggei hambu doidosok leondiak, huu lele uluk ele, hataholi la tao manggalauk leondiak neu Manetualain mana kokola nala. ");
INSERT INTO llg_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Mete ma ita sangga tao talalada nanaꞌak, na, ita paluu tao masik neu dei. Leondiak boe, hataholi la fo lasoda lai daebafok ia, ala paluu ei. Tehuu mete ma masik mamin so, na, ndia sosoan hata? Kada nggali henin neu dalak lain fo nana hehetak. ");
INSERT INTO llg_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ei boe oo, musi masoda leo banduk, suek hataholi noꞌu kala lita neulalau. Ei musi mbila manggaledo ndoos, sama leo kota manai letek lain, fo basa hataholi la litan. ");
INSERT INTO llg_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Hataholi mana dede bandu anak, taa tao banduk ndia neni ule dae dale neu. Tehuu ala tao bandu anak ndia neu mamana madema, suek bisa ana nanggaledo neu basa uma isi nala. ");
INSERT INTO llg_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ei boe musi masoda leondiak. Ei musi masaꞌa, suek hataholi feꞌe kala bisa lita ei soda malole mala. De lita leondiak, na, dei fo ala koa-kio Manetualain, lae, ‘Wei! Ei Amam manai nusa-sodak ndia, ana seli, bae maa!’ ” ");
INSERT INTO llg_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Ei boso duduꞌa mae, Au uni daebafok ia mai, fo koka heni Manetualain heti-heun, fo Ana feen neu baꞌi Musa. Ma boso maehetuk Au taa mbali Manetualain mana kokola nala fo ala kokolak mema kana neme makahulun mai. Tehuu Au mai ia, sangga tao basan ala dadi meuaok leo basa dedeꞌa kala fo ala kokola mema kana so. ");
INSERT INTO llg_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Huu ndia, de mamanene neulalau baa! Lalai no daebafok bei taa lakalulutuk heni sala, mete ma basan bei taa dadi tungga Manetualain heti-heu nala. Mae titik do koma esa boe oo, taa hambu nana koka henik. ");
INSERT INTO llg_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Neme Manetualain hataholin basan, mete ma hambu mana laꞌo-lena Lamatuak heti-heun, huu ana duduꞌa nae, ‘Heh! Heti-heuk ia, kada kadiꞌik, de sosoan taa fa boe!’ Basa de, neu nanoli leondiak neu hataholi feꞌek, de dei fo Manetualain nai nusa-sodak tao ndia dadik hataholi kadiꞌi anak. Tehuu, hataholi mana tao tungga basa Manetualain heti-heun, boe ma neu nanoli leondiak neu hataholi feꞌek, na, dei fo Manetualain tao ndia dadik neu hataholi kasosoak. ");
INSERT INTO llg_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Mamahele neu Au! Mete ma ei taa masoda ndoos malolen lena mese anggama ma hataholi partei Farisi la, na, ei taa bisa maso dadik neu Manetualain hataholin nala.” ");
INSERT INTO llg_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Ei bubuluk baꞌi Musa heti-heun, fo ana nafada mema kana neu ita bei-baꞌi nala so, nae, ‘Boso tao misa hataholi, huu see tao nisa hataholi, na, dei fo ana hambu huhukuk.’ ");
INSERT INTO llg_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Tehuu Au sangga afada leoiak: boso mamananasa aok, huu see namanasa ndia tolanoon, na, dei fo ana hambu huhukuk. Hataholi mana manggalau neu ndia tolanoon, nae, ‘O langgaute kea!’ dei fo hataholi ndia nasale neu lasi anggama la. Ma hataholi mana masapalak ndia tolanoon, nae, ‘Nggoak aa!’, dei fo ana hambu huhukuk nai haꞌi naraka. ");
INSERT INTO llg_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","De, mete ma o muni fefeek neu Manetualain, tehuu o masaneda, mae, tolanook esa bei namanasa o, ");
INSERT INTO llg_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","na, boso fee fefeek ndia dei. Muu mole mua o tolanoom ndia dei, basa ndia bei fo muu fee fefeek ndia neu Manetualain. ");
INSERT INTO llg_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Mete ma hambu hataholi sangga nadedeꞌa no o, na, malolenak muu tao mole-dame lai-lai mua ndia dei. Mete ma taa, na, dei fo hataholi ndia ana hela noo o neni mana maketu dedeꞌak miu. Basa boe ma mana maketu dedeꞌak fee o muu polisi, boe ma ala sese o muni bui dale muu. ");
INSERT INTO llg_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Au kokolak tetebes ia! Dei fo o leo makandoo nai bui dale, losa o bae ketu basa o huta mala.” ");
INSERT INTO llg_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Ei bubuluk baꞌi Musa heti-heun so, nae, ‘Boso hohongge.’ ");
INSERT INTO llg_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Tehuu Au sangga afada leoiak: hataholi botik matan fo ana suli inak esa, basa de dalen nahiik sunggu non, na, touk ndia hohongge no inak ndia nai ndia dalen. ");
INSERT INTO llg_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Mete ma o tao salak munik o mata konam, na, doꞌi henin leo. Huu malolenak o maso muni nusa-sodak muu, mua kada mata deꞌek esak, neme kada ala mbia o muni haꞌi naraka muu, mua o mata deꞌem dua sala. ");
INSERT INTO llg_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ma, mete ma o tao salak munik o lima konam, na, tete heni limak ndia leo. Huu malolenak o maso muni nusa-sodak muu mua kada o limam esak, neme kada ala mbia heni o muni haꞌi naraka muu, mua o limam dua sala. ");
INSERT INTO llg_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Ei bubuluk baꞌi Musa heti-heun so, nae, ‘Hataholi mana namaketu no sao-inan, na, ana musi fee susula namaketuk neu inak ndia.” ");
INSERT INTO llg_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Tehuu Au afada leoiak: mete ma hambu hataholi namaketu heni sao-inan, naa te sao-inan taa hohongge nitak, boe ma inak ndia sao seluk, na, sao-tou kaesan ndia, tao ndia hohongge. Ma mete ma hambu touk fo sao nala inak esa nana namaketu nitak, na, sila dua sala hohongge ndia so boe.” ");
INSERT INTO llg_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Ei bubuluk baꞌi Musa heti-heun fo nafada ita bei-baꞌi nala, nae, ‘Mete ma o helu munik soo no Manetualain naden, na, o nanambaꞌak mua heheluk ndia.’ ");
INSERT INTO llg_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Tehuu Au afada leoiak: mete ma helu, na, boso munik sosook. Boso soo munik nusa-sodak naden, huu nusa-sodak ndia, Manetualain mamana leleon. ");
INSERT INTO llg_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Boso soo munik daebafok naden, huu daebafok ndia Manetualain tabu ein. Ma boso soo munik Yerusalem naden, huu Yerusalem ndia, Mane Ina-huuk kotan. ");
INSERT INTO llg_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Boso soo munik ei langga mala. Huu ei taa maena koasa fo koasa langga buluk dok esa fo ana dadik nggeok do fulak. ");
INSERT INTO llg_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","De, ei sangga helu mae, hei, na, mafada mae, ‘hei’ leo. Tehuu mete ma taa, na, mafada mae ‘taa’ leo. Mete ma ei mafada lenak neme ndia mai, na, ndia naoka nai nitu so.” ");
INSERT INTO llg_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Ei bubuluk baꞌi Musa heti-heun so, nae, ‘Mete ma hambu hataholi tao nakalulutu o matam, na, bala tao makalulutu ndia matan. Ma mete ma hambu hataholi tao namoꞌu heni o nisim, na, bala tao mamoꞌu heni ndia nisin boe.’ ");
INSERT INTO llg_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Tehuu Au afada leoiak: boso bala manggalauk neu manggalauk. Mete ma hataholi famba o nasum seli, na, elan neme naa fo ana famba o nasum seli bali. ");
INSERT INTO llg_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Mete ma hambu hataholi nadedeꞌa no o, do, haꞌi nala o badum, na, fee o jeket neun bali. ");
INSERT INTO llg_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Mete ma hambu soldadu esa nakaseti o, fo lemba ndia buan doon kilo esa, na, lemba makandoon losa kilo dua. ");
INSERT INTO llg_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mete ma hambu hataholi noke o buam sudi hata, na, feen neu leo. Ma mete ma hambu hataholi tonda o buam sudi hata, na, kada feen leo.” ");
INSERT INTO llg_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Ei mamanene so, hataholi lae, ‘Sue o tolanoom, ma husembuluk neu hataholi mana husembuluk neu o.’ ");
INSERT INTO llg_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Tehuu Au afada leoiak: o musi sue hataholi mana husembuluk neu o. Ma moke Lamatuak fee babaꞌe-babatik neu hataholi mana tao doidoso o. ");
INSERT INTO llg_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Mete ma o tao leondiak, na, o matudu mae, o ia Amak manai nusa-sodak anan. Huu Ana tao ledo nasaꞌa fee hataholi malole, ma hataholi manggalauk boe. Ana nakonda uda fee hataholi mana tao tungga Ndia palendan noꞌu no hataholi mana laban Ndia palendan. ");
INSERT INTO llg_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","De, mete ma kada o sue hataholi mana sue o, na, o maehetuk Manetualain musi bala nenik babaꞌe-babatik neu o do? Taa! Huu hataholi manggalauk boe oo, sue sila nonoon mana sue sila. ");
INSERT INTO llg_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","De, mete ma kada o mafada mae, soda-molek neu o nonoom, na, ndia lenan hata? Huu hataholi taa kamahelek neu Manetualain boe oo, ala tao leondiak boe. ");
INSERT INTO llg_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","De, masanenedak baa! O Amam nai nusa-sodak sue basa hataholi la. De, o boe oo, musi tao leondiak!” ");
INSERT INTO llg_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yesus nanoli nakandoo, nae, “Masanenedak baa! Boso tungga anggama heti-heun, fo suek hataholi koa ei. Te mete ma ei tao leondiak, na, ei Amam nai nusa-sodak taa fee ei nggadi mala. ");
INSERT INTO llg_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Mete ma ei sangga tulu-fali hataholi mana toꞌa-taa kala, na, boso miu popode maa mala sudi nai bee. Tehuu mete ma ei tao leondiak, na, ei sama leo hataholi mana kokolak feꞌek ma tao feꞌek. Ala lahiik lalaꞌok leni uma huhule-haladoik leu, fo suek hataholi koa sala, lae, ‘Wei, hataholi la ia, ana seli lalan seli bae maa! Au kokolak tetebes ia! Ma, hambu kokoak leondiak, na, ala simbo basa sila nggadi nala so. ");
INSERT INTO llg_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","De, mete ma ei sangga tulu-fali hataholi mana toꞌa-taa kala, na, boso mafada sudi see baa! ");
INSERT INTO llg_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","No leondiak, na, hataholi la malai daebafok ia, taa bubuluk. Tehuu ei Amam manai nusa-sodak mana bubuluk hata fo ei taom no neneek ndia. Dei fo Ana bala ei nenik babaꞌe-babatik makadotok. ");
INSERT INTO llg_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Ledoeik ei hule-haladoi, na, boso tao aok leo hataholi mana kokola feꞌek, tehuu tao feꞌek. Ala lahiik lalaꞌok leni dala hataholi noꞌuk leu, ma lambadeik lai uma huhule-haladoik dale, suek hataholi noꞌu kala lita sala ma koa sala, lae, ‘Wei! Sila ia, hataholi malalaok bou!’ Tehuu mamanene baa! No hambu kokoak leondiak, na, ala simbo lala sila nggadi nala so. ");
INSERT INTO llg_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Tehuu ei taa bole leondiak. Mete ma ei hule-haladoi, na, maso mini kama dale miu, fo kena lelesu. Basa na hule-haladoi nee-nee neu ei Amam. Suek hataholi feꞌek taa lita, tehuu ei Amam nita. Dei fo Ana bala fee ei nenik babaꞌe-babatik makadotok. ");
INSERT INTO llg_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Mete ma ei hule-haladoi, na boso kokolak maꞌeok miu-mai. Huu, hataholi taa mana malelak Manetualain boe, bisa ala hule-haladoi leondiak. Ala duduꞌa lae, Manetualain nahiik namanene sila huhule-haladoi manalu ndia. ");
INSERT INTO llg_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Boso tao tungga leo sila baa! Huu mae ei bei taa moke hata-hata neu Amak nai nusa-sodak, tehuu Ana bubuluk memak hata fo ei paluum. ");
INSERT INTO llg_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","De, mete ma hule-haladoi, na, pake conto leoiak: ‘Amak manai nusa-sodak! Ama naden malalaok nalan seli. Ela basa hataholi la soꞌu lamadedema Ama naden fo ana seli ndia. ");
INSERT INTO llg_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ela Ama dadik Manek neu basa hataholi la! Ela basa hataholi la tao tungga Ama palendan nai daebafok ia, sama leo Ama atan nala tao tungga Ama palenda nai nusa-sodak. ");
INSERT INTO llg_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ama tulun fee ai nanaꞌak mana daik tungga faik. ");
INSERT INTO llg_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ai moke Ama koka heni ai sala-singgo nala, sama leo ai mafalende heni hataholi sala nala, fo taon neu ai. ");
INSERT INTO llg_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ama, manea fo ai taa tao manggalauk. Ma masalaꞌe mala ai, mima nitu la koasan mai. Te Ama ia, Manek mana koasa manai lain seli, ma ana seli. Ama toꞌu palenda nakandondoo henin. Ai huhule-haladoin, kada leondiak Ama. Amin. ");
INSERT INTO llg_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Tehuu mamanene baa! Mete ma ei mafalende heni hataholi salan neu ei, na, dei fo ei Amam manai nusa-sodak boe oo, Ana koka heni ei sala mala. ");
INSERT INTO llg_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Tehuu mete ma ei taa nau mafalende heni hataholi salan neu ei, na, neu ko ei Amam boe taa nafalende heni ei sala mala.” ");
INSERT INTO llg_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Mete ma ei hule-haladoi ma puasa, na, boso tao matak mamada ndoos, sama leo hataholi mana kokolak feꞌek, ma tao feꞌek. Huu ala tao leondiak fo suek hataholi koa sala, lae, ‘Wei! Sila ia, hataholi malalao kala bae!’ Tehuu mamanene baa! Hambu kokoak leondiak, na, ala simbo basa sila nggadi nala so. ");
INSERT INTO llg_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Tehuu mete ma puasa, na, malou ei mata mala malalao ndoos, ma sau neulalau langga buluk! ");
INSERT INTO llg_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","De, dei fo hataholi lita ei, na, tala bubuluk, lae, ei mana puasak. Tehuu ei Amam mana bubuluk. Dei fo Ana bala fee ei babaꞌe-babatik makadotok.” ");
INSERT INTO llg_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Boso tao ues mbilu mbuse fo makaduduluk hata makadotok nai daebafok ia. Huu neu ko fufuk ma besi-teik tao lakalulutu sala. Boe ma naꞌo mai ofe ma koꞌo neni sala. ");
INSERT INTO llg_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Tehuu malolenak ei tao ues mbilu mbuse fo makaduduluk hata makadotok nai nusa-sodak. Huu nai ndia, fufuk no besi-teik taa bisa tao lakalulutun. Ma naꞌo boe oo, taa bisa mai ofe fo koꞌo nenin. ");
INSERT INTO llg_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ei mbeda hata mala lai bee, na neu ko ei dale mala lakadita lai ndia boe.” ");
INSERT INTO llg_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Hataholi matan, sama leo banduk fo tao nanggaledo ndia dalen. Mete ma ndia matan manggaledok, na, ana tungga dala sodak malole, sama leo hataholi laꞌok nai manggaledok dale. ");
INSERT INTO llg_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Tehuu mete ma matan manggasasabuk, na, ana taa tungga dala neulauk, sama leo hataholi mana laꞌok nafadadaba nai makiuk dale. De, mete ma manggaledok manai ei dale mala, makiuk so, na, ei boe oo masoda nai makiuk dale.” ");
INSERT INTO llg_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Hataholi taa bisa tao ues no tebe-tebe fee malanggan dua, huu dei fo ana hii malanggan esa lena heni malangga feꞌek. Bisa boe ana tungga malangga esa, tehuu tana mbali malangga feꞌek. Huu ndia, de, o taa bisa mae, ‘Lamatuak ndia, au malanggang,’ mete ma o tao doik dadik neu o malanggam. ");
INSERT INTO llg_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Huu ndia de Au afada leoiak: boso masambute duduꞌa, au sangga asoda talobee, au uꞌa-inu hata, ma, pake hata? Ei maehetuk nasoda ndia na, kada soaneu naꞌa? No aok ndia, soa pake badu do? Taa leondiak. ");
INSERT INTO llg_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Mete sudik mbui kala mana laa lai lalai. Taa lasambute sele ma ketu-kolu fo mbeda nanaꞌak neu kama mbembedak dale. Tehuu ei Amam nai nusa-sodak, nakaboi mbea-mbea sala, nakandondoo henin. Ndia boe oo, neu ko bisa nakaboi ei lena heni sila bali. De, duduꞌa neulalau dei. Huu, Ana timba-tai ei, lena heni mbui kala sila. ");
INSERT INTO llg_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Mete ma hataholi nambadeik neu titilok matan, basa de ana nasambute no ndia ao-inan, na, ana bisa tao namadema ao-inan do? Taa bisa! ");
INSERT INTO llg_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Mete ma taa, na, hatina de ei masambute, fo, duduꞌa laꞌeneu baloꞌa papakek bali? Miu mete sudik bungga bakung nai mook. Tana inda abas, ma tenu sidi. ");
INSERT INTO llg_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Tehuu mamanene neulalau baa! Mane Soleman baloꞌa papake neulauk nalan seli, taa bisa laban bungga la lolen. ");
INSERT INTO llg_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Huu, Manetualain tao dalek neu bungga fo kada lasoda nai leledon ia, fo basa na, foꞌa boe ma lamatuu so, fo hataholi nggali heni sala leni haꞌi dale leu. Neu ko Ana papake ei lena heni bungga la sila. De, hatina de, ei taa nau mamahele tebe-tebe neu Ndia? ");
INSERT INTO llg_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","De, boso masambute duduꞌa, mae, ‘Ai sangga miꞌa hata?’ do ‘Ai sangga minu hata?’ do, ‘pake hata?’ ");
INSERT INTO llg_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Hataholi fo taa namahele neu Manetualain, ala tao ues mbilu mbuse fo lasuu hambu basa dedeꞌa kala sila. Tehuu ei boso leondiak, huu ei Amam nai nusa-sodak bubuluk basa hata fo ei paluuk so. ");
INSERT INTO llg_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Kada ei musi makalalaꞌok Ndia uen dei, ma musi tungga Ndia palendan, fo basa na, neu ko Ana fee tamba basa hata fo ei paluum. ");
INSERT INTO llg_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","De, boso masambute duduꞌa hata fo foꞌa ei paluum. Huu, foꞌa na, no nasambute feꞌek bali. Faik ia totoꞌan, dai ndia so.” ");
INSERT INTO llg_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Ei boso soli salak neu hataholi, fo suek Lamatuak boso soli salak neu ei. ");
INSERT INTO llg_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ei timba-tai hataholi leobeek, na, neu ko Manetualain timba-tai ei leondiak boe. Ei uku-sudi hataholi feꞌek salan leobeek, na, neu ko Manetualain uku-sudi ei leondiak boe. ");
INSERT INTO llg_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Huu, o kada tanda hataholi sala kadiꞌi anan, tehuu o sala ina-huum, kada o taok taa. Ndia sama leo o mita huꞌuk esa nai o nonoom matan. Naa te balo inahuuk babaa nala o matam, tehuu o taa mamedam. ");
INSERT INTO llg_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Talobee de o mambalani kokolak, mae, ‘Tolanook! Mai fo au tulun nggue heni huꞌuk ndia neme o mata deꞌem mai dei.’ Naa te o mesa nggo taa bisa mita hata-hata, huu balok natabaa nala o matam. ");
INSERT INTO llg_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Wei! Memak o ia mana dea-dalek tebe! Tulun dei! Soꞌu nggali heni balok ndia, neme o mata hehelim dei, bei fo o mita, fo tulun nggue heni huꞌu kadiꞌi anak ndia neme o nonoom matan ndia mai. ");
INSERT INTO llg_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Boso manoli dedeꞌa malalaok laꞌeneu Lamatuak neu mana haumeme kala. Huu sila ndia, sama leo busa manggalauk, de, dei fo ala pode lasafali mai sambu ei. Sila nggoan sama leo bafi. Mete ma hataholi fee sala lilo bokolii mabeli, na, ana taa mbali sana. Huu ndia nalelak kada heheta-hahaꞌi.” ");
INSERT INTO llg_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Mete ma ei hule-haladoi, moke makandondoo henin neu Lamatuak; na, neu ko Ana fee. Mete ma sangga makandondoo henin; na, neu ko Ana natudu dalak. Mete ma manggou makandondoo henin; na, neu ko Ana soi lelesu. ");
INSERT INTO llg_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Huu basa hataholi mana noke nakandondoo heni neu Lamatuak, neu ko ala simbo. Mana sangga nakandondoo henin, neu ko ana hambu. Mana manggou nakandondoo henin, neu ko Ana soi lelesu. ");
INSERT INTO llg_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ei duduꞌa sudi kana dei! Mete ma hambu kakanak noke loti, na, neu ko aman taa feen batu, hetu? ");
INSERT INTO llg_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Mete ma kakanak noke iꞌak, na, aman taa feen mengge! ");
INSERT INTO llg_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ei Amam manai nusa-sodak ndia, memak neulau hiak. De, mete ma hataholi manggalauk matak leo ei, na, mahiik fee bua neulauk neu ei ana mala, nakalenak bali ei Amam! Neu ko Ana fee hata fo ei mokek ndia. ");
INSERT INTO llg_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","De, o nau hata fo hataholi feꞌek tao neu o, na, o musi tao leondiak neu ndia boe. Huu ia netes, neme basa baꞌi Musa ma Manetualain mana kokola feꞌe nala lanoli mema kana neme makahulun mai so.” ");
INSERT INTO llg_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Mete ma hataholi nau maso neni nusa-sodak neu, na, ana musi laꞌok nesik lelesu makabiꞌak. Huu hambu dala lofoanak ma lelesu maloa, fo hataholi noꞌuk lahiik lesik ndia. Tehuu mata neuk baa! Huu dala leondiak noo hataholi neni naraka neu, de ala lakadodook leme Lamatuak mai. ");
INSERT INTO llg_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Hataholi nau maso neni nusa-sodak neu, musi nesik dala toꞌa-taak ndia, ma maso nesik lelesu makabiꞌak. Huu mae kada hataholi lumak lesik dalak ndia, tehuu dala makabiꞌak ndia, noo hataholi neni Lamatuak neu.” ");
INSERT INTO llg_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Mata neuk neu mana kedi-fudi kala, fo ala soꞌuk aok, lae, sila ndia Lamatuak mana kokola nala. Huu ala taok ao nala malole leo biꞌilombo. Naa te sila ndia manggalauk, sama leo busa fui, fo mai naꞌa biꞌi. ");
INSERT INTO llg_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Leobee fo ei bisa malelak hataholi mana tao aok malalaok ndia? Memete kana leo, neme sila tataon mai. Sama leo hataholi nita boan, na, nalelak huun. Boa malole, taa kalua neme ai huu taa malole mai. ");
INSERT INTO llg_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ai huu malole, naboa boa malole. Tehuu ai huu taa malole, naboa boa taa malole. ");
INSERT INTO llg_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Taa hambu ai huu malole, naboa boa taa malole. Ma taa hambu ai huu taa malole, naboa boa malole. ");
INSERT INTO llg_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ai huuk fo naboa boa taa malole, neu ko hataholi mai kekekon fo mbia henin neni haꞌi dale neu. ");
INSERT INTO llg_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Leondiak boe oo, no mana kokola la, fo ala tao aok malalaok sila. Ei bisa malela kasa neme sila tatao-nonoꞌi nala mai.” ");
INSERT INTO llg_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Dei fo hambu hataholi noke Au, nae, ‘Lamatuak!’ Tehuu kada ala seseik nai bafak. Neu ko Manetualain manai nusa-sodak timba heni sala. Huu, kada hataholi mana tungga no teteben Ndia hihii-nanaun, Ana simbo kana dadik neu Ndia hataholin. ");
INSERT INTO llg_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Dei fo neu daebafok babasan, hataholi noꞌu kala manaku, lae, Au ia sila Lamatuan. Ala kokoe Au, lae, Lamatuak ei! Ai miu tui-bengga Lamatuak nanonolin. Ai boe oo, husi nitu la minik Lamatuak naden. Ma ai tao tanda heran mata-mata kala minik Lamatuak koasan.’ ");
INSERT INTO llg_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Mae ala lambue kokoe Au leondiak boe oo, tehuu dei fo Au afada sala, ae, ‘Ei ia, see? Au taa alelak ei, huu ei taa masoda tungga Lamatuak hihii-nanaun. De, malai heok ia leo!’ ” ");
INSERT INTO llg_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Hataholi mana mai namanene Au, basa de tao tungga Au kokolang, na, ndia ndia sama leo hataholi malelak, fo nambadedei uman neu fanderen batu. ");
INSERT INTO llg_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Doo-doo boe ma uda belak konda losa faa mai. Ani sanggu mai de mboꞌi fee uma ndia. Tehuu uma ndia taa tuꞌu, huu nambadeik nai fanderen batu matea lain. ");
INSERT INTO llg_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Hataholi mana mai namanene Au, tehuu tana tao tungga Au kokolang, na, ndia ndia sama leo hataholi nggoak fo nambadedei uman neu salaek lain. ");
INSERT INTO llg_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Doo-doo boe ma uda belak konda losa faa mai. Ani sanggu boe oo mai mboꞌi fee uma ndia. Boe ma uma ndia tuꞌu henin, losa lulutuk.” ");
INSERT INTO llg_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesus kokolak nateꞌe leondiak, boe ma basa hataholi la heran lalan seli lamanene Ndia nanonolin, ");
INSERT INTO llg_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","huu Ana bubuluk tebe-tebe nanonolik ndia isin. Ndia dala nanonolin ndia, taa sama no sila mese anggama nala nanonoli nala. ");
INSERT INTO llg_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesus loe neme letek lain mai, boe ma hataholi noꞌu kala leu tungga Ndia. ");
INSERT INTO llg_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Kada nggengge neuk, hambu hataholi kamahedi kusta esa mai nasale Ndia. Ana sendek lunggulanggan, de noke tulun Yesus, nae, “Lamatuak aa! Tulun au dei! Mete ma Lamatuak nau, na, Lamatuak bisa tao mamopo au heding ia, suek hataholi la boso nunute au bali, fo au bisa huhule-haladoi nai uma huhulek dale.” ");
INSERT INTO llg_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Namanene leondiak, boe ma Yesus look liman neu, basa de Ana daba laꞌe hataholi kamahedi kusta ndia, boe ma Ana kokolak nae, “Memak Au nau! O hai leo!” Nggengge neuk, hataholi ndia hedin mopo tuti kana. ");
INSERT INTO llg_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Boe ma Yesus nafadan nae, “Masanenedak baa! O hai ia so, tehuu taa bole mafada sudi see. O musi tungga baꞌi Musa heti-heun dei. De, muni malangga anggama muu, suek ana palisak o aom, fo ana bubuluk o hedim ia mopo tetebes so, do, taa. Basa na, o musi fee tunu-hotuk tanda makasi, suek basa hataholi la bubuluk lae o hai tetebes so.” ");
INSERT INTO llg_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Basa ndia, boe ma Yesus maso neni nggolo Kapernaum neu. Nai ndia, hambu malangga soldadu Roma esa ana mai, fo sangga noke tulun, nae, ");
INSERT INTO llg_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Lamatuak aa! Au ana mana tao ues esa namahedi belak nai uma. Ana taa bisa foꞌa neme koin mai, huu ana doidoso nalan seli.” ");
INSERT INTO llg_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesus nataa, nae, “Malole! Dei fo Au uu, fo tao ahain.” ");
INSERT INTO llg_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Tehuu malangga soldadu ndia nae, “Lamatuak aa! Lamatuak boso makasosotak aom fo muu bali, huu au taa andaa simbok Lamatuak nai au umang. Sadi kada Lamatuak kokolak muma ia mai, na, neu ko au ana mana tao ues ndia, hai tutik. ");
INSERT INTO llg_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Au bubuluk dedeꞌak ia, huu au malangga nggala laena koasa fo palenda au. Ma au boe aena koasa fo palenda au ana palenda nggala. Mete ma au palenda au ana palendang, ae, ‘Muni ele muu’, na, neu ko ana neu. Mete ma au ae, ‘Muni ia mai!’ na, neu ko ana mai. Ma mete ma au adenu au hataholi mana tao ues, ae, ‘Tao ia!’ na, neu ko ana tao. De, sadi kada Lamatuak kokolak, na, neu ko au ana mana tao ues ndia, hai tutik.” ");
INSERT INTO llg_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Namanene leondiak, boe ma Yesus heran. Ana kokolak neu hataholi noꞌu kala mana tungga Ndia, nae, “Heran ei! Doo basa ia, Au bei taa atonggo itak hataholi Yahudi esa boe, namahehelen tean sama leo hataholi Roma ia! ");
INSERT INTO llg_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Mamanene baa! Huu dei fo hataholi deak noꞌuk sama leo hataholi Roma ia, fo leme ledo sasadun dulu mai, ma neme ledo tetesan neu, fo langgatuuk laꞌa feta noꞌu lo baꞌi Abraham, baꞌi Isak, ma baꞌi Yakob nai Manetualain uman nai nusa-sodak. ");
INSERT INTO llg_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Mae Lamatuak hele nala hataholi Yahudi la so, fo dadik Ndia hataholin, tehuu hambu noꞌu kala taa mbali Ndia. Dei fo Ana timba heni sala leni mamana makiu-mumuuk leu. Lai ndia lamatani ma ala doidoso lalan seli.” ");
INSERT INTO llg_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Kokolak basa leondiak, boe ma Yesus nafada malangga soldadu ndia, nae, “Ama fali leo. Huu touana mana tao ues ndia hai so, sama leo Ama namahehelen.” Nandaa no ledoeik ndia boe oo, tou anak ndia hai tutik. ");
INSERT INTO llg_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Basa de laꞌi esa, Yesus neni Petrus uman neu. Ana nita Petrus alinan sunggu nai koi lain, huu ana sumai. ");
INSERT INTO llg_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yesus toꞌu nala liman, boe ma ina lasik sumain mopo tuti kana, de ana foꞌa neu ono-lau Yesus asa. ");
INSERT INTO llg_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ledoeik ledo mulai tesa, boe ma hataholi la mai leni sila hataholi nitu nala kala. Boe ma Yesus palenda nitu la sila, nae, “Heh, nitu! Malai heok ia!” Boe ma nitu la sila kalua tutik. Ndia boe oo, tao nahai basa hataholi kamahedi kala. ");
INSERT INTO llg_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ana tao basa sila, suek tao tungga hata fo Manetualain mana kokolan Yesaya sulak mema kana so, nae, “Ana tao nahai ita hedi nala. Ma Ana lemba nala ita doidoso nala.” ");
INSERT INTO llg_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Basa ndia, boe ma Yesus nita hataholi makadotok mai eꞌo lalan. Boe ma Ana nadenu Ndia ana mana tungga nala nae, “Mai fo ata saꞌe ofak teni dano selik teu.” ");
INSERT INTO llg_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Boe ma mese anggama esa mai nafadan nae, “Ama Mesen! Ama muni sudi bee muu, na, au nau tungga akandondoo henin ua Ama!” ");
INSERT INTO llg_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Tehuu Yesus nataan nae, “Malole boe! Tehuu masaneda leoiak. Basa hataholi la, ma, banda la, kamamana leleo hehelik. Busa fui fali neni bolon neu. Mbuik fali neni ndunun neu. Tehuu Au, Hataholi Isi-isik ia, taa kauma hehelik, fo fali neni ndia neu. Lalaka langgak boe oo, taa.” ");
INSERT INTO llg_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Boe ma hataholi feꞌek esa bali, ana tungga-tungga non, mai noke nae, “Lamatuak! Au nau tungga Lamatuak, tehuu ela au fali fo uu akaneni au ina-ama nggala dei. Mete ma au amang maten so, na, bei fo au tungga.” ");
INSERT INTO llg_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Tehuu Yesus kokolak nae, “Leoiak! Neme naa, fo hataholi taa kamahele kala neu Manetualain, lakaneni sila hataholi mana maten nala. Huu, mete ma o nau tungga Au, na, o musi tungga tebe-tebe!” ");
INSERT INTO llg_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Basa ndia, boe ma Yesus no Ndia ana mana tungga nala saꞌe ofak leni dano selik leu. ");
INSERT INTO llg_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Taa dook boe ma, ani sanggu mai, lii mbuka mai, de oe neni ofak dale neu, tehuu Ana sunggu. ");
INSERT INTO llg_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Lita leondiak, boe ma ana mana tungga nala fafaen, lae, “Lamatuak aa! Lamatuak aa! Foꞌa fo masalaꞌe mala ita dei! Huu ita sangga bolo mate ia so, maa!” ");
INSERT INTO llg_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Boe ma Yesus nataa sala nae, “Wei, hatina de ei bii leoiak!? Ei taa mamahele neu Au do?” Boe ma Ana foꞌa, de Ana kaꞌi ani no lii, nae, “Hahae leo!” Boe ma lii no ani linok tutik. ");
INSERT INTO llg_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Boe ma Yesus ana mana tungga nala heran. Ala lae, “Awii! Ndia ia, see bae? Talobee, de Ana bisa palenda ani no lii, de ala tungga Ndia hihiin?” ");
INSERT INTO llg_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Taa dook bali, boe ma ala losa dano selik, nai hataholi Gadara la dae babaꞌen. Nai ndia hambu hataholi nitu nalak dua leo lai luak mamana hataholi kamates. Sila ndia, manggalaun ana seli, losa taa hambu hataholi esa boe nambalani laꞌok nesik ndia. Ala lita Yesus mai boe ma, ");
INSERT INTO llg_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","ala langgou, lae, “Wei, Manetualain Anan aa! Hatina de O mai babalik ai? Mae fain bei taa losa fo sangga huku ai, tehuu O sangga tao doidoso ai.” ");
INSERT INTO llg_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Taa dook neme ndia mai, bafi makadotok totofi dae sangga nanaꞌak. ");
INSERT INTO llg_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Boe ma nitu la loke Yesus lae, “Mete ma husi heni ai, na, madenu ai maso mini bafi la dalek miu!” ");
INSERT INTO llg_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Boe ma Yesus palenda sala, nae, “Miu leo!” De, nitu la kalua laꞌo ela hataholi kadua kala sila, de, ala maso leni bafi la sila dalek leu. Basa de, bafi la sila lalai lapoka kala loe tungga letek kakalan, de tuda leni dano dale leu. Boe ma basa sala bolo mate. ");
INSERT INTO llg_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Lita leondiak, boe ma mana manea bafi la lalai fali leni nggolok leu, de ala tui basa-basan. ");
INSERT INTO llg_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Lamanene tutui nala leondiak, boe ma hataholi noꞌu kala kalua leni mamanak ndia leu. Ala latonggo lo Yesus, de, ala kokoen, fo Ana laꞌo ela mamanak ndia. ");
INSERT INTO llg_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Basa ndia, boe ma Yesus asa hene fali leni ofak lain leu, fo leni dano selik leu, losa nai Ndia kota mamana leleon. ");
INSERT INTO llg_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Nai ndia, hataholi la ndolo leni sila nonoo luꞌun esa neu Ndia. Nita leondiak, boe ma Yesus bubuluk ala lamahele neu Ndia, de nae, Ndia bisa tao nahai sila nonoon ndia. Boe ma Ana nafada hataholi luꞌuk ndia, nae, “Ana nggo ei! Matetea o dalem dei! Huu Au koka heni o sala-singgo mala so.” ");
INSERT INTO llg_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Tehuu mese anggama hida lai ndia, lamanene Yesus kokolan ndia. De dale nala latobi tutik. Basa de lakokola aok, lae, “Hataholi ia nambalani nala seli kokolak leondiak, bae maa! Kada Manetualain mesa kana bisa fee ambon neu hataholi salan. Tehuu hataholi ia kokolan ndia, Ana tao aon sama leo ndia Manetualain. Ana nakadadaek Manetualain ndia so.” ");
INSERT INTO llg_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Tehuu Yesus bubuluk sila dale nala. Basa de, Ana kokolak nae, “Hatina de, ei duduꞌa mae, Au ia kokolak akadadaek Manetualain? ");
INSERT INTO llg_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Bee ndia lofoanak? Mete ma Au afada neu hataholi luꞌuk ia, ae, ‘O salam nana fee ambon so,’ do, Au ae, ‘Foꞌa leo, fo fali.’ ");
INSERT INTO llg_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Mete ma ana foꞌa tutik, dei fo ei mita buti, mae, Au ia Hataholi Isi-isik. Huu Au aena hak fee ambon neu hataholi salan.” Boe ma Yesus palenda hataholi luꞌuk ndia, nae, “Foꞌa leo! Luꞌa mala o mamana ndondolom, fo fali leo!” ");
INSERT INTO llg_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Boe ma, hataholi luꞌuk ndia foꞌa, de ana fali. ");
INSERT INTO llg_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Lita leondiak, boe ma basa hataholi la heran. Basa de ala soꞌuk lamadedema Manetualain naden, lae, “Manetualain ndia, ana seli bou! Ana fee koasa ina-huuk leoiak neu hataholi so.” ");
INSERT INTO llg_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Basa ndia, boe ma Yesus laꞌok neme ndia mai, de, nita hataholi mana susu-bea esa tao ues neme kantor bea. Ndia naden, Mateos. Boe ma Yesus noken nae, “Mai tungga Au!” Namanene leondiak, boe ma Mateos foꞌa de ana tungga tuti kana. ");
INSERT INTO llg_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Basa ndia, boe ma Mateos noke Yesus asa mai laꞌa nai ndia uman. Ana hoka ndia nonoo mana susu-bea la boe, ma nana hoka feꞌe kala, fo mai laꞌa noꞌu lo sala. ");
INSERT INTO llg_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Tehuu hataholi partei Farisi luma mai manggalau lo Yesus ana mana tungga nala, lae, “Hatina de ei mesem nanggatuuk naꞌa noꞌu no hataholi papake taa kala sila, fo leo mana susu-bea la, ma sila nonoo hataholi manggalauk kala sila?” ");
INSERT INTO llg_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Tehuu Yesus nafada sala, nae, “Hataholi kamahedik na, memak ana paluu dotel. Tehuu hataholi taa kamahedik na, taa paluu. ");
INSERT INTO llg_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Malolenak ei fali fo palisak neulalau Manetualain Dedeꞌa-kokolan, fo makahulun Ana nadenu Ndia mana kokola Hosea sulak, nae, ‘Au hihii-nanaung, fo ndia, Au hataholi nggala lasueao esa no esa, ma latudu namemeda kasian. Mete ma ala taa tao leondiak, na, sila banda tunu-hotu nala fo leni fee Au ndia, sosoan taa fa boe.’ Ndia, fo Manetualain nafadan so. Huu ndia, de Au taa mai akaneni hataholi fo taok aon malole, tehuu Au mai akaneni hataholi taa malole la.” ");
INSERT INTO llg_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Basa ndia, boe ma Yohanis Mana Salanik ana mana tungga nala leni Yesus leu. Ala latane lae, “Ai mana tungga Yohanis ndia, mateme puasa. Hataholi Farisi la puasa boe. Tehuu hatina de Ama ana mana tungga nala lambue laꞌa-linu lakandondoo henin? Sila taa puasa do?” ");
INSERT INTO llg_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Tehuu Yesus nataa sala, nenik nakandandaak, nae, “Leoiak: mete ma feta kabin, na, nana hoka kala taa puasa, tehuu laꞌa lakabete. Mete ma mana kabin touk bei nai ndia, na, neu ko laꞌa noꞌu. Tehuu dei fo laꞌi esa mete ma hataholi feꞌek, humu leni mana kabin touk, boe ma ndia nonoo nala, lameda dale hedi dei, bei fo ledoeik ndia ala puasa. ");
INSERT INTO llg_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Hataholi taa haꞌi nala tema beu bibiak esa, fo tandan neu badu laa sidak. Huu dei fo mete ma safe badu ndia, na, tema beuk nana tandak ndia ana kukulu. No leondiak, na, badu laak ndia boe sidan. ");
INSERT INTO llg_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Leondiak boe, hataholi taa diꞌa tua nasu beuk neni samba mboꞌok dale neu. Huu dei fo sambak ndia sidan, de tua nasu tetee henin. De, tua nasu beuk, na, diꞌan neni samba beuk neu, fo suek dua sala lakatataka lahele neulalau!” No leondiak Yesus nanoli sala nae, Ndia nanonolin ndia, beuk. De, boso seseo kana no nanonoli laak. ");
INSERT INTO llg_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ledoeik Yesus bei kola-kola no Yohanis ana mana tungga nala, boe ma malangga uma huhule-haladoik esa, mai natonggo non. Hataholi ndia sendek lunggulanggan neu Yesus matan, de hule nae, “Ama aa! Tulun dei! Huu au ana inanang bei fo maten. Ama tulun mai, fo lalaa limak neun dei, suek ana bisa nasoda fali.” ");
INSERT INTO llg_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Namanene leondiak, boe ma Yesus no Ndia ana mana tungga nala, tungga tutik hataholi ndia. ");
INSERT INTO llg_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Nai dala laladak, inak esa laꞌok tungga sala. Ana hambu bulak taa no hahaek teuk sanahulu dua ia so. Ana duduꞌa nai dalen, nae, “Sadi au bisa kada kame laꞌe badun, na, neu ko au hai ia so.” Huu ndia de ana neu kame Yesus badu mbedan. ");
INSERT INTO llg_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesus namedak, boe ma Ana heok matan nasale inak ndia. De, Ana kokolak, nae, “Ana nggo, ei! Matetea o dalem. Huu o namahehelem tebe-tebe neu Au, huu ndia, de o hai ia so.” Ledoeik ndia boe, inak ndia hai tutik. ");
INSERT INTO llg_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Basa ndia, boe ma Yesus asa laꞌok lakandoo leni malangga uma huhule-haladoik ndia uman leu. Losa ele boe ma Ana maso de nita mana makamina musik dale hedik, ma hataholi noꞌu kala lakaleleu. ");
INSERT INTO llg_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Tehuu Yesus nafada sala nae, “Hahae makaleleu, fo ama fali leo! Huu kakanak ia tana mate. Kada ana sunggu ndia.” Tehuu ala hika muꞌe Ndia. ");
INSERT INTO llg_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Basa ndia boe ma basa hataholi la sila kalua. Boe ma Yesus maso neni kakanak ndia kaman dale neu, de ana toꞌu nala liman. Boe ma kakanak ndia nasoda fali tutik. ");
INSERT INTO llg_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Lita leondiak, boe ma hataholi la mulai tui ndule sila nusan, laꞌeneu hata fo Yesus taok ndia so. ");
INSERT INTO llg_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Basa boe ma Yesus laꞌok nakandoo. Nai dala laladak, hataholi mbokek dua tungga-tungga lon. Ala langgou lae, “Yesus! Mane Dauk numbu-sadun aa! Kasian neu ai dei!” ");
INSERT INTO llg_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesus maso neni uma dale neu, boe ma hataholi mbokek kadua kala sila mai lasale Ndia. Boe ma Ana natane sala nae, “Ei mamahele tebe-tebe, mae Au aena koasa fo tao ei bisa mita?” Boe ma lataa, lae, “Awii! Ama boso matane bali, huu ai mamahele tebe-tebe so neu Ama.” ");
INSERT INTO llg_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Namanene leondiak, boe ma Yesus nafaloe sila matan nala, ma kokolak nae, “Mete ma leondiak, na, suek dadi tungga ei namahehele mala ndia!” ");
INSERT INTO llg_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Yesus kokolak nateꞌe leondiak, boe ma ala lita tutik. Tehuu Yesus nasaneneda kasa tingga-tingga, nae, “Masanenedak baa! Boso mafada hataholi esa boe laꞌeneu hata fo mana dadik ia so!” ");
INSERT INTO llg_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Tehuu taa bisa lakatataka lala. De, ala laꞌok ndule basa nusak ndia, de ala tui-bengga laꞌeneu Yesus tataon ndia. ");
INSERT INTO llg_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Hataholi mboke kadua kala sila kalua, boe ma hataholi loo hataholi feꞌek esa neni Yesus neu. Hataholi ndia taa bisa kokolak, huu nitu nalan. ");
INSERT INTO llg_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Nita leondiak, boe ma Yesus palenda nitu ndia kalua neme hataholi ndia mai. Nitu kalua, boe ma hataholi ndia nakokola tutik. Basa de hataholi noꞌuk malai ndia kala heran lalan seli. Ala lae, “Awii! Ita hataholi Yahudi la, bei taa tita titak leoiak ia maa!” ");
INSERT INTO llg_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Tehuu hataholi Farisi la taa lamahoko. Ala kokolak, lae, “Wei! Nitu la malanggan fee Ndia koasa, fo Ana husi kalua heni nitu.” ");
INSERT INTO llg_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Basa de Yesus laꞌok ndule basa kota ma nggolo kala, fo nanoli nai uma huhule-haladoi kala. Ana nanoli hataholi laꞌeneu Manetualain Hala Malolen, ma dala talobee fo ala bisa maso dadik Ndia hataholin. Ndia boe oo, tao nahai basa hedis mata-mata kala, ma basa hataholi ao taa matetu kala. ");
INSERT INTO llg_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Nita hataholi noꞌu kala sila, boe ma Yesus nameda kasian neu sala, huu ala taa bubuluk leni bee leu. Huu sila basa sala, sama leo biꞌilombo mana hoon taa. ");
INSERT INTO llg_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Boe ma Yesus kokolak no Ndia ana mana tungga nala, nae, “Hataholi noꞌu kala ia, sama leo osi buna-boan nala. Mae buna-boak noꞌuk, tehuu hataholi mana tao ues taa dai, fo ketu-kolu nala buna-boak sila, ma mbeda sala leu kama mbembedak dale neu. ");
INSERT INTO llg_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Huu ndia, de ei musi moke osi Lamatuan ndia, fo Ana haitua hataholi mana tao ues, fo suek leu lakaduduluk lala Ndia buna-boa nala.” ");
INSERT INTO llg_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Basa ndia, boe ma Yesus noke ana mana tungga nala mai lakabubua. Boe ma Ana fee sala koasa fo husi nitu ma tao lahai hataholi kamahedi kala mata-mata kala. ");
INSERT INTO llg_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ana mana tungga kasanahulu dua nala fo Ana nadenu sala sila, nade nala ndia: Kaesan, nade Simon (fo hataholi lateme loken lae, ‘Petrus’), boe ma fadin, nade Anderias, basa de, Yakobis, ma fadin, nade Yohanis (dua sala Sabadeus ana nala). ");
INSERT INTO llg_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Hambu Filipus boe, ma Bartolomeos. Boe ma Tomas, ma Mateos (mana susu-bea). Boe ma Yakobis (Alpius anan), ma Tadius. ");
INSERT INTO llg_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Boe ma Simon (mana tungga partei politik Selot), ma Yudas Iskariot (fo dei fo ana seꞌo heni Yesus). ");
INSERT INTO llg_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","6","Basa ndia, boe ma Yesus nadenu Ndia ana mana tungga nala sanahulu dua, ma fee sala palenda, nae, “Au adenu ei mini ita hataholi Yahudi nala miu, huu hataholi noꞌuk leme ita hataholi nala mai, taa tungga no teteben Lamatuak dalan. Sila ndia, sama leo biꞌilombo mana sala dalak. Huu ndia, de ei boso mini hataholi taa Yahudi miu, conto leo hataholi Samaria la. ");
INSERT INTO llg_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Miu mafada ita hataholi Israel asa, mae, ‘Fain losa so, fo basa hataholi bisa maso dadik Manetualain hataholin.’ ");
INSERT INTO llg_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Miu tao mahai hataholi kamahedik, tao masoda falik hataholi kamatek, tao mahai hataholi kamahedi kusta, ma, husi kalua heni nitu. Lamatuak fee makadotok neu ei so, tehuu taa noke falik hata esa boe, neme ei mai. De, hatematak ia, ei miu fo babaꞌe fee sala noꞌuk neu hataholi feꞌek, tehuu ei taa bole moke falik hata esa boe, neme sila mai. ");
INSERT INTO llg_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Laꞌok mia kada lima louk baa. Boso mini doik, ");
INSERT INTO llg_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","lepa-nggee, baloꞌa seluaok, tabu-eik, do teteꞌe-aik. Huu hataholi musi fee hataholi mana tao ues, hata fo nandaa, suek ala bisa lasoda. ");
INSERT INTO llg_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Mete ma ei maso mini kota esa do nggolok esa miu, na, ei sangga hataholi mana nau simbok ei. Basa na, leo nai ndia, losa ei laꞌo ela mamanak ndia. ");
INSERT INTO llg_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Mete ma ei maso mini hataholi uman miu, na, mafadan mae, ‘Soda-molek! Lamatuak fee ei babaꞌe-babatik.’ ");
INSERT INTO llg_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Mete ma hataholi lai uma ndia simbok ei no malole, na, ei moke fo Lamatuak fee babaꞌe-babatik neu sala. Tehuu mete ma ala taa simbok ei, na, Lamatuak boe oo, taa fee sala babaꞌe-babatik. ");
INSERT INTO llg_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Mete ma hataholi taa nau namanene ei, na, kalua mima uma ndia do kota ndia mai, fo basa na, sasambu heni afu neme ei eim mala mai, fo dadik tanda nae, ala taa lamanene, na, ala lemba aon natataak ndia. ");
INSERT INTO llg_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Dei fo, mete ma Manetualain naketu huku hataholi malai daebafok ia, na, neu ko Ana naketu huhukuk belak neu hataholi Sodom ma Gomora, fo makahulun manggalauk nalan seli ndia. Tehuu masanenedak baa! Huu dei fo Ana fee huhuku belak lena bali neu hataholi fo taa nau simbok ei!” ");
INSERT INTO llg_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Masanenedak baa! Huu Au adenu ei, sama leo Au haitua biꞌilombo neni busa fui manggalauk kala lalada nala neu. Huu ndia, de ei musi pake langgautek sama leo mengge malelak. Ma ei dale mala musi ndoos, sama leo lunda fo taa mana sangga dedeꞌak. ");
INSERT INTO llg_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Tehuu mata neuk baa! Huu dei fo hataholi tao doidoso ei sama leo busa kiki nakamate biꞌilombo. Dei fo ala hela leni ei maso mini mamana tao dedeꞌa anggama miu. Ma neu ko ala filo ei nai sila uma huhule-haladoin. ");
INSERT INTO llg_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Dei fo ala hela leni ei miu masale gubenol ma manek, huu ei tungga Au. Tehuu ei musi pake lelak ndia, fo mafada Au Hala Maloleng neu sala. No leondiak, hataholi taa mana malelak Lamatuak boe, bisa lamanene laꞌeneu Au. ");
INSERT INTO llg_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Huu mete ma ala hela loo ei leondiak, na, ei boso bii, mae, ‘Dei fo au sangga kokolak ae, hata?’ Do ‘dei fo au ataa, ae hata?’ Boso duduꞌa leondiak, huu losa ndia fain, dei fo ei Amam nai nusa-sodak, nafada laꞌeneu hata fo ei musi kokolak. ");
INSERT INTO llg_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Faik ndia, hata fo ei kokolak taa naoka nai ei mesa nggei, tehuu Ndia Dula Malalaon ndia nanoli ei kokolak hata. ");
INSERT INTO llg_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ei mete baa, huu nai uma esa dalek, mete ma hambu hataholi namahele neu Au, dei fo ndia tolanoo hehelin sangga dalak fo tao nisan. De, mete ma anak namahele, na, dei fo amak tao nisan. Mete ma amak no ina lamahele, na, dei fo sila ana hehelin ndia tao nisa sala. ");
INSERT INTO llg_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Mete te, dei fo basa hataholi la husembuluk neu ei, huu ei tungga Au. Tehuu, hataholi mana makatataka losa babasan, dei fo Manetualain fee sodak neun. ");
INSERT INTO llg_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Mete ma hataholi tao doidoso ei nai kota esa, na, foꞌa fo malai mini kota feꞌek esa miu. Tetebes ndia! Au ia, Hataholi Isi-isik. Dei fo ei bei taa laꞌok mateꞌe ndule basa kota la lai Israel, tehuu Au fali maing so. ");
INSERT INTO llg_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Hataholi la lateme fee hadak neu mesen esa, lena heni ana mana tungga nala. Ma ala fee hadak neu malanggan esa, lena heni ana mana tao uen nala. ");
INSERT INTO llg_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Mete ma ana mana tunggan nala lanoli fo malelan leo sila mesen, na, dai ndia so. Ma mete ma ana mana tao ues nanoli fo malelan leo malanggan, na, ndia boe nameda dai so. De, masanenedak bou! Mete ma hataholi noke maumak nae, ‘O ia Balsebul, na ndia nitu la malanggan!’ na, neu ko ndia uma isi nala hambu nadek taa malole nalan seli.” ");
INSERT INTO llg_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“De, ei boso bii hataholi mana laban ei. Huu hata fo hataholi tao nafufunik, dei fo basa hataholi la litan. ");
INSERT INTO llg_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Hata fo Au anoli ei mesa nggei ndia, na, dei fo ei musi miu mafada basa hataholi la. Ma hata fo Au afada no neneek, na, dei fo miu mafada mafeok basa mamanak lalaꞌen. ");
INSERT INTO llg_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Boso bii hataholi, huu kada ala bisa tao lisa hataholi aombaan, tehuu taa bisa tao lakalulutu hataholi samanen. Huu ndia, de ei musi bii Manetualain, huu kada Ndia mesa kana ka koasak fo mbia heni hataholi aon ma samanen neni tasi haꞌik fo mana mbila nakandondoo henin. ");
INSERT INTO llg_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","De matetea ei dale mala. Hataholi la seꞌo mbui hadek nai pasak, belin nai dae nalan seli. Tehuu taa hambu esa mate boe, mete ma ei Amam taa mboꞌi. ");
INSERT INTO llg_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ei Amam nai nusa-sodak boe oo, Ana tao matak neu ei, losa dedeꞌa kadiꞌi anak. Ei langga bulu doo makadoto nala lai ei langga mala boe oo, Ana bubulu kana so. ");
INSERT INTO llg_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","De, ei boso bii! Huu Manetualain timba-tai ei belin lena heni basa mbui hade kala sila.” ");
INSERT INTO llg_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Basa de Yesus kokolak bali, nae, leoiak, “Hataholi nambalani manaku nalelak Au nai hataholi noꞌu kala lai daebafok ia, na, dei fo Au boe oo, manaku alela kana nai Au Amang matan nai nusa-sodak ae, ‘Ndia ia, Au hataholing.’ ");
INSERT INTO llg_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Tehuu hataholi mana malelesi Au nai hataholi noꞌuk matan, nae, ana taa nalelak Au, na, dei fo Au afada Au Amang nai nusa-sodak ae, ‘Au taa alelak hataholi ia boe.’ ” ");
INSERT INTO llg_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Ei boso maehetuk, Au mai uni mole-dame nai daebafok ia. Tehuu Au mai fo tao hataholi la lalaba ao esa no esa. ");
INSERT INTO llg_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Au uni daebafok ia mai, tungga hata fo Lamatuak mana kokolan nafada memak so, nae, ‘Dei fo ana touanan laban aman, ana inanan laban inan, feto-feun laban aliinan, ");
INSERT INTO llg_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ma uma isi la lamusuk esa no esa.’ ");
INSERT INTO llg_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","De, hataholi fo tebe-tebe nau tungga Au, na, ana musi sue Au lena heni basa-basan; lena heni ndia ina-man, ma lena heni ndia anan nala. Tehuu, mete ma taa, na, hataholi ndia taa nandaa dadik Au hataholing. ");
INSERT INTO llg_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Huu hataholi mana nau tungga Au, tehuu taa nau lemba doidosok, na, ndia taa nandaa dadik Au hataholing. ");
INSERT INTO llg_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Hataholi fo ana sadia mate huu ana tungga Au, dei fo ana bisa nasoda nakandondoo henin no Lamatuak. Tehuu hataholi kada nasoda soaneu ndia soda hehelin, na, neu ko sodan ndia, mopo heni kana leondiak leo!” ");
INSERT INTO llg_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Hataholi mana simbok ei no malole, na, ana simbok Au leondiak boe. Ma hataholi mana simbok Au, na, ndia boe oo, simbok Manetualain fo mana madenu Au. ");
INSERT INTO llg_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Hataholi mana simbok Manetualain mana kokolan, huu mana kokolak ndia ana kokolak laꞌeneu Lamatuak, na, dei fo Lamatuak balan sama leo Lamatuak bala mana kokolan esa. Ma hataholi mana simbok hataholi dale ndoos esa, huu hataholi ndia tungga tebe-tebe Lamatuak hihi-nanaun, na, dei fo Lamatuak balan sama leo Lamatuak bala hataholi ndoos esa. ");
INSERT INTO llg_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Hataholi mana simbok hataholi esa kadiꞌik nalan seli, huu ana tungga Au, na, neu ko Lamatuak balan. Mae hataholi kada fee oe hiak nggalaas esa boe oo, na, neu ko Manetualain taa nafalende henin.” ");
INSERT INTO llg_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Faik fo Yesus nanoli nateꞌe ana mana tungga kasanahulu dua nala sila, boe ma Ana neu nafeok nggolo kala malai dae babaꞌek ndia, fo nanoli, ma tui-bengga Manetualain Hala Malolen. ");
INSERT INTO llg_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Faik ndia, Yohanis nai bui dale so. Ledoeik ana namanene basa dedeꞌa kala fo Yesus tao kala sila so, boe ma nadenu ndia ana mana tungga nala fo leu latane Yesus, lae, ");
INSERT INTO llg_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Manetualain helu memak neme makahulun mai so, nae, Ana sangga haitua Karistus mai, fo nasalaꞌe nala ita hataholi Yahudi la. De, Ama ia, ndia Karistus do? Do, ai musi mahani hataholi feꞌek bali?” Sila natatanen neu Yesus leondiak. ");
INSERT INTO llg_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Namanene leondiak, boe ma Yesus nataa, nae, “Ei mamanene aom so, ma mita aom so. De fali, fo mafada Kaꞌa Anis, mae, basan mana dadik so, tungga hata fo Manetualain mana kokolan Yesaya sulak mema kana so, nae: ");
INSERT INTO llg_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Hataholi mboke kala, bisa lita. Hataholi luꞌuk, foꞌa de laꞌok. Hataholi kamahedi kusta, dadik malalaok. Hataholi mbakek, bisa namanene. Hataholi mana matek, nasoda fali. Hataholi mana toꞌa-taak, namanene Hala Malole. ");
INSERT INTO llg_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","De, leoiak: miu mafada Kaꞌa Anis, huu dei fo ana naua-nanale, mete ma ana namahele nakandoo neu Au. Huu dei fo Manetualain fee babaꞌe-babatik neu hataholi fo namahehelen neu Au taa nanggeꞌo!” ");
INSERT INTO llg_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ledoeik Yohanis ana mana tungga nala fali, boe ma Yesus kokolak neu hataholi noꞌu kala, laꞌeneu Yohanis, nae, “Faik fo ei miu sangga Yohanis nai mamana nes ndia, na, ei duduꞌa mae sangga matonggo mia hataholi mata leo hatak? Taa dadi ei mini ele miu, fo matonggo mia hataholi mana noe-naꞌuk, fo sama leo oo fo manambeu neu-mai, tungga kada ani! ");
INSERT INTO llg_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ma taa dadi ei miu mita hataholi mana pake baloꞌa mabeli, huu hataholi mata leondiak, kada ana leo nai uma manek! ");
INSERT INTO llg_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","De, ei miu mita hataholi mata leobeek nai ele? Ei duduꞌa mae ei miu sangga Manetualain mana kokolan? Tetebes! Tehuu ndia ndia, mana kokola manai lain seli. ");
INSERT INTO llg_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Huu Manetualain Susula Malalaon nana sulak memak laꞌeneu Yohanis nae, ‘Mamanene! Au adenu Au hataholing, fo soi dalak fee O.’ ");
INSERT INTO llg_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Mamanene neulalau baa! Nai daebafok ia, taa hambu hataholi esa boe, fo lena heni Yohanis. Tehuu neme basa hataholi mana manaku nitak Manetualain leo Manek, na, hataholi manai dae nalan seli, lena heni Yohanis so. ");
INSERT INTO llg_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Mulai neme Yohanis tao ndia uen losa hatematak ia, hataholi makadotok ala maso dadik neu Manetualain enan. Tehuu hambu feꞌek luma bali, ala duduꞌa sala, lae, ala musi latati fo lakaseti hataholi maso dadik Manetualain hataholin. ");
INSERT INTO llg_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Losa Yohanis Mana Salanik mamain, ita hataholi Yahudi la tateme tasoda tungga baꞌi Musa ma Manetualain mana kokola nala heti-heu nala. ");
INSERT INTO llg_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","De, kada mamahele neu Au! Yohanis ndia, na, ndia Elia fo Manetualain mana kokola nala lafada memak so laꞌeneu ndia mamain. ");
INSERT INTO llg_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","De, mana mahiik bubuluk, na, mamanene neulalau baa! ");
INSERT INTO llg_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Au sangga fee nakandandaak fo suek ei bubuluk, hataholi hatematak ia, hataholi mata leobeek. Huu sila ndia, sama leo kakana kala mana manggatuuk lai pasak. Ala lambue langgou sila nonoo nala, lae, ");
INSERT INTO llg_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Wei! Ai fuu kinuk noꞌu, tehuu ei taa foti-longge mamahohoko. Basa na, ai soda sosoda dale hedik, tehuu ei taa mamatani.’ ");
INSERT INTO llg_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ei ia, sama leo kakana ana kala, fo taa lameda mana daik lalelak. Faik fo Yohanis mai, nateme puasa, ma taa ninu anggol. Boe ma hataholi la cap ndia, lae, ‘Ndia nitu nalak!’ ");
INSERT INTO llg_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Tehuu hatematak ia, Au, Hataholi Isi-isik ia, mai so. Au taa puasa, ma Au inu anggol. Boe ma hataholi la cap Au, lae, ‘Ndia ndia, memak hataholi balenaꞌo! Mana mafu funak bali! Ana neu nanonoo no mana susu-bea la! Ana partei esa no hataholi papake taa kala! Taa nameda aon bali!’ Tehuu ei tanda Au kokolang ia leo baa! Lamatuak malelan nana nitak nai Ndia hataholin soda nala.” ");
INSERT INTO llg_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Basa ndia, boe ma Lamatuak Yesus nasanenedak hataholi mana leo lai nggolok hida. Ana tao tanda heran noꞌuk lai ele so, tehuu tala nau laꞌo ela sila sala-singgo nala, fo tungga Lamatuak dala ndoon. ");
INSERT INTO llg_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Yesus nasanenedak kasa nae, “Ei hataholi Korasin ma hataholi Betsaida la! Mata neuk baa! Dei fo ei hambu soe! Au tao tanda heran mata-mata kala neu ei mata mala so, tehuu ei taa nau mamahele neu Manetualain. Naa te, ei ia hataholi Yahudi, fo manaku malelak Lamatuak. Tehuu leo tanda hera nala sila fo Au tao kala lai ei nggolo mala, dadi nakahuluk nai kota Tirus ma kota Sidon, na, neu ko doo basa ia de hataholi malai sila la hondak tutik, ma ala laꞌo ela sala-singgo nala, de ala tungga Lamatuak. Ma sila boe oo, neu ko pake baloꞌa fafaluk, ma tao afu neu langgak, fo dadik tanda, nae, ala fale dale nala neu sila sala-singgo nala. Naa te hataholi Tirus ma hataholi Sidon nala ia, taa hataholi Yahudi la, fo ala manaku lalelak Lamatuak. ");
INSERT INTO llg_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Tetebes! Dei fo kada ei mete leo! Mete ma Lamatuak naketu basa hataholi la dedeꞌa nala, na, hataholi Tirus ma hataholi Sidon nala huhukun bei daꞌun, lena heni ei huhuku mala. ");
INSERT INTO llg_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ei hataholi Kapernaum! Mata neuk baa! Ei boso duduꞌa mae, dei fo Lamatuak soꞌu nala ei maso mini nusa-sodak miu? Taa! Dei fo Lamatuak mbia heni ei maso mini naraka miu! Leo tanda heran nala fo Au tao kala neu ei nggolo mala dadi nakahuluk nai kota Sodom, na, neu ko Manetualain taa paluu tao nakalulutu kota manggalauk ndia. Huu mete ma hataholi Sodom lita tanda heran nala sila, na neu ko ala laꞌo ela sila manggalaun nala. ");
INSERT INTO llg_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Tetebes! Dei fo kada ei mete leo! Mete ma Lamatuak naketu basa hataholi la dedeꞌa nala, na, neu ko hataholi Sodom huhukun daꞌun, lena neme ei huhukum mai!” ");
INSERT INTO llg_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Kokolak basa leondiak, boe ma Yesus hule-haladoi, nae, “Amak! Amak fo mana dadik Lamatua Ina-huuk nai lalai ma daebafok. Au oke makasi noꞌuk, huu Ama tatana mala basa dedeꞌa huhukuk neme hataholi mana taok aon malelak, ma mana koao la. Tehuu Ama makambela basa dedeꞌa kala sila neu hataholi ana kala, ma hataholi dale kadiꞌi-taidae kala. ");
INSERT INTO llg_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Tetebes, Ama! Huu ndia ndia, tao nala Ama dalen namahoko!” ");
INSERT INTO llg_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Hule-haladoi nateꞌe leondiak, boe ma Yesus nafada hataholi malai ndia kala, nae, “Mamanene neulalau baa! Au Amang nai nusa-sodak, fee Au basa koasa la. Mana bubuluk neulalau neu Au, na, kada Amak. Ma mana malelak neulalau Amak, na, kada Ama Anan mesa kana, fo ndia Au ia. Ma Au hele hataholi feꞌe kala, fo afada sala, fo suek lalelak neulalau Ndia. ");
INSERT INTO llg_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Basa ei mana mangguk tao ues tingga-tingga, mai tungga Au! Basa ei mana lemba dedeꞌa mabela, mai mini Au mai! ");
INSERT INTO llg_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Mete ma ei simbo Au nanonoling, fo laꞌok noꞌu mia Au, na, ita ia, sama leo sapi luku dua, fo hela noꞌu luku esa. Huu Au ia, daleng malole, ma Au ia, daleng kadiꞌi-taidaek. Mete ma ei tungga Au, na, ei matea masa fali. ");
INSERT INTO llg_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Huu Au nanonoling ia, lofoanak. Ma Au palendang ia, taa mabela”. ");
INSERT INTO llg_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Laꞌi esa, laꞌeneu hataholi Yahudi la fai hahae tao ues, boe ma Yesus no ana mana tungga nala laꞌok lesik hataholi osin dale. Ndia ana mana tungga nala ndoe, huu ndia de ala ketu lala hade-gandum mbulen de laꞌa laꞌo-laꞌo. ");
INSERT INTO llg_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Nai ndia, hambu hataholi partei anggama Farisi luma, fo mana toꞌu lahele sila hada Yahudin. Lita Yesus ana mana tungga nala tao leondiak, boe ma ala sapa Ndia, lae, “O ana mana tungga mala ketu hade-gandum mbulen, neu fai hahae tao ues! Taa bole leondiak! Huu ndia laꞌolena ita heti-heun so.” ");
INSERT INTO llg_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","4","Tehuu Yesus nataa sala nae, “Leobee bae? Ei taa masaneda baꞌi Dauk tutuin ndia? Baꞌi Dauk no ndia ana mana tungga nala tei nala kio, huu ala ndoe lalan seli. Boe ma ala maso leni Manetualain Lalaa Huhule-haladoin dale leu, de haꞌi lala loti fo malangga anggama la feen neu Lamatuak so, de laꞌa. Naa te kada malangga anggama la bole laꞌa loti ndia. Hataholi feꞌek taa bole. Basa de baꞌi Dauk asa laꞌa, tehuu taa hambu hataholi soli salak neu sala. Nonook bali ei taa les malelak Manetualain Susula Malalaon boe! ");
INSERT INTO llg_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Huu nai ndia nana sulak laꞌeneu malangga anggama la mana ono-lau nai uma huhule-haladoik, laꞌeneu fai hahae tao ues. Tehuu sila taa hambu salak hata-hata. ");
INSERT INTO llg_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Mamanene baa! Makahulun, uma huhule-haladoik penting, tehuu hatematak ia hambu penting lena bali. Na, ndia Au, Hataholi Isi-isik ia. ");
INSERT INTO llg_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Nai Manetualain Susula Malalaon, Manetualain nae, ‘Au hihiing leoiak: Au hataholi nggala musi latudu namemeda kasian esa no esa. Mete ma taa tao leondiak, na, sila banda tunu-hotu nala fo leni sala leu Au ndia, sosoan taa fa boe.’ Naa, mete ma ei bubuluk neulalau Lamatuak kokolan ndia, na, neu ko ei taa soli salak neu Au ana mana tungga nggala. Huu tala tao salak hata esa boe maa! ");
INSERT INTO llg_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Huu Au ia, Hataholi Isi-isik. Au aena hak, fo aketu ae, hataholi bole tao hata neu fai hahae tao ues.” ");
INSERT INTO llg_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Basa ndia, boe ma Yesus laꞌo ela mamanak ndia, de neni sila uma huhule-haladoin neu. ");
INSERT INTO llg_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Nai ndia, hambu touk esa liman seli kamates. Hataholi Farisi la lasanggak dalak fo soli salak neu Yesus, mete ma Ana tao nahai hataholi lima kamate seselik ndia, laꞌeneu fai hahae tao ues. Basa de, latanen, lae, “Tungga ita heti-heu anggaman, na, hataholi tao nahai hataholi, laꞌeneu fai hahae tao ues, do taa?” ");
INSERT INTO llg_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Boe ma Yesus nataa nae, “Mete ma hataholi biꞌilombon esa tuda neni bolok dale neu, laꞌeneu fai hahae tao ues, na, neu ko mabiꞌik neu haꞌi nala biꞌi ndia neni lain mai hetu? ");
INSERT INTO llg_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Naa! Lamatuak sue hataholi, lena heni mabiꞌik sue ndia biꞌilombon. Huu ndia de, hataholi bole tao dedeꞌa malole laꞌeneu fai hahae tao ues.” ");
INSERT INTO llg_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Basa de Ana kokolak no hataholi lima kamate seselik ndia, nae, “Look o limam mai!” Boe ma ana look ndia lima kamate seselik ndia neu, de limak ndia hai tutik, sama leo ndia liman seli boe. ");
INSERT INTO llg_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Lita leondiak, boe ma hataholi Farisi la manggalau. Basa de ala foꞌa laꞌo ela uma huhule-haladoik ndia, de leu lala-halak lae, “Ita musi sangga dalak fo tao tisa Ndia!” ");
INSERT INTO llg_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Tehuu Yesus bubuluk sila duduꞌa manggalaun ndia, huu ndia, de, Ana laꞌo neni mamana feꞌek neu. Hataholi noꞌu kala tunggan, boe ma Ana tao nahai basa hataholi kamahedi kala. ");
INSERT INTO llg_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Tehuu Ana kaꞌi sala, nae, “Ei boso mafada hataholi feꞌe kala, mae, Au ia, see.” ");
INSERT INTO llg_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Huu, Au tao leondiak tungga hata fo Manetualain nafada Ndia mana kokolan Yesaya so, nae, ");
INSERT INTO llg_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","‘Mete sudik! Ndia ia, Au hataholi nadedenung fo Au hele alan so. Au sue Ndia, ma Au daleng namahoko nakandondoo henin ua Ndia. Dei fo Au fee Au Dulang neu Ndia, fo Ana neu nanoli basa hataholi nai nusa kala laꞌeneu Au dala soda ndoong. ");
INSERT INTO llg_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ndia taa babamba kalak. Ndia taa sosouk aok. ");
INSERT INTO llg_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ndia dalen malole. Ana taa nakatotoꞌak hataholi. Ai fo hiihii tepan, Ana taa tao natepa henin. Bandu anak fo hiihii maten, Ana taa fuu nisan. Nanoli hataholi nakandoo, losa babasan, basa hataholi nai nusa kala, tungga lalelak Lamatuak dala soda ndoon. ");
INSERT INTO llg_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Hataholi leme basa nusa kala dei fo lamahele neu Ndia, huu ala bubuluk Ndia ndia, see.” ");
INSERT INTO llg_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Basa de laꞌi esa, hataholi la leni hataholi nitu nalak esa losa mboken ma taa bisa kokolak, neni Yesus neu. Boe ma Yesus tao nahain, ma husi kalua heni nitu ndia. Basa de, hataholi ndia bisa nita, ma bisa nakokola tutik. ");
INSERT INTO llg_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Lita leondiak, boe ma basa hataholi la heran lalan seli. Ala lakokola lae, “Fama Ndia ia, Dauk numbu-sadun ia, fo Lamatuak mana kokolan nala sulak mema kana neme makahulun ele mai so! Ndia ndia, neu ko Hataholi fo ita tahanik ndia ia so!” ");
INSERT INTO llg_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Tehuu ledoeik hataholi Farisi la lamanene leondiak, boe ma taa simbo kana. Basa de lakokola lae, “Wei! Hataholi ia husi kalua heni nitu, na, huu nitu la malanggan Balsebul, fee koasa neu Ndia.” ");
INSERT INTO llg_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Tehuu Yesus bubuluk hataholi Farisi la kokolan ndia. De, nafada sala nae, “Ei kokolam ndia, taa minik langgautek! Mete ma nai nusak esa dalek, lauinggun nala lahote, na, talobee fo nusak ndia bei bisa nakatataka! Leondiak boe, hataholi la lai kota esa dalek, do lai uma esa dalek, lalaꞌu ao esa no esa, na, neu ko ala lasidak losa lakalulutuk, bou! ");
INSERT INTO llg_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","De, mete ma nitu la lambue lamusu kala, ma lambue lahusi kala esa no esa, na, sila malanggan taa bisa toꞌu palenda nala dook so bali! ");
INSERT INTO llg_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Masanenedak baa! Ei hataholi mala boe oo, husi nitu lalelak. Ala pake nitu koasan do? Taa! De, ei boso kokolak madabak, mae, Au pake nitu koasan fo husi nitu. Dei fo ei hataholi mala mesa kasa laketu, lae, hata fo ei soli salak ndia, sala. ");
INSERT INTO llg_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Tehuu mete ma tetebes Au husi nitu pake Lamatuak koasan, na, ndia natudu nae, Lamatuak ndia, memak Manek, fo mana memak nai ei mata mala so. ");
INSERT INTO llg_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Mete ma hataholi sangga mai namanaꞌo nai hataholi balakaik esa uman, na, ana musi hengge nisak hataholi ndia dei. Basa na, bei fo ana namoa nala hataholi ndia bua nala. ");
INSERT INTO llg_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Masaneda neulalau! Huu hataholi taa partei esa no Au, na, ndia ndia musu no Au. Ma see taa tulu-fali Au ueng, na, ndia ndia kada tao naodek. ");
INSERT INTO llg_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","De, mamanene neulalau Au kokolang ia! Manetualain sadia so, fo koka heni hataholi la salan nala. Mete ma hambu hataholi kokolak manggalauk neu hataholi feꞌek, na, Manetualain bei bisa koka heni ndia salan. Te mete ma hambu hataholi nambalani kokolak taa malole neu Manetualain Dula Dale Malalaon, na, Manetualain taa koka heni ndia salan ndia. ");
INSERT INTO llg_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Mete ma hataholi kokolak manggalauk neu Au, fo Hataholi Isi-isik ia, na, Manetualain sadia fee ambon neu ndia. Tehuu mete ma hataholi kokolak nakadadaek Lamatuak Dula Dale Malalaon, na, mae losa daebafok babasan boe oo, tehuu Manetualain taa koka heni ndia sala-singgon ndia!” ");
INSERT INTO llg_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Basa de Yesus kokolak nakandoo neu hataholi Farisi la sila, nae, “Duduꞌa neulalau! Ai huuk malole naboa boa malole. Tehuu ai huuk taa malole naboa boa taa malole. Huu neme boan mai, hataholi bisa bubuluk, lae, ai huuk ndia malole do taa. ");
INSERT INTO llg_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Tehuu ei ia sama leo mengge masapepekok! Ei taa bisa kokolak dedeꞌa malole. Huu hata fo nana mbedak nai hataholi dalen, na, ndia ana kalua nesik bafan. ");
INSERT INTO llg_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Hataholi malole, neu ko kokolak malole, huu dedeꞌa malole la sila nana mbedak nai ndia dalen. Tehuu hataholi manggalauk, neu ko kokolak manggalauk, huu dedeꞌa manggalauk kala sila nana mbedak nai ndia dalen. ");
INSERT INTO llg_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Mamahele Au! Huu dei fo neu faik daebafok babasan, na, Manetualain palisak basa hataholi la dedeꞌa nala. Faik ndia, hataholi esa-esak musi tanggon-natataak dedeꞌa-kokola sosoa taan ndia. ");
INSERT INTO llg_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","De, mata neuk baa! Huu dei fo Manetualain timba-tai ei dedeꞌa-kokolam mala, ma naketu, nae, ei nana hukuk do taa.” ");
INSERT INTO llg_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Lamanene Yesus kokolan leondiak, boe ma mese anggama luma ma hataholi Farisi la loke Ndia, lae, “Ama Mesen aa! Ai mahiik mita Ama tao tanda heran, fo dadik buti, nae, Ama koasam ndia tebe-tebe neme Manetualain mai.” ");
INSERT INTO llg_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Tehuu Yesus nasapala kasa, nae, “Amakee! Ei hataholi hatematak ia, taa nau mamanene neu Lamatuak! Ei malelak kada tao manggalauk! Mae ei moke tao tanda heran, tehuu Au taa tao. Huu makahulun Lamatuak tao tanda heran nenik Ndia mana kokolan Yunus so. Ndia dai so! ");
INSERT INTO llg_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yunus leo leledok telu ma leꞌodaek telu, nai iꞌa ina-huuk tein dale. Leondiak boe Au Hataholi Isi-isik ia. Dei fo Au leo leledok telu, leꞌodaek telu, nai lua batu mamana hataholi kamates. ");
INSERT INTO llg_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Dei fo neu faik fo daebafok babasan, mete ma Lamatuak dadik mana maketu, na, hataholi Niniwe la dadik neu sakasii fo kalaak ei lae, ‘Ei basa nggei ia, nggoak!’ Makahulun, hataholi Niniwe la lamanene neu Lamatuak mana kokolan Yunus, boe ma ala hondak ma laꞌo ela sila sala-singgon nala. Tehuu ei taa nau. Naa te, hatematak ia hambu Hataholi nai ei lalada mala fo ana seli lena heni Yunus, fo ndia Au ia. Tehuu ei taa nau mbali Au fa boe. ");
INSERT INTO llg_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Dei fo neu faik fo daebafok babasan, mete ma Lamatuak dadi mana maketu, na, ina mane Seba neme kona ele mai, de, nambadeik dadik sakasii. Ana tuduk lima kuꞌun fo kalaak ei basa nggei mana masodak hatematak ia, nae, ‘Ei basa nggei ia, nggoak!’ Makahulun, ina manek ndia neme dook ele mai, fo nita no mata deꞌe hehelin mane Soleman malelan. Naa te, hatematak ia hambu Hataholi nai ei lalada mala ana seli lena heni mane Soleman, fo ndia Au ia. Tehuu ei taa nau mbali Au fa boe.” ");
INSERT INTO llg_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Mete ma nitu nana husik neme hataholi esa mai, na, nitu ndia neni mamana nes neu, suek ana hahae aon. Tehuu taa hambu mamanak fo nandaa non. ");
INSERT INTO llg_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Boe ma ana duduꞌa nae, ‘Wei! Taa hambu mamana leoiak, na, malolenak au fali uu leo seluk nai hataholi makahuluk ndia.’ Basa de ana fali, boe ma ana nita mamanak ndia malalaok ma nana heti neulalauk. ");
INSERT INTO llg_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Basa de nitu ndia neu noke nala nonoon hitu, fo manggalaun lena heni ndia bali. Boe ma basa sala leu leo lai hataholi ndia, de lakamomotu lalan. De, hatematak ia, hataholi ndia sodan ana soe nalan seli so. Leondiak boe oo laꞌeneu hataholi hatematak kala ia.” ");
INSERT INTO llg_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Faik ndia, Yesus nakokola no hataholi noꞌu kala. Boe ma inan no fadi nala mai fo sangga latonggo lon. Kada ala lambadeik leu uma deak, de ladenu hataholi neu noke Ndia. ");
INSERT INTO llg_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","De hataholi neu nafada Ndia, nae, “Ama aa! Ama inam ma fadi mala lai deak. Ala sangga latonggo lo Ama.” ");
INSERT INTO llg_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Boe ma Yesus nataa nae, “Au ina tetebeng, ndia see? Ma Au tolanoo tetebeng ndia see?” ");
INSERT INTO llg_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Boe ma Ana tuduk neu hataholi la mana tungga Ndia, ma nafada nae, “Au inang ma Au tolanoong nggala sila ia. ");
INSERT INTO llg_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Te hataholi mana tao tungga Au Amang nai nusa-sodak hihii-nanaun, na, sila ndia Au bobonggi tetebe nggala.” ");
INSERT INTO llg_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Faik ndia boe, Yesus kalua neme uma ndia mai, de neu nanggatuuk neu dano Galelea bifin. ");
INSERT INTO llg_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Boe ma hataholi noꞌu kala mai lakalilimbu lalan. Boe ma Ana hene neu nanggatuuk nai ofa baluk esa lain, fo mana seek nai ndia, de nanoli. Hataholi la malai madak lain, basa sala lamanenen. ");
INSERT INTO llg_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Boe ma Ana nanoli sala makadotok, nenik nakandandaak. Ana tui nae, “Hambu hataholi mana tao ue daek esa, neu loloo bini nai osin. ");
INSERT INTO llg_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ledoeik ana loloo bini la ndia, hambu luma tuda lai dalak lain. Boe ma mbui kala mai de tutu laꞌa heni basa bini la sila. ");
INSERT INTO llg_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Hambu luma tuda leu dae batu. Bini ndia lanumbu lai-lai, tehuu dae niꞌianak. ");
INSERT INTO llg_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","De, ledo sadu mai, boe ma numbu kala sila male de lamatuu heni sala. Huu oka nala taa maso losa dae demak. ");
INSERT INTO llg_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Hambu bini luma tuda leu naꞌu laladan. De naꞌu la kabi lisa numbu kala sila. ");
INSERT INTO llg_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Tehuu hambu bini luma bali, na, tuda leu dae isik. Bini sila lanumbu, de ala ina-huu losa laboa. Hambu luma buna-boan beke laꞌi telu huluk, hambu beke nee huluk, ma hambu luma losa laꞌi natun esa. ");
INSERT INTO llg_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","See kandiꞌidok, na, mamanene neulalau baa!” ");
INSERT INTO llg_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Basa de Yesus ana mana tungga nala mai latanen, lae, “Hatina de Ama manoli hataholi noꞌu kala sila munik nakandandaak?” ");
INSERT INTO llg_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Boe ma Yesus nataa nae, “Huu ei nau bubuluk tebe-tebe Manetualain palendan, de Au afada memak unik nakandandaak ndia ndandaan. Tehuu mete ma hataholi feꞌek, na, Au anoli unik kada nakandandaak. ");
INSERT INTO llg_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Huu hataholi fo mana sangga bubuluk tebe-tebe Lamatuak hihii-nanaun, dei fo Lamatuak feen bubuluk tamba bali. Tehuu hataholi taa mana mbali Lamatuak hihii-nanaun, dei fo Lamatuak tao namanggonggoa kana. ");
INSERT INTO llg_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Au anoli sala unik kada nakandandaak, huu: ‘Ala lita so, tehuu taa nau lalelak. Ala lamanene so, tehuu taa nau bubuluk.’ ");
INSERT INTO llg_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Sila ndia sama leo hataholi fo Manetualain mana kokolan Yesaya sulak kana so, nae, ‘Dei fo ei mamanene, tehuu ei taa nau bubuluk. Dei fo ei mita, tehuu ei taa nau malelak hata fo ana dadi so. ");
INSERT INTO llg_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Huu hataholi la ia dale nala lakababatu, ala tao lambake ndiꞌido nala, ala tao lamboke mata nala. De, ela sala leme ndia leo, fo ndiꞌido nala mbake leondiak leo, ma ela sala leme ndia leo, fo mata nala mboke leondiak leo. Suek Au boso tao ahai sala, huu ala taa nau mbali Au.’ ");
INSERT INTO llg_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Tehuu ei ia, maua-manale bou! Huu ei mita mia ei mata heheli mala, ma ei mamanene mia ei ndiꞌido heheli mala so. ");
INSERT INTO llg_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Mamahele Au! Makahulun ele Lamatuak mana kokolan ma hataholi dale ndoo sala dokodoe nau lita hata fo ei mitan so, tehuu taa bisa. Sila boe dokodoe lamanene hata fo ei mamanenem so, tehuu taa bisa.” ");
INSERT INTO llg_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Kokolak basa leondiak, boe ma Yesus nafada sala nae, “De, hatematak ia ei mamanene nakandandaak ndia ndandaan. ");
INSERT INTO llg_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Bini mana tuda lai dalak lain ndia, na, ndia hataholi mana mamanene Dedeꞌa-kokolak laꞌeneu Manetualain palendan, tehuu taa nalelak tebe-tebe. Boe ma nitu la malanggan mai de namoa neni Dedeꞌa-kokolak ndia, neme hataholi dalen mai. ");
INSERT INTO llg_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Bini mana tuda nai dae batu ndia, na, ndia hataholi fo namanene Manetualain Dedeꞌa-kokolan, boe ma ana simbo nalan no namahokok. ");
INSERT INTO llg_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Tehuu Dedeꞌa-kokolak ndia taa naoka. Huu ndia de, taa nana mbedak nala dook nai hataholi ndia dalen. Leondiak hataholi feꞌek tao nakatotoꞌa kana, huu ana simbo nala Dedeꞌa-kokolak ndia, boe ma ana mboꞌi heni tuti kana. ");
INSERT INTO llg_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ma bini mana tuda nai naꞌu laladan, sama leo hataholi mana mamanene Dedeꞌa-kokolak ndia so. Tehuu ana nasambute nalan seli no dedeꞌak mata-mata kala, fo suek kada nasoda no malole. Boe ma basa dedeꞌa kala sila, seti heni Dedeꞌa-kokolak neme ndia dalen mai, losa sosoan taa so bali. ");
INSERT INTO llg_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Tehuu bini mana tuda nai dae isik, sama leo hataholi pasak ndia ndiꞌidoon, fo simbok Dedeꞌa-kokolak ndia, ma tungga Lamatuak hihii-nanaun. Basa na, kada ana tao dedeꞌa malole, sama leo bini mana maboak ndia. Hambu mana maboa laꞌi telu hulu, hambu laꞌi nee hulu, ma hambu losa laꞌi natun esa.” ");
INSERT INTO llg_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesus nafada nakandandaak esa bali, nae, “Manetualain totoꞌu palendan ndia, sama leo hataholi mana ngganggali bini neulauk nai ndia osin. ");
INSERT INTO llg_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Leꞌodae, boe ma basa hataholi la sunggu lamanee. Boe ma hataholi manggalauk mai, de ana ngganggali fii deꞌek neu osi ndia. ");
INSERT INTO llg_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Faik fo osi ndia mulai kalua buna-boan, boe ma ndia hataholi mana tao ue nala lita fii moli noꞌu no hade-gandum lai ndia. ");
INSERT INTO llg_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Basa boe ma, leu lafada maosik ndia lae, ‘Ama! Fain ai sele bini neulauk neu ama osin hetu? Hatina de hatematak ia hambu fii noꞌuk so?’ ");
INSERT INTO llg_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Maosik ndia nataa nae, ‘Ndia, hataholi manggalauk tataon ndia.’ Boe ma ndia hataholi mana tao ue nala lafadan lae, ‘Ama, ai miu tofa heni fii ndia do?’ ");
INSERT INTO llg_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Tehuu ana nataa nae, ‘Bosok! Huu ledoeik ei tofan, na, dei fo ita sesele neulau nala, nana feꞌa henik tungga. ");
INSERT INTO llg_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Neme naa, fo ala moli noꞌu losa fai kokolun. Dei fo neu faik ndia, bei fo au afada hataholi mana tao ues sala, ae, “Ei makaduduluk mala fii la dei. Basa na, hengge bubuak esa-esak, fo hotu heni sala. Basa bei fo makaduduluk mala buna-boa neulau kala, fo tao sala leni kama mbembedak dale leu.” ’” ");
INSERT INTO llg_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Basa ndia, boe ma Yesus kokolak bali, nae, “Au akadaik nakandandaak esa bali, fo ela ei bubuluk talobee de Manetualain dadik Manek neu hataholi noꞌu kala. Ndia hataholin nala, natahuhuun sama leo ai deꞌe kadiꞌi anak, fo hataholi selen nai osi dale. ");
INSERT INTO llg_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mae ai deꞌek kadiꞌi anak nalan seli, tehuu mete ma ana moli mai so, na, ana dadik ai huu ina-huuk nalan seli, nai osi ndia. Losa mbui kala mai landunu lai baꞌe nala.” ");
INSERT INTO llg_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesus nakadaik nakandadaak esa bali, nae, “Manetualain hataholin ndia, sama leo lalu teik fo inak esa haꞌi nalan, fo seseo kana no hade uu saku esa. Boe ma loti nakambela mai losa ina-huuk, huu lalu teik fa anak ndia.” ");
INSERT INTO llg_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesus nanoli hataholi noꞌuk pake tutuik mata-matak leondiak. Basa Ndia kokolan ndia, kada pake nakandandaak. ");
INSERT INTO llg_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ana nanoli leondiak tungga hata fo Manetualain mana kokolan sulak memak kana so, nae, “Dei fo Au anoli unik nakandandaak. Dei fo Au afada dedeꞌa kala, fo hataholi bei taa namanene nitak, mulai neme Lamatuak nakadadadik daebafok ia losa hatematak ia.” ");
INSERT INTO llg_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Basa boe ma Yesus laꞌo ela hataholi noꞌu kala sila, de Ana fali neni uma neu. Boe ma ana mana tungga nala mai, de loken fo Ana tulun, lae, “Ama aa! Tulun mafada ai, nakandandaak laꞌeneu fii ndandaan dei!” ");
INSERT INTO llg_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Boe ma Yesus nataa sala nae, “Hataholi mana ngganggali bini malole ndia, na, Au ndindia, fo Hataholi Isi-isik ia. ");
INSERT INTO llg_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ma osi ndia, na ndia, daebafok. Bini malole ndia, na ndia, hataholi mana maso dadik Manetualain bobonggin. Ma fii ndia, na ndia, malanggan nitu hataholi nala. ");
INSERT INTO llg_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Basa boe ma, hataholi manggalauk mana mai ngganggali fii ndia, na ndia, nitu la malangga ina-huun mesa kana. Ma fai kokoluk ndia, na ndia, daebafok babasan. Manetualain hataholi mana tao uen mana ketu-koluk sila, fo ndia Manetualain ata nusa-sodan nala. ");
INSERT INTO llg_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Faik fo daebafok babasan, ala lakabubua lala fii la, de ala hotu heni sala. ");
INSERT INTO llg_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Huu Au, Hataholi Isi-isik ia, dei fo Au haitua ata nusa-soda kala mai. Dei fo leu lakabubua lala basa hataholi la taa mana tungga Lamatuak palendan. Ma lakabubua lala basa hataholi mana fufudi-oꞌodo hataholi feꞌek, fo suek boso tungga Lamatuak palendan. ");
INSERT INTO llg_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Dei fo ala mbia heni basa hataholi manggalauk leni haꞌi naraka dalek leu, sama leo fii nana hotuk ndia. Nai ndia, bei fo ala lameda doidoso lalan seli, ma lamatani taa no hahaek. ");
INSERT INTO llg_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Tehuu hataholi mana masoda ndoos tungga Manetualain hihii-nanaun, neu ko ala leo lakandondoo henin lo sila Ama Manen nai nusa-sodak. Nai ndia, ala lasaꞌa manggaledok sama leo ledo. Hataholi mana nau nalelak Au, na, pasak ndiꞌidok neulalau baa!” ");
INSERT INTO llg_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yesus nakadaik nakandandaak esa bali, nae, “Hataholi mana nau nalelak Lamatuak totoꞌu palendan ndia, na, sama leo hataholi mana mahiik hambu bua mabeli nalan seli, fo hataholi feꞌek nafuni nitak nai dae bibia anak esa dale. Hataholi mana mahiik ndia mai kali, boe ma ana hambu buas ndia nai ndia, de, namahoko nalan seli. Basa de, natoi falik buas ndia. Boe ma ana fali lai-lai, fo neu seꞌo heni basa hata nala. De, neu hasa nala dae ndia, fo suek naena bua mabeli ndia.” ");
INSERT INTO llg_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Yesus nakadaik bali, nae, “Hataholi mana nau nalelak Lamatuak totoꞌu palendan ndia, sama leo hataholi mana danggan esa, nahiik hambu mutiara mabeli nalan seli. Boe ma ana nasanggak mutiara fo hasa. ");
INSERT INTO llg_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ledoeik ana natonggo no mutiara esa lolen ana seli, boe ma ana fali lai-lai, de neu seꞌo heni basa hata nala. Boe ma neu hasa nala mutiara ndia, fo suek bisa naenan leo.” ");
INSERT INTO llg_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Yesus nakadaik bali, nae, “Manetualain totoꞌu palendan ndia, sama leo mbuꞌak fo mana tao tasi la mboꞌin neni dano dale neu. Boe ma mbuꞌak ndia hambu iꞌak mata-mata kala. ");
INSERT INTO llg_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ledoeik mbuꞌak ndia henuk no iꞌa kala, boe ma mana tao tasi la mai hela lalan, de lenin neni dano bifin neu. Basa de langgatuuk fo laisi iꞌak leme mbuꞌak dale mai. Iꞌa neulauk, ala taon neni lembeneu dale neu. Tehuu iꞌa taa neulauk, na, ala mbia henin. ");
INSERT INTO llg_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Leondiak boe oo, neu faik fo daebafok babasan. Dei fo Manetualain ata nala leme nusa-sodak mai, fo leu tao kofeꞌe basa hataholi manggalauk leme hataholi dale ndoos mai. ");
INSERT INTO llg_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Dei fo ala mbia heni basa hataholi manggalauk leni haꞌi naraka dalek leu. Nai ndia, bei fo lameda doidoso lalan seli, ma lamatani taa no hahaek.” ");
INSERT INTO llg_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Kokolak nateꞌe leondiak, boe ma Yesus natane sala, nae, “Ei malelak basa Au kokolang isinaak ndia do?” Ala lataa, lae, “Ai malelak, Ama!” ");
INSERT INTO llg_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Basa de Yesus nataa nasa fali sala nae, “Malole! Huu mese anggama esa-esak nanoli tebe-tebe Lamatuak Dedeꞌa-kokolan fo nana sulak mema kana neme makahulun mai so, boe ma ana toꞌu natea Au nanonoling hatematak ia, na, ana sama leo maumak esa fo nahiik soi ndia kama mbembeda buan, fo natudu ndia hata laan nala sama-sama no ndia hata beu nala.” ");
INSERT INTO llg_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Faik fo Yesus nanoli nateꞌe hataholi noꞌu kala nenik nakandandaak, boe ma Ana laꞌo ela mamanak ndia, ");
INSERT INTO llg_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","de fali neni Ndia nggolon. Nai ndia, Ana maso neni uma huhule-haladoik neu, fo nanoli hataholi la. Basa hataholi la mana mamanene neu Ndia, heran lalan seli. Ala lakokola lae, “Amakee! Hataholi ia malelan seli maa! Ana nanoli neme bee ia? Talobee de losak Ana bisa tao tanda hera nala? ");
INSERT INTO llg_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Naa te, Ndia ia, kada tuka ai Anan. Ita talela kana tebe-tebe Ndia inan Maria; ma Ndia fadi nala, ndia Yakobis, Yusuf, Yudas ma Simon. ");
INSERT INTO llg_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ita boe talelak ndia feto nala, huu ita basa nggata leo nggolok esa naa! De, Ana hambu malelan ndia, neme bee mai bali? Ma Ana hambu koasan fo ana seli ndia, neme see mai bali?” ");
INSERT INTO llg_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Huu ndia, de, lesuhaꞌi nala lakaseꞌe, losa tala nau lamanenen so bali. Tehuu Yesus nafada, nae, “Memak tetebes! Nai mamana feꞌek, na, hataholi la lahiik fee hadak neu Manetualain mana kokolan. Tehuu nai ndia nggolon ma uma isi heheli nala, na, hataholi taa nau fee hadak neun.” ");
INSERT INTO llg_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Huu dale nala lakababatuk, de losak tala nau lamahele Yesus, huu ndia de, Ana taa tao tanda heran noꞌuk nai ndia. ");
INSERT INTO llg_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Faik ndia, mane Herodes toꞌu palenda nai propinsi Galelea. Ndia boe oo, namanene halak mata-mata kala laꞌeneu Yesus. ");
INSERT INTO llg_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ana nafada pegawe nala, nae, “Yesus ia, na neu ko Yohanis Mana Salanik, fo fain au adenu tete lala langgan. Hatematak ia nasoda seluk so bali, bae maa! Huu ndia de Ana naena koasa, fo tao tanda hera nala.” ");
INSERT INTO llg_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Mane Herodes kokolak leondiak, huu makahulun ana hambu dedeꞌak no Yohanis, losa ana humu nalan de nandee Yohanis neni bui dale neu. Dedeꞌak ndia tutuin leoiak: mane Herodes sao nala ndia fadin Filipus saon, nade Herodias. Naa te, Filipus no Herodias bei taa lamaketu. ");
INSERT INTO llg_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Huu ndia de Yohanis kaꞌi taa-taa, nae, “Ama manek taa bole sao mala fadim saon. Huu ndia laꞌolena ita hada Yahudin ndia so!” ");
INSERT INTO llg_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Tehuu Herodes taa nau mbali sana, de kada ana sao nala Herodias. Tungga teteben, na, Herodes nahiik tao nisa Yohanis Mana Salanik. Tehuu ana bii hataholi noꞌu kala, huu lamahele, lae, Yohanis ndia, na, Manetualain mana kokolan. Huu ndia de nadenu ndia hataholin, fo landee Yohanis neni bui dale neu. ");
INSERT INTO llg_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Tehuu doo-doo, boe ma Herodes tao feta fai bobonggin. Faik ndia, ina mane Herodias ana feꞌon neu longge nasale nana hoka kala. Ndia lolonggen neulaun seli, losa tao nala Herodes namahoko nalan seli. ");
INSERT INTO llg_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Longge nateꞌe, boe ma Herodes noke nala inanak ndia de, nae, “O nau moke au hata, na, kada mafada leo! Huu dei fo au fee o. Au toꞌu ahele au hehelung ia. Ma au soo unik Manetualain naden.” ");
INSERT INTO llg_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Namanene manek kokolan ndia, boe ma inanak ndia inan mbauedon. Huu ndia, de neu noke, nae, “Ama! Au oke Yohanis Mana Salanik langgan. Taon neu dulang esa dalek, munin neni ia mai, fo feen neu au.” ");
INSERT INTO llg_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Namanene inanak ndia noke leondiak, boe ma Herodes tenden hako tutik. Tehuu taa bisa hela falik ndia sosoon, huu basa nana hoka kala lamanenen so. Huu ndia de kada ana tungga inanak ndia nonoken leo. ");
INSERT INTO llg_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Boe ma ana palenda fo hataholi la leu tete lala Yohanis langgan, nai bui dale. ");
INSERT INTO llg_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ala tete lala Yohanis langgan, boe ma ala taon neu dulang dale, de leu feen neu inanak ndia. Ana simbo nala dulang ndia, boe ma ana koꞌo nenin neu inan. ");
INSERT INTO llg_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ledoeik Yohanis ana mana tungga nala lamanene ala tete lala langgan, boe ma ala leu haꞌi lala mbombolan, de leu latoin. Basa de leu lafada Yesus dedeꞌak ndia. ");
INSERT INTO llg_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Faik fo Yesus namanene laꞌeneu Yohanis, boe ma no Ndia ana mana tungga nala sangga heok leme mamanak ndia mai. Boe ma ala saꞌe ofak fo sangga leni mamana nes leu, fo bisa ala hahae ao nala. Tehuu hataholi noꞌu kala lita Yesus asa ofan ana tungga-tungga dano bifin. Boe ma ala kalua leme nggolo kala, de ala laꞌok lai-lai tungga dala madak lain. Huu ndia de ala losa lakahuluk Yesus asa nai mamanak fo lenik ndia leu. ");
INSERT INTO llg_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ledoeik Ana konda neme ofak lain mai, naa te nita hataholi makadoto kala lahanin so. De dalen nameda kasian neu sala. Boe ma Ana tao nahai hataholi kamahedi kala. ");
INSERT INTO llg_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ledo bobok, boe ma ana mana tungga nala mai lafadan lae, “Ama aa! Malolenak Ama madenu basa hataholi la ia, fo leu hasa nanaꞌak nai nggolo mana deka kala lai ia. Huu ledo bobok ia so! Tehuu taa hambu nanaꞌak fa boe nai ia.” ");
INSERT INTO llg_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Tehuu Yesus nataa, nae, “Bosok! Kada ei ndia fee sala laꞌa.” ");
INSERT INTO llg_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Tehuu lataa lae, “Awii, Ama aa! Ai taa hambu hata esa boe fo fee hataholi desi-desi ia, laꞌa. Ai taon leobee? Huu hambu kada loti lima, ma iꞌak boak dua, maa!” ");
INSERT INTO llg_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Tehuu Yesus kokolak, nae, “Hei! Malole ndia so. Mini sala ia mai leo!” ");
INSERT INTO llg_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Boe ma Ana nadenu hataholi la sila basa sala langgatuuk lakabubua leu naꞌu lain. Basa boe ma, Yesus haꞌi nala loti kalimak ma iꞌa kadua kala sila. Boe ma Ana nasale lalai neu, de, noke makasi neu Manetualain. Basa de, Ana bibiꞌi-babaꞌe loti sila, de Ana loon neu Ndia ana mana tungga nala, fo babaꞌe sala leu basa hataholi la sila. ");
INSERT INTO llg_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Basa boe ma ala laꞌa lakabete. Boe ma ala leu lakaduduluk lala nanaꞌa ela kala sila, de henu lembeneu sanahulu dua. ");
INSERT INTO llg_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Basa hataholi mana naꞌa kala sila meda touk lifun lima. Bei taa leke tamba inak ma kakana kala bali. ");
INSERT INTO llg_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Basa sala laꞌa lateꞌe boe ma, Yesus nadenu ana mana tungga nala leni ofak lain leu, fo lakahuluk leni dano selik leu. Tehuu Ana bei nahani nai ndia, fo nadenu hataholi noꞌu kala sila fali. ");
INSERT INTO llg_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ledoeik basa sala fali so, boe ma Yesus ndaꞌe neni letek esa lain neu, fo hule-haladoi. Losa leꞌodae, tehuu Ana bei mesa kana nai ndia. ");
INSERT INTO llg_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ledoeik ndia, Ndia ana mana tungga nala ofan losa dook nai dano laladan so. Tehuu ala sefe sota lalan seli, huu ofak nasale ani solu, de lii ina-huuk mbuka neu sala. ");
INSERT INTO llg_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Lole mbilak, boe ma Yesus neu tungga sala. Tehuu Ana laꞌok nesik oe bafon. ");
INSERT INTO llg_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Lita leondiak, boe ma ana mana tungga nala nggengge lalan seli. Ala kokolak lo bibiik, lae, “Heꞌe! Nitu ndia!” ");
INSERT INTO llg_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Tehuu Yesus kokolak nakandoo neu sala, nae, “Wei! Ei boso bii bou! Te Au ia Yesus! Ta hata-hata!” ");
INSERT INTO llg_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Lamanene leondiak, boe ma Petrus nataa nae, “Mete ma O ia memak Lamatuak, na, fee au laꞌok usik oe bafon, fo au uni Lamatuak uu.” ");
INSERT INTO llg_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Boe ma Yesus nataa nae, “Neu! Mai leo!” De Petrus kalua neme ofak dale mai, boe ma ana laꞌok nesik oe bafon neni Yesus neu. ");
INSERT INTO llg_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Tehuu ledoeik Petrus nameda ani belak, boe ma ana bii nalan seli de nanggou, nae, “Awii, Lamatuak aa! Masalaꞌe mala au dei!” ");
INSERT INTO llg_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Tutik Yesus solok liman lai-lai, de toꞌu nalan. Ana kokolak nae, “Awii, Peꞌu aa! Hatina de o dalem kabaꞌek? O taa mamahele tebe Au do?” ");
INSERT INTO llg_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Basa de dua sala maso leni ofak dale leu. Boe ma ani hahae tutik. ");
INSERT INTO llg_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Lita leondiak, boe ma ana mana tungga nala soꞌuk koa-kiok neu Ndia, lae, “Awii! Ama ia, memak tetebes Manetualain Anan, oo!” ");
INSERT INTO llg_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ledoeik ala losa dano selik boe ma, ala konda lai nggolo Genesaret dano bifin. ");
INSERT INTO llg_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ledoeik ala konda, naa te hataholi noꞌu kala lalelak asa tutik. Boe ma ala mulai langgou, lae, “Wei! Yesus mai so bou!” Ala lalai leu lafada lafeok, boe ma hataholi leni basa hataholi kamahedi kala mai. ");
INSERT INTO llg_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ala loke fo bisa kame laꞌe Ndia badun. Huu ala duduꞌa lae, “Sadi hataholi kamahedik kame kada laꞌe Yesus badu mbedan, na, neu ko ala hai tutik.” Boe ma basa hataholi kamahedi kala kame laꞌe Ndia badu mbedan ndia, de, ala hai tutik. ");
INSERT INTO llg_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Faik esa, hataholi Farisi bubuak esa lo mese anggama leme Yerusalem mai fo latonggo lo Yesus. ");
INSERT INTO llg_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Hataholi Farisi la toꞌu lahele sila hada Yahudin. Ledoeik lamanene, lae, Yesus ana mana tungga nala laꞌa, tehuu, taa safe lima nala tungga hadak hihiin, de ala luli. Boe ma ala mai soli salak neu Yesus, lae, “Hatina de o ana mana tungga mala laꞌa, na, taa safe lima nala dei? Ndia laban ita bei-baꞌi nala hadan!” ");
INSERT INTO llg_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Tehuu Yesus nataa nae, “Ei ia, memak hataholi mana kokolak feꞌek ma tao feꞌek! Ei malelam laban Manetualain palendan, fo kada tungga ei bei-baꞌi mala hadan. ");
INSERT INTO llg_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Huu Manetualain palenda so nae, ‘Fee hadak neu ei ina-mam mala.’ Ma tamba bali, nae, ‘Mete ma hataholi esa aꞌali aman do inan, na musi huku nisan.’ ");
INSERT INTO llg_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Manetualain nanoli leondiak, tehuu ei manoli feꞌek bali. Huu ei mae, ‘Mete ma hataholi esa helu so, fo fee ndia buan neu Lamatuak, na, ana taa paluu tulu-fali ndia ina-man, nenik ndia buan ndia, mae ala doidoso lalan seli.’ Tehuu no ei nanonolim leondiak ndia, na ei nggali heni Manetualain palendan, fo nggatin neu ei heti-heu heheli mala. ");
INSERT INTO llg_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Huu ndia de isinaak Au afada so, ae ei ia, hataholi fo mana kokolak feꞌek ma tao feꞌek! Ndia nandaa no hata fo Lamatuak mana kokolan Yesaya sulak mema kana so, laꞌeneu neme makahulun ele mai! Huu Lamatuak paken fo ana sulak nae, ");
INSERT INTO llg_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Hambu hataholi koa-kio Au, nenik kada bafan, tehuu taa no dalen. ");
INSERT INTO llg_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Mae ala tao leondiak boe oo, sosoan taa. Tala mbali Au, huu kada ala mbali hataholi heti-heun.’ ” ");
INSERT INTO llg_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Basa ndia, boe ma Yesus noke nala hataholi feꞌe kala lai ndia, de nanoli sala, nae, “Pasa ndiꞌidook neulalau, fo ei bisa bubuluk! ");
INSERT INTO llg_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Hata fo maso neni hataholi bafan dale neu, na ndia taa tao nanggenggeo hataholi. Tehuu hata fo kalua neme hataholi bafan mai, na ndia tao manggenggeok.” ");
INSERT INTO llg_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Basa ndia, boe ma Yesus ana mana tungga nala mai lafada Ndia, lae, “Ama bubuluk do? Hataholi Farisi la luli lamanene Ama kokolam ndia.” ");
INSERT INTO llg_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Tehuu Yesus nataa nae, “Au Amang nai nusa-sodak dei fo feꞌa heni hataholi taa mana manoli tungga Ndia hihii-nanaun. Ndia sama leo hataholi tofa heni seselek fo tana hii sala. ");
INSERT INTO llg_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","De, boso mbali hataholi Farisi la sila! Huu sila ndia, sama leo hataholi mbokek, mana matudu dalak neu hataholi mbokek. Dei fo ala tuda noꞌu leni bolok dale leu.” ");
INSERT INTO llg_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Basa de Petrus kokolak nae, “Ama, tulun mafada ai nakandandaak isinaak ndia ndandaan dei!” ");
INSERT INTO llg_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesus nataa nae, “Naa! Ei boe oo bei taa bubulu kana do? ");
INSERT INTO llg_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ndia hihiin leoiak: hata fo ita taꞌa, maso nesik bafak, boe ma nakandoo neni teik dale neu, de basa na, kalua bali neni mamana tei-moes neu. ");
INSERT INTO llg_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Tehuu hata fo kalua neme bafak mai, na, ndia ndia tao nanggenggeo hataholi, losa Manetualain nunuten, de taa nau simbo kana. ");
INSERT INTO llg_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Huu dedeꞌa manggalauk noꞌuk kalua leme hataholi dalen mai! Sama leo: duduꞌa manggalauk, tao nisa hataholi, hohongge, naeok no hataholi fo taa sao-toun do sao-inan, namanaꞌo, sakasii pepekok, ma kokolak naboboo hataholi naden. ");
INSERT INTO llg_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Dedeꞌa leondiak ndia, fo tao nanggenggeo hataholi. Tehuu mete ma hataholi kada naꞌa fo taa safe liman, tungga hadak hihii-nanaun, na, ndia taa dadi dedeꞌak.” ");
INSERT INTO llg_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Basa de, Yesus laꞌo ela mamanak ndia, fo neni dae babaꞌek mana dekak no kota Tirus ma kota Sidon. ");
INSERT INTO llg_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Nai ndia hambu inak esa neme dae babaꞌek ndia mai. Ndia taa hataholi Yahudi. Ledoeik namanene Yesus nai ndia so, boe ma neu noke tebe-tebe Yesus, nae, “Mane Dauk numbu-sadun aa! Kasian neu au dei, huu au ana feꞌong nitu nalan. Awii, kasian! Huu ana doidoso so.” ");
INSERT INTO llg_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Tehuu Yesus kada nee-nee, de taa nataa fa boe. Boe ma Ndia ana mana tungga nala mai lafadan, lae, “Ama aa, inak ia kada nambue nanggou tao nanggilok. Malolenak Ama madenun nalai heok neme ia mai.” ");
INSERT INTO llg_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Boe ma Yesus nataa nae, “Manetualain nadenu Au mai fo fali hataholi Yahudi, huu ala laꞌo lasalak, sama leo biꞌilombo ladabak. Ana taa fee Au uu fali hataholi feꞌek.” ");
INSERT INTO llg_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Tehuu inak ndia mai deka-deka bali no Yesus. Ana sendek lunggulanggan de noke tulun nae, “Lamatuak aa! Fali mala au dei.” ");
INSERT INTO llg_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Huu Yesus ngganggali kokolak, nae, “Taa nandaa haꞌi nala kakana kala nanaꞌan, fo nggalin neu busa la.” No hihiik nafunik, nae, Yesus musi fali Ndia hataholi Yahudin dei, bei fo bisa fali hataholi feꞌek. ");
INSERT INTO llg_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Tehuu inak ndia bala nae, “Tetebes Ama! Tehuu busa la mana mahanik lai mei sosolon. Sila boe oo, laꞌa hata fo mana tudak neme kakana kala pingga nala mai.” No hihiik nae, ledoeik kakana kala laꞌa, na, busa boe bisa naꞌa. Mae Yesus fali Ndia hataholin, tehuu Ndia boe oo, musi mete hataholi feꞌek. ");
INSERT INTO llg_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Namanene leondiak, boe ma Yesus nafada nae, “Awii! Ina mamahele tebe-tebe neu Au maa! De, ina fali leo, huu hata fo ina nokek ndia, dadi tutik so!” Boe ma ana fali, de nita anan hai memak so. ");
INSERT INTO llg_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Basa ndia, boe ma Yesus no Ndia ana mana tungga nala laꞌo ela mamanak ndia, boe ma ala laꞌok tungga-tungga dano Galelea bifin. De, ala ndaꞌe leni letek esa leu, boe ma Yesus nanggatuuk fo nanoli sala. ");
INSERT INTO llg_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Boe ma hataholi makadoto kala leni Ndia leu. Ala loo hataholi ei helak, hataholi mbokek, hataholi luꞌuk, hataholi taa bisa kokolak, ma hataholi kamahedi feꞌek boe. Ala tao hataholi kamahedi kala deka-deka lo Yesus ein. Basa de Ana tao nahai sala. ");
INSERT INTO llg_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Lita leondiak, boe ma hataholi noꞌu kala heran. Ala lakokola, lae, “Wei! Ana seli, maa! Hataholi ei helak, bisa laꞌok no malole. Ma hataholi mbokek, bisa nita. Hataholi luꞌuk bisa laꞌok. Ma hataholi taa bisa kokolak, bisa kokolak so! Tetebes Manetualain tataon ia. Ndia ndia, Lamatuak fo ita bei-baꞌi nala lakaluku-lakatele neun neme makahulun ele mai.” ");
INSERT INTO llg_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Basa faik hida, boe ma Yesus noke nala Ndia ana mana tungga nala de nae, “Au ameda kasian neu hataholi makadoto kala ia. Hambu leme dook mai so, ma lakabubua faik telu ia so, losak nanaꞌa nala taa so. Malolenak ala boso fali lo sila tei loun. Huu boso losak ala bengge lai dala laladak.” ");
INSERT INTO llg_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Tehuu Yesus ana mana tungga nala lataa lae, “Ama aa! Mamana nes ia, dook neme nggolok mai. Ita taa bisa fee hataholi makadoto kala ia laꞌa.” ");
INSERT INTO llg_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Tehuu Yesus natane sala nae, “Ei lotim hida?” Ala lataa lae, “Kada hitu, ma iꞌak faak!” ");
INSERT INTO llg_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Boe ma Yesus nadenu basa hataholi la sila langgatuuk leu dae. ");
INSERT INTO llg_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Boe ma Ana haꞌi nala loti kahitu kala, ma, iꞌak, de noke makasi neu Manetualain. Basa de Ana bibiꞌi sala, de Ana fee sala leu Ndia ana mana tungga nala, suek ala babaꞌe fee basa hataholi la. ");
INSERT INTO llg_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Boe ma basa sala laꞌa losa lakabete. Basa de, lakabubua lala nanaꞌa ela kala, henu lembeneu hitu. ");
INSERT INTO llg_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Basa hataholi manaꞌa kala sila, meda touk lifun haa. Bei taa hingga tamba inak ma kakana kala. ");
INSERT INTO llg_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Basa ndia, boe ma Yesus nadenu hataholi noꞌu kala sila fali. Boe ma Ana saꞌe ofak fo neni dae babaꞌek Magadan neu. ");
INSERT INTO llg_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Laꞌi esa, hataholi Farisi ma hataholi Saduki hida leni Yesus leu. Ala sangga latane-lataak lo Ndia, fo sangga tao latuda Ndia. Huu ndia, de ala loke Ndia, lae, “Ama aa! Tulun matudu tanda heran dei, fo dadik buti, nae, Ama hambu koasa neme Manetualain mai.” ");
INSERT INTO llg_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Tehuu Yesus nataa nae, “Mete ma ledo tesa ma lalai mbila, na, ei tandam mae, ‘Foꞌa tana uda.’ ");
INSERT INTO llg_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ma mete ma ledo sadu ma lalai koꞌa nggeok, na, ei mae, ‘Leledon ia sangga uda.’ Mete ma ei bisa tanda fai leondiak, na, hatina de ei taa bisa malelak tanda-tanda daebafok babasan? ");
INSERT INTO llg_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Wei! Ei hataholi hatematak ia, kada malelak tao manggalauk! Ei taa mbali Lamatuak! Mae ei moke tanda heran, tehuu Au taa tao. Huu makahulun Lamatuak tao tanda heran pake Ndia mana kokolan Yunus. De, dai ndia so!” Kokolak basa leondiak, boe ma Yesus laꞌo ela sala. ");
INSERT INTO llg_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ledoeik Yesus asa losa dano laladan, bei fo Ndia ana mana tungga nala lasaneda, lae, lafalende heni loti soaneu lepa-nggee. ");
INSERT INTO llg_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Namanene ala kokolak leondiak, boe ma Ana nafada sala nae, “Ei musi mata neuk neu hataholi Farisi ma hataholi Saduki la lalu tein baa.” ");
INSERT INTO llg_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Lamanene leondiak, boe ma Ndia ana mana tungga nala lasapangga. Ala lakokola aok, lae, “Tou lasik kokolak hata ndia? Fama Ana kokolak leondiak, huu ita taa teni loti do?” ");
INSERT INTO llg_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Tehuu Yesus bubuluk sila duduꞌa nala. Basa de Ana kokolak bali, nae, “Wei! Ei ia ana seli maa! Hatina de ei kokolak laꞌeneu loti! Ei taa mamahele Au do? ");
INSERT INTO llg_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ei bei taa bubuluk Au koasang do? Huu faik ndia Au bibiꞌi loti kalima kala sila fo fee hataholi lifu kalima kala laꞌa ndia, de ei makaduduluk mala loti nana naꞌa ela kala lembeneu hida? ");
INSERT INTO llg_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Basa de leobeek bali no loti kahitu kala fo Au baꞌe fee hataholi lifu kahaa kala sila? Hambu loti lenak sila ei makaduduluk mala sala lembeneu hida? ");
INSERT INTO llg_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Hatina de ei taa bubuluk Au kokolang isinaak ndia? Au taa kokolak laꞌeneu loti. Tehuu Au nau asanenedak ei, fo suek ei mata neuk mia hataholi Farisi ma hataholi Saduki la nanonoli nala. Huu sila nanonolin bisa leꞌa-nole nala hataholi noꞌuk, sama leo lalu teik tao nala loti dadik ina-huu.” ");
INSERT INTO llg_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Yesus kokolak leondiak, bei fo ala bubuluk, lae, Ana taa kokolak laꞌeneu loti. Tehuu Ana kokolak laꞌeneu hataholi Farisi ma hataholi Saduki la nanonoli kasala nala. ");
INSERT INTO llg_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Basa ndia, boe ma Yesus asa leni dae babaꞌek fo mana dekak no kota Kaiseria Filipi. Nai dala laladak, Ana natane sala nae, “Tungga hataholi la kokolan na, lae, Au fo Hataholi Isi-isik ia, see?” ");
INSERT INTO llg_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ala lataa lae, “Hambu luma lae, Ama ia, na, Yohanis Mana Salanik nasoda fali so. Feꞌek lae, fama Ama ia, baꞌi Elia. Feꞌek bali na, lae, baꞌi Yeremia. Mete ma taa, na, Manetualain mana kokola feꞌen makahulun ele.” ");
INSERT INTO llg_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Boe ma Yesus natane sala bali nae, “Mete ma tungga ei mesa nggei duduꞌa mala, na, Au ia, see?” ");
INSERT INTO llg_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Boe ma Simon Petrus nataa nae, “Ama ia, Karistus, fo ndia Hataholi fo makahulun ele Manetualain helu memak so, fo haituan mai! Ma Ama ia, Manetualain fo nasoda nakandondoo henin, Anan ndia!” ");
INSERT INTO llg_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Boe ma Yesus nae, “Simon, fo Yunus anan aa! O ia, maua-manalek bou! Huu hataholi taa nafada o dedeꞌak ia. Tehuu Au Amang nai nusa-sodak nafada o. ");
INSERT INTO llg_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Mamanene baa! Hatematak ia Au foi o nade ‘Petrus’. Huu nadek ndia ndandaan, fo ndia batu. Huu o namahehelem matea leo batu so, de dei fo o dadik fanderen neu Au hataholi kamahele nggala. Mae ala hambu doidosok losa mate boe oo, lahele lakandondoo henin. ");
INSERT INTO llg_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Dei fo Au fee o hak, fo makaneni Au hataholi nggala, sama leo o toꞌu nusa-sodak nggoen. Huu hata fo o kaꞌim nai daebafok ia, na ndia Lamatuak kaꞌin nai nusa-sodak boe. Ma hata fo o mboꞌim nai daebafok ia, na Lamatuak mboꞌin nai nusa-sodak boe.” ");
INSERT INTO llg_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Kokolak basa leondiak, boe ma Yesus kaꞌi sala, fo taa bole lafada sudi see, lae, Ndia ndia, Karistus. ");
INSERT INTO llg_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Mulai neme faik ndia mai, Yesus nafada Ndia ana mana tungga nala, nae, “Au musi uni kota Yerusalem uu. Tehuu dei fo nai ndia, Au hambu doidosok noꞌuk neme basa lasi hadak, malangga anggama Yahudi la malangga nala, ma mese anggama la. Dei fo ala tao lisa Au, tehuu neu binesan, Au asoda fali.” ");
INSERT INTO llg_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Yesus nafada leondiak, boe ma Petrus hela nalan neu dalak bifin, de kaꞌin, nae, “Ama boso kokolak leondiak! Taa bisa Manetualain elan leondiak!” ");
INSERT INTO llg_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Tehuu Petrus kokolan ndia, taa tungga Lamatuak hihii-nanaun. Huu ndia de Yesus kaꞌi nasa falin, nae, “Heh! Boke heok ia! Ndia ndia, nitu malanggan kokolan ndia! O boso matabaa mala Au! Kada o duduꞌa tungga hataholi hihiin, huu taa tungga Lamatuak hihii-nanaun!” ");
INSERT INTO llg_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Boe ma Yesus nanoli Ndia ana mana tungga nala, nae, “Hataholi mana nau tungga Au, ana musi nahele tungga nakandoo tungga-tungga faik! Ana musi nafalende heni ndia hihii hehelin, fo tungga kada Lamatuak hihii-nanaun. Mae hataholi sangga tao lisan boe oo, kada ana musi tungga nakandoo, sama leo hataholi lemba ndia ai ngganggen fo neu mate. ");
INSERT INTO llg_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Hataholi sadia mate huu ana tungga Au, dei fo ana hambu sodak nakandondoo henin no Lamatuak. Tehuu hataholi kada nau nasoda soaneu ndia ao-ina hehelin, neu ko ndia taa nasodan nakandondoo henin no Lamatuak! ");
INSERT INTO llg_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Mamanene baa! Mete ma o hambu basa daebafok isin, tehuu Manetualain timba heni o, na, nanalan hata? Mae o lemba muni basa daebafok isin boe oo, o taa bisa nggatin neu o samanem! ");
INSERT INTO llg_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Au afada ei basa nggei dedeꞌa kala ia, huu Au ia, Hataholi Isi-isik. Dei fo Au konda fali maing, pake Au Amang koasan, fo ana seli ndia, sama-sama ua Ndia ata nusa-sodan nala. Faik ndia, dei fo Au bala hataholi lalaꞌen tungga hata fo ana taon so. ");
INSERT INTO llg_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Masaneda neulalau baa! Neme ei basa nggei ia, dei fo hambu hataholi hida fo bei taa mate, losa faik bee ala lita Au, fo Hataholi Isi-isik ia, dadik Manek fo toꞌu palenda.” ");
INSERT INTO llg_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Seli faik nee, boe ma Yesus noke nala Petrus, Yakobis no fadin Yohanis, de ala sama-sama ndaꞌe leni lete madema esa lain leu, fo kada mesa kasa lai ndia. ");
INSERT INTO llg_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Losa lain, boe ma lita Yesus namata-ao feꞌe so. Matan nasaꞌa leo ledo, ma Ndia baloꞌa papaken dadik fula manggahadok. ");
INSERT INTO llg_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Kada nggengge neuk, lita Ana nakokola no baꞌi Musa ma baꞌi Elia. ");
INSERT INTO llg_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Boe ma Petrus mopo duduꞌan, losa ana kokolak nadabak, nae, “Ama aa! Ita malole hiak nai ia, maa! De malolenak ai tao mala lak telu. Esa soaneu Ama, esa neu baꞌi Musa, ma esa bali neu baꞌi Elia.” ");
INSERT INTO llg_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ledoeik Petrus kokolak leondiak, boe ma kada nggengge neuk koꞌas konda de mboti nala sala. Boe ma ala heran lalan seli lamanene halak esa kalua neme koꞌas ndia mai, nae, “Mamanene baa! Yesus ia Au Ana susueng. Ana tao namahoko Au daleng taa-taa. Mamanene neulalau neu Ndia baa!” ");
INSERT INTO llg_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Lamanene leondiak, boe ma ana mana tungga nala bii lalan seli, losa ala tuꞌu latotonok. ");
INSERT INTO llg_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Tehuu Yesus mai tao nafofoꞌa sala, boe ma Ana nae, “Wei! Ei foꞌa leo. Boso bii!” ");
INSERT INTO llg_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Boe ma ala botik mata nala, tehuu taa lita esa boe nai ndia. Huu kada Yesus mesa kana. ");
INSERT INTO llg_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Basa ndia boe ma, ala mulai konda leme letek ndia mai. Boe ma Yesus kaꞌi sala, nae, “Boso mafada sudi see, hata fo isinaak ei mitak ndia baa! Huu Au, Hataholi Isi-isik ia, musi mate dei. Basa na, dei fo mete ma Au asoda fali so, bei fo ei mafada hataholi.” ");
INSERT INTO llg_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Boe ma latane Ndia lae, “Ama ia memak Karistus, tehuu baꞌi Elia nai bee? Huu mese anggama la sila, lanoli lae, baꞌi Elia musi mai dei, bei fo Karistus mai. Tehuu tungga Ama, na, leobee?” ");
INSERT INTO llg_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesus nataa nae, “Memak tetebes. Baꞌi Elia musi mai dei, fo soi dalak fee Karistus. ");
INSERT INTO llg_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Tehuu mamanene neulalau baa! Baꞌi Elia mai so, tehuu hataholi taa lalela kana. Ala lakatotoꞌa kana, tungga sila hihiin. Leondiak boe, dei fo ala tao Au, Hataholi Isi-isik ia.” ");
INSERT INTO llg_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Lamanene basa leondiak, bei fo ala bubuluk, lae, baꞌi Elia fo Yesus kokolak ndia, na ndia, Yohanis Mana Salanik. ");
INSERT INTO llg_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Boe ma ledoeik Yesus asa fali so, latonggo lo hataholi noꞌuk lahani sala. Boe ma touk esa mai sendek lunggulanggan, de noke tulun ");
INSERT INTO llg_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","nae, “Lamatuak aa! Kasian neu au anang dei! Huu ana hambu hedi mulu biꞌik, ma ana doidoso nalan seli. Mete ma hedis ndia foe, na, nasiꞌa tuda neni oe dale neu, do haꞌi dale neu. Tulun dei, Lamatuak! ");
INSERT INTO llg_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Au uan neni Lamatuak ana mana tungga mala neu so, tehuu taa bisa tao lahain.” ");
INSERT INTO llg_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Namanene leondiak, boe ma Yesus nasapala Ndia ana mana tungga nala, nae, “Heh! Ei ia ana seli maa! Au anoli ei taa-taa so, tehuu ei taa malelak neulalau. Ma ei taa mamahele tebe-tebe neu Au! Au musi nggaleloak neu ei losa fai hida bali? Mua kakanak ndia mai leo!” ");
INSERT INTO llg_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ala loo kakanak ndia neu Ndia, boe ma Ana husi heni nitu neme kakandak ndia mai. Boe ma nitu ndia kalua laꞌo ela kakanak ndia, de ana hai tutik. ");
INSERT INTO llg_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Basa ndia, boe ma ledoeik Yesus mesa kana no Ndia ana mana tungga nala, ala latane Ndia lae, “Ama aa! Hatina de isinak ai taa bisa husi kalua heni nitu ndia?” ");
INSERT INTO llg_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesus nataa sala nae, “Ei taa bisa husi heni nitu ndia, huu ei taa mamahele tebe-tebe neu Au. Masanenedak baa! Mete ma ei mamahele tebe-tebe neu Au, na, mae kada fa anak boe oo, sama leo ai deꞌe kadiꞌi anak esa, tehuu ei bisa palenda letek esa, mae, ‘Heh letek! Lali muni ele muu!’ Neu ko ana lali. De, ei bisa tao sudi hata, sadi ei mamahele tebe-tebe neu Lamatuak. ");
INSERT INTO llg_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Tehuu mamanene baa! Nitu matak leoiak, memak manggalauk. Mete ma ei taa hule-haladoi ma puasa, fo moke tulu-falik neme Lamatuak mai, na, ei taa bisa husi nitu matak leondiak.” ");
INSERT INTO llg_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Basa de laꞌi esa, Yesus ma Ndia ana mana tungga nala lakabubua lai propinsi Galelea. Ana nafada sala nae, “Taa dook so bali, huu ala sangga seꞌo heni Au neu hataholi feꞌek. ");
INSERT INTO llg_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Boe ma ala tao lisa Au Hataholi Isi-isik ia. Memak Au mate, tehuu dei fo neu binesan, Au asoda fali.” Lamanene Ndia kokolan leondiak, boe ma ana mana tungga nala dale hedi lalan seli. ");
INSERT INTO llg_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Faik fo Yesus no Ndia ana mana tungga nala leni Kapernaum leu, boe ma mana susu-bea la, mai latane Petrus lae, “Ei Mesem bae Uma Ina Huhule-haladoik bean, do taa?” ");
INSERT INTO llg_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Boe ma Petrus nataa nae, “Bae maa!” Faik ana fali, boe ma Yesus nafada nakahuluk ndia nae, “Wei Simon! O duduꞌa sudik. Mane kala lai daebafok ia haꞌi bea neme see mai? Neme sila ana heheli nala, do neme hataholi feꞌek mai?” ");
INSERT INTO llg_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petrus nataa, nae, “Neme hataholi feꞌek mai!” Yesus tuti bali, nae, “Mete ma leondiak, na, manek ana hehelin taa bae, hetu? ");
INSERT INTO llg_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Leondiak boe no Uma Ina Huhule-haladoik bean. Tehuu boso ita tao tala mana susu-bea la luli. De, malolenak, kada o muu dolu iꞌak nai dano dale leo. O mala iꞌa makasososak, na, huꞌa bafan. Dei fo o hambu doi lilo fulak esa nai ndia. Basa na o pake doik ndia, fo muu bae ita dua nggata bean. Huu ndia dai ita dua nggata bean.” ");
INSERT INTO llg_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Faik ndia, Yesus ana mana tungga nala mai latonggo lo Ndia, de latane, lae, “Ama! See ndia ina-huuk nalan seli neme basa Manetualain hataholi nala?” ");
INSERT INTO llg_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Boe ma Yesus noke nala kakana kadiꞌik esa, de nambededein neu sila lalada nala. ");
INSERT INTO llg_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Boe ma Ana nae, “Mamanene neulalau! Hataholi mana nau maso dadik Manetualain hataholin, na, ana musi tao nasa fali ndia dala duduꞌan, fo dadik sama leo kakana kadiꞌik ia, fo taa sosoꞌuk nalelak aok. ");
INSERT INTO llg_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Huu hataholi dale kadiꞌi-taidaek ia, sama leo kakana kadiꞌik ia, de ndia ndia hataholi ina-huuk nalan seli nai Lamatuak matan. ");
INSERT INTO llg_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","De, hataholi mana simbok hataholi kadiꞌi-taidaek sama leo kakanak ia, huu namahele Au, na, hataholi ndia simbok Au so. ");
INSERT INTO llg_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Boe ma Yesus nafada sala bali, nae, “Mete ma hambu hataholi tao nala kakana kadiꞌik esa tungga dala salak, losa taa namahele Au bali, na, mata neuk baa! Malolenak hataholi mbaꞌa batu ina-huuk esa neu lesuhaꞌin, fo nabolon neni tasi laladan neu. ");
INSERT INTO llg_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Memak daebafok ia mamana soe, huu hambu dedeꞌak noꞌu kala tao lala hataholi tuda leni salak dale leu. Tehuu hataholi mana hambu soe manai lain seli ndia, na ndia, hataholi fo mana tao nala hataholi feꞌek tao salak. ");
INSERT INTO llg_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Mete ma o tao salak munik o limam, do o eim, na, tete henin leo! Huu malolenak o maso muni nusa-sodak muu, mua kada limak seli, do eik seli, lolen lena heni ala mbia heni o muni haꞌi naraka muu, mua o limam ma eim dua sala. ");
INSERT INTO llg_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Mete ma tao salak munik o matam seli, na kada doꞌi heni o matam leo! Huu malolenak o maso muni nusa-sodak muu, mua kada o matam seli lolen lena heni, ala mbia heni o muni naraka muu, mua o matam dua sala.” ");
INSERT INTO llg_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Yesus kokolak bali nae, “Mata neuk baa! Boso makadadaek kakana kadiꞌik leoiak. Huu Lamatuak ata nusa-sodan nala lanea sala. De, ata nusa-soda kala sila, maso leu sudi faik bee, fo lafada Manetualain hataholin dedeꞌa nala. ");
INSERT INTO llg_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","13","Ei duduꞌa neulalau, huu Au sangga fee nakandandaak leoiak: hambu hataholi esa biꞌilombon natun esa. Boe ma laꞌi esa biꞌilombo esa laꞌo nasalak, de, mesa kana tungga ndia dalan. Ei maehetuk hataholi ndia musi tao hata? Neu ko ana laꞌo ela biꞌilombo kasio hulu sio kala sila leu letek lain, de neu sangga biꞌilombo esak mana mopok ndia. Mete ma ana hambu fali kana so, na, dei fo ana namahoko nalan seli, huu nita ndia biꞌilombon esak ndia, lolen lena heni ndia biꞌilombo kasio hulu sion, fo taa mana mopo kala sila. Au, Hataholi Isi-isik ia, mai fo sangga fee sodak neu hataholi mana laꞌo heok neme dala ndoos mai. ");
INSERT INTO llg_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Huu mae kada kakana kadiꞌik esa mopon boe oo, Au Amang nai nusa-sodak taa nameda malole. ");
INSERT INTO llg_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Yesus kokolak bali, nae, “Mete ma o tolanoo kamahelem tao salak neu o, na, o musi muu matonggo muan. Basa na, mete ma ei dua nggei mesang, bei fo mafada ndia salan. Mete ma ana namanene o kokolam, na, ei dua nggei malole seluk ndia so. ");
INSERT INTO llg_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Tehuu mete ma ana taa nau namanene o, na, muu mala o nonoom esa do dua, fo miu sama-sama. Miu matonggo mia hataholi ndia, fo kokolak seluk mian. Huu nai Manetualain Susula Malalaon nana sulak nae, ‘Nai dedeꞌak esa, musi hambu sakasii dua do telu kokola nala sama, na, bei fo simbok sila kokolan nala ndia.’ ");
INSERT INTO llg_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Tehuu mete ma ana bei taa nau namanene ei, na, miu mafada salani kala. Ma mete ma ndia boe oo, taa nau simbok salani kala kokolan nala, na, taon neu ndia sama leo hataholi taa mana malelak Lamatuak. Mete ma taa, na, taon neu ndia manggalaun sama leo mana susu-bea. ");
INSERT INTO llg_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Masanenedak matalolole Au kokolang ia baa! Hata fo ei kaꞌin nai daebafok ia, na Lamatuak kaꞌin nai nusa-sodak boe. Ma hata fo ei makamboꞌi kana nai daebafok ia, na, Lamatuak nakamboꞌi kana nai nusa-sodak boe. ");
INSERT INTO llg_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ma Au afada seluk bali, ae, mete ma hambu hataholi dua leme ei mai hule-haladoi dalek esa, na, neu ko Au Amang nai nusa-sodak fee hata fo ala lokek ndia. ");
INSERT INTO llg_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Huu mete ma hambu hataholi dua do telu lakabubua fo hule-haladoi sama-sama, huu sila ndia, Au hataholing, na, Au boe oo, nai sila laladan.” ");
INSERT INTO llg_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Basa ndia, boe ma Petrus mai natane Yesus nae, “Lamatuak, au sangga atane fa. Mete ma au tolanoong hataholi kamahelek, tao salak taa-taa neu au, na, au musi feen ambon laꞌi hida? Losa laꞌi hitu do?” ");
INSERT INTO llg_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Boe ma Yesus nataa nae, “Taa! O musi fee ambon neu ndia laꞌi hitu laꞌi hitu hulu, losa o taa bisa hingga malan so bali. ");
INSERT INTO llg_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ei musi tao tungga leondiak, huu Manetualain sama leo manek hingga ndia pegawe nala huta nala. ");
INSERT INTO llg_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ledoeik ana mulai hingga, boe ma nadenu ndia hataholin neu noke nala pagawe esa fo mana mahutak ndia doin kefi-kefin. ");
INSERT INTO llg_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Tehuu pagawe ndia taa bisa bae nggati nala hutan ndia. Boe ma manek palenda nae, ‘Miu seꞌo heni hataholi ndia no basa sao-ana nala, fo ala dadik ata. Ma seꞌo heni basa hata nala, fo bae huta nala.’ ");
INSERT INTO llg_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Namanene leondiak, boe ma pagawe ndia sendek lunggulanggan neu manek matan, de ana kokoen nae, ‘Awii! Ama aa! Ama manek tulun fee au fai fa dei! Dei fo au bae falik basa au hutang.’ ");
INSERT INTO llg_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Namanene leondiak, boe ma manek nameda kasian neu ndia. De ana koka heni tutik basa ndia pegawen hutan. Basa de ana mboꞌi heni pegawe ndia. ");
INSERT INTO llg_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Tehuu ledoeik pagawe ndia kalua, de, natonggo no nonoon esa fo nahutan doik fa. Boe ma ana humu nala nonoon ndia, de ana kidu neu lesuhaꞌin ma nasapala kana, nae, ‘Weih! Hatematak ia bae o hutam leo!’ ");
INSERT INTO llg_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Namanene leondiak, boe ma nonoon sendek lunggulanggan de ana kokoen nae, ‘Awii! Tolanoo aa! Tulun fee au fai fa dei! Dei fo au bae ketu au hutang neu o.’ ");
INSERT INTO llg_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Tehuu pegawe ndia nae, ‘Taa bisa! Mae leobee boe oo, o musi bae hatematak ia!’ Basa de nandee nonoon ndia neni bui dale neu, losa ana bae basa hutan ndia. ");
INSERT INTO llg_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ledoeik manek namanene neme pegawe feꞌek fo nita hata mana dadik ndia so, boe ma dalen hedis. Basa de neu nafada manek. ");
INSERT INTO llg_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Namanene leondiak, boe ma manek noke pegawe fo taa nameda nalelak aon ndia. Ana kasilanggan, nae, ‘Heh, hataholi manggalauk! Huu o moke au kasian neu o, huu ndia de, au koka heni basa o hutam. ");
INSERT INTO llg_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Tehuu hatina de o taa kasian neu o nonoom fo sama leo au kasian neu o?’ ");
INSERT INTO llg_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Manek ndia manggalau, losa nadenu leu landeen neni bui dale neu, fo suek ala tao doidoson, losa ana bae ketu basa hutan.” ");
INSERT INTO llg_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Boe ma Yesus nateꞌe tutuin, ma nafada nae, “Naa, Au Amang nai nusa-sodak boe oo, nahinggak leondiak. Dei fo Ana huku ei, mete ma ei taa mafalende heni tebe-tebe ei tolanoo kamahelem sala nala.” ");
INSERT INTO llg_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesus nanoli basa sila, boe ma Ana laꞌo ela Galelea, de neni propinsi Yudea neu, nai lee Yarden selik ele. ");
INSERT INTO llg_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Hataholi noꞌu kala tungga Ndia, boe ma Ana tao nahai hataholi kamahedik nai ele. ");
INSERT INTO llg_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Hambu hataholi Farisi luma mai fo sangga tao latuda Ndia. Ala latane lae, “Ama aa! Tungga ita heti-heu anggaman, na, mete ma touk sao so, na, bole namaketu no saon, nenik sudi tuten hata, do leobee?” ");
INSERT INTO llg_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Tehuu Ana nataa nae, “Ei ia, hataholi malela anggama. Tehuu hatina de ei taa nau bubuluk Manetualain Susula Malalaon isin? Huu nai Tutui Sososan, nana sulak, nae, ‘Manetualain nakadadadik nala hataholi touk ma inak.’ ");
INSERT INTO llg_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ma nana sulak bali, nae, ‘Huu ndia, de touk musi laꞌo ela ndia ina-man, fo neu dalek esa no saon, te dua sala dadik esa so.’ ");
INSERT INTO llg_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Huu ndia, de mete ma Manetualain mesa kana tao dua sala dadik neu esa, na, hataholi taa bole tao sala lamaketu bali!” ");
INSERT INTO llg_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Lamanene Yesus kokolak leondiak, boe ma hataholi Farisi la latane bali lae, “Mete ma leondiak, na, hatina de baꞌi Musa nae, hataholi bole lamaketu, sadi ana fee susula namaketuk neu saon dei?” ");
INSERT INTO llg_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Boe ma Yesus nataa nae, “Baꞌi Musa mboꞌi ei bei-baꞌi mala lamaketu lo sao-inak, huu sila ndia, langga batu nala leo ei! Tehuu faik fo Lamatuak nakadadadik daebafok ia, Ndia hihiin taa leondiak. ");
INSERT INTO llg_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Huu ndia de Au afada baa! Mete ma sao-inak tao eok nakahuluk, na, touk bole namaketu non. Tehuu mete ma sao-inak taa tao eok, no touk mana namaketu non, fo basa na ana sao-ina feꞌek bali, na, ana hohongge ndia so!” ");
INSERT INTO llg_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Lamanene leondiak, boe ma ana mana tungga nala kokolak lae, “Mete ma leondiak, na, malolenak boso sao bali.” ");
INSERT INTO llg_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Boe ma Yesus nataa nae, “Taa basa hataholi la simbok Au kokolang ia. Kada hataholi fo Manetualain tudu nalan so. ");
INSERT INTO llg_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Huu hambu hataholi taa sao, huu bonggin mai leondiak so. Hambu tana sao boe, huu hataholi taon leondiak. Ma hambu, ana hele taa sao boe, huu ana nau kada nakalalaꞌok Manetualain uen. Hataholi mana malelak nanonolik ia, na, ela ana simbon leo.” ");
INSERT INTO llg_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Faik ndia, hataholi la koꞌo loo ana nala leni Yesus leu, fo suek Ana tao liman ma kokolak babaꞌe-babatik fee sala. Tehuu Ndia ana mana tungga nala kaꞌi hataholi la sila. ");
INSERT INTO llg_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Boe ma Ana manggalau Ndia ana mana tungga nala, nae, “Ela kakana kala sila leni Au mai! Boso kaꞌi sala! Huu hataholi fo sama leoiak ia, na ndia, Manetualain hataholin ndia.” ");
INSERT INTO llg_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Basa de Ana tao liman neu kakana ana kala sila, ma noke Manetualain fee babaꞌe-babatik neu sala. Basa ndia, boe ma Ana laꞌo ela mamanak ndia. ");
INSERT INTO llg_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Basa de laꞌi esa, hambu hataholi mai natane Yesus, nae, “Ama Mesen aa! Au musi tao hata malole leobeek, fo suek au bubuluk no teteben, ae, au bisa maso nusa-sodak do? Huu au nau asoda akandondoo henin ua Manetualain.” ");
INSERT INTO llg_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Boe ma Ana nataa nae, “Hatina de o matane Au laꞌeneu hata fo malole? Kada Manetualain mesa kana malole. Mete ma o nau masoda mua Ndia, na, tungga Ndia palendan.” ");
INSERT INTO llg_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Hataholi ndia natane bali, nae, “Palenda beek ndia?” Boe ma Yesus nataa nae, “Boso makanisa; boso tao eok; boso mamanaꞌo; boso dadik sakasii pepekok; ");
INSERT INTO llg_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","fee hada-holomata neu o ina-mam; ma sue o tolanoom, sama leo o sue o ao-ina hehelim.” ");
INSERT INTO llg_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Hataholi ndia nataa nae, “Naa, basa palenda sila, au tao tungga sala so. Hata fo bei taa dai bali?” ");
INSERT INTO llg_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Namanene leondiak, boe ma Yesus nae, “Naa! Mete ma o nau tungga basa Lamatuak hihii-nanaun, na, fali fo seꞌo heni basa o hata mala. Basa na, babaꞌe sala leu hataholi hata taa kala. Bei fo o mai tungga Au. Huu neu ko Manetualain bala fee o hata makadotok nai nusa-sodak.” ");
INSERT INTO llg_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Namanene leondiak, boe ma hataholi ndia fali no dalen hedis, huu ndia kama suꞌik nalan seli. ");
INSERT INTO llg_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Boe ma Yesus kokolak no Ndia ana mana tungga nala, nae, “Mamahele Au, huu hataholi kama suꞌik, totoꞌak nalan seli ana maso nusa-sodak neu. ");
INSERT INTO llg_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Totoꞌak ndia sama leo banda onta maso neni lalae dale neu nesik ndandauk bolon.” ");
INSERT INTO llg_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Lamanene leondia boe ma ana mana tungga nala heran lalan seli. Boe ma lae, “Mete ma leondiak na, see bisa maso neni nusa-sodak neu?” ");
INSERT INTO llg_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ana mete neulalau sala, boe ma Ana kokolak, nae, “Mete ma hataholi tao, na, memak taa bisa. Tehuu mete ma Manetualain tao, na, basan bisa dadi!” ");
INSERT INTO llg_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Boe ma Petrus tao nasanenedak nae, “Ama aa! Ai laꞌo ela basa ai hata nala, fo tungga Ama. Tehuu ai hambu hata?” ");
INSERT INTO llg_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ana nataa, nae, “Mamahele Au! Dei fo mete ma Manetualain tao basan dadik beuk, na, Au Hataholi Isi-isik ia, anggatuuk nai kadela mana palenda ina-huuk. Faik ndia, ei mana tungga Au, manggatuuk nai kadela mana palenda kasanahulu dua kala boe, fo dadik mana maketu neu ita leo Israel kasanahulu dua nala! ");
INSERT INTO llg_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Hataholi mana laꞌo ela uman, kaꞌa-fadin, ina-man, ana nala, ma osin, fo tungga Au, dei fo ana simbo falik laꞌi natun esa. Boe ma mete ma daebafok basan, na, ndia boe oo, hambu sodak no Manetualain nakandondoo henin. ");
INSERT INTO llg_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","De, masanenedak baa! Tungga Manetualain duduꞌan, na, hataholi noꞌuk taok aon ina-huuk, na sila ndia hataholi kadiꞌik nalan seli. Tehuu hataholi fo ana taok aon kadiꞌik, na sila ndia hataholi ina-huuk, tungga Manetualain duduꞌan.” ");
INSERT INTO llg_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Basa ndia, boe ma Yesus nanoli nae, “Manetualain totoꞌu palendan ndia, sama leo nakandandaak ia: maosik esa kalua fafai anan liꞌu nee, neu sangga hataholi mana tao ues nai ndia osi anggol. ");
INSERT INTO llg_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ana hambu hataholi mana tao ues, boe ma lala-halak tao ues faik esa, na, seseban doi lilo fulak esa, tungga seseba basa faik. Lala-halak, boe ma ana nadenu hataholi leu tao ues nai osi ndia. ");
INSERT INTO llg_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Liꞌu sio fafain, boe ma ana neni pasak neu. Neu ndia boe ma nita hataholi hida kada langgatuuk lanado kala lai ndia. ");
INSERT INTO llg_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Boe ma nafada sala, nae, ‘Wei tolanoo nggalei! Ei nau tao ues nai au osing do? Dei fo au bae ei no mandaan.’ Lamanene leondiak, boe ma lakaheik, de leu tao ues. ");
INSERT INTO llg_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Liꞌu sanahulu dua ledo kamatetun, ma liꞌu telu ledo bobon, maosik ndia kalua neme uman mai fo neu sangga hataholi mana tao ues bali. ");
INSERT INTO llg_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ledo bobok so fo meda liꞌu lima, boe ma maosik kalua bali. Ana susuli neu-mai, boe ma hambu hataholi bei lambadeik loulatak. Boe ma natane sala, nae, ‘Hatina de ei mambadeik loulatak mima fafain mai losa ledo bobok, ma taa tao hata esa boe?’ ");
INSERT INTO llg_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Hataholi la sila lataa lae, ‘Ama aa! Taa hambu hataholi esa boe fo ana fee ai tao ues.’ Boe ma maosik ndia nae, ‘Mete ma leondiak, na, ei miu tao ues nai au osing leo!’ ");
INSERT INTO llg_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Losa liꞌu hahae tao ues, boe ma maosik ndia noke nala ndia mandor, de nae, ‘Moke hataholi mana tao ues sala, fo bae sila esa-esak doi seseba tao ues. Mulai neme hataholi mana maso makabuik losa hataholi mana maso sososak ndia.’ ");
INSERT INTO llg_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Boe ma mandor ndia noke hataholi mana tao ue sala, mulai neme liꞌu lima ledo bobon. Ana fee sala esa-esak doi lilo fulak esa. ");
INSERT INTO llg_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Basa de mandor noke hataholi mana tao ues feꞌe kala, losa hataholi mana tao ues mulai neme liꞌu nee fafain. Mana tao ues neme fafai anan, duduꞌa lae, neu ko ala simbo noꞌuk lena heni hataholi la fo mana tao ues mulai neme liꞌu lima ledo bobon. Naa te, sila boe oo, simbo doi lilo fulak esa. ");
INSERT INTO llg_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Simbo lala leondiak, boe ma ala manggalau lo maosik, lae, ");
INSERT INTO llg_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Aweꞌe! Taa bisa leoiak ama! Sila mana makabuik lalan seli, kada tao ues liꞌu esa. Tehuu ai mana maso fafaik ia, tao ues sota malan seli, losa mbuse la tetee! Tehuu talobee de ama bae ai sama leo sila?’ ");
INSERT INTO llg_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Boe ma maosik fee sala natataak esa, nae, “Kaꞌa aa! Au taa aputak kaꞌa. Huu kaꞌa mesa kana nakaheik tao ues faik esa na, seseban doi lilo fulak esa. Tetebes hetu? De, au tungga ita nakeketun hetu? ");
INSERT INTO llg_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Malolenak kaꞌa simbo mala kaꞌa doi sesebam, fo fali leo. Mete ma au nau fee hataholi mana maso tao ues makabuik nalan seli neme kaꞌa mai, noꞌun sama leo au fee kaꞌa, na, au dedeꞌang ndia. ");
INSERT INTO llg_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Neu ko au bole pake au doing tungga au hihiing. Talobee de kaꞌa mamanasa huu au dale maloleng?’ ");
INSERT INTO llg_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Leondiak boe, neu faik fo Manetualain dadi Manek neu hataholi la, Ana bala neu Ndia hataholi nala tungga Ndia hihiin. De, hataholi mana mai makabuik mateꞌen, dei fo ana simbo babaꞌen sama leo hataholi mana mai makasososan. Hataholi mana mai makasososan, dei fo ana simbo ndia babaꞌen sama leo hataholi mana mai makabuik mateꞌen.” ");
INSERT INTO llg_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Basa ndia, boe ma Yesus asa mulai laꞌok leni Yerusalem leu. Nai dala laladak, Ana noke nala Ndia ana mana tungga nala fo mesa kasa lakabubua lo Ndia. Basa ndia, boe ma nafada bali nae, ");
INSERT INTO llg_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ei mamanene baa! Hatematak ia, ita sangga teni Yerusalem teu. Tehuu nai ele ala seꞌo heni Au, Hataholi Isi-iisik ia, neu malangga anggama Yahudi la malanggan nala, ma mese anggama la. Basa ndia, na, ala laketun fo huku mate Au. ");
INSERT INTO llg_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Boe ma ala fee Au uu hataholi feꞌek fo taa mana malelak Manetualain. Boe ma ala lakamamaek Au. Ma ala filo lahina Au aong. Basa de, bei fo ala tao lisa Au nai ai ngganggek. Memak Au mate tebe. Tehuu neu binesan, Au asoda fali.” ");
INSERT INTO llg_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Basa ndia, boe ma Sabadeus saon no anan Yakobis ma Yohanis leni Yesus leu. Boe ma ana sendek lunggulanggak fee hadak, ma kokoe Yesus. ");
INSERT INTO llg_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Boe ma Yesus natanen, nae, “Ina paluu hata?” Boe ma inak ndia nafada nae, “Leoiak Ama! Au oke, fo mete ma Ama nanggatuuk toꞌu palenda so, na, Ama soꞌu mala au anang dua sala ia, fo sila tungga toꞌu palenda sama-sama lo Ama boe. Au oke fo Ama nanggatutuu esa neu Ama boboa konam, ma esa bali neu boboa kiim.” ");
INSERT INTO llg_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Namanene leondiak, boe ma Yesus nafada Yakobis ma Yohanis nae, “Ei taa bubuluk hata fo ei mokek ndia. Huu dei fo Au hambu doidosok noꞌuk. De, leobee? Ei maehetuk ei boe mabeꞌi lemba doidosok ndia sama-sama mia Au do?” Dua sala kada lataa neulalau, lae, “Bisa nalan seli, Ama bou!” ");
INSERT INTO llg_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Basa de Ana nataa bali nae, “Memak, ei boe oo, dei fo lemba doidosok ndia sama leo Au. Tehuu dei fo see nanggatuuk nai Au kii-konang, na Au taa ndia aketun. Ndia Manetualain hak nakeketun ndia. Ana naketu mema kana so, see ma see ndia nanggatuuk nai mamanak ndia.” ");
INSERT INTO llg_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ledoeik ana mana tungga kasanahulu feꞌe nala lamanene dua sala nonoken leondiak, boe ma ala luli. ");
INSERT INTO llg_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Tehuu Yesus noke nala basa sala, de nae, “Leoiak! Ei bubuluk so hetu? Hataholi ina-huu kala mana toꞌu palenda lateme tuni-ndeni lauinggu nala, losa taa bisa botik langga nala. Ma malangga nala leme nusak fo hataholi taa lalelak Manetualain, ala palenda lala lena-lenak, losa lauinggu nala taa bisa botik langga nala. ");
INSERT INTO llg_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Tehuu ei taa bole tao leondiak! Naa, see neme ei mai nau dadik hataholi ina-huuk, na ana musi dadik hataholi nadedenuk fo ono-lau hataholi feꞌek. ");
INSERT INTO llg_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ma see nau dadik malanggan, na, ana musi tao aon leo ata. ");
INSERT INTO llg_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Mamanene baa! Au leondiak boe. Au Hataholi Isi-isik ia, mai ono-lau hataholi. Au taa mai fo hataholi ono-lau Au. Huu Au fee Au sodang katema tuan, fo soi hataholi noꞌu kala sala-singgo nala.” ");
INSERT INTO llg_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Basa ndia, boe ma Yesus asa laꞌok lakandoo. Ledoeik ala kalua leme kota Yeriko mai, hataholi noꞌuk tungga sala. ");
INSERT INTO llg_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Nai ndia, hambu hataholi mbokek dua langgatuuk lai dalak bifin. Ledoeik lamanene, lae, mana nesik ndia, na ndia, Yesus maneme Nasaret mai, boe ma ala langgou tingga-tingga lae, “Lamatuak! Dauk numbu-sadun aa! Ai mahani-mahani mala doon seli neu Lamatuak! Kasian neu ai dei!” ");
INSERT INTO llg_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Namanene langgou leondiak, boe ma hataholi kaꞌi sala lae, “Heh Ei dua nggei boso manggilo!” Tehuu ala boe langgou latingga bali, lae, “Lamatuak aa! Dauk numbu-sadun aa! Kasian neu ai dei!” ");
INSERT INTO llg_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ledoeik Ana namanene leondiak, boe ma Ana hahae de natane sala nae, “Ei nau Au tao hata fee ei?” ");
INSERT INTO llg_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Lataa lae, “Lamatuak aa! Tulun fo ai bisa mita dei!” ");
INSERT INTO llg_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Namanene sila kokolan leondiak, boe ma Ana nameda kasian neu sala. Basa de Ana daba mata nala, de ala lita tutik. Basa ndia, boe ma ala laꞌo tungga Ndia. ");
INSERT INTO llg_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Basa ndia, boe ma Yesus asa laꞌok lakandoo losa nggolok esa nade Betfage, nai lete Setun boboan. Nggolok ndia deka-deka no kota Yerusalem. Leu ndia, de ala hahae tataak. Boe ma Ana nadenu Ndia ana mana tunggan dua, fo leu lakahuluk. ");
INSERT INTO llg_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ana palenda sala nae, “Ei dua nggei mini nggolok ele miu. Mete ma ei maso, na, dei fo ei mita banda keledei ina esa no anan, nanambaꞌak lai ndia. Ei miu sefi heni tali nala, fo hela mini sala leni Au mai. ");
INSERT INTO llg_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Tehuu mete ma hataholi natane ei, nae, ‘Hatina de ei hela mini hataholi banda keledein?’ Naa, ei mataa mae, ‘Lamatuak sangga paken. Mete ma pake basan, na, dei fo Ana haitua fali kana mai tutik.’ ");
INSERT INTO llg_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Basa ia musi dadi, tungga hata fo Manetualain mana kokolan sulak mema kana so, nae, ");
INSERT INTO llg_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","‘Wei, ei hataholi Yerusalem asa! Mai mita ia dei baa! Huu ei Manem mai. Ana mai no dale kadiꞌi-taidaek. Ana mai saꞌe banda kaledei ana.’ ” ");
INSERT INTO llg_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Basa boe ma ana mana tungga nala leu de ala tao tungga basan, sama leo Yesus hehelun neu sala. ");
INSERT INTO llg_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ala hela loo banda keledei ina no anan leni Yesus leu. Boe ma ala bela sila lafa naluse nala neu banda keledei ana dean, de Yesus saꞌe neu lain, fo sangga maso neni kota neu. ");
INSERT INTO llg_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ledoeik ala sangga maso leni kota dale leu, boe ma hataholi noꞌu kala haꞌi lala lafa nala ma lafa ana nala, de bela sala leu dalak. Hambu luma boe, leu tati lala ai palm doo nala, de lakambembela sala leu dalak laladan. No leondiak, ala tao tanda lae, ala soluk Ndia leo hataholi ina-huuk. ");
INSERT INTO llg_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Boe ma luma laꞌok lakahuluk lai Yesus matan, ma mana tungga kala lai dea. Ala eki noꞌu lae, “Hosana! Ai koa-kio Manetualain! Huu Dauk numbu-sadun mai so! Hosana! Ai koa-kio neu Manetualain! Huu Lamatuak nadenu Hataholi ia mai. Hosana! Ai koa-kio neu Manetualain! Huu Lamatuak nanggatuuk toꞌu palenda memak, nai lalai fo deman ana seli!” ");
INSERT INTO llg_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ledoeik Yesus maso Yerusalem no nakasoek leondiak, boe ma basa kota isi nala kalua de latane lae, “Awii! See mana maik ia bae?” ");
INSERT INTO llg_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Hataholi noꞌu kala lataa, lae, “Ndia ia, Manetualain mana kokolan. Naden Yesus, fo hataholi Nasaret, neme propinsi Galelea mai.” ");
INSERT INTO llg_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Basa de Yesus asa laꞌok lakandoo, boe ma ala maso leni Uma Ina Huhule-haladoik dalek leu. Nai Uma Ina Huhule-haladoik pasan, hataholi la taon dadik pasak, fo laseꞌo lunda, suek hataholi paken dadik neu tunu-hotuk huhule-haladoik. Nita leondiak, boe ma Yesus husi kalua heni sala. Ana fae nalengga mei la fo ala taon neu mamana tuka doik, ma Ana fae nalengga banggu la fo ala paken neu laseꞌo mbui kala. ");
INSERT INTO llg_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Boe ma nafada sala, nae, “Lamatuak mana kokolan sulak mema kana so, nae, ‘Au ambadedei Uma ia, fo suek hataholi la mai hule-haladoi lai ia.’ Lamatuak hihiin leondiak, tehuu ei tao Uma ia dadik neu mana mamoa la mamana nakabubuan so!” ");
INSERT INTO llg_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Basa boe ma hataholi la loo hataholi mbokek ma luꞌu kala leni Yesus leu, lai Manetualain Uma Huhule-haladoin ndia. Boe ma Ana tao nahai basa sala. ");
INSERT INTO llg_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Nai ndia boe, hambu malangga anggama Yahudi malanggan nala, ma mese anggama la. Ledoeik lita Yesus tao tanda heran leondiak, boe ma ala luli. Nakalenak bali ledoeik lamanene kakana kala sila eki landaa lai Uma Huhule-haladoik ndia lae, “Hosana! Ai koa-kio Manetualain! Huu mane Dauk numbu-sadun mai so!” ");
INSERT INTO llg_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Basa de, malangga nala sila lafada Yesus lae, “Weih! O mamanene kakana kala sila kokolan? Ndia taa tetebes!” Tehuu Yesus nataa sala nae, “Hei, Au amanene. Tehuu hatina? Ei bei taa les mitak nai Manetualain Susula Malalaon laꞌeneu kakana kala mana koa-kio neu Manetualain do? Huu nai ndia nana sulak, nae, ‘Manetualain nahehele memak kakana mbimbilanak ma kakana kadiꞌik bafan nala, fo ala koa-kio Ndia.’ ” ");
INSERT INTO llg_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Basa boe ma, Yesus kalua laꞌo ela kota ndia, de neu sunggu nai nggolo Betania. ");
INSERT INTO llg_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Neu foꞌa fafain, Yesus asa laꞌok leni Yerusalem leu bali. Tehuu nai dala laladak, Ana nameda ndoe so. ");
INSERT INTO llg_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Nita ai huuk esa nai dalak bifin fo hataholi la lateme laꞌa boan. De, Ana neu deka-deka no ai huuk ndia, fo sangga memete sudik kaboak do taa. Tehuu ledoeik Ana losa ai huuk ndia, Ana taa nita boak esa boe, huu ai huuk ndia bei fo nadoo. Boe ma Ana kokolak neu ai huuk ndia, nae, “Huu o taa kalua o boam fee Au, de o taa bole maboa so!” Ana kokolak nateꞌe, boe ma ai huuk ndia namatuu tutik. ");
INSERT INTO llg_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ana mana tungga nala lita leondiak, boe ma ala nggengge. Ala latane lae, “Hatina de kada nggengge neuk ai huuk ia namatuu tutik?” ");
INSERT INTO llg_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Boe ma nataa nae, “Mamanene neulalau baa! Mete ma ei mamahele tebe-tebe Lamatuak, taa no dale kabaꞌek fa boe, na, ei bisa tao sama leo Au taok ndia. Ei bisa tao lena heni ndia boe. Conto leo: ei bisa palenda letek esa nanasoꞌuk neni tasi dale neu. Neu ko Manetualain keko heni letek ndia tutik, sadi ei mamahele tebe-tebe neu Ndia. ");
INSERT INTO llg_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Huu basa hata fo ei moke Manetualain, na, dei fo ei simbon, sadi ei mamahele tebe-tebe neu Ndia.” ");
INSERT INTO llg_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Basa de Yesus asa laꞌok lakandoo. Losa Yerusalem, boe ma ala maso fali leni Uma Ina Huhule-haladoik pasan leu bali. Ledoeik Ana nanoli hataholi laꞌeneu Manetualain dala sodan, boe ma malangga anggama Yahudi la malangga nala, ma lasi hada kala mai latane Ndia, lae, “Afik see nadenu o mai tao naodek nai ia? See fee o hak ndia?” ");
INSERT INTO llg_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Tehuu Ana bubuluk ala mai sangga dalak fo tao latuda Ndia. Boe ma Ana nataa nae, “Au boe oo, sangga atane ei. Ei mataa Au dei, bei fo Au ataa ei. ");
INSERT INTO llg_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Au sangga atane leoiak: ei basa nggei malelak Yohanis Mana Salanik ndia, hetu? See feen hak, fo ana salani hataholi? Manetualain do hataholi?” Boe ma ala duduꞌa leu-mai, boe ma lakokola lae, “Awii! Ita nana teꞌe nalak ia so maa! Huu mete ma ita tataa tae, ‘Manetualain fee hak’ na, dei fo Ana bala nae, mete ma leondiak, na, hatina de ei taa mamahele neu Yohanis?’ ");
INSERT INTO llg_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Tehuu ita boe oo taa bisa tae, ‘Hataholi fee hak’, te dei fo basa hataholi la manggalau lo ita. Huu sila lamahele, lae, Yohanis ndia, na, Manetualain mana kokolan.” ");
INSERT INTO llg_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Huu ndia de ala lataa Yesus lae, “Ai taa bubuluk.” Boe ma Yesus bala nae, “Naa! Mete ma leondiak, na, Au boe oo, taa paluu afada see ndia fee Au hak.” ");
INSERT INTO llg_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesus kokolak nakandoo no malangga nala sila, nae, “Ei duduꞌam leobee no nakandandaak ia? Touk esa ma ndia ana touanan dua. Ana palenda kakana kaꞌak, nae, ‘Ana nggo ei! Leledon ia, o muu tao ues nai osi dei.’ ");
INSERT INTO llg_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Tehuu kakanak ndia nataa nae, ‘Eh! Au taa uu.’ Tehuu taa dook boe ma ana fale dalen, de neu. ");
INSERT INTO llg_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Basa ndia boe ma, touk ndia nadenu kakana fadik nae, ‘ana nggo ei! Leledon ia, na, o muu tao ues nai osi dei.’ Boe ma kakanak ndia nataa nae, ‘Malole ama. Dei fo au uu.’ Tehuu naa te taa neu.” ");
INSERT INTO llg_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Tui basa leondiak, boe ma Yesus natane sala nae, “Naa, Au sangga atane leoiak: neme kakana kadua kala sila mai, see ndia tao tungga aman palendan ndia?” Boe ma lataa lae, “Kaꞌak!” Basa de Ana kokolak nae, “Hei. Tehuu mamanene neulalau, huu Au kokolak tetebes. Hataholi fo ei mae sila papake taa kala, sama leo mana susu-bea, ma ina kalabik, dei fo ala maso lakahuluk dadik Manetualain hataholin leme ei mai. Huu kada ei makaheik Lamatuak, tehuu taa tao tungga Ndia hihiin. ");
INSERT INTO llg_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Makahulun, Yohanis Mana Salanik nanoli ei so, dalan leobeek fo ei bisa masoda ndoos. Tehuu ei taa nau mamahelen. Naa te, ledoeik hataholi papake taa kala lamanene Yohanis, boe ma ala laꞌo ela sala-singgo nala, de ala tungga ndia nanonolin. Ei boe oo bubuluk basa sila. Tehuu ei taa nau hahae mima ei sala mala mai, fo tungga Manetualain hihii-nanaun.” ");
INSERT INTO llg_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Basa ndia, boe ma Yesus tui nakandandaak esa bali, nae, “Hataholi madaek esa tao osi, fo sangga sele ai anggol nai ndia dae bibian ndia. Boe ma ana mbaꞌa ndulen. Ma ana tao bak heꞌe anggol boak oen. Boe ma ana nambadedei mamana nanea madema esa. De ana fee hataholi mana tao osi la seba osi ndia, fo ala baꞌe duak osi ndia buna-boan lo ndia. Basa de touk ndia neni nusa dea neu. ");
INSERT INTO llg_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Losa fai ketu anggol boak, boe ma maosik nadenu ndia ana mana tao uen nala leni mana tao osi leu, fo loke ndia babaꞌen. ");
INSERT INTO llg_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Tehuu mana tao osi la sila taa mbali ndia hataholi nadedenu nala. Hambu nana fembak, ma hambu nana tao nisak, ma hambu nana mbiak nenik batu. ");
INSERT INTO llg_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Tehuu maosik ndia nadenu ndia ana mana tao ues bubua ina-huuk esa lena heni bubua makasososak ndia. Tehuu mana tao osi la, tao manggalauk leondiak leu sala boe. ");
INSERT INTO llg_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Doo-doo boe ma, maosik ndia, nadenu ndia ana hehelin neu. Huu ana duduꞌa nae, ‘Mete ma au haitua au ana heheling neu, na, neu ko ala simbo kana no malole, ma lamanenen.’ ");
INSERT INTO llg_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Tehuu ledoeik mana tao osi la lita kakanak ndia, boe ma lakokola lae, ‘Wei, ei mita dei! Te tou lasik haitua ana hehelin mai so. Dei fo ndia simbo basa tou lasik pusakan. De, mai fo ita tao tisan leo, fo suek ita hambu osi ia.’ ");
INSERT INTO llg_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Boe ma ala humu lala kakanak ndia, de hela lenin neni osi deak neu, de ala tao lisan.” ");
INSERT INTO llg_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yesus tui nateꞌe, boe ma Ana natane sala nae, “Naa, Au sangga atane leoiak: mete ma maosik fali main, na, meda ana tao leobee neu hataholi mana tao osi la sila?” ");
INSERT INTO llg_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Basa boe ma hataholi Yahudi la malangga nala lataa lae, “Neu ko ana tao nisa basa hataholi manggalauk kala sila. Basa ndia, na, ana fee hataholi feꞌek seba osi ndia, fo dei fo labaꞌe buna-boak, nandaa no ndia fai seseun.” ");
INSERT INTO llg_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Boe ma Yesus kokolak no sala nae, “Fama ei taa les mitak hata fo nana sulak nai Manetualain Susula Malalaon, nae, ‘Hambu batu esa tuka nala nggali henin, tehuu hatematak ia batu ndia dadik neu uma batu dii neten! Manetualain mesa kana hele nalan, fo nanggatutuu batu ndia. Huu ndia de ita titan, ndia neulaun ana seli!’ ” ");
INSERT INTO llg_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Basa de Yesus tuti Ndia kokolan bali, nae, “De, ei duduꞌa neulalaun dei baa! Makahulun, Lamatuak hele nala ita hataholi Yahudi ia, fo dadik Ndia hataholin. Tehuu ei taa nau mbali Au, de, neu ko Lamatuak hele nala hataholi feꞌek. Huu kada hataholi fo mana tungga Ndia hihii-nanaun, bisa maso dadik Ndia hataholin. ");
INSERT INTO llg_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Au afada tungga ndoon. Au ia, ndia batu netes ndia. Hataholi mana tuda laꞌeneu batu ndia, dei fo hataholi ndia lulutu ndoos. Ma mete ma batu ndia tuda laꞌe hataholi, na, dei fo hataholi ndia sosombu ndoos.” ");
INSERT INTO llg_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ledoeik malangga anggama Yahudi la malangga nala, ma hataholi Farisi la lamanene Yesus tutuin ndia, boe ma ala bubuluk lae, Ana uku ndandaak sila. Sila sama matetuk leo mana tao osi la sila, ma tuka batu mana mbia heni batu netes ndia. ");
INSERT INTO llg_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","De ala luli lalan seli. Boe ma ala heti dalan fo sangga humu Ndia. Tehuu ala bei bii hataholi noꞌu kala, fo mana taok Yesus ndia, Manetualain mana kokolan. De ala taa bisa tao hata-hata neu Ndia. ");
INSERT INTO llg_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Basa boe ma Yesus kokolak no sala bali, nenik nakandandaak, nae, ");
INSERT INTO llg_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Manetualain totoꞌu palendan ndia, sama leo manek esa tao ndia ana manen feta kabin. ");
INSERT INTO llg_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ledoeik lahehele lala feta so, boe ma nadenu ndia ata nala leu lafada hataholi nana hoka kala, lae, ‘Mai, huu feta sangga mulai ia so.’ Tehuu hataholi la sila taa nau mai. ");
INSERT INTO llg_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Basa de, ata la sila fali fo lafada manek. Namanene leondiak, boe ma manek ndia nadenu ata feꞌe nala, nae, ‘Ei miu mafada hataholi la sila, fo ala mai leo, huu feta nahehele so. Au hala sapi, ma tunu-nasu ala nanaꞌa malada la so. Madenu sala mai laꞌa feta, huu basan nana sadiak so.’ ");
INSERT INTO llg_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ata la sila leu lafada leondiak. Tehuu hataholi nana hoka kala sila taa nau mbali sala. Hambu mana neni osi neu, hambu mana neni mamana tao ues neu, ");
INSERT INTO llg_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","hambu luma humu lala manek ata nala, de tao doidoso sala losa mate sala. ");
INSERT INTO llg_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Namanene leondiak, boe ma manek luli nalan seli. Basa de nadenu soldadu nala leu tao lisa hataholi la mana tao lisa ndia ata nala. Boe ma soldadu la hotu heni kota ndia bebelak no dae. ");
INSERT INTO llg_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Basa boe ma, manek noke nala ata feꞌe nala, de nafada sala, nae, ‘Feta kabin nahehele so, tehuu hataholi fo au hoka kala sila, taa landaa tungga au fetang. ");
INSERT INTO llg_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Hatematak ia, ei kalua mini dala hataholi noꞌu kala miu, fo hoka sudi see fo ei matanggo mia sala lai ndia.’ ");
INSERT INTO llg_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Boe ma ata la sila leni dala hataholi noꞌu kala leu. Ala latonggo hataholi noꞌu kala lai ndia, de loo sala leni feta kabin ndia leu. Hataholi noꞌu kala tao lahenu feta ndia, de, hambu hataholi neulauk ma hataholi manggalauk. ");
INSERT INTO llg_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Basa de, manek neni feta ndia dalek neu de, ana mete ndule ndia hataholi mana mai nala sila. Boe ma nita hataholi esa taa pake baloꞌa feta. ");
INSERT INTO llg_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Boe ma manek ndia natanen nae, ‘Heh tolanoo! Hatina de o maso ia mai, taa pake baloꞌa feta?’ Tehuu hataholi ndia kada namanggonggoak. ");
INSERT INTO llg_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Boe ma manek ndia palenda ana mana ono-lau nala nae, ‘Hengge hataholi ia ei-lima nala, fo mbian deak neu. Ela ana namatani ma doidoso nai mamana makiuk ele.’ ");
INSERT INTO llg_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Leondiak boe oo, Manetualain hoka hataholi noꞌuk, tehuu Ana hele nala kada lumak fo dadik neu Ndia hataholin.” ");
INSERT INTO llg_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Lamanene basa Yesus kokolan ndia, boe ma hataholi Farisi la lala-halak fo sangga teꞌen ma soli salak neu Ndia. ");
INSERT INTO llg_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Boe ma ladenu sila ana mana tungga nala lo Herodes hataholi partei politik, fo ala latane-lataak lo Yesus. Ala sosoꞌuk Ndia, lae, “Ama Mesen! Ai bubuluk Ama dalen ndoos. Ama taa masapepeko malelak, ma taa hehele matak. Ama manoli taa-taa Manetualain Dedeꞌa-kokolan no ndoos. ");
INSERT INTO llg_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Hatematak ia, ai sangga matane dedeꞌak esa. Tungga ita anggama Yahudi heti-heun, na, meda ita musi bae bea fee mana palenda Roma mane ina-huun, do taa?” ");
INSERT INTO llg_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Tehuu Yesus bubuluk so, ala sangga doluk Ndia, fo kokolak laban mana palenda Roma. De, Ana nataa nae, “Memak ei hataholi mana dea-dalek! Hatina de ei sangga teꞌek Au minik dedeꞌak ndia? ");
INSERT INTO llg_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Hena matudu Au doi lilo fulak esa fo hataholi paken bae neu bea!” Boe ma latudun doi lilo fulak esa neu Ndia. ");
INSERT INTO llg_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Basa de natane sala, nae, “See mata-aon ia? Ma see naden ia?” ");
INSERT INTO llg_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Lataa lae, “Ndia kesel, mana palenda Roma mane ina-huun ndindia.” Boe ma Yesus nafada sala nae, “Mete ma leondiak, na ei fee mana palenda hata fo ndia hak. Ma fee Manetualain hata fo ana dadik Manetualain hak.” ");
INSERT INTO llg_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Lamanene leondiak, boe ma basa sala heran lalan seli, huu Ndia kokolan tetebes. Huu ndia, de ala taa bisa teꞌek lala Ndia. Boe ma ala laꞌo ela Ndia. ");
INSERT INTO llg_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Nai ndia boe oo, hambu hataholi partei Saduki. Hataholi Saduki la lanoli, lae, hataholi mana matek taa nasoda fali. Faik ndia, sila boe oo, sangga dalak fo teꞌek Yesus. Huu ndia de ala mai latanek lo Ndia, lae, ");
INSERT INTO llg_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Ama Mesen! Baꞌi Musa sulak ela ita so, hadak ia nae: mete ma touk esa mate laꞌo ela saon, tehuu anan taa, na, touk ndia fadin musi sao nala ina falu ndia, suek tao numbu-saduk fee kaꞌan mana matek ndia. ");
INSERT INTO llg_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Memak makahulun baꞌi Musa nanoli leondiak, tehuu ai sangga matane leoiak: hambu touk hitu tolanoo kala. Uluk sao, tehuu maten, ma anan taa. Boe ma fadin mana tungga ndia, sao nala ina falu ndia. ");
INSERT INTO llg_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Taa dook bali, boe ma maten boe, ma anan taa. Leondiak boe fadi katelun: ana sao nala ina falu ndia, tehuu maten, ma anan taa. Leondiak nakandondoo henin losa fadi mateꞌa teisusuk maten. ");
INSERT INTO llg_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Boe ma ina falu ndia maten. ");
INSERT INTO llg_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Hatematak ia ai sangga matane leoiak: inak ndia sao nitak touk hitu so. Dei fo neu daebafok babasan, boe ma Lamatuak tao nasoda falik hataholi mana mate kala, na, inak ndia dadik neu see saon?” ");
INSERT INTO llg_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Boe ma Yesus nataa nae, “Mete ma ei matane leondiak, na, ei sala malan seli ia maa! Huu ei taa bubuluk Manetualain Susulan isin. Ma ei boe oo, taa bubuluk Ndia koasan fo ana seli ndia! ");
INSERT INTO llg_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Teteben na leoiak. Dei fo mete ma Manetualain tao nasoda falik hataholi mana mate kala, na, taa lasaok so bali, sama leo Ndia ata nala malai nusa-sodak. ");
INSERT INTO llg_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ma Au boe sangga kokolak laꞌeneu hataholi bisa nasoda fali, do taa. Nai baꞌi Musa susulan tui nae, ai huu anak esa haꞌi naꞌan tehuu taa kade sana. Neme tutuik ia mai, ita bisa bubuluk, tae, hataholi mana matek bisa nasoda fali. Huu nai ndia Manetualain nafada baꞌi Musa nae, ");
INSERT INTO llg_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Au ia, o baꞌi mala Manetualain. Fo ndia baꞌi Abraham, baꞌi Isak, ma baꞌi Yakob. Sila basa sala lakaluku-lakatele lakandondoo henin neu Ndia losa hatematak ia.’ Ita bubuluk, tae, ledoeik Lamatuak kokolak leondiak, na, baꞌi la sila mate sala dook ia so. Tehuu Manetualain nae, Ndia bei dadik neu sila Lamatuan. Huu ndia, de ita bubuluk, tae, sila samanen bei lasoda lakandoo, mae sila mate dook ia so. De mae hataholi mana matek, tehuu ana nasoda fali. Huu kada hataholi kasodak nakaluku-nakatele neu Manetualain, tehuu taa hataholi mana matek hetu?!” ");
INSERT INTO llg_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Lamanene Yesus nanoli leondiak, boe ma hataholi Saduki la taa bisa bala fa boe bali. Tehuu hataholi noꞌu kala sila heran lalan seli de lakokola lae, “Awii! Hataholi ia, nanonolin ana seli maa!” ");
INSERT INTO llg_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ledoeik hataholi Farisi la lamanene, lae, Yesus senggi hataholi Saduki la sila, boe ma lakabubua noꞌu fo sangga latanek lo Ndia. ");
INSERT INTO llg_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Sila malela anggaman esa sangga teꞌek sudik Ndia nae, ");
INSERT INTO llg_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Ama Mesen! Au sangga atane leoiak: ita hada heti-heun, ma anggama palendan nala, noꞌun seli. Neme basa baꞌi Musa palendan ndia mai, na, bee ndia ina-huun ana seli?” ");
INSERT INTO llg_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Boe ma Ana nataa nae, “Palenda manai lain seli nai Manetualain Susula Malalaon ndia, leoiak: ‘Manetualain ndia na ei Manetualaim. De, ei musi sue Ndia lena heni basan. Huu ndia, de ei musi dokodoe Ndia taa-taa, malelak Ndia, ma tao ues mbilu mbuse fo tungga Ndia hihii-nanaun.’ ");
INSERT INTO llg_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Palenda ndia, penting nalan seli ma ana seli! ");
INSERT INTO llg_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ma hambu palenda kaduan, fo nae leoia: ‘O musi sue hataholi feꞌe kala, sama leo o sue o ao-ina hehelim.’ ");
INSERT INTO llg_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Palenda kadua kala ia, ndia huun neme basa baꞌi Musa heti-heun, ma basa Manetualain mana kokolan nala nanonolin basan. Hataholi taa bisa tungga palenda feꞌe kala, mete ma ndia taa tungga nakahuluk palenda kadua ina-huu kala ia.” ");
INSERT INTO llg_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ledoeik hataholi Farisi la sila bei lakabubua lai ndia, boe ma Yesus natane nasafali sala, nae, ");
INSERT INTO llg_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Neme makahulun ele mai Manetualain helu memak so, fo haitua Karistus mai, fo tao nasoda Ndia hataholi nala. Naa, tungga ei duduꞌa mala, na, Karistus ndia, na see numbu-sadun ndia?” Boe ma lataa, lae, “Ndia ndia, mane Dauk numbu-sadun.” ");
INSERT INTO llg_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesus kokolak nakadaik bali, nae, “Mete ma leondiak, na hatina de Manetualain Dula Dale Malalaon nafada mane Dauk, fo noke Karistus ndia, na, ‘Lamatuak’? Huu Dauk sulak nae, ");
INSERT INTO llg_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Manetualain nafada au Lamatuang, nae, “Mai fo manggatuuk muu Au boboa konang, nai mamana nana hadak nalan seli ia. Huu dei fo Au tao o musu mala, leu doꞌok o.’ ” ");
INSERT INTO llg_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Neme susulak ndia mai, ita bisa bubuluk tae, mane Dauk mesa kana noke Karistus ndia, na, ‘Lamatuak.’ De, mete ma hataholi lae, Karistus ndia, kada mane Dauk numbu-sadun, na, ndia bei taa dai! Huu Ndia boe oo, mane Dauk Lamatuan!” ");
INSERT INTO llg_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Lamanene Yesus kokolan leondiak, boe ma hataholi Farisi la sila kada lamanggonggoa kala, huu taa hambu hataholi esa boe bisa nataa Yesus. Huu ndia de, mulai neme faik ndia mai boe, ala bii latanen, ma ala taa lambalani teꞌek sudik Ndia so bali. ");
INSERT INTO llg_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Basa boe ma Yesus nanoli Ndia ana mana tungga nala, sama-sama lo hataholi noꞌu kala fo mana tungga sila. ");
INSERT INTO llg_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Ana nafada nae, mese anggama ma hataholi Farisi la, toꞌu hak fo lanoli baꞌi Musa heti-heu nala. ");
INSERT INTO llg_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Huu ndia de, ei musi mamanene sala ma tungga sila nanonolin. Tehuu boso tungga hata fo ala taon, huu ala taa tao tungga sila nanonoli hehelin. ");
INSERT INTO llg_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ala lakaseti hataholi fo lemba sila heti-heu anggama mabela ndia. Tehuu sila mesa kasa taa nau tulun hataholi la, fo tungga heti-heuk ndia. ");
INSERT INTO llg_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Basa hata fo ala taok ndia, ala tao, fo suek hataholi la koa sala. Conto leo: hata esa fo isin Manetualain Dedeꞌa-kokolan, de ala mbaꞌan neu langga nala, ma lima nala. Tehuu ala boe tao ina-huhuu sila ena nala, suek hataholi la koa sala lae, ‘Wei! Sila ndia, hataholi malalaok, bou!’ ");
INSERT INTO llg_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Mete ma ala maso leni uma huhule-haladoik leu, do ala tungga feta, na, ala lateme sangga mamana nanggatuuk neulauk nalan seli, fo hataholi noꞌu kala lita sala. ");
INSERT INTO llg_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Mete ma ala pasak leu, na sila boe oo, mana mahiik fee sala hadak. Ala sangga fo suek hataholi la doꞌok kasa, lae, ‘Soda-molek, ama mese nana hadak’. ");
INSERT INTO llg_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Tehuu ei boso tungga sila tatao leondian ndia! Hataholi taa bole loke ei, na lae, ‘ama mesen’, huu ei mesem kada esak. Ma ei basa nggei ia, tolanoo kala. ");
INSERT INTO llg_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Boso sosoꞌuk hataholi daebafok, mae, ‘ama’, huu ei Amam nai nusa-sodak kada esak. ");
INSERT INTO llg_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Hataholi boe oo, taa bole loke ei, na, lae, ‘lamatuak’, huu ei Lamatuam kada esak, fo ndia Au ia, fo Manetualain helun neme makahulun mai so, fo haituan mai. ");
INSERT INTO llg_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Huu ndia de, Au ae ei taa bole sosoꞌuk aok sama leo hataholi mana sangga hada kala sila. See neme ei mai nau dadik hataholi ina-huuk, na ana musi dadik leo mana ono-lauk, fo ono-lau hataholi feꞌek. ");
INSERT INTO llg_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Te hataholi mana nau sosoꞌuk aok, dei fo Lamatuak tao natudan. Tehuu hataholi mana tao aon sama leo hataholi kadiꞌik, dei fo Lamatuak soꞌu lai kana.” ");
INSERT INTO llg_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Basa ndia, boe ma Yesus kokolak tuti bali, nae, “Heh, ei mese anggama ma hataholi Farisi la! Memak ei ia, hataholi mana dea-dalek! Dei fo ei hambu soe, huu ei taa mamahele Au, Hataholi fo Manetualain helu memak sangga haituan mai. Ma manggalaun lena bali, ei matabaa mala hataholi mana nau neni Lamatuak palendan mai, fo ala boso lamahele neu Au. ");
INSERT INTO llg_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Heh, ei mese anggama ma hataholi Farisi la! Memak ei ia, hataholi mana dea-dalek! Dei fo ei hambu soe, huu ei mambue masapepeko ina falu la, fo basa na ei mamoa mala uma nala. Tehuu nai hataholi noꞌuk matan, na, ei mafuni ei manggalau nala sila, ma mambadeik hule-haladoi mala dook fo suek hataholi la lae, ei dale mala malalaok. Tehuu dei fo Manetualain huku ei, belak nalan seli. ");
INSERT INTO llg_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Heh, ei mese anggama ma hataholi Farisi la! Memak ei ia, hataholi mana dea-dalek! Neu ko ei hambu soe, huu ei saꞌe ofak sudi bee miu, ma loe-ndaꞌe letek, kada nau sangga hataholi esak, fo ana maso neni ei partei anggamam neu. Tehuu mete ma ana maso so, na, ei tao ndia sodan manggalaun lena bali, losa ana hambu huhukuk nai naraka belan laꞌi dua neme ei mai. ");
INSERT INTO llg_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Wei! Ei dale mala lakatema so, tehuu hatina de ei bei nau matudu dalak neu hataholi feꞌek bali? Dei fo ei hambu soe, huu ei manoli madabak, mae, ‘Mete ma hataholi soꞌuk heheluk nenik soo, ma seseik Uma Ina Huhule-haladoik, na, hataholi ndia taa nanambaꞌak no ndia hehelun ndia. Tehuu mete ma ana soꞌuk heheluk nenik soo, ma seseik bua lilo mbilas manai Uma Ina Huhule-haladoik dalek, na, bei fo ndia nanambaꞌak no hehelun ndia.’ ");
INSERT INTO llg_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ei ia nggoam ana seli! Ei maehetuk Lamatuak tao bua lilo mbilas ndia ina-huun lena, neme Ndia Uma Ina Huhule-haladoin? Taa! Huu Uma ndia tao bua sala sila dadik malalaok! ");
INSERT INTO llg_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ei boe oo, manoli madabak, mae, ‘Mete ma hataholi soꞌuk heheluk nenik soo, ma seseik mei tunu-hotuk manai Uma Ina Huhule-haladoik, na, hataholi ndia taa nanambaꞌak no hehelun ndia. Tehuu mete ma ana soꞌuk heheluk nenik soo, ma seseik tunu-hotuk manai mei ndia, na, bei fo ana nanambaꞌak no heheluk ndia.’ ");
INSERT INTO llg_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ei ia, mboke tebe-tebe so. Neu ko mei tunu-hotuk ndia, ina-huun lena tunu-hotuk manai mei ndia lain. Huu mei ndia, tao nala hataholi bisa fee tunu-hotun neu Manetualain. ");
INSERT INTO llg_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Huu ndia, de, mete ma hataholi soo ma seseik mei tunu-hotuk ndia, na malolenak seseik mei ndia, ma basa hata manai mei ndia lain boe. ");
INSERT INTO llg_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ma mete ma hataholi soo ma seseik Uma Ina Huhule-haladoik, na, malolenak seseik Uma ndia sama-sama no Manetualain naden, huu Ana leo nai ndia. ");
INSERT INTO llg_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ma mete ma hataholi soo fo seseik nusa-sodak, na, ndia ndia sama leo seseik Manetualain kadela palendan, sama-sama no Ndia naden, huu Ndia nanggatuuk toꞌu palenda nai ndia. ");
INSERT INTO llg_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Heh, ei mese anggama ma hataholi Farisi la! Memak ei ia, hataholi mana dea-dalek! Dei fo ei hambu soe, huu ei malelam ana seli mahihinggak fo fee Lamatuak esa neme babaꞌek sanahulu mai. Ei mambue mahinggak basa-basan, losa ei bumbu-fani mala nana selek nai osi dale mai boe oo, ei hinggan. Conto leo ei hingga lutu-lutuk ei daladai, adas makeek, ma jintan. Naa te ei mafalende heni Manetualain heti-heun manai lain nalan seli! Huu ei taa masoda no ndoos. Ei taa sue hataholi kasian nala. Ma ei taa masoda tungga makandoo Lamatuak hihii-nanaun. Malolenak, ei tao basa sila dei, bei fo ei miu hingga ei bumbu-fani mala, fo fee Lamatuak babaꞌen neu. ");
INSERT INTO llg_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ei dale mala lakatema so, tehuu hatina de ei bei nau matudu dalak neu hataholi feꞌek bali? Ei tao heti-heuk losa lutu-lutuk, fo madenu hataholi feꞌe kala tunggan, tehuu Lamatuak heti-heun manai lain nalan seli, ei mesa nggei taa tungga sana. Sama leo ei palisak lutu-lutuk fo seꞌe heni mbena anak neme ei oe nininum mai. Tehuu banda ina-huuk leo kamba, na, ei kodo katema kana! ");
INSERT INTO llg_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Heh, ei mese anggama ma hataholi Farisi la! Memak ei ia, hataholi mana dea-dalek! Dei fo ei hambu soe, huu ei safe mala ei pingga-manggo mala losa langgahado, tehuu ndia kada dea nala. Naa te, dalek manggenggeo ndoos neme ei mamoam ma ei nasambambambok mai. ");
INSERT INTO llg_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Weih! Hataholi Farisi mboke kala aa! Safe makahuluk ei pingga-manggo mala dale nala! No leondiak, na, babaꞌe deak boe oo, bisa dadik malalaok! ");
INSERT INTO llg_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Heh, ei mese anggama ma hataholi Farisi la! Memak ei ia, hataholi mana dea-dalek! Dei fo ei hambu soe, huu ei ia sama leo lates nana dama fulak. Hataholi nita deak, lolen ana seli. Tehuu dalek, henuk no mana mate kala dui-loun, ma basa kaboo mbuluk. ");
INSERT INTO llg_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ei boe oo, sama! Ei mahiik tao aok nonook leo hataholi malalaok. Nai deak na, hataholi nita ei, sama leo hataholi dale ndoos. Naa te ei dale mala, henuk no dedeꞌa manggalauk. Huu ei kokolak feꞌek, ma tao feꞌek, ma mafalende heni Manetualain palenda nala. ");
INSERT INTO llg_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Heh, ei mese anggama ma hataholi Farisi la! Memak ei ia, hataholi mana dea-dalek! Dei fo ei hambu soe! Ei tao late ina-huu kala fee Manetualain mana kokola nala, ma heu malole hataholi neulau kala late nala. ");
INSERT INTO llg_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Tehuu ei mae, ‘Leo ita tasoda lelek esa to ita bei-baꞌi nala, na, neu ko ita taa tungga tao tisa Manetualain mana kokola nala.’ ");
INSERT INTO llg_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","No leondiak, ei malengga seluk ei dedeꞌa kafunik heheli mala, mae, ei ndia boe manggalaun sama leo ei bei-baꞌim mala. ");
INSERT INTO llg_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","De, malolenak, ei tao manggalauk leondiak losa mateꞌen, tungga ei bei-baꞌim sala nala! ");
INSERT INTO llg_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ei ia tebe-tebe manggalaum sama leo mengge kalasok. Ei maehetuk Manetualain taa huku ei? Boso mamahena! Neu ko Ana mbia heni ei mini haꞌi naraka dale miu! ");
INSERT INTO llg_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Mamanene baa! Dei fo Au haitua fee ei Au nadedenu nggala, fo lanoli ma latudu ei Lamatuak dala soda ndoon. Tehuu dei fo ei tao misa luma, ma mbaku misa luma leu ai ngganggek. Hambu luma, ei filo sala lai uma huhule-haladoi kala, ma hambu ei tao doidoso luma, losa ala lalai leme kota esa, leni kota feꞌek leu. ");
INSERT INTO llg_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Makahulun ele, ei bei-baꞌim tao lisa Habel. Naa te ndia ndia, hataholi dale ndoos. Ei bei-baꞌim mala lambue tao lisa lakandondoo henin hataholi dale ndoos sala neme numbu-saduk esa mai neni numbu-saduk esa neu. Losa Zakarias, fo Barakia anan. Ala tao lisan neme Uma Ina Huhule-haladoik pasan fo dekak no mei tunu-hotuk. Huu ei tungga ei bei-baꞌim mala manggalaun ndia, de, ei musi tanggon basa hataholi ndoos sala sila daa nala. ");
INSERT INTO llg_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Memak tetebes! Tehuu ei fo hatematak ia, dei fo nana hukuk, huu dedeꞌa manggalauk kala fo ei bei-baꞌim mala taon neme makahulun ndia mai.” ");
INSERT INTO llg_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Wei hataholi Yerusalem aa! Ei ia, mambue tao misa Manetualain mana kokola nala, ma mbia misa nadedenu kala mana nau mai tulu-fali ei. Au ambue kokoe ei taa-taa fo mini Au mai, sama leo manu ina nasulu nala ana nala neu lidan dale. Tehuu ei taa nau. ");
INSERT INTO llg_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Huu ndia, de Lamatuak taa mbali ei umam so. Boe ma mbila-binesak, louk so. ");
INSERT INTO llg_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Mamanene neulalau baa! Huu ei taa mita Au bali, losa neu fain ei manaku mae, ‘Ai moke fo Manetualain fee babaꞌe-babatik neu Hataholi ia, huu Lamatuak haitua Ndia.’ Ei manaku leondiak, bei fo ei mita Au bali.” ");
INSERT INTO llg_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Basa ndia, boe ma Yesus sangga laꞌo ela Uma Ina Huhule-haladoik. Ledoeik Ana kalua, boe ma Ndia ana mana tungga nala latudu Uma Ina Huhule-haladoik malolen. ");
INSERT INTO llg_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Tehuu Ana nataa nae, “Uma ia memak malole! Tehuu mamanene baa! Taa dook bali, ala tao latuꞌu heni basa batu nala ia.” ");
INSERT INTO llg_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Basa de, Yesus ndaꞌe neu nanggatuuk nai lete Setun. Boe ma ana mana tungga nala mai lakokola lo Ndia mesa kana, lae, “Ama! Hena mafada seluk Ama kokolam isinaak ndia. Meda Ama fafali main ndia, laꞌeneu fai hida bae? Ma ndia tanda nala, meda leo hata? Talobee boe no daebafok babasan?” ");
INSERT INTO llg_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Basa boe ma Yesus nataa, nae, “Manea matalolole aok baa! Fo ei boso nana kedi nalak. ");
INSERT INTO llg_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Huu dei fo hataholi mata-mata kala mai fo babamba kalak, lae, ‘Au ia Karistus, Hataholi fo Manetualain heluk ndia so neme makahulun mai.’ No leondiak, ala kedi lala hataholi noꞌuk. ");
INSERT INTO llg_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mete ma ei mita hataholi latati, do ei mamanene, lae, hambu natatik sudi nai bee, na, ei boso bii. Huu dedeꞌa leondiak ndia, musi dadi dei. Tehuu daebafok fai babasan bei taa losa. ");
INSERT INTO llg_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Dei fo leo esa natati no leo feꞌek. Nusak esa natati laban nusa feꞌek. Hambu dae nanggeꞌo sudi nai bee. Ma fai ndoen boe napadaka nalan seli! ");
INSERT INTO llg_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Tehuu basa sila, bei fo tanda makasososak fo nafada, nae, daebafok fai babasan deka-deka mai so. Ndia sama leo inak bei fo nameda tein hedis, huu ndia fai bobonggin dekak so. ");
INSERT INTO llg_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","De, ei musi manea matalolole aok baa! Huu dei fo ala tao doidoso ma tao lisa ei. Ma hataholi leme basa nusa kala dei fo husembuluk lalan seli neu ei, huu ei tungga Au. ");
INSERT INTO llg_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Faik ndia, hataholi noꞌu kala heok lasadea ma taa nau lamahele Au bali. Ala lahusembuluk, ma laseꞌok esa no esa. ");
INSERT INTO llg_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Dei fo masapepeko kala lae sila ndia, Lamatuak mana kokola nala. De hataholi noꞌu kala lamahele sala. ");
INSERT INTO llg_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Dei fo hataholi manggalaun nala tamba faik, na, tamba lamanoꞌu, losa hataholi taa lasueao esa no esa bali. ");
INSERT INTO llg_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Tehuu hataholi mana nakatataka nakandoo losa maten, na, neu ko Manetualain tao nasodan. ");
INSERT INTO llg_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Huu hataholi musi tui-bengga Manetualain Hala Malolen, losa daebafok buꞌu nala, fo suek basa hataholi bisa bubuluk Lamatuak dala soda ndoon. Basa ndia, bei fo daebafok fai babasan mai.” ");
INSERT INTO llg_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Yesus kokolak nakandoo, nae, “Manetualain mana kokolan Daniel sulak so, laꞌeneu hataholi esa manggalaun ana seli. Ana maso mai, fo nambadeik neu mamana lulik, nai Manetualain Uma Ina Huhule-haladoin. No leondiak, ana tao nanggenggeo mamanak ndia. Huu ndia, de, Manetualain heok nasadea, laꞌo ela mamanak ndia. Mete ma ei mita leondiak so, na, mata neuk leo baa! (See les susulak ia, na, musi bubuluk neulalau!) ");
INSERT INTO llg_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Huu ndia dadik tanda, nae, fai-fai toꞌa-taak nai lelesu matan so. Mete ma mita leondiak so, na, hataholi manai propinsi Yudea, foꞌa malai mini letek miu leo. ");
INSERT INTO llg_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Mete ma hambu hataholi kalua neme uman mai, na, boso fali miu haꞌi buas bali. Malai lai-lai leo, fo suek boso hambu soe. ");
INSERT INTO llg_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Hataholi manai osi, na, boso fali fo haꞌi sidi nalusek bali. Malai makandoo leo! ");
INSERT INTO llg_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Nana kasian nalan seli neu ina kailus, ma ina kala mana masusu ana mbimbilanak. Huu ala taa bisa lalaik latingga. ");
INSERT INTO llg_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","De, malolenak ei hule-haladoi fo soe ndia taa mai laꞌeneu oefak, do mai laꞌeneu fai hahae tao ues. ");
INSERT INTO llg_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Huu faik ndia totoꞌan ana seli! Mulai neme Manetualain nakadadadik daebafok ia, losa hatematak ia, hataholi bei taa latonggo lo totoꞌa ina-huuk matak leondiak. ");
INSERT INTO llg_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Tehuu ei maua-manale malan seli, huu Manetualain tao kekeꞌu faik ndia. Mete ma taa, na, taa hambu hataholi esa boe nakatataka nasoda. Huu Manetualain sue Ndia hataholi nala fo Ana hele nala kala, de Ana tao kekeꞌu fai-fai totoꞌa kala sila. ");
INSERT INTO llg_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Dei fo mete ma faik ndia losa so, na, ei mamanene hataholi nae, ‘Mita dei! Karistus nai ia!’ Ma hataholi feꞌek lae, ‘Karistus nai ele!’ Tehuu ei boso mamahele baa! ");
INSERT INTO llg_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Huu dei fo hambu hataholi kalua fo babamba kalak, nae, ‘Au ia, Karistus!’ Ma feꞌe kala bali lae, ‘Au ia, Manetualain mana kokolan.’ Dei fo ala tao tanda heran mata-mata kala pake nitu koasan, fo pepeko hataholi. Ala soba-soba fo suek Manetualain hataholi nala nana kedi nalak! ");
INSERT INTO llg_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","De, ei musi manea neulalau aok baa! Fai-fai totoꞌak ndia bei taa losa, tehuu Au asanenedak memak ei baa! ");
INSERT INTO llg_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Mete ma hataholi nafada ei, nae, ‘Karistus nai mook ele!’ na, ei boso mini ele miu. Ma mete ma hambu nae, ‘Karistus nai uma ia dalek!’, na, ei boso mamahele sila pepeko nala ndia. ");
INSERT INTO llg_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Huu, Au ia, Hataholi Isi-isik. Dei fo Au fali uni daebafok ia mai, na, basa hataholi la lita Au, sama leo hataholi lita mahadok nasaꞌa nai ledo sasadun neni ledo tetesan neu. ");
INSERT INTO llg_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Mete ma Au fali maing, dei fo ei bubuluk Au nai bee. Sama leo hataholi bubuluk, nae, mete ma mbui manaꞌa mbombola kamates, lakabubua lai mamanak esa, na, neu ko hambu mbombola kamates nai ndia.” ");
INSERT INTO llg_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Basa de Yesus tuti bali, fo nafada Ndia ana mana tungga nala, nae, “Mete ma fai-fai totoꞌa kala sila lateꞌe, Dei fo ledo makiu, bulak boe taa nasaꞌa so bali. Nduu kala latuda kala leme lalai mai, ma basa koasa lalai lapoka kala.’ ");
INSERT INTO llg_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Basa ndia, boe ma basa hataholi lita tanda nai lalai, lae, Hataholi Isi-isik sangga fali main. Lita leondiak, boe ma basa hataholi nusa kala malai daebafok ia ala bii, losa lamatani. Huu, dei fo Au konda mai ua koꞌas, bei fo ala lita Au koasang, ma basa Au ana seling. ");
INSERT INTO llg_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Basa de, Au pake lii toꞌik lii ina-huuk, boe ma Au palenda Manetualain ata nala malai nusa-sodak, fo leu lakabubua lala basa hataholi fo Au hele ala kala leme basa daebafok buꞌu nala, neme ledo sasadu main losa ledo tetesa neu; neme kii mai losa kona.” ");
INSERT INTO llg_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Au haꞌi conto leo ai huuk. Mete ma doon mulai kuni, na, ndia tanda, nae, fai hanan deka-deka mai so. ");
INSERT INTO llg_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Leondiak boe, mete ma ei mita fai-fai toꞌa-taak mai so, sama leo Au afada ei isinaak ndia so, na, ndia tanda, nae, Au deka-deka mai so. ");
INSERT INTO llg_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Hatematak ia, mamanene neulalau! Neme basa hataholi bei kasodak hatematak ia, dei fo hambu bei taa maten, naa te fai-fai toꞌa-taa kala mai so. ");
INSERT INTO llg_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Mae lalai ma daebafok mopo heni sala, tehuu Au dedeꞌa-kokolang ia, lahele lakandoo taa no mana basak.” ");
INSERT INTO llg_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Taa hambu hataholi bubuluk faik bee ndia, Au fali maing. Manetualain ata nala malai nusa-sodak boe oo, taa bubuluk, ma Au boe oo, taa bubuluk. Kada Au Amang mesa kana bubuluk. ");
INSERT INTO llg_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Huu Au ia, Hataholi Isi-isik. Dei fo mete ma Au fali maing, na, ndia sama leo makahulun ele, faik fo Noh bei nasoda. ");
INSERT INTO llg_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Faa tuak ndia bei taa mai, tehuu hataholi la laꞌa-linu neulalau, ma lasaok noꞌu, sama leo basa faik. Ala tao leondiak lakandondoo henin, losa Noh maso neni ofa ina-huuk ndia dalek neu. ");
INSERT INTO llg_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Tehuu ledoeik faa tuak mai sapu heni basa sala, bei fo mata nala lalaak, fo bubuluk hata mana dadik ndia so. Leondiak boe, dei fo no Au mamaing. ");
INSERT INTO llg_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Faik ndia, mete ma hataholi dua tao ues lai osi dale, na, kada nggengge neuk Manetualain soꞌu nala esa ma feꞌek Ana elan. ");
INSERT INTO llg_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Mete ma inak dua mbau hade, na, nggengge neuk Manetualain soꞌu nala esa ma Ana ela feꞌek. ");
INSERT INTO llg_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Huu ndia, de, ei musi manea leledo-leꞌodaen, huu ei taa bubuluk fai hida ei Lamatuam fali main. ");
INSERT INTO llg_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Duduꞌa neulalau baa! Mete ma maumak bubuluk leꞌodae naꞌo sangga mai, na, neu ko ana nanea nakandoo, fo suek naꞌo boso maso neni uman neu. ");
INSERT INTO llg_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Huu ndia, de, ei musi mahehele. Huu Au fafali maing ndia, kada kaiboik.” ");
INSERT INTO llg_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Basa de Yesus kokolak nakadaik bali, nae, “Ei musi dadik sama leo nana nadedenuk fo tungga nakandondoo henin ndia malanggan hihii-nanaun. Huu, mete ma malanggan neni dae dook neu, na, ana soꞌu nala nana dedenu matak leondiak, suek nakaneni basa ndia uma isin nanaꞌa-nininu nala. ");
INSERT INTO llg_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Mete ma malanggan fali, fo nita ndia nana nadedenun tao ues neulauk, na, neu ko ana sue hataholi ndia. ");
INSERT INTO llg_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Mamahele Au, huu dei fo malanggan ndia, fee nana nadedenuk ndia koasa fo nakaneni basa ndia hata-heto nala. ");
INSERT INTO llg_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Tehuu mete ma nana nadedenuk ndia manggalauk, na, neu ko ana kokolak nai dalen, nae, ");
INSERT INTO llg_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","‘Malole! Malanggang laꞌo so, de see bubuluk nae fai hida ana fali bae!’ Ana duduꞌa leondiak, boe ma ana mulai mbomboko ndia nonoo mana tao ues feꞌe nala. Ma ana nanggatuuk naꞌa-ninu neulalau noꞌu no mana mafu kala. ");
INSERT INTO llg_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Tehuu taa bubuluk, naa te kaiboik ndia malanggan fali. ");
INSERT INTO llg_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Boe ma malanggan ndia huku nalan seli, de ana mbia henin deak neu, fo ana leo no hataholi mana dea-dale kala sila. Nai mamanak ndia, basa sala lamatani, huu ala doidoso lalan seli.” ");
INSERT INTO llg_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Basa ndia boe ma, Yesus tuti Ndia kokolan laꞌeneu Manetualain palendan nae, “Ei musi mahehele fo soluk Au fafali maing, sama leo nakandandaak ia. Leoiak: laꞌi esa inanak sanahulu kalua leꞌodaek ma leni bandu anak, fo soluk mana kabin touk, nai sila nonoon uman. ");
INSERT INTO llg_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Tehuu neme hataholi kasanahulu kala sila, lima nggoak, ma lima malelak. ");
INSERT INTO llg_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Kalima nggoa kala, lafalende heni leni mina lenak. ");
INSERT INTO llg_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Tehuu kalima malela kala, leni memak. ");
INSERT INTO llg_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Losa uma ndia, tehuu tou mana kabin bei taa no mamain boe. Dook boe ma inana kala mata nala nduak, de ala sunggu lamanee. ");
INSERT INTO llg_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Naa te, neu fatilada, boe ma lamanene hataholi la eki, lae, ‘Wei! Tou mana kabin mai so! Mai teu solu kana leo!’ ");
INSERT INTO llg_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Lamanene leondiak, boe ma inana kala sila foꞌa noꞌu. Basa de ala lahehele sila bandu ana nala. ");
INSERT INTO llg_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Tehuu inana nggoa kala kokolak lo sila nonoo nala, lae, ‘Wei, tolanoo nggalei! Tulun baꞌe fee ai mina fa dei, huu ai bandu nala sangga mate sala ia so!’ ");
INSERT INTO llg_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Tehuu inana malela kala sila lataa, lae, ‘Awii! Boso mamanasa, tehuu taa bisa bae maa. Huu ai minan taa dai neu ita basa nggata! Malolenak kada ei miu hasa mina nai kios leo.’ ");
INSERT INTO llg_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Boe ma leu hasa mina. Tehuu ledoeik ala kalua, boe ma tou mana kabin ndia losa so. Boe ma, inana malela kala sila maso tungga leni mamana feta leu, sama-sama lo mana kabin ma basa nana hoka kala. Sila basa sala maso leni uma dale leu, boe ma hataholi kena lelesu. ");
INSERT INTO llg_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Basa de, inana nggoa kala sila mai. Ala langgou kokoe, lae, ‘Ama! Ama aa! Tulun soi lelesu dei!’ ");
INSERT INTO llg_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Tehuu ana nataa nae, ‘Weih, taa bisa bou. Huu au taa alelak ei!’ ");
INSERT INTO llg_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Huu ndia, de ei musi mahehele fo manea makandondoo henin, huu ei boe oo, taa bubuluk Au mamaing, laꞌeneu fai hida, do liꞌu hida.” ");
INSERT INTO llg_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Basa de Yesus tuti nakandandaak esa bali, nae, “Mete ma Au laꞌo ela ei so, na, ei musi tao ues neulalau soaneu Au, sama leo nakandandak ia. Leoiak: malanggan esa sangga neni nusa dook neu. Faik fo ana nahehele sangga laꞌo, boe ma noke nala ana nadedenu nala, de ana palenda sala nae, ‘Ei pake doik ia dadik neu poko. Mete ma au fali, na ei musi mafada au, ei hambu bunak baꞌubee.’ ");
INSERT INTO llg_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Boe ma ana fee ndia ana nadedenu makasososan doi lilo mbilas alukosu lima, fo ana nakabubunak doi kala sila. Boe ma ana fee ana nadedenu kaduan, doik alukosu dua, ma ana nadedenu katelun doik alukosu esa, tungga sila esa-esak nabebeꞌin. Basa de ana neni dook neu. ");
INSERT INTO llg_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Simbo lala doi kala sila, boe ma nana dedenu kaesan kalua tutik fo neu danggan. Taa dook boe ma ana hambu bunan doik alukosu lima bali. ");
INSERT INTO llg_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Leondiak no nadedenu kaduan. Ana hambu bunak doik alukosu dua bali. ");
INSERT INTO llg_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Tehuu nadedenu katelun fo mana simbo doik alukosu esa ndia, neu kali bolok, de nafuni malanggan doin ndia. ");
INSERT INTO llg_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Dook boe ma, bei fo malanggan ndia mai. De nakabubua nala ndia ana nadedenun nala fo mulai palisak ndia doi nala fo ala lakanenik sila. ");
INSERT INTO llg_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Nana dedenu kaesan maso de ana fee doik alukosu sanahulu, boe ma nae, ‘Ama! Ia ama doin. Fain ama fee au doik alukosu lima. Tehuu hatematak ia, au hambu bunak alukosu lima bali.’ ");
INSERT INTO llg_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","No leondiak, de malanggan namahoko. Ana nafada nae, ‘Malole! O ia, nadedenu neulauk. O tao ues no manggatek so, ma o tungga makandondoo heni au palendang, mae au taa nai ia. Huu o bisa makaneni dedeꞌa kadiꞌi leoiak, de dei fo au soꞌu ala o fo makaneni dedeꞌa ina-huuk bali. Dei fo au tao feta fo ita basa nggata tamahoko takasoe.’ ");
INSERT INTO llg_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Basa boe ma, ana nadedenu kaduan mai, de fee ndia malanggan doik alukosu haa, ma nae, ‘Ama! Makahulun ama fee au, doik alukosu dua. Kada mete aom, huu au hambu bunak doik alukosu dua bali.’ ");
INSERT INTO llg_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Boe ma malanggan ndia namahoko. Ana nafada nae, ‘Malole! O ia boe, nadedenu malole. O manggate tao ues so, ma o tungga makandondoo heni au palendang, mae au taa nai ia. Huu o bisa makaneni dedeꞌa kadiꞌi leoiak, de, dei fo au soꞌu ala o makaneni dedeꞌa ina-huuk lena bali. Dei fo au tao feta fo ita basa nggata tamahoko takasoe.’ ");
INSERT INTO llg_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Basa de, nadedenuk katelun mai. Boe ma nafada nae, ‘Ama aa! Au bubuluk ama ia hataholi dale makababatuk. Huu ama haꞌi mala hata fo hataholi feꞌek taon, ma ketu mala hata fo hataholi feꞌek selen. ");
INSERT INTO llg_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Au bii, boso losak doi kala ia mopo heni sala, fo ama huku au. Huu ndia, de, au afuni neulalaun. Ia ama! Mala fali kana huu ama doin alukosu esa ia bei sodak! ");
INSERT INTO llg_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Namanene leondiak, boe ma malanggan ndia nasapala kana, nae, ‘O ia nadedenu manggalauk, ma mbelatuam ana seli! Mete ma o bubuluk so, mae, au haꞌi ala hata fo hataholi feꞌek taon, ma seu ala hata fo hataholi feꞌek selen, ");
INSERT INTO llg_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","na, hatina de o taa muu mbeda au doing neu bank leo? Fo suek au fali, na, au hambu bunan, mae kada faak boe oo, malole ndia!’ ");
INSERT INTO llg_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Basa de, malanggan ndia nadenu hataholi nadedenu feꞌe nala, nae, ‘Haꞌi mala ndia doin, fo feen neu nadedenuk fo mana hambu bunak doik alukosu kalimak ndia. ");
INSERT INTO llg_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Huu hataholi mana makaneni no malole, hata fo ana toꞌun, dei fo ana hambu noꞌuk bali. Tehuu hataholi fo taa nau nakaneni hata fo ana toꞌun ndia, dei fo ala haꞌi lala basan neme ndia mai. ");
INSERT INTO llg_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Humu mala nadedenuk fo sosoan taa hata esa boe ndia. Hela loloson fo mbia henin deak neu. Elan namatani ma doidoso nai mamana makiuk ele!’ ” ");
INSERT INTO llg_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Basa boe ma Yesus kokolak nakandoo, nae, “Au Hataholi Isi-isik ia, dei fo konda mai pake Au Amang koasan fo ana seli ndia, sama-sama ua Ndia ata nusa-sodan nala. Boe ma Au anggatuuk nai Au kadela mana palendang fo ana seli ndia, fo palisak basa hataholi la sodan nala. ");
INSERT INTO llg_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Dei fo basa hataholi fo mana masoda nitak nai daebafok, ala mai lasale Au. Basa na, Au tada kofeꞌe kasa, sama leo mana hoo tada kofeꞌe biꞌilombo neme biꞌiaek mai, fo dadik bubuak dua. ");
INSERT INTO llg_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Hataholi mana tao tungga Manetualain hihii-nanaun, Au tao sala leu Au boboa konang. Tehuu feꞌe kala, Au tao sala leu Au boboa kiing. ");
INSERT INTO llg_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Faik ndia, Au toꞌu palenda sama leo manek. Dei fo Au afada hataholi la malai Au boboa konang, ae, ‘Ei ia mana simbo babaꞌe-babatik neme Au Amang mai. Mai fo maso mini Ndia uman dale miu, fo nana sadia memak neme sososan mai neu ei. ");
INSERT INTO llg_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Au hoka ei, huu makahulun ledoeik Au ndoe, ei ndia fee Au uꞌa. Ledoeik Au maa mada, ei ndia fee Au inu. Au mai sama leo hataholi nusa dea, tehuu ei simbok Au nai ei uma mala. ");
INSERT INTO llg_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Au baloꞌa papakeng taa, tehuu ei fee Au baloꞌa papakek. Au amahedi, tehuu ei mai makaneni Au. Au nai bui dale, tehuu ei mai tilo Au.’ ");
INSERT INTO llg_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Lamanene leondiak, dei fo hataholi dale ndoos sala malai Au boboa konang ndia, lataa lasafali, lae, ‘Lamatuak aa, ia talobee ia so? Lamatuak nae, Lamatuak ndoe, na ai feen naꞌa. Lamatuak maa mada, na, ai feen ninu. ");
INSERT INTO llg_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Lamatuak sama leo hataholi nusa dea, boe ma ai simbo kana maso nai ai uma nala. Lamatuak baloꞌa papaken taa, na, ai feen. ");
INSERT INTO llg_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Lamatuak namahedi na, ai miu makanenin. Lamatuak nai bui dale, boe ma ai miu tulu-falin. Tehuu fai hidak ai tao dedeꞌa leondiak?’ ");
INSERT INTO llg_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Dei fo Au ataa sala, ae, ‘Mamahele neu Au! Huu ledoeik ei tao dedeꞌa leondiak neu Au hataholing nggala, mae tao neu hataholi papake taa kala boe oo, na, ndia ei tao neu Au ndia so!’ ");
INSERT INTO llg_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Boe ma Au afada hataholi la malai Au boboa kiing, ae, ‘Heh! Hataholi manggalauk kala! Manetualain sumba-soo ei so. Boke malai heok ia! Dei fo Au adenu hataholi mbia ei mini haꞌi naraka mbila taa mana basak miu. Huu Manetualain sadia mamana doidosok ndia so, neu nitu la, ma sila malangga ina-huun. ");
INSERT INTO llg_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Au husi heni ei, huu ledoeik Au ndoe, ei taa fee Au uꞌa. Ledoeik Au maa mada, ei taa fee Au inu. ");
INSERT INTO llg_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Au mai sama leo hataholi nusa dea, tehuu ei taa simbok Au nai ei uma mala. Au baloꞌa papakeng taa, tehuu ei taa fee Au baloꞌa papakek. Au amahedi, tehuu ei taa mai makaneni Au. Au nai bui dale, tehuu ei taa tulu-fali Au.’ ");
INSERT INTO llg_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Lamanene leondiak, dei fo hataholi manggalauk kala sila lataa, lae, ‘Lamatuak, talobee ia so? Lamatuak nae Lamatuak ndoe, tehuu ai taa fee O muꞌa. Lamatuak maa mada, tehuu ai taa fee minu. Lamatuak sama leo hataholi nusa dea, tehuu ai taa simbok O nai ai uman. Lamatuak baloꞌa papaken taa, tehuu ai taa fee O. Lamatuak namahedi, tehuu ai taa makaneni. Lamatuak nai bui dale, tehuu ai taa miu tulu-fali. Tehuu fai hidak, ai tao leondiak neu Lamatuak?’ ");
INSERT INTO llg_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Dei fo Au ataa sala ae, ‘Mamahele Au! Huu faik ei taa tulu-fali hataholi papake taa kala, na, ndia sama leo ei taa tulu-fali Au.’ ");
INSERT INTO llg_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Basa boe ma hataholi manggalauk kala sila hambu doidosok lakandondoo henin losa dodoon neu. Tehuu hataholi dale ndoos sala sila, hambu sodak lakandondoo henin lo Lamatuak losa dodoon neu.” ");
INSERT INTO llg_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ledoeik Yesus nanoli nateꞌe basa dedeꞌak neu sala, boe ma nafada Ndia ana mana tungga nala, nae, ");
INSERT INTO llg_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Ei bubuluk so, dei fo faik dua bali fo ita fai malolen, fo ndia Feta Paska. Faik ndia, dei fo hambu hataholi seꞌo heni Au, Hataholi Isi-isik ia. Basa de ala mbaku lisa Au, nai ai ngganggek.” ");
INSERT INTO llg_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Faik ndia, malangga anggama Yahudi la malangga nala, ma lasi-lasi hada kala lakabubua lai Kayafas uman. Kayafas ndia, na ndia, malangga anggama Yahudi la Malangga Ina-huun. ");
INSERT INTO llg_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ala lasanggak dalak, fo sangga humu Yesus no neneek, fo tao lisan. ");
INSERT INTO llg_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Tehuu ala heti dalak, lae, “Tataak dei! Ita boso humun lai-lai, huu fai-fai malole dekak so. Boso losak hataholi noꞌuk fo mana mahiik Ndia, ala tao nahuuk.” ");
INSERT INTO llg_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Nai nggolo Betania, hambu hataholi esa, nade Simon. Makahulun, hataholi la nunuten, huu ana hambu hedi kusta. Tehuu hatematak ia, ana hai so. Faik ndia fai malole bei taa losa, de Yesus asa leu laꞌa lai Simon uman. ");
INSERT INTO llg_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ledoeik ala laꞌa, boe ma inak esa mai natonggo no Yesus. Ana toꞌu boto esa, nana taok neme batu mabeli mai. Boto ndia isin mina kaboo meni, fo belin ana seli. Boe ma inak ndia, femba natepa boto ndia tatanan. Boe ma ana diꞌa didilo mina ndia fa-fa neu Yesus langgan, fo dadik tanda ana fee hadak neu Ndia. ");
INSERT INTO llg_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Tehuu ledoeik Yesus ana mana tungga nala lita inak ndia tao leondiak, boe ma ala luli, de lakokola lae, “Leo, ana boso ngganggali heni mina mabeli nalan seli ndia no sosoa taak! ");
INSERT INTO llg_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Malolenak ana seꞌo heni mina ndia leo! Fo suek doin, babaꞌe sala leu hataholi mana toꞌa-taa kala!” ");
INSERT INTO llg_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Tehuu Yesus bubuluk sila duduꞌa nala ndia, de Ana kokolak, nae, “Ei taa bole tao makatotoꞌak inak ia! Elan neme naa! Au amahoko, huu ana diꞌa mina neu Au aong. ");
INSERT INTO llg_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Huu hataholi mana toꞌa-taa kala lai ei lalada mala taa-taa. Tehuu taa dook so, Au ia, taa sama-sama ua ei. ");
INSERT INTO llg_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ma inak ia, diꞌa mina ia, na, nahehele Au aong sama leo ana ngganggali memak bungga neu Au mbombolang. ");
INSERT INTO llg_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Masaneda neulalau baa! Sudi nai bee mesan fo Manetualain Tutui Malolen ia nana tui-benggak ndule daebafok ia, sila boe oo neu ko tui inak ia malolen! Fo suek basa hataholi la lasanedan.” ");
INSERT INTO llg_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Hataholi esa neme Yesus ana mana tungga kasanahulu dua nala, nade Yudas Iskariot. Faik ndia boe, ana kalua neu sangga malangga anggama Yahudi la malangga nala, fo sangga fee Yesus neu sila liman. ");
INSERT INTO llg_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Losa sila, boe ma ana natane, nae, “Ama nggalei! Mete ma au tulun humu Yesus ndia, na, ei fee au hata?” Boe ma lataa lae, “Mete ma o nau seꞌo heni Ndia neu ai, na, ai bae.” Boe ma ala hingga lala doi lilo fulak telu hulu de feen neu Yudas. ");
INSERT INTO llg_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Basa ndia, boe ma Yudas kalua, de ana mulai sangga dalak fo sangga fee Yesus neu sala. ");
INSERT INTO llg_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Tungga-tungga teuk, hataholi Yahudi la fai-fai malole nala doon faik hitu. Ala loke lae fai malole ndia, nade ‘Feta Loti Lepa’. Faik ndia feta sangga mulai so, de Yesus ana mana tungga nala latane Ndia, lae, “Ama! Leꞌodaen ia ita mulai ita fai-fai malolen. De, Ama nau ai miu hala biꞌilombo, ma sadia mamanak feta Paska nai bee?” ");
INSERT INTO llg_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Boe ma Ana nataa, nae, “Ei maso kota miu, dei fo ei matonggo mia touk esa. Mafadan mae leoia: ‘Kaꞌa aa! Ama Mese nameda taa dook so bali Ana mate. De, Ana noke mamanak nai kaꞌa uman, fo Ana paken tao feta Paska no Ndia ana mana tungga nala.’ ” ");
INSERT INTO llg_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Lamanene leondiak, boe ma Ndia ana mana tungga nala leu tao tungga Ndia kokolan ndia. Boe ma ala sadia laꞌa feta Paska nai ndia. ");
INSERT INTO llg_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Leꞌodae boe ma Yesus no Ndia ana mana tungga kasanahulu dua nala langgatuuk laꞌa feta. ");
INSERT INTO llg_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ledoeik ala laꞌa, boe ma Ana kokolak nae, “Ei mamanene baa! Hambu hataholi esa neme ei mai, dei fo seꞌo heni Au uni hataholi feꞌe kala uu.” ");
INSERT INTO llg_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Lamanene leondiak, boe ma lameda taa malole. Boe ma sila esa-esak natane Yesus, nae, “Hataholi fo Ama kokolak ndia, taa ndia Au hetu?” ");
INSERT INTO llg_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Boe ma Yesus nataa nae, “Hataholi mana bolo lotin neni manggo ia sama-sama no Au, ndia ndia seꞌo heni Au. ");
INSERT INTO llg_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Masanenedak baa! Au, Hataholi Isi-isik ia, musi mate sama leo nana sulak memak so nai Manetualain Susula Malalaon. Tehuu, mata neuk! Huu hataholi mana sangga seꞌo heni Au ndia, dei fo ana hambu soe! Malolenak mete ma inan taa bonggin!” ");
INSERT INTO llg_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Basa ndia, boe ma Yudas boe natane tungga, nae, “Neu ko hataholi fo Ama kokolak ndia, taa ndia au hetu?” Boe ma Yesus nataa, nae, “Memak o mesa nggo mae leondia. Tehuu, see bali?” ");
INSERT INTO llg_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ledoeik bei laꞌa, boe ma Yesus soꞌu nala loti balok esa, de noke makasi neu Manetualain. Basa de Ana bibiꞌi-babaꞌe loti ndia, boe ma Ana loon neu Ndia ana mana tungga nala, ma nafada nae, “Loti ia, na, Au aong ndindia. Ei haꞌi malan fo miꞌa leo!” ");
INSERT INTO llg_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Basa ndia, boe ma Ana haꞌi nala nggalaas esa henuk no anggol oek, de noke makasi neu Manetualain. Basa de, Ana loon neu ana mana tungga nala, ma nafada nae, “Ei basa nggei haꞌi malan fo minu. ");
INSERT INTO llg_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Huu anggol oek ia, na, Au daang ndindia. Dei fo Au mate, na, Au daang faa, fo tao nasoda hataholi noꞌu kala leme sala-singgo nala mai. Daak ia dadik neu buti, fo tao nasanenedak, nae, hata fo Manetualain heluk ndia, memak hatematak ia ana dadi so. Haꞌi malan fo minu leo! ");
INSERT INTO llg_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Tehuu mamanene neulalau! Mulai neme leꞌodaen ia mai, Au taa inu anggol oek so bali. Dei fo mete ma Au ma Au Amang nai nusa-sodak nanggatuuk toꞌu palenda, bei fo Au inu bali ua ei.” ");
INSERT INTO llg_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Basa boe ma, ala soda sosodak esa, fo koa-kio Manetualain. Boe ma leꞌodaen ndia boe, ala kalua leni lete Setun leu. ");
INSERT INTO llg_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ledoeik ala belaꞌo, boe ma Yesus nafada memak Ndia ana mana tungga nala, nae, “Dei fo leꞌodaen ia, ei basa nggei malai laꞌo ela Au. Huu ala sula memak nai Manetualain Susula Malalaon, lae, ‘Dei fo Manetualain tao nisa manahoo, Basa na, ndia biꞌilombo nala latanggelak.’ ");
INSERT INTO llg_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Memak Au mate. Tehuu neu ko Au asoda fali, fo Au uu ahani ei nai propinsi Galelea ele.” ");
INSERT INTO llg_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Tehuu Petrus sapa nae, “Ama! Mae basa hataholi feꞌe kala lalai laꞌo ela Ama, tehuu au taa!” ");
INSERT INTO llg_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Boe ma Yesus nataa nae, “Leondiak do Peꞌu? Mamahele Au! Leꞌodaen ia, manu bei taa kokoa, tehuu o malelesi Au laꞌi telu, mae, o taa malelak Au!” ");
INSERT INTO llg_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Tehuu Petrus nahele nae, “Taa Ama! Mete ma Ama mate, na, au boe oo, mate tungga noꞌu. Huu au taa bisa alai laꞌo ela Ama!” Petrus nonoo feꞌe nala boe oo, esa-esak lae leondia boe. ");
INSERT INTO llg_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Basa de Yesus asa laꞌok lakandoo leni lete Setun leu, losa osi esa nade Getsemani. Nai ndia, Ana nafada ana mana tungga nala nae, “Ei manggatuuk tataak mai ia dei, huu Au sangga uu hule-haladoi nai ele.” ");
INSERT INTO llg_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Tehuu noke nala Petrus, Yakobis, ma Yohanis, de telu sala leu noꞌu loo Ndia. Mulai neme ledoeik ndia mai boe oo, Ndia dalen nameda hedis ma taa ndoo-ndoo. ");
INSERT INTO llg_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Dei fo ala laꞌok doo-doo ana, tehuu nafada sala nae, “Au dale hedi alan seli! Au ameda leo bali Au sangga mate. Ei manggatuuk beꞌe manea mia Au nai ia dei.” ");
INSERT INTO llg_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Boe ma Ana laꞌo dook fa mata neu, de Ana sendek lunggulanggan, de, hule-haladoi nae, “Ama susuek aa! Mete ma Ama nakaheik, na, boso Au tanggon doidosok ia. Tehuu boso tungga Au hihiing; kada ela tungga Ama hihii-nanaun.” ");
INSERT INTO llg_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Hule-haladoi nateꞌe, boe ma Ana fali neni Ndia ana mana tungga katelu nala sila neu. Tehuu ala sunggu lamanee. Boe ma Ana nafofoꞌa sala, de nafada Petrus nae, “Heh, Peꞌu! Hatina de ei sunggu? Au nai ele kada taa doo anak, tehuu ei taa bisa beꞌe fa boe! ");
INSERT INTO llg_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Kukuku tao mamaneu ei mata mala dei. Basa na, foꞌa fo manea mia Au! Huu memak ei dale mala lahiik tao malole, tehuu ei ao mala taa matea. De, malolenak ei hule-haladoi, fo mete ma hambu soba-douk, na, ei bisa mahele.” ");
INSERT INTO llg_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Basa de, Ana neu hule-haladoi bali, nae, “Ama aa! Mete ma Au musi lemba doidosok ia, na, ela tungga kada Ama hihii-nanaun.” ");
INSERT INTO llg_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Hule-haladoi basa, boe ma Ana fali neni Ndia ana mana tungga katelu nala sila neu. Tehuu ala sunggu seluk bali, huu mata nala nduak. ");
INSERT INTO llg_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Basa de Ana laꞌo ela sala, de neu hule-haladoi laꞌi esa bali. Ana noke seluk Aman, fo boso mboꞌin Ana lemba doidosok ndia, tehuu ela kada tungga Aman hihii-nanaun. ");
INSERT INTO llg_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Hule-haladoi nateꞌe boe ma Ana fali fo nafofoꞌa Ndia ana mana tungga mana sunggu kala sila, nae, “Ei bei sunggu makandoo ia do? Foꞌa leo! Huu hataholi mana sangga seꞌo heni Au, fo Hataholi Isi-isik ia, dekak mai so. Hatematak ia, ala sangga humu Au, fo fee Au uu hataholi manggalauk kala lima nala. ");
INSERT INTO llg_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Weih! Foꞌa leo! Malaak ei mata mala fo suli sudik mini ele miu. Huu hataholi mana seꞌo heni Au ndia, mai so.” ");
INSERT INTO llg_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ledoeik Yesus bei kola-kola leondiak, tehuu Yudas mai so, noo hataholi makadotok. Ala mai leni tafa ma ai kekeꞌuk, fo sangga humu Ndia. Ala tao leondiak, tungga palenda neme malangga anggama Yahudi la malangga nala, ma lasi hada kala. ");
INSERT INTO llg_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yudas fee tanda memak neu sala, nae, “Ei mete neulalau baa! Hataholi fo Au idun ndia, na ei humu mala Ndia leo! Huu, hataholi fo ei sanggak ndindia!” ");
INSERT INTO llg_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ledoeik ala losa leu Yesus, boe ma Yudas nakandoo neni Ndia matan neu, de nae “Soda-molek Ama Mesen!” Boe ma Yudas holu nalan de ana idun. ");
INSERT INTO llg_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Boe ma Yesus natanen nae, “Heh Yudas! O mamaim ia, no maksud leoiak do?” Boe ma, hataholi makadoto kala sila mata leu de, sangga humu Ndia. ");
INSERT INTO llg_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Kaiboik Yesus hataholin esa feꞌa nala tafan de ana sambi ketu heni hataholi esa ndiꞌidoon. (Hataholi makahinak ndia, na, malangga anggama Yahudi malangga ina-huun hataholi nadedenun ndia.) ");
INSERT INTO llg_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Nita leondiak, boe ma Yesus nafada hataholi ndia nae, “Mamana falik tafa ndia neni mamanan neu. Huu hataholi fo nasoda no nakaminak tafa, na, dei fo ndia boe oo, mate nenik tafa. ");
INSERT INTO llg_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","O taa bubuluk do? Au bisa oke Au Amang fo haitua Ndia ata nala lifu-lifu kala leme nusa-sodak mai, fo ala mai tulu-fali Au. ");
INSERT INTO llg_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Tehuu bosok. Elan neme naa, fo hataholi la ia humu lala Au. Huu basan nana sulak mema nai Manetualain Susula Malalaon, laꞌeneu Au, musi ana dadi.” ");
INSERT INTO llg_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Basa de Yesus kokolak neu hataholi makadoto kala sila fo mana mai humu Ndia, nae, “Weih! Ei maehetuk Au ia hataholi manggalauk do? Hatina de ei mai humu Au minik tafa ma ai kekeꞌuk? Naa te tungga-tungga faik Au anoli ei, nai Manetualain Uma Ina Huhule-haladoin, tehuu taa hambu esa tao hata-hata neu Au. ");
INSERT INTO llg_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Tehuu neme naa! Mai, humu mala Au leo! Huu basa ia nana sulak memak so, neme makahulun mai nai Manetualain Susula Malalaon.” Lita leondiak, boe ma Yesus ana mana tungga nala bii lalan seli. Boe ma ala lalai laꞌo ela Ndia. ");
INSERT INTO llg_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Basa ndia, boe ma hataholi mana humu Yesus loon neni malangga anggama Yahudi malangga ina-huun, Kayafas uman neu, huu hataholi ina-huun nala lakabubua lai ndia. Fo ndia, malangga anggama la malangga nala, mese anggama la, ma lasi hada kala. ");
INSERT INTO llg_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ledoeik ala toꞌu loo Ndia, naa te Petrus tungga nafufunik nai dea, losa malangga ina-huuk uman. Petrus boe, maso neni uma pasan neu, de nanggatuuk noꞌu no hataholi malai sila la. Huu ana nau bubuluk hata fo dei fo ana dadi. ");
INSERT INTO llg_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Nai uma ndia dalek, malangga anggama Yahudi la malanggan nala lakokola aok lo basa hataholi mana makaneni dedeꞌa anggama. Basa sala sangga buti, ma sangga dalak fo huku mate Yesus. ");
INSERT INTO llg_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Tehuu mae ala fee sakasii pepekok noꞌu kala boe oo, ala taa hambu buti esa boe, fo bisa paken. Babasan de ala hambu hataholi sakasii dua. ");
INSERT INTO llg_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Hataholi sakasii kadua kala sila, lae, “Ai mamanene mitak Hataholi ia kokolak nae, ‘Dei fo Au tao atuꞌu heni Uma Ina Huhule-haladoik. Tehuu neu faik telu, na, dei fo Au ambadedei fali kana.’ ” ");
INSERT INTO llg_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Basa de, malangga anggama Yahudi la malangga ina-huun nambadeik neu basa hataholi mana manggatuuk lai ndia matan. Boe ma natane Yesus, nae, “O mamanene hataholi noꞌu kala soli salak neu O. Tehuu, hatina de kada O nee-nee?” ");
INSERT INTO llg_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Tehuu Yesus taa nataa hata-hata. Boe ma malangga ina-huuk ndia natane bali, nae, “Au sangga atane ia! Tehuu O musi mataa tebe-tebe sama leo O mataa neu Manetualain fo mana masoda nai nusa-sodak. Hambu hataholi nae, O ia, Karistus, fo Manetualain Anan fo Ana heluk ndia so neme makahulun mai ndia. Tetebes ndia do?” ");
INSERT INTO llg_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Basa boe ma, Yesus nataa, nae, “Memak tetebes leo ama kokolan ndia. Tehuu masanenedak baa! Huu dei fo ei basa nggei mita Au, Hataholi Isi-isik ia. Dei fo Au anggatuuk nai nusa-sodak, nai Manetualain boboa konan, fo toꞌu palenda noꞌu ua Ndia fo mana koasa manai lain seli. Basa ndia, na, dei fo Au konda fali maing, ua koꞌas.” ");
INSERT INTO llg_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Namanene leondiak, boe ma malangga ina-huuk ndia luli nalan seli, losa ana luꞌi sida ndia badu nalun. Basa de ana eki neu basa hataholi la mana manggatuuk lai ndia, nae, “Weih! Ita taa paluu sakasii so bali! Ei mamanene minik ei ndiꞌidoo heheli mala, Ndia kokolan ndia. Ana soꞌuk aon dadik Manetualain Anan ia so. Ia nakadadae ia so! Ei basa nggei bubuluk so, mae, tungga ita heti-heu anggaman, na, mete ma hambu hataholi tao aon sama leo Lamatuak, na, hataholi ndia musi maten! ");
INSERT INTO llg_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","De, hatematak ia, ei sangga maketun mae hata?” Boe ma basa sala eki lae, “Memak hataholi ia, sala tetebes! De, musi huku nisan!” ");
INSERT INTO llg_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Basa de, hataholi hida mata leu de ala mbula ambe neu Yesus. Boe ma ala mbomboko lakamimina kana ma famban. ");
INSERT INTO llg_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Basa de ala haumemee Ndia, lae, “Weih! O ia, Karistus hetu? Soba O neuk dei! See ndia tutu O?” ");
INSERT INTO llg_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Faik ndia Petrus bei nanggatuuk nai uma ndia pasan. Basa de, ata inak esa mai kokolak non nae, “Isinaak, o boe oo sama-sama mua Yesus, fo hataholi Nasaret ndia, hetu?” ");
INSERT INTO llg_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Tehuu ana nalelesi neu hataholi noꞌu kala sila mata nala, nae, “Taa! Hatina de o matane leondiak! Au taa alelak Ndia maa.” ");
INSERT INTO llg_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Basa de, Petrus kalua fo nambadeik neu lelesu mbaꞌa matan. Boe ma, ina feꞌek esa nitan nai ndia. De, ana nafada hataholi malai ndia kala nae, “Wei, isinaak au ita hataholi ia sama-sama no Yesus, fo hataholi Nasaret ndia.” ");
INSERT INTO llg_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Boe ma Petrus sapan, nae, “Fama o kamuluk! Au taa alelak Hataholi ia maa! Au soo!” ");
INSERT INTO llg_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Taa dook bali, boe ma, hataholi feꞌek esa nai ndia, kokolak bali nae, “Heh! O boso pepeko bali, mae, o taa sama-sama mua hataholi ndia! Huu ai mamanene o kokolam ndia sama matetuk leo hataholi Galelea!” ");
INSERT INTO llg_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Tehuu ana aꞌali, ma ana laban nae, “Wei! Au soo unik Manetualain naden! Au taa alelak Hataholi ndia!” Nandaa no ndia kokolan ndia, boe ma manu kokoa. ");
INSERT INTO llg_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Namanene manu kokoan, boe ma Petrus nasaneda Yesus kokolan isinaak, nae, “Manu bei taa kokoa, tehuu o malelesi Au laꞌi telu so.” Nasaneda leondiak, boe ma ana neni deak neu de namatani nasakekedu. ");
INSERT INTO llg_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Fafai anan, basa hataholi mana makaneni dedeꞌa anggama sila, lala-halak fo sangga tao lisa Yesus. ");
INSERT INTO llg_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Huu ndia de, ala mbaꞌa leni Ndia neu nasale gubenol Pilatus. Huu ala nau fo gubenol huku nisa Ndia. ");
INSERT INTO llg_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ledoeik Yudas bubuluk, nae, Yesus hambu huku mate so, boe ma ana fale dalen, huu ana seꞌo heni Yesus. Boe ma ana fali neni malangga anggama Yahudi la malangga nala, lasi hada kala, fo ana fee falik doi lilo fula katelu huluk ndia. ");
INSERT INTO llg_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ana nafada nae, “Au asala ia so, huu au fee heni Hataholi sala taak ia.” Tehuu lataa lae, “Weih! Ai taa nau mbali o so bali! O mesa nggo ndia tanggon salak ndia.” ");
INSERT INTO llg_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Boe ma Yudas mbia heni doi kala sila leni Uma Ina Huhule-haladoik dale neu. De ana kalua neu londa aon losa mate henin. ");
INSERT INTO llg_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Boe ma malangga anggama Yahudi la malangga nala leu hele lakabubua lala doi kala fo Yudas mbia heni kala. Ala kokolak lae, “Ita taa bole tanggodi falik doi kala ia leni peti doik dale leu, huu doi kala ia manggenggeok. ");
INSERT INTO llg_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","De, malolenak ita teu hasan neu dae bibiak esa neme hataholi mana tao ule dae. Mete ma hataholi nusa dea maten, ma taa hambu hataholi nalela kana, na, ita bisa tatoin neu ndia leo.” ");
INSERT INTO llg_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Basa boe ma ala pake doik ndia, de leu hasa lala dae ndia. Huu ndia de losa hatematak ia, ala foi dae ndia nade, ‘Dae daak’. ");
INSERT INTO llg_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","No leondiak, ala tungga hata fo Lamatuak mana kokolan Yeremia kokolak memak so, nae, “Ala pake doi lilo fula katelu huluk sila, fo hasa neu dae. Ala pake doik sila, huu doi kala sila hataholi belin, tungga hataholi Israel asa laketu mema kana. ");
INSERT INTO llg_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Dae ndia ala hasan neme hataholi mana tao ule dae, tungga Manetualain palenda neu au.” ");
INSERT INTO llg_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Faik hataholi la loo Yesus losa gubenol, boe ma natane Yesus, nae, “Leobee? O ia tebe-tebe hataholi Yahudi la Manen do?” Ana nataa, nae, “Tetebes. Ama kokolan tetebes ndia so.” ");
INSERT INTO llg_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Tehuu faik fo malangga anggama Yahudi la malangga nala, ma lasi hada kala kalaak dedeꞌak noꞌuk laꞌeneu Yesus, tehuu Ana taa nataa fa boe. ");
INSERT INTO llg_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Boe ma gubenol natane Ndia nae, “O taa mamanene hataholi noꞌu kala kokola nalan sila do? Ala soli salak makadotok neu O. Tehuu hatina de O taa bala sala boe?!” ");
INSERT INTO llg_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Tehuu Ana taa nataa fa boe, losa gubenol heran nalan seli. ");
INSERT INTO llg_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Tungga-tungga teuk, mete ma hataholi la tao feta Paska, na, hataholi noꞌu kala lateme hele hataholi bui esa, fo gubenol mboꞌi henin. ");
INSERT INTO llg_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Faik ndia, hataholi bui esa, nade Barabas. Basa hataholi la bubuluk see ndia, huu manggalaun ana seli. ");
INSERT INTO llg_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Faik ndia boe oo, hataholi noꞌuk leni gubenol Pilatus leu loke, fo ana mboꞌi heni hataholi bui esa leo natetemek. Boe ma Pilatus natane sala nae, “Malole! Tehuu au mboꞌi heni see? Nai ia hambu Barabas, ma Yesus boe, fo hataholi la lae, Karistus. De Au mboꞌi heni see? Kada ei hele leo.” ");
INSERT INTO llg_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","(Gubenol kokolak leondiak, huu ana bubuluk so, malangga anggama Yahudi la malangga nala loo Yesus neni ndia neu, huu ala dale hedi Ndia lalan seli.) ");
INSERT INTO llg_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Faik fo gubenol bei palisak dedeꞌak ndia, tehuu ndia saon haitua heheluk neu ndia, nae, “Ama aa! Besa-besa bou, huu Yesus ia Hataholi fo salan taa fa boe. Huu-huu Ndia, de, leꞌodaek au alameꞌi taa malole. Losa hatematak ia au bei ameda taa malole alan seli.” ");
INSERT INTO llg_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Tehuu malangga anggama Yahudi la malangga nala, ma lasi hada kala mbauedo hataholi noꞌu kala sila, fo loke gubenol mboꞌi heni Barabas, ma huku nisa Yesus. ");
INSERT INTO llg_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Boe ma natane sala seluk bali nae, “Neme kadua kala ia, au mboꞌi heni see?” Boe ma lataa noꞌu lae, “Barabas! Kada mboꞌi heni Barabas leo!” ");
INSERT INTO llg_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Basa de natane sala nae, “Mete ma leondiak, na, au tao leobeek neu Yesus ia, fo hataholi lae, Karistus?” Boe ma basa sala eki noꞌu lae, “Mbaku misan nai ai ngganggek leo!” ");
INSERT INTO llg_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Basa de, gubenol natane bali nae, “Tehuu Ndia salan hata? Au palisak Ndia so, tehuu au taa hambu salan fa boe!” Tehuu basa sala boe eki latingga lae, “Tao misa Ndia! Mbaku Ndia neu ai ngganggek leo!” ");
INSERT INTO llg_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Taa dook boe ma, ana bubuluk, nae, ndia taa bisa tao hata-hata bali, huu hataholi noꞌu kala sangga manggalau so. Huu ndia de, ana haꞌi oe de ana safe liman neu sila mata nala, ma nafada nae, “Au taa tanggon Hataholi ia mamaten! Ela ei ndia musi tanggon!” ");
INSERT INTO llg_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Boe ma hataholi noꞌu kala sila lataa lae, “Hei, neme naa! Ela ai umbu ana nala tanggon Ndia daan ndia!” ");
INSERT INTO llg_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Namanene leondiak, boe ma ana nae, “Neu.” Boe ma ana mboꞌi Barabas, tungga sila hihiin. Basa de, ana palenda hataholi mana manea kala fo ala filo Yesus lenik fifilok. Filo lateꞌe, boe ma soldadu la loo Yesus, fo sangga mbaku nisan nai ai ngganggek. ");
INSERT INTO llg_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Basa ndia, boe ma soldadu la hela loo Yesus leni sila kota-musu nala pasa ina-huun neu. Nai ndia, ala loke lala sila nonoo nala batalion esa. ");
INSERT INTO llg_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Boe ma ala papaken badu nalu mbila-manggaledok esa, sama leo mane kala lateme paken. ");
INSERT INTO llg_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Boe ma, ala haꞌi lala ai kanggouk ndanan de ala nanen leo solangga. Boe ma ala neneꞌe solangga kanggouk ndia neu Yesus langgan, fo lakamiminak sama leo ala soꞌu mane beuk fo pake solangga manek. Boe ma ala latotoꞌun ai esa neu lima konan, sama leo teteꞌe-ai palenda. Boe ma ala sendek lunggulanggak lasale Ndia, ma ala haumemee Ndia, lae, “Hada-holomata neu hataholi Yahudi la Manen.” ");
INSERT INTO llg_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Boe ma ala mbula ambe neu Ndia, ma haꞌi lala teteꞌe-aik neme Ndia liman mai, de ala lambue denggu Ndia langgan. ");
INSERT INTO llg_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ala lambue haumemee basa Ndia, boe ma ala odu heni badu nalun. Boe ma ala papake seluk Ndia baloꞌan. Basa boe ma, ala loon neni kota Yerusalem deak neu, fo sangga leu mbaku Ndia neu ai ngganggek losa maten. ");
INSERT INTO llg_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ledoeik ala hela loo Yesus, ala latonggo lo hataholi esa neme dala laladak, fo bei fo neme kota Kirene mai. Ndia naden Simon. Ala lakasetin luꞌa ai ngganggek nggati Yesus. ");
INSERT INTO llg_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Boe ma ala losa mamanak esa, nade Golgota. (Nai dedeꞌa Aram, ndandaan nae, “Mamana langga duik.”) ");
INSERT INTO llg_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ala sangga feen ninu anggol nana seseok no akidoo makaheduk, fo suek Ana bisa nakatataka nala hedis. Yesus ninu kada faak, de, Ana timba henin. ");
INSERT INTO llg_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Basa boe ma, ala mbaku Ndia neu ai ngganggek. Boe ma soldadu la hela lot, fo sangga bubuluk see ndia hambu Ndia baloꞌa papaken. ");
INSERT INTO llg_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Boe ma ala langgatuuk lanea Ndia. ");
INSERT INTO llg_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ala sulak neu papak esa nae, “YESUS IA, HATAHOLI YAHUDI LA MANEN” Boe ma ala mbaku papak ndia neu langgan lain, suek lafada tuten hata de ala huku lisa Ndia. ");
INSERT INTO llg_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ala mbaku lisa hataholi manggalauk dua lai ndia boe. Esa nai Ndia boboa konan; ma esa nai Ndia boboa kiin. ");
INSERT INTO llg_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Basa hataholi mana laꞌok lesik ndia, mete Ndia. Boe ma ala muꞌek de haumemeen. ");
INSERT INTO llg_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ala eki Ndia lae, “Wei! O mae O bisa tao matuꞌu heni Manetualain Uma Ina Huhule-haladoin, fo basa na, mambadedei fali kana nai faik telu dalen hetu? Mete ma O tebe-tebe Manetualain Anan, na, soba mboꞌi heni sudik O aom, fo konda muma ai ndia mai leo.” ");
INSERT INTO llg_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Leondiak boe, malangga anggama Yahudi la malangga nala, mese anggama, ma lasi hada kala tungga haumemee Ndia lae, ");
INSERT INTO llg_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ana tao nasoda hataholi feꞌek so, tehuu Ana taa bisa tao nasoda Ndia ao-ina hehelin bae maa. Ana nae, Ndia ndia hataholi Israel asa Manen! Mete ma leondiak, na, malolenak Ana konda memak neme ai ndia mai. Mete ma ita tita leondiak, bei fo ita tamahele teu Ndia. ");
INSERT INTO llg_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Mete ma Ndia tebe-tebe Manetualain Anan, na, ela, ‘Ana namahena neu Manetualain. De, mete ma Lamatuak sue Ndia, na, ela Lamatuak tao nasoda Ndia.’ ” ");
INSERT INTO llg_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Hataholi mana mamoa kadua kala sila boe oo, tungga haumemee Ndia leondiak. ");
INSERT INTO llg_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Basa ndia, boe ma makiu-mumuuk mboti nala mamanak ndia neme ledo kamatetun losa liꞌu telu ledo bobon. ");
INSERT INTO llg_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Nandaa liꞌu telu ledo bobon, boe ma Yesus nanggou nenik dedeꞌa Aram, nae, “Eli! Eli! Lema sabatani?” (Ndia ndandaan nae, ‘Au Lamatuang! Au Manetualain aa! Hatina de Ama heok masadea ela Au leoiak?”) ");
INSERT INTO llg_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Hataholi hida deka-deka lai ndia lamanene Ndia halan. Boe ma ala lae, “Wei! Ei mamanene dei. Ana noke Elia, fo Lamatuak mana kokola makahulun ele ndia!” ");
INSERT INTO llg_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Basa de hataholi esa nalai neu haꞌi lombu, de ana bolon neu anggol makeis. Boe ma ana taon neu ai esa mbedan, de nambomboon neu Yesus bifidoon, fo suek Ana musi. ");
INSERT INTO llg_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Tehuu hambu hataholi feꞌek bali kokolak nae, “Mahani dei, fo ita mete sudik, Elia sangga mai tao nasoda Ndia, do taa?” ");
INSERT INTO llg_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Basa de, Yesus nanggou natingga seluk bali, boe ma Ana mate. ");
INSERT INTO llg_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Nai Uma Ina Huhule-haladoik, hambu tema babaa ina-huu maloa esa nana londak fo babaa Manetualain Kama Malalaon Ana Seli. Nandaa no Yesus ketu ani hahaen, boe ma tema nana londak ndia sii baꞌen neu dua, neme lain mai losa dae. Boe ma dae nanggeꞌo, losa batu ina-huuk ndala baꞌen. ");
INSERT INTO llg_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Late sala boe oo latangga. Ma Manetualain hataholi mana mate nala, luma lasoda fali. ");
INSERT INTO llg_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ledoeik Yesus nasoda fali so, boe ma ala kalua leme late sala mai, de leni Yerusalem leu. Hataholi noꞌu kala lita sala lai ndia. ");
INSERT INTO llg_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Nai Golgota, malangga soldadu esa ma ana palenda nala, lanea Yesus ai ngganggen. Ledoeik lita daebafok nanggeꞌo, ma basa dedeꞌa mana dadi kala sila so, de ala bii lalan seli. Ala lakokola lae, “Awii! Hataholi ia, memak tebe-tebe Manetualain Anan!” ");
INSERT INTO llg_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Nai ndia boe, hambu inak hida, lita Ndia mamaten neme dook mai. Ala tungga Ndia neme Galelea mai, huu ala ono-lau Ndia neme makahulun mai. ");
INSERT INTO llg_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Neme ina kala sila, hambu Maria neme Magdala mai, Maria esa bali, (fo ndia Yakobis no Yusuf inan), ma Sabadeus saon (fo ndia Yakobis no Yohanis inan). ");
INSERT INTO llg_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Hataholi kama suꞌik esa nai ndia, neme nggolo Arimatea mai, nade Yusuf. Ana tungga Yesus nanonolin dook ia so. Yesus mamaten ndia, laꞌeneu fai Lima. Neu foꞌa mai laꞌeneu hataholi Yahudi la fai huhule-haladoin. Huu ndia de, ledo sangga tesa, boe ma Yusuf sangga dalak fo sangga nakonda Yesus mbombolan neme ai ngganggek mai. ");
INSERT INTO llg_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Boe ma ana neni gubenol Pilatus neu, fo noke Yesus mbombolan. Basa de gubenol palenda fo ala fee mbombolak ndia neun. ");
INSERT INTO llg_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Boe ma Yusuf neni Golgota neu. Fo ana nakonda Yesus mbombolan neme ai ngganggek ndia mai. De, ana mbomboti neulalau mbombolak ndia, nenik tema beuk mabeli. ");
INSERT INTO llg_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Faik ndia, hataholi bei fo mbaꞌa basa lua anak esa nai lete batu, fo sadia memak Yusuf no bobonggi nala late nala, mete ma mate sala. De, Yusuf asa koꞌo Yesus mbombolan fo leu taon neu lua anak ndia. Boe ma ala loli lala batu ina-huuk esa, fo ala kena neulalau lua anak ndia. Basa ndia, boe ma Yusuf asa fali. ");
INSERT INTO llg_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Faik ndia, Maria maneme Magdala mai, ma Maria feꞌek ndia, ala tungga lai ndia boe. Ala langgatuuk lasale leni bolok ndia leu. ");
INSERT INTO llg_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Neu foꞌa main, laꞌeneu hataholi Yahudi la fai hahae tao ues. Boe ma malangga anggama Yahudi la malangga nala, ma hataholi Farisi la leu lasale gubenol. ");
INSERT INTO llg_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ala lafada lae, “Ama gub, ai masaneda faik fo masapepekok ndia bei nasoda, ana nafada nitak nae leoia: ‘Memak Au mate, tehuu seli faik telu, boe ma Au asoda fali.’ ");
INSERT INTO llg_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Huu ndia de, ama tulun fee soldadu la lanea latalolole lates ndia, losa fai katelun. No leondiak, Ndia ana mana tungga nala taa bisa lamanaꞌo lala Ndia mbombolan, fo pepeko hataholi lae, Ana nasoda fali so. Huu mete ma ala pepeko leondiak, na, ndia manggalaun lena sila pepeko makahulun ndia, fo ledoeik lae Ndia ndia, Karistus.” ");
INSERT INTO llg_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Namanene leondiak, boe ma gubenol nataa, nae, “Malole boe! Tehuu hambu ei hataholi mala lanea aom. Malolenak kada pake sila, fo leu lanea latalolole mamanak ndia.” ");
INSERT INTO llg_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Basa de leni mamanak ndia leu, ma loo sila hataholi mana manea nala. Losa ndia de ala segel lisa batu manai lates lelesun. Boe ma ala ladenu hataholi lanea lakandoo mamanak ndia, fo hataholi feꞌek boso mai haꞌi lala mbombolak ndia. ");
INSERT INTO llg_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Boe ma Sosodaina fafain, Maria maneme Magdala mai, ma Maria feꞌek, leu tilo lates ndia. ");
INSERT INTO llg_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Kada nggengge neuk, daebafok nanggeꞌo nalan seli. Manetualain atan esa konda neme nusa-sodak mai, boe ma neu loli heni batu ina-huuk fo nana kenak neu bolok ndia. Basa de ana nanggatuuk neu batu ndia lain. ");
INSERT INTO llg_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ata nusa-sodak ndia matan nasaꞌa leo manggahadok, ma baloꞌan fula malalaok. ");
INSERT INTO llg_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Hataholi mana manea kala sila bii lalan seli, losa ala dele mbuse makasufuk, ma ala taa bisa lakababalek leo bali hataholi kamate sala. ");
INSERT INTO llg_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Boe ma ata nusa-sodak ndia, nafada ina kala sila, nae, “Ei boso bii! Au bubuluk ei mai sangga Yesus, fo ndia, Hataholi fo ala mbaku lisan nai ai ngganggek ndia. ");
INSERT INTO llg_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Tehuu Ndia taa nai ia so. Ana nasoda fali so, sama leo Ana kokolak memak ndia so. Mai, fo mita aom mamanak fo ala lakambembeꞌu Ndia mbombolan neu. Mamanak ndia louk so! ");
INSERT INTO llg_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Naa, hatematak ia, ei fali lai-lai leo! Miu mafada Ndia ana mana tungga nala, mae, Yesus nasoda fali so. Ana laꞌo nakahuluk neni Galelea neu. Ala musi leu latonggo lo Ndia nai ele, sama leo makahulun Ana helu memak sila so. Kada mamahele leo. Fali leo, fo mafada hata fo au kokolak ia!” ");
INSERT INTO llg_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Boe ma ina kala sila lalai kalua laꞌo ela mamanak ndia. Ala lameda bii, tehuu ala lameda lamahoko boe. Ala fali lai-lai fo lafada dedeꞌak ndia neu basa Ndia ana mana tungga nala. ");
INSERT INTO llg_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Tehuu losa dala laladak, kada nggengge neuk Yesus mai natonggo no sala. Ana kokolak nae, “Soda-molek!” Lita leondiak, boe ma ala leu deka-deka fo sangga holu Ndia ein, ma lakaluku-lakatele neu Ndia. ");
INSERT INTO llg_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Boe ma Ana kokolak nae, “Boso bii baa! Miu mafada Au ana mana tungga nggala, fo ala leu lahani Au nai Galelea.” ");
INSERT INTO llg_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ledoeik ina kala sila bei lai dala laladak, boe ma hataholi mana manea kala fali leni kota leu. Leu lafada malangga anggama Yahudi la malangga nala, basa hata fo mana dadik ndia so. ");
INSERT INTO llg_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Boe ma malangga nala sila heti dalak lo lasi hada kala, fo ala seba hataholi mana manea kala doik makadotok, fo suek seu bafa nala. ");
INSERT INTO llg_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Malangga nala sila lafada lae, “Leoiak. Mete ma hataholi latane, na, ei musi mataa mae, leꞌodaen ndia ei sunggu mamanee. Naa te Ndia ana mana tungga nala mai lamanaꞌo leni Ndia mbombolan. ");
INSERT INTO llg_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ma mete ma ama gub namanene dedeꞌak ia, na, ei boso bii, huu dei fo ai ndia heti tou lasik.” ");
INSERT INTO llg_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Boe ma hataholi mana manea kala haꞌi lala doi kala sila. Ala tao tungga malangga nala sila hihiin. Huu ndia de, losa hatematak ia hataholi Yahudi la bei lamahele tutui pepekok ndia. ");
INSERT INTO llg_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Lamanene basa ina kala sila nafafadan, boe ma Yesus ana mana tungga kasanahulu esa nala sila, leni propinsi Galelea leu, fo latonggo lo Ndia nai letek esa, tungga Ndia hehelun ndia. ");
INSERT INTO llg_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ledoeik ala lita Ndia nai ele, boe ma ala lakaluku-lakatele neu Ndia. Mae leondiak boe oo, tehuu bei hambu luma dalen nala bei lakandaa. ");
INSERT INTO llg_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Boe ma Ana mai deka-deka no sala, de Ana kokolak, nae, “Manetualain fee Au koasa, fo Au palenda basa malai nusa-sodak, ma basa malai daebafok. ");
INSERT INTO llg_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","De, ei mini sudi bee miu, na, ei musi mafada basa hataholi nusa kala Au Tutui Maloleng ia. Ei musi manoli neulalau sala, fo suek ala dadik Au ana nggala. Ma ei musi salani sala fo dadik tanda, nae, ala nanambaꞌak so, lo Amak, ma Ndia Anan, ma Ndia Dula Dale Malalaon. ");
INSERT INTO llg_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ma manoli sala fo ala tao tungga basa palenda fo Au afada ei so. Masanenedak baa! Au ua ei taa-taa nai ei lalada mala, losa daebafok babasan.” ");
INSERT INTO llg_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Tutui malole ia. Manetualain Anan tutuin ia. Ndia naden Yesus Karistus, fo Manetualain tudu mema kana, neme makahulun ele mai so. Tutuin natahuhuun leoiak: ");
INSERT INTO llg_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Yesus bei taa mulai tao Ndia ue-ledin, tehuu Manetualain nadenu nakahuluk hataholi esa so, nade Yohanis. Yohanis musi neu sadia dalak soaneu Yesus mamain. Huu makahulun ele, Manetualain pake mana toꞌu halak esa so, nade Baꞌi Yesaya. Ana sulak mema kana so, nae: “Mamanene bou! Au adenu Au hataholing esa neu sadia dalak fee O. ");
INSERT INTO llg_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Dei fo hataholi ndia neu leo nai mamana nes esa, fo nanggou ngganggali, nae: ‘Basa hataholi lalaꞌen, mahehele, fo tao neulalau dala kala, fo simbok Lamatuak mamain! Tao mandoo dala kala fo simbok Ndia.’ ” ");
INSERT INTO llg_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","6","Hataholi la lateme loke Yohanis na, lae, Mana Salanik. Ana leo nai mamana nes. Baloꞌa papaken, nana tenuk neme banda onta bulun mai. Kalikeen nana taok neme banda louk mai. Ndia nanaꞌa-nininun, lamak ma fani oe nula. (Yohanis dala sodan ia, sama leo Baꞌi Elia nai fai makahulun ele.) Faik ndia, hataholi la noꞌuk leme kota Yerusalem mai, ma, basa propinsi Yudea isi nala, mai latonggo lo Yohanis nai ndia mamanan ndia. Ala mai sangga lita Yohanis, ma, lamanene nanonolin. Yohanis nafada sala nae, “Ei musi manaku, ma, laꞌo ela basa ei sala-singgo mala, fo suek Manetualain koka heni sala-singgo kala sila. Basa, na, ei musi salani dei, fo dadik tanda nae, ei mole mia Lamatuak so.” Boe ma, ala manaku sala-singgo nala, de, ana salani sala leme lee Yarden. ");
INSERT INTO llg_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ana nafada nae, “Neu ko hambu Hataholi esa, ana selin lena heni au, ana sangga mai. Leomae kada dadik neu Ndia hataholi nadedenun boe oo, au taa andaa. ");
INSERT INTO llg_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Au bisa salani ei unik kada oe mesan, tehuu, dei fo Ana tao lena heni au, huu Ana tao nahenu ei dale mala, no Manetualain Dula Dale Malalaon.” ");
INSERT INTO llg_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Faik ndia, Yesus neme nggolo Nasaret fo nai propinsi Galelea mai, fo natonggo no Yohanis. Boe ma Yohanis salani Ndia neme lee Yarden. ");
INSERT INTO llg_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ledoeik Yesus kalua neme oe dale mai, tutik nita lalai natahuꞌak. Basa boe ma, Manetualain Dula Dalen sama leo mbui lunda esa, konda neu Yesus. ");
INSERT INTO llg_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Boe ma lamanene Manetualain halan neme lalai mai, nae, “O ia, Au Ana susueng. O tao mamahoko Au daleng nakandondoo henin.” ");
INSERT INTO llg_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Basa ndia, boe ma Manetualain Dula Dalen hela noo Yesus neni mamana nes esa neu. ");
INSERT INTO llg_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Nai ndia hambu banda fui la boe. Yesus leo nai mamanak ndia, faik haa hulu. Nai ndia, nitu la malanggan mai fufudi-oꞌodo Yesus fo suek Ana tungga ndia, tehuu taa nala sana. Basa ndia, boe ma Manetualain ata nala leme nusa-sodak mai de ala ono-lau Ndia. ");
INSERT INTO llg_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Fain, ala tao Yohanis Mana Salanik neni bui dale neu, boe ma Yesus neni nusa Galilea neu, fo Ana tui-bengga Manetualain Hala Malolen nai ndia. ");
INSERT INTO llg_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ana nafada, nae, “Mamanene baa! Hatematak ia, Manetualain fain losa so! Hatematak ia, basa hataholi la bubuluk lae, Manetualain toꞌu palenda so. Huu ndia, de ei hahae mima ei pepeko mala leo, fo fali miu tungga Lamatuak. Basa na, mamahele neu Ndia Hala Malolen ia, leo.” ");
INSERT INTO llg_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Faik esa, Yesus laꞌok tungga dano Galilea bifin. Ana nita hataholi esa, nade Simon, no fadin, nade Anderias. Dua sala dala iꞌak. Sila ue-ledin tungga-tungga faik ndindia. ");
INSERT INTO llg_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesus noke sala de nae, “Wei! Mai fo tungga Au leo. Ei mateme sangga iꞌak tungga-tungga faik, tehuu hatematak ia, na, Au sangga tao ei dadik miu mana sangga samanek.” ");
INSERT INTO llg_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Lamanene leondiak, boe ma dua sala foꞌa laꞌo ela sila dala nala, de leu tunggamemak Ndia. ");
INSERT INTO llg_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Basa ndia, boe ma Yesus laꞌok nakandoo fa, boe ma nita Sabadeus ana nala. Kaꞌak nade Yakobis ma fadin nade Yohanis. Dua sala lafafaꞌu mbuꞌa nala lai ofak lain. ");
INSERT INTO llg_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yesus noke dua sala, de, nae, “Wei! Mai fo tungga Au.” De dua sala laꞌo ela aman no hataholi mana tao ues lai ofak lain. Boe ma leu tunggan Ndia. ");
INSERT INTO llg_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Boe ma Yesus no hataholi kahaa kala, mana tungga Ndia, laꞌok losa nggolo Kapernaum. Faik fo hataholi Yahudi la fai huhule-haladoin, boe ma Yesus maso neni uma huhule-haladoik dale neu, de nanoli nai ndia. ");
INSERT INTO llg_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Hataholi la lamanene Ndia kokolan, boe ma basa hataholi heran lalan seli, huu Ana bubuluk tebe-tebe nanonolik ndia isin. Ndia taa sama leo hataholi Yahudi la mese nala. ");
INSERT INTO llg_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Faik ndia, hambu hataholi nitu nalak esa. Ndia boe oo, maso neni uma huhule-haladoik dale neu, boe ma nitu manai hataholi ndia dalek, nakau nae, ");
INSERT INTO llg_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Wei! Yesus, hataholi Nasaret aa! O dedeꞌa hatam mua ai! O sangga mai tao makalulutu ai do? Ai malelak O so. O ia ndia Hataholi fo makahulun ele Manetualain helu, nae, Ana fee O mai. O ia, Lamatuak Hataholi Malalaon fo salan taa.” ");
INSERT INTO llg_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Tehuu Yesus nasapala kana nae, “Seu o bafam! Kalua muma hataholi ndia dalek mai leo!” ");
INSERT INTO llg_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Boe ma nitu ndia tao nala hataholi ndia ana leꞌa nalan seli. Boe ma ana kalua neme hataholi ndia dalek mai, ma nakau tingga-tingga. ");
INSERT INTO llg_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Basa boe ma, basa hataholi malai uma huhule-haladoik ndia dale kala lamanggonggoak. Boe ma basa sala lakokola, lae, “Awii! Hata ia bae? Ana palenda nitu la fo ala kalua, boe ma ala tungga Ndia hihii-nanaun. Nanonoli beuk ia hetu maa? Tou lasik ia, Dedeꞌa-kokolan ana seli, maa!” ");
INSERT INTO llg_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Boe ma hataholi la mulai tui lafeok neme bafak mai neni bafak neu, de nakambela losa basa nggolo kala malai propinsi Galelea ndia. ");
INSERT INTO llg_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ledoeik ala kalua leme uma huhule-haladoik dale mai, boe ma Yesus neni Simon no Anderias uman neu. Yakobis no Yohanis leu noꞌu lon. ");
INSERT INTO llg_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Nai ndia, Simon alinan sumai, de nakambeꞌuk nai koi lain. Ledoeik Yesus no ana mana tungga nala leni uma dale leu, boe ma hataholi la mai lafada lae, “Ina lasik sumai.” ");
INSERT INTO llg_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Basa ndia, boe ma Yesus neu tilo ina lasik, boe ma Ana toꞌu nala liman, de nafofoꞌan. Boe ma, ina lasik sumain mopon heni tuti kana. Basa boe ma, ina lasik kalua, de neu ono-lau sala. ");
INSERT INTO llg_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ledoeik ledo mulai tesa, boe ma hataholi la loo sila hataholi kamahedi nala, ma hataholi nitu nala kala leni Yesus mai, fo loke tulu-falik. ");
INSERT INTO llg_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Losa basa hataholi la kota esa isi nala mai lakahohombu, lai uma ndia pasan. ");
INSERT INTO llg_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Hataholi la sila hedi nala mata-mata kala, tehuu Yesus tao nahai basa sala. Ma Ana husi kalua heni nitu makadotok nalan seli. Tehuu Ana taa mboꞌi nitu la sila kokolak, huu lalelak Ndia. ");
INSERT INTO llg_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Neu foꞌa mai lolembilan, fo bei makikiu anak, tehuu Yesus foꞌa, de Ana neni uma ndia deak neu so. Ana neni mamana linok esa neu, de Ana hule-haladoi, ma nakokola no Manetualain. ");
INSERT INTO llg_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ledoeik Simon asa foꞌa, tehuu taa lita Yesus so, boe ma ala leu sanggan. ");
INSERT INTO llg_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ledoeik ala latonggo lo Ndia, boe ma lafada lae, “Ama, hataholi noꞌu kala sangga Ama.” ");
INSERT INTO llg_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Tehuu Ana nataa nae, “Ndia malole boe. Tehuu malolenak ita teni nggolo feꞌek mana dekak nai iak teu dei. Huu Au sangga afada Hala Malole neu sala boe. Te Au ue-leding ndia.” ");
INSERT INTO llg_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Basa boe ma, Ana laꞌok ndule basa propinsi Galelea, de nafada Manetualain Hala Malolen nai sila uma huhule-haladoin dale. Ma Ana husi heni nitu la leme hataholi la dalek mai boe. ");
INSERT INTO llg_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Faik ndia, hataholi kamahedi kusta esa neni Yesus mai. Boe ma ana sendek lunggulanggan de noke tulun Yesus nae, “Ama aa! Fali mala au dei! Huu au bubuluk Ama bisa tao mahai au heding ia, fo suek hataholi la boso nunute au. Sadi Ama nau.” ");
INSERT INTO llg_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Basa ndia boe ma Yesus tuda kasian neu hataholi ndia, boe ma Ana look liman neu de Ana tai laꞌen, boe ma nafada nae, “Memak! Au nau! De, o hai leo!” ");
INSERT INTO llg_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Nggenge neuk hataholi ndia hedin mopon. Boe ma ana hai tutik. ");
INSERT INTO llg_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Boe ma Yesus nadenu hataholi ndia fali, ma Ana fee nasanenedak neun, ");
INSERT INTO llg_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","nae, “Masanenedak neulalau. O hai ia so, tehuu taa bole mafada sudi see, baa! O musi tungga Baꞌi Musa palendan dei. De, muni malangga anggama muu, fo ana palisak o aom, ma ana mete o heꞌdim mopo tetebes so, do beik. Boe ma o musi fee tunu-hotuk, dadik tanda makasi, fo suek basa hataholi la bubuluk lae, o hai tebe-tebe so.” ");
INSERT INTO llg_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Tehuu hataholi ndia kalua nala deak, boe ma neu tui nafeok sudi nai bee. Basa ndia, boe ma hataholi noꞌu kala lasanggak fo latonggo lo Yesus, losak Ana taa bisa natodak matan nai kota ndia. De Ana leo nahele nai kada mamana nes manai kota deak. Tehuu hataholi la lafaan leme basa mamanak lalaꞌen mai, fo ala nau latonggo lo Ndia. ");
INSERT INTO llg_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Seli faik hida, boe ma Yesus fali seluk neni Kapernaum neu. Boe ma ala bengga lai basa mamanak lalaꞌen lae, “Ana losa nai uma so.” ");
INSERT INTO llg_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Boe ma hataholi la leme basa mamanak lalaꞌen mai. Ala lakahohombu losa lakaseseꞌe leme uma dale losa lelesu bafan. Basa ndia, boe ma Yesus nafada sala, Manetualain hihii-nanaun. ");
INSERT INTO llg_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ana bei kola-kola, tehuu hataholi haa ndolo leni hataholi luꞌuk esa neni Yesus neu. ");
INSERT INTO llg_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Huu hataholi noꞌun seli, de, ala taa lalak loo hataholi ndia losa Yesus matan. Boe ma ala hene leni uma lain leu, de ala doꞌi heni uma lain, nandaa no Yesus langgan. Ledoeik uma lain bolok, boe ma ala lakonda hataholi ndia no neneꞌin. ");
INSERT INTO llg_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ledoeik Yesus nita sala, boe ma Ana bubuluk hataholi la sila lamahele tebe-tebe leu Ndia. De Ana nafada tou luꞌuk ndia, nae, “Ana nggo ei! Au fee ambon neu o sala-singgo mala so!” ");
INSERT INTO llg_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Tehuu nai ndia hambu mese anggama Yahudi luma langgatuuk lai ndia. Ledoeik lamanene Yesus kokolan ndia, boe ma ala lameda taa malole nai dale nala dale. ");
INSERT INTO llg_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Boe ma ala lakokola lae, “Hataholi ia nambalani nalan seli kokolak nae, leo ndia! Kada Manetualain mesa kana fee ambon neu hataholi sala-singgo nala. Tehuu hataholi ia kokolan nonook bali leo Manetualain ndindia. Namumulu Manetualain ndia so!” ");
INSERT INTO llg_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Tehuu Yesus bubuluk basa sila dale nala so. Boe ma nafada nae, “Ei boso duduꞌa leondiak! ");
INSERT INTO llg_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","10","Bee ndia lofoanak. Mete ma Au afada hataholi luꞌuk ia ae, ‘O salam hambu ambon so,’ na, ei taa bubuluk, mete ma ana dadi leondiak, do taa. Tehuu metema Au ae, ‘Foꞌa leo! Lulu mala o neneꞌim fo fali leo,’ Mete ma ana foꞌa tutik so, na, dei fo ei mita buti mae, Au ia Hataholi Isi-isik. Ma Au aena koasa ma hak, fo fee ambon neu hataholi salan.” Basa ndia boe ma, Yesus nafada hataholi luꞌuk ndia nae, ");
INSERT INTO llg_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Mamanene baa! Hatematak ia o hai so! De, foꞌa fo luꞌa mala o neneꞌim, fo fali leo baa!” ");
INSERT INTO llg_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Namanene leondia, boe ma hataholi ndia foꞌa tutik leo. Boe ma ana luꞌa nala neneꞌin de ana laꞌo neni deak neu. Basa hataholi malai sila kala lita lo mata deꞌe nala. Boe ma basa sala lamanggonggoak, de lae, “Awii! Hatematak ia dei fo ita tita mata leo iak bae maa! Manetualain memak ana seli maa!” ");
INSERT INTO llg_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Basa ndia boe ma Yesus neni dano Galilea bifin neu seluk. Hataholi noꞌu kala mai latonggo lo Ndia, boe ma Ana nafada sala Manetualain hihii-nanaun. ");
INSERT INTO llg_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Nai ndia hambu hataholi esa nade Lewi, fo Alfius anan. Ana tao ues nai mamana bae bea fo fee mana palenda Roma. Nandaa no Yesus laꞌok tungga ndia, boe ma nita Lewi. Boe ma Ana nafadan nae, “Wei! Mai fo tungga Au!” Namanene Yesus nae leo ndia, boe ma ana foꞌa de ana tungga Ndia leo. ");
INSERT INTO llg_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Basa ndia boe ma, Yesus no ana mana tungga nala langgatuuk laꞌa lai Lewi uman, lo nonoo mana susu bea la. Hambu hataholi feꞌe kala boe, laꞌa lon lai ndia. Tungga hataholi Yahudi la duduꞌa nala, na hataholi sila hataholi manggalauk. Nai hataholi fo mana manggatuuk mana naꞌa kala sila, hambu hataholi noꞌuk hii lamanene neu Yesus. ");
INSERT INTO llg_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Faik ndia, mese anggama hida leme hataholi Farisi la partein mai, lita Yesus nanggatuuk naꞌa no mana susu bea la, ma hataholi manggalau kala. Boe ma latane Yesus ana mana tungga nala lae, “Talobee de ei mesem nanggatuuk naꞌa no hataholi mana susu bea la, ma hataholi manggalau kala?” ");
INSERT INTO llg_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Tehuu Yesus namanene ala latane leondiak, boe ma nafada nae, “Hataholi kamahedi kala memak ala paluu dotel, tehuu hataholi taa kamahedi kala taa paluu dotel. Au mai ono-lau hataholi manggalau kala. Tehuu Au taa mai ono-lau hataholi fo nameda aon hataholi ndoos.” ");
INSERT INTO llg_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Laꞌi esa, boe ma partei anggama Farisi la hataholi nala puasa. Lita Yohanis mana salanik ana mana tungga nala boe oo, ala puasa. Tehuu ala taa lita Yesus ana mana tungga nala puasa leo sila. Boe ma sila hataholi nala mai latonggo lo Yesus de latane lae, “Ama! Ai puasa. Ma Yohanis hataholi nala oo ala puasa boe. Tehuu hatina de Ama ana mana tungga nala taa puasa?” ");
INSERT INTO llg_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Boe ma Yesus nataa nae, “Memak ei bubuluk so, mete ma hataholi tao feta kabin, na, hataholi nana hoka kala taa puasa, huu laꞌa-linu losa lakabete. Mete ma mana kabin touk bei nai ndia, na basa sala laꞌa-linu leu esa. ");
INSERT INTO llg_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Tehuu mete ma faik esa nai ndia, fo hataholi la humu leni tou mana kabin, fo ala laꞌo so, na, dei fo tialai-dedena nala dale hedi. Bei fo ala puasa.” ");
INSERT INTO llg_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Basa boe ma Yesus nafada nakadaik dedeꞌa nakandandaak esa nae, “Taa hambu hataholi fo ana tanda tema beuk neu badu laak. Huu mete ma safen, na, tema beuk kukulu, fo badu sidan boe namaloa. ");
INSERT INTO llg_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Sama leo hataholi taa diꞌa tua nasu beuk neu samba mboꞌok dale. Te neu ko sambak ndia sidan de loo heni tua nasu. De, tua nasu beuk musi diꞌan neni samba beuk dale neu.” (Leondiak boe Yesus nanoli sala nae Ndia nanonoli beun, boso seseo kana no hataholi Farisi la nanonoli laan.) ");
INSERT INTO llg_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Laꞌi esa, nandaa no hataholi Yahudi la fai huhule-haladoin, Yesus laꞌo nesik osi la. Boe ma Yesus ana mana tungga nala ketu lala hade gandum, de laꞌa. ");
INSERT INTO llg_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Tehuu hataholi Farisi la suli lita sala, de lafada Yesus lae, “Hatina de O ana mana tungga nala laꞌolena ai anggaman heti-heun? Ala ketu hade gandum nandaa no fai hahae ue-ledis! Ei boso tao leondiak!” ");
INSERT INTO llg_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Boe ma Yesus nataa nae, “Leobee, bae? Ei taa masaneda Baꞌi Dauk tutuin ndia. Faik ndia, tou lasi Abiatar, dadik Anggama Yahudi malangga inahuun. Baꞌi Dauk no ana mana tungga nala, ndoe lalan seli. Boe ma ala leni Manetualain Tenda Hule-Haladoin dalek leu, de ala haꞌi lala loti, fo malangga anggama la feen neu Lamatuak, de laꞌa. Naa te kada malangga anggama la, bole laꞌa, tehuu hataholi feꞌek taa bole laꞌa. Boe ma Baꞌi Dauk asa laꞌa, tehuu taa hambu hataholi soli salak neu sala.” ");
INSERT INTO llg_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Boe ma Yesus nafada nakadaik, nae, “Ei boso mafalende henin mae, Manetualain tao fai hahae ue-ledis, fo dadik neu babaꞌe-babatik, fo suek tulu-fali neu ita hataholi. Tehuu Ana taa tao ita hataholi fo tungga kada fai hahae tao ue-ledis heti-heu nala. ");
INSERT INTO llg_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","De Au, Hataholi Isi-isik ia, aena hak fo afada hataholi la, fo bole, do taa bole tao sudi hata nandaa no fai hahae tao ue-leꞌdis.” ");
INSERT INTO llg_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Basa ndia boe ma, Yesus fali seluk neni hataholi Yahudi la Uma Huhule-haladoin neu. Nai ndia, nita hataholi lima kamates seselik esa. ");
INSERT INTO llg_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Nai ndia boe, hambu hataholi hida lai ndia, ala lasanggak dalak fo fee salak neu Yesus. De ala malok lakandondoo henin Ndia, fo sangga bubuluk, Ana tao nahai hataholi ndia, nandaa no fai hahae tao ue-leꞌdis do taa. ");
INSERT INTO llg_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Boe ma Yesus noke hataholi lima kamate seselik ndia nae, “Mai, fo mambadeik muu mata ia.” ");
INSERT INTO llg_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Boe ma Ana natane basa hataholi la sila nae, “Mete ma tungga ita anggaman heti-heun, na hata fo ita tao nandaa no fai hahae tao ue-ledis? Ita tao malole do taa? Ita tao tahai hataholi, do ita tao tisan?” Tehuu basa sala kada benee. ");
INSERT INTO llg_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Boe ma Yesus dalen hedis nalan seli, huu hataholi la sila tao kada aꞌafik neu heti-heuk, tehuu ala taa tao aꞌafik neu hataholi lima kamate seselik ndia faa boe. Boe ma Ana luli nalan seli, de Ana nakabubulak matan ndule basa sala. Basa boe ma Ana nafada hataholi ndia nae, “Look o limam mai leo!” Hataholi ndia ana look liman neu, de ana hai tutik. ");
INSERT INTO llg_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Boe ma hataholi Farisi la sila leni deak leu de ala laꞌo ela uma huhule-haladoik ndia. Boe ma leu lala halak lo Herodes partei politik hataholi nala fo ala sangga dalak tao lisa Yesus. ");
INSERT INTO llg_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Laꞌi esa, Yesus no Ndia ana mana tungga nala, laꞌo heok leni dano Galilea bifin leu. Tehuu huu hataholi noꞌu kala lamanene basa hata fo Ana tao kala sila, de basa sala leme nggolo-nggolok mai fo ala tunggan. Ala leme propinsi Galelea, propinsi Yudea, ma nusa Idumea mai. Hambu hataholi feꞌek luma leme kota Yerusalem, kota Sidon, ma kota Tirus mai. Ma hambu hataholi feꞌek luma leme lee Yarden dulu mai. Basa sala sangga Yesus fo latonggo lon. ");
INSERT INTO llg_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Huu hataholi la noꞌun seli, losak Yesus nadenu ana mana tungga nala sadia feen ofak esa. Ana sangga kokolak nai ofak lain, fo suek basa sala lamanene, ma ala boso babaan. ");
INSERT INTO llg_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Makahulun, Ana tao nahai nitak hataholi kamahedik noꞌuk. Huu ndia de hatematak ia basa hataholi kamahedi kala mai lakaseseti fo sadi ala kame laꞌen. ");
INSERT INTO llg_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ledoeik hataholi nitu nala kala lita Ndia, tutik ala bala leu dae neu Yesus matan. Boe ma nitu la lakau lae, “Memak O ia Manetualain Anan!” ");
INSERT INTO llg_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Tehuu Ana kaꞌi nisa kasa nae, “Ei boso mafada hataholi esa boe mae, Au ia see!” ");
INSERT INTO llg_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Basa boe ma Yesus ndaꞌe neni letek esa lain neu. Ana noke nala hataholi luma fo nandaa no Ndia dale hihiin. De ala leni matan leu. ");
INSERT INTO llg_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Boe ma Ana hele nala hataholi sanahulu dua. De nafada sala nae, “Au hele ala ei fo tungga mahele Au. Au boe oo, sangga adenu ei, fo miu mafada Manetualain hehelun neu basa hataholi lalaꞌen. ");
INSERT INTO llg_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ma au sangga fee koasa neu ei, fo ei bisa husi heni nitu la leme hataholi la mai.” ");
INSERT INTO llg_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","19","Hataholi kasanahulu dua kala sila nade nala sila ia: Simon (fo Yesus foin nade Petrus boe), Yakobis, Yohanis, (Yakobis no faꞌdin Yohanis ia, na Sabadius anan dua sala. Yesus foi dua sala nade ‘Boanerges’, fo sosoan ‘sama leo tatas’), Anderias, Filipus, Bartolomeos, Mateos, Tomas, Yakobis (fo Alpius anan), Tadius, Simon (fo mana masok partei politik Selot), ma Yudas Iskariot (fo mana seꞌo heni Yesus). ");
INSERT INTO llg_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Basa ndia, boe ma Yesus no ana mana tungga nala loe fali leme letek ndia lain mai. De ala maso leni uma esa dalek leu. Tehuu hataholi noꞌu kala mai lakaseseti lala Ndia bali, losa Yesus asa taa lalak laꞌa so bali. ");
INSERT INTO llg_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Lita leondia boe ma hataholi lae, “Mete sudik Yesus dei. Ana nafalende heni nasaneu nala aoinan so.” Huu kaꞌa-faꞌdi nala lamanene hataholi la kokolak lae leo ndia, de ala sangga mai lala falik Ndia. ");
INSERT INTO llg_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Faik ndia, mese anggama la leme Yerusalem mai de lafada hataholi malai ndia kala lae, “Wei Ei boso kada tungga-tungga mia Yesus ndia. Ana husi heni nitu leondiak ndia, na, huu Ana hambu koasa neme malangga nituk mai, fo hataholi lateme loke lae Baalsebul.” ");
INSERT INTO llg_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yesus namanene leondia, boe ma Ana noke nala basa sala de nafada nae, “Taa masok langgautek! Neme bee mai fo malangga nituk bisa husi seluk aoinan! ");
INSERT INTO llg_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Mete ma nai nusak esa, lauinggu nala lahuu, na neme bee mai nusak ndia bisa nakatataka! ");
INSERT INTO llg_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ma mete ma uma isi la lasii-lalaꞌu ao esa no esa, na neme bee mai fo bei lakatataka! ");
INSERT INTO llg_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Leondiak boe oo, mete ma nitu la esa musu no esa, na, neu ko ala latanggela-latanggali. Mete ma leondiak, na, neu ko basa sala lakalulutuk! ");
INSERT INTO llg_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Mete ma hataholi la sangga leu lamanaꞌo hataholi balakaik esa uman, na neu ko ana musi hengge nakahuluk maumak dei. Basa ndia, dei fo ala lamoa lala hataholi ndia bua nala. ");
INSERT INTO llg_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","De, Au afada memak ei: Manetualain sadia koka heni hataholi la sala-singgo nala so. Ma mete ma hataholi kokolak manggalauk neu hataholi feꞌek, na Manetualain bei fee ambon neun. ");
INSERT INTO llg_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Tehuu mete ma hambu hataholi nambalani kokolak manggalauk neu Manetualain Dula Dale Malalaon ndia, na Manetualain taa fee ambon neun losa daeinak babasan.” ");
INSERT INTO llg_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesus nae leo ndia, na, huu hataholi sila lae, “Hataholi ndia nitu nalak so!” ");
INSERT INTO llg_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Basa boe ma, Yesus inan no fadi nala, leni uma ndia leu, fo, sangga latonggo lon. Nai ele, ala lambadeik kada deak. De ladenu hataholi neu noke Yesus nai uma dale. ");
INSERT INTO llg_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Leꞌdoeik ndia, Yesus nanggatuuk, de bei kola-kola no hataholi noꞌu kala. Boe ma hataholi la lafada lae, “Ama! O inam no O faꞌdi mala lai deak. Ala sangga latonggo lo Ama.” ");
INSERT INTO llg_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Tehuu Yesus nafada nae, “Au inang ma Au tolanoo tetebe nggala sila, see?” ");
INSERT INTO llg_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Boe ma, Ana mete ndule hataholi mana manggatuuk ndule Ndia. Boe ma Ana kokolak nae, “Ei basanggei ia, Au inang ma Au tolanoo tetebe nggala. ");
INSERT INTO llg_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Huu see ndia tungga Manetualain hihii-nanaun, na sila ndia Au bobonggi tetebeng sisila.” ");
INSERT INTO llg_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Laꞌi esa, boe ma Yesus neni dano Galelea seluk neu. Boe ma hataholi la noꞌuk mai lakahohombu lala Ndia. Basa de Ana hene neni ofak esa lain neu fo mana seek nai ndia, suek Ana nanoli. Basa hataholi la malai madak lain lamanene Ndia. ");
INSERT INTO llg_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Boe ma Ana nanoli sala makadotok nenik nakandandaak nae, ");
INSERT INTO llg_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ei mamanene matalolole baa! Hambu hataholi esa neu ngganggali bini nai osin dale. ");
INSERT INTO llg_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ledoeik ana ngga-nggali bini la sila, nggelok tuda lai dalak lain. Boe ma mbui kala mai, de laꞌa heni basa bini la sila. ");
INSERT INTO llg_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Tehuu bini nggelok tuda lai dae batu. Bini la sila lanumbu lai-lai. Tehuu dae ndia niꞌis, ");
INSERT INTO llg_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","de ledoeik ledo nahaa boe ma numbu nala male, losa lamatuu de mate basa sala. Huu oka nala taa tola demak losa dae dale. ");
INSERT INTO llg_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Bini nggelok tuda lai fii la laladan. Boe ma fii la sila kofu lisa numbu kala sila, losa taa hambu labuna-laboa. ");
INSERT INTO llg_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Tehuu hambu bini nggelok bali, tuda lai dae isi malole. Bini la sila lanumbu de ala inahuu losa labuna laboa. Hambu nggelok buna-boan laꞌi telu hulu, hambu laꞌi nee hulu, ma hambu losa laꞌi natun esa. ");
INSERT INTO llg_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","De laꞌe neu see ndia fo kandiꞌidook, na mamanene matalolole baa!” ");
INSERT INTO llg_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Basa boe ma ledoeik Yesus mesa kana, boe ma Ndia ana mana tungga kasanahulu dua nala sila, lo hataholi feꞌek hida fo lamanene basa nanonolin ndia so, ala mai latonggo lon. Ala loken, fo, nafada fee sala nakandandaak ndia sosoan. ");
INSERT INTO llg_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Boe ma Yesus nataa nae, “Huu ei mahiik bubuluk tebe-tebe Manetualain palendan, de Au afada memak nakandandaak ndia sosoan. Tehuu mete ma hataholi feꞌek na, Au anoli unik kada nakandandaak. ");
INSERT INTO llg_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Hataholi feꞌek kala sila, na, sama leo Manetualain hataholi mana kokolan sulak memak lae, ‘Ala lita so, tehuu taa nau lalela kana. Ala lamanene so, tehuu taa nau bubulu kana. Nemenaa fo boso ala lamahele leu Lamatuak, suek Lamatuak taa paluu fee sala ambon neu sala nala so.’ ” ");
INSERT INTO llg_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Basa boe ma, Yesus nafada sala nakandandaak ndia sosoan, nae, “Wei! Mete ma ei bei taa malelak nakandandaak ia sosoan, na neme bee mai ei bisa malelak nakandandaa feꞌe kala sosoan? ");
INSERT INTO llg_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","De nakandandaak ndia sosoan leoiak: hataholi mana ngganggali bini ndia, sama leo hataholi fo mana tui-bengga Manetualain Dedeꞌa-kokolan. ");
INSERT INTO llg_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ma bini fo mana tuda lai dalak lain, fo mbui kala laꞌa heni sala, na sama leo hataholi fo lamanene Manetualain Dedeꞌa-kokolan. Tehuu taa dook boe, tehuu malangga nituk mai, de ana haꞌi neni Manetualain Dedeꞌa-kokolan sila, leme hataholi dalen mai. ");
INSERT INTO llg_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Bini mana tuda lai dae batu ndia, sama leo hataholi fo namanene ma ana simbok Manetualain Dedeꞌa-kokolan ndia no namahokok. ");
INSERT INTO llg_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Tehuu Dedeꞌa-Kokolak sila taa laoka. Huu ndia de Dedeꞌa-Kokolak sila taa nana mbeda nala dook lai hataholi ndia dalen. Ledoeik hataholi feꞌek tao lakatotoꞌa kana huu ana simbok Dedeꞌa-Kokolak ndia, boe ma tuti kana ana mboꞌi heni Dedeꞌa-kokolak ndia. ");
INSERT INTO llg_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ma bini fo mana tuda lai fii la laladan ndia, sama leo hataholi fo namanene basa Dedeꞌa Kokolak sila so. ");
INSERT INTO llg_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Tehuu kada ana nasambute no dedeꞌa mata-mata kala, fo suek nasoda nenik kada lole-lada daebafok. De basa dedeꞌa kala sila, seti heni Lamatuak Dedeꞌa-kokolan leme dalen mai, de sosoan taa fa boe. ");
INSERT INTO llg_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Tehuu bini fo mana tuda lai dae isi malole ndia, sama leo hataholi mana pasa ndiꞌidoon, de ana simbok Dedeꞌa-Kokolak sila ma ana tungga Lamatuak hihii-nanaun. Boe ma ana tao kada dedeꞌa malole, sama leo bini mana maboak ndia. Hambu luma labuna-laboa laꞌi telu hulu, hambu laꞌi nee hulu, ma hambu laꞌi natun esa.” ");
INSERT INTO llg_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesus kokolak nakandoo neme ofak ndia lain mai. Ana fee nakadaik nakandandaak esa seluk bali, nae, “Leo bee! Ei mita mitak do taa, hataholi dede nala bandu anak, boe ma ana tatanan nenik lembeneu! Do ana taon neu mamana susungguk sosolon! Taa hetu maa? Mete ma mbeꞌdan leondiak, na, manggaleꞌdon taa so. Hataholi la musi mbeda banduk neu mamana madema, fo suek manggaledok. ");
INSERT INTO llg_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","De hata fo nana funik nai hatematak ia, neu ko nana nitak. Hata fo hatematak ia, hataholi bei taa bubuluk, neu ko nana bubuluk. ");
INSERT INTO llg_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","De laꞌeneu see ndia fo kandiꞌidook, na mamanene neulalau!” ");
INSERT INTO llg_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Duduꞌa matalolole! Mete ma ei uku hataholi feꞌek tataon, na, neu ko hataholi uku ei leo ndiak boe. Ma Manetualain boe oo, uku nasafali ei leo ndiak. Tehuu Ndia uꞌukun belan seli bali. ");
INSERT INTO llg_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Mete ma hataholi nau sangga bubuluk tebe-tebe Lamatuak hihii-nanaun, na malelan boe tamba. Tehuu mete ma hataholi taa tao aꞌafik neu Lamatuak hihii-nanaun, na boe namanggoa.” ");
INSERT INTO llg_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Basa boe ma Yesus kokolak nakadaik nae, “Manetualain nusa palendan boe, inahuu sama leo bini fo hataholi ngganggalin nai osin. ");
INSERT INTO llg_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Leomae hataholi ndia fali, boe ma ana sunggu, de, nafalende heni bini ndia so. Tehuu bini ndia nanumbu ma ana boe inahuu nakandoo. ");
INSERT INTO llg_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Tehuu bini ndia moli aon nai dae, boe ma nandana, nabuna, losa naboa. ");
INSERT INTO llg_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Mete ma hade namatasa so, na, maosik nalelak kada ana mai, fo, ketu-kolu leo. Manetualain nusan palendan boe oo, leondiak. Basa sila, Lamatuak mesa kana tatao-nonoin ndia.” ");
INSERT INTO llg_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Basa ndia, boe ma Yesus kokolak nakadaik nae, “Au akadaik seluk nakandandaak esa bali, leoiak: ei bisa makasasama Manetualain hataholi nala. Ala mulai kada lumak, tehuu tamba faik boe lama noꞌu. ");
INSERT INTO llg_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ndia sama leo ai deꞌe kadiꞌi anak. ");
INSERT INTO llg_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Mete ma ita sele ai deꞌek ndia, na ana moli, ma ana dadi neu ai inahuuk nalan seli. Boe ma mbui kala mai sangga saꞌok fo landunu leu ndia.” ");
INSERT INTO llg_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ndia, fo, Yesus dala nanonolin neu sala, tungga sila nalelela nala. ");
INSERT INTO llg_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ana nateme pake nakandandaak mete ma nanoli sala. Tehuu mete ma neu Ndia ana mana tungga nala, na, Ana nafada basa dedeꞌa nakandandaak ndia sosoan. ");
INSERT INTO llg_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ledo bobon ndia, Yesus bei nai ofak lain. Boe ma Ana nadenu ana mana tungga nala nae, “Mai fo ita teni dano selik teu.” ");
INSERT INTO llg_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Basa boe ma ala saꞌe ofak noꞌu lo Yesus. De ala laꞌo ela hataholi nou kala sila leme ndia. Tehuu hataholi luma saꞌe ofa feꞌek. ");
INSERT INTO llg_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","38","Faik ndia Yesus ndae langgan neu kailunu lain, de Ana sunggu namanee neme ofa iko. Bei taa dook boe, tehuu ani sanggu mai. De lii mbuka nakandoo neni ofak dale neu, losa hihii henun. De ana mana tungga nala ala bii lalan seli. Boe ma ala mai fafae lafoꞌa Yesus de lae, “Ama aa! Foꞌa dei! Ita sangga bolo ia so! Tehuu Ama taa tao mbambalik neu ai!” ");
INSERT INTO llg_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Namanene leo ndia, boe ma Yesus foꞌa, de nadenu ani nae, “Nee-nee!” Boe ma Ana palenda dano nae, “Ndoo-ndoo leo!” Ani ndia hahae tutik, ma dano boe oo ndoo-ndoo memak. ");
INSERT INTO llg_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Basa boe ma Yesus nafada ana mana tungga nala nae, “Hatina de ei basa nggei bii leo iak? Ei taa mamahele Au do?” ");
INSERT INTO llg_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Basa sala bii ma heran, boe ma lakokola lae, “Ndia ia see bae? Losak ani no lii lamanene Ndia, bae maa!” ");
INSERT INTO llg_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Basa boe ma, Yesus no ana mana tungga nala losa Dano Galilea selik, fo, nai mamanak esa nade Garasa. ");
INSERT INTO llg_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","6","Nai mamanak ndia, hambu tou nitu nalak esa, losa namulu. Ana leo nai late sala. Leledo-leꞌodaen ana nakahola ma nafeok lete mbumbuku kala malai ndia, fo nakau nakandondoo henin. Ma ana tutu nihina aon nenik batu. Tehuu ndia balakain ana seli. Taa hambu hataholi esa bisa hengge nalan, leo mae ala henggen lenik tali besi boe. Hataholi la, hengge lima ein taa-taa lenik tali besi, tehuu ana tao naketu heni tali besi ndia ma ana tao natepa besi lalangge ein. Ndia balakain ana seli, losak taa hambu hataholi esa boe ana nakalee nalan. Ledoeik Yesus asa konda leme ofak lain mai, de bei heta ein neu madak lain, tehuu tutik tou kamuluk ndia nita sala neme dook mai. Basa boe ma ana neme late sala mai de nalaik neu sendek lunggu-langgan neu Yesus matan. ");
INSERT INTO llg_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Yesus nita touk ndia matan leondia, boe ma Yesus nafada, nae, “Wei! Nitu manggalauk! O kalua muma hataholi ia mai leo!” Boe ma, hataholi ndia nakau natingga nalan seli, nae, “Wei! O sangga tao au leobeek ia! Au bubuluk O ia Yesus, fo Manetualain mana koasa nai lain seli Anan. Au hule fo O boso tao doidoso au, baa!” ");
INSERT INTO llg_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Boe ma Yesus natanen nae, “O naden see?” Hataholi ndia nataa nae, “Au nadeng Legion, huu ai makadotok nalan seli, sama leo batalion noꞌuk!” ");
INSERT INTO llg_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Boe ma nitu la pake hataholi ndia, fo noke Yesus, fo, Ana boso fee sala kalua leme mamanak ndia mai. ");
INSERT INTO llg_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Taa dook neme mamanak ndia mai, hambu hataholi hida lanea bafi lalae esa. Bafi la sila meda lifun dua. Ala totofi nanaꞌak lai letek bifin. ");
INSERT INTO llg_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Basa boe ma, nitu la sila loke Yesus lae, “Madenu ai mini bafi la sila dalek miu.” ");
INSERT INTO llg_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Namanene leo ndia, boe ma Yesus nakaheik. Tutik nitu la sila, kalua leme hataholi ndia dalek mai, de ala maso leni bafi la sila dalek leu. Boe ma bafi lifu kadua kala sila, lalai lapoka kala loe tungga letek bifin losa dano dale, de basa sala bolo mate leme ndia. ");
INSERT INTO llg_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Lita leondia, boe ma basa hataholi mana manea bafi sila bii lalan seli. Basa boe ma ala lalai leu lafada basa hataholi ndule basa nggolo malai ndia kala. Boe ma hataholi noꞌu kala mai fo sangga lita hata mana dadik ndia so. ");
INSERT INTO llg_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ala mai latonggo lo Yesus, ma lita tou kamuluk ndia nanggatuuk nai ndia. Duduꞌa namaneu so, ma ana pake baloꞌas so. Lita leondia, boe ma basa hataholi la sila bii, huu ala bubuluk, see ndia bisa husi kalua heni nitu makadotok leme hataholi ndia mai, na, memak hataholi ndia ana seli. ");
INSERT INTO llg_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Basa boe ma ala tui lafeok esa no esa lae, sila lita lo mata heheli nala, tou kamuluk ndia hai so, ma bafi la bolo mate sala so. ");
INSERT INTO llg_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Boe ma nggolok ndia hataholi nala mai loke fo Yesus kalua laꞌo ela sila mamanan ndia. ");
INSERT INTO llg_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Leꞌdoeik Yesus sangga saꞌe neni ofak dale neu, boe ma touk fo isinaak nitu nalak ndia, ana mai noke Ndia fo ana nau tunggan boe. ");
INSERT INTO llg_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Tehuu Yesus taa nau. Ana nafadan, nae, “Malolenak o fali, fo mafada basa o bobonggi mala, hata fo Manetualain taon neu o so. Ma mafada sala mae, Manetualain sue o nalan seli.” ");
INSERT INTO llg_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Basa boe ma hataholi ndia fali de ana laꞌok ndule basa nusa esa ma kota sanahulu fo lateme loke lae, ‘Dekapolis’. Ana tui-bengga hata fo Yesus taon neu ndia so. Basa hataholi la fo mana mamanene tutuik ndia ala heran lalan seli, de lae. “Memak tetebes, bae maa!” ");
INSERT INTO llg_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Basa ndia boe ma Yesus asa fali seluk leni dano selik leu. Ala konda leme ofak lain mai, tehuu hataholi makadoto kala mai lakaseseti lala Ndia. ");
INSERT INTO llg_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Touk esa nade Yairus nai ndia boe. Ndia ndia malangga uma huhule-haladoik nai kota ndia. Ledoeik ana nita Yesus, boe ma ana sendek lungulanggan neu Yesus matan, ");
INSERT INTO llg_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","de, noke taa-taa, nae, “Ama aa! Au ana inanang bei fo teuk sanahulu dua, namahedi belak. Ama tulun mai fo tao mahain dei!” ");
INSERT INTO llg_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Boe ma Yesus tungga Yairus neni uman neu. Tehuu ala mulai laꞌok boe ma hataholi noꞌu kala tungga Ndia, losa ala laka seseti lala Ndia leme kii-konak mai. ");
INSERT INTO llg_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Nai hataholi sila laladan, hambu inak esa, ana hambu bulak tehuu daan taa mada ndoos losa teuk sanahulu dua ia, so. ");
INSERT INTO llg_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ana nabasa doin ma hata nala, fo bae neu dotel. Tehuu taa hambu esa tao nahain boe. Tehuu hedin ndia boe namabela nakandoo. ");
INSERT INTO llg_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","29","Inak ndia namanene tutuik noꞌun seli laꞌeneu Yesus. De, ana nakaseseti neu hataholi makadotok sila laladan, de sangga neu deka-deka no Yesus dean. Ana duduꞌa nai dalen, nae, “Sadi kada au bisa daba laꞌe Ndia badun, na, au hai ndia so!” Ledo eik ana daba laꞌe Yesus badun, boe ma tutik daan mada. De ana nameda hai ndoos so. ");
INSERT INTO llg_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Nandaa no ledoeik ndia, Yesus nameda balakain kalua neme aon dale mai. Boe ma Ana suli dea neu, de Ana mete neu hataholi makadoto kala sila. Basa de natane sala nae, “Ei see ndia daba laꞌe Au badung?” ");
INSERT INTO llg_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ana mana tungga nala lataa lae, “Ama mete aom leo! Hataholi desi-desi ia, de lakaseseti aok. De Ama matane sala mae, ‘See ndia daba laꞌe Au badung?’ ” ");
INSERT INTO llg_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Tehuu Yesus mete ndule sala, fo Ana sangga bubuluk isinaak see ndia daba laꞌe Ndia. ");
INSERT INTO llg_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Inak ndia namanene Yesus natane leo ndia, boe ma ana bii nalan seli. Basa boe ma ana sendek neu Yesus matan, de nataa nae, “Ama! Au ndia daba laꞌe Ama badun.” ");
INSERT INTO llg_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Boe ma Yesus nataan nae, “Huu ina mamahehele tebe-tebe neu Au, de ina hai ia so. Hatematak ia, ina fali no namahokok leo.” ");
INSERT INTO llg_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesus bei kola-kola nae leo ndia, boe ma hataholi esa neme Yairus uman mai, de nafada nae, “Kasian, inanak maten so. De boso tao makasosotak Ama Mesen fo Ana boso neu bali.” ");
INSERT INTO llg_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Tehuu Yesus taa mbali hataholi ndia kokolan. De, nafada Yairus, nae, “O boso bii, kada mamahele neu Lamatuak leo.” ");
INSERT INTO llg_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Boe ma Yesus laꞌo ela ana mana tungga nala nggelok. Tehuu Ana noo Petrus, Yakobis ma fadin Yohanis, de ala laꞌok lakandoo. ");
INSERT INTO llg_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ledoeik ala losa Yairus uman, boe ma ala lita hataholi noꞌuk langgilo lalan seli, ma lamanene lakaleleu. ");
INSERT INTO llg_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yesus maso dalek neu. Boe ma Ana natane sala, nae, “Hatina de ei manggilo ma makaleleu leoiak? Kakanak ia taa maten. Kada ana sunggu ndia.” ");
INSERT INTO llg_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Lamanene Yesus kokolan leondia, boe ma ala hika haumeme Ndia. Basa boe ma Ana nadenu basa sala leni deak leu. Boe ma Ana noke nala kakanak ndia aman ma inan, ma ndia ana mana tungga katelun, de basa sala maso leni inanak ndia kaman dale leu. ");
INSERT INTO llg_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Boe ma Yesus toꞌu nala inanak ndia liman, de Ana kokolak nenik sila dedeꞌa Aram nae, “Talita kum!” (Sosoan nae, “Inanak aa! Foꞌa leo.”) ");
INSERT INTO llg_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","43","Nggengge neuk, inanak ndia foꞌa, de ana mulai laꞌok. Boe ma Yesus nafada inan, nae, “Fee kakanak ia naꞌa leo!” Basa hataholi mana lita hata fo mana dadik ndia, ala heran lalan seli. Tehuu Yesus kaꞌi nisa kasa nae, “Ei boso mafaꞌda esa boe mae, Au tao asoda falik inanak ia so.” ");
INSERT INTO llg_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Basa boe ma, Yesus no Ndia ana mana tungga nala fali leni Yesus nggolon Nasaret leu. ");
INSERT INTO llg_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Nandaa laꞌeneu hataholi Yahudi la fai huhule-haladoin, de Yesus maso neni uma huhule-haladoik dalek neu, de nanoli. Faik ndia, hataholi noꞌu kala leu hule-haladoi. Ledoeik lamanene Ndia nanonolin, boe ma ala heran lalan seli, de lae, “Hataholi ia malelan seli maa! Ndia boe oo, naena koasa maa! Talobee de Ana leondiak? ");
INSERT INTO llg_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Naa te Ndia kada tuka ai. Ita talelak inan Maria; ma Ndia fadi nala, fo ndia Yakobis, Yoses, Yudas, ma Simon. Ndia boeoo, fadi inanan hida boe. Ita basa nggata leo nai nggolok esa naa!” Huu ndia, de ala dale hedin de ala taa nau lamanene Ndia so. ");
INSERT INTO llg_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Boe ma Yesus nafada, nae, “Memak tetebes! Hataholi lahiik fee hada-holomata, neu Manetualain mana kokolan fo maneme mamana feꞌek mai, lena heni manai nggolo hehelin.” ");
INSERT INTO llg_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6a","Tehuu hataholi sila dale nala lakababatu, losa tala nau lamahele Yesus so. Huu ndia, de Ana heran, boe ma Ana taa pake Ndia koasan bali nai ndia so. Kada Ana tao nahai hataholi kamahedik esa do duak. ");
INSERT INTO llg_vpl VALUES ("MK6_6b","071_6_6b","MRK","6","6b","6b","Basa boe ma, Yesus laꞌok ndule basa nggolo mana deka kala, fo nanoli hataholi la Manetualain hihii-nanaun. ");
INSERT INTO llg_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ana noke nala Ndia ana mana tungga kasanahulu dua nala, de nadenu sala laꞌok dua-duak, fo leu lafada Manetualain Hala Malolen. Ndia boe oo, fee sala koasa fo husi heni nitu. ");
INSERT INTO llg_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Ana palenda sala, nae, “Ei boso mini noꞌuk nai nai dalak. Boso mini lepa, doik, ma tas. Mini teteꞌe-aik, ma tabueis manai ei ei mala, ma kada badu esak. ");
INSERT INTO llg_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Mete ma hataholi simbok ei nai uman, na, ei musi leo nai ndia, losa ei lao seluk. ");
INSERT INTO llg_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ma mete ma ei losa nai mamanak esa, boe ma hataholi malai sila kala, taa nau simbok, ma taa nau lamanene ei, na laꞌo ela mamanak ndia. Basa na, mafada sala, mae, ‘Ei taa nau mamanene, na, ela ei lemba aom ei natataam ndia!’ ");
INSERT INTO llg_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Basa boe ma, ala tungga leu tui-bengga Hala Malole ndia. Ala lae basa hataholi la musi hahae leme sila sala-singgo nala mai leo, fo basa na, fali fo lasoda tungga Manetualain hihii-nanaun. ");
INSERT INTO llg_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Boe ma ala husi kalua heni nitu la. Basa ndia, na, ala tao mina neu hataholi kamahedi kala langgan, fo ala hule-haladoi fee sala. De, ala hai memak. ");
INSERT INTO llg_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Faik ndia, hataholi lai sudi bee mesan, lalelak Yesus so. Tutuik laꞌeneu Ndia koasan ndia boe oo, ana losa Mane Herodes ndiꞌidoon boe. Hambu hataholi lae, “Yohanis Mana Salanik ndia, nasoda falik nai Yesus aon dale! Huu ndia, de Ana bisa tao basa tanda hera nala sila.” ");
INSERT INTO llg_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Tehuu hataholi feꞌe kala bali na lae, “Taa! Elia ndia nasoda fali nai Ndia aon dale. Do Manetualain mana kokola feꞌen esa neme makahulun mai.” ");
INSERT INTO llg_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Tehuu ledoeik Mane Herodes namanene hataholi la kokolak laꞌeneu Yesus leo ndia, boe ma ana nataa, nae, “Neu ko Yohanis Mana Salanik fo fain au fee tete lala langgan ndia ia. Hatematak ia nasoda fali seluk so, maa!” ");
INSERT INTO llg_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Mane Herodes nadenu leo ndiak, huu ana hambu dedeꞌa inahuuk no Yohanis. Tutuin leo iak. Fai maneuk ele, Mane Herodes sao nala fadin Filipus saon, nade Herodias. Naa te Filipus no Herodias bei taa lamaketu. Huu ndia de Yohanis ana kaꞌi taa-taa, nae, “Ama Manek taa bole sao mala fadim saon. Huu tatao leo ndiak ndia, na, Ama laꞌolena ita hada Yahudin so.” Tehuu Herodes kada sao nahele inak ndia. Basa boe ma, ana fee hataholi leu humu lala Yohanis de ala teen neni bui dale neu. ");
INSERT INTO llg_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Huu Yohanis kaꞌi taa-taa leondiak, de inak ndia nambeda dalek neun fo ana sangga dalak fo ana tao nisan. Tehuu ana bei taa hambu lelak, huu Mane Herodes taon neni bui dale neu so. ");
INSERT INTO llg_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Boe ma Ana fee soldadu la lanea lahelen. Memak Mane Herodes bii Yohanis. Huu ana bubuluk Yohanis ndia, na, Manetualain nadenun mai so. Ma ndia boe oo, hataholi malole. Memak Mane Herodes nahiik namanene Yohanis dedeꞌa-kokolan. Tehuu laꞌi-laꞌi esa, na, dalen taa malole no Yohanis dedeꞌa-kokolan. ");
INSERT INTO llg_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Basa ndia, boe ma faik esa, ina Herodias hambu fai lelak fo bala dale hedin. Faik ndia, ala tao Mane Herodes fai bobonggin. Ala hoka hataholi inahuu nala fo ala mai laꞌa feta fai bobonggik ndia. Mana maik sila, na hataholi mana palenda la, malangga soldadu la, ma nusa Galilea lasi haꞌda nala. ");
INSERT INTO llg_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Neu feta laladan, boe ma Ina Herodias anafeꞌon neu longge. Ndia lolonggen lolen seli, losa ana tao namahoko Herodes ma ndia nana hoka nala Boe ma Mane Herodes noke nalan de natanen nae, “O nau moke au hata, na, kada mafada leo! Dei fo au fee o. ");
INSERT INTO llg_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Leomae o moke baꞌe duak au nusa palendang boe oo, au fee o. Au soo neu Manetualain naden!” ");
INSERT INTO llg_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Boe ma inanak ndia neu natane inan nae, “Ina aa! Ina duduꞌan, na, au oke hata fo neulaun seli neme ama mai?” Boe ma inan nataa nae, “Naaa! Muu fo moke Yohanis langgan.” ");
INSERT INTO llg_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Basa boe ma, inanak ndia lai-lai neni Herodes neu, de nae, “Ama aa! Au oke fo leni fee au Yohanis langgan, fo mbedan neu dulang esa dalek. Hatematak ia leo!” ");
INSERT INTO llg_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Mane Herodes namanene leondia boe ma tutik tenden ana bokak. Tehuu ana taa bisa hela falik ndia sumba-soon so, huu basa hataholi la lamanene basan so. ");
INSERT INTO llg_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Basa boe ma, ana palenda malangga soldaꞌdu esa, neu tete neni Yohanis langgan neme bui dale mai. ");
INSERT INTO llg_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Boe ma ala tete lala Yohanis langgan, de ala taon neu dulang esa dalek, boe ma lenin neu inanak ndia. Ana simbo nala dulang ndia, boe ma ana koꞌo nenin neu inan. ");
INSERT INTO llg_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ledoeik Yohanis ana mana tungga nala lamanene lae ala tete leni Yohanis langgan, de leu haꞌi lala mbombolan de leu latoin. Yohanis mamaten tutuin kada leondiak. ");
INSERT INTO llg_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Faik esa, boe ma Yesus ana mana tungga nala fo nadenu sala leu ndia, basa sala lakabubua seluk lo Ndia. Ala tui basa hata fo ala taon so, ma hata fo lanoli hataholi la so. ");
INSERT INTO llg_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Tehuu faik ndia hataholi noꞌu kala laꞌok leu mai sangga Yesus. Losak Yesus no ana mana tungga nala taa lalak laꞌa so. Boe ma Yesus nafada ana mana tungga nala nae, “Mai fo teu sangga mamana linok fo ita bisa hahae aok tala faa dei, ma.” ");
INSERT INTO llg_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","De, basa sala hene leni ofak dale leu, de leu sangga mamana linok, fo, dook neme nggolok mai. ");
INSERT INTO llg_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Tehuu hataholi makadoto kala sila lita Yesus ofan tungga dano bifin. Boe ma ala kalua leme nggolok dale mai, tungga dala madak lain, de ala losa lakahuluk Yesus asa. ");
INSERT INTO llg_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ledoeik Yesus konda neme ofak lain mai, boe ma nita hataholi noꞌuk lahani Ndia so. Boe ma dalen tuda kasian neu sala, huu ala taa bubuluk tao leo bee so, leo bali biꞌilombo fo mana hoon taa. Boe ma Ana nanoli sala Manetualain hihii-nanaun, ");
INSERT INTO llg_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","neme leledon mai losa bobok. Boe ma Yesus ana mana tungga nala lafada Ndia lae, “Ama aa! Malolenak Ama madenu basa hataholi la ia, fo leu hasa nanaꞌak nai nggolo-nggolo mana dekak lai ia. Huu ledo bobok ia so, de taa hambu nanaꞌak nai ia so.” ");
INSERT INTO llg_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Tehuu Yesus nataa nae, “Bosok! Kada ei ndia fee sala laꞌa.” Tehuu latane lasafalin lae, “Awii! Mete ma ita fee hataholi noꞌuk leoia laꞌa, na, ita musi kalua doik makadotok nalan seli! Sama leo tukan esa nggadin teuk esa! Neme bee mai, ita bisa hambu doik noꞌuk leondiak!” ");
INSERT INTO llg_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Boe ma Yesus nataa, nae, “Miu matane sudi kasa dei, see neni lepa-ngge.” Basa boe ma leu latane sala de ala fali mai lafada lae, “Hambu kada loti lima ma iꞌak boak dua.” ");
INSERT INTO llg_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Basa boe ma, Yesus nadenu basa hataholi la sila langgatuuk lakabubua leu naꞌu lain. ");
INSERT INTO llg_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Boe ma leu langgatuuk lakabubua. Hambu lakabubua hataholi natun bekeꞌesak, ma hambu luma beke lima huluk. ");
INSERT INTO llg_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Basa de, Yesus haꞌi nala loti ka lima kala, ma iꞌa boak kadua kala sila. Boe ma Ana nasale lalai neu, de noke makasi neu Manetualain. Basa ndia, boe ma Ana bibiꞌi loti sila de Ana loo fee sala leu Ndia ana mana tungga nala, fo leu babaꞌe sala leu basa hataholi la sila. Ana babaꞌe iꞌa boa kadua kala sila boe. ");
INSERT INTO llg_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Basa de basa sala laꞌa losa lakabete. ");
INSERT INTO llg_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Laꞌa basa, boe ma Ndia ana mana tungga nala, leu lakabubua lala nanaꞌa lena kala, de henu lembeneu sanahulu dua. ");
INSERT INTO llg_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Meda hataholi lifun lima. Ala bei hingga kaꞌda tou mana naꞌa kala. Tehuu bei taa hingga tamba ina kala ma kakana kala. ");
INSERT INTO llg_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Basa ndia, boe ma Yesus nadenu ana mana tungga nala, leu saꞌe ofak lakahuluk leni nggolok Betsaida, nai dano selik ele leu. Tehuu Ndia bei nai ndia, de nadenu hataholi la sila fali leo. ");
INSERT INTO llg_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ledoeik basa sala fali, boe ma Ana ndaꞌe neni letek esa lain neu, de Ana hule-haladoi. ");
INSERT INTO llg_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","50","Ledoeik leꞌodae so, boe ma Yesus konda fali. Ana nita ana mana tungga nala ofan losa nai dano laladan so. Tehuu ala sefe sota lalan seli, huu ofak laban ani solu. Ledoeik lolembilak, boe ma Yesus neu tungga sala. Tehuu kada Ana laꞌok nesik oe bafon. Ledoeik Ana sangga laꞌo seli ofak ndia, boe ma ala lita Ndia. Ala nggengge lalan seli. Boe ma latatane aok lae, “Awii! Hata ia? Nitu do hata?” Tehuu Yesus kokolak nakandoon, nae, “Wei! Ei boso bii, baa! Au ndia ia.” ");
INSERT INTO llg_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ledoeik Yesus hene neni ofak dale neu, boe ma ani nakamate tutik. Ndia ana mana tungga nala heran lalan seli. ");
INSERT INTO llg_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Dei fo ala lita Yesus pake koasan, fo Ana fee hataholi lifu kalima lena kala laꞌa. Tehuu ala bei taa bubuluk tebe-tebe Yesus koasan, huu dale nala bei lakababatu. ");
INSERT INTO llg_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ledoeik ala losa dano selik, boe ma ala see leu kota Genesaret tasi bifin. ");
INSERT INTO llg_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ledoeik ala konda leme ofak lain mai, tehuu hataholi noꞌu kala lita sala so. Boe ma ala bobouk lae, “Wei! Yesus mai so, bou.” ");
INSERT INTO llg_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","56","Sila basa sala lalai ndule nggolo kala, de leu hoka lafeok, boe ma hataholi la ndolo loo basa hataholi kamahedi kala mai. Kekeꞌun neu, sadi lamanene Yesus nai mamanak esa, na, basa sala ndolo leni basa hataholi kamahedi kala fo lakambembeu sala leu mook ndia. Ala duduꞌa nai dale nala dalek lae, “Sadi hataholi kamahedi kala sila daba laꞌe Yesus badu mbedan, na, neu ko ala hai ndia so.” Daba leondiak, boe ma ala hai tutik. ");
INSERT INTO llg_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Hambu hataholi Farisi bubuak esa lo mese anggama hida leme Yerusalem mai, fo latonggo lo Yesus. ");
INSERT INTO llg_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","5","Hataholi Farisi la sila, toꞌu lahele sila hada Yahudin. Leo, mete ma hataholi sangga laꞌa-linu, na, musi lafui oe tungga hadak hihiin. Leondiak boe oo, mete ma ala fali leme pasak mai, na, musi ladiu oe dei. Losak sila bua dapu heheli nala, leo ulek, pinggak, nggalas, cerek, musi safe sala tungga hadak hihiin, bei fo bole laꞌa-linu lenik. Mete ma hambu hataholi Yahudi feꞌek taa tungga sila hadan, na, hataholi Farisi la manggalau sala. Huu ndia, de ala manggalau neu leꞌdoeik ala lita Yesus ana mana tungga nala laꞌa-linu tehuu taa lafui oe tungga hadak hihiin. Boe ma ala mai, fee salak neu Yesus lae, “Hatina de o ana mana tungga nala laꞌa-linu, tehuu taa lafui oe dei? Ndia laban ita bei-baꞌi nala hadan!” ");
INSERT INTO llg_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","7","Boe ma Yesus nataa nae, “Ei ia, memak hataholi fo kokolak feꞌek, tehuu tao feꞌek. Neme makahulun mai, Baꞌi Yesaya sulak Manetualain Dedeꞌa-kokolan so, nae, ‘Hambu hataholi koa-kio Au, no kada bafan, tehuu taa no dalen. Ala tao leo ndiak boe oo sosoan taa. Te tala mbali Au hihiing. De ala tungga kada hataholi hihii-nanaun.’ Ei boe oo, sama leo ndiak. ");
INSERT INTO llg_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","9","Ei laꞌo ela Manetualain palendan so, fo tungga kada hataholi hadan. Memak ei malelan seli tao leondiak! ");
INSERT INTO llg_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Makahulun ele, Baꞌi Musa nafada basa Manetualain palendan so, nae, ‘Fee hada-holomatak neu ei inam ma amam.’ Boe ma tamba bali nae, ‘Mete ma hataholi esa aꞌali aman do inan, na musi huku nisa ndia.’ ");
INSERT INTO llg_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Manetualain nanoli leo ndiak, tehuu ei manoli feꞌek bali. Ei mae, ‘Mete ma hataholi helu nae ana fee hata esa neu Manetualain, na, leomae inan ma aman toꞌa-taa lalan seli boe oo, tehuu taa bole pake hata ndia fo tulu fali sala, huu helu basa so, fo sangga feen neu Manetualain.’ ");
INSERT INTO llg_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Huu ndia de isinaak, Au afada basa so, ae ei nggali heni Manetualain hihii-nananaun, fo ei nggati neu heti-heu beuk. Hambu ei nggati heti-heuk noꞌuk leondiak so.” ");
INSERT INTO llg_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Basa boe ma, Yesus noke nala hataholi feꞌek kala malai ndia kala, de nafaꞌda nae, “Pasa ei ndiꞌidoo mala dei, fo ei bubuluk. ");
INSERT INTO llg_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Hata fo maso neni hataholi tein dale neu, taa neni manggenggeok faa boe. Tehuu hata fo ana kalua, na, ndia dei fo tao manggenggeok. ");
INSERT INTO llg_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Naa, see kandiꞌi-dook, na, mamanene neulalau baa!” ");
INSERT INTO llg_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Basa boe ma, Yesus no ana mana tungga nala laꞌo ela hataholi la sila, de ala maso leni uma esa dalek leu. Boe ma, Ndia ana mana tungga nala latanen nakandandaak ndia sosoan. ");
INSERT INTO llg_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yesus nataa nae, “Ei taa bubuluk boe do? Ndia maksud leoiak: hata fo hataholi naꞌan, na ndia malole. Tehuu mana kaluak ndia, taa malole. ");
INSERT INTO llg_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Hata fo ita taꞌan, fo masok neni ita tein dalek neu, basa na kalua seluk bali. (Lamatuak Yesus maksud nae, hataholi bole naꞌa suꞌdi hata. Taa nana kena-kaꞌik.) ");
INSERT INTO llg_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Hata fo ana kalua neme hataholi dalen dale mai, na, ndia dei fo neni manggalauk, losa Manetualain nunuten, ma taa nau nakabubua non. ");
INSERT INTO llg_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Huu dedeꞌa manggalauk noꞌu kala kalua leme hataholi dalen dale mai! Sama leo: duduꞌa manggalauk, tao eok no hataholi, fo ndia taa sao inan do sao toun, namanaꞌo, nakanisa hataholi, ");
INSERT INTO llg_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","balenaꞌo, hohongge, tatao manggalauk, pepekok, tungga aombaa kasuun, dale hedi, kokolak tao natuda hataholi, koaok, taa kalela haꞌdak, ma langga batuk. ");
INSERT INTO llg_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Basa dedeꞌa manggalauk leo sila kala, kalua leme hataholi dalen dale mai. Ndia ndia tao nakalulutu ndia. De Manetualain boe oo, nunuten.” ");
INSERT INTO llg_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Basa boe ma, Yesus asa laꞌo ela mamanak ndia, de leni kota esa leu, nade Tirus. Losa ndia boe ma ala leni uma esa dalek leu, huu Yesus Ana taa nau hataholi bubuluk Ndia nai mamanak ndia. Tehuu Ana taa bisa kekek. ");
INSERT INTO llg_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Nai ndia boe oo, hambu inak esa taa hataholi Yahudi. Ala bonggin neme nggolok Fenisia nai nusa Siria ele. Namanene Yesus mai, boe ma neu noke Yesus, fo, husi heni nitu manggalauk neme ana inanan dalek mai. ");
INSERT INTO llg_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Tehuu Yesus nggali kokolak nae, “Kakana-kala musi laꞌa lakahuluk bei fo nanaꞌa elak nggali feen neu busa la.” (No maksud nafufunik nae, Yesus tulu-fali nakahuluk ndia hataholi Yahudi nala dei, bei fo bisa tulu-fali hataholi feꞌe kala). ");
INSERT INTO llg_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Tehuu inak ndia bala nae, “Tetebes, Ama! Tehuu busa ndia, nai mei sosolon. De ndia boe oo, naꞌa nanaꞌak fo mana tuda neme kakanak ndia pinggan dale mai.” (No maksud, nae, ledoeik fo kakana kala laꞌa, na, busa boe oo, hambu naꞌa. Leomae Yesus tulu-fali Ndia hataholi nala, tehuu Ana musi mbali hataholi feꞌek boe). ");
INSERT INTO llg_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Namanene leo ndia, boe ma Yesus nafada, nae, “Awii! Ina kokolan ndaan nalan seli so! De ina fali muu nggo leo, huu nitu ndia kalua neme ina anan ndia dalek mai so.” ");
INSERT INTO llg_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Boe ma, inak ndia fali. Ana losa uman naa te, anan sunggu namanee. Memak nitu ndia kalua so. ");
INSERT INTO llg_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Basa ndia boe ma, Yesus asa laꞌo ela kota Tirus, de ala laꞌok tungga tasibifi, de lesik kota Sidon. Neme ndia mai, ala laꞌok lakandoo losa dano Galelea. Basa boe ma ala laꞌo leni nusak esa, ma kota sanahulu fo lateme loke lae ‘Dekapolis’ leu. ");
INSERT INTO llg_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Nai ndia hambu hataholi hala taak ma mbake esa. Ndia nonoo nala loon leni Yesus neu. Ala loke fo Yesus lalaa liman neu langgan lain fo tao nahain. ");
INSERT INTO llg_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Boe ma Yesus laꞌo ela hataholi makadoto kala sila, de mesa kana neu no hataholi ndia. Yesus tao lima kuꞌun neni hataholi ndia ndiꞌidoon ddua sala dalek neu. Basa de, Ana tao ambe neu lima kuꞌun, de nafaloe hataholi ndia maan. ");
INSERT INTO llg_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Boe ma Yesus nasale lalai neu, de Ana hela naluk ani hahaen, boe ma Ana palenda nae, “Efata.” (Sosoan nae, “Huꞌak leo!”) ");
INSERT INTO llg_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ana nafada kada leondiak, tutik, hataholi ndia namanene leo. Hataholi ndia maa makambiin, ana bangganaꞌu tutik, losa ana mulai kokolak no malole. ");
INSERT INTO llg_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Basa boe ma, dua sala fali leni hataholi nou kala leu. Yesus kaꞌi sala nae, “Mamanene baa! Ei boso mafada hataholi mae, Au tao ahai hataholi ia so.” Leomae Yesus kaꞌi sala tehuu ala tui noꞌu lai basa mamanak lalaꞌen. ");
INSERT INTO llg_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Hataholi fo mana lamanene ndia, ala heran lalan seli. Boe ma ala lakokola lae, “Ana seli nalan seli maa! Hataholi ia tao basa hata dadik malole. Hataholi mbakek bisa namanene. Hataholi hala taak bisa nakokola.” ");
INSERT INTO llg_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","3","Laꞌi esa, boe ma hambu hataholi noꞌu kala mai lakabubua fo lamanene Yesus. Ala tungga Ndia faik telu ia so, de basa nanaꞌa-nininu nala so. Boe ma Yesus noke nala ana mana tungga nala, de nafada sala nae, “Au ameda kasian neu hataholi noꞌu kala ia. Hambu nggelok leme dook mai so, de lakabubua faik telu ia so, de losak nanaꞌa nala taa so. Malolenak boso ala fali lo tei loon dei. Fo boso losak ala bengge lai dala laladak.” ");
INSERT INTO llg_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Yesus ana mana tungga nala lataa, lae, “Ama aa! Mamanak ia dook no nggolok. De ita taa bisa fee hataholi noꞌu kala ia laꞌa-linu!” ");
INSERT INTO llg_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Tehuu Yesus natane sala nae, “Ei loti mala hida?” Ala lataa lae, “Ama aa! Ai loti nala kada hituk.” ");
INSERT INTO llg_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Basa boe ma Yesus nadenu sala langgatuuk leu dae. Boe ma Ana haꞌi nala loti kahitu kala sila, de noke makasi neu Manetualain. Basa boe ma Ana bibiꞌi loti la sila nenik Ndia liman, de, Ana fee sala leu ana mana tungga nala. Boe ma leu babaꞌe fee basa hataholi la sila. ");
INSERT INTO llg_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ala hambu iꞌak hida boe. Boe ma Yesus noke makasi seluk neu Manetualain neu iꞌa kala sila. Basa de Ana fee ana mana tungga nala leu babaꞌe fee hataholi la sila. ");
INSERT INTO llg_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Sila basa sala fama hataholi lifun haa. Ala laꞌa losa lakabete. Laꞌa basa boe ma ana mana tungga nala leu huhulu lakabubua nanaꞌa ela kala sila, henu lembeneu inahuuk hitu. Basa ndia, boe ma Yesus nadenu basa sala fali. ");
INSERT INTO llg_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ledoeik ala fali, boe ma Yesus no Ndia ana mana tungga nala saꞌe leni ofak esa dale leu, de, ala leni mamanak esa leu, nade Dalmanuta. ");
INSERT INTO llg_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ledoeik Yesus asa losa Dalmanuta, boe ma hataholi hida leme partei Farisi, mai fo latonggo lo Ndia. Ala latane-lataak lo Ndia, fo sangga teꞌek Ndia. Ala loke Ndia, lae, “Ama aa! Matudu tanda heran esa, fo, dadik neu bukti nae, memak O hambu koasa neme Manetualain mai.” ");
INSERT INTO llg_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesus hela naluk ani hahaen, boe ma nae, “Mete ma Au amanene ei kokolan leondiak, na Au fale Au daleng! Huu hatina de ei moke tanda heran? Boso tao leondiak! Memak hambu tanda heran, tehuu Au taa tao fee ei.” ");
INSERT INTO llg_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Basa boe ma Yesus laꞌo ela sala de neu saꞌe fali seluk neni ofak dale neu, no Ndia ana mana tungga nala. Boe ma leni dano selik leu. ");
INSERT INTO llg_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Leꞌdoeik Yesus asa losa nai dano lalaꞌdan, bei fo ana mana tungga nala lasaneda, ala taa leni lepa-ngge. Ala leni kaꞌda loti esa. ");
INSERT INTO llg_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesus namanene ala kokolak loti boe ma nae, “Ei musi masanenedak baa! Ei boso tungga Mane Herodes no hataholi Farisi la leꞌa-nole manggalaun. Sila leꞌa-nole nala sila sama leo ala seseok laluteik fo tao natafuu loti.” ");
INSERT INTO llg_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Lamanene leondia, boe ma Ndia ana mana tungga nala lakandaa. Boe ma ala lakokola lae, “Toulasik kokolak hata ndia? Fama Ana kokolak nae leondia, na huu ita taa teni loti.” ");
INSERT INTO llg_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Tehuu Yesus bubuluk sila duduꞌa nala. De, Ana kokolak nae, “Hatina de ei kokolak kada loti! Ei taa malelak Au maksud do? Memak ei langga-uten mbaꞌan seli! ");
INSERT INTO llg_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ei mita mia ei mata heheli mala so, tehuu ei taa bubuluk ndia ndandaan! Sama leo ei bei taa mita. Ei mamanene mia ei ndiꞌidoo heheli mala so, tehuu ei taa bubuluk hata-hata. Sama leo ei bei taa mamanene! Ei mafalende henin so, ");
INSERT INTO llg_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","loti kalima kala sila fo Au bibiꞌi sala, de feen neu hataholi lifun kalima kala sila hetu do? Fain ei makabubua mala loti nana naꞌa ela kala lembeneu hida?” Lataa lae, “Lembeneu sanahulu dua, Ama.” ");
INSERT INTO llg_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Yesus natane sala bali nae, “Ei bei masaneneꞌda fain Au bibiꞌi loti kahitu kala, de fee hataholi lifun kahaa kala sila laꞌa hetu? Ei makabubua mala nanaꞌa ela kala lembeneu hida?” Lataa lae, “Hitu, Ama!” ");
INSERT INTO llg_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Boe ma Yesus nae, “Memak tetebes! Ei mita mata nggei so, tehuu hatina de, ei bei taa bubuluk Au koasang neme bee mai!?” ");
INSERT INTO llg_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Basa ndia, boe ma Yesus asa losa nai nggolo Betsaida. Nai ndia, hataholi la loo hataholi mbokek esa, neni Yesus neu. Ala loke Yesus nafaloen, fo tao nahai hataholi mbokek ndia. ");
INSERT INTO llg_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Basa boe ma Yesus toꞌu nala hataholi ndia liman, de dua-sala kalua leni nggolok deak leu. Boe ma Ana mbula amben neu hataholi ndia matan, de nafaloe hataholi ndia matan. Natane, nae, “Leo bee? O bisa mita so do?” ");
INSERT INTO llg_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Hataholi ndia botik langgan, de ana suli kii-konak, boe ma nataa nae, “Hei! Au ita hataholi la belaꞌo, tehuu leo bali au ita ai-la belaꞌo!” ");
INSERT INTO llg_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Basa boe ma Yesus tao seluk liman neu hataholi ndia matan. Boe ma hataholi ndia suli soba seluk, naa te matan neulau ndoos so. Hatematak ia, ndia nita no manggaledok so. ");
INSERT INTO llg_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Boe ma Yesus nadenu hataholi ndia fali, boe ma Ana fee nasanenedak neun nae, “O fali leo, tehuu tungga dala feꞌek! Boso fali muni Betsaida muu bali.” ");
INSERT INTO llg_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Basa, boe ma Yesus asa laꞌok ndule nggolok-nggolok malai Kaisaria Filipi. Nai dala laladak, Yesus natane sala nae, “Mete ma tungga hataholi la tutuin na, lae Au ia see?” ");
INSERT INTO llg_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Lataa lae, “Nggelok lae ‘Yohanis Mana Salanik’. Hambu nggelok lae ‘Baꞌi Elia’, fo Manetualain hataholi mana kokolan nai makahulun. Nggelok bali, na, lae, Ama ia esa neme Manetualain hataholi mana mana kokola lele ulun, feꞌek esa bali.” ");
INSERT INTO llg_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Boe ma Yesus natane selu kasa nae, “Tehuu tungga ei na, Au ia see?” Petrus nataa nae, “Ama ia Karistus! Fo Manetualain tudu mema kana neme makahulun ele mai so.” ");
INSERT INTO llg_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Boe ma Yesus kaꞌi sala nae, “Ei boso mafada esa boe baa!” ");
INSERT INTO llg_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Basa boe ma Yesus mulai nafada ana mana tungga nala nae, “Au ia Hataholi Isi-isik. Neu ko Au hambu doidosok noꞌuk, huu lasi haꞌda kala, malangga anggama Yahudi la malangga nala, ma mese anggama la, basa sala timba heni Au. Neu ko ala tao lisa Au, tehuu nandaa no binesan, na Au asoda fali.” ");
INSERT INTO llg_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesus nafada manggaledok leondiak, boe ma Petrus hela nalan neu dalak bifin de ana kaꞌin nae, “Ama boso mae leondia! Au taa nau sila lima nala laꞌe Ama.” ");
INSERT INTO llg_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Petrus nae leondia, na, taa tungga Lamatuak hihiin. Boe ma Yesus nasale de suli Ndia ana mana tungga feꞌe nala. Boe ma Ana mboka Petrus nae, “Wei! Ndia nitu la malanggan kokolan ndia. Boke malai heok ia! O duduꞌa tungga kada hataholi hihiin, tehuu taa Manetualain hihii-nanaun!” ");
INSERT INTO llg_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Boe ma Yesus nanggou nala hataholi feꞌe kala fo ala mai lakabubua lo Ndia ana mana tungga nala. Boe ma Ana nanoli sala nae, “See nau tungga Au, na, ana musi nakatataka tungga-tungga faik nakandoo! Ana musi nafalende heni ndia hihiin, fo tungga kada Manetualain hihii-nanaun. Mae hataholi sangga tao lisan boe oo, ana musi kada tungga nakandoo, sama leo hataholi lemba ndia ai ngganggen, fo, neu mate. ");
INSERT INTO llg_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Huu hataholi fo kada ana nau nasoda soaneu ndia aoina hehelin, na, dei fo ndia sodan ndia, mopon leondiak leo! Tehuu hataholi fo sadia mate, huu ana tungga Au, ma, tui-bengga Lamatuak dala sodan, neu ko ana hambu nasoda nakandoo no Manetualain. ");
INSERT INTO llg_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Mamanene, baa! Mete ma o hambu basa dae-bafok isi nala, tehuu Manetualain timba heni o, na o hambu hata? ");
INSERT INTO llg_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Leomae o lemba muni basa daebafok isi nala boe oo, o taa bisa seluk neu o samanem. ");
INSERT INTO llg_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Masanenedak baa! Hataholi malai daebafok hatematak ia, manggalau nala mata-mata kala. Tala nau tungga Manetualain. De, see ana mae tungga Au, do ana mae toꞌu Au nanoli-nafadang, na, Au boe oo mae manakun nai Manetualain matan. Huu Au Hataholi Isi-isik ia, neu ko Au fali maing uma nusa-sodak mai. Ma Manetualain ata nusa-soda nala boe oo, ala tungga noꞌu lo Au. Ai konda mima nusa-sodak mai, mia Amak koasa ana seli, bei fo hataholi la bubuluk Au ia see. ");
INSERT INTO llg_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ei boso mafalende heni Au kokolang ia. Hambu neme ei basa nggei ia mai, bei taa mate, tehuu neu ko nita Manetualain palendan, ma koasa inahuun.” ");
INSERT INTO llg_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Basa faik nee dalen, boe ma Yesus noke Petrus, Yakobis, ma Yohanis fo basa sala ndaꞌe leni lete madema nes esa lain leu. Ledoeik ala losa lain, ala lita Yesus namata-ao feꞌe. ");
INSERT INTO llg_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ma Ndia baloꞌa-papaken boe oo, ana daꞌdi fula manggahadok. Nai dae-bafok ia, taa hambu buas esa boe fo fulan lena heni Ndia baloꞌa-papaken ndia. ");
INSERT INTO llg_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Kada nggengge neuk boe ma ala lita Yesus nakokola no baꞌi Elia ma Baꞌi Musa. ");
INSERT INTO llg_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Petrus asa bii lalan seli. Boe ma Petrus nakandaa losa kokolak nadabak leondiak so. Basa de nafada Yesus nae, “Ama aa! Ita neulau hiak nai ia, maa! De malolenak ai tao mala lalaa anak telu. Esa soeneu Ama, esa feen neu Baꞌi Musa, ma esa bali feen neu Baꞌi Elia.” ");
INSERT INTO llg_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Basa ndia, boe ma koꞌas konda mai, de mboti nala sala. Boe ma lamanene halak kalua neme koꞌas ndia dalek mai, nae, “Mamanene baa! Yesus ia, na, Au Ana susueng! Ei basa nggei mamanene matalolole neun baa!” ");
INSERT INTO llg_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ledoeik Petrus asa lamanene halak ndia, boe ma ala suli lafeok, tehuu nggengge neuk ala taa bisa lita hataholi feꞌek so. Kada Yesus mesa kana. ");
INSERT INTO llg_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Basa ndia, boe ma Yesus no ana mana tungga nala loe fali leme letek mai. Boe ma Yesus kaꞌi sala nae, “Hata fo isinaak bei fo ei mitan ndia, ei boso mafaꞌda sudi see. Au ia Hataholi Isi-isik. Au musi mate dei. Boe ma, neu ko mete ma Au asoda fali so, na, bei fo ei bole mafada hataholi la.” ");
INSERT INTO llg_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ala toꞌu lahele Yesus hala hehelun ndia, de taa lafada hataholi la. Tehuu telu sala latatane aok lae, “Ndia maksud hata, de nae Ana nau ‘nasoda fali neme Ndia mamaten mai’ ndia? Sosoan nae leobee ndia? Talobee ia bae?” ");
INSERT INTO llg_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Boe ma latanen lae, “Mese anggama la lae, ‘Baꞌi Elia musi mai nahahuluk, bei fo Karistus mai.’ Tehuu tungga Ama, na leobee?” ");
INSERT INTO llg_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesus nataa nae, “Memak tetebes, Baꞌi Elia mai nakahuluk fo sadia dalak fee Karistus, huu Hataholi ndia fo Manetualain tudu mema kana so neme makahulun mai. Tehuu talobee? Ei bei taa bubuluk hata fo ala sula kana nai Manetualain Susula Malalaon, laꞌeneu Hataholi Isi-iisik ndia, hetu? Huu ala sulak memak, lae, dei fo mete ma Ana mai so, na, hataholi la tao lakatotoꞌa kana, losa ala tao lisa Ndia. ");
INSERT INTO llg_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Tehuu ei musi pasak neulalau ndiꞌidook baa! Baꞌi Elia ndia memak ana mai so. Tehuu hataholi la tao lakatotoꞌa kana, tungga sila hihiin. Ndia boe nandaa no hata fo baꞌi-baꞌi la sulak mema kana so neme makahulun mai.” ");
INSERT INTO llg_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Leꞌdoeik Yesus no ana mana tungga katelu nala sila latonggo falik lo ana mana tungga feꞌe nala, boe ma ala lita hataholi noꞌu kala lakabubua. Hataholi la sila ala mai lita Yesus ana mana tungga feꞌe nala lasisimbo bafak lo mese anggama la. ");
INSERT INTO llg_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ledoeik hataholi noꞌu kala sila lita Yesus, de, ala nggengge, huu lae hetuk Yesus bei nai letek lain. Boe ma lalai leu latonggo lon. ");
INSERT INTO llg_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Boe ma Yesus natane sala nae, “Ei masisimbo bafak hata nai ia?” ");
INSERT INTO llg_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Boe ma hataholi esa ana mai de, nae, “Ama, mamanene dei! Au ua au ana touanang mai, fo Ama tao mahai ndia dei. Ana taa bisa kokolak, huu nitu manggalauk nalan. ");
INSERT INTO llg_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Mete ma nitu ndia nala kakanak ndia dalek, na ana babala kakanak ia neu dae. Basa ndia, na, kakanak bafan nafufude, ma ana henggu nisin. Boe ma aon nakambii sama leo ai. Au oke Ama ana mana tungga nala fo ala husi heni nitu ndia. Tehuu ala taa bisa hata esa boe.” ");
INSERT INTO llg_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Namanene leondia boe ma Yesus mboka sala nae, “Wei! Ei ia ana seli maa! Au anoli ei taa-taa so, tehuu ei taa bubuluk neulalau. Ma ei taa mamahele tebe-tebe neu Au! De Au musi nggaleloak neu ei losa fai hida? Mia kakanak ndia neni ia mai!” ");
INSERT INTO llg_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Boe ma ala koꞌo loo kakanak ndia neni Yesus neu. Tehuu ledoeik nitu nita Yesus, boe ma ana bala nabuu kakanak ndia lololi neu dae, losa bafan fufude kala. ");
INSERT INTO llg_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Basa boe ma Yesus natane kakanak aman nae, “O anam dadi tao leoiak ia, neme fai hidak mai?” Boe ma aman nataa nae, “Neme kadiꞌi anan mai so. ");
INSERT INTO llg_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Nitu ndia sangga nae tao nisa kakanak ia dook ia so. Ana tao natuda taa-taa au anang neni haꞌi dale neu, ma nabolon neni oe dale neu. De Ama fali malan dei! Mete ma bisa, na, kasian ai, fo mahai kakanak ia dei.” ");
INSERT INTO llg_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesus nataa nae, “Tehuu hatina de o mae, ‘mete ma bisa’? Memak Au bisa tao ala basa-basan, tehuu sadi hataholi namahele dei!” ");
INSERT INTO llg_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Basa ndia, boe ma toulasik ndia nataa ma hihii namatani nae, “Ama! Memak au amahele so. De fali mala au, fo au namaheheleng boe natea bali!” ");
INSERT INTO llg_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ledoeik ndia, Yesus nita hataholi noꞌuk mai lakaseseti lai ndia. Basa boe ma Ana palenda nitu ndia nae, “Heeh! Nitu manggalauk! O kalua muma kakanak ndia mai, fo ela namanene ma ana bisa kokolak. O boso maso seluk muni kakanak ia dalek mu bali.” ");
INSERT INTO llg_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Namanene Yesus kokolak nae leondia, boe ma nitu ndia nakau natingga nalan seli. Ana bala nabuu kakanak ndia losa ana leꞌa, bei fo nitu ndia kalua laꞌo elan. Boe ma kakanak ndia ana male leobali sangga maten. Losa hataholi la sila kokolak lae, “Naa! Ana mate so!” ");
INSERT INTO llg_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Tehuu Yesus toꞌu nala kakanak ndia liman, de nafofoꞌan. Boe ma ana foꞌa tutik leo. ");
INSERT INTO llg_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Basa boe ma Yesus no ana mana tungga nala laꞌo ela mamanak ndia de ala leni uma esa dalek leu. Latane Yesus nai ndia lae, “Ama! Huu hata de isinaak, ai taa bisa husi mala nitu ndia?” ");
INSERT INTO llg_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Boe ma Yesus nafada nae, “Mamanene neulalaun! Nitu la memak manggalauk. De metema ei taa hule-haladoi moke tulu-falik neme Manetualain mai, na, ei ta mabeꞌi husi nitu mata leondiak.” ");
INSERT INTO llg_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Basa ndia, boe ma Yesus no ana mana tungga nala laꞌo ela mamanak ndia, de ala leni nusa Galilea leu. Faik ndia, Yesus taa nau hataholi la bubuluk lae Ndia nai ndia so, ");
INSERT INTO llg_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","huu kada Ana sangga nanoli Ndia ana mana tungga nala. Ana nafada sala, nae, “Taa dook so bali, tehuu ala sangga seꞌo heni Au uu hataholi feꞌek kala. Basa na, ala tao lisa Au, fo Hataholi Isi-isik ia. Memak Au mate, tehuu neu binesan, na, Au asoda fali.” ");
INSERT INTO llg_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Yesus nafada leondiak, tehuu ana mana tungga nala lakandaan. Ala taa lambalani latane seluk Yesus maksud ndia hata. ");
INSERT INTO llg_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Basa ndia, boe ma Yesus asa laꞌo losa Kapernaum. Ledoeik ala maso leni uma dale leu, boe ma Yesus natane ana mana tungga nala nae, “Isinaak ei masisimbo bafak hata ndia neme dala laladak?” ");
INSERT INTO llg_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Tehuu taa hambu esa nambalani nataa boe, huu lasisimbo bafak leme dala laladak lae, see neme sila basa sala mai, inahuun nai lain seli, neme sila basa sala mai. ");
INSERT INTO llg_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Basa boe ma Yesus nanggatuuk, de nanoli sala nae, “See nau dadik hataholi inahuuk, na, musi sodan dadi tebe-tebe leo hataholi kadiꞌianak fo ono-lau fee basa hataholi la.” ");
INSERT INTO llg_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Boe ma Yesus koꞌo nala kakanak kadiꞌik esa nai ndia, de Ana fali neni basa sala laladan neu. Boe ma Ana kokolak, nae, ");
INSERT INTO llg_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“See nau tungga Au fo ono-lau hataholi anak sama leo kakanak ia, na, ndia sosoan nae, hataholi ndia boe oo, ono-lau Au. Ma ndia boe oo ono-lau Au Amang fo mana madenu Au, uni daebafok ia mai.” ");
INSERT INTO llg_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Basa ndia, boe ma Yesus ana mana tunggan Yohanis, kalaak nae, “Ama aa! Laꞌi esa, ai mita hataholi esa husi nitu pake Ama naden. De ai kaꞌin, huu ita hataholin taa ndia.” ");
INSERT INTO llg_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Boe ma Yesus nataa nae, “Heeh! Ei boso kaꞌi hataholi ndia. Huu see pake Au nadeng, fo ana tao tanda heran, na, ana taa kokolak naboo Au nadeng ndia. ");
INSERT INTO llg_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Mete ma ana taa laban ita, na, sosoan nae ita hataholi ndia boe. ");
INSERT INTO llg_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Masaneneda neulalau baa! Mete ma hambu hataholi bubuluk ei tungga Karistus, boe ma ana tulu-fali ei, na, neu ko Manetualain taa nafalende heni ndia sosotan. Leomae ana fee ei minu kaꞌda oe hiak nggalaas esa boe, tehuu Manetualain taa nafalende heni ndia.” ");
INSERT INTO llg_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Boe ma Yesus nafada selu kasa bali, nae, “Mete ma hambu hataholi tao nasala kakana anak esa, losak taa namahele Au so bali, na, mata neuk leo baa! Malolenak mbaꞌa batu inahuuk esa neu hataholi ndia lesuhain, fo mabolo henin neni tasi laladan neu. ");
INSERT INTO llg_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Mete ma o tao salak munik o limam, na tete heni limak ndia leo! Huu malolenak o maso muni nusa-sodak dalek muu, muni kada o limam seli, lena heni o muni o liman dua sala, tehuu ala mbia heni o muni haꞌi naraka dalek muu. ");
INSERT INTO llg_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Naraka ndia, memak mamana doidosok. Ndia haꞌin taa hambu maten. Ma ulek malai sila kala taa hahae eꞌedok tao kaboo mbuluk. ");
INSERT INTO llg_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Mete ma o tao salak munik o eim, na, tete heni eik ndia leo. Huu malolenak o maso muni nusa-sodak dalek muu, mua kada o eim seli, lena heni o muni o eim dua sala, tehuu ala mbia heni o muni haꞌi naraka dalek muu, mua o eim dua sala. ");
INSERT INTO llg_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Naraka ndia memak mamana doidosok. Ndia haꞌin taa hambu maten. Ma ulek malai sila kala taa hahae eꞌedok tao kaboo mbuluk. ");
INSERT INTO llg_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Mete ma o tao salak munik o matam, na edo henin. Huu malolenak o maso muni nusa-sodak dalek muu, mua kada o matam seli, lena heni o muni o matam dua sala, tehuu ala nggali heni o muni haꞌi naraka muu mua o matam dua sala. ");
INSERT INTO llg_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","‘Naraka ndia, memak mamana doidosok. Ndia haꞌin taa maten. Ma ulek malai sila kala taa hahae eꞌedok tao kaboo mbuluk.’ ");
INSERT INTO llg_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Au nanonoling ia, memak belan seli. De see nau tungga Au, na, ana musi nakatataka tungga nakandoo. Sama leo mbaa fo ala mamasin ma ala seꞌin lenik haꞌi, suek mbaa ndia nala dook. ");
INSERT INTO llg_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Masik ndia, malole. Ita paken fo tao nalada nanaꞌak. Tehuu mete ma masik ndia mamin so, na, sosoan hata? Ita nggali henin leo. Ei boe oo, musi dadik sama leo masik, fo masoda masueao mia basa hataholi la. Ei hahae masisimbo bafak mae see ndia inahuuk ma see ndia kadiꞌik!” ");
INSERT INTO llg_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Basa boe ma, Yesus asa leni propinsi Yudea leu, ma nggolo-nggolo feꞌek kala malai lee Yarden selik dulu leu. Nai sudi bee hataholi noꞌu kala mai lakahohombu lala Ndia. Yesus nanoli sala, sama leo natetemen. ");
INSERT INTO llg_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Hambu hataholi Farisi mana maik hida, fo ala sangga tao latuda Ndia. Ala latane lae, “Tungga ita anggaman heti-heun nae, mete ma touk esa kasaok so, na bole namaketu no saon, do taa?” ");
INSERT INTO llg_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesus nataa nae, “Masanenedak dei! Heti-heuk laꞌeneu sasaok fo Baꞌi Musa fee ita, nae, leo bee?” ");
INSERT INTO llg_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ala lataa lae, “Baꞌi Musa heti-heun nae, hataholi bole lamaketu, sadi fee susula namaketuk neu sao inan dei.” ");
INSERT INTO llg_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesus bala nae, “Heeh! Mamanene, baa! Huu kada ei langga batun, de Baꞌi Musa sulak leondiak. ");
INSERT INTO llg_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ei boso mafalende heni tutui sososak fo faik Manetualain nakadadadik lalai ma dae-bafok! Hambu nana sulak nae, ‘Manetualain nakadadaꞌdik hataholi, touk no inak. ");
INSERT INTO llg_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Huu ndia de, touk musi laꞌo ela ina-man, fo neu nasoda dalek esa no saon, ");
INSERT INTO llg_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","huu sila dua sala dadik leu esa so. ");
INSERT INTO llg_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Mete ma Manetualain tao dua sala dadik leu esa so, na, hataholi boso fee sala lamaketu bali!” ");
INSERT INTO llg_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Basa ndia, boe ma, Yesus no ana mana tungga nala mesa kasa maso leni uma esa dalek leu. Leu ndia boe ma latane Yesus nanonolin isinaak ndia. ");
INSERT INTO llg_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yesus nataa nae, “See ana ela heni sao inan, fo ana sao seluk, na, hohonggek ndia so. ");
INSERT INTO llg_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Inak boe oo leo ndiak! Mete ma ana ela heni sao toun fo ana sao seluk, na hohonggek ndia boe!” ");
INSERT INTO llg_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Faik esa, boe ma hambu hataholi la loo ana nala leni Yesus leu, fo loke Ana tao liman neu sala, fo fee sala babaꞌe-babatik. Tehuu Yesus ana mana tungga nala kaꞌi hataholi la sila. ");
INSERT INTO llg_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesus nita leondia, boe ma Ana manggalau ana mana tungga nala, nae, “Mboꞌi kakana kala sila leni Au mai. Boso kaꞌi sala, huu hataholi fo sama leo sila ia, na, Manetualain hataholi nala sila. ");
INSERT INTO llg_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ei masanedak neulalau! See fo nau neni Manetualain matan mai, na, ana musi dokodoe Manetualain, sama leo kakana kala dokodoe inan no aman. Mete ma taa leondiak, na sila taa landaa dadik leu Manetualain hataholi nala.” ");
INSERT INTO llg_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Basa ndia, boe ma Yesus holu nala kakana kala sila, de Ana tao liman neu esa-esako langgan lain, de Ana fee sala babaꞌe-babatik. ");
INSERT INTO llg_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesus no Ana mana tungga nala sangga laꞌo, boe ma hataholi kamasuꞌik esa nalai-nalai mesan mai, fo sangga natonggo no Ndia. Ana nakatele neu Yesus matan, boe ma natane, nae, “Ama Mesen fo nana hadak nalan seli! Au sangga atane fa. Leoiak, Ama. Au musi tao leobee, fo suek au bubuluk tebe-tebe, au bisa maso nusa-sodak, fo au asoda sama-sama ua Manetualain?” ");
INSERT INTO llg_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesus nataa nae, “Hatina, de o mae Au ia nana ‘haꞌdak nala seli’? Taa hambu hataholi esa nana hadak nalan seli, tehuu kada Manetualain mesa kana. ");
INSERT INTO llg_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","O bubuluk so, basa Manetualain hoholo-lalanen neme makahulun ele mai nae, ‘Boso makanisa; Boso hohongge; Boso mamanaꞌo; Boso dadi sakasii pepekok; Boso pepeko mala hataholi buan; ma fee hadak holomata neu o amam ma inam.’ ” ");
INSERT INTO llg_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Boe ma hataholi ndia nataa, nae, “Tetebes, Ama Mesen! Au tungga basa hoholo-lalane kala sila so neme au bei taꞌeꞌanang mai.” ");
INSERT INTO llg_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesus kasian neu hataholi ndia. Boe ma Ana nafada nae, “Tetebes! Tehuu bei ela dedeꞌak esa bali. Hatematak ia, o fali leo, fo seꞌo heni basa o hata mala. Doi nala muu babaꞌe sala leu hataholi mana toꞌa-taa kala. Basa ndia, na, o mai fo tungga Au leo. Dei fo Manetualain bala fee o hata feꞌek, nai nusa-sodak.” ");
INSERT INTO llg_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Hataholi ndia namanene nala Yesus kokolan ndia, boe ma dalen nakalalutuk. Basa de, ana fali no dalen hedis nalan seli, huu kamasuꞌi ndoos. ");
INSERT INTO llg_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Boe ma Yesus suli neu-mai, de nakokola no ana mana tungga nala nae, “Mamanene baa! Hataholi kamasuꞌik memak sosotak maso nusa-sodak!” ");
INSERT INTO llg_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Lamanene Yesus kokolan leondia, boe ma ana mana tungga nala lasapangga. Tehuu Yesus kokolak nakadaik bali, nae, “Mamanene neulalau! Nau dadik Manetualain hataholin, na, totoꞌan ana seli! Boso mae dedeꞌak ndia mudak. ");
INSERT INTO llg_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Huu hataholi kamasuꞌik maso neni nusa soꞌdak fo ana dadik Manetualain hataholin, na totoꞌan sama leo banda onta inahuuk esa, maso neni lalaen dale neu, nesik ndandau bolo.” ");
INSERT INTO llg_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Yesus kokolan ndia, tao nala basa sala boe lasapangga bali. Boe ma latatane aok, lae, “Mete ma tetebes leo ndiak, na, see bisa hambu sodak, bae?” ");
INSERT INTO llg_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesus suli sala esa-esa, boe ma Ana nafada nae, “Soaneu hataholi, na, taa bisa. Tehuu boso mafalende henin: soaneu Manetualain, na, basan mana dadik!” ");
INSERT INTO llg_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Basa boe ma, Petrus kokolak nae, “Ama aa! Ai lao ela basa ai hata nala, de ai tungga Ama. Tehuu ai hambu hata?” ");
INSERT INTO llg_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Yesus nae, “Au sangga afada ei leoiak: hataholi fo mana tungga Au, ma ana laꞌo ela ndia inama nala, kaꞌafadi nala, ma, ana nala, osi-lutun, ue-ledin, ma basa ndia uma isi nala, fo neu tui-bengga Manetualain Hala Malolen, na, neu ko ana hambu nggati falik losa laꞌi natun. Basa hata fo ana laꞌo ela kala sila, neu ko ana simbo falik lena heni ndia. Ma ndia boe oo, neu ko nasoda nakandoo no Manetualain. Babalan ndindia! ");
INSERT INTO llg_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Masanenedak baa! Hataholi fo mana tao inahuhuu aon, na, tungga Manetualain duduꞌan na dei fo hataholi ndia kadiꞌi anak nalan seli. Tehuu hataholi taok aon kadiꞌik, na, tungga Manetualain duduꞌan, na, ndia mana dadik hataholi inahuuk.” ");
INSERT INTO llg_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Faik ndia, Yesus asa laꞌok leni Yerusalem leu. Yesus laꞌok nakahuluk. Boe ma ana mana tungga nala ma hataholi feꞌe kala tungga Ndia. Ala lasaneda hata fo Ndia dedeꞌa-kokola makahulun, nae, hataholi la sangga tao lisa Ndia nai Yerusalem. Huu ndia, de ala lasapangga ma bii. Namanene leondia, boe ma Yesus noke nala kada Ndia ana mana tungga nala mesa kasa, fo nafada selu kasa hata fo hataholi sangga tao Ndia nai Yerusalem. ");
INSERT INTO llg_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ana kokolak nae, “Ei mamanene baa! Hatematak ia, ita sangga teni Yerusalem teu. Au ia Hataholi Isi-isik. Tehuu ala seꞌo heni Au neu malangga anggama la ma mese anggama la nai ele. Basa boe ma ala huku lisa Au. Boe ma ala fee Au uu hataholi feꞌek kala fo taa mana malelak Manetualain. ");
INSERT INTO llg_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Basa boe ma ala kokolak lakamamaek Au. Ala mbula ambe neu Au. Ala filo lahina Au aong. Basa bei fo ala tao lisa Au. Memak Au mate tetebes, tehuu neu binesan, Au asoda fali. ");
INSERT INTO llg_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Basa ndia boe ma, Yakobis no Yohanis fo Sabadius ana nala, leni Yesus leu. Ala loke Ndia lae, “Ama Mesen aa! Ai paluu fa!” ");
INSERT INTO llg_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesus natane nae, “Ei paluu hata?” ");
INSERT INTO llg_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Boe ma ala lataa lae, “Leoiak Ama! Mete ma Ama nanggatuuk toꞌu palenda so, na, ai moke Ama manggatutuu ai, esa nai Ama boboa konan, ma esa nai Ama boboa kiin, fo ai boe oo, toꞌu palenda.” ");
INSERT INTO llg_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesus nataa nae, “Ei dua-nggei taa bubuluk hata fo ei mokek ia. Neu ko Au ia hambu doidosok noꞌun seli. De leobee? Ei maehetuk ei bisa lemba doidosok sila sama-sama mia Au, losa mate do?” ");
INSERT INTO llg_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ala lataa, lae, “Ai bisa Ama!” Yesus bala nae, “Memak ei boe oo, neu ko lemba doidosok sama leo Au boe. ");
INSERT INTO llg_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Tehuu neu ko see ndia nanggatuuk nai Au boboa konang ma Au kiing ndia, Au taa ndia aketun. Ndia Manetualain hak nakeketun ndia. Ana naketu mema kana so, fo see ndia mana manggatuuk nai mamanak ndia.” ");
INSERT INTO llg_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ledoeik ana mana tungga feꞌe nala lamanene Yakobis no Yohanis loke leondia, boe ma ala luli lalan seli. ");
INSERT INTO llg_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Boe ma Yesus noke nala basa sala, de Ana nafada sala nae, “Leoiak! Ei bubuluk basa so, hetu? Hataholi inahuuk mana toꞌu palenda, lateme tuni-ndeni lauinggu nala, losa tala bisa lakababalek. Ma malangga-malangga nala leme hataholi nusak fo taa mana malelak Manetualain, ala fee palenda lala lena-lenak, losa lauinggu nala taa botik lala langga nala. ");
INSERT INTO llg_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Tehuu ei boso tao leondiak! De see neme ei mai fo ana sangga nau dadik hataholi inahuuk, na, ana musi dadik sama leo mana ono-lau hataholi feꞌek. ");
INSERT INTO llg_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ma see nau daꞌdi malanggan, na ana musi tao aon leo jongos. ");
INSERT INTO llg_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Huu Au, Hataholi Isi-isik ia, taa mai fo hataholi ono-lau Au. Tehuu Au mai fo ono-lau hataholi noꞌuk. Au mai fee Au sodang katema tuan fo soi ala hataholi noꞌuk sala-singgo nala.” ");
INSERT INTO llg_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yesus no ana mana tungga nala ma hataholi noꞌun seli losa kota Yeriko. Ledoeik ala sangga laꞌok lakandoo, boe ma hambu hataholi mbokek esa nanggatuuk hule doik nai dalak bifin. Ndia naden Bartimeos fo Timeos anan. ");
INSERT INTO llg_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ledoeik namanene lae mana nesik ndia, na Yesus neme Nasaret mai, boe ma nanggou tingga-tingga nae, “Yesus! Dauk tititi-nonosin aa! Ai mahani taa-taa Ama dook ia so! Kasian neu au dei!” ");
INSERT INTO llg_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Lamanene ana nanggou leondia, boe ma hataholi la kaꞌin lae, “Wei! O nee-nee dei!” Tehuu ana boe nanggou natingga seluk, nae, “Yesus! Dauk tititi-nonosin aa! Kasian neu au dei!” ");
INSERT INTO llg_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Boe ma Yesus hahae de nae, “Ei mian neni ia mai!” Boe ma ala leu lafadan, lae, “Wei! O nee-nee leo! Ama Mesen noke o. Mai leo!” ");
INSERT INTO llg_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Namanene leo ndia, boe ma Bartimeos nggali heni lafan, de nambadeik lai-lai, fo neu natonggo no Yesus. ");
INSERT INTO llg_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesus natanen, nae, “O hii hata?” Hataholi mbokek ndia nataa nae, “Ama! Au oke fo au bisa ita!” ");
INSERT INTO llg_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesus nafada seluk bali, nae, “Huu o mamahele mae Au bisa tao ahai o, de hatematak ia o hai so! De, muu leo!” Boe ma Bartimeos matan hai tutik. Basa ndia, boe ma ana neu tungga Yesus. ");
INSERT INTO llg_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ledoeik basa sala sangga deka lo kota Yerusalem, ala losa nai nggolok dua, fo Betfage ma Betania nai Lete Setun bifin. Leu ndia, boe ma Yesus asa hahae fa. Basa, boe ma Ana nadenu ana mana tunggan dua leu lakahuluk. ");
INSERT INTO llg_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Nafada sala nae, “Ei dua-nggei makahuluk mini nggolok ele miu. Mete ma ei losa ndia, na, neu ko ei mita banda keledei ana esa, nanambaꞌak nai ndia. Hataholi la bei taa saꞌe sudi kana. Ei miu sefi heni talin, fo, hela minin neni ia mai. ");
INSERT INTO llg_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Tehuu mete ma hambu hataholi natane ei, nae, ‘Hatina de ei hela mini banda keledei ndia?’ Naa, ei mataa mae, ‘Ai Lamatuan sangga paken. Mete ma Ana pake nateꞌen, na, dei fo Ana haitua fali tuti kana.’ ” ");
INSERT INTO llg_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Boe ma dua sala leu, de lita banda keledei ana ndia nanambaꞌak nai uma esa boboan, nai dalak bifin. Boe ma ala sefi lalan, de hela lenin. ");
INSERT INTO llg_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Tehuu hataholi mana mambadeik malai sila kala latane sala lae, “Wei! Hatina de ei sefi mala hataholi banda keledein ndia?” ");
INSERT INTO llg_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Boe ma ala lataa, lae, “Ai Lamatuan sangga paken. Mete ma Ana pake nateꞌen, na, dei fo ai mini fali tuti kana.” Boe ma hataholi la sila mboꞌi sala leꞌa leni banda keledei ndia. ");
INSERT INTO llg_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ala hela lenin neni Yesus neu. Basa de ala bela lafa nala neu banda keledei ndia sasaꞌen, de Yesus saꞌe. ");
INSERT INTO llg_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ledoeik ala sangga maso leni kota dale, boe ma hataholi noꞌu kala haꞌi lala lafa naluse nala, ma lafa lalaan, de ala bela sala leu dalak lain. Hambu ala tati palm doo kala, fo sama leo mbua doo lai dalak bifin ndia, de ala nggenggela sala leu dalak laladan. Ala tao leo ndiak fo dadik neu tanda nae, ala simbok Yesus no hada holomata. Sama leo lateme ala simbok hataholi inahuu kala. ");
INSERT INTO llg_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Boe ma hambu hataholi laꞌok lakahuluk lai Yesus matan, ma nggelok ala tungga Yesus dean. Ala mulai eki, lae, “Hosana! Ita koa-kio Manetualain! Lamatuak fee babaꞌe-babatik neu hataholi fo mana mai no Lamatuak naꞌden, huu Manetualain nadenu hataholi ndia so! ");
INSERT INTO llg_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Hosana! Ita koa-kio Manetualain! Huu Lamatuak sangga nafofoꞌa falik Mane Dauk palendan! Hosana! Koa-kio Manetualain! Huu Lamatuak nanggatuuk toꞌu palendan memak, losa lalai mboin ele!” ");
INSERT INTO llg_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Losa kota dale, boe ma Yesus asa leni Manetualain Uma Ina Huhule-haladoin pasan leu. Boe ma Yesus mete neulalau ndule basa mamanak ndia. Tehuu fai taa so, de ala fali seluk leni nggolo Betania leu. ");
INSERT INTO llg_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Neu foꞌa fafain, boe ma ala kalua leme Betania mai, fo leni kota Yerusalem leu. Tehuu ala losa dala laladak, boe ma Yesus nameda ndoe so. ");
INSERT INTO llg_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ana nita ai esa nai dalak bifin ndia. Hataholi la lateme laꞌa ai ndia boan. Boe ma Yesus neni ai ndia huun neu, fo Ana mete sudi kana naboa do taa. Tehuu ledoeik Ana losa ai ndia huun, tehuu taa nita boak esa boe. Huu memak fai naboan bei taa. Bei fo mulai nadoo. ");
INSERT INTO llg_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Boe ma Yesus nafada ai ndia nae, “Huu o taa fee o boam neu Au, de neme hatematak ia mai, o taa bisa fee o boam neu hataholi feꞌek so!” Ndia ana mana tungga nala boe oo, lamanene Ndia hala belan leondiak. ");
INSERT INTO llg_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Boe ma Yesus asa laꞌok lakandoo losa Yerusalem, de Ana maso seluk neni Manetualain Uma Ina Huhule-haladoin dalek neu. Nai Uma ndia pasan, hataholi la taon dadik neu pasak, fo laseꞌo mbui lunda suek hataholi la paken neu tunu-hotu huhule-haladoik. Nita leondia, boe ma Yesus husi kalua heni sala. Ana bala nggali heni mei la, fo ala paken neu tuka doik, ma Ana mbesi nalengga-natono banggu la fo ala paken neu laseꞌo mbui kala sila. ");
INSERT INTO llg_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Boe ma Ana kaꞌi basa hataholi la, fo taa bole leni baloꞌa nala lesik uma ndia pasan. ");
INSERT INTO llg_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Boe ma nanoli sala nae, “Ei bubuluk memak so, hata fo Manetualaian mana kokolan sulak basan so, nae, ‘Au ambadedei Au Umang ia, fo hataholi la leme basa hataholi nusa kala mai hule-haladoi lai ia!’ Tehuu ei tao uma ia dadik neu nakodaa la mamana nakabubuan so!” ");
INSERT INTO llg_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ledoeik malangga anggama la malangga nala ma mese anggama la, lamanene Yesus tao leondiak, boe ma ala luli Ndia lalan seli. Boe ma ala sangga dalak, fo tao lisan. Tehuu ala bei bii, huu hataholi noꞌu kala lahiik Ndia nanonolin. ");
INSERT INTO llg_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Leꞌdoeik ledo sangga tesa, boe ma Yesus no ana mana tungga nala kalua leme kota Yerusalem mai, de ala fali leu sunggu lai nggolo Betania. ");
INSERT INTO llg_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","21","Nai foꞌa fafai anan, Yesus no ana mana tungga nala fali seluk leni Yerusalem leu. Nai dala laladak, ala laꞌo lesik seluk ai, fo afik Yesus Ana sumba-soon ndia. Ana mana tungga nala heran lalan seli, huu ai ndia namatuu losa oka nala. Boe ma Petrus nasaneda afik Yesus kokolan ndia. De, ana nafada, nae, “Ama aa! Mita sudik dei! Ai fo afik Ama sumba-soon ndia maten so!” ");
INSERT INTO llg_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Boe ma Yesus nataa, nae, “Memak tetebes! Sadi ei boe oo, mamahele tebe-tebe neu Manetualain leondiak. ");
INSERT INTO llg_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Mete ma ei mamahele tebe-tebe, na ei bisa madenu letek esa fo nana soꞌuk neni tasi dale neu. Boe ma Manetualain keko henin letek ndia, sadi ei boso mamahele no dale bibiak! Ei musi mamahele tebe-tebe neu Manetualain. ");
INSERT INTO llg_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Boso mafalende henin baa! Sadi ei mamahele tebe-tebe, mae, Manetualain nabeꞌi fee hata fo ei moken, na neu ko Ana fee ei! ");
INSERT INTO llg_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Tehuu mete ma hambu hataholi esa neu hule-haladoi, naa te ndia dalen taa malole no hataholi feꞌek, na, ana musi malole no hataholi ndia dei. Leondiak bei fo ei Amam manai nusa-sodak, nau koka heni ei sala-singgo mala. ");
INSERT INTO llg_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Mete ma hambu hataholi esa bei nambeda dalek, ma taa nau fee ambon neu hataholi ndia, na, neu ko ei Amam manai nusa soꞌdak boe oo, taa nau nafalende heni ei sala-singgo mala boe.” ");
INSERT INTO llg_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Basa boe ma, Yesus no ana mana tungga nala laꞌo lakandoo. Losa Yerusalem, boe ma ala maso seluk bali, leni Manetualain Uma Ina Huhule-haladoin dalek leu. Ledoeik ala maso lala uma pasan, boe ma malangga anggama Yahudi la malangga nala, mese anggama la, ma lasi hada Yahudi la mai, ");
INSERT INTO llg_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","de latane Yesus lae, “Afik, see nadenu o mai tao husanak nai ia. See ndia fee o hak!” ");
INSERT INTO llg_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Tehuu Yesus Ana bubuluk ala sangga dalak, fo suek tao latuda Ndia. Boe ma Ana bala, nae, “Au boe oo sangga atane ei. Ei mataa Au dei, bei fo Au ataa ei. ");
INSERT INTO llg_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Au sangga atane ei leoiak: ei basa nggei malelak Yohanis Mana Salanik ndia, hetu? See ndia nadenun fo neu salani hataholi? Manetualain do hataholi?” ");
INSERT INTO llg_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ala duduꞌa neu-mai, boe ma lakokola aok lae, “Awii! Ita laꞌen ia so! Mete ma ita tataa tae, ‘Amak Manetualain ndia nadenu,’ na, neu ko natane nasafali ita nae, ‘Mete ma leondiak, na, hatina de ei taa mamahele neu Yohanis boe?’ ");
INSERT INTO llg_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Tehuu ita boe oo, taa bisa tafada tae, ‘Hataholi nadenu.’ Huu neu ko basa hataholi la manggalau. Huu lamahele lae Yohanis ndia na, Manetualain hataholi mana kokolan ndia.” ");
INSERT INTO llg_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Basa boe ma lataa lae, “Ai taa bubuluk!” Boe ma Yesus nataa nasafali sala, nae, “Mete ma leondiak, na Au boe oo taa nau afada, see ndia nadenu Au.” ");
INSERT INTO llg_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Basa ndia boe ma Yesus kokolak seluk bali no malangga anggama Yahudi la malangga nala ma mese anggama la, ma lasi hada Yahudi la. Ana kokolak pake nakandandaak, nae, “Hambu hataholi esa neu tao osi beuk, nai ndia dae bibia anan esa, fo sangga sele ai anggol neun. Boe ma ana kota eꞌon. Ma ana tao bak fo sangga natanee anggol oen. Boe ma ana nambadedei mamana nanea madema esa. Basa de ana fee hataholi feꞌek ala seba osi ndia, fo labaꞌe buna-boan. Boe ma ana laꞌo neni nusa dea neu. ");
INSERT INTO llg_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Losa fai seseu anggol, boe ma madaek nadenu ana mana tao uen esa, neni hataholi la mana tao osi ndia neu, fo noke ndia ena babaꞌen. ");
INSERT INTO llg_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Tehuu ledoeik ana losa, boe ma hataholi mana tao osi la humu lalan de ala mbombokon. Boe ma ala ladenu falik ndia no lima loun. ");
INSERT INTO llg_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Boe ma madaek ndia nadenu seluk ana mana tao uen esa neu bali. Tehuu hataholi mana tao osi la mbombokon losa langgan hinak-hinak mesan. Basa de lakamamae kana, ma ala husi fali kana. ");
INSERT INTO llg_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Basa ndia, boe ma madaek ndia nadenu seluk ana mana tao uen feꞌek esa neu bali. Tehuu ala tao lisan boe. Leomae ala tao leobeek boe oo, madaek ndia kada nadenu nakandoo ndia ana mana tao uen nala leu taa-taa. Tehuu mana tao osi la ala mbomboko lala nggelok, ma ala tao lisa nggelok. ");
INSERT INTO llg_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Hatematak ia ela kada hataholi esak so, fo madaek ndia ana mane kisan fo ana sue nalan seli. Huu ana taa hambu dalak feꞌek so, de nadenu ana mane kisan ndia neu leo. Boe ma ana duduꞌa nae, ‘Mete ma au adenu Au ana bongging neu, na, neu ko ala simbo kana no malole, ma ala lamanene neun.’ ");
INSERT INTO llg_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","De, ana nadenu anan neni ele neu. Tehuu ledoeik hataholi mana tao osi la lita kakanak ndia mai, boe ma lakokola aok lae, ‘Wei! Ei suli sudik dei! Toulasik nadenu ana bonggin mesa kana mai so! Mete ma toulasik maten so, na, ndia ndia hambu basa pusaka la. Mai fo ita tao tisa kaknak ndia leo, fo suek ita hambu ndia pusakan ia!’ ");
INSERT INTO llg_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Basa ndia boe ma, basa sala leu humu lalan, de ala tao lisan. Boe ma ala mbia heni mbombolan neni osi deak neu. Nakandandaak ndia nateꞌe kada ia leo.” ");
INSERT INTO llg_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Basa ndia, boe ma Yesus natane hataholi inahuu kala sila nae, “Tungga ei duduꞌan, na madaek ndia sangga tao hataholi mana tao osila sila leobee? Tungga Au so, na, neu ko ana mai fo tao nisa basa hataholi mana tao osi la sila. Basa ndia, na, ana fee osi anggol ndia neu hataholi feꞌek kala, fo, ala seban. ");
INSERT INTO llg_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ita basa nggata les basa Manetualain Susula Malalaon so, nae, ‘Hambu batu esa fo tuka nala ala mbia henin so. Tehuu hatematak ia, batu ndia dadik neu batu netes so. ");
INSERT INTO llg_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Manetualain mesa kana ndia hele nalan, de nanggatutuu falik batu ndia. Huu ndia de, ita titan lolen seli!’ ” ");
INSERT INTO llg_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Hataholi inahuu kala sila bubuluk mema kana, lae, Yesus uku bebeik sila, nenik nakandandaak ndia. Sila sama matetuk leo hataholi mana tao osi anggol ndia. Basa ndia, boe ma ala heti dalak fo sangga humun. Tehuu ala bii hataholi noꞌu kala fo mana hii Yesus nanonolin. Boe ma ala laꞌo elan leo. ");
INSERT INTO llg_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Basa ndia, boe ma hataholi inahuu nala ladenu hataholi Farisi hida, ma Herodes hataholi partein luma, leu latatanek lo Yesus, fo sangga ikan. ");
INSERT INTO llg_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Basa boe ma ala mai, de latatanek lo Ndia lae, “Ama Mesen! Ai basa nggai bubuluk Ama dalen ndoos, ma taa mana pepeko malelak. Ama mete kada hataholi la dale nala. Ama boe oo mafada Manetualain hihii-nanaun no manggaledok, huu Ama taa mete matak boe. Hatematak ia, ai sangga matane dedeꞌak esa. Tungga ita anggama Yahudi heti-heun, na, ita musi bae bea neu mana palenda Roma Mane Inahuun, do taa?” ");
INSERT INTO llg_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Tehuu Yesus bubuluk so, fo ala sangga doluk Ndia, suek Ana kokolak laban mana palenda Roma. Boe ma Yesus nataa no hala belak nae, “Huu hata de ei sangga makatutuꞌdak Au minik natatanek ndia! Hena matudu Au doi lilo fulak esa dei!” ");
INSERT INTO llg_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Boe ma ala loo feen doi lilo fulak esa. Ana simbok nalan boe ma Ana palisa kana. Basa ndia, de, Ana natane sala nae, “See mata-aon ia, ma see naden ia?” Boe ma ala lataa lae, “Mana palenda Roma Mane Inahuun ndindia!” ");
INSERT INTO llg_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Boe ma Yesus nae, “Naa! Mete ma leondiak, na, ei musi fee mana palenda hata fo mana palenda hak. Ma fee Manetualain hata, fo, Manetualain hak.” Lamanene leo ndia, boe ma basa sala heran lalan seli, huu Yesus nafada laꞌen ndia. Huu ndia de, ala taa hambu teꞌek lalan. ");
INSERT INTO llg_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Hambu partei anggama feꞌek esa, fo hataholi la lae, partei Saduki. Ala lanoli, lae, hataholi mana matek taa bisa nasoda fali. Laꞌi esa, hambu hataholi Saduki hida ala mai teꞌek Yesus. ");
INSERT INTO llg_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Ala kokolak lo Yesus lae, “Ama Mesen! Baꞌi Musa sulak fee ita, laꞌeneu hadak ia nae, metema touk esa mate laꞌo ela saon, tehuu anan taa, na, touk ndia fadin musi sao nala ina falu ndia, fo suek kaꞌa mana maten ndia, hambu tititi-nonosik. ");
INSERT INTO llg_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Memak Musa nanoli leondiak, tehuu ai nau matane leoiak: hambu touk hitu, tolanoo-bonggi kala. Uluk, sao nakahuluk, boe ma maten, tehuu anan taa. ");
INSERT INTO llg_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Boe ma fadin mana tungga ndia, sao nala inak ndia. Taa dook boe ma ana mate boe, ma inak ndia taa bonggi nala anak boe. Leondiak boe, losa fadi katelun; Ana sao nala ina falu ndia tehuu maten, ma taa bonggi nala anak boe. ");
INSERT INTO llg_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Leondiak nakanondoo henin losa fadi muli anan, tehuu maten boe. Mateꞌen, de, ina falu ndia maten boe. ");
INSERT INTO llg_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Hatematak ia, ai sangga matane leoiak: ina falu ndia sao nitak touk hitu! Tehuu mete ma neu daebafok babasan, fo Manetualain tao nasoda falik basa hataholi mana mate kala, na, inak ndia dadik neu see saon neme tou kahitu kala sila mai?” ");
INSERT INTO llg_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Boe ma Yesus nataa, nae, “Mete ma ei matane leondiak, na, sosoan nae, ei bei taa malelak matalolole Manetualain Susulan Malalaon isin. Ma ei boe oo, taa malelak Manetualain koasan. De, ei ia sala malan seli! ");
INSERT INTO llg_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Mamanene, baa! Leoiak: sasaok taa nai nusa-sodak. Basa hataholi mana mate kala fo Manetualain tao nasoda fali kasa, tala sao so bali. Leondiak boe oo, Manetualain ata nusa-soda nala tala sao boe. ");
INSERT INTO llg_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Boe ma, Au afada laꞌeneu hataholi mana mate kala lasoda fali, do taa. Baꞌi Musa sulak laꞌeneu ai huu kadiꞌik fo haꞌi naꞌan, tehuu taa kaden. Ei masaneda tutuik ndia do taa? Ledoeik haꞌi mbila nai ai ndia, boe ma Manetualain nafada Baꞌi Musa nae, ‘Au ia o Baꞌi-baꞌi mala Manetualain. Fo ndia Baꞌi Abraham, Baꞌi Isak, ma Baꞌi Yakob. Sila basa sala lakaluku-lakatele lakandondoo henin neu Au losa hatematak ia.’ ");
INSERT INTO llg_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ita bubuluk, tae, baꞌi-baꞌi la sila mate sala dook ia so. Tehuu Manetualain nafada nae, Ndia bei dadik sila Manetualain, huu ndia de ita bubuluk tae, sila lasoda fali so. De, leomae hataholi mate sala so boe oo, tehuu lasoda fali. Memak hataholi kasodak ndia nakaluku-nakatele neu Manetualain, tehuu taa hataholi mana mate kala hetu? De mete ma ei toꞌu mahele nanonolik ndia nae, hataholi mana mate kala taa lasoꞌda fali, na, memak ei sala malan seli ndia so!” ");
INSERT INTO llg_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Faik ndia, hambu mese anggama esa boe oo, namanene neu Yesus, nanggatuuk de nakokola no hataholi partei Saduki la. Mese anggama ndia duduꞌa nae, Yesus nataa sila natatanen ndia so, no malole. Boe ma natane Yesus nae, “Ama! Au sangga atane leoiak: ita hadan heti-heun, ma anggama palenda nala noꞌun seli. Neme basa Baꞌi Musa palenda nala sila, bee ndia kasosoak nalan seli?” ");
INSERT INTO llg_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesus nataa, nae, “Palenda kasosoak nalan seli fo nai Manetualain Susulan Malalaon dale nae leo ia: ‘Basa hataholi malai Israel! Mamanene neulalau! Manetualain ndia na memak ita Lamatuan, ma ita Mane Kisan! Taa hambu seluk so bali, kada Ndia mesa kana! ");
INSERT INTO llg_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","De ei musi suen lena heni basa hata lalaꞌen. Huu ndia, de, ei musi dokodoe Ndia taa-taa, malelak Ndia, ma ei musi maue-maledi tingga-tingga fo tungga Manetualain hihii-nanaun.’ ");
INSERT INTO llg_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ma palenda kadua nae leo ia: ‘O musi sue hataholi feꞌe kala sama leo o sue o aoina hehelim!’ Palenda kadua kala ia sosoan lena heni basan. Taa hambu palenda feꞌek soo, fo sosoan lena heni palenda kadua kala ia.” ");
INSERT INTO llg_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Basa ndia, boe ma mese anggama ndia nafada seluk neu Yesus nae, “Memak! Ama kokolam ndia tetebes. Manetualain dadik neu ita Lamatuan, de, taa hambu Lamatuak feꞌek so bali. ");
INSERT INTO llg_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ita musti sue Ndia lena heni basa hata lalaꞌen, losa ita dokodoe tahele Ndia, talelak Ndia, ma tao ues tingga-tingga fo tungga Ndia hihii-nanaun. Ma ita boe oo, musi sue hataholi feꞌek sama leo ita sue ita aoina hehelin! Ndia, Manetualain namahoko nalan seli lena heni kada ita tungga anggama heti-heu nala. Ndia malolen lena heni metema kada ita tunu banda tunu-hotuk, do fee hata feꞌek neu Ndia.” ");
INSERT INTO llg_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Namanene leondia, boe ma Yesus duduꞌa, nae, mese anggama ia nalelak no malole so. Boe ma Yesus nae, “O hiihii dadik Manetualain hataholin so.” Basa ndia, boe ma taa hambu hataholi feꞌek fo nambalani natane Yesus so, huu taa hambu hataholi senggi Ndia so. ");
INSERT INTO llg_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Basa ndia, boe ma Yesus bei nanoli hataholi sila lai Manetualain Uma Ina Huhule-haladoi dale. Boe ma Ana natane sala nae, “Tungga ei duduꞌam, na, leobee? Mese anggama la lanoli laꞌeneu Karistus ndia, fo Manetualain tudu memak neme lele uluk ele mai so. Tungga sila, na Ndia kada Mane Dauk tititi-nonosin. Tehuu ndia, taa tetebes. ");
INSERT INTO llg_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Huu makahulun ele Manetualain Dula Dale Malalaon pake Dauk, de ana sulak nae, ‘Manetualain nafada au Lamatuang, nae, “Mai fo manggatuuk muu mamana nanahadak ia, nai Au boboa konang. Neu ko Au tao ala o musu mala, losa ala doꞌok o.’ ” ");
INSERT INTO llg_vpl VALUES ("MK12_37a","071_12_37a","MRK","12","37a","37a","Neme ndia mai, ita bubuluk tae, Mane Dauk mesa kana noke Karistus ndia, na nae, ‘Lamatuak.’ Ndia sosoan nae, mete ma hataholi la lae, Yesus ndia kada Mane Dauk tititi-nonosin, na ndia bei taa dai! Huu Ndia boe oo, dadik Mane Dauk Lamatuan!” ");
INSERT INTO llg_vpl VALUES ("MK12_37b","071_12_37b","MRK","12","37b","37b","Ledoeik Yesus kokolak isinaak nae leondia, boe ma hataholi noꞌu kala lahiik lamanene lalan seli neu Ndia. ");
INSERT INTO llg_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Basa boe ma nafada sala bali, nae, “Ei musi mata neuk neu mese anggama la. Ala lahiik leu kokook pake badu naluk mana mbembembek, ma, leu latonggo lo hataholi noꞌu kala, fo suek hataholi la lita sala, fo, lae, ‘Wei! Hataholi inahuu kala sila bou!’ ");
INSERT INTO llg_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Mete ma ala leni uma huhule-haladoik dale leu, do leu laꞌa feta, na, ala lateme sangga kada mamana nanggatutuu neulauk, fo suek hataholi noꞌu kala lita sala. ");
INSERT INTO llg_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Tehuu mata neuk bou! Huu ala pepeko lala ina falu la, fo lamoa lala basa uma nala. Tehuu lai hataholi noꞌuk mata nala, na, lafuni sila tatao manggalau nala sila, lenik lambadeik fo ala hule-haladoi lala dook. Ala nau hataholi la lae, sila hataholi malalaok. Tehuu neu ko, Manetualain fee sala huhukuk belan seli.” ");
INSERT INTO llg_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Basa ndia, boe ma Yesus neu nanggatuuk nasale peti derma manai Manetualain Uma Ina Huhule-haladoin dalek ndia. Ana nita hataholi la mai langgodi sila doi kolete nala leni peti ndia dalek neu. Ana nita hataholi kamasuꞌi kala mai langgodi sila doi kolete nala noꞌuk nalan seli, nai ndia boe. ");
INSERT INTO llg_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Boe ma ina falu hata taak esa mai hule-haladoi boe. De ana nanggodi doik sen dua neni peti kolete dale neu. Doik ndia belin nai dae nalan seli. ");
INSERT INTO llg_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Basa boe ma Yesus Ana kapek nala ana mana tungga nala de nae, “Ei mete neulalau ina falu hata taak ndia dei. Ana nanggodi kada doik sen dua, tehuu ana fee lena heni neme basa hataholi la sila. ");
INSERT INTO llg_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Hataholi feꞌek sila langgodi doi kolete nala neme sila doi sisa nala mai. Tehuu ina falu ia, ana fee basa doin neu Manetualain.” ");
INSERT INTO llg_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Basa ndia boe ma, Yesus no ana mana tungga nala sangga laꞌo ela Uma Ina Huhule-haladoik. Ledoeik ala kalua, boe ma Ndia ana mana tunggan esa tuduk neni Uma Ina Huhule-haladoik neu de nae, “Ama aa! Hena Ama mete sudik ia dei! Uma ia lolen seli! Ala mbeda lakatotodok batu inahuu nala de lolen seli!” ");
INSERT INTO llg_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Tehuu Yesus nataa, nae, “Uma ia memak malole! Tehuu taa dook so bali, tehuu ala ofe heni basa batu la ia.” ");
INSERT INTO llg_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Basa boe ma, Yesus no ana mana tungga nala leni lete Setun lain leu, de langgatuuk leu mamanak esa fo nasasale matak no Uma Ina Huhule-haladoik ndia. Basa ndia, boe ma ana mana tungga kahaa nala mai de, mesa kasa lakokola lo Ndia. Fo ndia Petrus, Yakobis, Yohanis ma Anderias. ");
INSERT INTO llg_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Boe ma latane Yesus lae, “Ama! Mafada sudik seluk ai, Ama kokolan isinaak ndia dei. Faik bee ndia fo fain ndia losa? Ma tanda nala leo hata?” ");
INSERT INTO llg_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Boe ma Yesus nataa nae, “Sadi ei manea matalolole bou! Fo suek boso ei nana kedi nalak. ");
INSERT INTO llg_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Huu neu ko hataholi mata-mata kala mai, fo ala babamba kala nala ma lae, ‘Au ia Karistus, hataholin fo Manetualain helu memek neme makahulun ele mai so.’ Boe ma ala kedi lala hataholi noꞌuk. ");
INSERT INTO llg_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Mete ma ei mita hataholi la latati ma ei mamanene lae natatik nai mamanak sudi bee, na boso bii. Huu matak leondiak ndia, musi ana dadi dei, tehuu daebafok babasan bei taa losa. ");
INSERT INTO llg_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Neu ko leo esa natati laban leo feꞌek. Nusak esa natati laban nusa feꞌek. Hambu dae nanggeꞌo nai sudi bee. Fai ndoen boe oo, ana seli! Basa ia la, dadik tanda, sama leo inak esa bei fo tein mulai hedis fo sangga ana bonggi. ");
INSERT INTO llg_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","De, ei musi manea matalolole baa! Huu neu ko ala mai humu lala ei, fo ala hela loo ei mini mamana nakeketu dedeꞌa anggama miu. Ma ala mbomboko ei nai uma huhule-haladoik dale. Ma ala mbaꞌa leni ei mini mana palenda miu, huu ei tungga Au. Ma ndia dadik neu dalak esa, suek ei musi mboa sudi hata laꞌeneu Au. ");
INSERT INTO llg_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Tehuu Lamatuak hataholi nala musi leu tui-bengga lakahuluk Au Hala Maloleng neu basa leo la malai daebafok ia, bei fo daebafok babasan losa. ");
INSERT INTO llg_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Masanenedak baa! Mete ma ala mbaꞌa loo ei mini mamana nakeketu dedeꞌak miu, na, ei boso bii fo mae, ‘Neu ko au kokolak ae hata? Do au ataa ae hata?’ Mete ma fain ndia losa, na kada ei kokolak tungga hata fo Manetualain Dula Dale Malalaon nafada ei. ");
INSERT INTO llg_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Nai uma esa dalek, mete ma hambu hataholi esa namahele neu Au, na, neu ko ndia tolanoo hehelin sangga dalak fo ana tao nisan. Mete ma anan ndia namahele neu Au, na neu ko aman tao nisan. Ma mete ma inan no aman lamahele neu Au, na neu ko anan tao nisa sala. ");
INSERT INTO llg_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","De, neu ko hataholi la lambeda dalek leu ei lalan seli, huu ei mamahele Au. Tehuu see ndia nakatataka losa babasan, na, Manetualain feen sodak. ");
INSERT INTO llg_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Yesus kokolak nakandoo, nae, “Hataholi manggalau inahuuk esa sangga mai. Ana nambadeik neu mamana lulik fo manai Manetualain Uma Ina Huhule-haladoin dale, fo hataholi ndia taa nandaa nai mamanak ndia, losa ana tao nanunute mamanak ndia. Huu ndia de, Manetualain heok nasadea ela mamanak ndia. Mete ma ei mita leondiak so, na mata neuk leo baa! (See ana les ia, na ana musi mata neuk boe!). Ndia dadik tanda, nae, fai toꞌa-taak deka-deka so. Mete ma lita leondiak, na hataholi malai propinsi Yudea foꞌa lalai leni letek lain leu leo. ");
INSERT INTO llg_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ma ala musi lalaik lai-lai, fo suek boso ala hambu soe. Ma mete ma hambu see kalua laꞌo ela uman, na boso fali mai haꞌi baloꞌas bali. ");
INSERT INTO llg_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Boe ma hataholi la malai osi la dale, na, boso fali mai haꞌi bua nalusek bali. Tehuu malai makandoo leo! ");
INSERT INTO llg_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kasian nalan seli neu ina kailu sala, ma ina kala mana susu ana mbimbila ana kala. Huu ala taa lalaik lai-lai. ");
INSERT INTO llg_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","De malolenak ei hule-haladoi fo moke dedeꞌa manggalauk ndia, boso laꞌe neu fai oefaak. ");
INSERT INTO llg_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Huu faik ndia totoꞌan ana seli! Mulai neme Manetualain nakadadadik daebafok losa hatematak ia, hataholi la bei taa lita litak toꞌa-taa inahuuk matak leondiak. Ma neu ko hataholi la taa lita seluk totoꞌa matak leondiak so. ");
INSERT INTO llg_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Mete ma Manetualain taa tao kekeꞌu faik ndia, na neu ko taa hambu hataholi esa fo bisa nakatataka nasoda boe. Huu Manetualain sue hataholi fo ana hele mema kasa so, de Ana tao kekeꞌu fai totoꞌak ndia. ");
INSERT INTO llg_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Mete ma faik ndia losa, na ei mamanene hataholi la lae, ‘Mita dei! Karistus nai ia!’ Tehuu hataholi feꞌek lae, ‘Karistus nai ele!’ Tehuu ei boso mamanene ndia baa! ");
INSERT INTO llg_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Huu neu ko hambu hataholi kalua fo ana babamba kalan nae, ‘Au ia Karistus!’ Nggelok bali, na, lae, ‘Au ia Manetualain hataholi mana kokolan.’ Dei fo ala tao tanda heran mata-mata kala, pake nitu koasan, fo ala pepeko hataholi la. Ala soba-soba fo kedi lala, Manetualain hataholi nala boe. ");
INSERT INTO llg_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Tehuu ei musi manea matalolole baa! Fai toꞌa-taak ndia bei taa losa, tehuu Au asaneneꞌdak memak ei baa.” ");
INSERT INTO llg_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Basa boe ma Yesus tuti seluk kokolan bali, fo nafada ana mana tungga nala, nae, “Mete ma basa fai toꞌa-taak ndia, ‘Neu ko ledo makiu, bulak boe oo, taa manggaleꞌdo so. ");
INSERT INTO llg_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Nduu kala latuda kala leme lalai mai, ma basa koasa malai lalai langgongga-mboꞌa kala.’ ");
INSERT INTO llg_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Basa ndia, na, bei fo basa hataholi la lita Au, fo Hataholi Isi-isik ia. Neu ko Au mai nai koꞌas, uma lalai mai. Ma basa hataholi la lita Au koasang, ma basa Au nula-nambung. ");
INSERT INTO llg_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Boe ma Au palenda Manetualain ata nusa-soda nala, fo, leu lakabubua lala hataholi la fo Au hele basa sala leme dae-bafok buꞌu nala mai, neme dulu mai losa muli neu, neme kii mai losa kona neu. ");
INSERT INTO llg_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Yesus tuti Ndia kokolan, nae, “Au haꞌi nakandandaak neme ai huuk mai. Mete ma doon mulai kuni, na, ndia dadik tanda, nae, fai hanas deka-deka mai so. ");
INSERT INTO llg_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Leondiak boe oo, mete ma ei mita fai-fai toꞌa-taak losa, fo leo isinaak Au afada ei ndia so, na, ndia dadik tanda nae, Au deka-deka mai so. ");
INSERT INTO llg_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Hatematak ia, mamanene neulalau! Neme basa hataholi kasoda kala hatematak ia, neu ko hambu hataholi nggelok bei taa mate sala boe, tehuu fai toꞌa-taak ndia losa so. ");
INSERT INTO llg_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Leomae lalai ma daebafok mopo sala so, tehuu Au Hala Kokolang ia, nahele losa taa mana basak. ");
INSERT INTO llg_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Yesus kokolak nakadaik, nae, “Taa hambu hataholi esa boe, ana bubuluk fai hida Au fai do liꞌu fali maing. Manetualain ata nusa-soda nala boe oo, taa bubuluk. Au mesa nggau boe oo, taa bubuluk. Kada Au Amang mesa kana bubuluk. ");
INSERT INTO llg_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Huu ndia de, ei musi manea matalolole, huu ei taa bubuluk fai hida fain ndia. ");
INSERT INTO llg_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Taa dook so bali, Au laꞌo ela ei basa nggei. Tehuu dei fo Au fali maing. Sama leo maumak laꞌo ela uman fo ana neni dae dook neu. Ana palenda ana uma dale nala fo lakaneni neulalau uma ndia. Ma ana baꞌe fee sala esa-esako ue-leꞌdin. Ana palenda mana manea lelesu fo lanea neulalau losa ana fali main. ");
INSERT INTO llg_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ei boe oo musi manea leledo-leꞌodaen, huu ei taa bubuluk faik bee ndia, fo, maumak fali main. Ana fali ledo bobok do, fatiladak do, leledok do, ledo saduk do, ei taa bubuluk faik bee ndia. ");
INSERT INTO llg_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Boso losak ana mai no kaiboik, tehuu ana hambu ei bei sunggu masanggolo. ");
INSERT INTO llg_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","De, hata fo Au afada ei ia, na, Au afadan neu basa hataholi feꞌe kala boe oo ae, ‘Ei musi manea matalolole fo simbok Au mamaing!’ ” (Losa ndia, boe ma Lamatuak Yesus kokolak nateꞌe kokolak no ana mana tungga nala leme lete Setun.) ");
INSERT INTO llg_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","2","Basa ndia, boe ma malangga anggama inahuuk Yahudi la, ma mese anggama la, bei lasanggak dalak fo ala sangga humu Yesus no nee-neek. Fo ala sangga tao lisan. Tehuu ala heti dalak lae, “Tataa kana dei! Ita boso humu Ndia lai-lai, huu fai-fai malole la dekak so. Boso losak hataholi noꞌu kala lahuu.” Ala kokolak lae leondia, na, huu bei faik dua bali, fo hataholi Yahudi la fai malolen, fo ala foin nade ‘Fai Paska’, ma ‘Fai Feta Loti Taa Pake Lalu Teik.’ Ma nai fai-fai malole ndia, ala lasaneda neu makahulun ele, ledoeik sila bei-baꞌi nala kalua leme nusa Masir mai. ");
INSERT INTO llg_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Nai nggolo Betania, hambu hataholi esa nade Simon. Makahulun hataholi la nunuten, huu ana hambu hedi kusta. Tehuu hatematak ia ana hai so. Basa ndia boe ma, fai malole bei taa losa, de Yesus no ana mana tungga nala leu laꞌa lai Simon uman. Ledoeik laꞌa-linu, boe ma inak esa mai natonggo no Yesus. Ana toꞌu boto esa, fo ala taon neme batu mai. Isin mina kaboo meni isi-isik, fo belin seli. Boe ma inak ndia femba natepa boto ndia tatanan. De ana diꞌa mina ndia faa-faa neu Yesus langgan, fo dadik neu tanda esa, nae ana fee hadak neu Yesus. ");
INSERT INTO llg_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Tehuu hataholi feꞌek luma laꞌa-linu lai ndia boe. Ledoeik ala lita inak tataon ndia, boe ma ala luli de ala kokolak koaok lae, “Ah! Ina hatak ia, de ana mbomboꞌa-ngganggali heni mina kaboo meni kabelik ndia no sosoan taa! ");
INSERT INTO llg_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Malolenak kada ana seꞌo mina ndia! Fo neu babaꞌe doi noꞌuk ndia neu hataholi mana toꞌa-taa kala. Huu mina kaboo menik ndia belin sama leo hataholi esa nggadin teuk esa.” ");
INSERT INTO llg_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Tehuu Yesus bala sala nae, “Ei boso makatotoꞌak inak ndia! Boso mbali ndia tataon ndia! Au amahoko, huu ana diꞌa mina kaboo menik ndia neu Au aon so. ");
INSERT INTO llg_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Hataholi mana toꞌa-taa kala lo ei tungga-tungga faik. De ei bisa tulu-fali sala sudi neu faik bee. Tehuu Au na, taa dook so, tehuu Au taa akabubua ua ei so. ");
INSERT INTO llg_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Au sodang taa nala dook so. Ma isinaak inak ia ana diꞌa mina neu Au, na ana nalalau memak Au aong, sama leo ana loloo memak bungga neu Au mbombolang so, neu faik fo latoi Au. ");
INSERT INTO llg_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Masaneneꞌdak matalolole baa! Nai mamanak bee fo Manetualain Dedeꞌa-Kokola Malolen ia nana tui-benggak ndule daebafok ia, na, neu ko ala tui inak ia tatao malolen ndia. Fo suek basa hataholi la lasaneneꞌdak ndia.” ");
INSERT INTO llg_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Basa boe ma, hambu hataholi esa neme Yesus ana mana tungga kasanahulu dua nala mai, nade Yudas Iskariot. Ana kalua neu sangga malangga anggama Yahudi la, fo ana sangga seꞌo heni Yesus neu sala. Ana losa sila, boe ma nafada ndia maksud. ");
INSERT INTO llg_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ledoeik malangga nala lamanene Yudas kokolan ndia, boe ma, lamahoko lalan seli. De ala helun lae, “Mete ma o nau seꞌo Yesus neu ai, na, ai bae o.” Boe ma Yudas deak neu, de ana sangga dalak fo ana fee Yesus neu sala. ");
INSERT INTO llg_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Faik ndia tuda laꞌeneu fai kaesan neme hataholi Yahudi la fai-fai malolen. De, faik ndia, ala lateme hotu loti taa pake lalu teik, ma ala hala biꞌilombo boe. Basa ndia, boe ma Yesus ana mana tungga nala mai latanen lae, “Ama aa! Faik ia, ita fai malole Paska so. De, Ama nau ai miu sadia mamanak feta Paska nai bee?” ");
INSERT INTO llg_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Boe ma Yesus nadenu ana mana tunggan dua, nae, “Ei dua nggei makahuluk mini kota miu. Neu ko nai ele, ei matonggo mia touk esa luꞌa oe neu nggusi anak esa. Ei miu tunggan leo. ");
INSERT INTO llg_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Mete ma ana neni uma bee dalek neu, na, ei tunggan mini ndia miu. Basa na, mafada maumak mae, ‘Ama aa! Ai Ama Mesen noke mamanak esa, fo Ana sangga paken tao feta Paska no Ndia ana mana tungga nala.’ ");
INSERT INTO llg_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Basa, na, dei fo hataholi ndia natudu ei kama maloa esa nai uma tadan lain. Ana sadia nala kama ndia mana daik so. Kada ei dua nggei miu sadia nanaak nai ndia leo.” ");
INSERT INTO llg_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Basa boe ma, dua sala laꞌo leni kota leu. Nai ele, latonggo lo basa hata fo Yesus nafada memak ndia so. Boe ma ala sadia lala basa-basan fo Yesus ala laꞌa feta Paska lai ndia. Boe ma dua sala leu loke Yesus asa. ");
INSERT INTO llg_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ledoeik ledo tesa so, boe ma Yesus no Ndia ana mana tungga kasanahulu dua nala leni ndia leu. ");
INSERT INTO llg_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Basa boe ma langgatuuk de laꞌa-linu sama-sama. Ledoeik ala bei laꞌa-linu, boe ma Yesus nakokola, nae, “Ei mamanene baa! Hambu hataholi esa neme ei mai, neu ko ana seꞌo heni Au, neu hataholi feꞌe kala.” ");
INSERT INTO llg_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Lamanene leondia, boe ma lameda dale nala taa malole. Boe ma sila esa-esak latane Yesus lae, “Hataholi fo Ama mafadak ndia, memak taa ndia au hetu maa?!” ");
INSERT INTO llg_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesus nataa nae, “Hataholi fo mana deta lotin sama-sama no Au, neni manggo ia dalek neu, na, ndia ndia, ana seꞌo Au. ");
INSERT INTO llg_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Masanenedak baa! Au fo Hataholi Isi-isik ia musi mate, sama leo ala sulak memak nai Manetualain Susula Malalaon dalek so. Tehuu mata neuk! Huu hataholi mana seꞌo Au ndia, neu ko ana lemba ndia soen! Malolenak hataholi ndia, boso inan bonggin!” ");
INSERT INTO llg_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ledoeik ala bei laꞌa-linu, boe ma Yesus haꞌi nala loti katemak esa, de noke makasi neu Manetualain. Basa boe ma, Ana bibiꞌi loti ndia, de Ana loon neu ana mana tungga nala. Boe ma nae, “Loti ia Au aong ndindia. De haꞌi malan fo miꞌa leo.” ");
INSERT INTO llg_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Basa boe ma Ana haꞌi nala nggalaas fo oe anggol nai dalek. Ndia boe oo, noke makasi neu Manetualain. Basa boe ma Ana loon nggalaas ndia, neu ana mana tungga nala fo linu. ");
INSERT INTO llg_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Boe ma Ana nae, “Anggol ia, Au daang ndindia. Neu ko faa henin fo fee sodak neu hataholi noꞌu kala. Daak ia, dadik buti fo tao nasaneneꞌdak, nae, hata fo Manetualain helu basan so, memak hatematak ia ana dadi so. De haꞌi malan fo minu leo. ");
INSERT INTO llg_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Mamanene matalolole dei! Neme leꞌodaen ia neu, Au taa inu anggol ia so, losa Au Amang manai nusa-sodak nanggatuuk palenda, bei fo Au inu seluk bali.” ");
INSERT INTO llg_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Basa boe ma, ala soda sosodak esa, fo ala koa-kio Manetualain. Boe ma ala kalua leꞌodaen ndia, de leni lete Setun lain leu. ");
INSERT INTO llg_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ledoeik ala bei laꞌo-laꞌo, boe ma Yesus nafada mema kasa nae, “Neu ko leꞌodaen ia, ei basa nggei malai laꞌo ela Au. Huu nana sulak memak so, nai Manetualain susulan dale nae, ‘Neu ko Manetualain tao nisa mana hoo, boe ma biꞌilombo nala lalai sasalak.’ ");
INSERT INTO llg_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Memak Au mate, tehuu mete ma Au asoda fali so, na Au akahuluk ei, uni nusa Galilea uu.” ");
INSERT INTO llg_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Basa boe ma Petrus simbok nae, “Ama aa! Leomae basa hataholi la ia, lalai laꞌo ela Ama, tehuu au na taa!” ");
INSERT INTO llg_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesus nataa nae, “Peꞌu! Masanenedak, dei! Leꞌodaen ia, manu bei taa kokoa laꞌi dua, tehuu o malelesi Au laꞌi telu so!” ");
INSERT INTO llg_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Tehuu Petrus mboka nae, “Taa Ama! Mete ma Ama mate, na, au boe oo mate sama-sama ua Ama. Huu au taa alai laꞌo ela Ama, ma, taa alelesi Ama!” Petrus nonoo nala boe oo esa-esak lakokola lae leo ndia boe. ");
INSERT INTO llg_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Basa ndia, boe ma Yesus asa laꞌo lakandoo, losa osi esa nai Lete Setun nade ‘Getsemani’. Boe ma Yesus nafada sala nae, “Ei manggatuuk mahani mima ia leo! Huu Au sangga uu hule-haladoi nai ele.” ");
INSERT INTO llg_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Boe ma Yesus noke no Petrus, Yakobis, ma Yohanis, fo leu noꞌu. Mulai neme faik ndia mai, Ndia dalen nameda hedis, ma taa tesa. ");
INSERT INTO llg_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ana nafada sala, nae, “Au daleng hedin seli! Au ameda nonook bali Au sangga mate ia so. Ei manggatuuk ma manea mima ia dei!” ");
INSERT INTO llg_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Boe ma Ana laꞌok hodok neu dook fa, boe ma Ana sendek lunggu-langgan neu dae, de Ana hule-haladoi nae, “Ama susuek! Mete ma Ama nau, na, Au boso lemba doidoso leoiak. Au bubuluk memak taa hambu hata esa boe, fo Ama taa tao malan. De mete ma Ama nau na, makadodook doidosok ia neme Au mai. Tehuu boso tungga Au hihiing; ela tungga kada Ama hihii-nanaun mesan.” ");
INSERT INTO llg_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Basa boe ma Ana fali neni Ndia ana mana tungga katelu kala neu, tehuu ala sunggu lamanee. Ana fafae nafoꞌa sala, boe ma nafada Petrus nae, “Wei Peꞌu aa! O sunggu do? Au uni ele uu taa doo anak boe, tehuu ei taa beꞌe fa boe?! ");
INSERT INTO llg_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Kukuku mamaneneu ei mata mala dei, fo basa na foꞌa fo beꞌe mia Au dei! Ei dalem nahiik tao malole, tehuu ei ao mbaam taa balakaik. De malolenak ei hule-haladoi fo mete ma hambu soba-douk, na, ei taa nana senggik.” ");
INSERT INTO llg_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Basa boe ma Yesus neu hule-haladoi laꞌi esa seluk bali. Ana noke seluk neu Lamatuak, fo Ana boso feen lemba nahele doidosok ndia. ");
INSERT INTO llg_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Basa boe ma Ana fali seluk neni ana mana tungga katelu nala sila neu. Tehuu ala sunggu seluk bali, nenik mata nala lamabela lalan seli. Basa boe ma Ana fafae nafoꞌa selu kasa, tehuu ala taa bubuluk lataa Ndia lae leobee. ");
INSERT INTO llg_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Basa ndia boe ma Yesus Ana laꞌo ela sala, de neu hule-haladoi neu kalaꞌi telun. Boe ma Ana fali seluk, de Ana fafae nafoꞌa sala. Nafada sala nae, “Ei bei sunggu do? Dai ndia so! Foꞌa leo! Huu hataholi fo mana seꞌo Au, fo Hataholi Isi-isik ia, ana deka so. Hatematak ia ala sangga humu Au, fo ala fee Au uni hataholi manggalau kala liman neu. ");
INSERT INTO llg_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Foꞌa leo! Mamaneneu ei mata mala, fo mita sudik mini ele miu dei! Huu hataholi mana seꞌo Au, ana mai so. Mai fo teu tatonggo to sala!” ");
INSERT INTO llg_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ledoeik fo, Yesus bei kola-kola leondia, boe ma nggengge neuk Yudas no hataholi noꞌu kala mai so. Ala mai leni tafa kekeꞌuk ma ai kekeꞌuk, fo sangga humu Yesus. Ala tao leondiak, na, tungga malangga-malangga Yahudi la palenda nala. Sila ndia, malangga anggama la malangga nala, mese anggama la, ma lasi hada kala. ");
INSERT INTO llg_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yudas fee mema kasa tanda nae, “Ei mete matalolole baa! Mete ma au iꞌdu see ndia, na ei humun malan leo! Huu Ndia ndia, fo ei sanggak ndindia.” ");
INSERT INTO llg_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","De, ledoeik Yudas losa ndia, boe ma Yudas nakandoo nasale nala Yesus. Boe ma nafadan, nae, “Ama mesen!” Boe ma Yudas holu nalan de ana idun. ");
INSERT INTO llg_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Boe ma hataholi nou kala sila ala mata leu, de ala humu lala Yesus. ");
INSERT INTO llg_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Tehuu Yesus ana mana tunggan esa feꞌa nala tafa kekeꞌun, de ana sambi naketu heni hataholi esa ndiꞌidoon. Hataholi ndiꞌidoo ketuk ndia, na, malangga inahuu anggama Yahudi hataholi nadedenun ndia. ");
INSERT INTO llg_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Boe ma Yesus kokolak no mana humu kala sila nae, “Talobee? De ei maehetuk Au ia hataholi manggalauk do? De ei mai humu Au minik tafa ma ai kekeꞌuk? ");
INSERT INTO llg_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Tungga-tungga faik Au anoli ei nai Manetualain Uma Ina Huhule-haladoin dale, tehuu ei esa taa mai humu Au boe. De mai humu Au leo. Huu dedeꞌak ia nana sulak memak neme makahulun ele mai, nai Manetualain Susula Malalaon so.” ");
INSERT INTO llg_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Yesus ana mana tungga nala bii lalan seli losa basa sala lalai laꞌo ela Yesus mesa kana. ");
INSERT INTO llg_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Nai ndia boe, hambu taꞌeꞌanak esa ana tungga doꞌo-doꞌo no Yesus dean. Ana naluse tema bibiak esa. Hataholi la sila boe oo, ala sangga humun. ");
INSERT INTO llg_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Tehuu ala ndaso lala kada tema nalusen ndia, Basa de, nalai fali nakahola, huu ana bii nalan seli. ");
INSERT INTO llg_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Basa boe ma toꞌu loo Yesus neni malangga anggama inahuuk Yahudi uman neu. Hataholi inahuu nala lakabua lai ndia so. Hataholi sila ndia, malangga anggama la, mese anggama la, ma lasi-lasi haꞌda kala. ");
INSERT INTO llg_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ledoeik fo ala toꞌu loo Yesus ndia leu, boe ma Petrus babi-babi tungga dea, de ana losa malangga inahuuk anggama Yahudi uman pasan neu. Ndia boe oo, maso neni uma pasan neu, de nanggatuuk dala haꞌi noꞌu no hataholi mana manea lai ndia. ");
INSERT INTO llg_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Nai uma ndia dalek, malangga anggama la bekola lo hataholi mana maketu dedeꞌa anggama la. Basa sala sangga buti, fo ala fee salak neu Yesus, huu ala sangga huku lisa Ndia. Tehuu ala taa hambu buti faa boe. ");
INSERT INTO llg_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Boe ma ala loke lala hataholi noꞌu kala fo ala sakasii sangga tao latuꞌda Yesus. Tehuu tutui nala boe oo, mana kofeꞌek esa no esa. ");
INSERT INTO llg_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Boe ma hambu sakasii luma bali ala foꞌa lambadeik, de ala tui pepekok lae, ");
INSERT INTO llg_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ai mamanene hataholi ia kokolak nae, ‘Dei fo Au tao atuꞌu heni Uma Ina Huhule-haladoik ia, fo hataholi la lambadedein lenik lima nala. Boe ma fai katelun, na, Au ambadedei falik Uma ndia. Tehuu taa pake hataholi liman.’ ” ");
INSERT INTO llg_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Tehuu ala kokolak ndia, esa taa nandaa no esa boe. ");
INSERT INTO llg_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Basa boe ma Malangga inahuu anggama Yahudi foꞌa nambadeik neu basa hataholi la sila matan. De natane Yesus nae, “Hataholi noꞌu kala kalaak O so! Tehuu hatina de kada O nee-nee?” ");
INSERT INTO llg_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Tehuu Yesus taa nataa faa boe. Basa boe ma malangga inahuuk ndia natane selu kana nae, “Soba O mafada sudik dei. Memak tetebes O ia Karistus fo Manetualain Anan fo nana helu basak neme makahulun mai, ndia so?” ");
INSERT INTO llg_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesus nataa nae, “Memak tetebes, Au ndindia. Dei fo ei basa nggei mita Au, Hataholi Isi-isik ia, nanggatuuk nai nusa-sodak fo nai Manetualain boboa konan. Ndia koasan ana seli! Neu ko Au ma Ndia, toꞌu palenda noꞌu. Basa ndia, na, dei fo Au konda ua koꞌas neme nusa-sodak mai.” ");
INSERT INTO llg_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Namanene Yesus kokolak nae leondia, boe ma malangga inahuuk anggama Yahudi ndia, luli nalan seli, losa ana sii heni badu nalun. Basa boe ma ana nafada no hala belak neu hataholi mana manggatuuk lai mamana nakeketu dedeꞌa anggama ndia nae, “Ita taa paluu sakasii so! ");
INSERT INTO llg_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ei mamanene minik ei ndiꞌidoo heheli mala, Ndia mesa kana kokolak nae leondia hetu? Ana sou aon dadik neu Manetualain Anan. Namumulu belak ia! Tungga anggama heti-heun na, mete ma hambu hataholi esa tao aon sama leo Manetualain, na hataholi ndia musi maten! De hatematak ia, ei sangga maketun leobee?” Boe ma basa sala laketu lae, “Memak hataholi ia ana sala tetebes. Huu ndia de musi huku nisan!” ");
INSERT INTO llg_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Boe ma hataholi luma ala mata leu de ala mbula ambe neu Yesus. Ala mboti ketu matan, boe ma ala mbombokon. Boe ma latanen lae, “Soba O neuk sudik. See ndia tutu O?” Basa boe ma ala palenda hataholi mana manea Uma Ina Huhule-haladoik ndia fo hela loo Yesus. Ala loo Ndia leu, boe ma ala famba lakamiminak Ndia. ");
INSERT INTO llg_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Ledoeik ndia, Petrus bei nanggatuuk nai uma pasan. Boe ma Malangga Inahuu Anggama Yahudi ata inan esa mai, de nitan ana dala haꞌi. Boe ma ana mete besa-besa no Petrus matan de nae, “Isinaak o boe oo tungga sama-sama mua Yesus, hataholi Nasaret ndia, hetu? Tetebes hetu ma?!” ");
INSERT INTO llg_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Tehuu Petrus nataa nae, “Taa! Huu hatina de o matane leondiak! Au taa alela Ndia.” Basa ndia boe ma Petrus foꞌa de nambadeik neu mbaꞌa lelesu matan. Nandaa no ledoeik ndia boe oo, manu kokoa. ");
INSERT INTO llg_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Boe ma, ata inak ndia, nita seluk Petrus, de nafada hataholi malai sila kala, nae, “Hataholi ia, esa neme hataholi la sila mai!” ");
INSERT INTO llg_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Tehuu Petrus taa nau simbok, de nae, “Fama o kamuluk do! Au taa alelak Hataholi ndia, maa!” Doo-doo boe ma hataholi feꞌek esa manai ndiak ana kokolak neu Petrus bali, nae, “Wei! O bei masapepeko bali, mae o taa sama-sama mua hataholi la sila? Wei! Ei basanggei hataholi Galilea hetu!” ");
INSERT INTO llg_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Tehuu Petrus nalelesi seluk nae, “Wei. Au soo! Au taa alelak hataholi ndia fa boe.” ");
INSERT INTO llg_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Nandaa no ana kokolak nae leondia, boe ma manu kokoa seluk kalaꞌi duan. Boe ma Petrus nasaneda Yesus kokolan isinaak ndia nae, “Manu bei taa kokoa laꞌi dua, tehuu o malelesi Au laꞌi telu so.” Petrus nasaneda leondia, boe ma ana namatani-nakaleleu. ");
INSERT INTO llg_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Fafai anan, basa hataholi malai mamana naketu dedeꞌak, lala halak, fo sangga tao lisa Yesus. Boe ma ala mbaꞌa loo Yesus neu nasale gubenol Pilatus. ");
INSERT INTO llg_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ala losa, boe ma gubenol natane Yesus nae, “Leobee? O ia tetebes Mane Yahudi do?” Yesus nataa nae, “Tetebes! Ama gubenol kokolak ndaan ndia so.” ");
INSERT INTO llg_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Basa boe ma malangga anggama Yahudi la kokolak lo gubenol, lae, “Hataholi ia tao salak taa faak so!” Boe ma lafada Ndia sala nala esa-esa. ");
INSERT INTO llg_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Gubenol natane seluk Yesus nae, “O taa mamanene sila kokola nala? Ala fee salak noꞌun seli neu O. De, hena O balan dei.” ");
INSERT INTO llg_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Tehuu Yesus taa nataa hata fa boe, losa gubenol heran nalan seli. ");
INSERT INTO llg_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Tungga-tungga teuk, mete ma hataholi Yahudi la tao feta Paska, na, hataholi noꞌu kala sila, lateme ala hele lala hataholi bui esa fo gubenol mboꞌin. ");
INSERT INTO llg_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Faik ndia hambu hataholi bui esa nade Barabas. Makahulun, ala humu lala ndia no nonoo nala, huu ana laban mana palenda Roma, ma ana tao nisa hataholi boe. ");
INSERT INTO llg_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Huu feta Paska deka-deka so, de, hataholi noꞌuk leni gubenol Pilatus leu, de ala eki lae, “Ama gubenol! Fai Paska losa so! Mete ma bisa, na, ama gubenol mboꞌi fee ai hataholi bui esa fo leo ita natetemen!” ");
INSERT INTO llg_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Boe ma gubenol nataa, nae, “Au mboꞌi fee ei, see? Leobee mete ma au mboꞌi fee ei Mane Yahudi ia do? Ei makaheik, do taa?” ");
INSERT INTO llg_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Gubenol kokolak nae leondia, naa te ana bubuluk so, basa malangga anggama la, loo Yesus neni ndia neu, huu ala husembuluk neu Yesus. ");
INSERT INTO llg_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Tehuu malangga anggama la mbauedo hataholi noꞌu kala sila, fo basa sala loke gubenol lae, “Ai taa hii Ndia! De kada mboꞌi heni Barabas leo!” ");
INSERT INTO llg_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Basa boe ma, gubenol natane seluk nae, “Mete ma leondiak, na, au tao Yesus ia leobee, fo loken, na, lae, ‘Mane Yahudi’ ia?” ");
INSERT INTO llg_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Boe ma basa sala eki landaa-landaa lae, “Tao misan! Mbaku misan neu ai ngganggek!” ");
INSERT INTO llg_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Boe ma gubenol natane nae, “Tehuu Ana sala hata? Au palisak Ndia so, tehuu au taa hambu salan fa boe!” Tehuu ala boe eki latingga bali, lae, “Tao misan! Mbaku misan neu ai ngganggek leo!” ");
INSERT INTO llg_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Huu gubenol sangga tao namahoko hataholi noꞌu kala sila dale nala, de ana mboꞌi heni Barabas tungga sila hihiin. Boe ma ana palenda hataholi mana manea kala, fo leu filo Yesus. Ala filo lateꞌe, boe ma soldadula loon, fo sangga leu mbaku lisan nai ai ngganggek. ");
INSERT INTO llg_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Basa ndia boe ma soldadu la hela loo Yesus leni sila kota musun pasa maloan neu. Leu ndia boe ma ala loke lala sila nonoo nala batalion esa. ");
INSERT INTO llg_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Boe ma ala fee Yesus pake badu manalu mbila-balanggeok esa, sama leo mane kala lateme paken. Basa boe ma, ala haꞌi lala ai dilak ndanan, de ala nanen dadik solangga. Boe ma ala neꞌe solangga dilak ndia neu Yesus langgan de ala tao lakamimina kana leo ala soꞌu mane beuk, pake solangga manek. ");
INSERT INTO llg_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Boe ma basa sala fee hadak lakamiminak Ndia, lae, “Soda-molek, mane Yahudi!” ");
INSERT INTO llg_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ma ala taok sendek lakamiminak fee hadak neu Yesus matan. Basa de, ala mbula lakaduduak ambe neu Yesus matan. Basa de, ala denggu lakauꞌutak Ndia lenik ai. ");
INSERT INTO llg_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ala lakamimina kana basa, boe ma ala oꞌdu heni badu nalun. De ala oꞌdu falik badun neu seluk. Basa boe ma, loon kalua neni kota Yerusalem deak neu, fo ala leu mbaku londa lisan nai ai ngganggek. ");
INSERT INTO llg_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ledoeik ala kalua leme kota Yerusalem mai, de ala lala dala laladak boe ma latonggo lo touk esa neme kota Kirene mai. Touk ndia nade Simon, fo Alexander no Rufus aman. Bei fo ana sangga losa Yerusalem, tehuu soldadu la toꞌu lalan de lakasetin ana luꞌa Yesus ai ngganggen. ");
INSERT INTO llg_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ala hela loo Yesus losa mamanak esa nade Golgota. (Ndia sosoan nae, ‘mamanak langgaduik.’) ");
INSERT INTO llg_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Leu ndia, boe ma ala nau fee Yesus ninu anggol oek makeis fo nana seseok no akidook, suek Ana nakatataka hedis. Tehuu Yesus taa nau ninu. ");
INSERT INTO llg_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Boe ma ala mbaku lakalelenggak Yesus neu ai ngganggek. Boe ma ala lambadedei ai ngganggek ndia, meda neu liꞌu sio fafain. Boe ma soldadu la leꞌa lot, fo ala sangga bubuluk see ndia hambu Yesus baloꞌa-papaken. ");
INSERT INTO llg_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Boe ma ala sulak neu papak esa nae, “Ia, hataholi Yahudi la Manen.” Ala pake toꞌok ndia, fo huku Yesus. ");
INSERT INTO llg_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ala mbaku lisa tou nakodaa dua, lai ndia boe. Esa nai Yesus boboa konan; esa nai Yesus boboa kiin. ");
INSERT INTO llg_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","No leondiak ala tungga hata fo nana sulak memak nai Manetualain Susula Malalaon dalek nae. “Ala tao Ndia sama leo hataholi manggalauk.” ");
INSERT INTO llg_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Basa hataholi mana laꞌok lesik ndia, lita Yesus nana londak nai ai nggange ndia. Boe ma ala kakalek langgan fo haumeme lakamamaek Yesus, lae, “Wei! O mae O tao matuꞌu Manetualain Uma Ina Huhule-haladoin, fo basa na o mambadedei fali kana nai faik telu dalen, hetu? ");
INSERT INTO llg_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Heni O konda muma ai ngganggek ndia lain mai, fo makammboꞌik heni O aoinam leo! Mete ma leondiak na, bei fo ai mamahele memak, mae O ia Manetualain Anan.” ");
INSERT INTO llg_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Malangga anggama Yahudi la malangga nala, ma mese anggama la boe oo, ala haumeme Yesus, ma lakokola lae, “Ana tao nasoda hataholi feꞌek, tehuu taa bisa tao nasoda Ndia aoinan hehelin! ");
INSERT INTO llg_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ana nafada nae, Ndia ndia ‘Karistus’, Hataholi fo Manetualain helu mema kana neme makahulun ele mai so. Hataholi feꞌek lae, Ndia ndia, hataholi Israel Manen. Mete ma tetebes leondiak, na elan Ana konda aon neme ai ngganggek lain mai, fo ita tita sudi kana dei. Leondiak, bei fo ita basa nggata bisa tamahele Ndia.” Hataholi kadua kala fo nana londak lo Yesus boe oo, ala tungga haumeme Ndia boe. ");
INSERT INTO llg_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Basa ndia, boe ma makiuk mboti nala mamanak ndia, neme ledo kamatetun losa liꞌu telu ledo bobon. ");
INSERT INTO llg_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Nandaa no liꞌu telu ledo bobon, boe ma Yesus nanggou nenik dedeꞌa Aram nae, “Eloi! Eloi! Lema sabaktani?” (Ndia sosoan nae, “Au Lamatuang! Au Manetualain aa! Hatina deAma laꞌo ela Au leo iak?”) ");
INSERT INTO llg_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Hataholi luma mana dekak lai ndia, lamanene Yesus halan ndia. Boe ma ala lae, “Wei!, Ei mamanene dei. Ana noke Elia, fo Manetualain mana kokola makahulun ele ndia!” ");
INSERT INTO llg_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Boe ma hataholi esa nalaik-nalaik mesan neu haꞌi lombu, de ana domben neni anggol oek makeis dale neu. Boe ma ana kofu lombu neu teteꞌe-aik esa mbeꞌdan, de ana loo kana neu Yesus bifidoon fo nasamusi. Basa ndia boe ma hataholi la kokolak lae, “Mahani fo ata mete sudi kana dei! See bubuluk nae fama Baꞌi Elia mai nakondan neme ai nggangge lain mai.” ");
INSERT INTO llg_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Basa boe ma, Yesus nanggou laꞌi esa seluk bali, boe ma maten. ");
INSERT INTO llg_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Nai Uma Ina Huhule-haladoik dale, ala londa tema lelesu maloa esa fo babaa neu Manetualain Kama Malalaon. Nandaa no ketu Yesus ani hahaen, boe ma tema lelesu maloa ndia, sii baꞌen neu dua, neme lain mai, losa dae. ");
INSERT INTO llg_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Nai Golgota malangga soldadu esa nambadeik nanea dekak no Yesus nai ai ngganggen. Ledoeik ana nita Yesus mamaten, boe ma ana nggengge. Basa de ana nae, “Awi! Hataholi ia memak tetebes Manetualain Anan bae maa!” ");
INSERT INTO llg_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Ma inak luma lambadeik lai ndia, de lita Yesus mamaten leme dook mai. Sila ndia, fo, makahulun ala ono-lau Yesus neme Galilea. Ina kala sila, Salome, Maria neme nggolok Magdala mai, ma Maria feꞌek esa boe (ndia Yakobis taꞌeanak ma Yoses inan), ma inak feꞌek noꞌu kala fo ala laꞌok sama-sama tungga Yesus neni Yerusalem mai. ");
INSERT INTO llg_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Basa ndia boe ma hataholi esa sangga dalak fo nakonda Yesus mbombolan neme ai ngganggek lain mai. Hataholi ndia nade Yusuf, neme kota Arimatea mai. Ndia boe oo, mana maketu dedeꞌa anggama Yahudi. Ndia dalen malole hiak. Ndia boe oo nahani Manetualain palendan mamain. Yesus maten laꞌe neu fai lima. Foꞌa mai, nandaa no hataholi Yahudi la fai huhule-haladoin. Huu ndia de Yusuf sangga nakonda nakahuluk Yesus mbombolan dei. Boe ma nambalalani dalen, de ana neni gubenol Pilatus neu, fo noke nakonda Yesus mbombolan. ");
INSERT INTO llg_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Gubenol namanene Yusuf nonoken ndia, boe ma ana heran, de nae, “Awii! Hataholi ndia mate lai-lai so! Au ae hetuk, taa bisa dadi leo ndiak maa!” Boe ma ana nadenu hataholi leu loke malangga soldadu fo natanen, nae, “Leobee? Yesus ndia, maten so, do beik?” ");
INSERT INTO llg_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Malangga soldadu ndia nataa nae, “Memak maten ndia isinaak so, Ama.” Gubenol namanene leondia boe ma nadenu Yusuf neu nakonda heni Yesus mbombolan. ");
INSERT INTO llg_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Boe ma Yusuf neu hasa tema naluk mabeli. De, neni Golgota neu. Boe ma ana nakonda Yesus mbombolan neme ai ngganggek lain mai. Ana mbomboti nalolole Yesus mbombolan nenik tema beuk fo belin seli. Ledoeik ndia, bei fo ala mbaꞌa lala late lua beuk esa nai lete batu. Boe ma ala koꞌo Yesus mbombolan neni lates ndia dalek neu. Ala keko lala batu bebela inahuuk esa, de ala tatana latalololen neu lates bafan. Boe ma Yusuf asa fali. ");
INSERT INTO llg_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Faik ndia Maria neme Magdala mai no Maria feꞌek (fo Yoses inan), de ala tungga losa ndia boe. Dua sala lita de lasaneneꞌdak neulalau mamanak ndia fo ala mbeda Yesus mbombolan ndia neu. ");
INSERT INTO llg_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Neu foꞌa main, laꞌe neu fai nee, fo hataholi Yahudi la fai huhule-haladoin. Faik fo ledo tesa so, boe ma Maria neme nggolok Magdala, Maria feꞌek ndia (fo Yakobis inan), no Salome leu hasa mina kaboo menik, suek foꞌa na, ala sangga leu mbimbilun neu Yesus mbombolan, tungga hataholi Yahudi la hadan. ");
INSERT INTO llg_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Neu Sosoda ina fafai anan, boe ma telu sala leni lates leu. ");
INSERT INTO llg_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","Ala losa dala laladak, boe ma telu sala lakokola lae, “Wei! Tehuu see ana bisa fali ita, fo loli heni batu inahuuk ndia, neme lates lelesun mai? Memak ita telu nggata taa tabeꞌi loli batu ndia, huu batu ndia inahuun ana seli.” Ala losa ndia, tehuu lita batu ndia, nana loli henik so. ");
INSERT INTO llg_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Boe ma ala lakandoo leni lates dale leu. Tehuu ala nggengge lalan seli, huu lita touanak esa papaken fula manggadilak, nanggatuuk nai sila boboa konan. ");
INSERT INTO llg_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Boe ma touanak ndia kokolak no sala nae, “Wei! Ei boso bii! Au bubuluk ei mai sangga Yesus maneme Nasaret mai fo ala tao lisan nai ai ngganggek lain ndia. Tehuu Ndia taa nai ia so. Ana nasoda fali so. Mai fo mita aom mamanak fo lakambembeu Yesus mbombolan ndia louk so. ");
INSERT INTO llg_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ei fali lai-lai leo! Miu mafaꞌda Petrus asa mae, Yesus Ana nasoda fali so. Ana laꞌo nakahuluk neni Galilea neu so. Neu ko ala latonggo lo Yesus nai ele, fo leo makahulun nafada basa sila so. De, ama fali leo!” ");
INSERT INTO llg_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ledoeik fo ina kala sila lita mamanak ndia louk tetebes so, boe ma ala nggengge. De lalai deak leu. De, ala fali lai-lai. Ala taa lafada see esa boe nai dala laladak, huu ala bii lalan seli. ");
INSERT INTO llg_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Sosoda ina fafain, Yesus neu natudu aon makasososan neu Maria, fo maneme nggolo Magdala mai, fo makahulun Yesus husi heni nitak nitu hitu leme inak ndia aon dale mai. ");
INSERT INTO llg_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Nita basa Yesus, boe ma ana fali de neu nafada basa hataholi la fo makahulun mana tungga Yesus. Ala bei lakabubua lo dale hedik, ma luu nala tuda huu lasaneda Yesus mamaten. ");
INSERT INTO llg_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Basa boe ma Maria nafada sala nae, “Talobee, de ei bei dale hedi? Boso dale hedi bali, huu Yesus nasoda fali so. Bei lai-laik ia, au atonggo ua Ndia so!” Tehuu sila basa sala lataa lae, “Wei, O pepeko ndia!” ");
INSERT INTO llg_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Basa ndia boe ma Yesus ana mana tungga nala dua leni nggolok esa leu. Ala losa dala lalaꞌdak, boe ma Yesus natudu aon neu dua sala. Tehuu Yesus namata-ao feꞌek. Tehuu taa dook boe ma lalela kana. ");
INSERT INTO llg_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","De dua sala fali leu lafada nonoo nala lae, “Wei, mamanene dei! Isinaak ai bei fo ai matonggo mia Yesus neme dala laladak!” Tehuu basa nonoo nala lataa lae, “Wei! Ei boso pepeko leo ndiak.” ");
INSERT INTO llg_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Boe ma Yesus natonggo no ana mana tungga kasanahulu esa nala, neu ledoeik fo bei laꞌa-linu. Nafada sala nae, “Wei! Ei langga batu nala seli! Hataholi la lafada ei lae, lita Au no sila mata deꞌe heheli nala so, tehuu ei taa nau mamahele fa boe, maa! Ei mafada mae, basa sala pepeko ndia! Hatematak ia Au mai matang so. Memak Au mate so, tehuu hatematak ia, ei mita mata nggei, Au asoda asafali so! De, ei mita mata nggei leo. ");
INSERT INTO llg_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","De, hatematak ia ei musi miu laꞌok ndule daebafok ia, fo miu mafada basa hataholi la, Au Tutui Maloleng ia. ");
INSERT INTO llg_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Hataholi fo namahele neu Au, ma ana hambu salanik, na, neu ko Manetualain feen sodak, fo, ana leo losa dodoon neu, no Manetualain nai nusa-sodak. Tehuu hataholi fo taa namahele, na, neu ko ana hambu huhukuk, ma Manetualain timba henin, fo ana leo nai nusa-sodak deak losa dodoon neu. ");
INSERT INTO llg_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ma hataholi fo namahele neu Au, neu ko ala tao tanda heran mata-mata kala fo basa hataholi la lamahele lae sila koasan ndia memak neme Manetualain mai. Leo, neu ko ala husi nitu la pake Au nadeng. Neu ko Manetualain tao nala sala bisa lakokola pake dedeꞌa feꞌek, fo ala taa bubuluk. ");
INSERT INTO llg_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Boe ma mete ma ala toꞌu mengge kalasok, do linu laꞌe laso, na, ala taa hambu soe. Boe ma mete ma ala tao lima nala fo hule-haladoi fee hataholi kamahedik, na, neu ko hataholi ndia hai.” ");
INSERT INTO llg_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Yesus kokolak no basa ana mana tungga nala, boe ma Manetualain soꞌun neni nusa soꞌdak dalek neu. Nai ndia Ana dadik neu Manetualain lima boboa konan, fo dua sala palenda leu esa. ");
INSERT INTO llg_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Basa boe ma ana mana tungga nala tungga Ndia palendan. Ala leni basa sudi bee leu, de ala tui-bengga Yesus Tutui Malolen neu basa hataholi la. Boe ma Manetualain fee sala koasa, fo ala tao tanda heran fo sama leo Yesus nafadak ndia so. Boe ma hataholi noꞌu kala lamahele Yesus, huu ala bubuluk lae, Tutui Malole ndia, memak tetebes. Ledoeik fo ina katelu kala sila losa Petrus no nonoo nala, boe ma ala tui sala basa dedeꞌa kala, laꞌeneu touanak fo mana kokolak no sala leme lates isinaak ndia. Basa boe ma, Yesus mesa kana palenda ana mana tungga nala, fo leu tui-bengga Tutui Malole ia nai basa mamanak lalaꞌen, losa daebafok buꞌu nala. Tutui Malole ia natudu dalak fo Manetualain tao nasoda hataholi la leme sala-singgo nala mai, suek lasoda lakandoo lo Ndia. Tutui Malole ia, memak tetebes. Huu ndia. de nahele nakandoo, losa taa mana basak. ");
INSERT INTO llg_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","3","Ama Teofilus fo nana hadak. Soda-molek. Hataholi noꞌu kala, soba sulak so, tutuik laꞌeneu dedeꞌa kala mana dadik nai ai lalada nala. Ala sulak tutui kala sila, lenik tutuik fo ana eo neme ai mai, ma neni ai mai seluk neme makahulun mai. Tutui kala sila fo ai bubulu kana neme Lamatuak Yesus hataholi nala mana deka lo Ndia, ma neme hataholi feꞌek mai boe, fo nita no mata deꞌe hehelin. Basa tutui kala sila, nandaa leo Manetualain helu mema kana, neme makahulun mai so. De, au palisa kana lutu-lutuk basa sila so, mulai neme tutuik ndia huu-okan. Boe ma au aketun, fo sulak basa sila, no malole, tungga ndia tutunggan. No leo ndiak, na ama bisa bubuluk no teteben, hata fo ana dadi so. ");
INSERT INTO llg_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ma ama boe oo, bisa mamahele, hata fo hataholi la tuik ndia tetebes. Basa sila memak mana dadik so! ");
INSERT INTO llg_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Tutuik ia huun leo iak: faik fo Mane Herodes toꞌu palenda nai propinsi Yudea, hambu hataholi esa nade Zakarias. Ndia ndia, esa neme malangga anggama Yahudi la mai. Ma ndia boe oo, neme baꞌi Abia buao malangga anggaman mai. Zakarias saon, nade Elisabet. Ndia boe oo, tititi-nonosik neme malangga anggama la mai, huu ndia ndia, baꞌi Musa kaꞌan Harun tititi-nonosin ");
INSERT INTO llg_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Dua sala lasoda lo ndoos, tungga Manetualain palendan, ma basa heti-heu nala. Hataholi la boe oo, fee hadak neu sala. ");
INSERT INTO llg_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Dua sala lamalasi so, tehuu ana nala ta, huu Elisabet anamanan, nana kenak. ");
INSERT INTO llg_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Laꞌi esa, Zakarias ma ndia nonoo buao Abia nala hambu susula babaꞌe ues, nai Uma Ina Huhule-haladoik nai Yerusalem. ");
INSERT INTO llg_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Tungga sila natetemen, na malangga anggama la sila leꞌa lot, fo sangga bubuluk see hambu ues maso neni Uma Ina Huhule-haladoik Kama Malalaon Manai Lain Seli ndia dalek neu. Nai ndia, hataholi ndia musi dede ai kaboo menik nai Manetualain matan. Faik ndia, ala leꞌa lot, de lot tuda laꞌeneu Zakarias. ");
INSERT INTO llg_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Boe ma ana maso dalek neu. Ledoeik ana dede ai kaboo menik nai Kama ndia dalek, naa te hataholi noꞌu kala hule haladoi lai Uma Ina Huhule-haladoik ndia pasan. ");
INSERT INTO llg_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Kada nggengge neuk Manetualain ata nusa-sodan esa, mai nambadeik neu mamana dedede ai kaboo menik ndia boboa konan. ");
INSERT INTO llg_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Nita leo ndia, boe ma Zakarias bii nalan seli, losa ta bubuluk tao hata so. ");
INSERT INTO llg_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Tehuu ata nusa-sodak ndia, kokolak nae, “Zakarias! Boso bii bou! Huu Manetualain namanene o huhule haladoim so. De, dei fo o saom bonggi fee o, ana touanak esa. O musi foin nade Yohanis ");
INSERT INTO llg_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Dei fo hataholi noꞌu kala, lamahoko tungga noꞌu lo ei, huu ei hambu anak. Kakanak ia, dei fo tao nala o dalem namahoko. ");
INSERT INTO llg_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Lamatuak Dula Dale Malalaon koasan, no ndia, mulai neme inan bei nailun. Ana musi naluli ninu ala-lalu mata-matak. Faik fo ana inahuu mai, boe ma Manetualain paken dadik neu hataholi inahuuk. ");
INSERT INTO llg_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Dei fo ana kokoe nala hataholi Israel asa noꞌuk, fo lasafali tungga sila Lamatuan, fo ndia Manetualain. ");
INSERT INTO llg_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ndia hadan ma koasan, sama tetebes leo baꞌi Elia, fo Lamatuak mana kokola makahulun ndia. Ana mai nakahuluk neme ita Lamatuan. Ana tao nala ina-ama la, sue lasafali sila ana nala. Ma hataholi mana heok lasadea Lamatuak, ana tao nasafali sala boe, fo ala pode lasafali tungga Lamatuak hihii-nanaun. No leo ndiak, na ana tao nala hataholi la, lahehele dale nala, fo simbok Lamatuak mamain.” ");
INSERT INTO llg_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Tehuu Zakarias natane nasafali ata nusa-sodak ndia, nae, “Neme bee mai, bisa dadi!? Au ua au saong mamalasi leo iak so! De, tandan hata fo au bisa ita basa dedeꞌa kala ia dadi so?” ");
INSERT INTO llg_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Boe ma, ata nusa-sodak ndia nataa, nae, “Leo iak! Au ia Jibrael, fo Manetualain nadedenun. Ndia mesa kana nadenu au, fo au mai afada o dedeꞌa malole ia. ");
INSERT INTO llg_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Tehuu, o ta nau mamahele au kokolang ia. De, ndia tandan, fo o mokek ndia leo iak! O maam nakadita, de o ta bisa kokolak hata-hata, mulai neme hatematak ia mai, losa ei hambu kakanak ndia. Dei fo o mita aom. Huu hata fo au afadak ia, dei fo ana dadi, nandaa no ndia fain.” ");
INSERT INTO llg_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Hataholi noꞌu kala mana hule-haladoi lai deak ele, lamanggonggoak so, huu Zakarias ta kalua ndoos. ");
INSERT INTO llg_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ledoeik ana kalua deak mai, tehuu ana ta bisa kokolak hata esa so bali. Boe ma ana nakababalek nenik liman neu sala, de dei fo ala bubuluk, lae, Lamatuak natudu fee ndia so, dedeꞌa heran esa neme Kama Malalaok Nalan seli ndia dalek. ");
INSERT INTO llg_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Sila uen basan, boe ma Zakarias fali neni uman neu. ");
INSERT INTO llg_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","25","Ta dook boe ma, Elisabet naꞌilu, de ana kekek nai uman losa bulak lima. Ana kokolak nae, “Koa-Kiok neu Lamatuak! Mateꞌen Lamatuak natudu Ndia dale malolen neu au. Au hambu tititi-nonosik, de hataholi la ta lakamamaek au so bali.” ");
INSERT INTO llg_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ledoeik Elisabet ilun laꞌok bulak nee, boe ma Lamatuak haitua Ndia ata nusa-sodan esa, neni nggolok esa neu, nai propinsi Galelea, nade Nasaret. Ata nusa-sodak ndia nade Jibrael. ");
INSERT INTO llg_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Nai Nasaret hambu inanak esa, nade Maria. Maria nafufudik no touk esa nade Yusuf. Yusuf ndia, na, mane Dauk tititi-nonosin. Jibrael neu natonggo no inana Maria ndia. ");
INSERT INTO llg_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ana natudu aon neu inanak ndia, boe ma nae, “Soda-molek, ina! Manetualain hele nala o so, fo sangga tao dedeꞌa malole esa neu o. Manetualain sama-sama no o, Maria.” ");
INSERT INTO llg_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Namanene leo ndia, boe ma Maria namanggonggoak neu ata nusa-sodak kokolan ndia. Ana ta bubuluk ndia ndandaan hata. ");
INSERT INTO llg_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Boe ma ata nusa-sodak ndia tuti bali, nae, “Maria! O boso bii. Huu Manetualain naena hihiik natudu Ndia dale malolen neu o. ");
INSERT INTO llg_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ta dook so, huu o maꞌilu, boe ma dei fo o bonggi mala ana touanak esa. O musi foin nade Yesus. ");
INSERT INTO llg_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Dei fo Ana dadik Hataholi inahuuk. Dei fo Lamatuak noken na nae, ‘Ndia ndia, Au ana heheling.’ Ndia fo, Kakanak neme Manetualain fo Manai Lain Seli. Dei fo Manetualain soꞌu nalan, fo Ana toꞌu palenda, sama leo Ndia baꞌin Dauk. ");
INSERT INTO llg_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Dei fo Ana palenda hataholi Israel asa nakandondoo henin. Huu Ndia totoꞌu palendan ta mana basak.” ");
INSERT INTO llg_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Tehuu Maria natane Jibrael, nae, “Au ia, bei ta sunggu itak ua touk esa boe! De talobee, fo au bisa aꞌilu?” ");
INSERT INTO llg_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Boe ma Jibrael nataa, nae, “Leo iak! Dei fo Manetualain Dula Dale Malalaon mai neu o. Ma Manetualain fo Manai Lain Seli ndia koasan dei fo mboti nala o. No leo ndiak, na Kakanak fo dei fo o bonggik ndia, tebe-tebe malalaok. Huu Ndia ndia, Manetualain Anan. ");
INSERT INTO llg_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Boso heran! Huu o bobonggim esa, nade Elisabet, nailu so boe. Hataholi la lae, ndia ta bisa bonggi so, huu ndia lasik so. Tehuu hatematak ia, ndia tein, laꞌok bulak nee ia so. ");
INSERT INTO llg_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Huu soaneu Manetualain, na basan bisa dadi!” ");
INSERT INTO llg_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Boe ma Maria nataa nae, “Malole. Au ia Manetualain atan. De ela basan dadi tungga o kokolam ndia. Au ahehele tungga kada Lamatuak hihii-nanaun.” Basa boe ma ata nusa-sodak ndia, laꞌo elan. ");
INSERT INTO llg_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Seli faik hida, boe ma Maria laꞌo lai-lai neme Nasaret mai, neni Zakarias nggolon neu, nai letek manai Yudea. Losa ndia, de ana maso tutik neni Zakarias uman neu. Boe ma ana fee hadak neu Elisabet. ");
INSERT INTO llg_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ledoeik Elisabet namanene Maria fee hadak neu ndia, boe ma kakanak manai Elisabet tein dale, nafoki. Ma Lamatuak Dula Dale Malalalon maso neni Elisabet dalen neu. ");
INSERT INTO llg_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Boe ma ana kokolak natingga nae, “Maria! Dei fo hataholi la, soꞌu lamadedema o nadem, lena heni basa ina kala malai daebafok ia! Dei fo hataholi la, soꞌu lamadedema kakanak manai o teim dale ndia! ");
INSERT INTO llg_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Au boe oo, nanasoꞌuk tungga, huu au Lamatuang inan mai natonggo no au. ");
INSERT INTO llg_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ledoeik o maso fee hadak neu au leo ndiak, boe ma tutik au anang manai au teing dale, nafoki, huu namahoko. ");
INSERT INTO llg_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Manetualain natudu Ndia dale malolen neu o so, huu o mamahele, Ana sangga tao tungga Ndia hehelun.” ");
INSERT INTO llg_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria soꞌuk halan, nae, “Neme au dale kadiꞌi anang dalek mai, au soꞌuk amadedema Lamatuak! ");
INSERT INTO llg_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Au daleng namahoko, huu Manetualain fee au sodak! ");
INSERT INTO llg_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ana tao matak neulalau neu au, Ndia hataholi nadedenun fo sosoan ta ia. Mulai neme hatematak ia mai, basa hataholi la taok au ia, inak fo maua-manalek nalan seli, ");
INSERT INTO llg_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","huu Lamatuak tao dedeꞌa heran neu au. Ndia ndia, Mana Koasa ma Malalaok Nalan Seli. ");
INSERT INTO llg_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Manetualain natudu taa-taa namemeda kasian neu basa hataholi la, fo mana fee hadak ma lakaluku-lakatele neu Ndia, neme numbusaduk esa mai, neni numbusaduk feꞌek neu. ");
INSERT INTO llg_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ana pake Ndia koasan, fo tao naodek neu hataholi mana koao kala. ");
INSERT INTO llg_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ana tao natuda hataholi mana koasa la, huu koao nala. Tehuu Ana soꞌu laik hataholi madale taidae kala. ");
INSERT INTO llg_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ana fee hataholi mana ndoe kala, laꞌa losa lakabete, tehuu Ana husi heni hataholi kamasuꞌi kala, fo ala laꞌo lo sila lima lou nala. ");
INSERT INTO llg_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ana tulu-fali Ndia hataholi Israel asa, ma Ana natudu taa-taa Ndia dale kasian neu sala. ");
INSERT INTO llg_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Makahulun, Ana mbaꞌa heheluk no ita bei-baꞌi nala, fo ndia, baꞌi Abraham, ma basa numbu sadu nala. Hatematak ia, heheluk ndia nanambaꞌak nakandondoo henin.” ");
INSERT INTO llg_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Boe ma Maria leo no Elisabet losa bulak telu. Basa de ana fali neni uman neu nai Nasaret. ");
INSERT INTO llg_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ndia fain losa leo ndia, boe ma Elisabet bonggi ana touanak esa. ");
INSERT INTO llg_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Halak ndia natanggela neni ndia bobonggi nala neu, ma nggolo isi kala, lae, Manetualain natudu Ndia dale malolen, de ana fee Elisabet anak esa. Boe ma basa sala lamahoko. ");
INSERT INTO llg_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ledoeik kakanak ndia faik falu, boe ma ala sunat ana, tungga hataholi Yahudi la heti-heun. Ala nau foi kakanak ndia nade Zakarias, tungga ndia aman naden. ");
INSERT INTO llg_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Tehuu inan ta nau, de nae, “Ta bisa leo ndiak! Ndia naden, musi Yohanis!” ");
INSERT INTO llg_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Tehuu ala bala lae, “Hatina de o hele mala nade Yohanis ndia? Ta hambu hataholi esa boe nai ei bobonggi mala, pake nadek ndia!” ");
INSERT INTO llg_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Boe ma ala lakababalek lima nala neu Zakarias, fo sangga bubuluk ana sangga foi kakanak ndia nade see. ");
INSERT INTO llg_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zakarias nakababalek liman fo noke lei. Ala feen lei, de ana sulak, nae, “Ndia naden Yohanis!” Boe ma basa hataholi la, heran lalan seli. ");
INSERT INTO llg_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Kada nggengge neuk, huu Zakarias maan mana makaditak ndia, bangganaꞌu so. Boe ma ana koa-kio Manetualain. ");
INSERT INTO llg_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Basa hataholi mana leo dekak lai ndia, ala bii lalan seli. Boe ma tutuik ndia nakambela neme bafak mai neni bafak neu, losa hataholi la, malai lete kala malai propinsi Yudea, basa sala bubuluk. ");
INSERT INTO llg_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Hataholi mana mamanene tutuik ndia, duduꞌa, lae, “Manggaledok so, Lamatuak koasan no kakanak ndia. Dei fo ana inahuu mai, na ana dadik hataholi namata-ao leo hata, bae?” ");
INSERT INTO llg_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Basa boe ma, Lamatuak Dula Dale Malalaon maso neni Zakarias dalen neu. Huu ndia de, ana kokolak, nae, ");
INSERT INTO llg_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Koa-kiok neu Lamatuak, fo hataholi Israel asa Manetualain! Huu Ana mai tifa nala Ndia hataholi nala, fo suek ala boso sama leo ata. ");
INSERT INTO llg_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Lamatuak soꞌu nala Hataholi esa fo Ndia koasan ana seli so, fo dei fo Ana fee sodak neu ita. Ndia ndia, neme mane Dauk tititi-nonosin mai. ");
INSERT INTO llg_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Lamatuak helu memak basa ia la so, neme lele uluk mai, pake Ndia mana kokola nala, fo dale nala katemak lo Ndia. ");
INSERT INTO llg_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Hatematak ia, Ana sangga mboꞌi heni ita teme ita musu nala mai, ma teme hataholi la, fo mana dale hedi neu ita. ");
INSERT INTO llg_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","Ana natudu Ndia dale malolen neu ita bei-baꞌi nala, huu Ana nasaneda taa-taa Ndia hehelu nala fo Ana mbaꞌan no baꞌi Abraham. ");
INSERT INTO llg_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ana mboꞌi heni ita so, teme ita musu nala mai, fo ita bisa takaluku-takatele neu Ndia, ma ta paluu ita bii so bali. ");
INSERT INTO llg_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ana mboꞌi heni ita so, suek ita bisa tasoda malalaok, ma ndoos nai Ndia matan. ");
INSERT INTO llg_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Anis! O ia, Au anang. Dei fo hataholi la lalelak o, lae, o ia, Manetualain fo Manai Lain Seli mana kokolan. Dei fo o muu mafada hataholi la, fo lalengga dale nala, suek ala simbok Lamatuak mamain. ");
INSERT INTO llg_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Dei fo o muu matudu dalak neu Lamatuak hataholi nala, suek ala bubuluk sila hambu sodak, huu Lamatuak koka heni sila sala nala so. ");
INSERT INTO llg_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Huu Lamatuak dalen tuda ma kasian neu ita, huu ndia de, Ana fee ita fai lela beuk, sama leo fai beuk fo neni manggaledo beuk. Ita mana laꞌok nai makiuk, ma ita mana bii mate, huu ita bei ta mole to Lamatuak, dei fo hambu manggaledok fo noo ita teni dala mole-dame teu.” ");
INSERT INTO llg_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Basa boe ma Yohanis tamba faik, boe inahuu. Ma Lamatuak Dulan tao nalan balakai. Ana inahuu mai, boe ma neu leo nai mamana nes, losa ana mulai tao ndia ue-ledin fee hataholi Israel asa. ");
INSERT INTO llg_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","2","Laꞌi esa, faik fo Kirenius dadik malangga nusa Siria, boe ma mane inahuuk nade Agustus, fee palenda, nae, “Basa hataholi la malai mana toꞌu palenda Roma koasan, musi ala fali leni nggolo nala leu, suek ala tungga sulak nadek!” Ndia sososan fo mana toꞌu palenda Roma hingga ndia lau-inggu nala leo ndiak. ");
INSERT INTO llg_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","De, basa hataholi la fali leni nggolo nala leu, suek ala tungga sulak nadek. ");
INSERT INTO llg_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Faik ndia, Yusuf leo nai nggolo Nasaret, fo nai propinsi Galelea. Ana nafufudik no inanak esa nade Maria, fo kaꞌilus so. Yusuf ndia, na mane Dauk numbu-sadun ndia, de ana musi fali neni Dauk kotan Betlehem neu, nai propinsi Yudea fo ana tungga sulak nadek. Huu ndia de, dua sala laꞌo leni kota Betlehem leu. ");
INSERT INTO llg_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ledoeik ala bei lai ele, boe ma Maria fai bobonggin losa so. ");
INSERT INTO llg_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Tehuu nai ndia, ta hambu kama uma sesebak. Huu ndia de, ala leni lalae biꞌi dale leu. Basa boe ma, ana bonggi Ana sososan, touanak. Boe ma ala lalusen temak, ma ala lakambembeꞌun neu banda la haꞌo nanaꞌan dale neu. ");
INSERT INTO llg_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Leꞌodaen ndia, manahoo hida beꞌe lanea sila biꞌiae-biꞌilombo nala lai mook kota deak. ");
INSERT INTO llg_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kada nggengge neuk, ala lita Manetualain atan neme nusa-sodak mai. Boe ma, Lamatuak manggaledon nasaꞌa ndule sala, de ala bii lalan seli. ");
INSERT INTO llg_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Tehuu ata ndia nafada, nae, “Ei boso bii dei! Mamanene neulalau, baa! Huu au ia, mai afada ei hala malole esa. Basa mana mamanene hala malole ia, neu ko lamahoko. ");
INSERT INTO llg_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Hala malole ia liin leo iak: Faik ia, inak esa bonggi Karistus so, nai Betlehem, fo mane Dauk kotan. Karistus ndia, na hataholi fo, Manetualain helu mema kana, neme makahulun mai so. Lamatuak haituan mai, fo Ana fee sodak neu hataholi la, leme sala nala mai! Ndia ia, fo dei fo hataholi la loken na lae, ‘Lamatuak!’ ");
INSERT INTO llg_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Dei fo ei bisa malelak Ndia leo iak: ei matonggo mia Kakanak mbimbilanak esa, lalusen nenik temak. Ana sunggu nai banda la, haꞌo nanaꞌan dalek.” ");
INSERT INTO llg_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ana kokolak nateꞌe boe ma, nggengge neuk Manetualain ata nala makadotok leme nusa-sodak mai, de lakabubua lo ndia. Boe ma ala koa-kio Manetualain, de soda lae, ");
INSERT INTO llg_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ai soꞌuk mamadedema Manetualain naden! Ndia fo, mana manggatuuk palenda nai lalai aten. Manetualain nau fee dame, neu hataholi la malai daebafok, fo manatao namahoko Ndia dalen!” ");
INSERT INTO llg_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Basa boe ma, Lamatuak ata nala fali leni nusa-sodak leu. Boe ma manahoo la sila lakokola, lae, “Wei! Mai fo teni Betlehem teu, fo teu tita kakanak ndia dei! Huu Lamatuak haitua fee ita halak ndia.” ");
INSERT INTO llg_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Boe ma ala laꞌok lai-lai leni Betlehem leu. De ala latonggo lo Maria ma Yusuf. Ala lita Kakanak mbimbilanak ndia boe, sunggu nai banda la haꞌo nanaꞌan dalek. ");
INSERT INTO llg_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ledoeik ala lita kakanak ndia, boe ma ala tui, lae, “Isinaak Lamatuak ata nala leme nusa-sodak mai, de lafada ai so, laꞌeneu Kakanak ia!” Boe ma ala tui basan losa mateꞌen. ");
INSERT INTO llg_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Basa hataholi la, heran lalan seli, lamanene manahoo la tutui nala sila. ");
INSERT INTO llg_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Tehuu Maria mbeda basa dedeꞌa manadadi kala sila so, neu dalen. De ana duduꞌa neneek fo ana sangga bubuluk dedeꞌak ia ndandaan nae leobee. ");
INSERT INTO llg_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Basa boe ma, manahoo la fali leni sila biꞌiae-biꞌilombo nala leu. De, ala soꞌu lamadedema Manetualain naden. Ala loke makasi neu Ndia, huu lamanene ma litan, nandaa leo hata fo Lamatuak ata nala kokola nala sila. ");
INSERT INTO llg_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Bonggi heni Kakanak ndia faik falu, boe ma ala sunat kakana mbimbilanak ndia, tungga baꞌi Musa heti-heun. Boe ma, ina-aman foin nade, “Yesus”. Nadek ndia, fo ata nusa-sodak nafada sila so, neu faik fo Ndia inan bei ta naꞌilu Ndia. ");
INSERT INTO llg_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Hambu baꞌi Musa heti-heun esa nae, inak fo bonggi basa faik hahulu, na ana musi neu tao tungga hadak, fo tao nalalao aon nai Uma Ina Huhule-haladoik. No leo ndiak, na, ala bisa maso leni uma huhule-haladoik leu, leo basa faik. Huu ndia de, Yusuf ma Maria leni kota Yerusalem leu, fo ala sangga tao tungga hadak ndia. Boe ma ala loo sila ana mbimbilanan ndia, neni Uma Ina Huhule-haladoik dalek neu, fo ala fee Ndia dadik neu Lamatuak enan. ");
INSERT INTO llg_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ala tungga Lamatuak heti-heun fo nae, “Inak fo ana bonggi ana ulun, mete ma touk, na, ana musi fee kakanak ndia dadik Lamatuak enan.” ");
INSERT INTO llg_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Tungga Lamatuak heti-heun, na, mete ma fee kakanak ndia neu Lamatuak, na, ina-aman musi fee tunu-hotuk mbui kateu pasan esa, do lunda mulik dua. Huu ndia de, Yusuf no Maria tao tungga heti-heuk ndia boe. ");
INSERT INTO llg_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","26","Faik ndia, tou lasik esa, nade Simeon, fo ana leo nai kota Yerusalem. Ndia ndia, hataholi dale ndoos, ma ana dokodoe neu Lamatuak. Lamatuak Dula Dale Malalaon nafada ndia so, nae, dei fo ana bisa nita Karistus dei, bei fo ana mate. Karistus ndia, fo dei fo ana fee sodak neu hataholi Israel asa. ");
INSERT INTO llg_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Faik ndia, Lamatuak Dula Dale Malalaon noo Simeon neni Uma Ina Huhule-haladoik neu boe. Ndia ndandaak no Yesus ina-ama nala loo Ndia neni ndia neu, fo ala fee Ndia dadik neu Lamatuak enan. ");
INSERT INTO llg_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Nita kakanak ndia, boe ma toulasi Simeon koꞌo nalan, de ana soꞌuk koa-kiok neu Manetualain, nae, ");
INSERT INTO llg_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Koa-kiok neu Lamatuak! Lamatuak tao natetu Ndia hehelun neu au so. De, hatematak ia, Lamatuak bisa nakamboꞌik au so, fo ela au bisa mate no ndoo-ndoo, ");
INSERT INTO llg_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","huu au ita Hataholi fo Lamatuak haituan mai so, fo Ana tao nasoda ai mima ai sala nala mai! ");
INSERT INTO llg_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Lamatuak nau pake kakanak ia, fo tao nasoda basa hataholi nusa kala. ");
INSERT INTO llg_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Dei fo Ndia sama leo masaꞌak, fo neni hada-holomata neu Lamatuak hataholi nusa Israel asa. Ndia boe oo, sama leo manggaledok, fo natudu Lamatuak dalan neu basa hataholi nusa feꞌe kala.” ");
INSERT INTO llg_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Lamanene leo ndia, boe ma Yusuf no Maria heran lalan seli, no hata fo tou lasi Simeon kokolan laꞌeneu sila anan. ");
INSERT INTO llg_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Basa ndia, boe ma Simeon kokolak babaꞌe-babatik fee sala. Boe ma ana nafada Maria, nae, “Yesus inan aa! Dei fo hataholi luma lai Israel, timba heni ina Anan ia. Tehuu sila tataon neu Ndia ndia, dei fo natuda nasafali sala. Ina Anan ia boe oo tao namahoko hataholi luma dale nala. ");
INSERT INTO llg_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","No leo ndiak, na, dei fo Lamatuak tao nakaholak hataholi la dale nala. Tehuu o Maria, dei fo o hambu doidosok belak, sama leo tafa nana mbauk neu o mboꞌom.” ");
INSERT INTO llg_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Nai Uma Ina Huhule-haladoik, hambu ina lasik esa nade Hana. Ndia teun teuk falu hulu haa ia so. Ndia aman, nade Fanuel, neme leo Aser mai. Ana sao teuk hitu, boe ma saon mate laꞌo elan. Bei Hana ndia, na, Manetualain mana kokolan. Ndia uen, ndia hule-haladoi, ma puasa nai Uma Ina Huhule-haladoik, fo nakaluku-nakatele neu Manetualain nai leledo-leꞌodaen. ");
INSERT INTO llg_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ledoeik Simeon bei nakokola no Yusuf ma Maria, tehuu ina lasik ndia neu deka-deka so. Boe ma, ana namanene neu sala, de ana soꞌuk koa-kiok neu Manetualain. Basa de, ana kokolak laꞌeneu Yesus neu basa hataholi la, fo lahahanik Manek fo Manetualain heluk ndia so, fo haituan mai, suek nakamboꞌik hataholi nusa Israel. ");
INSERT INTO llg_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ledoeik Yusuf no Maria tao tungga basa baꞌi Musa heti-heun, nai kota Yerusalem, boe ma, ala fali leni propinsi Galelea fo sila nggolon, Nasaret leu. ");
INSERT INTO llg_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Yesus inahuu mai, de Ana boe balakai, nalelak, ma bubuluk dedeꞌak noꞌu kala. Manetualain boe oo, natudu dale malolen neu Ndia. ");
INSERT INTO llg_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Tungga-tungga teuk, na, Yusuf ma Maria laꞌo leni kota Yerusalem leu, fo laꞌa feta Paska nai ndia. ");
INSERT INTO llg_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Laꞌi esa, faik fo Yesus teun sanahulu dua, boe ma ala laꞌo noꞌu leni Yerusalem leu, fo ala tungga laꞌa feta sama leo natetemek. ");
INSERT INTO llg_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","44","Ledoeik fai-fai Paska basan so, boe ma Yusuf no Maria mulai laꞌo fali leni Nasaret leu, lo hataholi noꞌu kala mana sangga fali leni Galelea leu boe. Tehuu tala bubuluk, tehuu Yesus nana laꞌo elak nai Yerusalem. Laehetuk Ana laꞌo noꞌu no Ndia nonoo nala. Losa bobok, tehuu ta lita sana. Boe ma, ala laꞌo lafeok, leu sanggan nai sila bobonggi nala ma nonoo nala. ");
INSERT INTO llg_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Huu ta latonggo lo Ndia, de ala fali leni Yerusalem leu seluk, fo ala nau sanggan nai ele. ");
INSERT INTO llg_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Losa ele, boe ma ala sanggan losa faik telu, bei fo latonggo lo Ndia nai Uma Ina Huhule-haladoik dalek. Ana nanggatuuk natane-nataak no mese anggama Yahudi la. ");
INSERT INTO llg_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Basa hataholi la mana mamanene kala sila, ala heran lalan seli, huu Ana bubuluk tebe-tebe Manetualain Susulan isin, de Ana bisa nataa sila natatane nala no malole. ");
INSERT INTO llg_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Lita leo ndia, boe ma, ina-ama nala heran. Basa de Ndia inan nae, “Yesus! Hatina de o tao makatotoꞌak ai leo iak? O amam ma au masapangga malan seli, de, ai sangga O miu-mai!” ");
INSERT INTO llg_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Tehuu Yesus nataa nae, “Hatina de ama no ina masambute sangga Au? Kada malelak malan leo hetu? Au kauek nai Au Amang Uman.” ");
INSERT INTO llg_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Tehuu ta lalelak Ndia maksud. ");
INSERT INTO llg_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Basa boe ma basa sala fali leni Nasaret leu. Yesus tungga inan no aman palenda nala. Boe ma Yesus inan mbeda basa dedeꞌa kala sila neu dalen dale. ");
INSERT INTO llg_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Leo ndiak leo, de Yesus boe inahuu, ma Ana boe nandolu. Manetualain no hataholi la sue Ndia. ");
INSERT INTO llg_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Faik ndia, Tiberius dadik kesel de ana toꞌu palenda nai Roma, teuk sanahulu lima ia so. Pontius Pilatus dadik gubenol nai propinsi Yudea. Herodes dadik gubenol nai propinsi Galelea. Herodes kaꞌan Filipus, dadik gubenol nai nusa Iturea ma nusa Trakonitis. Ma Lisanias dadik gubenol nai nusa Abilene. Faik ndia boe oo, Hanas ma Kayafas dadik malangga anggama Yahudi la malangga inahuun nai kota Yerusalem. Faik ndia, Yohanis, fo Zakarias anan ndia, leo nai mamana nes, fo doon seli neme nggolok mai. Lamatuak feen heheluk neme ndia. ");
INSERT INTO llg_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Namanene basa boe ma, Yohanis neni basa nggolo kala, fo mana dekak no lee Yarden, de, nafada hataholi la, nae, “Ei musi manaku ma laꞌo ela basa ei sala mala, fo suek Manetualain koka heni sala kala sila. Basa na, ei musi salani dei, fo dadik neu tanda, nae, ei malole mia Lamatuak so.” ");
INSERT INTO llg_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Makahulun ele, Lamatuak mana kokolan baꞌi Yesaya sulak laꞌeneu Yohanis ia, nae, “Hambu hataholi esa nai mamana nes nanggou, nae, ‘Basa hataholi la, mahehele tao neulalau dala kala, fo simbok Lamatuak mamain! Tao mandoo dala kala fo soluk Ndia. ");
INSERT INTO llg_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Fua matetu lea kala lalaꞌen. Kali tao matetu lete kala lalaꞌen. Tao mandoo dala peko kala, tao neulalau dala kala fo bei nakatunu kala. ");
INSERT INTO llg_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Suek hataholi la leme basa hataholi nusa kala, bisa bubuluk, lae, Lamatuak nau fee sodak neu hataholi la, leme sila sala-singgo nala mai.’ ” ");
INSERT INTO llg_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Hataholi noꞌu kala, sudi leme bee mai, fo loke Yohanis salani sala. Tehuu nasapala kasa nae, “Wei! Ei masapepeko kala! Ei sama leo mengge kalasok! Boso mae hetuk ei bisa makamboꞌik mima Lamatuak huhukun mai, de kada taok ei hondak! Ta! Ta dook so bali, huu Lamatuak huku basa hataholi la, fo ta manahondak no tetebes. ");
INSERT INTO llg_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ei boso duduꞌa mae, ‘Au ia ta hambu huhukuk, huu au ia baꞌi Abraham numbu-sadun.’ Hambu nai bee leo ndiak? Ndia ta bisa fali nala ei, huu ta bisa tao ei dadik malalaok. Lamatuak nabeꞌi tao batu la ia dadik neu Abraham numbu-sadun. Au afada ei, baa! Matudu tungga ei sodam, mae, ei heok masadea laꞌo ela ei sala mala, ma ei pode masafali tungga Lamatuak so. ");
INSERT INTO llg_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ei musi tao dedeꞌa malole. Mete ma ta, na, Lamatuak huhuku mabelan tuda neu ei, fo sama leo hataholi pake taka fo loꞌo heni ai no okan. Leo ndiak leo! Ai sosoan ta, mete ma ndia buna-boan ta malole! De malolenak loꞌo henin, fo mbian neni haꞌi dale neu.’ ");
INSERT INTO llg_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Basa de, hataholi noꞌu kala latane Yohanis, lae, “De, ai musi tao hata?” ");
INSERT INTO llg_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Boe ma ana nataa, nae, “Mete ma o badum dua, na, fee esa neu hataholi badu tak. Mete ma o kananaꞌak, na, baꞌe fee hataholi nanaꞌa tak.” ");
INSERT INTO llg_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Basa de, manasusu bea la mai boe, de loke Yohanis fo salani sala. Ala latane, lae, “Ama mesen! Ai musi tao leobee?” ");
INSERT INTO llg_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ana nataa nae, “Ei mahiik kada masapepeko. Tehuu hatematak ia, ei musi maue-maledi no ndoos. Boso susu bea lena-lenak neme mana toꞌu palenda heti-heun mai. Ela lau-inggu la bae bea nandaa no heti-heuk.” ");
INSERT INTO llg_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Hambu soldadu luma lai ndia boe. Ala latane Yohanis, lae, “Mete ma ai, na, talobee? Ai musi tao hata?” Boe ma ana nataa, nae, “Boso mambue moke hataholi la doi nala, tungga ei hihii mala. Ma boso mambue fee salak neu hataholi, ta no bolo dalan. Ei musi moke makasi, ma simbo ei nggadi mala no teteben ma dale loak.” ");
INSERT INTO llg_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Lamanene ndia kokolan ndia, boe ma, basa hataholi la mulai lakisuk de lakukutuk, lae, “Awii! Naafo Yohanis ia, ndia Karistus, fo Lamatuak helu mema kana ndia so neme makahulun mai, fo sangga haituan mai ndia!” ");
INSERT INTO llg_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Tehuu Yohanis nafada sala nae, “Mamanene neulalau! Dei fo hambu Hataholi esa ana seli, lena heni au, sangga mai. Mae kada dadik neu Ndia hataholi nadedenun boe oo, au ta andaa. Au kada bisa salani ei unik oe, tehuu dei fo Ana tao lena heni au bali, huu Ana tao nahenu ei dale mala nenik Lamatuak Dula Dale Malalaon. Dei fo Ana tao nalalao ei, sama leo hataholi pake haꞌi fo hotu heni kadafuk. ");
INSERT INTO llg_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ana huku hataholi, fo mana tao sala kala, sama leo hataholi mana tao ue daek pake ani, fo daꞌi kofeꞌek kadafu kala, leme hade mai. Boe ma ana mbeda hade malalaok neni karon dale neu, tehuu ana hotu heni kadafun. Leo ndiak boe, dei fo Karistus huku hataholi mana tao sala kala, fo Ana mbia heni sala, leni haꞌi ta mana matek dalek neu. ");
INSERT INTO llg_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","No leo ndiak, Yohanis tao nasanenedak dedeꞌa mata-matak, ma nafada sala Lamatuak Hala Malolen. ");
INSERT INTO llg_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","20","Faik ndia, Yohanis mulai kokolak manggaledok laꞌeneu Herodes tataon. Dedeꞌak ndia leo iak: Herodes ndia na gubenol, nai propinsi Galelea. Ndia sala nala makadotok nalan seli. Conto leo ana namoa nala fadin sao inan, nade Herodias. Naa te, fadin bei kasodak, ma bei ta naelak no Herodias. Herodes dala sodan ta malole ndia, de ana tao nala Yohanis nafadan ledo-ledo, losa Herodes lesuhaꞌin nakaseꞌe nalan seli neu ndia. Boe ma Herodes humu nalan, de nandeen neni bui dale neu. ");
INSERT INTO llg_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Makahulun, fo faik ala bei ta humu lala Yohanis, na, ana salani hataholi noꞌuk. Ma ndia boe oo, salani Yesus. Basa boe ma Yesus hule-haladoi, de lalai natahuꞌak. ");
INSERT INTO llg_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Boe ma Lamatuak Dula Dale Malalaon konda neu Ndia. Dula Dale Malalaon ndia namata-ao leo mbui lunda esa. Boe ma hambu halak neme lalai mai, nae, “O ia, Au Ana susueng. O tao mala Au amahoko taa-taa.” ");
INSERT INTO llg_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Faik fo Yesus mulai nafada hataholi la laꞌeneu Lamatuak dala sodan, meda Ndia teun teuk telu hulu. Hataholi la lalelak, lae, Yesus ndia, na Yusuf Anan. Yusuf bei-baꞌi nala, leo iak: Yusuf aman, Eli. ");
INSERT INTO llg_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli aman, Matat. Matat aman, Lewi. Lewi aman, Melki. Melki aman, Yanai. Yanai aman, Yusuf. ");
INSERT INTO llg_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yusuf aman, Matatias. Matatias aman, Amos. Amos aman, Nahum. Nahum aman, Hesli. Hesli aman, Nagai. ");
INSERT INTO llg_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai aman, Maat. Maat aman, Matatias. Matatias aman, Semein Semein aman, Yosek. Yosek aman, Yoda. ");
INSERT INTO llg_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda aman, Yohanan. Yohanan aman, Resa. Resa aman, Serubabel. Serubabel aman, Sealtiel. Sealtiel aman, Neri. ");
INSERT INTO llg_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri aman, Melki. Melki aman, Adi. Adi aman, Kosam. Kosam aman, Elmadam. Elmadam aman, Er. ");
INSERT INTO llg_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er aman, Yosua. Yosua aman, Elieser. Elieser aman, Yorim. Yorim aman, Matat. Matat aman, Lewi. ");
INSERT INTO llg_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lewi aman, Simeon. Simeon aman, Yahuda. Yahuda aman, Yusuf. Yusuf aman, Yonam. Yonam aman, Elyakim. ");
INSERT INTO llg_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elyakim aman, Melea. Melea aman, Mena. Mena aman, Matata. Matata aman, Natan. Natan aman, Dauk ");
INSERT INTO llg_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dauk aman, Isai. Isai aman, Obet. Obet aman, Boas. Boas aman, Salmon. Salmon aman, Nahason. ");
INSERT INTO llg_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahason aman, Aminadab. Aminadab aman, Admin. Admin aman, Arni. Arni aman, Hesron. Hesron aman, Peres. Peres aman, Yahuda. ");
INSERT INTO llg_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yahuda aman, Yakob. Yakob aman, Isak. Isak aman, Abraham. Abraham aman, Tera. Tera aman, Nahor. ");
INSERT INTO llg_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor aman, Seruk. Seruk aman, Rehu. Rehu aman, Pelek. Pelek aman, Eber. Eber aman, Sela. ");
INSERT INTO llg_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela aman, Kenan. Kenan aman, Arpaksad. Arpaksad aman, Sem. Sem aman, Noh. Noh aman, Lamek. ");
INSERT INTO llg_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek aman, Metusalak. Metusalak aman, Henok. Henok aman, Yared. Yared aman, Mahalalel. Mahalalel aman, Kenan. ");
INSERT INTO llg_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan aman, Enos. Enos aman, Set. Set aman, Adam Adam ndia, fo Manetualain nakadadadi kana. ");
INSERT INTO llg_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ledoeik Yohanis salani basa Yesus, boe ma Yesus laꞌo ela lee Yarden. Lamatuak Dula Dale Malalaon no Ndia. Boe ma Dula Dale Malalaok noo ndia neni mamana nes neu. ");
INSERT INTO llg_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Yesus leo neme ndia losa faik haa hulu. Faik ndia Ana ta naꞌa-ninu hata esa boe, losa faik haa hulu. Ana ndoe nalan seli. Boe ma nitu la malanggan mai teꞌek sudi Ndia. ");
INSERT INTO llg_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ana nafada Yesus, nae, “Mete ma tetebes O ia Manetualain Anan, na O maena koasa. De, madenu batu la ia dadik loti, fo O muꞌa sala.” ");
INSERT INTO llg_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Tehuu Yesus nataa nae, “O hihiim dei! O ta bubuluk do? Nana sulak nai Manetualain Susula Malalaon, nae, ‘Hataholi ta kada nasoda neme nanaꞌak mai, hetu!” ");
INSERT INTO llg_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","6","Basa ndia, boe ma nitu la malanggan noon neni mamana madema esa neu, de natudu Ndia basa mana toꞌu palenda malai daebafok, fo basa sala ana seli. Basa de ana kokoe Yesus nae, “Basa mana toꞌu palenda lo koasa nala, ma ana selin ndia, au enang basa sila! De, au aena hak fo sangga fee sudi see, tungga au hihiing. ");
INSERT INTO llg_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Au sangga fee basa sala leu O. Kada O musi tao dedeꞌak esa dei, bei fo au fee. Kada lofoanak! Kada O makaluku-makatele neu au. Kada ndia!” ");
INSERT INTO llg_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Tehuu Yesus nataa nasafali nae, “Hambu nai bee leo ndiak? Huu nana sulak nai Manetualain Susula Malalaon dalek, nae, ‘O musi kada makaluku-makatele neu Manetualain. Ma kada o musi ono-lau neu Ndia.’ ” ");
INSERT INTO llg_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Basa ndia, boe ma nitu la malanggan noo Yesus neni kota Yerusalem neu. Nai ndia, ana noo Yesus hene leni Uma Ina Huhule-Haladoik mamana mademan neu. Boe ma ana nae, “Mete ma O ia memak Manetualain Anan, na, O palaboku dae muu leo! ");
INSERT INTO llg_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Huu nana sulak nai Manetualain Susula Malalaon, nae, ‘Dei fo Manetualain fee Ndia ata nala leme nusa-sodak mai, fo ala lanea O. ");
INSERT INTO llg_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Dei fo ala latanee O, fo suek O eim ta deta laꞌe batu faa boe.’ ” ");
INSERT INTO llg_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Tehuu Yesus nataa nae, “Boso babalik Au. Huu nana sulak nai Manetualain Susula Malalaon nae, ‘Boso soba-dou Manetualain!’ ");
INSERT INTO llg_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Nitu la malanggan soba-dou Yesus no dalak mata-matak, tehuu ta nala sana. Boe ma ana laꞌo ela Yesus, de nahani fai mandaak. ");
INSERT INTO llg_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Basa ndia, boe ma Yesus fali neni propinsi Galelea neu bali, huu Lamatuak Dula Dale Malalaon feen koasa. Ta dook, boe ma hataholi la malai nusak ndia mulai lalelak Ndia naden. ");
INSERT INTO llg_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ana nanoli nai hataholi Yahudi la uma huhule-haladoin, sudi nai bee. De, hataholi la koa Ndia, lae, “Yesus ndia, Hataholi ana seli, maa!” ");
INSERT INTO llg_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Laꞌi esa, Yesus neni Ndia nggolon Nasaret neu. Nandaa no hataholi Yahudi la fai huhule-haladoin, fo ndia ‘fai Sabat’, de, Ana maso neni uma huhule-haladoik dalek neu, sama leo Ndia natetemen. Boe ma Ana foꞌa nambadeik, fo sangga les nai Manetualain Susula Malalaon. ");
INSERT INTO llg_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","De, ala lo fee Ndia baꞌi Yesaya susulan. Ana bukan, de Ana les, nae, ");
INSERT INTO llg_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Manetualain Dula Dale Malalaon koasan nai au dalek. Huu ndia de Ana tudu au, fo au afada Lamatuak Hala Malolen neu hataholi kadiꞌi-taidae kala. Ana nadenu au, fo afada, ae, malai bui la, dei fo lakamboꞌik; mboke kala, dei fo lita lasafali; nana tuni-ndeni kala, dei fo lasoda lo lakamboꞌik. ");
INSERT INTO llg_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Huu hatematak ia, Lamatuak fain losa so, fo Ana tao nasoda Ndia hataholi nala.” ");
INSERT INTO llg_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Les basa susulak ndia, boe ma Yesus lulu fali kana, de Ana lon neu malangga makaluku-makatelek, de, Ana nanggatuuk. Basa hataholi la malai uma huhule-haladoik ndia dalek, mete lahele Ndia. ");
INSERT INTO llg_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Basa de, Ana nafada hataholi la, nae, “Hata fo ei mamanenen neme Manetualain Susulan isinaak ndia, hatematak ia ana dadi so!” ");
INSERT INTO llg_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Boe ma basa hataholi la malai ndia kala, mulai sosoꞌuk Yesus, lae, “Awii! Hata fo isinaak Ana kokolak ndia, malolen ana seli, maa! Tehuu Ndia ia, na Usu anan ia, hetu? Talobee de bisa ana dadi leo iak?” ");
INSERT INTO llg_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Basa de Yesus nafada sala, nae, “Neu ko ei basa nggei bubuluk hambu dedeꞌa-kokolak, nae, ‘Wei! Tao neulalau o aoina hehelim dei!’ Ei sangga pake dedeꞌa-kokolak ndia fo tutu masafali Au, mae, ‘Hatina de O ta tao tanda heran esa fee ai nai ia, sama leo O taok so nai kota Kapernaum ele?’ ");
INSERT INTO llg_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ndia teteben na leo iak: hataholi la taa nau simbok Lamatuak mana kokolan nai ndia nggolo hehelin. ");
INSERT INTO llg_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","Haꞌi conto neme Lamatuak mana kokolan, Baꞌi Elia. Laꞌi esa uda ta konda dae teuk telu seselik. Faik ndia, hambu ina falu noꞌuk lai Israel. Tehuu Lamatuak taa haitua Elia fo neu fali nala sala lai Israel. Kada Lamatuak haituan neni ina falu esa nai nggolo Sarfat fo dekak no kota Sidon. Naa te ina lasik ndia, hataholi ta Yahudi. Tehuu ana namahele Manetualain koasan. ");
INSERT INTO llg_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Haꞌi conto feꞌek bali, neme Lamatuak mana kokolan Elisa mai. Faik ndia, hataholi Yahudi la hambu hedi kusta lai Israel. Tehuu Lamatuak ta tao nahai sala. Kada Lamatuak nadenu Elisa tao nahai hataholi hedi kusta esa, nade Naaman. Naa te, ndia ndia, hataholi Siria, fo ta hataholi Yahudi. Tehuu namahele Manetualain koasan.” ");
INSERT INTO llg_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ledoeik ala lamanene Yesus nakandandaan leo ndia, boe ma basa sala manggalau lo Ndia. ");
INSERT INTO llg_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Basa sala foꞌa noꞌu de ala husi heni Ndia neme uma huhule-haladoik ndia mai. De ala hela loo Ndia leni nggolok bifin neu, fo ala sangga timban neni leak madema manai ndiak. ");
INSERT INTO llg_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Tehuu kada Ana laꞌok dea neu, nesik hataholi noꞌu kala laladan, de Ana laꞌo ela sala lai ndia. ");
INSERT INTO llg_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Basa ndia, de Yesus konda neni kota Kapernaum neu, fo nai dano Galelea bifin. Tungga-tungga fai huhule-haladoik, na Ana nanoli hataholi la lai uma huhule-haladoik dalek. ");
INSERT INTO llg_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ledoeik hataholi la lamanene Ndia kokolan, de ala heran lalan seli, huu Ana nalelak tebe-tebe nanonolik ndia isin. ");
INSERT INTO llg_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Laꞌi esa, faik fo Yesus nanoli nai uma huhule-haladoik ndia, boe ma hataholi nitu nalak esa nakaꞌau tingga-tingga, nae, ");
INSERT INTO llg_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Wei! Yesus, Hataholi Nasaret aa! O dedeꞌa hatam no ai! O mai sangga mai tao makalulutu ai, do? Ai malelak O. O ia, Hataholi Malalaok, fo ndia makahulun Manetualain helu fo haituan mai.” ");
INSERT INTO llg_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Tehuu Yesus nasapala kana, nae, “Seu o bafam! Kalua muma hataholi ndia mai!” Kada nggengge neuk, nitu ndia bala hataholi ndia neu dae, nai hataholi la sila laladan. Ana bala nateꞌe, boe ma nitu ndia kalua laꞌo ela hataholi ndia, de ta tao nahedi ndia so. ");
INSERT INTO llg_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Basa hataholi la nado nggoa-nggoa, de lae, “Heran oo! Hataholi ia kokolan naena koasa ana seli! Losak nitu la boe oo, tungga Ndia totoꞌu palendan.” ");
INSERT INTO llg_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Basa de, tutuik laꞌeneu Yesus mulai nakambela nai basa nusak ndia. ");
INSERT INTO llg_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ledoeik ala kalua leme uma huhule-haladoik ndia mai, boe ma Yesus neni hataholi esa uman neu. Hataholi ndia nade, Simon. Simon ali inan sumai, de aon natobi nalan seli. Basa de loke Yesus, lae, “Ama aa! Tulun tao mahai ina lasik dei!” ");
INSERT INTO llg_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yesus nambadeik neu koi bifin, de Ana husi heni sumaik ndia neme ina lasik ndia mai. Ledoeik ndia boe oo, ndia sumain mopo heni tutik. Basa de ana foꞌa tutik, de neu tao nanaꞌak fee sala. ");
INSERT INTO llg_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ledobobon ndia, fo ledoeik ledo tesa so, hataholi la loo basa hataholi kamahedi kala leni Yesus leu. Sila hedi nala mata-mata kala. Boe ma Ana daba liman neu hataholi kamahedi kala sila, de Ana tao nahai basa sala. ");
INSERT INTO llg_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Nai hataholi kamahedi kala sila boe, hambu luma nitu nala kala. De Yesus palenda nitu la sila, fo ala kalua leme hataholi la sila mai. Ala kalua ma ala langgou lae, “O ia, Manetualain Anan!” Huu nitu la sila bubuluk, lae, Ndia ndia, Karistus, fo Manetualain helu basan so, neme makahulun mai, fo sangga haituan mai. Huu ndia de, Yesus kaꞌi sala fo ta bole kokolak dedeꞌa deꞌek esa boe, laꞌeneu Ndia aon. ");
INSERT INTO llg_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Neu foꞌa lolembilan, Yesus foꞌa de neni mamana linok esa neu, nai kota deak. Hataholi la sanggan sudi nai bee. Ledoeik ala latonggo lon, boe ma ala kokoen, lae, “Ama leo tataak mia ai dei! Boso muni mamana feꞌek muu bali!” ");
INSERT INTO llg_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Tehuu Ana nataa, nae, “Au boe oo, musi uni nggolo feꞌe kala uu, fo uu afada Hala Malole laꞌeneu Manetualain palendan. Huu Lamatuak nadenu Au so, fo akalalaꞌok ues ndia.” ");
INSERT INTO llg_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Boe ma Ana laꞌok neme nggolok esa mai, neni nggolo feꞌek neu, fo Ana nanoli nai uma huhule-haladoi kala nai propinsi Yudea. ");
INSERT INTO llg_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Laꞌi esa, Yesus nanoli hataholi la leme dano Galelea bifin. Hataholi noꞌu kala mai fo sangga lamanene Manetualain Dedeꞌa-kokolan. Losa ala lakaseseti ma lakahohombu lala Yesus. ");
INSERT INTO llg_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Deka-deka nai ndia, hambu mana mbuꞌa-dala la, tao lalalao sila mbuꞌa nala lai madak lain. Boe ma Yesus nita ofak louk dua see lai ndia. ");
INSERT INTO llg_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Esa neme ofa kala sila mai, na Simon ofan ndindia. Basa de, Yesus saꞌe neni Simon ofan lain neu, de noke fo tumbun neni oe madema fa neu. Boe ma nanggatuuk de nanoli hataholi noꞌu kala sila. ");
INSERT INTO llg_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Nanoli nateꞌe, boe ma Ana nafada Simon nae, “Mon! Teni oe madema fa teu, fo nggali o mbuꞌam neu ndia. Huu dei fo ei hambu iꞌak noꞌuk.” ");
INSERT INTO llg_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Tehuu Simon nataan, nae, “Lamatuak boe oo! Ai tao ues mbilu mbuse leꞌodae katemak esa, tehuu ta hambu iꞌak esa boe! Tehuu Ama nae leo ndia, de, neu! Au akonda sudi kana.” ");
INSERT INTO llg_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Boe ma ala lakonda mbuꞌak, fo sangga helan lain mai, tehuu mbuꞌak ndia henuk no iꞌak makadotok, losa mbuꞌak mulai sida so. ");
INSERT INTO llg_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Boe ma Simon nanggou nonoo nala malai ofa feꞌe kala, fo ala mai falin. Boe ma ala mai hulu iꞌak neni ofak dale neu losa ofak kadua kala sila henuk no iꞌa kala, de uak ala bolo. ");
INSERT INTO llg_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Simon nonoo mana mbuꞌa-dala nala, Yakobis no Yohanis, fo Ama Sebedeus ana nala lai ndia boe. Ala heran lalan seli, huu ala hambu iꞌak makadotok leo ndiak. Ledoeik Simon Petrus nita hata fo mana dadik ndia so, boe ma tutik ana sendek lunggulanggan neu Yesus matan de nae, “Au ia hataholi mana tao salak noꞌun seli. De malolenak Lamatuak boso dekak mua au bali. Tehuu Yesus bala nae, “Mon! Boso mambue kada duduꞌa dedeꞌak ndia, huu Au sangga pake ei. Ei ia mateme sangga iꞌak. Tehuu hatematak ia, Au anoli ei sangga hataholi fo tungga Au.” ");
INSERT INTO llg_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ala hela tutik sila ofan de taon neni madak lain neu. Boe ma ala laꞌo ela basa-basan, de ala tungga Yesus leo. ");
INSERT INTO llg_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Nai nggolok esa, Yesus natonggo no hataholi kamahedi kusta esa, fo hedis ndia, mboti nala basa aoinan so. Ledoeik nita Yesus, boe ma, ana sendek lunggulanggan ma nakatele losa dae. De, nae, “Ama aa. Fali mala au dei! Huu au bubuluk Ama bisa tao mamopo au heding ia, fo suek hataholi la, boso nunute au bali. Sadi Ama nau.” ");
INSERT INTO llg_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Boe ma Yesus look liman neu, de nafaloen. De, Ana kokolak nae, “Au nau! O hai leo!” Kokolak basa, boe ma, hataholi ndia hedi kustan mopo heni tutik kana leo. ");
INSERT INTO llg_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Basa de, Yesus fee nasanenedak neun, nae, “Masanenedak neulalau! O hai ia so, tehuu o ta bole mafada sudi see, baa! O musi tungga Baꞌi Musa palendan dei. De muni malangga anggama muu, fo ana palisak o ao-inam, suek ana bubuluk o hedim mopo tetebes so, do ta. Basa na, o musi fee tunu-hotuk, fo basa hataholi la bubuluk, lae, o ia hai tetebes so.” ");
INSERT INTO llg_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Mae Yesus kaꞌin, tehuu tutuik laꞌeneu Ndia koasan ndia, nana natanggelak neme bafak mai neni bafak neu, neni sudi bee neu. De hataholi la lambue faa lakandoo leu, fo sangga lamanene Ana nanoli sala. Boe ma Ana tao nahai hataholi noꞌu kala, leme sila hedin mata-mata kala mai. ");
INSERT INTO llg_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Tehuu Yesus boe oo, nahiik heok laꞌo ela hataholi noꞌu kala sila, fo neu hule-haladoi nai mamana linok. ");
INSERT INTO llg_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Laꞌi esa, Yesus nanoli hataholi la, leme uma esa. Faik ndia hambu hataholi leme partei anggama Farisi mai, ma mese anggama hida, mai tungga lamanene Ndia. Ala mai leme nggolo-nggolo kala malai propinsi Galelea, leme propinsi Yudea mai, ma leme kota Yerusalem mai. Manetualain fee koasa neu Yesus, fo Ana tao nahai hatahaoli kamahedi kala. ");
INSERT INTO llg_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","19","Faik ndia hataholi luma ndolo leni hataholi luꞌuk esa nai loanak esa lain. Ala lasusua tingga-tingga leni hataholi luꞌuk ndia neu, fo Yesus tao nahain. Tehuu uma ndia nakaseꞌe no hataholi la, de mae nakaseseti dalek neu boe oo, ta bisa. Huu ndia de, ala loo hataholi luꞌuk ndia neni uma kalak lain neu. De, ala ofe tao bolok, fo londa hataholi luꞌuk ndia dae neu, nai loanak ndia lain. Ala lakondan neu hataholi noꞌu kala laladan, ndandaak neu Yesus matan. ");
INSERT INTO llg_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Nita leo ndia, boe ma Yesus bubuluk nae, ala lamahele Ndia bisa tao nahai sila nonoon ndia. Boe ma, Ana kokolak no hataholi luꞌuk ndia, nae, “Ananggo ei! Au koka heni o sala mala so.” ");
INSERT INTO llg_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Lamanene Yesus kokolan leo ndia, de hataholi Farisi la ma mese anggama la, mulai duduꞌa lae, “Heh! Kada Manetualain mesa kana naena hak fo koka heni hataholi sala nala. Tehuu ndia ia see, de losak ana tao aon leo Manetualain! Ia ia, namumulu belak ia so!” ");
INSERT INTO llg_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Tehuu Yesus bubuluk sila dalen nala. De, Ana kokolak, nae, “Hatina de ei duduꞌa mae, Au ia kokolak amumulu? ");
INSERT INTO llg_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","24","Au ia, Hataholi Isi-Isik. Ma Au aena hak, fo fee ambon hataholi salan. Mete ma kada Au afada hataholi luꞌuk ia, ae, ‘Au fee ambon neu o salam so’, na ei taa mita Au koasang nai daebafok ia. Tehuu mete ma Au ae, ‘Foꞌa leo! Luꞌa mala o loa anam, fo fali leo.’ Mete ma ana foꞌa tutik, na bei fo ei mita Au koasang. Huu ndia de Au nau tao ahai hataholi luꞌuk ia, fo suek ei boe oo, bubuluk Au aena hak, fo fee ambon neu hataholi salan.” Boe ma Ana heok nasafali de kokolak no hataholi luꞌuk ndia, nae, “Mambadeik leo! Luꞌa mala o loa anam fo fali leo!” ");
INSERT INTO llg_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Kada ngengge neuk, hataholi ndia foꞌa nambadeik neu hataholi noꞌu kala matan, de ana luꞌa nala ndia loa anan. Boe ma ana fali, ma ana soꞌuk koa-kiok neu Manetualain. ");
INSERT INTO llg_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Lita leo ndiak, de basa hataholi la heran. Basa de, ala soꞌu dema-demak Manetualain naden, lae, “Lamatuak ana seli, bae maa! Leledon ia ita tita to ita mata deꞌe heheli nala, dedeꞌa manai lain seli ia so.” ");
INSERT INTO llg_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Taa dook, boe ma Yesus kalua neme uma ndia mai, de nita hataholi mana susu bea esa, nanggatuuk nai mamana susu bea. Hataholi ndia naden Lewi. Boe ma Yesus noken, de nae, “Mai tungga Au!” ");
INSERT INTO llg_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Namanene leo ndia, boe ma Lewi foꞌa tutik, de ana laꞌo ela basa malai ndia kala, de ana tungga Yesus. ");
INSERT INTO llg_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Basa ndia, boe ma Lewi tao feta inahuuk, de ana hoka Yesus neni uman neu. Ndia boe oo, hoka nonoo mana susu bea la, ma nana hoka feꞌe kala, fo ala mai laꞌa feta. ");
INSERT INTO llg_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Tehuu hambu hataholi partei Farisi hida, ma mese anggama la ala manggalau neu Yesus ana mana tungga nala, lae, “Hatina de ei manggatuuk miꞌa mia hataholi papake taa kala sila, fo leo mana susu bea la, ma hataholi taa malole la sila? Hataholi neulauk, taa bole seseok mia hataholi mata-aok leo sila!” ");
INSERT INTO llg_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Tehuu Yesus nafada sala, nae, “Hataholi kamahedik memak ana toꞌa dotel. Tehuu hataholi neulauk taa toꞌa. ");
INSERT INTO llg_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Au mai akaneni hataholi taa malole la. Tehuu Au taa mai akaneni hataholi fo nameda aon ndoos so!” ");
INSERT INTO llg_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Boe ma, hataholi maneme partei Farisi, ma mese anggama la manggalau lo Yesus, lae, “Leo iak, Ama! Yohanis Mana Salanik ana mana tungga nala puasa ma ala hule-haladoi bali-bali. Hataholi Farisi la ana mana tungga nala leo ndiak boe. Tehuu hatina de Ama ana mana tungga nala lambue laꞌa-linu lakandoo? Sila ndia taa puasa litak, do?” ");
INSERT INTO llg_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Tehuu Yesus bala nenik nakandandaak neu sala, nae, “Memak ei bubuluk so, mete ma hambu feta kabin, na, nana hoka kala taa puasa, tehuu ala laꞌa lakabete. Mete ma mana kabin touk ana bei nai ndia, na neu ko basa sala laꞌa noꞌu. ");
INSERT INTO llg_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Tehuu dei fo laꞌi esa, mete ma hataholi feꞌe kala humu leni mana kabin touk dei, na, dei fo ndia nonoo nala lameda dale hedi, de bei fo ala puasa.” ");
INSERT INTO llg_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Basa de, Yesus fee nakandandaak esa bali, nae, “Taa hambu hataholi haꞌi nala tema beuk bibiak esa, fo tandan neu badu laak sidan. Huu dei fo mete ma safe badu ndia, na tema beuk nana tandak ndia, kukulu, de badu laak ndia boe sidan. ");
INSERT INTO llg_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","38","Leo ndiak boe, hataholi taa bisa diꞌa tua beuk neu samba laak nalan seli, huu naafo sidan, fo tetee heni tua ndia. De, tua beuk na musi diꞌan neni samba beuk neu. No leo ndiak, na Yesus nanoli sala nae, Ndia nanonolin beun, boso seseo kana no hataholi Farisi la nanonoli laan. ");
INSERT INTO llg_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Hataholi fo ninu nitak anggol oek laak, na, ana taa hii ninu anggol oek beuk. Huu ana bubuluk, nae, ‘Anggol fo nana mbeda nala dook ndia, ladan nai lain seli!’ ” ");
INSERT INTO llg_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Laꞌi esa, nandaa no hataholi Yahudi la fai hahae tao ues, de Yesus no Ndia ana mana tungga nala, ala laꞌok tungga hataholi osin dale. Boe ma Ndia ana mana tungga nala, ketu lala hade-gandum mbulen mana dekak no sila. Boe ma, laꞌisi de laꞌa. ");
INSERT INTO llg_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Nai ndia boe oo, hambu hataholi luma leme partei anggama Farisi, fo mana toꞌu tea-tea sila hada Yahudin. Lita Yesus ana mana tungga nala tao leo ndiak, boe ma lafada Ndia, lae, “Hatina de O ana mana tungga mala laꞌolena ita heti-heu anggaman? Ala tao ues nandaa no fai hahae tao ues! Mita ndia! Ala ketu hade-gandum. Taa bole leo ndiak!” ");
INSERT INTO llg_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","4","Tehuu Yesus bala, nae, “Talobee bae? Ei taa masaneda baꞌi Dauk tutuin ndia? Baꞌi Dauk no ndia ana mana tungga nala, tei nala kio huu ala ndoe lalan seli. De, ala maso leni Manetualain Tenda Huhule-haladoin dalek leu, de ala haꞌi lala loti fo malangga anggama la feen neu Lamatuak so, de laꞌa. Naa te, kada malangga anggama la bole laꞌa loti ndia. Hataholi feꞌek, taa bole. Boe ma baꞌi Dauk asa laꞌa, tehuu taa hambu hataholi fee salak neu sala. Ei ia nonook taa les mitak Manetualain Susula Malalaon! ");
INSERT INTO llg_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Pasa ndiꞌidook, fo mamanene neulalau! Au ia, Hataholi Isi-isik. Au aena hak fo aketu, ae, hataholi bole tao hata, nandaa no fai hahae tao ue-ledis.” ");
INSERT INTO llg_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Faik esa, nandaa no fai hahae tao ue-ledis feꞌek, boe ma Yesus neu nanoli nai uma huhule-haladoik. Nai ndia, touk esa liman seli kamates. ");
INSERT INTO llg_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Nai ndia boe oo, hambu mese anggama hida, ma hataholi leme partei anggama Farisi mai, fo ala sangga lelak, suek ala kakai latuda Yesus. Basa de ala lahani, fo mete ma Ana nau tao nahai hataholi lima kamate seselik ndia, nandaa no fai hahae tao ue-ledis. No leo ndiak, na, ala bisa fee salak neu Ndia nai matan. ");
INSERT INTO llg_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Tehuu Yesus bubuluk tebe-tebe sila hihiin. Huu ndia de Ana noke nala hataholi lima kamate seselik ndia, de nae, “Kaꞌa aa! Mai mambadeik muu lalada ia dei!” De, ana neu nambadeik tutik. ");
INSERT INTO llg_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Boe ma Yesus natane hataholi la sila, nae, “Hena Au atane sudik ei, dei. Tungga ita anggaman heti-heun, na kada ita bole tao hata, nandaa no fai hahae tao ue-ledis. Ita tao dedeꞌa malole, do tao dedeꞌa manggalauk? Ita tao tasoda hataholi, do tao takalulutu ndia sodan?” ");
INSERT INTO llg_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Basa de Yesus suli ndule sala, boe ma Ana nafada hataholi lima kamate seselik ndia, nae, “Look o limam mai!” De ana loo kana neu, boe ma liman hai tutik. ");
INSERT INTO llg_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Lita leo ndia, boe ma Yesus musu nala manggalau. De, ala mulai heti kekedik, lae, “Ai musi sangga dala feꞌek bali, fo tao tatudan!” ");
INSERT INTO llg_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Taa dook so bali, boe ma Yesus neni letek esa neu, fo Ana hule-haladoi. Basa de Ana hule-haladoi nai ndia, leꞌodae katemak esa. ");
INSERT INTO llg_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Neu foꞌa fafain, boe ma Ana noke nala Ndia ana mana tungga nala. Basa de neme sila basa sala mai, Ana hele nala hataholi sanahulu dua, fo ala dadik leu Ndia hataholi nadedenu nala. Hataholi fo Ana hele kala sila, ndia: ");
INSERT INTO llg_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simon (fo Yesus nateme noke nae ‘Petrus’), Anderias (Simon fadin), Yakobis, Yohanis (Yakobis fadin), Filipus, Bartolomeos, ");
INSERT INTO llg_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateos, Tomas, Yakobis (Alpius anan), Simon (mana tungga partei politik Selot), ");
INSERT INTO llg_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yudas (Yakobis anan), ma Yudas Iskariot (fo dei fo ana seꞌo heni Yesus) ");
INSERT INTO llg_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ledoeik ala konda leme letek ndia lain mai, de Yesus no Ndia ana mana tungga nala, lambadeik leme dae matetuk. Nai ndia boe oo, hataholi noꞌu kala, ala lakabubua. Sila ndia, mai leme propinsi Yudea, leme kota Yerusalem, leme Tirus ma Sidon mai, fo ndia kota dua lai tasi bifin. ");
INSERT INTO llg_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ala mai fo sangga lamanene neu Yesus ma luma ala loke Ndia fo tao nahai hataholi kamahedi kala. Boe ma, Ana tao nahai sala. Ndia boe oo, tao nahai hataholi nitu nalak, ma Ana husi kalua heni nitu la kalua leme hataholi la mai. ");
INSERT INTO llg_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Basa hataholi la, ala lahiik daba laꞌe Ndia, huu mete ma ala daba laꞌen, na, hambu koasa ana kalua neme Ndia mai fo tao nahai sala. ");
INSERT INTO llg_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Basa de Yesus heok nasale Ndia ana mana tungga nala, de nanoli, nae, “Hataholi kasia nala aa! Ei maua-manale, huu Manetualain mesa kana ndia, ei Mane malolen. ");
INSERT INTO llg_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Hataholi mana ndoe kala aa! Ei maua-manale, huu dei fo Lamatuak tao ei makabete. Hataholi mana mamatani ma mana dale hedi kala aa! Ei maua-manale, huu dei fo ei dale mala hika lamahoko. ");
INSERT INTO llg_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","23","Hataholi mana toꞌa-taak, huu tungga Au Hataholi Isi-isik ia! Ei maua-manale, huu dei fo Lamatuak bala ei nai nusa-sodak. Mae hataholi husembuluk neu ei, fo tao nakalulutu ei nade malolen, do, ana heheta ei, do ana husi nggali heni ei, sama leo hataholi manggalauk, na ei maua-manale, huu dei fo Lamatuak nasaneda ei, nai nusa-sodak. De, mete ma hataholi tao nakatotoꞌak ei leo ndiak, na, kada tao ei dale mala lamahoko! Ma makaboku mamahoko! Boso heran, huu hataholi mana tao nakatotoꞌak ei ndia, hatematak ia, sila bei-baꞌi nala mesa kasa tao lakatotoꞌak Manetualain mana kokola lele ulu nala. De, mete ma ei hambu totoꞌak mata leo ndiak, na, kada tao ei dale mala lamahoko, huu dei fo Lamatuak bala fee ei makadotok nai nusa-sodak! ");
INSERT INTO llg_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ma hataholi kamasuꞌi kala aa! Ei hambu soe, huu ei soda mala lamahoko, kada losa ia. ");
INSERT INTO llg_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Hataholi makabete kala aa! Ei hambu soe, huu fai ndoen ana seli laꞌe ei. Hataholi mana hika-setelee taa no hada kala aa! Ei hambu soe, huu totoꞌak ana mai tao nala ei makadii-makau. ");
INSERT INTO llg_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Hataholi mana sangga hada kala aa! Ei hambu soe, huu makahulun ei bei-baꞌi mala boe, ala koa-kio mana kokola masapepeko kala!” ");
INSERT INTO llg_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Boe ma Yesus tuti, nae, “Pasa ndiꞌidook fo mamanene neulalau! O musi sue o musu mala, ma tao dedeꞌa malole neu hataholi mana husembuluk neu o. ");
INSERT INTO llg_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Hule-haladoi fo moke Manetualain tao dedeꞌa malole neu hataholi mana sumba-soo o. Ma moke fo Ana tao dedeꞌa neulauk neu hataholi mana tao babalik o. ");
INSERT INTO llg_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Mete ma hambu hataholi famba o nasum seli, na, mboꞌin fo ana famba seluk o nasum seli bali. Mete ma hambu hataholi namoa nala o badu jeket, na, fee tamba o badum neu ndia bali. ");
INSERT INTO llg_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mete ma hambu hataholi noke o buam esa, na, kada feen neu leo. Ma mete ma hambu esa ana haꞌi neni o buam esa, na, neme naa, fo ana soan leo. Boso muu moke fali kana bali! ");
INSERT INTO llg_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","O musi tao mala hataholi feꞌe kala, nandaa leo o hii hataholi la tao o leo ndiak boe. ");
INSERT INTO llg_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","O mahiik matudu susuek neu o hataholi heheli mala. Ndia malole. Tehuu ndia ana selin, hata? Huu hataholi manggalau kala boe oo sue sila hataholi heheli nala! ");
INSERT INTO llg_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Mete ma kada o tao malole neu hataholi mana tao malole neu o, na, ndia ana selin nai bee? Huu hataholi manggalau kala boe, labalak tao malole leo ndiak boe ");
INSERT INTO llg_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Mete ma o bisa fee doi tonda neu hataholi fo ana bisa bae fali kana, na, ndia ana selin hata? Huu hataholi manggalau kala bisa fee doi tonda neu hataholi feꞌek, sadi mbila-binesak na, ala simbo fali kana no katemak. ");
INSERT INTO llg_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Tehuu ana selin ndia, fo ndia leo iak: sue o musu mala! Ma tao dedeꞌa malole neu sala. Hata fo ala paluu, na, kada fee sala tonda. Boso duduꞌa, mae, ala bisa fee fali kana, do taa. No leo ndiak, na dei fo Manetualain bala o. Ma o dadik Manetualain Manai Lain Seli anan. Huu o masoda sama leo o Amam, fo nahiik tao dedeꞌa malole neu hataholi manggalauk. Ndia boe oo, tao dedeꞌa malole neu hataholi, fo taa noke makasi nalelak. ");
INSERT INTO llg_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","De, o musi matudu dale kasian neu hataholi, sama leo o Amam nai nusa-sodak, natudu dale kasian neu o boe.” ");
INSERT INTO llg_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Yesus nanoli nakandoo, nae, “Boso uku hataholi, suek hataholi taa uku o. Boso sapa hataholi, huu dei fo hataholi la sapa lasafali o. Mafalende heni hataholi salan, fo suek lafalende heni o salam boe. ");
INSERT INTO llg_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mete ma o fee hataholi hata fo ala paluun, na, dei fo o simbo fali kana. Huu dei fo Lamatuak heti, fo o simbo falik makadotok. Ndia sama leo hataholi la mboꞌa fufue makadotok neni balee uꞌukuk dale neu, basa na ala ndondokon, neꞌen dae neu, basa na, ala isi lakadai kana seluk bali, mboi-mboi, losa ana sasi. O sisimbon ndia, namata-ao leo ndiak. Mete ma o fee fak, na o simbo falik fak boe. Tehuu mete ma o fee noꞌuk, na o boe oo, simbo falik makadotok.” ");
INSERT INTO llg_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesus boe nanoli nenik nakandandaak. Ana tui nae, “Hataholi mbokek taa bisa natudu dalak neu hataholi mboke feꞌek. Huu dei fo dua sala tuda noꞌu leni bolok dale leu! ");
INSERT INTO llg_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Sakolanak taa bisa ana selin lena heni ndia mesen! Tehuu mete ma ana tungga neulalau ndia mesen nanonolin, na ana bisa dadi sama leo ndia mesen. ");
INSERT INTO llg_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","O mahiik kada tanda neulalau hataholi sala kadiꞌi anan. Tehuu o sala inahuum, o taok leo bali taa. Ndia sama leo o mita huꞌuk esa nai hataholi matan. Naa te hambu balok inahuuk babaa nala o matam, tehuu o taa mameda sana! ");
INSERT INTO llg_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Talobee fo o mambalani kokolak mae, ‘Tolanoo! Mai fo au tulun nggai kalua heni huꞌuk neme o mata deꞌem dale mai dei.’ Naa te o mesa nggo taa bisa mita hata-hata, huu hambu balok babaa o matam! Wei! Memak o hadam ia, mana dea-matak tetebes! Tulun dei! Soꞌu nggali heni balok ndia neme o mata hehelim mai dei. Bei fo o bisa mita, fo tulun nggai heni huꞌuk neme o nonoom matan ndia.” ");
INSERT INTO llg_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Yesus tamba nakandandaak esa bali, nae, “Taa hambu ai malole, naboa boa taa malole. Ma taa hambu ai taa malole, naboa boa malole. ");
INSERT INTO llg_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Hataholi bisa tandan, mete ma ai esa, malole do taa, na neme ai ndia boa nala mai. Basa hataholi la bubuluk, lae, taa hambu, hataholi seu ufa boak, do, anggol boak neme ai dilak mai. ");
INSERT INTO llg_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Leo ndiak boe hataholi dale malalaok, bisa tao dedeꞌa malole. Tehuu hataholi dale manggenggeok tao dedeꞌa manggalauk. Huu neme hataholi kokolan mai, natudu ndia hada teteben.” ");
INSERT INTO llg_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Basa boe ma Yesus tuti bali, nae, kada ei mambue moke Au mae, ‘Lamatuak’. Tehuu hatina de ei taa nau tungga Au kokolang? ");
INSERT INTO llg_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Hataholi mana mai lamanene Au, boe ma ana tao tungga Au kokolang, ndia ndia sama leo ");
INSERT INTO llg_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","hataholi fo ana sangga nambadedei uma matea. Ana kali neulalau bolo fanderen nai dae isik dei, losa hambu batu isik. Boe ma ana tao fanderen ndandaak neu batu lain, bei fo ana nambadedei uma. Mete ma faa mai, na, uma ndia taa nanggeꞌo, huu buin matea so. ");
INSERT INTO llg_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Tehuu hataholi, fo kada namanene no dale bibiak, ma taa tungga Au kokolang, na, ndia ndia, sama leo hataholi fo ana nau nambadedei uma kada no lofoanak. Ana taa tao fanderen, tehuu kada nanggatutuu uma ndia neu dae isik lain, nai lee bifin. Boe ma faik fo faa mai, na ana sapu nakalulutu heni uma ndia!” ");
INSERT INTO llg_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Nanoli basa leo ndia, boe ma Yesus fali neni kota Kapernaum neu. ");
INSERT INTO llg_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Nai ndia, hambu malangga soldadu Roma esa. Ana naena ana manatao ues esa, fo ana namahelen. Hataholi mana tao ues ndia, namahedi, de elabaꞌik maten. ");
INSERT INTO llg_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Faik fo malangga soldadu ndia namanene laꞌeneu Yesus, boe ma ana haitua hataholi lasik Yahudi luma, leu loken Ana mai fo tao nahai ana mana tao ues ndia. ");
INSERT INTO llg_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ala kokoe Ndia, fo leo bisa, na, Ana tungga sala, fo neu tao nahai hataholi ndia. Ala kokoe Ndia, lae, “Ama aa! Hataholi Roma ia, hataholi neulauk! Ndia ndia, nandaa Ama Ana falin. ");
INSERT INTO llg_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Huu ana nambadedei uma huhule-haladoik esa fee ita, huu ana sue ita hataholi Yahudi la.” ");
INSERT INTO llg_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Boe ma Ana tungga no sala. Ala bei ta losa uma, tehuu malangga soldadu ndia haitua ndia nonoo nala mai lafada Yesus, lae, “Lamatuak, boso masotak muu bali, huu au taa andaa simbok Lamatuak nai au umang. ");
INSERT INTO llg_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","8","Ma au boe oo, taa andaa asale Lamatuak. Manggaledok so, fo au ae, Lamatuak naena koasa. De, sadi kada Lamatuak kokolak neme ia mai, na neu ko au ana mana tao ues ia, hai tutik. Au bubuluk dedeꞌak ia, huu au malangga nggala laena koasa, fo palenda au. Ma au boe oo, aena koasa fo palenda au soldadu nggala. Mete ma au palenda au ana palendang ae, ‘Muni ele muu!’ na neu ko ana neu. Mete ma au ae ‘Ia mai!’ na neu ko ana mai. Ma mete ma au adenu au hataholi mana tao ues, ae, ‘Tao ia!’ na neu ko ana tao leo ndiak. De, sadi kada Ama kokolak, na neu ko au ana mana tao ues ndia, hai tutik.” ");
INSERT INTO llg_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Namanene leo ndia, boe ma Ana heok aon, de nasale hataholi noꞌuk fo mana tungga Ndia. Boe ma Ana nae, “Heran, oo! Doo basa ia so, tehuu Au bei ta atonggo itak ua hataholi Yahudi esa, fo namahehelen tean sama leo hataholi Roma ia!” ");
INSERT INTO llg_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","De, Yesus Ana laꞌok losa kada ndia. Boe ma malangga soldadu nonoo nala ala fali. Losa malangga soldadu ndia uman, tehuu ala lita hataholi kamahedik ndia hai tutik so. ");
INSERT INTO llg_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Foꞌa mai, boe ma Yesus no Ndia ana mana tungga nala, laꞌo leni nggolok esa leu, nade Nain. Hambu hataholi noꞌu kala laꞌok noꞌu lo sala. ");
INSERT INTO llg_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ledoeik ala sangga dekak lo nggolok ndia lelesun dalek neu, boe ma hataholi bubuak esa, sangga kalua leu latoi mamate. Mana matek ndia, na ina falu esa ana touana kisan ndindia. ");
INSERT INTO llg_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ledoeik Yesus nita ina falu ndia, boe ma Ana tuda kasian neun. De, Ana nafada inak ndia, nae, “Ina aa! Nenee leo, boso mamatani bali!” ");
INSERT INTO llg_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Basa de Yesus neu deka-deka, de tai laꞌe mamana ndolo mamate ndia. Boe ma hataholi mana ndolo mamate sila, hahae tataak. De, Ana nafada mamate ndia, nae, “Taꞌe aa! Foꞌa leo!” ");
INSERT INTO llg_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Boe ma tou anak ndia nasoda fali, de ana foꞌa nanggatuuk tutik. De, ana mulai nakokola no hataholi mana mambadeik ndule ndia. Basa de Yesus nafada inak ndia, nae, “Ina aa! Simbok mala ina anan leo.” ");
INSERT INTO llg_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Basa hataholi malai ndia kala, bii lalan seli! Boe ma ala koa-kio Manetualain, lae, “Manetualain nadenu Ndia mana kokolan esa fo ana seli neu ita!” Hambu feꞌek bali, na, lae, “Manetualain mai nai ita laladan so, fo natudu Ndia dale malolen!” ");
INSERT INTO llg_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Boe ma tutuik ndia nakambela neni sudi bee neu, nai propinsi Yudea, losa nusa babaꞌe feꞌe kala boe. ");
INSERT INTO llg_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","20","Yohanis Mana Salanik ana mana tungga nala lamanene basa dedeꞌa kala, fo Yesus tao kala sila so. Basa de, leu tui Yohanis nai bui dale. Boe ma, ana haitua hataholi dua leni Yesus leu, fo latanen, lae, “Ama ia tebe-tebe Karistus, fo ai mahani taa-taak ndia, do? Do ai musi mahani hataholi feꞌek bali?” Basa, de latonggo lo Yesus, de ala latane leo ndiak. ");
INSERT INTO llg_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ledoeik hataholi nana nadedenu kala sila lai ndia, boe ma Yesus tao nahai hataholi noꞌuk kala hedin mata-mata kala. Ma Ana husi kalua heni nitu neme hataholi nitu nalak mai. Ma Ana tao nahai hataholi mboke kala, de bisa lita. ");
INSERT INTO llg_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Boe ma Yesus nafada Yohanis ana mana tungga nala, nae, “Ei fali miu mafada kaꞌa Nani, basa hata fo ei mamanenen so, ma ei mita aom so, fo sama leo Manetualain mana kokolan Yesaya sulak, nae, ‘Hataholi mbokek, bisa nita. Hataholi ei luꞌuk, foꞌa fo laꞌok. Hataholi hedi kusta, dadik malalaok. Hataholi mbakek, hambu namanene. Hataholi kamates, nasoda fali. Hataholi kasian, namanene Hala Malole.’ ");
INSERT INTO llg_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Fali miu mafada kaꞌa Nani, mae, ‘Hataholi taa mana maek, simbok Au, na, dei fo ala laue-lanale tebe-tebe.’ ” ");
INSERT INTO llg_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Faik fo Yohanis ana mana tungga nala fali so, boe ma Yesus kokolak no hataholi noꞌu kala sila, laꞌeneu Yohanis, nae, “Faik fo ei miu sangga Yohanis nai mamana nes ndia, ei duduꞌa mae sangga matonggo mia hataholi mata leobeek? Ei taa miu matonggo mia hataholi noe-naꞌuk, fo sama leo oo, de ani fumbun neu-mai. ");
INSERT INTO llg_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ei taa miu fo mita hataholi mana pake baloꞌa mabeli, sama leo hataholi leo nai uma manek! ");
INSERT INTO llg_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","De, ei miu tilo see nai ele? Do ei miu sangga Manetualain mana kokolan? Tetebes! Ndia ndia, Manetualain mana kokolan fo ana seli. ");
INSERT INTO llg_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","De, Susula Malalaok nana sula memak laꞌeneu Yohanis, nae, ‘Mamanene! Au adenu Au hataholing, fo neu soi dalak fee O.’ ");
INSERT INTO llg_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Nai daebafok ia, taa hambu hataholi esa boe, fo lena heni Yohanis. Tehuu nai Lamatuak nusan, na, kada hataholi manai dae teteꞌen, ana seli lena heni Yohanis.” ");
INSERT INTO llg_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Hataholi mana mamanene Yesus kokolan ndia, ala lalelak so, lae, Lamatuak dalan ndia, na, dala soda ndoos. Manasusu bea la boe oo, leo ndiak. Huu makahulun Yohanis salani sala, ma nanoli sala so. ");
INSERT INTO llg_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Tehuu hataholi maneme partei anggama Farisi ma malela heti-heu Yahudi, taa nau tungga Manetualain hihii-nanaun. Huu ndia de, ala taa loke Yohanis salani sala. ");
INSERT INTO llg_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Basa boe ma Yesus natane sala, nae, “Au sangga akasasama hataholi hatematak ia, no hata? Hataholi mata leobeek sila ia? ");
INSERT INTO llg_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Sila ndia, sama leo kakana kala mana manggatuuk lai pasak. Ala lambue langgou ma manggalau, lae, ‘Ai fuu kinuk noꞌu, tehuu ei taa longge mamahoko. Basa de ai soda sosoda bebeꞌe mamate, tehuu ei taa mamatani.’ ");
INSERT INTO llg_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Huu Yohanis Mana Salanik taa ninu anggol, ma nahiik puasa, na, ei makasasaꞌek ndia mae, ‘Ndia nitu nalak!’ ");
INSERT INTO llg_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Tehuu hatematak ia, Au, Hataholi Isi-isik ia, inu anggol ma uꞌa loti leo basa faik. Boe ma ei makasasaꞌek Au, mae, ‘Ndia ndia, memak hataholi balenaꞌo! Mana mafu funak bali! Neu nanonoo no mana susu bea la! Bubuak esa no hataholi papake taa kala! Ta nameda aon bali!’ ");
INSERT INTO llg_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Tehuu ei tanda Au kokolang ia leo, baa! Hataholi fo bubuluk tebe-tebe, na, ala tungga Lamatuak hihii-nanaun.” ");
INSERT INTO llg_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Nai kota ndia, hambu hataholi Farisi esa, nade Simon. Laꞌi esa, ana hoka Yesus asa mai laꞌa nai ndia uman. Simbo nala hohokak ndia, boe ma Yesus asa leu, fo sangga langgatuuk laꞌa. ");
INSERT INTO llg_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Faik ndia, hambu ina kalabik esa namanene, lae, Yesus sangga naꞌa nai ndia. De, ana maso mai, ma toꞌu neni mina kaboo menik mabeli boto esa. ");
INSERT INTO llg_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ana mai dekak nesik Yesus dean. Basa de ana sendek lunggulanggan neu Yesus ein. Boe ma ana namatani nakaleleu losa lun tuda laꞌe Yesus ein. Ana seka Yesus ein nenik ndia langga-bulu hehelin, ma ana idu nakamiminak Ndia ein. Basa de ana diꞌa mina kaboo menik ndia neu Yesus ein. ");
INSERT INTO llg_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Simon ndia, bubuluk inak ndia nanggatutuu-nambadedein. Huu ndia de ana duduꞌa nai dalen dale, nae, “Ia ana dadik buti so neu Yesus ia, fo Manetualain mana kokolan taa ia! Mete ma tebe-tebe Manetualain haitua Ndia mai, na, neu ko Ana bubuluk so, inak mana mafaloe Ndia, na, ina kalabik. Manetualain mana kokolan taa matak leo Ndia ndia, huu hataholi malalaok taa bole deka-deka no hataholi manggenggeo kala!” ");
INSERT INTO llg_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Tehuu Yesus bubuluk hata fo Simon duduꞌak ndia. Boe ma Ana nae, “Kaꞌa Mon! Leo iak, kaꞌa. Au sangga afada kaꞌa dedeꞌak esa.” Boe ma Simon nataa, nae, “Neu! Ama mesen, kokolak leo.” ");
INSERT INTO llg_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","De, Yesus Ana ngganggali kokolak neu ndia, nae, “Hambu hataholi esa, mana tukan fee hataholi feꞌe kala tondan doik. Ana fee nitak doi tonda neu hataholi dua. Ana fee esa tonda doi fulak natun lima, ma feꞌek kada lima huluk. ");
INSERT INTO llg_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Tehuu losa fain fo ala musi fee falik doi kala sila, dua sala taa labeꞌi. Boe ma mana fee doi tonda ndia, tuda kasian neu dua sala. Huu ndia de, ana nakamboꞌik dua sala leme dua sala huta nala mai. Mete ma tungga kaꞌa Mon duduꞌan, na, neme hataholi kadua kala mana tonda doi kala sila, na, bee ndia ana sue lena mana fee doi tonda ndia?” ");
INSERT INTO llg_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon ndaso nenenik nae, “Neu ko mana mahuta noꞌuk, maa!” Yesus nataa, nae, “Tetebes, kaꞌa!” ");
INSERT INTO llg_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Boe ma Ana heok nasale inak ndia, de nafada Simon nae, “Soba kaꞌa Mon suli neulalau inak ia. Ledoeik Au maso uni kaꞌa uman dale mai, tehuu kaꞌa taa sadia oe, fo safe Au eing, tungga ita hadan. Tehuu inak ia, nakatataba Au eing nenik ndia lun, de ana seka nalalaon nenik ndia langga-bulun. ");
INSERT INTO llg_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ma isinaak, ledoeik o soluk Au nai kaꞌa Mon uman dale, tehuu kaꞌa Mon taa idu Au, tungga ita natetemen. Tehuu mulai neme Au maso uni uma ia dalek mai, inak ia taa hahae idu Au eing. ");
INSERT INTO llg_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Isinaak Au maso uni uma ia mai, tehuu kaꞌa Mon boe mafalende heni hada diꞌa mina neu hataholi mana maik langgan, fo isinaak Au maso mai ndia. Tehuu inak ia, diꞌa mina kaboo menik mabeli ana seli neu Au eing so. ");
INSERT INTO llg_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kaꞌa Mon mamanene neulalau dei! Memak inak ia salan noꞌuk. Tehuu Lamatuak koka heni basa salan so, huu natudu ndia susuen ma namemeda makasin noꞌun seli neu Au. Tehuu hataholi fo nameda taa tao salak noꞌuk, ndia boe oo, nameda taa paluu hambu ambon noꞌuk. Huu ndia de ana taa nalelak susuek, ma taa nameda makasi nalelak neu Lamatuak.” ");
INSERT INTO llg_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Basa de Yesus kokolak no inak ndia, nae, “Au koka heni o sala-singgo mala so!” ");
INSERT INTO llg_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Hataholi mana manggatuuk laꞌa noꞌu, ala mulai lakukutuk, lae, “Wei! Ana duduꞌa nae Ndia ndia see ia?! Ana nambalani fee ambon neu hataholi salan, bae maa! Naa te kada Manetualain mesa kana naena hak fo koka heni hataholi salan! Aweꞌek!” ");
INSERT INTO llg_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Tehuu Yesus nafada inak ndia, nae, “Huu o mamahele Au so, de Lamatuak tao nasoda o. Fali leo, mua mole-dame!” ");
INSERT INTO llg_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Taa dook so bali, boe ma Yesus no Ndia ana mana tungga nala hataholi sanahulu dua, laꞌok ndule kota ma nggolo kala malai ndia kala. Ala laꞌo leu lafada hataholi la laꞌeneu Manetualain palendan. Ndia dadik hala malole neu sala. ");
INSERT INTO llg_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Nai bubuak ndia dalek hambu inak hida tungga boe. Ina kala ia, hambu lamahedi mata-matak, ma hambu nitu nalak. Tehuu Yesus tao nahai basa sala so. Matak leo Maria maneme Magdala mai. Makahulun, Yesus husi kalua nitak nitu hitu leme ndia mai. ");
INSERT INTO llg_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Hambu Susana boe, ma ina Yohana. Ina Yohana ia, na ndia ama Kusa saon. Kusa ndia, na malanggga mana makanenik, nai mane Herodes uma manen. Ma bei hambu inak noꞌuk feꞌe kala fo ala laꞌok noꞌu lo Yesus asa. Ina kala ia pake sila doi heheli nala, fo tanggon Yesus asa doi dalan. ");
INSERT INTO llg_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Laꞌi esa, hataholi la kalua leme nggolo noꞌu kala mai, fo ala sangga Yesus. Ledoeik hataholi noꞌu kala lakabubua so, boe ma Ana tui fee sala nakandandaak esa, nae, ");
INSERT INTO llg_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Hambu hataholi mana maue daek esa, neu ngganggali bini nai ndia osin. Bini luma tuda leu dalak lain. De ledoeik hataholi la, laꞌok lesik ndia, boe ma ala heheta bini la sila. Ma mbui kala mai, de tutu laꞌa labasa sala. ");
INSERT INTO llg_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Bini luma bali, na, tuda leu dae batu. Bini sila mulai lanumbu, tehuu male heni sala, huu oe taa dai. ");
INSERT INTO llg_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Bini feꞌek luma, tuda leu mamana dilak. Tehuu ledoeik ala mulai lanumbu, boe ma ai dila kala, kabi lisa sala. ");
INSERT INTO llg_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Tehuu bini feꞌe kala bali, na, ala tuda laꞌeneu dae isi mamina. Ala lanumbu, basa de ala moli dadik inahuuk losa laboa. Bini la sila ala fee buna-boak laꞌi natun.” Tui basa leo ndia, boe ma Yesus nggoe nakandandaak ndia, ma nafada nae, “Ei mana pasak ndiꞌidook, na, duduꞌa neulalau!” ");
INSERT INTO llg_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Basa boe ma, Yesus ana mana tungga nala latane nakandandaak ndia ndandaan. ");
INSERT INTO llg_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ana nataa nae, “Leo iak! Huu ei tungga tebe-tebe Manetualain hihii-nanaun, de Au buka manggaledok, fo ei bubuluk, talobee fo Lamatuak nau palenda Ndia hataholi nala. Tehuu hataholi feꞌe kala taa nau mbali Lamatuak hihii-nanaun. Huu ndia de, Au anoli sala unik kada nakandandaak. Huu Lamatuak mana kokola nala sulak memak basan so, laꞌeneu hataholi la ia, nae, ‘Ala lita so, tehuu taa nau lalela kana. Ala lamanene so, tehuu taa nau bubuluk.’ ” ");
INSERT INTO llg_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Boe ma Yesus nafada nakandandaak ndia ndandaan, nae, “Bini ndia, na, ndia Manetualain Dedeꞌa-kokolan. ");
INSERT INTO llg_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Bini mana tuda nai dalak lain ndia, na, ndia hataholi mana mamanene Lamatuak Dedeꞌa-kokolan, tehuu basa de nitu la malangga inahuun mai, de namoa nala Dedeꞌa-kokolak ndia neme sila dale nala mai. No leo ndiak, de ala taa lamahele Lamatuak, ma taa hambu sodak. ");
INSERT INTO llg_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Bini mana tuda lai dae batu, na, ndia hataholi fo namanene Lamatuak Dedeꞌa-kokolan no namahokok. Tehuu oka nala taa tola losa dook. Ala mulai lamahele, tehuu mete ma totoꞌak laꞌe sala, na, lofoanak ala tuda. ");
INSERT INTO llg_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Bini mana tuda nai mamana dilak ndia, na, ndia hataholi mana mamanene ma ala simbok Lamatuak Dedeꞌa-kokolan. Tehuu taa dook, tehuu ala lafalende heni Dedeꞌa-kokolak ndia, huu lasambute lalan seli lakaneni sila dedeꞌa heheli nala, ma sila hata-heto nala mata-matak, ma lahiik kada namahokok. Huu ndia de sila namahehelen ndia, buna-boan taa ");
INSERT INTO llg_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Tehuu bini mana tuda nai dae isi mamina ndia, na, ndia hataholi fo dalen ndoos, ma malole. Ledoeik ala lamanene Lamatuak Dedeꞌa-kokolan, boe ma ala mbeda neulalaun neu dale nala. No leo ndiak, na ala lamahele lakandoo, ma tao dedeꞌa malole noꞌuk.” ");
INSERT INTO llg_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Basa de, Yesus kokolak bali, nae, “Taa hambu hataholi dede bandu anak, fo tatanan nenik ule dae. Ma taa hambu hataholi tao banduk neu koi sosolon. Huu mete ma leo ndiak, na, hataholi taa bisa nita manggaledok bali. Banduk kasosoak, na, taon neu mamana madema, fo suek saꞌan tao manggaledo hataholi mana neni dalek mai. ");
INSERT INTO llg_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Basa hata fo nana nafunik hatematak ia, dei fo dadik nana nitak. Ma basa hata fo hataholi taa bubuluk hatematak ia, dei fo hataholi la bubulu kana. ");
INSERT INTO llg_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","De, ei musi duduꞌa neulalau dedeꞌa kala ia. Hataholi fo tebe-tebe sangga bubuluk Lamatuak hihii-nanaun, na, ana boe dadik malelak. Tehuu hataholi fo taa mbali Lamatuak hihii-nanaun, na, ana boe namanggoa. ");
INSERT INTO llg_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Laꞌi esa, Yesus nasambute no hataholi noꞌu kala. Boe ma inan ma fadi nala mai fo sangga latonggo lo Ndia. Tehuu ala taa bisa deka-deka lo Ndia, huu hataholi noꞌun seli. ");
INSERT INTO llg_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Boe ma hambu hataholi neu nafada Yesus nae, “Ama aa! Ama inam ma fadi mala lai deak. Ala sangga latonggo lo Ama.” ");
INSERT INTO llg_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Boe ma nataa nae, “Hei! Tehuu leo iak. Au inang ma Au tolanoo tetebe nggala, sila hataholi fo mana lamanene Manetualain Dedeꞌa-kokolan, ma basa na, ala tao tunggan.” ");
INSERT INTO llg_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Laꞌi esa, Yesus noke nala Ndia ana mana tungga nala, nae, “Mai ita saꞌe ofa baluk, fo teni tasi selik teu.” Boe ma ala saꞌe leu ofa baluk esa, de mulai laꞌo. ");
INSERT INTO llg_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ledoeik ala lala tasi lai, boe ma Yesus sunggu. Taa dook boe ma ani sanggu mai. Lii mbuka neni ofak baluk dale neu. Ala hii-hii hambu soe so. ");
INSERT INTO llg_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Lita leo ndia, boe ma ana mana tungga nala, leu fafae Yesus, lae, “Lamatuak aa! Lamatuak aa! Foꞌa fo tulun dei! Huu ita sangga bolo mate ia so!” Boe ma Yesus foꞌa. Basa de Ana nafada ani ma lii, nae, “Hahae leo!” Boe ma lii ma ani hahae tutik. ");
INSERT INTO llg_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Basa de Ana nafada ana mana tungga nala, nae, “Hatina de ei bei ta mamahele Au boe?” Ala bii ma heran. Boe ma ala latatanek esa no esa, lae, “Awii! Huu Yesus ia, na, see? Talobee de Ana bisa palenda ani ma lii, de ala tungga Ndia hihiin?” ");
INSERT INTO llg_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Taa dook, boe ma ala losa dae babaꞌek Garasa, nai tasi Galelea selik. ");
INSERT INTO llg_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Nai ndia, hambu hataholi esa nitu nalak dook ia so. Uman taa, de kada ana leo nai late sala laladan. Tungga-tungga faik, ana laꞌok neu-mai, ma tao foli holi-holik. Huu nitu la palendan nakandondoo henin. Hataholi la henggen taa-taa lenik tali besi do liti besi so, tehuu ana tao naketu henin. Boe ma nitu la lambue lakasetin, fo nalai neni mamana nes neu. Ledoeik Yesus konda neme ofa baluk mai, boe ma hataholi kamuluk ndia, neni Ndia neu. Hataholi ndia nakadii-nakau, ma ana lololi neu Yesus ein. Basa de Ana palendan nae, “Heh, nitu! Kalua muma hataholi ndia mai!” Boe ma hataholi kamuluk ndia nakau, nae, “Wei! Boso babalik au! Huu au bubuluk O ia, na, Yesus, fo Manetualain manai lain seli Anan! O boso tao doidoso au!” ");
INSERT INTO llg_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesus natanen nae, “O nadem see?” Boe ma nitu ndia nataa nae, “Legion, huu ai noꞌuk, leo soldadu lifu-lifuk.” Ana nae leo ndia, huu hambu nitu mana maso fo leo lai ndia aon dale, noꞌuk. ");
INSERT INTO llg_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Nitu la sila lambue loke lakandondoo heni Yesus, fo boso nadenu sala leni Bolo Doidosok leu, fo ndia mamana kena koasa manggalau kala. ");
INSERT INTO llg_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Tehuu deka-deka nai ndia, hambu bafi bubuak inahuuk esa, ala totofi dae, fo sangga nanaꞌak lai letek ndia bifin. Boe ma nitu la loke Yesus, lae, “Kada madenu ai maso mini bafi la sila dalek miu!” Boe ma Ana nakaheik. ");
INSERT INTO llg_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Basa boe ma, nitu la kalua laꞌo ela touk ndia, de maso leni bafi la sila dalek leu. Basa bafi la sila dadik lamulu, de ala lalai lapoka kala konda leme letek ndia mai, de tuda leni tasi dale leu. Boe ma basa sala bolo mate. ");
INSERT INTO llg_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Lita leo ndia, boe ma mana manea bafi la, lalai ndule nggolo kala malai ndia, de ala tui basa mana dadi kala sila. ");
INSERT INTO llg_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Lamanene tutuik leo ndia, boe ma hataholi noꞌu kala kalua leni mamanak ndia leu. Ala nau lita aon, hata mana dadik nai ndia so. Losa ndia, boe ma lita hataholi nitu nalak ndia, nanggatuuk ndoo-ndoo dekak no Yesus ein. Ana pake baloꞌas so, ma mulun mopon so. Lita leo ndia, boe ma basa sala bii. ");
INSERT INTO llg_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Basa de hataholi la, fo mana nita dedeꞌak ndia, lafada hataholi la dei fo mana mai kala sila, talobee de hataholi kamuluk ndia hai so. ");
INSERT INTO llg_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Boe ma basa hataholi Garasa la mana leo lai dae babaꞌek sila, loke Yesus fo Ana laꞌo ela sala, huu basa sala bii lalan seli. Boe ma Yesus asa leu hene leni ofa baluk dale leu, fo sangga fali leni tasi Galelea selik leu. ");
INSERT INTO llg_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Tehuu hataholi fo isinaak nitu nalak ndia, nambue kokoe Yesus, nae, “Ama aa! Mboꞌi au tungga Ama boe!” Tehuu Yesus bala nae, ");
INSERT INTO llg_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Kada leo iak! Malolenak o fali muni o bobonggi mala nggolon muu, fo tui sala laꞌeneu Manetualain malolen, de Ana tao nahai o so.” Basa boe ma, hataholi ndia laꞌo ndule kota ndia, de ana tui neu basa hataholi la, laꞌeneu Yesus tao nahain. ");
INSERT INTO llg_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Basa boe ma Yesus asa saꞌe ofa baluk fali leni tasi Galelea selik leu. Ledoeik ala konda leme ofa baluk ndia mai, naa te hataholi noꞌu kala lahani Ndia taa-taa so. Ala lakalilimbu lalan, fo sangga soluk Ndia. ");
INSERT INTO llg_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Nai ndia boe, hataholi esa, nade Yairus. Ndia ndia, malangga uma huhule-haladoik nai kota ndia. Ndia anan, kada kisak; ana inanak, teun teuk sanahulu dua. Hatematak ia, inanak ndia, namahedi belak, de elabaꞌik maten. Ledoeik Yairus nita Yesus mamain, boe ma ana sendek lunggulanggan neu Yesus matan. Ana noke Yesus neni uman neu, fo tulun ndia ana inanan. Ledoeik Yesus nataa nae hei, boe ma ala laꞌo leni Yairus uman leu. Tehuu hataholi noꞌu kala lasuu tungga boe. Huu ndia de ala laꞌok lakaseseti. ");
INSERT INTO llg_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Inak esa laꞌok tungga sala boe. Ana hambu bulak taa no hahaen, teuk sanahulu dua ia so. Ana nabasa doin ma hata nala, fo bae neu dotel asa. Tehuu taa hambu esa bisa tao nahain. Ndia hedin ndia, nambue foe nakandondoo henin. ");
INSERT INTO llg_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Boe ma ana neu deka-deka no Yesus dean. Basa de ana daba laꞌe Yesus badu mbedan. Ledoeik ana daba basa, boe ma ndia daa mana faan ana mada tutik. ");
INSERT INTO llg_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Nggengge neuk Yesus nambadeik, boe ma natane, nae, “See daba laꞌe Au?” Tehuu taa hambu hataholi esa manaku boe. Boe ma Petrus nae, “Lamatuak boe oo! Huu hataholi noꞌu kala lakaseseti leo iak! Ala lambue latumbuk leme dea mai.” ");
INSERT INTO llg_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Tehuu Yesus nafadan nae, “Taa! Isinaak Au ameda koasa kalua neme Au mai. De, Au bubuluk hataholi esa daba laꞌe Au so.” ");
INSERT INTO llg_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ledoeik inak ndia nameda ndia taa bisa kekek, de ana bii nalan seli. Ana dele, de ana sendek lunggulanggan neu Yesus. Boe ma ana tui ndia dedeꞌan huu-okan, neu basa hataholi noꞌu kala matan. Basa de ana nafada nae, nandaa no au daba Yesus, boe ma au hai tutik. ");
INSERT INTO llg_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Boe ma Yesus nafada ndia, nae, “Kaꞌa! O hai ndia so, na, huu o mamahele Au. Fali mua mole leo!” ");
INSERT INTO llg_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ledoeik Yesus bei kola-kola no inak ndia, tehuu Yairus hataholin esa mai nafadan, nae, “Awii, Ama aa! Ama anan taa kana so! Ana mate so, de boso tao nasambutek neu Ama Mesen bali.” ");
INSERT INTO llg_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Tehuu ledoeik Yesus namanene hataholi ndia nafafadan, boe ma Ana nafada Yairus nae, “Kaꞌa! Kada nenee! Boso bii! Kada mamahele neu Manetualain. Ndia ndia tao nasoda kaꞌa anan.” ");
INSERT INTO llg_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","53","Ledoeik ala losa Yairus uman, naa te hataholi la henuk lai ndia so. Ala lamatani lakaleleu. Boe ma Yesus kaꞌi sala, nae, “Ei hahae mamatani leo! Huu kakanak ia taa maten. Kada ana sunggu ndia! Tehuu hataholi la kada ala hika kolombimbiin, huu sila ndia lita matan kakanak ndia ketu ani hahaen so. Boe ma Yesus noke nala inanak ndia ina-man, Petrus, Yohanis, ma Yakobis, fo ala maso dalek leu noꞌu lo Ndia. Feꞌe kala Ana nadenu sala lahani lai kada deak. ");
INSERT INTO llg_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ala maso, boe ma Yesus toꞌu nala inanak ndia liman, ma noke nae, “Ina aa! Foꞌa leo!” ");
INSERT INTO llg_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Kada nggengge neuk, kakanak ndia nasoda fali, de ana foꞌa tutik. Basa boe ma Yesus nadenu inanak ndia inan, nae, “Fee kakanak ia naꞌa dei!” ");
INSERT INTO llg_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Inanak ndia ina-man bafa nala bemboo. Tehuu Yesus fee nasaneneda kasa, fo suek boso ala tui-bengga dedeꞌak ia neu hataholi la. ");
INSERT INTO llg_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Laꞌi esa, Yesus nakabubua nala Ndia ana mana tungga nala hataholi sanahulu dua. Basa de Ana fee sala koasa, fo suek ala husi nitu, ma bisa tao lahai hataholi kamahedik leme sila hedin mata-mata kala mai. ");
INSERT INTO llg_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ana nadenu sala, fo ala laꞌo leu tui-bengga hataholi la, laꞌeneu Manetualain totoꞌu palendan. Ndia boe oo, nadenu sala, fo ala tao lahai hataholi kamahedi kala, sudi lai bee. ");
INSERT INTO llg_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Tehuu nafada sala, nae, “Masanenedak matalolole! Ei taa bole mini hata-hata nai dalak. Laꞌok mia kada badu manai ei ao mala. Boso mini teteꞌe-aik, do tas, do lepa-nggee, ma doik. Badu seluaok boe oo, taa bole minin! ");
INSERT INTO llg_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Mete ma ei maso mini nggolok esa dalek miu, fo hambu hataholi simbok ei, na, leo nai sila uman leo. Boso hehele uma. Leo makandoo nai ndia, losa ei laꞌo ela nggolok ndia. ");
INSERT INTO llg_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Leo ei maso mini nggolok esa miu, naa te hataholi malai ndia kala, taa nau simbok, ma taa nau lamanene ei, na, laꞌo ela sala. Mete ma ei kalua mima ndia mai, na, tao tungga hadak, fo sasambu heni afu neme ei ei mala mai. Mafada sala mae, ‘Ei taa nau mamanene, na, ela ei lemba aom ei natataan ia.’ ");
INSERT INTO llg_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Basa de, ana mana tungga nala sila laꞌo leme nggolok esa mai, leni nggolok esa leu. Ala tui-bengga hataholi la, laꞌeneu Manetualain Hala Malolen. Basa de sila boe oo, tao lahai hataholi kamahedi kala. ");
INSERT INTO llg_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Faik ndia, tutui mata-mata kala laꞌeneu Yesus, losa mane Herodes Antipas ndiꞌidoon so. Namanene tutui kala sila, boe ma ana nasapangga, huu hataholi hida lae, “Yesus ndia, na, ndia Yohanis Mana Salanik fo nasoda fali so.” ");
INSERT INTO llg_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Luma bali, lae, “Ndia ndia, baꞌi Elia fo nasoda fali so.” Feꞌe kala bali lae, “Ndia ndia, esa neme Lamatuak mana kokola lele ulu feꞌen.” ");
INSERT INTO llg_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Tehuu Herodes nasaneda, nae, “Fain, fo au adenu tete ketu heni Yohanis langgan. De, Ana nasoda fali so, do leobee?” Boe ma ana nasusua fo sangga natonggo mata-matan no Yesus. ");
INSERT INTO llg_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Faik esa, Yesus ana mana tungga nala fo Yesus nadenu sala sila, ala fali de lakabubua seluk bali lo Ndia. Ala tui Ndia, basa hata fo ala taon so. Boe ma Yesus asa laꞌo neneek leni mamanak esa leu, dekak no nggolo Betsaida, fo leu hahae ao nala lai ndia. ");
INSERT INTO llg_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Tehuu hataholi noꞌu kala hae laꞌe Yesus asa sangga bee leu, de ala latungga dea lo Ndia. De, Yesus simbo kasa no malole, boe ma Ana tao nahai basa hataholi kamahedi kala, ma Ana tui sala laꞌeneu Manetualain totoꞌu palendan. ");
INSERT INTO llg_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ledoeik bobok so, boe ma Ndia ana mana tungga kasanahulu dua nala, lafada sila duduꞌa nala neu Yesus lae, “Malolenak Ama madenu hataholi la ia, leni nggolo-nggolo mana dekak lai ia, fo bisa leu sangga sila naꞌa-ninu heheli nala. Ma ela ala leu sangga mamanak fo sunggu tataak. Huu mamana nes leo iak, na, neme bee mai fo ala bisa laꞌa?” ");
INSERT INTO llg_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","14","Tehuu Yesus nataa nae, “Leo iak! Ela ei fee sala laꞌa!” Tehuu ala sapa, lae, “Awii, Ama bali! Neme bee mai bisa leo ndiak? Hataholi la ia, lifun lima lenak! Ndia bei kada tou kala, fo bei ta hingga ina kala ma kakana kala bali! Boe ma ita lotin kada limak, ma iꞌak kada boak duak. Mete ma Ama nau, fo ai ndia fee hataholi noꞌu kala ia laꞌa, na, bisa hasa nanaꞌak makadotok talobee fo fee sala?!” Boe ma Yesus nadenu sala, nae, “Heti hataholi la ia, langgatuk lakabubua lima hulu-lima huluk, bubuak esa.” ");
INSERT INTO llg_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Basa de ala heti leo ndiak. ");
INSERT INTO llg_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ledoeik ala langgatuuk so, boe ma Yesus haꞌi nala loti kalima kala ma iꞌa kadua kala. Boe ma nasale lalai neu, de Ana hule-haladoi noke makasi. Basa de Ana bibiꞌi loti la sila, ma iꞌa kala, de Ana loon neu ana mana tungga nala, fo ala babaꞌe fee hataholi la sila. ");
INSERT INTO llg_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Basa sala laꞌa, losa lakabete. Basa de ala huhulu-hehele lala nanaꞌa ela kala henu lembeneu sanahulu dua. ");
INSERT INTO llg_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Laꞌi esa, Yesus mesa kana de Ana hule-haladoi nai mamanak esa. Basa de Ndia ana mana tungga nala lakabubua lo Ndia. Hule-haladoi nateꞌe, boe ma Ana natane sala, nae, “Ei mamanene hataholi la kokolak, lae, Au ia, see?” ");
INSERT INTO llg_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ala lataa, lae, “Hambu luma lae, Ama ia, Yohanis Mana Salanik. Feꞌe kala bali, lae, fama Ama ia, baꞌi Elia. Mete ma taa, na, esa neme Manetualain mana kokola makahulun fo nasoda fali.” ");
INSERT INTO llg_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Boe ma Yesus natane bali, nae, “Mete ma tungga ei mesa nggei, na, ei mae Au ia see?” Basa boe ma Petrus nataa, nae, “Ama ia Karistus, na, ndia Hataholi fo Manetualain tudu mema kana so, neme makahulun mai.” ");
INSERT INTO llg_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Basa de Yesus kaꞌi sala, fo boso lafada sudi see, lae, Ndia ndia, Karistus. ");
INSERT INTO llg_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Basa boe ma, Yesus kokolak nakadaik bali, nae, “Au ia Hataholi Isi-isik. Au musi lemba doidosok belak mata-mata kala. Dei fo hataholi Yahudi la lasi-lasi hada nala, malangga anggama la malangga inahuu nala, ma mese anggama la taa nau simbok, lae, Au ia, Karistus. Basa de dei fo ala tao lisa Au. Memak Au mate, tehuu neu binesan, Au asoda fali!” ");
INSERT INTO llg_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Basa de, Ana nafada hataholi noꞌu kala, nae, “Hataholi fo ana nau tungga Au, na, ana musi nakatataka tungga nakandoo tungga-tungga faik. Ana musi mboꞌi heni ndia hihii-nanau hehelin. Ana musi tungga nakandoo, mae hataholi ana sangga tao nisan, sama leo hataholi lemba ndia ai ngganggen, fo neni ndia mamana mamaten neu. ");
INSERT INTO llg_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Huu hataholi fo sadia mate, huu ana tungga Au, na, dei fo ana hambu sodak nakandoo no Lamatuak. Tehuu hataholi fo kada ana nau nasoda soaneu ndia aoina hehelin, dei fo ana naelak dook neme Manetualain mai. ");
INSERT INTO llg_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Mete ma hataholi hambu daebafok no basa isin, tehuu Manetualain timba henin, na, ndia hambu nanala hatak? ");
INSERT INTO llg_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Au ia Hataholi Isi-isik. De, mete ma hataholi fo ana mae tungga Au, ma ana mae toꞌu Au nanonoling, na Au boe oo, dei fo Au mae manaku ndia nai Manetualain matan, neu faik, fo Au fali uma nusa-sodak mai. Huu dei fo Au konda mai, ua Amak koasan fo ana seli ndia, sama-sama ua Ndia ata nusa-soda nala. ");
INSERT INTO llg_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Au afada no ndoos neu ei. Hambu hida leme ei manai ia kala, dei fo ala lita ao nala, Lamatuak totoꞌu palendan, bei fo ala bisa mate.” ");
INSERT INTO llg_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Basa de neu fai kafalun, boe ma Yesus noke nala Petrus, Yohanis, ma Yakobis de leu ndaꞌe leni letek esa leu, fo sangga hule-haladoi. ");
INSERT INTO llg_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ledoeik Yesus bei hule-haladoi, boe ma Ndia mata-aon namata feꞌe, ma Ndia baloꞌa papaken dadik fula manggahadok. ");
INSERT INTO llg_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Kada nggengge neuk, hataholi dua sadu mai. Sila dua sala ndia, na ndia baꞌi Musa ma baꞌi Elia. Boe ma ala bekola lo Yesus. ");
INSERT INTO llg_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Sila nana nitak nalan seli. Telu sala lakokola laꞌeneu Yesus mamaten, fo dei fo nai Yerusalem. ");
INSERT INTO llg_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Faik ndia, Petrus no nonoon dua sala mata nala nduak nalan seli, losa ala sunggu. Ledoeik ala foꞌa, boe ma lita Yesus nambadeik no hataholi dua. Sila boe oo, lita Yesus nasaꞌa manggaledok. ");
INSERT INTO llg_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ledoeik baꞌi Musa ma baꞌi Elia sangga laꞌo, boe ma Petrus nasapanga, de, taa bubuluk sangga tao hata. Boe ma kada ana kokolak nadabak, nae, “Lamatuak aa! Ai mameda malole nai ia, maa! De, malolenak ai tao mala laak telu. Esa feen neu Lamatuak, esa feen neu baꞌi Musa ma esa bali na feen neu baꞌi Elia.” ");
INSERT INTO llg_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Tehuu ledoeik ana bei kokolak leo ndia, naa te koꞌas esa konda mai, de ana mboti nala sala. Boe ma Petrus asa ala bii. ");
INSERT INTO llg_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","De, ala lamanene halak neme koꞌas ndia dalek mai, nae, “Ia, Au Anang fo Au hele mema kana so! Ana kokolak, na, mamanene neulalau neu Ndia!” ");
INSERT INTO llg_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Kokolak nateꞌe, boe ma Petrus asa kada lita Yesus mesa kana. Sila telu sala ala seu bafa nala, de taa tui neu sudi see boe, hata fo lita kala sila. Doo-doo bei fo ala lambook bafa nala de ala tui neu hataholi feꞌe kala. ");
INSERT INTO llg_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Neu foꞌa mai, ledoeik Yesus no Petrus asa, konda leme letek ndia mai, naa te hataholi noꞌu kala mai latonggo lo Yesus. ");
INSERT INTO llg_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Boe ma, hataholi esa ana nanggoun nae, “Ama Mesen aa! Tulun mai mita au ana touana kisang dei! ");
INSERT INTO llg_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Huu nitu nambue toꞌu nalan, fo tao nalan nakau kaiboik, ma ana ndondokon losa fufude kala kalua leme bafan mai. Nitu ndia boe oo, nambue babalan, ma nambue babali kana nakandondoo henin. ");
INSERT INTO llg_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Au oke tulun Ama ana mana tungga nala so, fo ala husi kalua heni nitu ndia, tehuu taa lala sana!” ");
INSERT INTO llg_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesus nasapalak basa sala, nae, “Weih! Ei taa mamahele Lamatuak bisa tao nahai hataholi, do? Ei ia, memak hataholi taa nau masoda tungga dala ndoos! Au musi nggale loak neu ei, losa faik bee bali!?” Basa de Ana kokolak nasafali no tou maꞌanak ndia, nae, “Mua o anam neni ia mai leo!” ");
INSERT INTO llg_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ledoeik ala loo kakanak ndia neu Yesus, boe ma nitu ndia bala kakanak neu dae, ma ana ndoko nakamimina kana. Tehuu Yesus palenda nitu ndia, kalua laꞌo ela kakanak ndia, boe ma kakanak ndia hai tutik. Basa de Yesus fee kakanak ndia neu aman. ");
INSERT INTO llg_vpl VALUES ("LK9_43a","072_9_43a","LUK","9","43a","43a","Hataholi la mana lita Lamatuak koasan ana seli ndia, basa sala bafa nala heran lalan seli. ");
INSERT INTO llg_vpl VALUES ("LK9_43b","072_9_43b","LUK","9","43b","43b","Ledoeik, basa hataholi la bei kokolak laꞌeneu tanda hera nala, fo Yesus tao kala, Ana nafada Ndia ana mana tungga nala, nae, ");
INSERT INTO llg_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ei tanda neulalau Au kokolang ia! Taa dook so bali, huu hataholi sangga seꞌo heni Au, Hataholi Isi-isik ia. Basa na, ala fee Au uu hataholi dea kala.” ");
INSERT INTO llg_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Tehuu Ndia ana mana tungga nala lasapangga. Ala taa bubuluk ndia ndandaan. Sila boe oo, ala bii latane ndia ndandaan hata. ");
INSERT INTO llg_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Laꞌi esa, Yesus ana mana tungga nala mulai lasisimbo bafak, laꞌeneu see neme sila mai, fo dei fo ana dadik hataholi kaesan. ");
INSERT INTO llg_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Tehuu Yesus bubuluk hata fo lasisimbo bafak ndia. Boe ma, Ana noke nala kakana kadiꞌianak esa, de nambadedein neu Ndia boboan. ");
INSERT INTO llg_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Basa boe ma, Ana nafada sala, nae, “Mamanene neulalau! Hataholi fo tungga Au, fo ana ono-lau hataholi kadiꞌik sama leo kakanak ia, na, ndia ndandaan, nae hataholi ndia boe oo, ana ono-lau Au. Ma ndia boe oo, ana ono-lau Au Amang nai nusa-sodak fo mana nadenu Au uni daebafok ia mai. Hataholi noꞌu kala lahiik lakadadae kasa. Matak leo hataholi kasian, hataholi mana toꞌa-taak, hataholi taa malole, hataholi ua-nale kamuluk, ma hataholi kadiꞌi-taidae kala. Hataholi mana nahiik ono-lau hataholi mata leo ndiak, na, Manetualain tao ndia, nai lain seli. ");
INSERT INTO llg_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Basa de Yohanis nafada Yesus, nae, “Lamatuak! Laꞌi esa, ai mita hataholi esa husi kalua heni nitu no kada ana seseik Ama naden. De, ai kaꞌin fo boso ana seseik Ama naden, huu ita nonoon taa ndia.” ");
INSERT INTO llg_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Tehuu Yesus nataa, nae, “Bosok! Huu hataholi taa mana laban ita, na, ndia ndandaan, nae ita nonoo hehelin ndia.” ");
INSERT INTO llg_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yesus bubuluk, Ndia fai sosoꞌun neni nusa-sodak neu deka-deka so. Boe ma, Ana naketun fo neni Yerusalem neu. ");
INSERT INTO llg_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ana nadenu hataholi fo ala laꞌok lakahuluk leme sila mai, fo leu sadia nanaꞌa-nininuk. Boe ma ala maso leni nggolok esa nai nusa Samaria, fo sangga sadia mamana leo tataak. ");
INSERT INTO llg_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Tehuu hataholi Samaria la, sila taa nau simbok Yesus asa, huu Ndia nau neu nakaluku-nakatele Manetualain nai Yerusalem. ");
INSERT INTO llg_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ledoeik Yakobis no Yohanis lamanene hataholi Samaria la sila tatao-nonoꞌin, de ala kokoe Yesus, lae, “Lamatuak aa! Leobee na, mete ma ita toke Manetualain, fo haitua haꞌi neme lalai mai, fo hotu heni basa sala?” ");
INSERT INTO llg_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Tehuu Yesus nasale nala dua sala, de Ana kaꞌi sala, nae, “Boso duduꞌa leo ndiak.” ");
INSERT INTO llg_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Boe ma, ala laꞌok lakandoo leni nggolo feꞌek leu. ");
INSERT INTO llg_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ledoeik ala belaꞌo, boe ma hataholi esa kokolak no Yesus, nae, “Ama! Ama neni sudi bee neu, na, au nau tungga akandoo ua Ama!” ");
INSERT INTO llg_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Tehuu Yesus nataa, nae, “Malole boe! Tehuu masaneda leo iak. Basa hataholi ma banda la laena mamana leleo hehelik. Busa fui fali neni ndia bolon neu. Mbuik fali neni ndia ndunun neu. Tehuu Au, Hataholi Isi-isik ia, uma heheling taa fo fali neni ndia neu. Lalaka langgak boe oo, taa.” ");
INSERT INTO llg_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Laꞌi esa, Yesus noke nala hataholi feꞌek esa, de nae, “Mai fo tungga Au, fo dadik neu Au hataholing.” Hataholi ndia nataa, nae, “Neu! Tehuu leo iak, Ama. Ela au fali fo au akaneni au ina-amang dei. Mete ma au amang maten so, na, bei fo au tungga.” ");
INSERT INTO llg_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Tehuu Yesus nafadan, nae, “Leo iak! Ela hataholi la taa mana lamahele Lamatuak, ala lakaneni sila hataholi mana maten. Tehuu ei fo mana mamahele Lamatuak, na, ei uem, miu tui-bengga laꞌeneu Manetualain totoꞌu palendan.” ");
INSERT INTO llg_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Hambu hataholi esa bali nae, “Malole boe, Lamatuak! Au nau tungga akandoo Ama. Tehuu makamboꞌik au uu idu ateteꞌak au bobonggi nggala dei, bei fo au fali mai tungga Ama.” ");
INSERT INTO llg_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Tehuu Yesus nafadan, nae, “Leo iak! Mete ma hataholi foi dae, boe ma nasambute no dedeꞌa feꞌek, losa ana nafalende heni sesele-ngganggalin, na, ndia osin taa dadi. Leo ndiak boe oo, no hataholi fo naketun nau tungga Au, tehuu nambue nasaneda nakandoo ndia soda makahulun. Hataholi mata leo ndiak, sosoan taa fo ana dadik Manetualain hataholi mana tao uen, nai Manetualain palendan.” ");
INSERT INTO llg_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Basa ndia, boe ma Yesus hele nala ana mana tungga feꞌe nala, hitu hulu dua. Boe ma Ana babaꞌe sala dua-duak, fo leu lakahuluk Ndia, leni mamana kala fo dei fo Ana sangga neni ndia neu. ");
INSERT INTO llg_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ana nadenu sala nae, “Hambu hataholi makadotok fo sama leo hade, kuni so. Ela kada maosik haitua ndia hataholi mana tao uen, fo kada ala mai ketu-kolu. De, ei musi hule-haladoi moke Manetualain haitua nakadaik Ndia hataholi mana tao uen, fo lakabubua lala hataholi la fo mana nau tungga Au. Huu, hataholi mana nau tungga Au sila noꞌuk, tehuu hataholi mana tao ue sala kada lumak. ");
INSERT INTO llg_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Hatematak ia ei laꞌo leo! Au adenu ei, fo mini hataholi noꞌu kala miu. Tehuu masaneda leo iak. Ei sama leo biꞌilombo ana dale malole, fo mini busa fui manggalau kala laladan miu. ");
INSERT INTO llg_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ei boso mini doik, do tas baloꞌas, do tabueis lenak nai dalak. Boso ngganggali heni fai no sosoa taak, ma mambue kokolak mia hataholi nai dalak. ");
INSERT INTO llg_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","8","Mete ma ei maso mini nggolok esa dalek miu, na boso ei lali-lali mima uma esa mini uma feꞌek miu. Leo hataholi la simbok ei no malole, nai uma esa, na, leo tataak kada ndia leo, losa ei laꞌo ela nggolok ndia. Mete ma ei mini uma esa miu, ei musi moke Manetualain, fo fee babaꞌe-babatik neu hataholi la malai uma ndia. Mete ma maumak nai ndia, simbok ei no malole, na, neu ko Lamatuak natudu Ndia dale malolen neu uma isi la. Tehuu leo ala taa nau simbok ei, na, ela Lamatuak natudu Ndia dale malolen neu kada ei mesa nggei. Mete ma ei maso mini uma esa miu, do nggolok esa, de, ei miꞌa-minu sudi hata fo ala fee. Na, simbo kana no dale namahokok, huu nandaa mete ma ala fee ei leo ndiak fo nggati ei sosotam. ");
INSERT INTO llg_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Tao mahai sila hataholi kamahedi nala. Ma mafada sala, mae, ‘Manetualain palendan nai ita matan so!’ ");
INSERT INTO llg_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Tehuu hambu nggolok boe, fo hataholi nala taa nau simbok ei. Mete ma ala tao leo ndiak neu ei, na, miu mambadeik miu nggolok ndia dalan, fo ama kokolak, mae, ");
INSERT INTO llg_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Mamanene neulalau! Ai mai mini Lamatuak Dedeꞌa-kokolan fee ei so, tehuu ei taa mbali sala fa boe. De, hatematak ia, ai sasambu heni nggolok ia afun neme ai ei nala mai, fo ana dadik tanda, nae, dei fo ei lemba aom ndia nenenin! Tehuu masaneda neulalau! Manetualain palendan nai ita matan so!’ ");
INSERT INTO llg_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ei bubuluk kota Sodom manggalaun, hetu? Au afada ei baa! Dei fo nandaa no faik fo daebafok babasan, Lamatuak huku hataholi mana timba heni ei ndia, belan lena heni hataholi Sodom asa!” ");
INSERT INTO llg_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Yesus kokolak nakadaik bali, nae, “Mata neuk neu ei manai nggolo Korasin ma nggolo Betsaida! Soe laꞌe ei! Au tao tanda heran mata-mata kala neu ei mata deꞌe mala, tehuu ei taa nau mamahele Lamatuak. Naa te, ei ia, hataholi Yahudi fo ei manaku malelak Ndia. Tehuu leo tanda hera nala fo Au tao kala sila, nai ei nggolo mala, dadi leo nai Tirus ma kota Sidon, na neu ko doo basa ia, de hataholi la malai ndia kala hondak so, ma ala laꞌo ela sila sala nala so, de ala lasafali tungga Lamatuak. De neu ko sila boe oo, pake buas fafaluk, ma tao afu neu langgak, fo dadik neu tanda, nae, ala fale dale nala no sila sala-singgo nala. Naa te hataholi Tirus ma Sido nala ia, hataholi taa Yahudi la, fo ala manaku lalelak Manetualain. ");
INSERT INTO llg_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Tetebes! Ei mita leo! Dei fo mete ma Lamatuak naketu basa hataholi la dedeꞌa nala, na, hataholi Tirus ma hataholi Sido nala huhuku nala bei daꞌuanak lena heni ei huhuku mala. ");
INSERT INTO llg_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Mata neuk, neu hataholi nggolo Kapernaum! Ei boso duduꞌa, mae, dei fo Lamatuak soꞌu nala ei fo maso mini nusa-sodak miu. Taa! Dei fo Lamatuak mbia heni ei mini naraka dalek miu! ");
INSERT INTO llg_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Masaneda matalolole! Huu hataholi fo namanene ei, sama leo namanene Au. Ma hataholi fo taa nau namanene ei, na sama leo taa nau namanene Au. Nakalenak bali, hataholi la, fo taa nau namanene Au ndia, sama leo taa nau namanene Manetualain, fo mana nadenu Au uni daebafok ia mai so.” ");
INSERT INTO llg_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Faik fo hataholi nana nadenu kahitu hulu dua kala sila fali, de, dale nala lamahoko lalan seli. Boe ma, ala lafada Yesus, lae, “Awii! Ana seli maa! Ledoeik ai pake Lamatuak naden fo husi nitu la. Nitu la lamanene ai, de ala kalua tutik! Ana seli maa!” ");
INSERT INTO llg_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Boe ma Yesus nataa sala, nae, “Tetebes! Ledoeik ei tao leo ndiak, boe ma Au ita Manetualain mbia heni nitu no ndia malanggan leme lalai mai, sama leo manggahadok fo kalua kii-konak neme lalai mai. ");
INSERT INTO llg_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Masanenedak baa! Nitu la malanggan ndia, ita musun ndia. Ma ndia naena koasa boe! Tehuu Au fee ei koasa, fo suek ei tao matepa ndia koasan. Ma leo ei heta laꞌe mengge kalasok, do kulak, na, ei taa hambu hedis fa boe. Taa hambu esa ana tao soe neu ei. ");
INSERT INTO llg_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ei dale mala lamahoko, huu nitu la lamanene ei. Malole boe, tehuu kada dedeꞌa kadiꞌik ndia! Malolenak ei dale mala lamahoko, huu Lamatuak sulak nala ei nade mala so, fo dadik neu Ndia hataholi nusa-sodan.” ");
INSERT INTO llg_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Faik ndia, Lamatuak Dula Dale Malalaon, tao nala Yesus dalen namahoko. Boe ma Ana koa-kio Lamatuak, nae, “Ama! Ama mana dadi Malangga Inahuuk nai lalai ma daebafok. Au akahehenek makasi noꞌun seli, huu Ama kena dedeꞌa kala ia neu hataholi fo ana taok ndia malelak, ma mana koao kala. Tehuu Ama buka basa dedeꞌa kala ia neu kakana ana kala, ma hataholi dale kadiꞌi taidae kala. Tetebes, Ama! Huu ndia ndia, tao nala Ama dalen namahoko!” ");
INSERT INTO llg_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Basa de Yesus nafada hataholi noꞌu kala, nae, “Mamanene baa! Au Amang nai nusa-sodak fee basa koasa neu Au. Mana bubuluk no teteben fo nae, Au ia see, na kada Amak. Ma mana bubuluk no teteben, Amak see, na kada Ama Anan, fo ndia Au. Ma Au hele hataholi feꞌek, fo nafada sala, fo suek ala lalelak Ndia.” ");
INSERT INTO llg_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Basa de Yesus heok nasale Ndia ana mana tungga nala, de nafada heheli sala, nae, “Ei maua tetebes, huu ei mita Lamatuak koasan so. ");
INSERT INTO llg_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Mane kala ma basa mana kokola makahulun ele dokodoe sangga lita Lamatuak koasan fo ei mitan so, tehuu sila taa bisa. Sila boe oo, dokodoe sangga lamanene hata fo ei mamanenen so, tehuu sila taa bisa. ");
INSERT INTO llg_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Laꞌi esa, malela heti-heu Yahudi esa, nambadeik fo sangga teꞌek Yesus. Ana natane, nae, “Ama Mesen! Tulun mafada dei! Au musi tao hata, fo ela au bubuluk au bisa hambu sodak akandondoo henin ua Lamatuak nai nusa-sodak?” ");
INSERT INTO llg_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesus nataa, nae, “Baꞌi Musa sulak hata laꞌeneu dedeꞌak ia? O duduꞌam leobeek laꞌeneu ndia?” ");
INSERT INTO llg_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Hataholi ndia nafada, nae, “Ana sulak, nae: ‘O musi sue Manetualain, fo o Lamatuam, lena heni neme basa-basan mai. Huu ndia de, o musi dokodoe Ndia taa-taa, tao ues mbilu mbuse fo tungga Ndia hihii-nanaun, ma malelak neulalau Ndia.’ Boe ma nana sulak, nae, ‘O musi sue o tolanoom, sama leo o sue o aoina hehelim.’ ” ");
INSERT INTO llg_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesus bala nae, “Tetebes! Mete ma o tungga leo ndiak, na o masoda makandondoo henin mua Lamatuak.” ");
INSERT INTO llg_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Tehuu hataholi ndia sangga taok aon leo hataholi ndoos. Basa de natane Yesus, nae, “Tehuu au ‘tolanoong’ ndia, na ndia bee?” ");
INSERT INTO llg_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Boe ma Yesus nataa, nae, “Leo iak! Au sangga afada nakandandaak esa. Dei fo o mafada Au, see ndia tetebes o ‘tolanoom’. Tutuik ndia leo iak: Hambu hataholi Yahudi esa neme kota Yerusalem mai, de loe neni Yeriko neu. Tehuu kada nggengge neuk, naꞌo mana mamoa kala, mai de lambuen. Ala mbombokon, basa de ala lamoa lala doin, ma basa ndia baloꞌa papake nala. Boe ma ala mbia henin neni dalak bifin neu, de ala laꞌo elan. Hataholi ndia elabaꞌik maten so. ");
INSERT INTO llg_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Tehuu see bubuluk nae, huu malangga anggama Yahudi esa konda nesik ndia boe. Tehuu ledoeik nita hataholi makahinak ndia lengga-lengga neme dalak bifin, tehuu ana taa hahae fo tulu-fali hataholi ndia. Ana laꞌok heo nesik dalak selik de laꞌo nakandoo. ");
INSERT INTO llg_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Taa dook, boe ma hataholi feꞌek esa, laꞌok nesik ndia. Ndia ndia, hataholi Lewi fo nateme tulu-fali nai Manetualain Uma Ina Huhule-Haladoin. Ledoeik nita hataholi ndia lee-lee nai dalak bifin, boe ma kada neu deka-deka fo mete sudi kana, tehuu taa tulu-fali sana. De ana laꞌo nakandoo. ");
INSERT INTO llg_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","34","Taa dook bali, boe ma hataholi esa neme dae Samaria mai, nesik ndia no ndia banda keledein. Ita basa nggata bubuluk, hataholi Yahudi la lateme suli latahihiik hataholi Samaria la. Ledoeik hataholi Samaria ia nita hataholi nana namoak ndia, boe ma dalen tuda kasian neu hataholi ndia. Ana neu deka-deka fo sangga tulu-fali hataholi ndia. Ana diꞌa anggol oek de ana tao nalalao hina kala, basa de ana tao mina neun. Boe ma ana fefeo neulalaun, de ana nakahehene kana neni banda keledein lain neu. Basa de noon losa kota. Boe ma ana feen leo tataak, neu hataholi mauma sesebak esa, fo nakaneni neulalaun. ");
INSERT INTO llg_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Neu foꞌa fafain, boe ma hataholi Samaria ndia bae nakahuluk doi lilo fulak dua neu mauma sesebak ndia, ma nafadan, nae, ‘Pake doik ia, fo makaneni neulalau hataholi kamahedik ndia, losa ana hai. Mete ma taa dai, na, tulun pake tataak ama doin dei. Faik fo au fali maing, dei fo au nggati basa ama doin.’ ” ");
INSERT INTO llg_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yesus nakandandaan ndia, losa ndia leo. Basa de Ana natane malela heti-heuk ndia, nae, “Tungga o, na see ndia ‘tolanoo’ tetebes, neu hataholi nana namoak ndia?” ");
INSERT INTO llg_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Hataholi ndia nataa, nae, “Memak neu ko ndia hataholi mana tuda kasian neu hataholi ndia.” Yesus nae, “Tetebes kaꞌa! Muu leo, fo tao tunggan.” ");
INSERT INTO llg_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","40","Basa ndia, boe ma Yesus no ana mana tungga nala laꞌo lakandoo leni Yerusalem leu. De ala singgo nai nggolok esa. Nai ndia hambu hataholi dua kaꞌa-fadi kala, nade Marta ma Maria. Marta noke Yesus fo ala leo tataak nai ndia uman. Basa de ala leo tataak lai ndia. Ledoeik Yesus nanggatuuk fo nanoli hataholi la, boe ma Marta nasambute nakaneni nanaꞌak nai dapu dale. Tehuu ndia fadin Maria, nanggatuuk deka-deka neu Yesus ein, fo namanene Ndia kokolan. Taa dook boe ma, Marta maso mai, de ana manggalau neu Yesus, nae, “Ama aa! Talobee ia! Au asambute alan seli tao nanaꞌa-nininuk, naa te au fading kada nanggatuuk neulalau nai ia. Tulun dei! Madenun neu fali au nai dapu dale!” ");
INSERT INTO llg_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Tehuu Lamatuak Yesus nataa, nae, “Maꞌa, Maꞌa. O ia, masambute mua kada duduꞌa mata-mata kala. ");
INSERT INTO llg_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Malole boe, tehuu hambu dedeꞌak esa inahuun lena heni nai hatematak ia. Mia nanggatuuk fo namanene Au kokolang. Ana hele nala nelaun manai lain seli so. Hataholi taa bisa namoa nala Dedeꞌa-kokolak neme ndia mai. ");
INSERT INTO llg_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Laꞌi esa, Yesus neu hule-haladoi. Ana hule-haladoi nateꞌe, boe ma Ndia ana mana tungga esa mai, de noke, nae, “Lamatuak aa! Yohanis Mana Salanik nanoli ndia ana mana tungga nala, fo ala hule-haladoi lalelak. De, ai moke fo Lamatuak boe oo, manoli ai huhule-haladoik dei!” ");
INSERT INTO llg_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Basa de Yesus nae, “Malole boe! Hule-haladoi pake conto leo iak: ‘Ama! Ama naden malalao-malalafuk. Ela basa hataholi la, ala soꞌu dema-demak Ama naden fo ana seli ndia. Ela Ama dadik Manek neu basa hataholi la. ");
INSERT INTO llg_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ama tulun fee ai nanaꞌak mana daik tungga-tungga faik. ");
INSERT INTO llg_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ai moke Ama mafalende heni ai sala-singgo nala, sama leo ai boe oo, mafalende heni hataholi sala nala fo ala lambue taon neu ai. Ama manea fo ai taa tao manggalauk.” ");
INSERT INTO llg_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Basa boe ma Yesus nanoli nakadaik fee sala laꞌeneu huhule-haladoik. Ana pake nakandandaak, nae, “Leo fatilada neu dua, boe ma hambu ei nonoom esa neme dae dook mai, fo ana leo tataak nai o umam. Tehuu o taa maena hata-hata fo feen naꞌa. Basa de o muni o nonoo feꞌem esa uman muu, de o kokoen mbea-mbea neme uman deak mai, mae, ‘Kaꞌa ei! Fee tataak au loti balok telu dei! Huu au hambu hataholi mana maik nai uma, tehuu ai mada ndoos! Kaꞌa tulun dei! Kada balok telu! Dei fo au nggatin!’ ");
INSERT INTO llg_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Meda dei fo o nonoom ndia nataa nasafali, nae, ‘Kaꞌa boe oo! Hataholi ana sunggu namanee, tehuu kaꞌa mai babalik bali! Lelesu nana nggoe nisak, so! Kakana kala sunggu lamanee so. De boso mamanasa baa! Tehuu fai seluk dei, kaꞌa baa!’ ");
INSERT INTO llg_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Mae leo ndiak boe oo, tehuu masaneda neulalau. Mae hataholi ndia taa foꞌa fo fee o, huu o ia, ndia nonoon, tehuu mete ma o mambue kokoen makandondoo henin, na, neu ko ana foꞌa fo ana fee. ");
INSERT INTO llg_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Leo ndiak boe, no huhule-haladoik. Moke makandoo neu Lamatuak; dei fo Ana fee. Sangga makandoo; dei fo Ana natudu dalak. Manggou makandoo; dei fo Ana soi lelesu. ");
INSERT INTO llg_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Huu basa hataholi la fo mana loke lakandoo neu Manetualain, na dei fo ala simbo. Mana sangga lakandoo, dei fo ala hambu. Mana langgou lakandoo dei fo Ana soi lelesu. ");
INSERT INTO llg_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ei duduꞌa sudi kana! Hambu nai bee amak, fo mete ma anan noke iꞌak, na ana feen mengge? ");
INSERT INTO llg_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Do, mete ma anan noke manutolo, na, ana feen kulak? Taa dadi, hetu maa? ");
INSERT INTO llg_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Memak hataholi hada teteben, manggalauk. Tehuu ei Amam manai nusa-sodak ndia, hada teteben neulaun ana seli. De, mete ma hataholi fo manggalaun matak leo ei, fo mahiik fee bua malole neu ana mala, na, nakalenak Amak bali! Ndia taa kada Ana fee ei hata fo ei paluu, tehuu lenak neme ndia mai, Ana fee ei Ndia Dula Dale Malalaon neu hataholi fo noke neu Ndia.” ");
INSERT INTO llg_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Laꞌi esa, Yesus husi kalua heni nitu, neme hataholi hala taak esa mai. Basa de hataholi ndia kokolak nasafali. Hataholi malai ndia kala, heran lalan seli. ");
INSERT INTO llg_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Tehuu hambu luma boe ala lae, “Huu Ana hambu koasa neme nitu la malanggan mai, fo ndia Balsebul.” ");
INSERT INTO llg_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Hataholi feꞌe kala, sangga soba Yesus. Basa de, ala loke fo Ana tao tanda heran bali, fo natudu sala, nae, Ndia koasan ndia, memak neme Lamatuak mai. ");
INSERT INTO llg_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Tehuu Yesus bubuluk memak, sila langgaute manggenggeon ndia. Boe ma Ana kokolak, nae, “Mete ma nai nusak esa, lauinggu nala lamusuk, na neu ko nusak ndia nakalulutuk. Leo ndiak boe, mete ma nai uma esa, uma isi nala lambue lasoda latoka esa no esa, na uma-loo ndia taa dadadik so! ");
INSERT INTO llg_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","De, mete ma nitu la lambue lamusuk ma lambue lahusik esa no esa, na, sila malanggan taa bisa toꞌu palenda nala dook so bali! De, taa masok neu langgautek, mete ma ei mae, Au pake nitu koasan fo husi nasafali nitu mesa kana! ");
INSERT INTO llg_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Masanedak, baa! Ei hataholi mala boe, lalelak husi nitu. De ala pake koasa neme nitu mai, do? Taa hetu! De, ei boso kokolak madabak, mae, Au pake nitu koasan fo husi nitu. Dei fo ei hataholi mala laketun, lae, hata fo ei makasasaꞌek Au ndia, sala. ");
INSERT INTO llg_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Tehuu mete ma Au tebe-tebe husi nitu ndia, pake Manetualain koasan, na, ndia natudu, nae, Lamatuak palendan nai ei mata mala so. Nai ia so, tehuu nonook ei taa bubulu kana. ");
INSERT INTO llg_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Mete ma palani manggalauk esa, ana pake manala nai kii-konak, fo ana nanea neulalau ndia uman, na neu ko basa ndia baloꞌan lasoda. ");
INSERT INTO llg_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Tehuu, dei fo hambu esa balakain lena ndia, na ana tao senggin, de namoa nala basa hataholi ndia manala nala. Basa ndia, na ndia boe ana kao neni basa hataholi ndia hata-heto nala, de ana babaꞌe sala leu ndia ana mana tungga nala. Doo basa ia so, palani manggalauk kaesan ndia, namahele neu ndia manalan. Tehuu hatematak ia, ndia taa bisa namahena neu manala sila bali. ");
INSERT INTO llg_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Masaneda neulalau! Hataholi fo taa partei esa no Au, na, ndia ndia Au musung. Ma hataholi fo taa tulu-fali Au ue-leding, na, ndia ndia, kada ana tao naodek.” ");
INSERT INTO llg_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Yesus kokolak nakadaik bali, nae, “Mete ma ita husi nitu kalua neme hataholi esa mai, na, neni mamana nes neu, fo ana sangga mamana hahae aok. Huu taa hambu mamanak fo nandaa, boe ma ana duduꞌa, nae, “Heh! Taa hambu mamana leo iak, na, malolenak au fali uu leo seluk nai hataholi makahulun ndia.’ ");
INSERT INTO llg_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Basa de ana fali, boe ma nita mamanak ndia, malalaok ma nana heti neulauk. ");
INSERT INTO llg_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Boe ma nitu ndia neu noke nala ndia nonoon hitu, fo manggalaun ana lena ndia. Boe ma basa sala leu leo lai hataholi ndia, de lakamomotu lalan. De, hatematak ia, hataholi ndia soen lena bali.” ");
INSERT INTO llg_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ledoeik Yesus bei kola-kola no hataholi noꞌu kala sila, tehuu inak esa nai ndia nanggou, nae, “O inam naua-nanale nalan seli, huu ana bisa bonggi O, ma ana bisa nasusu O, bae!” ");
INSERT INTO llg_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yesus nataa, nae, “Tetebes, ina! Tehuu mana maua-manalek nalan seli, na, ndia hataholi mana pasa ndiꞌidoon, fo namanene Manetualain Dedeꞌa-kokolan, ma ana tao tunggan!” ");
INSERT INTO llg_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ledoeik, Yesus bei kola-kola, tehuu hataholi makadoto kala mai lakalilimbu eꞌo lala Ndia. Ana kokolak, nae, “Hataholi hatematak ia, lalelak kada tao tatao manggalauk. Ala lambue loke papasi Au, fo tao tanda heran fee sala, fo suek ala bubuluk Au ia tebe-tebe Lamatuak hataholin. Naa te makahulun Lamatuak fee sala tanda heran nenik Ndia mana kokolan Yunus. De, dai ndia so! ");
INSERT INTO llg_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Makahulun ele, Yunus nafada hataholi kota Niniwe, nae, ala musi hondak dei. Hata fo ana dadi neu Yunus nai makahulun ele so, de ana dadik tanda fee sala, nae, Manetualain ndia nadenu ndia. Leo ndiak boe neu Hataholi Isi-isik. Au mai afada ei, fo ei hondak dei. Ma hata fo dadi neu Au, dei fo dadik tanda neu hataholi hatematak ia, nae, memak Manetualain ndia Ana nadenu Au. ");
INSERT INTO llg_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Dei fo neu faik fo daebafok ia fai babasan, mete ma Lamatuak nambadeik dadik Mana Maketu, dei fo ina manek neme kona ele mai, nasoda fali, de nambadeik dadik neu sakasii. Ana tuduk liman, fo kalaak ei basa nggei fo bei kasoda kala hatematak ia, nae, ‘Ei basa nggei ia, nggoam ana seli, maa!’ Huu makahulun ina manek ndia neme dook ele mai, fo sangga nita no mata deꞌe hehelin, mane Soleman malelan. Naa te, hatematak ia, Hataholi esa nai ei lalada mala lena heni mane Soleman. Tehuu ei taa nau mbali Ndia fa boe! ");
INSERT INTO llg_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ma taa kada Ndia mesakana! Dei fo hataholi la mana mai kala leme Niniwe mai, foꞌa lambadeik, de ala dedeu ei fo bei kasodak hatematak ia, lae, ‘Ei basa nggei nggoak!’ Ala kokolak lae leo ndia, na huu fain, fo neu faik Yunus neu nafada Lamatuak hihiin neu sala, boe ma ala hondak tutik. Naa te hatematak ia, Hataholi fo Ana seli lena heni Yunus ndia, nai ei basa nggei lalada mala, tehuu ei taa nau hondak fa boe! ");
INSERT INTO llg_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Yesus tuti Ndia kokolan bali, nae, “Hataholi tao nambila bandu anak, boe ma ana taon neu mamana madema, fo suek tao manggaledo kama ndia, neu basa hataholi la, mana maso leni ndia leu. Taa hambu hataholi tao nambila banduk, boe ma ana tatanan nenik lembeneu, do ana nafuni nisa kana. Ndia sosoan taa fa boe! ");
INSERT INTO llg_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ei mata mala boe oo, sama leo banduk. Ana tao manggaledo ei dale mala. Mete ma mata makiuk, na hataholi suli basa-basan no dale manggalauk. Tehuu mete ma mata manggaledok, na hataholi suli basa-basan no dale malolen. ");
INSERT INTO llg_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Masusua, fo manggaledok manai ei dale mala ndia, manggaledon ana seli, sama leo ledo manggaledon. Manggaledok manai ei dale mala ndia, boso leo bulak manggaledon, fo kada ana fee ndia saꞌon. ");
INSERT INTO llg_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Mete ma ei dale mala manggaledok, losa taa hambu bolok esa makiuk boe, na, neu ko basa ei soda mala manggaledok boe leo banduk inahuuk, fo tao manggaledo ei soda mala.” ");
INSERT INTO llg_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesus kokolak nateꞌe, boe ma hataholi esa neme partei anggama Farisi noke Ndia, fo neu naꞌa nai ndia uman. Losa ele, boe ma Yesus maso neni uma dale neu, de Ana nanggatuuk dekak no mei nanaꞌak. ");
INSERT INTO llg_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Tehuu maumak heran nita Yesus nanggatuuk naꞌa tehuu taa safe liman nakahuluk, tungga hataholi Farisi la heti-heun. ");
INSERT INTO llg_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Basa boe ma Yesus nafadan, nae, “Ei hataholi Farisi la ana seli! Ei toꞌu mahele ei heti-heu anggamam! Ei masaneda safe malalao pinggak ma nggalas dean losa nanggadilak, tehuu ei taa masaneda tao malalao ei dale mala, fo manggenggeo ndoos, manggalauk, ma balenaꞌon ana seli! ");
INSERT INTO llg_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Nggoa kala aa! Boso mafalende henin. Manetualain tao nalalao babaꞌe manai deak. Ndia boe oo, tao nalalao babaꞌe manai dalek. ");
INSERT INTO llg_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Tehuu malolenak, ei fee hataholi kasia nala hata fo ei ena mala, suek ei bisa malalaok nai Lamatuak matan. ");
INSERT INTO llg_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ei hataholi Farisi la! Dei fo ei hambu soe! Dedeꞌak fo fee Lamatuak babaꞌek esa neme babaꞌek sanahulu mai, na, ei mambue mahinggak lutu-lutuk, inahuu-kadiꞌik losa ei bumbu-fani kadiꞌi anam neme osi dale mai boe oo, ei mahinggak malan seli! Tehuu ei taa mbali dedeꞌa panting nala. Ei boe oo mafalende heni laꞌeneu sue Manetualain ma dedeꞌak fo taa no ndoos. Memak ita musi fee tahele Lamatuak babaꞌen, ma boso mafalende heni dedeꞌak fo panting lena. ");
INSERT INTO llg_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Neu ko ei hambu soe! Huu ei mateme sangga mamana neulauk nalan seli nai uma huhule-haladoik, ma mahiik sangga hada-holomata nai mamanak hataholi noꞌuk. ");
INSERT INTO llg_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Neu ko ei hambu soe! Huu ei sama leo lates, fo daen ndefa de bebelak no dae. Hataholi laꞌok nesik ndia tehuu taa bubuluk lates nai ndia, huu ndefa heni lates daen manai lain, de bebelak no dae, ma dalek kabook. Naa te, tungga ita hadan, na, hataholi mana heta laꞌe lates, na, ana tao nanggenggeo aon, de ta nandaa maso neni uma huhule-haladoik dalek neu. Ei hataholi Farisi la sama leo lates! Nai deak na ei matutudu mala nonook leo malalaon ana seli. Tehuu ei dale mala, na henuk no dedeꞌa kabook.” ");
INSERT INTO llg_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Hambu hataholi malela heti-heu Yahudi esa nai ndia, ndaso nala Yesus kokolan, de nae, “Ama Mesen! Ama kokolan isinaak ndia, ana femba laꞌe ai boe!” ");
INSERT INTO llg_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Basa boe ma Yesus bala, nae, “Tetebes! Ei malela heti-heuk Yahudi la, ela ei hambu soe boe! Ei taa tao mamadaꞌu hataholi la sodan, tehuu ei boe tao makatotoꞌa kasa bali, fo tao ei heti-heu anggama mala mabela ndia. De, ei makalelembak hataholi minik ei heti-heu mala mata-mata kala. Tehuu ei mesa nggei taa tulun lemba sudik belak ndia fa boe! ");
INSERT INTO llg_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Neu ko ei ia hambu soe! Huu ei kada masambute mambadedei batu-batu lutu fo fee hadak neu Lamatuak mana kokola makahulun ele. Naa te, ei bei-bai mala sila ndia, tao lisa mana kokola la sila! ");
INSERT INTO llg_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ei boe oo, ei hada-tatao mala leoesak mia ei bei-baꞌi mala sila. Ala timba heni Lamatuak mana kokola nala, ma ala tao lisa sala. Basa na, ei mambadedei lutu batu lates fee mana kokola la sila, fo dadik tanda, nae, ei boe oo, makaheik no malole, neu ei bei-bai mala tatao nala sila. ");
INSERT INTO llg_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Huu ndia de, Manetualain bubuluk basan so, de Ana kokolak nitak, nae, ‘Dei fo Au adenu Au mana kokola nggala ma hataholi nana dedenu feꞌe nggala, leni hataholi la leu. Basa de, hataholi la sila, tao doidoso lakamiminak luma, ma tao lisa luma.’ ");
INSERT INTO llg_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Hataholi fo kasodak hatematak ia, musi lemba natataak neme hataholi la, fo mana tao lisa Lamatuak mana kokola nala. Na, hinggan neme Lamatuak nakadadadik daebafok ia, fo, mulai neme Habel mamaten mai, losa mateꞌen ndia Zakarias. Ndia boe oo, nana tao nisak neme mei tunu-hotuk laladan ma Kama Malalaok nai Manetualain Uma Ina huhule-Haladoin. Ei boe oo, lemba mala sila huhukun ndia! ");
INSERT INTO llg_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ei malela heti-heu Yahudi la! Neu ko ei hambu soe! Huu ei ndia toꞌu nggoek fo bisa soi lelesu, fo hataholi la bubuluk neulalau Manetualain hihii-nanaun. Tehuu ei mesa nggei taa maso mini ndia miu. Manggalaun ana seli bali, na, ei matabaa mala hataholi la, fo boso maso leni ndia leu!” ");
INSERT INTO llg_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Ledoeik, Yesus kokolak nateꞌe, boe ma mese anggama la, ma hataholi Farisi la, manggalau lo Ndia. Mulai neme faik ndia mai, ala lambue latane mata-mata kala, fo sangga ika latuda Ndia. Ala heti kekedik nakandondoo henin fo sangga dedeꞌak lo Ndia. ");
INSERT INTO llg_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Faik ndia, hambu hataholi lifun hida mai, fo sangga lamanene Yesus. Ala laꞌok lakaseseti ma ala lakalilimbu lala Ndia. Boe ma Ana kokolak nakahuluk no Ndia ana mana tungga nala, nae, “Manea matalolole, fo boso ei tungga hataholi Farisi mana taok malalaok. Ala lateme kokolak feꞌek tehuu tao feꞌek. ");
INSERT INTO llg_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ala taok sila neulauk, tehuu sila tataon ndia, dei fo nana nitak. ");
INSERT INTO llg_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Hata fo ei kokolak mafufunik hatematak ia, dei fo hataholi la lamanenen no manggaledok. Hata fo ei makukutu kana nai kama dale, dei fo hataholi la kokola kana latinggan neu hataholi noꞌu kala matan.” ");
INSERT INTO llg_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Yesus kokolak nakadaik, nae, “Ana nggalei! Boso bii, mete ma hataholi la, sangga tao lisa ei. Huu kada ala bisa tao lisa ei ao mala, tehuu taa bisa tao hata-hata neu ei samane mala. ");
INSERT INTO llg_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Au sangga afada, ae, ei musi bii see. Ei musi bii Manetualain. Huu Ndia ndia, bisa tao nisa ei, fo basa ndia, na, Ana mbia heni ei mini bolo naraka dalek miu. De, ei musi bii tebe-tebe Ndia. ");
INSERT INTO llg_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ei duduꞌa sudi kana, mbui hadek belin hida? Belin daꞌuk nalan seli hetu?! Mbuik lima na doik sen dua, hetu? Mae leo ndiak boe oo, tehuu Manetualain taa nafalende heni mbuik esa boe. ");
INSERT INTO llg_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Leo ndiak boe oo, Lamatuak tao dalek neu ei. Ana bubuluk no teteben langga-buluk hida lai ei langga mala. De, ei boso bii, huu Manetualain timba-tai ei beli mala de lena heni mbui hadek makadotok.” ");
INSERT INTO llg_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Basa de, Yesus kokolak bali no Ndia ana mana tungga nala, nae, “Pasa neulalau ndiꞌidook! Mete ma hambu hataholi nambalani manaku Au nai hataholi noꞌuk matan nai daebafok ia, na, neu ko Au boe oo, manakun nai Manetualain ata nala malai nusa-sodak mata nala, ae, ndia ndia, Au hataholing. ");
INSERT INTO llg_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Tehuu mete ma hambu hataholi kokolak nai hataholi matan, nae, ndia taa nalelak Au, na, neu ko Au kokolak neu Manetualain ata nala malai nusa-sodak mata nala, ae, Au taa alelak ndia. ");
INSERT INTO llg_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Au ia Hataholi Isi-isik. Mete ma hambu hataholi kokolak naboboo Au nade maloleng, na, Manetualain bei sadia nafalende heni hataholi ndia salan. Tehuu mete ma ana kokolak tao nabooo Dula Dale Malalaok nade malolen, na, Manetualain taa nafalende heni ndia salan. ");
INSERT INTO llg_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Dei fo mete ma hataholi hela no ei mini mamana tao dedeꞌak anggama miu, do, mini hataholi mana toꞌu palenda la miu, huu ei mamahele Au, na, ei boso bii, masalaꞌe aok leobee. ");
INSERT INTO llg_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Huu dei fo faik ndia boe oo, Manetualain Dula Dale Malalaon nanoli dedeꞌa deꞌek mandaan, fo ei mataa sala.” ");
INSERT INTO llg_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Basa ndia, boe ma hataholi esa neme hataholi noꞌu kala mai natane Yesus nae, “Ama Mesen aa! Tulun madenu au kaꞌang, fo nabaꞌe no au, ai aman pusakan.” ");
INSERT INTO llg_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Tehuu Yesus nataan, nae, “Wei! See soꞌu nala Au, dadik Mana Maketu fo aketu ei dua nggei, dedeꞌa mata leo ndiak?” ");
INSERT INTO llg_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Basa boe ma Yesus kokolak neu hataholi noꞌu kala, nae, “Ei musi mata neuk, fo boso masanggenggeu. Huu hata noꞌu kala ia, taa bisa tanggon nasoda no mole-dame.” ");
INSERT INTO llg_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Basa boe ma, Ana tui tutuik nakandandaak esa, nae, “Hambu hataholi kamasuꞌik esa osin buna-boan makadotok. ");
INSERT INTO llg_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Losak ndia kama mbembeda nanaꞌa nala lakaseꞌe, de taa bubuluk sangga tao sala leobee so bali. ");
INSERT INTO llg_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Basa de ana naketun nae, “Au sangga tao leo iak leo! Au sangga ofe heni kama bembeda nanaꞌa laa kala, fo au ambadedei kama mbembeda nanaꞌa inahuuk esa, fo mbeda au osing buna-boan, ma basa hata-heto feꞌe kala leu ndia. ");
INSERT INTO llg_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Mete ma leo ndiak so, na, dei fo Au kokolak ua Au ao heheling, ae, ‘Wei! Mamana mbembeda nanaꞌak henuk so! Nanaꞌak dai so, fo naꞌa losa teu-teu kala. De, muꞌa-minu malada-malada ma pepedo eik no namahokok leo! ");
INSERT INTO llg_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Tehuu Manetualain nafadan, nae, ‘Weih! O nggoam, dei! Leꞌodaen ia boe oo, o mate. Basa na, see ndia hambu basa o kama mbembeda nanaꞌam no basa isi nala sila, bae? ");
INSERT INTO llg_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","De, leo iak! Hataholi kada ana bisa nakaduduluk hata-heto makadotok nai daebafok ia, fo feen neu ndia aoina hehelin, tehuu nai Manetualain duduꞌan, na, ndia ndia hata taak, huu ana taa mole no Lamatuak.” ");
INSERT INTO llg_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Basa de Yesus nanoli nakadaik Ndia ana mana tungga nala, nae, “Boso tao nasambutek mia ei soda mala basa fain, laꞌeneu sangga naꞌa hata, do pake hata. ");
INSERT INTO llg_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Huu ita sodan ia, lena heni hata fo ita taꞌa, ma hata fo ita pake. ");
INSERT INTO llg_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Mete sudik mbui kaa nggeo kala! Ala taa sele-nggali, taa ketu-kolu, taa laena kama mbembeda nanaꞌak, tehuu Manetualain nakaboi sala. Mete ma leo ndiak, na, neu ko Ndia boe oo, bisa nakaboi ei. Huu Ana timba-tai ei belim lena heni mbui kala. ");
INSERT INTO llg_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Mete ma hataholi nambadeik neu titilok matan, basa na, nasambute no ndia aoina hehelin, na, meda ana bisa tao namanalu ndia sodan do? Taa bisa! ");
INSERT INTO llg_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","De, mete ma ana nasambute no kada dedeꞌa kadiꞌik leo ndiak, na, taa neni buna-boak hata-hata, boe ma hatina de ana bei nau nasambute bali no dedeꞌa inahuuk? Ndia nanalan hata? ");
INSERT INTO llg_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Mete sudik bungga nula. Ala taa tao osi-lutu, ma taa tenu sidi. Tehuu mane Soleman baloꞌa papaken neulaun ana seli boe oo, taa bisa laban bungga nula lolen. ");
INSERT INTO llg_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Te Manetualain nakaboi naꞌu ana, fo sosoan taa, fo nasoda faik ia, na, foꞌa mai na, maten, fo hataholi la mbian neni haꞌi dale neu. Mete ma leo ndiak, na, Ndia boe oo, bisa nakaboi ei fo belim lena heni naꞌu. De, hatina de ei taa masalai tebe-tebe neu Ndia? ");
INSERT INTO llg_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Leo ndiak boe, ei boso masambute mia kada dedeꞌa nanaꞌa-nininuk. Huu dei fo Lamatuak nakanenin. ");
INSERT INTO llg_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Hataholi fo taa mana tia-dea neu Lamatuak, huu ala mbilu mbuse fo lakaneni basa ia la. Tehuu ei taa bole leo ndiak, huu ei Amam manai nusa-sodak bubuluk so, basa hata fo ei paluun. ");
INSERT INTO llg_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Mete ma ei makalalaꞌok Manetualain uen dei, na, dei fo Ndia boe oo, nakaneni dedeꞌa kala sila fee ei.” ");
INSERT INTO llg_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Boe ma Yesus tuti seluk bali, nae, “Ei sama leo biꞌilombo bubua anak esa, fo balakain taa fa boe. Tehuu boso bii! Huu ei Amam nai nusa-sodak ndia, Mane Inahuuk ndia. Hata fo Ndia enan, na, Ana namahoko feen Ndia ana susue nala. ");
INSERT INTO llg_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","De, miu seꞌo heni ei baloꞌa mala, fo basa na, doin babaꞌe feen neu hataholi hata taa kala. No leo ndiak, na ei mbeda hata nai nusa-sodak, fo nai mamana sodak, de nahele makandondoo henin. Naꞌo la taa bisa leu lamanaꞌo lalan. Hihinggi boe oo, taa bisa naꞌa nakalulutun. ");
INSERT INTO llg_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Masaneda matalolole! Huu ei hata mala lai bee, na, ei dale mala lai ndia boe.” ");
INSERT INTO llg_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Yesus kokolak bali, nae, “Leledo-leꞌodaen, ei musi mahehele, fo ono-lau Lamatuak. Sama leo hataholi nadedenuk beꞌe nahani ndia malangga maumak fali neme feta kabin mai. Mete ma maumak dedele lelesu, na, ana bisa neu soi lelesu no lai-laik. ");
INSERT INTO llg_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Mete ma maumak mai, na, nita ndia hataholi mana tao ue nala lahani leo ndiak, na, neu ko ala laua-lanale lalan seli. Huu dei fo maumak mesa kana natudu ndia dale malolen neu sala. Ana pake baloꞌa tao ues, de neu ono-lau hataholi mana tao ue sala nanaꞌa malada. ");
INSERT INTO llg_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Hataholi mana tao ue sala sila ua-nale nala neulauk, huu ala ono-lau maumak no malole. Mae maumak mai neu sudi liꞌu hida, fo fatiladak do lolembilak boe oo, sila mana mahehele taa-taak. ");
INSERT INTO llg_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Duduꞌa neulalau! Mete ma hambu maumak bubuluk liꞌu hida naꞌo la mai, na, neu ko ana taa fee lelak neu naꞌo la, fo ala ofe uman. ");
INSERT INTO llg_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","De, ei musi mahehele taa-taa, huu taa hambu hataholi esa boe, bubuluk no teteben, ledoeik bee ndia Hataholi Isi-isik fali main bali. ");
INSERT INTO llg_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Basa de Petrus natane Yesus nae, “Ama Mesen! Ama nakandandaan isinaak ndia kada laꞌeneu ai mesa nggai, do laꞌeneu basa hataholi la?” ");
INSERT INTO llg_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","44","Boe ma Yesus nataa nae, “Nakandandaak ndia laꞌeneu basa hataholi la, fo ala taok aon sama leo malangga makanenik malelak, fo nakaneni no dale katemak neu ndia malanggan. Huu dei fo ndia malanggan soꞌu nalan, fo baꞌe nanaꞌak fee hataholi mana tao ues feꞌe kala. Mete ma ana manggate tao tungga ndia uen leo ndiak, na, mae sudi faik bee ndia malanggan mai boe oo, tehuu ana tao dedeꞌa tetebes taa-taa. Basa de, ana naua-nanale nalan seli, huu ndia malanggan dei fo soꞌu nalan, fo ana nakaneni basa ndia hata-heton. ");
INSERT INTO llg_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Tehuu soe, mete ma malangga makanenik mulai duduꞌa, nae, ‘Eh! Neu ko toulasik bei dook bei fo ana mai.’ Boe ma ana mulai mbomboko hataholi mana tao ues feꞌe kala, touk ma inak. Basa de, ana nanggatuuk naꞌa-ninu no namahokok losa mafuk. ");
INSERT INTO llg_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Tehuu laꞌi esa, malangga makanenik tana duꞌa laꞌen, huu nggengge neuk ndia malanggan fali. Boe ma malanggan mbombokon, basa de ana husi henin, fo ana hambu babaꞌek nai deak noꞌu no hataholi taa dale katemak fo taa mana tao tungga malanggan hihii-nanaun. ");
INSERT INTO llg_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Huu hataholi mana tao ues, bubuluk ndia malanggan hihii-nanaun, tehuu taa nau nahehele tao tunggan, do taa nau tao tunggan, na dei fo ana hambu huhuku belak. ");
INSERT INTO llg_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Tehuu hataholi mana tao ues, fo ana tao ues sala, huu taa bubuluk malanggan hihii-nanaun, na, dei fo ana hambu huhuku taa mabela. Huu hataholi mana simbo ues inahuuk, na ndia natataan inahuuk boe.” ");
INSERT INTO llg_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yesus tuti Ndia kokolan, nae, “Au mai fo tada kofeꞌek Au hataholi nggala lo hataholi feꞌe kala malai daebafok ia. Ndia sama leo hataholi pake haꞌi, fo hotu heni kadafu kala. Au hihiing, na, mete ma haꞌi ndia mulai mbila nai sudi bee so. ");
INSERT INTO llg_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Tehuu Au musi lemba doidoso mabela ndia nakahuluk. Dei fo Au doidoso tebe-tebe losa Au ue mateꞌeng. ");
INSERT INTO llg_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ei mae hetuk Au mai uni dame nai daebafok ia, do? Taa! Au mamaing ia, tao ala hataholi la lahuu lasisimbo bafak, ma tao hataholi la latanggelak huu Au nanonoling. ");
INSERT INTO llg_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Mulai neme hatematak ia mai, hataholi la kaꞌa-fadi kala fanggi. Nai bobonggik esa na, telu ala laban dua, ma dua laban telu. ");
INSERT INTO llg_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Amak laban anan; Anak laban aman. Inan laban anan; Anak laban inan. Alinak laban feto-feun; Feto-feuk laban alinan.” ");
INSERT INTO llg_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Boe ma Yesus kokolak neu hataholi noꞌu kala sila, nae, “Mete ma ei mita koꞌa makate sadu nai muli ele, na ei mae, ‘Ia tanda uda sangga mai.’ Memak tetebes leo ndiak. ");
INSERT INTO llg_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Mete ma ani nafumbu neme kona mai, na, ei mae, ‘Leledon ia matobin ana seli.’ ");
INSERT INTO llg_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Heh! Ei hataholi mana dea-mata kala ia, ei kokolak feꞌek, ma tao feꞌek! Ei malela kala, ei mafada sala fo lalelak daebafok ia, fai hanan ma fai oefaan hihii-nanaun. Tehuu hatina de ei taa nau malelak Lamatuak hihii-nanaun?” ");
INSERT INTO llg_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","58","Yesus kokolak nakadaik bali, nae, “Mete ma ei madedeꞌa, na, hatina de ei taa nau maketu ao nggei, bee ndia tetebes! Malolenak ei tao tungga dame dei! Boso losak ei losa nai mana maketu dedeꞌak matan, boe ma naketun ei maso mini bui dale miu. ");
INSERT INTO llg_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Huu mete ma leo ndiak, na neu ko ei taa bisa kalua, losa ei bae ketu ei hutam fo mana maketu naketu basan ndia so.” ");
INSERT INTO llg_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Faik ndia, hambu hataholi neu nafada Yesus, nae, gubenol Pilatus tao nisa hataholi Yahudi hida leme Galelea, neu ledoeik ala leni tunu-hotuk neni Uma Ina Huhule-haladoik nai Yerusalem. ");
INSERT INTO llg_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Namanene leo ndia, boe ma Yesus natane, nae, “Tungga ei, na, meda hataholi nana tao nisa kala sila, na, sala nala inahuun lena heni basa hataholi Galelea feꞌe kala do? Huu ndia de, ala hambu huhuku mate? ");
INSERT INTO llg_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Taa! Tehuu mete ma ei taa laꞌo ela ei soda manggalaum ndia, fo fali miu tungga Lamatuak hihii-nanaun, na, ei boe oo, dei fo makalulutuk, leo sila boe. ");
INSERT INTO llg_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Basa na, leobee bali, laꞌeneu hataholi kasanahulu falu kala mana mate kala sila, huu fain uma batu madema tuꞌu tuni nala sala leme Siloam? Sila sala nala inahuun lena heni hataholi feꞌe kala malai Yerusalem, do? ");
INSERT INTO llg_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Taa! Tehuu mete ma ei taa laꞌo ela ei soda naputam ndia, fo fali tungga Lamatuak dala ndoon miu, na, ei boe oo, dei fo makalulutuk sama leo sila.” ");
INSERT INTO llg_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Basa boe ma, Yesus tui seluk nakandandaak esa, nae, “Hambu hataholi esa naena ai kaboak nai osin dale. Ana nambue mai titilo sudik, fo sangga bubuluk ai ndia naboa so, do beik. Tehuu ai ndia bei ta naboa. ");
INSERT INTO llg_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Basa boe ma, ana nadenu ndia hataholi mana tao ues nai osi dale, nae, ‘Teuk telu ia so, au mai taa-taa fo sangga ai ia boan, tehuu au taa hambu hata esa boe. De, kekeko henin, huu ai ia kada naꞌa mamanak.’ ");
INSERT INTO llg_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Tehuu mana tao osi ndia nataa, nae, ‘Ama boso mamanasa. Fee ai ia teuk esa bali. Fo suek au fufuꞌa daen ndule huun, ma basa na, au tao pupuk neun, fo tao naꞌaon. ");
INSERT INTO llg_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Mete ma teu mana maik, ai ia naboa, na malole. Tehuu mete ma taa, na, kekeko henin leo.’ ” ");
INSERT INTO llg_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Laꞌi esa, nandaa no hataholi Yahudi la fai huhule-haladoin, de Yesus neu nanoli nai uma huhule-haladoik. ");
INSERT INTO llg_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Nai ndia hambu inak esa dean mbukuk teuk sanahulu falu ia so, huu nitu tataon ndia. Ana taa bisa nambadeik natetu aon. ");
INSERT INTO llg_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesus nita inak ndia, boe ma noke nalan, de nafadan, nae, “Ina! Hatematak ia ina hai ia so.” ");
INSERT INTO llg_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Boe ma Yesus tao liman neu inak ndia, de nggengge neuk, inak ndia dea manambukun, nakandoo tutik. Boe ma ana noke makasi ma koa-kiok Manetualain. ");
INSERT INTO llg_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Tehuu malangga uma huhule-haladoik ndia, manggalau, huu Yesus tao nahai hataholi, laꞌeneu fai huhule-haladoik. Boe ma ana nafada hataholi noꞌu kala, nae, “Sosoda ina esa, na hambu kada faik nee tao ues. De, malolenak hataholi kamahedi kala mai laꞌeneu fai tao ues, fo sangga hataholi mana tao nahai sala. Boso mai nai fai huhule-haladoik!” ");
INSERT INTO llg_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Tehuu Yesus nataan, nae, “Heh! Hataholi mana dea-mata kala. Nai fai hahaek na, ei tao ues, hetu? Huu ei miu mboꞌi ei sapi mala ma keledei, fo fee sala linu oe, hetu?! ");
INSERT INTO llg_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Inak ia, baꞌi Abraham tititi-nonosin, sama leo ita boe. Nitu la malanggan hengge nalan teuk sanahulu falu ia so. Mete ma Au mboꞌi henin laꞌeneu fai huhule-haladoik, na, salak ndia do?” ");
INSERT INTO llg_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Lamanene leo ndia, boe ma Yesus musu nala, mae. Tehuu hataholi noꞌu kala lamahoko lo Ndia tatao-nonoꞌi malole nala. ");
INSERT INTO llg_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Boe ma Yesus kokolak tuti bali, nae, “Leo Au akasasamak Lamatuak hataholi nala sama leo hata bae? ");
INSERT INTO llg_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Sososan sila kada lumak, tehuu dodoo boe ma ala lamanoꞌu. Ala mulai sama leo ai deꞌe kadiꞌi anak. Hataholi selen neu ndia osin. Boe ma ana moli mai, de dadik ai inahuuk. Boe ma mbui kala mai landunu nai baꞌe nala.” ");
INSERT INTO llg_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Basa de, Yesus kokolak bali, nae, “Leo Au akasasamak Lamatuak hataholi nala no hata bali, bae? ");
INSERT INTO llg_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ndia sama leo laluteik, fo ina kala haꞌi lalan, de seseo kana no hade uu saku dua, fo tao loti noꞌuk. Boe ma hade uu nana seseok ndia, mbela mai losa ana inahuu, huu kada laluteik fa anak boe. Nakandandaak ia sosoan leo iak, Lamatuak hataholi nala leꞌa-nole lala sala, de boe nakambela leo ndiak.” ");
INSERT INTO llg_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Basa ndia, boe ma Yesus asa mulai laꞌo leni kota Yerusalem leu. Ana singgo laꞌo-laꞌo tungga-tungga dalak nai kota ma nggolok sila, fo nanoli hataholi la. ");
INSERT INTO llg_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Nai mamanak esa, hambu hataholi esa natanen, nae, “Ama Mesen! Meda kada hataholi luma kala ala bisa hambu sodak, do?” ");
INSERT INTO llg_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Ana nataa, nae, “Nusa-sodak lelesun dalek neu ndia kadiꞌianak. De, mbalak eik, fo ei bisa maso tungga ndia. Huu hambu hataholi noꞌu kala, soba maso, tehuu taa bisa. ");
INSERT INTO llg_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Mete ma maumak nggoe lelesun so, na, dei fo ei mambadeik nai deak, fo dedele lelesu, ma eki moke tulun, mae, ‘Ama! Soi lelesu dei!’ Tehuu dei fo Ana nataa, nae, ‘Ei ia, see? Au taa alelak ei maa!’ ");
INSERT INTO llg_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Boe ma ei mae, ‘Talobee de, Ama taa malelak ai? Ai ndia mateme miꞌa-minu mia Ama. Ama boe oo, mateme manoli ai, nai ai okofoo nala.’ ");
INSERT INTO llg_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Boe ma dei fo Ana nataa nae, ‘Au afada ndia isinaak so, Au taa alelak ei! Ei ia, kada hataholi fo mana tao manggalauk. De, boke malai heok ia! ");
INSERT INTO llg_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Basa boe ma, dei fo mete ma Manetualain naketu basa hataholi la dedeꞌa nala, na ei kada mamatani, ma mamanasa. Tehuu ei mita baꞌi Abraham, baꞌi Isak, baꞌi Yakob, ma basa Manetualain mana kokola nala, maso langgatuuk lai nusa-sodak so. Tehuu ei nana husi henik, mini deak miu. ");
INSERT INTO llg_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Dei fo hataholi la leme basa daebafok buꞌu nala mai, fo leme ledo sasadun mai, losa ledo tetesa neun; neme kii mai losa kona, langgatuk laꞌa noꞌu lai Manetualain uma manen. ");
INSERT INTO llg_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Tanda matalolole dedeꞌak ia; dei fo mete ma Lamatuak naketu hataholi la dedeꞌa nala, na hambu hataholi makahuluk, nae hetuk ndia kada hataholi kadiꞌik, tehuu ana hambu hada-holomata inahuuk. Ma hambu hataholi makahuluk luma lae ndia hataholi inahuuk, naa te Lamatuak tao ndia, kada hataholi kadiꞌik.” ");
INSERT INTO llg_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Faik ndia, hambu hataholi Farisi luma, mai lasale Yesus, boe ma lafada, lae, “Malolenak Ama Mesen heok dook muni mamana feꞌek muu, huu mane Herodes sangga tao nisa Ama.” ");
INSERT INTO llg_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","33","Boe ma Yesus nataa, nae, “Heh! Toulasik ndia manggalaun ana seli! Ei miu mafadan, mae, ‘Au husi heni nitu la, ma tao ahai hataholi kamahedi kala, nai faik ia, ma foꞌa mai. Neu binesan, bei fo Au ueng ndia basan.’ Mae talobee boe oo, Au bei nau tao ues fa bali, nai dalak fo Au uni Yerusalem uu. Huu hataholi Yerusalem sila, fo lahiik tao lisa Manetualain mana kokola nala. ");
INSERT INTO llg_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Awii, hataholi Yerusalem nala aa! Ei ia, fo mambue tao misa Manetualain mana kokola nala, ma mbia makamate hataholi nana dedenu kala, fo ala mai latudu dalak neu ei. Laꞌi noꞌuk Au nau akabubua fo anea ei so, suek babaa ala ei, mima manggalauk mai, sama leo manu ina nasulu nala ana nala, neu lidan dale. Tehuu ei taa nau. ");
INSERT INTO llg_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Hatematak ia, Lamatuak taa mbali ei uma huhule-haladoim ndia so bali. De, mbila-binesak te louk so. Dei fo ei taa mita Au bali, losa ei manaku, mae, ‘Manetualain fee babaꞌe-babatik neu hataholi, fo mana mai neni Lamatuak naden, huu Lamatuak nadenu Ndia so!” ");
INSERT INTO llg_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Laꞌi esa, laꞌeneu fai huhule-haladoik, de hataholi partei Farisi la malanggan esa hoka Yesus, fo neu naꞌa nai ndia uman. Ana nanggatuuk naꞌa, tehuu hambu hataholi malok Ndia, fo sangga nita Ana tao hata, laꞌeneu fai huhule-haladoik. ");
INSERT INTO llg_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Faik ndia, hambu hataholi kamahedi mbaeaok esa, nanggatuuk nai ndia boe. ");
INSERT INTO llg_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Boe ma Yesus natane malela heti-heu Yahudi esa, ma hataholi Farisi fo mana manggatuuk laꞌa lai ndia boe, nae, “Tungga baꞌi Musa heti-heun, na bole tao nahai hataholi kamahedik, laꞌeneu fai huhule-haladoik, do taa?” ");
INSERT INTO llg_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Tehuu taa hambu hataholi esa huꞌa bafan boe. Boe ma Yesus daba hataholi kamahedik ndia, de ana hai tutik. Boe ma Yesus nadenun fali. ");
INSERT INTO llg_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Basa ndia, boe ma Yesus natane sala bali, nae, “Mete ma hambu kakanak esa tuda neni oe dolu dale neu, laꞌeneu fai huhule-haladoik, na, ei miu kalua henin, do taa? Mete ma sapi tuda, na ei elan, do hela kaluan lain mai? Neu ko ei miu hela kaluan neni lain mai. Na, ndia sosoan, nae, ei tao ues ndia, hetu!” ");
INSERT INTO llg_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Lamanene Yesus kokolak leo ndia, boe ma taa hambu hataholi esa boe, ana bisa nataa Ndia. ");
INSERT INTO llg_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Faik ndia, Yesus susuli hataholi la, fo mana mai laꞌa feta lai uma ndia. Hataholi noꞌu kala hele mamanak lai mata, fo langgatuuk leu ndia. Nita leo ndia, boe ma Ana kokolak, nae, ");
INSERT INTO llg_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Mata neuk, baa! Mete ma hataholi hoka ei, fo ei mini feta kabin miu, na, boso miu sangga manggatuuk nai hataholi inahuu kala mamana nala. Huu boso losak mafetak hoka hataholi inahuun lena. ");
INSERT INTO llg_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Mete ma leo ndiak, na, mafetak mai nafada o, nae, ‘Boso mamanasa, baa! Ama hii, na, tulun lali muni dea muu dei, huu au sadia kadela ia, soaneu hataholi inahuuk!’ Boe ma o foꞌa laꞌo ela kadela ndia no mamaek, de o muu manggatuuk muu kadela manai dea. ");
INSERT INTO llg_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","De, mete ma o hambu hohokak, na, muu manggatuuk muu kadela manai dea nalan seli. Dei fo mete ma mafetak nita o, boe ma ana mai, de nae, ‘Eh, Ama! Mai manggatuuk muu mata ia.’ No leo ndiak, na, ei hambu hada-holomata nai basa nana hoka kala mata nala. ");
INSERT INTO llg_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Huu hataholi fo mana sosoꞌuk aon, dei fo Lamatuak tao natudan. Tehuu hataholi mana tao aon sama leo hataholi kadiꞌik, na, dei fo Lamatuak soꞌu lai kana.” ");
INSERT INTO llg_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Basa ndia, boe ma Yesus kokolak no maumak, nae, “Fai seluk, mete ma ama tao feta, na, boso hoka ama bobonggin ma nonoo kamasuꞌi mala! Huu neu ko ala bisa hoka bala ama. ");
INSERT INTO llg_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Mete ma ama tao feta, na, hoka hataholi hata taa kala, hataholi hela eik, hataholi fo taa bisa laꞌok, ma hataholi mboke kala. ");
INSERT INTO llg_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Neu ko ala taa bisa bala ama. Tehuu mete ma ama hoka sala, na, Manetualain ndia bala. Dei fo mete ma Ana tao nasoda falik hataholi kamahele mana mate kala so, na, Ana taa nafalende heni ama dale malolen.” ");
INSERT INTO llg_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Lamanene leo ndia, boe ma hataholi mana manggatuuk mei esa no Yesus, kokolak, nae, “Maua-manalek neu hataholi, fo naꞌa tungga noꞌu nai Manetualain uma manen, bae!” ");
INSERT INTO llg_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesus nataa, nae, “Au tutuing leo iak: hataholi esa tao feta inahuuk. Boe ma ana hoka hataholi makadotok. ");
INSERT INTO llg_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ledoeik feta nahehele sangga mulai, boe ma nadenu ndia hataholi nadedenun neu noke hataholi nana hoka kala, nae, ‘Mai leo, huu feta sangga mulai.’ ");
INSERT INTO llg_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Tehuu basa sala latoꞌo mata-mata kala, fo suek taa bisa leu. Esa natoꞌo, nae, ‘Awii! Bei fo au hasa ala osi esa, de au musi uu ita sudi kana dei. Boso mamanasa baa!’ ");
INSERT INTO llg_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Feꞌek natoꞌo, nae, ‘Bei fo au hasa ala sapi luku pasan lima. De au sangga uu soba sudi kasa ia, de boso mamanasa baa!’ ");
INSERT INTO llg_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Feꞌek bali, na, nae, ‘Bei fo au sao, de taa bisa.’ ");
INSERT INTO llg_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Boe ma hataholi nana dedenuk fali, de nafada ndia malanggan. Namanene leo ndia, boe ma malanggan ndia luli nalan seli. Basa boe ma ana palenda ndia hataholi nadedenun ndia, nae, ‘Mete ma leo ndiak, na o kalua lai-lai! O muni basa okofoo la ma dala makabiꞌa kala, nai kota ia muu, fo hoka basa hataholi kasia nala, hataholi hela ei kala, hataholi mboke kala, ma hataholi luꞌu kala’ ");
INSERT INTO llg_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Namanene leo ndia, boe ma hataholi nadedenuk ndia neu hoka basa hataholi la sila. Basa de ana neu nafada, nae, ‘Ama! Basa hataholi la mai so, tehuu mamana kala noꞌuk bei louk.” ");
INSERT INTO llg_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Boe ma malanggan ndia, nae, ‘Mete ma leo ndiak, na, o muu seluk bali, muni nggolo kala malai kota deak, losa osi la. Kokoe mala sudi see, fo mua sala mai, fo sadi ala tao lahenu mamana feta ia. ");
INSERT INTO llg_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Mamanene baa! Hataholi mana timba heni Au hohokang ndia, taa lameda feta ia ladan fa boe!” ");
INSERT INTO llg_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Basa ndia, boe ma Yesus asa, laꞌo lakandoo leni Yerusalem leu. Hataholi noꞌu kala tungga Ndia. Basa de Ana nasale sala, boe ma Ana kokolak nae, ");
INSERT INTO llg_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Hataholi fo tebe-tebe nau tungga Au, na, musi sue Au lena heni basa-basan: lena heni ndia ina-aman, lena heni ndia sao-anan, lena heni kaꞌa-fadin, nakalenak lena heni ndia aoina hehelin. Mete ma taa, na, hataholi ndia, taa nandaa dadik Au ana mana tunggang. ");
INSERT INTO llg_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Huu hataholi fo taa nau lemba doidosok, huu ana tungga Au, na, ndia taa nandaa dadik Au hataholing. Hataholi fo nau dadik Au hataholing, na, mae hataholi sangga tao nisan boe oo, tehuu ana lemba nakandoo doidoson. ");
INSERT INTO llg_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","De, mete ma sangga nau tungga Au, na, hingga neulalaun dei. Conto leo hataholi sangga nambadedei uma katadak. Ana musi hingga nakahuluk ongkos losa lutu-lutuk. Huu boso losak doik taa dai. ");
INSERT INTO llg_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Mete ma taa hingga lutu-lutuk, na, nafo ana bei fo tao fanderen, naa te basa doi kala so. Basa de, hataholi la hika lakamamae kana ");
INSERT INTO llg_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","lae, ‘Ei mete sudik hataholi ndia dei. Bei fo ana tao fanderen, fo bei ta hata-hata, naa te basa doik so.’ ");
INSERT INTO llg_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Conto feꞌek, fo ndia dedeꞌa natatik. Manek fo nau natati, na, ana musi nanggatuuk hingga nakahulu kana, no ndia nonoo nala. Mete ma ndia soldadu nala kada hataholi lifun sanahuluk, na, meda ana bisa senggi laban musun hataholi lifun dua hulu, do taa? ");
INSERT INTO llg_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Mete ma hingga basan so, tehuu dei fo ndia nana senggik, na, malolenak, ledoeik musu bei nai dook, na, ana haitua memak hataholi nadedenuk neu, fo tao dame. ");
INSERT INTO llg_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Leo ndiak boe neu hataholi mana nau tungga Au. Ana musi hingga neu-mai, nae, ana nahehele so, fo laꞌo ela basa-basan, do taa? Tehuu mete ma taa, na hataholi ndia taa nandaa dadik Au ana mana tunggang. ");
INSERT INTO llg_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","35","Yesus tuti Ndia kokolan no conto feꞌek bali, nae, “Masik ndia, neulauk. Ita paken fo tao nalada nanaꞌak. Tehuu mete ma masik ndia mamin so, na, ndia sosoan hata? Taa bisa paken so bali, fo tao nalada nanaꞌak. Sangga taon neu pupuk boe oo, taa bisa. Kada ita nggali henin leo. See kandiꞌidook, na, mamanene neulalau, bou!” ");
INSERT INTO llg_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Faik ndia, hataholi mana laꞌok bea, no hataholi papake taak feꞌe kala, lambue leni Yesus leu, fo sangga lamanenen. Tehuu hataholi Yahudi la, tao sila leo hataholi taa malole. ");
INSERT INTO llg_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Lita leo ndia, boe ma hataholi Farisi la, ma mese anggama Yahudi la, manggalau, lae, “Aweꞌek! Hataholi ia nanonoo no hataholi papake taa kala. Nakalenak bali Ana nanggatuuk naꞌa no sala bali.” ");
INSERT INTO llg_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Namanene leo ndia, boe ma Yesus tui fee sala nakandandaak ia, nae, ");
INSERT INTO llg_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Leo esa neme ei mai, biꞌilombon natun esa. Boe ma mopo esa. Hatematak ia, hataholi ndia musi tao hata? Neu ko ana laꞌo ela biilombo kasio hulu sio kala sila leu mamana sodak, fo neu sangga losa hambu biꞌilombo mana mopok ndia. ");
INSERT INTO llg_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Mete ma ana natonggo no biꞌilombo ndia, na, ana luꞌa neni fali kana no namahokok. ");
INSERT INTO llg_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Losa uma, boe ma ana noke ndia nonoo nala, de nafada sala, nae, ‘Wei! Ei mai fo mamahoko makasoe mia au dei! Huu au hambu falik au biꞌilombo mana mopong so.” ");
INSERT INTO llg_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nai nusa-sodak leo ndiak boe. Mete ma hambu hataholi kasalak esa hondak, boe ma ana fali neni Lamatuak neu, na basa nusa-sodak isi nala lamahoko lalan seli. Ala lamahoko lalan seli, huu hataholi esa fali neni Lamatuak neu, lena heni hataholi kasio hulu sio kala mai, fo mana masoda no ndoo sala, ma taa sala dalak.” ");
INSERT INTO llg_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Basa de Yesus tui nakandandaak esa, nae, “Hambu inak esa doi lilo fulan sanahulu. Naa te mopo esa. De, hatematak ia, ana sangga tao hata bali? Neu ko ana neu dede haꞌi neu banduk, de ana loti sudi nai bee, ma ana sasapu uma ndia losa basa buꞌuk lalaꞌen, fo ana sangga neulalau doik ndia. ");
INSERT INTO llg_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Faik fo ana hambu falik doik ndia, boe ma ana noke nala hataholi uma tia-tai nala, de nae ‘Wei! Ei mai fo mamahoko noꞌu mia au dei! Huu au hambu falik au doi mana mopong ndia so!’ ");
INSERT INTO llg_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nai nusa-sodak leo ndiak boe. Mete ma hambu hataholi kasalak esa hondak, de basa na ana fali neni Lamatuak neu, na, neu ko basa ata nusa-soda kala lamahoko lalan seli. ");
INSERT INTO llg_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Basa boe ma, Yesus tuti Ndia tutuin no nakandandaak feꞌek esa bali, nae, “Hambu touk esa no ndia ana touanan dua. ");
INSERT INTO llg_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Laꞌi esa, kakana mateꞌa teisusuk, nafada aman, nae, ‘Ama aa! Baꞌe fee au hata pusaka hatematak ia leo!’ Boe ma aman baꞌe hata la sila neu anan dua sala. ");
INSERT INTO llg_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Taa dook boe ma, kakana mateꞌa teisusuk ndia seꞌo heni ndia babaꞌen. Basa de ana mbomboti nala ndia baloꞌan, de ana laꞌo neni nusak dook neu. Nai ndia, ana ngganggali loloo heni ndia doi nala ma nasoda no kada sosoa aok. ");
INSERT INTO llg_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Faik fo ndia doin basan, boe ma ndoes ana seli, langga laꞌe nusak ndia, losa touanak ndia boe oo, ana natai bauk. ");
INSERT INTO llg_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Boe ma ana neu sangga ues, de touk esa nai nusak ndia, simbok nalan, fo feen ana nakaneni bafi la nanaꞌan. ");
INSERT INTO llg_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Huu touanak ndia, taa nakatataka nala ndoes so bali, de ana sadia naꞌa bafi la nanaꞌan. Huu taa hambu hataholi, fo ana nau feen naꞌa. ");
INSERT INTO llg_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Doo-doo, boe ma ana mulai duduꞌa neu-mai, nae, ‘Nai au amang uman, na, basa hataholi mana tao ue sala laꞌa losa lakabete. Naa te au nai ia, sangga mate ua ndoes ia so. ");
INSERT INTO llg_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Malolenak, au fali leo, uni au amang uu. Basa na, au afadan ae, ‘Ama aa! Au tao sala inahuuk neu Lamatuak ma ama so. ");
INSERT INTO llg_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Au taa andaa dadik neu ama anan so bali. Ela ama simbok mala au, dadik neu mana tao ues nai ama uman boe oo, malole ndia!’ ” ");
INSERT INTO llg_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ana duduꞌa leo ndiak, boe ma ana foꞌa, de fali neni aman uman neu. Bei nai dook, tehuu toulasik nitan so, boe ma ana tuda kasian neun. Ana konda neme uma mai, de nalaik neu soluk ndia anan fo ana fali ndia so. Basa de toulasik holu nalan, ma idun. ");
INSERT INTO llg_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Boe ma kakanak ndia kokolak neu aman, nae, ‘Ama aa! Au tao sala inahuuk neu Lamatuak ma ama so. Au taa andaa, dadik neu ama anan so bali.’ ");
INSERT INTO llg_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Tehuu ndia aman palenda nakandoon ndia hataholi mana tao ue nala, nae, ‘Wei! Lai-lai, dei! Miu haꞌi mala badu neulaun seli, fo papaken. Tao ndeli neu ndia lima kuꞌun, ma sapatu neu ein. ");
INSERT INTO llg_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Miu hela mala sapi nakaboik maꞌao ndia, fo tatin, huu ita sangga tao feta takasoe. ");
INSERT INTO llg_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Huu au anang ia, sama leo maten so, tehuu hatematak ia ana nasoda fali so. Ndia mopo so, tehuu hatematak ia, au hambu fali kana so.’ Kokolak basa leo ndia, boe ma ala mulai feta lakasoe. ");
INSERT INTO llg_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Faik ndia, kakana kaꞌak taa nai uma, huu ana tao ues nai osi. Ledoeik ana fali, namanene neme dook mai hataholi la, lakaminak musik, ma ala foti-longge. ");
INSERT INTO llg_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Boe ma ana noke nala hataholi mana tao ues esa, de natanen, nae, ‘Weih! Tao nakasoe hatak ia?’ ");
INSERT INTO llg_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Hataholi mana tao ues ndia, nataa nae, ‘Ama fadim fali main so. De, ama amam nadenu tati sapi, fo tao feta inahuuk, huu ndia anan fali no sodak so.’ ");
INSERT INTO llg_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Namanene leo ndia, boe ma kakana kaꞌak luli. Ana taa nau maso neni uma dale neu so. Boe ma aman neu kokoen fo ana neni uma dale neu. ");
INSERT INTO llg_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Tehuu ana manggalau nae, ‘Ama! Duduꞌa sudi kana dei! Doo-doo basa ia, au mbilu mbuse tao ues sota mate, sama leo ama mana tao uen. Au taa laꞌolena itak ama hihiin. Mae leo ndiak boe oo, tehuu ama bei ta fee nitak au biꞌi ana esa, fo au tao feta akasoe, ua au nonoo nggala. ");
INSERT INTO llg_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Tehuu taa bubuluk, ama anan ia, ana tukan loloo heni doik, neu nakaminak inak fo tao nabasa ama doin. Hatematak ia, ana fali main so, boe ma ama tati sapi maꞌao nalan seli, fo tao feta inahuuk neu ndia.’ ");
INSERT INTO llg_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Tehuu aman nataa, nae, ‘Ana susueng aa! Mamanene neulalau! Doo-doo basa ia, o leo sama-sama mua ama. Basa hata fo ama enan, na, o enam basa sila. ");
INSERT INTO llg_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Tehuu hatematak ia, ita musi feta takasoe, huu o fadim esa ia. Makahulun, sama leo maten so, tehuu hatematak ia ana nasoda fali so. Ana mopo so, tehuu hatematak ia, hambu fali kana so.’ ” ");
INSERT INTO llg_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Basa de Yesus nakadaik nakandandaak esa bali neu Ndia ana mana tungga nala, nae, “Hambu hataholi kamasuꞌik esa, fee hataholi esa ana tao ues, fo ana dadik ndia malangga makanenik. Tehuu doo-doo boe ma malanggan ndia, namanene malangga makanenik ndia, mulai naputak fo tao nakahehenik ndia. ");
INSERT INTO llg_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","De, ana noke nala malangga makanenik ndia, de nafadan, nae, ‘O ia, talobee? Au amanene o mambue maputak au hata nggala. Hatematak ia, o muu tao susula laporan laꞌeneu ues tataon ia, fo au palisa kana dei. Huu basa ndia, na, au sangga fee o hahae.’ ");
INSERT INTO llg_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Namanene leo ndia, boe ma malangga makanenik ndia, duduꞌa neu-mai, nae, ‘Au soe ia so, maa! Hatematak ia, au sangga tao hata bali? Au taa abeꞌi foi dae. Dadik neu mana hule doik boe oo, au mae. ");
INSERT INTO llg_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Mete ma au taa bisa tao ues nai ia bali, na au sangga dalak, fo ela hataholi feꞌe kala bei nau tulun simbok au.’ ");
INSERT INTO llg_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Huu ndia de, ana mulai noke nala basa hataholi mana mahuta kala neu ndia malanggan. Ana natane hataholi kaesan, nae, ‘Weih! O bei mahuta hida nai au malanggang?’ ");
INSERT INTO llg_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Hataholi ndia, nataa nae, ‘Au hutang mina setun liter lifun haa.’ Boe ma malangga makanenik, nae, ‘Tetebes! Ia mala o susula hutan. Hatematak ia, sii henin leo, basa de ana nanggatuuk, fo sulak lai-lai susula huta beuk, nae, o mahuta kada mina liter lifun duak.’ ");
INSERT INTO llg_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Basa de neu natane hataholi kaduan, nae, ‘O bali, mahuta baꞌubee?’ Ana nataa, nae, ‘Au ahuta hade karon lifun esa.’ Malangga makanenik ndia nafadan, nae, ‘Sii heni susula huta laak ndia, ma basa na sulak huta beuk, mae, karon natun faluk.’ ");
INSERT INTO llg_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ana tao leo ndiak, losa ndia malanggan bubuluk ndia kekedin. Tehuu malanggan ndia, musi manaku, nae, malangga makanenik manggalauk ndia, memak masapedon ana seli. Au afada nakandandaak ndia, suek ei bubuluk, mae, mete ma nakasasaman no hataholi kamahele kala, na, hataholi taa kamahele kala memak masapedon ana seli, nasoda nai lauinggu laladan. ");
INSERT INTO llg_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","De, ei duduꞌa sudi kana. Mae hataholi daebafok nambue tao dedeꞌa manggalauk pake sila hata nala, tehuu malolenak ei pake ei hata daebafom fo tulu-fali hataholi la. No leo ndiak, na ei boe oo, hambu nonook makadotok. Mae hata la sila basan, tehuu dei fo Lamatuak sadia mamanak fee ei, nai nusa-sodak. ");
INSERT INTO llg_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Mete ma hataholi ndoos nai dedeꞌa kadiꞌi ana kala, na, neu ko ana ndoos nai dedeꞌa inahuuk. Tehuu mete ma hataholi naputak nai dedeꞌa kadiꞌi ana kala, na, neu ko naputak nai dedeꞌa inahuuk. ");
INSERT INTO llg_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Mete ma hataholi taa bisa namahele ei, fo makaneni hata basa faik, fo dedeꞌa kadiꞌik nai daebafok ia, na talobee fo Lamatuak namahele ei nai dedeꞌa inahuuk? ");
INSERT INTO llg_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Mete ma ei taa bisa makaneni hataholi feꞌek hatan, na see nambalani nau fee ei hatan? ");
INSERT INTO llg_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Nadedenuk esa, taa bisa namanene malanggan dua. Huu dei fo ana husembuluk neu esa, ma ana sue esa. Do dalen katemak neu esa, ma taa mbali esa. Leo ndiak boe no ei, huu hataholi taa bisa sue Manetualain, sama-sama no doik.” ");
INSERT INTO llg_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Faik ndia, hambu hataholi Farisi luma tungga lamanene Yesus kokolan isinaak ndia. Boe ma ala haumemee Ndia, huu ala balenaꞌo doik. ");
INSERT INTO llg_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Tehuu Yesus nataa, nae, “Wei! Mae ei tao malalao aok nai hataholi matan, tehuu Manetualain bubuluk ei dale mala sila manggalauk. Hambu dedeꞌak noꞌuk, fo hataholi soꞌun dema-demak, naa te tungga Manetualain, na, dedeꞌak ndia manggalauk, ma Ana nunute sala. ");
INSERT INTO llg_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Losa no Yohanis Mana Salanik mamain, na, ita hataholi Yahudi tasoda tungga baꞌi Musa ma Lamatuak mana kokola nala heti-heun. Tehuu hatematak ia, Lamatuak Hala Malolen nana tui-benggak nai sudi bee. Hataholi noꞌuk lasusua tingga-tingga, fo suek ala lasoda tungga Lamatuak hihii-nanaun. ");
INSERT INTO llg_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Leo mae lalai ma daebafok mopo heni sala, tehuu Manetualain heti-heun taa mopo fa boe. Titi-koma boe oo, taa mopo sala! ");
INSERT INTO llg_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Hataholi fo ana ela heni sao inan, fo ana sao seluk bali no ina feꞌek, na hohonggek ndia. Basa de hataholi sao no ina sao elak, na hohonggek ndia boe.” ");
INSERT INTO llg_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yesus tui nakadaik, nae, “Hambu hataholi kamasuꞌik esa, nahiik pake baloꞌa malole fo nana taok neme tema bangganaꞌuk mai. Leledo-leꞌodaen ana naꞌa-ninu malada-malada, ma ana sosoa aon. ");
INSERT INTO llg_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Nai ndia, hambu hataholi mana taik esa. Ndia naden Lasarus. Ndia aon henuk no bisu mbuluk. Tungga-tungga faik, nonoo nala loon, fo taon neu hataholi kamasuꞌik ndia lelesu tembok matan. ");
INSERT INTO llg_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ana nahiik naꞌa neme hataholi kamasuꞌik ndia nanaꞌa ela nala, tehuu tana hambu hata esa boe. Kada busa la mai lalamemei ndia bisun nanan. ");
INSERT INTO llg_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Basa boe ma Lasarus maten. Boe ma Manetualain ata nusa-sodan mai haꞌi nalan, de nanggatutuun neu baꞌi Abraham boboan. Taa dook boe ma hataholi kamasuꞌik ndia maten, de hataholi la, latoin. ");
INSERT INTO llg_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Tehuu ndia taa maso nusa-sodak. Ana maso neni naraka neu, sama-sama no hataholi mana mamate kala noꞌuk. Nai ndia, ana hambu doidosok taa-taa. Boe ma laꞌi esa, ana botik matan, de nita Lasarus nanggatuuk namahoko, nai baꞌi Abraham boboan. ");
INSERT INTO llg_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Boe ma ana nanggou, nae, ‘Baꞌi Abraham aa! Kasian neu au dei! Fee Lasarus dombe lima kuꞌu mbedan neu oe, fo ana mai nakadoen neu kada au maang mbedan boe oo, malole ndia. Huu au doidoso mamates nai haꞌi naraka ia!’ ");
INSERT INTO llg_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Tehuu Abraham nataa, nae, ‘Ana nggo ei! Masaneda neulalau neu fain, fo faik o bei masoda nai daebafok, o hambu basa malole la. Tehuu Lasarus kada hambu totoꞌak. De, hatematak ia Lamatuak kokoe-nanasi ndia nai ia, tehuu o doidoso. ");
INSERT INTO llg_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Nakalenak bali, nai o ma ai laladan ia, Lamatuak tao leak maloa esa. De, hataholi malai ia kala, taa bisa leni ei miu, ma hataholi malai ndia kala, taa bisa leni ia mai. ");
INSERT INTO llg_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Boe ma hataholi kamasuꞌik ndia noke, nae, ‘Mete ma leo ndiak, na, baꞌi tulun madenu Lasarus neni au amang uman neu dei. ");
INSERT INTO llg_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Huu au bei fadi toung lima lai ele. Madenu Lasarus neu nasaneneda kasa, fo ala fali leni Lamatuak leu leo. Fo suek mate sala, na, boso ala maso leni mamana doidosok ia mai.’ ");
INSERT INTO llg_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Tehuu Abraham nataa, nae, ‘Manetualain fee sala baꞌi Musa ma Lamatuak mana kokola nala susula nala. O fadi mala bisa les bali-bali, fo lalelak Lamatuak hihii-nanaun.’ ");
INSERT INTO llg_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Tehuu, hataholi kamasuꞌik ndia sapa, nae, ‘Baꞌi Abraham aa! Ndia bei ta dai. Ala taa mbali Lamatuak Dedeꞌa-kokolan! Musi hambu hataholi mana matek kalua neme lates dale mai, fo neu nafada sala, bei fo ala hondak, boe ma nau lamanene.’ ");
INSERT INTO llg_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Tehuu Abraham nataa, nae, ‘Mete ma ala taa nau lamanene baꞌi Musa ma Lamatuak mana kokola nala dedeꞌa-kokola nala, na, mae hataholi mana matek kalua neme lates dale mai boe oo, ala taa nau lamanene.’ ” ");
INSERT INTO llg_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesus nafada Ndia ana mana tungga nala, nae, “Laꞌi noꞌuk hambu hataholi fo tuda neni salak dale neu, huu hataholi feꞌek tataon. Tehuu hataholi mana tao dedeꞌak ndia, soen ana seli. ");
INSERT INTO llg_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Mete ma hataholi mana tao dedeꞌak leo ndiak, losa hambu kakanak taa namahele Au, na, dei fo Manetualain feen huhuku belak. Daꞌuanan lena, na, malolenak mbaꞌa batu inahuuk esa neu lesuhaꞌin, fo mbia henin neni tasi dale neu. ");
INSERT INTO llg_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","De, manea neulalau, fo ei boe oo, boso tao mala hataholi tuda salak dale neu! Tehuu mete ma o tolanoom tao salak, na, kaꞌin. Mete ma ana hondak, boe ma ana mai noke ambon, na, mafalende heni ndia salan ndia. ");
INSERT INTO llg_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Mete ma o tolanoom tao salak laꞌi hitu nai leledok esa, boe ma ana hondak, de ana mai noke ambon laꞌi hitu, na, o musi mafalende heni salan laꞌi hitu boe.” ");
INSERT INTO llg_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Faik esa, Yesus ana mana tungga nala mai lasale Ndia, fo loke, lae, “Ama Mesen! Ai namahehelen taa matea. Tulun matetea ai namahehelen dei!” ");
INSERT INTO llg_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Boe ma Yesus nataa, nae, “Mete ma ei namahehelem neu Manetualain koasan, na, mae kada fak boe oo, tehuu ei bisa palenda ai ina ndia, mae, ‘Feꞌa, fo lali muni tasi dale muu!’ Dei fo ai ndia tungga ei palendam tutik.” ");
INSERT INTO llg_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Basa boe ma Yesus kokolak bali, nae, “Haꞌi conto. Hambu ata esa, tati dae nai osi, ma nanea biꞌilombo nai mook. Ana tao ues nateꞌe boe ma ata ndia fali uma neu. Mae leobee boe oo, ndia malanggan taa kokolak nae, ‘Mai fo ita dua nggata tanggatuuk fo taꞌa noꞌu leo!’ ");
INSERT INTO llg_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Taa! Mandaan ndia, na, ndia malanggan palendan, nae, ‘Muu tao nanaꞌa-nininuk fee au dei. Basa na, bei fo o muꞌa-minu nai dea ele.’ ");
INSERT INTO llg_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Mete ma ata ndia tao tungga ndia malanggan hihii-nanaun so, na, ei mae hetuk malanggan ndia ana noke makasi neu ndia, do taa? ");
INSERT INTO llg_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ei leo ndiak boe. Mete ma ei tao basa ues, fo Lamatuak palendak ndia so, na, ei kokolak mae, ‘Ai kada hataholi nadedenu kala. Ai taa sangga kokoak. Huu kada ai makalalaꞌok ues.” ");
INSERT INTO llg_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Faik fo Yesus asa laꞌo leni Yerusalem leu, ala losa propinsi Galelea ma nusa Samaria, toon. ");
INSERT INTO llg_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Faik fo ala sangga maso leni nggolok esa nai ndia leu, boe ma hataholi kamahedi kusta sanahulu nau latonggo lo Yesus. Ala lambadeik lai dook. ");
INSERT INTO llg_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Basa de ala langgou landaa, lae, “Yesus! Lamatuak aa! Kasian neu ai dei!” ");
INSERT INTO llg_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ledoeik Yesus nita sala, boe ma nadenu sala, nae, “Ei miu matudu ei ao mala neu malangga anggama la dei, fo suek ala palisak, lae, ei hedi kustam ndia mopon so, do beik.” Lamanene leo ndia, boe ma leu. Leu dala laladak, de kada nggengge neuk basa sala hai tutik so. ");
INSERT INTO llg_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ala laꞌok lakandoo no namahokok. Tehuu hataholi esa fali neni Yesus neu. Ana eki, nae, “Kokoak neu Lamatuak! Huu au hai so!” ");
INSERT INTO llg_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Boe ma ana sendek lunggulanggan, de noke makasi noꞌuk neu Yesus. (Naa te hataholi ndia taa hataholi Yahudi. Ndia hataholi Samaria, fo ala ladedeꞌa lakandondoo henin lo hataholi Yahudi la.) ");
INSERT INTO llg_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Boe ma Yesus natane hataholi la fo mana tungga Ndia, nae, “Talobee bae? Isinaak Au tao ahai hataholi sanahulu, hetu? De kasio kala, lai bee? ");
INSERT INTO llg_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Hatina de kada hataholi nusa dea ia fali main, fo noke makasi neu Manetualain, ma ana koa-kio neu Ndia?” ");
INSERT INTO llg_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Boe ma Ana nafada hataholi ndia, nae, “O hai so, huu o mamahele tebe-tebe neu Au. De, foꞌa leo, fo fali muni o nggolom muu no sodak.” ");
INSERT INTO llg_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","21","Faik esa, hataholi Farisi luma mai latane Yesus, lae, “Ama Mesen! Mafada sudik ai dei! Faik bee ndia Manetualain mulai nakalalaꞌok Ndia totoꞌu palendan?” Boe ma Yesus nataa, nae, “Leo iak! Lamatuak taa nakalalaꞌok Ndia totoꞌu palendan nenik tanda mata-mata kala nai daebafok ia, fo hataholi bisa nita no ndia matan. Hataholi la taa hambu buti, de lae, ‘Hena mete sudik ia! Huu Manetualain nakalalaꞌok Ndia totoꞌu palendan nai ia so!’, do ‘Nai ele!’ Taa! Huu Ana nakalalaꞌok Ndia totoꞌu palendan nai ei lalada mala, fo nai hataholi la dale nala.” ");
INSERT INTO llg_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Basa de Yesus nafada Ndia ana mana tungga nala, nae, “Taa dook so bali, tehuu Au, fo Hataholi Isi-isik ia, taa sama-sama ua ei so bali. Dei fo neu fai-fai toꞌa-taa kala, na, ei dokodoe nau mita Au fafali maing. Tehuu, Au bei ta mai. ");
INSERT INTO llg_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Mete ma hataholi la mai lafada, lae, ‘Karistus nai ia!’ do, ‘Karistus nai ele!’ na, ei boso masambute masanggak miu-mai, huu hataholi la kokola nala sila pepekok ndia. ");
INSERT INTO llg_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Tehuu dei fo Hataholi Isi-isik tebe-tebe fali main, na, ndia tandan manggaledok nalan seli, sama leo manggahadok fo nasaꞌa tao manggaledo lalai, neme mbedak seli mai, neni mbedak seli neu. ");
INSERT INTO llg_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Tehuu Ndia boe oo, musi tanggon doidosok mata-matak dei. Ma hataholi lelek hatematak ia, taa nau lamanene, ma ala sangga timba nggali heni Ndia. ");
INSERT INTO llg_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Tehuu, mete ma Ana nau fali main, na, hataholi la kada lasoda lo manggalauk sama leo basa faik, fo sama leo Noh lelen. ");
INSERT INTO llg_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Faik ndia, ala laꞌa-linu, tao feta kabin, losa faik fo Noh maso neni ofak dale neu. Tehuu hataholi la sila boe oo, taa nau lamanene. Boe ma, nggengge neuk faa inahuuk nggangga mai, de tao nakalulutu sila basa sala. ");
INSERT INTO llg_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ndia boe oo, sama leo hataholi la, fo mana masoda manggalauk nai Lot lelen. Faik ndia, ala laꞌa-linu, ala danggan, tao osi, lambadedei uma, ma ala lasoda manggalauk leo basa faik. ");
INSERT INTO llg_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Tehuu hataholi la boe oo, taa nau lamanene. Boe ma fafain ndia, fo Lot nalai laꞌo ela kota Sodom, kada nggengge neuk uda haꞌik ma balerang tuda leme lalai mai, de naꞌa heni sila basa sala. ");
INSERT INTO llg_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","De, ei musi mata neuk baa! Huu boso losak dei fo mete ma Hataholi Isi-isik ndia, sangga fali main, boe ma hataholi la kada lasoda leo basa faik. Tehuu kada nggengge neuk Ana sadu mai. ");
INSERT INTO llg_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Faik ndia, hataholi manai uma mata ndia, boso maso bali, fo mambembeda. Hataholi mana tao ues nai osi, boso fali mai fo haꞌi buas. ");
INSERT INTO llg_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Masanenedak hata fo dadi neu Lot saon nai makahulun. Ana mate, huu nasaneda ndia buan nai uma. ");
INSERT INTO llg_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Hataholi taa nau tungga Au, huu ana sue aoina hehelin, na, dei fo ndia sodan sosoan taa. Tehuu hataholi fo mana nau tungga Au, losa ana fee ndia sodan, huu ana sue Au, dei fo ana hambu sodak, ma nasoda nakandondoo henin no Manetualain. ");
INSERT INTO llg_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Au afada memak! Faik fo Hataholi Isi-isik fali main, na, mete ma hataholi dua sunggu lai koi esa, boe ma, nggengge neuk Lamatuak haꞌi nala esa, ma ela esa. ");
INSERT INTO llg_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Mete ma inak dua, mbau hade sama-sama, na, dei fo Lamatuak haꞌi nala esa tehuu ela feꞌek ndia. ");
INSERT INTO llg_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Mete ma hataholi dua tao ues lai osi, na dei fo Lamatuak haꞌi nala esa, ma ela feꞌek ndia.” ");
INSERT INTO llg_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Lamanene leo ndia, boe ma Yesus ana mana tungga nala latane Ndia, lae, “Ama Mesen! Dei fo basa sila dadi lai bee?” Boe ma Yesus kokolak nakandandaak, nae, “Leo iak. Mete ma ei mita mbuik manaꞌa banda kamates, laꞌa lakabubuak leni bee leu, na, ei bubuluk so, ndia dadik tanda, nae, neu ko leu laꞌa banda kamates lai mamanak ndia.” No maksud nana nafunik, dei fo mete ma Karistus fali main, na, ndia tanda nala manggaledok nalan seli, mete ma hataholi les nalelak. ");
INSERT INTO llg_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Laꞌi esa, Yesus nanoli Ndia ana mana tungga nala, nenik nakandandaak, fo ala hule-haladoi taa no namaketuk, ma samanek taa mana maꞌa-malek. Ala musi lamahele Lamatuak nakandondoo henin. ");
INSERT INTO llg_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Tutuik ndia leo iak: “Nai kota esa hambu mana maketu dedeꞌak esa, taa mbali Manetualain. Ana taa mbali sudi see boe. ");
INSERT INTO llg_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Nai ndia boe oo, hambu ina falu esa nambue neni mana maketu dedeak ndia neu, fo noke nakandondoo henin, nae, ‘Ama mana maketu dedeꞌak! Maketu au dedeꞌang no ndoos, baa!’ ");
INSERT INTO llg_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Sososan mana maketu dedeꞌak ndia taa mbali ina falu ndia. Tehuu doo-doo boe ma ana mbela-malua namanene inak ndia. Basa de ana nanggatuuk duduꞌa, nae, ‘Memak au taa mbali Manetualain, nakalenak hataholi. ");
INSERT INTO llg_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Tehuu ina falu ia, tao nala au langgang naleo. Huu ndia de, malolenak au aketu ndia dedeꞌan no ndoos dei. Tehuu mete ma taa, na dei fo ana nambue tao nakasosotak au nakandondoo henin.’ ");
INSERT INTO llg_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Naa, ei duduꞌa soba sudik mana maketu dedeꞌa manggalauk ndia. ");
INSERT INTO llg_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Mae doon ana seli bei fo ana tulu-fali ina falu ndia, na, neu ko Manetualain boe oo nau tulu-fali Ndia hataholi nala, fo mana hule-haladoik leledo-leꞌodaen noke tulu-falik. Tehuu Lamatuak taa nau nakaꞌeꞌeso kana ");
INSERT INTO llg_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Huu Ana nakaneni sila dedeꞌan no lai-laik. Naa, Au sangga atane leo iak: mete ma Au, Hataholi Isi-isik ia, fali maing so, na, meda Au bei atonggo ua hataholi kamahele kala malai daebafok ia, do taa?” ");
INSERT INTO llg_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yesus tui nakadaik nakandandaak esa, laꞌeneu hataholi mana mamahele aon ana seli, ma nahiik nakadadaek hataholi feꞌek. Ana tui, nae, ");
INSERT INTO llg_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Hambu touk dua leu hule-haladoi nai Uma Ina Huhule-haladoik. Touk esa neme partei anggama Farisi mai; ma esa bali, na, mana susu bea. Hataholi Yahudi la, taok hataholi Farisi la hataholi malalaok. Tehuu ala taok hataholi mana susu bea la, hataholi taa malole. ");
INSERT INTO llg_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Losa uma huhule-haladoik, boe ma hataholi Farisi ndia mesa kana nambadeik de ana hule-haladoi, nae, ‘Makasi Lamatuak, huu au ia, hataholi neulauk. Au taa manggalauk leo hataholi feꞌe kala. Au taa nakodaa. Au taa balenaꞌo, Au taa hohongge. Makasi, Lamatuak, huu au taa manggalauk leo mana susu bea ia. ");
INSERT INTO llg_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Au manggate puasa laꞌi dua nai sosodaꞌina esa. Ma au fee taa-taa babaꞌe sanahulu neme basa au hahambung mai.’ Hataholi Farisi ndia huhule-haladoin leo ndiak. ");
INSERT INTO llg_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Tehuu mana susu bea ndia, nambadeik dook nai dea ele. Ana taa nambalani botik matan, fo suli neni lalai neu. Kada ana hule-haladoi nakatele langgan no dale makalulutuk, nae, ‘Ou Manetualain. Kasian neu au, fo hataholi mana tao salak ia! Fee ambon neu au dei! ");
INSERT INTO llg_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Faik ndia dua sala fali leni sila uma nala leu, de, meda see ndia fo malole no Manetualain? Hataholi mana koaok ndia, do, hataholi mana susu bea ndia? Neu ko Ana simbok no malole mana susu bea fo dale kadiꞌi taidaek ndia. Tehuu taa mbali hataholi Farisi ndia. Huu Manetualain tao natuda hataholi mana koaok, tehuu Ana soꞌu laik hataholi dale kadiꞌi taidaek.” ");
INSERT INTO llg_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Laꞌi esa, hataholi la koꞌo leni ana kadiꞌi ana nala, leni Yesus leu, fo suek Ana tao liman neu sala, ma Ana kokolak fee sala babaꞌe-babatik. Lita leo ndia, boe ma Yesus ana mana tungga nala, kaꞌi hataholi kaꞌana kala sila. ");
INSERT INTO llg_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","17","Tehuu Yesus soluk nala kakana kala sila, fo maleni Ndia leu. Basa de Ana nafada Ndia ana mana tungga nala, nae, “Neme naa, fo kakana ana kala sila leni Au mai. Ei boso makalelee sala. Masaneda neulalau! Huu hataholi fo nau dadik Manetualain hataholin, na, musi namahena neu Manetualain, fo sama leo kakana ana kala, lamahena neu sila ina-ama nala.” ");
INSERT INTO llg_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Laꞌi esa, hambu hataholi Yahudi inahuuk esa mai natane Yesus, nae, “Ama Mesen fo nana hadak! Au musi tao leobee, fo ela au bubuluk no teteben, au bisa maso uni nusa-sodak uu, fo suek au asoda akandoo ua Manetualain?” ");
INSERT INTO llg_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Boe ma Yesus nataa nae, “Hatina de o mae, Au, ‘nana hadak’? Kada esak nana hadak, fo ndia Manetualain. ");
INSERT INTO llg_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Naa! O bubuluk so, hetu, Manetualain heti-heun neme makahulun mai, nae: Boso hohongge; boso makanisa; boso mamanaꞌo; boso dadik neu sakasii pepekok; ma fee hadak neu o ina-amam.” ");
INSERT INTO llg_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Hataholi ndia nataa, nae, “Tetebes, Ama! Au tungga basa heti-heu kala sila mulai neme au bei kadiꞌing mai.” ");
INSERT INTO llg_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Namanene leo ndia, boe ma Yesus nae, “Malole! Tehuu o bei ta dai dedeꞌak esa. Huu ndia de, hatematak ia, o fali fo muu seꞌo heni basa o hata-heto mala. Basa ndia, na, muu babaꞌe doi nala neu hataholi hata taa kala. Basa na, bei fo o fali maim fo tungga Au. Huu dei fo Manetualain bala fee o hata nai nusa-sodak.” ");
INSERT INTO llg_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Namanene leo ndia, boe ma hataholi ndia dalen hedis, huu ndia namasuꞌi nalan seli. ");
INSERT INTO llg_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesus nitan laꞌo no dale makalulutuk, de nafada Ndia ana mana tungga nala, nae, “Hataholi kamasuꞌik memak makaleꞌo ndoos maso neni nusa-sodak neu. ");
INSERT INTO llg_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ita takasasaman no dedeꞌa feꞌek. Memak taa bisa banda onta inahuuk maso neni lalaen dale neu, nesik ndandau bolo. Leo ndiak boe neu hataholi fo kada namahena neu ndia hata-heton, tehuu taa namahena neu Lamatuak, na, taa bisa maso neni nusa-sodak neu. ");
INSERT INTO llg_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Hataholi mana mamanene Yesus kokolan leo ndiak, latane Ndia, lae, “Mete ma totoꞌak neu hataholi kamasuꞌik leo ndiak, na, hataholi mata leobeek bisa hambu sodak. ");
INSERT INTO llg_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesus nataa, nae, “Soaneu hataholi, na memak dedeꞌak noꞌu kala taa bisa. Tehuu soaneu Manetualain na basan bisa dadi.” ");
INSERT INTO llg_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Boe ma Petrus ana tuti, nae, “Ama aa! Ai laꞌo ela basa ai hata-heto nala, fo tungga Ama. Tehuu dei fo ai hambu hata?” ");
INSERT INTO llg_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesus nataa, nae, “Peꞌu! Mamanene neulalau! Hataholi mana laꞌo ela uman, sao inan, kaꞌa-fadi nala, inama nala, do ana nala, huu ana nakalalaꞌok Manetualain uen, ");
INSERT INTO llg_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","na neu ko ana simbo noꞌun lena heni nai daebafok ia. Boe ma mete ma daebafok ia nakalulutuk, na ndia boe oo, hambu sodak nakandondoo henin no Manetualain.” ");
INSERT INTO llg_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesus noo Ndia ana mana tungga nala hataholi kasanahulu dua kala, de mesa kana Ana kokolak no sala, nae, “Ei basa nggei bubuluk, mae, hatematak ia ita belaꞌo teni kota Yerusalem teu. Losa ele, boe ma basa hata fo makahulun Lamatuak mana kokola nala sula kana so, laꞌeneu Hataholi Isi-isik ndia, dei fo ana dadi tetebes leo hata fo ala sulak ndia. ");
INSERT INTO llg_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Dei fo ala fee Au uu hataholi feꞌe kala, fo taa lamahele Manetualain. Basa de ala haumemee Au. Ala lakadadaek Au mata-mata kala. Ala mbula ambe neu Au. ");
INSERT INTO llg_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ala filo Au. Basa de, ala tao lisa Au. Tehuu neu binesan, Au asoda fali. ");
INSERT INTO llg_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Lamanene Yesus kokolan leo ndia, boe ma ana mana tungga nala lasapangga, huu ala bei ta bisa bubuluk dedeꞌa kala sila ndandaan. ");
INSERT INTO llg_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Faik fo Yesus asa sangga maso leni kota Yeriko leu, hambu hataholi mbokek esa mana noke-noke doik nanggatuuk nai dalak bifin. ");
INSERT INTO llg_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ledoeik namanene hataholi noꞌu kala lesik ndia, boe ma natane, nae, “Wei! Hata ndia?” ");
INSERT INTO llg_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Boe ma hataholi la lafadan, lae, “Yesus maneme Nasaret mai, nesik ndia.” ");
INSERT INTO llg_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Namanene leo ndia, boe ma hataholi mbokek ndia, eki tingga-tingga, nae, “Yesus! Mane Dauk tititi-nonosin aa! Kasian neu au dei!” ");
INSERT INTO llg_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Hataholi la mana laꞌok lakahuluk lai Yesus matan, kaꞌin fo ana nee-nee. Tehuu ana boe eki natingga bali, nae, “Mane Dauk tititi-nonosin aa! Kasian neu au dei!” ");
INSERT INTO llg_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ledoeik Yesus namanene leo ndia, boe ma nambadeik. De, Ana nadenu leu lalaꞌo loo hataholi mbokek ndia mai. Losa neu Ndia matan, boe ma Yesus natanen, nae, ");
INSERT INTO llg_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“O nau Au tao hata neu o?” Ana nataa, nae, “Ama aa! Au oke fo au bisa ita.” ");
INSERT INTO llg_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesus nataa, nae, “Malole. Huu o mamahele, fo Au bisa tao ahai o, de hatematak ia, o bisa mita so.” ");
INSERT INTO llg_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Kada nggengge neuk, hataholi ndia, mboken hai tutik so. Boe ma ana tungga Yesus, ma ana koa-kio Manetualain. Basa hataholi mana lita leo ndiak, ala soꞌu koa-kiok neu Manetualain. ");
INSERT INTO llg_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Basa de Yesus asa maso tungga kota Yeriko, fo sangga laꞌo lakandoo. ");
INSERT INTO llg_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Nai ndia hambu malangga mana susu bean esa, naden Sakeos. Ndia hataholi kamasuꞌik. ");
INSERT INTO llg_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ledoeik namanene Yesus sangga nesik ndia, boe ma nahiik nita Yesus. Tehuu taa bisa nita neulalaun, huu hataholi noꞌuk ala lakalilimbu lala Yesus, ma ndia aon kekeꞌuk. ");
INSERT INTO llg_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Huu ndia de ana nalaik nakahuluk, boe ma ana hene neni ai esa lain neu, nai dalak bifin, fo Yesus sangga nesik ndia. ");
INSERT INTO llg_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Losa ai ndia hun, boe ma Yesus suli lain neu. Basa de Ana noke Sakeos, nae, “Sakeos! Konda mai leo! Masiꞌa, huu faik ia, Au sangga leo tataak nai o umam.” ");
INSERT INTO llg_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sakeos heran nalan seli. Boe ma ana konda lai-lai, de ana noo Yesus neni ndia uman neu. Ana namahoko nalan seli. ");
INSERT INTO llg_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Tehuu hataholi noꞌu kala ala manggalau, lae, “Aweꞌek! Sakeos ia, hataholi manggalauk! Hatina de Yesus maso neu leo taa-taak nai ndia uman?! Basa hataholi la bubuluk so!” ");
INSERT INTO llg_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Losa uma, boe ma Sakeos nambadeik neu Yesus matan, de ana kokolak nae, “Ama Mesen! Mulai neme leledon ia mai, au baꞌe duak basa au hata nggala, fo fee babaꞌek esa neu hataholi hata taa kala. Mete ma au susu bea itak lena-lenak, na au bae fali kana neu sala, beke laꞌi haak.” ");
INSERT INTO llg_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesus nataa nae, “Malole. Faik ia, Manetualain fee o sodak so ma basa o bobonggi mala, huu o mamahele Lamatuak, sama leo baꞌi Abraham. ");
INSERT INTO llg_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Huu Manetualain nadenu Au dadik neu Hataholi Isi-isik nai daebafok ia. Au mai sangga hataholi mana heok neme Lamatuak dalan mai, fo tao fee sala sodak.” ");
INSERT INTO llg_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Faik ndia, hambu hataholi noꞌuk tungga lamanene neu Yesus. Ala sangga deka-deka lo kota Yerusalem. Ala laehetuk Ana nau nakalalaꞌok Manetualain palendan nai ndia, sama leo manek esa. Boe ma Yesus tui fee sala nakandandaak esa bali, ");
INSERT INTO llg_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","nae, “Hambu hataholi inahuuk esa sangga laꞌo neni nusa dea neu, fo ala poi lesun dadik manek. Basa na, bei fo ana nau fali neni ndia nusa hehelin neu. ");
INSERT INTO llg_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ledoeik nahehele fo ana sangga laꞌo, boe ma noke ndia hataholi mana tao ue kasanahulu nala, de ana fee sala hataholi esa na doi lilo mbilas esa. Ana palenda, nae, ‘Ei pake doi kala ia dadik neu poko. Tehuu dei fo mete ma au fali, na, ei mafada au, èi hambu bunak baꞌu bee.’ Boe ma ana laꞌo leo. ");
INSERT INTO llg_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Tehuu ndia lau-inggu nala, husembuluk neun. De, ala haitua hataholi nadedenu nala leni ele leu, fo lafada lae, ‘ai taa nau hataholi ia toꞌu palenda neu ai.’ ");
INSERT INTO llg_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Mae leo ndiak boe oo, tehuu ala poi lesu neu ndia nai ele. Basa de ana fali. Losa ndia uman, boe ma ana noke ndia hataholi mana tao ue kasanahulu nala, de natane sala, nae, ‘Ei hambu bunak hida, neme doi lilo mbilas ndia mai?’ ");
INSERT INTO llg_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Hataholi mana tao ues sososak nafada, nae, ‘Ama manek! Au hambu bunak laꞌi sanahulu neme poko fo au simbok ndia! ");
INSERT INTO llg_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Boe ma manek nafadan nae, “Malole! O ia, hataholi mana tao ues malole. Huu au bisa amahele o, nenik dedeꞌa kadiꞌi kala, huu ndia de, hatematak ia, au soꞌu ala o, fo palenda kota sanahulu.’ ");
INSERT INTO llg_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Boe ma, hataholi mana tao ue kaduan nafada nae, ‘Ama manek! Au hambu bunak doi lilo mbilas lima neme poko fo au simbok ndia.’ ");
INSERT INTO llg_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Boe ma manek ndia koan, nae, ‘Malole! Mete ma leo ndiak, na au soꞌu ala o, fo palenda kota lima.’ ");
INSERT INTO llg_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Tehuu hataholi mana tao ue katelun, neni falik ndia doi lilo mbilan. Boe ma nafada, nae, ‘Ia mala falik ama doin! Au mbombotin, de au afuni neulalaun, fo boso mopon. ");
INSERT INTO llg_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Au tao leo ndiak, na, huu au bii. Au bubuluk ama ia, mana toꞌu palenda no lima besik. Huu ama mahiik haꞌi mala hata fo ama taa enan, ma ketu mala hata fo ama taa selen.’ ");
INSERT INTO llg_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Namanene leo ndia, boe ma manek nasapala kana, nae, “O ia taa kalela hadak! O kokolam ndia, huku seluk o aoina hehelim so. O bubuluk au ia hataholi dale matea, fo haꞌi ala hata fo taa au enang, ma ketu ala hata fo au taa selen. ");
INSERT INTO llg_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Mete ma leo ndiak, na, hatina de o taa muu mbeda doik ia neu bank? Fo ela au fali na, au hambu bunan. Mae kada fak boe oo, malole.’ ");
INSERT INTO llg_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Boe ma manek ndia nadenu hataholi feꞌe kala lai ndia, nae, ‘Haꞌi mala ndia doin ndia, fo feen neu hataholi mana tao ues fo ana hambu doik kasanahulu isinaak ndia.’ ");
INSERT INTO llg_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Tehuu ala sapa, lae, ‘Ama! Hataholi ndia hambu dai ndia so. Hatina de nau haꞌi nala hataholi fo enan fak, fo fee nakadai kana neu ndia bali? ");
INSERT INTO llg_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Tehuu manek ndia nataa, nae, ‘Duduꞌa neulalau! Huu hataholi fo malelak mana makaneni hata, fo hataholi lamahelen so, dei fo ana hambu nakadaik bali. Tehuu hataholi mbelatua nakaneni, na, dei fo ala haꞌi labasa hata fo ndia enan. ");
INSERT INTO llg_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Naa! Hatematak ia, ei miu humu mala au musu nggala fo taa hii au dadik manek nai ia. Mia sala leni ia mai, fo basa na, tao misa sala neu au matang. Miu leo!” ");
INSERT INTO llg_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesus tui basa boe ma, ala laꞌo lakandoo leni Yerusalem leu. Yesus laꞌok nakahuluk. ");
INSERT INTO llg_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ledoeik fo ala deka-deka lo nggolok dua, fo ndia Betfage ma Betania, fo nai lete Saitun bifin, boe ma Ana nadenu Ndia ana mana tungga nala dua, fo ala laꞌok lakahuluk. ");
INSERT INTO llg_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Ana nadenu sala, nae, “Ei dua nggei mini nggolok manai mata ele miu. Dei fo ei mita banda keledei maneanak esa nanambaꞌak nai ndia. Hataholi bei ta saꞌe lita kana. Ei sefi heni talin, fo hela minin neni ia mai. ");
INSERT INTO llg_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Tehuu mete ma hambu hataholi natane, nae, ‘Hatina de ei sefi heni banda keledei ndia talin?’ na mafada sala mae, ‘Ai Lamatuan sangga paken.’ ” ");
INSERT INTO llg_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Boe ma dua sala leu, de latonggo lo banda keledei maneanak ndia, fo sama leo Yesus kokolan ndia. ");
INSERT INTO llg_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ledoeik ala sefi heni banda keledei maneanak ndia talin, boe ma maenak natane sala, nae, “Hatina de ei mboꞌi heni banda ia?” ");
INSERT INTO llg_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Boe ma lataa, lae, “Ai Lamatuan sangga paken.” ");
INSERT INTO llg_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Mabanda keledei maneanak ndia simbok no malole, de dua sala hela leni banda keledei maneanak ndia neni Yesus neu. Ala bela sila lafa naluse nala, neu banda keledei maneanak ndia dean. Boe ma ala lakasasaꞌek Yesus neni lain neu. ");
INSERT INTO llg_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Hataholi noꞌu kala, ala haꞌi lala lafa naluse nala, ma, lafa ana nala, de ala belan neu dalak, fo soluk Yesus sama leo ala simbok hataholi inahuuk ia. ");
INSERT INTO llg_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ledoeik Ana mulai konda neme lete Saitun mai, boe ma hataholi noꞌu kala lo Ndia ana mana tungga nala, mulai eki koa-kio Manetualain, huu lita basa tanda koasan ndia so. ");
INSERT INTO llg_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ala eki lae, “Ndia ia, Manek fo Manetualain nadenun mai! Manetualain feen babaꞌe-babatik neu Ndia! Hatematak ia, hataholi bisa dame lo Lamatuak nai nusa-sodak. Koa-kiok neu Lamatuak fo mana manggatuuk toꞌu palenda nai lalai fo deman ana seli.” ");
INSERT INTO llg_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Tehuu hambu hataholi Farisi nai hataholi la sila lalada nala. Ala lafada Yesus, lae, “Ama Mesen! Kaꞌi sala fo boso ala eki leo ndiak, huu ia ana seli ia, maa!” ");
INSERT INTO llg_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Tehuu Yesus nataa, nae, “Heh! Au afada memak! Mete ma hataholi la ia, seu bafa nala, na dei fo batu la koa-kio Lamatuak!” ");
INSERT INTO llg_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Faik fo ala deka-deka maso Yerusalem leu, boe ma Yesus nita kota ndia, de namatani, ");
INSERT INTO llg_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","nae, “Awii, hataholi Yerusalem aa! Au nau fo faik ia, ei simbok mole-dame, fo Au unik ia. Tehuu, ei taa mbali Lamatuak, de hatematak ia seli heni fain so. De, mole-dame ndia, dook no ei so. ");
INSERT INTO llg_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Dei fo ei musu mala fua dae ndule kota tembon, fo basa na, ala maso mai sambu ei. ");
INSERT INTO llg_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ala tao latuꞌu heni ei kotam ndia bebelak no dae, fo basa na, ala tao lisa ei, ma basa ei ana mala. Ala taa ela batu esa nambadeik boe, huu Lamatuak mai so, fo Ana nau fee ei sodak, tehuu ei taa malelak Ndia!” ");
INSERT INTO llg_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Basa boe ma Yesus maso neni Uma Ina Huhule-haladoik pasan neu, fo hataholi la taon dadik neu pasak so, fo laseꞌo banda tunu-hotuk. Nita leo ndia, boe ma Yesus mulai husi heni sala leme ndia mai. ");
INSERT INTO llg_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ana nasapala kasa nae, “Lamatuak mana kokola nala sulak mema kana so, nae, ‘Au ambadedei Uma ia, fo basa hataholi la, bisa mai hule-haladoi lai ia.” Tehuu, ei taon dadik neu mana mamoa la mamana nakabubuan.” ");
INSERT INTO llg_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Basa ndia, boe ma tungga-tungga faik Yesus neni Uma Ina Huhule-haladoik neu, fo nanoli nai ndia. Tehuu malangga anggama Yahudi la malangga nala, mese anggama la, ma lasi hada Yahudi la, sangga dalak, fo ala tao lisa Ndia. ");
INSERT INTO llg_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Tehuu ala taa hambu dalak, huu hataholi noꞌu kala sila, lamahoko lamanene Yesus kokolan. ");
INSERT INTO llg_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Faik esa, Yesus neni Uma Ina Huhule-haladoik neu, boe ma Ana nanoli Hala Malole nai uma ndia pasan. Boe ma malangga anggama Yahudi malangga nala, mese anggama la, ma lasi-lasi hada kala mai latane Ndia. ");
INSERT INTO llg_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ala latane, lae, “See fee O hak, de afik O mai tao nahuuk nai ia? Hena mafada ai dei!” ");
INSERT INTO llg_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Boe ma Yesus nataa, nae, “Au boe oo, sangga atane dedeꞌak esa, fo basa, na, bei fo Au ataa ei. ");
INSERT INTO llg_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Leo iak: ei malelak Yohanis Mana Salanik, hetu? See feen koasa, fo ana salani hataholi la? Manetualain do hataholi?” ");
INSERT INTO llg_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Boe ma lakokola leu-mai, de lae, “Awii! Ita soꞌe talan ia so maa. Mete ma ita tae, ‘Manetualain ndia nadenu,’ na dei fo Ana bala nae, ‘Mete ma leo ndiak, na hatina, de ei taa mamahele Yohanis ndia?’ ");
INSERT INTO llg_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Tehuu ita boe taa bisa tae, ‘hataholi nadenu’, huu dei fo hataholi la ia haꞌi batu, fo, mbia lisa ita. Huu ala lamahele, lae, Yohanis ndia, na, Lamatuak mana kokolan.” ");
INSERT INTO llg_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Basa de ala lataa Yesus lae, “Ai taa bubuluk.” ");
INSERT INTO llg_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Boe ma Yesus bala nae, “Mete ma leo ndiak, na Au boe oo, taa nau afada ae, see ndia nadenu Au.” ");
INSERT INTO llg_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Basa boe ma, Yesus tui hataholi noꞌu kala sila, nakandandaak esa bali, nae, “Hambu hataholi esa, sele nai osi anggol. Ana fee hataholi mana tao osi la seba osin ndia, fo labaꞌe buna-boan. Boe ma ana huꞌa neni nusa dea neu, fo leo nala dook nai ele. ");
INSERT INTO llg_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Losa fai ketu anggol boak, boe ma maosik ndia, nadenu ndia hataholi mana tao ues esa neu simbo ndia babaꞌen neme mana seba osi la ndia. Tehuu mana seba osi la sila mbomboko maosik hataholi mana tao ues ndia, de basa boe ma ala husi henin, de ana fali no lima louk. ");
INSERT INTO llg_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Basa de maosik haitua seluk ndia hataholi mana tao ues esa bali. Tehuu mana seba osi la mbombokon, ma lakamamae kana. Basa de, ala husi fali kana no lima louk. ");
INSERT INTO llg_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Boe ma maosik ana haitua seluk ndia hataholi mana tao ues katelun neu, tehuu ala mbomboko lahinan, boe ma ala mbia henin neni mbaꞌa deak neu. ");
INSERT INTO llg_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Maosik ndia duduꞌa-duduꞌa nae, ‘Au musi tao leobee bali? Malolenak au haitua au ana susueng neu. Neu ko ala feen hadak ma ala simbo kana no malole.” De ana haitua ana bonggin neni ele neu. ");
INSERT INTO llg_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Tehuu ledoeik mana seba osi la litan, boe ma ala lakokola lae, ‘Wei, ei mita dei! Huu toulasik haitua ndia ana hehelin mai. Ndia ndia, dei fo ana simbo basa toulasik pusaka nala. De mai fo ita tao tisan leo, suek ita hambu osi ia leo. ");
INSERT INTO llg_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ledoeik kakanak ndia ana losa, boe ma ala hela loloson, neni osi deak neu, de ala tao lisan. Au sangga atane leo iak: ei duduꞌam, na maosik ana sangga tao leobee neu hataholi mana seba osi sila? ");
INSERT INTO llg_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Tungga Au, na, neu ko maosik ana mai fo tao nisa basa sala, fo basa na, ana fee hataholi feꞌek ala seba osi ndia.” Ledoeik hataholi la lamanene Yesus kokolan leo ndia, boe ma ala lataa, lae, “Mete ma bisa, na, Manetualain boso huku ai leo ndiak!” ");
INSERT INTO llg_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Basa de Yesus suli nakabubulak neu sala, boe ma natane, nae, “Mete ma taa huku leo ndiak, na, hatina de Lamatuak mana kokola nala ala sulak so, lae leo iak: ‘Batu esa fo tuka nala nggali henin so, tehuu hatematak ia, ana dadik neu dii inak batu neten so?’ ");
INSERT INTO llg_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Hataholi fo nakatunu neu batu ndia, na, neu ko nakalulutuk, huu ana hambu huhukuk. Ma, mete ma batu ndia ana tuda laꞌe hataholi, na, ndia boe oo, nakalulutuk nalan seli, huu ana laꞌe huhukuk. ");
INSERT INTO llg_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Faik fo mese anggama ma malangga anggama la malanggan lamanene tutuik ndia, de ala bubuluk, lae, Yesus uku bebeik sila, nenik nakandandaak ndia. Sila sama tetebes leo mana seba osi sila. De ala luli lalan seli. Boe ma ala heti kekedik fo sangga humu Ndia. Tehuu ala bii hataholi noꞌu kala fo lahiik Yesus nanonoli nala. De, ala laꞌo elan leo. ");
INSERT INTO llg_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Basa, boe ma Yesus musu nala ala malok Ndia. Ala sangga hataholi mana memete-mamaku kala fo bisa tao ao nala leo hataholi malalaok, fo leu lakahiak Yesus. Ala lamahena fo Yesus bisa kokolak laban mana toꞌu palenda Roma, fo basa na, leu lapor gubenol, fo suek ladenu hataholi la leu humu Yesus. ");
INSERT INTO llg_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Boe ma ala haitua mana memete-mamakuk, fo ala leu latane Yesus, lae, “Ama Mesen! Ai bubuluk Ama dalen ndoos. Ama taa nalelak pepekok, ma taa mete matak. Ama manoli Manetualain Dedeꞌa-kokolan no teteben. ");
INSERT INTO llg_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Hatematak ia, ai sangga matane dedeꞌak esa: tungga ita anggama Yahudi heti-heun na, meda ita bole bae bea neu mana toꞌu palenda Roma mane inahuun do taa?” ");
INSERT INTO llg_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Tehuu Yesus bubuluk sila maksud manggalaun fo sangga ala teꞌek Ndia. Boe ma Ana nataa, nae, ");
INSERT INTO llg_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Soba matudu Au doi lilo fulak esa dei.” Boe ma ala latudu doik ndia neu Ndia. Basa de Ana natane, nae, “See mata-aon ia?” Ma see naden ia?” Ala lataa, lae, “Ndia mane inahuuk Kesel.” ");
INSERT INTO llg_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Boe ma Yesus nae, “Mete ma leo ndiak, na, fee mana toꞌu palenda hata fo sila hak. Ma fee Manetualain hata fo Ndia hak.” ");
INSERT INTO llg_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Lamanene leo ndia, boe ma ala heran lalan seli, huu ala taa bisa teꞌek lala Ndia nai hataholi noꞌu kala matan. Boe ma ala lakatema bafa nala leo. ");
INSERT INTO llg_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Basa ndia, boe ma hataholi luma leme partei anggama Saduki mai fo ala sangga teꞌek Yesus. Hataholi Saduki la lanoli lae hataholi kamate kala taa lasoda fali so, nai daebafok babasan. Ala mai latane Yesus, lae, ");
INSERT INTO llg_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Ama Mesen! Baꞌi Musa sulak ela ita heti-heun so, nae, mete ma hambu touk mate, tehuu ana tak, na, hataholi ndia fadin musi sao mbalu nala ina falu ndia, fo suek ana fee numbu saduk neu kaꞌan mana matek ndia so. ");
INSERT INTO llg_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Memak makahulun baꞌi Musa nanoli leo ndiak. Tehuu hatematak ia, ai sangga matane leo iak: hambu touk hitu tolanoo bonggi kala. Kaꞌak sao, tehuu maten, ma ana tak. ");
INSERT INTO llg_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Boe ma fadin mana tungga ndia, sao mbalu nala ina falu ndia. Taa dook tehuu ndia maten boe, tehuu ana taa. ");
INSERT INTO llg_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Leo ndiak boe, no fadi katelun. Ana sao mbalu nala ina falu ndia bali, tehuu ndia boe oo, maten, tehuu ana taa boe. Leo ndiak nakandondoo henin, losa fadi mateꞌa teisusuk ndia maten boe. ");
INSERT INTO llg_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Boe ma ina falu ndia maten boe. ");
INSERT INTO llg_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Naa! Hatematak ia, ai sangga matane leo iak: inak ndia sao nitak touk hitu so. Dei fo mete ma daebafok basan, fo Lamatuak tao nasoda falik hataholi mana mate kala, na, inak ndia sao teteben ndia see?” ");
INSERT INTO llg_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Boe ma Yesus nataa, nae, “Hataholi kada lasaok lai daebafok. ");
INSERT INTO llg_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","36","Tehuu dei fo nai nusa-sodak na, hataholi la taa lasaok so. Ma nai ele, na ala taa mate so. Ala sama leo Manetualain ata nusa-soda nala. Huu faik fo Manetualain tao nasoda falik hataholi mana mate kala, na, Ana hele nala sala fo dadik neu Ndia ana nala. ");
INSERT INTO llg_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Nai baꞌi Musa susulan, na, hambu tutuik laꞌeneu, ai kadiꞌik haꞌi naꞌan tehuu taa kaden. Neme tutuik ndia mai, na, ita bubuluk hataholi mate tehuu bisa nasoda fali. Nai ndia, Manetualain nafada baꞌi Musa, nae, “Au ia, o baꞌi-baꞌi mala Manetualain. Fo ndia, baꞌi Abraham, baꞌi Isak, ma baꞌi Yakob. Sila basa sala lakaluku-lakatele neu Au, losa hatematak ia.” ");
INSERT INTO llg_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Naa te baꞌi la sila mate sala so neme makahulun mai. Tehuu Manetualain nafada so, nae, Ndia bei dadik sila Lamatuan, huu ndia de ita bubuluk tae, sila bei kasodak. Huu, kada hataholi kasodak bisa nakaluku-nakatele neu Manetualain, tehuu taa hataholi kamatek, hetu?!” ");
INSERT INTO llg_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Lamanene Yesus nataa leo ndia, boe ma, mese anggama esa kokolak nae, “Ama Mesen natataan ndia, teteben ana seli.” ");
INSERT INTO llg_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Mulai neme faik ndia mai boe oo, taa hambu hataholi esa nambalani natane bali, huu taa hambu hataholi ana bisa teꞌek nala Ndia. ");
INSERT INTO llg_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Basa ndia, boe ma Yesus bei nanoli hataholi la sila, nai Uma Ina Huhule-haladoik. Boe ma Ana natane nasafali sala, nae, “Tungga ei duduꞌa mala, na, leobee? Mese anggama la lanoli, na, lae Karistus ndia na ndia Hataholi fo Manetualain tudu mema kana so neme lele uluk, mai. Tungga sila, na, Ndia kada dadik mane Dauk tititi-nonosin. Tehuu ndia bei ta dai. ");
INSERT INTO llg_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Huu makahulun, mane Dauk mesa kana sulak nai susula Sosodak Koa-kio kala, nae, ‘Manetualain nafada au Lamatuang, nae, “Mai fo manggatuuk muu mamana nana hadak, nai Au boboa konang. ");
INSERT INTO llg_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Huu dei fo Au tao O musu mala, losa ala doꞌok neu O.’ ” ");
INSERT INTO llg_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Neme susulak ndia mai, ita bubuluk, tae, mane Dauk mesa kana noke Karistus ndia, na nae, ‘Lamatuak’, na ndia ndandaan, mete ma hataholi la lae, Karistus ndia, kada mane Dauk tititi-nonosin, na ndia bei ta dai! Huu Ndia boe oo, dadik mane Dauk Lamatuan!” ");
INSERT INTO llg_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ledoeik basa hataholi la pasak ndiꞌidook, fo lamanene Yesus, boe ma Ana kokolak no Ndia ana mana tungga nala, nae, ");
INSERT INTO llg_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Ei musi mata neuk neu mese anggama la. Huu ala lahiik lalaꞌok pake badu naluk mana mbembek, fo leu latonggo lo hataholi noꞌu kala, fo suek hataholi la lita sala, na lae, ‘Wei! Sila ndia, hataholi inahuuk, bou!’ Ala lahiik sangga mamanak nana hadak ana seli, nai uma huhule-haladoi kala, nai feta, ma nai mamanak fo hataholi la lateme lakabubua. ");
INSERT INTO llg_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Tehuu mata neuk, huu ala lambue pepeko lala ina falu la, fo lamoa lala sila uma nala. Tehuu nai hataholi la matan, na, ala lafuni sila manggalau nala ndia, ma ala lambadeik hule-haladoi lala dook. Ala nau fo, hataholi la lae sila, hataholi malalaok. Tehuu Lamatuak bubuluk sila sala nala, de dei fo Ana huku sala mabela nalan seli.” ");
INSERT INTO llg_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Faik fo Yesus nanoli nai Uma Ina Huhule-haladoik, nita hataholi kamasuꞌi kala tao doi kolete neni peti derma dalek neu. ");
INSERT INTO llg_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ndia boe oo, nita ina falu hata taak esa, ana mai tungga hule-haladoik. Ana nanggodi doik sen dua neni peti ndia neu. Doik ndia belin kada fa anak nalan seli. ");
INSERT INTO llg_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Basa de Yesus kokolak no Ndia ana mana tungga nala nae, “Mamanene neulalau! Ina falu hata taak ia, nanggodi doik kada sen duak, tehuu ana fee lena heni basa hataholi la so. ");
INSERT INTO llg_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Hataholi feꞌe kala sila langgodi doi kolete neme kada sila doi sisa nala. Tehuu ina falu ia, fee basa ndia doi nala. Naa te, doik ndia, na ndia doin fo nasoda nenik.” ");
INSERT INTO llg_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Faik ndia, Yesus ana mana tungga nala, kokolak koa Uma Ina Huhule-haladoik, lae, “Ama! Mete sudik Uma ia neulaun ana seli maa! Ala taon nenik batu-batu nana tatik inahuuk ana seli, basa de ala lakatotodok lalan mandaa hiak. Ma hambu hataholi la fee bua mabeli fo heuneu Lamatuak Uman ia!” Tehuu Yesus nataa, nae, ");
INSERT INTO llg_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Uma ia memak malole. Tehuu taa dook, huu hataholi la, tao latuꞌu heni basa batu la ia, losa bebelak no dae.” ");
INSERT INTO llg_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Basa de Yesus ana mana tungga nala latane, lae, “Ama Mesen! Hata fo Ama kokolak isinaak ndia, meda dadi nai faik bee ndia? Mete ma fain dekak so, na, dei fo ndia tanda nala leobeek?” ");
INSERT INTO llg_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Boe ma Yesus nataa, nae, “Sadi ei manea matalolole, fo boso ei nana kedi nalak. Huu dei fo hambu hataholi mata-mata kala mai, fo bamba kala nala, lae, ‘Au ia Karistus.’ Luma boe lae, ‘Fai daebafok babasan deka-deka mai so!’ Tehuu boso mamahele! ");
INSERT INTO llg_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Mete ma ei 