﻿USE sofia;
DROP TABLE IF EXISTS sofia.litb_vpl;
CREATE TABLE litb_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES litb_vpl WRITE;
INSERT INTO litb_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Jau parašyta keletas Kristaus biografijų, kurių šaltinis – pasakojimai, paplitę tarp mūsų iš pirmųjų mokinių ir kitų liudininkų, mačiusių Kristų, lūpų, ");
INSERT INTO litb_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Tačiau man pasirodė, kad gerai būtų patikrinti visus iki vieno aprašymus ir, kruopščiai patyrinėjus, pateikti tau santrauką, ");
INSERT INTO litb_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","kad įtikėtum tiesa, kurios buvai mokomas. ");
INSERT INTO litb_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Savo pasakojimą pradėsiu nuo žydų kunigo Zacharijo. Jis gyveno tada, kai Judėją valdė Erodas, Zacharijas buvo šventyklos tarnų Abijo skyriaus narys. Jo žmona Elzbieta buvo kilusi iš Aarono palikuonių, ir taip pat kaip Zacharijas priklausė žydų kunigų luomui. ");
INSERT INTO litb_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Jie buvo dievobaimingi žmonės, ir stropiai laikėsi visų Dievo įsakymų. ");
INSERT INTO litb_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Tačiau jie neturėjo vaikų, nes Elzbieta buvo nevaisinga, ir abu jau buvo labai seni. ");
INSERT INTO litb_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Vieną budėjimo savaitės dieną, kai Zacharijas šventykloje vykdė savo pareigas, burtų keliu jam teko garbė smilkyti Dievo šlovei šventyklos viduje. ");
INSERT INTO litb_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Tuo tarpu didelė minia meldėsi šventyklos kieme, kaip buvo įprasta smilkymo metu, ");
INSERT INTO litb_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","12","Zacharijas buvo šventykloje, kai staiga smilkalų altoriaus dešinėje pasirodė angelas! Zacharijas apstulbo ir išsigando, ");
INSERT INTO litb_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Tačiau angelas pasakė: „Nebijok, Zacharijau, aš atėjau pranešti, kad Dievas išklausė jūsų maldą, ir tavo žmona Elzbieta pagimdys sūnų. Pavadink jį Jonu. ");
INSERT INTO litb_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Jūs abu turėsite daug džiaugsmo ir malonumų jam gimus, ir daugelis džiaugsis kartu su jumis. ");
INSERT INTO litb_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Jis bus vienas iš didžiųjų Dievo žmonių. Jam nebus galima gerti vyno ar kurio kito svaiginančio gėrimo – jis bus kupinas Šventosios Dvasios dar savo motinos įsčiose. ");
INSERT INTO litb_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Jis įkalbės daugelį žydų grįžti prie Dievo. ");
INSERT INTO litb_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Jis bus tvirtos dvasios ir galingas vyras kaip Elijas, senovės pranašas, ir paruoš kelią Mesijui, parengs žmones Jo atėjimui. Jis sušvelnins suaugusiųjų širdis, kad jos taptų panašios į mažų vaikų širdeles, o neklusniųjų mintis pakeis į tikėjimo išmintį.“ ");
INSERT INTO litb_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zacharijas tarė angelui: „Bet tai neįmanoma. Aš jau senas, o mano žmona irgi metuose.“ ");
INSERT INTO litb_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Atsakydamas angelas jam tarė: „Aš esu Gabrielius. Aš stoviu Dievo akivaizdoje. Tai Jis mane pasiuntė tau pranešti gerąją žinią! ");
INSERT INTO litb_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","O dabar, kadangi tu nepatikėjai, neteksi kalbos, kol gims kūdikis, Mano žodžiai išsipildys reikiamu laiku.“ ");
INSERT INTO litb_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Tuo tarpu minios žmonių laukė, kada pasirodys Zacharijas, ir stebėjosi, kodėl jis taip ilgai užtruko. ");
INSERT INTO litb_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kai jis pagaliau išėjo, negalėjo kalbėti. Iš Zacharijo judesių žmonės suprato, kad jis matė šventykloje regėjimą. ");
INSERT INTO litb_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Likusias budėjimo dienas jis ėjo savo pareigas šventykloje, o po to grįžo namo. ");
INSERT INTO litb_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Netrukus jo žmona Elzbieta tapo nėščia ir slėpėsi penkis mėnesius. ");
INSERT INTO litb_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","„Koks geras Viešpats, – sakė ji, – kad panaikino tą mano negarbę!“ ");
INSERT INTO litb_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Kitą mėnesį Dievas pasiuntė angelą Gabrielių į Nazaretą, kaimą Galilėjoje, ");
INSERT INTO litb_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","pas mergelę Mariją, susižiedavusią su Juozapu, vyru iš karaliaus Dovydo giminės. ");
INSERT INTO litb_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Gabrielius, pasirodęs jai, tarė: „Sveika, malonėmis apdovanotoji, Dievas su tavimi!“ ");
INSERT INTO litb_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Tai išgirdusi, Marija sutriko ir nusigando, Ji stengėsi suprasti, kas slypi angelo žodžiuose. ");
INSERT INTO litb_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","„Nebijok, Marija, – pasakė jai angelas, – Dievas nusprendė tave nuostabiai palaiminti. ");
INSERT INTO litb_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Labai greitai tu tapsi nėščia ir pagimdysi Sūnų. Tu Jį pavadinsi Jėzumi. ");
INSERT INTO litb_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Jis bus didis žmogus ir vadins Jį Dievo Sūnumi. ");
INSERT INTO litb_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Visagalis Dievas suteiks tavo Sūnui Jo tėvo Dovydo sostą, Jis amžinai valdys Izraelį, ir Jo karalystė niekada nesibaigs!“ ");
INSERT INTO litb_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Marija paklausė angelą: „Kaip aš galiu pagimdyti kūdikį? Aš esu mergaitė ir nepažįstu vyro.“ ");
INSERT INTO litb_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Angelas atsakė: „Šventoji Dvasia aplankys tave, ir Dievo galybė pridengs tave Savo šešėliu, todėl gimęs berniukas bus visiškai šventas ir vadinsis Dievo Sūnumi. ");
INSERT INTO litb_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Štai tavo teta Elzbieta – „nevaisingoji“, kaip ją vadino, prieš pusmetį tapo nėščia senyvame amžiuje. ");
INSERT INTO litb_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Dievas išpildo kiekvieną Savo pažadą.“ ");
INSERT INTO litb_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Marija pasakė: „Štai aš – Viešpaties tarnaitė, trokštu tarnauti Jam taip, kaip Jis to nori. Tegul viskas, ką pasakei, išsipildo.“ Ir tada angelas pranyko. ");
INSERT INTO litb_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Po kelių dienų Marija išskubėjo į Judėjos kalnus, miestelį, kur gyveno Zacharijas, aplankyti Elzbietos. ");
INSERT INTO litb_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Kai Marija pasveikino Elzbietą, suspurdėjo kūdikis Elzbietos įsčiose, ir ją aplankė Šventoji Dvasia. ");
INSERT INTO litb_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ji džiugiai sušuko Marijai: „Tu labiausiai palaiminta iš visų moterų – tavo Sūnus vertas Dievo išaukštinimo. ");
INSERT INTO litb_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Iš kur man ta garbė, kad Viešpaties motina aplanko mane? ");
INSERT INTO litb_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Kai tu įėjai ir pasveikinai mane, kai aš išgirdau tavo balsą, iš džiaugsmo suspurdėjo kūdikis mano įsčiose! ");
INSERT INTO litb_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Tu įtikėjai, kad Viešpats tesės Savo pažadą, todėl Jis nuostabiai palaimino tave.“ ");
INSERT INTO litb_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Marija atsakė: „Kaip aš šlovinu Viešpatį! ");
INSERT INTO litb_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Aš džiaugiuosi Viešpačiu, savo Gelbėtoju, ");
INSERT INTO litb_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","nes Jis pažvelgė į Savo nuolankią tarnaitę. Štai nuo dabar visos kartos vadins mane Dievo palaimintąja, ");
INSERT INTO litb_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","nes didžiais dalykais apdovanojo mane Visagalis. ");
INSERT INTO litb_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Jo gailestingumas neaplenkia nė vieno, kuris Jam paklūsta. ");
INSERT INTO litb_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Kokia galinga Jo ranka! Jis išblaško išdidžiuosius išpuikėlius, ");
INSERT INTO litb_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","nuverčia nuo sostų galiūnus ir išaukština žemesniuosius. ");
INSERT INTO litb_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Jis pasotina išalkusias širdis, o turtuolius tuščiomis paleidžia. ");
INSERT INTO litb_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","O kaip Jis padėjo Savo tarnui Izraeliui! Jis neužmiršo Savo pažado, ");
INSERT INTO litb_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","nes pažadėjo mūsų tėvams – Abraomui ir jo vaikams – amžiną gailestingumą.“ ");
INSERT INTO litb_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Marija paviešėjo pas Elzbietą apie tris mėnesius ir grįžo į savo namus. ");
INSERT INTO litb_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Tuo metu atėjo laikas gimti Elzbietos kūdikiui, ir ji pagimdė sūnų. ");
INSERT INTO litb_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Žinia, koks Viešpats jai gailestingas, greitai pasklido po kaimynus ir gimines, ir visi sveikino ją. ");
INSERT INTO litb_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Kai kūdikiui suėjo aštuonios dienos, visi giminės ir draugai susirinko į apipjaustymo ceremoniją. Jie visi nusprendė, kad berniuko vardas bus Zacharijas, kaip ir jo tėvo. ");
INSERT INTO litb_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Bet Elzbieta pasakė: „Visai ne! Jis turi būti pavadintas Jonu!“ ");
INSERT INTO litb_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","„Kaip? – stebėjosi šie. – Juk visoje jūsų giminėje nerasi vyro tokiu vardu.“ ");
INSERT INTO litb_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Tada jie ženklais paklausė kūdikio tėvą, kokį vardą jis nori duoti berniukui. ");
INSERT INTO litb_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Tasai pasiekė skiautę popieriaus ir visų nustebimui užrašė: „Jo vardas Jonas!“ ");
INSERT INTO litb_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Tuojau pat Zacharijas atgavo kalbą ir ėmė garbinti Dievą. ");
INSERT INTO litb_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Žinia apie stebuklą pasklido ne tik po visą kaimyninę apylinkę, bet ir Judėjoje. ");
INSERT INTO litb_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Visi, kas girdėjo šią naujieną, ilgai svarstė: „Įdomu, kuo taps šis vaikas, kadangi Viešpats jį globoja ypatingai.“ ");
INSERT INTO litb_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Tada jo tėvą Zachariją aplankė Šventoji Dvasia ir jis pranašavo: ");
INSERT INTO litb_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","„Šlovinkite Viešpatį, Izraelio Dievą, kadangi Jis aplankė Savo tautą ir atnešė jai išgelbėjimą. ");
INSERT INTO litb_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Jis siunčia mums galingą Gelbėtoją iš Savo tarno Dovydo karališkosios giminės, ");
INSERT INTO litb_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","kaip seniau buvo žadėjęs per šventuosius pranašus, ");
INSERT INTO litb_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Kuris išgelbės mus nuo priešų, nuo visų, kas mūsų nekenčia. ");
INSERT INTO litb_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","Jis buvo gailestingas mūsų protėviams, pačiam Abraomui, prisimindamas jam duotą šventą pažadą, jog leis mums, ");
INSERT INTO litb_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","išvaduotiems iš priešų rankos, tarnauti Dievui be baimės ");
INSERT INTO litb_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","per visą gyvenimą šventumu ir teisumu Jo akivaizdoje. ");
INSERT INTO litb_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","O tu, sūneli, vadinsiesi Aukščiausiojo pranašu, nes eisi paruošti kelią Mesijui. ");
INSERT INTO litb_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Tu mokysi žmones pažinti išgelbėjimą iš nuodėmių atleidimo. ");
INSERT INTO litb_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Tai įvyks dėl mūsų gailestingojo Dievo malonės, ir jau netruks nušvisti dangaus aušra, ");
INSERT INTO litb_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","kad paliestų sėdinčius tamsybėse ir mirties ūksmėje, kad palydėtų mus į ramybės kelią.“ ");
INSERT INTO litb_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Mažasis berniukas labai mylėjo Dievą. Kai jis užaugo, atsiskyręs gyveno dykumoje, kol pradėjo tarnauti Izraeliui. ");
INSERT INTO litb_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Apie tą laiką Romos imperatorius Cezaris Augustas paskelbė privalomą visos tautos gyventojų surašymą. ");
INSERT INTO litb_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Šis surašymas vyko, kai Siriją valdė Kvirinas. ");
INSERT INTO litb_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Visi privalėjo registruotis savo protėvių namuose. ");
INSERT INTO litb_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Kadangi Juozapas buvo iš karališkos giminės, jam reikėjo vykti į Betliejaus miestą Judėjoje, į senuosius karaliaus Dovydo namus. Jis keliavo iš Galilėjos kaimelio Nazareto. ");
INSERT INTO litb_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Jis pasiėmė drauge savo sužadėtinę Mariją, kuri buvo nėščia. ");
INSERT INTO litb_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ten ir atėjo metas gimdyti; ");
INSERT INTO litb_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Marija pagimdė pirmagimį Sūnų, suvystė ir paguldė ėdžiose, kadangi jiems miestelio užeigose neatsirado vietos. ");
INSERT INTO litb_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Tą naktį keletas piemenų laukuose ganė avis. ");
INSERT INTO litb_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Staiga tarp jų pasirodė angelas ir aplinkui viskas nušvito dangaus šviesa. Piemenys labai išsigando, ");
INSERT INTO litb_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","bet angelas juos nuramino. „Nebijokite! – tarė jis. – Aš skelbiu jums pačią linksmiausią naujieną, kuri skirta kiekvienam žmogui! ");
INSERT INTO litb_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Šią naktį Betliejuje gimė Išgelbėtojas – Viešpats ir Mesijas! ");
INSERT INTO litb_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Kaip jūs atpažinsite Jį? Jūs rasite Kūdikį, suvystytą ir paguldytą ėdžiose!“ ");
INSERT INTO litb_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Tuojau pasirodė daugybė kitų angelų – dangiškoji kariuomenė, kuri garbino Dievą giedodama: ");
INSERT INTO litb_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","„Šlovė Dievui aukštybėse, o žemėje ramybė Jo mylimiems žmonėms!“ ");
INSERT INTO litb_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Kai šis didžiulis būrys angelų grįžo į dangų, piemenys sakė vieni kitiems: „Eime į Betliejų! Ten pamatysime šį nuostabų dalyką, apie kurį mums Viešpats yra paskelbęs.“ ");
INSERT INTO litb_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Jie nuskubėjo į kaimą pas Mariją ir Juozapą. Ėdžiose gulėjo Kūdikis. ");
INSERT INTO litb_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Piemenys pasakojo visiems, ką angelas buvo sakęs jiems apie Vaikelį. ");
INSERT INTO litb_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Visi, kurie girdėjo piemenų pasakojimą, labai stebėjosi. ");
INSERT INTO litb_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Marija saugojo šituos dalykus širdyje ir dažnai juos apmąstydavo. ");
INSERT INTO litb_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Piemenys grįžo į laukus prie savo bandų, dėkodami Dievui už angelų apsilankymą ir už tai, kad pamatė Vaikelį, kaip angelas jiems buvo sakęs. ");
INSERT INTO litb_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Po aštuonių dienų, apipjaustymo ceremonijos metu, berniukas buvo pavadintas Jėzumi. Šį vardą angelas davė dar Kūdikiui nesant įsčiose. ");
INSERT INTO litb_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Kai atėjo Marijos aukos šventykloje laikas, po vaiko gimimo, kaip reikalavo Mozės įstatymai, tėvai nunešė Jį Jeruzalėn aukoti Dievui, ");
INSERT INTO litb_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","nes tame įstatyme Viešpaties pasakyta: „Kiekvienas moters pirmagimis berniukas turi būti pašvęstas Viešpačiui.“ ");
INSERT INTO litb_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ta pačia proga Jėzaus tėvai atnašavo „porą balandžių burkuolių arba du jauniklius karvelius“, kaip buvo reikalaujama įstatyme. ");
INSERT INTO litb_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Tą dieną šventykloje buvo Jeruzalės gyventojas, vardu Simeonas. Tai buvo geras ir dievobaimingas žmogus, kupinas Šventosios Dvasios ir nuolat laukiantis Mesijo pasirodymo. ");
INSERT INTO litb_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Šventoji Dvasia jam buvo apreiškusi, kad jis nemirs, kol pamatys Jį – Dievo pateptąjį Karalių. ");
INSERT INTO litb_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Šventoji Dvasia paskatino jį nueiti į šventyklą. Tą dieną, kai Marija su Juozapu atnešė Jėzų, ");
INSERT INTO litb_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeonas buvo ten ir, paėmęs Vaikelį į savo rankas, šlovino Dievą: ");
INSERT INTO litb_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","„Dabar, Viešpatie, aš jau galiu ramus mirti! ");
INSERT INTO litb_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Aš Jį pamačiau, kaip buvai žadėjęs. Aš pamačiau Išgelbėtoją, ");
INSERT INTO litb_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","kurį Tu davei pasauliui. ");
INSERT INTO litb_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Jis – toji Šviesa, kuri švies tautoms, ir Jis bus Tavo tautos, Izraelio, žmonių garbė!“ ");
INSERT INTO litb_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Juozapas ir Marija stovėjo stebėdamiesi tuo, kas buvo sakoma apie Jėzų. ");
INSERT INTO litb_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeonas palaimino juos ir tarė Marijai: „Kalavijas persmeigs tavo sielą, nes šį Kūdikį Izraelyje daugelis paniekins savo pačių pražūčiai. ");
INSERT INTO litb_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Bet daugybei kitų Jis bus pats didžiausias džiaugsmas ir atsiskleis slapčiausios jų širdžių godos.“ ");
INSERT INTO litb_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Tą dieną šventykloje buvo ir pranašė Ona. Ji buvo iš Asero giminės, Fanuelio duktė. Moteris buvo sena, nes po septynerių vedybinio gyvenimo metų jau našlavo aštuoniasdešimt keturis metus. ");
INSERT INTO litb_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ji niekada nepasitraukdavo iš šventyklos, dieną ir naktį garbindavo Dievą melsdamasi ir dažnai pasninkaudama. ");
INSERT INTO litb_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ji priėjo, kai Simeonas kalbėjo su Juozapu ir Marija, ir taip pat pradėjo dėkoti Dievui ir pasakoti Jeruzalėje visiems, kurie laukė Išgelbėtojo, kad Mesijas pagaliau atėjo. ");
INSERT INTO litb_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Atlikę viską pagal Viešpaties įsakymus, Jėzaus tėvai grįžo namo į Nazareto miestą Galilėjoje. ");
INSERT INTO litb_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Čia berniukas augo ir tvirtėjo, pasižymėdamas neįprasta Jo amžiui išmintimi, o Dievas Jį apdovanodavo Savo malone. ");
INSERT INTO litb_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","42","Kai Jėzui sukako dvylika metų, Jis lydėjo tėvus į Jeruzalę, į tradicinę Velykų šventę, kurioje jie kasmet lankydavosi. ");
INSERT INTO litb_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Pasibaigus iškilmėms, visi keliavo namo į Nazaretą, bet Jėzus pasiliko Jeruzalėje. Pirmą dieną tėvai Jo nepasigedo, ");
INSERT INTO litb_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","nes manė, kad Jis esąs tarp keliaujančiųjų. Kai Jėzus nepasirodė kitą vakarą, jie puolė Jo ieškoti tarp giminių ir draugų. ");
INSERT INTO litb_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Negalėdami rasti, jie grįžo į Jeruzalę. ");
INSERT INTO litb_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Po trijų dienų jie pagaliau surado Jėzų šventykloje. Su įstatymo mokytojais Jis kalbėjosi apie sudėtingus dalykus, ");
INSERT INTO litb_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","stebindamas visus išmanymu ir Savo atsakymais. ");
INSERT INTO litb_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Tėvai nežinojo, ką galvoti. „Sūnau! – priekaištavo mama. – Kodėl Tu taip pasielgei? Mes nepaprastai išsigandome, Tavęs visur ieškodami.“ ");
INSERT INTO litb_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","„Kam jums reikėjo Manęs ieškoti? Ar jūs nesuprantate, kad Man reikia būti čia, šventykloje, Mano Tėvo namuose?“ ");
INSERT INTO litb_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Bet jie nesuvokė, apie ką Jis kalba. ");
INSERT INTO litb_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Tada Jis grįžo su tėvais į Nazaretą ir buvo klusnus. O Jo motina dėjosi visa tai į širdį. ");
INSERT INTO litb_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Su metais Jėzus darėsi išmintingesnis ir buvo mylimas Dievo bei žmonių. ");
INSERT INTO litb_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Imperatoriaus Tiberijaus penkioliktaisiais valdymo metais Dievas apsireiškė Jonui (Zacharijo sūnui), kai jis gyveno dykumoje. (Tuo metu Judėjoje viešpatavo Pilotas. Erodas – Galilėjoje, jo brolis Pilypas buvo Turėjos bei Trachonitidės krašto tetrarchas, Lisanijus – Abilėnės tetrarchas, o Anas ir Kajafas buvo vyriausieji kunigai.) ");
INSERT INTO litb_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Tada Jonas keliavo po visą Pajordanę skelbdamas, jog krikštas žmonėms padės grįžti prie Dievo ir atsižadėti nuodėmių, kad jiems būtų atleista. ");
INSERT INTO litb_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Pranašo Izaijo žodžiais, Jonas buvo „balsas, šaukiantis iš tyrų: Ruoškite kelią Viešpačiui! Jo atėjimui platinkite takus! ");
INSERT INTO litb_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Sulyginkite kalnus! Užpildykite slėnius! Išlyginkite vingius! Tiesinkite kelius! ");
INSERT INTO litb_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Tada visa žmonija pamatys Dievo siųstą Išgelbėtoją.“ ");
INSERT INTO litb_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Štai kaip Jonas pamokslavo minioms, kurios atėjo krikštytis: „Jūs, gyvačių išperos! Bandote pabėgti nuo pragaro neatsisukę į Dievą iš tikrųjų! Todėl jūs ir norite būti pakrikštyti! ");
INSERT INTO litb_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Pirma eikite ir įrodykite, kad tikrai atgailaujate. Ir nemanykite, jog esate saugūs todėl, kad jūs – Abraomo palikuonys. To nepakanka. Dievas gali ir šiuos dykumų akmenis paversti Abraomo vaikais! ");
INSERT INTO litb_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Jo teismo kirvis virš jūsų pakibęs ir pasirengęs pakirsti jūsų šaknis bei nuversti visai. Taip kiekvienas medis, kuris neveda gerų vaisių, turi būti nukirstas ir įmestas į ugnį.“ ");
INSERT INTO litb_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Minia klausė: „Ką tu nori, kad mes darytume?“ ");
INSERT INTO litb_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","„Jei tu turi du apsiaustus, – kalbėjo jis, – vieną atiduok neturinčiam. Jei turi atliekamo maisto – atiduok alkanam.“ ");
INSERT INTO litb_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Net muitininkai, šie visiems žinomi kyšininkai, atėjo pasikrikštyti ir klausė: „Kaip mes įrodysime tau, kad atsižadėjome nuodėmių?“ ");
INSERT INTO litb_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","„Savo sąžiningumu, – atsakė jis. – Užtikrinkite, kad nerinksite daugiau mokesčių, negu romėnų vyriausybė reikalauja.“ ");
INSERT INTO litb_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","„O kaip mes?“ – paklausė keletas kareivių. Jonas tarė: „Neatimkite pinigų grasinimais ir prievarta, nė vieno nekaltinkite tuo, ko jis nepadarė; tenkinkitės savo alga.“ ");
INSERT INTO litb_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Visi laukė ateinančio Mesijo, troško sužinoti, ar tai iryra Jonas. Šis klausimas rūpėjo kiekvienam, todėl buvo visur svarstomas. ");
INSERT INTO litb_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Jonas atsakė į šį klausimą, sakydamas: „Aš krikštiju jus vandeniu, bet greitai ateis Tas, kuris turi daug didesnę galią už mane. Iš tiesų aš nesu vertas būti net Jo vergu. Jis krikštys jus ugnimi ir Šventąja Dvasia. ");
INSERT INTO litb_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Jis atskirs pelus nuo grūdų ir, sudeginęs pelus amžina ugnimi, surinks kviečius.“ ");
INSERT INTO litb_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jis davė daug panašių įspėjimų, skelbdamas tautai gerąją naujieną. ");
INSERT INTO litb_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","20","Po to, kai Jonas viešai kritikavo Erodą, Galilėjos valdovą, už vedybas su savo brolio žmona Erodiada ir kitus paikus darbus, Erodas įmetė Joną į kalėjimą, tuo padarydamas dar vieną nuodėmę. ");
INSERT INTO litb_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Vieną dieną po to, kai jau buvo pakrikštytos ištisos minios, krikštytis atėjo pats Jėzus. Jam meldžiantis atsivėrė dangus ");
INSERT INTO litb_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ir Šventoji Dvasia balandžio pavidalu nusileido ant Jo, o balsas iš dangaus pasakė: „Tu esi Mano mylimasis Sūnus, Tavimi Aš gėriuosi.“ ");
INSERT INTO litb_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","38","Jėzui buvo apie trisdešimt metų, kai Jis pradėjo Savo misiją. Jėzų laikė sūnumi Juozapo, sūnaus Helio, sūnaus Matato, sūnaus Levio, sūnaus Melchio, sūnaus Janajo, sūnaus Juozapo, sūnaus Matatijo, sūnaus Amoso, sūnaus Naumo, sūnaus Heslio, sūnaus Nagajo, sūnaus Maato, sūnaus Matatijo, sūnaus Semejino, sūnaus Josecho, sūnaus Jodos, sūnaus Joanano, sūnaus Resos, sūnaus Zorobabelio, sūnaus Salatielio, sūnaus Nerio, sūnaus Melchio, sūnaus Adijo, sūnaus Kosamo, sūnaus Elmadamo, sūnaus Ero, sūnaus Jėzaus, sūnaus Eliezero, sūnaus Jorimo, sūnaus Matato, sūnaus Levio, sūnaus Simeono, sūnaus Judo, sūnaus Juozapo, sūnaus Jonos, sūnaus Eliachimo, sūnaus Melėjo, sūnaus Menos, sūnaus Matatos, sūnaus Natano, sūnaus Dovydo, sūnaus Jesės, sūnaus Jobedo, sūnaus Boozo, sūnaus Salos, sūnaus Naasono, sūnaus Aminadabo, sūnaus Admino, sūnaus Arnio, sūnaus Esromo, sūnaus Faro, sūnaus Judo, sūnaus Jokūbo, sūnaus Izaoko, sūnaus Abraomo, sūnaus Taros, sūnaus Nachoro, sūnaus Serucho, sūnaus Ragaujo, sūnaus Faleko, sūnaus Ebero, sūnaus Salos, sūnaus Kainamo, sūnaus Arfaksado, sūnaus Semo, sūnaus Nojaus, sūnaus Lamecho, sūnaus Matūzalio, sūnaus Henocho, sūnaus Jare to, sūnaus Maleleelio, sūnaus Kainamo, sūnaus Eno, sūnaus Seto, sūnaus Adomo, kuris buvo Dievo. ");
INSERT INTO litb_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Kupinas Šventosios Dvasios, Jėzus paliko Jordano upę ir Dvasia vedžiojo Jį Judėjos tyruose, kur velnias Jį gundė ");
INSERT INTO litb_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","keturiasdešimt dienų. Visą šį laiką Jėzus pasninkavo ir labai išalko. ");
INSERT INTO litb_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Šėtonas Jam tarė: „Jeigu Tu Dievo Sūnus, paversk šį akmenį duonos kepalu.“ ");
INSERT INTO litb_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Bet Jėzus atsakė: „Raštuose parašyta: gyvenime yra daug svarbesnių dalykų už duoną!“ ");
INSERT INTO litb_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Tada šėtonas užvedė Jį ant aukšto kalno ir akimirksniu parodė viso pasaulio karalystes. ");
INSERT INTO litb_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Velnias pasakė: „Aš atiduosiu Tau visas karalystes ir jų garbę, nes jos mano ir aš jas dalinu, kam noriu. ");
INSERT INTO litb_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Jei Tu atsiklaupsi ir pagarbinsi mane, visa bus Tavo.“ ");
INSERT INTO litb_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jėzus atsakydamas tarė: „Raštuose taip parašyta: Viešpatį, savo Dievą, tegarbink ir Jam vienam tetarnauk!“ ");
INSERT INTO litb_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","11","Po to šėtonas nusivedė Jį į Jeruzalę, liepė atsistoti ant šventyklos stogo ir tarė: „Jei Tu Dievo Sūnus, pulk žemyn, nes Raštai sako, kad Dievas atsiųs angelų sargybą Tau bei pasirūpins, kad nesusitrenktumei į grindinį!“ ");
INSERT INTO litb_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jėzus jam atkirto: „Raštai taip pat moko: Negundyk Viešpaties, savo Dievo, kvailais patikrinimais!“ ");
INSERT INTO litb_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Tada velnias baigė gundymusir kuriam laikui nuo Jėzaus pasitraukė. ");
INSERT INTO litb_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Tada Jėzus grįžo į Galilėją, kupinas Šventosios Dvasios galios. Greitai Jis išgarsėjo visoje šalyje ");
INSERT INTO litb_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Savo pamokslais sinagogose. Visi Jį gyrė. ");
INSERT INTO litb_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Kai Jis atvyko į Nazaretą, į vaikystės namus, šeštadienį kaip paprastai nuėjo į sinagogą ir atsistojo skaityti Raštų. ");
INSERT INTO litb_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Jam buvo paduota pranašo Izaijo knyga ir, ją atvertęs, Jis rado parašyta: ");
INSERT INTO litb_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","19","„Viešpaties Dvasia yra Manyje; Jis paskyrė Mane skelbti gerąją naujieną vargšams, Jis siuntė Mane gydyti sužeistas širdis ir skelbti, kad belaisviai bus išlaisvinti, aklieji atgaus regėjimą, pažemintieji atsikratys engėjų. Dievas yra pasirengęs palaiminti visus, kurie tik pas Jį ateis.“ ");
INSERT INTO litb_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jis užvertė knygą, padavė ją tarnui ir atsisėdo. Visi sinagogoje įdėmiai žiūrėjo į Jį. ");
INSERT INTO litb_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Tada Jis pridūrė: „Šis Raštas pildosi šiandien.“ ");
INSERT INTO litb_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Visi susirinkusieji buvo geros nuomonės apie Jį, bet labai stebėjosi gražiais žodžiais, sklindančiais iš Jo lūpų. „Ar gali būti? – klausinėjo vienas kitą. – Argi Jis ne Juozapo sūnus?“ ");
INSERT INTO litb_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Tada Jis prabilo: „Greičiausiai jūs pasakysite Man patarlę: „Gydytojau, pasigydyk pats“, turėdami galvoje „kodėl nedarai stebuklų gimtajame mieste, kaip darei Kafarnaume?“ ");
INSERT INTO litb_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Bet Aš sakau jums, kad nė vienas pranašas nepripažįstamas gimtajame mieste! ");
INSERT INTO litb_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","Pavyzdžiui, prisiminkite, kaip pranašas Elijas parodė stebuklą Sarepto našlei, atvykusiai iš Sidono krašto. Tomis sausros dienomis daugeliui žydų našlių reikėjo pagalbos, nes lietus nelijo jau tris su puse metų ir šalyje siautėjo badas, tačiau Elijas nė pas vieną iš jų nebuvo siųstas. ");
INSERT INTO litb_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Arba prisiminkite pranašą Eliziejų, kuris išgydė Naamaną iš Sirijos, o ne žydų raupsuotuosius.“ ");
INSERT INTO litb_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Šitokie pasakojimai sukėlė klausytojų įtūžį. ");
INSERT INTO litb_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Jie atsikėlė, nusivedė Jį prie skardžio, ant kurio buvo pastatytas miestas, norėdami nustumti Jį nuo uolos. ");
INSERT INTO litb_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Bet Jis paliko minią, braudamasis pro įtūžusius žmones. ");
INSERT INTO litb_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Tada grįžo į Galilėjos miestą Kafarnaumą ir ten mokė sinagogoje kiekvieną šeštadienį. ");
INSERT INTO litb_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Čia žmonės taip pat stebėjosi tuo, ką Jis sakė; kalbėdamas Jis nesirėmė kitų mintimis, bet skelbė Savą tiesą. ");
INSERT INTO litb_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Kartą, kai Jis kalbėjo sinagogoje, velnio apsėstas žmogus pradėjo šaukti: ");
INSERT INTO litb_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","„Eik šalin! Mums Tu nereikalingas, Jėzau iš Nazareto. Tu atėjai mus sunaikinti. Aš žinau, kad Tu esi Šventasis Dievo Sūnus.“ ");
INSERT INTO litb_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jėzus jį sudraudė, sakydamas: „Nutilk!“ O demonui liepė: „Išeik!“ Miniai stebint, velnias parbloškė tą žmogų ant žemės ir paliko jį nieko pikta daugiau nedarydamas. ");
INSERT INTO litb_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Žmonės nustebę klausinėjo: „Kas Šio Žmogaus žodžiuose, kad net velnias Jo paiso?“ ");
INSERT INTO litb_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Žinia apie tai, ką Jis padarė, žaibo greitumu pasklido po visą apylinkę. ");
INSERT INTO litb_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Tą dieną iš sinagogos Jis nuėjo į Simono namus, kur, drugio krečiama, gulėjo Simono uošvė. Visi prašė, kad ją pagydytų. ");
INSERT INTO litb_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Atsistojęs prie lovos, Jis sudraudė drugį, ir ligonės kūno temperatūra staiga nukrito. Moteris atsikėlusi tuojau paruošė jiems valgyti. ");
INSERT INTO litb_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Tą vakarą, saulei nusileidus, visi, kurie savo namuose turėjo ligonių, sergančių visokiomis ligomis, vedė juos pas Jėzų, o Jo rankų prisilietimas visus gydė. ");
INSERT INTO litb_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Kai kurie buvo velnio apsėsti; Jam paliepus, demonai išeidavo šaukdami: „Tu esi Dievo Sūnus.“ Ir Jis drausdavo juos, kad šito nesakytų. Bet jie žinojo, kad Jis yra Kristus, todėl pakluso Jo liepimui nutilti. ");
INSERT INTO litb_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Kitos dienos rytą Jis išėjo į dykumą. Žmonės Jo visur ieškojo ir, kai pagaliau rado, maldavo pasilikti Kafarnaume. ");
INSERT INTO litb_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Bet Jis atsakė: „Aš turiu skelbti gerąją naujieną apie Dievo karalystę ir kitose vietose – tam Aš ir esu siųstas.“ ");
INSERT INTO litb_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Taigi Jis keliavo toliau, mokydamas visose Judėjos sinagogose. ");
INSERT INTO litb_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Vieną dieną, kai Jis sakė pamokslą prie Genezareto ežero, didelės minios veržėsi prie Jo paklausyti Dievo Žodžio. ");
INSERT INTO litb_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jis pastebėjo dvi tuščias valtis, stovinčias vandenyje prie kranto. Žvejai plovė tinklus. ");
INSERT INTO litb_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Įlipęs į Simono valtį, Jėzus paprašė jį atsistumti truputį nuo kranto, kad Jis galėtų kalbėti žmonėms. ");
INSERT INTO litb_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Baigęs kalbėti, pasakė Simonui: „Dabar plauk į gilumą, išmesk tinklus valksmui, ir jūs pagausite daug žuvų!“ ");
INSERT INTO litb_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","„Mokytojau, – atsakė Simonas, – mes visą naktį vargome, bet nieko nesugavome. Tik dėl Tavo žodžio pabandysime dar kartą užmesti tinklą.“ ");
INSERT INTO litb_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Šį kartą jų tinklai buvo tokie pilni, kad net pradėjo trūkinėti! ");
INSERT INTO litb_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Išgirdę pagalbos šauksmą, kita valtimi atplaukė jų draugai, ir netrukus jos abi buvo tokios pilnos žuvies, kad vos neskendo. ");
INSERT INTO litb_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Kai Simonas Petras suprato, kas atsitiko, atsiklaupė prieš Jėzų ir pasakė: „Eik sau nuo manęs, Viešpatie, nes aš esu nusidėjėlis, nevertas, kad Tu būtum arti manęs.“ ");
INSERT INTO litb_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Jį apstulbino didelis laimikis, ");
INSERT INTO litb_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","taip pat kaip ir jo draugus, Zebedėjo sūnus Jokūbą bei Joną. Jėzus atsakė: „Nebijok! Dabar tu būsi žmonių sielų žvejys!“ ");
INSERT INTO litb_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Kai tik pasiekė krantą, vyrai, viską palikę, iškeliavo kartu su Juo. ");
INSERT INTO litb_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Viename kaimelyje buvo sunkiai sergąs raupsais žmogus. Pamatęs Jėzų, jis parpuolė kniūbsčias ant dulkėtos žemės ir maldavo, kad pagydytų: „Viešpatie, jei tik Tu panorėsi, mano ligos gali nė žymės nelikti!“ ");
INSERT INTO litb_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jėzus, ištiesęs ranką, palietė ligonį ir tarė: „Žinoma, noriu, būk išgydytas!“ Raupsai staiga pranyko! ");
INSERT INTO litb_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jėzus liepė niekam nepasakoti, kas atsitiko, ir tuojau pasirodyti žydų kunigui. „Paaukok, kaip liepia Mozės įstatymas, už raupsų išgydymą, – tarė Jis. – Tai bus įrodymas, kad esi sveikas.“ ");
INSERT INTO litb_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Dabar žinia apie Jo galią pasklido dar greičiau ir didelės minios ėjo klausytis Jo pamokslų ir gydytis nuo ligų. ");
INSERT INTO litb_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Tačiau Jis dažnai pasitraukdavo į tyrus maldai. ");
INSERT INTO litb_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Vieną dieną, kai Jis mokydamas kalbėjo, keletas žydų religijos vadovai ir įstatymo mokytojai sėdėjo netoliese. Atrodė, kad jie susirinko iš visų Galilėjos, Judėjos kaimų, taip pat ir iš Jeruzalės. Viešpaties gydymo galia neblėso. ");
INSERT INTO litb_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Staiga pasirodė keletas vyrų, nešančių patale paralyžiuotą žmogų. Jie stengėsi atnešti jį pas Jėzų, bet negalėjo prasibrauti per minią. ");
INSERT INTO litb_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Tada jie užlipo ant stogo, išėmė keletą čerpių ir nuleido sergantį žmogų į minią su visu patalu tiesiai prieš Jėzų. ");
INSERT INTO litb_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Matydamas jų tikėjimą, Jėzus pasakė tam žmogui: „Mano drauge, tavo nuodėmės atleidžiamos!“ ");
INSERT INTO litb_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","„Kas Jis toks, kad piktžodžiauja? – šaukė fariziejai ir įstatymo mokytojai. – Tai apsišaukėlis! Atleisti nuodėmes gali tik Dievas!“ ");
INSERT INTO litb_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jėzus, žinodamas jų mintis, tarė jiems: „Kodėl jūs sakote, kad šventvagiškai kalbu? ");
INSERT INTO litb_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","24","Aš, Mesijas, turiu valdžią atleisti nuodėmes žemėje. Kad Mano žodžiai neatrodytų tušti, – nes bet kas gali taip kalbėti, – Aš išgydysiu šį žmogų.“ Ir, pasisukęs į paralyžiuotąjį, Jis pasakė: „Paimk savo patalą ir eik namo, nes tu esi išgydytas!“ ");
INSERT INTO litb_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ir staiga visų akivaizdoje vyras pašoko ant kojų, paėmė patalą, kuriame gulėjo, ir nužingsniavo namo šlovindamas Dievą. ");
INSERT INTO litb_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Visus apėmė pagarbi baimė. Jie šlovino Dievą, sakydami: „Mes šiandien matėme keistų dalykų!“ ");
INSERT INTO litb_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Vėliau, jau beeidamas iš šio miestelio, Jėzus pamatė mokesčių rinkėją, garsų sukčių. To žmogaus vardas buvo Levis. Jėzus tarė jam: „Eikš, būsi vienas Mano mokinių!“ ");
INSERT INTO litb_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Levis tučtuojau viską paliko ir atsistojęs nuėjo su Juo. ");
INSERT INTO litb_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Greitai Levis iškėlė didelį pokylį savo namuose ir pakvietė Jėzų būti garbės svečiu. Susirinko Levio draugai, mokesčių rinkėjai, kiti svečiai. ");
INSERT INTO litb_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Bet fariziejai bei Rašto žinovai labai priekaištavo mokiniams, kad Jėzus valgo su tokiais dideliais nusidėjėliais. ");
INSERT INTO litb_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jėzus jiems atsakė: „Juk ne sveikiesiems reikia gydytojo, o sergantiesiems. ");
INSERT INTO litb_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Mano tikslas – raginti nusidėjėlius nusigręžti nuo savo nuodėmių, o ne leisti laiką su tais, kurie galvoja, kad jie jau pakankamai geri.“ ");
INSERT INTO litb_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Jie priekaištavo ir dėl to, kad Jėzaus mokiniai ne pasninkauja, o valgo ir geria. „Jono Krikštytojo mokiniai nuolat pasninkauja ir meldžiasi, – sakė jie. – Tai daro ir fariziejų mokiniai. Kodėl Tavieji valgo ir geria?“ ");
INSERT INTO litb_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jėzus paklausė: „Ar laimingi žmonės pasninkauja? Ar vestuvių svečiai alksta jaunikio akivaizdoje? ");
INSERT INTO litb_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Bet ateis laikas, kai jaunikis bus nužudytas. Tada jie nenorės pagalvoti apie valgį.“ ");
INSERT INTO litb_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jėzus palygino: „Niekas neplėšo naujo drabužio, kad iš jo padarytų lopą senam. Ne tik naujas rūbas sugadintas, bet ir senas atrodytų prasčiau su nauju lopu. ");
INSERT INTO litb_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Niekas nepila šviežio vyno į senas odines, nes vynas išsiveržtų iš senų vynmaišių, suplėšydamas juos ir išsiliedamas. ");
INSERT INTO litb_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Šviežias vynas turi būti pilamas į naujus vynmaišius. ");
INSERT INTO litb_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ir niekas, paragavęs seno vyno, nebenori šviežio ir gaivaus. Nes sakoma: išmėginti būdai yra geriausi.“ ");
INSERT INTO litb_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Vieną šeštadienį eidami per kviečių lauką, Jėzus ir Jo mokiniai skynė varpas ir, sutrynę rankomis, valgė grūdus. ");
INSERT INTO litb_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Tuomet keletas fariziejų sakė: „Toks elgesys prieštarauja įstatymams! Tavo mokiniai skina varpas, o žydų įstatymas draudžia dirbti šeštadienį.“ ");
INSERT INTO litb_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jėzus atsakė: „Ar neskaitote Šventojo Rašto? Ar niekad neskaitėte, ką darė karalius Dovydas, kai jis ir jo vyrai buvo alkani? ");
INSERT INTO litb_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Jis nuėjo į šventyklą, paėmė duonos, skirtos Viešpačiui, ir – nors tai įstatymo laužymas – valgė ją ir dalijosi su kitais.“ ");
INSERT INTO litb_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ir dar Jėzus pridūrė: „Mano valioje šeštadienio įstatymai.“ ");
INSERT INTO litb_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Kitą šeštadienį Jis mokė sinagogoje, o ten buvo žmogus, kurio dešinioji ranka buvo padžiūvusi. ");
INSERT INTO litb_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Rašto žinovai ir fariziejai atidžiai stebėjo, ar Jis gydys žmogų tą dieną, nes buvo šeštadienis. Jie troško rasti kaltinimų. ");
INSERT INTO litb_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Kaip gerai Jėzus suprato jų mintis! Jis tik pasakė vyrui su padžiūvusia ranka: „Ateik, atsistok į vidurį, kad visi matytų.“ Taip tasai ir padarė. ");
INSERT INTO litb_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Tada Jėzus kreipėsi į fariziejus: „Tad klausiu jus, ar dera šeštadienį daryti gera ar pikta? Gelbėti gyvybę ar ją sunaikinti?“ ");
INSERT INTO litb_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Apžvelgęs juos visus, Jis tarė vyrui: „Ištiesk ranką.“ Tas ištiesė, ir ranka visiškai pasveiko. ");
INSERT INTO litb_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Dėl to Jėzaus priešai siuto iš pykčio ir sumanė Jį nužudyti. ");
INSERT INTO litb_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Netrukus Jėzus išėjo į kalnus ir meldėsi ten visą naktį. ");
INSERT INTO litb_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Auštant sukvietė visus Savo pasekėjus ir išsirinko dvylika – artimiausiųjų mokinių būrelį. (Jie buvo paskirti Jo apaštalais, o dar kitaip – misionieriais.) ");
INSERT INTO litb_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","16","Štai jų vardai: Simonas (kurį Jis dar vadino Petru), Andriejus (Simono brolis), Jokūbas, Jonas, Pilypas, Baltramiejus, Matas, Tomas, Jokūbas (Alfiejaus sūnus), Simonas (zelotų grupės narys), Judas (Jokūbo sūnus), Judas Iskarijotas (kuris vėliau Jį išdavė). ");
INSERT INTO litb_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","18","Nusileidę nuo kalno šlaito, jie stovėjo greta Jėzaus drauge su kitais Jo sekėjais didelėje lygumoje apsupti minios. Žmonės ėjo iš visos Judėjos ir iš Jeruzalės, nuo tolimų Tyro ir Sidono šiaurinių pakrančių paklausyti Jo ar išsigydyti. Jis išvarė ir daug piktųjų dvasių. ");
INSERT INTO litb_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Kiekvienas stengėsi Jį paliesti, nes tokiu būdu žmonės išgydavo. ");
INSERT INTO litb_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Tada Jis pasisuko į mokinius ir prabilo: „Kokie palaiminti jūs, beturčiai, nes Dievo karalystė yra jūsų! ");
INSERT INTO litb_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Palaiminti ir jūs, alkstantieji, nes būsite pasotinti! Palaiminti, kurie verkiate, nes ateis laikas, kai juoksitės iš džiaugsmo! ");
INSERT INTO litb_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Kokia laimė, kai kiti jūsų neapkenčia, atstumia jus, įžeidinėja ir šmeižia dėl to, kad jūs su Manimi! ");
INSERT INTO litb_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Džiaukitės, kad šitaip atsitinka! Linksminkitės, nes jūsų laukia didelis atpildas danguje. Jūs būsite tarp gerų žmonių; taip buvo elgiamasi ir su senaisiais pranašais.“ ");
INSERT INTO litb_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","„Tačiau kokios kančios laukia turtingųjų! Savo vienintelę laimę jie jau patiria čia. ");
INSERT INTO litb_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Jie nusipenėję ir turtingi dabar, bet jų laukia baisus badmetis. Jų nerūpestingas juokas – būsimo skausmo ženklas. ");
INSERT INTO litb_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ir koks nusivylimas laukia tų, kuriuos dabar šlovina minia, – netikrus pranašus ji visuomet šlovindavo.“ ");
INSERT INTO litb_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","„Klausykite visi! Mylėkite priešus. Darykite gera tiems, kurie jūsų nekenčia. ");
INSERT INTO litb_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Melskite laimės tiems, kurie jus keikia, laiminkite tuos, kurie jus persekioja. ");
INSERT INTO litb_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Jei kas smogia jums į vieną žandą, leiskite trenkti ir į kitą. Jei kas reikalauja jūsų apsiausto, atiduokite jam ir savo marškinius. ");
INSERT INTO litb_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Duokite, ką turite, kiekvienam, kuris tik paprašo jūsų, ir kai kas nors iš jūsų atimama, nesirūpinkite, kaip tai susigrąžinti. ");
INSERT INTO litb_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Elkitės su kitais taip, kaip norėtumėte, kad kiti su jumis elgtųsi. ");
INSERT INTO litb_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Negi manote, jog esate nusipelnę, jei mylite tik tuos, kurie jus myli? Net bedieviai taip daro. ");
INSERT INTO litb_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ir jei darote gera tik tiems, kurie jums geri, argi tai nuostabu? Taip daro ir nusidėjėliai. ");
INSERT INTO litb_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ir jei skolinate pinigus tik tiems, kurie gali grąžinti skolą, koks jūsų nuopelnas? Juk ir didžiausi savanaudžiai nusidėjėliai skolina saviesiems, žinodami, kad skolą grąžins! ");
INSERT INTO litb_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Mylėkite priešus! Darykite jiems gera. Ir nesisielokite, jei tuo pačiu neatsilygins. Tada dangaus atpildas jums bus labai didelis, ir jūs būsite tikri Dievo vaikai, nes Viešpats gailestingas ir nedėkingiesiems, ir piktiesiems.“ ");
INSERT INTO litb_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","„Stenkitės mylėti taip, kaip ir jūsų Tėvas. ");
INSERT INTO litb_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Nekritikuokite ir nesmerkite, nes patys būsite pasmerkti. Būkite kantrūs su kitais – tada ir jie bus kantrūs su jumis. ");
INSERT INTO litb_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Jei jūs duosite, ir jums bus duota. Jūsų dovana grįš su kaupu. Kokiu saiku seikėsite, tuo pačiu saiku ir jums bus atseikėta.“ ");
INSERT INTO litb_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Štai keletas palyginimų, kuriuos Jėzus vartojo Savo pamoksluose: „Kaip gali aklas žmogus vesti aklą? Jis įkris į duobę ir įtrauks kitą su savimi. ");
INSERT INTO litb_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Kaip gali mokinys žinoti daugiau už savo mokytoją? Bet jei jis daug padirbės, gali tiek pat išmokti. ");
INSERT INTO litb_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Kodėl matai krislą kito akyje, jo mažą klaidą, tačiau nepastebi rąsto savo akyje? ");
INSERT INTO litb_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Kaip tu gali sakyti jam: „Broli, aš išimsiu krislą iš tavo akies“, kai savo akyje nematai rąsto? Veidmainy! Pirma išmesk rąstą iš savo akies, tada galbūt galėsi išimti krislą iš brolio akies!“ ");
INSERT INTO litb_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","„Geras medis neveda blogų vaisių, kaip ir menkas medis neveda gerų vaisių. ");
INSERT INTO litb_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Medį pažinsi pagal vaisių, kurį jis veda. Figos niekada neaugs ant uosių, ar vynuogės ant erškėčių. ");
INSERT INTO litb_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Geras žmogus daro gerus darbus iš geros širdies. Blogo žmogaus blogi darbai sklinda iš širdyje slypinčio blogio. Kas tik yra širdyje, atsispindi žmogaus kalboje.“ ");
INSERT INTO litb_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","„Taigi kodėl vadinate Mane Viešpačiu ir nedarote, ką Aš sakau? ");
INSERT INTO litb_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Tačiau kiekvienas, kuris ateina ir klauso Mano žodžio bei Man paklūsta, ");
INSERT INTO litb_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","panašus į žmogų, statantį namą ant tvirto pamato, kuris yra ant tvirtos uolos. Kai potvynio vandenys pakils ir atsimuš į tą namą, jis tvirtai stovės, nes tvirtai pastatytas. ");
INSERT INTO litb_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Bet tie, kurie klausosi ir nepaiso Manęs, panašūs į žmogų, statantį namą be pamato. Kai potvynis apsemia tą namą, jis pavirsta į griuvėsių krūvą.“ ");
INSERT INTO litb_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Kai Jėzus baigė pamokslą, Jis grįžo į Kafarnaumo miestą. ");
INSERT INTO litb_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Kaip tik tuo metu vienas didžiai vertinamas romėnų armijos kapitono tarnas sirgo ir buvo marinamas. ");
INSERT INTO litb_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Išgirdęs apie Jėzų, kapitonas siuntė kelis gerbiamus žydų vyresniuosius su prašymu ateiti ir pagydyti tarną. ");
INSERT INTO litb_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Atėję jie karštai maldavo Jėzų, kad eitų su jais ir padėtų tam žmogui. Jie papasakojo, koks puikus žmogus yra kapitonas. „Jis labiau už bet ką vertas Tavo pagalbos, – sakė jie, – ");
INSERT INTO litb_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","nes jis myli žydus ir netgi asmeniškai sumokėjo už sinagogos statybą!“ ");
INSERT INTO litb_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jėzus nuėjo su jais, bet prieš atvykstant į namus, kapitonas pasiuntė keletą draugų, kad perspėtų: „Viešpatie, nesivargink eidamas į mano namus, nes aš nevertas tokios garbės, ");
INSERT INTO litb_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","nevertas net eiti Tavęs pasitikti. Tik tark žodį toje vietoje, kur esi, ir mano tarnas pagis. Aš tuo tvirtai tikiu, ");
INSERT INTO litb_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","kadangi esu aukštesnių pareigūnų valdžioje ir turiu sau pavaldžių kareivių. Man tik reikia pasakyti „eikite“, ir jie eina, arba – „ateikite“, ir jie ateina, ar savo tarnui – „daryk tai ir tai“, ir jis daro. Taigi tik pasakyk: „Būk išgydytas“, ir mano tarnas vėl bus sveikas!“ ");
INSERT INTO litb_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jėzus buvo sužavėtas. Pasisukęs į minią, Jis tarė: „Niekada tarp žydų Izraelyje nemačiau žmogaus, kuris turėtų tokį stiprų tikėjimą.“ ");
INSERT INTO litb_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ir kai kapitono draugai grįžo į jo namus, jie rado tarną visiškai sveiką. ");
INSERT INTO litb_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Netrukus po to Jėzus su Savo mokiniais nuvyko į Najino miestą. Jį kaip paprastai lydėjo didelė minia. ");
INSERT INTO litb_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Pro miesto vartus ėjo laidotuvių procesija. Prisiartinę jie sužinojo, kad miręs berniukas buvo vienintelis našlės motinos sūnus, tad daug gedinčių iš miesto buvo su ja. ");
INSERT INTO litb_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Kai Viešpats ją pamatė, Jo širdį apėmė gailestis. „Neverk!“ – tarė Jis. ");
INSERT INTO litb_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Tada priėjo prie karsto, palietė jį ir nešikai sustojo. „Vaikine, – pasakė Jis, – sugrįžk gyventi.“ ");
INSERT INTO litb_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Berniukas atsisėdo ir pradėjo kalbėtis su jį apsupusiais žmonėmis! Ir Jėzus atidavė jį motinai. ");
INSERT INTO litb_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Didelė baimė apėmė minią, ir jie šlovino Dievą, sakydami: „Galingas pranašas iškilo tarp mūsų, ir šiandien mes pamatėm galingą Viešpaties ranką.“ ");
INSERT INTO litb_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Žinia apie Jo stebuklą pasklido visoje Judėjoje ir net už jos ribų. ");
INSERT INTO litb_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jono Krikštytojo mokiniai greitai išgirdo apie visa, ką Jėzus darė. Kai jie papasakojo apie tai Jonui, ");
INSERT INTO litb_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","jis pasiuntė savo du mokinius pas Jėzų, kad paklaustų, ar Jis iš tiesų Mesijas, ar jiems kito laukti. ");
INSERT INTO litb_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","22","Mokiniai rado Jėzų, kai Jis gydė ligonius, sergančius įvairiomis ligomis: luošus ir aklus, ir apsėstus piktosios dvasios. Kai jie paklausė, ko Jonas buvo prašęs, štai koks buvo atsakymas: „Grįžkite pas Joną ir papasakokite jam apie tai, ką čia šiandien matėte ir girdėjote: apie tai, kad akli regi, luošieji vaikšto nešlubuodami, raupsuotieji visiškai pagydomi. Kurtieji vėl girdi. Mirusieji prikeliami. O beturčiams skelbiama geroji naujiena. ");
INSERT INTO litb_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ir jam pasakykite: „Palaimintas, kuris nepraranda tikėjimo Manimi.“ ");
INSERT INTO litb_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Kai jie išėjo, Jėzus kalbėjosi su žmonėmis apie Joną. „Kas tas žmogus, kurio pamatyti išėjote į Judėjos tyrus? – paklausė Jėzus. – Ar jis jums atrodė silpnas kaip žolė, kurią pajudina kiekvienas vėjelio pūstelėjimas? ");
INSERT INTO litb_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ar jis apsirengęs brangiais drabužiais? Ne! Tie, kurie brangiais drabužiais apsirengę, tie rūmuose, o ne tyruose. ");
INSERT INTO litb_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ar pranašą pamatėte? Taip! Ir ne tik pranašą. ");
INSERT INTO litb_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Jis tas, apie kurį Raštuose parašyta: „Žiūrėkite! Štai Aš siunčiu pasiuntinį, kad jis paruoštų Tau kelią.“ ");
INSERT INTO litb_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Visa žmonija nėra mačiusi pranašesnio už Joną. Bet vis dėlto mažiausiasis Dievo karalystėje yra didesnis už jį.“ ");
INSERT INTO litb_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Visi, kurie girdėjo Joną pamokslaujantį, net patys blogiausieji pripažino, kad Dievo reikalavimai teisingi, ir panoro būti krikštijami. ");
INSERT INTO litb_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Visi, išskyrus fariziejus ir Mozės įstatymo mokytojus. Šie atmetė Dievo sumanymą ir atsisakė Jono krikšto. ");
INSERT INTO litb_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","„Ką galiu pasakyti apie tokius žmones? – paklausė Jėzus. – Su kuo juos galiu palyginti? ");
INSERT INTO litb_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Jie panašūs į vaikus, sėdinčius prekyvietėje, kurie skundžiasi draugams: „Jums nepatinka, jei mes žaidžiame „vestuves“, nepatinka, jei mes žaidžiame „laidotuves“! ");
INSERT INTO litb_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Kadangi Jonas Krikštytojas paprastai nieko nevalgydavo ir visą savo gyvenimą nebuvo išgėręs nė lašo svaiginančio gėrimo, jūs sakėte: „Jis tikriausiai pamišęs.“ ");
INSERT INTO litb_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Štai Aš valgau ir geriu vyną, o jūs sakote: „Koks Jėzus rajūnas, kiek Jis geria! O jau Jo draugai – padugnės!“ ");
INSERT INTO litb_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Bet Aš esu tikras, kad jūs visada rasite pateisinimą savo prieštaravimams.“ ");
INSERT INTO litb_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Vienas fariziejus pakvietė Jėzų į namus pietų, ir Jėzus sutiko. Kai jie atsisėdo valgyti, ");
INSERT INTO litb_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","gatvės moteriškė, išgirdusi, kad Jėzus čia, atsinešė puikų indąbrangių kvepalų. ");
INSERT INTO litb_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Įėjusi atsiklaupė, bučiavo Jo kojas ir laistė jas ašaromis, šluostė savo plaukais bei tepė jas kvepalais. ");
INSERT INTO litb_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Kada šeimininkas, fariziejus, pamatė, kas vyksta ir kas yra ta moteris, tarė pats sau vienas: „Tai rodo, kad Jėzus nėra pranašas; jei Dievas iš tiesų būtų Jį siuntęs, Jis žinotų, kas yra ta moteris!“ ");
INSERT INTO litb_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Staiga Jėzus prabilo, atsiliepdamas į jo mintis: „Simonai, – kreipėsi Jis į fariziejų. – Aš turiu tau kai ką pasakyti.“ „Gerai, Mokytojau, – atsakė Simonas. – Sakyk.“ ");
INSERT INTO litb_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Tada Jėzus papasakojo jam tokią istoriją: „Žmogus paskolino pinigų dviem žmonėms – vienam penkis šimtus denarų, o kitam penkiasdešimt denarų. ");
INSERT INTO litb_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Bet nė vienas jų negalėjo grąžinti skolos, todėl jis abiem skolą dovanojo. Kuris po to jį labiau mylėjo?“ ");
INSERT INTO litb_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","„Aš manau, kad tas, kuris buvo jam daugiau skolingas“, – atsakė Simonas. „Taip“, – sutiko Jėzus. ");
INSERT INTO litb_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Tada Jis atsigręžė į moterį ir pasakė Simonui: „Žiūrėk! Štai klūpanti moteris! Kai Aš įėjau į tavo namus, tu nenuplovei Mano dulkėtų kojų, o ji nuplovė jas savo ašaromis ir nušluostė plaukais. ");
INSERT INTO litb_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Tu nepabučiavai Manęs susitikimo vardan, o ji nesiliovė bučiavusi Man kojas, kai tik Aš įėjau. ");
INSERT INTO litb_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Tu nepatepei aliejumi Mano galvos, o ji tepė Mano kojas brangiais kvepalais. ");
INSERT INTO litb_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Todėl jos nuodėmės – nors jų daug – atleidžiamos, nes ji labai pamilo mane; o tas, kuriam mažai dovanota, nedaug meilės teparodo.“ ");
INSERT INTO litb_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Jis moteriai pasakė: „Tau atleidžiamos nuodėmės.“ ");
INSERT INTO litb_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Tada prie stalo sėdėję vyrai tarpusavyje ėmė kalbėtis patys sau: „Kas Šis Žmogus manosi esąs, kad ir nuodėmes atleidžia?“ ");
INSERT INTO litb_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","O Jėzus tarė moteriai: „Tavo tikėjimas išgelbėjo tave, būk rami.“ ");
INSERT INTO litb_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Netrukus Jis pradėjo kelionę per Galilėjos miestus ir kaimus, skelbdamas Dievo karalystės atėjimą, ir pasiėmė dvylika mokinių su Savimi. ");
INSERT INTO litb_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Dalis moterų, iš kurių Jis išvarė piktąsias dvasias arba išgydė, ėjo kartu su Juo. Tarp jų buvo Marija Magdalietė (Jėzus išvarė iš jos septynias piktąsias dvasias), ");
INSERT INTO litb_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Joana, Chuzos žmona (Chuza buvo karaliaus Erodo rūmų valdininkas), Zuzana ir daug kitų, kurios asmeninėmis santaupomis prisidėdavo išlaikant Jėzų ir Jo mokinius. ");
INSERT INTO litb_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Vieną dieną Jis papasakojo istoriją didelei miniai, kuri rinkosi Jo paklausyti, kiti iš aplinkinių miestų dar tebebuvo kelyje. ");
INSERT INTO litb_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","„Ūkininkas išėjo į laukus sėti. Jis išbarstė sėklas ant žemės. Kai kurios krito ant tako ir buvo sumindžiotos. Atskrido paukščiai ir sulesė jas, nes jos buvo gerai matomos. ");
INSERT INTO litb_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Kitos sėklos krito į nederlingą dirvą ant uolos. Šios sėklos pradėjo dygti, bet greitai sudžiūvo dėl drėgmės stokos. ");
INSERT INTO litb_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Dar kitos sėklos krito tarp erškėčių, ir jauni daigeliai greitai buvo nustelbti. ");
INSERT INTO litb_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Tačiau didelė dalis krito į derlingą dirvą. Ši sėkla išaugo ir davė šimteriopą derlių.“ Šitaip palyginęs, Jis pasakė: „Kas turi ausis, tesiklauso.“ ");
INSERT INTO litb_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Apaštalai klausė, ką ši istorija reiškianti. ");
INSERT INTO litb_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jis atsakė: „Dievas leido jums sužinoti šio palyginimo prasmę, kadangi čia kalbama apie Dievo karalystę. Tačiau minia, kaip senasis pranašas ir buvo sakęs, viską girdėjo, bet nieko nesuprato. ");
INSERT INTO litb_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Štai ką jis reiškia: Sėkla yra Dievo Žodis žmonėms. ");
INSERT INTO litb_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Išmintas takas, kur nukrenta sėklos, reiškia kietas širdis tų, kurie girdi Dievo žodžius, tačiau juos atima atėjęs velnias, kad žmonės netikėtų ir nebūtų išgelbėti. ");
INSERT INTO litb_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Akmenuota žemė vaizduoja tuos, kuriems patinka klausytis pamokslų, bet Žodis niekada iš tiesų jų nepasiekia, neįsišaknija jų širdyse ir nesubręsta. Jie tiki, kad Žodis tikras, ir tiki juo kurį laiką, bet kaipapučia karšti permainų vėjai, jie praranda tikėjimą. ");
INSERT INTO litb_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Sėklos tarp erškėčių simbolizuoja tuos, kurie klauso ir tiki Dievo Žodžiu, bet vėliau jų tikėjimas prapuola rūpesčių, turtų, pareigų ir gyvenimo malonumų sūkuryje. Ir tokiu būdu jie niekada nesugeba niekam padėti įtikėti Dievo Žodžiu. ");
INSERT INTO litb_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","O geroji dirva simbolizuoja sąžiningus, geros širdies žmones. Jie klauso Dievo Žodžio, priima ir skleidžia jį, todėl jų darbas yra vaisingas.“ ");
INSERT INTO litb_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Kitą kartą Jis paklausė: „Ar girdėjote, kad kas nors, uždegęs žiburį, laikytų jį uždengęs gaubtu? Ne, žibintai statomi taip, kad visi matytų. ");
INSERT INTO litb_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Lygiai taip pat kurią nors dieną visa, kas paslėpta žmonių širdyse, bus iškelta į dienos šviesą ir išaiškės. ");
INSERT INTO litb_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Taigi žiūrėkite, kaip jūs klausotės. Nes turinčiam bus duota, o iš neturinčio net ir tai, ką jis tariasi turįs, bus atimta.“ ");
INSERT INTO litb_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Kartą, kai motina ir broliai atėjo Jo aplankyti, jie negalėjo įeiti į namus, kur Jis mokė, nes buvo susirinkusi didelė žmonių minia. ");
INSERT INTO litb_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Kai Jėzui buvo pasakyta, kad artimieji stovi lauke ir nori Jį pamatyti, ");
INSERT INTO litb_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jis tarė: „Mano motina ir Mano broliai yra tie, kurie klauso Dievo Žodžio ir jį vykdo.“ ");
INSERT INTO litb_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Vieną dieną, būdamas valtyje su Savo mokiniais, Jėzus pasiūlė jiems persikelti į kitą ežero pusę. ");
INSERT INTO litb_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Plaukiant per ežerą, Jėzus užsnūdo, o tuo metu pradėjo pūsti vėjas. Kilo didelė audra, ir jie atsidūrė dideliame pavojuje, nes galėjo nuskęsti. ");
INSERT INTO litb_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Prisiartinę prie Jėzaus, mokiniai pažadino Jį. „Mokytojau, Mokytojau, mes skęstame!“ – šaukė jie. Todėl Jis įsakė audrai: „Nurimk“, – ir vėjas tuojau pat nurimo, bangos sumažėjo. ");
INSERT INTO litb_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Tada Jis paklausė: „Kur jūsų tikėjimas?“ Jie išsigando ir nustebę vienas kito klausė: „Kas šis žmogus, kad net vėjai ir bangos Jo klauso?“ ");
INSERT INTO litb_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Taigi jie atplaukė į geraziečių kraštą, kuris yra priešingame Galilėjos krante. ");
INSERT INTO litb_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Lipant iš valties, Jo pasitikti atėjo žmogus iš Godaro miesto. Jis ilgą laiką buvo demonų apsėstas, gyveno kapinėse benamis ir nuogas. ");
INSERT INTO litb_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Vos tik jis pamatė Jėzų, ėmė garsiai šaukti ir parpuolęs priešais Ji sakė: „Ko Tu iš manęs nori, Jėzau, Aukščiausiojo Dievo Sūnau?! Prašau, maldauju, nekankink manęs!“ ");
INSERT INTO litb_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Šis demonas jį dažnai užvaldydavo. Net ir surakintas grandinėmis jis buvo visiškai to demono valdomas, todėl nusitraukdavo grandines ir išlėkdavo į dykynę. Jėzus įsakė demonui atstoti nuo jo. ");
INSERT INTO litb_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","„Koks tavo vardas?“ – paklausė Jėzus demoną. Jis atsakė: „Legionas“, nes žmogų buvo apsėdę tūkstančiai piktųjų dvasių. ");
INSERT INTO litb_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Jos maldavo, kad Jėzus neįsakytų joms prasmegti. ");
INSERT INTO litb_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Netoliese kalne ganėsi kiaulių kaimenė. Demonai prašė leisti jiems persikelti į kiaules. Jėzus jiems leido. ");
INSERT INTO litb_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Taigi jie paliko vyrą ir suėjo į kiaules. Bematant visa kaimenė metėsi nuo skardžio į ežerą ir prigėrė. ");
INSERT INTO litb_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Piemenys pasileido į netoliese esantį miestą ir bėgdami visiems pasakojo apie tai, kas įvyko. ");
INSERT INTO litb_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Greitai minia išėjo pati pažiūrėti, kas atsitiko, ir pamatė žmogų, iš kurio buvo išėję demonai, sėdintį prie Jėzaus kojų, apsirengusį ir sveiko proto! Visa minia labai išsigando. ");
INSERT INTO litb_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Tada mačiusieji papasakojo, kaip buvo išgydytas apsėstasis. ");
INSERT INTO litb_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Visi puolė maldauti Jėzų pasitraukti ir palikti juos vienus, nes visus buvo užvaldžiusi didelė baimė. Taigi Jis grįžo į valtį ir nusiyrė į kitą ežero pusę. ");
INSERT INTO litb_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Velnio apsėstas žmogus maldavo, kad jį paimtų drauge, bet Jėzus nesutiko. ");
INSERT INTO litb_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","„Grįžk į šeimą, – tarė jam, – ir papasakok, kokį didelį dalyką tau Dievas padarė.“ Todėl jis vaikščiojo po miestą ir visiems skelbė apie didelį Jėzaus stebuklą. ");
INSERT INTO litb_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Kitoje ežero pusėje žmonės pasitiko Jį išskėstomis rankomis, labai Jo laukė. ");
INSERT INTO litb_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Vienas žydų sinagogos vyresnysis, vardu Jajiras, atėjo ir krito Jėzui po kojomis, maldaudamas ateiti į jo namus, ");
INSERT INTO litb_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","nes vienintelis jo vaikas, dvylikos metų mergytė, buvo marinama. Jėzus ėjo skverbdamasis pro minią. ");
INSERT INTO litb_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","44","Jiems beeinant, iš paskos prisiartino moteris, kuri norėjo pagyti, ir palietė Jį. Dvylika metų ji sirgo kraujoplūdžiu, kurio niekas negalėjo pagydyti (nors ji atidavė visą turtą daktarams). Tačiau tik palietus Jėzaus rūbo kraštelį, kraujavimas sustojo. ");
INSERT INTO litb_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","„Kas palietė Mane?“ – paklausė Jėzus. Visi gynėsi, o Petras pasakė: „Mokytojau, minia spaudžia Tave…“ ");
INSERT INTO litb_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Bet Jėzus jam atsakė: „Ne, kažkas sąmoningai palietė Mane, nes Aš jutau, kaip iš Manęs išėjo gydanti galia.“ ");
INSERT INTO litb_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Kai moteris suvokė, kad Jėzus žino, ji pradėjo drebėti, atsiklaupė priešais Jį ir pasakė, kodėl palietė Jį ir, kad dabar ji sveika. ");
INSERT INTO litb_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","„Dukrele, – tarė Jis jai, – tavo tikėjimas išgelbėjo tave, lik rami.“ ");
INSERT INTO litb_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jiems dar tebekalbant, iš Jajiro namų atėjo pasiuntinys ir pranešė, kad mažoji mergaitė mirė. „Ji mirė, – pasakė jis jos tėvui. – Dabar nebėra prasmės varginti Mokytoją.“ ");
INSERT INTO litb_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Bet kai Jėzus išgirdo, kas atsitiko, Jis pasakė tėvui: „Nebijok! Tik pasitikėk Manimi, ir ji bus gyva.“ ");
INSERT INTO litb_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Kai jie atvyko į namus, Jėzus neleido į kambarį nieko, išskyrus tik Petrą, Jokūbą ir Joną, mergaitės tėvą bei motiną. ");
INSERT INTO litb_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Namai buvo pilni giedotojų, bet Jis juos nutildė, sakydamas: „Baikite raudoję! Ji gyva, tik užmigusi.“ ");
INSERT INTO litb_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Šie žodžiai sukėlė šypseną ir juoką, nes visi žinojo, kad ji mirusi. ");
INSERT INTO litb_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Tada Jis paėmė ją už rankos ir sušuko: „Mergaite, kelkis!“ ");
INSERT INTO litb_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Tuo metu mergaitė atsigavo ir pakilo. „Duokite jai ko valgyti“, – pasakė Jis. ");
INSERT INTO litb_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Jos tėvus apėmė didelis džiaugsmas, bet Jėzus reikalavo niekam nepasakoti atsitikimo smulkmenų. ");
INSERT INTO litb_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Vieną dieną Jėzus sukvietė visus dvylika apaštalų ir davė jiems valdžią bei galią išvaryti demonus ir gydyti visas ligas. ");
INSERT INTO litb_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Tada Jis pasiuntė juos gydyti ligonių ir skelbti apie artėjančią Dievo karalystę. ");
INSERT INTO litb_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","„Neimkite su savimi net lazdos, – nurodė jiems, – nei elgetos maišelio, nei maisto, nei pinigų. Neturėkite nė dviejų apsiaustų. ");
INSERT INTO litb_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Aplankykite kiekviename kaime vienerius namus. ");
INSERT INTO litb_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Jei tik miesto žmonės neklausytų jūsų, kai jūs į jį įeisite, apsisukite ir išeikite, parodydami Dievo rūstybę, nusipurtydami to miesto dulkes nuo kojų.“ ");
INSERT INTO litb_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Taigi jie keliavo po kaimus, skelbdami gerąją naujieną ir gydydami ligonius. ");
INSERT INTO litb_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Kai Erodą pasiekė žinia apie Jėzaus stebuklus, jis sunerimo ir susimąstė, nes kai kas sakė: „Tai Jonas Krikštytojas prisikėlė iš numirusių.“ ");
INSERT INTO litb_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Kiti sakė: „Tai Elijas ar kuris kitas pranašas prisikėlė iš numirusių.“ Tie gandai sklido po visą šalį. ");
INSERT INTO litb_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","„Aš nukirsdinau Jonui galvą, – sakė Erodas. – Okas Šis Žmogus, apie Kuri aš girdžiu tokius keistus pasakojimus?“ Jis panoro Ji pamatyti. ");
INSERT INTO litb_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Kai apaštalai grįžo pas Jėzų ir apsakė, ką buvo nuveikę, drauge su jais ir Jėzus tyliai pasitraukė į Betsaidos miestą. ");
INSERT INTO litb_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Bet žmonės sužinojo, kur Jis eina, ir sekė iš paskos. Jis neatstūmė jų, vėl pasakodamas apie Dievo karalystę ir gydydamas ligonius. ");
INSERT INTO litb_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Pavakary atėjo visi dvylika mokinių, sakydami, kad Jis siųstų žmones į šalia esančius kaimus ir vienkiemius susirasti maisto ir prieglobstį nakčiai, „nes šioje dykumoje nėra ko valgyti“, kaip jie sakė. ");
INSERT INTO litb_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Bet Jėzus tarė: „Jūs duokite jiems valgyti!“ „Bet mes turime tik penkis kepalėlius duonos ir dvi žuvis, – protestavo jie. – Nebent nueitume ir nupirktume maisto visai šiai miniai.“ ");
INSERT INTO litb_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","O ten buvo penki tūkstančiai vyrų. „Liepkite jiems susėsti ant žemės grupėmis po penkiasdešimt“, – atsiliepė į tai Jėzus. ");
INSERT INTO litb_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Mokiniai taip ir padarė. ");
INSERT INTO litb_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jėzus paėmė penkis kepalėlius duonos, dvi žuvis, pažvelgė į dangų ir palaimino, laužė duoną ir dalino Savo mokiniams, kad duotų miniai. ");
INSERT INTO litb_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Visi valgė iki soties, ir dar buvo surinkta dvylika pintinių trupinių! ");
INSERT INTO litb_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Vieną dieną, kai Jėzus buvo vienas ir meldėsi netoli nuo Savo mokinių, Jis priėjo prie jų ir paklausė: „Kas Aš esu žmonių akyse?“ ");
INSERT INTO litb_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Jie sakė Jam: „Jonas Krikštytojas, o galbūt Elijas ar vienas iš senųjų pranašų, prisikėlęs iš numirusių.“ ");
INSERT INTO litb_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Tada Jis paklausė: „O ką jūs apie Mane galvojate?“ Petras atsakė: „Tu Mesijas – Dievo Kristus!“ ");
INSERT INTO litb_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jis liepė niekam apie tai nesakyti. ");
INSERT INTO litb_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","„Aš, Mesijas, turiu daug kentėti, – sakė Jis, – būti atmestas žydų vadovų – vyresniųjų, vyriausiųjų kunigų ir įstatymo žinovų, nužudytas, o po trijų dienų Aš prisikelsiu.“ ");
INSERT INTO litb_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Tada Jis visiems pasakė: „Kiekvienas, kuris nori Manimi sekti, turi atsisakyti savo troškimų ir patogumų, nešti savo kryžių kiekvieną dieną ir būti su Manimi. ");
INSERT INTO litb_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kas netenka gyvybės dėl Manęs, išgelbsti ją, bet kas nori išsaugoti gyvybę, praranda ją. ");
INSERT INTO litb_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Nes kokia nauda būtų žmogui, jei jis laimėtų visą pasaulį, o pražudytų save? ");
INSERT INTO litb_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Kai ateis Mano šlovės valanda, Mano Tėvo ir visų šventųjų angelų šlovės valanda, tada gėdysiuosi tų, kurie gėdijosi Manęs ir Mano žodžių. ");
INSERT INTO litb_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Bet tai paprasta tiesa – kai kurie iš jų, kurie čia stovi, nemirs, kol išvys Dievo karalystę.“ ");
INSERT INTO litb_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Praėjus aštuonioms dienoms, Jis nusivedė Petrą, Jokūbą ir Joną į kalną melstis. ");
INSERT INTO litb_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Besimeldžiant Jo veidas nušvito, o apdaras tapo akinančiai baltas ir švytėjo. ");
INSERT INTO litb_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Tuomet pasirodė du vyrai – Mozė ir Elijas. ");
INSERT INTO litb_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Jie atrodė didingai ir kalbėjo apie Jėzaus mirtį Jeruzalėje, kurią Jis turės priimti pagal Dievo sumanymą. ");
INSERT INTO litb_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petrą ir jo draugus apėmė miegas ir jie užsnūdo. Nubudę jie pamatė Jėzų didingoje šviesoje, o su Juo stovinčius du vyrus. ");
INSERT INTO litb_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Mozei ir Elijui besirengiant iškeliauti, Petras sutrikęs ir nežinodamas ką sakąs, tarė: „Mokytojau, mums čia gera būti. Mes pastatysime šioje vietoje tris palapines: vieną Tau, vieną Mozei ir vieną Elijui.“ ");
INSERT INTO litb_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Bet jam bekalbant užėjo debesis, ir juos apėmė baimė, ");
INSERT INTO litb_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","o balsas iš debesies pasakė: „Tai Mano mylimasis Sūnus, Mano išrinktasis, klausykite Jo.“ ");
INSERT INTO litb_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Balsui nutilus, Jėzus vėl buvo vienas su Savo mokiniais. Jie tylėjo ir ilgai nekalbėjo nieko apie tai, ką buvo matę. ");
INSERT INTO litb_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Rytojaus dieną, jiems leidžiantis nuo kalno, Jėzų pasitiko gausi minia, ");
INSERT INTO litb_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","o vienas žmogus sušuko: „Mokytojau, šis berniukas yra mano vienintelis sūnus, ");
INSERT INTO litb_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","o velnias jį laiko pasigavęs. Jis verčia jį rėkti, tampo, kad net putos iš burnos veržiasi. Jis nesiliauja jo kankinęs. ");
INSERT INTO litb_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Aš prašiau Tavo mokinius pagelbėti, bet jie neįstengė!“ ");
INSERT INTO litb_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","„O užsispyrę ir netikintys žmonės, – pasakė Jėzus Savo mokiniams. – Kaip ilgai Man reikės jus kęsti? Atvesk jį čia.“ ");
INSERT INTO litb_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Besiartinantį berniuką demonas parbloškė ant žemės ir pradėjo stipriai tąsyti, bet Jėzus liepė demonui išeiti, pagydė berniuką ir atidavė tėvui. ");
INSERT INTO litb_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Pagarbi baimė apėmė žmones, kai jie pamatė Dievo galios apreiškimą. Tada, kai visi stebėjosi nuostabiais Jėzaus darbais, Jis tarė Savo mokiniams: ");
INSERT INTO litb_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","„Paklausykite ir įsidėmėkite, ką sakau: Aš, Mesijas, būsiu išduotas.“ ");
INSERT INTO litb_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Bet mokiniai nesuprato Jo kalbos, nes nuo jų tai buvo paslėpta, o klausti jie nedrįso. ");
INSERT INTO litb_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Dabar kilo ginčas, kuris iš jų pranašiausias bus artėjančioje karalystėje! ");
INSERT INTO litb_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Bet Jėzus žinojo jų mintis ir, pasikvietęs mažą vaiką prie Savęs, ");
INSERT INTO litb_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","jiems pasakė: „Kas rūpinasi tokiu vaikeliu, rūpinasi Manimi, o kas rūpinasi Manimi, tas ir Dievu rūpinasi, nes Jis Mane siuntė. Jūsų rūpestis kitais yra jūsų vertės matas.“ ");
INSERT INTO litb_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jo mokinys Jonas priėjo prie Jo ir pasakė: „Mokytojau, mes matėme vieną žmogų, Tavo vardu išvarantį demonus. Mes draudėme jam. Pagaliau juk jis ne iš mūsų.“ ");
INSERT INTO litb_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Bet Jėzus pasakė: „Jums nereikėjo to daryti. Nes kas nėra prieš jus, tas už jus.“ ");
INSERT INTO litb_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Artėjant metui grįžti į dangų, Jis ryžtingai pasuko Jeruzalės link. ");
INSERT INTO litb_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Vieną dieną Jis siuntė pasiuntinius užsakyti kambarius viename Samarijos kaime. ");
INSERT INTO litb_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Bet jie buvo išvaryti. Kaimo žmonės atsisakė bendrauti su jais, nes jie keliavo į Jeruzalę. ");
INSERT INTO litb_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Kai atėjo žinia apie tai, kas atsitiko, Jokūbas ir Jonas pasakė Jėzui: „Mokytojau, ar mums įsakyti, kad kristų ugnis iš dangaus ir sudegintų juos?“ ");
INSERT INTO litb_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Bet Jėzus atsigręžęs sudraudė juos, ");
INSERT INTO litb_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ir jie iškeliavo į kitą kaimą. ");
INSERT INTO litb_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Jiems einant keliu, vienas žmogus pasakė Jėzui: „Aš Tave seksiu, kur tik Tu beeitum.“ ");
INSERT INTO litb_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Bet Jėzus atsakė: „Atmink, Aš neturiu nė kur galvos priglausti. Lapės turi urvus, paukščiai lizdus, o Aš, Mesijas, neturiu visai namų žemėje.“ ");
INSERT INTO litb_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Kitą kartą, kai Jis pakvietė žmogų, kad šis eitų su Juo ir būtų Jo mokinys, jis sutiko, bet norėjo palaukti tėvo mirties. ");
INSERT INTO litb_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jėzus atsakė: „Leisk neturintiems amžino gyvenimo pasirūpinti tokiais dalykais. Tavo pareiga eiti ir skelbti visam pasauliui apie Dievo karalystę.“ ");
INSERT INTO litb_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Dar vienas sakė: „Taip, Mokytojau. Aš seksiu paskui Tave, bet pirma leisk paprašyti leidimo namie.“ ");
INSERT INTO litb_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Bet Jėzus tarė: „Kas leidžiasi atitraukiamas nuo darbo, kurį jam skirsiu, netinkamas Dievo karalystei.“ ");
INSERT INTO litb_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Tuo metu Viešpats pasirinko kitus septyniasdešimt du mokinius ir pasiuntė juos po du pirma Savęs į visus miestus ir kaimus, kuriuos Jis vėliau ketino aplankyti. ");
INSERT INTO litb_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Jis davė jiems nurodymus: „Melskite pjūties Viešpatį, kad atsiųstų daugiau darbininkų jums padėti, nes pjūtis didelė, o darbininkų maža. ");
INSERT INTO litb_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Dabar eikite ir atminkite, kad jūs būsite kaip avinėliai tarp vilkų. ");
INSERT INTO litb_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Nesiimkite su savimi pinigų, nei elgetos maišelio, nei atsarginių porų batų. O kelyje negaiškite laiko. ");
INSERT INTO litb_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Kai tik į kuriuos namus įeisite, laiminkite juos. ");
INSERT INTO litb_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Jei tik jie bus verti palaimos, jūsų palaima pasiliks, jei ne – jūsų palaiminimas sugrįš jums. ");
INSERT INTO litb_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Kai ateisite į kaimą, nesikelkite iš namų į namus, bet pasilikite vienoje vietoje. Be abejonės, valgykite ir gerkite, kas jums padėta. Nedvejodami priimkite svetingumą, nes darbininkas vertas savo užmokesčio! ");
INSERT INTO litb_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","9","Jeigu miestas priims jus, laikykitės šių dviejų taisyklių: valgykite, kas jums padėta, gydykite ligonius. Tai darydami sakykite: „Dievo karalystė dabar yra labai arti jūsų.“ ");
INSERT INTO litb_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Jei miestas jūsų nepriims, eikite į gatves ir sakykite: ");
INSERT INTO litb_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","„Mes nusivalome net jūsų miesto dulkes nuo kojų, viešai skelbdami pražūtį. Niekada neužmirškite, kaip arti Dievo karalystės jūs buvote!“ ");
INSERT INTO litb_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Net Sodomai paskutiniojo teismo dieną bus lengviau nei tokiam miestui. ");
INSERT INTO litb_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Kokie baisumai laukia jūsų, Chorazino ir Betsaidos miestai! Jei Tyre ar Sidone būčiau padaręs stebuklus, kuriuos parodžiau jums, jų žmonės seniai būtų apsivilkę ašutines ir barstę savo galvas pelenais sielodamiesi bei atgailaudami. ");
INSERT INTO litb_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Taip, Tyras ir Sidonas teismo dieną užsitrauks mažesnę bausmę už jus. ");
INSERT INTO litb_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","O jūs, Kafarnaumo žmonės, ką Man apie jus pasakyti? Negi jūs būsite išaukštinti iki dangaus? Ne, jūs būsite nutrenkti į pragarą.“ ");
INSERT INTO litb_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Tada Jis pasakė Savo mokiniams: „Tie, kurie jus priima – Mane priima. Kurie jus atmeta – Mane atmeta. O tie, kurie Mane atmeta, atmeta Dievą, kuris Mane siuntė.“ ");
INSERT INTO litb_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Sugrįžę tie septyniasdešimt du Jam linksmai pareiškė: „Net demonai mūsų klauso, kai mes ištariame Tavo vardą.“ ");
INSERT INTO litb_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","„Taip, – atsakė Jis jiems. – Aš mačiau šėtoną, krintantį iš dangaus kaip žaibą! ");
INSERT INTO litb_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","O jums Aš suteikiau galią įveikti visą blogio galybę, vaikščioti tarp gyvačių bei skorpionų ir juos mindžioti. Niekas jums nepakenks. ");
INSERT INTO litb_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Tačiau svarbu ne tai, kad piktosios dvasios jums pavaldžios, bet kad jūsų vardai, kaip dangaus piliečių, užrašyti danguje.“ ");
INSERT INTO litb_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Tada Jėzų užvaldė Šventosios Dvasios džiaugsmas ir Jis tarė: „Aš šlovinu Tave, Tėve, dangaus ir žemės Viešpatie, kad paslėpei tuos dalykus nuo išmintingųjų ir pasaulio protingųjų ir apreiškei tiems, kurie patiklūs kaip maži vaikai. ");
INSERT INTO litb_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Taip, Tėve, ačiū Tau, nes Tu taip norėjai. Viskas Man yra Mano Tėvo atiduota. Niekas iš tiesų nežino, kas yra Sūnus, tik Tėvas, nei kas yra Tėvas, tik Sūnus ir tie, kuriuos Sūnus pasirinko Jį apreikšti.“ ");
INSERT INTO litb_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Tada, atsigręžęs į dvylika apaštalų, Jis ramiai pasakė: „Palaiminti jūs esate, kad teko jums tai pamatyti. ");
INSERT INTO litb_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Daug pranašų ir karalių seniai laukė tų dienų, kad pamatytų ir išgirstų tai, ką jūs matėte ir išgirdote!“ ");
INSERT INTO litb_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Vieną dieną pas Jėzų atėjo Mozės įstatymo žinovas ir, norėdamas patikrinti Jį, paklausė: „Mokytojau, ką turi daryti žmogus, kad amžinai gyventų danguje?“ ");
INSERT INTO litb_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jėzus atsakė: „O ką apie tai sako Mozės įstatymas?“ ");
INSERT INTO litb_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","„Jis teigia, – atsakė, – kad turite mylėti Viešpatį, savo Dievą, visa širdimi, visa siela, visomis jėgomis, visu protu, o savo artimą kaip save patį.“ ");
INSERT INTO litb_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","„Teisingai! – Jėzus jam pasakė. – Taip daryk ir gyvensi.“ ");
INSERT INTO litb_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Žmogus norėjo pateisinti savo nemeilę kai kuriems žmonėms, todėl paklausė: „Kas yra mano artimas?“ ");
INSERT INTO litb_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jėzus atsakė palyginimu: „Vienas žydas ėjo iš Jeruzalės į Jerichą ir buvo užpultas plėšikų. Jie išrengė jį, atėmė pinigus, primušė ir paliko pusgyvį šalia kelio. ");
INSERT INTO litb_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Atsitiktinai pro šalį ėjo vienas žydų kunigas ir, pamatęs ten gulintį žmogų, perėjo į kitą kelio pusę ir praėjo pro jį. ");
INSERT INTO litb_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Žydų šventyklos tarnautojas ėjo pro šalį, pažiūrėjo į gulintį žmogų ir nuėjo toliau. ");
INSERT INTO litb_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Bet niekinamas samarietis keliavo pro šalį ir pamatė gulintį žmogų. Jis pajuto didelį gailestį. ");
INSERT INTO litb_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Atsiklaupęs šalia, jis patepė jo žaizdas vaistais ir aprišo. Paskui, užsodinęs žmogų ant savo asilo, ėjo šalia jo, kol priėjo užeigą, kur slaugė jį per naktį. ");
INSERT INTO litb_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Kitą dieną jis padavė užeigos šeimininkui du denarus ir paprašė jo pasirūpinti tuo žmogumi. „Jei ką viršaus išleisi, – pasakė jis, – aš sumokėsiu skirtumą kitą kartą, kai būsiu čia!“ ");
INSERT INTO litb_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","„Kuris iš šių trijų, tavo manymu, yra artimas plėšikų aukai?“ ");
INSERT INTO litb_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Žmogus atsakė: „Tas, kuris parodė jam gailestingumą.“ Tada Jėzus pasakė: „Tai keliauk ir tu šitaip daryk.“ ");
INSERT INTO litb_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jėzus ir Jo mokiniai, keliaudami į Jeruzalę, priėjo kaimą, kur moteris, vardu Morta, pakvietė juos į savo namus. ");
INSERT INTO litb_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Jos sesuo Marija sėdėjo ant grindų ir klausėsi Jėzaus žodžių. ");
INSERT INTO litb_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Bet Morta buvo nepatenkinta ir susirūpinusi pietumis, kuriuos ruošė. Ji priėjo prie Jėzaus ir paklausė: „Mokytojau, ar Tau neatrodo, kad mano sesuo neteisi čia sėdėdama, kai aš viena dirbu visus darbus? Liepk jai ateiti man padėti.“ ");
INSERT INTO litb_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Bet Viešpats jai pasakė: „Brangioji Morta, tu nusiminusi dėl daugelio menkniekių. ");
INSERT INTO litb_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Tėra tik vienas dalykas, dėl kurio verta rūpintis. Marija jį atrado – Aš iš jos to neatimsiu!“ ");
INSERT INTO litb_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Kartą, Jėzui baigiant melstis, vienas iš mokinių priėjo ir pasakė: „Viešpatie, pamokyk mus melstis, kaip ir Jonas mokė savo mokinius.“ ");
INSERT INTO litb_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Štai malda, kurios Jis išmokė: „Tėve, tegul Tavo vardas būna pagarbintas, nes yra šventas; te greičiau ateina Tavo karalystė. ");
INSERT INTO litb_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Pamaitink mus kiekvieną dieną. ");
INSERT INTO litb_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Atleisk mums mūsų kaltes, nes ir mes atleidžiame tiems, kurie mums nusidėjo. Ir neleisk, kad mes būtume sugundyti.“ ");
INSERT INTO litb_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Paskui, aiškindamas jiems šią maldą, Jis palygino: „Sakykime, jūs nuėjote į draugo namus vidurnaktį, norėdami pasiskolinti tris kepalus duonos. Jūs jam sakote: „Mano draugas ką tik atvyko pas mane iš kelionės, ir aš neturiu ką jam duoti valgyti.“ ");
INSERT INTO litb_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Anas iš miegamojo atsilieps: „Neprašyk, kad atsikelčiau. Durys nakčiai užrakintos ir mes visi miegame. Šį kartą aš negaliu tau padėti.“ ");
INSERT INTO litb_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Bet Aš jums sakau – jeigu jis to nepadarys iš bičiulystės, o jūs nenustosite beldę, tai jis atsikels ir duos visa, ko jūs paprašysite – dėl jūsų įkyrumo. ");
INSERT INTO litb_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Taip ir su malda. Nepaliaudami prašykite, tai nuolat gausite, atkakliai ieškokite – ir visada rasite, belskite, ir durys bus atidarytos. ");
INSERT INTO litb_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kiekvienas, kas prašo – gauna, kas ieško – randa, ir durys atidaromos kiekvienam, kas beldžia. ");
INSERT INTO litb_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Jei esate tėvai, o jūsų sūnus prašo duonos, negi duosite akmenį? Jeigu jis prašo žuvies, nejau paduosite gyvatę? ");
INSERT INTO litb_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Jeigu jis prašo kiaušinio, argi duosite skorpioną? Žinoma, ne! ");
INSERT INTO litb_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Tad jei nusidėjėliai, kaip jūs, duoda savo vaikams ko jiems reikia, negi nesuprantate, kad jūsų dangiškasis Tėvas duos bent jau tiek pat ir atsiųs Šventąją Dvasią tiems, kurie Jos prašo?“ ");
INSERT INTO litb_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Kartą Jėzus išvarė velnią iš nebylio, ir žmogus vėl prakalbo. Minia buvo sujaudinta ir nustebinta, ");
INSERT INTO litb_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","bet kai kurie sakė: „Nenuostabu, kad Jis išvaro piktąsias dvasias. Jam galią suteikia šėtonas, piktųjų dvasių karalius!“ ");
INSERT INTO litb_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Kiti prašė ženklo iš dangaus, įrodančio, kad Jis yra Mesijas. ");
INSERT INTO litb_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jis žinojo kiekvieno jų mintis, todėl pasakė: „Kiekviena karalystė, vidaus kovų draskoma, pasmerkta pražūčiai. Taip pat ir namai, kuriuose tvyro kivirčai bei priešiškumas. ");
INSERT INTO litb_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Tokiu būdu, jei tai, ką jūs sakote, yra tiesa, vadinasi šėtonas kovoja pats prieš save, įgaliodamas Mane išvaryti velnius; kaip gali jo karalystė išlikti? ");
INSERT INTO litb_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Jeigu Aš šėtono įgaliotas, tai ką galite pasakyti apie savo pasekėjus? Nes jie išvaro demonus! Ar manote, jog tai rodo, kad jie šėtono apsėsti? Paklauskite jų, ar esate teisūs? ");
INSERT INTO litb_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Kadangi Aš išvarau demonus Dievo suteikta galia, tai reiškia, kad atėjo Dievo karalystė. ");
INSERT INTO litb_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Šėtono rūmai saugūs tol, kol juos sergsti stiprus ir ginkluotas šeimininkas, ");
INSERT INTO litb_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","kol kas nors stipresnis bei geriau ginkluotas neužpuola jo, nenugali, neatima ginklų ir neišdalija šėtono turtų. ");
INSERT INTO litb_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Visi, kurie nėra su Manimi, eina prieš Mane, ir jeigu Man nepadeda, kenkia Mano tikslui. ");
INSERT INTO litb_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Kai velnias yra išvaromas iš žmogaus, jis nueina į tyrus, ieškodamas poilsio, bet jo neradęs, jis sugrįžta į žmogų, iš kurio išėjo, ir ");
INSERT INTO litb_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","pamato, kad buvę namai iššluoti ir sutvarkyti. ");
INSERT INTO litb_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Tada jis eina ir pasiima kartu kitas septynias dvasias, dar piktesnes už save, ir jos visos apsėda žmogų. Tokiu būdu vargšui žmogui darosi septynis kartus blogiau negu buvo iki tol.“ ");
INSERT INTO litb_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jam bekalbant, viena moteris iš minios garsiai sušuko: „Tepalaimina Dievas Tavo motiną, įsčias, iš kurių Tu išėjai, ir krūtis, kurios Tave maitino.“ ");
INSERT INTO litb_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jis atsakė: „Taip, bet dar labiau palaiminti tie, kurie girdi Dievo Žodį ir pagal jį gyvena.“ ");
INSERT INTO litb_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","30","Miniai veržiantis artyn, Jis pasakė pamokslą: „Blogi laikai, ir žmonės blogi. Jie reikalauja ženklo iš dangaus, įrodančio, kad Aš – Mesijas, bet vienintelis įrodymas, kurį Aš duosiu, bus Jonos ženklas, įtikinęs nineviečius, kad jį siuntė Dievas. Mano panašus ženklas įrodys, kad Dievas Mane siuntė pas šituos žmones. ");
INSERT INTO litb_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Paskutiniojo teismo dieną Sabos karalienė prisikels ir pirštu parodys į šią kartą ją smerkdama, nes patinuėjo ilgą ir sunkų kelią, norėdama paklausyti Saliamono išminties, o čia štai Asmuo didesnis už Saliamoną, bet mažai kas kreipia į tai dėmesį. ");
INSERT INTO litb_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Nineviečiai taip pat prisikels ir pasmerks šią tautą, nes jie atgailavo, Jonai sakant pamokslus, o čia yra kažkas didesnis negu Jona, bet ši tauta nenori klausytis.“ ");
INSERT INTO litb_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","„Niekas nedega žiburio, kad po to jį paslėptų! Jį deda į žibintą, kad šviestų visiems, kas tik įeis į kambarį. ");
INSERT INTO litb_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Jūsų akys atspindi jūsų vidinę būklę. Tyra akis įleidžia saulės šviesą į jūsų sielą. Jei ji ydinga, uždengia šviesą ir panardina jus tamsoje. ");
INSERT INTO litb_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Todėl žiūrėkite, kad saulės šviesa nebūtų užtemdyta. ");
INSERT INTO litb_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Jei tu būsi pilnas vidinės šviesos, be jokių tamsos kampelių, tai švytės ir tavo veidas, lyg apšviestas išorinės šviesos.“ ");
INSERT INTO litb_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","38","Jam tebekalbant, vienas fariziejus pasikvietė Jį į namus pietų. Atvykęs Jėzus atsisėdo valgyti neatlikęs rankų mazgojimo ceremonijos, kaip reikalavo žydų paprotys. Tai labai nustebino šeimininką. ");
INSERT INTO litb_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Tada Jėzus jam pasakė: „Jūs, fariziejai, nusiplaunat išorę, bet viduje tebesate nešvarūs, gobšūs ir pikti. ");
INSERT INTO litb_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Neišmanėliai! Argi Dievas, sukurdamas išorę, nesukūrė vidaus? ");
INSERT INTO litb_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Dosnumas geriausiai paliudija tyrumą. ");
INSERT INTO litb_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Bet vargas jums, fariziejai! Jūs imate dešimtinę už smulkmenas, bet visai pamirštate Dievo meilę ir teisingumą. Taip, reikia dešimtines rinkti, bet svarbiausių dalykų neapleidžiant! ");
INSERT INTO litb_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Vargas jums, fariziejai! Kaip jūs mėgstate pirmąsias kėdes sinagogose ir garbingus sveikinimus turgavietėse! ");
INSERT INTO litb_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Taip, jūsų laukia baisus teismas. Nes jūs panašūs į užmirštus kapus laukuose. Žmonės praeina pro juos, nežinodami, kad jus mindžioja.“ ");
INSERT INTO litb_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","„Pone, – pasakė vienas ten stovėjęs religijos įstatymo žinovas. – Jūs savo žodžiais įžeidėte ir mano profesiją.“ ");
INSERT INTO litb_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","„Taip, – atsakė Jėzus. – Tokie pat baisumai laukia ir jūsų. Jūs žlugdote žmones, keldami neįvykdomus religinius reikalavimus, kurių patys niekada nemanote laikytis. ");
INSERT INTO litb_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Vargas jums! Nes jūs lygiai tokie patys kaip ir jūsų protėviai, kurie kadaise nužudė pranašus. ");
INSERT INTO litb_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Žmogžudžiai! Jūs sutinkate su savo protėviais, manydami, kad jie viską darė gerai – jūs ir patys taip būtumėte pasielgę. ");
INSERT INTO litb_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Štai ką Dievas apie jus sako: „Aš siųsiu pas jus pranašus ir apaštalus, o jūs vienus jų nužudysite, kitus persekiosite. ");
INSERT INTO litb_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ir jūsų kartos atsakys už Dievo tarnų žudymą nuo pat pasaulio sutvėrimo – ");
INSERT INTO litb_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","pradedant Abelio nužudymu ir baigiant Zacharijo mirtimi tarp altoriaus ir šventyklos.“ Taip, toks bus kaltinimas jums. ");
INSERT INTO litb_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Vargas jums, religijos žinovai! Nes jūs slepiate tiesą nuo žmonių. Jūs patys jos nepriimate ir kitiems kliudote rasti progą įtikėti.“ ");
INSERT INTO litb_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Fariziejai ir Rašto aiškintojai be galo įniršo ir nuo to laiko pradėjo Jį smarkiai pulti kamantinėdami, užduodami daugybę klausimų, tykodami Jį sugauti ką nors sakant, už ką galėtų suimti. ");
INSERT INTO litb_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Vienu metu susirinko tūkstančių tūkstančiai žmonių. Vieni kitus stumdė ir trypė. Jis pasisuko į Savo mokinius ir įspėjo juos: „Labiausiai saugokitės fariziejų ir jų veidmainystės. ");
INSERT INTO litb_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Tokia veidmainystė amžinai negali būti paslėpta. ");
INSERT INTO litb_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Visa, ką jie sakė tamsoje, bus girdėti šviesoje, o visa, ką jie viduje šnibždėjo, bus skelbiama nuo stogų, kad visi išgirstų! ");
INSERT INTO litb_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Brangieji draugai, nebijokite tų, kurie nori jus nužudyti. Jie gali užmušti tik kūną, nes neturi galios jūsų sielai. ");
INSERT INTO litb_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Bet Aš pasakysiu, ko jums bijoti – bijokite Dievo, kuris turi galią nužudęs įmesti į pragarą. ");
INSERT INTO litb_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ko verti penki žvirbliai? Dviejų skatikų. Ne daugiau kaip dviejų. Tačiau Dievas neužmiršo nė vieno iš jų. ");
INSERT INTO litb_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Jis žino net kiek plaukų ant jūsų galvos. Niekada nebijokite – jūs daug vertesni už visą žvirblių pulką. ");
INSERT INTO litb_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Užtikrinu jus: Aš, Mesijas, viešai pagerbsiu jus Dievo angelų akivaizdoje, jei jūs viešai išpažinsite Mane žemėje žmonių akivaizdoje. ");
INSERT INTO litb_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Bet Aš išsiginsiu angelų akivaizdoje tų, kurie Manęs išsigina žmonių akivaizdoje. ");
INSERT INTO litb_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Bet tiems, kurie kalba prieš Mane, gali būti atleista, tačiau kas kalba prieš Šventąją Dvasią, tam niekada nebus atleista. ");
INSERT INTO litb_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Kada jūs būsite atvesti į teismą ir atsidursite prieš žydų sinagogos viršininkus bei vyresniuosius, nesirūpinkite, kaip ginsitės kalbėdami, ");
INSERT INTO litb_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","nes Šventoji Dvasia parinks jums tinkamus žodžius, kai jūs jau ten stovėsite.“ ");
INSERT INTO litb_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Tada kažkas iš minios tarė: „Pone, liepk mano broliui, kad pasidalintų su manimi tėvo palikimą.“ ");
INSERT INTO litb_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Bet Jėzus atsakė: „Žmogau, kas gi padarė Mane teisėju, kad spręsčiau tokius dalykus? ");
INSERT INTO litb_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Saugokitės! Netrokškite to, kas ne jūsų. Nes gyvybė ir tikras gyvenimas nepriklauso nuo jūsų turtingumo.“ ");
INSERT INTO litb_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Tada Jis papasakojo tokią istoriją: „Turtingo žmogaus laukai gerai užderėjo. ");
INSERT INTO litb_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Iš tiesų jo klojimai buvo perpildyti – jis negalėjo visko sutalpinti. Jis apsvarstė tą dalyką ");
INSERT INTO litb_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","ir galop sušuko: dabar žinau – nugriausiu savo klojimus ir pastatysiu didesnius! Tada vietos užteks. ");
INSERT INTO litb_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Tuomet aš ilsėsiuosi ir sakysiu sau: „Drauguži, tu pakankamai susikrovei ateičiai. Dabar gyvenk ramiai! Tesups tave vynas, moterys ir dainos!“ ");
INSERT INTO litb_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Bet Dievas jam pasakė: „Kvaily! Šią naktį tu mirsi. Kam tada visa tai atiteks?“ ");
INSERT INTO litb_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Taip, kiekvienas žmogus yra kvailys, kuris stengiasi įsigyti turtų žemėje, bet ne danguje.“ ");
INSERT INTO litb_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Tada, pasisukęs į mokinius, Jis pasakė: „Nesirūpinkite tuo, ar jūs turite pakankamai maisto, drabužių, ");
INSERT INTO litb_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","nes gyvenimas susideda iš daug svarbesnių dalykų nei maistas ar drabužiai. ");
INSERT INTO litb_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Pažiūrėkite į varnus – jie nesėja ir nepjauna, neturi nė sandėlių laikyti maistui, bet jie gerai gyvena, nes Dievas juos maitina. O jūs esate nepalyginamai vertingesni už bet kokius paukščius! ");
INSERT INTO litb_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ir be to, kokia nauda iš rūpesčių? Ar pridės rūpesčiai bent dieną prie tavo gyvenimo? Žinoma, ne! ");
INSERT INTO litb_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Tad jei sielojantis neišsprendžiamos net tokios smulkmenos, tai kam tada rūpintis dėl didesnių dalykų? ");
INSERT INTO litb_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Pažiūrėkite į lelijas! Jos neverpia ir neaudžia, tačiau net Saliamonas pačioje savo didybėje nebuvo išsipuošęs taip, kaip jos. ");
INSERT INTO litb_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Jeigu Dievas aprengia gėles, šiandien žaliuojančias, o ryt nuvystančias, negi jūs, abejojantieji, nemanote, kad ir jums Dievas duos rūbus? ");
INSERT INTO litb_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Nesirūpinkite maistu – ką valgysite ir ką gersite, nesirūpinkite, nes Dievas jus viskuo aprūpins. ");
INSERT INTO litb_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Visa žmonija pluša dėl kasdienės duonos, bet jūsų Dangiškasis Tėvas žino, ko jums reikia. ");
INSERT INTO litb_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Jis visuomet duos visa, ko jums reikia kasdien, jeigu rūpestis dėl Dievo karalystės bus jūsų pagrindinis rūpestis. ");
INSERT INTO litb_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Todėl nebijok, mažoji kaimene, jūsų Tėvui didelis džiaugsmas duoti jums karalystę. ");
INSERT INTO litb_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Parduokite, ką turite, ir atiduokite tiems, kuriems reikia. Tai pastorins jūsų pinigines danguje. O dangiškose piniginėse nėra nei plyšimų, nei skylių. Tenai jūsų turtai niekada nežus. Joks vagis negali jų pavogti, nė kandys suėsti. ");
INSERT INTO litb_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kur jūsų turtai, ten jūsų širdys ir mintys.“ ");
INSERT INTO litb_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","„Būkite pasirengę – pasipuošę ir laukiantys, ");
INSERT INTO litb_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","nes jūsų Viešpats sugrįš iš vestuvių puotos. Tada jūs būsite pasirengę atidaryti duris ir įleisti Jį, kada Jis sugrįš ir pasibels. ");
INSERT INTO litb_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Didelis džiaugsmas laukia tų, kurie pasirengę ir laukia Jo sugrįžimo. Jis pats susodins juos ir susėdusius pavalgydins. ");
INSERT INTO litb_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Jis gali sugrįžti vakare devintą valandą ar net vidurnaktį. Ir kada Jis besugrįžtų, tarnai visada pasiruošę džiaugtis Jo sulaukę. ");
INSERT INTO litb_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Visi būtų pasirengę, jei žinotų tikslią Jo grįžimo valandą, taip pat lyg būtų pasiruošę sugauti vagį, jeigu žinotų, kada jis ateis. ");
INSERT INTO litb_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Taigi būkite visada pasirengę. Nes Aš, Mesijas, ateisiu, kada jūs mažiausiai tikėsitės.“ ");
INSERT INTO litb_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Petras paklausė: „Viešpatie, ar Tu čia mums kalbi, ar visiems?“ ");
INSERT INTO litb_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","44","Ir Viešpats atsakė: „Aš kalbu bet kuriam ištikimam, jautriam žmogui, kurį šeimininkas įpareigoja pamaitinti kitus tarnus. Jei jo šeimininkas sugrįš ir ras, kad tarnas gerai atliko jam duotą darbą, šeimininkas paskirs jam atlyginimą – atiduos valdyti visa, ką jis turi. ");
INSERT INTO litb_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Bet jei žmogus pradės galvoti: „Mano šeimininkas ilgai negrįš“, ir pradės plakti vyrus bei moteris, kuriuos turėtų apginti, leis laiką pokyliuose girtuokliaudamas, – ");
INSERT INTO litb_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","jo šeimininkas grįš nepastebėtas, tai jis neteks savo pareigų ir bus jam skirta vieta nesąžiningųjų tarpe. ");
INSERT INTO litb_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Jis bus žiauriai nubaustas dėl to, kad žinodamas savo pareigą, atsisakė ją vykdyti. ");
INSERT INTO litb_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Bet kiekvienas, kuris nežino, kad daro bloga, bus lengvai nubaustas. Daug yra reikalaujama iš tų, kuriems daug duodama, nes jų atsakomybė yra didesnė.“ ");
INSERT INTO litb_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","„Aš atėjau atnešti ugnį į žemę ir įvykdyti Savo misiją. ");
INSERT INTO litb_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Manęs laukia siaubingas krikštas, ir Aš nerimstu, kol tai išsipildys! ");
INSERT INTO litb_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Negi manote, kad Aš atėjau atnešti į žemę taiką? Ne! Greičiausiai nesantaiką ir susiskaldymą! ");
INSERT INTO litb_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Nuo šiol šeimos bus išskirtos, trys už Mane, du prieš Mane – o galbūt atvirkščiai. ");
INSERT INTO litb_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Tėvas spręs vienaip apie Mane, jo sūnus – kitaip, motina ir duktė nesutars, garbingi uošvienės sprendimai bus marčios atmesti.“ ");
INSERT INTO litb_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Tada Jis pasisuko į minią ir pasakė: „Kai vakaruose pamatote besiformuojančius debesis, jūs sakote: „Ateina liūtis.“ Ir jūs teisūs. ");
INSERT INTO litb_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Kai pučia pietų vėjas, jūs sakote: „Šiandien bus karšta diena.“ Taip ir yra. ");
INSERT INTO litb_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Veidmainiai! Jūs pakankamai gerai suprantate, kas yra danguje, betnenorite aplink save pastebėti pranašingus ženklus, rodančius artėjančiąją krizę. ");
INSERT INTO litb_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Kodėl jūs patys atsisakote pamatyti teisybę? ");
INSERT INTO litb_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Jeigu pakeliui į teismą sutiksite savo kaltintoją, pamėginkite išsiaiškinti reikalą be teisėjo, nes jis gali įmesti jus į kalėjimą ir, ");
INSERT INTO litb_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","jeigu taip atsitiks, jūs nebūsite laisvas, kol iki galo nebus atlikta bausmė.“ ");
INSERT INTO litb_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Tuo laiku Jam buvo pranešta, kad Pilotas nužudė keletą žydų iš Galilėjos, kai jie aukojo Jeruzalės šventykloje. ");
INSERT INTO litb_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","„Ar jūs manote, kad jie buvo didesni nusidėjėliai už bet kuriuos kitus žmones iš Galilėjos? ");
INSERT INTO litb_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Visai ne. Ar nesuprantate, kad ir jūs žūsite, jei eisite blogais keliais ir neatsisakysite paikų įpročių ir neatsisuksite į Dievą? ");
INSERT INTO litb_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","O kaipgi tie aštuoniolika vyrų, kurie žuvo Siloamo bokštui užgriuvus ant jų? Ar jie buvo patys didžiausi nusidėjėliai Jeruzalėje? ");
INSERT INTO litb_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Visai ne. Ir jūs taip pat žūsite, jei neatgailausite.“ ");
INSERT INTO litb_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Tada Jis papasakojo tokią istoriją: „Žmogus sode pasodino figos medį ir eidavo žiūrėti, ar neužaugo ant jo koks vaisius, bet vis grįždavo nusivylęs. ");
INSERT INTO litb_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Pagaliau jis liepė sodininkui medį nukirsti: „Aš laukiau tris metus, bet jis nedavė nė vieno figos vaisiaus! – pasakė jis. – Kam su juo dar vargti? Jis užima vietą, kurią mes galime kitiems tikslams panaudoti!“ ");
INSERT INTO litb_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","„Duokim medžiui dar vieną progą, – pasakė sodininkas. – Palikite jį dar kitiems metams, aš ypatingai jį globosiu ir gausiai tręšiu. ");
INSERT INTO litb_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Jei kitais metais figa duos vaisių – puiku, jei ne, aš ją nupjausiu!“ ");
INSERT INTO litb_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Vieną šeštadienį mokydamas sinagogoje, ");
INSERT INTO litb_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Jis pastebėjo ligos išvargintą moterį, kuri aštuoniolika metų buvo susitraukusi ir negalėjo išsitiesti. ");
INSERT INTO litb_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Pasišaukęs ją, Jėzus pasakė: „Moterie, tu esi pagydyta nuo ligos!“ ");
INSERT INTO litb_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Jis palietė ją, ir ji tuojau pat išsitiesino. Kaip ji šlovino Dievą ir dėkojo Jam! ");
INSERT INTO litb_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Bet vietos žydų vadovas, sinagogos vyresnysis, supyko todėl, kad Jėzus ją gydė šeštadienį. „Savaitė turi šešias darbo dienas! – rėkė jis miniai. – Tomis dienomis tegu ateina gydytis, bet tik ne šeštadienį!“ ");
INSERT INTO litb_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Viešpats atsakė: „Tu veidmainy! Ar tu šeštadienį nedirbi! Ar neatriši tvartuose gyvulių nuo ėdžių, ar nenuvedi jų vandens atsigerti šeštadienį? ");
INSERT INTO litb_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ar Aš negerai darau vien dėl to, kad šiandien šeštadienis, juk Aš išgelbsčiu šią žydų moterį iš velnio vergijos, kurioje jis laikė ją aštuoniolika metų?“ ");
INSERT INTO litb_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jo priešai susigėdo. Ir visi žmonės džiaugėsi nuostabiais dalykais, kuriuos Jis padarė. ");
INSERT INTO litb_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Dabar Jis pradėjo jiems aiškinti apie Dievo karalystę: „Kokia yra Dievo karalystė? – Jis paklausė. – Ką Aš apie ją galiu pasakyti? ");
INSERT INTO litb_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ji panaši į mažą garstyčios grūdą, pasodintą sode; jis greitai išauga į aukštą krūmą ir paukščiai gyvena jo šakose. ");
INSERT INTO litb_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","21","Ji panaši į mieles, įminkytas tešlon, kurios kyla nematomai, kol visa tešla iškyla ir palengvėja.“ ");
INSERT INTO litb_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jis keliavo į Jeruzalę, pakeliui sakydamas pamokslus miestuose bei kaimuose. ");
INSERT INTO litb_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Kažkas Jį paklausė: „Ar tik keletas išsigelbės?“ Ir Jis atsakė: ");
INSERT INTO litb_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","25","„Durys į dangų siauros. Stenkitės įeiti, nes po to, kai šeimos galva užrakins duris, bus per vėlu. Jei tada stovėsite lauke ir belsitės maldaudami: „Viešpatie, atverk mums duris“, Jis atsakys: „Aš jūsų nepažįstu.“ ");
INSERT INTO litb_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","„Bet mes valgėme su Tavimi ir Tu mokei gatvėse“, – jūs pasakysite. ");
INSERT INTO litb_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","O Jis atsakys: „Sakau jums, Aš jūsų nepažįstu. Jūs negalite čia įeiti dėl savo kaltės. Eikite lauk!“ ");
INSERT INTO litb_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ten bus didelis verksmas ir dantų griežimas, kai jūs būsite lauke ir matysite Abraomą, Izaoką, Jokūbą ir visus pranašus Dievo karalystėje, ");
INSERT INTO litb_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","nes žmonės ateis ten iš viso pasaulio. ");
INSERT INTO litb_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Tai įsidėmėkite: kurie dabar niekinami, tada bus labai vertinami, ir daug tų, kurie dabar šlovinami, tada bus mažiausiai pagerbti.“ ");
INSERT INTO litb_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Po kelių minučių keli fariziejai Jam pasakė: „Eik iš čia, jei nori likti gyvas, nes karalius Erodas Tave seka.“ ");
INSERT INTO litb_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jėzus atsakė: „Eik ir pasakyk tam lapei, kad Aš ir toliau išvarinėsiu demonus ir darysiu stebuklus, gydydamas ");
INSERT INTO litb_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","šiandien, rytoj ir poryt. Juk Dievo pranašas turi mirti tik Jeruzalėje. ");
INSERT INTO litb_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","O Jeruzale, Jeruzale! Mieste, žudantis pranašus! Mieste, akmenimis užmušąs tuos, kurie siųsti tau padėti. Kaip dažnai Aš norėjau surinkti tavo vaikus į krūvą, kaip višta savo viščiukus po sparnais, bet tu neleidai. ");
INSERT INTO litb_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","O dabar jūsų namai palikti bei apleisti. Ir jūs Manęs nebepamatysite, kol nepasakysite: „Pasveikintas, kuris ateina Viešpaties vardu.“ ");
INSERT INTO litb_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Vieną šeštadienį, kai Jis buvo žydų tarybos nario namuose, fariziejai stebėjo Jį kaip vanagai, norėdami pamatyti, ");
INSERT INTO litb_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","ar Jis išgydys žmogų, sergantį vandenlige. ");
INSERT INTO litb_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jėzus paklausė fariziejų ir įstatymo žinovų, stovinčių aplinkui: „Ar įstatymas draudžia gydyti ligonius šeštadienį?“ ");
INSERT INTO litb_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Kai jie atsisakė paaiškinti, Jėzus paėmė ligonį už rankos, išgydė jį ir paleido. ");
INSERT INTO litb_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Tada Jis pasisuko į stebėjusius: „Kas iš jūsų šeštadienį nedirba? Jeigu jūsų karvė įkris į duobę, ar nepulsite jos gelbėti?“ ");
INSERT INTO litb_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Jie vėl neturėjo ką atsakyti. ");
INSERT INTO litb_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Matydamas, kad pakviestieji pietums stengėsi atsisėsti pačioje garbingiausioje vietoje prie stalo, Jis davė jiems patarimą: ");
INSERT INTO litb_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","„Jeigu jus pakvies į vestuvių pokylį, nesėskite pirmoje vietoje, nes jei pasirodys kas nors kitas garbingesnis už jus, ");
INSERT INTO litb_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","šeimininkas atves jį prie jūsų ir pasakys: „Tegul šis žmogus sėdasi į jūsų vietą.“ O jūs sutrikęs turėsite sėstis į likusią vietą stalo gale. ");
INSERT INTO litb_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Geriau daryti taip – sėstis paskutinėje vietoje, o kai šeimininkas pamatys jus, jis ateis ir pasakys: „Drauge, mes tau turime geresnę vietą nei šita.“ Tai jūs būsite pagerbtas visų svečių akivaizdoje. ");
INSERT INTO litb_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Nes kiekvienas, kuris pažemins save, bus išaukštintas.“ ");
INSERT INTO litb_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Tuomet Jis pasisuko į šeimininką: „Kada ruošiate pietus, – pasakė Jis, – nekvieskite draugų, brolių, giminių ir turtingų kaimynų, ");
INSERT INTO litb_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","nes jie ir jus pakvies atsilygindami. ");
INSERT INTO litb_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Pamaldiesiems prisikeliant Dievas atlygins, kad pakvietėt tuos, kurie negali tuo pačiu atsimokėti.“ ");
INSERT INTO litb_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Tai girdėdamas žmogus, sėdintis prie stalo su Jėzumi, sušuko: „Kokia palaima patekti į Dievo karalystę!“ ");
INSERT INTO litb_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jėzus pasakė palyginimą: „Žmogus surengė didelę puotą ir išsiuntinėjo daug pakvietimų. ");
INSERT INTO litb_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Kai viskas buvo paruošta, jis pasiuntė savo tarną pranešti svečiams, jog laikas atvykti. ");
INSERT INTO litb_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Jie pradėjo atsiprašinėti. Vienas sakė, kad jis ką tik nusipirko lauką, nori eiti jį apžiūrėti ir prašė, kad ji atleistų nuo pokylio. ");
INSERT INTO litb_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Kitas pasakė, kad jis ką tik nusipirko penkis jungus jaučių ir nori juos išmėginti. ");
INSERT INTO litb_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Dar vienas – ką tik vedęs ir dėl tos priežasties negali ateiti.“ ");
INSERT INTO litb_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Tarnas sugrįžo ir viską pranešė savo šeimininkui. Šis supyko ir liepė greitai eiti į gatves, skersgatvius ir sukviesti elgetas, vargetas, luošus ir aklus. ");
INSERT INTO litb_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Bet ir tuomettada dar liko vietos. ");
INSERT INTO litb_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","„Na, – tada pasakė šeimininkas, – pereik kaimo takeliais, patvoriais ir atvaryk visus, ką tik surasi, kad namai būtų pilni. ");
INSERT INTO litb_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nes nė vienas iš tų, kuriuos anksčiau pakviečiau, neragaus nė trupučio to, ką jiems buvau paruošęs.“ ");
INSERT INTO litb_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Jėzų sekė didelė minia. Jis apsisuko ir kreipėsi į juos: ");
INSERT INTO litb_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","„Kas nori Mane sekti, turi mylėti Mane labiau už savo tėvą, motiną, žmoną, vaikus, brolius, seseris, labiau už savo gyvybę – kitaip jis negali būti Mano mokinys. ");
INSERT INTO litb_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ir nė vienas negali būti Mano mokinys, kas neima savo kryžiaus ir neseka Manimi. ");
INSERT INTO litb_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Bet nepradėkite, kol nežinote tikros kainos. Negi kas pradės statyti namą, nepadaręs sąmatos ir nepatikrinęs, ar turi pakankamai pinigų? ");
INSERT INTO litb_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Priešingu atveju, jo pinigai gali pasibaigti pastačius tik pamatus, ir kiek visiems būtų juoko! ");
INSERT INTO litb_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","„Pažiūrėkite į šitą jaunuolį, – jie juoktųsi. – Jis pradėjo statyti namus ir pristigo pinigų.“ ");
INSERT INTO litb_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Koks karalius eina į karą, pirma neatsisėdęs su savo patarėjais ir neapsvarstęs, ar jo armija iš 10 000 vyrų pakankamai stipri, kad sumuštų 20 000 vyrų. ");
INSERT INTO litb_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Jeigu sprendimas neigiamas, tada, kol priešo armija dar toli, jis siųs paliaubų komandą, kad aptartų taikos sąlygas. ");
INSERT INTO litb_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Taigi, nė vienas negali tapti Mano mokiniu pirma neatsisėdęs ir neperskaičiavęs savo gėrybių, o tada jų dėl Manęs neatsisakęs. ");
INSERT INTO litb_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ko verta druska, kai nebetenka sūrumo? ");
INSERT INTO litb_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Druska be skonio nieko neverta – net kaip trąša. Ji bevertė ir tinka tik išmesti. Gerai paklausykite, gal jūs suprasite, ką norėjau pasakyti.“ ");
INSERT INTO litb_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Nesąžiningi mokesčių rinkėjai ir kiti dideli nusidėjėliai dažnai ateidavo pasiklausyti Jėzaus pamokslų, ");
INSERT INTO litb_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","bet tai sukėlė žydų religijos vadovų ir žydų įstatymo mokytojų pasipiktinimą, kadangi Jis bendrauja su tokiais menkais žmonėmis – netgi valgo su jais. ");
INSERT INTO litb_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Todėl Jėzus pavartojo šį palyginimą: ");
INSERT INTO litb_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","„Jeigu jūs turėtumėte šimtą avių, o viena iš jų pasimestų ir pasiklystų, argi jūs nepaliktumėte devyniasdešimt devynių kitų ir neimtumėte ieškoti vienos pasiklydusios, kol surastumėte? ");
INSERT INTO litb_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ir tada jūs su džiaugsmu neštumėte ją namo ant pečių. ");
INSERT INTO litb_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Kai parvyktumėte, jūs sušauktumėte draugus ir kaimynus pasidžiaugti kartu su jumis, nes atsirado prapuolusi avis. ");
INSERT INTO litb_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Taip pat ir dangus bus laimingesnis dėl vieno pasiklydusio nusidėjėlio, kuris grįžta prie Dievo, negu dėl devyniasdešimt devynių kitų, kurie nebuvo paklydę!“ ");
INSERT INTO litb_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Arba štai kitas palyginimas: „Moteris turi dešimt vertingų sidabrinių monetų ir vieną pameta. Argi ji neužsidegs žiburio ir neieškos kiekviename namo kampe, ar neiššluos kiekvieno užkampio ar plyšio, kol ras ją? ");
INSERT INTO litb_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ar radusi ji nesukvies draugių ir kaimynų pasidžiaugti kartu? ");
INSERT INTO litb_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Taip ir Dievo angelų akivaizdoje daug džiaugsmo, kai atgailauja vienas nusidėjėlis.“ ");
INSERT INTO litb_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Kad mintis būtų aiškesnė, Jis papasakojo jiems tokią istoriją: „Žmogus turėjo du sūnus. ");
INSERT INTO litb_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Kai jaunesnysis pasakė tėvui: „Dabar noriu pasidalinti tavo turtą (gauti turto dalį), nelaukdamas tavo mirties!“ – jo tėvas sutiko ir padalijo sūnums turtą. ");
INSERT INTO litb_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Po kelių dienų tas jaunesnysis sūnus susidėjo visus savo daiktus ir leidosi kelionėn į tolimą žemę. Ten iššvaistė visus pinigus pokyliams ir prostitutėms. ");
INSERT INTO litb_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Tuo metu, kai baigėsi jo pinigai, į aną šalį atėjo badas ir jis pradėjo badauti. ");
INSERT INTO litb_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Jis įkalbėjo vietinį ūkininką, kad tas pasamdytų jį šerti kiaulių. ");
INSERT INTO litb_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Vaikinas taip išalko, kad net atliekos, kuriomis jis maitino kiaules, jam atrodė geros. Bet niekas nieko jam nedavė. ");
INSERT INTO litb_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Kai pagaliau jis atsipeikėjo ir nusiramino, tarė sau: „Namie net samdiniai turi apsčiai maisto, o aš čia mirštu iš alkio! ");
INSERT INTO litb_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Aš grįšiu namo ir sakysiu: „Tėve, aš nusidėjau dangui ir tau ");
INSERT INTO litb_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ir nesu vertas vadintis tavo sūnumi. Prašau, priimk mane kaip samdinį.“ ");
INSERT INTO litb_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Taip jis grįžo namo pas tėvą. Kai jis dar buvo toli nuo namų, tėvas pamatė jį sugrįžtantį, ir jo širdis prisipildė gailesčio ir meilės. Nubėgęs apkabino ir išbučiavo jį. ");
INSERT INTO litb_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Jo sūnus jam pasakė: „Tėve, nusidėjau dangui ir tau, nesu vertas vadintis tavo sūnumi.“ ");
INSERT INTO litb_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Bet jo tėvas pasakė tarnams: „Greičiau atneškite puikiausius rūbus ir apvilkite jį. Užmaukite ant piršto brangakmeniais papuoštą žiedą; nepamirškite apavo! ");
INSERT INTO litb_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Paskerskite veršiuką, kurį turime tvarte. Mes privalome iškilmingai atšvęsti, ");
INSERT INTO litb_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","nes šis mano sūnus buvo miręs, o dabar grįžo į gyvenimą. Jis buvo pražuvęs ir atsirado!“ Taigi pokylis prasidėjo. ");
INSERT INTO litb_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Tuo tarpu vyresnysis sūnus dirbo laukuose. Kai jis grįžo namo, išgirdo šokių muziką, sklindančią iš namų, ");
INSERT INTO litb_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ir paklausė vieną tarną, kas čia vyksta. ");
INSERT INTO litb_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","„Sugrįžo tavo brolis, – jam buvo pasakyta, – ir tavo tėvas papjovė veršiuką, kuri mes nušėrėme, ir suruošė didelį pokylį, kad atšvęstų laimingą sugrįžimą į namus!“ ");
INSERT INTO litb_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Vyresnysis brolis supyko ir nėjo į vidų. Tėvas išėjo laukan ir maldavo ji, ");
INSERT INTO litb_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","bet jis atsakė: „Visus šiuos metus aš tau dirbau ir nė karto neatsisakiau nė vieno darbo, kurį tu man skyrei. Ir per visą tą laiką tu nė karto nedavei man net jaunos ožkos šventei su draugais. ");
INSERT INTO litb_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Dabar, kai grįžta tas tavo sūnus, ištaškęs tavo pinigus prostitutėms, tu šventi, paskerdęs puikiausią mūsų veršeli!“ ");
INSERT INTO litb_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","„Brangus sūnau, – pasakė jam tėvas. – Aš ir tu labai artimi, ir visa, ką turiu, yra tavo. ");
INSERT INTO litb_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ir gerai darome, kad švenčiame. Nes jis – tavo brolis. Jis buvo miręs ir prisikėlė! Jis buvo prarastas ir atsirado!“ ");
INSERT INTO litb_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Po to Jėzus mokiniams papasakojo šią istoriją: „Vienas turtingas žmogus turėjo prievaizdą, kuris tvarkė jo reikalus, bet greitai pasklido gandas esą jis labai nesąžiningas. ");
INSERT INTO litb_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Todėl darbdavys pasišaukė jį į vidų ir pasakė: „Ką aš girdžiu apie tave šnekant, kad tu vagi iš manęs? Paruošk ataskaitą, nes būsi atleistas.“ ");
INSERT INTO litb_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Prievaizdas pagalvojo sau: „Ką dabar daryti? Čia netenku darbo, eiti kasti griovių aš neturiu jėgų, be to esu pernelyg išdidus, kad galėčiau prašyti išmaldos. ");
INSERT INTO litb_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Aš žinau, ką daryti. Įgysiu daug draugų, kurie manimi rūpinsis, kai būsiu atleistas.“ ");
INSERT INTO litb_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","6","Jis pasikvietė visus, kurie buvo savo darbdaviui skolingi, kad ateitų ir aptartų padėtį. Jis paklausė pirmąjį: „Kiek tu jam skolingas?“ „Mano skola šimtas statinių aliejaus“, – atsakė žmogus. „Taip, štai skolos raštas, kurį tu pasirašei!“ – jam pasakė prievaizdas. – Suplėšyk ir parašyk kitą, parodantį pusę to kiekio!“ ");
INSERT INTO litb_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","„O kiek tu jam skolingas?“ – paklausė jis kitą žmogų. „Šimtą saikų kviečių“, – atsakė tas. Prievaizdas tarė: „Štai, imk skolos raštą ir pakeisk jį kitu, kuriame parašyta, jog esi skolingas aštuoniasdešimt saikų kviečių!“ ");
INSERT INTO litb_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Turtingasis žmogus negalėjo nesižavėti sukčiaus įžvalgumu. Tiesa, kad pasauliečiai yra daug apsukresni už pamaldžiuosius. ");
INSERT INTO litb_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Bet ar Aš liepiu jums siekti draugystės per suktybes? Ar šitaip elgdamiesi įgysite amžinus namus danguje? ");
INSERT INTO litb_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ne! Jei negali sąžiningai atlikti mažų darbų, nebūsi sąžiningas ir didelius dirbdamas. ");
INSERT INTO litb_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Jei nors truputį sukčiausite, sąžiningai neatliksite ir didesnių pareigų. ");
INSERT INTO litb_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ir jeigu jums negalima patikėti pasaulio turtų, kas patikės jums tikrus dangaus turtus? Jeigu nesąžiningai elgiatės su svetimais pinigais, tai ar galima jums patikėti jūsų pačių pinigus? ");
INSERT INTO litb_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Nei jūs, nei kas kitas negali tarnauti dviem šeimininkams. Jūs neapkęsite vieno ir parodysite ištikimybę kitam, arba atvirkščiai – jūs vieną priimsite su džiaugsmu, o kito neapkęsite. Jūs negalite tarnauti ir Dievui, ir pinigui!“ ");
INSERT INTO litb_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Fariziejai, kurie buvo godūs, žinoma, šaipėsi iš viso to. ");
INSERT INTO litb_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Tada Jis jiems pasakė: „Jūs apsimetę teisiais ir pamaldžiais žmonių akivaizdoje, bet Dievas žino jūsų piktas širdis. Žmonių akyse jūs pagerbti, bet pasmerkti Dievo akyse.“ ");
INSERT INTO litb_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","„Iki Jono Krikštytojo mokslo jūs vadovavotės Mozės įstatymais ir pranašų žodžiais, bet Jonas supažindino su gerąja naujiena apie greit ateisiančią Dievo karalystę. Ir dabar daugybė į ją veržiasi. ");
INSERT INTO litb_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Bet tai nereiškia, kad įstatymas neteko galios bent vienu požiūriu. Jis stiprus ir nepalaužiamas kaip dangus ir žemė. ");
INSERT INTO litb_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Taigi kiekvienas, kas išsiskiria su žmona ir veda kitą – svetimauja, ir kas veda išsiskyrusią moterį – taip pat.“ ");
INSERT INTO litb_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","„Gyveno vienas turtingas žmogus, – tęsė Jėzus, – kuris buvo nuostabiai apsirengęs ir kiekvieną dieną kėlė prabangias puotas. ");
INSERT INTO litb_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","O Lozorius, sergantis elgeta, gulėjo prie jo durų, svajodamas apie trupinius nuo turtuolio stalo. ");
INSERT INTO litb_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Atbėgę šunys laižydavo jo atviras žaizdas. ");
INSERT INTO litb_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Pagaliau vargšas mirė, ir angelai jį nunešė į Abraomo prieglobstį, ten, kur yra teisiųjų mirusiųjų vieta. ");
INSERT INTO litb_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Mirė taip pat ir turtuolis, buvo palaidotas, o jo vėlė nukeliavo į pragarą. Čia kentėdamas, jis pamatė tolumoje Lozorių su Abraomu. ");
INSERT INTO litb_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","„Tėve Abraomai, – sušuko jis, – pasigailėk! Atsiųsk čionai Lozorių, kad, suvilgęs vandenyje galą piršto, atvėsintų mano liežuvi, nes aš baisiai kenčiu šiose liepsnose!“ ");
INSERT INTO litb_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Bet Abraomas jam pasakė: „Sūnau, atmink, kad savo gyvenime turėjai ko norėjai, o Lozorius neturėjo nieko. Todėl dabar čia jis paguostas, o tu – kančioje. ");
INSERT INTO litb_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Be to, mus skiria didelė bedugnė, tad kiekvienas, kuris nori pas tave patekti, yra sustabdomas ant bedugnės krašto, ir nė vienas iš jūsų negali ateiti pas mus.“ ");
INSERT INTO litb_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Tas vėl tarė: „Tai meldžiu tave, tėve, nusiųsk jį bent į mano tėvo namus: ");
INSERT INTO litb_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","aš gi turiu penkis brolius – juos teįspėja, kad ir jie nepatektų į šią kančių vietą.“ ");
INSERT INTO litb_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraomas atsiliepė: „Jie turi Mozę bei pranašus, tegul jų klauso!“ ");
INSERT INTO litb_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","O anasatsakė: „Ne, tėve Abraomai! Bet jei kas iš mirusiųjų nueitų pas juos, jie atsiverstų“ ");
INSERT INTO litb_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Tačiau Abraomas tarė: „Jeigu jie neklauso Mozės nei pranašų, tai nepatikės, jei kas ir iš mirusiųjų prisikeltų.“ ");
INSERT INTO litb_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","„Visuomet atsiras pagundų nusidėti, – vieną dieną pasakė Jėzus Savo mokiniams. – Bet vargas tam žmogui, kuris gundo. ");
INSERT INTO litb_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","3","Jam būtų geriau, jei ant kaklo būtų užmauta girnapusė ir jis būtų įmestas jūron, negu papiktintų šitų mažų vaikų sielas. Aš jus įspėju! Pabark savo brolį, jei jis nusižengia, o jeigu gailisi – atleisk jam. ");
INSERT INTO litb_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Net jei jis nusižengia septynis kartus per dieną ir kiekvieną kartą kreipiasi į tave, prašydamas atleidimo, atleisk jam.“ ");
INSERT INTO litb_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Vieną dieną apaštalai pasakė Viešpačiui: „Mums reikia didesnio tikėjimo, pamokyk, kaip jį sustiprinti.“ ");
INSERT INTO litb_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","„Jeigu jūsų tikėjimas būtų kaip garstyčios grūdas, – atsakė Jėzus, – jo užtektų šitam šilkmedžiui išrauti ir įmesti į siautėjančią jūrą. Jūsų paliepimas tuojau duotų rezultatus. ");
INSERT INTO litb_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","9","Kai tarnas grįžta suaręs laukus ir apžiūrėjęs avis, jis iškart nesėda prie stalo ir nevalgo, bet pirma paruošia valgį šeimininkui ir paduoda jam vakarienę, o tik paskui sėdasi pats. Jam net nedėkojama, nes jis paprasčiausiai atlieka pareigą. ");
INSERT INTO litb_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Taip pat ir jūs, darote tik tai, kas privaloma!“ ");
INSERT INTO litb_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Keliaudami Jeruzalės link, jie pasiekė ribątarp Galilėjos ir Samarijos. ");
INSERT INTO litb_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Kaimelio pakraštyje atokiai stovėjo dešimt raupsuotųjų ir ");
INSERT INTO litb_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","šaukė: „Jėzau, pasigalėk mūsų!“ ");
INSERT INTO litb_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jis pažvelgė į juos ir pasakė: „Eikite pas žydų kunigą ir pasirodykite, kad esate sveiki!“ Jiems einant, raupsai pranyko. ");
INSERT INTO litb_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Vienas jų sugrįžo pas Jėzų šaukdamas: „Šlovė Viešpačiui, aš išgydytas!“ ");
INSERT INTO litb_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Žmogus krito veidu ant žemės prieš Jėzų, dėkodamas už tai, kas įvyko. Jis buvo samarietis. ");
INSERT INTO litb_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jėzus paklausė: ");
INSERT INTO litb_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","„Ar ne dešimt pagydžiau? Kur kiti devyni? Ar tik šis svetimtautis sugrįžo pašlovinti Dievą?“ ");
INSERT INTO litb_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","O žmogui Jėzus pasakė: „Stokis ir eik. Tavo tikėjimas išgydė tave.“ ");
INSERT INTO litb_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Vieną dieną fariziejai paklausė Jėzų: „Kada ateis Dievo karalystė?“ Jėzus atsakė: „Dievo karalystės jūs nematysite ir ");
INSERT INTO litb_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","negalėsite pasakyti: „Ji prasidėjo čia, šioje ar kitoje vietoje“, nes Dievo karalystė yra jumyse.“ ");
INSERT INTO litb_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Vėliau Jis apie tai kalbėjosi su Savo mokiniais: „Ateis laikas, kai jūs norėsite pabūti su Manimi nors dieną, bet Manęs čia nebus, – tarė Jis. ");
INSERT INTO litb_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","– Jus pasieks žinios, kad Aš sugrįžau, kad Aš toje ar kitoje vietoje; netikėkite tuo ir neikite Manęs ieškoti, ");
INSERT INTO litb_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","nes, kai Aš grįšiu, jūs tikrai žinosite: tvykstelės žaibas, kuris viską danguje nušvies. ");
INSERT INTO litb_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Bet pirma visa ši tauta turi Mane atstumti ir Aš turiu daug iškentėti. ");
INSERT INTO litb_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Kai Aš grįšiu, žmonės bus tokie abejingi Dievui, kaip Nojaus laikais. ");
INSERT INTO litb_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Jie valgė ir gėrė, vedė ir tekėjo iki tos dienos, kol Nojus sėdo į laivą. Tada kilo tvanas, ir jie visi nuskendo. ");
INSERT INTO litb_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Pasaulis bus toks, kaip ir Loto dienomis – žmonės rūpinosi savo buitimi. Jie valgė, gėrė, pirko, pardavinėjo, sodino, statė, ");
INSERT INTO litb_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","kol vieną rytą Lotas išėjo iš Sodomos. Tuomet iš dangaus pasipylė ugnis ir siera ir sunaikino juos visus. ");
INSERT INTO litb_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Taip, kasdieniai darbai vyraus iki pat Mano sugrįžimo valandos. ");
INSERT INTO litb_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Tie, kurie bus išvykę iš namų, tą dieną tenegrįžta namo susidėti daiktų, o kas laukuose – tenegrįžta į miestą. ");
INSERT INTO litb_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Prisiminkite, kas atsitiko Loto žmonai. ");
INSERT INTO litb_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Kas stengsis išsaugoti savo gyvybę, praras ją, o kas negailės jos, tas bus išgelbėtas. ");
INSERT INTO litb_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Tą naktį du vyrai miegos viename kambaryjeir vienas bus paimtas, o kitas paliktas. ");
INSERT INTO litb_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Dvi moterys bus užsiėmusios namų ruoša. Viena bus paimta, o kita palikta. Taip ir su žmonėmis, dirbančiais kartu laukuose.“ ");
INSERT INTO litb_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","„Viešpatie, kur jie bus paimti?“ – klausė mokiniai. Jėzus atsakė: „Kur maita, ten susirenka maitvanagiai!“ ");
INSERT INTO litb_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Vieną dieną Jėzus mokė, kad reikia nuolatos melstis. ");
INSERT INTO litb_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","„Gyveno mieste teisėjas, – sakė Jis, – didelis bedievis. ");
INSERT INTO litb_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","To miesto našlė dažnai ateidavo prašyti, kad ją apgintų nuo skriaudiko. ");
INSERT INTO litb_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","Jis kurį laiką spyrėsi, bet pagaliau nusileido.“ „Nebijau nei Dievo, nei žmonių, – pasakė jis sau, – bet ši moteris labai įkyri. Aš apginsiu jos teises, nes čia vaikščiodama ji mane vargina!“ ");
INSERT INTO litb_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Tada Viešpats pasakė: ");
INSERT INTO litb_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","„Jeigu net blogas teisėjas pavargo, nejaugi Dievas neapgins Savo žmonių, kurie Jo šaukiasi dieną naktį. ");
INSERT INTO litb_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Taip! Jis jiems greitai atsakys! Tačiau svarbiausia tai: kai grįsiu Aš, Mesijas, kiek rasiu nepraradusių tikėjimo ir besimeldžiančių?“ ");
INSERT INTO litb_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Šią istoriją Jis papasakojo keliems žmonėms, kurie gyrėsi savo dorybe, o kitus niekino: ");
INSERT INTO litb_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","„Du vyrai nuėjo į šventyklą melstis. Vienas buvo išdidus, įsitikinęs savo teisumu fariziejus, o kitas – muitininkas. ");
INSERT INTO litb_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Išdidusis fariziejus meldėsi: „Ačiū Dievui, aš nesu nusidėjėlis kaip kiti, ypač kaip šis muitininkas! Aš nesu sukčius, svetimoteriautojas. ");
INSERT INTO litb_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Aš pasninkauju du kartus per savaitę. Aš duodu Dievui dešimtinę nuo to, ką pelnau.“ ");
INSERT INTO litb_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","O muitininkas stovėjo atokiau ir nedrįso besimelsdamas nė akių pakelti į dangų, tik liūdnai mušėsi į krūtinę, šaukdamas: „Dieve, pasigailėk manęs, nusidėjėlio.“ ");
INSERT INTO litb_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Aš sakau jums, šitas nusidėjėlis, o ne fariziejus grįžo namo išteisintas! Nes išdidieji bus pažeminti, o pažemintieji bus išaukštinti.“ ");
INSERT INTO litb_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Vieną dieną keletas motinų atnešė savo kūdikius, kad Jis juos paliestų ir palaimintų. Bet mokiniai liepė joms pasišalinti. ");
INSERT INTO litb_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","17","Tada Jėzus sukvietė vaikus ir pasakė mokiniams: „Leiskite mažutėliams eiti pas Mane! Niekada nevarykite jų šalin! Nes Dievo karalystė priklauso žmonėms, kurių širdys pasitikinčios kaip šių vaikų. Kas neturi tokio tikėjimo, niekada neįeis pro karalystės vartus!“ ");
INSERT INTO litb_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Kartą žydų religijos vadovas paklausė Jo: „Gerasis Mokytojau, ką aš turiu daryti, kad patekčiau į dangų?“ ");
INSERT INTO litb_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","„Ar supranti, ką sakai, kai vadini Mane geru? – Jėzus paklausė jį. – Tik Dievas iš tiesų geras, o ne kas kitas. ");
INSERT INTO litb_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Tu juk žinai dešimt Dievo įsakymų: nesvetimoteriauk, nežudyk, nevok, nemeluok, gerbk tėvus ir taip toliau.“ ");
INSERT INTO litb_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Žmogus atsakė: „Aš laikiausi šitų įsakymų nuo vaikystės.“ ");
INSERT INTO litb_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","„Dar vieno dalyko tau trūksta, – pasakė Jėzus. – Parduok visa, ką turi, ir atiduok pinigus vargšams. Už tai gausi atpildą danguje. Tada ateik ir sek paskui Mane.“ ");
INSERT INTO litb_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Kai žmogus tai išgirdo, nuėjo nuliūdęs, nes jis buvo labai turtingas. ");
INSERT INTO litb_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jėzus jį stebėjo nueinantį ir tada pasakė Savo mokiniams: „Kaip sunku turtingiems įeiti į Dievo karalystę! ");
INSERT INTO litb_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Lengviau kupranugariui pralįsti pro adatos skylutę, negu turtuoliui įeiti į Dievo karalystę.“ ");
INSERT INTO litb_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Tie, kurie girdėjo, sušuko: „Jeigu ją yra sunku pasiekti – kaip apskritai kas nors gali išsigelbėti?“ ");
INSERT INTO litb_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jis atsakė: „Dievas gali padaryti tai, ko žmogus negali.“ ");
INSERT INTO litb_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Petras pasakė: „Mes palikome savo namus ir nusekėme paskui Tave.“ ");
INSERT INTO litb_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","„Taip, – atsakė Jėzus. – Visiems, kurie kaip ir jūs paliko namus, žmoną, brolius, tėvus, vaikus dėl Dievo karalystės, ");
INSERT INTO litb_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","dabar bus atlyginta daug kartų daugiau; o taip pat jie gaus amžinąjį gyvenimą būsimajame amžiuje.“ ");
INSERT INTO litb_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Surinkęs dvylika apaštalų, Jis pasakė: „Kaip jūs žinote, mes vykstame į Jeruzalę. Kai ten nuvyksime, išsipildys senųjų pranašų žodžiai apie Mane. ");
INSERT INTO litb_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Aš būsiu atiduotas pagonių pajuokai, išgėdintas, apspjaudytas, ");
INSERT INTO litb_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","nuplaktas ir nužudytas. Trečią dieną Aš prisikelsiu.“ ");
INSERT INTO litb_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Bet jie nieko nesuprato, kas buvo sakoma, nes Jis kalbėjo lyg užuominomis. ");
INSERT INTO litb_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Kai jie pasiekė Jerichą, šalikelėje sėdėjo vienas aklas keliauninkas, prašydamas išmaldos. ");
INSERT INTO litb_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Išgirdęs praeinančios minios triukšmą, jis paklausė, kas vyksta. ");
INSERT INTO litb_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Jam pasakė, kad pro šalį eina Jėzus iš Nazareto, ");
INSERT INTO litb_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","todėl jis pradėjo šaukti: „Jėzau, Dovydo Sūnau, pasigailėk manęs!“ ");
INSERT INTO litb_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Minia prieštaravo, bandydama nutildyti, bet jis tik dar garsiau šaukė: „Dovydo Sūnau, pasigailėk manęs.“ ");
INSERT INTO litb_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Kai Jėzus atėjo į tą vietą, Jis sustojo. „Atveskit akląjį čia“, – tarė Jis. ");
INSERT INTO litb_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Po to kreipėsi į akląjį: „Ko nori?“ „Viešpatie, – maldavo tasai, – grąžink man regėjimą!“ ");
INSERT INTO litb_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ir Jėzus sutiko: „Gerai, praregėk! Tavo tikėjimas išgelbėjo tave!“ ");
INSERT INTO litb_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Žmogus tuojau praregėjo ir nusekė paskui Jėzų, šlovindamas Dievą. Ir visi, kurie matė šį stebuklą, taip pat šlovino Dievą. ");
INSERT INTO litb_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","2","Jėzui einant per Jericho miestą, žmogus, vardu Zachiejus, vienas įtakingiausių žydų mokesčių rinkėjų ir, žinoma, labai turtingas žmogus, ");
INSERT INTO litb_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","stengėsi pamatyti Jėzų, bet negalėjo, nes buvo neaukšto ūgio, ir minia jį užstojo. ");
INSERT INTO litb_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Todėl jis užbėgo priekin, įlipo į figmedį šalia kelio, kad stebėtų Jį iš čia. ");
INSERT INTO litb_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Kai Jėzus ėjo pro šalį, pažvelgė aukštyn ir pašaukė Zachiejų vardu: „Zachiejau, – Jis pasakė, – greičiau leiskis žemyn, nes Aš šiandien būsiu svečias tavo namuose!“ ");
INSERT INTO litb_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zachiejus skubiai nulipo ir nusivedė Jėzų į savo namus, labai susijaudinęs ir džiaugdamasis. ");
INSERT INTO litb_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Bet minia buvo nepatenkinta. „Jis nuėjo pas didelį nusidėjėlį“, – murmėjo jie. ");
INSERT INTO litb_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Tuo metu Zachiejus stovėjo prieš Viešpatį ir pasakė: „Mokytojau, nuo dabar aš atiduosiu pusę savo turto vargšams. Jei iš ko buvau paėmęs per didelį mokestį, aš save nubausiu, grąžindamas jiems keturis kartus daugiau!“ ");
INSERT INTO litb_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","10","Jėzus jam pasakė: „Tai rodo, kad šiandien išgelbėjimas atėjo į šiuos namus. Šis žmogus buvo vienas iš pražuvusiųjų Abraomo vaikų, ir Aš, Mesijas, atėjau ieškoti ir gelbėti tokių kaip jo sielų.“ ");
INSERT INTO litb_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Kadangi Jėzus artinosi prie Jeruzalės, sakė, kad Dievo karalystė prasidės tuojau pat. ");
INSERT INTO litb_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","„Vienas aukštos kilmės žmogus, gyvenantis tolimoje provincijoje, buvo pakviestas į šalies sostinę karūnuoti. ");
INSERT INTO litb_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Išvykdamas jis sukvietė dešimt padėjėjų ir kiekvienam davė po dešimt minų pragyvenimui, kol jis sugrįš. ");
INSERT INTO litb_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Bet kai kurie žmonės jo nekentė ir pasiuntė jam deklaraciją, teigiančią, kad jie sukilo ir nepripažins jo savo karaliumi. ");
INSERT INTO litb_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Sugrįžęs jis sukvietė visus, kuriems buvo davęs pinigų, nes norėjo patikrinti, kaip jie tuos pinigus panaudojo ir koks buvo pelnas. ");
INSERT INTO litb_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Pirmasis žmogus pranešė apie didelį pelną. Jis dešimt kartų padidino gautą sumą. ");
INSERT INTO litb_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","„Puiku! – sušuko karalius. – Tu geras žmogus. Tu elgeisi sąžiningai, todėl atlygindamas pavesiu tau valdyti dešimt miestų!“ ");
INSERT INTO litb_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Kitas žmogus taip pat pranešė apie didelį pelną. Jis penkis kartus padidino gautą sumą. ");
INSERT INTO litb_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","„Gerai, – pasakė šeimininkas. – Tu gali būti penkių miestų valdytojas!“ ");
INSERT INTO litb_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Trečias žmogus atsinešė tik tiek pinigų, kiek buvo gavęs. „Aš juos išsaugojau, – jis pasakė. – ");
INSERT INTO litb_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Aš bijojau, kad tu pareikalausi mano uždirbto pelno, nes tu griežtas žmogus, imi, kas ne tavo, ir pasisavinsi kitų užaugintą derlių.“ ");
INSERT INTO litb_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","„Tu niekingas ir piktas tarne, – sušuko karalius. – Aš griežtas! Taip, tikrai, bet jei žinojai, koks aš blogas esu, ");
INSERT INTO litb_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","tai kodėl nepadėjai pinigų į banką, kad aš galėčiau gauti procentus?“ ");
INSERT INTO litb_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Tada pasisukęs į kitus, stovinčius šalia, jis paliepė: „Atimkite iš jo pinigus ir atiduokite žmogui, kuris daugiausia uždirbo.“ ");
INSERT INTO litb_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","„Bet, pone, – sakė jie, – jis jau turi pakankamai.“ ");
INSERT INTO litb_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","„Taip, – atsakė karalius. – Visuomet taip yra, kad tie, kurie turi, gauna daugiau, o tie, kurie mažai teturi, greitai netenka visko. ");
INSERT INTO litb_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","O dabar atveskite tuos sukilusius priešus čia ir mano akivaizdoje įvykdykite mirties bausmę.“ ");
INSERT INTO litb_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Papasakojęs šią istoriją, Jėzus leidosi į Jeruzalę eidamas mokinių priešakyje. ");
INSERT INTO litb_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Prisiartinęs prie Betfagės ir Betanijos miestų ties Alyvų kalnu, Jis iš anksto pasiuntė du mokinius ");
INSERT INTO litb_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ir nurodė eiti į kitą kaimą, ten jie turėjo surasti asiliuką, pririštą šalia kelio. Tai buvo asiliukas, nepripratintas jodinėti. „Atriškite jį ir atveskite čia, – pasakė Jėzus. – ");
INSERT INTO litb_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ir jei kas paklaustų, ką jūs čia darote, tik pasakykite: „Jo reikia Viešpačiui.“ ");
INSERT INTO litb_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Jie rado asiliuką, kaip Viešpats buvo sakęs, ir, žinoma, ");
INSERT INTO litb_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","kai jį atrišo, šeimininkai reikalavo paaiškinimo. „Ką jūs darote, – jie klausė. – Kodėl jūs atrišate mūsų asiliuką?“ ");
INSERT INTO litb_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","O mokiniai paprasčiausiai atsakė: „Jo reikia Viešpačiui!“ ");
INSERT INTO litb_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Taip jie atvedė asiliuką pas Jėzų ir permetė jam keletą apsiaustų per nugarą, kad Jėzus galėtų ant jo užsėsti. ");
INSERT INTO litb_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","37","Tada minios prieš Jį ant kelio tiesė savo drabužius, kai jie pasiekė vietą, kur kelias ėjo Alyvų kalno šlaitu. Visa procesija pradėjo šaukti ir giedoti, šlovindama Dievą už nuostabius Jėzaus padarytus stebuklus. ");
INSERT INTO litb_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","„Dievas davė mums Karalių! – džiūgavo jie. – Tegyvuoja Karalius! Tedžiūgauja visas dangus! Šlovė Dievui aukštai danguje!“ ");
INSERT INTO litb_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Bet kai kurie fariziejai iš minios Jam šaukė: „Mokytojau, sudrausk Savo mokinius!“ ");
INSERT INTO litb_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jis atsakė jiems: „Jei šitie tylės – akmenys šauks!“ ");
INSERT INTO litb_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Kai jie priartėjo prie Jeruzalės ir pamatė priekyje miestą, Jis verkė jo. ");
INSERT INTO litb_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","„Amžina ramybė buvo jums pasiekiama, o jūs jos atsisakėte, – Jis verkė. – Dabar jau vėlu. ");
INSERT INTO litb_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Tavo priešai supils pylimą prie tavo sienų, apguls jus iš visų pusių, apsups ");
INSERT INTO litb_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ir sulygins su žeme jus ir jūsų vaikus. Jie parblokš ant žemės tave ir tavo vaikus, suspaus tave. Jūsų priešai nepaliks nė vieno akmens, nes jūs atsisakėte progos, kurią Dievas jums pasiūlė.“ ");
INSERT INTO litb_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Tada Jis atėjo į šventyklą ir pradėjo varyti lauk pirklius nuo prekystalių, ");
INSERT INTO litb_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","sakydamas jiems: „Evangelija skelbia, kad mano šventykla yra maldos namai, bet jūs ją pavertėte vagių lindyne.“ ");
INSERT INTO litb_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Po to Jis kasdien mokė šventykloje, bet aukštieji kunigai, kiti religijos vadovai bei tautos seniūnai norėjo surasti būdų Juo atsikratyti. ");
INSERT INTO litb_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Bet jie nieko negalėjo sugalvoti, nes Jis buvo žmonių numylėtinis. Jie klausėsi kiekvieno Jo žodžio. ");
INSERT INTO litb_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Mokydamas ir skelbdamas gerąją naujieną šventykloje, Jėzus susidūrė su aukštaisiais kunigais ir kitais religiniais vadovais bei tarnybos nariais. ");
INSERT INTO litb_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Jiems reikėjo sužinoti, kas leido Jam išvaryti pirklius iš šventyklos. ");
INSERT INTO litb_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","„Prieš atsakydamas Aš paklausiu vieno dalyko, – atsakė Jis. – ");
INSERT INTO litb_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ar Jonas buvo Dievo siųstas, ar jis veikė savo paties valia?“ ");
INSERT INTO litb_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Jie tai aptarė savo tarpe. „Jeigu mes sakysime, kad jo misija iš dangaus, tada mes įkliuvę, nes Jis paklaus: „Tada kodėl jūs juo netikėjote?“ ");
INSERT INTO litb_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Jei mes sakysime, kad Jonas nebuvo Dievo siųstas, žmonės užsvaidys mus akmenimis, nes jie įsitikinę, kad jis buvo pranašas.“ ");
INSERT INTO litb_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Pagaliau jie atsakė: „Mes nežinome.“ ");
INSERT INTO litb_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ir Jėzus atsakė: „Tada Aš taip pat neatsakysiu į jūsų klausimą.“ ");
INSERT INTO litb_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Tada Jis vėl pasisuko į žmones ir papasakojo jiems šią istoriją: „Žmogus pasodino vynuogyną, išnuomojo jį keliems ūkininkams ir išvyko keliems metams į tolimą šalį. ");
INSERT INTO litb_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Atėjus derliaus nuėmimo metui, jis pasiuntė vieną savo tarną į ūkį, kad jam duotų vynuogyno derliaus dalį. Bet nuomininkai sumušė jį, išsiuntė atgal tuščiomis. ");
INSERT INTO litb_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Jis vėl nusiuntė kitą tarną, bet ir tą anie sumušė, išjuokė ir paleido tuščiomis. ");
INSERT INTO litb_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Buvo pasiųstas ir trečias žmogus. Ir tam nepasisekė. Jis taip pat buvo sužeistas ir pavarytas į šalį. ");
INSERT INTO litb_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","„Ką man daryti? – pats savęs paklausė šeimininkas. – Žinau! Aš pasiųsiu savo mylimąjį sūnų. Gal jie parodys jam pagarbą?“ ");
INSERT INTO litb_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Kai vynininkai pamatė jo sūnų, jie pasakė: „Mums duota proga. Po tėvo mirties šis jaunuolis paveldės visą žemę. Čionai! Užmuškim jį. Tada paveldėtas turtas bus mūsų.“ ");
INSERT INTO litb_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Jie išvilko jį laukan ir užmušė. Ką darys šeimininkas? ");
INSERT INTO litb_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Aš jums sakau: jis ateis, užmuš juos ir išnuomos vynuogyną kitiems.“ „Bet jie niekada to nepadarys“, – protestavo Jo klausytojai. ");
INSERT INTO litb_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jėzus, žvelgdamas į juos, paklausė: Ką reiškia Rašto posakis: „Akmuo, kurį statytojai atmetė, tapo kertiniu akmeniu!“ ");
INSERT INTO litb_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Jis pridūrė: „Kas tik kris ant šito akmens, suduš, ant ko tas akmuo užgrius, tas bus sumaltas į miltus.“ ");
INSERT INTO litb_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Kai aukštieji kunigai ir religijos vadovai išgirdo šią istoriją, kurią Jis papasakojo, jie norėjo Jį tuojau suimti, nes suprato, kad apie juos buvo kalbama. Jo palyginimuose jie buvo piktieji nuomininkai. Bet jie bijojo, kad, suėmus Jį, kils riaušės. Todėl jie stengėsi nutverti kokį žodį, kad galėtų pranešti romėnų valdininkui ir, suradę priežastį, suimti. ");
INSERT INTO litb_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Naudodamiesi proga, jie siuntė šnipus, kurie apsimetė esą sąžiningi vyrai. ");
INSERT INTO litb_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Jie sakė Jėzui: „Mokytojau, mes žinome, koks Tu sąžiningas. Tu visuomet sakai tiesą ir žiūrėdamas teisybės nepaisai žmonių luomų, bet mokai Dievo kelių. ");
INSERT INTO litb_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Dabar pasakyk mums, ar reikia mokėti romėnų vyriausybei mokesčius ar ne?“ ");
INSERT INTO litb_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Puikiai įžvelgdamas jų klastą, Jis tarė jiems: ");
INSERT INTO litb_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","„Parodykite man monetą. Kieno atvaizdas ant jos? Ir kieno vardas?“ Jie atsakė: „Ciesoriaus – romėnų imperatoriaus.“ ");
INSERT INTO litb_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Jis tarė: „Tada atiduokite imperatoriui visa, kas imperatoriaus, o Dievui visa, kas Dievo.“ ");
INSERT INTO litb_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Taip sužlugo jų pastangos pergudrauti Jį žmonių akivaizdoje. Stebėdamiesi Jo atsakymais, jie nutilo. ");
INSERT INTO litb_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Tada pas Jėzų atėjo keletas sadukiejų – taip vadinosi žmonės, kurie skelbė, kad mirtis yra būties pabaiga, kad nėra prisikėlimo – ");
INSERT INTO litb_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","sakydami: „Mozės įstatymai teigia: „Jei kieno vedęs brolis numirtų bevaikis, tuomet jo brolis tegul veda našlę, ir jų vaikai pagal įstatymą priklausys mirusiam žmogui, kad pratęstų jo giminę.“ ");
INSERT INTO litb_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Mes žinome septynių brolių šeimą. Vyriausias vedė ir mirė bevaikis. ");
INSERT INTO litb_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Jo brolis vedė našlę, ir jis taip pat mirė. Vaikų taip pat nebuvo. ");
INSERT INTO litb_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ir taip jau atsitiko, kad vienas po kito ją vedė septyni broliai, o paskui mirė, nepalikdami vaikų. ");
INSERT INTO litb_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Galiausiai mirė ir moteris. ");
INSERT INTO litb_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Štai mūsų klausimas: „Kieno žmona ji bus prisikėlusi? Nes visi buvo vedę ją vieną.“ ");
INSERT INTO litb_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jėzus atsakė: „Vedybos yra šios žemės žmonėms, bet kai tie, ");
INSERT INTO litb_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","kurie pasirodo verti prisikelti iš numirusių, nueis į dangų, jie neves ir netekės. ");
INSERT INTO litb_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ir jie niekada nebegalės mirti. Tuo atžvilgiu jie tolygūs angelams. Jie yra Dievo sūnūs, nes jie prikelti iš numirusių naujam gyvenimui. ");
INSERT INTO litb_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Tu klausi, ar yra prisikėlimas ar jo nėra, – Mozės pasakojime tai įrodoma. Kai jis aprašo, kaip Dievas jam pasirodė degančiame krūme, jis kalba apie Dievą kaip Abraomo Dievą, Izaoko Dievą, Jokūbo Dievą. ");
INSERT INTO litb_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Sakyti, kad Viešpats yra kurio nors žmogaus Dievas, tai reiškia, kad asmuo yra gyvas, nemiręs. Taigi Dievo požiūriu visi žmonės gyvi.“ ");
INSERT INTO litb_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","„Gerai pasakyta, Mokytojau!“ – pastebėjo keletas čia stovinčių žydų įstatymo žinovų. ");
INSERT INTO litb_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Jie nebedrįso daugiau klausinėti. ");
INSERT INTO litb_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Tada Jėzus jų paklausė: „Kodėl taip yra, kad Kristus, Mesijas, sakoma esąs karaliaus Dovydo palikuonis? ");
INSERT INTO litb_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Pats Dovydas psalmių knygoje rašė: Dievas pasakė mano Viešpačiui, Mesijui: „Sėsk Mano dešinėje, ");
INSERT INTO litb_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","kol Tavo priešus sudėsiu po Tavo kojomis.“ ");
INSERT INTO litb_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Kaip gali Mesijas tuo pačiu metu būti ir Dovydo sūnumi, ir Dovydo Dievu?“ ");
INSERT INTO litb_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Tada miniai klausantis, Jis pasakė: ");
INSERT INTO litb_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","„Saugokitės tų religijos žinovų, nes jie mėgsta rengtis prabangiais drabužiais ir jiems patinka, kad žmonės jiems lenktųsi, kai jie eina gatve. Ir kaip jie mėgsta garbingas vietas sinagogose bei religinėse šventėse! ");
INSERT INTO litb_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Bet net kalbėdami ilgas maldas su dideliu išoriniu nuolankumu, jie ruošia planus, kaip atimti iš našlių pinigus. Todėl šių žmonių laukia baisiausias Dievo nuosprendis!“ ");
INSERT INTO litb_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Stovėdamas šventykloje, Jis stebėjo turtuolius, metančius dovanas į rinkliavų dėžutę. ");
INSERT INTO litb_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Tuo metu pro šalį ėjo neturtinga našlė ir įmetė dvi mažas varines monetas. ");
INSERT INTO litb_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","„Iš tiesų, – Jis pastebėjo, – ši vargšė našlė davė daugiau nei visi kiti kartu paėmus. ");
INSERT INTO litb_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Nes jie davė truputį iš to, kas jiems atliko, bet ji, nors ir neturtinga, atidavė visa, ką turėjo.“ ");
INSERT INTO litb_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Keletas Jo mokinių pradėjo kalbėti apie šventyklą su gražiais akmenimis ir papuošimais ant sienų. ");
INSERT INTO litb_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Bet Jėzus pasakė: „Ateis laikas, kai visi šie dalykai, kuriais žavitės, bus nugriauti, ir nė vienas akmuo nebus paliktas ant akmens, bet viskas pavirs žvirgždo krūva.“ ");
INSERT INTO litb_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","„Mokytojau! – šaukė jie. – Kada? Ar bus koks nors įspėjimas iš anksto?“ ");
INSERT INTO litb_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jis atsakė: „Neleiskite, kad jus suklaidintų. Nes daugelis ateis, skelbsis Mesiju ir sakys: „Atėjo laikas“, bet netikėkite jais. ");
INSERT INTO litb_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kai jūs girdite apie prasidedančius karus ir maištus, nepasimeskite. Iš tiesų, karai turi kilti, bet ne greit pasibaigs, ");
INSERT INTO litb_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","nes tauta sukils prieš tautą ir karalystė prieš karalystę. ");
INSERT INTO litb_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Bus dideli žemės drebėjimai ir badas, daugelyje šalių kils epidemijos ir baisūs dalykai vyks danguje. ");
INSERT INTO litb_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Bet prieš tai bus ypatingo persekiojimo metas, ir jus vedžios pas karalius ir valdytojus, tąsys po sinagogas ir kalėjimus dėl Mano vardo. ");
INSERT INTO litb_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Tada Mesijas pasirodys žinomas ir gerbiamas. ");
INSERT INTO litb_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Todėl nesirūpinkite, kaip atsakysite į klausimus, ");
INSERT INTO litb_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","nes Aš jums duosiu tinkamus žodžius ir tokią išmintį, kad nė vienas iš jūsų priešininkų negebės prieštarauti. ");
INSERT INTO litb_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Net jūsų artimiausieji – jūsų tėvai, broliai, giminės, draugai – išduos jus ir suims, ir keletas jūsų bus nužudyti. ");
INSERT INTO litb_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ir visi nekęs jūsų, kadangi jūs esate Mano. ");
INSERT INTO litb_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Bet nė vienas plaukas nuo jūsų galvos nepranyks! ");
INSERT INTO litb_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Jei jūs būsite tvirti, tai jūsų sielos bus išgelbėtos. ");
INSERT INTO litb_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Bet kai pamatysite Jeruzalę, supamą kariuomenės, tada jūs žinokite, jog atėjo jos sunaikinimo laikas. ");
INSERT INTO litb_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Tada Jeruzalės žmonės tebėga į kalvas. Tegul Jeruzalės gyventojai stengiasi pabėgti, o ir tie, kurie už miesto, tegul nesistengia sugrįžti. ");
INSERT INTO litb_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Nes tiems bus teismo dienos, ir išsipildys Senajame Rašte parašyti pranašų žodžiai. ");
INSERT INTO litb_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Vargas nėščioms moterims tomis dienomis ir toms, kurios turi mažus vaikus. Nes vargas tai tautai ir didelis pasipiktinimas jos žmonėmis. ");
INSERT INTO litb_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Juos žiauriai nužudys priešai ir kaip tremtinius ir belaisvius išblaškys po visas pasaulio tautas, o Jeruzalę užkariaus ir sutryps prieš savo triumfo pabaigą. ");
INSERT INTO litb_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Tada danguje vyks keisti dalykai – įspėjimai, būsimų šėtoniškų įvykių ženklai saulėje, mėnulyje, žvaigždėse, o čia, žemėje, tautos, apstulbintos audringų jūrų ir keistų potvynių bei atoslūgių, atsidurs sąmyšyje. ");
INSERT INTO litb_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Daugelio žmonių drąsa svyruos dėl baisaus likimo, ateinančio į žemę, nes bus pažeistas paties dangaus tvirtumas. ");
INSERT INTO litb_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Tada žemės žmonės išvys Mane, Išgelbėtoją, ateinantį debesyje su didžia galybe ir šlove. ");
INSERT INTO litb_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Taigi, kai visi šitie dalykai prasidės, stovėkite tiesiai ir pakelkite akis. Nes jūsų išgelbėjimas arti.“ ");
INSERT INTO litb_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Tada Jis palygino: „Stebėkite figmedį ar kuri kitą medį. ");
INSERT INTO litb_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Kai pasirodo lapeliai, ir be sakymo žinote, kad vasara arti. ");
INSERT INTO litb_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Taigi, pamatę įvykius, kuriuos aprašiau, jūs taip pat galite būti tikri, kad Dievo karalystė arti. ");
INSERT INTO litb_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Aš iškilmingai jums pareiškiu: Kai šitie dalykai pasirodys, ateis pasaulio pabaiga. ");
INSERT INTO litb_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ir nors visas dangus ir žemė praeis, Mano žodžiai nepraeis. ");
INSERT INTO litb_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","Saugokitės! Teneužklumpa Mano staigus atėjimas jūsų nepasirengusių. Neleiskite, kad rasčiau jus, gyvenančius nerūpestingai, ūžiančius, geriančius ir užsiėmusius šio pasaulio reikalais, kaip ir visi žmonės. ");
INSERT INTO litb_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Nuolatos budėkite ir melskitės, kad ateitumėte pas Mane, jei galima, nepatyrę tų baisumų.“ ");
INSERT INTO litb_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","38","Kasdien Jėzus eidavo į šventyklą mokyti, o minios pradėdavo rinktis anksti ryte. Kiekvieną naktį Jis praleisdavo Alyvų kalne. ");
INSERT INTO litb_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Pagaliau artėjo Velykų šventė – žydų iškilmės, kai valgoma tik nerauginta duona. ");
INSERT INTO litb_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Aukštieji kunigai ir kiti religijos vadovai šurmuliavo, rengdamiesi nužudyti Jėzų, bet ir nesukelti maišto. To jie labai bijojo. ");
INSERT INTO litb_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Tada šėtonas įėjo į Judą Iskarijotą, kuris buvo vienas iš dvylikos mokinių, ");
INSERT INTO litb_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ir jis nuėjo pas aukštuosius kunigus, vadus bei šventyklos sargus aptarti, kaip geriausiai išduoti Jėzų. ");
INSERT INTO litb_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Jie, žinoma, džiaugėsi sužinoję, kad Judas pasiruošęs padėti, ir pažadėjo jam atlyginimą. ");
INSERT INTO litb_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas ieškojo progos, kaip tyliai, niekam nematant, suimti Jėzų. ");
INSERT INTO litb_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Atėjo Velykų iškilmių diena. Buvo paskerstas Velykų avinėlis ir valgomas su nerauginta duona. ");
INSERT INTO litb_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jėzus pirma pasiuntė Petrą ir Joną, kad surastų vietą ir paruoštų Velykų valgį. ");
INSERT INTO litb_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","„Kur nori, kad mes eitume?“ – klausė jie. ");
INSERT INTO litb_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ir Jis atsakė: „Vos tik įeisite į Jeruzalę, pamatysite žmogų, nešanti vandens ąsotį. Sekite, į kuriuos namus jis įeis, ");
INSERT INTO litb_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ir pasakykite žmogui, kuris ten gyvena: „Mūsų Mokytojas liepė, kad jūs parodytumėte svečių kambarį, kur Jis galės valgyti Velykų vakarienę su Savo mokiniais.“ ");
INSERT INTO litb_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Jis nusives jus į viršų, į didelį mums skirtą kambarį. Tai ir bus ta vieta. Eikite pirma ir paruoškite ten valgį.“ ");
INSERT INTO litb_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Išėję į miestą, jie rado viską, kaip Jėzus buvo sakęs, ir parengė Velykų vakarienę. ");
INSERT INTO litb_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Tada atvyko Jėzus su kitais mokiniais ir kartu susėdo prie stalo. ");
INSERT INTO litb_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Jis pasakė: „Aš didžiai laukiau šios valandos, trokšdamas valgyti šį Velykų valgį su jumis prieš Savo kančių pradžią. ");
INSERT INTO litb_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Nes Aš jums dabar sakau: „Daugiau su jumis nebevalgysiu šio maisto, kol jo reikšmė neatsiskleis Dievo karalystėje.“ ");
INSERT INTO litb_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Tada, paėmęs vyno taurę ir sukalbėjęs padėkos maldą, Jis tarė: „Imkite ir dalinkitės tarp savęs. ");
INSERT INTO litb_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nes Aš nebegersiu vyno, kol ateis Dievo karalystė.“ ");
INSERT INTO litb_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Tada Jis paėmė riekę duonos, sukalbėjo padėkos maldą, laužė ją ir davė apaštalams, tardamas: „Tai yra Mano kūnas, kuris už jus atiduodamas. Imkite ir valgykite Mano atminimui.“ ");
INSERT INTO litb_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Lygiai taip po vakarienės Jis paėmė taurę, sakydamas: „Ši taurė yra Naujoji Sandora Mano kraujyje, kuris už jus išliejamas. ");
INSERT INTO litb_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Čia, tarp mūsų, sėdintis kaip draugas prie stalo yra žmogus, kuris mane išduos. ");
INSERT INTO litb_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Aš privalau mirti. Tai Dievo sumanymo dalis. Bet didis siaubas laukia to, kuris Mane išduos.“ ");
INSERT INTO litb_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Tada mokiniai stebėjosi, kas galėtų padaryti tokį dalyką. ");
INSERT INTO litb_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ir jie pradėjo tarp savęs ginčytis, kuris bus aukščiausias besiartinančioje karalystėje. ");
INSERT INTO litb_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jėzus jiems tarė: „Šiame pasaulyje karaliai nurodinėja tarnams, o tarnai neturi galimybės pasirinkti. ");
INSERT INTO litb_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Bet jums vadovaus Tas, kuris geriausiai jums tarnauja. ");
INSERT INTO litb_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Visame pasaulyje mokytą prie stalo aptarnauja jo tarnai. Tik ne čia! Nes Aš esu jūsų tarnas. ");
INSERT INTO litb_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Nepaisant to, jūs likote Man ištikimi tomis baisiomis dienomis. ");
INSERT INTO litb_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Kadangi Mano Tėvas skyrė Man karalystę, Aš duodu jums teisę ");
INSERT INTO litb_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","valgyti ir gerti prie Mano stalo toje karalystėje. Jūs sėdėsite sostuose, teisdami dvylika Izraelio giminių. ");
INSERT INTO litb_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Simonai, Simonai, šėtonas prašė jus atiduoti ir persijoti tarsi kviečius, ");
INSERT INTO litb_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","bet Aš meldžiausi už tave, kad tavo tikėjimas visiškai nežlugtų. Taigi, kai tu atgailausi už savo nuodėmes ir vėl į Mane atsisuksi, sustiprink ir atstatyk savo brolių tikėjimą.“ ");
INSERT INTO litb_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Simonas pasakė: „Viešpatie, aš pasiruošęs eiti su Tavimi į kalėjimą ir net mirti su Tavimi.“ ");
INSERT INTO litb_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Bet Jėzus atsakė: „Petrai, leisk man kai ką tau pasakyti. Šią naktį, dar gaidžiui nepragydus, tu Manęs išsiginsi tris kartus, tvirtindamas, kad nepažįsti.“ ");
INSERT INTO litb_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Tada Jėzus jų paklausė: „Kai Aš jus išsiunčiau skelbti gerosios naujienos, jūs neturėjote pinigų, krepšio ir atliekamų drabužių, kaip jūs tada vertėtės?“ „Puikiai!“ – jie atsakė. ");
INSERT INTO litb_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","„Bet dabar pasiimkite krepšį, jei jį turite, ir pinigų. Ir jei neturite kalavijo, geriau parduokite drabužius ir nusipirkite jį. ");
INSERT INTO litb_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Nes atėjo laikas, kai išsipildys toji pranašystė apie Mane: „Jis bus pasmerktas kaip nusikaltėlis.“ Taip išsipildys viskas, kas pranašų apie Mane parašyta.“ ");
INSERT INTO litb_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","„Mokytojau, – jie sakė, – mes turime du kalavijus su savimi.“ „Pakanka!“ – Jis atsakė. ");
INSERT INTO litb_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Tada, lydimas mokinių, Jis išėjo iš viršutiniame aukšte esančio kambario ir kaip paprastai nuėjo į Alyvų kalną. ");
INSERT INTO litb_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ten Jis jiems tarė: „Melskite Dievą, kad pagundos jūsų nenugalėtų.“ ");
INSERT INTO litb_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Jis nuėjo toliau, maždaug per akmens metimą, atsiklaupė ir ėmė melstis šiais žodžiais: ");
INSERT INTO litb_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","„Tėve, jei nori, atimk iš Manęs šią baisią taurę, bet Aš noriu, kad pildytųsi Tavo valia, o ne Mano.“ ");
INSERT INTO litb_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Tada iš dangaus pasirodė angelas, nes Jėzų buvo apėmusi tokia dvasios kančia, kad Jis, ");
INSERT INTO litb_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","vis karščiau melsdamasis, pradėjo prakaituoti krauju ir vis didesni lašai krito ant žemės. ");
INSERT INTO litb_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Pagaliau Jis vėl atsistojo ir grįžo pas mokinius, bet rado juos miegančius, prislėgtus liūdesio. ");
INSERT INTO litb_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","„Miegate! – pasakė. – Kelkitės! Melskite Dievą, kad gundomi nesukluptumėte!“ ");
INSERT INTO litb_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jam bekalbant, prisiartino minia, vedama Judo, vieno iš dvylikos apaštalų. Judas priėjo prie Jėzaus ir pabučiavo į skruostą draugiškai sveikindamas. ");
INSERT INTO litb_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Bet Jėzus pasakė: „Judai, savo pabučiavimu tu išduodi Žmogaus Sūnų?“ ");
INSERT INTO litb_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Kiti mokiniai pamatę, kas gali įvykti, sušuko: „Mokytojau, ar mes kovosim? Mes atsinešėme kalavijus!“ ");
INSERT INTO litb_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Vienas jų puolė aukštojo kunigo tarną ir nukirto jam dešinę ausį. ");
INSERT INTO litb_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Bet Jėzus pasakė: „Daugiau nesipriešinkite.“ Jis palietė vietą, kur buvo žmogaus ausis, ir išgydė ją. ");
INSERT INTO litb_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Tada Jėzus kreipėsi į šventyklos aukštuosius kunigus, apsaugos viršininkus ir seniūnus, religijos vadovus, kurie buvo minios priekyje: „Ar Aš koks plėšikas, kad jūs išėjote Manęs suimti ginkluoti kalavijais ir vėzdais? ");
INSERT INTO litb_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Kodėl jūs Manęs nesuėmėte šventykloje? Aš ten būdavau kiekvieną dieną. Bet dabar atėjo jūsų metas – kai siautėja šėtono jėga.“ ");
INSERT INTO litb_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jie sugavo Jį ir nuvedė į aukščiausiojo kunigo rūmus, o Petras sekė Jį iš tolo. ");
INSERT INTO litb_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Kareiviai kieme susikūrė ugnį ir susėdo ratu pasišildyti. Ten prie jų prisijungė Petras. ");
INSERT INTO litb_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Viena tarnaitė pastebėjo jį laužo šviesoje ir pradėjo įdėmiai apžiūrinėti. Pagaliau ji prašneko: „Šis žmogus buvo su Jėzumi!“ ");
INSERT INTO litb_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Petras išsigynė, sakydamas: „Moteriške, aš Jo net nepažįstu!“ ");
INSERT INTO litb_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Netrukus kažkas kitas pažvelgė į jį ir pasakė: „Tu greičiausiai esi iš jų.“ „Ką tu, žmogau“, – atsakė Petras. ");
INSERT INTO litb_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Maždaug po valandos dar kažin kas ėmė atkakliai tvirtinti: „Aš žinau, šis vyrukas yra vienas Jėzaus mokinių, nes abu iš Galilėjos.“ ");
INSERT INTO litb_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Bet Petras pasakė: „Žmogau, aš nežinau apie ką tu kalbi.“ Jam bekalbant pragydo gaidys. ");
INSERT INTO litb_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Tuomet Jėzus atsigręžęs pažvelgė į Petrą. Tada Petras atsiminė, ką Jis buvo pasakęs: „Dar gaidžiui nepragydus, rytoj tu tris kartus Manęs išsiginsi.“ ");
INSERT INTO litb_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Petras išėjo iš kiemo karčiai verkdamas. ");
INSERT INTO litb_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Dabar Jėzų saugantys kareiviai pradėjo iš jo tyčiotis. ");
INSERT INTO litb_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Jie užrišo Jam akis, mušė Jį kumščiais ir klausė: „Kas šį sykį Tave užgavo, pranaše?“ ");
INSERT INTO litb_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Jie visaip Jį įžeidinėjo. ");
INSERT INTO litb_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Kitą rytą, auštant, susirinko žydų Aukščiausiasis teismas, taip pat religinė valdžia. Jėzų išvedė prieš Tarybą ");
INSERT INTO litb_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","ir liepė pasakyti, ar Jis tebetvirtina esąs Mesijas, ar ne. Bet Jis atsakė: „Jeigu jums pasakysiu, jūs nepatikėsite ");
INSERT INTO litb_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","arba neleisite Man išdėstyti reikalo. ");
INSERT INTO litb_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Bet greitai ateis laikas, kai Aš, Mesijas, sėdėsiu soste šalia Visagalio Dievo.“ ");
INSERT INTO litb_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Jie visi šaukė: „Tada Tu tvirtini esąs Dievo Sūnus?“ Jis atsakė: „Taip, Aš esu.“ ");
INSERT INTO litb_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","„Kam mums reikia kito įrodymo? – šaukė jie. – Juk mes patys girdėjome Jį taip sakant.“ ");
INSERT INTO litb_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Tada visa Taryba nuvedė Jėzų pas vietininką Pilotą. ");
INSERT INTO litb_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Jie iš karto pradėjo Jį kaltinti: „Šis jaunuolis vedė mūsų žmones į pražūtį, sakydamas nemokėti mokesčių romėnų vyriausybei, tvirtindamas, kad Jis mūsų Mesijas – Karalius.“ ");
INSERT INTO litb_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Todėl Pilotas paklausė: „Ar esi jų Mesijas ir Karalius?“ „Taip, – atsakė Jėzus. – Taip yra, kaip sakai.“ ");
INSERT INTO litb_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilotas pasisuko į vyresniuosius kunigus, į minią ir pasakė: „Na? Tai nėra nusikaltimas.“ ");
INSERT INTO litb_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Tada jie įsiuto: „Bet Jis kursto riaušes prieš vyriausybę visoje Judėjoje, nuo Galilėjos iki Jeruzalės.“ ");
INSERT INTO litb_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","„Gal Jis tada iš Galilėjos?“ – paklausė Pilotas. ");
INSERT INTO litb_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Kai Jėzus tai patvirtino, Pilotas liepė Jį nuvesti pas karalių Erodą, nes Galilėja tada buvo Erodo valdžioje. O Erodas tuo metu buvo Jeruzalėje. ");
INSERT INTO litb_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Erodas džiaugėsi, turėdamas progą pamatyti Jėzų, nes buvo daug apie Jį girdėjęs ir tikėjosi pamatyti Jį darant stebuklą. ");
INSERT INTO litb_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Jis bėrė Jėzui klausimus vieną po kito, bet atsakymo nesulaukė. ");
INSERT INTO litb_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Tuo tarpu vyriausieji kunigai ir kiti religijos vadovai stovėjo čia, garsiai Jį kaltindami. ");
INSERT INTO litb_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Dabar Erodas ir jo kareiviai pradėjo tyčiotis iš Jėzaus, išjuokė Jį ir, aptaisę karališkais rūbais, nusiuntė atgal pas Pilotą. ");
INSERT INTO litb_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Tą dieną iki šiol buvę priešai, Erodas ir Pilotas, tapo gerais draugais. ");
INSERT INTO litb_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Tada Pilotas, sukvietęs aukštuosius kunigus, kitus žydų vadovus ir liaudį, ");
INSERT INTO litb_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","paskelbė savo nuosprendi: „Jūs atvedėte man šį Žmogų, kaltindami Jį už vadovavimą maištui prieš romėnų vyriausybę. Aš Jį smulkiai išklausinėjau ir įsitikinau, kad Jis nekaltas. ");
INSERT INTO litb_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Erodas padarė tą pačią išvadą ir vėl atsiuntė Jį atgal. Šis Žmogus nepadaręs nieko, už ką derėtų bausti mirtimi. ");
INSERT INTO litb_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Todėl aš Jį nuplakdinsiu odiniu diržu su švino gabalais ir paleisiu.“ ");
INSERT INTO litb_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","18","Bet dabar minioje kilo didelis triukšmas, nes jie vienu balsu šaukė: „Nukryžiuok Jį, paleisk mums Barabą!“ ");
INSERT INTO litb_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Barabas sėdėjo kalėjime už žmogžudystę ir maišto Jeruzalėje kurstymą prieš vyriausybę.) ");
INSERT INTO litb_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilotas ginčijosi, nes norėjo paleisti Jėzų. ");
INSERT INTO litb_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Tačiau minia šaukė: „Nukryžiuoti! Nukryžiuoti!“ ");
INSERT INTO litb_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Jis dar trečią kartą klausė: „Kodėl? Kokį nusikaltimą Jis padarė? Aš neradau priežasties Jo žudyti, todėl aš Jį nuplakdinsiu ir paleisiu.“ ");
INSERT INTO litb_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Bet jie šaukė vis garsiau ir garsiau, reikalaudami Jėzaus mirties, ir jų šauksmai nugalėjo. ");
INSERT INTO litb_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pilotas nuteisė Jėzų mirti, kaip jie reikalavo. ");
INSERT INTO litb_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Jiems reikalaujant, jis paleido iš kalėjimo Barabą, nuteistą už maištą ir žmogžudystę. Jėzų atidavė jų valiai. ");
INSERT INTO litb_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Kai minia lydėjo Jėzų į mirties vietą, Simonas iš Kirėnės, kuris ėjo iš kaimo į Jeruzalę, buvo priverstas eiti iš paskos ir nešti Jo kryžių. ");
INSERT INTO litb_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Jėzų lydėjo didelės minios ir daug liūdesio apimtų moterų. ");
INSERT INTO litb_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Bet Jėzus, atsigręžęs į jas, prabilo: „Jeruzalės dukros, verkite ne Manęs, bet savęs ir savo vaikų! ");
INSERT INTO litb_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Nes ateis dienos, kai neturinčios vaikų motinos bus iš tiesų laikomos laimingomis. ");
INSERT INTO litb_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Žmonės maldaus, kad griūdami kalnai juos sunaikintų, o kalvos palaidotų. ");
INSERT INTO litb_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Jei šitaip daroma Man, Gyvybės medžiui, kas laukia jūsų?“ ");
INSERT INTO litb_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","33","Du kiti nusikaltėliai buvo vedami nužudyti kartu su Juo į vietą, vadinamą „kaukole.“ Čia visi trys buvo nukryžiuoti. Jėzus – ant vidurinio kryžiaus, o du nusikaltėliai – iš abiejų pusių. ");
INSERT INTO litb_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","„Tėve, atleisk šiems žmonėms, nes jie nežino, ką daro“, – Jėzus meldėsi. O kareiviai lošė iš jo drabužių, mėtydami kauliuką dėl kiekvieno daikto. ");
INSERT INTO litb_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Minia stebėjo. Žydų vadovai tyčiodamiesi juokėsi: „Jis buvo toks geras, padėdamas kitiems, pažiūrėkim, kaip Jis išsigelbės, jei tikrai yra Dievo išrinktasis Mesijas.“ ");
INSERT INTO litb_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Kareiviai išjuokė Jį, siūlydami parūgusio vyno. ");
INSERT INTO litb_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Jie šaukė Jam: „Jei Tu žydų Karalius – gelbėkis pats!“ ");
INSERT INTO litb_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Viršum Jo buvo prikalta lentelė su užrašu: „Šitas yra žydų Karalius.“ ");
INSERT INTO litb_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Vienas iš greta nukryžiuotų nusikaltėlių įžeidinėjo Jėzų: „Argi Tu ne Mesijas? Įrodyk tai, išgelbėdamas Save ir mus, jei gali.“ ");
INSERT INTO litb_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Bet kitas nusikaltėlis sudraudė jį: „Ir Dievo tu nebijai net mirties akivaizdoje! ");
INSERT INTO litb_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Savo piktais darbais mes užsitarnavome mirtį, bet šis Žmogus nepadarė nieko bloga.“ ");
INSERT INTO litb_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Tada jis pasakė: „Jėzau, atsimink mane, kai įžengsi į Savo karalystę.“ ");
INSERT INTO litb_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jėzus atsakė: „Šiandien su Manimi tu būsi rojuje. Tai Mano pažadas.“ ");
INSERT INTO litb_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Buvo po vidurdienio, kai tamsa trims valandoms apgaubė žemę. ");
INSERT INTO litb_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Saulė aptemo ir staiga stora šventyklos uždanga perplyšo pusiau. ");
INSERT INTO litb_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Tada Jėzus sušuko: „Tėve, Aš Tau atiduodu Savo dvasią.“ Ir su tais žodžiais lūpose Jis mirė. ");
INSERT INTO litb_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Kai vykdantis nuosprendžius romėnų karinio dalinio kapitonas pamatė, kas atsitiko, buvo pritrenktas Dievo akivaizdoje iš nuostabos ir pasakė: „Žinoma, šis Žmogus buvo nekaltas.“ ");
INSERT INTO litb_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ir kai žmonės, atėję pažiūrėti reginio, pamatė, kad Jėzus miręs, jie skirstėsi namo labai nusiminę. ");
INSERT INTO litb_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Tuo tarpu Jėzaus draugai ir moterys, kurios sekė Jį nuo pat Galilėjos, stovėjo atokiau ir viską matė. ");
INSERT INTO litb_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","52","Tada vienas žmogus, vardu Juozapas, žydų Aukščiausiojo teismo narys, nuėjo pas Pilotą ir paprašė Jėzaus kūno. Jis buvo pamaldus žmogus, kuris laukė Mesijo atėjimo ir nesutiko su nuosprendžiu ir kitais žydų vadovų veiksmais. ");
INSERT INTO litb_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Tada jis nuėmė Jėzaus kūną, suvyniojo į ilgą lininę drobulę ir paguldė į naują kapą, iškaltą uolos rūsyje. ");
INSERT INTO litb_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Tai buvo padaryta penktadienį po pietų, pasiruošimo šabui dieną. ");
INSERT INTO litb_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Kai kūnas buvo nuimtas, moterys iš Galilėjos sekė ir matė, kaip Jis buvo palaidotas. ");
INSERT INTO litb_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Tada jos grįžo namo ir ruošė tepalus bei kvepalus balzamavimui, bet kol baigė, atėjo šeštadienis, todėl jos visą dieną ilsėjosi, kaip reikalauja žydų įstatymas. ");
INSERT INTO litb_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Labai ankstų sekmadienio rytą jos pasiėmė tepalus, nuėjo prie kapo ");
INSERT INTO litb_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","ir rado didžiulį akmenį, dengusi įėjimą, nuridentą į šalį. ");
INSERT INTO litb_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Jos įėjo į vidų, bet Viešpaties Jėzaus kūno neberado. ");
INSERT INTO litb_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Jos stovėjo čia sutrikusios, nežinodamos, kas Jam galėjo atsitikti. Staiga prieš jas pasirodė du vyrai, apsirengę tokiais spindinčiais drabužiais, kad moterys net buvo apakintos. ");
INSERT INTO litb_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Jos išsigando ir žemai jiems nusilenkė. Tada vyrai paklausė: „Kodėl jūs kape ieškote gyvo žmogaus? ");
INSERT INTO litb_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","7","Jo čia nėra. Jis prisikėlė. Ar neprisimenate, ką Jis jums pasakė Galilėjoje? Mesijas bus išduotas ir atsidurs blogų žmonių valioje, nukryžiuotas prisikels trečią dieną.“ ");
INSERT INTO litb_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Tuomet jos prisiminė Jėzaus žodžius, ");
INSERT INTO litb_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","sugrįžo atgal į Jeruzalę, kad pasakytų vienuolikai mokinių ir visiems kitiems, kas įvyko. ");
INSERT INTO litb_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","(Moterys, įėjusios į kapo rūsį, buvo Marija Magdalietė, Joana, Jokūbo motina Marija ir keletas kitų.) ");
INSERT INTO litb_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Bet tiems vyrams jų žodžiai atrodė kaip pasaka. Jie netikėjo jomis. ");
INSERT INTO litb_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Tačiau Petras nubėgo prie kapo pažiūrėti. Pasilenkęs jis pažvelgė į vidų ir pamatė tuščias linines drobules. Jis vėl grįžo namo stebėdamasis tuo, kas buvo įvykę. ");
INSERT INTO litb_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Tą pačią dieną, Sekmadienį, du Jėzaus sekėjai ėjo į Emauso kaimą, esantį už septynių mylių nuo Jeruzalės. ");
INSERT INTO litb_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Eidami jie kalbėjosi apie Jėzaus mirtį, ");
INSERT INTO litb_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","ir staiga prie keliauninkų prisiartino Jėzus. Jis ėjo šalia jų, ");
INSERT INTO litb_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","bet šie Jo nepažino, kadangi nuo to juos saugojo Dievas. ");
INSERT INTO litb_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","„Jūs, atrodo, apie kažką smarkiai diskutuojate? – Jis paklausė. – Kuo jūs taip susirūpinote?“ Jie nutilo, ir jų veidai apsiniaukė. ");
INSERT INTO litb_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Vienas iš jų, vardu Kleopas, pasakė: „Jūs greičiausiai vienintelis žmogus Jeruzalėje, negirdėjęs apie baisius dalykus, kurie vyko praėjusią savaitę.“ ");
INSERT INTO litb_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","„Kokius dalykus?“ – paklausė Jėzus. „Visa tai atsitiko Jėzui, žmogui iš Nazareto, – pasakė jie. – Jis buvo pranašas, kuris darė neįtikėtinus stebuklus ir buvo galingas Mokytojas, aukštai vertinamas Dievo ir žmonių. ");
INSERT INTO litb_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Bet aukštieji kunigai ir mūsų religijos vadovai suėmė Jį, perdavė romėnų vyriausybei, kad Jį pasmerktų mirčiai. Jie nukryžiavo Jį. ");
INSERT INTO litb_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Mes manėme, kad Jis šlovingasis Mesijas ir atėjo išgelbėti Izraelį. O greta to, kas įvyko prieš tris dienas, ");
INSERT INTO litb_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","šiandien rytą kelios mūsų grupės moterys buvo nuėjusios prie Jo kapo. Jos grįžo su neįtikėtina naujiena, kad Jo kūno kape nebėra ir kad jos susitiko angelus, pasakiusius, jog Jėzus gyvas. ");
INSERT INTO litb_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Vyrai taip pat bėgo pažiūrėti, ir tikrai – kūno nebėra, kaip moterys ir sakė.“ ");
INSERT INTO litb_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Tada Jėzus tarė jiems: „Ak jūs paiki, paiki žmonės! Kaip sunkiai jūs patikite tuo, apie ką rašo pranašai Raštuose! ");
INSERT INTO litb_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Argi neaiškiai buvo pasakyta pranašų, kad Mesijas turės visa tai iškentėti, prieš išeidamas į Savo šlovę?“ ");
INSERT INTO litb_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Tada Jėzus citavo jiems vieną pastraipą po kitos iš pranašų Raštų, pradėdamas Pradžios knyga, ir, peržvelgęs visus Raštus, aiškino jų prasmę ir tai, kas juose rašoma apie Jį. ");
INSERT INTO litb_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Dabar jau jie artėjo prie Emauso. Jėzus būtų keliavęs toliau, ");
INSERT INTO litb_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","bet jie maldavo Jį pasilikti nakčiai, nes jau temo. ");
INSERT INTO litb_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Tada Jis nuėjo su jais į namus. Jiems atsisėdus valgyti, Jis paprašė Viešpatį palaiminti maistą, paėmė mažą kepalėlį duonos, laužė jį ir davė kitiems. ");
INSERT INTO litb_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Tik staiga jų akys atsivėrė ir jie pažino Jėzų! Bet tuo metu Jis pranyko jiems iš akių! ");
INSERT INTO litb_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Jie pradėjo vienas kitam pasakoti, kaip jų širdys sušilo, kai Jis su jais kalbėjo, aiškindamas Raštą. ");
INSERT INTO litb_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Po valandos jie sugrįžo atgal į Jeruzalę, kur juos pasitiko vienuolika mokinių ");
INSERT INTO litb_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","šiais žodžiais: „Viešpats iš tiesų prisikėlė! Jis pasirodė Petrui!“ ");
INSERT INTO litb_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Tiedu iš Emauso tuojau papasakojo, kaip jiems pasirodė Jėzus kelyje ir kaip, belaužantį duoną, jie atpažino Jį. ");
INSERT INTO litb_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Apie tai besikalbant, tarp jų staiga atsirado pats Jėzus ir pasveikino juos. ");
INSERT INTO litb_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Bet visas būrelis labai išsigando, manydamas, kad mato dvasią. ");
INSERT INTO litb_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","„Kodėl jūs taip išsigandote?“ – paklausė Jis. – Kodėl jūs abejojate, kad tai iš tiesų Aš? ");
INSERT INTO litb_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Pasižiūrėkite į Mano rankas ir kojas. Žiūrėkite ir įsitikinkite, kad tai esu Aš. Palieskite Mane. Būkite tikri, kad Aš nesu dvasia. Nes dvasia neturi kūno, kaip matote Mane turint.“ ");
INSERT INTO litb_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Kalbėdamas Jis iškėlė rankas, kad jie matytų vinių žymes ir parodė jiems žaizdas kojose. ");
INSERT INTO litb_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Tačiau jie tebestovėjo neryžtingi, pilni džiaugsmo ir abejonių. Tada Jis paklausė: „Ar neturite čia ko valgyti?“ ");
INSERT INTO litb_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Jie davė Jam gabalėlį keptos žuvies, ");
INSERT INTO litb_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ir visiems žiūrint Jėzus valgė! ");
INSERT INTO litb_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Tada Jis tarė: „Kai Aš anksčiau buvau su jumis, argi neprisimenate, kai sakiau: viskas, kas turi išsipildyti apie Mane, parašyta Mozės, Pranašų ir Psalmių knygose.“ ");
INSERT INTO litb_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Tai pasakęs, Jis atvėrė jų protus bent jau šitiems Raštams išmanyti! ");
INSERT INTO litb_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Po to pridūrė: „Tikrai, jau seniai parašyta, kad Mesijas turės kentėti ir mirti, ir prisikelti trečią dieną iš numirusių; ");
INSERT INTO litb_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","šita žinia apie prisikėlimą turi pasklisti iš Jeruzalės į visas tautas. Visiems, kurie tik į Mane atsigręžia, bus atleidžiamos nuodėmės. ");
INSERT INTO litb_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Jūs – šių pranašysčių išsipildymo liudininkai. ");
INSERT INTO litb_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","O dabar Aš jums atsiųsiu Šventąją Dvasią, kaip pažadėjo Mano Tėvas. Dar nepasakokite kitiems apie tai, kol iš dangaus ateis Šventoji Dvasia, – pasilikite mieste, kol Ji iš aukštybių suteiks jums jėgą.“ ");
INSERT INTO litb_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Tada Jėzus nusivedė juos keliu į Betaniją ir, iškėlęs rankas į dangų, palaimino juos. Laimindamas ");
INSERT INTO litb_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","pradėjo kilti į dangų, ir jie Jo nebematė. ");
INSERT INTO litb_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Visi šlovino Jį, grįžo į Jeruzalę, pilni didelio džiaugsmo, ");
INSERT INTO litb_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ir nuolat lankė šventyklą, šlovindami Dievą.");
INSERT INTO litb_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Pirmoje savo knygoje, Teofiliau, aš papasakojau apie Jėzaus gyvenimą, mokymą ir apie tai, kaip Jis, ");
INSERT INTO litb_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","palikęs Savo išrinktiesiems apaštalams tolesnius nurodymus per Šventąją Dvasią, grįžo į dangų. ");
INSERT INTO litb_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Po nukryžiavimo dar keturiasdešimt dienų Jėzus kartais pasirodydavo apaštalams, daugeliu dalykų įrodydamas, kad tai būtent Jis. Tomis progomis Jis kalbėjo su jais apie Dievo karalystę. ");
INSERT INTO litb_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Viename šių susirinkimų Jis liepė jiems neišvykti iš Jeruzalės, bet laukti, kol juos aplankys Šventoji Dvasia, kad įvyktų tai, ką anksčiau Tėvas buvo jiems žadėjęs. ");
INSERT INTO litb_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","„Jonas krikštijo vandeniu, – kalbėjo Jis, – bet jūs po kelių dienų būsite pakrikštyti Šventąja Dvasia.“ ");
INSERT INTO litb_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Jėzui pasirodžius kitą kartą, jie ėmė klausinėti: „Viešpatie, ar Tu dabar rengiesi gelbėti Izraelį nuo Romos jungo, kad mūsų tauta vėl taptų laisva?“ ");
INSERT INTO litb_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","„Laiką nustato Tėvas, – atsakė Jis. – Ne jums žinoti laiką ir valandą. ");
INSERT INTO litb_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Bet kai jus aplankys Šventoji Dvasia, įgausite galybės patvirtinti apie Mano mirtį ir prisikėlimą Jeruzalės žmonėms, visai Judėjai, Samarijai bei visam pasauliui.“ ");
INSERT INTO litb_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Netrukus Jis visus stebindamas pakilo į dangų ir pranyko debesyje. ");
INSERT INTO litb_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Kai jie, akių nenuleisdami, žiūrėjo į žengiantį dangun Jėzų, staiga prie jų atsirado du baltai apsirengę vyrai ir pasakė: ");
INSERT INTO litb_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","„Galilėjos žmonės, ko stovite, žiūrėdami į dangų? Jėzus nužengė į dangų ir vieną dieną Jis sugrįš taip pat, kaip buvo išėjęs.“ ");
INSERT INTO litb_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Tai įvyko ant Alyvų kalno, taigi į Jeruzalę jie turėjo grįžti pusę mylios ");
INSERT INTO litb_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","ir susirinko bendrai maldai viršutiniame namo, kuriame buvo apsistoję, kambaryje. ");
INSERT INTO litb_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Susirinkime dalyvavo: Petras, Jonas, Jokūbas, Andriejus, Pilypas ir Tomas, Baltramiejus, Matas, Alfiejaus sūnus Jokūbas, Simonas Uolusis, Jokūbo sūnus Judas ir Jėzaus broliai. Čia taip pat buvo keletas moterų, o su jomis ir Jėzaus motina. ");
INSERT INTO litb_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Šis maldos susirinkimas tęsėsi keletą dienų. Vieną dieną, dalyvaujant šimtui dvidešimčiai žmonių, atsistojo Petras ir kreipėsi į juos: ");
INSERT INTO litb_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","„Broliai, turėjo išsipildyti Rašto žodžiai, bylojantys apie Jėzų išdavusi Judą, kuris atvedė minią Jį suimti, nes taip buvo nurodžiusi Šventoji Dvasia per karalių Dovydą. ");
INSERT INTO litb_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judas buvo vienas iš pasirinktų apaštalų. ");
INSERT INTO litb_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Pinigų, gautų už išdavystę, jam užteko sklypui nupirkti, o paskui jis stačia galva krito žemyn, plyšo pusiau, ir išėjo visi jo viduriai. ");
INSERT INTO litb_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Žinia apie jo mirtį greitai pasklido tarp visų Jeruzalės gyventojų, ir jie pavadino tą vietą Kraujo lauku. ");
INSERT INTO litb_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Karaliaus Dovydo pranašystė yra Psalmių knygoje, kur jis sako: „Tegul jo namai lieka apleisti, ir tegul niekas juose negyvena.“ Ir vėl: „Te jo darbas būna pavedamas kitam atlikti.“ ");
INSERT INTO litb_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Taigi dabar mes privalome vietoje Judo pasirinkti kitą žmogų, kad šis prisijungtų prie mūsų, Jėzaus prisikėlimo liudytojų. Išsirinkime tą, kuris buvo nuolat su mumis nuo mūsų pirmos pažinties su Viešpačiu iki to laiko, kai buvo paimtas į dangų.“ ");
INSERT INTO litb_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Susirinkimas iškėlė du kandidatus: Juozapą, vadinamą Barsabu, pravarde Justas, ir Motiejų. ");
INSERT INTO litb_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Tada jie visi meldėsi, kad būtų pasirinktas tinkamas žmogus. „Viešpatie, – jie sakė. – Tu žinai kiekvieną širdį. Parodyk mums, katrą šių vyrų Tu pasirinkai apaštalu vietoje išdaviko Judo, jau nukeliavusio į tinkamą vietą.“ ");
INSERT INTO litb_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Tada jie metė burtus ir dvyliktuoju apaštalu pasirinko Motiejų. ");
INSERT INTO litb_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Praėjo septynios savaitės nuo Jėzaus mirties ir prisikėlimo, ir dabar atėjo Sekminių diena. Staiga maldos namuose esančius ");
INSERT INTO litb_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","tikinčiuosius lyg galingos audros dundesys apkurtino garsas. ");
INSERT INTO litb_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Tada ant jų galvų pradėjo kristi kažkas panašaus į liepsną ar ugnies liežuvius. ");
INSERT INTO litb_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ir dalyvavusieji prisipildė Šventosios Dvasios, ir pradėjo kalbėti svetimomis kalbomis, nes Šventoji Dvasia suteikė šią galimybę. ");
INSERT INTO litb_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Daug pamaldžių žydų buvo atvykę iš kitų šalių į religines iškilmes. ");
INSERT INTO litb_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Pasigirdus ūžesiui iš dangaus virš namo, minios žmonių bėgo pažiūrėti, kas čia vyksta, ir žmonės buvo apstulbinti, nes girdėjo jų kalba kalbančius Kristaus mokinius. ");
INSERT INTO litb_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","„Kaip gali būti?! – stebėjosi jie. – Nors visi šie žmonės iš Galilėjos, ");
INSERT INTO litb_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","mes girdime juos kalbant mūsų gimtosiomis kalbomis. ");
INSERT INTO litb_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Mes – partai, medai, elamiečiai, Mesopotamijos, Judėjos, Kapadokijos, Ponto, Azijos, ");
INSERT INTO litb_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frygijos, Pamfilijos, Egipto ir Libijos pakraščio ties Kirėne gyventojai, ateiviai iš Romos, tiek žydai, tiek ir žydų prozelitai – ");
INSERT INTO litb_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","kretiečiai bei arabai. Ir visi mes girdime šiuos vyrus kalbančius mūsų kalbomis apie galingus Dievo stebuklus!“ ");
INSERT INTO litb_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Jie stovėjo nustebinti ir suglumę. „Ką tai galėtų reikšti?“ – klausinėjo jie vienas kitą. ");
INSERT INTO litb_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Bet minioje buvo ir tokių, kurie šaipėsi, sakydami: „Jie paprasčiausiai visi girti!“ ");
INSERT INTO litb_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Tada Petras, su vienuolika apaštalų išėjęs į priekį, prabilo į minią: „Visi paklausykite: ir svečiai, ir Jeruzalės gyventojai! ");
INSERT INTO litb_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Kai kurie sakote, kad šitie vyrai girti! Tai netiesa! Dabar ankstyvas metas. Žmonės nepasigeria iki devintos valandos ryto! ");
INSERT INTO litb_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Tai, ką jūs matote šį rytą, prieš šimtmečius išpranašavo Joelis: ");
INSERT INTO litb_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","„Paskutinėmis dienomis Viešpats pasakė: „Aš įkvėpsiu Šventosios Dvasios visiems žmonėms. Jūsų sūnūs ir dukros pranašaus, jūsų jaunuoliai matys regėjimus, jūsų seneliai sapnuos sapnus. ");
INSERT INTO litb_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Taip, Šventoji Dvasia aplankys visus mano tarnus, tiek vyrus, tiek ir moteris, ir jie galės pranašauti. ");
INSERT INTO litb_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Danguje ir žemėje pasirodys nepaprasti ženklai: kraujas ir ugnis bei dūmų debesys. ");
INSERT INTO litb_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Saulė pajuoduos, o mėnulis bus raudonas lyg kraujas prieš tą bauginančią Viešpaties atėjimo dieną. ");
INSERT INTO litb_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Bet visi, kas prašys Viešpaties pasigailėjimo, jo susilauks ir bus išgelbėti.“ ");
INSERT INTO litb_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Klausykite, Izraelio žmonės! Viešpats viešai palaikė Jėzų iš Nazareto, per Jį darydamas stebuklus, kaip jūs tai gerai žinote. ");
INSERT INTO litb_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Bet Viešpats, vykdydamas Savo iš anksto parengtą planą, leido, kad pagal romėnų vyriausybės nurodymus Jėzus būtų prikaltas prie kryžiaus ir nužudytas. ");
INSERT INTO litb_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Tada Viešpats išlaisvino Jį iš mirties siaubo ir vėl grąžino į gyvenimą, nes mirtis nepajėgė išlaikyti Jo savo gniaužtuose. ");
INSERT INTO litb_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Karalius Dovydas sako apie Jėzų: „Aš žinau, kad Viešpats visada su manimi. Jis man padeda. Galinga Viešpaties jėga palaiko mane. ");
INSERT INTO litb_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Nenuostabu, kad mano širdis pilna džiaugsmo ir aš Jį šlovinu, nes žinau, kad po mirties nebūsiu apleistas. ");
INSERT INTO litb_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Tu neleisi mano sielai likti pragare ir neleisi šventam Sūnaus kūnui supūti. ");
INSERT INTO litb_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Tu sugrąžinsi man gyvenimą ir suteiksi nuostabų džiaugsmą Savo akivaizdoje.“ ");
INSERT INTO litb_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Brangūs broliai, pagalvokite! Dovydas kalbėjo ne apie save, kai sakė mano cituotus žodžius, nes jis mirė, buvo palaidotas, ir iki šiol tebėra jo kapas. ");
INSERT INTO litb_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Bet jis buvo pranašas ir žinojo, jog Dievas davė nesulaužomą pažadą, kad vienas iš paties Dovydo palikuonių bus Mesijas ir sėdės Dovydo soste. ");
INSERT INTO litb_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Dovydas žiūrėjo tolyn į ateitį ir pranašavo Mesijo prisikėlimą, sakydamas, kad Mesijo siela nebus palikta pragare ir Jo kūnas neges. ");
INSERT INTO litb_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Jis kalbėjo apie Jėzų, ir visi mes esame liudininkai, kad Jėzus prisikėlė iš numirusių. ");
INSERT INTO litb_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Dabar Jis sėdi danguje, aukščiausios garbės soste, šalia Dievo. Ir kaip žadėjo, Tėvas davė Jam galią atsiųsti Šventąją Dvasią, o rezultatus jūs šiandien matote ir girdite. ");
INSERT INTO litb_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Dovydas ne apie save kalbėjo, nes niekada nebuvo užžengęs į dangų. Be to, jis vėliau tvirtino: „Dievas kalbėjo Mesijui, mano Viešpačiui, ir Jam pasakė: „Sėsk čia, garbingoje vietoje šalia Manęs, ");
INSERT INTO litb_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","kol Tavo priešai visiškai priklausys Man.“ ");
INSERT INTO litb_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Todėl aš neabejodamas tvirtinu visiems Izraelio žmonėms: „Dievas padarė Viešpačiu ir Mesiju Jėzų, kurį jūs nukryžiavote!“ ");
INSERT INTO litb_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Tie Petro žodžiai juos giliai sujaudino, ir žmonės jam bei kitiems apaštalams pasakė: „Broliai, ką mums daryti?“ ");
INSERT INTO litb_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Petras jiems atsakė: „Visi turite nusigręžti nuo nuodėmės, sugrįžti prie Dievo, pasikrikštyti Jėzaus Kristaus vardu, kad būtų atleistos jūsų nuodėmės, o tada jūs taip pat gausite šią Šventosios Dvasios dovaną. ");
INSERT INTO litb_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Nes Kristus ją pažadėjo jums visiems, taip pat jūsų vaikams ir netgi tolimose šalyse esantiems, kuriuos tik pasišauks Viešpats, mūsų Dievas!“ ");
INSERT INTO litb_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Tada Petras pasakė ilgą pamokslą, pasakodamas apie Jėzų ir karštai ragindamas visus klausytojus atsikratyti ydų. ");
INSERT INTO litb_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ir tie trys tūkstančiai žmonių, kurie patikėjo Petro žodžiais, buvo pakrikštyti. ");
INSERT INTO litb_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Jie pritapdavo prie kitų tikinčiųjų, klausydamiesi apaštalų mokymo, laužydami duoną ir melsdamiesi. ");
INSERT INTO litb_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Juos buvo apėmusi pagarba ir baimė, o apaštalai padarė daug stebuklų. ");
INSERT INTO litb_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Visi tikintieji nuolat susieidavo ir viskuo pasidalindavo, ");
INSERT INTO litb_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","parduodami savo turtą ir atiduodami jį vargstantiems. ");
INSERT INTO litb_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Jie sutartinai melsdavosi šventykloje, susitikdavo mažomis grupelėmis Komunijai, valgydavo drauge, patirdami didelį džiaugsmą ir dėkingumą, ");
INSERT INTO litb_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","šlovindami Dievą. Visas miestas buvo jiems palankus, ir kiekvieną dieną jų būrį gausindavo Dievo išganytieji. ");
INSERT INTO litb_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Vieną popietę, trečią valandą, Petras ir Jonas nuėjo į šventyklą melstis. ");
INSERT INTO litb_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Prisiartinę prie šventyklos, jie pamatė nešamą gatve iš prigimties luošą vyrą. Kaip ir kiekvieną dieną, jį pasodino prie šventyklos vartų, vadinamų Gražiaisiais. ");
INSERT INTO litb_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Petrui ir Jonui einant pro šalį, jis paprašė pinigų. ");
INSERT INTO litb_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Jie įdėmiai pasižiūrėjo į jį, ir tada Petras tarė: „Pažvelk!“ ");
INSERT INTO litb_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Luošasis pažvelgė į juos nekantriai, tikėdamasis ką nors gauti. ");
INSERT INTO litb_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Bet Petras pasakė: „Aš neturiu pinigų tau duoti. Bet ką turiu, tau duodu. Jėzaus Kristaus iš Nazareto vardu, sakau tau: „Vaikščiok!“ ");
INSERT INTO litb_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Tada Petras paėmė luošą žmogų už rankos ir pastatė jį ant kojų. Ir kai jis tai padarė, žmogaus kojos ir kulkšnies kaulas pagijo ir taip sustiprėjo, ");
INSERT INTO litb_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","kad jis pastovėjo minutėlę ir pradėjo pasišokinėdamas vaikščioti. Jis šokinėdamas nuėjo su jais į šventyklą ir šlovino Dievą. ");
INSERT INTO litb_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Kai žmonės viduje pamatė jį vaikštantį ir šlovinantį Dievą, ");
INSERT INTO litb_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","suprato, kad tai buvo tas pats luošas elgeta, kurį jie taip dažnai matydavo prie Gražiųjų vartų. Žmonės buvo neapsakomai nustebinti! ");
INSERT INTO litb_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Visi subėgo į Saliamono salę, kur jis neatsitraukdamas stovėjo prie Petro ir Jono! Visi pagarbiai nuščiuvo, nes buvo nustebinti tokio įvykio. ");
INSERT INTO litb_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Petras, suradęs tinkamiausią progą, kreipėsi į minią: „Izraelio vyrai! – pasakė jis. – Kas jus taip stebina? Kam šitaip žiūrėti į mus, lyg mes savo galia ar šventumu būtume išgydę šį žmogų. ");
INSERT INTO litb_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Tai Abraomo, Izaoko, Jokūbo ir kitų mūsų protėvių Dievas įvykdė šį stebuklą, nes norėjo pašlovinti Savo tarną Jėzų. Aš kalbu apie Jėzų, kurį jūs išdavėte, atidavėte ir išsigynėte Pilotui, nors tasai buvo nutaręs Jį paleisti. ");
INSERT INTO litb_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Jūs nenorėjote Jį išlaisvinti, Šventąjį ir Teisųjį. Jūs reikalavote geriau paleisti žudiką! ");
INSERT INTO litb_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Jūs nužudėte gyvybės Kūrėją, bet Dievas Jį vėl prikėlė iš numirusių. Jonas ir aš esame to įvykio liudininkai, nes po to, kai jūs nužudėte Jėzų, mes matėme Jį gyvą! ");
INSERT INTO litb_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Jėzaus vardas išgydė šį žmogų. Jūs žinote, koks jis anksčiau buvo luošas. Tikėjimas Jėzaus vardu (tikėjimas duotas mums Dievo) taip tobulai išgydė jį. ");
INSERT INTO litb_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Brangūs broliai, suprantu, kad jūs nežinodami šitaip pasielgėte su Jėzumi, tas pats gali būti pasakyta ir apie jūsų vadovus. ");
INSERT INTO litb_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Dievas vykdė pažadą, ir Mesijas turėjo visa tai iškentėti. ");
INSERT INTO litb_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Dabar pakeiskite savo nuomonę ir požiūrį į Dievą ir atsisukite į Jį, kad Jis galėtų jūsų nuodėmes nuplauti ir siųsti jums tuos nuostabius Viešpaties atgaivos laikus, ");
INSERT INTO litb_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","sugrąžindamas jums Jėzų, jūsų Mesiją. ");
INSERT INTO litb_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Kaip pranašauta nuo senovės laikų, danguje Jam reikia pasilikti tol, kol visiškai bus atsižadėta nuodėmės. ");
INSERT INTO litb_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Antai, Mozė yra pasakęs: „Viešpats Dievas jūsų tarpe pažadins Pranašą, kaip mane! Atidžiai paklausykite, ką Jis sako. ");
INSERT INTO litb_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Kiekvienas, kas neklausys Jo, bus visiškai sunaikintas.“ ");
INSERT INTO litb_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Samuelis ir visi pranašai vėliau kalbėjo apie tai, kas vyksta šiandien. ");
INSERT INTO litb_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Jūs, tų pranašų vaikai, esate susiję su Dievo pažadu, duotu jūsų protėviams – palaiminti visą pasaulį per žydų tautą. Tai Dievo duotas pažadas Abraomui. ");
INSERT INTO litb_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Kai tik Dievas prikėlė Savo Tarną gyvenimui, Jis pirmiausia pasiuntė Jį jums, Izraelio žmonėms, kad palaimintų jus, apsaugodamas jus nuo nuodėmių.“ ");
INSERT INTO litb_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Jiems bekalbant su žmonėmis, priėjo prie jų aukštieji kunigai, šventyklos apsaugos viršininkas ir keletas sadukiejų. ");
INSERT INTO litb_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Jie labai pyko, kad Petras su Jonu skelbė, jog Jėzus prisikėlė iš numirusių. ");
INSERT INTO litb_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Jie suėmė juos, ir kadangi buvo jau vakaras, įmetė juos nakčiai į kalėjimą. ");
INSERT INTO litb_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Bet daugelis žmonių, kurie girdėjo jų žodį, tuo patikėjo. Taip tikinčiųjų skaičius padidėjo iki penkių tūkstančių! ");
INSERT INTO litb_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Atsitiko taip, kad kitą dieną žydų tautos vadovų taryba posėdžiavo Jeruzalėje. ");
INSERT INTO litb_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Taip pat čia buvo vyriausias kunigas Anas, Kajafas, Jonas, Aleksandras ir kiti vyriausiojo kunigo giminės. ");
INSERT INTO litb_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Abu mokiniai buvo pastatyti prieš juos. „Kieno įkvėpti ir kieno vardu jūs tai padarėte?“ – reikalavo pasiaiškinti taryba. ");
INSERT INTO litb_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Tada Petras, kupinas Šventosios Dvasios, jiems atsakė: „Gerbiami tautos vadovai ir vyresnieji, ");
INSERT INTO litb_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","jei mus šiandien klausinėjate apie geradarystę luošam žmogui, kaip jis buvo išgydytas, ");
INSERT INTO litb_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","leiskite man jums pranešti, kad tai buvo padaryta Mesijo, Jėzaus iš Nazareto, kurį jūs nukryžiavote, vardu ir galia, nes Dievas Jį prikėlė iš numirusių. Jo dėka šis žmogus čia stovi sveikas! ");
INSERT INTO litb_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Nes Jėzus – Mesijas, kuris minimas Raštuose, bylojančiuose apie akmenį, išmestą kaip nebereikalingą, kuris tapo kertiniu akmeniu. ");
INSERT INTO litb_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Nėra jokio kito išsigelbėjimo. Visame pasaulyje nėra nė vieno kito tokio vardo, kurio galėtų šauktis žmogus ir išsigelbėti.“ ");
INSERT INTO litb_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Taryba, matydama Petro ir Jono drąsą, patyrusi, kad tai paprasti beraščiai žmonės, labai nustebo ir aiškiai suprato, ką jiems davė buvimas su Jėzumi! ");
INSERT INTO litb_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","O taryba negalėjo abejoti dėl išgydymo, nes išgydytasis stovėjo kaip tik priešais juos. ");
INSERT INTO litb_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Todėl jie liepė visiems pasišalinti, o patys ėmė tartis. ");
INSERT INTO litb_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","„Ką mes darysime su šiais žmonėmis? – klausė jie vienas kitą. – Mes negalime paneigti jų padaryto didžiulio stebuklo. Apie jį žino visi, kas yra Jeruzalėje. ");
INSERT INTO litb_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Bet galbūt mes galime uždrausti jiems skelbti šią žinią. Mes prisakysime, kad šiukštu neskelbtų ir nemokytų Jėzaus vardu.“ ");
INSERT INTO litb_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Tad jie sukvietė vėl visus į vidų ir įsakė jiems daugiau niekada nekalbėti apie Jėzų. ");
INSERT INTO litb_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Tačiau Petras ir Jonas atsakydami tarė: „Spręskite, ar Dievas nori, kad mes klausytume jūsų, o ne Jo! ");
INSERT INTO litb_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Mes negalime nekalbėti apie tuos nuostabius dalykus, kuriuos darė Jėzus, nes patys matėme ir apie juos girdėjome iš Jėzaus lūpų!“ ");
INSERT INTO litb_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Tada taryba ir toliau jiems grasino. Pagaliau juos paleido, nes nežinojo, kaip nubausti nesukeliant maišto. Mat visi garbino Dievą už nuostabųjį stebuklą – ");
INSERT INTO litb_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","keturiasdešimt metų buvęs luošas žmogus taip stebuklingai išgijo! ");
INSERT INTO litb_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Kai tik Petras ir Jonas buvo išlaisvinti, jie susirado kitus mokinius ir išpasakojo jiems viską, ką sakė taryba. ");
INSERT INTO litb_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Tada visi tikintieji susitelkė šioje maldoje: „Viešpatie, dangaus, žemės, jūros ir viso, kas juose, Kūrėjau! ");
INSERT INTO litb_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Tavo Šventoji Dvasia per mūsų protėvį, tavo tarną karalių Dovydą, kalbėjo: „Kodėl niršta ant Viešpaties pagonys? Kam neišmintingos tautos planuoja sąmokslus prieš Visagalį Dievą? ");
INSERT INTO litb_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Žemės karaliai sukilo į kovą prieš Jį ir prieš pateptąjį Dievo Sūnų!“ ");
INSERT INTO litb_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Štai kas vyksta šiandien šiame mieste. Nes karalius Erodas, valdytojas Pilotas su visais romėnais, taip pat ir Izraelio žmonės yra susivieniję prieš Jėzų, Tavo pateptąjį Sūnų, Tavo Šventąjį Tarną. ");
INSERT INTO litb_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Jie įvykdys tai, ką Tavo išmintinga jėga leis jiems padaryti. ");
INSERT INTO litb_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","O dabar, Viešpatie, išgirsk jų grasinimus, suteik saviesiems tarnams didelę drąsą atvirai skelbti, ");
INSERT INTO litb_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","siųsk Savo gydančią galią ir teįvyksta nepaprastų dalykų ir stebuklų Tavo Švento Tarno Jėzaus vardu.“ ");
INSERT INTO litb_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Jiems pasimeldus, sudrebėjo pastatas, kuriame jie buvo susirinkę, ir visi, prisipildę Šventosios Dvasios, galėjo drąsiai skelbti Dievo Žodį. ");
INSERT INTO litb_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Visi tikintieji buvo vienminčiai ir turėjo tarsi vieną širdį, jokios nuosavybės nelaikė sava, viskuo dalinosi tarpusavyje. ");
INSERT INTO litb_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Apaštalai sakė įtikinančius pamokslus apie Viešpaties Jėzaus prisikėlimą, ir visi tikintieji buvo nuoširdūs, draugiški. ");
INSERT INTO litb_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Jie nepažino skurdo, nes kurie turėjo žemės sklypus ir namus, juos parduodavo ir gautus pinigus atiduodavo apaštalams, kad jie atiduotų vargstantiems. ");
INSERT INTO litb_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Pavyzdžiui, toks buvo Juozapas, apaštalų pramintas Barnabu, „Paguodos sūnum.“ Jis buvo kilęs iš Kipro salos, Levio giminės. ");
INSERT INTO litb_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Tai jis buvo vienas iš tų, kuris pardavė savo žemės sklypą, o pardavęs gautus pinigus atnešė apaštalams, kad jie padalintų vargstantiems. ");
INSERT INTO litb_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Tačiau vienas žmogus, vardu Ananijas, su savo žmona Sapfyra pardavęs žemės sklypą, ");
INSERT INTO litb_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","atnešė tik dalį pinigų, tvirtindamas, kad tai buvo visa suma (jo žmona sutiko su šia apgavyste). ");
INSERT INTO litb_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Bet Petras pasakė: „Ananijau, šėtonas užvaldė tavo širdį. Kai tu tvirtinai, kad tai visi pinigai, tu melavai Šventajai Dvasiai. ");
INSERT INTO litb_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Turtas buvo tavo nuosavybė, ir tu galėjai tvarkyti jį kaip norėjai. Galėjai parduoti ar neparduoti. Ir pardavęs tu galėjai nuspręsti, kiek duoti. Kaip tu galėjai taip padaryti? Tu ne mums melavai, o Dievui.“ ");
INSERT INTO litb_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananijas, išgirdęs tuos žodžius, krito ant grindų ir mirė! Visi išsigando, ");
INSERT INTO litb_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","o jaunuoliai pridengė jį paklode, išnešė ir palaidojo. ");
INSERT INTO litb_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Maždaug po kokių trijų valandų atėjo jo žmona, kuri nežinojo, kas buvo atsitikę. ");
INSERT INTO litb_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Petras ją paklausė: „Ar jūs pardavėte savo žemę už tokią ir tokią kainą?“ „Taip, už tiek“, – atsakė ji. ");
INSERT INTO litb_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Bet Petras prabilo: „Kaip tu su savo vyru galėjai šitaip sugalvoti? Jūs susimokėte ir norėjote patikrinti, ar Dievas gali žinoti tai, kas iš tikrųjų vyksta? Lauke už durų dar tebėra jaunuoliai, kurie palaidojo tavo vyrą. Jie taip pat ir tave išneš.“ ");
INSERT INTO litb_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Bematant ji susmuko ant grindų ir mirė. Atėjo jaunuoliai ir pamatė, kad ji mirus. Išnešė ją ir palaidojo šalia vyro. ");
INSERT INTO litb_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Baimė apėmė visą bažnyčią ir visus kitus, kurie girdėjo, kas buvo atsitikę. ");
INSERT INTO litb_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Tuo tarpu apaštalai nuolat rinkdavosi šventykloje, Saliamono salėje, ir darė dar daug nepaprastų stebuklų. ");
INSERT INTO litb_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Kiti tikintieji nedrįso prie jų prisidėti, nors visi juos labai gerbė. ");
INSERT INTO litb_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Augo būrys vyrų ir moterų, įtikėjusių Viešpatį. ");
INSERT INTO litb_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Sergantieji buvo gabenami į gatves lovose ir ant kilimėlių, kad Petrui einant, bent jo šešėlis kristų ant kai kurių gulinčiųjų. ");
INSERT INTO litb_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Keliavo minios iš Jeruzalės priemiesčių ir nešė ligonius ir piktųjų dvasių apsėstuosius. Visi jie būdavo pagydomi. ");
INSERT INTO litb_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Stiprų pavydą jautė aukščiausias kunigas, jo giminės ir draugai iš sadukiejų tarpo. ");
INSERT INTO litb_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Jie suėmė apaštalus ir įmetė juos į viešą kalėjimą. ");
INSERT INTO litb_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Bet naktį atėjo Viešpaties angelas, atidarė kalėjimo vartus, išvedė pro juos ir tarė: ");
INSERT INTO litb_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","„Eikite į šventyklą ir skelbkite žmonėms apie šį Gyvenimą!“ ");
INSERT INTO litb_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Auštant jie atvyko į šventyklą ir tuojau ėmė mokyti. Vėliau rytą vyriausias kunigas ir jo šalininkai atvyko į šventyklą ir, sukvietę žydų tarybą ir visą Senatą, nusiuntė tarnus, kad atvestų apaštalus, kuriuos nusprendė patraukti teisman. ");
INSERT INTO litb_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Kai į kalėjimą atvyko tarnai, vyrų ten nebuvo, todėl jie, grįžę į tarybą, pranešė: ");
INSERT INTO litb_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","„Kalėjimo durys buvo užrakintos, sargai stovėjo lauke; kai atidarėme vartus, viduje nieko nebuvo.“ ");
INSERT INTO litb_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Šventyklos apsaugos viršininkas ir aukštieji kunigai, tai išgirdę, sumišę stebėjosi, kas bus toliau ir kuo visa tai baigsis! ");
INSERT INTO litb_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Tuo metu kažkas pranešė, kad vyrai, kuriuos jie įkalino, stovi šventykloje ir moko žmones! ");
INSERT INTO litb_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Šventyklos apsaugos kapitonas nuėjo su kariais ir suėmė juos (be prievartos, nes bijojo žmonių, kad jų neužmuštų, jei jie šiurkščiau elgtųsi su mokiniais). ");
INSERT INTO litb_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Jie atvedė apaštalus į tarybą. ");
INSERT INTO litb_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","„Negi mes jums nesakėme, kad daugiau niekada neprasitartumėte apie Jėzų? – paklausė vyriausias kunigas. – O štai jūs savo mokslu užtvindėte visą Jeruzalę ir norite ant mūsų galvų užtraukti To Žmogaus kraują!“ ");
INSERT INTO litb_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Bet Petras ir apaštalai atsiliepė: „Dievo reikia klausyti daugiau negu žmonių. ");
INSERT INTO litb_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Mūsų protėvių Dievas prikėlė Jėzų, kurį jūs nužudėte prikaldami prie kryžiaus. ");
INSERT INTO litb_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Tada Savo galinga jėga Dievas išaukštino Jį kaip Kunigaikštį ir Išgelbėtoją, kad Izraelis turėtų progą atgailauti ir kad būtų atleistos jūsų nuodėmės. ");
INSERT INTO litb_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","O mes esame tų įvykių liudininkai, taip pat ir Šventoji Dvasia, kurią Dievas suteikia visiems, Jam paklūstantiems.“ ");
INSERT INTO litb_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Tuomet taryba baisiai įširdo ir nusprendė juos užmušti. ");
INSERT INTO litb_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Bet pakilo vienas fariziejus, vardu Gamalielis (labai gerbiamas žmonių tarpe įstatymo mokytojas), ir pareikalavo, kad jam kalbant iš tarybos būtų išvesti apaštalai. ");
INSERT INTO litb_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Tada jis kreipėsi į savo kolegas: „Izraelio vyrai, pagalvokite, ką daryti su šitais žmonėmis. ");
INSERT INTO litb_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Prieš kurį laiką gyveno jaunuolis Teudas, kuris laikė save kažkuo nepaprastu. Jam pritarė apie keturi šimtai žmonių, bet jis buvo užmuštas, jo pasekėjai ramiai išsiskirstė. ");
INSERT INTO litb_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Po jo, gyventojų surašymo dienomis, buvo Judas iš Galilėjos. Dalis žmonių tapo jo mokiniais ir sekė paskui jį. Bet ir jis mirė, o jo pasekėjai išsiskirstė. ");
INSERT INTO litb_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Todėl aš patariu palikti tuos žmones ramybėje. Jei tai, ko jie moko ir daro, kyla iš jų pačių, viskas greitai žlugs savaime. ");
INSERT INTO litb_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Bet jei tai iš Dievo, tai jūs nepajėgsite jų sunaikinti, nebent jei stotumėte į kovą prieš pati Dievą.“ ");
INSERT INTO litb_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Taryba paklausė jo patarimo. Pasišaukė apaštalus, nuplakdino juos, paleido ir liepė niekada nebekalbėti apie Jėzų. ");
INSERT INTO litb_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","O jie ėjo iš tarybos džiaugdamiesi, kad Dievas palaikė juos vertais kentėti panieką dėl Jo vardo. ");
INSERT INTO litb_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Jie nesiliovė kiekvieną dieną namuose ir šventykloje mokyti, kad Jėzus yra Mesijas. ");
INSERT INTO litb_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Tikinčiųjų skaičiui greitai augant, kilo nepasitenkinimas. Tie, kurie kalbėjo tik graikiškai, skundėsi, kad buvo diskriminuojamos jų našlės, kad joms kasdien aprūpinimui nebūdavo duodama tiek pat maisto, kiek gaudavo moterys, kalbančios hebrajiškai. ");
INSERT INTO litb_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Tuomet dvylika apaštalų sušaukė visų tikinčių susirinkimą ir tarė: „Mes turėtume leisti laiką melsdamiesi, o ne sudarinėdami maitinimo programas. ");
INSERT INTO litb_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Dabar, brangūs broliai, apsižvalgykime aplinkui ir išrinkime septynis vyrus, išmintingus ir kupinus Šventosios Dvasios, turinčius gerą vardą. Mes jiems pavesime šį reikalą. ");
INSERT INTO litb_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Tada mes galėsime atsidėti maldai ir mokymui.“ ");
INSERT INTO litb_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Šitas pasiūlymas pasirodė tinkamas visam susirinkimui, ir jie išsirinko Steponą (vyrą, kupiną tikėjimo ir Šventosios Dvasios), Pilypą, Prochorą, Nikanorą, Timoną, Parmeną, Mikalojų iš Antiochijos (pagonį, atsivertėlį į žydų tikėjimą, kuris tapo krikščioniu). ");
INSERT INTO litb_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Tuos septynis pristatė apaštalams, o šie melsdamiesi dėjo ant jų rankas ir laimino. ");
INSERT INTO litb_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Dievo Žodžio buvo mokoma vis didesnėse grupėse, o mokinių skaičius Jeruzalėje labai išaugo. Taip pat atsivertė daugelis žydų kunigų. ");
INSERT INTO litb_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Steponas, kupinas tikėjimo ir Šventosios Dvasios, darė daugelį stebuklų. ");
INSERT INTO litb_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Vieną dieną keletas vyrų iš žydų libertinų sinagogos pradėjo su juo ginčytis, o prie jų greitai prisijungė žydai iš Kirėnės, Egipto Aleksandrijos ir Turkijos provincijų, Kilikijos bei Azijos. ");
INSERT INTO litb_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Bet niekas negalėjo pasipriešinti Stepono išminčiai ir dvasiai. ");
INSERT INTO litb_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Taigi jie pasikvietė keletą vyrų, kad šie meluotų. O tie tvirtino girdėję Steponą piktžodžiaujantį Mozei ir net Dievui. ");
INSERT INTO litb_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Šis kaltinimas sukurstė liaudį. Ji įtūžo ant Stepono. Žydų vadovai suėmė jį ir nuvedė į tarybą. ");
INSERT INTO litb_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Pasamdyti liudytojai melavo, kad Steponas nuolat kalba prieš šventyklą ir Mozės įstatymus. ");
INSERT INTO litb_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Jie sakė: „Mes girdėjome jį sakantį, kad šis jaunuolis, Jėzus iš Nazareto, sugriaus šventyklą ir atmes visus Mozės įstatymus!“ ");
INSERT INTO litb_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Tą akimirką taryba pamatė, jog Stepono veidas suspindo! ");
INSERT INTO litb_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Tada vyriausiasis kunigas paklausė jį: „Ar tie kaltinimai teisingi?“ ");
INSERT INTO litb_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Štai koks ilgas buvo Stepono atsakymas: „Šlovingasis Dievas apsireiškė mūsų tėvui Abraomui Irake dar prieš jam persikeliant į Siriją ");
INSERT INTO litb_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ir liepė išeiti iš savo gimtojo krašto, atsisveikinti su giminėmis ir leistis į kelionę ton šalin, kurią Dievas jam parodys. ");
INSERT INTO litb_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Tada jis paliko Chaldėjų kraštą ir apsigyveno Harane, Sirijoje, iki savo tėvo mirties. Iš ten Dievas atvedė jį čia, Izraelio žemėn, ");
INSERT INTO litb_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","bet nesuteikė jam nė mažyčio žemės plotelio. Tačiau Dievas pažadėjo, kad galiausiai jam ir jo palikuonims (nors jis buvo bevaikis!) priklausys visa šalis. ");
INSERT INTO litb_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Dievas taip pat jam pasakė, kad šitie jo palikuonys paliks savo šalį ir gyvens kaip ateiviai svetimoje žemėje ir 400 metų vergaus. ");
INSERT INTO litb_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","„Bet Aš nubausiu tautą, kuri juos pavergs, – jam pasakė Dievas. – Vėliau Mano žmonės sugrįš į šią Izraelio valstybę ir čia Mane garbins.“ ");
INSERT INTO litb_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ir tuomet Dievas davė atlikti Abraomui apipjaustymo apeigą, kaip Dievo ir Abraomo žmonių susitarimą. Taigi, suėjus aštuonioms dienoms, Abraomo sūnus Izaokas buvo apipjaustytas. Izaokas tapo Jokūbo tėvu, o Jokūbui gimė dvylika vaikų, kurie tapo žydų tautos patriarchais. ");
INSERT INTO litb_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Šie iš pavydo broliui pardavė Juozapą į Egiptą kaip vergą. Bet Dievas buvo su juo. ");
INSERT INTO litb_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Jis apsaugojo Juozapą nuo sielvarto ir suteikė išminties Egipto karaliaus, faraono, akivaizdoje. Dievas davė Juozapui nepaprastą išmintį, todėl faraonas paskyrė ji Egipto valdovu, pavesdamas jam ir savo rūmų reikalus. ");
INSERT INTO litb_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Bet Egipte ir Kanaano žemėje kilo badas, ir mūsų protėviai atsidūrė dideliame varge. ");
INSERT INTO litb_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Jokūbas išgirdo, kad Egipte dar yra javų, ir išsiuntė savo sūnus, kad nupirktų truputį. ");
INSERT INTO litb_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Kai jie atvyko į Egiptą antrą kartą, Juozapas leidosi atpažįstamas, ir broliai buvo pristatyti faraonui. ");
INSERT INTO litb_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Tada Juozapas pakvietė savo tėvą Jokūbą ir visų brolių šeimas, iš viso septyniasdešimt penkis asmenis, kad atvyktų į Egiptą. ");
INSERT INTO litb_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Šitaip Jokūbas atkeliavo į Egiptą, kur mirė jis ir visi jo sūnūs. ");
INSERT INTO litb_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Juos visus pargabeno į Sichemą ir palaidojo kape, kurį Abraomas buvo nupirkęs Sicheme iš Emoro sūnų. ");
INSERT INTO litb_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","18","Artinantis laikui, kai Dievas turėjo išpildyti Abraomui duotą pažadą išlaisvinti jo palikuonis iš vergijos, Egipte labai išaugo žydų skaičius. Tačiau tuo metu buvo karūnuotas karalius, kuris negerbė Juozapo atminimo. ");
INSERT INTO litb_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Šis karalius rengė sąmokslą prieš mūsų giminę, versdamas mūsų protėvius pamesti savo vaikus laukuose. ");
INSERT INTO litb_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Tuo metu gimė dieviško grožio vaikas – Mozė. Jo tėvai slėpė jį tris mėnesius namuose, ");
INSERT INTO litb_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","o kai nebegalėjo laikyti jo paslėpę, turėjo jį palikti. Jį rado faraono duktė ir paėmė auginti, įsūnijo bei ");
INSERT INTO litb_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","mokė visos Egipto išminties. Taip jis tapo galingu valdovu ir oratoriumi. ");
INSERT INTO litb_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Vieną dieną, artėjant keturiasdešimtajam gimtadieniui, jam kilo mintis aplankyti savo brolius izraelitus. ");
INSERT INTO litb_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","To apsilankymo metu jis pamatė egiptietį, nedorai besielgiantį su izraelitu. Mozė keršydamas užmušė egiptietį. ");
INSERT INTO litb_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mozė tikėjosi, kad broliai supras, jog Dievas jį siuntė jiems padėti, bet šie nieko nesuprato. ");
INSERT INTO litb_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Kitą dieną jis vėl juos aplankė ir pamatė besivaidijančius du izraelitus. Mozė mėgino juos sutaikyti, sakydamas: „Vyrai, jūs esate broliai! Todėl neturite šitaip kovoti. To neturite daryti.“ ");
INSERT INTO litb_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Bet tasai, kuris buvo nuskriaudęs artimą, liepė Mozei rūpintis savais reikalais. „Kas tave paskyrė mūsų valdovu ar teisėju? – klausė jis. – ");
INSERT INTO litb_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Gal rengiesi ir mane nužudyti, kaip vakar nužudei egiptietį?“ ");
INSERT INTO litb_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Tada Mozė pabėgo iš šalies, apsigyveno Madiano krašte, kur gimė jo du sūnūs. ");
INSERT INTO litb_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Po keturiasdešimties metų dykumoje, netoli Sinajaus kalno, jam pasirodė angelas degančio krūmo liepsnose. ");
INSERT INTO litb_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mozė tai matė ir stebėjosi, kas ten yra; kai jis nubėgo pasižiūrėti, pakvietė Viešpaties balsas: ");
INSERT INTO litb_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","„Aš esu tavo Dievas, Abraomo, Izaoko ir Jokūbo Dievas.“ Mozė ėmė drebėti iš baimės ir nedrįso pažvelgti. ");
INSERT INTO litb_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","O Viešpats jam tarė: „Nusiauk apavą, nes tu stovi ant šventos žemės. ");
INSERT INTO litb_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Aš mačiau Egipte Savo tautos skausmą ir verksmą. Aš nužengiau jų išvaduoti. Tad ateik čionai! Aš ketinu tave pasiųsti į Egiptą.“ ");
INSERT INTO litb_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Ir tuo būdu Dievas sugrąžino tą, kurį pirma jo žmonės atmetė, sakydami: „Kas tave paskyrė vadovu ir mūsų teisėju?“ ");
INSERT INTO litb_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Mozė buvo siųstas kaip valdovas ir išgelbėtojas. Daugybės įsimintinų stebuklų pagalba jis išvedė juos iš Egipto, pervedė per Raudonąją jūrą ir vedžiojo keturiasdešimt metų dykumoje. ");
INSERT INTO litb_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Pats Mozė Izraelio žmonėms yra pasakęs: „Dievas pažadins Pranašą iš jūsų brolių tarpo, panašiai kaip mane.“ ");
INSERT INTO litb_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Tai buvo tikra tiesa, nes Mozė tarpininkavo tyruose tarp Izraelio žmonių ir angelo, kuris Sinajaus kalne perdavė jiems Dievo įsakymą – gyvąjį žodį. ");
INSERT INTO litb_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Bet mūsų tėvai atmetė Mozę ir norėjo grįžti į Egiptą. ");
INSERT INTO litb_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Jie sakė Aaronui: „Padirbdink mums dievų, kurie parvestų mus atgal, nes mes nežinome, kas nutiko tam Mozei, išvedusiam mus iš Egipto.“ ");
INSERT INTO litb_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Tokiu būdu jie pasidirbo dievą – aukso veršį – ir ėmė aukoti jam atnašą. Jie džiaugėsi savo rankų darbu. ");
INSERT INTO litb_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Dievas nusigręžė nuo jų, apleido juos, leisdamas jiems tarnauti saulei, mėnuliui, žvaigždėms kaip dievams! Amoso pranašysčių knygoje Viešpats klausia: „Negi Man, Izraeli, tu aukojai būdamas dykumoje šituos keturiasdešimt metų? ");
INSERT INTO litb_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Tu iš tiesų domiesi pagoniškais dievais – Molochu, dievo Romfos žvaigžde ir visais stabais, kuriuos pasidirbote, kad galėtumėte juos garbinti. Todėl pasiųsiu jus į nelaisvę toli, anapus Babilono.“ ");
INSERT INTO litb_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Mūsų protėviai per dykumą gabenosi su savimi kilnojamą šventyklą – tabernakulį. Jame jie laikė akmenines plokštes, ant kurių buvo užrašyti Dešimt įsakymų. Šis tabernakulis buvo sukurtas tiksliai pagal angelo Mozei duotą planą. ");
INSERT INTO litb_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Metams bėgant, kada Jozuė kovojo prieš pagonių gentis, šį tabernakulį pasiėmė su savimi į naująją žemę ir naudojo iki karaliaus Dovydo laikų. ");
INSERT INTO litb_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dievas nuoširdžiai palaimino Dovydą. Dovydas paprašė ypatingos teisės statyti šventovę Jokūbo Dievui. ");
INSERT INTO litb_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Saliamonas ją pastatė, ");
INSERT INTO litb_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","tačiau Dievas negyvena šventovėse, sukurtose žmogaus rankomis. ");
INSERT INTO litb_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","„Dangus – Man sostas, o žemė – suolelis Mano kojoms“, – sako Viešpats per Savo pranašus. „Kokius namus jūs Man statysite? – klausia Viešpats. – Ar Aš juose pasiliksiu? ");
INSERT INTO litb_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Argi ne Aš sukūriau dangų ir žemę?“ ");
INSERT INTO litb_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Jūs – užsispyrę stabmeldžiai! Negi jūs amžinai priešinsitės Šventajai Dvasiai? Taip darė jūsų tėvai, ir jūs taip darote! ");
INSERT INTO litb_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Paminėkite nors vieną pranašą, kurio nepersekiojo jūsų tėvai? Jie netgi žudydavo tuos, kurie pranašavo Teisiojo atėjimą, – Mesijo, kurį jūs išdavėte ir nužudėte. ");
INSERT INTO litb_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Taip, jūs sąmoningai sulaužėte Dievo įsakymus, nors juos gavote iš angelų rankų.“ ");
INSERT INTO litb_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Žydų vadovai labai įsižeidė dėl Stepono kaltinimų ir įniršę ėmė ant jo griežti dantis. ");
INSERT INTO litb_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","O Steponas, kupinas Šventosios Dvasios, ramiai žvelgė aukštyn į dangų, išvydo Dievo šlovę ir Jėzų, stovintį Dievo dešinėje! ");
INSERT INTO litb_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ir tuojau pasakė: „Štai matau dangų atvirą ir Jėzų, Mesiją, stovintį Dievo dešinėje!“ ");
INSERT INTO litb_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Tada, baisiai rėkdami ir stumdydamiesi, jie užsikimšo ausis ir visi kaip vienas puolė ji, ");
INSERT INTO litb_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","išsitempė už miesto ir užmušė akmenimis. Liudytojai – budeliai – nusivilko švarkus ir padėjo juos prie jaunuolio Sauliaus kojų. ");
INSERT INTO litb_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Kai žudikai svaidė akmenis į Steponą, jis meldėsi: „Viešpatie Jėzau, priimk mano sielą.“ ");
INSERT INTO litb_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Jis suklupęs šaukė: „Viešpatie, nelaikyk jų elgesio nuodėme!“ Ir ištaręs tuos žodžius, mirė. ");
INSERT INTO litb_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saulius visiškai pritarė Stepono nužudymui. Ir nuo tos dienos prasidėjo didelė tikinčiųjų persekiojimo banga, palietusi Jeruzalės bažnyčią. Visi, išskyrus apaštalus, pasklido po Judėją ir Samariją. ");
INSERT INTO litb_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Bet atėjo keletas pamaldžių žydų ir su didele širdgėla palaidojo Steponą. ");
INSERT INTO litb_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Saulius lyg laukinis siautėjo visur, persekiodamas tikinčiuosius. Įsiverždavo net į privačius namus, nežiūrėdamas, ar vyrai, ar moterys, suimdavo juos ir grūsdavo į kalėjimą. ");
INSERT INTO litb_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Pabėgę iš Jeruzalės, tikintieji visur sakė pamokslus ir skelbė gerąją naujieną apie Jėzų! Pavyzdžiui, ");
INSERT INTO litb_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Pilypas nuvyko į Samarijos miestą ir ten pasakojo žmonėms apie Kristų. ");
INSERT INTO litb_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Minios įdėmiai klausėsi, nes Jis darė daug stebuklų. ");
INSERT INTO litb_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Buvo išvaryta daug piktųjų dvasių, kurios šaukdamos palikdavo savo aukas, buvo išgydyta daug paralyžiuotųjų ir šlubų. ");
INSERT INTO litb_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Taigi tame mieste buvo daug džiaugsmo! ");
INSERT INTO litb_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","11","Tai buvo vyras, vardu Simonas, ilgą laiką buvęs žiniuonis, labai įtakingas, išdidus, nes jis galėjo padaryti nepaprastus dalykus. Samariečiai kalbėjo apie jį kaip apie Mesiją. ");
INSERT INTO litb_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Bet dabar jie įtikėjo Pilypo žodžiu, kad Jėzus yra Mesijas, ir jo žodžiais apie Dievo karalystę. Buvo pakrikštyta daug vyrų ir moterų. ");
INSERT INTO litb_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Tada ir Simonas įtikėjo, pasikrikštijo ir ėmė sekti paskui Pilypą. Jis buvo labai nustebintas Pilypo daromais stebuklais. ");
INSERT INTO litb_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Kai apaštalai Jeruzalėje išgirdo, kad Samarijos žmonės priėmė Dievo Žodį, jie nusiuntė tenai Petrą ir Joną. ");
INSERT INTO litb_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Vos tik jiems atvykus, jie ėmė melstis, kad tie nauji tikintieji gautų Šventąją Dvasią. ");
INSERT INTO litb_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Mat Ji dar nebuvo nė vieno iš jų aplankiusi. Jie dar tebuvo pakrikštyti Viešpaties Jėzaus vardu. ");
INSERT INTO litb_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Tuomet Petras ir Jonas ant tikinčiųjų dėjo rankas, šitaip įkvėpdami Šventąją Dvasią. ");
INSERT INTO litb_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Kai Simonas pamatė, kad Šventoji Dvasia aplanko žmones, kai apaštalas laimino juos, jis panoro nusipirkti šią galią. ");
INSERT INTO litb_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","„O, kad ir aš turėčiau tokią galią, kad ir man uždėjus rankas ant žmonių, juos aplankytų Šventoji Dvasia!“ – sušuko jis. ");
INSERT INTO litb_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Bet Petras tarė jam: „Tavo pinigai žus kartu su tavimi, nes manai, kad Dievo dovana yra nuperkama. ");
INSERT INTO litb_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Šis dalykas neatneš tau laimės, nes tu nesi teisus prieš Dievą. ");
INSERT INTO litb_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Nusigręžk nuo didelės nedorybės ir melskis. Galbūt Dievas dar atleis tavo piktas mintis, ");
INSERT INTO litb_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","nes tu esi pavydus ir nuodėmingas.“ ");
INSERT INTO litb_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","„Melskite už mane, – sušuko Simonas, – kad manęs neištiktų tie baisūs dalykai.“ ");
INSERT INTO litb_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Paliudiję ir paskelbę Dievo Žodį Samarijoje, Petras ir Jonas pasuko atgal į Jeruzalę, pakeliui sustodami keliuose samariečių kaimuose, kad perduotų žmonėms Dievo Žodį. ");
INSERT INTO litb_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Viešpaties angelas prabilo į Pilypą, tardamas: „Vidurdienį eik ant kelio, kuris vingiuoja iš Jeruzalės per Gazos dykumą.“ ");
INSERT INTO litb_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Taip jis ir padarė. Ir štai bevažiuojąs Etiopijos iždo valdytojas, eunuchas, turintis didelę įtaką karalienės Kandakės rūmuose. Jis buvo nuvykęs į Jeruzalę pasimelsti, ");
INSERT INTO litb_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","o dabar keliavo namo ir, sėdėdamas vežime, garsiai skaitė iš pranašo Izaijo knygos. ");
INSERT INTO litb_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Šventoji Dvasia tarė Pilypui: „Eik greta šito vežimo.“ ");
INSERT INTO litb_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Pribėgęs jis išgirdo, ką etiopas skaito, ir todėl paklausė: „Ar supranti, ką skaitai?“ ");
INSERT INTO litb_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","„Žinoma, ne! – šis atsiliepė. – Kaip aš galiu suprasti, jei man niekas nepaaiškina?“ Jis paprašė Pilypą lipti į vežimą ir sėsti šalia. ");
INSERT INTO litb_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Rašto vieta, kurią jis skaitė, buvo tokia: „Jis buvo vedamas kaip avis, vedama pjauti, ir kaip ėriukas, kuris tyli kerpamas, taip ir Jis neatvėrė Savo burnos. ");
INSERT INTO litb_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Jis liko pažemintas, todėl nebuvo nuteistas. Ir kas gali apsakyti Jo giminę, jeigu Jo gyvenimas žemėje buvo nutrauktas?!“ ");
INSERT INTO litb_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Eunuchas paklausė Pilypą: „Ar Izaijas kalbėjo apie save ar apie ką kitą?“ ");
INSERT INTO litb_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Todėl Pilypas pradėjo nuo minėtos Rašto vietos ir dar daug ką papasakojo jam apie Jėzų. ");
INSERT INTO litb_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Keliaudami toliau, jie privažiavo nedidelį vandens telkinį. Eunuchas prabilo: „Žiūrėkite! Vanduo! Kodėl negaliu būti pakrikštytas?“ ");
INSERT INTO litb_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","„Gali, – atsakė Pilypas, – jei tiki visa širdimi.“ Eunuchas atsakė: „Aš tikiu, kad Jėzus Kristus yra Dievo Sūnus.“ ");
INSERT INTO litb_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Jie sustojo ir nuėjo į vandenį, kur Pilypas eunuchą pakrikštijo. ");
INSERT INTO litb_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Kai jie išlipo iš vandens, Viešpaties Dvasia pasiėmė Pilypą. Eunuchas niekada daugiau jo nematė, bet keliavo toliau džiaugdamasis. ");
INSERT INTO litb_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Tuo tarpu Pilypas atsidūrė Azote! Pakeliui į Cezarėją jis skelbė gerąją naujieną visuose miestuose. ");
INSERT INTO litb_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","O Saulius, grasindamas ir degdamas noru sunaikinti Jeruzalėje kiekvieną krikščionį, ");
INSERT INTO litb_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","nuėjo pas vyriausiąjį kunigą ir pareikalavo rašto, adresuoto Damasko sinagogoms, kuriame joms buvo nurodyta dalyvauti persekiojant visus ten gyvenančius tikinčiuosius, vyrus ir moteris, kad jis galėtų juos suimtus gabenti į Jeruzalę. ");
INSERT INTO litb_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Su šia misija besiartinant prie Damasko, apšvietė jį dangaus šviesa! ");
INSERT INTO litb_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Parpuolęs ant žemės, jis išgirdo balsą: „Sauliau! Sauliau! Kam Mane persekioji?“ ");
INSERT INTO litb_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","„Kas Tu esi, Viešpatie“, – paklausė Saulius. O balsas atsakė: „Aš esu Jėzus, kurį tu persekioji! ");
INSERT INTO litb_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Dabar kelkis, eik į miestą ir lauk Mano tolimesnių nurodymų.“ ");
INSERT INTO litb_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Sauliaus draugai nustebę stovėjo be žado, nes jie girdėjo kažkieno balsą, tačiau nieko nematė. ");
INSERT INTO litb_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saulius atsikėlė nuo žemėsir pasijuto besąs aklas. Ji reikėjo nuvesti į Damaską, ir ten ");
INSERT INTO litb_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","tris dienas jis nieko nevalgė ir negėrė. ");
INSERT INTO litb_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damaske gyveno tikintysis, vardu Ananijas. Apsireiškęs Viešpats jam kalbėjo: „Ananijau!“ „Taip, Viešpatie!“ – atsakė jis. ");
INSERT INTO litb_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Viešpats pasakė: „Nueik į gatvę, vadinamą Tiesiąja, surask Judo namus ir teiraukis tarsiečio, vardu Saulius. Jis dabar meldžiasi, ");
INSERT INTO litb_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","nes regėjime Aš jam parodžiau vyrą, vardu Ananijas, ateinantį uždėti ant jo rankas, kad jis vėl praregėtų.“ ");
INSERT INTO litb_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","„Bet, Viešpatie, aš esu girdėjęs apie baisius dalykus, kuriuos šis žmogus padarė tikintiesiems Jeruzalėje, – sušuko Ananijas. – ");
INSERT INTO litb_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Mes girdime, kad jis turi aukštųjų kunigų įgaliojimus suimti visus, kurie šaukiasi Tavojo vardo!“ ");
INSERT INTO litb_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Bet Viešpats pasakė: „Eik ir daryk, kaip sakau. Saulius yra Mano išrinktasis, kuris neš Mano žodžius tautoms ir karaliams, o taip pat ir Izraelio žmonėms. ");
INSERT INTO litb_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Aš jam parodysiu, kiek daug jam teks iškentėti dėl Manęs.“ ");
INSERT INTO litb_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Taigi Ananijas nuėjo į tuos namus, rado Saulių, uždėjo ant jo rankas ir tarė: „Broli Sauliau, Viešpats Jėzus, kuris pasirodė tau kelyje, atsiuntė mane, kad tau įkvėpčiau Šventąją Dvasią ir atgautum regėjimą.“ ");
INSERT INTO litb_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Akimirksniu (atrodė tartum nuo jo akių žvynai nukrito) Saulius atgavo regėjimą ir tuojau pat buvo pakrikštytas. ");
INSERT INTO litb_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Po to užvalgęs įgijo jėgų. Saulius, pabuvęs kelias dienas su tikinčiaisiais Damaske, ");
INSERT INTO litb_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","nuėjo ir sinagogose visiems skelbė gerąją naujieną apie Jėzų, kad Jis iš tiesų yra Dievo Sūnus. ");
INSERT INTO litb_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Visi, kurie tatai girdėjo, stebėjosi ir klausinėjo: „Ar čia ne tas pats, kuris taip žiauriai persekiojo Jėzaus pasekėjus Jeruzalėje? – klausė jie. – Argi jis nėra atvykęs jų suimti?“ ");
INSERT INTO litb_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Saulius vis karščiau kalbėjo ir Damasko žydai negalėjo pakęsti tų įrodymų, kad Jėzus iš tiesų yra Mesijas. ");
INSERT INTO litb_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Po kurio laiko žydų vadovai nusprendė jį nužudyti. ");
INSERT INTO litb_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Bet Saulius žinojo jų planą. Jie tykojo jo prie miesto vartų dieną ir naktį, pasiruošę jį nužudyti. ");
INSERT INTO litb_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Taigi nakčia keletas mokinių pintinėje nuleido jį per miesto sienos angą žemyn. ");
INSERT INTO litb_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Atvykęs į Jeruzalę, jis stengėsi susitikti su tikinčiaisiais, bet jie visi jo bijojo. Jie manė, kad jis apgaudinėja. ");
INSERT INTO litb_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Tada Barnabas nusivedė jį pas apaštalus ir jiems papasakojo, kaip Saulius regėjęs Viešpatį kelyje į Damaską ir ką Viešpats jam sakė, o taip pat kalbėjo apie tai, kaip jis nuoširdžiai mokė Jėzaus vardu. ");
INSERT INTO litb_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Tik tada jie jį priėmė, ir Saulius nuolat būdavo su tikinčiaisiais ir ");
INSERT INTO litb_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","drąsiai mokė Viešpaties vardu. Bet keletas graikiškai kalbančių žydų, su kuriais jis ginčijosi, nutarė Saulių nužudyti. ");
INSERT INTO litb_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Kai kiti tikintieji išgirdo apie pavojų, jie nugabeno jį į Cezarėją ir tada išsiuntė namo, į Tarsą. ");
INSERT INTO litb_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Tuo tarpu bažnyčia visoje Judėjoje, Galilėjoje, Samarijoje džiaugėsi ramybe. Vis augo bažnyčios galia ir tikinčiųjų skaičius. Tikintieji išmoko gyventi Dievo baimėje, globojami Šventosios Dvasios. ");
INSERT INTO litb_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Petras keliavo iš vienos vietos į kitą, lankydamas juos. Bekeliaudamas aplankė tikinčiuosius, gyvenančius Lidoje. ");
INSERT INTO litb_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ten jis sutiko žmogų, vardu Enėjas. Jis buvo paralyžiuotas ir aštuonerius metus ligos prirakintas prie lovos. ");
INSERT INTO litb_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Petras jam tarė: „Enėjau! Jėzus Kristus teišgydo tave! Kelkis ir pasiklok lovą.“ Ir bematant jis buvo išgydytas. ");
INSERT INTO litb_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Tada visi Lidos ir Sarono gyventojai, pamatę jį vaikštantį, atsivertė į Viešpatį. ");
INSERT INTO litb_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Jopėje buvo tikinčioji moteris, vardu Tabita, išvertus Dorkadė (Gazelė), kuri buvo garsi gerais darbais ir išmaldomis. ");
INSERT INTO litb_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Tomis dienomis ji susirgo ir mirė. Jos draugai pašarvojo ją aukštutiniame kambaryje. ");
INSERT INTO litb_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Bet mokiniai išgirdo, jog netoliese Lidoje yra Petras, todėl jie pasiuntė du vyrus, kad šie paprašytų Petrą su jais grįžti į Jopę. ");
INSERT INTO litb_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Taip jis ir padarė. Kai tik Petras atvyko, jie nusivedė jį į viršų, kur gulėjo Tabita. Kambarys buvo pilnas verkiančių našlių, kurios viena kitai rodė Tabitos joms pasiūtus rūbus. ");
INSERT INTO litb_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Bet Petras liepė joms visoms išeiti iš kambario. Tada jis atsiklaupė ir ėmė melstis. Pasisukęs į lavoną, tarė: „Kelkis, Tabita!“, ir ji atmerkė akis! Pamačiusi Petrą, ji atsisėdo. ");
INSERT INTO litb_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Jis padavė jai ranką ir padėjo atsikelti. Sukvietęs tikinčiuosius ir našles, parodė ją gyvą. ");
INSERT INTO litb_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Žinia pasklido mieste, ir daugelis įtikėjo Viešpatį. ");
INSERT INTO litb_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Petras ilgą laiką pasiliko Jopėje pas vieną kailiadirbį Simoną. ");
INSERT INTO litb_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Cezarėjoje gyveno romėnų armijos karininkas Kornelijus, italų kohortos šimtininkas. ");
INSERT INTO litb_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Jis buvo pamaldus žmogus, giliai nuolankus, kaip ir visi jo namiškiai. Jis dosniai šelpdavo žmones ir ištvermingai melsdavosi Dievui. ");
INSERT INTO litb_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Vieną popietę, apie trečią valandą, kai jis nemiegojo, regėjime pamatė Dievo angelą, kuris tarė: „Kornelijau!“ ");
INSERT INTO litb_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kornelijus pažvelgė į jį išsigandęs. „Kas yra, Viešpatie?“ – jis paklausė angelo. Angelas jam atsakė: „Tavo maldos ir išmaldos Dievo akyse neliko nepastebėtos! ");
INSERT INTO litb_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Pasiųsk keletą vyrų į Jopę, kad surastų žmogų, vardu Simonas Petras, ");
INSERT INTO litb_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","kuris svečiuojasi pas Simoną kailiadirbį, kurio namai stovi ant jūros kranto, ir pakviesk, kad jis ateitų tavęs aplankyti.“ ");
INSERT INTO litb_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Vos tik angelas pasitraukė, Kornelijus pasišaukė du namiškius tarnus ir vieną pamaldų kareivį iš patarnautojų ");
INSERT INTO litb_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","ir visa, kas atsitiko, jiems išaiškinęs, išsiuntė į Jopę. ");
INSERT INTO litb_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","10","Rytojaus dieną, jiems besiartinant prie miesto, Petras užlipo ant plokščiastogio pasimelsti. Buvo vidurdienis, ir jis pasijuto išalkęs. Bet kol buvo ruošiamas maistas, jį aplankė Šventoji Dvasia. ");
INSERT INTO litb_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Jis pamatė atsivėrusį dangų ir didelę storą drobinę paklodę lyg maršką, už keturių kampų nuleidžiamą ant žemės. ");
INSERT INTO litb_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Joje buvo įvairiausių gyvūnų, gyvačių ir paukščių (žydų draudžiamų vartoti maistui). ");
INSERT INTO litb_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Tada balsas jam pasakė: „Kelkis, Petrai, pjauk ir valgyk ką nori!“ ");
INSERT INTO litb_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","„Viešpatie, niekada gyvenime aš nevalgiau tokių sutvėrimų, nes žydų įstatymai juos draudžia valgyti“, – atsakė Petras. ");
INSERT INTO litb_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Balsas vėl kalbėjo: „Ką Dievas apvalė, tu nevadink suteptu!“ ");
INSERT INTO litb_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Regėjimas pasikartojo tris kartus. Tada drobinis padėklas vėl pakilo į dangų. ");
INSERT INTO litb_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Petras buvo tarsi pritrenktas. Ką regėjimas galėtų reikšti? Ką jam reikia daryti? Kaip tik tada Kornelijaus siųsti vyrai rado namą ir, stovėdami už vartų, ");
INSERT INTO litb_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","teiravosi, ar Simonas Petras gyvena šioje vietoje! ");
INSERT INTO litb_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Tuo tarpu, kol Petras buvo regėjimo apstulbintas, Šventoji Dvasia jam pasakė: „Trys vyrai ieško tavęs. ");
INSERT INTO litb_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Lipk žemyn, sutik juos ir keliauk su jais. Viskas tvarkoje. Tai aš juos siunčiau.“ ");
INSERT INTO litb_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Taip Petras nulipo žemyn ir tarė: „Štai ir aš, kurio ieškote. Su kokiu reikalu atėjote?“ ");
INSERT INTO litb_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Tada jie papasakojo jam apie romėnų karininką Kornelijų, teisų ir pamaldų, visų žydų didžiai gerbiamą žmogų, gavusį angelo nurodymą pasikviesti Petrą į savo namus ir išklausyti jo pamokymų. ");
INSERT INTO litb_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Taigi Petras pasikvietė juos į vidų ir priglaudė nakčiai. Kitą rytą jis iškeliavo su jais, lydimas keleto kitų tikinčiųjų iš Jopės. ");
INSERT INTO litb_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Rytojaus dieną jie atvyko į Cezarėją. Kornelijus jau laukė jo, sukvietė gimines ir artimuosius draugus. ");
INSERT INTO litb_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Petrui įėjus į jo namus, Kornelijus puolė prie jo kojų, išreikšdamas jam pagarbą. ");
INSERT INTO litb_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Bet Petras pasakė: „Kelkis! Aš ne Dievas!“ ");
INSERT INTO litb_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Jis atsikėlė, ir jie kurį laiką kalbėjosi, tada įėjo į vidų, kur buvo susirinkę žmonės. ");
INSERT INTO litb_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Petras prabilo: „Jūs žinote, kad man nedera vaikščioti po pagonių namus. Bet regėjime man Viešpats parodė, kad negalima jokio žmogaus laikyti žemesniu. ");
INSERT INTO litb_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Taigi atvykau, kai tik mane pakvietė. Dabar pasakykite, kokiu reikalu mane pakvietėte?“ ");
INSERT INTO litb_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kornelijus atsakė: „Prieš keturias dienas aš meldžiausi įprastą popietės valandą. Tik štai stojo prieš mane vyras spindinčiais drabužiais! ");
INSERT INTO litb_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Jis man tarė: „Kornelijau, tavo maldos išklausytos ir Dievas prisiminė tavo maldas. ");
INSERT INTO litb_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Dabar siųsk keletą vyrų į Jopę ir pasikviesk Simoną, vadinamą Petru, kuris apsistojęs kailiadirbio namuose prie jūros.“ ");
INSERT INTO litb_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Taigi aš tuojau pasiunčiau pas tave žmones, o tu gerai padarei, kad taip greitai atvykai. Štai mes dabar čia, Viešpaties akivaizdoje, laukiame norėdami išgirsti, kas tau Viešpaties įsakyta!“ ");
INSERT INTO litb_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Tada Petras atsakė: „Aš labai aiškiai matau, kad žydai ne vieni yra Dievo mylimi! ");
INSERT INTO litb_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Kiekvienoje tautoje yra Jį garbinančių geradarių, ir jie Jam mieli. ");
INSERT INTO litb_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Aš esu tikras, kad jūs girdėjote apie gerąją naujieną Izraelio žmonėms. Per Jėzų Mesiją, kuris yra visos kūrinijos Viešpats, ateina ramybė. ");
INSERT INTO litb_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ši naujiena pasklido po visą Judėją po Jono Krikštytojo misijos Galilėjoje. ");
INSERT INTO litb_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Jūs taip pat žinote, kad Jėzui iš Nazareto Dievas įkvėpė Šventąją Dvasią ir suteikė galybę, todėl Jis keliavo darydamas gera ir gydydamas visus piktųjų dvasių apsėstuosius, nes Dievas buvo su Juo. ");
INSERT INTO litb_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Mes, apaštalai, esame liudininkai to, ką Jis yra padaręs Izraelyje ir Jeruzalėje, kur Jis buvo nužudytas ant kryžiaus. ");
INSERT INTO litb_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","41","Bet trečią dieną Dievas Jį prikėlė iš numirusių, leido Jam pasirodyti ne visai tautai, bet Dievo iš anksto paskirtiems žmonėms. ");
INSERT INTO litb_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Jis mus siuntė visur skelbti gerąją naujieną ir liudyti, kad Jėzus – Dievo paskirtasis, visų gyvųjų ir mirusiųjų Teisėjas. ");
INSERT INTO litb_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Apie Jį visi pranašai liudijo sakydami, kad kiekvienas, kas Juo tiki, gauna Jo vardu nuodėmių atleidimą.“ ");
INSERT INTO litb_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Petrui pasakojant tuos dalykus, Šventoji Dvasia aplankė visus, kurie klausėsi jo žodžio. ");
INSERT INTO litb_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Žydai, kurie buvo atvykę drauge su Petru, labai stebėjosi, kad Šventosios Dvasios dovana buvo duodama ir pagonims! ");
INSERT INTO litb_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","47","Dėl to nėra abejonės, nes jie girdėjo juos kalbant įvairiomis kalbomis ir šlovinant Dievą. Petras paklausė: „Argi kas galėtų dabar neleisti man juos krikštyti, jeigu juos, kaip ir mus, jau aplankė Šventoji Dvasia?“ ");
INSERT INTO litb_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Jis krikštijo juos Jėzaus Kristaus, vardu. Paskui Kornelijus prašė jį pasilikti dar kelias dienas. ");
INSERT INTO litb_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Greitai naujiena pasiekė apaštalus ir kitus brolius Judėjoje, kad pagonys atsivertė! ");
INSERT INTO litb_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Kai Petras sugrįžo į Jeruzalę, žydų tikintieji ginčijosi su juo. ");
INSERT INTO litb_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","„Tu draugavai su pagonimis ir netgi su jais valgei!“ – kaltino jie. ");
INSERT INTO litb_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Tada Petras jiems papasakojo visą istoriją: ");
INSERT INTO litb_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","„Sykį Jopėje aš meldžiausi ir regėjime pamačiau didelę keturkampę paklodę, nusileidžiančią iš dangaus. ");
INSERT INTO litb_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Paklodės viduje buvo visų rūšių gyvių: roplių, paukščių (kurių mums negalima valgyti). ");
INSERT INTO litb_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Aš girdėjau balsą, kuris man sakė: „Pjauk ir valgyk, ką tik nori.“ ");
INSERT INTO litb_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Aš atsakiau: „Niekada, Viešpatie! Dar niekada nevalgiau to, ką draudžia žydų įstatymai!“ ");
INSERT INTO litb_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Bet balsas iš dangaus prabilo vėl: „Nesakyk, kad tai neteisinga, kai Dievas sako, kad teisinga!“ ");
INSERT INTO litb_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Taip atsitiko tris kartus, ir vėl paklodė ir visa, kas joje buvo, pranyko danguje. ");
INSERT INTO litb_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Kaip tik tada trys vyrai atvyko į namus, kur buvau apsistojęs, manęs pasiimti į Cezarėją! ");
INSERT INTO litb_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Šventoji Dvasia man įsakė vykti su jais ir nesirūpinti dėl to, kad jie pagonys. Mane lydėjo šitie šeši broliai, ir mes greitai atvykome į vieno žmogaus namus, kuris siuntė pasiuntinius. ");
INSERT INTO litb_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Jis mums papasakojo regėjęs angelą, kuris jam liepė siųsti pasiuntinius į Jopę ir surasti Simoną Petrą! ");
INSERT INTO litb_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Jis pamokys, kaip jam ir jo namiškiams išsigelbėti. ");
INSERT INTO litb_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Na, aš pradėjau jiems skelbti gerąją naujieną. Kai tik pradėjau kalbėti, juos aplankė Šventoji Dvasia, kaip pradžioje buvo aplankiusi ir mus. ");
INSERT INTO litb_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Tada aš apmąsčiau Viešpaties žodžius, kaip Jis yra pasakęs: „Taip, Jonas krikštijo vandeniu, o jūs būsite pakrikštyti Šventąja Dvasia.“ ");
INSERT INTO litb_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Jeigu Dievas davė šitiems pagonims tokią pačią dovaną kaip ir mums, įtikėjusiems Viešpatį Jėzų Kristų, tai kas gi aš toks, kad turėčiau ginčytis?“ ");
INSERT INTO litb_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Kai kiti tai išgirdo, buvo atsakyta į visus jų prieštaravimus, ir jie pradėjo šlovinti Dievą! „Taip, – sakė jie, – Dievas pagonims taip pat davė ypatingą malonę, atsigręžus į Jį, gauti amžinąjį gyvenimą.“ ");
INSERT INTO litb_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Tuo tarpu tikintieji, kurie persekiojimo metu po Stepono mirties buvo pabėgę iš Jeruzalės, nukeliavo į Finikiją, Kiprą, Antiochiją skleisdami gerąją naujieną ne tiktai žydams. ");
INSERT INTO litb_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Kai kurie tikintieji, keliavę iš Kipro ir Kirėnės į Antiochiją, atnešė ir graikams žinią apie Viešpatį Jėzų. ");
INSERT INTO litb_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Taip Viešpats buvo su jais, ir daug pagonių tapo tikinčiaisiais. ");
INSERT INTO litb_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Kai bažnyčia Jeruzalėje išgirdo, kas atsitiko, ji išsiuntė Barnabą į Antiochiją padėti naujai įtikėjusiems. ");
INSERT INTO litb_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Atvykęs ir pamatęs nuostabius Dievo darbus, jis labai apsidžiaugė ir paragino tikinčiuosius likti ištikimus Viešpačiui bet kokia kaina. ");
INSERT INTO litb_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabas buvo geras žmogus, kupinas Šventosios Dvasios bei tvirto tikėjimo. Tai daugeliui žmonių padėjo įtikėti Dievą. ");
INSERT INTO litb_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Tuomet Barnabas nukeliavo toliau į Tarsą ieškoti Pauliaus. ");
INSERT INTO litb_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Radęs jį, grįžo į Antiochiją. Jie abu gyveno ten ištisus metus mokydami naujai pakrikštytuosius. (Antiochijoje tikintieji pirmą kartą buvo pavadinti krikščionimis.) ");
INSERT INTO litb_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Tomis dienomis iš Jeruzalės atvyko kai kurie pranašai į Antiochiją. ");
INSERT INTO litb_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Vienas jų, vardu Agabas, viename susirinkime, Šventosios Dvasios įkvėptas, išpranašavo didelį badą Izraelio žemėje. ");
INSERT INTO litb_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Tikintieji nusprendė padėti Judėjai, kiekvienas aukodamas tiek, kiek galėjo. ");
INSERT INTO litb_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Dovanas jie siuntė Jeruzalės bažnyčios vyresniesiems per Barnabą ir Paulių. ");
INSERT INTO litb_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Apie tą laiką karalius Erodas ėmė persekioti kai kuriuos tikinčiuosius. ");
INSERT INTO litb_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Užmušė apaštalą Jokūbą, Jono broli. ");
INSERT INTO litb_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Pamatęs, kad tai labai džiugino žydų vadovus, jis per Velykų šventes suėmė Petrą ");
INSERT INTO litb_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","ir įmetė kalėjiman, pavesdamas saugoti jį šešiolikos kareivių sargybai. Po Velykų Erodas ketino atiduoti Petrą žydų egzekucijai. ");
INSERT INTO litb_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Bažnyčioje visi karštai meldė Dievą, kad Petras kalėjime būtų saugus. ");
INSERT INTO litb_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Paskutinę naktį, kai Petras turėjo būti atiduotas žydams, jis miegojo surakintas dviem grandinėmis. Jį saugojo du kareiviai, o kiti stovėjo prie kalėjimo vartų. ");
INSERT INTO litb_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Staiga kalėjimo kamerą nutvieskė šviesa. Priešais Petrą atsirado Viešpaties angelas! Angelas pažadino Petrą, bakstelėdamas į šoną, ir tarė: „Kelkis greičiau!“ Nuo rankų nukrito grandinės. ");
INSERT INTO litb_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Tada angelas kalbėjo toliau: „Renkis ir apsiauk batus!“ Jis taip ir padarė. „Dabar apsivilk apsiaustą ir eik paskui mane“, – įsakė angelas. ");
INSERT INTO litb_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Tada Petras, sekdamas angelą, išėjo iš kalėjimo kameros. Bet visą laiką jis negalėjo suvokti, ar tai sapnas, ar regėjimas, ir netikėjo, jog viskas vyksta tikrovėje. ");
INSERT INTO litb_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Jie praėjo pro pirmą, antrą sargybą ir prisiartino prie geležinių gatvės vartų. Vartai savaime atsidarė! Taigi jie išėjo. Kiek palydėjęs Petrą gatve, angelas nuo jo pasitraukė. ");
INSERT INTO litb_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Petras, supratęs kas atsitiko, tarė sau: „Tai tiesa! Viešpats siuntė angelą, kad išgelbėtų mane iš Erodo rankų ir žydų kėslų.“ ");
INSERT INTO litb_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Taip mąstydamas, jis atėjo prie Morkumi vadinamo Jono motinos Marijos namų, kuriuose maldai buvo susirinkę daug žmonių. ");
INSERT INTO litb_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Jis pasibeldė į vartų duris. Atidaryti atėjo mergaitė, vardu Rodė. ");
INSERT INTO litb_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Pažinusi Petro balsą, ji iš džiaugsmo nubėgo į vidų pranešti visiems, jog gatvėje stovi Petras. ");
INSERT INTO litb_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Jie netikėjo jos žodžiais. „Tu pakvaišai!“ – sakė jie. Ji atkakliai tvirtino savo. Tada jie nusprendė: „Tai greičiausiai jo angelas. Jie tikriausiai jį nužudė.“ ");
INSERT INTO litb_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Tuo tarpu Petras tebesibeldė į lauko duris. Atidarę jie nustėro. ");
INSERT INTO litb_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Jis davė ženklą nurimti ir papasakojo, kas buvo atsitikę ir kaip Viešpats išvedė jį iš kalėjimo. „Pasakykite Jokūbui ir kitiems apie tai, kas atsitiko“, – sakė jis. ");
INSERT INTO litb_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Auštant kalėjime kilo didelis sąmyšis. Kas atsitiko Petrui? ");
INSERT INTO litb_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Erodas pasiuntė ji atvesti, bet niekur nerado. Jis suėmė šešiolika sargybinių, teisė karo teisme ir nubaudė mirtimi. Po to jis kuriam laikui persikėlė į Cezarėją. ");
INSERT INTO litb_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Erodui tebesant Cezarėjoje, jo aplankyti atvyko gyventojai iš Tyro ir Sidono miestų. Erodas buvo labai nepatenkintas tų dviejų miestų žmonėmis, bet jų atstovai draugavo su Blastu, karaliaus sekretorium, ir prašė taikos, nes jų miestai ekonomiškai priklausė nuo prekybos su Erodo šalimi. ");
INSERT INTO litb_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Buvo duotas leidimas susitikti su Erodu. Tai dienai atėjus, jis, apsivilkęs karališkais rūbais, sėdėjo soste ir pasakė jiems prakalbą. ");
INSERT INTO litb_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Pabaigoje žmonės sukėlė dideles ovacijas, šaukdami: „Tai dievo balsas, ne žmogaus!“ ");
INSERT INTO litb_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Bematant Viešpaties angelas palietė Erodą, ir jis susirgo, ji užpuolė kirminai ir jis mirė, kadangi priėmė žmonių pagarbą, užuot šlovinęs Dievą. ");
INSERT INTO litb_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Viešpaties geroji naujiena greitai plito, ir tikinčiųjų skaičius vis augo. ");
INSERT INTO litb_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnabas ir Paulius aplankė Jeruzalę, ir kai tik jie, įvykdę savo užduotis, grįžo į Antiochiją, pasiėmė su savimi Joną, vadinamą Morkumi. ");
INSERT INTO litb_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antiochijos bažnyčioje buvo pranašų ir mokytojų: tai Barnabas ir Simonas, pravarde Juodasis, Lucijus Kirėnietis, Manaenas, karaliaus Erodo įbrolis ir Paulius. ");
INSERT INTO litb_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Vieną dieną, jiems besimeldžiant ir pasninkaujant, Šventoji Dvasia pasakė: „Skirkite Barnabui ir Pauliui darbą, kuriam Aš juos pašauksiu.“ ");
INSERT INTO litb_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Tada po ilgesnių pasninkų ir maldų vyrai uždėjo ant jų rankas ir siuntė juos toliau. ");
INSERT INTO litb_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Šventosios Dvasios vedami, jie iškeliavo į Seleukiją, o iš ten išplaukė į Kiprą. ");
INSERT INTO litb_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Atvykę į Salamino miestą, jie nuėjo į žydų sinagogą ir ėmė skelbti Dievo Žodį. (Jonas Morkus buvo jų padėjėjas.) ");
INSERT INTO litb_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","7","Po to jie ėjo, sakydami pamokslus, iš miesto į miestą per visą salą iki Pafo, kur pagaliau susitiko burtininką žydą, netikrą pranašą, vardu Barjėzus. Jis buvo artimas labai įžvalgiam ir supratingam valdytojui Sergijui Pauliui. Valdytojas pakvietė jį aplankyti Barnabą ir Paulių, nes norėjo išgirsti Dievo Žodį. ");
INSERT INTO litb_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Bet burtininkas Elimas (jo graikiškas vardas) trukdė ir ragino nekreipti dėmesio į tai, ką sakė Paulius ir Barnabas, stengdamasis atitraukti jį nuo tikėjimo Viešpačiu. ");
INSERT INTO litb_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Tada Paulius, kupinas Šventosios Dvasios, piktai pažvelgė į burtininką ir prabilo: ");
INSERT INTO litb_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","„Ak tu, velnio sūnau! Tu pilnas įvairiausių gudrybių ir niekšybių, prieše viso, kas gera. Ar niekada ir nebaigsi prieštarauti Viešpačiui? ");
INSERT INTO litb_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","O dabar Dievas uždeda ant tavęs savo baudžiančią ranką, ir tu kuriam laikui apaksi.“ Bematant ant jo nusileido rūkas ir tamsa, ir jis ėmė klajoti, maldaudamas, kad kas paimtų jį už rankos ir vestų. ");
INSERT INTO litb_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Pamatęs kas vyksta, valdytojas buvo nustebintas Dievo Žodžio galios ir įtikėjo. ");
INSERT INTO litb_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Iš Pafo Paulius ir visi su juo buvę atplaukė į Pergės uostamiestį Turkijoje. Čia Jonas pasitraukė nuo jų ir sugrįžo į Jeruzalę. ");
INSERT INTO litb_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Bet Barnabas ir Paulius leidosi toliau, kol pasiekė Pisidijos Antiochiją. Šeštadienį jie nuvyko į sinagogą melstis. ");
INSERT INTO litb_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Po įprastinio skaitymo iš Mozės ir Pranašų knygos atsakingieji už pamaldas pasiuntė jiems tokio turinio raštelį: „Broliai, jei turite kokį pamokantį žodį – tarkite!“ ");
INSERT INTO litb_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Taigi, atsistojęs Paulius pamojo sveikindamas ir kalbėjo: „Izraelio vyrai ir visi kiti čia susirinkę Dievą garbinantys žmonės, paklausykite! ");
INSERT INTO litb_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Izraelio tautos Dievas išsirinko mūsų protėvius, pagerbė juos, išvesdamas iš Egipto vergijos. ");
INSERT INTO litb_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Jis globojo juos, klajojančius tyruose keturiasdešimt metų, ");
INSERT INTO litb_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","20","po to Jis sunaikino septynias tautas Kanaane ir leido Izraeliui paveldėti jų žemes. Teisėjai valdė apie keturis šimtus penkiasdešimt metų, juos pakeitė pranašas Samuelis. ");
INSERT INTO litb_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Vėliau žmonės ėmė reikalauti karaliaus, ir tada Dievas davė jiems Saulių, Kišo sūnų, Benjamino giminės vyrą keturiasdešimčiai metų. ");
INSERT INTO litb_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Bet Dievas, pašalinęs jį, pakeitė karaliumi Dovydu, žmogumi, apie kurį Viešpats sakė: „Dovydas, Jeses sūnus, yra Mano širdžiai mielas, nes jis paklusnus Man.“ ");
INSERT INTO litb_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Jėzus yra vienas karaliaus Dovydo palikuonių, kurį Viešpats pažadėjo padaryti Izraelio Gelbėtoju! ");
INSERT INTO litb_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Kol Jis dar nebuvo atėjęs, Jonas Krikštytojas sakė pamokslus Izraelyje, aiškindamas būtinumą nusigręžti nuo nuodėmės ir atsigręžti į Dievą. ");
INSERT INTO litb_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Kadangi Jonas buvo bebaigiąs savo darbą, paklausė: „Negi manote, kad aš Mesijas? Ne! Bet Jis greitai ateis. Lyginant su Juo, aš esu niekas.“ ");
INSERT INTO litb_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Broliai, Abraomo sūnūs, o taip pat visi ne žydų tautybės žmonės, kurie gerbiate Dievą! Išganymas skirtas mums visiems! ");
INSERT INTO litb_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Žydai Jeruzalėje ir jų vadovai įvykdė pranašystę, nužudydami Jėzų, nes jie neatpažino Jo ir nesuprato, kad Jis yra Tasai, apie kurį rašė pranašai, nors ir girdėjo kiekvieną šeštadienį sakomus pranašų žodžius. ");
INSERT INTO litb_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Jie nerado Jame mirties vertos kaltės, bet reikalavo, kad Pilotas Jį nužudytų. ");
INSERT INTO litb_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Kai jie įvykdė visa, kas apie Jį buvo parašyta, Jėzų nuėmė nuo kryžiaus ir paguldė į kapą. ");
INSERT INTO litb_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Bet Dievas prikėlė Jį iš numirusių. ");
INSERT INTO litb_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Jį keletą kartų matė vyrai, kurie buvo atlydėję Jį iš Galilėjos į Jeruzalę. Tie vyrai nuolatos tai liudija viešai. ");
INSERT INTO litb_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","O dabar Barnabas ir aš esame čia, kad praneštume jums gerąją naujieną. Šiais laikais išsipildė Dievo duotas pažadas mūsų protėviams. Tuo pažadu Dievas prikėlė Jėzų. Štai ką apie Jėzų kalba antroji psalmė: „Šiandien Aš išaukštinau Tave, Savo Sūnų.“ ");
INSERT INTO litb_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Nes Dievas pažadėjo Jį prikelti amžiams. Tai byloja Raštas, kuriame sakoma: „Aš Tau padarysiu nuostabų dalyką, kurį pažadėjau Dovydui.“ ");
INSERT INTO litb_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Kitoje psalmėje Jis išsamiau paaiškina, sakydamas: „Dievas neleis supūti Savo vieninteliam Šventajam.“ ");
INSERT INTO litb_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Čia kalbama ne apie Dovydą, nes Dovydas, pasitarnavęs savo kartai pagal Dievo planą, mirė, buvo palaidotas ir supuvo, ");
INSERT INTO litb_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","o Šio antrojo kūnas nebuvo supuvęs. ");
INSERT INTO litb_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Broliai, klausykite! Per Jėzų jums bus atleidžiamos nuodėmės. ");
INSERT INTO litb_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Visiems tikintiems bus atleistos jų kaltės, ir jie bus pripažinti teisiais. To niekada negalėtų padaryti žydų įstatymas. ");
INSERT INTO litb_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Saugokitės! Neleiskite, kad jums pritaikytų pranašų žodžius: ");
INSERT INTO litb_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","„Žiūrėkite ir žūkite jūs, tiesos niekintojai, nes Aš ir dabar darau Savo darbą, kuriuo nenorite patikėti, net ir apie jį išgirdę.“ ");
INSERT INTO litb_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Tą dieną, kai žmonės išėjo iš sinagogos, jie prašė Paulių grįžti pas juos kitą savaitę ir pasakyti kalbą. ");
INSERT INTO litb_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Daug žydų ir pamaldžių prozelitų, kurie meldėsi sinagogoje, sekė gatve paskui Paulių ir Barnabą, kai abu vyrai ragino juos priimti Dievo siūlomas malones. ");
INSERT INTO litb_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Kitą savaitę susirinko beveik visas miestas pasiklausyti skelbiamo Viešpaties Žodžio. ");
INSERT INTO litb_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Išvydus tokią minią, žydus apėmė pavydas, ir jie piktžodžiaudami ėmė prieštarauti Pauliui. ");
INSERT INTO litb_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Tada Paulius ir Barnabas drąsiai kalbėjo ir pareiškė: „Buvo būtina, kad geroji Dievo naujiena pirmiausia būtų paskelbta žydams. Bet kadangi jūs ją atmetėte, tai nesate verti amžinojo gyvenimo. Na, mes pasiūlysime ją pagonims. ");
INSERT INTO litb_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Nes taip mums liepė Viešpats, sakydamas: „Paskyriau Tave, kad būtum šviesa pagonims, kad išgelbėtum juos visus, net ir tolimiausiuose žemės kampeliuose esančius.“ ");
INSERT INTO litb_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Kai pagonys tai išgirdo, jie buvo labai patenkinti ir džiaugėsi Pauliaus žinia, ir kas tik siekė amžinojo gyvenimo, įtikėjo. ");
INSERT INTO litb_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Taip Viešpaties naujiena paplito po visą šį kraštą. ");
INSERT INTO litb_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Tuo tarpu žydų vadovai išjudino pamaldžias moteris ir įtakingus miesto piliečius, sukvietė minią prieš Paulių ir Barnabą ir išvijo juos iš miesto. ");
INSERT INTO litb_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Bet jie, nusikratę nuo kojų miesto dulkes, nukeliavo į Ikonijų. ");
INSERT INTO litb_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Mokiniai, kupini Šventosios Dvasios, labai džiaugėsi. ");
INSERT INTO litb_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ikonijuje Paulius ir Barnabas kartu nuėjo į sinagogą ir taip karštai meldėsi, kad įtikėjo daugybė žydų ir graikų. ");
INSERT INTO litb_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Bet žydai, kurie su panieka atmetė Dievo Žodį, kurstė pagonis prieš Paulių ir Barnabą, pasakodami apie juos įvairiausius paikus dalykus. ");
INSERT INTO litb_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Nepaisydami to, jie pasiliko ten ir drąsiai skelbė Dievo Žodį. Viešpats įrodė, kad jų skelbiama naujiena priklausė nuo Jo veiklos. Viešpats įgalino juos daryti didelius stebuklus. ");
INSERT INTO litb_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Bet miesto žmonių nuomonės skyrėsi: vieni buvo už žydų vadovus, kiti palaikė apaštalus. ");
INSERT INTO litb_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","6","Kai Paulius ir Barnabas sužinojo apie pagonių, žydų bei žydų vadovų sąmokslą pulti ir užmušti juos akmenimis, gelbėdamiesi jie pabėgo į Likaonijos miestus Listrą ir Derbę bei jų apylinkes ");
INSERT INTO litb_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ir skelbė ten Dievo Žodį. ");
INSERT INTO litb_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Būdami Listroje, jie sutiko žmogų, kuris buvo luošas nuo pat gimimo ir niekuomet nebuvo nė žingsnio žengęs. ");
INSERT INTO litb_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Jis klausėsi Pauliaus pamokslų, o pastarasis stebėjo jį ir suprato, kad ligonis tiki, jog pasveiks. ");
INSERT INTO litb_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Taigi Paulius sušuko jam: „Atsistok!“ Žmogus pašoko ir pradėjo vaikščioti! ");
INSERT INTO litb_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Besiklausanti minia, pamačiusi, ką Paulius padarė, sušuko (žinoma, vietiniu dialektu): „Šie vyrai yra dievai, bet turi žmogaus pavidalą.“ ");
INSERT INTO litb_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Jie nusprendė, kad Barnabas esąs dievas Dzeusas, o Paulius – Hermis. ");
INSERT INTO litb_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Priemiestyje esančios Dzeuso šventyklos kunigas atgabeno jiems pilną vežimą gėlių ir minios akivaizdoje paruošė galvijus aukojimui prie miesto vartų. ");
INSERT INTO litb_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Bet Barnabas ir Paulius, pamatę, kas vyksta, su baime persiplėšė drabužius ir išbėgo, šaukdami: ");
INSERT INTO litb_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","„Vyrai! Ką darote? Mes žmonės kaip ir jūs! Mes atnešėme jums gerąją naujieną, kviesdami liautis garbinus tas tuštybes, ragindami geriau melstis gyvajam Dievui, kuris sukūrė dangų, žemę, jūrą ir visa, kas joje yra. ");
INSERT INTO litb_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Anksčiau Jis buvo leidęs tautoms elgtis, kaip jos nori. ");
INSERT INTO litb_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Bet Jis visa tai stebėjo. Jo liudytojai buvo geri darbai, tai yra siunčiamas lietus, gausus derlius, teikiamas maistas ir širdies džiaugsmas.“ ");
INSERT INTO litb_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Bet vis tiek Paulius ir Barnabas negalėjo perkalbėti žmonių, kad jiems neaukotų. ");
INSERT INTO litb_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Po kelių dienų keli žydai, atvykę iš Antiochijos ir Ikonijaus, sukurstė žmones, kurie akmenimis apsvaidė Paulių ir, manydami jį esant mirusį, išvilko laukan už miesto. ");
INSERT INTO litb_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Kai tik tikintieji jį apsupo, jis pakilo ir grįžo į miestą! Rytojaus dieną kartu su Barnabu leidosi į Derbę. ");
INSERT INTO litb_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Jie ten skelbė gerąją naujieną ir įgijo nemaža pasekėjų. Jie vėl pasuko atgal į Listrą, Ikonijų, Antiochiją. ");
INSERT INTO litb_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ten jie skatino tikinčiuosius stipriau mylėti Dievą ir savo artimą. Jie žmones padrąsino, kad šie tvirčiau tikėtų, nepabūgtų, kai bus persekiojami, priminė, jog į Dievo karalystę jie įeis tik tada, kai įveiks sunkius išbandymus. ");
INSERT INTO litb_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Paulius ir Barnabas taip pat paskyrė vyresniuosius kiekvienoje bažnyčioje ir meldėsi už juos, pasninkaudami ir pavesdami juos Dievui, kuriuo jie tikėjo. ");
INSERT INTO litb_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Tada per Pisidiją jie keliavo atgal į Pamfiliją, ");
INSERT INTO litb_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","vėl mokė Pergėje ir leidosi į Ataliją. ");
INSERT INTO litb_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Pagaliau jie laivu išplaukė atgal į Antiochiją, kur Dievas jiems buvo pavedęs padaryti darbą, dabar jau pabaigtą. ");
INSERT INTO litb_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Sugrįžę jie sukvietė tikinčiuosius ir pasakojo, kaip Dievas per juos atvėrė tikėjimo duris ir pagonims. ");
INSERT INTO litb_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Antiochijoje jie išbuvo su tikinčiaisiais netrumpą laiką. ");
INSERT INTO litb_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Kai Paulius ir Barnabas buvo Antiochijoje, atvykę žmonės iš Judėjos ėmė sakyti tikintiesiems, kad jie turi tvirtai laikytis seno žydų apipjaustymo papročio, nes kitaip negalės būti išgelbėti. ");
INSERT INTO litb_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Paulius ir Barnabas ilgai ginčijosi ir svarstė. Pagaliau tikintieji pasiuntė juos į Jeruzalę, lydimus keleto vietinių vyrų, kad ten pakalbėtų šiuo klausimu su apaštalais ir vyresniaisiais. ");
INSERT INTO litb_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Lydimi viso susirinkimo, jie iš miesto pasuko Jeruzalės link, pakeliui sustodami aplankyti tikinčiųjų Fenikijos ir Samarijos miestuose, ir visų džiaugsmui pasakojo, kad pagonys taip pat įtikėjo. ");
INSERT INTO litb_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Atvykę į Jeruzalę, jie susitiko su bažnyčios vadovais. Dalyvavo visi apaštalai ir vyresnieji. Paulius ir Barnabas pasakojo apie tai, ką Viešpats buvo per juos nuveikęs. ");
INSERT INTO litb_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Bet pakilo keletas vyrų, anksčiau buvusių fariziejų, ir paskelbė, kad visi atsivertėliai pagonys privalo būti apipjaustyti ir reikalavo laikytis visų žydų papročių bei ceremonijų. ");
INSERT INTO litb_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Tada apaštalai ir bažnyčios vyresnieji susirinko šio klausimo apsvarstyti. ");
INSERT INTO litb_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Po ilgų diskusijų atsistojo Petras ir kreipėsi į juos: „Broliai, visi jūs žinote, jog Dievas jau seniai pasirinko mane, kad skelbčiau pagonims gerąją naujieną ir kad jie taip pat įtikėtų. ");
INSERT INTO litb_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Dievas, kuris pažįsta žmonių širdis, paliudijo, kad Jis priima pagonis, duodamas jiems Šventąją Dvasią kaip ir mums. ");
INSERT INTO litb_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Jis neatskyrė jų nuo mūsų, tikėjimu apvalydamas jų širdis. ");
INSERT INTO litb_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Negi jūs ketinate mokyti Dievą, apsunkindami pagonis jungu, kurio nei mes, nei mūsų tėvai negalėjo pakelti? ");
INSERT INTO litb_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Negi netikite, kad visi išsigelbės tuo pačiu būdu – Viešpaties Jėzaus malone?“ ");
INSERT INTO litb_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Daugiau niekas nesiginčijo. Dabar visi klausėsi Barnabo ir Pauliaus pasakojimo apie Dievo padarytus stebuklus tarp pagonių. ");
INSERT INTO litb_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Jiems nutilus, prabilo Jokūbas: „Broliai, paklausykite manęs! ");
INSERT INTO litb_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Petras jums papasakojo, kaip Viešpats pirmiausia aplankė pagonis, kad ir jie šlovintų Jo vardą. ");
INSERT INTO litb_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Pagonių atsivertimas rodo, jog pranašai buvo teisūs. Pavyzdžiui, paklausykite ištraukos iš pranašo Amoso knygos: ");
INSERT INTO litb_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","„Paskui, – sako Viešpats, – Aš sugrįšiu ir atnaujinsiu sutartį su Dovydu tam, ");
INSERT INTO litb_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","kad ir pagonys rastų Dievą, ir visi kiti, kurie Mano vardą mini. ");
INSERT INTO litb_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Taip sako Viešpats“, leisdamas nuo amžių tai pažinti. ");
INSERT INTO litb_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Aš manau, jog mes neturime reikalauti, kad pagonys, kurie atsigręžia į Dievą, laikytųsi žydų įstatymų, ");
INSERT INTO litb_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","bet mes privalome jiems įsakyti, kad jie atsisakytų nuo susiteršimo stabais, nuo paleistuvavimo, paskerstų gyvulių mėsos ir kraujo. ");
INSERT INTO litb_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Kiekviename mieste šeštadienį iš kartos į kartą žydų sinagogose šie dalykai buvo skelbiami.“ ");
INSERT INTO litb_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Tada apaštalai ir vyresnieji kartu su visa bažnyčia nutarė pasiųsti į Antiochiją iš savųjų išrinktus vyrus kartu su Pauliumi ir Barnabu, kad šie praneštų apie tokį sprendimą. Išrinktieji vyrai buvo dviejų bažnyčių vadovai – Judas (taip pat vadinamas Barsabu) ir Silas. ");
INSERT INTO litb_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Jie pasiėmė su savimi raštą: „Nuo apaštalų, vyresniųjų ir brolių Jeruzalėje – broliams pagonims Antiochijoje, Sirijoje ir Sicilijoje. Sveikiname! ");
INSERT INTO litb_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Mes suprantame, kad kai kurie tikintieji sujaudino jus ir sujaukė jūsų sielas, bet mes jiems tokių įgaliojimų nedavėme. ");
INSERT INTO litb_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Mums atrodo išmintinga, vieningai nusprendus, pasiųsti du oficialius atstovus su mylimaisiais Barnabu ir Pauliumi. ");
INSERT INTO litb_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Tie vyrai – ir Judas, ir Silas – rizikavo gyvybe dėl Jėzaus Kristaus. ");
INSERT INTO litb_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Jie jums praneš, ką mes nusprendėme šiuo klausimu. ");
INSERT INTO litb_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Šventajai Dvasiai ir mums pasirodė teisinga nebeužkrauti jums daugiau jokios naštos, išskyrus tai, kad ");
INSERT INTO litb_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","būtina susilaikyti nuo aukų stabams, nuo paskerstų gyvulių mėsos ir kraujo, ir nuo paleistuvystės. Jei taip darysite, bus gerai. Sudiev!“ ");
INSERT INTO litb_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Keturi pasiuntiniai tuojau iškeliavo į Antiochiją, kur jie sušaukė krikščionių bendruomenę ir įteikė jiems laišką. ");
INSERT INTO litb_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Kai jį perskaitė, visoje bažnyčioje kilo daug džiaugsmo. ");
INSERT INTO litb_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas ir Silas buvo talentingi oratoriai ir stiprino tikėjimą ilgais pamokslais. ");
INSERT INTO litb_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Pabuvę ten keletą dienų, Judas ir Silas parnešė į Jeruzalę sveikinimus ir linkėjimus tiems, kurie juos siuntė. ");
INSERT INTO litb_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","35","Paulius ir Barnabas pasiliko Antiochijoje padėti kitiems, kurie ten sakė pamokslus ir skelbė Dievo Žodį. ");
INSERT INTO litb_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Po kiek laiko Paulius patarė Barnabui grįžti atgal į Turkiją aplankyti miestų, kuriuose anksčiau buvo skelbę Viešpaties Žodį, ir pažiūrėti, kaip jiems sekasi. ");
INSERT INTO litb_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabas sutiko ir norėjo pasiimti kartu Joną, vadinamą Morkumi. ");
INSERT INTO litb_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Bet Pauliui tas sumanymas visai nepatiko, kadangi Jonas buvo juos palikęs Pamfilijoje. ");
INSERT INTO litb_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Barnabas ir Paulius labai nesutarė šiuo klausimu ir išsiskyrė. Barnabas, pasiėmęs Morkų, išplaukė į Kiprą. ");
INSERT INTO litb_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","41","Tuo tarpu Paulius, pasirinkęs Silą ir palaimintas tikinčiųjų, iškeliavo į Siriją stiprinti bažnyčių. ");
INSERT INTO litb_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pirmiausia Paulius ir Silas nukeliavo į Derbę, o po to į Listrą, kur jie sutiko Timotiejų. Jo motina buvo krikščionė žydė, o tėvas – graikas. ");
INSERT INTO litb_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Timotiejus turėjo gerą vardą Listroje ir Ikonijuje, ");
INSERT INTO litb_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","todėl Paulius paprašė jo būti kelionės palydovu. Paisydamas to krašto žydų papročių, jis apipjaustė Timotiejų, nes visi žinojo, kad šio tėvas graikas ir anksčiau to daryti neleido. ");
INSERT INTO litb_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Paskui jie keliavo iš miesto į miestą, garsindami pagonims skirtą apaštalų ir Jeruzalės vyresniųjų sprendimą. ");
INSERT INTO litb_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Taip bažnyčia kasdien tvirtėjo, didėjo tikinčiųjų skaičius. ");
INSERT INTO litb_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Toliau jie keliavo per Frygiją ir Galatiją, nes Šventoji Dvasia tuo metu draudė jiems vykti į turkų provinciją Azijoje. ");
INSERT INTO litb_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Keliaudami netoli Mysijos sienos, jie pasuko į šiaurę, į Bitinijos provinciją, bet ir vėl Jėzaus Dvasia juos sustabdė. ");
INSERT INTO litb_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Perėję Mysijos provinciją, jie nuėjo į Troados miestą. ");
INSERT INTO litb_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Tą naktį Paulius pamatė regėjimą: žmogus iš Makedonijos (Graikijoje) maldavo: „Ateik čia ir padėk mums.“ ");
INSERT INTO litb_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Buvo nutarta, kad mes vyksime į Makedoniją įsitikinę, jog Dievas mus pasiuntė skelbti jiems Evangeliją. ");
INSERT INTO litb_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Išplaukę iš Troados, leidomės tiesiog į Samotrakę ir rytojaus dieną į Neapolį. ");
INSERT INTO litb_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Pagaliau pasiekėme Filipus, romėnų kolonijos Makedonijos srities miestą, ir ten užtrukome kelias dienas. ");
INSERT INTO litb_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Šeštadienį mes nuėjome netoli už miesto prie upės, kur, mūsų supratimu, keletas žmonių buvo susirinkę maldai. Atvykusias moteris mes mokėme Rašto. ");
INSERT INTO litb_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Viena buvo Lidija, pardavėja iš Tiatyrų, prekiaujanti purpuro drabužiais. ");
INSERT INTO litb_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ji buvo pakrikštyta kartu su visais namiškiais ir prašė mūsų pabūti jos svečiais. „Jei jūs nusprendėte, kad aš įtikėjau Viešpatį, ateikite ir pasilikite mano namuose.“ Ji taip nuoširdžiai kalbėjo, kad mus privertė pasilikti. ");
INSERT INTO litb_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Vieną dieną, eidami į maldos vietą prie upės, mes sutikome demono apsėstą vergę mergaitę, kuri nuspėdavo ateitį. Spėdama ji uždirbdavo daug pinigų savo šeimininkams. ");
INSERT INTO litb_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ji sekė mums iš paskos, šaukdama: „Šitie vyrai yra Dievo tarnai. Jie atėjo mums pasakyti, kaip gauti nuodėmių atleidimą.“ ");
INSERT INTO litb_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Tai kartojosi kasdien, kol Paulius nebeapsikentęs atsigręžė ir prabilo į joje esantį demoną: „Jėzaus Kristaus vardu įsakau tau – iš jos išeik!“ Demonas tuojau pat paliko vergę. ");
INSERT INTO litb_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Sudužo jos šeimininkų viltys praturtėti. ");
INSERT INTO litb_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Jie sugriebė Paulių ir Silą ir nutempė į miesto prekyvietę pas teisėjus. ");
INSERT INTO litb_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","„Šitie žydai trukdo mūsų miestui, – jie šaukė. – Jie moko žmones daryti tai, kas prieštarauja romėnų įstatymams.“ ");
INSERT INTO litb_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Minia bematant buvo nuteikta prieš Paulių ir Silą, o teisėjai liepė juos nurengti ir nuplakti rykštėmis. ");
INSERT INTO litb_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Rykštės čaižyte čaižė jų nuogas nugaras. Po to jie buvo įmesti į kalėjimą. Kalėjimo viršininkui grasino mirtimi, jeigu jie pabėgtų. ");
INSERT INTO litb_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Todėl šis negaišo ir įmetė juos į vidinį kalėjimo požemį, kojas įspraudęs į šiekštą. ");
INSERT INTO litb_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Apie vidurnaktį Paulius ir Silas meldėsi ir giedodami šlovino Viešpatį. ");
INSERT INTO litb_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Staiga kilo toks stiprus žemės drebėjimas, jog kalėjimo pamatai susvyravo. Atsivėrė visos durys, visiems kaliniams nukrito pančiai. ");
INSERT INTO litb_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Kalėjimo viršininkas nubudo ir pamatė plačiai atidarytas kalėjimo duris. Pamanęs, jog visi kaliniai pabėgo, išsitraukė kalaviją ir norėjo nusižudyti. ");
INSERT INTO litb_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Bet Paulius sušuko jam: „Nedaryk to! Mes visi esame čia!“ ");
INSERT INTO litb_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Drebėdamas iš baimės, kalėjimo viršininkas pasiprašė šviesos ir, nubėgęs į kalėjimo požemį, puolė Pauliui ir Silui po kojų. ");
INSERT INTO litb_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Jis išvedė juos ir maldavo: „Ponai, ką turiu daryti, kad būčiau išgelbėtas?“ ");
INSERT INTO litb_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Jie atsakė: „Tikėk Viešpatį Jėzų, tai būsi išgelbėtas tu ir tavo namai“, ");
INSERT INTO litb_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Paskui jie skelbė Viešpaties Žodį jam ir jo namiškiams. ");
INSERT INTO litb_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Tą pačią valandą jis nuplovė jų žaizdas ir su visa šeima buvo pakrikštytas. ");
INSERT INTO litb_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Paskui nusivedė juos į savo namus ir pavaišino. Jis džiūgavo su namiškiais, kadangi dabar visi buvo įtikėję. ");
INSERT INTO litb_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Kitą rytą teisėjai pasiuntė policijos pareigūnus pranešti kalėjimo viršininkui, kad paleistų tuos žmones. ");
INSERT INTO litb_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Todėl kalėjimo viršininkas pasakė Pauliui, kad jie gali ramiai sau eiti. ");
INSERT INTO litb_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Bet Paulius atsakė: „Nieko panašaus! Jie viešai mus nuplakė be jokio teismo ir įmetė į kalėjimą. Mes esame Romos piliečiai! O štai dabar jie nori, kad mes išvyktume slapčia. To nebus! Tegul jie patys atvyksta ir išlaisvina mus!“ ");
INSERT INTO litb_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Policijos pareigūnai tai perdavė teisėjams, kurie labai išsigando, išgirdę, kad Paulius ir Silas yra Romos piliečiai. ");
INSERT INTO litb_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Atėję į kalėjimą, jie išlaisvino Paulių ir Silą prašydami, kad šie paliktų miestą. ");
INSERT INTO litb_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Paulius ir Silas tada užsuko į Lidijos namus, susitiko su tikinčiaisiais ir, išvykdami iš miesto, dar su jais kalbėjosi. ");
INSERT INTO litb_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Dabar jie keliavo per Amfipolio ir Apolonijos miestus ir atvyko į Tesaloniką, kur buvo žydų sinagoga. ");
INSERT INTO litb_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pagal savo įprotį Paulius užėjo ten ir tris šeštadienius iš eilės aiškino jiems Raštą. ");
INSERT INTO litb_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Jis atskleidė žmonėms pranašystes apie Mesijo kančias ir Jo prisikėlimą, įrodinėjo, kad Jėzus yra Mesijas. ");
INSERT INTO litb_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Daug pamaldžių graikų, taip pat nemažai žymių moterų įtikėjo Viešpatį. ");
INSERT INTO litb_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Bet žydų vadovai pavyduliavo. Tai paskatino kai kuriuos nevykėlius jaunuolius gatvėse sukurstyti minią ir pradėti riaušes. Jie užpuolė Jasono namus, norėdami suimti Paulių ir Silą bei pristatyti miesto tarybai, kad nubaustų. ");
INSERT INTO litb_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ten jų neradę, jie ištempė Jasoną bei keletą tikinčiųjų laukan ir prievarta nuvedė į tarybą. „Paulius ir Silas apvertė visą pasaulį aukštyn kojomis, o nūnai jie drumsčia ramybę mūsų mieste, – šaukė jie. – ");
INSERT INTO litb_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","O Jasonas priglaudė juos savo namuose. Visi šitie kalti dėl išdavystės, nes jie skelbia karaliumi Jėzų, o ne Cezarį.“ ");
INSERT INTO litb_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Miesto žmonės, kaip ir teisėjai, suklaidinti tų gandų, ");
INSERT INTO litb_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","paleido juos tik gavę įkaitus. ");
INSERT INTO litb_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Tą naktį krikščionys išlydėjo Paulių ir Silą į Berėją, kur, kaip paprastai, jie, užėję į sinagogą, skelbė Dievo Žodį. ");
INSERT INTO litb_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Berėjos žmonės buvo atviresni už tesalonikiečius ir mielai jų klausė. Jie kasdien tyrinėjo Raštą, atidžiai tikrindami Pauliaus ir Silo teiginius. ");
INSERT INTO litb_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Taip daugelis įtikėjo, o iš jų nemažai ir kilmingų moterų bei vyrų. ");
INSERT INTO litb_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Bet kai Tesalonikos žydai sužinojo, kad Paulius jau Berėjoje skelbia Dievo Žodį, atskubėjo čionai ir kurstė žmones. ");
INSERT INTO litb_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Tikintieji skubiai išsiuntė Paulių prie jūros, o Silas ir Timotiejus pasiliko tenai. ");
INSERT INTO litb_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Lydėjusieji Paulių keliavo su juo į Atėnus, o po to grįžo į Berėją pranešti Silui ir Timotiejui, kad kuo greičiau vyktų pas jį. ");
INSERT INTO litb_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Kol Paulius laukė jų Atėnuose, jis netvėrė apmaudu, matydamas pilną stabų miestą. ");
INSERT INTO litb_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Jis ėjo į sinagogą tartis su žydais ir dievobaimingais pagonimis, kasdien kalbėdavosi su atėjusiais į miesto aikštę. ");
INSERT INTO litb_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Jis ginčijosi su kai kuriais epikūrininkais ir stoikų filosofais. Jam pasakojant apie Jėzų ir Jo prisikėlimą, vieni sakė, kad jis – fantazuotojas. Kiti tvirtino, jog jis perša svetimą mokslą. ");
INSERT INTO litb_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Jie pakvietė jį į susirinkimą Areopage: „Ateik papasakoti mums daugiau apie šią naują religiją. ");
INSERT INTO litb_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Tu pasakoji mums stulbinančius dalykus. Mes norėtume apie tai išgirsti daugiau.“ ");
INSERT INTO litb_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Aš privalau paaiškinti, kad visi atėniečiai, taip pat, kaip ir jų svečiai, temoka leisti laiką, aptarinėdami naujas idėjas!) ");
INSERT INTO litb_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Tada Paulius, atsistojęs Areopago viduryje, prabilo: „Atėniečiai, man rodos, kad jūs labai dievobaimingi. ");
INSERT INTO litb_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Vaikščiodamas ir apžiūrinėdamas jūsų altorius, aš radau vieną užrašą: „Nežinomam dievui!“ Jūs garbinate Jo nepažindami. Kaip aš noriu jums apie Jį papasakoti! ");
INSERT INTO litb_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Jis sukūrė pasaulį ir visa, kas tik jame yra. Kadangi Jis yra dangaus ir žemės Viešpats, tai negyvena žmogaus rankomis sukurtose šventyklose. ");
INSERT INTO litb_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Žmogaus rankos čia negali padėti, nes Jam nieko netrūksta. Jis Pats visiems duoda gyvybę, alsavimą ir tenkina visus mūsų poreikius. ");
INSERT INTO litb_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Visus pasaulio žmones Jis sukūrė iš Adomo ir išsklaidė tautas po žemę. Jis iš anksto numatė kiekvieno iš mūsų kilimo ir nuopuolio laiką ir nustatė universalias ribas. ");
INSERT INTO litb_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Visa tai turi skatinti žmones ieškoti Dievo. Galbūt nujausdami tą kelią dievop, pagaliau Jį atrastų, nors Dievas yra netoli kiekvieno iš mūsų. ");
INSERT INTO litb_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Jame mes gyvename, judame ir esame! Kaip sako vienas jūsų poetas: „Mes esame Dievo vaikai.“ ");
INSERT INTO litb_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Jei taip, mes neturime galvoti apie Dievą, kaip apie dievybę, panašią į žmonių sukurtą stabą iš aukso, sidabro ar iškaltą iš akmens. ");
INSERT INTO litb_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Dievas nesmerkė šitų dalykų praeityje, bet dabar Jis skelbia, kad visi atsisakytų stabų ir tik Jį vieną garbintų. ");
INSERT INTO litb_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Jis nustatė dieną, kada teisingai teis pasaulį per Žmogų, kurį Jis nurodė ir paskyrė, prikeldamas Jį iš numirusių.“ ");
INSERT INTO litb_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Išgirdę Paulių kalbant apie prisikėlimą iš numirusių, vieni ėmė juoktis, o kiti sakė: „Mes norime išgirsti apie tai vėliau.“ ");
INSERT INTO litb_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Tuo baigėsi Pauliaus pokalbis su jais, ");
INSERT INTO litb_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","bet kai kurie žmonės stojo į jo pusę ir priėmė tikėjimą. Tarp jų buvo Dionizas, miesto tarybos narys, moteris, vardu Damaridė ir kiti. ");
INSERT INTO litb_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Po to Paulius paliko Atėnus ir nuvyko į Korintą, ");
INSERT INTO litb_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Čia jis susipažino su žydu Akvilu, gimusiu Ponte, kuris neseniai buvo grįžęs iš Italijos su žmona Priskile, nes buvo išėjęs Klaudijaus Cezario įsakymas iškraustyti visus žydus iš Romos. ");
INSERT INTO litb_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Paulius gyveno ir darbavosi su jais, nes ir jie vertėsi palapinių audimu. ");
INSERT INTO litb_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Kiekvieną šeštadienį Paulius sakė pamokslus sinagogoje, stengdamasis įtikinti žydus ir graikus. ");
INSERT INTO litb_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Atvykus iš Makedonijos Silui ir Timotiejui, Paulius atsidėjo vien tik mokymui, tvirtindamas žydams, kad Jėzus yra Mesijas. ");
INSERT INTO litb_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Bet žydai nesiliovė prieštarauti ir burnoti prieš Dievą. Jie įžeidinėdavo Jėzų. Paulius nusipurtė nuo rūbų dulkes ir pasakė: „Tesilieja jūsų kraujas ant jūsų galvų. Aš nekaltas ir nuo šiol mokysiu pagonis.“ ");
INSERT INTO litb_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Po to jis persikėlė į Tito Justo, dievobaimingo pagonio, namus. Titas Justas šlovino Dievą, o jo namai buvo šalia sinagogos. ");
INSERT INTO litb_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Tuo tarpu sinagogos vyresnysis Krispas ir jo namiškiai įtikėjo Viešpačiu ir buvo pakrikštyti, kaip ir daugelis kitų Korinte. ");
INSERT INTO litb_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Vieną naktį Viešpats regėjime prabilo į Paulių: „Nebijok! Kalbėk! Netylėk! ");
INSERT INTO litb_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Aš esu su tavimi ir niekas negali tau pakenkti. Daug žmonių šiame mieste priklauso Man.“ ");
INSERT INTO litb_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Taigi Paulius dar gyveno ten pusantrų metų, mokydamas Dievo tiesų. ");
INSERT INTO litb_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Galionui tapus Achajos prokonsulu, žydai visi kaip vienas sukilo prieš Paulių ir nutempė jį į teismą. ");
INSERT INTO litb_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Jie kaltino Paulių už žmonių įkalbinėjimą garbinti Dievą prieštaraujančiais romėnų įstatymui būdais. ");
INSERT INTO litb_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pauliui ėmus gintis, Galionas pasisuko į jo kaltintojus ir pasakė: „Klausykite, žydai, jei tai būtų nusikaltimas, aš būčiau priverstas jūsų paklausyti, ");
INSERT INTO litb_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","bet kadangi tai ginčas dėl mokymo, vardų bei kvailų žydų įstatymų, spręskite patys. Manęs tai nedomina ir aš apie tuos dalykus nekalbu.“ ");
INSERT INTO litb_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Galionas išvarė juos iš teismo. ");
INSERT INTO litb_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Tada minia čiupo Sosteną, naują sinagogos vadovą, ir jį sumušė, bet Galionas į tai nekreipė dėmesio. ");
INSERT INTO litb_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paulius pasiliko mieste dar keletą dienų. Paskui, atsisveikinęs su krikščionimis, kartu su Priskile ir Akvilu iškeliavo į Siriją. Kenchrėjoje Paulius pagal žydų paprotį nusiskuto galvą, nes buvo padaręs įžadą. ");
INSERT INTO litb_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Atvykęs į Efezo uostą, jis mus paliko laive, o pats nuėjo į sinagogą pasikalbėti su žydais. ");
INSERT INTO litb_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Jie prašė jį pasilikti dar kelias dienas, bet jis jautė, kad negali užtrukti. ");
INSERT INTO litb_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","„Per šventes aš būtinai turiu būti Jeruzalėje“, – pasakė jis, pažadėjęs grįžti į Efezą vėliau, jei Dievas leis. Todėl jis vėl iškeliavo. ");
INSERT INTO litb_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Paulius sustojo Cezarėjos uoste. Aplankęs Jeruzalės bažnyčią, išplaukė į Antiochiją. ");
INSERT INTO litb_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Po kiek laiko jis vėl išvyko į Turkiją per Galatiją ir Frygiją, lankydamas visus tikinčiuosius, drąsindamas juos ir padėdamas stiprinti tikėjimą. ");
INSERT INTO litb_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Tuo tarpu vienas žydas, vardu Apolas, puikus Raštų mokytojas ir skelbėjas, ką tik atvyko į Efezą iš Egipto Aleksandrijos. ");
INSERT INTO litb_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Egipte jam kažkas papasakojo, ką Jonas Krikštytojas kalbėjo apie Jėzų, bet tai buvo labai nedaug. Jis niekada nebuvo girdėjęs istorijos pabaigos. ");
INSERT INTO litb_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Jis drąsiai ir energingai ėmė skelbti sinagogoje: „Ateina Mesijas! Ruoškitės Jį priimti!“ Priskilė ir Akvilas išgirdo jį šitaip kalbant. Tai buvo nepaprastas pamokslas. Po to jie susitiko su juo ir paaiškino, kas atsitiko Jėzui nuo Jono laikų ir ką visa tai reiškia. ");
INSERT INTO litb_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Kai Apolas sumanė vykti į Graikiją, tikintieji jį padrąsino. Jie parašė savo draugams tikintiesiems, prašydami gražiai priimti Apolą. Dievas puikiai įprasmino jo atvykimą į Graikiją, stiprindamas bažnyčią, ");
INSERT INTO litb_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","nes Apolas viešuose ginčuose sugebėjo atmesti visus žydų argumentus, Raštu įrodydamas Jėzų esant Mesiją. ");
INSERT INTO litb_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolui gyvenant Korinte, Paulius apkeliavo Turkiją ir atvyko į Efezą. Ten jis užtiko kelis mokinius ir paklausė: ");
INSERT INTO litb_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","„Ar, tapę tikinčiaisiais, gavote Šventąją Dvasią“? „Ne, – jie atsakė. – Mes nežinome, ką jūs turite mintyje, sakydamas „Šventąją Dvasią.“ ");
INSERT INTO litb_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","„Tada kokį krikštą jūs esate priėmę?“ – jis paklausė. „Jono krikštą“, – atsakė šie. ");
INSERT INTO litb_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Tada Paulius jiems paaiškino, kad Jono krikštas reiškė troškimą atsižadėti nuodėmės ir atsigręžti į Dievą ir kad tie, kurie gavo jo krikštą, turi įtikėti Jėzų, kuris, kaip sakė Jonas, vėliau ateisiąs. ");
INSERT INTO litb_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Kai tik jie tai išgirdo, buvo pakrikštyti Viešpaties Jėzaus vardu. ");
INSERT INTO litb_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Tada, kai Paulius dėjo ant jų galvų rankas, juos aplankė Šventoji Dvasia. Jie ėmė kalbėti skirtingomis kalbomis ir pranašauti. ");
INSERT INTO litb_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Iš viso jų buvo bene dvylika vyrų. ");
INSERT INTO litb_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Paskui Paulius nuėjo į sinagogą ir tris mėnesius kas šeštadienį kantriai pasakojo, kuo jis tiki ir kodėl ragina visus įtikėti Jėzų. ");
INSERT INTO litb_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Kai kurie atmetė jo žodžius ir viešai kalbėjo prieš Kristų. Todėl jis pasitraukė, atsisakydamas vėl juos mokyti. Tikinčiuosius jis pradėjo mokyti Tirano pamokslų salėje. ");
INSERT INTO litb_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Tai truko dvejus metus, ir visi Azijos gyventojai – tiek žydai, tiek ir graikai – išgirdo Viešpaties Žodį. ");
INSERT INTO litb_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Viešpats suteikė Pauliui galią daryti nepaprastus stebuklus. ");
INSERT INTO litb_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Kai ant ligonių būdavo uždedamos skepetaitės ar kūną jo lietę drabužiai, jie pasveikdavo, nuo jų pasitraukdavo piktosios dvasios. ");
INSERT INTO litb_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Keliaujančių žydų būrys, einančių iš miesto į miestą, išvarinėdavo piktąsias dvasias ir sumanė pasinaudoti Viešpaties Jėzaus vardu. Jie sugalvojo tokius burtažodžius: „Maldaujame Jėzaus Kristaus vardu, kurį skelbia Paulius – išeik!“ ");
INSERT INTO litb_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Taip darė septyni žydų kunigo Skėvo sūnūs. ");
INSERT INTO litb_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Kai jie tai bandė su piktosios dvasios apsėstu žmogumi, piktoji dvasia atšovė: „Pažįstu Jėzų, žinau Paulių, o jūs kas būsite?“ ");
INSERT INTO litb_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Apsėstasis puolė taip juos mušti, kad šie turėjo iš namų bėgti nuogi ir sunkiai sužeisti. ");
INSERT INTO litb_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Gandas apie tai, kas atsitiko, greitai pasklido po visą Efezą. Tai sužinojo visi žydai ir graikai. Miestą apėmė didelė baimė, o Viešpaties Jėzaus vardas buvo labai išaukštintas. ");
INSERT INTO litb_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","19","Daug tikinčiųjų, kurie užsiiminėjo juodąja magija, prisipažino, ką buvo padarę. Jie sunešė kerėjimų bei burtų knygas ir visų akyse sudegino. Kažkas suskaičiavo, kad knygų vertė lygi penkiasdešimčiai tūkstančių sidabro drachmų (tolygu 10 000 JAV dolerių). ");
INSERT INTO litb_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Tai rodo, kaip stipriai viso regiono žmones sujaudino Dievo Žodis. ");
INSERT INTO litb_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Vėliau Paulius, Šventosios Dvasios skatinamas, grįždamas į Jeruzalę nusprendė aplankyti Graikiją. „Po to, – sakė jis, – aš turiu vykti į Romą.“ ");
INSERT INTO litb_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Pirma savęs jis pasiuntė du padėjėjus, Timotiejų ir Brastą, o pats dar užtruko Turkijoje. ");
INSERT INTO litb_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Apie tą laiką Efeze dėl krikščionių kilo didelis sąmyšis. ");
INSERT INTO litb_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Vienas sidabrakalys, vardu Demetrijas, samdydavosi daug amatininkų gaminti sidabrinėms graikų deivės Artemidės šventovės miniatiūroms. ");
INSERT INTO litb_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Jis sukvietė savo ir kitus vyrus, kurie buvo susiję su tuo amatu, ir kreipėsi į juos: „Vyrai, šis užsiėmimas yra jūsų pelno šaltinis. ");
INSERT INTO litb_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Kaip jūs matėte ir girdėjote, tas Paulius įtikino daugelį žmonių, kad rankomis padaryti dievai – tai ne dievai. Dėl to mūsų darbų vertė mažėja. Tai aiškiai matyti ne tik čia, Efeze, bet ir visoje apylinkėje! ");
INSERT INTO litb_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Žinoma, aš kalbu ne tik apie mūsų amato situaciją ir pelno sumažėjimą, bet ir apie grėsmę didžiajai deivės Artemidės šventyklai netekti savo įtakos. Ši galinga valdovė Artemidė, kuri buvo gerbiama ne tik šioje Turkijos dalyje, bet ir visame pasaulyje, bus užmiršta!“ ");
INSERT INTO litb_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Tada jie dar labiau supyko ir ėmė šaukti: „Didi efeziečių Artemidė!“ ");
INSERT INTO litb_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Susirinko minia ir greitai miestą apėmė sąmyšis. Visi skubėjo į amfiteatrą, pagriebė Pauliaus bendrakeleivius Gajų ir Aristarchą. ");
INSERT INTO litb_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paulius norėjo įsimaišyti į minią, bet mokiniai jo neleido. ");
INSERT INTO litb_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Keletas Pauliaus bičiulių, romėnų provincijos pareigūnų, taip pat pasiuntė jam žinią, prašydami nerizikuoti gyvybe ir neiti į teatrą. ");
INSERT INTO litb_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Viduje žmonės reikalavo nežinia ko, buvo didžiulė betvarkė. Iš tiesų daugelis jų nežinojo, dėl ko atėję. ");
INSERT INTO litb_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Keletas žydų pastebėjo Aleksandrą ir ištempė jį į priekį. Jis rankos mostu parodė, kad minia nutiltų, ir bandė pasiaiškinti. ");
INSERT INTO litb_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Bet supratę, kad jis žydas, žmonės vėl ėmė šaukti. Dvi valandas nesiliovė šūksniai: „Didi yra efeziečių Artemidė! Didi efeziečių Artemidė!“ ");
INSERT INTO litb_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Pagaliau miesto meras įstengė juos nutildyti: „Efezo vyrai! – prabilo jis. – Visi žino, kad Efezas yra didžiosios Artemidės garbintojas. Jos statulėlė nukrito iš dangaus. ");
INSERT INTO litb_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Kadangi tai neginčijamas faktas, nusiraminkite ir nieko nedarykite neapgalvoję. ");
INSERT INTO litb_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Tačiau jūs atvedėte čia šituos vyrus, kurie nieko nepavogė iš jos šventyklos ir nepiktžodžiavo. ");
INSERT INTO litb_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Jei Demetrijas ir jo bendrininkai turi juos kuo apkaltinti, tai teismai posėdžiauja ir prokonsulai gali tuojau pat išnagrinėti kaltinimą. Tegul sau bylinėjasi. ");
INSERT INTO litb_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Jei bus nusiskundimų dėl kitų reikalų, jie gali būti išspręsti nuolatiniuose miesto tarybos susirinkimuose; ");
INSERT INTO litb_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","romėnų vyriausybė mus gali apkaltinti dėl šios dienos riaušių, nes jos kilo be jokių priežasčių. Jei Roma pareikalaus paaiškinimo, aš nežinosiu, ką atsakyti.“ ");
INSERT INTO litb_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Tada jie visi išsiskirstė. ");
INSERT INTO litb_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Kai viskas pasibaigė, Paulius atsisveikino su mokiniais ir išvyko į Graikiją. ");
INSERT INTO litb_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Pakeliui mokė visuose miestuose, sakė pamokslus. ");
INSERT INTO litb_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Graikijoje Paulius praleido tris mėnesius, ruošdamasis plaukti į Siriją. Supratęs, kad žydai sumanė jį nužudyti, nusprendė pirmiausia vykti šiaurėn, į Makedoniją. ");
INSERT INTO litb_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Keletas vyrų keliavo su juo į Turkiją. Paulių lydėjo berėjiečio Pyro sūnus Sopatras, Aristarchas ir Sekundas iš Tesalonikos, Gajus iš Derbės, Timotiejus bei Trofimas, kurie grįžo namo į Turkiją, ");
INSERT INTO litb_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","iškeliavo pirma mūsų ir laukė Troadoje. ");
INSERT INTO litb_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Kai tik baigėsi Velykų iškilmės, mes išplaukėme iš Filipų šiaurinėje Graikijoje ir po penkių dienų atvykome į Troadą Turkijoje. Ten mes užtrukome savaitę. ");
INSERT INTO litb_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Sekmadienį susirinkome į duonos laužymo ceremoniją. Paulius sakė pamokslą. Kadangi jis norėjo kitą dieną iškeliauti, kalbėjo iki vidurnakčio! ");
INSERT INTO litb_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Viršutiniame aukšte, kur mes susirinkome, buvo uždegta daugybė žibintų. ");
INSERT INTO litb_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Paulius kalbėjo, o vienas jaunas žmogus, vardu Eutichas, sėdėjęs ant palangės, giliai įmigo ir, krisdamas iš trečio aukšto, užsimušė. ");
INSERT INTO litb_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","12","Paulius nulipo žemyn, paėmė jį ant rankų ir tarė: „Nesirūpinkite – jis gyvas.“ Ir iš tiesų – jis buvo gyvas! Baimė ir džiaugsmas nuvilnijo per minią. Jie visi vėl užlipo į viršų ir kartu valgė Viešpaties vakarienę. Tada Paulius kalbėjo dar gana ilgai. Jau aušo, kai jis pagaliau juos paliko. ");
INSERT INTO litb_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Paulius keliavo į Aso žemę sausuma, o mes toliau keliavome laivu. ");
INSERT INTO litb_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Ten susitikome ir kartu plaukėme į Mitilėnę. ");
INSERT INTO litb_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Rytojaus dieną mes praplaukėme Samą, o dar po dienos atvykome į Miletą. ");
INSERT INTO litb_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Šį kartą Paulius nusprendė nesustoti Efeze, nes skubinosi, norėdamas Sekmines atšvęsti Jeruzalėje. ");
INSERT INTO litb_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Atplaukęs į Miletą, jis pasiuntė žinią Efezo bažnyčios vyresniesiems, kad atvyktų jo pasitikti prie laivo. ");
INSERT INTO litb_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Jiems atvykus, Paulius tarė: „Jūs žinote, vyrai, kad nuo tos dienos, kai tik atvykau į Turkiją, ");
INSERT INTO litb_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","aš nuolankiai, su ašaromis akyse tarnavau Viešpačiui. Žydai rezgė įvairias pinkles ir man teko patirti didelių pavojų. ");
INSERT INTO litb_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Aš niekada ir niekur nenutylėjau tiesos. ");
INSERT INTO litb_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Tiek žydams, tiek pagonims aš tvirtinau apie būtinumą atsižadėti nuodėmės, atsigręžti į Dievą ir įtikėti mūsų Viešpatį Jėzų Kristų. ");
INSERT INTO litb_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Ir štai aš keliauju į Jeruzalę Šventosios Dvasios vedamas. Aš nežinau, kas manęs laukia, ");
INSERT INTO litb_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","išskyrus tai, ką Šventoji Dvasia man kalbėjo kiekviename mieste, jog kalėjimas ir kančia dar ateityje. ");
INSERT INTO litb_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Bet nieko nevertas gyvenimas, jei jo nepanaudosiu atlikti darbams, kuriuos Viešpats man paskyrė. Mano misija yra skelbti gerąją naujieną apie nepaprastą Dievo gerumą ir meilę. ");
INSERT INTO litb_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Dabar aš žinau, kad jūs visi, su kuriais aš vaikščiojau skelbdamas Dievo karalystę, daugiau manęs nebematysite. ");
INSERT INTO litb_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Leiskite atvirai pasakyti, kad negalite man primesti nė vieno žmogaus kraujo. ");
INSERT INTO litb_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Nes aš nevengiau skelbti jiems Dievo Evangeliją. ");
INSERT INTO litb_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Todėl budėkite! Nepamirškite maitinti ir ganyti Viešpaties kaimenę. Tai Jo bažnyčia, atpirkta krauju, nes Šventoji Dvasia jums pavedė ją prižiūrėti. ");
INSERT INTO litb_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Gana gerai žinau, kad man pasitraukus iš jūsų tarpo, pasirodys netikri mokytojai ir, kaip plėšrūs vilkai, nepagailės avelių. ");
INSERT INTO litb_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Kai kurie jūs patys iškreipsite tiesą, kad patrauktute į save žmones. ");
INSERT INTO litb_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Saugokitės! Prisiminkite tuos trejis metus, kai aš buvau su jumis ir nuolat jumis rūpinausi. Aš liejau dėl jūsų ašaras. ");
INSERT INTO litb_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Dabar aš pavedu jus Dievui, Jo rūpesčiui ir Jo malonei, kuri turi galią padaryti žmones tikinčiais ir atiduoti Jo išrinktiesiems visą palikimą. ");
INSERT INTO litb_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Aš niekada netroškau nei pinigų, nei puikių drabužių. ");
INSERT INTO litb_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Jūs žinote, kad dirbau pagal išgales, norėdamas pragyventi ir net tenkinti poreikius tų, kurie buvo su manimi. ");
INSERT INTO litb_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Padėdamas vargšams, aš buvau jums nuolatinis pavyzdys, nes primindavau Viešpaties Jėzaus žodžius: „Didesnė laimė duoti negu imti.“ ");
INSERT INTO litb_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Pabaigęs kalbėti, jis atsiklaupė ir kartu su visais pasimeldė. ");
INSERT INTO litb_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Atsisveikino jie balsu raudodami ir glebėsčiuodami jį, ");
INSERT INTO litb_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","liūdėdami, kad daugiau niekada jo nebematysią. Po to jie palydėjo jį į laivą. ");
INSERT INTO litb_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Atsisveikinę su Efezo vyresniaisiais, mes plaukėme tiesiai į Kosą. Rytojaus dieną mes pasiekėme Rodą, o tada – į Patarą. ");
INSERT INTO litb_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Ten mes sėdome į laivą, plaukiantį į Fenikiją, Sirijos provinciją. ");
INSERT INTO litb_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Mes pastebėjome Kipro salą, praplaukdami palikome ją kairėje ir išlipome Tyro uoste Sirijoje, kur buvo iškrautas laivas. ");
INSERT INTO litb_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Mes išlipome į krantą, ir, suradę vietinius tikinčiuosius, praleidome su jais savaitę. Tie mokiniai įspėjo Paulių. Per juos pranašavo Šventoji Dvasia ir patarė nevykti į Jeruzalę. ");
INSERT INTO litb_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Savaitės pabaigoje, kai mes grįžome į laivą, jie visi su žmonomis ir vaikais palydėjo mus į pajūrį, kur meldėmės ir atsisveikinome. ");
INSERT INTO litb_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Po to mes sulipome į laivą, o jie sugrįžo namo. ");
INSERT INTO litb_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Keliaudami toliau, iš Tyro atplaukėme į Ptolemaidę. Ten pasveikinome tikinčiuosius, bet pasilikome pas juos tik vieną dieną. ");
INSERT INTO litb_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Paskui atvykome į Cezarėją ir apsistojome evangelisto Pilypo, vieno iš septynių pirmųjų diakonų, namuose. ");
INSERT INTO litb_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Jis turėjo keturias netekėjusias dukteris, kurios galėjo pranašauti. ");
INSERT INTO litb_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Po kelių dienų iš Judėjos atvyko vyras, vardu Agabas. ");
INSERT INTO litb_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Jis taip pat turėjo pranašavimo dovaną. Jis paėmė Pauliaus juostą ir, susirišęs ja rankas, pasakė: „Šventoji Dvasia kalba: „Taip Jeruzalėje bus surištas šios juostos šeimininkas ir atiduotas romėnams.“ ");
INSERT INTO litb_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Tai išgirdę, ir mes, ir vietiniai gyventojai, ir jo bendrakeleiviai maldavome Paulių neiti į Jeruzalę. ");
INSERT INTO litb_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Bet jis atsakė: „Kodėl raudate ir draskote man širdį? Aš pasirengęs Jeruzalėje ne tik būti įkalintas, bet ir numirti dėl Viešpaties Jėzaus.“ ");
INSERT INTO litb_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Paaiškėjus, kad jo neperkalbėsime, tarėme: „Tebūnie Viešpaties valia!“ ");
INSERT INTO litb_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Netrukus, susidėję daiktus, mes iškeliavome į Jeruzalę. ");
INSERT INTO litb_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Mus lydėjo mokiniai iš Cezarėjos. Atvykę svečiavomės vieno iš pirmųjų tikinčiųjų kipriečio Mnasono namuose. ");
INSERT INTO litb_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Mus nuoširdžiai sutiko visi Jeruzalės tikintieji. ");
INSERT INTO litb_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Rytojaus dieną Paulius kartu su mumis nuėjo pas Jokūbą ir Jeruzalės bažnyčios vyresniuosius. ");
INSERT INTO litb_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Mums pasisveikinus, Paulius smulkiai nupasakojo daugelį dalykų, kuriuos Dievas per jį buvo padaręs pagonių kraštuose. ");
INSERT INTO litb_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Jie šlovino Dievą ir sakė: „Matai, broli, daug žydų taip pat atsivertė, bet jie atkakliai reikalauja, kad tikintieji žydai tęstų žydų tradicijas ir papročius. ");
INSERT INTO litb_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Čia, Jeruzalėje, žydų krikščionims buvo prikalbėta, kad tu nusistatęs prieš Mozės įstatymus ir draudi jų vaikus apipjaustyti. ");
INSERT INTO litb_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Ką dabar daryti? Jie vis tiek išgirs, kad esi atvykęs.“ ");
INSERT INTO litb_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Mes patariame štai ką: „Čia yra keturi vyrai, kurie ruošiasi nusiskusti galvas ir duoti įžadus, ");
INSERT INTO litb_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Eik su jais į šventyklą ir taip pat nusiskusk galvą. Užmokėk už juos, kad jie galėtų nusiskusti galvas. Tuomet visi matys, kad tu pritari šiam papročiui, kaip ir žydų krikščionys, kad jūs patys laikotės žydų įstatymų ir kad jūsų nuomonė šiais klausimais sutampa su mūsų. ");
INSERT INTO litb_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Tikintiesiems, kurie buvo pagonys, mes iš viso neliepiame laikytis šių žydų įstatymų, išskyrus tuos, kurie draudžia valgyti stabams aukojamą maistą, pasmaugtų gyvulių mėsą bei kraują, ir paleistuvauti.“ ");
INSERT INTO litb_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Ir todėl Paulius, pasinaudodamas jų patarimu, rytojaus dieną nuėjo su vyrais į šventyklą atlikti ceremoniją. Tuo būdu jis paskelbė įžadą kartu su kitais aukoti auką po septynių dienų. ");
INSERT INTO litb_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Praėjus beveik septynioms dienoms, keli žydai iš Turkijos pamatė Paulių šventykloje ir sukurstė prieš jį minią. Jie nutvėrė jį ");
INSERT INTO litb_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","šaukdami: „Izraelitai, gelbėkit! Štai žmogus, kuris eina prieš tautą ir visiems liepia nesilaikyti žydų įstatymų. Jis net kalba prieš šventyklą ir išniekina ją, atvesdamas ten pagonis!“ ");
INSERT INTO litb_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Mat tą dieną kiek anksčiau jie buvo matę jį su Trofimu iš Efezo ir manė, jog Paulius bus atsivedęs jį į šventyklą. ");
INSERT INTO litb_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Dėl šitų kaltinimų sujudo visi miesto žmonės ir kilo didelė sumaištis. Paulius buvo ištemptas iš šventyklos, ir vartai tuojau buvo uždaryti. ");
INSERT INTO litb_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Kai jie ketino jį užmušti, romėnų kareivių kuopos viršininkui, tribūnui, buvo duota žinia, kad visoje Jeruzalėje neramu. ");
INSERT INTO litb_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Jis su kareiviais ir šimtininkais atskubėjo prie minios. Minia, pamačiusi atvykstančius kareivius, liovėsi mušti Paulių. ");
INSERT INTO litb_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Tribūnas suėmė jį ir liepė surišti dviem grandinėmis. Tada paklausė minios, kas jis esąs ir ką padaręs. ");
INSERT INTO litb_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Vieni šaukė viena, kiti – visai kita. Triukšme ir sumaištyje negalėdamas nieko sužinoti, jis įsakė nuvesti Paulių į kareivių stovyklą. ");
INSERT INTO litb_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","36","Kareiviams atėjus prie laiptų, minia taip įšėlo, jog šie turėjo Paulių nešte nešti, kad jo nenužudytų besigrūdantys iš paskos žmonės, šaukdami ir reikalaudami jo mirties. ");
INSERT INTO litb_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","38","Kai Paulius turėjo būti vedamas į stovyklą, jis paklausė tribūno: „Gal galiu tau šį tą pasakyti?“ „Moki graikiškai? – nustebęs paklausė tribūnas. – Tai tu ne tas egiptietis, kuris prieš kelis metus sukėlė sąmyšį ir išvedė į dykumą keturis tūkstančius galvažudžių?“ ");
INSERT INTO litb_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","„Ne, – atsakė Paulius. – Aš esu žydas ir ne iš kokio menko miestelio, bet iš Tarso Kilikijoje. Aš prašau leidimo kalbėti su šiais žmonėmis.“ ");
INSERT INTO litb_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Tribūnas sutiko. Todėl Paulius atsistojo ant laiptų ir pamojo miniai, kad nutiltų. Greitai minia visai nurimo, ir jis prabilo hebrajų kalba: ");
INSERT INTO litb_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","„Broliai ir tėvai, pasiklausykite mano pasiteisinimo.“ ");
INSERT INTO litb_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Išgirdusi jį kalbant hebrajiškai, minia dar labiau susikaupė. ");
INSERT INTO litb_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","„Aš esu žydas, gimęs Tarse, Kilikijoje, bet išauklėtas Jeruzalėje vadovaujant Gamalieliui, prie kurio kojų aš išmokau rūpestingai laikytis žydų įstatymų ir papročių. Aš stengiausi šlovinti Dievą savo darbu, kaip ir jūs visi nūnai darote. ");
INSERT INTO litb_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ir aš persekiojau krikščionis iki mirties, surišdamas ir įmesdamas į kalėjimą vyrus ir moteris. ");
INSERT INTO litb_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Kad taip yra, galėtų paliudyti vyriausiasis kunigas ar bet kuris kitas tarybos narys, nes aš prašiau jų laiškų Damasko žydų vadovams su nuorodymais, leidžiančiais visus krikščionis supančiotus atgabenti į Jeruzalę, kad jie būtų nubausti. ");
INSERT INTO litb_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Man keliaujant ir artinantis prie Damasko, apie vidurdienį staiga mane apšvietė labai stipri šviesa. ");
INSERT INTO litb_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Aš kritau ant žemės ir išgirdau balsą: „Sauliau, Sauliau, kam Mane persekioji!?“ ");
INSERT INTO litb_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","„Kas su manimi kalba?“ – paklausiau aš. Jis atsakė: „Aš esu Jėzus iš Nazareto, kurį tu persekioji.“ ");
INSERT INTO litb_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Su manimi buvę vyrai matė šviesą, bet nesuprato kalbos. ");
INSERT INTO litb_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Aš tariau: „Ką man daryti, Viešpatie?“ Viešpats man tarė: „Kelkis ir eik į Damaską, o ten tau bus pasakyta visa, kas tavęs laukia ateityje!“ ");
INSERT INTO litb_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Buvau apakintas stiprios šviesos ir tik bendrakeleivių už rankos vedamas, aš pasiekiau Damaską. ");
INSERT INTO litb_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Toksai Ananijas, pamaldusir įstatymui ištikimas žmogus, giriamas visų Damasko žydų, ");
INSERT INTO litb_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","atėjęs atsistojo šalia manęs ir pasakė: „Broli Sauliau, praregėk!“ Ir tą pačią akimirką aš jį pamačiau. ");
INSERT INTO litb_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Tada jis kalbėjo: „Mūsų protėvių Dievas pasirinko tave, kad pažintumei Jo valią, išvystumei Mesiją ir girdėtumei Jį kalbantį. ");
INSERT INTO litb_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Tu turėsi visur paliudyti, ką esi matęs ir girdėjęs. ");
INSERT INTO litb_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Tai ko dabar lauki? Eik ir priimk krikštą, nusiplauk nuodėmes, šaukdamasis Viešpaties!“ ");
INSERT INTO litb_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","18","Kai jau grįžęs į Jeruzalę vieną dieną meldžiausi šventykloje, regėjimo ekstazėje Dievas man sakė: „Skubėk iš Jeruzalės, nes čia žmonės nepriims tavo liudijimo apie Mane.“ ");
INSERT INTO litb_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Aš įrodinėjau: „Bet Viešpatie, jie žino, kad aš mesdavau į kalėjimą ir mušdavau kiekvienoje sinagogoje tuos, kurie tikėjo Tavimi. ");
INSERT INTO litb_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Kada buvo nužudytas Tavo liudytojas Steponas, aš stovėjau ten kartu su jais pritardamas ir saugojau jų drabužius, kuriuos jie nusirengė, mėtydami į jį akmenimis.“ ");
INSERT INTO litb_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Bet Dievas man tarė: „Keliauk iš Jeruzalės, nes išsiųsiu tave toli, pas pagonis.“ ");
INSERT INTO litb_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Iki tol minia jo klausėsi, paskui visi kartu pratrūko: „Šalin tą tipą! Nušluoti nuo žemės jį. Užmušti jį! Jam nevalia gyventi!“ ");
INSERT INTO litb_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Jie rėkė, mėtė į orą drabužius ir svaidė saujomis smėlį. ");
INSERT INTO litb_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Taip tribūnas įvedė jį į vidų ir liepė nuplakti, kad prisipažintų esąs kaltas. Jis norėjo sužinoti, kodėl minia prieš jį taip įsiuto. ");
INSERT INTO litb_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Kai Paulių, norėdami nuplakti, pririšo diržais, jis kreipėsi į čia stovėjusį šimtininką: „Ar jums valia plakti Romos pilietį, ir dar nenuteistą?“ ");
INSERT INTO litb_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Šimtininkas priėjo prie tribūno ir pareiškė: „Ką jūs darote? Šis žmogus yra Romos pilietis!“ ");
INSERT INTO litb_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Tuomet tribūnas priėjo prie Pauliaus ir paklausė: „Pasakyk man, ar tu Romos pilietis?“ „Taip, žinoma.“ ");
INSERT INTO litb_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","„Ir aš esu, – suniurnėjo tribūnas. – Aš šitą pilietybę įsigijau už didelius pinigus!“ „O aš turiu nuo gimimo!“ ");
INSERT INTO litb_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Bematant pranyko kareiviai, kurie stovėjo pasiruošę jį nučaižyti, kai tik išgirdo, kad Paulius – Romos pilietis. Nusigando ir tribūnas, nes buvo įsakęs jį surišti ir nuplakdinti. ");
INSERT INTO litb_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Rytojaus dieną tribūnas nuėmė jam grandines ir įsakė sušaukti aukštuosius kunigus ir žydų tarybą. Pastatęs prieš juos Paulių, stengėsi sužinoti, kas atsitiko. ");
INSERT INTO litb_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Atidžiai ir įdėmiai stebėdamas tarybą, Paulius prabilo: „Broliai, aš visuomet gyvenau visiškai švaria sąžine Dievo akivaizdoje!“ ");
INSERT INTO litb_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Tuojau vyriausias kunigas Ananijas įsakė šalia Pauliaus stovintiems smogti jam per burną. ");
INSERT INTO litb_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Paulius jam tarė: „Tave Dievas muš, tu, netašytas stuobry! Koks tu teisėjas, kad pats laužai įstatymą liepdamas mane mušti?“ ");
INSERT INTO litb_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Stovėję šalia Pauliaus jį įspėjo: „Tu taip kalbi su vyriausiuoju Dievo kunigu?“ ");
INSERT INTO litb_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","„Aš nežinojau, kad jis – vyriausiasis kunigas, Rašte pasakyta: „Niekada blogai nekalbėk apie bet kurį iš savo vadovų.“ ");
INSERT INTO litb_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Po to Paulius kažką sugalvojo. Viena tarybos dalis buvo sadukiejai, kita dalis – fariziejai. Todėl jis sušuko: „Broliai, aš fariziejus kaip ir visi mano protėviai. Ir jūs mane teisiate, kadangi tikiu mirusiųjų prisikėlimu!“ ");
INSERT INTO litb_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Tada taryba pasidalijo į dvi grupes: fariziejai buvo nusiteikę prieš sadukiejus, ");
INSERT INTO litb_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","kadangi sadukiejai neigė prisikėlimą, angelus, net amžiną dvasios buvimą, o fariziejai visus dalykus pripažino. ");
INSERT INTO litb_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Kilo didelis klegesys. Keli žydų vadovai pašoko ginčytis, kad Paulius teisus. „Mes nerandame nieko blogo jame, – jie šaukė. – Greičiausiai jam kalbėjo dvasia ar angelas kelyje į Damaską.“ ");
INSERT INTO litb_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Ginčams stiprėjant, Paulių tampė iš visų pusių, stumdydami į priekį ir atgal. Pagaliau tribūnas, bijodamas, kad jie nesudraskytų Pauliaus, įsakė nuvesti jį į kareivių stovyklą. ");
INSERT INTO litb_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Kitą naktį Pauliui pasirodė Viešpats ir tarė jam: „Nesijaudink, Pauliau! Kaip liudijai apie Mane žmonėms čia, Jeruzalėje, taip reikės tau liudyti ir Romoje.“ ");
INSERT INTO litb_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","13","Kitą rytą susirinko per keturiasdešimt žydų ir prisiekė, kad nei valgys, nei gers, kol nenužudys Pauliaus. ");
INSERT INTO litb_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Paskui nuėjo pas aukštuosius kunigus bei seniūnus ir papasakojo jiems, ką buvo nusprendę. ");
INSERT INTO litb_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","„Paprašykite tribūno, kad vėl atvestų Paulių į tarybą, – jie reikalavo. – Apsimeskite, kad dar norėtumėte duoti jam keletą klausimų. Mes užmušime jį kelyje.“ ");
INSERT INTO litb_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Bet Pauliaus sūnėnas sužinojo apie jų planą, atėjo į kareivines ir pranešė Pauliui. ");
INSERT INTO litb_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Paulius, pasivadinęs vieną šimtininką, paprašė: „Nuvesk šį jaunuolį pas tribūną. Jis turi kai ką svarbaus jam pasakyti.“ ");
INSERT INTO litb_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Taip šimtininkas ir padarė, paaiškindamas: „Kalinys Paulius pasikvietė mane ir paprašė atvesti pas tave šį jaunuolį, kuris nori tau kai ką pranešti.“ ");
INSERT INTO litb_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Tribūnas, paėmęs jį už rankos, pasivedėjo į šalį ir paklausė: „Apie ką turi man pranešti, jaunuoli?“ ");
INSERT INTO litb_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","„Rytoj žydai susitarė prašyti tave, kad nuvestum Paulių į teismo tarybą, neva norėdami gauti daugiau informacijos, – pranešė jis. – ");
INSERT INTO litb_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Nedarykite to! Kelyje tykos daugiau kaip keturiasdešimt vyrų, pasiruošę užpulti ir užmušti jį. Jie prisiekė nei valgyti, nei gerti, kol jį nužudys. Dabar jie jau čia, tikėdamiesi, kad tu išpildysi jų prašymą.“ ");
INSERT INTO litb_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","„Tegu nė vienas nežino, kad tu man tai pasakei“, – tribūnas įspėjo išeinantį jaunuolį. ");
INSERT INTO litb_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","24","Pasišaukęs du šimtininkus, tribūnas įsakė: „Pasiimkite du šimtus kareivių, kad dar šį vakarą devintą valandą galėtumėte vykti į Cezarėją. Paimkite du šimtus ietininkų ir septyniasdešimt raitelių. Parūpinkite Pauliui arklį ir sveiką pristatykite ji valdytojui Feliksui.“ ");
INSERT INTO litb_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Paskui jis valdytojui parašė tokį laišką: ");
INSERT INTO litb_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","„Klaudijas Lisijas kilniausiajam valdytojui Feliksui siunčia sveikinimą. ");
INSERT INTO litb_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Šį žmogų žydai sugavo ir norėjo nužudyti, bet aš pasiunčiau kareivius išvaduoti jį, nes sužinojau, kad jis Romos pilietis. ");
INSERT INTO litb_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Tada nuvežiau jį į jų teismo tarybą, norėdamas sužinoti, už ką jis kaltinamas. ");
INSERT INTO litb_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Greitai supratau, jog žydai ginčijosi dėl savo įsitikinimų, tačiau jis nebuvo apkaltintas, todėl negalėjo būti nubaustas kalėjimu ar mirtimi. ");
INSERT INTO litb_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Kai man buvo pranešta apie šį sąmokslą, aš nusprendžiau pasiųsti jį pas tave, o jo kaltintojams pasakysiu, kad savo kaltinimus pateiktų tau.“ ");
INSERT INTO litb_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Kaip buvo įsakyta, kareiviai nakčia nuvedė Paulių į Antipatridę. ");
INSERT INTO litb_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Rytojaus dieną jie grįžo į kareivines, palikę jį su raiteliais, kad nugabentų jį į Cezarėją, ");
INSERT INTO litb_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Atvykę į Cezarėją, jie pristatė valdytojui Paulių ir atidavė laišką. ");
INSERT INTO litb_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Perskaitęs jį, valdytojas paklausė Pauliaus, iš kur jis esąs. „Iš Kilikijos“, – atsakė Paulius. ");
INSERT INTO litb_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","„Aš išsamiai susipažinsiu su tavo byla, kai atvyks tavo kaltintojai“, – jam pasakė valdytojas ir įsakė laikyti jį kalėjime karaliaus Erodo pretorijuje. ");
INSERT INTO litb_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Po penkių dienų atvyko vyriausiasis kunigas Ananijas su keliais žydų vadovais ir advokatu Tertulu kaltinti Paulių. ");
INSERT INTO litb_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Į priekį iškviestas Tertulas, kreipdamasis į valdytoją, išdėstė kaltinimus, skirtus Pauliui: „Ekscelencija, mums, žydams, tu suteikei ramybę ir taiką ir neleidai mūsų skriausti. ");
INSERT INTO litb_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Dėl to mes esame labai dėkingi. ");
INSERT INTO litb_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Kad neįkyrėčiau tau, labai prašau atkreipti dėmesį tik į vieną dalyką. Aš trumpai išdėstysiu kaltinimus, skirtus šiam žmogui. ");
INSERT INTO litb_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Mes nustatėme, kad šis žmogus yra ramybės drumstėjas. Šis žmogus nuolat kelia maištus prieš romėnų vyriausybę. Jis yra žinomas nazariečių sektos vadas. ");
INSERT INTO litb_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Be to, jis mėgino išniekinti šventovę, kai mes jį suėmėme. Mes būtume teisę jį pagal tai, ko nusipelnė, ");
INSERT INTO litb_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","bet įgulos tribūnas Lisijas užėjęs prievarta atėmė jį, ");
INSERT INTO litb_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","reikalaudamas, kad jį teistų pagal romėnų įstatymą. Jūs nesunkiai suprasite, kad mūsų kaltinimas teisingas, apklausdamas jį pats.“ ");
INSERT INTO litb_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Tada visi žydai įsijungė į bendrą pokalbį, pareikšdami, kad visa, ką Tertulas sakė, yra tiesa. ");
INSERT INTO litb_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Dabar atėjo Pauliaus eilė. Valdytojas mostu parodė, kad atsistotų ir kalbėtų. Paulius pradėjo: „Žinau, kad tu jau daug metų teisėjauji žydams. Tai suteiks pasitikėjimo, kai man reikės gintis. ");
INSERT INTO litb_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Greitai paaiškės, kad aš atvykau į Jeruzalę tik prieš dvylika dienų melstis šventykloje. ");
INSERT INTO litb_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Galėsite pamatyti, kad niekada neskatinau sąmyšio sinagogose ar kurio nors miesto gatvėse. ");
INSERT INTO litb_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Šie vyrai, žinoma, negali įrodyti dalykų, kuriais jie mane kaltina. ");
INSERT INTO litb_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Vieną dalyką aš pripažįstu: tikiu sielos išganymu, kurį jie laiko sekta. Aš laikausi savo protėvių tarnavimo Dievui kelio. Tvirtai tikiu žydų įstatymu ir visu tuo, kas parašyta Pranašų knygose. ");
INSERT INTO litb_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Kartu su šiais vyrais tikime, jog bus teisiųjų ir neteisiųjų prisikėlimas. ");
INSERT INTO litb_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Todėl stengsiuosi iš visų jėgų išlaikyti švarią sąžinę prieš Dievą ir prieš žmones. ");
INSERT INTO litb_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Aš po daugelio metų grįžau į Jeruzalę duoti žydams išmaldą ir aukoti Dievui atnašų. ");
INSERT INTO litb_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Mano kaltintojai pamatė mane šventykloje, kai atnašavau padėkos auką. Aš buvau nusiskutęs galvą, kaip jų įstatymas reikalauja, o aplink mane nebuvo minios ir jokio triukšmo! Ten buvo keli žydai iš Turkijos. ");
INSERT INTO litb_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Jie privalo būti čia, jei ką turi prieš mane, ");
INSERT INTO litb_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","bet štai! Tegul dabar šie vyrai pasako, kokį nusikaltimą aš padariau. ");
INSERT INTO litb_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Nebent tai, kad pasakiau vieną dalyką, kurio neturėjau sakyti: „Aš esu čia, teismo taryboje, kad apginčiau tikėjimo tiesą, jog mirusieji prisikels.“ ");
INSERT INTO litb_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Feliksas, gerai žinodamas, kad krikščionys nepradės riaušių, liepė žydams palaukti, kol atvyks įgulos tribūnas Lisijas. Tuomet jis svarstysiąs jų klausimą. ");
INSERT INTO litb_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Jis liepė Paulių įmesti į kalėjimą, bet sargybiniui davė nurodymus švelniai su juo elgtis, nedrausti jo draugams jį lankyti ir leisti nešti jam dovanas, kad šis galėtų gyventi patogiau. ");
INSERT INTO litb_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Po kelių dienų atėjo Feliksas su savo žyde žmona Druzile. Pasišaukę Paulių, jie išklausė jo pasakojimą apie tikėjimą į Jėzų Kristų. ");
INSERT INTO litb_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Pauliui besikalbant su jais apie teisingumą, savitvardą ir apie būsimą teismą, Feliksas nusigando. „Šiam kartui užtenka. Kai bus tinkamesnis laikas, aš tave vėl pasišauksiu“, – tarė jis. ");
INSERT INTO litb_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Be to jis tikėjosi, kad Paulius duos jam pinigų, todėl dažnokai ji kviesdavosi ir su juo kalbėdavosi. ");
INSERT INTO litb_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Taip prabėgo dveji metai, Feliksą pakeitė Porcijus Festas. Kadangi Feliksas norėjo įsiteikti žydams, jis paliko Paulių, supančiotą grandinėmis. ");
INSERT INTO litb_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Po trijų dienų, perėmęs savo naujas pareigas Cezarėjoje, Festas išvyko į Jeruzalę. ");
INSERT INTO litb_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Ten jį pasičiupo vyriausieji kunigai bei kiti žydų vadovai ir daug papasakojo apie Paulių. ");
INSERT INTO litb_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Jie prašė atvesti Paulių į Jeruzalę, tikėdamiesi patykoti jį kelyje ir nužudyti. ");
INSERT INTO litb_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","5","Bet Festas atsakė, jog kol Paulius Cezarėjoje, įgaliotiniai turi grįžti į teismą, kadangi jis pats netrukus ten vyksta. ");
INSERT INTO litb_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Po aštuonių ar dešimties dienų jie sugrįžo į Cezarėją. Kitą dieną prasidėjo Pauliaus teismas. ");
INSERT INTO litb_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Pauliui atvykus į teismą, susirinkę Jeruzalės žydai iškėlė jam daug rimtų kaltinimų, kurių negalėjo įrodyti. ");
INSERT INTO litb_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Paulius paneigė kaltinimus: „Aš esu nekaltas, – pareiškė jis. – Aš niekuo nenusikaltau žydų įstatymams, šventyklos neišniekinau, prieš Romos vyriausybę nemaištavau.“ ");
INSERT INTO litb_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Paskui Festas, norėdamas parodyti savo palankumą žydams, paklausė jį: „Ar nori keliauti į Jeruzalę ir būti ten teisiamas mano akivaizdoje?“ ");
INSERT INTO litb_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Paulius atsakė: „Ne! Aš reikalauju ypatingos teisės būti išklausytas paties imperatoriaus. Jūs labai gerai žinote, kad aš nekaltas. ");
INSERT INTO litb_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Jeigu padariau tai, kas verta mirties bausmės, aš neatsisakau mirti! Bet jeigu aš nekaltas, nei tau, nei kam kitam nevalia manęs išduoti šitiems, kad nužudytų. Aš kreipsiuosi į Cezarį!“ ");
INSERT INTO litb_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Festas, pasitaręs su savo patarėjais, atsakė: „Labai gerai! Šaukeisi – vyksi pas Cezarį.“ ");
INSERT INTO litb_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Po kelių dienų karalius Agripa ir Berenikė atvyko paviešėti pas Festą. ");
INSERT INTO litb_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Jiems tenai užtrukus keletą dienų, Festas aptarė Pauliaus bylą su karaliumi. Jis papasakojo jam: „Turiu vieną kalinį, kurį man paliko Feliksas. ");
INSERT INTO litb_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Kai buvau Jeruzalėje, aukštieji kunigai ir kiti žydų seniūnai savaip žiūrėjo į šį reikalą ir prašė, kad pasmerkčiau Paulių. ");
INSERT INTO litb_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Žinoma, aš nedelsdamas paaiškinau jiems, kad romėnų įstatymas nepasmerkia žmogaus, kol jis nenuteisiamas. Jam suteikiama galimybė stoti savo kaltintojų akivaizdoje ir gintis. ");
INSERT INTO litb_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Kai jie susirinko, kitą dieną sušaukiau teismą ir įsakiau atvesti Paulių. ");
INSERT INTO litb_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Jam iškelti kaltinimai buvo visai ne tokie, kaip maniau. ");
INSERT INTO litb_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Ten buvo kalbama apie religiją ir mirusį Jėzų, kurį Paulius tvirtina esant gyvą! ");
INSERT INTO litb_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Dvejodamas, kaip išspręsti tokią bylą, aš paklausiau, ar jis nenorėtų vykti į Jeruzalę ir tenai būti teisiamas. ");
INSERT INTO litb_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Paulius šaukėsi Cezario. Todėl aš įsakiau kalinti jį toliau, kol galėsiu išsiųsti jį pas Cezarį.“ ");
INSERT INTO litb_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","„Aš ir pats norėčiau pasiklausyti to žmogaus“, – tarė Agripa. Festas atsakė: „Galėsi rytoj pasiklausyti.“ ");
INSERT INTO litb_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Rytojaus dieną Agripa ir Berenikė iškilmingai atvyko, lydimi tribūnų bei kitų žymių miesto žmonių, ir Festas liepė įvesti Paulių. ");
INSERT INTO litb_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Tada Festas kreipėsi į klausytojus: „Karaliau Agripa ir visi susirinkusieji. Jūs matote žmogų, kurio mirties reikalauja vietiniai ir Jeruzalės žydai! ");
INSERT INTO litb_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Bet mano nuomone, jis nėra padaręs nieko, kas būtų verta mirties. Tačiau jis nori kreiptis dėl savo bylos į Cezarį. Neturėdamas ką daryti, nusprendžiau jį ten pasiųsti. ");
INSERT INTO litb_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Bet ką turėčiau parašyti valdovui? Nes nėra jokios tikros kaltės! Štai aš ir atvedžiau jį visų, o ypač jūsų, karaliau Agripa, teismui, kad jį apklausęs, patartumei, ką man parašyti. ");
INSERT INTO litb_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Nes nėra teisinga siųsti kalinį pas imperatorių neturint įkalčių!“ ");
INSERT INTO litb_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Tuomet Agripa tarė Pauliui: „Išeik į priekį ir viską paaiškink.“ Tokiu būdu Paulius, pamojęs ranka, pradėjo gintis: ");
INSERT INTO litb_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","„Aš esu laimingas, karaliau Agripa, galėdamas tau atsakyti, ");
INSERT INTO litb_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","nes žinau, kad tu esi žydų įstatymo ir papročių žinovas. Dabar prašau, kantriai išklausykite mane. ");
INSERT INTO litb_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Žydai gerai žino, kad nuo ankstyvos jaunystės, o vėliau Jeruzalėje buvau auklėjamas žydų tarpe ir gyvenau to auklėjimo veikiamas. ");
INSERT INTO litb_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Jei jie manimi patikėtų, tai žinotų, kad gyvenau kaip fariziejus, griežčiausiai laikydamasis žydų įstatymų ir papročių. ");
INSERT INTO litb_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Bet jų kaltinimų tikroji priežastis yra visai kita, kadangi aš viliuosi, jog išsipildys Viešpaties pažadas, duotas mūsų protėviams. ");
INSERT INTO litb_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Jo išsipildymo tikisi sulaukti mūsų dvylikos giminių tauta, stropiai tarnaudama dieną ir naktį. Dėl šios vilties jie kaltina mane, o karaliau! ");
INSERT INTO litb_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Negi nusikaltimas – laukti mirusiųjų prisikėlimo? Negi neįtikėtina, kad Dievas gali prikelti žmones? ");
INSERT INTO litb_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Aš tikėjau, kad Jėzaus Nazariečio pasekėjus turiu persekioti iki paskutiniųjų. ");
INSERT INTO litb_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Aukštųjų kunigų įgaliotas aš įmečiau daug šventųjų į kalėjimą Jeruzalėje, o kai jie būdavo pasmerkti mirti – pritardavau. ");
INSERT INTO litb_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Juos kankindamas, stengiausi priversti krikščionis piktžodžiauti prieš Kristų. Be galo priešiškai nusiteikęs persekiodavau juos net tolimuose svetimų šalių miestuose. ");
INSERT INTO litb_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Vieną dieną apie vidurdienį, karaliau, tuo pačiu tikslu einant į Damaską su aukštųjų kunigų įgaliojimais, ");
INSERT INTO litb_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","mane nušvietė dangaus šviesa, ryškesnė už saulę. ");
INSERT INTO litb_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Mes visi parpuolėme ant žemės, o aš išgirdau hebrajiškai sakant: „Sauliau, Sauliau, kam Mane persekioji? Tu tik pats sau kenki!“ ");
INSERT INTO litb_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","„Kas esi, Viešpatie?“ – paklausiau aš. O Viešpats atsakė: „Aš esu Jėzus, Kurį tu persekioji. ");
INSERT INTO litb_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Dabar kelkis! Nes Aš tau apsireiškiau, kad paskirčiau tave Savo tarnu bei liudytoju. Tu turi papasakoti pasauliui apie šį ir daugelį kitų būsimų apreiškimų. ");
INSERT INTO litb_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Aš apsaugosiu tave nuo tautiečių ir pagonių. Taip, Aš ketinu siųsti tave pas pagonis, ");
INSERT INTO litb_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","kad atvertumei jų akis ir jie matytų savo tikrą padėtį, kad jie atgailautų ir gyventų Dievo šviesoje, o ne šėtono tamsoje, kad gautų nuodėmių atleidimą bei vietą ir dalį tarp tų, kurių nuodėmės buvo nuplautos per tikėjimą Manimi.“ ");
INSERT INTO litb_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Todėl, karaliau Agripa, aš negalėjau nepaklusti, nes mačiau regėjimą iš dangaus. ");
INSERT INTO litb_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Iš pradžių skelbiau Damaske, Jeruzalėje ir visoje Judėjoje. Pagonių krašte taip pat ėmiau tvirtinti, kad visi turi atsisakyti nuodėmių, atsigręžti į Dievą ir kaip atgailą daryti gerus darbus. ");
INSERT INTO litb_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Žydai sugriebė mane šventykloje, kai kalbėjau apie tai, ir mėgino nužudyti, ");
INSERT INTO litb_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","bet Viešpaties saugomas aš ir šiandien gyvas, pasakoju visiems, mažiems ir dideliems, tuos nuostabius dalykus. ");
INSERT INTO litb_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Sakau tai, ką yra skelbę pranašai ir Mozė apie Mesiją, kentėjusį ir tapusį pirmuoju prisikėlusiuoju iš numirusių, kad iš dangaus atneštų šviesą ir žydams, ir pagonims.“ ");
INSERT INTO litb_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Staiga Festas sušuko: „Pauliau, tau galvoj negerai! Iš didelio rašto išėjai iš krašto!“ ");
INSERT INTO litb_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Bet Paulius atsiliepė: „Ne, aš nesikraustau iš proto, prakilnusis Festai. Aš kalbu rimtus tiesos žodžius. ");
INSERT INTO litb_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Karalius Agripa žino šiuos dalykus. Aš atvirai kalbu, nes esu tikras, kad visi šitie dalykai yra jam žinomi, nes ne slapta jie buvo daromi! ");
INSERT INTO litb_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Karaliau Agripa, ar tiki pranašais? Žinau, kad tiki.“ ");
INSERT INTO litb_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agripa jį pertraukė: „Tokie menki įrodymai manęs neprivers tikėti Kristumi!“ ");
INSERT INTO litb_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Paulius atsakė: „Nepriklausomai nuo to, ar mano argumentai menki, ar stiprūs, aš prašau Dievą, kad ne tik tu, bet ir kiekvienas galėtų tapti tokiu pat kaip aš, tik be šitų grandinių.“ ");
INSERT INTO litb_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Tuomet karalius, valdytojas, Berenikė ir visi kiti pakilo ir išėjo. ");
INSERT INTO litb_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Kiek vėliau kalbėdamiesi jie priėjo vienos nuomonės: „Šitas žmogus nepadarė nieko blogo, kas būtų baustina mirtimi ar kalėjimu.“ ");
INSERT INTO litb_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agripa Festui pareiškė: „Jis galėjo būti išlaisvintas, jeigu nebūtų šaukęsis Cezario.“ ");
INSERT INTO litb_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Pagaliau buvo susitarta leistis kelionėn į Romą laivu, todėl Paulius ir keli kiti kaliniai buvo uždaryti į šimtininko Julijaus, imperatoriaus kuopos nario, kalėjimą. ");
INSERT INTO litb_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Mes įlipome į laivą, kuris pagal grafiką turėjo aplankyti keletą Turkijos uostų. Turėčiau pridurti, kad su mumis buvo Aristarchas, graikas iš Tesalonikos. ");
INSERT INTO litb_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Rytojaus dieną, kai mes atplaukėme į Sidoną, Julijus draugiškai elgėsi su Pauliumi ir leido jam išlipti į krantą aplankyti bičiulius ir pasisvečiuoti. ");
INSERT INTO litb_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Iš ten išplaukę į jūrą, mes grūmėmės su vėjais ir turėjome keisti kursą, todėl plaukėme į šiaurę nuo Kipro, tarp salos ir žemyno, ");
INSERT INTO litb_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Kilikijos ir Pamfilijos provincijų pakrante. Atvykome į Myrą Likijos provincijoje. ");
INSERT INTO litb_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Šimtininkas surado aleksandriečių laivą, kuris plaukė į Italiją, ir persodino mus į jį. ");
INSERT INTO litb_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Daug dienų plaukėme audringa jūra, kol pagaliau pasiekėme Knidą. Tačiau labai sustiprėjus vėjams, mes plaukėme Kretos link pro Salmonės uostą. ");
INSERT INTO litb_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Sunkiai plaukdami prieš vėją ir pamažu judėdami pietine pakrante, mes atvykome į Dailiąją Prieplauką, netoli nuo Lasėjos miesto. ");
INSERT INTO litb_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Ten prabėgo kelios dienos. Leistis ilgon kelionėn pasidarė pavojinga, nes buvo vėlyvas metų laikas. Paulius kalbėjo apie tai su laivo karininkais: ");
INSERT INTO litb_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","„Ponai, aš manau, kad vargas mums, jei mes plauksime toliau. Galime netekti ne tik laivo, krovinių, bet ir sulaukti mirties“, – sakė jis. ");
INSERT INTO litb_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Bet kalinių sargai labiau klausė laivo kapitono ir savininko negu Pauliaus. ");
INSERT INTO litb_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Kadangi Dailioji Prieplauka, atviras uostas, nebuvo tinkama vieta žiemoti, tai didžioji įgulos dalis nusprendė plaukti toliau ir kaip nors pasiekti Feniksą, kuris buvo geras uostas, atviras į šiaurės vakarus ir pietvakarius. ");
INSERT INTO litb_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Kai ėmė pūsti švelnus pietų vėjas, diena atrodė tinkama kelionei, todėl jie pakėlė inkarą, plaukė pakrantėmis. ");
INSERT INTO litb_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Oras staiga pasikeitė, pakilo viesulas, vadinamas Šiauriaryčiu. ");
INSERT INTO litb_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Jis užklupo laivą ir nunešė į jūrą. Iš pradžių jie stengėsi pasukti laivą į krantą, bet nepajėgė. Vėjas pagavo laivą ir nešė jį, ");
INSERT INTO litb_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Pagaliau praplaukėme pro Kaudos salą, ties kuria mes sunkiai įkėlėme į laivą gelbėjimo valtį, kuri buvo tempiama, ");
INSERT INTO litb_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","tada korpusą sustiprinome virvėmis. Jūreiviai bijojo, kad nebūtume nunešti ant Afrikos pakrantės seklumų, todėl jie nuleido viršutines bures ir tokiu būdu buvo nešami vėjo. ");
INSERT INTO litb_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Rytojaus dieną, kai jūra dar labiau įsisiautėjo, įgula ėmė mėtyti krovinį į jūrą. ");
INSERT INTO litb_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Trečią dieną jie mėtė laukan įrangą ir viską, kas pakliuvo po ranka. ");
INSERT INTO litb_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Daug dienų šėlo baisi audra, kol pagaliau visi prarado viltį išsigelbėti. ");
INSERT INTO litb_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Žmonės ilgą laiką jau nebevalgė, kai pagaliau Paulius sukvietė įgulą ir pasakė: „Vyrai, pirmiausia jūs turėjote paklausyti manęs ir neplaukti iš Dailiosios Prieplaukos. Būtume išvengę visų šitų pavojų ir nuostolių. ");
INSERT INTO litb_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Bet nenusiminkite! Niekas nežus, nors laivas ir nuskęs. ");
INSERT INTO litb_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Praėjusią naktį šalia manęs atsistojo Viešpaties angelas, kuriam aš priklausau ir tarnauju, ir pranešė: ");
INSERT INTO litb_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","„Nebijok Pauliau, nes tu tikrai stosi prieš Cezarį! Dar daugiau – Dievas patenkino tavo prašymą ir išgelbės visus, kurie plaukia su tavimi.“ ");
INSERT INTO litb_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Turėkite drąsos! Aš tikiu Dievu. Bus taip, kaip Jis sakė. ");
INSERT INTO litb_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Bet mūsų laivas suduš užplaukęs ant seklumos.“ ");
INSERT INTO litb_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Keturioliktą parą apie vidurnaktį, kai buvome Adrijos jūroje svaidomi pirmyn ir atgal, jūreiviams pasirodė, kad žemė jau nebetoli. ");
INSERT INTO litb_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Jie išmetė grimzlę ir nustatė dvidešimties jūros sieksnių gylį. Truputį vėliau išmatavo dar kartą ir berado tik penkiolika sieksnių. Šitaip jie suprato, kad greitai laivą išmes į krantą. ");
INSERT INTO litb_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Bijodami užplaukti ant povandeninių uolų, išmetė pro užpakalinę laivo dalį keturis inkarus ir meldė dienos. ");
INSERT INTO litb_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Keli jūreiviai, nutarę pabėgti iš laivo, nuleido į vandenį gelbėjimo valtį, neva norėdami išmesti inkarus laivo priekyje. ");
INSERT INTO litb_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Paulius įspėjo šimtininką ir karius: „Visi jūs žūsite, jeigu kas nors paliks laivą.“ ");
INSERT INTO litb_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Tada kareiviai nukapojo valties virves ir leido jai nukristi į jūrą. ");
INSERT INTO litb_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Prieš rytą Paulius ragino visus valgyti, sakydamas: „Šiandien jau keturiolikta diena, kaip jūs nieko burnoje neturėjote. ");
INSERT INTO litb_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Valgykite savo pačių labui. Nė vienam iš jūsų nenukris nė plaukas nuo galvos!“ ");
INSERT INTO litb_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Po to jis paėmė keletą džiūvėsių, visų akivaizdoje padėkojo Dievui ir atsilaužė gabalėlį. ");
INSERT INTO litb_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Tuomet laive buvę ");
INSERT INTO litb_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","du šimtai septyniasdešimt šeši žmonės visi iki vieno ėmė valgyti. ");
INSERT INTO litb_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Pavalgiusi įgula palengvino laivą, išmesdama į jūrą kviečius. ");
INSERT INTO litb_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Rytui išaušus, jie nepastebėjo kranto linijos, bet pamatė įlanką jūroje su lėkštais krantais ir svarstė, ar jie galėtų tarp tų uolų nusigauti į krantą. ");
INSERT INTO litb_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Pagaliau nutarė pabandyti. Nupjovė inkarus, paliko juos jūroje, atleido laivo diržus ir, iškėlę prieš vėją priekinę burę, leidosi į krantą. ");
INSERT INTO litb_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Bet laivas užplaukė ant seklumos ir užpakalinė laivo dalis sukežo. ");
INSERT INTO litb_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Kareiviai šimtininkui patarė leisti jiems išžudyti kalinius, kad kuris išplaukęs į krantą nepabėgtų. ");
INSERT INTO litb_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Bet Julijus norėjo išsaugoti Paulių, todėl neleido. Tada jis įsakė visiems, kad mokantys plaukti šoktų į jūrą ir plauktų į krantą, ");
INSERT INTO litb_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","o kiti tegul pasistengia pasiekti krantą ant storų lentų ir laivo nuolaužų. Taip visi saugiai pasiekė krantą. ");
INSERT INTO litb_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Greitai mes sužinojome, kad esame Maltos saloje. ");
INSERT INTO litb_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Salos žmonės buvo malonūs, užkūrė ugnį ant kranto ir nuoširdžiai kvietė prie jos, nes lijo ir buvo šalta. ");
INSERT INTO litb_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Kai Paulius pririnko laužui glėbį šakų, iš laužo iššliaužė nuodinga gyvatė ir įsikibo į jo ranką! ");
INSERT INTO litb_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Salos gyventojai, pamatę įsikibusią į ranką gyvatę, vienas kitam sakė: „Tikrai tas žmogus – žmogžudys. Nors jis jūroje išsigelbėjo, bet teisingumas neleidžia jam gyventi!“ ");
INSERT INTO litb_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","O Paulius nupurtė gyvatę į ugnį ir jam nieko pikto neatsitiko. Gyventojai laukė, kol jis sutins ar staiga kris negyvas. ");
INSERT INTO litb_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Gerokai palaukę pamatė, kad jam nieko pikto neatsitiko, todėl ėmė manyti, kad jis dievaitis. ");
INSERT INTO litb_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Netoli tos vietos, kur mes išlipome, buvo salos valdytojo Publijaus valdos. Jis mus maloniai priėmė ir tris dienas globojo. ");
INSERT INTO litb_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Atsitiko taip, kad susirgo karštlige ir viduriavimu Publijaus tėvas. Paulius užėjo pas jį, pasimeldė, uždėjo ant jo rankas ir išgydė. ");
INSERT INTO litb_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Tada visi kiti salos ligoniai ėjo ir buvo pagydyti. ");
INSERT INTO litb_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Už tai mes buvome apipilti dovanomis ir, kai atėjo laikas išplaukti, žmonės krovė į laivą mums įvairiausius kelionei reikalingus daiktus. ");
INSERT INTO litb_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Praėjo trys mėnesiai nuo laivo sudužimo, ir mes vėl pakėlėme bures. Šį kartą tai buvo Aleksandrijos uosto laivas „Dvyniai“, kuris žiemojo saloje. ");
INSERT INTO litb_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Pirmiausia aplankėme Sirakūzus. Ten prastovėjome tris dienas. ");
INSERT INTO litb_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Plaukdami pakrantėmis pasiekėme Regijų. Ir dar po dienos, ėmus pūsti pietų vėjui, atvykome į Puteolus. ");
INSERT INTO litb_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Ten radome nemažai tikinčiųjų! Jie prašė mus paviešėti septynias dienas ir tada vykti į Romą. ");
INSERT INTO litb_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Broliai Romoje išgirdo apie mūsų atvykimą ir atėjo pasitikti prie Apijaus Forumo. Kiti prisijungė prie mūsų prie Trijų tavernų. Juos išvydęs, Paulius įgijo pasitikėjimo ir dėkojo Dievui. ");
INSERT INTO litb_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Mums atvykus į Romą, Pauliui buvo leista pasirinkti, kur gyventi, nors ir saugomam kareivio. ");
INSERT INTO litb_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Praėjus trims dienoms po atvykimo, jis pasikvietė septynis žydų vadovus ir taip jiems kalbėjo: „Broliai, žydai mane Jeruzalėje suėmė ir perdavė romėnų vyriausybei. Jie persekioja mane, nors niekam blogo nepadariau. Mūsų protėvių įstatymų taip pat nepažeidžiau. ");
INSERT INTO litb_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Romėnai ištardę norėjo paleisti, nes nerado mirties vertos kaltės. Žydų vadovai reikalavo mirties bausmės. ");
INSERT INTO litb_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Esant tokiems prieštaravimams, aš pamačiau, kad būtina kreiptis į Cezarį, bet ne todėl, kad būčiau pykęs ant jų. ");
INSERT INTO litb_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Aš paprašiau jus susirinkti šiandien, kad su jumis susipažinčiau ir papasakočiau, jog grandinėmis esu surakintas dėl tikėjimo Mesiju.“ ");
INSERT INTO litb_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Jie atsakė: „Mes negirdėjome jokių kaltinimų tavo atžvilgiu. Iš Judėjos mes negavome nei laiškų, nei pranešimų iš tų, kurie atvyksta iš Jeruzalės. ");
INSERT INTO litb_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Bet mes norėtume išgirsti, kuo tu tiki, nes apie tuos krikščionis mes žinome tik tiek, kad jie visų smerkiami.“ ");
INSERT INTO litb_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Buvo sutarta dėl laiko, ir tą dieną į Pauliaus namus suėjo daug žmonių. Jis papasakojo apie Dievo karalystę ir mokė apie Jėzų iš Raštų: pranašų ir penkių Mozės knygų. Jis pradėjo rytą ir baigė vėlai vakare! ");
INSERT INTO litb_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Vieni jo žodžiais tikėjo, kiti – ne. ");
INSERT INTO litb_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Bet, pasiginčiję tarpusavyje, jie išėjo, o paskutiniai Pauliaus žodžiai tebeskambėjo ausyse: „Teisi Šventoji Dvasia, kalbėjusi per pranašą Izaiją: ");
INSERT INTO litb_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","„Girdėti girdėsite ir matyti matysite, bet nesuprasite, ");
INSERT INTO litb_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","nes jūsų širdys aptuko, o ausys apkurto. Užmerkite akis, kad nesuprastumėte, kad kartais nepamatytumėte ir neišgirstumėte, kad neatsisuktumėteį Mane ir kad Aš jūsų nepagydyčiau.“ ");
INSERT INTO litb_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","29","Todėl aš noriu, kad jūs suvoktumėte, jog Dievas suteiks palaiminimą ir pagonims, o šie jį priims.“ ");
INSERT INTO litb_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Paulius išsinuomojo butą dvejiems metams ir priimdavo visus savo lankytojus. ");
INSERT INTO litb_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Jis visiems skelbė tiesą apie Dievo karalystę ir Viešpatį Jėzų Kristų, ir niekas nebandė jo sudrausti.");
ALTER TABLE litb_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
