﻿USE sofia;
DROP TABLE IF EXISTS sofia.lit_vpl;
CREATE TABLE lit_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES lit_vpl WRITE;
INSERT INTO lit_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Pradžioje Dievas sukūrė dangus ir žemę. ");
INSERT INTO lit_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Ir žemė buvo be pavidalo ir tuščia ir tamsa buvo virš gelmės paviršiaus. Ir Dievo Dvasia sklandė virš vandenų paviršiaus. ");
INSERT INTO lit_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Ir Dievas tarė: „Tegul atsiranda šviesa!“ Ir atsirado šviesa. ");
INSERT INTO lit_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Ir Dievas matė šviesą, kad ji gera, ir Dievas atskyrė šviesą nuo tamsos. ");
INSERT INTO lit_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Ir Dievas pavadino šviesą diena, o tamsą jis pavadino naktimi. Ir buvo vakaras ir buvo rytas – pirmoji diena. ");
INSERT INTO lit_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Ir Dievas tarė: „Tegul atsiranda skliautinė platybė tarp vandenų, ir ji tegul atskiria vandenis nuo vandenų.“ ");
INSERT INTO lit_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Ir Dievas padarė skliautinę platybę ir atskyrė vandenis, kurie buvo po skliautine platybe, nuo vandenų, kurie buvo virš skliautinės platybės. Taip ir įvyko. ");
INSERT INTO lit_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Ir Dievas pavadino skliautinę platybę dangumis. Ir buvo vakaras ir buvo rytas – antroji diena. ");
INSERT INTO lit_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Ir Dievas tarė: „Tegul susirenka vandenys, kurie yra po dangumis, į vieną vietą ir tegul pasirodo sausuma.“ Taip ir įvyko. ");
INSERT INTO lit_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Ir Dievas pavadino sausumą žeme, o vandenų samplūdį jis pavadino jūromis. Ir Dievas matė, kad tai buvo gera. ");
INSERT INTO lit_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Ir Dievas tarė: „Tegul žemė išželdina žemėje augmeniją, augalus, duodančius sėklą, vaismedžius, pagal savo rūšį vedančius vaisius, kuriuose yra jų sėkla.“ Taip ir įvyko. ");
INSERT INTO lit_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Ir žemė išvedė augmeniją, augalus, duodančius sėklą pagal savo rūšį, ir medžius, pagal savo rūšį vedančius vaisius, kuriuose yra jų sėkla. Ir Dievas matė, kad tai buvo gera. ");
INSERT INTO lit_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Ir buvo vakaras ir buvo rytas – trečioji diena. ");
INSERT INTO lit_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Ir Dievas tarė: „Tegul atsiranda šviesuliai dangaus skliautinėje platybėje dienai nuo nakties atskirti. Ir jie tegul būna kaip ženklai, pažymintys ir nustatytus laikus, ir dienas ir metus, ");
INSERT INTO lit_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","ir jie tegul būna kaip šviesuliai dangaus skliautinėje platybėje, kad apšviestų žemę.“ Taip ir įvyko. ");
INSERT INTO lit_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Ir Dievas padarė du didžiuosius šviesulius – didesnįjį šviesulį dienai valdyti ir mažesnįjį šviesulį nakčiai valdyti; jis padarė ir žvaigždes. ");
INSERT INTO lit_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Ir Dievas įdėjo juos į dangaus skliautinę platybę, kad apšviestų žemę ");
INSERT INTO lit_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","ir valdytų dieną bei naktį, ir atskirtų šviesą nuo tamsos. Ir Dievas matė, kad tai buvo gera. ");
INSERT INTO lit_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Ir buvo vakaras ir buvo rytas – ketvirtoji diena. ");
INSERT INTO lit_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Ir Dievas tarė: „Tegul vandenys veisia knibždančių gyvų padarų, ir tegul viršum žemės skraido paukščiai dangaus skliautinės platybės matomos dalies priekyje.“ ");
INSERT INTO lit_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Ir Dievas sukūrė didžiulius baisūnus ir visus judančius gyvus padarus, kuriuos veisė vandenys pagal jų rūšį, ir kiekvieną sparnuotą paukštį pagal jo rūšį. Ir Dievas matė, kad tai buvo gera. ");
INSERT INTO lit_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Ir Dievas juos palaimino, tardamas: „Būkite vaisingi ir dauginkitės, ir pripildykite vandenis jūrose, o paukščiai tegul dauginasi žemėje!“ ");
INSERT INTO lit_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Ir buvo vakaras ir buvo rytas – penktoji diena. ");
INSERT INTO lit_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Ir Dievas tarė: „Tegul žemė išveda gyvų padarų pagal jų rūšis – gyvulių, ir ropojančių padarų ir laukinių žvėrių pagal jų rūšis.“ Taip ir įvyko. ");
INSERT INTO lit_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Ir Dievas padarė žemės laukinius žvėris pagal jų rūšis ir gyvulius pagal jų rūšis, ir prie dirvos ropojančius padarus pagal jų rūšis. Ir Dievas matė, kad tai buvo gera. ");
INSERT INTO lit_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Ir Dievas tarė: „Padarykime žmogų, atitinkantį mūsų atvaizdą, pagal mūsų panašumą, ir tegul jie valdo jūros žuvis, ir padangių paukščius, ir gyvulius, ir visą žemę, ir visus ropojančius padarus, kurie juda ant žemės.“ ");
INSERT INTO lit_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Taigi Dievas sukūrė žmogų pagal savo atvaizdą, pagal Dievo atvaizdą jis sukūrė jį; vyriškos lyties ir moteriškos lyties jis juos sukūrė. ");
INSERT INTO lit_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Ir Dievas juos palaimino, ir Dievas jiems tarė: „Būkite vaisingi ir dauginkitės ir pripildykite žemę ir užvaldykite ją; ir valdykite jūros žuvis, padangių paukščius ir kiekvieną gyvą padarą, kuris juda ant žemės.“ ");
INSERT INTO lit_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Ir Dievas tarė: „Štai aš duodu jums kiekvieną sėklą duodantį augalą, kuris yra ant visos žemės paviršiaus, ir visokį medį, kuriame yra medžio vaisius, duodantis sėklą; tai bus jums maistas. ");
INSERT INTO lit_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","O visiems žemės laukiniams žvėrims, visiems padangių paukščiams ir visiems gyvūnams, judantiems ant žemės, turintiems savyje gyvasties esmę, duodu visokius žalius augalus kaip maistą. Taip ir įvyko. ");
INSERT INTO lit_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Ir Dievas matė visa, ką buvo padaręs, ir štai, tai buvo labai gera. Ir buvo vakaras ir buvo rytas – šeštoji diena. ");
INSERT INTO lit_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Taip buvo pabaigti dangūs ir žemė, ir visa jų aibė. ");
INSERT INTO lit_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Tai iki septintos dienos Dievas užbaigė savo darbą, kurį jis padarė, ir ilsėjosi septintą dieną nuo viso savo darbo, kurį jis padarė. ");
INSERT INTO lit_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Ir Dievas palaimino septintąją dieną ir ją pašventino, nes joje jis ilsėjosi nuo viso savo darbo, kurį Dievas kūrybingai padarė. ");
INSERT INTO lit_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Šitie yra dangų ir žemės kilmės istorijos duomenys jų sukūrimo metu, – tą dieną, kurią VIEŠPATS Dievas padarė žemę ir dangus, ");
INSERT INTO lit_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","ir jokio laukinio krūmo dar nebuvo žemėje ir joks lauko augalas dar neaugo (nes VIEŠPATS Dievas dar nebuvo siuntęs į žemę lietaus ir nebuvo žmogaus dirvai įdirbti, ");
INSERT INTO lit_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","tik migla kildavo nuo žemės ir drėkindavo visą dirvos paviršių). ");
INSERT INTO lit_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Ir VIEŠPATS Dievas supavidalino žmogų iš dirvos dulkių ir įkvėpė į jo šnerves gyvybės dvasią, ir žmogus tapo gyva siela. ");
INSERT INTO lit_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Ir VIEŠPATS Dievas įveisė sodą Edene, rytuose, ir ten jis apgyvendino žmogų, kurį buvo supavidalinęs. ");
INSERT INTO lit_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Ir VIEŠPATS Dievas išaugino iš dirvos visokius medžius, mielus pasižiūrėti ir gerus maistui, taip pat gyvybės medį sodo viduryje ir gėrio bei blogio pažinimo medį. ");
INSERT INTO lit_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Ir iš Edeno upė tekėjo sodui drėkinti, o nuo ten ji šakojosi ir tapo keturiomis pagrindinėmis upėmis. ");
INSERT INTO lit_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Pirmosios vardas – Pišonas. Ji yra ta, kuri apsupa visą Havilos šalį, kur yra aukso. ");
INSERT INTO lit_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","O tos šalies auksas yra geras. Ten yra bdelio ir onikso akmens. ");
INSERT INTO lit_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Ir antrosios upės vardas – Gihonas. Ji yra ta, kuri apsupa visą Kušo šalį. ");
INSERT INTO lit_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Ir trečiosios upės vardas – Hidekelis. Ji yra ta, kuri teka prie Asirijos rytų. Ir ketvirtoji upė, – ji yra Eufratas. ");
INSERT INTO lit_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Ir VIEŠPATS Dievas paėmė žmogų ir įkurdino jį Edeno sode, kad jį įdirbtų ir saugotų. ");
INSERT INTO lit_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Ir VIEŠPATS Dievas įsakė žmogui, tardamas: „Nuo kiekvieno sodo medžio tau leista laisvai valgyti, ");
INSERT INTO lit_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","bet nuo gėrio bei blogio pažinimo medžio – nevalgyk nuo jo, nes tą dieną, kurią nuo jo valgysi, tikrai mirsi.“ ");
INSERT INTO lit_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Ir VIEŠPATS Dievas tarė: „Negera žmogui būti vienam; jam padarysiu atitinkančią pagalbininkę.“ ");
INSERT INTO lit_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Ir VIEŠPATS Dievas iš dirvos supavidalino visus lauko žvėris ir visus padangių paukščius ir atvedė juos pas Adomą pamatyti, kaip jis juos pavadins; ir kuo tik Adomas pavadino kiekvieną gyvūną, toks ir buvo jo vardas. ");
INSERT INTO lit_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Ir Adomas davė vardus visiems gyvuliams ir padangių paukščiams, ir visiems lauko žvėrims, tačiau Adomui nebuvo rasta atitinkančio pagalbininko. ");
INSERT INTO lit_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Ir VIEŠPATS Dievas užmigdė Adomą giliu miegu ir, jam miegant, išėmė vieną jo šonkaulių, ir jo vietą užpildė kūnu. ");
INSERT INTO lit_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","O VIEŠPATS Dievas iš šonkaulio, kurį buvo išėmęs iš žmogaus, sudarė moterį ir atvedė ją pas žmogų. ");
INSERT INTO lit_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Ir Adomas tarė: „Pagaliau! Ši yra kaulas iš mano kaulų ir kūnas iš mano kūno! Ji bus vadinama moterimi, nes iš vyro ji buvo paimta.“ ");
INSERT INTO lit_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Dėl tos priežasties vyras paliks savo tėvą bei savo motiną ir liks sujungtas su savo žmona, ir juodu taps vienu kūnu. ");
INSERT INTO lit_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Jie abu – žmogus ir jo žmona – buvo nuogi ir jie nesigėdijo. ");
INSERT INTO lit_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","O gyvatė buvo gudresnė už visus lauko žvėris, kuriuos VIEŠPATS Dievas buvo padaręs. Ir ji tarė moteriai: „Ar tikrai Dievas pasakė: ‚Nevalgykite nuo visų sodo medžių‘?“ ");
INSERT INTO lit_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Ir moteris tarė gyvatei: „Mums leista valgyti sodo medžių vaisių, ");
INSERT INTO lit_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","bet apie vaisių medžio, kuris yra sodo viduryje, Dievas tarė: ‚Nevalgykite nuo jo ir nelieskite jo, kad nemirtumėte‘.“ ");
INSERT INTO lit_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Ir gyvatė tarė moteriai: „Jūs tikrai nemirsite, ");
INSERT INTO lit_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","nes Dievas žino, kad tą dieną, kai valgysite nuo jo, atsivers jūsų akys, ir jūs būsite kaip dievai, pažindami gėrį ir blogį.“ ");
INSERT INTO lit_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Ir kai moteris pamatė, kad medis buvo geras maistui ir kad jis žavus akims, ir kad medis pageidaujamas – galintis padaryti žmogų išmintingą, ji paėmė jo vaisiaus ir valgė, ir taip pat davė savo vyrui, esančiam su ja, ir jis valgė. ");
INSERT INTO lit_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Ir atsivėrė jų abiejų akys, ir jie suprato esą nuogi; ir jie susiuvo figmedžio lapus ir sau padarė prijuostes. ");
INSERT INTO lit_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Ir jie išgirdo balsą VIEŠPATIES Dievo, vaikštančio sode, dienos atvėsimo metu; ir Adomas ir jo žmona pasislėpė nuo VIEŠPATIES Dievo akivaizdos tarp sodo medžių. ");
INSERT INTO lit_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Ir VIEŠPATS Dievas pašaukė Adomą ir jam tarė: „Kur tu?“ ");
INSERT INTO lit_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ir jis tarė: „Aš išgirdau tavo balsą sode ir bijojau, nes aš nuogas; todėl pasislėpiau.“ ");
INSERT INTO lit_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Ir jis tarė: „Kas tau pasakė, kad tu nuogas? Ar valgei nuo medžio, nuo kurio tau įsakiau nevalgyti?“ ");
INSERT INTO lit_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Ir žmogus tarė: „Moteris, kurią davei, kad būtų su manimi, ji davė man nuo to medžio, ir aš valgiau.“ ");
INSERT INTO lit_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Ir VIEŠPATS Dievas tarė moteriai: „Kas gi tai, ką tu padarei?“ Ir moteris tarė: „Gyvatė mane apgavo, ir aš valgiau.“ ");
INSERT INTO lit_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Ir VIEŠPATS Dievas tarė gyvatei: „Kadangi tai padarei, tu esi labiau prakeikta už visus gyvulius ir už visus lauko žvėris; ant savo pilvo turėsi šliaužti ir dulkes ėsti per visas savo gyvenimo dienas; ");
INSERT INTO lit_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","ir aš sukelsiu priešiškumą tarp tavęs bei moters ir tarp tavo sėklos bei moters Sėklos; jis – moters Sėkla – triuškins tau galvą, o tu triuškinsi jam kulnį.“ ");
INSERT INTO lit_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Moteriai jis tarė: „Aš didžiai padauginsiu tavo nėštumo vargą – skausmingai tu gimdysi vaikus; ir tavo potraukis bus nukreiptas į tavo vyrą, ir jis tave valdys.“ ");
INSERT INTO lit_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ir Adomui jis tarė: „Kadangi paklausei savo žmonos balso ir valgei nuo medžio, apie kurį aš tau įsakiau, sakydamas: „Nevalgyk nuo jo!“ – prakeikta yra dirva dėl tavęs; vargdamas maitinsiesi iš jos per visas savo gyvenimo dienas ");
INSERT INTO lit_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","ir erškėčius bei usnis ji tau želdins, ir tu maitinsiesi lauko augmenija. ");
INSERT INTO lit_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Savo veido prakaitu turėsi valgyti duoną, kol sugrįši į dirvą, nes iš jos buvai paimtas; nes tu esi dulkė, ir į dulkę sugrįši.“ ");
INSERT INTO lit_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Ir Adomas pavadino savo žmoną vardu Ieva, nes ji buvo visų gyvųjų motina. ");
INSERT INTO lit_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Ir VIEŠPATS Dievas Adomui ir jo žmonai padarė odinius drabužius ir juos aprengė. ");
INSERT INTO lit_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Ir VIEŠPATS Dievas tarė: „Štai žmogus tapo kaip vienas iš mūsų, pažindamas gėrį ir blogį, o dabar, kad jis neištiestų savo rankos ir nepaimtų nuo gyvybės medžio, ir nevalgytų, ir negyventų per amžius!“ ");
INSERT INTO lit_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Todėl VIEŠPATS Dievas išsiuntė jį iš Edeno sodo įdirbti dirvą, iš kurios jis buvo paimtas. ");
INSERT INTO lit_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Taigi jis išvarė žmogų, ir į rytus nuo Edeno sodo pastatė kerubus ir besisukiojantį liepsningą kalaviją, kad saugotų kelią į gyvybės medį. ");
INSERT INTO lit_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Ir Adomas pažino savo žmoną Ievą, ir ji tapo nėščia ir pagimdė Kainą, ir tarė: „Gavau vyriškos lyties žmogų nuo VIEŠPATIES.“ ");
INSERT INTO lit_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Ir dar kartą ji pagimdė – šįkart jo brolį Abelį. Ir Abelis buvo avių piemuo, o Kainas buvo žemdirbys. ");
INSERT INTO lit_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Ir taip įvyko, kad, kuriam laikui praslinkus, Kainas atnešė auką VIEŠPAČIUI iš dirvos vaisiaus. ");
INSERT INTO lit_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Taip pat atnešė ir Abelis – bet iš savo kaimenės pirmagimių ir iš jų taukų. Ir VIEŠPATS palankiai pažvelgė į Abelį ir į jo auką, ");
INSERT INTO lit_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","tačiau į Kainą ir į jo auką jis palankiai nepažvelgė. Ir Kainas labai supyko, ir jo veidas paniuro. ");
INSERT INTO lit_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Ir VIEŠPATS tarė Kainui: „Kodėl tu supykai ir kodėl tavo veidas paniuro? ");
INSERT INTO lit_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Jeigu tu darysi gera, argi nebūsi priimtas? O jeigu nedarysi gera, nuodėmė pritupia prie durų. Ir tau bus nukreiptas jos potraukis, bet tu privalai ją suvaldyti.“ ");
INSERT INTO lit_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Ir Kainas kalbėjo savo broliui Abeliui; ir taip įvyko, kad jiems esant laukuose, Kainas pakilo prieš savo brolį Abelį ir jį užmušė. ");
INSERT INTO lit_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Ir VIEŠPATS tarė Kainui: „Kur tavo brolis Abelis?“ Ir jis tarė: „Nežinau! Argi aš savo brolio sargas?“ ");
INSERT INTO lit_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Ir anas tarė: „Ką tu padarei? Iš dirvos šaukiasi manęs tavo brolio kraujo balsas! ");
INSERT INTO lit_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Taigi dabar tu esi prakeiktas nuo dirvos, kuri atvėrė savo burną priimti tavo brolio kraują iš tavo rankos. ");
INSERT INTO lit_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Kai dirbsi dirvą, ji nuo šiol tau nebeduos savo gero derliaus; tu būsi bėglys ir klajūnas žemėje.“ ");
INSERT INTO lit_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Ir Kainas tarė VIEŠPAČIUI: „Mano bausmė didesnė nei aš galiu pakelti! ");
INSERT INTO lit_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Štai šiandien mane išvarei nuo dirvos paviršiaus, ir turėsiu nuo tavo veido slėptis, ir būsiu bėglys ir klajūnas žemėje; ir taip įvyks, kad kas tik mane sutiks, mane užmuš.“ ");
INSERT INTO lit_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Bet VIEŠPATS jam tarė: „Taigi, kas tik užmuštų Kainą, tam septyneriopai bus atkeršyta. Ir VIEŠPATS davė Kainui ženklą, kad kas nors, jį užtikęs, jo nenužudytų.“ ");
INSERT INTO lit_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Ir Kainas pasitraukė nuo VIEŠPATIES akivaizdos ir apsigyveno Nodo šalyje, į rytus nuo Edeno. ");
INSERT INTO lit_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Paskui Kainas pažino savo žmoną, ir ji tapo nėščia ir pagimdė Henochą. Ir jis pastatė miestą, ir pavadino miestą savo sūnaus vardu – Henochas. ");
INSERT INTO lit_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","O Henochui gimė Iradas, o Iradas pagimdė Mehujaelį, o Mehujaelis pagimdė Metušaelį, o Metušaelis pagimdė Lamechą. ");
INSERT INTO lit_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","O Lamechas ėmė sau dvi žmonas. Vienos vardas buvo Ada, o kitos vardas Cila. ");
INSERT INTO lit_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","O Ada pagimdė Jabalą. Jis buvo tėvas tokių, kurie gyvena palapinėse, ir tokių, kurie turi galvijų. ");
INSERT INTO lit_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","O jo brolio vardas buvo Jubalas. Jis buvo tėvas visų tokių, kurie groja lyra ir fleita. ");
INSERT INTO lit_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","O Cila, ji taip pat pagimdė Tubal Kainą, visų bronzos / žalvario ir geležies kalvių mokytoją. O Tubal-Kaino sesuo buvo Naama. ");
INSERT INTO lit_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Ir Lamechas tarė savo žmonoms: „Ada ir Cila, išgirskite mano balsą! Lamecho žmonos, klausykitės mano kalbos! Juk užmušiau vyrą už man padarytą žaizdą, bernioką už man padarytą sužalojimą. ");
INSERT INTO lit_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Jei už Kainą bus atkeršyta septyneriopai, tai už Lamechą septyniasdešimt septynis kartus!“ ");
INSERT INTO lit_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Ir Adomas vėl pažino savo žmoną ir ji pagimdė sūnų ir pavadino jį vardu Setas; „Nes Dievas, – ji sakė, – man paskyrė kitą sėklą vietoje Abelio, kurį Kainas užmušė. ");
INSERT INTO lit_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","O Setui – jam irgi gimė sūnus, ir jis pavadino jį vardu Enošas. Tuo metu žmonės pradėjo šauktis VIEŠPATIES vardo. ");
INSERT INTO lit_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Šita yra Adomo šeimos istorijos duomenų knyga. Tą dieną, kai Dievas sukūrė žmogų, jis padarė jį, turintį panašumų į Dievą; ");
INSERT INTO lit_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","vyriškos lyties ir moteriškos lyties sukūrė jis juos; ir jis palaimino juos ir pavadino juos vardu Adomas tą dieną, kai jie buvo sukurti. ");
INSERT INTO lit_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Ir Adomas pragyveno šimtą trisdešimt metų ir pagimdė sūnų pagal savo panašumą, atitinkantį savo atvaizdą, ir jis pavadino jį vardu Setas. ");
INSERT INTO lit_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Ir Adomo dienos po to, kai pagimdė Setą, sudarė aštuonis šimtus metų, ir jis pagimdė sūnų bei dukterų. ");
INSERT INTO lit_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Taigi visos Adomo dienos, kurias jis gyveno, sudarė devynis šimtus trisdešimt metų, ir jis mirė. ");
INSERT INTO lit_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Ir Setas pragyveno šimtą penkerius metus ir pagimdė Enošą. ");
INSERT INTO lit_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Ir Setas, po to, kai pagimdė Enošą, pragyveno aštuonis šimtus septynerius metus ir pagimdė sūnų bei dukterų. ");
INSERT INTO lit_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Taigi visos Seto dienos sudarė devynis šimtus dvylika metų, ir jis mirė. ");
INSERT INTO lit_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Ir Enošas pragyveno devyniasdešimt metų ir pagimdė Kenaną. ");
INSERT INTO lit_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Ir Enošas, po to, kai pagimdė Kenaną, pragyveno aštuonis šimtus penkiolika metų ir pagimdė sūnų bei dukterų. ");
INSERT INTO lit_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Taigi visos Enošo dienos sudarė devynis šimtus penkerius metus, ir jis mirė. ");
INSERT INTO lit_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Ir Kenanas pragyveno septyniasdešimt metų ir pagimdė Mahalalelį. ");
INSERT INTO lit_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Ir Kenanas, po to, kai pagimdė Mahalalelį, pragyveno aštuonis šimtus keturiasdešimt metų ir pagimdė sūnų bei dukterų. ");
INSERT INTO lit_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Taigi visos Kenano dienos sudarė devynis šimtus dešimt metų, ir jis mirė. ");
INSERT INTO lit_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Ir Mahalalelis pragyveno šešiasdešimt penkerius metus ir pagimdė Jeredą. ");
INSERT INTO lit_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Ir Mahalalelis, po to, kai pagimdė Jeredą, pragyveno aštuonis šimtus trisdešimt metų ir pagimdė sūnų bei dukterų. ");
INSERT INTO lit_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Taigi visos Mahalalelio dienos sudarė aštuonis šimtus devyniasdešimt penkerius metus, ir jis mirė. ");
INSERT INTO lit_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Ir Jeredas pragyveno šimtą šešiasdešimt dvejus metus ir pagimdė Henochą. ");
INSERT INTO lit_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Ir Jeredas, po to, kai pagimdė Henochą, pragyveno aštuonis šimtus metų ir pagimdė sūnų bei dukterų. ");
INSERT INTO lit_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Taigi visos Jeredo dienos sudarė devynis šimtus šešiasdešimt dvejus metus, ir jis mirė. ");
INSERT INTO lit_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Ir Henochas pragyveno šešiasdešimt penkerius metus ir pagimdė Metušelachą. ");
INSERT INTO lit_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Ir Henochas, po to, kai pagimdė Metušelachą, vaikščiojo su Dievu tris šimtus metų ir pagimdė sūnų bei dukterų. ");
INSERT INTO lit_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Taigi visos Henocho dienos sudarė tris šimtus šešiasdešimt penkerius metus. ");
INSERT INTO lit_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Ir Henochas vaikščiojo su Dievu, paskui jo nebebuvo, nes Dievas jį pasiėmė. ");
INSERT INTO lit_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Ir Metušelachas pragyveno šimtą aštuoniasdešimt septynerius metus ir pagimdė Lamechą. ");
INSERT INTO lit_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Ir Metušelachas, po to, kai pagimdė Lamechą, pragyveno septynis šimtus aštuoniasdešimt dvejus metus ir pagimdė sūnų bei dukterų. ");
INSERT INTO lit_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Taigi visos Metušelacho dienos sudarė devynis šimtus šešiasdešimt devynerius metus, ir jis mirė. ");
INSERT INTO lit_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Ir Lamechas pragyveno šimtą aštuoniasdešimt dvejus metus ir pagimdė sūnų, ");
INSERT INTO lit_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","ir pavadino jį vardu Nojus, sakydamas: „Šitas suteiks mums paguodos nuo mūsų darbo ir nuo mūsų rankų vargo dėl dirvos, kurią VIEŠPATS prakeikė.“ ");
INSERT INTO lit_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Ir Lamechas, po to, kai pagimdė Nojų, pragyveno penkis šimtus devyniasdešimt penkerius metus ir pagimdė sūnų bei dukterų. ");
INSERT INTO lit_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Taigi visos Lamecho dienos sudarė septynis šimtus septyniasdešimt septynerius metus, ir jis mirė. ");
INSERT INTO lit_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Ir Nojus buvo penkių šimtų metų, ir jis pagimdė Semą, Chamą ir Jafetą. ");
INSERT INTO lit_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Ir įvyko, kai žmonių pradėjo daugėti žemės paviršiuje ir jiems gimė dukterų, ");
INSERT INTO lit_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","kad Dievo sūnūs matė žmonių dukteris, kad jos gražios, ir ėmė sau į žmonas iš visų, kurias jie išsirinko. ");
INSERT INTO lit_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Ir VIEŠPATS tarė: „Mano Dvasia nesivaidys su žmogumi amžinai, nes jis yra ir kūniškas. Vis dėlto jo dienų bus šimtas dvidešimt metų. ");
INSERT INTO lit_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Anomis dienomis žemėje buvo milžinų, – taip pat vėliau, kai Dievo sūnūs įeidavo pas žmonių dukteris ir jos gimdydavo jiems vaikų. Tie buvo senovės galiūnai, garsūs vyrai. ");
INSERT INTO lit_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Ir VIEŠPATS matė, kad žmogaus blogumas žemėje buvo gausus, ir kad kiekvienas jo širdies minčių siekimas visuomet buvo tik blogas. ");
INSERT INTO lit_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Ir gailėjosi VIEŠPATS, kad jis žemėje sukūrė žmogų, ir jam gėlė širdį. ");
INSERT INTO lit_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Ir VIEŠPATS tarė: „Aš pragaišinsiu žmogų, kurį sukūriau, nuo žemės paviršiaus, – nuo žmogaus iki gyvulio, iki ropojančio padaro, iki padangių paukščio, – nes gailiuosi juos padaręs.“ ");
INSERT INTO lit_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Tačiau Nojus rado malonę VIEŠPATIES akyse. ");
INSERT INTO lit_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Šitie yra Nojaus šeimos istorijos duomenys: Nojus buvo teisus žmogus, jis buvo nepriekaištingas tarp savo amžininkų; Nojus vaikščiojo su Dievu. ");
INSERT INTO lit_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Ir Nojus pagimdė tris sūnus: Semą, Chamą ir Jafetą. ");
INSERT INTO lit_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Bet žemė buvo sugedusi Dievo akyse, ir žemė buvo pripildyta smurto. ");
INSERT INTO lit_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Ir Dievas matė žemę, ir štai ji buvo sugedusi, nes žemėje sugadino savo kelius kiekviena kūną turinti būtybė. ");
INSERT INTO lit_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Ir Dievas tarė Nojui: „Kiekvienos kūną turinčios būtybės galas yra atėjęs mano akivaizdon, nes per juos žemė pasidarė pilna smurto. Ir štai pragaišinsiu juos drauge su žeme. ");
INSERT INTO lit_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Pasidaryk arką iš gofero medžio; arkoje padaryk kambarių ir padenk ją derva iš vidaus ir iš lauko. ");
INSERT INTO lit_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ir štai kaip tu turi ją padaryti: arkos ilgis turi būti trys šimtai uolekčių, jos plotis – penkiasdešimt uolekčių, ir jos aukštis – trisdešimt uolekčių. ");
INSERT INTO lit_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Padaryk šviesos angą arkai, ir užbaik ją per uolektį nuo viršaus; taip pat arkos vieninteles duris įstatyk jos šone; padaryk ją su apatiniu, antru ir trečiu aukštu. ");
INSERT INTO lit_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Ir aš, štai aš ruošiuosi siųsti vandenų tvaną ant žemės pragaišinti po dangumi kiekvieną kūną turinčią būtybę, kurioje yra gyvybės kvėpavimas; visa, kas yra žemėje, pražus. ");
INSERT INTO lit_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Bet su tavimi aš tvirtinsiu savo sandorą: tu įeisi į arką, tu ir tavo sūnūs, ir tavo žmona, ir tavo sūnų žmonos su tavimi. ");
INSERT INTO lit_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Ir iš kiekvieno gyvo padaro iš visų kūną turinčių būtybių, tu turi priversti patekti į arką po du iš kiekvienos rūšies, kad išlaikytum juos gyvus su savimi; jie turi būti patinas ir patelė. ");
INSERT INTO lit_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Kad išliktų gyvi, turės patekti pas tave po du iš kiekvienos rūšies, – iš paukščių pagal jų rūšis ir iš gyvulių pagal jų rūšis, iš visų žemės ropojančių padarų pagal jų rūšis. ");
INSERT INTO lit_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Taip pat pasiimk visokio valgomo maisto ir susikrauk pas save. Ir tai bus maistas tau ir jiems.“ ");
INSERT INTO lit_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Ir Nojus padarė pagal visa, ką Dievas buvo jam įsakęs, – būtent taip padarė. ");
INSERT INTO lit_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Ir VIEŠPATS tarė Nojui: „Įeik į arką tu ir visi tavo namiškiai, nes šioje kartoje mačiau tave esant teisų prieš mane. ");
INSERT INTO lit_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Pasiimk iš visų švariųjų gyvulių septynis ir septynias (po patiną ir jo patelę), ir iš gyvulių, kurie nešvarūs, pasiimk du (po patiną ir jo patelę), ");
INSERT INTO lit_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","taip pat iš padangės paukščių septynis ir septynias (po patiną ir patelę), kad atžala būtų išlaikyta gyva ant visos žemės paviršiaus. ");
INSERT INTO lit_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Nes dar septynios dienos, ir aš siųsiu žemėn lietų keturiasdešimčiai dienų ir keturiasdešimčiai naktų ir pražudysiu nuo žemės paviršiaus visas būtybes, kurias esu padaręs.“ ");
INSERT INTO lit_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Ir Nojus padarė pagal visa, ką VIEŠPATS buvo jam įsakęs. ");
INSERT INTO lit_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Ir Nojus buvo šešių šimtų metų, kai vandenų tvanas užliejo žemę. ");
INSERT INTO lit_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Ir Nojus ir jo sūnūs, ir jo žmona, ir jo sūnų žmonos įėjo su juo į arką dėl tvano vandenų. ");
INSERT INTO lit_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Iš švariųjų gyvulių ir iš gyvulių, kurie nešvarūs, ir iš paukščių, ir iš visų gyvūnų, judančių ant žemės, ");
INSERT INTO lit_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","po du, patinas ir patelė, įėjo pas Nojų į arką, kaip Dievas buvo Nojui įsakęs. ");
INSERT INTO lit_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Ir taip įvyko po septynių dienų, kad tvano vandenys atsirado ant žemės. ");
INSERT INTO lit_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Šeši šimtaisiais Nojaus gyvenimo metais, antrąjį mėnesį, septynioliktąją to mėnesio dieną, – tą dieną pratrūko visi didžiosios gelmės šaltiniai, ir dangaus langai atsidarė. ");
INSERT INTO lit_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Ir lietus lijo ant žemės keturiasdešimt dienų ir keturiasdešimt naktų. ");
INSERT INTO lit_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Tą pačią dieną įėjo į arką Nojus ir Nojaus sūnūs Semas, Chamas, bei Jafetas, taip pat su jais Nojaus žmona ir trys jo sūnų žmonos, – ");
INSERT INTO lit_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","jie ir visokie žvėrys pagal jų rūšį, ir visokie galvijai pagal jų rūšį, ir visokie ropojantys padarai, kurie juda ant žemės, pagal jų rūšį, ir visokie paukščiai pagal jų rūšį – visi visokių sparnų paukšteliai. ");
INSERT INTO lit_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Ir jie įėjo pas Nojų į arką, po du iš visų kūną turinčių būtybių, kuriose yra gyvybės kvėpavimas. ");
INSERT INTO lit_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Ir kurie įėjo, įėjo patinas ir patelė iš kiekvieno kūno rūšies, kaip Dievas jam buvo įsakęs; ir VIEŠPATS už jo uždarė duris. ");
INSERT INTO lit_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Ir tvanas žemėje tęsėsi keturiasdešimt dienų; ir vandenys daugėjo ir pakėlė arką, ir ji pakilo aukštai viršum žemės. ");
INSERT INTO lit_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Ir vandenys pritvino ir labai padaugėjo ant žemės, o arka plūduriavo ant vandenų paviršiaus. ");
INSERT INTO lit_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Tai vandenys labai labai pritvino ant žemės, ir visi aukštieji kalnai, esantys po visu dangumi, buvo apsemti. ");
INSERT INTO lit_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Pritvino vandenų penkiolika uolekčių aukščiau, ir buvo apsemti kalnai. ");
INSERT INTO lit_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Ir žuvo visos kūną turinčios būtybės, kurios judėjo ant žemės: paukščiai ir galvijai ir žvėrys ir visi knibždantys padarai, kurie knibžda ant žemės, ir visi žmonės. ");
INSERT INTO lit_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Visi, kurie tik buvo sausumoje, kurių šnervėse buvo gyvybės dvasios alsavimas, mirė. ");
INSERT INTO lit_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Taip jis pragaišino visas būtybes, buvusias dirvos paviršiuje – nuo žmogaus iki gyvulio, iki ropojančio padaro, iki padangės paukščio. Jie juk buvo pragaišinti nuo žemės, o išliko tik Nojus ir tie, kurie buvo su juo arkoje. ");
INSERT INTO lit_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Pritvino vandenų ant žemės šimtą penkiasdešimt dienų. ");
INSERT INTO lit_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Ir Dievas atsiminė Nojų ir visus gyvus padarus bei visus gyvulius, kurie buvo su juo arkoje; ir Dievas siuntė vėją pūsti virš žemės, ir vandenys atslūgo. ");
INSERT INTO lit_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Be to, gelmės šaltiniai ir dangaus langai buvo uždaryti ir buvo sulaikytas lietus iš dangaus, ");
INSERT INTO lit_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","ir vandenys vis traukėsi atgal nuo žemės, o pasibaigus šimtui penkiasdešimčiai dienų, vandenys nuslūgo. ");
INSERT INTO lit_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Ir septintą mėnesį, septynioliktąją to mėnesio dieną, arka nusėdo ant Ararato kalnų. ");
INSERT INTO lit_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Ir vandenys vis slūgo iki dešimtojo mėnesio. Dešimtąjį mėnesį, to mėnesio pirmąją dieną, pasirodė kalnų viršūnės. ");
INSERT INTO lit_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Taip įvyko, kad pasibaigus keturiasdešimčiai dienų, Nojus atidarė arkos langą, kurį buvo įtaisęs, ");
INSERT INTO lit_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ir išleido varną, kuris išlėkė – tai išskrisdavo, tai parskrisdavo, kol žemėje nudžiuvo vandenys. ");
INSERT INTO lit_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Taip pat jis išleido nuo savęs balandį pažiūrėti, ar vandenys buvo nusekę žemės paviršiuje. ");
INSERT INTO lit_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Ir įvyko šeši šimtai pirmaisiais metais, pirmąjį mėnesį, pirmąją to mėnesio dieną, kad vandenys buvo nudžiuvę žemėje. Ir Nojus nukėlė arkos dangtį ir pasižiūrėjo, ir štai dirvos paviršius buvo sausas. ");
INSERT INTO lit_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ir antrąjį mėnesį, dvidešimt septintąją to mėnesio dieną, žemė buvo sausa. ");
INSERT INTO lit_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Tada Dievas kalbėjo Nojui, sakydamas: ");
INSERT INTO lit_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","„Išeik iš arkos tu ir tavo žmona, ir tavo sūnūs, ir tavo sūnų žmonos su tavimi. ");
INSERT INTO lit_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Išvesk su savimi visus gyvus padarus, esančius su tavimi, iš visų kūną turinčių būtybių, tiek iš paukščių, tiek iš gyvulių, tiek iš visų ropojančių padarų, kurie juda ant žemės, kad jie gausiai veistųsi žemėje ir būtų vaisingi, ir daugintųsi žemėje. ");
INSERT INTO lit_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Ir Dievas palaimino Nojų bei jo sūnus ir jiems tarė: „Būkite vaisingi ir dauginkitės ir pripildykite žemę. ");
INSERT INTO lit_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Ir bijos jūsų ir baidysis jūsų visi žemės laukiniai žvėrys ir visi padangių paukščiai; jie yra atiduoti į jūsų ranką drauge su visais, kurie juda ant žemės, ir drauge su visomis jūros žuvimis. ");
INSERT INTO lit_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Visi gyvi judantys padarai bus jums maistui. Kaip atidaviau žalius augalus, taip atiduodu jums viską. ");
INSERT INTO lit_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Bet mėsos su jo gyvybe, kuri yra jo kraujas, nevalgykite. ");
INSERT INTO lit_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Ir už jūsų kraują, nuo kurio priklauso jūsų gyvybės, būtinai pareikalausiu atsiskaityti: iš kiekvieno gyvo padaro pareikalausiu atsiskaityti už jį, ir iš žmogaus. Iš kiekvieno žmogų nužudžiusio žmogaus pareikalausiu atsiskaityti už brolio gyvybę. ");
INSERT INTO lit_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Kas pralieja žmogaus kraują, to kraujas turi būti žmogaus pralietas, nes Dievas padarė žmogų pagal savo atvaizdą. ");
INSERT INTO lit_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","O jūs būkite vaisingi ir dauginkitės, gausėkite žemėje ir dauginkitės joje!“ ");
INSERT INTO lit_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Tada Dievas kalbėjo Nojui ir jo sūnums, esantiems su juo, sakydamas: ");
INSERT INTO lit_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","„Ir aš, štai aš tvirtinu savo sandorą su jumis ir jūsų palikuonimis, kurie bus po jūsų, ");
INSERT INTO lit_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","ir su visais gyvais padarais, esančiais su jumis: su paukščiais, su gyvuliais, su laukiniais žvėrimis, esančiais su jumis – su visais, kurie išeina iš arkos, – su visais žemės gyvūnais. ");
INSERT INTO lit_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Ir tvirtinu savo sandorą su jumis: niekada daugiau visos kūną turinčios būtybės nebebus tvano vandenų pašalintos ir niekada daugiau nebebus tvano žemei nuniokoti.“ ");
INSERT INTO lit_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Ir Dievas tarė: „Šitas yra ženklas sandoros, kurią aš sudarau tarp savęs ir jūsų bei visų su jumis gyvų padarų, nesibaigiančioms kartoms: ");
INSERT INTO lit_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","savo lanką padedu į debesį, ir jis bus ženklas sandoros tarp manęs ir žemės. ");
INSERT INTO lit_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Ir įvyks taip, kad, kai užleisiu debesį virš žemės, lankas pasirodys debesyje, ");
INSERT INTO lit_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ir aš atsiminsiu savo sandorą, esančią tarp manęs ir jūsų bei visų gyvų padarų iš visų kūną turinčių būtybių; ir vandenys daugiau nevirs tvanu visoms kūną turinčioms būtybėms pragaišinti. ");
INSERT INTO lit_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Ir Nojus pabudo nuo savo vyno ir sužinojo, ką jam buvo padaręs jo jaunas sūnus. ");
INSERT INTO lit_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Ir jis tarė: „Tebūna prakeiktas Kanaanas! Jis bus tarnų tarnas savo broliams!“ ");
INSERT INTO lit_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Ir jis tarė: „Palaimintas tebūna VIEŠPATS, Semo Dievas! O Kanaanas tebūna tarnas jiems. ");
INSERT INTO lit_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Dievas teišplečia Jafetą, ir tasai teapsigyvena Semo palapinėse, ir Kanaanas tebūna tarnas tam.“ ");
INSERT INTO lit_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Štai šitie yra Nojaus sūnų Semo, Chamo ir Jafeto šeimų istorijos duomenys. Po tvano jiems gimė sūnų. ");
INSERT INTO lit_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Ir visa žemė turėjo vienodą kalbą ir vienodus žodžius. ");
INSERT INTO lit_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Ir įvyko, kad keliaudami iš rytų jie rado lygumą Šinaro šalyje ir ten apsigyveno. ");
INSERT INTO lit_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Ir jie sakė vienas kitam: „Eime, pasidirbkime plytų ir jas gerai išdekime. (O plytų jie turėjo vietoj akmenų, ir bitumo jie turėjo vietoj molinio plyšių glaisto.) ");
INSERT INTO lit_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Ir jie tarė: „Eime, pasistatykime sau miestą ir bokštą, kurio viršūnė danguose, ir pasidarykime sau vardą, kad nebūtume išsklaidyti po visos žemės paviršių.“ ");
INSERT INTO lit_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Ir VIEŠPATS nužengė pamatyti miesto ir bokšto, kurį žmonių palikuonys statė. ");
INSERT INTO lit_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Ir VIEŠPATS tarė: „Štai viena tauta, ir viena kalba jiems visiems, ir štai ką jie pradėjo veikti! O kad nuo šiol nebūtų taip, kad ką tik jie sumanys daryti būtų be suvaržymo, ");
INSERT INTO lit_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","eime, nuženkime ir ten sumaišykime jų kalbą, kad jie nesuprastų vienas kito kalbos.“ ");
INSERT INTO lit_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Taip VIEŠPATS juos išsklaidė iš ten po visos žemės paviršių, ir jie nustojo statę miestą. ");
INSERT INTO lit_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Todėl pavadino jį vardu Babelis, nes ten VIEŠPATS sumaišė visos žemės kalbą ir iš ten VIEŠPATS juos išsklaidė po visos žemės paviršių. ");
INSERT INTO lit_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Šie yra Šemo šeimos istorijos duomenys: Šemas buvo šimto metų ir pagimdė Arpachšadą dvejiems metams praėjus po tvano. ");
INSERT INTO lit_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Ir Šemas, po to, kai pagimdė Arpachšadą, gyveno penkis šimtus metų ir pagimdė sūnų bei dukterų. ");
INSERT INTO lit_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Ir Arpachšadas pragyveno trisdešimt penkerius metus ir pagimdė Šelachą. ");
INSERT INTO lit_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Ir Arpachšadas, po to, kai pagimdė Šelachą, gyveno keturis šimtus trejus metus ir pagimdė sūnų bei dukterų. ");
INSERT INTO lit_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Ir Šelachas pragyveno trisdešimt metų ir pagimdė Eberą. ");
INSERT INTO lit_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Ir Šelachas, po to, kai pagimdė Eberą, gyveno keturis šimtus trejus metus ir pagimdė sūnų bei dukterų. ");
INSERT INTO lit_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ir Eberas pragyveno trisdešimt ketverius metus ir pagimdė Pelegą. ");
INSERT INTO lit_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Ir Eberas, po to, kai pagimdė Pelegą, gyveno keturis šimtus trisdešimt metų ir pagimdė sūnų bei dukterų. ");
INSERT INTO lit_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Ir Pelegas pragyveno trisdešimt metų ir pagimdė Rejų. ");
INSERT INTO lit_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Ir Pelegas, po to, kai pagimdė Rejų, gyveno du šimtus devynerius metus ir pagimdė sūnų bei dukterų. ");
INSERT INTO lit_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Ir Rejus pragyveno trisdešimt dvejus metus ir pagimdė Serugą. ");
INSERT INTO lit_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Ir Rejus, po to, kai pagimdė Serugą, gyveno du šimtus septynerius metus ir pagimdė sūnų bei dukterų. ");
INSERT INTO lit_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Ir Serugas pragyveno trisdešimt metų ir pagimdė Nachorą. ");
INSERT INTO lit_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Ir Serugas, po to, kai pagimdė Nachorą, gyveno du šimtus metų ir pagimdė sūnų bei dukterų. ");
INSERT INTO lit_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Ir Nachoras pragyveno dvidešimt devynerius metus ir pagimdė Terachą. ");
INSERT INTO lit_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Ir Nachoras, po to, kai pagimdė Terachą, gyveno šimtą devyniolika metų ir pagimdė sūnų bei dukterų. ");
INSERT INTO lit_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Ir Terachas pragyveno septyniasdešimt metų ir pagimdė Abramą, Nachorą ir Haraną. ");
INSERT INTO lit_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Štai šitie yra Teracho šeimos istorijos duomenys: Terachas pagimdė Abramą, Nachorą ir Haraną. O Haranas pagimdė Lotą. ");
INSERT INTO lit_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Ir Haranas mirė savo tėvo Teracho akivaizdoje savo gimtojoje šalyje, chaldėjų Ūre. ");
INSERT INTO lit_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","O Abramas ir Nahoras ėmė sau žmonas. Abramo žmonos vardas buvo Saraja, o Nachoro žmonos vardas Milka, kuri buvo duktė Harano, kuris buvo Milkos tėvas ir Iskos tėvas. ");
INSERT INTO lit_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","O Saraja buvo nevaisinga; jokio vaiko ji neturėjo. ");
INSERT INTO lit_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Ir Terachas paėmė savo sūnų Abramą ir Harano sūnų Lotą, kuris buvo jo vaikaitis, ir savo marčią Sarają, kuri buvo jo sūnaus Abramo žmoną. Ir jie išvyko su jais iš chaldėjų Ūro, kad nukeliautų į Kanaano šalį. O atėję ligi Harano, jie ten apsigyveno. ");
INSERT INTO lit_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Ir Teracho dienos sudarė du šimtus penkerius metus, ir Terachas mirė Harane. ");
INSERT INTO lit_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Ir VIEŠPATS buvo taręs Abramui: „Eik iš savo šalies ir iš savo giminės ir iš savo tėvo namų į šalį, kurią tau parodysiu. ");
INSERT INTO lit_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Ir padarysiu iš tavęs didelę tautą ir laiminsiu tave, ir padarysiu didį tavo vardą, ir tu būsi palaiminimas. ");
INSERT INTO lit_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Ir laiminsiu tave laiminančius, bet prakeiksiu tave prakeikiantį; ir tavyje bus palaimintos visos žemės šeimų grupės.“ ");
INSERT INTO lit_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Taigi Abramas išvyko, kaip VIEŠPATS jam buvo pasakęs, ir su juo vyko Lotas; ir Abramas buvo septyniasdešimt penkerių metų, kai išvyko iš Harano. ");
INSERT INTO lit_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Ir Abramas pasiėmė savo žmoną Sarają ir savo brolio sūnų Lotą ir visą jų turtą, kurį jie buvo sukaupę, ir asmenis, kuriuos jie buvo įsigiję Harane. Ir jie išvyko, kad nukeliautų į Kanaano šalį, ir atvyko į Kanaano šalį. ");
INSERT INTO lit_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Ir Abramas perėjo per tą šalį iki Šechemo vietovės, iki Morės lygumos. O anuomet kanaaniečiai buvo toje šalyje. ");
INSERT INTO lit_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Ir VIEŠPATS pasirodė Abramui ir tarė: „Tavo sėklai aš duosiu šitą šalį.“ Ir jis ten pastatė aukurą VIEŠPAČIUI, kuris jam pasirodė. ");
INSERT INTO lit_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Ir VIEŠPATS užgavo faraoną ir jo namus didelėmis rykštėmis dėl Sarajos, Abramo žmonos. ");
INSERT INTO lit_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Tada Abramas keliavo aukštyn iš Egipto – jis ir jo žmona ir visa, kas jam priklausė, bei Lotas su juo, – į Negebą. ");
INSERT INTO lit_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Ir VIEŠPATS tarė Abramui, kai Lotas buvo nuo jo atsiskyręs: „Pakelk dabar savo akis ir pažvelk iš vietos, kurioje esi, į šiaurę ir į pietus, į rytus ir į vakarus, ");
INSERT INTO lit_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","nes visą šalį, kurią matai, duosiu tau ir tavo palikuonijai amžiams. ");
INSERT INTO lit_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ir padarysiu tavo palikuoniją kaip žemės dulkes taip, kad jei kas galėtų suskaičiuoti žemės dulkes, tai ir tavo palikuonija galėtų būti suskaičiuota. ");
INSERT INTO lit_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Kelkis, pereik šalį išilgai ir skersai, nes tau ją duosiu. ");
INSERT INTO lit_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Ir įvyko Šinaro karaliaus Amrafelio, Elasaro karaliaus Arjocho, Elamo karaliaus Kedorlaomero ir tautų karaliaus Tidalo dienomis, ");
INSERT INTO lit_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","kad šitie kariavo su Sodomos karaliumi Bera ir su Gomoros karaliumi Birša, Admos karaliumi Šinabu ir Ceboimo karaliumi Šemeberiu, ir Belos, tai yra Coaro, karaliumi. ");
INSERT INTO lit_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Tie visi susivienijo Sidimo slėnyje, kuris yra Druskos jūra. ");
INSERT INTO lit_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Dvylika metų jie priverstinai tarnavo Kedorlaomerui, o tryliktaisiais metais sukilo. ");
INSERT INTO lit_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Ir keturioliktaisiais metais atėjo Kedorlaomeras ir su juo esantys karaliai ir sumušė refajus Ašterot Karnaime, ir zuzus Hame, ir emus Šave Kirjataime, ");
INSERT INTO lit_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ir horus jų kalnyne, Seyre, iki pat prie dykumos esančio El Parano. ");
INSERT INTO lit_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Ir jie apsigręžė ir atėjo į En Mišpatą, tai yra Kadešą, ir nukariavo visą amalekiečių kraštą, taip pat amoritus, gyvenusius Hacecon Tamaroje. ");
INSERT INTO lit_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Ir išėjo Sodomos karalius, Gomoros karalius, Admos karalius, Ceboimo karalius ir Belos, tai yra Coaro, karalius, ir jie stojo į mūšį su jais Sidimo slėnyje: ");
INSERT INTO lit_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","su Elamo karaliumi Kedorlaomeru, ir tautų karaliumi Tidalu, ir Šinaro karaliumi Amrafeliu, ir Elasaro karaliumi Arjochu – keturi karaliai prieš penkis. ");
INSERT INTO lit_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Ir padalinęs pajėgas prieš juos, naktį jis ir jo tarnai sumušė juos, ir vijosi juos iki Hobos, esančios Damasko kairėje. ");
INSERT INTO lit_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Ir jis pargabeno visą turtą, pargabeno ir savo brolį Lotą ir jo turtą, taip pat moteris ir kitus žmones. ");
INSERT INTO lit_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Ir po Abramo sugrįžimo iš Kedorlaomero ir su juo buvusių karalių nukovimo, Sodomos karalius išėjo jo pasitikti į Šavės slėnį, tai yra Karaliaus slėnį. ");
INSERT INTO lit_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Ir Melchizedekas, Salemo karalius, išnešė duonos ir vyno; ir jis buvo Dievo Aukščiausiojo kunigas. ");
INSERT INTO lit_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Ir jis palaimino jį tardamas: „Tegul palaimina Abramą Dievas Aukščiausiasis, dangaus ir žemės savininkas! ");
INSERT INTO lit_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Ir tebūna palaimintas Dievas Aukščiausiasis, kuris atidavė tavo priešus į tavo ranką!“ Ir jis davė jam nuo visko dešimtinę. ");
INSERT INTO lit_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Po šių dalykų VIEŠPATIES žodis atėjo Abramui regėjime, sakydamas: „Nebijok, Abramai! Aš esu tavo skydas, tavo labai apstus atlygis.“ ");
INSERT INTO lit_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Ir, išvedęs jį laukan, tarė: „Malonėk įbesti akis į dangų ir suskaičiuoti žvaigždes, jei gali jas suskaičiuoti!“ Ir jis jam tarė: „Tokia bus tavo sėkla.“ ");
INSERT INTO lit_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Ir jis pasitikėjo VIEŠPAČIU, o jis įskaitė tai jam kaip teisumą. ");
INSERT INTO lit_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Ir jis tarė Abramui: „Žinok užtikrintai, kad keturis šimtus metų tavo palikuonija bus ateivis ne nesavoje šalyje (jie gi svetimiesiems tarnaus, o anie juos kamuos). ");
INSERT INTO lit_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Bet ir tautai, kuriai jie tarnaus, aš įvykdysiu teisingumą, o po to jie išvyks su dideliu turtu. ");
INSERT INTO lit_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","O tu nueisi pas savo tėvus ramybėje; tu būsi palaidotas žiloje senatvėje. ");
INSERT INTO lit_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Bet ketvirtoje kartoje jie čia sugrįš, nes amoritų blogybės saikas dar nepilnas.“ ");
INSERT INTO lit_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Tą pačią dieną VIEŠPATS tvirtino su Abramu sandorą, sakydamas: „Tavo sėklai aš daviau šitą šalį nuo Egipto upės iki didžiosios upės, – Eufrato upės – ");
INSERT INTO lit_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Ir kai Abramas buvo devyniasdešimt devynerių metų, VIEŠPATS pasirodė Abramui ir jam tarė: „Aš esu Visagalis Dievas; vaikščiok mano akivaizdoje ir būk nepriekaištingas. ");
INSERT INTO lit_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ir aš sudarysiu savo sandorą tarp savęs ir tavęs ir nepaprastai tave padauginsiu.“ ");
INSERT INTO lit_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Ir Abramas parpuolė kniūbsčias, ir Dievas kalbėjo su juo, tardamas: ");
INSERT INTO lit_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","„O mano, štai mano sandora yra su tavimi, ir tu būsi daugelio tautų tėvu. ");
INSERT INTO lit_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Ir nebesivadinsi vardu Abramas, bet tavo vardas bus Abraomas, nes padariau tave daugelio tautų tėvu. ");
INSERT INTO lit_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Tebūnie toli nuo tavęs taip pasielgti – nužudyti teisųjį su nedorėliu, kad teisiajam atsitiktų taip, kaip nedorėliui! Toli tai tebūnie nuo tavęs! Ar visos žemės Teisėjas nedarys tai, kas teisinga?“ ");
INSERT INTO lit_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Ir įvyko, kai jie juos išvedė laukan, jis tarė: „Paspruk dėl savo gyvybės! Nežiūrėk atgal ir nesustok niekur lygumoje! Bėk į kalną, kad nebūtum pražudytas!“ ");
INSERT INTO lit_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Tada VIEŠPATS liejo ant Sodomos ir Gomoros sierą ir ugnį nuo VIEŠPATIES, iš dangaus, ");
INSERT INTO lit_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","ir pargriovė tuos miestus ir visą lygumą ir visus miestų gyventojus ir dirvos augalus. ");
INSERT INTO lit_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","O jo žmona, eidama iš paskos, žiūrėjo atgal ir pavirto druskos stulpu. ");
INSERT INTO lit_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Be to, iš tiesų ji yra mano sesuo. Ji yra mano tėvo duktė, bet ne mano motinos duktė, ir ji tapo mano žmona. ");
INSERT INTO lit_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Ir Sara tarė: „Dievas padarė taip, kad juokiausi; visi, kurie girdės, juoksis su manimi.“ ");
INSERT INTO lit_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Ir Abraomas atsikėlė anksti ryte ir paėmė duonos bei odinę vandens ir užkėlęs tai ant jos peties davė tai ir vaiką Hagarai ir ją išsiuntė; ir ji išėjo ir klaidžiojo Beer Šebos dykumoje. ");
INSERT INTO lit_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Ir įvyko po tų dalykų, kad Dievas išmėgino Abraomą ir jam tarė: „Abraomai!“ Ir jis tarė: „Aš čia!“ ");
INSERT INTO lit_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Ir jis tarė: „Meldžiu tave, imk savo sūnų, savo vienintelį, kurį tu myli, Izaoką, ir eik į Morijos šalį; ir ten paaukok jį kaip deginamąją auką ant vieno iš kalnų, kurį tau nurodysiu.“ ");
INSERT INTO lit_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Ir Izaokas kalbėjo savo tėvui Abraomui, tardamas: „Mano tėve!“ O tas tarė: „Aš čia, mano sūnau.“ Ir jis tarė: „Štai ugnis ir malkos, bet kur yra tas avinėlis deginamajai aukai?“ ");
INSERT INTO lit_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ir Abraomas tarė: „Dievas sau parūpins tam tikrą avinėlį deginamajai aukai, mano sūnau.“ Taip jiedu drauge ėjo toliau. ");
INSERT INTO lit_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Ir jie atėjo į vietą, apie kurią Dievas jam buvo kalbėjęs, ir Abraomas ten pastatė aukurą ir eilėmis išklojo malkas ir surišo savo sūnų Izaoką ir uždėjo jį ant aukuro virš malkų. ");
INSERT INTO lit_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Ir Abraomas ištiesė savo ranką ir paėmė peilį tam, kad papjautų savo sūnų. ");
INSERT INTO lit_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Bet VIEŠPATIES angelas sušuko jam iš dangaus tardamas: „Abraomai, Abraomai!“ Ir jis tarė: „Aš čia!“ ");
INSERT INTO lit_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Ir jis tarė: „Netiesk savo rankos prieš berniuką ir nieko jam nedaryk! Nes dabar žinau, kad bijai Dievo, kadangi tu nesulaikei nuo manęs savo sūnaus, savo vienintelio sūnaus.“ ");
INSERT INTO lit_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ir Abraomas, pakėlęs savo akis, žiūrėjo, ir štai jam už nugaros avinas tankmėje įstrigęs savo ragais. Tai Abraomas priėjo ir paėmė aviną, ir paaukojo jį kaip deginamąją auką vietoj savo sūnaus. ");
INSERT INTO lit_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Ir Abraomas praminė tą vietą „Jehova-Jireh“; kaip yra sakoma iki šios dienos: „VIEŠPATIES kalne bus parūpinta“. ");
INSERT INTO lit_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Ir Abraomas buvo pasenęs, sulaukęs senyvo amžiaus, ir VIEŠPATS buvo laiminęs Abraomą visapusiškai. ");
INSERT INTO lit_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Ir Abraomas tarė savo tarnui, savo namų ūkio vyriausiajam, kuris valdė visa, kas jam priklausė: „Na, dėk savo ranką po mano šlaunimi, ");
INSERT INTO lit_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","ir aš prisaikdinsiu tave VIEŠPAČIU, dangaus Dievu ir žemės Dievu, kad mano sūnui tu neimsi žmonos iš dukterų kanaaniečių, tarp kurių aš gyvenu, ");
INSERT INTO lit_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","bet nuvyksi į mano kraštą ir pas mano giminę ir paimsi žmoną mano sūnui Izaokui.“ ");
INSERT INTO lit_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Ir šitie yra Abraomo sūnaus Izaoko šeimos istorijos duomenys: Abraomas pagimdė Izaoką; ");
INSERT INTO lit_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","o Izaokas buvo keturiasdešimties metų, kai jis ėmė į žmonas Rebeką, aramėjo Betuelio iš Padan Aramo dukterį, aramėjo Labano seserį. ");
INSERT INTO lit_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Ir Izaokas uoliai maldavo VIEŠPATĮ už savo žmoną, nes ji buvo nevaisinga; o VIEŠPATS patenkino uolų maldavimą, ir jo žmona Rebeka tapo nėščia. ");
INSERT INTO lit_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Ir berniukai augo; ir Ezavas buvo sumanus medžiotojas, lauko vyras; o Jokūbas buvo ramus žmogus, gyvenąs palapinėse. ");
INSERT INTO lit_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","O Jokūbas išvyko iš Beer Šebos ir vyko Harano link. ");
INSERT INTO lit_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Ir užtikęs tam tikrą vietą, jis ten nakvojo, nes saulė jau buvo nusileidusi. Ir paėmęs iš tos vietos akmenų, jis pasidėjo prie savo galvos, ir toje vietoje atsigulė miegoti. ");
INSERT INTO lit_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Ir štai aš esu su tavimi ir tave saugosiu visur, kur eisi ir tave sugrąžinsiu į šią šalį, nes nepaliksiu tavęs, kol neįvykdysiu, ką esu tau pažadėjęs.“ ");
INSERT INTO lit_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Ir Jokūbas pabudo iš miego ir tarė: „Tikrai VIEŠPATS yra šioje vietoje, o aš nežinojau!“ ");
INSERT INTO lit_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Ir jis bijojo ir tarė: „Kokia bauginanti ši vieta! Tai ne kas kita, kaip tik Dievo namai, ir tai dangaus vartai!“ ");
INSERT INTO lit_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Tada Jokūbas vėl leidosi kelionėn ir atvyko į rytiečių šalį. ");
INSERT INTO lit_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Ir VIEŠPATS, matydamas, kad Lėja, lyginant su Rachele, buvo nekenčiama, atidarė jos įsčias, bet Rachelė buvo nevaisinga. ");
INSERT INTO lit_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","ir sakykite: „Štai ir tavo tarnas Jokūbas yra mums iš paskos. (Nes jis tarė: „Aš sutaikinsiu jį dovana, kuri eina pirma manęs, o paskui išvysiu jo veidą; galbūt jis mane priims.“) ");
INSERT INTO lit_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Ir Jokūbas gyveno šalyje, kurioje jo tėvas buvo laikinas gyventojas, Kanaano šalyje. ");
INSERT INTO lit_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Šitie yra Jokūbo šeimos istorijos duomenys. Septyniolikos metų sūnui Juozapui teko ganyti kaimenę su savo broliais, o berniukas buvo su savo tėvo žmonų Bilhos ir Zilpos sūnumis; ir Juozapas parnešdavo savo tėvui blogų žinių apie juos. ");
INSERT INTO lit_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","O Izraelis mylėjo Juozapą labiau už visus kitus savo vaikus, nes jis buvo jo senatvės sūnus, ir jis padarė jam margaspalvį drabužį. ");
INSERT INTO lit_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Ir jo broliai, pastebėję, kad jų tėvas jį mylėjo labiau už visus jo brolius, nekentė jo ir negalėjo su juo taikingai kalbėti. ");
INSERT INTO lit_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Ir Juozapas sapnavo sapną ir papasakojo jį savo broliams. Tada jie dar labiau jo nekentė. ");
INSERT INTO lit_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Ir jis jiems tarė: „Na, pasiklausykite šio sapno, kurį sapnavau! ");
INSERT INTO lit_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Antai mes rišome pėdus laukuose, ir štai mano pėdas atsikėlė ir pasiliko stačias, o štai jūsų pėdai sustojo aplinkui ir nusilenkė mano pėdui. ");
INSERT INTO lit_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Tada vienas vyras sutiko jį, ir štai – šis klaidžioja po lauką! Ir tas vyras jo paklausė, sakydamas: „Ko ieškai?“ ");
INSERT INTO lit_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Eime, parduokime jį izmaelitams, bet savo rankos nekelkime prieš jį, nes jis yra mūsų brolis, mūsų kūnas! Ir jo broliai paklausė. ");
INSERT INTO lit_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Einant pro šalį midjaniečiams pirkliams, jie Juozapą pakėlė ir ištraukė iš duobės. Jie tada pardavė Juozapą izmaelitams už dvidešimt sidabrinių. O tie nusivedė Juozapą į Egiptą. ");
INSERT INTO lit_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Ir VIEŠPATS buvo su Juozapu, ir jis buvo sėkmingas vyras, ir jis buvo savo šeimininko egiptiečio namuose. ");
INSERT INTO lit_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Ir nuo to laiko, kai jis paskyrė jį prižiūrėtoju savo namuose ir prižiūrėtoju visko, kas jam priklausė, taip įvyko, kad VIEŠPATS dėl Juozapo laimino egiptiečio namus. Ir VIEŠPATIES palaiminimas teko viskam, kas jam priklausė namuose ir laukuose. ");
INSERT INTO lit_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Ir Juozapo šeimininkas suėmė jį ir pasodino jį į kalėjimą, į vietą, kur kalėjo karaliaus kaliniai. Ir jis ten pasiliko kalėjime. ");
INSERT INTO lit_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Bet VIEŠPATS buvo su Juozapu ir parodė jam maloningumą ir davė jam palankumą kalėjimo viršininko akyse. ");
INSERT INTO lit_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Ir faraonas tarė savo tarnams: „Ar berasime tokį vyrą, kaip šis, kuriame yra Dievo Dvasia?“ ");
INSERT INTO lit_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Mes visi esame vieno vyro sūnūs; mes dori žmonės; tavo tarnai nėra šnipai!“ ");
INSERT INTO lit_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","VIEŠPATIE, tebelaukiu tavo išgelbėjimo! ");
INSERT INTO lit_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Ir jie perdavė Juozapui tokį įsakymą, sakydami: „Tavo tėvas prieš savo mirtį įsakė, sakydamas: ");
INSERT INTO lit_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Bet dėl jūsų, jūs sumanėte prieš mane bloga; Dievas tai sumanė kaip gera, kad tai įvykdytų – kaip yra šiandien – kad daug žmonių išlaikytų gyvų. ");
INSERT INTO lit_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Ir mirė Juozapas ir visi jo broliai ir visa ana karta. ");
INSERT INTO lit_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Ir nebegalėdama ilgiau jo slėpti, ji paėmė jam papiruso nendrių dėžutę ir apglaistė ją bitumu ir derva. Ji įdėjo į ją vaiką, ir padėjo tarp nendrių prie upės kranto. ");
INSERT INTO lit_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Ir Dievas išgirdo jų vaitojimą ir Dievas atsiminė savo sandorą su Abraomu, Izaoku ir Jokūbu. ");
INSERT INTO lit_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Ir jis tarė: „Nesiartink prie šios vietos! Nusiauk nuo savo kojų apavą, nes vieta, ant kurios tu stovi, yra šventa žemė“. ");
INSERT INTO lit_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Ir VIEŠPATS tarė: „Aš tikrai mačiau prispaudimą savo tautos, esančios Egipte, ir išgirdau jos šauksmą dėl jos varovų į darbus, nes aš žinau jos kančias; ");
INSERT INTO lit_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Ir Dievas tarė Mozei: „AŠ ESU, KURIS ESU.“ Ir jis pridūrė: „Šitaip sakyk Izraelio vaikams: mane siuntė pas jus AŠ ESU.“ ");
INSERT INTO lit_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Ir Dievas kalbėjo Mozei sakydamas: „Aš esu JEHOVA. ");
INSERT INTO lit_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Aš pasirodžiau Abraomui, Izaokui ir Jokūbui Dievo Visagalio vardu, bet savo vardu „JEHOVA“ jiems nedaviau savęs pažinti. ");
INSERT INTO lit_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Ir VIEŠPATS kalbėjo Mozei, sakydamas: ");
INSERT INTO lit_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Ir faraono širdis užkietėjo, kad jis jų neklausė, kaip VIEŠPATS buvo sakęs. ");
INSERT INTO lit_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Tas atsakė: „Rytoj.“ Anas tarė: „Tebūna pagal tavo žodį, kad žinotum, jog nėra kito kaip VIEŠPATS, mūsų Dievas!“ ");
INSERT INTO lit_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Ir VIEŠPATS tarė Mozei: „Sakyk Aaronui: „Ištiesk savo lazdą ir suduok į žemės dulkes, kad jos pavirstų utėlėmis visoje Egipto šalyje.“ ");
INSERT INTO lit_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Kitaip, jeigu tu neišleisi mano tautos, štai aš užleisiu musių spiečiais tave, tavo tarnus, tavo tautą ir tavo namus. Ir egiptiečių namai bus pilni musių spiečių ir taip pat žemė, kurioje jie gyvena. ");
INSERT INTO lit_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Ir VIEŠPATS tarė Mozei ir Aaronui: „Pasiimkite pilnas rieškučias krosnies pelenų, ir Mozė turi juos stipriai paberti į dangų faraono akivaizdoje. ");
INSERT INTO lit_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Ir jie taps smulkiomis dulkėmis virš viso Egipto šalies, ir visoje Egipto šalyje ant žmonių ir ant gyvulių atsiras votys, pūliuojančios opos.“ ");
INSERT INTO lit_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Ir jie paėmė krosnies pelenų ir atsistojo faraono akivaizdoje ir Mozė juos stipriai pabėrė į dangų. Ir ant žmonių ir ant gyvulių atsirado votys, pūliuojančios opos. ");
INSERT INTO lit_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Ir Mozė ištiesė savo ranką į dangų, ir tris dienas visoje Egipto šalyje buvo tiršta tamsa. ");
INSERT INTO lit_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Tris dienas jie nematė vienas kito, nei pajudėjo iš vietos. Tačiau, visų Izraelio vaikų namuose buvo šviesu. ");
INSERT INTO lit_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Ir VIEŠPATS tarė Mozei: „Dar vieną rykštę siųsiu faraonui ir Egiptui. Po to jis išleis jus iš čia. Kai jis jus išleis, jis jus varyte išvarys iš čia visiškai. ");
INSERT INTO lit_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Bet prieš nors vieną iš Izraelio vaikų šuo nepajudins savo liežuvio, nei prieš žmogų, nei prieš gyvulį, kad žinotumėte, jog VIEŠPATS daro skirtumą tarp egiptiečių ir izraelitų. ");
INSERT INTO lit_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Jūsų avinėlis turi būti be kliaudos, vienerių metų patinas; turite jį paimti iš avių ar ožkų. ");
INSERT INTO lit_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Ir jį turite laikyti iki šio mėnesio keturioliktos dienos, tada visa Izraelio susirinkimo minia jį papjaus tarp dviejų – ankstyvojo ir vėlyvojo – vakarų. ");
INSERT INTO lit_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Ir jie turi paimti kraujo ir juo patepti abi staktas ir sąramą tų namų, kuriuose jie valgys jį. ");
INSERT INTO lit_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Ir šiuo būdu jį valgykite: susijuosę strėnas, apsiavę kurpes ir pasiėmę lazdą į ranką; ir jį valgykite paskubomis. Tai yra VIEŠPATIES Aplenkimas. ");
INSERT INTO lit_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Nes tą naktį aš pereisiu per Egipto šalį ir užmušiu visus pirmagimius Egipto šalyje, tiek žmones, tiek ir gyvulius, ir visiems Egipto dievams įvykdysiu teismą; aš esu VIEŠPATS! ");
INSERT INTO lit_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","O kraujas bus ženklas jūsų naudai ant namų, kuriuose jūs būsite. Tada, pamatęs kraują, jus aplenksiu, ir, man niokojant Egipto šalį, jūsų nepalies pragaišinimo rykštė. ");
INSERT INTO lit_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Ir turi įvykti šitaip, kai jūsų vaikai jums sakys: „Kas yra šis jūsų tarnavimas?“ ");
INSERT INTO lit_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","tada jūs sakykite: „Tai VIEŠPATIES Aplenkimo auka; jis aplenkė Izraelio vaikų namus Egipte, kai jis smogė egiptiečius, o mūsų namus išgelbėjo.“ Ir žmonės nusilenkė ir kniūbsti garbino.“ ");
INSERT INTO lit_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Ir VIEŠPATS kalbėjo Mozei, sakydamas: ");
INSERT INTO lit_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Ir bus šitaip – ateityje kai tavo sūnus tave paklaus: „Ką tai reiškia?“, tu jam atsakysi: „Galinga ranka VIEŠPATS mus išvedė iš Egipto, iš vergystės namų. ");
INSERT INTO lit_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Ir tai bus kaip ženklas tau ant rankos ir kaip galvaraištis tarp tavo akių, kad galinga ranka VIEŠPATS išvedė mus iš Egipto. ");
INSERT INTO lit_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Ir VIEŠPATS kalbėjo Mozei, sakydamas: ");
INSERT INTO lit_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","VIEŠPATS yra karo vyras, VIEŠPATS jo vardas! ");
INSERT INTO lit_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Kas tarp dievų tau lygus, VIEŠPATIE? Kas, kaip tu, toks didingas šventumu, baimę keliantis savo veiksmais, kurie verti gyriaus, darantis stebuklus? ");
INSERT INTO lit_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Savo gailestingumu tu vedei tautą, kurią išpirkai, savo galia nuvedei į savo šventąją buveinę. ");
INSERT INTO lit_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","VIEŠPATS karaliaus per amžių amžius! ");
INSERT INTO lit_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Ir VIEŠPATS kalbėjo Mozei, sakydamas: ");
INSERT INTO lit_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Kaip VIEŠPATS įsakė Mozei, taip Aaronas jį atidėjo priešais Liudijimą, kad būtų išlaikytas. ");
INSERT INTO lit_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Štai aš stovėsiu ten priešais tave ant tos uolos Horebe. O tu suduok į uolą, ir iš jos ištekės vandens, kad tauta atsigertų.“ Mozė Izraelio vyresniųjų akyse taip ir padarė. ");
INSERT INTO lit_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Ir Dievas kalbėjo visus šiuos žodžius, sakydamas: ");
INSERT INTO lit_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","„Aš esu VIEŠPATS, tavo Dievas, kuris tave išvedžiau iš Egipto šalies, iš vergijos namų. ");
INSERT INTO lit_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Neturėk kitų dievų šalia manęs. ");
INSERT INTO lit_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Nedaryk sau jokio raižybos kūrinio nei jokio atvaizdo to, kas yra aukštai danguje, ar kas žemai žemėje, ar kas vandenyje po žeme; ");
INSERT INTO lit_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","nesilenk prieš juos nei tarnauk jiems; nes aš – VIEŠPATS, tavo Dievas, – esu pavydus Dievas, vaikams paskiriantis tėvų blogadarybių aplankymą – trečiajai ir ketvirtajai kartai tų, kurie manęs nekenčia, – ");
INSERT INTO lit_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","ir rodantis gailestingumą tūkstančiams tų, kurie mane myli ir laikosi mano įsakymų. ");
INSERT INTO lit_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Tuščiam reikalui nevartok VIEŠPATIES, savo Dievo, vardo, nes VIEŠPATS nelaikys nekaltu to, kuris nerimtai vartoja jo vardą. ");
INSERT INTO lit_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Atsimink šabo dieną, kad ją laikytum šventa. ");
INSERT INTO lit_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Šešias dienas dirbk ir atlik visą savo darbą, ");
INSERT INTO lit_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","bet septintoji diena yra VIEŠPATIES, tavo Dievo šabas. Joje nedirbk jokio darbo nei tu pats ar tavo sūnus ar tavo duktė, nei tavo tarnas ar tavo tarnaitė ar tavo gyvulys ar pas tave esantis svetimšalis, kuris yra tavo vartų ribose, ");
INSERT INTO lit_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","nes per šešias dienas VIEŠPATS padarė dangų ir žemę, jūrą ir visa, kas yra juose, o septintąją dieną ilsėjosi. Todėl VIEŠPATS palaimino šabo dieną ir pašventino ją. ");
INSERT INTO lit_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Gerbk savo tėvą ir savo motiną, kad tavo dienos būtų prailgintos šalyje, kurią VIEŠPATS, tavo Dievas, tau duoda. ");
INSERT INTO lit_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Neįvykdyk žmogžudystės. ");
INSERT INTO lit_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Nesvetimauk. ");
INSERT INTO lit_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Nevok. ");
INSERT INTO lit_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Neliudyk melagingai prieš savo artimą. ");
INSERT INTO lit_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Negeisk savo artimo namų; negeisk savo artimo žmonos, nei jo tarno, nei jo tarnaitės, nei jo jaučio, nei jo asilo, nei bet ko, kas priklauso tavo artimui.“ ");
INSERT INTO lit_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Iš žemės padaryk man aukurą ir aukok ant jo savo deginamąsias ir savo taikos aukas, savo avis ir savo galvijus. Kiekvienoje vietoje, kurioje priminsiu savo vardą, aš ateisiu pas tave ir laiminsiu tave. ");
INSERT INTO lit_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","akį už akį, dantį už dantį, ranką už ranką, koją už koją, ");
INSERT INTO lit_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","nudeginimą už nudeginimą, žaizdą už žaizdą, randą už randą. ");
INSERT INTO lit_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Jeigu tik paimsi kaip užstatą savo artimo apdarą, tu turi jam sugrąžinti jį iki saulės laidos, ");
INSERT INTO lit_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","nes tai yra jo vienintelis apklotas, tai jo odos drabužis: į ką kita įsivyniojęs jis atsiguls? Ir bus šitaip: kai jis šauksis manęs, išklausysiu, nes aš esu maloningas. ");
INSERT INTO lit_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Ir VIEŠPATS tarė Mozei: „Užlipk pas mane į kalną ir ten pabūk. Ir tau duosiu akmens plokštes, tai yra įstatymą ir įsakymus, kuriuos surašiau jiems pamokyti.“ ");
INSERT INTO lit_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Taigi Mozė pakilo su savo padėjėju Jozue, ir Mozė lipo į Dievo kalną. ");
INSERT INTO lit_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Ir Izraelio vaikų akims VIEŠPATIES šlovės vaizdas buvo kaip ryjanti ugnis kalno viršūnėje. ");
INSERT INTO lit_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Ir VIEŠPATS kalbėjo Mozei, sakydamas: ");
INSERT INTO lit_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Ir jie tepadaro man šventovę, kad gyvenčiau tarp jų. ");
INSERT INTO lit_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Pagal visa tai, ką tau parodysiu, pagal padangtės pavyzdį ir visų jos įrankių pavyzdį, būtent taip turite ją padaryti. ");
INSERT INTO lit_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Ir padaryk kartis iš akacijos medžio ir jas aptrauk auksu. ");
INSERT INTO lit_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Ir įdėk į skrynią Liudijimą, kurį tau duosiu. ");
INSERT INTO lit_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Ir iš gryno aukso padaryk gailestingumo sostą pustrečios uolekties ilgio ir pusantros uolekties pločio. ");
INSERT INTO lit_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Ir iš aukso padaryk du kerubus, iš kūju nuplakto metalo juos padaryk abiejuose gailestingumo sosto galuose. ");
INSERT INTO lit_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Ir padaryk vieną kerubą viename gale, o kitą kerubą kitame gale; iš gailestingumo sosto padarykite kerubus abiejuose jo galuose. ");
INSERT INTO lit_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Ir kerubai turi būti išskėtę savo sparnus aukštyn, gaubdami savo sparnais gailestingumo sostą, o jų veidai turi būti vienas priešais kitą, į gailestingumo sostą turi būti nukreipti kerubų veidai. ");
INSERT INTO lit_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Ir uždėk gailestingumo sostą ant skrynios iš viršaus, o į skrynią įdėk Liudijimą, kurį tau duosiu. ");
INSERT INTO lit_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Ir ten aš su tavimi susitiksiu ir kalbėsiuosi su tavimi nuo gailestingumo sosto viršaus (iš tarp dviejų kerubų, esančių ant Liudijimo skrynios) apie viską, ką aš tau įsakymu duosiu Izraelio vaikams. ");
INSERT INTO lit_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Taip pat padaryk stalą iš akacijos medžio; jo ilgis bus dvi uolektys ir jo plotis – viena uolektis ir jo aukštis – pusantros uolekties. ");
INSERT INTO lit_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Ir nuolat mano akivaizdoje laikyk padėjęs ant stalo padėtinę duoną. ");
INSERT INTO lit_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Ir padaryk iš gryno aukso žibintuvą; žibintuvas turi būti nukaltas. Jo kotas ir jo šakos, jo taurelės, jo buoželės ir jo žiedai turi būti iš to paties gabalo. ");
INSERT INTO lit_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Šešios šakos turi išeiti iš jo šonų: trys žibintuvo šakos iš vieno jo šono ir trys žibintuvo šakos iš kito jo šono; ");
INSERT INTO lit_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Ir padaryk uždangą iš mėlynos ir violetinės ir skaisčiai raudonos medžiagos ir plonų suktinių siūlų drobės; ji bus puikaus meistro darbas, kurį turi padaryti su išsiuvinėtais kerubais. ");
INSERT INTO lit_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Ir pakabink ją ant keturių auksu aptrauktų akacijos medžio stulpų, turinčių auksinius kablius ant keturių sidabro pastovų. ");
INSERT INTO lit_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Ir uždangą pakabink žemiau sagčių ir ten, už uždangos, į vidų įnešk Liudijimo skrynią, o uždanga turi jums atskirti šventąją vietą nuo švenčiausiosios vietos. ");
INSERT INTO lit_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Ir padaryk aukurą iš akacijos medžio penkių uolekčių ilgio, penkių uolekčių pločio – aukuras bus kvadratinis – ir jo aukštis bus trys uolektys. ");
INSERT INTO lit_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Ir ant jo keturių kampų padaryk jam ragus; jo ragai turi būti iš to paties gabalo. Taip pat aptrauk jį bronza / žalvariu. ");
INSERT INTO lit_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Ir kad jis man eitų kunigo pareigas, iš Izraelio vaikų tarpo priartink prie savęs savo brolį Aaroną ir jo sūnus su juo, tai yra Aaroną, Nadabą ir Abihuvą, Eleazarą ir Itamarą, Aarono sūnus. ");
INSERT INTO lit_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Per jūsų kartas tokia turi būti nuolatinė deginamoji auka VIEŠPATIES akivaizdoje prie įėjimo į susitikimo palapinę, kur susitiksiu su tavim, kad ten tau kalbėčiau. ");
INSERT INTO lit_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Ir padaryk aukurą smilkalams deginti; padaryk jį iš akacijos medžio. ");
INSERT INTO lit_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Jo ilgis bus viena uolektis, ir jo plotis bus viena uolektis – jis bus kvadratinis – ir jo aukštis bus dvi uolektys; jo ragai turi būti iš to paties gabalo. ");
INSERT INTO lit_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Taip pat aptrauk jį grynu auksu – jo viršų, jo šonus aplinkui ir jo ragus; ir jam aplinkui padaryk aukso atbrailą. ");
INSERT INTO lit_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Ir VIEŠPATS kalbėjo Mozei, sakydamas: ");
INSERT INTO lit_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","„Kai surašysite Izraelio vaikus pagal jų skaičių, tada kiekvienas vyras duos VIEŠPAČIUI išpirką už savo sielą, kai juos skaičiuosi, kad tarp jų nebūtų rykštės, kai juos skaičiuosi. ");
INSERT INTO lit_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Štai ką duos kiekvienas, kuris pereis į suskaičiuotuosius: pusę šekelio pagal šventovės šekelį (šekelis yra dvidešimt gerų); pusė šekelio bus atnaša VIEŠPAČIUI. ");
INSERT INTO lit_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Kiekvienas, kuris pereis į suskaičiuotuosius (dvidešimtmetis ar vyresnis), turi duoti VIEŠPATIES atnašą. ");
INSERT INTO lit_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Duodant VIEŠPATIES atnašą, kad atliktų atpirkimą už jūsų sielas, turtingasis neturi duoti daugiau, ir vargšas neturi duoti mažiau kaip pusę šekelio. ");
INSERT INTO lit_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Ir paimk iš Izraelio vaikų atpirkimo pinigus ir paskirk juos susitikimo palapinės tarnavimui. Izraelio vaikams tai bus priminimas VIEŠPATIES akivaizdoje, kad atpirktų jūsų sielas.“ ");
INSERT INTO lit_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Ir VIEŠPATS kalbėjo Mozei, sakydamas: ");
INSERT INTO lit_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Ir VIEŠPATS kalbėjo Mozei, sakydamas: ");
INSERT INTO lit_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","„Štai vardu pašaukiau Hūro sūnaus Ūrio sūnų Becalelį iš Judo genties, ");
INSERT INTO lit_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","ir išminties bei supratimo bei sugebėjimo bei visokio darbo atlikimo tikslams jį pripildžiau Dievo Dvasios, ");
INSERT INTO lit_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","sumaniems darbams sugalvoti, dirbiniams padaryti iš aukso, sidabro ir bronzos / žalvario, ");
INSERT INTO lit_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","ir brangakmeniams išpjaustyti įtvėrimui, ir medienai apdirbti, – visokiam darbui atlikti. ");
INSERT INTO lit_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Ir VIEŠPATS kalbėjo Mozei, sakydamas: ");
INSERT INTO lit_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","O kai žmonės matė, kad Mozė uždelsė nusileisti nuo kalno, žmonės susirinko prie Aarono ir jam tarė: „Kelkis, padaryk mums dievų, kurie eitų pirma mūsų, nes nežinome, kas nutiko va šiam Mozei, žmogui, kuris išvedė mus aukštyn iš Egipto šalies.“ ");
INSERT INTO lit_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Ir Aaronas jiems tarė: „Nutraukite auksinius auskarus, esančius jūsų žmonų, jūsų sūnų ir jūsų dukterų ausyse, ir atneškite juos man.“ ");
INSERT INTO lit_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Ir visi žmonės nusitraukė auksinius auskarus, esančius jų ausyse, ir atnešė juos Aaronui. ");
INSERT INTO lit_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Ir paėmęs tai iš jų rankų, jis išdrožė jį raižikliu ir padarė jį nulieto metalo veršį. Tada jie tarė: „Šitie yra tavo dievai, o Izraeli, kurie tave išvedė aukštyn iš Egipto šalies!“ ");
INSERT INTO lit_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Ir VIEŠPATS gailėdamasis apsigalvojo dėl to blogo, kurį jis pasakė padarysiąs savo tautai. ");
INSERT INTO lit_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Ir VIEŠPATS smogė žmones už tai, kad jie padarė tą veršį, kurį padarė Aaronas. ");
INSERT INTO lit_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Ir jis tarė: „Aš pats eisiu su tavimi, ir aš tau suteiksiu poilsį.“ ");
INSERT INTO lit_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","O jis atsakė: „Aš padarysiu, kad praeis prieš tavo veidą visas mano gerumas ir ištarsiu prieš tave vardą „VIEŠPATS“; aš būsiu maloningas tam, kam būsiu maloningas, ir pasigailėsiu to, ko pasigailėsiu.“ ");
INSERT INTO lit_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Ir VIEŠPATS jam prieš veidą praėjo ir paskelbė: „VIEŠPATS, VIEŠPATS Dievas, gailestingas ir maloningas, lėtas pykti, gausus gerumu ir tiesa, ");
INSERT INTO lit_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","išlaikantis gailestingumą tūkstančiams, atleidžiantis blogadarybes, nusižengimą ir nuodėmę, tačiau jokiu būdu nepaliekantis kaltojo nenubausto, paskiriantis tėvų blogadarybių aplankymą vaikams ir vaikų vaikams, – trečiajai ir ketvirtajai kartai.“ ");
INSERT INTO lit_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Ir VIEŠPATS tarė Mozei: „Užsirašyk šituos žodžius, nes pagal šitų žodžių pasakymą aš sudariau sandorą su tavimi ir Izraeliu.“ ");
INSERT INTO lit_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Ir Mozė baigė kalbėti su jais (ir jis užsidėjo ant veido gaubtuvą). ");
INSERT INTO lit_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Ir VIEŠPATS kalbėjo Mozei, sakydamas: ");
INSERT INTO lit_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Nes kūno gyvybė yra kraujyje, ir aš jums daviau jį ant aukuro jūsų sieloms atpirkti, nes būtent kraujas atperka sielą. ");
INSERT INTO lit_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Neprakeik kurčiojo nei nepadėk suklupimo kliūties prieš akląjį, bet bijok savo Dievo: aš esu VIEŠPATS. ");
INSERT INTO lit_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Jums nevalia neteisingai pasielgti teisme: nebūk šališkas vargšui ir neduok pirmenybės didžiūnui, bet teisk savo artimą teisingai. ");
INSERT INTO lit_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Nekeršyk nei laikyk pagiežos prieš savo tautiečius, bet mylėk savo artimą kaip save patį: aš esu VIEŠPATS. ");
INSERT INTO lit_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Ir nedarykite jokių įsipjovimų savo kūne dėl mirusio, nei darykite ant savęs jokių tatuiruočių: aš esu VIEŠPATS. ");
INSERT INTO lit_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","Būtinai dešimtąją šito septintojo mėnesio dieną bus Atpirkimo diena: jums tai bus šventas susirinkimas ir jūs turėsite nužeminti savo sielas ir atnašauti VIEŠPAČIUI auką, aukojamą ugnimi. ");
INSERT INTO lit_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Ir jie įkalino jį, kad jiems sprendimą išdėstytų pagal VIEŠPATIES įsakymą. ");
INSERT INTO lit_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Jums turi galioti vienokia teisingumo sistema; ji turi galioti tiek svetimšaliui, tiek ir tėvynainiui, nes aš esu VIEŠPATS, jūsų Dievas. ");
INSERT INTO lit_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Ir aš pastatysiu savo padangtę tarp jūsų; ir mano siela nesibjaurės jumis. ");
INSERT INTO lit_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Ir vaikščiosiu tarp jūsų ir būsiu jūsų Dievas, o jūs būsite mano tauta. ");
INSERT INTO lit_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Jei jis pašventins savo lauką nuo jubiliejaus metų, turi pasilikti tavo nustatyta vertė, ");
INSERT INTO lit_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Ir VIEŠPATS kalbėjo Mozei Sinajaus dykumoje, susitikimo padangtėje, antrojo mėnesio pirmąją dieną, antraisiais metais po jų išvykimo iš Egipto šalies, sakydamas: ");
INSERT INTO lit_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","„Surašykite visą Izraelio vaikų susirinkimą pagal jų šeimų grupes, pagal jų tėvų namus, pagal visų vyriškių vardų skaičių, pavieniui. ");
INSERT INTO lit_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","„VIEŠPATS telaimina ir tesaugoja tave. ");
INSERT INTO lit_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","VIEŠPATS tenušviečia tave savo veidu ir tebūna tau maloningas. ");
INSERT INTO lit_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","VIEŠPATS teatgręžia savo veidą į tave ir tesuteikia tau ramybę. ");
INSERT INTO lit_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Taip jie turi uždėti mano vardą ant Izraelio vaikų, ir aš juos laiminsiu. ");
INSERT INTO lit_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Ir Mozė tarė Hobabui, savo uošvio Reuelio Midjaniečio sūnui: „Keliaujame ton vieton, apie kurią VIEŠPATS yra pasakęs: „Duosiu ją jums.“ Eik su mumis ir mes tau gera darysime, nes VIEŠPATS pažadėjo gera Izraeliui.“ ");
INSERT INTO lit_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Ir kai žmonės skundėsi, tai labai nepatiko VIEŠPAČIUI. O VIEŠPATS išgirdo ir jo rūstybė užsidegė, taip pat VIEŠPATIES ugnis suliepsnojo tarp jų ir prarijo esančius stovyklos pakraštyje. ");
INSERT INTO lit_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","O Nūno sūnus Jozuė, Mozės padėjėjas, vienas iš jo rinktinių vyrų, atsiliepdamas tarė: „Mano viešpatie Moze, sustabdyk jiems! ");
INSERT INTO lit_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(O tas vyras Mozė buvo labai romus, labiau už visus žmones, esančius ant žemės paviršiaus.) ");
INSERT INTO lit_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Ir VIEŠPATS kalbėjo Mozei, sakydamas: ");
INSERT INTO lit_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","„Savo labui pasiųsk vyrus, kad jie išžvalgytų Kanaano šalį, kurią aš duodu Izraelio vaikams. Pasiųsk po vieną vyrą iš kiekvienos jo tėvų genties, kiekvienam esant vadui tarp jų. ");
INSERT INTO lit_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Ir Mozė pagal VIEŠPATIES įsakymą išsiuntė juos iš Parano dykumos. Visi jie buvo Izraelio vaikų vadovaujantys vyrai. ");
INSERT INTO lit_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","VIEŠPATS yra lėtas pykti ir kupinas gailestingumo, atleidžiantis blogadarybę ir nusižengimą, bet jokiu būdu neatleisdamas kaltojo nuo atsakomybės, vaikams paskiriantis tėvų blogadarybės aplankymą – trečiajai ir ketvirtajai kartai. ");
INSERT INTO lit_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Ir VIEŠPATS kalbėjo Mozei, sakydamas: ");
INSERT INTO lit_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","„Kalbėk Izraelio vaikams ir jiems įsakyk, kad jie per visas savo kartas pasidarytų kutus prie savo drabužių kampų, ir kad jie pridėtų mėlyną virvelę prie kampinių kutų. ");
INSERT INTO lit_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Mat turite turėti kutą, kad matydami jį atmintumėte visus VIEŠPATIES įsakymus ir juos vykdytumėte, ir kad nebūtumėte vedami pagal savo širdį ir savo akis, pagal kurias linkstate vykdyti paleistuvingus norus, ");
INSERT INTO lit_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Ir VIEŠPATS kalbėjo Aaronui: „Jų šalyje neturėsi veldinio nei turėsi dalies tarp jų: aš esu tavo dalis ir tavo veldinys tarp Izraelio vaikų. ");
INSERT INTO lit_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Ir pirmąjį mėnesį Izraelio vaikai – visas susirinkimas – atvyko į Cino dykumą, ir tauta apsistojo Kadeše. Ten ir mirė Mirjama, ir ten ji buvo palaidota. ");
INSERT INTO lit_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Ir susirinkimui nebuvo vandens; tad jie susirinko prieš Mozę ir prieš Aaroną. ");
INSERT INTO lit_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Ir tauta vaidijosi su Moze ir kalbėjo, sakydami: „Verčiau būtume žuvę, kai mūsų broliai žuvo VIEŠPATIES akivaizdoje! ");
INSERT INTO lit_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Ir kodėl atvedėte VIEŠPATIES susirinkimą aukštyn į šią dykumą, kad mes ir mūsų gyvuliai čia mirtume? ");
INSERT INTO lit_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Ir kodėl mus atkėlėte aukštyn iš Egipto, kad mus atvestumėte į šitą blogą vietą? Šita nėra nei sėklų, nei figmedžių, nei vynmedžių, nei granatmedžių vieta; ir nėra nė vandens atsigerti! ");
INSERT INTO lit_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Tada Mozė ir Aaronas nuėjo nuo susirinkimo akivaizdos prie susitikimo palapinės įėjimo ir parpuolė veidais žemyn; ir jiems pasirodė VIEŠPATIES šlovė; ");
INSERT INTO lit_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","ir VIEŠPATS kalbėjo Mozei, sakydamas: ");
INSERT INTO lit_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","„Paimk lazdą ir surink susirinkimą, tu ir tavo brolis Aaronas, ir kalbėkite uolai jų akyse; ir ji išleis savo vandenį, ir tu jiems išgausi vandens iš uolos; taip pagirdysi susirinkimą ir jų gyvulius.“ ");
INSERT INTO lit_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Ir Mozė paėmė lazdą iš VIEŠPATIES akivaizdos, kaip jis buvo jam įsakęs. ");
INSERT INTO lit_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Ir Mozė ir Aaronas surinko susirinkimą priešais uolą, ir jis jiems tarė: „ Prašau klausykite, jūs maištininkai! Ar mes turime iš šitos uolos jums išgauti vandens?“ ");
INSERT INTO lit_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Ir Mozė pakėlė savo ranką ir du kartus smogė savo lazda į uolą; tada išsiliejo daug vandens, ir gėrė susirinkimas ir jų gyvuliai. ");
INSERT INTO lit_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Ir VIEŠPATS tarė Mozei ir Aaronui: „Kadangi nepasitikėjote manimi, kad laikytumėte mane šventu Izraelio vaikų akyse, todėl neįvesite šito susirinkimo į šalį, kurią jiems daviau. ");
INSERT INTO lit_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Tai Meribos vandenys, nes Izraelio vaikai vaidijosi su VIEŠPAČIU, o jis palaikė savo šventumą jų tarpe. ");
INSERT INTO lit_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Ir VIEŠPATS siuntė ugningas gyvates tarp žmonių ir jos gėlė žmones ir daug Izraelio žmonių mirė. ");
INSERT INTO lit_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Todėl žmonės atėjo pas Mozę ir tarė: „Mes nusidėjome, nes kalbėjome prieš VIEŠPATĮ ir prieš tave. Melskis VIEŠPAČIUI, kad jis pašalintų nuo mūsų gyvates! Tad Mozė meldėsi už žmones. ");
INSERT INTO lit_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","VIEŠPATS tarė Mozei: „Pasidirbk ugningą gyvatę ir pritaisyk ją prie karties. Ir įvyks šitaip: bet kuris įgeltasis, kai jis įbes akis į ją, gyvuos. ");
INSERT INTO lit_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Ir Mozė padarė bronzinę / žalvarinę gyvatę ir pritaisė ją prie karties, ir įvyko, kad, jei gyvatė ką įgėlė ir tas įbedė akis į bronzinę / žalvarinę gyvatę, jis gyvavo. ");
INSERT INTO lit_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Dievas nėra žmogus, kad meluotų, ir nėra žmogaus sūnus, kad persigalvotų. Ar jis pasakė ir nepadarys? Ar jis kalbėjo ir neįvykdys? ");
INSERT INTO lit_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Todėl pasakyk: „Aš suteikiu jam taikos sandorą. ");
INSERT INTO lit_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Bet jeigu taip nedarysite, štai jūs būsite nusidėję VIEŠPAČIUI, ir galite būti tikri, kad jūsų nuodėmė jus pagaus. ");
INSERT INTO lit_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","Teisdami nebūkite šališki: išklausykite tiek varguolį, tiek ir didžiūną. Nė vieno nebijokite, nes toks teismas yra Dievo. O reikalą, kuris jums per sunkus, perduokite man, ir aš jį išklausysiu. ");
INSERT INTO lit_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","Bet jeigu iš ten ieškosi VIEŠPATIES, savo Dievo, tu jį surasi, jeigu ieškosi jo visa savo širdimi ir visa savo siela. ");
INSERT INTO lit_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","Todėl laikykis jo nuostatų ir jo įsakymų, kuriuos tau šią dieną įsakau, kad gerai sektųsi tau ir tavo vaikams po tavęs ir kad prailgintum savo dienas žemėje, kurią VIEŠPATS, tavo Dievas, tau duoda amžiams. ");
INSERT INTO lit_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","Nedaryk sau jokio raižybos kūrinio nei jokio atvaizdo to, kas yra aukštai danguje, ar kas žemai žemėje, ar kas vandenyje po žeme; ");
INSERT INTO lit_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","nesilenk jiems nei tarnauk jiems; nes aš VIEŠPATS, tavo Dievas, esu pavydus Dievas, lankantis tėvų blogadarybes ant vaikų iki trečios ir ketvirtos kartos tų, kurie manęs nekenčia; ");
INSERT INTO lit_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","ir rodantis gailestingumą tūkstančiams tų, kurie mane myli ir laikosi mano įsakymų. ");
INSERT INTO lit_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","ir sakėte: „Štai VIEŠPATS, mūsų Dievas, mums parodė savo šlovę ir savo didybę, ir girdėjome jo balsą iš ugnies vidaus. Šiandien pamatėme, kad gali Dievas kalbėti su žmogumi ir tas likti gyvas. ");
INSERT INTO lit_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","Klausyk, o Izraeli: VIEŠPATS, mūsų Dievas, yra vienas VIEŠPATS; ");
INSERT INTO lit_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","Ir mylėk VIEŠPATĮ, savo Dievą, visa savo širdimi, visa savo siela ir visomis savo jėgomis. ");
INSERT INTO lit_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","ir uoliai mokyk jų savo vaikus ir apie juos kalbėk, kai sėdi savo namuose ir kai eini keliu ir kai atsiguli ir kai atsikeli. ");
INSERT INTO lit_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","Ir pririšk juos kaip ženklą sau ant rankos, ir jie bus kaip galvaraištis tarp tavo akių. ");
INSERT INTO lit_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","Ir užrašyk juos ant savo namo durų staktų ir ant savo vartų. ");
INSERT INTO lit_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","Taigi žinok, kad VIEŠPATS, tavo Dievas, jis yra Dievas, ištikimas Dievas, kuris laikosi sandoros ir gailestingumo iki tūkstančio kartų tiems, kurie jį myli ir laikosi jo įsakymų, ");
INSERT INTO lit_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","ir tiesiai jiems į veidą atlygina tiems, kurie jo nekenčia, pražudydamas juos; jis nedels su tuo, kuris jo nekenčia – jis jam tiesiai į veidą atlygins. ");
INSERT INTO lit_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","Taigi žinok savo širdyje, kad, kaip žmogus drausmina savo sūnų, taip VIEŠPATS, tavo Dievas, drausmina tave. ");
INSERT INTO lit_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","Nes VIEŠPATS, tavo Dievas, tave įveda į gerą šalį, į šalį vandens upelių, versmių ir požeminių srovių, išsiveržiančių slėniuose ir kalnuose; ");
INSERT INTO lit_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","O dabar, Izraeli, ko gi reikalauja iš tavęs VIEŠPATS, tavo Dievas, jei ne vien tai, kad bijotum VIEŠPATIES, savo Dievo, vaikščiotum visais jo keliais, mylėtum jį ir tarnautum VIEŠPAČIUI, savo Dievui, visa savo širdimi ir visa savo siela, ");
INSERT INTO lit_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","laikytumeisi VIEŠPATIES įsakymų ir jo nuostatų, kuriuos šią dieną pats tau įsakau tavo labui? ");
INSERT INTO lit_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","Todėl apipjaustykite savo širdies prieodę ir nebebūkite kietasprandžiai, ");
INSERT INTO lit_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","nes VIEŠPATS, jūsų Dievas, yra dievų Dievas ir viešpačių Viešpats, didis Dievas, galingas ir baimę keliantis, kuris nesielgia šališkai, nei ima kyšių, ");
INSERT INTO lit_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","kuris vykdo teisingumą našlaičių ir našlių labui, kuris myli svetimšalį, duodamas jam maisto ir drabužių. ");
INSERT INTO lit_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","Jis yra tavo gyrius ir jis yra tavo Dievas, kuris tau padarė šiuos didelius ir baimę keliančius dalykus, kuriuos matė tavo akys. ");
INSERT INTO lit_vpl VALUES ("DT11_13","006_11_13","DEU","11","13","13","Taip įvyks: jei tikrai klausysite mano įsakymų, kuriuos jums šią dieną įsakau, būtent mylėti VIEŠPATĮ, savo Dievą, ir jam tarnauti visa savo širdimi ir visa savo siela, ");
INSERT INTO lit_vpl VALUES ("DT11_14","006_11_14","DEU","11","14","14","tai duosiu jūsų šaliai lietaus laiku, ankstyvojo lietaus ir vėlyvojo lietaus, ir suvalysi savo javus, savo vyną ir savo aliejų. ");
INSERT INTO lit_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","Todėl įsidėkite šiuos mano žodžius į savo širdį ir į savo sielą, ir juos pririškite sau kaip ženklą ant rankos, ir jie tebūna kaip galvaraištis tarp jūsų akių. ");
INSERT INTO lit_vpl VALUES ("DT12_7","006_12_7","DEU","12","7","7","ir ten valgykite VIEŠPATIES, savo Dievo, akivaizdoje ir džiaukitės jūs ir jūsų šeimynos kiekvienu jūsų rankos ištiesimu, kuriuo VIEŠPATS, tavo Dievas, palaimino tave. ");
INSERT INTO lit_vpl VALUES ("DT13_4","006_13_4","DEU","13","4","4","Sekite paskui VIEŠPATĮ, savo Dievą, ir bijokite jo, ir laikykitės jo įsakymų, ir klausykite jo balso, ir tarnaukite jam, ir tvirtai laikykitės prie jo. ");
INSERT INTO lit_vpl VALUES ("DT14_26","006_14_26","DEU","14","26","26","ir išleisi tuos pinigus pirkdamas ko tik geidžia tavo siela: jaučių, ar mažųjų gyvulių, ar vyno, ar stipraus gėrimo, ar ko tik trokšta tavo siela. Ir ten VIEŠPATIES, savo Dievo, akivaizdoje, valgyk ir džiaukis tu ir tavo namiškiai. ");
INSERT INTO lit_vpl VALUES ("DT15_11","006_15_11","DEU","15","11","11","Kadangi vargšai niekada nepradings iš šalies, todėl įsakau aš tau, sakydamas: „Plačiai atverk ranką savo broliui, savo skurdžiui ir vargšui savo šalyje. ");
INSERT INTO lit_vpl VALUES ("DT16_21","006_16_21","DEU","16","21","21","Nestatyk sau jokio dievukstulpio medžio šalia VIEŠPATIES, tavo Dievo, aukuro, kurį pasidarysi. ");
INSERT INTO lit_vpl VALUES ("DT16_22","006_16_22","DEU","16","22","22","Ir neiškelk sau jokio akmeninio stulpo – jų nekenčia VIEŠPATS, jūsų Dievas. ");
INSERT INTO lit_vpl VALUES ("DT17_17","006_17_17","DEU","17","17","17","Taip pat jam neleidžiama dauginti sau žmonų, kad nenukryptų jo širdis, ir jam neleidžiama apsčiai dauginti sau sidabro bei aukso. ");
INSERT INTO lit_vpl VALUES ("DT18_15","006_18_15","DEU","18","15","15","VIEŠPATS, tavo Dievas, tau prikels iš tavo tarpo, iš tavo brolių, Pranašą, tokį, kaip aš; jo privalote klausyti, ");
INSERT INTO lit_vpl VALUES ("DT18_16","006_18_16","DEU","18","16","16","elgdamasis pagal visa tai, ko prašei VIEŠPATIES, savo Dievo, Horebe susirinkimo dieną, sakydamas: „Leisk man daugiau nebegirdėti VIEŠPATIES, savo Dievo, balso ir daugiau nebematyti tos didžios ugnies, kad nemirčiau! ");
INSERT INTO lit_vpl VALUES ("DT18_17","006_18_17","DEU","18","17","17","Tada VIEŠPATS man tarė: „Taip kalbėdami, jie gerai padarė. ");
INSERT INTO lit_vpl VALUES ("DT18_18","006_18_18","DEU","18","18","18","Jiems prikelsiu iš jų brolių tarpo Pranašą, tokį, kaip tu ir įdėsiu savo žodžius į jo burną ir jis jiems kalbės viską, ką jam įsakysiu. ");
INSERT INTO lit_vpl VALUES ("DT18_19","006_18_19","DEU","18","19","19","Ir įvyks šitaip: žmogus, kuris neklausys mano žodžių, kuriuos jis kalbės mano vardu, aš pats reikalausiu iš to už tai atsakyti. ");
INSERT INTO lit_vpl VALUES ("DT18_20","006_18_20","DEU","18","20","20","Bet pranašas, kuris elgsis įžūliai, kalbėdamas mano vardu žodį, kurio kalbėti nesu jam įsakęs, ar kuris kalbės kitų dievų vardu, tas pranašas turi mirti! ");
INSERT INTO lit_vpl VALUES ("DT18_21","006_18_21","DEU","18","21","21","O jeigu sakysi savo širdyje: „Kaip mes atpažinsime žodį, kurio VIEŠPATS nekalbėjo?“ – štai kaip: ");
INSERT INTO lit_vpl VALUES ("DT18_22","006_18_22","DEU","18","22","22","kai pranašas kalba VIEŠPATIES vardu, o tas dalykas neatsitinka ir neįvyksta, tai yra dalykas, kurio VIEŠPATS nekalbėjo. Pranašas kalbėjo tai įžūliai. Jo nebijok! ");
INSERT INTO lit_vpl VALUES ("DT19_15","006_19_15","DEU","19","15","15","Vienintelio liudytojo parodymais neturi būti patvirtintas reikalas prieš žmogų dėl kokio nors nusikaltimo ar kokios nors nuodėmės bet kokiame nusidėjime, kuriuo jis nusidėjo: reikalas turi būti patvirtintas dviejų liudytojų burnų parodymais ar trijų liudytojų burnų parodymais. ");
INSERT INTO lit_vpl VALUES ("DT20_4","006_20_4","DEU","20","4","4","nes VIEŠPATS, jūsų Dievas, yra tas, kuris eina su jumis kovoti už jus prieš jūsų priešus, kad jus išgelbėtų. ");
INSERT INTO lit_vpl VALUES ("DT20_7","006_20_7","DEU","20","7","7","Ar yra vyras, kuris įsipareigojo imti moterį į žmonas, bet dar jos nevedė? Tas tegul eina ir grįžta į savo namus, kad nežūtų mūšyje ir kitas vyras jos nevestų. ");
INSERT INTO lit_vpl VALUES ("DT22_5","006_22_5","DEU","22","5","5","Vyro drabužis neturi būti moters dėvimas, ir vyrui neleidžiama vilkėti moters apdaro, nes visi, kurie taip daro, yra pasibjaurėjimas VIEŠPAČIUI, tavo Dievui. ");
INSERT INTO lit_vpl VALUES ("DT24_5","006_24_5","DEU","24","5","5","Kai vyras bus ką tik vedęs žmoną, jis neturi išeiti į karą, ir neturi būti įpareigotas jokiu reikalu; vienerius metus jis turi būti laisvas namuose, kad džiugintų savo žmoną, kurią yra paėmęs į žmonas. ");
INSERT INTO lit_vpl VALUES ("DT29_29","006_29_29","DEU","29","29","29","Paslėpti dalykai priklauso VIEŠPAČIUI, mūsų Dievui, bet apreikšti dalykai priklauso mums ir mūsų vaikams per amžius, kad vykdytume visus šio įstatymo žodžius. ");
INSERT INTO lit_vpl VALUES ("DT30_6","006_30_6","DEU","30","6","6","Ir VIEŠPATS, tavo Dievas, apipjaustys tavo širdį ir tavo palikuonių širdį, jog mylėtum VIEŠPATĮ, savo Dievą, visa savo širdimi ir visa savo siela, kad gyventum. ");
INSERT INTO lit_vpl VALUES ("DT30_19","006_30_19","DEU","30","19","19","Šiandien šaukiu liudytojais prieš jus dangų ir žemę: padėjau prieš tave gyvenimą ir mirtį, palaiminimą ir prakeikimą. Taigi rinkis gyvenimą, kad būtum gyvas tu (ir tavo palikuonys), ");
INSERT INTO lit_vpl VALUES ("DT30_20","006_30_20","DEU","30","20","20","kad mylėtum VIEŠPATĮ, savo Dievą, klausytum jo balso ir glaustumeis prie jo (nes jis yra tavo gyvenimas ir tavo dienų ilgumas), kad gyventum žemėje, kurią VIEŠPATS prisiekė duoti tavo tėvams Abraomui, Izaokui ir Jokūbui. ");
INSERT INTO lit_vpl VALUES ("DT31_6","006_31_6","DEU","31","6","6","Būkite stiprūs ir drąsūs! Nebijokite ir neišsigąskite jų, nes VIEŠPATS, tavo Dievas, yra tas, kuris eina su tavimi! Jis nenustos palaikyti tavęs ir nepasitrauks nuo tavęs. ");
INSERT INTO lit_vpl VALUES ("DT31_8","006_31_8","DEU","31","8","8","Ir VIEŠPATS yra tas, kuris eina pirma tavęs. Jis bus su tavimi, jis nenustos palaikyti tavęs ir nepasitrauks nuo tavęs. Nebijok ir nenusigąsk! ");
INSERT INTO lit_vpl VALUES ("DT32_4","006_32_4","DEU","32","4","4","Jis yra Uola. Tobulas jo darbas, nes visi jo keliai teisingi – ištikimas Dievas ir be neteisybės, jis teisingas ir tiesus. ");
INSERT INTO lit_vpl VALUES ("DT32_10","006_32_10","DEU","32","10","10","Jis rado jį dykumos šalyje kaukiančioje tyrlaukio dykynėje, apglėbė jį, mokė jį, saugojo jį kaip savo akies vyzdį. ");
INSERT INTO lit_vpl VALUES ("DT32_21","006_32_21","DEU","32","21","21","Jie sukėlė mano pavydą tuo, kas ne Dievas; jie pykdė mane savo tuštybėmis; tai aš sukelsiu jų pavydą per netautą, aš pykdysiu juos per kvailą tautą. ");
INSERT INTO lit_vpl VALUES ("DT32_29","006_32_29","DEU","32","29","29","O, kad jie būtų išmintingi, kad suprastų tai, kad jie įžvelgtų, koks bus jų galas! ");
INSERT INTO lit_vpl VALUES ("DT32_35","006_32_35","DEU","32","35","35","Atkeršijimas ir atmokėjimas yra mano – jų koja paslys tinkamu laiku, nes jų didžiulės nelaimės diena yra arti, ir atskuba tai, kas juos ištiks. ");
INSERT INTO lit_vpl VALUES ("DT33_25","006_33_25","DEU","33","25","25","Geležiniai ir žalvariniai bus tavo užraktai, o tavo stiprybė atitiks tavo dienas. ");
INSERT INTO lit_vpl VALUES ("DT33_27","006_33_27","DEU","33","27","27","Amžinasis Dievas yra tavo prieglauda ir po tavimi – amžinos rankos. Jis nuvarys priešą nuo tavęs ir palieps: „Pražudyk juos!“ ");
INSERT INTO lit_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","Ir po VIEŠPATIES tarno Mozės mirties, įvyko, kad VIEŠPATS tarė Nūno sūnui Jozuei, Mozės padėjėjui, sakydamas: ");
INSERT INTO lit_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","„Mirė mano tarnas Mozė. Taigi dabar kelkis, eik per šitą Jordaną, tu ir visa šita tauta į šalį, kurią duodu jiems, Izraelio vaikams. ");
INSERT INTO lit_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","Niekas nepajėgs atsilaikyti prieš tave per visas tavo gyvenimo dienas; kaip buvau su Moze, taip būsiu su tavimi: nenustosiu palaikyti tavęs ir nepasitrauksiu nuo tavęs. ");
INSERT INTO lit_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","Būk stiprus ir drąsus, nes šitai tautai tu pats padalinsi kaip paveldėjimą šalį, kurią jiems duoti esu prisiekęs jų tėvams. ");
INSERT INTO lit_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","Neleisk šitai įstatymo knygai pasitraukti nuo tavo burnos, bet mąstyk apie ją dieną ir naktį, kad rūpestingai elgtumeisi veikdamas pagal viską, kas joje parašyta, nes tada padarysi savo kelią sėkmingą ir tada tau gerai klosis. ");
INSERT INTO lit_vpl VALUES ("JS1_9","007_1_9","JOS","1","9","9","Argi tau neįsakiau?! Būk stiprus ir drąsus! Nebijok ir nenusigąsk! Nes VIEŠPATS, tavo Dievas, yra su tavimi, kad ir kur eitum! ");
INSERT INTO lit_vpl VALUES ("JS5_15","007_5_15","JOS","5","15","15","Ir VIEŠPATIES kariuomenės vadas tarė Jozuei: „Nusiauk apavą nuo savo kojų, nes vieta, ant kurios tu stovi, yra šventa“. Jozuė taip ir padarė. ");
INSERT INTO lit_vpl VALUES ("JS7_1","007_7_1","JOS","7","1","1","Bet Izraelio vaikai įvykdė nusižengimą tuo, kas buvo paskirta neatšaukiamam tikslui, nes Zeracho sūnaus Zabdžio sūnaus Karmio sūnus Achanas iš Judo giminės pasiėmė iš to, kas buvo paskirta neatšaukiamam tikslui, ir VIEŠPATIES rūstybė užsidegė prieš Izraelio vaikus. ");
INSERT INTO lit_vpl VALUES ("JS7_20","007_7_20","JOS","7","20","20","Ir Achanas atsakydamas Jozuei tarė: „Iš tiesų nusidėjau aš prieš VIEŠPATĮ, Izraelio Dievą, ir padariau taip ir taip: ");
INSERT INTO lit_vpl VALUES ("JS7_21","007_7_21","JOS","7","21","21","pamatęs tarp pagrobtų daiktų gražų babilonietišką drabužį ir du šimtus šekelių sidabro, ir viena aukso luitą, sveriantį penkiasdešimt šekelių, jų užsigeidžiau ir juos pasiėmiau. Ir štai jie yra paslėpti žemėje, mano palapinės viduryje, o sidabras yra po juo“. ");
INSERT INTO lit_vpl VALUES ("JS11_23","007_11_23","JOS","11","23","23","Taip Jozuė paėmė visą šalį pagal visa tai, ką VIEŠPATS buvo kalbėjęs Mozei. Ir Jozuė ją davė kaip veldinį Izraeliui pagal jų genčių padalas. Ir šalis ilsėjosi nuo karo. ");
INSERT INTO lit_vpl VALUES ("JS13_1","007_13_1","JOS","13","1","1","O Jozuė buvo pasenęs ir sulaukęs senyvo amžiaus. Ir VIEŠPATS jam tarė: – Tu esi senas ir sulaukęs senyvo amžiaus, o dar lieka labai daug žemės užimti. ");
INSERT INTO lit_vpl VALUES ("JS14_8","007_14_8","JOS","14","8","8","Nors mano broliai, kurie ėjo aukštyn su manimi, tirpdė tautos širdį, bet aš iki galo sekiau VIEŠPAČIU, savo Dievu. ");
INSERT INTO lit_vpl VALUES ("JS21_43","007_21_43","JOS","21","43","43","Taigi Viešpats davė Izraeliui visą šalį, kurią jis buvo prisiekęs duoti jų tėvams, ir jie užėmė ją ir įsikūrė joje. ");
INSERT INTO lit_vpl VALUES ("JS23_11","007_23_11","JOS","23","11","11","Užtat atidžiai žiūrėkite dėl savęs, kad mylėtumėte VIEŠPATĮ, savo Dievą. ");
INSERT INTO lit_vpl VALUES ("JS23_14","007_23_14","JOS","23","14","14","Ir štai šią dieną einu visos žemės keliu. O jūs žinote visa savo širdimi ir visa savo siela, kad neliko neįvykdytas nė vienas iš visų gerų dalykų, kuriuos VIEŠPATS, jūsų Dievas, jums pažadėjo; visi jums įvyko, iš jų neliko neįvykdytas nė vienas dalykas. ");
INSERT INTO lit_vpl VALUES ("JS23_15","007_23_15","JOS","23","15","15","Todėl įvyks, kad kaip jums atėjo visi geri dalykai, kuriuos VIEŠPATS, jūsų Dievas, jums pažadėjo, taip VIEŠPATS jums siųs visus blogus dalykus, kol jis išnaikins jus iš šitos geros šalies, kurią VIEŠPATS, jūsų Dievas, jums yra davęs. ");
INSERT INTO lit_vpl VALUES ("JS23_16","007_23_16","JOS","23","16","16","Jeigu jūs nusižengsite VIEŠPATIES, savo Dievo, sandorai, kurią jis yra jums įsakęs, ir nuėję tarnausite kitiems dievams ir jiems nusilenksite, tai VIEŠPATIES rūstybė užsidegs prieš jus, ir jūs greitai pražūsite iš tos geros šalies, kurią jis jums yra davęs. ");
INSERT INTO lit_vpl VALUES ("JS24_15","007_24_15","JOS","24","15","15","Ir jei jūs laikote tai blogu dalyku tarnauti VIEŠPAČIUI, rinkitės šiandien, kam tarnausite: dievams, kurie buvo Užupyje, kuriems jūsų tėvai tarnavo, ar dievams amoritų, kurių krašte gyvenate; bet štai dėl manęs ir mano namų – mes tarnausime VIEŠPAČIUI. ");
INSERT INTO lit_vpl VALUES ("JS24_24","007_24_24","JOS","24","24","24","Ir tauta tarė Jozuei: „VIEŠPAČIUI, savo Dievui, tarnausime ir jo balsui paklusime! ");
INSERT INTO lit_vpl VALUES ("JS24_31","007_24_31","JOS","24","31","31","Ir Izraelis tarnavo VIEŠPAČIUI per visas Jozuės dienas ir per visas dienas vyresniųjų, kurie gyveno ilgiau už Jozuę ir kurie žinojo visus VIEŠPATIES darbus, kuriuos jis buvo padaręs Izraeliui. ");
INSERT INTO lit_vpl VALUES ("JG6_14","008_6_14","JDG","6","14","14","Ir VIEŠPATS atsigręžė į jį ir tarė: „Eik su šita savo jėga ir išgelbėk Izraelį iš midjaniečių rankos! Ar aš tavęs nesiunčiu?“ ");
INSERT INTO lit_vpl VALUES ("JG16_28","008_16_28","JDG","16","28","28","Ir Samsonas šaukėsi VIEŠPATIES ir tarė: „O Valdove VIEŠPATIE, atsimink mane, meldžiu, ir sustiprink mane, meldžiu, tik šitą vieną kartą, o Dieve, kad atkeršyčiau filistinams vienu kartu už abi mano akis. ");
INSERT INTO lit_vpl VALUES ("JG17_6","008_17_6","JDG","17","6","6","Tomis dienomis Izraelyje karaliaus nebuvo. Kiekvienas darė tai, kas jo akimis atrodė teisinga. ");
INSERT INTO lit_vpl VALUES ("JG20_16","008_20_16","JDG","20","16","16","Tarp visų šitų žmonių buvo septyni šimtai rinktinių vyrų kairiarankių. Kiekvienas jų sugebėjo sviesti svaidykle akmenį į plauką ir neprašauti. ");
INSERT INTO lit_vpl VALUES ("JG20_42","008_20_42","JDG","20","42","42","Tad Izraelio vyrų akivaizdoje jie pasisuko į dykumos kelią, bet mūšis pasivijo juos, ir išėjusius iš miestų jie pragaišino jų tarpe. ");
INSERT INTO lit_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Tada parpuolus kniūbsčia ir nusilenkus į žemę, ji jam tarė: „Kodėl esu radusi malonę tavo akyse, jog į mane atkreipei dėmesį? Juk aš svetimšalė!“ ");
INSERT INTO lit_vpl VALUES ("S11_1","010_1_1","1SA","1","1","1","Štai buvo tam tikras vyras iš Ramataim-Cofimų, iš Efraimo kalnyno, vardu Elkana, efratiečio Cūfo sūnaus Tohuvo sūnaus Elihuvo sūnaus Jerohamo sūnus. ");
INSERT INTO lit_vpl VALUES ("S11_2","010_1_2","1SA","1","2","2","Ir jis turėjo dvi žmonas: pirmosios vardas buvo Ona, o antrosios vardas – Penina. Penina turėjo vaikų, bet Ona neturėjo vaikų. ");
INSERT INTO lit_vpl VALUES ("S11_3","010_1_3","1SA","1","3","3","Ir šis vyras kasmet iš savo miesto eidavo aukštyn garbinti ir aukoti kareivijų VIEŠPAČIUI Šilojyje. Ir ten buvo du Elio sūnūs, Hofnis ir Finehasas, VIEŠPATIES kunigai. ");
INSERT INTO lit_vpl VALUES ("S12_2","010_2_2","1SA","2","2","2","Niekas nėra toks šventas kaip VIEŠPATS, nes be tavęs nėra kito tokio ir nėra uolos tokios, kaip mūsų Dievas. ");
INSERT INTO lit_vpl VALUES ("S12_9","010_2_9","1SA","2","9","9","Jis apsaugos savo šventųjų kojas, o nedorėliai nutildomi tamsoje, nes savo jėga joks žmogus nenugalės. ");
INSERT INTO lit_vpl VALUES ("S12_30","010_2_30","1SA","2","30","30","Todėl VIEŠPATS, Izraelio Dievas, prabyla: „Tikrai pažadėjau, kad tavo namai ir tavo tėvo namai per amžius vaikščios mano akivaizdoje. Bet dabar VIEŠPATS prabyla: „Tai tebūna toli nuo manęs! Nes mane gerbiančius aš gerbsiu, bet mane niekinantys bus prakeikti! ");
INSERT INTO lit_vpl VALUES ("S13_1","010_3_1","1SA","3","1","1","Ir berniukas Samuelis tarnavo VIEŠPAČIUI Elio akivaizdoje. O VIEŠPATIES žodis buvo retas tomis dienomis – pranašiškas regėjimas nebuvo paplitęs reiškinys. ");
INSERT INTO lit_vpl VALUES ("S13_9","010_3_9","1SA","3","9","9","Ir Elis tarė Samueliui: „Eik, atsigulk ir bus šitaip: jei tave pašauks, pasakysi: „Kalbėk, VIEŠPATIE, nes tavo tarnas klauso.“ Taigi Samuelis nuėjęs atsigulė į savo vietą. ");
INSERT INTO lit_vpl VALUES ("S13_19","010_3_19","1SA","3","19","19","O Samuelis augo, ir VIEŠPATS buvo su juo ir neleido nė vienam iš jo žodžių likti neįvykdytam. ");
INSERT INTO lit_vpl VALUES ("S18_3","010_8_3","1SA","8","3","3","Tačiau jo sūnūs nevaikščiojo jo keliais, bet palinko į neteisų pelną ir ėmė kyšius ir iškraipė teisingumą. ");
INSERT INTO lit_vpl VALUES ("S112_23","010_12_23","1SA","12","23","23","O dėl manęs, tebūnie toli nuo manęs tai, kad aš nusidėčiau prieš VIEŠPATĮ, paliaudamas melstis už jus; bet aš jus mokysiu gero ir tiesaus kelio: ");
INSERT INTO lit_vpl VALUES ("S112_24","010_12_24","1SA","12","24","24","tik bijokite VIEŠPATIES ir jam tarnaukite ištikimai visa savo širdimi; būtinai įbeskite akis į tai, kokius didžius dalykus jis yra jums padaręs! ");
INSERT INTO lit_vpl VALUES ("S113_1","010_13_1","1SA","13","1","1","Saulius buvo vienerių metų sūnus, kai jis pradėjo karaliauti, ir jis karaliavo Izraeliui dvejus metus. ");
INSERT INTO lit_vpl VALUES ("S113_14","010_13_14","1SA","13","14","14","Bet dabar tavo karaliavimas neišliks; VIEŠPATS pasiieškojo vyrą, atitinkantį savo širdį, ir VIEŠPATS jam įsakė būti valdovu savo tautai, nes tu nesilaikei to, ką VIEŠPATS tau įsakė. ");
INSERT INTO lit_vpl VALUES ("S115_11","010_15_11","1SA","15","11","11","Esu atgailavęs, kad padariau Saulių karaliumi, nes jis nusigręžė nuo sekimo paskui mane ir neįvykdė mano įsakymų. Ir tai sukėlė Samueliui sielvartą ir jis šaukėsi VIEŠPATIES visą naktį. ");
INSERT INTO lit_vpl VALUES ("S115_22","010_15_22","1SA","15","22","22","Ir Samuelis tarė: „Argi VIEŠPATĮ džiugina deginamosios aukos ir pjaunamosios aukos kaip jį džiugina paklusnumas VIEŠPATIES žodžiui? Dėmesio! Paklusnumas yra geresnis už auką, ir klausymas yra geresnis už avinų taukus. ");
INSERT INTO lit_vpl VALUES ("S115_23","010_15_23","1SA","15","23","23","Nes maištavimas yra kaip raganavimo nuodėmė, ir savavaliavimas – kaip nedorybė bei stabgarbystė. Kadangi tu atmetei VIEŠPATIES žodį, tai jis ir atmetė tave, kad nebebūtum karaliumi. ");
INSERT INTO lit_vpl VALUES ("S115_29","010_15_29","1SA","15","29","29","Be to, Izraelio Pastovusis negali nei meluoti, nei atgailauti, nes jis ne žmogus, kad turėtų atgailauti. ");
INSERT INTO lit_vpl VALUES ("S115_35","010_15_35","1SA","15","35","35","Ir Samuelis daugiau nepasimatė su Sauliumi iki savo mirties dienos, nors Samuelis liūdėjo dėl Sauliaus. O VIEŠPATS atgailavo, kad buvo padaręs Saulių Izraelio karaliumi. ");
INSERT INTO lit_vpl VALUES ("S116_7","010_16_7","1SA","16","7","7","Bet VIEŠPATS tarė Samueliui: „Nežiūrėk į jo išvaizdą ar į jo aukštą ūgį, kadangi jį atmečiau. Nes VIEŠPATS mato ne taip, kaip žmogus mato: nes žmogus žiūri į išorę, bet VIEŠPATS žiūri į širdį. ");
INSERT INTO lit_vpl VALUES ("S117_29","010_17_29","1SA","17","29","29","Ir Dovydas tarė: „Ką gi dabar padariau? Argi nėra reikalo?!“ ");
INSERT INTO lit_vpl VALUES ("S117_47","010_17_47","1SA","17","47","47","Ir visas šitas susirinkimas žinos, kad VIEŠPATS išgelbsti ne kalaviju ir ietimi, nes ši mūšis yra VIEŠPATIES, ir jis atiduos jus į mūsų rankas.“ ");
INSERT INTO lit_vpl VALUES ("S118_14","010_18_14","1SA","18","14","14","Ir Dovydas išmintingai elgėsi visuose savo keliuose; ir VIEŠPATS buvo su juo. ");
INSERT INTO lit_vpl VALUES ("S25_8","011_5_8","2SA","5","8","8","Ir tą dieną Dovydas tarė: „Kas sumuštų jebusiečius, tegul vandens tuneliu pasiekia ir „raišuosius“ ir „akluosius“, kurių nekenčia Dovydo siela.“ Todėl žmonės sakė: „Aklas ir raišas neturi įeiti į namus“. ");
INSERT INTO lit_vpl VALUES ("S25_23","011_5_23","2SA","5","23","23","Ir kai Dovydas pasiklausė VIEŠPATIES, jis tarė: „Neik aukštyn, bet apeik juos ratu iš užnugario ir prieik prie jų priešais balzamo medžius. ");
INSERT INTO lit_vpl VALUES ("S25_24","011_5_24","2SA","5","24","24","Ir tebus, kai išgirsi žingsniavimo šlamesį balzamo medžių viršūnėse, tuojau veik, nes tada VIEŠPATS bus išėjęs tavo priekyje filistinų kariuomenės mušti. ");
INSERT INTO lit_vpl VALUES ("S27_15","011_7_15","2SA","7","15","15","Bet mano palankumas nenukryps nuo jo, kaip jį nukreipiau nuo Sauliaus, kurį pašalinau prieš tave. ");
INSERT INTO lit_vpl VALUES ("S27_22","011_7_22","2SA","7","22","22","Todėl tu esi didis, o VIEŠPATIE Dieve, nes nėra nė vieno tau lygaus, ir išskyrus tave, nėra Dievo, kaip byloja visa, ką esame girdėję savo ausimis. ");
INSERT INTO lit_vpl VALUES ("S211_27","011_11_27","2SA","11","27","27","O gedului praėjus, Dovydas siuntė pasiuntinį ir ją atvedė į savo namus, ir ji tapo jo žmona ir pagimdė jam sūnų. Bet tas dalykas, kurį Dovydas buvo padaręs, VIEŠPATIES akyse buvo blogis. ");
INSERT INTO lit_vpl VALUES ("S217_23","011_17_23","2SA","17","23","23","O Ahitofelis, pamatęs, kad jo patarimas nebuvo vykdomas, pasibalnojo asilą, ir pakilo, ir parvyko namo į savo miestą, ir sutvarkė savo namų reikalus, ir pasikorė, ir mirė, ir buvo palaidotas savo tėvo kape. ");
INSERT INTO lit_vpl VALUES ("S222_1","011_22_1","2SA","22","1","1","Ir Dovydas kalbėjo VIEŠPAČIUI šitos giesmės žodžius tą dieną, kai VIEŠPATS jį išgelbėjo iš visų jo priešų rankų ir iš Sauliaus rankų. ");
INSERT INTO lit_vpl VALUES ("S222_2","011_22_2","2SA","22","2","2","Jis tarė: „VIEŠPATS yra mano uola ir mano tvirtovė ir mano išvaduotojas, ");
INSERT INTO lit_vpl VALUES ("S222_3","011_22_3","2SA","22","3","3","mano Dievas, mano uola – bėgsiu prieglaudon pas jį. Jis yra mano skydas ir mano išgelbėjimo ragas, mano aukšta prieglauda ir mano priebėga, mano išgelbėtojas – tu išgelbsti mane nuo smurto! ");
INSERT INTO lit_vpl VALUES ("S222_4","011_22_4","2SA","22","4","4","Šauksiuosi VIEŠPATIES, kuris vertas gyriaus, ir būsiu išgelbėtas iš savo priešų. ");
INSERT INTO lit_vpl VALUES ("S222_31","011_22_31","2SA","22","31","31","Tikras Dievas – jo kelias yra tobulas, VIEŠPATIES žodis yra patikimas; jis yra skydas visiems, kurie pasitiki juo. ");
INSERT INTO lit_vpl VALUES ("S222_32","011_22_32","2SA","22","32","32","Nes kas yra Dievas, jei ne VIEŠPATS? Ir kas yra uola, jei ne mūsų Dievas? ");
INSERT INTO lit_vpl VALUES ("S222_36","011_22_36","2SA","22","36","36","Tu man davei savo išgelbėjimo skydą ir tavo švelnumas padarė mane didį. ");
INSERT INTO lit_vpl VALUES ("S223_2","011_23_2","2SA","23","2","2","VIEŠPATIES Dvasia kalbėjo per mane, ir jo žodis buvo ant mano liežuvio. ");
INSERT INTO lit_vpl VALUES ("K13_14","012_3_14","1KI","3","14","14","Ir jei vaikščiosi mano keliais, laikydamasis mano nuostatų ir įsakymų, kaip vaikščiojo tavo tėvas Dovydas, tai prailginsiu tavo dienas. ");
INSERT INTO lit_vpl VALUES ("K18_39","012_8_39","1KI","8","39","39","tuomet išklausyk danguje, savo gyvenamoje vietoje, ir atleisk, ir veik, ir duok kiekvienam pagal visus jo kelius, kurio širdį tu pažįsti, nes tu – tu vienas – pažįsti visų žmonių palikuonių širdis, ");
INSERT INTO lit_vpl VALUES ("K18_56","012_8_56","1KI","8","56","56","„Tebūna palaimintas VIEŠPATS, kuris davė poilsį savo tautai Izraeliui pagal visa tai, ką buvo pažadėjęs; nė vienas žodis neliko neįvykdytas iš viso jo gerojo pažado, kurį jis kalbėjo per savo tarną Mozę. ");
INSERT INTO lit_vpl VALUES ("K119_19","012_19_19","1KI","19","19","19","Taigi jis ėjo iš ten ir surado Šafato sūnų Eliziejų, ariantį su dvylika jungų jaučių pirma jo, o jis pats buvo su dvyliktuoju. Ir Elijas, praeidamas pro jį, užmetė ant jo savo skraistę. ");
INSERT INTO lit_vpl VALUES ("K122_34","012_22_34","1KI","22","34","34","Ir kažkoks vyras įtempė lanką specialiai netaikydamas ir įšovė Izraelio karaliui tarp pridurtinių šarvų ir krūtinšarvio; todėl jis tarė savo vežimo važiuotojui: „Suk atgal ir vežk mane iš mūšio, nes esu sužeistas. ");
INSERT INTO lit_vpl VALUES ("K29_20","013_9_20","2KI","9","20","20","Ir sargybinis pranešė, sakydamas: „Jis pasiekė juos, bet negrįžta; o važiuosena – kaip Nimšio sūnaus Jehuvo važiuosena, nes jis vairuoja nutrūktgalviškai.“ ");
INSERT INTO lit_vpl VALUES ("K215_12","013_15_12","2KI","15","12","12","Šis buvo VIEŠPATIES žodis, kurį jis kalbėjo Jehuvui, sakydamas: „Tavo sūnūs sėdės Izraelio soste iki ketvirtosios kartos.“ Taip ir įvyko. ");
INSERT INTO lit_vpl VALUES ("K222_14","013_22_14","2KI","22","14","14","Taigi kunigas Hilkijas ir Ahikamas ir Achboras ir Šafanas ir Asaja nuėjo pas pranašę Huldą, žmoną Šalumo, Tikvos sūnaus, Harhaso sūnaus, drabužių saugotojo (o ji gyveno Jeruzalėje, antroje dalyje), ir jie kalbėjosi su ja. ");
INSERT INTO lit_vpl VALUES ("R14_9","014_4_9","1CH","4","9","9","Jabecas buvo labiau gerbtinas už savo brolius; be to, jo motina pavadino jį vardu Jabecas, sakydama: „Nes aš jį pagimdžiau skausme. ");
INSERT INTO lit_vpl VALUES ("R14_10","014_4_10","1CH","4","10","10","Jabecas šaukėsi Izraelio Dievo, sakydamas: „Ak, kad tu mane laiminte palaimintum ir praplėstum mano sritį, kad tavo ranka būtų su manim ir kad saugotum nuo blogio, kad manęs nevargintų! Ir Dievas davė, ko jis prašė. ");
INSERT INTO lit_vpl VALUES ("R16_31","014_6_31","1CH","6","31","31","O šitie yra tie, kuriuos Dovydas pastatė vadovauti giedojimo tarnystei VIEŠPATIES namuose po to, kai skrynia buvo padėta į atilsio vietą, ");
INSERT INTO lit_vpl VALUES ("R16_32","014_6_32","1CH","6","32","32","ir kurie, iki Saliamonas pastatė Viešpaties namus Jeruzalėje, tarnavo giedodami priešais susitikimo palapinės padangtę, eidami pareigas pagal jiems nustatytą tvarką. ");
INSERT INTO lit_vpl VALUES ("R111_20","014_11_20","1CH","11","20","20","O Joabo brolis Abišajas buvo Trijulės vadas, nes, pakėlęs savo ietį prieš tris šimtus, jis juos išžudė ir laimėjo sau vardą Trijulėje. ");
INSERT INTO lit_vpl VALUES ("R116_12","014_16_12","1CH","16","12","12","Atsiminkite jo nuostabius darbus, kuriuos jis padarė, jo stebuklus ir jo burnos nuosprendžius, ");
INSERT INTO lit_vpl VALUES ("R116_29","014_16_29","1CH","16","29","29","Suteikite VIEŠPAČIUI šlovę, priklausančią jo vardui, atneškite auką ir ateikite jo akivaizdon, garbinkite VIEŠPATĮ šventumo grožyje. ");
INSERT INTO lit_vpl VALUES ("R116_34","014_16_34","1CH","16","34","34","Dėkokite VIEŠPAČIUI, nes jis geras, nes jo gailestingumas išlieka per amžius! ");
INSERT INTO lit_vpl VALUES ("R116_35","014_16_35","1CH","16","35","35","Ir sakykite: „Išgelbėk mus, o mūsų išgelbėjimo Dieve, ir surink mus ir išvaduok iš kitataučių, kad dėkotume tavo šventajam vardui ir kad girtumėmės tavo girtinais veiksmais. ");
INSERT INTO lit_vpl VALUES ("R117_27","014_17_27","1CH","17","27","27","Taigi dabar teikis palaiminti savo tarno namus, kad jie amžinai būtų tavo akivaizdoje. Kadangi tu, VIEŠPATIE, palaiminai, jie bus palaiminti amžinai. ");
INSERT INTO lit_vpl VALUES ("R122_9","014_22_9","1CH","22","9","9","Štai tau gims sūnus, kuris bus ramus vyras, o aš jam duosiu ramybę nuo visų aplinkinių priešų. Mat jo vardas bus Saliamonas ir jo dienomis Izraeliui suteiksiu taiką ir ramybę. ");
INSERT INTO lit_vpl VALUES ("R122_12","014_22_12","1CH","22","12","12","Tik VIEŠPATS teduoda tau išminties bei įžvalgumo ir teįsako tau dėl Izraelio, kad laikytumeisi VIEŠPATIES, savo Dievo, įstatymo. ");
INSERT INTO lit_vpl VALUES ("R122_13","014_22_13","1CH","22","13","13","Tada tau seksis, jei užtikrinsi, kad įvykdytum nuostatus ir potvarkius, kuriuos Viešpats įsakė Mozei dėl Izraelio. Būk stiprus ir drąsus, nebijok ir nenusigąsk! ");
INSERT INTO lit_vpl VALUES ("R122_19","014_22_19","1CH","22","19","19","Dabar nukreipkite savo širdį ir savo sielą ieškoti VIEŠPATIES, savo Dievo; taigi pakilkite ir statykite VIEŠPATIES Dievo šventyklą, kad įneštumėte VIEŠPATIES sandoros skrynią ir Dievo šventus indus į namus, statomus VIEŠPATIES vardui. ");
INSERT INTO lit_vpl VALUES ("R123_1","014_23_1","1CH","23","1","1","Taigi kai Dovydas buvo pasenęs ir pasisotinęs dienomis, jis paskyrė savo sūnų Saliamoną karaliumi virš Izraelio. ");
INSERT INTO lit_vpl VALUES ("R128_9","014_28_9","1CH","28","9","9","O tu, mano sūnau Saliamonai, pažink savo tėvo Dievą ir tarnauk jam vientisa širdimi ir noringa siela, nes VIEŠPATS ištiria visas širdis ir supranta visus minčių siekius. Jeigu ieškosi jo, jis leis, kad tu jį surastum, bet jeigu paliksi jį, jis atmes tave amžinai. ");
INSERT INTO lit_vpl VALUES ("R128_19","014_28_19","1CH","28","19","19","Sakė Dovydas: „Jis davė suprasti visa tai – visus šio šablono dirbinius – per raštą nuo VIEŠPATIES rankos ant manęs.“ ");
INSERT INTO lit_vpl VALUES ("R128_20","014_28_20","1CH","28","20","20","Ir Dovydas tarė savo sūnui Saliamonui: „Būk stiprus ir drąsus ir daryk tai, nebijok ir nenusigąsk, nes VIEŠPATS Dievas, mano Dievas, bus su tavimi! Jis nenustos palaikyti tavęs ir nepasitrauks nuo tavęs, iki bus baigtas visas paruošimo darbas VIEŠPATIES namų tarnavimui. ");
INSERT INTO lit_vpl VALUES ("R129_11","014_29_11","1CH","29","11","11","Tavo, VIEŠPATIE, yra didybė, jėga, šlovė, pergalė ir kilnybė, nes viskas danguje ir žemėje yra tavo; tavo yra karalystė, VIEŠPATIE, ir tu esi išaukštintas kaip galva viršum visko. ");
INSERT INTO lit_vpl VALUES ("R129_14","014_29_14","1CH","29","14","14","Bet kas gi aš ir kas mano tauta, kad pajėgtume taip noriai šitaip aukoti? Juk iš Tavęs ateina viskas, ir tau davėme tik tai, ką gavome iš tavo rankos. ");
INSERT INTO lit_vpl VALUES ("R27_14","015_7_14","2CH","7","14","14","ir jei nusižemins mano tauta, kuri vadinasi mano vardu, jei jie melsis ir ieškos mano veido, ir gręšis nuo savo nedorų kelių, tada aš tikrai klausysiuos iš dangaus, atleisiu jų nuodėmę ir išgydysiu jų šalį. ");
INSERT INTO lit_vpl VALUES ("R213_12","015_13_12","2CH","13","12","12","Ir štai su mumis yra pats Dievas kaip vadas ir jo kunigai su gaudžiančiais trimitais, kad garsiai skelbtų prieš jus kovos signalą. O Izraelio vaikai, nekovokite prieš VIEŠPATĮ, savo tėvų Dievą, nes jums nesiseks.“ ");
INSERT INTO lit_vpl VALUES ("R214_11","015_14_11","2CH","14","11","11","Tada Asa šaukėsi VIEŠPATIES, savo Dievo, ir tarė: „VIEŠPATIE, tau nesunku padėti tiek tiems, kurių daug, tiek tiems, kurie yra be galios! Padėk mums, o VIEŠPATIE, mūsų Dieve, nes mes remiamės tavimi ir tavo vardu einame prieš šitą daugybę. O VIEŠPATIE, tu esi mūsų Dievas! Neleisk jokiam žmogui savęs nugalėti!“ ");
INSERT INTO lit_vpl VALUES ("R215_7","015_15_7","2CH","15","7","7","Bet jūs būkite stiprūs ir tenenusilpsta jūsų rankos, nes jums bus atmokėta už darbą!“ ");
INSERT INTO lit_vpl VALUES ("R216_9","015_16_9","2CH","16","9","9","Nes VIEŠPATIES akys žvalgosi aplinkui po visą žemę, kad pasirodytų stiprus dėl tų, kurių širdis yra vientisa prieš jį. Šiuo atveju tu kvailai pasielgei, todėl nuo šiol tau bus karų.“ ");
INSERT INTO lit_vpl VALUES ("R218_4","015_18_4","2CH","18","4","4","Ir Juozapatas tarė Izraelio karaliui: „Meldžiu tave, pirmiausia pasiteirauk VIEŠPATIES žodžio.“ ");
INSERT INTO lit_vpl VALUES ("R219_11","015_19_11","2CH","19","11","11","Ir štai vyriausiasis kunigas Amarijas yra viršesnis už jus visuose VIEŠPATIES reikaluose, o Izmaelio sūnus Zebadijas, Judo namų vadas, visuose karaliaus reikaluose, o levitai bus pareigūnai jūsų akivaizdoje. Būkite stiprūs ir veikite, ir VIEŠPATS tebūna su tuo, kuris geras.“ ");
INSERT INTO lit_vpl VALUES ("R220_12","015_20_12","2CH","20","12","12","O mūsų Dieve, argi tu nenuteisi jų? Nes esame bejėgiai prieš šitą didelį būrį, atžygiuojantį prieš mus, ir nežinome, ką daryti, – bet mūsų akys nukreiptos į tave. ");
INSERT INTO lit_vpl VALUES ("R225_9","015_25_9","2CH","25","9","9","Ir Amacijas tarė Dievo vyrui: „Bet ką daryti su šimtu talentų, kuriuos daviau Izraelio pulkui?“ Ir Dievo vyras atsakė: „VIEŠPATS yra pajėgus tau duoti kur kas daugiau negu tai.“ ");
INSERT INTO lit_vpl VALUES ("R231_5","015_31_5","2CH","31","5","5","Ir vos tik įsakymui plačiai pasklidus, Izraelio vaikai gausiai atnešė pirmavaisius javų, vyno, aliejaus, medaus ir viso laukų prieaugio; jie gausiai atnešė visko dešimtinę. ");
INSERT INTO lit_vpl VALUES ("R231_21","015_31_21","2CH","31","21","21","Ir ieškodamas savo Dievo visais atžvilgiais – kiekvieno darbo, kurį jis ėmėsi daryti Dievo namų tarnavime, ir įstatymo, ir įsakymo atžvilgiais, – jis dirbo iš visos savo širdies, ir jam sekėsi. ");
INSERT INTO lit_vpl VALUES ("R232_8","015_32_8","2CH","32","8","8","su juo yra kūno ranka, bet su mumis yra VIEŠPATS, mūsų Dievas, kad mums padėtų ir kovotų mūsų kovas. Ir tauta pasirėmė Judo karaliaus Chezekijo žodžiais. ");
INSERT INTO lit_vpl VALUES ("ER8_22","016_8_22","EZR","8","22","22","Nes man buvo gėda iš karaliaus prašyti kareivių būrio ir raitelių, kad mus apgintų nuo kokio nors priešo kelyje, nes buvome kalbėję karaliui, sakydami: „Mūsų Dievo ranka yra ant visų tų, kurie jo ieško – jų pačių labui, bet jo galybė ir jo rūstybė yra prieš visus, kurie jį palieka.“ ");
INSERT INTO lit_vpl VALUES ("NH1_3","017_1_3","NEH","1","3","3","Ir jie man sakė: „Žmonių likutis, kuris išliko iš paėmimo į nelaisvę, ten provincijoje yra dideliame varge ir gėdoje. Be to, Jeruzalės siena sugriauta, ir jos vartai sudeginti ugnimi.“ ");
INSERT INTO lit_vpl VALUES ("NH2_4","017_2_4","NEH","2","4","4","Tada karalius man tarė: „Ko gi tu prašai?“ Tai pasimeldžiau dangaus Dievui ");
INSERT INTO lit_vpl VALUES ("NH2_20","017_2_20","NEH","2","20","20","Tada atsakydamas jiems tariau: „Pats dangaus Dievas mums duos pasisekimą, o mes, jo tarnai, pakilsime ir statysime. Bet jūs neturite nei dalies, nei teisės, nei atminimo Jeruzalėje.“ ");
INSERT INTO lit_vpl VALUES ("NH3_5","017_3_5","NEH","3","5","5","O šalia jų taisė tekojiečiai, tačiau jų didikai nepalenkė savo sprandų prie savo Viešpaties darbo. ");
INSERT INTO lit_vpl VALUES ("NH4_2","017_4_2","NEH","4","2","2","Ir jis kalbėjo savo brolių ir Samarijos kariuomenės akivaizdoje, sakydamas: „Ką daro tie suglebę žydai? Ar jie sau atstatys? Ar jie aukos aukas? Ar jie užbaigs per dieną? Ar jie atgaivins sudegusius akmenis iš šiukšlių krūvų?“ ");
INSERT INTO lit_vpl VALUES ("NH4_6","017_4_6","NEH","4","6","6","O mes toliau statėme sieną, ir visa siena iki pusės buvo sujungta, nes žmonės į darbą įdėjo širdį. ");
INSERT INTO lit_vpl VALUES ("NH5_19","017_5_19","NEH","5","19","19","O mano Dieve, atsimink mane su palankumu dėl visko, ką esu nuveikęs šiai tautai! ");
INSERT INTO lit_vpl VALUES ("NH6_9","017_6_9","NEH","6","9","9","Nes jie visi stengėsi mus įbauginti, sakydami: „Nusilpnintos jų rankos nukris nuo darbo ir jis nebus užbaigtas.“ Taigi dabar, o Dieve, sustiprink mano rankas! ");
INSERT INTO lit_vpl VALUES ("NH8_10","017_8_10","NEH","8","10","10","Tada jis jiems tarė: „Eikite, valgykite tai, kas riebu, gerkite tai, kas saldu, ir pasiųskite dalį tiems, kuriems nieko nėra paruošta, nes ši diena yra šventa mūsų Viešpačiui; ir nesisielokite, nes VIEŠPATIES džiaugsmas yra jūsų stiprybė.“ ");
INSERT INTO lit_vpl VALUES ("NH9_17","017_9_17","NEH","9","17","17","Jie gi atsisakė klausyti ir neatsiminė tavo stebuklų, kuriuos tarp jų padarei; jie sukietino sprandą ir maištaudami išsirinko vadą, kad grįžtų į vergiją. Bet tu esi Dievas, kuris pasiruošęs atleisti, maloningas ir gailestingas, lėtas pykti ir kupinas gerumo, ir jų neapleidai. ");
INSERT INTO lit_vpl VALUES ("NH9_33","017_9_33","NEH","9","33","33","Tačiau tu esi teisus dėl viso, kas mus ištiko, nes tu darei teisingai, bet mes nedorai elgėmės. ");
INSERT INTO lit_vpl VALUES ("NH13_15","017_13_15","NEH","13","15","15","Tomis dienomis mačiau Jude kai kuriuos, mindančius vyno spaudykles šabo dieną ir įnešančius pėdus, ir kraunančius ant asilų, taip pat vyną, vynuoges, figas ir visokias naštas, kurias jie gabeno į Jeruzalę šabo dieną. Ir aš pakėliau įspėjimo balsą tą dieną, kai jie pardavinėjo maistą. ");
INSERT INTO lit_vpl VALUES ("NH13_31","017_13_31","NEH","13","31","31","ir įsakiau skirtu laiku atgabenti malkų ir pirmavaisių. O mano Dieve, atsimink mane su palankumu! ");
INSERT INTO lit_vpl VALUES ("ET1_1","018_1_1","EST","1","1","1","Ir taip įvyko Ahasvero dienomis, – to Ahasvero, kuris karaliavo šimtui dvidešimt septynioms provincijoms nuo Indijos iki Etiopijos, – ");
INSERT INTO lit_vpl VALUES ("ET4_14","018_4_14","EST","4","14","14","Nes jeigu iš tikrųjų šiuo metu tylėsi, tai erdvumas ir išvadavimas kils žydams iš kitos vietos, bet tu ir tavo tėvo namai pražūsite. O kas žino, gal kaip tik tokiam metui tu atėjusi į karališkąją padėtį? ");
INSERT INTO lit_vpl VALUES ("JB1_1","019_1_1","JOB","1","1","1","Uco šalyje buvo vyras, kurio vardas Jobas. Tas vyras buvo tobulas ir tiesus, ir toks, kuris bijojo Dievo ir vengė blogio. ");
INSERT INTO lit_vpl VALUES ("JB1_6","019_1_6","JOB","1","6","6","O tam tikrą dieną Dievo sūnūs atėjo prisistatyti VIEŠPATIES akivaizdon ir tarp jų atėjo ir Šėtonas. ");
INSERT INTO lit_vpl VALUES ("JB1_7","019_1_7","JOB","1","7","7","Ir VIEŠPATS tarė Šėtonui: „Iš kur ateini?“ Tada Šėtonas atsiliepdamas VIEŠPAČIUI tarė: „Iš apvaikščiojimo po žemę ir iš žvalgybos vaikštinėjimo po ją.“ ");
INSERT INTO lit_vpl VALUES ("JB1_8","019_1_8","JOB","1","8","8","O VIEŠPATS tarė Šėtonui: „Ar atkreipei dėmesį į mano tarną Jobą? Juk kito tokio kaip jis žemėje nėra. Tai tobulas ir tiesus vyras, kuris bijo Dievo ir vengia blogio.“ ");
INSERT INTO lit_vpl VALUES ("JB1_9","019_1_9","JOB","1","9","9","Tada Šėtonas atsiliepdamas VlEŠPAČIUI tarė: „Argi už nieką Jobas bijo Dievo? ");
INSERT INTO lit_vpl VALUES ("JB1_21","019_1_21","JOB","1","21","21","ir tarė: „Nuogas išėjau iš savo motinos įsčių ir nuogas sugrįšiu į ten; VIEŠPATS davė ir VIEŠPATS atėmė; tebūna palaimintas VIEŠPATIES vardas!“ ");
INSERT INTO lit_vpl VALUES ("JB2_2","019_2_2","JOB","2","2","2","Ir VIEŠPATS tarė Šėtonui: „Iš kur ateini?“ Tada Šėtonas atsiliepdamas VIEŠPAČIUI tarė: „Iš apvaikščiojimo po žemę ir iš žvalgybos vaikštinėjimo po ją.“ ");
INSERT INTO lit_vpl VALUES ("JB2_3","019_2_3","JOB","2","3","3","O VIEŠPATS tarė Šėtonui: „Ar atkreipei dėmesį į mano tarną Jobą? Juk kito tokio kaip jis žemėje nėra. Tai tobulas ir tiesus vyras, kuris bijo Dievo ir vengia blogio. Jis ir toliau tvirtai laikosi savo tobulumo, nors tu mane sukurstei prieš jį, kad jį be priežasties praryčiau.“ ");
INSERT INTO lit_vpl VALUES ("JB3_2","019_3_2","JOB","3","2","2","Ir Jobas atsiliepdamas tarė: ");
INSERT INTO lit_vpl VALUES ("JB3_20","019_3_20","JOB","3","20","20","Kodėl jis duoda šviesą tam, kuris kenčia, ir gyvybę tiems, kurie patys karčiai merdi, ");
INSERT INTO lit_vpl VALUES ("JB3_21","019_3_21","JOB","3","21","21","kurie ilgisi mirties, bet ji neateina; ir jos kasinėja labiau negu paslėptų lobių, ");
INSERT INTO lit_vpl VALUES ("JB4_1","019_4_1","JOB","4","1","1","Tada temanas Elifazas atsiliepdamas tarė: ");
INSERT INTO lit_vpl VALUES ("JB4_8","019_4_8","JOB","4","8","8","Remiantis tuo, ką esu matęs, tie, kurie įaria nedorybę ir sėja bėdą, tą patį ir pjauna. ");
INSERT INTO lit_vpl VALUES ("JB5_13","019_5_13","JOB","5","13","13","Jis sugauna gudruolius jų pačių klasta ir suktųjų sumanymams skubiai padaromas galas. ");
INSERT INTO lit_vpl VALUES ("JB5_17","019_5_17","JOB","5","17","17","Dėmesio! Koks didžiai palaimintas žmogus, kurį Dievas sudraudžia. Tad neniekink Visagalio drausmės, ");
INSERT INTO lit_vpl VALUES ("JB5_18","019_5_18","JOB","5","18","18","nes jis sužeidžia, bet ir aptvarsto; jis daužo, bet ir jo rankos išgydo. ");
INSERT INTO lit_vpl VALUES ("JB6_1","019_6_1","JOB","6","1","1","Bet Jobas atsiliepdamas tarė: ");
INSERT INTO lit_vpl VALUES ("JB7_10","019_7_10","JOB","7","10","10","Į savo namus jis nebesugrįš, ir jo vieta daugiau jo nebepažins. ");
INSERT INTO lit_vpl VALUES ("JB7_20","019_7_20","JOB","7","20","20","Aš nusidėjau. Ko lauki, kad dar padaryčiau, o žmonių Sarge? Kodėl padarei mane savo taikinį, taip, kad esu sau našta? ");
INSERT INTO lit_vpl VALUES ("JB9_1","019_9_1","JOB","9","1","1","Tada Jobas atsiliepdamas tarė: ");
INSERT INTO lit_vpl VALUES ("JB9_2","019_9_2","JOB","9","2","2","„Tikrai žinau, kad taip yra. Bet kaip gi žmogus gali būti teisus prieš Dievą? ");
INSERT INTO lit_vpl VALUES ("JB9_3","019_9_3","JOB","9","3","3","Jei kas panorėtų bylinėtis su juo, jis negalėtų jam atsakyti nė vieną kartą iš tūkstančio. ");
INSERT INTO lit_vpl VALUES ("JB9_4","019_9_4","JOB","9","4","4","Jis išmintingos širdies ir stiprios galios; kas gi užsikietino prieš jį ir išliko saugus?! ");
INSERT INTO lit_vpl VALUES ("JB10_1","019_10_1","JOB","10","1","1","Mano siela neapkenčia mano gyvenimo. Noriu išlieti savo skundą, kalbėti iš savo sielos kartėlio. ");
INSERT INTO lit_vpl VALUES ("JB11_1","019_11_1","JOB","11","1","1","Tada naamatietis Cofaras atsiliepdamas tarė: ");
INSERT INTO lit_vpl VALUES ("JB12_1","019_12_1","JOB","12","1","1","Ir Jobas atsiliepdamas tarė: ");
INSERT INTO lit_vpl VALUES ("JB13_15","019_13_15","JOB","13","15","15","Nors jis mane ir užmuštų, aš vis tiek juo pasitikėsiu; vis dėlto prieš jį ginsiu savo gyvenseną. ");
INSERT INTO lit_vpl VALUES ("JB14_4","019_14_4","JOB","14","4","4","Kas gali išgauti tai, kas švaru, iš to, kas nešvaru? Niekas. ");
INSERT INTO lit_vpl VALUES ("JB14_5","019_14_5","JOB","14","5","5","Kadangi jo dienos yra nustatytos, jo mėnesių skaičius yra tavo žinioje; tu nustatei jo ribas, kurių jis negali peržengti. ");
INSERT INTO lit_vpl VALUES ("JB15_1","019_15_1","JOB","15","1","1","Tada temanas Elifazas atsiliepdamas tarė: ");
INSERT INTO lit_vpl VALUES ("JB15_14","019_15_14","JOB","15","14","14","Kas yra žmogus, kad galėtų būti tyras, arba gimusis iš moters, kad galėtų būti teisus? ");
INSERT INTO lit_vpl VALUES ("JB15_15","019_15_15","JOB","15","15","15","Štai savo šventaisiais jis nepasitiki, ir dangūs yra netyras jo akyse. ");
INSERT INTO lit_vpl VALUES ("JB15_16","019_15_16","JOB","15","16","16","Tai kiek bjauresnis ir labiau suterštas yra žmogus, geriantis neteisybę kaip vandenį?! ");
INSERT INTO lit_vpl VALUES ("JB16_1","019_16_1","JOB","16","1","1","Tada Jobas atsiliepdamas tarė: ");
INSERT INTO lit_vpl VALUES ("JB18_1","019_18_1","JOB","18","1","1","Tada šuachas Bildadas atsiliepdamas tarė: ");
INSERT INTO lit_vpl VALUES ("JB19_1","019_19_1","JOB","19","1","1","Tada Jobas atsiliepdamas tarė: ");
INSERT INTO lit_vpl VALUES ("JB19_25","019_19_25","JOB","19","25","25","O aš – aš žinau, kad mano Išpirkėjas gyvas ir kad jis atsistos galiausiai ant žemės. ");
INSERT INTO lit_vpl VALUES ("JB19_26","019_19_26","JOB","19","26","26","Ir po to, kai bus pašalinta mano oda ir šitas kūnas, tada iš savo kūno regėsiu Dievą, ");
INSERT INTO lit_vpl VALUES ("JB19_27","019_19_27","JOB","19","27","27","kurį pats sau pamatysiu. Taip, jį matys mano akys, o ne koks nors svetimas! Alpstu ilgėdamasis! ");
INSERT INTO lit_vpl VALUES ("JB20_1","019_20_1","JOB","20","1","1","Tada naamatietis Cofaras atsiliepdamas tarė: ");
INSERT INTO lit_vpl VALUES ("JB21_1","019_21_1","JOB","21","1","1","Bet Jobas atsiliepdamas tarė: ");
INSERT INTO lit_vpl VALUES ("JB22_1","019_22_1","JOB","22","1","1","Tada temanas Elifazas atsiliepdamas tarė: ");
INSERT INTO lit_vpl VALUES ("JB22_28","019_22_28","JOB","22","28","28","Priimsi sprendimą ir tau jis liks įsigalėjęs, taip pat suspindės šviesa ant tavo kelių, ");
INSERT INTO lit_vpl VALUES ("JB23_1","019_23_1","JOB","23","1","1","Tada Jobas atsiliepdamas tarė: ");
INSERT INTO lit_vpl VALUES ("JB23_10","019_23_10","JOB","23","10","10","Bet jis pažįsta kelią priešais mane; jam ištyrus mane, išeisiu tarsi auksas. ");
INSERT INTO lit_vpl VALUES ("JB23_12","019_23_12","JOB","23","12","12","Nuo jo lūpų įsakymo neatsitraukiau; jo burnos žodžius vertinau labiau už savo būtiną maistą. ");
INSERT INTO lit_vpl VALUES ("JB25_1","019_25_1","JOB","25","1","1","Tada šuachas Bildadas atsiliepdamas tarė: ");
INSERT INTO lit_vpl VALUES ("JB25_4","019_25_4","JOB","25","4","4","Kaip tad žmogus gali būti išteisintas prieš Dievą? Arba kaip gimusis iš moters gali būti tyras? ");
INSERT INTO lit_vpl VALUES ("JB26_13","019_26_13","JOB","26","13","13","Savo Dvasia jis papuošė dangus, jo ranka supavidalino besirangančią gyvatę. ");
INSERT INTO lit_vpl VALUES ("JB28_28","019_28_28","JOB","28","28","28","O žmogui jis tarė: „Štai VIEŠPATIES baimė yra išmintis, ir šalintis nuo blogio – išmanymas. ");
INSERT INTO lit_vpl VALUES ("JB29_3","019_29_3","JOB","29","3","3","kai jo žibintas švietė virš mano galvos ir kai jo šviesoje ėjau per tamsą; ");
INSERT INTO lit_vpl VALUES ("JB30_9","019_30_9","JOB","30","9","9","O dabar esu jų pašaipos daina, ir jiems esu priežodis. ");
INSERT INTO lit_vpl VALUES ("JB31_1","019_31_1","JOB","31","1","1","Sudariau sandorą su savo akimis; tad kaipgi telksiu mintis į mergelę?! ");
INSERT INTO lit_vpl VALUES ("JB32_6","019_32_6","JOB","32","6","6","Ir buzito Barachelio sūnus Elihuvas atsiliepdamas tarė: „Aš jaunas, o jūs seni, todėl nedrįsau ir bijojau jums pareikšti savo nuomonės. ");
INSERT INTO lit_vpl VALUES ("JB32_8","019_32_8","JOB","32","8","8","Tačiau tikrai mirtinguosiuose žmonėse yra dvasia, ir Visagalio iškvėpta dvasia duoda jiems supratimą. ");
INSERT INTO lit_vpl VALUES ("JB33_13","019_33_13","JOB","33","13","13","Kodėl kovoji prieš jį, kad jis neatsakinėja į visus jo žodžius? ");
INSERT INTO lit_vpl VALUES ("JB34_1","019_34_1","JOB","34","1","1","O Elihuvas atsiliepdamas tarė: ");
INSERT INTO lit_vpl VALUES ("JB34_21","019_34_21","JOB","34","21","21","nes jo akys stebi žmogaus kelius ir jis mato visus jo žingsnius. ");
INSERT INTO lit_vpl VALUES ("JB34_22","019_34_22","JOB","34","22","22","Nėra nei tamsos, nei mirties šešėlio, kur galėtų pasislėpti blogadariai. ");
INSERT INTO lit_vpl VALUES ("JB34_32","019_34_32","JOB","34","32","32","Pamokyk mane to, ko nematau! Jei dariau neteisybę, daugiau to nedarysiu. ");
INSERT INTO lit_vpl VALUES ("JB35_1","019_35_1","JOB","35","1","1","Ο Elihuvas atsiliepdamas tarė: ");
INSERT INTO lit_vpl VALUES ("JB38_1","019_38_1","JOB","38","1","1","Tada VIEŠPATS atsiliepdamas Jobui iš viesulo tarė: ");
INSERT INTO lit_vpl VALUES ("JB38_41","019_38_41","JOB","38","41","41","Kas paruošia varnui jo peną, kai jo jaunikliai šaukiasi Dievo, klaidžioja aplinkui dėl lesalo stokos? ");
INSERT INTO lit_vpl VALUES ("JB40_1","019_40_1","JOB","40","1","1","Tada VIEŠPATS atsiliepdamas Jobui tarė: ");
INSERT INTO lit_vpl VALUES ("JB40_3","019_40_3","JOB","40","3","3","Tadas Jobas atsiliepdamas VIEŠPAČIUI tarė: ");
INSERT INTO lit_vpl VALUES ("JB40_6","019_40_6","JOB","40","6","6","Tada VIEŠPATS atsiliepdamas Jobui iš viesulo tarė: ");
INSERT INTO lit_vpl VALUES ("JB40_19","019_40_19","JOB","40","19","19","Jis yra Dievo veikalų šedevras; tik jo Kūrėjas gali priartinti savo kalaviją prie jo. ");
INSERT INTO lit_vpl VALUES ("JB42_1","019_42_1","JOB","42","1","1","Tada Jobas atsiliepdamas VIEŠPAČIUI tarė: ");
INSERT INTO lit_vpl VALUES ("JB42_2","019_42_2","JOB","42","2","2","„Žinau, kad tu pajėgi padaryti visa ir kad joks tavo sumanymas nebus sukliudytas. ");
INSERT INTO lit_vpl VALUES ("JB42_6","019_42_6","JOB","42","6","6","Todėl aš bjauriuosi savimi ir atgailauju dulkėse ir pelenuose. ");
INSERT INTO lit_vpl VALUES ("JB42_17","019_42_17","JOB","42","17","17","Ir Jobas mirė senas ir pasisotinęs dienomis. ");
INSERT INTO lit_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","Koks didžiai palaimintas žmogus, kuris nevaikščioja pagal nedorėlių patarimą, nei stovi nusidėjėlių kelyje, nei sėdi šaipūnų būryje. ");
INSERT INTO lit_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","Priešingai – jis mėgsta VIEŠPATIES įstatymą ir apmąsto jo įstatymą dieną ir naktį. ");
INSERT INTO lit_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","Ir jis bus kaip medis, pasodintas prie vandens upelių, kuris duoda savo vaisių savo metu; ir jo lapai nenuvys, ir visa, ką jis bedaro, pasiseks. ");
INSERT INTO lit_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","Ne tokie yra nedorėliai, bet jie yra kaip pelai, kuriuos išsklaido vėjas. ");
INSERT INTO lit_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","Todėl nedorėliai neišsilaikys teisme, nei nusidėjėliai teisiųjų susirinkime, ");
INSERT INTO lit_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","nes VIEŠPATS pažįsta teisiųjų kelią, bet nedorėlių kelias pražus. ");
INSERT INTO lit_vpl VALUES ("PS2_1","020_2_1","PSA","2","1","1","Kodėl kitataučiai siaučia ir tautos apmąsto tuštybę? ");
INSERT INTO lit_vpl VALUES ("PS2_2","020_2_2","PSA","2","2","2","Žemės karaliai stoja į kovą, ir valdovai išvien tariasi prieš VIEŠPATĮ ir prieš jo pateptąjį, sakydami: ");
INSERT INTO lit_vpl VALUES ("PS2_3","020_2_3","PSA","2","3","3","„Sutraukykime jų pančius, numeskime nuo savęs jų virves!“ ");
INSERT INTO lit_vpl VALUES ("PS2_4","020_2_4","PSA","2","4","4","Tas, kuris sėdi danguose, juokiasi; Viešpats tyčiojasi iš jų. ");
INSERT INTO lit_vpl VALUES ("PS2_5","020_2_5","PSA","2","5","5","Tada jis kalbės jiems rūstaudamas ir įnirtęs juos išgąsdins: ");
INSERT INTO lit_vpl VALUES ("PS2_6","020_2_6","PSA","2","6","6","„O aš pats pastačiau savo karalių ant Siono, savo švento kalno!“ ");
INSERT INTO lit_vpl VALUES ("PS2_7","020_2_7","PSA","2","7","7","„Paskelbsiu įsaką; VIEŠPATS man tarė: „Tu esi mano Sūnus, šiandien aš tave pagimdžiau. ");
INSERT INTO lit_vpl VALUES ("PS2_8","020_2_8","PSA","2","8","8","Prašyk manęs, ir aš tau duosiu kitataučius, – tavo veldinį, ir tolimiausius žemės kraštus, – tavo nuosavybę. ");
INSERT INTO lit_vpl VALUES ("PS2_9","020_2_9","PSA","2","9","9","Tu daužysi juos geležine lazda, kaip puodžiaus indą juos daužysi į šukes!“ ");
INSERT INTO lit_vpl VALUES ("PS2_10","020_2_10","PSA","2","10","10","Taigi dabar, o karaliai, būkite išmintingi; duokitės įspėjami jūs, žemės teisėjai. ");
INSERT INTO lit_vpl VALUES ("PS2_11","020_2_11","PSA","2","11","11","Tarnaukite VIEŠPAČIUI su baime ir džiūgaukite drebėdami. ");
INSERT INTO lit_vpl VALUES ("PS2_12","020_2_12","PSA","2","12","12","Bučiuokite Sūnų, kad jis nerūstautų ir kelyje nežūtumėte, jo pykčiui truputį užsidegus. Kokie didžiai palaiminti visi, kurie bėga prieglaudon pas jį! ");
INSERT INTO lit_vpl VALUES ("PS3_1","020_3_1","PSA","3","1","1","Dovydo psalmė, jam bėgant nuo savo sūnaus Abšalomo veido. O VIEŠPATIE, kaip padaugėjo mano priešų! Daug tų, kurie sukyla prieš mane! ");
INSERT INTO lit_vpl VALUES ("PS3_2","020_3_2","PSA","3","2","2","Daug tų, kurie sako apie mano sielą: „Jam iš Dievo nėra išgelbėjimo!“ Sela. ");
INSERT INTO lit_vpl VALUES ("PS3_3","020_3_3","PSA","3","3","3","Bet Tu, VIEŠPATIE, esi skydas aplink mane, mano šlovė ir tas, kuris pakelia mano galvą. ");
INSERT INTO lit_vpl VALUES ("PS3_4","020_3_4","PSA","3","4","4","Savo balsu ne kartą šaukiausi VIEŠPATIES, ir jis nuo savo šventojo kalno išklausė mane. Sela. ");
INSERT INTO lit_vpl VALUES ("PS3_5","020_3_5","PSA","3","5","5","Aš – aš atsiguliau ir užmigau. Atsibudau, nes VIEŠPATS mane palaikė. ");
INSERT INTO lit_vpl VALUES ("PS3_6","020_3_6","PSA","3","6","6","Nebijau dešimt tūkstančių žmonių, kurie yra sustoję prieš mane iš visų pusių. ");
INSERT INTO lit_vpl VALUES ("PS3_7","020_3_7","PSA","3","7","7","Kelkis, o VIEŠPATIE! Išgelbėk mane, o mano Dieve! Juk tu visiems mano priešams smogei į žandą, nedorėlių dantis sutrupinai. ");
INSERT INTO lit_vpl VALUES ("PS3_8","020_3_8","PSA","3","8","8","VIEŠPAČIUI priklauso išgelbėjimas! Tavo tautai tebūna tavo palaiminimas! Sela. ");
INSERT INTO lit_vpl VALUES ("PS4_1","020_4_1","PSA","4","1","1","Vyriausiajam muzikui. Su styginiais instrumentais. Dovydo psalmė. Kai šaukiuosi, išklausyk mane, mano teisumo Dieve! Kai būdavau prispaustas, Tu suteikdavai man erdvės. Būk man maloningas ir išgirsk mano maldą! ");
INSERT INTO lit_vpl VALUES ("PS4_2","020_4_2","PSA","4","2","2","O žmonių sūnūs, kaip ilgai mano šlovę versite į gėdinimą? Kaip ilgai mylėsite tuštybę ir ieškosite to, kas melaginga? Sela. ");
INSERT INTO lit_vpl VALUES ("PS4_3","020_4_3","PSA","4","3","3","Bet žinokite, kad dievotąjį VIEŠPATS atskyrė sau; VIEŠPATS išgirsta, kai jo šaukiuosi. ");
INSERT INTO lit_vpl VALUES ("PS4_4","020_4_4","PSA","4","4","4","Bijokite ir nenusidėkite; apmąstykite savo širdyje būdami savo lovoje ir nusiraminkite. Sela. ");
INSERT INTO lit_vpl VALUES ("PS4_5","020_4_5","PSA","4","5","5","Aukokite teisingas aukas ir pasitikėkite VIEŠPAČIU! ");
INSERT INTO lit_vpl VALUES ("PS4_6","020_4_6","PSA","4","6","6","Daugelis sako: „Kas parodys mums gera? O VIEŠPATIE, pakelk virš mūsų savo veido šviesą! ");
INSERT INTO lit_vpl VALUES ("PS4_7","020_4_7","PSA","4","7","7","Tu į mano širdį įdėjai daugiau džiaugsmo negu tuo metu, kai padaugėjo anų javų ir anų šviežio vyno. ");
INSERT INTO lit_vpl VALUES ("PS4_8","020_4_8","PSA","4","8","8","Ramus aš atsigulsiu ir taip pat užmigsiu, nes tu vienas, o VIEŠPATIE, darai taip, kad saugiai gyvenu. ");
INSERT INTO lit_vpl VALUES ("PS5_1","020_5_1","PSA","5","1","1","Vyriausiajam muzikui. Nehilotu. Dovydo psalmė. Klausykis mano žodžių, o VIEŠPATIE, atkreipk dėmesį į mano apmąstymą! ");
INSERT INTO lit_vpl VALUES ("PS5_2","020_5_2","PSA","5","2","2","Išklausyk mano pagalbos šauksmo balsą, mano Karaliau ir mano Dieve, nes pastoviai melsiuosi tau! ");
INSERT INTO lit_vpl VALUES ("PS5_3","020_5_3","PSA","5","3","3","O VIEŠPATIE, ryte mano balsą išgirsi, ryte sudėliosiu prieš tave savo maldą ir atidžiai stebėsiu. ");
INSERT INTO lit_vpl VALUES ("PS5_4","020_5_4","PSA","5","4","4","Nes tu nesi toks dievas, kuriam patiktų nedorybė, neįmanoma blogajam apsistoti pas tave. ");
INSERT INTO lit_vpl VALUES ("PS5_5","020_5_5","PSA","5","5","5","Pagyrūnai neišstovės prieš tavo akis; tu neapkenti visų, darančių neteisybę. ");
INSERT INTO lit_vpl VALUES ("PS5_6","020_5_6","PSA","5","6","6","Tu pražudysi tuos, kurie kalba melą; VIEŠPATS bjaurisi kraugeriu ir apgaviku. ");
INSERT INTO lit_vpl VALUES ("PS5_7","020_5_7","PSA","5","7","7","Bet aš įeisiu į tavo namus per tavo apstų gailestingumą, bijodamasis tavęs nusilenksiu tavo šventos buveinės link. ");
INSERT INTO lit_vpl VALUES ("PS5_8","020_5_8","PSA","5","8","8","Vesk mane, o VIEŠPATIE, savo teisumo ribose dėl mano priešų! Nutiesk prieš mane tiesiai savo kelią. ");
INSERT INTO lit_vpl VALUES ("PS5_9","020_5_9","PSA","5","9","9","Nes jų burnoje nėra nieko patikimo; jų vidus – pati nedorybė, jų gerklė – atviras kapas, jie pataikauja savo liežuviu. ");
INSERT INTO lit_vpl VALUES ("PS5_10","020_5_10","PSA","5","10","10","Pražudyk juos, o Dieve! Tegul jų pačių kėslai parklupdo juos; nusviesk juos dėl jų maištavimų daugybės, nes jie sukilo prieš tave! ");
INSERT INTO lit_vpl VALUES ("PS5_11","020_5_11","PSA","5","11","11","Bet tegul džiaugiasi visi, kurie bėga prieglaudon pas tave! Tegul jie visada džiaugsmingai šūkauja, nes tu apsaugoji juos! Tegul džiūgauja tavimi tie, kurie myli tavo vardą! ");
INSERT INTO lit_vpl VALUES ("PS5_12","020_5_12","PSA","5","12","12","Nes tu, o VIEŠPATIE, laimini teisųjį, apgaubi jį palankumu lyg didžiuoju skydu. ");
INSERT INTO lit_vpl VALUES ("PS6_1","020_6_1","PSA","6","1","1","Vyriausiajam muzikui. Su styginiais instrumentais pagal šeminitą. Dovydo psalmė. O VIEŠPATIE, nebark manęs rūstaudamas, ir nedrausmink manęs įtūždamas! ");
INSERT INTO lit_vpl VALUES ("PS6_2","020_6_2","PSA","6","2","2","Pasigailėk manęs, o VIEŠPATIE, nes aš silpnas; pagydyk mane, o VIEŠPATIE, nes mano kaulai sukrėsti, ");
INSERT INTO lit_vpl VALUES ("PS6_3","020_6_3","PSA","6","3","3","ir mano siela labai sukrėsta! Bet tu, o VIEŠPATIE, – kiek ilgai? ");
INSERT INTO lit_vpl VALUES ("PS6_4","020_6_4","PSA","6","4","4","Atsigręžk, o VIEŠPATIE! Išvaduok mano sielą! Išgelbėk mane dėl savo gailestingumo! ");
INSERT INTO lit_vpl VALUES ("PS6_5","020_6_5","PSA","6","5","5","Nes mirtyje nėra tavo atminimo; kas kape tau dėkos? ");
INSERT INTO lit_vpl VALUES ("PS6_6","020_6_6","PSA","6","6","6","Nuvargau bedejuodamas, kasnakt aptvindau savo lovą, ašaromis aplieju savo patalą. ");
INSERT INTO lit_vpl VALUES ("PS6_7","020_6_7","PSA","6","7","7","Nuo sielvarto sunyko mano akys, paseno dėl visų mano priešų. ");
INSERT INTO lit_vpl VALUES ("PS6_8","020_6_8","PSA","6","8","8","Atsitraukite nuo manęs, visi blogadariai! Nes VIEŠPATS išgirdo mano verksmo balsą. ");
INSERT INTO lit_vpl VALUES ("PS6_9","020_6_9","PSA","6","9","9","VIEŠPATS išgirdo mano palankumo prašymą, VIEŠPATS priima mano maldą. ");
INSERT INTO lit_vpl VALUES ("PS6_10","020_6_10","PSA","6","10","10","Tegul visi mano priešai susigėsta ir tebūna labai sukrėsti; tegul jie atsigręžia ir susigėsta staiga! ");
INSERT INTO lit_vpl VALUES ("PS7_1","020_7_1","PSA","7","1","1","Dovydo šigajonas, kurį jis giedojo VIEŠPAČIUI dėl Benjamino palikuonio Kušo žodžių. VIEŠPATIE, mano Dieve, bėgu prieglaudon pas tave! Išgelbėk mane nuo visų mano persekiotojų ir išvaduok mane, ");
INSERT INTO lit_vpl VALUES ("PS7_2","020_7_2","PSA","7","2","2","kad toks nesuplėšytų mano sielos į gabalus kaip liūtas, kuris sudrasko, kai nėra kam išvaduoti. ");
INSERT INTO lit_vpl VALUES ("PS7_3","020_7_3","PSA","7","3","3","O VIEŠPATIE, mano Dieve, jei aš tai padariau, jei mano rankose yra neteisybė, ");
INSERT INTO lit_vpl VALUES ("PS7_4","020_7_4","PSA","7","4","4","jei atsilyginau blogu tam, kuris laikėsi taikos su manimi (juk išvadavau tą, kuris be priežasties yra mano priešas), ");
INSERT INTO lit_vpl VALUES ("PS7_5","020_7_5","PSA","7","5","5","tai priešas tepersekioja mano sielą ir ją tepagauna; taip, tesutrypia į žemę mano gyvybę ir tepaguldo mano garbę į dulkes! Sela. ");
INSERT INTO lit_vpl VALUES ("PS7_6","020_7_6","PSA","7","6","6","Kelkis, o VIEŠPATIE, rūstaudamas! Pakilk prieš mano priešų įtūžį ir mano labui pabusk teismui, kurį įsakei! ");
INSERT INTO lit_vpl VALUES ("PS7_7","020_7_7","PSA","7","7","7","Taip žmonių susirinkimas apsups tave; todėl dėl jų sugrįžk į aukštybes. ");
INSERT INTO lit_vpl VALUES ("PS7_8","020_7_8","PSA","7","8","8","VIEŠPATS teis tautas. Paskelbk kaltinimo nepagrįstumo nuosprendį apie mane, o VIEŠPATIE, pagal mano teisumą ir pagal mano vientisumo dorybę, esančią manyje. ");
INSERT INTO lit_vpl VALUES ("PS7_9","020_7_9","PSA","7","9","9","Prašau nedorėlių blogiui padaryti galą! Bet teisųjį sutvirtink! Nes ištiria širdis ir giliausias žmogaus dalis būtent teisusis Dievas. ");
INSERT INTO lit_vpl VALUES ("PS7_10","020_7_10","PSA","7","10","10","Mano skydas yra pas Dievą, kuris išgelbsti tiesiaširdžius. ");
INSERT INTO lit_vpl VALUES ("PS7_11","020_7_11","PSA","7","11","11","Dievas yra teisus teisėjas, ir toks Dievas, kuris kasdien pyksta ant nedorėlių. ");
INSERT INTO lit_vpl VALUES ("PS7_12","020_7_12","PSA","7","12","12","Jei žmogus neatsigręžia, VIEŠPATS galanda savo kalaviją, jis yra išlenkęs savo lanką ir jį paruošęs. ");
INSERT INTO lit_vpl VALUES ("PS7_13","020_7_13","PSA","7","13","13","Be to, jis tokiam yra paruošęs mirtinus ginklus, savo strėles yra padaręs degančias. ");
INSERT INTO lit_vpl VALUES ("PS7_14","020_7_14","PSA","7","14","14","Štai toks patiria gimdymo skausmus nedorybei įvykdyti; jis gi tapo nėščias žalingumu ir pagimdo melą. ");
INSERT INTO lit_vpl VALUES ("PS7_15","020_7_15","PSA","7","15","15","Jis padarė duobę ir ją iškasė ir pats įkrito į griovį, kurį padarė. ");
INSERT INTO lit_vpl VALUES ("PS7_16","020_7_16","PSA","7","16","16","Jo žalingumas sugrįš jam ant galvos, ir jo smurtas nusileis jam ant pakaušio. ");
INSERT INTO lit_vpl VALUES ("PS7_17","020_7_17","PSA","7","17","17","Aš girsiu VIEŠPATĮ deramai pagal Jo teisumą ir giedosiu gyrių VIEŠPATIES, Aukščiausiojo, vardui. ");
INSERT INTO lit_vpl VALUES ("PS8_1","020_8_1","PSA","8","1","1","Vyriausiajam muzikui. Pagal gititą. Dovydo psalmė. O VIEŠPATIE, mūsų Valdove, koks didingas tavo vardas visoje žemėje! Tu pastatei savo šlovę virš dangų. ");
INSERT INTO lit_vpl VALUES ("PS8_2","020_8_2","PSA","8","2","2","Iš kūdikių ir žindomųjų burnos tu priruošei stiprybę dėl savo priešų, kad nuramdytum priešą ir keršytoją. ");
INSERT INTO lit_vpl VALUES ("PS8_3","020_8_3","PSA","8","3","3","Kai žvelgiu į tavo dangus, tavo pirštų darbus, į mėnulį ir žvaigždes, kurias tu išdėstei, ");
INSERT INTO lit_vpl VALUES ("PS8_4","020_8_4","PSA","8","4","4","kas yra žmogus, kad jį atmeni, ir žmogaus sūnus, kad jį aplankai? ");
INSERT INTO lit_vpl VALUES ("PS8_5","020_8_5","PSA","8","5","5","Nes jį padarei truputį žemesnį už angelus, šlove ir garbe jį apvainikavai. ");
INSERT INTO lit_vpl VALUES ("PS8_6","020_8_6","PSA","8","6","6","Tu davei jam valdyti tavo rankų darbus, visa padėjai po jo kojomis: ");
INSERT INTO lit_vpl VALUES ("PS8_7","020_8_7","PSA","8","7","7","visas avis ir jaučius, ir netgi lauko žvėris, ");
INSERT INTO lit_vpl VALUES ("PS8_8","020_8_8","PSA","8","8","8","padangių paukščius, jūros žuvis ir visa, kas tik keliauja jūrų takais. ");
INSERT INTO lit_vpl VALUES ("PS8_9","020_8_9","PSA","8","9","9","O VIEŠPATIE, mūsų Valdove, koks didingas tavo vardas visoje žemėje! ");
INSERT INTO lit_vpl VALUES ("PS9_1","020_9_1","PSA","9","1","1","Vyriausiajam muzikui. Pagal mūt lebbėn. Dovydo psalmė. א Alef Girsiu tave, o VIEŠPATIE, visa savo širdimi, apskelbsiu visus tavo nuostabius darbus. ");
INSERT INTO lit_vpl VALUES ("PS9_2","020_9_2","PSA","9","2","2","Būsiu linksmas ir džiūgausiu tavimi, giedosiu gyrių tavo vardui, o Aukščiausiasis. ");
INSERT INTO lit_vpl VALUES ("PS9_3","020_9_3","PSA","9","3","3","Kai mano priešai bus atblokšti atgal, jie suklups ir pražus dėl tavo veido. ");
INSERT INTO lit_vpl VALUES ("PS9_4","020_9_4","PSA","9","4","4","Nes tu palaikei mano teisę ir mano bylą: sėdėjai soste, teisingai teisdamas. ");
INSERT INTO lit_vpl VALUES ("PS9_5","020_9_5","PSA","9","5","5","Tu subarei pagonis, pragaišinai bloguosius, ištrynei jų vardą amžių amžiams. ");
INSERT INTO lit_vpl VALUES ("PS9_6","020_9_6","PSA","9","6","6","O prieše, tavo pavertimai griuvėsiais baigėsi amžinai, nors išrovei miestus su šaknimis. Priešų atminimas pražuvo su jais! ");
INSERT INTO lit_vpl VALUES ("PS9_7","020_9_7","PSA","9","7","7","Bet VIEŠPATS pasiliks per amžius; savo sostą jis pastatė teismui. ");
INSERT INTO lit_vpl VALUES ("PS9_8","020_9_8","PSA","9","8","8","Ir jis teis pasaulį vadovaudamasis teisumu, teisingumą įvykdys tautoms vadovaudamasis lygiateisiškumu. ");
INSERT INTO lit_vpl VALUES ("PS9_9","020_9_9","PSA","9","9","9","Taigi VIEŠPATS bus aukšta prieglauda prislėgtajam, aukšta prieglauda sielvarto laikais. ");
INSERT INTO lit_vpl VALUES ("PS9_10","020_9_10","PSA","9","10","10","Kurie pažįsta tavo vardą, bėga prieglaudon pas tave, nes tu, VIEŠPATIE, nesi palikęs tų, kurie rūpestingai ieško tavęs. ");
INSERT INTO lit_vpl VALUES ("PS9_11","020_9_11","PSA","9","11","11","Giedokite gyrių VIEŠPAČIUI, kuris gyvena Sione! Skelbkite tautose jo darbus! ");
INSERT INTO lit_vpl VALUES ("PS9_12","020_9_12","PSA","9","12","12","Atkeršydamas už kraują, jis atsimena juos, jis neužmiršta prispaustųjų šauksmo. ");
INSERT INTO lit_vpl VALUES ("PS9_13","020_9_13","PSA","9","13","13","Pasigailėk manęs, o VIEŠPATIE! Tu, kuris mane pakeli iš mirties vartų, atsižvelk į vargą man nuo tų, kurie manęs neapkenčia, ");
INSERT INTO lit_vpl VALUES ("PS9_14","020_9_14","PSA","9","14","14","kad garsinčiau visą tavo gyrių Siono dukters vartuose; džiūgausiu dėl tavo išgelbėjimo! ");
INSERT INTO lit_vpl VALUES ("PS9_15","020_9_15","PSA","9","15","15","Pagonys nugrimzdo į duobę, kurią patys iškasė; jų koja įkliuvo į pinkles, kurias patys paspendė. ");
INSERT INTO lit_vpl VALUES ("PS9_16","020_9_16","PSA","9","16","16","VIEŠPATS duoda save pažinti: jis vykdė teisingumą, nedorėlis įsipainiojamas į savo paties rankų darbą. Higaionas. Sela. ");
INSERT INTO lit_vpl VALUES ("PS9_17","020_9_17","PSA","9","17","17","Nedorėliai suks į pragarą, visos tautos, kurios pamiršta Dievą. ");
INSERT INTO lit_vpl VALUES ("PS9_18","020_9_18","PSA","9","18","18","Nes vargšas nebus pamirštas visam laikui; prispaustųjų lūkestis nebus pražuvęs amžinai. ");
INSERT INTO lit_vpl VALUES ("PS9_19","020_9_19","PSA","9","19","19","Pakilk, VIEŠPATIE! Teneįsigali mirtingieji! Tebūna tautos teisiamos tavo akyse. ");
INSERT INTO lit_vpl VALUES ("PS9_20","020_9_20","PSA","9","20","20","Įvaryk jiems baimės, o VIEŠPATIE! Težino tautos, kad jos – tik žmonės! Sela. ");
INSERT INTO lit_vpl VALUES ("PS10_1","020_10_1","PSA","10","1","1","Kodėl tu, o VIEŠPATIE, stovi toli, kodėl slepiesi sielvarto laikais? ");
INSERT INTO lit_vpl VALUES ("PS10_2","020_10_2","PSA","10","2","2","Puikuodamiesi nedorėliai persekioja prispaustuosius; teįkliūva jie patys į savo sumanytas pinkles! ");
INSERT INTO lit_vpl VALUES ("PS10_3","020_10_3","PSA","10","3","3","Nedorėlis gi giriasi savo širdies troškimu bei laimina gobšuolį ir niekina VIEŠPATĮ. ");
INSERT INTO lit_vpl VALUES ("PS10_4","020_10_4","PSA","10","4","4","Nedorėlis savo išdidžiu veidu atsisako ieškoti Dievo; nėra Dievo visose jo mintyse. ");
INSERT INTO lit_vpl VALUES ("PS10_5","020_10_5","PSA","10","5","5","Jo keliai visuomet sukelia sielvartą; tavo teismai yra aukšti, toli nuo jo akių; o visi jo priešai – jis prunkščia į juos. ");
INSERT INTO lit_vpl VALUES ("PS10_6","020_10_6","PSA","10","6","6","Jis taria savo širdyje: „Aš nesvyruosiu, nes aš nepatirsiu nelaimės niekada“. ");
INSERT INTO lit_vpl VALUES ("PS10_7","020_10_7","PSA","10","7","7","Jo burna pilna keiksmo, melo ir sukčiavimo, po jo liežuviu – nedorybė ir neteisybė. ");
INSERT INTO lit_vpl VALUES ("PS10_8","020_10_8","PSA","10","8","8","Jis sėdi tykodamas kaimuose; slaptavietėse jis nužudo nekaltąjį. ע Ajin Jo akys stebi iš pasalų nelaimėlį. ");
INSERT INTO lit_vpl VALUES ("PS10_9","020_10_9","PSA","10","9","9","Jis tyko slaptavietėse kaip liūtas savo tankmėje. Jis tyko pagrobti prispaustąjį, čiumpa prispaustąjį, įtraukdamas jį į savo tinklą. ");
INSERT INTO lit_vpl VALUES ("PS10_10","020_10_10","PSA","10","10","10","Ir jis pritūpia, puola pagūžom, kad nelaimėliai nukristų jo stipriomis priemonėmis. ");
INSERT INTO lit_vpl VALUES ("PS10_11","020_10_11","PSA","10","11","11","Jis taria savo širdyje: „Dievas pamiršo, jis paslepia savo veidą, jis niekada nepamatys.“ ");
INSERT INTO lit_vpl VALUES ("PS10_12","020_10_12","PSA","10","12","12","Kelkis, o VIEŠPATIE! O Dieve, pakelk savo ranką, nepamiršk prispaustojo! ");
INSERT INTO lit_vpl VALUES ("PS10_13","020_10_13","PSA","10","13","13","Kodėl nedorėlis niekina Dievą? Jis taria savo širdyje: „Tu nepareikalausi atsiskaityti.“ ");
INSERT INTO lit_vpl VALUES ("PS10_14","020_10_14","PSA","10","14","14","Tu pamatei! Nes tu pastebi nedorybę ir skaudinimą, kad atlygintum savo ranka. Nelaimėlis save patiki tau; našlaičio padėjėjas esi tu. ");
INSERT INTO lit_vpl VALUES ("PS10_15","020_10_15","PSA","10","15","15","Sulaužyk nedoro ir blogo žmogaus ranką, pareikalauk atsiskaityti už jo nedorybę, kol nieko neberasi. ");
INSERT INTO lit_vpl VALUES ("PS10_16","020_10_16","PSA","10","16","16","VIEŠPATS yra Karalius per amžių amžius. Pagonys yra pražuvę iš jo žemės. ");
INSERT INTO lit_vpl VALUES ("PS10_17","020_10_17","PSA","10","17","17","Prispaustųjų troškimą tu, VIEŠPATIE, esi išklausęs; jų širdį paruoši tu, atkreipsi savo ausį ");
INSERT INTO lit_vpl VALUES ("PS10_18","020_10_18","PSA","10","18","18","našlaičio ir prislėgtojo bylą apginti, kad joks žemės mirtingasis daugiau nebegąsdintų. ");
INSERT INTO lit_vpl VALUES ("PS11_1","020_11_1","PSA","11","1","1","Vyriausiajam muzikui. Dovydo. Esu pasitikėjęs VIEŠPAČIU! Kaip galite tarti mano sielai: „Pabėk į jūsų kalnus kaip paukštis!? ");
INSERT INTO lit_vpl VALUES ("PS11_2","020_11_2","PSA","11","2","2","Nes štai nedorėliai įtempia lanką, ant templės savo strėlę deda, kad tamsoje šaudytų į tiesiaširdžius. ");
INSERT INTO lit_vpl VALUES ("PS11_3","020_11_3","PSA","11","3","3","Jeigu pamatai nugriaunami, ką begalės daryti teisusis?“ ");
INSERT INTO lit_vpl VALUES ("PS11_4","020_11_4","PSA","11","4","4","VIEŠPATS yra savo ypatingai šventoje šventykloje – VIEŠPATIES sostas yra danguje. Jo akys stebi, jo akių vokai tiria žmonių palikuonis. ");
INSERT INTO lit_vpl VALUES ("PS11_5","020_11_5","PSA","11","5","5","VIEŠPATS teisųjį tiria, bet jo siela nekenčia nedorėlio ir smurtą mylinčio. ");
INSERT INTO lit_vpl VALUES ("PS11_6","020_11_6","PSA","11","6","6","Jis lies ant nedorėlių žabangus, ugnį ir sierą, ir svilinančią audrą; tai bus jiems skirtoji taurė. ");
INSERT INTO lit_vpl VALUES ("PS11_7","020_11_7","PSA","11","7","7","Nes VIEŠPATS yra teisus, jis myli teisybę. Dorieji matys jo veidą. ");
INSERT INTO lit_vpl VALUES ("PS12_1","020_12_1","PSA","12","1","1","Vyriausiajam muzikui. Pagal šeminitą. Dovydo psalmė. Išgelbėk, o VIEŠPATIE, nes nebėra dievotojo, nes ištikimieji pradingsta tarp žmonių palikuonių. ");
INSERT INTO lit_vpl VALUES ("PS12_2","020_12_2","PSA","12","2","2","Jie kiekvienas su savo kaimynu kalba netiesą, jie kalba pataikaujančiomis lūpomis ir dvilype širdimi. ");
INSERT INTO lit_vpl VALUES ("PS12_3","020_12_3","PSA","12","3","3","VIEŠPATS pribaigs pataikaujančias lūpas, didžiakalbį liežuvį – ");
INSERT INTO lit_vpl VALUES ("PS12_4","020_12_4","PSA","12","4","4","tuos, kurie yra pasakę: „Mes turime stiprų liežuvį; mūsų lūpos yra mūsų pačių. Kas gali mums viešpatauti?“ ");
INSERT INTO lit_vpl VALUES ("PS12_5","020_12_5","PSA","12","5","5","„Dėl smurto prieš prispaustuosius, dėl vargšų dejavimo aš pakilsiu dabar, – sako VIEŠPATS. – Aš suteiksiu saugumą nuo to, kuris į jį prunkščia“. ");
INSERT INTO lit_vpl VALUES ("PS12_6","020_12_6","PSA","12","6","6","VIEŠPATIES žodžiai yra tyri žodžiai, kaip molio lydykloje grynintas sidabras, septynis kartus nuskaistintas. ");
INSERT INTO lit_vpl VALUES ("PS12_7","020_12_7","PSA","12","7","7","Tu juos saugosi, o VIEŠPATIE, tu kiekvieną iš jų išlaikysi nuo šitos kartos per amžius. ");
INSERT INTO lit_vpl VALUES ("PS12_8","020_12_8","PSA","12","8","8","Nedorėliai vaikščioja visur aplinkui, kai niekšiški žmonės yra išaukštinti. ");
INSERT INTO lit_vpl VALUES ("PS13_1","020_13_1","PSA","13","1","1","Vyriausiajam muzikui. Dovydo psalmė. Kiek ilgai, VIEŠPATIE? Ar pamirši mane amžinai? Kiek ilgai slėpsi savo veidą nuo manęs? ");
INSERT INTO lit_vpl VALUES ("PS13_2","020_13_2","PSA","13","2","2","Kiek ilgai teks man patarimų dėti sau į sielą, liūdesiui užėmus mano širdį dienos metu? Kiek ilgai mano priešas bus išaukštintas virš manęs? ");
INSERT INTO lit_vpl VALUES ("PS13_3","020_13_3","PSA","13","3","3","Pažvelk, išklausyk mane, VIEŠPATIE, mano Dieve! Padaryk šviesias man akis, kad mirties miegu neužmigčiau! ");
INSERT INTO lit_vpl VALUES ("PS13_4","020_13_4","PSA","13","4","4","Kad mano priešas nesakytų: „Aš jį nugalėjau“ ir mano prispaudėjai nedžiūgautų dėl to, kad svyruoju. ");
INSERT INTO lit_vpl VALUES ("PS13_5","020_13_5","PSA","13","5","5","Bet aš pasitikėjau tavo gailestingumu. Mano širdis džiūgaus dėl tavo išgelbėjimo. ");
INSERT INTO lit_vpl VALUES ("PS13_6","020_13_6","PSA","13","6","6","Aš giedosiu VIEŠPAČIUI, nes jis dosniai padarė man gera. ");
INSERT INTO lit_vpl VALUES ("PS14_1","020_14_1","PSA","14","1","1","Vyriausiajam muzikui. Dovydo. Kvailys pasakė savo širdyje: „Nėra Dievo.“ Tokie sugedę, jie daro šlykščius darbus; nėra gera darančio. ");
INSERT INTO lit_vpl VALUES ("PS14_2","020_14_2","PSA","14","2","2","VIEŠPATS žvelgė žemyn iš dangaus į žmonių palikuonis, kad pamatytų, ar yra kas išmano, kas ieško Dievo. ");
INSERT INTO lit_vpl VALUES ("PS14_3","020_14_3","PSA","14","3","3","Visi nukrypo į šoną, jie kartu pasidarė suteršti; nėra gera darančio, nėra nė vieno. ");
INSERT INTO lit_vpl VALUES ("PS14_4","020_14_4","PSA","14","4","4","Argi visi tie, kurie daro neteisybę, yra tokie nežinantys?! Jie ryja mano tautą, kaip jie valgo duoną, ir nėra pasišaukę VIEŠPATIES! ");
INSERT INTO lit_vpl VALUES ("PS14_5","020_14_5","PSA","14","5","5","Jie tenai drebete drebėjo iš baimės, nes Dievas yra su teisiųjų karta. ");
INSERT INTO lit_vpl VALUES ("PS14_6","020_14_6","PSA","14","6","6","Jūs sugėdintumėte vargšo priimtą patarimą, bet VIEŠPATS yra jo prieglauda. ");
INSERT INTO lit_vpl VALUES ("PS14_7","020_14_7","PSA","14","7","7","O, kad iš Siono ateitų išgelbėjimas Izraeliui! Kai VIEŠPATS sugrąžins namo savo nelaisvėn paimtą tautą, džiūgaus Jokūbas, apsidžiaugs Izraelis! ");
INSERT INTO lit_vpl VALUES ("PS15_1","020_15_1","PSA","15","1","1","Dovydo psalmė. Viešpatie, kas gali pabūti tavo padangtėje? Kas gali gyventi tavo šventajame kalne? ");
INSERT INTO lit_vpl VALUES ("PS15_2","020_15_2","PSA","15","2","2","Tas, kuris vaikščioja vientisumo dorybėje, daro, kas teisu, ir kalba tiesą savo širdyje. ");
INSERT INTO lit_vpl VALUES ("PS15_3","020_15_3","PSA","15","3","3","Toks nešmeižia savo liežuviu, nedaro savo artimui blogo, ir nesityčioja iš savo kaimyno. ");
INSERT INTO lit_vpl VALUES ("PS15_4","020_15_4","PSA","15","4","4","Jo akyse tas, kurį reikia atmesti, yra laikomas niekam tikusiu, bet toksai gerbia tuos, kurie bijo VIEŠPATIES; jis, prisiekęs savo paties žalai, net nedaro pakeitimų. ");
INSERT INTO lit_vpl VALUES ("PS15_5","020_15_5","PSA","15","5","5","Jis savo pinigų neskolina su palūkanomis ir kyšių prieš nekaltąjį neima. Kas šiuos dalykus daro niekada nebus parblokštas. ");
INSERT INTO lit_vpl VALUES ("PS16_1","020_16_1","PSA","16","1","1","Dovydo miktamas. Saugok mane, o Dieve, nes pasitikiu tavimi. ");
INSERT INTO lit_vpl VALUES ("PS16_2","020_16_2","PSA","16","2","2","O mano siela, tu tarei VIEŠPAČIUI: „Tu esi mano Viešpats, mano gerovė nėra kitur, tik tavyje.“ ");
INSERT INTO lit_vpl VALUES ("PS16_3","020_16_3","PSA","16","3","3","Visiškai gėriuosi šventaisiais, kurie yra žemėje, tai yra šauniaisiais. ");
INSERT INTO lit_vpl VALUES ("PS16_4","020_16_4","PSA","16","4","4","Padaugės sielvartų tiems, kurie nuskuba paskui kitą! Jų liejamųjų kraujo aukų neaukosiu, nei neimsiu jų vardų į savo lūpas. ");
INSERT INTO lit_vpl VALUES ("PS16_5","020_16_5","PSA","16","5","5","VIEŠPATS yra mano paveldo dalis ir mano taurė; tu išlaikai mano paveldo dalią. ");
INSERT INTO lit_vpl VALUES ("PS16_6","020_16_6","PSA","16","6","6","Man matavimo virvės krito maloniose vietose, iš tikrųjų mano paveldas yra puikus. ");
INSERT INTO lit_vpl VALUES ("PS16_7","020_16_7","PSA","16","7","7","Laiminsiu VIEŠPATĮ, kuris man yra pataręs; iš tikrųjų naktimis mane pamoko mano giliausia dalis. ");
INSERT INTO lit_vpl VALUES ("PS16_8","020_16_8","PSA","16","8","8","Nuolatos statau VIEŠPATĮ priešais save; kadangi jis mano dešinėje, aš nesusvyruosiu. ");
INSERT INTO lit_vpl VALUES ("PS16_9","020_16_9","PSA","16","9","9","Todėl linksma mano širdis ir džiūgauja mano šlovė, ir mano kūnas ilsėsis su viltimi, ");
INSERT INTO lit_vpl VALUES ("PS16_10","020_16_10","PSA","16","10","10","nes tu nepaliksi manęs kape, ir neleisi savo Šventajam patirti supuvimo. ");
INSERT INTO lit_vpl VALUES ("PS16_11","020_16_11","PSA","16","11","11","Tu parodysi man apstaus gyvenimo taką; tavo akivaizdoje – džiaugsmo pilnatvė, tavo dešinėje – malonumai per amžius. ");
INSERT INTO lit_vpl VALUES ("PS17_1","020_17_1","PSA","17","1","1","Dovydo malda. Išgirsk, o VIEŠPATIE, tai, kas teisinga, atkreipk dėmesį į mano šauksmą, klausykis mano maldos iš lūpų be vyliaus! ");
INSERT INTO lit_vpl VALUES ("PS17_2","020_17_2","PSA","17","2","2","Iš tavęs teateina man nuosprendis, tavo akys temato, kas tiesu. ");
INSERT INTO lit_vpl VALUES ("PS17_3","020_17_3","PSA","17","3","3","Tu ištyrei mano širdį, aplankei mane naktį, mane išmėginai ir nieko neradai. Esu pasiryžęs, kad mano burna nenusižengs. ");
INSERT INTO lit_vpl VALUES ("PS17_4","020_17_4","PSA","17","4","4","O dėl žmonių darbų, – tavo lūpų žodžiu aš susilaikiau nuo smurtininko takų. ");
INSERT INTO lit_vpl VALUES ("PS17_5","020_17_5","PSA","17","5","5","Mano žingsniai tvirtai laikėsi tavo takų, mano kojos nesvyravo. ");
INSERT INTO lit_vpl VALUES ("PS17_6","020_17_6","PSA","17","6","6","Aš šaukiausi tavęs, nes tu išklausysi mane, Dieve. Palenk prie manęs savo ausį, išgirsk mano kalbą. ");
INSERT INTO lit_vpl VALUES ("PS17_7","020_17_7","PSA","17","7","7","Parodyk savo nuostabią mielaširdystę tu, kuris savo dešine ranka išgelbėji tavimi pasitikinčius nuo tų, kurie sukyla prieš juos. ");
INSERT INTO lit_vpl VALUES ("PS17_8","020_17_8","PSA","17","8","8","Saugok mane kaip akies vyzdį, savo sparnų paūksmėje slėpk mane ");
INSERT INTO lit_vpl VALUES ("PS17_9","020_17_9","PSA","17","9","9","nuo nedorėlių, kurie smurtauja prieš mane, mano mirtinųjų priešų, kurie mane apsupa! ");
INSERT INTO lit_vpl VALUES ("PS17_10","020_17_10","PSA","17","10","10","Jie yra užsidarę savo taukuose, savo burna išdidžiai kalba. ");
INSERT INTO lit_vpl VALUES ("PS17_11","020_17_11","PSA","17","11","11","Mūsų žingsnius! Jie apsupo mus! Jie yra nustatę savo akis, kad parklupdytų. ");
INSERT INTO lit_vpl VALUES ("PS17_12","020_17_12","PSA","17","12","12","Kiekvienas iš jų yra panašus į liūtą, geidžiantį draskyti, į liūtuką, sėlinantį iš pasalų. ");
INSERT INTO lit_vpl VALUES ("PS17_13","020_17_13","PSA","17","13","13","Kelkis, o VIEŠPATIE, užbėk jam už akių, parklupdyk jį! Savo kalaviju išvaduok mano sielą nuo nedorėlio! ");
INSERT INTO lit_vpl VALUES ("PS17_14","020_17_14","PSA","17","14","14","Savo ranka išvaduok iš žmonių, o VIEŠPATIE, iš žmonių iš pasaulio, kurių dalia yra šiame gyvenime, kurių pilvą tu pripildai savo lobio. Jiems vaikų netrūksta, ir perteklių jie palieka savo mažyliams. ");
INSERT INTO lit_vpl VALUES ("PS17_15","020_17_15","PSA","17","15","15","Aš pats teisume žvelgsiu į tavo veidą ir pabudęs pasisotinsiu tavo atspindžiu. ");
INSERT INTO lit_vpl VALUES ("PS18_1","020_18_1","PSA","18","1","1","Vyriausiajam muzikantui. Psalmė VIEŠPATIES tarno Dovydo, kuris kalbėjo VIEŠPAČIUI šitos giesmės žodžius tą dieną, kai VIEŠPATS jį išvadavo iš visų jo priešų rankų ir iš Sauliaus rankų. Jis kalbėjo: Tave myliu, o VIEŠPATIE, mano stiprybe. ");
INSERT INTO lit_vpl VALUES ("PS18_2","020_18_2","PSA","18","2","2","VIEŠPATS yra mano aukšta apsaugos uola bei mano tvirtovė bei mano vaduotojas; mano Dievas, mano uola – juo pasitikiu; mano skydas bei mano išgelbėjimo ragas, mano aukšta prieglauda. ");
INSERT INTO lit_vpl VALUES ("PS18_30","020_18_30","PSA","18","30","30","Tikras Dievas – jo kelias yra tobulas, VIEŠPATIES žodis yra patikimas; jis yra skydas visiems, kurie pasitiki juo. ");
INSERT INTO lit_vpl VALUES ("PS18_31","020_18_31","PSA","18","31","31","Nes kas yra Dievas, jei ne VIEŠPATS? Ir kas yra uola, jei ne mūsų Dievas? ");
INSERT INTO lit_vpl VALUES ("PS18_32","020_18_32","PSA","18","32","32","Tai Dievas, kuris apjuosia mane jėga ir padaro mano kelią nepriekaištingą, ");
INSERT INTO lit_vpl VALUES ("PS18_35","020_18_35","PSA","18","35","35","Tu man davei savo išgelbėjimo skydą, ir tavo dešinė mane parėmė, ir tavo švelnumas padarė mane didį. ");
INSERT INTO lit_vpl VALUES ("PS18_49","020_18_49","PSA","18","49","49","Todėl dėkosiu tau, o VIEŠPATIE, tarp tautų ir giedosiu gyrių tavo vardui. ");
INSERT INTO lit_vpl VALUES ("PS19_1","020_19_1","PSA","19","1","1","Vyriausiajam muzikui. Dovydo psalmė. Dangūs skelbia Dievo šlovę ir skliautinė platybė skelbia jo rankų darbą. ");
INSERT INTO lit_vpl VALUES ("PS19_2","020_19_2","PSA","19","2","2","Diena dienai išlieja „kalbą“ ir naktis nakčiai praneša pažinimą ");
INSERT INTO lit_vpl VALUES ("PS19_3","020_19_3","PSA","19","3","3","(nors nėra kalbos, nėra posakių – jų balsas girdimas be kalbos ir posakių). ");
INSERT INTO lit_vpl VALUES ("PS19_4","020_19_4","PSA","19","4","4","Jų matavimo virvė išsitiesė po visą žemę, jų žodžiai iki pasaulio ribos. Juose jis įtaisė padangtę saulei, ");
INSERT INTO lit_vpl VALUES ("PS19_5","020_19_5","PSA","19","5","5","kuri lyg jaunikis kaskart išeina iš savo kambario, lyg sportininkas džiaugiasi kaskart bėgdamas taku. ");
INSERT INTO lit_vpl VALUES ("PS19_7","020_19_7","PSA","19","7","7","VIEŠPATIES įstatymas yra tobulas, atgręžiantis sielą; VIEŠPATIES liudijimas yra patikimas, doroviškai naivius žmones padarantis išmintingus. ");
INSERT INTO lit_vpl VALUES ("PS19_8","020_19_8","PSA","19","8","8","VIEŠPATIES nurodymai teisingi, džiuginantys širdį; VIEŠPATIES įsakymas tyras, apšviečiantis akis. ");
INSERT INTO lit_vpl VALUES ("PS19_9","020_19_9","PSA","19","9","9","VIEŠPATIES baimė yra skaisti, pasiliekanti per amžius; VIEŠPATIES sprendimai yra tiesa, visiškai teisingi. ");
INSERT INTO lit_vpl VALUES ("PS19_10","020_19_10","PSA","19","10","10","Jie geistini labiau už auksą, net už daug gryno aukso; taip pat saldesni už medų ir varvantį korių medų. ");
INSERT INTO lit_vpl VALUES ("PS19_11","020_19_11","PSA","19","11","11","Be to, tavo tarnas jais įspėjamas; kas jų laikosi, gauna didelį atlygį. ");
INSERT INTO lit_vpl VALUES ("PS19_12","020_19_12","PSA","19","12","12","Kas gali suvokti savo klaidas? Apvalyk mane nuo slaptų kalčių. ");
INSERT INTO lit_vpl VALUES ("PS20_5","020_20_5","PSA","20","5","5","Mes krykštausime dėl tavo išgelbėjimo, vėliavas kelsime savo Dievo vardu. Visus tavo prašymus teįvykdo VIEŠPATS! ");
INSERT INTO lit_vpl VALUES ("PS20_7","020_20_7","PSA","20","7","7","Vieni pasitiki karo vežimais, kiti žirgais, bet mes prisiminsime VIEŠPATIES, savo Dievo, vardą. ");
INSERT INTO lit_vpl VALUES ("PS21_6","020_21_6","PSA","21","6","6","Nes jį pastatai apstu palaiminimu amžinai, tu savo veidu didžiai pradžiugini jį. ");
INSERT INTO lit_vpl VALUES ("PS21_13","020_21_13","PSA","21","13","13","Būk išaukštintas, VIEŠPATIE, savo galia! Apgiedosime ir muzikuodami girsime tavo galybę. ");
INSERT INTO lit_vpl VALUES ("PS22_1","020_22_1","PSA","22","1","1","Vyriausiajam muzikui. Atliekama pagal melodiją „Aušros elnė“. Dovydo psalmė. Mano Dieve, mano Dieve, kodėl mane apleidai, būdamas toli nuo mano išvadavimo, nuo mano dejonės žodžių? ");
INSERT INTO lit_vpl VALUES ("PS22_4","020_22_4","PSA","22","4","4","Tavimi pasitikėjo mūsų tėvai; jie pasitikėjo, ir tu juos išvadavai. ");
INSERT INTO lit_vpl VALUES ("PS22_6","020_22_6","PSA","22","6","6","Bet aš esu kirminas, o ne žmogus; žmonių patyčių objektas ir tautos niekinamas. ");
INSERT INTO lit_vpl VALUES ("PS22_16","020_22_16","PSA","22","16","16","Nes mane apsupo šunys, blogadarių gauja mane apspito; jie perdūrė mano rankas ir mano kojas. ");
INSERT INTO lit_vpl VALUES ("PS22_17","020_22_17","PSA","22","17","17","Galiu suskaičiuoti visus savo kaulus. Tie spokso, žiūri į mane, ");
INSERT INTO lit_vpl VALUES ("PS22_18","020_22_18","PSA","22","18","18","dalijasi tarpusavyje mano drabužius ir dėl mano apdaro meta burtą. ");
INSERT INTO lit_vpl VALUES ("PS22_19","020_22_19","PSA","22","19","19","Bet tu, VIEŠPATIE, nebūk toli! Mano stiprybe, skubėk man padėti! ");
INSERT INTO lit_vpl VALUES ("PS22_22","020_22_22","PSA","22","22","22","Aš paskelbsiu tavo vardą savo broliams, susirinkimo viduryje tave girsiu. ");
INSERT INTO lit_vpl VALUES ("PS22_23","020_22_23","PSA","22","23","23","Jūs, kurie bijote VIEŠPATIES, girkite jį! Visi, kurie Jokūbo sėkla, šlovinkite jį! Ir visi, kurie Izraelio sėkla, bijokitės jo! ");
INSERT INTO lit_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","Dovydo psalmė. VIEŠPATS yra mano ganytojas, aš nestokosiu. ");
INSERT INTO lit_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","Jis guldo mane žaliuojančiose pievose, švelniai vedžioja mane prie atilsio vietovių vandenų. ");
INSERT INTO lit_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","Jis atgaivina mano sielą, jis veda mane teisumo takais dėl savo vardo. ");
INSERT INTO lit_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","Be to, nors eičiau per mirties šešėlio slėnį, blogo nebijosiu, nes tu pats esi su manimi; tavo vėzdas ir tavo lazda patys paguodžia mane. ");
INSERT INTO lit_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","Tu paruoši ties manimi stalą mano priešų akivaizdoje, tu aliejumi man patepi galvą; mano taurė sklidina. ");
INSERT INTO lit_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","Tikrai gerumas ir gailestingumas lydės mane per visas mano gyvenimo dienas, ir aš pasiliksiu VIEŠPATIES namuose amžinai. ");
INSERT INTO lit_vpl VALUES ("PS24_1","020_24_1","PSA","24","1","1","Dovydo psalmė. VIEŠPAČIUI priklauso žemė ir visa, kas joje, pasaulis ir kas jame gyvena, ");
INSERT INTO lit_vpl VALUES ("PS24_2","020_24_2","PSA","24","2","2","nes jis ant jūrų ją pastatė, ant srovių ją įtvirtino. ");
INSERT INTO lit_vpl VALUES ("PS24_10","020_24_10","PSA","24","10","10","Kas yra tas šlovės Karalius? Kareivijų VIEŠPATS – jis yra šlovės Karalius! Sela. ");
INSERT INTO lit_vpl VALUES ("PS24_3","020_24_3","PSA","24","3","3","Kas gali kopti į VIEŠPATIES kalną? Arba, kas gali atsistoti jo šventoje vietoje? ");
INSERT INTO lit_vpl VALUES ("PS24_4","020_24_4","PSA","24","4","4","Tas, kurio rankos nekaltos ir širdis tyra, kuris nekėlė savo sielos į tuštybę ir neprisiekė apgaulingai. ");
INSERT INTO lit_vpl VALUES ("PS24_5","020_24_5","PSA","24","5","5","Tas gaus palaiminimą iš VIEŠPATIES ir teisumą iš savo išgelbėjimo Dievo. ");
INSERT INTO lit_vpl VALUES ("PS25_1","020_25_1","PSA","25","1","1","Dovydo. א Alef Į tave, VIEŠPATIE, keliu savo sielą. ");
INSERT INTO lit_vpl VALUES ("PS25_2","020_25_2","PSA","25","2","2","O mano Dieve, tavimi pasitikiu: neleisk man būti sugėdintam, neleisk mano priešams džiūgauti turėdami viršenybę prieš mane. ");
INSERT INTO lit_vpl VALUES ("PS25_3","020_25_3","PSA","25","3","3","Taip pat, visi laukiantieji tavęs tenebūna sugėdinti; tebūna sugėdinti tie, kurie be pagrindo laužo ištikimybę. ");
INSERT INTO lit_vpl VALUES ("PS25_4","020_25_4","PSA","25","4","4","O VIEŠPATIE, parodyk man savo kelius, pamokyk mane savo takų. ");
INSERT INTO lit_vpl VALUES ("PS25_5","020_25_5","PSA","25","5","5","Vesk mane savo tiesos ribose ir mokyk mane, nes tu esi mano išgelbėjimo Dievas; ו Vav laukiau tavęs visą dieną. ");
INSERT INTO lit_vpl VALUES ("PS25_6","020_25_6","PSA","25","6","6","Atsimink, o VIEŠPATIE, savo apstų meilingumą ir savo didį gailestingumą, nes jie yra nuo amžių. ");
INSERT INTO lit_vpl VALUES ("PS25_7","020_25_7","PSA","25","7","7","Neatsimink mano jaunystės nuodėmių nei mano nusižengimų; atsimink mane pagal savo gailestingumą dėl savo gerumo, o VIEŠPATIE! ");
INSERT INTO lit_vpl VALUES ("PS25_8","020_25_8","PSA","25","8","8","Geras ir tiesus yra VIEŠPATS, todėl jis nusidėjėlius moko kelio. ");
INSERT INTO lit_vpl VALUES ("PS25_9","020_25_9","PSA","25","9","9","Romiuosius jis ves teisingu taku ir romiuosius jis mokys savo kelio. ");
INSERT INTO lit_vpl VALUES ("PS25_10","020_25_10","PSA","25","10","10","Visi VIEŠPATIES takai yra gailestingumas ir ištikimybė tiems, kurie laikosi jo sandoros ir jo liudijimų. ");
INSERT INTO lit_vpl VALUES ("PS25_12","020_25_12","PSA","25","12","12","Kas yra tas žmogus, kuris bijo VIEŠPATIES? Tą jis pamokys kelyje, kurį šis turi pasirinkti. ");
INSERT INTO lit_vpl VALUES ("PS25_15","020_25_15","PSA","25","15","15","Mano akys nuolat nukreiptos į VIEŠPATĮ, nes jis ištrauks mano kojas iš pinklių. ");
INSERT INTO lit_vpl VALUES ("PS26_1","020_26_1","PSA","26","1","1","Dovydo. Paskelbk kaltinimo nepagrįstumo nuosprendį apie mane, VIEŠPATIE, nes vaikščiojau savo vientisumo dorybėje ir VIEŠPAČIU pasitikėjau; nesvyruosiu. ");
INSERT INTO lit_vpl VALUES ("PS26_3","020_26_3","PSA","26","3","3","Nes tavo mielaširdystė yra man prieš akis, ir vaikštau tavo tiesoje. ");
INSERT INTO lit_vpl VALUES ("PS26_8","020_26_8","PSA","26","8","8","VIEŠPATIE, aš myliu tavo namų gyvenamąją vietą, tai yra vietą, kur gyvena tavo šlovė. ");
INSERT INTO lit_vpl VALUES ("PS27_1","020_27_1","PSA","27","1","1","Dovydo. VIEŠPATS yra mano šviesa ir mano išgelbėjimas – kurio asmens man bijoti? VIEŠPATS yra mano gyvenimo tvirtovė – kurio asmens man išsigąsti? ");
INSERT INTO lit_vpl VALUES ("PS27_2","020_27_2","PSA","27","2","2","Kai blogadariai, – mano prispaudėjai ir mano priešai, – užpuolė mane, kad suėstų mano kūną, jie suklupo ir krito. ");
INSERT INTO lit_vpl VALUES ("PS27_3","020_27_3","PSA","27","3","3","Nors stovyklautų prieš mane kariuomenė, nenusigąs mano širdis, ir nors karas kiltų prieš mane, šiame dalyke liksiu tikintis. ");
INSERT INTO lit_vpl VALUES ("PS27_4","020_27_4","PSA","27","4","4","Vieno teprašiau iš VIEŠPATIES, to vieno sieksiu: likti VIEŠPATIES namuose per visas savo gyvenimo dienas, kad stebėčiau VIEŠPATIES pasigėrėjimą ir susikaupčiau jo šventykloje. ");
INSERT INTO lit_vpl VALUES ("PS27_8","020_27_8","PSA","27","8","8","Mano širdis už tave tarė: „Ieškokite mano veido.“ Tavo veido, VIEŠPATIE, aš ieškosiu. ");
INSERT INTO lit_vpl VALUES ("PS27_9","020_27_9","PSA","27","9","9","Neslėpk savo veido nuo manęs, neatstumk supykęs savo tarno! Tu esi mano pagalba, neatmesk manęs ir nepalik manęs, o mano išgelbėjimo Dieve! ");
INSERT INTO lit_vpl VALUES ("PS27_11","020_27_11","PSA","27","11","11","VIEŠPATIE, mokyk mane savo kelio, dėl mano priešų vesk mane lygiu taku. ");
INSERT INTO lit_vpl VALUES ("PS27_12","020_27_12","PSA","27","12","12","Neatiduok manęs mano priešų valiai, nes melagingi liudytojai sukilo prieš mane ir iškvepia smurtą. ");
INSERT INTO lit_vpl VALUES ("PS27_14","020_27_14","PSA","27","14","14","Lauk VIEŠPATIES! Būk stiprus, ir jis sutvirtins tavo širdį. Lauk, aš sakau, VIEŠPATIES! ");
INSERT INTO lit_vpl VALUES ("PS28_6","020_28_6","PSA","28","6","6","Palaimintas VIEŠPATS, nes jis išklausė mano maldavimų balsą! ");
INSERT INTO lit_vpl VALUES ("PS28_7","020_28_7","PSA","28","7","7","VIEŠPATS yra mano stiprybė ir mano skydas; juo pasitikėjo mano širdis, ir esu sulaukęs pagalbos. Todėl džiūgauja mano širdis, ir savo giesme girsiu jį. ");
INSERT INTO lit_vpl VALUES ("PS28_8","020_28_8","PSA","28","8","8","VIEŠPATS jiems yra stiprybė, taip pat savo pateptojo išgelbėjimo tvirtovė. ");
INSERT INTO lit_vpl VALUES ("PS29_1","020_29_1","PSA","29","1","1","Dovydo psalmė. Duokite VIEŠPAČIUI, o Galingojo sūnūs, duokite VIEŠPAČIUI šlovę ir galybę! ");
INSERT INTO lit_vpl VALUES ("PS29_2","020_29_2","PSA","29","2","2","Duokite VIEŠPAČIUI šlovę, priklausančią jo vardui, garbinkite VIEŠPATĮ šventumo grožyje. ");
INSERT INTO lit_vpl VALUES ("PS29_3","020_29_3","PSA","29","3","3","VIEŠPATIES balsas viršum vandenų! Šlovės Dievas sugriaudė. VIEŠPATS viršum didžių vandenų! ");
INSERT INTO lit_vpl VALUES ("PS29_4","020_29_4","PSA","29","4","4","VIEŠPATIES balsas galingas, VIEŠPATIES balsas didingas. ");
INSERT INTO lit_vpl VALUES ("PS29_5","020_29_5","PSA","29","5","5","VIEŠPATIES balsas laužo kedrus, VIEŠPATS gi laužo Libano kedrus. ");
INSERT INTO lit_vpl VALUES ("PS29_6","020_29_6","PSA","29","6","6","Jis šokdina juos lyg veršį, šokdina Libaną ir Sirjoną lyg jauną laukinį jautį. ");
INSERT INTO lit_vpl VALUES ("PS29_7","020_29_7","PSA","29","7","7","VIEŠPATIES balsas išskelia ugnies liepsnas. ");
INSERT INTO lit_vpl VALUES ("PS29_8","020_29_8","PSA","29","8","8","VIEŠPATIES balsas sudrebina dykumą, VIEŠPATS sudrebina Kadešo dykumą. ");
INSERT INTO lit_vpl VALUES ("PS29_9","020_29_9","PSA","29","9","9","VIEŠPATIES balsas sukelia gimdymo skausmus elnėms ir daro miškus plikus, o jo šventykloje visi kalba apie jo šlovę. ");
INSERT INTO lit_vpl VALUES ("PS29_10","020_29_10","PSA","29","10","10","VIEŠPATS sėdi viršum tvano, VIEŠPATS gi sėdi kaip Karalius per amžius. ");
INSERT INTO lit_vpl VALUES ("PS29_11","020_29_11","PSA","29","11","11","VIEŠPATS suteiks stiprybę savo tautai! VIEŠPATS palaimins savo tautą taika! ");
INSERT INTO lit_vpl VALUES ("PS30_1","020_30_1","PSA","30","1","1","Psalmė. Giesmė Namų pašventinimui. Dovydo. Aukštinsiu tave, o VIEŠPATIE, nes tu mane iškėlei ir neleidai mano priešams džiūgauti turėdami viršenybę prieš mane. ");
INSERT INTO lit_vpl VALUES ("PS30_2","020_30_2","PSA","30","2","2","O VIEŠPATIE, mano Dieve, šaukiausi tavęs, ir tu mane išgydei. ");
INSERT INTO lit_vpl VALUES ("PS30_10","020_30_10","PSA","30","10","10","Išgirsk, o VIEŠPATIE, ir pasigailėk manęs! VIEŠPATIE, būk man padėjėjas! ");
INSERT INTO lit_vpl VALUES ("PS30_11","020_30_11","PSA","30","11","11","Tu pavertei mano raudą šokiu ratelyje, nuvilkai man ašutinę ir apjuosei mane džiaugsmu, ");
INSERT INTO lit_vpl VALUES ("PS30_12","020_30_12","PSA","30","12","12","tam, kad mano šlovė giedotų gyrių tau ir netylėtų. O VIEŠPATIE, mano Dieve, tau dėkosiu amžinai! ");
INSERT INTO lit_vpl VALUES ("PS31_1","020_31_1","PSA","31","1","1","Vyriausiajam muzikui. Dovydo psalmė. Tavimi, o VIEŠPATIE, pasitikiu; niekados tenebūsiu sugėdintas! Išvaduok mane vadovaudamasis savo teisumu. ");
INSERT INTO lit_vpl VALUES ("PS31_2","020_31_2","PSA","31","2","2","Palenk prie manęs savo ausį, išvaduok mane skubiai! Būk man stipri uola, tvirtovių namai mane išgelbėti! ");
INSERT INTO lit_vpl VALUES ("PS31_3","020_31_3","PSA","31","3","3","Nes tu esi mano uola ir mano tvirtovė. Todėl dėl savo vardo vesk mane ir vadovauk man. ");
INSERT INTO lit_vpl VALUES ("PS31_4","020_31_4","PSA","31","4","4","Ištrauk mane iš tinklo, kurį slaptai man padėjo; nes tu esi mano stiprybė. ");
INSERT INTO lit_vpl VALUES ("PS31_5","020_31_5","PSA","31","5","5","Į tavo ranką pavedu savo dvasią. Tu išpirkai mane, o VIEŠPATIE, o tiesos Dieve. ");
INSERT INTO lit_vpl VALUES ("PS31_15","020_31_15","PSA","31","15","15","Tavo rankoje yra mano laikai – išplėšk mane iš mano priešų rankos ir iš mano pesekiotojų! ");
INSERT INTO lit_vpl VALUES ("PS31_23","020_31_23","PSA","31","23","23","Mylėkite VIEŠPATĮ, visi jo šventieji: VIEŠPATS apsaugo ištikimuosius, bet gausiai atlygina tam, kuris elgiasi išdidžiai. ");
INSERT INTO lit_vpl VALUES ("PS32_1","020_32_1","PSA","32","1","1","Dovydo. Maskilas. Koks didžiai palaimintas, kuriam atleistas nusižengimas, kurio nuodėmė uždengta! ");
INSERT INTO lit_vpl VALUES ("PS32_2","020_32_2","PSA","32","2","2","Koks didžiai palaimintas žmogus, kuriam VIEŠPATS neįskaito kaltės ir kurio dvasioje nėra apgaulės! ");
INSERT INTO lit_vpl VALUES ("PS32_3","020_32_3","PSA","32","3","3","Kol tylėjau, mano kaulai dūlėjo nuo mano nuolatinių dejonių. ");
INSERT INTO lit_vpl VALUES ("PS32_4","020_32_4","PSA","32","4","4","Nes dieną ir naktį mane slėgė tavo ranka; mano drėgnumas pavirto vasaros sausra. Sela. ");
INSERT INTO lit_vpl VALUES ("PS32_5","020_32_5","PSA","32","5","5","Pripažinau tau savo nuodėmę ir nenuslėpiau savo kaltės. Tariau: „Aš išpažinsiu savo nusižengimus VIEŠPAČIUI.“ Tada tu atleidai mano nuodėmės kaltę. Sela. ");
INSERT INTO lit_vpl VALUES ("PS32_6","020_32_6","PSA","32","6","6","Dėl to kiekvienas dievotasis melsis tau tuo laiku, kai tave galima rasti; tikrai, kai patvins gausingi vandenys, jie tokio nepasieks! ");
INSERT INTO lit_vpl VALUES ("PS32_7","020_32_7","PSA","32","7","7","Tu esi mano slėptuvė; nuo bėdos mane apsaugosi. Tu apsupsi mane išvadavimo giesmėmis. Sela. ");
INSERT INTO lit_vpl VALUES ("PS32_8","020_32_8","PSA","32","8","8","„Mokysiu tave ir rodysiu tau kelią, kuriuo turi eiti; patarsiu tau, kreipdamas į tave savo akį. ");
INSERT INTO lit_vpl VALUES ("PS32_9","020_32_9","PSA","32","9","9","Nebūk kaip arklys ar kaip mulas, neturintis supratimo! Žąslais ir kamanomis jų snukį reikia suvaldyti, kad nesiartintų prie tavęs. ");
INSERT INTO lit_vpl VALUES ("PS32_10","020_32_10","PSA","32","10","10","Nedorėliui būna daug skausmų, bet tas, kuris pasitiki VIEŠPAČIU, bus apsuptas palankumo. ");
INSERT INTO lit_vpl VALUES ("PS32_11","020_32_11","PSA","32","11","11","Džiaugitės VIEŠPAČIU ir džiūgaukite, teisieji, ir džiaugsmingai šūkaukite, visi tiesiaširdžiai! ");
INSERT INTO lit_vpl VALUES ("PS33_1","020_33_1","PSA","33","1","1","Džiūgaukite VIEŠPAČIU, jūs teisieji! Tiesaširdžiams pritinka jį girti. ");
INSERT INTO lit_vpl VALUES ("PS33_2","020_33_2","PSA","33","2","2","Girkite VIEŠPATĮ lyra, giedokite jam arfa ir dešimčiastygiu instrumentu! ");
INSERT INTO lit_vpl VALUES ("PS33_3","020_33_3","PSA","33","3","3","Giedokite jam naują giesmę, meistriškai grokite džiūgavimo skambesiu! ");
INSERT INTO lit_vpl VALUES ("PS33_18","020_33_18","PSA","33","18","18","Štai VIEŠPATIES akis nukreipta į tuos, kurie jo bijo, į tuos, kurie užtikrintai viliasi jo gailestingumu, ");
INSERT INTO lit_vpl VALUES ("PS33_20","020_33_20","PSA","33","20","20","Mūsų siela laukia VIEŠPATIES – Jis mūsų pagalba ir mūsų skydas, ");
INSERT INTO lit_vpl VALUES ("PS33_21","020_33_21","PSA","33","21","21","todėl juo džiaugiasi mūsų širdis, nes pasitikėjome jo šventuoju vardu. ");
INSERT INTO lit_vpl VALUES ("PS34_1","020_34_1","PSA","34","1","1","Dovydo psalmė, kai jis pakeitė savo elgseną Abimelecho akivaizdoje. Tas jį nuvarė, ir jis nuėjo. א Alef Laiminsiu VIEŠPATĮ visuomet; jo gyrius nuolat bus mano lūpose. ");
INSERT INTO lit_vpl VALUES ("PS34_2","020_34_2","PSA","34","2","2","VIEŠPAČIU didžiuosis mano siela; nuolankieji tai išgirs ir džiaugsis. ");
INSERT INTO lit_vpl VALUES ("PS34_3","020_34_3","PSA","34","3","3","Apskelbkite su manimi VIEŠPATIES didybę ir kartu aukštinkime jo vardą! ");
INSERT INTO lit_vpl VALUES ("PS34_4","020_34_4","PSA","34","4","4","Ieškojau VIEŠPATIES, ir jis išklausė mane ir išvadavo mane iš visų mano baimių. ");
INSERT INTO lit_vpl VALUES ("PS34_5","020_34_5","PSA","34","5","5","Jie žvelgė į jį ir prašviesėjo, ir jų veidai nebebus sugėdinti. ");
INSERT INTO lit_vpl VALUES ("PS34_6","020_34_6","PSA","34","6","6","Šis vargšas šaukėsi, ir VIEŠPATS jį išgirdo, ir jį išgelbėjo iš visų jo sielvartų. ");
INSERT INTO lit_vpl VALUES ("PS34_7","020_34_7","PSA","34","7","7","VIEŠPATIES angelas stovyklauja aplink tuos, kurie jo bijo, ir juos išvaduoja. ");
INSERT INTO lit_vpl VALUES ("PS34_8","020_34_8","PSA","34","8","8","Ragaukite ir matykite patys, koks geras VIEŠPATS! Koks didžiai palaimintas žmogus, kuris bėga prieglaudon pas jį. ");
INSERT INTO lit_vpl VALUES ("PS34_9","020_34_9","PSA","34","9","9","Bijokite VIEŠPATIES, jo šventieji, nes nieko nestokoja tie, kurie jo bijo. ");
INSERT INTO lit_vpl VALUES ("PS34_10","020_34_10","PSA","34","10","10","Jauni liūtai kenčia skurdą ir badauja, bet tie, kurie ieško VIEŠPATIES, jokio gero nestokos! ");
INSERT INTO lit_vpl VALUES ("PS34_11","020_34_11","PSA","34","11","11","Ateikite, vaikai, klausykite manęs; aš mokysiu jus VIEŠPATIES baimės. ");
INSERT INTO lit_vpl VALUES ("PS34_12","020_34_12","PSA","34","12","12","Kas iš jūsų yra žmogus, kuris trokšta gyvenimo, geidžia dienų, kad pamatytų gera? ");
INSERT INTO lit_vpl VALUES ("PS34_13","020_34_13","PSA","34","13","13","Sulaikyk savo liežuvį nuo blogo ir savo lūpas nuo apgaulingų kalbų! ");
INSERT INTO lit_vpl VALUES ("PS34_14","020_34_14","PSA","34","14","14","Venk blogio ir daryk gera, ieškok taikos ir ją vykis! ");
INSERT INTO lit_vpl VALUES ("PS34_15","020_34_15","PSA","34","15","15","Viešpaties akys nukreiptos į teisiuosius ir jo ausys į jų šauksmą. ");
INSERT INTO lit_vpl VALUES ("PS34_16","020_34_16","PSA","34","16","16","VIEŠPATIES veidas yra prieš darančius bloga, kad išdildytų nuo žemės jų atminimą. ");
INSERT INTO lit_vpl VALUES ("PS34_17","020_34_17","PSA","34","17","17","Teisieji šaukiasi, ir Viešpats klausosi ir išvaduoja juos iš visų jų sielvartų. ");
INSERT INTO lit_vpl VALUES ("PS34_18","020_34_18","PSA","34","18","18","VIEŠPATS yra arti tų, kurių širdis sudužusi, išgelbsti tuos, kurių dvasia palaužta. ");
INSERT INTO lit_vpl VALUES ("PS34_19","020_34_19","PSA","34","19","19","Daug blogybių patiria teisusis, bet iš jų visų jį išvaduoja VIEŠPATS. ");
INSERT INTO lit_vpl VALUES ("PS34_20","020_34_20","PSA","34","20","20","Jis saugo visus jo kaulus, nė vienas iš jų nesulūžęs. ");
INSERT INTO lit_vpl VALUES ("PS34_21","020_34_21","PSA","34","21","21","Nedorėlį pražudo blogis, ir tie, kurie nekenčia teisiojo, bus nuteisti. ");
INSERT INTO lit_vpl VALUES ("PS34_22","020_34_22","PSA","34","22","22","VIEŠPATS išperka savo tarnų sielą, ir nebus nuteistas nė vienas, kuris bėga prieglaudon pas jį. ");
INSERT INTO lit_vpl VALUES ("PS35_9","020_35_9","PSA","35","9","9","Tada mano siela džiaugsis VIEŠPAČIU; ji džiūgaus jo išgelbėjimu. ");
INSERT INTO lit_vpl VALUES ("PS35_27","020_35_27","PSA","35","27","27","Tekrykštauja ir tedžiūgauja tie, kurie nori teisingumo man, ir tegul jie nuolat sako: „Tebūna išaukštintas VIEŠPATS, kuris nori savo tarno gerovės!“ ");
INSERT INTO lit_vpl VALUES ("PS36_5","020_36_5","PSA","36","5","5","VIEŠPATIE, tavo gailestingumas siekia dangų, tavo ištikimumas – debesis. ");
INSERT INTO lit_vpl VALUES ("PS36_9","020_36_9","PSA","36","9","9","Nes tau priklauso gyvenimo šaltinis; tavo šviesoje mes matysime šviesą. ");
INSERT INTO lit_vpl VALUES ("PS37_1","020_37_1","PSA","37","1","1","Dovydo. א Alef Nesierzink dėl blogadarių, nepavydėk tiems, kurie daro neteisybę! ");
INSERT INTO lit_vpl VALUES ("PS37_2","020_37_2","PSA","37","2","2","Nes jie greitai bus nupjauti kaip žolė, ir nuvys kaip minkšta žolelė. ");
INSERT INTO lit_vpl VALUES ("PS37_3","020_37_3","PSA","37","3","3","Pasitikėk VIEŠPAČIU ir daryk gera; taip liksi apsigyvenęs šalyje ir būsi pamaitintas tiesa. ");
INSERT INTO lit_vpl VALUES ("PS37_4","020_37_4","PSA","37","4","4","Ir gėrėkis VIEŠPAČIU, ir jis duos tau, ko trokšta tavo širdis. ");
INSERT INTO lit_vpl VALUES ("PS37_5","020_37_5","PSA","37","5","5","Pavesk VIEŠPAČIUI savo kelią bei pasitikėk juo, ir jis veiks: ");
INSERT INTO lit_vpl VALUES ("PS37_6","020_37_6","PSA","37","6","6","tai yra, jis tavo teisybę iškels viešumon kaip šviesą ir tavo teisingumą kaip vidudienį. ");
INSERT INTO lit_vpl VALUES ("PS37_7","020_37_7","PSA","37","7","7","Būk ramus prieš VIEŠPATĮ ir kantriai jo lauk! Nesierzink dėl to, kuriam sekasi savajame kelyje – dėl žmogaus, kuris vykdo nedorus planus! ");
INSERT INTO lit_vpl VALUES ("PS37_8","020_37_8","PSA","37","8","8","Liaukis pykęs ir palik rūstybę! Nesierzink! Tai veda tik į bloga. ");
INSERT INTO lit_vpl VALUES ("PS37_9","020_37_9","PSA","37","9","9","Nes blogadariai bus pribaigti, bet tie, kurie laukia VIEŠPATIES, paveldės žemę. ");
INSERT INTO lit_vpl VALUES ("PS37_16","020_37_16","PSA","37","16","16","Truputis, kurį turi teisusis, yra geriau negu daugelio nedorėlių turtas. ");
INSERT INTO lit_vpl VALUES ("PS37_23","020_37_23","PSA","37","23","23","Gero žmogaus žingsniai yra VIEŠPATIES sudėlioti, ir jis džiaugiasi jo keliu. ");
INSERT INTO lit_vpl VALUES ("PS37_24","020_37_24","PSA","37","24","24","Nors jis krinta, nebus parblokštas, nes VIEŠPATS palaiko jį savo ranka. ");
INSERT INTO lit_vpl VALUES ("PS37_25","020_37_25","PSA","37","25","25","Buvau jaunas ir pasenau, tačiau nemačiau nei Dievo apleisto teisiojo, nei jo vaikų, elgetaujančių duonos. ");
INSERT INTO lit_vpl VALUES ("PS37_26","020_37_26","PSA","37","26","26","Ištisą dieną jis gailestingas ir skolina, ir jo vaikai yra palaiminti. ");
INSERT INTO lit_vpl VALUES ("PS37_27","020_37_27","PSA","37","27","27","Venk blogio ir daryk gera ir liksi apsigyvenęs per amžius, ");
INSERT INTO lit_vpl VALUES ("PS37_28","020_37_28","PSA","37","28","28","nes VIEŠPATS myli teisybę ir nepalieka savo šventųjų. ע Ajin Jie bus išsaugoti per amžius, bet nedorėlių vaikai bus pribaigti. ");
INSERT INTO lit_vpl VALUES ("PS37_37","020_37_37","PSA","37","37","37","Atkreipk dėmesį į tobuląjį ir žiūrėk į tiesųjį, nes ateitis tokiam žmogui yra gerovė. ");
INSERT INTO lit_vpl VALUES ("PS37_39","020_37_39","PSA","37","39","39","Bet teisiųjų išgelbėjimas ateina nuo VIEŠPATIES; jis yra jų tvirtovė sielvarto metu. ");
INSERT INTO lit_vpl VALUES ("PS37_40","020_37_40","PSA","37","40","40","Ir VIEŠPATS jiems padės, ir juos išvaduos. Jis juos išvaduos iš nedorėlių ir juos išgelbės, nes jie pasitiki juo. ");
INSERT INTO lit_vpl VALUES ("PS38_9","020_38_9","PSA","38","9","9","Viešpatie, tau atviras kiekvienas mano troškimas, ir mano dejavimas nuo tavęs nepaslėptas. ");
INSERT INTO lit_vpl VALUES ("PS38_18","020_38_18","PSA","38","18","18","Nes išpažįstu savo kaltę, nerimauju dėl savo nuodėmės. ");
INSERT INTO lit_vpl VALUES ("PS38_22","020_38_22","PSA","38","22","22","Skubėk man padėti, o Viešpatie, mano išgelbėjime! ");
INSERT INTO lit_vpl VALUES ("PS39_7","020_39_7","PSA","39","7","7","Bet ko dabar laukiu aš, Viešpatie? Esu sudėjęs savo viltis į tave! ");
INSERT INTO lit_vpl VALUES ("PS40_1","020_40_1","PSA","40","1","1","Vyriausiajam muzikui. Dovydo psalmė. Aš laukte laukiau Viešpaties; jis pasilenkė prie manęs ir išgirdo mano šauksmą. ");
INSERT INTO lit_vpl VALUES ("PS40_2","020_40_2","PSA","40","2","2","Jis ištraukė mane iš triukšmingos duobės, iš klampaus dumblo, ir pastatė ant uolos mano kojas, sutvirtino mano žingsnius. ");
INSERT INTO lit_vpl VALUES ("PS40_3","020_40_3","PSA","40","3","3","Jis įdėjo man į burną naują giesmę – gyrių mūsų Dievui. Daugelis matys ir bijos, ir pasitikės VIEŠPAČIU. ");
INSERT INTO lit_vpl VALUES ("PS40_7","020_40_7","PSA","40","7","7","Tada tariau: „Štai ateinu! Knygos ritinyje parašyta apie mane. ");
INSERT INTO lit_vpl VALUES ("PS40_8","020_40_8","PSA","40","8","8","Mėgstu vykdyti tavo valią, mano Dieve, ir tavo įstatymas yra pačiame mano viduje.“ ");
INSERT INTO lit_vpl VALUES ("PS40_17","020_40_17","PSA","40","17","17","Nors aš prispaustas as ir vargingas, Viešpats galvoja apie mane. Tu mano pagalba ir mano išvaduotojas; mano Dieve, nedelsk! ");
INSERT INTO lit_vpl VALUES ("PS41_1","020_41_1","PSA","41","1","1","Vyriausiajam muzikui. Dovydo psalmė. Koks didžiai palaimintas tas, kuris supratingai elgiasi su vargšais; nelaimės dieną VIEŠPATS jį išgelbės. ");
INSERT INTO lit_vpl VALUES ("PS41_2","020_41_2","PSA","41","2","2","VIEŠPATS jį apsaugos ir išlaikys gyvą, jis bus palaimintas žemėje, ir tu jo neatiduosi į jo priešų valią. ");
INSERT INTO lit_vpl VALUES ("PS41_4","020_41_4","PSA","41","4","4","Sakiau: „VIEŠPATIE, pasigailėk manęs, išgydyk mano sielą, nes esu nusidėjęs tau. ");
INSERT INTO lit_vpl VALUES ("PS41_9","020_41_9","PSA","41","9","9","Netgi mano artimas draugas, kuriuo pasitikėjau, kuris valgė mano duonos, pakėlė kulną prieš mane. ");
INSERT INTO lit_vpl VALUES ("PS42_1","020_42_1","PSA","42","1","1","Vyriausiajam muzikui. Maskilas. Koracho sūnums. Kaip elnias geidžia vandens upelių, taip mano siela geidžia tavęs, o Dieve. ");
INSERT INTO lit_vpl VALUES ("PS42_2","020_42_2","PSA","42","2","2","Mano siela trokšta Dievo, gyvojo Dievo; kada ateisiu ir pasirodysiu Dievo akivaizdoje? ");
INSERT INTO lit_vpl VALUES ("PS42_3","020_42_3","PSA","42","3","3","Mano ašaros tapo mano valgiu dieną ir naktį, kai jie nuolat manęs klausinėja: „Kur yra tavo Dievas?“ ");
INSERT INTO lit_vpl VALUES ("PS42_4","020_42_4","PSA","42","4","4","Kai šituos dalykus prisimenu, išlieju savyje savo sielą: nes aš eidavau su daugybe, eidavau su jais į Dievo namus džiaugsmo ir gyriaus balsu, su daugybe, kurie šventė šventadienį. ");
INSERT INTO lit_vpl VALUES ("PS42_5","020_42_5","PSA","42","5","5","Ko esi nusiminus, mano siela, ir ko nerimsti manyje? Užtikrintai lauk tu Dievo, nes aš dar girsiu jį už išgelbėjimą, kurį suteikia jo buvimas šalia! ");
INSERT INTO lit_vpl VALUES ("PS42_6","020_42_6","PSA","42","6","6","O mano Dieve, mano siela yra nusiminusi manyje, todėl iš Jordano krašto ir Hermono viršūnių krašto, iš Micaro kalvos nukreipsiu savo mintis į tave. ");
INSERT INTO lit_vpl VALUES ("PS42_7","020_42_7","PSA","42","7","7","Gelmė šaukia gelmei, tavo kriokliams griaudžiant, visos bangos ir tavo vilnys ritosi per mane. ");
INSERT INTO lit_vpl VALUES ("PS42_8","020_42_8","PSA","42","8","8","Dieną VIEŠPATS įsakys savo mielaširdystei lydėti mane, o naktį jo giesmė bus su manimi, malda mano gyvybės Dievui. ");
INSERT INTO lit_vpl VALUES ("PS42_9","020_42_9","PSA","42","9","9","Sakysiu Dievui, savo Uolai: „Kodėl mane pamiršai? Kodėl vaikštau gedėdamas dėl priešo engimo?“ ");
INSERT INTO lit_vpl VALUES ("PS42_10","020_42_10","PSA","42","10","10","Kenčiu lyg kaulus laužant, man priekaištauja mano priešai, kasdien man sakydami: „Kur yra tavo Dievas?“ ");
INSERT INTO lit_vpl VALUES ("PS42_11","020_42_11","PSA","42","11","11","Ko esi nusiminus, mano siela, ir ko nerimsti manyje? Užtikrintai lauk tu Dievo, nes aš dar girsiu jį, mano veido išgelbėjimą ir mano Dievą! ");
INSERT INTO lit_vpl VALUES ("PS43_3","020_43_3","PSA","43","3","3","Siųsk savo šviesą ir savo tiesą, teveda jos mane; teparveda mane į tavo šventąjį kalną ir į tavo didingą padangtę! ");
INSERT INTO lit_vpl VALUES ("PS43_5","020_43_5","PSA","43","5","5","Ko esi nusiminus, mano siela, ir ko nerimsti manyje? Užtikrintai lauk tu Dievo, nes aš dar girsiu jį, mano veido išgelbėjimą ir mano Dievą! ");
INSERT INTO lit_vpl VALUES ("PS44_8","020_44_8","PSA","44","8","8","Dievu giriamės ištisą dieną ir tavo vardą girsime per amžius. Sela. ");
INSERT INTO lit_vpl VALUES ("PS44_21","020_44_21","PSA","44","21","21","argi Dievas to nesuieškotų? Nes jis žino širdies paslaptis. ");
INSERT INTO lit_vpl VALUES ("PS44_22","020_44_22","PSA","44","22","22","Juk dėl tavęs mes esame žudomi visą dieną, mes laikomi tarsi pjautinomis avimis. ");
INSERT INTO lit_vpl VALUES ("PS44_26","020_44_26","PSA","44","26","26","Pakilk! Padėk mums ir išpirk mus dėl savo gailestingumo! ");
INSERT INTO lit_vpl VALUES ("PS45_11","020_45_11","PSA","45","11","11","tada karalius didžiai trokš tavo grožio; kadangi jis tavo Viešpats, nusilenk prieš jį ir tu. ");
INSERT INTO lit_vpl VALUES ("PS45_17","020_45_17","PSA","45","17","17","Aš padarysiu, kad tavo vardą atsimins visose kartų kartose; dėl to tautos tave girs per amžių amžius. ");
INSERT INTO lit_vpl VALUES ("PS46_1","020_46_1","PSA","46","1","1","Vyriausiajam muzikui. Koracho sūnums. Pritaikyta alamot. Giesmė. Dievas mums yra prieglauda ir stiprybė, labai prieinama pagalba bėdose. ");
INSERT INTO lit_vpl VALUES ("PS46_2","020_46_2","PSA","46","2","2","Todėl mes tikrai nebijosime, nors žemė pasikeistų, ir nors kalnai nuslystų į jūros vidurį, ");
INSERT INTO lit_vpl VALUES ("PS46_3","020_46_3","PSA","46","3","3","nors jos vandenys siaustų ir putotų, nors ir drebėtų kalnai jai sukilus. Sela. ");
INSERT INTO lit_vpl VALUES ("PS46_4","020_46_4","PSA","46","4","4","Yra upė, kurios srovės džiugins Dievo miestą, Aukščiausiojo didingos buveinės šventąją vietą. ");
INSERT INTO lit_vpl VALUES ("PS46_5","020_46_5","PSA","46","5","5","Dievas yra to miesto viduje: jis negali svyruoti; Dievas jam padės rytui brėkštant. ");
INSERT INTO lit_vpl VALUES ("PS46_6","020_46_6","PSA","46","6","6","Siautė tautos, svyravo karalystės; jam pakėlus balsą – ištirpo žemė! ");
INSERT INTO lit_vpl VALUES ("PS46_7","020_46_7","PSA","46","7","7","Kareivijų VIEŠPATS yra su mumis, Jokūbo Dievas mums yra aukštoji prieglauda. Sela. ");
INSERT INTO lit_vpl VALUES ("PS46_8","020_46_8","PSA","46","8","8","Ateikite, stebėkite VIEŠPATIES veiksmus, kokių suniokojimų jis įvykdė žemėje! ");
INSERT INTO lit_vpl VALUES ("PS46_9","020_46_9","PSA","46","9","9","Jis sustabdo karus iki žemės pakraščio, sulaužo lankus ir sukapoja ietis, sudegina vežimus ugnimi! ");
INSERT INTO lit_vpl VALUES ("PS46_10","020_46_10","PSA","46","10","10","Liaukitės ir pripažinkite, kad aš esu Dievas! Būsiu išaukštintas tautose, išaukštintas žemėje. ");
INSERT INTO lit_vpl VALUES ("PS46_11","020_46_11","PSA","46","11","11","Kareivijų VIEŠPATS yra su mumis, Jokūbo Dievas mums yra aukštoji prieglauda. Sela. ");
INSERT INTO lit_vpl VALUES ("PS47_2","020_47_2","PSA","47","2","2","Nes VIEŠPATS, aukščiausiasis, yra baimę keliantis, didis visos žemės Karalius. ");
INSERT INTO lit_vpl VALUES ("PS47_6","020_47_6","PSA","47","6","6","Giedokite gyrių Dievui, giedokite gyrių! Giedokite gyrių mūsų Karaliui, giedokite gyrių, ");
INSERT INTO lit_vpl VALUES ("PS47_7","020_47_7","PSA","47","7","7","nes Dievas yra visos žemės Karalius! Giedokite gyrių protaudami! ");
INSERT INTO lit_vpl VALUES ("PS48_10","020_48_10","PSA","48","10","10","Kaip tavo vardas, o Dieve, taip ir gyrius tau siekia žemės pakraščius; tavo dešinė pilna teisumo. ");
INSERT INTO lit_vpl VALUES ("PS48_14","020_48_14","PSA","48","14","14","kad šis Dievas yra mūsų Dievas per amžių amžius – jis pats ves mus iki mirties! ");
INSERT INTO lit_vpl VALUES ("PS49_6","020_49_6","PSA","49","6","6","Tie, kurie pasitiki savo turtu ir giriasi savo nuosavybės gausybe, ");
INSERT INTO lit_vpl VALUES ("PS49_7","020_49_7","PSA","49","7","7","nė vienas iš jų jokiu būdu nepajėgia išpirkti savo brolio, nė pajėgia duoti Dievui išpirkos už jį ");
INSERT INTO lit_vpl VALUES ("PS49_8","020_49_8","PSA","49","8","8","(nes jų sielos išpirkimas yra brangus, tad kas bando tesiliauja visam) ");
INSERT INTO lit_vpl VALUES ("PS50_14","020_50_14","PSA","50","14","14","Aukok Dievui padėką ir Aukščiausiajam vykdyk savo įžadus ");
INSERT INTO lit_vpl VALUES ("PS50_15","020_50_15","PSA","50","15","15","ir šaukis manęs bėdos dieną, tai išvaduosiu tave, ir tu mane šlovinsi. ");
INSERT INTO lit_vpl VALUES ("PS50_23","020_50_23","PSA","50","23","23","Kas aukoja padėką, pašlovina mane ir paruošia kelią; tam parodysiu Dievo išgelbėjimą. ");
INSERT INTO lit_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","Vyriausiajam muzikui. Dovydo psalmė. Kai pranašas Natanas atėjo pas jį po to, kai tas buvo įėjęs pas Batšebą. Pasigailėk manęs, o Dieve, pagal savo mielaširdystę, pagal savo meilumo apstybę išdildyk mano nusižengimus. ");
INSERT INTO lit_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","Visai nuplauk nuo manęs mano kaltę ir nuo mano nuodėmės apvalyk mane. ");
INSERT INTO lit_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","Nes aš pripažįstu savo nusižengimus, ir mano nuodėmė man yra nuolat prieš akis – ");
INSERT INTO lit_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","tau nusidėjau, tiktai tau, ir padariau, kas bloga tavo akyse, – kad būtum išteisintas kalbėdamas, nepeiktinas teisdamas. ");
INSERT INTO lit_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","Štai aš buvau pagimdytas jau nukrypęs nuo to, kas teisinga, ir nuodėmingą mane pradėjo mano motina. ");
INSERT INTO lit_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","Štai tu trokšti matyti tiesą žmogaus viduje, ir duosi man pažinti išmintį mano slaptame „aš“. ");
INSERT INTO lit_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Apvalyk mane yzopu, ir būsiu švarus, nuplauk mane, ir būsiu baltesnis už sniegą. ");
INSERT INTO lit_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","Duok man išgirsti džiaugsmo ir linksmybės žinią, kad džiūgautų kaulai, kuriuos sudaužei! ");
INSERT INTO lit_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","Paslėpk savo veidą nuo mano nuodėmių ir išdildyk visas mano kaltes. ");
INSERT INTO lit_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","Sukurk man tyrą širdį, o Dieve, ir teisingą dvasią atnaujink manyje. ");
INSERT INTO lit_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Nenumesk manęs iš savo akivaizdos, ir savo Šventosios Dvasios neatimk nuo manęs. ");
INSERT INTO lit_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","Grąžink man džiaugsmą, kilusį iš tavo išgelbėjimo, ir paremk mane savo noringa Dvasia. ");
INSERT INTO lit_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","Mokysiu nusižengėlius tavo kelių, ir nusidėjėliai atsivers į tave. ");
INSERT INTO lit_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","Išlaisvink mane nuo kraujo kaltės, o Dieve, mano išgelbėjimo Dieve, ir mano liežuvis džiaugsmingai šūkaus apie tavo teisumą. ");
INSERT INTO lit_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","O Viešpatie, praverk mano lūpas, ir mano burna skelbs tavo gyrių! ");
INSERT INTO lit_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","16","Nes tu nenori aukos, – priešingu atveju tau ją atnašaučiau, – tavęs nedžiugina deginamoji auka. ");
INSERT INTO lit_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","Dievui tinkamos aukos – sudužusi dvasia; sudužusios ir palaužtos širdies tu, Dieve, nepaniekinsi. ");
INSERT INTO lit_vpl VALUES ("PS51_18","020_51_18","PSA","51","18","18","Savo gera valia daryk gera Sionui: pastatyk Jeruzalės sienas! ");
INSERT INTO lit_vpl VALUES ("PS51_19","020_51_19","PSA","51","19","19","Tada tu būsi patenkintas teisingomis aukomis, tai yra deginamąja auka ir visai sudeginama auka, tada jaučiai bus atnašaujami ant tavo aukuro. ");
INSERT INTO lit_vpl VALUES ("PS52_8","020_52_8","PSA","52","8","8","Bet aš esu kaip žaliuojantis alyvmedis Dievo namuose; aš pasitikiu Dievo gailestingumu visados ir per amžius. ");
INSERT INTO lit_vpl VALUES ("PS53_1","020_53_1","PSA","53","1","1","Vyriausiajam muzikui. Pagal mahalatą. Maskilas. Dovydo. Kvailys pasakė savo širdyje: „Nėra Dievo“. Tokie sugedę ir daro šlykščią neteisybę; nėra gera darančio. ");
INSERT INTO lit_vpl VALUES ("PS53_2","020_53_2","PSA","53","2","2","Dievas žvelgė žemyn iš dangaus į žmonių palikuonis, kad pamatytų, ar yra kas išmano, kas ieško Dievo. ");
INSERT INTO lit_vpl VALUES ("PS53_3","020_53_3","PSA","53","3","3","Visi atsitraukė, jie kartu pasidarė suteršti; nėra gera darančio, nėra nė vieno. ");
INSERT INTO lit_vpl VALUES ("PS53_4","020_53_4","PSA","53","4","4","Argi tie, kurie daro neteisybę, yra tokie nežinantys?! Jie ryja mano tautą, kaip jie valgo duoną, ir nėra pasišaukę Dievo! ");
INSERT INTO lit_vpl VALUES ("PS53_5","020_53_5","PSA","53","5","5","Jie tenai drebete drebėjo iš baimės, kokios dar nėra buvus, nes Dievas išmėtė tave apgulusiųjų kaulus. Tu juos sugėdinai, nes Dievas juos atmetė. ");
INSERT INTO lit_vpl VALUES ("PS53_6","020_53_6","PSA","53","6","6","O, kad iš Siono ateitų galutinis išgelbėjimas Izraeliui! Kai Dievas sugrąžins namo savo nelaisvėn paimtą tautą, džiūgaus Jokūbas, apsidžiaugs Izraelis! ");
INSERT INTO lit_vpl VALUES ("PS54_4","020_54_4","PSA","54","4","4","Štai Dievas yra mano pagelbėtojas, Viešpats palaiko mano sielą! ");
INSERT INTO lit_vpl VALUES ("PS55_16","020_55_16","PSA","55","16","16","Štai dėl manęs – aš šauksiuosi Dievo, ir VIEŠPATS mane išgelbės. ");
INSERT INTO lit_vpl VALUES ("PS55_22","020_55_22","PSA","55","22","22","Mesk ant VIEŠPATIES savo naštą, ir jis palaikys tave; jis niekados neleis teisiajam pargriūti. ");
INSERT INTO lit_vpl VALUES ("PS56_3","020_56_3","PSA","56","3","3","Tuomet, kai bijau, pasitikėsiu tavimi. ");
INSERT INTO lit_vpl VALUES ("PS56_13","020_56_13","PSA","56","13","13","Nes tu išvadavai mano sielą iš mirties; ar neišvaduosi mano kojų nuo suklupimo, kad Dievo akivaizdoje vaikščiočiau gyvųjų šviesoje? ");
INSERT INTO lit_vpl VALUES ("PS57_1","020_57_1","PSA","57","1","1","Vyriausiajam muzikui, Altaschitas. Dovydo miktamas, kai jis bėgo nuo Sauliaus į olą. Būk man gailestingas, o Dieve, būk man gailestingas, nes mano siela pasitiki tavimi ir tavo sparnų paūksmėje turėsiu prieglobstį, kol praeis didžiulė nelaimė. ");
INSERT INTO lit_vpl VALUES ("PS57_2","020_57_2","PSA","57","2","2","Aš šauksiuosi Dievo, Aukščiausiojo, Dievo, kuris iki galo veikia mano labui. ");
INSERT INTO lit_vpl VALUES ("PS57_10","020_57_10","PSA","57","10","10","nes didis, siekiantis dangų, yra tavo gailestingumas ir siekianti debesis tavo ištikimybė. ");
INSERT INTO lit_vpl VALUES ("PS59_16","020_59_16","PSA","59","16","16","Bet aš giedosiu apie tavo jėgą ir krykštausiu rytmetį dėl tavo gailestingumo, nes tu pasidarei man aukšta prieglauda, priebėga mano suspaudimo dieną. ");
INSERT INTO lit_vpl VALUES ("PS60_1","020_60_1","PSA","60","1","1","Vyriausiajam muzikui. Atliekama pagal melodiją „Šošanim-edut“. Dovydo miktamas. Pamokymui. Kai jis kariavo su Aram-naharaimais ir Aram-zoba ir kai Joabas apsisuko ir sumušė Druskos slėnyje dvylika tūkstančių iš Edomo. O Dieve, tu mus atstūmei, ant mūsų išsiveržei, tu užsirūstinai – o atstatyk mus! ");
INSERT INTO lit_vpl VALUES ("PS60_5","020_60_5","PSA","60","5","5","Kad tavo mylimieji būtų išvaduoti, išgelbėk savo dešine ir išklausyk mane! ");
INSERT INTO lit_vpl VALUES ("PS60_12","020_60_12","PSA","60","12","12","Su Dievu mes veiksime galingai, nes jis sumindys mūsų priešus. ");
INSERT INTO lit_vpl VALUES ("PS61_1","020_61_1","PSA","61","1","1","Vyriausiajam muzikui. Su styginiu instrumentu. Dovydo. O Dieve, išgirsk mano šauksmą, klausykis mano maldos! ");
INSERT INTO lit_vpl VALUES ("PS61_2","020_61_2","PSA","61","2","2","Iš žemės pakraščio šaukiuosi tavęs, mano širdžiai alpstant – vesk mane į uolą, aukštesnę už mane! ");
INSERT INTO lit_vpl VALUES ("PS61_3","020_61_3","PSA","61","3","3","Juk tu buvai ir tebesi man prieglauda ir stiprus bokštas gintis nuo priešo. ");
INSERT INTO lit_vpl VALUES ("PS61_4","020_61_4","PSA","61","4","4","Aš gyvensiu tavo padangtėje amžinai, liksiu bėgęs prieglaudon į tavo sparnų slėptuvę. Sela. ");
INSERT INTO lit_vpl VALUES ("PS61_5","020_61_5","PSA","61","5","5","Nes tu, o Dieve, girdėjai mano įžadus; tu davei man paveldą su tais, kurie bijo tavo vardo. ");
INSERT INTO lit_vpl VALUES ("PS61_6","020_61_6","PSA","61","6","6","Pridėsi dienų prie karaliaus gyvenimo, pridėsi metų lyg iš kartos į kartą. ");
INSERT INTO lit_vpl VALUES ("PS61_7","020_61_7","PSA","61","7","7","Jis sėdės per amžius Dievo akivaizdoje; paskirk gerumą ir tiesą, kurie jį apsaugos. ");
INSERT INTO lit_vpl VALUES ("PS61_8","020_61_8","PSA","61","8","8","Tada aš giedosiu gyrių tavo vardui per amžius, kad kasdien vykdyčiau savo įžadus. ");
INSERT INTO lit_vpl VALUES ("PS62_2","020_62_2","PSA","62","2","2","Jis vienintelis yra mano uola ir mano išgelbėjimas, mano aukšta prieglauda; aš nepargriūsiu galutinai. ");
INSERT INTO lit_vpl VALUES ("PS62_5","020_62_5","PSA","62","5","5","Mano siela, ramiai lauk vien tik Dievo, nes iš jo ateina tai, ko užtikrintai laukiu. ");
INSERT INTO lit_vpl VALUES ("PS62_6","020_62_6","PSA","62","6","6","Jis vienintelis yra mano uola ir mano išgelbėjimas, mano aukšta prieglauda; aš nepargriūsiu. ");
INSERT INTO lit_vpl VALUES ("PS62_7","020_62_7","PSA","62","7","7","Ant Dievo rymo mano išgelbėjimas ir mano šlovė; mano stiprybės uola, mano prieglobstis yra Dieve. ");
INSERT INTO lit_vpl VALUES ("PS62_8","020_62_8","PSA","62","8","8","O žmonės, pasitikėkite juo visados! Išliekite jo akivaizdoje savo širdį; Dievas yra mūsų prieglauda! Sela. ");
INSERT INTO lit_vpl VALUES ("PS63_3","020_63_3","PSA","63","3","3","Tavo mielaširdystė yra geresnė už geriausią gyvenimą, todėl mano lūpos girs tave. ");
INSERT INTO lit_vpl VALUES ("PS64_10","020_64_10","PSA","64","10","10","Teisusis džiaugsis VIEŠPAČIU ir bėgs prieglaudon pas jį: ir visi tiesiaširdžiai rodys šlovę. ");
INSERT INTO lit_vpl VALUES ("PS65_1","020_65_1","PSA","65","1","1","Vyriausiajam muzikui. Dovydo psalmė. Giesmė. Gyrius laukia tavęs Sione, o Dieve, ir tau bus įvykdytas įžadas. ");
INSERT INTO lit_vpl VALUES ("PS65_4","020_65_4","PSA","65","4","4","Koks didžiai palaimintas žmogus, kurį tu išsirenki ir artini prie savęs, kad gyventų tavo kiemuose! Pasitenkinsime tavo namų, tavo šventų rūmų, gėrybėmis. ");
INSERT INTO lit_vpl VALUES ("PS65_11","020_65_11","PSA","65","11","11","Tu apvainikuoji metus savo gerumu, ir tavo vežimų provėžos trykšta riebalais. ");
INSERT INTO lit_vpl VALUES ("PS66_1","020_66_1","PSA","66","1","1","Vyriausiajam muzikui. Giesmė. Psalmė. O visos šalys, kelkite džiaugsmingą skambų garsą VIEŠPAČIUI! ");
INSERT INTO lit_vpl VALUES ("PS66_2","020_66_2","PSA","66","2","2","Apgiedokite jo vardo šlovę; girkite jį šlovingai. ");
INSERT INTO lit_vpl VALUES ("PS66_18","020_66_18","PSA","66","18","18","Jei būčiau pritaręs nedorybei savo širdyje, tai Viešpats nebūtų manęs išklausęs. ");
INSERT INTO lit_vpl VALUES ("PS66_20","020_66_20","PSA","66","20","20","Tebūna palaimintas Dievas, kuris neatmetė mano maldos ir neatitraukė savo gailestingumo nuo manęs. ");
INSERT INTO lit_vpl VALUES ("PS67_1","020_67_1","PSA","67","1","1","Vyriausiajam muzikui. Su styginiais instrumentais. Psalmė. Giesmė. Tebūna Dievas mums maloningas ir telaimina mus, savo veido šviesą tekreipia į mus, Sela. ");
INSERT INTO lit_vpl VALUES ("PS67_2","020_67_2","PSA","67","2","2","kad tavo kelias būtų žinomas žemėje, tavo išgelbėjimas visose tautose. ");
INSERT INTO lit_vpl VALUES ("PS67_6","020_67_6","PSA","67","6","6","Žemė duos savo derlių; laimins mus Dievas, mūsų pačių Dievas! ");
INSERT INTO lit_vpl VALUES ("PS68_5","020_68_5","PSA","68","5","5","Našlaičių tėvas ir našlių gynėjas – tai Dievas savo šventoje buveinėje. ");
INSERT INTO lit_vpl VALUES ("PS68_6","020_68_6","PSA","68","6","6","Dievas apgyvendina vienišus šeimose, jis išveda belaisvius, sukaustytus grandinėmis, bet maištininkams tenka gyventi išdegusioje vietovėje. ");
INSERT INTO lit_vpl VALUES ("PS68_9","020_68_9","PSA","68","9","9","Tu, o Dieve, siuntei gausų lietų, kuriuo tu sutvirtinai savo veldinį, kai jis buvo nuvargęs. ");
INSERT INTO lit_vpl VALUES ("PS68_11","020_68_11","PSA","68","11","11","Viešpats davė žodį, tos geros žinios pranešėjų būrys buvo didžiulis. ");
INSERT INTO lit_vpl VALUES ("PS68_19","020_68_19","PSA","68","19","19","Tebūna palaimintas Viešpats, kuris diena iš dienos apkrauna mus geradarystėmis; Dievas yra mūsų išgelbėjimas! Sela. ");
INSERT INTO lit_vpl VALUES ("PS68_20","020_68_20","PSA","68","20","20","Mūsų Dievas yra išgelbėjimo Dievas, ir JEHOVAI, Viešpačiui, priklauso išeitys iš mirties. ");
INSERT INTO lit_vpl VALUES ("PS68_28","020_68_28","PSA","68","28","28","Tavo Dievas yra tavo stiprybės priežastis; pasirodyk stiprus, O Dieve – tu tai darei mūsų labui! ");
INSERT INTO lit_vpl VALUES ("PS69_4","020_69_4","PSA","69","4","4","Daugiau negu mano galvos plaukų yra tų, kurie nekenčia manęs be priežasties. Galingi yra tie, kurie nori mane sunaikinti, neteisėtai būdami mano priešais. Tada aš grąžinau tai, ko nebuvau paėmęs. ");
INSERT INTO lit_vpl VALUES ("PS69_9","020_69_9","PSA","69","9","9","Nes uolumas dėl tavo namų sugraužė mane, ir užgauliojimai tų, kurie tave užgaulioja, krito ant manęs. ");
INSERT INTO lit_vpl VALUES ("PS69_12","020_69_12","PSA","69","12","12","Tie, kurie sėdi vartuose, kalba prieš mane, ir aš – geriančiųjų stipriųjų gėrimų pašaipos daina. ");
INSERT INTO lit_vpl VALUES ("PS69_17","020_69_17","PSA","69","17","17","Ir neslėpk savo veido nuo savo tarno, nes esu bėdoje; skubiai išklausyk mane! ");
INSERT INTO lit_vpl VALUES ("PS69_32","020_69_32","PSA","69","32","32","Nuolankieji tai matys ir nudžiugs, jūs, ieškantys Dievo – atgis gi jūsų širdis! ");
INSERT INTO lit_vpl VALUES ("PS69_34","020_69_34","PSA","69","34","34","Tegul jį giria dangus ir žemė, jūros ir visa, kas jose juda! ");
INSERT INTO lit_vpl VALUES ("PS71_3","020_71_3","PSA","71","3","3","Būk man saugi gyvenamoji vieta, į kurią galima nuolat ateiti; tu įsakei išgelbėti mane, nes tu esi mano uola ir mano tvirtovė. ");
INSERT INTO lit_vpl VALUES ("PS71_8","020_71_8","PSA","71","8","8","Mano burna tebūna pripildyta tavo gyriaus ir tavo garbės visą dieną. ");
INSERT INTO lit_vpl VALUES ("PS71_14","020_71_14","PSA","71","14","14","Bet aš nuolat užtikrintai vilsiuosi ir daugiau pridėsiu prie viso tavo gyriaus. ");
INSERT INTO lit_vpl VALUES ("PS71_16","020_71_16","PSA","71","16","16","Aš eisiu su Viešpaties DIEVO jėga, minėsiu tavo teisumą, tavo vieno! ");
INSERT INTO lit_vpl VALUES ("PS71_19","020_71_19","PSA","71","19","19","Ir tavo teisumas pasiekia aukštybę, o Dieve, kuris padarei didžių dalykų; o Dieve, kas yra lygus tau?! ");
INSERT INTO lit_vpl VALUES ("PS71_23","020_71_23","PSA","71","23","23","Džiaugsmingai šūkaus mano lūpos, kai tau giedosiu, ir mano siela, kurią išpirkai! ");
INSERT INTO lit_vpl VALUES ("PS72_12","020_72_12","PSA","72","12","12","Nes jis išvaduoja neturtėlį, kuris šaukiasi pagalbos, ir varguolį bei tą, kuriam nėra padėjėjo. ");
INSERT INTO lit_vpl VALUES ("PS72_13","020_72_13","PSA","72","13","13","Jis pasigailės vargšo bei neturtėlio ir išgelbės neturtėlių sielas. ");
INSERT INTO lit_vpl VALUES ("PS72_18","020_72_18","PSA","72","18","18","Tebūna pagarbintas VIEŠPATS Dievas, Izraelio Dievas, kuris vienas daro stebuklus! ");
INSERT INTO lit_vpl VALUES ("PS73_1","020_73_1","PSA","73","1","1","Asafo psalmė. Tikrai Dievas geras Izraeliui, tiems, kurių širdis tyra! ");
INSERT INTO lit_vpl VALUES ("PS73_2","020_73_2","PSA","73","2","2","O mano atvejis buvo toksai: mano kojos vos nepaslydo, mano žingsniai bemaž buvo ėmę slidinėti, ");
INSERT INTO lit_vpl VALUES ("PS73_3","020_73_3","PSA","73","3","3","nes pavydėjau pagyrūnams, mačiau, kaip gerai sekasi nedorėliams. ");
INSERT INTO lit_vpl VALUES ("PS73_7","020_73_7","PSA","73","7","7","Nuo riebalų išsiverčia jų akys, jie turi daugiau, negu geidžia širdis. ");
INSERT INTO lit_vpl VALUES ("PS73_24","020_73_24","PSA","73","24","24","Tu vesi mane savo nutarimu ir paskui priimsi mane į šlovę. ");
INSERT INTO lit_vpl VALUES ("PS73_25","020_73_25","PSA","73","25","25","Be tavęs, kas man danguje? Ir žemėje man nėra ko gėrėtis be tavęs. ");
INSERT INTO lit_vpl VALUES ("PS73_26","020_73_26","PSA","73","26","26","Mano kūnas ir mano širdis sunyksta, bet Dievas yra mano širdies stiprybė ir mano dalis per amžius. ");
INSERT INTO lit_vpl VALUES ("PS73_27","020_73_27","PSA","73","27","27","Nes štai tie, kurie yra toli nuo tavęs, pražus; tu išrausi su šaknimis visus, kurie nueina nuo tavęs paleistuvaudami. ");
INSERT INTO lit_vpl VALUES ("PS73_28","020_73_28","PSA","73","28","28","O dėl manęs – man gera būti arti Dievo; aš bėgau prieglaudon pas Viešpatį JEHOVĄ, kad paskelbčiau visus tavo darbus. ");
INSERT INTO lit_vpl VALUES ("PS75_7","020_75_7","PSA","75","7","7","bet teisėjas yra Dievas; vieną jis pažemina, o kitą išaukština. ");
INSERT INTO lit_vpl VALUES ("PS77_8","020_77_8","PSA","77","8","8","Nejaugi jo gailestingumas pasiliovė amžinai?! Argi liks neįvykdytas jo pažadas kartų kartoms?! ");
INSERT INTO lit_vpl VALUES ("PS77_11","020_77_11","PSA","77","11","11","Aš atsiminsiu VIEŠPATIES darbus, tikrai atsiminsiu tavo stebuklus nuo tolimos praeities. ");
INSERT INTO lit_vpl VALUES ("PS78_1","020_78_1","PSA","78","1","1","Asafo maskilas. Klausykis, o mano tauta, mano įstatymo; palenkite savo ausis prie mano burnos žodžių! ");
INSERT INTO lit_vpl VALUES ("PS78_2","020_78_2","PSA","78","2","2","Atversiu savo burną palyginimu, išliesiu senovės mįsles, ");
INSERT INTO lit_vpl VALUES ("PS78_22","020_78_22","PSA","78","22","22","nes jie netikėjo Dievu ir nepasitikėjo Jo išgelbėjimu. ");
INSERT INTO lit_vpl VALUES ("PS78_34","020_78_34","PSA","78","34","34","Kai jis juos mirtinai smogė, tada jie jo ieškojo: jie gi atsigręžė ir rimtai kreipėsi į Dievą. ");
INSERT INTO lit_vpl VALUES ("PS78_35","020_78_35","PSA","78","35","35","Ir jie atsiminė, kad Dievas yra jų uola ir aukščiausiasis Dievas jų išpirkėjas. ");
INSERT INTO lit_vpl VALUES ("PS78_41","020_78_41","PSA","78","41","41","Taip, jie nusigręždavo ir gundydavo Dievą, ir apribodavo Izraelio Šventąjį. ");
INSERT INTO lit_vpl VALUES ("PS78_53","020_78_53","PSA","78","53","53","Ir jis saugiai juos vedė, todėl jie neišsigando; bet jūra užtvindė jų priešus. ");
INSERT INTO lit_vpl VALUES ("PS79_9","020_79_9","PSA","79","9","9","Padėk mums, mūsų išgelbėjimo Dieve, / dėl savo vardo šlovės! / Išgelbėk mus ir atpirkimu pašalink mūsų nuodėmes / dėl savo vardo! / ");
INSERT INTO lit_vpl VALUES ("PS79_13","020_79_13","PSA","79","13","13","O mes, tavo tauta ir tavo ganyklos avys, amžinai tau dėkosime, kartų kartoms garsinsime tavo gyrių! ");
INSERT INTO lit_vpl VALUES ("PS80_1","020_80_1","PSA","80","1","1","Vyriausiajam muzikui. Atliekama pagal melodiją „Šošanim-edut“. Asafo. Psalmė. Klausykis, O Izraelio Ganytojau! Tu, kuris vedi Juozapą lyg kaimenę. Suspindėk tu, kuris sėdi tarp kerubų. ");
INSERT INTO lit_vpl VALUES ("PS80_18","020_80_18","PSA","80","18","18","Tada nesitrauksime nuo tavęs; atgaivink mus, ir mes šauksimės tavo vardo! ");
INSERT INTO lit_vpl VALUES ("PS81_10","020_81_10","PSA","81","10","10","Aš VIEŠPATS, tavo Dievas, kuris atvedžiau tave aukštyn iš Egipto šalies. Plačiai atverk savo burną, ir aš ją pripildysiu. ");
INSERT INTO lit_vpl VALUES ("PS82_1","020_82_1","PSA","82","1","1","Asafo psalmė. Dievas stovi galingųjų susirinkime; tarp dievų jis daro teismą. ");
INSERT INTO lit_vpl VALUES ("PS83_1","020_83_1","PSA","83","1","1","Giesmė. Asafo psalmė. O Dieve, nebūk ramiai nutylėjęs! Nebūk nebylus ir nebūk ramus, o Dieve! ");
INSERT INTO lit_vpl VALUES ("PS83_18","020_83_18","PSA","83","18","18","kad žmonės žinotų, jog tu vienas, kurio vardas JEHOVA, esi aukščiausiasis visai žemei. ");
INSERT INTO lit_vpl VALUES ("PS84_1","020_84_1","PSA","84","1","1","Vyriausiajam muzikui. Pagal gititą. Koracho sūnums. Psalmė. Kokia miela tavo didinga padangtė, o Kareivijų VIEŠPATIE! ");
INSERT INTO lit_vpl VALUES ("PS84_2","020_84_2","PSA","84","2","2","VIEŠPATIES kiemų trokšta mano siela, netgi alpsta! Mano širdis ir mano kūnas krykštauja dėl buvimo arti gyvojo Dievo! ");
INSERT INTO lit_vpl VALUES ("PS84_3","020_84_3","PSA","84","3","3","Net žvirblis rado namus ir kregždė sau lizdą, kur galėtų sudėti savo jauniklius, prie tavo aukurų, o kareivijų VIEŠPATIE, mano Karaliau ir mano Dieve. ");
INSERT INTO lit_vpl VALUES ("PS84_4","020_84_4","PSA","84","4","4","Kokie didžiai palaiminti, kurie gyvena tavo namuose: jie ir toliau girs tave. Sela. ");
INSERT INTO lit_vpl VALUES ("PS84_5","020_84_5","PSA","84","5","5","Koks didžiai palaimintas žmogus, kurio stiprybė yra tavyje – aukštieji keliai yra tokių žmonių širdyse. ");
INSERT INTO lit_vpl VALUES ("PS84_6","020_84_6","PSA","84","6","6","Keliaudami per Bachos slėnį, jie pavers jį paversmiu, ir lietus pripildys duburius. ");
INSERT INTO lit_vpl VALUES ("PS84_7","020_84_7","PSA","84","7","7","Jie eina iš stiprybės į stiprybę, kiekvienas iš jų pasirodo Dievo akivaizdoje Sione. ");
INSERT INTO lit_vpl VALUES ("PS84_8","020_84_8","PSA","84","8","8","O VIEŠPATIE, kareivijų Dieve, išgirsk mano maldą! Klausykis, o Jokūbo Dieve! Sela. ");
INSERT INTO lit_vpl VALUES ("PS84_9","020_84_9","PSA","84","9","9","Pažvelk, o Dieve, į mūsų skydą! Ir pažiūrėk į savo pateptojo veidą! ");
INSERT INTO lit_vpl VALUES ("PS84_10","020_84_10","PSA","84","10","10","Juk viena diena tavo kiemuose yra geresnė už tūkstantį kitur. Verčiau pasirinkčiau būti durininkas savo Dievo namuose, negu gyventi nedorybės palapinėse. ");
INSERT INTO lit_vpl VALUES ("PS84_11","020_84_11","PSA","84","11","11","Nes VIEŠPATS Dievas yra saulė ir skydas; VIEŠPATS teikia malonę ir šlovę. Jis nesulaiko gero nuo tų, kurie vaikščioja vientisumo dorybėje. ");
INSERT INTO lit_vpl VALUES ("PS84_12","020_84_12","PSA","84","12","12","O kareivijų VIEŠPATIE, koks didžiai palaimintas žmogus, kuris pasitiki tavimi! ");
INSERT INTO lit_vpl VALUES ("PS85_6","020_85_6","PSA","85","6","6","Ar tik ne tu dar kartą atgaivinsi mus, kad tavo tauta džiaugtųsi tavimi? ");
INSERT INTO lit_vpl VALUES ("PS85_8","020_85_8","PSA","85","8","8","Tegul aš klausysiu, ką kalba VIEŠPATS Dievas, nes jis žada ramybę savo tautai, savo šventiesiems; bet jie tegul nesigręžia į kvailystę! ");
INSERT INTO lit_vpl VALUES ("PS85_10","020_85_10","PSA","85","10","10","Gailestingumas ir tiesa susitiko, teisumas ir taika pasibučiavo. ");
INSERT INTO lit_vpl VALUES ("PS85_12","020_85_12","PSA","85","12","12","Taip, VIEŠPATS duos gera, ir mūsų šalis duos savo derlių. ");
INSERT INTO lit_vpl VALUES ("PS86_1","020_86_1","PSA","86","1","1","Dovydo malda. Palenk, o VIEŠPATIE, savo ausį, išklausyk mane, nes aš prispaustas ir vargingas. ");
INSERT INTO lit_vpl VALUES ("PS86_5","020_86_5","PSA","86","5","5","Nes tu, Viešpatie, esi geras ir nusiteikęs atleisti, kupinas gailestingumo visiems, kurie tavęs šaukiasi. ");
INSERT INTO lit_vpl VALUES ("PS86_11","020_86_11","PSA","86","11","11","Pamokyk mane, VIEŠPATIE, savo kelio; aš vaikščiosiu tavo tiesoje; suvienyk mano širdį, kad bijotų tavo vardo. ");
INSERT INTO lit_vpl VALUES ("PS86_13","020_86_13","PSA","86","13","13","Nes tavo gailestingumas yra man didelis; tu net išgelbėjai mano sielą iš giliausio pragaro. ");
INSERT INTO lit_vpl VALUES ("PS87_3","020_87_3","PSA","87","3","3","Apie tave kalba šlovingų dalykų, o Dievo mieste! Sela. ");
INSERT INTO lit_vpl VALUES ("PS89_14","020_89_14","PSA","89","14","14","Teisumas ir teisingumas yra tavo sosto įtvirtinta buveinė; gailestingumas ir tiesa eina tavo veido priešakyje. ");
INSERT INTO lit_vpl VALUES ("PS89_15","020_89_15","PSA","89","15","15","Kokia didžiai palaiminta yra tauta, kuri pažįsta džiūgavimo šauksmą, o VIEŠPATIE, – jie vaikščios tavo veido šviesoje. ");
INSERT INTO lit_vpl VALUES ("PS89_16","020_89_16","PSA","89","16","16","Visą dieną jie džiūgauja dėl tavo vardo, ir tavo teisumu jie išaukštinti. ");
INSERT INTO lit_vpl VALUES ("PS89_19","020_89_19","PSA","89","19","19","Tada tu regėjime kalbėjai savo dievotiesiems ir pasakei: „Aš suteikiau pagalbą tam tikram karžygiui, išaukštinau išrinktąjį iš tautos. ");
INSERT INTO lit_vpl VALUES ("PS89_34","020_89_34","PSA","89","34","34","Aš nelaužysiu savo sandoros ir nepakeisiu to, kas išėjo iš mano lūpų. ");
INSERT INTO lit_vpl VALUES ("PS89_48","020_89_48","PSA","89","48","48","Kuris žmogus gali gyventi ir nepatirti mirties?! Argi jis išgelbės savo sielą iš kapo rankos? Sela. ");
INSERT INTO lit_vpl VALUES ("PS90_1","020_90_1","PSA","90","1","1","Dievo vyro Mozės malda. Viešpatie, tu esi mūsų buveinė per kartų kartas. ");
INSERT INTO lit_vpl VALUES ("PS90_2","020_90_2","PSA","90","2","2","Prieš gimstant kalnams ir prieš tau gimdant žemę bei pasaulį, nuo amžinybės iki amžinybės tu esi Dievas. ");
INSERT INTO lit_vpl VALUES ("PS90_8","020_90_8","PSA","90","8","8","Tu statei mūsų neteisybes prieš save, savo veido šviesoje mūsų slaptas nuodėmes. ");
INSERT INTO lit_vpl VALUES ("PS90_9","020_90_9","PSA","90","9","9","Nes visos mūsų dienos praslenka tau rūstaujant; mes eikvojame savo metus kaip atodūsį. ");
INSERT INTO lit_vpl VALUES ("PS90_12","020_90_12","PSA","90","12","12","Taigi pamokyk mus skaičiuoti savo dienas, kad priartintume savo širdis prie išminties. ");
INSERT INTO lit_vpl VALUES ("PS90_16","020_90_16","PSA","90","16","16","Tebūna matoma tavo tarnams tavo veikla ir jų vaikams tavo šlovė! ");
INSERT INTO lit_vpl VALUES ("PS90_17","020_90_17","PSA","90","17","17","Ir tegul VIEŠPATIES, mūsų Dievo, pasigėrėjimas būna ant mūsų; ir mūsų labui padaryk nepajudinamą mūsų rankų darbą; taip, padaryk nepajudinamą mūsų rankų darbą. ");
INSERT INTO lit_vpl VALUES ("PS91_1","020_91_1","PSA","91","1","1","Kas gyvena Aukščiausiojo slaptavietėje, tas pasiliks Visagalio šešėlyje. ");
INSERT INTO lit_vpl VALUES ("PS91_2","020_91_2","PSA","91","2","2","Aš sakysiu VIEŠPAČIUI: „Mano prieglauda ir mano tvirtove, mano Dieve! Pasitikiu juo.“ ");
INSERT INTO lit_vpl VALUES ("PS91_4","020_91_4","PSA","91","4","4","Savo plunksnomis jis uždengs tave ir po jo sparnais turėsi prieglaudą. Jo tiesa yra didysis skydas ir apskritasis skydas. ");
INSERT INTO lit_vpl VALUES ("PS91_11","020_91_11","PSA","91","11","11","Nes jis savo angelams įsakys apie tave, kad saugotų tave visuose tavo keliuose. ");
INSERT INTO lit_vpl VALUES ("PS91_12","020_91_12","PSA","91","12","12","Ant rankų jie nešios tave, kad neužsigautum kojos į akmenį. ");
INSERT INTO lit_vpl VALUES ("PS92_1","020_92_1","PSA","92","1","1","Psalmė, giesmė šabo dienai. Gera dėkoti VIEŠPAČIUI ir giedoti gyrių tavo vardui, o Aukščiausiasis, ");
INSERT INTO lit_vpl VALUES ("PS92_2","020_92_2","PSA","92","2","2","skelbti rytmetį tavo mielaširdystę, kas naktį tavo ištikimybę ");
INSERT INTO lit_vpl VALUES ("PS92_3","020_92_3","PSA","92","3","3","dešimčiastygiu instrumentu ir arfa, lyros rimtu garsu. ");
INSERT INTO lit_vpl VALUES ("PS92_4","020_92_4","PSA","92","4","4","Nes tu, o VIEŠPATIE, pradžiuginai mane savo veikla, dėl tavo rankų darbų aš krykštauju. ");
INSERT INTO lit_vpl VALUES ("PS92_12","020_92_12","PSA","92","12","12","Teisusis klestės kaip palmė, jis augs kaip kedras Libane. ");
INSERT INTO lit_vpl VALUES ("PS93_2","020_93_2","PSA","93","2","2","Nuo senovės įtvirtintas tavo sostas, nuo amžinybės tu valdai. ");
INSERT INTO lit_vpl VALUES ("PS93_4","020_93_4","PSA","93","4","4","VIEŠPATS aukštybėje yra galingesnis už gausių vandenų griausmą, už galingas jūros bangas! ");
INSERT INTO lit_vpl VALUES ("PS93_5","020_93_5","PSA","93","5","5","Tavo liudijimai labai patikimi; tavo namams, VIEŠPATIE, šventumas pritinka visados. ");
INSERT INTO lit_vpl VALUES ("PS94_11","020_94_11","PSA","94","11","11","VIEŠPATS žino žmonių mintis, kad jos yra tuštybė. ");
INSERT INTO lit_vpl VALUES ("PS94_14","020_94_14","PSA","94","14","14","Juk VIEŠPATS neatstums savo tautos, ir savo veldinio nepaliks. ");
INSERT INTO lit_vpl VALUES ("PS94_18","020_94_18","PSA","94","18","18","Kai sakiau: „Slysta mano koja“, – tavo gailestingumas, VIEŠPATIE, palaikė mane. ");
INSERT INTO lit_vpl VALUES ("PS95_1","020_95_1","PSA","95","1","1","Ateikite, džiaugsmingai šūkaukime VIEŠPAČIUI, kelkime džiaugsmingą skambų garsą mūsų išgelbėjimo Uolai! ");
INSERT INTO lit_vpl VALUES ("PS95_2","020_95_2","PSA","95","2","2","Įeikime jo akivaizdon su padėka! Psalmėmis kelkime jam džiaugsmingą skambų garsą! ");
INSERT INTO lit_vpl VALUES ("PS95_3","020_95_3","PSA","95","3","3","Nes VIEŠPATS yra didysis Dievas ir didysis Karalius viršum visų dievų. ");
INSERT INTO lit_vpl VALUES ("PS95_4","020_95_4","PSA","95","4","4","Jo rankoje yra žemės gelmės; be to, kalnų viršūnės priklauso jam. ");
INSERT INTO lit_vpl VALUES ("PS95_5","020_95_5","PSA","95","5","5","Jo yra jūra – jis ją padarė – ir sausumą supavidalino jo rankos. ");
INSERT INTO lit_vpl VALUES ("PS95_6","020_95_6","PSA","95","6","6","Ateikite, garbinkime ir nusilenkime; klaupkimės prieš VIEŠPATĮ, mūsų Kūrėją. ");
INSERT INTO lit_vpl VALUES ("PS95_7","020_95_7","PSA","95","7","7","Nes jis yra mūsų Dievas, o mes – jo ganyklos tauta bei jo rankos ganomos avys. Jeigu šiandien klausytumėtės jo balso, ");
INSERT INTO lit_vpl VALUES ("PS95_8","020_95_8","PSA","95","8","8","neužkietinkite savo širdžių kaip maištavime, kaip gundymo dieną dykumoje, ");
INSERT INTO lit_vpl VALUES ("PS95_9","020_95_9","PSA","95","9","9","kur jūsų protėviai gundė mane, bandė mane, nors buvo matę mano darbą! ");
INSERT INTO lit_vpl VALUES ("PS96_2","020_96_2","PSA","96","2","2","Giedokite VIEŠPAČIUI, laiminkite jo vardą, dieną iš dienos skelbkite jo išgelbėjimą. ");
INSERT INTO lit_vpl VALUES ("PS96_5","020_96_5","PSA","96","5","5","Nes visi tautų dievai yra stabai, bet VIEŠPATS sukūrė dangus. ");
INSERT INTO lit_vpl VALUES ("PS96_6","020_96_6","PSA","96","6","6","Didybė ir šlovė yra jo priešakyje, galybė ir grožybė yra jo šventovėje. ");
INSERT INTO lit_vpl VALUES ("PS96_10","020_96_10","PSA","96","10","10","Sakykite tarp tautų, kad VIEŠPATS karaliauja; ir nepajudinamai bus įtvirtintas pasaulis; jis teis tautas teisingai. ");
INSERT INTO lit_vpl VALUES ("PS97_10","020_97_10","PSA","97","10","10","Jūs, kurie mylite VIEŠPATĮ, nekęskite blogio; jis apsaugo savo šventųjų sielas, iš nedorėlių rankos juos išvaduoja. ");
INSERT INTO lit_vpl VALUES ("PS97_11","020_97_11","PSA","97","11","11","Šviesa sėjama teisiajam ir džiaugsmas – tiesiaširdžiui. ");
INSERT INTO lit_vpl VALUES ("PS97_12","020_97_12","PSA","97","12","12","Džiūgaukite, teisieji, VIEŠPAČIU, ir prisimindami jo šventumą reikškite dėkingumą. ");
INSERT INTO lit_vpl VALUES ("PS98_1","020_98_1","PSA","98","1","1","Psalmė. Giedokite VIEŠPAČIUI naują giesmę, nes jis padarė nuostabių dalykų! Jo dešinė ir jo šventoji ranka jam laimėjo pergalę. ");
INSERT INTO lit_vpl VALUES ("PS98_3","020_98_3","PSA","98","3","3","Jis atsiminė savo gailestingumą ir savo ištikimybę Izraelio namams; visi žemės pakraščiai pamatė mūsų Dievo išgelbėjimą. ");
INSERT INTO lit_vpl VALUES ("PS98_8","020_98_8","PSA","98","8","8","Teploja rankomis upės, kartu tekrykštauja kalnai ");
INSERT INTO lit_vpl VALUES ("PS98_9","020_98_9","PSA","98","9","9","VIEŠPATIES akivaizdoje, nes jis ateina žemės teisti! Jis teis pasaulį vadovaudamasis teisumu ir tautas vadovaudamasis lygiateisiškumu. ");
INSERT INTO lit_vpl VALUES ("PS99_8","020_99_8","PSA","99","8","8","O VIEŠPATIE, mūsų Dieve, tu jiems atsakei; jiems buvai atleidžiantis Dievas, nors ir keršytojas už jų veikas. ");
INSERT INTO lit_vpl VALUES ("PS100_1","020_100_1","PSA","100","1","1","Gyriaus psalmė. O visos šalys, kelkite džiaugsmingą skambų garsą VIEŠPAČIUI! ");
INSERT INTO lit_vpl VALUES ("PS100_2","020_100_2","PSA","100","2","2","Tarnaukite VIEŠPAČIUI su džiaugsmu! Įeikite jo akivaizdon su krykštavimu! ");
INSERT INTO lit_vpl VALUES ("PS100_3","020_100_3","PSA","100","3","3","Žinokite, kad VIEŠPATS, jis yra Dievas! Padarė mus jis, o ne mes patys; mes esame jo tauta ir jo ganyklos avys. ");
INSERT INTO lit_vpl VALUES ("PS100_4","020_100_4","PSA","100","4","4","Įeikite pro jo vartus su dėkojimu, į jo kiemus su gyriumi; dėkokite jam, laiminkite jo vardą. ");
INSERT INTO lit_vpl VALUES ("PS100_5","020_100_5","PSA","100","5","5","Nes VIEŠPATS yra geras, jo gailestingumas yra amžinas, ir jo tiesa išlieka kartų kartoms. ");
INSERT INTO lit_vpl VALUES ("PS101_1","020_101_1","PSA","101","1","1","Dovydo psalmė. Apie gailestingumą ir teisingumą giedosiu; tau, o VIEŠPATIE, kelsiu giesmę. ");
INSERT INTO lit_vpl VALUES ("PS101_3","020_101_3","PSA","101","3","3","Aš nestatysiu sau prieš akis jokio nedoro dalyko; nekenčiu veiklos tų, kurie nukrypsta į šalį; tai nepagaus manęs! ");
INSERT INTO lit_vpl VALUES ("PS102_11","020_102_11","PSA","102","11","11","Mano dienos – kaip ištįsęs šešėlis, aš pats gi lyg žolė vystu. ");
INSERT INTO lit_vpl VALUES ("PS102_12","020_102_12","PSA","102","12","12","Bet tu, VIEŠPATIE, pasiliksi per amžius ir tavo atminimas per visas kartas. ");
INSERT INTO lit_vpl VALUES ("PS102_17","020_102_17","PSA","102","17","17","Jis atsižvelgs į nuskurdėlių maldą ir nepaniekins jų maldos. ");
INSERT INTO lit_vpl VALUES ("PS102_26","020_102_26","PSA","102","26","26","Jie praeis, bet tu pasiliksi; taip, jie visi susidėvės kaip drabužis; kaip apdarą tu juos pakeisi, ir jie bus pakeisti, ");
INSERT INTO lit_vpl VALUES ("PS102_27","020_102_27","PSA","102","27","27","bet tu esi toks pat, ir tavo metai nesibaigs. ");
INSERT INTO lit_vpl VALUES ("PS103_1","020_103_1","PSA","103","1","1","Dovydo. O mano siela, laimink VIEŠPATĮ, ir visa, kas manyje, laimink jo šventą vardą! ");
INSERT INTO lit_vpl VALUES ("PS103_2","020_103_2","PSA","103","2","2","O mano siela, laimink VIEŠPATĮ ir nepamiršk visų jo geradarysčių! ");
INSERT INTO lit_vpl VALUES ("PS103_3","020_103_3","PSA","103","3","3","Jis – tas, kuris atleidžia visą tavo kaltę, kuris gydo visas tavo ligas, ");
INSERT INTO lit_vpl VALUES ("PS103_4","020_103_4","PSA","103","4","4","kuris atperka tavo gyvybę iš pražūties, kuris apgaubia tave gailestingumu ir apsčiu meilumu, ");
INSERT INTO lit_vpl VALUES ("PS103_8","020_103_8","PSA","103","8","8","Gailestingas ir maloningas yra VIEŠPATS, lėtas pykti ir kupinas gailestingumo. ");
INSERT INTO lit_vpl VALUES ("PS103_12","020_103_12","PSA","103","12","12","Kaip toli rytai yra nuo vakarų, taip jis nuo mūsų atitolino mūsų nusižengimus. ");
INSERT INTO lit_vpl VALUES ("PS103_13","020_103_13","PSA","103","13","13","Kaip tėvas gailisi savo vaikų, taip VIEŠPATS gailisi tų, kurie jo bijo. ");
INSERT INTO lit_vpl VALUES ("PS103_15","020_103_15","PSA","103","15","15","Mirtingasis – jo dienos panašios į žolę, jis klesti taip, kaip lauko gėlė: ");
INSERT INTO lit_vpl VALUES ("PS103_16","020_103_16","PSA","103","16","16","juk vėjas virš jos vos pučia, ir jos jau nebėra, ir jos vieta daugiau jos nebepažins. ");
INSERT INTO lit_vpl VALUES ("PS103_17","020_103_17","PSA","103","17","17","Bet VIEŠPATIES gailestingumas būna nuo amžinybės iki amžinybės ant tų, kurie jo bijo, ir jo teisumas vaikų vaikams – ");
INSERT INTO lit_vpl VALUES ("PS103_20","020_103_20","PSA","103","20","20","Laiminkite VIEŠPATĮ, jo angelai, jūs veiksmingi galingieji, kurie vykdote jo žodį, klausydami jo žodžio balso. ");
INSERT INTO lit_vpl VALUES ("PS103_21","020_103_21","PSA","103","21","21","Laiminkite VIEŠPATĮ, jūs, visos jo kareivijos, jūs, jo tarnai, kurie vykdote jo valią. ");
INSERT INTO lit_vpl VALUES ("PS104_6","020_104_6","PSA","104","6","6","Tu ją apdengei gelme kaip drabužiu, vandenys stovėjo virš kalnų. ");
INSERT INTO lit_vpl VALUES ("PS104_7","020_104_7","PSA","104","7","7","Tau barantis jie bėgo, nuo tavo griaustinio balso jie išskubėjo. ");
INSERT INTO lit_vpl VALUES ("PS104_8","020_104_8","PSA","104","8","8","Kalnai pakilo, nusileido slėniai į vietą, į kurią jiems pastatei pamatą. ");
INSERT INTO lit_vpl VALUES ("PS104_9","020_104_9","PSA","104","9","9","Tu nustatei ribą: jie negali peržengti, jie nebegali sugrįžti žemės apdengti. ");
INSERT INTO lit_vpl VALUES ("PS104_19","020_104_19","PSA","104","19","19","Jis padarė mėnulį laikams nustatyti; saulė žino, kada nusileisti. ");
INSERT INTO lit_vpl VALUES ("PS104_24","020_104_24","PSA","104","24","24","Viešpatie, kokia daugybė tavo darbų! Savo išmintimi juos padarei! Tavo kūrinių pilna žemė! ");
INSERT INTO lit_vpl VALUES ("PS104_31","020_104_31","PSA","104","31","31","VIEŠPATIES šlovė pasiliks per amžius, VIEŠPATS džiaugsis savo darbais. ");
INSERT INTO lit_vpl VALUES ("PS104_33","020_104_33","PSA","104","33","33","Giedosiu VIEŠPAČIUI, kol gyvas būsiu, giedosiu gyrių savo Dievui, kol gyvuos manasis aš. ");
INSERT INTO lit_vpl VALUES ("PS104_34","020_104_34","PSA","104","34","34","Tebūna malonus mano apmąstymas apie jį, aš džiaugsiuosi VIEŠPAČIU. ");
INSERT INTO lit_vpl VALUES ("PS105_1","020_105_1","PSA","105","1","1","Dėkokite VIEŠPAČIUI, šaukitės jo vardo, skelbkite tautose jo darbus! ");
INSERT INTO lit_vpl VALUES ("PS105_2","020_105_2","PSA","105","2","2","Giedokite jam, giedokite jam psalmes; apsakykite visus jo stebuklingus darbus. ");
INSERT INTO lit_vpl VALUES ("PS105_40","020_105_40","PSA","105","40","40","Jie prašė, ir jis atsiuntė putpelių ir pasotino juos duona iš dangaus. ");
INSERT INTO lit_vpl VALUES ("PS105_41","020_105_41","PSA","105","41","41","Jis atvėrė uolą, ir ištryško gausus vanduo, tekėjo per sausas vietoves lyg upė. ");
INSERT INTO lit_vpl VALUES ("PS105_42","020_105_42","PSA","105","42","42","Nes jis atsiminė savo šventąjį pažadą ir savo tarną Abraomą. ");
INSERT INTO lit_vpl VALUES ("PS106_1","020_106_1","PSA","106","1","1","Girkite VIEŠPATĮ! Dėkokite VIEŠPAČIUI, nes jis geras, nes jo gailestingumas išlieka per amžius! ");
INSERT INTO lit_vpl VALUES ("PS106_4","020_106_4","PSA","106","4","4","Atsimink mane, o VIEŠPATIE, rodydamas palankumą savo tautai, atkreipk dėmesį į mane įvykdydamas savo išgelbėjimą, ");
INSERT INTO lit_vpl VALUES ("PS106_5","020_106_5","PSA","106","5","5","kad matyčiau tavo išrinktųjų gerovę, kad džiaugčiausi tavo tautos džiaugsmu, kad didžiuočiausi kartu su tavo paveldu. ");
INSERT INTO lit_vpl VALUES ("PS106_6","020_106_6","PSA","106","6","6","Mes nusidėjome su savo tėvais, nusikaltome, nedorai elgėmės. ");
INSERT INTO lit_vpl VALUES ("PS106_24","020_106_24","PSA","106","24","24","Paskui jie paniekino puikųjį kraštą, netikėjo jo žodžiu, ");
INSERT INTO lit_vpl VALUES ("PS106_25","020_106_25","PSA","106","25","25","bet murmėjo savo palapinėse, neklausydami VIEŠPATIES balso. ");
INSERT INTO lit_vpl VALUES ("PS106_45","020_106_45","PSA","106","45","45","Jų labui jis atsiminė savo sandorą ir atšaukė baudimą pagal savo gailestingumų gausybę. ");
INSERT INTO lit_vpl VALUES ("PS107_1","020_107_1","PSA","107","1","1","Dėkokite VIEŠPAČIUI, nes jis geras, nes jo gailestingumas išlieka per amžius! ");
INSERT INTO lit_vpl VALUES ("PS107_8","020_107_8","PSA","107","8","8","Tegiria VIEŠPATĮ už jo gailestingumą ir už jo nuostabius darbus žmonių palikuonims, ");
INSERT INTO lit_vpl VALUES ("PS107_9","020_107_9","PSA","107","9","9","nes jis patenkina ištroškusią sielą ir išalkusią sielą pripildo gero! ");
INSERT INTO lit_vpl VALUES ("PS107_20","020_107_20","PSA","107","20","20","Jis siuntė savo žodį ir išgydė juos, ir iš didžio sukritimo juos išgelbėjo. ");
INSERT INTO lit_vpl VALUES ("PS107_30","020_107_30","PSA","107","30","30","Tada jie džiaugėsi, kad jos nurimo, ir jis juos nuvedė į jų geidžiamą uostą. ");
INSERT INTO lit_vpl VALUES ("PS108_4","020_108_4","PSA","108","4","4","Nes tavo gailestingumas toks didelis, kad yra aukščiau dangų, ir tavo tiesa siekia debesis. ");
INSERT INTO lit_vpl VALUES ("PS108_13","020_108_13","PSA","108","13","13","Su Dievu mes narsiai nuveiksime, nes jis yra tas, kuris sutryps mūsų priešus. ");
INSERT INTO lit_vpl VALUES ("PS109_31","020_109_31","PSA","109","31","31","Nes jis stovės vargšo dešinėje, kad jį išgelbėtų iš tų, kurie smerkia jo sielą. ");
INSERT INTO lit_vpl VALUES ("PS110_3","020_110_3","PSA","110","3","3","Tavo galybės dieną tavo tauta noriai pasisiūlys nuo ryto išaušimo turėdama apsčią šventumo grožybę; tau skirta tavo jaunystės rasa. ");
INSERT INTO lit_vpl VALUES ("PS111_5","020_111_5","PSA","111","5","5","Jis davė maisto bijantiems jo; jis per amžius atsimins savo sandorą. ");
INSERT INTO lit_vpl VALUES ("PS111_7","020_111_7","PSA","111","7","7","Jo rankų darbai – tiesa ir teisingumas, visi jo nurodymai – patikimi. ");
INSERT INTO lit_vpl VALUES ("PS111_10","020_111_10","PSA","111","10","10","VIEŠPATIES baimė – išminties pradžia; puikią įžvalgą turi visi, kurie vykdo jo nurodymus. Jo gyrius patvers amžinai. ");
INSERT INTO lit_vpl VALUES ("PS112_1","020_112_1","PSA","112","1","1","Girkite VIEŠPATĮ! Didžiai palaimintas žmogus, kuris bijo VIEŠPATIES, kuris labai gėrisi jo įsakymais. ");
INSERT INTO lit_vpl VALUES ("PS112_7","020_112_7","PSA","112","7","7","Jis nebijo blogos žinios; ב bėt tvirta jo širdis, pasitikinti VIEŠPAČIU. ");
INSERT INTO lit_vpl VALUES ("PS113_1","020_113_1","PSA","113","1","1","Girkite VIEŠPATĮ! Girkite, o VIEŠPATIES tarnai, girkite VIEŠPATIES vardą! ");
INSERT INTO lit_vpl VALUES ("PS115_1","020_115_1","PSA","115","1","1","Ne mums, VIEŠPATIE, ne mums, bet savo vardui teik šlovę dėl savo gailestingumo, dėl savo ištikimybės. ");
INSERT INTO lit_vpl VALUES ("PS115_3","020_115_3","PSA","115","3","3","Bet mūsų Dievas yra danguose; jis daro visa, kas jam patinka. ");
INSERT INTO lit_vpl VALUES ("PS115_11","020_115_11","PSA","115","11","11","Jūs, kurie bijote VIEŠPATIES, pasitikėkite VIEŠPAČIU! Jis yra pagalba ir skydas tokiems. ");
INSERT INTO lit_vpl VALUES ("PS115_13","020_115_13","PSA","115","13","13","Jis palaimins tuos, kurie bijo VIEŠPATIES, ir mažus, ir didelius. ");
INSERT INTO lit_vpl VALUES ("PS116_5","020_116_5","PSA","116","5","5","VIEŠPATS yra maloningas ir teisus, mūsų Dievas gailestingas. ");
INSERT INTO lit_vpl VALUES ("PS116_6","020_116_6","PSA","116","6","6","VIEŠPATS apsaugo paprastuosius: buvau susmukdytas, ir jis mane išgelbėjo. ");
INSERT INTO lit_vpl VALUES ("PS116_7","020_116_7","PSA","116","7","7","Sugrįžk, mano siela, į savo poilsį, nes VIEŠPATS dosniai padarė tau gera! ");
INSERT INTO lit_vpl VALUES ("PS116_8","020_116_8","PSA","116","8","8","Nes tu išgelbėjai mano sielą nuo mirties, mano akis nuo ašarų, mano kojas nuo suklupimo. ");
INSERT INTO lit_vpl VALUES ("PS116_12","020_116_12","PSA","116","12","12","Kuo atlyginsiu VIEŠPAČIUI už visas jo geradarystes man? ");
INSERT INTO lit_vpl VALUES ("PS116_15","020_116_15","PSA","116","15","15","VIEŠPATIES akyse jo šventųjų mirtis yra brangiai vertinama. ");
INSERT INTO lit_vpl VALUES ("PS116_17","020_116_17","PSA","116","17","17","Tau aukosiu padėkos auką ir šauksiuosi VIEŠPATIES vardo. ");
INSERT INTO lit_vpl VALUES ("PS117_1","020_117_1","PSA","117","1","1","Girkite VIEŠPATĮ, visos tautos! Išgarsinkite jį, visi žmonės! ");
INSERT INTO lit_vpl VALUES ("PS117_2","020_117_2","PSA","117","2","2","Nes Jo gailestingas gerumas mums yra didis ir VIEŠPATIES tiesa yra amžina. Girkite VIEŠPATĮ! ");
INSERT INTO lit_vpl VALUES ("PS118_1","020_118_1","PSA","118","1","1","Dėkokite VIEŠPAČIUI, nes jis geras, nes jo gailestingumas išlieka per amžius! ");
INSERT INTO lit_vpl VALUES ("PS118_6","020_118_6","PSA","118","6","6","VIEŠPATS yra už mane – aš nebijosiu! Ką gali man padaryti žmogus? ");
INSERT INTO lit_vpl VALUES ("PS118_21","020_118_21","PSA","118","21","21","Dėkosiu tau, nes mane išklausei ir man tapai išgelbėjimu. ");
INSERT INTO lit_vpl VALUES ("PS118_24","020_118_24","PSA","118","24","24","Šita yra diena, kurią VIEŠPATS padarė; ja džiūgaukime ir linksminkimės. ");
INSERT INTO lit_vpl VALUES ("PS118_25","020_118_25","PSA","118","25","25","O VIEŠPATIE, prašau tave, mus išgelbėk dabar! Meldžiu tave, O VIEŠPATIE, prašau tave, suteik mums sėkmę dabar! ");
INSERT INTO lit_vpl VALUES ("PS118_26","020_118_26","PSA","118","26","26","Palaimintas, kuris ateina VIEŠPATIES vardu! Mes laiminome jus iš VIEŠPATIES namų. ");
INSERT INTO lit_vpl VALUES ("PS119_1","020_119_1","PSA","119","1","1","Kokie didžiai palaiminti yra nepeiktino kelio žmonės, kurie vaikščioja pagal VIEŠPATIES įstatymą! ");
INSERT INTO lit_vpl VALUES ("PS119_2","020_119_2","PSA","119","2","2","Kokie didžiai palaiminti, kurie laikosi jo liudijimų, visa širdimi jo ieško; ");
INSERT INTO lit_vpl VALUES ("PS119_3","020_119_3","PSA","119","3","3","jie ir nedaro neteisybės; jie vaikščioja jo keliais. ");
INSERT INTO lit_vpl VALUES ("PS119_4","020_119_4","PSA","119","4","4","Tu pats įsakei stropiai vykdyti tavo nurodymus. ");
INSERT INTO lit_vpl VALUES ("PS119_5","020_119_5","PSA","119","5","5","O, kad mano keliai būtų sutvirtinti tavo nuostatų laikytis! ");
INSERT INTO lit_vpl VALUES ("PS119_6","020_119_6","PSA","119","6","6","Tada, paisydamas visų tavo įsakymų, nebūsiu sugėdintas. ");
INSERT INTO lit_vpl VALUES ("PS119_7","020_119_7","PSA","119","7","7","Girsiu tave tiesia širdimi, mokydamasis tavo teisingų nuosprendžių. ");
INSERT INTO lit_vpl VALUES ("PS119_8","020_119_8","PSA","119","8","8","Tavo nuostatų laikysiuosi – jokių būdu neapleisk manęs! ");
INSERT INTO lit_vpl VALUES ("PS119_9","020_119_9","PSA","119","9","9","Kaip jaunuolis savo gyvenimo kelią padarys tyrą? Atidžiai budėdamas pagal tavo žodį. ");
INSERT INTO lit_vpl VALUES ("PS119_10","020_119_10","PSA","119","10","10","Visa širdimi tavęs ieškojau, – neleisk man nuklysti nuo tavo įsakymų. ");
INSERT INTO lit_vpl VALUES ("PS119_11","020_119_11","PSA","119","11","11","Tavo žodį paslėpiau savo širdyje, kad tau nenusidėčiau. ");
INSERT INTO lit_vpl VALUES ("PS119_12","020_119_12","PSA","119","12","12","Tu esi palaimintas, o VIEŠPATIE! Mokyk mane savo nuostatų. ");
INSERT INTO lit_vpl VALUES ("PS119_13","020_119_13","PSA","119","13","13","Savo lūpomis skelbiau visus tavo burnos nuosprendžius. ");
INSERT INTO lit_vpl VALUES ("PS119_14","020_119_14","PSA","119","14","14","Džiaugiausi tavo liudijimų keliu kaip visokiais turtais. ");
INSERT INTO lit_vpl VALUES ("PS119_15","020_119_15","PSA","119","15","15","Mąstysiu apie tavo nurodymus ir paisysiu tavo nustatytų kelių. ");
INSERT INTO lit_vpl VALUES ("PS119_16","020_119_16","PSA","119","16","16","Tavo nuostatais gėrėsiuosi, nepamiršiu tavo žodžio. ");
INSERT INTO lit_vpl VALUES ("PS119_17","020_119_17","PSA","119","17","17","Dosniai daryk man, savo tarnui, gera, kad gyvenčiau ir laikyčiausi tavo žodžio. ");
INSERT INTO lit_vpl VALUES ("PS119_18","020_119_18","PSA","119","18","18","Atverk man akis, kad nuostabius dalykus iš tavo įstatymo įsižiūrėčiau! ");
INSERT INTO lit_vpl VALUES ("PS119_19","020_119_19","PSA","119","19","19","Aš svetimšalis žemėje, – neslėpk nuo manęs savo įsakymų. ");
INSERT INTO lit_vpl VALUES ("PS119_20","020_119_20","PSA","119","20","20","Tavo nuosprendžių ilgesys visada prispaudžia mano sielą. ");
INSERT INTO lit_vpl VALUES ("PS119_21","020_119_21","PSA","119","21","21","Tu subarei išdidėlius – prakeiktuosius, kurie nuklysta nuo tavo įsakymų. ");
INSERT INTO lit_vpl VALUES ("PS119_22","020_119_22","PSA","119","22","22","Pašalink nuo manęs pajuoką ir panieką, nes laikiausi tavo liudijimų. ");
INSERT INTO lit_vpl VALUES ("PS119_23","020_119_23","PSA","119","23","23","Nors kunigaikščiai susėdę tarėsi prieš mane, tavo tarnas apmąstė tavo nuostatus. ");
INSERT INTO lit_vpl VALUES ("PS119_24","020_119_24","PSA","119","24","24","Be to, tavo liudijimai – mano didžiulis pasigėrėjimas, mano patarėjai. ");
INSERT INTO lit_vpl VALUES ("PS119_25","020_119_25","PSA","119","25","25","Mano siela prikimba prie dulkių – atgaivink mane pagal savo žodį. ");
INSERT INTO lit_vpl VALUES ("PS119_26","020_119_26","PSA","119","26","26","Tau papasakojau apie savo kelius, ir tu išklausei mane. Mokyk mane savo įstatų! ");
INSERT INTO lit_vpl VALUES ("PS119_27","020_119_27","PSA","119","27","27","Duok man suprasti tavo nurodymų kelią, ir aš vis kalbėsiu apie tavo nuostabius darbus. ");
INSERT INTO lit_vpl VALUES ("PS119_28","020_119_28","PSA","119","28","28","Mano siela smunka iš sielvarto; sustiprink mane pagal savo žodį. ");
INSERT INTO lit_vpl VALUES ("PS119_29","020_119_29","PSA","119","29","29","Melo kelią pašalink nuo manęs, ir maloningai suteik man savo įstatymą. ");
INSERT INTO lit_vpl VALUES ("PS119_30","020_119_30","PSA","119","30","30","Pasirinkau tiesos kelią; tavo nuosprendžius pasidėjau priešais save. ");
INSERT INTO lit_vpl VALUES ("PS119_31","020_119_31","PSA","119","31","31","Tvirtai laikausi tavo liudijimų; o VIEŠPATIE, nesugėdink manęs. ");
INSERT INTO lit_vpl VALUES ("PS119_32","020_119_32","PSA","119","32","32","Tavo įsakymų keliu bėgsiu, nes tu prapleti mano širdį. ");
INSERT INTO lit_vpl VALUES ("PS119_33","020_119_33","PSA","119","33","33","Mokyk mane, o VIEŠPATIE, savo nuostatų kelio, ir jo laikysiuosi iki galo. ");
INSERT INTO lit_vpl VALUES ("PS119_34","020_119_34","PSA","119","34","34","Daryk mane supratingą, kad tavo įstatymą saugočiau nepažeistą ir visa širdimi jo laikyčiausi. ");
INSERT INTO lit_vpl VALUES ("PS119_35","020_119_35","PSA","119","35","35","Vesk mane tavo įsakymų taku, nes juo gėriuosi. ");
INSERT INTO lit_vpl VALUES ("PS119_36","020_119_36","PSA","119","36","36","Palenk mano širdį į savo liudijimus, o ne į godumą. ");
INSERT INTO lit_vpl VALUES ("PS119_37","020_119_37","PSA","119","37","37","Nukreipk mano akis, kad nematytų tuštybių, savo kelyje suteik man gyvybingumą. ");
INSERT INTO lit_vpl VALUES ("PS119_38","020_119_38","PSA","119","38","38","Savo tarnui sutvirtink savo žodį, kuris puoselėja baimę tavęs. ");
INSERT INTO lit_vpl VALUES ("PS119_39","020_119_39","PSA","119","39","39","Nukreipk nuo manęs užgauliojimą, kurio bijausi, nes tavo nuosprendžiai yra geri. ");
INSERT INTO lit_vpl VALUES ("PS119_40","020_119_40","PSA","119","40","40","Štai aš esu troškęs tavo nurodymų, atgaivink mane vadovaudamasis savo teisumu! ");
INSERT INTO lit_vpl VALUES ("PS119_42","020_119_42","PSA","119","42","42","Tuomet turėsiu ką atsakyti tam, kuris kuriuo nors žodžiu priekaištauja man, nes pasitikiu tavo žodžiu. ");
INSERT INTO lit_vpl VALUES ("PS119_46","020_119_46","PSA","119","46","46","Be to, kalbėsiu apie tavo liudijimus karalių akivaizdoje ir nesigėdinsiu. ");
INSERT INTO lit_vpl VALUES ("PS119_47","020_119_47","PSA","119","47","47","Mėgausiuosi tavo įsakymais, kuriuos myliu. ");
INSERT INTO lit_vpl VALUES ("PS119_48","020_119_48","PSA","119","48","48","Taip pat pakelsiu rankas į tavo įsakymus, kuriuos esu mylėjęs, ir mąstysiu apie tavo įsakus. ");
INSERT INTO lit_vpl VALUES ("PS119_50","020_119_50","PSA","119","50","50","Tai mano paguoda mano varge, kad tavo žodis mane atgaivino. ");
INSERT INTO lit_vpl VALUES ("PS119_54","020_119_54","PSA","119","54","54","Tavo nuostatai man yra giesmės mano laikinosios gyvenimo vietos namuose. ");
INSERT INTO lit_vpl VALUES ("PS119_64","020_119_64","PSA","119","64","64","Tavo gailestingumo, VIEŠPATIE, pilna žemė; mokyk mane savo nuostatų. ");
INSERT INTO lit_vpl VALUES ("PS119_67","020_119_67","PSA","119","67","67","Prieš patirdamas prispaudimą, aš paklysdavau, bet dabar laikausi tavo žodžio. ");
INSERT INTO lit_vpl VALUES ("PS119_71","020_119_71","PSA","119","71","71","Gera man, kad buvau prispaustas, kad išmokčiau tavo nuostatų. ");
INSERT INTO lit_vpl VALUES ("PS119_77","020_119_77","PSA","119","77","77","Tepasiekia mane tavo apstus meilingumas, kad gyvenčiau, nes tavo įstatymas – mano didžiulis pasigėrėjimas! ");
INSERT INTO lit_vpl VALUES ("PS119_78","020_119_78","PSA","119","78","78","Tesusigėsta išdidėliai, nes jie per melą elgėsi su manimi iškreiptai; bet aš mąstysiu apie tavo nurodymus. ");
INSERT INTO lit_vpl VALUES ("PS119_80","020_119_80","PSA","119","80","80","Tegul mano širdis būna nepeiktinas tavo nuostatų atžvilgiu, kad nebūčiau sugėdintas. ");
INSERT INTO lit_vpl VALUES ("PS119_81","020_119_81","PSA","119","81","81","Mano siela ilgisi tavo išgelbėjimo, tavo žodžiu užtikrintai viliuosi. ");
INSERT INTO lit_vpl VALUES ("PS119_88","020_119_88","PSA","119","88","88","Pagal savo mielaširdystę atgaivink mane, kad vykdyčiau tavo burnos liudijimą. ");
INSERT INTO lit_vpl VALUES ("PS119_89","020_119_89","PSA","119","89","89","Per amžius, o VIEŠPATIE, tavo žodis įtvirtintas danguje. ");
INSERT INTO lit_vpl VALUES ("PS119_90","020_119_90","PSA","119","90","90","Per visas kartas tveria tavo ištikimybė; tu padėjai į vietą žemę, ir ji tebestovi. ");
INSERT INTO lit_vpl VALUES ("PS119_91","020_119_91","PSA","119","91","91","Jie šiandien tebstovi pagal tavo sprendimus, nes visi daiktai yra tavo tarnai. ");
INSERT INTO lit_vpl VALUES ("PS119_97","020_119_97","PSA","119","97","97","O, kaip aš myliu tavo Įstatymą! Mąstau apie jį visą dieną. ");
INSERT INTO lit_vpl VALUES ("PS119_99","020_119_99","PSA","119","99","99","Turiu daugiau išminties už visus savo mokytojus, nes apmąstau tavo liudijimus. ");
INSERT INTO lit_vpl VALUES ("PS119_103","020_119_103","PSA","119","103","103","Kokie saldūs tavo žodžiai mano gomuriui, saldesni už medų mano burnai! ");
INSERT INTO lit_vpl VALUES ("PS119_105","020_119_105","PSA","119","105","105","Tavo žodis yra žibintas mano kojoms ir šviesa mano takui. ");
INSERT INTO lit_vpl VALUES ("PS119_113","020_119_113","PSA","119","113","113","Nekenčiu tų, kurie daliniai pritaria tavo žodžiui, bet myliu tavo įstatymą. ");
INSERT INTO lit_vpl VALUES ("PS119_114","020_119_114","PSA","119","114","114","Tu esi mano slėptuvė ir skydas, užtikrintai viliuosi tavo žodžiu. ");
INSERT INTO lit_vpl VALUES ("PS119_116","020_119_116","PSA","119","116","116","Palaikyk mane pagal savo žodį, kad gyvenčiau; neleisk man gėdytis dėl mano vilties. ");
INSERT INTO lit_vpl VALUES ("PS119_117","020_119_117","PSA","119","117","117","Palaikyk mane ir būsiu saugus; ir nuolat atsižvelgsiu į tavo nuostatus. ");
INSERT INTO lit_vpl VALUES ("PS119_120","020_119_120","PSA","119","120","120","Mano kūnas dreba, bijodamas tavęs; ir aš bijau tavo nuosprendžių. ");
INSERT INTO lit_vpl VALUES ("PS119_123","020_119_123","PSA","119","123","123","Mano akys nyksta belaukdamos tavo išgelbėjimo ir tavo teisumo žodžio. ");
INSERT INTO lit_vpl VALUES ("PS119_124","020_119_124","PSA","119","124","124","Elkis su savo tarnu pagal savo gailestingumą ir mokyk mane savo nuostatų. ");
INSERT INTO lit_vpl VALUES ("PS119_128","020_119_128","PSA","119","128","128","Todėl visus tavo nurodymus dėl visų dalykų laikau teisingais, ir nekenčiu jokio melagingo kelio. ");
INSERT INTO lit_vpl VALUES ("PS119_130","020_119_130","PSA","119","130","130","Tavo žodžių atskleidimas apšviečia, doroviškai naiviems žmonėms suteikia supratimo. ");
INSERT INTO lit_vpl VALUES ("PS119_133","020_119_133","PSA","119","133","133","Sudėliok mano žingsnius savo žodžiu, ir neleisk jokiai nedorybei manęs užvaldyti. ");
INSERT INTO lit_vpl VALUES ("PS119_135","020_119_135","PSA","119","135","135","Tešviečia tavo veidas tavo tarnui, ir mane mokyk savo nuostatų. ");
INSERT INTO lit_vpl VALUES ("PS119_137","020_119_137","PSA","119","137","137","Teisus esi tu, VIEŠPATIE, ir tiesūs yra tavo nuosprendžiai. ");
INSERT INTO lit_vpl VALUES ("PS119_144","020_119_144","PSA","119","144","144","Tavo liudijimai yra teisingi per amžius. Duok man išmanymo, ir aš gyvensiu. ");
INSERT INTO lit_vpl VALUES ("PS119_148","020_119_148","PSA","119","148","148","Mano akys užbėga budėjimams už akių, kad mąstyčiau apie tavo žodį. ");
INSERT INTO lit_vpl VALUES ("PS119_152","020_119_152","PSA","119","152","152","Apie tavo liudijimus seniai žinau, kad tu amžiams juos nustatei. ");
INSERT INTO lit_vpl VALUES ("PS119_156","020_119_156","PSA","119","156","156","Daug yra tavo giliaširdiškų jausmų, o VIEŠPATIE; atgaivink mane pagal savo nuosprendžius. ");
INSERT INTO lit_vpl VALUES ("PS119_160","020_119_160","PSA","119","160","160","Tavo žodžio visuma yra tiesa, ir amžinas kiekvienas tavo teisingas nuosprendis. ");
INSERT INTO lit_vpl VALUES ("PS119_161","020_119_161","PSA","119","161","161","Kunigaikščiai persekiojo mane be priežasties, bet mano širdis drebėjo nuo tavo žodžių. ");
INSERT INTO lit_vpl VALUES ("PS119_162","020_119_162","PSA","119","162","162","Aš džiaugiuosi tavo žodžiu kaip tas, kuris randa didelį grobį. ");
INSERT INTO lit_vpl VALUES ("PS119_163","020_119_163","PSA","119","163","163","Nekenčiu ir bjauriuosi melu, bet tavo įstatymą myliu. ");
INSERT INTO lit_vpl VALUES ("PS119_164","020_119_164","PSA","119","164","164","Septynis kartus per dieną tave giriu už tavo teisingus sprendimus. ");
INSERT INTO lit_vpl VALUES ("PS119_165","020_119_165","PSA","119","165","165","Didelė ramybė atitenka tiems, kurie myli tavo įstatymą ir niekas negali jų suklupdyti. ");
INSERT INTO lit_vpl VALUES ("PS119_166","020_119_166","PSA","119","166","166","Aš laukiau viltingai tavo išgelbėjimo, VIEŠPATIE, ir tavo įsakymus vykdžiau. ");
INSERT INTO lit_vpl VALUES ("PS119_167","020_119_167","PSA","119","167","167","Mano siela laikėsi tavo liudijimų, ir juos labai labai myliu. ");
INSERT INTO lit_vpl VALUES ("PS119_168","020_119_168","PSA","119","168","168","Laikiausi tavo nurodymų ir tavo liudijimų, nes visi mano keliai yra tavo akivaizdoje. ");
INSERT INTO lit_vpl VALUES ("PS119_175","020_119_175","PSA","119","175","175","Atgaivink mano sielą ir ji girs tave, tavo nuosprendžiai tepadeda man. ");
INSERT INTO lit_vpl VALUES ("PS121_1","020_121_1","PSA","121","1","1","Giesmė užkopimui. Aš pakelsiu savo akis į kalnus. Iš kur ateina mano pagalba? ");
INSERT INTO lit_vpl VALUES ("PS121_2","020_121_2","PSA","121","2","2","Mano pagalba ateina iš VIEŠPATIES, kuris padarė dangų ir žemę. ");
INSERT INTO lit_vpl VALUES ("PS121_3","020_121_3","PSA","121","3","3","Jis neleis svyruoti tavo kojai; nesnaus tas, kuris tave saugo. ");
INSERT INTO lit_vpl VALUES ("PS121_4","020_121_4","PSA","121","4","4","Štai tas, kuris saugo Izraelį, nei snaus, nei miegos! ");
INSERT INTO lit_vpl VALUES ("PS121_5","020_121_5","PSA","121","5","5","VIEŠPATS yra tas, kuris saugo tave, prie tavo dešinės rankos yra VIEŠPATS – tavo ūksmė. ");
INSERT INTO lit_vpl VALUES ("PS121_6","020_121_6","PSA","121","6","6","Saulė nesmogs tavęs dieną, nė mėnulis naktį. ");
INSERT INTO lit_vpl VALUES ("PS121_7","020_121_7","PSA","121","7","7","VIEŠPATS saugos tave nuo viso blogio; jis saugos tavo sielą. ");
INSERT INTO lit_vpl VALUES ("PS121_8","020_121_8","PSA","121","8","8","VIEŠPATS saugos tavo išėjimą ir tavo įėjimą nuo dabar ir per amžius. ");
INSERT INTO lit_vpl VALUES ("PS123_2","020_123_2","PSA","123","2","2","Štai kaip tarnų akys žvelgia į jų valdovo ranką, kaip tarnaitės akys į jos valdovės ranką, taip mūsų akys žvelgia į VIEŠPATĮ, mūsų Dievą, kol jis išlies mums malonės. ");
INSERT INTO lit_vpl VALUES ("PS124_8","020_124_8","PSA","124","8","8","Mūsų pagalba glūdi VIEŠPATIES, kuris sukūrė dangus ir žemę, varde. ");
INSERT INTO lit_vpl VALUES ("PS125_4","020_125_4","PSA","125","4","4","Daryk gera, o VIEŠPATIE, geriesiems ir tiesiaširdžiams. ");
INSERT INTO lit_vpl VALUES ("PS126_2","020_126_2","PSA","126","2","2","Tada mūsų burna buvo pilna juoko, o mūsų liežuvis – krykštavimo. Tada buvo kalbama tautose: „VIEŠPATS padarė jiems didžių dalykų! ");
INSERT INTO lit_vpl VALUES ("PS126_3","020_126_3","PSA","126","3","3","VIEŠPATS didžių dalykų mums padarė, todėl mes linksmi. ");
INSERT INTO lit_vpl VALUES ("PS126_5","020_126_5","PSA","126","5","5","Kurie sėja ašarodami, pjaus džiaugsmingai šūkaudami. ");
INSERT INTO lit_vpl VALUES ("PS126_6","020_126_6","PSA","126","6","6","Kas eite eina verkdamas, nešinas brangia sėkla, eite pareis krykštaudamas, nešinas savo pėdais. ");
INSERT INTO lit_vpl VALUES ("PS127_1","020_127_1","PSA","127","1","1","Užkopimų giesmė Saliamonui. Jeigu VIEŠPATS nestato namų, veltui triūsia jų statytojai; jeigu VIEŠPATS nesaugo miesto, veltui budi sargas. ");
INSERT INTO lit_vpl VALUES ("PS127_2","020_127_2","PSA","127","2","2","Veltui jums anksti keltis, vėlai eiti gulti, valgyti sunkiu darbu įgytą duoną – jis gi duoda miegą tiems, kuriuos myli. ");
INSERT INTO lit_vpl VALUES ("PS127_3","020_127_3","PSA","127","3","3","Štai vaikai yra paveldas nuo VIEŠPATIES, įsčių vaisius – atlygis nuo jo. ");
INSERT INTO lit_vpl VALUES ("PS127_4","020_127_4","PSA","127","4","4","Kaip strėlės karžygio rankoje, taip jaunystės vaikai. ");
INSERT INTO lit_vpl VALUES ("PS127_5","020_127_5","PSA","127","5","5","Kokie didžiai palaimintas žmogus, kuris turi jų pilną savo strėlinę! Tokie nebus sugėdinti, bet jie kalbėsis su priešais vartuose. ");
INSERT INTO lit_vpl VALUES ("PS128_1","020_128_1","PSA","128","1","1","Užkopimų giesmė. Koks didžiai palaimintas kiekvienas, kuris bijo VIEŠPATIES ir vaikščioja jo keliais! ");
INSERT INTO lit_vpl VALUES ("PS130_4","020_130_4","PSA","130","4","4","Bet atleidimas yra su tavimi, kad tavęs bijotų. ");
INSERT INTO lit_vpl VALUES ("PS130_5","020_130_5","PSA","130","5","5","Laukiu VIEŠPATIES, laukia mano siela, aš gi užtikrintai viliuosi jo žodžiu. ");
INSERT INTO lit_vpl VALUES ("PS130_7","020_130_7","PSA","130","7","7","Izraeli, sudėk viltis į VIEŠPATĮ, nes VIEŠPATIES žinioje yra gailestingumas, jo žinioje yra apstus išpirkimas. ");
INSERT INTO lit_vpl VALUES ("PS131_1","020_131_1","PSA","131","1","1","Užkopimų giesmė. Dovydo. VIEŠPATIE, mano širdis nėra išpuikusi, nei mano akys išdidžios, nei užsiimu dideliais ar man per aukštais dalykais. ");
INSERT INTO lit_vpl VALUES ("PS131_2","020_131_2","PSA","131","2","2","Tikrai aš nuraminau ir nutildžiau savo sielą, kaip pabaigęs žįsti vaikas prie mamos; mano siela yra kaip pabaigęs žįsti vaikas prie manęs. ");
INSERT INTO lit_vpl VALUES ("PS131_3","020_131_3","PSA","131","3","3","O Izraeli, sudėk viltis į VIEŠPATĮ nuo šiol ir per amžius! ");
INSERT INTO lit_vpl VALUES ("PS132_15","020_132_15","PSA","132","15","15","Laiminte laiminsiu jo maistą, jo neturtėlius pasotinsiu duona. ");
INSERT INTO lit_vpl VALUES ("PS133_1","020_133_1","PSA","133","1","1","Užkopimų giesmė. Dovydo. Štai kaip gera ir kaip malonu, kai broliai gyvena vienybėje! ");
INSERT INTO lit_vpl VALUES ("PS136_1","020_136_1","PSA","136","1","1","Dėkokite VIEŠPAČIUI, nes jis geras, nes jo gailestingumas išlieka per amžius! ");
INSERT INTO lit_vpl VALUES ("PS136_2","020_136_2","PSA","136","2","2","Dėkokite dievų Dievui, nes jo gailestingumas išlieka per amžius! ");
INSERT INTO lit_vpl VALUES ("PS136_3","020_136_3","PSA","136","3","3","Dėkokite viešpačių VIEŠPAČIUI, nes jo gailestingumas išlieka per amžius! ");
INSERT INTO lit_vpl VALUES ("PS136_4","020_136_4","PSA","136","4","4","Tam, kuris vienas daro didelius stebuklus, nes jo gailestingumas išlieka per amžius! ");
INSERT INTO lit_vpl VALUES ("PS136_5","020_136_5","PSA","136","5","5","Tam, kuris supratingai padarė dangus, nes jo gailestingumas išlieka per amžius! ");
INSERT INTO lit_vpl VALUES ("PS136_6","020_136_6","PSA","136","6","6","Tam, kuris ištiesė žemę ant vandenų, nes jo gailestingumas išlieka per amžius! ");
INSERT INTO lit_vpl VALUES ("PS136_7","020_136_7","PSA","136","7","7","Tam, kuris padarė didelius šviesulius, nes jo gailestingumas išlieka per amžius! ");
INSERT INTO lit_vpl VALUES ("PS136_8","020_136_8","PSA","136","8","8","Saulę, kad viešpatautų dienai, nes jo gailestingumas išlieka per amžius! ");
INSERT INTO lit_vpl VALUES ("PS136_9","020_136_9","PSA","136","9","9","Mėnulį ir žvaigždes, kad viešpatautų nakčiai, nes jo gailestingumas išlieka per amžius! ");
INSERT INTO lit_vpl VALUES ("PS136_10","020_136_10","PSA","136","10","10","Tam, kuris ištiko Egiptą per jo pirmagimius, nes jo gailestingumas išlieka per amžius! ");
INSERT INTO lit_vpl VALUES ("PS136_11","020_136_11","PSA","136","11","11","Ir išvedė Izraelį iš jų tarpo, nes jo gailestingumas išlieka per amžius! ");
INSERT INTO lit_vpl VALUES ("PS136_12","020_136_12","PSA","136","12","12","Stipria ranka ir ištiestu dilbiu, nes jo gailestingumas išlieka per amžius! ");
INSERT INTO lit_vpl VALUES ("PS136_13","020_136_13","PSA","136","13","13","Tam, kuris pusiau padalijo Raudonąją jūrą, nes jo gailestingumas išlieka per amžius! ");
INSERT INTO lit_vpl VALUES ("PS136_14","020_136_14","PSA","136","14","14","Ir pervedė Izraelį per jos vidurį, nes jo gailestingumas išlieka per amžius! ");
INSERT INTO lit_vpl VALUES ("PS136_15","020_136_15","PSA","136","15","15","Bet sukratė faraoną ir jo kariuomenę į Raudonąją jūrą, nes jo gailestingumas išlieka per amžius! ");
INSERT INTO lit_vpl VALUES ("PS136_16","020_136_16","PSA","136","16","16","Tam, kuris vedė savo tautą per dykumą, nes jo gailestingumas išlieka per amžius! ");
INSERT INTO lit_vpl VALUES ("PS136_17","020_136_17","PSA","136","17","17","Tam, kuris sumušė didelius karalius, nes jo gailestingumas išlieka per amžius! ");
INSERT INTO lit_vpl VALUES ("PS136_18","020_136_18","PSA","136","18","18","Ir užmušė didingus karalius, nes jo gailestingumas išlieka per amžius! ");
INSERT INTO lit_vpl VALUES ("PS136_19","020_136_19","PSA","136","19","19","Sihoną, amoritų karalių, nes jo gailestingumas išlieka per amžius! ");
INSERT INTO lit_vpl VALUES ("PS136_20","020_136_20","PSA","136","20","20","Ir Ogą, Bašano karalių, nes jo gailestingumas išlieka per amžius! ");
INSERT INTO lit_vpl VALUES ("PS136_21","020_136_21","PSA","136","21","21","Ir davė jų šalį kaip veldinį, nes jo gailestingumas išlieka per amžius! ");
INSERT INTO lit_vpl VALUES ("PS136_22","020_136_22","PSA","136","22","22","Kaip veldinį Izraeliui, savo tarnui, nes jo gailestingumas išlieka per amžius! ");
INSERT INTO lit_vpl VALUES ("PS136_23","020_136_23","PSA","136","23","23","Kuris mus atsiminė, kai buvome pažeminti, nes jo gailestingumas išlieka per amžius! ");
INSERT INTO lit_vpl VALUES ("PS136_24","020_136_24","PSA","136","24","24","Ir mus išplėšė iš mūsų priešininkų, nes jo gailestingumas išlieka per amžius! ");
INSERT INTO lit_vpl VALUES ("PS136_25","020_136_25","PSA","136","25","25","Kuris teikia maisto kiekvienai kūną turinčiai būtybei, nes jo gailestingumas išlieka per amžius! ");
INSERT INTO lit_vpl VALUES ("PS136_26","020_136_26","PSA","136","26","26","Dėkokite dangaus Dievui, nes jo gailestingumas išlieka per amžius! ");
INSERT INTO lit_vpl VALUES ("PS138_2","020_138_2","PSA","138","2","2","Aš nusilenksiu tavo šventos buveinės link ir girsiu tavo vardą už tavo mielaširdystę ir tavo tiesą, nes tu išaukštinai savo žodį virš viso savo vardo. ");
INSERT INTO lit_vpl VALUES ("PS138_3","020_138_3","PSA","138","3","3","Dieną, kurią šaukiausi, tu mane išklausei; stiprindamas mano sielą savo galia, mane padrąsinai. ");
INSERT INTO lit_vpl VALUES ("PS138_5","020_138_5","PSA","138","5","5","Jie ir giedos VIEŠPATIES keliuose, nes VIEŠPATIES šlovė yra didžiulė! ");
INSERT INTO lit_vpl VALUES ("PS138_8","020_138_8","PSA","138","8","8","VIEŠPATS iki galo veiks mano labui. VIEŠPATIE, tavo gailestingumas amžinas! Neapleisk tų, kuriuos sukūrė tavo rankos. ");
INSERT INTO lit_vpl VALUES ("PS139_1","020_139_1","PSA","139","1","1","Vyriausiajam muzikui. Dovydo psalmė. O VIEŠPATIE, tu mane ištyrei ir pažįsti. ");
INSERT INTO lit_vpl VALUES ("PS139_2","020_139_2","PSA","139","2","2","Tu žinai mano atsisėdimą ir mano atsistojimą, tu supranti mano mintis iš toli. ");
INSERT INTO lit_vpl VALUES ("PS139_3","020_139_3","PSA","139","3","3","Tu atskiri mano taką ir mano atsigulimą, ir esi susipažinęs su visais mano keliais. ");
INSERT INTO lit_vpl VALUES ("PS139_4","020_139_4","PSA","139","4","4","Nes dar nėra žodžio ant mano liežuvio, ir štai tu, VIEŠPATIE, jį visiškai žinai. ");
INSERT INTO lit_vpl VALUES ("PS139_7","020_139_7","PSA","139","7","7","Kur galėčiau eiti nuo tavo Dvasios ir kur bėgti nuo tavo veido? ");
INSERT INTO lit_vpl VALUES ("PS139_8","020_139_8","PSA","139","8","8","Jeigu užkilčiau į dangų, ten esi tu! Ir jeigu „pasikločiau patalą“ pragare, štai ten esi tu! ");
INSERT INTO lit_vpl VALUES ("PS139_9","020_139_9","PSA","139","9","9","Jeigu pasiimčiau aušros sparnus ir apsigyvenčiau prie tolimiausio jūros galo, ");
INSERT INTO lit_vpl VALUES ("PS139_10","020_139_10","PSA","139","10","10","net ten mane vedžios tavo ranka ir tvirtai mane laikys tavo dešinė. ");
INSERT INTO lit_vpl VALUES ("PS139_11","020_139_11","PSA","139","11","11","Jeigu sakyčiau: „Tamsa tikrai užguls mane, naktis aplinkui mane pavirs šviesa, ");
INSERT INTO lit_vpl VALUES ("PS139_12","020_139_12","PSA","139","12","12","net tamsa nepaslepia nuo tavęs, bet naktis šviečia kaip diena; kaip tau šviesa, taip ir tamsa. ");
INSERT INTO lit_vpl VALUES ("PS139_13","020_139_13","PSA","139","13","13","Nes sukūrei mano giliausias dalis; tu mane surezgei mano motinos įsčiose. ");
INSERT INTO lit_vpl VALUES ("PS139_17","020_139_17","PSA","139","17","17","Kokios brangios man yra tavo mintys, o Dieve! Koks didelis jų skaičius! ");
INSERT INTO lit_vpl VALUES ("PS139_18","020_139_18","PSA","139","18","18","Jei jas skaičiuočiau, skaičiumi jų būtų daugiau negu smilčių! Kai atsibundu, aš tebesu su tavimi. ");
INSERT INTO lit_vpl VALUES ("PS139_22","020_139_22","PSA","139","22","22","Nekenčiu jų visiška neapykanta, laikau juos savo priešais. ");
INSERT INTO lit_vpl VALUES ("PS139_23","020_139_23","PSA","139","23","23","Ištirk mane, o Dieve, ir pažink mano širdį, išmėgink mane ir pažink mano mintis, ");
INSERT INTO lit_vpl VALUES ("PS139_24","020_139_24","PSA","139","24","24","ir pažiūrėk, ar yra manyje kuris nors nedoras kelias, ir vesk mane amžinuoju keliu. ");
INSERT INTO lit_vpl VALUES ("PS141_2","020_141_2","PSA","141","2","2","Tebūna mano malda išstatyta prieš tave kaip smilkalai, o mano rankų pakėlimas – kaip vakarinė auka! ");
INSERT INTO lit_vpl VALUES ("PS141_8","020_141_8","PSA","141","8","8","Juk į tave, Viešpatie JEHOVA, žvelgia mano akys, tavimi pasitikiu; neatidenk mano sielos pavojui. ");
INSERT INTO lit_vpl VALUES ("PS142_5","020_142_5","PSA","142","5","5","Šaukiausi tavęs, o VIEŠPATIE, sakiau: „Mano prieglauda ir mano dalis gyvųjų šalyje esi tu!“ ");
INSERT INTO lit_vpl VALUES ("PS142_6","020_142_6","PSA","142","6","6","Atkreipk dėmesį į mano šauksmą, nes esu susmukdytas labai žemai! Išgelbėk mane nuo mano persekiotojų, nes jie yra stipresni už mane! ");
INSERT INTO lit_vpl VALUES ("PS143_1","020_143_1","PSA","143","1","1","Dovydo psalmė. O VIEŠPATIE, išgirsk mano maldą, klausykis mano maldavimų! Atsakyk man vadovaudamasis savo ištikimumu ir savo teisumu! ");
INSERT INTO lit_vpl VALUES ("PS143_2","020_143_2","PSA","143","2","2","Ir neik į teismą su savo tarnu, nes kiekvienas iš gyvųjų yra neišteisintinas tavo akyse. ");
INSERT INTO lit_vpl VALUES ("PS143_8","020_143_8","PSA","143","8","8","Duok man jau rytmetį išgirsti tavo meilingumą, nes tavimi pasitikiu. Parodyk man kelią, kuriuo turiu eiti, nes į tave keliu savo sielą. ");
INSERT INTO lit_vpl VALUES ("PS143_10","020_143_10","PSA","143","10","10","Mokyk mane vykdyti tavo valią, nes tu esi mano Dievas. Tavo geroji dvasia tegul veda mane į teisumo kraštą. ");
INSERT INTO lit_vpl VALUES ("PS144_1","020_144_1","PSA","144","1","1","Dovydo. Tebūna palaimintas VIEŠPATS, mano uola, kuris lavina mano rankas kovai, mano pirštus karui, ");
INSERT INTO lit_vpl VALUES ("PS144_2","020_144_2","PSA","144","2","2","mano gerumas ir mano tvirtovė, mano aukšta prieglauda ir mano išvaduotojas, mano skydas ir tas, kuriuo pasitikiu, kuris mano tautą padarė man pavaldžia. ");
INSERT INTO lit_vpl VALUES ("PS144_15","020_144_15","PSA","144","15","15","Kokia didžiai palaiminta tauta, kuriai taip klostosi, palaiminta tauta, kurios Dievas yra VIEŠPATS! ");
INSERT INTO lit_vpl VALUES ("PS145_1","020_145_1","PSA","145","1","1","Dovydo pareikštas gyrius. Tave vis išaukštinsiu, mano Dieve, o karaliau! Ιr vis laiminsiu tavo vardą per amžių amžius! ");
INSERT INTO lit_vpl VALUES ("PS145_2","020_145_2","PSA","145","2","2","Kasdien laiminsiu tave ir girsiu tavo vardą per amžių amžius! ");
INSERT INTO lit_vpl VALUES ("PS145_3","020_145_3","PSA","145","3","3","VIEŠPATS yra didis ir didžiai girtinas, ir jo didybė neištiriama. ");
INSERT INTO lit_vpl VALUES ("PS145_8","020_145_8","PSA","145","8","8","VIEŠPATS yra maloningas ir kupinas gailesčio, lėtas pykti ir didžiai gailestingas. ");
INSERT INTO lit_vpl VALUES ("PS145_9","020_145_9","PSA","145","9","9","VIEŠPATS yra geras visiems, jam giliai rūpi visi jo kūriniai. ");
INSERT INTO lit_vpl VALUES ("PS145_18","020_145_18","PSA","145","18","18","VIEŠPATS yra arti visų, kurie jo šaukiasi, visų, kurie jo šaukiasi reikšdami tiesą. ");
INSERT INTO lit_vpl VALUES ("PS145_19","020_145_19","PSA","145","19","19","Jis išpildys norą tų, kurie jo bijo; jis gi išgirs jų šauksmą ir juos išgelbės. ");
INSERT INTO lit_vpl VALUES ("PS145_20","020_145_20","PSA","145","20","20","VIEŠPATS visus jį mylinčius saugo, bet nedorėlius pražudys. ");
INSERT INTO lit_vpl VALUES ("PS146_1","020_146_1","PSA","146","1","1","Girkite VIEŠPATĮ! Girk VIEŠPATĮ, mano siela! ");
INSERT INTO lit_vpl VALUES ("PS146_2","020_146_2","PSA","146","2","2","Girsiu VIEŠPATĮ, kol gyvas būsiu, giedosiu gyrių savo Dievui, kol gyvas būsiu. ");
INSERT INTO lit_vpl VALUES ("PS146_5","020_146_5","PSA","146","5","5","Laimingas žmogus, kurio pagalba – Jokūbo Dievas; jis viliasi VIEŠPAČIU, savo Dievu, ");
INSERT INTO lit_vpl VALUES ("PS146_6","020_146_6","PSA","146","6","6","kuris sukūrė dangų ir žemę, jūrą ir visa, kas yra juose; kuris išsaugo tiesą per amžius; ");
INSERT INTO lit_vpl VALUES ("PS147_1","020_147_1","PSA","147","1","1","Girkite VIEŠPATĮ, nes gera giedoti gyrių mūsų Dievui, nes tai miela, ir gyrius pritinka. ");
INSERT INTO lit_vpl VALUES ("PS147_3","020_147_3","PSA","147","3","3","Jis išgydo tuos, kurių širdis sudaužyta, ir aptvarsto jų žaizdas. ");
INSERT INTO lit_vpl VALUES ("PS147_5","020_147_5","PSA","147","5","5","Didis yra mūsų Viešpats ir didžiajėgis, jo supratimas yra begalinis. ");
INSERT INTO lit_vpl VALUES ("PS147_7","020_147_7","PSA","147","7","7","Giedokite VIEŠPAČIUI dėkodami, skambinkite lyra mūsų Dievui! ");
INSERT INTO lit_vpl VALUES ("PS147_11","020_147_11","PSA","147","11","11","VIEŠPAČIUI patinka tie, kurie jo bijo, kurie viliasi jo gailestingumu. ");
INSERT INTO lit_vpl VALUES ("PS148_1","020_148_1","PSA","148","1","1","Girkite VIEŠPATĮ! Girkite VIEŠPATĮ iš dangų, girkite jį aukštybėse! ");
INSERT INTO lit_vpl VALUES ("PS148_13","020_148_13","PSA","148","13","13","tegiria jie VIEŠPATIES vardą, nes išaukštintas jo vardas – vien tik jo; jo šlovė virš žemės ir dangaus. ");
INSERT INTO lit_vpl VALUES ("PS149_4","020_149_4","PSA","149","4","4","nes VIEŠPATS gėrisi savąja tauta, romiuosius jis papuoš išgelbėjimu. ");
INSERT INTO lit_vpl VALUES ("PS150_1","020_150_1","PSA","150","1","1","Girkite VIEŠPATĮ! Girkite VIEŠPATĮ jo šventykloje, girkite jį jo galybės skliautinėje platybėje! ");
INSERT INTO lit_vpl VALUES ("PS150_2","020_150_2","PSA","150","2","2","Girkite jį už jo galingus darbus, girkite jį, kaip pritinka jo didybės apstumui! ");
INSERT INTO lit_vpl VALUES ("PS150_3","020_150_3","PSA","150","3","3","Girkite jį pučiamųjų ragų gaudesiu, girkite jį arfa ir lyra! ");
INSERT INTO lit_vpl VALUES ("PS150_4","020_150_4","PSA","150","4","4","Girkite jį būgneliu ir šokdami ratelį, girkite jį styginiais instrumentais ir fleita! ");
INSERT INTO lit_vpl VALUES ("PS150_5","020_150_5","PSA","150","5","5","Girkite jį skardumo lėkštėmis, girkite jį šūksnių lėkštėmis! ");
INSERT INTO lit_vpl VALUES ("PS150_6","020_150_6","PSA","150","6","6","Visa, kas kvėpuoja, tegul giria VIEŠPATĮ! Girkite VIEŠPATĮ! ");
INSERT INTO lit_vpl VALUES ("PR1_1","021_1_1","PRO","1","1","1","Dovydo sūnaus Saliamono, Izraelio karaliaus, patarlės. ");
INSERT INTO lit_vpl VALUES ("PR1_2","021_1_2","PRO","1","2","2","Kad duotų pažinti išmintį ir pataisantį ugdymą, kad duotų suprasti įžvalgius žodžius, ");
INSERT INTO lit_vpl VALUES ("PR1_3","021_1_3","PRO","1","3","3","kad duotų priimti protingą elgesį skatinantį pataisantį ugdymą (teisumą, teisingumą, ir lygiateisiškumą); ");
INSERT INTO lit_vpl VALUES ("PR1_4","021_1_4","PRO","1","4","4","kad suteiktų įžvalgumo doroviškai naiviems žmonėms, pažinimo ir nuovokumo jaunuoliui. ");
INSERT INTO lit_vpl VALUES ("PR1_5","021_1_5","PRO","1","5","5","Išmintingasis išklausys ir daugiau pasimokys; ir suprantantis priims išmintingus patarimus, ");
INSERT INTO lit_vpl VALUES ("PR1_6","021_1_6","PRO","1","6","6","kad suprastų patarlę ir netiesioginės reikšmės pasakojimą, išmintingųjų posakius ir jų mįsles. ");
INSERT INTO lit_vpl VALUES ("PR1_7","021_1_7","PRO","1","7","7","VIEŠPATIES baimė yra pažinimo pradžia. Kvailiai niekina išmintį ir drausmę. ");
INSERT INTO lit_vpl VALUES ("PR1_8","021_1_8","PRO","1","8","8","Mano sūnau, klausyk savo tėvo pataisančio auklėjimo ir neatmesk savo motinos įstatymo, ");
INSERT INTO lit_vpl VALUES ("PR1_9","021_1_9","PRO","1","9","9","nes jie yra malonės papuošalas tavo galvai ir grandinėlės tavo kaklui. ");
INSERT INTO lit_vpl VALUES ("PR1_10","021_1_10","PRO","1","10","10","Mano sūnau, jei tave vilioja nusidėjėliai, nesutik. ");
INSERT INTO lit_vpl VALUES ("PR1_11","021_1_11","PRO","1","11","11","Jeigu jie sako: „Eikš su mumis, tykokime kraujo, be priežasties surenkime pasalas nekaltajam, ");
INSERT INTO lit_vpl VALUES ("PR1_12","021_1_12","PRO","1","12","12","prarykime juos gyvus, kaip kapas, tai yra žvalus, kaip nužengiančius į duobę! ");
INSERT INTO lit_vpl VALUES ("PR1_13","021_1_13","PRO","1","13","13","Rasime visokio brangaus turto, pripildysime savo namus grobio! ");
INSERT INTO lit_vpl VALUES ("PR1_14","021_1_14","PRO","1","14","14","Savo burtą mesk į mūsų tarpą, visi turėsime vieną piniginę!“ – ");
INSERT INTO lit_vpl VALUES ("PR1_15","021_1_15","PRO","1","15","15","mano sūnau, nesileisk į kelią su jais, sulaikyk savo koją nuo jų tako, ");
INSERT INTO lit_vpl VALUES ("PR1_16","021_1_16","PRO","1","16","16","nes jų kojos bėga į blogį ir skuba kraujo pralieti. ");
INSERT INTO lit_vpl VALUES ("PR1_17","021_1_17","PRO","1","17","17","Tikrai veltui tiesiamas tinklas prieš bet kurio paukščio akis, ");
INSERT INTO lit_vpl VALUES ("PR1_18","021_1_18","PRO","1","18","18","bet šie tykoja savo pačių kraujo, jie surengia pasalą savo pačių gyvybei. ");
INSERT INTO lit_vpl VALUES ("PR1_19","021_1_19","PRO","1","19","19","Tokie yra keliai kiekvieno, kuris pasigviešia neteisaus pelno; šis atima savo savininkų gyvybę. ");
INSERT INTO lit_vpl VALUES ("PR1_20","021_1_20","PRO","1","20","20","Išmintis šaukia gatvėje, plačiose vietose kelia savo balsą, ");
INSERT INTO lit_vpl VALUES ("PR1_21","021_1_21","PRO","1","21","21","ji šaukia prie triukšmingų gatvių kampų, kur vartai atsiveria; mieste ji sako savo žodžius: ");
INSERT INTO lit_vpl VALUES ("PR1_22","021_1_22","PRO","1","22","22","„O doroviškai naivūs žmonės, kiek ilgai mylėsite naivumą? Ir kiek ilgai šaipūnai mėgausis šiepimu ir kvailiai nekęs pažinimo? ");
INSERT INTO lit_vpl VALUES ("PR1_23","021_1_23","PRO","1","23","23","Gręžkitės, kai jus baru! Štai aš jums gausiai išliesiu savo dvasią, duosiu jums pažinti mano žodžius. ");
INSERT INTO lit_vpl VALUES ("PR1_24","021_1_24","PRO","1","24","24","Kadangi šaukiau, o jūs atsisakėte paisyti, ištiesiau savo ranką, ir niekas nekreipė dėmesio, ");
INSERT INTO lit_vpl VALUES ("PR1_25","021_1_25","PRO","1","25","25","bet jūs kiekvieną mano patarimą nustūmėte ir nenorėjote mano pabarimo, ");
INSERT INTO lit_vpl VALUES ("PR1_26","021_1_26","PRO","1","26","26","aš savo ruožtu juoksiuosi iš jūsų nelaimės, tyčiosiuosi, kai ateis jums siaubas, ");
INSERT INTO lit_vpl VALUES ("PR1_27","021_1_27","PRO","1","27","27","kai ateis jums siaubas lyg suniokojimas ir užklups jus didžiulė nelaimė kaip viesulas, kai ant jūsų užeis sielvartas ir susikrimtimas. ");
INSERT INTO lit_vpl VALUES ("PR1_28","021_1_28","PRO","1","28","28","Tada jie šauksis manęs, bet aš neatsakysiu, jie anksti manęs ieškos, bet nesuras manęs. ");
INSERT INTO lit_vpl VALUES ("PR1_29","021_1_29","PRO","1","29","29","Kadangi jie nekentė pažinimo ir nepasirinko VIEŠPATIES baimės, ");
INSERT INTO lit_vpl VALUES ("PR1_30","021_1_30","PRO","1","30","30","nenorėjo mano patarimo, paniekino kiekvieną mano pabarimą, ");
INSERT INTO lit_vpl VALUES ("PR1_31","021_1_31","PRO","1","31","31","tai jie valgys savo pačių kelio vaisių ir pasisotins savo pačių kėslais. ");
INSERT INTO lit_vpl VALUES ("PR1_32","021_1_32","PRO","1","32","32","Nes doroviškai naivių žmonių nusigręžimas nuo išminties jiems smogs mirtinai ir kvailių klestėjimas juos pražudys. ");
INSERT INTO lit_vpl VALUES ("PR1_33","021_1_33","PRO","1","33","33","Bet kas manęs klauso, tas saugiai gyvens ir bus ramus be nelaimės baimės.“ ");
INSERT INTO lit_vpl VALUES ("PR2_1","021_2_1","PRO","2","1","1","Mano sūnau, jeigu priimsi mano žodžius ir mano įsakymus laikysi pas save kaip brangenybę, ");
INSERT INTO lit_vpl VALUES ("PR2_2","021_2_2","PRO","2","2","2","kad palenktum savo ausį išminčiai ir nukreiptum savo širdį į supratimą, ");
INSERT INTO lit_vpl VALUES ("PR2_3","021_2_3","PRO","2","3","3","gausis šitaip, jeigu šauksiesi įžvalgumo ir pakelsi savo balsą kreipdamas supratingumui, ");
INSERT INTO lit_vpl VALUES ("PR2_4","021_2_4","PRO","2","4","4","jeigu jos ieškosi kaip sidabro ir stengsiesi ją atrasti kaip paslėptus lobius, ");
INSERT INTO lit_vpl VALUES ("PR2_5","021_2_5","PRO","2","5","5","tai tu suprasi, ką reiškia bijoti VIEŠPATIES ir sužinosi, ką reiškia pažinti Dievą. ");
INSERT INTO lit_vpl VALUES ("PR2_6","021_2_6","PRO","2","6","6","(Nes VIEŠPATS teikia išmintį, iš jo burnos ateina pažinimas ir supratimas. ");
INSERT INTO lit_vpl VALUES ("PR2_7","021_2_7","PRO","2","7","7","Jis laiko paruošęs nenuviliančią išmintį doriesiems, yra skydas tiems, kurie vaikščioja vientisumo dorybėje, ");
INSERT INTO lit_vpl VALUES ("PR2_8","021_2_8","PRO","2","8","8","saugodamas teisingumo takus ir atidžiai sergėdamas savo šventųjų kelią.) ");
INSERT INTO lit_vpl VALUES ("PR2_9","021_2_9","PRO","2","9","9","Tada tu suprasi teisumą, teisingumą ir lygiateisiškumą, tai yra kiekvieną dorą taką. ");
INSERT INTO lit_vpl VALUES ("PR2_10","021_2_10","PRO","2","10","10","Kai išmintis įeis į tavo širdį ir pažinimas bus malonus tavo sielai, ");
INSERT INTO lit_vpl VALUES ("PR2_11","021_2_11","PRO","2","11","11","nuovokumas tave atidžiai sergės, supratimas tave apsaugos, ");
INSERT INTO lit_vpl VALUES ("PR2_12","021_2_12","PRO","2","12","12","kad tave išgelbėtų nuo blogio kelio, nuo žmogaus, kalbančio tai, kas iškreipta; ");
INSERT INTO lit_vpl VALUES ("PR2_13","021_2_13","PRO","2","13","13","tokie palieka tiesius takus, kad vaikščiotų tamsybės keliais, ");
INSERT INTO lit_vpl VALUES ("PR2_14","021_2_14","PRO","2","14","14","tokie džiaugiasi vykdydami bloga ir džiūgauja dėl blogio iškrypimų; ");
INSERT INTO lit_vpl VALUES ("PR2_15","021_2_15","PRO","2","15","15","jų keliai iškrypę, ir patys yra sukti savo takuose; – ");
INSERT INTO lit_vpl VALUES ("PR2_16","021_2_16","PRO","2","16","16","kad išgelbėtų tave nuo svetimos moters, nuo svetimosios (ji meilikauja savo žodžiais, ");
INSERT INTO lit_vpl VALUES ("PR2_17","021_2_17","PRO","2","17","17","ji tokia, kuri palieka savo jaunystės vadovą ir pamiršta savo Dievo sandorą), ");
INSERT INTO lit_vpl VALUES ("PR2_18","021_2_18","PRO","2","18","18","nes jos namai grimzta į mirtį, ir jos takai – į mirusiuosius. ");
INSERT INTO lit_vpl VALUES ("PR2_19","021_2_19","PRO","2","19","19","Visi, kurie įeina pas ją, nebegrįžta ir nenutveria gyvenimo takų. ");
INSERT INTO lit_vpl VALUES ("PR2_20","021_2_20","PRO","2","20","20","Tikslas yra toks: kad vaikščiotum gerųjų keliu ir laikytumeisi teisiųjų takų, ");
INSERT INTO lit_vpl VALUES ("PR2_21","021_2_21","PRO","2","21","21","nes dorieji gyvens šalyje, ir nepriekaištingieji pasiliks joje, ");
INSERT INTO lit_vpl VALUES ("PR2_22","021_2_22","PRO","2","22","22","bet nedorėliai bus iškirsti iš žemės, ir klastūnai bus iš jos išrauti. ");
INSERT INTO lit_vpl VALUES ("PR3_1","021_3_1","PRO","3","1","1","Mano sūnau, nepamiršk mano įstatymo, bet tavo širdis tesaugo mano įsakymus, ");
INSERT INTO lit_vpl VALUES ("PR3_2","021_3_2","PRO","3","2","2","nes jie tau pridės ilgai besitęsiančias dienas ir gyvybingų metų ir ramybės. ");
INSERT INTO lit_vpl VALUES ("PR3_3","021_3_3","PRO","3","3","3","Gailestingumas ir tiesa tenepalieka tavęs; užsirišk juos sau ant kaklo, įsirašyk juos savo širdies plokštėje; ");
INSERT INTO lit_vpl VALUES ("PR3_4","021_3_4","PRO","3","4","4","to padarinys toks: įgysi maloningumą ir puikią įžvalgą, kurie matysis Dievo ir žmonių akyse. ");
INSERT INTO lit_vpl VALUES ("PR3_5","021_3_5","PRO","3","5","5","Visa savo širdimi pasitikėk VIEŠPAČIU, o savo supratimu nesiremk. ");
INSERT INTO lit_vpl VALUES ("PR3_6","021_3_6","PRO","3","6","6","Visuose savo keliuose pripažink jį, ir jis nukreips tavo takus. ");
INSERT INTO lit_vpl VALUES ("PR3_7","021_3_7","PRO","3","7","7","Nebūk išmintingas savo akyse: bijok VIEŠPATIES ir venk blogio. ");
INSERT INTO lit_vpl VALUES ("PR3_8","021_3_8","PRO","3","8","8","Tai bus sveikata tavo bambai ir smegenų drėgmė tavo kaulams. ");
INSERT INTO lit_vpl VALUES ("PR3_9","021_3_9","PRO","3","9","9","Gerbk VIEŠPATĮ savo turtu ir viso savo prieaugio pirmaisiais vaisiais, ");
INSERT INTO lit_vpl VALUES ("PR3_10","021_3_10","PRO","3","10","10","tai tavo svirnai bus gausiai pripildyti, ir šviežias vynas liesis per surinkimo talpyklų kraštus. ");
INSERT INTO lit_vpl VALUES ("PR3_11","021_3_11","PRO","3","11","11","Mano sūnau, nepaniekink VIEŠPATIES drausmės, nesipiktink dėl jo pabarimo, ");
INSERT INTO lit_vpl VALUES ("PR3_12","021_3_12","PRO","3","12","12","nes ką VIEŠPATS myli, tą sudraudžia kaip tėvas sūnų, kuriuo gėrisi. ");
INSERT INTO lit_vpl VALUES ("PR3_13","021_3_13","PRO","3","13","13","Koks didžiai palaimintas žmogus, kuris randa išmintį, ir žmogus, kuris įgyja supratimo, ");
INSERT INTO lit_vpl VALUES ("PR3_14","021_3_14","PRO","3","14","14","nes nauda iš to, ką ji teikia, yra vertingesnė negu nauda iš to, ką teikia sidabras, ir pelnas iš jos yra vertingesnis už auksą. ");
INSERT INTO lit_vpl VALUES ("PR3_15","021_3_15","PRO","3","15","15","Ji brangesnė už brangakmenius, ir visa, ko trokšti, negali jai prilygti. ");
INSERT INTO lit_vpl VALUES ("PR3_16","021_3_16","PRO","3","16","16","Ilgai besitęsiančios dienos – jos dešinėje, jos kairėje – turtai ir garbė. ");
INSERT INTO lit_vpl VALUES ("PR3_17","021_3_17","PRO","3","17","17","Jos keliai – malonūs keliai, ir visi jos takai – ramybė. ");
INSERT INTO lit_vpl VALUES ("PR3_18","021_3_18","PRO","3","18","18","Ji yra gyvybės medis tiems, kurie ją nutveria, ir laimingas kiekvienas, kuris jos laikosi. ");
INSERT INTO lit_vpl VALUES ("PR3_19","021_3_19","PRO","3","19","19","VIEŠPATS išmintimi pastatė žemę, supratimu įtvirtino dangus. ");
INSERT INTO lit_vpl VALUES ("PR3_20","021_3_20","PRO","3","20","20","Jo pažinimu perskirti požeminiai vandenys, ir debesys lašina rasą. ");
INSERT INTO lit_vpl VALUES ("PR3_21","021_3_21","PRO","3","21","21","Mano sūnau, neišleisk jų iš savo akių, laikykis sveikos išminties ir nuovokumo, ");
INSERT INTO lit_vpl VALUES ("PR3_22","021_3_22","PRO","3","22","22","taip jie bus gyvybė tavo sielai ir gražmena tavo kaklui. ");
INSERT INTO lit_vpl VALUES ("PR3_23","021_3_23","PRO","3","23","23","Tada saugiai eisi savo keliu, ir tavo koja nesuklups. ");
INSERT INTO lit_vpl VALUES ("PR3_24","021_3_24","PRO","3","24","24","Kai gulsiesi pailsėti, nebijosi, bet atsigulsi, ir tavo miegas bus saldus. ");
INSERT INTO lit_vpl VALUES ("PR3_25","021_3_25","PRO","3","25","25","Nebijok staigaus siaubo ir nedorėlių niokojimo, kai jis ateis, ");
INSERT INTO lit_vpl VALUES ("PR3_26","021_3_26","PRO","3","26","26","nes VIEŠPATS bus tavo pasitikėjimas ir apsaugos tavo koją nuo sugavimo spąstuose. ");
INSERT INTO lit_vpl VALUES ("PR3_27","021_3_27","PRO","3","27","27","Nesulaikyk gero nuo to, kuriam tai priklauso, kai tavo rankos pajėgia tai padaryti. ");
INSERT INTO lit_vpl VALUES ("PR3_28","021_3_28","PRO","3","28","28","Nesakyk savo artimui: „Eik ir sugrįžk, ir rytoj tau duosiu“, kai tu dabar turi tai pas save. ");
INSERT INTO lit_vpl VALUES ("PR3_29","021_3_29","PRO","3","29","29","Nesumanyk bloga prieš savo artimą, jam saugiai gyvenant šalia tavęs. ");
INSERT INTO lit_vpl VALUES ("PR3_30","021_3_30","PRO","3","30","30","Nesivaidyk be reikalo su žmogumi, jei jis tau nieko blogo nėra padaręs. ");
INSERT INTO lit_vpl VALUES ("PR3_31","021_3_31","PRO","3","31","31","Nepavydėk smurtininkui ir nepasirink nė vieno iš jo kelių, ");
INSERT INTO lit_vpl VALUES ("PR3_32","021_3_32","PRO","3","32","32","nes suktas žmogus yra bjaurastis VIEŠPAČIUI, bet jo paslaptis yra pas doruosius. ");
INSERT INTO lit_vpl VALUES ("PR3_33","021_3_33","PRO","3","33","33","VIEŠPATIES prakeikimas tvyro ant nedorėlio namų, bet teisiųjų buveinę jis laimina. ");
INSERT INTO lit_vpl VALUES ("PR3_34","021_3_34","PRO","3","34","34","Tikrai jis pašiepia šaipūnus, bet nuolankiesiems duoda malonę. ");
INSERT INTO lit_vpl VALUES ("PR3_35","021_3_35","PRO","3","35","35","Išmintingieji paveldės šlovę, bet negarbė „iškels“ kvailius. ");
INSERT INTO lit_vpl VALUES ("PR4_1","021_4_1","PRO","4","1","1","Vaikai, klausykite tėvo pataisančio auklėjimo ir atkreipkite dėmesį, kad išmoktumėte supratimo, ");
INSERT INTO lit_vpl VALUES ("PR4_2","021_4_2","PRO","4","2","2","nes duodu jums gerą pamokymą! Nepalikite mano įstatymo! ");
INSERT INTO lit_vpl VALUES ("PR4_3","021_4_3","PRO","4","3","3","Kai buvau savo tėvo sūnelis, gležnas ir branginamas kaip vienintelis savo motinos akyse, ");
INSERT INTO lit_vpl VALUES ("PR4_4","021_4_4","PRO","4","4","4","jis ir mokydamas mane pasakė: „Tavo širdis tegul tvirtai laiko mano žodžius! Laikykis mano įsakymų ir gyvensi! ");
INSERT INTO lit_vpl VALUES ("PR4_5","021_4_5","PRO","4","5","5","Įgyk išminties, įgyk supratimo. Nepamiršk ir nenukrypk nuo mano burnos pasakymų. ");
INSERT INTO lit_vpl VALUES ("PR4_6","021_4_6","PRO","4","6","6","Jos nepalik, ir ji tave atidžiai sergės; mylėk ją, ir ji tave saugos. ");
INSERT INTO lit_vpl VALUES ("PR4_7","021_4_7","PRO","4","7","7","Išmintis yra svarbiausias dalykas: todėl įsigyk išmintį, ir įsigyk supratimą nors ir už visą savo nuosavybę. ");
INSERT INTO lit_vpl VALUES ("PR4_8","021_4_8","PRO","4","8","8","Aukštai vertink ją, ir ji tave paaukštins; ji suteiks tau garbę, kai ją apkabinsi. ");
INSERT INTO lit_vpl VALUES ("PR4_9","021_4_9","PRO","4","9","9","Ji uždės ant tavo galvos malonės papuošalą, suteiks tau šlovės vainiką.“ ");
INSERT INTO lit_vpl VALUES ("PR4_10","021_4_10","PRO","4","10","10","Klausyk, mano sūnau, ir priimk mano pasakymus, tai tavo gyvenimo metų bus daug. ");
INSERT INTO lit_vpl VALUES ("PR4_11","021_4_11","PRO","4","11","11","Išminties kelio tave mokiau, vedžiau tave tiesiais takais. ");
INSERT INTO lit_vpl VALUES ("PR4_12","021_4_12","PRO","4","12","12","Tau einant, nebus ankšta tavo žingsniams, ir jei bėgsi, nesuklupsi. ");
INSERT INTO lit_vpl VALUES ("PR4_13","021_4_13","PRO","4","13","13","Tvirtai laikykis pataisančio auklėjimo, jo nepaleisk; saugok jį, nes tai yra tavo gyvybė. ");
INSERT INTO lit_vpl VALUES ("PR4_14","021_4_14","PRO","4","14","14","Į nedorėlių taką neįeik, ir blogųjų keliu neženk. ");
INSERT INTO lit_vpl VALUES ("PR4_15","021_4_15","PRO","4","15","15","Venk jo, nepereik į jį, nusisuk nuo jo ir praeik pro šalį. ");
INSERT INTO lit_vpl VALUES ("PR4_16","021_4_16","PRO","4","16","16","Nes jie neužmiega, jeigu nėra padarę ko bloga, ir atimamas iš jų miegas, jeigu nėra ko suklupdę. ");
INSERT INTO lit_vpl VALUES ("PR4_17","021_4_17","PRO","4","17","17","Nes jie valgo nedorybės duoną ir geria smurto vyną. ");
INSERT INTO lit_vpl VALUES ("PR4_18","021_4_18","PRO","4","18","18","Bet teisiųjų takas yra kaip sužibanti šviesa, vis labiau švintanti, kol visiškai išaušta diena. ");
INSERT INTO lit_vpl VALUES ("PR4_19","021_4_19","PRO","4","19","19","Nedorėlių kelias yra kaip tamsa: jie nežino, ant ko suklumpa. ");
INSERT INTO lit_vpl VALUES ("PR4_20","021_4_20","PRO","4","20","20","Mano sūnau, atkreipk dėmesį į mano žodžius, palenk ausį į mano pasakymus. ");
INSERT INTO lit_vpl VALUES ("PR4_21","021_4_21","PRO","4","21","21","Neišleisk jų iš savo akių, saugok juos pačiame savo širdies viduje. ");
INSERT INTO lit_vpl VALUES ("PR4_22","021_4_22","PRO","4","22","22","Nes jie yra gyvybė tiems, kurie juos randa, ir sveikata visam jų kūnui. ");
INSERT INTO lit_vpl VALUES ("PR4_23","021_4_23","PRO","4","23","23","Labiau už viską, kas saugotina, saugok savo širdį, nes iš jos teka gyvenimo versmės. ");
INSERT INTO lit_vpl VALUES ("PR4_24","021_4_24","PRO","4","24","24","Pašalink nuo savęs burnos suktumą, ir lūpų iškrypimą atitolink nuo savęs. ");
INSERT INTO lit_vpl VALUES ("PR4_25","021_4_25","PRO","4","25","25","Tavo akys turi žiūrėti tiesiai į priekį, ir tavo akių vokai turi būti nukreipti į tai, kas tiesiai prieš tave. ");
INSERT INTO lit_vpl VALUES ("PR4_26","021_4_26","PRO","4","26","26","Atidžiai apžiūrėk taką savo kojai ir visi tavo keliai bus tvirti. ");
INSERT INTO lit_vpl VALUES ("PR4_27","021_4_27","PRO","4","27","27","Nesuk nei į dešinę, nei į kairę; atitrauk savo koją nuo blogio. ");
INSERT INTO lit_vpl VALUES ("PR5_1","021_5_1","PRO","5","1","1","Mano sūnau, atkreipk dėmesį į mano išmintį ir palenk savo ausį mano supratimui, ");
INSERT INTO lit_vpl VALUES ("PR5_2","021_5_2","PRO","5","2","2","kad saugotum nuovokumą ir kad tavo lūpos laikytųsi pažinimo. ");
INSERT INTO lit_vpl VALUES ("PR5_3","021_5_3","PRO","5","3","3","Nes svetimos moters lūpos varva korio medumi ir jos burna švelnesnė už aliejų, ");
INSERT INTO lit_vpl VALUES ("PR5_4","021_5_4","PRO","5","4","4","bet jos galutinės pasekmės yra karčios kaip metėlė, aštrios kaip dviašmenis kalavijas. ");
INSERT INTO lit_vpl VALUES ("PR5_5","021_5_5","PRO","5","5","5","Jos kojos leidžiasi į mirtį, pragarą nusitveria jos žingsniai. ");
INSERT INTO lit_vpl VALUES ("PR5_6","021_5_6","PRO","5","6","6","Kad tik negalvotum apie gyvenimo taką – jos keliai vingiuoti, tu tai nepastebi. ");
INSERT INTO lit_vpl VALUES ("PR5_7","021_5_7","PRO","5","7","7","Taigi dabar, vaikai, klausykite manęs ir neatsitraukite nuo mano burnos žodžių. ");
INSERT INTO lit_vpl VALUES ("PR5_8","021_5_8","PRO","5","8","8","Atitolink nuo jos savo kelią ir nesiartink prie jos namų durų, ");
INSERT INTO lit_vpl VALUES ("PR5_9","021_5_9","PRO","5","9","9","kad kitiems neatiduotum savo garbės ir savo metų neatiduotum žiauriajam, ");
INSERT INTO lit_vpl VALUES ("PR5_10","021_5_10","PRO","5","10","10","kad svetimi žmonės nesisotintų tavo turtu ir tai, kas tavo įgyta sunkiu darbu nebūtų pašalinio namuose, ");
INSERT INTO lit_vpl VALUES ("PR5_11","021_5_11","PRO","5","11","11","ir galiausiai nevaitotum, kai sunyks tavo mėsa ir tavo kūnas, ");
INSERT INTO lit_vpl VALUES ("PR5_12","021_5_12","PRO","5","12","12","ir nesakytum: „Ai, ai! Kaip nekenčiau pataisančio ugdymo, ir mano širdis paniekino pabarimą, ");
INSERT INTO lit_vpl VALUES ("PR5_13","021_5_13","PRO","5","13","13","ir nepaklusau savo mokytojų balsui, ir nepalenkiau savo ausies tiems, kurie mane mokė! ");
INSERT INTO lit_vpl VALUES ("PR5_14","021_5_14","PRO","5","14","14","Tik per plauką nebuvau visiškoje nelaimėje sušauktos žmonių grupės ir susirinkimo tarpe. ");
INSERT INTO lit_vpl VALUES ("PR5_15","021_5_15","PRO","5","15","15","Gerk vandenis iš savo paties talpyklos ir tekančius vandenis iš savo paties šulinio. ");
INSERT INTO lit_vpl VALUES ("PR5_16","021_5_16","PRO","5","16","16","Teišsilieja tavo versmės lauke, plačiose vietose tavo vandenų upeliai. ");
INSERT INTO lit_vpl VALUES ("PR5_17","021_5_17","PRO","5","17","17","Jie tegul priklauso tau vienam, bet ne svetimiems šalia tavęs. ");
INSERT INTO lit_vpl VALUES ("PR5_18","021_5_18","PRO","5","18","18","Tebūna tavo šaltinis palaimintas ir džiaukis savo jaunystės žmona. ");
INSERT INTO lit_vpl VALUES ("PR5_19","021_5_19","PRO","5","19","19","Ji tebūna kaip mylinti elnė ir maloni stirna. Visada jos krūtys tepatenkina tave, ir nuolat būk jos meilės nugalėtas. ");
INSERT INTO lit_vpl VALUES ("PR5_20","021_5_20","PRO","5","20","20","Juk kodėl, mano sūnau, būtum svetimos moters nugalėtas ir apkabintum svetimosios krūtinę? ");
INSERT INTO lit_vpl VALUES ("PR5_21","021_5_21","PRO","5","21","21","Nes VIEŠPATIES akys mato žmogaus kelius, ir jis stebi visus jo takus. ");
INSERT INTO lit_vpl VALUES ("PR5_22","021_5_22","PRO","5","22","22","Nedorėlį sugaus jo paties neteisybės, ir jis bus pagautas savo nuodėmės virvėmis. ");
INSERT INTO lit_vpl VALUES ("PR5_23","021_5_23","PRO","5","23","23","Jis mirs dėl drausmės stokos ir dėl savo didelės kvailybės jis nuklys. ");
INSERT INTO lit_vpl VALUES ("PR6_1","021_6_1","PRO","6","1","1","Mano sūnau, jei esi laidavęs už savo pažįstamą, jei esi paspaudęs ranką prisiimdamas atsakomybę už svetimąjį, ");
INSERT INTO lit_vpl VALUES ("PR6_2","021_6_2","PRO","6","2","2","tu savo burnos žodžiais esi įsipainiojęs, savo burnos žodžiais esi sugautas. ");
INSERT INTO lit_vpl VALUES ("PR6_3","021_6_3","PRO","6","3","3","Daryk jau šitaip, mano sūnau, ir išsivaduok, nes patekai į savo pažįstamo rankas: eik, nusižemink ir smarkiai maldauk savo pažįstamo. ");
INSERT INTO lit_vpl VALUES ("PR6_4","021_6_4","PRO","6","4","4","Neduok miegoti savo akims nei pasnausti savo akių vokams. ");
INSERT INTO lit_vpl VALUES ("PR6_5","021_6_5","PRO","6","5","5","Išsivaduok kaip elnė iš medžiotojo rankos ir kaip paukštis iš paukštgaudžio rankos. ");
INSERT INTO lit_vpl VALUES ("PR6_6","021_6_6","PRO","6","6","6","Eik pas skruzdėlę, tinginy, apsvarstyk jos kelius ir pasidaryk išmintingas. ");
INSERT INTO lit_vpl VALUES ("PR6_7","021_6_7","PRO","6","7","7","Neturėdama jokio vadovo, prižiūrėtojo ar valdovo, ");
INSERT INTO lit_vpl VALUES ("PR6_8","021_6_8","PRO","6","8","8","ji paruošia sau maisto vasarą, surenka sau peną pjūties metu. ");
INSERT INTO lit_vpl VALUES ("PR6_9","021_6_9","PRO","6","9","9","Kiek ilgai drybsosi, tinginy? Kada kelsiesi iš savo miego? ");
INSERT INTO lit_vpl VALUES ("PR6_10","021_6_10","PRO","6","10","10","Dar truputį pamiegoti, truputį pasnausti, truputį rankas susidėjus padrybsoti, – ");
INSERT INTO lit_vpl VALUES ("PR6_11","021_6_11","PRO","6","11","11","ir tavo skurdas ateis kaip žygiuotojas ir tavo nepriteklius kaip ginkluotas vyras. ");
INSERT INTO lit_vpl VALUES ("PR6_12","021_6_12","PRO","6","12","12","Nenaudėlis žmogus, nedoras žmogus, vaikštinėja kalbėdamas apgaulinga burna. ");
INSERT INTO lit_vpl VALUES ("PR6_13","021_6_13","PRO","6","13","13","Jis mirkteli akimis, kalba kojomis, moko pirštais. ");
INSERT INTO lit_vpl VALUES ("PR6_14","021_6_14","PRO","6","14","14","Turėdamas savo širdyje suktybių, jis nuolat sumano blogį, sėja nesutarimus. ");
INSERT INTO lit_vpl VALUES ("PR6_15","021_6_15","PRO","6","15","15","Dėl to jo žlugimas ateis staiga, per akimirką jis bus sutriuškintas nepagydomai. ");
INSERT INTO lit_vpl VALUES ("PR6_16","021_6_16","PRO","6","16","16","VIEŠPATS nekenčia šitų šešių dalykų, net septyni yra jam bjaurybė: ");
INSERT INTO lit_vpl VALUES ("PR6_17","021_6_17","PRO","6","17","17","išdidžios akys, melagingas liežuvis ir nekaltą kraują praliejančios rankos, ");
INSERT INTO lit_vpl VALUES ("PR6_18","021_6_18","PRO","6","18","18","širdis, sumananti nedorus sumanymus, kojos, skubiai bėgančios į blogį, ");
INSERT INTO lit_vpl VALUES ("PR6_19","021_6_19","PRO","6","19","19","nebūtus dalykus kalbantis melagingas liudytojas, ir tas, kuris sėja nesutarimus tarp brolių. ");
INSERT INTO lit_vpl VALUES ("PR6_20","021_6_20","PRO","6","20","20","Mano sūnau, laikykis savo tėvo įsakymo ir neatmesk savo motinos įstatymo. ");
INSERT INTO lit_vpl VALUES ("PR6_21","021_6_21","PRO","6","21","21","Laikyk juos nuolat prisirišęs prie širdies ir apsirišk juos aplink kaklą. ");
INSERT INTO lit_vpl VALUES ("PR6_22","021_6_22","PRO","6","22","22","Kai tu eini tas įstatymas ves tave, kai tu miegi jis saugos tave, o tau atsibudus jis kalbės su tavimi. ");
INSERT INTO lit_vpl VALUES ("PR6_23","021_6_23","PRO","6","23","23","Nes įsakymas yra žibintas, ir įstatymas – šviesa, ir drausmės pabarimai – gyvenimo kelias, ");
INSERT INTO lit_vpl VALUES ("PR6_24","021_6_24","PRO","6","24","24","kad tave saugotų nuo blogos moters, nuo svetimos moters liežuvio meilikavimo. ");
INSERT INTO lit_vpl VALUES ("PR6_25","021_6_25","PRO","6","25","25","Nenorėk jos grožio savo širdyje, ir neleisk jai pagauti tave savo akių vokais. ");
INSERT INTO lit_vpl VALUES ("PR6_26","021_6_26","PRO","6","26","26","Nes per paleistuvaujančią moterį vyrui telieka duonos kąsnis, ir svetimautoja medžioja brangią gyvybę. ");
INSERT INTO lit_vpl VALUES ("PR6_27","021_6_27","PRO","6","27","27","Ar gali žmogus paimti ugnį į savo užantį ir nesudeginti savo drabužių? ");
INSERT INTO lit_vpl VALUES ("PR6_28","021_6_28","PRO","6","28","28","Arba ar gali žmogus vaikščioti ant karštų žarijų ir nenudegti kojų? ");
INSERT INTO lit_vpl VALUES ("PR6_29","021_6_29","PRO","6","29","29","Taip ir tas, kuris įeina pas savo artimo žmoną; neliks nekaltas nė vienas, kuris ją paliečia. ");
INSERT INTO lit_vpl VALUES ("PR6_30","021_6_30","PRO","6","30","30","Žmonės nepaniekina vagies, jei jis vagia, kad patenkintų savo sielą, kai yra alkanas; ");
INSERT INTO lit_vpl VALUES ("PR6_31","021_6_31","PRO","6","31","31","tačiau pagautas jis turi atmokėti septyneriopai, atiduoti visą savo namų turtą. ");
INSERT INTO lit_vpl VALUES ("PR6_32","021_6_32","PRO","6","32","32","Kas su moterimi svetimauja, tas stokoja nuovokos; kuris tai daro, tas pražudo savo sielą. ");
INSERT INTO lit_vpl VALUES ("PR6_33","021_6_33","PRO","6","33","33","Sužalojimo ir negarbės jis susilauks, ir jo gėda nebus išdildyta. ");
INSERT INTO lit_vpl VALUES ("PR6_34","021_6_34","PRO","6","34","34","Nes pavyduliavimas yra vyro įtūžis, ir jis keršto dieną nepasigailės. ");
INSERT INTO lit_vpl VALUES ("PR6_35","021_6_35","PRO","6","35","35","Jis nepriims jokio pasiūlyto papirkimo, ir nesutiks, nors ir duotum didžiulį kyšį. ");
INSERT INTO lit_vpl VALUES ("PR7_1","021_7_1","PRO","7","1","1","Mano sūnau, laikykis mano žodžių ir mano įsakymus laikyk savyje kaip brangenybę. ");
INSERT INTO lit_vpl VALUES ("PR7_2","021_7_2","PRO","7","2","2","Saugok mano įsakymus ir gyvenk, ir mano įstatymą kaip savo akies vyzdį. ");
INSERT INTO lit_vpl VALUES ("PR7_3","021_7_3","PRO","7","3","3","Užsirišk juos sau ant pirštų, įsirašyk juos savo širdies plokštėje. ");
INSERT INTO lit_vpl VALUES ("PR7_4","021_7_4","PRO","7","4","4","Sakyk išminčiai: „Tu mano sesuo“, – o išmonę vadink giminaite, ");
INSERT INTO lit_vpl VALUES ("PR7_5","021_7_5","PRO","7","5","5","kad jos apsaugotų tave nuo svetimos moters, nuo svetimosios, meilikaujančios savo žodžiais. ");
INSERT INTO lit_vpl VALUES ("PR7_6","021_7_6","PRO","7","6","6","Nes prie savo namų lango žiūrėjau pro savo pinučius ");
INSERT INTO lit_vpl VALUES ("PR7_7","021_7_7","PRO","7","7","7","ir mačiau tarp doroviškai naivių žmonių, pastebėjau tarp jaunuolių sveiko mąstymo stokojantį jaunikaitį, ");
INSERT INTO lit_vpl VALUES ("PR7_8","021_7_8","PRO","7","8","8","einantį gatve arti jos kampo, ir jis žingsniavo keliu jos namų link ");
INSERT INTO lit_vpl VALUES ("PR7_9","021_7_9","PRO","7","9","9","prieblandoje, dienai blėstant, nakties ir tamsos viduryje. ");
INSERT INTO lit_vpl VALUES ("PR7_10","021_7_10","PRO","7","10","10","Ir štai jį pasitiko moteris paleistuvės apdaru ir klastinga širdimi. ");
INSERT INTO lit_vpl VALUES ("PR7_11","021_7_11","PRO","7","11","11","(Ji triukšminga ir maištinga, jos kojos nepasilieka namie. ");
INSERT INTO lit_vpl VALUES ("PR7_12","021_7_12","PRO","7","12","12","Tai gatvėje, tai aikštėse, ir prie kiekvieno kampo ji tykoja.) ");
INSERT INTO lit_vpl VALUES ("PR7_13","021_7_13","PRO","7","13","13","Taigi ji pastvėrė jį ir pabučiavo; rodydama kietą veido išraišką jam tarė: ");
INSERT INTO lit_vpl VALUES ("PR7_14","021_7_14","PRO","7","14","14","„Aš turiu taikos aukas; šią dieną ištesėjau savo įžadus. ");
INSERT INTO lit_vpl VALUES ("PR8_6","021_8_6","PRO","8","6","6","Klausykite, nes kalbėsiu tai, kas kilnu, ir mano lūpos skelbs tai, kas tiesu. ");
INSERT INTO lit_vpl VALUES ("PR8_13","021_8_13","PRO","8","13","13","VIEŠPATIES baimė – tai nekęsti blogio; puikybės, išdidumo, blogio kelio ir iškrypusios burnos aš nekenčiu. ");
INSERT INTO lit_vpl VALUES ("PR8_17","021_8_17","PRO","8","17","17","Aš myliu tuos, kurie mane myli, ir kas anksti manęs ieško, mane suras. ");
INSERT INTO lit_vpl VALUES ("PR8_18","021_8_18","PRO","8","18","18","Turtai ir garbė yra pas mane, išliekantis lobis ir teisumas. ");
INSERT INTO lit_vpl VALUES ("PR8_22","021_8_22","PRO","8","22","22","VIEŠPATS turėjo mane, savo kelio pradžią, prieš savo senovės kūrinius. ");
INSERT INTO lit_vpl VALUES ("PR8_30","021_8_30","PRO","8","30","30","tada aš buvau šalia jo kaip architektas, ir kasdien buvau jo pasigėrėjimas, visuomet džiūgaudama jo akivaizdoje, ");
INSERT INTO lit_vpl VALUES ("PR8_31","021_8_31","PRO","8","31","31","džiūgaudama jo žemės gyvenamoje vietoje ir labai gėrėdamasi žmonių palikuonimis. ");
INSERT INTO lit_vpl VALUES ("PR8_32","021_8_32","PRO","8","32","32","Taigi dabar, vaikai, klausykite manęs! Nes palaiminti tie, kurie laikosi mano kelių. ");
INSERT INTO lit_vpl VALUES ("PR8_34","021_8_34","PRO","8","34","34","Koks didžiai palaimintas žmogus, kuris manęs klauso, kasdien budėdamas prie mano vartų, laukdamas šalia mano durų staktų. ");
INSERT INTO lit_vpl VALUES ("PR9_1","021_9_1","PRO","9","1","1","Išmintis pasistatė namus, ji išsitašė septynis stulpus. ");
INSERT INTO lit_vpl VALUES ("PR9_2","021_9_2","PRO","9","2","2","Ji skerdė savo maistinius gyvulius, sumaišė savo vyną, taip pat paruošė savo stalą. ");
INSERT INTO lit_vpl VALUES ("PR9_3","021_9_3","PRO","9","3","3","Ji išsiuntė savo tarnaites, ji šaukia iš miesto aukštumų: ");
INSERT INTO lit_vpl VALUES ("PR9_4","021_9_4","PRO","9","4","4","„Kas tik yra doroviškai naivus, tas tegul užsuka čia“; kuriam trūksta sveiko mąstymo, tam ji sako: ");
INSERT INTO lit_vpl VALUES ("PR9_5","021_9_5","PRO","9","5","5","„Ateikite, valgykite mano duonos ir gerkite vyno, kurį sumaišiau. ");
INSERT INTO lit_vpl VALUES ("PR9_6","021_9_6","PRO","9","6","6","Palik doroviškai naivius žmones ir gyvensi, eik gi supratimo keliu!“ ");
INSERT INTO lit_vpl VALUES ("PR9_10","021_9_10","PRO","9","10","10","VIEŠPATIES baimė yra išminties pradžia, ir Šventojo pažinimas yra supratimas. ");
INSERT INTO lit_vpl VALUES ("PR9_17","021_9_17","PRO","9","17","17","„Vogti vandenys saldūs, ir slaptoje valgoma duona gardi.“ ");
INSERT INTO lit_vpl VALUES ("PR9_18","021_9_18","PRO","9","18","18","Bet jis nežino, kad ten yra mirusieji, kad jos svečiai yra pragaro gelmėse. ");
INSERT INTO lit_vpl VALUES ("PR10_1","021_10_1","PRO","10","1","1","Saliamono patarlės. Išmintingas sūnus džiugina tėvą, bet kvailas sūnus yra sielvartas savo motinai. ");
INSERT INTO lit_vpl VALUES ("PR10_2","021_10_2","PRO","10","2","2","Nedorybės lobiai naudos neduoda, bet teisumas išgelbsti nuo mirties. ");
INSERT INTO lit_vpl VALUES ("PR10_8","021_10_8","PRO","10","8","8","Kas išmintingas širdimi, tas priima įsakymus, bet kas kvailas lūpomis, tas bus nublokštas. ");
INSERT INTO lit_vpl VALUES ("PR10_9","021_10_9","PRO","10","9","9","Kas nekaltai vaikščioja, saugiai vaikščioja, bet kas iškraipo savo kelius, bus išaiškintas. ");
INSERT INTO lit_vpl VALUES ("PR10_17","021_10_17","PRO","10","17","17","Kas paiso pataisantį ugdymą yra takas į gyvenimą, bet kas atmeta pabarimą, tas klaidina. ");
INSERT INTO lit_vpl VALUES ("PR10_19","021_10_19","PRO","10","19","19","Kur daug žodžių, ten netrūksta nuodėmių, bet kas pažaboja savo lūpas, yra išmintingas. ");
INSERT INTO lit_vpl VALUES ("PR10_20","021_10_20","PRO","10","20","20","Teisiojo liežuvis yra kaip rinktinis sidabras, o nedorėlio nuovoka yra mažavertė. ");
INSERT INTO lit_vpl VALUES ("PR10_21","021_10_21","PRO","10","21","21","Teisiojo lūpos maitina daugelį, bet kvailieji miršta dėl nuovokos stokos. ");
INSERT INTO lit_vpl VALUES ("PR10_22","021_10_22","PRO","10","22","22","Praturtina štai kas – VIEŠPATIES palaiminimas, ir jis prie to neprideda sielvarto. ");
INSERT INTO lit_vpl VALUES ("PR10_27","021_10_27","PRO","10","27","27","VIEŠPATIES baimė prideda dienų, bet nedorėlių metai bus sutrumpinti. ");
INSERT INTO lit_vpl VALUES ("PR10_28","021_10_28","PRO","10","28","28","Teisiojo neabejotina viltis teikia džiaugsmą, o nedorėlio lūkestis žūva. ");
INSERT INTO lit_vpl VALUES ("PR10_31","021_10_31","PRO","10","31","31","Teisiojo burna užaugina išminties, bet iškreiptas liežuvis bus išpjautas. ");
INSERT INTO lit_vpl VALUES ("PR10_32","021_10_32","PRO","10","32","32","Teisiojo lūpos žino, kas yra priimtina, bet nedorėlių burna kalba daugybę suktybių. ");
INSERT INTO lit_vpl VALUES ("PR11_1","021_11_1","PRO","11","1","1","Apgaulingos svarstyklės – bjaurastis VIEŠPAČIUI, bet tikslus svarstis jam patinka. ");
INSERT INTO lit_vpl VALUES ("PR11_2","021_11_2","PRO","11","2","2","Atėjus išdidumui, ateina ir gėda, bet su nuolankiaisiais yra išmintis. ");
INSERT INTO lit_vpl VALUES ("PR11_14","021_11_14","PRO","11","14","14","Kai nėra išmintingo kreipimo, tauta žlunga, bet saugumas ten, kur daug patarėjų. ");
INSERT INTO lit_vpl VALUES ("PR11_18","021_11_18","PRO","11","18","18","Nedorėlis daro apgaulingą darbą, bet kas sėja teisumą, tam bus užtikrintas užmokestis. ");
INSERT INTO lit_vpl VALUES ("PR11_21","021_11_21","PRO","11","21","21","Ranka į ranką blogas žmogus neliks nenubaustas, bet teisųjų sėkla bus išvaduota. ");
INSERT INTO lit_vpl VALUES ("PR11_24","021_11_24","PRO","11","24","24","Vienas plačiai išskirsto, bet vis dėlto turtėja, o kitas pasilaiko tai, ką turėtų atiduoti, bet tik nuskursta. ");
INSERT INTO lit_vpl VALUES ("PR11_25","021_11_25","PRO","11","25","25","Dosni siela bus praturtintas, ir kas pagirdo, pats bus pagirdytas. ");
INSERT INTO lit_vpl VALUES ("PR11_29","021_11_29","PRO","11","29","29","Kas vargina savo šeimyną, tas paveldės vėją, ir toks kvailys tampa išmintingos širdies žmogaus tarnu. ");
INSERT INTO lit_vpl VALUES ("PR11_30","021_11_30","PRO","11","30","30","Teisiojo vaisius yra gyvybės medis, ir kas laimi sielų, yra išmintingas. ");
INSERT INTO lit_vpl VALUES ("PR12_1","021_12_1","PRO","12","1","1","Kas myli drausminantį pamokymą, myli pažinimą, bet kas nekenčia pabarimo, yra bukaprotis. ");
INSERT INTO lit_vpl VALUES ("PR12_2","021_12_2","PRO","12","2","2","Geras žmogus įgyja VIEŠPATIES palankumą, bet jis pasmerks žmogų, kuris sumano nedorus planus. ");
INSERT INTO lit_vpl VALUES ("PR12_3","021_12_3","PRO","12","3","3","Žmogus nebus įtvirtintas nedorybe, bet teisiųjų šaknis nebus pajudintas. ");
INSERT INTO lit_vpl VALUES ("PR12_4","021_12_4","PRO","12","4","4","Šauni moteris yra savo vyro vainikas, bet ta, kuri užtraukia gėdą, yra kaip puvinys jo kauluose. ");
INSERT INTO lit_vpl VALUES ("PR12_7","021_12_7","PRO","12","7","7","Nedorėliai yra parbloškiami ir jų nebėra, bet teisiųjų namai stovės. ");
INSERT INTO lit_vpl VALUES ("PR12_10","021_12_10","PRO","12","10","10","Teisusis rūpinasi savo gyvulio gyvybe, bet nedorėlio gailestingiausi jausmai yra žiaurūs. ");
INSERT INTO lit_vpl VALUES ("PR12_12","021_12_12","PRO","12","12","12","Nedorėlis geidžia blogųjų tinklą, bet teisiajam šaknis duota. ");
INSERT INTO lit_vpl VALUES ("PR12_15","021_12_15","PRO","12","15","15","Kvailio akims jo kelias atrodo teisingas, bet kas klauso patarimo yra išmintingas. ");
INSERT INTO lit_vpl VALUES ("PR12_16","021_12_16","PRO","12","16","16","Kvailio rūstybė tuoj pat žinoma, bet sumanus žmogus nuslepia nepagarbą. ");
INSERT INTO lit_vpl VALUES ("PR12_19","021_12_19","PRO","12","19","19","Tiesą kalbančios lūpos išsilaikys amžinai, bet meluojantis liežuvis tik akimirksnį. ");
INSERT INTO lit_vpl VALUES ("PR12_20","021_12_20","PRO","12","20","20","Apgaulė yra širdyje tų, kurie sumano pikta, bet taikingai patariantiems yra džiaugsmas. ");
INSERT INTO lit_vpl VALUES ("PR12_22","021_12_22","PRO","12","22","22","Meluojančios lūpos yra bjaurastis VIEŠPAČIUI, bet kurie elgiasi pagal teisybę, tie jam patinka. ");
INSERT INTO lit_vpl VALUES ("PR12_25","021_12_25","PRO","12","25","25","Nerimas žmogaus širdyje ją smukdo, bet geras žodis ją pradžiugina. ");
INSERT INTO lit_vpl VALUES ("PR12_28","021_12_28","PRO","12","28","28","Gyvybė yra teisumo kelyje, juk to tako kryptimi nėra mirties. ");
INSERT INTO lit_vpl VALUES ("PR13_1","021_13_1","PRO","13","1","1","Išmintingas sūnus klauso savo tėvo drausminančio pamokymo, bet šaipūnas neklauso barimo. ");
INSERT INTO lit_vpl VALUES ("PR13_2","021_13_2","PRO","13","2","2","Iš savo burnos vaisiaus žmogus valgys tai, kas gera, bet klastūnų siela valgys smurtą. ");
INSERT INTO lit_vpl VALUES ("PR13_3","021_13_3","PRO","13","3","3","Kas sulaiko savo burną, tas apsaugo savo gyvybę, bet kas plačiai atveria savo lūpas, tam bus pražūtis. ");
INSERT INTO lit_vpl VALUES ("PR13_9","021_13_9","PRO","13","9","9","Teisiųjų šviesa džiūgauja, bet nedorėlių žibintas bus užgęsintas. ");
INSERT INTO lit_vpl VALUES ("PR13_10","021_13_10","PRO","13","10","10","Tik per išdidumą kyla ginčas, bet išmintis yra su tais, kurie priima gerą patarimą. ");
INSERT INTO lit_vpl VALUES ("PR13_12","021_13_12","PRO","13","12","12","Atidėta viltis susargdina širdį, o įgyvendintas troškimas yra gyvybės medis. ");
INSERT INTO lit_vpl VALUES ("PR13_14","021_13_14","PRO","13","14","14","Išmintingojo įstatymas – gyvybės šaltinis, kad pavyktų išvengti mirties žabangų. ");
INSERT INTO lit_vpl VALUES ("PR13_20","021_13_20","PRO","13","20","20","Kas vaikščioja su išmintingais, bus išmintingas, bet kas draugauja su kvailais, sužlugs. ");
INSERT INTO lit_vpl VALUES ("PR13_24","021_13_24","PRO","13","24","24","Kas gailisi savo rykštelės, nekenčia savo sūnaus, bet kas jį myli, drausmina jį anksti. ");
INSERT INTO lit_vpl VALUES ("PR13_25","021_13_25","PRO","13","25","25","Teisusis valgo iki savo sielos soties, bet nedorėlių pilvas stokos. ");
INSERT INTO lit_vpl VALUES ("PR14_1","021_14_1","PRO","14","1","1","Kiekviena išmintinga moteris statydina savo namus, bet kvaila nugriauna juos savo rankomis. ");
INSERT INTO lit_vpl VALUES ("PR14_2","021_14_2","PRO","14","2","2","Kas vaikščioja besilaikydamas savo tiesumo, bijo VIEŠPATIES, bet kas eina savo suktais keliais, jį niekina. ");
INSERT INTO lit_vpl VALUES ("PR14_3","021_14_3","PRO","14","3","3","Kvailojo burnoje – išdidumo lazda, bet išmintingųjų lūpos juos apsaugos. ");
INSERT INTO lit_vpl VALUES ("PR14_4","021_14_4","PRO","14","4","4","Kur nėra jaučių, ten švarios ėdžios, bet gausus prieaugis gaunamas jaučio jėga. ");
INSERT INTO lit_vpl VALUES ("PR14_10","021_14_10","PRO","14","10","10","Širdis pažįsta savo pačios kartumą, ir pašalietis nesidalins jos džiaugsmu. ");
INSERT INTO lit_vpl VALUES ("PR14_11","021_14_11","PRO","14","11","11","Nedorėlių namai bus sunaikinti, bet dorųjų padangtė klestės. ");
INSERT INTO lit_vpl VALUES ("PR14_12","021_14_12","PRO","14","12","12","Būna kelias, kuris atrodo teisingas žmogui, bet jo galas – mirties keliai. ");
INSERT INTO lit_vpl VALUES ("PR14_15","021_14_15","PRO","14","15","15","Doroviškai naivus žmogus tiki visokiais dalykais, kas tik pasakyta, bet sumanus žmogus apsvarsto savo žingsnius. ");
INSERT INTO lit_vpl VALUES ("PR14_17","021_14_17","PRO","14","17","17","Kas greitai supyksta, kvailai elgiasi, o žmogus, kuris sumano nedorus planus, yra nekenčiamas. ");
INSERT INTO lit_vpl VALUES ("PR14_19","021_14_19","PRO","14","19","19","Blogieji nusilenkia prieš geruosius, ir nedorėliai – prie teisiųjų vartų. ");
INSERT INTO lit_vpl VALUES ("PR14_26","021_14_26","PRO","14","26","26","Stiprų užtikrintumą turi tas, kuris bijo VIEŠPATIES, ir savo vaikams jis bus prieglauda. ");
INSERT INTO lit_vpl VALUES ("PR14_27","021_14_27","PRO","14","27","27","VIEŠPATIES baimė yra gyvenimo šaltinis mirties pinklėms išvengti. ");
INSERT INTO lit_vpl VALUES ("PR14_29","021_14_29","PRO","14","29","29","Kas lėtas pykti, tas turi daug supratimo, bet staigios dvasios žmogus išaukština kvailumą. ");
INSERT INTO lit_vpl VALUES ("PR14_31","021_14_31","PRO","14","31","31","Kas skriaudžia vargšą, niekina jo Kūrėją, bet jį gerbia tas, kuris pasigaili stokojančio. ");
INSERT INTO lit_vpl VALUES ("PR14_32","021_14_32","PRO","14","32","32","Nedorėlis parbloškiamas dėl jo paties blogadarystės, bet teisusis turi prieglaudą net savo mirties metu. ");
INSERT INTO lit_vpl VALUES ("PR15_1","021_15_1","PRO","15","1","1","Švelnus atsakymas nukreipia rūstybę, bet šiurkštūs žodžiai sukelia pyktį. ");
INSERT INTO lit_vpl VALUES ("PR15_2","021_15_2","PRO","15","2","2","Išmintingųjų liežuvis gerai pritaiko pažinimą, bet kvailųjų burna plūsta kvailumu. ");
INSERT INTO lit_vpl VALUES ("PR15_3","021_15_3","PRO","15","3","3","VIEŠPATIES akys yra visur, stebinčios blogus ir gerus. ");
INSERT INTO lit_vpl VALUES ("PR15_4","021_15_4","PRO","15","4","4","Gydantis liežuvis yra gyvybės medis, bet jo suktumas yra dvasios sutraiškymas. ");
INSERT INTO lit_vpl VALUES ("PR15_8","021_15_8","PRO","15","8","8","Nedorėlio auka VIEŠPAČIUI yra bjaurastis, bet dorųjų malda jam yra pasigėrėjimas. ");
INSERT INTO lit_vpl VALUES ("PR15_13","021_15_13","PRO","15","13","13","Džiugi širdis linksmina veidą, bet širdies sielvartu dvasia palaužiama. ");
INSERT INTO lit_vpl VALUES ("PR15_16","021_15_16","PRO","15","16","16","Geriau mažai su VIEŠPATIES baime, negu didelis lobis ir su juo nerimas. ");
INSERT INTO lit_vpl VALUES ("PR15_17","021_15_17","PRO","15","17","17","Geriau daržovių porcija, kur yra meilė, negu nupenėtas jautis ir su juo neapykanta. ");
INSERT INTO lit_vpl VALUES ("PR15_20","021_15_20","PRO","15","20","20","Išmintingas sūnus džiugina tėvą, bet kvailas žmogus niekina savo motiną. ");
INSERT INTO lit_vpl VALUES ("PR15_21","021_15_21","PRO","15","21","21","Kvailybė yra džiaugsmas stokojančiajam sveiko mąstymo, bet supratingas žmogus vaikščioja tiesiai. ");
INSERT INTO lit_vpl VALUES ("PR15_23","021_15_23","PRO","15","23","23","Žmogus džiaugiasi savo burnos deramu atsakymu, ir koks geras žodis, pasakytas tinkamu laiku! ");
INSERT INTO lit_vpl VALUES ("PR15_24","021_15_24","PRO","15","24","24","Gyvenimo takas eina aukštyn išmintingajam, kad jis išvengtų pragaro žemai. ");
INSERT INTO lit_vpl VALUES ("PR15_26","021_15_26","PRO","15","26","26","Blogo žmogaus kėslai – bjaurastis VIEŠPAČIUI, bet tyrųjų žodžiai – malonūs žodžiai. ");
INSERT INTO lit_vpl VALUES ("PR15_28","021_15_28","PRO","15","28","28","Teisiojo širdis apmąsto, kaip atsakyti, bet nedorėlio burna išlieja blogybes. ");
INSERT INTO lit_vpl VALUES ("PR15_29","021_15_29","PRO","15","29","29","VIEŠPATS toli nuo nedorėlių, bet teisiųjų maldą jis išklauso. ");
INSERT INTO lit_vpl VALUES ("PR16_1","021_16_1","PRO","16","1","1","Žmogui priklauso širdies sudėlioti sumanymai, bet liežuvio atsakymas yra iš VIEŠPATIES. ");
INSERT INTO lit_vpl VALUES ("PR16_2","021_16_2","PRO","16","2","2","Visi žmogaus keliai yra švarūs jo paties akyse, bet VIEŠPATS pasveria dvasias. ");
INSERT INTO lit_vpl VALUES ("PR16_3","021_16_3","PRO","16","3","3","Pavesk savo darbus VIEŠPAČIUI, tai tavo sumanymai bus sutvirtinti. ");
INSERT INTO lit_vpl VALUES ("PR16_4","021_16_4","PRO","16","4","4","VIEŠPATS viską padarė savo tikslui ir net nedorėlį tam tikrai kančios dienai. ");
INSERT INTO lit_vpl VALUES ("PR16_5","021_16_5","PRO","16","5","5","Kiekvienas, kuris išdidus širdyje yra pasibjaurėjimas VIEŠPAČIUI; ranka į ranką jis neliks nenubaustas. ");
INSERT INTO lit_vpl VALUES ("PR16_6","021_16_6","PRO","16","6","6","Kaltė apvaloma dėl gailestingumo ir tiesos, ir žmonės pasitraukia nuo blogio dėl VIEŠPATIES baimės. ");
INSERT INTO lit_vpl VALUES ("PR16_7","021_16_7","PRO","16","7","7","Kai žmogaus keliai patinka VIEŠPAČIUI, jis sutaiko su juo net jo priešus. ");
INSERT INTO lit_vpl VALUES ("PR16_8","021_16_8","PRO","16","8","8","Geriau mažai su teisumu, negu didelės pajamos be teisingumo. ");
INSERT INTO lit_vpl VALUES ("PR16_9","021_16_9","PRO","16","9","9","Žmogaus širdis sumano jo kelią, bet nukreipia jo žingsnius VIEŠPATS. ");
INSERT INTO lit_vpl VALUES ("PR16_10","021_16_10","PRO","16","10","10","Dieviškas nuosprendis yra Karaliaus lūpose; jo burna nenusižengia teisme. ");
INSERT INTO lit_vpl VALUES ("PR16_11","021_16_11","PRO","16","11","11","Teisingos svartis ir svarstyklės yra VIEŠPATIES; visi maišelio svarsčiai – jo darbas. ");
INSERT INTO lit_vpl VALUES ("PR16_17","021_16_17","PRO","16","17","17","Dorųjų vieškelis – pasitraukti nuo blogio; kas sergi savo kelią, tas išsaugo savo sielą. ");
INSERT INTO lit_vpl VALUES ("PR16_18","021_16_18","PRO","16","18","18","Pirm žlugimo eina išdidumas, ir pirm suklupimo – išpuikusi dvasia. ");
INSERT INTO lit_vpl VALUES ("PR16_19","021_16_19","PRO","16","19","19","Geriau būti nusižeminusia dvasia su nuolankiaisiais, negu dalytis grobiu su išdidžiaisiais. ");
INSERT INTO lit_vpl VALUES ("PR16_20","021_16_20","PRO","16","20","20","Kas išmintingai reikalą tvarko, tas randa gera, ir kas pasitiki VIEŠPAČIU, tas laimingas! ");
INSERT INTO lit_vpl VALUES ("PR16_23","021_16_23","PRO","16","23","23","Išmintingojo širdis daro jo burną sumaningą ir jo lūpoms prideda tai, kas skatina susivokmą. ");
INSERT INTO lit_vpl VALUES ("PR16_25","021_16_25","PRO","16","25","25","Būna kelias, kuris atrodo teisingas žmogui, bet jo galas – mirties keliai. ");
INSERT INTO lit_vpl VALUES ("PR16_32","021_16_32","PRO","16","32","32","Kas lėtas pykti yra geresnis už karžygį ir kas suvaldo savo dvasią – už tą, kuris nukariauja miestą. ");
INSERT INTO lit_vpl VALUES ("PR17_1","021_17_1","PRO","17","1","1","Geriau sausas kąsnelis ir su juo ramybė, negu namai, pilni aukų mėsos, su vaidais. ");
INSERT INTO lit_vpl VALUES ("PR17_2","021_17_2","PRO","17","2","2","Išmintingas tarnas valdys gėdą darantį sūnų ir tarp brolių dalysis veldiniu. ");
INSERT INTO lit_vpl VALUES ("PR17_3","021_17_3","PRO","17","3","3","Lydyklė – sidabrui, lydkrosnė – auksui, o širdžių tyrėjas – VIEŠPATS. ");
INSERT INTO lit_vpl VALUES ("PR17_6","021_17_6","PRO","17","6","6","Senųjų vainikas – vaikų vaikai, o vaikų šlovė – jų tėvai. ");
INSERT INTO lit_vpl VALUES ("PR17_9","021_17_9","PRO","17","9","9","Kas pridengia nusižengimą, siekia meilės, bet kas kartoja reikalą, išskiria draugus. ");
INSERT INTO lit_vpl VALUES ("PR17_10","021_17_10","PRO","17","10","10","Išmintingajam didesnį įspūdį padaro pabarimas negu kvailiui šimtas kirčių. ");
INSERT INTO lit_vpl VALUES ("PR17_15","021_17_15","PRO","17","15","15","Kas išteisina nedorėlį ir kas nuteisia teisųjį, tie abu yra pasibjaurėjimas VIEŠPAČIUI. ");
INSERT INTO lit_vpl VALUES ("PR17_17","021_17_17","PRO","17","17","17","Draugas visada myli, ir brolis gimsta bėdos atvejui. ");
INSERT INTO lit_vpl VALUES ("PR17_18","021_17_18","PRO","17","18","18","Sveiko mąstymo stokojantis žmogus paspaudžia ranką prisiimdamas kito atsakomybę ir laiduoja savo pažįstamo akivaizdoje. ");
INSERT INTO lit_vpl VALUES ("PR17_21","021_17_21","PRO","17","21","21","Kas pagimdo kvailį, tas sukelia sau sielvartą, ir paikšo tėvas neturi džiaugsmo. ");
INSERT INTO lit_vpl VALUES ("PR17_22","021_17_22","PRO","17","22","22","Linksma širdis daro gera kaip vaistai, bet prislėgta dvasia džiovina kaulus. ");
INSERT INTO lit_vpl VALUES ("PR17_25","021_17_25","PRO","17","25","25","Kvailas sūnus – sielvartas tėvui ir kartybė tai, kuri jį pagimdė. ");
INSERT INTO lit_vpl VALUES ("PR17_28","021_17_28","PRO","17","28","28","Net kvailys, kai jis tyli, laikomas išmintingu; kas sučiaupia lūpas laikomas supratingu žmogumi. ");
INSERT INTO lit_vpl VALUES ("PR18_1","021_18_1","PRO","18","1","1","Per geismą uždaras žmogus išsiveržia ant visos saugios išminties. ");
INSERT INTO lit_vpl VALUES ("PR18_8","021_18_8","PRO","18","8","8","Liežuvautojo žodžiai yra kaip lengviai suryjami skanėstai, ir jie pasiekia žmogaus asmenybės gelmes. ");
INSERT INTO lit_vpl VALUES ("PR18_10","021_18_10","PRO","18","10","10","VIEŠPATIES vardas – tvirtas bokštas; teisusis bėga į jį ir yra saugus. ");
INSERT INTO lit_vpl VALUES ("PR18_12","021_18_12","PRO","18","12","12","Prieš žlugimą žmogaus širdis yra išdidi, ir prieš garbę eina nusižeminimas. ");
INSERT INTO lit_vpl VALUES ("PR18_13","021_18_13","PRO","18","13","13","Kas, dar neišklausęs, atsako, tam tai yra kvailybė ir gėda. ");
INSERT INTO lit_vpl VALUES ("PR18_21","021_18_21","PRO","18","21","21","Mirtis ir gyvenimas yra liežuvio galioje, ir kurie jį mėgsta, tie valgys jo vaisius. ");
INSERT INTO lit_vpl VALUES ("PR18_22","021_18_22","PRO","18","22","22","Kas randa žmoną, randa gera ir įgyja VIEŠPATIES palankumą. ");
INSERT INTO lit_vpl VALUES ("PR18_24","021_18_24","PRO","18","24","24","Žmogus, turintis draugų, turi būti draugiškas, ir yra mylintis draugas, kuris labiau prisirišęs negu brolis. ");
INSERT INTO lit_vpl VALUES ("PR19_3","021_19_3","PRO","19","3","3","Paties žmogaus kvailumas iškreipia jo kelią ir jo širdis niršta ant VIEŠPATIES. ");
INSERT INTO lit_vpl VALUES ("PR19_5","021_19_5","PRO","19","5","5","Melagingas liudytojas neliks nenubaustas, ir kas kalba melus, neišsigelbės. ");
INSERT INTO lit_vpl VALUES ("PR19_8","021_19_8","PRO","19","8","8","Kas įgyja sveiko mąstymo, tas myli savo sielą; kas laikosi supratimo, tas ras gera. ");
INSERT INTO lit_vpl VALUES ("PR19_9","021_19_9","PRO","19","9","9","Melagingas liudytojas neliks nenubaustas, ir kas kalba melus, pražus. ");
INSERT INTO lit_vpl VALUES ("PR19_11","021_19_11","PRO","19","11","11","Žmogaus nuovokumas daro jį lėtą pykti, ir jam šlovė – atleisti nusižengimą. ");
INSERT INTO lit_vpl VALUES ("PR19_14","021_19_14","PRO","19","14","14","Namai ir turtas – paveldas iš tėvų, o išmintinga žmona – nuo VIEŠPATIES. ");
INSERT INTO lit_vpl VALUES ("PR19_18","021_19_18","PRO","19","18","18","Drausmink sūnų, nes yra vilties, ir dėl jam gręsiančios žūties, nuo drausminimo nesusilaikyk. ");
INSERT INTO lit_vpl VALUES ("PR19_21","021_19_21","PRO","19","21","21","Daug sumanymų žmogaus širdyje, bet VIEŠPATIES nutarimas bus įvykdytas. ");
INSERT INTO lit_vpl VALUES ("PR19_23","021_19_23","PRO","19","23","23","VIEŠPATIES baimė veda į gyvenimą, ir kas bijo VIEŠPATIES liks patenkintas; blogis jo neaplankys. ");
INSERT INTO lit_vpl VALUES ("PR19_26","021_19_26","PRO","19","26","26","Kas užpuola tėvą, kas išveja motiną, tai sūnus, kuris daro gėdą ir užtraukia negarbę. ");
INSERT INTO lit_vpl VALUES ("PR19_27","021_19_27","PRO","19","27","27","Mano sūnau, liaukis klausyti pataisančio ugdymo, ir po to nuklysti nuo pažinimo žodžių. ");
INSERT INTO lit_vpl VALUES ("PR20_1","021_20_1","PRO","20","1","1","Vynas yra išjuokėjas, stiprus gėrimas yra triukšmingas siautėjas; ir kiekvienas, kuris juo apsigauna, yra neišmintingas. ");
INSERT INTO lit_vpl VALUES ("PR20_2","021_20_2","PRO","20","2","2","Karaliaus sukelta baimė yra kaip liūto riaumojimas; kas jį supykdo, nusideda prieš savo gyvybę. ");
INSERT INTO lit_vpl VALUES ("PR20_3","021_20_3","PRO","20","3","3","Tai yra garbė žmogui vengti vaido, bet kiekvienas kvailys ginčijasi. ");
INSERT INTO lit_vpl VALUES ("PR20_6","021_20_6","PRO","20","6","6","Dauguma žmonių skelbia savo pačių gerumą, bet kas gali rasti patikimą žmogų?! ");
INSERT INTO lit_vpl VALUES ("PR20_7","021_20_7","PRO","20","7","7","Teisusis vaikšto savo vientisumo dorybėje; po jo yra labai palaiminti jo vaikai. ");
INSERT INTO lit_vpl VALUES ("PR20_17","021_20_17","PRO","20","17","17","Žmogui gardi apgavystės duona, bet vėliau jo burna taps pilna žvyro. ");
INSERT INTO lit_vpl VALUES ("PR20_20","021_20_20","PRO","20","20","20","Kas keikia savo tėvą ar savo motiną, to žibintas bus užgesintas juodžiausioje tamsoje. ");
INSERT INTO lit_vpl VALUES ("PR20_22","021_20_22","PRO","20","22","22","Nesakyk: „Atlyginsiu blogu už bloga.“ Lauk VIEŠPATIES, ir jis tave išgelbės. ");
INSERT INTO lit_vpl VALUES ("PR20_27","021_20_27","PRO","20","27","27","Žmogaus dvasia yra VIEŠPATIES žibintas, tiriantis žmogaus asmenybės gelmes. ");
INSERT INTO lit_vpl VALUES ("PR20_30","021_20_30","PRO","20","30","30","Sumušimo randai nuvalo nuo blogio, ir kirčiai nuvalo žmogaus asmenybės gelmes. ");
INSERT INTO lit_vpl VALUES ("PR21_1","021_21_1","PRO","21","1","1","Karaliaus širdis – tai vandens upeliai VIEŠPATIES rankoje: jis nukreipia ją, kur tik nori. ");
INSERT INTO lit_vpl VALUES ("PR21_2","021_21_2","PRO","21","2","2","Kiekvienas žmogaus kelias yra teisingas jo paties akyse, bet VIEŠPATS pasveria širdis. ");
INSERT INTO lit_vpl VALUES ("PR21_15","021_21_15","PRO","21","15","15","Teisingumo vykdymas – teisiojo džiaugsmas, bet blogadarių žlugimas. ");
INSERT INTO lit_vpl VALUES ("PR21_20","021_21_20","PRO","21","20","20","Išmintingo žmogaus buveinėje yra branginamo lobio ir aliejaus, bet kvailas žmogus tai išeikvoja. ");
INSERT INTO lit_vpl VALUES ("PR21_23","021_21_23","PRO","21","23","23","Kas sulaiko savo burną ir savo liežuvį, apsaugo savo sielą nuo bėdų. ");
INSERT INTO lit_vpl VALUES ("PR21_24","021_21_24","PRO","21","24","24","Kas pasinaudoja išdidžia rūstybe, to vardas – išdidus ir išpuikęs išjuokėjas. ");
INSERT INTO lit_vpl VALUES ("PR21_25","021_21_25","PRO","21","25","25","Tinginio troškimas jį nužudo, nes jo rankos atsisako dirbti. ");
INSERT INTO lit_vpl VALUES ("PR21_26","021_21_26","PRO","21","26","26","Jis godžiai geidžia visą dieną, bet teisusis duoda ir nešykšti. ");
INSERT INTO lit_vpl VALUES ("PR21_29","021_21_29","PRO","21","29","29","Nedorėlis rodo kietą veidą, bet doras žmogus nustato savo keliui tvirtą pagrindą. ");
INSERT INTO lit_vpl VALUES ("PR21_30","021_21_30","PRO","21","30","30","Jokia išmintis, joks supratimas ir joks patarimas negali atsispirti VIEŠPAČIUI. ");
INSERT INTO lit_vpl VALUES ("PR22_1","021_22_1","PRO","22","1","1","Geriau pasirinkti gerą vardą negu didelius turtus ir gerą vertinimą negu sidabrą ir auksą. ");
INSERT INTO lit_vpl VALUES ("PR22_2","021_22_2","PRO","22","2","2","Turtingas ir beturtis susitinka: jų visų Kūrėjas yra VIEŠPATS. ");
INSERT INTO lit_vpl VALUES ("PR22_3","021_22_3","PRO","22","3","3","Sumanus žmogus mato pavojų ir pasislepia, bet doroviškai naivūs žmonės eina toliau ir turi sulaukti bausmės. ");
INSERT INTO lit_vpl VALUES ("PR22_4","021_22_4","PRO","22","4","4","Nusižeminimo, tai yra VIEŠPATIES baimės, pasekmė – turtai, garbė ir gyvenimas. ");
INSERT INTO lit_vpl VALUES ("PR22_5","021_22_5","PRO","22","5","5","Erškėčiai ir žabangos yra sukto žmogaus kelyje; kas saugo savo sielą, bus toli nuo jų. ");
INSERT INTO lit_vpl VALUES ("PR22_6","021_22_6","PRO","22","6","6","Įgudink vaiką pagal jam įsakytą kelią, ir pasenęs jis nenukryps nuo jo. ");
INSERT INTO lit_vpl VALUES ("PR22_7","021_22_7","PRO","22","7","7","Turtingasis viešpatauja beturčiui, ir skolininkas yra skolintojo vergas. ");
INSERT INTO lit_vpl VALUES ("PR22_8","021_22_8","PRO","22","8","8","Kas sėja neteisybę, pjaus tuštybę, ir jo rūstybės lazda nueis niekais. ");
INSERT INTO lit_vpl VALUES ("PR22_15","021_22_15","PRO","22","15","15","Kvailystė yra įrišusi vaiko širdyje; drausmės rykštelė ją atitolins nuo jo. ");
INSERT INTO lit_vpl VALUES ("PR22_20","021_22_20","PRO","22","20","20","Ar neparašiau tau puikių dalykų su sumaningumu ir pažinimu, ");
INSERT INTO lit_vpl VALUES ("PR22_21","021_22_21","PRO","22","21","21","kad tau duočiau pažinti tiesos žodžių tikrovę, kad galėtum atsakyti tiesos žodžiais tiems, kurie tave siunčia? ");
INSERT INTO lit_vpl VALUES ("PR22_24","021_22_24","PRO","22","24","24","Nesibičiulauk su pikčiurna ir nesusieik su karštakošiu, ");
INSERT INTO lit_vpl VALUES ("PR22_25","021_22_25","PRO","22","25","25","kad neišmoktum jo kelių ir nepaspęstum žabangų savo sielai. ");
INSERT INTO lit_vpl VALUES ("PR22_26","021_22_26","PRO","22","26","26","Nebūk vienu iš tų, kurie paspaudžia ranką prisiimdami kito atsakomybę, vienu iš tų, kurie laiduoja už skolas. ");
INSERT INTO lit_vpl VALUES ("PR22_29","021_22_29","PRO","22","29","29","Matai žmogų, stropiai atliekantį darbą? Jis stos į darbą karalių akivaizdoje, jis nestos į darbą nežinomųjų akivaizdoje. ");
INSERT INTO lit_vpl VALUES ("PR23_4","021_23_4","PRO","23","4","4","Nesivargink siekdamas praturtėti – atsisakyk savo išmanymo. ");
INSERT INTO lit_vpl VALUES ("PR23_7","021_23_7","PRO","23","7","7","nes kaip jis galvoja savo širdyje, toks jis ir yra; „Valgyk ir gerk!“ – jis sako tau, bet jo širdis nėra su tavimi. ");
INSERT INTO lit_vpl VALUES ("PR23_13","021_23_13","PRO","23","13","13","Nesulaikyk nuo vaiko pataisančio auklėjimo, nes jeigu jį suduosi rykštele, jis nemirs. ");
INSERT INTO lit_vpl VALUES ("PR23_14","021_23_14","PRO","23","14","14","Tu turi jį suduoti rykštele, ir taip išgelbėsi jo sielą nuo pragaro. ");
INSERT INTO lit_vpl VALUES ("PR23_15","021_23_15","PRO","23","15","15","Mano sūnau, jeigu tavo širdis bus išmintinga, džiaugsis mano širdis, būtent aš džiaugsiuosi. ");
INSERT INTO lit_vpl VALUES ("PR23_17","021_23_17","PRO","23","17","17","Tegul tavo širdis nepavydi nusidėjėliams, bet išlik bijantis VIEŠPATIES visuomet; ");
INSERT INTO lit_vpl VALUES ("PR23_18","021_23_18","PRO","23","18","18","nes galas tikrai yra, ir tavo lūkestis nebus pribaigtas. ");
INSERT INTO lit_vpl VALUES ("PR23_19","021_23_19","PRO","23","19","19","Klausyk, mano sūnau, ir būk išmintingas ir kelyje nustatyk kryptį savo širdžiai. ");
INSERT INTO lit_vpl VALUES ("PR23_20","021_23_20","PRO","23","20","20","Nebūk su mėgstančiais išgerti vyno, su mėsos rajūnais, ");
INSERT INTO lit_vpl VALUES ("PR23_21","021_23_21","PRO","23","21","21","nes girtuoklis ir rajūnas nuskurs, ir mieguistumas aprengs žmogų skarmalais. ");
INSERT INTO lit_vpl VALUES ("PR23_22","021_23_22","PRO","23","22","22","Klausyk savo tėvo, kuris tave pagimdė, ir nepaniekink savo motinos, kai ji pasenusi. ");
INSERT INTO lit_vpl VALUES ("PR23_23","021_23_23","PRO","23","23","23","Pirk tiesą ir jos neparduok; taip pat išmintį, drausmę ir supratimą. ");
INSERT INTO lit_vpl VALUES ("PR23_24","021_23_24","PRO","23","24","24","Teisiojo tėvas didžiai džiūgaus, ir tas, kuris pagimdo išmintingą vaiką, juo džiaugsis. ");
INSERT INTO lit_vpl VALUES ("PR23_25","021_23_25","PRO","23","25","25","Tavo tėvas ir tavo motina bus laimingi, ir tedžiūgauja ta, kuri tave pagimdė. ");
INSERT INTO lit_vpl VALUES ("PR23_26","021_23_26","PRO","23","26","26","Mano sūnau, duok man savo širdį, ir tegul tavo akys stebi mano kelius. ");
INSERT INTO lit_vpl VALUES ("PR23_27","021_23_27","PRO","23","27","27","Nes paleistuvė yra gili duobė, ir svetima moteris – ankštas šulinys. ");
INSERT INTO lit_vpl VALUES ("PR23_28","021_23_28","PRO","23","28","28","Be to, ji kaip plėšikas tykoja grobio ir daugina neištikimuosius tarp žmonių. ");
INSERT INTO lit_vpl VALUES ("PR23_29","021_23_29","PRO","23","29","29","Kam būna vargas? Kam liūdesys? Kam vaidai? Kam bambėjimas? Kam būna žaizdų be priežasties? Kam paraudusios akys? ");
INSERT INTO lit_vpl VALUES ("PR23_30","021_23_30","PRO","23","30","30","Tiems, kurie ilgai užtrunka prie vyno, kurie vis eina ragauti maišyto vyno. ");
INSERT INTO lit_vpl VALUES ("PR23_31","021_23_31","PRO","23","31","31","Nežiūrėk į vyną, kai jis raudonas, kai jis parodo savo išvaizdą taurėje; jis švelniai sruvena gerkle žemyn. ");
INSERT INTO lit_vpl VALUES ("PR23_32","021_23_32","PRO","23","32","32","Galų gale jis kerta kaip gyvatė ir įgelia kaip angis. ");
INSERT INTO lit_vpl VALUES ("PR23_33","021_23_33","PRO","23","33","33","Tavo akys žiūrės į svetimas moteris, ir tavo širdis ištars iškrypusius dalykus. ");
INSERT INTO lit_vpl VALUES ("PR23_34","021_23_34","PRO","23","34","34","Ir tu būsi kaip gulintis jūros viduryje ir kaip gulintis laivo stiebo viršūnėje. ");
INSERT INTO lit_vpl VALUES ("PR23_35","021_23_35","PRO","23","35","35","„Mane smogė, – sakysi, – bet man neskaudėjo; mane mušė, bet nejaučiau! Kada prabusiu? Vėl jo ieškosiu.“ ");
INSERT INTO lit_vpl VALUES ("PR24_1","021_24_1","PRO","24","1","1","Blogiems žmonėms nepavydėk ir su jais būti negeisk, ");
INSERT INTO lit_vpl VALUES ("PR24_2","021_24_2","PRO","24","2","2","nes jų širdis apmąsto, kaip smurtą vartoti, ir jų lūpos aptaria, kaip žalą padaryti. ");
INSERT INTO lit_vpl VALUES ("PR24_3","021_24_3","PRO","24","3","3","Namai statomi išmintimi ir sutvirtinami supratimu, ");
INSERT INTO lit_vpl VALUES ("PR24_8","021_24_8","PRO","24","8","8","Kas sumano daryti blogį, tas bus pramintas pinklininku. ");
INSERT INTO lit_vpl VALUES ("PR24_9","021_24_9","PRO","24","9","9","Sumanyti kvailystę yra nuodėmė; ir išjuokėjas – pasibjaurėjimas žmonėms. ");
INSERT INTO lit_vpl VALUES ("PR24_11","021_24_11","PRO","24","11","11","O, kad išvaduotum tuos, kurie vedami į mirtį ir sulaikytum tuos, kurie slysta į skerdimą! ");
INSERT INTO lit_vpl VALUES ("PR24_12","021_24_12","PRO","24","12","12","Jeigu sakai: „Mes juk šito nežinojome!“ – tai argi tas, kuris pasveria širdis, nesusigaudo? Argi tas, kuris saugo tavo sielą, nežino? Ir argi jis neatlygins kiekvienam žmogui pagal jo darbus? ");
INSERT INTO lit_vpl VALUES ("PR24_16","021_24_16","PRO","24","16","16","nes teisusis septynis kartus pargriūna ir vėl atsikelia, bet nedorėliai galutinai suklups nelaimėje. ");
INSERT INTO lit_vpl VALUES ("PR24_19","021_24_19","PRO","24","19","19","Nesierzink dėl blogadarių, nepavydėk nedorėliams, ");
INSERT INTO lit_vpl VALUES ("PR24_20","021_24_20","PRO","24","20","20","nes blogajam nebus geros baigties, nedorėlio žibintas bus užgesintas. ");
INSERT INTO lit_vpl VALUES ("PR24_21","021_24_21","PRO","24","21","21","Mano sūnau, bijok VIEŠPATIES ir karaliaus; nesusidėk su linkusiais pakeisti, ");
INSERT INTO lit_vpl VALUES ("PR24_24","021_24_24","PRO","24","24","24","Kas nedorėliui sako: „Tu teisus“, – tą žmonės prakeiks, ant jo tautos pyks; ");
INSERT INTO lit_vpl VALUES ("PR24_25","021_24_25","PRO","24","25","25","bet tiems, kurie tokį sudraus, bus mielas atsiliepimas, ir jiems ateis gerovės palaima. ");
INSERT INTO lit_vpl VALUES ("PR24_27","021_24_27","PRO","24","27","27","Paruošk savo darbą po atvira dangumi ir jį padaryk tinkamą sau laukuose, o paskui įkurk sau šeimą. ");
INSERT INTO lit_vpl VALUES ("PR24_33","021_24_33","PRO","24","33","33","Dar truputį pamiegoti, truputį pasnausti, truputį rankas susidėjęs padrybsoti, – ");
INSERT INTO lit_vpl VALUES ("PR24_34","021_24_34","PRO","24","34","34","ir tavo skurdas ateis kaip žygiuotojas ir tavo nepriteklius kaip ginkluotas vyras. ");
INSERT INTO lit_vpl VALUES ("PR25_1","021_25_1","PRO","25","1","1","Šitos irgi yra Saliamono patarlės, kuriuos perrašė Judo karaliaus Chezekijo vyrai. ");
INSERT INTO lit_vpl VALUES ("PR25_11","021_25_11","PRO","25","11","11","Kaip aukso obuoliai sidabro puošmenose, taip tinkamai pasakytas žodis. ");
INSERT INTO lit_vpl VALUES ("PR25_12","021_25_12","PRO","25","12","12","Kaip auksinis žiedas ir gryno aukso papuošalas, taip išmintingas pabarėjas paklusniai ausiai. ");
INSERT INTO lit_vpl VALUES ("PR25_14","021_25_14","PRO","25","14","14","Kaip debesys ir vėjas be lietaus yra tas, kuris giriasi nebūta dovana. ");
INSERT INTO lit_vpl VALUES ("PR25_19","021_25_19","PRO","25","19","19","Pasitikėjimas neištikimu žmogumi bėdos metu yra kaip sugedęs dantis ir raiša koja. ");
INSERT INTO lit_vpl VALUES ("PR25_28","021_25_28","PRO","25","28","28","Kaip sugriautas miestas be sienų yra žmogus, kuris nesuvaldo savo dvasios. ");
INSERT INTO lit_vpl VALUES ("PR26_1","021_26_1","PRO","26","1","1","Kaip sniegas vasarą ir kaip lietus pjūties metu, taip garbė netinka kvailiui. ");
INSERT INTO lit_vpl VALUES ("PR26_22","021_26_22","PRO","26","22","22","Liežuvautojo žodžiai yra kaip lengviai suryjami skanėstai, ir jie pasiekia žmogaus asmenybės gelmes. ");
INSERT INTO lit_vpl VALUES ("PR26_28","021_26_28","PRO","26","28","28","Meluojantis liežuvis nekenčia tų, kurie nuo jo nukenčia, ir pataikaujanti burna sukelia baisią nelaimę. ");
INSERT INTO lit_vpl VALUES ("PR27_1","021_27_1","PRO","27","1","1","Nesigirk rytojaus diena, nes nežinai, ką diena gali atnešti. ");
INSERT INTO lit_vpl VALUES ("PR27_2","021_27_2","PRO","27","2","2","Tegul tave giria kitas, o ne tavo paties burna, kas nors kitas, o ne tavo paties lūpos. ");
INSERT INTO lit_vpl VALUES ("PR27_3","021_27_3","PRO","27","3","3","Akmuo yra sunkus ir smėlis svarus, bet kvailio sukeltas apmaudas sunkesnis už abu. ");
INSERT INTO lit_vpl VALUES ("PR27_6","021_27_6","PRO","27","6","6","Mylinčio draugo daromos žaizdos yra ištikimos, bet priešo bučiniai klastingi. ");
INSERT INTO lit_vpl VALUES ("PR27_9","021_27_9","PRO","27","9","9","Kaip tepalas ir kvepalai džiugina širdį, taip džiugina žmogaus draugo mielumas, pareikštas širdingu patarimu. ");
INSERT INTO lit_vpl VALUES ("PR27_11","021_27_11","PRO","27","11","11","Mano sūnau, būk išmintingas ir pradžiugink mano širdį, kad galėčiau atsakyti tam, kuris man priekaištauja. ");
INSERT INTO lit_vpl VALUES ("PR27_12","021_27_12","PRO","27","12","12","Sumanus žmogus mato pavojų ir pasislepia, bet doroviškai naivūs žmonės eina toliau ir turi sulaukti bausmės. ");
INSERT INTO lit_vpl VALUES ("PR27_17","021_27_17","PRO","27","17","17","Geležis geležį galanda; taip žmogus „galanda“ savo draugo veido išraišką. ");
INSERT INTO lit_vpl VALUES ("PR27_19","021_27_19","PRO","27","19","19","Kaip vandenyje veidas atspindi veidą, taip žmogaus širdis atspindi žmogų. ");
INSERT INTO lit_vpl VALUES ("PR27_21","021_27_21","PRO","27","21","21","Lydyklė – sidabrui, lydkrosnė – auksui, o jam sakytas pagyrimas – žmogui. ");
INSERT INTO lit_vpl VALUES ("PR28_1","021_28_1","PRO","28","1","1","Nedorėliai bėga niekam nesivejant, bet teisieji yra drąsūs kaip liūtas. ");
INSERT INTO lit_vpl VALUES ("PR28_4","021_28_4","PRO","28","4","4","Kurie palieka įstatymą, giria nedorėlius, bet kurie laikosi įstatymo, priešinasi jiems. ");
INSERT INTO lit_vpl VALUES ("PR28_5","021_28_5","PRO","28","5","5","Blogi žmonės nesupranta, ką reiškia teisingumas, bet tie, kurie ieško VIEŠPATIES, viską supranta. ");
INSERT INTO lit_vpl VALUES ("PR28_9","021_28_9","PRO","28","9","9","Kas nukreipia savo ausį, kad nesiklausytų įstatymo, net jo malda yra bjaurastis. ");
INSERT INTO lit_vpl VALUES ("PR28_13","021_28_13","PRO","28","13","13","Kas slepia savo nuodėmes, tam nesiseka, bet kas jas išpažįsta ir palieka, tas susilaukia gailestingumo. ");
INSERT INTO lit_vpl VALUES ("PR28_20","021_28_20","PRO","28","20","20","Ištikimas žmogus turės daug palaiminimų, bet kas skuba praturtėti, tas neliks nenubaustas. ");
INSERT INTO lit_vpl VALUES ("PR28_24","021_28_24","PRO","28","24","24","Kas apiplėšia savo tėvą ar savo motiną ir sako: „Nėra nusižengimo!“, – tas yra niokotojo draugas. ");
INSERT INTO lit_vpl VALUES ("PR28_25","021_28_25","PRO","28","25","25","Kas yra išdidžios širdies, sukelia vaidus; bet, kas pasitiki VIEŠPAČIU, bus praturtintas. ");
INSERT INTO lit_vpl VALUES ("PR28_26","021_28_26","PRO","28","26","26","Kas pasitiki savo širdimi, yra kvailys, bet kas išmintingai elgiasi, tas bus išvaduotas. ");
INSERT INTO lit_vpl VALUES ("PR29_1","021_29_1","PRO","29","1","1","Dažnai peikiamas žmogus, kuris užkietina savo sprandą, bus staiga nukirstas – ir neišgydomai. ");
INSERT INTO lit_vpl VALUES ("PR29_2","021_29_2","PRO","29","2","2","Teisiesiems įsigalint, tauta džiaugiasi, bet nedorėliui valdant, tauta dejuoja. ");
INSERT INTO lit_vpl VALUES ("PR29_3","021_29_3","PRO","29","3","3","Kas myli išmintį, džiugina savo tėvą, bet kas bičiulauja su paleistuvėmis, eikvoja savo turtą. ");
INSERT INTO lit_vpl VALUES ("PR29_4","021_29_4","PRO","29","4","4","Karalius teisingumu įtvirtina šalį, bet kas ima kyšius, ją sugriauna. ");
INSERT INTO lit_vpl VALUES ("PR29_5","021_29_5","PRO","29","5","5","Žmogus, kuris pataikauja savo artimui, ištiesia tinklą jo kojoms. ");
INSERT INTO lit_vpl VALUES ("PR29_15","021_29_15","PRO","29","15","15","Rykštelė ir pabarimas teikia išminties, bet vaikas, paliktas sau, daro gėdą savo motinai. ");
INSERT INTO lit_vpl VALUES ("PR29_18","021_29_18","PRO","29","18","18","Kur nėra Dievo duoto apreiškimo, tauta sulaukėja, bet kas laikosi įstatymo, tas palaimintas. ");
INSERT INTO lit_vpl VALUES ("PR29_21","021_29_21","PRO","29","21","21","Kas lepina savo tarną nuo mažens, tam jis galiausiai taps sūnumi. ");
INSERT INTO lit_vpl VALUES ("PR29_22","021_29_22","PRO","29","22","22","Piktas žmogus sukelia nesantaiką ir karštakošis pridaro daug nusižengimų. ");
INSERT INTO lit_vpl VALUES ("PR29_23","021_29_23","PRO","29","23","23","Žmogaus išdidumas jį nužemins, bet kas nuolankios dvasios, palaikys pagarbą. ");
INSERT INTO lit_vpl VALUES ("PR29_25","021_29_25","PRO","29","25","25","Žmonių baimė spendžia žabangus, bet kas pasitiki VIEŠPAČIU, bus saugus. ");
INSERT INTO lit_vpl VALUES ("PR30_1","021_30_1","PRO","30","1","1","Agūro, Jakės sūnaus žodžiai, pranašiškas pranešimas, šio žmogaus pasakymas Itieliui, būtent Itieliui ir Ukalui: ");
INSERT INTO lit_vpl VALUES ("PR30_5","021_30_5","PRO","30","5","5","Kiekvienas Dievo žodis yra grynas; jis yra skydas tiems, kurie juo pasitiki. ");
INSERT INTO lit_vpl VALUES ("PR30_6","021_30_6","PRO","30","6","6","Nieko nepridėk prie jo žodžių, kad jis tavęs nesubartų ir nebūtum įrodytas esant melagis. ");
INSERT INTO lit_vpl VALUES ("PR30_8","021_30_8","PRO","30","8","8","atitolink nuo manęs tuštybę ir melagystę; neduok man nei skurdo, nei turtingumo, mane aprūpink man reikalingu maistu, ");
INSERT INTO lit_vpl VALUES ("PR30_11","021_30_11","PRO","30","11","11","Yra karta, kuri keikia savo tėvą ir nelaimina savo motinos. ");
INSERT INTO lit_vpl VALUES ("PR30_12","021_30_12","PRO","30","12","12","Yra karta, kuri tyra savo akyse, bet kurios purvas nenuplautas. ");
INSERT INTO lit_vpl VALUES ("PR30_17","021_30_17","PRO","30","17","17","Akis, kuri tyčiojasi iš tėvo ir niekina paklusnumą motinai, bus slėnio varnų iškapota ir jaunų erelių sulesta. ");
INSERT INTO lit_vpl VALUES ("PR31_1","021_31_1","PRO","31","1","1","Karaliaus Lemuelio žodžiai, pranašiškas pranešimas, kurio jo motina pamokė jį: ");
INSERT INTO lit_vpl VALUES ("PR31_2","021_31_2","PRO","31","2","2","Ką, mano sūnau? Ir ką, mano įsčių sūnau? Ir ką, mano įžadų sūnau? ");
INSERT INTO lit_vpl VALUES ("PR31_3","021_31_3","PRO","31","3","3","Neatiduok savo šaunumo moterims, nė savo kelių tam dalykui, kuris sunaikina karalius. ");
INSERT INTO lit_vpl VALUES ("PR31_4","021_31_4","PRO","31","4","4","Ne karaliams, o Lemueli, ne karaliams gerti vyną, nė valdovams stiprų gėrimą. ");
INSERT INTO lit_vpl VALUES ("PR31_5","021_31_5","PRO","31","5","5","Priešingu atveju, toksai gers ir pamirš tai, kas buvo įsakyta, ir iškraipys teisingumą prispaustųjų atžvilgiu. ");
INSERT INTO lit_vpl VALUES ("PR31_6","021_31_6","PRO","31","6","6","Duokite stipraus gėrimo bepražūstančiam ir vyno tiems, kurie patys karčiai merdi. ");
INSERT INTO lit_vpl VALUES ("PR31_7","021_31_7","PRO","31","7","7","Toksai tegul geria ir pamiršta savo skurdą ir savo vargo tenebeatsimena. ");
INSERT INTO lit_vpl VALUES ("PR31_8","021_31_8","PRO","31","8","8","Atverk savo burną už tą, kuris pats už save negali kalbėti, tai yra už teises visų negalinčių apsiginti. ");
INSERT INTO lit_vpl VALUES ("PR31_9","021_31_9","PRO","31","9","9","Atverk savo burną, teisk teisingai ir gink varguolių bei vargšų teises. ");
INSERT INTO lit_vpl VALUES ("PR31_10","021_31_10","PRO","31","10","10","Kas gali rasti šaunią moterį? Juk jos vertė daug didesnė už brangakmenius. ");
INSERT INTO lit_vpl VALUES ("PR31_11","021_31_11","PRO","31","11","11","Jos vyro širdis visiškai pasitiki ja, ir jam neprireiks grobio. ");
INSERT INTO lit_vpl VALUES ("PR31_12","021_31_12","PRO","31","12","12","Ji darys jam gera, o ne bloga, per visas savo gyvenimo dienas. ");
INSERT INTO lit_vpl VALUES ("PR31_13","021_31_13","PRO","31","13","13","Ji ieško vilnos bei linų ir mielai darbuojasi savo rankomis. ");
INSERT INTO lit_vpl VALUES ("PR31_14","021_31_14","PRO","31","14","14","Ji yra kaip pirklių laivai: iš toli ji pargabena savo maistą. ");
INSERT INTO lit_vpl VALUES ("PR31_15","021_31_15","PRO","31","15","15","Ji ir keliasi, kai dar naktis, ir duoda maisto savo šeimynai bei dalį savo tarnaitėms. ");
INSERT INTO lit_vpl VALUES ("PR31_16","021_31_16","PRO","31","16","16","Ji apsvarsto lauką ir jį nuperka; savo rankų atlygiu ji įveisia vynuogyną. ");
INSERT INTO lit_vpl VALUES ("PR31_17","021_31_17","PRO","31","17","17","Ji sujuosia savo strėnas stiprybe ir sustiprina savo rankas. ");
INSERT INTO lit_vpl VALUES ("PR31_18","021_31_18","PRO","31","18","18","Ji jaučia, kad jos pelnas geras; jos žibintas neužgęsta naktį. ");
INSERT INTO lit_vpl VALUES ("PR31_19","021_31_19","PRO","31","19","19","Ji ištiesia savo rankas į verpstę, ir jos rankos laiko ratelį. ");
INSERT INTO lit_vpl VALUES ("PR31_20","021_31_20","PRO","31","20","20","Savo delną ji atidaro varguoliams ir ištiesia savo rankas stokojantiems. ");
INSERT INTO lit_vpl VALUES ("PR31_21","021_31_21","PRO","31","21","21","Ji nebijo sniego dėl savo šeimynos, nes visa jos šeimyna aprengta skaisčiai raudonais drabužiais. ");
INSERT INTO lit_vpl VALUES ("PR31_22","021_31_22","PRO","31","22","22","Ji pasigamina sau užtiesalų; jos apdaras – aukštos kokybės drobė ir purpuras. ");
INSERT INTO lit_vpl VALUES ("PR31_23","021_31_23","PRO","31","23","23","Jos vyras yra žinomas vartuose, kai jis posėdžiauja su šalies vyresniaisiais. ");
INSERT INTO lit_vpl VALUES ("PR31_24","021_31_24","PRO","31","24","24","Ji padaro ir parduoda ploną drobę, ir pristato juostų pirkliams. ");
INSERT INTO lit_vpl VALUES ("PR31_25","021_31_25","PRO","31","25","25","Stiprybė ir kilnumas – jos apdaras, ir ji džiaugiasi ateitimi. ");
INSERT INTO lit_vpl VALUES ("PR31_26","021_31_26","PRO","31","26","26","Ji atveria savo burną vadovaudamasi išmintimi, ir ant jos liežuvio – maloningumo įstatymas. ");
INSERT INTO lit_vpl VALUES ("PR31_27","021_31_27","PRO","31","27","27","Ji gerai prižiūri savo šeimynos takus ir nevalgo tinginystės duonos. ");
INSERT INTO lit_vpl VALUES ("PR31_28","021_31_28","PRO","31","28","28","Jos vaikai pakyla ir vadina ją palaiminta, jos vyras irgi giria ją: ");
INSERT INTO lit_vpl VALUES ("PR31_29","021_31_29","PRO","31","29","29","„Daug dukterų elgėsi šauniai, bet tu viršiji jas visas!“ ");
INSERT INTO lit_vpl VALUES ("PR31_30","021_31_30","PRO","31","30","30","Žavumas apgaulingas, ir grožis tuščias; bet moteris, kuri bijo VIEŠPATIES, bus giriama. ");
INSERT INTO lit_vpl VALUES ("PR31_31","021_31_31","PRO","31","31","31","Duokite jai jos rankų atlygį, ir jos darbai tegul giria ją vartuose. ");
INSERT INTO lit_vpl VALUES ("EC1_1","022_1_1","ECC","1","1","1","Mokytojo, Dovydo sūnaus, karaliaus Jeruzalėje, žodžiai. ");
INSERT INTO lit_vpl VALUES ("EC1_2","022_1_2","ECC","1","2","2","Tuštybių tuštybė! „sako Mokytojas. „Tuštybių tuštybė! Viskas tuštybė! ");
INSERT INTO lit_vpl VALUES ("EC1_3","022_1_3","ECC","1","3","3","Kokia pasiliekanti nauda žmogui iš viso jo varginančio darbo, kuriuo jis nusivargina po saule? ");
INSERT INTO lit_vpl VALUES ("EC1_4","022_1_4","ECC","1","4","4","Karta nueina ir karta ateina, bet žemė lieka per amžius. ");
INSERT INTO lit_vpl VALUES ("EC1_5","022_1_5","ECC","1","5","5","Ir saulė teka, ir saulė leidžiasi bei skuba į savo vietą, iš kur ji pateka. ");
INSERT INTO lit_vpl VALUES ("EC1_6","022_1_6","ECC","1","6","6","Vėjas pučia į pietus ir pasisuka į šiaurę, vis sukasi ir sukasi, ir grįžta vėjas pagal tą patį sukinį. ");
INSERT INTO lit_vpl VALUES ("EC1_7","022_1_7","ECC","1","7","7","Visos upės teka į jūrą, tačiau jūra neprisipildo. Į vietą, iš kurios upės išteka, ten jos vėl suteka. ");
INSERT INTO lit_vpl VALUES ("EC1_8","022_1_8","ECC","1","8","8","Visi dalykai vargina, žmogus nesugeba to išreikšti; akis žiūrėdama nepasisotina, ir ausis klausydama neprisipildo. ");
INSERT INTO lit_vpl VALUES ("EC1_9","022_1_9","ECC","1","9","9","Kas buvo, tas bus, ir kas buvo daroma, tas bus daroma, ir po saule nieko nėra nauja. ");
INSERT INTO lit_vpl VALUES ("EC1_10","022_1_10","ECC","1","10","10","Ar yra kas, apie kurį galima pasakyti: „Žiūrėk, tai šis tas nauja“? Tai jau buvo anksčiau per amžius, kurie buvo pirma mūsų. ");
INSERT INTO lit_vpl VALUES ("EC1_11","022_1_11","ECC","1","11","11","Nebeatsimenama tų dalykų, kurie anksčiau buvo, ir tų, kurie bus ateityje, neatsimins tie, kurie bus po to. ");
INSERT INTO lit_vpl VALUES ("EC1_12","022_1_12","ECC","1","12","12","Aš, Mokytojas, Jeruzalėje karaliavau Izraeliui. ");
INSERT INTO lit_vpl VALUES ("EC1_13","022_1_13","ECC","1","13","13","Ir nukreipiau savo širdį ieškoti ir tyrinėti išmintimi viską, kas darosi po dangumi; šį nuožmų darbą Dievas davė Adomo sūnums, kad juo užsiimtų. ");
INSERT INTO lit_vpl VALUES ("EC1_14","022_1_14","ECC","1","14","14","Mačiau visus darbus, kurie daromi po saule; ir štai viskas yra tuštybė ir dvasios varginimas. ");
INSERT INTO lit_vpl VALUES ("EC1_15","022_1_15","ECC","1","15","15","Kas kreiva, to neįmanoma ištiesinti; ir ko trūksta, to neįmanoma suskaičiuoti. ");
INSERT INTO lit_vpl VALUES ("EC1_16","022_1_16","ECC","1","16","16","Pats bendravau su savo širdimi, sakydamas: „Žiūrėk, tapau aš didžiu, įgijau daugiau išminties už visus, kurie pirma manęs buvo Jeruzalėje! Taip, mano širdis yra patyrusi daug išminties bei pažinimo“. ");
INSERT INTO lit_vpl VALUES ("EC1_17","022_1_17","ECC","1","17","17","Taigi, nukreipiau savo širdį pažinti išmintį ir pažinimą, kvailybę ir paikyybę. Supratau, kad ir tai yra dvasios varginimas. ");
INSERT INTO lit_vpl VALUES ("EC1_18","022_1_18","ECC","1","18","18","Nes kur yra daug išminties, ten yra daug sielvarto, ir kas didina savo pažinimą, tas didina savo skausmą. ");
INSERT INTO lit_vpl VALUES ("EC2_1","022_2_1","ECC","2","1","1","Širdyje sau tariau: „Ateik jau, išbandysiu tave linksmybe, taigi džiaukis malonumais“. Bet va – tai irgi tuštybė! ");
INSERT INTO lit_vpl VALUES ("EC2_2","022_2_2","ECC","2","2","2","Apie juoką sakiau: „Jis yra sukvailiojimas!“ Ir apie linksmybę: „Ką ji nuveikia?“ ");
INSERT INTO lit_vpl VALUES ("EC2_3","022_2_3","ECC","2","3","3","Tyrinėjau savo širdyje, ką reikštų vynu pritraukti savo kūną – tuo tarpu mano širdžiai vis vedant mane išmintimi – ir ką reikštų nusitverti kvailybę, kad suprasčiau, kas yra gera žmonių palikuonims, ką jie turėtų daryti po dangumi per tą savo gyvenimo dienų kiekį. ");
INSERT INTO lit_vpl VALUES ("EC2_4","022_2_4","ECC","2","4","4","Pasidariau didelių darbų: stačiausi namų, veisiausi vynuogynų; ");
INSERT INTO lit_vpl VALUES ("EC2_5","022_2_5","ECC","2","5","5","pasidariau sodų bei parkų ir juose pasodinau visokių vaisių medžių; ");
INSERT INTO lit_vpl VALUES ("EC2_6","022_2_6","ECC","2","6","6","pasidariau vandens tvenkinių, kad iš jų laistyčiau augančių medžių mišką; ");
INSERT INTO lit_vpl VALUES ("EC2_7","022_2_7","ECC","2","7","7","įsigijau tarnų bei tarnaičių ir turėjau savo namuose gimusiųjų tarnų. Taip pat turėjau daug gyvulių – didžiųjų galvijų ir mažųjų gyvulių – daugiau negu visų kitų, buvusių prieš mane Jeruzalėje. ");
INSERT INTO lit_vpl VALUES ("EC2_8","022_2_8","ECC","2","8","8","Taip pat prisirinkau sidabro bei aukso ir karaliams bei provincijoms būdingo turto. Apsirūpinau giesmininkais bei giesmininkėmis ir tuo, kas žmonių palikuonių pamėgta, ir daugybe muzikinių instrumentų. ");
INSERT INTO lit_vpl VALUES ("EC2_9","022_2_9","ECC","2","9","9","Taigi pasidariau didis ir viršijau visus buvusius prieš mane Jeruzalėje. Be to, dar mano išmintis pasiliko su manimi. ");
INSERT INTO lit_vpl VALUES ("EC2_10","022_2_10","ECC","2","10","10","Ir ko tik geidė mano akys, joms neatsakiau. Nesulaikiau savo širdies nuo jokio džiaugsmo. Juk mano širdis džiaugėsi iš viso mano triūso, tai tokia buvo mano dalis iš viso mano triūso. ");
INSERT INTO lit_vpl VALUES ("EC2_11","022_2_11","ECC","2","11","11","Paskui atkreipiau savo žvilgsnį į visus darbus, kuriuos padarė mano rankos, ir į triūsą, kuriuo nusivarginau dirbdamas, ir štai viskas buvo tuštybė ir dvasios varginimas, ir nėra jokios pasiliekančios naudos po saule. ");
INSERT INTO lit_vpl VALUES ("EC2_12","022_2_12","ECC","2","12","12","Ir atkreipiau savo žvilgsnį į išmintį, į kvailybę ir paikyybę; nes ką gali padaryti žmogus, kuris ateis po karaliaus? Tik tai, kas jau buvo daroma. ");
INSERT INTO lit_vpl VALUES ("EC2_13","022_2_13","ECC","2","13","13","Tada aš pamačiau, kad išmintis tiek pralenkia kvailystę, kiek šviesa pralenkia tamsą. ");
INSERT INTO lit_vpl VALUES ("EC2_14","022_2_14","ECC","2","14","14","Išmintingasis mato, kur eina, bet kvailys vaikšto tamsoje. Bet taip pat pastebėjau, kad vienodas įvykis atsitinka jiems visiems. ");
INSERT INTO lit_vpl VALUES ("EC2_15","022_2_15","ECC","2","15","15","Tada širdyje sau tariau: „Kaip atsitinka kvailiui, taip ir man įvyks, būtent man; tad kodėl aš buvau pernelyg išmintingas?“ Tada širdyje sau tariau, kad tai irgi tuštybė. ");
INSERT INTO lit_vpl VALUES ("EC2_16","022_2_16","ECC","2","16","16","Nes nėra nei išmintingojo, nei kvailojo išliekančio atminimo, nes ateities dienomis viskas jau bus užmiršta. Tad kaip miršta išmintingasis? Lygiai taip, kaip miršta kvailasis! ");
INSERT INTO lit_vpl VALUES ("EC2_17","022_2_17","ECC","2","17","17","Tad nekenčiau gyvenimo, nes nuožmus man pasidarė darbas, kuris daromas po saule, nes viskas yra tuštybė ir dvasios varginimas. ");
INSERT INTO lit_vpl VALUES ("EC2_18","022_2_18","ECC","2","18","18","Ir nekenčiau visų savo triūso vaisių, dėl kurių buvau triūsęs po saule, nes turiu tai palikti žmogui, kuris bus po manęs. ");
INSERT INTO lit_vpl VALUES ("EC2_19","022_2_19","ECC","2","19","19","Ir kas žino, ar jis bus išmintingas, ar kvailas? Tačiau jis valdys visus mano triūso vaisius, dėl kurių buvau triūsęs ir pritaikęs išmintį po saule. Tai irgi tuštybė! ");
INSERT INTO lit_vpl VALUES ("EC2_20","022_2_20","ECC","2","20","20","Todėl nusigręžiau, kad nuvilčiau savo širdį dėl visų triūso vaisių, dėl kurių buvau triūsęs po saule. ");
INSERT INTO lit_vpl VALUES ("EC2_21","022_2_21","ECC","2","21","21","Juk būna žmogus, kuris yra triūsęs išmintimi, pažinimu ir bešališkumu. Tačiau žmogui, kuris tuo nėra triūsęs, jis tai paliks jo daliai. Tai irgi tuštybė ir didelė blogybė! ");
INSERT INTO lit_vpl VALUES ("EC2_22","022_2_22","ECC","2","22","22","Nes ką gi žmogus gauna iš viso savo triūso ir iš savo širdies varginimo, kuriuo jis triūsė po saule? ");
INSERT INTO lit_vpl VALUES ("EC2_23","022_2_23","ECC","2","23","23","Nes visos jo dienos – sielvartai, ir jo darbas – širdgėla. Net naktį jo širdis neturi poilsio. Tai irgi tuštybė! ");
INSERT INTO lit_vpl VALUES ("EC2_24","022_2_24","ECC","2","24","24","Nieko nėra geriau žmogui, kaip valgyti ir gerti ir duoti savo sielai matyti gera savo triūse. Aš ir tai mačiau, kad tai yra iš Dievo rankos. ");
INSERT INTO lit_vpl VALUES ("EC2_25","022_2_25","ECC","2","25","25","Juk kas gali valgyti arba pajusti tai labiau už mane? ");
INSERT INTO lit_vpl VALUES ("EC2_26","022_2_26","ECC","2","26","26","Nes žmogui, kuris yra geras jo akyse, Dievas duoda išminties, pažinimo ir džiaugsmo, bet nusidėjėliui jis duoda vargingą darbą – rinkti ir krauti, kad šis duotų tam, kuris geras Dievo akyse. Nusidėjėliui tai irgi tuštybė ir dvasios varginimas. ");
INSERT INTO lit_vpl VALUES ("EC3_1","022_3_1","ECC","3","1","1","Viskam yra paskirtas metas, ir paskirtas laikas kiekvienam siekiui po dangumi: ");
INSERT INTO lit_vpl VALUES ("EC3_2","022_3_2","ECC","3","2","2","laikas gimti ir laikas mirti; laikas sodinti ir laikas išrauti, kas pasodinta; ");
INSERT INTO lit_vpl VALUES ("EC3_3","022_3_3","ECC","3","3","3","laikas žudyti ir laikas gydyti; laikas griauti ir laikas statyti; ");
INSERT INTO lit_vpl VALUES ("EC3_4","022_3_4","ECC","3","4","4","laikas verkti ir laikas juoktis; laikas gedėti ir laikas šokinėti; ");
INSERT INTO lit_vpl VALUES ("EC3_5","022_3_5","ECC","3","5","5","laikas mėtyti akmenis ir laikas surinkti akmenis; laikas apkabinti ir laikas vengti apkabinimo; ");
INSERT INTO lit_vpl VALUES ("EC3_6","022_3_6","ECC","3","6","6","laikas ieškoti ir laikas laikyti praradusiu; laikas laikyti ir laikas išmesti; ");
INSERT INTO lit_vpl VALUES ("EC3_7","022_3_7","ECC","3","7","7","laikas perplėšti ir laikas susiūti, laikas tylėti ir laikas kalbėti; ");
INSERT INTO lit_vpl VALUES ("EC3_8","022_3_8","ECC","3","8","8","laikas mylėti ir laikas nekęsti; laikas karui ir laikas taikai. ");
INSERT INTO lit_vpl VALUES ("EC3_9","022_3_9","ECC","3","9","9","Kokia gi pasiliekanti nauda dirbančiajam iš jo triūso? ");
INSERT INTO lit_vpl VALUES ("EC3_10","022_3_10","ECC","3","10","10","Mačiau užduotį, kurią Dievas davė žmonių palikuonims, kad ja užsiimtų. ");
INSERT INTO lit_vpl VALUES ("EC3_11","022_3_11","ECC","3","11","11","Jis padarė visus dalykus gražius kiekvieno skirtam laikui, jis taip pat įdėjo amžinybę į jų širdį taip, kad joks žmogus negali išsiaiškinti Dievo daromo darbo nuo pradžios iki galo. ");
INSERT INTO lit_vpl VALUES ("EC3_12","022_3_12","ECC","3","12","12","Supratau, kad nieko geresnio jiems nėra, kaip tik žmogui džiaugtis ir daryti gera savo gyvenime. ");
INSERT INTO lit_vpl VALUES ("EC3_14","022_3_14","ECC","3","14","14","Žinau, kad visa, ką daro Dievas, išliks amžinai: nieko negalima prie to pridėti, nieko negalima iš to atimti. Ir Dievas yra taip padaręs, kad jo bijotų. ");
INSERT INTO lit_vpl VALUES ("EC3_20","022_3_20","ECC","3","20","20","Visi eina į vieną vietą, visi yra iš dulkių, ir visi į dulkes sugrįžta. ");
INSERT INTO lit_vpl VALUES ("EC5_1","022_5_1","ECC","5","1","1","Elkis apdairiai, kai keli koją į Dievo namus, ir būk labiau pasiruošęs klausytis, negu atnašauti kvailių auką, nes jie nesusivokia, kad daro bloga. ");
INSERT INTO lit_vpl VALUES ("EC5_2","022_5_2","ECC","5","2","2","Nebūk ūmus savo burna, ir neleisk savo širdžiai skubiai tarti žodžio Dievo akivaizdoje, nes Dievas yra danguje, o tu žemėje. Todėl tavo žodžių tebūna nedaug. ");
INSERT INTO lit_vpl VALUES ("EC5_3","022_5_3","ECC","5","3","3","Juk sapnas atsiranda dėl daugybės vargingų darbų, ir kvailio neapgalvotas pasakymas dėl daugybės žodžių. ");
INSERT INTO lit_vpl VALUES ("EC5_10","022_5_10","ECC","5","10","10","Kas myli pinigus, nepasisotins pinigais, nė mylintis turtingumą – pelnu; tai irgi tuštybė! ");
INSERT INTO lit_vpl VALUES ("EC5_16","022_5_16","ECC","5","16","16","O tai irgi yra skaudi blogybė: kaip jis atėjo, lygiai taip nueis, tad kokia pasiliekanti nauda tam, kuris triūsė vėjais? ");
INSERT INTO lit_vpl VALUES ("EC7_2","022_7_2","ECC","7","2","2","Geriau eiti į gedulo namus, negu eiti į pokylių namus, nes toks kiekvieno žmogaus galas, ir gyvas žmogus tai dėsis į širdį. ");
INSERT INTO lit_vpl VALUES ("EC7_5","022_7_5","ECC","7","5","5","Geriau išgirsti išmintingojo pabarimą, negu klausytis kvailųjų dainos. ");
INSERT INTO lit_vpl VALUES ("EC7_6","022_7_6","ECC","7","6","6","Nes kaip erškėčių spragsėjimas po puodu, taip kvailio kvatojimasis. O tai irgi tuštybė! ");
INSERT INTO lit_vpl VALUES ("EC7_8","022_7_8","ECC","7","8","8","Geresnė reikalo pabaiga negu jo pradžia, kantri dvasia geresnė negu išpuikusi dvasia. ");
INSERT INTO lit_vpl VALUES ("EC7_9","022_7_9","ECC","7","9","9","Savo dvasioje nebūk greitas pykti, nes pyktis glūdi kvailių užantyje. ");
INSERT INTO lit_vpl VALUES ("EC7_13","022_7_13","ECC","7","13","13","Apsvarstyk Dievo darbą: kas gali ištiesinti, ką jis sukreivino? ");
INSERT INTO lit_vpl VALUES ("EC7_16","022_7_16","ECC","7","16","16","Neperdėk, laikydamasis normos, ir nepasirodyk pernelyg išmintingas! Kodėl turėtum save pražudyti? ");
INSERT INTO lit_vpl VALUES ("EC7_20","022_7_20","ECC","7","20","20","Nes nėra žemėje teisaus žmogaus, kuris atlikinėja gera ir nuodėmės nedaro. ");
INSERT INTO lit_vpl VALUES ("EC8_4","022_8_4","ECC","8","4","4","Kadangi karaliaus žodis turi galią, kas gali jam sakyti: „Kodėl taip darai?“ ");
INSERT INTO lit_vpl VALUES ("EC8_12","022_8_12","ECC","8","12","12","Nors nusidėjėlis šimtąkart atlikinėja bloga ir jo dienos prailgintos, vis dėlto aš žinau tikrai, kad bus gera Dievo bijantiems, kurie bijo jo akivaizdoje, ");
INSERT INTO lit_vpl VALUES ("EC9_10","022_9_10","ECC","9","10","10","Visa, ką tik tavo ranka aptinka nuveikti, jėga savąja tai nuveik, nes nėra nei veikimo, nei planavimo, nei pažinimo, nei išmintingumo kape-šeole, į kurį tu eini. ");
INSERT INTO lit_vpl VALUES ("EC10_1","022_10_1","ECC","10","1","1","Paleisk savo duoną ant vandenų paviršaus, nes tu ją rasi po daugelio dienų. ");
INSERT INTO lit_vpl VALUES ("EC10_20","022_10_20","ECC","10","20","20","Nekeik karaliaus net mintyse, ir nekeik turtuolio savo miegamajame; nes padangių paukštis nuneš tavo balsą, ir sparnuotis išduos žodį. ");
INSERT INTO lit_vpl VALUES ("EC11_6","022_11_6","ECC","11","6","6","Rytą sėk savo sėklą ir vakare neleisk ilsėtis savo rankai, nes nežinai ar šita, ar ana sėja pasiseks, ar abi bus vienodai geros. ");
INSERT INTO lit_vpl VALUES ("EC11_9","022_11_9","ECC","11","9","9","Džiaukis, jaunuoli, savo jaunystėje, ir tegul tavo širdis tave džiugina tavo jaunumės dienomis, ir vaikščiok savo širdies keliais ir savo akių regėjimu. Bet žinok, kad dėl visų šitų dalykų Dievas pristatys tave į teismą. ");
INSERT INTO lit_vpl VALUES ("EC11_10","022_11_10","ECC","11","10","10","Taigi, iš savo širdies pašalink sielvartą ir atitolink nuo savo kūno kančias, nes jaunatvė ir jaunystės aušra tėra tuštybė. ");
INSERT INTO lit_vpl VALUES ("EC12_1","022_12_1","ECC","12","1","1","Atsimink savo Kūrėją savo jaunystės dienomis, kol dar neateina blogosios dienos ir neprisiartina metai, apie kuriuos sakysi: „Man jie nepatinka!“ ");
INSERT INTO lit_vpl VALUES ("EC12_7","022_12_7","ECC","12","7","7","Tada dulkės sugrįš į žemę, kaip buvo, o dvasia sugrįš pas Dievą, kuris ją davė. ");
INSERT INTO lit_vpl VALUES ("EC12_8","022_12_8","ECC","12","8","8","Tuštybių tuštybė, – sako pamokslininkas, – visybė yra tuštybė. ");
INSERT INTO lit_vpl VALUES ("EC12_13","022_12_13","ECC","12","13","13","Visa išklausius, reikalo išvada tokia: bijok Dievo ir laikykis jo įsakymų, nes tai visa žmogaus pareiga, ");
INSERT INTO lit_vpl VALUES ("EC12_14","022_12_14","ECC","12","14","14","kadangi Dievas pristatys į teismą kiekvieną darbą, net kiekvieną paslėptą dalyką, ar jis būtų geras, ar blogas. ");
INSERT INTO lit_vpl VALUES ("SS2_4","023_2_4","SNG","2","4","4","Jis atvedė mane į pokylio namus, ir jo vėliava viršum manęs buvo meilė. ");
INSERT INTO lit_vpl VALUES ("SS2_7","023_2_7","SNG","2","7","7","Prisaikdinu jus, o Jeruzalės dukterys, gazelėmis ar lauko elnėmis: nežadinkite ir nesukelkite meilės, iki ji pati panorės prabusti! ");
INSERT INTO lit_vpl VALUES ("SS2_12","023_2_12","SNG","2","12","12","Gėlės pasirodė žemėje, atėjo paukščių čiulbėjimo metas, ir purplelio burkavimas girdimas mūsų šalyje. ");
INSERT INTO lit_vpl VALUES ("SS2_15","023_2_15","SNG","2","15","15","Sugaukite mums lapes, tas laputes, kurios gadina vynuogynus, nes mūsų vynuogynai žydi. ");
INSERT INTO lit_vpl VALUES ("IS1_3","024_1_3","ISA","1","3","3","Jautis pažįsta savo savininką ir asilas savo valdovo ėdžias; bet Izraelis nepažįsta, mano tauta nesupranta. ");
INSERT INTO lit_vpl VALUES ("IS1_9","024_1_9","ISA","1","9","9","Jei kareivijų VIEŠPATS nebūtų mums palikęs labai mažo likučio, mes būtume tapę kaip Sodoma ir būtume prilygę Gomorai. ");
INSERT INTO lit_vpl VALUES ("IS1_18","024_1_18","ISA","1","18","18","„Malonėkite ateiti ir spręskime bylą, „sako VIEŠPATS. „Nors jūsų nuodėmės tamsiai raudonos, taps baltos kaip sniegas; nors jos yra raudonos kaip purpuras, taps kaip vilna.“ ");
INSERT INTO lit_vpl VALUES ("IS2_5","024_2_5","ISA","2","5","5","O Jokūbo namai, ateikite ir vaikščiokime VIEŠPATIES šviesoje! ");
INSERT INTO lit_vpl VALUES ("IS4_6","024_4_6","ISA","4","6","6","Ir bus pastogė kaip ūksmė dieną nuo kepinančios kaitros, / ir kaip prieglauda bei slėptuvė nuo audros ir lietaus. ");
INSERT INTO lit_vpl VALUES ("IS5_27","024_5_27","ISA","5","27","27","tarp jų nebus nei pavargusio nei suklumpančio; nė vienas nesnaus nei miegos; nei jų strėnų juosta bus atsišta, nei jų apavo dirželis bus nutrauktas. ");
INSERT INTO lit_vpl VALUES ("IS6_1","024_6_1","ISA","6","1","1","Tais metais, kai mirė karalius Uzijas, mačiau Viešpatį, sėdintį aukštame ir pakeltame soste, ir jo apdaro šleifas pripildė šventyklą. ");
INSERT INTO lit_vpl VALUES ("IS6_2","024_6_2","ISA","6","2","2","Viršum jo stovėjo serafai; kiekvienas turėjo po šešis sparnus: dviem dengė savo veidą, dviem dengė savo kojas ir dviem skraidė. ");
INSERT INTO lit_vpl VALUES ("IS6_3","024_6_3","ISA","6","3","3","Ir vienas šaukė kitam, sakydamas: „Šventas, šventas, šventas yra Kareivijų VIEŠPATS; visa žemė pilna jo šlovės!“ ");
INSERT INTO lit_vpl VALUES ("IS6_4","024_6_4","ISA","6","4","4","Ir nuo šaukiančiojo balso svyravo durų staktos, ir namai prisipildė dūmų. ");
INSERT INTO lit_vpl VALUES ("IS6_5","024_6_5","ISA","6","5","5","Tada aš tariau: „Vargas man! Nes aš esu žuvęs, kadangi aš esu nešvarių lūpų žmogus ir gyvenu nešvarių lūpų tautos tarpe, nes mano akys matė Karalių, Kareivijų VIEŠPATĮ.“ ");
INSERT INTO lit_vpl VALUES ("IS6_9","024_6_9","ISA","6","9","9","Ir jis tarė: „Eik ir sakyk šitai tautai: ‚Klausyte klausykitės, tačiau nesupraskite, ir regėte regėkite, tačiau nesuvokite!‘ ");
INSERT INTO lit_vpl VALUES ("IS6_10","024_6_10","ISA","6","10","10","Nutukink šitos tautos širdį, jų ausis apsunkink ir jų akis užmerk, kad jie nematytų akimis, negirdėtų ausimis, nesuprastų savo širdimis ir neatsiverstų, ir nebūtų išgydyti!“ ");
INSERT INTO lit_vpl VALUES ("IS7_9","024_7_9","ISA","7","9","9","Samarija tėra Efraimo galva, o Remalijo sūnus tėra Samarijos galva. Jei netikėsite, tai neįsitvirtinsite. ");
INSERT INTO lit_vpl VALUES ("IS7_14","024_7_14","ISA","7","14","14","Todėl pats Viešpats duos jums ženklą: štai mergelė taps nėščia ir pagimdys sūnų ir pavadins jį vardu Imanuelis. ");
INSERT INTO lit_vpl VALUES ("IS8_13","024_8_13","ISA","8","13","13","Galybių VIEŠPATĮ – jį laikykite šventu! Jis gi – jūsų baimė, ir jis – jūsų išgąstis! ");
INSERT INTO lit_vpl VALUES ("IS8_17","024_8_17","ISA","8","17","17","O aš lauksiu VIEŠPATIES, kuris slepia savo veidą nuo Jokūbo namų, ir juo grįsiu savo viltis. ");
INSERT INTO lit_vpl VALUES ("IS8_19","024_8_19","ISA","8","19","19","Ir kai jie jums tars: „Kreipkitės į turinčius namų dvasių ir į žynius, kurie čirškia ir murmena“, – argi kuri nors tauta neturėtų kreiptis į savo Dievą?! Argi jie turėtų gyvųjų labui kreiptis į mirusiuosius?! ");
INSERT INTO lit_vpl VALUES ("IS8_20","024_8_20","ISA","8","20","20","Kreipkitės į įstatymą ir liudijimą: jeigu jie nekalba pagal šitą žodį, tai todėl, kad juose nėra šviesos. ");
INSERT INTO lit_vpl VALUES ("IS9_2","024_9_2","ISA","9","2","2","Tauta, vaikščiojanti tamsoje, išvydo didžią šviesą; gyvenantiems mirties šešėlio krašte nušvito šviesa. ");
INSERT INTO lit_vpl VALUES ("IS9_6","024_9_6","ISA","9","6","6","Nes kūdikis yra mums gimęs, sūnus yra mums duotas, ir valdžia bus ant jo peties, ir jis bus vadinamas Nuostabusis, Patarėjas, Galingasis Dievas, Amžinasis Tėvas, Taikos Kunigaikštis. ");
INSERT INTO lit_vpl VALUES ("IS9_7","024_9_7","ISA","9","7","7","Jo valdžios didėjimui ir taikai nebus galo Dovydo soste ir jo karalystėje, kad ją įkurtų ir palaikytų teisingumu ir teisumu nuo dabar ir per amžius. Kareivijų VIEŠPATIES uolus užsidegimas tai įvykdys. ");
INSERT INTO lit_vpl VALUES ("IS10_5","024_10_5","ISA","10","5","5","„Vargas Asirijai, mano pykčio vėzdui! Lazda jų rankoje – tai mano įtūžis. ");
INSERT INTO lit_vpl VALUES ("IS10_6","024_10_6","ISA","10","6","6","Aš pasiųsiu ją pas veidmainingą tautą ir prieš žmones, ant kurių turiu rūstauti; duosiu jai įsaką, kad prisigrobtų grobio ir prisiplėštų prisiplėšiamo turto ir kad juos sumindytų kaip gatvės purvą. ");
INSERT INTO lit_vpl VALUES ("IS11_1","024_11_1","ISA","11","1","1","Ir iš Jesės kelmo išdygs Atauga, ir iš jo šaknų išaugs Atžala. ");
INSERT INTO lit_vpl VALUES ("IS12_2","024_12_2","ISA","12","2","2","Štai Dievas yra mano išgelbėjimas! Aš pasitikėsiu ir nebijosiu, nes mano stiprybė ir mano giesmė yra VIEŠPATS JEHOVA, ir jis man tapo išgelbėjimu! ");
INSERT INTO lit_vpl VALUES ("IS12_3","024_12_3","ISA","12","3","3","Taigi, jūs su džiaugsmu semsite vandens iš išgelbėjimo šaltinių. ");
INSERT INTO lit_vpl VALUES ("IS12_5","024_12_5","ISA","12","5","5","Giedokite gyrių VIEŠPAČIUI, nes jis padarė didingų dalykų! Tebūna tai žinoma visoje žemėje. ");
INSERT INTO lit_vpl VALUES ("IS12_6","024_12_6","ISA","12","6","6","Krykštauk ir džiaugsmingai užtrauk gaidą, Siono gyventoja, nes didis yra tarp jūsų esantis Izraelio Šventasis! ");
INSERT INTO lit_vpl VALUES ("IS14_11","024_14_11","ISA","14","11","11","Nustumta žemyn į kapą tavo puikybė, tavo styginių instrumentų skambesys. Po tavimi lervos yra ištiestos tarsi guolis, ir kirmėlės tave apkloja. ");
INSERT INTO lit_vpl VALUES ("IS14_12","024_14_12","ISA","14","12","12","Kaip tu iškritai iš dangaus, o Liuciferi, aušros sūnau! Tu esi nukirstas žemėn, kuris nusilpninai tautas! ");
INSERT INTO lit_vpl VALUES ("IS14_13","024_14_13","ISA","14","13","13","Nes tu sakei savo širdyje: „Aš pakilsiu į dangų, aš iškelsiu savo sostą viršum Dievo žvaigždžių, ir aš atsisėsiu ant susirinkimo kalno Šiaurės tolimiausiose vietose, ");
INSERT INTO lit_vpl VALUES ("IS14_14","024_14_14","ISA","14","14","14","aš pakilsiu virš debesų aukštybių, aš prilygsiu Aukščiausiajam! ");
INSERT INTO lit_vpl VALUES ("IS14_15","024_14_15","ISA","14","15","15","Tačiau tu būsi nustumtas į pragarą, į tolimiausias duobės vietas. ");
INSERT INTO lit_vpl VALUES ("IS14_16","024_14_16","ISA","14","16","16","Tie, kurie tave matys, spoksos į tave ir apžiūrinės tave, klausdami: „Ar tai tas vyras, kuris sudrebino žemę, kuris sukrėtė karalystes, ");
INSERT INTO lit_vpl VALUES ("IS14_17","024_14_17","ISA","14","17","17","kuris pasaulį padarė kaip dykumą ir sugriovė jo miestus, kuris savo belaisvių nepaleido namo? ");
INSERT INTO lit_vpl VALUES ("IS17_7","024_17_7","ISA","17","7","7","Tą dieną žmogus atsižvelgs į savo Kūrėją, ir jo akys kryps į Izraelio Šventąjį. ");
INSERT INTO lit_vpl VALUES ("IS17_8","024_17_8","ISA","17","8","8","Ir jis neatsižvelgs į aukurus, savo rankų darbą, ir nebežiūrės į tai, ką padarė jo pirštai, nei į dievukstulpius, nei į saulės atvaizdus. ");
INSERT INTO lit_vpl VALUES ("IS25_1","024_25_1","ISA","25","1","1","O VIEŠPATIE, tu esi mano Dievas! Aš aukštinsiu tave, aš girsiu tavo vardą, nes tu padarei nuostabius dalykus, seniai sugalvotus patikimus ir neabejojamus planus. ");
INSERT INTO lit_vpl VALUES ("IS25_4","024_25_4","ISA","25","4","4","Nes tu buvai stiprybė bejėgiui, stiprybė stokojančiam jo varge, priebėga nuo audros, ūksmė nuo kaitros. Mat bauginančių galingųjų siautulys – kaip audra, atsimušianti į sieną. ");
INSERT INTO lit_vpl VALUES ("IS25_8","024_25_8","ISA","25","8","8","Jis pergalėje praris mirtį ir Viešpats JEHOVA nušluostys ašaras nuo visų veidų ir savo tautos gėdą jis pašalins nuo visos žemės, nes VIEŠPATS tai pasakė. ");
INSERT INTO lit_vpl VALUES ("IS25_9","024_25_9","ISA","25","9","9","Tądien jie sakys: „Štai mūsų Dievas, kurio laukėme, ir jis mus išgelbsti! Tai VIEŠPATS, kurio laukėme! Džiūgaukime ir linksminkimės dėl jo išgelbėjimo! ");
INSERT INTO lit_vpl VALUES ("IS26_3","024_26_3","ISA","26","3","3","Tu išlaikysi tobuloje ramybėje tą, kurio mąstymas nesvyruoja nuo tavęs, nes jis pasitiki tavimi. ");
INSERT INTO lit_vpl VALUES ("IS26_4","024_26_4","ISA","26","4","4","Pasitikėkite VIEŠPAČIU per amžius, nes VIEŠPATYJE JEHOVOJE yra amžina uola. ");
INSERT INTO lit_vpl VALUES ("IS26_8","024_26_8","ISA","26","8","8","Be to, mes laukėme tavęs, o VIEŠPATIE, tavo teismo nuosprendžių kelyje; siela žavisi tavo vardu ir tavo atminimu. ");
INSERT INTO lit_vpl VALUES ("IS27_5","024_27_5","ISA","27","5","5","Arba jis tegul priima mano stiprybę – tesudaro taiką su manimi! Taiką tesudaro su manimi! ");
INSERT INTO lit_vpl VALUES ("IS28_5","024_28_5","ISA","28","5","5","Tą dieną Kareivijų VIEŠPATS taps šlovingu vainiku bei puikia diadema savo tautos likučiui, ");
INSERT INTO lit_vpl VALUES ("IS28_16","024_28_16","ISA","28","16","16","Todėl taip sako Viešpats DIEVAS: „Štai aš dedu Sione pamatui Akmenį, išbandytą Akmenį, brangų kertinį Akmenį, tvirtą pamatą: kas tiki juo, tas neskubės. ");
INSERT INTO lit_vpl VALUES ("IS29_13","024_29_13","ISA","29","13","13","Todėl Viešpats tarė: „Kadangi ši tauta artinasi prie manęs savo burna ir savo lūpomis mane gerbia, bet savo širdį atitolino nuo manęs, ir jų baimę manęs tesudaro išmokyti žmonių įsakymai, ");
INSERT INTO lit_vpl VALUES ("IS29_24","024_29_24","ISA","29","24","24","Klaidžiojantys dvasia susipras, murmantieji priims pamokymą. ");
INSERT INTO lit_vpl VALUES ("IS30_18","024_30_18","ISA","30","18","18","Ir todėl VIEŠPATS lauks, kad jis būtų jums maloningas, ir todėl jis bus išaukštintas, kad jis jūsų pasigailėtų, nes VIEŠPATS yra teisingumo Dievas. Palaiminti visi, kurie jo laukia! ");
INSERT INTO lit_vpl VALUES ("IS30_19","024_30_19","ISA","30","19","19","O Siono tauta, gyvenanti Jeruzalėje, tu daugiau nebeverksi! Tavo šauksmui skambant, jis tikrai bus maloningas tau; kai tik jis išgirs, tau atsilieps. ");
INSERT INTO lit_vpl VALUES ("IS30_21","024_30_21","ISA","30","21","21","Ir kai nukrypsite į dešinę ar į kairę, tavo ausys girdės žodį, tau iš užnugario nurodantį: „Tas yra kelias; eikite juo.“ ");
INSERT INTO lit_vpl VALUES ("IS32_2","024_32_2","ISA","32","2","2","Ir žmogus bus lyg prieglobstis nuo vėjo ir lyg slėptuvė nuo audros, lyg vandens upeliai sausoje dykvietėje, kaip didžiulės uolos šešėlis saulės nudegintame krašte. ");
INSERT INTO lit_vpl VALUES ("IS32_7","024_32_7","ISA","32","7","7","Ir niekšo priemonės blogos; jis sumano nedorų planų, kad pražudytų varguolius melagingais žodžiais, net kai vargšas kalba teisybę. ");
INSERT INTO lit_vpl VALUES ("IS32_17","024_32_17","ISA","32","17","17","Teisumo poveikis bus taika, o teisumo padarinys – ramumas ir saugumas amžinai. ");
INSERT INTO lit_vpl VALUES ("IS32_18","024_32_18","ISA","32","18","18","Tada mano tauta gyvens ramioje buveinėje, saugiuose namuose, atvangiose atilsio vietose, ");
INSERT INTO lit_vpl VALUES ("IS33_5","024_33_5","ISA","33","5","5","VIEŠPATS yra išaukštintas, nes jis gyvena aukštybėse; Sioną pripildė teisingumo ir teisumo. ");
INSERT INTO lit_vpl VALUES ("IS33_6","024_33_6","ISA","33","6","6","Jisai bus jūsų laikų patvarumas – išgelbėjimo pilnatvės, išminties ir pažinimo lobis. VIEŠPATIES baimė – jo turtas! ");
INSERT INTO lit_vpl VALUES ("IS34_16","024_34_16","ISA","34","16","16","Suieškokite VIEŠPATIES knygoje ir skaitykite: nei vieno iš jų netrūks, nei vienas nepasiges savo patelės; nes tai įsakė mano burna, ir jo dvasia jas surinko. ");
INSERT INTO lit_vpl VALUES ("IS35_4","024_35_4","ISA","35","4","4","Sakykite bailiaširdžiams: „Būkite stiprūs, nebijokite! Štai jūsų Dievas kerštaudamas ateis, atlygindamas Dievas ateis ir jus išgelbės.“ ");
INSERT INTO lit_vpl VALUES ("IS35_10","024_35_10","ISA","35","10","10","Ir VIEŠPATIES išpirktieji sugrįš ir ateis į Sioną krykštaudami, ir amžina linksmybė liks jiems ant galvos. Jie įgis džiaugsmą ir linksmybę, sielvartas ir dejavimas bėgs šalin. ");
INSERT INTO lit_vpl VALUES ("IS38_17","024_38_17","ISA","38","17","17","Štai, kad būtų ramybė, man buvo skirta didelė kartybė. Bet tu mylėjai mano sielą išgelbėdamas ją iš naikinimo duobės, nes tu visas mano nuodėmes nusviedei sau už nugaros. ");
INSERT INTO lit_vpl VALUES ("IS38_20","024_38_20","ISA","38","20","20","VIEŠPATS pasiruošęs mane išgelbėti. Todėl grosime mano giesmes styginiais instrumentais per visas savo gyvenimo dienas prie VIEŠPATIES namų! ");
INSERT INTO lit_vpl VALUES ("IS39_8","024_39_8","ISA","39","8","8","Tada Chezekijas atsakė Izaijui: „VIEŠPATIES žodis, kurį man pasakei, yra geras.“ Jis taip pat pasakė: „Mano dienomis bus taika ir stabilumas.“ ");
INSERT INTO lit_vpl VALUES ("IS40_1","024_40_1","ISA","40","1","1","„Guoskite, guoskite mano tautą! – sako jūsų Dievas. – ");
INSERT INTO lit_vpl VALUES ("IS40_5","024_40_5","ISA","40","5","5","ir VIEŠPATIES šlovė bus apreikšta, ir visa žmonija drauge ją išvys, nes VIEŠPATIES burna tai kalbėjo“. ");
INSERT INTO lit_vpl VALUES ("IS40_6","024_40_6","ISA","40","6","6","Balsas tarė: „Šauk!“ Ir jis tarė: „Ką man šaukti?“ Kiekvienas kūnas yra žolė, ir visas jų grožis – kaip lauko gėlė. ");
INSERT INTO lit_vpl VALUES ("IS40_7","024_40_7","ISA","40","7","7","Žolė sudžiūsta, gėlė nuvysta, nes VIEŠPATIES dvasia pučia į ją. Iš tikrųjų tauta yra žolė. ");
INSERT INTO lit_vpl VALUES ("IS40_8","024_40_8","ISA","40","8","8","Žolė sudžiūsta, gėlė nuvysta, bet žodis nuo mūsų Dievo pasiliks per amžius. ");
INSERT INTO lit_vpl VALUES ("IS40_11","024_40_11","ISA","40","11","11","Kaip ganytojas jis ganys savo kaimenę, savo ranka surinks avinėlius, nešios juos prie krūtinės, švelniai vedžios žindančias avis. ");
INSERT INTO lit_vpl VALUES ("IS40_22","024_40_22","ISA","40","22","22","Tai jis, kuris sėdi viršum žemės skritulio, ir jos gyventojai atrodo kaip žiogai, kuris ištiesia dangus kaip užuolaidą ir išskleidžia juos tarsi gyvenamą palapinę, ");
INSERT INTO lit_vpl VALUES ("IS40_28","024_40_28","ISA","40","28","28","Ar tu nesi sužinojęs, ar tu nesi girdėjęs? Amžinasis Dievas, VIEŠPATS, visų žemės pakraščių Kūrėjas, nepailsta ir nepavargsta; jo supratimas neištiriamas. ");
INSERT INTO lit_vpl VALUES ("IS40_29","024_40_29","ISA","40","29","29","Jis duoda nuvargusiam jėgų ir bejėgiui daugina stiprybę. ");
INSERT INTO lit_vpl VALUES ("IS40_31","024_40_31","ISA","40","31","31","bet tie, kurie laukia VIEŠPATIES, atnaujins jėgas: jie pakils sparnais kaip ereliai, jie bėgs ir nepavargs, jie vaikščios ir nepails. ");
INSERT INTO lit_vpl VALUES ("IS41_10","024_41_10","ISA","41","10","10","Nebijok, nes aš esu su tavimi; nesidairyk baimingai, nes aš tavo Dievas. Aš sustiprinsiu tave ir tikrai padėsiu tau, aš tikrai laikysiu tave savo teisumo dešine. ");
INSERT INTO lit_vpl VALUES ("IS41_11","024_41_11","ISA","41","11","11","Štai visi, kurie buvo įsiutę prieš tave, gėdysis ir paraus iš sarmatos. Taps niekais ir pražus tie, kurie kovoja su tavimi. ");
INSERT INTO lit_vpl VALUES ("IS41_13","024_41_13","ISA","41","13","13","Nes aš, VIEŠPATS, tavo Dievas, laikau tavo dešinę ranką ir tau sakau: „Nebijok, aš tau padėsiu! ");
INSERT INTO lit_vpl VALUES ("IS42_1","024_42_1","ISA","42","1","1","„Štai mano Tarnas, kurį palaikau, mano išrinktasis, kuriuo gėrisi mano siela! Aš uždėjau ant jo savo Dvasią; jis iškels viešumon teisingumą tautoms. ");
INSERT INTO lit_vpl VALUES ("IS42_2","024_42_2","ISA","42","2","2","Jis nešauks ir nepakels savo balso, neduos girdėti gatvėje savo balso. ");
INSERT INTO lit_vpl VALUES ("IS42_3","024_42_3","ISA","42","3","3","Jis nenulauš palaužtos nendrės ir neužgesins gruzdančio dagčio; jis iškels viešumon teisingumą pagal tiesą. ");
INSERT INTO lit_vpl VALUES ("IS42_5","024_42_5","ISA","42","5","5","Taip sako Dievas, VIEŠPATS, tas, kuris sukūrė dangus ir juos ištiesė; tas, kuris ištiesė žemę ir tai, kas iš jos išauga; tas, kuris duoda alsavimą žmonėms ant jos ir dvasią joje vaikščiojantiems: ");
INSERT INTO lit_vpl VALUES ("IS42_8","024_42_8","ISA","42","8","8","Aš esu JEHOVA, tai mano vardas. Aš neduosiu savo garbės kitam, nei savo šlovės raižybos kūriniams. ");
INSERT INTO lit_vpl VALUES ("IS42_9","024_42_9","ISA","42","9","9","Štai ankstesnieji dalykai jau įvyko, ir aš skelbiu naujus dalykus; aš jums pranešu prieš jiems pasirodant. ");
INSERT INTO lit_vpl VALUES ("IS42_16","024_42_16","ISA","42","16","16","Vesiu akluosius jiems nežinomu keliu, juos vesiu jiems nepažįstamais takais. Tamsą prieš juos paversiu šviesa ir vingiuotus kelius tiesiais. Tokie yra dalykai, kuriuos darysiu ir jų neapleisiu. ");
INSERT INTO lit_vpl VALUES ("IS43_1","024_43_1","ISA","43","1","1","Bet dabar taip sako VIEŠPATS, kuris sukūrė tave, o Jokūbai, tai yra tas, kuris supavidalino tave, o Izraeli: „Nebijok, nes aš išpirkau tave, pašaukiau tave vardu, tu esi mano! ");
INSERT INTO lit_vpl VALUES ("IS43_2","024_43_2","ISA","43","2","2","Kai tu eisi per vandenis, aš būsiu su tavim, ir kai eisi per upes, jos tavęs nepaskandins. Kai žengsi per ugnį, nesudegsi, ir liepsna tavęs neapdegins. ");
INSERT INTO lit_vpl VALUES ("IS43_10","024_43_10","ISA","43","10","10","Jūs esate mano liudytojai, – sako VIEŠPATS, – ir mano tarnas, kurį išsirinkau, kad pažintumėte mane ir manimi tikėtumėte ir suprastumėte, jog aš esu tas. Pirma manęs nebuvo supavidalintas joks dievas ir po manęs jokio nebus. ");
INSERT INTO lit_vpl VALUES ("IS43_11","024_43_11","ISA","43","11","11","Aš, aš esu VIEŠPATS, ir be manęs nėra išgelbėtojo. ");
INSERT INTO lit_vpl VALUES ("IS43_25","024_43_25","ISA","43","25","25","Aš, aš esu tas, kuris išdildau tavo nusižengimus dėl savęs, ir tavo nuodėmių neatminsiu. ");
INSERT INTO lit_vpl VALUES ("IS44_3","024_44_3","ISA","44","3","3","Nes aš išliesiu vandens ant ištroškusios žemės ir sroves ant sausumos; išliesiu savo Dvasią ant tavo sėklos ir savo Palaimą ant tavo atžalų. ");
INSERT INTO lit_vpl VALUES ("IS44_24","024_44_24","ISA","44","24","24","Taip sako VIEŠPATS, tavo Ιšpirkėjas, ir tas, kuris tave pavidalino įsčiose: „Aš esu VIEŠPATS, kuris padarau visa, kuris vienas ištiesiau dangus, kuris niekam nepadedant išskleidžiau žemę, ");
INSERT INTO lit_vpl VALUES ("IS45_2","024_45_2","ISA","45","2","2","Aš pats eisiu pirma tavęs ir sulyginsiu kalnus. Žalvario duris sudaužysiu ir geležies užšovus nukaposiu. ");
INSERT INTO lit_vpl VALUES ("IS45_5","024_45_5","ISA","45","5","5","Aš esu VIEŠPATS, ir nėra kito – be manęs nėra Dievo! Aš apjuosiau tave, nors nepažįsti manęs, ");
INSERT INTO lit_vpl VALUES ("IS45_6","024_45_6","ISA","45","6","6","kad jie žinotų nuo saulės patekėjimo ir nuo vakarų, jog be manęs nėra kito. Aš esu VIEŠPATS, ir nėra kito! ");
INSERT INTO lit_vpl VALUES ("IS45_7","024_45_7","ISA","45","7","7","Aš pavidalinu šviesą ir sukuriu tamsą; aš darau gerovę ir sukuriu nelaimę; aš, VIEŠPATS, visa tai darau. ");
INSERT INTO lit_vpl VALUES ("IS45_17","024_45_17","ISA","45","17","17","Izraelis bus išgelbėtas VIEŠPATYJE amžinu išgelbėjimu! Jūs neturėsite gėdytis ir parausti iš sarmatos per amžių amžius! ");
INSERT INTO lit_vpl VALUES ("IS45_18","024_45_18","ISA","45","18","18","Nes taip sako VIEŠPATS, kuris sukūrė dangus – jis yra pats Dievas, kuris supavidalino žemę ir ją padarė; jis ją įtvirtino, jis sukūrė ją ne dykvietei būti, bet jis ją supavidalino apgyvendinimui: „Aš esu VIEŠPATS, ir nėra kito. ");
INSERT INTO lit_vpl VALUES ("IS45_22","024_45_22","ISA","45","22","22","Atsigręžkite į mane ir būsite išgelbėti, visi žemės pakraščiai, nes aš Dievas, ir nėra kito! ");
INSERT INTO lit_vpl VALUES ("IS47_2","024_47_2","ISA","47","2","2","Paimk girnas ir malk miltus! Atidenk savo plaukus, nuo kojų nutrauk banguotą drabužio dalį, apsinuogink šlaunis ir pereik per upes. ");
INSERT INTO lit_vpl VALUES ("IS47_3","024_47_3","ISA","47","3","3","Bus atidengtas tavo nuogumas, tai yra tavo gėda bus matoma. Aš atkeršysiu, ir nesusitiksiu su tavimi kaip įprastai su žmogumi susitinkama. ");
INSERT INTO lit_vpl VALUES ("IS47_4","024_47_4","ISA","47","4","4","Mūsų atpirkėjas yra kareivijų VIEŠPATS, jo vardas yra Izraelio Šventasis.l. ");
INSERT INTO lit_vpl VALUES ("IS48_8","024_48_8","ISA","48","8","8","Aišku, tu negirdėjai; aišku, nežinojai; aišku, nuo seno tavo ausis nebuvo atverta; nes aš žinojau, kad tu būtum pasielgęs labai neištikimai, ir nuo įsčių tave vadino nusižengėliu. ");
INSERT INTO lit_vpl VALUES ("IS48_18","024_48_18","ISA","48","18","18","O, kad tu būtum klausęs mano įsakymų! Tavo ramybė būtų buvusi kaip upė, ir tavo teisumas – kaip jūros bangos. ");
INSERT INTO lit_vpl VALUES ("IS48_22","024_48_22","ISA","48","22","22","„Nedorėliui nėra ramybės“, – sako VIEŠPATS. ");
INSERT INTO lit_vpl VALUES ("IS49_5","024_49_5","ISA","49","5","5","„O dabar, – sako VIEŠPATS, kuris nuo įsčių mane supavidalino būti jo Tarnu ir sugrąžinti Jokūbą jam, – nors Izraelis dar nesurinktas pas jį, būsiu šlovingas VIEŠPATIES akyse ir mano Dievas bus mano stiprybė – ");
INSERT INTO lit_vpl VALUES ("IS49_15","024_49_15","ISA","49","15","15","Ar gali moteris pamiršti savo žindomą vaiką, kad nepasigailėtų savo įsčių sūnaus? Net tokios gal ir pamirš, tačiau tavęs nepamiršiu aš. ");
INSERT INTO lit_vpl VALUES ("IS50_4","024_50_4","ISA","50","4","4","Viešpats DIEVAS davė man išmokytųjų liežuvį, kad gebėčiau žodžiu stiprinti nuvargusį. Kas rytą jis žadina, žadina man ausį, kad klausyčiausi kaip išmokytieji. ");
INSERT INTO lit_vpl VALUES ("IS50_5","024_50_5","ISA","50","5","5","Viešpats DIEVAS atvėrė man ausį, ir aš nemaištavau, atgal nesitraukiau. ");
INSERT INTO lit_vpl VALUES ("IS50_6","024_50_6","ISA","50","6","6","Savo nugarą daviau mušantiems ir savo skruostus – raunantiems man barzdą, aš neslėpiau savo veido nuo sugėdinimo ir spjaudymo. ");
INSERT INTO lit_vpl VALUES ("IS51_11","024_51_11","ISA","51","11","11","Ir VIEŠPATIES išpirktieji sugrįš ir ateis į Sioną krykštaudami, ir amžina linksmybė liks jiems ant galvos. Jie įgis džiaugsmą ir linksmybę, sielvartas ir dejavimas bėgs šalin. ");
INSERT INTO lit_vpl VALUES ("IS51_12","024_51_12","ISA","51","12","12","Aš, aš esu tas, kuris jus guodžia! Kas tu esi, kad bijai žmogaus, kuris miršta, ir adomiečio, kuris bus atiduotas kaip žolė, ");
INSERT INTO lit_vpl VALUES ("IS52_13","024_52_13","ISA","52","13","13","Štai mano Tarnas elgsis išmintingai, jis bus iškeltas, bus išaukštintas ir bus labai prakilnus. ");
INSERT INTO lit_vpl VALUES ("IS52_15","024_52_15","ISA","52","15","15","Taip jis apšlakstys daugelį tautų. Karaliai užčiaups savo burnas dėl jo, nes jie pamatys tai, ko niekada nebuvo jiems apsakyta, ir susimąstys apie tai, ko niekada nebuvo girdėję.“ ");
INSERT INTO lit_vpl VALUES ("IS53_1","024_53_1","ISA","53","1","1","Kas tikėjo girdima mūsų žinia, ir VIEŠPATIES ranka – kuriam ji buvo apreikšta? ");
INSERT INTO lit_vpl VALUES ("IS53_2","024_53_2","ISA","53","2","2","Nes jis išaugs jo akivaizdoje kaip ūglis ir kaip šaknis iš sausos žemės. Jis neturi nei geros formos, nei didingumo, ir kai žiūrime į jį, nėra išvaizdos, kad jo norėtume. ");
INSERT INTO lit_vpl VALUES ("IS53_3","024_53_3","ISA","53","3","3","Jis yra paniekintas ir žmonių atmestas, skausmų vyras, ligą pažįstąs, paniekintas kaip toks, nuo kurio slepiami veidai; jo aukštai nevertinome ir mes. ");
INSERT INTO lit_vpl VALUES ("IS53_4","024_53_4","ISA","53","4","4","Tikrai jis užnešė mūsų negalias ir nešiojo mūsų ligas, o mes jį laikėme ištiktu, Dievo smogtu ir kamuojamu. ");
INSERT INTO lit_vpl VALUES ("IS53_5","024_53_5","ISA","53","5","5","Tačiau jis buvo sužeistas dėl mūsų maištavimų, sumuštas dėl mūsų kalčių. Ant jo krito bausmė, kad mums būtų ramybė ir jo žaizdomis esame išgydyti. ");
INSERT INTO lit_vpl VALUES ("IS53_6","024_53_6","ISA","53","6","6","Mes visi buvome paklydę kaip avys, kiekvienas sukome į savo kelią, bet VIEŠPATS uždėjo ant jo mūsų visų kaltę. ");
INSERT INTO lit_vpl VALUES ("IS53_7","024_53_7","ISA","53","7","7","Jis buvo engiamas ir kamuojamas, tačiau jis neatvėrė savo burnos; kaip avinėlis, vedamas pjauti ir kaip avis, tylinti prieš savo kirpėjus, jis neatvėrė savo burnos. ");
INSERT INTO lit_vpl VALUES ("IS53_8","024_53_8","ISA","53","8","8","Jis buvo paimtas iš kalėjimo ir iš teismo. O kas iš jo kartos apmąstys? Nes jis buvo atkirstas nuo gyvųjų šalies, ant jo krito smūgis už mano tautos nusižengimą. ");
INSERT INTO lit_vpl VALUES ("IS53_12","024_53_12","ISA","53","12","12","Todėl aš duosiu jam dalį tarp didžiūnų, ir su galingaisiais jis pasidalys grobį – dėl to, kad jis atidavė savo sielą mirčiai ir buvo priskirtas prie maištininkų. Jis ir prisiėmė daugelio nuodėmę ir užtarė maištininkus. ");
INSERT INTO lit_vpl VALUES ("IS54_8","024_54_8","ISA","54","8","8","Išliedamas apmaudą, aš paslėpiau akimirksnį savo veidą nuo tavęs, tačiau su amžinu geranoriškumu tavęs pasigailėsiu,“ sako VIEŠPATS, tavo Išpirkėjas. ");
INSERT INTO lit_vpl VALUES ("IS54_13","024_54_13","ISA","54","13","13","Visi tavo vaikai bus VIEŠPATIES pamokyti ir didelė bus tavo vaikų ramybė. ");
INSERT INTO lit_vpl VALUES ("IS54_17","024_54_17","ISA","54","17","17","Joks ginklas, nukaltas tau pulti, neturės sėkmės, ir kiekvieną liežuvį, kuris kelsis teistis su tavimi, tu įrodysi esant kaltą. Toks yra VIEŠPATIES tarnų paveldas, ir jų teisumas yra iš manęs,“ – sako VIEŠPATS. ");
INSERT INTO lit_vpl VALUES ("IS55_1","024_55_1","ISA","55","1","1","„Ei, visi, kurie trokštate, ateikite prie vandenų, – ir kas neturi pinigų, – ateikite, pirkite ir valgykite! Taip, ateikite, pirkite vyno ir pieno be pinigų ir be užmokesčio! ");
INSERT INTO lit_vpl VALUES ("IS55_2","024_55_2","ISA","55","2","2","Kodėl jūs leidžiate pinigus už tai, kas nėra duona ir savo triūso atlygį už tai, kas nepasotina? Klausykite manęs atidžiai ir valgykite tai, kas gera, ir tesimėgauja jūsų siela riebumais. ");
INSERT INTO lit_vpl VALUES ("IS55_3","024_55_3","ISA","55","3","3","Palenkite savo ausį ir ateikite pas mane, klausykite, ir jūsų siela bus gyva! Ir aš patvirtinsiu su jumis amžiną sandorą – patikimą, didį gailestingumą Dovydui. ");
INSERT INTO lit_vpl VALUES ("IS55_6","024_55_6","ISA","55","6","6","Ieškokite VIEŠPATIES, kol galima jį rasti, šaukitės jo, kol jis arti! ");
INSERT INTO lit_vpl VALUES ("IS55_7","024_55_7","ISA","55","7","7","Nedorėlis tepalieka savo kelią ir neteisus žmogus savo mintis; teatsisuka jis į VIEŠPATĮ, ir jis jo pasigailės, tai yra, į mūsų Dievą, nes jis gausiai atleis. ");
INSERT INTO lit_vpl VALUES ("IS55_8","024_55_8","ISA","55","8","8","„Nes mano mintys – ne jūsų mintys, ir mano keliai – ne jūsų keliai, – sako VIEŠPATS, – ");
INSERT INTO lit_vpl VALUES ("IS55_9","024_55_9","ISA","55","9","9","nes kaip dangūs aukštesni už žemę, taip mano keliai aukštesni už jūsų kelius ir mano mintys – už jūsų mintis. ");
INSERT INTO lit_vpl VALUES ("IS55_11","024_55_11","ISA","55","11","11","taip bus ir mano žodis, kuris išeina iš mano burnos: jis nesugrįš pas mane bergždžias, bet įvykdys tai, ko aš noriu, ir bus sėkmingas tame, dėl ko jį siunčiu. ");
INSERT INTO lit_vpl VALUES ("IS56_5","024_56_5","ISA","56","5","5","Aš savo namuose ir savo sienų viduje duosiu jiems vietą, taip pat vardą, geresnį už sūnus ir dukteris; aš jiems duosiu amžiną vardą, kuris nebus sunaikintas. ");
INSERT INTO lit_vpl VALUES ("IS57_15","024_57_15","ISA","57","15","15","Nes taip sako Aukštasis ir Prakilnusis, turintis nuolatinę buveinę amžinybėje, kurio vardas yra Šventasis: „Aš turiu nuolatinę buveinę aukštoje ir šventoje vietoje, taip pat pas tą, kuris yra palaužtos ir nusižeminusios dvasios, kad atgaivinčiau nusižeminusiųjų dvasią ir atgaivinčiau palaužtųjų širdį. ");
INSERT INTO lit_vpl VALUES ("IS57_18","024_57_18","ISA","57","18","18","Aš mačiau jo kelius, bet aš išgydysiu jį ir vedžiosiu jį, taip pat grąžinsiu paguodos jam ir tiems, kurie raudojo dėl jo. ");
INSERT INTO lit_vpl VALUES ("IS57_19","024_57_19","ISA","57","19","19","Aš kuriu lūpų vaisių: Ramybė, ramybė esančiam toli ir esančiam arti! – sako VIEŠPATS, – ir aš jį išgydysiu. ");
INSERT INTO lit_vpl VALUES ("IS57_20","024_57_20","ISA","57","20","20","Bet nedorėliai yra kaip sudrumsta jūra, kai ji negali nurimti, kurios vandenys išmeta dumblą ir purvą. ");
INSERT INTO lit_vpl VALUES ("IS57_21","024_57_21","ISA","57","21","21","Nedorėliui nėra ramybės“, „sako mano Dievas. ");
INSERT INTO lit_vpl VALUES ("IS58_11","024_58_11","ISA","58","11","11","Ir VIEŠPATS visuomet tave vedžios, ir sausros išdegintose vietovėse tavo sielą pasotins, ir sustiprins tavo kaulus. Tu gi būsi kaip laistomas sodas, ir kaip versmė, kurios vandenys neišsenka. ");
INSERT INTO lit_vpl VALUES ("IS58_12","024_58_12","ISA","58","12","12","Ir kurie bus iš tavęs atstatys senuosius griuvėsius, tu iškelsi daugelio kartų pamatus, ir tave vadins spragų užtaisytoju, gyvenamų vietovių takų atstatytoju. ");
INSERT INTO lit_vpl VALUES ("IS59_1","024_59_1","ISA","59","1","1","Štai, VIEŠPATIES ranka nėra sutrumpėjusi, kad negalėtų išgelbėti, nei jo ausis apkurtusi, kad negalėtų išgirstų. ");
INSERT INTO lit_vpl VALUES ("IS59_2","024_59_2","ISA","59","2","2","Bet jūsų nedorybės atskyrė jus nuo jūsų Dievo ir jūsų nuodėmės paslėpė jo veidą, kad jis nesiklausytų. ");
INSERT INTO lit_vpl VALUES ("IS59_15","024_59_15","ISA","59","15","15","Taip pat tiesos trūksta, ir kas šalinasi nuo blogio, pasidaro grobiu. Ir VIEŠPATS matė ir jo akyse tai buvo bloga, kad nebuvo teisingumo. ");
INSERT INTO lit_vpl VALUES ("IS59_16","024_59_16","ISA","59","16","16","Ir jis matė, kad nebuvo žmogaus, ir nusistebėjo, kad nebuvo užtarėjo; todėl jo paties labui išgelbėjo jo paties ranka, ir jo teisumas jį palaikė. ");
INSERT INTO lit_vpl VALUES ("IS59_21","024_59_21","ISA","59","21","21","„O dėl manęs, šita yra mano sandora su jais, – sako VIEŠPATS. – Mano Dvasia, kuri yra ant tavęs, ir mano žodžiai, kuriuos įdėjau į tavo burną, nepasitrauks nuo tavo burnos, nei nuo tavo sėklos burnos, nei nuo tavo sėklos sėklos burnos nuo dabar ir per amžius,“ – sako VIEŠPATS. ");
INSERT INTO lit_vpl VALUES ("IS60_19","024_60_19","ISA","60","19","19","Saulė nebebus tau šviesa dieną, ir mėnulis nebešvies tau spindesiu, bet VIEŠPATS tau bus amžina šviesa, ir tavo Dievas – tavo šlovė. ");
INSERT INTO lit_vpl VALUES ("IS60_20","024_60_20","ISA","60","20","20","Tavo saulė nebenusileis ir tavo mėnulis nesudils, nes VIEŠPATS bus tau amžina šviesa ir tavo gedulo dienos pasibaigs. ");
INSERT INTO lit_vpl VALUES ("IS60_22","024_60_22","ISA","60","22","22","Mažutėlis pasidarys tūkstančiu ir menkutėlis – galinga tauta. Aš, VIEŠPATS, paties to įvykio laiku skubiai tai įvykdysiu. ");
INSERT INTO lit_vpl VALUES ("IS61_1","024_61_1","ISA","61","1","1","Viešpaties DIEVO Dvasia yra ant manęs, nes VIEŠPATS patepė mane skelbti gerą žinią romiesiems; jis mane siuntė apraišioti tų, kurių širdys sudužusios, skelbti belaisviams laisvę ir įkalintiems – kad kalėjimas atidarytas, ");
INSERT INTO lit_vpl VALUES ("IS61_2","024_61_2","ISA","61","2","2","skelbti VIEŠPATIES malonės metus ir mūsų Dievo keršto dieną, guosti visų gedinčių, ");
INSERT INTO lit_vpl VALUES ("IS61_3","024_61_3","ISA","61","3","3","sutvirtinti gedinčius Sione: duoti jiems vainiką vietoj pelenų, džiaugsmo aliejaus vietoj gedulo, gyriaus drabužį vietoj aptemusios dvasios, kad juos vadintų drūtais teisumo medžiais, VIEŠPATIES sodiniais, kad jis savo šlovę apreikštų. ");
INSERT INTO lit_vpl VALUES ("IS61_10","024_61_10","ISA","61","10","10","Tegul aš džiaugte džiaugsiuosi VIEŠPAČIU, tegul džiūgauja mano siela dėl mano Dievo, nes jis mane aprengė išgelbėjimo drabužiais, apsiautė mane teisumo apsiaustu, kaip kad jaunikis iškilmingai užsideda puošnų galvos apdangalą, ir nuotaka dabinasi papuošalais. ");
INSERT INTO lit_vpl VALUES ("IS63_9","024_63_9","ISA","63","9","9","Visuose jų varguose jis buvo varginamas, ir jo akivaizdos angelas juos išgelbėjo; dėl savo meilės ir savo pagailos jis išpirko juos, ir jis pakėlė juos, ir nešė juos per visas senų senovės dienas. ");
INSERT INTO lit_vpl VALUES ("IS64_6","024_64_6","ISA","64","6","6","Bet mes visi esame kaip nešvarusis, ir visi mūsų teisūs veiksmai yra kaip suteršti skudurai. Ir mes visi vystame kaip lapai, ir mūsų blogadarybės mus nuneša kaip vėjas. ");
INSERT INTO lit_vpl VALUES ("IS65_14","024_65_14","ISA","65","14","14","štai mano tarnai džiaugsmingai šūkaus iš širdies linksmumo, bet jūs šauksite iš skausmingos širdies ir staugsite iš palaužtos dvasios. ");
INSERT INTO lit_vpl VALUES ("IS65_24","024_65_24","ISA","65","24","24","Prieš jiems šaukiant, aš atsiliepsiu; jiems dar tebekalbant, aš išklausysiu. ");
INSERT INTO lit_vpl VALUES ("IS66_1","024_66_1","ISA","66","1","1","Taip kalba VIEŠPATS: „Dangus – mano sostas, o žemė – mano kojų suolelis. Tai kur namai, kuriuos man galėtumėte pastatyti, ir kur gi mano atilsio vieta? ");
INSERT INTO lit_vpl VALUES ("IS66_2","024_66_2","ISA","66","2","2","Nes visa tai sukūrė mano ranka, taip ir visa tai egzistuoja, – sako VIEŠPATS. „Bet aš skiriu dėmesį tam, kuris nuolankus, kurio dvasia sužalota ir kuris dreba nuo mano žodžio. ");
INSERT INTO lit_vpl VALUES ("IS66_13","024_66_13","ISA","66","13","13","Aš taip paguosiu jus, kaip vyrą, kurį guodžia jo motina; ir jūs būsite paguosti Jeruzalėje. ");
INSERT INTO lit_vpl VALUES ("JR3_22","025_3_22","JER","3","22","22","„Sugrįžkite, atsimetę vaikai! Išgydysiu jūsų atsimetimus! „Štai mes ateiname pas tave, nes tu esi VIEŠPATS, mūsų Dievas. ");
INSERT INTO lit_vpl VALUES ("JR4_4","025_4_4","JER","4","4","4","Apsipjaustykite VIEŠPAČIUI ir pašalinkite savo širdies prieodę, Judo žmonės ir Jeruzalės gyventojai, kad neišsiveržtų mano įtūžis kaip ugnis ir nedegtų neužgesinamai dėl jūsų darbų blogumo. ");
INSERT INTO lit_vpl VALUES ("JR6_16","025_6_16","JER","6","16","16","Taip kalba VIEŠPATS: „Stokitės ant kryžkelių ir žvalgykitės ir klauskitės senovės takų, kur yra gerasis kelias! Eikite juo ir rasite atilsį savo sieloms.“ Bet jie sakė: „Neisime!“ ");
INSERT INTO lit_vpl VALUES ("JR7_23","025_7_23","JER","7","23","23","Bet jiems įsakiau štai ką: ‚Pakluskite mano balsui, ir aš būsiu jūsų Dievas, o jūs būsite mano tauta, ir vaikščiokite visu tuo keliu, kuriuo eiti jums įsakau, kad jums gerai sektųsi.‘ ");
INSERT INTO lit_vpl VALUES ("JR8_6","025_8_6","JER","8","6","6","Aš klausiausi ir išgirdau, bet jie kalbėjo neteisingai; niekas neatgailavo dėl savo nedorybės, sakydamas: „Ką aš padariau?! Kiekvienas nusisuko į savo bėgimo taką, kaip žirgas, šuoliais lekiantis į mūšį. ");
INSERT INTO lit_vpl VALUES ("JR9_23","025_9_23","JER","9","23","23","Taip sako VIEŠPATS: „Išmintingasis tenesigiria savo išmintimi ir galingasis tenesigiria savo galia, turtingasis tenesigiria savo turtais, ");
INSERT INTO lit_vpl VALUES ("JR9_24","025_9_24","JER","9","24","24","bet štai kuo tesigiria tas, kuris giriasi turėdamas supratimą ir pažindamas mane: kad aš esu VIEŠPATS, kuris įgyvendinu mielaširdystę, teisingumą ir teisumą žemėje; nes tais dalykais aš gėriuosi“, – sako VIEŠPATS. ");
INSERT INTO lit_vpl VALUES ("JR10_6","025_10_6","JER","10","6","6","Nes kito tokio, kaip tu, o VIEŠPATIE, nėra! Didingas tu ir didingas tavo vardo galybė! ");
INSERT INTO lit_vpl VALUES ("JR10_10","025_10_10","JER","10","10","10","Bet VIEŠPATS yra tikrasis Dievas, jis yra gyvasis Dievas ir amžinasis karalius; žemė drebės nuo jo rūstybės, tautos gi nepajėgia ištverti jo įtūžio. ");
INSERT INTO lit_vpl VALUES ("JR10_12","025_10_12","JER","10","12","12","Jis padarė žemę savo jėga, jis įtvirtino pasaulį savo išmintimi, ir ištiesė dangus savo supratimu. ");
INSERT INTO lit_vpl VALUES ("JR10_23","025_10_23","JER","10","23","23","Aš žinau, VIEŠPATIE, kad ne nuo žmogaus priklauso jo kelias ir kad ne nuo asmens priklauso galia eiti ir nustatyti kryptį savo žingsniams. ");
INSERT INTO lit_vpl VALUES ("JR10_24","025_10_24","JER","10","24","24","O VIEŠPATIE, drausmink mane, tačiau saikingai, ne rūstaudamas, kad nesutrintum manęs į nieką. ");
INSERT INTO lit_vpl VALUES ("JR13_15","025_13_15","JER","13","15","15","Girdėdami supraskite ir klausykitės! Nesipuikuokite, nes kalbėjo VIEŠPATS! ");
INSERT INTO lit_vpl VALUES ("JR13_16","025_13_16","JER","13","16","16","Duokite šlovę VIEŠPAČIUI, savo Dievui, kol Jis neužleido tamsos ir kol dar neatsitrenkė jūsų kojos į aptemusius kalnus! O jums laukiant šviesos, jis pavers ją mirties šešėliu, pakeis į tirštą tamsybę. ");
INSERT INTO lit_vpl VALUES ("JR15_16","025_15_16","JER","15","16","16","Tavo žodžiai buvo surasti, ir aš juos valgiau, ir tavo žodis man buvo džiaugsmas ir mano širdies džiūgavimas, nes buvau vadinamas tavo vardu, o VIEŠPATIE, Galybių Dieve. ");
INSERT INTO lit_vpl VALUES ("JR17_5","025_17_5","JER","17","5","5","Taip sako VIEŠPATS: „Prakeiktas žmogus, kuris pasitiki žmogumi ir laiko mirtingą kūną savo stiprybe, ir kurio širdis nukrypsta nuo VIEŠPATIES. ");
INSERT INTO lit_vpl VALUES ("JR17_7","025_17_7","JER","17","7","7","Palaimintas žmogus, kuris pasitiki VIEŠPAČIU, būtent VIEŠPATS yra jo užtikrintumas! ");
INSERT INTO lit_vpl VALUES ("JR17_9","025_17_9","JER","17","9","9","Širdis už viską klastingesnė ir neišgydomai nedora. Kas gali ją perprasti? ");
INSERT INTO lit_vpl VALUES ("JR17_14","025_17_14","JER","17","14","14","Gydyk mane, VIEŠPATIE, ir būsiu išgydytas; išgelbėk mane, ir būsiu išgelbėtas, nes tu esi mano gyrius. ");
INSERT INTO lit_vpl VALUES ("JR17_23","025_17_23","JER","17","23","23","Tačiau jie nepakluso ir nepalenkė savo ausies, bet sukietino savo sprandą, kad neklausytų ir nepriimtų pataisančio ugdymo. ");
INSERT INTO lit_vpl VALUES ("JR20_5","025_20_5","JER","20","5","5","Ir aš atiduosiu visus šito miesto išteklius, visą jo įgytą turtą, visas jo brangenybes, net visus Judo karalių lobius atiduosiu į rankas jų priešams, o jie juos apiplėš, grobį pasiims ir juos nugabens į Babiloną. ");
INSERT INTO lit_vpl VALUES ("JR20_11","025_20_11","JER","20","11","11","Bet VIEŠPATS yra su manimi kaip baimę keliantis nugalėtojas, todėl mano persekiotojai suklups ir nenugalės; jie bus labai sugėdinti, nes jiems nesiseks; jų amžina gėda niekada nebus pamiršta. ");
INSERT INTO lit_vpl VALUES ("JR23_6","025_23_6","JER","23","6","6","Jo dienomis Judas bus išgelbėtas ir Izraelis gyvens saugiai. Ir toks jo vardas, kuriuo jis bus vadinamas: VIEŠPATS – mūsų teisumas. ");
INSERT INTO lit_vpl VALUES ("JR23_23","025_23_23","JER","23","23","23","Argi aš esu Dievas iš arti, – sako VIEŠPATS, – bet ne Dievas iš toli? ");
INSERT INTO lit_vpl VALUES ("JR23_24","025_23_24","JER","23","24","24","Ar gali žmogus pasislėpti slaptose vietose, kad aš jo nematyčiau? – sako VIEŠPATS. – Argi ne aš pripildau dangų ir žemę? – sako VIEŠPATS. ");
INSERT INTO lit_vpl VALUES ("JR23_29","025_23_29","JER","23","29","29","– Argi mano žodis nėra kaip ugnis, – sako VIEŠPATS, – ir ar jis nėra kaip kūjis, kuris sutrupina uolą? ");
INSERT INTO lit_vpl VALUES ("JR24_7","025_24_7","JER","24","7","7","Ir duosiu jiems širdį, kad pažintų mane, jog aš esu VIEŠPATS. Ir jie bus mano tauta, o aš būsiu jų Dievas, nes jie visa širdimi atsigręš į mane. ");
INSERT INTO lit_vpl VALUES ("JR29_11","025_29_11","JER","29","11","11","Nes aš žinau mintis, kurias galvoju apie jus, – sako VIEŠPATS, – gerovės, o ne nelaimės, mintis, kad jums duočiau baigtį, kurios viliatės. ");
INSERT INTO lit_vpl VALUES ("JR29_13","025_29_13","JER","29","13","13","Ir ieškosite manęs ir rasite mane, kai visa širdimi manęs ieškosite. ");
INSERT INTO lit_vpl VALUES ("JR30_7","025_30_7","JER","30","7","7","Vargas! Ta diena gi tokia didinga, kad nėra jai lygios. Tai juk priespaudos laikas Jokūbui. Tačiau jis bus išgelbėtas iš jos. ");
INSERT INTO lit_vpl VALUES ("JR31_3","025_31_3","JER","31","3","3","Nuo seno man pasirodė VIEŠPATS, sakydamas: „Aš amžina meile tave mylėjau, todėl mielaširdiškumu aš pritraukiau tave. ");
INSERT INTO lit_vpl VALUES ("JR31_15","025_31_15","JER","31","15","15","Taip sako VIEŠPATS: „Triukšmas pasigirdo Ramoje, rauda, kartus verksmas. Rachelė verkdama savo vaikų nesileidžia guodžiama dėl savo vaikų, nes jų nebėra.“ ");
INSERT INTO lit_vpl VALUES ("JR31_34","025_31_34","JER","31","34","34","Ir jie nebemokys kiekvienas žmogus savo artimo ir kiekvienas žmogus savo brolio, sakydami: „Pažinkite VIEŠPATĮ!“, nes jie visi mane pažins, nuo jų mažiausiojo net iki jų didžiausiojo, – sako VIEŠPATS, – nes aš atleisiu jų kaltes ir jų nuodėmių nebeatminsiu.“ ");
INSERT INTO lit_vpl VALUES ("JR32_17","025_32_17","JER","32","17","17","Ak, Viešpatie DIEVE! Štai tu sukūrei dangus ir žemę savo didele jėga ir ištiesta ranka! Nieko tau nėra per sunkaus! ");
INSERT INTO lit_vpl VALUES ("JR32_27","025_32_27","JER","32","27","27","Štai aš esu VIEŠPATS, kiekvienos kūną turinčios būtybės Dievas. Argi yra man kas nors per sunku? ");
INSERT INTO lit_vpl VALUES ("JR33_3","025_33_3","JER","33","3","3","„Šaukis manęs, ir aš tau atsiliepsiu ir parodysiu tau didžių bei nepasiekiamų dalykų, kurių nežinai.“ ");
INSERT INTO lit_vpl VALUES ("JR45_5","025_45_5","JER","45","5","5","O tu, ar ieškai sau didelių dalykų? Neieškok! Nes štai netrukus aš atvesiu nelaimę visoms kūną turinčioms būtybėms, – sako VIEŠPATS, – bet tavo gyvybę aš tau duosiu kaip grobį visose vietose, kur tik eisi! ");
INSERT INTO lit_vpl VALUES ("LM2_20","026_2_20","LAM","2","20","20","Pažvelk, o VIEŠPATIE, ir žiūrėk atidžiai, kam tu taip padarei! Argi moterys valgys savo įsčių vaisių, glamonėjamus vaikus? Nejaugi kunigas ir pranašas turi būti nužudyti Viešpaties šventovėje? ");
INSERT INTO lit_vpl VALUES ("LM3_14","026_3_14","LAM","3","14","14","Aš buvau pajuoka visai savo tautai, jų pašaipos daina visą dieną. ");
INSERT INTO lit_vpl VALUES ("LM3_22","026_3_22","LAM","3","22","22","Dėl VIEŠPATIES gailestingumo gausybės mums neatėjo galas, nes jo apstus meilingumas nesibaigia – ");
INSERT INTO lit_vpl VALUES ("LM3_23","026_3_23","LAM","3","23","23","atsinaujina kas rytą. Didelė tavo ištikimybė! ");
INSERT INTO lit_vpl VALUES ("LM3_24","026_3_24","LAM","3","24","24","VIEŠPATS yra mano dalis, „sako mano siela, „todėl sudedu viltis į Jį. ");
INSERT INTO lit_vpl VALUES ("LM3_25","026_3_25","LAM","3","25","25","VIEŠPATS yra geras tiems, kurie jo laukia, jis geras tai sielai, kuri jo ieško. ");
INSERT INTO lit_vpl VALUES ("LM3_26","026_3_26","LAM","3","26","26","Gera ir sudėti viltis į VIEŠPATIES išgelbėjimą ir tyliai to laukti. ");
INSERT INTO lit_vpl VALUES ("LM3_33","026_3_33","LAM","3","33","33","nes jis ne iš širdies prispaudžia ir nuliūdina žmones. ");
INSERT INTO lit_vpl VALUES ("LM3_40","026_3_40","LAM","3","40","40","Ištirkime ir išmėginkime savo kelius ir gręžkimės į VIEŠPATĮ! ");
INSERT INTO lit_vpl VALUES ("LM3_51","026_3_51","LAM","3","51","51","Mano akis skaudina mano širdį dėl visų mano miesto dukterų. ");
INSERT INTO lit_vpl VALUES ("EK11_19","027_11_19","EZK","11","19","19","Ir aš duosiu jiems vieną širdį ir įdėsiu naują dvasią į jūsų vidų. Pašalinsiu akmeninę širdį iš jų kūno ir jiems duosiu minkštą širdį. ");
INSERT INTO lit_vpl VALUES ("EK14_6","027_14_6","EZK","14","6","6","Todėl sakyk Izraelio namams: „Taip sako Viešpats DIEVAS: „Atgailaukite ir gręžkitės nuo savo stabų ir nugręžkite savo veidus nuo visų savo bjaurybių. ");
INSERT INTO lit_vpl VALUES ("EK18_1","027_18_1","EZK","18","1","1","Man atėjo VIEŠPATIES žodis, sakydamas: ");
INSERT INTO lit_vpl VALUES ("EK18_2","027_18_2","EZK","18","2","2","„Kas jums yra?! Jūs pritaikote šią patarlę Izraelio šaliai, sakydami: „„Tėvai valgė rūgščių vynuogių, o vaikams dantys atšipo“? ");
INSERT INTO lit_vpl VALUES ("EK18_3","027_18_3","EZK","18","3","3","Kaip aš gyvas, „sako Viešpats DIEVAS, „jūs daugiau nepritaikysite šios patarlės Izraelyje! ");
INSERT INTO lit_vpl VALUES ("EK18_4","027_18_4","EZK","18","4","4","Štai visos sielos priklauso man; kaip tėvo siela, taip ir sūnaus siela priklauso man; siela, kuri nusideda, mirs. ");
INSERT INTO lit_vpl VALUES ("EK18_5","027_18_5","EZK","18","5","5","Bet jei žmogus yra teisus ir daro, kas teisinga ir teisu, ");
INSERT INTO lit_vpl VALUES ("EK18_10","027_18_10","EZK","18","10","10","Jeigu jis pagimdytų sūnų, kuris yra plėšikas, praliejantis kraują ir darantis ką panašaus į bet kurį iš šitų dalykų, ");
INSERT INTO lit_vpl VALUES ("EK18_14","027_18_14","EZK","18","14","14","ir štai jei jis pagimdys sūnų, kuris matys visas savo tėvo nuodėmes, kurias jis darė, ir praregėdamas, panašų dalykų ir nedarys, ");
INSERT INTO lit_vpl VALUES ("EK18_15","027_18_15","EZK","18","15","15","nebus nevalgęs alkuose ir nebus kėlęs akių į Izraelio namų stabus, nebus suteršęs savo artimo žmonos, ");
INSERT INTO lit_vpl VALUES ("EK18_16","027_18_16","EZK","18","16","16","ir nebus nė vieno engęs, nebus sulaikęs užstato ir nebus plėšęs grobio, bet bus savo duonos davęs alkanam ir apdengęs nuogą drabužiu, ");
INSERT INTO lit_vpl VALUES ("EK18_20","027_18_20","EZK","18","20","20","Tas asmuo, kuris nusideda, – turi mirti jis. Sūnus neturi kentėti už tėvo kaltę, nei tėvas neturi kentėti už sūnaus kaltę; teisiojo teisumas bus jam vienam įskaitytas, o nedorėlio nedorybė bus jam vienam įskaityta. ");
INSERT INTO lit_vpl VALUES ("EK18_32","027_18_32","EZK","18","32","32","Nes aš nenoriu mirštančiojo mirties, – sako Viešpats Jehova, – todėl atsigręžkite ir gyvuokite! ");
INSERT INTO lit_vpl VALUES ("EK28_11","027_28_11","EZK","28","11","11","Man dar atėjo VIEŠPATIES žodis, sakydamas: ");
INSERT INTO lit_vpl VALUES ("EK28_12","027_28_12","EZK","28","12","12","„Žmogaus sūnau, užtrauk raudą apie Tyro karalių ir jam sakyk: „Taip sako Viešpats DIEVAS: Tu antspauduotas etalonas, pilnas išminties ir tobulai gražus. ");
INSERT INTO lit_vpl VALUES ("EK28_13","027_28_13","EZK","28","13","13","Tu buvai Edene, Dievo sode. Visokie brangakmeniai apklojo tave: sardis, topazas, ir deimantas; berilis, oniksas, ir jaspis; safyras, smaragdas, ir raudonasis granatas; taip pat auksas, tavo būgnelių ir tavo dūdelių meistriškumas, buvo tavyje. Jie buvo paruošti tą dieną, kai buvai sukurtas. ");
INSERT INTO lit_vpl VALUES ("EK28_14","027_28_14","EZK","28","14","14","Tu esi pateptas kerubas, kuris dengia, taip aš tave paskyriau. Tu buvai šventajame Dievo kalne, vaikštinėjai tarp ugningų akmenų. ");
INSERT INTO lit_vpl VALUES ("EK28_15","027_28_15","EZK","28","15","15","Tu buvai nepriekaištingas savo keliuose nuo pat savo sukūrimo dienos, iki buvo atrasta tavyje blogis. ");
INSERT INTO lit_vpl VALUES ("EK28_16","027_28_16","EZK","28","16","16","Per tavo plačiąją prekybą jie pripildė tavo vidų smurto ir nusidėjai. Todėl išmesiu tave iš Dievo kalno kaip suterštą ir nuvarysiu tave, o dengiantis kerube, iš ugningų akmenų tarpo į pražūtį. ");
INSERT INTO lit_vpl VALUES ("EK28_17","027_28_17","EZK","28","17","17","Tavo širdis išpuiko dėl tavo grožio, tu sugadinai savo išmintį dėl savo spindesio. Aš numesiu tave žemėn, tave išstatysiu karalių akivaizdon, kad jie spoksotų į tave. ");
INSERT INTO lit_vpl VALUES ("EK28_18","027_28_18","EZK","28","18","18","Tu suteršei savo šventoves savo nusidėjimų daugybe, savo prekybos neteisybe, todėl iš tavo tarpo aš išgausiu ugnį. Ji surys tave, ir visų tave matančių akyse paversiu tave pelenais ant žemės. ");
INSERT INTO lit_vpl VALUES ("EK28_22","027_28_22","EZK","28","22","22","ir sakyk: „Taip sako Viešpats DIEVAS: Štai aš esu prieš tave, o Sidone, ir būsiu šlovinamas tavyje. Tada jie žinos, kad aš esu VIEŠPATS, kai jame įvykdysiu teisminius sprendimus ir būsiu laikomas šventu jame. ");
INSERT INTO lit_vpl VALUES ("EK33_11","027_33_11","EZK","33","11","11","Sakyk jiems: „Kaip aš gyvas, – sako Viešpats Jehova, – aš nenoriu nedorėlio mirties, bet noriu, kad nedorėlis nusigręžtų nuo savo kelio ir gyvuotų. Nusigręžkite, Nusigręžkite nuo savo nelabų kelių! Kodėl gi jūs turėtumėte mirti, o Izraelio namai?! ");
INSERT INTO lit_vpl VALUES ("EK33_20","027_33_20","EZK","33","20","20","Tačiau jūs sakote: „Viešpats elgiasi nelygiai! O Izraelio namai, pats teisiu kiekvieną iš jūsų pagal jo elgesį. ");
INSERT INTO lit_vpl VALUES ("EK34_15","027_34_15","EZK","34","15","15","Aš ganysiu savo kaimenę ir pats joms duosiu atsigulti, – sako Viešpats DIEVAS. ");
INSERT INTO lit_vpl VALUES ("EK34_26","027_34_26","EZK","34","26","26","Ir juos bei savo kalvos apylinkes padarysiu palaima: siųsiu lietų kaip tik laiku; tai bus palaimos liūtys. ");
INSERT INTO lit_vpl VALUES ("EK36_26","027_36_26","EZK","36","26","26","Ir aš duosiu jums naują širdį ir įdėsiu naują dvasią į jūsų vidų. Pašalinsiu akmeninę širdį iš jūsų kūno ir jums duosiu minkštą širdį. ");
INSERT INTO lit_vpl VALUES ("EK47_17","027_47_17","EZK","47","17","17","O riba bus nuo jūros iki Hacar Enono ties Damasko riba, ir šiaurėje į šiaurę yra Hamato krašto riba. Ta yra šiaurinė pusė. ");
INSERT INTO lit_vpl VALUES ("EK47_19","027_47_19","EZK","47","19","19","O pietinė pusė pietų link eis nuo Tamaros iki Meribos vandenų Kadeše, upe iki Didžiosios jūros. O tai yra pietinė pusė, nukreipta į pietus. ");
INSERT INTO lit_vpl VALUES ("DN1_1","028_1_1","DAN","1","1","1","Trečiaisiais Judo karaliaus Jehojakimo karaliavimo metais Babilono karalius Nebukadnecaras atžygiavo prie Jeruzalės ir apgulė ją. ");
INSERT INTO lit_vpl VALUES ("DN1_2","028_1_2","DAN","1","2","2","Viešpats atidavė į jo rankas Judo karalių Jehojakimą ir Dievo Namų indų dalį. Jis nugabeno juos į Šinaro šalį į savo dievo namus ir indus įnešė į savo dievo iždinę. ");
INSERT INTO lit_vpl VALUES ("DN1_3","028_1_3","DAN","1","3","3","Tuomet karalius įsakė Ašpenazui, savo eunuchų viršininkui, atvesti keletą iš Izraelio sūnų, iš karaliaus giminės ir iš kilmingųjų: ");
INSERT INTO lit_vpl VALUES ("DN1_4","028_1_4","DAN","1","4","4","jaunikaičius be jokios ydos, esančius gražios išvaizdos, sumanančius visokią išmintį, turinčius pažinimą ir suvokiančius mokslus, tokius, kurie pajėgūs tarnauti karaliaus rūmuose, ir juos išmokyti chaldėjų rašto ir kalbos. ");
INSERT INTO lit_vpl VALUES ("DN1_5","028_1_5","DAN","1","5","5","Karalius paskyrė jiems kasdienį davinį iš karaliaus ypatingo maisto ir vyno, kurį jis pats gėrė, o juos turėjo lavinti trejus metus, kad tam laikui pasibaigus jie galėtų tarnauti karaliaus akivaizdoje. ");
INSERT INTO lit_vpl VALUES ("DN1_6","028_1_6","DAN","1","6","6","Taigi tarp jų buvo iš Judo sūnų Danielius, Hananijas, Mišaelis ir Azarijas, ");
INSERT INTO lit_vpl VALUES ("DN1_7","028_1_7","DAN","1","7","7","kuriems eunuchų viršininkas davė vardus; jis gi Danielių praminė Beltšacaru, Hananiją – Šadrachu, Mišaelį – Mešachu ir Azariją – Abed Negu. ");
INSERT INTO lit_vpl VALUES ("DN1_8","028_1_8","DAN","1","8","8","Bet Danielius ryžosi savo širdyje nesiteršti karaliaus ypatingu maistu nė vynu, kurį jis gėrė, todėl eunuchų viršininkui teikė prašymą, kad pats nesiterštų. ");
INSERT INTO lit_vpl VALUES ("DN1_9","028_1_9","DAN","1","9","9","Ir Dievas suteikė Danieliui malonę ir širdingą prielankumą eunuchų viršininko akyse. ");
INSERT INTO lit_vpl VALUES ("DN1_10","028_1_10","DAN","1","10","10","Bet eunuchų viršininkas tarė Danieliui: „Aš bijau savo valdovo karaliaus, kuris jums paskyrė maistą ir gėrimą. Kodėl gi jis pamatytų jūsų veidus prasčiau atrodančius negu kitų jūsų amžiaus jaunikaičių? Taip pastatysite mano galvą pavojuje dėl karaliaus.“ ");
INSERT INTO lit_vpl VALUES ("DN1_11","028_1_11","DAN","1","11","11","Tada Danielius sakė prižiūrėtojui, kurį eunuchų viršininkas buvo paskyręs Danieliui, Hananijui, Mišaeliui ir Azarijui: ");
INSERT INTO lit_vpl VALUES ("DN1_12","028_1_12","DAN","1","12","12","„Prašom mėginti savo tarnus dešimt dienų. Tegul mums duoda daržovių valgyti ir vandens atsigerti. ");
INSERT INTO lit_vpl VALUES ("DN1_13","028_1_13","DAN","1","13","13","Po to tebus tamstos akivaizdoje apžiūrima mūsų išvaizda, taip pat išvaizda jaunikaičių, valgiusių karaliaus valgius ir, kaip tamsta pamatysi, taip daryk su savo tarnais.“ ");
INSERT INTO lit_vpl VALUES ("DN1_14","028_1_14","DAN","1","14","14","Taigi, jis sutiko su šiuo jų pasiūlymu ir mėgino juos dešimt dienų. ");
INSERT INTO lit_vpl VALUES ("DN1_15","028_1_15","DAN","1","15","15","Dešimčiai dienų praėjus, jų išvaizda atrodė gražesnė ir kūno atžvilgiu riebesnė negu visų jaunikaičių, valgiusių karaliaus valgius. ");
INSERT INTO lit_vpl VALUES ("DN1_16","028_1_16","DAN","1","16","16","Taigi prižiūrėtojas atsiimdavo jiems skirtą valgį ir vyną, kurį jie turėjo gerti, ir duodavo jiems daržovių. ");
INSERT INTO lit_vpl VALUES ("DN1_17","028_1_17","DAN","1","17","17","O štai dėl šitų keturių jaunikaičių – Dievas suteikė jiems visokio rašto bei mokslo išminties pažinimą ir įgūdžius; be to, Danielius suprato visokius regėjimus ir sapnus. ");
INSERT INTO lit_vpl VALUES ("DN1_18","028_1_18","DAN","1","18","18","Praėjus dienoms, po kurių karalius buvo įsakęs juos atvesti, eunuchų viršininkas atvedė juos pas Nebukadnecarą. ");
INSERT INTO lit_vpl VALUES ("DN1_19","028_1_19","DAN","1","19","19","Tada karalius kalbėjosi su jais, ir iš jų visų neatsirado nė vieno tokio kaip Danielius, Hananijas, Mišaelis ir Azarijas. Todėl jie tarnavo karaliui. ");
INSERT INTO lit_vpl VALUES ("DN1_20","028_1_20","DAN","1","20","20","Dėl kiekvieno išminties ir supratimo reikalo, apie kurį karalius juos klausinėjo, jis rado juos dešimt kartų pranašesnius už visus žynius ir kerėtojus, esančius visoje jo karalystėje. ");
INSERT INTO lit_vpl VALUES ("DN1_21","028_1_21","DAN","1","21","21","Taigi, Danielius išbuvo iki pirmųjų karaliaus Kyro metų. ");
INSERT INTO lit_vpl VALUES ("DN2_1","028_2_1","DAN","2","1","1","Antraisiais Nebukadnecaro karaliavimo metais Nebukadnecaras sapnavo sapnus ir jo dvasia sunerimo ir jis negalėjo miegoti. ");
INSERT INTO lit_vpl VALUES ("DN2_2","028_2_2","DAN","2","2","2","Tuomet karalius įsakė sušaukti žynius, kerėtojus, raganius ir chaldėjus, kad jie pasakytų karaliui jo sapnus. Todėl jie atėjo ir atsistojo karaliaus akivaizdoje. ");
INSERT INTO lit_vpl VALUES ("DN2_3","028_2_3","DAN","2","3","3","Karalius jiems tarė: „Sapnavau sapną, ir mano dvasia sunerimo, norėdama pažinti tą sapną.“ ");
INSERT INTO lit_vpl VALUES ("DN2_4","028_2_4","DAN","2","4","4","Tada chaldėjai kalbėjo karaliui aramėjiškai: „O karaliau, gyvuok amžinai! Pasakyk sapną savo tarnams, ir mes atskleisime reikšmę.“ ");
INSERT INTO lit_vpl VALUES ("DN2_5","028_2_5","DAN","2","5","5","Karalius atsakė ir tarė chaldėjams: „Yra išėjęs iš manęs įsakas: jei neatskleisite mano sapno ir jo reikšmės, jūs būsite sukapoti į gabalus ir jūsų namai bus paversti mėšlynu. ");
INSERT INTO lit_vpl VALUES ("DN2_6","028_2_6","DAN","2","6","6","Bet jei atskleisite sapną ir jo reikšmę, gausite iš manęs dovanų, atpildą, ir didžią garbę! Taigi atskleiskite man sapną ir jo reikšmę!“ ");
INSERT INTO lit_vpl VALUES ("DN2_7","028_2_7","DAN","2","7","7","Jie antrą kartą atsakė ir tarė: „Karalius tepasako sapną savo tarnams, ir mes atskleisime reikšmę!“ ");
INSERT INTO lit_vpl VALUES ("DN2_8","028_2_8","DAN","2","8","8","Karalius atsakė ir tarė: „Aš tikrai žinau, kad norite laimėti laiko, nes jūs matote, kad įsakas iš manęs yra išėjęs. ");
INSERT INTO lit_vpl VALUES ("DN2_9","028_2_9","DAN","2","9","9","Bet jei neatskleisite sapno, yra vienas įstatymas jums, nes susimokėte sakyti man melagingus ir klaidingus žodžius kol laikas pasikeis. Tad pasakykite man sapną, tada žinosiu, kad galite atskleisti jo reikšmę!“ ");
INSERT INTO lit_vpl VALUES ("DN2_10","028_2_10","DAN","2","10","10","Chaldėjai atsakė karaliaus akivaizdoje tardami: „Nėra žemėje žmogaus, kuris galėtų atskleisti karaliaus reikalą, nes joks karalius, viešpats ar valdovas nėra nieko panašaus reikalavęs iš bet kokio žynio, kerėtojo ar chaldėjo. ");
INSERT INTO lit_vpl VALUES ("DN2_11","028_2_11","DAN","2","11","11","Dalykas, kurio karalius reikalauja, yra išsiskiriantis. Tad nėra nieko kito, kas galėtų jį atskleisti karaliaus akivaizdoje, išskyrus dievus, kurių buveinė nėra tarp žmonių.“ ");
INSERT INTO lit_vpl VALUES ("DN2_12","028_2_12","DAN","2","12","12","Dėl to karalius labai įtūžo bei didžiai supyko ir įsakė sunaikinti visus Babilono išminčius. ");
INSERT INTO lit_vpl VALUES ("DN2_13","028_2_13","DAN","2","13","13","Ir buvo išleistas įstatymas išžudyti išminčius, ir jie ieškojo nužudyti Danielių bei jo draugus. ");
INSERT INTO lit_vpl VALUES ("DN2_14","028_2_14","DAN","2","14","14","Tada Danielius protingai ir taktiškai atsiliepė Arjochui, karaliaus sargybos vadui, kuris buvo išėjęs žudyti Babilono išminčius. ");
INSERT INTO lit_vpl VALUES ("DN2_15","028_2_15","DAN","2","15","15","Jis atsakė ir tarė karaliaus valdytojui Arjochui: „Kodėl iš karaliaus toks skubotas įstatymas?“ Tada Arjochas paaiškino reikalą Danieliui. ");
INSERT INTO lit_vpl VALUES ("DN2_16","028_2_16","DAN","2","16","16","Tuomet Danielius užėjo ir paprašė karalių duoti jam laiko, kad jis galėtų atskleisti karaliui reikšmę. ");
INSERT INTO lit_vpl VALUES ("DN2_17","028_2_17","DAN","2","17","17","Paskui Danielius parėjo į savo namus ir pranešė tą dalyką savo draugams Hananijui, Mišaeliui ir Azarijui, ");
INSERT INTO lit_vpl VALUES ("DN2_18","028_2_18","DAN","2","18","18","kad maldautų dangaus Dievą pasigailėjimo dėl šios paslapties, kad Danielius ir jo draugai nebūtų nužudyti su kitais Babilono išminčiais. ");
INSERT INTO lit_vpl VALUES ("DN2_19","028_2_19","DAN","2","19","19","Tada Danieliui nakties regėjime buvo apreikšta paslaptis ir Danielius šlovino dangaus Dievą. ");
INSERT INTO lit_vpl VALUES ("DN2_20","028_2_20","DAN","2","20","20","Danielius prabilo ir tarė: „Tebūna pašlovintas Dievo vardas nuo amžių per amžius, nes jo yra išmintis ir galybė! ");
INSERT INTO lit_vpl VALUES ("DN2_21","028_2_21","DAN","2","21","21","Jis gi keičia laikotarpius ir laikus, pašalina karalius ir įstato karalius, suteikia išminčiams išmintį ir išmanantiems išmanymą. ");
INSERT INTO lit_vpl VALUES ("DN2_22","028_2_22","DAN","2","22","22","Jis apreiškia gilybes ir paslaptis, žino, kas yra tamsoje, ir šviesa pasilieka su juo. ");
INSERT INTO lit_vpl VALUES ("DN2_23","028_2_23","DAN","2","23","23","Aš dėkoju tau ir giriu tave, mano tėvų Dieve, kuris suteikei man išminties ir stiprybės ir dabar man apreiškei, ko tavęs prašėme, nes atskleidei mums karaliaus dalyką.“ ");
INSERT INTO lit_vpl VALUES ("DN2_24","028_2_24","DAN","2","24","24","Dėl viso to Danielius užėjo pas Arjochą, kurį karalius buvo paskyęs išžudyti Babilono išminčius. Jis nuėjo ir taip jam tarė: „Nežudyk Babilono išminčių! Nuvesk mane pas karalių, ir aš atskleisiu karaliui reikšmę.“ ");
INSERT INTO lit_vpl VALUES ("DN2_25","028_2_25","DAN","2","25","25","Tada Arjochas skubiai atvedė Danielių pas karalių ir taip jam tarė: „Radau vyrą iš Judo tremtinių, kuris atskleis karaliui reikšmę.“ ");
INSERT INTO lit_vpl VALUES ("DN2_26","028_2_26","DAN","2","26","26","Karalius atsakė ir tarė Danieliui, kurio vardas Beltšacaras: „Ar tu gali man atskleisti sapną, kurį regėjau ir jo reikšmę?“ ");
INSERT INTO lit_vpl VALUES ("DN2_27","028_2_27","DAN","2","27","27","Danielius atsakė karaliaus akivaizdoje tardamas: „Paslapties, kurį karalius reikalauja, išminčiai, kerėtojai, žyniai ir spėjikai negali atskleisti karaliui, ");
INSERT INTO lit_vpl VALUES ("DN2_28","028_2_28","DAN","2","28","28","bet yra danguje Dievas, kuris apreiškia paslaptis ir atskleidžia karaliui Nebukadnecarui, kas įvyks vėlesnėmis dienomis. Toks buvo tavo sapnas ir tokie tavo galvos regėjimai tau gulint lovoje: ");
INSERT INTO lit_vpl VALUES ("DN2_34","028_2_34","DAN","2","34","34","Tu žiūrėjai, kol be rankų pagalbos buvo atkirstas akmuo, kuris smogė statulai į jos geležies ir molio pėdas ir sutrupino jas į šipulius. ");
INSERT INTO lit_vpl VALUES ("DN3_17","028_3_17","DAN","3","17","17","Jeigu taip yra, mūsų Dievas, kuriam tarnaujame, pajėgia mus išgelbėti iš ugnimi plieskiančios krosnies, ir jis mus išvaduos iš tavo rankų, o karaliau. ");
INSERT INTO lit_vpl VALUES ("DN6_26","028_6_26","DAN","6","26","26","Išleidžiu įsaką, kad kiekvienoje mano karalystės valdoje žmonės drebėtų ir bijotų Danieliaus Dievo akivaizdoje, nes jis yra gyvasis Dievas, tvirtas per amžius. Ir jo karalystė nesunaikinama, ir jo valdžia yra begalinė. ");
INSERT INTO lit_vpl VALUES ("DN7_13","028_7_13","DAN","7","13","13","Nakties regėjimuose stebėjau – štai atėjo su dangaus debesimis tarsi Žmogaus Sūnus. Jis priėjo prie Senaamžio, ir buvo jam pristatytas. ");
INSERT INTO lit_vpl VALUES ("DN8_1","028_8_1","DAN","8","1","1","Trečiaisiais karaliaus Belšacaro karaliavimo metais man, Danieliui, pasirodė regėjimas po ano, kuris man buvo pasirodęs pradžioje. ");
INSERT INTO lit_vpl VALUES ("DN8_2","028_8_2","DAN","8","2","2","Mačiau gi tame regėjime ir taip įvyko: matydamas pats ir buvau Šušane, rūmuose, esančiuose Elamo provincijoje – mačiau gi regėjime save esant prie Ulajo upės. ");
INSERT INTO lit_vpl VALUES ("DN8_3","028_8_3","DAN","8","3","3","Tada pakėliau savo akis ir pamačiau, ir štai priešais upę stovėjo avinas, turintis du ragus. Abu ragai buvo aukšti, bet vienas buvo aukštesnis už kitą, ir aukštesnysis išaugo vėliau. ");
INSERT INTO lit_vpl VALUES ("DN8_4","028_8_4","DAN","8","4","4","Mačiau aviną, badantį į vakarus, į šiaurę ir į pietus, ir jokie gyvuliai negalėjo atsilaikyti prieš jį, ir nebuvo jokio išvadavimo iš jo rankos, bet jis elgėsi, kaip jam patiko ir tapo didis. ");
INSERT INTO lit_vpl VALUES ("DN8_5","028_8_5","DAN","8","5","5","O aš – aš svarsčiau, ir štai ožys atėjo iš vakarų per visą žemės paviršių, nepaliesdamas žemė. Ožys turėjo įsidėmėtiną ragą tarp akių. ");
INSERT INTO lit_vpl VALUES ("DN8_6","028_8_6","DAN","8","6","6","O jis priėjo prie du ragus turinčio avino, kurį mačiau stovintį priešais upę, ir puolė jį smarkiai įnirtęs. ");
INSERT INTO lit_vpl VALUES ("DN8_7","028_8_7","DAN","8","7","7","Ir mačiau jį priartėjant prie avino ir, prieš jį įpykęs, jis smogė avinui ir nulaužė jo abu ragus, o avinas neturėjo jėgos atsilaikyti prieš jį, tai jis parbloškė jį ant žemės ir sutrypė jį, ir nebuvo nė vieno, kuris būtų galėjęs išvaduoti aviną iš jo rankos. ");
INSERT INTO lit_vpl VALUES ("DN8_11","028_8_11","DAN","8","11","11","Jis pasidarė didis net prieš kareivijos kunigaikštį ir nuo jo jis pašalino kasdienę auką ir ano šventyklos vieta buvo prablokštas žemėn. ");
INSERT INTO lit_vpl VALUES ("DN9_9","028_9_9","DAN","9","9","9","Viešpačiui, mūsų Dievui, priklauso apstus gailestingumas ir gausus atleidimas, nors mes maištavome prieš jį. ");
INSERT INTO lit_vpl VALUES ("DN9_27","028_9_27","DAN","9","27","27","Jis tvirtins sandorą su daugeliu vienai savaitei, o savaitės viduryje sustabdys aukojimą ir atnašavimą, net iki tokio lygio – niokotojo bjaurybių paskleidimo. O iki užbaigimo ir iš anksto nustatytas dalykas bus išlietas ant tai, kas išniokytas. ");
INSERT INTO lit_vpl VALUES ("DN10_19","028_10_19","DAN","10","19","19","Ir jis tarė: „Nebijok, didžiai mylimas žmogau, ramybė tau! Būk stiprus. Taip, būk stiprus! O jam bekalbant su manimi, aš buvau sustiprintas ir sakiau: „Malonėki kalbėti, mano viešpatie, nes tu mane sustiprinai. ");
INSERT INTO lit_vpl VALUES ("DN11_10","028_11_10","DAN","11","10","10","O jo sūnūs kariaus ir sutelks daugybę gausių karinių pajėgių ir vienas tikrai žygiuos pirmyn, užlies bei pereis kraštą ir vėl kariaus iki pat jo tvirtovės. ");
INSERT INTO lit_vpl VALUES ("DN11_32","028_11_32","DAN","11","32","32","Jis pataikūniškais žodžiais sužlugdys tuos, kurie nedoriai elgiasi prieš sandorą, bet žmonės, kurie pažįsta savo Dievą, bus stiprūs ir imsis žygių. ");
INSERT INTO lit_vpl VALUES ("DN11_37","028_11_37","DAN","11","37","37","Jis nekreips dėmesio nei į savo tėvų dievus, nei į moterų norimąjį, nei į jokį dievą, nes laikys save didesniu už visus. ");
INSERT INTO lit_vpl VALUES ("DN12_2","028_12_2","DAN","12","2","2","Ir žemės dulkėse miegančiųjų daugybė pabus: vieni – amžinam gyvenimui, o kiti – gėdai, amžinajai paniekai. ");
INSERT INTO lit_vpl VALUES ("DN12_3","028_12_3","DAN","12","3","3","O išmintingieji spindės taip, kaip dangaus skliautinės platybės spindesys, ir tie, kurie nukreipia daugelį į teisumą, – kaip žvaigždės per amžių amžius. ");
INSERT INTO lit_vpl VALUES ("DN12_10","028_12_10","DAN","12","10","10","Daugelis bus apvalyti, išbaltinti ir nuskaistinti, tačiau nedorėliai nedorai elgsis. Ir nė vienas nedorėlių nesupras, bet išmintingieji supras. ");
INSERT INTO lit_vpl VALUES ("DN12_11","028_12_11","DAN","12","11","11","Nuo to laiko, kai kasdienė auka bus pašalinta ir bus pastatyta išniekinanti bjaurybė, bus tūkstantis du šimtai devyniasdešimt dienų. ");
INSERT INTO lit_vpl VALUES ("HS2_23","029_2_23","HOS","2","23","23","Pasėsiu ją krašte sau pačiam, meilingai elgsiuosi su ta, kuri nebuvo sulaukusi meilingumo ir sakysiu ne savo tautai: „Tu mano tauta“, o jie atsakys: „Tu mano Dievas!“ ");
INSERT INTO lit_vpl VALUES ("HS6_1","029_6_1","HOS","6","1","1","„Eime ir grįžkime pas VIEŠPATĮ, nes jis sudraskė, jis mus ir išgydys; jis sužeidė, jis mus ir sutvarstys. ");
INSERT INTO lit_vpl VALUES ("HS6_3","029_6_3","HOS","6","3","3","Taigi, pažinkime – veržkimės pažinti – VIEŠPATĮ! Jo išėjimas yra parengtas įvykti kaip aušra, ir jis ateis pas mus kaip lietūs, kaip vėlyvasis lietus, kaip ankstyvasis lietus, kuris drėkina žemę.“ ");
INSERT INTO lit_vpl VALUES ("HS9_5","029_9_5","HOS","9","5","5","Ką darysite iškilmių dieną ir VIEŠPATIES šventės dieną? ");
INSERT INTO lit_vpl VALUES ("HS10_12","029_10_12","HOS","10","12","12","Sėkite sau teisumą, pjaukite pagal gailestingumą; plėškite dirvoną, nes jau laikas ieškoti VIEŠPATIES, kol jis ateis ir išlies ant jūsų teisumą. ");
INSERT INTO lit_vpl VALUES ("HS13_4","029_13_4","HOS","13","4","4","Tačiau tavo Dievas esu aš, VIEŠPATS, nuo Egipto šalies, ir tu neturi pažinti kito dievo, tik mane, nes be manęs nėra išgelbėtojo. ");
INSERT INTO lit_vpl VALUES ("HS14_2","029_14_2","HOS","14","2","2","Imkite su savimi žodžius ir grįžkite pas VIEŠPATĮ. Sakykite jam: „Pašalink visą kaltę ir priimk mus maloningai; taip mes atnašausime savo lūpų gyrių kaip veršius.“ ");
INSERT INTO lit_vpl VALUES ("JL2_13","030_2_13","JOL","2","13","13","Persiplėškite savo širdis, o ne savo drabužius! Gręžkitės į VIEŠPATĮ, savo Dievą, nes jis yra maloningas bei gailestingas, lėtas pykti bei kupinas gerumo ir jam gaila užtraukti nelaimę. ");
INSERT INTO lit_vpl VALUES ("JL2_28","030_2_28","JOL","2","28","28","Ir po to įvyks šitaip: aš išliesiu savo Dvasią ant visokių žmonių, ir jūsų sūnūs ir jūsų dukterys pranašaus, jūsų senieji sapnuos sapnus, jūsų jaunuoliai matys regėjimus, ");
INSERT INTO lit_vpl VALUES ("JL2_29","030_2_29","JOL","2","29","29","ir ant tarnų ir ant tarnaičių tomis dienomis išliesiu savo Dvasią. ");
INSERT INTO lit_vpl VALUES ("AM3_3","031_3_3","AMO","3","3","3","Argi gali du eiti kartu, jeigu jie nesutaria? ");
INSERT INTO lit_vpl VALUES ("AM6_3","031_6_3","AMO","6","3","3","Vargas jums, kurie išstumiate iš galvos mintį apie nelaimės dieną ir priartinate smurto valdymą; ");
INSERT INTO lit_vpl VALUES ("AM6_4","031_6_4","AMO","6","4","4","kurie atsilošiate ant dramblio kaulo lovų ir drybsote savo kušetėse ir valgote ėriukus, paimtus iš bandos, bei veršius iš gardo vidurio; ");
INSERT INTO lit_vpl VALUES ("OB1_1","032_1_1","OBA","1","1","1","Abdijo regėjimas. Taip sako Viešpats DIEVAS apie Edomą: Girdėjome žinią iš VIEŠPATIES, ir pasiuntinys yra pasiųstas kitataučiams: „Kilkite! O Kilkime į karą prieš jį!“ ");
INSERT INTO lit_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Ir VIEŠPATIES žodis atėjo Amitajo sūnui Jonai, sakydamas: ");
INSERT INTO lit_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Bet aš padėkos balsu tau aukosiu; tai, ką pažadėjau, ištesėsiu. Išgelbėjimas yra iš VIEŠPATIES! ");
INSERT INTO lit_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Ir antrą kartą VIEŠPATIES žodis atėjo Jonai, sakydamas: ");
INSERT INTO lit_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Taigi Jona pradėjo įeiti į miestą, eidamas vienos dienos kelionę, ir jis šaukė, sakydamas: „Dar keturiasdešimt dienų, ir Ninevė bus pargriauta!“ ");
INSERT INTO lit_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Tada Ninevės žmonės pasitikėjo Dievu ir paskelbė pasninką ir apsivilko ašutinėmis – nuo jų didžiausio iki jų mažiausio. ");
INSERT INTO lit_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","O ta žinia pasiekė Ninevės karalių, ir jis pakilo iš savo sosto, nusivilko savo apsiaustą, apsivilko ašutine ir atsisėdo pelenuose. ");
INSERT INTO lit_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Ir jis paskelbė ir pranešė Ninevėje karaliaus ir jo didžiūnų įsaku, būtent: „Nei žmonės, nei gyvuliai, nei galvijai, nei kaimenės nieko neturi ragauti, neturi ganytis, ir neturi gerti vandens. ");
INSERT INTO lit_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Bet žmonės ir gyvuliai turi būti apvilkti ašutinėmis ir stipriai šaukti Dievo! Ir kiekvienas turi nusigręžti nuo savo blogio kelio ir nuo smurto, kurį daro savo rankomis. ");
INSERT INTO lit_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Kas žino, gal Dievas apsigręš ir apsigalvojęs gailėsis, ir nusigręš nuo savo degančios rūstybės, ir mes nepražūsime? ");
INSERT INTO lit_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Ir Dievas pamatė jų veiksmus, kad jie nusigręžė nuo savo blogio kelio. Ir Dievas apsigalovjęs gailėjosi dėl nelaimės, kurią jis sakė jiems sukelsiąs, ir jis jos nesukėlė. ");
INSERT INTO lit_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Bet Jonai tai labai nepaprastai nepatiko, ir jis labai supyko. ");
INSERT INTO lit_vpl VALUES ("MC1_1","034_1_1","MIC","1","1","1","Morešetiečiui Michėjui atėjęs VIEŠPATIES žodis, kurį jis matė apie Samariją ir Jeruzalę Judo karalių Jotamo, Ahazo ir Chezekijo dienomis. ");
INSERT INTO lit_vpl VALUES ("MC3_4","034_3_4","MIC","3","4","4","Tada jie šauksis VIEŠPATIES, bet jis neatsakys jiems. Tuo metu jis net paslėps savo veidą nuo jų, atitinkamai su tuo, kaip jie nedorai elgėsi atlikdami savo darbus. ");
INSERT INTO lit_vpl VALUES ("MC4_5","034_4_5","MIC","4","5","5","Nors visos tautos – kiekvienas žmogus – vaikščioja savo dievo vardu, tačiau mes vaikščiosime VIEŠPATIES, savo Dievo, vardu per amžių amžius. ");
INSERT INTO lit_vpl VALUES ("MC4_8","034_4_8","MIC","4","8","8","O tu, kaimenės bokšte, Siono dukters tvirtove, pas tave ji ateis, būtent pirmoji valdžia įsitvirtins – Jeruzalės dukters karalystė! ");
INSERT INTO lit_vpl VALUES ("MC5_1","034_5_1","MIC","5","1","1","Dabar susiburk į pulkus, o pulkų dukterie! Jis mus apgulė! Lazda jie trenkia į žandą Izraelio teisėjui. ");
INSERT INTO lit_vpl VALUES ("MC5_2","034_5_2","MIC","5","2","2","Bet tu, Betliejau Efratoje, nors esi menkas tarp Judo tūkstančių, tačiau mano labui išeis iš tavęs tas, kuris bus valdovas Izraelyje, kurio išėjimai buvo nuo tolimos praeities, nuo amžinybės dienų. ");
INSERT INTO lit_vpl VALUES ("MC5_3","034_5_3","MIC","5","3","3","Todėl jis apleis juos iki laiko, kai gimdančioji bus pagimdžiusi. Tada jo likusieji broliai sugrįš pas Izraelio vaikus. ");
INSERT INTO lit_vpl VALUES ("MC5_4","034_5_4","MIC","5","4","4","Ir jis išstovės ir ganys VIEŠPATIES galia, VIEŠPATIES, savo Dievo, vardo didybe. Ir jie liks gyventi, nes tuomet jis bus laikomas didžiu iki žemės pakraščių. ");
INSERT INTO lit_vpl VALUES ("MC6_6","034_6_6","MIC","6","6","6","Kuo nešinas ateisiu VIEŠPATIES akivaizdon ir nusilenksiu prieš aukštybių Dievą? Ar man ateiti jo akivaizdon su deginamosiomis aukomis, su vienerių metų veršiais? ");
INSERT INTO lit_vpl VALUES ("MC6_7","034_6_7","MIC","6","7","7","Ar VIEŠPAČIUI patiks tūkstančiai avinų ar dešimtys tūkstančių aliejaus upelių? Ar man atiduoti savo pirmagimį už savo nusižengimą, savo kūno vaisių už savo sielos nuodėmę? ");
INSERT INTO lit_vpl VALUES ("MC6_8","034_6_8","MIC","6","8","8","Tau, žmogau, jis parodė, kas gera: ko gi VIEŠPATS reikalauja iš tavęs, jeigu ne tik daryti, kas teisinga, mylėti gailestingumą ir vaikščioti nuolankiai su savo Dievu? ");
INSERT INTO lit_vpl VALUES ("MC7_18","034_7_18","MIC","7","18","18","Kas yra toks Dievas, kaip tu, kuris pašalina kaltę ir atleidžia savo paveldo likučiui nusižengimą? Jis nelaiko savo pykčio amžinai, nes gėrisi gailestingumu. ");
INSERT INTO lit_vpl VALUES ("NM1_7","035_1_7","NAM","1","7","7","VIEŠPATS yra geras, tvirtovė bėdos dieną; jis gi pažįsta tuos, kurie juo pasitiki. ");
INSERT INTO lit_vpl VALUES ("HK1_13","036_1_13","HAB","1","13","13","Tavo akys per tyros, kad žvelgtum į blogį, ir tu negali žiūrėti į neteisybę; kodėl tu žiūri į klastūnus ir tyli, kai nedorėlis praryja teisesnį už save? ");
INSERT INTO lit_vpl VALUES ("HK2_4","036_2_4","HAB","2","4","4","Štai, jo pasipūtusi siela nėra tiesi jame, bet teisusis savo tikėjimu gyvens. ");
INSERT INTO lit_vpl VALUES ("HK2_15","036_2_15","HAB","2","15","15","Vargas tam, kuris duoda savo kaimynams gerti, kuris kiši savo indą, be to padaro girtus irgi, kad galėtum pamatyti jų nuogybę! ");
INSERT INTO lit_vpl VALUES ("HK3_17","036_3_17","HAB","3","17","17","Nors figmedis nežydėtų ir nebūtų vaisių vynmedžiuose, nors apviltų alyvmedžio derlius ir laukai neduotų maisto, nors kaimenė būtų iškirsta iš gardo, ir nebūtų galvijų tvartuose, ");
INSERT INTO lit_vpl VALUES ("HK3_18","036_3_18","HAB","3","18","18","vis dėlto aš džiūgausiu VIEŠPAČIU, džiaugsiuosi savo išgelbėjimo Dievu! ");
INSERT INTO lit_vpl VALUES ("HK3_19","036_3_19","HAB","3","19","19","VIEŠPATS Dievas yra mano stiprybė; jis padarys mano kojas kaip elnių ir vedžios mane mano aukštumose. Vyriausiajam muzikui, kad atliktų mano styginiais instrumentais. ");
INSERT INTO lit_vpl VALUES ("ZP1_8","037_1_8","ZEP","1","8","8","Ir tada, VIEŠPATIES aukos dieną, įvyks šitaip: aš gi nubausiu kunigaikščius ir karaliaus sūnus, ir visus, kurie apsirengia užsieniniu apdaru. ");
INSERT INTO lit_vpl VALUES ("ZP3_9","037_3_9","ZEP","3","9","9","Nes tada aš grąžinsiu tautoms tyrą kalbą, kad jos visos galėtų šauktis VIEŠPATIES vardo, petys į petį jam tarnauti. ");
INSERT INTO lit_vpl VALUES ("ZP3_16","037_3_16","ZEP","3","16","16","Tą dieną bus sakoma Jeruzalei: „Nebijok, o Sione, tenenusilpsta tavo rankos! ");
INSERT INTO lit_vpl VALUES ("HG2_5","038_2_5","HAG","2","5","5","Nebijokite turėdami žodį, kurį patvirtinau sudarydamas sandorą su jumis, kai jūs išėjote iš Egipto: mano Dvasia juk pasilieka tarp jūsų. ");
INSERT INTO lit_vpl VALUES ("HG2_7","038_2_7","HAG","2","7","7","ir sudrebinsiu visas tautas, ir ateis visų tautų trokštamasis, ir pripildysiu šituos namus šlovės, – sako kareivijų VIEŠPATS. ");
INSERT INTO lit_vpl VALUES ("ZC1_3","039_1_3","ZEC","1","3","3","Todėl sakyk jiems: „Taip kalba galybių VIEŠPATS: „Gręžkitės į mane, sako kareivijų VIEŠPATS, tai Aš gręšiuosi į jus, kalba kareivijų VIEŠPATS. ");
INSERT INTO lit_vpl VALUES ("ZC9_9","039_9_9","ZEC","9","9","9","Didžiai džiūgauk, o Siono dukterie! Šauk, o Jeruzalės dukterie! Štai tavo Karalius ateina pas tave! Jis teisus ir turintis išgelbėjimą, nusižeminęs ir jojantis ant asilo, ant asilaičio, asilės jauniklio. ");
INSERT INTO lit_vpl VALUES ("ZC10_12","039_10_12","ZEC","10","12","12","Ir jiems duosiu galybę VIEŠPATYJE, ir vaikštinės jo vardu“, – sako VIEŠPATS. ");
INSERT INTO lit_vpl VALUES ("ZC12_10","039_12_10","ZEC","12","10","10","ir ant Dovydo namų bei ant Jeruzalės gyventojų išliesiu malonės ir maldavimų Dvasią, ir jie žvelgs į mane, kurį jie perdūrė. Jie ir apraudos jį, kaip apraudama vienintelį sūnų, ir karčiai dejuos dėl jo, kaip karčiai dejuojama dėl pirmagimio. ");
INSERT INTO lit_vpl VALUES ("ZC13_1","039_13_1","ZEC","13","1","1","Tą dieną šaltinis bus atvertas Dovydo namams ir Jeruzalės gyventojams dėl nuodėmės ir dėl netyrumo. ");
INSERT INTO lit_vpl VALUES ("ZC14_9","039_14_9","ZEC","14","9","9","Ir VIEŠPATS bus visos žemės karalius; tą dieną bus vienas VIEŠPATS ir vienas jo vardas. ");
INSERT INTO lit_vpl VALUES ("ML2_10","040_2_10","MAL","2","10","10","Argi ne vieną tėvą mes visi turime? Argi ne vienas Dievas mus sukūrė? Kodėl mes klastingai elgiamės kiekvienas su savo broliu, padarydami nebešventą savo tėvų sandorą? ");
INSERT INTO lit_vpl VALUES ("ML3_1","040_3_1","MAL","3","1","1","„Štai aš siųsiu savo pasiuntinį, ir jis paruoš kelią pirma manęs. Ir staiga ateis į savo šventyklą Viešpats, kurio jūs ieškote, būtent sandoros pasiuntinys, kuriuo jūs gėritės, štai jis ateis“, – sako kareivijų VIEŠPATS. ");
INSERT INTO lit_vpl VALUES ("ML3_2","040_3_2","MAL","3","2","2","Tačiau, kas gali ištverti jo atėjimo dieną? Ir kas išsilaikys jam pasirodžius? Nes jis yra lyg metalų grynintojo ugnis ir lyg skalbėjų muilas, ");
INSERT INTO lit_vpl VALUES ("ML3_3","040_3_3","MAL","3","3","3","ir jis atsisės kaip sidabro grynintojas bei valytojas. Jis valys Levio sūnus ir juos nušveis kaip auksą ir sidabrą, kad jie būtų tokie, kurie aukoja aukas VIEŠPAČIUI teisingai. ");
INSERT INTO lit_vpl VALUES ("ML3_6","040_3_6","MAL","3","6","6","Kadangi aš esu VIEŠPATS, aš nesikeičiu; todėl jūs, Jokūbo sūnūs, nepražuvote. ");
INSERT INTO lit_vpl VALUES ("ML3_7","040_3_7","MAL","3","7","7","Jūs jau nuo savo tėvų dienų atsitraukėte nuo mano nuostatų ir jų nesilaikėte. Sugrįžkite pas mane, tai Aš sugrįšiu pas jus, – sako Galybių VIEŠPATS. „Bet jūs sakote: „Kaip mes sugrįšime? ");
INSERT INTO lit_vpl VALUES ("ML3_16","040_3_16","MAL","3","16","16","Tada tie, kurie bijojo VIEŠPATIES, dažnai kalbėjosi vienas su kitu; o VIEŠPATS tai dėmėjosi ir klausėsi, ir jo akivaizdoje buvo parašyta atminimo knyga labui tų, kurie bijojo VIEŠPATIES ir mąstė apie jo vardą. ");
INSERT INTO lit_vpl VALUES ("ML3_17","040_3_17","MAL","3","17","17","„Manąją veikimo dieną, – sako Kareivijų VIEŠPATS, – jie man bus ypatinga brangenybė, ir jų gailėsiuos, kaip žmogus gailisi savo sūnaus, kuris jam tarnauja.“ ");
INSERT INTO lit_vpl VALUES ("ML4_1","040_4_1","MAL","4","1","1","Nes štai ateina Diena, deganti kaip krosnis! Ir visi išdidieji ir visi, kurie elgiasi nedorai, taps ražienomis, ir juos taip sudegins ateinanti Diena, – sako Kareivijų VIEŠPATS, – kad ji nepaliks jiems nei šaknies, nei šakos. ");
INSERT INTO lit_vpl VALUES ("ML4_2","040_4_2","MAL","4","2","2","Bet jums, bijantiems mano vardo, užtekės Teisumo Saulė su išgydymu savo sparnuose. Jūs išeisite ir šokinėsite kaip veršiukai, išėję iš tvarto. ");
INSERT INTO lit_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jėzaus Kristaus, sūnaus Dovydo, sūnaus Abraomo, kilmės knyga. ");
INSERT INTO lit_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraomas pagimdė Izaoką, ir Izaokas pagimdė Jokūbą, ir Jokūbas pagimdė Judą ir jo brolius, ");
INSERT INTO lit_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ir Judas pagimdė Faresą ir Zarą iš Tamaros, ir Faresas pagimdė Esromą, ir Esromas pagimdė Aramą, ");
INSERT INTO lit_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ir Aramas pagimdė Aminadabą, ir Aminadabas pagimdė Naasoną, ir Naasonas pagimdė Salmoną, ");
INSERT INTO lit_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ir Salmonas pagimdė Boozą iš Rahabos, ir Boozas pagimdė Jobedą iš Rūtos, ir Jobedas pagimdė Jesę, ");
INSERT INTO lit_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ir Jesė pagimdė karalių Dovydą, ir karalius Dovydas pagimdė Saliamoną iš Ūrijo pačios, ");
INSERT INTO lit_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","ir Saliamonas pagimdė Roboamą, ir Roboamas pagimdė Abiją, ir Abija pagimdė Asą, ");
INSERT INTO lit_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ir Asa pagimdė Juozapatą, ir Juozapatas pagimdė Joramą, ir Joramas pagimdė Oziją, ");
INSERT INTO lit_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ir Ozijas pagimdė Joatamą, ir Joatamas pagimdė Achazą, ir Achazas pagimdė Ezekiją, ");
INSERT INTO lit_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ir Ezekijas pagimdė Manasą, ir Manasas pagimdė Amoną, ir Amonas pagimdė Joziją, ");
INSERT INTO lit_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ir Jozijas pagimdė Jechoniją ir jo brolius, kurie gyveno ištremimo į Babiloną metu. ");
INSERT INTO lit_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ir po ištrėmimo į Babiloną, Jechonijas pagimdė Salatielį, ir Salatielis pagimdė Zorobabelį, ");
INSERT INTO lit_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ir Zorobabelis pagimdė Abijudą, ir Abijudas pagimdė Eliakimą, ir Eliakimas pagimdė Azorą, ");
INSERT INTO lit_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","ir Azoras pagimdė Sadoką, ir Sadokas pagimdė Achimą, ir Achimas pagimdė Elijudą, ");
INSERT INTO lit_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ir Elijudas pagimdė Eleazarą, ir Eleazaras pagimdė Mataną, ir Matanas pagimdė Jokūbą, ");
INSERT INTO lit_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ir Jokūbas pagimdė Juozapą – vyrą Marijos, iš kurios gimė Jėzus, kuris yra vadinamas Kristumi. ");
INSERT INTO lit_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Taigi nuo Abraomo iki Dovydo – iš viso keturiolika kartų, ir nuo Dovydo iki ištrėmimo į Babiloną – keturiolika kartų, ir nuo ištrėmimo į Babiloną iki Kristaus – keturiolika kartų. ");
INSERT INTO lit_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Taigi Jėzaus Kristaus gimimas buvo toks: kai jo motina Marija buvo Juozapui pažadėta į žmonas, prieš jiems sueinant kartu, ji buvo rasta nėščia iš Šventosios Dvasios. ");
INSERT INTO lit_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Tuomet jos vyras Juozapas, būdamas teisus ir nenorėdamas jos viešai sugėdinti, buvo nusiteikęs slapčia nutraukti santuoką su ja. ");
INSERT INTO lit_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Bet, jam begalvojant apie tai, štai Viešpaties angelas pasirodė jam sapne, sakydamas: „Juozapai, Dovydo sūnau, nebijok pasiimti savo žmonos Marijos, nes tai, kas joje pradėta, yra iš Šventosios Dvasios. ");
INSERT INTO lit_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ir ji pagimdys sūnų, ir tu pavadinsi jį vardu Jėzus, nes jis išgelbės savo žmones iš jų nuodėmių.“ ");
INSERT INTO lit_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","O visa tai įvyko, kad išsipildytų tai, kas buvo Viešpaties pasakyta per pranašą, būtent: ");
INSERT INTO lit_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Štai mergelė taps nėščia ir pagimdys sūnų ir jie vadins jį vardu Emanuelis, kuris išvertus reiškia: Dievas su mumis. ");
INSERT INTO lit_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Tada Juozapas, pažadintas, padarė taip, kaip Viešpaties angelas buvo jam įsakęs, ir savo žmoną pasiėmė, ");
INSERT INTO lit_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","bet jos nepažino, iki ji pagimdė savo pirmagimį sūnų, ir jis pavadino jį vardu Jėzus. ");
INSERT INTO lit_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Tada, Jėzui gimus Judėjos Betliejuje karaliaus Erodo dienomis, štai atkeliavo į Jeruzalę išminčiai iš rytų ");
INSERT INTO lit_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","sakydami: „Kur yra gimusis žydų Karalius? Nes mes matėme jo žvaigždę rytuose ir atvykome jo pagarbinti.“ ");
INSERT INTO lit_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","O tai išgirdęs, sunerimo karalius Erodas, taip pat visa Jeruzalė su juo, ");
INSERT INTO lit_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","ir surinkęs visus tautos aukštuosius kunigus bei raštininkus, jis ne kartą teiravosi jų, kur turi gimti Kristus. ");
INSERT INTO lit_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ir jie tarė jam: „Judėjos Betliejuje, nes taip yra pranašo parašyta: ");
INSERT INTO lit_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","ir tu, Betliejau, Judo krašte, jokiu būdu nesi mažiausias tarp Judo kunigaikščių, nes iš tavęs ateis valdytojas, kuris ganys mano tautą Izraelį.“ ");
INSERT INTO lit_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Tada Erodas, slapčia pasikvietęs išminčius, tiksliai klausinėdamas iš jų sužinojo žvaigždės pasirodymo metą ");
INSERT INTO lit_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","ir juos siųsdamas į Betliejų, tarė: „Eikite ir kruopščiai ieškokite to vaikelio, ir kai jį surasite, praneškite man, kad ir aš nuvykęs jį pagarbinčiau.“ ");
INSERT INTO lit_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Išklausę karaliaus, jie iškeliavo. Ir štai žvaigždė, kurią jie matė rytuose, ėjo pirma jų, kol atėjusi sustojo viršum tos vietos, kur buvo vaikelis. ");
INSERT INTO lit_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Išvydę žvaigždę, jie džiaugėsi labai dideliu džiaugsmu. ");
INSERT INTO lit_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ir, įėję į namą, jie pamatė vaikelį su jo motina Marija ir parpuolę jį garbino. Ir atvėrę savo brangenybių dėžutes, jie pateikė jam dovanų: aukso ir smilkalų ir miros. ");
INSERT INTO lit_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ir sapne Dievo perspėti negrįžti pas Erodą, jie kitu keliu iškeliavo į savo kraštą. ");
INSERT INTO lit_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ir jiems iškeliavus, štai Viešpaties angelas pasirodo Juozapui sapne, sakydamas: „Kelkis, imk vaikelį bei jo motiną ir bėk į Egiptą, ir ten pasilik, kol tau pasakysiu, nes Erodas rengiasi ieškoti vaikelio, kad jį pražudytų.“ ");
INSERT INTO lit_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ir atsikėlęs jis nakčia pasiėmė vaikelį bei jo motiną ir pasitraukė į Egiptą ");
INSERT INTO lit_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ir ten išbuvo iki Erodo mirties, kad išsipildytų, kas Viešpaties buvo pasakyta per pranašą, būtent: Iš Egipto pašaukiau savo Sūnų. ");
INSERT INTO lit_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Tada Erodas, pamatęs, kad išminčiai jį išjuokė, baisiai įniršo ir pasiuntęs įgaliotinių išžudė visus berniukus, kurie buvo Betliejuje ir visoje jo apylinkėje, dviejų metų ir jaunesnius, pagal metą, kurį tiksliai klausinėdamas buvo sužinojęs iš išminčių. ");
INSERT INTO lit_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Tada išsipildė tai, kas buvo pranašo Jeremijo pasakyta, būtent: ");
INSERT INTO lit_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Triukšmas pasigirdo Ramoje, rauda ir verksmas ir didžiulis dejavimas: Rachele verkia savo vaikų ir nesileidžia guodžiama, nes jų nebėra. ");
INSERT INTO lit_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Bet, kai Erodas buvo miręs, štai Viešpaties angelas Egipte pasirodė Juozapui sapne, ");
INSERT INTO lit_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","sakydamas: „Kelkis ir pasiimk vaikelį bei jo motiną ir keliauk į Izraelio šalį, nes yra mirę tie, kurie tykojo vaikelio gyvybės“. ");
INSERT INTO lit_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ir atsikėlęs jis paėmė su savimi vaikelį bei jo motiną, ir atvyko į Izraelio šalį. ");
INSERT INTO lit_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Bet, kai jis išgirdo, kad Judėjai karaliauja Archelajas vietoj savo tėvo Erodo, pabūgo ten vykti. O sapne Dievo įspėtas, jis pasitraukė į Galilėjos sritį ");
INSERT INTO lit_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ir atvykęs apsigyveno mieste, vadinamame Nazaretu, kad išsipildytų, kas buvo pasakyta per pranašus: jį vadins Nazarėnu. ");
INSERT INTO lit_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Tomis dienomis pasirodo Jonas Krikštytojas, skelbdamas kaip šauklys Judėjos dykumoje ");
INSERT INTO lit_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ir sakydamas: „Atgailaukite, nes dangaus karalystė yra prisiartinusi!“ ");
INSERT INTO lit_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Tada išeidavo pas jį Jeruzalė ir visa Judėja, ir visas kraštas prie Jordano, ");
INSERT INTO lit_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ir išpažindami savo nuodėmes, jie būdavo jo krikštijami Jordane. ");
INSERT INTO lit_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Duokite tad vaisių, pritinkančių atgailai, ");
INSERT INTO lit_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","ir nemanykite sakyti savyje: „Mes kaip tėvą turime Abraomą. Nes aš jums sakau, kad Dievas pajėgia prikelti vaikų Abraomui iš šitų akmenų! ");
INSERT INTO lit_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Aš, žinoma, vandeniu jus krikštiju dėl atgailavimo, bet tas, kuris ateina po manęs, yra galingesnis už mane – jo apavų aš nevertas nešioti! Jisai krikštys jus Šventąja Dvasia ir ugnimi. ");
INSERT INTO lit_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Jo vėtyklė – jo rankoje, ir jis visiškai išvalys savo klojimą ir surinks savo kviečius į klėtį, bet jis sudegins pelus neužgesinama ugnimi.“ ");
INSERT INTO lit_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Tuomet ateina Jėzus iš Galilėjos prie Jordano pas Joną, kad būtų jo pakrikštytas. ");
INSERT INTO lit_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Bet Jonas mėgino jam neleisti, sakydamas: „Man reikia būti tavo pakrikštytam, o tu ateini pas mane?“ ");
INSERT INTO lit_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ir Jėzus atsakydamas jam tarė: „Leisk dabar, nes taip mums dera įvykdyti visą teisumą.“ Tada jis jam leido. ");
INSERT INTO lit_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ir kai jis buvo pakrikštytas, Jėzus tuoj pat ėjo aukštyn iš vandens; ir štai jam atsivėrė dangūs, ir jis pamatė Dievo Dvasią nusileidžiančią kaip balandį ir nutupiančią ant jo; ");
INSERT INTO lit_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","ir štai balsas iš dangaus prakalbo: „Šitas yra mano mylimasis Sūnus, kuriuo gėriuosi.“ ");
INSERT INTO lit_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Tada Jėzus buvo Dvasios nuvestas į dykumą, kad būtų velnio gundomas. ");
INSERT INTO lit_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","O išpasninkavęs keturiasdešimt dienų ir keturiasdešimt naktų, jis ilgainiui išalko. ");
INSERT INTO lit_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ir gundytojas, atėjęs pas jį, tarė: „Jeigu tu esi Dievo Sūnus, įsakyk, kad šie akmenys pavirstų duona. ");
INSERT INTO lit_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Bet jis atsakydamas tarė: „Yra parašyta: Žmogus gyvens ne vien duona, bet kiekvienu žodžiu, išeinančiu iš Dievo burnos.“ ");
INSERT INTO lit_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Tada velnias jį paima į šventąjį miestą ir pastato jį ant šventyklos viršūnės ");
INSERT INTO lit_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ir sako jam: „Jeigu tu esi Dievo Sūnus, meskis žemyn, nes yra parašyta: „Jis savo angelams įsakys apie tave, ir ant rankų jie nešios tave, kad niekada neužsigautum savo kojos į akmenį“. ");
INSERT INTO lit_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jėzus jam tarė: „Vėlgi yra parašyta: „Negundyk Viešpaties, savo Dievo“. ");
INSERT INTO lit_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Iš naujo velnias paima jį į labai aukštą kalną ir parodo jam visas pasaulio karalystes bei jų šlovę ");
INSERT INTO lit_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ir jam sako: „Visa tai duosiu tau, jei parpuolęs pagarbinsi mane.“ ");
INSERT INTO lit_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Tada Jėzus jam sako: „Eik šalin, Šėtone! Juk yra parašyta: „Garbink Viešpatį, savo Dievą, ir jam vienam tarnauk.“ ");
INSERT INTO lit_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Tada velnias jį palieka, ir štai atėjo angelai ir jam tarnavo. ");
INSERT INTO lit_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","O išgirdęs, kad Jonas įkalintas, Jėzus pasitraukė į Galilėją ");
INSERT INTO lit_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ir, palikęs Nazaretą, jis atėjo ir apsigyveno Kapernaume, prie jūros, Zabulono ir Neftalio pakraščiuose, ");
INSERT INTO lit_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","kad išsipildytų, kas buvo pasakyta per pranašą Izaiją, būtent: ");
INSERT INTO lit_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","ZABULONO KRAŠTAS IR NEFTALIO KRAŠTAS, PRIE JŪROS KELIO, ANAPUS JORDANO, KITATAUČIŲ GALILĖJA – ");
INSERT INTO lit_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","žmonės, kurie sėdėjo tamsoje, išvydo didžią Šviesą, ir tiems, kurie sėdėjo mirties krašte ir šešėlyje, užtekėjo Šviesa“. ");
INSERT INTO lit_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Nuo to laiko Jėzus pradėjo skelbti kaip šauklys sakydamas: „Atgailaukite, nes dangaus karalystė yra prisiartinusi! ");
INSERT INTO lit_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ir Jėzus, vaikščiodamas palei Galilėjos jūrą, pamatė du brolius – Simoną, vadinamą Petru, ir jo brolį Andriejų – metančius tinklą į jūrą; mat jie buvo žvejai. ");
INSERT INTO lit_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ir jis sako jiems: „Sekite paskui mane, ir aš jus paversiu žmonių žvejais.“ ");
INSERT INTO lit_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ir jie tuojau paliko tinklus ir sekė paskui jį. ");
INSERT INTO lit_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ir pamatęs minias jis užlipo į kalną; ir jam atsisėdus, prie jo priėjo jo mokytiniai. ");
INSERT INTO lit_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ir atvėrės savo burną, jis ėmė mokyti juos, sakydamas: ");
INSERT INTO lit_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","„Palaiminti tie, kurie yra beturčiai dvasios atžvilgiu, nes jų yra dangaus karalystė. ");
INSERT INTO lit_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Palaiminti tie, kurie liūdi, nes jie bus paguosti. ");
INSERT INTO lit_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Palaiminti tie, kurie yra romūs, nes jie paveldės žemę. ");
INSERT INTO lit_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Palaiminti tie, kurie alksta ir trokšta teisumo, nes jie bus pasotinti. ");
INSERT INTO lit_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Palaiminti tie, kurie yra gailestingi, nes jie susilauks gailestingumo. ");
INSERT INTO lit_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Palaiminti tie, kurie yra tyraširdžiai, nes jie matys Dievą. ");
INSERT INTO lit_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Palaiminti tie, kurie yra taikdariai, nes jie bus vadinami Dievo vaikais. ");
INSERT INTO lit_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Palaiminti tie, kurie yra persekiojami dėl teisumo, nes jų yra dangaus karalystė. ");
INSERT INTO lit_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Esate palaiminti, kai dėl manęs jus niekina ir persekioja, ir meluodami kalba apie jus visokį blogą posakį. ");
INSERT INTO lit_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Džiaukitės ir džiūgaukite, nes didelis yra jūsų atlygis danguje, nes tokiu pat būdu jie persekiojo pirm jūsų buvusius pranašus. ");
INSERT INTO lit_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Jūs esate pasaulio šviesa. Neįmanoma nuslėpti miesto, pastatyto ant kalno. ");
INSERT INTO lit_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nebūna, kad žmonės uždega žiburį ir jį pastato po indu, bet į žibintuvą, ir jis šviečia visiems esantiems namuose. ");
INSERT INTO lit_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Tešviečia jūsų šviesa žmonių akivaizdoje taip, kad jie matytų jūsų gerus darbus ir šlovintų jūsų Tėvą, kuris yra danguje. ");
INSERT INTO lit_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","„Nemanykite, kad aš atėjau panaikinti Įstatymo ar Pranašų: aš atėjau ne panaikinti, bet išpildyti. ");
INSERT INTO lit_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nes iš tiesų sakau jums: kol dangus ir žemė nepraeis, nė vienas jotas, nė vienas ženklelis jokiu būdu neišnyks iš įstatymo, kol viskas išsipildys. ");
INSERT INTO lit_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","„Jūs esate girdėję, kad buvo senolių pasakyta: „Nesvetimauk“. ");
INSERT INTO lit_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Bet aš jums sakau: kiekvienas, kuris žvelgia į moterį taip, kad jos užsigeidžia, tas savo širdyje su ja jau svetimavo. ");
INSERT INTO lit_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ir kas tik privers tave nueiti mylią, nueik su juo dvi. ");
INSERT INTO lit_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Jūs esate girdėję, kad buvo pasakyta: „Mylėk savo artimą“ ir „nekęsk savo priešo“. ");
INSERT INTO lit_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Bet aš jums sakau: mylėkite savo priešus, laiminkite tuos, kurie jus keikia, darykite gera tiems, kurie jūsų nekenčia, ir melskitės už tuos, kurie jus šmeižia ir jus persekioja, ");
INSERT INTO lit_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","kad pasirodytumėte esą savo danguje esančio Tėvo vaikai, nes jis padaro, kad jo saulė tekėtų blogiesiems ir geriesiems ir siunčia lietų teisiesiems ir neteisiesiems. ");
INSERT INTO lit_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Tad būkite tobuli, kaip ir jūsų Tėvas, kuris danguje, yra tobulas. ");
INSERT INTO lit_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","„Saugokitės, kad nedarytumėte savo gailestingumo darbų žmonių akyse, kad būtumėte jų matomi, antraip neturite atlygio pas savo Tėvą danguje. ");
INSERT INTO lit_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ir kai meldiesi, nebūk kaip veidmainiai, nes jie mėgsta melstis stovėdami sinagogose ir gatvių kampuose, kad žmonėms pasirodytų. Iš tiesų sakau jums: jie turi savo atlygį. ");
INSERT INTO lit_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Bet tu, kai meldiesi, įeik į savo kambarėlį ir užsirakinęs duris melskis savo Tėvui, kuris yra slaptoje, o tavo Tėvas, kuris mato slaptoje, atlygins tau viešai. ");
INSERT INTO lit_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Bet kai meldžiatės, tuščiai nepakartokite, kaip svetimtikiai, nes jie galvoja, kad jie bus išgirsti dėl jų gausaus kalbėjimo. ");
INSERT INTO lit_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Todėl nebūkite kaip jie, nes jūsų Tėvas žino, ko jums reikia prieš jums prašant jo. ");
INSERT INTO lit_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Todėl melskitės šitaip: „Tėve mūsų, kuris esi danguje, tebūna šventu laikomas tavo vardas. ");
INSERT INTO lit_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Teateina tavo karalystė. Teįvyksta tavo valia kaip danguje, taip ir žemėje. ");
INSERT INTO lit_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Kasdienės mūsų duonos duok mums šiandien ");
INSERT INTO lit_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ir atleisk mums mūsų skolas, kaip ir mes atleidžiame savo skolininkams. ");
INSERT INTO lit_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ir nevesk mūsų į pagundą, bet išvaduok mus nuo blogio; nes tavo yra karalystė, galybė ir šlovė amžinai. Amen. ");
INSERT INTO lit_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Nes jeigu jūs atleisite žmonėms jų nusižengimus, tai ir jūsų dangiškasis Tėvas jums atleis, ");
INSERT INTO lit_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","bet jeigu neatleisite žmonėms jų nusižengimų, tai nė jūsų Tėvas neatleis jūsų nusižengimų. ");
INSERT INTO lit_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Nekraukite sau lobių žemėje, kur kandys ir rūdys sugadina, ir kur vagys įsilaužia ir vagia, ");
INSERT INTO lit_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","bet kraukite sau lobius danguje, kur nei kandys, nei rūdys nesugadina, ir kur vagys neįsilaužia ir nevagia, ");
INSERT INTO lit_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","nes kur yra jūsų lobis, ten bus ir jūsų širdis. ");
INSERT INTO lit_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Kūno šviesa yra akis, todėl jei tavo akis sveika, visas tavo kūnas bus pilnas šviesos. ");
INSERT INTO lit_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Bet jeigu tavo akis bloga, visas tavo kūnas bus pilnas tamsos. Taigi jeigu tavyje esanti šviesa yra tamsa, tai kokia baisi toji tamsa! ");
INSERT INTO lit_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Niekam neįmanoma tarnauti dviem šeimininkams, nes jis arba vieno nekęs, o kitą mylės, arba jis vieno tvirtai laikysis, o kitą nieku vers. Jums neįmanoma tarnauti Dievui ir mamonai. ");
INSERT INTO lit_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Įsižiūrėkite į padangių paukščius: nei jie sėja, nei pjauna, nei į klėtis krauna, o jūsų dangiškasis Tėvas juos maitina. Argi jūs nesate daug vertesni už juos? ");
INSERT INTO lit_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Taigi, jei Dievas taip aprengia lauko žolę, kuri šiandien yra, o rytoj įmetama į krosnį, ar jis ne kur kas labiau aprengs jus, o mažatikiai? ");
INSERT INTO lit_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Todėl nesirūpinkite ir nesakykite: ‚Ką valgysime?‘ arba: ‚Ką gersime?‘ arba: ‚Kuo apsirengsime?‘ ");
INSERT INTO lit_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Nes viso to geidžia svetimtikiai; juk jūsų dangiškasis Tėvas žino, kad jums reikia viso to. ");
INSERT INTO lit_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Bet pirma ieškokite Dievo karalystės ir jo teisumo, ir visa tai bus jums pridėta. ");
INSERT INTO lit_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","„Neteiskite, kad nebūtumėte teisiami, ");
INSERT INTO lit_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","nes kokiu teismu teisiate, tokiu būsite teisiami, ir kokiu saiku seikite, tokiu jums bus atseikėta. ");
INSERT INTO lit_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ir kodėl žiūri į krislą savo brolio akyje, o nepastebi rąsto savojoje akyje?! ");
INSERT INTO lit_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Arba kaip gali sakyti savo broliui: ‚Leisk man išimti krislą iš tavo akies‘, o štai rąstas tavo akyje?! ");
INSERT INTO lit_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Veidmainy, pirma išmesk rąstą iš savo akies, o paskui aiškiai žiūrėsi tam tikslui, kad išmestum krislą iš savo brolio akies. ");
INSERT INTO lit_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Vis prašykite, ir bus jums duota; vis ieškokite, ir surasite; vis belskite, ir bus jums atidaryta. ");
INSERT INTO lit_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Nes kiekvienas prašantysis gauna ir ieškantysis randa, taip pat beldžiančiajam bus atidaryta. ");
INSERT INTO lit_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Įeikite pro ankštus vartus todėl, kad platūs yra vartai ir erdvus yra kelias, kuris veda į pražūtį, ir daug yra pro juos einančių, ");
INSERT INTO lit_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","ir todėl, kad ankšti yra vartai ir siauras yra kelias, kuris veda į gyvenimą, ir nedaug yra juos surandančių. ");
INSERT INTO lit_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Taip ir kiekvienas geras medis duoda gerus vaisius, bet netikęs medis duoda blogus vaisius. ");
INSERT INTO lit_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Geras medis negali duoti blogų vaisių, nei netikęs medis negali duoti gerų vaisių. ");
INSERT INTO lit_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kiekvienas medis, kuris neduoda gerų vaisių, yra nukertamas ir įmetamas į ugnį. ");
INSERT INTO lit_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Taigi juos pažinsite iš jų vaisių. ");
INSERT INTO lit_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ir tada jiems pareikšiu: ‚Aš niekada jūsų nepažinojau. Pasitraukite nuo manęs jūs, kurie darote įstatymo pažeidimą.‘“ ");
INSERT INTO lit_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Taigi kiekvienas, kas tik klauso šitų mano žodžių ir juos vykdo, – aš jį prilyginsiu išmintingam vyrui, kuris pastatė savo namą ant uolos; ");
INSERT INTO lit_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","ir lijo lietus, ir užėjo potvyniai, ir pūtė vėjai, ir daužėsi į tą namą; o jis nenugriuvo, nes jo pamatai buvo pastatyti ant uolos. ");
INSERT INTO lit_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ir kiekvienas, kuris klauso šitų mano žodžių ir jų nevykdo, bus prilygintas kvailam vyrui, kuris pastatė savo namą ant smėlio; ");
INSERT INTO lit_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","ir lijo lietus, ir užėjo potvyniai, ir pūtė vėjai, ir daužėsi į tą namą; o jis sugriuvo, ir jo griuvimas buvo smarkus.“ ");
INSERT INTO lit_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","nes jis juos mokė kaip turintis įgaliojimą, o ne kaip raštininkai. ");
INSERT INTO lit_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Kai jis leidosi nuo kalno, didelės minios sekė paskui jį. ");
INSERT INTO lit_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ir štai atėjo raupsuotasis ir garbino jį, sakydamas: „Viešpatie, jei tu nori, esi pajėgus mane padaryti švarų. ");
INSERT INTO lit_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ir ištiesęs ranką Jėzus palietė jį sakydamas: „Noriu, būk švarus.“ Ir tuojau jo raupsai buvo nuvalyti. ");
INSERT INTO lit_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ir Jėzus jam sako: „Žiūrėk, niekam nepasakok, bet eik, pasirodyk kunigui ir paaukok dovaną, kurią Mozė įsakė, kad jiems tai būtų liudijimas. ");
INSERT INTO lit_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nes aš esu žmogus pavaldinys, turintis sau pavaldžių kareivių, ir sakau vienam: „Eik!“ – ir jis eina, ir kitam: „Ateik!“ – ir jis ateina, ir savo tarnui: „Padaryk tai!“ – ir jis daro.“ ");
INSERT INTO lit_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ir Jėzus tarė šimtininkui: „Eik, teįvyksta tau, kaip tikėjai!“ Ir jo tarnas buvo išgydytas tą pačią valandą. ");
INSERT INTO lit_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ir atėjęs į Petro namus, Jėzus pamatė jo žmonos motiną gulinčią ir karščiuojančią. ");
INSERT INTO lit_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ir jis palietė jos ranką, ir karštligė pasitraukė nuo jos, ir ji atsikėlė ir jiems patarnavo. ");
INSERT INTO lit_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","kad išsipildytų, kas buvo pasakyta per pranašą Izaiją, būtent: „Jis užnešė mūsų negalias ir nešiojo mūsų ligas“. ");
INSERT INTO lit_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Matydamas dideles minias aplink save, Jėzus įsakė pasitraukti į kitą pusę. ");
INSERT INTO lit_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","O priėjęs vienas raštininkas tarė jam: „Mokytojau, aš seksiu paskui tave, kur tik tu eisi!“ ");
INSERT INTO lit_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ir Jėzus jam sako: „Lapės turi urvus ir padangės paukščiai lizdus, bet Žmogaus Sūnus neturi kur galvos priglausti.“ ");
INSERT INTO lit_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","O kitas iš jo mokytinių jam tarė: „Viešpatie, leisk man pirmiau pareiti ir palaidoti savo tėvą.“ ");
INSERT INTO lit_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Bet Jėzus jam tarė: „Sek paskui mane ir palik mirusiems laidoti savo mirusius.“ ");
INSERT INTO lit_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ir jam įlipęs į valtį, jo mokytiniai nusekė paskui jį. ");
INSERT INTO lit_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ir štai pakilo jūroje didžiulė audra taip, kad bangos paslėpė valtį. Bet jis miegojo. ");
INSERT INTO lit_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","O priėjęs jo mokytiniai pažadino jį, sakydami: „Viešpatie, išgelbėk mus! Žūstame!“ ");
INSERT INTO lit_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ir jis sako jiems: „Kodėl jūs esate bailūs, mažatikiai?“ Tada atsikėlęs, jis sudraudė vėjus bei jūrą, ir pasidarė visiškai ramu. ");
INSERT INTO lit_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Bet žmonės stebėjosi, sakydami: „Kas tai per žmogus, kad netgi vėjai ir jūra jo klauso!?“ ");
INSERT INTO lit_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ir kai jis atvyko į kitą pusę, į gergeziečių kraštą, jį pasitiko du velnių apsėstieji išeidami iš kapų; jie buvo tokie labai smurtingi, kad niekas negalėjo praeiti anuo keliu. ");
INSERT INTO lit_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ir štai jie šaukė, sakydami: „Kas mums ir tau bendro, Jėzau, Dievo Sūnau? Ar čia atėjai pirma laiko mūsų kankinti?“ ");
INSERT INTO lit_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","O toli nuo jų buvo gausi besiganančių kiaulių banda. ");
INSERT INTO lit_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Tad velniai maldavo jį, sakydami: „Jeigu mus išvarai, tai leisk mums pasitraukti į kiaulių bandą.“ ");
INSERT INTO lit_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ir jis jiems tarė: „Eikite!“ Ir išėję jie pasitraukė į kiaulių bandą. Ir štai visa kiaulių banda metėsi nuo skardžio į jūrą ir nugaišo vandenyse. ");
INSERT INTO lit_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","O tie, kurie jas ganė, pabėgo ir nuėję į miestą, viską išpasakojo, įskaitant tai, kas atsitiko velnių apsėstiesiems. ");
INSERT INTO lit_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ir štai visas miestas išėjo Jėzaus pasitikti ir, kai jie pamatė jį, maldavo, kad jis paliktų jų pakraščius. ");
INSERT INTO lit_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ir įlipęs į valtį, jis perplaukė ir atvyko į savąjį miestą. ");
INSERT INTO lit_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Bet kad žinotumėte, jog Žmogaus Sūnus turi žemėje valdymo galią nuodėmėms atleisti – tada jis tarė sergančiam paralyžiumi – kelkis, pasiimk savo gultą ir eik į savo namus.“ ");
INSERT INTO lit_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ir atsikėlęs jis nuėjo į savo namus. ");
INSERT INTO lit_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ir iš ten eidamas toliau Jėzus pamatė muitinėje sėdintį žmogų, vardu Matą, ir jis jam sako: „Sek paskui mane!“ Ir jis atsikėlęs sekė paskui jį. ");
INSERT INTO lit_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jam tuos dalykus bekalbant jiems, štai tam tikras valdytojas atėjęs garbino jį, sakydamas: „Ką tik mirė mano duktė, bet ateik ir uždėk ant jos savo ranką, ir ji gyvens.“ ");
INSERT INTO lit_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ir atsikėlęs Jėzus nusekė paskui jį, taip pat ir jo mokytiniai. ");
INSERT INTO lit_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ir štai moteris, dvylika metų serganti kraujoplūdžiu, prisiartino iš paskos ir palietė jo drabužio kutą. ");
INSERT INTO lit_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Mat ji pati sau kalbėjo: „Jeigu tik paliesiu jo drabužį, būsiu išgydyta.“ ");
INSERT INTO lit_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","O Jėzus atsigręžęs ir ją pamatęs, tarė: „Drąsos, dukterie! Tavo tikėjimas tave išgydė.“ Ir nuo tos valandos moteris buvo išgydyta. ");
INSERT INTO lit_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ir Jėzus atėjęs į valdytojo namus ir pamatęs vamzdininkus ir triukšmaujančią minią, ");
INSERT INTO lit_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","tarė jiems: „Pasitraukite, nes mergaitė ne mirusi, bet miega.“ Ir jie išjuokė jį. ");
INSERT INTO lit_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","O kai minia buvo išvaryta, jis įėjęs vidun paėmė mergaitę už rankos, ir ji atsikėlė. ");
INSERT INTO lit_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ir garsas apie tai pasklido po visą tą kraštą. ");
INSERT INTO lit_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ir Jėzui išeinant iš ten, du aklieji sekė paskui jį šaukdami ir sakydami: „Dovydo Sūnau, pasigailėk mūsų!“ ");
INSERT INTO lit_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","O jam įėjus į namus, aklieji priėjo prie jo, ir Jėzus sako jiems: „Ar tikite, kad aš pajėgiu tai padaryti?“ Jie sako jam: „Taip, Viešpatie.“ ");
INSERT INTO lit_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Tada jis palietė jų akis, sakydamas: „Teįvyksta jums pagal jūsų tikėjimą.“ ");
INSERT INTO lit_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ir jų akys atsivėrė; ir Jėzus juos prigrasė, sakydamas: „Žiūrėkite, kad niekas nesužinotų!“ ");
INSERT INTO lit_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Bet išėję jie paskleidė garsą apie jį po visą tą kraštą. ");
INSERT INTO lit_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ir jiems išeinant, štai jie atvedė pas jį žmogų, kuris buvo nebylus ir velnio apsėstas. ");
INSERT INTO lit_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ir kai velnias buvo išvarytas, nebylys prakalbo. Ir minios stebėjosi, sakydamos: „Taip dar niekada nebuvo matyta Izraelyje!“ ");
INSERT INTO lit_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Bet fariziejai tarė: „Jis išvarinėja velnius per velnių kunigaikštį.“ ");
INSERT INTO lit_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","todėl melskite pjūties Viešpatį, kad jis varytų darbininkų į savo pjūtį.“ ");
INSERT INTO lit_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simonas Kanaanietis ir Judas Iskarijotas, kuris ir išdavė jį. ");
INSERT INTO lit_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Išgydykite ligonius, apvalykite raupsuotus, prikelkite mirusius, išvarykite velnius. Dovanai gavote, dovanai duokite. ");
INSERT INTO lit_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Iš tiesų sakau jums: teismo dieną Sodomos ir Gomoros šaliai bus pakenčiamiau negu tam miestui. ");
INSERT INTO lit_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Štai aš išsiunčiu jus kaip avis tarp vilkų; tad būkite gudrūs kaip gyvatės ir nekalti kaip balandžiai. ");
INSERT INTO lit_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ir dėl mano vardo visi nekęs jūsų; bet būtent tas, kuris ištvers iki galo, bus išgelbėtas. ");
INSERT INTO lit_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ir nebijokite tų, kurie užmuša kūną, bet negali užmušti sielos; o verčiau bijokite to, kuris gali pražudyti ir sielą, ir kūną pragare. ");
INSERT INTO lit_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Taigi kiekvienas, kas tik mane išpažins žmonių akivaizdoje, tą ir aš išpažinsiu savo Tėvo, kuris yra danguje, akivaizdoje. ");
INSERT INTO lit_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","O bet kas, kuris manęs išsižadės žmonių akivaizdoje, to ir aš išsižadėsiu savo Danguje esančio Tėvo akivaizdoje. ");
INSERT INTO lit_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Kas atrandęs savo gyvybę, tas ją pražudys, o kas pražudęs savo gyvybę dėl manęs, tas ją atras. ");
INSERT INTO lit_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ir yra palaimintas kas tik nepasipiktins manimi.“ ");
INSERT INTO lit_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Nes jis yra tasai, apie kurį yra parašyta: Štai aš siunčiu pirma tavo veido savo pasiuntinį, kuris paruoš tau kelią pirma tavęs. ");
INSERT INTO lit_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Atėjo Žmogaus Sūnus, valgantis ir geriantis, ir jie sako: „Štai žmogus rijūnas ir vyno gėrūnas, muitininkų ir nusidėjėlių draugas! Bet jos vaikai išmintį išteisina.“ ");
INSERT INTO lit_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Tada jis pradėjo priekaištauti miestams, kuriuose buvo padaryta daugumas jo galingų antgamtinių veiksmų, kadangi jie neatgailavo: ");
INSERT INTO lit_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","„Vargas tau, Chorazine! Vargas tau, Betsaida! Nes jeigu galingi antgamtiniai veiksmai, kurie buvo padaryti jumyse, būtų buvę padaryti Tyre ir Sidone, jie seniai būtų atgailavę ašutinėje ir pelenuose. ");
INSERT INTO lit_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Vis dėlto jums sakau: teismo dieną Tyrui ir Sidonui bus pakenčiamiau negu jums! ");
INSERT INTO lit_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Bet aš sakau jums, kad teismo dieną Sodomos šaliai bus pakenčiamiau negu tau.“ ");
INSERT INTO lit_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ateikite pas mane visi, kurie vargstate ir nešate sunkias naštas, ir aš jums suteiksiu poilsį. ");
INSERT INTO lit_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Imkite ant savęs mano jungą ir mokykitės iš manęs, nes aš romus ir nuolankios širdies, ir jūs rasite savo sieloms poilsį, – ");
INSERT INTO lit_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","nes mano jungas švelnus ir mano našta yra lengva. ");
INSERT INTO lit_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Nes Žmogaus Sūnus yra ir šabo Viešpats.“ ");
INSERT INTO lit_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","kad išsipildytų, kas buvo pasakyta per pranašą Izaiją, būtent: ");
INSERT INTO lit_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Štai mano Tarnas, kurį aš išrinkau, mano mylimasis, kuriuo gėrisi mano siela. Ant Jo uždėsiu savo Dvasią, ir jis praneš kitataučiams teisingumą. ");
INSERT INTO lit_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Jis nenulauš lūžusios nendrės ir neužgesins gruzdančio dagčio, kol neišsiųs teisingumo į pergalę. ");
INSERT INTO lit_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","IR KITATAUČIAI SUDĖS VILTIS Į JO VARDĄ. ");
INSERT INTO lit_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Tada pas jį atvedė aklą ir nebylų velnio apsėstą žmogų; ir jis išgydė jį taip, kad aklas ir nebylus žmogus ir kalbėjo ir regėjo. ");
INSERT INTO lit_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ir visos minios netvėre iš nuostabos ir sakė: „Nejaugi šis nėra Dovydo sūnus?!“ ");
INSERT INTO lit_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Bet tai išgirdę, fariziejai sakė: „Šitas išvarinėja velnius ne kitaip, kaip tik velnių valdovu Belzebulu.“ ");
INSERT INTO lit_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ir Jėzus, žinodamas jų mintis, tarė jiems: „Kiekviena karalystė, suskilusi priešingai sau, nusiaubiama, ir joks miestas ar jokie namai, suskilę priešingai sau, neišstovės. ");
INSERT INTO lit_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ir jeigu Šėtonas išvarinėja Šėtoną, tai jis yra susiskaldęs priešingai sau. Tai kaipgi išstovės jo karalystė? ");
INSERT INTO lit_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ir jeigu aš išvarinėju velnius Belzebulu, tai kuo juos išvarinėja jūsų vaikai?! Todėl jie bus jūsų teisėjai. ");
INSERT INTO lit_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Bet jeigu aš išvarinėju velnius Dievo Dvasia, tai pas jus yra atėjusi Dievo karalystė. ");
INSERT INTO lit_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Arba kaipgi gali kas įeiti į galiūno namus ir išplėšti jo daiktus, jeigu jis pirma nebus surišęs galiūno? Jis išplėš jo namus tik tada. ");
INSERT INTO lit_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Kas ne su manimi, tas prieš mane, ir kas su manimi nerenka, tas išvaiko. ");
INSERT INTO lit_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Todėl sakau jums: visokia nuodėmė ir piktžodžiavimas bus žmonėms atleisti, bet piktžodžiavimas Šventajai Dvasiai nebus žmonėms atleistas. ");
INSERT INTO lit_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Nes pagal savo žodžius būsi išteisintas ir pagal savo žodžius būsi pasmerktas.“ ");
INSERT INTO lit_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Tada kai kurie iš raštininkų ir fariziejų atsakė, tardami: „Mokytojau, mes norėtume pamatyti ženklą iš tavęs.“ ");
INSERT INTO lit_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Bet jis atsakydamas tarė jiems: „Nelaba ir svetimaujanti karta geidžia ženklo, bet nebus jai duota kito ženklo, kaip tik pranašo Jonos ženklas, ");
INSERT INTO lit_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","nes kaip Jona buvo tris dienas ir tris naktis didelio vandens gyvūno pilve, taip ir Žmogaus Sūnus bus tris dienas ir tris naktis žemės širdyje. ");
INSERT INTO lit_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Žmonės nineviečiai kelsis drauge su šia karta teisme ir ją pasmerks, nes jie atgailavo dėl Jonos šaukliško skelbimo, o štai čia už Joną yra kas didesnis! ");
INSERT INTO lit_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Taigi jūs pasiklausykite palyginimo apie sėjėją. ");
INSERT INTO lit_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Argi šis ne dailidės sūnus? Argi jo motina nevadinama Marija? O jo broliai – Jokūbas ir Jozė, ir Simonas, ir Judas? ");
INSERT INTO lit_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ir jo seserys, argi ne jos visos su mumis? Tad iš kur šitam visi šie dalykai?!“ ");
INSERT INTO lit_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ir jie pasipiktino juo. Bet Jėzus jiems tarė: „Pranašas nebūna be pagarbos niekur kitur, tik savo tėviškėje ir savo namuose. ");
INSERT INTO lit_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ir jis ten nepadarė daug galingų antgamtinių veiksmų dėl jų netikėjimo. ");
INSERT INTO lit_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ir tuoj pat Jėzus privertė savo mokytinius lipti į valtį ir pirma jo plaukti į kitą pusę, kol jis atleisiąs minias. ");
INSERT INTO lit_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ir, atleidęs minias, jis užlipo į kalną melstis atskirai. Ir, atėjus vakarui, jis buvo ten vienas. ");
INSERT INTO lit_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Bet valtis jau buvo jūros viduryje, blaškoma bangų, nes vėjas buvo priešingas. ");
INSERT INTO lit_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ir per ketvirtą nakties sargybą Jėzus ėjo pas juos vaikščiodamas jūros paviršiumi. ");
INSERT INTO lit_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ir kai mokytiniai pamatė jį vaikščiojantį jūros paviršiumi, jie krūptelėjo ir sakė: „Tai šmėkla!“ ir iš baimės jie ėmė šaukti. ");
INSERT INTO lit_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Bet Jėzus tuojau jiems tarė, sakydamas: „Drąsos! Tai aš. Nebijokite!“ ");
INSERT INTO lit_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ir Petras jam atsakydamas tarė: „Viešpatie, jei tai tu, liepk man eiti pas tave vandens paviršiumi.“ ");
INSERT INTO lit_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","O jis tarė: „Ateik.“ Tai išlipęs iš valties, Petras vaikščiojo vandens paviršiumi, kad nueitų pas Jėzų. ");
INSERT INTO lit_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Bet matydamas smarkų vėją, jis nusigando ir, pradėjęs skęsti, sušuko, sakydamas: „Viešpatie, išgelbėk mane!“ ");
INSERT INTO lit_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ir tuojau ištiesęs ranką, Jėzus nutvėrė jį bei jam tarė: „O mažatiki, ko suabejojai?!“ ");
INSERT INTO lit_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ir jiems įlipus į valtį, vėjas nurimo. ");
INSERT INTO lit_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Tuomet tie, kurie buvo valtyje, prisiartinę pagarbino jį, sakydami: „Tikrai tu esi Dievo Sūnus!“ ");
INSERT INTO lit_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","„Kodėl tavo mokytiniai laužo prosenių tradiciją? Nes jie nesimazgoja rankų, kai valgo duoną.“ ");
INSERT INTO lit_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","bet niekais jie mane garbina, mokydami žmonių priesakų lyg įpareigojančių mokslų““. ");
INSERT INTO lit_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Tada atėjo jo mokytiniai ir jam pasakė: „Ar žinai, kad fariziejai, išgirdę tą pasakymą, pasipiktino?“ ");
INSERT INTO lit_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Bet jis atsakydamas tarė: „Kiekvienas augalas, kurio nesodino mano dangiškasis Tėvas, bus išrautas. ");
INSERT INTO lit_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Bet tie dalykai, kurie išeina iš burnos, išlenda iš širdies, ir šie suteršia žmogų. ");
INSERT INTO lit_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Nes iš širdies išeina blogos mintys, žmogžudystės, svetimavimai, paleistuvystės, vagystės, melagingi liudijimai, piktžodžiavimai. ");
INSERT INTO lit_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Šitie yra tie dalykai, kurie suteršia žmogų, bet valgymas nemazgotomis rankomis žmogaus nesuteršia.“ ");
INSERT INTO lit_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Tada Jėzus išėjo iš ten ir pasitraukė į Tyro ir Sidono regioną. ");
INSERT INTO lit_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ir štai moteris kanaanietė iš tų pakraštų išėjusi šaukė jam, sakydama: „Pasigailėk manęs, o Viešpatie, Dovydo Sūnau! Mano dukrą baisiai apsėda velnias! ");
INSERT INTO lit_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Bet jis neatsakė jai nė žodžio. Ir priėję jo mokytiniai prašinėjo jį, sakydami: „Išsiųsk ją, nes ji šaukia mums iš paskos!“ ");
INSERT INTO lit_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Bet jis atsakydamas tarė: „Aš esu siųstas tik pas pražuvusias Izraelio namų avis.“ ");
INSERT INTO lit_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Tada ji priėjusi jį garbino, tardama: „Viešpatie, padėk man!“ ");
INSERT INTO lit_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Bet jis atsakydamas tarė: „Nėra gerai imti vaikų duoną ir mesti šunyčiams.“ ");
INSERT INTO lit_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","O ji tarė: „Taip, Viešpatie. Tačiau ir šunyčiai ėda trupinius, kurie krenta nuo jų šeimininkų stalo. ");
INSERT INTO lit_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Tada Jėzus atsakydamas tarė jai: „O moterie, didis tavo tikėjimas! Teįvyksta tau, kaip tu nori.“ Ir tą pačią valandą jos dukra buvo išgydyta. ");
INSERT INTO lit_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ir iš ten išėjęs, Jėzus atvyko prie Galilėjos jūros, ir užkopęs ant kalno, ten sėdėjo. ");
INSERT INTO lit_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ir atėjo pas jį didžiulės minios, atsigabendamos su savimi raišų, aklų, nebylių, neturinčių kūno dalių ir daugelį kitokių, ir juos padėjo prie Jėzaus kojų, o jis juos išgydė. ");
INSERT INTO lit_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Pasekmė ta, kad minios stebėjosi, matydama nebylius kalbančius, neturinčius kūno dalių sveikus, raišus vaikščiojančius ir aklus reginčius, ir šlovino Izraelio Dievą. ");
INSERT INTO lit_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Tada, susišaukęs savo mokytinius, Jėzus tarė: „Mane apima gailestis dėl minios, nes jau tris dienas jie pasilieka su manimi ir neturi ko valgyti, ir nenoriu paleisti jų alkanų, kad jie nenuilstų kelyje. ");
INSERT INTO lit_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ir jo mokytiniai jam sako: „Iš kur mums imti dykumoje tiek daug duonos, kad ji pasotintų tokią didžiulę minią? ");
INSERT INTO lit_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ir Jėzus jiems sako: „Kiek jūs turite kepalų? Ir jie tarė: „Septynis ir kelias žuveles. ");
INSERT INTO lit_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ir jis įsakė miniai susėsti ant žemės ");
INSERT INTO lit_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ir paėmęs septynis kepalus ir žuvis ir padėkojęs, jis laužė ir davė savo mokytiniams, o mokytiniai – miniai. ");
INSERT INTO lit_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ir jie visi valgė ir pasisotino; ir pririnko pertekusių gabalų septynias pilnas pintines. ");
INSERT INTO lit_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","O valgančiųjų buvo keturi tūkstančiai vyrų, neskaitant moterų ir vaikų. ");
INSERT INTO lit_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ir paleidęs minias, jis įlipo į valtį ir atvyko į Magdalos pakraščius. ");
INSERT INTO lit_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jis sako jiems: „Bet jūs ką sakote mane esant? ");
INSERT INTO lit_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ir Simonas Petras atsakydamas tarė: „Tu esi Kristus, gyvojo Dievo Sūnus! ");
INSERT INTO lit_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ir Jėzus atsakydamas tarė jam: „Palaimintas esi, Simonai bar Jona, nes ne kūnas ir kraujas tau tai apreiškė, bet mano Tėvas, kuris yra danguje. ");
INSERT INTO lit_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ir aš taip pat sakau tau, kad tu esi Petras, ir ant šitos Uolos aš statydinsiu savo bažnyčią, ir pragaro vartai jos nenugalės. ");
INSERT INTO lit_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ir aš tau duosiu dangaus karalystės raktus, ir ką tik tu suriši žemėje, bus surišta danguje, ir ką tik tu atriši žemėje, bus atrišta danguje. ");
INSERT INTO lit_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Tada jis davė įsakymą savo mokytiniams, kad jie niekam nesakytų, kad jis yra Jėzus, kuris Kristus. ");
INSERT INTO lit_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Tada Jėzus tarė savo mokytiniams: „Jei kas nori eiti paskui mane, teišsižada savęs ir tepasiima savo kryžių, ir teseka manimi. ");
INSERT INTO lit_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Nes bet kas, kuris ketina išgelbėti savo gyvybę, tas ją pražudys, o bet kas, kuris pražudys savo gyvybę dėl manęs, tas ją atras. ");
INSERT INTO lit_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Nes kokia gi nauda žmogui, jeigu jis laimėtų visą pasaulį, bet prarastų savo sielą?! Arba ką žmogus duos mainais už savo sielą?! ");
INSERT INTO lit_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Dar jam tebekalbant, štai šviesus debesis apgaubė juos šešėliu, ir štai balsas iš debesies prakalbo: „Šitas yra mano mylimasis Sūnus, kuriuo gėriuosi – klausykite jo!“ ");
INSERT INTO lit_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ir priėjęs Jėzus palietė juos bei tarė: „Kelkitės ir nebijokite! ");
INSERT INTO lit_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ir pakėlę savo akis jie nieko daugiau nebematė, vien tiktai Jėzų. ");
INSERT INTO lit_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ir jiems atėjus prie minios, pas jį atėjo žmogus, klaupdamasis prieš jį ir sakydamas: ");
INSERT INTO lit_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","„Viešpatie, pasigailėk mano sūnaus, kadangi jis mėnulio susmogtas ir labai kankinasi, mat jis dažnai įpuola į ugnį ir dažnai į vandenį. ");
INSERT INTO lit_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ir atvedžiau jį pas tavo mokytinius, bet jie nepajėgė jo išgydyti.“ ");
INSERT INTO lit_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Tada Jėzus atsakydamas tarė: „O netikinti ir iškrypusi karta! Iki kol aš būsiu su jumis? Iki kol jus pakęsiu? Atneškite jį čia, pas mane.“ ");
INSERT INTO lit_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ir Jėzus sudraudė velnią, ir jis išėjo iš jo; ir vaikas buvo išgydytas nuo to akimirksnio. ");
INSERT INTO lit_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Tada mokytiniai atskirai atėjo pas Jėzų ir tarė: „Kodėl mes nepajėgėme jo išvaryti?“ ");
INSERT INTO lit_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ir Jėzus jiems tarė: „Dėl jūsų netikėjimo. Nes iš tiesų sakau jums: jeigu turėsite tikėjimą kaip garstyčios sėklos grūdelį, jūs pasakysite šitam kalnui: ‚Persikelk iš čia į tenai‘, – ir jis persikels. Ir nieko jums nebus neįmanomo. ");
INSERT INTO lit_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Tačiau šita veislė kitaip neišeina, kaip tik malda ir pasninku.“ ");
INSERT INTO lit_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ir atėjus jiems į Kapernaumą, prie Petro priėjo rinkliavos rinkėjai, ir tarė: „Ar jūsų mokytojas nemoka rinkliavos? ");
INSERT INTO lit_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Jis sako: „Taip, jis moka! Ir kai parėjo į namus, Jėzus pirmas jį prakalbino: „Kaip manai, Simonai? Iš ko žemės karaliai ima muitą ar duoklę? Iš savo vaikų ar iš svetimųjų? ");
INSERT INTO lit_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petras jam sako: „Iš svetimųjų. Jėzus sako jam: „Tai, žinoma, vaikai yra laisvi. ");
INSERT INTO lit_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Tačiau, kad jų nepiktintume, nueik prie jūros, įmesk kabliuką, paimk pirmą užkibusią žuvį, ir pravėręs jos žiotis rasi pinigą. Paimk jį ir atiduok jiems už mane ir už save. ");
INSERT INTO lit_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Tuo pačiu metu pas Jėzų atėjo mokytiniai, sakydami: „Kas gi yra didžiausias dangaus karalystėje?“ ");
INSERT INTO lit_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ir Jėzus, pasišaukęs mažą vaiką, pastatė jį jų viduryje, ");
INSERT INTO lit_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ir tarė: „Iš tiesų sakau jums: jeigu neatsiversite ir nepasidarysite kaip maži vaikai, jokiu būdu neįeisite į dangaus karalystę. ");
INSERT INTO lit_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Todėl kas nusižemina kaip šis mažas vaikas, tas yra didžiausias dangaus karalystėje. ");
INSERT INTO lit_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ir jei tavo akis suklupdina tave, išlupk ją ir mesk nuo savęs. Tau yra geriau vienakiui įeiti į gyvenimą, negu turėdamas dvi akis būti įmestam į pragaro ugnį. ");
INSERT INTO lit_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Juk Žmogaus Sūnus atėjo išgelbėti to, kas yra pražuvę. ");
INSERT INTO lit_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Lygiai taip pat tai nėra jūsų danguje esančio Tėvo valia, kad pražūtų bent vienas iš šitų mažutėlių. ");
INSERT INTO lit_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Be to, jeigu tavo brolis tau nusidės, eik ir prie keturių akių įtikink jį dėl kaltumo; jeigu jis paklausys tavęs, tu laimėjai savo brolį. ");
INSERT INTO lit_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Bet jeigu jis tavęs neklausys, paimk su savimi dar vieną ar du, kad dviejų ar trijų liudytojų burnos parodymais būtų patvirtintas kiekvienas žodis. ");
INSERT INTO lit_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","O jeigu jis atsisakys jų klausyti, pasakyk tai bažnyčiai; bet jeigu jis atsisakys klausyti bažnyčios, tebūna jis tau kaip svetimtikis ir muitininkas. ");
INSERT INTO lit_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Iš tiesų sakau jums: kokius tik dalykus jūs surišite žemėje, bus surišta danguje, ir kokius tik dalykus jūs atrišite žemėje, bus atrišta danguje. ");
INSERT INTO lit_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Jums dar sakau: jei du iš jūsų susitartų žemėje dėl bet kokio dalyko, ko tik jie prašytų, jiems tai bus padaryta mano Tėvo, kuris yra danguje. ");
INSERT INTO lit_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Nes kur du ar trys yra susirinkę mano vardu, ten aš esu tarp jų.“ ");
INSERT INTO lit_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Tada atėjęs pas jį, Petras pasakė: „Viešpatie, kiek kartų mano brolis nusidės man, ir aš turėsiu jam atleisti? Ar iki septynių kartų?“ ");
INSERT INTO lit_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jėzus jam *tarė: „Aš nesakau tau iki septynių kartų, bet iki septyniasdešimtkart septynių. ");
INSERT INTO lit_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Taip ir mano dangiškasis Tėvas padarys jums, jeigu jūs kiekvienas iš širdies neatleisite savo broliams jų nusižengimų.“ ");
INSERT INTO lit_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Bet Jėzus tarė: „Leiskite vaikučius ir nedrauskite jiems ateiti pas mane, nes tokių yra dangaus karalystė. ");
INSERT INTO lit_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ir štai vienas priėjęs tarė jam: „Gerasis Mokytojau, ką gera turiu daryti, kad turėčiau amžiną gyvenimą? ");
INSERT INTO lit_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","gerbk savo tėvą ir motiną; ir, mylėk savo artimą kaip save patį.“ ");
INSERT INTO lit_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Tada Jėzus tarė savo mokytiniams: „Iš tiesų sakau jums: turtingas sunkiai įeis į dangaus karalystę. ");
INSERT INTO lit_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ir dar jums sakau: lengviau kupranugariui pralįsti pro adatos ausį, negu turtingam įeiti į Dievo karalystę.“ ");
INSERT INTO lit_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","O tai išgirdę, jo mokytiniai labai nustebo ir pasakė: „Tai kas gali būti išgelbėtas?!“ ");
INSERT INTO lit_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Bet įbedęs į juos akis, Jėzus jiems tarė: „Žmonėms tai yra neįmanoma, bet Dievui viskas yra įmanoma. ");
INSERT INTO lit_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Tada Petras atsakydamas jam tarė: „Štai mes viską palikome ir sekėme paskui tave. Kas mums bus už tai?“ ");
INSERT INTO lit_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ir Jėzus jiems tarė: „Iš tiesų sakau jums, kad atgimime, kai Žmogaus Sūnus sėdės savo šlovės soste, jūs, kurie sekėte paskui mane, – jūs irgi sėdėsite dvylikoje sostų, teisdami dvylika Izraelio genčių. ");
INSERT INTO lit_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ir kiekvienas, kuris paliko namus ar brolius, ar seseris, ar tėvą, ar motiną, ar žmoną, ar vaikus, ar žemes dėl mano vardo, gaus šimteriopai ir paveldės amžinąjį gyvenimą. ");
INSERT INTO lit_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Tačiau daugelis pirmųjų bus paskutiniai, ir daugelis paskutinių – pirmi.“ ");
INSERT INTO lit_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Bet Jėzus juos pasišaukęs, tarė: „Jūs žinote, kad tautų valdovai jiems viešpatauja, ir didžiūnai joms duoda pajusti savo galią. ");
INSERT INTO lit_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Bet tarp jūsų taip nebus. Priešingai, kas tarp jūsų nori būti didis, jis turi būti jūsų tarnautojas, ");
INSERT INTO lit_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ir kas tarp jūsų nori būti pirmas, jis turi būti jūsų tarnas ");
INSERT INTO lit_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","lygiai taip, kaip Žmogaus Sūnus atėjo ne kad jam tarnautų, bet kad jis pats tarnautų ir savo gyvybės atiduotų kaip išpirkos vietoj daugelio.“ ");
INSERT INTO lit_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ir jiems išeinant iš Jericho, paskui jį sekė didelė minia. ");
INSERT INTO lit_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ir štai pakelėje sėdintys du aklieji išgirdę, kad Jėzus eina pro šalį, šaukė, sakydami: „Pasigailėk mūsų, o Viešpatie, Dovydo Sūnau!“ ");
INSERT INTO lit_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ir minia sudraudė juos, kad jie tylėtų, bet jie vis šaukė dar garsiau, sakydami: „Pasigailėk mūsų, o Viešpatie, Dovydo Sūnau!“ ");
INSERT INTO lit_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ir sustojęs Jėzus pašaukė juos ir tarė: „Ko norite, kad jums padaryčiau?“ ");
INSERT INTO lit_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Jie sako jam: „Viešpatie, kad mūsų akys būtų atvertos.“ ");
INSERT INTO lit_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Tad Jėzus, apimtas gailesčio, palietė jų akis; ir tuoj pat jų akys praregėjo, ir jie nusekė paskui jį. ");
INSERT INTO lit_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ir kai jie priartėjo prie Jeruzalės ir atėjo į Betfagę prie Alyvų kalno, tada Jėzus pasiuntė du mokytinius, ");
INSERT INTO lit_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","sakydamas jiems: „Eikite į priešais jus esantį kaimą, ir tuojau rasite pririštą asilę ir su ja asilaitį; atriškite juos ir atveskite man. ");
INSERT INTO lit_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ir jeigu kas jums ką sakytų, pasakykite: „Jų reikia Viešpačiui. Ir jis tuojau juos išsiųs.“ ");
INSERT INTO lit_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Visa tai įvyko, kad išsipildytų, kas buvo pasakyta per pranašą, būtent: ");
INSERT INTO lit_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Sakykite Siono dukteriai: Štai tavo karalius ateina pas tave romus ir sėdintis ant asilo ir ant asilaičio, nešulinio gyvulio jauniklio. ");
INSERT INTO lit_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ir mokytiniai nuėję ir padarę, kaip Jėzus jiems buvo įsakęs, ");
INSERT INTO lit_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","atvedė asilę ir asilaitį, uždėjo ant jų savo drabužius, ir užsodino jį ant jų. ");
INSERT INTO lit_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ir labai didelė minia tiesė savo drabužius kelyje, o kiti kirto šakas nuo medžių ir klojo jas kelyje. ");
INSERT INTO lit_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Nes Jonas atėjo pas jus teisumo kelyje, ir jūs juo netikėjote; bet muitininkai ir paleistuvės juo tikėjo; ir jūs, tai matę, vėliau neatgailavote, kad juo tikėtumėte. ");
INSERT INTO lit_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ir kas ant to akmens kris, bus sudaužytas, bet ant ko jis nukris, tą sutriuškins.“ ");
INSERT INTO lit_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jėzus atsakydamas tarė jiems: „Jūs klystate nepažindami nei šventraščių, nei Dievo galios, ");
INSERT INTO lit_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","„Aš esu Abraomo Dievas ir Izaoko Dievas, ir Jokūbo Dievas?“ Dievas nėra mirusiųjų, bet gyvųjų Dievas.“ ");
INSERT INTO lit_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","„Mokytojau, kuris įsakymas yra didžiausias Įstatyme?“ ");
INSERT INTO lit_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jėzus jam atsakė: „Mylėk Viešpatį, savo Dievą, visa savo širdimi, visa savo siela ir visu savo protu. ");
INSERT INTO lit_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Šis yra pirmasis ir didžiausias įsakymas. ");
INSERT INTO lit_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ir antrasis yra panašus į jį: Mylėk savo artimą kaip save patį. ");
INSERT INTO lit_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ant šitų dviejų įsakymų kybo visas Įstatymas ir Pranašai.“ ");
INSERT INTO lit_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jis sako jiems: „Kaipgi tada Dovydas dėl Dvasios įtakos vadina jį Viešpačiu, sakydamas: ");
INSERT INTO lit_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Bet vargas jums, raštininkai ir fariziejai, veidmainiai! Nes jūs priešais žmones uždarote dangaus karalystę; nes nei jūs patys neįeinate, nei į ją įeinantiems neleidžiate įeiti. ");
INSERT INTO lit_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Vargas jums, raštininkai ir fariziejai, veidmainiai! Nes jūs apkeliaujate jūra ir sausuma, kad padarytumėte vieną atsivertėlį, ir kai tokiu atsiranda, padarote jį pragaro vaiką dukart labiau negu patys esate. ");
INSERT INTO lit_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Vargas jums, raštininkai ir fariziejai, veidmainiai! Nes jūs duodate dešimtinę nuo mėtų ir krapų ir kmynų, bet apleidote svaresniuosius įstatymo dalykus – teisingumą, gailestingumą ir tikėjimą. Šituos reikėjo jums vykdyti ir anų neapleisti! ");
INSERT INTO lit_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Jūs aklieji vadai, kurie iškošiate uodą, bet praryjate kupranugarį! ");
INSERT INTO lit_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Taip ir jūs išoriškai atrodote žmonėms teisūs, bet viduje esate pilni veidmainystės ir įstatymo pažeidinėjimo. ");
INSERT INTO lit_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","O Jeruzale, Jeruzale, kuri žudai pranašus ir užmuši akmenimis tuos, kurie yra pas tave siųsti! Kiek kartų norėjau surinkti tavo vaikus, kaip višta surenka savo viščiukus po sparnais, o jūs nenorėjote! ");
INSERT INTO lit_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","O visi tie dalykai tėra skausmų pradžia. ");
INSERT INTO lit_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Bet kas ištvers iki galo, būtent tas bus išgelbėtas. ");
INSERT INTO lit_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ir bus paskelbta ši karalystės evangelija visame pasaulyje, kad būtų liudijimas visoms tautoms, ir tada ateis galas. ");
INSERT INTO lit_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Todėl kai pamatysite išniekinimo bjaurybę, kuri buvo apsakyta per pranašą Danielų, stovinčią šventoje vietoje (tegul skaitytojas permano!), ");
INSERT INTO lit_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Dangus ir žemė praeis, bet mano žodžiai niekaip nepraeis. ");
INSERT INTO lit_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Bet apie tos Dienos ir Valandos laiką niekas nežino, nei dangaus angelai, bet tik mano Tėvas. ");
INSERT INTO lit_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","bet išmintingosios kartu su žibintais pasiėmė alyvų aliejaus savo induose. ");
INSERT INTO lit_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Jo valdovas tarė jam: „Gerai atlikta, gerasis ir ištikimasis tarne! Tu buvai ištikimas dėl keleto dalykų, aš padarysiu tave atsakingą už daugelį dalykų. Įeik į savo valdovo džiaugsmą!“ ");
INSERT INTO lit_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ir jis pastatys avis savo dešinėje, bet ožius – kairėje. ");
INSERT INTO lit_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Tada jis tars ir tiems kairėje: „Eikite nuo manęs, prakeiktieji, į amžinąją ugnį, paruoštą velniui ir jo angelams! ");
INSERT INTO lit_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Nes buvau išalkęs, ir nedavėte man valgyti, buvau ištroškęs, ir nedavėte man atsigerti, ");
INSERT INTO lit_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","buvau svetimšalis, ir jūs manęs nepriėmėte, nuogas, ir manęs neaprengėte, sergantis ir kalėjime, ir manęs neaplankėte.“ ");
INSERT INTO lit_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Tada ir jie atsakys jam, tardami: „Viešpatie, kada tave matėme išalkusį ar ištroškusį, ar svetimšalį, ar nuogą, ar sergantį, ar kalėjime ir tau nepatarnavome?“ ");
INSERT INTO lit_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Tada jis atsakys jiems, tardamas: „Iš tiesų sakau jums: kiek nepadarėte vienam iš šitų mažiausiųjų, tiek nepadarėte man.“ ");
INSERT INTO lit_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ir eis šitie į amžiną nubaudimą, o teisieji į amžiną gyvenimą.“ ");
INSERT INTO lit_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Iš tiesų sakau jums: visame pasaulyje, kur tik bus skelbiama ši evangelija, ir jos atminimui bus pasakojama, ką ji padarė.“ ");
INSERT INTO lit_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Tada vienas iš Dvylikos, vadinamas Judu Iskarijotu, nuėjęs pas aukštuosius kunigus, ");
INSERT INTO lit_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","tarė: „Ką sutinkate man duoti, kad aš jums jį išduočiau?“ Ir jie pristatė jam trisdešimt sidabrinių. ");
INSERT INTO lit_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","O vakarui atėjus, jis su Dvylika atsisėdo valgyti. ");
INSERT INTO lit_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ir jiems valgant, Jėzus, paėmęs duoną ir pasakęs palaiminimą, ją laužė ir davė mokytiniams ir tarė: „Imkite, valgykite – tai yra mano kūnas.“ ");
INSERT INTO lit_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ir paėmęs taurę ir padėkojęs, jis jiems davė, sakydamas: „Gerkite iš jos visi, ");
INSERT INTO lit_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","nes tai yra mano kraujas, kuris yra naujosios sandoros kraujas, kuris išliejamas už daugelį dėl nuodėmių atleidimo. ");
INSERT INTO lit_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Bet sakau jums: visai negersiu šito vynmedžio vaisiaus nuo šiol iki tos dienos, kada su jumis gersiu jį naują savo Tėvo karalystėje.“ ");
INSERT INTO lit_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ir pagiedoję giesmę jie išėjo į Alyvų kalną. ");
INSERT INTO lit_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","O Petras atsakydamas jam tarė: „Nors ir visi atsimes dėl tavęs, aš niekada neatsimesiu!“ ");
INSERT INTO lit_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ir truputį toliau paėjęs, jis parpuplė veidu žemyn ir meldėsi, sakydamas: „O mano Tėve, jeigu yra įmanoma, teaplenkia mane šita taurė. Tačiau ne kaip aš noriu, bet kaip tu!“ ");
INSERT INTO lit_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Budėkite ir melskitės, kad neįžengtumėte į pagundą. Dvasia iš tikrųjų noringa, bet kūnas silpnas.“ ");
INSERT INTO lit_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Bet visa tai įvyko, kad išsipildytų pranašų šventraščiai.“ Tada visi mokytiniai paliko jį ir pabėgo. ");
INSERT INTO lit_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ir Petras prisiminė Jėzaus jam pasakytą žodį: „Prieš gaidžiui pragystant, tu triskart manęs išsižadėsi.“ Ir jis išėjo laukan ir karčiai verkė. ");
INSERT INTO lit_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ir Jėzus stovėjo valdytojo akivaizdoje ir valdytojas jį paklausė, sakydamas: „Ar tu esi žydų karalius?“ Ir Jėzus jam tarė: „Tu tai sakai.“ ");
INSERT INTO lit_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Bet jis neatsakė jam nė į vieną kaltinimą, tad valdytojas labai stebėjosi. ");
INSERT INTO lit_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Mat jis suprato, kad jie perdavė jį iš pavydo. ");
INSERT INTO lit_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Tada valdytojo kareiviai, nusivedę Jėzų į teismo aikštę, surinko aplink jį visą batalioną. ");
INSERT INTO lit_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ir, atėję į vietą, vadinamą Golgota (tai reiškia „Kaukolės vietą“), ");
INSERT INTO lit_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Tuo pačiu jį užgauliojo ir vagys, kurie buvo nukryžiuoti kartu su juo. ");
INSERT INTO lit_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Bet Jėzus, vėl sušukęs garsiu balsu, atidavė dvasią. ");
INSERT INTO lit_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ir štai šventyklos uždanga buvo perplėštas pusiau nuo viršaus iki apačios; ir žemė drebėjo, ir uolos skeldėjo, ");
INSERT INTO lit_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","O Pilotas jiems tarė: „Imkite sargybą! Eikite, saugokite, kaip mokate!“ ");
INSERT INTO lit_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Jie nuėję padarė kapą saugų, užantspauduodami akmenį ir pastatydami sargybą. ");
INSERT INTO lit_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ir šabo pabaigoje, sutemant į pirmąją savaitės dieną, Marija Magdalietė ir kita Marija atėjo pažiūrėti kapo. ");
INSERT INTO lit_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ir angelas atsakydamas tarė moterims: „Jūs nebijokite! Juk žinau, kad ieškote Jėzaus, kuris buvo nukryžiuotas. ");
INSERT INTO lit_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Jo čia nėra, nes jis prisikėlė, kaip jis pasakė. Ateikite, apžiūrėkite vietą, kur Viešpats gulėjo. ");
INSERT INTO lit_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ir eikite skubiai ir pasakykite jo mokytiniams: ‚Jis yra prisikėlęs iš numirusiųjų ir štai eina pirma jūsų į Galilėją; tenai jį pamatysite.‘ Štai aš jums tai pasakiau.“ ");
INSERT INTO lit_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","O vienuolika mokytinių nuėjo į Galilėją, į kalną, kurį Jėzus jiems buvo nurodęs, ");
INSERT INTO lit_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","ir jį pamatę, jie garbino jį, tačiau kai kurie abejojo. ");
INSERT INTO lit_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ir priėjęs Jėzus jiems kalbėjo, sakydamas: „Visa valdžia danguje ir žemėje yra duota man. ");
INSERT INTO lit_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Tad eikite ir padarykite mokytiniais visų tautų žmones, krikštydami juos vardan Tėvo, ir Sūnaus, ir Šventosios Dvasios, ");
INSERT INTO lit_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","mokydami juos laikytis visko, ką jums įsakiau. Ir štai aš esu su jumis per visas dienas iki pasaulio pabaigos.“ Amen. ");
INSERT INTO lit_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jėzaus Kristaus, Dievo Sūnaus, evangelijos pradžia, ");
INSERT INTO lit_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","kaip yra parašyta pranašuose: Štai aš siunčiu pirma tavo veido savo pasiuntinį, kuris paruoš tau kelią pirma tavęs. ");
INSERT INTO lit_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Atsirado Jonas dykumoje krikštydamas ir skelbdamas krikštą, kurį sąlygoja atgaila – dėl nuodėmių atleidimo. ");
INSERT INTO lit_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Aš, žinoma, vandeniu jus krikštijau, bet jis krikštys jus Šventąja Dvasia.“ ");
INSERT INTO lit_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ir tuoj pat Dvasia nuvaro jį į dykumą. ");
INSERT INTO lit_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Tuomet, kai Jonas jau buvo įkalintas, Jėzus atėjo į Galilėją, skelbdamas Dievo karalystės Evangeliją ");
INSERT INTO lit_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ir sakydamas: „Suėjo nustatytas laikas, ir Dievo karalystė yra prisiartinusi. Atgailaukite ir tikėkite Evangelija!“ ");
INSERT INTO lit_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","O beeidamas palei Galilėjos jūrą jis pamatė Simoną ir jo brolį Andriejų, metančius tinklą į jūrą; mat jie buvo žvejai. ");
INSERT INTO lit_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ir Jėzus jiems tarė: „Eikite paskui mane, ir aš paversiu jūs pasidarančiais žmonių žvejais. ");
INSERT INTO lit_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ir jie tuojau paliko savo tinklus ir sekė paskui jį. ");
INSERT INTO lit_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ir nuo ten truputį toliau paėjęs, jis pamatė Zebediejaus Jokūbą ir jo brolį Joną, valtyje betaisančius tinklus. ");
INSERT INTO lit_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ir tuojau jis pašaukė juos, ir jie, palikę savo tėvą Zebediejų su samdiniais valtyje, nuėjo paskui jį. ");
INSERT INTO lit_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ir jie nuėjo į Kapernaumą, ir tuojau, šabo dieną, jis įėjo į sinagogą ir mokė. ");
INSERT INTO lit_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ir jie stebėjosi jo mokymu, nes jis juos mokė kaip turintis valdžią, o ne kaip raštininkai. ");
INSERT INTO lit_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","O jų sinagogoje buvo netyrosios dvasios valdomas žmogus, ir jis šaukė, ");
INSERT INTO lit_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","sakydamas: „Netrukdyk! Kas mums ir tau bendro, Jėzau Nazarėnai? Ar atėjai mūsų pražudyti? Pažįstu tave, kas esi – Dievo Šventasis. ");
INSERT INTO lit_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","O Jėzus jį sudraudė, sakydamas: „Nutilk ir išeik iš jo! ");
INSERT INTO lit_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ir netyra dvasia, sukėlusi jam traukulį ir sušukusi garsiu balsu, išėjo iš jo. ");
INSERT INTO lit_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ir jie visi stebėjosi, kad net klausinėjo tarpusavyje, sakydami: „Kas tai yra? Kas tai per naujoviškas mokymas? Nes jis įsakinėja su valdžia netgi netyroms dvasioms, ir jos paklusta jam.“ ");
INSERT INTO lit_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ir tuoj pat garsas apie jį sklido po visą Galilėjos apylinkę. ");
INSERT INTO lit_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ir tuojau, išėję iš sinagogos, jie įėjo į Simono ir Andriejaus namus su Jokūbu ir Jonu. ");
INSERT INTO lit_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","O Simono žmonos motina gulėjo karščiuodama, ir jie tuojau jam pasakoja apie ją. ");
INSERT INTO lit_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ir priėjęs jis paėmė ją už rankos ir ją pakėlė; ir tuojau karštligė pasitraukė nuo jos, ir ji jiems patarnavo. ");
INSERT INTO lit_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ir pas jį ateina raupsuotasis, maldaudamas jo ir klaupdamasis prieš jį, ir jam sakydamas: „Jei tu nori, esi pajėgus mane padaryti švarų. ");
INSERT INTO lit_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ir Jėzus, apimtas gailesčio, ištiesė savo ranką ir palietė jį, ir sako jam: „Noriu, būk švarus. ");
INSERT INTO lit_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ir jam prabilęs tuojau raupsai pasitraukė nuo jo, ir jis buvo padarytas švarus. ");
INSERT INTO lit_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ir griežtai jį įspėjęs, jis tuojau išvarė jį ");
INSERT INTO lit_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ir sako jam: „Žiūrėk, niekam nieko nepasakok, bet eik, pasirodyk kunigui ir aukok už savo nuvalymą tai, ką Mozė įsakė, kad tai būtų liudijimas jiems. ");
INSERT INTO lit_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Bet jis išėjęs pradėjo taip plačiai skelbti ir tą žinią garsinti, kad Jėzus net nebegalėjo atvirai įeiti į miestą, bet buvo toli, dykose vietose; ir jie ateidavo pas jį iš visokių krypčių. ");
INSERT INTO lit_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ir po kelių dienų jis vėl įėjo į Kapernaumą, ir buvo girdėta, kad jis yra namuose. ");
INSERT INTO lit_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ir tuojau susirinko tiek daug, kad nebebuvo vietos, netgi prie durų. Ir jis skelbė jiems žodį. ");
INSERT INTO lit_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ir kai kurie atėjo pas jį atnešdami vieną paralyžiuotą žmogų, kurį nešė keturiese. ");
INSERT INTO lit_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","O matydamas jų tikėjimą, Jėzus tarė paralyžiuotajam: „Sūnau, tavo nuodėmės tau atleistos. ");
INSERT INTO lit_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Bet kad žinotumėte, jog Žmogaus Sūnus turi valdymo galią nuodėmėms atleisti žemėje „jis tarė sergančiam paralyžiumi – ");
INSERT INTO lit_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","sakau tau, kelkis, ir pasiimk savo gultą ir eik į savo namus. ");
INSERT INTO lit_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Tai išgirdęs Jėzus sako jiems: „Ne sveikiesiems reikia gydytojo, bet ligoniams; aš atėjau ne teisiųjų šaukti į atgailą, bet nusidėjėlių.“ ");
INSERT INTO lit_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ir niekas nepila naujo vyno į senus vynmaišius. Antraip naujas vynas suplėšia vynmaišius, ir vynas išsipila, ir vynmaišiai bus sugadinti. Priešingai, naujas vynas piltinas į naujus vynmaišius. ");
INSERT INTO lit_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ir jis tarė jiems: „Šabas atsirado žmogui, o ne žmogus šabui; ");
INSERT INTO lit_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","taigi Žmogaus Sūnus yra ir šabo Viešpats.“ ");
INSERT INTO lit_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ir jis vėl įėjo į sinagogą, o ten buvo žmogus, turintis sudžiūvusią ranką. ");
INSERT INTO lit_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ir jie stebėjo jį, ar jis išgydys jį šabo dieną, kad galėtų jį apkaltinti. ");
INSERT INTO lit_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","O fariziejai išėjo ir tuojau ėmė tartis su erodininkais prieš jį, kaip jie galėtų jį pražudyti. ");
INSERT INTO lit_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ir jis liepė savo mokytiniams jam atidėti valtelę – dėl minios, kad jo nesuspaustų. ");
INSERT INTO lit_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ir jis jiems atsakė, tardamas: „Kas yra mano motina ar mano broliai?“ ");
INSERT INTO lit_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ir apžvelgęs aplink jį sėdinčius, jis sako: „Štai mano motina ir mano broliai! ");
INSERT INTO lit_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Nes kas tik vykdo Dievo valią, tas yra mano brolis, mano sesuo ir motina.“ ");
INSERT INTO lit_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ir jis jiems tarė: „Jums yra duota suprasti Dievo karalystės slėpinį, bet už ribų esantiems visi šitie dalykai būna pateikiami palyginimais, ");
INSERT INTO lit_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","kad regėdami jie regėtų, bet nesuprastų, ir klausydami jie klausytų, bet nesusigaudytų, kad kartais jie neatsiverstų, ir nuodėmės nebūtų jiems atleistos. ");
INSERT INTO lit_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ir daugeliu tokių palyginimų jis kalbėjo jiems žodį, kiek jie pajėgė klausytis. ");
INSERT INTO lit_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ir tą pačią dieną, atėjus vakarui, jis sako jiems: „Persikelkime į kitą pusę. ");
INSERT INTO lit_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ir paleidę minią, jie paima jį su savimi taip, kaip jis buvo valtyje. O jį lydėjo ir kitos valtelės. ");
INSERT INTO lit_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ir pakyla didžiulis viesulas, ir bangos taip daužiasi į valtį, kad ją jau semia. ");
INSERT INTO lit_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","O jis buvo laivo laivagalyje, miegantis ant pagalvės. Ir jie pažadina jį, ir sako jam: „Mokytojau, ar tau nerūpi, kad mes žūstame?“ ");
INSERT INTO lit_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ir pabudęs jis sudraudė vėją ir prabilo į jūrą: „Nutilk, nurimk!“ Ir vėjas liovėsi, ir pasidarė visiškai ramu. ");
INSERT INTO lit_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ir jis tarė jiems: „Kodėl jūs tokie bailūs? Kaipgi yra, kad neturite tikėjimo? ");
INSERT INTO lit_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ir jie labai išsigando ir sakė vienas kitam: „Kas gi yra šitas, kad net vėjas ir jūra jo klauso?“ ");
INSERT INTO lit_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ir jie atvyko į kitą jūros pusę, į gadariečių kraštą. ");
INSERT INTO lit_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","O jam išlipęs iš valties, tuojau susidūrė su juo iš kapų išėjęs netyrosios dvasios valdomas žmogus, ");
INSERT INTO lit_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","kuris gyveno kapų rūsiuose; ir net grandinėmis niekas nepajėgė jo sukaustyti, ");
INSERT INTO lit_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","nes jis daug kartų buvo sukaustytas pančiais ir grandinėmis, bet jis nutraukydavo grandines ir sutrupindavo pančius, ir niekas neįstengdavo jo sutramdyti. ");
INSERT INTO lit_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ir visuomet – naktį ir dieną – jis buvo kalnuose ir kapinėse šaukdamas ir pjaustydamas save akmenimis. ");
INSERT INTO lit_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","O iš tolo pamatęs Jėzų, jis atbėgo ir parpuolė prieš jį, ");
INSERT INTO lit_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ir garsiai šaukdamas tarė: „Kas man ir tau bendro, Jėzau, Dievo Aukščiausiojo Sūnau? Saikdinu tave Dievu, nekankink manęs!“ ");
INSERT INTO lit_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","(Nes jis buvo ne kartą pasakęs jam: „Išeik, netyroji dvasia, iš to žmogaus!“) ");
INSERT INTO lit_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ir jis paklausė jo: „Koks tavo vardas? O jis atsakė, tardamas: „Mano vardas – Legionas, nes mūsų yra daug. ");
INSERT INTO lit_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ir jis labai jį maldavo, kad jų neišsiųstų iš to krašto. ");
INSERT INTO lit_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ir tam tikra moteris, dvylika metų serganti kraujoplūdžiu ");
INSERT INTO lit_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ir daug iškentėjusi nuo daugelio gydytojų ir išleidusi visa, ką turėjo, ir niekuo nesulaukusi pagerėjimo, bet vis ėjusi blogyn, ");
INSERT INTO lit_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","išgirdusi apie Jėzų, priėjo minioje iš užnugario ir palietė jo drabužį. ");
INSERT INTO lit_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Nes ji tarė: „Jeigu paliesiu bent jo drabužius, būsiu išgydyta.“ ");
INSERT INTO lit_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ir tuojau išdžiuvo jos kraujo šaltinis, ir ji pajuto kūnu, kad buvo išgydyta iš savo negalios. ");
INSERT INTO lit_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ir Jėzus, tuojau žinojęs savyje, kad iš jo buvo išėjusi galia, atsigręžęs minioje tarė: „Kas palietė mano drabužius?“ ");
INSERT INTO lit_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ir jo mokytiniai jam tarė: „Tu matai minią, spaudžiančią tave iš visų pusių, o sakai: ‚Kas mane palietė?‘“ ");
INSERT INTO lit_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ir jis žvalgėsi aplinkui, norėdamas pamatyti tą, kuri buvo tai padariusi. ");
INSERT INTO lit_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Bet moteris, bijodama ir drebėdama, žinodama, kas jai buvo atsitikę, atėjo ir parpuolė prieš jį ir papasakojo jam visą tiesą. ");
INSERT INTO lit_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","O jis jai tarė: „Dukterie, tavo tikėjimas išgydė tave, eik ramybėje ir būk pasveikusi iš savo negalios.“ ");
INSERT INTO lit_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Argi šitas nėra tas dailidė, Marijos sūnus, Jokūbo, Jozės, Judo bei Simono brolis? Ir argi ne jo seserys čia su mumis?“ Ir jie piktinosi juo. ");
INSERT INTO lit_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","O jeigu tam tikri žmonės jūsų nepriims ir jūsų nesiklausys, iš ten išeidami nusikratykite dulkes sau po kojomis, kaip liudijimą prieš juos. Iš tiesų sakau jums: teismo dieną Sodomai ir Gomorai bus pakenčiamiau negu tam miestui.“ ");
INSERT INTO lit_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ir tuojau jis privertė savo mokytinius lipti į valtį ir pirmiau vykti į kitą pusę palei Betsaidą, kol jis paleisiąs žmones. ");
INSERT INTO lit_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ir atsisveikinęs su jais, jis nuėjo į kalną melstis. ");
INSERT INTO lit_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","O atėjus vakarui, valtis buvo jūros viduryje, o jis vienas sausumoje. ");
INSERT INTO lit_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ir jis matė juos vargstančius besiiriant, nes vėjas buvo jiems priešingas. Ir apie ketvirtą nakties sargybą jis ateina pas juos, vaikščiodamas jūros paviršiumi, ir norėjo praeiti jiems pro šalį. ");
INSERT INTO lit_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Bet jie, pamatę jį einantį jūros paviršiumi, pamanė tai esant šmėkla, ir ėmė šaukti, ");
INSERT INTO lit_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","nes visi jį matė ir krūptelėjo. Bet jis tuojau į juos prakalba: „Drąsos! Tai aš. Nebijokite!“ ");
INSERT INTO lit_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ir jis įlipo aukščiau pas juos į valtį ir vėjas liovėsi. O jie tarpusavyje labai pervirš apstulbo ir stebėjosi. ");
INSERT INTO lit_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","bet niekaisjie mane garbina, mokydami žmonių priesakų lyg įpareigojančių mokslų.“ ");
INSERT INTO lit_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ir jis tarė jiems: „Puikiai jūs atmetate Dievo įsakymą, kad laikytumėtės savo tradicijos. ");
INSERT INTO lit_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","O jis sako jiems: „Ar ir jūs esate be nuovokos? Argi nesuvokiate, kad visa, kas iš išorės įeina į žmogų, negali jo suteršti? ");
INSERT INTO lit_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Nes tai nepatenka į jo širdį, bet į vidurius, ir išeina išvietėn, kiekvieną valgį padarant švarų. ");
INSERT INTO lit_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ir jis tarė: „Žmogų suteršia tai kas iš žmogaus išeina. ");
INSERT INTO lit_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Būtent iš vidaus, iš žmonių širdies, išeina blogos mintys, svetimavimai, paleistuvystės, žmogžudystės, ");
INSERT INTO lit_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","vagystės, godus troškimai, blogadarybės, suktybė, palaidumas, pavydas, piktžodžiavimas, išdidumas, kvailumas. ");
INSERT INTO lit_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Visos šitos blogybės išeina iš vidaus ir suteršia žmogų. ");
INSERT INTO lit_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ir iš ten jis kėlėsi ir nuėjo Tyro ir Sidono ribų link. Ir įėjęs į vienus namus, jis norėjo, kad niekas apie tai nežinotų, bet jis negalėjo likti nepastebėtas. ");
INSERT INTO lit_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Nes viena moteris, kurios dukrelė turėjo netyrąją dvasią, išgirdusi apie jį, atėjo ir puolė jam po kojų. ");
INSERT INTO lit_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","(O ta moteris buvo graikė, sirofinikiečių tautybės.) Ir ji maldavo jį, kad jis išvarytų iš jos dukros velnią. ");
INSERT INTO lit_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Bet Jėzus jai tarė: „Leisk pirma vaikams pasisotinti, nes nėra gerai imti vaikų duoną ir mesti šunyčiams.“ ");
INSERT INTO lit_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Bet atsakė jinai ir tarė jam: „Taip, Viešpatie. Tačiau ir šunyčiai po stalu ėda vaikų numestus trupinius. ");
INSERT INTO lit_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jis jai tarė: „Dėl šito pasakymo eik; velnias yra išėjęs iš tavo dukros.“ ");
INSERT INTO lit_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ir parėjusi į savo namus, ji rado velnią išėjusį ir dukrą gulinčią ant lovos. ");
INSERT INTO lit_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ir vėl, išėjęs iš Tyro ir Sidono pakraštų, jis atėjo prie Galilėjos jūros per Dekapolio pakraštų vidurį. ");
INSERT INTO lit_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ir jie atveda pas jį sunkiai kalbantį kurčią ir maldauja jį, kad ranką uždėtų ant jo. ");
INSERT INTO lit_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ir pasivedęs jį nuošaliau nuo minios, jis įkišo savo pirštus į jo ausis, ir spjovęs palietė jo liežuvį, ");
INSERT INTO lit_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ir pažvelgęs į dangų, atsiduso ir sako jam: „Efata!“ – tai yra: „Atsiverk!“ ");
INSERT INTO lit_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ir tuojau buvo atverti jo ausys, ir buvo atrištas jo liežuvio raištis, ir jis kalbėjo aiškiai. ");
INSERT INTO lit_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ir jis jiems davė įsakymą, kad niekam nepasakotų, bet kuo labiau jis jiems įsakydavo, tuo dar labiau jie tai skelbdavo ");
INSERT INTO lit_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","ir be saiko nustebdavo, sakydami: „Jis visa padarė gerai! Jis ir kurčiuosius daro girdinčius ir nebylius kalbančius!“ ");
INSERT INTO lit_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Tomis dienomis esant labai didelei miniai ir jiems neturint ko valgyti, Jėzus, pasišaukęs savo mokytinius, sako jiems: ");
INSERT INTO lit_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","„Mane apima gailestis dėl minios, nes jau trys dienos, kaip jie pasilieka su manimi ir neturi ko valgyti. ");
INSERT INTO lit_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ir jei paleisiu juos alkanus į jų namus, jie nuils kelyje, nes kai kurie iš jų yra atėję iš toli. ");
INSERT INTO lit_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ir jo mokytiniai jam atsakė: „Iš kur kas galės šiuos žmones pasotinti duona čia dykumoje?“ ");
INSERT INTO lit_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ir jis paklausė jų: „Kiek turite kepalų?“ Ir jie tarė: „Septynis.“ ");
INSERT INTO lit_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ir jis liepė miniai susėsti ant žemės, ir paėmęs septynis kepalus ir padėkojęs, jis davė savo mokytiniams, kad pristatytų, ir jie pristatinėjo miniai. ");
INSERT INTO lit_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Jie dar turėjo kelias žuveles, tai palaiminęs, jis pasakė jiems pristatyti ir jas. ");
INSERT INTO lit_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Tad jie valgė ir pasisotino ir pririnko gabalų perteklių – septynias pintines. ");
INSERT INTO lit_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","O buvo kokie keturi tūkstančiai valgiusieji; ir jis paleido juos. ");
INSERT INTO lit_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ir tuojau įlipęs su savo mokytiniais į valtį, jis atvyko į Dalmanutos regioną. ");
INSERT INTO lit_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ir jis ateina į Betsaidą, o jam atveda akląjį, ir maldauja jį, kad jį paliestų. ");
INSERT INTO lit_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ir paėmęs akląjį už rankos, jis nusivedė jį iš kaimo; ir spjovęs jam į akis ir uždėjęs ant jo savo rankas, jis paklausė jo, ar jis ką nors mato. ");
INSERT INTO lit_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","O pažvelgęs aukštyn, jis tarė: „Matau žmones kaip medžius, vaikščiojančius. ");
INSERT INTO lit_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Paskui jis vėl uždėjo rankas jam ant akių ir privertė jį žvelgti aukštyn; ir jis buvo išgydytas, ir jis visus žmones matė aiškiai. ");
INSERT INTO lit_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ir jis išsiuntė jį namo, sakydamas: „Tau nevalia ir eiti į kaimą, ir bet kam nors kaime pasakoti. ");
INSERT INTO lit_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ir išėjo Jėzus ir jo mokytiniai į Pilypo Cezarėjos kaimus. Ir kelyje jis paklausė savo mokytinių, jiems sakydamas: „Žmonės sako, kad aš esu kas? ");
INSERT INTO lit_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","O jie atsakė: „Jonas Krikštytojas, o kiti Elijas, dar kiti – vienas iš pranašų. ");
INSERT INTO lit_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ir jis sako jiems: „Bet jūs sakote, kad aš esu kas? Ir Petras atsakydamas taria jam: „Tu esi Kristus. ");
INSERT INTO lit_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ir jis pagrasino jiems, kad niekam to nesakytų apie jį. ");
INSERT INTO lit_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ir jis pradėjo juos mokyti, kad Žmogaus Sūnus turės daug iškentėti ir būti atmestas vyresniųjų bei aukštųjų kunigų bei raštininkų ir būti nužudytas ir po trijų dienų prisikelti. ");
INSERT INTO lit_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ir pasišaukęs minią su savo mokytiniais jis tarė jiems: „Bet kas, kuris nori eiti paskui mane, tas privalo išsižadėti savęs, privalo pasiimti savo kryžių ir privalo sekti paskui mane. ");
INSERT INTO lit_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Nes bet kas, kuris ketina išgelbėti savo gyvybę, tas ją pražudys, o bet kas, kuris pražudys savo gyvybę dėl manęs ir dėl evangelijos, tas ją išgelbės. ");
INSERT INTO lit_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Kokia gi žmogui būtų nauda, jeigu jis laimėtų visą pasaulį ir prarastų savo sielą? ");
INSERT INTO lit_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Arba ką žmogus duos mainais už savo sielą?! ");
INSERT INTO lit_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Todėl bet kas, kuris gėdysis manęs ir mano žodžių šioje svetimaujančioje ir nuodėmingoje kartoje, to gėdysis ir Žmogaus Sūnus, kai jis ateis savo Tėvo šlovėje su šventaisiais angelais.“ ");
INSERT INTO lit_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ir po šešių dienų Jėzus pasiima Petrą, Jokūbą ir Joną ir užsiveda juos vienus nuošaliai į aukštą kalną, ir jis atsimainė jų akivaizdoje, ");
INSERT INTO lit_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ir jo drabužiai pasidarė spindintys, nepaprastai balti kaip sniegas, kaip jų išbaltinti negalėtų joks vėlėjas žemėje. ");
INSERT INTO lit_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ir jiems pasirodė Elijas su Moze, ir jie kalbėjosi su Jėzumi. ");
INSERT INTO lit_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ir atsiliepdamas Petras sako Jėzui: „Mokytojau, gera mums čia būti. Pastatykime tris padangtes: vieną tau, vieną Mozei ir vieną Elijui.“ ");
INSERT INTO lit_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Juk jis nežinojo, ką sakyti, nes jie buvo persigandę.) ");
INSERT INTO lit_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ir užėjo debesis, pridengdamas juos šešėliu, ir iš debesies atėjo balsas, tardamas: „Šitas yra mano mylimasis Sūnus – klausykite jo!“ ");
INSERT INTO lit_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ir staiga, apsidairę, jie nieko prie savęs nebematė, tik Jėzų vieną. ");
INSERT INTO lit_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ir atėjęs pas mokytinius, jis pamatė aplink juos didžiulę minią ir diskutuojančius su jais raštininkus. ");
INSERT INTO lit_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ir tuojau visi žmonės, jį pamatę, nepaprastai nustebo ir pribėgę, jį pasveikino. ");
INSERT INTO lit_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Tada jis paklausė raštininkų: „Ką diskutuojate su jais?“ ");
INSERT INTO lit_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ir vienas iš minios atsakydamas tarė: „Mokytojau, aš atvedžiau pas tave savo sūnų, kuris turi nebylę dvasią, ");
INSERT INTO lit_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","ir kur tik ji sugriebia jį, ji parmeta jį žemyn, ir jis atsiputoja, ir griežia dantimis, ir sudžiūsta. O aš prašiau tavo mokytinių, kad jie ją išvarytų, bet jie neįstengė. ");
INSERT INTO lit_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jis atsako jam ir taria: „O netikinti karta! Iki kol aš būsiu su jumis? Iki kol jus pakęsiu? Atneškite jį pas mane.“ ");
INSERT INTO lit_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ir jie jį atvedė pas jį, ir, jį pamačiusi, dvasia tuojau ėmė jį tąsyti, ir parpuolęs ant žemės jis voliojosi apsiputodamas. ");
INSERT INTO lit_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ir jis paklausė jo tėvo: „Jam taip darosi nuo kada?“ Ir jis pasakė: „Nuo mažumės. ");
INSERT INTO lit_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ir ji dažnai įmesdavo jį tai į ugnį, tai į vandenį, kad jį pražudytų. Bet jeigu tu pajėgi ką nors padaryti, padėk mums, pasigailėjęs mūsų!“ ");
INSERT INTO lit_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Tad Jėzus jam tarė: „Jei tu pajėgi tikėti, viskas yra įmanoma tam, kuris tiki.“ ");
INSERT INTO lit_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ir vaiko tėvas sušukdamas tuojau tarė su ašaromis: „Viešpatie, aš tikiu! Padėk mano netikėjimui!“ ");
INSERT INTO lit_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","O kai Jėzus pamatė, kad susibėga minia, jis sudraudė netyrąją dvasią, sakydamas jai: „Nebyle ir kurčia dvasia, įsakau tau, išeik iš jo ir daugiau į jį nebeįeik!“ ");
INSERT INTO lit_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ir sušukusi ir smarkiai jį tąsiusi, dvasia išėjo. O jis pasidarė tarsi negyvas, kad net daugelis sakė, kad jis miręs. ");
INSERT INTO lit_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Bet Jėzus, paėmęs jį už rankos, pakėlė jį, ir jis atsistojo. ");
INSERT INTO lit_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ir jam įėjus į namus, jo mokytiniai paklausė jo atskirai: „Kodėl mes nepajėgėme jos išvaryti? ");
INSERT INTO lit_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ir jis tarė jiems: „Ši veislė negali išeiti nieku kitu, kaip tik malda ir pasninku.“ ");
INSERT INTO lit_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ir atsisėdęs jis pasišaukė Dvylika ir jiems sako: „Jei kas trokšta būti pirmas, tas bus visų paskutinis ir visų tarnas.“ ");
INSERT INTO lit_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ir paėmęs vaikutį, jis jį pastatė tarp jų ir jį apkabinęs, tarė jiems: ");
INSERT INTO lit_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ir jei tavo ranka verčia tave nupulti į nuodėmę, nukirsk ją! Tau geriau įeiti į gyvenimą neturinčiam kūno dalių, negu su abiem rankom patekti į pragarą, į neužgesinamą ugnį, ");
INSERT INTO lit_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","kur jų kirminas nemiršta ir ugnis neužgęsta. ");
INSERT INTO lit_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ir jei tavo koja verčia tave nupulti į nuodėmę, nukirsk ją! Tau geriau įeiti į gyvenimą raišam, negu su abiem kojom būti įmestam į pragarą, į neužgesinamą ugnį, ");
INSERT INTO lit_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","kur jų kirminas nemiršta ir ugnis neužgęsta. ");
INSERT INTO lit_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ir jei tavo akis verčia tave nupulti į nuodėmę, nukirsk ją! Tau geriau vienakiui įeiti į Dievo karalystę, negu su abiem akim būti įmestam į ugnies pragarą, ");
INSERT INTO lit_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","kur jų kirminas nemiršta ir ugnis neužgęsta. ");
INSERT INTO lit_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Bet nuo sukūrimo pradžios DIEVAS PADARĖ TOKIUS – VYRIŠKĮ IR MOTERIŠKĘ. ");
INSERT INTO lit_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","DĖL ŠIOS PRIEŽASTIES VYRAS PALIKS SAVO TĖVĄ IR MOTINĄ IR SUSIJUNGS SU SAVO ŽMONA, ");
INSERT INTO lit_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ir jie pristatė jam vaikučius, kad jis juos paliestų, bet jo mokytiniai barė tuos, kurie juos pristatė. ");
INSERT INTO lit_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Bet tai pamatęs, Jėzus labai užsigavo ir tarė jiems: „Leiskite vaikučiams ateiti pas mane ir nedrauskite jiems, nes tokių yra Dievo karalystė. ");
INSERT INTO lit_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Iš tiesų sakau jums: kas nepriims Dievo karalystės kaip vaikutis, tas jokiu būdu į ją neįeis. ");
INSERT INTO lit_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","O juos apkabinęs ir ant jų uždėjęs rankas, jis juos palaimino. ");
INSERT INTO lit_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ir jam išeinant į kelią, vienas žmogus, pribėgęs ir atsiklaupęs prieš jį, paklausė jo: „Gerasis Mokytojau, ką turiu daryti, kad paveldėčiau amžiną gyvenimą?“ ");
INSERT INTO lit_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Bet Jėzus jam tarė: „Kodėl vadini mane geru? Niekas nėra geras, tik vienas Dievas. ");
INSERT INTO lit_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Tu žinai įsakymus: Nesvetimauk, nevykdyk žmogžudystės, nevok, melagingai neliudyk, neapgauk, gerbk savo tėvą ir motiną.“ ");
INSERT INTO lit_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","O tas atsakydamas tarė jam: „Mokytojau, visų šitų aš laikiausi nuo pat jaunystės.“ ");
INSERT INTO lit_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Tada Jėzus, įdėmiai žvelgdamas į jį, pamilo jį ir tarė jam: „Vieno dalyko tau trūksta: eik, parduok viską, ką turi, ir atiduok vargšams, ir turėsi lobį danguje. Ir ateik, sek paskui mane imdamas kryžių.“ ");
INSERT INTO lit_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ir paniuręs dėl to pasakymo jis pasitraukė sielodamasis, nes jis turėjo didelius turtus. ");
INSERT INTO lit_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ir apžvelgdamas aplinkui Jėzus *tarė savo mokytiniams: „Kaip sunkiai tie, kurie turi turtus, įeis į Dievo karalystę!“ ");
INSERT INTO lit_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ir mokytiniai stebėjosi jo žodžiais. O Jėzus dar kartą atsakydamas jiems sako: „Vaikai, kaip sunku tiems, kurie pasitiki turtais, įeiti į Dievo karalystę! ");
INSERT INTO lit_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Lengviau kupranugariui pralįsti pro adatos ausį, negu turtingam įeiti į Dievo karalystę.“ ");
INSERT INTO lit_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ir jie nustebo nepaprastai, ir tarpusavyje pasakė: „Tai kas gali būti išgelbėtas?!“ ");
INSERT INTO lit_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","O Jėzus, žiūrėdamas į juos, *tarė: „Žmonėms tai neįmanoma, bet ne Dievui, nes Dievui viskas yra įmanoma.“ ");
INSERT INTO lit_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Nes ir Žmogaus Sūnus atėjo ne kad jam tarnautų, bet kad jis pats tarnautų ir savo gyvybės atiduotų kaip išpirkos vietoj daugelio.“ ");
INSERT INTO lit_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ir jie *atėjo į Jerichą. O iškeliaujant jam su savo mokytiniais ir gausinga minia iš Jericho, pakelėje sėdėjo aklas Bartimiejus, Timiejaus sūnus, elgetaudamas. ");
INSERT INTO lit_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ir išgirdęs, kad tai yra Jėzus Nazarietis, jis pradėjo šaukti ir sakyti: „Dovydo Sūnau, Jėzau, pasigailėk manęs!“ ");
INSERT INTO lit_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ir Jėzus sustojo ir įsakė pašaukti jį. Ir jie pašaukia akląjį, jam sakydami: „Būk drąsus! Kelkis! Jis tave šaukia!“ ");
INSERT INTO lit_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ir kai jie artėja į Jeruzalę, į Betfagę ir Betaniją, ties Alyvų kalnu, jis išsiunčia du savo mokytinius ");
INSERT INTO lit_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ir sako jiems: „Eikite į priešais jus esantį kaimą ir, vos tik į jį įžengę, rasite pririštą asilaitį, ant kurio joks žmogus dar nėra sėdėjęs: atriškite jį ir atveskite. ");
INSERT INTO lit_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ir jeigu kas jums sakytų: „Kodėl tai darote? sakykite, kad Viešpačiui jo reikia, ir jis tuojau pasiųs jį čionai“.“ ");
INSERT INTO lit_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Tai jie nuėjo ir rado pririštą asilaitį lauke prie durų, vietoje, kur susitinka du keliai ir jie atriša jį. ");
INSERT INTO lit_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ir kai kurie iš ten stovinčių jiems tarė: „Ką jūs darote, kad atrišote asilaitį?“ ");
INSERT INTO lit_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","O jie pasakė jiems, kaip Jėzus buvo paliepęs, ir tie juos išleido. ");
INSERT INTO lit_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ir jie atvedė asilaitį pas Jėzų ir užmetė ant jo savo drabužius, o jis užsėdo ant jo. ");
INSERT INTO lit_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ir daugelis tiesė ant kelio savo drabužius, o kiti kirto medžių šakas ir klojo jas ant kelio. ");
INSERT INTO lit_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ir tie, kurie ėjo priekyje, ir tie, kurie sekė paskui, vis šaukė, sakydami: „Osana! Palaimintas yra tas, kuris ateina Viešpaties vardu! ");
INSERT INTO lit_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Palaiminta mūsų tėvo Dovydo karalystė, kuri ateina Viešpaties vardu! Osana aukščiausiose aukštybėse! ");
INSERT INTO lit_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ir Jėzus atsakydamas jiems sako: „Turėkite tikėjimą Dievu. ");
INSERT INTO lit_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ir kai stovite melsdamiesi, atleiskite, jei ką nors turite prieš ką, kad ir jūsų Tėvas, kuris danguje, atleistų jums jūsų nusižengimus. ");
INSERT INTO lit_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Bet jeigu jūs neatleidžiate, tai nė jūsų Tėvas, kuris danguje, neatleis jūsų nusižengimų. ");
INSERT INTO lit_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ir jie vėl ateina į Jeruzalę; ir jam vaikščiojant šventykloje pas jį ateina vyriausieji kunigai, raštininkai bei vyresnieji ");
INSERT INTO lit_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ir sako jam: „Kokiu įgaliojimu tu šiuos dalykus darai? Ir kas tau davė tokį įgaliojimą šiuos dalykus daryti? ");
INSERT INTO lit_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ir Jėzus atsakydamas tarė jiems: „Aš irgi paklausiu jus vieno dalyko, o jūs man atsakykite. Tada jums pasakysiu, kokiu įgaliojimu aš šiuos dalykus darau. ");
INSERT INTO lit_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Jono krikštas buvo iš dangaus ar iš žmonių? Atsakykite man!“ ");
INSERT INTO lit_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ir jie atsakydami tarė Jėzui: „Mes nežinome.“ Ir Jėzus atsakydamas jiems sako: „Tai nė aš jums nesakysiu, kokiu įgaliojimu aš šiuos dalykus darau.“ ");
INSERT INTO lit_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ir Jėzus atsakydamas tarė jiems: „Argi ne todėl klystate, kad nepažįstate nei šventraščių, nei Dievo galios? ");
INSERT INTO lit_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Nes pats Dovydas sakė Šventąja Dvasia: ‚VIEŠPATS tarė mano Viešpačiui: Sėskis mano dešinėje, kol aš pastatysiu tavo priešus tavo pakoju.‘ ");
INSERT INTO lit_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Taigi pats Dovydas jį vadina Viešpačiu; tai iš kur tai, kad jis yra jo sūnus?“ Ir paprasti žmonės mielai jo klausėsi. ");
INSERT INTO lit_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ir jūs būsite visų nekenčiami dėl mano vardo; bet kas ištvers iki galo, tas bus išgelbėtas. ");
INSERT INTO lit_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Dangus ir žemė praeis, bet mano žodžiai niekaip nepraeis. ");
INSERT INTO lit_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Bet apie tos Dienos ir Valandos laiką niekas nežino, nei angelai, kurie yra danguje, nei Sūnus, bet tik Tėvas. ");
INSERT INTO lit_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Būkite atsargūs, budėkite ir melskitės, nes nežinote, kada tas laikas bus! ");
INSERT INTO lit_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Po dviejų dienų buvo numatyta Aplenkimo ir Neraugintosios duonos šventė, ir aukštieji kunigai bei raštininkai ieškojo būdo klasta suimti jį ir nužudyti. ");
INSERT INTO lit_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Bet jie tarė: „Tik ne per šventę, kad nebūtų žmonių sąmyšio.“ ");
INSERT INTO lit_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Iš tiesų sakau jums: visame pasaulyje, kur tik bus skelbiama ši evangelija, ir jos atminimui bus pasakojama, ką ji padarė.“ ");
INSERT INTO lit_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ir Judas Iskarijotas, vienas iš Dvylikos, nuėjo pas aukštuosius kunigus, kad jiems jį išduotų. ");
INSERT INTO lit_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ir jie, tai išgirdę, apsidžiaugė ir pažadėjo duoti jam pinigų. O jis ieškojo būdo patogiu laiku jį išduoti. ");
INSERT INTO lit_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ir pirmąją Neraugintosios duonos dieną, kada aukojamas Aplenkimo avinėlis, jo mokytiniai jam tarė: „Kur nori, kad eitume paruošti, kad valgytum Aplenkimo avinėlį?“ ");
INSERT INTO lit_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ir jis išsiunčia du savo mokytinius ir sako jiems: „Eikite į miestą, ir ten jus sutiks vyras, vandens ąsočiu nešinas. Sekite paskui jį ");
INSERT INTO lit_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ir kur tik jis įeis, sakykite namų šeimininkui: ‚Mokytojas sako: „Kur yra svečių kambarys, kuriame galėčiau su savo mokytiniais valgyti Aplenkimo avinėlį?“‘ ");
INSERT INTO lit_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ir jis parodys jums didelį aukštutinį kambarį, apstatytą ir paruoštą. Ten paruoškite mums.“ ");
INSERT INTO lit_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ir jo mokytiniai išėjo ir atėjo į miestą ir rado taip, kaip jis buvo jiems sakęs. Ir jie paruošė Aplenkimo avinėlį. ");
INSERT INTO lit_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ir vakare jis ateina su Dvylika, ");
INSERT INTO lit_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","ir jiems atsilošiant ir valgant, Jėzus tarė: „Iš tiesų sakau jums: vienas iš jūsų mane išduos – kuris valgo su manimi.“ ");
INSERT INTO lit_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ir jie pradėjo liūdėti ir jam pasakyti vienas po kito: „Nejaugi aš? Ir kitas: „Nejaugi aš? ");
INSERT INTO lit_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ir jis atsakydamas tarė jiems: „Vienas iš Dvylikos, kuris mirko su manimi duoną į dubenį. ");
INSERT INTO lit_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Žmogaus Sūnus tikrai eina, kaip apie jį parašyta, bet vargas tam žmogui, per kurį Žmogaus Sūnus išduodamas! Gerai būtų buvę tam žmogui, jei jis nebūtų gimęs.“ ");
INSERT INTO lit_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ir jiems valgant, Jėzus, paėmęs duoną ir pasakęs palaiminimą, ją laužė ir davė jiems ir tarė: „Imkite, valgykite – tai yra mano kūnas.“ ");
INSERT INTO lit_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ir paėmęs taurę ir padėkojęs, jis davė jiems, ir jie visi gėrė iš jos. ");
INSERT INTO lit_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ir jis tarė jiems: „Tai yra mano kraujas, kuris yra naujosios sandoros kraujas, kuris išliejamas už daugelį. ");
INSERT INTO lit_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Iš tiesų sakau jums: visai nebegersiu vynmedžio vaisiaus iki tos dienos, kada gersiu jį naują Dievo karalystėje.“ ");
INSERT INTO lit_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ir pagiedoję giesmę jie išėjo į Alyvų kalną. ");
INSERT INTO lit_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Bet Petras jam tarė: „Nors ir visi atsimes, tačiau ne aš!“ ");
INSERT INTO lit_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ir jie ateina į vietą, kurios vardas Getsemanė. Ir jis sako savo mokytiniams: „Sėskite čia, kol aš melsiuosi.“ ");
INSERT INTO lit_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ir jis pasiėmė* su savimi Petrą ir Jokūbą ir Joną ir pradėjo nepaprastai nustebti bei pajusti didžiulę apsunkinimą ");
INSERT INTO lit_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ir jiems tarė*: „Mano siela labai nuliūdusi – iki mirties. Pasilikite čia ir budėkite!“ ");
INSERT INTO lit_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ir paėjęs truputį toliau, jis puolė ant žemės ir meldėsi, kad, jei įmanoma, ta valanda nuo jo praeitų. ");
INSERT INTO lit_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ir jis tarė: „Aba, Tėve, tau viskas įmanoma; atimk šią taurę nuo manęs! Tačiau tebūnie ne tai, ko noriu aš, bet tai, ko nori tu.“ ");
INSERT INTO lit_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ir jis ateina ir randa juos miegančius, ir sako Petrui: „Simonai, tu miegi? Neįstengei nė vienos valandos pabudėti? ");
INSERT INTO lit_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Budėkite ir melskitės, kad neįžengtumėte į pagundą. Dvasia iš tiesų noringa, bet kūnas silpnas.“ ");
INSERT INTO lit_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ir vėl nuėjęs jis meldėsi, tardamas tuos pačius žodžius. ");
INSERT INTO lit_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ir sugrįžęs, jis juos rado vėl miegančius (nes jų akys buvo apsunkusios), ir jie nežinojo, ką jam atsakyti. ");
INSERT INTO lit_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ir jis ateina trečią kartą ir sako jiems: „Miegokite dabar ir ilsėkitės! Gana! Atėjo ta valanda: štai Žmogaus Sūnus išduodamas į nusidėjėlių rankas. ");
INSERT INTO lit_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Kelkitės, eime! Štai mano išdavėjas yra prisiartinęs.“ ");
INSERT INTO lit_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ir tuojau, jam tebekalbant, ateina Judas, esantis vienas iš Dvylikos, o su juo didelė minia su kalavijais ir vėzdais, nuo aukštųjų kunigų, raštininkų ir vyresniųjų. ");
INSERT INTO lit_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ir jo išdavėjas buvo jiems davęs ženklą, sakydamas: „Kurį pabučiuosiu, tai yra tas. Jį suimkite ir saugiai nuveskite.“ ");
INSERT INTO lit_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ir vos tik atėjęs jis tuojau prisiartino prie jo ir sako: „Mokytojau, mokytojau!“ – ir pabučiavo jį. ");
INSERT INTO lit_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ir jie visi paliko jį ir pabėgo. ");
INSERT INTO lit_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ir toks vienas jaunuolis sekė paskui jį, užsimetęs lininį audeklą aplink savo nuogą kūną, ir jauni vyrai jį griebia. ");
INSERT INTO lit_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Bet jis paliko lininį audeklą ir pabėgo nuo jų nuogas. ");
INSERT INTO lit_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Tačiau jis tylėjo ir nieko neatsakė. Vyriausiasis kunigas pakartotinai jį klausinėjo tardamas jam: „Ar tu esi Kristus, Palaimintojo Sūnus?“ ");
INSERT INTO lit_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ir Jėzus tarė: „Aš esu. Ir jūs pamatysite žmogaus Sūnų, sėdintį Galybės dešinėje ir ateinantį dangaus debesimis.“ ");
INSERT INTO lit_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Mat jis suprato, kad aukštieji kunigai buvo jį perdavę iš pavydo. ");
INSERT INTO lit_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ir kareiviai nusivedė jį į kiemą, kuris yra teismo aikštė, ir *sušaukė visą batalioną. ");
INSERT INTO lit_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ir jie apvelkia jį purpuriniu apdaru ir nupynę uždeda jam aplinkui galvą erškėčių vainiką. ");
INSERT INTO lit_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ir po to, kai pasityčiojo iš jo, jie nuvilko nuo jo purpurinį apdarą ir apvilko jį jo paties drabužiais ir jį išveda, kad jį nukryžiuotų. ");
INSERT INTO lit_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ir jie priverčia vieną pareinantį iš lauko praeivį – Simoną kirėnietį, Aleksandro ir Rufo tėvą – nešti jo kryžių. ");
INSERT INTO lit_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ir jie atneša jį į Golgotos vietą, kuris išvertus reiškia: „Kaukolės vieta“. ");
INSERT INTO lit_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ir jie davė jam gerti vyno, primaišyto su mira, bet jis nepriėmė. ");
INSERT INTO lit_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ir jį nukryžiavę, jie pasidalijo jo drabužius, mesdami dėl jų burtus, kas ką imsiąs. ");
INSERT INTO lit_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","O buvo trečia valanda, ir jie nukryžiavo jį. ");
INSERT INTO lit_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Taip pat buvo užrašytas jo kaltinimo užrašas: „ŽYDŲ KARALIUS“. ");
INSERT INTO lit_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ir kartu su juo jie nukryžiavo du vagis: vieną jo dešinėje, o kitą jo kairėje. ");
INSERT INTO lit_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ir išsipildė šventraštis, kuris sako: „Ir jis buvo priskaitytas prie įstatymo pažeidėjų“. ");
INSERT INTO lit_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","O praeiviai plūdo jį, kraipydami savo galvas ir sakydami: „Še tau, kuris sugriauni šventyklą ir per tris dienas ją atstatai! ");
INSERT INTO lit_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Išgelbėk save ir nuženk nuo kryžiaus!“ ");
INSERT INTO lit_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","O panašiai ir aukštieji kunigai tarpusavyje su raštininkais tyčiodamiesi sakė: „Jis išgelbėjo kitus, pats savęs nepajėgia išgelbėti!“ ");
INSERT INTO lit_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Tegul Kristus, Izraelio Karalius, nužengia dabar nuo kryžiaus, kad matytume ir tikėtume! Taip pat tie, kurie buvo su juo nukryžiuoti, užgauliojo jį. ");
INSERT INTO lit_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ir šeštai valandai atėjus, visą šalį apgaubė tamsa iki devintos valandos. ");
INSERT INTO lit_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","O devintą valandą Jėzus garsiu balsu šaukė, sakydamas: „Eloi, Eloi, lama sabachtani? (Tai išvertus yra: „Mano Dieve, mano Dieve, kodėl mane apleidai?) ");
INSERT INTO lit_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ir kai kurie šalia stovintys išgirdę sakė: „Žiūrėk, jis šaukiasi Elijo. ");
INSERT INTO lit_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Tada vienas nubėgęs ir pripildęs kempinę pilną acto ir užmovęs ją ant nendrės, davė jam gerti, sakydamas: „Palaukite, pažiūrėsime, ar ateis Elijas jo nuimti. ");
INSERT INTO lit_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Bet Jėzus išleidęs skardų šauksmą išleido dvasią. ");
INSERT INTO lit_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ir šventyklos uždanga buvo perplėštas pusiau nuo viršaus iki apačios. ");
INSERT INTO lit_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ir jis jiems tarė: „Eikite į visą pasaulį ir skelbkite Evangeliją visai kūrinijai. ");
INSERT INTO lit_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Kas yra pasitikėjęs ir pakrikštytas, bus išgelbėtas; bet kas nėra pasitikėjęs, bus nuteistas. ");
INSERT INTO lit_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Kadangi daugelis užsiėmė iš eilės išdėstyti nupasakojimą apie tuos dalykus, kuriais mes visiškai tikime ");
INSERT INTO lit_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","lygiai taip, kaip perdavė mums tie, kurie nuo pradžios savo akimis matė ir buvo tapę žodžio patikėtiniai, ");
INSERT INTO lit_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","atrodė gerai ir man, akylai sekusiam visus tuos dalykus su didžiu tikslumu nuo pat pradžios, nuosekliai surašyti tau, prakilnusis Teofiliau, ");
INSERT INTO lit_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","kad iš arti pažintum užtikrintumą pranešimų, kurių esi pamokytas. ");
INSERT INTO lit_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Judėjos karaliaus Erodo dienomis buvo tam tikras kunigas, vardu Zacharijas, iš Abijos skyriaus ir jo žmona iš Aarono dukterų, o jos vardas buvo Elžbieta. ");
INSERT INTO lit_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ir jie abu buvo teisūs prieš Dievą, besivaikščiojantys pagal visus Viešpaties įsakymus ir nuostatus, nepeiktini. ");
INSERT INTO lit_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ir jie neturėjo vaikų, nes Elžbieta buvo nevaisinga, ir jie abu buvo sulaukę senyvo amžiaus. ");
INSERT INTO lit_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ir įvyko šitaip, kad, jam beatliekant kunigo tarnystę Dievo akivaizdoje pagal jo skyriaus eilę, ");
INSERT INTO lit_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","vadovaujantis kunigo tarnystės papročiu, sprendžiančio sutartinio ženklo būdu jam teko deginti smilkalus, įėjus į Viešpaties šventyklą. ");
INSERT INTO lit_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Tuo tarpu, smilkymo valandą visa žmonių minia meldėsi lauke. ");
INSERT INTO lit_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ir jam pasirodė Viešpaties angelas, stovintis smilkalų aukuro dešinėje. ");
INSERT INTO lit_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","O Zacharijas, jį pamatęs, krūptelėjo, ir pagavo jį išgąstis. ");
INSERT INTO lit_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Bet angelas jam tarė: „Nebijok, Zacharijau, nes tavo malda išklausyta, ir tavo žmona Elžbieta pagimdys tau sūnų, ir tu pavadinsi jį vardu Jonas. ");
INSERT INTO lit_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Bus džiaugsmo tau, net džiūgavimas, ir daugelis džiaugsis jo gimimu, ");
INSERT INTO lit_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","nes jis bus didis Viešpaties akyse. Jis ir būtinai neturės gerti vyno bei stipraus gėrimo, ir bus pripildytas Šventosios Dvasios iš pat savo motinos įsčių. ");
INSERT INTO lit_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ir daugelį Izraelio vaikų jis atvers į Viešpatį, jų Dievą. ");
INSERT INTO lit_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ir jis eis pirma jo su Elijo dvasia ir galybe, kad atverstų tėvų širdis į vaikus ir neklusniuosius į teisiųjų išmintį, kad prirengtų Viešpačiui išsamiai paruoštų žmonių.“ ");
INSERT INTO lit_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Bet Zacharijas tarė angelui: „Kaip aš tai žinosiu? Juk aš esu senas žmogus ir mano žmona sulaukusi senyvo amžiaus.“ ");
INSERT INTO lit_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","O angelas atsakydamas jam tarė: „Aš esu Gabrielius, kuris stoviu Dievo akivaizdoje, ir esu atsiųstas kalbėti tau ir tau pranešti šias geras žinias. ");
INSERT INTO lit_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ir štai tu būsi nebylys, tai yra negalėsi kalbėti iki dienos, kurią tai įvyks, nes nepatikėjai mano žodžiais, kurie išsipildys savo metu.“ ");
INSERT INTO lit_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Tuo tarpu žmonės laukė Zacharijo ir stebėjosi, kad jis taip ilgai užtrunka šventykloje. ");
INSERT INTO lit_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Bet išėjęs, jis negalėjo jiems kalbėti, ir jie suprato, kad jis buvo matęs regėjimą šventykloje. Ir jis aiškinosi jiems gestais ir pasiliko nebylus. ");
INSERT INTO lit_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ir taip įvyko, kad pasibaigus jo tarnystės dienoms, jis parėjo namo. ");
INSERT INTO lit_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ir po tų dienų jo žmona Elžbieta tapo nėščia ir penkis mėnesius slėpėsi, sakydama: ");
INSERT INTO lit_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","„Taip Viešpats su manimi pasielgė tomis dienomis, kuriomis jis pažvelgė į mane, kad nuimtų mano negarbę tarp žmonių.“ ");
INSERT INTO lit_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ir šeštąjį mėnesį angelas Gabrielius buvo Dievo pasiųstas į Galilėjos miestą, vadinamą Nazaretu, ");
INSERT INTO lit_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","pas mergelę, pažadėtą į žmonas vyrui iš Dovydo namų, kurio vardas buvo Juozapas; o mergelės vardas buvo Marija. ");
INSERT INTO lit_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Atėjęs pas ją, angelas tarė: „Sveika, malone apdovanotoji! Viešpats su tavimi! Palaiminta tu tarp moterų! ");
INSERT INTO lit_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ir jį pamačiusi ji labai susijaudino dėl jo pasakymo ir galvojo sau, kas tai turėtų būti per pasveikinimas. ");
INSERT INTO lit_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","O angelas jai tarė: „Nebijok, Marija, nes radai malonę pas Dievą! ");
INSERT INTO lit_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ir štai tu pradėsi savo įsčiose ir pagimdysi sūnų, ir pavadinsi jį vardu Jėzus. ");
INSERT INTO lit_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Jis bus didis ir bus vadinamas Aukščiausiojo Sūnumi, ir Viešpats Dievas duos jam jo tėvo Dovydo sostą, ");
INSERT INTO lit_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ir jis karaliaus Jokūbo namams per amžius, ir jo karalystei nebus galo.“ ");
INSERT INTO lit_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Tuomet Marija tarė angelui: „Kaip tai bus? Nes nepažįstu vyro.“ ");
INSERT INTO lit_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","O angelas atsakydamas tarė jai: „Ant tavęs nužengs Šventoji Dvasia, ir Aukščiausiojo jėga pridengs tave šešėliu; todėl kas gims iš tavęs – tas, kas šventas, – bus vadinamas Dievo Sūnumi. ");
INSERT INTO lit_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ir štai tavo giminaitė Elžbieta, ji taip pat pradėjo sūnų savo senatvėje, ir šis mėnuo yra šeštas jai, kuri buvo vadinama nevaisinga, ");
INSERT INTO lit_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","nes Dievui nieko nėra neįmanomo.“ ");
INSERT INTO lit_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Tada Marija tarė: „Štai aš Viešpaties tarnaitė, tebūna man pagal tavo žodį.“ Ir angelas nuo jos pasitraukė. ");
INSERT INTO lit_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ir tomis dienomis Marija atsikėlė ir skubiai nukeliavo į kalnyną, į vieną iš Judo miestų, ");
INSERT INTO lit_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ir įėjo į Zacharijo namus ir pasveikino Elžbietą. ");
INSERT INTO lit_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ir taip įvyko, kad Elžbietai išgirdus Marijos pasveikinimą, jos įsčiose šoktelėjo kūdikis, ir Elžbieta tapo pripildyta Šventosios Dvasios ");
INSERT INTO lit_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ir ji garsiai sušuko ir tarė: „Palaiminta tu tarp moterų, ir palaimintas tavo įsčių vaisius! ");
INSERT INTO lit_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ir iš kur man tai, kad mano Viešpaties motina ateina pas mane?! ");
INSERT INTO lit_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nes štai vos tik tavo pasveikinimo balsas pasiekė mano ausis, šoktelėjo iš džiaugsmo kūdikis mano įsčiose. ");
INSERT INTO lit_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ir palaiminta ta, kuri tikėjo, kad įvyks tai, kas jai Viešpaties pasakyta.“ ");
INSERT INTO lit_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","O Marija prabilo: „Mano siela apskelbia Viešpaties didingumą, ");
INSERT INTO lit_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ir mano dvasia džiūgauja Dievu, mano Išgelbėtoju, ");
INSERT INTO lit_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","nes jis atsižvelgė į savo tarnaitės žemą luomą. Juk štai nuo dabar visos kartos vadins mane palaiminta, ");
INSERT INTO lit_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","nes didžių dalykų padarė man Galingasis, ir jo vardas yra šventas, ");
INSERT INTO lit_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ir jo gailestingumas trunka per kartų kartas tiems, kurie jo bijosi. ");
INSERT INTO lit_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Jis savo ranka parodė galybę; jis išsklaidė tuos, kurie didžiuojasi savo širdies protavimu; ");
INSERT INTO lit_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","jis numetė valdovus nuo sostų ir išaukštino žemuosius; ");
INSERT INTO lit_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","jis pripildė alkstančius gėrybėmis, o turtuolius paleido tuščiomis; ");
INSERT INTO lit_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","jis padėjo savo tarnui Izraeliui, prisimindamas gailestingumą, ");
INSERT INTO lit_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","kaip jis kalbėjo mūsų tėvams, Abraomui, ir jo palikuonims per amžius.“ ");
INSERT INTO lit_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ir Marija pasiliko pas ją apie tris mėnesius ir sugrįžo į savo namus. ");
INSERT INTO lit_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","O Elžbietai suėjo laikotarpis iki gimdymo, ir ji pagimdė sūnų. ");
INSERT INTO lit_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ir jos kaimynai bei giminės išgirdo, kad Viešpats didino jai parodytą savo gailestingumą, ir jie džiaugėsi kartu su ja. ");
INSERT INTO lit_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ir taip įvyko, kad aštuntąją dieną jie atėjo vaikelio apipjaustyti ir ketino jį pavadinti tėvo vardu, Zachariju. ");
INSERT INTO lit_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","O atsiliepdama jo motina tarė: „Ne! Priešingai, jis turi būti pavadintas Jonu.“ ");
INSERT INTO lit_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ir jie tarė jai: „Nėra nė vieno tavo giminėje, kuris vadinasi šiuo vardu.“ ");
INSERT INTO lit_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ir jie jo tėvui parodė gestų paklausdami, kaip jis norėtų jį pavadinti. ");
INSERT INTO lit_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ir paprašęs rašomosios lentelės jis užrašė štai ką: Jo vardas yra Jonas. Ir visi stebėjosi. ");
INSERT INTO lit_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ir tuoj pat jo burna atsivėrė ir jo liežuvis atsirišo, ir jis ėmė kalbėti laimindamas Dievą. ");
INSERT INTO lit_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ir visus jų kaimynus apėmė baimė, ir visame Judėjos kalnyne vis buvo kalbama apie visus šiuos dalykus. ");
INSERT INTO lit_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ir visi girdėjusieji dėjosi tuos dalykus į savo širdis, sakydami: „Kas gi bus iš to vaiko?!“ Ir Viešpaties ranka buvo su juo. ");
INSERT INTO lit_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ir jo tėvas Zacharijas tapo pripildytas Šventosios Dvasios ir pranašavo, sakydamas: ");
INSERT INTO lit_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","„Tebūna palaimintas Viešpats, Izraelio Dievas, kadangi pagalbon aplankė ir išpirko savo žmones ");
INSERT INTO lit_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ir iškėlė mums išgelbėjimo ragą savo tarno Dovydo namuose, ");
INSERT INTO lit_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","kaip jis nuo senų senovės kalbėjo savo šventųjų pranašų burna, ");
INSERT INTO lit_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","jog mus išgelbės nuo mūsų priešų ir iš rankos visų tų, kurie mūsų nekenčia, ");
INSERT INTO lit_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","kad parodytų gailestingumą mūsų tėvams, tai yra, kad atsimintų savo šventąją sandorą, ");
INSERT INTO lit_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","priesaiką, kurią jis davė mūsų tėvui Abraomui, ");
INSERT INTO lit_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","kad jis duos mums, išvaduotiems iš mūsų priešų rankos, be baimės jam tarnauti ");
INSERT INTO lit_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","šventume ir teisume jo akivaizdoje per visas mūsų gyvenimo dienas. ");
INSERT INTO lit_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","O tu, vaikeli, būsi vadinamas Aukščiausiojo pranašu, nes eisi pirma Viešpaties veido paruošti jo kelius, ");
INSERT INTO lit_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","duoti jo žmonėms pažinti išgelbėjimą jų nuodėmių atleidimu ");
INSERT INTO lit_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","per mūsų Dievo gailestingą giliaširdiškumą, dėl kurio mus aplankė Šviesos Brėškimas iš aukštybių, ");
INSERT INTO lit_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","kad apšviestų sėdinčius tamsoje ir mirties šešėlyje, kad nukreiptų mūsų kojas į ramybės kelią.“ ");
INSERT INTO lit_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ir vaikas vis augo, taip pat vis stiprėjo dvasia ir buvo dykumose iki pat savo atskleidimo Izraeliui dienos. ");
INSERT INTO lit_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ir įvyko tomis dienomis, kad išėjo ciesoriaus Augusto įsakas, kad visas pasaulis užsirašytų apmokestinimui. ");
INSERT INTO lit_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(Toks pirmasis surašymas apmokestinimui įvyko Siriją valdančiajam Kvirinui dalyvaujant.) ");
INSERT INTO lit_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ir visi ėjo užsirašyti, kiekvienas į savo miestą. ");
INSERT INTO lit_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ir Juozapas irgi ėjo iš Galilėjos, iš Nazareto miesto, aukštyn į Judėją, į Dovydo miestą, vadinamą Betliejumi, – nes jis buvo iš Dovydo namų ir giminės, – ");
INSERT INTO lit_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","užsirašyti kartu su žmona Marija, – jam pažadėta į žmonas, – kuri buvo stora dėl nėštumo. ");
INSERT INTO lit_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ir įvyko taip, kad jiems ten esant, nėštumo dienos pasibaigė, tad ji turėjo gimdyti. ");
INSERT INTO lit_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ir ji pagimdė savo pirmagimį sūnų ir suvystė jį vystyklais ir paguldė jį ėdžiose, nes jiems nebuvo vietos svečių patalpose. ");
INSERT INTO lit_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ir tame pačiam krašte buvo piemenų, kurie pasiliko lauke ir budėjo naktį prie savo kaimenės. ");
INSERT INTO lit_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ir štai prie jų atsirado Viešpaties angelas, ir aplink jų smarkiai nušvietė Viešpaties šlovė, tai jie labai išsigando. ");
INSERT INTO lit_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Bet angelas jiems tarė: „Nebijokite, nes štai skelbiu jums gerą žinią – didį džiaugsmą, kuris bus kiekvienai tautai, ");
INSERT INTO lit_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","kad šiandien Dovydo mieste jums gimė Išgelbėtojas, kuris yra Kristus, Viešpats. ");
INSERT INTO lit_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ir šitas bus jums ženklas: rasite kūdikį, suvystytą vystyklais, gulintį ėdžiose.“ ");
INSERT INTO lit_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ir staiga prie angelo atsirado gausi dangaus kareivija, girianti Dievą ir sakanti: ");
INSERT INTO lit_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","„Šlovė Dievui aukščiausiose aukštybėse, o ramybė žemėje, palankumas žmonėse!“ ");
INSERT INTO lit_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ir taip įvyko, kad angelams pasišalinus nuo jų į dangų, piemenys kalbėjo vienas kitam: „Būtinai pereikime į Betliejų ir pamatykime, kas įvyko, ką Viešpats mums pranešė!“ ");
INSERT INTO lit_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ir jie atskubėjo ir rado Mariją, Juozapą ir kūdikį, gulintį ėdžiose. ");
INSERT INTO lit_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ir tai pamatę jie plačiai apskelbė jiems kalbėtą pasakymą apie šį vaikelį. ");
INSERT INTO lit_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ir visi, kurie girdėjo, stebėjosi tais dalykais, kurie jiems buvo piemenų pasakyta. ");
INSERT INTO lit_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Bet Marija įsidėmėjo visus šiuos dalykus ir svarstė juos savo širdyje. ");
INSERT INTO lit_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ir piemenys grįžo šlovindami ir girdami Dievą už visa, ką buvo girdėję ir matę taip, kaip jiems buvo pasakyta. ");
INSERT INTO lit_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ir kai buvo suėjusios aštuonios dienos vaikui apipjaustyti, jis buvo pavadintas vardu Jėzus, kuriuo vardu angelas jį pavadino anksčiau nei jis buvo pradėtas įsčiose. ");
INSERT INTO lit_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ir kai buvo suėjusios jos apsivalymo pagal Mozės įstatymą dienos, jie nunešė jį į Jeruzalę, kad pristatytų jį Viešpačiui, – ");
INSERT INTO lit_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","kaip yra parašyta Viešpaties įstatyme: „Kiekvienas vyriškos lyties kūdikis, kuris pirmąkart atveria motinos įsčias, bus pašventintas Viešpačiui“ – ");
INSERT INTO lit_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","ir kad duotų auką pagal tai, kas pasakyta Viešpaties įstatyme: „Porą purplelių arba du jaunus balandžius“. ");
INSERT INTO lit_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ir štai Jeruzalėje buvo žmogus, vardu Simeonas. O tas žmogus buvo teisus ir dievobaimingas, laukiantis Izraelio paguodos, ir Šventoji Dvasia buvo ant jo. ");
INSERT INTO lit_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ir jam buvo Šventosios Dvasios apreikšta, kad jis nepatirsiąs mirties, kol pamatysiąs Viešpaties Kristų. ");
INSERT INTO lit_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ir jis dėl Dvasios įtakos atėjo į šventyklą. O tėvams įnešant vaikelį Jėzų, kad pasielgtų su juo pagal įstatymo įsigalėjusią tvarką, ");
INSERT INTO lit_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","jis ir paėmė jį į savo rankas ir palaimino Dievą ir tarė: ");
INSERT INTO lit_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","„O Valdove, tu dabar pagal savo žodį leidi savo tarnui iškeliauti ramybėje, ");
INSERT INTO lit_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","nes mano akys išvydo tavo išgelbėjimą, ");
INSERT INTO lit_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","kurį paruošei visų tautų akivaizdoje: ");
INSERT INTO lit_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Šviesą kitataučiams duoti apreiškimo ir tavosios Izraelio tautos šlovę.“ ");
INSERT INTO lit_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Tai Juozapas ir jo motina stebėjosi tuo, kas buvo apie jį kalbama. ");
INSERT INTO lit_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ir Simeonas juos palaimino ir tarė Marijai, jo motinai: „Štai, šis vaikas yra padėtas daugelio Izraelyje kritimui ir pakėlimui, taip pat ženklui, prieš kurį bus žodžiaujama, ");
INSERT INTO lit_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","(taip ir tavo pačios sielą pervers kalavijas) – kad būtų atskleistos daugelio širdžių mintys.“ ");
INSERT INTO lit_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Buvo ir pranašė Ona, Fanuelio duktė iš Asero genties. Ji buvo sulaukusi labai senyvo amžiaus, po savo mergystės išgyvenusi septynerius metus su vyru, ");
INSERT INTO lit_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ir našlavusi apie aštuoniasdešimt ketverius metus. Ji nesitraukdavo iš šventyklos tarnaudama Dievui pasninkais ir maldomis naktį ir dieną. ");
INSERT INTO lit_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ir ji, tuo pat metu priėjusi, dėkojo Viešpačiui ir ėmė kalbėti apie kūdikį visiems, kurie Jeruzalėje laukė išpirkimo. ");
INSERT INTO lit_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ir kai jie buvo atlikę visa pagal Viešpaties įstatymą, jie sugrįžo į Galilėją, į savo miestą Nazaretą. ");
INSERT INTO lit_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","O vaikas vis augo ir vis stiprėjo dvasia, pripildytas išminties, ir Dievo malonė buvo ant jo. ");
INSERT INTO lit_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ir jo tėvai kiekvienais metais per Aplenkimo šventę keliaudavo į Jeruzalę. ");
INSERT INTO lit_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ir kai jis buvo dvylikos metų, šventės papročiu jie nuvyko aukštyn į Jeruzalę. ");
INSERT INTO lit_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ir jis jiems tarė: „Kodėl manęs ieškojote? Ar nežinojote, kad man reikia užsiimti savo Tėvo reikalais?“ ");
INSERT INTO lit_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Bet jie nesuprato pasakymo, kurį jis jiems kalbėjo. ");
INSERT INTO lit_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ir jis ėjo su jais žemyn ir atėjo į Nazaretą, ir elgėsi pavaldžiai jiems; o jo motina visus šituos pasakymus laikė atidžiai savo širdyje. ");
INSERT INTO lit_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ir Jėzus vis augo išmintimi, ūgiu ir Dievo bei žmonių teigiamu požiūriu į jį. ");
INSERT INTO lit_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ir jis ėjo po visą Jordano apylinkę, skelbdamas krikštą, kurį sąlygoja atgaila – dėl nuodėmių atleidimo, ");
INSERT INTO lit_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ir visokie žmonės matys Dievo išgelbėjimą. ");
INSERT INTO lit_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Dėl to jis sakydavo minioms, kurios išėjo pas jį būti jo pakrikštytos: O angių išperos, kas jus perspėjo bėgti nuo ateinančios rūstybės? ");
INSERT INTO lit_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Duokite tad vaisių, pritinkančių atgailai, ir nepradėkite sakyti savyje: ‚Mes kaip tėvą turime Abraomą.‘ Nes aš jums sakau, kad Dievas pajėgia prikelti vaikų Abraomui iš šitų akmenų! ");
INSERT INTO lit_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Tada ir muitininkai atėjo, kad būtų pakrikštyti, ir jam tarė: „Mokytojau, ką mums daryti?“ ");
INSERT INTO lit_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ir jis jiems tarė: „Nereikalaukite daugiau, negu jums yra liepta.“ ");
INSERT INTO lit_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Taip pat ir kariai klausė jo, sakydami: „O ką mums daryti?“ Ir jis tarė jiems: „Iš nė vieno neišgaukite turto prievarta nė melagingu įskundimu ir tenkinkitės savo alga.“ ");
INSERT INTO lit_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Jonas atsiliepė visiems sakydamas: „Aš gi jus krikštiju vandeniu, bet ateina už mane galingesnis, kurio apavų dirželio aš nevertas atrišti. Jisai krikštys jus Šventąja Dvasia ir ugnimi. ");
INSERT INTO lit_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jis gi tokiu būdu skelbė evangeliją žmonėms ragindamas su įspėjimais dėl daug kitų dalykų. ");
INSERT INTO lit_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Bet Jėzus jam atsakė tardamas: „Yra parašyta, kad žmogus gyvens ne vien duona, bet kiekvienu Dievo žodžiu. ");
INSERT INTO lit_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ir velnias tarė jam: „Visą šitą valdžią (taip pat jų šlovę) aš tau duosiu, nes ji man yra atiduota, ir ją duodu kam tik noriu. ");
INSERT INTO lit_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Todėl jei tu pagarbinsi mane, visa tai bus tavo.“ ");
INSERT INTO lit_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Bet Jėzus atsakydamas jam tarė: „Eik šalin nuo manęs, Šėtone! Juk yra parašyta: ‚Garbink Viešpatį, savo Dievą, ir jam vienam tarnauk‘.“ ");
INSERT INTO lit_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ir jis nuvedė jį į Jeruzalę ir pastatė jį ant šventyklos viršūnės ir jam tarė: „Jeigu tu esi Dievo Sūnus, meskis nuo čia žemyn, ");
INSERT INTO lit_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","nes yra parašyta: ‚Jis savo angelams įsakys apie tave, kad saugotų tave‘ ");
INSERT INTO lit_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ir ‚Ant rankų jie nešios tave, kad niekada neužsigautum savo kojos į akmenį‘.“ ");
INSERT INTO lit_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","O Jėzus atsakydamas jam tarė: „Yra pasakyta: ‚Negundyk Viešpaties, savo Dievo‘.“ ");
INSERT INTO lit_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ir kai velnias baigė kiekvieną gundymą, jis atsitraukė nuo jo kurį laiką. ");
INSERT INTO lit_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ir Dvasios galybe Jėzus sugrįžo į Galilėją, ir garsas apie jį pasklido po visą aplinkui esantį kraštą. ");
INSERT INTO lit_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ir jis vis mokė jų sinagogose, visų šlovinamas. ");
INSERT INTO lit_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","„Viešpaties Dvasia yra ant manęs, nes jis patepė mane pranešti evangeliją vargšams; jis pasiuntė mane gydyti tuos, kurių širdys sudužusios, skelbti kaip šauklys belaisviams išvadavimą ir akliesiems regėjimo atstatymą, išsiųsti į laisvę palūžusiuosius, ");
INSERT INTO lit_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","skelbti Viešpaties malonės metus.“ ");
INSERT INTO lit_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ir jis pradėjo jiems kalbėti: „Šiandien, jums klausantis, šis Šventraštis išsipildė.“ ");
INSERT INTO lit_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ir visi gerai atsiliepė apie jį ir stebėjosi maloningais žodžiais, sklindančiais iš jo burnos. Ir jie tarė: „Argi jis ne Juozapo sūnus?!“ ");
INSERT INTO lit_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ir pranašo Eliziejaus laikais buvo daug raupsuotųjų Izraelyje, bet nė vienas jų nebuvo apvalytas, tik siras Naamanas.“ ");
INSERT INTO lit_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Bet jis praėjo tarp jų ir pasišalino, ");
INSERT INTO lit_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","ir nusileido į Galilėjos miestą Kapernaumą, ir šabo dienomis juos mokė. ");
INSERT INTO lit_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ir jie stebėjosi jo mokslu, nes jo žodis buvo su valdžia. ");
INSERT INTO lit_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ir sinagogoje buvo žmogus, kuris turėjo vieno netyro velnio dvasią ir šaukė garsiu balsu, ");
INSERT INTO lit_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","sakydamas: „Netrukdyk! Kas mums ir tau bendro, Jėzau Nazarėnai? Ar atėjai mūsų pražudyti? Pažįstu tave, kas esi – Dievo Šventasis.“ ");
INSERT INTO lit_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","O Jėzus jį sudraudė, sakydamas: „Nutilk ir išeik iš jo!“ Ir nubloškęs jį į vidurį, velnias išėjo iš jo ir jo nesužeidė. ");
INSERT INTO lit_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ir jie visi stebėjosi ir kalbėjo vienas kitam, sakydami: „Kas tai per žodis! Nes su valdžia ir galia jis įsakinėja netyroms dvasioms, ir jos išeina.“ ");
INSERT INTO lit_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ir garsas apie jį sklido į visas tos apylinkės vietas. ");
INSERT INTO lit_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ir pakilęs iš sinagogos jis įėjo į Simono namus. Ir Simono žmonos motina sirgo sunkia karštlige; ir jie maldavo jį už ją. ");
INSERT INTO lit_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ir stovėdamas jai iš viršaus jis sudraudė karštligę, ir ta pasitraukė nuo jos. Ir tuojau ji atsikėlė ir jiems patarnavo. ");
INSERT INTO lit_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Taip pat gi iš daugelio išėjo velniai, šaukdami ir sakydami: „Tu esi Kristus, Dievo Sūnus!“ Bet jis sudrausdamas neleido jiems kalbėti, nes jie žinojo jį esant Kristų. ");
INSERT INTO lit_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ir raštininkai bei fariziejai pradėjo svarstyti, sakydami: „Kas yra šitas, kuris kalba piktžodžiavimus? Kas gali atleisti nuodėmes, jei ne vienas Dievas?“ ");
INSERT INTO lit_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Bet kad žinotumėte, jog Žmogaus Sūnus turi žemėje valdymo galią nuodėmėms atleisti – jis tarė sergančiam paralyžiumi – sakau tau, kelkis, ir pasiėmęs savo gultuką, eik į savo namus.“ ");
INSERT INTO lit_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Esu atėjęs ne teisiųjų šaukti į atgailą, bet nusidėjėlių. ");
INSERT INTO lit_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ir jis tarė jiems, kad „Žmogaus Sūnus yra ir šabo Viešpats.“ ");
INSERT INTO lit_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Palaiminti esate, kai žmonės jūsų nekęs ir kai jie atskirs jus, ir niekins, ir atmes kaip blogą jūsų vardą dėl Žmogaus Sūnaus. ");
INSERT INTO lit_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Džiaukitės tą dieną ir šokinėkite iš džiaugsmo, nes štai jūsų atlygis danguje yra didelis, nes lygiai taip ir jų tėvai darė pranašams. ");
INSERT INTO lit_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ir kaip norite, kad žmonės darytų jums, taip ir jūs darykite jiems. ");
INSERT INTO lit_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Verčiau mylėkite savo priešus ir darykite gera, ir skolinkite nieko nesitikėdami atgausią; tuomet jūsų atlygis bus didelis, ir būsite Aukščiausiojo vaikai, nes jis yra maloningas nedėkingiems ir blogiems. ");
INSERT INTO lit_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ir kai jis pabaigė visus savo pasakymus besiklausiusiems žmonėms, jis įėjo į Kapernaumą. ");
INSERT INTO lit_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ir vienas šimtininko tarnas, kuris jam buvo brangus, sirgo ir buvo arti mirties. ");
INSERT INTO lit_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ir išgirdęs apie Jėzų, jis pasiuntė pas jį žydų vyresniuosius, maldaudamas jo, kad jis ateitų ir išgydytų jo tarną. ");
INSERT INTO lit_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ir atėję pas Jėzų jie primygtinai jo prašinėjo, sakydami, kad vertas yra tas, kuriam tai padarys, ");
INSERT INTO lit_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","nes jis myli mūsų tautą ir pats pastatė mums sinagogą. ");
INSERT INTO lit_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Tai Jėzus ėjo su jais. O jam jau esant nebetoli nuo namų, šimtininkas pasiuntė pas jį draugus, sakydamas jam: „Viešpatie, nesivargink, nes nesu vertas, kad užeitum po mano stogu. ");
INSERT INTO lit_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Todėl net nelaikiau savęs vertu ateiti pas tave. Bet pasakyk žodžiu, ir mano tarnas pasveiks. ");
INSERT INTO lit_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nes ir aš esu žmogus, skirtas būti pavaldinys, turintis sau pavaldžių kareivių, ir sakau vienam: „Eik! – ir jis eina, ir kitam: „Ateik! – ir jis ateina, ir savo tarnui: „Padaryk tai! – ir jis daro. ");
INSERT INTO lit_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Tuos dalykus išgirdęs, Jėzus stebėjosi juo ir, atsigręžęs į minią, kuri sekė paskui jį, tarė: „Sakau jums – nė Izraelyje neradau tokio didelio tikėjimo. ");
INSERT INTO lit_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","O sugrįžę į namus, pasiustieji rado tarną, kuris buvo susirgęs, sveiką. ");
INSERT INTO lit_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ir paskesnę dieną įvyko, kad jis įėjo į miestą, vadinamą Nainu; o kartu su juo keliavo daugelis jo mokytinių ir gausi minia. ");
INSERT INTO lit_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","O kai jis prisiartino prie miesto vartų, štai buvo išnešamas numirėlis, – vienintelis savo motinos sūnus, o ji buvo našlė. Ir didoka miesto minia buvo su ja. ");
INSERT INTO lit_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ir kai Viešpats ją pamatė, jį apėmė gailestis dėl jos ir jis jai tarė: „Neverk. ");
INSERT INTO lit_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ir priėjęs jis palietė karsto laidojimo neštuvus ir nešėjai sustojo; ir jis tarė: „Jaunuoli, sakau tau: kelkis!“ ");
INSERT INTO lit_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ir numirėlis atsisėdo ir pradėjo kalbėti, ir Jėzus atidavė jį jo motinai. ");
INSERT INTO lit_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ir visus apėmė baimė, ir jie šlovino Dievą, sakydami: „Didis pranašas iškilo tarp mūsų!“ ir: „Dievas pagalbon aplankė savo tautą!“ ");
INSERT INTO lit_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ir ši žinia apie jį pasklido po visą Judėją ir po visą apylinkę. ");
INSERT INTO lit_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ir yra palaimintas kas tik nepasipiktins manimi. ");
INSERT INTO lit_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Jis yra tasai, apie kurį yra parašyta: Štai aš siunčiu pirma tavo veido savo pasiuntinį, kuris paruoš tau kelią pirma tavęs. ");
INSERT INTO lit_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ir jį išgirdusi visa liaudis, taip pat muitininkai, išteisino Dievą, pasikrikštydami Jono krikštu. ");
INSERT INTO lit_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Bet visi jos vaikai išmintį išteisina. ");
INSERT INTO lit_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Bet jiems neturint iš ko atmokėti, jis nuoširdžiai abiem atleido. Taigi pasakyk man, kuris iš jų labiau jį mylės?“ ");
INSERT INTO lit_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Todėl aš tau sakau: jos nuodėmės, kurių yra daug, yra atleistos; dėl to ji labai mylėjo. O kam yra atleista mažai, tas myli mažai. ");
INSERT INTO lit_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ir atsilošusieji kartu prie stalo pradėjo tarpusavyje kalbėti: „Kas yra šis, kuris net nuodėmes atleidžia?“ ");
INSERT INTO lit_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","„Išėjo sėjėjas savo sėklos sėti, ir jam besėjant, dalis nukrito palei kelią ir ji buvo sumindžiota, ir padangių paukščiai ją sulesė. ");
INSERT INTO lit_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ir kita dalis nukrito ant uolos ir vos tik išdygusi ji sudžiuvo, nes jai trūko drėgmės. ");
INSERT INTO lit_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ir kita dalis nukrito tarp erškėčių, ir kartu su ja išdygę erškėčiai nusmelkė ją. ");
INSERT INTO lit_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","O kita dalis nukrito ant geros žemės ir išdygo, ir davė šimteriopą vaisių.“ Tai sakydamas, jis sušuko: „Kas turi ausis klausyti – teklauso!“ ");
INSERT INTO lit_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ir jo mokytiniai klausė jį, sakydami: „Ką reiškia šis palyginimas?“ ");
INSERT INTO lit_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ir jis tarė: „Jums yra duota pažinti Dievo karalystės slėpinius, bet visiems kitiems – palyginimais, kad MATYDAMI NEMATYTŲ IR GIRDĖDAMI NESUPRASTŲ. ");
INSERT INTO lit_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","O palyginimas reiškia štai ką: sėkla yra Dievo žodis. ");
INSERT INTO lit_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","O tie palei kelią yra tie, kurie girdi, paskui ateina velnias ir atima žodį iš jų širdies, kad jie netikėtų ir nebūtų išgelbėti. ");
INSERT INTO lit_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","O tie ant uolos yra tie, kurie, kai išgirsta, priima žodį su džiaugsmu, bet šitie neturi šaknies; jie tiki kurį laiką, bet išmėginimo metu atkrinta. ");
INSERT INTO lit_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","O kas krito tarp erškėčių, yra tie, kurie išgirdę, beeidami yra nusmelkiami gyvenimo rūpesčių, turtų ir malonumų ir nesubrandina vaisiaus. ");
INSERT INTO lit_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","O tai geroje žemėje – tai yra tie, kurie išgirdę žodį, laikosi jo taurioje bei geroje širdyje ir ištverdami neša vaisių. ");
INSERT INTO lit_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ir jis tarė jiems: „Kur yra jūsų tikėjimas?“ Ir jie išsigandę stebėjosi, sakydami vienas kitam: „Kas gi yra šitas, kad jis įsakinėja net vėjams ir vandeniui, ir tie jo klauso?“ ");
INSERT INTO lit_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Pamatęs Jėzų, jis šaukė, parpuolė prieš jį ir garsiai tarė: „Kas man ir tau bendro, Jėzau, Aukščiausiojo Dievo Sūnau? Meldžiu tave, nekankink manęs!“ ");
INSERT INTO lit_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ir moteris, dvylika metų serganti kraujoplūdžiu, kuri buvo išleidusi gydytojams visą savo pragyvenimo turtą ir kurios niekas neįstengė išgydyti, ");
INSERT INTO lit_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","priėjusi iš užnugario palietė jo drabužio kutą, ir tuojau sustojo jos kraujoplūdis. ");
INSERT INTO lit_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ir Jėzus tarė: „Kas tas, kuris mane palietė?“ Visiems išsiginant Petras ir su juo esantys tarė: „Vadove, minia tave spaudžia ir grūda, o tu sakai: ‚Kas tas, kuris mane palietė?‘“ ");
INSERT INTO lit_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ir Jėzus tarė: „Kas nors mane palietė, nes aš supratau, kad iš manęs yra išėjusi galia.“ ");
INSERT INTO lit_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ir moteris, pamačiusi, kad neliko nepastebėta, drebėdama priėjo ir parpuolusi prieš jį pasisakė jam visų žmonių akivaizdoje, dėl kokios priežasties ji buvo jį palietusi ir kaip tuojau buvo išgydyta. ");
INSERT INTO lit_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ir jis tarė jai: „Drąsos, dukterie! Tavo tikėjimas tave išgydė, eik ramybėje.“ ");
INSERT INTO lit_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Taigi tetrarchas Erodas išgirdo apie visus jo daromus dalykus ir sumišo, nes buvo kai kurių pasakyta, kad Jonas yra prikeltas iš numirusių, ");
INSERT INTO lit_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ir jis pasakė visiems: „Jei kas nori eiti paskui mane, tas privalo išsižadėti savęs, privalo pasiimti kasdien savo kryžių ir privalo sekti paskui mane. ");
INSERT INTO lit_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Nes bet kas, kuris ketina išgelbėti savo gyvybę, tas ją pražudys, o bet kas, kuris pražudys savo gyvybę dėl manęs, tas ją išgelbės. ");
INSERT INTO lit_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ir štai du vyrai kalbėjosi su juo. Jie buvo Mozė ir Elijas, ");
INSERT INTO lit_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","kurie pasirodė šlovėje ir kalbėjo apie jo iškeliavimą, kurį jis netrukus įvykdys Jeruzalėje. ");
INSERT INTO lit_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ir įvyko, kad paskesnę dieną, jiems nusileidus nuo kalno, jį pasitiko didelė minia. ");
INSERT INTO lit_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ir štai vienas žmogus šaukė iš minios, sakydamas: „Mokytojau, meldžiu tave, pažvelk į mano sūnų, nes jis yra mano vienintelis vaikas. ");
INSERT INTO lit_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ir štai dvasia pačiumpa jį, ir jis staiga sušunka. Ir ji tąso jį, kad jis putoja, ir vargais negalais nuo jo atstoja jį sumušdama. ");
INSERT INTO lit_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ir meldžiau tavo mokytinių ją išvaryti, bet jie nepajėgė.“ ");
INSERT INTO lit_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ir Jėzus atsakydamas tarė: „O netikinti ir iškrypusi karta! Iki kol aš būsiu su jumis ir jus kęsiu? Atvesk čia savo sūnų. ");
INSERT INTO lit_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ir jam dar beprieinant, velnias parmetė jį žemyn ir didžiai tąsė. Bet Jėzus sudraudė netyrąją dvasią, ir išgydė vaiką ir jį atidavė jo tėvui. ");
INSERT INTO lit_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ir visi labai stebėjosi galinga Dievo jėga. Bet jiems visiems besistebint visu tuo, ką Jėzus padarė, jis tarė savo mokytiniams: ");
INSERT INTO lit_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Bet jis atsisukęs, sudraudė juos ir tarė: „Nežinote, kokios jūs esate dvasios, ");
INSERT INTO lit_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Nes žmogaus Sūnus atėjo ne žmonių gyvybių pražudyti, bet išgelbėti“. Ir jie nukeliavo į kitą kaimą. ");
INSERT INTO lit_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jėzus jam tarė: „Palik mirusiems laidoti savo mirusius, bet tu eik ir skelbk Dievo karalystę.“ ");
INSERT INTO lit_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ir kitas tarė: „Viešpatie, aš seksiu paskui tave, bet leisk man pirmiau atsisveikinti su savo namiškiais.“ ");
INSERT INTO lit_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","O Jėzus jam tarė: „Nė vienas, uždėjęs ant plūgo ranką ir besižvalgąs atgal, netinka Dievo karalystei.“ ");
INSERT INTO lit_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Po šių dalykų Viešpats paskyrė dar kitus septyniasdešimt ir išsiuntė juos po du, kad eitų pirma jo į kiekvieną miestą ir vietą, kur jis pats ketino eiti. ");
INSERT INTO lit_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Todėl jis tarė jiems: „Pjūtis iš tiesų didelė, bet darbininkų maža; todėl melskite pjūties Viešpatį, kad jis išsiųstų darbininkų į savo pjūtį. ");
INSERT INTO lit_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Bet jums sakau, kad tą dieną Sodomai bus pakenčiamiau negu tam miestui. ");
INSERT INTO lit_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ir septyniasdešimt su džiaugsmu sugrįžo, sakydami: „Viešpatie, kai jiems įsakome tavo vardu, mums elgiasi pavaldžiai net velniai!“ ");
INSERT INTO lit_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Tačiau nesidžiaukite tuo, kad dvasios elgiasi pavaldžiai jums. Bet verčiau džiaukitės, kad jūsų vardai yra įrašyti danguje.“ ");
INSERT INTO lit_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","O jis atsakydamas tarė: „Mylėk Viešpatį, savo Dievą, visa savo širdimi ir visa savo siela, ir visomis savo jėgomis, ir visu savo protu, o savo artimą kaip save patį.“ ");
INSERT INTO lit_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Bet jis, norėdamas save išteisinti, tarė Jėzui: „O kas yra mano artimas?“ ");
INSERT INTO lit_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Tačiau Jėzus atsakydamas jai tarė: „Morta, Morta, tu rūpiniesi ir nerimauji dėl daugelio dalykų, ");
INSERT INTO lit_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","bet tereikia vieno dalyko, ir Marija išsirinko tą gerą dalį, kuri nebus iš jos atimta.“ ");
INSERT INTO lit_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Tad aš jums sakau: prašykite, ir bus jums duota; ieškokite, ir rasite; belskite, ir bus jums atidaryta. ");
INSERT INTO lit_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Nes kiekvienas, kas prašo, gauna, kas ieško, randa, ir tam, kuris beldžiasi, bus atidaryta. ");
INSERT INTO lit_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Kol stipruolis, gerai apsiginklavęs, saugo savo rūmus, jo turtas yra saugus. ");
INSERT INTO lit_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Kas ne su manimi, tas yra prieš mane, ir kas nesurenka su manimi, tas išsklaido. ");
INSERT INTO lit_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ir taip įvyko, kad jam besakant tuos dalykus, viena moteris iš minios pakėlė balsą ir tarė jam: „Palaimintos įsčios, kurios tave nešiojo, ir krūtys, kurias žindei.“ ");
INSERT INTO lit_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Bet jis tarė: „Tikriau šitaip: palaiminti yra tie, kurie klausosi Dievo žodžio ir jo laikosi!“ ");
INSERT INTO lit_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ninevės žmonės kelsis drauge su šia karta teisme ir ją pasmerks, nes jie atgailavo dėl Jonos šaukliško skelbimo, o štai čia už Joną yra kas didesnis! ");
INSERT INTO lit_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Bet vargas jums, fariziejai! Nes jūs duodate dešimtinę iš mėtų, rūtų ir visokių žolelių, bet teisingumą ir Dievo meilę apeinate! Šituos reikėjo jums vykdyti ir anų neapleisti! ");
INSERT INTO lit_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Vargas jums! Nes jūs statote pranašų kapus, o jūsų tėvai juos nužudė. ");
INSERT INTO lit_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Iš tiesų jūs liudijate, kad visiškai pritariate savo tėvų darbams, nes jie tikrai juos nužudė, o jūs – jūs statote jų kapus! ");
INSERT INTO lit_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Todėl ir Dievo Išmintis pasakė: ‚Aš siųsiu pas juos pranašų bei apaštalų, ir vienus iš jų jie nužudys ir persekios iš vietos, ");
INSERT INTO lit_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","kad iš šios kartos būtų pareikalauta visų pranašų kraujo, pralieto nuo pasaulio įkūrimo, ");
INSERT INTO lit_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","pradedant Abelio krauju iki kraujo Zacharijo, žuvusio tarp aukuro ir šventyklos. Taip! Jums sakau: jis bus išreikalautas iš šitos kartos!‘ ");
INSERT INTO lit_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Argi ne penki žvirbliai parduodami už du skatikus? Tačiau nė vienas jų nėra pamirštas Dievo akivaizdoje. ");
INSERT INTO lit_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Bet netgi visi jūsų galvos plaukai suskaičiuoti! Tad nebijokite: jūs esate vertesni už daugybę žvirblių! ");
INSERT INTO lit_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ir jis jiems tarė: „Žiūrėkite ir saugokitės gobšumo, nes žmogaus gyvybė nesusideda iš gausybės jo turimų daiktų.“ ");
INSERT INTO lit_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ir jis pasakė jiems palyginimą, sakydamas: „Vieno turtingo žmogaus dirva užderėjo gausiai. ");
INSERT INTO lit_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ir jis sau vienas svarstinėjo, sakydamas: ‚Ką man daryti, nes neturiu kur sukrauti savo derliaus?‘ ");
INSERT INTO lit_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ir jis tarė: ‚Štai ką padarysiu: nugriausiu savo klėtis ir pastatysiu didesnes ir į jas sudėsiu visus savo javus ir savo gėrybes. ");
INSERT INTO lit_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Tada tarsiu savo sielai: siela, tu turi daug gėrybių, sukrautų daugeliui metų; ilsėkis, valgyk, gerk, linksminkis!‘ ");
INSERT INTO lit_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Bet Dievas jam tarė: ‚Kvaily, šią naktį iš tavęs bus pareikalauta tavo sielos; o kam atiteks daiktai, kuriuos priruošei?‘ ");
INSERT INTO lit_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Taip yra tam, kuris krauna sau lobį, bet nėra turtingas pas Dievą.“ ");
INSERT INTO lit_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Nebijok, mažoji kaimene, nes jūsų Tėvas džiaugiasi duodamas jums karalystę. ");
INSERT INTO lit_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","nes kur yra jūsų lobis, ten bus ir jūsų širdis. ");
INSERT INTO lit_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Palaiminti tie tarnai, kuriuos parėjęs viešpats ras budinčius. Iš tiesų sakau jums, kad jis susijuos ir susodins juos prie stalo, ir prieidamas patarnaus jiems. ");
INSERT INTO lit_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ar manote, kad atėjau ramybės duoti žemėje? Ne, jums sakau, bet veikiau nesantaikos! ");
INSERT INTO lit_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ir kodėl jūs patys neteisėjaujate, kas yra teisu? ");
INSERT INTO lit_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Aš sakau jums: Ne! Bet jeigu neatgailausite, jūs visi panašiu būdu pražūsite. ");
INSERT INTO lit_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Aš sakau jums: Ne! Bet jeigu neatgailausite, jūs visi panašiu būdu pražūsite. ");
INSERT INTO lit_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ir jeigu jis tikrai duos vaisių, gerai; o jeigu ne, po to jį iškirsi.“ ");
INSERT INTO lit_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ir jis per šabą mokė vienoje iš sinagogų. ");
INSERT INTO lit_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ir štai buvo ten moteris, aštuoniolika metų turinti ligos dvasią. Ji ir buvo susitraukusi, ir visiškai negalėjo išsitiesti. ");
INSERT INTO lit_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","O ja pamatęs Jėzus pasišaukė ją ir jai tarė: „Moterie, esi išvaduota iš savo ligos!“ ");
INSERT INTO lit_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ir jis uždėjo ant jos rankas o ji tuoj pat buvo padaryta tiesi ir ėmė šlovinti Dievą. ");
INSERT INTO lit_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Bet reaguodamas sinagogos vadovas, supykęs, kad Jėzus gydė šabo dieną, pasakė miniai: „Yra šešios dienos, per kurias reikia dirbti. Tad jomis ateikite ir gydykitės, o ne per šabą!“ ");
INSERT INTO lit_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Tada Viešpats atsakydamas jam tarė: „Veidmainy, argi kiekvienas iš jūsų šabo dieną neatriša savo jaučio ar asilo nuo ėdžių ir nenuveda pagirdyti? ");
INSERT INTO lit_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ir argi šios moters, kuri yra Abraomo duktė, kurią Šėtonas laikė sukaustęs štai šiuos aštuoniolika metų, nereikėjo išvaduoti iš šitų pančių šabo dieną?“ ");
INSERT INTO lit_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ir jam tai kalbant, visi jo priešininkai susigėdo, o visa minia džiaugėsi visais jo daromais šlovingais darbais. ");
INSERT INTO lit_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ir šabo dieną jam įėjus į vieno fariziejų valdytojų namus valgyti duonos, taip įvyko, kad jie kruopščiai stebėjo jį. ");
INSERT INTO lit_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ir štai ten priešais jį buvo vienas žmogus, sergantis vandenlige. ");
INSERT INTO lit_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ir Jėzus atsakydamas kalbėjo įstatymininkams ir fariziejams, sakydamas: „Ar teisėta gydyti šabo dieną?“ ");
INSERT INTO lit_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Bet jie tylėjo. Tada jis ėmė, išgydė jį ir paleido. ");
INSERT INTO lit_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ir atsakydamas jiems jis tarė: „Kuris iš jūsų turės asilą arba jautį, įkritusį į duobę, ir tuojau jo neištrauks per šabo dieną?“ ");
INSERT INTO lit_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ir jie nesugebėjo jam į tai atkirsti. ");
INSERT INTO lit_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ir jis pakviestiesiems pasakė palyginimą, atkreipdamas dėmesį į tai, kaip jie rinkosi garbingiausias vietas, sakydamas jiems: ");
INSERT INTO lit_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","„Kai esi kieno nors pakviestas į vestuves, nesisėsk garbingiausioje vietoje, kad kartais nebūtų jo pakviestas už tave labiau pripažinamas žmogus ");
INSERT INTO lit_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","O fariziejai ir raštininkai murmėjo, sakydami: „Šitas priima nusidėjėlius ir su jais valgo.“ ");
INSERT INTO lit_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Sakau jums, kad taip ir danguje bus daugiau džiaugsmo dėl vieno atgailaujančio nusidėjėlio negu dėl devyniasdešimt devynių teisiųjų, kuriems nereikia atgailos. ");
INSERT INTO lit_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Tada jis tarė: „Vienas žmogus turėjo du sūnus, ");
INSERT INTO lit_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","o jausnesnysis iš jų tarė tėvui: ‚Tėve, duok man atitenkančią turto dalį.‘ Tad jis padalijo jiems savo pragyvenimo turtą. ");
INSERT INTO lit_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ir po nedaugelio dienų, viską susirinkęs, jaunesnysis sūnus iškeliavo į tolimą šalį ir ten, palaidai gyvendamas išeikvojo savo turtą. ");
INSERT INTO lit_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ir kai jis viską išleido, toje šalyje kilo smarkus badas, ir jis pradėjo stokoti. ");
INSERT INTO lit_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ir nuėjęs jis prisijungė prie vieno tos šalies piliečio, ir tas jį pasiuntė į savo laukus kiaulių ganyti. ");
INSERT INTO lit_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ir jis geisdavo prikimšti savo pilvą ankščių, kurias ėsdavo kiaulės, bet niekas jam neduodavo. ");
INSERT INTO lit_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Bet susiprotėjęs jis tarė: ‚Kiek mano tėvo samdinių turi apsčiai duonos, o aš mirštu iš bado! ");
INSERT INTO lit_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Kelsiuosi, eisiu pas savo tėvą ir jam sakysiu: Tėve, aš nusidėjau prieš dangų ir tavo akivaizdoje ");
INSERT INTO lit_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ir nebesu vertas vadintis tavo sūnumi; padaryk mane vienu savo samdinių.‘ ");
INSERT INTO lit_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ir pakilęs jis ėjo pas savo tėvą. O jam dar toli esant, jo tėvas jį pamatė ir jį apėmė gailestis, tai nubėgo, ir puolė jam ant kaklo, ir jį pabučiavo. ");
INSERT INTO lit_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","O sūnus jam tarė: ‚Tėve, aš nusidėjau prieš dangų ir tavo akivaizdoje ir nebesu vertas vadintis tavo sūnumi.‘ ");
INSERT INTO lit_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Bet tėvas tarė savo tarnams: ‚Išneškite geriausią drabužį ir apvilkite jį, ir užmaukite jam žiedą ant rankos ir apavą ant kojų, ");
INSERT INTO lit_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","ir atveskite čia nupenėtą veršį ir papjaukite. Tai valgykime ir linksminkimės, ");
INSERT INTO lit_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","nes šitas mano sūnus buvo miręs, bet vėl atgijo, ir buvo pražuvęs, bet yra surastas.‘ Ir jie pradėjo linksmintis. ");
INSERT INTO lit_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","O jo vyresnysis sūnus buvo laukuose, ir kai pareidamas priartėjo prie namų, jis išgirdo muziką ir šokius. ");
INSERT INTO lit_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ir pasišaukęs, kad priartėtų vieną iš tarnų, jis teiravosi, kas čia dedasi. ");
INSERT INTO lit_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ir tas jam tarė: ‚Tavo brolis parėjo, ir tavo tėvas papjovė nupenėtą veršį, kadangi atgavo jį sveiką.‘ ");
INSERT INTO lit_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ir jis supyko ir nesutiko įeiti; todėl jo tėvas išėjo ir ne kartą maldavo jį. ");
INSERT INTO lit_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","O jis atsakydamas tarė tėvui: „Štai šiuos daugelį metų tau tarnauju ir niekada tavo įsakymo neperžengiau, tačiau tu man niekada nedavei nė ožiuko, kad galėčiau pasilinksminti su savo draugais. ");
INSERT INTO lit_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Bet kai parėjo šitas tavo sūnus, prarijęs tavąjį pragyvenimo turtą su paleistuvėmis, tu jam papjovei nupenėtą veršį.“ ");
INSERT INTO lit_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","O jis jam tarė: ‚Vaikeli, tu visuomet esi su manimi, ir visa, kas yra mano, yra tavo. ");
INSERT INTO lit_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Bet derėjo linksmintis ir džiaugtis, nes šitas tavo brolis buvo miręs, bet vėl atgijo, buvo pražuvęs, bet buvo surastas.‘“ ");
INSERT INTO lit_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ir valdovas pagyrė neteisųjį prievaizdį, kadangi jis išmintingai pasielgė. Juk šio pasaulio vaikai savo kartoje yra išmintingesni negu šviesos vaikai. ");
INSERT INTO lit_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ir aš jums sakau: darykite sau draugų neteisios mamonos pagalba; kad kai jūs išsibaigsite žemėje, jie priimtų jus į amžinąsias padangtes. ");
INSERT INTO lit_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Kas ištikimas mažiausiame dalyke, tas yra ištikimas ir dideliame, o kas neteisus mažiausiame dalyke, tas yra neteisus ir dideliame. ");
INSERT INTO lit_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Taigi, jeigu nebuvote ištikimi neteisios mamonos atžvilgiu, kas jums patikės tikruosius turtus? ");
INSERT INTO lit_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Jokiam tarnui neįmanoma tarnauti dviem šeimininkams, nes jis arba vieno nekęs, o kitą mylės, arba vieno tvirtai laikysis, o kitą nieku vers. Jums neįmanoma tarnauti Dievui ir mamonai. ");
INSERT INTO lit_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ir jis jiems tarė: „Jūs esate tie, kurie patys išteisina save žmonių akyse, bet Dievas pažįsta jūsų širdis, nes tai, kas tarp žmonių aukštai vertinama, Dievo akyse yra bjaurybė. ");
INSERT INTO lit_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","O buvo tam tikras turtingas žmogus, kuris vilkėdavo purpuru bei plona drobe ir kasdien linksmindavosi ištaigingai; ");
INSERT INTO lit_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","taip pat buvo tam tikras elgeta, vardu Lozorius, kuris gulėjo prie jo vartų, aptekęs votimis ");
INSERT INTO lit_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ir geisdamas pasisotinti iš trupinių, kurie krisdavo nuo turtuolio stalo; tačiau netgi šunys atėję laižydavo jo žaizdas. ");
INSERT INTO lit_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ir įvyko, kad elgeta mirė ir buvo angelų nuneštas į Abraomo užantį; mirė ir turtuolis ir buvo palaidotas. ");
INSERT INTO lit_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ir pragare, pakėlęs savo akis, kęsdamas kančias, jis iš tolo pamato Abraomą ir jo užantyje Lozorių. ");
INSERT INTO lit_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ir šaukdamas jis tarė: ‚Tėve Abraomai, pasigailėk manęs ir pasiųsk Lozorių, kad jis pamirkytų savo piršto galą į vandenį ir atvėsintų mano liežuvį, nes baisiai kenčiu šioje liepsnoje.‘ ");
INSERT INTO lit_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Bet Abraomas tarė: ‚Atsimink, sūnau, kad tu per savo gyvenimą atsiėmei savo gėrybes ir Lozorius tokiu pat būdu atsiėmė blogybes. O dabar šis yra guodžiamas, bet tu baisiai kenti. ");
INSERT INTO lit_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ir be visų šitų dalykų, tarp mūsų ir jūsų yra įtvirtinta didžiulė praraja tam, kad tie, kurie nori iš čia pereiti pas jus, negali, ir anie iš ten negali ateiti pas mus.‘ ");
INSERT INTO lit_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Tada jis tarė: ‚Tai meldžiu tave, tėve, nusiųsk jį į mano tėvo namus, ");
INSERT INTO lit_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","– nes turiu penkis brolius, – kad jis jiems paliudytų, jog ir jie nepatektų į šią kančios vietą.‘ ");
INSERT INTO lit_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraomas jam sako: ‚Jie turi Mozę ir pranašus, jie privalo jų klausyti.‘ ");
INSERT INTO lit_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","O anas tarė: ‚Ne, tėve Abraomai! Bet jei kas iš numirusiųjų nueitų pas juos, jie atgailautų.‘ ");
INSERT INTO lit_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ir jis jam tarė: ‚Jeigu jie neklauso Mozės ir pranašų, tai nors kas ir iš numirusiųjų prisikeltų, jie nesileis įtikinami.‘“ ");
INSERT INTO lit_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Saugokitės: jeigu tavo brolis tau nusideda, sudrausk jį, ir jeigu jis atgailauja, atleisk jam. ");
INSERT INTO lit_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ir jeigu jis tau nusideda septynis kartus per dieną ir septynis kartus per dieną atsigręžia į tave, sakydamas: ‚Aš atgailauju‘, tu jam atleisk. ");
INSERT INTO lit_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ir įvyko, kad jam einant į Jeruzalę, jis perėjo per Samarijos ir Galilėjos vidurį. ");
INSERT INTO lit_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ir jam įeinant į tam tikrą kaimą, jį pasitiko dešimt raupsuotų vyrų, kurie stovėjo atokiai. ");
INSERT INTO lit_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ir jie pakėlė balsus sakydami: „Jėzau, Vadove, pasigailėk mūsų!“ ");
INSERT INTO lit_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ir juos pamatęs, jis jiems tarė: „Eikite ir pasirodykite kunigams.“ Ir įvyko, kad beeidami jie buvo apvalyti. ");
INSERT INTO lit_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ir vienas iš jų, pamatęs, kad buvo išgydytas, sugrįžo šlovindamas Dievą garsiu balsu ");
INSERT INTO lit_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ir jam dėkodamas parpuolė veidu žemyn prie jo kojų – o jis buvo samarietis. ");
INSERT INTO lit_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ir Jėzus atsakydamas tarė: „Argi ne dešimt buvo apvalyta? O kur devyni? ");
INSERT INTO lit_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Neatsirado jokių kitų, sugrįžusių atiduoti Dievui šlovę, kaip tik šitas svetimšalis!“ ");
INSERT INTO lit_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ir jis tarė jam: „Kelkis ir eik! Tavo tikėjimas išgydė tave.“ ");
INSERT INTO lit_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Atsiminkite Loto žmoną! ");
INSERT INTO lit_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Bet kas, kuris ketina išgelbėti savo gyvybę, tas ją pražudys, o bet kas, kuris pražudys savo gyvybę, tas ją išlaikys. ");
INSERT INTO lit_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ir jis pasakė jiems palyginimą apie būtinumą visada melstis ir nepailsti, ");
INSERT INTO lit_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","sakydamas: „Viename mieste buvo vienas teisėjas, kuris nebijojo Dievo ir nepaisė žmonių; ");
INSERT INTO lit_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ir argi Dievas neįvykdys keršto už savo išrinktuosius, kurie dieną ir naktį jam šaukia, ir jų atžvilgiu jis ilgai pakenčia? ");
INSERT INTO lit_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ir jis pasakė šitą palyginimą kai kuriems, kurie pasitikėjo savimi, kad yra teisūs, o visus kitus niekino: ");
INSERT INTO lit_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","„Du žmonės nuėjo aukštyn į šventyklą melstis: vienas – fariziejus, o kitas – muitininkas. ");
INSERT INTO lit_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Fariziejus atsistojęs šitaip meldėsi sau: ‚Dieve, dėkoju tau, kad nesu kaip visi kiti žmonės – plėšikai, neteisūs, svetimautojai arba va kaip šis muitininkas. ");
INSERT INTO lit_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Aš pasninkauju du kartus per savaitę, duodu dešimtinę nuo visko, ką gaunu.‘ ");
INSERT INTO lit_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","O muitininkas, stovėdamas atokiai, net neturėjo noro savo akių pakelti į dangų, bet mušėsi į krūtinę, sakydamas: ‚Dieve, būk gailestingas man, nusidėjėliui!‘ ");
INSERT INTO lit_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Sakau jums: šitas nuėjo žemyn į savo namus išteisintas, ne anas, nes kiekvienas, kuris save aukština, bus pažemintas, bet kas save žemina, bus išaukštintas.“ ");
INSERT INTO lit_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Bet pasišaukęs juos Jėzus tarė: „Leiskite vaikučiams ateiti pas mane ir jiems nedrauskite, nes tokių yra dangaus karalystė. ");
INSERT INTO lit_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ir vienas valdytojas jo paklausė, sakydamas: „Gerasis Mokytojau, ką turiu daryti, kad paveldėčiau amžinąjį gyvenimą?“ ");
INSERT INTO lit_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","O Jėzus jam tarė: „Kodėl mane vadini geru? Niekas nėra geras, tik vienas Dievas. ");
INSERT INTO lit_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","nes lengviau kupranugariui pralįsti pro adatos ausį, negu turtingam įeiti į Dievo karalystę.“ ");
INSERT INTO lit_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","O jis tarė: „Tie dalykai, kurie neįmanomi žmonėms, yra įmanomi Dievui.“ ");
INSERT INTO lit_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Juk Žmogaus Sūnus atėjo ieškoti ir išgelbėti to, kas yra pražuvę. ");
INSERT INTO lit_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Bet jo piliečiai jo nekentė ir nusiuntė jam iš paskos pasiuntinius, sakydami: „Mes nesutinkame, kad šitas mums karaliautų!“ ");
INSERT INTO lit_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","sakydami: „Palaimintas Karalius, kuris ateina Viešpaties vardu! Ramybė danguje ir šlovė aukščiausiose aukštybėse!“ ");
INSERT INTO lit_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ir kai jis prisiartino, išvydęs miestą, jis dėl jo verkė, ");
INSERT INTO lit_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","sakydamas: „O kad tu, būtent tu, bent šioje savo dienoje būtum pažinęs tuos dalykus, kurie lemia tavo ramybę! Bet dabar jie yra paslėpti nuo tavo akių. ");
INSERT INTO lit_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Kiekvienas, kuris kris ant būtent to akmens, bus sudaužytas, bet ant ko jis nukris, tą sutriuškins. ");
INSERT INTO lit_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","O Jėzus atsakydamas jiems tarė: „Šio pasaulio vaikai veda ir yra duotos į žmonas; ");
INSERT INTO lit_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Jis gi nėra mirusiųjų Dievas, bet gyvųjų, nes visi gyvuoja jam. ");
INSERT INTO lit_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ir kai kuriems kalbant apie šventyklą, kad ji buvo išpuošta gražiais akmenimis bei įžadinėmis dovanomis, jis tarė: ");
INSERT INTO lit_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Dangus ir žemė praeis, bet mano žodžiai niekaip nepraeis. ");
INSERT INTO lit_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ir paėmęs duoną ir padėkojęs, ją laužė, ir davė jiems, sakydamas: „Tai yra mano kūnas, kuris už jus atiduodamas; tai darykite mano atminimui.“ ");
INSERT INTO lit_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Tokiu pat būdu jis paėmė ir taurę po vakarienės valgymo, sakydamas: „Ši taurė yra naujoji sandora mano krauju, kuris už jus išliejamas. ");
INSERT INTO lit_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Bet štai mane išduodančiojo ranka yra su manimi ant stalo. ");
INSERT INTO lit_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ir iš tiesų Žmogaus Sūnus eina, kaip buvo paskirta, bet vargas tam žmogui, per kurį jis yra išduotas!“ ");
INSERT INTO lit_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ir tarp jų taip pat kilo ginčas, kuris iš jų yra laikomas didžiausiu. ");
INSERT INTO lit_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","O jis jiems tarė: „Tautų karaliai jiems viešpatauja, ir tie, kurie jas užvaldo, yra vadinami geradariais. ");
INSERT INTO lit_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Bet jūs ne taip darykite. Priešingai, didžiausiasis tarp jūsų tebūna tarsi jauniausiasis, o kas vadovauja lyg tas, kuris tarnauja. ");
INSERT INTO lit_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Nes katras yra didesnis – kuris sėdi prie stalo ar kuris patarnauja? Argi ne tas, kuris sėdi prie stalo?! Tačiau aš tarp jūsų esu kaip tas, kuris patarnauja. ");
INSERT INTO lit_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","O jūs esate tie, kurie pasilikote su manimi mano išmėginimuose. ");
INSERT INTO lit_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ir aš skiriu jums karalystę, kaip mano Tėvas man paskyrė, ");
INSERT INTO lit_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","kad valgytumėte ir gertumėte prie mano stalo mano karalystėje ir sėdėtumėte sostuose, teisdami dvylika Izraelio genčių.“ ");
INSERT INTO lit_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ir Viešpats tarė: „Simonai, Simonai, štai Šėtonas pareiškė norą pasisavinti jus, kad persijotų jus kaip kviečius, ");
INSERT INTO lit_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","bet aš meldžiausi už tave, kad tavo tikėjimas nenustotų. Ir tu, tąsyk atsivertęs, sutvirtink savo brolius.“ ");
INSERT INTO lit_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Atėjęs į vietą, jis jiems tarė: „Melskitės, kad neįžengtumėte į pagundą. ");
INSERT INTO lit_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","ir tarė jiems: „Kodėl miegate? Kelkitės ir melskitės, kad įžengumėte į pagundą.“ ");
INSERT INTO lit_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Tada Pilotas tarė aukštiesiems kunigams ir miniai: „Aš nerandu šitame žmoguje jokios kaltės.“ ");
INSERT INTO lit_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ir tą pačią dieną Pilotas ir Erodas tapo draugais. Mat anksčiau jie buvo priešiški vienas kitam. ");
INSERT INTO lit_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","O sekė paskui jį daugybė liaudies bei moterų, kurios taip pat jį apdejavo ir apraudojo. ");
INSERT INTO lit_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Bet atsigręžęs į jas, Jėzus tarė: „Jeruzalės dukros, neverkite dėl manęs! Verčiau dėl savęs verkite ir dėl savo vaikų! ");
INSERT INTO lit_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Nes štai ateina dienos, kuriose jie sakys: ‚Palaimintos nevaisingosios ir įsčios, kurios negimdė, ir krūtys, kurios nežindė!‘ ");
INSERT INTO lit_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Tada jie pradės sakyti kalnams: ‚Griūkite ant mūsų!‘ – ir kalvoms: ‚Pridenkite mus!‘ ");
INSERT INTO lit_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Nes jeigu jie daro šiuos dalykus žaliam medžiui, tai kas atsitiks sausajam?!“ ");
INSERT INTO lit_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ir vienas iš pakabintų nusikaltėlių šmeižė jį, sakydamas: „Jei tu esi Kristus, išgelbėk save ir mus!“ ");
INSERT INTO lit_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Bet kitas sudrausdamas atsiliepė jam, sakydamas: „Ar tu net Dievo nebijai, nors tau galioja tas pats smerkiantis nuosprendis? ");
INSERT INTO lit_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","O mums, žinoma, teisėtai, nes gauname atlygį, atitinkantį mūsų darbus, bet šitas nieko nepadoraus nepadarė.“ ");
INSERT INTO lit_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ir jis tarė Jėzui: „Viešpatie, prisimink mane, kai savo karalystėje ateisi.“ ");
INSERT INTO lit_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ir Jėzus jam tarė: „Iš tiesų sakau tau: tu būsi su manimi rojuje šiandien.“ ");
INSERT INTO lit_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ir buvo apie šeštą valandą, ir visą kraštą apgaubė tamsa iki devintos valandos, ");
INSERT INTO lit_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ir saulė aptemo, ir šventyklos uždanga buvo perplėštas pusiau. ");
INSERT INTO lit_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ir sušukęs garsiu balsu Jėzus tarė: „Tėve, į tavo rankas aš pavedu savo dvasią!“ O tai pasakęs jis išleido dvasią. ");
INSERT INTO lit_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","O pirmąją savaitės dieną, labai anksti ryte, jos atėjo prie kapo, nešdamos kvepalus, kuriuos buvo paruošusios, ir su jomis buvo kai kurios kitos moterys. ");
INSERT INTO lit_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ir jos rado akmenį nuritintą nuo kapo, ");
INSERT INTO lit_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","o įėjusios nerado Viešpaties Jėzaus kūno. ");
INSERT INTO lit_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ir kai jos dėl to buvo labai sumišusios, įvyko taip, kad štai du vyrai spindinčiais drabužiais prisiartino prie jų. ");
INSERT INTO lit_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ir joms išsigandus ir nuleidus žemyn veidus, juodu joms tarė: „Kodėl ieškote gyvojo tarp mirusiųjų? ");
INSERT INTO lit_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Nėra jo čia, bet jis yra prikeltas! Atsiminkite, kaip jis, dar būdamas Galilėjoje, jums kalbėjo, ");
INSERT INTO lit_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","sakydamas: ‚Žmogaus Sūnus turi būti atiduotas į žmonių nusidėjėlių rankas, būti nukryžiuotas, ir trečią dieną prisikelti!‘“ ");
INSERT INTO lit_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Tada jos atsiminė jo žodžius. ");
INSERT INTO lit_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","O sugrįžusios nuo kapo, jos pranešė visa tai Vienuolikai ir visiems kitiems. ");
INSERT INTO lit_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ir įvyko, kad jiems besikalbant ir emocingai besitariant, pats Jėzus prisiartinęs keliavo kartu su jais. ");
INSERT INTO lit_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Tada jis tarė jiems: „O neišmaėliai, tai yra žmonės lėtos širdies tikėti visais dalykais, kuriuos kalbėjo pranašai! ");
INSERT INTO lit_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ir pradėjęs nuo Mozės ir visų pranašų jis aiškino ir aiškino jiems, kas visuose šventraščiuose pasakyta apie jį. ");
INSERT INTO lit_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ir jie vienas kitam tarė: „Argi mūsų širdys nedegė mumyse, kai jis kelyje mums kalbėjo ir kai mums atvėrė šventraščius?“ ");
INSERT INTO lit_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ir tą pačią valandą pakilę, jie sugrįžo į Jeruzalę ir rado susirinkusius Vienuolika ir tuos, kurie buvo su jais, ");
INSERT INTO lit_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","kurie sakė: „Viešpats prisikėlė tikrai ir pasirodė Simonui!“ ");
INSERT INTO lit_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Tada jis atvėrė jiems protą, kad jie galėtų suprasti šventraščius, ");
INSERT INTO lit_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ir tarė jiems: „Šitaip yra parašyta ir šitaip turėjo Kristus kentėti ir trečiąją dieną prisikelti iš mirusiųjų, ");
INSERT INTO lit_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ir jo vardu turi būti autoritetingai skelbiama visoms tautoms atgaila ir nuodėmių atleidimas, pradedant nuo Jeruzalės. ");
INSERT INTO lit_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ir jūs esate šių dalykų liudytojai. ");
INSERT INTO lit_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ir štai aš siunčiu ant jūsų, ką yra pažadėjęs mano Tėvas, o jūs pasilikite Jeruzalės mieste, kol būsite apvilkti jėga iš aukštybių.“ ");
INSERT INTO lit_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ir jis išvedė juos iki Betanijos, ir pakėlęs savo rankas, juos palaimino. ");
INSERT INTO lit_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ir įvyko taip, kad, kol jis juos laimino, jis pasitraukė nuo jų ir buvo paimtas į dangų. ");
INSERT INTO lit_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","O pagarbinę jį, jie su didžiu džiaugsmu sugrįžo į Jeruzalę, ");
INSERT INTO lit_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ir šventykloje būdavo nuolat, girdami ir laimindami Dievą. Amen. ");
INSERT INTO lit_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Pradžioje buvo Žodis, ir Žodis buvo pas Dievą, ir Žodis buvo Dievas. ");
INSERT INTO lit_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Tasai buvo pradžioje pas Dievą. ");
INSERT INTO lit_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Kiekviena visatos dalis atsirado per jį, ir be jo neatsirado nieko, kas tik yra atsiradę. ");
INSERT INTO lit_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Jame buvo gyvybė, ir ta gyvybė buvo žmonių Šviesa. ");
INSERT INTO lit_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ir Šviesa nuolat šviečia tamsoje, tačiau tamsa jos nepagavo. ");
INSERT INTO lit_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Atsirado nuo Dievo atsiųstas žmogus, vardu Jonas. ");
INSERT INTO lit_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Tasai atėjo tam, kad būtų liudijimas, – kad liudytų apie Šviesą, idant visi per jį įtikėtų. ");
INSERT INTO lit_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jis nebuvo ta Šviesa, bet buvo pasiųstas liudyti apie tą Šviesą. ");
INSERT INTO lit_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Tikroji Šviesa buvo ta, kuri apšviečia kiekvieną žmogų, ateinantį į pasaulį. ");
INSERT INTO lit_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Jis buvo pasaulyje, ir pasaulis atsirado per jį, bet pasaulis jo nepažinojo. ");
INSERT INTO lit_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Į savo nuosavybę jis atėjo, ir savieji jo nepriėmė. ");
INSERT INTO lit_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Bet visiems, kurie jį priėmė, tiems jis davė įgaliojimą tapti Dievo vaikais – tiems, kurie pasitiki jo vardu, ");
INSERT INTO lit_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","kurie yra pagimdyti nei iš kraujo, nei iš kūno valios, nei iš vyro valios, bet iš Dievo. ");
INSERT INTO lit_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","O tas Žodis tapo kūnu ir apsigyveno tarp mūsų – ir mes matėme jo šlovę, būtent Viengimio nuo Tėvo šlovę – pilnas malonės ir tiesos. ");
INSERT INTO lit_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jonas *liudijo apie jį ir šaukė, sakydamas: „Šitas buvo tas, apie kurį kalbėjau šitaip: „Tas, kuris ateina po manęs, yra viršesnis už mane, nes jis buvo anksčiau už mane“.“ ");
INSERT INTO lit_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ir mes visi iš jo pilnatvės gavome ir malonę, pakeičiančią malonę, ");
INSERT INTO lit_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","nes Įstatymas buvo duotas per Mozę; malonė ir tiesa atėjo per Jėzų Kristų. ");
INSERT INTO lit_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Dievo niekas niekada nėra matęs; viengimis Sūnus, kuris yra Tėvo užantyje, – tas jį apsakė. ");
INSERT INTO lit_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ir šitas yra Jono liudijimas, kai žydai iš Jeruzalės siuntė kunigų ir levitų jo paklausti: „Kas tu esi?“ ");
INSERT INTO lit_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ir jis išpažino ir neišsisukinėjo, bet išpažino: „Aš nesu Kristus.“ ");
INSERT INTO lit_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ir jie paklausė jo: „Tai kas gi? Ar tu Elijas?“ O jis sako: „Nesu.“ „Ar tu tas Pranašas?“ Ir jis atsakė: „Ne.“ ");
INSERT INTO lit_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Tada jie tarė jam: „Kas tu esi, kad mes galėtume duoti atsakymą tiems, kurie mus siuntė? Ką sakai apie save?“ ");
INSERT INTO lit_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Jis tarė: „Aš esu dykumoje šaukiančiojo balsas: „Darykite VIEŠPAČIUI tiesų kelią“, kaip sakė pranašas Izaijas.“ ");
INSERT INTO lit_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","O atsiųstieji buvo iš fariziejų. ");
INSERT INTO lit_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ir jo paklausdami jie jam tarė: „Tai kodėl krikštiji, jei nesi Kristus, nei Elijas, nei tas Pranašas?“ ");
INSERT INTO lit_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jonas jiems atsakė, tardamas: „Aš krikštiju vandeniu, bet tarp jūsų stovi tas, kurio jūs nepažįstate. ");
INSERT INTO lit_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Jis yra tas, kuris ateina po manęs, kuris yra viršesnis už mane, kurio apavo dirželio aš nesu vertas atrišti.“ ");
INSERT INTO lit_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Šie dalykai įvyko Betabaroje anapus Jordano, kur Jonas krikštydavo. ");
INSERT INTO lit_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Rytojaus dieną Jonas *pamatė ateinantį pas jį Jėzų ir *pasakė: „Štai Dievo Avinėlis, kuris pašalina pasaulio nuodėmę! ");
INSERT INTO lit_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Šitas yra tas, apie kurį aš sakiau: „Po manęs ateina vyras, kuris yra viršesnis už mane, nes jis buvo anksčiau už mane.“ ");
INSERT INTO lit_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ir aš jo nepažinojau, bet todėl atėjau krikštydamas vandeniu, – kad jis būtų apreikštas Izraeliui.“ ");
INSERT INTO lit_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ir Jonas paliudijo, sakydamas: „Aš mačiau Dvasią, lyg balandį nusileidžiančią iš dangaus, ir ji pasiliko ant jo. ");
INSERT INTO lit_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ir aš jo nepažinojau, bet tas, kuris mane siuntė krikštyti vandeniu, man pasakė: „Ant ko pamatysi nusileidžiančią Dvasią, taip pat ant jo pasiliekančią, jis yra tas, kuris krikštija Šventąja Dvasia.“ ");
INSERT INTO lit_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ir aš esu matęs ir esu liudijęs, kad šitas yra Dievo Sūnus.“ ");
INSERT INTO lit_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Rytojaus dieną vėl stovėjo Jonas ir du iš jo mokytinių, ");
INSERT INTO lit_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ir žiūrėdamas į einantį Jėzų jis sako: „Štai Dievo Avinėlis!“ ");
INSERT INTO lit_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Tuodu mokytiniai girdėjo jį tai kalbant ir nusekė paskui Jėzų. ");
INSERT INTO lit_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Tada Jėzus, atsigręžęs ir pamatęs juos sekančius, *tarė jiems: „Ko ieškote?“ O jie tarė jam: „Rabi, – (verčiant būtų pasakyta „Mokytojau“) – kur tamsta gyveni?“ ");
INSERT INTO lit_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jis *pasakė jiems: „Ateikite ir pamatykite.“ Jie atėjo ir pamatė, kur jis gyvena, ir tą dieną pasiliko pas jį. O buvo apie dešimtą valandą. ");
INSERT INTO lit_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Vienas iš tų dviejų, kurie buvo girdėję tai iš Jono ir nusekę paskui Jėzų, buvo Simono Petro brolis Andriejus. ");
INSERT INTO lit_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Jis pirmas *susiieškojo savo brolį Simoną ir jam *pasakė: „Mes radome Mesiją!“ (Išvertus tai reiškia „Kristų“). ");
INSERT INTO lit_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ir jis atvedė jį pas Jėzų, o įbedęs akis į jį Jėzus tarė: „Tu esi Simonas, Jonos sūnus. Tu būsi vadinamas Kefu.“ (Verčiant tai yra „Petras“.) ");
INSERT INTO lit_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Rytojaus dieną Jėzus norėjo eiti į Galilėją. Ir jis *surado Pilypą ir jam *tarė: „Sek paskui mane!“ ");
INSERT INTO lit_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","O Pilypas buvo iš Betsaidos, Andriejaus ir Petro miesto. ");
INSERT INTO lit_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pilypas *surado Natanaelį ir jam *pasakė: „Mes suradome tą, apie kurį rašė Mozė įstatyme, taip pat pranašai – Jėzų iš Nazareto, Juozapo sūnų.“ ");
INSERT INTO lit_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","O Natanaelis jam tarė: „Ar iš Nazareto gali būti kas gero?!“ Pilypas jam *sakė: „Ateik ir pasižiūrėk!“ ");
INSERT INTO lit_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jėzus pamatė Natanaelį, ateinantį pas jį, ir *pasakė apie jį: „Štai tikras izraelitas, kuriame nėra klastos!“ ");
INSERT INTO lit_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanaelis jam *tarė: „Iš kur mane pažinai?“ Jėzus atsakydamas tarė jam: „Prieš Pilypui pašaukiant tave, kai buvai po figmedžiu, aš mačiau tave.“ ");
INSERT INTO lit_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanaelis atsakydamas jam *tarė: „Rabi, tu esi Dievo Sūnus! Tu esi Izraelio Karalius!“ ");
INSERT INTO lit_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jėzus atsakydamas tarė jam: „Ar tu tiki, kadangi aš tau pasakiau: „Aš mačiau tave po figmedžiu“? Pamatysi už šituos didesnių dalykų.“ ");
INSERT INTO lit_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ir jis sako jam: „Iš tiesų, iš tiesų sakau jums: nuo šiol jūs matysite atvirą dangų ir Dievo angelus, kylančius ir nusileidžiančius ant Žmogaus Sūnaus.“ ");
INSERT INTO lit_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ir trečią dieną Galilėjos Kanoje buvo vestuvės, ir ten buvo Jėzaus motina, ");
INSERT INTO lit_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","taip pat ir Jėzus ir jo mokytiniai buvo pakviesti į vestuves. ");
INSERT INTO lit_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Pritrūkus vyno, Jėzaus motina jam sako: „Jie nebeturi vyno.“ ");
INSERT INTO lit_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jėzus jai sako: „Kas man ir tau bendro, moterie? Mano valanda dar neatėjo.“ ");
INSERT INTO lit_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Jo motina sako tarnams: „Darykite, ką tik jis jums sakys.“ ");
INSERT INTO lit_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ir ten pagal žydų apeiginio apvalymo papročius buvo padėti šeši akmeniniai vandens indai, kiekvienas talpinantis du arba tris saikus. ");
INSERT INTO lit_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jėzus jiems sako: „Vandens indus pripilkite vandeniu.“ Ir jie sklidinai juos pripylė. ");
INSERT INTO lit_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ir jis sako jiems: „Dabar semkite ir neškite vyriausiajam puotos tvarkytojui.“ Ir jie nunešė. ");
INSERT INTO lit_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Kai vyriausiasis puotos tvarkytojas paragavo paversto vynu vandens ir nežinojo, iš kur jis yra (nors tarnai, kurie sėmė vandenį, žinojo), vyriausiasis puotos tvarkytojas pasišaukia jaunikį ");
INSERT INTO lit_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ir jam sako: „Kiekvienas žmogus pirma stato gerąjį vyną, o kai žmonės sočiai atsigėrę, tada prastesnį; tu laikei gerąjį vyną iki šiol.“ ");
INSERT INTO lit_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Šitą antgamtinių ženklų pradžią Jėzus padarė Galilėjos Kanoje ir apreiškė savo šlovę; ir jo mokytiniai juo tikėjo. ");
INSERT INTO lit_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Po to jis ėjo žemyn į Kapernaumą, jis ir jo motina, ir jo broliai, ir jo mokytiniai. Ir ten jie pasiliko kelias dienas. ");
INSERT INTO lit_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ir žydų Aplenkimo šventė buvo arti, ir Jėzus nuvyko aukštyn į Jeruzalę ");
INSERT INTO lit_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","ir šventykloje rado prekiaujančių jaučiais, avimis, ir balandžiais, taip pat prisėdusių pinigų keitėjų. ");
INSERT INTO lit_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ir pasidaręs iš virvučių rimbą, jis išvarė juos visus – ir avis ir jaučius – iš šventyklos bei išpylė keitėjų pinigus bei apvertė stalus, ");
INSERT INTO lit_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","taip pat pasakė balandžių pardavėjams: „Pasiimkite šitai iš čia! Nepaverskite mano Tėvo namų prekybos namais!“ ");
INSERT INTO lit_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ir jo mokytiniai prisiminė, kad yra parašyta: Uolumas dėl tavo namų sugraužė mane. ");
INSERT INTO lit_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Todėl žydai atsiliepė ir jam tarė: „Kokį ženklą mums parodysi, kadangi šiuos dalykus darai?“ ");
INSERT INTO lit_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jėzus atsakydamas tarė jiems: „Sugriaukite šitą šventyklą, o aš per tris dienas ją atstatysiu.“ ");
INSERT INTO lit_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Tada žydai tarė: „Keturiasdešimt šešis metus buvo statoma ši šventykla, o tu ją atstatysi per tris dienas?!“ ");
INSERT INTO lit_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Bet jis kalbėjo apie savo kūno šventyklą. ");
INSERT INTO lit_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Todėl kai jis buvo prikeltas iš numirusiųjų, jo mokytiniai prisiminė, kad jis buvo jiems tai pasakęs, ir jie tikėjo šventraščiu ir ta žinia, kurią buvo pasakęs Jėzus. ");
INSERT INTO lit_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","O kai jis per Aplenkimo šventę buvo Jeruzalėje, šventės dieną, daugelis, stebėdami jo antgamtinius ženklus, kuriuos jis padarė, įtikėjo jo vardą. ");
INSERT INTO lit_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Bet Jėzus savęs jiems nepatikėjo, kadangi jis visus pažinojo, ");
INSERT INTO lit_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ir jam nereikėjo, kad kas paliudytų apie žmogų, nes pats žinojo, kas yra žmoguje. ");
INSERT INTO lit_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Iš fariziejų buvo žmogus, vardu Nikodemas, vienas iš žydų valdytojų. ");
INSERT INTO lit_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Šitas nakčia atėjo pas Jėzų ir jam tarė: „Rabi, mes žinome, kad tu esi atėjęs nuo Dievo mokytojas, nes niekas negali daryti šitų antgamtinių ženklų, kuriuos tu darai, jei Dievas nėra su juo.“ ");
INSERT INTO lit_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jėzus atsakydamas jam tarė: „Iš tiesų, iš tiesų sakau tau: jei kas nėra gimęs iš naujo, jis negali matyti Dievo karalystės.“ ");
INSERT INTO lit_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemas jam sako: „Kaip žmogus gali gimti, būdamas senas? Ar jis gali antrą kartą įeiti į savo motinos įsčias ir gimti?“ ");
INSERT INTO lit_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jėzus atsakė: „Iš tiesų, iš tiesų sakau tau: jei kas nėra gimęs iš vandens ir Dvasios, tas negali įeiti į Dievo karalystę. ");
INSERT INTO lit_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Tas, kuris yra gimęs iš kūno, yra kūnas; o tas, kuris yra gimęs iš Dvasios, yra dvasia. ");
INSERT INTO lit_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Nesistebėk, kad tau pasakiau: jums būtina gimti iš naujo. ");
INSERT INTO lit_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Vėjas pučia, kur jis nori, ir tu girdi jo garsą, bet nežinai, iš kur ateina ir kurlink nueina. Kiekvienas, kuris yra gimęs iš Dvasios, yra taip besielgiantis žmogus.“ ");
INSERT INTO lit_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemas atsakydamas jam tarė: „Kaip tai gali būti?“ ");
INSERT INTO lit_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jėzus atsakydamas jam tarė: „Tu esi Izraelio mokytojas ir nežinai šitų dalykų? ");
INSERT INTO lit_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Iš tiesų, iš tiesų sakau tau: mes kalbame, ką žinome, ir liudijame, ką matėme, o jūs nepriimate mūsų liudijimo. ");
INSERT INTO lit_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Jei pasakiau jums žemiškus dalykus ir jūs netikite, tai kaipgi jūs tikėsite, jei pasakysiu jums dangiškus dalykus? ");
INSERT INTO lit_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ir niekas nėra pakilęs į dangų išskyrus tą, kuris nužengė iš dangaus, – Žmogaus Sūnus, kuris yra danguje. ");
INSERT INTO lit_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ir kaip Mozė dykumoje iškėlė gyvatę, taip turi būti iškeltas Žmogaus Sūnus, ");
INSERT INTO lit_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","kad kiekvienas, kuris juo tiki, nepražūtų, bet turėtų amžiną gyvenimą. ");
INSERT INTO lit_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Nes Dievas taip mylėjo pasaulį, jog davė savo viengimį Sūnų, kad kiekvienas, kuris juo tiki, nepražūtų, bet turėtų amžiną gyvenimą. ");
INSERT INTO lit_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Dievas gi nesiuntė savo Sūnaus į pasaulį, kad jis pasaulį nuteistų, bet kad pasaulis per jį būtų išgelbėtas. ");
INSERT INTO lit_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Kas juo tiki yra neteisiamas, o kas netiki, jau yra nuteistas, nes nėra tikėjęs Dievo viengimio Sūnaus vardu. ");
INSERT INTO lit_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ir šis yra nuteisimo pagrindas: Šviesa yra atėjusi į pasaulį, bet žmonės labiau mylėjo tamsą nei Šviesą, nes jų darbai buvo blogi. ");
INSERT INTO lit_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Nes kiekvienas, kuris daro nedorus dalykus, neapkenčia Šviesos ir neina į Šviesą, kad jo darbai nebūtų išpeikti. ");
INSERT INTO lit_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Bet kas vykdo tiesą, tas eina į Šviesą, idant jo darbai būtų aiškiai atskleisti, kad jie nuveikti Dieve.“ ");
INSERT INTO lit_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Po šių dalykų Jėzus ir jo mokytiniai atėjo į Judėjos kraštą, ir ten jis su jais kurį laiką išbuvo ir krikštydavo. ");
INSERT INTO lit_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","O Enone, arti Salimo, Jonas irgi krikštydavo, nes ten buvo daug vandens. Žmonės ateidavo ir būdavo pakrikštijami, ");
INSERT INTO lit_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","mat Jonas dar nebuvo įmestas į kalėjimą. ");
INSERT INTO lit_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Tada iškilo klausimas tarp kai kurių Jono mokytinių ir tam tikrų žydų dėl apeiginio apsivalymo. ");
INSERT INTO lit_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ir jie atėjo pas Joną ir jam tarė: „Rabi, tas, kuris buvo su tavimi anapus Jordano, kurį tu esi paliudijęs, štai jis krikštija, ir visi eina pas jį.“ ");
INSERT INTO lit_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jonas atsakydamas tarė: „Žmogus nieko negali pasiimti, jeigu jam nebūtų duota iš dangaus. ");
INSERT INTO lit_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Jūs patys man liudijate, kad aš pasakiau: aš nesu Kristus, bet kad esu pasiųstas pirma jo. ");
INSERT INTO lit_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Kas turi nuotaką, tas yra jaunikis; bet jaunikio draugas, kuris stovi šalia ir jo klausosi, džiaugte džiaugiasi jaunikio balsu. Taigi šis mano džiaugsmas yra pilnatviškas. ");
INSERT INTO lit_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Jam būtina eiti didyn, bet man – mažėti. ");
INSERT INTO lit_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Kas ateina iš aukštai, yra aukščiau visų. Kas yra iš žemės, yra žemiškas ir kalba žemiškai. Kas ateina iš dangaus, yra aukščiau visų ");
INSERT INTO lit_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ir jis liudija tai, ką jis yra matęs ir girdėjęs, o niekas jo liudijimo nepriima. ");
INSERT INTO lit_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Kas yra priėmęs jo liudijimą, tas užantspaudavo tai, kad Dievas yra tiesakalbis. ");
INSERT INTO lit_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Nes tas, kurį Dievas yra atsiuntęs, kalba Dievo žodžius, nes Dievas duoda Dvasią be saiko. ");
INSERT INTO lit_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tėvas myli Sūnų, ir visa yra atidavęs į jo ranką. ");
INSERT INTO lit_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Kas pasitiki Sūnumi, turi amžiną gyvenimą, o kas atsisako tikėti Sūnumi – gyvenimo nematys; priešingai, Dievo rūstybė pasilieka ant jo.“ ");
INSERT INTO lit_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Taigi kai Viešpats sužinojo, kad fariziejai išgirdo, jog Jėzus padaro ir pakrikštija daugiau mokytinių negu Jonas ");
INSERT INTO lit_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(nors pats Jėzus gi nekrikštijo, tik jo mokytiniai), ");
INSERT INTO lit_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","jis paliko Judėją ir nuėjo vėl į Galilėją. ");
INSERT INTO lit_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ir jam reikėjo eiti per Samariją. ");
INSERT INTO lit_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Taigi jis ateina į Samarijos miestą, vadinamą Sicharu, prie pat žemės sklypo, kurį Jokūbas davė savo sūnui Juozapui. ");
INSERT INTO lit_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","O ten buvo Jokūbo šaltinis. Todėl Jėzus, nuvargęs nuo kelionės, atsisėdo taip prie šaltinio. Buvo apie šeštą valandą. ");
INSERT INTO lit_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ateina moteris iš Samarijos semtis vandens. Jėzus jai sako: „Duok man gerti.“ ");
INSERT INTO lit_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Mat jo mokytiniai buvo nuėję į miestą nupirkti maisto). ");
INSERT INTO lit_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Tad moteris iš Samarijos jam sako: „Kaip tamsta, būdamas žydas, prašai mane, Samarijos moterį, gerti? Nes žydai nesimaišo su samariečiais.“ ");
INSERT INTO lit_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jėzus atsakydamas jai tarė: „Jeigu būtum pažinusi Dievo dovaną ir kas yra tas, kuris tau sako: „Duok man gerti“, būtum jo prašiusi, ir jis būtų tau davęs gyvojo vandens.“ ");
INSERT INTO lit_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Moteris jam sako: „Gerbiamasis, tamsta neturi kuo pasemti, o šulinys yra gilus; tad iš kur tamsta turi to gyvojo vandens? ");
INSERT INTO lit_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Nejaugi tamsta esi didesnis už mūsų tėvą Jokūbą, kuris tą šulinį mums davė ir pats iš jo gėrė, ir jo vaikai, ir jo gyvuliai?“ ");
INSERT INTO lit_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jėzus atsakydamas jai tarė: „Kiekvienas, kuris geria šio vandens, vėl trokš, ");
INSERT INTO lit_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","tačiau kas gers vandens, kurio aš jam duosiu, niekaip nebetrokš per amžius, bet vanduo, kurį jam duosiu, jame taps šaltiniu vandens, trykštančio į amžiną gyvenimą.“ ");
INSERT INTO lit_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Moteris jam sako: „Gerbiamasis, duok man šio vandens, kad nebetrokščiau ir nebeičiau semtis čionai.“ ");
INSERT INTO lit_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jėzus jai sako: „Eik, pašauk savo vyrą ir čionai ateik!“ ");
INSERT INTO lit_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Moteris atsakydama tarė: „Neturiu vyro.“ Jėzus jai tarė: „Gerai pasakei: „Neturiu vyro“, ");
INSERT INTO lit_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","nes esi turėjusi penkis vyrus, ir tas, kurį dabar turi, nėra tavo vyras. Čia tu tiesą pasakei!“ ");
INSERT INTO lit_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Moteris jam sako: „Gerbiamasis, matau, kad tamsta esi pranašas. ");
INSERT INTO lit_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Mūsų tėvai garbino šiame kalne, o jūs sakote, kad Jeruzalėje yra vieta, kur reikia garbinti.“ ");
INSERT INTO lit_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jėzus jai sako: „Moterie, tikėk manimi, kad ateina valanda, kada garbinsite Tėvą nei šiame kalne, nei Jeruzalėje. ");
INSERT INTO lit_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Jūs garbinate, ko nepažįstate; mes garbiname, ką pažįstame, nes išgelbėjimas yra iš žydų. ");
INSERT INTO lit_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Bet ateina valanda, ir dabar ji jau yra, kai tikrieji garbintojai garbins Tėvą dvasia ir tiesa, nes ir tokių jį garbinančių ieško Tėvas. ");
INSERT INTO lit_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Dievas yra Dvasia, ir tie, kurie garbina jį, turi garbinti dvasia ir tiesa.“ ");
INSERT INTO lit_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Moteris jam sako: „Žinau, kad Mesijas ateina, kuris vadinamas Kristumi. Kai jis ateis, viską mums praneš jis.“ ");
INSERT INTO lit_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jėzus jai sako: „Tai aš, kuris su tavimi kalbu!“ ");
INSERT INTO lit_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ir kaip tik tuo metu atėjo jo mokytiniai ir stebėjosi, kad jis kalbėjosi su moterimi. Vis dėlto nė vienas nepasakė: „Ko sieki?“ arba: „Kodėl su ja kalbi?“ ");
INSERT INTO lit_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Tada moteris paliko savo vandens ąsotį, nuėjo į miestą ir sako žmonėms: ");
INSERT INTO lit_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","„Eikite šen, pamatykite žmogų, kuris man pasakė viską, ką tik esu padariusi! Nejaugi jis nėra Kristus?!“ ");
INSERT INTO lit_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Tada jie išėjo iš miesto ir ėjo pas jį. ");
INSERT INTO lit_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","O tuo tarpu jo mokytiniai maldavo jį, sakydami: „Mokytojau, valgyk!“ ");
INSERT INTO lit_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Bet jis jiems tarė: „Aš turiu maisto valgymui, apie kurį nežinote jūs.“ ");
INSERT INTO lit_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Todėl mokytiniai tarė vienas kitam: „Nejaugi kas atnešė jam valgyti?“ ");
INSERT INTO lit_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jėzus jiems sako: „Mano maistas – vykdyti valią to, kuris mane siuntė, ir pabaigti jo darbą. ");
INSERT INTO lit_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ar jūs nesakote: „Dar keturi mėnesiai, ir ateis pjūtis“? Štai, jums sakau, pakelkite akis ir pažiūrėkite į laukus, kad jie pabalę pjūčiai! ");
INSERT INTO lit_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ir pjovėjas gauna atlygį ir surenka vaisių amžinam gyvenimui, kad kartu džiaugtųsi ir sėjėjas ir pjovėjas. ");
INSERT INTO lit_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Nes šiuo atveju yra teisingas tas posakis: „Vienas sėja, o kitas pjauna“. ");
INSERT INTO lit_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Aš pasiunčiau jus pjauti to, dėl ko jūs netriūsėte. Kiti triūsė, o jūs esate įstoję į jų darbą.“ ");
INSERT INTO lit_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ir daug to miesto samariečių juo įtikėjo dėl žodžio moters, kuri liudijo: „Jis man pasakė viską, ką esu padariusi.“ ");
INSERT INTO lit_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Taigi, kai samariečiai atėjo pas jį, jie prašė jį pasilikti pas juos. Ir jis ten pasiliko dvi dienas. ");
INSERT INTO lit_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ir daug daugiau žmonių įtikėjo dėl jo paties žodžio ");
INSERT INTO lit_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ir tarė moteriai: „Jau nebe dėl tavo kalbos tikime, nes patys išgirdome jį ir žinome, kad šitas iš tikrųjų yra Kristus, pasaulio Išgelbėtojas.“ ");
INSERT INTO lit_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","O po tų dviejų dienų jis iš ten išvyko ir nuėjo į Galilėją, ");
INSERT INTO lit_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","nes pats Jėzus buvo paliudijęs, kad pranašas negerbiamas savo tėviškėje. ");
INSERT INTO lit_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Taigi, kai jis atėjo į Galilėją, galilėjiečiai jį priėmė, nes buvo matę visa, ką jis per šventę buvo padaręs Jeruzalėje, nes ir jie buvo nuvykę į šventę. ");
INSERT INTO lit_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Taigi Jėzus vėl atėjo į Galilėjos Kaną, kur jis pavertė vandenį vynu. Ir buvo tam tikras karaliaus valdininkas, kurio sūnus sirgo Kapernaume. ");
INSERT INTO lit_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Šis, išgirdęs, kad Jėzus iš Judėjos atvyko į Galilėją, nuėjo pas jį ir maldavo jo, kad nueitų žemyn ir išgydytų jo sūnų, nes jis buvo prie mirties. ");
INSERT INTO lit_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Tad Jėzus jam tarė: „Jeigu nepamatysite antgamtinių ženklų ir stebuklų, niekaip netikėsite.“ ");
INSERT INTO lit_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Karaliaus valdininkas jam sako: „Gerbiamasis, ateik žemyn, kol mano vaikelis dar nenumirė!“ ");
INSERT INTO lit_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jėzus jam sako: „Eik, tavo sūnus gyvuoja!“ Ir žmogus patikėjo žodžiu, kurį Jėzus jam pasakė, ir iškeliavo. ");
INSERT INTO lit_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ir jam beeinant žemyn, jį pasitiko jo tarnai ir jam pranešė, sakydami: „Tavo sūnus gyvuoja!“ ");
INSERT INTO lit_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Tada jis teiravosi jų, kurią valandą jis pradėjo taisytis. Ir jie tarė jam: „Vakar septintą valandą karštinė jį paliko.“ ");
INSERT INTO lit_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Taigi tėvas suprato, kad tai buvo ta pati valanda, kurią Jėzus jam tarė: „Tavo sūnus gyvuoja!“ Ir jis pats įtikėjo bei visa jo šeimyna. ");
INSERT INTO lit_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Šitą Jėzus vėl padarė – antrą antgamtinį ženklą, – kai jis buvo parvykęs iš Judėjos į Galilėją. ");
INSERT INTO lit_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Po šių dalykų buvo žydų šventė, ir Jėzus nuvyko aukštyn į Jeruzalę. ");
INSERT INTO lit_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","O Jeruzalėje prie avių vartų yra baseinas, hebrajiškai vadinamas Betezda, turintis penkias kolonų palaikomas stogines. ");
INSERT INTO lit_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Juose gulėjo labai didelis būrys ligonių – aklų, šlubių, sudžiūvusių, kurie laukė vandens sujudėjimo. ");
INSERT INTO lit_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Nes angelas kokiu nors metu nusileisdavo į baseiną ir sujudindavo vandenį; tad kas pirmas po vandens sujudinimo įlipdavo, pasveikdavo nuo bet kokios ligos, kokia besirgdavo. ");
INSERT INTO lit_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ir ten buvo tam tikras žmogus, kuris turėjo negalią trisdešimt aštuonerius metus. ");
INSERT INTO lit_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jėzus pamatęs jį gulintį ir žinodamas, kad jis jau ilgą laiką tokios būklės, jam sako: „Ar nori pasveikti?“ ");
INSERT INTO lit_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ligonis jam atsakė: „Gerbiamasis, neturiu žmogaus, kuris vandeniui sujudėjus įkeltų mane į baseiną, o kol pats einu, kitas pirma manęs įžengia.“ ");
INSERT INTO lit_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jėzus jam sako: „Kelkis, pasiimk savo gultą ir vaikščiok!“ ");
INSERT INTO lit_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ir tuojau tas žmogus pasveiko ir paėmė savo gultą, ir vaikščiojo. O ta diena buvo šabas. ");
INSERT INTO lit_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Todėl žydai tarė išgydytajam: „Yra šabas, tau neteisėta nešti gulto“. ");
INSERT INTO lit_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Jis atsakė jiems: „Tas, kuris mane išgydė, man tarė: „Pasiimk savo gultą ir vaikščiok“.“ ");
INSERT INTO lit_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Tada jie paklausė jo: „Kas yra tas žmogus, pasakęs tau: ‚Pasiimk savo gultą ir vaikščiok‘?“ ");
INSERT INTO lit_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Bet išgydytasis nežinojo, kas jis, nes, miniai esant toje vietoje, Jėzus buvo pasitraukęs. ");
INSERT INTO lit_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Po šių dalykų Jėzus rado jį šventykloje ir tarė jam: „Štai esi pasveikęs; daugiau nebenusidėk, kad neatsitiktų tau kas blogesnio!“ ");
INSERT INTO lit_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Žmogus nuėjo ir pasakė žydams, kad tas, kuris jį išgydė, yra Jėzus. ");
INSERT INTO lit_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ir todėl žydai persekiodavo Jėzų ir siekdavo jį nužudyti, nes jis padarė tai šabo dieną. ");
INSERT INTO lit_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Bet Jėzus jiems atsakydavo: „Mano Tėvas lig šiolei dirba, ir aš dirbu.“ ");
INSERT INTO lit_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Dėl to žydai dar labiau siekė jį nužudyti, nes jis ne tik sulaužė šabą, bet ir vadino Dievą savo Tėvu, prilygindamas save Dievui. ");
INSERT INTO lit_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Tada Jėzus atsiliepė ir pasakė jiems: „Iš tiesų, iš tiesų sakau jums: Sūnus nieko negali daryti vadovaudamasis savimi, bet jis daro tik tai, ką mato Tėvą darant, nes tai, ką jis daro, tuo pat būdu ir Sūnus daro tuos pačius dalykus. ");
INSERT INTO lit_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Nes Tėvas myli Sūnų ir parodo jam visus dalykus, kuriuos jis pats daro, ir jis parodys jam darbų, dar didesnių už šituos, kad jūs stebėtumėtės. ");
INSERT INTO lit_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Nes kaip Tėvas prikelia mirusiuosius ir duoda jiems gyvybę, taip ir Sūnus duoda gyvybę tiems, kuriems nori. ");
INSERT INTO lit_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Nes net Tėvas neteisia nė vieno, bet visą teismą yra pavedęs Sūnui, ");
INSERT INTO lit_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","kad visi gerbtų Sūnų lygiai taip, kaip jie gerbia Tėvą. Kas negerbia Sūnaus, negerbia jį siuntusio Tėvo. ");
INSERT INTO lit_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Iš tiesų, iš tiesų sakau jums: kas klauso mano žodžio ir tiki mane atsiuntusiuoju, tas turi amžiną gyvenimą ir neina į smerkiantį teismą, bet iš mirties yra perėjęs į gyvenimą. ");
INSERT INTO lit_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Iš tiesų, iš tiesų sakau jums: ateina valanda, ir dabar jau yra, kada mirusieji išgirs Dievo Sūnaus balsą; ir tie, kurie išgirs, gyvuos. ");
INSERT INTO lit_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Nes kaip Tėvas turi gyvybę pats savyje, taip davė ir Sūnui turėti gyvybę pačiam savyje, ");
INSERT INTO lit_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","ir taip pat davė jam įgaliojimą įvykdyti teismą, nes jis yra Žmogaus Sūnus. ");
INSERT INTO lit_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Tuo nesistebėkite! Νes ateina valanda, kai visi, esantys kapuose, išgirs jo balsą ");
INSERT INTO lit_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ir išeis: tie, kurie darydavo gera – į gyvenimo prisikėlimą; o tie, kurie darydavo bloga – į smerkiančio teismo prisikėlimą. ");
INSERT INTO lit_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Aš nieko negaliu daryti vadovaudamasis savimi. Aš teisiu, kaip girdžiu, ir mano teismas yra teisingas, nes aš ieškau ne savo valios, bet valios Tėvo, kuris mane siuntė. ");
INSERT INTO lit_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Jei liudyčiau pats apie save, mano liudijimas nebūtų tiesa; ");
INSERT INTO lit_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","yra kitas, kuris apie mane liudija, ir aš žinau, kad liudijimas, kurį jis apie mane liudija, yra tiesa. ");
INSERT INTO lit_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Jūs esate nusiuntę pasiuntiniuspas Joną, ir jis yra paliudijęs tiesą. ");
INSERT INTO lit_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Bet aš pats priimu liudijimą ne iš žmogaus, bet sakau šiuos dalykus, kad patys būtumėte išgelbėti. ");
INSERT INTO lit_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jis buvo degantis ir spindintis žiburys, ir jūs norėjote džiūgauti jo šviesa trumpą laiką. ");
INSERT INTO lit_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Bet aš turiu didesnį liudijimą negu tą iš Jono, nes darbai, kuriuos Tėvas man davė pabaigti, tie patys darbai, kuriuos aš darau, liudija apie mane, kad Tėvas mane siuntė. ");
INSERT INTO lit_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ir pats Tėvas, kuris mane siuntė, yra paliudijęs apie mane. Jūs nesate nei jo balso kada nors girdėję, nei jo pavidalo regėję, ");
INSERT INTO lit_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ir neturite jo žodžio jumyse pasiliekančio, nes netikite tuo, kurį jis siuntė. ");
INSERT INTO lit_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Tyrinėkite šventraščius, kadangi manote, kad juose turite amžiną gyvenimą; ir būtent jie liudija apie mane. ");
INSERT INTO lit_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ir jūs nesutinkate ateiti pas mane, kad turėtumėte gyvenimą. ");
INSERT INTO lit_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Nepriimu šlovės iš žmonių. ");
INSERT INTO lit_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Bet jus pažįstu, kad jūs neturite savyje Dievo meilės. ");
INSERT INTO lit_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Savo Tėvo vardu esu atėjęs, bet jūs manęs nepriimate. Jeigu savo vardu ateitų kitas, tą priimsite. ");
INSERT INTO lit_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Kaipgi galite įtikėti jūs, kurie vieni iš kitų priimate šlovę, o šlovės, kuri ateina iš vienintelio Dievo, neieškote?! ");
INSERT INTO lit_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Nemanykite, kad aš jus kaltinsiu Tėvui. Yra, kas jus kaltina – Mozė, į kurį jūs esate sudėję savo viltis. ");
INSERT INTO lit_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Nes jei būtumėte tikėję Moze, tikėtumėte manimi, nes jis rašė apie mane. ");
INSERT INTO lit_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Bet jei netikite jo raštais, kaipgi tikėsite mano žodžiais?!“ ");
INSERT INTO lit_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Po šių dalykų Jėzus nuvyko anapus Galilėjos, tai yra Tiberiados, jūros. ");
INSERT INTO lit_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ir paskui jį sekė didelė žmonių minia, nes jie matė jo antgamtinius ženklus, kuriuos jis darė ligoniams. ");
INSERT INTO lit_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ir Jėzus užkopė į kalną ir ten atsisėdo kartu su savo mokytiniais. ");
INSERT INTO lit_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","(O arti buvo Aplenkimas, žydų šventė.) ");
INSERT INTO lit_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Tada Jėzus, pakėlęs akis ir pamatęs didelę minią ateinant pas jį, sako Pilypui: „Iš kur nupirksime duonos, kad šitie galėtų valgyti?“ ");
INSERT INTO lit_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ο jis tai pasakė mėgindamas jį, nes pats žinojo, ką darysiąs. ");
INSERT INTO lit_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pilypas jam atsakė: „Už du šimtus denarų duonos jiems neužteks, kad kiekvienas iš jų gautų bent truputį.“ ");
INSERT INTO lit_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Vienas iš jo mokytinių, Simono Petro brolis Andriejus, jam sako: ");
INSERT INTO lit_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","„Yra čia vienas berniukas, kuris turi penkis miežinės duonos kepaliukus ir dvi žuveles, bet ką tai reiškia tokiai daugybei?!“ ");
INSERT INTO lit_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ir Jėzus tarė: „Susodinkite žmones.“ O toje vietoje buvo daug žolės. Taigi vyrai susėdo, iš viso kokie penki tūkstančiai. ");
INSERT INTO lit_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ir Jėzus paėmė kepaliukus ir padėkojęs išdalijo mokytiniams, o mokytiniai susėdusiems; irgi tokiu pat būdu iš žuvų, kiek jie norėjo. ");
INSERT INTO lit_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Kai jie buvo pasotinti, jis tarė savo mokytiniams: „Surinkite pertekusius gabalus, kad niekas neprapultų.“ ");
INSERT INTO lit_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Taigi jie surinko ir pripildė dvylika pintinių gabalų iš penkių miežinės duonos kepaliukų, kurie buvo pertekę valgiusiesiems. ");
INSERT INTO lit_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Tad žmonės, pamatę antgamtinį ženklą, kurį padarė Jėzus, tarė: „Šitas tikrai yra tas Pranašas, ateinantysis į pasaulį.“ ");
INSERT INTO lit_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Taigi, Jėzus, supratęs, kad jie ruošiasi ateiti ir pasigriebti jį, kad padarytų jį karaliumi, vėl pasitraukė pats vienas į kalną. ");
INSERT INTO lit_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","O kai atėjo vakaras, jo mokytiniai nusileido prie jūros ");
INSERT INTO lit_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ir, įlipę į valtį, ėmė keliauti anapus jūros į Kapernaumą. (O jau buvo sutemę, ir Jėzus dar nebuvo atėjęs pas juos.) ");
INSERT INTO lit_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Jūra įsibangavo, nes pūtė smarkus vėjas. ");
INSERT INTO lit_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Nusiyrę apie dvidešimt penkis ar trisdešimt stadijų, jie pamato Jėzų, einantį jūros paviršiumi ir besiartinantį prie valties, ir jie išsigando. ");
INSERT INTO lit_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","O jis sako: „Tai aš. Nebijokite!“ ");
INSERT INTO lit_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Tada jie panoro jį pasiimti į valtį, ir iškart valtis atsidūrė prie kranto, į kur jie keliavo. ");
INSERT INTO lit_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Rytojaus dieną, kai minia, stovinti kitoje jūros pusėje, pastebėjo, kad ten nebuvo jokios kitos valtelės, išskyrus tą, į kurią buvo įlipę jo mokytiniai, ir kad Jėzus nebuvo kartu su savo mokytiniais įlipęs į valtelę, bet jo mokytiniai buvo išvykę vieni ");
INSERT INTO lit_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","– (nors atkeliavo kitų valtelių iš Tiberiados ir sustojo prie pat tos vietos, kur, Viešpačiui padėkojus, jie buvo valgę) – ");
INSERT INTO lit_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","taigi, kai minia pamatė, kad ten nebuvo nei Jėzaus, nei jo mokytinių, tai ir jie patys įlipo į valtis ir atkeliavo į Kapernaumą, ieškodami Jėzaus. ");
INSERT INTO lit_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ir suradę jį kitoje jūros pusėje jie tarė jam: „Rabi, kada čia atvykai?“ ");
INSERT INTO lit_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jėzus jiems atsakydamas tarė: „Iš tiesų, iš tiesų sakau jums: jūs manęs ieškote ne dėl to, kad supratote antgamtinius ženklus, bet todėl, kad valgėte duonos ir pasisotinote. ");
INSERT INTO lit_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Dirbkite ne dėl žūvančio maisto, bet dėl maisto, išliekančio amžinam gyvenimui, kurį duos jums Žmogaus Sūnus, nes jį užantspaudavo Tėvas, tai yra Dievas.“ ");
INSERT INTO lit_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Tada jie tarė jam: „Ką mums daryti, kad dirbtume Dievo darbus?“ ");
INSERT INTO lit_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jėzus atsakydamas jiems tarė: „Tai yra Dievo reikalaujamas darbas, kad tikėtumėte tuo, kurį jis siuntė.“ ");
INSERT INTO lit_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Tad jie tarė jam: „Tai kokį antgamtinį ženklą darysi, kad matytume ir tikėtume tavimi? Ką nuveiksi? ");
INSERT INTO lit_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Mūsų tėvai valgė maną dykumoje; kaip yra parašyta: Jis davė jiems valgyti duonos iš dangaus.“ ");
INSERT INTO lit_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Tada Jėzus jiems tarė: „Iš tiesų, iš tiesų sakau jums: ne Mozė davė jums tos duonos iš dangaus, bet mano Tėvas duoda jums iš dangaus tikrąją duoną. ");
INSERT INTO lit_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Nes Dievo duona yra tas, kuris nužengia iš dangaus ir duoda pasauliui gyvybę.“ ");
INSERT INTO lit_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Tada jie tarė jam: „Viešpatie, visada duok mums šios duonos!“ ");
INSERT INTO lit_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","O Jėzus jiems atsakė: „Aš esu gyvybės duona! Kas ateina pas mane, niekuomet nealks, ir kas tiki manimi, niekuomet nebetrokš. ");
INSERT INTO lit_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Bet jums pasakiau, kad jūs irgi mane matėte, tačiau netikite. ");
INSERT INTO lit_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Visi, kuriuos man duoda Tėvas, ateis pas mane, ir ateinančio pas mane jokiu būdu neišvarysiu lauk, ");
INSERT INTO lit_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","nes aš nužengiau iš dangaus vykdyti ne savo valios, bet valios to, kuris mane siuntė. ");
INSERT INTO lit_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ir šita yra valia Tėvo, kuris mane siuntė, kad aš neprarasčiau nė vieno iš visos grupės, kurią jis man yra davęs, bet kad paskutiniąją dieną prikelčiau juos visus. ");
INSERT INTO lit_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ir šita yra valia to, kuris mane siuntė, kad kiekvienas, kuris mato Sūnų ir juo tiki, turėtų amžiną gyvenimą; ir aš jį prikelsiu paskutiniąją dieną.“ ");
INSERT INTO lit_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Tada žydai dėl jo murmėjo, nes jis buvo pasakęs: „Aš esu ta duona, kuri nužengė iš dangaus.“ ");
INSERT INTO lit_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","O jie tarė: „Argi jis ne Jėzus, Juozapo sūnus, kurio tėvą ir motiną mes pažįstame?! Tad kaipgi jis sako: ‚Aš esu nužengęs iš Dangaus‘?!“ ");
INSERT INTO lit_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Todėl atsakydamas Jėzus jiems tarė: „Nemurmėkite tarpusavyje! ");
INSERT INTO lit_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Niekas nepajėgia ateiti pas mane, nebent jį patrauks Tėvas, kuris mane siuntė; ir tą aš prikelsiu paskutiniąją dieną. ");
INSERT INTO lit_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Yra parašyta Pranašuose: Ir bus visi mokomi Dievo. Todėl, kiekvienas, kuris išgirdo iš Tėvo ir pasimokė, ateina pas mane. ");
INSERT INTO lit_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Nėra taip, jog kas yra matęs Tėvą – tiktai tas, kuris iš Dievo yra, tas yra matęs Tėvą. ");
INSERT INTO lit_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Iš tiesų, iš tiesų sakau jums: kas tiki manimi, turi amžiną gyvenimą. ");
INSERT INTO lit_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Aš esu gyvybės duona. ");
INSERT INTO lit_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Jūsų tėvai dykumoje valgė maną ir mirė. ");
INSERT INTO lit_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Šita yra duona, kuri nužengia iš Dangaus, kad bet kuris žmogus jos valgytų ir nemirtų. ");
INSERT INTO lit_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Aš esu gyvoji duona, kuri nužengė iš dangaus; jei kas valgys šitos duonos, gyvens per amžius; ir duona, kurią aš duosiu, yra mano kūnas, kurį aš duosiu už pasaulio gyvybę.“ ");
INSERT INTO lit_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Todėl žydai ginčijosi tarp savęs, sakydami: „Kaip šitas gali mums duoti valgyti savo kūną?“ ");
INSERT INTO lit_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Tada Jėzus jiems tarė: „Iš tiesų, iš tiesų sakau jums: jeigu nevalgysite Žmogaus Sūnaus kūno ir negersite jo kraujo, neturėsite savyje gyvybės. ");
INSERT INTO lit_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Kas valgo mano kūną ir geria mano kraują, turi amžiną gyvenimą, ir aš jį prikelsiu paskutiniąją dieną. ");
INSERT INTO lit_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Nes mano kūnas tikrai yra valgis, ir mano kraujas tikrai yra gėrimas. ");
INSERT INTO lit_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Kas valgo mano kūną ir geria mano kraują, pasilieka manyje, ir aš jame. ");
INSERT INTO lit_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Kaip gyvasis Tėvas mane siuntė, ir aš gyvuoju per Tėvą, taip ir tas, kuris mane valgo, gyvuos per mane. ");
INSERT INTO lit_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Šita yra ta duona, kuri nužengė iš dangaus! Nėra taip, kaip jūsų tėvai valgė maną ir mirė: kas valgo šitą duoną, tas gyvens per amžius.“ ");
INSERT INTO lit_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Šiuos dalykus jis kalbėjo sinagogoje, mokydamas Kapernaume. ");
INSERT INTO lit_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Tai išgirdę, daugelis jo mokytinių tada pasakė: „Šis pasakymas yra kietas, kas pajėgia jo klausytis?!“ ");
INSERT INTO lit_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Bet Jėzus, žinodamas savyje, kad jo mokytiniai dėl to murma, jiems tarė: „Ar tai jus piktina? ");
INSERT INTO lit_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Tai kas būtų, jei pamatytumėte Žmogaus Sūnų pakylantį ten, kur jis buvo pirmiau? ");
INSERT INTO lit_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Dvasia yra ta, kuri duoda gyvybę; kūnas neduoda jokios naudos. Žodžiai, kuriuos aš jums kalbu, yra dvasia ir yra gyvybė. ");
INSERT INTO lit_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Bet yra kai kurie iš jūsų, kurie netiki.“ Mat Jėzus iš pradžių žinojo, kurie yra netikintieji, ir kas yra tas, kurį jį išduos. ");
INSERT INTO lit_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ir jis tarė: „Todėl jums sakiau, kad niekas nepajėgia ateiti pas mane, jeigu jam nėra duota mano Tėvo.“ ");
INSERT INTO lit_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Nuo to laiko daugelis jo mokytinių grįžo atgal ir daugiau su juo nebevaikščiojo. ");
INSERT INTO lit_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Tada Jėzus tarė Dvylikai: „Nejaugi ir jūs norite pasišalinti?“ ");
INSERT INTO lit_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simonas Petras jam atsakė: „Viešpatie, pas ką mes eisime?! Amžino gyvenimo žodžius turi tu! ");
INSERT INTO lit_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ir mes tikėjome ir tebetikime, taip pat sužinojome ir tebežinome, kad tu esi tikrasis Kristus, gyvojo Dievo Sūnus.“ ");
INSERT INTO lit_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jėzus jiems atsakė: „Ar ne aš jus, Dvylika, išsirinkau? O vienas iš jūsų yra velnias.“ ");
INSERT INTO lit_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(Jis kalbėjo apie Judą Iskarijotą, Simono sūnų, nes būtent jis tas, kuris jį išduos, būdamas vienas iš Dvylikos.) ");
INSERT INTO lit_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Po šių dalykų Jėzus vaikščiojo po Galilėją, nes nenorėjo vaikščioti po Judėją dėl to, kad žydų vadovai siekė jį nužudyti. ");
INSERT INTO lit_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","O buvo arti žydų Padangčių šventė. ");
INSERT INTO lit_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Dėl to jo broliai jam tarė: „Išeik iš čia ir nueik į Judėją, kad ir tavo mokytiniai pamatytų darbus, kuriuos darai, ");
INSERT INTO lit_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","nes niekas, kuris siekia iškilti viešumon, nieko nedaro slapčiomis. Jei tu darai šiuos dalykus, parodyk save pasauliui.“ ");
INSERT INTO lit_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","(Mat netgi jo broliai juo netikėjo.) ");
INSERT INTO lit_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Tada Jėzus jiems tarė: „Mano laikas dar neatėjo, bet jūsų laikas visuomet yra tinkamas. ");
INSERT INTO lit_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Yra neįmanoma pasauliui jūsų nekęsti, bet jis nekenčia manęs, nes aš liudiju apie jį, kad jo darbai yra blogi. ");
INSERT INTO lit_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Jūs patys eikite aukštyn į šią šventę; aš dar neinu aukštyn į šią šventę, nes mano laikas dar nėra išsipildęs.“ ");
INSERT INTO lit_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Pasakęs jiems tuos dalykus, jis pasiliko Galilėjoje. ");
INSERT INTO lit_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","O kai jo broliai buvo nuėję aukštyn, tada ir jis nuėjo aukštyn į šventę – ne viešai, bet tarsi slapčiomis. ");
INSERT INTO lit_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Tad žydų vadovai ieškojo jo šventėje ir sakė: „Kur tasai yra?“ ");
INSERT INTO lit_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ir miniose buvo daug murmėjimo dėl jo. Iš vienos pusės vieni sakė: „Jis yra geras žmogus“, bet kiti sakė: „Ne; jis minią klaidina.“ ");
INSERT INTO lit_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Vis dėlto nė vienas apie jį viešai nekalbėjo nes bijojo žydų vadovų. ");
INSERT INTO lit_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","O šventei jau įpusėjus Jėzus nuėjo aukštyn į šventyklą ir ėmė mokyti. ");
INSERT INTO lit_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ir žydų vadovai stebėjosi, sakydami: „Iš kur šitas, specialiai nesimokęs, žino rašytinį tekstą?“ ");
INSERT INTO lit_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Atsakydamas Jėzus jiems tarė: „Mano mokslas yra ne mano, bet to, kuris mane siuntė. ");
INSERT INTO lit_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Jei kas turi valią vykdyti jo valią, tas sužinos apie tą mokslą – ar jis yra iš Dievo, ar aš kalbu vadovaudamasis savimi. ");
INSERT INTO lit_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Kas kalba vadovaudamasis savimi, tas ieško savo šlovės. Tačiau, kas ieško šlovės to, kuris jį siuntė, tas yra teisingas, ir jame nėra neteisybės. ");
INSERT INTO lit_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Argi Mozė jums nedavė įstatymo? Tačiau nė vienas iš jūsų nesilaiko įstatymo. Kodėl siekiate mane nužudyti?“ ");
INSERT INTO lit_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Žmonės atsiliepdami pasakė: „Tu velnio apsėstas! Kas gi siekia tave nužudyti?“ ");
INSERT INTO lit_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jėzus atsakydamas jiems tarė: „Padariau tik vieną darbą, ir esate visi nustebę. ");
INSERT INTO lit_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Dėl to Mozė davė jums apipjaustymą – nors jis nėra iš Mozės, bet iš protėvių – ir jūs šabo dieną apipjaustote žmogų. ");
INSERT INTO lit_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Jei žmogus šabo dieną gauna apipjaustymą, kad nebūtų sulaužytas Mozės įstatymas, ar jūs ant manęs pykstate, kad šabo dieną visą žmogų padariau sveiką? ");
INSERT INTO lit_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Nebeteiskite pagal išvaizdą, bet teiskite teisingu nuosprendžiu.“ ");
INSERT INTO lit_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Tada kai kurie jeruzaliečiai tarė: „Ar ne šitas yra tas, kurį jie siekia nužudyti? ");
INSERT INTO lit_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Bet žiūrėkite: jis viešai kalba, ir jie nieko jam nesako. Nejaugi valdytojai tikrai žino, kad šitas yra kaip tik Kristus? ");
INSERT INTO lit_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Tačiau mes žinome, iš kur šis yra. O kai ateis Kristus, niekas nežinos, iš kur jis yra.“ ");
INSERT INTO lit_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Tuomet sušuko Jėzus šventykloje, mokydamas ir sakydamas: „Ar jūs ir mane pažįstate, ir žinote, iš kur aš esu? O aš esu atėjęs ne savimi vadovaudamasis, bet tas, kuris mane siuntė, yra teisingas kurio jūs nepažįstate. ");
INSERT INTO lit_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Bet aš jį pažįstu, nes esu iš jo, ir mane siuntė jis.“ ");
INSERT INTO lit_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Tuomet jie siekė jį suimti, bet nė vienas nepakėlė prieš jį rankos, nes jo valanda dar nebuvo atėjusi. ");
INSERT INTO lit_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","O daugelis iš minios įtikėjo juo ir sakė: „Kai Kristus ateis, nejaugi jis padarys daugiau antgamtinių ženklų už tuos, kuriuos šitas yra padaręs?“ ");
INSERT INTO lit_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Fariziejai išgirdo, kad minia tuos dalykus murmėjo apie jį, tad fariziejai bei aukštieji kunigai pasiuntė patikėtinius jo suimti. ");
INSERT INTO lit_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Tada Jėzus jiems tarė: „Dar trumpą laiką būsiu su jumis, ir tada eisiu pas tą, kuris mane siuntė. ");
INSERT INTO lit_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Jūs manęs ieškosite ir nerasite, ir kur aš esu, ten jūs negalite ateiti.“ ");
INSERT INTO lit_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Tada žydai sakė vieni kitiems: „Kur jis eis, kad mes jo nerasime? Bene jis rengiasi keliauti pas išeivius tarp graikų ir mokys graikus? ");
INSERT INTO lit_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Kas tai per žodis, kurį jis pasakė: „Jūs manęs ieškosite ir nerasite, ir kur aš esu, ten jūs negalite ateiti“?“ ");
INSERT INTO lit_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","O paskutiniąją, didžiąją šventės dieną Jėzus stovėjo ir šaukė, sakydamas: „Jei bet kas trokšta, tegul ateina pas mane ir tegul geria. ");
INSERT INTO lit_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Kas tiki manimi, kaip šventraštis pasakė, gyvojo vandens upės tekės iš jo vidaus.“ ");
INSERT INTO lit_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","(O jis tai pasakė apie Dvasią, kurią turėjo gauti tie, kurie tiki juo. Mat Dvasia dar nebuvo gauta, nes Jėzus dar nebuvo pašlovintas.) ");
INSERT INTO lit_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Todėl daugelis iš minios, išgirdę tą pasakymą, sakė: „Iš tiesų šitas yra tas Pranašas.“ ");
INSERT INTO lit_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Kiti sakė: „Šitas yra Kristus.“ Bet dar kiti sakė: „Ką?! Nejaugi Kristus ateis iš Galilėjos? ");
INSERT INTO lit_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Argi šventraštis nesakė, kad Kristus ateina iš Dovydo sėklos ir iš Betliejaus miestelio, kur yra buvęs Dovydas?“ ");
INSERT INTO lit_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Taigi minioje atsirado susiskaldymas dėl jo. ");
INSERT INTO lit_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ir kai kurie iš jų norėjo jį suimti, bet nė vienas nepakėlė prieš jį rankos. ");
INSERT INTO lit_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Tada patikėtiniai sugrįžo pas aukštuosius kunigus ir fariziejus, o tie tarė jiems: „Kodėl neatvedėte jo?“ ");
INSERT INTO lit_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Patikėtiniai atsakė: „Dar niekada žmogus nėra taip kalbėjęs, kaip šitas žmogus!“ ");
INSERT INTO lit_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Todėl fariziejai jiems atsiliepė: „Ar ir jūs esate suklaidinti? ");
INSERT INTO lit_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Nejaugi kas nors iš valdytojų ar iš fariziejų pasitikėjo juo? ");
INSERT INTO lit_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Bet šita minia, kuri nežino Įstatymo, yra prakeikta!“ ");
INSERT INTO lit_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Į juos prabilo vienas iš jų, Nikodemas, kuris buvo atėjęs pas Jėzų nakčia: ");
INSERT INTO lit_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","„Nejaugi mūsų įstatymas teisia žmogų, jeigu nebūtų pirmiau jo išklausęs ir sužinojęs, ką jis daro?“ ");
INSERT INTO lit_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Jie atsakydami jam tarė: „Nejaugi ir tu iš Galilėjos? Patyrinėk ir pamatyk, kad joks pranašas nėra kilęs iš Galilėjos.“ ");
INSERT INTO lit_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ir kiekvienas nuėjo į savo namus. ");
INSERT INTO lit_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","O Jėzus nuėjo į Alyvų kalną. ");
INSERT INTO lit_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ir auštant jis vėl atėjo į šventyklą, ir visa liaudis atėjo pas jį, o jis atsisėdęs juos mokė. ");
INSERT INTO lit_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ir raštininkai bei fariziejai *atvedė pas jį moterį, pagautą svetimaujant, ir, ją pastatę viduryje ");
INSERT INTO lit_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","jam sako: „Mokytojau, ši moteris buvo sugauta svetimaujant – per patį veiksmą! ");
INSERT INTO lit_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","O Mozė įstatyme mums įsakė, kad tokios turi būti užmuštos užmėtant akmenimis. Taigi, ką sakai tu?“ ");
INSERT INTO lit_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","(O jie tai sakė mėgindami jį, kad turėtų kuo jį apkaltinti.) Bet Jėzus pasilenkęs žemyn pirštu rašinėjo ant žemės. ");
INSERT INTO lit_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Bet kai jie nesiliovė jo klausinėti, jis atsitiesęs jiems tarė: „Kas iš jūsų be nuodėmės, tas pirmas temeta į ją akmenį.“ ");
INSERT INTO lit_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ir jis vėl pasilenkęs rašinėjo ant žemės. ");
INSERT INTO lit_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Bet tie, kurie tai girdėjo, sąžinės įtikinti dėl kaltės, traukėsi vienas po kito, pradedant nuo vyriausiojo iki paskutiniojo; ir Jėzus buvo paliktas vienas, taip pat moteris, stovinti viduryje. ");
INSERT INTO lit_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ir atsitiesęs ir nematęs nė vieno, bet tik moterį, jis tarė jai: „Moterie, kur yra tie tavo kaltintojai? Niekas tavęs nenuteisė?“ ");
INSERT INTO lit_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ji tarė: „Niekas, Viešpatie.“ Jėzus jai tarė: „Nė aš nesiimu tavęs nuteisti. Eik ir daugiau nebenusidėk.“ ");
INSERT INTO lit_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Tada Jėzus vėl jiems kalbėjo, sakydamas: „Aš esu pasaulio Šviesa. Kas seka manimi, niekad nevaikščios tamsoje, bet turės gyvybės Šviesą.“ ");
INSERT INTO lit_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Tad fariziejai jam tarė: „Pats apie save liudiji; tavo liudijimas nėra tiesa.“ ");
INSERT INTO lit_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jėzus atsakydamas jiems tarė: „Net jei aš liudyčiau apie save, mano liudijimas yra tiesa, nes aš žinau, iš kur atėjau ir kur nueinu. O jūs nesuprantate, iš kur ateinu ir kur nueinu. ");
INSERT INTO lit_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Jūs teisiate pagal kūną; aš nesiimu nė vieno žmogaus teisti. ");
INSERT INTO lit_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Bet net jeigu imuosi teisti, mano nuosprendis yra teisingas, nes aš esu ne vienas, bet esu aš ir mane siuntęs Tėvas. ");
INSERT INTO lit_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ir net jūsų įstatyme yra parašyta, jog dviejų žmonių liudijimas yra tiesa. ");
INSERT INTO lit_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Aš esu tas , kuris liudija apie save, ir Tėvas, kuris mane siuntė, liudija apie mane.“ ");
INSERT INTO lit_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Tada jie tarė jam: „Kur yra tavo Tėvas?“ Jėzus atsakė: „Jūs nei manęs nepažįstate, nei mano Tėvo. Jei būtumėte pažinę mane, būtumėte pažinę ir mano Tėvą.“ ");
INSERT INTO lit_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jėzus, mokydamas šventykloje, tuos žodžius pasakė iždinėje. Ir niekas jo nesuėmė, nes jo valanda dar nebuvo atėjusi. ");
INSERT INTO lit_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Tada Jėzus vėl jiems tarė: „Aš einu sau, o jūs ieškosite manęs ir mirsite savo nuodėmingume. Kur aš einu, jūs negalite ateiti.“ ");
INSERT INTO lit_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Tada žydai tarė: „Nejaugi jis nusižudys, kad sako: „Kur aš einu, jūs negalite ateiti“?“ ");
INSERT INTO lit_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ir jis tarė jiems: „Jūs esate iš pažemių, aš esu iš aukštai; jūs esate iš šito pasaulio, aš nesu iš šito pasaulio. ");
INSERT INTO lit_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Todėl pasakiau jums, kad mirsite savo nuodėmėse, nes jeigu netikite, kad aš esu tas, mirsite savo nuodėmėse.“ ");
INSERT INTO lit_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Tada jie tarė jam: „Kas tu esi?“ O Jėzus jiems sako: „Tas pats, kaip sakau jums nuo pradžios. ");
INSERT INTO lit_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Turiu daug ką apie jus sakyti ir smerkti. Vis dėlto tas, kuris mane siuntė, yra tiesakalbis, ir aš kalbu pasauliui būtent tuos dalykus, kuriuos girdėjau iš jo.“ ");
INSERT INTO lit_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Jie nesuprato, kad jis kalbėjo jiems apie Tėvą. ");
INSERT INTO lit_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Tada Jėzus jiems tarė: „Kai būsite aukštyn iškėlę Žmogaus Sūnų, tada žinosite, kad aš esu tas ir kad nieko nedarau vadovaudamasis savimi, bet taip, kaip mano Tėvas mane išmokė – skelbiu būtent tuos dalykus. ");
INSERT INTO lit_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ir tas, kuris mane siuntė, yra su manimi. Tėvas nepaliko manęs vieno, nes aš visada darau tuos dalykus, kurie jam patinka.“ ");
INSERT INTO lit_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jam kalbant tuos žodžius, daugelis įtikėjo jį. ");
INSERT INTO lit_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Tada Jėzus tarė įtikėjusiems jį žydams: „Jeigu jūs pasiliekate mano žodyje, tikrai esate mano mokytiniai; ");
INSERT INTO lit_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","ir jūs pažinsite tiesą, ir tiesa jus išlaisvins.“ ");
INSERT INTO lit_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Jie atsakė jam: „Mes esame Abraomo sėkla ir niekada nevergavome niekam; kaipgi tu sakai: „Būsite išlaisvinti“?!“ ");
INSERT INTO lit_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jėzus jiems atsakė: „Iš tiesų, iš tiesų sakau jums, kad kiekvienas, kuris nuodėmiauja, yra nuodėmės tarnas. ");
INSERT INTO lit_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ir tarnas nepasilieka šeimynoje per amžius, bet Sūnus pasilieka per amžius. ");
INSERT INTO lit_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Tad jei Sūnus jus išlaisvins, jūs tikrai būsite laisvi. ");
INSERT INTO lit_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Žinau, kad esate Abraomo sėkla. Bet siekiate mane nužudyti, nes mano žodis neturi jumyse vietos. ");
INSERT INTO lit_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Aš kalbu tai, ką esu matęs pas savo Tėvą, o jūs darote tai, ką esate matę pas savo tėvą.“ ");
INSERT INTO lit_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Jie atsakydami tarė jam: „Mūsų tėvas yra Abraomas!“ Jėzus jiems sako: „Jei būtumėte Abraomo vaikai, jūs darytumėte Abraomo darbus. ");
INSERT INTO lit_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Bet dabar siekiate nužudyti mane – žmogų, kuris kalbėjo jums tiesą, kurią girdėjau iš Dievo. Šitaip Abraomas nedarė! ");
INSERT INTO lit_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Jūs darote savo tėvo darbus.“ Tada jie tarė jam: „Mes nesame gimę iš paleistuvystės! Turime vieną Tėvą – Dievą.“ ");
INSERT INTO lit_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jėzus jiems tarė: „Jeigu Dievas būtų jūsų Tėvas, jūs mylėtumėte mane dėl to, kad aš išėjau iš Dievo ir čion atėjau ir dėl to, kad esu atėjęs nesivadovaudamas savimi, bet mane siuntė jis. ");
INSERT INTO lit_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Kodėl nesuprantate mano kalbos? Todėl, kad nepajėgiate klausyti mano žodžio. ");
INSERT INTO lit_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Jūs esate iš savo tėvo – velnio, ir norite vykdyti savo tėvo geidulius. Jis nuo pradžios buvo žmogžudys ir neišsistovėjo tiesoje, nes jame nėra tiesos. Kai jis kalba melą, jis kalba tai, kas jam sava, nes jis yra melagis ir melo tėvas. ");
INSERT INTO lit_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","O kadangi aš sakau tiesą, jūs netikite manimi. ");
INSERT INTO lit_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Kuris iš jūsų įtikins mane esant kaltą dėl nuodėmės? O jei sakau tiesą, kodėl jūs netikite manimi? ");
INSERT INTO lit_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Kas yra iš Dievo, tas Dievo žodžių klauso. Jūs dėl to neklausote, kad nesate iš Dievo.“ ");
INSERT INTO lit_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Todėl žydai atsakydami jam tarė: „Argi mes ne teisingai sakome, kad tu esi samarietis ir velnio apsėstas?!“ ");
INSERT INTO lit_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jėzus atsakė: „Aš nesu velnio apsėstas, bet aš gerbiu savo Tėvą ir jūs plėšiate man garbę. ");
INSERT INTO lit_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Be to, aš nesiekiu savo šlovės; yra, kas siekia ir teisia. ");
INSERT INTO lit_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Iš tiesų, iš tiesų sakau jums: Jei kas laikysis mano žodžio, tas jokiu būdu nepatirs mirties per amžius.“ ");
INSERT INTO lit_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Tad žydai jam tarė: „Dabar žinome, kad tu velnio apsėstas. Abraomas mirė ir pranašai, o tu sakai: „Jei kas laikysis mano žodžio, tas jokiu būdu nepatirs mirties per amžius.“ ");
INSERT INTO lit_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Nejaugi tu esi didesnis už mūsų tėvą Abraomą, kuris mirė? Ir pranašai mirė. Kuo daraisi?“ ");
INSERT INTO lit_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jėzus atsakė: „Jeigu aš šlovinu save, mano šlovė yra niekinga. Yra mano Tėvas, kuris mane šlovina, apie kurį jūs sakote, kad jis yra jūsų Dievas, ");
INSERT INTO lit_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","nors nesate jo pažinę. Bet aš jį pažįstu. Ir jeigu sakyčiau, kad jo nepažįstu, būčiau melagis, panašus į jus. Priešingai, aš pažįstu jį ir laikausi jo žodžio. ");
INSERT INTO lit_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Jūsų tėvas Abraomas džiūgavo, kad matysiąs manąją dieną; ir jis ją pamatė ir džiaugėsi.“ ");
INSERT INTO lit_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Tada žydai jam tarė: „Dar tu neturi nė penkiasdešimt metų ir esi matęs Abraomą?!“ ");
INSERT INTO lit_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jėzus jiems tarė: „Iš tiesų, iš tiesų sakau jums: pirmiau negu atsirado Abraomas, Aš esu!“ ");
INSERT INTO lit_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Dėl to jie griebėsi akmenų, kad mestų į jį. Bet Jėzus pasislėpė ir, pereidamas tarp jų, išėjo iš šventyklos ir taip ėjo pro šalį. ");
INSERT INTO lit_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ir eidamas pro šalį Jėzus pamatė žmogų, aklą nuo gimimo. ");
INSERT INTO lit_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ir jo mokytiniai paklausė jo, sakydami: „Mokytojau, kas nusidėjo – šitas žmogus, ar jo tėvai, – kad jis gimė aklas?“ ");
INSERT INTO lit_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jėzus atsakė: „Nei šitas žmogus nenusidėjo, nei jo tėvai, bet jis gimė aklas, kad Dievo darbai būtų apreikšti jame. ");
INSERT INTO lit_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Man reikia dirbti darbus to, kuris mane siuntė, kol yra diena; ateina naktis, kada niekas negali dirbti. ");
INSERT INTO lit_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Kol esu pasaulyje, esu pasaulio Šviesa.“ ");
INSERT INTO lit_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Tai pasakęs, jis spjovė žemėn, ir padarė purvo iš seilių, ir purvu patepė aklojo akis ");
INSERT INTO lit_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ir tarė jam: „Eik, nusiplauk Siloamo tvenkinyje.“ (Išvertus Siloamas reiškia „Pasiųstas“.) Taigi jis nuėjo, nusiplovė ir parėjo regintis. ");
INSERT INTO lit_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Tada kaimynai ir tie, kurie anksčiau matydavo jį esantį aklą, tarė: „Ar jis ne tas, kuris sėdėdavo ir elgetaudavo?“ ");
INSERT INTO lit_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Vieni sakė, kad tai jis, bet kiti, kad jis tik yra panašus į jį; bet jis sakė: „Aš esu tas.“ ");
INSERT INTO lit_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Todėl jie klausinėjo jį: „Kaip tau buvo atvertos akys?“ ");
INSERT INTO lit_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Jis atsakydamas tarė: „Žmogus, vadinamas Jėzumi, padarė purvo ir patepė mano akis, ir tarė man: ‚Eik į Siloamo tvenkinį ir nusiplauk.‘ Ir aš nuėjęs ir nusiplovęs, praregėjau.“ ");
INSERT INTO lit_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Tada jie tarė jam: „Kur jis yra?“ Jis tarė: „Nežinau.“ ");
INSERT INTO lit_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Jie nuvedė pas fariziejus tą, kuris anksčiau buvo aklas. ");
INSERT INTO lit_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","O buvo šabas, kai Jėzus padarė purvo ir atvėrė jo akis. ");
INSERT INTO lit_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Tada ir fariziejai vėl jį klausinėjo, kaip jis praregėjo. O jis tarė jiems: „Jis uždėjo man ant akių purvo, aš nusiploviau ir regiu.“ ");
INSERT INTO lit_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Tada kai kurie fariziejai sakė: „Šitas žmogus nėra iš Dievo, nes jis nesilaiko šabo.“ Kiti sakė: „Kaip gali žmogus, kuris yra nusidėjėlis, daryti tokius antgamtinius ženklus?“ Ir tarp jų atsirado ir liko susiskaldymas. ");
INSERT INTO lit_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Jie vėl sako aklajam: „Kadangi jis tau atvėrė akis, ką tu pats sakai apie jį?“ O jis tarė: „Jis yra pranašas.“ ");
INSERT INTO lit_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Bet žydai netikėjo tai apie jį, kad jis būdavo aklas, bet praregėjo, kol jie pasišaukė praregėjusiojo tėvus. ");
INSERT INTO lit_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ir jie paklausė jų, sakydami: „Ar šitas yra jūsų sūnus, kurį sakote gimus aklą? Tai kaip jis dabar regi?“ ");
INSERT INTO lit_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Jo tėvai jiems atsakydami tarė: „Žinome, kad šitas yra mūsų sūnus ir kad jis gimė aklas. ");
INSERT INTO lit_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Bet kaip jis dabar regi, nežinome, nei kas jam atvėrė akis, nežinome; jis yra pilnametis – jį patį klauskite! Jis pats kalbės už save.“ ");
INSERT INTO lit_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Šituos žodžius kalbėjo jo tėvai, nes jie žydų bijojo. Mat žydai jau buvo susitarę, kad jeigu kas nors jį išpažins esant Kristų, tas bus pašalintas iš sinagogos. ");
INSERT INTO lit_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Todėl jo tėvai pasakė: „Jis yra pilnametis – jį patį klauskite!“ ");
INSERT INTO lit_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Tada jie vėl pašaukė tą žmogų, kuris būdavo aklas, ir jam tarė: „Atiduok šlovę Dievui! Mes žinome, kad tas žmogus yra nusidėjėlis.“ ");
INSERT INTO lit_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Tada jis atsiliepdamas tarė: „Ar jis nusidėjėlis, aš nežinau. Viena žinau, kad nors buvau aklas, dabar regiu.“ ");
INSERT INTO lit_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Tada jie vėl tarė jam: „Ką jis tau padarė? Kaip jis atvėrė tavo akis?“ ");
INSERT INTO lit_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Jis atsakė jiems: „Jau jums pasakiau, bet jūs nesiklausėte. Kodėl vėl norite išklausyti? Nejaugi ir jūs norite tapti jo mokytiniais?“ ");
INSERT INTO lit_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Tada jie išplūdo jį ir tarė: „Tu esi jo mokytinis; bet mes esame Mozės mokytiniai. ");
INSERT INTO lit_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Mes žinome, kad Dievas yra kalbėjęs Mozei, bet iš kur yra šitas, mes nežinome.“ ");
INSERT INTO lit_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Žmogus atsakydamas jiems tarė: „Tuo juk ir reikia stebėtis, kad jūs nežinote, iš kur jis yra, o vis dėlto jis man atvėrė akis! ");
INSERT INTO lit_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Mes gi žinome, kad Dievas neišklauso nusidėjėlių, bet jeigu kas yra Dievo garbintojas ir vykdo jo valią, tą jis išklauso. ");
INSERT INTO lit_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Nuo pasaulio pradžios negirdėta, kad kas būtų atvėręs aklo gimusio akis! ");
INSERT INTO lit_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Jeigu šitas nebūtų iš Dievo, jis nieko nepajėgtų padaryti.“ ");
INSERT INTO lit_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Jie atsakydami jam tarė: „Tu visas gimei nuodėmėse, ir tu mus mokai?!“ Ir jie išmetė jį lauk. ");
INSERT INTO lit_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jėzus išgirdo, kad jie išmetė jį, ir suradęs jį, jam tarė: „Ar tu pasitiki Dievo Sūnumi?“ ");
INSERT INTO lit_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Jis atsakydamas tarė: „Kas jis, Viešpatie, kad juo pasitikėčiau?“ ");
INSERT INTO lit_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ir Jėzus jam tarė: „Tu esi jį matęs, ir jis yra tas, kuris kalba su tavimi.“ ");
INSERT INTO lit_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Tada jis tarė: „Tikiu, Viešpatie!“ – ir pagarbino jį. ");
INSERT INTO lit_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ir Jėzus tarė: „Dėl teismo aš atėjau į šį pasaulį, kad aklieji regėtų ir regintieji apaktų.“ ");
INSERT INTO lit_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ir kai kurie iš fariziejų, kurie buvo su juo, išgirdo tuos žodžius ir jam tarė: „Nejaugi ir mes esame akli?“ ");
INSERT INTO lit_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jėzus jiems tarė: „Jeigu būtumėte akli, neturėtumėte nuodėmės, bet dabar sakote: ‚Mes regime!‘ – Todėl jūsų nuodėmė pasilieka.“ ");
INSERT INTO lit_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","„Iš tiesų, iš tiesų sakau jums: kas įeina į avių gardą ne pro duris, bet įlipa pro kur kitur, tas yra vagis ir plėšikas. ");
INSERT INTO lit_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Bet tas, kuris įeina pro duris, tas yra avių ganytojas. ");
INSERT INTO lit_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Jam durininkas atidaro, ir avys klauso jo balso, ir jis šaukia savąsias avis vardu ir jas išveda. ");
INSERT INTO lit_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ir išsivaręs savąsias avis, jis eina jų priešakyje ir avys paskui jį seka, nes jos pažįsta jo balsą. ");
INSERT INTO lit_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","O paskui svetimą jos niekaip neseks, bet nuo jo bėgs, nes jos nepažįsta svetimųjų balso.“ ");
INSERT INTO lit_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jėzus pasakė jiems šį palyginimą, bet jie nesuprato tų dalykų, kuriuos jis kalbėjo jiems. ");
INSERT INTO lit_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Tada Jėzus vėl jiems tarė: „Iš tiesų, iš tiesų sakau jums: avių durys esu aš. ");
INSERT INTO lit_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Visi, kokie bebuvo, kurie pirma manęs atėjo, yra vagys ir plėšikai, bet avys jų neklausė. ");
INSERT INTO lit_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Aš esu durys; jei kas įeina per mane, tas bus išgelbėtas ir įeis ir išeis ir ras ganyklą. ");
INSERT INTO lit_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Vagis ateina ne kam kitam, kaip tik vogti, žudyti ir naikinti; aš atėjau, kad jie turėtų gyvenimą ir apsčiai jo turėtų. ");
INSERT INTO lit_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Aš esu gerasis ganytojas; gerasis ganytojas guldo už avis savo gyvybę. ");
INSERT INTO lit_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Bet samdinys, kuris ne ganytojas, kuriam avys ne savos, pamatęs ateinantį vilką, palieka avis ir bėga, o griebia jas vilkas ir išsklaido avis. ");
INSERT INTO lit_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Samdinys gi bėga, nes jis yra samdinys ir jam avys nerūpi. ");
INSERT INTO lit_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Aš esu gerasis ganytojas ir pažįstu savo avis, ir esu savųjų pažįstamas. ");
INSERT INTO lit_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Kaip Tėvas mane pažįsta, taip ir aš pažįstu Tėvą; ir už avis guldau savo gyvybę. ");
INSERT INTO lit_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Dar turiu kitų avių, kurios nėra iš šito gardo; jas taip pat man reikia atvesti, ir jos klausys mano balso, ir bus viena kaimenė, vienas ganytojas. ");
INSERT INTO lit_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Mano Tėvas mane myli dėl to, kad aš guldau savo gyvybę, kad vėl ją pasiimčiau. ");
INSERT INTO lit_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Niekas neatima jos iš manęs, bet aš ją guldau vadovaudamasis savimi. Aš turiu įgaliojimą ją guldyti ir turiu įgaliojimą vėl ją pasiimti. Šitą įsakymą esu gavęs iš savo Tėvo.“ ");
INSERT INTO lit_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Todėl dėl šitų žodžių vėl atsirado susiskaldymas tarp žydų. ");
INSERT INTO lit_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ir daugelis iš jų sakė: „Jis velnio apsėstas ir kraustosi iš proto! Kam jo klausote?“ ");
INSERT INTO lit_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Kiti sakė: „Šitie žodžiai nėra velnio apsėsto žmogaus žodžiai. Nejaugi velnias gali atverti aklojo akis?!“ ");
INSERT INTO lit_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ir Jeruzalėje įvyko Pašventinimo šventė, ir buvo žiema. ");
INSERT INTO lit_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ir Jėzus vaikščiojo šventykloje, po Saliamono stoginę. ");
INSERT INTO lit_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Tai žydai jį apstojo ratu ir jam tarė: „Kaip ilgai laikysi mus abejonėse? Jei tu esi Kristus, pasakyk mums atvirai!“ ");
INSERT INTO lit_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jėzus jiems atsakė: „Aš jums sakiau, bet jūs netikite; darbai, kuriuos aš darau savo Tėvo vardu, tie liudija apie mane. ");
INSERT INTO lit_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Bet jūs netikite, nes nesate iš manųjų avių, kaip jums sakiau. ");
INSERT INTO lit_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Manosios avys klauso mano balso; pažįstu jas aš pats, ir jos seka paskui mane; ");
INSERT INTO lit_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","amžiną gyvenimą joms duodu aš pats, ir jos niekada nepražus per amžius, ir niekas jų neišplėš iš mano rankos. ");
INSERT INTO lit_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Mano Tėvas, kuris man jas davė, yra didesnis už visus, ir niekas negali jų išplėšti iš mano Tėvo rankos. ");
INSERT INTO lit_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Aš ir mano Tėvas esame viena.“ ");
INSERT INTO lit_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Todėl žydai vėl stvėrėsi akmenų, kad jį užmėtytų akmenimis. ");
INSERT INTO lit_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jėzus jiems atsiliepė: „Jums parodžiau daug gerų darbų iš savo Tėvo. Už kurį iš šitų darbų siekiate mane užmėtyti akmenimis?“ ");
INSERT INTO lit_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Žydai jam atsakė, sakydami: „Ne už gerą darbą siekiame tave užmėtyti akmenimis, bet už piktžodžiavimą, būtent už tai, kad tu, būdamas žmogus, daraisi Dievu.“ ");
INSERT INTO lit_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jėzus jiems atsakė: „Argi jūsų įstatyme nėra parašyta: „Aš tariau: esate dievai“? ");
INSERT INTO lit_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Jeigu jis pavadino dievais tuos, kuriems atėjo Dievo žodis (ir šventraščio neįmanoma panaikinti), ");
INSERT INTO lit_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","tai ar jūs galite sakyti tam, kurį Tėvas pašventino ir pasiuntė į pasaulį: „Tu piktžodžiauji“, todėl, kad pasakiau: „Aš esu Dievo Sūnus“? ");
INSERT INTO lit_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Jeigu nedarau savo Tėvo darbų, netikėkite manimi. ");
INSERT INTO lit_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Bet jei darau, tai, nors ir netikite manimi, tikėkite darbais, kad žinotumėte ir tikėtumėte, kad Tėvas yra manyje, ir aš jame.“ ");
INSERT INTO lit_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Jie dėl to vėl siekė jį suimti, bet jis ištrūko jiems iš rankų ");
INSERT INTO lit_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","ir vėl nuėjo už Jordano į tą vietą, kur anksčiau Jonas krikštydavo, ir ten apsistojo. ");
INSERT INTO lit_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ir daugelis atėjo pas jį ir sakydavo: „Nors Jonas nepadarė jokio antgamtinio ženklo, vis dėlto visa tai, ką Jonas kalbėjo apie šitą žmogų, yra tiesa.“ ");
INSERT INTO lit_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ir daugelis tenai juo įtikėjo. ");
INSERT INTO lit_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","O buvo tam tikras sergantis žmogus, Lozorius iš Betanijos, iš Marijos ir jos sesers Mortos kaimo. ");
INSERT INTO lit_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(O Marija buvo ta, kuri patepė Viešpatį tepamaisiais kvepalais ir nušluostė jo kojas savo plaukais; jos brolis Lozorius sirgo.) ");
INSERT INTO lit_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Todėl jo seserys pasiuntė pas jį, sakydamos: „Viešpatie, štai tas, kurį tu myli, serga!“ ");
INSERT INTO lit_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Bet tai išgirdęs, Jėzus tarė: „Šita liga ne mirčiai, bet Dievo šlovei, kad Dievo Sūnus per ją būtų pašlovintas. ");
INSERT INTO lit_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","(Vis dėlto Jėzus mylėjo Mortą, jos seserį ir Lozorių.) ");
INSERT INTO lit_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Taigi, kai jis išgirdo, kad tas serga, jis tąsyk net dvi dienas pasiliko toje vietoje, kur buvo. ");
INSERT INTO lit_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Vėliau, po to jis sako mokytiniams: „Eikime vėl į Judėją.“ ");
INSERT INTO lit_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Jo mokytiniai jam sako: „Mokytojau, žydai ką tik kėsinosi tave užmušti akmenimis, o tu vėl ten vyksti? ");
INSERT INTO lit_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jėzus atsakė: „Argi diena neturi dvylika valandų?! Jeigu kas vaikščioja dieną, nesuklumpa, nes mato šio pasaulio šviesą. ");
INSERT INTO lit_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Bet jeigu kas naktį vaikščioja, suklumpa, nes jame nėra šviesos.“ ");
INSERT INTO lit_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Jis tai pasakė, o paskui jis sako jiems: „Mūsų draugas Lozorius yra užmigęs, bet vykstu, kad jį pažadinčiau iš miego.“ ");
INSERT INTO lit_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Tad jo mokytiniai tarė: „Viešpatie, jeigu jis užmigęs, pasveiks.“ ");
INSERT INTO lit_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","(Tačiau Jėzus buvo kalbėjęs apie jo mirtį, bet jie manė, kad jis kalbėjęs apie poilsio miegą.) ");
INSERT INTO lit_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Tada Jėzus atvirai jiems pasakė: „Lozorius mirė, ");
INSERT INTO lit_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","bet aš džiaugiuosi, kad ten nebuvau, – dėl jūsų, kad tikėtumėte. Vis dėlto eikime pas jį.“ ");
INSERT INTO lit_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tada Tomas, vadinamas Didymu, tarė savo bendramokytiniams: „Eikime ir mes, kad mirtume su juo.“ ");
INSERT INTO lit_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Atėjęs Jėzus rado jį jau keturias dienas buvusį kape. ");
INSERT INTO lit_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","O Betanija buvo arti Jeruzalės – maždaug penkiolikos stadijų atstu, – ");
INSERT INTO lit_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ir daug Judėjos gyventojų atėjo pas tas moteris, tai yra prie Mortos ir Marijos, kad jas paguostų dėl jų brolio. ");
INSERT INTO lit_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Taigi, kai Morta išgirdo, kad Jėzus ateinąs, ji išėjo jo pasitikti, bet Marija liko sėdėti namie. ");
INSERT INTO lit_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Tada Morta prabilo į Jėzų: „Viešpatie, jeigu būtum čia buvęs, mano brolis nebūtų miręs. ");
INSERT INTO lit_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Bet žinau, kad netgi dabar, ko tik prašysi Dievą, Dievas tau duos.“ ");
INSERT INTO lit_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jėzus jai sako: „Tavo brolis prisikels!“ ");
INSERT INTO lit_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Morta jam sako: „Žinau, kad jis prisikels prisikėlime, paskutiniąją dieną.“ ");
INSERT INTO lit_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jėzus jai tarė: „Aš esu prisikėlimas ir gyvenimas. Kas tiki manimi, net jei numirtų, gyvuos, ");
INSERT INTO lit_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ir kiekvienas, kuris gyvuoja ir tiki manimi, jokiu atveju nemirs per amžius. Ar tai tiki?“ ");
INSERT INTO lit_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ji sako jam: „Taip, Viešpatie, aš tikiu, kad tu esi Kristus, Dievo Sūnus, ateinantysis į pasaulį.“ ");
INSERT INTO lit_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ir tai pasakiusi ji nuėjo ir slapčiomis pasišaukė savo seserį Mariją, sakydama: „Mokytojas yra atėjęs ir tave šaukia.“ ");
INSERT INTO lit_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Kai ji tai išgirdo, ji skubiai pakilo ir nuėjo pas jį. ");
INSERT INTO lit_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","O Jėzus dar nebuvo atėjęs į kaimą, bet buvo toje vietoje, kur Morta jį pasitiko. ");
INSERT INTO lit_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Tada žydai, kurie buvo su ja namuose ir ją guodė, pamatę, kad Marija skubiai pakilo ir išėjo, sekė paskui ją, sakydami, kad ji eina prie kapo ten verkti. ");
INSERT INTO lit_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Tada, kai Marija atėjo, kur buvo Jėzus, jį pamačiusi, ji puolė jam į kojas, sakydama jam: „Viešpatie, jeigu būtum čia buvęs, mano brolis nebūtų miręs!“ ");
INSERT INTO lit_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Taigi, kai Jėzus pamatė ją verkiančią ir su ja atėjusius žydus verkiančius taip pat, jis dejavo dvasioje ir pats save jaudino ");
INSERT INTO lit_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ir tarė: „Kur jį paguldėte?“ Jie tarė jam: „Viešpatie, ateik ir pamatyk.“ ");
INSERT INTO lit_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jėzus pravirko. ");
INSERT INTO lit_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Tada žydai tarė: „Štai kaip jis jį mylėjo!“ ");
INSERT INTO lit_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","O kai kurie iš jų tarė: „Ar tas, kuris atvėrė aklojo akis, negalėjo padaryti, kad ir šis nemirtų?“ ");
INSERT INTO lit_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Todėl Jėzus vėl dejuodamas savyje ateina prie kapo. Tai buvo ola, ir prie jos buvo užristas akmuo. ");
INSERT INTO lit_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jėzus sako: „Pašalinkite akmenį.“ Μirusiojo sesuo Morta jam sako: „Viešpatie, jis jau dvokia, nes jau keturios dienos, kaip jis yra miręs.“ ");
INSERT INTO lit_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jėzus jai sako: „Ar nesakiau tau, kad jeigu tikėsi, matysi Dievo šlovę?“ ");
INSERT INTO lit_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Tada jie pašalino akmenį, kur buvo paguldytas numirėlis. Ir Jėzus pakėlė akis aukštyn ir tarė: „Tėve, dėkoju tau, kad mane išklausei. ");
INSERT INTO lit_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ir aš žinojau, kad tu visada manęs išklausai; bet dėl šalia stovinčios minios tai pasakiau, kad jie tikėtų, jog tu esi mane siuntęs.“ ");
INSERT INTO lit_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ir tuos dalykus pasakęs jis garsiu balsu sušuko: „Lozoriau, išeik!“ ");
INSERT INTO lit_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ir išėjo tas, kuris buvo miręs, būdamas kojomis ir rankomis apvyniotas laidojimo aprišalais, o jo veidas buvo apvyniotas skepeta. Jėzus jiems sako: „Atraišiokite jį ir leiskite jam eiti.“ ");
INSERT INTO lit_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Tad daugelis iš žydų, kurie atėjo pas Mariją ir matė, ką Jėzus padarė, įtikėjo juo. ");
INSERT INTO lit_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Bet kai kurie iš jų nuėjo pas fariziejus ir papasakojo jiems, ką Jėzus padarė. ");
INSERT INTO lit_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Tad aukštieji kunigai ir fariziejai surinko tarybą ir tarė: „Ką darysime? Nes šitas žmogus daro daug antgamtinių ženklų. ");
INSERT INTO lit_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Jei šitaip jį paliksime, visi įtikės juo, ir romėnai ateis ir atims tą mūsų vietą bei mūsų tautą.“ ");
INSERT INTO lit_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","O vienas iš jų – Kajafas, būdamas vyriausiasis kunigas tais metais, jiems tarė: „Jūs visiškai nieko nei išmanote, ");
INSERT INTO lit_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","nei susivokiate, kad mums yra naudinga, jog vienas žmogus mirtų už liaudį, bet nepražūtų visa tauta.“ ");
INSERT INTO lit_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","(O tai jis kalbėjo nesivadovaudamas savimi, bet, būdamas vyriausiasis kunigas tais metais, jis išpranašavo, kad Jėzus mirs už tą tautą, ");
INSERT INTO lit_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ir ne tik už tą tautą, bet kad jis taip pat surinktų į viena Dievo išsklaidytuosius vaikus.) ");
INSERT INTO lit_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Tada, nuo tos dienos, jie drauge sutarė, kad jį nužudytų. ");
INSERT INTO lit_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Todėl Jėzus daugiau nebevaikščiojo viešai tarp Judėjos gyventojų, bet iš ten nuėjo į kraštą netoli dykumos, į miestą, vadinamą Efraimu, ir ten išbuvo su savo mokytiniais. ");
INSERT INTO lit_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Žydų Aplenkimo šventė buvo arti, ir daug žmonių iš viso krašto prieš Aplenkimo šventę traukė aukštyn į Jeruzalę apsivalyti. ");
INSERT INTO lit_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Tad jie ieškojo Jėzaus ir stoviniuodami šventykloje kalbėjosi vieni su kitais: „Kaip jūs manote? Jis neateis į šventę, ar ne?“ ");
INSERT INTO lit_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Mat ir aukštieji kunigai ir fariziejai išleido įsakymą, kad, jei kuris žinotų, kur jis yra, praneštų, kad jie galėtų jį suimti. ");
INSERT INTO lit_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Tada, šešios dienos prieš Aplenkimo šventę, Jėzus atėjo į Betaniją, kur buvo numirėlis Lozorius, kurį jis prikėlė iš numirusiųjų. ");
INSERT INTO lit_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Taigi, ten jie iškėlė jam vaišes ir Morta patarnavo, o Lozorius buvo vienas iš atsilošiančiųjų su juo prie stalo. ");
INSERT INTO lit_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Tada Marija, paėmusi svarą labai brangių tepamųjų kvepalų iš tikro nardo, patepė Jėzui kojas. Ji ir nušluostė jo kojas savo plaukais. Ir namai prisipildė tepamųjų kvepalų kvapo. ");
INSERT INTO lit_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Tada vienas iš jo mokytinių, Simono sūnus Judas Iskarijotas, kuris jį išduos, *pasakė: ");
INSERT INTO lit_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","„Kodėl šie tepamieji kvepalai nebuvo parduoti už tris šimtus denarų ir pinigai neatiduoti vargšams?“ ");
INSERT INTO lit_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Jis tai sakė ne todėl, kad rūpinosi vargšais, bet todėl, kad buvo vagis ir turėjo kasą, ir nešiojosi tai, kas buvo į ją įdedama. ");
INSERT INTO lit_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Tad Jėzus tarė: „Palik ją ramybėje, ji juos buvo laikiusi mano laidojimo dienai. ");
INSERT INTO lit_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Nes vargšų visada turite šalia savęs, bet mane ne visada turėsite.“ ");
INSERT INTO lit_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Taigi didelė žydų minia žinojo, kad jis ten buvo, ir jie atėjo ne tik dėl Jėzaus, bet kad pamatytų ir Lozorių, kurį jis prikėlė iš numirusiųjų. ");
INSERT INTO lit_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Bet aukštieji kunigai susitarė, kad ir Lozorių nužudytų, ");
INSERT INTO lit_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","nes daugybė žydų per jį atsitraukė nuo jų ir įtikėjo Jėzumi. ");
INSERT INTO lit_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Rytojaus dieną didelė minia, kuri atvyko į šventę, išgirdusi, kad Jėzus ateinąs į Jeruzalę, ");
INSERT INTO lit_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","pasiėmė palmių šakų ir išėjo jo pasitikti ir šaukė: „Osana! Palaimintas tas, kuris ateina Viešpaties vardu – Izraelio Karalius!“ ");
INSERT INTO lit_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","O Jėzus, radęs jauną asilą, užsėdo ant jo, kaip yra parašyta: ");
INSERT INTO lit_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Nebijok, Siono dukterie! Štai tavo Karalius ateina, sėdintis ant asilės jauniklio. ");
INSERT INTO lit_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","O iš pradžių jo mokytiniai šitų dalykų nesuprato, bet, kai Jėzus buvo pašlovintas, tada jie prisiminė, kad šie dalykai buvo apie jį parašyta, ir kad jie buvo jam tai padarę. ");
INSERT INTO lit_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Taigi vis dar liudijo apie tai minia, buvusi su juo, kai jis pašaukė Lozorių iš kapo ir prikėlė jį iš numirusiųjų. ");
INSERT INTO lit_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Žmonių būrys todėl ir išėjo jį pasitikti, nes buvo girdėjęs jį padarius tą antgamtinį ženklą. ");
INSERT INTO lit_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Todėl fariziejai kalbėjo vieni kitiems: „Matote, kaip nieko negalite padaryti! Štai pasaulis nuėjo paskui jį!“ ");
INSERT INTO lit_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ir tarp atėjusiųjų aukštyn garbinti per šventę buvo tam tikri graikai. ");
INSERT INTO lit_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Taigi tie priėjo prie Pilypo, kilusio iš Galilėjos Betsaidos, ir prašė jo, sakydami: „Gerbiamasis, norėtume pamatyti Jėzų.“ ");
INSERT INTO lit_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Pilypas *nuėjo ir *pasakė Andriejui, o Andriejus ir Pilypas dar Jėzui *pasakė. ");
INSERT INTO lit_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","O Jėzus jiems atsakė, sakydamas: „Yra atėjusi valanda, kad būtų pašlovintas Žmogaus Sūnus. ");
INSERT INTO lit_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Iš tiesų, iš tiesų sakau jums: jei kviečio grūdas įkritęs į žemę nemiršta, jis lieka vienas, bet jeigu numiršta, jis duoda daug vaisių. ");
INSERT INTO lit_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Kas myli savo gyvybę, ją pražudys, tačiau kas nekenčia savo gyvybės šiame pasaulyje, išsaugos ją amžinam gyvenimui. ");
INSERT INTO lit_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Jei kas man tarnauja, jis turi sekti paskui mane, ir kur aš esu, ten bus ir mano tarnas; jei kas man tarnauja, tą gerbs mano Tėvas. ");
INSERT INTO lit_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Dabar mano siela sukrėsta. Ir ką aš sakysiu: ‚Tėve, išgelbėk mane nuo šios valandos!‘? Bet dėl šios priežasties aš atėjau į šią valandą. ");
INSERT INTO lit_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tėve, pašlovink savo vardą.“ Tada iš dangaus ataidėjo balsas: „Aš jį pašlovinau ir vėl pašlovinsiu.“ ");
INSERT INTO lit_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Todėl aplink stovinti ir tai girdėjusi minia sakė griaustinį sugriaudus. Kiti sakė: „Angelas jam kalbėjo.“ ");
INSERT INTO lit_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jėzus atsakydamas tarė: „Ne dėl manęs pasigirdo tas balsas, bet dėl jūsų. ");
INSERT INTO lit_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Dabar yra šio pasaulio teismas, dabar šio pasaulio kunigaikštis bus išmestas lauk. ");
INSERT INTO lit_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","O aš, kai būsiu aukštyn iškeltas nuo žemės, visus trauksiu pas save.“ ");
INSERT INTO lit_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jis tai pasakė nurodydamas, kokia mirtimi jam numatyta mirti. ");
INSERT INTO lit_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Žmonės jam atsakė: „Mes girdėjome iš Įstatymo, kad Kristus pasilieka per amžius. Tai kaip tu gali sakyti, kad Žmogaus Sūnus turi būti iškeltas aukštyn? Kas yra tas Žmogaus Sūnus?“ ");
INSERT INTO lit_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Tada Jėzus jiems tarė: „Dar trumpą laiką Šviesa yra su jumis. Vaikščiokite, kol turite Šviesą, kad ant jūsų neužeitų tamsa. O tas, kuris vaikšto tamsoje, nežino, kur eina. ");
INSERT INTO lit_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Kol turite Šviesą, pasitikėkite Šviesa, kad būtumėte Šviesos vaikai. Tai pasakęs Jėzus išėjo ir pasislėpė nuo jų. ");
INSERT INTO lit_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Bet nors jis buvo padaręs tiek daug antgamtinių ženklų jų akivaizdoje, tačiau jie netikėjo juo, ");
INSERT INTO lit_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","kad išsipildytų pranašo Izaijo pasakymas, kurį jis kalbėjo: VIEŠPATIE, kas patikėjo girdima mūsų žinia? Ir kuriam buvo apreikšta Viešpaties ranka? ");
INSERT INTO lit_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Jie negalėjo tikėti, nes Izaijas vėl pasakė: ");
INSERT INTO lit_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Jis yra apakinęs jų akis ir užkietinęs jų širdį, kad nematytų akimis nei suvoktų širdimi ir neatsiverstų, ir aš jų nepagydyčiau. ");
INSERT INTO lit_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Tuos dalykus pasakė Izaijas, kai pamatė jo šlovę ir kalbėjo apie jį. ");
INSERT INTO lit_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Vis dėlto net iš vyresnybės daugelis įtikėjo jį, bet dėl fariziejų jie neišpažino jo, kad nebūtų pašalinti iš sinagogos, ");
INSERT INTO lit_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","nes žmonių šlovę jie mėgo labiau už Dievo šlovę. ");
INSERT INTO lit_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","O Jėzus šaukdamas tarė: „Kas tiki manimi, tas tiki ne manimi, bet tuo, kuris mane siuntė. ");
INSERT INTO lit_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Be to, kas mato mane, mato tą, kuris mane siuntė. ");
INSERT INTO lit_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Aš, Šviesa, esu atėjęs į pasaulį, kad kiekvienas, kuris manimi tiki, nepasiliktų tamsoje. ");
INSERT INTO lit_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ir jei kas klausosi mano žodžių ir netiki, aš nesiimu jo teisti, nes atėjau ne tam, kad teisčiau pasaulį, bet kad išgelbėčiau pasaulį. ");
INSERT INTO lit_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Kas mane atmeta ir mano žodžių nepriima, turi tą, kuris jį teisia; tas žodis, kurį kalbėjau, teis jį paskutiniąją dieną. ");
INSERT INTO lit_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Nes aš nekalbėjau vadovaudamasis savimi, bet Tėvas, kuris mane siuntė, pats davė man įsakymą, ką turiu sakyti ir ką turiu kalbėti. ");
INSERT INTO lit_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ir žinau, kad jo įsakymas yra amžinas gyvenimas. Todėl ką aš kalbu, kalbu taip, kaip Tėvas yra man pasakęs.“ ");
INSERT INTO lit_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","O prieš Aplenkimo šventę, Jėzus, žinodamas, kad buvo atėjusi jo valanda, jog jis turi išeiti iš šio pasaulio pas Tėvą, mylėjęs savuosius, kurie buvo pasaulyje, jis mylėjo juos iki galo. ");
INSERT INTO lit_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ir pasibaigus vakarienei, velniui jau įdėjus į Simono sūnaus Judo Iskarijoto širdį jį išduoti, ");
INSERT INTO lit_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jėzus, žinodamas, kad Tėvas visa atidavęs į jo rankas ir kad jis išėjo nuo Dievo ir eina pas Dievą, ");
INSERT INTO lit_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","*kėlėsi nuo vakarienės stalo ir *padėjo į šoną savo viršutinius drabužius ir, paėmęs rankšluostį, juo apsijuosė. ");
INSERT INTO lit_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Po to jis *įpylė vandens į praustuvę ir ėmė mazgoti mokytiniams kojas bei šluostyti jas rankšluosčiu, kuriuo buvo apsijuosęs. ");
INSERT INTO lit_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Tada jis *priėjo prie Simono Petro ir šis jam *tarė: „Viešpatie, nejaugi tu mazgosi man kojas?!“ ");
INSERT INTO lit_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jėzus atsakydamas tarė jam: „Tu dabar nesupranti, ką aš darau, bet po šių dalykų suvoksi.“ ");
INSERT INTO lit_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petras jam *tarė: „Nieku būdu nemazgosi man kojų per amžius!“ Jėzus jam atsakė: „Jeigu tavęs nenumazgosiu, vadinasi, tu su manimi neturi dalies.“ ");
INSERT INTO lit_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simonas Petras jam *tarė: „Viešpatie, ne tik mano kojas, bet ir rankas ir galvą!“ ");
INSERT INTO lit_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jėzus jam *tarė: „Kas yra nuplautas, tam nereikia nieko kito, kaip tik kojas nusimazgoti, nes yra visas švarus – ir jūs esate švarūs, bet ne visi.“ ");
INSERT INTO lit_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Nes jis žinojo, kas jį išduosiąs, todėl pasakė: „Ne visi esate švarūs.“ ");
INSERT INTO lit_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Taigi, kai jau buvo numazgojęs jiems kojas ir pasiėmęs savo drabužius ir vėl atsilošęs prie stalo, jis tarė jiems: „Ar suprantate, ką jums padariau? ");
INSERT INTO lit_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Jūs mane vadinate Mokytoju ir Viešpačiu, ir gerai sakote, nes aš toks ir esu. ");
INSERT INTO lit_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Jei tad aš – Viešpats ir Mokytojas – numazgojau jums kojas, tai ir jūs privalote vieni kitiems kojas mazgoti. ");
INSERT INTO lit_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nes esu jums davęs pavyzdį, kad ir jūs taip darytumėte, kaip aš jums dariau. ");
INSERT INTO lit_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Iš tiesų, iš tiesų sakau jums: nei tarnas nėra didesnis už savo šeimininką, nei pasiųstasis didesnis už savo siuntėją. ");
INSERT INTO lit_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Jei žinote šiuos dalykus, – esate palaiminti, jei juos darote. ");
INSERT INTO lit_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ne apie jus visus kalbu. Aš žinau, kuriuos išsirinkau, bet taip yra, kad išsipildytų šventraštis: Tas, kuris su manimi valgo duoną, pakėlė prieš mane savo kulną. ");
INSERT INTO lit_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Sakau jums pradedant dabar, prieš įvykstant, kad įvykus tikėtumėte, jog ΑŠ ESU tas. ");
INSERT INTO lit_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Iš tiesų, iš tiesų sakau jums: kas priima bet kurį asmenį, kurį siunčiu, tas priima mane, o kas priima mane, tas priima tą, kuris mane siuntė.“ ");
INSERT INTO lit_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Pasakęs tuos dalykus, Jėzus buvo sukrėstas dvasioje ir liudijo tardamas: „Iš tiesų, iš tiesų sakau jums, kad mane išduos vienas iš jūsų!“ ");
INSERT INTO lit_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Todėl mokytiniai ėmė žvalgytis vieni į kitus nesuvokdami, apie kurį jis kalbąs. ");
INSERT INTO lit_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","O vienas jo mokytinių, kurį Jėzus mylėjo, buvo atsilošęs valgyti prie Jėzaus užančio. ");
INSERT INTO lit_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Todėl Simonas Petras *parodė jam gestą, kad pasiklaustų, kas būtų tas, apie kurį jis kalba. ");
INSERT INTO lit_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Tad pasilinkęs prie Jėzaus krūtinės, šis *pasakė jam: „Kas jis, Viešpatie?“ ");
INSERT INTO lit_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jėzus *atsakė: „Tai tas, kuriam pamirkęs paduosiu gabaliuką duonos.“ Ir įmirkęs gabaliuką *padavė jį Judui Iskarijotui, Simono sūnui. ");
INSERT INTO lit_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ir po gabaliuko Šėtonas įėjo į jį. Tada Jėzus jam tarė: „Ką darai, daryk greičiau!“ ");
INSERT INTO lit_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Tačiau, nė vienas iš atsilošusių prie stalo nesuprato, kodėl jis taip pasakė jam. ");
INSERT INTO lit_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Nes kai kurie manė, kadangi Judas turėjo kasą, kad Jėzus jam *sakęs: „Nupirk, ko mums reikia šventei“, arba kad jis ką nors duotų vargšams. ");
INSERT INTO lit_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Tad anas, priėmęs duonos gabaliuką, tuojau išėjo; o buvo naktis. ");
INSERT INTO lit_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Taigi, kai tas buvo išėjęs, Jėzus *tarė: „Žmogaus Sūnus jau dabar pašlovintas, ir Dievas jau pašlovintas per jį. ");
INSERT INTO lit_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Jei Dievas jau pašlovintas per jį, tai ir Dievas jį pašlovins per save – ir tuojau jį pašlovins. ");
INSERT INTO lit_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Vaikeliai, dar trumpą laiką būsiu su jumis. Jūs manęs ieškosite; ir kaip sakiau žydams: ‚kur aš einu, jūs negalite ateiti‘, – taip dabar ir jums sakau. ");
INSERT INTO lit_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Jums duodu naują įsakymą, kad jūs vieni kitus mylėtumėte – kaip aš jus mylėjau, kad ir jūs taip mylėtumėte vienas kitą. ");
INSERT INTO lit_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Iš to visi pažins, kad esate mano mokytiniai, jei mylėsite vieni kitus.“ ");
INSERT INTO lit_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simonas Petras jam *tarė: „Viešpatie, kur eini?“ Jėzus jam atsakė: „Kur einu, tu dabar negali sekti paskui mane, bet vėliau seksi paskui mane.“ ");
INSERT INTO lit_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petras jam *tarė: „Viešpatie, kodėl negaliu sekti paskui tave dabar? Aš savo gyvybę guldysiu už tave!“ ");
INSERT INTO lit_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jėzus jam atsakė: „Ar savo gyvybę guldysi už mane? Iš tiesų, iš tiesų sakau tau: jokiu būdu gaidys nepragys, iki tu triskart manęs išsižadėsi!“ ");
INSERT INTO lit_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","„Tegul nebūna sukrėstos jūsų širdys: tikite Dievu, tikėkite ir manimi. ");
INSERT INTO lit_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Mano Tėvo namuose yra daug buveinių; jei taip nebūtų, būčiau jums pasakęs. Einu jums vietos paruošti. ");
INSERT INTO lit_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ir jeigu nueinu ir paruošiu jums vietą, vėl ateisiu ir pasiimsiu jus pas save, kad jūs būtumėte ten, kur esu aš. ");
INSERT INTO lit_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ir žinote, kur einu, ir žinote kelią.“ ");
INSERT INTO lit_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomas jam *tarė: „Viešpatie, nežinome, kur tu eini. Ir kaip galime žinoti kelią?“ ");
INSERT INTO lit_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jėzus jam sako: „Aš esu kelias, tiesa ir gyvenimas; niekas neateina pas Tėvą kitaip, kaip tik per mane. ");
INSERT INTO lit_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Jei būtumėte pažinę mane, tai būtumėte pažinę ir mano Tėvą. Ir nuo šiol jį pažįstate ir jį esate matę.“ ");
INSERT INTO lit_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Pilypas jam sako: „Viešpatie, parodyk mums Tėvą, ir to mums pakaks.“ ");
INSERT INTO lit_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jėzus jam sako: „Esu su jumis jau tokį ilgą laiką, ir tu, Pilypai, dar nesi manęs pažinęs?! Kas mane yra matęs, yra matęs Tėvą! Tad kaipgi tu sakai: ‚Parodyk mums Tėvą‘? ");
INSERT INTO lit_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Nejau tu netiki, kad aš esu Tėve ir Tėvas yra manyje?! Žodžius, kuriuos aš jums kalbu, aš nekalbu vadovaudamasis savimi, bet Tėvas, kuris išlieka manyje, jis daro savo darbus. ");
INSERT INTO lit_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Tikėkite manimi, kad aš esu Tėve ir Tėvas manyje. Bet jei netikite, tai tikėkite manimi dėl pačių darbų. ");
INSERT INTO lit_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Iš tiesų, iš tiesų sakau jums: kas tiki manimi, tas irgi darys darbus, kuriuos aš darau, ir dar už juos didesnių darys, nes aš einu pas savo Tėvą. ");
INSERT INTO lit_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ir ko tik prašysite mano vardu, tai padarysiu, kad Tėvas būtų pašlovintas per Sūnų. ");
INSERT INTO lit_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Jei ko prašysite mano vardu, tai padarysiu aš. ");
INSERT INTO lit_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Jei mane mylite, laikykitės mano įsakymų. ");
INSERT INTO lit_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ir melsiu Tėvą aš pats, ir jis duos jums kitą Paguodžiantį Užtarėją, kad pasiliktų su jumis per amžius, ");
INSERT INTO lit_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","tai yra, Tiesos Dvasią, kurios pasaulis neįstengia priimti, nes nemato jos ir nepažįsta jos. Bet jūs pažįstate ją, nes ji pasilieka pas jus ir bus jumyse. ");
INSERT INTO lit_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Nepaliksiu jūsų netekusiais artimo asmens – ateisiu pas jus. ");
INSERT INTO lit_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Dar trumpą laiką, ir pasaulis manęs *nebematys. Tačiau jūs mane matote. Kadangi aš gyvenu, jūs irgi gyvensite. ");
INSERT INTO lit_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Tą dieną jūs žinosite, kad aš esu savo Tėve, ir jūs manyje, ir aš jumyse. ");
INSERT INTO lit_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Kas turi mano įsakymus ir jų laikosi, jis yra tas, kuris mane myli. O kas mane myli,tą mylės mano Tėvas, ir aš jį mylėsiu ir jam apsireikšiu. ");
INSERT INTO lit_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judas – ne Iskariotas – jam *tarė: „Viešpatie, kas įvyko, kad tu rengiesi apsireikšti mums, o ne pasauliui?“ ");
INSERT INTO lit_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jėzus atsakydamas tarė jam: „Jei kas mane myli, jis laikysis mano žodžių, ir mano Tėvas jį mylės, ir mes pas jį ateisime ir pasidarysime savo buveinę pas jį. ");
INSERT INTO lit_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Kas manęs nemyli, mano žodžių nesilaiko. O žodis, kurį girdite, yra ne mano, bet Tėvo, kuris yra mane siuntęs. ");
INSERT INTO lit_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Tuos dalykus esu jums pasakęs dar būdamas su jumis. ");
INSERT INTO lit_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Bet Paguodžiantis Užtarėjas, – Šventoji Dvasia, kurį Tėvas atsiųs mano vardu, – jis išmokys jus visko ir viską jums primins, ką aš esu jums pasakęs. ");
INSERT INTO lit_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Aš jums palieku ramybę, duodu jums savo ramybę. Ne kaip pasaulis duoda, aš jums duodu. Tegul nebūna sukrėstos jūsų širdys ir teneišsigąsta. ");
INSERT INTO lit_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Girdėjote, kaip aš jums sakiau: „Išeinu ir vėl ateisiu pas jus.“ Jei mane mylėtumėte, džiaugtumėtės, kad sakiau: „Einu pas Tėvą“, – nes mano Tėvas yra didesnis už mane. ");
INSERT INTO lit_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ir jau dabar, prieš įvykstant, esu jums tai pasakęs, jog kada tai įvyks, tikėtumėte. ");
INSERT INTO lit_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Nuo šiol nebedaug kalbėsiu su jumis, nes ateina šio pasaulio kunigaikštis, ir manyje jis neturi nieko. ");
INSERT INTO lit_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Bet taip ir darau, kaip Tėvas davė man įsakymą, kad pasaulis žinotų, kad myliu Tėvą. Kelkitės, eikime iš čia!“ ");
INSERT INTO lit_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","„Aš esu tikrasis vynmedis, o mano Tėvas yra sodininkas. ");
INSERT INTO lit_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Kiekvieną manyje esančią šakelę, neduodančią vaisiaus, jis pašalina; ir kiekvieną šakelę, duodančią vaisių, apgenėja, kad ji neštų daugiau vaisiaus. ");
INSERT INTO lit_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Jūs jau esate švarūs per žodį, kurį jums kalbėjau. ");
INSERT INTO lit_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Pasilikite manyje, ir aš – jumyse. Kaip šakelė negali duoti vaisiaus pati iš savęs, jei ji nepasilieka vynmedyje, taip negalite ir jūs, jei nepasiliekate manyje. ");
INSERT INTO lit_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Aš esu vynmedis, jūs – šakelės; kas pasilieka manyje, ir aš jame, tas neša daug vaisiaus, nes nuo manęs atskirti nieko nepajėgiate nuveikti. ");
INSERT INTO lit_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Jei kas nepasiliks manyje, tas bus išmestas laukan kaip šakelė ir sudžius. O jas surenka ir įmeta į ugnį, ir jos yra sudeginamos. ");
INSERT INTO lit_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Jei pasiliksite manyje, ir mano žodžiai pasiliks jumyse, prašysite, ko tik norėsite, ir jums tai įvyks. ");
INSERT INTO lit_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Mano Tėvas bus pašlovintas tuo, kad duosite daug vaisių, ir taip pasirodysite esą mano mokytiniai. ");
INSERT INTO lit_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Kaip Tėvas mane mylėjo, taip ir aš jus mylėjau. Pasilikite mano meilėje. ");
INSERT INTO lit_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Jei laikysitės mano įsakymų, pasiliksite mano meilėje, kaip ir aš esu laikęsis savo Tėvo įsakymų ir pasilieku jo meilėje. ");
INSERT INTO lit_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Tuos dalykus esu jums pasakęs, kad mano džiaugsmas pasiliktų jumyse ir kad jūsų džiaugsmas būtų pilnatviškas. ");
INSERT INTO lit_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Šitas yra mano įsakymas: kad vieni kitus mylėtumėte, kaip aš jus mylėjau. ");
INSERT INTO lit_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Niekas neturi didesnės meilės negu tai, kad kas guldo savo gyvybę už savo draugus. ");
INSERT INTO lit_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Jūs esate mano draugai, jei darote, ką tik aš jums įsakau. ");
INSERT INTO lit_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Jau nebevadinu jūsų tarnais, nes tarnas nežino, ką daro jo šeimininkas. Bet jus esu pavadinęs draugais, nes pranešiau jums visus dalykus, kuriuos girdėjau iš savo Tėvo. ");
INSERT INTO lit_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ne jūs mane išsirinkote, bet aš jus išsirinkau ir jus paskyriau, kad jūs eitumėte ir neštumėte vaisių, ir kad jūsų vaisius išliktų, kad ko tik prašytumėte Tėvą mano vardu, jis jums duotų. ");
INSERT INTO lit_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Šiuos dalykus jums įsakau, kad mylėtumėte vienas kitą. ");
INSERT INTO lit_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Jei pasaulis jūsų nekenčia, žinokite, kad jis yra manęs nekentęs pirmiau negu jūsų. ");
INSERT INTO lit_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Jeigu jūs būtumėte iš pasaulio, pasaulis mylėtų savuosius. Tačiau, kadangi nesate iš pasaulio, bet aš jus išsirinkau iš pasaulio, todėl pasaulis jūsų nekenčia. ");
INSERT INTO lit_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Atsiminkite žodį, kurį aš jums sakiau: Tarnas nėra didesnis už savo šeimininką. Jeigu jie mane persekiojo, tai ir jus persekios. Jeigu jie laikėsi mano žodžio, tai laikysis ir jūsų. ");
INSERT INTO lit_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Bet visus šiuos dalykus jie darys jums dėl mano vardo, nes jie nepažįsta to, kuris mane siuntė. ");
INSERT INTO lit_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Jei nebūčiau atėjęs ir jiems kalbėjęs, jie neturėtų nuodėmės. O dabar jie neturi kuo paslėpti savo nuodėmę. ");
INSERT INTO lit_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Kas manęs nekenčia, nekenčia ir mano Tėvo. ");
INSERT INTO lit_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Jei nebūčiau tarp jų padaręs darbų, kurių niekas kitas nėra daręs, jie neturėtų nuodėmės. Bet dabar jie yra ir matę, ir nekentę tiek manęs, tiek mano Tėvo. ");
INSERT INTO lit_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Bet yra taip, kaip yra, kad išsipildytų žodis, parašytas jų įstatyme: Jie manęs nekentė be priežasties. ");
INSERT INTO lit_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Bet kai bus atėjęs Paguodžiantis Užtarėjas, kurį jums atsiųsiu nuo Tėvo, Tiesos Dvasia, kuri išeina iš Tėvo, jis liudys apie mane. ");
INSERT INTO lit_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ir jūs taip pat liudykite, nes buvote su manimi nuo pradžios.“ ");
INSERT INTO lit_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","„Tuos dalykus esu jums pasakęs, kad pasipiktinę nesukluptumėte į nuodėmę. ");
INSERT INTO lit_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Jie pašalins jus iš sinagogų, ir netgi ateina laikas kiekvienam jus žudančiam žmogui manyti, kad atlieka tarnystę Dievui. ");
INSERT INTO lit_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ir tuos dalykus jie darys jums, nes jie nei Tėvo, nei manęs nepažino. ");
INSERT INTO lit_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Bet tuos dalykus esu jums pasakęs, kad atėjus laikui atsimintumėte, kad pats apie juos kalbėjau jums. Ir tų dalykų nesakiau jums iš pradžių, nes buvau su jumis. ");
INSERT INTO lit_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Bet dabar einu pas tą, kuris mane siuntė, ir nė vienas iš jūsų manęs neklausia: ‚Kur eini?‘ ");
INSERT INTO lit_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Bet kadangi esu jums pasakęs tuos dalykus, liūdesys pripildė jūsų širdį. ");
INSERT INTO lit_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Tačiau aš jums sakau tiesą: jums yra naudinga, kad aš išeinu, nes jei neišeisiu, pas jus neateis Paguodžiantis Užtarėjas, bet jei išeisiu, atsiųsiu jį pas jus. ");
INSERT INTO lit_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ir atėjęs jis įtikins pasaulį esant kaltą dėl nuodėmės, dėl teisumo ir dėl teismo: ");
INSERT INTO lit_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","dėl nuodėmės, nes jie netiki manimi; ");
INSERT INTO lit_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","dėl teisumo, nes einu pas savo Tėvą, ir nebematysite manęs; ");
INSERT INTO lit_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","dėl teismo, nes šio pasaulio kunigaikštis yra nuteistas. ");
INSERT INTO lit_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Dar daug dalykų turiu jums pasakyti, bet jūs dabar negalite pakelti. ");
INSERT INTO lit_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Tačiau kai ateis anas Paguodžiantis Užtarėjas, – tiesos Dvasia, – jis ves jus į visą tiesą, nes jis kalbės nesivadovaudamas savimi, bet kalbės, kokius tik dalykus išgirs, ir praneš jums tuos dalykus, kurie turi įvykti. ");
INSERT INTO lit_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Jis pašlovins mane, nes jisims iš to, kas mano, ir jums praneš. ");
INSERT INTO lit_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Visa, ką tik turi Tėvas, yra mano, todėl sakiau, kad jis ims iš to, kas mano, ir jums praneš. ");
INSERT INTO lit_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Prabėgs trumpas laikas – ir manęs neregėsite, ir dar trumpas laikas – ir mane pamatysite, nes aš pas Tėvą einu.“ ");
INSERT INTO lit_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Tada kai kurie iš jo mokytinių tarpusavyje pasakė: „Kas tai yra, ką jis mums sako: ‚Prabėgs trumpas laikas – ir manęs neregėsite, ir dar trumpas laikas – ir mane pamatysite‘? ir: ‚Nes aš pas Tėvą einu‘?“ ");
INSERT INTO lit_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Todėl jie klausinėjo: „Kas tai yra, ką jis sako: ‚Prabėgs trumpas laikas‘? Nežinome, ką jis kalba.“ ");
INSERT INTO lit_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Taigi, Jėzus žinojo, kad jie norėjo jį klausti, ir jiems tarė: „Ar klausinėjote vieni kitų dėl to, kad pasakiau: ‚Prabėgs trumpas laikas – ir manęs neregėsite, ir dar trumpas laikas – ir mane pamatysite‘? ");
INSERT INTO lit_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Iš tiesų, iš tiesų sakau jums: jūs verksite ir raudosite, bet pasaulis džiaugsis. Ir jūs liūdėsite, bet jūsų liūdesys pavirs džiaugsmu. ");
INSERT INTO lit_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Moteris, kai ji gimdo, sielojasi, nes atėjo jos valanda, bet vos tik pagimdžiusi vaiką ji nebeprisimena kančios iš džiaugsmo, kad į pasaulį gimė žmogus. ");
INSERT INTO lit_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Taip ir jūs dabar tikrai sielojatės, bet aš jus vėl pamatysiu, ir jūsų širdis džiaugsis. Ir jūsų džiaugsmo niekas neatima iš jūsų. ");
INSERT INTO lit_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ir tą dieną manęs nieko neklausinėsite. Iš tiesų, iš tiesų sakau jums: ko tik prašysite Tėvą mano vardu, jis jums duos. ");
INSERT INTO lit_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Iki šiol nieko neprašėte mano vardu. Prašykite, ir gausite, kad jūsų džiaugsmas būtų pilnatviškas. ");
INSERT INTO lit_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Šiuos dalykus jums esu pasakęs palyginimais, bet ateina laikas, kai nebe palyginimais kalbėsiu jums, bet atvirai apie Tėvą jums skelbsiu. ");
INSERT INTO lit_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Tą dieną prašysite mano vardu, ir nesakau jums, kad už jus melsiu Tėvą aš pats, ");
INSERT INTO lit_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","nes pats Tėvas jus myli, kadangi jūs esate mane mylėję ir esate tikėję, kad būtent aš atėjau iš Dievo. ");
INSERT INTO lit_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Išėjau iš Tėvo ir esu atėjęs į pasaulį. Vėl palieku pasaulį ir einu pas Tėvą.“ ");
INSERT INTO lit_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Jo mokytiniai jam tarė: „Štai dabar atvirai kalbi ir nebekalbi palyginimų. ");
INSERT INTO lit_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Dabar žinome, kad žinai viską, ir tau nereikia, jog kas tavęs klaustų; iš to mes tikime, kad tu išėjęs nuo Dievo.“ ");
INSERT INTO lit_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jėzus jiems atsakė: „Ar dabar tikite? ");
INSERT INTO lit_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Štai ateina valanda – net dabar yra atėjusi – jums išsisklaidyti kiekvienas prie savo daiktų ir palikti mane vieną, tačiau nesu vienas, nes su manimi yra Tėvas. ");
INSERT INTO lit_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Tuos dalykus esu jums pasakęs, kad manyje turėtumėte ramybę. Pasaulyje turėsite prispaudimą, bet būkite drąsūs: pasaulį nugalėjau būtent aš. ");
INSERT INTO lit_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jėzus pasakė tuos dalykus ir pakėlė savo akis į dangų, ir tarė: „Tėve, atėjo valanda! Pašlovink savo Sūnų, kad ir tavo Sūnus pašlovintų tave, ");
INSERT INTO lit_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","kad, kaip jam esi davęs teisę valdyti kiekvieną žmogų, jis duotų amžiną gyvenimą visiems, kuriuos esi jam davęs. ");
INSERT INTO lit_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","O tai yra amžinas gyvenimas: kad jie pažintų tave, vienintelį teisingą bei tikrą Dievą ir tavo siųstąjį Jėzų Kristų. ");
INSERT INTO lit_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Aš pašlovinau tave žemėje, pabaigiau darbą, kurį man davei nuveikti. ");
INSERT INTO lit_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","O dabar tu, Tėve, pašlovink mane pas save ta šlove, kurią turėjau su tavimi prieš pasaulio buvimą. ");
INSERT INTO lit_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Apreiškiau tavo vardą žmonėms, kuriuos man esi davęs iš pasaulio. Jie buvo tavo, ir man esi juos davęs, ir jie yra laikęsi tavo žodžio. ");
INSERT INTO lit_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Dabar jie yra pažinę, kad visa, ką esi man davęs, yra iš tavęs. ");
INSERT INTO lit_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Nes aš jiems daviau žodžius, kuriuos esi man davęs, ir jie juos priėmė ir tikrai pažino, kad aš nuo tavęs išėjau, ir jie įtikėjo, kad tu mane siuntei. ");
INSERT INTO lit_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Aš meldžiu už juos. Ne už pasaulį meldžiu, bet už tuos, kuriuos esi man davęs, nes jie yra tavo. ");
INSERT INTO lit_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ir visi, kurie yra mano, yra tavo, ir kurie tavo, – mano, ir aš esu pašlovintas per juos. ");
INSERT INTO lit_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ir dabar nebesu pasaulyje, bet šitie yra pasaulyje, o aš einu pas tave. Šventasis Tėve, išlaikyk savo vardu tuos, kuriuos esi man davęs, kad jie būtų viena kaip ir mes. ");
INSERT INTO lit_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Kol buvau su jais pasaulyje, aš išlaikiau juos tavo vardu; saugojau tuos, kuriuos man davei, ir nė vienas iš jų nėra prarastas, tiktai pražūties sūnus, kad išsipildytų šventraštis. ");
INSERT INTO lit_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","O dabar einu pas tave; ir šiuos dalykus kalbu pasaulyje, kad jie turėtų savyje išsipildžiusį mano džiaugsmą. ");
INSERT INTO lit_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Aš esu jiems davęs tavo žodį, ir pasaulis jų nekentė, nes jie nėra iš pasaulio, kaip ir aš nesu iš pasaulio. ");
INSERT INTO lit_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nemeldžiu, kad juos paimtum iš pasaulio, bet kad saugotum juos nuo blogio. ");
INSERT INTO lit_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Jie nėra iš pasaulio, kaip ir aš nesu iš pasaulio. ");
INSERT INTO lit_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Šventink juos savo tiesa! Tavo žodis yra tiesa. ");
INSERT INTO lit_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Kaip tu mane siuntei į pasaulį, taip ir aš juos siunčiau į pasaulį. ");
INSERT INTO lit_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ir jų labui aš pašventinu save, kad ir jie iš tiesų būtų pašventinti. ");
INSERT INTO lit_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Tačiau meldžiu ne vien už šituos, bet ir už tuos, kurie per jų žodį įtikės manimi, ");
INSERT INTO lit_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","kad jie visi būtų viena, kaip tu, Tėve, esi manyje, ir aš tavyje. Meldžiu, kad ir jie mumyse būtų viena, idant pasaulis tikėtų, jog tu esi mane siuntęs. ");
INSERT INTO lit_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ir tą šlovę, kurią man davei, aš jiems daviau, kad jie būtų viena taip, kaip ir mes esame viena: ");
INSERT INTO lit_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","aš juose, ir tu manyje, idant jie būtų iki galo suvienyti, ir kad pasaulis žinotų, jog tu mane siuntei ir juos mylėjai taip, kaip mylėjai mane. ");
INSERT INTO lit_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Tėve, aš noriu, kad ir tie, kuriuos man davei, būtų su manimi ten, kur aš esu, idant jie matytų mano šlovę, kurią man davei, nes mylėjai mane prieš pasaulio įkūrimą. ");
INSERT INTO lit_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","O teisusis Tėve, pasaulis tavęs nepažinojo, bet aš tave pažinojau, ir šitie pažino, kad tu mane siuntei. ");
INSERT INTO lit_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ir supažindinau juos su tavo vardu ir dar supažindinsiu, kad meilė, kuria mane mylėjai, būtų juose, ir aš juose. ");
INSERT INTO lit_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Pasakęs tuos žodžius, Jėzus išėjo su savo mokytiniais į kitą žiemą tekančio upelio „Kedron“ pusę, kur buvo sodas, į kurį įėjo jis ir jo mokytiniai. ");
INSERT INTO lit_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","O jo išdavikas Judas taip pat žinojo tą vietą, nes Jėzus dažnai ten susieidavo su savo mokytiniais. ");
INSERT INTO lit_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Taigi Judas, gavęs būrį kareivių ir patikėtinių iš aukštųjų kunigų ir fariziejų, *atėjo ten su žibintais, deglais ir ginklais. ");
INSERT INTO lit_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Todėl Jėzus, žinodamas visa, kas jam atsitinka, išėjo į priekį ir jiems tarė: „Ko ieškote?“ ");
INSERT INTO lit_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Jie atsakė jam: „Jėzaus Nazariečio“. Jėzus jiems *tarė: „AŠ ESU tas“. O jo išdavikas Judas irgi stovėjo su jais. ");
INSERT INTO lit_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Taigi, kai tik jis ištarė jiems: „AŠ ESU tas“, jie atsitraukė ir parpuolė ant žemės. ");
INSERT INTO lit_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Tada jis vėl juos paklausė: „Ko ieškote?“ Ir jie tarė: „Jėzaus Nazariečio“. ");
INSERT INTO lit_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jėzus atsakė: „Jums pasakiau, kad AŠ ESU tas. Taigi jei ieškote manęs, tai leiskite šitiems pasišalinti“, – ");
INSERT INTO lit_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","kad išsipildytų žodis, kurį jis buvo pasakęs: „Iš tų, kuriuos man davei, nepraradau nė vieno“. ");
INSERT INTO lit_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Tada Simonas Petras, kuris turėjo kalaviją, išsitraukė jį, smogė vyriausiojo kunigo tarnui ir nukirto jam dešinę ausį. O to tarno vardas buvo Malkus. ");
INSERT INTO lit_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Tada Jėzus pasakė Petrui: „Kišk savo kalaviją į makštį! Argi neturėčiau gerti tos taurės, kurią Tėvas man yra davęs?!“ ");
INSERT INTO lit_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Tada būrys, jo vadas ir žydų patikėtiniai sučiupo Jėzų, jį surišo ");
INSERT INTO lit_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ir nuvedė jį pirma pas Aną, nes jis buvo uošvis Kajafo, kuris tais metais buvo vyriausiasis kunigas. ");
INSERT INTO lit_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","O Kajafas buvo tas, kuris buvo pataręs žydams, kad yra naudinga, jog vienas žmogus mirtų už liaudį. ");
INSERT INTO lit_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","O paskui Jėzų nusekė Simonas Petras ir kitas mokytinis. Tas mokytinis buvo pažįstamas vyriausiajam kunigui ir įėjo su Jėzumi į vyriausiojo kunigo kiemą. ");
INSERT INTO lit_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Bet Petras liko stovėti prie durų. Tada išėjo anas mokytinis, kuris buvo pažįstamas vyriausiajam kunigui, ir kalbėjo su durininke ir įsivedė Petrą. ");
INSERT INTO lit_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Tada tarnaitė durininkė *pasakė Petrui: „Ar ir tu nesi vienas iš šito žmogaus mokytinių?“ Jis *pasakė: „Nesu!“ ");
INSERT INTO lit_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","O ten stoviniavo tarnai ir patikėtiniai, dėl šalčio susikūrę ugnį iš anglių. Petras taip pat buvo su jais, stovinėdamas ir šildydamasis. ");
INSERT INTO lit_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Tada vyriausiasis kunigas paklausė Jėzaus apie jo mokytinius ir apie jo mokslą. ");
INSERT INTO lit_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jėzus jam atsakė: „Aš viešai kalbėjau pasauliui. Aš visada mokiau sinagogoje ir šventykloje, kur visuomet susieina žydai, ir slapčia nieko nekalbėjau. ");
INSERT INTO lit_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Kodėl mane klausinėji? Klausinėk tuos, kurie yra girdėję, ką jiems kalbėjau. Štai jie žino, ką aš sakiau.“ ");
INSERT INTO lit_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ir jam tai pasakius, vienas iš šalia stovinčių patikėtinių daužė Jėzui per veidą, sakydamas: „Šitaip tu atsakai vyriausiajam kunigui?!“ ");
INSERT INTO lit_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jėzus jam atsakė: „Jei neteisingai pasakiau, liudyk apie tai, kas neteisinga, bet jei teisingai, kam mane muši?“ ");
INSERT INTO lit_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","(Taigi, Anas pasiuntė jį surištą pas vyriausiąjį kunigą Kajafą.) ");
INSERT INTO lit_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Tuo tarpu Simonas Petras tebestovėjo ir šildėsi. Todėl jie tarė jam: „Ar ir tu nesi vienas iš jo mokytinių?“ Jis išsigynė, sakydamas: „Nesu!“ ");
INSERT INTO lit_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Vienas iš vyriausiojo kunigo tarnų, giminaitis to, kuriam Petras nukirto ausį, *pasakė: „Argi aš tavęs nemačiau sode kartu su juo?“ ");
INSERT INTO lit_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Tada Petras vėl išsigynė, ir tuojau pragydo gaidys. ");
INSERT INTO lit_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Tada jie *nuvedė Jėzų nuo Kajafo į teismo aikštę, – o buvo anksti, – bet jie patys nėjo į teismo aikštę, kad nesusiterštų, bet kad galėtų valgyti Aplenkimo avinėlį. ");
INSERT INTO lit_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Tada Pilotas išėjo pas juos ir tarė: „Kokį kaltinimą keliate prieš šitą žmogų?“ ");
INSERT INTO lit_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Jie atsakydami jam tarė: „Jeigu jis nebūtų blogadarys, nebūtume tau jo perdavę.“ ");
INSERT INTO lit_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Tada Pilotas tarė jiems: „Jį paimkite jūs patys ir jį teiskite pagal savo įstatymą!“ Tada žydai jam tarė: „Mums neteisėta nė vieno nužudyti“, – ");
INSERT INTO lit_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","kad išsipildytų Jėzaus žodis, kurį jis buvo pasakęs, nurodydamas, kokia mirtimi jam numatyta mirti. ");
INSERT INTO lit_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Tada Pilotas vėl įėjo į teismo aikštę ir pasišaukė Jėzų ir jam tarė: „Ar tu esi žydų karalius?“ ");
INSERT INTO lit_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jėzus jam atsakė: „Ar tu tai sakai vadovaudamasis savimi, ar kiti apie mane tau pasakė?“ ");
INSERT INTO lit_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilotas atsakė: „Nejaugi aš esu žydas?! Tavo tauta ir aukštieji kunigai tave man perdavė. Ką padarei?“ ");
INSERT INTO lit_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jėzus atsakė: „Mano karalystė yra ne iš šio pasaulio. Jeigu mano karalystė būtų iš šio pasaulio, tuomet mano pavaldiniai kovotų, kad aš nebūčiau atiduotas žydams. Bet iš tikrųjų mano karalystė nėra iš čia.“ ");
INSERT INTO lit_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Todėl Pilotas jam tarė: „Vadinasi, tu esi karalius?“ Jėzus atsakė: „Tu tai sakai, nes aš esu karalius. Aš tam esu gimęs ir tam atėjęs į pasaulį, kad liudyčiau tiesą. Kiekvienas, kuris yra iš tiesos, klauso mano balso.“ ");
INSERT INTO lit_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilotas jam *pasakė: „Kas yra tiesa?“ Ir tai taręs jis vėl išėjo pas žydus ir jiems *tarė: „Aš nerandu jame jokios kaltės. ");
INSERT INTO lit_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Vis dėlto jūs turite paprotį, kad per Aplenkimo šventę paleisčiau jums vieną suimtąjį. Taigi ar norite, kad paleisčiau jums žydų karalių?“ ");
INSERT INTO lit_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Tada jie visi vėl šaukė, sakydami: „Ne šitą, bet Barabą!“ O Barabas buvo plėšikas. ");
INSERT INTO lit_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Tad Pilotas tuomet paėmė Jėzų ir nuplakdino. ");
INSERT INTO lit_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ir kareiviai, nupynę vainiką iš erškėčių, uždėjo jam ant galvos ir apsiautė jį purpurine skraiste ");
INSERT INTO lit_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ir tarė: „Sveikas, žydų karaliau!“, ir vis daužė Jėzui per veidą. ");
INSERT INTO lit_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Taigi Pilotas dar kartą išėjo laukan ir jiems *tarė: „Štai išvedu jį jums, kad žinotumėte, jog nerandu jokios kaltės jame.“ ");
INSERT INTO lit_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Tada Jėzus išėjo laukan nešinas erškėčių vainiku ir purpurine skraiste. O Pilotas jiems *tarė: „Štai žmogus!“ ");
INSERT INTO lit_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Taigi, kai aukštieji kunigai ir patikėtiniai jį pamatė, jie šaukė, sakydami: „Nukryžiuok jį, nukryžiuok!“ Pilotas jiems *tarė: „Jį paimkite jūs patys ir nukryžiuokite, nes aš jame nerandu kaltės!“ ");
INSERT INTO lit_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Žydai jam atsakė: „Mes turime įstatymą, ir pagal mūsų įstatymą jis turi mirti, nes jis paskyrė save Dievo Sūnumi.“ ");
INSERT INTO lit_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Taigi, kai Pilotas išgirdo tą pasakymą, jis dar labiau išsigando ");
INSERT INTO lit_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ir vėl nuėjo į teismo aikštę ir *pasakė Jėzui: „Iš kur tu esi?“ Bet Jėzus jam neatsakė. ");
INSERT INTO lit_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Tada Pilotas jam *tarė: „Nekalbi su manimi? Ar nežinai, kad turiu valdžią tave nukryžiuoti ir turiu valdžią tave paleisti?!“ ");
INSERT INTO lit_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jėzus atsakė: „Tu prieš mane neturėtum jokios valdžios, jei tau nebūtų duota iš aukštybių. Todėl tas, kuris mane perdavė tau, turi didesnę nuodėmę.“ ");
INSERT INTO lit_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ir nuo tol Pilotas vis pasistengė jį paleisti, bet žydai vis šaukė, sakydami: „Jei šitą paleisi, nesi ciesoriaus draugas. Kiekvienas, kuris darosi karaliumi, kalba prieš ciesorių.“ ");
INSERT INTO lit_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Tada Pilotas, išgirdęs tą pasakymą, išvedė Jėzų laukan ir atsisėdo į teismo krasę vietoje, pavadintoje „Akmenų grindinys“, o hebrajiškai – Gabata. ");
INSERT INTO lit_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","O tai buvo Aplenkimo šventės Pasirengimo diena ir apie šeštą valandą. Ir jis *tarė žydams: „Štai jūsų karalius!“ ");
INSERT INTO lit_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Bet jie šaukė: „Šalin, šalin! Nukryžiuok jį!“ Pilotas jiems *tarė: „Ar man nukryžiuoti jūsų karalių?“ Aukštieji kunigai atsakė: „Neturime karaliaus, tiktai ciesorių!“ ");
INSERT INTO lit_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Taigi tuomet jis atidavė jiems jį, kad būtų nukryžiuotas. O jie paėmė ir nusivedė Jėzų. ");
INSERT INTO lit_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ir jis, nešdamas savo kryžių, išėjo į vadinamąją Kaukolės vietą, kuri hebrajiškai vadinama Golgota, ");
INSERT INTO lit_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","kur jie nukryžiavo jį, o su juo kitus du vienoje ir antroje pusėje, bet Jėzų viduryje. ");
INSERT INTO lit_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","O be to Pilotas parašė užrašą ir prisegė jį prie kryžiaus. Buvo parašyta: „Jėzus Nazarietis, žydų karalius.“ ");
INSERT INTO lit_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Tad šį užrašą skaitė daugybė žydų, nes vieta, kur Jėzus buvo nukryžiuotas, buvo arti miesto, o parašyta buvo hebrajiškai, graikiškai ir lotyniškai. ");
INSERT INTO lit_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Tad žydų aukštieji kunigai tarė Pilotui: „Nerašyk: „Žydų Karalius„“, bet, „Šitas sakė: „Aš esu žydų Karalius“.“ ");
INSERT INTO lit_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilotas atsakė: „Ką parašiau, parašiau!“ ");
INSERT INTO lit_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","O kareiviai, kai buvo nukryžiavę Jėzų, paėmė jo drabužius ir padalijo juos į keturias dalis – kiekvienam kareiviui po dalį; pasiėmė ir tuniką. O tunika buvo be siūlės, nuo viršaus ištisai austa. ");
INSERT INTO lit_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Todėl jie vieni kitiems tarė: „Neplėšykime jοs, bet meskime dėl jos burtą, kam teks“, – kad išsipildytų šventraštis, kuris sako: „Jie pasidalijo tarpusavyje mano drabužius ir dėl mano apdaro metė burtą.“ Būtent dėl to kareiviai padarė šituos dalykus. ");
INSERT INTO lit_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Tuo tarpu prie Jėzaus kryžiaus stovėjo jo motina bei jo motinos sesuo, Kleopo žmona Marija, ir Marija Magdalietė. ");
INSERT INTO lit_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Taigi Jėzus, pamatęs motiną ir šalia stovintį mokytinį, kurį jis mylėjo, *tarė savo motinai: „Moterie, štai tavo sūnus!“ ");
INSERT INTO lit_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Po to jis *tarė mokytiniui: „Štai tavo motina!“ Ir nuo tos valandos tas mokytinis pasiėmė ją į savo namus. ");
INSERT INTO lit_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Po to, žinodamas, jog jau viskas atlikta, kad išsipildytų šventraštis, Jėzus *tarė: „Trokštu.“ ");
INSERT INTO lit_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","O tenai buvo pastatytas indas, pilnas acto. Ir jie, pripildę kempinę acto ir uždėję ją ant yzopo šakelės, prikišo prie jo burnos. ");
INSERT INTO lit_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Taigi, kai Jėzus buvo ėmęs acto, jis tarė: „Atlikta!“ Ir, nulenkęs galvą, atidavė dvasią. ");
INSERT INTO lit_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Taigi, dėl to, kad buvo Pasirengimo diena, žydai, kad kūnai neliktų ant kryžiaus per šabą, – nes ta šabo diena buvo didi, – prašė Pilotą, kad būtų sulaužytos jų kojos ir kūnai būtų nuimti. ");
INSERT INTO lit_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Tad atėjo kareiviai ir sulaužė pirmojo kojas, taip pat kito, kuris buvo su juo nukryžiuotas. ");
INSERT INTO lit_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Bet kai, priėję prie Jėzaus, pamatė jį jau mirus, jie nebelaužė jam kojų, ");
INSERT INTO lit_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","tik vienas iš kareivių ietimi perdūrė jam šoną, ir tuojau ištekėjo kraujo ir vandens. ");
INSERT INTO lit_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ir tas, kuris tai matė, yra paliudijęs (ir jo liudijimas yra tiesa, ir jis žino, kad sako tiesą), kad tikėtumėte jūs. ");
INSERT INTO lit_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Nes šitie dalykai įvyko, kad išsipildytų šventraštis: Nė vienas jo kaulas nebus sulaužytas. ");
INSERT INTO lit_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ir vėl, kitas šventraštis sako: „Jie žiūrės į tą, kurį perdūrė.“ ");
INSERT INTO lit_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ir po šitų įvykių Juozapas iš Arimatėjos, būdamas Jėzaus mokytinis, – tik slaptas dėl žydų baimės, – paprašė Pilotą, kad tas jam leistų pasiimti Jėzaus kūną, ir Pilotas leido. Tad jis atėjo ir pasiėmė Jėzaus kūną. ");
INSERT INTO lit_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Taip pat atėjo ir Nikodemas, kuris iš pradžių buvo atėjęs pas Jėzų nakčia, atnešdamas apie šimto svarų miros ir alavijo mišinio. ");
INSERT INTO lit_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Taigi, jie paėmė Jėzaus kūną ir suvyniojo jį į linines drobules su kvepalais, kaip yra paprotys žydams paruošti laidojimui. ");
INSERT INTO lit_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","O toje vietoje, kur jis buvo nukryžiuotas, buvo sodas, o tame sode naujas kapo rūsys, kuriame dar niekas nebuvo laidotas. ");
INSERT INTO lit_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Taigi dėl žydų Pasirengimo dienos jie ten paguldė Jėzų, nes kapas buvo arti. ");
INSERT INTO lit_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Pirmąją savaitės dieną, anksti, kai dar buvo tamsu, *atėjo Marija Magdalietė prie kapo ir *pamatė nuo kapo rūsio angos nuristą akmenį. ");
INSERT INTO lit_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Tad ji *nubėgo ir *atbėgo pas Simoną Petrą ir pas kitą mokytinį, kurį mylėjo Jėzus, ir jiems *pasakė: „Jie paėmė Viešpatį iš kapo, ir nežinome, kur jį padėjo!“ ");
INSERT INTO lit_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Taigi Petras ir tas kitas mokytinis išėjo ir leidosi prie kapo. ");
INSERT INTO lit_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ir abu bėgo kartu, bet tas kitas mokytinis pralenkė Petrą ir pirmas pasiekė kapą. ");
INSERT INTO lit_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ir pasilenkęs jis *pamatė padėtas linines drobules, tačiau neįėjo. ");
INSERT INTO lit_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Tada Simonas Petras *atėjo sekdamas paskui jį ir įėjo į kapo rūsį, ir *matė padėtas linines drobules ");
INSERT INTO lit_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","bei skepetą, buvusią ant jo galvos, ne prie drobulių gulinčią, bet atskirai suvyniotą į vieną vietą. ");
INSERT INTO lit_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Tuomet tad įėjo ir kitas mokytinis, kuris pirmas atėjo prie kapo – ir pamatė ir patikėjo. ");
INSERT INTO lit_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Mat jie šventraščio dar nebuvo supratę, kad jis turi prisikelti iš numirusiųjų. ");
INSERT INTO lit_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Tada tie mokytiniai vėl parėjo į savuosius namus. ");
INSERT INTO lit_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","O Marija verkdama stovėjo lauke palei kapą. Taigi, beverkdama ji pasilenkė į kapo vidų ");
INSERT INTO lit_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ir *pamatė du angelus baltais drabužiais sėdinčius: vieną galvūgalyje, o kitą kojų vietoje, kur buvo paguldytas Jėzaus kūnas. ");
INSERT INTO lit_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ir jie *tarė jai: „Moterie, kodėl verki?“ Ji *tarė jiems: Todėl, kad jie paėmė mano Viešpatį, ir nežinau, kur jį „padėjo.“ ");
INSERT INTO lit_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ir tuos žodžius pasakiusi ji atsisuko atgal ir pamatė stovintį Jėzų, bet nepažino, kad tai buvo Jėzus. ");
INSERT INTO lit_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jėzus *tarė jai: „Moterie, kodėl verki? Ko ieškai?“ Manydama, kad jis esąs sodininkas, ji tarė jam: „Gerbiamasis, jei tamsta išnešei jį, pasakyk man, kur jį padėjai, ir aš jį pasiimsiu.“ ");
INSERT INTO lit_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jėzus jai *tarė: „Marija!“ Ji atsisuko ir jam *tarė: „Rabuni!“ (verčiant būtų pasakyta „Mokytojau!“). ");
INSERT INTO lit_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jėzus jai sako: „Neliesk manęs, nes dar nesu pakilęs pas savo Tėvą. Bet eik pas mano brolius ir jiems pasakyk: ‚Aš pakylu pas savo Tėvą ir jūsų Tėvą, pas savo Dievą ir jūsų Dievą‘.“ ");
INSERT INTO lit_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Marija Magdalietė *atėjo pranešdama mokytiniams, kad ji mačiusi Viešpatį, ir kad jis pasakė jai tuos žodžius. ");
INSERT INTO lit_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Taigi, tą dieną, pirmąją savaitės dieną, vakarui atėjus ir durims, kur buvo susirinkę mokytiniai, dėl žydų baimės esant užrakintoms, atėjo Jėzus, atsistojo viduryje ir jiems *pasakė: „Ramybė jums!“ ");
INSERT INTO lit_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ir tai pasakęs, jis parodė jiems savo rankas ir savo šoną. Išvydę Viešpatį, mokytiniai dėl to nudžiugo. ");
INSERT INTO lit_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Tada Jėzus vėl jiems tarė: „Ramybė jums! Kaip Tėvas yra mane siuntęs, taip ir aš jus siunčiu.“ ");
INSERT INTO lit_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ir tai pasakęs jis kvėpė į juos ir jiems taria: „Priimkite Šventąją Dvasią: ");
INSERT INTO lit_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","kieno tik nuodėmes atleisite, tiems jos yra atleistos; kieno tik nuodėmes sulaikysite, jos yra sulaikytos.“ ");
INSERT INTO lit_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tačiau, kai atėjo Jėzus, Tomo, vadinamo Didymu, vieno iš Dvylikos, su jais nebuvo. ");
INSERT INTO lit_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Tad kiti mokytiniai jam tarė: „Mes matėme Viešpatį!“ Bet jis tarė jiems: „Jei nepamatysiu jo rankose vinių žymės ir neįdėsiu savo piršto į vinių žymę ir neįkišiu savo rankos į jo šoną, tuo visai netikėsiu.“ ");
INSERT INTO lit_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ir po aštuonių dienų jo mokytiniai vėl buvo viduje, ir Tomas su jais. Durims esant užrakintoms, Jėzus atėjo, atsistojo viduryje ir prabilo: „Ramybė jums!“ ");
INSERT INTO lit_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Paskui jis *pasakė Tomui: „Ištiesk čia savo pirštą, ir apžiūrėk mano rankas, ir ištiesk čia savo ranką ir įkišk į mano šoną, – ir nebūk netikintis, bet tikintis!“ ");
INSERT INTO lit_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ir Tomas atsakydamas tarė jam: „Mano Viešpatie ir mano Dieve!“ ");
INSERT INTO lit_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jėzus jam *pasakė: „Tomai, tu esi tikėjęs todėl, kad esi mane matęs; tie, kurie nematė, tačiau tikėjo, yra palaiminti!“ ");
INSERT INTO lit_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Žinoma, savo mokytinių akivaizdoje Jėzus padarė ir daug kitų antgamtinių ženklų, kurie nėra surašyti šioje knygoje. ");
INSERT INTO lit_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","O šitie yra surašyti, kad tikėtumėte, jog Jėzus yra Kristus, Dievo Sūnus, ir kad tikėdami turėtumėte gyvybę jo vardu. ");
INSERT INTO lit_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Po šių dalykų Jėzus vėl pasirodė mokytiniams prie Tiberiados jūros. Ir jis pasirodė šitaip. ");
INSERT INTO lit_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Buvo kartu Simonas Petras ir Tomas, vadinamas Didymu, taip pat Natanaelis iš Galilėjos Kanos, ir Zebediejaus sūnūs, ir kiti du iš jo mokytinių. ");
INSERT INTO lit_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simonas Petras jiems *tarė: „Einu žvejoti.“ Jie jam *atsiliepė: „Ir mes einame su tavimi.“ Jie išėjo ir tuojau sulipo į valtelę, bet tą naktį nieko nesugavo. ");
INSERT INTO lit_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Rytui jau išaušus, Jėzus stovėjo ant kranto, Bet mokytiniai nepažino, kad tai buvo Jėzus. ");
INSERT INTO lit_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Tada Jėzus jiems *tarė: „Vaikai, neturite kokio maisto, ar ne?“ Jie atsakė jam: „Ne“. ");
INSERT INTO lit_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Tad jis jiems tarė: „Užmeskite tinklą į dešinę pusę nuo valties, ir rasite.“ Taigi jie užmetė, ir jau nebeįstengė jo patraukti dėl žuvų gausybės. ");
INSERT INTO lit_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Todėl tas mokytinis, kurį Jėzus mylėjo, *pasakė Petrui: „Tai Viešpats!“ O Simonas Petras, išgirdęs, kad tai esąs Viešpats, apsijuosė žvejo drabužiu, nes buvo neapsirengęs, ir metėsi į jūrą. ");
INSERT INTO lit_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","O kiti mokytiniai atvyko valtele, nes buvo netoli nuo sausumos – tik už daugmaž dviejų šimtų uolekčių – atitempdami tinklą su žuvimis. ");
INSERT INTO lit_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Tada, kai jie išlipo į sausumą, jie pamatė paruoštas medžio anglių žėrinčias žarijas ir ant jų padėtą žuvį – taip pat duoną. ");
INSERT INTO lit_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jėzus jiems *pasakė: „Atneškite iš žuvų, kurias ką tik sugavote.“ ");
INSERT INTO lit_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simonas Petras nuėjo ir išvilko į sausumą tinklą, pilną didelių žuvų, iš viso šimtą penkiasdešimt tris. Ir nors jų buvo tiek daug, tačiau tinklas nesuplyšo. ");
INSERT INTO lit_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jėzus jiems *tarė: „Ateikite šen, valgykite!“ Ir nė vienas iš mokytinių nedrįso jo klausti: „Kas tu esi?“, nes jie žinojo, jog tai yra Viešpats. ");
INSERT INTO lit_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Taigi Jėzus *priėjo, *paėmė duonos ir *davė jiems, taip pat ir žuvies. ");
INSERT INTO lit_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Tai buvo jau trečias kartas, kai Jėzus, prikeltas iš numirusiųjų, pasirodė mokytiniams. ");
INSERT INTO lit_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Tad jiems pavalgius Jėzus *tarė Simonui Petrui: „Simonai, Jonos sūnau, ar myli mane labiau negu šitie?“ Jis jam *tarė: „Taip, Viešpatie. Tu žinai, kad tave myliu“. Jis sako jam: „Vis maitink mano avinėlius.“ ");
INSERT INTO lit_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jis vėl, antrą kartą, jam *pasakė: „Simonai, Jonos sūnau, ar myli mane?“ Tas jam *tarė: „Taip, Viešpatie. Tu žinai, kad tave myliu“. Jis jam *pasakė: „Vis ganyk mano avis.“ ");
INSERT INTO lit_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jis trečią kartą jam *pasakė: „Simonai, Jonos sūnau, ar myli mane?“ Petras nuliūdo, kad jis sakė jam trečią kartą: „Ar myli mane?“ Ir jis tarė jam: „Viešpatie, tu žinai viską; tu žinai, kad tave myliu“. Jėzus jam *tarė: „Vis maitink mano avis. ");
INSERT INTO lit_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Iš tiesų, iš tiesų sakau tau: kai buvai jaunas, susijuosdavai ir vaikščiodavai, kur norėjai. Bet kai pasensi, ištiesi savo rankas, ir kitas tave apjuos ir ves, kur tu nenori.“ ");
INSERT INTO lit_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Tai jis kalbėjo nurodydamas, kokia mirtimi Petras pašlovinsiąs Dievą. Ir tai pasakęs, jis dar jam *tarė: „Sek paskui mane!“ ");
INSERT INTO lit_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Tada Petras atsisukęs *pamatė iš paskos einantį mokytinį, kurį Jėzus mylėjo, kuris taip pat per vakarienę buvo atsilošęs ant Jėzaus krūtinės ir taręs: „Viešpatie, kas yra tas, kuris tave išduos?“ ");
INSERT INTO lit_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Petras, matydamas jį, *tarė Jėzui: „Viešpatie, o kas šitam bus?“ ");
INSERT INTO lit_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jėzus jam *tarė: „Jeigu norėčiau, kad jis pasiliktų, kol ateisiu, kas gi tau? Tu sek paskui mane.“ ");
INSERT INTO lit_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Tad tas pasakymas pasklido tarp brolių, jog tasai mokytinis nemirsiąs. Bet Jėzus jam nesakė, kad jis nemirsiąs, tik: „Jeigu norėčiau, kad jis pasiliktų, kol ateisiu, kas gi tau?“ ");
INSERT INTO lit_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Šis ir yra tas mokytinis, kuris liudija apie tuos dalykus ir juos užrašė, ir mes žinome, kad jo liudijimas yra tiesa. ");
INSERT INTO lit_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ir yra taip pat daug kitų dalykų, – kiek tik padarė Jėzus, – kuriuos užrašius po vieną, tai manau, kad net pats pasaulis nesutalpintų knygų, kurios būtų parašytos. Amen. ");
INSERT INTO lit_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Pirmąjį veikalą buvau sudaręs, Teofiliau, žinoma, apie viską, ką Jėzus pradėjo ir daryti ir mokyti ");
INSERT INTO lit_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","iki tos dienos, kurią buvo paimtas į dangų, pirmiau per Šventąją Dvasią davęs įsakymus apaštalams, kuriuos išsirinko. ");
INSERT INTO lit_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Jis ir save gyvą parodė jiems po savo kančios, su daugeliu nenuginčijamų įrodymų, keturiasdešimt dienų būdamas jų regėtas ir kalbėdamas apie dalykus, susijusius su Dievo karalyste. ");
INSERT INTO lit_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Be to, būdamas kartu su jais susibūręs, jis įsakė jiems nepasišalinti iš Jeruzalės, bet laukti to, ką Tėvas pažadėjo, „apie kurį, – pasakė jis, – girdėjote iš manęs, ");
INSERT INTO lit_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","nes Jonas, žinoma, vandeniu krikštijo, bet jūs po nedaugelio dienų būsite pakrikštyti Šventąja Dvasia.“ ");
INSERT INTO lit_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Taigi kai buvo susiėję, jie paklausė jo, sakydami: „Viešpatie, ar tu šiuo metu Izraeliui atkursi karalystę? ");
INSERT INTO lit_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","O jis tarė jiems: „Ne jums žinoti laikotarpius ar įvykių laikus, kuriuos nustatė Tėvas, remdamasis savo paties valdžia. ");
INSERT INTO lit_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Tačiau, Šventajai Dvasiai nužengus ant jūsų, gausite galybę ir būsite liudytojai mano labui ir Jeruzalėje, ir visoje Judėjoje bei Samarijoje ir ligi pat žemės pakraščių. ");
INSERT INTO lit_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ir jam pasakius tuos dalykus, jiems bežiūrint, jis buvo pakeltas, ir debesis atitraukė jį nuo jų akių. ");
INSERT INTO lit_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ir kol jam kylant jie įdėmiai žiūrėjo į dangų, štai ir prie jų atsistojo du vyrai baltais drabužiais, ");
INSERT INTO lit_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","kurie ir tarė: „Vyrai galilėjiečiai, ko stovite, žiūrėdami į dangų? Tas pats Jėzus, kuris buvo paimtas nuo jūsų į dangų, taip ir ateis, – tokiu pat būdu, kaip jį matėte vykstantį į dangų.“ ");
INSERT INTO lit_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Tada jie sugrįžo į Jeruzalę nuo vadinamojo Alyvų kalno, kuris arti Jeruzalės – šabo dienos kelionės atstumu. ");
INSERT INTO lit_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ir kai jie buvo įėję į Jeruzalę, jie užlipo į aukštutinį kambarį, kur buvo apsistoję Petras ir Jokūbas, ir Jonas, ir Andriejus, Pilypas ir Tomas, Baltramiejus ir Matas, Alfiejaus sūnus Jokūbas ir Simonas Uolusis, ir Jokūbo brolis Judas. ");
INSERT INTO lit_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Vieningai visi šitie uoliai atsidėjo maldai ir maldavimui kartu su moterimis ir Jėzaus motina Marija ir jo broliais. ");
INSERT INTO lit_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ir tomis dienomis atsistojo Petras viduryje mokytinių (iš viso buvo apie šimtą dvidešimt žmonių) ir tarė: ");
INSERT INTO lit_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","„Vyrai broliai! Turėjo išsipildyti šis šventraštis, kurį iš anksto Šventoji Dvasia kalbėjo Dovydo burna apie Judą, tapusį vadovu tiems, kurie suėmė Jėzų, ");
INSERT INTO lit_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","nes jis buvo priskaičiuotas prie mūsų ir buvo gavęs šios tarnystės dalį. ");
INSERT INTO lit_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Taigi, šitas gi už neteisybės atlyginimą įsigijo žemės sklypą, ir, stačia galva puolęs žemyn, plyšo pusiau, ir visi jo viduriai išvirto. ");
INSERT INTO lit_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ir tai pasidarė žinoma visiems, kurie gyveno Jeruzalėje, tad tas sklypas jų savita kalba buvo pramintas Akeldama, tai yra, Kraujo sklypas. ");
INSERT INTO lit_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Nes yra parašyta Psalmių knygoje: Jo buveinė tegul ištuštėja, ir tegul niekas joje negyvena; ir, kitas tegul perima jo prižiūrėjimo tarnystę. ");
INSERT INTO lit_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Taigi iš tų vyrų, kurie visą laiką buvo su mumis, kai Viešpats Jėzus tarp mūsų įeidavo ir išeidavo, ");
INSERT INTO lit_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","pradedant Jono krikštu iki tos dienos, kai jis buvo nuo mūsų paimtas aukštyn, vienas iš jų turi būti paskirtas jo prisikėlimo liudytoju kartu su mumis.“ ");
INSERT INTO lit_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ir jie pasiūlė du: Juozapą, vadinamą Barsabu, kuris buvo pramintas Justu, ir Motiejų. ");
INSERT INTO lit_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ir melsdamiesi jie tarė: „Tu, Viešpatie, kuris pažįsti visų širdis, parodyk, katrą iš šiųdviejų išsirinkai, ");
INSERT INTO lit_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","kad jis gautų dalį šios tarnystės, tai yra apaštalystės, nuo kurios Judas nusižengimu atkrito, kad nueitų į savąją vietą.“ ");
INSERT INTO lit_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Tada jie pateikė savo ženklus, ir sprendimą rodantis ženklas krito Motiejui, ir jis buvo priskaitytas prie vienuolikos apaštalų. ");
INSERT INTO lit_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ir visiškai atėjus Sekminių dienai, visi vieningai buvo vienoje vietoje. ");
INSERT INTO lit_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ir staiga iš dangaus atsirado ūžesys tarsi besinešančio smarkaus vėjo ir pripildė visą namą, kur jie sėdėjo. ");
INSERT INTO lit_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ir jiems pasirodė besidalą tarsi ugnies liežuviai, o tai sėdosi ant kiekvieno be išimties. ");
INSERT INTO lit_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ir jie visi tapo pripildyti Šventosios Dvasios ir pradėjo kalbėti kitomis kalbomis, kaip Dvasia jiems davė prabilti. ");
INSERT INTO lit_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ir Jeruzalėje gyveno žydų, pamaldžių žmonių iš visų tautų po dangumi. ");
INSERT INTO lit_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","O atsiradus gandui apie tai, subėgo minia ir sumišo, nes kiekvienas be išimties girdėjo juos kalbant savo kalba. ");
INSERT INTO lit_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ir jie visi apstulbo ir stebėjosi, sakydami vienas kitam: „Argi va visi šitie kalbantys nėra galilėjiečiai? ");
INSERT INTO lit_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Tai kaipgi mes kiekvienas girdime savo gimtąja kalba?! ");
INSERT INTO lit_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Mes – partai ir medai ir elamiečiai, taip pat gyvenantys Mesopotamijoje ir Judėjoje ir Kapadokijoje, Ponte ir Azijoje, ");
INSERT INTO lit_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigijoje ir Pamfilijoje, Egipte ir Libijos srityse Kirėnės link, ir apsilankantys romiečiai, – ir žydai ir prozelitai, – ");
INSERT INTO lit_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","kretiečiai ir arabai – girdime juos skelbiant didžius Dievo darbus mūsų kalbomis.“ ");
INSERT INTO lit_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ir jie visi apstulbo ir sumišo, vieni kitiems sakydami: „Ką gi tai reiškia?“ ");
INSERT INTO lit_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Kiti šaipydamiesi tarė: „Šitie yra pilni saldaus vyno.“ ");
INSERT INTO lit_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Izraelio vyrai, klausykite šių žodžių: Jėzų Nazarietį, – vyrą, kurį Dievas jums patvirtino galingais antgamtiniais veiksmais ir pranašiškais ženklais ir antgamtiniais ženklais, kuriuos Dievas darė per jį jūsų tarpe, kaip ir patys žinote, – ");
INSERT INTO lit_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","šitą (atiduotą Dievo paskirtu nutarimu ir išankstiniu žinojimu) jūs, suėmę įstatymo pažeidėjų rankomis bei prikalę prie kryžiaus, nužudėte; ");
INSERT INTO lit_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Dievas jį prikėlė, nutraukęs mirties gimdymo skausmus, nes buvo neįmanoma, kad jis būtų jos laikomas. ");
INSERT INTO lit_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","nes tu nepaliksi manęs kape nei neleisi savo Šventajam patirti supuvimo. ");
INSERT INTO lit_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Padarei taip, kad pažinčiau gyvybės kelius; tu savo veidu pripildysi mane džiaugsmo. ");
INSERT INTO lit_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Dievas prikėlė tą Jėzų; mes visi esame šito liudytojai. ");
INSERT INTO lit_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Todėl tegul visi Izraelio namai žino tvirtai, kad Dievas tą patį Jėzų, kurį jūs nukryžiavote, padarė ir Viešpačiu ir Kristumi.“ ");
INSERT INTO lit_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","O kai jie tai išgirdo, jiems verte vėrė širdį, ir jie tarė Petrui bei kitiems apaštalams: „Vyrai broliai, ką mums daryti?“ ");
INSERT INTO lit_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Taigi Petras jiems tarė: „Atgailaukite – ir turi būti pakrikštytas kiekvienas iš jūsų Jėzaus Kristaus vardu dėl nuodėmių atleidimo, – ir jūs gausite dovanojamą Šventąją Dvasią. ");
INSERT INTO lit_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Nes jums skirtas tas pažadas, taip pat jūsų vaikams ir visiems toli esantiems, kuriuos tik Viešpats, mūsų Dievas, pasišauks.“ ");
INSERT INTO lit_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ir daugeliu kitų žodžių jis uoliai liudijo ir ragino su įspėjimais, sakydamas: „Išsigelbėkite iš šitos iškrypusios kartos!“ ");
INSERT INTO lit_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Taigi tie, kurie mielai priėmė jo žodį, buvo pakrikštyti, ir tą dieną buvo pridėti apie tris tūkstančius sielų. ");
INSERT INTO lit_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ir jie uoliai atsidėjo apaštalų mokslui ir bendrystei ir duonos laužymui ir maldoms. ");
INSERT INTO lit_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ir baimė apėmė kiekvieną sielą, ir per apaštalus buvo daroma daug stebuklų ir antgamtinių ženklų. ");
INSERT INTO lit_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ir visi, kurie tikėjo, buvo kartu ir visa turėjo bendra, ");
INSERT INTO lit_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ir parduodavo savo nuosavybių bei turtų ir, ką gavę, padalydavo visiems, kiek kam reikėdavo. ");
INSERT INTO lit_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ir jie, kasdien vieningai atsidėdami suėjimui šventykloje ir laužydami duoną vienur kitur namuose, valgydavo džiugia ir darna širdimi, ");
INSERT INTO lit_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","girdami Dievą ir būdami visos tautos palankiai vertinami. Ir tuos, kuriuos jis išgelbėdavo, Viešpats kasdien pridėdavo prie bažnyčios. ");
INSERT INTO lit_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Bet Šventojo ir Teisiojo jūs išsigynėte ir reikalavote atiduoti jums vyrą žmogžudį, ");
INSERT INTO lit_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","ir nužudėte gyvybės Kūrėją, kurį Dievas prikėlė iš numirusių; mes esame to liudytojai. ");
INSERT INTO lit_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Tad atgailaukite ir atsiverskite dėl savo nuodėmių išdildymo, kad nuo Viešpaties veido ateitų atgaivos laikai ");
INSERT INTO lit_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ir atsiųstų jis anksčiau jums paskelbtąjį Jėzų Kristų. ");
INSERT INTO lit_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Nes Mozė tikrai pasakė tėvams: ‚Viešpats, jūsų Dievas, jums prikels iš jūsų brolių Pranašą – tokį, kaip mane. Klausykite jo visame kame, ką tik jis sakys jums. ");
INSERT INTO lit_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ir jiems bekalbant žmonėms, prie jų priėjo kunigai, šventyklos sargybos vadas ir sadukiejai, ");
INSERT INTO lit_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","gieždami apmaudą dėl to, kad jie mokė žmones ir skelbė prisikėlimą iš numirusiųjų Jėzaus atvejo pagrindu. ");
INSERT INTO lit_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ir jie nutvėrė juos ir uždarė į kalėjimą iki rytdienos, nes jau buvo vakaras. ");
INSERT INTO lit_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Bet daugelis tų, kurie girdėjo žodį, tikėjo, ir vyrų skaičius pasidarė maždaug penkiais tūkstančiais. ");
INSERT INTO lit_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","tebūna žinoma jums visiems ir visai Izraelio tautai, kad vardu Jėzaus Kristaus Nazariečio, kurį jūs nukryžiavote, kurį Dievas prikėlė iš numirusiųjų – per jį šitas vyras jūsų akivaizdoje stovi sveikas. ");
INSERT INTO lit_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Šitas yra akmuo, kuris buvo jūsų, statytojų, laikomas nieku, kuris tapo vyraujančiu kertiniu akmeniu. ");
INSERT INTO lit_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ir nė viename kitame nėra išgelbėjimo, nes po dangumi nėra tarp žmonių duoto kito vardo, kuriuo mes turime būti išgelbėti.“ ");
INSERT INTO lit_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","O matydami Petro ir Jono drąsą ir pastebėję, kad jie esą nemokyti ir neišprusę žmonės, jie stebėjosi, taip pat atpažino juos buvus su Jėzumi. ");
INSERT INTO lit_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Bet kad tai toliau neišplistų tautos tarpe, griežtai juos pagrasinkime, kad jie nuo šiol nė vienam nebekalbėtų remdamiesi šituo vardu.“ ");
INSERT INTO lit_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ir paleisti jie nuėjo pas savuosius ir išpasakojo viską, ką jiems buvo sakę aukštieji kunigai ir vyresnieji. ");
INSERT INTO lit_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ir išklausę tie vieningai pakėlė balsą į Dievą ir tarė: „Valdove, tu esi Dievas, kuris padarei dangų ir žemę ir jūrą ir visa, kas juose yra, ");
INSERT INTO lit_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","kuris savo tarno Dovydo burna pasakei: ‚Kodėl įnirto kitataučiai, ir tautos sutelkė dėmesį į tuštybę? ");
INSERT INTO lit_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Žemės karaliai stojo į kovą ir valdovai susibūrė draugėn prieš Viešpatį ir prieš jo Pateptąjį. ");
INSERT INTO lit_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Nes iš tiesų prieš tavo šventąjį Tarną Jėzų, kurį tu patepei, susibūrė ir Erodas ir Poncijus Pilotas su kitataučiais ir Izraelio tauta, ");
INSERT INTO lit_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","kad darytų visa, ką tavo ranka ir tavo nutarimas iš anksto buvo nulėmę įvykti. ");
INSERT INTO lit_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","O dabar, Viešpatie, pažvelk į jų grasinimus ir duok savo tarnams su visu drąsumu kalbėti tavo žodį, ");
INSERT INTO lit_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","kai tu ištiesi savo ranką išgydyti, ir ženklai ir stebuklai yra daromi tavo šventojo Tarno Jėzaus vardu.“ ");
INSERT INTO lit_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ir su didžiule jėga apaštalai liudijo Viešpaties Jėzaus prisikėlimą, ir didelė malonė buvo ant jų visų. ");
INSERT INTO lit_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Bet tam tikras žmogus, vardu Ananijas, su savo žmona Sapfyra pardavė nuosavybę ");
INSERT INTO lit_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Tada, pakilo vyriausiasis kunigas, taip pat visi kiti  su juo (tai yra sadukiejų sekta), ir jie pasidarė pilni pavydaus uolumo ");
INSERT INTO lit_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","O kai vyriausiasis kunigas, šventyklos sargybos vadas ir aukštieji kunigai išgirdo šituos žodžius, jie dėl jų sumišo, nežinodami, kas iš to išeis. ");
INSERT INTO lit_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Tada Petras ir kiti apaštalai atsakydami tarė: „Reikia labiau klausyti Dievo negu žmonių. ");
INSERT INTO lit_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Mūsų tėvų Dievas prikėlė Jėzų, kurį jūs nužudėte, pakabindami ant medžio. ");
INSERT INTO lit_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Jį Dievas išaukštino savo dešine ranka, kad būtų Kunigaikštis ir Išgelbėtojas, kad suteiktų Izraeliui atgailą ir nuodėmių atleidimą. ");
INSERT INTO lit_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Nes pirmiau šių dienų prieš kiek laiko iškilo Teudas, kuris pasisakė esąs kažkas nepaprastas. Prie jo prisijungė tam tikras vyrų skaičius – apie keturis šimtus. Jis buvo nužudytas, ir visi, kurie tikėjo juo, išsisklaidė ir nuėjo niekais. ");
INSERT INTO lit_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Taigi jie, žinoma, išėjo iš tarybos akivaizdos džiaugdamiesi, kad buvo palaikyti vertais dėl jo vardo patirti paniekinimą. ");
INSERT INTO lit_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","o mes patys uoliai atsidėsime maldai ir žodžio tarnybai. ");
INSERT INTO lit_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ir Dievo žodis vis klestėjo, ir mokytinių skaičius Jeruzalėje labai didėjo; be to, didelis kunigų būrys pakluso tikėjimui. ");
INSERT INTO lit_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","kol iškilo kitas karalius, kuris nežinojo apie Juozapą. ");
INSERT INTO lit_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Tada Viešpats jam tarė: „Nusiauk nuo savo kojų apavą, nes vieta, ant kurios tu stovi, yra šventa žemė“. ");
INSERT INTO lit_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Jūs, kietasprandžiai ir neapipjaustytieji širdimis bei ausimis! Jūs visuomet priešinatės Šventajai Dvasiai; kaip jūsų tėvai, taip ir jūs! ");
INSERT INTO lit_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Ir Saulius visiškai pritarė jo nužudymui. Ir tuo laiku kilo didelis persekiojimas, nukreiptas prieš Jeruzalėje esančią bažnyčią, ir visi, išskyrus apaštalus, buvo išsklaidyti į išeiviją po Judėjos ir Samarijos kraštus. ");
INSERT INTO lit_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Net pats Simonas įtikėjo ir pakrikštytas atsidėjo buvimui su Pilypu. O matydamas daromus antgamtinius veiksmus ir didžius antgamtinius ženklus, jis labai stebėjosi. ");
INSERT INTO lit_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Todėl tie, kurie buvo išsklaidyti, ėjo visur pranešdami Evangeliją, tai yra Viešpaties žodį. ");
INSERT INTO lit_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Tada Pilypas atvėręs savo burną pradėjo nuo to paties šventraščio ir paskelbė jam Evangeliją – Jėzų. ");
INSERT INTO lit_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ir jiems bevažiuojant keliu, jie prikeliavo kažkokį vandenį, ir eunuchas tarė: „Žiūrėk – vanduo! Kas man trukdo būti pakrikštytam?“ ");
INSERT INTO lit_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Tada Pilypas tarė: „Jei tiki iš visos širdies, tai yra teisėta.“ Atsakydamas tas pasakė: „Tikiu, kad Jėzus Kristus yra Dievo Sūnus.“ ");
INSERT INTO lit_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","O jis tarė: „Kas Tu esi, Viešpatie?“ Viešpats atsakė: „Aš esu Jėzus, kurį tu persekioji. Sunku tau spyriotis prieš akstiną!“ ");
INSERT INTO lit_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Tada drebėdamas ir stebėdamasis, jis tarė: „Viešpatie, ką tu nori, kad aš daryčiau?“ O Viešapts jam atsakė: „Kelkis, eik į miestą, ir tau bus pasakyta, ką turi daryti.“ ");
INSERT INTO lit_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Bet Saulius buvo vis labiau stiprinamas ir tarp Damaske gyvenančių žydų kėlė sąmyšį, įrodydamas, kad šitas yra tikras Kristus. ");
INSERT INTO lit_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Taigi bažnyčios po visą Judėją, Galilėją ir Samariją turėjo ramybę ir buvo statydinamos; ir vaikščiodamos Viešpaties baime bei Šventosios Dvasios padrąsinimu, jos buvo dauginamos. ");
INSERT INTO lit_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ir kai pasišalino angelas, kuris kalbėjo Kornelijui, šis pašaukė du savo besitarnaunčius namiškius ir pamaldų kareivį iš tų, kurie uoliai atsiduodavo jo patarnavimui, ");
INSERT INTO lit_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ir jis tarė jiems: „Jūs žinote, kaip stipriai žydui yra įstatymu uždrausta turėti artimų reikalų su svetimtaučiu arba svečiuotis pas jį. Bet Dievas man parodė, kad jokio žmogaus neturiu vadinti suteptu ar apeigine prasme netyru. ");
INSERT INTO lit_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Tada atvėręs burną Petras tarė: „Iš tiesų matau, kad Dievas nėra šališkas, ");
INSERT INTO lit_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Jį Dievas prikėlė trečiąją dieną ir padarė taip, kad jis pasidarė atvirai matomas – ");
INSERT INTO lit_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","ne visiems žmonėms, bet Dievo iš anksto parinktiems liudytojams – būtent mums, kurie su juo valgėme ir gėrėme, jam prisikėlus iš numirusių. ");
INSERT INTO lit_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ir jis mums įsakė skelbti žmonėms ir uoliai liudyti, kad būtent jis yra Dievo paskirtasis gyvųjų ir mirusiųjų teisėjas. ");
INSERT INTO lit_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Apie jį visi pranašai liudija, kad kiekvienas, kuris juo pasitiki, jo vardu gauna nuodėmių atleidimą. ");
INSERT INTO lit_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Petrui dar tebetariant šiuos žodžius, Šventoji Dvasia nužengė ant visų, kurie klausėsi žodžio. ");
INSERT INTO lit_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ir apaštalai ir broliai, kurie buvo Judėjoje, išgirdo, kad ir kitataučiai priėmė Dievo žodį. ");
INSERT INTO lit_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Tada prisiminiau Viešpaties žodį, kaip jis sakydavo: ‚Jonas, žinoma, vandeniu krikštijo, bet jūs būsite pakrikštyti Šventąja Dvasia.‘ ");
INSERT INTO lit_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ir tai išgirdę, jie nutilo ir šlovino Dievą, sakydami: „Tad ir nežydams Dievas suteikė atgailą, kad gyventų.“ ");
INSERT INTO lit_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Tie gi, kurie buvo išsklaidyti į išeiviją dėl persekiojimo, kilusio dėl Stepono, nukeliavo iki Finikijos ir Kipro ir Antiochijos, skelbdami žodį niekam kitam, o vien tik žydams. ");
INSERT INTO lit_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ir Viešpaties ranka buvo su jais, ir didelis skaičius įtikėjo ir atsivertė į Viešpatį. ");
INSERT INTO lit_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Atvykęs ir pamatęs Dievo malonę, jis apsidžiaugė ir ragino juos visus, kad ryžtinga širdimi jie liktų atsidavę Viešpačiui. ");
INSERT INTO lit_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","O Dievo žodis vis klestėjo ir didėjo. ");
INSERT INTO lit_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","O Barnabas ir Saulius, išsamiai atlikę savo tarnystę, grįžo iš Jeruzalės; jie buvo pasiėmę su savimi ir Joną, vadinamą Morkumi. ");
INSERT INTO lit_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ir Antiochijoje, ten esančioje bažnyčioje, buvo tam tikri pranašai ir mokytojai, antai Barnabas, ir Simeonas, vadinamas Nigeriu, ir kirėnietis Lucijus; antai Manaenas, kuris užaugo kartu su tetrarchu Erodu, ir Saulius. ");
INSERT INTO lit_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","O jiems tarnaujant Viešpačiui ir pasninkaujant, Šventoji Dvasia tarė: „Išskirkite man abudu – Barnabą ir Saulių – darbui, kuriam aš juos pašaukiau.“ ");
INSERT INTO lit_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Tada jie, papasninkavę ir pasimeldę ir uždėję ant jų rankas, juos išsiuntė. ");
INSERT INTO lit_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ir kai Jonas baiginėjo savo gyvenimo bėgtynes, jis tarė: ‚Ką manote mane esant? Aš nesu jis. Bet štai po manęs ateina tas, kurio kojų apavo nesu vertas atrišti.‘ ");
INSERT INTO lit_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Bet Dievas jį prikėlė iš numirusių. ");
INSERT INTO lit_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Ir mes skelbiame jums gerą žinią, kad pažadą, kuris buvo duotas tėvams, ");
INSERT INTO lit_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Dievas tą patį pažadą įvykdė mums, jų vaikams, tuo, kad jis prikėlė Jėzų, kaip ir yra parašyta ir antroje psalmėje: Tu esi mano Sūnus, šiandien aš tave pagimdžiau. ");
INSERT INTO lit_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Todėl jis sako ir kitoje psalmėje: „Tu neleisi savo Šventajam patirti supuvimo“. ");
INSERT INTO lit_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Nes Dovydas, Dievo nutarimu atitarnavęs savajai kartai, užmigo ir buvo priskaičiuotas prie savo jau mirusių tėvų, ir patyrė supuvimą, ");
INSERT INTO lit_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","bet tas, kurį Dievas prikėlė, nepatyrė supuvimo. ");
INSERT INTO lit_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Taigi, žinokite, vyrai broliai, kad nuodėmių atleidimas yra skelbiamas jums per šitą vyrą, ");
INSERT INTO lit_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","ir kiekvienas, kuris tiki, yra juo išteisinamas nuo visko, nuo ko jūs negalėjote būti išteisinti Mozės įstatymu. ");
INSERT INTO lit_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Bet žydai pamatę minias pasidarė pilni pavydaus uolumo ir prieštaravo tiems dalykams, kuriuos kalbėjo Paulius, atsikalbinėdami ir piktžodžiaudami. ");
INSERT INTO lit_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Tada drąsiai kalbėdami Paulius ir Barnabas tarė: „Buvo būtina, kad Dievo žodis būtų pasakytas jums pirma; bet kadangi jūs atmetate jį ir nutariate, jog patys neverti amžino gyvenimo, štai mes sukame pas kitataučius. ");
INSERT INTO lit_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Nes Viešpats yra šitaip mums paliepęs: „Paskyriau tave kaip šviesą kitataučiams, kad būtum naudingas jų išgelbėjimui iki pat žemės pakraščių.“ ");
INSERT INTO lit_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Tai girdėdami, kitataučiai džiaugėsi ir šlovino Viešpaties žodį, ir įtikėjo visi, kurie buvo priskirti amžinam gyvenimui. ");
INSERT INTO lit_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Taigi jie ten išbuvo ilgą laiką ir drąsiai kalbėjo, remdamiesi Viešpačiu, kuris liudijo savo malonės žodį ir davė antgamtinių ženklų bei pranašiškų ženklų, kad jie būtų padaryti jų rankomis. ");
INSERT INTO lit_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Ir paskelbę Evangeliją tam miestui ir padarę daugelį mokytinių, jie sugrįžo į Listrą ir Ikonijų ir Antiochiją, ");
INSERT INTO lit_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","stiprindami mokytinių sielas, ragindami juos pasilikti ištikimi tikėjimui, ir kad mes per daugelį prispaudimų turime įeiti į Dievo karalystę. ");
INSERT INTO lit_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ir jiems paskyrę vyresniuosius kiekvienoje bažnyčioje ir pasimeldę su pasninku, jie patikėjo juos Viešpačiui, kuriuo šie tikėjo. ");
INSERT INTO lit_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","O atvykę ir surinkę bažnyčią, jie pranešė viską, ką Dievas su jais nuveikė ir kaip atvėrė tikėjimo duris kitataučiams. ");
INSERT INTO lit_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ir kai kurie, atėję žemyn iš Judėjos, ėmė mokyti tuos brolius: „Jeigu nesiduodate apipjaustomi pagal Mozės paprotį, negalite būti išgelbėti.“ ");
INSERT INTO lit_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Priešingai, mes tikime, kad būsime išgelbėti tokiu pat būdu kaip ir jie – per Viešpaties Jėzaus Kristaus malonę. ");
INSERT INTO lit_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Nuo amžinybės Dievui žinomi visi jo darbai. ");
INSERT INTO lit_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","ir per juos jie parašė šiuos dalykus: „Apaštalai ir vyresnieji ir broliai kitataučių kilmės broliams Antiochijoje, Sirijoje ir Kilikijoje: Sveiki! ");
INSERT INTO lit_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ir po kiek dienų Paulius tarė Barnabui: „Grįžkime ir pagalbon aplankykime savo brolius kiekviename mieste, kur skelbėme Viešpaties žodį, ir pažiūrėkime, kaip jiems sekasi.“ ");
INSERT INTO lit_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","O Barnabas nusprendė pasiimti su jais Joną, vadinamą Morkumi, ");
INSERT INTO lit_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","bet Paulius buvo tvirtai nusistatęs, kad labiau tiktų nepasiimti kartu tokio, kuris iš Pamfilijos nuo jų pasitraukė ir nesidarbavo su jais. ");
INSERT INTO lit_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Taigi kilo tarp jų toks aštrus nesutarimas, kad jie vienas nuo kito atsiskyrė. Ir Barnabas, pasiėmęs Morkų, išplaukė į Kiprą, ");
INSERT INTO lit_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","o Paulius, pasirinkęs Silą, iškeliavo, brolių pavestas Dievo malonei. ");
INSERT INTO lit_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ir jis perėjo per Siriją ir Kilikiją, stiprindamas bažnyčias. ");
INSERT INTO lit_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Ir jis atvyko į Derbę ir Listrą, o štai tam tikras mokytinis buvo tenai, vardu Timotiejus, – (tam tikros tikinčios žydės sūnus, bet tėvas buvo graikas), – ");
INSERT INTO lit_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","apie kurį gerai atsiliepė broliai Listroje ir Ikonijuje. ");
INSERT INTO lit_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paulius norėjo, kad jis išvyktų su juo. Tad paėmęs jis apipjaustė jį dėl tose vietose esančių žydų, nes jie visi žinojo jo tėvą esant graiką. ");
INSERT INTO lit_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ir keliaudami per miestus, jie perdavė jiems laikytis įsakų, kuriuos leido apaštalai ir vyresnieji Jeruzalėje. ");
INSERT INTO lit_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Todėl gi bažnyčios buvo stiprinamos tikėjimo atžvilgiu ir kasdien augo skaičiumi. ");
INSERT INTO lit_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Ir perėję Frigiją, taip pat Galatijos kraštą, ir Šventajai Dvasiai uždraudus jiems kalbėti žodį Azijoje, ");
INSERT INTO lit_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","po to atėję į Myziją, jie mėgino eiti į Bitiniją, bet Dvasia jiems neleido. ");
INSERT INTO lit_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ir praėję pro Myziją, jie nusileido į Troadą. ");
INSERT INTO lit_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ir naktį Pauliui pasirodė regėjimas: tam tikras vyras iš Makedonijos stovėjo ir jį maldavo, sakydamas: „Pereik į Makedoniją ir padėk mums!“ ");
INSERT INTO lit_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Ir po to, kai jis pamatė regėjimą, tuojau siekėme vykti į Makedoniją, susidarydami išvadą, kad Viešpats pašaukė mus skelbti jiems evangeliją. ");
INSERT INTO lit_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Todėl išplaukę iš Troados, leidomės tiesiu kursu į Samotrakę, o rytojaus dieną į Neapolį, ");
INSERT INTO lit_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","o iš ten į Filipus, kuris yra pagrindinis tos Makedonijos srities miestas, taip pat kolonija. O šiame mieste išbuvome kelias dienas. ");
INSERT INTO lit_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","ir išvedęs juos laukan, jis paklausė: „Gerbiamieji, ką turiu daryti, kad būčiau išgelbėtas?“ ");
INSERT INTO lit_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ir jie tarė: „Tikėk Viešpačiu Jėzumi Kristumi ir būsi išgelbėtas – tu ir tavo šeimyna!“ ");
INSERT INTO lit_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ir jie kalbėjo Viešpaties žodį jam ir visiems, esantiems jo namuose. ");
INSERT INTO lit_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ir tą pačią nakties valandą juos pasiėmęs, jis nuplovė jų kirčių žaizdas ir tuojau buvo pakrikštytas – jis pats ir visi jo saviškiai. ");
INSERT INTO lit_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ir nusivedęs juos į savo namus, jis padengė jiems stalą ir džiūgavo, pasitikėjęs Dievu kartu su visais savo namiškiais. ");
INSERT INTO lit_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","O perėję Amfipolį ir Apoloniją jie atėjo į Tesaloniką, kur buvo žydų sinagoga, ");
INSERT INTO lit_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","ir kaip buvo pratęs, Paulius įėjo pas juos ir tris šabass diskutavo su jais dėstydamas iš šventraščių, ");
INSERT INTO lit_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","atverdamas šventraščius ir teikdamas įrodymų, kad Kristui reikėjo kentėti ir prisikelti iš numirusių, ir kad: „Šis Jėzus, kurį aš jums skelbiu, yra Kristus.“ ");
INSERT INTO lit_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ir kai kurie iš jų įtikėjo ir buvo priskirti prie Pauliaus ir Silo, taip pat daugybė pamaldų graikų ir nemaža aukštuomenės moterų. ");
INSERT INTO lit_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Bet žydai, kurie atsisakė tikėti, apimti pavydo, pasiėmė tam tikrų nelabų vyrų iš turgavietės ir subūrę minią sukėlė mieste sąmyšį. Užpuolę Jasono namus, jie ieškojo jų, kad išvesti prieš liaudį. ");
INSERT INTO lit_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Bet jų neradę nusitempė Jasoną ir kai kuriuos brolius pas miesto vadovus, šaukdami: „Tie, kurie verčia pasaulį aukštyn kojomis, ir čia yra atėję! ");
INSERT INTO lit_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Juos yra priglaudęs Jasonas! Šitie visi gi veikia prieš ciesoriaus įsakus, sakydami, kad yra kitas karalius – toks Jėzus!“ ");
INSERT INTO lit_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ir jie sutrikdė minią ir miesto vadovus, kurie tuos dalykus išgirdo. ");
INSERT INTO lit_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Taigi paėmę užstatą iš Jasono ir kitų, jie juos paleido. ");
INSERT INTO lit_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Šitie buvo kilnesni negu tie Tesalonikoje tuo, kad jie priėmė žodį visišku noringumu ir kasdien tyrinėjo Šventraščius, ar taip esą iš tikrųjų. ");
INSERT INTO lit_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pauliui Atėnuose jų belaukiant, jo dvasia nervinosi jame, matydamas miestą, kuris yra visiškai stabgarbiškas. ");
INSERT INTO lit_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Tada Paulius atsistojo Marso kalvos viduryje ir tarė: „Atėnų vyrai, aš matau, kad visais atžvilgiais jūs esate nepaprastai religingi. ");
INSERT INTO lit_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","ir jis nėra aptarnaujamas žmonių rankomis, tarsi jam ko nors reikėtų, nes jis pats visiems duoda gyvybę ir alsavimą ir visa kita; ");
INSERT INTO lit_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","ir jis iš vieno kraujo padarė visas žmonių tautas tam, kad gyventų visame žemės paviršiuje, nustatęs iš anksto paskirtus laikus ir jų gyvenamos vietos ribas, ");
INSERT INTO lit_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","kad jie ieškotų Dievo – gal tikrai apčiuopomis ieškotų ir surastų jį, – nors jis yra visiškai netoli nuo kiekvieno iš mūsų, ");
INSERT INTO lit_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","nes ‚mes jame gyvename, judame ir būvame‘, kaip yra pasakę ir kai kurie jūsų poetai: ‚Mes gi esame jo palikuonys.‘ ");
INSERT INTO lit_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Tad kadangi mes esame Dievo palikuonys, neturime manyti, kad Dievybė yra panaši į auksą ar sidabrą, ar akmenį, į žmogaus meno ir vaizduotės raižybos kūrinį. ");
INSERT INTO lit_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Todėl gi Dievas, pakentęs nežinojimo laikus, dabar liepia visiems žmonėms visur atgailauti, ");
INSERT INTO lit_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","nes jis nustatė dieną, kurią yra pasirengęs teisingai teisti pasaulį per Vyrą, kurį yra paskyręs, visiems davęs užtikrinimą prikeldamas jį iš numirusiųjų.“ ");
INSERT INTO lit_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Ir išgirdę apie mirusiųjų prisikėlimą, vieni ėmė šaipytis, o kiti sakė: „Apie tai tavęs pasiklausysime kitą kartą.“ ");
INSERT INTO lit_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ir taip Paulius išėjo iš jų tarpo. ");
INSERT INTO lit_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Ir vyriausiasis sinagogos vadovas Krispas įtikėjo Viešpačiu su visa savo šeimyna. Taip pat daugelis iš korintiečių klausydamiesi įtikėjo ir buvo pakrikštyti. ");
INSERT INTO lit_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","nes aš esu su tavimi, ir niekas nesikėsins tau kenkti, nes aš turiu daug žmonių šiame mieste. ");
INSERT INTO lit_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Tada tarė Paulius: „Jonas iš tikrųjų krikštijo krikštu, kurį sąlygoja atgaila, sakydamas tautai, kad jie turi tikėti tuo, kuris turi po jo ateiti, tai yra, Kristumi Jėzumi.“ ");
INSERT INTO lit_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ir daugelis įtikėjusiųjų ateidavo išpažindami ir apsakydami dalykus, kuriais užsiimdavo. ");
INSERT INTO lit_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Taip pat daugelis tų, kurie užsiiminėdavo magija, sunešę savo knygas, sudegino jas visų akivaizdoje; ir jie apskaičiavo jų vertę ir rado ją esant penkiasdešimt tūkstančių sidabrinių. ");
INSERT INTO lit_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Šitaip Dievo žodis vis klestėjo ir ėmė viršų. ");
INSERT INTO lit_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Ir pirmąją savaitės dieną, mokytiniams susirinkus laužti duonos, Paulius jiems dėstė, ketindamas išvykti rytojaus dieną, ir užtęsė savo kalbą iki vidurnakčio. ");
INSERT INTO lit_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Ir iš Mileto jis pasiuntė žinią į Efezą ir pasikvietė bažnyčios vyresniuosius. ");
INSERT INTO lit_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","kaip nevengiau pranešti jums nieko iš to, kas naudinga, ir jus mokyti viešai ir po namus, ");
INSERT INTO lit_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","uoliai liudydamas tiek žydams, tiek ir graikams atgailą Dievo atžvilgiu ir tikėjimą mūsų Viešpaties Jėzaus Kristaus atžvilgiu. ");
INSERT INTO lit_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Bet aš nelaikau rūpimu dalyku nė vieno iš šitų dalykų, ir savo gyvybės nelaikau brangiu savo labui, kad su džiaugsmu pabaigčiau savo gyvenimo bėgtynes, tai yra tarnystę, kurią gavau iš Viešpaties Jėzaus: uoliai liudyti Dievo malonės Evangeliją. ");
INSERT INTO lit_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","O štai dabar aš žinau, kad daugiau nematysite mano veido jūs visi, tarp kurių esu perėjęs skelbdamas Dievo karalystę. ");
INSERT INTO lit_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","nes nevengiau jums paskelbti Dievo nutarimo visumos. ");
INSERT INTO lit_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Todėl saugokite save ir visą kaimenę, kuriai Šventoji Dvasia paskyrė jus prižiūrinčiaisiais, kad ganytumėte Dievo bažnyčią, kurią jis įsigijo savuoju krauju. ");
INSERT INTO lit_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Nes aš žinau tai, kad, man išvykus, pas jus įeis grobuoniški vilkai, nesigailintys kaimenės, ");
INSERT INTO lit_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","ir iš jūsų pačių kelsis vyrai, kalbantys iškreiptus dalykus, kad patrauktų mokytinius paskui save. ");
INSERT INTO lit_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Todėl budėkite, atsimindami, kad per trejus metus naktį ir dieną nepalioviau su paraginimu įspėjinėjęs kiekvieną su ašaromis. ");
INSERT INTO lit_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","O dabar, broliai, patikiu jus Dievui ir jo malonės žodžiui, kuris yra pajėgus jus statydinti ir duoti jums paveldą tarp visų pašventintųjų. ");
INSERT INTO lit_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Aš visa jums parodžiau, kad šitaip triūsdami privalote padėti silpniesiems ir atminti Viešpaties Jėzaus žodžius, nes jis sakė: „Labiau palaiminta duoti, negu imti.“ ");
INSERT INTO lit_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","O dabar, ko delsi? Kelkis, būk pakrikštytas, ir nusiplauk savo nuodėmes, šaukdamasis Viešpaties vardo.“ ");
INSERT INTO lit_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Ir jis parašė tokio tūrinio laišką: ");
INSERT INTO lit_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","„Klaudijus Lisijus Tamstos Prakilnybe valdytojau Feliksai: Sveiki! ");
INSERT INTO lit_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","tarė: „Aš tave išklausysiu, kai atvyks ir tavo kaltintojai.“ Ir liepė jį sergėti Erodo rūmuose. ");
INSERT INTO lit_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","tai mes, Tamstos Prakilnybe Feliksai, ir visaip ir visur tai pripažįstame su visišku dėkingumu. ");
INSERT INTO lit_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Nes šitą žmogų radome esant marą ir maišto kurstytoją tarp visų žydų po pasaulį ir nazariečių sektos vadeiva, ");
INSERT INTO lit_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","turėdamas į Dievą sudėtą užtikrintą viltį, kurią ir jie patys pripažįsta, kad bus mirusiųjų prisikėlimas, tiek teisiųjų, tiek neteisiųjų. ");
INSERT INTO lit_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Ir dėl šito stropiai lavinu save, kad visada turėčiau sąžinę be papiktinimo prieš Dievą ir žmones. ");
INSERT INTO lit_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Kodėl jums atrodo neįtikėtina, kad Dievas prikelia numirusius? ");
INSERT INTO lit_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","atverti jiems akis ir atgręžti juos nuo tamsybės į šviesą ir nuo Šėtono valdžios į Dievą, kad jie gautų nuodėmių atleidimą ir paveldą tarp pašventintųjų per tikėjimą manimi. ");
INSERT INTO lit_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Todėl, o karaliau Agripa, nebuvau neklusnus dangiškajam regėjimui, ");
INSERT INTO lit_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","bet pirmiausiai tiems Damaske, taip pat Jeruzalėje bei po visą Judėjos kraštą, taip pat nežydams pranešdavau, kad jie turi atgailauti ir atsiversti į Dievą darydami atgailą atitinkančius darbus. ");
INSERT INTO lit_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Taigi gavęs pagalbos iš Dievo, aš iki šios dienos tebestoviu liudydamas ir mažam, ir dideliam, nesakydamas nieko kito, kaip tik tai, ką pranašai ir Mozė kalbėjo įvyksiant, ");
INSERT INTO lit_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Ir jam besakant šiuos dalykus ginant save, Festas tarė garsiu balsu: „Pauliau, tu iš proto kraustaisi! Didelis raštas veda tave iš proto!“ ");
INSERT INTO lit_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Bet jis sako: „Aš nesikraustau iš proto, prakilnusis Festai, bet kalbu tiesos ir sveiko proto žodžius. ");
INSERT INTO lit_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Nes yra informuotas apie tuos dalykus karalius, kuriam aš drąsiai ir kalbu. Mat esu įsitikinęs, kad niekas iš tų dalykų nėra jo nepastebėtas, juoba kad tai dėjosi ne kur nors užkampyje. ");
INSERT INTO lit_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Karaliau Agripa, ar tu tiki pranašais? Žinau, kad tu tiki.“ ");
INSERT INTO lit_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Tada Agripa tarė Pauliui: „Tu mane beveik įtikini tapti kristianu. ");
INSERT INTO lit_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Todėl, vyrai, būkite optimistiškai nusiteikę, nes tikiu Dievu, kad bus taip, kaip man pasakyta. ");
INSERT INTO lit_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Ir iš ten broliai, išgirdę apie mus, išėjo mūsų pasitikti iki Apijaus forumo ir Trijų Tavernų. Juos išvydęs Paulius padėkojo Dievui ir įgavo drąsos. ");
INSERT INTO lit_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Todėl tebūna jums žinoma, kad šis Dievo išgelbėjimas yra pasiųstas kitataučiams, ir jie jo klausysis!“ ");
INSERT INTO lit_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Paulius, Jėzaus Kristaus tarnas, pašauktas apaštalas, išskirtas Dievo evangelijai, ");
INSERT INTO lit_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","kurią jis iš anksto pažadėjo per savo pranašus Šventuosiuose Raštuose, ");
INSERT INTO lit_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","apie jo Sūnų Jėzų Kristų, mūsų Viešpatį, kuris kūno atžvilgiu pasidarė iš Dovydo sėklos ");
INSERT INTO lit_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","ir pagal šventumo Dvasią buvo paskelbtas galingu Dievo Sūnumi per prisikėlimą iš numirusių, ");
INSERT INTO lit_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","per kurį mes gavome malonę ir apaštalystę, kad jo vardo labui būtų paklusnumas tikėjimui tarp visų kitataučių, ");
INSERT INTO lit_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","tarp kurių esate ir jūs – Jėzaus Kristaus pašauktieji; ");
INSERT INTO lit_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","visiems Romoje esantiems Dievo mylimiesiems, pašauktiems šventiesiems. Malonė jums ir ramybė nuo Dievo, mūsų Tėvo, ir Viešpaties Jėzaus Kristaus. ");
INSERT INTO lit_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Pirmiausia aš dėkoju savo Dievui per Jėzų Kristų už jus visus, kad jūsų tikėjimas yra apskelbiamas visame pasaulyje. ");
INSERT INTO lit_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Nes Dievas, kuriam aš tarnauju savo dvasia jo Sūnaus Evangelijoje, yra mano liudytojas, kaip be paliovos miniu jus savo maldose, visuomet ");
INSERT INTO lit_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","prašydamas, kad kokiu nors būdu dabar – pagaliau – Dievo valioje sėkmingai nukeliaučiau pas jus. ");
INSERT INTO lit_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Nes aš trokštu jus pamatyti, kad galėčiau jums duoti kokią dvasinę dovaną jūsų sutvirtinimui, ");
INSERT INTO lit_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","tai yra, kad būčiau pas jus paskatinamas bei guodžiamas kartu su jumis per bendrą tikėjimą – ir jūsų ir mano. ");
INSERT INTO lit_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Bet nenoriu, broliai, kad nežinotumėte, jog daug kartų nusistačiau atvykti pas jus, – bet iki šiol buvau sukliudytas, – kad turėčiau kiek vaisių ir tarp jūsų, kaip ir tarp kitų kitataučių. ");
INSERT INTO lit_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Aš esu skolininkas tiek graikams, tiek barbarams, tiek išmintingiems, tiek neišmanantiems. ");
INSERT INTO lit_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Taigi mano būsena tokia – esu noringas skelbti Evangeliją ir jums, esantiems Romoje, ");
INSERT INTO lit_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","nes aš nesigėdiju Kristaus Evangelijos, kadangi ji yra Dievo jėga išgelbėti kiekvienam, kuris pasitiki, pirma žydui, taip pat ir graikui; ");
INSERT INTO lit_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","nes joje Dievo teisumas apreiškiamas iš tikėjimo į tikėjimą, kaip yra parašyta: O teisusis tikėjimu gyvens. ");
INSERT INTO lit_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Nes iš Dangaus apreiškiama Dievo rūstybė ant kiekvienos bedievystės ir kiekvieno neteisumo žmonių, kurie tiesą užgniaužia neteisumu, ");
INSERT INTO lit_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","todėl, kad tai, kas akivaizdžiai žinoma apie Dievą, jiems yra aišku, kadangi Dievas jiems aiškiai parodė. ");
INSERT INTO lit_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Nes jo nematomos ypatybės – tiek jo amžinoji jėga, tiek ir dievystė – yra aiškiai matomos nuo pasaulio sukūrimo, suvokiamos per kūrinius; dėl to jie yra nepateisinami, ");
INSERT INTO lit_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","todėl kad, pažinę Dievą, nei šlovino jo kaip Dievo, nei dėkojo, bet savo sumanymų atžvilgiu jie pasidarė beprasmiais, ir jų neišmani širdis sutemo. ");
INSERT INTO lit_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Teigdamiesi esą išmintingi, jie sukvailėjo ");
INSERT INTO lit_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","ir negendančio Dievo šlovę išmainė į tai, kas panašu į gendančio žmogaus, ir paukščių, ir keturkojų, ir roplių atvaizdą. ");
INSERT INTO lit_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Todėl ir Dievas taip juos perdavė netyrumui per jų pačių širdžių geidulius, kad tarpusavyje jie gėdingai elgėsi su savo kūnais. ");
INSERT INTO lit_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Jie Dievo tiesą išmainė į melą ir garbino bei tarnavo verčiau tam, kas sukurta, negu Kūrėjui, kuris yra palaimintas amžinai. Amen. ");
INSERT INTO lit_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Dėl šios priežasties Dievas juos perdavė į gėdingas aistras, nes ir jų moteriškės išmainė fiziškai prigimtinį santykiavimą į fizinei prigimčiai priešingą; ");
INSERT INTO lit_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","tokiu pat būdu ir vyriškiai, palikę fiziškai prigimtinį santykiavimą su moteriške, savo pageidime užsidegė vienas kitam, vyriškiai su vyriškiais darydami tai, kas gėdos verta, ir gaudami savyje būtiną atpildą už savo nuklydimą. ");
INSERT INTO lit_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Ir lygiai kaip jie nelaikė priimtina aiškiame pažinime išlaikyti Dievo, Dievas juos perdavė į atmestinai vertintą protavimo būseną daryti neprideramų dalykų. ");
INSERT INTO lit_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Jie – pripildyti visokio neteisumo, paleistuvystės, piktybės, gobšumo, blogumo; jie – pilni pavydo, žmogžudystės, nesantaikos, suktybės, piktos valios; jie – šnibždeikos, ");
INSERT INTO lit_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","šmeižikai, nekenčiantys Dievo, įžūlūs, išdidūs, pagyrūnai, blogo išradėjai, neklusnūs tėvams, ");
INSERT INTO lit_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","neišmanūs, nesilaikantys susitarimų, nebranginantys artimųjų, nesutaikomi, negailestingi. ");
INSERT INTO lit_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Jie, puikiai žinodami Dievo teisingą sprendimą, kad tie, kurie daro tokius dalykus, yra mirties verti, ne tik juos daro, bet ir visiškai pritaria taip darantiems. ");
INSERT INTO lit_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Todėl esi nepateisinamas, kas bebūtum, o žmogau, kuris teisi, nes dėl ko teisi kitą, dėl to paties nuteisi save, kadangi tu, kuris teisi, darai tuos pačius dalykus. ");
INSERT INTO lit_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Bet mes žinome, kad Dievo teismas prieš tuos, kurie daro tokius dalykus, remiasi tiesa. ");
INSERT INTO lit_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Ir ar taip manai, o žmogau, kuris teisi tokius dalykus darančius ir pats juos darai, kad tu išvengsi Dievo teismo?! ");
INSERT INTO lit_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Arba, ar tu niekini jo gerumo bei pakantumo bei didžios kantrybės turtus, nenutuokdamas, kad Dievo gerumas veda tave į atgailą? ");
INSERT INTO lit_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Bet savo užkietėjimu ir neatgailaujančia širdimi pats sau kaupi rūstybę rūstybės ir Dievo teisingo nuosprendžio apreiškimo dienai; ");
INSERT INTO lit_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","jisai atlygins kiekvienam pagal jo darbus: ");
INSERT INTO lit_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","viena vertus, amžinu gyvenimu tiems, kurie, ištvermingai darydami gera, ieško šlovės ir garbės ir negendamumo, ");
INSERT INTO lit_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","bet kita vertus, įtūžiu ir rūstybe tiems, kurie yra priešiški garbėtroškos ir atsisako būti tiesos įtikinti bei jai paklusti, bet yra neteisumo įtikinami ir jam paklusta; ");
INSERT INTO lit_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","prispaudimas ir sielvartas sielai kiekvieno žmogaus, kuris įvykdo bloga, pirma žydui, taip pat ir graikui; ");
INSERT INTO lit_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","bet šlovė, pagarba ir ramybė kiekvienam, darančiam gera – pirma žydui, taip pat ir graikui. ");
INSERT INTO lit_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Priežastis yra tokia: Dievas nėra šališkas. ");
INSERT INTO lit_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Nes visi, kurie nusidėjo be Įstatymo, be Įstatymo ir pražus; ir visi, kurie nusidėjo Įstatymo ribose, bus Įstatymu teisiami – ");
INSERT INTO lit_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","(nes ne Įstatymo atidūs klausytojai teisūs Dievo akivaizdoje, bet Įstatymo atlikėjai bus išteisinti, ");
INSERT INTO lit_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","nes kada tik kitataučiai, kurie neturi Įstatymo, iš prigimties daro Įstatymo numatytų dalykų, šitie, neturėdami Įstatymo, yra patys sau įstatymas: ");
INSERT INTO lit_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","tokie parodo savo širdyse įrašytą įstatymo darbą, jų sąžinei kartu tiems dalykams paliudijant, ir jų mintims tuo tarpu juos kaltinant arba net ginant) – ");
INSERT INTO lit_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","tą dieną, kai Dievas, anot mano evangelijos, teis žmonių paslaptis per Jėzų Kristų. ");
INSERT INTO lit_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Žiūrėk! Tu vadiniesi žydas, ir pasikliauji įstatymu, ir giriesi Dievu, ");
INSERT INTO lit_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ir žinai jo valią, ir iš įstatymo pamokytas, laikai išmėgintais bei priimtinais tuos dalykus, kurie yra geriausi, ");
INSERT INTO lit_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","be to, esi įsitikinęs esąs aklųjų vedlys, šviesa tų, kurie yra tamsoje, ");
INSERT INTO lit_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","kvailųjų auklėtojas, vaikelių mokytojas, įstatyme turįs pažinimo ir tiesos įkūnijimą. ");
INSERT INTO lit_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Taigi, tu, kuris mokai kitą, ar savęs nepamokai? Tu, kuris skelbi, kad nevalia vogti, ar tu vagi? ");
INSERT INTO lit_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Tu, kuris sakai, kad nevalia svetimauti, ar tu svetimauji? Tu, kuris bjauriesi stabais, ar apiplėši šventoves? ");
INSERT INTO lit_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Tu, kuris giriesi įstatymu, įstatymo laužymu ar darai Dievui negarbę? ");
INSERT INTO lit_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Nes, kaipgi yra parašyta, DĖL JŪSŲ ŠMEIŽIAMAS DIEVO VARDAS TARP KITATAUČIŲ. ");
INSERT INTO lit_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Nes apipjaustymas iš tiesų naudingas, jei vykdai įstatymą, bet jei esi įstatymo laužytojas, tavo apipjaustymas yra tapęs neapipjaustymu. ");
INSERT INTO lit_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Todėl, jei neapipjaustytasis laikytųsi įstatymoteisumo, argi jo neapipjaustymas nebus įskaitytas kaip apipjaustymas? ");
INSERT INTO lit_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Ir, argi iš prigimties neapipjaustytasis, kuris vykdo įstatymą, neteis tavęs, kuris turėdamas įstatymo raidę ir apipjaustymą, esi įstatymo laužytojas? ");
INSERT INTO lit_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Nes tas nėra žydas, kuris yra toks išoriškai, ir tas nėra apipjaustymas, kuris išoriškas, kūne atliktas; ");
INSERT INTO lit_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","bet tas yra žydas, kuris toks viduje, ir tas yra apipjaustymas, kuris yra Dvasia – ne raide – atliktas širdies apipjaustymas; tokiam pagyrimas ateina ne iš žmonių, bet iš Dievo. ");
INSERT INTO lit_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Koks tada žydo pranašumas arba kokia apipjaustymo nauda? ");
INSERT INTO lit_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Didžiulė – kiekvienu atžvilgiu! Svarbiausia gi tikrai, kad jiems buvo patikėti Dievo pranašiški pranešimai. ");
INSERT INTO lit_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","O tai kas, jeigu kai kurie netikėjo? Ar jų netikėjimas Dievo ištikimybę pavers niekais? ");
INSERT INTO lit_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Anaiptol! Ne! Verčiau, Dievas tesirodo tiesakalbis, bet kiekvienas žmogus – melagis, kaip yra parašyta: Kas būtum išteisintas savo pasakymais ir laimėtum, kai teisiamsi su tavimi. ");
INSERT INTO lit_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Bet jei mūsų neteisumas Dievo teisumą daro ryškų, ką mes sakysime?! Ar Dievas neteisus, kuris išlieja rūstybę?! (Kalbu kaip žmonėms būdinga.) ");
INSERT INTO lit_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Anaiptol! Ne! Kaip tada Dievas teis pasaulį?! ");
INSERT INTO lit_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Toks būtų pagrindas: jei per mano melagystę Dievo tiesa plėtojosi jo šlovei, tai kam aš dar teisiamas kaip nusidėjėlis? ");
INSERT INTO lit_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Ir kodėl ne šitaip – (kaip esame šmeižiami, ir kaip kai kurie tvirtina mus sakant): „Darykime bloga, kad išeitų gera?“ Tokių nuteisimas yra teisingas. ");
INSERT INTO lit_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Ką gi? Ar mes geresni? Visai ne! Nes mes prieš tai įrodėme, kad tiek žydai, tiek graikai – visi yra nuodėmės valdžioje, ");
INSERT INTO lit_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","kaip yra parašyta: NĖRA TEISAUS, NĖRA NĖ VIENO. ");
INSERT INTO lit_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","NĖRA IŠMANANČIO, NĖRA KAS DIEVO IEŠKO. ");
INSERT INTO lit_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","JIE VISI NUSISUKO NUO KELIO, KARTU PASIDARĖ NENAUDINGI; NĖRA KAS DARO GERA, NĖRA NĖ VIENO. ");
INSERT INTO lit_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","JŲ GERKLĖ ATVERSTAS KAPAS, SAVO LIEŽUVIAIS JIE APGAUDINĖJA, GYVAČIŲ NUODAI PO JŲ LŪPOMIS. ");
INSERT INTO lit_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","JŲ BURNA PILNA KEIKSMO IR KARTUMO. ");
INSERT INTO lit_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","JŲ KOJOS EIKLIOS KRAUJUI IŠLIETI, ");
INSERT INTO lit_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","JŲ KELIUOSE SUNAIKINIMAS IR NELAIMĖ, ");
INSERT INTO lit_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","IR TAIKOS KELIO JIE NEPAŽINO; ");
INSERT INTO lit_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","PRIEŠ JŲ AKIS NĖRA DIEVO BAIMĖS. ");
INSERT INTO lit_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Mes gi žinome, kad ką tik sako įstatymas, jis sako tiems, kurie to įstatymo ribose, kad būtų užčiaupta kiekviena burna, ir visas pasaulis būtų kaltas prieš Dievą. ");
INSERT INTO lit_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Todėl įstatymo darbais jo akyse nebus išteisintas joks kūnas, nes per įstatymą nuodėmė aiškiai suvokiama. ");
INSERT INTO lit_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Bet dabar yra apreikštas Dievo teisumas – (atskiras nuo įstatymo), – apie kurį liudija Įstatymas ir Pranašai, – ");
INSERT INTO lit_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","tai – Dievo teisumas, kuris per tikėjimą Jėzumi Kristumi yra visų labui ir yra ant visų, kurie tiki, – (nes nėra jokio skirtumo, ");
INSERT INTO lit_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","kadangi visi nusidėjo ir stokoja Dievo šlovės) – ");
INSERT INTO lit_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","kurie išteisinami dovanai jo malone per išpirkimą, kuris yra Kristuje Jėzuje, ");
INSERT INTO lit_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","kurį Dievas viešai išstatė esant rūstybę numaldavusi auka, veikianti per tikėjimą jo krauju, kad parodytų savo teisumą anksčiau padarytų nusidėjimų nenubaudimo atžvilgiu, veikiant Dievo pakantumui, ");
INSERT INTO lit_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","jog dabartiniu metu parodytų savo teisumą – kad jis būtų teisus ir išteisinantis tą, kuris pasitiki Jėzumi. ");
INSERT INTO lit_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Kur gi tada pasigyrimas? Jis pašalintas. Kokiu įstatymu? Darbų? Ne, verčiau tikėjimo įstatymu. ");
INSERT INTO lit_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Todėl mes darome išvadą, kad, įstatymo darbams esant nesusijusiems, žmogus išteisinamas tikėjimu. ");
INSERT INTO lit_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Ar jis vien tik žydų Dievas? Bet argi jis nėra ir kitataučių? Taip, ir kitataučių, ");
INSERT INTO lit_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","kadangi tėra vienas Dievas, kuris išteisins apipjaustytąjį tikėjimu ir neapipjaustytąjį per tikėjimą. ");
INSERT INTO lit_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Ar tuomet mes įstatymą paverčiame niekais per tikėjimą? Anaiptol! Ne! Priešingai, mes patvirtiname įstatymą. ");
INSERT INTO lit_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Taigi, ką sakysime, kad mūsų tėvas Abraomas įgijo pagal kūną?! ");
INSERT INTO lit_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Nes jeigu Abraomas buvo išteisintas darbais, jis turi kuo pasigirti – tik ne prieš Dievą. ");
INSERT INTO lit_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Nes ką gi sako šventraštis? Abraomas pasitikėjo Dievu, ir tai jam buvo įskaityta kaip teisumas. ");
INSERT INTO lit_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","O tam, kuris dirba, atlygis įskaitomas remiantis ne malone, bet remiantis įsiskolinimu. ");
INSERT INTO lit_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Tačiau tam, kuris nedirba, bet tiki tuo, kuris išteisina bedievį, jo tikėjimas yra įskaitomas kaip teisumas. ");
INSERT INTO lit_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Lygiai kaip ir Dovydas pareiškia palaiminimą žmogaus, kuriam Dievas įskaito teisumą, žmogaus darbams esant nesusijusiems: ");
INSERT INTO lit_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","Palaiminti tie, kurių įstatymo pažeidimai atleisti ir kurių nuodėmės uždengtos. ");
INSERT INTO lit_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Palaimintas žmogus, kuriam Viešpats niekaip neįskaitys nuodėmės. ");
INSERT INTO lit_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Ar tad šitas palaiminimas pareiškiamas tik apipjaustytojo atžvilgiu, ar taip pat neapipjaustytojo atžvilgiu? Nes mes sakome, kad Abraomui tikėjimas buvo įskaitytas kaip teisumas. ");
INSERT INTO lit_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Tad kokiomis aplinkybėmis jis buvo įskaitytas? Ar jam esant apipjaustytam ar neapipjaustytam? Jam nesant apipjaustytam, bet esant neapipjaustytam. ");
INSERT INTO lit_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Ir jis gavo apipjaustymo ženklą, tikėjimo teisumo antspaudą, kurį tikėjimą jis turėjo būdamas neapipjaustytas, kad jis būtų tėvas visų, kurie, nors neapipjaustyti, tiki, kad ir jiems būtų įskaitytas teisumas, ");
INSERT INTO lit_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","ir apipjaustytųjų tėvas – tiems, kurie ne tik apipjaustyti, bet ir vaikščioja padoriai pėdomis mūsų tėvo Abraomo tikėjimo, kurį jis turėjo, būdamas dar neapipjaustytas. ");
INSERT INTO lit_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Štai kodėl: ne per įstatymą atiteko Abraomui arba jo sėklai pažadas, kad jis bus pasaulio paveldėtojas, bet per tikėjimo teisumą. ");
INSERT INTO lit_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Nes jei paveldėtojai tie, kurie yra iš įstatymo, tai tikėjimas yra padarytas tuščiu, ir pažadas paverstas niekais, ");
INSERT INTO lit_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","kadangi įstatymas sukelia rūstybę, nes kur nėra įstatymo, ten nėra nusižengimo. ");
INSERT INTO lit_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Dėl tos priežasties paveldėjimas yra iš tikėjimo, idant atitiktų malonę, kad pažadas būtų garantuotas ištisai sėklai, ne tik tai, kuri iš įstatymo, bet ir tai, kuri iš tikėjimo Abraomo, kuris yra mūsų visų tėvas ");
INSERT INTO lit_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","(kaip yra parašyta: Aš padariau tave daugelio tautų tėvu); jis yra mūsų visų tėvas akivaizdoje Dievo, kuriuo pasitikėjo, kuris suteikia gyvybę mirusiesiems ir vadina tuos dalykus, kurių nėra, tarsi jie jau būtų. ");
INSERT INTO lit_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Priešingai vilčiai jis tikėjo su viltimi tam, kad taptų daugelio tautų tėvu, anot to, kas buvo pasakyta: Tokia bus tavo sėkla. ");
INSERT INTO lit_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Ir tikėjimo atžvilgiu nebūdamas silpnas, jis nekreipė rimto dėmesio į savo jau apmirusį kūną – jam buvo arti šimto metų – ir Saros įsčių numirimą, ");
INSERT INTO lit_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","taip pat jis neabejojo Dievo pažadu per netikėjimą, bet per tikėjimą buvo stiprinamas, duodamas Dievui šlovę ");
INSERT INTO lit_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","ir būdamas visiškai įsitikinęs, jog ką jis yra pažadėjęs, jis pajėgia ir įvykdyti. ");
INSERT INTO lit_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Dėl to tai jam ir buvo įskaityta kaip teisumas. ");
INSERT INTO lit_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Tačiau buvo parašyta ne vien jo naudai, kad buvo jam įskaityta, ");
INSERT INTO lit_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","bet ir mūsų naudai, kuriems numatyta įskaityti – pasitikintiems tuo, kuris prikėlė iš numirusiųjų Jėzų, mūsų Viešpatį, ");
INSERT INTO lit_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","kuris buvo atiduotas dėl mūsų nusižengimų ir buvo prikeltas dėl mūsų išteisinimo. ");
INSERT INTO lit_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Taigi, būdami išteisinti tikėjimu, turime taiką su Dievu per mūsų Viešpatį Jėzų Kristų, ");
INSERT INTO lit_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","per kurį tikėjimu turime ir įėjimą į šią malonę, kurioje stovime, ir giriamės Dievo šlovės užtikrinta viltimi. ");
INSERT INTO lit_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Ir ne vien tuo, bet mes taip pat giriamės prispaudimais, žinodami, kad prispaudimas sukelia ištvermę, ");
INSERT INTO lit_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","ištvermė – išbandymus išlaikiusį būdą, išbandymus išlaikęs būdas – užtikrintą viltį. ");
INSERT INTO lit_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","O užtikrinta viltis nesugėdina, nes Dievo meilė yra išlieta mūsų širdyse per mums duotą Šventąją Dvasią. ");
INSERT INTO lit_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Nes, mums dar tebesant bejėgiams, Kristus kaip tik laiku mirė už bedievius. ");
INSERT INTO lit_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Nes vargu ar kas mirtų už teisų žmogų; nors už gerą žmogų galbūt kas ir išdrįstų numirti. ");
INSERT INTO lit_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Bet Dievas rodo savo meilę mums tuo, kad Kristus numirė už mus, kai tebebuvome nusidėjėliai. ");
INSERT INTO lit_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Taigi daug labiau, mes – dabar išteisinti jo krauju, – būsime per jį išgelbėti nuo rūstybės. ");
INSERT INTO lit_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Nes jeigu, būdami priešai, buvome sutaikinti su Dievu jo Sūnaus mirtimi, tai daug labiau, būdami sutaikinti, būsime išgelbėti jo gyvenimu. ");
INSERT INTO lit_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Ir ne vien tai, bet mes taip pat giriamės Dievu per mūsų Viešpatį Jėzų Kristų, per kurį mes dabar gavome sutaikinimą. ");
INSERT INTO lit_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Todėl, kaip per vieną žmogų nuodėmė įėjo į pasaulį, ir per nuodėmę mirtis, ir tokiu būdu mirtis perėjo į visus žmones, kadangi visi nusidėjo – ");
INSERT INTO lit_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","nes iki įstatymo nuodėmė buvo pasaulyje, bet nuodėmė nepriskaitoma, kai nėra įstatymo. ");
INSERT INTO lit_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Vis dėlto mirtis viešpatavo nuo Adomo iki Mozės net tiems, kurie nenusidėjo nusižengimu, panašiu į Adomo, kuris yra pirmavaizdis to, kuris turėjo ateiti. ");
INSERT INTO lit_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Bet ir maloninga dovana šitaip nepanaši į nusižengimą: nes jei vieno nusižengimu daugelis mirė, tai daug labiau Dievo malonė, tai yra dovana malonėje, suteikta vieno žmogaus, Jėzaus Kristaus, apstėjo daugeliui. ");
INSERT INTO lit_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Ir ne taip, kaip įvyko per vieną nusidėjusį, yra su dovana, nes iš tikrųjų teismas iš vieno nusižengimo atvedė į nuteisimą, bet maloninga dovana iš daugelio nusižengimų – į išteisinimą. ");
INSERT INTO lit_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Nes jei per vieno nusižengimą mirtis viešpatavo per vieną, tai daug labiau tie, kurie priima malonės ir teisumo dovanos apstumą, viešpataus gyvenime per vieną, Jėzų Kristų. ");
INSERT INTO lit_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Išvada tokia: kaip per vieno nusižengimą visiems žmonėms atsirado nuteisimas, taip per vieno teisumą visiems žmonėms atsirado išteisinimas, kad gyventų. ");
INSERT INTO lit_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Nes kaip per vieno žmogaus neklusnumą daugelis buvo paskirti nusidėjėliais, taip per vieno klusnumą daugelis bus paskirti teisiais. ");
INSERT INTO lit_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","O įstatymas įsiterpė, kad nusižengimas padidėtų. Bet kur nuodėmė padidėjo, malonė dar labiau didžiai apstėjo, ");
INSERT INTO lit_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","kad kaip nuodėmė viešpatavo sukeldama mirtį, taip malonė viešpatautų per teisumą į amžiną gyvenimą per Jėzų Kristų, mūsų Viešpatį. ");
INSERT INTO lit_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Tad ką gi sakysime? Ar mums pasilikti nuodėmėje, kad apstėtų malonė? ");
INSERT INTO lit_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Anaiptol! Ne! Kaipgi mes, kurie mirėme nuodėmei, toliau joje gyventume? ");
INSERT INTO lit_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Arba ar nežinote, kad mes visi, kurie buvome pakrikštyti į Jėzų Kristų, buvome pakrikštyti į jo mirtį? ");
INSERT INTO lit_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Taigi per krikštą buvome palaidoti su juo į mirtį, kad kaip Kristus buvo prikeltas iš numirusiųjų per Tėvo šlovę, tokiu pat būdu ir mes vaikščiotume gyvybės naujume. ");
INSERT INTO lit_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Nes kadangi esame pasidarę sujungti kartu su jo mirties panašumu, tikrai būsime sujungti ir su jo prisikėlimo panašumu, ");
INSERT INTO lit_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","žinodami tai, kad mūsų senasis žmogus buvo su juo nukryžiuotas, kad nuodėmės kūnas būtų padarytas neveiksmingas, kad nuo šiol mes nebevergautume nuodėmei. ");
INSERT INTO lit_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Priežastis tokia: kas yra miręs, yra teisiškai išvaduotas iš nuodėmės. ");
INSERT INTO lit_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Štai gi, jei mes esame mirę su Kristumi, tikime, kad ir gyvensime su juo, ");
INSERT INTO lit_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","žinodami, kad Kristus, prikeltas iš numirusių, nebemiršta; mirtis jam nebeviešpatauja. ");
INSERT INTO lit_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Nes kad jis numirė, jis numirė nuodėmei vieną kartą galutinai, bet kad jis gyvena, jis gyvena Dievui. ");
INSERT INTO lit_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Ir jūs save laikykite tokiu pat būdu faktiškai mirusiais nuodėmei, bet gyvais Dievui per Jėzų Kristų, mūsų Viešpatį. ");
INSERT INTO lit_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Taigi neleiskite nuodėmei viešpatauti jūsų mirtingame kūne, kurio viešpatavimo padarinys yra paklusnumas jai per jo geidulius. ");
INSERT INTO lit_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Ir neduokite nuodėmei savo narių kaip neteisumo įrankių, bet duokite save Dievui kaip gyvus iš numirusiųjų ir savo narius kaip teisumo įrankius Dievui. ");
INSERT INTO lit_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Nes nuodėmė neturi jums viešpatauti, nes esate ne įstatymo, bet malonės valdžioje. ");
INSERT INTO lit_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Tai ką gi? Ar mums nusidėti, kadangi nebesame įstatymo valdžioje, bet malonės valdžioje? Anaiptol! Ne! ");
INSERT INTO lit_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Ar nežinote, kad būdami pasidavę kam nors paklusniai tarnauti, būnate tarnai to, kuriam paklūstate: arba tarnai nuodėmės, kurios rezultatas – mirtis, arba tarnai paklusnumo, kurio rezultatas – teisumas? ");
INSERT INTO lit_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Bet ačiū Dievui, kad nors buvote nuodėmės tarnai, tačiau iš širdies paklusote tai mokslo normai, kuriai buvote perduoti, ");
INSERT INTO lit_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","ir patyrę išlaisvinimą iš nuodėmės, jūs buvote padaryti teisumo tarnais. ");
INSERT INTO lit_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","(Vartoju žmonėms įprastą sąvoką dėl jūsų kaip fizinių būtybių silpnumo.) Nes kaip buvote atidavę savo narius tarnais nešvarumui ir įstatymo pažeidimui, kurio atidavimo rezultatas – įstatymo pažeidimas, taip dabar atiduokite savo narius tarnais teisumui, kurio atidavimo rezultatas – šventumas. ");
INSERT INTO lit_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Nes kai jūs buvote nuodėmės tarnai, buvote laisvi nuo teisumo. ");
INSERT INTO lit_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Kokį, tada, vaisių jūs turėjote iš tų dalykų, kurių dabar gėdijatės?! Nes tų dalykų galutinis rezultatas – mirtis. ");
INSERT INTO lit_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Bet dabar, išlaisvinti iš nuodėmės ir padaryti tarnais Dievui, jūs turite savo vaisių, lemiantį šventumą ir galutinį rezultatą – amžiną gyvenimą. ");
INSERT INTO lit_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Nes nuodėmės atlygis – mirtis, o Dievo dovana – amžinas gyvenimas per Kristų Jėzų, mūsų Viešpatį. ");
INSERT INTO lit_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Arba ar jūs nežinote, broliai – nes kalbu žinantiems įstatymą, – kad įstatymas viešpatauja žmogui tol, kol jis gyvena? ");
INSERT INTO lit_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Nes ištekėjusi moteris yra įstatymu susaistyta su vyru tol, kol jis gyvena; bet jei vyras numirtų, ji yra atleista nuo savo vyro įstatymo. ");
INSERT INTO lit_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Išvada tokia: jeigu ji susituoktų su kitu vyru, kol dar gyvena jos vyras, ji bus vadinama svetimautoja; bet jeigu jos vyras mirtų, ji yra laisva nuo to įstatymo taip, kad ji nėra svetimautoja, nors ji ir susituokusi su kitu vyru. ");
INSERT INTO lit_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Taigi, mano broliai, ir jūs buvote padaryti mirusiais įstatymui – per Kristaus kūną, – kad susituoktumėte su kitu, su tuo, kuris buvo prikeltas iš numirusių, kad neštume vaisių Dievui. ");
INSERT INTO lit_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Nes kol buvome kūniškoje padėtyje, nuodėmių potraukiai, kurie pažadinti per įstatymą, veikė mūsų nariuose, kad neštų vaisių mirčiai. ");
INSERT INTO lit_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Bet dabar esame atleisti nuo mirusiojo įstatymo, kuriame buvome laikomi, kad mes tarnautume nauju – Dvasios – būdu, o ne senu – rašytinio teksto – būdu. ");
INSERT INTO lit_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Taigi, ką sakysime? Ar įstatymas yra nuodėmė? Anaiptol! Ne! Priešingai, aš nebūčiau pažinęs nuodėmės, jei ne per įstatymą; nes ir pageidimo nebūčiau suvokęs, jei įstatymas nebūtų pasakęs: „Negeisk!“ ");
INSERT INTO lit_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Bet nuodėmė, pasinaudodama proga per įsakymą, veikė manyje visokeriopą pageidimą, nes be įstatymo nuodėmė buvo mirusi. ");
INSERT INTO lit_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","O aš kadaise buvau gyvas be įstatymo, bet įsakymui atėjus, nuodėmė atgijo, ir aš numiriau, ");
INSERT INTO lit_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","ir man paaiškėjo, kad tas pats įsakymas, kuris buvo laikomas vedančiu į gyvenimą, veda į mirtį. ");
INSERT INTO lit_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Nes nuodėmė, pasinaudojusi proga per įsakymą, mane apgavo ir per jį mane nužudė. ");
INSERT INTO lit_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Taigi įstatymas iš tiesų yra šventas, ir įsakymas – šventas ir teisingas ir geras. ");
INSERT INTO lit_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Vadinasi, geras dalykas pasidarė man mirtimi?! Anaiptol! Ne! Priešingai, nuodėmė, kad ji pasirodytų esanti nuodėmė, per gerą dalyką sukėlė man mirtį, kad nuodėmė per įstatymą pasidarytų matoma kaip apsčiai nuodėminga. ");
INSERT INTO lit_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Nes žinome, kad įstatymas yra dvasiškas, bet aš esu kūniškas – mane pardavė nuodėmės valdžion. ");
INSERT INTO lit_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Nes nesuprantu, ką darau, nes ko aš noriu, to nedarau, bet ko nekenčiu, tai darau. ");
INSERT INTO lit_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Bet jei darau tai, ko nenoriu, aš pritariu Įstatymui, kad jis geras. ");
INSERT INTO lit_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Taigi dabar jau nebe aš tai darau, bet manyje gyvenanti nuodėmė. ");
INSERT INTO lit_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Nes žinau, kad manyje (tai yra mano kūniškajame aš) negyvena nieko gero; nes norėti yra man po ranka, bet nerandu kaip gera daryti. ");
INSERT INTO lit_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Nes nedarau gera, ko noriu, bet bloga, ko nenoriu, tą darau. ");
INSERT INTO lit_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Bet jei darau tai, ko nenoriu, tai nebe aš tai darau, bet manyje gyvenanti nuodėmė. ");
INSERT INTO lit_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Taigi randu tokį įstatymą, kad, kai noriu daryti gera, bloga yra man po ranka. ");
INSERT INTO lit_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Juk pagal vidinį žmogų Dievo įstatymu gėriuosi, ");
INSERT INTO lit_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","bet savo nariuose įžiūriu kitokį įstatymą, kariaujantį prieš mano proto įstatymą ir paimantį mane į nelaisvę nuodėmės įstatymui, kuris yra mano nariuose. ");
INSERT INTO lit_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Vargšas aš žmogus! Kas mane išvaduos iš šitos mirties kūno? ");
INSERT INTO lit_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","(Dėkoju Dievui už išgelbėjimą per Jėzų Kristų, mūsų Viešpatį!) Išvada tokia: aš pats protu tarnauju Dievo įstatymui, bet kūniškuoju aš – nuodėmės įstatymui. ");
INSERT INTO lit_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Todėl dabar nėra jokio nuteisimo tiems, kurie Kristuje Jėzuje, kurie vaikščioja ne pagal kūniškumą, bet pagal Dvasią. ");
INSERT INTO lit_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Nes gyvybės Dvasios įstatymas Kristumi Jėzumi išlaisvino mane iš nuodėmės ir mirties įstatymo. ");
INSERT INTO lit_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Nes įstatymui esant bejėgiui tam, kadangi buvo silpnas per kūną, Dievas, atsiuntęs savo Sūnų nuodėmingo kūno panašume ir už nuodėmę, nuteisė nuodėmę kūne, ");
INSERT INTO lit_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","kad įstatymo teisumas išsipildytų mumyse, kurie vaikščiojame ne pagal kūniškumą, bet pagal Dvasią. ");
INSERT INTO lit_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Nes tie, kurie yra pagal kūniškumą, turi į kūno dalykus nukreiptą nusistatymą, bet tie, kurie pagal Dvasią – į Dvasios dalykus. ");
INSERT INTO lit_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Nes kūniškas nusistatymas yra mirtis, bet dvasiškas nusistatymas yra gyvenimas ir ramybė, ");
INSERT INTO lit_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","kadangi kūniškas nusistatymas yra priešiškumas Dievui; jis gi nepasiduoda Dievo įstatymo valdomas, nė nepajėgia pasiduoti. ");
INSERT INTO lit_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","O tie, kurie yra kūniškoje padėtyje, nepajėgia patikti Dievui. ");
INSERT INTO lit_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Tačiau jūs esate ne kūniškoje padėtyje, bet Dvasios padėtyje, jei iš tikrųjų Dievo Dvasia gyvena jumyse; o jei kas neturi Kristaus Dvasios, tas nėra jo. ");
INSERT INTO lit_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Ir jei Kristus yra jumyse, kūnas tikrai yra miręs dėl nuodėmės, bet Dvasia yra jūsų gyvybė dėl teisumo. ");
INSERT INTO lit_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Bet jei Dvasia to, kuris prikėlė Jėzų iš numirusių, gyvena jumyse, tai tas, kuris prikėlė Kristų iš numirusių, padarys gyvus ir jūsų mirtingus kūnus savo Dvasia, gyvenančia jumyse. ");
INSERT INTO lit_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Išvada, broliai, tokia: esame įpareigoti ne kūniškumui, kad gyventume pagal kūniškumą – ");
INSERT INTO lit_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","nes jeigu gyvenate pagal kūniškumą, turėsite mirti, bet jeigu jūs Dvasia marinate kūniškumo darbus, gyvensite. ");
INSERT INTO lit_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Nes kurie tik yra Dievo Dvasios vedami, šitie yra Dievo sūnūs. ");
INSERT INTO lit_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Nes jūs negavote vergystės dvasios, kad vėl bijotumėte, bet gavote įsūnijimo Dvasią, kuria šaukiame: „Aba, Tėve! ");
INSERT INTO lit_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Pati Dvasia liudija mūsų dvasiai, kad esame Dievo vaikai. ");
INSERT INTO lit_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","O jei esame vaikai, tai ir paveldėtojai, – Dievo paveldėtojai ir Kristaus bendrapaveldėtojai – jei iš tikrųjų kenčiame su juo, kad su juo būtume ir pašlovinti. ");
INSERT INTO lit_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Nes aš padarau išvadą, kad dabartinio laiko kentėjimai ne verti palyginimo su šlove, kuri bus apreikšta mumyse. ");
INSERT INTO lit_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Nes kūrinija su ilgesingu lūkesčiu laukia Dievo sūnų apreiškimo. ");
INSERT INTO lit_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Nes kūrinija buvo padaryta pavaldi tuštybei – ne savo valia, bet valia to, kuris ją padarė pavaldžią – su viltimi ");
INSERT INTO lit_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","kad ir pati kūrinija bus išlaisvinta iš gedimo vergystės į šlovingą Dievo vaikų laisvę. ");
INSERT INTO lit_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Nes žinome, kad visa kūrinija kartu dejuoja ir kartu kenčia gimdymo skausmus iki šiol. ");
INSERT INTO lit_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Ir ne vien tai, bet ir mes, turintys Dvasią kaip pirmavaisį, – ir mes patys dejuojame savyje, laukdami įsūnijimo, būtent mūsų kūno išpirkimo. ");
INSERT INTO lit_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Nes esame išgelbėti užtikrinta viltimi; tačiau, regima viltis nėra viltis, nes kas viliasi to, ką jis regi? ");
INSERT INTO lit_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Bet jei viliamės to, ko neregime, tai ištvermingai laukiame. ");
INSERT INTO lit_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","O tokiu pat būdu ir Dvasia ateina pagalbon mūsų silpnumams, nes nežinome, ko melsti, kaip reikėtų, bet pati Dvasia užtaria mus neišsakomais atodūsiais. ");
INSERT INTO lit_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Širdžių Tyrėjas žino Dvasios sumąstytą tikslą, nes ji užtaria šventuosius sutinkamai su Dievu. ");
INSERT INTO lit_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Be to, mes žinome, kad mylintiems Dievą visi dalykai bendrai veikia į gera – tiems, kurie yra pašaukti pagal jo tikslą, ");
INSERT INTO lit_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","nes kuriuos jis iš anksto pažino, tuos iš anksto ir paskyrė būti atitinkančiais jo Sūnaus atvaizdą, kad šis būtų pirmagimis tarp daugelio brolių. ");
INSERT INTO lit_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","O kuriuos jis iš anksto paskyrė, tuos ir pašaukė; ir kuriuos pašaukė, tuos ir išteisino; ir kuriuos išteisino, tuos ir pašlovino. ");
INSERT INTO lit_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Tai ką pasakysime apie šiuos dalykus? Jei Dievas už mus, tai kas gi prieš mus?! ");
INSERT INTO lit_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Jis net nepagailėjo savo Sūnaus, bet atidavė jį už mus visus – kaipgi jis mums maloningai nedovanotų ir visko kartu su juo?! ");
INSERT INTO lit_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Kas apkaltins Dievo išrinktuosius? Dievas yra tas, kuris išteisina. ");
INSERT INTO lit_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Kas yra tas, kuris nuteisia?! Kristus yra tas, kuris mirė, – dar daugiau, yra ir prikeltas, – kuris yra ir Dievo dešinėje, kuris ir užtaria mus. ");
INSERT INTO lit_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Kas mus atskirs nuo Kristaus meilės? Ar prispaudimas, ar sielvartas, ar persekiojimas, ar badas, ar nuogumas, ar pavojus, ar kalavijas? ");
INSERT INTO lit_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Kaip yra parašyta: Dėl tavęs esame žudomi visą dieną – laikė mus avimis skerdimui. ");
INSERT INTO lit_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Vis dėlto visuose šiuose dalykuose visiškai nugalime per tą, kuris mus mylėjo. ");
INSERT INTO lit_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Nes esu įsitikinęs, kad nei mirtis, nei gyvenimas, nei angelai, nei kunigaikštystės, nei galybės, nei dabartiniai dalykai, nei būsimieji dalykai, ");
INSERT INTO lit_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","nei aukštybė, nei gilybė, nei kuris nors kitas kūrinys nepajėgs mūsų atskirti nuo Dievo meilės, kuri yra Kristuje Jėzuje, mūsų Viešpatyje. ");
INSERT INTO lit_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Kalbu tiesą Kristuje, nemeluoju, mano sąžinė kartu su manimi liudydama Šventąja Dvasia, ");
INSERT INTO lit_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","kad mano širdis labai liūdi ir nuolat širdį man skauda. ");
INSERT INTO lit_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Nes galėčiau linkėti sau būti prakeiktam, atskirtam nuo Kristaus dėl savo brolių, savo bendrataučių kūno atžvilgiu, ");
INSERT INTO lit_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","kurie yra izraelitai, kuriems priklauso įsūnystė, ir šlovė, ir sandoros, ir įstatymo suteikimas, ir tarnavimas Dievui, ir pažadai; ");
INSERT INTO lit_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","kuriems priklauso tėvai, ir iš kurių kūno atžvilgiu yra kilęs Kristus, kuris yra aukščiau visų, palaimintasis Dievas per amžius. Amen. ");
INSERT INTO lit_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Bet, nėra taip, tarsi Dievo žodis būtų niekais nuėjęs. Nes ne visi, kurie yra kilę iš Izraelio, yra tikras Izraelis. ");
INSERT INTO lit_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Ir jie ne visi yra vaikai vien dėl to, kad jie Abraomo palikuonys. Priešingai, TAVO PALIKUONYS BUS PAVADINTI IZAOKE. ");
INSERT INTO lit_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Tai yra, kūno vaikai – ne šitie yra Dievo vaikai; priešingai, pažado vaikai laikomi palikuonimis. ");
INSERT INTO lit_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Nes šis yra pažado žodis: ŠITUO LAIKU AŠ ATEISIU, IR SARA TURĖS SŪNŲ. ");
INSERT INTO lit_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Ir ne tik tai, bet ir kai Rebeka tapo nėščia per vieną, per mūsų tėvą Izaoką, ");
INSERT INTO lit_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","(vaikams gi dar negimus, nė ką nors gera ar bloga padarius), kad išsilaikytų išrinkimą atitinkantis Dievo tikslas, kuris remiasi ne darbais, bet tuo, kuris pašaukia, ");
INSERT INTO lit_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","jai buvo pasakyta: „VYRESNYSIS TARNAUS JAUNESNIAJAM, ");
INSERT INTO lit_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","kaip yra parašyta: JOKŪBĄ MYLĖJAU, BET EZAVO NEKENČIAU. ");
INSERT INTO lit_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Tai ką gi pasakysime? Nejaugi Dievas yra neteisingas?! Anaiptol! Ne! ");
INSERT INTO lit_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Nes jis sako Mozei: AŠ PASIGAILĖSIU TO, KO TIK NORĖSIU PASIGAILĖTI, IR BŪSIU GAILESTINGAS TAM, KURIAM TIK NORĖSIU BŪTI GAILESTINGAS. ");
INSERT INTO lit_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Išvada tokia: lemia nei žmogus, kuris trokšta, nei žmogus, kuris deda visas jėgas, bet Dievas, kuris pasigaili. ");
INSERT INTO lit_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Nes šventraštis sako faraonui: KAIP TIK ŠIAM PAČIAM TIKSLUI AŠ IŠKĖLIAU TAVE, KAD TAVYJE PARODYČIAU SAVO JĖGĄ IR KAD MANO VARDAS BŪTŲ SKELBIAMAS PO VISĄ ŽEMĘ. ");
INSERT INTO lit_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Išvada tokia: jis pasigaili to, kurio nori, ir užkietina tą, kurį nori. ");
INSERT INTO lit_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Tad man pasakysi: „Kodėl jis dar priekaištauja? Nes kas gi yra atsilaikęs prieš jo valią? ");
INSERT INTO lit_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Taigi, tikrai, o žmogau, kas gi tu esi, kad atsakai priešingai Dievui? Argi lipdinys pasakys tam, kuris jį sulipdė: „Kodėl mane tokį padarei? ");
INSERT INTO lit_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Arba ar puodžius neturi valdymo galios moliui, kad iš to paties minkalo padarytų vieną indą garbingam naudojimui, o kitą negarbingam?! ");
INSERT INTO lit_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","O kas jeigu Dievas, norėdamas parodyti rūstybę ir padaryti žinomą savo galią, didžia kantrybe pakentė pražūčiai priruoštus rūstybės indus, ");
INSERT INTO lit_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","ir kad padarytų žinomus savo šlovės turtus gailestingumo indams, kuriuos jis iš anksto paruošė šlovei, – ");
INSERT INTO lit_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","kuriuos jis ir pašaukė – mus, ne tik iš žydų, bet ir iš kitataučių? ");
INSERT INTO lit_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Kaip jis sako ir Ozėjuje: „Ne savo žmonių grupę pavadinsiu savąja žmonių grupe ir tą, kuri nemylima – mylima. ");
INSERT INTO lit_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Ir bus taip, kad toje vietoje, kur buvo jiems pasakyta: „Jūs ne mano žmonių grupė, ten jie bus vadinami gyvojo Dievo vaikais.“ ");
INSERT INTO lit_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Ir Izaijas šaukia apie Izraelį: „NORS IZRAELIO VAIKŲ SKAIČIUS BŪTŲ KAIP JŪROS SMĖLIO, TIK LIKUTIS BUS IŠGELBĖTAS, ");
INSERT INTO lit_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","NES JIS TEISINGAI UŽBAIGIA BEI PAGREITINA REIKALĄ, KADANGI PAGREITINTĄ REIKALĄ VIEŠPATS ĮVYKDYS ŽEMĖJE. ");
INSERT INTO lit_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Ir kaip iš anksto sakė Ezaijas: „JEI KAREIVIJŲ VIEŠPATS NEBŪTŲ MUMS PALIKĘS palikuonių, MES BŪTUME TAPĘ KAIP SODOMA IR BŪTUME PRILYGĘ GOMORAI. ");
INSERT INTO lit_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Tai ką pasakysime? Štai ką: kitataučiai, kurie nesivijo teisumo, įgijo teisumą – būtent teisumą, įgyjamą tikėjimu. ");
INSERT INTO lit_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Bet Izraelis, kuris vijosi įstatymo dėl teisumo, nepasiekė įstatymo dėl teisumo. ");
INSERT INTO lit_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Kodėl? Todėl, kad vijosi ne tikėjimu, bet tarytum įstatymo darbais. Nes jie užkliuvo už to suklupimo akmens, ");
INSERT INTO lit_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","kaip yra parašyta: „ŠTAI AŠ DEDU SIONE SUKLUPIMO AKMENĮ IR PARPUOLIMO UOLĄ, BET KAS TIK JUO PASITIKI, NEBUS SUGĖDINTAS. ");
INSERT INTO lit_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Broliai, mano širdies troškimas ir malda Dievui už Izraelį yra tai, kad jie būtų išgelbėti. ");
INSERT INTO lit_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Nes aš jų labui liudiju, kad jie turi uolumą Dievui, bet ne pagal tikrą pažinimą. ");
INSERT INTO lit_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Nes jie, ignoruodami Dievo teisumą ir dėdami pastangas įtvirtinti savąjį teisumą, nepasidavė Dievo teisumui. ");
INSERT INTO lit_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Nes teisumo atžvilgiu Kristus yra įstatymo galas kiekvienam, kuris tiki. ");
INSERT INTO lit_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Nes Mozė aprašo teisumą, kuris siekiamas įstatymu šitaip: JAIS BUS GYVAS ŽMOGUS, KURIS TUOS REIKALAVIMUS VYKDO. ");
INSERT INTO lit_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Bet teisumas, įgyjamas tikėjimu, kalba šitaip: „Nesakyk savo širdyje: Kas pakils į dangų? – tai yra Kristaus nuvesti žemyn; ");
INSERT INTO lit_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","Arba: „kas nusileis į gilybę?“ (tai yra Kristaus atvesti aukštyn iš numirusių). ");
INSERT INTO lit_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Bet ką jis sako? „Žodis yra arti tavęs, tavo burnoje ir tavo širdyje; tai yra pranešimas apie tikėjimą, kurį pranešimą skelbiame kaip šaukliai, ");
INSERT INTO lit_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","kad jeigu savo burna išpažinsi Jėzų esant Viešpatį ir savo širdimi tikėsi, kad Dievas jį prikėlė iš numirusiųjų, būsi išgelbėtas, ");
INSERT INTO lit_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","nes širdimi žmogus tiki ir dėl to turi teisumą, ir burna žmogus išpažįsta ir dėl to turi išgelbėjimą. ");
INSERT INTO lit_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Nes šventraštis byloja: Kas tik pasitiki juo, nebus sugėdintas. ");
INSERT INTO lit_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Nes nėra skirtumo tarp žydo ir graiko, nes tas pats yra visų Viešpats, pertekęs gėrybių visiems, kurie jo šaukiasi. ");
INSERT INTO lit_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Nes KIEKVIENAS, KURIS ŠAUKSIS VIEŠPATIES VARDO, BUS IŠGELBĖTAS. ");
INSERT INTO lit_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Kaip tad jie šauksis to, kuriuo netikėjo?! Ir kaip jie tikės tuo, apie kurį negirdėjo?! Ir kaip jie išgirs be tokio, kuris skelbia kaip šauklys?! ");
INSERT INTO lit_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Ir kaip jie skelbs, jei nebus pasiųsti?! Kaip yra parašyta: KOKIOS GRAŽIOS KOJOS TŲ, KURIE SKELBIA GERĄ TAIKOS ŽINIĄ, KURIE SKELBIA GERŲJŲ DALYKŲ EVANGELIJĄ! ");
INSERT INTO lit_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Tačiau ne visi pakluso Evangelijai. Nes Izaijas sako: „VIEŠPATIE, kas patikėjo girdima mūsų žinia? ");
INSERT INTO lit_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Taigi, tikėjimas ateina iš girdimos žinios, o girdima žinia – per Dievo žodį. ");
INSERT INTO lit_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Bet aš sakau: ar jie negirdėjo? Kaipgi ne! Dar daugiau: JŲ garsas PASKLIDO PO VISĄ ŽEMĘ IR JŲ ŽODŽIAI – IKI PASAULIO PAKRAŠČIŲ. ");
INSERT INTO lit_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Bet aš sakau: argi Izraelis nežinojo? Mozė pirmas sako: „AŠ KURSTYSIU, KAD jus PAIMTŲ PAVYDĄ PER NETAUTĄ, PER NEIŠMANANČIĄ TAUTĄ AŠ jus PYKDYSIU. ");
INSERT INTO lit_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Bet Izaijas yra labai drąsus ir sako: „AŠ BUVAU ATRASTAS TŲ, KURIE MANĘS NEIEŠKOJO, PASIDARIAU AIŠKIAI MATOMAS TIEMS, KURIE APIE MANE NEKLAUSINĖJO. ");
INSERT INTO lit_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Bet Izraeliui jis sako: „Ištisą dieną laikiau ištiesęs savo rankas į atsisakiusią tikėti ir atsikalbinėjančią liaudį. ");
INSERT INTO lit_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Dievas neatmetė savo tautos, kurią jis iš anksto pažinojo. Ką? Ar nežinote, ką sako šventraštis apie Eliją? Kaip jis maldaudamas kreipiasi į Dievą prieš Izraelį, sakydamas: ");
INSERT INTO lit_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","„Viešpatie, TAVO PRANAŠUS JIE NUŽUDĖ IR TAVO AUKURUS NUGRIOVĖ; O AŠ ESU IŠLIKĘS VIENAS, IR JIE TYKOJA MANO GYVYBĖS. ");
INSERT INTO lit_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Bet ką byloja Dievo atsakymas jam? „AŠ PALIKAU sau SEPTYNIS TŪKSTANČIUS VYRŲ, KURIE NESULENKĖ KELIŲ BAALIUI. ");
INSERT INTO lit_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Taigi, tuo pat būdu ir dabartiniu metu likutis yra sudarytas pagal malonės išrinkimą. ");
INSERT INTO lit_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Bet jei malone, tai nebe darbais; kitaip malonė nebebūtų malonė. Bet jei darbais, tai nebėra malonė; kitaip darbas nebėra darbas. ");
INSERT INTO lit_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Tai ką? Ko Izraelis stengiasi pasiekti, to neįgavo jis, bet įgavo išrinktieji. O likusieji buvo apakinti ");
INSERT INTO lit_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","pagal tai, kaip yra parašyta: DIEVAS JIEMS DAVĖ SNAUDULIO DVASIĄ, – AKIS, KAD JIE NEMATYTŲ, IR AUSIS, KAD JIE NEGIRDĖTŲ, IKI PAT ŠIOS DIENOS. ");
INSERT INTO lit_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Ir Dovydas sako: „JŲ STALAS TEPAVIRSTA ŽABANGAIS IR PINKLĖMIS IR SUKLUPIMO KLIŪTIMI IR ATPILDU JIEMS; ");
INSERT INTO lit_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","JŲ AKYS TEBŪNA APTEMUSIOS, KAD JIE NEREGĖTŲ IR LAIKYK JŲ NUGARĄ NUOLAT SULENKTĄ. ");
INSERT INTO lit_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Tad aš sakau: ar jie suklupo, kad galutinai nupultų? Anaiptol! Ne! Priešingai, per jų nupuolimą išgelbėjimas atėjo kitataučiams, kad juos paimtų pavydas. ");
INSERT INTO lit_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Bet jeigu jų nupuolimas yra turtas pasaulio naudai ir jų mažėjimas – turtas kitataučių naudai, tai kaip dar daugiau jų pilnatvė?! ");
INSERT INTO lit_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Nes kalbu jums, kitataučiams; kadangi aš esu apaštalas kitataučiams, skiriu šlovės savo tarnybai, ");
INSERT INTO lit_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","kad kaip nors kurstyčiau, kad mano tautiečius paimtų pavydas, ir kai kuriuos jų išgelbėčiau. ");
INSERT INTO lit_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Nes jei jų atmetimas yra sutaikinimas pasaulio naudai, tai kas bus jų priėmimas, jei ne gyvenimas prisikėlus iš numirusių? ");
INSERT INTO lit_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Nes jei pirminė dalis šventa, tai ir visa tešla šventa; ir jei šaknis šventa, tai ir šakos. ");
INSERT INTO lit_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Bet jei kai kurios šakos buvo išlaužtos, o tu, būdamas laukinis alyvmedis, buvai tarp jų įskiepytas ir pasidarei alyvmedžio šaknies bei sultingumo bendru dalininku, ");
INSERT INTO lit_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","tai nesididžiuok prieš šakas! Bet jei didžiuojiesi, – ne tu išlaikai šaknį, bet šaknis tave! ");
INSERT INTO lit_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Taigi pasakysi: „Šakos buvo išlaužtos, kad įskiepytas būčiau aš. ");
INSERT INTO lit_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Gerai! Jos buvo išlaužtos dėl netikėjimo, bet tu stovi dėl tikėjimo. Negalvok išdidžiai, verčiau bijok! ");
INSERT INTO lit_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Nes jei Dievas nepagailėjo prigimtinių šakų, – gal kartais ir tavęs nepagailės. ");
INSERT INTO lit_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Taigi pamatyk Dievo gerumą ir griežtumą: tiems, kurie nupuolė – griežtumas; bet tau – gerumas, jei pasiliksi jo gerume; kitaip ir tu būsi iškirstas! ");
INSERT INTO lit_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Bet ir anie, jei nepasiliks netikėjime, bus įskiepyti, nes Dievas yra pajėgus juos vėl įskiepyti. ");
INSERT INTO lit_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Nes jei tu buvai iškirstas iš alyvmedžio, kuris pagal prigimtį yra laukinis, ir buvai įskiepytas prieš prigimtį į gerą alyvmedį, tai kaip dar labiau šitie, kurie yra šakos pagal prigimtį, bus įskiepyti į savo pačių alyvmedį? ");
INSERT INTO lit_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Nes nenoriu, broliai, kad jūs nežinotumėte šio slėpinio, – kad nebūtumėte išmintingi savo akyse, – kad Izraelį yra dalinai ištikęs užkietėjimas, kol įeis kitataučių pilnatvė, ");
INSERT INTO lit_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","ir taip visas Izraelis bus išgelbėtas, kaip yra parašyta: IŠ SIONO ATEIS IŠVADUOTOJAS IR JIS NUKREIPS BEDIEVYSTĘ NUO JOKŪBO. ");
INSERT INTO lit_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","NES ŠI YRA SANDORA NUO MANĘS JIEMS, KAI PAŠALINSIU JŲ NUODĖMES. ");
INSERT INTO lit_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Evangelijos atžvilgiu jie yra priešai jūsų dėlei, bet išrinkimo atžvilgiu jie yra mylimieji savo tėvų dėlei, ");
INSERT INTO lit_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","nes Dievas dėl dovanų ir pašaukimo neatgailaus. ");
INSERT INTO lit_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Nes kaip jūs kadaise buvote atsisakę tikėti Dievu, tačiau dabar susilaukėte pasigailėjimo per jų atsisakymą tikėti, ");
INSERT INTO lit_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","taip ir šitie dabar atsisakė tikėti, kad per jūsų patirtą pasigailėjimą ir jie susilauktų pasigailėjimo. ");
INSERT INTO lit_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Nes Dievas drauge uždarė juos visus užsispyrusiame netikėjime, kad jis visų pasigailėtų. ");
INSERT INTO lit_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Ak, kokia Dievo išminties ir pažinimo lobio gelmė! Kokie neištiriami jo teisminiai sprendimai ir nesusekami jo keliai! ");
INSERT INTO lit_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Nes kas pažinojo VIEŠPATIES mintį? Arba kas buvo jo patarėjas? ");
INSERT INTO lit_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Arba KAS JAM PIRMAS DAVĖ, IR JAM TAI BUS ATMOKĖTA? ");
INSERT INTO lit_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Nes iš jo ir per jį ir jam yra visa. Jam šlovė amžinai! Amen. ");
INSERT INTO lit_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Taigi dėl Dievo apstaus pasigailėjimo aš maldauju jus, broliai, atnašauti savo kūnus kaip gyvą auką – šventą, Dievui patinkančią; tai jūsų protingas tarnavimas Dievui . ");
INSERT INTO lit_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Ir neprisitaikykite prie šio pasaulio, bet būkite perkeičiami savo proto atnaujinimu, kad ištirtumėte, kas yra gera, patinkama ir tobula Dievo valia. ");
INSERT INTO lit_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Nes per man duotą malonę aš sakau kiekvienam, esančiam tarp jūsų, nemanyti apie save geriau negu dera manyti, bet manyti taip, kad nuosaikiai manytų, destis kokį tikėjimo mastą Dievas yra kiekvienam priskyręs. ");
INSERT INTO lit_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Nes kaip viename kūne turime daug narių ir visi nariai atlieka ne tą patį uždavinį, ");
INSERT INTO lit_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","taip mes, būdami daugelis, esame vienas kūnas Kristuje, o pavieniui – vieni kitų nariai. ");
INSERT INTO lit_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Tad turėdami malonės dovanų, kurios skiriasi pagal mums suteiktą malonę, tinkamai jas naudokime: jei kas turi pranašavimo dovaną, tas privalo pranašauti pagal tikėjimo santykinį kiekį, ");
INSERT INTO lit_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","jei kas turi tarnavimo dovaną, tas privalo būti nusiteikęs tarnauti; jei kas moko, tas privalo būti nusiteikęs mokyti; ");
INSERT INTO lit_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","jei kas ragina, tas privalo būti nusiteikęs raginti; jei kas duoda, tas privalo būti nusiteikęs veikti iš tyrų paskatų; jei kas vadovauja, tas privalo būti nusiteikęs veikti uoliai; jei kas rodo gailestingumą, tas privalo būti nusiteikęs veikti linksmai. ");
INSERT INTO lit_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Neveidmainiška meilė: bodėti to, kas bloga, tvirtai laikytis to, kas gera, ");
INSERT INTO lit_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","jums esant draugiškai nusiteikusiems vieni kitiems broliška meile, pagarbiai laikydami vieni kitus svarbesniais, ");
INSERT INTO lit_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","stropumo atžvilgiu netingūs, dvasios atžvilgiu užsidegę, tarnaudami Viešpačiui, ");
INSERT INTO lit_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","užtikrintos vilties atžvilgiu džiaugdamiesi, prispaudimo atžvilgiu ištverdami, maldos atžvilgiu uoliai atsidėję, ");
INSERT INTO lit_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","šventųjų poreikių atžvilgiu pasidalydami, svetingumo atžvilgiu dėdami dideles pastangas. ");
INSERT INTO lit_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Laiminkite tuos, kurie jus persekioja; laiminkite ir nekeikite. ");
INSERT INTO lit_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Džiaukitės su besidžiaugiančiais ir verkite su verkiančiais. ");
INSERT INTO lit_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Galvokite tą patį vieni apie kitus. Negalvokite apie išdidžius dalykus, bet užsiimkite su žemaisiais. Nebūkite išmintingi savo akyse. ");
INSERT INTO lit_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Niekam neatmokėkite blogu už bloga, rūpinkitės tuo, kas dora visų žmonių akivaizdoje. ");
INSERT INTO lit_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Jei įmanoma, kiek nuo jūsų priklauso, gyvenkite taikingai su visais žmonėmis. ");
INSERT INTO lit_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Nekeršykite už save, mylimieji; priešingai, palikite vietos rūstybei, nes yra parašyta: „Kerštas priklauso man, atmokėsiu pats, sako Viešpats“. ");
INSERT INTO lit_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Todėl JEI TAVO PRIEŠAS ALKSTA, PAVALGYDINK JĮ; JEI TROKŠTA, PAGIRDYK JĮ, NES TAI DARYDAMAS KRAUSI UGNINGAS ŽARIJAS ANT JO GALVOS. ");
INSERT INTO lit_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Nesiduok blogio nugalimas, bet nugalėk blogį gėriu. ");
INSERT INTO lit_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Kiekviena siela tesielgia pavaldžiai aukštesnėms valdžioms. Nes nėra valdžios, kaip tiktai iš Dievo, ir esančios valdžios yra Dievo paskirtos. ");
INSERT INTO lit_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Taigi tas, kuris priešinasi valdžiai, priešinasi Dievo potvarkiui, o tie, kurie priešinasi, užsitrauks sau smerkiantį nuosprendį. ");
INSERT INTO lit_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Nes valdovai nekelia baimės už gerus darbus, bet už blogus. Argi tu nori nebijoti valdžios? Įprastai daryk tai, kas gera, ir susilauksi iš jos pagyrimo, ");
INSERT INTO lit_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","nes valdžia yra Dievo tarnautoja tavo labui. Bet jeigu įprastai darai bloga, bijok, nes ji ne veltui nešioja kalaviją, kadangi ji yra Dievo tarnautoja, keršytoja, kad įvykdytų rūstybę darančiam bloga. ");
INSERT INTO lit_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Todėl būtina elgtis pavaldžiai ne tik dėl rūstybės, bet ir dėl sąžinės. ");
INSERT INTO lit_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Nes dėl tos priežasties jūs ir mokesčius mokate, nes anie yra Dievo tarnautojai, atsidedantys kaip tik tam reikalui. ");
INSERT INTO lit_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Todėl visiems atiduokite jiems priklausančias skolas: kam mokestį – mokestį; kam muitą – muitą; kam baimę – baimę; kam pagarbą – pagarbą. ");
INSERT INTO lit_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Niekam nieko nebūkite skolingi, išskyrus meilę vienas kitam, nes kas myli kitą, yra įvykdęs įstatymą. ");
INSERT INTO lit_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Nes tai – „nesvetimauk“, „neįvykdyk žmogžudystės“, „nevok“, „neliudyk melagingai“, „negeisk“, ir bet kuris kitas įsakymas, yra sutraukti į šį posakį, būtent: „Mylėk savo artimą kaip save patį“. ");
INSERT INTO lit_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Meilė nedaro nieko blogo artimui, todėl meilė yra įstatymo įvykdymas. ");
INSERT INTO lit_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Ir tai darykite, suvokdami laiką, kad dabar pats laikas mums pabusti iš miego, nes mūsų išgelbėjimas dabar yra arčiau negu tada, kai įtikėjome. ");
INSERT INTO lit_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Naktis beveik praslinko ir diena yra prisiartinusi. Tad nusimeskime tamsos darbus ir užsidėkime šviesos ginklus. ");
INSERT INTO lit_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Vaikščiokime dorai, kaip šviesu paros metu: ne dalyvaudami orgijose ir girtaudami, ne sanguliaudami ir elgdamiesi palaidžiai, ne vaidydamiesi ir pavyduliaudami. ");
INSERT INTO lit_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Priešingai, apsivilkite Viešpačiu Jėzumi Kristumi ir nekurkite planų kūniškojo aš geiduliams. ");
INSERT INTO lit_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","O tą, kuris yra silpnas tikėjimo atžvilgiu, priimkite, tik ne ginčams vesti apie jo samprotavimus. ");
INSERT INTO lit_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Nes vienas tiki galintis valgyti viską, bet kitas, būdamas silpnas, valgo daržoves. ");
INSERT INTO lit_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Tas, kuris valgo, tegul neniekina to, kuris nevalgo, ir tas, kuris nevalgo, tegul neteisia to, kuris valgo, nes Dievas jį priėmė. ");
INSERT INTO lit_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Kas esi tu, kad teisi kito namų tarną? Jis tvirtai stovi arba nupuola savo šeimininkui. Ir jis tvirtai stovės, nes Dievas yra pajėgus jį padaryti tvirtai stovintį. ");
INSERT INTO lit_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Vienas vertina vieną dieną labiau už kitą, kitas lygiai vertina kiekvieną dieną. Kiekvienas tegul būna visiškai įsitikinęs savo protavimu. ");
INSERT INTO lit_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Kas laiko vieną dieną ypatinga, ją laiko ypatinga Viešpaties labui, ir kas nelaiko dienos ypatinga, Viešpaties labui nelaiko jos ypatinga. Kas valgo, Viešpaties labui valgo, nes jis dėkoja Dievui; o kas nevalgo, tas Viešpaties labui nevalgo ir dėkoja Dievui. ");
INSERT INTO lit_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Nes nė vienas iš mūsų negyvena savo labui ir nė vienas nemiršta savo labui. ");
INSERT INTO lit_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Nes ar gyvename, gyvename Viešpaties labui, ir ar mirštame, mirštame Viešpaties labui. Taigi ar gyvename, ar mirštame, – esame Viešpaties. ");
INSERT INTO lit_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Nes Kristus ir mirė, ir prisikėlė, ir atgijo tam, kad jis viešpatautų tiek mirusiems, tiek gyviems. ");
INSERT INTO lit_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","O tu – kodėl tu teisi savo brolį? Arba kodėl tu niekini savo brolį? Juk mes visi stosime prieš Kristaus teismo krasę. ");
INSERT INTO lit_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Nes yra parašyta: „Kaip aš gyvas, – sako Viešpats, – man nusilenks kiekvienas kelis, ir kiekvienas liežuvis viešai prisipažins Dievui.“ ");
INSERT INTO lit_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Išvada tokia: kiekvienas iš mūsų duos ataskaitą Dievui už save. ");
INSERT INTO lit_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Todėl turėtume nebeteisti vieni kitų; bet dėl štai ko verčiau priimkite nuosprendį: nepadėti broliui suklupimo kliūties ar pargriaunančios kliuvinio. ");
INSERT INTO lit_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Aš žinau ir esu įsitikinęs per Viešpatį Jėzų, kad nieko nėra savaime netyro; tik tam, kuris ką nors laiko netyru, jam tai yra netyras. ");
INSERT INTO lit_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Bet jeigu tavo brolis sielojasi dėl tavo valgio, tu jau nebevaikščioji pagal meilę. Savo valgiu nežlugdyk to, už kurį mirė Kristus! ");
INSERT INTO lit_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Tad neturi būti piktžodžiaujamas tas jums priklausantis geras dalykas. ");
INSERT INTO lit_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","nes Dievo karalystė nėra valgis ir gėrimas, bet teisumas, ramybė ir džiaugsmas Šventosios Dvasios įtakoje. ");
INSERT INTO lit_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Nes kas šitais tarnauja Kristui, tas patinka Dievui ir yra sulaukęs žmonių pritarimo. ");
INSERT INTO lit_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Išvada tokia: vykimės ramybės dalykus, ir dalykus, kurių tikslas yra vieni kitus statydinti. ");
INSERT INTO lit_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Dėl maisto negriauk Dievo darbo! Iš tikrųjų viskas yra tyra, bet blogai elgiasi žmogus, kuris valgo suklupdindamas kitus. ");
INSERT INTO lit_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Gerai nei nevalgyti mėsos, nei negerti vyno, nei nieko nedaryti, kuo tavo brolis suklumpa ar yra piktinamas, ar yra silpninamas. ");
INSERT INTO lit_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Ar tu turi įsitikinimą? Pasilaikyk jį sau Dievo akivaizdoje. Palaimintas, kuris neteisia savęs tuo, ką pripažįsta. ");
INSERT INTO lit_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Bet tas, kuris abejoja, jeigu jis valgo, yra nuteistas, nes jis valgo ne iš tikėjimo; nes visa, kas ne iš tikėjimo, yra nuodėmė. ");
INSERT INTO lit_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Tad mes, stiprieji, turime pakęsti silpnųjų silpnybes, o ne sau įtikti, ");
INSERT INTO lit_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","nes kiekvienas iš mūsų privalo įtikti savo artimui jo labui, statydinimui. ");
INSERT INTO lit_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Priežastis tokia: net Kristus ne sau įtiko, bet taip, kaip yra parašyta: Tave paniekinusiųjų paniekinimai krito ant manęs. ");
INSERT INTO lit_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","Nes visa, kas anksčiau buvo parašyta, buvo parašyta mums pamokyti, kad ištverme ir šventraščio paguoda turėtume užtikrintos vilties. ");
INSERT INTO lit_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","O ištvermės ir paguodžiančio paraginimo Dievas teduoda jums tarpusavyje būti tos pačios minties pagal Kristų Jėzų, ");
INSERT INTO lit_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","kad jūs vieningai, vienu balsu, šlovintumėte Dievą, tai yra mūsų Viešpaties Jėzaus Kristaus Tėvą. ");
INSERT INTO lit_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Todėl priimkite vienas kitą, kaip ir Kristus mus priėmė, Dievo šlovei. ");
INSERT INTO lit_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","Nes pareiškiu: Jėzus Kristus tapo apipjaustytųjų tarnas dėl Dievo tiesos, kad patvirtintų tėvams duotus pažadus ");
INSERT INTO lit_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","ir kad kitataučiai šlovintų Dievą už jo gailestingumą, kaip yra parašyta: Dėl to aš tau prisipažinsiu tarp kitataučių ir tavo vardui giedosiu.“ ");
INSERT INTO lit_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","Ir vėl jis sako: Džiaukitės, o kitataučiai, kartu su jo žmonėmis!“ ");
INSERT INTO lit_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","Ir vėl: Girkite Viešpatį, visi kitataučiai, ir išgarsinkite jį, visi žmonės!“ ");
INSERT INTO lit_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Ir vėl – Izaijas sako: Bus Jesės šaknis, tai yra tas, kuris pakils viešpatauti kitataučiams; kitataučiai sudės viltis į jį.“ ");
INSERT INTO lit_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Taigi, jums tikint, tegul užtikrintos vilties Dievas pripildo jus viso džiaugsmo ir ramybės, kad Šventosios Dvasios galybe apstėtumėte užtikrintos vilties. ");
INSERT INTO lit_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Ir aš pats esu įsitikinęs taip pat apie jus, mano broliai, kad jūs esate irgi pilni gerumo, pripildyti viso pažinimo ir pajėgūs vieni kitus su paraginimu įspėti. ");
INSERT INTO lit_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","Vis dėlto, broliai, kai kur parašiau jums drąsiau nei įprasta, būtent primindamas jums dėl Dievo man duotos malonės, ");
INSERT INTO lit_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","kurios tikslas toks, kad būčiau Jėzaus Kristaus tarnautojas kitataučių labui, kaip šventyklos tarnas pateikdamas Dievo Evangeliją tam, kad atnašavimas, kurį sudaro kitataučiai, būtų priimtinas, pašventintas Šventąja Dvasia. ");
INSERT INTO lit_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Taigi Kristuje Jėzuje turiu tam tikrą pasigyrimą tuose dalykuose, kurie susiję su tarnyste Dievui. ");
INSERT INTO lit_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","Nes nedrįsčiau ko nors pasakoti, ko Kristus nebūtų nuveikęs per mane (tam tikslui, kad kitataučiai paklustų) žodžiu ir darbu, ");
INSERT INTO lit_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","antgamtinių ženklų ir pranašiškų ženklų galybe, Dievo Dvasios galybe. Pasekmė ta, kad nuo Jeruzalės ir aplinkui iki Ilyrikos aš iki galo paskleidžiau Kristaus evangeliją; ");
INSERT INTO lit_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","šitaip laikiau tai didžiausiu siekiu skelbti evangeliją ne ten, kur Kristus buvo minimas, kad nestatyčiau ant kito žmogaus pamato, ");
INSERT INTO lit_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","bet kaip yra parašyta: „Pamatys tie, kuriems nebuvo skelbta apie jį ir supras tie, kurie nebuvo girdėję“. ");
INSERT INTO lit_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","Dėl tos priežasties daug kartų man buvo kliudoma pas jus atvykti. ");
INSERT INTO lit_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Bet dabar, nebeturėdamas užmojo šiose srityse ir daugelį metų turėdamas didelį troškimą atvykti pas jus, ");
INSERT INTO lit_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","kai tik keliausiu į Ispaniją, atvyksiu pas jus. Nes tikiuosi pamatyti jus perkeliaudamas ir būti jūsų aprūpintas kelionei pirmyn į ten, jeigu pirma bent iš dalies „pasisotinsiu“ bendravimu su jumis. ");
INSERT INTO lit_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Bet dabar keliauju į Jeruzalę šventiesiems patarnauti. ");
INSERT INTO lit_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","Nes tie iš Makedonijos ir Achajos džiaugėsi padarydami tam tikrą bendryste pagrįstą rinkliavą šventųjų neturtėliams, esantiems Jeruzalėje. ");
INSERT INTO lit_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Tuo jie tikrai džiaugėsi, ir jie yra anų skolininkai. Nes jeigu kitataučiai tapo anų dvasinių dalykų dalininkais, tai jie privalo aniems patarnauti bent medžiaginiais dalykais. ");
INSERT INTO lit_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Todėl baigęs šitą reikalą, tai yra saugiai atidavęs jiems šitą bendrystės vaisių, jums padedant nuvyksiu į Ispaniją. ");
INSERT INTO lit_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","Ir žinau, kad kai pas jus atvyksiu, atvyksiu Kristaus Evangelijos palaiminimo pilnatvei esant su manimi. ");
INSERT INTO lit_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","O maldauju jus, broliai, per Viešpatį Jėzų Kristų ir per Dvasios meilę kartu su manimi kovoti už mane maldomis Dievui, ");
INSERT INTO lit_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","kad būčiau išvaduotas nuo tų Judėjoje, kurie atsisako tikėti, ir kad mano tarnavimas Jeruzalės labui būtų priimtinas šventiesiems, ");
INSERT INTO lit_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","kad su džiaugsmu atvykčiau pas jus (pagal Dievo valią) ir su jumis atsigaivinčiau. ");
INSERT INTO lit_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","O ramybės Dievas tebūna su jumis visais. Amen. ");
INSERT INTO lit_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","Aš ir teigiamai jums pristatau mūsų seserį Febę, kuri yra Kenchrėjoje esančios bažnyčios tarnaitė, ");
INSERT INTO lit_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","kad priimtumėte ją Viešpatyje, kaip pridera šventiesiems, ir jai padėtumėte bet kokiu reikalu, dėl kurio jai iš jūsų ko nors prireiktų, nes ji pati yra buvusi daugelio ir mano paties padėjėja. ");
INSERT INTO lit_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","Sveikinkite Priscilę ir Akvilą, mano bendradarbius Kristuje Jėzuje, ");
INSERT INTO lit_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","kurie už mano gyvybę padėjo po budelio kirviu savo pačių kaklus, kuriems dėkoju ne aš vienas, bet ir visos kitataučių bažnyčios. ");
INSERT INTO lit_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","Sveikinkite ir bažnyčią, esančią jų namuose. Sveikinkite mano mylimą Epenetą, kuris yra Achajos pirmavaisius Kristui. ");
INSERT INTO lit_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","Sveikinkite Mariją, kuri triūsė daug mūsų labui. ");
INSERT INTO lit_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","Sveikinkite Androniką ir Juniją, mano giminaičius ir mano bendrakalinius, kurie yra įžymūs apaštalų tarpe, kurie taip pat pirmiau už mane yra Kristuje. ");
INSERT INTO lit_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","Sveikinkite Ampliją, mano mylimą Viešpatyje. ");
INSERT INTO lit_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","Sveikinkite mūsų bendradarbį Kristuje Urboną ir mano mylimą Stachį. ");
INSERT INTO lit_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","Sveikinkite Apelį, išlaikiusį išmėginimą Kristuje. Sveikinkite tuos, kurie yra iš Aristobulo namiškių. ");
INSERT INTO lit_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","Sveikinkite mano giminaitį Erodioną. Sveikinkite tuos, kurie yra iš Narcizo namiškių, kurie yra Viešpatyje. ");
INSERT INTO lit_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","Sveikinkite Trifeną ir Trifosą, kurios triūsia Viešpatyje. Sveikinkite mylimą Persidę, kuri daug triūsė Viešpatyje. ");
INSERT INTO lit_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","Sveikinkite išrinktąjį Viešpatyje Rufą, taip pat jo bei mano motiną. ");
INSERT INTO lit_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","Sveikinkite Asinkritą, Flegontą, Hermą, Patrobą, Hermį ir su jais esančius brolius. ");
INSERT INTO lit_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","Sveikinkite Filologą ir Juliją, Nerėją ir jo seserį, ir Olimpą, ir visus su jais esančius šventuosius. ");
INSERT INTO lit_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","Sveikinkite vieni kitus šventu pabučiavimu. Kristaus bažnyčios sveikina jus. ");
INSERT INTO lit_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","O aš maldauju jus, broliai, akylai stebėti tuos, kurie kelia maištus ir suklupimą sukeliančias kliūtis priešingas mokslui, kurio jūs išmokote, ir venkite jų. ");
INSERT INTO lit_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","Nes tokie tarnauja ne mūsų Viešpačiui Jėzui Kristui, bet savo pilvui, ir pamaloninančia kalba bei gražbylyste apgaudinėja neįtariančiųjų širdis. ");
INSERT INTO lit_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","Jūsų gi paklusnumas pasidarė žinomas visiems. Todėl džiaugiuosi dėl jūsų, tačiau noriu, kad geriems dalykams būtumėte jūs išmintingi, bet blogiems dalykams nekalti. ");
INSERT INTO lit_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","Ir ramybės Dievas netrukus sutryps Šėtoną po jūsų kojomis. Mūsų Viešpaties Jėzaus Kristaus malonė tebūna su jumis. Amen. ");
INSERT INTO lit_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","Jus sveikina mano bendradarbis Timotiejus ir mano giminaičiai Liucijus, Jasonas ir Sosipatras. ");
INSERT INTO lit_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","Aš, Tercijus, kuris surašiau šitą laišką, sveikinu jus Viešpatyje. ");
INSERT INTO lit_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","Jus sveikina Gajus, priėmęs pas save mane ir visą bažnyčią. Jus sveikina miesto ūkio reikalų tvarkytojas Erastas ir brolis Kvartas. ");
INSERT INTO lit_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","Mūsų Viešpaties Jėzaus Kristaus malonė tebūna su jumis visais. Amen. ");
INSERT INTO lit_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","O tam, kuris pajėgia padaryti jus tvirtus pagal mano Evangeliją, tai yra šauklišką skelbimą apie Jėzų Kristų, pagal apreiškimą slėpinio, kuris buvo nutylėtas nuo pasaulio pradžios, ");
INSERT INTO lit_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","bet dabar yra apreikštas – būtent per pranašiškus šventraščius pagal amžinojo Dievo įsakymą visoms tautoms yra duota žinoti, kad būtų paklusnumas tikėjimui, – ");
INSERT INTO lit_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","vieninteliam išmintingajam Dievui – jam šlovė per Jėzų Kristų amžinai! Amen. ");
INSERT INTO lit_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Paulius, Dievo valia pašauktas Jėzaus Kristaus apaštalas, ir brolis Sostenas – ");
INSERT INTO lit_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","Dievo bažnyčiai, kuri yra Korinte, pašventintiems Kristuje Jėzuje, pašauktiems būti šventieji drauge su visais, kurie kiekvienoje vietoje šaukiasi mūsų Viešpaties Jėzaus Kristaus vardo – tiek jų, tiek mūsų Viešpaties. ");
INSERT INTO lit_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","Malonė jums ir ramybė nuo Dievo, mūsų Tėvo, ir Viešpaties Jėzaus Kristaus. ");
INSERT INTO lit_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","Todėl jokios dovanos netrūksta jums, laukiantiems apsireiškimo mūsų Viešpaties Jėzaus Kristaus, ");
INSERT INTO lit_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","kuris ir iki galo padarys jus tvirtus, nepeiktinus mūsų Viešpaties Jėzaus Kristaus dieną. ");
INSERT INTO lit_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","Ištikimas yra Dievas, kurio veikimu jūs buvote pašaukti į jo Sūnaus, mūsų Viešpaties Jėzaus Kristaus, bendrystę. ");
INSERT INTO lit_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","O aš maldauju jus, broliai, mūsų Viešpaties Jėzaus Kristaus vardu, kad jūs visi kalbėtumėte tą patį, ir kad tarp jūsų nebūtų susiskaldymų, bet kad būtumėte tobulai sunarinti būdami tos pačios minties ir tos pačios pažiūros. ");
INSERT INTO lit_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","Mat man buvo pranešta apie jus, mano broliai, nuo Chlojės namiškių, kad tarp jūsų yra nesutarimų. ");
INSERT INTO lit_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","Ar Kristus padalytas? Nejaugi Paulius buvo už jus nukryžiuotas? Arba, ar jūs buvote pakrikštyti vardan Pauliaus? ");
INSERT INTO lit_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","Dėkoju Dievui, kad nė vieno iš jūsų nepakrikštijau, išskyrus Krispą ir Gajų, ");
INSERT INTO lit_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","kad kas nors negalėtų sakyti, jog krikštijau vardan savęs. ");
INSERT INTO lit_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","O aš pakrikštijau ir Stepono namiškius. Daugiau nežinau, ar ką kitą pakrikštijau, ");
INSERT INTO lit_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","nes Kristus siuntė mane ne krikštyti, bet skelbti evangeliją, – ne su kalbos išmintimi, kad Kristaus kryžius nebūtų be poveikio. ");
INSERT INTO lit_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","Nes kryžiaus skelbimas tiems, kurie žūsta, yra kvailystė, bet mums, kurie esame išgelbėti, jis yra Dievo jėga. ");
INSERT INTO lit_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","Mat žydai reikalauja antgamtinio ženklo, ir graikai ieško išminties, ");
INSERT INTO lit_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","bet mes skelbiame Kristų nukryžiuotą – žydams gi suklupimo kliūtis, o graikams – kvailystę, ");
INSERT INTO lit_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","bet pašauktiesiems – tiek žydams, tiek graikams – skelbiame Kristų – Dievo galybę ir Dievo išmintį. ");
INSERT INTO lit_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","Nes Dievo kvailystė yra išmintingesnė už žmones, ir Dievo silpnybė yra stipresnė už žmones. ");
INSERT INTO lit_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","Bet jo veikimu jūs esate Kristuje Jėzuje, kuris Dievo veikimu mums buvo padarytas išmintimi, būtent – teisumu, šventinimu ir išpirkimu, ");
INSERT INTO lit_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","kad būtų kaip yra parašyta: KAS GIRIASI, TESIGIRIA VIEŠPAČIU. ");
INSERT INTO lit_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","Ir pats buvau pas jus silpnas ir baimingas ir labai drebantis, ");
INSERT INTO lit_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","Mes gi gavome ne pasaulio dvasią, bet Dvasią, kuri iš Dievo, kad suvoktume Dievo mums dovanai duotus dalykus. ");
INSERT INTO lit_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","Tuos dalykus mes ir kalbame – ne tais žodžiais, kurių moko žmogaus išmintis, bet kurių moko Šventoji Dvasia – palygindami dvasinius dalykus su dvasiniais. ");
INSERT INTO lit_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","Bet nedvasiškas žmogus nepriima Dievo Dvasios dalykų, nes šie jam yra kvailystė; ir jis nepajėgia jų suprasti, nes jie yra ištiriami dvasiškai. ");
INSERT INTO lit_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","Nes Kas pažinojo VIEŠPATIES mintį, kad jį pamokytų? Tačiau Kristaus mintį turime mes. ");
INSERT INTO lit_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","Aš maitinau jus pienu, o ne kietu maistu, nes dar nepajėgėte jo priimti; bet ir dabar dar nepajėgiate, ");
INSERT INTO lit_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","nes vis dar esate kūniški. Juk tais atvejais, kai tarp jūsų yra pavydas, nesantaika ir kurstymai maištauti, argi nesate kūniški, tai yra argi nevaikščiojate, kaip žmonėms būdinga? ");
INSERT INTO lit_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","Kas tad yra Paulius ir kas Apolas? Vis dėlto tik tarnai, per kuriuos jūs įtikėjote, ir tai kaip Viešpats davė ir vienam ir kitam tarnauti. ");
INSERT INTO lit_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","Aš sodinau, Apolas laistė, o Dievas augino. ");
INSERT INTO lit_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","Taigi nei tas, kuris sodina, yra kažkas, nei tas, kuris laisto, bet tik Dievas, kuris augina. ");
INSERT INTO lit_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","O kas sodina ir kas laisto yra viena. Ir kiekvienas gaus savo atlygį pagal savo triūsą. ");
INSERT INTO lit_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","Nes mes esame Dievui priklausantys bendradarbiai; jūs esate Dievui priklausanti dirva, Dievui priklausantis pastatas. ");
INSERT INTO lit_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","Pagal Dievo man duotą malonę aš, kaip išmintingas kvalifikuotas statytojas, padėjau pamatą, o kitas ant jo stato. Bet tegul kiekvienas žiūrisi, kaip ant jo stato, ");
INSERT INTO lit_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","nes niekas nėra pajėgus dėti kito pamato, kaip tik tą, kuris padėtas, kuris yra Jėzus Kristus. ");
INSERT INTO lit_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","Ir jeigu kas ant šito pamato stato iš aukso, sidabro, brangiųjų akmenių, medžio, šieno, šiaudų, – ");
INSERT INTO lit_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","kiekvieno darbas išaiškės, nes diena jį iškels aikštėn, kadangi jis bus atskleistas ugnimi, ir ugnis ištirs, koks yra kiekvieno darbas. ");
INSERT INTO lit_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","Jeigu kieno darbas, kurį jis ant jo statė, išliks, tas gaus atlygį. ");
INSERT INTO lit_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","Jeigu kieno darbas sudegs, jis patirs nuostolį, bet jis pats bus išgelbėtas, tačiau taip, kaip per ugnį. ");
INSERT INTO lit_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","Ar nežinote, kad esate Dievo šventykla ir Dievo Dvasia gyvena jumyse? ");
INSERT INTO lit_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","Jeigu kas sugadina Dievo šventyklą, tą Dievas sugadins, nes Dievo šventykla yra šventa, ir ta šventykla esate jūs! ");
INSERT INTO lit_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","Tad niekas tenesigiria žmonėmis. Nes viskas yra jūsų, ");
INSERT INTO lit_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","ar Paulius, ar Apolas, ar Kefas, ar pasaulis, ar gyvenimas, ar mirtis, ar dabartiniai dalykai, ar būsimieji dalykai – viskas yra jūsų, ");
INSERT INTO lit_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","o jūs esate Kristaus, o Kristus yra Dievo. ");
INSERT INTO lit_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","O be to, iš prievaizdų yra reikalaujama, kad kiekvienas būtų aptiktas esant ištikimas. ");
INSERT INTO lit_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","Nes prieš save nieko nežinau. Tačiau aš tuo nesu išteisintas, bet tas, kuris mane tiria, yra Viešpats. ");
INSERT INTO lit_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","Kas gi tave išskiria iš kitų? Ir ką tu turi, ko negavai? O jeigu gavai, ko giriesi, lyg nebūtum gavęs? ");
INSERT INTO lit_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","Nors ir turėtumėte dešimt tūkstančių auklėtojų Kristuje, tačiau neturite daug tėvų, nes aš jus pagimdžiau Kristuje Jėzuje per evangeliją. ");
INSERT INTO lit_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","Taigi aš maldauju jus: būkite mano sekėjai. ");
INSERT INTO lit_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","Dėl šios priežasties pasiunčiau pas jus Timotiejų, kuris yra mano mylimas ir ištikimas vaikas Viešpatyje. Jis jums primins būtent mano Kristuje įgyvendinamus veikimo būdus, kaip aš mokau visur, kiekvienoje bažnyčioje. ");
INSERT INTO lit_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","Nes tikrai aš nebūdamas pas jus kūnu, bet būdamas dvasia, jau teisinį sprendimą priėmiau, lyg kad būdamas su jumis, tą dalyką padariusį, ");
INSERT INTO lit_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","mūsų Viešpaties Jėzaus Kristaus vardu, kai esate susirinkę ir mano dvasia, su mūsų Viešpaties Jėzaus Kristaus galybe ");
INSERT INTO lit_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","atiduoti tokį Šėtonui kūno niokojimui, kad dvasia būtų išgelbėta Viešpaties Jėzaus Dieną. ");
INSERT INTO lit_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","Jūsų gyrimasis negeras. Ar nežinote, kad truputis raugo suraugina visą tešlą? ");
INSERT INTO lit_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","Todėl išvalykite senąjį raugą, kad būtumėte nauja tešla, kaip kad esate nerauginti, nes ir Kristus – mūsų Aplenkimo Avinėlis – yra paaukotas už mus. ");
INSERT INTO lit_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","Todėl švęskime šventę nei su senu raugu ne su piktos valios ir nelabumo raugu, bet su nerauginta nuoširdumo ir tiesos duona. ");
INSERT INTO lit_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","Tad jei turite teismų dėl dalykų, susijusių su šiuo gyvenimu, tai sodinkite į sprendžiančiųjų vietą tuos, kurie mažiausiai vertinami bažnyčioje. ");
INSERT INTO lit_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","Tokie kai kurie iš jūsų buvote, bet esate nuplauti, bet esate pašventinti, bet esate išteisinti Viešpaties Jėzaus Kristaus vardu ir mūsų Dievo Dvasia. ");
INSERT INTO lit_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","„Viskas man yra teisėta!“ Bet ne viskas naudinga! „Viskas man yra teisėta!“ Bet aš neleisiu jokiam dalykui užvaldyti mane! ");
INSERT INTO lit_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","„Valgiai pilvui, ir pilvas valgiams. Dievas gi pražudys ir jį, ir juos.“ O kūnas ne paleistuvystei, bet Viešpačiui, ir Viešpats – kūnui. ");
INSERT INTO lit_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","Bėkite nuo paleistuvystės! Kiekviena kita nuodėmė, kurią žmogus daro, yra kūno išorėje, bet tas, kuris paleistuvauja, nusideda prieš savo paties kūną. ");
INSERT INTO lit_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","Ką? Ar nežinote, kad jūsų kūnas yra šventykla jumyse esančios Šventosios Dvasios, kurią turite iš Dievo, ir kad nepriklausote sau? ");
INSERT INTO lit_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","Nes esate nupirkti už didelę kainą, todėl šlovinkite Dievą savo kūnu ir savo dvasia, kurie priklauso Dievui. ");
INSERT INTO lit_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","O dėl dalykų, apie kuriuos man rašėte: Yra gera, kad vyras nepaliestų moters. ");
INSERT INTO lit_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","Tačiau, dėl to, kad būna paleistuvavimų, tegul kiekvienas vyras turi savo žmoną ir tegul kiekviena moteris turi savo vyrą. ");
INSERT INTO lit_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","Tegul vyras suteikia žmonai priklausantį palankumą, taip pat ir žmona vyrui. ");
INSERT INTO lit_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","Žmona nėra savo kūno valdžia, bet vyras; taip pat ir vyras nėra savo kūno valdžia, bet žmona. ");
INSERT INTO lit_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","Nesulaikykite vienas nuo kito tai, kas paprastai priklauso, nebent abipusiu sutikimu kuriam laikui, kad atsiduotumėte pasninkui ir maldai ir paskui vėl sueitumėte kartu, kad Šėtonas jūsų negundytų dėl jūsų nuolaidžiavimo savo norams. ");
INSERT INTO lit_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","Bet šį dalyką sakau pagal man duotą leidimą, ne pagal man duotą įsakymą. ");
INSERT INTO lit_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","Nes norėčiau, kad visi žmonės būtų tokie, kaip ir aš pats. Tačiau kiekvienas turi iš Dievo savo paties dovaną, vienas vienokią, o kitas kitokią. ");
INSERT INTO lit_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","Todėl sakau nesusituokusiems ir našlėms: gerai jiems, jeigu jie pasilieka tokie, kaip ir aš. ");
INSERT INTO lit_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","Bet jeigu jie negali susivaldyti, tegul tuokiasi, nes yra geriau tuoktis, negu degti. ");
INSERT INTO lit_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","O susituokusiems įsakau, tačiau ne aš, bet Viešpats: žmonai neleidžiama atsiskirti nuo vyro, – ");
INSERT INTO lit_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","bet jei ji ir atsiskirtų, ji turi pasilikti nesusituokusi arba susitaikyti su savo vyru, – ir vyrui neleidžiama išsiųsti savo žmonos. ");
INSERT INTO lit_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","Visiems kitiems sakau aš, ne Viešpats: jei kuris nors brolis turi netikinčią žmoną ir ji sutinka gyventi su juo, jis neturi išsiųsti jos. ");
INSERT INTO lit_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","Ir moteris, turinti netikintį vyrą, kuris sutinka su ja gyventi, neturi išsiųsti jo. ");
INSERT INTO lit_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","Jūs esate nupirkti už didelę kainą; nepasidarykite žmonių vergais. ");
INSERT INTO lit_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","Ar esi susaistytas su žmona? Neieškok nutraukimo. Ar tau nutrauktas saitas su žmona? Neieškok žmonos. ");
INSERT INTO lit_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","Bet jei kas galvoja, kad netinkamai elgiasi savo mergelės atžvilgiu, jeigu ji peraugtų patį geriausią susituokimo amžių, ir taip reikia, tedaro kaip nori, jis nenusideda; tegul jie susituokia. ");
INSERT INTO lit_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","Tačiau kas savo širdyje yra tvirtai apsisprendęs, – nebūdamas priverstas, bet pats valdydamas savo valią, – ir yra taip nutaręs savo širdyje, kad išsaugos savo mergelę, tas daro gerai. ");
INSERT INTO lit_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","Taigi tas, kuris duoda į žmonas, daro gerai; bet tas, kuris neduoda į žmonas, daro geriau. ");
INSERT INTO lit_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","Žmona yra susaistyta įstatymu tiek laiko, kiek gyvena jos vyras. Bet jeigu jos vyras būtų miręs, ji yra laisva ištekėti už ko nori – tiktai Viešpatyje. ");
INSERT INTO lit_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","Bet, pagal mano požiūrį, ji laimingesnė, jeigu ji taip pasilieka; o aš manau, kad ir aš turiu Dievo Dvasią. ");
INSERT INTO lit_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","Štai gi apie stabams paaukotų dalykų: suprantame, kad „pažinimą turime visi“. Pažinimas išpučia, bet meilė statydina. ");
INSERT INTO lit_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","Ir jei kas mano, kad yra ką nors suvokęs, tai jis dar nieko nežino, kaip reikia žinoti. ");
INSERT INTO lit_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","Bet žiūrėkite, kad ši jūsų teisė kokiu tai būdu netaptų suklupimo priežastimi silpniesiems. ");
INSERT INTO lit_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","ir per tavo pažinimą ar nežus silpnas brolis, už kurį mirė Kristus? ");
INSERT INTO lit_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","O šitaip nusidėdami broliams ir sužeisdami jų silpną sąžinę, jūs nusidedate Kristui. ");
INSERT INTO lit_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","Todėl jei valgis papiktina mano brolį, aš visai nevalgysiu mėsos kol esti pasaulis, kad tik savo brolio nepapiktinčiau. ");
INSERT INTO lit_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","Ar mes neturime įgaliojimo apkeliauti su žmona, viena iš seserų, kaip ir kiti apaštalai ir Viešpaties broliai, ir Kefas? ");
INSERT INTO lit_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","Arba ar vien tik aš ir Barnabas neturime įgaliojimo neužsiimti uždarbiavimu? ");
INSERT INTO lit_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","Silpniesiems pasidariau tarsi silpnas, kad laimėčiau silpnuosius; visiems tapau viskuo, kad visokeriopais būdais kai kuriuos išgelbėčiau. ");
INSERT INTO lit_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","Ar nežinote, kad lenktynėse bėga visi bėgikai, bet vienas gauna prizą? Taip bėkite, kad laimėtumėte. ");
INSERT INTO lit_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","Ir kiekvienas, kovojantis už pergalę, susivaldo visais atžvilgiais. Taigi anie taip daro, beje, kad gautų vystantį vainiką, bet mes nevystantį. ");
INSERT INTO lit_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","Todėl aš tokiu būdu bėgu, ne kaip nežinomybėje, tokiu būdu einu kumštynių, ne kaip smūgiuojantis į orą, ");
INSERT INTO lit_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","bet tramdau savo kūną ir jį pavergiu, kad kartais, kitiems skelbęs kaip šauklys, pats nebūčiau Dievo vertintas atmestinai. ");
INSERT INTO lit_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","Be to, broliai, nenoriu, kad jūs nežinotumėte, jog visi mūsų tėvai buvo po debesimi, ir visi perėjo per jūrą, ");
INSERT INTO lit_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","ir visi buvo pakrikštyti į Mozę debesyje ir jūroje, ");
INSERT INTO lit_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","ir visi valgė tą patį dvasinį maistą, ");
INSERT INTO lit_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","ir visi gėrė tą patį dvasinį gėrimą; jie gi gėrė iš dvasinės Uolos, kuri sekė paskui juos, o ta Uola buvo Kristus. ");
INSERT INTO lit_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","Ir nemurmėkite, kaip kai kurie iš jų murmėjo ir žuvo nuo žudytojo. ");
INSERT INTO lit_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","Todėl tas, kuris tariasi stovįs, težiūri, kad negriūtų. ");
INSERT INTO lit_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","Jūsų nėra pagriebęs joks kitas išmėginimas, kaip tik žmonėms įprastas. Bet ištikimas yra Dievas, kuris neleis jūsų mėginti labiau, negu galite pakelti, bet kartu su išmėginimu sukurs ir išeitį, kad galėtumėte ištverti. ");
INSERT INTO lit_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","Todėl, mano mylimieji, bėkite nuo stabgarbystės. ");
INSERT INTO lit_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","Kalbu kaip išmintingiems; apsvarstykite patys, ką sakau. ");
INSERT INTO lit_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","Laiminimo taurė, kurią laiminame, ar ji nėra bendrystė su Kristaus krauju? Duona, kurią laužome, ar ji nėra bendrystė su Kristaus kūnu? ");
INSERT INTO lit_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","Nes mes, daugelis, esame viena duona, vienas kūnas, kadangi mes visi dalijamės ta viena Duona. ");
INSERT INTO lit_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","Žiūrėkite į fizinį Izraelį! Αrgi tie, kurie valgo aukas, nėra aukuro bendrystės dalyviai? ");
INSERT INTO lit_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","Tad ką aš sakau? Ar kad stabas yra kas nors? Arba ar kad tai, kas aukojama stabams yra kas nors? ");
INSERT INTO lit_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","Priešingai sakau: kad tai, ką kitataučiai aukoja, aukoja velniams, o ne Dievui; bet nenoriu, kad būtumėte bendrystės dalyviai su velniais. ");
INSERT INTO lit_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","Jūs negalite gerti Viešpaties taurės ir velnių taurės; jūs negalite būti Viešpaties stalo ir velnių stalo dalininkai. ");
INSERT INTO lit_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","Ar kurstome, kad Viešpatį paimtų pavydas? Ar esame galingesni už jį? ");
INSERT INTO lit_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","„Viskas man yra teisėta!“ Bet ne viskas naudinga! „Viskas man yra teisėta!“ Bet ne viskas statydina! ");
INSERT INTO lit_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","Niekas teneieško savo, bet kiekvienas kito gerovės. ");
INSERT INTO lit_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","Taigi, ar valgote, ar geriate, ar šiaip ką darote, viską darykite Dievo šlovei. ");
INSERT INTO lit_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","Neduokite progos suklupti į nusižengimus nei žydui, nei graikui, nei Dievo bažnyčiai, ");
INSERT INTO lit_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","kaip ir aš visiems viskuo įtinku, neieškodamas savo, bet daugelio naudos, kad jie būtų išgelbėti. ");
INSERT INTO lit_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","Būkite mano sekėjai, kaip ir aš esu Kristaus sekėjas. ");
INSERT INTO lit_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","O aš jus giriu, broliai, kad jūs atsimenate visus mano nurodymus ir laikotės perduotų nurodymų, kokių jums perdaviau. ");
INSERT INTO lit_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","Bet noriu, kad žinotumėte, jog kiekvieno vyro galva yra Kristus, žmonos galva yra vyras, o Kristaus galva yra Dievas. ");
INSERT INTO lit_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","Nes vyras iš tiesų neturi apsidengti galvos, kadangi jis yra Dievo atvaizdas ir šlovė, bet moteris yra vyro šlovė. ");
INSERT INTO lit_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","nes vyras nėra iš moters, bet moteris iš vyro, ");
INSERT INTO lit_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","taip pat vyras nebuvo sukurtas moteriai, bet moteris vyrui. ");
INSERT INTO lit_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","Dėl šios priežasties moteris privalo turėti ant galvos valdymo ženklą dėl angelų. ");
INSERT INTO lit_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","Vis dėlto Viešpatyje nei vyras yra be moters, nei moteris be vyro. ");
INSERT INTO lit_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","nes, kaip moteris buvo paimta iš vyro, taip ir vyras ateina per moterį, o viskas yra iš Dievo. ");
INSERT INTO lit_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","Ar net ir pati prigimtis jūsų nemoko, kad jei vyras nešioja ilgus plaukus, jam yra gėda? ");
INSERT INTO lit_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","Bet jei moteris nešioja ilgus plaukus, tai yra garbė jai, nes plaukai jai duoti kaip apdangalas. ");
INSERT INTO lit_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","Bet, šitą paliepdamas, aš jūsų negiriu, kad taip sueinate, kad būna ne geresnis, bet blogesnis poveikis. ");
INSERT INTO lit_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","Nes, pirmiausia, girdžiu, kad jums sueinant bažnyčioje, tarp jūsų esama susiskaldymų, ir aš iš dalies tuo tikiu, ");
INSERT INTO lit_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","nes tarp jūsų ir turi būti atskalų, kad pasidarytų aiškūs tie tarp jūsų, kurie, po išmėginimo, sulaukė pritarimo. ");
INSERT INTO lit_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","Taigi, kai jūs sueinate į vieną vietą, tai ne Viešpaties vakarienės valgyti, ");
INSERT INTO lit_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","nes valgymo metu kiekvienas griebia iš anksto savąją vakarienę, tai vienas alksta, o kitas nusigeria! ");
INSERT INTO lit_vpl VALUES ("C111_22","076_11_22","1CO","11","22","22","Ką?! Nejaugi neturite namų, kuriuose tinka pavalgyti ir gerti?! Arba, ar jūs niekinate Dievo bažnyčią ir gėdinate tuos, kurie nieko neturi? Ką aš jums turėčiau pasakyti? Ar turėčiau jus girti? Negiriu už tai! ");
INSERT INTO lit_vpl VALUES ("C111_23","076_11_23","1CO","11","23","23","Nes aš gavau iš Viešpaties tai, ką jums ir perdaviau, kad Viešpats Jėzus tą naktį, kurią buvo išduotas, paėmė duoną, ");
INSERT INTO lit_vpl VALUES ("C111_24","076_11_24","1CO","11","24","24","ir padėkojęs ją laužė ir tarė: „Imkite, valgykite – tai yra mano kūnas, kuris už jus laužomas; tai darykite mano atminimui.“ ");
INSERT INTO lit_vpl VALUES ("C111_25","076_11_25","1CO","11","25","25","Tokiu pat būdu, po vakarienės valgymo jis paėmė ir taurę, sakydamas: „Ši taurė yra naujoji sandora mano krauju. Kiek kartų ją gersite, tai darykite mano atminimui.“ ");
INSERT INTO lit_vpl VALUES ("C111_26","076_11_26","1CO","11","26","26","Nes kiek kartų valgote šią duoną ir geriate šią taurę, jūs skelbiate Viešpaties mirtį, kol jis ateis. ");
INSERT INTO lit_vpl VALUES ("C111_27","076_11_27","1CO","11","27","27","Todėl jeigu kas nevertai valgys šią duoną ir gers Viešpaties taurę, bus kaltas prieš Viešpaties kūną ir kraują. ");
INSERT INTO lit_vpl VALUES ("C111_28","076_11_28","1CO","11","28","28","Bet žmogus tegul ištiria pats save, ir tokiu būdu jis tevalgo tos duonos ir tegeria iš tos taurės. ");
INSERT INTO lit_vpl VALUES ("C111_29","076_11_29","1CO","11","29","29","Nes tas, kuris valgo ir geria nevertai, valgo ir geria sau pasmerkimą, neišskirdamas Viešpaties kūno. ");
INSERT INTO lit_vpl VALUES ("C111_30","076_11_30","1CO","11","30","30","Dėl šios priežasties tarp jūsų yra daug silpnų bei sergančių ir nemažai miega. ");
INSERT INTO lit_vpl VALUES ("C111_31","076_11_31","1CO","11","31","31","Bet jei tikrai išskirtume savo neatitikimus, nebūtume teisiami. ");
INSERT INTO lit_vpl VALUES ("C111_32","076_11_32","1CO","11","32","32","Bet kai esame teisiami, esame Viešpaties drausminami, kad nebūtume nuteisti su pasauliu. ");
INSERT INTO lit_vpl VALUES ("C111_33","076_11_33","1CO","11","33","33","Taigi, mano broliai, kai sueinate valgyti, palaukite vieni kitų. ");
INSERT INTO lit_vpl VALUES ("C111_34","076_11_34","1CO","11","34","34","Ir jei kas alkanas, tepavalgo namie, kad nesueitumėte teismo užsitraukti. O kai tik atvyksiu, nurodymais sutvarkysiu likusius reikalus. ");
INSERT INTO lit_vpl VALUES ("C112_1","076_12_1","1CO","12","1","1","Bet nenoriu, broliai, kad nežinotumėte apie štai kokius dvasinius reikalus. ");
INSERT INTO lit_vpl VALUES ("C112_2","076_12_2","1CO","12","2","2","Jūs žinote, kad buvote kitataučiai, nuvedami pas tuos nebylius stabus, kaip kad nuvesdavo. ");
INSERT INTO lit_vpl VALUES ("C112_3","076_12_3","1CO","12","3","3","Todėl duodu jums žinoti, kad nė vienas, kalbėdamas Dievo Dvasios valdomas, nesako: „Prakeiktas Jėzus!“ Ir kad nė vienas negali sakyti; „Jėzus yra Viešpats“, jei ne Šventosios Dvasios valdomas. ");
INSERT INTO lit_vpl VALUES ("C112_4","076_12_4","1CO","12","4","4","O esama skirtingų malonės dovanų, tačiau ta pati Dvasia; ");
INSERT INTO lit_vpl VALUES ("C112_5","076_12_5","1CO","12","5","5","ir esama skirtingų tarnysčių, tačiau tas pats Viešpats; ");
INSERT INTO lit_vpl VALUES ("C112_6","076_12_6","1CO","12","6","6","Ir esama skirtingų veikimų, tačiau yra tas pats Dievas, kuris viską nuveikia visuose. ");
INSERT INTO lit_vpl VALUES ("C112_7","076_12_7","1CO","12","7","7","Bet kiekvienam yra duotas Dvasios pasireiškimas bendram labui. ");
INSERT INTO lit_vpl VALUES ("C112_8","076_12_8","1CO","12","8","8","Antai vienam per Dvasią duodamas išminties žodis, o kitam – pažinimo žodis pagal tą pačią Dvasią, ");
INSERT INTO lit_vpl VALUES ("C112_9","076_12_9","1CO","12","9","9","o kitokiam – tikėjimas ta pačia Dvasia, o kitam – gydymo dovanos ta pačia Dvasia, ");
INSERT INTO lit_vpl VALUES ("C112_12","076_12_12","1CO","12","12","12","Nes kaip kūnas yra vienas ir turi daug narių, ir visi to vieno kūno nariai, nors jų daug, yra vienas kūnas, taip yra ir Kristus. ");
INSERT INTO lit_vpl VALUES ("C112_13","076_12_13","1CO","12","13","13","Nes ir mes visi vienos Dvasios valdomi – tiek žydai, tiek kitataučiai, tiek vergai, tiek laisvieji, – buvome pakrikštyti į vieną kūną, ir visi buvome pagirdyti iš vienos Dvasios. ");
INSERT INTO lit_vpl VALUES ("C112_25","076_12_25","1CO","12","25","25","kad kūne nebūtų susiskaldymo, bet kad nariai vienodai rūpintųsi vieni kitais. ");
INSERT INTO lit_vpl VALUES ("C112_27","076_12_27","1CO","12","27","27","O jūs esate Kristaus kūnas ir, atskirai imant, nariai. ");
INSERT INTO lit_vpl VALUES ("C112_28","076_12_28","1CO","12","28","28","Ir Dievas pastatė į veikimo sritį bažnyčioje štai ką: pirma – apaštalus, antra – pranašus, trečia – mokytojus; po to – stebuklus, paskui – išgydymų dovanas, patarnavimus, vadovavimus, įvairias kalbas. ");
INSERT INTO lit_vpl VALUES ("C112_31","076_12_31","1CO","12","31","31","O uoliai siekite geriausiųjų dovanų. Bet vis dėlto aš jums rodau visa didžiai pranokstantį kelią. ");
INSERT INTO lit_vpl VALUES ("C113_1","076_13_1","1CO","13","1","1","Jeigu kalbu žmonių ir angelų kalbomis, bet neturiu meilės, esu pasidaręs tarsi skambantis varis ar žvangantis tuščiapuodis. ");
INSERT INTO lit_vpl VALUES ("C113_2","076_13_2","1CO","13","2","2","Ir jeigu turiu pranašystės dovaną ir suprantu visus slėpinius ir visą, ką įmanoma žinoti, ir jeigu turiu visą tikėjimą, kad galiu perkelti kalnus, bet neturiu meilės, esu niekas. ");
INSERT INTO lit_vpl VALUES ("C113_3","076_13_3","1CO","13","3","3","Ir jeigu išdalinu visą savo turtą vargšams maitinti, ir jeigu atiduodu savo kūną sudeginti, bet neturiu meilės, tai man neduoda jokios naudos. ");
INSERT INTO lit_vpl VALUES ("C113_4","076_13_4","1CO","13","4","4","Meilė ilgai pakenčia, daro tai, kas maloninga. Meilė nepavydi. Meilė nesigiria, nepasipučia, ");
INSERT INTO lit_vpl VALUES ("C113_5","076_13_5","1CO","13","5","5","nesielgia netinkamai, neieško sau naudos, nėra lengvai erzinama, nelaiko patirtų blogadarybių sąskaitos, ");
INSERT INTO lit_vpl VALUES ("C113_6","076_13_6","1CO","13","6","6","nesidžiaugia dėl neteisybės, bet džiaugiasi kartu su tiesa, ");
INSERT INTO lit_vpl VALUES ("C113_7","076_13_7","1CO","13","7","7","visa pakelia, visa tiki, viskuo viliasi, visa ištveria. ");
INSERT INTO lit_vpl VALUES ("C113_8","076_13_8","1CO","13","8","8","Meilė niekada nesibaigia; bet jeigu yra pranašavimai, jie bus pašalinti, jeigu yra kalbos, jos liausis; jeigu yra žinojimas, jis bus pašalintas, ");
INSERT INTO lit_vpl VALUES ("C113_9","076_13_9","1CO","13","9","9","nes mes žinome iš dalies ir pranašaujame iš dalies. ");
INSERT INTO lit_vpl VALUES ("C113_10","076_13_10","1CO","13","10","10","Bet kai ateis tai, kas yra tobula, tada tai, kas iš dalies, bus pašalinta. ");
INSERT INTO lit_vpl VALUES ("C113_11","076_13_11","1CO","13","11","11","Kai buvau vaikas, kalbėjau kaip vaikas, mąsčiau kaip vaikas, protavau kaip vaikas, bet kai tapau vyru, pašalinau tai, kas vaikiška. ");
INSERT INTO lit_vpl VALUES ("C113_12","076_13_12","1CO","13","12","12","Nes dabar matome veidrodžiu, mįslingu vaizdu, bet tuomet matysime veidas į veidą; dabar pažįstu iš dalies, bet tuomet pažinsiu išsamiai kaip ir esu išsamiai pažintas. ");
INSERT INTO lit_vpl VALUES ("C113_13","076_13_13","1CO","13","13","13","O dabar pasilieka tikėjimas, viltis, meilė – šie trys, bet jų didžiausia yra meilė. ");
INSERT INTO lit_vpl VALUES ("C114_1","076_14_1","1CO","14","1","1","Vykitės meilę ir uoliai siekite dvasinių dovanų, o labiau – kad pranašautumėte. ");
INSERT INTO lit_vpl VALUES ("C114_4","076_14_4","1CO","14","4","4","Kas kalba nežinoma kalba, save statydina, bet kas pranašauja, statydina bažnyčią. ");
INSERT INTO lit_vpl VALUES ("C114_17","076_14_17","1CO","14","17","17","Nes iš tiesų gerai dėkoji tu, bet kitas nestatydinamas. ");
INSERT INTO lit_vpl VALUES ("C114_20","076_14_20","1CO","14","20","20","Broliai, samprotavimų atžvilgiu nebūkite vaikai. Verčiau blogybės atžvilgiu būkite kūdikiai, bet samprotavimų atžvilgiu būkite subrendę. ");
INSERT INTO lit_vpl VALUES ("C114_26","076_14_26","1CO","14","26","26","Tai ką daryti, broliai? Kai sueinate, kiekvienas iš jūsų arba turi psalmę, arba turi pamokymą, arba turi kalbą, teikiamą pagal tam tikrą reiškimo sistemą, arba turi apreiškimą, arba turi vertimą. Viskas tebūna daroma statydinimui. ");
INSERT INTO lit_vpl VALUES ("C114_32","076_14_32","1CO","14","32","32","Ir pranašų dvasios yra pavaldžios pranašams, ");
INSERT INTO lit_vpl VALUES ("C114_33","076_14_33","1CO","14","33","33","nes Dievas yra ne sumaišties, bet ramybės Dievas, kaip visose šventųjų bažnyčiose. ");
INSERT INTO lit_vpl VALUES ("C114_34","076_14_34","1CO","14","34","34","Tegul jūsų moterys tyli bažnyčiose, nes joms neleidžiama kalbėti, bet joms skirta elgtis pavaldžiai, kaip sako ir įstatymas. ");
INSERT INTO lit_vpl VALUES ("C114_35","076_14_35","1CO","14","35","35","O jeigu jos nori ko nors išmokti, tepasiklausia namie savo vyrų, nes gėda moterims kalbėti bažnyčioje. ");
INSERT INTO lit_vpl VALUES ("C114_40","076_14_40","1CO","14","40","40","Viskas tebūna daroma padoriai ir tvarkingai. ");
INSERT INTO lit_vpl VALUES ("C115_1","076_15_1","1CO","15","1","1","Dabar, broliai, jums pareiškiu tą Evangeliją, kurią kaip gerą žinią jums paskelbiau, kurią ir priėmėte, kurioje ir stovite, ");
INSERT INTO lit_vpl VALUES ("C115_2","076_15_2","1CO","15","2","2","kuria ir esate išgelbėti, jei laikotės tokio pranešimo, kuriuo jums skelbiau gerą žinią, nebent tuščiai tikėjote. ");
INSERT INTO lit_vpl VALUES ("C115_3","076_15_3","1CO","15","3","3","Nes jums perdaviau pirmiausiai tai, ką ir pats gavau, – kad Kristus numirė už mūsų nuodėmes pagal šventraščius, ");
INSERT INTO lit_vpl VALUES ("C115_4","076_15_4","1CO","15","4","4","ir kad buvo palaidotas, ir kad prisikėlė trečiąją dieną pagal šventraščius, ");
INSERT INTO lit_vpl VALUES ("C115_5","076_15_5","1CO","15","5","5","ir kad jis pasirodė Kefui, po to Dvylikai. ");
INSERT INTO lit_vpl VALUES ("C115_6","076_15_6","1CO","15","6","6","Paskui jis pasirodė vienu metu daugiau negu penkiems šimtams brolių, kurių dauguma tebelieka iki dabar, nors ir kai kurie yra užmigę. ");
INSERT INTO lit_vpl VALUES ("C115_7","076_15_7","1CO","15","7","7","Paskui jis pasirodė Jokūbui, po to visiems apaštalams. ");
INSERT INTO lit_vpl VALUES ("C115_8","076_15_8","1CO","15","8","8","O visų paskiausiai, lyg ne laiku gimusiam, jis pasirodė ir man. ");
INSERT INTO lit_vpl VALUES ("C115_9","076_15_9","1CO","15","9","9","Nes aš esu mažiausias iš apaštalų, kuris nevertas, kad būčiau pavadintas apaštalu todėl, kad persekiojau Dievo bažnyčią. ");
INSERT INTO lit_vpl VALUES ("C115_10","076_15_10","1CO","15","10","10","Bet Dievo malone esu, kas esu, ir jo man suteiktoji malonė nebuvo bergždžia; priešingai – aš triūsiau daugiau negu jie visi, tačiau ne aš, bet Dievo malonė, kuri su manimi. ");
INSERT INTO lit_vpl VALUES ("C115_11","076_15_11","1CO","15","11","11","Taigi ar tai aš, ar jie, – taip mes skelbiame, ir taip jūs įtikėjote. ");
INSERT INTO lit_vpl VALUES ("C115_12","076_15_12","1CO","15","12","12","O jei Kristus yra skelbiamas, kad jis prisikėlė iš numirusių, tad kaipgi kai kurie tarp jūsų sako, jog nėra mirusiųjų prisikėlimo?! ");
INSERT INTO lit_vpl VALUES ("C115_17","076_15_17","1CO","15","17","17","ir jei Kristus nėra prikeltas, jūsų tikėjimas yra tuščias; jūs tebesate savo nuodėmėse! ");
INSERT INTO lit_vpl VALUES ("C115_18","076_15_18","1CO","15","18","18","Tokiu atveju ir užmigusieji Kristuje yra pražuvę! ");
INSERT INTO lit_vpl VALUES ("C115_19","076_15_19","1CO","15","19","19","Jeigu turime viltį dėl Kristaus tik šiame gyvenime, tai esame labiausiai apgailėtini iš visų žmonių. ");
INSERT INTO lit_vpl VALUES ("C115_20","076_15_20","1CO","15","20","20","Bet dabar Kristus yra prisikėlęs iš numirusių ir tapo užmigusiųjų pirmavaisiu. ");
INSERT INTO lit_vpl VALUES ("C115_21","076_15_21","1CO","15","21","21","Nes kadangi per žmogų atėjo mirtis, per žmogų atėjo ir mirusiųjų prisikėlimas. ");
INSERT INTO lit_vpl VALUES ("C115_22","076_15_22","1CO","15","22","22","Nes kaip visi miršta Adome, taip visi bus padaryti gyvi Kristuje. ");
INSERT INTO lit_vpl VALUES ("C115_25","076_15_25","1CO","15","25","25","Nes jis turi karaliauti, kol pats paguldys visus priešus po savo kojomis. ");
INSERT INTO lit_vpl VALUES ("C115_26","076_15_26","1CO","15","26","26","Kaip paskutinis priešas mirtis yra paverčiama niekais. ");
INSERT INTO lit_vpl VALUES ("C115_27","076_15_27","1CO","15","27","27","Nes jis visus dalykus ir asmenis padarė pavaldžius po jo kojomis. Bet kai jis sako, kad visus padarė pavaldžius, tai aišku, kad išskyrus tą, kuris visus padarė pavaldžius jam. ");
INSERT INTO lit_vpl VALUES ("C115_28","076_15_28","1CO","15","28","28","O kai visi bus padaryti jam pavaldūs, tada ir pats Sūnus bus padarytas pavaldus tam, kuris visus padarė pavaldžius jam, kad Dievas būtų viskas visame kame. ");
INSERT INTO lit_vpl VALUES ("C115_31","076_15_31","1CO","15","31","31","Mirštu kasdien – tai prisiekiu jūsų sukeltu džiūgavimu, kurį turiu Kristuje Jėzuje, mūsų Viešpatyje. ");
INSERT INTO lit_vpl VALUES ("C115_33","076_15_33","1CO","15","33","33","Nesiduokite suklaidinami: blogos draugijos gadina gerus papročius. ");
INSERT INTO lit_vpl VALUES ("C115_42","076_15_42","1CO","15","42","42","Taip ir su mirusiųjų prisikėlimu. Kūnas sėjamas gendamumo įveiktas, prikeliamas negendamumo įveiktas; ");
INSERT INTO lit_vpl VALUES ("C115_43","076_15_43","1CO","15","43","43","sėjamas negarbingumo įveiktas, prikeliamas šlovės įveiktas; sėjamas silpnumo įveiktas, prikeliamas galybės įveiktas. ");
INSERT INTO lit_vpl VALUES ("C115_45","076_15_45","1CO","15","45","45","Ir taip yra parašyta: „Pirmasis žmogus adomas tapo gyva siela“; Paskutinysis Adomas tapo gyvybę teikiančia Dvasia. ");
INSERT INTO lit_vpl VALUES ("C115_49","076_15_49","1CO","15","49","49","Ir kaip nešiojome žemiškojo atvaizdą, taip nešiosime ir dangiškojo atvaizdą. ");
INSERT INTO lit_vpl VALUES ("C115_51","076_15_51","1CO","15","51","51","Štai aš išdėstau jums slėpinį: mes ne visi užmigsime, bet visi būsime pakeisti į kitokius – ");
INSERT INTO lit_vpl VALUES ("C115_52","076_15_52","1CO","15","52","52","labai greitu laiku, akimirksniu, gaudžiant paskutiniam trimitui. Nes trimitas nuskambės, ir mirusieji bus prikelti negendantys, ir mes būsime pakeisti į kitokius. ");
INSERT INTO lit_vpl VALUES ("C115_53","076_15_53","1CO","15","53","53","Nes šiam gendančiam kūnui būtina apsivilkti negendamumu ir šiam mirtingam kūnui būtina apsivilkti nemirtingumu. ");
INSERT INTO lit_vpl VALUES ("C115_54","076_15_54","1CO","15","54","54","Ir kai šis gendantis kūnas apsivilks negendamumu ir šis mirtingas kūnas apsivilks nemirtingumu, tada išsipildys tas parašytas žodis: PERGALĖJE MIRTIS YRA PRARYTA! ");
INSERT INTO lit_vpl VALUES ("C115_55","076_15_55","1CO","15","55","55","O mirtie, kur tavo geluonis? O kape, kur tavo pergalė?“ ");
INSERT INTO lit_vpl VALUES ("C115_56","076_15_56","1CO","15","56","56","Mirties geluonis yra nuodėmė, o nuodėmės galia yra įstatymas. ");
INSERT INTO lit_vpl VALUES ("C115_57","076_15_57","1CO","15","57","57","Bet dėkui Dievui, kuris duoda mums pergalę per mūsų Viešpatį Jėzų Kristų. ");
INSERT INTO lit_vpl VALUES ("C115_58","076_15_58","1CO","15","58","58","Todėl, mano mylimieji broliai, būkite tvirti, nepajudinami, visuomet gausiai vykdydami Viešpaties darbą, žinodami, kad jūsų triūsas nėra veltui Viešpatyje. ");
INSERT INTO lit_vpl VALUES ("C116_1","076_16_1","1CO","16","1","1","O dėl rinkliavos šventiesiems: kaip nurodžiau Galatijos bažnyčioms, taip ir jūs darykite. ");
INSERT INTO lit_vpl VALUES ("C116_4","076_16_4","1CO","16","4","4","Ir jeigu bus tinkama, kad ir aš keliaučiau, tai jie keliaus su manimi. ");
INSERT INTO lit_vpl VALUES ("C116_9","076_16_9","1CO","16","9","9","nes man yra atsiverusios plačios ir veiksmingos durys, – o priešininkų daug. ");
INSERT INTO lit_vpl VALUES ("C116_13","076_16_13","1CO","16","13","13","Budėkite, tvirtai stovėkite tikėjime, elkitės vyriškai, būkite stiprūs. ");
INSERT INTO lit_vpl VALUES ("C116_14","076_16_14","1CO","16","14","14","Viską, ką darote, darykite su meile. ");
INSERT INTO lit_vpl VALUES ("C116_15","076_16_15","1CO","16","15","15","Maldauju jus, broliai (jūs pažįstate Stepono šeimyną, kad ji yra Achajos pirmasis vaisius, ir kad jie atsidavė tarnauti šventiesiems), ");
INSERT INTO lit_vpl VALUES ("C116_16","076_16_16","1CO","16","16","16","kad jūs taip pat tokiems elgtumėtės pavaldžiai ir kiekvienam bendradarbiaujančiam ir triūsiančiam. ");
INSERT INTO lit_vpl VALUES ("C116_17","076_16_17","1CO","16","17","17","Džiaugiuosi Stepono, Fortunato ir Achaiko atvykimu dėl to, kad jie parūpino tai, ko trūko iš jūsų pusės, ");
INSERT INTO lit_vpl VALUES ("C116_18","076_16_18","1CO","16","18","18","nes jie atgaivino mano dvasią – taip pat jūsų. Tad pripažinkite tokius žmones! ");
INSERT INTO lit_vpl VALUES ("C21_1","077_1_1","2CO","1","1","1","Paulius, Dievo valia Jėzaus Kristaus apaštalas, ir brolis Timotiejus – Dievo bažnyčiai, esančiai Korinte, ir visiems šventiesiems, esantiems visoje Achajoje. ");
INSERT INTO lit_vpl VALUES ("C21_2","077_1_2","2CO","1","2","2","Malonė jums ir ramybė nuo Dievo, mūsų Tėvo, ir Viešpaties Jėzaus Kristaus. ");
INSERT INTO lit_vpl VALUES ("C21_3","077_1_3","2CO","1","3","3","Tebūna palaimintas Dievas, tai yra mūsų Viešpaties Jėzaus Kristaus Tėvas, apstaus gailestingumo Tėvas ir visos paguodos Dievas, ");
INSERT INTO lit_vpl VALUES ("C21_4","077_1_4","2CO","1","4","4","kuris mus guodžia kiekviename mūsų prispaudime, kad būtume pajėgūs guosti tuos, kurie yra bet kokiame prispaudime, ta paguoda, kuria mes patys esame Dievo guodžiami, ");
INSERT INTO lit_vpl VALUES ("C21_5","077_1_5","2CO","1","5","5","nes kaip kentėjimai dėl Kristaus gausėja mums, taip per Kristų gausėja ir mūsų paguoda. ");
INSERT INTO lit_vpl VALUES ("C21_6","077_1_6","2CO","1","6","6","Ir jei kenčiame priespaudą, tai jūsų paguodai ir išgelbėjimui, kuris yra veiksmingas ištveriant tokius pačius kentėjimus, kuriuos ir mes kenčiame; arba, jei esame guodžiami, tai yra jūsų paguodai ir išgelbėjimui. ");
INSERT INTO lit_vpl VALUES ("C21_9","077_1_9","2CO","1","9","9","taip, mes patys savyje jautėmės gavę mirties nuosprendį, kad nepasitikėtume savimi, bet Dievu, kuris prikelia mirusius. ");
INSERT INTO lit_vpl VALUES ("C21_20","077_1_20","2CO","1","20","20","nes kiek tik yra Dievo pažadų, jie jame yra „taip“, ir jame yra „Amen“ tam, kad per mus būtų šlovė Dievui. ");
INSERT INTO lit_vpl VALUES ("C22_14","077_2_14","2CO","2","14","14","Taigi dėkui Dievui, kuris per Kristų visuomet mus veda pergalės eisenoje ir per mus paskleidžia savo pažinimo aromatą kiekvienoje vietoje, ");
INSERT INTO lit_vpl VALUES ("C23_5","077_3_5","2CO","3","5","5","Ne todėl, kad būtume savaime tinkami ką nors sumanyti tarytum iš savęs, bet mūsų tinkamumas yra iš Dievo, ");
INSERT INTO lit_vpl VALUES ("C23_6","077_3_6","2CO","3","6","6","kuris taip pat padarė mus tinkamais naujos sandaros tarnais – ne raidės, bet Dvasios, nes raidė užmuša, bet Dvasia duoda gyvybę. ");
INSERT INTO lit_vpl VALUES ("C23_8","077_3_8","2CO","3","8","8","tai kaip gi Dvasios tarnystė nebus dar labiau šlovinga?! ");
INSERT INTO lit_vpl VALUES ("C23_16","077_3_16","2CO","3","16","16","Tačiau kada tik ji atsiverčia į Viešpatį, šydas nuimamas. ");
INSERT INTO lit_vpl VALUES ("C23_17","077_3_17","2CO","3","17","17","Viešpats gi yra ta Dvasia, ir kur Viešpaties Dvasia, ten laisvė. ");
INSERT INTO lit_vpl VALUES ("C23_18","077_3_18","2CO","3","18","18","Bet mes visi, atidengtu veidu žiūrėdami lyg veidrodyje į Viešpaties šlovę, kaip tik Viešpaties, tai yra Dvasios, veikimu esame perkeičiami į tą patį atvaizdą iš šlovės į šlovę. ");
INSERT INTO lit_vpl VALUES ("C24_3","077_4_3","2CO","4","3","3","Bet jei ir mūsų evangelija yra paslėpta, ji yra paslėpta žūstantiems, ");
INSERT INTO lit_vpl VALUES ("C24_4","077_4_4","2CO","4","4","4","kurių atveju šio pasaulio dievas apakino jų kaip netikinčių protus, kad jiems nenušvistų Kristaus, kuris yra Dievo atvaizdas, šlovingos evangelijos šviesa. ");
INSERT INTO lit_vpl VALUES ("C24_5","077_4_5","2CO","4","5","5","Mat ne save pačius skelbiame, bet Kristų Jėzų – Viešpatį, o save – jūsų tarnais Jėzaus dėlei. ");
INSERT INTO lit_vpl VALUES ("C24_6","077_4_6","2CO","4","6","6","Nes Dievas, kuris liepė šviesai iš tamsos nušvisti, mūsų širdyse nušvito, kad suteiktų Dievo šlovės pažinimo šviesą Jėzaus Kristaus veide. ");
INSERT INTO lit_vpl VALUES ("C24_8","077_4_8","2CO","4","8","8","Mes visaip spaudžiami, tačiau nepriverčiami sielvartauti; sutrikdomi, bet nenusivylę; ");
INSERT INTO lit_vpl VALUES ("C24_9","077_4_9","2CO","4","9","9","persekiojami, bet neapleidžiami; mes parbloškiami, bet nesunaikinami, ");
INSERT INTO lit_vpl VALUES ("C24_10","077_4_10","2CO","4","10","10","visuomet šen ir ten nešiodamiesi kūne Viešpaties Jėzaus mirimą, kad ir Jėzaus gyvybė apsireikštų mūsų kūne. ");
INSERT INTO lit_vpl VALUES ("C24_11","077_4_11","2CO","4","11","11","Nes mes, gyvieji, dėl Jėzaus esame nuolat atiduodami mirčiai, kad ir Jėzaus gyvybė apsireikštų mūsų mirtingame kūne. ");
INSERT INTO lit_vpl VALUES ("C24_16","077_4_16","2CO","4","16","16","Todėl mes nepailstame. Atvirkščiai, nors mūsų išorinis žmogus ir genda, tačiau vidinis atnaujinamas diena iš dienos. ");
INSERT INTO lit_vpl VALUES ("C24_17","077_4_17","2CO","4","17","17","Nes mūsų lengvas prispaudimas, trunkantis tik akimirksnį, paruošia mums visa didžiai pranokstantį amžiną šlovės svorį, ");
INSERT INTO lit_vpl VALUES ("C24_18","077_4_18","2CO","4","18","18","mums žiūrint ne į regimus dalykus, bet į neregimus, nes regimieji dalykai yra laikini, bet neregimieji yra amžini. ");
INSERT INTO lit_vpl VALUES ("C25_6","077_5_6","2CO","5","6","6","Taigi visuomet būdami drąsiai nusiteikę ir žinodami, kad, kol gyvename namie, kūne, gyvename svetur nuo Viešpaties – ");
INSERT INTO lit_vpl VALUES ("C25_7","077_5_7","2CO","5","7","7","(nes vaikščiojame tikėjimu, ne regėjimu) – ");
INSERT INTO lit_vpl VALUES ("C25_8","077_5_8","2CO","5","8","8","mes esame drąsiai nusiteikę ir mieliau norėtume nebegyventi kūno namuose ir gyventi namie pas Viešpatį. ");
INSERT INTO lit_vpl VALUES ("C25_9","077_5_9","2CO","5","9","9","Todėl, ar būdami namie, ar svetur, uoliai stengiamės jam patikti. ");
INSERT INTO lit_vpl VALUES ("C25_10","077_5_10","2CO","5","10","10","Nes mes visi turime pasirodyti prieš Kristaus teismo krasę, kad kiekvienas gautų atlygį už kūnu padarytus dalykus, pagal tai, ką jis padarė, ar tai būtų gera ar bloga. ");
INSERT INTO lit_vpl VALUES ("C25_14","077_5_14","2CO","5","14","14","Nes Kristaus meilė verčia veikti mus, padariusius išvadą, kad jeigu vienas mirė už visus, tai visi mirė; ");
INSERT INTO lit_vpl VALUES ("C25_15","077_5_15","2CO","5","15","15","ir jis mirė už visus, kad tie, kurie gyvena, nuo šiol nebe sau gyventų, bet tam, kuris už juos mirė ir prisikėlė. ");
INSERT INTO lit_vpl VALUES ("C25_17","077_5_17","2CO","5","17","17","Taigi, jei kas yra Kristuje, tas yra naujas kūrinys; kas sena, praėjo, štai visa yra pasidariusi nauja. ");
INSERT INTO lit_vpl VALUES ("C25_18","077_5_18","2CO","5","18","18","Ir visa tai yra iš Dievo, kuris mus per Jėzų Kristų sutaikino su savimi ir davė mums sutaikinimo tarnystę, ");
INSERT INTO lit_vpl VALUES ("C25_19","077_5_19","2CO","5","19","19","būtent, kad Dievas buvo Kristuje sutaikindamas pasaulį su savimi, neįskaitydamas jiems jų nusižengimų, ir mums patikėdamas sutaikinimo žodį. ");
INSERT INTO lit_vpl VALUES ("C25_20","077_5_20","2CO","5","20","20","Taigi esame pasiuntiniai atstovaudami Kristui, tarsi per mus įspėdamas ragintų pats Dievas; atstovaudami Kristui jus meldžiame: „Susitaikykite su Dievu!“ ");
INSERT INTO lit_vpl VALUES ("C25_21","077_5_21","2CO","5","21","21","Nes mūsų labui jis pavertė nuodėme tą, kuris nepadarė nuodėmės, kad mes jame taptume Dievo teisumu. ");
INSERT INTO lit_vpl VALUES ("C26_1","077_6_1","2CO","6","1","1","Bendradarbiaudami su Dievu raginame jus nepriimti Dievo malonės nenaudingai, – ");
INSERT INTO lit_vpl VALUES ("C26_2","077_6_2","2CO","6","2","2","(nes jis sako: „AŠ IŠKLAUSIAU TAVE PRIIMTINU METU IR IŠGELBĖJIMO DIENĄ AŠ PADĖJAU TAU. Štai dabar ypač PRIIMTINAS METAS, štai dabar IŠGELBĖJIMO DIENA!) – ");
INSERT INTO lit_vpl VALUES ("C26_3","077_6_3","2CO","6","3","3","niekuo neduodami progos pasipiktinti, kad tarnystė nebūtų peikiama, ");
INSERT INTO lit_vpl VALUES ("C26_11","077_6_11","2CO","6","11","11","Mūsų burna atvirai jums prabilo, korintiečiai, mūsų širdis jums tapo erdvi. ");
INSERT INTO lit_vpl VALUES ("C26_12","077_6_12","2CO","6","12","12","Jūs nesate priversti sielvartauti per mus, bet esate priversti sielvartauti per savo pačių giliaširdiškus jausmus. ");
INSERT INTO lit_vpl VALUES ("C26_14","077_6_14","2CO","6","14","14","Nebūkite įkinkyti į nelygų jungą su netikinčiaisiais, nes kokia gi teisumo ir įstatymo pažeidinėjimo bendra veikla? Ir kokia gi šviesos bendrystė su tamsa? ");
INSERT INTO lit_vpl VALUES ("C26_15","077_6_15","2CO","6","15","15","Ir koks gi Kristaus susitarimas su Beliaru? Arba kokia gi tikinčiojo bendra dalis su netikinčiuoju? ");
INSERT INTO lit_vpl VALUES ("C26_16","077_6_16","2CO","6","16","16","Ir kokia gi Dievo šventyklos santarvė su stabais? Nes jūs esate gyvojo Dievo šventykla, kaip Dievas pasakė: „Aš gyvensiu juose ir vaikščiosiu tarp jų, ir būsiu jų Dievas, ir jie bus mano tauta.“ ");
INSERT INTO lit_vpl VALUES ("C26_17","077_6_17","2CO","6","17","17","Todėl „išeikite iš jų ir būkite atskirti, – sako Viešpats, – ir nepalieskite to, kas netyra; tada aš jus priimsiu ");
INSERT INTO lit_vpl VALUES ("C26_18","077_6_18","2CO","6","18","18","ir būsiu jums Tėvas, o jūs būsite man sūnūs ir dukterys,“ – sako Viešpats, Visagalis. ");
INSERT INTO lit_vpl VALUES ("C27_1","077_7_1","2CO","7","1","1","Taigi, mylimieji, turėdami šituos pažadus, apsivalykime nuo visokio kūno ir dvasios susitepimo, Dievo baimėje puoselėdami šventumą iki tikslo pasiekimo. ");
INSERT INTO lit_vpl VALUES ("C27_6","077_7_6","2CO","7","6","6","Bet Dievas, prislėgtųjų guodėjas, paguodė mus Tito atvykimu, ");
INSERT INTO lit_vpl VALUES ("C27_7","077_7_7","2CO","7","7","7","ir ne tik jo atvykimu, bet ir ta paguoda, kuria jis buvo paguostas dėl jūsų, pranešdamas mums apie jūsų stiprų norėjimą, jūsų dejones, jūsų uolumą dėl manęs. Tad dar labiau apsidžiaugiau. ");
INSERT INTO lit_vpl VALUES ("C27_8","077_7_8","2CO","7","8","8","Nors ir nuliūdinau jus laišku, nesigailiu, nors ir gailėjausi. Nes matau, kad tas laiškas jus nuliūdino, nors tai buvo tik kuriam laikui. ");
INSERT INTO lit_vpl VALUES ("C27_9","077_7_9","2CO","7","9","9","Dabar džiaugiuosi ne todėl, kad buvote nuliūdinti, bet kad buvote tokiu būdu nuliūdinti, jog atgailavote, nes patyrėte dievobaimingą liūdesį, todėl iš mūsų pusės jokiu atveju nebuvo jums žalos. ");
INSERT INTO lit_vpl VALUES ("C27_10","077_7_10","2CO","7","10","10","Mat dievobaimingas liūdesys sukelia neapgailestautiną atgailą, kurios pasekmė – išgelbėjimas, bet pasauliškas liūdesys sukelia mirtį. ");
INSERT INTO lit_vpl VALUES ("C27_11","077_7_11","2CO","7","11","11","Juk žiūrėkite: kaip tik tai, kad patyrėte dievobaimingą liūdesį, kiek sukėlė jumyse smarkumo, ir kiek noro atsakyti už save, ir kiek pykčio, ir kiek baimės, ir kiek stipraus norėjimo, ir kiek uolumo, ir kiek teisingumo įvykdymo! Jūs visais atžvilgiais parodėte, kad dabar esate švarūs šiame reikale. ");
INSERT INTO lit_vpl VALUES ("C27_13","077_7_13","2CO","7","13","13","Todėl mes buvome paguosti dėl jūsų paguodos, ir net dar labiau džiaugėmės dėl Tito džiaugsmo, nes jo dvasia buvo jūsų visų atgaivinta. ");
INSERT INTO lit_vpl VALUES ("C28_9","077_8_9","2CO","8","9","9","Jūs juk pažįstate mūsų Viešpaties Jėzaus Kristaus malonę, kad jis, būdamas turtingas, dėl jūsų tapo vargšu, kad per jo neturtą taptumėte turtingi. ");
INSERT INTO lit_vpl VALUES ("C28_21","077_8_21","2CO","8","21","21","rūpindamiesi tuo, kas dora ne tik Viešpaties akyse, bet ir žmonių akyse. ");
INSERT INTO lit_vpl VALUES ("C29_6","077_9_6","2CO","9","6","6","Ir sakau štai ką: kas šykščiai sėja, šykščiai ir pjaus, o kas apsčiai sėja, apsčiai ir pjaus. ");
INSERT INTO lit_vpl VALUES ("C29_7","077_9_7","2CO","9","7","7","Kiekvienas teduoda kaip nutaria savo širdyje, ne gailėdamas ar verčiamas; nes Dievas myli linksmą davėją. ");
INSERT INTO lit_vpl VALUES ("C29_15","077_9_15","2CO","9","15","15","Dėkui Dievui už jo neapsakomą dovaną! ");
INSERT INTO lit_vpl VALUES ("C210_3","077_10_3","2CO","10","3","3","Nes, nors vaikščiojame kūne, kovojame ne pagal kūniškumą, ");
INSERT INTO lit_vpl VALUES ("C210_4","077_10_4","2CO","10","4","4","(nes mūsų kovos ginklai nėra kūniški, bet galingi per Dievą tvirtovėms griauti) ");
INSERT INTO lit_vpl VALUES ("C210_5","077_10_5","2CO","10","5","5","nuversdami sumanymus ir visa, kas aukšta, kas išsikelia prieš Dievo pažinimą, ir atvesdami nelaisvėn kiekvieną mintį, kad paklustų Kristui ");
INSERT INTO lit_vpl VALUES ("C210_6","077_10_6","2CO","10","6","6","ir būdami pasirengę atlyginti už kiekvieną neklusnumą, kai jūsų klusnumas bus visiškas. ");
INSERT INTO lit_vpl VALUES ("C210_12","077_10_12","2CO","10","12","12","Nes nedrįstame savęs gretinti ar palyginti su kai kuriais, kurie save teigiamai pristato. Bet jie, matuodami save pagal save pačius ir palygindami save su savimi, nedaro išmingtingų išvadų. ");
INSERT INTO lit_vpl VALUES ("C210_17","077_10_17","2CO","10","17","17","O KAS GIRIASI, TESIGIRIA VIEŠPAČIU. ");
INSERT INTO lit_vpl VALUES ("C210_18","077_10_18","2CO","10","18","18","Nes ne tas pripažintas tinkamu, kuris teigiamai pristato save, bet kurį teigiamai pristato Viešpats. ");
INSERT INTO lit_vpl VALUES ("C211_1","077_11_1","2CO","11","1","1","O, kad jūs pakęstumėte truputėlį mano paikybės! Bet jūs ir pakenčiate mane. ");
INSERT INTO lit_vpl VALUES ("C211_2","077_11_2","2CO","11","2","2","Nes aš pavyduliauju dėl jūsų dievotu pavydu, nes vienam vyrui jus pažadėjau į žmonas, kad Kristui pristatyčiau jus kaip tyrą mergelę. ");
INSERT INTO lit_vpl VALUES ("C211_14","077_11_14","2CO","11","14","14","Ir nenuostabu, nes pats Šėtonas apsimeta šviesos angelu. ");
INSERT INTO lit_vpl VALUES ("C211_15","077_11_15","2CO","11","15","15","Tad nieko ypatingo, jeigu ir jo tarnautojai apsimeta teisumo tarnautojais, kurių galas atitiks jų darbus. ");
INSERT INTO lit_vpl VALUES ("C212_7","077_12_7","2CO","12","7","7","Ir kad nebūčiau perdėm išaukštintas dėl apreiškimų gausybės, man buvo duotas dyglys kūne, Šėtono pasiuntinys, kad mane smūgiuotų tam tikslui, kad nebūčiau perdėm išaukštintas. ");
INSERT INTO lit_vpl VALUES ("C212_8","077_12_8","2CO","12","8","8","Už tai tris kartus maldavau Viešpatį, kad tai nuo manęs atitrauktų. ");
INSERT INTO lit_vpl VALUES ("C212_9","077_12_9","2CO","12","9","9","Bet jis man tarė: „Pakanka tau mano malonės, nes mano jėga tampa tobula silpnume.“ Todėl verčiau mieliausiai girsiuosi savo silpnumais, kad Kristaus jėga apgaubtų mane. ");
INSERT INTO lit_vpl VALUES ("C212_10","077_12_10","2CO","12","10","10","Todėl gėriuosi silpnumais, įžeidimais, priverstiniais dalykais, persekiojimais, sielvartais dėl Kristaus, nes, kai esu silpnas, tada esu stiprus. ");
INSERT INTO lit_vpl VALUES ("C212_20","077_12_20","2CO","12","20","20","Mat aš bijau, kad kartais atvykęs nerasčiau jūsų tokių, kokių nenoriu, ir kad jūs nerastumėte manęs tokio, kokio jūs nenorite, kad kartais nebūtų nesutarimų, pavyduliavimų, pykčio proveržių, priešiškų norų pirmauti, apkalbų, šnibždėtų paskalų, pasipūtimų, sumišimų, ");
INSERT INTO lit_vpl VALUES ("C213_5","077_13_5","2CO","13","5","5","Patikrinkite save, ar esate tikėjime. Ištirkite save! Arba ar nepažįstate savęs, kad Jėzus Kristus yra jumyse – nebent esate Dievo vertinti atmestinai? ");
INSERT INTO lit_vpl VALUES ("C213_11","077_13_11","2CO","13","11","11","Galiausiai, broliai, linkiu jums sėkmės! Pasidarykite tobulai sunarinti, pasinaudokite paguoda, būkite vienos minties, sugyvenkite taikiai, o meilės ir ramybės Dievas bus su jumis. ");
INSERT INTO lit_vpl VALUES ("C213_14","077_13_14","2CO","13","14","14","Viešpaties Jėzaus Kristaus malonė, Dievo meilė ir Šventosios Dvasios bendrystė su jumis visais! ");
INSERT INTO lit_vpl VALUES ("GL1_1","078_1_1","GAL","1","1","1","Paulius, apaštalas – ne nuo žmonių, ir ne žmogaus įgaliojimu, bet įgaliojimu Jėzaus Kristaus ir Dievo Tėvo, kuris prikėlė jį iš numirusiųjų, – ");
INSERT INTO lit_vpl VALUES ("GL1_2","078_1_2","GAL","1","2","2","ir visi su manimi esantys broliai Galatijos bažnyčioms. ");
INSERT INTO lit_vpl VALUES ("GL1_3","078_1_3","GAL","1","3","3","Malonė jums ir ramybė nuo Dievo Tėvo ir mūsų Viešpaties Jėzaus Kristaus, ");
INSERT INTO lit_vpl VALUES ("GL1_4","078_1_4","GAL","1","4","4","atidavusio save už mūsų nuodėmes, kad mus išgelbėtų iš dabartinio blogo amžiaus pagal valią mūsų Dievo ir Tėvo, ");
INSERT INTO lit_vpl VALUES ("GL1_5","078_1_5","GAL","1","5","5","kuriam tebūna šlovė per amžių amžius! Amen. ");
INSERT INTO lit_vpl VALUES ("GL1_6","078_1_6","GAL","1","6","6","Stebiuosi, kad jūs nuo To, kuris pašaukė jus į Kristaus malonę, taip greitai persimetate prie kitos rūšies „evangelijos“, ");
INSERT INTO lit_vpl VALUES ("GL1_7","078_1_7","GAL","1","7","7","kuri nėra tos pačios rūšies, bet tik yra kai kurie jus sutrikdantys žmonės, kurie norėtų iškreipti Kristaus Evangeliją. ");
INSERT INTO lit_vpl VALUES ("GL1_8","078_1_8","GAL","1","8","8","Bet jeigu net mes patys ar angelas iš dangaus jums skelbtų kitokią „evangeliją“, negu tą Evangeliją, kurią jums paskelbėme, – tebūna prakeiktas! ");
INSERT INTO lit_vpl VALUES ("GL1_11","078_1_11","GAL","1","11","11","Bet aš duodu jums žinoti, broliai, kad mano paskelbtoji Evangelija nėra pagal žmoniją, ");
INSERT INTO lit_vpl VALUES ("GL1_12","078_1_12","GAL","1","12","12","nes nei iš žmogaus ją gavau, nei žmogaus jos buvau išmokytas, bet Jėzaus Kristaus apreiškimu. ");
INSERT INTO lit_vpl VALUES ("GL2_7","078_2_7","GAL","2","7","7","bet priešingai, pamatę, kad man buvo patikėta Evangelija neapipjaustytiesiems, kaip Petrui apipjaustytiesiems – ");
INSERT INTO lit_vpl VALUES ("GL2_14","078_2_14","GAL","2","14","14","Bet kai pamačiau, kad jie nevaikščioja tiesiai pagal tą Evangelijos tiesą, tariau Petrui visų akivaizdoje: „Jei tu, būdamas žydas, gyveni kitatautiškai, o ne žydiškai, kodėl verti kitataučius gyventi taip, kaip žydai?“ ");
INSERT INTO lit_vpl VALUES ("GL2_15","078_2_15","GAL","2","15","15","Mes, kurie prigimtimi žydai ir ne „kitataučių kilmės nusidėjėliai“, ");
INSERT INTO lit_vpl VALUES ("GL2_16","078_2_16","GAL","2","16","16","žinodami, jog žmogus neišteisinamas įstatymo darbais, bet per tikėjimą Jėzumi Kristumi – ir mes pasitikėjome Kristumi Jėzumi, kad būtume išteisinti tikėjimu Kristumi, o ne įstatymo darbais; nes įstatymo darbais nebus išteisintas nė vienas žmogus. ");
INSERT INTO lit_vpl VALUES ("GL2_17","078_2_17","GAL","2","17","17","O jeigu siekdami būti išteisinti per Kristų, ir mes patys esame rasti esant nusidėjėliais, ar dėl to Kristus yra nuodėmės tarnas? Anaiptol! Ne! ");
INSERT INTO lit_vpl VALUES ("GL2_20","078_2_20","GAL","2","20","20","Buvau nukryžiuotas su Kristumi, tačiau gyvenu – nors nebe aš, bet gyvena manyje Kristus. Ir dabar, tą gyvenimą, kurį gyvenu kūne, gyvenu tikėjimu Dievo Sūnumi, kuris mylėjo mane ir atidavė save už mane. ");
INSERT INTO lit_vpl VALUES ("GL3_6","078_3_6","GAL","3","6","6","Lygiai taip pat ABRAOMAS PASITIKĖJO DIEVU, IR TAI JAM BUVO ĮSKAITYTA KAIP TEISUMAS. ");
INSERT INTO lit_vpl VALUES ("GL3_7","078_3_7","GAL","3","7","7","Todėl žinokite, kad tie, kurie yra iš tikėjimo, tie yra Abraomo vaikai. ");
INSERT INTO lit_vpl VALUES ("GL3_8","078_3_8","GAL","3","8","8","Ir šventraštis, numatydamas, kad Dievas tikėjimu išteisina kitataučius, iš anksto paskelbė Abraomui Evangeliją: „Tavyje bus palaimintos visos tautos.“ ");
INSERT INTO lit_vpl VALUES ("GL3_9","078_3_9","GAL","3","9","9","Taigi tie, kurie yra iš tikėjimo, yra palaiminami su tikinčiuoju Abraomu. ");
INSERT INTO lit_vpl VALUES ("GL3_11","078_3_11","GAL","3","11","11","Bet kad Dievo akyse niekas neišteisinamas įstatymu, yra aišku, nes teisusis tikėjimu gyvens. ");
INSERT INTO lit_vpl VALUES ("GL3_12","078_3_12","GAL","3","12","12","Bet įstatymas nesiremia tikėjimu; priešingai, „JUOS VYKDANTIS ŽMOGUS GYVENS JAIS“. ");
INSERT INTO lit_vpl VALUES ("GL3_13","078_3_13","GAL","3","13","13","Kristus mus išpirko iš įstatymo prakeikimo, už mus tapdamas prakeikimu, nes yra parašyta: „Prakeiktas kiekvienas, kuris kybo ant medžio“, – ");
INSERT INTO lit_vpl VALUES ("GL3_16","078_3_16","GAL","3","16","16","Ir pažadai buvo duoti Abraomui ir jo sėklai. Jis nesako „ir sėkloms“, kaip daugeliui; bet kaip vienai „ir tavo sėklai“, kuri yra Kristus. ");
INSERT INTO lit_vpl VALUES ("GL3_18","078_3_18","GAL","3","18","18","Nes jeigu paveldėjimas įgyjamas įstatymu, tai jau nebe pažadu. Bet Dievas dovanojo jį Abraomui pažadu. ");
INSERT INTO lit_vpl VALUES ("GL3_19","078_3_19","GAL","3","19","19","Tai kam reikalingas įstatymas? Jis, įsakytas per angelus tarpininko ranka, buvo pridėtas dėl nusižengimų, kol ateis Sėkla, kuriai buvo duotas pažadas. ");
INSERT INTO lit_vpl VALUES ("GL3_20","078_3_20","GAL","3","20","20","Tarpininkas gi nėra reikalingas, kai yra tik viena šalis, bet Dievas tėra vienas. ");
INSERT INTO lit_vpl VALUES ("GL3_21","078_3_21","GAL","3","21","21","Ar tad įstatymas priešingas Dievo pažadams? Anaiptol! Ne! Nes jei būtų buvę duotas įstatymas, galintis teikti gyvybę, tai teisumas tikrai būtų įgyjamas įstatymu. ");
INSERT INTO lit_vpl VALUES ("GL3_22","078_3_22","GAL","3","22","22","Bet šventraštis visus uždarė nuodėmingume, kad tikėjimu Jėzumi Kristumi tai, kas pažadėta, būtų duotas tiems, kurie tiki. ");
INSERT INTO lit_vpl VALUES ("GL3_23","078_3_23","GAL","3","23","23","Bet prieš ateinant tikėjimui, mes buvome saugomi įstatymo valdžioje, uždaryti tikėjimui, kuris po to turėjo būti apreikštas. ");
INSERT INTO lit_vpl VALUES ("GL3_24","078_3_24","GAL","3","24","24","Tad įstatymas buvo lydintis mūsų auklėtojas iki Kristaus, kad būtume išteisinti tikėjimu. ");
INSERT INTO lit_vpl VALUES ("GL3_25","078_3_25","GAL","3","25","25","O tikėjimui atėjus, nebesame auklėtojo valdžioje. ");
INSERT INTO lit_vpl VALUES ("GL3_26","078_3_26","GAL","3","26","26","Nes jūs visi esate Dievo vaikai per tikėjimą Kristumi Jėzumi. ");
INSERT INTO lit_vpl VALUES ("GL3_27","078_3_27","GAL","3","27","27","Nes jūs visi, kurie buvote pakrikštyti į Kristų, apsivilkote Kristumi. ");
INSERT INTO lit_vpl VALUES ("GL3_28","078_3_28","GAL","3","28","28","Nėra nei žydo, nei graiko, nėra nei vergo, nei laisvojo, nėra nei vyriškos lyties žmogaus, nei moteriškos lyties žmogaus, nes jūs visi esate viena Kristuje Jėzuje. ");
INSERT INTO lit_vpl VALUES ("GL3_29","078_3_29","GAL","3","29","29","O jeigu jūs esate Kristaus, tai esate Abraomo sėkla ir paveldėtojai pagal pažadą. ");
INSERT INTO lit_vpl VALUES ("GL4_1","078_4_1","GAL","4","1","1","Dabar sakau, kad, kol paveldėtojas yra nepilnametis, jis niekuo nesiskiria nuo tarno, nors yra visa ko šeimininkas, ");
INSERT INTO lit_vpl VALUES ("GL4_2","078_4_2","GAL","4","2","2","bet yra globėjų ir prievaizdų valdžioje iki tėvo nustatyto laiko. ");
INSERT INTO lit_vpl VALUES ("GL4_3","078_4_3","GAL","4","3","3","Taip ir mes, kai buvome nepilnamečiai, buvome laikomi priverstiniam tarnavimui pasaulio pradmenims. ");
INSERT INTO lit_vpl VALUES ("GL4_4","078_4_4","GAL","4","4","4","Bet, atėjus laiko pilnatvei, Dievas atsiuntė savo Sūnų, gimusį iš moters, gimusį įstatymo valdžioje, ");
INSERT INTO lit_vpl VALUES ("GL4_5","078_4_5","GAL","4","5","5","kad išpirktų esančius įstatymo valdžioje, kad įgytume įsūnijimą. ");
INSERT INTO lit_vpl VALUES ("GL4_6","078_4_6","GAL","4","6","6","Ir kadangi esate sūnūs, Dievas atsiuntė į jūsų širdis savo Sūnaus Dvasią, šaukiančią: „Aba, Tėve! ");
INSERT INTO lit_vpl VALUES ("GL4_7","078_4_7","GAL","4","7","7","Taigi tu jau nebesi priverstinis tarnas, bet sūnus; o jeigu sūnus, tai ir Dievo paveldėtojas per Kristų. ");
INSERT INTO lit_vpl VALUES ("GL5_1","078_5_1","GAL","5","1","1","Todėl tvirtai stovėkite laisvėje, kuria Kristus mus išlaisvino, ir nebūkite vėl įsipainioję į vergystės jungą. ");
INSERT INTO lit_vpl VALUES ("GL5_4","078_5_4","GAL","5","4","4","Jūs, kurie siekiate būti išteisinti įstatymu, esate be poveikio nuo Kristaus – jūs esate išpuolę iš malonės. ");
INSERT INTO lit_vpl VALUES ("GL5_5","078_5_5","GAL","5","5","5","Tačiau mes laukiame teisumo, kurio užtikrintai vilimės, tikėjimo pagrindu Dvasios pagalba. ");
INSERT INTO lit_vpl VALUES ("GL5_6","078_5_6","GAL","5","6","6","Nes Kristuje Jėzuje nieko neįstengia padaryti nei apipjaustymas, nei neapipjaustymas, verčiau tikėjimas, darantis poveikį per meilę. ");
INSERT INTO lit_vpl VALUES ("GL5_13","078_5_13","GAL","5","13","13","Nes jūs, broliai, buvote pašaukti į laisvę; tik nenaudokite laisvės kaip progos kūnui, bet meile tarnaukite vienas kitam. ");
INSERT INTO lit_vpl VALUES ("GL5_16","078_5_16","GAL","5","16","16","Tad sakau: vaikščiokite Dvasia, ir nevykdysite kūno geidulių. ");
INSERT INTO lit_vpl VALUES ("GL5_19","078_5_19","GAL","5","19","19","Aiškūs gi yra kūno darbai, kurie yra svetimavimas, paleistuvavimas, netyrumas, palaidumas, ");
INSERT INTO lit_vpl VALUES ("GL5_20","078_5_20","GAL","5","20","20","stabgarbystė, užbūrimas narkotikais, priešiškumai, nesantaika, pavydūs rungtyniavimai, pykčio proveržiai, priešiškas noras pirmauti, maištavimai, atskalos, ");
INSERT INTO lit_vpl VALUES ("GL5_21","078_5_21","GAL","5","21","21","pavydai, žmogžudystės, girtavimai, orgijos ir panašūs dalykai, apie kuriuos aš sakau iš anksto, kaip ir anksčiau sakiau, kad tie, kurie atlikinėja tokius dalykus, nepaveldės Dievo karalystės. ");
INSERT INTO lit_vpl VALUES ("GL5_22","078_5_22","GAL","5","22","22","Bet Dvasios vaisius yra meilė, džiaugsmas, ramybė, didi kantrybė, švelnumas, geradarystė, ištikimybė, ");
INSERT INTO lit_vpl VALUES ("GL5_23","078_5_23","GAL","5","23","23","romumas, susivaldymas – prieš tokius nėra įstatymo. ");
INSERT INTO lit_vpl VALUES ("GL5_24","078_5_24","GAL","5","24","24","Ir kurie yra Kristaus, tie nukryžiavo kūno viršenybę kartu su jos potraukiais ir geismais. ");
INSERT INTO lit_vpl VALUES ("GL5_25","078_5_25","GAL","5","25","25","Jei gyvename Dvasia, tai ir padoriai vaikščiokime Dvasia. ");
INSERT INTO lit_vpl VALUES ("GL5_26","078_5_26","GAL","5","26","26","Nebesiekime šlovės už tuštybes, erzindami vieni kitiems, pavydėdami vieni kitiems. ");
INSERT INTO lit_vpl VALUES ("GL6_1","078_6_1","GAL","6","1","1","Broliai, jei žmogus ir būtų pagautas nusižengime, jūs, kurie esate dvasiški, pataisykite tokį su romia dvasia, kiekvienas žiūrėdamas savęs, kad ir tu nebūtum sugundytas. ");
INSERT INTO lit_vpl VALUES ("GL6_2","078_6_2","GAL","6","2","2","Nešiokite vieni kitų naštas, ir taip įvykdykite Kristaus įstatymą. ");
INSERT INTO lit_vpl VALUES ("GL6_6","078_6_6","GAL","6","6","6","Tas, kuris lavinamas žodžiu, tegul dalijasi visomis savo gėrybėmis su tuo, kuris lavina. ");
INSERT INTO lit_vpl VALUES ("GL6_7","078_6_7","GAL","6","7","7","Nesiduokite suklaidinami! Dievas nesiduoda išjuokiamas! Nes ką tik žmogus sėja, tą ir pjaus. ");
INSERT INTO lit_vpl VALUES ("GL6_8","078_6_8","GAL","6","8","8","Nes kas sėja savo kūniškajam aš, iš kūniškojo aš pjaus sugedimą, bet kas sėja Dvasiai, iš Dvasios pjaus amžiną gyvenimą. ");
INSERT INTO lit_vpl VALUES ("GL6_9","078_6_9","GAL","6","9","9","Tad nenuvarkime darydami gera, nes atėjus metui pjausime, jei nenuilsime. ");
INSERT INTO lit_vpl VALUES ("GL6_10","078_6_10","GAL","6","10","10","Išvada tokia: kada tik turime progą, darykime gera visiems, ypač tikėjimo namiškiams. ");
INSERT INTO lit_vpl VALUES ("GL6_14","078_6_14","GAL","6","14","14","Bet anaiptol nesigiriu nieku kitu, kaip tik mūsų Viešpaties Jėzaus Kristaus kryžiumi, kuriuo pasaulis man nukryžiuotas ir aš pasauliui. ");
INSERT INTO lit_vpl VALUES ("GL6_15","078_6_15","GAL","6","15","15","Nes Kristuje Jėzuje nieko neįstengia padaryti nei apipjaustymas, nei neapipjaustymas, bet tik naujas kūrinys. ");
INSERT INTO lit_vpl VALUES ("GL6_16","078_6_16","GAL","6","16","16","Ir visi, kurie padoriai vaikščioja pagal šią taisyklę, tebūna jiems ramybė ir gailestingumas, ir Dievo Izraeliui. ");
INSERT INTO lit_vpl VALUES ("GL6_17","078_6_17","GAL","6","17","17","Nuo šiol tegul niekas nebevargina manęs, nes savo kūne nešioju Viešpaties Jėzaus žymes. ");
INSERT INTO lit_vpl VALUES ("GL6_18","078_6_18","GAL","6","18","18","Broliai, mūsų Viešpaties Jėzaus Kristaus malonė tebūna su jūsų dvasia. Amen. ");
INSERT INTO lit_vpl VALUES ("EP1_1","079_1_1","EPH","1","1","1","Paulius, Dievo valia Jėzaus Kristaus apaštalas, šventiesiems, esantiems Efeze, tai yra ištikimiesiems Kristuje Jėzuje. ");
INSERT INTO lit_vpl VALUES ("EP1_2","079_1_2","EPH","1","2","2","Malonė jums ir ramybė nuo Dievo, mūsų Tėvo, ir Viešpaties Jėzaus Kristaus. ");
INSERT INTO lit_vpl VALUES ("EP1_3","079_1_3","EPH","1","3","3","Tebūna palaimintas mūsų Viešpaties Jėzaus Kristaus Dievas ir Tėvas, kuris palaimino mus Kristuje kiekviena dvasine palaima dangaus srityse ");
INSERT INTO lit_vpl VALUES ("EP1_4","079_1_4","EPH","1","4","4","šitaip: jis išsirinko mus jame prieš pasaulio įkūrimą, kad mes būtume prieš jį šventi ir nepeiktini meilėje, ");
INSERT INTO lit_vpl VALUES ("EP1_5","079_1_5","EPH","1","5","5","sau iš anksto paskyręs mus pilnateisių vaikų įsūnystei per Jėzų Kristų pagal savo valios palankumą, ");
INSERT INTO lit_vpl VALUES ("EP1_6","079_1_6","EPH","1","6","6","kad būtų giriama šlovė jo malonės, kuria jis padarė mus malone apdovanotaisiais Mylimajame. ");
INSERT INTO lit_vpl VALUES ("EP1_7","079_1_7","EPH","1","7","7","Jame turime išpirkimą per jo kraują – nusižengimų atleidimą – pagal turtingumą jo malonės, ");
INSERT INTO lit_vpl VALUES ("EP1_8","079_1_8","EPH","1","8","8","kurios jis gausiai sute