﻿USE sofia;
DROP TABLE IF EXISTS sofia.lip_vpl;
CREATE TABLE lip_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES lip_vpl WRITE;
INSERT INTO lip_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Aye nyamfo ni bana ba ǝsuǝ Yesu Kristo wǝ ni Oka David eto ufluflu lɛbɔ utsyi, nya David ni ufluflu wǝ lɛbɔ utsyi Abraham eto kafo. ");
INSERT INTO lip_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Idu lǝ Abraham ibǝ Oka David ǝsuǝǝ, nnyǝ antomǝ ba ntǝkǝ lǝ bǝtsyuǝ ǝsuǝ. Abraham léle Isak wǝ léle Yakob wǝ léle ");
INSERT INTO lip_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda ku wǝ bayimisani. Yuda ku wǝ usiǝ Tamai léle Perez ku Zera, nya Perez léle Hezron. Hezron léle Aram, nya wuntsya léle Aminadab. ");
INSERT INTO lip_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aminadab léle Naheson wǝ léle Salmon. ");
INSERT INTO lip_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon ku Rahab léle Boaz, nya Boaz ku Rut léle Obed. Obed léle Isai, ");
INSERT INTO lip_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","nya Isai léle Oka David. Nya idu lǝ Oka David ǝsuǝ isu lefe nǝ Babiloniafɔ dítsyi lema lǝ Israel bebi ǝsuǝ nya bǝmuǝ mǝ bésuko mǝ kasɔɔ, mǝ antomǝ ba dítǝkǝ lǝ betsyuǝ ǝsuǝ ni mba lǝǝbǝ mfo nɛ. Oka David ku usio wǝ lídi Uria eto usiǝ wǝ ɔ́lɛ ófo úfii, ále Salomo. ");
INSERT INTO lip_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomo ále Rehoboam wǝ léle Abiya. Abiya tsya léle Asa, ");
INSERT INTO lip_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","nya Asa léle Yosefat. Yosefat léle Yoram wǝ léle Uziya. ");
INSERT INTO lip_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uziya léle Yotam wǝ léle Ahaz wǝ léle Hezekiya wǝ léle Manase. ");
INSERT INTO lip_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Manase léle Amon, nya Amon léle Yosiya wǝ léle ");
INSERT INTO lip_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yekoniya ku wǝ bayimisani lǝ Babilonia lɛkɛfe. ");
INSERT INTO lip_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Idu lefe nǝ Israel bebi ditsyi Babilonia bǝbǝ isu ese lefe nǝ bále Yesu, mba bále ku mǝ antomǝ eto aye ni mba lǝǝbǝ mfo nɛ. Yekoniya léle Sealtiel wǝ léle Zerubabel wǝ léle ");
INSERT INTO lip_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Abihud, nya wuntsya léle Elyakim. Elyakim léle Azur, ");
INSERT INTO lip_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","nya Azur léle Sadok wǝ léle Akim wǝ léle Elihud. ");
INSERT INTO lip_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Elihud léle Eleazar, nya Eleazar léle Matan, nya wuntsya léle ");
INSERT INTO lip_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakob wǝ léle Yosef wǝ dífi Maria wǝ léle Yesu wǝ baakpo Nwǝ Onanto Lékpo Ɔhile Utsyǝ. ");
INSERT INTO lip_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Itǝ eso idu lǝ Abraham isu Oka David eto lelefe eyifo alefe lefosi ana, nya idu lǝ Oka David ǝsuǝ isu lefe nǝ Babiloniafɔ dímuǝ Israel bebi besuko mǝ kasɔ lǝ Babiloniaa, eyifo alefe lefosi ana. Nya isi idu lefe nǝmfó ibǝ lefe nǝ bále Nwǝ Onanto Lékpo Ɔhile Utsyǝ, eyifo alefe lefosi ana. ");
INSERT INTO lip_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Nnyǝ mǝ ɛyɛ fɛ bále Yesu Kristo. Bátɔ Maria bǝtǝ Yosef, tsya fɛ bookpa wǝǝ, Maria ǝnyǝ nkǝ ufi ɔlɛ kafo. Onanto eto Lɛwɔnɔ eto ǝsuǝale dítǝ íbǝ itǝ nko. ");
INSERT INTO lip_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yosef eyifo utidi sɛɛ lǝ Onanto eto ǝnǝmi. Fɛɛ se wóanla nkǝ woakpo Maria eto ǝnǝmi kasɔ lǝ kusǝ komǝ eto ǝnǝmi esoo, úbu disi nkǝ lǝ oyani wǝ kpoo kalɔkalɔ. ");
INSERT INTO lip_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Lefe nǝ úfi nsusu bomfoo, Onanto eto ɔtɔnkpe utsyuǝ ǝlǝkǝ ǝsuǝ óte wǝ lǝ kola kǝmiǝ, nya ɔ́tɛyi wǝ nkǝ, “Yosef, Oka David eto kafo eto ubi, mante sikpi ku fǝ usiǝ Maria bokpa kesuko fǝ ɔflɔ. Itsyise kafo ka ɔnlɛ mfoo, Onanto eto Lɛwɔnɔ eto ǝsuǝale ǝsuǝ itsyi. ");
INSERT INTO lip_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nya woole ubisaibi. Nya fǝ Yosef luutǝkǝ wǝ diye fǝ Yesu, itsyise wǝ ni nwǝ luulǝkǝ wǝ betidi utsyiko lǝ abua ǝsuǝ nɛ.” ");
INSERT INTO lip_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Asa nyamfo ǝbǝ itǝ lǝ Maria ǝsuǝ fe kase Onanto lɛtɛyi utsyǝ ɛyɛ lǝ wǝ unyɛlǝkǝtidi ǝsuǝ nkǝ yuubǝ itǝ sitinti. Ɔ́tɛyi nkǝ, ");
INSERT INTO lip_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Kebitɛ kǝtsyuǝ ka lenyi osani ǝbɔlɛ kafo nya woole ubisaibi. Nya betidi lookpo wǝ bǝnkǝ Imanuel.” Nnya kasɔ ni bǝnkǝ Onanto si ko bo. ");
INSERT INTO lip_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Lǝ nyaso se Yosef lésanklii, ókpa Maria, úyifo wǝ usiǝ fe kase Onanto eto ɔtɔnkpe ǝmǝ lɛtɛyi wǝ. ");
INSERT INTO lip_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Fɛɛ Yosef ku Maria mánte bǝtsyuǝ fe usǝ ku usiǝ isu ese lefe nǝ óle wǝ ubisaibi ǝmǝ. Nya Yosef dítǝkǝ wǝ diye nkǝ Yesu. ");
INSERT INTO lip_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Bále Yesu lǝ umǝ wǝ baakpo Betlehem lǝ Yudea eto kasɔ lǝ lefe nǝ Oka Herodes díkedi seka lǝ ke ǝsuǝ. Nya lǝ lefe nǝmfó ǝsuǝǝ, babesibe bǝtsyuǝ ba léte asa ɛyɛ lǝ olalɛlɛ befandebi eto ǝtsyǝbi ǝsuǝ etsyi kofekatokɔ bǝbǝ Yerusalem. ");
INSERT INTO lip_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Nya bátɔ bǝnkǝ, “Sieti bále ubi wǝ luudi Yudafɔ eto oka ǝmǝ? Búnyǝ wǝ sefandebi lǝ kofekatokɔ. Nya búbǝ boǝ boesumu wǝ.” ");
INSERT INTO lip_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Lefe nǝ Oka Herodes lɛnɔ ditiki nǝmfoo, difufu ǝmuǝ wǝ ku betidi ba kenke lɛkɛ lǝ Yerusalem mfó. ");
INSERT INTO lip_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Nyaso ókpadi Onanto eto besunyǝ ninǝ ku afi eto bateasa nya ɔ́tɔ mǝ nkǝ, “Sieti boole Nwǝ Onanto Lékpo Ɔhile Utsyǝ ǝmǝ?” ");
INSERT INTO lip_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Mfó nya bátɛyi wǝ bǝnkǝ, “Betlehem lǝ Yudea eto kasɔ, itsyise nko Onanto eto Unyɛlǝkǝtidi lɛwɔni útsyǝ nkǝ, ");
INSERT INTO lip_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Fǝ Betlehem lǝ Yuda eto kasɔ, emenyifo ɔkɛkɛ lǝ Yuda eto kǝmǝnkplɛ nti. Itsyise lǝ fǝǝ, nya nwǝ luudi ɔtɔnkotɔnko wǝ lɔɔyɛnko mɔ betidi Israelfɔɔ, lɔɔbɔ utsyi nɛ.’ ” ");
INSERT INTO lip_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Nyaso Oka Herodes ákpadi bafɔ ba dítsyi kofekatokɔ bamǝ bǝbǝ mfó nya ókpe disi ku mǝ kabiɔ ǝsuǝ, nya ɔ́tɔ mǝ ɔ́nɔ lefe nǝ tutuutu sefandebi siamǝ lɛbɔ bǝnyǝ. ");
INSERT INTO lip_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Mfó fɛ útǝ mǝ kusu nya bédu bésu Betlehem. Nya ɔ́tɛyi mǝ nkǝ, “Bisu lǝ bisu bɛbɛbɛ dikpefi nǝmǝ kukɔnɔ. Nya lǝ binyǝ wǝǝ, lǝ bisinkli bibǝ bɛtɛyi mɛ, bǝ lǝ mintsya lǝ nsu nsumu wǝ.” ");
INSERT INTO lip_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Nyamfo eto kamaa, bafɔ bamǝ áyifɛ kusu bédu. Nya se bántɔɔ, besi bǝnyǝ sefandebi siamǝ fe nsia bǝnyǝ lǝ kofekatokɔ mfó ke. Nya se bǝnyǝ see, bǝnyǝ disuǝyuǝ tinti. Sefandebi siamǝ áyɛnko mǝ sisu síńyǝ lǝ kaka ubi ǝmǝ nlabe. ");
INSERT INTO lip_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Nya se bédufǝ diyo nǝmǝ kafo nya bǝnyǝ ubi ǝmǝ ku wǝ ambe Mariaa, báse akonki nya básumu wǝ. Nya basini mǝ kabɔtɔ nya bǝtǝ wǝ ǝtǝsa nnya lefo koya, nnya ni sika ku lufui ku uyudu. ");
INSERT INTO lip_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Lǝ nnya kamaa, Onanto ǝlǝkǝ óte mǝ lǝ kola kǝmiǝ nkǝ bénsisinkli bayɛ Oka Herodes ɔflɔ. Nyaso báyɛ kusu bamba bésinkli bésu mǝ kasɔ. ");
INSERT INTO lip_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Se babesibe bamǝ dísinkli bédu eto kamaa, Onanto eto ɔtɔnkpe utsyuǝ ǝlǝkǝ ǝsuǝ óte Yosef lǝ kola kǝmiǝ. Nya ɔ́tɛyi wǝ nkǝ, “Oka Herodes ebutǝ nkǝ bati dikpefi nǝmǝ kama lǝ balo wǝ. Nyaso taka, lǝ etsyetsyiko dikpefi nǝmǝ ku ni ambe esuko Egipte eto kasɔ. Bisiǝ mfó isu ese lefe nǝ mɔɔtɛyi fǝ minkǝ bisinkli bibǝ.” ");
INSERT INTO lip_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ketsye kamfoo, Yosef átaka úfi ubi ǝmǝ ku wǝ ambe útsyetsyiko bésu Egipte eto kasɔ. ");
INSERT INTO lip_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Nya bǝsiǝ mfó isu ese lefe nǝ Oka Herodes díkpǝ. Kase bákɛ mfó ǝbǝ itǝ lǝ asa nnya Onanto lɛtɛyi utsyǝ ɛyɛ lǝ wǝ bɛnyɛlǝkǝtidi ǝsuǝ nkǝ, “Egipte kee, mínkpadi mɔ ubi míntsyiko.” ");
INSERT INTO lip_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Lefe nǝ Oka Herodes dínyǝ nkǝ bafɔ ba dítsyi kofekatokɔ mfó áwɛ wǝ bákpee, kafo ányi wǝ tinti. Nyaso útǝ nkǝ wǝ bamamanyǝ su Betlehem ku kaka letsyilama mfó kenke lǝ balo bebisaibi ba díkafo alɛ ǝnuǝ ku ibǝ kasɔ lǝ kase bafɔ bamǝ léte lefe nǝ sefandebi siamǝ dílǝkǝ ǝsuǝ séte. ");
INSERT INTO lip_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Mmǝ ibǝ bǝ Onanto eto Unyɛlǝkǝtidi Yeremiya eto lesa nǝ ɔ́tɛyi útsyǝǝ, ǝbǝ itǝ nko sitinti, nnya nlɛ bɔtɛyi nkǝ, ");
INSERT INTO lip_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Bánɔ bofa butsyuǝ lǝ Rama ini kekuwiwi ku kaminsǝ eto kɔsɔ kekleke. Rahel lɛ keku buwi itǝ wǝ bebi. Nya ɔnnlɛ bɔtɔnɔ nkǝ bammansǝ wǝ lɛkɔ, itsyise bebi bamǝ ǝkpǝ eso.” ");
INSERT INTO lip_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Se Oka Herodes díkpǝ eto kamaa, Onanto eto ɔtɔnkpe utsyuǝ ǝlǝkǝ ǝsuǝ óte Yosef lǝ kola kǝmiǝ lǝ Egipte. ");
INSERT INTO lip_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Nya ɔ́tɛyi wǝ nkǝ, “Taka, lǝ efi ubi ǝmǝ ku wǝ ambe lǝ bisinkli bisu Israel eto kasɔ, itsyise mba léla bǝ baalo ubi ǝmǝ ébukpǝ.” ");
INSERT INTO lip_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Lǝ nyaso Yosef átaka nya ókpa dikpefi nǝmǝ ku ni ambe nya bédu bésu Israel eto kasɔ. ");
INSERT INTO lip_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Fɛɛ lefe nǝ Yosef lɛnɔ nkǝ Arkelao, wǝ ni Oka Herodes eto ubi, béfi bǝtsyǝ seka lǝ Yudea lǝ wǝ anto eto kɛnyɛɛ, óte sikpi ku mfó busu. Nya se Onanto eto ɔtɔnkpe utsyuǝ díkǝ wǝ ato lǝ kola kǝmiǝ nkǝ wensu mfoó, ófloma kusu údu úsu Galilea eto lɛkpɔ mfo. ");
INSERT INTO lip_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nya se úsu mfoó, úsu úsiǝ lǝ umǝ wǝ baakpo Nasaret. Nya mǝ eto mfó busiǝ ǝtǝ bǝ Onanto eto Bǝnyɛlǝkǝtidi eto ditiki nǝ bátɛyi bǝtsyǝ bǝ, “Bookpo wǝ bǝ Nasaretnyǝ,” ǝbǝ ítǝ sitinti. ");
INSERT INTO lip_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Lǝ lefe nǝmfó ǝsuǝǝ, Ntuflǝsǝtidi Yohanes ésu mfiminti lǝ Yudea eto kasɔ, nya útsyiko letsya bobe katɛyi ");
INSERT INTO lip_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","nkǝ, “Bítsyi mi akɔɛsi bɛwuninsǝ lǝ abuayifoyifo ǝsuǝ, itsyise Onanto eto Sekadidi eboyo selo.” ");
INSERT INTO lip_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yohanes ǝmfo ni utidi wǝ Onanto eto Unyɛlǝkǝtidi Yesaya lɛtɛyi útsyǝ nkǝ, “Utidi utsyuǝ lɛ bofa bembembe lǝ mfiminti katɛyi nkǝ, ‘Bɛlɔ Bonamute eto kusu bitsyǝ. Bɛtsyɔnsǝ wǝ kusu bitsyǝ itǝ wǝ bɔyɛ!’ ” ");
INSERT INTO lip_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Nya awu nnya Yohanes lékpee, ɔtɔmini ku lekoko eto bise béfi bédi nnya. Nya úfi kubukikue eto abɔsu ókle nkɛ. Nya wǝ didisa dídi bekpǝsǝ ku bablɔ. ");
INSERT INTO lip_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Nya betidi dítsyi Yerusalem eto umǝ ku Yudea eto kasɔ ku Yordan eto Ketu eto lekpake mfó kenke bǝbǝ wǝ ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Bǝlǝkǝ mǝ asa bua kasɔ nya úflǝsǝ mǝ ntu lǝ Yordan eto ketu kafo. ");
INSERT INTO lip_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Se Yohanes dínyǝ Farisifɔ ku Sadukifɔ kpǝ ba díbǝ wǝ ɔflɔ bǝ lǝ uflǝsǝ mǝ ntuu, ɔ́tɛyi mǝ nkǝ, “Mi mba nte fe bawa eto befluflu! Owoe lɛlɛ mi kɔlɛ nkǝ bitsyetsyi lǝ Onanto eto kotonǝnǝ ko nlɛ bubǝ eto kɛnyɛ? ");
INSERT INTO lip_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Beté lǝ mi eyifosa ǝsuǝ biǝnkǝ bɛtsyi bɛwuninsǝ lǝ mi abua ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Nya biembu biǝ se ini Abraham eto befluflu bini esoo, Onanto embunǝ mi koto. Bɛlɔ bɛnɔ biǝ Onanto ebofo befluflu bulǝkǝ ketsyiko aba nyamfo ǝsuǝ kǝtǝ Abraham. ");
INSERT INTO lip_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","“Bebe se banlɛ kefiebi bǝńyǝ bǝ baala eyi nyamǝ taa keyudu ke. Kuyi saa ko laanwɔ ebibi sɛɛ, boola ko befi bakpe lǝ ditefɛnku kǝmiǝ. ");
INSERT INTO lip_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Mɔɔ, ntu mǝǝflǝsǝ mi nnya nlɛ bote bǝ bɛtsyi bɛwuninsǝ lǝ mi abuayifoyifo ǝsuǝ. Fɛɛ nwǝ ntǝkǝ mɛ kama ɔnlɛ bubǝǝ, wǝ ebufi Onanto eto Lɛwɔnɔ ku ute uflǝsǝ mi ntu. Ɔmɔ oso mɛ, nya mǝnńyǝ ntǝ bǝ nyifo wǝ keyifo kulaa tsya. ");
INSERT INTO lip_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Utsyi wǝ kɔfɛ ko wuufi ɔflɛ wǝ kamɔ ulǝkǝ kofo fɛ lǝ ufi ke okpo lǝ unwu. Fɛɛ kofo ko luubuu, wootonsǝ ko lǝ utǝ wǝ laanni kulefe kulefe, kǝmiǝ!” ");
INSERT INTO lip_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Lefe nǝmfoó, Yesu etsyi Galilea eto kasɔ úbǝ Yohanes ɔflɔ lǝ Yordan eto Ketu nkǝ lǝ Yohanes lǝ uflǝsǝ wǝ ntu. ");
INSERT INTO lip_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Fɛɛ se Yohanes mánla nkǝ lǝ uflǝsǝ Yesu ntu esoo, ɔ́tɛyi wǝ nkǝ, “Mɔ bomu ele bǝ mbǝ fǝ ɔflɔ, nya inni fǝ ele bǝ bǝ mɔ ɔflɔ fǝ mflǝsǝ fǝ ntu.” ");
INSERT INTO lip_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Fɛɛ Yesu ǝtǝ wǝ mbuayɛ nkǝ, “Fǝǝ, tɔnɔ lǝ eyifo nnya nko te mɔmɔ. Itsyise nko fɛ yuutǝ buyifo lesa nǝ ni Onanto eto lelabi nɛ.” Nyaso Yohanes átɔnɔ útǝ wǝ. ");
INSERT INTO lip_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Nya se Yohanes díflǝsǝ Yesu ntu ólosǝ koo, ɔ́bɔ lǝ ntu bomǝ ǝsuǝ, nya mfó ǝmǝ kato léna nwaa nya úńyǝ Onanto eto Lɛwɔnɔ nlɛ bɔyifǝ kǝbǝ kasɔ fe lɛblɛkpa seka díbǝ dísiǝ lǝ wǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Nya bánɔ ɔkɔɛ dítsyi kato ɔnlɛ bɔtɛyi nkǝ, “Nwǝmfo ni mɔ Ubi Lala wǝ mankeko, wǝ eto asa leedufǝ mɛ ǝnǝ tinti nɛ.” ");
INSERT INTO lip_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Nyamfo eto kamaa, Onanto eto Lɛwɔnɔ ákpa Yesu dísuko mfiminti bǝ lǝ Obonsam lǝ oto wǝ obe. ");
INSERT INTO lip_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Nya se Yesu lékle kɛnyɛ itǝ eyifosi anaa, kukpɛnsɛ álɛ wǝ. ");
INSERT INTO lip_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Mfó nya olontidi ǝmǝ díbǝ wǝ ɔflɔ nya ɔ́tɛyi wǝ nkǝ, “Lǝ Onanto eto Ubi fenii, tɛyi abambi nyamfo lǝ efiani didisa.” ");
INSERT INTO lip_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Mfó Yesu dítǝ mbuayɛ nkǝ, “Awɔnisa Kɛnkɛ eto Kukue lǝ bɔtɛyi nkǝ, ‘Inni didisa mate lǝǝntǝ utidi nkpǝ. Bomu ditiki saa nǝ laabɔ ketsyi lǝ Onanto eto kɛnyɛ, ni lǝǝtǝ nkpǝ sitinti nɛ.’ ” ");
INSERT INTO lip_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Mfó nya Obonsam ǝmǝ lékpa Yesu úsuko Yerusalem, Umǝ Kɛnkɛ ǝmǝ. Nya úfi wǝ úsu útǝkǝ lǝ Yudafɔ eto Disumuyo eto kaka nso botaka eto disinti. ");
INSERT INTO lip_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Mfó ɔ́tɛyi wǝ nkǝ, “Lǝ Onanto Kosate eto Ubi fenii, sa ǝbǝ ǝńyǝ lǝ kasɔ. Itsyise Awɔnisa Kɛnkɛ eto Kukue lɛ bɔtɛyi nkǝ, ‘Onanto ebotsyese wǝ batɔnkpe nkǝ bakɔbe fǝ lǝ ani bǝ lǝ fǝ kokpa lǝ kɔyɛ butusǝ lǝ abambi ǝsuǝ.’ ” ");
INSERT INTO lip_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu ǝtǝ wǝ mbuayɛ nkǝ, “Fɛɛ Awɔnisa Kɛnkɛ eto Kukue komǝ ke lɛ bɔtɛyi nkǝ, ‘Manto fǝ Onamute Onanto abe.’ ” ");
INSERT INTO lip_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Mfó nya Obansam ǝmǝ lékpa Yesu úsuko kɔtini ko letaka eto disinti nya óte wǝ kawunsiǝ eto sekakedikɔ kenke ku ke diyǝnde. ");
INSERT INTO lip_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Nya ɔ́tɛyi Yesu nkǝ, “Muufi asa nnyamfo kenke ntǝ fǝ, lǝ ebose akonki esumu mɛ.” ");
INSERT INTO lip_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Mfó nya Yesu dítǝ wǝ mbuayɛ nkǝ, “Satana, du mɛ lǝ ɔflɔ! Awɔnisa Kɛnkɛ eto Kukue lɛ bɔtɛyi nkǝ, ‘Fǝ Onamute Onanto hã ele bǝ se akonki ǝtǝ, esumu.’ ” ");
INSERT INTO lip_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Mfó nya Obonsam dídu lǝ Yesu ɔflɔ, nya Onanto eto batɔnkpe díbǝ bawunsǝ ko wǝ. ");
INSERT INTO lip_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Se Yesu lɛnɔ nkǝ bǝmuǝ Yohanes béti bákpe lǝ diyoo, údu úsu Galilea. ");
INSERT INTO lip_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Wǝnsiǝ lǝ Nasaret, bomu údu úsu úsiǝ lǝ Kapernaum, ni umǝ wǝ nkpe lǝ Galilea eto Ditumbu kplɛ ɔflɔ lǝ Sebulon ku Naftali eto lekpake mfó. ");
INSERT INTO lip_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Úsiǝ mfo nya Onanto eto Unyɛlǝkǝtidi Yesaya eto kɛnyɛ ka ɔ́tɛyi útsyǝ díbǝ kǝtǝ nkǝ, ");
INSERT INTO lip_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","16","“Sebulon eto kasɔ ku Naftali eto kasɔ eto betidi ba nkpǝ lǝ ketuntu ǝsuǝ, lǝ lekpo eto kusu ɔflɔ lǝ Yordan eto Ketu eto ditukpenkpe nǝ nse lǝ Galilea eto kasɔ kaka betidi ba lenni Yudafɔ luunyǝ diyǝnde kplɛ! Nya mba nkpe lǝ ukpǝ eto bulǝ kǝmiǝ, Onanto eto diyǝnde ebuyǝnde lekpo mǝ lǝ ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ídu lǝ lefe nǝmfó Yesu étsyiko letsya bobe katɛyi nkǝ, “Bisinkli lǝ mi abua kama itsyise Onanto eto Sekadidi ebɔfi.” ");
INSERT INTO lip_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Nya se Yesu lɛyɛ lǝ Galilea eto ditumbukplɛ ɔflɔ ɔntɔɔ, únyǝ bayimisani inuǝ ba ni mba laata asabu. Mǝ ni Simon wǝ baakpo Petro ku wǝ ɔyimisani Andrea ba díkata asabu lǝ ditumbukplɛ nǝmǝ. ");
INSERT INTO lip_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesu átɛyi mǝ nkǝ, “Bibǝ bitǝkǝko mɛ, idu mɔmɔ ɛntɔɔ, moote mi kase biulǝkǝ betidi bitǝ Onanto.” ");
INSERT INTO lip_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Mfó báyani mǝ asabu bǝtsyǝ nya bǝtǝkǝko wǝ bédu. ");
INSERT INTO lip_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Nya se ɔ́yɛ sɛkɛ úsu sɛtɔɔ, usi únyǝ bayimisani inuǝ ba baakpo Yakobo ku Yohanes ba ni Sebedeo eto bebi. Mǝ ku mǝ anto Sebedeo ǝmǝ ákɛ lǝ ɔklɔ kafo bákalɔ mǝ asabu fɛ Yesu lékpadi mǝ. ");
INSERT INTO lip_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Lamfolamfoo, báyani mǝ anto ku ɔklɔ ǝmǝ bǝtsyǝ nya bǝtǝkǝko wǝ bédu. ");
INSERT INTO lip_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu áyɛ lǝ Galilea eto kasɔ kenke nya óte asa lǝ Yudafɔ eto ntsyakɔ. Nya óbe Onanto eto Sekadidi eto Ditiki Sɛɛ nǝmǝ letsya. Nya ótsya betidi ba efimbi ate ate nlɛ bulǝ kenke. ");
INSERT INTO lip_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Nyamfo ǝtǝ bǝ wǝ diye ku ditiki nǝmǝ áyɛ éfia Siria eto kasɔ kenke. Nyaso betidi ákpa mǝ befimfi ba efimbi ate ate nlɛ bulǝ báboko wǝ ɔflɔ. Mǝ bǝtsyuǝǝ, awɔnɔ bua dísiǝ mǝ lǝ ǝsuǝ kakpe mǝ bulǝ. Bǝtsyuǝ kǝkpǝkasankli eto bufi díkǝlǝ nya bǝtsyuǝǝ, ani ku akpa díkpǝ mǝ. Yesu átsya mǝmblɛ kenke. ");
INSERT INTO lip_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Sitiditu kplɛ sia ditsyi Galilea eto kasɔ ku Kǝmǝ Lefosi ka nkpe mfó ku Yerusalem ku Yudea eto kasɔ ku nsɔ bo nkpe lǝ Yordan eto Ketu eto lekpake nǝ nse ǝbǝ bǝtǝkǝ ko wǝ. ");
INSERT INTO lip_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Se Yesu dínyǝ sitiditu sia dítǝkǝko wǝǝ, óbe úsu kɔtini kato nya úsiǝ kasɔ. Mfó nya wǝ bakasebi díbǝ wǝ ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Nya útsyiko mǝ asa bote nkǝ, ");
INSERT INTO lip_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Onanto ákpo atsyɔ betidi ba nyi bǝ beyifo bakombo lǝ lɛwɔnɔ ǝsuǝ, itsyise Onanto eto sekakedikɔ eyifo mǝ sele. ");
INSERT INTO lip_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Onanto ákpo atsyɔ betidi ba leewi kaminsǝku. Mǝ Onanto loomansǝ lɛkɔ nɛ. ");
INSERT INTO lip_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Onanto ákpo atsyɔ betidi ba laabokosǝ ǝsuǝ kasɔ. Mǝǝ ni mba luudi sɛkplɛ lǝ kasɔ kamfo eto bikǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Onanto ákpo atsyɔ betidi ba laakplatsya keklekle bǝ bǝǝsiǝ nkpǝ sɛɛ lǝ Onanto eto ǝnǝmi. Mǝ ni mba luunyǝ asa nnya luuyuǝsǝ mǝ kafo nɛ. ");
INSERT INTO lip_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Onanto ákpo atsyɔ betidi ba lǝǝnyǝ mǝ bǝtsyuǝ kaminsǝ. Onanto ebunyǝ mǝ kaminsǝ. ");
INSERT INTO lip_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Onanto ákpo atsyɔ betidi ba eto ketu lekpa kɛnkɛ. Mǝ luunyǝ Onanto nɛ. ");
INSERT INTO lip_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Onanto ákpo atsyɔ betidi ba laalɔ bǝtsyuǝ nti kaboko diyuǝ. Onanto ebokpo mǝ wǝ bebi tinti. ");
INSERT INTO lip_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Onanto ákpo atsyɔ betidi ba eto kama baati kate ohiã se bensi nkpǝ sɛɛ ekeyifo lǝ Onanto lelabi ǝsuǝ eso. Onanto eto sekakedikɔ eyifo mǝ sele. ");
INSERT INTO lip_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Onanto ákpo mi atsyɔ lǝ betidi aaka mi, kate mi ohiã nya baatɛyi bidia saa lǝ mi ǝsuǝ se bitǝkǝko mɛ eso. ");
INSERT INTO lip_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Binyǝ disuǝyuǝ lǝ beto keyudu, itsyise mi kayofofo fui lǝ Onanto eto kato. Nko ke ete báte Onanto eto bǝnyɛlǝkǝtidi ba lɛtɔ mi sɛtɔ ohiã nɛ. ");
INSERT INTO lip_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Bite fe mmba bitǝ betidi ba kenke. Fɛɛ lǝ kamini ábɔ lǝ mmba bomǝ ǝsuǝǝ, ǝnsiǝmbofo kamini bokpe lǝ mu bio. Nya se bunsibǝ kutǝkǝ saa esoo, buwui hã ele bǝ befi mu bewui lǝ betidi lǝ bayɛ lǝ mu ǝsuǝ bafe. ");
INSERT INTO lip_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Biyifo fe diyǝnde bitǝ kawunsiǝ kenke. Umǝ wǝ bála bǝtǝkǝ lǝ kɔtini ǝsuǝǝ, ambiɔ. ");
INSERT INTO lip_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kuutsyuǝ saa anto okandiɛ kefi asa keti wǝ. Bomu bufi beefi wǝ kǝtǝkǝ lǝ wǝ kǝtǝkǝkɔ ǝsuǝ kaka wuutǝ diyǝnde utsyuǝ saa wǝ nkpe lǝ diyo nǝmǝ. ");
INSERT INTO lip_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Nko ke ele bǝ mi okandiɛ yǝnde utǝ lǝ betidi lǝ bǝnyǝ nɛ. Bǝ lǝ bǝnyǝ asa sɛɛ nnya bieyifo lǝ befi atɛsǝ bǝtǝ mi Anto wǝ nkpe kato.” ");
INSERT INTO lip_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Yesu esi ɔ́tɛyi nkǝ, “Biembu biǝ mbǝ miǝ maninsǝ Moses eto afi nnya ókpe, nye Onanto eto bǝnyɛlǝkǝtidi léte. Mǝmbǝ miǝ maaninsǝ nnya kon. Bomu mbǝ miǝ lǝ mbǝ mflɔsǝ nnya. ");
INSERT INTO lip_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nya nla miǝ bete sitinti minkǝ, lǝ kase kato ku kasɔ nsi nkpee, kulesa saa embɔbɔ lǝ kɔfi komǝ ǝsuǝ isu ese lefe nǝ lesa saa luubǝ elo. ");
INSERT INTO lip_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Lǝ nyaso lǝ utsyuǝ ataka uńyǝ lǝ kɔfi komǝ eto lesa sɛkɛ ditsyuǝ ǝsuǝǝ, nya ote betidi bamba nkǝ mǝ tsya yifo nkoo, boofi wǝ fe ɔfɛfɛ lǝ Onanto eto sekakedikɔ. Fɛɛ utidi wǝ ke luuyifo lǝ kɔfi komǝ ǝsuǝ nya woote betidi bamba tsya nkǝ beyifo nkoo, boofi wǝ fe ɔkplɛnyǝ tinti lǝ Onanto eto sekakedikɔ. ");
INSERT INTO lip_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nyaso nlɛ mi bɔtɛyi wuee minkǝ, fɛ biofo Onanto eto sekakedikɔ budufǝǝ, ele bǝ bisiǝ nkpǝ sɛɛ lǝ Onanto eto ǝnǝmi bo lɛlɛkɛ bonso kase kɔfi eto bateasa ku Farisifɔ kulaa tsya nsi. ");
INSERT INTO lip_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Kɔɔ bɛnɔ bátɛyi betidi bǝnkǝ, ‘Manlo utidi.’ Nya utidi wǝ leeyifo nkoo, ele bǝ bakponko wǝ lekpo. ");
INSERT INTO lip_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Fɛɛ mɔmɔɔ, mɔ lɛ mi bɔtɛyi minkǝ, utsyuǝ saa ke luunyǝ ɔblɔ lǝ wǝ ɔyimi ǝsuǝǝ, bookponko wǝ lekpo. Nya utidi wǝ tsya lɔɔtɛyi wǝ ɔyimitsyuǝ nkǝ, ‘Eyifo utidi bimbaa,’ bookpa wǝ besuko beninǝ eto ǝnǝmi. Nya utidi wǝ lɔɔtɛyi wǝ ɔyimitsyuǝ nkǝ, ‘Eyifo ubukii,’ Onanto ebunǝ wǝ koto lǝ ditefɛnku manlo kǝmiǝ. ");
INSERT INTO lip_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Nyaso lǝ ibǝ bǝ efi fǝ ǝtǝsa atɔnko lǝ Onanto kedikǝtǝkɔ eto leba ǝsuǝǝ, nya fakloma fǝ lesatsyuǝ kpe lǝ fǝ ku fǝ ɔyimitsyuǝ lenti, ");
INSERT INTO lip_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","yani fǝ kedi kamǝ ǝtsyǝ lǝ Disumuyo mfó lǝ esu lǝ fonko fǝ ɔyimitsyuǝ lǝ bekpo ntu lǝ bǝtsyuǝ nti fɛ lǝ efi fǝ kedi kamǝ esu ǝtǝ Onanto. ");
INSERT INTO lip_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Lǝ utsyuǝ aala nkǝ weefi fǝ usuko kɔfi ɔflɔɔ, bɛbɛ lefe lǝ fonko wǝ lǝ bɛlɔ bǝtsyuǝ nti. Lenni nkoo, lǝ fonko wǝ esu lekpo etii, utidi ǝmfo ebufi fǝ okpe lǝ okponkpo eto ani. Nya wuntsya luufi fǝ okpe mba lɛmuǝ betidi eto ani nya bookpe fǝ lǝ diyo. ");
INSERT INTO lip_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nya nlɛ fǝ bɔtɛyi kasini minkǝ ebɔkɛ lǝ mfó isu ese lefe nǝ foofo kayo ka fensi alosǝ. ");
INSERT INTO lip_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Bɛnɔ bátɛyi bǝnkǝ, ‘Yanle bǝ bǝsǝ ku bǝsiǝ fe bǝtsyuǝ kama.’ ");
INSERT INTO lip_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Fɛɛ mɔ lɛ mi bɔtɛyi minkǝ utsyuǝ saa kee loobe usionko nya wɔɔkɛ wǝ ɔkɔɛɛ, ókpo wǝ lǝ wǝ utu kǝmiǝ koko. ");
INSERT INTO lip_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Nyaso lǝ fǝ kodiani eto dinǝmi ǝǝtǝ nkǝ dufǝ lǝ lebua ǝsuǝǝ, lǝkǝ ni ato akpe. Ɛlɛkɛ itǝ fǝ bǝ nyansǝ fǝ ǝsuǝ eto lekpa ditsyuǝ enso bǝ befi fǝ utidi ǝmǝ kenke bato bakpe lǝ utemanlo kǝmiǝ. ");
INSERT INTO lip_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Nya lǝ fǝ kodiani ǝǝtǝ fǝǝyifo lebuaa, la ko ato akpe. Ɛlɛkǝ itǝ fǝ eso bǝ nyansǝ fǝ ǝsuǝ eto lekpa lɔni enso bǝ fǝ utidi ǝmǝ kenke dufǝ lǝ utemanlo kǝmiǝ. ");
INSERT INTO lip_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Bátɛyi bǝnkǝ, ‘Utsyuǝ saa ke lɔɔni wǝ usiǝǝ, ele bǝ utǝ wǝ kukue nkǝ ɔ́ni wǝ.’ ");
INSERT INTO lip_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Fɛɛ nlɛ mi bɔtɛyi minkǝ, lǝ osani utsyuǝ áni wǝ usiǝ, nya yanyɛ lǝ disenkpo ǝsuǝ esoo, osani ǝmǝ dítǝ usio ǝmǝ lekpo kusǝ. Nya dimanyɛ lǝ osani wǝ ke luufi usio ǝmǝ tsya ákpo kusiǝ. ");
INSERT INTO lip_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Kɔɔ bɛnɔ tsya bátɛyi betidi bǝnkǝ, ‘Mankpadi asa esi etudi kɛnyɛ lǝ nnya ǝsuǝ. Bomu yifo lǝ ntamu bo faka fǝtǝ Bonamute ǝsuǝ.’ ");
INSERT INTO lip_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Fɛɛ mɔmɔɔ, nlɛ mi bɔtɛyi minkǝ mankpadi asa ǝtsyǝ kɛnyɛ saa. Mankpadi asa nnya nkpe kato itsyise Onanto eto lekankpomɛ ni mfó. ");
INSERT INTO lip_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Mankpadi asa nnya nkpe lǝ kasɔ tsya itsyise Onanto eto akpa eto kǝtǝkɔ ini. Nya mankpadi Yerusalem, itsyise mfó ni baka eto Oka wǝ ni Ǝsuǝalenyǝ Kenke eto umǝ nɛ. ");
INSERT INTO lip_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Mankpadi fǝ disi tsya itsyise ǝmbǝ ǝsuǝale foofo fǝ disi eto sɛwɔni eto lɛ ɔni buyifo uflubi lee ona. ");
INSERT INTO lip_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Tǝ lǝ mi ee lǝ iyifo ee, nya lǝ mi oowo lǝ iyifo oowo ete. Lesa bamba sa enso nyamfo eto bɔtɛyii, etsyi lǝ olontidi ǝmǝ ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Bɛnɔ bátɛyi bǝnkǝ, ‘Bafo dinǝmi lǝ dinǝmi eto kɛnyɛ, nya lɛnyi lǝ lɛnyi eto kɛnyɛ.’ ");
INSERT INTO lip_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Fɛɛ mɔmɔɔ, mɔ lɛ mi bɔtɛyi minkǝ, mantisǝ fǝ ɔyimitsyuǝ eto kabua ka úyifo eto oko. Lǝ utsyuǝ ásɔ fǝ lǝ kodianitosii, tsyi nkonse tsya ǝtǝ wǝ. ");
INSERT INTO lip_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Nya lǝ utsyuǝ aala nkǝ woasama fǝ lǝ ofo fǝ awu katoo, wuninsǝ fǝ kafia tsya ǝtǝ wǝ. ");
INSERT INTO lip_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Nko ke lǝ ǝsuǝalenyǝ eto utsyuǝ anyikǝ fǝ okpe nkǝ tsyi wǝ bikǝ lǝ bɛyɛ disunkpo lɔnii, yɛnko wǝ nnya ǝnuǝ. ");
INSERT INTO lip_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Lǝ utsyuǝ atɔ fǝ lesatsyuǝ, fi ni ǝtǝ wǝ. Nya lǝ utsyuǝ tsya atɔ nkǝ dia lesa ǝtǝ wǝ, dia ni ǝtǝ wǝ. ");
INSERT INTO lip_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Bɛnɔ bátɛyi bǝnkǝ, ‘La fǝ bayɛtsyuǝ lǝ ekisi fǝ olo!’ ");
INSERT INTO lip_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Fɛɛ mɔmɔɔ, nlɛ mi bɔtɛyi minkǝ bela mi balo lǝ beto ola lǝ mba leekisi mi eto disi. ");
INSERT INTO lip_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Bǝ lǝ befiani Onanto wǝ nkpe kato eto bebi tinti. Itsyise wǝ lǝǝtǝ kofe laafa kǝtǝ betidi bua ku mba leeyifo kasɛɛ kenke tsyɛtsyɛɛtsyɛ. Nya ɔsɔmi tsya laani kǝtǝ betidi ba leeyifo kasɛɛ ku mba leenyifo kasɛɛ ta. ");
INSERT INTO lip_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Lǝ betidi ba laala mi ete mi tsya laalaa, nte kayofofo ka Onanto luutǝ mi. Nko ke te mba laafo umǝnko kula tsya leeyifo nɛ. ");
INSERT INTO lip_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Nya lǝ mi bayɛtsyuǝ mate ete biǝsiǝsǝǝ, nyalɛ bienyifo tɔ kulesa nǝ eto ani ele bǝ basɔ mi. Mamfokanɔfɔ tsya eyifo nko ke. ");
INSERT INTO lip_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Bomuu, bɛflɔ fe kase mi Anto wǝ nkpe kato lɛflɔ seka. ");
INSERT INTO lip_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Bebe kukɔnɔ biǝ bienyifo kesumu eto kasɛɛ ka ele bǝ biyifo bilǝkǝ bete lǝ betidi lǝ bǝnyǝ. Itsyise lǝ biyifo nkoo, biensiembunyǝ kayofofo saa itsyi lǝ mi Anto wǝ nkpe kato ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Nyaso lǝ ǝtǝ okombo utsyuǝ lesatsyuǝǝ, mambe nya letsya lǝ betidi lǝ banɔ fe kase ǝnǝmi ǝnǝmi eto betidi leeyifo lǝ ntsyakɔ ku lǝ umǝ eto kabia. Beeyifo nko bǝ lǝ betidi lǝ batɛsǝ mǝ. Nlɛ mi bɔtɛyi sitinti minkǝ boonyǝ mǝ kayofofo koko. ");
INSERT INTO lip_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Nyaso fǝǝ, lǝ awunsǝko okomboo, yifo nko bǝ fǝ ɔyɛtsyuǝ kulaa tsya embote lesa nǝ feyifo. ");
INSERT INTO lip_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Itǝ bǝ iyifo abiɔnsa nya kuutsyuǝ saa lembunyǝ enso fǝ Anto Onanto wǝ lǝǝnyǝ asanyata, bǝ lǝ ofo fǝ nya kayo. ");
INSERT INTO lip_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Lǝ bɛlɛ ola botoo, bienyifo fe kase ǝnǝmi ǝnǝmi eto betidi leeyifo. Baala buńyǝ lǝ Yudafɔ eto kalakatokɔ ku lǝ obia bǝ lǝ utsyuǝ saa lǝ unyǝ mǝ. Nlɛ mi bɔtɛyi sitinti miǝ, boofo mǝ kayofofo saa koko. ");
INSERT INTO lip_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Fɛɛ lǝ alɛ ola botoo, dufǝ lǝ fǝ diyo kǝmiǝ lǝ eti siku lǝ ato ola ǝtǝ fǝ Anto wǝ kuutsyuǝ saa lǝǝnnyǝ. Nya fǝ Anto wǝ lǝǝnyǝ fǝ eyifosa kulakula saa, ebofo fǝ nya kayo. ");
INSERT INTO lip_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Lǝ bɛlɛ ola botoo, biendi etiki kpenkpenkpe katɛyi, kalɔ bɔtɛyi fe kase bamamonyǝ leeyifo. Beebu bǝ lǝ batɛyi etiki kpenkpenkpee, nya mǝ bǝfiǝ loofo mǝ olatoto nɛ. ");
INSERT INTO lip_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Bienyifo fe mǝ, itsyise Mi Anto Onanto yi asa nnya behiã fɛ biatɔ wǝ. ");
INSERT INTO lip_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Nyaso nnyǝ mmǝ ele bǝ beto ola, ‘Boanto wǝ nkpe kato, tǝ lǝ bakpasǝ fǝ diye. ");
INSERT INTO lip_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Fǝ sekakedidi lǝ sibǝ. Beyifo lǝ fǝ lelabi ǝsuǝ lǝ kasɔ mfo fe kase inte kato. ");
INSERT INTO lip_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Tǝ bo bo mmi eto didisa. ");
INSERT INTO lip_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Fi bo abua atsyɛ bo fe kase bo tsya leefi katsyɛ mba laata bo kebu. ");
INSERT INTO lip_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Mǝntǝ lǝ budufǝ lǝ botokabe ǝsuǝ, lǝǝlǝkǝ bo etsyiko lǝ abua ǝsuǝ. Itsyi sekadidi ku ǝsuǝale ku diyǝnde eyifo fǝ ale lefe saa. Ibǝ itǝ.’ ");
INSERT INTO lip_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Nya lǝ bifi mi bǝtsyuǝ eto botakebu bɛtsyɛ mǝǝ, mi Anto Onanto tsya ebufi mi ale tsya ɔtsyɛ mi. ");
INSERT INTO lip_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Fɛɛ lǝ biemfi mi bǝtsyuǝ eto botakebu bɛtsyɛ mǝǝ, mi Anto Onanto tsya embufi mi botakebu ɔtsyɛ mi. ");
INSERT INTO lip_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Nya lǝ békle kɛnyɛɛ, mǝnyǝnkisǝ ǝnǝmi eyifo fe kase ǝnǝmi ǝnǝmi eto betidi leeyifo seka. Beenyǝnkisǝ ǝnǝmi sekasitsyuǝ bǝ lǝ utsyuǝ saa luunyǝ mǝ nkǝ balɛ kɛnyɛ bokle. Nlɛ mi bɔtɛyi wuee minkǝ boofo mǝ kayofofo saa bálosǝ. ");
INSERT INTO lip_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Lǝ bɛlɛ kɛnyɛ bokle nɛ, biflǝ ǝnǝmi lǝ besadi disi. ");
INSERT INTO lip_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Nyamfo luutǝ bǝ betidi embote bǝnkǝ bɛlɛ kɛnyɛ bokle. Bomu bǝ lǝ mi Anto wǝ boǝnnyǝ hã lǝ ote. Bǝ lǝ mi Anto wǝ lǝǝnyǝ lesa saa, lǝ ofo mi nya kayo. ");
INSERT INTO lip_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Bianlɔ ǝsuǝ eto bikǝ bitsyǝ lǝ kasɔ kamfo, kaka balɛ ku kosansa laabiasǝ bikǝ nya beyu tsya laaba biku kedufǝ ayo keyu mi. ");
INSERT INTO lip_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Bomu bɛlɔ mi bikǝ bitsyǝ lǝ Onanto eto. Mfoo, balɛ embobiasǝ mi nye beto kosonsa nya beyu tsya lemboba siku beyu mi. ");
INSERT INTO lip_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Itsyise kaka fǝ bikǝ bia lefo koya ntee, mfo fuufi fǝ ǝnǝmi ǝtǝkǝ nɛ. ");
INSERT INTO lip_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Ǝnǝmi eyifo fe okandiɛ itǝ utidi. Lǝ fǝ ǝnǝmi alɛkɛɛ, fǝ ǝsuǝ kenke ebokpa fe okandiɛ. ");
INSERT INTO lip_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Fɛɛ lǝ fǝ ǝnǝmi annlɔ kǝnyǝǝ, fǝ utidi eto umu ǝmǝ kenke ebɔkɛ lǝ ketuntu ǝsuǝ. Nyaso lǝ diyǝnde nǝ nkpe lǝ fǝ afiani ketuntuu, fǝ ketuntu kamǝ ebɔkɛ ale tinti. ");
INSERT INTO lip_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Kuutsyuǝ saa embofo banamute inuǝ busumu. Woola ɔni, ukisi unuǝfǝ. Uutsyue ɔni koto nya wɔɔni unuǝfǝ. Ǝmbofo Onanto ku atabi bɔkɔ kesumu. ");
INSERT INTO lip_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Nyamfo eso minlɛ mi bɔtɛyi minkǝ bianso mi nsusu bufi kǝtǝkǝ lǝ lesa nǝ biudi nye biunǝ nye asa nnya biɔlɛ lǝ mi ǝsuǝ. Itsyise nkpǝ afo koya eso didisa. Nya ǝsuǝ eto uyi tsya lefo koya eso asa nnya biɔlɛ. ");
INSERT INTO lip_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Bebe baklɔbɛ, baamfo kakuɛ nya bǝmlǝkǝ edisa nye eyibibi kǝtsyǝ ǝsuǝ lǝ kewũ, fɛɛ mi Anto Onanto aabe mǝ! Nya ntsyǝ fǝ woombobe mi enso mǝ, lefe nǝ eto lefe befo koya benso mǝ. ");
INSERT INTO lip_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nya mi utsyuǝ ebofo nkpǝ busiǝ diyi lɔni kasonsǝ kaso kase elee, lǝ ufi nya okpe lǝ wǝ nsusu ǝsuǝ kekleke nko? ");
INSERT INTO lip_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Bibu bebe kase dituwinimi lǝ dimǝ laanɔ bobee. Kaanta olokotutu nya keendi kafia kefi keti ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Fɛɛ nlɛ mi bɔtɛyi minkǝ Oka Salomo kulaa tsya lǝ wǝ kɔlɔkɔ eto diyǝnde ǝsuǝǝ, mánnɔ bobe fe dituwinimi nǝ lǝǝmǝ mfó. ");
INSERT INTO lip_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Lǝ nko Onanto lǝǝtǝ sefa kɔlɔkɔ komfo eto oklee, sefa sia lǝǝńyǝ mmi ete nya kǝsiǝsǝ ete baala se kato kakpé lǝ ditefɛnku kǝmiǝǝ, ntsyǝ Onanto lembutǝ bo alɛsa kpǝ enso sefa eto ale? Ntsyǝ wǝmbutǝ mi kɔlɔkɔ enso? Bimbǝ bofokanɔ kpǝ! ");
INSERT INTO lip_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Lǝ nyaso biensisiǝ bikebu disi katɔ biǝnkǝ, ‘Sieti buunyǝ lesaatsyuǝ budi nye lesaatsyuǝ bunǝ nye lesaatsyuǝ bɔlɛ lǝ ǝsuǝ?’ ");
INSERT INTO lip_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Asa nyamfo eyifo asa nnya bamamonyǝ lǝǝsiǝ kebu disi ketsyiko. Mi Anto wǝ nkpe kato yi nkǝ asa nyamfo kenke ebohiã mi. ");
INSERT INTO lip_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Bomu bitǝ lǝ mi abɛbɛsa tutɛ lǝ idi kase Onanto luudi seka lǝ mi ǝsuǝ le befiani basɛɛ. Nya wuufi asa bamba nya kenke loofe itǝ mi tsya, utǝ mi. ");
INSERT INTO lip_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Nyaso biǝnsiǝ bikebu disi itsyi lǝ kusɛ ko nlɛ bubǝ ǝsuǝ. Diyi nǝmfó tsya ebubǝ ku ni bulǝ. Yanle bǝ bufi bulǝ bamba bokpe lǝ mi eto bole ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Mankponko betidi bamba lekpo bǝ lǝ Onanto tsya lǝ ɔyɛ fǝ lekpo bokponko. ");
INSERT INTO lip_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Kase faaklá asa yeeyi kaba kakpo kǝtǝ utidii, nko ke eto okle Onanto looklá utǝ fintsya nɛ! ");
INSERT INTO lip_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Ntsyǝ fɛ fanlɛ dikubi kɛkɛ nǝ ntǝkǝ fǝ ɔyimitsyuǝ eto dinǝmi bobe fɛ fannlɛ dikubi kplɛ nǝ ntǝkǝ lǝ fǝ léle bunyǝ? ");
INSERT INTO lip_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ntsyǝ fɛ foofo fǝ ɔyimitsyuǝ bɔtɛyi fǝnkǝ, ‘Lekpakpa, tǝ lǝ nlǝkǝ dikubi kɛkɛ nǝ ntǝkǝ fǝ lǝ dinǝmi,’ se dikubi kplɛ ntǝkǝ lǝ fǝ kosate eto lele ǝsuǝ? ");
INSERT INTO lip_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Fǝ ǝnǝmi ǝnǝmi eto utidi! Ka dikubi kplɛ nǝ ntǝkǝ fǝ lǝ dinǝmi bulǝkǝ fɛ lǝ ǝnyǝ kusu ǝlǝkǝ fǝ ɔyimitsyuǝ eto lele kɛkɛ nǝ ntǝkǝ wǝ lǝ dinǝmi. ");
INSERT INTO lip_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Biemfi asa nnya diyifo kɛnkɛ beto bitǝ bakpa. Lǝ bifi bitǝ mǝǝ, mǝ bomu ebɔtsyi bawuninsǝ bǝnǝ mi. Biemfi mi atsyabi nya lefo koya beto bekpe bakplako. Lǝ bifi bitǝ mǝǝ, bɔɔnwɔ nya ku mǝ akpa bakpe lǝ kota. ");
INSERT INTO lip_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Bɛtɔ asa lǝ befi bǝtǝ mi. Bɛbɛbɛ asa lǝ binyǝ. Bɛsɔ siku lǝ basini mi. ");
INSERT INTO lip_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Itsyise utsyuǝ saa wǝ laatɔ asaa, bǝǝtǝ wǝ. Nya utsyuǝ saa wǝ laabɛbɛɛ, wǝǝnyǝ. Nya utsyuǝ saa, wǝ lɛsɔ sikuu, bɔɔsini wǝ. ");
INSERT INTO lip_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Minti eto Owoe lǝ wǝ ubi atɔ wǝ abolo, wuufi lebambi utǝ wǝ? ");
INSERT INTO lip_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Nye lǝ ɔtɔ wǝ lɛkpɛ, wuufi owa utǝ wǝ? ");
INSERT INTO lip_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Mimba ni babuayifo kulaa yi kase buifi asa sɛɛ bitǝ mi bebi. Nya ntsyǝ yuutsyǝ ku Boanto wǝ nkpe kato itǝ bo? Ntsyǝ yoofo bubǝ bǝ weembufi wǝ asa, asa sɛɛ, utǝ betidi ba laatɔ wǝ? ");
INSERT INTO lip_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Asa nnya biala biǝ betidi bamba yifo bǝtǝ mii, mitsya yifo nnya bitǝ mǝ nko. Nyamfo ete Moses eto kɔfi ku Onanto eto bǝnyɛlǝkǝtidi nlɛ bote nɛ. ");
INSERT INTO lip_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Bɛyɛ lǝ kesie kɛkɛ befe bidufǝ kǝmiǝ. Itsyise lǝ bɛyɛ lǝ kesie ka lɛmɔ ku kusu ko disensǝ ko diyuǝ ku bɔyɛɛ, yookpa mi isuko katsylɔkɔ ka ni ute kǝmiǝ. Nya ko ǝsuǝ betidi kpǝ nyɛ nɛ. ");
INSERT INTO lip_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Fɛɛ nkpǝ eto kusu afɛ, nya ko bɔyɛ kesu mfó kpe ale, nya betidi esiani hã lǝǝnyǝ ko. ");
INSERT INTO lip_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Bebe mi ǝsuǝ sinini lǝ bidiabidia eto bǝnyɛlǝkǝtidi ǝsuǝ. Bǝǝbǝ mi ɔflɔ fe basamu seka lǝ dinyǝbi ǝsuǝ. Fɛɛ lǝ mǝ kǝmiǝǝ, baso bekiti. ");
INSERT INTO lip_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Biunyǝ mǝ bitsyǝ lekpo lǝ mǝ eyifosa ǝsuǝ. Kanyi aannwɔ eyibibi nnya bedi. Nya otonkpa anwɔ nnya bendi. ");
INSERT INTO lip_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Nko ini bǝ kuyi sɛɛ saa aanwɔ ebibi sɛɛ. Nya kuyi bua saa aanwɔ ebibi bua. ");
INSERT INTO lip_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Kuyi sɛɛ saa aannwɔ ebibi bua nko ke kuyi bua saa laannwɔ ebibi sɛɛ nɛ. ");
INSERT INTO lip_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kuyi saa ko laannwɔ ebibi sɛɛ, baala ko kefi kakpe lǝ ute. ");
INSERT INTO lip_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Nyaso badiantidi ba lǝǝlǝkǝ Onanto eto Ditiki Sɛɛ nǝmǝ kɛnyɛɛ, biunyǝ mǝ bitsyǝ lekpo lǝ mǝ eyifosa ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Inni utsyuǝ saa ke laakpadi mɛ nkǝ, ‘Bonamute, Bonamutee,’ luudufǝ Onanto eto sekakedikɔ. Bomu betidi ba leeyifo mɔ Anto wǝ nkpe kato eto alasa luudufǝ mfó. ");
INSERT INTO lip_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Lǝ diyi fɛfɛ ayoo, betidi kpǝ bɔtɛyi mɛ bǝ, ‘Bonamute, Bonamute! Lǝ fǝ diye ǝsuǝ nya búdi fǝ Ditiki Sɛɛ nǝmǝ nya búyifo ayanisa kpǝ bóla awɔnɔ bua kpǝ búlǝkǝ lǝ betidi ǝsuǝ.’ ");
INSERT INTO lip_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Mfó nya mɔɔtɛyi mǝ minkǝ, ‘Minyi mi kulaa o-o! Bidu mɛ lǝ ɔflɔ, mi babuayifotidi.’ ");
INSERT INTO lip_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Nyaso utidi wǝ ke laanɔ mɔ etiki nya weeyifo lǝ nnya ǝsuǝǝ, wǝ ni obesibe nɛ. Ute fe utidi wǝ léto wǝ diyo uńyǝnsǝ lǝ koba ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ɔsɔmi áni nya ntu díyi boba bokpo, nya ufiebi kekleke lɛsɔ ɔyɛ lǝ diyo nǝmǝ ǝsuǝ ófe. Fɛɛ díamba itsyise óto ni utǝkǝ lǝ koba ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Fɛɛ utsyuǝ saa wǝ laanɔ mɔ etiki fɛ woanyɛ lǝ nnya ǝsuǝǝ, okateko ubuki. Ute fe utidibuki wǝ léto wǝ diyo uńyǝnsǝ lǝ kɔwinimi ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ɔsɔmi áni nya ntu díyi bóba bókpo mfó, nya ufiebi kekleke lɛsɔ ɔ́yɛ lǝ diyo nǝmǝ ǝsuǝ ófe, nya léba kploo lékpo lǝ kasɔ.” ");
INSERT INTO lip_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Se Yesu léte asa nyamfo kenke ólosǝǝ, wǝ asatete eyifo mǝmblɛ yanii. ");
INSERT INTO lip_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Wǝ asatete ményifo fe kase afi eto bateasa laate. Bomu óte asa fe nwǝ nkpe ǝsuǝale lǝ asa nnya óte ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Lefe nǝ Yesu lɛyifǝ kɔtini komǝ úbǝ kasɔɔ, betidi kpǝ ǝtǝkǝko wǝ. ");
INSERT INTO lip_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Mfó nya osani utsyuǝ wǝ nlɛ bufi sía bufi díbǝ óse akonki lǝ wǝ ǝnǝmi ɔ́tɛyi nkǝ, “Bonamute! Lǝ alaa, ebofo butǝ bǝ mɔ ǝsuǝ le.” ");
INSERT INTO lip_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesu ǝnǝ wǝ kɔni útidi wǝ, nya ɔ́tɛyi wǝ nkǝ, “Nla. Fǝ ǝsuǝ le.” Lamfolamfo bufi bomǝ ǝyuǝ utidi ǝmǝ. ");
INSERT INTO lip_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Mfó ǝmǝ nya Yesu lɛtɛyi wǝ nkǝ, “Be kukɔnɔ, nya mensu atɛyi kuutsyuǝ saa kulesa. Bomu fi fǝ ǝsuǝ esu ate Onanto eto usumunyǝ wǝ luudi fǝ adansiɛ nkǝ fǝ bufi ǝyuǝ fǝ sitinti. Nya lǝ efi kedi ka Moses eto kɔfi lɛtɔ ǝtǝ. Bǝ lǝ utsyuǝ saa lǝ ote nkǝ bufi bomǝ ǝyuǝ fǝ sitinti.” ");
INSERT INTO lip_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Se Yesu dídufǝ Kapernaun eto umǝǝ, Romafɔ eto Omamanyǝ Ninǝ utsyuǝ ǝbǝ ɔ́lɛ wǝ lekpakpa nkǝ, ");
INSERT INTO lip_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Bonamute! Mɔ uyifoyifo lɛ bufi kekleke. Olabe lǝ diyo ɔnnlɛ bofo botaka.” ");
INSERT INTO lip_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu átɛyi wǝ nkǝ, “Muusu lɛ nsu ntsya wǝ.” ");
INSERT INTO lip_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Omamanyǝ ninǝ ǝmǝ ǝtǝ wǝ mbuayɛ nkǝ, “Bonamute, oolo! Yǝńyǝ itǝ bǝ mɔ diyo. Tɛyi ditiki lɔni ete mɔ uyifoyifo ǝmǝ eto bufi ebuyuǝ wǝ. ");
INSERT INTO lip_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Mintsya eyifo nwǝ nkpe lǝ beninǝ eto kalɔ, nya bamamanyǝ bǝtsyuǝ tsya nkpe mɛ kalɔ. Lǝ ntɛyi utsyuǝ miǝ, ‘Suu’ weesu. Nya lǝ ntɛyi obamba tsya miǝ, ‘Bǝǝ,’ wǝǝbǝ. Nya lǝ ntɛyi mɔ uyifoyifo miǝ, ‘Yifo nǝmfoo,’ weeyifo ni.” ");
INSERT INTO lip_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Se Yesu lɛnɔ etiki nyamfoo, íyifo wǝ yanii nya ɔ́tɛyi betidi ba dítǝkǝko wǝ mfó nkǝ, “Nlɛ mi bɔtɛyi sitinti minkǝ lǝ Israelbebi nti kulaa tsyaa, mǝnnyǝ tɔ bofokanɔ kplɛ bomfo eto okle! ");
INSERT INTO lip_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nlɛ mi bɔtɛyi sitinti minkǝ betidi kpǝ ebutsyi kofekatokɔ ku ko diyokedufǝkɔ bǝbǝ bǝsiǝ kasɔ bedi lesa ku Abraham, Isak ku Yakob lǝ Onanto eto sekakedikɔ. ");
INSERT INTO lip_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Fɛɛ mimba ni sekakedikɔ siamǝ eto bebii, boofi mǝ batobakpe lǝ ketuntu ka nkpe lǝ se kama mfo. Mfó boowi nku bayimi anyi.” ");
INSERT INTO lip_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Nya kamaa, nya Yesu lɛtɛyi bamamanyǝ eto uninǝ ǝmǝ nkǝ, “Du esu diyo, yuubǝ itǝ fǝ fe kase fáfo fánɔ ǝsuǝ.” Nya omamanyǝ ninǝ ǝmǝ eto uyifoyifo eto ǝsuǝ dímuǝ wǝ ale lǝ lefe nǝmfó ǝsuǝ ke. ");
INSERT INTO lip_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Se Yesu dísu Petro eto diyoo, únyǝ nkǝ atikesi ǝmuǝ Petro eto usiǝambe kekleke, nya onlabe. ");
INSERT INTO lip_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Mfó ǝmǝ nya Yesu lɛkɔbe wǝ lǝ kɔni nya atikesi nyamǝ léyani wǝ nya ótaka úsu úyifo wǝ afɔ. ");
INSERT INTO lip_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Se ditsyitsyo lefe léyoo, bákpa betidi kpǝ ba awɔnɔ bua díkǝlǝ báboko Yesu ɔflɔ. Yesu lǝ ditikididi lɔni ǝsuǝǝ, óla awɔnɔ bua nyamǝ úlǝkǝ lǝ mǝ ǝsuǝ. Nya ótsya befimfi bamǝ kenke mǝ efimbi. ");
INSERT INTO lip_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Úyifo nyamfo bǝ lǝ ditiki nǝ Onanto eto Unyɛlǝkǝtidi Yesaya lɛtɛyi utsyǝ lǝ ibǝ itǝ nkǝ, “Wǝ kosate átsya bo kǝsuǝfi, nya ótsya bo efimbi kenke.” ");
INSERT INTO lip_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Lefe nǝ Yesu dínyǝ betidi kpǝ ba ńyǝ wǝ lǝ ɔflɔɔ, ɔ́tɛyi wǝ batɔnkpe bamǝ nkǝ, bǝtǝ lǝ bayila ditumbukplɛ nǝmǝ besu ni lekpake nǝnse. ");
INSERT INTO lip_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Afi eto oteasa utsyuǝ ǝbǝ wǝ ɔflɔ mfó. Nya ɔ́tɛyi Yesu nkǝ, “Oteasa, muutǝkǝko fǝ nsu kaka ke fantɔ.” ");
INSERT INTO lip_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Mfó nya Yesu lɛtɛyi wǝ nkǝ, “Nkpaflɔbɛ kpe ǝbiǝ nnya eto kafo baalabe, nya baklɔbɛ nkpe ayo. Fɛɛ Utidi Eto Ubii, ǝmbǝ kaka wuuluǝ wǝ disi.” ");
INSERT INTO lip_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Nya utidi bamba utsyuǝ wǝ ni okasebi lɛtɛyi nkǝ, “Bonamute, tǝ mɛ kusu lǝ nsu mbikǝ mɔ anto fɛ.” ");
INSERT INTO lip_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yesu ǝtǝ wǝ mbuayɛ nkǝ, “Tǝkǝko mɛ. Tǝ mba nsi nkpǝ fe bekpǝnkpǝ lǝ besu bebikǝ mǝ bekpǝnkpǝtsyuǝ.” ");
INSERT INTO lip_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesu ku wǝ bakasebi édufǝ lǝ ɔklɔ utsyuǝ kafo. ");
INSERT INTO lip_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Yanklɛ ufiebi étsyiko bɔsɔ kekleke lǝ ditumbukplɛ nǝmǝ ǝsuǝ. Nya ɔnlɛ ntu bɔsɔ kakpo lǝ ɔklɔ ǝmǝ kafo, nya íyifo fe woonya udufɔ lǝ ntu kasɔ. Fɛɛ Yesu wǝǝ lábe selabe. ");
INSERT INTO lip_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Bakasebi bamǝ ésu básanklisǝ wǝ nya bátɛyi wǝ bǝnkǝ, “Bonamute, lǝkǝ bo! Boǝbǝ bukpǝ lo.” ");
INSERT INTO lip_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Mfó nya Yesu lɛtɔ mǝ nkǝ, “Beso bɛnlɛ sikpi bote nko? Mi mba eto bofokanɔ lemfui!” Mfó nya ótaka úúnyǝ nya ókpe ufiebi ku ntu bomǝ kɛnyɛ nkǝ bǝyuǝ kɛnyɛ. Nya lesa saa díyuǝ kɛnyɛ kananana. ");
INSERT INTO lip_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Iyifo utsyuǝ saa mfó yanii. Nya bátɔ ǝsuǝ bǝ, “Nte utidi wǝ eto okle ni nwǝ mfo? Ufiebi ku ntu kulaa tsya eetsyue wǝ koto!” ");
INSERT INTO lip_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Se Yesu lɛyila ditumbukplɛ úsu ni lekpake nǝnse údufǝ Gadara eto kasɔɔ, betidi inuǝ ba ǝsuǝ awɔnɔ bua nsi ábɔ betsyi lǝ edi nti bǝbǝ bátsyako wǝ. Nya se bakɛ sikpi tinti esoo, kuutsyuǝ saa mánkatɔnɔ nkǝ woayɛ kusu komfo ofe. ");
INSERT INTO lip_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Lamfolamfo, báfa ku ɔkɔɛ bembembe nya bátɔ wǝ bǝnkǝ, “Fǝ Onanto eto Ubi, be nkpe lǝ bonko fǝ lenti mfo? Bubǝ fǝbǝ fǝ etsyiko bo koto bunǝ katɔnsǝ fɛ lǝ lefe nǝmǝ lǝ leyoo?” ");
INSERT INTO lip_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Bakplako eto lekpa kplɛ ditsyuǝ ǝńyǝ lǝ mfó ɔflɔ békedi lesa. ");
INSERT INTO lip_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Nyaso awɔnɔ bua nyamǝ álɛ Yesu lekpakpa bǝnkǝ, “Lǝ ebola bo ǝlǝkǝ lǝ mfoo, nyalɛ la bo esu akpe lǝ bakplako eto lekpa kplɛ nǝ ńyǝ mǝ ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Mfó Yesu dínyǝnki ókpe mǝ ɔ́tɛyi nkǝ, “Bidu bisu.” Nyaso bédu mfó bésu bédufǝ lǝ bakplako bamǝ ǝsuǝ. Nya bakplako bamǝ kenke dítsyetsyi báwunini lǝ kɔtini komǝ eto kotosi bésu bédufǝ lǝ ditumbukplɛ nǝmǝ ǝsuǝ nya bǝnǝ ntu bǝkpǝ. ");
INSERT INTO lip_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Lǝ nyaso mba laase bakplako bamǝ étsyetsyi besu umǝ. Bátɛyi lesa saa nǝ díbǝ lǝ bakplako bamǝ ku betidi ba awɔnɔ bua disiǝ lǝ ǝsuǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Nyaso utsyuǝ saa lǝ umǝ ǝmǝ ésu nkǝ wǝǝnyǝ Yesu. Nya se bǝnyǝ wǝǝ, bálɛ wǝ lekpakpa bǝ udu lǝ mǝ kasɔ. ");
INSERT INTO lip_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu édufǝ lǝ ɔklɔ nya usinkli ɔ́yɛ lǝ ditumbukplɛ ǝsuǝ úsu wǝ umǝ. ");
INSERT INTO lip_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Mfó nya bákpa osani utsyuǝ wǝ léba onkpo kasɔ lǝ belabekǝ ǝsuǝ báboko wǝ ɔflɔ. Se Yesu dínyǝ nkǝ báfo bánɔ tinti esoo, ɔ́tɛyi nwǝ léba onkpo kasɔ ǝmǝ nkǝ, “Ubi, kpe utu. Mfi fǝ abua ntsyɛ fǝ.” ");
INSERT INTO lip_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Mfó afi eto bateasa bǝtsyuǝ ba díńyǝ mfó lɛtɛyi bǝnkǝ, “Utidi ǝmfo lǝ mbusiotiki budi.” ");
INSERT INTO lip_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesu ǝnyǝ mǝ nsusu bomfo utsyǝ lekpo nya ɔ́tɔ mǝ nkǝ, “Beso bɛnlɛ nsusu bua bomfo eto okle bufi? ");
INSERT INTO lip_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Nya nte etiki nnya eto bɔtɛyi diyuǝ enso, ‘Mfi fǝ abua ntsyɛ fǝ,’ lee batɛyi bǝ ‘Taka, lǝ ayɛ edu’? ");
INSERT INTO lip_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Bǝ lǝ nlǝkǝ nte mi miǝ Utidi Eto Ubi kpe ǝsuǝale bǝ lǝ ufi abua ɔtsyɛ lǝ kawunsiǝ mfoo,” ɔ́tɛyi utidi ǝmǝ léba onkpo kasɔ mfó nkǝ, “Taka ǝńyǝ, lǝ efi fǝ belabekǝ lǝ edu esu diyo.” ");
INSERT INTO lip_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Mfó nya osani ǝmǝ létaka nnya úfi wǝ belabekǝ nnya údu úsu diyo. ");
INSERT INTO lip_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Lefe nǝ betidi bamfó dínyǝ nyamfoo, sikpi ǝmuǝ mǝ nnya bátɛsǝ Onanto bǝ úfi ǝsuǝale nyamfo eto okle útǝ betidi. ");
INSERT INTO lip_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu édu mfó nya se ɔnyɛ ɔntɔɔ, únyǝ nwǝ laafo umǝnko utsyuǝ wǝ baakpo Mateo wǝ nsi lǝ wǝ keyifokɔ. Nya ɔ́tɛyi wǝ nkǝ, “Tǝkǝko mɛ.” Mfó ǝmǝ nya Mateo létaka útǝkǝko wǝ. ");
INSERT INTO lip_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Lefe nǝ Yesu nsi ɔnlɛ lesa budi lǝ Mateo eto diyoo, mba laafo umǝnko kpǝ ku babuayifo bǝtsyuǝ ǝbǝ bákɔ ku Yesu ku wǝ bakasebi ǝsuǝ lǝ lesakedikɔ mfó. ");
INSERT INTO lip_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Mfó nya Farisifɔ ba dínyǝ nyamfoo, lɛtɔ wǝ bakasebi bǝnkǝ, “Beso mi oteasa ku mba laafo umǝnko ku babuayifo leedi lesa kakɔ?” ");
INSERT INTO lip_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu ánɔ lesa nǝ bátɛyi nyaso útǝ mbuayɛ nkǝ, “Betidi ba nkpe ǝsuǝale manhiã ofanyǝ enso mba ni befimfi hã. ");
INSERT INTO lip_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Bisu lǝ bisu bɛbɛbɛ nnya báwɔni bákpe lǝ Awɔnisa Kɛnkɛ eto Kukue eto kasɔ bǝnkǝ, ‘Kaminsǝnyǝnyǝ maabɛbɛ, nya inni bebukilolo kǝtǝ kedi.’ Mǝmbǝ miǝ mǝǝbǝ nlǝkǝ betidi sɛɛ, bomu babuayifo eso mimbǝ.” ");
INSERT INTO lip_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Mfó nya Ntuflǝsǝtidi Yohanes eto bakasebi díbǝ bátɔ Yesu bǝnkǝ, “Beso bonko Farisifɔ laakle kɛnyɛ lǝ lefe lefe ǝsuǝ, fɛɛ fǝ bakasebi laankle kɛnyɛ?” ");
INSERT INTO lip_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesu ǝtǝ mǝ mbuayɛ nkǝ, “Bibubibu biǝ okafɔsǝ eto baklobo ba nkpe lǝ wǝ ɔflɔ yifo mǝ ǝsuǝ yooyooyoo ku kaminsǝ lǝ lefe nǝ eto lefe onkpe lǝ mǝ ɔflɔ? Yanle bǝ ibǝ nko kulefe! Fɛɛ diyi ditsyuǝ ebubǝ nǝ ǝsuǝ bookpa okafɔsǝ ǝmǝ bedunko lǝ mǝ ɔflɔ. Lǝ lefe nǝmfó ǝsuǝǝ, bookle kɛnyɛ bǝsiǝ. ");
INSERT INTO lip_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Kuutsyuǝ saa emfi kafia eto lefianku fɔfɔ katale kǝtǝkǝ lǝ kakoko ǝsuǝ. Itsyise lefianku fɔfɔ nǝmǝ ebunǝ ni ǝsuǝ dilǝkǝ lǝ lekoko nǝmǝ ǝsuǝ itǝ bǝ dibiǝ koko nǝmǝ ebola disensǝ lekpe. ");
INSERT INTO lip_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","“Nko ke kuutsyuǝ saa leemfi nte fɔfɔ kakpo lǝ kubukikuetobe koko kafo itsyise nte bomǝ ebɔkpɔ itǝ otobǝ ǝmǝ eboba nya nte bomǝ luuwi nya otobe ǝmǝ loobia. Bomu beefi nte fɔfɔ kakpo lǝ kubukikuetobe fɔfɔ kafo. Nya asakpa ǝnuǝ nyamǝ ebutsyǝ kukɔnɔ.” ");
INSERT INTO lip_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Lefe nǝ Yesu nlɛ mǝ etiki budinkoo, Yudafɔ eto katsyakɔ eto uninǝ utsyuǝ ǝbǝ wǝ ɔflɔ nya óse akonki, ɔ́lɛ wǝ lekpakpa ɔ́tɛyi nkǝ, “Mɔ ubisiobi ǝkpǝ mɔmɔmɔmɔ, tsya bǝ lǝ ǝbǝ efi fǝ ani ǝtǝkǝ wǝ lǝ ǝsuǝ lǝ otaka.” ");
INSERT INTO lip_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Nyaso Yesu átaka útǝkǝko wǝ ku wǝ bakasebi. ");
INSERT INTO lip_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Se ɔntɔɔ, usionko utsyuǝ wǝ kɔtɔ díkakpo lǝ lefosi alɛ ǝnuǝ sɔ̃ɔ̃ ǝsuǝ tsya ǝtǝkǝko Yesu kama nya útidi wǝ awu eto kotosi. ");
INSERT INTO lip_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Úyifo nko nya ɔ́tɛyi wǝ ǝsuǝ lǝ bofokanɔ ǝsuǝ nkǝ, “Lǝ ntidi wǝ awu koo, mɔ bufi ebɔyɛ mɛ.” ");
INSERT INTO lip_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesu átsyi ɔ́wuninsǝ únyǝ wǝ nya ɔ́tɛyi wǝ nkǝ, “Muǝ utu alɛ, mɔ ubi. Fǝ bofokanɔ átsya fǝ.” Lǝ lefe nǝmfo ǝsuǝ tututuu, bufí bomǝ ǝyuǝ wǝ. ");
INSERT INTO lip_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Nnya kamaa, Yesu ésu katsyakɔ eto uninǝ ǝmǝ eto diyo nya se únyǝ mba leefe nkpatsyaku ku mba nlɛ bofa kewi nkuu, ");
INSERT INTO lip_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ɔ́tɛyi mǝ nkǝ, “Utsyuǝ saa bɔ usu lekple, disiobi nǝmǝ mǝnkpǝ, bomu selabe ete onlabe.” Mfo bétsyiko wǝ bumǝ. ");
INSERT INTO lip_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Nya se bála betidi bamǝ babɔsɛɛ, Yesu édufǝ diyo nǝ ubisiobi ǝmǝ nlabe, nya ɔ́kɔbe wǝ lǝ kɔni, nya ótaka úsiǝ. ");
INSERT INTO lip_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ditiki nǝmfo ésensǝ léba lékpo lǝ kasɔ kamǝ eto lekpake nǝmfó kenke. ");
INSERT INTO lip_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Se Yesu dídu mfó ɔnyɛ ɔntɔɔ, bǝnǝmba inuǝ bǝtsyuǝ átaka bǝtǝkǝko wǝ ku kudu bembembe bátɛyi bǝnkǝ, “Oka, David eto ubi! Nyǝ bo kaminsǝ!” ");
INSERT INTO lip_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Nya se Yesu dísu údufǝ diyoo, bǝnǝmba inuǝ bamǝ edufǝ mfó. Nya Yesu lɛtɔ mǝ nkǝ, “Befo bɛnɔ biǝ moofo mi botsya?” Mfó bǝmǝnkli kɛnyɛ bátɛyi bǝnkǝ, “Ɛɛ! Bofo bɔnɔ.” ");
INSERT INTO lip_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Mfó nya Yesu dítidi mǝ ǝnǝmi nya ɔ́tɛyi mǝ nkǝ, “Tǝ lǝ ibǝ itǝ fe kase befo bɛnɔ.” ");
INSERT INTO lip_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Nya ete mǝ ǝnǝmi lɛsini. Nya Yesu díkǝ mǝ ato kekleke nkǝ, “Biantɛyi kuutsyuǝ saa nyamfo.” ");
INSERT INTO lip_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Fɛɛ se bédu mfóo, bábe ditiki nǝmfo letsya utidi sa anɔ lǝ lɛkpɔ nǝmfó kenke itsyi lǝ Yesu ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Se betidi bamfo dídu bantɔɔ, betidi bǝtsyuǝ ákpa osani utsyuǝ wǝ lɛwɔnɔ bua dítǝ ɔnnlɛ etiki bofo budi báboko Yesu ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Óla lɛwɔnɔ bua nǝmǝ úlǝkǝ lǝ wǝ ǝsuǝ. Mfó nya utidi ǝmǝ dítsyiko etiki budi. Nyamfo éyifo betidi ba ńyǝ mfó yanii, bátɛyi bǝnkǝ, “Boǝnnyǝ tɔ nyamfo eto okle bunyǝ kulefe lǝ Israel eto kasɔ!” ");
INSERT INTO lip_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Fɛɛ Farisifɔ bǝtsyuǝ átɛyi bǝnkǝ, “Awɔnɔ bua eto oka wǝ lǝǝtǝ wǝ ǝsuǝale, nya úfi ɔnlɛ awɔnɔ bua nyamfó bola kǝlǝkǝ nɛ.” ");
INSERT INTO lip_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu áyɛ ótsyilama kǝmǝ ku mbuto bo nkpe lǝ lekpake nǝ lɛfi mfó. Óte asa lǝ Yedafɔ eto ntsyakɔ. Óbe Ditiki Sɛɛ nǝmǝ letsya óte asa itsyi lǝ Onanto eto sekakedikɔ ǝsuǝ. Nya ótsya betidi efimbi efimbi kenke. ");
INSERT INTO lip_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Nya se únyǝ sitiditu siamǝǝ, mǝ asa ǝnǝ wǝ kafo itsyise ǝsuǝ ába mǝ, nya bánkɛ ɔwɔnsǝkotsyuǝ saa, nya beyifo fe basamu ba lǝmbǝ obebe. ");
INSERT INTO lip_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Nyaso ɔ́tɛyi wǝ bakasebi nkǝ, “Bɛkuɛnke bia díkayo bulǝkǝ fui, fɛɛ beyifoyifo bamǝ emfui. ");
INSERT INTO lip_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Nyaso bɛlɛ ɔkuɛnsate ǝmǝ lekpakpa lǝ otsyese beyifoyifo lǝ bǝbǝ bawunsǝ lǝ bǝlǝkǝ bɛkuɛnkǝ biamǝ.” ");
INSERT INTO lip_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu ákpadi wǝ batɔnkpe lefosi inuǝ bamǝ ɔ́kɔ nya útǝ mǝ ǝsuǝale nkǝ bala awɔnɔ bua bǝlǝkǝlǝ betidi ǝsuǝ nya lǝ batsya mǝ efimbi, efimbi saa tsya. ");
INSERT INTO lip_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Batɔnkpe lefosi inuǝ bamǝ eto aye ni Simon wǝ bensi baakpo Petro ku wǝ ɔyimi Andrea ku Yakobo ku wǝ ɔyimi wǝ baakpo Yohanes baa ni Sebedeo eto bebi ");
INSERT INTO lip_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ku Filipo ku Bartolomeo ku Toma ku Mateo wǝ laafo umǝnko ku Yakobo wǝ ni Alfeo eto ubi ku Tadeo ");
INSERT INTO lip_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ku Simon wǝ ditsyi Kana ku Yuda Iskariot wǝ dídu Yesu útǝ. ");
INSERT INTO lip_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesu ǝtsyǝ lefosi betidi inuǝ bamfo kusu nya ótsyese mǝ nya úkǝ mǝ ato nkǝ, “Biensu betidi ba lenni Yudafɔ eto kasɔ nye bidufǝ Samariafɔ eto umǝ saa tsya kafo. ");
INSERT INTO lip_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Bomu bisu Israel bebi ba diyifo fe basamu ba lénya kusu ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Bisu bebe letsya biǝnkǝ, ‘Onanto eto Sekakedidi eboyo selo.’ ");
INSERT INTO lip_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Betsya befimfi lǝ betakasǝ mba díkpǝ. Betsya mba nlɛ bufisia bufi, lǝ bela awɔnɔ bua bitsyiko lǝ betidi ǝsuǝ. Bíanya ǝsuǝale nyamfo bitsyiko mɔ ɔflɔ nyaso mi tsya biemfi nnya bete befo atabi. ");
INSERT INTO lip_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Bientsyi atabi saa lǝ mi katobe. ");
INSERT INTO lip_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Mi kuutsyuǝ mentsyi otobe fe mba laatɔ asa, awu nuǝfǝ, afɔkpa nye ɔlɛ uyi ɔyɛ kusu. Uyifoyifo ǝńyǝ utǝ lesa nǝ wuudi. ");
INSERT INTO lip_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Lǝ bidufǝ umǝ nye kebuto kǝtsyuǝǝ, bɛbɛbɛ utidi sɛɛ wǝ loola nkǝ woafo mi. Bɛsɔnɔ lǝ wǝ ɔflɔ lǝ bɛkɛ mfo isu ese lefe nǝ biudu. ");
INSERT INTO lip_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Lǝ bidufǝ diyo ditsyuǝ, bisiǝsǝ mǝ biǝnkǝ, ‘Diyuǝ itǝ mi.’ ");
INSERT INTO lip_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Lǝ báfo mi ku kafo faa, bitǝ lǝ mi diyuǝ eto kǝsiǝ kamfó lǝ kǝsiǝ ku diyo nǝmfó kenke eto utsyuǝ saa. Nya lǝ bamfo mii, diyuǝ eto kǝsiǝ kamfó bǝ mi ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Nya lǝ diyo nye umǝ ǝmǝ eto betidi mámfo mi nye báni bámfo mi ditikii, nyalɛ bidu mfó lǝ bɛflɛ mi nkpafo eto site bekpo lǝ umǝ ǝmǝ. ");
INSERT INTO lip_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nlɛ mi bɔtɛyi sitinti minkǝ lǝ diyi fɛfɛ nǝ Onanto lookponko kawunsiǝ eto betidi lekpo ǝsuǝǝ, wuunyǝ Sodom ku Gomora eto betidi kaminsǝ kulaa tsya oso umǝ ǝmfo eto bale. ");
INSERT INTO lip_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Bɛlɔ bɛnɔ! Nlɛ mi botsyese fe basamu lǝ bekiti eto nti. Bitǝkǝ ǝnǝ fe bawa seka, nya bɛlɛ mi ǝsuǝ kukɔnɔ fe ablonima. ");
INSERT INTO lip_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Bebe mi ǝsuǝ kukɔnɔ, itsyise betidi ebumuǝ mi, bakpa mi besuko akpokakpokɔ. Bɔɔblɛ mi lǝ Yudafɔ eto ntsyakɔ. ");
INSERT INTO lip_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Lǝ mɔ disi esoo, bookponko mi akpo lǝ Aba eto beninǝ ku baka eto ǝnǝmi. Lǝ mfóo, bɛtɛyi mǝ ku mba lenni Yudafɔ Ditiki Sɛɛ nǝmǝ. ");
INSERT INTO lip_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Lǝ bákpa mi bésuko lekpokakpokɔɔ, biembu disi lǝ lesa nǝ biɔtɛyi, nye kase biɔtɛyi nnya. Lǝ lefe nǝmfo ayoo, boote mi lesa nǝ biɔtɛyi. ");
INSERT INTO lip_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Itsyise inni mi loote etiki nnya buidi, bomu mi Anto Onanto eto Lɛwɔnɔ luudi etiki ɔyɛ lǝ mi ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Betidi ebudu mǝ bayimi bǝtǝ bǝ balo. Nya antomǝ tsya luuyifo nko ke ku mǝ bebi. Bebi ebotaka bǝńyǝ lǝ mǝ antomǝ ǝsuǝ bedu mǝ bǝtǝ bǝ balo. ");
INSERT INTO lip_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Utsyuǝ saa ebukisi mi lǝ mɔ disi eso. Fɛɛ utsyuǝ saa wǝ luuńyǝ kekleke lǝ wǝ bofokanɔ ǝsuǝ isu ese kalosǝkɔɔ, boofo wǝ lǝ nkpǝ. ");
INSERT INTO lip_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Lǝ bati mi kama lǝ umǝ ɔnii, bitsyetsyi bisu umǝ bamba. Nya nlɛ mi bɔtɛyi sitinti minkǝ, biembuyifo mi keyifo belosǝ lǝ Israel eto kǝmǝ ka kenke fɛ mɔ, Utidi Eto Ubi luubǝ. ");
INSERT INTO lip_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Okasebi saa aanso wǝ oteasa. Odomunyǝ saa tsya aanso wǝ onamute. ");
INSERT INTO lip_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Nyasoo, ele bǝ imi, okasebi saa nkǝ wuubǝ utsyǝ fǝ wǝ oteasa seka. Nya ndomunyǝ tsya luubǝ utsyǝ fe wǝ onamute. Nya lǝ bákpadi oyosate utsyuǝ bǝ Awɔnɔ bua eto ɔtɔnkotɔnko nyaalɛ nte aye bua nya eto okle bembokpo diyo nǝmǝ eto bebi? ");
INSERT INTO lip_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Nyaso biante betidi sikpi, itsyise lesa saa nǝ ǝsuǝ béti asa bakulaa, bɔɔsini asa lǝ nnya ǝsuǝ, nya asakulakula saa ebɔbɔɔ lekple banɔ. ");
INSERT INTO lip_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Lesa nǝ minlɛ mi bɔtɛyi lǝ ketuntu lefee, bɛtɛyi nnya lǝ kalekpakpa ǝsuǝ. Nya lesa nǝ batɛyi mi lǝ kawɛ ǝsuǝ, bebe nya letsya lǝ utsyuǝ saa lǝ ɔnɔ. ");
INSERT INTO lip_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Biante mba ini etidisuǝ ete boofo bolo fɛ bembofo okla bolo sikpi. Bomu bete Onanto wǝ loofo utidi eto ǝsuǝ eto sinǝ ku lɛwɔnɔ bolo lǝ ute wǝ laatonsǝ asa sikpi. ");
INSERT INTO lip_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Lǝ efi kablɛ kanii, foofo ntsyuɛ nnuǝ boya tsyaa, ke kani kplo embukpǝ lǝ inni Boanto Onanto eto lelabi. ");
INSERT INTO lip_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Nya mimii, Onanto yi mi disi eto sɛwɔni eto leklabi kenke. ");
INSERT INTO lip_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Nyaso biante sikpi, itsyise befo koya beso baklɔbɛ kpǝ. ");
INSERT INTO lip_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Utsyuǝ saa wǝ luulǝkǝ kɛnyɛ lǝ betidi nti ɔtɛyi nkǝ uyifo mɔ olee, mintsya ebofo wǝ fe moole lǝ mɔ Anto Onanto eto ǝnǝmi kato. ");
INSERT INTO lip_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Fɛɛ lǝ utsyuǝ áni mɛ lǝ betidi ba tã eto ǝnǝmii, mintsya ebɔni wǝ lǝ mɔ Anto wǝ kato eto ǝnǝmi. ");
INSERT INTO lip_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Biembu biǝ mbǝ diyuǝ kabokokɔ lǝ kawunsiǝ. Owo lo! Mǝmbǝ diyuǝ kabokokɔ, bomu kabia! ");
INSERT INTO lip_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Mbǝ miǝ mǝǝnǝ kabia nkpe ‘lǝ bebisaibi ku mǝ antomǝ lenti, lǝ bebisiobi ku mǝ ambemǝ lenti, lǝ bebisiǝ ku mǝ bese ambe mǝ lenti. ");
INSERT INTO lip_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Nya utidi eto olo sitintii, ebutsyi wǝ kosate eto diyo kafo.’ ");
INSERT INTO lip_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Nya utsyuǝ saa wǝ laala wǝ anto nye ambe oso mɛɛ, mǝńyǝ itǝ bǝ uyifo mɔ okasebi. Nko ke ini bǝ utsyuǝ saa ke laala wǝ ubisaibi nye ubisiobi kulaa tsya oso mɛɛ, yǝnńyǝ itǝ bǝ uyifo mɔ okasebi. ");
INSERT INTO lip_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Utsyuǝ saa ke dímentsyi wǝ uyikabie ɔyɛ mɔ kayɛkɔ utǝkǝko mɛɛ, mǝnńyǝ utǝ bǝ uyifo mɔ okasebi. ");
INSERT INTO lip_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Utsyuǝ saa ke lela nkǝ waata wǝ nkpǝ eto disii, ebonyansǝ mu. Fɛɛ utsyuǝ saa ke loonyansǝ wǝ nkpǝ lǝ mɔ butǝkǝko esoo, wuunyǝ nkpǝ manlo sitinti. ");
INSERT INTO lip_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Utsyuǝ saa ke loofo mii, mɔ ofo. Nya utsyuǝ saa ke loofo mɛɛ, ofo nwǝ létsyese mɛ tsya. ");
INSERT INTO lip_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Utsyuǝ saa ke loofo Onanto eto unyɛlǝkǝtidi nkǝ uyifo Onanto eto unyɛlǝkǝtidi esoo, ebunyǝ kedikɔ lǝ unyɛlǝkǝtidi eto kayofofo ka woofo lǝ nnya ǝsuǝ. Utsyuǝ saa ke loofo utidi wǝ ni ɔsɛɛ itsyise uyifo ɔsɛɛnyǝ esoo, wǝ ku utidi ǝmǝ ebofo kayofofo itsyi lǝ keyifo ka úyifo eso. ");
INSERT INTO lip_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Bebe nyamfo kukɔnɔ bǝ utsyuǝ saa wǝ luutǝ ntu yududu eto lɛkɔbetɔ mɔ bakasebi bamfo eto utsyuǝ lǝ mǝ nti lǝ mɔ disii, ebunyǝ kayofofo lǝ nnya eso kokooko.” ");
INSERT INTO lip_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Lefe nǝ Yesu dílǝkǝ wǝ bakasebi lefosi inuǝ bamfo útsyǝ mǝ kusu ólosǝǝ, údu mfó úsu óte asa nnya óbe nnya letsya lǝ kǝmǝ kamǝ ku nka letsyilama mfó. ");
INSERT INTO lip_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Lefe nǝmǝǝ, se Ntuflǝsǝtidi Yohanes wǝ nkpe lǝ Aba eto diyo lɛnɔ asa nnya Yesu nlɛ buyifoo, ókpe wǝ bakasebi bǝtsyuǝ Yesu ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Bésu bátɔ Yesu bǝnkǝ, “Tɛyi bo. Fǝ ni utidi wǝ Yohanes lɛtɛyi nkǝ ǝǝbǝ bubǝǝ, lee bobe obamba kusu?” ");
INSERT INTO lip_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Mfó nya Yesu dítǝ mǝ mbuayɛ nkǝ, “Bisinkli bisu bɛtɛyi Yohanes asa nnya bɛnlɛ bɔnɔ ku nnya bɛnlɛ bunyǝ. ");
INSERT INTO lip_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Bǝnǝmba lɛ bunyǝ, nya mba leba bankpo lǝ kasɔ lɛ bɔyɛ. Mba nlɛ bufisia bufi eto ǝsuǝ lɛ bokpa, batoti lɛ bɔnɔ, balɛ bekpǝnkpǝ botakasǝ kǝnyǝnsǝ, nya banlɛ bakombo Ditiki Sɛɛ nǝmǝ bɔtɛyi. ");
INSERT INTO lip_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Diyuǝ itǝ mba dimǝnyǝ kabua saa lǝ mɛ ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Se Yohanes eto bakasebi bamǝ dídu bantɔɔ, Yesu édi betidi bamǝ etiki itsyi lǝ Yohanes ǝsuǝ ɔ́tɛyi nkǝ, “Se bísu Yohanes ɔflɔ lǝ mfimintii, be béfo bɛnɔ biǝ biunyǝ? Lefanto nǝ ufiebi nlɛ bɔsɔ kafe lee? ");
INSERT INTO lip_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Be bísu kabekɔ fɛɛ? Utidi wǝ nkpe bikǝ lǝ ǝsuǝ bia laanɔ bobe lee? Betidi ba laakpe bikǝ biamfo eto oklee, Lekayo baakɛ. ");
INSERT INTO lip_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Bɛtɛyi mɛ lesa nǝ kon bísu kabekɔ! Biǝ biesu bebe Onanto eto unyɛlǝkǝtidi lee? Ee, lǝ sitinti wǝ uni nɛ. Fɛɛ nwǝ bínyǝǝ, so Onanto eto unyɛlǝkǝtidi kulaa tsya. ");
INSERT INTO lip_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Itsyise Yohanes ni nwǝ ǝsuǝ báwɔni bákpe lǝ Awɔnisa Kɛnkɛ eto Kukue bǝnkǝ, Onanto átɛyi nkǝ, ‘Mootsyese mɔ ɔtɔnkpe ntɔnsǝ fǝ bubǝ lǝ ubǝ ɔlɔ fǝ kusu utsyǝ.’ ");
INSERT INTO lip_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nya nlɛ mi bɔtɛyi sitinti minkǝ Ntuflǝsǝtidi Yohanes amɔ oso utsyuǝ saa wǝ usio léle lǝ kawunsiǝ kamfo. Fɛɛ nwǝ nso bɔfɛ lǝ Onanto eto sekakedikɔɔ, amɔ oso Yohanes ǝmǝ. ");
INSERT INTO lip_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Idu lǝ Ntuflǝsǝtidi Yohanes eto lefe ibǝ ese mɔmɔɔ, balɛ bota kekleke ku kǝnǝmisɛ lǝ kato eto sekakedikɔ siamǝ ǝsuǝ. Fɛɛ mba ńyǝ lǝ se ǝsuǝ ku kǝnǝmisɛ tinti lɛ bokplatsya bǝ beeti se bubǝ kusu. ");
INSERT INTO lip_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ibǝ ese lǝ Yohanes eto lefee, Onanto eto bǝnyɛlǝkǝtidi ku Moses eto afi edi etiki itsyi lǝ sekakedikɔ siamǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Nya lǝ bela biǝ biafo mɔ dítiki bɛnɔɔ, Yohanes ni Elia, wǝǝ eto bubǝ bátɛyi bǝtsyǝ. ");
INSERT INTO lip_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nwǝ ato nkpee, utsyue ato lǝ ɔnɔ. ");
INSERT INTO lip_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Nya mɔmɔɔ, be muufi mmi eto betidi nkatesǝ ko? Beyifo fe bekpefi ba laakpe kɔyɛ lǝ asi. Lekpa lɔni afa kakpadi mǝ bǝtsyuǝ katɛyi nkǝ, ");
INSERT INTO lip_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Búse kusiǝkpakpa eto ese butǝ mi, Fɛɛ bɛni kewui buwui. Bóto keku eto ese butǝ mi, Fɛɛ bienwi nku.’ ");
INSERT INTO lip_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Itsyise lefe nǝ Yohanes díbǝǝ, ókle kɛnyɛ nya wǝnnǝ nte. Nya utsyuǝ saa lɛtɛyi nkǝ, ‘Utsyi lɛwɔnɔ bua.’ ");
INSERT INTO lip_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Fɛɛ se Utidi Eto Ubi díbǝǝ, údi únǝ. Nya utsyuǝ saa lɛtɛyi nkǝ, ‘Be utidi ǝmfo! Uyifo udikpuu ku utenǝ, mba laafo umǝnko ku babuayifo eto ɔyɛtsyuǝ!’ Fɛɛ utidi eto eyifosa ǝsuǝǝ, nya woǝlǝkǝ Onanto eto kobe ko nkpe wǝ kate nɛ.” ");
INSERT INTO lip_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Kǝmǝ ka ǝsuǝ Yesu díyifo ayanisa kpǝ eto betidi mántsyi báwuninsǝ bafo banɔ. Nyaso ílǝ wǝ itǝ mǝ. ");
INSERT INTO lip_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ɔ́tɛyi nkǝ, “Mbɔbɔɛ mǝǝtǝ fǝ Korasim! Nya mbɔbɔɛ mǝǝtǝ fǝ Betsaida! Lǝ ayanisa nnya béyifo lǝ mi ete béyifo lǝ Tiro ku Sidon innii, eni mfó eto betidi ebɔtsyi bawuninsǝ kokoko, befi atoku eto mfia beti, bediki ntɔ lǝ ǝsuǝ ete bǝ bani mǝ abua. ");
INSERT INTO lip_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Nlɛ mi bɔtɛyi sitinti minkǝ, lǝ Lekpoyi Fɛfɛɛ, Onanto ebunyǝ Tiro ku Sidon eto kǝmǝ kaminsǝ eso mi. ");
INSERT INTO lip_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Nya fǝ Kapernaum, bubu fanlɛ fǝ Onanto ebobesǝ fǝ kato? Boobokosǝ fǝ kasɔ bato fǝ bakpe lǝ ditefɛnku kǝmiǝ ke! Lǝ ayanisa nnya minyifo lǝ fǝ ete mínyifo lǝ Sodom, eni usi okpe eyo mmi! ");
INSERT INTO lip_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Nlɛ fǝ bɔtɛyi sitinti minkǝ lǝ lekpo yi fɛfɛɛ, Onanto ebunyǝ Sodom kaminsǝ tinti oso fǝ!” ");
INSERT INTO lip_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Lǝ lefe nǝmfoo, Yesu átɛyi nkǝ, “Anto, kato ku kasɔ eto Onamute. Maasɔ fǝ ani, itsyise ǝlǝkǝ asa nnya lɛkula babesibe ku bekuente áté mba lennyi kulesa. ");
INSERT INTO lip_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ee, Anto, sitinti, nko fála fǝ ibǝ itǝ nɛ. ");
INSERT INTO lip_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Mɔ Anto éfi asa nnya kenke útǝ mɛ. Kuutsyuǝ saa enyi Ubi ǝmǝ enso Anto. Nya kuutsyuǝ saa enyi Anto ǝmǝ enso Ubi ǝmǝ ku mba Ubi ǝmǝ laala nkǝ wǝǝlǝkǝ wǝ oté. ");
INSERT INTO lip_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Bibǝ mɔ ɔflɔ mimba ntsyi bike kinkinki bia nlɛ mi bulǝ, lǝ ntǝ lǝ bitsyǝ ɔnwɛ. ");
INSERT INTO lip_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Bibǝ lǝ busie mɔ bitsyike butǝ bǝtsyuǝ lǝ bekase asa bitsyiko mɔ ɔflɔ, itsyise nkpe lefonǝ nya mimbokosǝ ǝsuǝ kasɔ lǝ lɛwɔnɔ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Itsyise bitsyikǝ bia muutsyisǝ mi ǝyuǝ, nya bitsyikǝ bia muutsyisǝ mi tsya eyifo fomfloo.” ");
INSERT INTO lip_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Lǝ lefe kliminti ditsyuǝ kamaa, Yesu ku wǝ bakasebi ésu báyɛ akpa eto ɔkuɛ utsyuǝ kafo báfe lǝ Ɔnwɛditsyǝyi. Se kukpɛnsǝ lɛlɛ wǝ bakasebi bamǝǝ, bétsyiko edisa nyamǝ bufǝsǝ kayimi. ");
INSERT INTO lip_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Se Farisifɔ bamǝ dínyǝ nyamfoo, bátɛyi Yesu bǝnkǝ, “Fǝ bakasebi éyifo lesa nǝ díńyǝ lǝ bo Ɔnwɛditsyǝyi eto afi ǝsuǝ!” ");
INSERT INTO lip_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Mfó Yesu dítǝ mǝ mbuayɛ ɔ́tɔ mǝ nkǝ, “Bíankla lesa nǝ Oka David díyifo lǝ lefe nǝ kukpɛnsɛ lɛlɛ wǝ ku wǝ betidi? ");
INSERT INTO lip_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Údufǝ Onanto eto diyo, nya wǝ ku wǝ betidi dífi lesa nǝ bákpo atsyɔ bǝtǝ Onanto bédi, lǝ lefe nǝ eto lefe kɔfi mǝntǝ kusu nko, ini mba lǝǝtǝ Onanto kedi hã nkpe kusu beedi lebolo nǝmǝ. ");
INSERT INTO lip_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Nye bíankla lǝ Moses eto afi biǝnkǝ lǝ Ɔnwɛditsyǝyi saa, besumunyǝ ba nkpe lǝ Onanto eto Disumuyo ékeyifo asa nnya díńyǝ lǝ diyi nǝmǝ ǝsuǝ, tsya fɛɛ bánlo mǝ dikpi lǝ nnya ǝsuǝ? ");
INSERT INTO lip_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nlɛ mi bɔtɛyi minkǝǝ, lesaatsyuǝ kpe mi lenti mfo nǝ lɛmɔ lenso Disumuyo Kplɛ. ");
INSERT INTO lip_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Awɔnisa Kɛnkɛ eto Kukue nkǝ, ‘Kaminsǝnyǝnyǝ ni lesa nǝ maabɛbɛ, inni bebuki eto keditǝtǝ.’ Lǝ bǝ bɛnɔ nyamfo kasɔ tutuutuu, eni biembokpo akpofukutu belo betidi ekpi. ");
INSERT INTO lip_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Itsyise Utidi Eto Ubi ni Ɔnwɛditsyǝyi eto Onamute.” ");
INSERT INTO lip_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Mfó nya Yesu dídu úsu Yudafɔ eto Katsyakɔ kǝtsyuǝ. ");
INSERT INTO lip_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Mfóo, úsu únyǝ osani utsyuǝ wǝ eto kɔni, kɔni díkpǝ. Betidi bǝtsyuǝ ákɛ mfó ba léla bǝ bábɛbɛ etiki bǝtǝ wǝ bǝ óta kɔfi ubu, nyaso bátɔ wǝ bǝnkǝ, “Kɔfi ǝtǝ kusu bǝ batsya ufimfi lǝ Ɔnwɛditsyǝyi?” ");
INSERT INTO lip_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesu átɔ mǝ nkǝ, “Lǝ ibǝ bǝ mi utsyuǝ eto osamu ákpia údufǝ lǝ dibiǝku ǝsuǝ lǝ Ɔnwɛditsyǝyii, wǝmbunǝ wǝ ulǝkǝ? ");
INSERT INTO lip_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Fɛɛ utidi afo koya oso osamu! Nyalɛ, bo kɔfi mǝntǝ bo kusu nkǝ bɔwunsǝko kuutsyuǝ lǝ Ɔnwɛditsyǝyi.” ");
INSERT INTO lip_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Mfó nya ɔ́tɛyi osani wǝ eto kɔni díkpǝ nkǝ, “Nǝ fǝ kɔni etsyue.” Únǝ ko útsyue, nya kɔni komǝ disi kótsya wǝ fe kase kunuǝfǝ komǝ nte. ");
INSERT INTO lip_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Nya Farisifɔ ba díńyǝ mfó dídu nya béfi nsusu bǝ boolo Yesu. ");
INSERT INTO lip_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Se Yesu lɛnɔ nkǝ bákle kɛnyɛ lǝ wǝ ǝsuǝǝ, údu mfó, nya betidi kpǝ dítǝkǝko wǝ. Ótsya befimfi kenke. ");
INSERT INTO lip_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Nya úti mǝ kusu nkǝ bǝntǝ lǝ betidi lǝ bate bǝ wǝ uni. ");
INSERT INTO lip_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ɔ́tɛyi nyamfo nko bǝ lǝ Onanto eto nnya ɔ́tɛyi útsyǝ ɛyɛ lǝ wǝ Unyɛlǝkǝtidi Yesaya ǝsuǝ lǝ ibǝ itǝ sitinti nkǝ, ");
INSERT INTO lip_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Nwǝ mfo ni mɔ uyifoyifo wǝ mínlǝkǝ mintsyǝ, nwǝ maala, nya mǝǝnyǝ disuǝyuǝ lǝ wǝ tinti. Muutǝ mɔ Lɛwɔnɔ lǝ dibǝ disiǝ lǝ wǝ ǝsuǝ, nya woobe mɔ lekpokponkpo letsya utǝ kawunsiǝ kenke. ");
INSERT INTO lip_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Weembunǝ etiki ku betidi nye ofã kuutsyuǝ, nya bǝmbɔnɔ wǝ etiki ku bofa lǝ obia. ");
INSERT INTO lip_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Wɔɔkɛ dibusǝ utǝ mba lǝmbǝ ǝsuǝale. Nya wuunyǝ mba diyifole saa lǝmbǝ lǝ ǝsuǝ kaminsǝ. Wɔɔlɛnko nko kekleke isu ese lefe nǝ mɔ ɔnukualɛ eto lekpokponkpo luutǝkǝ kato. ");
INSERT INTO lip_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Nya betidi ba kenke luufi mǝ kusubebe bǝtǝkǝ lǝ wǝ.” ");
INSERT INTO lip_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Mfó nya betidi bǝtsyuǝ lékpa osani utsyuǝ wǝ awɔnɔ bua nlɛ bulǝ, wǝ ni unǝmba nya uyifo nwǝ lendi etiki tsya báboko Yesu ɔflɔ. Yesu átsya wǝ itǝ ófo etiki budi, kǝnyǝ asa tsya. ");
INSERT INTO lip_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ayanisa nnya Yesu díyifo mfó éyifo betidi bamfó yanii, nya bátɔ bǝnkǝ, “Inni nwǝmfo ni Oka David eto ufluflu wǝ bákpo ɔhile bǝtsyǝ?” ");
INSERT INTO lip_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Se Farisifɔ lɛnɔ nyamfoo, bátɛyi bǝnkǝ, “Woala ɔwɔnɔ bua kǝlǝkǝ ɛyɛ lǝ ǝsuǝale nya awɔnɔ bua eto ɔtɔnkotɔnko Beelsebul dítǝ wǝ ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesu áte mǝ nsusu nyaso ɔ́tɛyi mǝ nkǝ, “Sekakedikɔ saa sia laama akpa akpa, kǝńyǝ lǝ bǝtsyuǝ ǝsuǝǝ, ebɔkɛ sɛklɛ. Nya umǝ nye diyo saa nǝ laama akpa akpa kǝńyǝ lǝ bǝtsyuǝ ǝsuǝǝ, eboba lǝ akpa. ");
INSERT INTO lip_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Nyaso lǝ lekpa lɔni lɛ lekpa nuǝfǝ bɔkpɔnko lǝ Obonsam eto sekakedikɔɔ, ete bǝnkǝ dioba akpa, nya diǝmbɔklɛ fɛ dioba lekpo lǝ kasɔ. ");
INSERT INTO lip_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Lǝ bɛlɛ bɔtɛyi biǝ awɔnɔ bua eto ɔtɔnkotɔnko eto ǝsuǝale ǝsuǝ maayɛ kala awɔnɔ bua kǝlǝkǝ lǝ betidi ǝsuǝǝ, nyalɛ bawe eto ǝsuǝale ǝsuǝ mba ntǝkǝko mi laayɛ kala mǝ kǝlǝkǝ? Lesa nǝ mi kosate eto mba ntǝkǝko mi leeyifoo, lǝ bote bǝ bɛnlɛ sitinti bɔtɛyi. ");
INSERT INTO lip_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Inni Beelsebul bomuu, Onanto eto Lɛwɔnɔ ni lǝǝtǝ mɛ ǝsuǝale bǝ nla awɔnɔ bua lǝ betidi ǝsuǝ. Nyamfo lɛ bote bǝ Onanto eto Sekadidi ébutsyǝ kasɔ lǝ mi nti koko. ");
INSERT INTO lip_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Kuutsyuǝ saa embofo botaka kedufǝ lǝ ǝsuǝaletidi eto diyo ete utsyiko wǝ bikǝ butsyi, lenni bǝ ófo ǝsuǝaletidi ǝmǝ bumuǝ kakle fɛ woofo budufǝ lǝ diyo nǝmǝ ketsyi wǝ bikǝ. ");
INSERT INTO lip_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Utidi wǝ ke lentǝkǝko mɛɛ, uńyǝ mɛ lǝ ǝsuǝ. Nya nwǝ ke lanwunsǝko mɛ lǝ bɔsɛketsyue ǝsuǝ eesensǝ nnya. ");
INSERT INTO lip_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Lǝ nyamfo esoo, nlɛ mi bɔtɛyi minkǝ, boofi abua saa béyifo ku etiki bua saa bédi batsyɛ mǝ, fɛɛ nwǝ ke luudi etiki nnya diíyǝ lǝ Lɛwɔnɔ Kɛnkɛ ǝsuǝ alɛɛ, bembufi nnya batsyɛ wǝ. ");
INSERT INTO lip_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Nya utsyuǝ wǝ ke luudi etiki uńyǝ lǝ Utidi Eto Ubi ǝsuǝǝ, boofo bufi katsyɛ wǝ, fɛɛ utsyuǝ saa ke luudi etiki uńyǝ lǝ Lɛwɔnɔ Kɛnkɛ ǝsuǝǝ, bembufi batsyɛ wǝ lǝ nkpǝ bomfo lee mbo luubǝ ǝsuǝ tsya. ");
INSERT INTO lip_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Kuyi sɛɛ saa aanwɔ ebibi sɛɛ, nya kuyi bua saa tsya aanwɔ ebibi bua. Bǝǝtsyǝ kuyi lekpo ɛyɛ lǝ ebibi nnya koanwɔ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mimba lɛbɔ bitsyi lǝ bawa eto kafo ǝsuǝ! Asa sɛɛ aambɔ ketsyi lǝ mi kɛnyɛ! Itsyise lesa nǝ diyi mi ketu ǝsuǝǝ, nnya mi kɛnyɛ lǝǝlǝkǝ katɛyi nɛ. ");
INSERT INTO lip_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Utidi sɛɛ, asa sɛɛ laabɔ ketsyi lǝ wǝ nya ini nnya wǝǝlǝkǝ katɛyi nɛ. Nya utidi bua tsyaa, abua nnya nkpe lǝ wǝǝ, nnya wǝǝlǝkǝ katɛyi nɛ. ");
INSERT INTO lip_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Nla miǝ ekpa ko mi wee bǝ, lǝ Lekpoyi Fɛfɛɛ, utsyuǝ saa ebutǝ etiki bimba saa nnya lɛbɔ lǝ wǝ kɛnyɛ eto nkunta. ");
INSERT INTO lip_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Itsyise fǝ kosate eto etiki nnya lɛbɔ fǝ lǝ kɛnyɛɛ, nya buufi bakponko fǝ lekpo balofǝ dikpi lee bǝtǝ fǝ lɛbɛ nɛ.” ");
INSERT INTO lip_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Mfó nya afi eto bateasa ku Farisifɔ bǝtsyuǝ lɛtɛyi Yesu bǝnkǝ, “Oteasa, bola boǝ yifo ayanisa ǝtsyuǝ até lǝ bobe.” ");
INSERT INTO lip_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Mfó nya Yesu dítǝ mbuayɛ nkǝ, “Bebe, mi mmi eto betidi ba leesumu bǝfiǝ ku asa bimba. Bela biǝ biǝnyǝ ayanisa itsyi mɔ ɔflɔ, fɛɛ biembunyǝ ayanisa saa enso nnya dítsyi Onanto eto Unyɛlǝkǝtidi Yona ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Fe kase Yona dísiǝ eyi ǝtsyǝ ku ntsye ntsyǝ lǝ lɛkpɛ kplɛ ditsyuǝ eto kafoo, nko ke Utidi Eto Ubi tsya lɔɔkɛ lǝ eyi ǝtsyǝ ku ntsye ntsyǝ ǝsuǝ lǝ kasɔ kǝmiǝ nɛ. ");
INSERT INTO lip_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Lǝ Lekpoyi Fɛfɛɛ, Ninive eto betidi ebuńyǝ balo mi dikpi itsyise bátsyi bawuninsǝ se bánɔ Yona lébe Ditiki Sɛɛ nǝmǝ letsya. Nya lǝ ntɛyi mi, utsyuǝ kpe mi lenti mfo wǝ lɛmɔ onso Yona. ");
INSERT INTO lip_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Lǝ Lekpoyi Fɛfɛɛ, Besio eto Oka wǝ dítsyi Ɔnwɛdikue ebotaka uńyǝ olo mi dikpi, itsyise ɔ́yɛ utsyi taa mfó úsu Oka Salomo ɔflɔ nkǝ lǝ usu ɔnɔ Oka Salomo eto abesibetiki. Fɛɛ nlɛ mi bɔtɛyi sitinti minkǝ, lesatsyuǝ nǝ nso Oka Salomo eto kobe kpe mi lenti mfo. ");
INSERT INTO lip_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Nlɛ mi bɔtɛyi minkǝ, lǝ bala lɛwɔnɔ bua bǝlǝkǝ lǝ utidi ǝsuǝǝ, diesukayɛ nlebe nlebe bo lekoe kabɛbɛ kasɔnɔkɔ. Nya lǝ diǝnnyǝ kedufǝkɔ saa, ");
INSERT INTO lip_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","diatɛyi ni ǝsuǝ nkǝ, ‘Muusinkli nsu kaka mínsiǝ kɔ.’ Lǝ dibǝ dinyǝ nkǝ mfó te fufuu, bákpa mfó nya betsyue bikǝ kukɔnɔ lǝ ni kafoo. ");
INSERT INTO lip_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Diesinkli kesu kakpa awɔnɔ bua akuanse bamba nnya nkpe ale enso ni nya beesinkli kesu kǝsiǝ mfó. Nya lǝ kalokɔɔ, utidi ǝmǝ eto asayifoyifo aabia kaso nnya kɔ. Nko yuutsyǝ itǝ mi mmi eto betidi bua bamfo nɛ.” ");
INSERT INTO lip_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Lefe nǝ Yesu nsi nlɛ etiki budi ku betidi bamǝǝ, wǝ ambe ku wǝ bayimisani ǝbǝ bǝńyǝ lǝ lekple mfó nya bála bǝ bedinko wǝ etiki. ");
INSERT INTO lip_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Nya betidi ba díńyǝ mfó eto ɔni dísu ɔ́tɛyi Yesu nkǝ, “Bebe, fǝ ambe ku fǝ bayimisani ńyǝ lǝ lekple bǝ bala bǝ beedinko fǝ etiki.” ");
INSERT INTO lip_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesu ǝtǝ wǝ mbuayɛ nkǝ, “Owoe ni mɔ ambe nya bawe ni mɔ bayimisani?” ");
INSERT INTO lip_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Nya óté wǝ bakasebi kɔni ɔ́tɛyi nkǝ, “Nnyǝ mɔ ambe ku mɔ bayimisani! ");
INSERT INTO lip_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Utsyuǝ saa wǝ leeyifo mɔ Anto wǝ nkpe kato eto lelabii, wǝ ni mɔ ɔyimisani ku mɔ ɔyimisio ku mɔ ambe nɛ.” ");
INSERT INTO lip_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Diyi nǝmfó kee, Yesu édu lǝ diyo úsu lekpo kɛnyɛ. Úsiǝ lǝ kasɔ útsyiko asa boté. ");
INSERT INTO lip_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Betidi ba díbǝ bátsyilama wǝ efui tinti eso údufǝ lǝ ɔklɔ utsyuǝ nya úsiǝ lǝ kasɔ, nya sitiditu siamǝ díńyǝ lǝ utuflɔ mfó. ");
INSERT INTO lip_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Údi mǝ etiki kpǝ ɔ́yɛnko lǝ akpá ǝsuǝ nkǝ, “Lefe nǝ léfe mǝǝ, utsyuǝ uni ésu úsǝ eyibibi lǝ ɔkuɛ. ");
INSERT INTO lip_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Se ɔnlɛ eyibibi nyamǝ busǝǝ, ǝtsyuǝ álo ékpo lǝ kusu ɔflɔ nya baklɔbɛ díbǝ básɛ nnya bámini. ");
INSERT INTO lip_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Eyibibi nyamǝ ǝtsyuǝ tsya álo ékpo lǝ abanse ǝsuǝ, kaka sitǝ lemfui. Íkǝ mlǝ itsyise site siamǝ memfui. ");
INSERT INTO lip_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Fɛɛ se kofe lefaa, eyibibi nyamǝ díkǝǝ, áblobe nya íkpǝ itsyise nnya keyudu méndufǝ isu kasɔ etsyo. ");
INSERT INTO lip_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Eyibibi nyamǝ eto ǝtsyuǝ álo ékpo lǝ biyu nti. Nya se íkee, biyu biamǝ áto íti nnya. ");
INSERT INTO lip_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Fɛɛ eyibibi nyamǝ eto ǝtsyuǝ álo ékpo lǝ kasɔ sɛɛ ǝsuǝ nya se íkǝ ébee, ɛnwɔ ebibi. Ǝtsyuǝ anwɔ kolofa, ǝtsyuǝ tsya awosi akua, nya ǝtsyuǝ tsya lɛnwɔ awosi ǝtsyǝ.” ");
INSERT INTO lip_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Nya Yesu lɛtɛyi mǝ nkǝ, “Fǝ ke ato nnya laanɔ asa nkpee, nɔ!” ");
INSERT INTO lip_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Nya Yesu eto bakasebi díbǝ Yesu ɔflɔ nya bátɔ wǝ bǝnkǝ, “Beso feedi betidi etiki kayɛnko lǝ akpá ǝsuǝ?” ");
INSERT INTO lip_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesu ǝtǝ mǝ mbuayɛ nkǝ, “Mimii, béfi kato eto sekakedikɔ eto asakulakula bǝtǝ mi, fɛɛ inni betidi bamba. ");
INSERT INTO lip_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Utidi wǝ ke asa ntee, buusi bǝtǝ wǝ bawunsǝ nya wɔɔkɛ kpǝ. Nya utidi wǝ kulesa lentee, nnya nte wǝ tsyaa, bɔɔlɛ nnya bafo wǝ lǝ ani. ");
INSERT INTO lip_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Nnya eso meedi mǝ etiki kayɛnko lǝ akpá ǝsuǝ ni nkǝ, balɛ asa bunyǝ ku ǝnǝmi, fɛɛ bǝǝnnyǝ kǝtsyǝ lekpo. Balɛ bɔnɔ, tsya fɛɛ baannɔ nye banɔ kasɔ. ");
INSERT INTO lip_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Nyaso Unyɛlǝkǝtidi Yesaya eto nnya ɔ́tɛyi utsyǝ ǝbǝ itǝ nko bǝ, ‘Betidi bamfo ebɔnɔ bãã, fɛɛ bǝmbɔnɔ kasɔ! Boonyǝ asa bãã, fɛɛ bǝmbunyǝ ekpanko mǝ ");
INSERT INTO lip_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Itsyise disi ǝkpǝ betidi bamfó. Lenni nko inii, eni mǝ ǝnǝmi ebunyǝ asa wuee. Mǝ ato tsya ebɔnɔ asa nnya mǝ nsusu tsya lɔɔnɔ asa kasɔ, nya bɔɔtsyi mǝ ǝnǝmi bǝtǝ mɛ, nko Onanto lɛtɛyi nɛ, nya mootsya mǝ bufi.’ ");
INSERT INTO lip_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Fɛɛ mii, disiɛkpɛ kpe mi tinti, itsyise mi ǝnǝmi ǝǝnyǝ asa nnya mi ato tsya laanɔ asa. ");
INSERT INTO lip_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nlɛ mi bɔtɛyi sitinti minkǝ, Onanto eto bǝnyɛlǝkǝtidi ku basɛɛ kpǝ ábɛbɛ bǝ lǝ bǝnyǝ asa nnya bɛnlɛ buunyǝ, fɛɛ bǝnyǝ nya lǝ banɔ asa nnya bɛnlɛ bɔɔnɔ, fɛɛ bánnɔ.” ");
INSERT INTO lip_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Yesu átɛyi wǝ bakasebi nkǝ, “Bitsyue ato lǝ bɛnɔ lǝ nlǝkǝ nwǝ dísǝ eyibibi eto lekpá eto kasɔ nte mi. ");
INSERT INTO lip_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Utsyuǝ saa wǝ laanɔ Ditiki Sɛɛ nǝmǝ itsyi lǝ Onanto eto Sekadidi eto letsyabebe fɛ woannɔ ni kasɔɔ, eyifo fe eyibibi nnya lélo ékpo lǝ usunte ɔflɔ nya olontidi ǝmǝ lǝǝbǝ kǝnǝ nnya báto mfó kǝlǝkǝ lǝ mǝ akɔɛsi. ");
INSERT INTO lip_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Eyibibi nnya lélo ékpo lǝ kabansesɔɔ, ńyǝ itǝ betidi ba laanɔ ditiki nǝmǝ nya baafo ni ku disuǝyuǝ lamfolamfo. ");
INSERT INTO lip_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Fɛɛ se dianyɛ kedufǝ lǝ mǝ ketu kesu kǝmiǝ esoo, diǝnsiǝ lǝ mǝ kaklɛ. Nyaso lǝ bulǝ nye kamatiti kǝtsyuǝ ǝbǝ lǝ mǝ ǝsuǝ iku lǝ ditiki nǝmǝ esuǝǝ, yealo mǝ ani lamfolamfo nya bǝǝtǝ disi. ");
INSERT INTO lip_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Eyibibi nnya dídufǝ lǝ biyu nti ni betidi ba laanɔ ditiki nǝmǝ. Fɛɛ disibubu lǝ kawunsiǝ kamfo eto bikǝ ku ke setabikɛ sia laawɛ utidi kakpee, aato keti ditiki nǝmǝ, itǝ diannwɔ ebibi. ");
INSERT INTO lip_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Nya eyibibi nnya lélo ékpo lǝ kasɔ sɛɛ ǝsuǝ ni betidi ba laanɔ ditiki nǝmǝ nya baanɔ ni kasɔ. Nya dianwɔ ebibi, ǝtsyuǝ kolofa, ǝtsyuǝ awosi akua, nya ǝtsyuǝ tsya awosi ǝtsyǝ.” ");
INSERT INTO lip_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu átɛyi mǝ lekpá bamba nkǝ, “Onanto eto sekakedikɔ ale utsyuǝ wǝ díse eyibibi sɛɛ lǝ wǝ ɔkuɛ. ");
INSERT INTO lip_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Lǝ ketsye eto lefe nǝ utsyuǝ saa nlabe selabee, olontidi utsyuǝ ésu úsǝ eyibibi wuliwuli ókpo lǝ akpa nyamǝ nti nya údu. ");
INSERT INTO lip_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Se eyibibi nyamǝ lébe itsyiko bɔnwɔɔ, sefa sia olontidi ǝme dísu úse ókpo lǝ ɔkuɛ ǝmǝ tsya étsyiko ǝsuǝ bulǝkǝ kate. ");
INSERT INTO lip_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Mfó nya ɔkuɛnsate eto beyifoyifo dísu bátɔ wǝ bǝnkǝ, ‘Boanto, búnyǝ boǝ eyibibi sɛɛ fesǝ lǝ fǝ ɔkuɛ ǝmǝ. Nya se sefa siamfo dítsyi?’ ");
INSERT INTO lip_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Útǝ mǝ mbuayɛ nkǝ, ‘Olontidi utsyuǝ díyifo nyamfo nɛ.’ “Bátɔ wǝ bǝnkǝ, ‘Ala fǝ busu busu sefa siamǝ bulǝkǝ?’ ");
INSERT INTO lip_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Útǝ mǝ mbuayɛ nkǝ, ‘Owo, itsyise lǝ bisu sefa siamǝ kesukɔ kǝlǝkǝǝ, biofo akpa eto ǝtsyuǝ tsya busu kǝlǝkǝ ku sefa siamǝ. ");
INSERT INTO lip_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Bitǝ lǝ sefa siamǝ ku akpa nyamǝ lǝ ińyǝ isu ese dilǝkǝfe. Lefe nǝmfóo, muutǝ beyifoyifo bamǝ tɔ̃ baka sefa siamǝ bulǝkǝ kakle etsyu, etsyu batonsǝ fɛ lǝ batɔ bǝlǝkǝ akpà nyamǝ. Nya lǝ bekpa ebibi nyamǝ bekpo lǝ mɔ kenwu ǝsuǝ.’ ” ");
INSERT INTO lip_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu esi ɔ́tɛyi mǝ lekpá bamba ditsyuǝ nkǝ, “Onanto eto sekakedikɔ ale utidi wǝ léto diyibibi kɛkɛ ditsyuǝ lǝ wǝ kasɔ. ");
INSERT INTO lip_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Diyifo diyibibi nǝ nso bɔfɛ lǝ ni bǝtsyuǝ nti. Fɛɛ lǝ díkǝ lébee, diamɔ kafiani kuyi ko laaso bɔmɔ lǝ ko bǝtsyuǝ kenke nti. Diesense kalɛ nya baklɔbɛ lǝǝbǝ kato ayo lǝ ko kalɛ ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu esi ɔ́tɛyi mǝ lekpa bamba nkǝ, “Nyǝ mǝ Onanto eto sekakedikɔ nte. Site fe usio wǝ dífi ǝyǝnkisǝsa otsyakasǝ ku ntabinamfo eto utu utsyuǝ isu ese lefe nǝ nnamfo wɔwɔ bomǝ kenke letaka.” ");
INSERT INTO lip_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu éfi akpá óte betidi bamǝ asa nyamfo kenke. Wéndi mǝ etiki saa nnya dímanyɛ lǝ akpá ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Úyifo nko itǝ lǝ ditiki nǝ Onanto eto Unyɛlǝkǝtidi lɛtɛyi utsyǝ lǝ ibǝ itǝ nkǝ, “Muudi mǝ etiki nyɛnko lǝ akpá ǝsuǝ. Muudi mǝ etiki nnya nkpe lǝ kakula ǝsuǝ idu lǝ kawunsiǝ eto kasɔ ketsyikokɔ ke.” ");
INSERT INTO lip_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesu édu lǝ betidi bamǝ ɔflɔ nya úsu diyo. Nya wǝ bakasebi díbǝ wǝ ɔflɔ bátɛyi wǝ bǝnkǝ, “Lǝkǝ lekpá nǝ fátɛyi bo itsyi lǝ sefa wunyɛwunyɛ sia lɛkɛ lǝ ɔkuɛ ǝmǝ kasɔ ate bo.” ");
INSERT INTO lip_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesu átɛyi mǝ nkǝ, “Nwǝ dísǝ eyibibi sɛɛ nyamǝ ni mɔ, Utidi Eto Ubi. ");
INSERT INTO lip_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ɔkuɛ ǝmǝ ni kawunsiǝ. Nya eyibibi sɛɛ nyamǝ ni mba nkpe lǝ sekakedikɔ siamǝ. Sefa siamǝ ni betidi ba ni olontidi ǝmǝ eto bale. ");
INSERT INTO lip_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Nya olontidi wǝ dísǝ sefa bua siamǝ ni Obonsam. Bidikǝ dilǝkǝfe ni kawunsiǝ eto kalosǝkɔ. Nya mba lǝǝlǝkǝ bidike biamǝ ni Onanto eto batɔnkpe. ");
INSERT INTO lip_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Fe kase baakpa sefa kǝtsyǝ ditsyu katonsǝǝ, nko ke yuubǝ lǝ kawunsiǝ eto kalosǝkɔ nɛ. ");
INSERT INTO lip_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mɔ, Utidi Eto Ubi, ebotsyese mɔ batɔnkpe lǝ bǝlǝkǝ asa nnya lǝǝtǝ boeyifo abua ku babuayifo kenke betsyiko Onanto eto sekakedikɔ. ");
INSERT INTO lip_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Boofi mǝmblɛ bato bakpe lǝ ditefɛnku manlo kǝmiǝ. Mfó boowi nku bayimi animi! ");
INSERT INTO lip_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Nya Onanto eto betidi luuyǝnde fe kofe lǝ mǝ Onanto eto umǝ. Mba ato nkpee, tsyue ato lǝ banɔ! ");
INSERT INTO lip_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Onanto eto sekakedikɔ ale bikǝ bia lefo koya béfi bákula lǝ ɔkuɛ utsyuǝ, nya utsyuǝ dísu ɔ́kɛ nnya nya úsi úfi ɔ́kula. Únyǝ disuǝyuǝ tinti, nyaso úsu úfi wǝ lesa saa óte nya úfí úsu óya ɔkuɛ ǝmǝ.” ");
INSERT INTO lip_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Yesu esi ɔ́tɛyi nkǝ, “Onanto eto sekakedikɔ ale nwǝ laate bikǝ wǝ nlɛ atsyabi nnya laanɔ bobe tinti bɔbɛbɛ. ");
INSERT INTO lip_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Se úsu únyǝ ɔni wǝ lefo koya tinti onsoo, úfi lesa saa nǝ nte wǝ úsu óte nya úsu óya otsyabi ǝmǝ.” ");
INSERT INTO lip_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Yesu átɛyi nkǝ, “Onanto eto sekakedikɔ esi sele asabu nnya báta bákpo lǝ lekpo, nnya bǝlǝkǝ akpɛ ate ate kpǝ. ");
INSERT INTO lip_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Nya lefe nǝ asabu nyamǝ díyii, bǝnǝ nnya bábɔnko lǝ ntu báboko ditukpenkpe nya bǝsiǝ lǝ kasɔ nya básɛ akpɛ nyamǝ bǝlǝkǝ. Básɛ edidi bákpo lǝ etsyitsya, nya básɛ nnya beendi béwui. ");
INSERT INTO lip_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Nko ke yuutsyǝ lǝ kawunsiǝ eto kalokɔ nɛ. Onanto eto batɔnkpe ebubǝ bǝlǝkǝ betidi sɛɛ betsyiko lǝ babua nti. ");
INSERT INTO lip_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Nya booto babuayifo bakpe lǝ ditefɛnku manlo kǝmiǝ. Mfó nya nkuwiwi ku anyiyimiyimi lɔɔkɛ.” ");
INSERT INTO lip_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesu átɔ mǝ nkǝ, “Bɛnɔ asa nyamfo kasɔ?” Bǝtǝ mbuayɛ bǝnkǝ, “Ee.” ");
INSERT INTO lip_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Nyaso Yesu átɛyi mǝ nkǝ, “Nyalɛ, nyamfo lɛ bote nkǝ, afi eto oteasa saa wǝ léfiani Onanto eto sekakedikɔ eto okasebi, ale Onamute utsyuǝ wǝ lǝǝlǝkǝ bike fɔfɔ ku bekoko lǝ mi kakulakɔ kaboko lekple.” ");
INSERT INTO lip_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Nya se Yesu lɛtɛyi akpá nyamfo kenke ólosǝǝ, údu mfo. ");
INSERT INTO lip_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Úsinkli úsu mǝ umǝ, nya óte asa lǝ mǝ katsyakɔ. Nya betidi ba lɛnɔ wǝ asatetee, íyifo mǝ yanii, nya bátɔ bǝ, “Sieti nwǝ mfo lékase kobe komfo eto okle útsyiko? Nya sie únyǝ ǝsuǝale nnya ufi ɔnlɛ ayanisa nyamfo buyifo kate? ");
INSERT INTO lip_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Inni wǝ ni nwǝ laawoe keyi eto ubi ǝmǝ lee? Nya eni Maria tsya ni wǝ ambe, nya wǝ bayimisani tsya ni Yakob, Yosef, Simon ku Yuda, nya wǝ bayimisio kenke tsya nkpe bo lenti mfo lee? ");
INSERT INTO lip_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Nya lǝ sieti ɔkɛ wǝ kobe ku ǝsuǝale nyamfo eto okle utsyiko?” ");
INSERT INTO lip_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Nko ini bǝ wǝ asa eyifo mǝ kɛnyɛlele, nyaso báni wǝ. Mfó nya Yesu lɛtɛyi mǝ nkǝ, “Onanto eto Unyɛlǝkǝtidi kpe dibu lǝ kalebe saa, enso wǝ umǝ ku wǝ batokpenyǝ hã eto nti bǝ beembu wǝ.” ");
INSERT INTO lip_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Se bámfo bánɔ esoo, Yesu ményifo ayanisa kpǝ lǝ mǝ nti. ");
INSERT INTO lip_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Lǝ lefe nǝmfóo, Herodes wǝ dídi Seka Lǝ Galilea eto kasɔɔ, ánɔ etiki itsyi lǝ Yesu ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ɔ́tɛyi wǝ beyifoyifo nkǝ, “Utidi emfo ni Ntuflǝsǝtidi Yohanes wǝ bátakǝsǝ betsyiko ɔkɔmǝ úbǝ nkpǝ, nyaso onkpe ǝsuǝale weeyifo ayanisa kate nɛ.” ");
INSERT INTO lip_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ɔ́tɛyi nko itsyise Herodes ni nwǝ dítǝ bǝmuǝ Yohanes bákpe lǝ Aba eto diyo. Úyifo nko lǝ Herodia wǝ ni wǝ ɔyimi Filipo eto usiǝ eso. ");
INSERT INTO lip_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Itsyise Ntuflǝsǝtidi Yohanes átɛyi Herodes nkǝ, “Onanto eto kɔfi mǝntǝ kusu bǝ fi fǝ ɔyimi eto usiǝ Herodia.” ");
INSERT INTO lip_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Nyamfo eso Herodes ála nkǝ lǝ balo Yohanes. Fɛɛ óte Yudafɔ eto betidi sikpi, itsyise bébu Yohanes fe Onanto eto Unyɛlǝkǝtidi. ");
INSERT INTO lip_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Diyi lɔnii, se Herodes nlɛ wǝ leleyi budii, ókpadi betidi bǝbǝ. Nya Herodia eto ubisiobi díbǝ uwi kewi lǝ betidi kpǝ bamǝ eto ǝnǝmi. Nyamfo ákpe Herodes disuǝyuǝ tinti. ");
INSERT INTO lip_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Mfó útsyǝ kɛnyɛ útǝ wǝ nkǝ, “Ekpe lǝ lesa saa bǝ muutǝ fǝ lesa nǝ ke fatɔ!” ");
INSERT INTO lip_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Wǝ ambe ǝtǝ ɔ́tɔ nkǝ, “Tǝ mɛ mɔmɔ mɔmɔ mfoo, Ntuflǝsǝtidi Yohanes eto disi nǝ béfi bǝtǝkǝ lǝ ɔkpɛ tɛnklɛ ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Lesa nǝ disiobi nǝmfo lɛtɔ ǝlǝ Herodes efensɛ. Fɛɛ lǝ kɛnyɛ ka úkǝtsyǝ lǝ wǝ beninǝ ku mba ókpadi óboko mfó eto ǝnǝmi esoo, útǝ nkǝ beyifo lǝ disiobi nǝmǝ eto nnya ɔtɔ ǝsuǝ bǝtǝ wǝ. ");
INSERT INTO lip_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Nyaso ókpe utidi úsu óla Yohanes wǝ lɛkɛ lǝ Aba eto diyo eto disi. ");
INSERT INTO lip_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Béfi disi nǝmǝ nkpe lǝ ɔkpɛ tɛnklɛ ǝsuǝ bǝtǝ disiobi nǝmǝ nya wuntsya dífi ni úsu útǝ wǝ ambe. ");
INSERT INTO lip_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Yohanes eto bakasebi ǝbǝ bétsyi wǝ ɔkɔ ǝmǝ bésu bébike, nya bésu bátɛyi Yesu. ");
INSERT INTO lip_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Lefe nǝ Yesu lɛnɔ nkǝ bálo Yohanes, úsiǝ lǝ ɔklɔ údu mfó úsu kaka lɛbiɔ. Fɛɛ se betidi lɛnɔ nkoo, bédu lǝ mǝ kǝmǝ, báyɛ akpa bésu kaka onkpe. ");
INSERT INTO lip_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Mfó nya Yesu lɛbɔ lǝ ɔklɔ ǝmǝ kafo. Nya se únyǝ sitiditu siamǝ, mǝ asa ǝnǝ wǝ kafo nya ótsya mba ni befimfi. ");
INSERT INTO lip_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ditsyitsyo nǝmfóo, wǝ bakasebi ǝbǝ wǝ ɔflɔ nya bátɛyi bǝnkǝ, “Kale ebolo, nya mfo tsya atsyo ku umǝ. Nyaso yani betidi bamfo lǝ besu mbuto bo nkpe mfó lǝ besu baya lesatsyuǝ bedi.” ");
INSERT INTO lip_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesu ǝtǝ mǝ mbuayɛ nkǝ, “Yanle bǝ bedu. Mi kosatee, bitǝ mǝ lesatsyuǝ lǝ bedi.” ");
INSERT INTO lip_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Bátɛyi wǝ bǝnkǝ, “Lesa nǝ nte bo ete ni abolo anɔ ku akpɛ ǝnuǝ.” ");
INSERT INTO lip_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Mfó nya Yesu lɛtɛyi mǝ nkǝ, “Bifi nnya beboko mɛ mfo.” ");
INSERT INTO lip_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ɔ́tɛyi betidi bamfó nkǝ bǝsiǝ kasɔ lǝ sefa ǝsuǝ. Nya ufi abolo anɔ ku akpɛ ǝnuǝ nyamǝ, nya óbesǝ wǝ ǝnǝmi kato nya ɔ́sɔ Onanto ani. Úbudi abolo nyamǝ nya úfi útǝ wǝ bakasebi. Nya bakasebi bamǝ tsya dífi nnya bǝtǝ betidi bamǝ. ");
INSERT INTO lip_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Utsyuǝ saa édi úmi. Nya se wǝ bakasebi lɛsɛ nnya bédi díbuu, íyi etsyitsya lefosi ǝnuǝ. ");
INSERT INTO lip_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Basani ba dídi lesa nǝmǝ eyifo fe basani akpi anɔ. Fɛɛ bánkla besio ku bekpefi bákpe lenti. ");
INSERT INTO lip_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Mfó nya Yesu dítǝ wǝ bakasebi lébe bédufǝ lǝ ɔklɔ nya ɔ́tɛyi mǝ nkǝ bákatɔ lǝ ditumbukplɛ nǝmǝ eto lekpake nǝ nse. Wǝ akɛ mfó nkǝ lǝ utsyǝ betidi bamǝ kusu. ");
INSERT INTO lip_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Se útsyǝ betidi bamǝ kusu olosǝǝ, wǝ mate ábe úsu kɔtini kato úsu óto ola. Se ketsye lefe léyoo, wǝ mate hã ákɛ mfó. ");
INSERT INTO lip_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Lǝ lefe nǝmfóo, ɔklɔ ǝmǝ ébɔyɛ ótsyo. Ufiebi lɛ bɔsɔ kekleke ketinkǝsǝ kufuǝ komǝ, nya ntu nlɛ bɔsɔ kedufǝ lǝ ɔklɔ ǝmǝ kafo fe wuufusǝ. ");
INSERT INTO lip_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Nya fe kolensiǝntu kplɛ eto abombo ǝtsyǝ ku olosiǝ eto abombo akua nti sekaa, Yesu áyɛ lǝ ntu ǝsuǝ úbǝ údufǝ wǝ bakasebi bamǝ ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Lefe nǝ bǝnyǝ bǝ ɔyɛ lǝ ntu ǝsuǝ mfóo, báte sikpi nya bátɛyi bǝnkǝ, “Ɔkɔ uni!” Nyaso bétsyiko bofa ku sikpi bembembe! ");
INSERT INTO lip_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Fɛɛ Yesu édi mǝ etiki lamfolamfo ɔ́tɛyi nkǝ, “Bekpe utu! Mɔ uni! Biante sikpi!” ");
INSERT INTO lip_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Mfó nya Petro lɛtɛyi nkǝ, “Bonamute, lǝ fǝ uni sitintii, tǝ lǝ nyɛ lǝ ntu ǝsuǝ mbǝ ntu fǝ.” ");
INSERT INTO lip_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesu átɛyi wǝ nkǝ, “Bǝ!” Nya Petro lɛbɔ lǝ ɔklɔ ǝmǝ kafo nya útsyiko bɔyɛ lǝ ntu bomǝ kesu Yesu ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Fɛɛ se únyǝ kase ufiebi ǝmǝ nkpe kɛnyɛ alee, sikpi ǝmuǝ wǝ nya útsyiko bonya kedufǝ lǝ ntu bomǝ kǝmiǝ. Mfó nya Petro lefã ɔ́tɛyi nkǝ, “Bonamute, fo ǝtǝ mɛ!” ");
INSERT INTO lip_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Lamfolamfo Yesu ǝnǝ kɔni útsyue, ɔ́kɔbe wǝ nya ɔ́tɛyi wǝ nkǝ, “Fǝ bofokanɔ lǝ mɛ ǝmbǝ ale! Beso fáyaki?” ");
INSERT INTO lip_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Se mǝ inuǝ bamǝ dídufǝ lǝ ɔklɔ ǝmǝ kafoo, ufiebi ǝmǝ ko lɛyɛ bɔsɔ. ");
INSERT INTO lip_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Mfó nya bakasebi bamǝ lése akonki básumu wǝ. Nya bátɛyi wǝ bǝnkǝ, “Onanto eto ubi feni sitinti!” ");
INSERT INTO lip_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Se báyila ditumbukplɛ nǝmǝ báyo ditukpenkpe nǝ nsee, báyifǝ lǝ Genesaret eto kasɔ. ");
INSERT INTO lip_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Mfoó, betidi bamǝ ǝnyǝ Yesu bǝtsyǝ lekpo. Nyaso bésu bákpa befimfi ba kenke nkpe lǝ lekpake nǝmfó báboko Yesu ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Bálɛ wǝ lekpakpa bǝ lǝ utǝ lǝ befimfi lǝ betidi wǝ awu eto atosi ete. Nya mba kenke dítidi wǝ awu eto atosii, mǝ bufi ǝyuǝ mǝ. ");
INSERT INTO lip_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Nya Farisifɔ bǝtsyuǝ ku afi eto bateasa bǝtsyuǝ ba dítsyi Yerusalem díbǝ Yesu ɔflɔ nya bátɔ wǝ bǝnkǝ, ");
INSERT INTO lip_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Beso fɛ fǝ bakasebi leenyifo lǝ bo banamǝ eto akpa ǝsuǝ? Bǝǝmflǝ mǝ ani kukɔnɔ fe kase bo akpa laate fɛ beedi lesa!” ");
INSERT INTO lip_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesu átɔ mǝ nkǝ, “Nya beso biani nya bienyifo lǝ Onanto eto afí ǝsuǝ fɛ biǝtǝkǝko mi batekoko, banakoko eto asatete kama? ");
INSERT INTO lip_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Itsyise Onanto átɛyi nkǝ, ‘Bu fǝ anto ku fǝ ambe. Nya utidi wǝ laakpadi wǝ anto ku ambe diye bua ditsyuǝǝ, ele bǝ balo wǝ.’ ");
INSERT INTO lip_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Fɛɛ mi áte biǝ utidi nwǝ lesatsyuǝ nte nkǝ woofo ni bufi kawunsǝko wǝ anto nye ambe fɛ ɔ́tɛyi nkǝ, ‘Mfi lesa nǝmfo ntsyǝ kɛnyɛ miǝ muufi ni ntǝ Onanto.’ ");
INSERT INTO lip_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ɛyɛ lǝ nyamfo ǝsuǝǝ, yensi fe bǝ bebu mǝ anto mǝ. Kusu komfo ǝsuǝ nya biayɛ kani Onanto eto kɔfi itǝ lǝ bitǝkǝko mi kosate eto asatete kama nɛ. ");
INSERT INTO lip_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mi ǝnǝmi ǝnǝmi eto betidi! Asa nnya Onanto eto Unyɛlǝkǝtidi Yesaya lɛtɛyi útsyǝ lǝ mi ǝsuǝ ǝbǝ itǝ nko sitinti. ");
INSERT INTO lip_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Onanto átɛyi nkǝ, ‘Betidi bamfo efi mǝ kɛnyɛ eto etiki fufu balɛ mɛ dibu butǝ. Fɛɛ lǝ mǝ utu kǝmiǝǝ, baanla mɛ. ");
INSERT INTO lip_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Bimba ete beeyifo mɔ keyifo. Itsyise kawunsiǝ eto betidi eto asa ete baate lǝ mɔ ale eto kɛnyɛ.’ ” ");
INSERT INTO lip_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Mfó nya Yesu lékpadi sitiditu siamǝ oboko wǝ ɔflɔ nya ɔ́tɛyi mǝ nkǝ, “Bitsyue ato lǝ bɛnɔ asa nyamfo kasɔ! ");
INSERT INTO lip_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Inni lesa nǝ leedufǝ utidi eto kɛnyɛ laabiasǝ wǝ, bomu etiki nnya laabɔ ketsyi lǝ wǝ kɛnyɛɛ, nnya laabiasǝ wǝ nɛ.” ");
INSERT INTO lip_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Nya wǝ bakasebi díbǝ wǝ ɔflɔ bátɛyi wǝ bǝnkǝ, “Eyi fǝnkǝ se Farisifɔ lɛnɔ asa nnya fátɛyii, éla mǝ kɛnyɛ lele tinti?” ");
INSERT INTO lip_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yesu ǝtǝ mǝ mbuayɛ nkǝ, “Kuyi saa kuyi ko mɔ Anto wǝ nkpe Kato dímantoo, boosu ko bewi. ");
INSERT INTO lip_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Nyaso biankpe mǝ kɛnyɛ. Bete fe bǝnǝmba ba nyɛnko bǝnǝmba bamba. Nya lǝ unǝmba ɔni yɛnko unǝmba bambaa, mǝ inuǝ ba tã ebudu banɔ bedufǝ lǝ kubiǝ kafo.” ");
INSERT INTO lip_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Petro átɛyi wǝ nkǝ, “Lǝkǝ lekpa nǝmfo kasɔ ate bo.” ");
INSERT INTO lip_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Nya Yesu lɛtɛyi mǝ nkǝ, “Nyalɛ betidi ba laannɔ asa kasɔ ete binsi binii? ");
INSERT INTO lip_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Binyi biǝ lesa saa nǝ didufǝ utidi lǝ kɛnyɛ, ayɛ kedufǝ wǝ lǝ kafo, nya weesie ni kabɔsǝ fe ɔflɔ kewi? ");
INSERT INTO lip_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Fɛɛ etiki nnya laabɔ ketsyi lǝ wǝ kɛnyɛ, aabɔ ketsyi lǝ wǝ utu kǝmiǝ. Nya nyamfo lǝǝtǝ utidi laanansǝ ǝsuǝ lǝ kesumu eto kusu ǝsuǝ nɛ. ");
INSERT INTO lip_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Itsyise itsyi lǝ wǝ utu kǝmiǝ nya diǝtǝ weeyifo asa bua fe ditidilo, sɛsɔnɔdi nye disenkpo, setsyetɔ, kuyu ku bidiatɛyitɛyi ku betidi eto ayebiasǝbiasǝǝ, laabɔ ketsyi nɛ. ");
INSERT INTO lip_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Asa nyamfo eto kakle laanansǝ utidi nɛ. Fɛɛ lǝ utidi mǝmflǝ kɔni fɛ udi lesa fe kase Farisifɔ laatee, nyamfo aannansǝ utidi.” ");
INSERT INTO lip_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu édu mfó úsu lekpake nǝ lɛfi kǝmǝnkplɛ inuǝ ka ni Tiro ku Sidon ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Mfó nya Kana eto usio utsyuǝ díbǝ Yesu ɔflɔ, nya ókafã bembembe kalɛ wǝ lekpakpa nkǝ, “Mɔ Onamute, Oka David eto kafo eto ubi, nyǝ mɛ kaminsǝ! Lɛwɔnɔ bua ǝbǝ disi lǝ mɔ ubisiobi ǝsuǝ nya dítǝ ɔnlɛ kanyi bunyǝ fefe!” ");
INSERT INTO lip_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Fɛɛ Yesu ménfe kɛnyɛ ɔtɛyi wǝ kulesa. Mfó nya wǝ bakasebi lɛnyi besu balɛ wǝ lekpakpa bátɛyi wǝ bǝnkǝ, “La wǝ lǝ udu, itsyise utǝkǝko bo ɔlɛ bofã ketisǝ bo ato!” ");
INSERT INTO lip_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Nya Yesu dítǝ mǝ mbuayɛ nkǝ, “Israel bebi nte fe basamu ba lénya ɔflɔ hã Onanto lékpe mɛ nkǝ nsu.” ");
INSERT INTO lip_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Mfó nya usio ǝmfo díbǝ óse akonki lǝ wǝ ɔflɔ ɔ́tɛyi wǝ nkǝ, “Mɔ Onamute, wunsǝko mɛ!” ");
INSERT INTO lip_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesu ǝtǝ wǝ mbuayɛ nkǝ, “Yanlɛkɛ bǝ befi bekpefi eto didisa bato bakpe mǝ bakpa.” ");
INSERT INTO lip_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Usio ǝmǝ ǝtǝ mbuayɛ nkǝ, “Mɔ Onamute, ite nko sitinti. Fɛɛ bakpa bamǝ tsya aafo didisa wɛlɛwɛlɛ nǝ lélo lékpo kasɔ lǝ mǝ onamute eto ɔpunu kalɔ budii.” ");
INSERT INTO lip_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Mfó nya Yesu dítǝ wǝ mbuayɛ nkǝ, “Eyifo usio wǝ nkpe bofokanɔ tinti! Lesa nǝ fanlɛ bɔbɛbɛɛ, lǝ ibǝ itǝ fǝ.” Nyaso lǝ lefe nǝmǝ tutuutu wǝ ubisiobi ǝmǝ ǝmuǝ ale. ");
INSERT INTO lip_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu édu mfó, nya ɔyɛ lǝ Galilea eto ditumbukplɛ ɔflɔ óbe kɔtini kutsyuǝ nya úsiǝ kasɔ. ");
INSERT INTO lip_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Betidi kpǝ ǝbǝ wǝ ɔflɔ nya bákpa mba léba bankpoo kasɔ, bǝnǝmba, abafa, bamumu, ku befimfi bamba kpǝ báboko wǝ ɔflɔ, nya ótsya mǝ bufi. ");
INSERT INTO lip_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Iyifo betidi bamǝ yanii se bǝnyǝ bamumu nlɛ etiki budi, mba léba bankpoo kasɔ nlɛ botaka kayɛ, abafa nlɛ bɔyɛ, bǝnǝmba nlɛ asa bunyǝ nya bátɛsǝ Israel eto Onanto. ");
INSERT INTO lip_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu ákpadi wǝ bakasebi óboko wǝ ɔflɔ nya ɔ́tɛyi mǝ nkǝ, “Sitiditu siamfo eto asa lɛ mɛ kaminsǝ, itsyise bǝbǝ mɛ ɔflɔ diyi tsyǝfǝ sɔ̃ɔ̃ nɛ, nya kulesa ente mɔmɔ boodi. Manla miǝ lǝ yani mǝ lǝ bedu ku kafo fufu, lǝ ǝnǝmi lǝ isu enako mǝ lǝ kusu.” ");
INSERT INTO lip_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Wǝ bakasebi átɔ wǝ bǝnkǝ, “Sieti buunyǝ didisa butǝ mǝ lǝ mfimnti mfo bǝ lǝ betidi ba kpenkpe mfo lǝ bedi bemi?” ");
INSERT INTO lip_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu átɔ mǝ nkǝ, “Didisa lesia nte mi?” Nya bátɛyi wǝ bǝnkǝ, “Abolo akuanse ku akpɛ kɛkɛ asiani ete nte.” ");
INSERT INTO lip_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Nyaso Yesu átɛyi sitiditu siamǝ nkǝ bǝsiǝ kasɔ. ");
INSERT INTO lip_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Úfi abolo akuanse ku akpɛ nyamǝ, nya ɔ́sɔ Onanto ani, nya úbudi nnya nya úfi útǝ wǝ bakasebi bamǝ. Nya bésie nnya bǝtǝ betidi bamǝ. ");
INSERT INTO lip_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Mǝmblɛ édi lesa nǝmǝ bemi. Nya se básɛ nnya wɛlɛwɛlɛ nnya díbuu, íyi etsyitsya akuanse. ");
INSERT INTO lip_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Basani ba dídi lesa nǝmǝ eboyo akpi ana. Fɛɛ bánkla besio ku bekpefi bakpe lenti. ");
INSERT INTO lip_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Se Yesu dítsyǝ betidi bamǝ kusu olosǝǝ, údufǝ lǝ ɔklɔ nya údu úsu Magadan eto lekpake eti. ");
INSERT INTO lip_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Farisifɔ ku Sadukifɔ bǝtsyuǝ ǝbǝ Yesu ɔflɔ bǝ lǝ bato wǝ babe. Nyaso bátɛyi wǝ bǝnkǝ, “Yifo ayanisa ǝtsyuǝ ate bo lǝ bote boǝ etsyi Onanto ɔflɔ sitinti.” ");
INSERT INTO lip_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Fɛɛ Yesu ǝtǝ mǝ mbuayɛ nkǝ, “Lǝ kofe lɛ diyo budufǝ nya binyǝ asɔmiloku lɛsɛ hǝǝ, biatɛyi biǝnkǝ kalesɛ ebusiǝ kusɛɛ. ");
INSERT INTO lip_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Nya kolesiǝntu lǝ kofe lɛ boto nya kawunsiǝ ditsyiko bona tũũ, biatɛyi biǝnkǝ ɔsɔmi ǝbǝ bɔni. Bialɛ ola akafo bote kase kawunsiǝ luubǝ kǝtsyǝ lǝ binyǝ asɔmiloku eto ditsyǝbi. Fɛɛ beso biǝmbofo asa nnya luubǝ lǝ lefe nǝmǝ bote! ");
INSERT INTO lip_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Mi mmi eto betidi bua ba leesumu bǝfiǝ! Bela biǝ nyifo ayanisa nte mi lǝ binyǝ? Kulefe, membuyifo! Ayanisa nnya eto okle boote mi ete ni nnya díbǝ lǝ Yona ǝsuǝ.” Nyaso ótaka údu lǝ mǝ ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Se bakasebi bamǝ lɛyila ditumbukplɛ nǝmǝ bésu ni lekpake nǝ nsee, bǝnyǝ bǝ báta ǝsuǝ béntsyi dídisa saa bésuko. ");
INSERT INTO lip_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesu átɛyi mǝ nkǝ, “Bebe sinini lǝ Farisifɔ ku Sadukifɔ eto ǝyǝnkisǝsa nnya baakpe lǝ asa ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Mfó nya bétsyiko mǝ ǝsuǝ bɔtɔ bǝnkǝ, “Nnya bóentsyi didisa saa eso ɔnlɛ bɔtɛyi mmǝǝ.” ");
INSERT INTO lip_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesu áte lesa nǝ banlɛ bɔtɛyi, nyaso ɔ́tɔ mǝ nkǝ, “Beso bɛnlɛ bɔtɛyi lǝ mi nti itsyi lǝ didisa nǝmǝ bíentsyi eso ǝsuǝ? Mi bofokanɔ emfui! ");
INSERT INTO lip_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Nyaso biannɔ tɔ asa kasɔ? Biankloma tɔ lefe nǝ mínsie abolo anɔ míntǝ betidi akpi anɔ dídi bémi? Nya etsyitsya asia nnya wɛlɛwɛlɛ dibu díyi? ");
INSERT INTO lip_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Nya abolo akuanse nya mímfi míntǝ betidi akpi anaa, etsyitsya asia díyi se békpa nnya díbu? ");
INSERT INTO lip_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ntsyǝ ibǝ fɛ biannɔ kasɔ biǝ inni didisa ǝsuǝ míndi mi etiki mintsyiko? Bebe sinini lǝ Farisifɔ ku Sadukifɔ lǝ mǝ ǝyǝnkisǝsa ǝsuǝ!” ");
INSERT INTO lip_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Nyamfo ǝsuǝ fɛ bakasebi bamǝ lɛnɔ kasɔ bǝ inni ǝyǝnkisǝsa ǝsuǝ ɔnlɛ mǝ kɔlɛ bɔlɛ nɛ. Bomu lǝ asa nnya Farisifɔ ku Sadukifɔ laate ǝsuǝ ɔnlɛ. ");
INSERT INTO lip_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu ésu lekpake nǝ lɛfi Kaisarea Filipi eto umǝ. Mfó nya ɔ́tɔ wǝ bakasebi nkǝ, “Owoe betidi laatɛyi bǝ mɔ, Utidi Eto Ubi, ni?” ");
INSERT INTO lip_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Bǝtǝ mbuayɛ bǝnkǝ, “Bǝtsyuǝ bǝ fǝ ni Ntuflǝsǝtidi Yohanes. Bǝtsyuǝ tsya bǝ fǝ ni Elia, nya babamba tsya bǝ Yeremiya nye Onanto eto Unyɛlǝkǝtidi bamba utsyuǝ feni.” ");
INSERT INTO lip_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Mfó nya Yesu lɛtɔ mǝ nkǝ, “Nya mi nkpǝ? Owoe biatɛyi biǝ wǝ mini?” ");
INSERT INTO lip_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Petro ǝtǝ mbuayɛ nkǝ, “Fǝ ni Nwǝ Onanto Lékpo Ɔhile Utsyǝ. Fǝ ni Onanto wǝ nsi nkpǝ eto Ubi.” ");
INSERT INTO lip_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesu ǝtǝ mbuayɛ nkǝ, “Simon, Yona eto ubi, átɛyi nnya ɛlɛkɛ. Itsyise ɔnukualɛ ǝmfo mámbɔ utsyi lǝ utidinini saa eto kɛnyɛ. Bomu mɔ Anto wǝ nkpe katoo, wǝ dílǝkǝ nnya óte fǝ nɛ. ");
INSERT INTO lip_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nyaso nlɛ fǝ bɔtɛyi minkǝ fǝ Petro, fǝ diye ni leba. Nya leba nǝmfo ǝsuǝ mooto mɔ bafokanɔfɔ eto ditsyukpa nǝmǝ ńyǝnsǝ, nya ukpǝ eto ǝsuǝale kulaa tsya embutǝkǝ ni kato. ");
INSERT INTO lip_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Muufi Onanto eto sekakedikɔ eto kasafui ntǝ fǝ. Lesa saa nǝ fookle lǝ kasɔ mfoo, bookle ni kato. Nya lesa saa nǝ foonyankli lǝ kasɔ mfoo, boonyankli ni tsya kato.” ");
INSERT INTO lip_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Mfó nya Yesu lékpe wǝ bakasebi kɔfi nkǝ, “Biantɛyi kuutsyǝ saa biǝnkǝ mɔ ni Nwǝ Bákpo Ɔhile Bǝtsyǝ ǝmǝ.” ");
INSERT INTO lip_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Idu lǝ lefe nǝmfó ɛntɔɔ, Yesu étsyiko wǝ bakasebi etiki bɔtɛyi kakpasǝ wuee nkǝ, “Ele bǝ nsu Yerusalem lǝ nsu nyǝ kanyi lǝ beninǝ, besumunyǝ ninǝ ku lǝ afi eto bateasa eto ani. Boolo mɛ. Fɛɛ lǝ diyi tsyǝfǝ ǝsuǝǝ, Onanto ebotakasǝ mɛ utsyiko ɔkɔmǝ nsinkli mbǝ nkpǝ.” ");
INSERT INTO lip_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Petro ákpa wǝ úsuko lɛkpɔ, nya utsyiko buyǝnki kakpe wǝ katɛyi nkǝ, “Kulefe, Bonamute! Nyamfo eto okle okakaaka! Yǝmbǝ fǝ lǝ ǝsuǝ kulefe, kulefe!” ");
INSERT INTO lip_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yesu átsyi ɔ́wuninsǝ ɔ́tɛyi Petro nkǝ, “Obonsam, du mɛ lǝ ɔflɔ! Eyifo nwǝ eto eyifosa dińyǝ mɛ lǝ ǝsuǝ, itsyise fǝ nsusu bomfo menyifo Onanto eto nle, bomu utidinini eto nle.” ");
INSERT INTO lip_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Nya Yesu lɛtɛyi wǝ bakasebi nkǝ, “Lǝ utsyuǝ aala nkǝ wǝǝtǝkǝko mɛɛ, ele bǝ ɔni wǝ ǝsuǝ lǝ utsyi wǝ uyikabie utǝkǝko mɛ. ");
INSERT INTO lip_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Utsyuǝ saa wǝ laala nkǝ waata wǝ nkpǝ eto disii, woonyansǝ mu. Nya utsyuǝ saa wǝ loonyansǝ wǝ nkpǝ lǝ mɔ butǝkǝko ǝsuǝǝ, wuunyǝ mu. ");
INSERT INTO lip_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Nte kutǝkǝ ko utidi luunyǝ lǝ kawunsiǝ eto bikǝ kenke afiani wǝ bele nya ónyansǝ wǝ nkpǝ. Nye be utidi luufi oflomako bǝ lǝ unyǝ nkpǝ manlo? ");
INSERT INTO lip_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Itsyise Utidi Eto Ubi ebubǝ ku Onanto eto batɔnkpe lǝ Onanto eto diyǝnde ǝsuǝ, nya moofo utsyuǝ saa kayo lǝ keyifo ka úyifo ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nlɛ mi bɔtɛyi kakpasǝ wuee minkǝ, betidi bǝtsyuǝ kpe mi lenti mfo ba lembukpǝ isu ese lefe nǝ bǝnyǝ Utidi Eto Ubi dibǝ fe Oka.” ");
INSERT INTO lip_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Eyi akua kamaa, Yesu ákpa Petro ku Yakobo ku wǝ ɔyimi Yohanes mate úsuko kɔtini ko letaka eto disi kato. ");
INSERT INTO lip_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Se bǝńyǝ mfóo, bǝnyǝ bǝ Yesu eto ǝsuǝ áfloma. Wǝ ǝnǝmi lɛ buyǝnde fe kofe, nya awu nnya onkpe diflubi futututu ɛnlɛ boto lǝ ǝnǝmi. ");
INSERT INTO lip_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Mfó nya bakasebi itsyǝ bamǝ dínyǝ Moses ku Elia banlɛ etiki budi ku Yesu. ");
INSERT INTO lip_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Nya Petro lébesǝ ɔkɔɛ kato ɔ́tɛyi Yesu nkǝ, “Bonamute, ɛlɛkɛ tinti bǝ búbǝ mfo! Lǝ aalaa, mooto ebu ǝtsyǝ. Fǝ lɔni, Moses lɔni nya Elia tsya lɔni.” ");
INSERT INTO lip_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Se ɔnlɛ nyamfo bɔtɛyii, lɛsɔmiloku nǝ nlɛ buyǝnde ábɔ díti mǝ, nya bánɔ ɔkɔɛ lɛbɔ utsyi lɛsɔmiloku nǝmǝ kǝmiǝ nlɛ bɔtɛyi nkǝ, “Nyǝ mɔ Ubi lala, wǝ ǝsuǝ mǝǝnyǝ disuǝyuǝ. Bitsyue wǝ koto!” ");
INSERT INTO lip_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Se bakasebi itsyǝ bamfo lɛnɔ ɔkɔɛ ǝmfoo, sikpi ǝmuǝ mǝ tinti nya béfi ǝnǝmi béfusǝ kasɔ. ");
INSERT INTO lip_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yesu ésu mǝ ɔflɔ nya útidi mǝ ɔ́tɛyi nkǝ, “Betaka bińyǝ! Biante sikpi!” ");
INSERT INTO lip_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Se bátakasǝ ǝnǝmi bábe katoo, bǝnnyǝ kuutsyuǝ saa enso Yesu mate hã. ");
INSERT INTO lip_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Se banlɛ bɔyifǝ lǝ kɔtini komǝ kǝbǝ kasɔɔ, Yesu ǝkǝ mǝ ato nkǝ, “Biantɛyi kutsyuǝ saa lesa nǝ bínyǝ mfo isu ese lefe nǝ batakasǝ mɔ, Utidi Eto Ubi, betsyiko ɔkɔmǝ mimbǝ.” ");
INSERT INTO lip_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Mfó nya bakasebi bamǝ lɛtɔ Yesu bǝnkǝ, “Beso afi eto bateasa laatɛyi bǝnkǝ ele bǝ Elia ka bubǝ ɔtɔnsǝ?” ");
INSERT INTO lip_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesu ǝtǝ mbuayɛ nkǝ, “Sitinti ele bǝ Elia ka bubǝ ɔtɔnsǝ bǝ lǝ ɔlɔ lesa saa utsyǝ. ");
INSERT INTO lip_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Fɛɛ nlɛ mi bɔtɛyi minkǝ Elia ébubǝ koko, tsya bǝnyǝ wǝ bǝtsyǝ lekpo, nya béyifo wǝ disale nǝ kee bála. Nko ke booyifo mɔ, Utidi Eto Ubi tsya disiale nɛ.” ");
INSERT INTO lip_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Mfó bakasebi bamǝ léte bǝ Ntuflǝsǝtidi Yohanes ɔnlɛ. ");
INSERT INTO lip_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Lefe nǝ Yesu ku wǝ bakasebi díbǝ báyo sitiditu siamǝ ɔflɔ, osani utsyuǝ ǝbǝ óse akonki lǝ Yesu ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Nya ɔ́tɛyi wǝ nkǝ, “Bonamute, nyǝ mɔ ubisaibi ǝmfo kaminsǝ! Ɔlɛ budukanɔ eto bufi bufi nya ɔnlɛ kanyi bunyǝ tinti. Lefe kpǝ weedu kanɔ kedufǝ lǝ ute nye ntu ǝsuǝ tsya. ");
INSERT INTO lip_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nkpa wǝ mboko fǝ bakasebi ɔflɔ, fɛɛ bámfo wǝ botsya.” ");
INSERT INTO lip_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesu ǝtǝ mbuayɛ nkǝ, “Mii, mmi eto betidi, beso biamfo mɛ kanɔ nya bitidi ato mǝ? Nte lefe nǝ eto okle ele bǝ nkɛ mi lǝ ɔflɔ? Nte lefe nǝ eto lefe ele bǝ mfi nnǝ mi! Bekpa osaibi ǝmǝ beboko mɛ mfo!” ");
INSERT INTO lip_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Mfó Yesu léto ɔkɔɛ ókpe lɛwɔnɔ bua nǝ nlɛ dikpefi nǝmǝ bulǝ nya lɛbɔ wǝ lǝ ǝsuǝ! Nya bufi bomǝ díyuǝ wǝ lamfolamfo. ");
INSERT INTO lip_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kamaa, bakasebi bamǝ mate ǝbǝ Yesu ɔflɔ nya bátɔ wǝ bǝnkǝ, “Beso bóamfo lɛwɔnɔ bua nǝmǝ bola kǝlǝkǝ?” ");
INSERT INTO lip_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesu ǝtǝ mbuayɛ nkǝ, “Mi bofokanɔ mǝmmuǝ ale. Nlɛ mi bɔtɛyi sitinti minkǝ lǝ mi bofokanɔ te fenkǝ diyibibi nǝ nso bɔfɛ kenkee, ele bǝ ibǝ itǝ bǝ biofo kɔtini komfo bɔtɛyi biǝnkǝ, ‘Nyi mfo, esu mǝ!’ Nya yuubǝ itǝ. Kulesa ǝmbǝ biǝmbofo buyifo. ");
INSERT INTO lip_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Fɛɛ ɛyɛ lǝ olatoto ku kɛnyɛklekle ǝsuǝ hã fɛ biofo lɛwɔnɔ bua nǝmfo eto okle bola kǝlǝkǝ.” ");
INSERT INTO lip_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Lefe nǝ bakasebi bamǝ kenke díbǝ bátsya lǝ Galilea, Yesu átɛyi mǝ nkǝ, “Boofi Utidi Eto Ubi bakpe betidi lǝ ani, ");
INSERT INTO lip_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","nya boolo wǝ. Fɛɛ lǝ diyi tsyǝfǝ ǝsuǝǝ, Onanto ebotakasǝ wǝ utsyiko ɔkɔmǝ oboko nkpǝ.” Nyamfo álo bakasebi bamǝ ani. ");
INSERT INTO lip_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Lefe nǝ Yesu ku wǝ bakasebi díbǝ bédufǝ Kapernaum, Yudafɔ eto mba laafo Disumuyo eto oko ǝbǝ bátɔ Petro bǝnkǝ, “Mi oteasa tsya aafó Disumuyo eto oko ǝmǝ?” ");
INSERT INTO lip_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Petro ǝtǝ mbuayɛ nkǝ, “Ee, woafó.” Nya se Petro dísu údufǝ diyo, Yesu áka wǝ bɔtɔ nkǝ, “Simon, be ni fǝ nsusu? Bawoe eto ani ele bǝ bafo oko bǝtǝ kawunsiǝ eto baka? Bǝmǝnyǝ eto ani lee bafɔ?” ");
INSERT INTO lip_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petro ǝtǝ mbuayɛ nkǝ, “Bafɔ.” Yesu ǝtǝ mbuayɛ nkǝ, “Nyalɛ ete bǝ yanle bǝ bǝmǝnyǝ fo oko saa nɛ. ");
INSERT INTO lip_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Fɛɛ se boanla boǝ boata kuutsyuǝ saa bubu esoo, su ditumbukplɛ eto kɛnyɛ lǝ ata osakɛ. Lɛkpɛ tutɛ nǝ fuulǝkǝǝ, ebunyǝ atabi lǝ ni kɛnyɛ nnya looyo afo boofǝ eto oko ǝmǝ. Lǝkǝ nya, lǝ esu afo bokufǝ eto oko.” ");
INSERT INTO lip_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Lefe nǝmfóo, bakasebi bamǝ ǝbǝ Yesu ɔflɔ nya bátɔ wǝ bǝnkǝ, “Owoe ni ɔkplɛnyǝ kenke lǝ Onanto eto sekakedikɔ?” ");
INSERT INTO lip_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Lǝ nyasoo, Yesu ákpadi dikpefi kɛkɛ ditsyuǝ úbǝ úńyǝnsǝ lǝ mǝ nti. ");
INSERT INTO lip_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Nya ɔ́tɛyi nkǝ, “Nlɛ mi bɔtɛyi sitinti minkǝ, lǝ biamfloma mi ditsyǝbi biyifo fe bekpefii, biembudufǝ Onanto eto sekakedikɔ. ");
INSERT INTO lip_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Utidi wǝ ni ɔkplɛnyǝ kenke lǝ Onanto eto sekakedikɔɔ, wǝ ni utidi wǝ laabokosǝ wǝ ǝsuǝ kasɔ fe dikpefi nǝmfo eto okle. ");
INSERT INTO lip_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Nya utsyuǝ saa wǝ loofo bekpefi bamfo eto utsyuǝ lǝ mɔ disii, mɔɔ ini ófo. ");
INSERT INTO lip_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Fɛɛ lǝ utsyuǝ ebutǝ bekpefi ba léfo mɛ bánɔ mfo eto ɔni kplo lǝ onya kusu lǝ mɔ wǝ bofokanɔ ǝsuǝǝ, yɔɔlɛkɛ itǝ wǝ eso lǝ befi ukue batsyasǝ lǝ kukuǝ kplɛ bakpe wǝ lǝ simuǝ bato wǝ bakpe lǝ lekpo eto kaka letsyo, lǝ unǝ ntu ukpǝ. ");
INSERT INTO lip_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Mbɔbɔɛ itǝ kawunsiǝ kamfo eto asa nnya loofo butǝ utidi dufǝ lǝ lebua lǝ onya kusu! Asa nyamfo eto okle ebubǝ kokooko. Fɛɛ mbɔbɔɛ itǝ nwǝ ǝsuǝ nyamfo lɔɔyɛ ibǝ. ");
INSERT INTO lip_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Lǝ fǝ kɔni nye kokpa ǝǝtǝ feeyifo lebua, la ko ǝlǝkǝ ato akpe. Ɛlɛkɛ itǝ fǝ bǝ yɛ edufǝ lǝ nkpǝ kǝmiǝ kɔni kɔnwɛ nye kokpa kɔnwɛ enso bǝ yɛ ani ǝnuǝ nye akpa ǝnuǝ lǝ befi fǝ bato bakpe lǝ ditefɛnku manlo kǝmiǝ. ");
INSERT INTO lip_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Nya lǝ fǝ dinǝmi ǝǝtǝ feeyifo lebua, lǝkǝ ni ato akpe! Ɛlɛkɛ itǝ fǝ bǝ nyǝ nkpǝ ku dinǝmi lɛwɛ enso bǝ kɛ ǝnǝmi ǝnuǝ lǝ befi fǝ bato bakpe lǝ ditefɛnku manlo kǝmiǝ. ");
INSERT INTO lip_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Bebe kukɔnɔ biǝ biemfi ekpefi kɛkɛ bamfo eto kuutsyuǝ fe mba dimanle kulesa. Nlɛ mi bɔtɛyi sitinti minkǝ bakpe Onanto eto batɔnkpe kato ba lǝǝnyǝ lǝ mɔ Anto eto ǝnǝmi lefe saa lǝ mǝ kutsyǝ. ");
INSERT INTO lip_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Itsyise Utidi Eto Ubi ǝbǝ nkǝ lǝ ofo betidi ba lénya kusu lǝ nkpǝ. ");
INSERT INTO lip_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Lǝ utsyuǝ kpe basamu kolofa kɔni, nya ɔni lénya lǝ mǝ ntii, be bibu biǝ wuuyifo? Weemboyani awosi ɔwɔnɔmbǝ ɔwɔnɔmbǝ bamǝ utsyǝ lǝ kɔtini ǝsuǝ mfó bekedi, nya wuusu ɔbɛbɛ ɔni ǝme lénya? ");
INSERT INTO lip_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nya lǝ únyǝ wǝǝ, mɔtɛyi mi miǝ wuunyǝ disuǝyuǝ tinti lǝ wǝ ǝsuǝ enso awosi ɔwɔnɔmbǝ ɔwɔnɔmbǝ ba dímanya mfó ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Nko ke inte itǝ mi Anto wǝ nkpe kato nɛ, nkǝ woannla nkǝ bekpefi kɛkɛ bamfo eto kuutsyuǝ lǝ onya. ");
INSERT INTO lip_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Lǝ fǝ ɔyimitsyuǝ áta fǝ úbuu, su wǝ ɔflɔ, lǝ ǝlǝkǝ wǝ botakebu ate wǝ. Nya tǝ lǝ nyamfo lǝ ɛkɛ lǝ fonko wǝ eto nti ete. Lǝ ɔ́nɔ fǝ kasɔɔ, te fǝ esinkli eyifo lɔni ku fǝ ɔyimi nɛ. ");
INSERT INTO lip_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Fɛɛ lǝ wǝmbɔnɔ fǝ kasɔɔ, tǝ lǝ betidi inuǝ nye itsyǝ lǝ banɔ ko mi lǝ adansiɛ seka eso, fe kase Awɔnisa Kɛnkɛ eto Kukue lɛtɛyi. ");
INSERT INTO lip_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Nya lǝ mfó tsya ɔni woannɔ kasɔɔ, nyalɛ tǝ lǝ bafokanɔfɔ eto ditsyukpa nǝmǝ lǝ banɔ. Nya lǝ mfó tsya woannɔ kasɔɔ, lǝkǝ ato lǝ wǝ ǝsuǝ fe utidi wǝ lǝmbǝ bofokanɔ nye nwǝ laafo umǝnko. ");
INSERT INTO lip_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Nyaso nlɛ mimblɛ bɔtɛyi minkǝ lesa saa nǝ biokle lǝ kasɔ mfoo, bookle ni kato. Nya lesa saa ke bionyankli lǝ kasɔ mfoo, boonyakli ni kato tsya. ");
INSERT INTO lip_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Nya nsi nlɛ mi bɔtɛyi tsya minkǝ, lǝ mi inuǝ eto kɛnyɛ eyifo kani lǝ kasɔ mfo bɛnlɛ lesaatsyuǝ bɔtɔɔ, mɔ Anto wǝ nkpe kato ebuyifo ni utǝ mi. ");
INSERT INTO lip_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Itsyise kaka mi inuǝ nye itsyǝ letsya lǝ mɔ diye ǝsuǝǝ, nkpe mi lenti.” ");
INSERT INTO lip_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Nya Petro lɛnyi ɔ́fi Yesu nya ɔ́tɔ wǝ nkǝ, “Bonamute, lǝ mɔ ɔyimitsyuǝ ata mɛ ubuu, sesia ele bǝ mfi ntsyɛ wǝ? Sekuanse lee?” ");
INSERT INTO lip_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu ǝtǝ wǝ mbuayɛ nkǝ, “Inni sekuanse ete! Bomu awosi akuanse eto sekuanse. ");
INSERT INTO lip_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Itsyise Onanto eto sekakedikɔ te fe Oka wǝ lela nkǝ weebu nkunta ku wǝ beyifoyifo. ");
INSERT INTO lip_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Kase útsyǝ kasɔ koo, bákpa osani utsyuǝ wǝ nsi wǝ kayo kplɛ báboko wǝ ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Kulesa ente wǝ wuufi ofo kayo kamǝ esoo, oka ǝmǝ ǝtǝ nkǝ bate wǝ ku wuusiǝ ku wǝ bebi ku lesa saa nǝ nte wǝ lǝ befi bafo kayo kamǝ. ");
INSERT INTO lip_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Itǝ uyifoyifo ǝmfo áse akonki lǝ oka ǝmǝ ǝnǝmi ɔ́lɛ wǝ lekpakpa ɔ́tɛyi nkǝ, ‘Tsyǝ ǝsuǝ ko mɛ, moofo fǝ kayo kamǝ kenke.’ ");
INSERT INTO lip_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Wǝ asa ǝnǝ oka ǝmǝ kafo, nyaso úfi kayo kamǝ kenke ɔ́tsyɛ wǝ nya óyani wǝ údu. ");
INSERT INTO lip_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Nya se uyifoyifo ǝmfo díduu, ótsyako wǝ uyifotsyuǝ, wǝ dísiǝ wǝ sika flubia sɛkɛ eto kayo. Mfó nya úmuǝ wǝ lǝ ale ǝsuǝ lǝ simuǝ ku lɛkɔɛlonlobi ɔ́tɛyi wǝ nkǝ, ‘Fo mɛ kayo ka fensi mɛ!’ ");
INSERT INTO lip_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Wǝ uyifotsyuǝ ǝmǝ álɛ wǝ lekpakpa ɔ́tɛyi wǝ nkǝ, ‘Tsyǝ ǝsuǝ ko mɛ, moofo fɛ kayo ka kenke minsi fǝ!’ ");
INSERT INTO lip_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Fɛɛ ɔ́ni nya útǝ nkǝ beti wǝ bakpe lǝ Aba eto diyo isu ese lefe nǝ woofo kayo ka kenke unsi wǝ. ");
INSERT INTO lip_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Se wǝ beyifotsyuǝ dínyǝ lesa nǝ díbǝǝ, ílǝ mǝ tinti nya bésu bátɛyi Oka ǝmǝ lesa saa nǝ díbǝ. ");
INSERT INTO lip_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Nyaso ókpadi wǝ uyifoyifo ǝmǝ óboko wǝ ɔflɔ nya ɔ́tɛyi wǝ nkǝ, ‘Fǝ ndomunyǝ bua! Mfi fǝ kayo ka fensi mɛ kenke ntsyɛ fǝ itsyise álɛ mǝ lekpakpa eso. ");
INSERT INTO lip_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Kase mínyǝ fǝ kaminsǝǝ, nko ke ele bǝ eni fintsya nyǝ fǝ ɔyimitsyuǝ uyifoyifo kaminsǝ nɛ.’ ");
INSERT INTO lip_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Kafo ányi Oka ǝmǝ tinti nya útǝ nkǝ bǝnǝ wǝ koto bakpe wǝ lǝ diyo isu ese lefe nǝ woofo kayo kamǝ kenke olosǝ.” ");
INSERT INTO lip_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Mfó Yesu lélosǝ nkǝ, “Nko ke mɔ Anto wǝ nkpe kato luuyifo utsyuǝ saa lǝ mi nti wǝ lembufi ɔtsyɛ wǝ ɔyimitsyuǝ itsyi taa wǝ lɛkɔɛsi ke nɛ.” ");
INSERT INTO lip_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Se Yesu lɛtɛyi asa nyamfo ólosǝǝ, údu lǝ Galilea úsu Yudea eto lɛkpɔ nǝ nkpe lǝ Yordan eto ketu eto lekpake nǝ nse. ");
INSERT INTO lip_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Betidi kpǝ ǝtǝkǝko wǝ nya ótsya mǝ efimbi, efimbi mfó. ");
INSERT INTO lip_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Mfó nya Farisifɔ bǝtsyuǝ díbǝ wǝ ɔflɔ bǝ baato wǝ babe, nya bátɔ wǝ bǝnkǝ, “Bo kɔfi ǝtǝ kusu nkǝ osani ni wǝ usiǝ lǝ kusu saa ola ǝsuǝ?” ");
INSERT INTO lip_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesu ǝtǝ mbuayɛ nkǝ, “Biankla tɔ lǝ Awɔnisa Kɛnkɛ bǝ taa ketsyikokɔɔ, nwǝ díyifo kawunsiǝǝ, usio ku osani úyifo betidi? ");
INSERT INTO lip_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Nya Onanto lɛtɛyi nkǝ, ‘Lǝ nyamfo eso osani luudu lǝ wǝ anto ku ambe utsyǝ nya wuufi kusiǝ, nya mǝ inuǝ bamǝ loofiani utidi ɔni.’ ");
INSERT INTO lip_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Itsyise lǝ nnya kamaa, bensiyifo betidi inuǝ. Bomu bafiani utidi ɔni. Nyaso yanle bǝ utidi sense lesa nǝ Onanto dífi ɔ́kɔ lǝ bǝtsyuǝ.” ");
INSERT INTO lip_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Farisifɔ bamǝ átɔ wǝ bǝnkǝ, “Nyalɛ beso Moses dítǝ kusu nkǝ ele bǝ osani tǝ wǝ usiǝ kukue nkǝ ɔlɛ wǝ bɔni fɛ lǝ ɔni wǝ?” ");
INSERT INTO lip_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesu ǝtǝ mbuayɛ nkǝ, “Mi letotidi eso Moses dítǝ kusu nkǝ bɛni bese ku bǝsiǝ nɛ. Yɛntsyǝ nko lǝ kasɔ ketsyikokɔ. ");
INSERT INTO lip_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nyaso nlɛ mi bɔtɛyi minkǝ osani wǝ ke lɛni wǝ usiǝ, nya inni lǝ disenkpo eso nya úsu úfi usio bambaa, ókpo kusiǝ.” ");
INSERT INTO lip_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Wǝ bakasebi átɛyi wǝ bǝnkǝ, “Lǝ nko usǝ ku usiǝ eto nti eto etiki ntee, nyalɛ ɛlɛkɛ eso lǝ bemfi kusiǝ nye bǝnsiǝ kusǝ.” ");
INSERT INTO lip_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesu átɛyi mǝ nkǝ, “Inni utsyuǝ saa loofo asatete nyamfo bofo nko, enso mba Onanto dítǝ nnya nko hã. ");
INSERT INTO lip_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Esu kpǝ kpe nyaso betidi leemfi bǝsiǝ. Bǝtsyuǝ nko bále mǝ nɛ. Bǝtsyuǝǝ, betidi díyifo mǝ nko. Bǝtsyuǝ tsya emfi bǝsiǝ itsyise bala bǝ beefi mǝ ǝsuǝ bǝtǝ Onanto eto sekakedikɔ eto keyifo. Nwǝ loofo wǝ ǝsuǝ bufi kǝtǝ asatete nyamfoo, tǝ lǝ uyifo nko.” ");
INSERT INTO lip_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Betidi bǝtsyuǝ ákpa bekpefi báboko Yesu ɔflɔ bǝ lǝ ufi ani utǝkǝ lǝ mǝ, lǝ oto ola utǝ mǝ, fɛɛ wǝ bakasebi ényenki bákpe betidi bamǝ. ");
INSERT INTO lip_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Mfó nya Yesu lɛtɛyi wǝ bakasebi bamǝ nkǝ, “Bitǝ bekpefi kusu lǝ bǝbǝ mɛ ɔflɔ, nya bienti mǝ kusu, itsyise Onanto eto sekakedikɔ eyifo fǝ mba laabokosǝ ǝsuǝ kasɔ fe ekpefi bamfo eto okle eto kale.” ");
INSERT INTO lip_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Nya Yesu dífi wǝ ani útǝkǝ lǝ mǝ ókpo mǝ atsyɔ, nya údu lǝ mǝ ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Osani utsyuǝ ǝbǝ Yesu ɔflɔ diyi lɔni nya ɔ́tɔ wǝ nkǝ, “Oteasa, nte lesa sɛɛ nǝ ele bǝ nyifo fɛ lǝ nnyǝ nkpǝ manlo?” ");
INSERT INTO lip_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Mfó Yesu dítǝ wǝ mbuayɛ nkǝ, “Beso fanlɛ mɛ kasɛɛ ka ele bǝ beyifo bɔtɔ? Utidi ɔni hã nkpe wǝ ni ɔsɛɛ. Lǝ ala fǝ ǝǝnyǝ nkpǝ manloo, yɛ lǝ Onanto eto afi nyamǝ ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ɔ́tɔ nkǝ, “Nte afi nnya?” Yesu átɛyi wǝ nkǝ, “Manlo utidi, mendi sɛsɔnɔ, menyu, manla fuutsyuǝ kɛnyɛ, ");
INSERT INTO lip_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","bu fǝ anto ku fǝ ambe, nya lǝ ala fǝ ɔyimitsyuǝ fe kase faala fǝ ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Mfó nya okosobi ǝmfo dítǝ mbuayɛ nkǝ, “Mbuyifo lǝ afi nyamfo kenke ǝsuǝ. Be disi ibu bǝ nyifo?” ");
INSERT INTO lip_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu átɛyi wǝ nkǝ, “Lǝ aala fǝ aaflɔɔ, su lǝ esu efi fǝ lesa saa nǝ nte fǝ ate. Nya lǝ efi atabi nnya fǝnyǝ esu ǝtǝ bakombo, nya fuunyǝ bikǝ ǝtsyǝ kato nɛ. Nyamfo eto kamaa, sinkli ǝbǝ ǝtǝkǝko mɛ.” ");
INSERT INTO lip_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Fɛɛ se okosobi ǝmǝ lɛnɔ nyamfoo, údu ku bulǝ lǝ lɛkɔɛsi. Itsyise bikǝ kpǝ akɛ wǝ. ");
INSERT INTO lip_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Mfó nya Yesu lɛtɛyi wǝ bakasebi nkǝ, “Nlɛ mi bɔtɛyi kakpasǝ wuee minkǝ, yɔɔkɛ ale itǝ batabinyǝ bǝ bedufǝ Onanto eto sekakedikɔ. ");
INSERT INTO lip_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nsi nlɛ bɔtɛyi bio minkǝ, iyuǝ itǝ ɔtɔmini ku lekoko bǝ ɔyɛ lǝ okabikǝ eto ofo ofe enso bǝ otabinyǝ dufǝ lǝ Onanto eto sekakedikɔ.” ");
INSERT INTO lip_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Lefe nǝ bakasebi bamǝ lɛnɔ nyamfoo, íyifo mǝ yanii, nyaso bátɔ bǝnkǝ, “Nyalɛ owoe ko luunyǝ nkpǝ manlo?” ");
INSERT INTO lip_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesu ábe mǝ tũũ nya ɔ́tɛyi mǝ nkǝ, “Kawunsiǝ eto utidi saa ǝmbofo nyamfo buyifo. Fɛɛ Onanto, wǝ ebofo lesa saa buyifo.” ");
INSERT INTO lip_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Mfó nya Petro lɛtɛyi wǝ nkǝ, “Bee! Bóayani lesa saa bútsyǝ bǝ lǝ butǝkǝko fǝ. Be bo luunyǝ?” ");
INSERT INTO lip_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu átɛyi mǝ nkǝ, “Nlɛ mi bɔtɛyi sitinti minkǝ, lefe nǝ mɔ, Utidi Eto Ubi, luubǝ lǝ mɔ diyǝnde ǝsuǝ mbǝ nsiǝ lǝ mɔ lekankpomɛ ǝsuǝ lǝ kawunsiǝ fɔfɔ kamǝǝ, mi lefosi inuǝ ba dítǝkǝko mɛ tsya ebusiǝ lǝ akankpomɛ ǝsuǝ bǝ lǝ bekponko Israel bebi eto lefosi mmfo nnuǝ bomǝ lekpo. ");
INSERT INTO lip_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Nyaso utsyuǝ saa wǝ léyani diyo nye bayimisani nye bayimisio nye anto nye ambe nye bebi nye kakuɛ utsyǝ nkǝ lǝ utǝkǝko mɛ esoo, ebunyǝ nnya kayofofo kolofa ku kama. Nya Onanto ebutǝ wǝ nkpǝ bo lǝmbɔkɛ kalosǝkɔ. ");
INSERT INTO lip_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Fɛɛ betidi kpǝ ba ntɔ sɛtɔ mɔmɔɔ, ebubǝ bafe kama. Nya mba ntǝkǝ kama mɔmɔɔ, ebubǝ bafe batɔ sɛtɔ. ");
INSERT INTO lip_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Onanto eto sekakedikɔ ale eyibibi eto ɔkuɛmfo utsyuǝ wǝ létaka ku olesiǝtu nkǝ weesu ɔbɛbɛ diyi eto beyifoyifo bǝtsyuǝ lǝ beyifo keyifo bǝtǝ wǝ lǝ ɔkuɛ. ");
INSERT INTO lip_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ɔkuɛmfo ǝmǝ ku beyifoyifo bamǝ átɔnɔ lǝ diyi eto keyifo eto kayofofo ǝsuǝ, ini sika flubia sɔni eto atabi, nya bédu bésu eyibibi eto ɔkuɛ ǝmǝ. ");
INSERT INTO lip_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Se ɛsɔ abombo ɔwɔnɔmbǝǝ, osani ǝmǝ esi úsu asi nya únyǝ se basani bǝtsyuǝ ńyǝ mfó banlɛ kulesa buyifo. ");
INSERT INTO lip_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Nyaso ɔ́tɛyi mǝ nkǝ, ‘Mi tsya su biyifo keyifo lǝ mɔ eyibibi eto ɔkuɛ lǝ mfo mi kayo ka dińyǝ itǝ.’ ");
INSERT INTO lip_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Nyaso bésu ɔkuɛ ǝmǝ. “Nya lǝ lefosi abombo ǝnuǝ ku lǝ kakɔmi eto abombo ǝtsyǝ eto lefee, usi úyifo nko ke. ");
INSERT INTO lip_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Se ibu sɛkɛ lǝ abombo anɔ lǝ ɛsɔɔ, usi úsu asi mfó nya únyǝ betidi bǝtsyuǝ nsi ńyǝ mfó. Ɔ́tɔ mǝ nkǝ, ‘Beso binyǝ mfo diyi wɔlɔlɔlɔ bɛnlɛ diyi bobiasǝ keyifo menyifo menyifo?’ ");
INSERT INTO lip_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Bǝtǝ wǝ mbuayɛ bǝnkǝ, ‘Kuutsyuǝ saa mǝntǝ bo keyifo nkǝ buyifo.’ “Nyaso ɔ́tɛyi mǝ nkǝ, ‘Nyalɛ, mi tsya su mɔ eyibibi eto ɔkuɛ bisu biyifo keyifo.’ ");
INSERT INTO lip_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Se ditsyitsyo lefe léyoo, ɔkuɛnsate ǝmǝ átɛyi beyifoyifo eto uninǝ nkǝ, ‘Kpadi beyifoyifo bamǝ lǝ afo mǝ kayo, tsyiko lǝ mba díbǝ fɛfɛ ǝsuǝ, lǝ esu alosǝ lǝ mba leka bubǝ ǝsuǝ.’ ");
INSERT INTO lip_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Báfo betidi ba díbǝ keyifo ku ditsyitsyo eto abombo anɔ eto utsyuǝ saa sika flubia sɔni sɔni. ");
INSERT INTO lip_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Nya se éyo mba leka keyifo bubǝ ku olesiǝǝ, bébu bǝ boofo mǝ kayo baso mǝ bǝtsyuǝ. Fɛɛ mǝ tsya eto utsyuǝ saa áfo diyi eto kayofofo kani kamǝ, ini sika flubia sɔni. ");
INSERT INTO lip_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Se báfo atabi nyamǝǝ, betsyiko bunyenki kakpe ɔkuɛnsate ǝmǝ bǝnkǝ, ");
INSERT INTO lip_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Betidi fɛfɛ ba báfo éyifo keyifo lebombosɔsɔ lɔni hã, nya bomba mfo díńyǝ lǝ kofe buyifo keyifo diyi wɔlɔlɔlɔ tsyaa, kayofofo kani ete bǝtǝ bo!’ ");
INSERT INTO lip_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Mfó ɔkuɛnsate ǝmǝ lɛtɛyi mǝ ɔni nkǝ, ‘Ɔyimitsyuǝ, nɔ. Mántafa fǝ. Lee, inni diyi lɔni eto keyifo eto kayofofo ka ni sika flubia sɔni ǝsuǝ bókpe asi? ");
INSERT INTO lip_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Nyaso fo fǝ kayofofo lǝ edu esu diyo. Iyifo mɔ lelabi miǝ mǝǝtǝ utidi fɛfɛ ǝmfo kayofofo fe kase mínkǝtǝ fǝ ke. ");
INSERT INTO lip_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Lee, mimbǝ kusu meeyifo ku mɔ atabi kase maala? Lee, mɔ kafoɛkpɛ ka meeyifo nlɛ fǝ ǝnǝmi bɔsɛ?’ ” ");
INSERT INTO lip_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Nyaso Yesu álosǝ ɔtɛyi nkǝ, “Betidi ba ni bafɛfɛ ebofiani betutɛ nya mba ni betutɛ loofiani bafɛfɛ.” ");
INSERT INTO lip_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Se Yesu ku wǝ bakasebi lefosi inuǝ bamǝ lɛyɛ bantɔ lǝ Yerusalem, ókpa mǝ úsuko lɛkpɔ nya ɔ́tɛyi mǝ nkǝ, ");
INSERT INTO lip_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Bɛnɔ, bɔtɔ lǝ Yerusalem kaka boomuǝ Utidi Eto Ubi bakpe lǝ besumunyǝ ninǝ ku afi eto bateasa eto ani. Nya boolo wǝ dikpǝnkpi. ");
INSERT INTO lip_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Nya boofi wǝ bakpe lǝ mba lenni Yudafɔ eto ani bǝ bakpe wǝ kofani, bablɛ wǝ, basɔ wǝ bamanklasǝ lǝ uyikabie ǝsuǝ bǝ lǝ ukpǝ. Fɛɛ lǝ diyi tsyǝfǝ ǝsuǝǝ, Onanto ebotakasǝ wǝ utsyiko ɔkɔmǝ ubǝ nkpǝ.” ");
INSERT INTO lip_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Nya Sebedeo eto usiǝ lékpa wǝ bebi inuǝ óboko nya base akonki lǝ Yesu ɔflɔ nya ɔ́lɛ wǝ lekpakpa nkǝ ɔwunsǝko mǝ. ");
INSERT INTO lip_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Nya Yesu lɛtɔ wǝ nkǝ, “Be fanlɛ bɔbɛbɛ?” Mfó usio ǝmǝ dítǝ mbuayɛ nkǝ, “Tsyǝ mɛ kɛnyɛ fǝnkǝ lǝ edufǝ lǝ fǝ sekakedikɔɔ, ebusiǝsǝ mɔ bebisaibi inuǝ bamfo, ɔni lǝ fǝ kodiani nya unuǝfǝ lǝ fǝ kǝmǝni.” ");
INSERT INTO lip_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesu átɛyi mǝ nkǝ, “Biante lesa nǝ bɛnlɛ bɔtɔ. Kanyi ka mǝǝbǝ bunyǝǝ, mi tsya ebofo ke butsyi?” Bǝtǝ mbuayɛ bǝnkǝ, “Ee, boofo.” ");
INSERT INTO lip_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Mfó Yesu lɛtɛyi mǝ nkǝ, “Sitinti, biofo butsyi. Fɛɛ mimbǝ kusu mǝǝlǝkǝ futsyǝ luusiǝ lǝ mɔ kodiani nye kǝmǝni. Nsiǝkɔ bomfo te ítǝ betidi ba mɔ Anto lɛlɔ utsyǝ itǝ mǝ.” ");
INSERT INTO lip_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Lefe nǝ bakasebi lefosi fɛfɛ lɛnɔ bayimi inuǝ bamfo eto etiki nyamfoo, kafo ányi mǝ tinti! ");
INSERT INTO lip_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Nyaso Yesu ákpadi mǝ ɔkɔ nya ɔ́tɛyi mǝ nkǝ, “Biyi biǝ betidi ba lenni Yudafɔ eto baka kpe ǝsuǝale kenke lǝ mǝ betidi ǝsuǝ nya mǝ batɔnkotɔnko tsya nkpe ǝsuǝale kekleke lǝ mǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Fɛɛ inni nko ele bǝ itsyǝ lǝ mimba lefo bɛnɔ nti. Lǝ utsyuǝ lǝ mi nti aala nkǝ weeyifo ɔkplɛnyǝ, ele bǝ uyifo uyifoyifo utǝ bafɛfɛ. ");
INSERT INTO lip_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Nyaso lǝ utsyuǝ lǝ mi nti aala nkǝ weeyifo ututɛɛ, ele bǝ uyifo wǝ ǝsuǝ uyifoyifo utǝ bafɛfɛ kenke. ");
INSERT INTO lip_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Nko ke ini nɛ bǝ mɔ, Utidi Eto Ubi, mǝmbǝ miǝ besumu mɛ. Bomu bǝ lǝ nsumu nya lǝ mfi mɔ nkpǝ ntǝ lǝ betidi kpǝ eto disi.” ");
INSERT INTO lip_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Kase Yesu ku wǝ bakasebi nlɛ budu lǝ Yeriko eto umǝ, betidi kpǝ ǝtǝkǝko mǝ. ");
INSERT INTO lip_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Bǝnǝmba inuǝ ba nsi lǝ kusu ɔflɔɔ, ánɔ bǝ Yesu ǝbǝ ɔlɛ bofe, nyaso bétsyiko bofa katɛyi bǝnkǝ, “Bonamute, Oka David eto ubi! Nnyǝ bo kaminsǝ!” ");
INSERT INTO lip_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Betidi bamǝ átɛyi bǝnǝmba bamǝ bǝnkǝ bedika. Fɛɛ mfe bomu báfa bembembe enso bátɛyi bǝnkǝ, “Bonamute, Oka David eto ubi! Nyǝ bo kaminsǝ!” ");
INSERT INTO lip_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesu ǝkǝnǝ únyǝ nya ókpadi mǝ nkǝ bǝbǝ nya ɔ́tɔ mǝ nkǝ, “Be bela biǝ nyimfo ntǝ mi?” ");
INSERT INTO lip_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Mfó bǝtǝ mbuayɛ bǝnkǝ, “Anto, bola boǝ tǝ lǝ bunyǝ asa.” ");
INSERT INTO lip_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Mǝ asa ǝnǝ Yesu kafo nya utidi mǝ ǝnǝmi. Lamfolamfo, mǝ ǝnǝmi ásini nya bǝnyǝ asa, nya bǝtǝkǝko wǝ. ");
INSERT INTO lip_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Se Yesu ku wǝ bakasebi lɛnyi bafi Yerusalem nya bédufǝ Betfage lǝ Nnuǝbi eto Eyi eto Kɔtini ǝsuǝǝ, Yesu ála wǝ bakasebi inuǝ ɔ́tɔnsǝ. ");
INSERT INTO lip_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Nya ɔ́tɛyi mǝ nkǝ, “Bikatɔ lǝ kebuto ka nkpe sɛtɔ mfó. Mfóo, biunyǝ ɔflimu wǝ nńyǝ lǝ ukuǝ nya wǝ ubi nńyǝ wǝ lǝ akɔ. Nyankli wǝ ku ukuǝ lǝ akpa mǝ aboko mɛ. ");
INSERT INTO lip_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Nya lǝ utsyuǝ átɔ mi lesaatsyuǝǝ, bɛtɛyi wǝ biǝnkǝ, ‘Bonamute lɛ mǝ bohiã.’ Ete booyani mǝ lamfolamfo bǝtǝ mi.” ");
INSERT INTO lip_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Nyamfo ǝbǝ itǝ fe kase Onanto eto unyɛlǝkǝtidi utsyuǝ lɛtɛyi utsyǝ nkǝ, ");
INSERT INTO lip_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Bɛtɛyi Sion eto umǝnkplɛ eto betidi biǝnkǝ, ‘Bebe, mi Oka lɛ mi ɔflɔ bubǝ! Obokosǝ ǝsuǝ kasɔ nya unsi lǝ ɔflimu ku ubi ǝsuǝ ɔnlɛ bubǝ.’ ” ");
INSERT INTO lip_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Nyaso bakasebi inuǝ bamfó ésu nya béyifo fe kase Yesu lékpe mǝ nkǝ beyifo. ");
INSERT INTO lip_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Bákpa ɔflimu ku ubi ǝmǝ báboko, nya béfi mǝ mfia bésensǝ bákpo lǝ mǝ ǝsuǝ nya Yesu lébe úsiǝ lǝ mǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Betidi bǝtsyuǝ lɛ keyudu boto. Nya bǝtsyuǝ tsya léla sekabe ku keyilɛ bésensǝ bákpo lǝ kusu. ");
INSERT INTO lip_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Nya betidi ba ntɔ ku mba ntǝkǝ kenke nlɛ bofa katɛyi bǝnkǝ, “Yuu, yuuduu, itǝ Oka David eto ubi wǝ nlɛ bubǝ o-o! Atɛsǝ itǝ nwǝ nlɛ bubǝ lǝ Bonamute eto diye usuǝ! Yuu, yuuduu itǝ Onanto!” ");
INSERT INTO lip_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Lefe nǝ Yesu dídufǝ Yerusalem, umǝ ǝmǝ kenke ko dítinkǝ. Nya betidi lɛtɔ bǝnkǝ, “Owoe uni?” ");
INSERT INTO lip_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Betidi bǝtsyuǝ ǝtǝ mbuayɛ bǝnkǝ, “Nwǝ mfo ni Onanto eto Unyɛlǝkǝtidi Yesu wǝ dítsyi Nasaret lǝ Galilea eto kasɔ nɛ!” ");
INSERT INTO lip_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu ésu údufǝ Disumuyo Kplɛ nya óla betidi ba kenke nlɛ bikǝ bote ku booya mfó úlǝkǝ lǝ diyo nǝmǝ. Úkǝ kapunu ka betidi nlɛ atabi bofloma ku mba laate ablonima eto akpomɛ uwui. ");
INSERT INTO lip_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Nya ɔ́tɛyi mǝ nkǝ, “Báwɔni bákpe lǝ Awɔnisa Kɛnkɛ eto Kukue bǝ Onanto átɛyi nkǝ, ‘Bookpo mɔ diyo nkǝ, ola katokɔ.’ Fɛɛ mi efi ni bíyifo beyu eto kabiɔkɔ!” ");
INSERT INTO lip_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Nya bǝnǝmba ku abafa díbǝ wǝ ɔflɔ lǝ Disumuyo mfó nya Yesu létsya mǝ bufi. ");
INSERT INTO lip_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Se besumunyǝ ninǝ ku afi eto bateasa dínyǝ ayanisa nya Yesu nlɛ buyifo ku bekpefi ba nlɛ kudu bokpo katɛyi bǝnkǝ, “Atɛsǝ itǝ Oka David eto ubi,” lǝ Disumuyo mfóo, kafo ányi mǝ tinti. ");
INSERT INTO lip_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Nyaso bátɔ Yesu bǝnkǝ, “Alɛ lesa nǝ bekpefi bamǝ nlɛ bɔtɛyi mfó bɔnɔ?” Nya Yesu dítǝ mbuayɛ nkǝ, “Nlɛ bɔnɔ. Nya nyi tsya minkǝ békla nyamfo lǝ Awɔnisa Kɛnkɛ eto Kukue bǝ, ‘Ǝtǝ bekpefi ku bebisambi fǝ befi atɛsǝ nnya lɛflɔ tinti bǝtǝ fǝ.’ ” ");
INSERT INTO lip_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Lǝ nyamfo eto kamaa, Yesu édu lǝ besumunyǝ ninǝ ku afi eto bateasa bamfó ɔflɔ nya úsu údufǝ Betania eto umǝ kaka úsu ólabe. ");
INSERT INTO lip_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Se kale dísiǝ nya se úsinkli ɔnlɛ umǝ bubǝ ku olesiǝǝ, kukpǝnsɛ álɛ wǝ. ");
INSERT INTO lip_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Únyǝ kudiyi kutsyuǝ lǝ kusu ɔflɔ mfó nya ɔ́tsyi úsu ko ɔflɔ. Fɛɛ wǝnnyǝ kulesa lǝ ko enso ko afanto. Nyaso ɔ́tɛyi kuyi komǝ nkǝ, “Ensiembɔnwɔ ebibi kulefe tsya.” Lamfolamfo kudiyi komǝ áblobe. ");
INSERT INTO lip_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Se bakasebi bamǝ dínyǝ nkoo, éyifo mǝ yanii. Nya bátɔ bǝnkǝ, “Be dítǝ bǝ kudiyi komfo léblobe nko mmǝ?” ");
INSERT INTO lip_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesu ǝtǝ mbuayɛ nkǝ, “Sitinti minlɛ mi bɔtɛyi minkǝ lǝ bekpe bofokanɔ bo lǝmbǝ kayakii, biofo nnya mínyifo kudiyi komfo buyifo. Fɛɛ inni nyamfo mate. Bomu biofo kɔtini komfo bɔtɛyi biǝ, ‘Nyi lǝ mfo esu edufǝ lǝ lekpo kafo,’ nya yuubǝ itǝ nko. ");
INSERT INTO lip_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nya lesa saa nǝ biɔtɔ Onanto lǝ olatoto ǝsuǝ lǝ bofokanɔ ǝsuǝǝ, biunyǝ ni.” ");
INSERT INTO lip_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Se Yesu dísinkli úbǝ Disumuyo Kplɛ mfó nya ɔnlɛ asa botee, besumunyǝ ninǝ ku Yudafɔ eto beninǝ bamǝ ǝbǝ bátɔ wǝ bǝnkǝ, “Nte ǝsuǝale nnya fankpe feeyifo asa nyamfo eto okle? Nya owoe dítǝ fǝ ǝsuǝale nyamfo?” ");
INSERT INTO lip_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Mfó nya Yesu dítǝ mǝ mbuayɛ nkǝ, “Mintsya mɔɔtɔ mi ditiki lɔni hã nnɔ. Nya lǝ bitǝ mɛ mbuayɛɛ, mɔɔtɛyi mi ǝsuǝale nnya minkpe meeyifo asa nyamfo eto okle. ");
INSERT INTO lip_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Owoe ɔflɔ Yohanes léfo ǝsuǝale fɛ úflǝsǝ betidi ntuu? Onanto ɔflɔ lee, nye lǝ utidi ɔflɔ?” Mfó bétsyiko mǝ ǝsuǝ bɔtɔ kanɔ bǝ, “Be ele bǝ bɔtɛyi? Lǝ bɔtɛyi boǝ Onanto ɔflɔɔ, wɔɔtɔ bo nkǝ, ‘Nyalɛ beso biamfo Yohanes bɛnɔ?’ ");
INSERT INTO lip_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Fɛɛ lǝ bɔtɛyi boǝ utidi ɔflɔɔ, bɔlɛ sikpi bote lesa nǝ betidi luuyifo, itsyise mǝmblɛ áfo bánɔ bǝ Yohanes eyifo Onanto eto unyɛlǝkǝtidi.” ");
INSERT INTO lip_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Nyaso bǝtǝ Yesu mbuayɛ bǝnkǝ, “Bunyi kaka ófo ǝsuǝale utsyiko.” Nya ɔ́tɛyi mǝ nkǝ, “Nko ke mintsya lɛmbɔtɛyi mi kaka mímfo ǝsuǝale mintsyiko fɛ meeyifo asa nyamfo eto okle nɛ.” ");
INSERT INTO lip_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Ntsyǝ bibu itsyi lǝ ditiki nǝmfo ǝsuǝ? Utidi utsyuǝ ákɛ wǝ lɛkɛ bebisaibi inuǝ. Ɔ́tɛyi uninǝle nkǝ, ‘Ubi, su eyifo keyifo lǝ mɔ eyibibi eto ɔkuɛ mmi.’ ");
INSERT INTO lip_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Útǝ mbuayɛ nkǝ, ‘Mǝmbǝ busu.’ Fɛɛ kamaa, ɔ́tsyi wǝ nsusu ɔ́wuninsǝ nya úsu. ");
INSERT INTO lip_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Anto ǝmǝ ésu wǝ ubi nuǝfǝ ɔflɔ nya ɔ́tɛyi wǝ nko ke. Wǝ átɔnɔ nkǝ, ‘Yo o-o, nto, muusu.’ Fɛɛ wénsu. ");
INSERT INTO lip_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Mǝ inuǝ bamǝ eto ntii, mǝ owoe díyifo lǝ mǝ anto eto lelabi ǝsuǝ?” Bǝtǝ mbuayɛ bǝnkǝ, “Uninǝle ǝmǝ.” Nyaso Yesu átɛyi mǝ nkǝ, “Nlɛ mi bɔtɛyi kakpasǝ minkǝ beyu ku basɔnɔdi lɛ mi bofe kaaka mi Onanto eto sekakedikɔ budufǝ. ");
INSERT INTO lip_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Itsyise Ntuflǝsǝtidi Yohanes ǝbǝ mi ɔflɔ nkǝ wǝǝbǝ ote mi kusu sɛɛ ko biɔyɛ, fɛɛ bíamfo wǝ bɛnɔ. Fɛɛ beyu ku basɔnɔdi bomu áfo wǝ bánɔ. Nya se bínyǝ nyamfo bítsyǝ lekpo tsyaa, bíamfloma mi nsusu biǝ biafo wǝ bɛnɔ. ");
INSERT INTO lip_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Bɛnɔ lekpa bamba nǝmfo. Ɔkuɛmfo utsyuǝ ǝsiǝ wǝ léfo eyibibi eto ɔkuɛ, nya ókpe ɔkpɔ otsyilama wǝ. Óto kaka beeke eyibibi eto nte kǝlǝkǝ nya óto nwǝ laase ɔkuɛ ǝmǝ eto kǝsiǝkɔ. Nya úfi ɔkuɛ ǝmǝ ókpe beyifoyifo bǝtsyuǝ lǝ ani nkǝ bakase wǝ, nya údu úsu kusu. ");
INSERT INTO lip_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Se lefe léyo bǝ balɛ eyibibi nyamǝǝ, ɔkuɛnsate ǝmfo ákpe wǝ ndomufɔ nkǝ besu bafo wǝ kedikɔ baboko wǝ. ");
INSERT INTO lip_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Ɔkuɛmfo eto beyifoyifo bamfo ǝmuǝ wǝ ndomufɔ bamfo nya báblɛ ɔni, bálo ɔni, nya bákpɔ ɔni tsya aba. ");
INSERT INTO lip_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Nyamfo eto kamaa, osate ǝmǝ esi ótsyese ndomufɔ bamba ba nso mba kɔ utu. Nya beyifoyifo bamǝ disi béyifo mǝ tsya nko ke. ");
INSERT INTO lip_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Kalosǝkɔɔ, óla wǝ kosate eto ubi ótsyese mǝ. Nya ɔ́tɛyi nkǝ, ‘Mfo nnɔ miǝ boobu mɔ ubi babe.’ ");
INSERT INTO lip_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Fɛɛ se beyifoyifo bamǝ dínyǝ wǝ ubi ǝmfoo, bátɛyi mǝ ǝsuǝ bǝnkǝ, ‘Nnyǝ ɔkuɛmfo eto ubi wǝ lǝǝkǝ bikǝ biamǝ budii. Bibǝ lǝ bolo wǝ lǝ bɔlɛ wǝ kedikɔ bofo.’ ");
INSERT INTO lip_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Nyaso bǝmuǝ wǝ nya báto wǝ bakpe lǝ ɔkpɔ ǝmǝ eto kama, nya bálo wǝ.” ");
INSERT INTO lip_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Mfó nya Yesu lɛtɔ mǝ nkǝ, “Mɔmɔɔ, lǝ eyibibi eto ɔkuɛnsate ǝmǝ ǝbǝǝ, be wuuyifo beyifoyifo bamǝ?” ");
INSERT INTO lip_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Bǝtǝ mbuayɛ bǝnkǝ, “Woolo betidi bua bamfó kaminsǝ mǝnyǝmǝnyǝ, ufi eyibibi eto ɔkuɛ ǝmǝ okpe beyifoyifo bamba ba luutǝ wǝ, wǝ kutsyǝ lǝ balɛ eyibibi nyamǝ.” ");
INSERT INTO lip_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesu átɛyi mǝ nkǝ, “Bíankla tɔ lesa nǝ nkpe lǝ Awɔnisa Kɛnkɛ eto Kukue ǝsuǝ bǝnkǝ, ‘Leba nǝ mba laato ayo lɛni bǝ dimbǝ kɔnɔɔ, ni bomu díbǝ lefiani nǝ nso bofe lǝ afɛfɛ kenke nti. Bonamute ni nwǝ díyifo nyamfo. Sitintii, iyifo lesa nǝ laanɔ bobe tinti!’ ” ");
INSERT INTO lip_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Nya Yesu disi ɔ́tɛyi mǝ nkǝ, “Nyaso nlɛ mi bɔtɛyi minkǝ boofo Onanto eto sekakedikɔ lǝ mi ani befi bǝtǝ betidi ba lɔɔnwɔ ebibi nnya lɛlɛkɛ. ");
INSERT INTO lip_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Nya utsyuǝ saa ke lɔɔtsyinini udu ɔnɔ lǝ leba nǝ báni mfó ǝsuǝǝ, wuufǝsǝ blublublu. Nya lǝ ibǝ bǝ leba nǝmǝ tsya asɔ utsyuǝ lǝ ǝsuǝǝ, dioba wǝ dikuǝ wǝ blublublu.” ");
INSERT INTO lip_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Lefe nǝ besumunyǝ ninǝ ku Farisifɔ lɛnɔ Yesu eto akpá nyamfoo, báte bǝ mǝ ɔnlɛ. ");
INSERT INTO lip_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Nyaso bála bǝ bǝmuǝ wǝ. Fɛɛ báté sitiditu siamǝ sikpi, itsyise mǝmblɛ kenke ébu Yesu fe Onanto eto Unyɛlǝkǝtidi. ");
INSERT INTO lip_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu esi óté mǝ asa ɛyɛ lǝ akpá ǝsuǝ nkǝ, ");
INSERT INTO lip_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Onanto eto sekakedikɔ te fe mmǝ. Lefe lɔnii, Oka utsyuǝ édi kusiǝkpakpa eto diyisɛɛ útǝ wǝ ubisaibi. ");
INSERT INTO lip_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Óla wǝ beyifoyifo ókpe nkǝ besu bakpo betidi ba ókla utsyǝ nkǝ bafe bǝbǝ diyisɛɛ nǝmǝ kedikɔ. Fɛɛ bánla bǝ bǝǝbǝ. ");
INSERT INTO lip_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Nyaso óla wǝ beyifoyifo bamba ókpe nkǝ batɛyi betidi ba ókla utsyǝ nkǝ, ‘Lesalidife nǝmǝ eboyo! Bálo mɔ banantsyui ku banatsyui eto akpɔ nnya nkpe ayinkua bufi bɔlɛ mi kama bobe. Nya búkalɔ lesa saa bútsyǝ. Nyaso bibǝ kusiǝ komǝ kakpakɔ!’ ");
INSERT INTO lip_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Fɛɛ mbamǝ bákla eto kuutsyuǝ saa mémbu wǝ úbǝ. Bomu bédu bésu nlebe bamba bo bála. Ɔni édu úsu wǝ ɔkuɛ, nya obamba tsya dídu usu wǝ bikǝkatekɔ. ");
INSERT INTO lip_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Nya babamba tsya dímuǝ beyifoyifo bamǝ nya báblɛ mǝ nya bálo mǝ. ");
INSERT INTO lip_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Oka ǝmǝ ǝnyǝ ɔblɔ tinti, nya ótsyese wǝ bamamanyǝ nya bésu bálo bewudifɔ bamǝ kenke nya bátonsǝ mǝ umǝnkplɛ ǝmǝ. ");
INSERT INTO lip_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Nyaso ókpadi wǝ beyifoyifo nya ɔ́tɛyi mǝ nkǝ, ‘Mɔ ubi eto kusiǝkpakpa eto diyisɛɛ didi nǝmǝ eto lefe éboyo. Fɛɛ betidi ba mínkla miǝ bǝbǝ diyi nǝmǝ kedikɔ mǝnńyǝ itǝ diyisɛɛ nǝmǝ. ");
INSERT INTO lip_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Nyaso mɔmɔɔ, bisu umǝ eto kesunte lǝ bekpadi utsyuǝ saa wǝ ke biunyǝ biǝ bǝbǝ diyisɛɛ nǝmǝ kedikɔ mfo.’ ");
INSERT INTO lip_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Mfó nya beyifoyifo bamǝ dísu kesunte nya bákpadi utsyuǝ saa wǝ bǝnyǝ, babua ku basɛɛ kenke nya kusiǝkpakpa eto diyo nǝmǝ díyi kenke. ");
INSERT INTO lip_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Nya se Oka ǝmǝ díbǝ diyo nǝmǝ nkǝ wǝǝbǝ obe betidi ba díbǝ mfóo, únyǝ osani wǝ dímankpe awu nnya baakpe kesu kusiǝkakpakɔ. ");
INSERT INTO lip_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Oka ǝmǝ átɔ wǝ nkǝ, ‘Ɔhɔ, ntsyǝ ibǝ bǝ ǝbǝ mfo se fǝmankpe kusiǝkakpa eto awu?’ Fɛɛ wámfo kɛnyɛ bulǝkǝ. ");
INSERT INTO lip_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Mfó nya ɔ́tɛyi wǝ beyifoyifo nkǝ, ‘Bekpe wǝ amla lǝ ani ku akpa, lǝ beto wǝ bekpe lǝ ketuntu ka nkpe lekple. Mfó wuuwi keku ɔyimi animi nɛ.’ ” ");
INSERT INTO lip_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Nya Yesu lélosǝ nkǝ, “Onanto ákpadi betidi kpǝ, fɛɛ esiani ete úlǝkǝ lǝ mǝ nti.” ");
INSERT INTO lip_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Farisifɔ bǝtsyuǝ ésu bákpe disi lǝ kase bɔɔyɛ bǝmuǝ Yesu ɛyɛ lǝ wǝ kɛnyɛ eto etikididi ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Nyaso bátsyese mǝ bakasebi bǝtsyuǝ ku betidi ba ntekeko Herodes eto ditsyukpa kama lǝ Yesu ɔflɔ. Nya se bésuu, bátɛyi wǝ bǝnkǝ, “Oteasa, buyi boǝ eyifo ɔnukualɛtidi nya faate Onanto bofokanɔ eto asa lǝ kusu ǝsuǝ sitinti, itsyise aambe utidi eto ǝnǝmi keyifo lesa saa. Nya ememfi kukǝtsyuǝ lǝ betidi eto etikididi ǝsuǝ tsya. ");
INSERT INTO lip_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Nyaso tɛyi bo lesa nǝ febu. Bo kɔfi ǝtǝ bo kusu nkǝ bofó umǝnko butǝ Romafɔ eto Okankplɛ lee, yǝntǝ kusu nko?” ");
INSERT INTO lip_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Fɛɛ se Yesu mfe nyi mǝ nsusu bua esoo, ɔ́tɛyi mǝ nkǝ, “Mi ǝnǝmi ǝnǝmi eto betidi! Beso biala biǝ biato mɛ bebe? ");
INSERT INTO lip_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Bete mɛ atabi nnya biefi kafo umǝnko ǝmǝ lǝ mbe.” Béfi atabi nyamǝ báboko wǝ. ");
INSERT INTO lip_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Mfó nya Yesu lɛtɔ mǝ nkǝ, “Owoe báta bǝtǝkǝ mfo, nya owoe eto diye báwɔni bǝtǝkǝ mfo?” ");
INSERT INTO lip_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Bǝtǝ mbuayɛ bǝnkǝ, “Okankplɛ Kaisare eto ale ini.” Nyaso Yesu átɛyi mǝ nkǝ, “Bifi lesa nǝ ni Kaisare eto ale bitǝ Kaisare. Lǝ bífi lesa nǝ ni Onanto eto léle bitǝ Onanto.” ");
INSERT INTO lip_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Se bánɔ nyamfo, íyifo mǝ yanii nya bédu wǝ lǝ ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Diyi nǝmfo kee, Sadukifɔ ba laatɛyi bǝ bekpǝnkpǝ ensiembotaka betsyi ɔkɔmǝǝ, ǝbǝ Yesu ɔflɔ ku etiki ǝtsyuǝ. ");
INSERT INTO lip_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Bátɛyi wǝ bǝnkǝ, “Oteasa, Moses átɛyi bo nkǝ, lǝ osani utsyuǝ ǝkpǝ nya óyani wǝ usiǝ utsyǝ nya wonko wǝ dímanle bebii, elebɛ osani ǝmǝ eto ɔyimisani fi ɔkɔsiǝ ǝmǝ ufi. Lǝ wonko wǝ ale bebii, boofi bebi bamǝ fe osani ǝmǝ díkpe eto bebi. ");
INSERT INTO lip_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Mɔmɔɔ, ibǝ bǝ bayimisani ekuanse ǝsiǝ lǝ bo nti mfo. Ɔyimisani ninǝ kenke éfi usio, nya wonko wǝ mánle fɛ osani ǝmǝ díkpǝ. Nya wǝ ɔyimisani wǝ ntǝkǝ wǝ kama dífi ɔkɔsiǝ ǝmǝ. ");
INSERT INTO lip_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Nko ibǝ ɔyimisani nuǝfǝ ku utsyǝfǝ isu ese okuansele mǝmblɛ dífi usio ǝmǝ bafia nya mǝ nti kuutsyuǝ ku usio ǝmǝ mánle fɛ békpǝ. ");
INSERT INTO lip_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Lǝ kalosǝkɔɔ, usio ǝmǝ tsya ǝbǝ úkpǝ. ");
INSERT INTO lip_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Mɔmɔɔ, lǝ diyi nǝ bekpǝnkpǝ lootaka betsyi ɔkɔmǝǝ, owoe eto usiǝ wuudi se mǝmblɛ kenke díkefi wǝ bǝnyǝ?” ");
INSERT INTO lip_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesu ǝtǝ mǝ mbuayɛ nkǝ, “Bénya kusu tinti. Itsyise biannɔ Awɔnisa Kɛnkɛ eto Kukue komǝ kasɔ, nya binyi kulesa lǝ Onanto eto ǝsuǝale ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Lǝ bekpǝnkpǝ esi bataka bǝbǝ nkpǝǝ, bootsyǝ fe Onanto eto batɔnkpe ba nkpe lǝ Onanto eto kato, nya bembufi bǝsiǝ nye bǝsiǝ besǝ tsya. ");
INSERT INTO lip_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Nya bíankla asa nnya Onanto lɛtɛyi mi itsyi lǝ bekpǝnkpǝ eto botaka ketsyi ɔkɔmǝ ǝsuǝ? Ɔ́tɛyi nkǝ, ");
INSERT INTO lip_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Mɔ ni Abraham eto Onanto ku Isak eto Onanto ku Yakob eto Onanto!’ Uyifo mba nkpe nkpǝ eto Onanto inni mba díkekpǝ.” ");
INSERT INTO lip_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Se sitiditu siamǝ lɛnɔ asa yamfoo, íyifo mǝ yanii, lǝ wǝ asatete ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Se Farisifɔ lɛnɔ bǝ Yesu asɔ Sadukifɔ kasɔɔ, bésu bátsya. ");
INSERT INTO lip_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Nya mǝ ɔni wǝ ni afi eto oteasa, ála nkǝ lǝ ɔtɔ Yesu etiki ǝtsyuǝ lǝ umuǝ wǝ lǝ wǝ etiki ǝsuǝ. Ɔ́tɛyi nkǝ, ");
INSERT INTO lip_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Oteasa, nte kɔfi ko nso bofe lǝ afi nyamǝ kenke nti?” ");
INSERT INTO lip_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesu ǝtǝ mbuayɛ nkǝ, “La fǝ Onamute wǝ ni fǝ Onanto ku fǝ utu kenke ku fǝ lɛwɔnɔ kenke ku fǝ nsusu kenke. ");
INSERT INTO lip_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Kɔfi komfo ni kɔkplɛ kenke ko nso bofe tsya nɛ. ");
INSERT INTO lip_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Kunuǝfǝ ko lefe lele ko ni, ‘La fǝ ɔyimitsyuǝ fe kase faala fǝ ǝsuǝ.’ ");
INSERT INTO lip_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Moses eto kɔfi komǝ ku Onanto eto bǝnyɛlǝkǝtidi eto asatete kenke kpǝsǝ lǝ afi ǝnuǝ nyamfo ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Se Farisifɔ bǝtsyuǝ létsyaa, Yesu átɔ mǝ nkǝ, ");
INSERT INTO lip_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ntsyǝ ni mi nsusu lǝ Nwǝ Onanto Lékpo Ɔhile Utsyǝ Ǝsuǝ? Owoe eto ubi uni?” Bǝtǝ mbuayɛ bǝnkǝ, “Oka David eto ubi uni.” ");
INSERT INTO lip_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Mfó nya Yesu lɛtɔ mǝ nkǝ, “Lǝ nko inii, ntsyǝ fɛ Oka David ɛyɛ lǝ Onanto eto Lɛwɔnɔ Kɛnkɛ eto ǝsuǝale ǝsuǝǝ, lékpadi wǝ nkǝ Onamute. Oka David átɛyi nkǝ, ");
INSERT INTO lip_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Bonamute átɛyi mɔ Onamute nkǝ, “Siǝ mfo lǝ mɔ kodiani isu ese lefe nǝ muutǝ efi fǝ akpa ǝtǝkǝ fǝ balo lǝ disinti.” ’ ");
INSERT INTO lip_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Nya lǝ Oka David ákpo Nwǝ Onanto Lékpo Ɔhile Utsyǝ nkǝ Onamutee, ntsyǝ ibǝ bǝ Nwǝ ǝmǝ esi uyifo Oka David eto ubi?” ");
INSERT INTO lip_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Mǝ nti eto kuutsyuǝ mámfo Yesu mbuayɛ butǝ. Nya idu dinǝmfo entɔɔ, mǝ kuutsyuǝ ménsifo wǝ ditiki saa bɔtɔ. ");
INSERT INTO lip_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Nyamfo eto kamaa, Yesu édi sitiditu siamǝ ku wǝ bakasebi etiki. ");
INSERT INTO lip_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Ɔ́tɛyi nkǝ, “Afi eto bateasa ku Farisifɔ kpe ǝsuǝale, bǝ baté Moses eto kɔfi komǝ. ");
INSERT INTO lip_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Nyaso ele bǝ biyifo lǝ lesa nǝ ke batɛyi mi ǝsuǝ kukɔnɔ. Fɛɛ biǝntǝkǝko mǝ eyifosa kama itsyise bǝǝnsiǝ nkpǝ lǝ asa nnya baate ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Baakle bikǝ bia nkpe kalende ku nkpe ale ku butsyi ketsyisǝ betidi, tsya fɛɛ bembokpe fǝ lɛ kɔni etsyi bikǝ biamǝ. ");
INSERT INTO lip_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Beeyifo lesa saa bǝ lǝ betidi lǝ bǝnyǝ mǝ. Be Awɔnisa Kɛnkɛ eto etiki nnya báwɔni bákpe lǝ mǝ nto ku anii, be kase báwɔni nya ɛmɔɔ, ku kase bankpimi nnyaa! Be kase tsya aboyo nnya mfaka lǝ mǝ awu nnya bankpe eto nyɛ ǝsuǝ dikulǝǝ! ");
INSERT INTO lip_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Baala nkplɛkɔ sɛɛ busiǝ lǝ eyi kedikɔ ku nsiǝkɔ bo bebu bǝtsyǝ bakplɛnyǝ lǝ Yudafɔ eto ntsyakɔ. ");
INSERT INTO lip_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Baala bǝ betidi kǝsiǝsǝ mǝ kǝbǝ kasɔ ku dibu lǝ asi bakpadi mǝ bǝ Oteasa. ");
INSERT INTO lip_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Yanle bǝ bakpadi mi bǝ Oteasa itsyise mimblɛɛ, bayimi bini lǝ bǝtsyuǝ nya Oteasa ɔni kplo nkpe mi. ");
INSERT INTO lip_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Nya yanle bǝ bekpadi kuutsyuǝ saa lǝ kasɔ mfo biǝ mi Anto, itsyise Anto ɔni hã nkpe mi lǝ kato. ");
INSERT INTO lip_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Biǝntǝ bakpadi mi Ɔtɔnkotɔnko, itsyisee Ɔtɔnkotɔnko ɔni hã ete nkpe bo, wǝ ni Nwǝ Onanto Lékpo Ɔhile Utsyǝ. ");
INSERT INTO lip_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nwǝ ni ɔkplɛnyǝ lǝ mi nti yifo nwǝ ni mi uyifoyifo. ");
INSERT INTO lip_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Utsyuǝ saa wǝ laabesǝ ǝsuǝ katoo, boobokosǝ wǝ kasɔ. Nya nwǝ laabokosǝ wǝ ǝsuǝ kasɔɔ, boobesǝ wǝ kato. ");
INSERT INTO lip_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Mbɔbɔɛ mǝǝtǝ mi, afi eto bateasa ku Farisifɔ! Mi ǝnǝmi ǝnǝmi eto betidi! Mi díti Onanto eto sekakedikɔ eto kusu bekpe betidi, nya mi kosate endufǝ mfó, nya bieti betidi bamba ba nlɛ bokplatsya kekleke tsya kusu biǝ bendufǝ. ");
INSERT INTO lip_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Mbɔbɔɛ mǝǝtǝ mi afi eto bateasa ku Farisifɔ! Mi ni ǝnǝmi ǝnǝmi eto betidi. Biesu bakɔbǝsiǝ ɔflɔ biǝ biawunsǝko mǝ, fɛɛ biawɛ mǝ kalɛ mǝ lesa saa kafo. Nya biato kala kɛntsyɛ bimba. Lǝ nyamfo esoo, mi kotonǝnǝ ebɔkɛ ale eso! ");
INSERT INTO lip_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Mbɔbɔɛ mǝǝtǝ mi afi eto bateasa ku Farisifɔ! Ǝnǝmi ǝnǝmi eto betidi bini! Biayila lekpo akpa akpa ku biayɛ kafe lǝ nsɔ nsɔ ǝsuǝ lǝ bilǝkǝ utidi ɔni eto okla bitǝ Onanto. Nya lǝ befo utsyuǝ buyifo nkoo, biatǝ woabia nnya lǝǝtǝ bǝ udufǝ lǝ ditefɛnku nǝme kǝmiǝ enso mi kosate kulaa tsya! ");
INSERT INTO lip_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Mbɔbɔɛ mǝǝtǝ mi, bǝnǝmba ba ni batɔnkotɔnko! Biatɛyi biǝ, ‘Lǝ utsyuǝ akpadi Disumuyo eto diyee, yeambiasǝ kulesa. Fɛɛ lǝ okpadi sika sia nte lǝ Disumuyo mfóo, nnya akle wǝ bǝ uyifo lǝ akpadi nyamǝ ǝsuǝ kokooko.’ ");
INSERT INTO lip_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Bǝnǝmba eto bamumu! Nte nnya nso bofe, sika siamǝ lee, Disumuyo ka dítǝ sika siamǝ díyifo kɛnkɛ? ");
INSERT INTO lip_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Biate tsya biǝ, ‘Lǝ utsyuǝ ataninko Disumuyo eto lebaa, kataninko kamǝ mankle wǝ, fɛɛ lǝ otaninko ǝtǝsa nnya ntǝkǝ lǝ Disumuyo eto leba nǝmǝ ǝsuǝǝ, nnya akle wǝ.’ ");
INSERT INTO lip_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Nya ntsyǝ béba ǝnǝmi mmǝ! Nte nnya nso bofe, ǝtǝsa nnyamǝ lee, Disumuyo eto leba nǝ dítǝ ǝtǝsa nnyamǝ díyifo kɛnkɛ. ");
INSERT INTO lip_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Nyaso lǝ utidi éfi Disumuyo eto leba nǝmǝ óka ntamuu, ɔlɛ mu boka ɛyɛ lǝ keditǝtǝ eto leba nǝmǝ ku keditǝtǝ kenke ka ntǝkǝ lǝ leba nǝmǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Nya lǝ óka ntamu okpadi Disumuyo Kplɛɛ, ɔlɛ mu boka kakpadi Disumuyo ku Onanto we nsi lǝ mfó tsya. ");
INSERT INTO lip_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Nya lǝ utsyuǝ ákpadi katoo, ɔlɛ Onanto eto lekankpomɛ ku nwǝ lǝǝsiǝ lǝ ni bokpadi. ");
INSERT INTO lip_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Mǝǝtǝ mi mbɔbɔɛ, mi afi eto bateasa ku Farisifɔ! Mi ǝnǝmi ǝnǝmi eto betidi! Biefi kayoma eto bekolenkǝ bia laanyi fififi bia biakpe eto lekpafosile kǝtǝ Onanto, fɛɛ bɛni nya bienyifo lǝ kɔfi eto asa tete nnya nso bofe ǝsuǝ, nnya ni bɔyɛ lǝ kusu ǝsuǝ, kaminsǝnyǝnyǝ, ku ɔnukualɛdidi. Nyamfo ele bǝ biyifo bifi bekpe lǝ afɛfɛ nyamǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Mi batɔnkotɔnko ba ni bǝnǝmba! Biayɛ ekubi kǝlǝkǝ lǝ nte ǝsuǝ, fɛɛ asa nnya biamini amɔ eso ɔtɔmini ku lekoko. ");
INSERT INTO lip_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Mbɔbɔɛ mǝǝtǝ mi afi eto bateasa ku Farisifɔ! Ǝnǝmi ǝnǝmi eto betidi! Biǝflǝ mi akɔbe ku kakpɛ eto kama, fɛɛ nnya kafoo eyi ku asa bua fe kase mi tsya lebia nya biyi ku asa nnya béfo lǝ ǝsuǝale ku lǝ mɔ hã ete eto lɛlɛkɛsǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Fǝ Farisinyǝ unǝmba, tsyiko fǝ lɛkɔbe buflǝ lǝ kafo, ete ni kama tsya ebole kɛnkɛnkɛ. ");
INSERT INTO lip_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Mbɔbɔɛ mǝǝtǝ mi afi eto bateasa ku Farisifɔ! Ǝnǝmi ǝnǝmi eto betidi bini! Bite fe edi nnya bákua bǝńyǝnsǝ laanɔ bobe. Fɛɛ nnya kǝmiǝ eyi ku bakɔ bubu ku ekubi biabia. ");
INSERT INTO lip_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Nko ke bele betidi ba lɛlɛkɛ lǝ betidi eto ǝnǝmi, fɛɛ biyi ku kawɛ ku ditsyǝbi bua. ");
INSERT INTO lip_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Mbɔbɔɛ mǝǝtǝ mi afi eto bateasa ku Farisifɔ! Ǝnǝmi ǝnǝmi eto betidi! Bieku edi sɛɛ kǝtǝ Onanto eto bǝnyɛlǝkǝtidi ba dísiǝ nkpǝ sɛɛ nya bialɔ nnya kukɔnɔ. ");
INSERT INTO lip_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Nya biatɛyi biǝ, ‘Lǝ nnya ete busiǝ nkpǝ lǝ lefe nǝ bo banamǝ dísiǝǝ, eni bienyifo lesa nǝ béyifo, balo Onanto eto bǝnyɛlǝkǝtidi.’ ");
INSERT INTO lip_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Nyaso befo nnya sitinti biǝ, mi eyifosa afo nnya ekpe bǝ biyifo mba lélo Onanto eto bǝnyɛlǝkǝtidi eto befluflu. ");
INSERT INTO lip_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Nyaso bisukosǝ lǝ belosǝ lesamǝ mi banamǝ dítsyǝ kasɔ. ");
INSERT INTO lip_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Mi betidi bua, biyifo fe bawa eto bebi eto bebi! Bibu biǝ biofo butsyetsyi kedu lǝ Onanto eto kotonǝnǝ lǝ ditefɛnku manlo ǝsuǝ? ");
INSERT INTO lip_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Lǝ nyamfo esoo, nlɛ mi bɔtɛyi minkǝ, mootsyese mi Onanto eto bǝnyɛlǝkǝtidi, babesibe ku bateasa, Biolo mǝ bǝtsyuǝ, bɛsɔ bǝtsyuǝ lǝ uyikabie, nya biɔblɛ bǝtsyuǝ lǝ Disumuyo, nya biutǝkǝko mǝ idu lǝ umǝ isu umǝ. ");
INSERT INTO lip_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Lǝ nyamfo esoo, kotonǝnǝ itǝ mba lélo betidi ba dímenyifo kabua saa ebutǝkǝ mi lǝ ǝsuǝ, idu lǝ Abel wǝ dímenyifo ɔsɛɛ nyǝ lǝ Onanto eto ǝnǝmi eto kɔtɔ, isu Sakaria, Barakia eto ubi, nwǝ belo lǝ Disumuyo ku kedikǝtǝkɔ eto leba eto nti eto kɔtɔ. ");
INSERT INTO lip_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nlɛ mi bɔtɛyi sitinti minkǝ kɔtɔ komfó kenke tǝkǝ mmi mba nsi nkpǝ mmi lǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Yerusalem, Yerusalem, fǝ lélo Onanto eto bǝnyɛlǝkǝtidi nya fákpɔ Onanto eto batɔnkpe ba ótsyese aba! Nla sesia sesia miǝ maasɔ fǝ betidi lebo lǝ mɔ akɔ, fe kase ukusɛsiǝle laakpa wǝ bebi kakpe lǝ wǝ mbamba kalɔ, fɛɛ biǝntǝ kusu nko. ");
INSERT INTO lip_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Lǝ nnya esoo, fǝ Disumuyo ebubu kǝtsyǝ fufu. ");
INSERT INTO lip_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Idu mɔmɔ ɛntɔɔ, nlɛ mi bɔtɛyi miǝ, biensi embunyǝ mɛ bio isu se lefe nǝ bɛtɛyi biǝ, ‘Onanto kpo nwǝ nlɛ bubǝ lǝ Bonamute eto diye ǝsuǝ atsyɔ.’ ” ");
INSERT INTO lip_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Se Yesu lɛbɔ lǝ Disumuyo mfo ɔntɔɔ, wǝ bakasebi ǝbǝ wǝ ɔflɔ bǝ baaté wǝ kase báto Disumuyo nǝmǝ ku ke ayo kenke. ");
INSERT INTO lip_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Fɛɛ ɔ́tɛyi mǝ nkǝ, “Bɛlɔ bebe nyamfo kukɔnɔ. Itsyise nlɛ mi bɔtɛyi minkǝ booba ayo nyamfo kenke, bǝ lɛ leba lɔni embubu ditǝkǝ lǝ ni utsyuǝ ǝsuǝ. Boosensǝ nyamblɛ bewui.” ");
INSERT INTO lip_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Se Yesu dísu unsi lǝ Nnuǝbi eto Eyi eto Kɔtini ǝsuǝǝ, wǝ bakasebi ǝbǝ wǝ ɔflɔ buɛɛ nya bátɔ wǝ bǝnkǝ, “Tɛyi bo lefe nǝ kawunsiǝ eto kalosǝkɔ luubǝ ku lesa nǝ luubǝ nnya loote bǝ fǝ businkli kǝbǝ eto lefe eboyo.” ");
INSERT INTO lip_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesu átɛyi mǝ nkǝ, “Bebe kukɔnɔ biǝ kuutsyuǝ saa manwɛ mi okpe. ");
INSERT INTO lip_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Betidi kpǝ ebubǝ ba luufi mɔ diye bǝbǝ batɛyi mi bǝnkǝ, ‘Mɔ ni Nwǝ Ǝmǝ Bákpo Ɔhile Bǝtsyǝ,’ bǝ lǝ bawɛ betidi kpǝ bakpe. ");
INSERT INTO lip_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Biɔnɔ ama eto kudu ku ama eto etiki lǝ katsyontsyokɔ ku kaka lɛfi. Fɛɛ bíǝntǝ lǝ nyamfo lǝ ekpe mi sikpi. Ele bǝ asa nyamfo bǝ, fɛɛ yante bǝ kalosǝkɔ eboyo tɔ. ");
INSERT INTO lip_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Nsɔ eto betidi ebɔkpɔ ama ku mǝ bǝtsyuǝ. Nya sekakedikɔ ebotaka sińyǝ lǝ se utsyuǝ ǝsuǝ. Nya kukpɛnsɛ luubǝ lǝ nlebe kpǝ. Nya nsɔ tsya luutinkǝ lǝ nlebe nlebe. ");
INSERT INTO lip_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Nyamfo kenke ebuyifo fe kase kalelefo lǝǝtsyǝ usio kasɔ ku bunǝ. ");
INSERT INTO lip_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Lǝ lefe nǝmfóo, boomuǝ mi befi mi bakpe lǝ ani bǝtǝ bǝ bate mi ohiã, nya boolo mi kulaa tsya. Kawunsiǝ eto betidi kenke ebukisi mi lǝ mɔ disi eso. ");
INSERT INTO lip_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Betidi kpǝ ebonyansǝ mǝ bofokanɔ. Boofi mǝ bǝtsyuǝ bakpe lǝ ani bǝtǝ balo nya bookisi mǝ bayimi bǝtsyuǝ. ");
INSERT INTO lip_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Betidi kpǝ ebɔbɔ batɛyi bidia bǝnkǝ mǝ ni Onanto eto bǝnyɛlǝkǝtidi nya bɔɔwɛ betidi kpǝ bakpe. ");
INSERT INTO lip_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Abuayifoyifo ebufui ekpe nya mba dikafo banɔ kpǝ eto lelabi itǝ bǝtsyuǝ lɔɔni. ");
INSERT INTO lip_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Fɛɛ nwǝ luunyǝ kekleke isu ese kalosǝkɔ, ebunyǝ nkpǝ manlo. ");
INSERT INTO lip_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Boobe Onanto eto sekakedikɔ eto Ditiki Sɛɛ nǝmǝ letsya lǝ kawunsiǝ bafia, itǝ lǝ utsyuǝ saa lǝ uńyǝ kusu ɔnɔ ni, nnya kama fɛ kalosǝkɔ luubǝ nɛ. ");
INSERT INTO lip_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Buinyǝ ekpinsa nyamǝ luubǝ ińyǝ lǝ kakɛnkɛkɔ kamǝ fe kase Onanto eto unyǝlǝkǝtidi Daniel lɛtɛyi útsyǝ. Yuuńyǝ lǝ kakɛkɛnkɔ kamǝ. Nya fǝ ke lékla kukue komfoo, nɔ nyamfo kasɔ wuee. ");
INSERT INTO lip_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Nya lǝ lefe nǝmfóo, mimba nkpe lǝ Yuda eto kasɔ, tsyetsyi besu atini ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Utidi wǝ ntǝkǝ lǝ diyo disi, wanyifǝ ubǝ kasɔ nkǝ wǝǝbǝ ufi kulesa lǝ wǝ diyo kafo. ");
INSERT INTO lip_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Utidi wǝ nkpe lǝ ɔkuɛ mensi sinkli ubǝ oto nkǝ wǝǝbǝ ufi wǝ kafia. ");
INSERT INTO lip_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Fɛɛ mbɔbɔɛ mǝǝtǝ bafonlɛ ku bebiambe ba nlɛ bebisambi bɔyimisǝ lǝ lefe nǝmfo ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Bɛlɛ Onanto lekpakpa biǝ mmi ditsyetsyife nǝmǝ mǝntǝkǝ lǝ lɛyɔ lefe nye Ɔnwɛditsyǝyi ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Itsyise kayinyǝnyǝ kekleke ka luubǝ lǝ lefe nǝmfóo, ke okle mǝmbǝ tɔ kǝnyǝ itsyi lǝ kawunsiǝ eto ketsykokɔ ke. Nya ke okle tsya ensiembubǝ kǝnyǝ. ");
INSERT INTO lip_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Fɛɛ Onanto ébose nnya uyi útsyǝ nkǝ wuulǝkǝ eyi nyamǝ ubu. Lenni nko esoo, eni utidi sa embubu usiǝ lǝ nkpǝ. Fɛɛ lǝ betidi ba Onanto díkǝlǝkǝ utsyǝ esoo, wuulǝkǝ eyi nyamǝ ubu. ");
INSERT INTO lip_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Nyaso lǝ utsyuǝ átɛyi mi nkǝ, ‘Bebe! Nnyǝ Nwǝ Onanto Lékpo Ɔhile Utsyǝ nkpe mfo o-o,’ nye ‘Nnyǝ wǝ nkpe mmǝǝ,’ mamfo wǝ anɔ. ");
INSERT INTO lip_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Itsyise badia ba laatɛyi bǝ mǝ ni mba Bákpo Ɔhile Bǝtsyǝ ku mba tsya bǝ mǝ ni Onanto Eto Bǝnyɛlǝkǝtidi ebotaka bǝbǝ. Nya booyifo ayanisa kplɛ kplɛ kpǝ bate, bǝ lǝ boofo kulaa tsya, bɔɔwɛ betidi ba Onanto dílǝkǝ utsyǝ bakpe. ");
INSERT INTO lip_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Bɛnɔ biǝ mbɔtɛyi mi nyamfo ntɔnsǝ fɛ lǝ lefe nǝmǝ lǝ leyo. ");
INSERT INTO lip_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Nye lǝ betidi átɛyi mi bǝnkǝ, ‘Okpe lǝ mfimintii,’ biensu bebe. Nye lǝ bátɛyi mi bǝ ‘Okpe lǝ diyo kafo mfoo,’ biamfo bɛnɔ. ");
INSERT INTO lip_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Itsyise Utidi Eto Ubi eto bubǝ ebutsyǝ fe kase kato laato ɔsi mia mia, lǝ kofekatokɔ kǝnyǝndǝ kakpo lǝ kofe eto diyokedufǝkɔ seka. ");
INSERT INTO lip_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Kaka lesakpǝnkpǝ ntee, mfo ebintsyǝ lǝǝsiǝ nɛ. ");
INSERT INTO lip_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Lǝ kanyinyǝnyǝ kamfo eto kamaa, kofe ebona tũũ, nya kofande tsya ensiembuyǝnde, nya befandebi loolo bitsyi kato, nya kato eto ǝsuǝale luutinkǝ nya yɔɔnyi lǝ nnya ńyǝnkɔ. ");
INSERT INTO lip_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Nya Utidi Eto Ubi eto ditsyǝbi nǝmǝ lɔɔbɔ bǝnyǝ ɔnlɛ bubǝ lǝ asɔmiloku ǝsuǝ. Nya kawunsiǝ eto betidi kenke luuwi nku lǝ bǝnyǝ Utidi Eto Ubi ntǝkǝ lǝ asɔmiloku ǝsuǝ ɔnlɛ bubǝ lǝ diyǝnde ku ǝsuǝale kplɛ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Buufe kakpatsyaku kplɛ nya wootsyese wǝ batɔnkpe kawunsiǝ eto akpɔ ana nyamǝ, nya bookpa betidi ba úlǝkǝ útsyǝ idu lǝ kawunsiǝ eto disi lɔni isu disi nǝ. ");
INSERT INTO lip_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Bekase asa itsyi lǝ kudiyi ǝsuǝ lǝ kase koata kabɔ afanto fɔfɔ. Lefe nǝ binyǝ kudiyi ditsyiko bota kǝlǝkǝ afantoo, biate biǝ kasɔminte boyo kalo. ");
INSERT INTO lip_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Nko ke lǝ binyǝ asa nnya kenke mínkatɛyi míntɔnsǝǝ, bete biǝ kalosǝkɔ kamǝ eboyo kalo. ");
INSERT INTO lip_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nlɛ mi bɔtɛyi sitinti minkǝ asa nyamfo kenke ebubǝ fɛ mba nsi nkpǝ mfo luukpǝ balo. ");
INSERT INTO lip_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kato ku kasɔ ebubǝ kafe, fɛɛ mɔ etiki embubǝ efe kulefe. ");
INSERT INTO lip_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Kuutsyuǝ saa enyi diyi nye lefe nǝmǝ kalosǝkɔ luubǝ. Onanto eto Batɔnkpe nye Ubi ǝmǝ kulaa tsya enyi. Anto hã nyi. ");
INSERT INTO lip_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Utidi Eto Ubi eto bubǝ ebuyifo fe kase íbǝ lǝ Noa eto lefe. ");
INSERT INTO lip_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Lǝ lefe nǝ lɛtɔ ntu eto buyi bomǝǝ, betidi ékedi, bǝkǝnǝ, basani ku besio ákakpa bǝtsyuǝ isu ese diyi fɛfɛ nǝ Noa dídufǝ lǝ kufue komǝ kafo. ");
INSERT INTO lip_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Fɛɛ bánte lesa nǝ nlɛ bubǝ isu ese lefe nǝ ɔsɔmi lɛni, ntu díyi bókpa mǝmblɛ kenke búdunko. Nko ke yuutsyǝ lǝ Utidi Eto Ubi eto dibǝfe tsya nɛ. ");
INSERT INTO lip_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Lǝ lefe nǝmfóo, basani inuǝ ebuńyǝ lǝ ɔkuɛ bekeyifo keyifo fɛ wookpa ɔni udunko nya uubu ɔni bǝtsyǝ. ");
INSERT INTO lip_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Besio inuǝ ebuńyǝ bǝkǝkuǝ antabi, fɛɛ Onanto ebutsyi ɔni udunko nya uubu ɔni utsyǝ. ");
INSERT INTO lip_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Nyaso bitǝkǝ ǝnǝ, itsyise binnyi diyi nǝ mi Onamute luubǝ. ");
INSERT INTO lip_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Lǝ oyosate áte dinǝ uyu luubǝ wǝ keyukɔ, eni wuutǝkǝ ǝnǝ ukase ni. Nya weembutǝ kusu nkǝ uyu ǝmǝ dufǝ, oba wǝ diyo uyu wǝ. ");
INSERT INTO lip_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Nko ke ele bǝ fintsya muǝ ǝsuǝ ǝtsyǝ, itsyise Utidi Eto Ubi ǝmǝ ebubǝ lǝ lefe nǝ fannlɛ wǝ kusu bobe. ");
INSERT INTO lip_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Owoe ni uyifoyifo sɛɛ wǝ ni obesibe? Wǝ ni uyifoyifo wǝ, wǝ Onamute dífi útsyǝ lǝ wǝ beyifotsyuǝ eto kɛnyɛ, nkǝ úkǝtǝ mǝ lesa lǝ lefe ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Nte disuǝyuǝ nǝ eto okle yuudi itǝ uyifoyifo ǝmfo lǝ wǝ Onamute ǝbǝ unyǝ wǝ ɔnlɛ buyifo lǝ kusu ǝsuǝ! ");
INSERT INTO lip_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nlɛ fǝ bɔtɛyi sitinti minkǝ Onamute ǝmfo ebufi uyifoyifo ǝmfo utsyǝ lǝ wǝ bikǝ kenke eto kɛnyɛ. ");
INSERT INTO lip_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Fɛɛ lǝ uyifoyifo bua unii, wɔɔtɛyi wǝ ǝsuǝ nkǝ, ‘Mɔ Onamute embubǝ mɔmɔ!’ ");
INSERT INTO lip_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Nyaso wuutsyiko wǝ beyifoyifotsyuǝ bɔblɛ, nya ukedi, ukǝnǝ ku betekpe. ");
INSERT INTO lip_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Nya wǝ Onamute ǝmǝ ebubǝ lǝ diyi lɔni nǝ ɔnlɛ wǝ kusu bobe ku lefe nǝ unnyi. ");
INSERT INTO lip_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Onamute ǝmǝ ebunǝ wǝ koto sitinti. Nya wuunǝ wǝ koto kekleke fe kase ińyǝ itǝ ǝnǝmi ǝnǝmi eto betidi seka! Mfó nya wuuwi keku wɔɔyimi animi! ");
INSERT INTO lip_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Lefe nǝmfóo, mmǝ seka Onanto eto sekakedikɔ luutsyǝ nɛ. Yuutsyǝ fe mbitɛ lefosi ba léto mǝ kakandiɛ bǝ beesu batsyako ɔkafɔse utsyuǝ. ");
INSERT INTO lip_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Mǝ nti eto ɛnɔ eeninǝ, nya ɛnɔ fɛfɛ tsya eyifo babesibe. ");
INSERT INTO lip_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ɛnɔ ba leeninǝ étsyi kakandiɛ, fɛɛ béntsyi nnuǝbi lǝ asa ǝsuǝ báwunisǝ. ");
INSERT INTO lip_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Nya babesibe bamǝ alɛɛ, mǝ étsyi nnuǝbi báwunsǝ lǝ mǝ asa ǝsuǝ ku kakandiɛ kamǝ. ");
INSERT INTO lip_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Se Okafɔse ǝmǝ léfe kama ku bubǝ esoo, mbitɛ bomǝ étsyiko selabe butinkǝ nya bálabe selabe. ");
INSERT INTO lip_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Ntsyenti lefee, bánɔ kudu bǝnkǝ, ‘Nnyǝ okafɔse ǝmǝ nlɛ bubǝ! Betaka, bibǝ betsyako wǝ!’ ");
INSERT INTO lip_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Mfó nya mbitɛ bomǝ létaka nya bábesǝ mǝ kakandiɛ eto ute kato. ");
INSERT INTO lip_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Nya mba leeninǝ lɛtɛyi babesibe bamǝ bǝ, ‘Bitǝ bo mi nnuǝbi bomǝ eto ntsyuǝ itsyise bo kakandiɛ lɛ bɔni.’ ");
INSERT INTO lip_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Nya babesibe bamǝ lɛtɛyi mǝ bǝnkǝ, ‘Bo nnuǝbi emboyo itǝ bo ku mi, nyaso bisu mba laate ɔflɔ, lǝ bisu beya butsyuǝ bitǝ ǝsuǝ.’ ");
INSERT INTO lip_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Nya kase bésu mu kayakɔ koo, okafɔse ǝmǝ ǝbǝ údufǝ. Mbitɛ ɛnɔ ba dímuǝ ǝsuǝ ǝkǝko wǝ bédufǝ lǝ kaka banlɛ kusiǝ komǝ bokpa mfó nya béti siku. ");
INSERT INTO lip_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Kamaa, mbitɛ fɛfɛ bomǝ tsya ǝbǝ bédufǝ nya bétsyiko siku bɔsɔ katɛyi nkǝ, ‘Boanto, Boanto! Sini bo lǝ budufǝ!’ ");
INSERT INTO lip_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Nya okafɔse ǝmǝ lɛtɛyi mǝ nkǝ, ‘Kulefe, minnyi mi!’ ” ");
INSERT INTO lip_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Mfó nya Yesu lélosǝ ɔ́tɛyi nkǝ, “Nyaso bimuǝ ǝsuǝ bitsyuǝ, itsyise binyi diyi nye lefe nǝ muubǝ. ");
INSERT INTO lip_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Lefe nǝmfóo, Onanto eto sekakedikɔ ebutsyǝ fe mmǝ. Lefe lɔnii, Osani utsyuǝ akɛ, wǝ léla nkǝ lǝ usu kusu kutsyuǝ nyaso ókpadi wǝ beyifoyifo nya úfi wǝ bikǝ ókpe mǝ lǝ ani. ");
INSERT INTO lip_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Útǝ utsyuǝ saa lesa nǝ wuukefi keyifo lǝ wǝ ǝsuǝale ǝsuǝ, nya ɔnii, útǝ wǝ sika eto atabi akpi anɔ. Nya obambaa, útǝ wǝ akpi ǝnuǝ. Utsyǝfǝǝ, útǝ wǝ kɔkpi kɔni. Nya údu úsu wǝ kusu komǝ. ");
INSERT INTO lip_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Uyifoyifo wǝ léfo atabi eto akpi anɔɔ, ésu ɔ́tsyi ɔ́wuninsǝ lǝ nnya ǝsuǝ nya únyǝ akpi anɔ útǝkǝsǝ. ");
INSERT INTO lip_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Nko ke nwǝ bǝtǝ akpi ǝnuǝ tsya dínyǝ akpi ǝnuǝ útǝkǝsǝ. ");
INSERT INTO lip_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Fɛɛ uyifoyifo wǝ bǝtǝ sika eto atabi kɔkpi kɔnwɛɛ, úsu úku dibiǝ nya úfi wǝ Onamute eto atabi nyamǝ ɔ́kula mfó. ");
INSERT INTO lip_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Lǝ lefe kɛntsye eto kamaa, beyifoyifo bamfo eto Onamute ǝmǝ ésinkli úbǝ nya údufǝ lǝ nkunta ku mǝ. ");
INSERT INTO lip_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Uyifoyifo wǝ léfo sika eto atabi akpi anɔ, éfi akpi anɔ bamba óboko nya ɔ́tɛyi nkǝ, ‘Bonamute, ǝtǝ mɛ sika eto akpi anɔ, nya mínyǝ akpi anɔ bamba mínkpe.’ ");
INSERT INTO lip_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Wǝ Onamute ǝmǝ átɛyi wǝ nkǝ, ‘Alɔ éyifo, uyifoyifo sɛɛ. Éyifo asa lǝ kusu ǝsuǝ nya fálɛ asa sɛkɛ ola, nyaso muufi fǝ ntsyǝ lǝ asa kpǝ eto kɛnyɛ. Dufǝ ǝbǝ lǝ ǝbǝ ǝnyǝnko mɛ disuǝyuǝ!’ ");
INSERT INTO lip_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Nya uyifoyifo nuǝfǝ wǝ bǝtǝ sika eto akpi ǝnuǝ tsya díbǝ nya ɔ́tɛyi nkǝ, ‘Bonamute, ǝtǝ mɛ sika eto atabi akpi ǝnuǝ nya mínyǝ akpi ǝnuǝ bamba mínkpe.’ ");
INSERT INTO lip_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Wǝ Onamute ǝmǝ átɛyi wǝ nkǝ, ‘Uyifoyifo sɛɛ, éyifo lesa saa lǝ kusu ǝsuǝ tinti! Se fálɛ asa sɛkɛ ola lǝ kusu ǝsuǝ esoo, muufi fǝ ntsyǝ lǝ kpǝ eto kɛnyɛ. Bǝ lǝ ǝbǝ ǝnyǝnko mɛ disuǝyuǝ!’ ");
INSERT INTO lip_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Mfó nya uyifoyifo wǝ léfo sika eto atabi kɔkpi kɔnwɛ tsya díbe nya ɔ́tɛyi nkǝ, ‘Bonamute, nyi minkǝ eyifo utidi wǝ eto asa nkpe ale nnya fǝǝfǝsǝ asa lǝ kaka fámanto kuǝtsyuǝ. Nya faalɛ asa lǝ kaka fémense kulesa. ");
INSERT INTO lip_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nya se mínte sikpi esoo, mfi fǝ atabi nyamǝ nya mínku dibiǝ mímfi nnya mínkpe. Nyaso nyǝ fǝ atabi ni nyamfo.’ ");
INSERT INTO lip_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Wǝ Onamute ǝmǝ átɛyi wǝ nkǝ, ‘Fǝ uyifoyifo bua, ɔflɔ́. Eyi fǝ meefi lesa kaka lǝ mánkpe nya mǝǝfǝsǝ asa lǝ kaka mánto kulesa. ");
INSERT INTO lip_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Nyalɛ beso fémemfi mɔ atabi ésuko atabi kǝtsyǝkɔ bǝ lǝ mbǝǝ, lǝ nnyǝ nnya kutǝkǝ?’ ");
INSERT INTO lip_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Mfó nya onamute ǝmǝ lɛtɛyi nkǝ, ‘Mɔmɔ, lɛ atabi nyamfo afo lǝ wǝ ani lǝ befi nnya bitǝ nwǝ nkpe akpi lefosi.’ ");
INSERT INTO lip_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Itsyise utidi wǝ nkpe asaa, wǝ ke bonsi boofi ditsyuǝ bakpe bawunsǝ nɛ. Nya utidi wǝ kulesa lentee, sɛkɛɛ nte wǝ tsyaa, bɔɔlɛ ni bafo wǝ lǝ ani. ");
INSERT INTO lip_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Nya uyifoyifo bimba ǝmfo alɛɛ, beto wǝ bekpe lǝ ketuntu ka nkpe lǝ lekple. Kaka mfóo, wuwi keku unǝ wǝ animi. ");
INSERT INTO lip_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Lefe nǝ Utidi Eto Ubi ǝmǝ luubǝ lǝ wǝ diyǝnde ǝsuǝ ku Onanto eto batɔnkpe kenkee, wuusiǝ lǝ wǝ lekankpomɛ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Nya kawunsiǝ eto ese eto betidi kenke lɔɔbɔ bǝńyǝ lǝ wǝ ǝnǝmi. Nya wuusǝnsǝ mǝ lǝ akpa ǝnuǝ fe kase nwǝ laayɛnko bebuki leesǝnsǝ basamu kǝlǝkǝ lǝ bate nti. ");
INSERT INTO lip_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Wuuńyǝsǝ betidi sɛɛ lǝ wǝ kodiani, nya wuutǝ mba ni betidi bua ńyǝ lǝ wǝ kǝmǝni. ");
INSERT INTO lip_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Nya Oka ǝmǝ lɔɔtɛyi mba ńyǝ wǝ lǝ kodiani nkǝ, ‘Bibǝ, mi mba mɔ anto lékpo atsyɔ! Bibǝ bidufǝ lǝ sekakedikɔ ka bálɔ bǝtsyǝ itǝ mi idu taa kawunsiǝ eto ketsyikokɔ ke. ");
INSERT INTO lip_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kukpɛnsɛ álɛ mɛ nya bítǝ mɛ lesa míndi, utukuɛ álɛ mɛ, nya bítǝ mɛ ntu mínnǝ. Nyifo ɔfɔ nya béfo mɛ békpe lǝ mi ayo. ");
INSERT INTO lip_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Lefe nǝ mínyɛ leyaa, bítǝ mɛ kafia nti. Nya lefe nǝ mínlɛ bufii, bɛlɛ mɛ ola. Lefe nǝ bákpe mɛ lǝ diyo, bíbǝ bebe mɛ.’ ");
INSERT INTO lip_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Mfó nya betidi sɛɛ bamǝ lɔɔtɔ wǝ bǝnkǝ, ‘Bonamute, dimanfe búnyǝ kukpɛnsɛ nlɛ fǝ fɛ bútǝ lesa fédi, nye bútǝ fǝ ntu fǝnǝ? ");
INSERT INTO lip_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Dimanfe búnyǝ fǝ ɔfɔ fɛ bófo fǝ nye fányɛ leya bútǝ fǝ kafia féti? ");
INSERT INTO lip_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Dimanfe bɔ́nɔ bǝ alɛ bufi nye bǝ akɛ lǝ diyo fɛ búbǝ bóbe fǝ?’ ");
INSERT INTO lip_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Mfó nya Oka ǝmǝ luutǝ mbuayɛ nkǝ, ‘Nlɛ mi bɔtɛyi minkǝ, lefe saa nǝ fáwunsǝko utsyuǝ wǝ lǝmbǝ dibu saa lǝ mɔ bayimi bamfo ntii, mɔ féyifo fǝtǝ.’ ");
INSERT INTO lip_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Mfó wɔɔtɛyi mba ńyǝ lǝ wǝ kǝmǝni nkǝ, ‘Bidu mɛ lǝ ɔflɔ, mi mba Onanto díkudi! Bisu bidufǝ lǝ ditefɛnku manlo nǝ Onanto létsyaka útǝ Obonsam ku wǝ batɔnkpe! ");
INSERT INTO lip_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kukpɛnsɛ álɛ mɛ, fɛɛ bɛni bíǝntǝ mɛ lesa ndi. Utukuɛ álɛ mɛ, fɛɛ bíǝntǝ mɛ ntu nko ke. ");
INSERT INTO lip_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nyifo ɔfɔ wǝ díbǝ ɔ́sɔnɔ mi, tsya bíamfo mɛ. Nyɛ leya tsya bíenti mɛ kafia. Nnɔ bufi, bákpe mɛ lǝ diyo, fɛɛ bíǝmbǝ bisiǝsǝ mɛ.’ ");
INSERT INTO lip_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Mfó buutǝ wǝ mbuayɛ bǝnkǝ, ‘Boanto, lemanfe búnyǝ kukpɛnsɛ lɛlɛ fǝ, nye ututkuɛ lɛ fǝ, nye féyifo ɔfɔ, nye fányɛ leya, nye fanlɛ bufi, nye fakɛ lǝ diyo fɛ bóǝmbǝ bobe nye bɔ́wunsǝko fǝ?’ ");
INSERT INTO lip_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Oka ǝmǝ ebutǝ mbuayɛ nkǝ, ‘Nlɛ mi bɔtɛyi minkǝ, lefe nǝ eto lefe bíenyifo kasɛɛ bítǝ betidi ba bíembu kulesa lǝ mɔ bǝtsyuǝ bamfo ntii, mɔ uni bíenyifo kulesa bitǝ!’ ” ");
INSERT INTO lip_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Yesu átɛyi ólosǝ nkǝ, “Nyaso boofi mba mfo batsyese kanyi kǝnyǝkɔ itǝ manlo manlo. Nya betidi sɛɛ bamfóo, mǝ ebunyǝ nkpǝ bo lǝmbɔkɛ kalokɔ kulefe kulefe.” ");
INSERT INTO lip_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Se Yesu lɛtɛyi asa nyamfo kenke ólosǝǝ, ɔ́tɛyi wǝ bakasebi nkǝ, ");
INSERT INTO lip_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Iyifo mi bote bǝnkǝ ibu eyi ǝnuǝ lǝ Ukpǝ Asa Bo Ɔ́yila eto Diyi nǝmǝ lǝ leyoo, nya boofi Utidi Eto Ubi bǝtǝ bǝ basɔ wǝ bamanklasǝ lǝ kuyi ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Nya besumunyǝ ninǝ ku umǝ eto beninǝ dísu bátsya lǝ Usumunyǝ ninǝ Kenke Kayafa eto diyo. ");
INSERT INTO lip_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Befi nsusu bǝ boomuǝ Yesu kalɔkalɔ lǝ balo wǝ. ");
INSERT INTO lip_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Bátɛyi tsya bǝnkǝ, “Yanle bǝ bumuǝ wǝ lǝ diyi nǝmǝ budi kǝmiǝ, lenni nko betidi bamǝ ebunyǝnki bataka bǝńyǝ bo lǝ ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu ésu Simon wǝ dífi bufi sia eto diyo lǝ Betania. ");
INSERT INTO lip_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Lefe nǝ Yesu nsi ɔnlɛ budii, usio utsyuǝ ǝbǝ wǝ ɔflɔ, wǝ dítsyi nnuǝbi alabasta eto dituntu nǝ ókpo nnuǝbi tɔ bo laanyi fififi, bo léfo koya tinti óboko mfó, nya úfi mu ókpo Yesu lǝ disi. ");
INSERT INTO lip_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Se Yesu eto bakasebi dínyǝ nyamfoo, kafo ányi mǝ. Bátɔ ǝsuǝ bǝnkǝ, “Beso óbiasǝ nnuǝbi bomfo nko? ");
INSERT INTO lip_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Boofo nnuǝbi bomfó boté itǝ koya kplɛ, befi atabi nyamǝ bǝtǝ bakombo!” ");
INSERT INTO lip_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Se Yesu lɛnɔ lesa nǝ banlɛ bɔtɛyii, ɔ́tɛyi mǝ nkǝ, “Beso bɛnlɛ usio ǝmfo bule? Lesa sɛɛ dini úyifo útǝ mɛ. ");
INSERT INTO lip_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Bakombo kpe mi lenti lefe saa. Fɛ, mɔɔ inni lefe saa mɔɔkɛ mi lǝ ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Se usio ǝmfo dífi nnuǝbi bomfo ókpo mɛ lǝ ǝsuǝ, ɔ́lɔ mɛ utsyǝ itǝ mɔ bubike. ");
INSERT INTO lip_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nlɛ mi bɔtɛyi sitinti minkǝ kawunsiǝ eto kaka ke boobe Ditiki Sɛɛ nǝmfo letsyaa, boofi nnya usio ǝmfo díyifo bakakloma wǝ.” ");
INSERT INTO lip_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Mfó nya bakasebi lefosi inuǝ bamǝ eto ɔni, wǝ baakpo Yuda Iskariot dísu besumunyǝ ninǝ ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Nya úsu ɔ́tɔ mǝ nkǝ, “Be biutǝ mɛ lǝ ndu Yesu ntǝ mi?” Bákla sika flubia fosi ǝtsyǝ béfi bǝtǝ wǝ. ");
INSERT INTO lip_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Idu lǝ lefe nǝmfóo, útsyiko esu bɔbɛbɛ kase wuudu Yesu utǝ mǝ. ");
INSERT INTO lip_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Lǝ Abolo Menyenki eto Eyididi eto diyi tutɛ ǝsuǝǝ, bakasebi bamǝ ǝbǝ Yesu ɔflɔ nya bátɔ wǝ bǝnkǝ, “Sie faala fǝ bɔlɔ butsyǝ butǝ fǝ itǝ Ukpǝ Ása Bo Ɔ́yila eto diyi nǝmǝ budi?” ");
INSERT INTO lip_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ɔ́tɛyi mǝ nkǝ, “Bisu osani utsyuǝ ǝmǝ ɔflɔ lǝ umǝ ǝmǝ lǝ bɛtɛyi wǝ biǝ, ‘Oteasa nkǝ, “Mɔ lefe éboyo. Mɔ ku mɔ bakasebi ebudi Ukpǝ Ása Bo Ɔ́yila eto didisa nǝmǝ lǝ fǝ diyo.” ’ ” ");
INSERT INTO lip_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Bakasebi bamǝ éyifo fe kase Yesu lɛtɛyi mǝ, nya bánwa Ukpǝ Ása Bo Ɔ́yila eto didisa nǝmǝ bǝtsyǝ mfó. ");
INSERT INTO lip_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Se ditsyitsyo lefe léyoo, Yesu ku wǝ bakasebi lefosi inuǝ bamǝ ǝbǝ bǝsiǝ kasɔ itǝ lesa budi. ");
INSERT INTO lip_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Lǝ lesa nǝmǝ kedikɔɔ, Yesu átɛyi mǝ nkǝ, “Nlɛ mi bɔtɛyi minkǝ, mi nti eto ɔni ebudu mɛ utǝ.” ");
INSERT INTO lip_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ditiki nǝmfo ǝlǝ bakasebi bamǝ tinti nya bétsyiko wǝ bɔtɔ ɔni ɔni bǝnkǝ, “Bonamute, mɔ fanlɛ lee?” ");
INSERT INTO lip_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesu ǝtǝ mbuayɛ nkǝ, “Utidi wǝ bonko wǝ nlɛ kɔni bokpe lǝ ɔkpɛ ɔni kedi uni luudu mɛ utǝ. ");
INSERT INTO lip_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mɔ, Utidi Eto Ubi, ebukpǝ fe kase báwɔni lǝ Awɔnisa Kɛnkɛ eto Kukue ǝsuǝ. Fɛɛ mbɔbɔɛ itǝ utidi wǝ luudu Utidi Eto Ubi utǝ. Lǝ nnya ete bánle utidi ǝmǝ eni ɛlɛkɛ itǝ wǝ eso.” ");
INSERT INTO lip_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yuda wǝ lǝǝbǝ Yesu budu kǝtǝ tsya átɔ nkǝ, “Oteasa, sitinti inni mɔ fanlɛ, lee?” Yesu ǝtǝ mbuayɛ nkǝ, “Fǝ lɛtɛyi.” ");
INSERT INTO lip_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Se banlɛ lesa budii, Yesu éfi abolo, nya ɔ́sɔ ani nya úbudi wǝ nya úfi útǝ wǝ bakasebi ɔ́tɛyi nkǝ, “Befo lǝ bidi. Nyamfo ni mɔ ǝsuǝ eto sinǝ nɛ.” ");
INSERT INTO lip_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Nya úfi lɛkɔbe ku nte nya ɔ́sɔ Onanto ani, nya úfi útǝ mǝ nkǝ, “Mimblɛ fo binǝ. ");
INSERT INTO lip_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Nyǝ mɔ kɔtɔ ko ni kakle lǝ Onanto ku wǝ betidi eto nti. Kɔtɔ ko minfi minlɛ bokpo kasɔ lǝ betidi kpǝ eto disi, bǝ lǝ Onanto lǝ ufi mǝ abua ɔtsyɛ mǝ. ");
INSERT INTO lip_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nlɛ mi bɔtɛyi sitinti minkǝ, mensiembunǝ nte bomfo eto okle isu ese lefe nǝ mɔ ku mi luunǝ nte fɔfɔ lǝ mɔ Anto eto sekakedikɔ.” ");
INSERT INTO lip_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Nyamfo eto kamaa, bésǝ kusǝ bátɛsǝ Onanto, nya bédu bésu Nnuǝbi eto Eyi eto Kɔtini ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Nya Yesu lɛtɛyi mǝ nkǝ, “Mmi eto ketsye kamfoo, mimblɛ ebutsyetsyi bidu mɛ lǝ ɔflɔ, nya mɔ mate luubu. Itsyise Awɔnisa Kɛnkɛ eto Kukue átɛyi nkǝ, ‘Onanto ebolo nwǝ lǝǝtsyǝ basamu bamǝ nya basamu bamǝ luusǝnsǝ.’ ");
INSERT INTO lip_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Fɛɛ lǝ batakasǝ mɛ betsyiko ɔkɔmǝǝ, mɔɔtɔ mi sɛtɔ nsu Galilea.” ");
INSERT INTO lip_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petro éfe kɛnyɛ ɔ́tɛyi Yesu nkǝ, “Lǝ bafɛfɛ kenke ani fǝ tsyaa, memboyani fǝ ntsyǝ kulefe!” ");
INSERT INTO lip_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Mfó nya Yesu lɛtɛyi Petro nkǝ, “Nlɛ fǝ bɔtɛyi minkǝ ketsye kamfo fɛ ukusɛ luutǝ kɛnyɛ, ǝbɔtɛyi sitsyǝ fǝnkǝ enyi mɛ.” ");
INSERT INTO lip_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petro ǝtǝ mbuayɛ nkǝ, “Mǝmbɔni fǝ kulefe, lǝ ibǝ bǝ bonko fǝ kpe kulaa tsya.” Nya bakasebi fɛfɛ kenke tsya lɛtɛyi nko. ");
INSERT INTO lip_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Nya Yesu ku wǝ bakasebi dísu kaka baakpo Getsemane, nya ɔ́tɛyi mǝ nkǝ, “Bisiǝ mfo lǝ nsu sɛtɔ mǝ nsu nto ola.” ");
INSERT INTO lip_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ókpa Petro ku Sebedeo eto bebi inuǝ bamǝ ɔ́yɛnko. Údufǝ lǝ kawɛndo ǝsuǝ, nya útsyiko butinkǝ kekleke. ");
INSERT INTO lip_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Nya ɔ́tɛyi mǝ nkǝ, “Kanyi ka nkpe mɛ lǝ utu fui tinti bǝ kába mɛ ǝsuǝ. Bisiǝ mfo lǝ bikase ku mɛ.” ");
INSERT INTO lip_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ɔ́yɛ úsu sɛtɔ sɛkɛ nya ókpo lǝ kasɔ úfusǝ ǝnǝmi, nya óto ola nkǝ, “Mɔ Anto, lǝ yɔɔlɛkɛɛ, takasǝ bulǝ bomfo lǝ mɛ ǝsuǝ. Fɛɛ menyifo lǝ mɔ lelabi ǝsuǝ bomu lǝ fǝ lelabi ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Se úsinkli úsu bakasebi itsyǝ bamǝ ɔflɔ, únyǝ nkǝ bálabe selabe, nya ɔ́tɔ Petro nkǝ, “Nyaso mi basini bamfo embofo ǝnǝ butǝkǝ ku mɛ itǝ lebombosɔsɔ lɔni hã ete? ");
INSERT INTO lip_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Bitǝkǝ ǝnǝ lǝ beto ola bǝ biembudufǝ lǝ botokabe ǝsuǝ. Lɛwɔnɔ nǝmǝ lɛ bola, fɛɛ ǝsuǝ eto sinǝ ayɔkpɔ.” ");
INSERT INTO lip_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yesu esi úsu dinuǝfǝ úsu oto ola ɔ́tɛyi nkǝ, “Mɔ Anto, lǝ kanyi eto lɛkɔbe nǝ mǝǝbǝ bunǝ mfo embofe mɛ, nya iyifo fǝ lelabi bǝ nnǝ ni kokooko, nyalɛ tǝ lǝ ibǝ itǝ nko.” ");
INSERT INTO lip_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Se úsinkli úbǝ bioo, únyǝ nkǝ bakasebi bamǝ si balɛ selabe ko, nya bannlɛ ǝnǝmi bofo buminkli kulaa tsya. ");
INSERT INTO lip_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yesu esi údu lǝ mǝ ɔflɔ ditsyǝfǝ úsu óto ola fe kase óto ibǝ éfe. ");
INSERT INTO lip_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Nya úsinkli úbǝ bakasebi bamǝ ɔflɔ nya ɔ́tɛyi mǝ nkǝ, “Bisi belabe selabe bɛlɛ ɔnwɛ butsyǝ? Bebe! Lefe nǝmǝ eboyo bǝ befi Utidi Eto Ubi ǝmǝ bakpe lǝ betidi bua eto ani. ");
INSERT INTO lip_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Betaka lǝ budu. Bebee, nwǝ nlɛ mɛ budu kǝtǝ ebɔfi.” ");
INSERT INTO lip_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesu ǝńyǝ ɔlɛ mǝ etiki budinko fɛ Yuda wǝ ni lefosi inuǝ bamǝ eto ɔni díbǝ údufǝ. Betidi ba ni besumunyǝ ninǝ ku batɔnkotɔnko ba bǝlǝkǝ ǝtǝkǝko wǝ, nya béntsyi nlande ku keyi. ");
INSERT INTO lip_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Udundukǝtǝ ǝmǝ ǝtǝ báte batɔnsǝ bǝ, “Utidi wǝ mɔɔbuta nsiǝsǝǝ, wǝ ni utidi wǝ bɛnlɛ bɔbɛbɛ nɛ. Bimuǝ wǝ.” ");
INSERT INTO lip_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Yuda ésu Yesu ɔflɔ nya lǝ kase únyǝ wǝ koo, ɔ́tɛyi wǝ nkǝ, “Oteasa, diyuǝsǝ itǝ fǝ.” Mfó nya ɔ́buta wǝ. ");
INSERT INTO lip_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesu ǝtǝ wǝ mbuayɛ nkǝ, “Ɔhɔ, kɔse lǝ eyifo lesa nǝ fǝbǝ keyifokɔ!” Mfó nya betidi bamǝ díbǝ Yesu ɔflɔ nya bǝmuǝ wǝ nya bákɔbe wǝ kekleke. ");
INSERT INTO lip_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Mba ntǝkǝko Yesu eto ɔni ǝlǝkǝ wǝ kalande nya ówe Usumunyǝ Ninǝ eto ndomunyǝ eto koto. ");
INSERT INTO lip_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Mfó nya Yesu lɛtɛyi wǝ nkǝ, “Fi fǝ kalande akpe lǝ ke kakpekɔ. Betidi ba leetsyi kalande lǝ betidi ǝsuǝǝ, kalande ǝsuǝ baayɛ kǝkpǝ. ");
INSERT INTO lip_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Biante biǝ moofo bɔwunsǝko bɔtɔ ketsyiko mɔ Anto ɔflɔ lee, nya lamfolamfoo, wootsyese wǝ batɔnkpe eto bamamanyǝ eto akpa lefosi ǝnuǝ itsyi kato? ");
INSERT INTO lip_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Fɛɛ lǝ ibǝ nkoo, ntsyǝ fɛ nnya báwɔni bákpe lǝ Awɔnisa Kɛnkɛ eto Kukue luubǝ itǝ?” ");
INSERT INTO lip_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Nya Yesu dítsyi ǝnǝmi útǝ sitiditu siamǝ nya ɔ́tɔ mǝ nkǝ, “Beso ele bǝ bitsyi keyi ku nlande bibǝ biǝ bibǝ mɛ kǝmuǝkɔ fe nwǝ ńyǝ lǝ Aba ǝsuǝ? Diyi saa, nkɛ lǝ Onanto eto kesumuyo mfó nkate asa, fɛɛ bíǝmmuǝ mɛ. ");
INSERT INTO lip_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Asa nyamfo kenke ǝbǝ nko bǝ lǝ asa nnya bǝnyǝlǝkǝtidi lɛtɛyi bǝtsyǝ lǝ Awɔnisa Kɛnkɛ eto Kukue ǝsuǝ lǝ ibǝ itǝ nko.” Mfó nya wǝ bakasebi kenke dítsyetsyi bédu lǝ wǝ ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Mba dímuǝ Yesu ákpa wǝ bésuko Usumunyǝ Ninǝ Kenke Kayafa eto diyo kaka besumunyǝ ninǝ ku umǝ eto beninǝ ku afi eto bateasa létsya bensi. ");
INSERT INTO lip_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Petro ǝtǝko mǝ kama kama úsu taa Usumunyǝ Ninǝ Kenke eto lekpata kafo. Úsu úsiǝ lǝ bamamanyǝ bamǝ ɔflɔ nkǝ lǝ obe kase ditiki nǝmǝ dubǝ ibǝ. ");
INSERT INTO lip_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Besumunyǝ ninǝ ku bakponkpo ba dísiǝ mfó kenke ábɛbɛ betidi ba luubǝ bala etiki bǝtǝkǝ Yesu lǝ bǝnyǝ kusu balo wǝ. ");
INSERT INTO lip_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Fɛɛ bǝnnyǝ kulesa saa, ite bǝ betidi kpǝ ǝbǝ bála bidia bǝtǝkǝ wǝ lǝ ǝsuǝ tsyafɛ. Betidi inuǝ bǝtsyuǝ ǝbǝ ");
INSERT INTO lip_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","nya bátɛyi bǝnkǝ, “Utidi ǝmfo átɛyi nkǝ, ‘Mooba Onanto eto kesumuyo nǝmfo, nya lǝ eyi ǝtsyǝ ǝsuǝǝ, muusinkli nto ni nńyǝnsǝ.’ ” ");
INSERT INTO lip_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Usumunyǝ Ninǝ Kenke átaka úńyǝ nya ɔ́tɔ Yesu nkǝ, “Anlɛ etiki nnya banlɛ bɔtɛyi kǝtǝkǝ fǝ lǝ ǝsuǝ mfo bɔnɔ? Ǝmbǝ Kulesa fɔɔtɛyi lǝ nnya ǝsuǝ?” ");
INSERT INTO lip_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Fɛɛ Yesu édi bi, wóantɛyi kulesa. Usumunyǝ Ninǝ Kenke ǝmǝ esi ɔ́tɛyi wǝ nkǝ, “Lǝ Onanto wǝ nsi nkpe eto diye ǝsuǝǝ, nlɛ fǝ bɔtɛyi minkǝ tɛyi bo lǝ fǝ ni Onanto eto Ubi wǝ Bákpo Ɔhile Utsyǝ ǝmǝ.” ");
INSERT INTO lip_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Mfó nya Yesu dítǝ mbuayɛ nkǝ, “Ee, ite fǝ kase fátɛyi. Fɛɛ nlɛ mi bɔtɛyi minkǝ idu mɔmɔ ɛntɔɔ, buinyǝ Utidi Eto Ubi se unsi lǝ Ǝsuǝalenyǝ Kenke eto kodiani. Nya biunyǝ se unsi lǝ asɔmiloku ǝsuǝ utsyi kato ɔnlɛ bubǝ!” ");
INSERT INTO lip_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Lǝ nyamfo ǝsuǝǝ, Usumunyǝ Ninǝ Kenke ǝmǝ áfuadi wǝ awu ku lɛblɔfi nya ófa ɔ́tɛyi nkǝ, “Édi mbusiotiki! Boensihiã badansiɛ saa! Bíɔnɔ mbusiotiki nnya údi mfo! ");
INSERT INTO lip_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ntsyǝ bibu?” Mǝmblɛ ǝtǝ mbuayɛ bǝnkǝ, “Údi dikpi nya uńyǝ utǝ ukpǝ!” ");
INSERT INTO lip_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Nya bétufǝ ntufǝ bákpo wǝ lǝ ǝnǝmi nya báblɛ wǝ. Nya mba lɛsɔ wǝ lǝ atosi, ");
INSERT INTO lip_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","átɛyi bǝnkǝ, “Lǝ Nwǝ Onanto Lékpo Ɔhile Utsyǝ fenii, tɛyi bo futsyǝ lɛsɔ fǝ!” ");
INSERT INTO lip_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Petro ǝsiǝ lǝ lekple lǝ kpakpaakpe mfó fɛ Usumunyǝ Ninǝ Kenke eto usumubisiobi díbǝ mfó nya ɔ́tɛyi wǝ nkǝ, “Fintsya ǝtǝkǝko Yesu wǝ ditsyi Galilea eto kasɔ.” ");
INSERT INTO lip_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Fɛɛ ɔ́ni nnya lǝ betidi bamfo kenke eto ǝnǝmi ɔ́tɛyi nkǝ, “Mante lesa nǝ fanlɛ bɔtɛyi mfo!” ");
INSERT INTO lip_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Nya údu mfó úsu úńyǝ lǝ diyo nǝmǝ eto kesie. Usumubisiobi bamba tsya ǝnyǝ Petro nya ɔ́tɛyi mba díńyǝ mfó nkǝ, “Wuntsya ǝtǝkǝko Yesu Nasaretnyǝ ǝmǝ.” ");
INSERT INTO lip_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Bio Petro esi ɔ́ni nya óka ntamu ɔ́tɛyi nkǝ, “Minyi osani ǝmǝ ko!” ");
INSERT INTO lip_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Yanklɛ fɛ mba ńyǝ mfo díbǝ bátɛyi Petro bǝnkǝ, “Ɛkpɛ mǝ ɔni feni, itsyise fǝ etikididi ǝǝlǝkǝ fǝ kate wuee.” ");
INSERT INTO lip_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Nya Petro lɛtɛyi nkǝ, “Ekpe lǝ lesa saa bǝ ɔnukualɛ minlɛ bɔtɛyi minkǝ Onanto lǝ unǝ mɛ koto lǝ sidia minlɛ bɔtɛyi!” Lefe nǝmfo tutuutu nnya ukusɛ dítǝ kɛnyɛ. ");
INSERT INTO lip_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Nya Petro lékloma lesa nǝ Yesu lɛtɛyi nkǝ, “Fɛ ukusɛ luutǝ kɛnyɛɛ, ǝbɔtɛyi sitsyǝ fǝnkǝ enyi mɛ.” Ɔ́bɔ úsu lekple nya úwi keku kekleke. ");
INSERT INTO lip_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Se kale dísiǝ ku olesiǝtu, Besumunyǝ ninǝ ku umǝ eto beninǝ kenke átsya nya báse uyi bǝ boolo Yesu. ");
INSERT INTO lip_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Bákpe wǝ lǝ amena nya bákpa wǝ bésu bákpe Romafɔ eto Aba eto Uninǝ Pilato lǝ ani. ");
INSERT INTO lip_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Se Yuda, wǝ dídu Yesu lɛnɔ nkǝ bálo wǝ dikpǝnkpii, ífi wǝ tinti, nya úsinkliko sika flubia awosi ǝtsyǝ nyamǝ úsuko besumunyǝ ninǝ ku umǝ eto beninǝ bamǝ. ");
INSERT INTO lip_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ɔ́tɛyi nkǝ, “Nyifo kabua bǝ mfi utidi wǝ dímenyifo kabua ntǝ miǝ balo!” Bǝtǝ mbuayɛ bǝnkǝ, “Nyamfo manka bo nkpǝ. Fǝ etiki ni nyamfó!” ");
INSERT INTO lip_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yuda éfi atabi nyamǝ óto ókpe lǝ Onanto eto Disumuyo mfó, nya usu ókpe ukuǝ úkpe. ");
INSERT INTO lip_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Nya besumunyǝ ninǝ bamfó lɛsɛ atabi nyamǝ nya bátɛyi bǝnkǝ, “Atabi nyamfo eyifo kɔtɔ eto atabi, nya iyifo lesa nǝ ńyǝ lǝ bo kesumu eto kɔfi ǝsuǝ bǝ bufi atabi nyamfo bokpe lǝ bo kesumu eto otobe. Bo kɔfi eti nyamfo kusu.” ");
INSERT INTO lip_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Se bákpe disii, báse nya uyi bǝnkǝ befi atabi nyamǝ bésu báya Asa eto Otonto eto Kasɔ itǝ bafɔ eto kebikekɔ. ");
INSERT INTO lip_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Nyamfo esoo, bǝtǝkǝ kasɔ kamǝ diye bǝ Kɔtɔ eto Kasɔ ibǝ ese lǝ mmi. ");
INSERT INTO lip_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Itǝ lesa nǝ Onanto eto unyɛlǝkǝtidi Yeremia lɛtɛyi útsyǝ díbǝ itǝ nkǝ, “Béfi sika flubia eto atabi fosi ǝtsyǝ, nya Israelfɔ lɛtɔnɔ bǝ boofo lǝ wǝ disi ");
INSERT INTO lip_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","béfi báya Otonto eto Kasɔ, fe kase Bonamute léla nkǝ nyifo.” ");
INSERT INTO lip_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Bákpa Yesu báboko Romafɔ eto Aba eto Unyɛsiǝ Ninǝ Pilato eto ǝnǝmi. Nya ɔ́tɔ wǝ nkǝ, “Fǝ ni Yudafɔ eto Oka ǝmǝ?” Yesu ǝtǝ mbuayɛ nkǝ, “Ee. Átɛyi kukɔnɔ.” ");
INSERT INTO lip_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Fɛɛ wántɛyi kulesa itsyi lǝ besumunyǝ ninǝ ku umǝ eto beninǝ eto nyɛ bo banlɛ bola kǝtǝkǝ wǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Mfó nya Pilato lɛtɔ wǝ nkǝ, “Etiki nnya banlɛ bɔtɛyi lǝ fǝ ǝsuǝ mfo manka fǝ lee?” ");
INSERT INTO lip_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Fɛɛ íyifo Aba eto uninǝ ǝmǝ yani tinti se Yesu lɛni wémfe kɛnyɛ útǝ mbuayɛ saa. ");
INSERT INTO lip_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ídi Aba eto uninǝ lesa nǝ úkeyifo lɛlɛ saa lǝ bǝǝbǝ Ukpǝ Ása Bo Ɔ́yila eto diyi budi, bǝ oyani mba béti bákpe lǝ Aba eto diyo eto ɔni wǝ betidi kpǝ bamǝ lɛtɔ, utǝ mǝ. ");
INSERT INTO lip_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Lǝ lefe nǝmfóo, mba bákpe lǝ diyo mfó eto ɔni akɛ, wǝ betidi nyi kukɔnɔ nya baakpo wǝ bǝ Baraba. ");
INSERT INTO lip_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Nyaso lefe nǝ betidi kpǝ díbǝ bátsyaa, Pilato átɔ mǝ nkǝ, “Owoe biala biǝ nyani ntǝ mi? Baraba lee, lee Yesu wǝ betidi laakpo bǝ Nwǝ Onanto Lékpo Ɔhile Utsyǝ?” ");
INSERT INTO lip_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Úyifo nko itsyise óte nkǝ kekisi eso Yudafɔ eto beninǝ bamfo lékpa wǝ báboko. ");
INSERT INTO lip_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Lefe nǝ Pilato nsi ɔnlɛ lekpo nǝmǝ bokpoo, wǝ usiǝ átsyese wǝ ɔtɔnkpe nkǝ, “Lǝkǝ fǝ ani lǝ utidi wǝ dímenyifo kabua saa mfo eto etiki ǝsuǝ, itsyise nsiǝ kola kǝnǝ eto ketsye itsyi lǝ wǝ ǝsuǝ, nnya dítǝ sikpi dímuǝ mɛ tinti!” ");
INSERT INTO lip_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Besumunyǝ ninǝ ku umǝ eto beninǝ ábiasǝ betidi ba létsya mfo eto ato bǝnkǝ batɔ Pilato lǝ oyani Baraba utǝ mǝ lǝ balo Yesu. ");
INSERT INTO lip_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Fɛɛ Pilato átɔ betidi ba létsya mfó nkǝ, “Betidi inuǝ bamfo eto nti, nte nwǝ bela biǝ nyani ntǝ mi?” Bǝtǝ mbuayɛ bǝnkǝ, “Baraba!” ");
INSERT INTO lip_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Nya Pilato dísi ɔ́tɔ mǝ nkǝ, “Nyalɛ, be ele bǝ nyifo ku Yesu wǝ baakpo bǝ Nwǝ Onanto Lékpo Ɔhile Utsyǝ mɔmɔ?” Mǝmblɛ kenke ǝtǝ mbuayɛ bǝnkǝ, “Sɔ wǝ amanklasǝ lǝ kuyi ǝsuǝ!” ");
INSERT INTO lip_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Fɛɛ Pilato átɔ mǝ nkǝ, “Nte kabua ka úyifo?” Mfóo, bétsyiko bofa bembembe katɛyi bǝnkǝ, “Sɔ wǝ amanklasǝ lǝ uyikabie ǝsuǝ!” ");
INSERT INTO lip_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Se Pilato dínyǝ nkǝ wensiembofo kulesa buyifo lenni bulǝ ebubǝǝ, úfi ntu nya úflǝ ani lǝ sitiditu nǝmǝ eto ǝnǝmi nya ɔ́tɛyi nkǝ, “Nnyǝ mɔ ani, nnyǝ mɔ akpa, mɔ ani ǝmbǝ lǝ osani ǝmfo eto bolo ǝsuǝ! Mi etiki ini.” ");
INSERT INTO lip_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Sitiditu siamǝ kenke ǝtǝ mbuayɛ bǝnkǝ, “Wǝ ukpǝ bǝ utǝkǝ lǝ bo ku bo bebi lǝ ǝsuǝ!” ");
INSERT INTO lip_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Mfó nya Pilato léyani Baraba útǝ mǝ. Nya se útǝ báblɛ Yesu bálosǝ, óyani wǝ útǝ nkǝ básɔ wǝ lǝ uyi ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Nya Pilato eto bamamanyǝ lékpa Yesu bésuko Aba eto uninǝ eto diyo, nya bamamanyǝ ba kenke díbǝ bátsyilama wǝ. ");
INSERT INTO lip_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Bǝlǝkǝ wǝ awu lǝ ǝsuǝ nya béfi awu sia bákpe wǝ. ");
INSERT INTO lip_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Nya béfi biyu bédi lekpakpa bétsyisǝ wǝ lǝ disi fɛ béfi uyi bákpe wǝ lǝ kodiani. Nya báse akonki lǝ wǝ ǝnǝmi fe oka seka nya bǝmǝ wǝ bátɛyi bǝnkǝ, “Yuu, yuuduu,! Yudafɔ eto Oka lǝ usiǝ nkpǝ kɛntsyɛɛ!” ");
INSERT INTO lip_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Bétufǝ ntufǝ bákpo wǝ lǝ ǝsuǝ nya bálɛ uyi ǝmǝ báfo básɔ wǝ lǝ disi. ");
INSERT INTO lip_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Se bǝmǝ wǝ bálosǝ nkoo, bǝlǝkǝ wǝ awu sia nyamǝ lǝ ǝsuǝ nya besi béfi wǝ awu nyamǝ bákpe wǝ. Nya bákpa wǝ báyɛnko bésu wǝ kasɔkɔ lǝ uyikabie ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Lefe nǝ bédu lǝ umǝ báyɛ bantɔɔ, bátsyako osani utsyuǝ wǝ ditsyi Kirene wǝ baakpo Simon. Bamamanyǝ bamǝ áhiɛ wǝ bǝ ofo Yesu eto uyikabie komǝ utsyi. ");
INSERT INTO lip_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Nya bésu báyo kaka baakpo Golgata eto kasɔnɔnɔ ni Ditidisikɔbe ku kalua. ");
INSERT INTO lip_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Bǝtǝ Yesu nte bo bátsyakasǝ ku kofa ko nkpe kalo bǝ unǝ. Fɛɛ se útu mu óbee, ɔ́ni wǝnnǝ mu. ");
INSERT INTO lip_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Mfó nya bamamanyǝ bamǝ lɛsɔ wǝ bamanklasǝ lǝ uyikabie ǝsuǝ, nya bákpo asa basɛɛ fɛ bésie wǝ awu bǝtǝ bǝtsyuǝ. ");
INSERT INTO lip_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Nya kamaa, bǝsiǝ mfó bákase wǝ. ");
INSERT INTO lip_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Lǝ wǝ disi katoo, báwɔni asa bámanklasǝ lǝ uyi ǝmǝ ǝsuǝ. Nnya báwɔni bǝnkǝ lesa nǝ eso bálo wǝ ni bǝ, “Nnyǝ Yesu, Nwǝ Ni Yudafɔ Eto Oka.” ");
INSERT INTO lip_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Básɔ beyu inuǝ bǝtsyuǝ tsya lǝ uyikabie ǝsuǝ bákɔ lǝ Yesu ǝsuǝ. Ɔni áfaka lǝ wǝ sediani nya ɔni tsya léfaka lǝ wǝ simǝni. ");
INSERT INTO lip_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Betidi ba kenke lɛyɛ mfó étinkǝsǝ mǝ esi nya báka Yesu fefe. ");
INSERT INTO lip_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Bátɛyi bǝnkǝ, “Fǝ ni nwǝ lɛtɛyi fǝnkǝ eboba Desumuyo Kplɛ akpo lǝ kasɔ, esinkli ato ni ǝńyǝnsǝ lǝ eyi ǝtsyǝ ǝsuǝ nɛ! Lǝkǝ fǝ ǝsuǝ, lǝ Onanto eto Ubi feni! Yifǝ lǝ uyikabie komǝ ǝsuǝ ǝbǝ kasɔ.” ");
INSERT INTO lip_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Nko ke besumunyǝ ninǝ ku afi eto bateasa ku umǝ eto beninǝ tsya dímǝ wǝ bátɛyi bǝnkǝ, ");
INSERT INTO lip_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ófo betidi bamba lǝ nkpǝ, fɛɛ wǝmbofó wǝ ǝsuǝ bulǝkǝ! Lǝ Yudafɔ eto Oka unii, ɔyifǝ lǝ kuyi ǝsuǝ mɔmɔ ubǝ, lǝ bofo wǝ bɔnɔ! ");
INSERT INTO lip_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ófó Onanto ɔ́nɔ, nya waakpadi wǝ ǝsuǝ nkǝ Onanto eto Ubi. Nyaso bitǝ lǝ bobe lǝ Onanto aala wǝǝ, lǝ ulǝkǝ wǝ mɔmɔ lǝ bobe!” ");
INSERT INTO lip_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Nko ken beyu ba ku wǝ básɔ lǝ kuyi ǝsuǝ tsya léka wǝ nɛ. ");
INSERT INTO lip_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Idu lǝ kakɔmi eto abombo lefosi ǝnuǝǝ, kawunsiǝ kenke ána tũũ isu ese lǝ ketsyitsyokɔmi eto abombo ǝtsyǝ. ");
INSERT INTO lip_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Fe abombo ǝtsyǝ etii, Yesu áfa bembembe ɔ́tɛyi nkǝ, “Eli, Eli, lama sabaktani?” Nyamfo eto kasɔ ni, “Mɔ Onanto, mɔ Onanto! Beso fáyani mɛ fǝtsyǝ?” ");
INSERT INTO lip_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Betidi bǝtsyuǝ díńyǝ mfó ánɔ lesa nǝ ɔ́tɛyi, nya bátɛyi bǝnkǝ, “Ɔlɛ Elia bokpadi!” ");
INSERT INTO lip_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Mǝ ɔni étsyetsyi nya úfi okosa wǝ bákpe lǝ nte eto sonkpe, nya úfi mu ku uyi úsuko nkǝ lǝ utǝ wǝ lǝ unǝ. ");
INSERT INTO lip_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Fɛɛ betidi bamba átɛyi bǝnkǝ, “Bińyǝ lǝ bobe! Bitǝ lǝ bobe lǝ Elia ebubǝ ulǝkǝ wǝ utsyiko kuyi komfo ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesu esi ófa bembembe nya úkpǝ. ");
INSERT INTO lip_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Lamfolamfoo, Disumuyo Kplɛ eto kafia kplɛ dísie lǝ akpa ǝnuǝ itsyi kato ibǝ kasɔ. Nya kasɔ kamǝ kenke dítinkǝ, nya aba léba. ");
INSERT INTO lip_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Edi ásini, nya Onanto eto betidi kɛnkɛ kpǝ ba díkekpǝ létaka bǝbǝ nkpǝ. ");
INSERT INTO lip_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Bábɔ lǝ mǝ edi kafo nya se Yesu létaka útsyi ɔkɔmǝ úbǝ nkpǝǝ, bésu Yudafɔ eto Umǝ Kɛnkɛ ǝmǝ kafo kaka betidi kpǝ dínyǝ mǝ. ");
INSERT INTO lip_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Se Omamanyǝ ninǝ ku bamamanyǝ ba díńyǝ bákase Yesu dínyǝ kase kasɔ dítinkǝ ku asa nnya díbǝ mfó kenkee, sikpi ǝmuǝ mǝ tinti! Nya bátɛyi bǝnkǝ, “Sitintii, utidi ǝmfo éyifo Onanto eto Ubi.” ");
INSERT INTO lip_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Besio kpǝ ba dítsyi Galilea ba díkawunsǝko Yesu ǝńyǝ lǝ kɔsɛsɛ bákabe asa nnya díbǝ. ");
INSERT INTO lip_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mǝ bǝtsyuǝ ni Maria Magdalene, ku Maria wǝ ni Yakobo ku Yosef eto ambe ku Sebedeo eto usiǝ. ");
INSERT INTO lip_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Se éyo ditsyitsyo lefee, otabinyǝ utsyuǝ wǝ baakpo Yosef, nya úyifo Yesu eto okasebi wǝ ditsyi Arimatea ǝbǝ. ");
INSERT INTO lip_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Úsu Pilato ɔflɔ nya ɔ́tɔ wǝ nkǝ lǝ ofo Yesu eto ɔkɔ. Pilato ǝtǝ kusu nkǝ befi ɔkɔ ǝmǝ bǝtǝ Yosef. ");
INSERT INTO lip_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Nyaso Yosef áfo ɔkɔ ǝmǝ nya úfi kafia flubia kǝtsyuǝ úmli wǝ. ");
INSERT INTO lip_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Nya úfi wǝ úsu úbikǝ lǝ kebikekɔ lǝ wǝ kosate eto kudi fɔfɔ ko bǝlǝkǝ lǝ koba kǝmiǝ. Nya ominansǝ leba nǝ lɛmɔ úti ko kɛnyɛ nya údu. ");
INSERT INTO lip_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria Magdalene ku Maria nuǝfǝ ǝsiǝ mfó balɛ kudi komǝ bobe. ");
INSERT INTO lip_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Nya se kale disiǝ nya ini Ɔnwɛditsyǝyii esoo, usumunyǝ ninǝ ku Farisifɔ ésu Pilato ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Nya bátɛyi wǝ bǝnkǝ, “Uninǝ, lefe nǝ odiantidi ǝmǝ dísiǝ nkpǝǝ, ɔ́tɛyi nkǝ, ‘Lǝ nkpǝǝ, bootakasǝ mɛ betsyiko ɔkɔmǝ lǝ eyi ǝtsyǝ eto kama.’ ");
INSERT INTO lip_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Nyaso tǝ lǝ bamamanyǝ lǝ base kudi komǝ kukɔnɔ isu ese diyi tsyǝfǝ nǝmǝ, kase wǝ bakasebi lembusu beyu ɔkɔ ǝmǝ bedunko batɛyi betidi bǝnkǝ ótaka utsyi ɔkɔmǝ. Lǝ ibǝ nkoo, sidia sia bɔɔtɛyi ǝbɔkɛ seso nsia kɔ.” ");
INSERT INTO lip_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Mfó nya Pilato lɛtɛyi mǝ nkǝ, “Bitǝ lǝ bamamanyǝ lǝ besu base kudi komǝ fe kase boofo.” ");
INSERT INTO lip_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Nyaso bésu bálɔ béti leba nǝ béti lǝ kudi komǝ kɛnyɛ kekleke bǝtsyǝ ko lekpo, bǝ lǝ utsyuǝ etidi ni lǝ bǝnyǝ bǝtsyǝ lekpo, nya bǝtsyǝ bamamanyǝ bǝ base ko. ");
INSERT INTO lip_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Lǝ Ɔnwɛditsyǝyi eto kamaa, ǝni Kɔsida eto kolensiǝntoo, Maria Magdalene ku Maria nuǝfǝ ésu bǝ besu babe kudi komǝ. ");
INSERT INTO lip_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Lamfolamfoo, kasɔ étinkǝ kekleke. Onanto eto Ɔtɔnkpe utsyuǝ áyifǝ utsyi kato úbǝ ɔ́minansǝ leba kplɛ nǝmǝ nya úsiǝ lǝ ni ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Wǝ ditsyǝbi ékeyǝnde fe kase ɔsi laato nya wǝ awu diflubi futututu fe aklala seka. ");
INSERT INTO lip_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Sikpi ǝmuǝ mba nlɛ mfó bose nya bétinkǝ tinti, nya bákpo kasɔ mfó fe bukpǝ békpe. ");
INSERT INTO lip_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Onanto eto Ɔtɔnkpe ǝmfó édinko besio bamǝ etiki nya ɔ́tɛyi mǝ nkǝ, “Biante sikpi! Nnyi miǝ Yesu wǝ básɔ bámanklasǝ lǝ kuyi ǝsuǝ bɛnlɛ bɔbɛbɛ. ");
INSERT INTO lip_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Umbǝ mfo! Bátakasǝ wǝ fe kase ɔ́tɛyi ɔtɔnsǝ. Bibǝ bebe kaka ólabee. ");
INSERT INTO lip_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Mɔmɔɔ, bisu mlǝ lǝ bisu bɛtɛyi wǝ bakasebi biǝ, ‘Bátakasǝ wǝ betsyiko ɔkɔmǝ úbǝ nkpǝ, nya ɔntɔ mi sɛtɔ úsu Galilea. Mfó biunyǝ wǝ nɛ.’ Bekloma nnya míntɛyi mi mfo.” ");
INSERT INTO lip_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Nyaso bédu lǝ kudi komǝ ɔflɔ lǝ sikpitete ku disuǝyuǝ tsya ǝsuǝ. Nya bétsyetsyi bǝ beesu batɛyi wǝ bakasebi. ");
INSERT INTO lip_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Lamfolamfoo, Yesu átsyako mǝ, nya ɔ́tɛyi mǝ nkǝ, “Diyuǝ itǝ mi.” Báyɛ bétu wǝ bábokosǝ ǝsuǝ kasɔ bákɔbe wǝ lǝ akpa nya bésumu wǝ. ");
INSERT INTO lip_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yesu átɛyi mǝ nkǝ, “Biante sikpi. Bisu bɛtɛyi mɔ bayimi biǝ besu Galilea, mfó buunyǝ mɛ nɛ.” ");
INSERT INTO lip_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Lefe nǝ besio bamfó dísinkli bantɔɔ, bamamanyǝ ba lése kudi komǝ ésu umǝ nya bátɛyi besumunyǝ ninǝ bamǝ asa nnya kenke díbǝ mfó. ");
INSERT INTO lip_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Besumunyǝ ninǝ bamǝ ku umǝ eto beninǝ ákpe disi béfi nsusu. Bǝtǝ bamamanyǝ bamǝ atabi eto akplɛ, ");
INSERT INTO lip_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","nya bátɛyi mǝ bǝnkǝ, “Bɛtɛyi biǝnkǝ lefe nǝ bélabe selabe ku ketsyee, wǝ bakasebi ǝbǝ béyu wǝ ɔkɔ ǝmǝ bédunko. ");
INSERT INTO lip_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Nya lǝ Romafɔ eto Aba eto uninǝ anɔ nyamfoo, buutǝ ɔnɔ kasɔ boǝ inni mi díyifo kulesa, nyaso yanle bǝ balo mi dikpi.” ");
INSERT INTO lip_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Bamamanyǝ bamǝ áfo atabi nyamǝ nya béyifo fe kase bátɛyi mǝ. Nyaso nyamfo ni ditiki nǝ lɛyɛ létsyilama Yudafɔ ntii taa mmi nɛ. ");
INSERT INTO lip_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Lǝ nnya eto kamaa, bakasebi lefosi ɔnwɛ bamǝ ábe bésu kɔtini ko nkpe lǝ Galilea ǝsuǝ kaka Yesu lɛtɛyi mǝ utsyǝ. ");
INSERT INTO lip_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Se bǝnyǝ wǝǝ, bésumu wǝ, ite bǝ mǝ bǝtsyuǝ áyaki tsya. ");
INSERT INTO lip_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesu ányi ɔfi mǝ nya ɔ́tɛyi mǝ nkǝ, “Onanto éfi kato ku kasɔ kenke eto ǝsuǝale útǝ mɛ. ");
INSERT INTO lip_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Nyaso bisu kawunsiǝ eto betidi kenke ɔflɔ lǝ biyifo mǝ mɔ bakasebi. Biflǝsǝ mǝ ntu lǝ Anto ku Ubi ku Lɛwɔnɔ Kɛnkɛ eto diye ǝsuǝ, ");
INSERT INTO lip_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","nya bete mǝ bǝ betsyue lesa saa nǝ mínte mi koto. Nya lǝ sitintii, mɔɔkɛ ku mi lefe saa, isu ese lǝ kawunsiǝ eto kalosǝkɔ.” ");
INSERT INTO lip_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Nyamfo ni Ditiki Sɛɛ itsyi lǝ Yesu Kristo wǝ ni Onanto kosate eto ubi ǝsuǝ eto ketsyikokɔ. ");
INSERT INTO lip_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Lǝ lefe kɛntsyɛ nǝ léfe mǝǝ, Onanto eto unyǝlǝkǝtidi Yesaya áwɔni utsyǝ nkǝ Onanto átɛyi wǝ ubi nkǝ, “Mootsyese ɔtɔyɛ ntɔnsǝ. Wǝ lɔɔlɔ betidi utsyǝ itǝ fǝ bubǝ. ");
INSERT INTO lip_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ǝbɔnɔ se nkomǝ eto utidi ǝmfo luusu kabe letsya lǝ mfiminti akatɛyi nkǝ, ‘Bimuǝ ǝsuǝ bitsyǝ itǝ Bonamute ǝmǝ. Bimuǝ ǝsuǝ kukɔnɔ itǝ wǝ bubǝ.’ ” ");
INSERT INTO lip_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Nko eto ɔtɔyɛ ǝmǝ ni Yohanes. Wǝ ni díbǝ ɔkɛ lǝ mfiminti kaka úkǝflǝsǝ betidi ntu lǝ ketu fe kase Yudafɔ leeyifo. Nya ɔnlɛ bofa kabe letsya nkǝ ele bǝ betidi tsyi mǝ akɔɛsi bawuninsǝ lǝ bayɛ asa bua buyifo lǝ bafo ntu flǝsǝflǝsǝ eto lekpa lǝ Onanto lǝ ufi mǝ abua ɔtsyɛ mǝ. ");
INSERT INTO lip_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Betidi kpǝ etsyi Yudea eto kasɔ ku mǝ umǝnkplɛ wǝ baakpo Yerusalem nya bésu mfiminti bomfó bǝ lǝ banɔ Yohanes eto kɔtɔ ko bákpe wǝ eto etiki. Bǝlǝkǝ mǝ abua báte Onanto nya Yohanes díflǝsǝ mǝ ntu lǝ ketu ka baakpo Yordan. ");
INSERT INTO lip_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohanes ákpe ɔflimu eto bisǝ eto awudindi nya úfi kubukikuǝ eto abɔsu ókle wǝ nkɛ. Didisa nǝ úkǝdi didi bablɔ ku bǝkpǝsǝ. ");
INSERT INTO lip_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Wǝ etiki nnya ɔnlɛ ditsya bobe ni nkǝ, “Utidi wǝ ntǝkǝ mɛ kama ɔnlɛ bubǝǝ, so mɛ famfamfa nya yǝńyǝ itǝ bǝ ńyǝ lǝ wǝ kɛnyɛ nyifo wǝ keyifo blɛmblɛ. ");
INSERT INTO lip_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Mɔɔ, ntu eto buflǝsǝ eto lekpa ete maafo buyifo. Fɛɛ wǝ ebufi Onanto eto Lɛwɔnɔ uflǝsǝ mi ntu.” ");
INSERT INTO lip_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Yanklɛ fɛ Yesu ditsyi umǝ wǝ baakpo Nasaret lǝ Galilea eto kasɔ, ubǝ udufǝ, nya Yohanes díyifo wǝ ntuflǝsǝflǝsǝ eto lekpa lǝ Yordan. ");
INSERT INTO lip_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Lǝ kase Yesu nlɛ bɔbɔ lǝ ntu bomǝ ǝsuǝ kabe katoo, únyǝ nkǝ Onanto eto kato lɛ bɔsini nya Onanto eto Lɛwɔnɔ lɛyifǝ dísiǝ lǝ wǝ ǝsuǝ lǝ lɛblɛkpa eto ditsyǝbi ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Nya bánɔ ɔkuɛ ditsyi kato ɔnlɛ bɔtɛyi nkǝ, “Fǝ ni mɔ ubi wǝ mankeko, nya mǝǝnyǝ disuǝyuǝ lǝ fǝ.” ");
INSERT INTO lip_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Lamfolamfo, Onanto eto Lɛwɔnɔ ákpa Yesu úsuko mfiminti bomǝ kafo. ");
INSERT INTO lip_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Wǝ mate ǝsiǝ mfó eyifosi ana. Lǝ lefe nǝmfó ǝsuǝǝ, Obonsam áto Yesu óbe. Nya Onanto eto batɔyɛ díbǝ bawunsǝ ko wǝ. ");
INSERT INTO lip_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Lǝ lefe nǝ bǝmuǝ Yohanes bákpe lǝ Aba eto diyoo, Yesu édu mfó úsu Galilea úsu údi Onanto eto Ditiki Sɛɛ nǝmǝ mfó. ");
INSERT INTO lip_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ɔkɛ mfó katɛyi nkǝ, “Lefe sɛɛ nǝmǝ eboyo. Onanto eto sekakedikɔ eto lefe ǝbɔfi. Bisinkli lǝ mi asa bua eto kama lǝ befo Ditiki Sɛɛ nǝmfo bɛnɔ.” ");
INSERT INTO lip_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Se Yesu nlɛ botsyilama lǝ ditumbukplɛ nǝ nkpe lǝ Galilea eto kasɔ ɔflɔɔ, únyǝ mba lǝǝlǝkǝ akpɛ inuǝ, ba ni Simon ku wǝ ɔyimisani Andreas, ba nlɛ mǝ asabu bota mfó. ");
INSERT INTO lip_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Nya Yesu lɛtɛyi mǝ nkǝ, “Bibǝ bitǝkǝko mɛ idu mɔmɔ ɛntɔɔ, nya moote mi kase biulǝkǝ betidi bitǝ Onanto.” ");
INSERT INTO lip_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Lamfolamfo báyani mǝ asabu bǝtsyǝ nya bátaka bǝtǝkǝko wǝ. ");
INSERT INTO lip_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ɔ́yɛ úsu sɛtɔ sɛkɛ nya únyǝ bayimisani inuǝ bǝtsyuǝ ba ni Sebedeo eto bebi ba ni Yakobo ku Yohanes. Besi mǝ ɔklɔ kafo balɛ mǝ asabu bɔlɔ. ");
INSERT INTO lip_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Kase Yesu dínyǝ mǝ koo, ókpadi mǝ nkǝ bǝtǝkǝko wǝ. Mǝ tsya átaka akpa akpa báyani mǝ anto Sebedeo ku wǝ beyifoyifo bǝtsyǝ lǝ ɔklɔ ǝmǝ kafo bǝtǝkǝko Yesu. ");
INSERT INTO lip_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesu ku mba ntǝkǝko wǝ ésu bédufǝ umǝ wǝ baakpo Kapernaum. Nya lǝ Yudafɔ eto Ɔnwɛditsyǝyi nǝ ntǝkǝ lǝ mǝ mfó eto busu ǝsuǝ eto kamaa, Yesu ésu Yudafɔ eto katsyakɔ nya útsyiko mǝ Anantotiki bote. ");
INSERT INTO lip_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Iyifo mba kenke lɛnɔ wǝ asatete nyamǝ yanii, itsyise ɛbɔ lete lǝ mba laate asa itsyi lǝ Yudafɔ eto afi ǝsuǝ. Bomu wǝ asatete eyifo nnya nkpe kalende nya itsyi taa wǝ utu kǝmiǝ. ");
INSERT INTO lip_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Lǝ lefe nǝmǝ tutuutuu, osani utsyuǝ lɛwɔnɔ bua nsi wǝ lǝ ǝsuǝ akɛ lǝ katsyakɔ kamǝ mfó, ");
INSERT INTO lip_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","nya ófa bembembe ɔ́tɛyi nkǝ, “Yesu Nasaretnyǝ, be fanlɛ bɔbɛbɛ ketsyiko lǝ bo ɔflɔ mfo? Bubǝ fǝbǝ fǝ ǝǝbǝ atsylɔsǝ bo lee? Nyi futsyǝ feni. Fǝ ni Onanto eto Ɔkɛnkɛnyǝ wǝ ótsyese nɛ.” ");
INSERT INTO lip_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesu éti lɛwɔnɔ nǝmǝ kusu nya ókpe ni kɔfi nkǝ, “Dika, nya lǝ abɔ lǝ osani ǝmǝ ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Lɛwɔnɔ nǝmfo étinkǝsǝ osani ǝmǝ keklekle nya dítǝ ófa bǝmbǝǝmbǝ fɛ lɛbɔ lǝ wǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Itǝ iyifo mba kenke díńyǝ mfó yanii, nya bátɔ mǝ ǝsuǝ bǝnkǝ, “Nte asatete fɔfɔ nnya eto okle nɛ? Utidi ǝmfo kpe ǝsuǝale woafo etiki budi ku awɔnɔ bua nya beetsyue wǝ etiki ato.” ");
INSERT INTO lip_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Itǝ esoo, Yesu eto diye áyɛ letsyo lǝ Galilea eto kasɔ kenke. ");
INSERT INTO lip_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesu ku wǝ bakasebi ku Yakobo ku Yohanes édu lǝ katsyakɔ kamǝ nya bésu Simon ku Andreas eto diyo. ");
INSERT INTO lip_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Se bésu bédufǝ mfóo, betidi bǝtsyuǝ átɛyi Yesu bǝnkǝ, Simon eto usiǝambe áyila, atikesi ǝmuǝ wǝ olabe. ");
INSERT INTO lip_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Nyaso Yesu ésu wǝ ɔflɔ, nya ɔ́kɔbe wǝ lǝ kɔni ótakasǝ úńyǝnsǝ. Lamfolamfo wǝ bufi bomǝ áyɛ wǝ nya ótaka útǝ mɛ lesa bédi. ");
INSERT INTO lip_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Se ditsyitsyo lefe léyoo, betidi ákpa befimfi kenke ku mba awɔnɔ bua díkakpe bulǝ kpǝ báboko Yesu bǝ lǝ otsya mǝ bufi. ");
INSERT INTO lip_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Nya umǝ ǝmǝ kenke eto betidi díbǝ bǝńyǝ lǝ kesie mfó bánlɛ bobe. ");
INSERT INTO lip_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesu átsya betidi kpǝ ba nlɛ bufi ateate bufi nya óla awɔnɔ bua lǝ betidi kpǝ ǝsuǝ ku mba awɔnɔ bua nsi lǝ ǝsuǝ, itsyise Yesu yi nkǝ awɔnɔ bua nyamǝ yi futsyǝ uni, nyaso wántɔnɔ nkǝ awɔnɔ nyamǝ tɛyi kulesa itsyi lǝ wǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Kolensiǝnto fɛ kale luusiǝǝ, Yesu átaka ɔ́bɔ lǝ diyo nǝmǝ. Úsu kaka kutsyuǝ saa lǝmbǝ nya óto ola útǝ Onanto. ");
INSERT INTO lip_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Kamaa, Simon ku wǝ bayɛtsyuǝ ésu bábɛbɛ Yesu. ");
INSERT INTO lip_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Lǝ lefe nǝ bǝnyǝ wǝǝ, bátɛyi wǝ bǝnkǝ, “Utsyuǝ saa ǝbǝ ɔlɛ fǝ bɔbɛbɛ.” ");
INSERT INTO lip_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Fɛɛ Yesu átɛyi mǝ nkǝ, “Bitǝ lǝ busu umǝ bamba. Efe bǝ ndi Anantotiki lǝ mfó tsya, itsyise nyamfo ni mɔ keyifo ka mimbǝ keyifokɔ lǝ kawunsiǝ nɛ.” ");
INSERT INTO lip_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Nyaso ɔ́yɛ ótsyilama Galilea eto kasɔ kenke, nya úkedi Anantotiki nyamǝ lǝ Yudafɔ eto ntsyakɔ kpǝ nya óla awɔnɔ bua ɔ́bɔsǝ lǝ betidi ǝsuǝ tsya. ");
INSERT INTO lip_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Osani utsyuǝ wǝ nlɛ bufisia bufi ǝbǝ Yesu ɔflɔ. Óse akonki ɔ́lɛ wǝ lekpakpa nkǝ lǝ ɔwunsǝko wǝ. Ɔ́tɛyi wǝ nkǝ, “Lǝ alaa, ebofo mɛ botsya nya yuuyuǝ mɛ tsya.” ");
INSERT INTO lip_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Wǝ etiki nyamǝ ǝnǝ Yesu kafo, nyaso únǝ wǝ kɔni nya útidi wǝ. Nya ɔ́tɛyi wǝ nkǝ, “Nla nko. Fǝ ǝsuǝ kenke lǝ yele.” ");
INSERT INTO lip_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Lamfolamfo bufi bomǝ ǝyuǝ wǝ. ");
INSERT INTO lip_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Mfó nya Yesu lɛtɛyi wǝ nkǝ udu, nya ókpe wǝ kɔfi keklekle nkǝ, ");
INSERT INTO lip_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Mǝnńyǝ lǝ kusu atɛyi betidi nnya dibǝ, bomu su lǝ efi fǝ ǝsuǝ esu ate Onanto eto Usumunyǝ. Lǝ efi nkpata bo Mose eto kɔfi lɛtɔ esuko. Nyamfo luulǝkǝ ete bǝnkǝ bufi bomǝ ǝyuǝ fǝ nɛ.” ");
INSERT INTO lip_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Tsya lefe nǝ nwǝ ǝmǝ dídu ɔntɔɔ, útsyiko bofa katɛyi kase Yesu létsya wǝ. Lǝ nnya esoo, Yesu ménsifo umǝ saa busu, itsyise betidi kpǝ lɛ wǝ ɔflɔ bubǝ. Nyamfo esoo, Yesu kosate átsyimɛ lǝ umǝmflɔ kaka kuutsyǝ lǝmbǝ. Nya betidi ditsyi nlebe nlebe kpǝ, bǝbǝ wǝ ɔflɔ mfó. ");
INSERT INTO lip_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Lǝ eyi ǝtsyuǝ eto kamaa, úsinkli úsu Kapernaum nya lǝ wǝ businki kǝbǝ ǝsuǝǝ, betidi ánɔ bǝ úsinkli úbǝ oto. ");
INSERT INTO lip_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Nya betidi kpǝ díbǝ diyo nǝ ɔkɛ, ku ni kayoma kenke. Nya ɔkɛ mfó úkedi mǝ etiki. ");
INSERT INTO lip_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Mfó nya betidi ena léboko ufimfi wǝ léba onkpo kasɔ wǝ ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Nya se banlɛ kusu bunyǝ lǝ bayɛnko wǝ lǝ kesie bedufǝnko wǝ diyo kafo lǝ kase betidi mfui esoo, bésu bábe letsya bǝlǝkǝ ofo nya báyɛnko ufimfi ǝmǝ ku wǝ belabekǝ báyifǝsǝ bǝtsyǝ le Yesu eto akɔ. ");
INSERT INTO lip_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Se Yesu dínyǝ kase sɔ̃ɔ̃ báfo bánɔ bǝ woofo ufimfi ǝmǝ botsya esoo, Yesu átɛyi nwǝ léba onkpo kasɔ ǝmǝ nkǝ, “Ubi, mfi fǝ abua ntsyɛ fǝ.” ");
INSERT INTO lip_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Fɛɛ afi eto bateasa ba lɛkɛ mǝ lenti mfó ebu lǝ mǝ akɔɛsi ǝsuǝ bátɛyi bǝnkǝ, ");
INSERT INTO lip_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Beso woatɛyi nko? Ɔlɛ mbusiotiki budi. Onanto hã laafo abua bufi katsyɛ!” ");
INSERT INTO lip_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yesu áte mǝ nsusu nyaso ɔ́tɛyi mǝ nkǝ, “Beso ele bǝ nyamfo lǝ mi? ");
INSERT INTO lip_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Nte nya diyuǝ enso bɔtɛyi, ‘Mfi fǝ abua ntsyɛ fǝ,’ lee ‘Taka lǝ efi fǝ belabekǝ lǝ ayɛ edu’? ");
INSERT INTO lip_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Nyaso lǝ itǝ bǝ befo bɛnɔ biǝ Utidi Eto Ubii, nkpe ǝsuǝale bǝ mfi betidi eto abua ntsyɛ le kawunsiǝ kamfo. Bɛnɔ?” Mfó ǝmǝǝ, Yesu esi útsyi wǝ ǝnǝmi útǝ ufimfi ǝmǝ nya ɔ́tɛyi wǝ nkǝ, ");
INSERT INTO lip_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Taka lǝ efi fǝ belabekǝ lǝ esu diyo.” ");
INSERT INTO lip_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Nya osani ǝmfo létaka lamfolamfo úfi wǝ okla nya údu lǝ betidi bamǝ ńyǝ mfó nti. Nyamfo éyifo betidi ba kenke nyǝ mfó yanii. Nya ítǝ béfi atǝsǝ banlɛ Onanto butǝ. Mǝmblɛ átɛyi bǝ bǝnnyǝ tɔ nyamfo eto okle bǝnyǝ. ");
INSERT INTO lip_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Nya Yesu disi údu úsu Galilea eto Ditumbukplɛ kɛnyɛ nya betidi bamǝ kenke díbǝ wǝ ɔflɔ mfó, nya óte mǝ Anantotiki. ");
INSERT INTO lip_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Kase ɔ́nlɛ bɔyɛ kafe lǝ ditumbukplɛ nǝmǝ ɔflɔ mfóo, úsu únyǝ Lewi wǝ ni Alfeo eto ubi wǝ nsi lǝ kaka woafo umǝnko. Nya Yesu lɛtɛyi wǝ nkǝ, “Taka lǝ ǝtǝkǝko mɛ!” Nyaso Lewi átaka kpla nya útǝkǝko wǝ. ");
INSERT INTO lip_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ketsyitsyokɔmii, Yesu ku wǝ bakasebi ku betidi kpǝ ba ntǝkǝko wǝ, ésu Lewi eto bǝ lǝ besu bedi lesa ku wǝ. Mba dítǝkǝko wǝ eto bǝtsyuǝ éyifo mba laafo umǝnko ku babuayifo. ");
INSERT INTO lip_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Nya afi eto bateasa ba ni Yudafɔ eto lekpa nǝ baakpo Farisifɔ tsya akɛ mfó. Nyaso lefe nǝ afi eto bateasa ba ni Farisifɔ bamǝ dínyǝ bǝ Yesu si ɔ́lɛ lesa budi ku babuayifo, bátɔ wǝ bakasebi bǝnkǝ, “Ntsyǝso wonko mba laafo umǝnko ku babuayifo nsi banlɛ lesa budi?” ");
INSERT INTO lip_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Se Yesu lɛnɔ etiki nnya bánlɛ budii, ɔ́tɛyi mǝ nkǝ, “Betidi ba nkpe ǝsuǝale manhiã ofanyǝ enso mba ni befimfi hã. Mǝmbǝ miǝ mǝǝbǝ nlǝkǝ betidi sɛɛ, bomu babuayifo eso mimbǝ.” ");
INSERT INTO lip_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Lǝ lefe ditsyuǝ se Yohanes ku wǝ bakasebi ku Farisifɔ lɛkɛ lǝ kɛnyɛkekle ǝsuǝǝ, betidi bǝtsyuǝ ǝbǝ Yesu ɔflɔ nya bátɔ wǝ bǝnkǝ, “Beso fɛ fǝ bakasebi laankle kɛnyɛ fe kase Yohanes eto bakasebi ku Farisifɔ laakle?” ");
INSERT INTO lip_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu ǝtǝ mǝ mbuayɛ lǝ lekpa seka ɔ́tɛyi nkǝ, “Nyalɛ Okafɔsǝ eto bakloboo, bani lesa budi lǝ kusiǝ kakpakɔ kamǝ? Lee, yanle bǝ bǝnyǝ disuǝyuǝ ku okafɔsǝ ǝmǝ nkpe mǝ lentii? ");
INSERT INTO lip_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Yuubǝ diyi ditsyuǝ bǝ lǝ bǝlǝkǝ okafɔsǝ ǝmǝ lǝ mǝ nti, baklobo bamǝ ebokle kɛnyɛ beyifo yoyoyo. ");
INSERT INTO lip_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Kuutsyuǝ saa emfi lefianku fɔfɔ kaka kama lǝ kafia koko ka nlɛ bola ǝsuǝ, lefianku fɔfɔ nǝmǝ ebunǝ kafia koko kamǝ kala lǝ bǝflǝ kǝ, nya luutǝ dibiǝ koko nǝmǝ sǝnsǝ lɛmɔ leso kɔ. ");
INSERT INTO lip_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Nnya kamaa, bankpo ntǝ fɔfɔ lǝ kubukikuǝtobe koko wǝ bákakpo ntǝ bǝnyǝ kafo. Ntǝ fɔfɔ bomǝ ebɔkpɔ bobe kato itǝ bǝ kubukikuetobe koko ǝmǝ ebola itǝ bǝ ntǝ ku kubukikuǝtobe ǝmǝ ebuyifo asɔsɔ. Bomu ntǝ fɔfɔɔ, ubukikuǝtobe fɔfɔ ǝsuǝ baakpo mu.” ");
INSERT INTO lip_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Lefe lɔni lǝ Ɔnwɛditsyǝyii, se Yesu ku wǝ bakasebi nyɛ lǝ anta eto ɔkuɛ utsyuǝ banlɛ bofee, bǝfǝsǝ anta ǝtsyuǝ balɛ bɔyimi. ");
INSERT INTO lip_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Nyaso Farisifɔ bǝtsyuǝ átɔ Yesu bǝnkǝ, “Beso fǝ bakasebi lǝǝyifo nko? Bo kɔfi mǝntǝ kusu bǝ beyifo nko lǝ Ɔnwɛditsyǝyi.” ");
INSERT INTO lip_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Lǝ nnya ǝsuǝ Yesu átɔ mǝ nkǝ, “Biankla lǝ Onanto eto Kukuǝ Kɛnkɛ eto Awɔnisa lesa nǝ Oka David díyifo? Lǝ lefe nǝ kukpǝnsɛ lɛlɛ wǝ ku wǝ bayɛtsyuǝǝ, Oka David ésu kaka bǝǝtǝ Onanto kedi lǝ Usumunyǝ Ninǝ Kenke wǝ baakpo Abiatar eto lefe. Úlǝkǝ didisa kɛnkɛ nǝ ntǝ mfó itǝ mba lǝǝtǝ wǝ kedi hã lǝ Disumuyo údi nya útǝ wǝ bayɛtsyuǝ tsya ditsyuǝ bédi. Moses eto kɔfi mǝntǝ nkomǝ eto diyifobi nǝmfo kusu, tsya bántɛyi mǝ kulesa.” ");
INSERT INTO lip_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Nya Yesu lɛtɛyi mǝ nkǝ, “Onanto ǝtsyǝ Ɔnwɛditsyǝyi itǝ utidi eto lɛlɛkǝsǝ. Inni utidi bǝtsyǝ itǝ diyi nǝmǝ eto lɛlɛkɛsǝ. ");
INSERT INTO lip_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Nyaso mɔ, Utidi Eto Ubii, mɔ ke ni Ɔnwɛditsyǝyi eto Onamute.” ");
INSERT INTO lip_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Lǝ lefe bamba ǝsuǝǝ, Yesu esi úsu Yudafɔ eto katsyakɔ. Utsyuǝ akɛ mfó wǝ eto kɔni díkpǝ konyoma. ");
INSERT INTO lip_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Betidi ba lɛkɛ mfó eto bǝtsyuǝ ńyǝ balɛ bobe lǝ wootsya utidi ǝmǝ lǝ ɔnwɛditsyǝyi nǝmǝ ǝsuǝ lǝ babe lǝ buunyǝ etiki lǝ wǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesu ákpadi utidi ǝmǝ eto kɔni díkpǝ útsyǝ lǝ betidi ba kenke eto ǝnǝmi. ");
INSERT INTO lip_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Nya útsyi wǝ ǝnǝmi útǝ betidi bamǝ kenke nya ɔ́tɔ mǝ nkǝ, “Ɛlɛkɛ bǝ utidi yifo kasɛɛ lǝ Ɔnwɛditsyǝyi, lee Ɔnwɛditsyǝyi eyifo diyi nǝ utidi loobiasǝ asa? Iyifo diyi nǝ bǝǝtǝ nkpǝ, lee iyifo diyi nǝ baa biasǝ nkpǝ?” Fɛɛ bámfo wǝ kulesa bɔtɛyi. ");
INSERT INTO lip_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesu étsyi ɔ́wuninsǝ nya óbe mǝ ku lɛblɔfi itsyise ílǝ wǝ lǝ lɛkɔɛsi se bánla bǝ baawunsǝko mǝ bǝtsyuǝ eso. Nya ɔ́tɛyi ufimfi ǝmǝ nkǝ, “Nǝ fǝ kɔni etsyue.” Únǝ ko útsyue. Nya ete kɔni komǝ létsya wǝ. ");
INSERT INTO lip_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Lǝ nnya ǝsuǝǝ, Farisifɔ bamǝ édu nya bésu bátsya ku Herod eto betidi nya bákpe disi lǝ kase bɔɔyɛ balo Yesu. ");
INSERT INTO lip_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Nya Yesu ku wǝ bakasebi lɛyɛ bésu Galilea eto ditumbukplɛ ɔflɔ. Nya sitiditu kplɛ sia ditsyi Galilea ku Yudea ku Yerusalem ku Idumia eto kasɔ ku mba ditsyi Yordan eto ketu eto lekpake nǝ nse ku mba ditsyi Tiro ku Sidon tsya ǝtǝko wǝ bǝbǝ. Nnya ni bǝnkǝ wǝ ayanisa nnya ɔnlɛ buyifo ǝbɔyɛ etsyo nyaso betidi kpǝ ála bǝ befi mǝ ǝnǝmi bǝnyǝ wǝ. ");
INSERT INTO lip_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Lǝ lefe nǝmfó se Yesu díkatsya betidi kpǝ esoo, befimfi kpǝ lɛ bokplatsya bǝ lǝ betidi wǝ ko lǝ bǝmuǝ ale. Nyaso Yesu átɛyi wǝ bakasebi nkǝ babɛbɛ ɔklɔ bǝńyǝnsǝ lǝ utuflɔ, itǝ bǝ lǝ betidi bamǝ ǝbǝ befuii, woofo bobe kǝdufǝ lǝ wǝ kafo. ");
INSERT INTO lip_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Lɛwɔnɔ bua ǝsiǝ lǝ betidi bǝtsyuǝ ba díbǝ mfó ǝsuǝ. Lǝ bǝnyǝ, bǝnyǝ Yesu koo, békedu kanɔ nya bákafa katɛyi bǝnkǝ, “Fǝ ni Onanto eto Ubi.” ");
INSERT INTO lip_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Nya Yesu káninko mǝ nkǝ bǝntǝ lǝ betidi lǝ bate futsyǝ uni. ");
INSERT INTO lip_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Nyamfo eto kamaa, Yesu ábe úsu kɔtini disi. Nya mfóo, ókpadi mba óla nkǝ bakɛ ko wǝ. ");
INSERT INTO lip_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Betidi bamfo ǝbǝ wǝ ɔflɔ nya úlǝkǝ lefosi inuǝ lǝ mǝ nti. Nya útǝkǝ mǝ diye nkǝ batɔnkpe. Ɔ́tɛyi mǝ nkǝ, “Nlǝkǝ mi minkǝ bɛkɛ mɛ lǝ ɔflɔ lefe saa. Mootsyese mi lǝ bisu bidi Anantotiki. ");
INSERT INTO lip_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Nya biɔkɛ ǝsuǝale bela awɔnɔ bua bitsyiko lǝ betidi ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","19","Betidi lefosi inuǝ ba úlǝkǝ eto aye ni Simon wǝ Yesu dítǝ diye nkǝ Petro ku Yakobo ku wǝ ɔyimisani kɛkɛ Yohanes ba ni Sebedeo eto bebi ba Yesu dítǝkǝ diye nkǝ Boanerges eto kasɔ ni nkǝ, beedi etiki ku utǝ fe kase kato laafa kekumi bembembe, bafɛfɛ ni Andreas ku Filipo ku Bartolomeo ku Mateo ku Toma ku Yakobo wǝ ni Alfeo eto ubi ku Tadeo ku Simon wǝ lǝ lefe ditsyuǝ nǝ lefe léta mǝ kasɔ disi ku Yuda Iskariot, nwǝ luubǝ ulǝkǝ Yesu utǝ. ");
INSERT INTO lip_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Se Yesu dídu mfóo, údu úsu diyo ditsyuǝ. Nya betidi kpǝ esi bǝbǝ mǝ ɔflɔ mfó. Itǝ bǝ ibǝ ɛkɛ ale itǝ Yesu ku wǝ bakasebi bǝ bánkɛ lefe kulaa tsya lǝ bedi lesa. ");
INSERT INTO lip_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Se wǝ kosate eto betidi lɛnɔ nkoo, bésu bǝ lǝ besu bǝnǝ wǝ besuko diyo, itsyise bátɛyi bǝnkǝ, “Disi abia wǝ.” ");
INSERT INTO lip_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Nya afi eto bateasa ba ditsyi Yerusalem lɛtɛyi bǝnkǝ, “Lɛwɔnɔ bua ǝbǝ disi lǝ Yesu ǝsuǝ. Nya awɔnɔ bua eto ɔtɔnkotɔnkoo, ni nwǝ dítǝ wǝ ǝsuǝale fɛ ɔnlɛ awɔnɔ bua nyamfó bola kabɔnko lǝ betidi ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Nyaso Yesu ákpadi betidi bamǝ nya údi etiki ko mǝ lǝ lekpa ǝsuǝ nkǝ, “Ntsyǝ yuubǝ bǝ Obonsam ebofo wǝ ǝsuǝ bola ketsyiko lǝ utidi ǝsuǝ? ");
INSERT INTO lip_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Lǝ ibǝ bǝnkǝ sekakedikɔ áma se ǝsuǝ lǝ akpaa, nya akpa akpa nyamǝ nlɛ bɔkpɔ lǝ mǝ ǝsuǝ ntii, nkomǝ eto sekakedikɔ siamǝ ǝmbofo buńyǝ. ");
INSERT INTO lip_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Lǝ diyo ditsyuǝ eto betidi ǝsǝnsǝ lǝ mǝ bǝtsyuǝ ǝsuǝǝ, anto ku anto nlɛ bɔkpɔ lǝ mǝ bǝtsyuǝ ǝsuǝǝ, diyo nǝmfó ǝmbofo buńyǝ. ");
INSERT INTO lip_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Nyaso lǝ Obonsam ataka uńyǝ ɔnlɛ bɔkpɔ ku wǝ ǝsuǝ ku wǝ sekakedikɔ sia lema akpa akpaa, sekakedikɔ siamfó ebusǝnsǝ nya wǝ sekakedidi ebolo. ");
INSERT INTO lip_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Iyifo etiki eto ɔnukualɛ bǝ utidi ǝmbofo botaka kesu ketu ǝsuǝaletidi lǝ wǝ diyo, ketsyi wǝ bikǝ. Fɛ woofo budufǝ lǝ wǝ diyo nǝmǝǝ, tsyisɛ umuǝ ǝsuǝaletidi ǝmǝ okle. ");
INSERT INTO lip_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Nlɛ mi bɔtɛyi sitinti minkǝ Onanto ebufi lebua saa nǝ betidi díyifo ku diye bua saa nǝ baakpadi Onanto ɔtsyɛ. ");
INSERT INTO lip_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Fɛɛ diye bua saa nǝ utidi lookpadi Onanto eto Lɛwɔnɔ Kɛnkɛɛ, Onanto ǝmbufi ni ɔtsyɛ wǝ kulefe. Itsyise wuufi lebua nǝmfo fenkǝ lebua nǝ wembotasuǝ.” ");
INSERT INTO lip_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu átɛyi nyamfo nko itsyise betidi bǝnkǝ lɛwɔnɔ bua kpe lǝ wǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Lǝ lefe nǝmǝ ǝsuǝǝ, Yesu eto bayimisani ku wǝ ambe ǝbǝ mfó. Bǝńyǝ lǝ lekple nya bákpe wǝ utidi bǝ bahiã wǝ. ");
INSERT INTO lip_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Nyaso betidi ba létsyilama wǝ átɛyi Yesu bǝnkǝ, “Be, fǝ ambe ku fǝ bayimisani ńyǝ lǝ lekple bǝ bǝ.” ");
INSERT INTO lip_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Nyaso Yesu átɔ mǝ nkǝ, “Owoe ni mɔ ambe? Bawoe ni mɔ bayimisani?” ");
INSERT INTO lip_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Nya ótsyilamasǝ ǝnǝmi nya óbe betidi ba nsi letsyilama wǝ mfó nya ɔ́tɛyi nkǝ, “Bee, nyǝ mbamfo ni mɔ ambe nye mɔ bayimisani. ");
INSERT INTO lip_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Utsyuǝ saa wǝ leeyifo Onanto eto lelabii, wǝ ni mɔ ɔyimisani nye mɔ ɔyimisio, nye mɔ ambe nɛ.” ");
INSERT INTO lip_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu esi ésu Galilea eto ditumbukplɛ flɔ nya ɔnlɛ Ditiki Sɛɛ nǝ mǝ bote. Nya lǝ kase betidi ba létsyilama wǝ mfui esoo, údufǝ lǝ ɔklɔ kafo lǝ ntu bomǝ ǝsuǝ, nya úsiǝ kasɔ. Nya betidi bamǝ díńyǝ lǝ ntu kɛnyɛ fɛ Yesu dídi ko mǝ etiki. ");
INSERT INTO lip_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Lefe kpǝ lǝ wǝ asatete ǝsuǝǝ, údi etiki ɔ́yɛnko lǝ akpa ǝsuǝ lǝ ufi ulǝkǝ asa nnya óla nkǝ loote mǝ kasɔ. Asa nnya óte mǝ ni nkǝ. ");
INSERT INTO lip_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Bɛnɔ! Lefe lɔnii, ɔkuɛmfo ɔni ésu ɔkuɛ nkǝ lǝ usu usiǝ eyibibi ǝtsyuǝ. ");
INSERT INTO lip_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Lǝ lefe nǝ ɔnlɛ eyibibi nyamǝ busǝǝ, íbǝ bǝ ǝtsyuǝ álo ékpo lǝ usunte ɔflɔ, nya baklɔbɛ díbǝ básɛ nnya bámini. ");
INSERT INTO lip_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ǝtsyuǝ álo ékpo lǝ aba ǝsuǝ, kaka sitǝ lemfui. Nyaso eyibibi nyamfo ǝkǝ mlǝ. ");
INSERT INTO lip_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Fɛɛ se kofe lébe kɛnyɛɛ, éblobe nya íkpǝ. Nnya ni bǝ, nnya keyudu mǝnnyǝ didisa itsyi lǝ aba nyamǝ eso. ");
INSERT INTO lip_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Eyibibi nyamǝ eto ǝtsyuǝ ésu ékpo lǝ biyu nti. Nya kanyi kamǝ léto kéti nnya. Nyaso yámfo bɔnwɔ. ");
INSERT INTO lip_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Nya íbǝ bǝ ǝtsyuǝ álo ékpo lǝ kasɔ sɛɛ ǝsuǝ. Nya íkǝ, nya yébe kukɔnɔ nya yɛnwɔ ebibi. Nya ǝtsyuǝ lɛnwɔ ebibi fosi ǝtsyǝ, ebibi fosi akua, ǝtsyuǝ lɛnwɔ kolofa.” ");
INSERT INTO lip_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Lǝ kalosǝkɔɔ, Yesu átɛyi mǝ nkǝ, “Nyaso fǝ ke nkpe atoo, tsyuǝ ato kukunɔ lǝ anɔ.” ");
INSERT INTO lip_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Lǝ lefe nǝ Yesu mate insii, wǝ bakasebi lefosi inuǝ bamǝ ku mba lǝǝtǝkǝko wǝ ǝbǝ wǝ ɔflɔ nya bátɔ wǝ bǝ ulǝkǝ lekpa nǝmǝ kasɔ ote mǝ. ");
INSERT INTO lip_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Nya Yesu lɛtɛyi mǝ nkǝ, “Mimii, béfi Onanto sekakedikɔ eto akulasa bǝtǝ mi. Fɛɛ mba díbuu, nye bafɛfɛ ba lentǝkǝko mɛ, ǝbɔnɔ mɔ asatete nyamǝ ɛyɛ lǝ akpa ǝsuǝ hã. ");
INSERT INTO lip_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Nyaso íbǝ itǝ fe kase Onanto eto unyɛlǝkǝtidi lɛwɔni útsyǝ nkǝ, ‘Buukabe tsyaa, bǝǝmbunyǝ bǝtsyǝ lekpo. Buukǝtsyue ato tsyaa, bǝǝmbɔnɔ kasɔ. Nnya ni bǝ lǝ banɔ nye bǝnyǝ tsyaa, bǝǝmbɔnɔ kasɔ. lǝ betsyi mǝ ǝnǝmi bǝtǝ Onanto, bǝ lǝ ufi mǝ abua ɔtsyɛ mǝ.’ ” ");
INSERT INTO lip_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Nya Yesu lɛtɔ mǝ nkǝ, “Biannɔ lekpa nǝmfo eto kasɔ? Ntsyǝ fɛ biofo lekpa bamba saa kasɔ bɔnɔ? ");
INSERT INTO lip_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ɔkuɛmfo ǝmǝ lɛ Onanto eto etiki busǝnsǝ. ");
INSERT INTO lip_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Betidi bǝtsyuǝ ale kase eyibibi ǝtsyuǝ luubǝ ekpo lǝ kusu ɔflɔ. Lǝ kase banlɛ bɔnɔɔ, ete Obonsam ǝǝbǝ nya wǝǝnwǝ nnya kǝlǝkǝ lǝ mǝ nsusu ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Betidi bamba tsya ale eyibibi nnya lǝǝbǝ kakpo lǝ aba ǝsuǝ. Lǝ lefe nǝ banlɛ nnya bɔnɔɔ, yeakpe mǝ disuǝyuǝ. ");
INSERT INTO lip_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Tsya ditiki nǝmǝ eto keyudu ǝnńyǝ kasɔ kukɔnɔ. Baafo kanɔ itǝ lefe kliminti ete. Nya lefe nǝ ke kǝnǝ nye bulǝ sɛkɛ díbǝ lǝ mǝ ǝsuǝ lǝ ditiki nǝmǝ esoo, beesinkli kama. ");
INSERT INTO lip_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","“Nya betidi bǝtsyuǝ tsya te fe eyibibi nnya díbǝ íkǝ lǝ kanyi nti. Nya mbamfó ni betidi ba laanɔ ditiki nǝmǝ. ");
INSERT INTO lip_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Fɛɛ kawunsiǝ kamfo eto bulǝ ku atabi bɔbɛbɛ kekleke ku ǝsuǝ eto lɛlɛkǝsǝ ku kawunsiǝ eto kamini bɔbɛbɛ aafo mǝ ketu. Nyamfo laakle kemli ditiki nǝmǝ itǝ bǝ diamfo ebibi bɔnwɔ. ");
INSERT INTO lip_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","“Nya betidi bǝtsyuǝ te fe eyibibi nnya lélo ékpo lǝ kasɔ sɛɛ ǝsuǝ. Baafo etiki nyamǝ ku utu faa, nya baanwɔ ebibi kpǝ. Ǝtsyuǝ aanwɔ ebibi fosi ǝtsyǝ, nye awosi akua nye kolofa.” ");
INSERT INTO lip_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu esi ɔ́tɔ mǝ nkǝ, “Utidi aato okandiɛ kefi kakpe lǝ ditsyitsya kalɔ nye lǝ mpa kalɔ? Inni okandiɛ eto kǝtǝkǝkɔ baato okandiɛ kǝtǝkǝ? ");
INSERT INTO lip_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Lesa nǝ ke nkpe lǝ kakula ǝsuǝǝ, ǝbɔbɔ lǝ lekple utidi saa nyǝ. Lesa nǝ ke nkpe lǝ kakula ǝsuǝ ǝbɔbɔ tɛnklɛ utsyuǝ saa nyǝ. ");
INSERT INTO lip_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Nyaso lǝ bekpe atoo, bɛnɔ kukɔnɔ!” ");
INSERT INTO lip_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yesu esi ɔ́tɛyi nkǝ, “Bifi mi ato bekpe kukɔnɔ lǝ lesa nǝ bɛnlɛ bɔnɔ ǝsuǝ. Kase faakla asa yeeyi kaba kakpo kǝtǝ utidii, nko ke eto okle Onanto lookla utǝ fintsya nɛ! ");
INSERT INTO lip_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Utidi wǝ ke asa ntee, buusi bǝtǝ wǝ bawunsǝ. Nya utidi wǝ kulesa lentee, nnya nte wǝ tsyaa, bɔɔlɛ nnya bafo wǝ lǝ ani.” ");
INSERT INTO lip_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu esi ɔ́tɛyi mǝ nkǝ, “Onanto eto sekakedikɔ ale osani wǝ laato eyibibi. ");
INSERT INTO lip_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Diyi saa woalabe kataka, nya nkomǝ eto eyibibi nyamǝ nlɛ bukǝ kabe. Fɛɛ unnyi kase asa nlɛ butsyǝ nkomǝ. ");
INSERT INTO lip_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Nnya ni bǝnkǝ kasɔ ka báto diyibibi nǝmǝǝ, ke laalɛ ni ola nko. Tutɛ, lǝ díkǝǝ, díabɔ afanto, nya uyi laabɔ. Nya lǝ ébee, yeawɔ ebibi kpǝ. ");
INSERT INTO lip_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Lǝ ebibi nyamǝ ábe ɛsɛɛ, ɔkuɛmfo ǝmǝ ǝbǝ kala nnya. Itsyise nnya lɛlɛfe eboyo.” ");
INSERT INTO lip_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu átɔ nkǝ, “Be muufi nkatesǝ ku Onanto eto sekakedikɔ. Nte lekpa nǝ ele bǝ mfi nlǝkǝ nyamfo eto kasɔ? ");
INSERT INTO lip_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ite fenkǝ utidi éfi diyibibi nǝ nso bɔfɛ lǝ kawunsiǝ úsu óto. ");
INSERT INTO lip_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Lefe ditsyuǝ eto kamaa, diǝkǝ kafiani kuyi. Nya nkomǝ eto kuyi komfo laamɔ kaso ɔkuɛ eto ediyi fɛfɛ kenke. Koata kalɛ kpǝ. Nya baklɔbɛ laato ayo lǝ kuyi komǝ eto kalɛ ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu édi mǝ etiki nyamfo lǝ kase utsyuǝ sa loofo kasɔ bɔnɔ. ");
INSERT INTO lip_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Etiki saa wuudi mǝǝ, woatɛyi nnya kayɛ lǝ akpa ǝsuǝ. Lǝ lefe nǝ itǝ kusu bǝ wonko wǝ bakasebi bamǝ hã sii, nya fɛ wǝǝlǝkǝ nnya kasɔ kate mǝ nɛ. ");
INSERT INTO lip_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Diyi nǝmfó eto ditsyitsyo lefee, Yesu átɛyi wǝ bakasebi nkǝ, “Bitǝ lǝ bɔyila ditumbukplɛ nǝmfo busu ni lekpake nǝ nse.” ");
INSERT INTO lip_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Nyaso bédu lǝ betidi ǝto ditsyukpa nǝmfo ɔflɔ bésu bedufǝ bǝsiǝ lǝ ɔklɔ wǝ Yesu dísiǝ ǝsuǝ, nya bétsyiko ditumbukplɛ nǝmǝ bɔyila. Kaklɔ bamba tsya ǝńyǝ mfó. ");
INSERT INTO lip_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Yanklɛ fɛ ufiebi ko dítsyiko bɔsɔ bembembe nya ɔ́sɔ ntu ókpo lǝ ɔklɔ ǝmǝ kafo, nya ibu sɛkɛ lǝ ntu lǝ buyi ɔklɔ ǝmǝ lǝ onya udu fǝ lǝ ntu kasɔ. ");
INSERT INTO lip_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Lǝ lefe nǝmfóo, Yesu ǝsiǝ lǝ ɔklɔ ǝmǝ eto kama, úfi wǝ disi útǝkǝ lǝ esunde ǝsuǝ nya ɔnlɛ selabe. Nyaso básanklisǝ wǝ nya bátɛyi wǝ bǝnkǝ, “Oteasa, ɛnlɛ fǝ bulǝ bǝnkǝ boǝbǝ bukpǝ?” ");
INSERT INTO lip_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesu átaka úńyǝ nya ófa ɔ́tɛyi nkǝ, “Ufiebi, yɛ bɔsɔ!” Nya ɔ́tɛyi ntu bomǝ tsya nkǝ, “Ntu yɛ bonwa!” Nya ufiebi ǝmǝ disinkli ɔ́yɛ bɔsɔ, nya ntu bomǝ eto ǝnǝmi disinkli búyuǝ buɛɛ kananaa. ");
INSERT INTO lip_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Nya Yesu lɛtɔ wǝ bakasebi nkǝ, “Beso biate sikpi mmǝ? Bíamfo tɔ bɛnɔ?” ");
INSERT INTO lip_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Sikpi ǝmuǝ mǝ sefensǝ, nya bétsyiko mǝ bǝtsyuǝ bɔtɔ bǝnkǝ, “Owoe ko ni utidi ǝmfo? Bǝ ntu bomǝ ku ufiebi kenke etsyue wǝ etiki koto!” ");
INSERT INTO lip_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Nyamfo eto kamaa, Yesu ku wǝ bakasebi édu bésu Galilea eto Ditumbukplɛ eto situma sia nse lǝ Gerasefɔ eto kasɔ. ");
INSERT INTO lip_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Le kase Yesu lɛbɔ le ɔklɔ ǝmǝ kafo koo, osani utsyuǝ wǝ lɛwɔnɔ bua nsi lǝ ǝsuǝǝ, ǝbǝ ótsyako wǝ. Osani ǝmfo ábɔ lǝ edi nnya lɛfi mfó nti. ");
INSERT INTO lip_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Itsyise mfó úkǝsiǝ nɛ. Lǝ lefe nǝ lefe mmǝǝ, betidi ba kenke mámfo wǝ bumuǝ kakpe lǝ amana. ");
INSERT INTO lip_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Lǝ lefe kpǝ ǝsuǝǝ, bákafo wǝ ani ku akpa bokle. Fɛɛ wókala nnya bufǝsǝ kabɔ. Utidi ǝmfo akɛ ǝsuǝale tinti, itǝ bǝ kutsyuǝ saa mánkamfo wǝ bumuǝ kǝtsyǝ. ");
INSERT INTO lip_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Kǝtsyǝ ku kakɔmi kenke úkatsyilama lǝ betidi eto edi ku atini nyamǝ nti, nya úkakpo kudu, ékefi abambi katsya wǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Utidi ǝmfo ǝńyǝ kɔsɛsɛ fɛ únyǝ Yesu. Nyaso útsyetsyi úsu óse akonki lǝ Yesu eto ǝnǝmi. ");
INSERT INTO lip_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Nya ófa bembembe ɔ́tɛyi nkǝ, “Onanto Fanlonlo eto Ubi! Be nkpe lǝ mɔ ku fǝ lenti mfo? Nlɛ fǝ lekpakpa, se mɛ uyi lǝ Onanto eto diye ǝsuǝ fǝnkǝ embunǝ mɛ koto!” ");
INSERT INTO lip_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ɔ́tɛyi nkomǝ, itsyise ɔ́nɔ bǝ Yesu Yesu áto ɔkuɛ nkǝ, “Lɛwɔnɔ bua bɔ lǝ osani ǝmfo ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Nya Yesu lɛtɔ wǝ nkǝ, “Ntsyǝ baakpo fǝ?” Nya útǝ mbuayɛ nkǝ, “Mɔ baakpo omantsya itsyise bomba nkpe lǝ nwǝ mfo ǝsuǝǝ, bufui.” ");
INSERT INTO lip_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Nya ɔ́lɛ Yesu lekpakpa nkǝ woanla mǝ lǝ kasɔ kamǝ. ");
INSERT INTO lip_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Lǝ lefe nǝmfó ǝsuǝǝ, bakplako kpǝ ǝńyǝ lɛ kɔtini komǝ ɔflɔ balɛ budi. ");
INSERT INTO lip_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Nya awɔnɔ nyamfo lɛlɛ Yesu lekpakpa bǝnkǝ, “La bo akpe lǝ bakplako ba ńyǝ lǝ mmǝ, lǝ budu budufǝ lǝ mǝ ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Nya ɔ́tɔnɔ útǝ mǝ, nya awɔnɔ nyamǝ lɛbɔ lǝ osani ǝmfo ǝsuǝ nya bédu bésu bédufǝ lǝ bakplako bamǝ ǝsuǝ. Nya bakplako bamǝ kenke, ba eto utu luuyifo fe akpi ǝnuǝǝ, dítsyetsyi bésu báwunini lǝ kɔtini komǝ eto kotosi bésu bédufǝ lǝ ditumbukplɛ nǝmǝ nya bánya bátsylɔ kenke. ");
INSERT INTO lip_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Nya mba nlɛ bakplako bamǝ bobee, dítsyetsyi bésu umǝ ǝmǝ ku mba lɛkɛ lǝ wǝ ɔflɔ mfó, nya bésu batɛyi betidi ba kenke lesa nǝ díbǝ. Mba bátɛyi ésu mfó, bésu bábe lesa nǝ díbǝ. ");
INSERT INTO lip_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Nya lefe nǝ bǝbǝ Yesu ɔflɔɔ, bǝnyǝ utidi wǝ awɔnɔ bua kpǝ dísiǝ lǝ ǝsuǝ mfó. Nya únsi lǝ kasɔ, ónkpe awu, íkakpa ko wǝ. Nya sikpi dímuǝ mǝmblɛ kenke. ");
INSERT INTO lip_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Betidi ba leka wǝ búnyǝǝ, átɛyi lesa saa nǝ díbǝ lǝ utidi ǝmǝ ku bakplako bamǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Nyaso bálɛ Yesu lekpakpa bǝ udu lǝ mǝ kasɔ. ");
INSERT INTO lip_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Lefe nǝ Yesu nlɛ budufǝ lǝ ɔklɔ ǝmǝ ǝsuǝǝ, osani ǝmǝ ǝsuǝ awɔnɔ bua dísiǝǝ, alɛ wǝ lekpakpa nkǝ, “Tɔnɔ lǝ ntǝkǝko fǝ lǝ bukayɛ katsyilama.” ");
INSERT INTO lip_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Fɛɛ Yesu mántɔnɔ. Bomu ɔ́tɛyi wǝ nkǝ, “Sinkli esu fǝ betidi ɔflɔ lǝ atɛyi mǝ kase Onamute ǝmǝ lɛwunsǝ ko fǝ ku kase únyǝ fǝ kaminsǝ.” ");
INSERT INTO lip_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Nyaso osani ǝmfo édu úsu ótsyilama Kǝmǝ Lefosi kamǝ nya ɔ́tɛyi betidi bamǝ lesa saa nǝ Yesu díyifo útǝ wǝ. Nya íyifo mba lɛnɔ nnya yanii. ");
INSERT INTO lip_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu ǝsiǝ lǝ ɔklɔ úsinkli úsu ditumbukplɛ nǝmǝ eto Yudafɔ eto lekpake nǝ nse. Se úsu údufǝ ditumbukplɛ nǝmǝ eto kɛnyɛ mfóo, betidi kpǝ ǝbǝ bátsyilama wǝ. ");
INSERT INTO lip_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Nya Yudafɔ eto katsyakɔ eto uninǝ ɔni utsyuǝ wǝ baakpo Yairo ǝbǝ mfó. Se únyǝ Yesuu, óse akonki lǝ wǝ akɔ. ");
INSERT INTO lip_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Nya ɔ́lɛ wǝ lekpakpa kekleke nkǝ, “Mɔ ubisiobi kɛkɛ lɛ bufi kekleke. Nyaso bǝ lǝ ǝbǝ efi fǝ kɔni ǝtǝkǝ lǝ wǝ bǝ lǝ ǝsuǝ lǝ imuǝ wǝ ale lǝ ɔkɛ nkpǝ.” ");
INSERT INTO lip_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Nyaso Yesu átaka útǝkǝko wǝ. Nya lǝ kase betidi ba díkǝko Yesu difui esoo, bátsyilama wǝ se bántɔ. ");
INSERT INTO lip_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Nya usio utsyuǝ akɛ lǝ mǝ nti, wǝ kɔtɔ díkakpo lǝ lefosi alɛ ǝnuǝ sɔ̃ɔ̃ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ɔkɛ lǝ kanyi ǝsuǝ lǝ lefe nǝ eto lefe mba leeyifo afa díkǝtǝ wǝ afa kulaatsya. Wóbiasǝ wǝ atabi kenke ótsya bufi bomfo, tsya bufi bomǝ mányuǝ wǝ. Kato bomu bóbe. ");
INSERT INTO lip_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ɔ́nɔ etiki itsyi lǝ Yesu ǝsuǝ, nyaso útǝkǝko betidi ba dítǝkǝko Yesu kama. ");
INSERT INTO lip_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ɔ́tɛyi wǝ ǝsuǝ nkǝ, “Lǝ mfó wǝ awu butidi koo, eni bufi bomǝ ǝbɔyɛ mɛ.” ");
INSERT INTO lip_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Nyaso lefe nǝ útidi Yesu eto awuu, kɔtɔ komǝ díkakpo wǝǝ, ála kplo lamfolamfo! Nya únyǝ utsyǝ lekpo lǝ wǝ ǝsuǝ nkǝ wǝ bufi bomǝ áyɛ wǝ, nyaso kanyi ka ɔnlɛ bunyǝǝ, álo. ");
INSERT INTO lip_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Lamfolamfo Yesu áte nkǝ ǝsuǝale ǝtsyuǝ ábɔ wǝ lǝ wǝ ǝsuǝ. Nyaso úkǝnǝ úńyǝ, nya ɔ́tsyi ɔwuninsǝ, nya ɔ́tɔ betidi bamǝ ntǝkǝko wǝ nkǝ, “Owoe ni futsyǝ dítidi mɛ awu?” ");
INSERT INTO lip_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Wǝ bakasebi bamǝ átɔ wǝ bǝnkǝ, “Be kase betidi bamfo letsyilama fǝ. Beso faatɔ fǝ, owoe ni futsyǝ dítidi fǝ?” ");
INSERT INTO lip_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Tsyaa, Yesu esi úkǝnǝ úńyǝ ɔlɛ ǝnǝmi botsyilamasǝ kabe lǝ woofo futsyǝ dítidi wǝ bunyǝ. ");
INSERT INTO lip_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Usio ǝmǝ mfó ǝnyǝ utsyǝ lekpo nkǝ lesatsyuǝ ǝbǝ wǝ lǝ ǝsuǝ. Nyaso lǝ sikpitete ku ketinkǝ ǝsuǝǝ, ɔ́bɔ úbǝ óse akonki lǝ Yesu eto akɔ. Nya ɔ́tɛyi wǝ lǝ ɔnukualɛ ǝsuǝ, lesa nǝ díbǝ. ");
INSERT INTO lip_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesu átɛyi wǝ nkǝ, “Mɔ ubisiobi, fǝ bofokanɔ átsya fǝ. Su lǝ diyuǝ ǝsuǝ. Fǝ kanyi ensiǝmbu sinkli kǝbǝ bio.” ");
INSERT INTO lip_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Lǝ lefe nǝ Yesu nlɛ nyamfo bɔtɛyii, batɔnkpe bǝtsyuǝ étsyi Yudafɔ eto katsyakɔ kamǝ eto uninǝ ǝmǝ eto diyo bǝbǝ nya bátɛyi wǝ bǝnkǝ, “Fǝ ubi ǝmǝ ébukpǝ koko. Beso fensi fanlɛ Oteasa ǝmfo bulǝ?” ");
INSERT INTO lip_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesu méntsyue ditiki nǝ mba nlɛ bɔtɛyi mfó ato. Bomu ɔ́tɛyi Yairo nkǝ, “Mante sikpi, fo anɔ ete.” ");
INSERT INTO lip_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Nya Yesu lékpa Petro ku Yakobo ku wǝ ɔyimisani Yohanes mate hã, nya bésu Yairo eto diyo. ");
INSERT INTO lip_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Nya lefe nǝ bédufǝ diyo nǝmǝ, nya Yesu dínyǝ kase banlɛ kanyi bunyǝ kakpo edu kewi nkuu, ");
INSERT INTO lip_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","údufǝ lǝ mǝnti nya ɔ́tɔ mǝ nkǝ, “Be léboko kudu komfo bokpo? Beso bɛnlɛ nku? Dikpefi nǝmfó ménkpǝ. Selabe ete onlabe.” ");
INSERT INTO lip_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Se ɔ́tɛyi nkoo, betidi ba ńyǝ mfó étsyiko wǝ bumǝ. Nyaso Yesu ǝtǝ nkǝ mǝmblɛ bɔ besu lekple, nya útǝ ubi ǝmǝ eto anto ku ambe ku wǝ bakasebi itsyǝ bamǝ nkǝ bedufǝ kaka ubi ǝmǝ díkpe ónlabe lǝ kasɔ. ");
INSERT INTO lip_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yesu ákɔbe usiobi kɛkɛ ǝmǝ lǝ kɔni nya ɔ́tɛyi wǝ nkǝ, “Talita Koumu.” Nya kasɔ lǝ sele siamǝ ni nkǝ, “Disiobi, nlɛ fǝ bɔtɛyi minkǝ, taka ǝńyǝ!” ");
INSERT INTO lip_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Lamfolamfo, disiobi nǝmǝ nǝ dikafo lefosi alɛ ǝnuǝǝ, átaka úńyǝ nya útsyiko bɔyɛ katsyilama. Se íbǝ nkoo, íyifo mǝmblɛ yanii. ");
INSERT INTO lip_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Nyaso Yesu ǝkǝ mǝ ato kekleke nkǝ bantɛyi kuutsyuǝ saa. Nya kamaa, ɔ́tɛyi mǝ nkǝ, “Bitǝ wǝ lesatsyuǝ lǝ udi.” ");
INSERT INTO lip_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu édu mfó úsu wǝ umǝ kaka úsiǝ óbe, ku wǝ bakasebi. ");
INSERT INTO lip_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Nya lǝ Yudafɔ eto Ɔnwɛditsyǝyi ǝsuǝǝ, úsu ɔlɛ Anantotiki búdi lǝ Yudafɔ eto katsyakɔ mfó. Nyaso íyifo betidi ba kenke lɛnɔ wǝ asatetee yanii. Bátɔ bǝtsyuǝ bǝnkǝ, “Sieti ókase etiki nyamfo eto okle utsyiko? Nte kobe ko eto okle nkpe wǝ bǝ woafo ayanisa nyamfo eto okle buyifo? ");
INSERT INTO lip_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Inni wǝ ni Maria eto ubi wǝ ni nwǝ laawe keyi? Lee inni wǝ ni Yakobo ku Yose ku Yuda ku Simon eto ɔyimisani? Nya wǝ bayimisio tsya nkpe mfo!” Nyaso betidi bamfo mámfo wǝ. ");
INSERT INTO lip_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesu átɛyi mǝ nkǝ, “Onanto eto unyǝlǝkǝtidi kpe dibu lǝ nlebe kpǝ. Fɛɛ lǝ wǝ kosate eto umǝǝ, lǝ wǝ betidi ntii, ku lǝ wǝ kosate eto diyo eto betidi eto ǝnǝmii, umbǝ dibu saa.” ");
INSERT INTO lip_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6","Nnya ni bǝnkǝ wǝ kosate eto umǝ eto betidi mámfo wǝ banɔ, etiki nyamfo éyifo Yesu yanii tinti. Lǝ nyamfo eso wóamfo ayanisa kpǝ buyifo mfó enso nnya úfi wǝ ani útǝkǝ befimfi bǝtsyuǝ lǝ ǝsuǝ nya mǝ bufi díyuǝ mǝ. Lǝ nyamfo eto kamaa, Yesu átsyilama mbuto bo letsyilama mfó, kate Anantotiki nyamǝ. ");
INSERT INTO lip_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Nya ókpadi wǝ bakasebi lefosi inuǝ bamǝ utsyǝ, nya óla mǝ ótsyese inuǝ inuǝ. Útǝ mǝ ǝsuǝale nkǝ baso awɔnɔ bua ani. ");
INSERT INTO lip_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Nya ɔ́tɛyi mǝ nkǝ, “Mi kuutsyuǝ saa manlɛ kulesa usuko kusu komǝ, enso uyi wǝ baalɛɛ kɔni hã. Bientsyi didisa nye otobe fenkǝ mba laatɔ asa kafe. Bientsyi atabi lǝ mi katobe. ");
INSERT INTO lip_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Bekpe mi afɔkpa, tsya bientsyi akpesa bamba saa enso nnya benkpe.” ");
INSERT INTO lip_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Usi ɔ́tɛyi mǝ nkǝ, “Kaka kee bafo mii, bɛkɛ mfó isu ese lefe nǝ biuudu. ");
INSERT INTO lip_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Lǝ bídufǝ umǝ utsyuǝ nya betidi bamfó dímamfo mi nye báni bǝ beembutsyue mi ditiki kotoo, bidu lǝ bɛflɛ mi nkpafo eto sitǝ bekpo mfó. Nyamfo loote Onanto eto kotonǝnǝ eto ditsyǝbi nǝ lǝǝbǝ bubǝ itǝ mǝ lǝ umǝ ǝmǝ.” ");
INSERT INTO lip_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Nyaso bakasebi bamǝ édu bésu bátsyilama bédi Anantotiki nyamǝ budi kafe bǝ utsyuǝ saa sinkli lǝ abuayifoyifo kama. ");
INSERT INTO lip_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Bála awɔnɔ bua kpǝ lǝ betidi ǝsuǝ. Nya bédiki befimfi kpǝ nnuǝbi itǝ bǝmuǝ ale. ");
INSERT INTO lip_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Lǝ lefe nǝmfóo, Oka Herodes ákanɔ asa nnya kenke nlɛ búbǝ bɔ́nɔ, itsyise Yesu eto diye áyɛ letsyo ésu kalebe saa. Betidi bǝtsyuǝ ákatɛyi bǝnkǝ, “Yohanes wǝ ni ntuflǝsǝtidi ésinkli úbǝ nkpǝ! Nyaso onkpe ǝsuǝale ɔnlɛ ayanisa buyifo nɛ!” ");
INSERT INTO lip_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Bǝtsyuǝ tsya ákatɛyi bǝnkǝ, “Wǝ ni Onanto eto Unyɛlǝkǝtidi Elia.” Betsyuǝ tsya bǝ, “Wǝ ni Onanto eto Unyɛlǝkǝtidi, itsyise útǝ fe Onanto eto bǝnyɛlǝkǝtidi eto ɔni.” ");
INSERT INTO lip_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Lefe nǝ Herodes lɛnɔ nyamfóo, wuntsya átɛyi nkǝ, “Yohanes wǝ útǝ bála disi uni disi ósankli utsyi ɔkɔmǝ úbǝ!” ");
INSERT INTO lip_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ɛtɔnsǝǝ, Herodes kosate dítǝ kusu nkǝ bǝmuǝ Yohanes, nya útǝ kusu nkǝ bakle wǝ, befi wǝ bakpe lǝ diyo. Herodes éyifo nyamfo itsyi lǝ Herodia wǝ úsu úfi, wǝ dídi wǝ ɔyimi Filipo eto usiǝ eso. ");
INSERT INTO lip_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Yohanes ákatɛyi Herodes nkǝ, “Yanlɛkɛ bǝ fo fǝ ɔyimisani eto usiǝ efi.” ");
INSERT INTO lip_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Nyaso Yohanes eto etiki ǝkǝlǝ Herodia, nyaso úkǝkisi wǝ. Nya ɔ́bɛbɛ kusu nkǝ lǝ olo wǝ. ");
INSERT INTO lip_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Tsyaa, wámfo kusu bunyǝ lǝ Herodes eso. Itsyise Herodes áte Yohanes sikpi se unyi nkǝ Yohanes éyifo ɔnukualɛtidi ku utidi wǝ díyifo kɛnkɛ eso. Nyaso úkase wǝ. Lefe kpǝ, óla nkǝ lǝ úkanɔ wǝ asatete, ite bǝ wǝ etiki nyamǝ káto wǝ lǝ lɛkɔɛsi lɛ ɔ́nɔ nnya tsya fɛ. ");
INSERT INTO lip_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Lǝ kalosǝkɔɔ, íbǝ bǝ Herodia ǝnyǝ kusu ko ɔnlɛ bɔbɛbɛ. Diyi nǝmfó didi Herodes eto leleyi. Herodes ákpadi wǝ beninǝtidi lǝ wǝ sekakedikɔ ku wǝ bamamanyǝ eto beninǝ ku Galilea eto kasɔ eto beninǝ kplɛkplɛ lǝ wǝ lesakedikɔ. ");
INSERT INTO lip_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodia eto kebitɛ ǝbǝ mfó úwi kewi ókpe disuǝyuǝ nya Oka Herodes ku wǝ bahɔ lǝ lesakedikɔ mfó tinti. Nyaso Oka Herodes átɔ kebitɛ kamǝ nkǝ, “Be faala fǝ lǝ ntǝ fǝ?” ");
INSERT INTO lip_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Nya usi ɔ́tɛyi wǝ tsya nkǝ, “Ekpe lǝ mɔ lekankpomɛ, minkǝ muutǝ fǝ lesa nǝ ke fɔɔtɔ mɛ, lǝ mɔ sekakedikɔ eto kutsyǝ kulaa tsya!” ");
INSERT INTO lip_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Nyaso usiobi ǝmfo átaka úsu ɔ́tɔ wǝ ambe nkǝ, “Be ele bǝ ntɔ?” Nya wǝ ambe lɛtɛyi wǝ nkǝ, “Tɔ wǝ Yohanes Ntuflǝsǝtidi eto disi.” ");
INSERT INTO lip_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Disiobi nǝmfo ésinkli kpla dísu diyo nǝmǝ kafo nya ɔ́tɛyi Herodes nkǝ, “Nla minkǝ la Yohanes Ntuflǝsǝtidi eto disi ǝtǝkǝ lǝ ɔkpɛ tɛnklɛ ǝsuǝ ǝtǝ mɛ mɔmɔmɔmɔ!” ");
INSERT INTO lip_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nyamfo ába oka Herodes lɛkɔɛsi, fɛɛ wǝnsiǝmbofo ntamu bo óka utsyǝ lǝ beninǝtidi bamfó eto ǝnǝmi butu. ");
INSERT INTO lip_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Lǝ nyaso ókpe wǝ oblafɔ lamfolamfo nkǝ usu ola Yohanes eto disi lǝ ufi oboko. Nya oblafɔ ǝmfó dídu úsu Aba eto diyo nǝ baakpe betidi, mfó úsu óla Yohanes eto disi. ");
INSERT INTO lip_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Kamaa, úfi disi nǝmǝ útǝkǝ lǝ ɔkpɛ tɛnklɛ ǝsuǝ nya úfi ni oboko disiobi nǝmǝ. Nya wuntsya dífi ni úsu útǝ wǝ ambe. ");
INSERT INTO lip_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Lefe nǝ Yohanes eto bakasebi lɛnɔ ditiki nǝmfoo, bésu báfo wǝ ɔkɔ bésu bébikǝ. ");
INSERT INTO lip_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Batɔnkpe ba Yesu lékpe nkǝ besu batsyilama lekpake mfóo, ésinkli bǝbǝ bátɛyi wǝ nnya kenke bésu beyifo ku asa nnya báte. ");
INSERT INTO lip_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Nya kaka mǝ ku Yesu lɛsɔnɔ eto betidi kpǝ ba nlɛ búbǝ kédu étsyiko bufui. Nyaso Yesu ku wǝ bakasebi mánkɛ lefe lǝ bedi lesa kula tsya. Nyaso Yesu átɛyi mǝ nkǝ, “Bitǝ lǝ bo hã lǝ busu kaka lɛbiɔ lǝ busiǝ mfó butsyǝ ɔnwɛ sɛkɛ.” ");
INSERT INTO lip_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Nyaso bésu bédufǝ lǝ ɔklɔ lǝ besu kaka betidi lǝmbǝ. ");
INSERT INTO lip_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Fɛɛ lefe nǝ bántɔɔ, betidi kpǝ ǝnyǝ mǝ bǝtsyǝ lekpo, nya bétsyetsyi bátɔ sɛtɔ bésu baka mfó budufǝ fɛ Yesu ku wǝ bakasebi dísu bédufǝ mfó. ");
INSERT INTO lip_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Se Yesu lɛbɔ lǝ ɔklɔ ǝmǝ únyǝ sitiditu siamǝǝ, mǝ asa ǝnǝ wǝ kafo itsyise bǝtsyǝ fe basamu ba lǝmbǝ obebe. Nyaso útsyiko mǝ asa kpǝ bote itsyi lǝ Onanto ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Lefe nǝ ditsyitsyo léyoo, wǝ bakasebi ányi bésu wǝ ɔflɔ nya bátɛyi wǝ bǝnkǝ, “Kale bolo. Nya kase mfo diyifo ntɛntii, bǝǝmbunyǝ kulesa bedi. ");
INSERT INTO lip_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Nyaso lǝkǝ mǝmblɛ kusu lǝ bedu. Lǝ bedufǝ kǝmǝ ku mbuto bo lɛfi mfoo, boofó lesatsyuǝ bunyǝ kaya kedi.” ");
INSERT INTO lip_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yesu átɛyi mǝ nkǝ, “Mi kosatee, bitǝ mǝ lesatsyuǝ lǝ bedi.” Nya bátɛyi wǝ bǝnkǝ, “Nyamfó ebofo fe utsyuǝ eto afa mflamfla eto kayofofo! Ala fǝ bobiasǝ nyamfo lǝ mǝ budi ǝsuǝ?” ");
INSERT INTO lip_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Nya Yesu lɛtɔ mǝ nkǝ, “Abolo asia bɛnlɛ? Bisu bebe!” Nya se bésu bábee, bátɛyi wǝ bǝnkǝ, “Abolo anɔ ku akpɛ ǝnuǝ ete ntǝ.” ");
INSERT INTO lip_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Yesu átɛyi wǝ bakasebi nkǝ bǝtǝ lǝ betidi bamǝ kenke lǝ bǝsiǝ kasɔ lǝ sefa siamǝ ǝsuǝ mfó lǝ etsyukpa etsyukpa ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Nyaso betidi bamfo kenke ǝsiǝ kasɔ lǝ etsyukpa etsyukpa ǝsuǝ ǝtsyuǝ fe betidi kolofa nya ǝtsyuǝ fe betidi awosi anɔ. ");
INSERT INTO lip_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Nya Yesu dífi abolo ku akpɛ nyamǝ, nya se óbe kato, nya ɔ́sɔ Onanto ani. Nya úbudi abolo nyamǝ nya úfi nnya útǝ wǝ bakasebi nkǝ bǝsiǝ bǝtǝ etsyukpa etsyukpa nyamǝ. Nya úsiǝ akpɛ nyamɛ tsya nko útǝ mǝ. ");
INSERT INTO lip_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Mba kenke lɛkɛ mfó édi bémi. ");
INSERT INTO lip_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Nya se wǝ bakasebi lɛsɛ didisa nǝ díbu bakɔɔ, díyi lefosi etsyitsya kplɛ ǝnuǝ. ");
INSERT INTO lip_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Nya mba dídi lesa nǝmfo eto basani mate éyifo betidi akpi anɔ. ");
INSERT INTO lip_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Lamfolamfo Yesu átɛyi wǝ bakasebi nkǝ bedufǝ lǝ ɔklɔ ǝmǝ lǝ besu umǝ wǝ baakpo Betsaida, lǝ ditumbukplɛ nǝmǝ eto lekpake nǝ nse. Nya útǝ nkǝ sitiditu siamǝ sǝnsǝ sidu. ");
INSERT INTO lip_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Nyamfo eto kamaa, wuntsya édu óbe kɔtini komǝ nkǝ lǝ usu oto ola. ");
INSERT INTO lip_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Se éyo ketsyee, ɔklɔ ǝmǝ áyo ditumbukplɛ nǝmǝ eto ntinti, Yesu mate hã díbu uńyǝ mfó. ");
INSERT INTO lip_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Únyǝ nkǝ wǝ betidi édufǝ lǝ bulǝ ǝsuǝ ku kase bánlɛ ɔklɔ ǝmǝ bofo bonwa itsyise ufiebi lɛ bɔsɔ kǝlǝ mǝ. Nyaso lǝ kolensiǝnto kplɛɛ, Yesu áyɛ lǝ ntu bomǝ ǝsuǝ úsu mǝ ɔflɔ eti nkǝ lǝ ɔyɛ ofe. ");
INSERT INTO lip_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Nya se bǝnyǝ wǝ lǝ ntu bomǝ ǝsuǝǝ, báfa bátɛyi bǝnkǝ, “Ɔkɔ ni.” ");
INSERT INTO lip_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Mǝmblɛ áte sikpi se bǝnyǝ wǝ. Nyaso Yesu átɛyi mǝ lamfolamfo nkǝ, “Biante sikpi! Mɔ uni! Bimuǝ utu bɛlɛ!” ");
INSERT INTO lip_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Nya óbe údufǝ lǝ mǝ ɔklɔ ǝmǝ kafo, nya ete ufiebi ǝmǝ lɛyɛ bɔsɔ. Nyamfo éyifo wǝ bakasebi yanii ku kafɔsu. ");
INSERT INTO lip_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Itsyise bánte kase ko íbǝ fɛ útǝ betidi akpi anɔ bamfo lesa bédi banɔ. Mǝ nsusu mánkpa ko mǝ lǝ nyamfó ǝsuǝ, itsyise bámfo wǝ bánɔ. ");
INSERT INTO lip_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Se bédufǝ ditumbukplɛ nǝmǝ eto lekpake nǝ nsee, báyifǝ lǝ Genesaret eto kasɔ. Nya bátsyasǝ mǝ ɔklɔ ǝmǝ mfó. ");
INSERT INTO lip_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Kase báyifǝ lǝ ɔklɔ ǝmǝ koo, betidi ǝtsyǝ Yesu lekpo. ");
INSERT INTO lip_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Nyaso betidi bamǝ étsyetsyi bésu bátɛyi mǝ betidi kenke lǝ kasɔ kamǝ. Nya kaka ke bánɔ bǝ Yesu kpee, bétsyi befimfi lǝ mǝ belabekǝ ǝsuǝ báboko wǝ ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Nya kaka ke Yesu dísu koo, umǝ ni o-o, kebuto keni o-o, betidi ko díketsyi mǝ befimfi kaboko obia nya bánlɛ wǝ lekpakpa bǝnkǝ utǝ lǝ betidi wǝ awu eto atosi ete. Nya mba dítidi nnyaa, ǝmuǝ ale. ");
INSERT INTO lip_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Farisifɔ ku afi eto bateasa ba dítsyi Yerusalem ǝbǝ bátsyilama Yesu. ");
INSERT INTO lip_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Bǝnyǝ bǝ wǝ bakasebi si balɛ lesa budi nya bǝtsyuǝ mǝmflǝ mǝ ani fe kase Farisifɔ laate betidi bǝ ele bǝ bǝflǝ. ");
INSERT INTO lip_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Bǝnyǝ nyamfo bǝtsyǝ lekpo itsyise Farisifɔ ku Yudafɔ fɛfɛ kenke eeyifo lǝ mǝ batekoko, banakoko eto akpa nnya báyani bǝtsyǝ nya báte mǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Nya lǝ báya lesa saa betsyiko bikǝkatekɔ tsyaa, ele bǝ bǝflǝ mǝ ani fɛ lǝ bedi. Nya ele bǝ beyifo lǝ afi kpǝ nnya bǝbǝ bétu, fe kase bǝǝflǝ akɔbe ku ekplibi ku kalɔtsyi. ");
INSERT INTO lip_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Lǝ nyaso Farisifɔ ku afi eto bateasa átɔ Yesu bǝnkǝ, “Beso fǝ mba ntǝkǝko fǝ lǝǝnyifo lǝ bo batekoko ku banakoko eto akpa ǝsuǝ? Nya banlɛ asa budi lǝ mǝ ani mǝflǝmflǝmflǝ ǝsuǝ?” ");
INSERT INTO lip_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesu ǝlǝkǝ kɛnyɛ ɔ́tɛyi nkǝ, “Ǝnǝmi ǝnǝmi eto betidi bini! Lesa nǝ Onanto eto Unyɛlǝkǝtidi Yesaya lɛwɔni ɔ́tɛyi utsyǝ lǝ mi ǝsuǝǝ, íbǝ ítǝ sitinti! Ɔ́tɛyi bo nkǝ, Onanto átɛyi nkǝ, ‘Betidi bamfoo, ǝnǝmi ǝnǝmi eto dibu ete bǝǝtǝ mɛ, banla mɛ itsyi lǝ mǝ akɔɛsi. ");
INSERT INTO lip_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Bimba ete ini bǝ bálɛ mɔ lelabi buyifo. Baate kawunsiǝ eto afi nnya betidi dítsyǝ fenkǝ mɔ afi ini.’ ");
INSERT INTO lip_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Nnya lete bǝ bifi mɔ kɔfi bɛkula nya bɛnlɛ mi kawunsiǝ mfo eto akpa boté.” ");
INSERT INTO lip_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yesu esi ɔ́tɛyi mǝ nkǝ, “Bekpe awɛsu ǝtsyuǝ nnya biefi akayɛ lǝ nnya ǝsuǝ kani Onanto eto kɔfi budi, keyifo batekoko ku banakoko eto akpa. ");
INSERT INTO lip_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Onanato eto Unyɛlǝkǝtidi Moses áwɔni útsyǝ nkǝ, ‘Bu fǝ anto ku fǝ ambe. Ɔ́tɛyi tsya nkǝ fǝǝ ke léka fǝ anto ku fǝ ambee, ele bǝ balo fǝ.’ ");
INSERT INTO lip_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Fɛɛ biatɛyi biǝnkǝ ɛlɛkɛ bǝ utidi ebofo lesa bɔni butǝ wǝ anto ku ambe ba lesa lehiã, ku nsusu bǝ lesa nǝmǝ eyifo kɛnkɛ, kato taflatsyǝ ku nsusu bǝ wuufi lesa nǝmǝ utǝ Onanto bomu eso. ");
INSERT INTO lip_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Nya ɛyɛ le bo akpa ǝsuǝǝ, boata Onanto eto kɔfi kebu. ");
INSERT INTO lip_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Nko ini bǝ biefi mi bana eto akpa kaninsǝ Onanto eto afi. Nya bieyifo asa bamba kpǝ tsya fe nyamfo eto okle.” ");
INSERT INTO lip_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Lǝ nnya kamaa, Yesu esi ókpadi sitiditu siamǝ nkǝ bányi bafi wǝ. Nya ɔ́tɛyi mǝ nkǝ, “Mimblɛ kenke bitsyue mɛ ato lǝ bɛnɔ kasɔ. ");
INSERT INTO lip_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Lesa nǝ ke utsyuǝ dídi ókpe lǝ kafo ǝmbutǝ obiasǝ wǝ ǝsuǝ. Bomu lesa nǝ ke ditsyi lǝ wǝ lɛkɔɛsi ɔtɛyii, nnya ni lesa nǝ lǝǝtǝ weeyifo lebua nɛ. ");
INSERT INTO lip_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Mimblɛ kenke bitsyuǝ ato lǝ bɛnɔ mɛ kasɔ.” ");
INSERT INTO lip_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Lǝ nyamfo eto kamaa, se údu lǝ mǝ ɔflɔ úsu diyoo, wǝ bakasebi átɔ wǝ bǝnkǝ ulǝkǝ lekpa nǝmǝ eto kasɔ ote mǝ. ");
INSERT INTO lip_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yesu átɛyi mǝ nkǝ, “Lǝ biannɔ lekpa nǝmfo kasɔɔ, nyalɛ mi nsusu ǝmbǝ kulesa kasɔ bofo bɔnɔ! Ekpa bǝnkǝ lesa nǝ didufǝ lǝ utidi kafoo, ǝmbutǝ utidi ǝmǝ yifo lebua, ");
INSERT INTO lip_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","itsyise yeendufǝ lǝ wǝ utu kǝmiǝ. Wǝ kafo bomu yuudufǝ nya yɔɔyɛ ɛbɔ lǝ wǝ kafo fe lesa biabia.” Nyaso nnya Yesu lɛtɛyi mfoo, ate bǝnkǝ didisa saa alɛkɛ itǝ budi. ");
INSERT INTO lip_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Nya úsukosǝ ɔ́tɛyi nkǝ, “Lesa nǝ lɛbɔ itsyi lǝ utsyuǝ eto lɛkɔɛsii, ni laabiasǝ utidi nɛ. ");
INSERT INTO lip_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Itsyise nsusu bua saa aabɔ ketsyi lǝ utidi eto lɛkɔɛsi kǝmiǝ nya mu lǝǝtǝ wǝǝyifo asa bua nɛ. Asa nyamfó ni fenkǝ, lɛsɔnɔdi ku kuyu ku ditilo ku disǝnkpo, kusiǝ kamafefe ku sidikpuu, ");
INSERT INTO lip_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ku nsusu bua fifi ku kawɛ ku disiale, sidia tɛyitɛyi kabiasǝ utidi eto diye ku nsusu bua kekleke fifi lǝ sisǝ ku sisiǝ ǝsuǝ, nya lǝǝnǝ utidi kakpe lǝ kofani ǝsuǝ, ǝnǝmi sɛsǝsɛsǝ lǝ utidi bamba eto bikǝ ǝsuǝ, diye biasǝbiasǝ, ǝsuǝ kato bobesǝ, ebukisa yifoyifo, koto mentsyue mentsyue. ");
INSERT INTO lip_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Asa bua nyamfo kenke aabɔ ketsyi lǝ utidi eto lɛkɔɛsi, nya laabiasǝ utidi nɛ.” ");
INSERT INTO lip_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Nyamfo eto kamaa, Yesu édu úsu umǝ utsyuǝ lǝ Tiro eto kasɔ. Úsu diyo ditsyuǝ kaka wóanla nkǝ kuutsyuǝ saa te nkǝ okpe mfó, tsyafɛ wóamfo bɔbiɔ. ");
INSERT INTO lip_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Mfóo, se usio utsyuǝ wǝ lɛwɔnɔ bua nlɛ wǝ ubi bulǝ lɛnɔ nkǝ Yesu kpe lǝ mfóo, úbǝ wǝ ɔflɔ akpa akpa nya óse akonki lǝ wǝ ǝnǝmi. ");
INSERT INTO lip_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Usio ǝmfo enni Yudanyǝ. Bále wǝ lǝ umǝ wǝ baakpo Foinike lǝ Siria eto kasɔ. Nya ɔ́lɛ Yesu lekpakpa nkǝ ola lɛwɔnɔ nǝmǝ ɔbɔnko lǝ wǝ ubi ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Nya Yesu lékpasǝ wǝ nkǝ, “Tutɛɛ, tǝ bekpefi lesa etɔ. Yanlɛkɛ bǝ befi bekpefi eto lesa bǝtǝ bakpa.” ");
INSERT INTO lip_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Lǝ nnya ǝsuǝ usio ǝmfo ǝtǝ wǝ mbuayɛ nkǝ, “Ao, mɔ Onamute, bakpa bamǝ lǝ ɔpunu kalɔ lǝ lesakedikɔ mfóo, ebunyǝ lesa nǝ bekpefi bamǝ nlǝ budi eto nǝ lookpoo kasɔ bedi.” ");
INSERT INTO lip_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Nya Yesu lɛtɛyi wǝ nkǝ, “Lǝ kase fǝtǝ mbuayɛ mfo esoo, du esu diyo. Ebunyǝ se lɛwɔnɔ nǝmǝ díkayani fǝ ubi ǝmǝ.” ");
INSERT INTO lip_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Nyaso usio ǝmfo édu úsu diyo. Lǝ mfóo, únyǝ nkǝ wǝ ubi labe lǝ wǝ kalabekɔ, nya lɛwɔnɔ bua nǝmǝ lénsisi wǝ lǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Se Yesu lídu lǝ Tiro eto lekpake mfóo, ɔ́yɛ lǝ Sidon úsu Galilea eto Ditumbukplɛ kama kaka Kǝmǝ Lefosi kamǝ nkpe eti. ");
INSERT INTO lip_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Nya mfóo, betidi bǝtsyuǝ ákpa utidi utsyuǝ wǝ ni ototi ku ɔmumu báboko wǝ ɔflɔ nya bálɛ wǝ lekpakpa bǝ utǝkǝ ani lǝ wǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Nyaso Yesu ákpa wǝ usuko lɛkpɔ kaka betidi ku kudu lǝmbǝ, nya úfi wǝ animi ókpe wǝ lǝ ato. Útufǝ ntufǝ ókpo lǝ wǝ animi nya ɔ́kɔbe utidi ǝmǝ eto odiakami. ");
INSERT INTO lip_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Nya Yesu lébesǝ wǝ ǝnǝmi óbe kato nya ɔ́wɔnɔ fũũ, nya ɔ́tɛyi osani ǝmǝ nkǝ, “Hefata,” eto kasɔ ni bǝǝ, “Sini!” ");
INSERT INTO lip_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Lamfolamfo, osani ǝmǝ eto ato ásini nya wǝ odiakami tsya lényankli nya ófo etiki budi. ");
INSERT INTO lip_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesu ákpe betidi ba dinyǝ mfó kɔfi nkǝ bántɛyi utidi saa kulesa, itsyi lǝ lesa nǝ bǝnyǝ mfó. Fɛɛ bimbaa ete ɔ́ninko mǝ, itsyise kase ókpe mǝ kɔfii, nko kǝ banlɛ nnya bokpantsyasǝ nɛ. ");
INSERT INTO lip_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Nya betidi ba kenke lɛnɔ asa nyamfóo, iyifo mǝ naa efensǝ! Nya bátɛyi mǝ ǝsuǝ bǝ, “Wǝǝyifo lesa saa kukɔnɔ. Wǝǝtǝ bamumu leedi etiki, nya batoti tsya laanɔ asa!” ");
INSERT INTO lip_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Lǝ eyi nyamfó ǝsuǝǝ, betidi kpǝ ǝbǝ bátsya mfó. Nya se kulesa dímǝntsyǝ boodi esoo, Yesu ákpadi wǝ bakasebi óboko wǝ akɔ nya ɔ́tɛyi mǝ nkǝ, ");
INSERT INTO lip_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Betidi bamfo eto asa lɛ mɛ kaminsǝ, itsyise eyi ǝtsyǝ sɔ̃ɔ̃ ni nyamfo se bǝbǝ mɔ ɔflɔ nɛ. Nya mɔmɔɔ, kulesa ente boodi. ");
INSERT INTO lip_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Lǝ nyani mǝ beluu, kukpɛnsɛ ebɔlɛ mǝ kola disi lǝ kusu itsyise mǝ bǝtsyuǝ etsyi katsyontsyokɔ.” ");
INSERT INTO lip_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Nya wǝ bakasebi lɛtɔ wǝ bǝnkǝ, “Se utidi luunyǝ lesa utǝ betidi bamfo lǝ mfiminti mfo bǝ bedi bemi?” ");
INSERT INTO lip_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Mfó Yesu lɛtɔ mǝ nkǝ, “Abolo asia nte mi?” Bátɛyi wǝ bǝnkǝ, “Abolo akuanse.” ");
INSERT INTO lip_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yesu átɛyi mǝmblɛ nkǝ bǝsiǝ kasɔ. Nya úfi abolo akuanse nyamǝ, nya ɔ́sɔ Onanto ani, nya úbudi nnya úfi útǝ wǝ bakasebi nkǝ befi bǝtǝ betidi bamǝ kenke. Nya mǝ tsya dífi nnya bésiǝ bǝtǝ mǝ. ");
INSERT INTO lip_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Akpɛ asiani tsya ǝtsyǝ. Yesu éfi nnya tsya nya ɔ́sɔ ani. Nya úfi nnya útǝ wǝ bakasebi nkǝ besiǝ nnya tsya bǝtǝ mǝ. ");
INSERT INTO lip_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Betidi bamfó kenke édi bémi. Betidi bamǝ eto utu ebuyifo akpi ana. Se bédi bálosǝǝ, bakasebi bamǝ ásɛ abolo wɛlɛwɛlɛ nnya díbu nya íyi etsyitsya kplɛkplɛ akuanse. Nnya kamaa, Yesu ǝlǝkǝ betidi bamfo kenke kusu nya bédu. ");
INSERT INTO lip_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Nya Yesu ku wǝ bakasebi dídufǝ lǝ ɔklɔ báyila ditumbukplɛ bésu Dalmanuta eto lekpake. ");
INSERT INTO lip_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Farisifɔ bǝtsyuǝ ǝbǝ Yesu ɔflɔ nya bétsyiko wǝ etiki bunǝnko lǝ befi bato wǝ babe. Nyaso bátɛyi wǝ bǝ uyifo ayanisa ǝtsyuǝ ote mǝ lǝ bate bǝ Onanto ɔflɔ útsyi úbǝ. ");
INSERT INTO lip_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Nyamfo ǝlǝ Yesu tinti nya óla ɔwɔnɔ nya ɔ́tɔ mǝ nkǝ, “Beso kon mmi eto betidi laabɛbɛ bǝ bǝǝnyǝ ayanisa fɛ lǝ bafo banɔ? Kulefe, nlɛ mi bɔtɛyi minkǝ, membuyifo ayanisa nnya eto okle bela biǝ biǝnyǝ mfo!” ");
INSERT INTO lip_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Nya údu lǝ mǝ ɔflɔ, nya úsinkli údufǝ lǝ ɔklɔ nya ɔ́yila ditumbukplɛ nǝmǝ úsu ni lekpake nǝ nse. ");
INSERT INTO lip_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Kase banlɛ ditumbukplɛ nǝmǝ bɔyilaa, wǝ bakasebi bamǝ áta ǝsuǝ béntsyi abolo kpǝ. ");
INSERT INTO lip_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Nya Yesu lɛtɛyi mǝ nkǝ, “Bekpe kobe lǝ bitsyue ato lǝ bɛnɔ etiki itsyi lǝ oka Herodes ku Farisifɔ eto ǝyǝnkisǝsa ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Lefe nǝmfóo, mǝ sɔ̃ɔ̃ dínyǝ mfó bánlɛ etiki búdi katɛyi bǝ, “Lee nnya buuntsyi abolo kpǝ eso ɔnlɛ bɔtɛyi nkoo?” ");
INSERT INTO lip_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Fɛɛ se Yesu nyi etiki nnya banlɛ bɔtɛyi esoo, ɔ́tɔ mǝ nkǝ, “Beso bɛnlɛ etiki lǝ abolo butsyi ǝsuǝ? Ibǝ ese mɔmɔɔ, biǝnyǝtɔ nye bɛnɔ kasɔ? Bitidi ato ko! ");
INSERT INTO lip_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Bekpe ǝnǝmi, tsya fɛ biǝnnyǝ! Bekpe ato, tsya fɛ biannɔ! ");
INSERT INTO lip_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Bíankloma lefe nǝ ménsie abolo anɔ míntǝ betidi akpi anɔ dídi? Etsyitsya kplɛ asia nnya wɛlɛwɛlɛ díbu díyi?” Bátɛyi wǝ bǝnkǝ, “Lefosi etsyitsya ǝnuǝ.” ");
INSERT INTO lip_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Yesu esi ɔ́tɔ mǝ nkǝ, “Nya lǝ lefe nǝ mínsiǝ abolo akuanse míntǝ betidi akpi anaa, nnya wɛlɛwɛlɛ díbuu, etsyitsya asia íyi?” Bátɛyi wǝ bǝnkǝ, “Akuanse.” ");
INSERT INTO lip_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Nya ɔ́tɔ mǝ nkǝ, “Ibǝ ese mɔmɔɔ, biante tɔ futsyǝ mini?” ");
INSERT INTO lip_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Se Yesu ku wǝ bakasebi dídufǝ Betsaida, betidi bǝtsyuǝ ákpa unǝmba utsyuǝ báboko Yesu ku wǝ bakasebi ɔflɔ nya bálɛ wǝ lekpakpa bǝ lǝ ufi wǝ kɔni utǝkǝ lǝ wǝ. ");
INSERT INTO lip_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesu ákɔbe nwǝ ǝmǝ lǝ kɔni nya ókpa wǝ ɔ́bɔnko lǝ umǝ nti. Se útufǝ ntufǝ ókpo lǝ unǝmba ǝmǝ eto ǝnǝmii, úfi wǝ ani útǝkǝ lǝ wǝ ǝsuǝ, nya ɔ́tɔ wǝ nkǝ, “Alɛ lesatsyuǝ bunyǝǝ?” ");
INSERT INTO lip_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Nya utidi ǝmǝ létakasǝ wǝ ǝnǝmi óbe kato nya ɔ́tɛyi nkǝ, “Ee, nlɛ betidi bunyǝ, tsya beyifo fe eyi. Fɛɛ balɛ bɔyɛ katsyilama.” ");
INSERT INTO lip_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Nya Yesu disi útidi wǝ ǝnǝmi. Lǝ lefe nuǝfǝ nǝmfoo, utidi ǝmǝ ásini wǝ ǝnǝmi kukɔnɔ, nya wǝ ǝnǝmi lékpa, nya únyǝ lesa saa kukɔnɔ. ");
INSERT INTO lip_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Nya Yesu dílǝkǝ wǝ kusu nkǝ udu usu wǝ diyo, wensisinkli usu umǝ ǝmǝ nti. ");
INSERT INTO lip_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Lǝ nnya kamaa, Yesu ku wǝ bakasebi édu mfó bésu kebuto kǝtsyuǝ ka lɛfi Kaisarea Filipi eto kasɔ eti. Nya lefe nǝ bányɛ lǝ kusu bantɔɔ, Yesu édi mǝ etiki ɔ́tɛyi nkǝ, “Bɛtɛyi mɛ, futsyǝ betidi laatɛyi bǝ wǝ mini?” ");
INSERT INTO lip_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Bátɛyi wǝ bǝnkǝ, “Bǝtsyuǝ lɛ bɔtɛyi bǝ fǝ ni Ntuflǝsǝtidi Yohanes. Nya bǝtsyuǝ tsya nlɛ bɔtɛyi bǝnkǝ fǝ ni Onanto eto Unyɛlǝkǝtidi Elia. Nya bǝtsyuǝ tsya nlɛ bɔtɛyi bǝnkǝ fǝ ni Onanto eto mba lǝǝlǝkǝ wǝ kɛnyɛ eto mba kɔ eto okle ɔni.” ");
INSERT INTO lip_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Nya Yesu disi ɔ́tɔ mǝ nkǝ, “Mimi nkpǝ, owoe biebu biǝ wǝ mini?” Petro átɛyi wǝ nkǝ, “Fǝ ni nwǝ Onanto lékpo ɔhile útsyǝ.” ");
INSERT INTO lip_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Nya Yesu díkǝ mǝ ato nkǝ bántɛyi ku utsyuǝ saa, lesa nǝ benyi itsyi lǝ wǝ mfo. ");
INSERT INTO lip_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Nya Yesu dítsyiko wǝ bakasebi asa ǝtsyuǝ bóte, ɔ́tɛyi mǝ nkǝ, “Ele bǝ ibǝ itǝ bǝ Utidi Eto Ubi nyǝ kanyi lǝ Yudafɔ eto beninǝ ku besumunyǝ ninǝ ku afi eto bateasa eto ani, bani wǝ. Boolo wǝ, tsya lǝ diyi tsyǝfǝǝ wootaka.” ");
INSERT INTO lip_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ɔ́tɛyi mǝ nyamfo ókpasǝ, bǝ lǝ banɔ kasɔ. Nya Petro lékpa wǝ usuko ɔflɔ wonko wǝ inuǝ, nya ɔ́ninko wǝ. ");
INSERT INTO lip_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Tsyaa, se Yesu díkǝnsǝ óbe wǝ bakasebii, údi etiki ku lɛblɔfi ókpe Petro nkǝ, “Obansam, du mɛ lǝ ɔflɔ!” Nya ɔlɔ bɔ́tɛyi nkǝ, “Anla asa nnya Onanto lala, bomu nnya betidinini lala!” ");
INSERT INTO lip_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Nyaso Yesu ákpadi betidi eto ditsyukpa nǝmǝ ku wǝ bakasebi óboko wǝ ɔflɔ nya ɔ́tɛyi mǝ nkǝ, “Lǝ utsyuǝ ala nkǝ wǝǝtǝkǝko mɛɛ, ele bǝ ulǝkǝ wǝ ato ku wǝ ǝsuǝ utsyiko lǝ wǝ alasa ǝsuǝ nya lǝ utsyi wǝ uyikabie utǝkǝko mɛ. ");
INSERT INTO lip_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Itsyise nwǝ ke lela nkǝ wǝǝlǝkǝ wǝ nkpǝǝ, woo nyansǝ mu. Nya utidi wǝ ke loonyansǝ wǝ nkpǝ lǝ mɔ disi ku lǝ Ditiki Sɛɛ nǝmfo esoo, wuunyǝ nkpǝ manlo. ");
INSERT INTO lip_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Nte kutǝkǝ ko utudi luunyǝ lǝ kawunsiǝ kamfo eto bikǝ kenke afiani wǝ bele fɛ wǝnnyǝ nkpǝ manlo? ");
INSERT INTO lip_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Nye be utidi luufi ofloma ko bǝ lǝ unyǝ nkpǝ manlo? ");
INSERT INTO lip_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mɔmɔ mfoo, betidi kpǝ lǝ asa bua buyifo ketsyi kama kakpe Onanto. Nyaso lǝ utsyuǝ efi mɔ ku mɔ asatete fe afanisa mɔmɔɔ, wuuntsya ebudi kofani lǝ mɔ, Utidi Eto Ubi, ɔflɔ lǝ lefe nǝ muubǝ ku Onanto eto Batɔnkpe kɛnkɛ ku lǝ Onanto eto diyǝnde ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Nya Yesu disi ɔ́tɛyi mǝ nkǝ, “Nlɛ mi bɔtɛyi sitinti minkǝ mi bǝtsyuǝ ǝmbukpǝ isu ese lefe nǝ biunyǝ Onanto ǝmǝ eto sekakedikɔ luubǝ ku ǝsuǝale.” ");
INSERT INTO lip_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Eyi akua eto kamaa, Yesu ákpa Petro, ku Yakobo ku Yohanes bésu kɔtini kutsyuǝ ǝsuǝ. Mǝ hã dísu bǝsiǝ mfó. Lefe nǝ bakasebi bamfo ńlɛ bobee, bǝnyǝ bǝ Yesu eto ditsyǝbi áfloma. ");
INSERT INTO lip_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Nya wǝ awu nnya onkpe léfloma íflubi futututu enso kase utidi luuflǝ wǝ bikǝ ku ntu biole nya bɛnlɛ buyǝnde. ");
INSERT INTO lip_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Nya bǝnyǝ Onanto eto bǝnyɛlǝkǝtidi ba koko, Mose ku Elia lɛbɔ bánlɛ etiki budi ku Yesu. ");
INSERT INTO lip_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Sikpi ǝmuǝ bakasebi bamǝ kenke itsyise bánte lesa nǝ bánlɛ bɔtɛyi. Nya Petro wǝ dímante lesa nǝ woatɛyi, lɛtɛyi Yesu nkǝ, “Oteasa, bo mfo eto bubǝ alɛkɛ tinti. Tǝ lǝ boto ebu ǝtsyǝ. Lɔni itǝ fǝ, lɔni itǝ Mose, nya lɔni tsya itǝ Elia.” ");
INSERT INTO lip_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Nya lɛsɔmiloku ditsyuǝ díbǝ díti mǝmblɛ kenke, nya bánɔ ɔkɔɛ lɛbɔ utsyi lǝ asɔmiloku nyamǝ ǝsuǝ nlɛ bɔtɛyi nkǝ, “Nwǝ mfo ni mɔ ubi lala wǝ mankeko. Bitsyue wǝ koto.” ");
INSERT INTO lip_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Akpaakpa mfóo, bátsyilamasǝ ǝnǝmi tsya bǝnyǝ kuutsyuǝ saa enso Yesu hã ńyǝ ku mǝ mfó. ");
INSERT INTO lip_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Lefe nǝ bésinkli banlɛ kɔtini komǝ bɔyifǝ kǝbǝ kasɔɔ, Yesu ǝkǝ mǝ ato nkǝ, “Biantɛyi kuutsyuǝ lesa nǝ bínyǝ mfo isu ese bǝ, mɔ, Utidi Eto Ubi, ataka ntsyi ɔkɔmǝ mbǝ.” ");
INSERT INTO lip_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Béti etiki nyamfo bákpe lǝ mǝ nti, fɛ lǝ mǝ mate sii, nya bákatɔ mǝ ǝsuǝ bǝnkǝ, “Be ni bǝ wootaka utsyi ɔkɔmǝ ubǝ eto kasɔ?” ");
INSERT INTO lip_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Nya bátɔ Yesu bǝnkǝ, “Beso afi eto bateasa bamǝ laatɛyi bǝnkǝ ele bǝ ibǝ bǝ Onanto eto Unyɛlǝkǝtidi Elia tɔ Kristo eto bubǝ?” ");
INSERT INTO lip_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesu átɛyi mǝ nkǝ, “Sitinti baatɛyi. Ele bǝ Onanto eto Unyɛlǝkǝtidi Elia tɔ Kristo eto bubǝ lǝ ubǝ ɔlɔ lesa saa utsyǝ. Fɛɛ báwɔni bákpe lǝ Awɔnisa Kɛnkɛ Eto Kukuǝ tsya bǝ Utidi Eto Ubi ebudi ohiã tinti nya bɔɔni wǝ. Be bibu biǝ nyamfo tsya lɛ bote? ");
INSERT INTO lip_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Nlɛ mi bɔtɛyi minkǝ Onanto eto Unyɛlǝkǝtidi Elia búbǝ koko. Fɛɛ betidi mámfo wǝ ku dibu. Bomu béyifo wǝ kase ke bála. Nyamfo ǝbǝ itǝ fe kase Onanto eto bɛnyɛlǝkǝtidi lɛwɔni bǝtsyǝ lǝ Awɔnisa Kɛnkɛ eto Kukue ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Lefe nǝmfóo, se Yesu ku bakasebi itsyǝ bamǝ dísinkli bǝbǝ bakasebi fɛfɛ ɔflɔɔ, bǝnyǝ bǝ betidi kpǝ ńyǝ bátsyilama mǝ, nya afi eto bateasa bǝtsyuǝ nlɛ mǝ etiki bunǝ nko. ");
INSERT INTO lip_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Se betidi bamfó kenke dínyǝ Yesu nlɛ bubǝǝ, íyifo mǝ yanii, nya bétsyetsyi bésu bátsyako wǝ bǝsiǝsǝ wǝ. ");
INSERT INTO lip_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesu ɔ́tɔ wǝ bakasebi bamǝ nkǝ, “Nte kǝnǝ ka mi ku mǝ nlɛ?” ");
INSERT INTO lip_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Nya osani utsyuǝ wǝ ńyǝ lǝ betidi bamǝ nti lɛtɛyi Yesu nkǝ, “Oteasa, nkpa mɔ ubi mboko fǝ ɔflɔ, itsyise lɛwɔnɔ bua si wǝ lǝ ǝsuǝ itǝ waamfo etiki budi. ");
INSERT INTO lip_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Lefenǝ ke lɛwɔnɔ bua nǝmfo nlɛ wǝ bulǝǝ, dietsyi wǝ kasɔ lǝ kasɔ, nya efu laabɔ wǝ lǝ kɛnyɛ nya woayimi anyi, nya wǝ ǝsuǝ kenke laasie kǝklǝkǝ. Nya mínkpa wǝ mimboko fǝ bakasebi minkǝ lǝ batsya wǝ, fɛ bamfo.” ");
INSERT INTO lip_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Nya Yesu lɛtɛyi mǝ nkǝ, “Ei! Mii, mmi eto betidi, mi bofo kanɔ ǝmbǝ ale! Nte lefe nǝ eto okle ele bǝ bonko mi yɛ fɛ lǝ befo bɛnɔ? Nye nte lefe kɛntsyɛ nǝ ele bǝ nyɛnko mi fɛ lǝ bɛnɔ asa kasɔ? Bekpa ubi ǝmǝ beboko mɛ!” ");
INSERT INTO lip_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Nya bákpa wǝ búsuko Yesu. Nya kase lɛwɔnɔ bua nǝmfo dínyǝ Yesu ko, dítinkǝsǝ ubi ǝmǝ nya dínǝ wǝ lɛɛsɔ lǝ kasɔ lɛnlɛ bowaninsǝ, akaminansǝ lǝ kasɔ, nya efu nlɛ bɔbɔ lǝ wǝ kɛnyɛ. ");
INSERT INTO lip_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Nya Yesu lɛtɔ wǝ anto nkǝ, “Se ítsyiko wǝ buyifo mǝǝ, yɔ́ɔ klɛ?” Osani ǝmǝ átɛyi wǝ nkǝ, “Ítsyǝ wǝ kasɔ lǝ wǝ sikpefi lefe ke. ");
INSERT INTO lip_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Lɛwɔnɔ nǝmǝ aakplatsya sesiasesia nkǝ lǝ lelo wǝ, lǝ ibǝ nkoo, dietǝ nkǝ lǝ udu ɔnɔ udufǝ lǝ utǝ nye ntu ǝsuǝ. Nlɛ fǝǝ lekpakpa, nyǝ bo kaminsǝ, lǝ ebofo lǝ awunsǝ ko bo!” ");
INSERT INTO lip_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu átɛyi wǝ nkǝ, “Beso faatɛyi mɛ fǝnkǝ lǝ moofo? Lesasa ebofo bubǝ kǝtǝ lǝ afo mɛ ɔnɔ.” ");
INSERT INTO lip_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Lamfolamfo, ubi ǝmǝ eto anto átɛyi bembembe nkǝ, “Mfo nnɔ, tsyaa bumbǝ ale kpǝ. Wunsǝko mɛ lǝ mɔ bofo kanɔ lǝ bumuǝ ale.” ");
INSERT INTO lip_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Nya lefe nǝ Yesu dínyǝ nkǝ betidi kpǝ lǝ bɔkpɔ lǝ banyi bafi mǝǝ, údi lɛwɔnɔ nǝmfo etiki nkǝ, “Lɛwɔnɔ bua nǝ lǝǝtǝ betidi lannɔ ku leendi etiki, nlɛ fǝ bɔtɛyi minkǝ bɔ lǝ ubi ǝmfo ǝsuǝ, nya mensi sinkli edufǝ lǝ wǝ kulefe kulefe bio!” ");
INSERT INTO lip_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Lɛwɔnɔ nǝmfo áfa bembembe, nya dítinkǝsǝ wǝ kekleke nya lɛbɔ wǝ lǝ ǝsuǝ. Ubi ǝmfo álabe mfó fe bukpǝ ukpǝ. Nya utsyuǝ saa wǝ ńyǝ mfó nlɛ bɔtɛyi nkǝ, “Ukpǝ!” ");
INSERT INTO lip_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Nya Yesu lɛkɔbe ubi ǝmǝ lǝ kɔni nya ótaka úńyǝ. ");
INSERT INTO lip_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Lǝ nyamfo eto kama se Yesu dídufǝ diyo ditsyuǝǝ, wǝ bakasebi átɔ wǝ buɛ bǝnkǝ, “Beso bo dímamfo lɛwɔnɔ nǝmfo bola kǝlǝkǝ lǝ ubi ǝmǝ ǝsuǝ?” ");
INSERT INTO lip_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Nya Yesu lɛtɛyi mǝ nkǝ, “Siankpa utidi ǝmǝ éboto ola sesia sesia sesia nya ókle kɛnyɛɛ, nya fɛ woofo lɛwɔnɔ nǝmfo eto okle bola kǝlǝkǝ lǝ utidi ǝsuǝ nɛ.” ");
INSERT INTO lip_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yesu ku wǝ bakasebi édu mfó báyɛ lǝ Galilea eto kasɔ. Yesu mánla nkǝ kuutsyuǝ saa te kaka onkpe, ");
INSERT INTO lip_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","itsyise úkate wǝ bakasebi asa. Ɔ́tɛyi mǝ nkǝ, “Osani utsyuǝ ebufi Betidi kenke eto Ubi utǝ, nya wuufi wǝ utǝ betidi nkǝ balo. Nya lǝ diyi tsyǝfǝ ǝsuǝǝ, wuusinkli otaka ubǝ nkpǝ.” ");
INSERT INTO lip_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Tsya bánnɔ lesa nǝ ɔ́tɛyi mǝ mfo eto kasɔ, nya báte sikpi ku kase bɔɔtɔ wǝ ditiki nǝ ɔ́tɛyi mfo eto kasɔ. ");
INSERT INTO lip_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Se bésu bédufǝ Kapernaum eto umǝǝ, bésu bédufǝ diyo lɔni. Mfóo, Yesu átɔ wǝ bakasebi nkǝ, “Nte ditiki nǝ bɛnlɛ bunǝ lǝ mi nti se bɔ́nlɛ bubǝ?” ");
INSERT INTO lip_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Tsya bǝntǝ wǝ mbuayɛ saa. Itsyise se bánlɛ bubǝǝ, bǝkǝnǝ etiki bǝ bala bǝ baate utsyǝ wǝ ni ɔkplɛ kenke lǝ mǝ nti. ");
INSERT INTO lip_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Nya Yesu dísiǝ lǝ kasɔ nya ókpadi wǝ bakasebi lefosi inuǝ bamǝ, nya ɔ́tɛyi mǝ nkǝ, “Mi futsyǝ lela nkǝ weedi ɔkplɛnyǝ kenke lǝ mi ntii, ele bǝ uyifo wǝ ǝsuǝ fenkǝ nwǝ lǝmbǝ kulesa nti, nya wuusumu wǝ bǝtsyuǝ.” ");
INSERT INTO lip_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Nya útǝ dikpefi díbǝ únyǝ lǝ mǝ sɛtɔ. Nya útsyi dikpefi nǝmfo útǝkǝ lǝ wǝ akpa nya ɔ́tɛyi mǝ nkǝ, ");
INSERT INTO lip_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Utsyuǝ saa léfo dikpefi lǝ mɔ disii, mɔ ni ófo. Nya utsyuǝ saa loofo mɛɛ, inni mɔ mate ete ofo. Bomu ófo mɔ Anto wǝ létsyese mɛ tsya.” ");
INSERT INTO lip_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Nya, okasebi wǝ baakpo Yohanes lɛtɛyi Yesu nkǝ, “Oteasa, búnyǝ osani utsyuǝ wǝ nlɛ awɔnɔ bua bóla lǝ fǝ diye ǝsuǝ. Nya búti wǝ kusu buǝ usinkli ɔyɛ, itsyise umbǝ lǝ bo nti.” ");
INSERT INTO lip_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yesu átɛyi mǝ nkǝ, “Bienti wǝ kusu, itsyise utsyuǝ saa wǝ leeyifo ayanisa lǝ mɔ diye ǝsuǝǝ, ǝmbudi mɔ etiki bua. ");
INSERT INTO lip_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Nya utsyuǝ saa wǝ lǝǝnnyǝ lǝ bo ǝsuǝǝ, bonko wǝ eyifo bani. ");
INSERT INTO lip_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","“Nya mǝtǝ lǝ bete biǝ utsyuǝ saa wǝ luutǝ mi ntu nkǝ binǝ itsyise biyifo mɔ balee, Onanto ebofo wǝ nnya kayo. ");
INSERT INTO lip_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Lǝ ibǝ bǝ utidi utsyuǝ ǝtǝ bǝ dikpefi nǝ díkǝnyǝ bofokanɔ lǝ mɛ ésinkli kama lǝ nnya ǝsuǝǝ, wuunyǝ kotonǝnǝ tinti. Lǝ befi ukuǝ bátsyasǝ lǝ lebambi kplɛ ǝsuǝ befi bakpe wǝ lǝ simuǝ befi wǝ bato bakpe lǝ ditumbukplɛ, yɔɔlɛkɛ itǝ wǝ eso. ");
INSERT INTO lip_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","“Nyaso lǝ fǝ kɔni kɔni abiasǝ fǝ bofokanɔɔ, tɔnɔ lǝ ala ko ǝlǝkǝ! Ɛlɛkɛ bǝ yɛ kɔni kɔwɛ esu nkpǝ manlo kǝmiǝ enso bǝ kɛ ani ǝnuǝ lǝ Onanto lǝ oto fǝ okpe lǝ ditǝfɛnku ǝsuǝ kaka baatonsǝ asa bua. ");
INSERT INTO lip_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Nyaso lǝ fǝ kokpa kɔni laabiasǝ fǝ bofokanɔɔ, la ko ǝlǝkǝ. Ɛlɛkɛ eso bǝ kɛ kokpa kɔwɛ lǝ ǝnyǝ nkpǝ manlo, enso bǝ akpa ǝnuǝ kɛ fǝ lǝ bato fǝ bakpe lǝ utǝ ǝmǝ kǝmiǝ. ");
INSERT INTO lip_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Nya lǝ fǝ dinǝmi aakpa fǝ kesuko asa bua kǝmiǝǝ, nǝ ni ǝlǝkǝ. Ɛlɛkɛ eso lǝ akpe dinǝmi lɛwɛ nya fedufǝ lǝ Onanto eto sekakedikɔ enso bǝ kɛ ǝnǝmi ǝnuǝ lǝ befi fǝ bato bakpe lǝ utǝ manlo kǝmiǝ, ");
INSERT INTO lip_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","wǝ eto asa bátɛyi bǝnkǝ, ‘Ekuklubi nnya laabiasǝ asa mfóo, ǝǝnkpǝ kulefe. Nya ute wǝ laatonsǝ asa mfóo, aanni kulefe.’ ");
INSERT INTO lip_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Itsyise fe kase beefi mba kakpe lǝ didisa dialɛkɛɛ, nko kǝ Onanto leefi kanyinyǝnyǝ eto utǝ kakpasǝ wǝ betidi ǝsuǝ nɛ. ");
INSERT INTO lip_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Mba alɛkɛ. Fɛ lǝ bóyansǝ mu kamini, ǝnsiǝmbofo kamini bokpe lǝ mu bio. Nyaso, tǝ mba eto lɛlɛkǝsǝ lǝ bɔkɛ mi lǝ ǝsuǝ. Lǝ bisiǝ lǝ diyuǝ ǝsuǝ ku mi bǝtsyuǝ.” ");
INSERT INTO lip_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Nya se Yesu dídu mfó, ɔ́yila Yordan eto ketu úsu Yudea eto kasɔ. Betidi kpǝ esi bǝbǝ bátsyilama wǝ mfó tsya, nya úkate mǝ asa mfó itsyi lǝ Onanto ǝsuǝ fe kase úkala buyifo. ");
INSERT INTO lip_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Farisifɔ bǝtsyuǝ ǝbǝ wǝ ɔflɔ bǝ lǝ itǝ kusuu, lǝ bǝnyǝ kusu lǝ wǝ ǝsuǝ. Bátɔ Yesu bǝnkǝ, “Nyalɛ Onanto eto kɔfi ǝtǝ kusu bǝnkǝ osani ɔni wǝ usiǝ?” ");
INSERT INTO lip_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Nya Yesu tsya lítǝ mbuayɛ ɔ́tɔ mǝ nkǝ, “Nte kɔfi ko Mose lékpe mi?” ");
INSERT INTO lip_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Bǝtǝ mbuayɛ bǝnkǝ, “Mose ǝtǝ kusu nkǝ osani wǝ ke lensianla wǝ usiǝǝ, ɔwɔni kukuǝ lǝ utǝ wǝ bote fɛ lǝ oyani wǝ.” ");
INSERT INTO lip_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesu átɛyi mǝ nkǝ, “Moses wǝǝ ni Onanto eto Unyɛlǝkǝtidi áwɔni nyamfo nko útǝ mi itsyi lǝ mi letotidi eso. ");
INSERT INTO lip_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Taa kawunsiǝ eto diyifofee, Onanto éyifo osani ku usio, fe kase báwɔni bákpe lǝ Kukue Kɛnkɛ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Awɔnisa Eto Kukuǝ Kɛnkɛ átɛyi nkǝ, ‘Lǝ nyamfo eso osani du lǝ wǝ anto ku ambe ɔflɔ usu ɔkɔ ku wǝ usiǝ, ");
INSERT INTO lip_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","nya mǝ inuǝ bamǝ loofiani ǝsuǝ eto sinǝ sɔni.’ Nyaso lǝ Onanto eto ǝnǝmii, bafiani utidi ɔni. Inni inuǝ! ");
INSERT INTO lip_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Nyaso betidi ba Onanto lɛkɔ banii, kawunsiǝ kamfo eto utidi saa ǝmbǝ kusu wǝǝsǝnsǝ mǝ nti.” ");
INSERT INTO lip_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Kama se bésu bédufǝ lǝ diyo kǝmiǝǝ, wǝ bakasebi átɔ wǝ asa itsyi lǝ lǝsanǝ ɔ́tɛyi lǝ kɔfi komfó ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yesu ǝlǝkǝ kasɔ óte mǝ nkǝ, “Osani wǝ looyani wǝ usiǝ usu nya úfi obambaa, udi kɔsɔnɔ, ota wǝ usiǝ koko ǝmǝ ubu. ");
INSERT INTO lip_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Nko ke lǝ usio ani wǝ usiǝ nya usu usiǝko úsiǝ kusǝ bamba tsyaa, wuntsya akpo kusǝ óta wǝ usiǝ koko ǝmǝ úbu.” ");
INSERT INTO lip_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Lǝ lefe nǝmǝ tutuutuu, betidi bǝtsyuǝ ákpa mǝ bebi báboko Yesu ɔflɔ bǝ lǝ ufi wǝ ani utǝkǝ mǝ lǝ ǝsuǝ okpo mǝ atsyɔ. Fɛɛ wǝ bakasebi ǝnyǝnki bákpe mǝ. ");
INSERT INTO lip_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Se Yesu dínyǝ nyamfoo, kafo ányi wǝ nya ɔ́tɛyi wǝ bakasebi nkǝ, “Bitǝ lǝ ekpefi lǝ bǝbǝ mɔ ɔflɔ, bienti mǝ kusu. Itsyise Onanto eto sekakedikɔ tǝ itǝ mba laabokosǝ mǝ ǝsuǝ kasɔ fe kase ekpefi kɛkɛ bamfo leeyifo. ");
INSERT INTO lip_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nlɛ mi bɔtɛyi sitinti minkǝ utidi wǝ ke lǝmbofo Onanto eto Sekadidi fe kase dikpefi kɛkɛ laabokosǝ wǝ ǝsuǝ kasɔɔ, wǝmbudufǝ Onanto eto sekakedikɔ kulefe.” ");
INSERT INTO lip_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Nya ɔ́buta dikpefi saa, útǝkǝ wǝ kɔni nya ókpo mǝ atsyɔ. ");
INSERT INTO lip_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Lefe nǝ Yesu létaka úńyǝ lǝ uluu, osani utsyuǝ étsyetsyi úbǝ óse akonki lǝ wǝ ǝnǝmi, nya ɔ́tɔ wǝ nkǝ, “Oteasa Sɛɛ, be ele bǝ nyifo fɛ lǝ nyǝ nkpǝ manlo?” ");
INSERT INTO lip_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu átɔ wǝ nkǝ, “Eyi lesa nǝ eso fakpadi mɛ fǝ, ɔsɛɛ? Utidi saa meenyifo ɔsɛɛ, enso Onanto. ");
INSERT INTO lip_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Eyi Onanto eto afi nnya kenke. Manlo utidi, mankpo kusǝ nye mamfe fǝ usiǝ kama, menyu, mantɛyi sidia lǝ fuutsyuǝ ǝsuǝ nye ala wǝ kɛnyɛ, manwɛ utidi lǝ afo wǝ bikǝ, bu fǝ anto ku fǝ ambe.” ");
INSERT INTO lip_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Osani ǝmfo esi ɔ́tɛyi wǝ nkǝ, “Oteasa, idu lǝ mɔ sikpefi ibǝ ese lǝ mii, nlɛ afi nyamfo kenke budi.” ");
INSERT INTO lip_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu ábe wǝ ku lelabi nya ɔ́tɛyi wǝ nkǝ, “Lesakpa lɔni hã dibu ele bǝ yifo. Su lǝ esu efi fǝ bikǝ bia kenke nte fǝ ate, lǝ efi atabi nyamfó efi ǝtǝ bakombo. Lǝ nnya ǝsuǝǝ, ebofiani otabinyǝ lǝ Onanto eto. Nyamfo eto kamaa, du lǝ ǝbǝ ǝtǝkǝko mɛ lefe saa!” ");
INSERT INTO lip_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Se osani ǝmfo lɛnɔ ditiki nǝmfoo, élo wǝ ani nnya údu ku nkuɛnlo, itsyise bikǝ kpǝ kpe wǝ. ");
INSERT INTO lip_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesu átsyi ɔwininsǝ nya ótsyilamasǝ ǝnǝmi óbe wǝ bakasebi nya ɔ́tɛyi mǝ nkǝ, “Ekpe ale tinti fɛ batabinyǝ loofo Onanto eto sekakedikɔ budufǝ.” ");
INSERT INTO lip_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ditiki nǝmfo ábiasǝ wǝ bakasebi bamfo eto nsusu. Fɛɛ Yesu esi átɛyi mǝ nkǝ, “Mɔ bebi, bɛnɔ kase enkpe ale itǝ batabinyǝ bǝ bǝnyǝ kusu bedufǝ Onanto eto sekakedikɔ! ");
INSERT INTO lip_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Mǝ mfó budufǝ kpe ale eso kase ɔdɔmini ku lekoko lɔɔyɛ lǝ okaasa eto ofo ofe!” ");
INSERT INTO lip_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Se ɔ́tɛyi mǝ ditiki nǝmfoo, isi ébiasǝ mǝ nsusu ekpe blɛmblɛ! Nya banlɛ mǝ ǝsuǝ bɔtɔ bǝnkǝ, “Nyalɛ owoe ko luunyǝ nkpǝ manlo?” ");
INSERT INTO lip_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Nyaso Yesu ábe mǝ tũũ, nya ɔ́tɛyi nkǝ, “Utidi saa ǝmbǝ loofo nyamfo buyifo. Fɛɛ wǝ Onantoo, wǝ ebofo lesa saa buyifo.” ");
INSERT INTO lip_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Nya Petro dídi etiki ɔ́tɛyi nkǝ, “Bóyani bo lesa saa butsyǝ bubǝ butǝkǝko fǝ!” ");
INSERT INTO lip_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Nya Yesu lɛtɛyi nkǝ, “Nlɛ mi bɔtɛyi minkɛ mimi ebunyǝ bikǝ kpǝ enso mbia béyani bitsyǝ. Itsyise utidi saa wǝ léyani wǝ oto nye bayimisani nye bayimisio, nye ambe, nye anto, nye wǝ bebi, nye wǝ ɔkuɛ útsyǝ lǝ mɔ butǝkǝko esoo, nya lǝ usǝnsǝ Ditiki Sɛɛ nǝmfoo, ");
INSERT INTO lip_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","wuunyǝ asa nyamfó eto nnya kolofa ku kama lǝ kasɔ kamfo. Wuunyǝ kato ku bayimisani ku bayimisio, ku ambemǝ ku bebi ku kakuɛ kpǝ. Fɛɛ betidi ebokpe wǝ bulǝ tsya. Nya nyamfo eto kamaa, wuunyǝ nkpǝ manlo lǝ kawunsiǝ fɔfɔ ka luubǝ. ");
INSERT INTO lip_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Fɛ betidi kpǝ ba ntɔ sɛtɔ mɔmɔɔ, ebubǝ bafe kama. Nya mba nkpe kama mɔmɔɔ, mǝ loofe batɔ sɛtɔ nɛ.” ");
INSERT INTO lip_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Lǝ lefe nǝ bányɛ lǝ kusu baatɔ lǝ Yerusalem eeto umǝǝ, Yesu átɔ sɛtɔ fɛ wǝ bakasebi dítǝkǝ. Nya bulǝ butsyuǝ eto okle dídufǝ lǝ bakasabi bamfó ǝsuǝ nya sikpi dímuǝ betidi ba ntǝkǝko mǝ tsya. Yesu esi ókpadi wǝ bakasebi nya ókpa mǝ úsuko kaka kudu lǝmbǝ nya ɔ́tɛyi mǝ asa nnya lǝǝbǝ wǝ butu. ");
INSERT INTO lip_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ɔ́tɛyi mǝ nkǝ, “Bɛnɔ! Bɔtɔ lǝ Yerusalem eto umǝ kaka boomuǝ mɛ, mɔɔ ni Utidi Eto Ubi, nya boofi mɛ bakpe lǝ besumunyǝ ninǝ ku afi eto bateasa eto ani. Boolo mɛ dikpǝkpi nya buufi mɛ bakpe lǝ mba lenni Yudafɔ eto ani. ");
INSERT INTO lip_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Nya bookpe mɛ kɔfiɔ, nya bootufǝ ntufǝ bakpo mɛ lǝ ǝsuǝ, bablɛ mɛ, balo mɛ. Fɛɛ lǝ diyi tsyǝfǝ ǝsuǝǝ, muusinkli ntaka mbǝ nkpǝ bio.” ");
INSERT INTO lip_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Nya Sebedeo eto bebi ba ni Yakobo ku Yohanes díbǝ Yesu ɔflɔ nya bátɛyi wǝ bankǝ, “Oteasa, bokpe kǝtsyuǝ boǝ boatɛyi lǝ eyifo ǝtǝ bo.” ");
INSERT INTO lip_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesu átɔ mǝ nkǝ, “Be ini?” ");
INSERT INTO lip_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Bátɛyi wǝ bǝnkǝ, “Lǝ ǝsiǝ lǝ fǝ lekankpomɛ lǝ fǝ sekakedikɔ eto diyǝnde ǝsuǝǝ, bo tsya aala boǝ lǝ bubǝ busiǝ lǝ fǝ akɔ mfó. Bo ɔni lǝ usiǝ lǝ fǝ kodiani nya unuǝfǝ tsya lǝ usiǝ lǝ fǝ kǝmǝni.” ");
INSERT INTO lip_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesu átɛyi mǝ nkǝ, “Biante lesa nǝ bɛnlɛ bɔtɔ! Befo bɛnɔ biǝ biofo ntu bunǝ lǝ kanyi eto lɛkɔbe nǝ mǝǝnǝ ǝsuǝ? Nya biofo ntuflǝsǝflǝsǝ eto lekpa nǝ moofo lǝ kawunsiǝ mfo bofoo?” ");
INSERT INTO lip_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Nya bǝtǝ mbuayɛ bǝnkǝ, “Boofo.” Yesu átɛyi mǝ nkǝ, “Ee, biofo bunǝ lǝ lɛkɔbe bua nǝ eto okle mǝǝnǝ, nnya biofo ntu flǝsǝflǝsǝ eto lekpa nǝ eto okle maafo mfo. ");
INSERT INTO lip_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Fɛɛ mimbǝ kusu bǝ nlǝkǝ utidi wǝ luusiǝ lǝ mɔ kodiani nye kǝmǝni. Mɔ Anto wǝ ni futsyǝ luutǝ betidi ba úkalɔ mfó utsyǝ útǝ.” ");
INSERT INTO lip_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Lefe nǝ bakasebi lefosi fɛfɛ lɛnɔ etiki nyamfoo, bǝnyǝ ɔblɔ bákpe Yakobo ku Yohanes. ");
INSERT INTO lip_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Nyaso Yesu ákpadi mǝmblɛ kenke utsyǝ nya ɔ́tɛyi mǝ nkǝ, “Biyi biǝnkǝ Aba eto beninǝ kpe ǝsuǝale lǝ mǝ betidi ba nkpe lǝ mǝ kalɔ ǝsuǝ. Nya nkomǝ eto beninǝ tidi bamfó akɛ ale ǝkǝlǝkǝ kayinkǝ mba nkpe mǝ kalɔ. ");
INSERT INTO lip_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Fɛɛ yanle bǝ itsyǝ nko lǝ mi nti. Lǝ mi nti eto utsyuǝ aala nkǝ weedi ɔtɔnkotɔnkoo, ele bǝ obokosǝ ǝsuǝ kasɔ usumu bafɛfɛ. ");
INSERT INTO lip_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Nya lǝ mi nti eto utsyuǝ aala nkǝ woafo diye kplɛɛ, ele bǝ uyifo nwǝ lǝǝnnǝ ǝsuǝ, laabokosǝ ǝsuǝ kasɔ kabɛbɛ bafɛfɛ eto lɛlɛkǝsǝ. ");
INSERT INTO lip_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Itsyise Utidi Eto Ubi kulaa tsya mǝmbǝ nkǝ besumu mɛ. Bomu bǝ lǝ usumu betidi lǝ ufi wǝ nkpǝ utǝ lǝ betidi kpǝ eto dilǝkǝ.” ");
INSERT INTO lip_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Nnya kamaa, Yesu ku wǝ bakasebi ésu Yeriko. Nya se banlɛ budu lǝ umǝ ǝmǝǝ, betidi kpǝ ǝtǝkǝko mǝ. Nya lefe nǝ bányɛ kusuu, báfe unǝmba utsyuǝ wǝ baakpo Bartimeo eto kasɔ ni Timeo eto ubi. Nya unsi mfó ɔnlɛ asa bɔtɔ. ");
INSERT INTO lip_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Se ɔ́nɔ nkǝ Yesu Nasaretnyǝ uni nlɛ bofee, ófa bembembe ɔ́tɛyi nkǝ, “Yesu! David eto ubi! Be mɛ lǝ ǝnyǝ mɛ kaminsǝ!” ");
INSERT INTO lip_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Betidi kpǝ ba nlɛ bofe mfó ǝnyǝnki bákpe wǝ bǝnkǝ usinkli ɔyɛ kudu komǝ. Tsya mfe fɛ usi ófa bembembe nkǝ, “David eto ubi! Be mɛ lǝ ǝnyǝ mɛ kaminsǝ!” ");
INSERT INTO lip_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Nya se Yesu lɛnɔ nkoo, úkǝnǝ úńyǝ nya ɔ́tɛyi nkǝ, “Bekpadi wǝ bitǝ mɛ.” Nyaso bákpadi unǝmba ǝmfo bátɛyi bǝ, “Nyǝ disuǝyuǝ! Taka mlǝ, itsyise ɔlɛ fǝ bokpadi.” ");
INSERT INTO lip_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Lamfolamfo, úlǝkǝ wǝ awu kato óto ókpe, nya ótaka úńyǝ, nya úsu Yesu flɔ. ");
INSERT INTO lip_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu átɔ wǝ nkǝ, “Be faala fǝ nyifo ntǝ fǝ?” Unǝmba ǝmǝ átɛyi wǝ nkǝ, “Oteasa, tǝ lǝ mɔ ǝnǝmi lǝ ɛsini lǝ nkǝnyǝ!” ");
INSERT INTO lip_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Nya Yesu lɛtɛyi wǝ nkǝ, “Su. Fǝ bofokanɔ átsya fǝ.” Nya lamfolamfo, wǝ ǝnǝmi lɛsini nya útsyiko asa bunyǝ. Nya útǝkǝko Yesu, nya mǝmblɛ lídu. ");
INSERT INTO lip_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Lefe nǝ bányi bafi Yerusalem nya bédufǝ Betfage ku kaka letsyilama Betania mfóo, báyo Nnuǝbi eto Eyi eto Kɔtini. Nya mfó Yesu lékpe wǝ bakasebi inuǝ nkǝ beákatɔ. ");
INSERT INTO lip_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Nya ɔ́tɛyi mǝ nkǝ, “Lǝ bidufǝ umǝ tutɛɛ, biunyǝ biǝnkǝ bátsyasǝ ɔflimubi wǝ ku ukuǝ, wǝ ku utsyuǝ saa dímǝsiǝ tɔ unyǝ. Benyankli wǝ lǝ ukuǝ lǝ bifi wǝ beboko mɛ. ");
INSERT INTO lip_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Nya lǝ utsyuǝ átɔ mi nkǝ, ‘Beso bɛnlɛ wǝ bulǝkǝ?’ bɛtɛyi wǝ biǝ mi Onamute ahiã wǝ, nya businkli bufi wǝ boboko mlɛ.” ");
INSERT INTO lip_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Nyaso betidi inuǝ bamfo ésu nya bǝnyǝ bǝ ɔflimubi ńyǝ lǝ ukuǝ, úńyǝ lǝ futsyǝ eto kǝsiǝ. Nya bǝlǝkǝ wǝ ku ukuǝ ǝmǝ. ");
INSERT INTO lip_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Betidi bǝtsyuǝ ba ńyǝ mfó átɔ mǝ bǝnkǝ, “Be bɛnlɛ wǝ bonyankli keyifo ko?” ");
INSERT INTO lip_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Bátɛyi mǝ fe kase Yesu lɛtɛyi mǝ. Nya mǝ tsya dítǝ mǝ kusu bǝ banyankli wǝ. ");
INSERT INTO lip_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Se báboko Yesu ubuki ǝmfoo, béfi mǝ mfia bǝtǝkǝ lǝ ubuki ǝmǝ ǝsuǝ nya Yesu lébe úsiǝ lǝ wǝ. ");
INSERT INTO lip_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Betidi kpǝ éfi mǝ mfia bǝtsyǝ lǝ kasɔ, bǝtsyuǝ tsya ǝfǝsǝ kalɛ ku afanto lǝ kaflɔ bésense bákpo lǝ kusu bǝ lǝ ɔyɛ ofe. ");
INSERT INTO lip_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Betidi ba kenke ntɔ sɛtɔ ku mba ntǝkǝ kamaa káfa bembembe kákatɛyi bǝ, “Hosiana! Bɔlɛ atɛsǝ butǝ nwǝ nlɛ bubǝ lǝ Onanto eto diye ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Bifi atɛsǝ bitǝ bo ona Oka David eto sekakedikɔ sia nlɛ bubǝ. Hosiana itǝ Onanto wǝ nkpe kato fanlofanlo.” ");
INSERT INTO lip_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Se údufǝ Yerusalem, Yesu ésu Yudafɔ eto Disumuyo. Nya ótsyilamasǝ ǝnǝmi ɔ́lɛ ola óbe lesa saa nǝ nkpe mfó. Fɛɛ se kale mfe nlɛ bolo esoo, údu úsu Betania ku wǝ bakasebi. ");
INSERT INTO lip_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Se kale dísiǝ, bédu lǝ Umǝ Betania bánlɛ bubǝǝ nya kukpɛnsɛ étsyiko Yesu bɔlɛ. ");
INSERT INTO lip_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Únyǝ kɔsɛsɛ nkǝ kuyi kutsyuǝ ko laawɔ eyibibi baakpo fiki ko léta afanto kpǝ nyǝ mfó. Nyaso úsu nkǝ weesu obe lǝ kɔ́nwɔ ebibi. Fɛɛ se úsu údufǝ kuyi komǝ kalɔɔ, únyǝ nkǝ kóanwɔ ebibi saa. Afanto hã kóto. Lefe nǝ ele bǝ kusi kɔnwɔ tsya mányo tɔ. ");
INSERT INTO lip_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Nyaso Yesu édi kuyi komǝ etiki ɔ́tɛyi nkǝ, “Ensiembɔnwɔ ebibi bio.” Wǝ bakasebi ánɔ se ɔ́tɛyi nko. ");
INSERT INTO lip_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Se bésu bédufǝ Yerusalem, Yesu ésu Yudafɔ eto Disumuyo, nya útsyiko betidi ba nlɛ asa bote ku mba nlɛ bikǝ bote lǝ diyo nǝmǝ bola, úkǝ mba nlɛ atabi bofloma eto kapunu úwi. Nya úkǝ mba nsi banlɛ ablonima tsya bote eto akpomɛ úwi itsyise wóanla nkǝ kuutsyuǝ saa ubǝ ukayɛ lǝ Disumuyo ɔflɔ mfó kafe ku mǝ bikǝ. ");
INSERT INTO lip_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Nya wóantɔnɔ nkǝ kuutsyuǝ saa fi kulesa úbǝ katekɔ lǝ kesumukɔ eto diyo nǝmǝ mfó. ");
INSERT INTO lip_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Nya óte betidi bamfó asa ɔ́tɛyi mǝ nkǝ, “Bawɔni lǝ Awɔnisa Kɛnkɛ Eto Kukuǝ ǝsuǝ bǝ, Onanto átɛyi nkǝ, ‘Bookpo mɔ diyo, diyo nǝ kawunsiǝ kenke eto betidi luubǝ bato ola bǝtǝ Onanto.’ Fɛɛ mimi éfi ni bíyifo beyu eto kabiɔkɔ katafa betidi.” ");
INSERT INTO lip_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Besumunyǝ ninǝ ku afi eto bateasa ba lɛkɛ mfó ánɔ etiki nnya Yesu lɛtɛyi. Nyaso bábɛbɛ kusu ko bɔɔyɛ balo wǝ. Tsyaa balɛ sikpi bote ɛyɛ lǝ kase betidi ba tã laala wǝ asatete eso. ");
INSERT INTO lip_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Se éyo ditsyitsyo lefee, Yesu ku wǝ bakasebi édu lǝ Yerusalem eto umǝ ǝmǝ. ");
INSERT INTO lip_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Se kale dísiǝ eto olesiǝǝ, nya se bányɛ lǝ kusu bánlɛ bubǝǝ, bǝnyǝ bǝ kudiyi komǝ ébukpǝ koko kenke taa ko keyudu ke. ");
INSERT INTO lip_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petro ákloma lesa nǝ díbǝ, nya ɔ́tɛyi Yesu nkǝ, “Oteasa, be kuyi komǝ fékudii, kúkpǝ!” ");
INSERT INTO lip_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu átɛyi mǝ nkǝ, “Befo Onanto bɛnɔ. ");
INSERT INTO lip_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nlɛ mi bɔtɛyi sitinti minkǝ, utsyuǝ saa wǝ lɔɔtɛyi kɔtini komfo nkǝ kɔnyi kusu kudufǝ lǝ lekpoo, nya wanyaki lǝ wǝ lɛkɔɛsi, nya ófo ɔ́nɔ nkǝ lesa nǝ ɔ́tɛyi ebubǝ itǝǝ, Onanto ebuyifo nnya utǝ wǝ. ");
INSERT INTO lip_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Nyaso nlɛ mi bɔtɛyi minkǝ, lesa nǝ ke biɔtɔ Onanto ɛyɛ lǝ olatoto ǝsuǝǝ, befo bɛnɔ biǝ dioka mi kɔni. Onanto ebuyifo lesa nǝ mǝ utǝ mi. ");
INSERT INTO lip_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Nya lǝ bibǝ ola katokɔ kǝtǝ Onanto nya bekloma biǝ utidi utsyuǝ áta mi úbuu, bifi bɛtsyɛ wǝ itǝ bǝ mi Anto wǝ nkpe kato tsyaa, lǝ ufi mi asa bua ɔtsyɛ mi. ");
INSERT INTO lip_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Fɛɛ lǝ biemfi bɛtsyɛ wǝǝ, mi Anto wǝ nkpe kato tsya ǝmbufi ɔtsyɛ mi.” ");
INSERT INTO lip_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yesu ku wǝ bakasebi édufǝ Yerusalem. Nya Yesu nyɛ lǝ kesumukɔ mfó botsyilamaa, nya besumunyǝ ninǝ ku afi eto bateasa ku umǝ eto beninǝ bǝtsyuǝ díbǝ wǝ ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Nya bátɔ wǝ bǝnkǝ, “Owoe dítǝ fǝ ǝsuǝale fɛ feeyifo asa nyamfo? Nya owoe tsya dítǝ fǝ kusu nko?” ");
INSERT INTO lip_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesu ǝtǝ mbuayɛ nkǝ, “Tutɛɛ, mɔɔtɔ mi ditiki lɔni hã. Nya lǝ bitǝ ni mbuayɛɛ, mɔɔtɛyi mi nwǝ eto ǝsuǝale ǝsuǝ minlɛ asa nyamfo buyifo. ");
INSERT INTO lip_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Bɛtɛyi mɛ kaka Yohanes léfo ǝsuǝale utsyiko fɛ úflǝsǝ betidi ntu? Ǝsuǝale nyamǝǝ, Onanto ɔflɔ itsyi lee utidi ete dítǝ wǝ kusu?” ");
INSERT INTO lip_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Bétsyiko etiki nyamfo bunǝ lǝ mǝ nti, nya bátɔ mǝ ǝsuǝ bǝnkǝ, “Ntsyǝ ele bǝ bɔtɛyi kɛɛ? Lǝ bɔtɛyi boǝ nkomǝ eto ǝsuǝale nyamǝ etsyi Onanto ɔflɔɔ, wɔɔtɔ bo nkǝ, ‘Lǝ nko inii, beso bíamfo Yohanes bɛnɔ?’ ");
INSERT INTO lip_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Fɛɛ lǝ bɔtɛyi wǝ boǝ, utidi ete letsyese wǝ tsyaa!” Balɛ sikpi bote kase bɔtɛyi nko tsya itsyise utsyuǝ saa áfo ɔ́nɔ nkǝ Yohanes eyifo Onanto eto unyɛlǝkǝtidi. ");
INSERT INTO lip_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Nyaso bátɛyi Yesu bǝnkǝ, “Bunyi.” Nya Yesu lɛtɛyi mǝ nkǝ, “Mintsya ǝmbɔtɛyi mi itsyi lǝ ǝsuǝale nnya minkpe eso fɛ maafo nyamfo buyifo!” ");
INSERT INTO lip_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Nya Yesu lɛtɛyi mǝ lekpa nkǝ, “Lefe lɔnii, osani utsyuǝ áfo nte eto eyi eto ɔkuɛ. Nya ókpe ɔkpɔ ótsyilama wǝ. Nya úlǝkǝ dibiǝ lǝ koba ǝsuǝ kaka wuukǝkǝ eyibibi nyamǝ eto ntu ukakpo. Nya óto kalebe kani letaka kaka bookǝnyǝ bakase ɔkuɛ ǝmǝ. Nya úfi ɔkuɛ ǝmǝ ókpe lǝ wǝ beyifoyifo bǝtsyuǝ eto ani nkǝ bakase wǝ, lǝ lesa nǝ ke bǝnyǝ lǝ ɔkuɛ ǝmǝǝ, lǝ befi baboko lǝ besie bǝtsyuǝ. Nya údu úsu kusu. ");
INSERT INTO lip_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Se lefe léyo bǝ balɛ eyibibi nyamǝǝ, osani ǝmǝ ákpe mǝ wǝ uyifoyifo ɔni nkǝ lǝ bɔɔlɛ eyibibi nyamǝǝ, lǝ batsyɛ nya lǝ akpa ǝnuǝ lǝ osani ǝmǝ lǝ ofo wǝ lekpa oboko wǝ. ");
INSERT INTO lip_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Fɛɛ beyifoyifo bamfo ko dímuǝ wǝ uyifoyifo ǝmfo báblɛ nya bála wǝ bátsyese nya údu anifufu. ");
INSERT INTO lip_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Nya osani ǝmfo disi ótsyese uyifoyifo bamba. Nya se úsuu, beyifoyifo bamfo lɛblɛ wǝ nya ófo lefabe lǝ disi, nya bákpe wǝ kofani tinti. ");
INSERT INTO lip_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Nya osani ǝmfo disi ótsyese wǝ uyifoyifo bamba bio, nya báblɛ wuntsya nya bálo wǝ. Nnya kamaa, usi ótsyese wǝ beyifoyifo kpǝ. Nya báblɛ bǝtsyuǝ nya bálo bafɛfɛ. ");
INSERT INTO lip_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Utidi wǝ dibu wǝ bio wootsyese wǝ ni osani ǝmfo kosate eto ubi lala. Lɛfɛfɛɛ, ótsyese wǝ. Nya ɔ́tɛyi wǝ ǝsuǝ nkǝ, ‘Mfo nnɔ miǝ boobu mɔ ubi.’ ");
INSERT INTO lip_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Fɛɛ beyifoyifo bamǝ átɛyi mǝ ǝsuǝ bǝnkǝ, ‘Nyǝ nwǝ luudi Bonamute eto bikǝ. Bibǝ lǝ bumuǝ wǝ bolo, lǝ bɔlɛ wǝ kedikɔ bofo bofianinsǝ bo kale.’ ");
INSERT INTO lip_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Nyaso bǝmuǝ ubi ǝmfo. Nya bálo wǝ. Béfi wǝ bǝduǝ lǝ ɔkuɛ ǝmǝ eto kama.” ");
INSERT INTO lip_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Nya Yesu lɛtɔ mǝ nkǝ, “Be befo bɛnɔ biǝ osani ǝmfó ebuyifo? Mɔɔtɛyi mi minkǝ wuusu mfó usu olo beyifoyifo bamfó, ɔlɛ ɔkuɛ ǝmfo ofo okpe betidi bambaa kɔni. ");
INSERT INTO lip_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ntɔ bíankla lǝ Awɔnisa Kɛnkɛ Eto Kukuǝ kaka bátɛyi bǝnkǝ, ‘Leba nǝ mba laato ayo lɛni bǝ dimbǝ kɔnɔɔ, ni bomu díbǝ lefiani nǝ nso bofe lǝ afɛfɛ kenke nti. ");
INSERT INTO lip_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Bonamute ni nwǝ díyifo nyamfo. Iyifo lesa nǝ laanɔ bobe sitinti!’ ” ");
INSERT INTO lip_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Nya se bánɔ nyamfoo, Yudafɔ eto beninǝ ákplatsya kekleke bǝ lǝ bǝmuǝ Yesu. Itsyise bǝnyǝ bǝ lekpa nǝmǝ ɔ́tɛyi itsyi lǝ mǝ ǝsuǝ. Fɛɛ báte sitiditu sia ńyǝ mfó sikpi. Nyaso bédu lǝ wǝ ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Kamaa, bátsyese Farisifɔ ku Herodes eto betidi bǝtsyuǝ lǝ Yesu ɔflɔ bǝ lǝ besu betsyue wǝ etikididi ato lǝ bǝnyǝ kabua lǝ wǝ esuǝ. ");
INSERT INTO lip_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Se bésu wǝ ɔflɔɔ, bátɛyi wǝ bǝnkǝ, “Oteasa, buyi boǝ fǝǝ, ɔnukualɛtidi feni. Nya eentsyi fǝ etiki kawuninsǝ lǝ ǝdufǝ betidi ǝnǝ. Aante betidi eto ǝnǝmi sikpi, ɔkplɛ lee, ɔkɛkɛ. Nya ni bǝ Onanto eto kusu sɛɛ ǝsuǝ hã faate saa kayɛnko. Nyaso tɛyi bo lǝ ɛlɛkɛ bǝ boko oko butǝ Romafɔ eto Okankplɛ Kaisare ");
INSERT INTO lip_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Bofo lee boamfo?” Fɛɛ Yesu yi mǝ nkǝ ǝnǝmi ǝnǝmi eto betidi beni, nya ɔ́tɔ mǝ nkǝ, “Beso biala biǝ biato mɛ bebe? Beboko mɛ atabi lǝ mbe.” ");
INSERT INTO lip_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Báboko wǝ ani. Nya ɔ́tɔ mǝ nkǝ, “Owoe eto disi ku diye ntǝkǝ lǝ nnya ǝsuǝ mfo?” Mfó bǝtǝ mbuayɛ bǝ, “Okankplɛ Kaisare ni.” ");
INSERT INTO lip_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Nya Yesu lɛtɛyi mǝ nkǝ, “Nyaso bifi lesa nǝ ni Okankplɛ Kaisare eto lele bitǝ wǝ. Lǝ bifi lesa nǝ ni Onanto eto lele bitǝ Onanto.” Lǝ nyamfo esoo, iyifo mǝ naa. ");
INSERT INTO lip_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sadukifɔ bǝtsyuǝ ǝbǝ Yesu ɔflɔ. Mǝ laate bǝnkǝ lǝ utidi ǝkpǝǝ, woensibusinkli otaka ubǝ nkpǝ. Bǝbǝ bǝ bátɔ Yesu ditiki ditsyuǝ. ");
INSERT INTO lip_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Bátɛyi wǝ bǝnkǝ, “Oteasa, Moses áwɔni lǝ afi nnya útǝ bo nkǝ, ‘Lǝ osani utsyuǝ ǝkpǝ nya óyani wǝ usiǝ utsyǝ nya bánle bebi saa, nyalɛ ele bǝ osani ǝmfo eto ɔyimisani, fi usio ǝmǝ ufi. Nya wǝ ku ɔkɔsiǝ ǝmǝ lǝ bale bebi. Nya bebi bamfóo, betidi ebunyǝ mǝ fe osani wǝ dimankɛ ubi saa eto bale.’ ");
INSERT INTO lip_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Nya íbǝ lefe lɔni bǝ, bayimisani ekuanse ǝsiǝ. Ututǝ éfi kusiǝ nya úkpǝ le lefe nǝ bánle ubi saa. ");
INSERT INTO lip_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Nya unuǝfǝ tsya dífi wǝ, nya wuntsya díkpǝ lefe nǝ eto lefe wonko usio ǝmfo dímanle ubi saa. Nko kǝ íbǝ lǝ wǝ ǝsuǝ bǝ banle ubi saa. ");
INSERT INTO lip_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Nko íbǝ bǝ mǝ ekuanse ba kenke éfi usio emfo bafia. Fɛɛ mǝmblɛ kenke ǝkpǝ lefe nǝ mǝ ku usio ǝmfo dímanle bebi saa. Nnya kama kamaa, usio ǝmfo tsya ǝkpǝ. ");
INSERT INTO lip_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Mɔmɔɔ, nnya ni bǝnkǝ lǝ lefe nǝ bǝkpǝnkpǝ kenke lootaka betsyi ɔkɔmǝ bǝbǝ nkpǝǝ, mǝ nti eto owoe luudi usio ǝmfo eto usǝ se mǝ betidi ekuanse bamǝ lǝ lefe ditsyuǝǝ, dikefi wǝ fe kusiǝ?” ");
INSERT INTO lip_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Nya Yesu dítǝ mbuayɛ nkǝ, “Inni nko ini kulaa. Nnyǝ minkǝ bíannɔ ditiki nǝmfo kasɔ, itsyise biannɔ etiki nya nkpe lǝ Awɔnisa Kɛnkɛ Eto Kukuǝ eto kasɔ nya binyi Onanto eto ǝsuǝale. Nyaso beta wǝ bibu. ");
INSERT INTO lip_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Lǝ lefe nǝ bǝkpǝnkpǝ lootakaa, bootsyǝ fe Onanto eto batɔnkpe, nyaso bembufi bǝsiǝ nye bǝsǝ. ");
INSERT INTO lip_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Nya lǝ bǝkpǝnkpǝ eto businkli kataka ǝsuǝ, Moses áwɔni lesatsyuǝ lǝ Awɔnisa Kɛnkɛ Eto Kukuǝ ǝsuǝ itsyi lǝ biyu eto eyi kpufɛɛ nnya díńyǝ utǝ ǝsuǝ. Onanto lídi wǝ etiki. Lee biankloma? Mfó ɔ́wɔni nkǝ Onanto átɛyi wǝ nkǝ, ‘Mɔ ni Abraham eto Onanto ku Isak eto Onanto ku Yakob eto Onanto tsya.’ ");
INSERT INTO lip_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Nnya kasɔ ni bǝnkǝ betidi ba díkǝkpǝ ebusinkli bǝbǝ nkpǝ, nya wǝ kǝ ni mǝ Onanto. Fɛɛ mi bíonya ɔnukualɛsu komfo koko!” ");
INSERT INTO lip_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Afi eto oteasa wǝ díńyǝ mfó ánɔ etiki nya banlɛ bɔtɛyi. Nya ánɔ nkǝ Yesu ǝtǝ etiki nyamǝ eto mbuayɛ kukɔnɔ. Nyaso ɔ́nyi úsu Yesu ɔflɔ nya ɔ́tɔ nkǝ, “Nte kɔfi ko ni nko nso bofe lǝ afi nnya kenke nti?” ");
INSERT INTO lip_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Mfó Yesu lɛtɛyi wǝ nkǝ, “Kɔfi ko nso bofe ni nko báwɛni bǝnkǝ, ‘Israel eto betidi, bɛlɔ bɛnɔ kukɔnɔ! Onanto ni bo Onamute, nya Onanto ɔni hã nkpe. ");
INSERT INTO lip_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Nyaso ele bǝ ala Onanto wǝ ni fǝ Onamute ku fǝ utu kenke, ku fǝ lɛwɔnɔ kenke ku fǝ nsusu kenke, ku fǝ ǝsuǝale kenke.’ ");
INSERT INTO lip_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Nya kɔfi ko nsi ntǝkǝ lǝ nkomfo eto kama ni bǝ, ‘La fǝ ɔyimitsyuǝ fe kase faala fǝ ǝsuǝ.’ Kɔfi saa ensibǝ ko ntǝkǝ afi nyamfo kato.” ");
INSERT INTO lip_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Nya osani ǝmǝ dítǝ mbuayɛ nkǝ, “Oteasa, átɛyi nnya kukɔnɔ! Lesa nǝ fátɛyi eyifo ɔnukualɛ bǝ Onanto ni bo Onamute, wǝ kama Onanto saa ensibǝ. ");
INSERT INTO lip_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Nya ele bǝ Utidi saa la Onanto itsyi lǝ wǝ utu ku wǝ nsusu kenke ku wǝ ǝsuǝale kenke. Nya ele bǝ ola wǝ utiditsyuǝ fe kase woala wǝ ǝsuǝ. Ɛlɛkɛ eso bǝ utidi di afi ǝnuǝ nyamfo, eso bǝ ufi bebuki ku keditǝtǝ bamba utǝ Onanto.” ");
INSERT INTO lip_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Se Yesu dínyǝ kasɔnɔnɔ ka ǝsuǝ osani ǝmfo lɛyɛ útǝ mbuayɛɛ, ɔ́tɛyi wǝ nkǝ, “Fǝ alɛɛ, ibu sɛkɛ ete lǝ edufǝ Onanto eto sekakedikɔ.” Nyamfo eto kamaa, kuutsyuǝ saa mensi kpe ɔkɔɛ nkǝ woatɔ Yesu kulesa tsya. ");
INSERT INTO lip_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Lefenǝ Yesu lɛkɛ lǝ Yudafɔ eto Disumuyo ɔnlɛ Anantotiki bote mfóo, ɔ́tɔ nkǝ, “Ntsyǝ ibǝ fɛ afi eto bateasa bamǝ nlɛ bɔtɛyi bǝnkǝ Utidi wǝ Nlɛ Bubǝǝ, ábɔ utsyi Oka David eto kafo? ");
INSERT INTO lip_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Lɛwɔnɔ Kɛnkɛ áwunsǝko Oka David átɛyi nkǝ, ‘Onanto átɛyi mɔ Onamute nkǝ, “Siǝ mfo lǝ mɔ kodiani isu ese lefe nǝ muutǝ efi fǝ akpa ǝtǝkǝ fǝ balo lǝ disinti.” ’ ");
INSERT INTO lip_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Nyalɛ lǝ David kosate lǝ Utidi wǝ Nlɛ Bubǝ bokpo nkǝ wǝ Onamutee, nyalɛ ntsyǝ ibǝ fɛ wǝ kosate loofo David eto kafo eto ubi budi?” Nya betidi kpǝ dínyǝ banlɛ etiki nnya Yesu nyǝ ɔnlɛ budi bɔnɔ ku disuǝyuǝ. ");
INSERT INTO lip_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Se Yesu nlɛ betidi bamfó asa botee, ɔ́tɛyi mǝ nkǝ, “Bebe sinini lǝ afi eto bateasa ǝsuǝ. Baala awu kplɛ bokpe nya baala bɔyɛ kafe kaka betidi luunyǝ mǝ bǝsiǝsǝ ku dibu. ");
INSERT INTO lip_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Bala nsiǝkɔ kplɛ busiǝ lǝ Yudafɔ eto ntsyakɔ ku lǝ asakedikɔ. ");
INSERT INTO lip_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Bǝlǝkǝ bakɔbǝsiǝ kɔhɔ. Kamaa, baalɛ mǝ bikǝ kafo. Nya bato kala kɛntsyɛɛ kate ǝsuǝ bǝ beyi Onanto. Mǝ kotonǝnǝ ǝbɔkɛ ale eso betidi fɛfɛ eto ale!” ");
INSERT INTO lip_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Nya Yesu díkǝnǝ úsiǝ lǝ kedi kǝtǝkɔ lǝ Disumuyo kaka banlɛ atabi boko, nya únsi ɔnlɛ bobe kase betidi nlɛ bofe kesu kako asa. Batabinyǝ kpǝ áko atabi kpǝ. ");
INSERT INTO lip_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Nya ɔkɔsiǝ okombo utsyuǝ tsya díbǝ ófe nya úfi atabi sɛkɛ úsu óko. ");
INSERT INTO lip_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Nya Yesu lékpadi wǝ bakasebi utsyǝ nya ɔ́tɛyi mǝ nkǝ, “Nlɛ mi bɔtɛyi sitinti minkǝ lǝ Onanto eto ǝnǝmii, ɔkɔsiǝ okombo ǝmfo eto atabi nnya ókoo, édufǝ ǝnǝ eso nnya betidi bamfo kenke léko. ");
INSERT INTO lip_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Sitintii, betidi bamfo kpe kɔni kalende. Fɛɛ nnya nte mǝ eto sɛkɛ ete baboko. Nya usionko ǝmfo alɛɛ, ite bǝ okombo ni tsyaa, ufi lesa nǝ ntǝ wǝ kenke úbǝ óko. Lesa nǝ ele bǝ wuufi oya lesa udii, nnya ni lesa nǝ úfi úbǝ óko mfo nɛ.” ");
INSERT INTO lip_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Se Yesu lɛbɔ lǝ Yudafɔ eto Disumuyo mfóo, wǝ bakasebi eto ɔni átɛyi wǝ nkǝ, “Oteasa, be aba nnya laanɔ bobe mfo beefi báto diyo kplɛ nǝmfo ku kase baato nii! Dianɔ bobe!” ");
INSERT INTO lip_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesu átɛyi wǝ nkǝ, “Bɛlɔ bebe diyo kplɛ nǝmfo kukɔnɔ, itsyise aba nya béfi báto ni eto lɛɛ lɔni embubu ditǝkǝ lǝ ni utsyuǝ ǝsuǝ! Diyo nǝmfo kenke eboba lekpo lǝ kasɔ nnya aba nyamfó kenke looba isensǝ ekpo.” ");
INSERT INTO lip_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesu édu úsu úsiǝ lǝ Nnuǝbi eto Eyi eto Kɔtini komǝ ǝsuǝ. Nya mfóo, úsiǝ ɔnlɛ Disumuyo nǝmǝ bobe katsyese. Nya Petro ku Yakobo ku Yohanes ku Andreas hã díbǝ wǝ ɔflɔ nya bátɔ wǝ bǝnkǝ, ");
INSERT INTO lip_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Onamute, dimamfe ayo nyamfó looba? Tɛyi bo asa nnya luubǝ lǝ bote boǝ lefe nǝmǝ eboyo bǝ nkomǝ eto asa nyamfo ebubǝ?” ");
INSERT INTO lip_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Nya Yesu lɛtɛyi mǝ nkǝ, “Bebe sinini, nya biǝntǝ lǝ kuutsyuǝ saa lǝ ɔwɛ mi okpe. ");
INSERT INTO lip_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Betidi kpǝ ebubǝ lǝ mɔ diye ǝsuǝ nya bɔɔtɛyi mi bǝnkǝ, ‘Nnyǝ mɔ ni nwǝ bákpo ɔhile ǝmǝ,’ nya bɔɔwɛ betidi kpǝ bakpe. ");
INSERT INTO lip_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Nya yenyifo mi bulǝ lǝ bɛnɔ ama eto kɔsɔ lǝ mi ɔflɔ nye lǝ katsyontsyokɔ. Ele bǝ asa nyamfo eto kakle bǝ. Tsya inni nnya kasɔ ni bǝnkǝ kawunsiǝ eto kalokɔ eboyo. ");
INSERT INTO lip_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kasɔ ka ebotaka nka lema. Nya sekakedikɔ ka ebotaka nka lema. Nsɔ ebutinkǝ lǝ kalebe saa, nya kukpɛnsǝ luubǝ. Asa nyamfo ebuyifo fe kase kalefo lǝǝnǝ usionko. ");
INSERT INTO lip_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Ele bǝ ibǝ bǝ lǝ mi kosate bimuǝ ǝsuǝ bitsyǝ. Boomuǝ mi bakpa mi besuko Yudafɔ eto beninǝ eto ǝnǝmi. Bɔɔblɛ mi lǝ ntsyakɔ. Boolǝkǝ mi bǝńyǝnsǝ lǝ baka ku nsɔ eto beninǝ eto ǝnǝmi lǝ mɔ disi eso, nya biɔtɛyi mǝ ditiki itsyi lǝ mɛ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Tsya fɛ kalosǝkɔ luubǝǝ, yuubǝ bǝ batɛyi kawunsiǝ eto ǝsǝ kenke eto betidi Onanto eto ditiki nǝmfo. ");
INSERT INTO lip_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Nya lǝ lefe nǝ bǝmuǝ mi besuko lekpokakpokɔɔ, biembu disi bɛtɔnsǝ itsyi lǝ lesa nǝ biɔtɛyi ǝsuǝ. Lǝ lefe nǝmǝ ayoo, lǝ bɛtɛyi ditiki nǝ Onanto eto Lɛwɔnɔ lookpe mi kɛnyɛ nkǝ bɛtɛyi. Itsyise inni mi kosate lǝǝbǝ etiki budi. Bomu Onanto eto Lɛwɔni loote mi lesa nǝ biɔtɛyi. ");
INSERT INTO lip_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Ɔyimi ebudu ɔyimi utǝ bǝ balo. Nya antomǝ tsya luuyifo nko ke ku mǝ bebi. Bebi ebotaka bǝńyǝ lǝ mǝ antomǝ ǝsuǝ bedu mǝ bǝtǝ bǝ balo. ");
INSERT INTO lip_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Bookisi mi lǝ mɔ disi. Fɛɛ utsyuǝ saa wǝ luunyǝ kekleke lǝ wǝ bofokanɔ ǝsuǝ isu ese kalosǝkɔɔ, Onanto ebulǝkǝ wǝ utsyiko lǝ kotonǝne ko bǝtsyǝ itǝ babuayifo ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Mɔmɔɔ, bifǝ ato lǝ bɛlɔ bɛnɔ kukɔnɔ. Lǝ binyǝ lesa nǝ Onanto leekisi nlɛ bubǝ lǝ wǝ Disumuyo kɛnkɛ, ka nlɛ mfo kɔfiɔ bokpe nya dimanle bǝ ɛkɛ mfoo, betidi ba nkpe lǝ Yuda tsyetsyi besu babiɔ lǝ atini ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Nwǝ ntǝkǝ lǝ wǝ ditsya ǝsuǝǝ, mensi bu disi nkǝ woayifǝ ubǝ ufi kulesa lǝ wǝ diyo. ");
INSERT INTO lip_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Utsyuǝ wǝ nńyǝ lǝ ɔkuɛ membu disi nkǝ wǝǝsinkli ubǝ oto nkǝ wǝǝbǝ ufi wǝ kafia. ");
INSERT INTO lip_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Lefe nǝmfó ebɔkɛ ale tinti itǝ besionko ba ni bafondɛ, nye mba nlɛ bebisambi ba nlɛ bɔyimi. ");
INSERT INTO lip_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Bɛlɛ Onanto lekpakpa bǝ lefe nǝmǝ mǝntǝkǝ lǝ lɛyɔ lefe! ");
INSERT INTO lip_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Itsyise bulǝ bo luubǝ lǝ lefe nǝmfóo, ǝbɔkɛ ale leso mbo ke díkǝbǝ bófe saa idu lǝ kawunsiǝ eto kasɔ ketsyikokɔ ibǝ ese mi eto lefe nǝmfo. Nya bulǝ bomfo eto okle ensiembubǝ inyǝ kulefe. ");
INSERT INTO lip_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Fɛɛ Onanto ǝbɔtɛyi utsyǝ nkǝ wuulǝkǝ eyi nyamǝ ubu. Itsyise lenni nkoo, kuutsyuǝ saa embubu usiǝ. Tsya lǝ wǝ betidi ba úkǝlǝkǝ utsyǝ esoo, wuulǝkǝ lefe nǝmǝ ubu. ");
INSERT INTO lip_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Nyaso lǝ utsyuǝ atɛyi fǝ nkǝ, ‘Bebe! Nnyǝ Kristo mfo,’ nye utsyuǝ tsya nkǝ, ‘Nyǝ wǝ nkpe mmǝǝ,’ mamfo anɔ! ");
INSERT INTO lip_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Itsyise mba luuyifo mǝ ǝsuǝ fe Kristo nye Onanto eto bǝnyɛlǝkǝtidii, kpǝ ebotaka bǝńyǝ. Booyifo ayanisa kpǝ ku asa nnya nkpe sikpi, itǝ bǝ lǝ boofoo, bɔɔwɛ Onanto eto betidi ba úkǝlǝkǝ utsyǝ taa kɔ kulaa tsya bakpe. ");
INSERT INTO lip_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Nyaso bimuǝ ǝsuǝ bitsyǝ! Ńtɛyi mi lesa saa ntɔnsǝ fɛ lǝ lefe nǝmǝ lǝ leyo. ");
INSERT INTO lip_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Nya lǝ eyi nnya luutǝkǝ lǝ bulǝ bomfo eto kamaa, ‘kofe ǝmbofa bio, nya kofande tsya lembuyǝnde. ");
INSERT INTO lip_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Befandebi ebuyifo fe bofankli bɛnlɛ ketsyi kato kǝbǝ kasɔ, nya kato eto asa kenke luutinkǝ.’ ");
INSERT INTO lip_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Lefe nǝmfóo, betidi ebunyǝ mɛ, Utidi Eto Ubi, nlɛ bubǝ lǝ asɔmiloku ǝsuǝ. Nya muubǝ ku Onanto eto ǝsuǝale lǝ diyǝnde kplɛ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Nya mootsyese mɔ kato eto batɔnkpe kawunsiǝ eto akpɔ ana nyamǝ lǝ nsu nlǝkǝ mɔ betidi ba mínkǝlǝkǝ míntsyǝ itsyi lǝ kawunsiǝ eto lekpake nǝmfo isu ese lǝ kalosǝkɔ ka nse. ");
INSERT INTO lip_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Bekase asa itsyi lǝ koto ǝsuǝ. Lǝ ibǝ bǝ binyǝ se kuyi komfó lɛ afanto fɔfɔ bulǝkǝǝ, eté mi bǝ kasɔmite ǝbɔfi. ");
INSERT INTO lip_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Nko ke lǝ ibǝ bǝ binyǝ asa nnya míntɛyi mi mfo lɛ kasɔ butsyǝ ku bubǝǝ, ete biote biǝ kawunsiǝ kamfo eto kalosǝkɔ ǝbɔfi nnya ikǝbǝ eyo fǝ kǝsiǝ pɛɛ! ");
INSERT INTO lip_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Sitinti nlɛ mi bɔtɛyi minkǝ asa nyamfo kenke ebubǝ itǝ fɛ efe nǝmfo eto betidi luukpǝ balo. ");
INSERT INTO lip_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kato ku kasɔ kenke ebubǝ kafe. Fɛɛ mɔ ditiki embubǝ lefe kulefe. ");
INSERT INTO lip_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Tsyaa, kuutsyuǝ saa enyi diyi nye lefe nǝ asa nyamfo luubǝ itǝ, Onanto eto batɔnkpe ku mɔ, Onanto eto Ubi kulaa tsya enyi, enso mɔ Anto hã nyi. ");
INSERT INTO lip_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Bebe kukɔnɔ lǝ bimuǝ ǝsuǝ bitsyǝ itsyise binyi lefe nǝ nyamfó luubǝ itǝ. ");
INSERT INTO lip_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Mɔ bubǝ ebuutsyǝ fe kase osani utsyuǝ luudu lǝ wǝ umǝ nkǝ wǝǝsu kusu, nya óyani wǝ beyifoyifo utsyǝ lǝ diyo. Útǝ utsyuǝ saa keyifo ka wuukeyifo. Nnya kamaa, ɔ́tɛyi nwǝ laase wǝ diyo nkǝ ɔlɔ ose wǝ diyo kekleke. ");
INSERT INTO lip_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Nko kǝ ele bǝ mi tsya muǝ ǝsuǝ binyǝ. Itsyise binnyi lefe nǝ mi Oyosate luubǝ udufǝ. Yoofo bubǝ bǝ wuubǝ ku kakɔmi lefe, nye ntsyetsyi, nye kolensiǝnto kplɛ ko bekusɛ lǝǝtǝ kɛnyɛ, nye olesiǝ. ");
INSERT INTO lip_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Lǝ ibǝ bǝ ubǝ ofuaa, yanle bǝ ibǝ bǝ ubǝ unyǝ mi bɛnlɛ selabe. ");
INSERT INTO lip_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Lesa nǝ minlɛ mi bɔtɛyi mfoo, nlɛ nnya bɔtɛyi itǝ betidi ba ta. Nnya ni bǝ bimuǝ ǝsuǝ bitsyǝ.” ");
INSERT INTO lip_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ibu eyi ǝnuǝ fɛ lǝ Yudafɔ lǝ bedi mǝ eyi nnya baakpo Ukpǝ Ása Bo Ɔ́yila ku Nnamfokuã Eto Abolo Eto Eyi, nyna beefi kakloma mǝ budu lǝ Egipte. Besumunyǝ ninǝ ku afi eto bateasa bǝtsyuǝ ákɛ mfó békebu disi lǝ kusu ko bɔɔyɛ kalɔkalɔ bǝmuǝ Yesu balo. ");
INSERT INTO lip_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Bátɛyi lǝ mǝ nti bǝnkǝ, “Yanle bǝ ibǝ nko lǝ eyisɛ nyamǝ eto lefe. Itsyise lenni nkoo, betidi ebunyǝ ɔblɔ bataka bǝńyǝ bo lǝ ǝsuǝ ibǝ ekpe bule.” ");
INSERT INTO lip_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu ésu Betania eto umǝ lǝ Simon wǝ díkefi bufisia únyǝ eto diyo. Lǝ lefe nǝ Yesu nsi mfó ɔ́nlɛ lesa budii, usionko utsyuǝ wǝ nlɛ nnuǝbi bo laanyi fififi eto dituntu nǝ baakpo alabasta ǝbǝ mfó. Baakpo nnuǝbi bomfó, bo lefo koya tintii bǝ naadi. Usionko ǝmfo ásini dituntu nǝmǝ nya ɔ́wuninsǝ nnuǝbi bomǝ ókpo Yesu lǝ disi. ");
INSERT INTO lip_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Nyamfo ǝlǝ betidi ba díńyǝ mfó. Nya kafo lɛnyi mǝ bátɛyi bǝtsyuǝ bǝnkǝ, “Beso woabiasǝ nnuǝbi bomfo nko? ");
INSERT INTO lip_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Eni ofo mu bote kǝnyǝ fe lɛlɛ wɔlɔlɔ eto kayo, ufi usu utǝ bakombo.” Nyaso béyǝnki bákpe wǝ bákpo wǝ kudu. ");
INSERT INTO lip_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Nyaso Yesu átɛyi mǝ nkǝ, “Beyani wǝ kpoo! Be so biayani wǝ lǝ bɛyɛ wǝ bulǝ? Lesa sɛɛ úyifo útǝ mɛ. ");
INSERT INTO lip_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Bakombo kpe mi lenti lefe saa. Nya biofo mǝ bɔwunsǝko lǝ lefe nǝ ke beela. Mɔ alɛɛ, inni lefe saa mɔɔkɛ mi lenti. ");
INSERT INTO lip_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Usionko ǝmfo éyifo lesa nǝ wofo buyifo. Úfi nnuǝbi bomfo ókpo mɛ lǝ ǝsuǝ ɔ́lɔ mɛ utsyǝ itǝ muukpǝ fɛ buubikǝ mɛ. ");
INSERT INTO lip_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nlɛ mi bɔtɛyi sitinti minkǝ kaka ke boobe Onanto eto ditiki sɛɛ nǝmǝ letsya lǝ kawunsiǝ kamfoo, bɔɔtɛyi nnya usionko ǝmfo tsya díyifo mfo kefi kakloma wǝ.” ");
INSERT INTO lip_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Nyaso Yuda Iskariot wǝ ni Yesu eto bakasebi lefosi inuǝ bamǝ eto ɔnii, ésu besumunyǝ ninǝ bamǝ ɔflɔ nkǝ woote Yesu udi utǝ mǝ. ");
INSERT INTO lip_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ǝsuǝ ǝyuǝ mǝ tinti se bánɔ etiki nnya úbǝ ɔ́tɛyi mǝ, nya mǝ tsya lɛtɛyi bǝ buutǝ wǝ atabi. Nyaso Yuda ákabɛbɛ kusu ko wɔɔnyɛ ote mǝ kase boomuǝ wǝ. ");
INSERT INTO lip_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Lǝ diyi tutɛ lǝ Nnamfokuã eto Diyididi nǝ baalo Ukpǝ Ása Bo Ɔ́yila Eto Asamubi lǝ mǝ lekpa ǝsuǝǝ, Yesu eto bakasebi átɔ wǝ bǝnkǝ, “Se faala fǝ bɔlɔ butsyǝ itǝ Ukpǝ Ása Bo Ɔ́yila eto diyisɛ nǝmǝ eto budi?” ");
INSERT INTO lip_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Nyaso Yesu ǝlǝkǝ bakasebi inuǝ lǝ mǝ bǝtsyuǝ nti nya ɔ́tɛyi mǝ nkǝ, “Mi bisu umǝnkpɛ ǝmǝ nya biotsyako utsyuǝ wǝ ntsyi ntu ku ɔlɔtsyi. Bitǝkǝko wǝ bisu diyo nǝ ǝsuǝ wuudufǝ. ");
INSERT INTO lip_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Nya lǝ bɛtɛyi Oyosate ǝmǝ biǝnkǝ, ‘Oteasa ǝmǝ lɛ bɔtɛyi nkǝ, te bo diyo nǝ kafo wonko wǝ bakasebi luubǝ bedi mǝ lesa lǝ Ukpǝ Ása Bo Ɔ́yila Eto Diyisɛ nǝmǝ ǝsuǝ.’ ");
INSERT INTO lip_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Mfóo, woote mi diyo nǝ lɛmɔ kafo lǝ diyo nǝmǝ eto abanslo kaka bálɔ asa bǝtsyǝ kukɔnɔ itǝ bo.” ");
INSERT INTO lip_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Bakasebi bamfo édu búsu umǝ, nya bǝnyǝ lesa saa fe kase Yesu lɛtɛyi mǝ. Nya béyifo Ukpǝ Ása Bo Ɔ́yila ǝmfo eto lesa nǝmǝ bǝtsyǝ mfó. ");
INSERT INTO lip_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Se ditsyitsyo lefe léyoo, Yesu ku wǝ bakasebi lefosi inuǝ bamǝ ésu mfó. ");
INSERT INTO lip_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Nya lǝ lefe nǝ bénsi bánlɛ búdii, Yesu átɛyi nkǝ, “Nlɛ mi bɔtɛyi sitinti minkǝ mi ɔni wǝ bonko wǝ nlɛ kɔni bokpe lǝ ɔkpɛ kedi lesa mfoo, ebote mɛ udi.” ");
INSERT INTO lip_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ditiki nǝmfo éyifo mǝ buɛɛ ku sikpi, nya bétsyiko wǝ bɔtɔ ɔni, ɔni, bǝnkǝ, “Sitinti, nyi miǝ inni mɔ ni fanlɛ, lee mɔ ni?” ");
INSERT INTO lip_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesu ǝtǝ mbuayɛ nkǝ, “Mi lefosi inuǝ eto ɔni ni. Nya ni bǝ bonko wǝ nlɛ kɔni bokpe lǝ ɔkpɛ ɔni mfo kedi. ");
INSERT INTO lip_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mɔ, wǝǝ ni Utidi Eto Ubi ebukpǝ fe kase báwɔni bákpe lǝ Awɔnisa Kɛnkɛ Eto Kukuǝ ǝsuǝ. Fɛɛ ilǝ mɛ itǝ futsyǝ ǝmǝ itsyise woǝbǝ ohiã bunyǝ fefe. Lǝ nnya ete bánle utsyǝ ǝmfóo, eni yɔɔlɛkɛ eso!” ");
INSERT INTO lip_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Lǝ lǝ lefe nǝ bánlɛ lesa búdii, Yesu éfi abolo ǝtsyuǝ. Nya lefe nǝ úkasɔ Onanto anii, úbudi nnya wɛlɛwɛlɛ nnya úsie ni útǝ wǝ bakasebi. Nya ɔ́tɛyi mǝ nkǝ, “Befo nyamfo lǝ bidi. Nyamfo ni mɔ usuǝ eto sinǝ nɛ.” ");
INSERT INTO lip_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Nya úfi lɛkɔbe ku nte, nya se ɔ́sɔ Onanto anii, úfi útǝ mǝ nya bǝnǝ. ");
INSERT INTO lip_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nya ɔ́tɛyi mǝ nkǝ, “Nyamfo ni mɔ kɔtɔ ko muufi ntǝ lǝ betidi kpǝ eto disi, ko Onanto luufi uyifo ketsyue fɔfɔ lǝ wǝ ku wǝ betidi eto nti. ");
INSERT INTO lip_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Lǝ ɔnukualɛ ǝsuǝǝ, mensiǝmbunǝ nte fɔfɔ bomfo bio, isu ese lefe nǝ muunǝ nte fɔfɔ bomfo eto okle lǝ Onanto eto sekakedikɔ.” ");
INSERT INTO lip_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Nya bése kusǝ béfi bátɛsǝ Onanto nya bédu bésu Nnuǝbi eto Eyi eto Kɔtini. ");
INSERT INTO lip_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Mfó Yesu lɛtɛyi wǝ bakasebi nkǝ, “Mi utsyuǝ saa ebutsyetsyi óyani mɛ utsyǝ. Itsyise Onanto átɛyi lǝ Awɔnisa Kɛnkɛ Eto Kukuǝ ǝsuǝ nkǝ, fe kase báwɔni bǝtsyǝ bǝ ‘Moolo nwǝ laase basamu bamǝ, nya wǝ basamu luusǝnsǝ.’ ");
INSERT INTO lip_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Fɛɛ lǝ ntaka ntsyi lǝ ɔkɔmǝ mbǝǝ, mɔɔtɔ mi nsu Galilea.” ");
INSERT INTO lip_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Nya Petro lɛtɛyi wǝ nkǝ, “Mɔ alɛ mǝmbutsyetsyi ndu fǝ lǝ ɔflɔ kulefe, lǝ ibǝ bǝ bafɛfɛ kenke ebuyifo nko kulaa tsya.” ");
INSERT INTO lip_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu átɛyi Petro nkǝ, “Nlɛ fǝ bɔtɛyi sitinti minkǝ fɛ ukusɛ luutǝ kɛnyɛ dinuǝfǝ lǝ kǝtsyǝ kamfoo, fǝ kosate ǝbɔni mɛ sitsyǝ.” ");
INSERT INTO lip_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Petro esi óse wǝ uyi óka ntamu ɔ́tɛyi nkǝ, “Lǝ ibǝ bǝnkǝ balo bonko fǝ tsyaa, mǝmbɔni fǝ ntɛyi minkǝ minyi fǝ.” Nnya ke wǝ bakasebi bamǝ tsya lɛtɛyi nɛ. ");
INSERT INTO lip_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Nya bédu Getsemane. Nya Yesu lɛtɛyi wǝ bakasebi nkǝ, “Bisiǝ lǝ kasɔ mfo lǝ nsu nto ola.” ");
INSERT INTO lip_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Nya ókpa Petro ku Yakobo ku Yohanes ɔ́yɛnko. Nya se lesa nǝ nlɛ wǝ bubǝ lǝ ǝsuǝ nlɛ wǝ bulǝ esoo, ");
INSERT INTO lip_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ɔ́tsyi ɔ́wininsǝ nya ɔ́tɛyi mǝ nkǝ, “Nyamfo lɛ mɛ bulǝ lǝ utu ku kanyinyǝnyǝ itǝ ukpǝ. Bianlabe selabe. Bińyǝ bisǝkǝ mɛ mfo.” ");
INSERT INTO lip_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Se ɔ́nyi úsu sɛtɔ sɛkɛɛ, ókpo lǝ kasɔ nya óto ola ɔ́lɛ wǝ anto lekpakpa nkǝ, “Lǝ yuuyifo fǝ lelabii, nyalɛ tǝ bulǝ bomfo lǝ bofe mɛ.” ");
INSERT INTO lip_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Nya ɔ́tɛyi nkǝ, “Mɔ Anto, Onanto! Aafo lesa saa buyifo. Lǝ aalaa, nyalɛ takasǝ bulǝ bomfo lǝ mɛ ǝsuǝ. Tsya inni lǝ mɔ lelabi ǝsuǝ bomu lǝ fǝ lele ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Lefe nǝ úsinkli úbǝ wǝ bakasebi itsyǝ bamǝ ɔflɔɔ, úbǝ únyǝ nkǝ bálabe selabe. Nya ɔ́tɔ Simon Petro nkǝ, “Simon, selabe fanlɛɛ? Ǝmbofo ǝnǝ butǝkǝ lebombosɔsɔ lɔni kplon tsya ete?” ");
INSERT INTO lip_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Nya ɔ́tɛyi mǝ nkǝ, “Bitǝkǝ ǝnǝ bisiǝ bikato ola bǝ biǝmbudufǝ lǝ botoo kabe ǝsuǝ. Lɛwɔnɔ nǝmǝ lɛ bola, fɛɛ ǝsuǝale ǝmbǝ.” ");
INSERT INTO lip_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Úsinkli úsu bio nkǝ weesu oto ola fe ditutɛ ke. ");
INSERT INTO lip_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Úsinkli úbǝ wǝ bakasebi ɔflɔ bio nya usi úbǝ únyǝ nkǝ besi bálɛ selabe. Bánlɛ mǝ ǝnǝmi bofo buminkli. Nya bánte lesa nǝ bɔtɛyi wǝ lǝ nnya ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Se úsinkli úbǝ ditsyǝfǝǝ, ɔ́tɔ mǝ nkǝ, “Bola bela biǝ bialabe bitsyǝ ɔnwɛ? Isiǝ, betaka! Lefe nǝmǝ eboyo. Bebe! Ubǝ mɔ, Onanto eto Ubi, bufi kakpe babuayifo eto ani. Bebe mǝǝ, se baankpee kusu banlɛ bubǝ. ");
INSERT INTO lip_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Betaka lǝ busu botsyako mǝ. Bebe nwǝ dífi mɛ ókpe mǝ lǝ ani nlɛ bubǝǝ.” ");
INSERT INTO lip_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Mǝ ku Yesu si bǝńyǝ mfó bálɛ etiki fɛ Yuda wǝ ni lefosi bakasebi inuǝ bamǝ eto ɔni díbǝ. Besumunyǝ ninǝ ku afi eto bateasa ku umǝ ǝmǝ eto beninǝ kpǝ ǝtǝkǝko wǝ bǝbǝ. Bétsyi keyi ku nlanle. ");
INSERT INTO lip_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Nwǝ dídu wǝ útǝ mfóo, ébɔtɛyi betidi bamfo utsyǝ nkǝ, “Utidi wǝ biunyǝ muusiǝsǝ mfiɔ lǝ kolaa, wǝ ni nwǝ ǝmǝ nɛ. Bimuǝ wǝ, lǝ bekpa wǝ bidunko.” ");
INSERT INTO lip_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Nyaso se Yuda lɛyɛ úsu útu Yesu, ókpadi wǝ nkǝ, “Oteasa!” Nya ɔ́fiɔ wǝ lǝ kola. ");
INSERT INTO lip_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Nyaso bǝmuǝ Yesu nya bákɔbe wǝ kekleke. ");
INSERT INTO lip_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Nya mba díńyǝ lǝ Yesu ɔflɔ eto ɔni dílǝkǝ wǝ kalanle nya óla Usumunyǝ Ninǝ Kenke eto odomunyǝ eto koto. ");
INSERT INTO lip_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Nya Yesu lɛtɔ mǝ nkǝ, “Beso ele bǝ bitsyi keyi ku nlanle fɛ lǝ bibǝ bimuǝ mɛ lǝ ǝsuale ǝsuǝ fe uyu mini? ");
INSERT INTO lip_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Bo ku mi ete lɛkɛ lǝ Disumuyo mfó diyi saa, nya minkɛ mfó mínkate Anantotiki nyamǝ mfó tsya bíǝmmuǝ mɛ. Bǝ lǝ kase Onanto eto Awɔnisa Kɛnkɛ Eto Kukuǝ lɛtɛyi utsyǝǝ, lǝ ibǝ itǝ nko.” ");
INSERT INTO lip_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Nya wǝ bakasebi kenke dítsyetsyi báyani wǝ bǝtsyǝ. ");
INSERT INTO lip_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Lǝ lefe nǝmǝ mfoo, okosobi utsyuǝ wǝ nti kafia ǝsuǝ ntǝkǝko wǝǝ, ǝnyǝ lesa nǝ kenke díbǝ. Bamamanyǝ bamǝ ála lǝ bǝmuǝ okosobi ǝmfo. Fɛ ini wǝ kafia ete bákɔbe, nya ɔ́kpɔ ");
INSERT INTO lip_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ɔ́bɔ mǝ lǝ ani. Nya útsyǝtsyi údu leyaleya. Nya óyani wǝ kafia ókpe mǝ lǝ ani. ");
INSERT INTO lip_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Nya bákpa Yesu bésuko Usumunyǝ Ninǝ Kenke eto diyo. Mfó nya besumunyǝ beninǝ bamǝ ku umǝ eto beninǝ ku afi eto bateasa létsya bénsi. Mǝ ni Yudafɔ eto beninǝ. ");
INSERT INTO lip_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petro ǝtǝkǝko mǝ kama kama nya úsu údufǝ lǝ usumunyǝ ninǝ eto diyo nǝmǝ. Nya úsu úsiǝ lǝ bamamanyǝ bamǝ ɔflɔ ɔ́nlɛ ute bɔyifǝ. ");
INSERT INTO lip_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Besumunyǝ ninǝ ku Yudafɔ eto beninǝ kenke ba dísiǝ mfó ákplatsya babe lǝ boofo kabua kǝtsyuǝ bunyǝ lǝ Yesu ǝsuǝ lǝ bayɛ bǝmuǝ wǝ balo. Tsya bámfo kabua saa bunyǝ lǝ wǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Betidi kpǝ ǝbǝ bedi etiki bátɛyi bidia lǝ wǝ ǝsuǝ, tsyaa mba díbǝ eto etiki áta ibu lǝ bǝtsyuǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Nya bǝtsyuǝ létaka bátɛyi nya bála wǝ kɛnyɛ bǝnkǝ, ");
INSERT INTO lip_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Bɔnɔ bǝ ɔ́tɛyi nkǝ, ‘Mooba Onanto eto Disumuyo nǝ báto mfo, tsya lǝ diyi tsyǝfǝ ǝsuǝǝ, muusinkli nto lebamba nǝ bémfi betidi eto ani báto.’ ” ");
INSERT INTO lip_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Fɛɛ mǝ tsya eto etikididi mánkate ku mǝ bǝtsyuǝ eto ale. ");
INSERT INTO lip_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Usumunyǝ ninǝ kenke átaka úńyǝ lǝ mǝ nti nya ɔ́tɔ Yesu nkǝ, “Anlɛ etiki nnya banlɛ bɔtɔ bɔnɔ? Embutǝ mbuayɛ? Be nkpe fǝ fɔɔtɛyi?” ");
INSERT INTO lip_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Tsya Yesu édi bi, wémfǝ kɛnyɛ ɔ́tɛyi kulesa. Usumunyǝ ninǝ kenke ǝmfo esi ɔ́tɔ wǝ nkǝ, “Fǝ ni Nwǝ mǝ Bákpo Ɔhile, Onanto ǝmǝ boatɛsǝ eto Ubi?” ");
INSERT INTO lip_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu átɛyi wǝ nkǝ, “Mɔ ni. Nya biuunyǝ Utidi Eto Ubi se unsi lǝ Ǝsuǝaletidi Onanto eto kodiani. Nya biunyǝ se unsi lǝ asɔmiloku utsyi kato ɔnlɛ bubǝ!” ");
INSERT INTO lip_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Lǝ lefe nǝmfó tututuu, Usumunyǝ Ninǝ Kenke ǝmfo kosate ko léfuadi wǝ awu ku lɛblɔfi ɔ́tɛyi nkǝ, “Fǝnkǝ bee? Badansiɛ sa nńsife itǝ bo bio itsyi lǝ mba ńyǝ mfo kama! ");
INSERT INTO lip_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Údi mbusiotiki úńyǝ lǝ Onanto ǝsuǝ! Ntsyǝ binyǝ lǝ wǝ ǝsuǝ?” Nya mǝmblɛ lɛtɔnɔ bálo wǝ dikpi bǝ ele bǝ ukpǝ. ");
INSERT INTO lip_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Mǝ nti eto bǝtsyuǝ étsyiko ntufǝ butufǝ kákpo Yesu. Nya bákle wǝ ǝnǝmi nya bétsyiko wǝ bɔsɔ. Nya bánlɛ wǝ bɔtɛyi bǝnkǝ, “Tɛyi bo futsyǝ lɛsɔ fǝ!” Nya bamamanyǝ bǝtsyuǝ lékpa Yesu bédunko, nya básɔ wǝ lǝ atosi. ");
INSERT INTO lip_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Lǝ lefe nǝmfóo, Petro ébubǝ úsi lǝ Usumunyǝ Ninǝ Kenke ǝmǝ eto diyo fɛ usiobi wǝ nkpe wǝ lǝ ɔflɔ díbǝ. ");
INSERT INTO lip_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Lefe nǝ únyǝ Petro nsi lǝ uté ɔflɔ ɔnlɛ wǝ bɔyifǝǝ, ɔ́tɛyi wǝ nkǝ, “Fintsya ébutǝkǝko Yesu Nasaretnyǝ ǝmǝ ǝnyǝ!” ");
INSERT INTO lip_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Nya Petro dítudi kɛnyɛ ɔ́tɛyi nkǝ, “Bee? Mánnɔ lesa nǝ fanlɛ bɔtɛyi mfo eto kasɔ!” Nya ótaka údu úsu úńyǝ lǝ kesiǝ ɔflɔ. Kase óyo kǝsiǝ kamǝ ko ukusǝ ko dítǝ kɛnyɛ. ");
INSERT INTO lip_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Usiobi ǝmfo esi úbǝ mfó úbǝ óbe wǝ, nya usi útsyiko betidi ba díńyǝ mfó bɔtɛyi nkǝ, “Osani ǝmfo eyifo mǝ nti eto ɔni!” ");
INSERT INTO lip_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Tsya Petro esi útudi kɛnyɛ nko ke. Yanklɛ fɛ mba ńyǝ mfó lɛtɛyi wǝ bǝnkǝ, “Yanle bǝ ani fǝ enni mǝ ɔni, itsyise fintsya etsyi Galilea eto kasɔ.” ");
INSERT INTO lip_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Nya Petro léfa ɔ́tɛyi nkǝ, “Ekpe lǝ Onanto bǝ lǝ sidia minlɛ bɔtɛyii, lǝ unǝ mɛ koto! Minyi utidi ǝmǝ ǝsuǝ bɛnlɛ etiki budi ketsyiko mfo!” ");
INSERT INTO lip_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Lamfolamfo, ukusɛ ko disi útǝ kɛnyɛ dinuǝfǝ, nya Petro lékloma nkǝ Yesu átɛyi wǝ nkǝ, “Fɛ ukusɛ luutǝ kɛnyɛ dinuǝfǝǝ, ǝbutudi kɛnyɛ sitsyǝ fǝ enyi mɛ.” Nya ílǝ Petro lǝ utu nya úwi keku. ");
INSERT INTO lip_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Olesiǝnto ǝmfóo, besumunyǝ ninǝ, átsya ku Yudafɔ eto beninǝ ku afi eto bateasa ku Yudafɔ eto batɔnkotɔnko kenke. Se béfi nsusu lǝ etiki nyamǝ ǝsuǝ ku kase bɔɔyɛ ku nnya. Bákle Yesu nya bákpa wǝ bésuko Aba eto Unyɛsiǝ Ninǝ itǝ Romafɔ eto Aba wǝ baakpo Pilato ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Mfóo, Pilato átɔ Yesu nkǝ, “Fǝ ni Yudafɔ eto Oka?” Yesu átɛyi wǝ nkǝ, “Ee, lǝ kase fanlɛ bɔtɛyi.” ");
INSERT INTO lip_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Besumunyǝ ninǝ bamǝ ála etiki kpǝ bǝtǝkǝ Yesu. ");
INSERT INTO lip_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Nyaso Pilato esi ɔ́tɔ wǝ nkǝ, “Ǝmbulǝkǝ kɛnyɛ lǝ etiki saa ǝsuǝ? Tsyue koto lanɔ etiki nnya banlɛ bɔtɛyi lǝ fǝ ǝsuǝ!” ");
INSERT INTO lip_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Tsya, Yesu ménsitɛyi kulesa, nyaso íyifo Pilato yanii! ");
INSERT INTO lip_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Lefe saa lǝ eyo nkomǝ eto diyididi ǝsuǝǝ, íyifo Pilato eto lekpa nǝ ókayani betidi bua ba bákpe lǝ diyo eto ɔni wǝ bála kǝtǝ mǝ. ");
INSERT INTO lip_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Lǝ lefe nǝmfóo, bǝmuǝ osani wǝ baakpo Baraba bákpe le diyo. Úyifo futsyǝ lɛkɛ lǝ betidi ba létaka bǝnyǝ lǝ Romafɔ eto Aba ǝsuǝ nti. Nya lǝ kudu ko bákpo bǝlǝ betidi ku betidi ba bálo esoo, bǝmuǝ wǝ ku mba dítǝkǝko wǝ bákpe lǝ a Aba eto diyo. ");
INSERT INTO lip_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Nyaso se betidi kpǝ díbǝ bátsyaa, bátɛyi Pilato bǝnkǝ okloma kase wǝǝnyǝ mba baakpe lǝ ayo kaminsǝ fe kase wókala buyifo lɛlɛ saa. ");
INSERT INTO lip_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ɔ́tɔ mǝ nkǝ, “Bela biǝnkǝ nyani Yudafɔ eto Oka ǝmǝ ntǝ mi?” ");
INSERT INTO lip_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilato átɔ mǝ nko itsyise óte nkǝ kekisi ǝsuǝ eso besumunyǝ ninǝ lékpa Yesu báboko wǝ ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Nya besumunyǝ ninǝ bamǝ lídi betidi bamǝ bákpe bǝnkǝ bátɛyi Pilato bǝnkǝ, óyani Baraba bomu utǝ mǝ. ");
INSERT INTO lip_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilato esi údi betidi eto ditsyukpa nǝmǝ etiki nya ɔ́tɔ mǝ nkǝ, “Be bela biǝ nyifo ku utidi ǝmǝ biakpo biǝ Yudafɔ eto Oka mfo?” ");
INSERT INTO lip_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Nya báfa bátɛyi wǝ bǝnkǝ, “Sɔ wǝ lǝ uyikabie ǝsuǝ!” ");
INSERT INTO lip_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilato átɔ mǝ nkǝ, “Nte kabua ka úyifo eso?” Tsya, mǝmblɛ esi báfa bembembe bátɛyi bǝnkǝ, “Sɔ wǝ amanklasǝ lǝ uyikabie ǝsuǝ!” ");
INSERT INTO lip_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Se Pilato léla nkǝ weeyifo lǝ mǝ lelabi ǝsuǝ esoo, óyani Baraba útǝ mǝ. Nya útǝ béfi kekuefiofio báblɛ Yesu, nya úfi wǝ ókpe lǝ bamamanyǝ eto ani nkǝ besu basɔ wǝ bamanklasǝ lǝ uyikabie ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Bamamanyǝ bamǝ ákpa Yesu bésuko Aba eto Unyɛsiǝ Ninǝ eto diyo nya bákpadi bamamanyǝ fɛfɛ bǝ bǝbǝ mfó. ");
INSERT INTO lip_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Nya béfi kafia sia eto awu bákpe Yesu fe Oka nya béyifo biyu eto lekpakpa béti wǝ lǝ disi fe lekankpakpa. ");
INSERT INTO lip_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Nya banlɛ wǝ kɔfiɔ bokpe ákatɛyi bǝnkǝ, “Yuu, yuuduu,! Yudafɔ eto Oka lǝ usiǝ nkpǝ kɛntsyɛɛ!” ");
INSERT INTO lip_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Básɔ wǝ lǝ disi ku lekete nya bétufǝ ntufǝ bákpo wǝ lǝ ǝsuǝ. Nya báse akonki lǝ wǝ ɔflɔ bákpe disi kasɔ ku dibu bǝtǝ wǝ. ");
INSERT INTO lip_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Se bǝmǝ wǝ nya bákpe wǝ kofani bálosǝǝ, bǝlǝkǝ awu sia nyamǝ lǝ ǝsuǝ nya bésinkliko nnya ókpe kɔ bákpe wǝ. Nya bákpa wǝ bésuko kaka bɔsɔ wǝ bamanklasǝ lǝ uyikabie ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Lefe nǝ bántɔɔ, bátsyako osani wǝ baakpo Simon wǝ ditsyi dibutu ɔ́ntɔ lǝ Yerusalem. Nyaso bamamanyǝ bamǝ áhiɛ wǝ bǝnkǝ ɔwunsǝko Yesu lǝ utsyinko wǝ uyikabie ǝmǝ. Simon ǝmfó etsyi Sireni eto kasɔ, nya wǝ bebi ni Aleksandra ku Rufo. ");
INSERT INTO lip_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Bákpa Yesu bésuko kaka baakpo Ditidisikɔbe. ");
INSERT INTO lip_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Mfó bǝtǝ wǝ nte bo bátsyakasǝ ku kofa ko loobokosǝ kanyinyǝnyǝ kamǝ kasɔ bǝ unǝ, fɛɛ Yesu áni wǝnǝǝ. ");
INSERT INTO lip_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Nnya kamaa, bamamanyǝ bamǝ ásɔ wǝ bámanklasǝ lǝ uyikabie ǝsuǝ. Nya béfi afetu bákpo básɛ lǝ bate lekpa nǝ luutu utsyuǝ saa fɛ bésense awu nyamǝ bǝtǝ bǝtsyuǝ. ");
INSERT INTO lip_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Básɔ wǝ bamanklasǝ lǝ uyikabie ǝsuǝ lǝ olesiǝ ǝmfó eto abombo ɔwɔnɔmbǝ lefe. ");
INSERT INTO lip_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Nya báwɔni asa lɛ otabo kɛkɛ ǝsuǝ básɔ lǝ wǝ disi kato nnya nlɛ bote lesa nǝ eso bálo wǝ ni bǝnkǝ, “Ǝnyǝ Yudafɔ Eto Oka.” ");
INSERT INTO lip_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Nya básɔ beyu inuǝ tsya lǝ eyi ǝsuǝ báwunsǝ lǝ Yesu ǝsuǝ. Ɔni áfaka lǝ wǝ kodiani eto kutsyǝ nya ɔni tsya léfaka lǝ kǝmǝni. ");
INSERT INTO lip_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Mba kenke lɛyɛ mfó bafe étinkǝsǝ mǝ esi bákpe Yesu kɔfiɔ bátɛyi bǝnkǝ, “Ɛhɛɛ! Inni fǝ lɛtɛyi fǝ eboba bo Disumuyo kplɛ akpo lǝ kasɔ esinkli ato kǝ lǝ eyi ǝtsyǝ ǝsuǝ kɛɛ? ");
INSERT INTO lip_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Yifǝ ǝbǝ kasɔ lǝ ǝlǝkǝ fǝ ǝsuǝ etsyiko ukpǝ eto ani lǝ bobe!” ");
INSERT INTO lip_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Nko kǝ basumufɔ ninǝ ku afi eto bateasa bamǝ tsya dímǝ wǝ bátɛyi mǝ bǝtsyuǝ bǝnkǝ, “Úlǝkǝ betidi bamba utsyiko lǝ ukpǝ ǝsuǝ, fɛɛ wembofo wǝ ǝsuǝ bulǝkǝ ketsyiko lǝ ukpǝ ǝsuǝ! ");
INSERT INTO lip_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Lǝ wǝ baakpo Israelfɔ eto oka, wǝ ni Kristo ǝmǝǝ, wǝ Onanto Lékpo Ɔhile Utsyǝ sitintii, ulǝkǝ wǝ ǝsuǝ lǝ ɔyifǝ lǝ uyikabie ǝsuǝ ubǝ kasɔ bǝ lǝ bofo bɔnɔ!” Betidi inuǝ ba básɔ bafakasǝ lǝ eyikabie ǝsuǝ ku Yesu mfóo, tsya áka wǝ. ");
INSERT INTO lip_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Se éyo kakɔmi lefee, kasɔ mfó kenke ko léna. Nya ítsyǝ nko ísu ése abombo etsyǝ. ");
INSERT INTO lip_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Nya lǝ lefe nǝmfóo, Yesu áfa bembembe ɔ́tɛyi nkǝ, “Eli, Eli, lama sabaktani?” Etiki nyamfo eto kasɔ ni bǝ, “Mɔ Onanto, mɔ Onanto! Beso fáyani mɛ fǝtsyǝ?” ");
INSERT INTO lip_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Betidi bǝtsyuǝ díńyǝ mfó ánɔ lesa nǝ ɔ́tɛyi, nya bátɛyi bǝtsyuǝ bǝ, “Ɔlɛ Onanto eto Unyɛlǝkǝtidi Elia bokpadi.” ");
INSERT INTO lip_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Mǝ ɔni étsyetsyi úsu úfi okosa wǝ bákpe lǝ ntǝ eto sonkpe ǝsuǝ nya óbesǝ wǝ kato ku uyi útǝ Yesu nkǝ unǝ. Nya ɔ́tɛyi bafɛfɛ nkǝ, “Bińyǝ lǝ bobe! Bitǝ lǝ bobe lǝ Onanto eto Unyɛlǝkǝtidi Elia ebubǝ ulǝkǝ wǝ utsyiko lǝ uyikabie komfo ǝsuǝ!” ");
INSERT INTO lip_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Nya Yesu léfa bembembe nya úkpǝ. ");
INSERT INTO lip_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Lǝ lefe nǝmfó ǝsuǝ tutuutuu, kafia kplɛ ka léfakanya kéti Yudafɔ eto Disumuyo eto Kakɛnkɛkɔ Kenke eto ǝnǝmii, léfuadi lǝ akpa ǝnuǝ itsyii kato ibǝ kasɔ. ");
INSERT INTO lip_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Nya se omamanyǝ ninǝ wǝ díńyǝ lǝ uyikabie ǝmǝ ɔflɔ lɛnɔ Yesu eto bofa nya únyǝ kase úkpǝǝ, ɔ́tɛyi nkǝ, “Sitinti utidi ǝmfo eyifo Onanto eto Ubi.” ");
INSERT INTO lip_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Besionko bǝtsyuǝ tsya ǝńyǝ kɔsɛsɛ bákabe. Maria Magdalene ku Salome ku Maria nwǝ eto bebi ni Yakobo kɛkɛ ku Yosef, akɛ mǝ lenti. ");
INSERT INTO lip_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Lefe nǝ Yesu lɛkɛ lǝ Galileaa, mǝ dítǝkǝko wǝ bákawunsǝ ko wǝ nɛ. Besionko bamba kpǝ ba dítǝkǝko wǝ bésu Yerusalem tsya ǝńyǝ mfó. ");
INSERT INTO lip_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Asa nyamfo ǝbǝ lǝ diyi nǝ bǝǝmuǝ ǝsuǝ itǝ bǝ lǝ kofe edufǝ diyoo, lǝ bedi Ɔnwɛditsyǝyi eto diyi. Nya se kale nlɛ boloo, ");
INSERT INTO lip_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Yudafɔ eto okponkpo ɔni wǝ baakpo Yosef wǝ ditsyi Arimatea eto uninǝ, ákpe ɔkɔɛ úsu únyǝ Pilato. Yosef éyifo Yudafɔ eto Uninǝ kplɛ wǝ lɛkɛ dibu nya úkabe kusu itǝ Onanto eto Sekakedidi eto bubǝ. Se óyo Pilato ɔflɔɔ, ɔ́lɛ wǝ lekpakpa nkǝ utǝ wǝ kusu lǝ usu ulǝkǝ Yesu eto ɔkɔ ǝmǝ usu ubikǝ fɛ lǝ eyo Ɔnwɛditsyǝyi ǝmǝ. ");
INSERT INTO lip_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Se Pilato lɛnɔ nkǝ Yesu ébukpǝ kokoo, íyifo wǝ naa. Nyaso ókpadi wǝ omamanyǝ ninǝ wǝ díńyǝ lǝ etsyuesa nyamfó eto kɛnyɛ, nya ɔ́tɔ wǝ lǝ sitinti ini bǝ Yesu ébukpǝ koko. ");
INSERT INTO lip_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Nya se uninǝ ǝmfo lɛtɛyi wǝ nkǝ ɔnukualɛ inii, Pilato ǝtǝ Yosef kusu nkǝ usu ulǝkǝ ɔkɔ ǝmǝ. ");
INSERT INTO lip_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Nya Yosef dísu úlǝkǝ Yesu eto ɔkɔ nya úfi kafia kpaa fɔfɔ ka óya úmli wǝ. Nya úfi wǝ úsu úbikǝ lǝ kudi ko bǝlǝkǝ lǝ koba kǝmiǝ bǝtsyǝ koko lǝ kɔtini ɔflɔ. Nya útǝ nkǝ baminansǝ leba kplɛ lɔni beti lǝ kudi komǝ eto kɛnyɛ. ");
INSERT INTO lip_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Lǝ lefe nǝmfóo, Maria Magdalene ku Maria wǝ ni Yosef eto ambe ǝńyǝ mfó nya bábe kaka bébikǝ Yesu eto ɔkɔ ǝmǝ. ");
INSERT INTO lip_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Kǝsiǝsǝ eto ditsyitsyoo, lefe nǝ békedi Ɔnwɛditsyǝyi bálosǝǝ, Maria Magdalene ku Maria wǝ ni Yakobo eto ambe ku Salome ésu báya nnuǝbi bo laanyi fififi bǝnkǝ beesu bediki Yesu eto ɔkɔ. ");
INSERT INTO lip_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Nyaso se kale dísiǝ kɔsida eto olesiǝǝ, bátaka bésu kudi komǝ eti. ");
INSERT INTO lip_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","Se bántɔɔ, bákatɔ mǝ bǝtsyuǝ bǝnkǝ, “Owoe buunyǝ lɔminansǝ leba kplɛ nǝmǝ lǝ kudi komǝ eto kɛnyɛ utǝ bo?” Bátɔ mǝ ǝsuǝ nko itsyise leba nǝmǝ amɔ tinti. Nya se bésu bédufǝ mfóo, bǝnyǝ bǝnkǝ futsyǝ ébubǝ ɔ́minansǝ leba nǝmǝ lǝ mfó. ");
INSERT INTO lip_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Nyaso se bédufǝ kudi komǝ kafoo, bǝnyǝ okosobi utsyuǝ se únsi lǝ kodiani. Nya ónkpe awu nnya diflubi futututu! Difufu ǝmuǝ mǝ. ");
INSERT INTO lip_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Nya okosobi ǝmǝ lɛtɛyi mǝ nkǝ, “Biante sikpi! Nyi minkǝ Yesu Nasaretnyǝ ǝmǝ bɛnlɛ bɔbɛbɛ, nwǝ básɔ báfakǝsǝ lǝ uyikabie ǝsuǝ. Umbǝ mfo! Ótaka okpe nkpǝ! Bebe! Mfo bálabesǝ wǝ nɛ. ");
INSERT INTO lip_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Nyaso bisu bɛtɛyi wǝ bakasebi ku Petro tsya biǝnkǝ, ‘Yesu tɔ mi sɛtɔ, ɔtɔ lǝ Galilea. Mfó ti biunyǝ wǝ fe kase ɔ́tɛyi mi utsyǝ.’ ” ");
INSERT INTO lip_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Nyamfo ákpe besionko bamǝ difufu, nya bédu lǝ kudi komǝ ɔflɔ ku ketinkǝ, bánte lesa nǝ beeyifo, nya bákpe etsyi ani. Kase bánkpe lǝ kusu bántɔɔ, bántɛyi kuutsyuǝ kulesa, itsyise sikpi ǝmuǝ mǝ. ");
INSERT INTO lip_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Se Yesu létaka utsyi ɔkɔmǝ Kɔsida komfo eto olesiǝǝ, utidi tutɛ wǝ úlǝkǝ ǝsuǝ óte ni Maria Magdalenyǝ, nwǝ ǝsuǝ óla awɔnɔ bua akuanse utsyiko lǝ lefe nǝ ditsyuǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Úsu ɔ́tɛyi Yesu eto bayɛtsyuǝ ba nlɛ nku buwi lǝ wǝ ukpǝ ǝmǝ eso. ");
INSERT INTO lip_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Nya se Maria lɛtɛyi mǝ nkǝ Yesu kpe nkpǝ nya únyǝ wǝǝ, bámfo wǝ bánɔ. ");
INSERT INTO lip_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Nyamfo eto kamaa, Yesu ǝlǝkǝ ǝsuǝ óte bakasebi inuǝ lǝ lefe nǝ bányɛ lǝ kusu bántɔ. Fɛɛ bǝnnyǝ wǝ betsyǝ lekpo mlǝ. ");
INSERT INTO lip_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Kama se bésu bátee, bésinkli bésu bátɛyi bafɛfɛ. Tsyaa, mbamǝ mámfo mǝ bánɔ. ");
INSERT INTO lip_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Fɛfɛfɛɛ, Yesu ǝlǝkǝ wǝ ǝsuǝ óte wǝ lefosi bakasebi ɔnwɛ lǝ lefe nǝ bénsi bánlɛ budi. Nyaso únyenki ókpe mǝ lǝ kase mǝ bofokanɔ lǝmbǝ ale, nya betidi ato fefe, se bamfó betidi ba díkǝnyǝ wǝ se ótaka utsyi ɔkɔmǝ úbǝ nkpǝ bofo kanɔ. ");
INSERT INTO lip_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ɔ́tɛyi mǝ nkǝ, “Bisu kawunsiǝ kenke lǝ bebe Onanto eto Ditiki Sɛɛ nǝmǝ ditsya bitǝ betidi ba kenke. ");
INSERT INTO lip_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Utidi wǝ lefo Ditiki Sɛɛ nǝmfo ɔnɔ nya utǝ bǝǝflǝsǝ wǝ ntuu, Onanto ebufi wǝ abua ɔtsyǝ wǝ. Nya utidi wǝ dimamfo ɔnɔɔ, Onanto embofo wǝ. ");
INSERT INTO lip_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Nya Onanto ebutǝ bafokanɔfɔ lǝ mɛɛ, ǝsuǝale beyifo ayanisa kpǝ. Boola awɔnɔ bua lǝ mɔ diye ǝsuǝ. Bɔɔtɛyi belebele kpǝ bia benyi. ");
INSERT INTO lip_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Nya lǝ bǝmuǝ owa nye bǝnǝ kenii, yembuyifo mǝ kabua saa. Lǝ bǝtǝkǝ befimfi anii, boomuǝ ale.” ");
INSERT INTO lip_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Lefe nǝ Bonamute Yesu dídi mǝ etiki ólosǝ mfó eto kamaa, Onanto étsyi wǝ úsuko kato kaka wuunsi lǝ kakplɛkɔ lǝ wǝ Anto ɔflɔ lǝ kodiani. ");
INSERT INTO lip_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Nya wǝ batɔnkpe létsyilama nlebe saa kenke bátɛyi Ditiki Sɛɛ nǝmǝ. Nya Onamute ǝmǝ dísiǝ ko mǝ ɔ́wunsǝko mǝ nya béyifo ayanisa nnya lete bǝ mǝ ditiki nǝmǝ eyifo ɔnukualɛ ɛyɛ lǝ ayanisa kpǝ nnya béyifo ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Mɔ ɔyimisani Tiofilo, betidi kpǝ ákplatsya kase boofo, lǝ bawɔni lesa saa nǝ díbǝ lǝ bo nti bǝtsyǝ. ");
INSERT INTO lip_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Báwɔni nnya fe kase betidi ba dínyǝ asa nyamfó lɛtɛyi bo idu lǝ nnya kasɔ ketsyikokɔ nya bábe Onanto eto Ditiki nǝmǝ letsya báte tsya. ");
INSERT INTO lip_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Nyaso, Tiofilo lala, se míndufǝ lǝ asa nyamfo mínto nnya mímbe kenke idu lǝ kasɔ ketsyikokɔ ke esoo, mfi nsusu lǝ nnya ǝsuǝ minkǝ ɛlɛkɛ bǝ nwɔni asa nyamfo lǝ ekpa ɛyɛ lǝ kusu ǝsuǝ mfi ntǝ fǝ. ");
INSERT INTO lip_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Nlɛ nyamfo buyifo nko bǝ lǝ ǝnyǝ ɔnukualɛ eto ditiki nǝmǝ bǝ lǝ ate asa nnya báte fǝ. ");
INSERT INTO lip_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Lǝ lefe nǝ Herodes lídi seka lǝ Yudea eto kasɔ ǝsuǝǝ, Onanto eto usumunyǝ utsyuǝ wǝ baakpo Sakaria akɛ mfó. Ɔ́bɔ utsyi lǝ besumunyǝ ba lǝǝtǝ kedi eto ditsyukpa nǝ baakpo Abia ǝsuǝ. Sakaria eto usiǝ wǝ baakpo Elisabet tsya ábɔ utsyi lǝ Onanto eto Usumunyǝ wǝ baakpo Aaron éto kafo ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Usǝ ku usiǝ bamfo ǝsiǝ nkpǝ sɛɛ lǝ Onanto eto lelabi ǝsuǝ. Nya béyifo lǝ wǝ afi kenke ǝsuǝ kukunɔ. ");
INSERT INTO lip_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ubi saa mankɛ mǝ, itsyise Elisabet anle. Nya mǝ inuǝ bamǝ tsya ébobe báfe. ");
INSERT INTO lip_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Diyi lɔnii, Sakaria akɛ lǝ Yudafɔ eto Kedikǝtǝkɔ ɔlɛ wǝ Kesumuyifo buyifo itsyise wǝ ditsyukpa ítu. ");
INSERT INTO lip_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Nya lǝ mǝ kesumu eto lekpa ǝsuǝǝ, bákpo básɛ bǝnyǝ bǝ Sakaria ni nwǝ ǝsuǝ ítǝkǝ. Nyaso wǝ ni nwǝ bǝlǝkǝ bǝ usu otonsǝ elufui utǝ Onanto lǝ Kedikǝtǝkɔ eto leba nǝmǝ ǝsuǝ. Mfó nya údufǝ Yudafɔ eto kedikǝtǝkɔ kamǝ. ");
INSERT INTO lip_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Nya lefe nǝ ɔkɛ mfó ɔnlɛ elufui botonsǝǝ, betidi fɛfɛ ǝńyǝ lǝ lekple balɛ ola boto. ");
INSERT INTO lip_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Mfó Onanto eto ɔtɔnkpe utsyuǝ wǝ díńyǝ lǝ kaka ɔnlɛ elufui botonsǝ eto sediani dílǝkǝ ǝsuǝ óte wǝ. ");
INSERT INTO lip_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Se Sakaria dínyǝ wǝǝ, óyakla nya óte sikpi tinti. ");
INSERT INTO lip_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Fɛɛ Onanto eto ɔtɔnkpe emfó átɛyi wǝ nkǝ, “Sakaria, mante sikpi! Onanto ánɔ fǝ olatoto, nya fǝ usiǝ Elisabet ebole ubisaibi utǝ fǝ. Nya fuutǝkǝ wǝ diye fǝnkǝ Yohanes. ");
INSERT INTO lip_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Lǝ wǝ bole ǝsuǝǝ, ebunyǝ disuǝyuǝ tinti. Nko ke tsya betidi kpǝ luunyǝ disuǝyuǝ nɛ. ");
INSERT INTO lip_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Woofiani utidi kplɛ lǝ Bonamute eto ǝnǝmi. Yanle bǝ unǝ ntǝ bo nkpe ale nye ntǝ saa eto okle tsya. Nya idu lǝ wǝ lelefee, Lɛwɔnɔ Kɛnkɛ ebusiǝ ko wǝ. ");
INSERT INTO lip_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Nya ɛyɛ lǝ wǝ ǝsuǝǝ, Israel bebi ebusinkli bǝbǝ mǝ Onamute Onanto ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Wǝ ni nwǝ lɔɔtɔ Bonamute eto bubǝ lǝ ǝsuǝale ku utu bokpe ǝsuǝ fe kase Onanto eto Unyɛlǝkǝtidi Elia dítsyǝ. Nya wuutǝ diyuǝ luubǝ bebi ku antomǝ nti. Nya wuunǝ koto tsyuetsyue okpe lǝ betidi ba ditidi ato ǝsuǝ bǝ lǝ bekefi nsusu sɛɛ bayɛ lǝ kusu ǝsuǝ lǝ mǝ asayifoyifo ǝsuǝ. Nyamfo luutǝ Bonamute eto betidi lǝ bǝsiǝ bakabe kusu itǝ wǝ bubǝ.” ");
INSERT INTO lip_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Mfó nya Sakaria lɛtɔ ɔtɔnkpe ǝmfó nkǝ, “Be luutǝ bǝ mfo nyamfo nnɔ? Itsyise mbobe mfiani uninǝsǝ nya mɔ usiǝ tsya díkafiani uninǝsiǝ.” ");
INSERT INTO lip_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Lǝ nnya ǝsuǝ ɔtɔnkpe ǝmǝ ǝtǝ mbuayɛ nkǝ, “Mɔ ni Gabriel wǝ lǝǝńyǝ lǝ Onanto eto ǝnǝmi. Wǝ létsyese mɛ nkǝ ntɛyi fǝ Ditiki Sɛɛ nǝmfo. ");
INSERT INTO lip_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Fɛɛ ámamfo mɔ kɛnyɛ eto dikiti nǝmfo ánɔ. Ite bǝ ámamfo anɔ tsyaa, yuubǝ itǝ lǝ lefe nǝ Onanto dítsyue útsyǝ ǝsuǝ. Se fámamfo ánɔ eso ebofiani ɔmumu isu ese lefe nǝ diyi nǝmǝ léyo fɛ fǝ odiakami looyankli edi etiki.” ");
INSERT INTO lip_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Lǝ lefe nǝ asa nyamfo kenke díbǝǝ, íyifo betidi ba kenke díńyǝ bensekǝ Sakaria lǝ lekple mfó yanii, itsyise bánte lesa nǝ eso éfo wǝ lefe kpǝ nko lǝ Yudafɔ eto kedikǝtǝkɔ kamǝ nko. ");
INSERT INTO lip_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Se ɔ́bɔ úbǝ lekplee, wénsifo mǝ etiki budinko. Nyaso bǝnyǝ bǝ únyǝ bulǝkǝkate butsyuǝ lǝ Yudafɔ eto kedikǝtǝkɔ mfó. Nyaso ɔ́nnlɛ etiki bofo budi nɛ, ini ani ete úfi ɔ́nlɛ mǝ etiki budi. ");
INSERT INTO lip_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Se Sakaria eto kesumu eto lefe léloo, úsinkli úsu diyo. ");
INSERT INTO lip_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Nyamfó eto kamaa, Elisabet ésu ɔ́lɛ kafo, itǝ eso wénsikabɔ kesu umǝ bio. Nya ɔ́kula ǝsuǝ itǝ afa anɔ sɔ̃ɔ̃. ");
INSERT INTO lip_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Lǝ nnya eso Elisabet átɛyi nkǝ, “Mɔmɔɔ, be asa nnya Bonamute díyifo útǝ mɛɛ, nya úlǝkǝ kofani lǝ mɛ ǝsuǝ lǝ betidi ba kenke eto ǝnǝmi.” ");
INSERT INTO lip_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Lǝ Elisabet eto kafolɛlɛ eto kofa kuande ǝsuǝǝ, Onanto átsyese wǝ ɔtɔnkpe Gabriel nkǝ usu umǝ wǝ baakpo Nasaret lǝ Galilea eto kasɔ. ");
INSERT INTO lip_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Onanto eto Ɔtɔnkpe ǝmfo étsyi kɛnyɛ úsuko kebitɛ ka bátɔ bǝtǝ osani wǝ baakpo Yosef wǝ ditsyi Oka David eto kafo. Kebitɛ kamǝ eto diye ni Maria. ");
INSERT INTO lip_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Onanto eto Ɔtɔnkpe ǝmfo ǝbǝ Maria ɔflɔ nya ɔ́tɛyi wǝ nkǝ, “Nsiǝsǝ fǝ lǝ diyuǝ ǝsuǝ! Fǝǝ bǝnǝ kafo! Bonamute si ko fǝ.” ");
INSERT INTO lip_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ɔtɔnkpe ǝmfo eto kɛnyɛ ka óboko éyifo Maria yanii, nya itǝ wǝ disibubu lǝ kǝsiǝ kamǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Lǝ nnya ǝsuǝ ɔtɔnkpe ǝmǝ átɛyi wǝ nkǝ, “Maria, mante sikpi. Onanto ǝnǝ fǝ kafo tinti. ");
INSERT INTO lip_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ebɔlɛ kafo nya foole ubisaibi, nya fuutǝkǝ wǝ diye fǝ Yesu. ");
INSERT INTO lip_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Woofo diye tinti nya bookpo wǝ bǝ Onanto wǝ ni Ǝsuǝalenyǝ Kenke eto ubi. Nya Boanto Onanto luutǝ nkǝ ubi ǝmǝ di seka fe wǝ ona Oka David ke. ");
INSERT INTO lip_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Nya wuudi seka lǝ Yakob eto kafo eto bebi ǝsuǝ isu manlo manlo. Nya wǝ sekakedikɔ embolo kulefe kulefe.” ");
INSERT INTO lip_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Lǝ nnya ǝsuǝǝ, Maria átɔ Ɔtɔnkpe ǝmǝ nkǝ, “Ntsyǝ nyamfo loofo bubǝ kǝtǝ, se minyi osani?” ");
INSERT INTO lip_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Onanto eto ɔtɔnkpe ǝmǝ ǝtǝ mbuayɛ nkǝ, “Lɛwɔnɔ Kɛnkɛ ebɔyifǝ disiǝ lǝ fǝ nya Ǝsuǝalenyǝ Kenke eto ǝsuǝale loola disiǝ lǝ fǝ. Nyaso ubi wǝ foole ebuyifo Ɔkɛnkɛnyǝ nya bookpo wǝ bǝ Onanto eto Ubisaibi. ");
INSERT INTO lip_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Mɔmɔɔ, nla miǝ lǝ ate fǝ, fǝ otokpenyǝ wǝ baakpo Elisabet wǝ ni uninǝsiǝ wǝ baakpo okonɔ, fe ɔ́lɛ kafo kofa kuande nɛ. ");
INSERT INTO lip_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Itsyise kulesa ǝmbǝ ale itǝ Onanto eto buyifo.” ");
INSERT INTO lip_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Nya Maria lɛtɛyi wǝ nkǝ, “Bee, Boanto Onanto eto uyifoyifo mini. Utǝ ibǝ itǝ mɛ lǝ ǝsuǝ fe kase fátɛyi.” Lǝ nnya ǝsuǝ nya Onanto eto ɔtɔnkpe ǝmǝ dídu. ");
INSERT INTO lip_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Lǝ lefe nǝmǝ ǝsuǝǝ, Maria ǝmuǝ ǝsuǝ mlǝmlǝmlǝ nya ɔ́kɔse úsu Yudea eto umǝ wǝ nkpe lǝ atini nti. Usu Sakaria eto diyo nya úsiǝsǝ Elisabet. ");
INSERT INTO lip_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Se Elisabet lɛnɔ Maria eto kǝsiǝ kamǝǝ, ubi wǝ lɛkɛ wǝ lǝ kafo ko lɛkpɔ, nya Elisabet díyi ku Lɛwɔnɔ Kɛnkɛ kenke. ");
INSERT INTO lip_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Mfó nya óbesǝ ɔkɔɛ kato ɔ́tɛyi nkǝ, “Bákpo fǝ atsyɔ lǝ besio kenke nti, nya bákpo ubi wǝ fǝǝbǝ bole tsya atsyɔ! ");
INSERT INTO lip_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Fɛɛ ntsyǝ minyǝ disi ɛkpɛ mmǝ bǝ mɔ Onamute eto ambe lǝ ubǝ mɔ ɔflɔ? ");
INSERT INTO lip_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Akpa akpa se mínɔ fǝ kǝsiǝǝ, ubi wǝ nkpe mɛ lǝ kafo ábe ósa ku disuǝyuǝ. ");
INSERT INTO lip_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Disuǝyuǝ itǝ fǝ sitinti, itsyise áfo kɛnyɛ ka Bonamute létsyese fǝ ánɔ bǝ yuubǝ itǝ nko.” ");
INSERT INTO lip_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Lǝ nnya ǝsuǝǝ, nya Maria lɛtɛyi nkǝ, “Mɔ okla lɛ mɔ Onamute bɔtɛsǝ. ");
INSERT INTO lip_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Nya mɔ lɛwɔnɔ nlɛ disuǝyuǝ bunyǝ lǝ fǝ Onanto wǝ ni mɔ Ofomfokǝtǝ ǝsuǝ, ");
INSERT INTO lip_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","itsyise ókloma únǝ mɛ kafo, mɔ, wǝ uyifoyifo wǝ dimanle kulesa. Nya idu mɔmɔ ɛntɔɔ, kawunsiǝ eto betidi kenke ebokpo mɛ bǝ nwǝ bákpo atsyɔ. ");
INSERT INTO lip_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Itsyise Ǝsuǝalenyǝ Kenke éyifo asa kplɛ útǝ mɛ, nya wǝ diye eyifo kɛnkɛ. ");
INSERT INTO lip_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Wǝ kaminsǝnyǝnyǝ kpe lefe saa itǝ wǝ bebi eto bebi ba kenke lǝǝtǝ wǝ dibu. ");
INSERT INTO lip_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Wǝ kɔni éyifo asa kplɛ, nya úsensǝ mba laabesǝ ǝsuǝ kato lǝ mǝ nsusu ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Óbokosǝ baka kplɛ kasɔ lǝ mǝ akankpomɛ ǝsuǝ, nya óbesǝ mba laabokosǝ mǝ ǝsuǝ kasɔɔ, kato. ");
INSERT INTO lip_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Útǝ nkǝ betidi ba kukpɛnsɛ nlɛ kenke lǝ bǝnyǝ asa sɛɛ bedi bemi tɔ, nya óla batabinyǝ ótsyese ani fufu. ");
INSERT INTO lip_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ókloma kɛnyɛ ka útsyǝ útǝ bó bana eto bana, nya úbǝ ɔnlɛ Israel eto kuse eto betidi kenke bɔwunsǝko. ");
INSERT INTO lip_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ókloma ɔlɛ kaminsǝnyǝnyǝ bufi kǝtǝ Abraham ku wǝ bebi eto bebi isu manlo manlo!” ");
INSERT INTO lip_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria ákɛ lǝ Elisabet ɔflɔ fenkǝ afa ǝtsyǝ fɛ úsinkli úsu oto. ");
INSERT INTO lip_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Se Elisabet eto ubi eto lelefe léyoo, óle ubisaibi. ");
INSERT INTO lip_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Nya Elisabet eto bayotsya ku wǝ batokpenyǝ lɛnɔ asa sɛɛ nnya Bonamute ǝmǝ díyifo útǝ wǝ. Nya mǝmblɛ dínyǝnko wǝ disuǝyuǝ tinti. ");
INSERT INTO lip_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Se ubi ǝmǝ léfo eyi mflamflaa, bǝbǝ bǝnkǝ baala wǝ lelo nya bála bǝ lǝ befi wǝ anto eto diye Sakaria bǝtǝkǝ wǝ. ");
INSERT INTO lip_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Fɛɛ wǝ ambe mántɔnɔko mǝ nko nya ɔ́tɛyi mǝ nkǝ, “Kpa o-o! Bifi diye Yohanes bitǝkǝ wǝ.” ");
INSERT INTO lip_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Mfó bétsyiko etiki bunǝ ku wǝ katɛyi bǝnkǝ, “Fǝ otokpenyǝ saa ǝmbǝ baakpo nko.” ");
INSERT INTO lip_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Nya bátɔ wǝ anto lǝ ani eto eyifosa ǝsuǝ bǝ ote diye nǝ woala nkǝ bǝfi bǝtǝkǝ wǝ ubi ǝmǝ. ");
INSERT INTO lip_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Mfó nya Sakaria léfo leba nǝ ǝsuǝ baawɔni asa kǝtǝkǝ nya ɔ́wɔni nkǝ, “Wǝ diye ni Yohanes.” Nya íyifo mǝmblɛ yanii. ");
INSERT INTO lip_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Lamfolamfo Sakaria étsyiko etiki budi nya ɔ́tɛsǝ Onanto. ");
INSERT INTO lip_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Sikpi ǝmuǝ mba wonko mǝ nsi lǝ koyotsya nya ítǝ ditiki nǝmfo dísensǝ dísu kǝmǝ kpǝ lǝ Yudea eto atini ǝsuǝ mfó kenke. ");
INSERT INTO lip_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Betidi ba kenke lɛnɔ asa nyamfo etsyiko disi bubu katɔ mǝ ǝsuǝ bǝnkǝ, “Nte utidi wǝ eto okle ubi ǝmfo luubǝ ofiani?” Itsyise ílǝkǝ ete wuee bǝ, Bonamute eto kɔni tǝkǝ lǝ wǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Mfó nya Lɛwɔnɔ Kɛnkɛ lɛyifǝ dísiǝ lǝ ubi ǝmǝ eto anto Sakaria ǝsuǝ nya údi Onanto etiki ɔ́tɛyi utsyǝ nkǝ, ");
INSERT INTO lip_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Atɛsǝ itǝ Bonamute, Israel eto Onanto, itsyise úbǝ nkǝ woawunsǝko wǝ kuse nya lǝ ulǝkǝ mǝ. ");
INSERT INTO lip_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Úlǝkǝ Ofomfokǝtǝ Kplɛ útǝ bo lǝ Oka David wǝǝ ni wǝ eto uyifoyifo eto kafo eto ubi. ");
INSERT INTO lip_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Útsyǝ kɛnyɛ kamfó kokooko ɛyɛ lǝ wǝ bǝnyɛlǝkǝtidi kɛnkɛ ǝsuǝ nkǝ, ");
INSERT INTO lip_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","wuulǝkǝ bo utsyiko lǝ balo ku mba leekisi bo kenke eto ani. ");
INSERT INTO lip_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ɔ́tɛyi útsyǝ nkǝ wuunyǝ bo banamǝ kaminsǝ nya wookloma kɛnyɛ ka ókle ku mǝ. ");
INSERT INTO lip_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Nya ɔ́tɛyi bo anto Abraham kɛnyɛ klekle kamfo utsyǝ nkǝ, ");
INSERT INTO lip_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","wuulǝkǝ bo utsyiko lǝ bo balo eto ani, nya wookpe bo ǝsuǝale busumu wǝ sikpi manté manté. ");
INSERT INTO lip_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Nya wuuyifo bo kɛnkɛ bǝ lǝ buyifo mba nyɛ lǝ kusu sɛɛ ǝsuǝ lǝ wǝ ǝnǝmi lǝ bo nkpǝ kenke ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Nya fǝ, mɔ ubi, bookpo fǝ bǝnkǝ Onanto wǝ nso kenke eto Unyɛlǝkǝtidi. Ɛbɔtɔ̃ Onamute ǝmǝ eto bubǝ nya fɔɔlɔ kusu ǝtsyǝ itǝ wǝ. ");
INSERT INTO lip_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Nya ebutǝ wǝ betidi te bǝ boonyǝ bofokǝtǝ itsyise boofi mǝ abua batsyɛ mǝ. ");
INSERT INTO lip_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Bo Onanto kpe lefonǝ nya woabe bo ku kaminsǝnyǝnyǝ. Wuutǝ bofokǝtǝ eto diyǝnde bǝ itǝ bo itsyi kato. ");
INSERT INTO lip_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Nya wuutǝ diyǝnde nǝmfo nkǝ dibǝ ditǝ lekpasǝ itǝ mba nkpe lǝ ketuntu ǝsuǝ ku mba nkpe lǝ ukpǝ eto sikpitete ǝsuǝ bǝ lǝ okpa bo ɔyɛnko udufǝnko diyuǝ eto kusu ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Nya ubi ǝmǝ lébe nya ɔkɛ ale lǝ ǝsuǝ ku lɛwɔnɔ ǝsuǝ. Nya úsiǝ lǝ mfiminti isu ese lefe nǝ ɔ́bɔ úbǝ Israel eto kuse eto ǝnǝmi. ");
INSERT INTO lip_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Nya lǝ lefe nǝmfoo, Romamfɔ eto Okankplɛ Kaisare Augusto ǝtǝ ǝsuǝale nkǝ bawɔni betidi ba kenke nkpe lǝ Roma eto sekakedikɔ eto kasɔ eto aye. ");
INSERT INTO lip_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Nya ni betidi eto aye wɔniwɔni tutɛ nɛ, lǝ Aba eto uninǝ wǝ baakpo Kirenio eto Sekadidi lǝ Siria eto kasɔ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Nyaso utidi saa ésu wǝ umǝ lǝ usu ɔwɔni wǝ diye. ");
INSERT INTO lip_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Lefe nǝmfo nya Yosef tsya létaka útsyi Nasaret eto umǝ lǝ Galilea eto kasɔ úsu Betlehem eto umǝ lǝ Yudea eto kasɔ lǝ kaka bále Oka David. Yosef ésu mfó itsyise uyifo Oka David eto kafo eto ubi. ");
INSERT INTO lip_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ókpa Maria wǝ bátɔ bǝtǝ wǝ nya ɔnlɛ kafo tsya ɔ́yɛnko nkǝ lǝ ɔwɔni wǝ diye. ");
INSERT INTO lip_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Nya lefe nǝ bakɛ lǝ Betlehem mfóo, lefe áyo Maria bǝ ole. ");
INSERT INTO lip_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Óle wǝ ubi tutɛ wǝ ni osaibi lǝ diyo nǝ bebuki laalabe. Nya úfi kafia úmini wǝ, nya úfi wǝ ólabesǝ lǝ lesa nǝ ǝsuǝ bebuki bamfó leedi lesa, itsyise kasɔnɔkɔ mánkɛ lǝ bafɔ eto kedufǝkɔ. ");
INSERT INTO lip_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Lǝ kasɔ kamǝ ǝsuǝ mfóo, mba laabe basamu bǝtsyuǝ akɛ mfo kabe mǝ bebuki ketsye ka kenke. ");
INSERT INTO lip_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Onanto eto ɔtɔnkpe utsyuǝ ǝlǝkǝ ǝsuǝ óte mǝ nya Onanto ǝmǝ eto diyǝnde ǝyǝnde ekpo mǝ lǝ ǝsuǝ. Lǝ nyamfo eso bate sikpi tinti! ");
INSERT INTO lip_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Fɛɛ Onanto eto ɔtɔnkpe ǝmǝ átɛyi mǝ nkǝ, “Biante sikpi. Mboko mi Ditiki Sɛɛ nǝ looboko disuǝyuǝ ku diyuǝ tinti itǝ betidi ba kenke. ");
INSERT INTO lip_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Nya lǝ mmi eto diyi nǝmfoo, bále Ofomfokǝtǝ wǝ ni Bonamute Kristo bǝtǝ mi lǝ Oka David eto umǝ. ");
INSERT INTO lip_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Nya lesa nǝ biufi binyǝ bitsyǝ lekpoo, ni bǝ biunyǝ ubisambi wǝ béfi kafia bémli nya onlabe lǝ bebuki eto kedikɔ.” ");
INSERT INTO lip_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Lefe nǝmfo tutuutu, Onanto eto batɔnkpe eto ditsyukpa kplɛ lɔni étsyi kato díbǝ bǝlǝkǝ ǝsuǝ báte, nya bákɔ ku ɔtɔnkpe ɔni ǝmfó nya banlɛ Onanto bɔtɛsǝ katɛyi bǝnkǝ, ");
INSERT INTO lip_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Dibu ku atɛsǝ itǝ Onanto wǝ nkpe kato fanlofanlo, nya diyuǝsǝ itǝ kasɔ eto betidi ba kenke lǝǝdufǝ Onanto ǝnǝ!” ");
INSERT INTO lip_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Nya lǝ lefe nǝ Onanto eto batɔnkpe bamfo dídu lǝ mǝ ɔflɔ bésinkli bésu katoo, mba laabe basamu bamǝ átɛyi mǝ ǝsuǝ bǝnkǝ, “Bitǝ lǝ busu Betlehem lǝ busu bobe asa nnya díbǝ fe kase Boanto dílǝkǝ óte bo.” ");
INSERT INTO lip_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Nyaso bákɔse bésu nya bǝnyǝ Maria ku Yosef ku ubisambi wǝ nlabe lǝ bebuki eto kedikɔ mfó. ");
INSERT INTO lip_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nya se bǝnyǝ wǝ nkoo, bátɛyi lesa saa nǝ Onanto eto ɔtɔnkpe ǝmǝ lɛtɛyi mǝ itsyi lǝ ubi ǝmǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Lefe nǝmfo se betidi ba kenke lɛnɔ mba laabe basamu bamǝ eto etiki nyamfoo, íyifo mǝ yani tinti. ");
INSERT INTO lip_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maria ákloma asa nyamfo kenke nya úkebu disi ketsyi lǝ nnya ǝsuǝ ɛyɛ etsyo. ");
INSERT INTO lip_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Lefe nǝmfóo, se mba laabe basamu bamǝ dísinklii, bátɛsǝ Onanto lǝ lesa saa nǝ bánɔ ku bǝnyǝ tsya ǝsuǝ, itsyise nyamblɛ kenke ǝbǝ itǝ pɛpɛɛpɛ fe kase Onanto eto ɔtɔnkpe ǝmǝ lɛtɛyi mǝ. ");
INSERT INTO lip_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Nya lǝ diyi mflamflale ǝsuǝ, se lefe léyo bǝ bala ubi ǝmǝ leloo, bǝtǝkǝ wǝ diye bǝnkǝ Yesu fe kase Onanto eto Ɔtɔnkpe ǝmǝ lɛtɛyi utsyǝ fɛ bálɛ wǝ kafo. ");
INSERT INTO lip_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Lefe áyo itǝ bǝ Yosef ku Maria yifo ǝsuǝ eto okla buflǝ eto lekpa fe kase Moses eto kɔfi lɛtɔ. Nyaso bákpa ubisambi ǝmǝ tsya bésuko Yerusalem bǝ lǝ befi wǝ bakpe Bonamute lǝ ani. ");
INSERT INTO lip_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Nko ini báwɔni bǝtsyǝ lǝ Onanto eto kɔfi eto kukue ǝsuǝ bǝnkǝ, “Ubisaibi tutɛ ku ubuki sende tutɛ saa, ele bǝ bǝlǝkǝ wǝ bǝtsyǝ kutsyǝ befi bakpe Bonamute lǝ ani.” ");
INSERT INTO lip_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Nyaso bésu Yerusalem bǝ lǝ befi kedi bǝtǝ Bonamute lǝ kase kɔfi lɛtɔ ǝsuǝǝ, ablonima ǝnuǝ nye ablɛkpa ǝnuǝ beefi kǝtǝ kedi kamǝ. ");
INSERT INTO lip_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Nya lǝ lefe nǝmfoo, osani utsyuǝ wǝ baakpo Simeon ákɛ lǝ Yerusalem. Nya úyifo utidi sɛɛ wǝ laate Onanto sikpi nya uńyǝ ɔnlɛ kusu bobe itǝ Israel eto bulǝkǝ. Nya Lɛwɔnɔ Kɛnkɛ dísiǝko wǝ, ");
INSERT INTO lip_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","nya lése wǝ uyi nkǝ weembukpǝ isu ese lefe nǝ eto lefe uunyǝ Onanto eto Nwǝ Bákpo Ɔhile Bǝtsyǝ, wǝ eto etiki Onanto lɛtɛyi utsyǝ. ");
INSERT INTO lip_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Lefe nǝmfoo, Lɛwɔnɔ Kɛnkɛ nǝmǝ ákpa Simeon úsuko Yudafɔ eto Disumuyo mfó. Nya se anto ku ambe bamǝ lékpa ubisambi Yesu ǝmǝ bésukoo, bátɛyi bǝ bǝbǝ bǝ beyifo lesa saa nǝ ele bǝ beyifo bǝtǝ wǝ fe kase kɔfi létee, ");
INSERT INTO lip_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeon áfo ubisambi ǝmǝ ɔ́lɛ lǝ wǝ ani, nya ɔ́tɛsǝ Onanto ɔ́tɛyi nkǝ, ");
INSERT INTO lip_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Boanto Onanto, mɔmɔɔ, se fékeyifo lǝ fǝ kɛnyɛtsyǝtsyǝ ǝsuǝ esoo, ebofo mɛ kusu bulǝkǝ, mɔ fǝ usumunyǝ, bǝ lǝ nsu lǝ diyuǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Mɔ kosate ébufi mɔ ǝnǝmi nnyǝ Ofomfokǝtǝ ǝmǝ ");
INSERT INTO lip_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","fǝtǝ fǝ ubǝ lǝ kusǝ komǝ eto betidi kenke lǝ bǝnyǝ wǝ ku dinǝmi. ");
INSERT INTO lip_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Wǝ ni diyǝnde nǝ luulǝkǝ lesa nǝ faala lǝ lekple lete betidi ba lenni Yudafɔ. Nya wuufi dibu oboko fǝ kusǝ Israel eto betidi eto nti.” ");
INSERT INTO lip_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Asa nnya Simeon lɛtɛyi mfo éyifo Yosef ku Maria yanii. ");
INSERT INTO lip_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Nya Simeon lékpo mǝ atsyɔ nya ɔ́tɛyi ubi ǝmǝ eto ambe Maria nkǝ, “Ubi ǝmfo eyifo Nwǝ Onanto Lékpo Ɔhile Utsyǝ. Nya wǝ ni Ofomfokǝtǝ nye budukanɔ itǝ Israel bebi kpǝ. Uyifo lekpotsyǝtsyǝ itsyi lǝ Onanto ɔflɔ, nya betidi kpǝ lootaka bǝnyǝ lǝ wǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Nya wuutǝ nkǝ betidi kpǝ lǝkǝ mǝ nsusu bo bakula bate utsyuǝ saa nyǝ. Nya ɛyɛ lǝ nyamfo ǝsuǝ esoo, ebunyǝ kanyi fe kase lesiabi laase utidi eto utu kedunsǝ.” ");
INSERT INTO lip_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Mfó ǝmǝǝ, usio ɔni utsyuǝ wǝ ni Onanto eto Unyɛlǝkǝtidi ákɛ mfo baakpo bǝ Hana. Nya wǝ anto Fanuel étsyi Aser eto kafo. Alɛ akuanse hã úsiǝ ku wǝ usǝ fɛ usǝ ǝmǝ díkpǝ. Nya úyifo ɔkɔsiǝ wǝ lébe bembembe. Ófo alɛ fosi mflamfla alɛ ana. Úkesu Yudafɔ eto Disumuyo mfo lefe saa, ákatɛsǝ Onanto ketsye ku kakɔmi nya úkato ola kákle kɛnyɛ tsya. ");
INSERT INTO lip_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Lǝ lefe nǝmfó tutuutuu, wuntsya ǝbǝ ɔ́sɔ Onanto ani, nya ɔ́tɛyi itsyi lǝ ubi ǝmǝ ǝsuǝ útǝ betidi ba kenke ńyǝ banlɛ Onanto kusu bobe bǝ wuulǝkǝ Yerusalem. ");
INSERT INTO lip_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Nya se Yosef ku Maria lélosǝ mǝ lekpa nǝmǝ buyifo fe kase Onanto eto kɔfi letee, bésinkli bésu mǝ umǝ Nasaret lǝ Galilea eto kasɔ. ");
INSERT INTO lip_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ubi ǝmǝ ábe ɔ́bɔ disi nya ɔ́kɛ ǝsuǝale, nya óte kobe tinti. Nya Onanto dínyǝ disuǝyuǝ lǝ wǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Lɛlɛ saa lɛlɛɛ, Yesu eto anto ku ambǝ ékesu Yerusalem késu kédi diyi nǝ baakpo Ukpǝ Ása Bo Ɔ́yila. ");
INSERT INTO lip_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Nyaso se Yesu léfo lefosi alɛ ǝnuǝǝ, bési bésu Yerusalem fe kase békeyifo kɔ seka. ");
INSERT INTO lip_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Nya se bédi diyi nǝmǝ bálosǝ nya banlɛ businkli kesu mǝ umǝǝ, Yesu wǝ esi ɔ́kɛ kama lǝ Yerusalem mfó. Fɛɛ wǝ anto ku ambe mánte nko. ");
INSERT INTO lip_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Mǝ ébu bǝnkǝ ɔkɛ lǝ betidi bamǝ nti nyaso bédu báyɛ diyi wɔlɔlɔlɔ eto kusu fɛ bétsyiko wǝ bɔbɛbɛ lǝ bahɔ ku batokpenyǝ nti. ");
INSERT INTO lip_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Nya se bǝnnyǝ wǝ esoo, bésinkli bésu Yerusalem bésu balɛ wǝ bɔbɛbɛ. ");
INSERT INTO lip_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Nya lǝ diyi tsyǝfǝǝ, bésu bǝnyǝ wǝ lǝ Yudafɔ eto Disumuyo kaka wǝ ku Yudafɔ eto bateasa nsi. Mfó úsiǝ ɔnlɛ mǝ asa nnya bánlɛ bɔtɛyi ato butsyue nya ɔnlɛ mǝ etiki bɔtɔ lɔni lɔni kanɔ. ");
INSERT INTO lip_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Nya mba lɛnɔ asa nnya díkabɔ lǝ wǝ kɛnyɛɛ, íyifo mǝ yanii lǝ wǝ asa kasɔnɔnɔ kpǝ ku kase úfi ɔnlɛ asa nnya bátɔ wǝ kasɔ bulǝkǝ eso. ");
INSERT INTO lip_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Íyifo wǝ anto ku ambǝ mǝ yanii se bǝnyǝ wǝ lǝ mfo nko. Nya wǝ ambe lɛtɔ wǝ nkǝ, “Ubi, ntsyǝso féyifo bo nyamfo eto okle? Mɔ ku fǝ nto kenke ákɛ lǝ bulǝ ǝsuǝ nya búsu bɔnlɛ botsyilama kabɛbɛ fǝ.” ");
INSERT INTO lip_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Mfo nya Yesu dítǝ mbuayɛ ɔ́tɔ nkǝ, “Beso ibǝ bǝ bísu bɛlɛ botsyilama kabɛbɛ mɛ? Binyi biǝ mɔ Anto eto diyo ele bǝ nkɛ lee?” ");
INSERT INTO lip_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Fɛɛ mǝǝ, bánnɔ lesa nǝ ɔ́tɛyi mǝ mfó eto kasɔ. ");
INSERT INTO lip_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Mfó nya Yesu dítǝkǝko mǝ nya bédu bésu Nasaret, nya óbokosǝ ǝsuǝ kasɔ útǝ mǝ. Nya asa nyamfo kenke lɛkɛ lǝ wǝ ambe eto nsusu kǝmiǝ ɛɛyɛ etsyo. ");
INSERT INTO lip_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Nya Yesu lebe ɔ́bɔ disi lǝ kobetete ku lǝ ǝsuǝ eto sinǝ ǝsuǝ, nya ófo diye lǝ betidi kenke ku lǝ Onanto eto ǝnǝmi. ");
INSERT INTO lip_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Íyifo lɛlɛ lefosi nɔnde se Okankplɛ Kaisare Tiberio lídi seka, Unyɛlǝkǝtidi Yohanes wǝ ni Sakaria eto ubi wǝ léfo kɛnyɛ utsyiko Onanto ɔflɔ lǝ lefe nǝ ɔ́kɛ lǝ mfiminti. Nya Pontio Pilato lídi Aba eto unyɛsiǝ lǝ Yudea eto kasɔ ǝsuǝ. Nya Herodes díkedi seka lǝ Galilea eto kasɔ. Nya lǝ lefe nǝmǝ mfóo, Herodes eto ɔyimisani Filipo tsya lídi seka lǝ kasɔ ka baakpo Iturea ku Trakoniti eto lekpake ǝsuǝ. Nya Lisania tsya díkedi seka lǝ Abilene eto kasɔ ǝsuǝ. Nya lǝ lefe nǝmfoo, Annas ku Kayafa ni Onanto eto Besumunyǝ Ninǝ Kenke. ");
INSERT INTO lip_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Nyaso Yohanes áyɛ ótsyilama Yordan eto Ketu eto ditukpenkpe ku lekpake mfó kédi Anantotiki kátɛyi nkǝ, “Bitsyi bɛwuninsǝ lǝ mi abua ǝsuǝ lǝ befo ntuflǝsǝflǝsǝ eto lekpa lǝ Onanto lǝ ufi mi abua ɔtsyɛ mi.” ");
INSERT INTO lip_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Nya nko seka ini báwɔni lǝ Onanto eto Unyɛlǝkǝtidi Yesaya eto kukue banlɛ bɔtɛyi bǝnkǝ, “Utidi utsyuǝ kpe lǝ mfiminti ɔlɛ bofa katɛyi nkǝ, ‘Bińyǝ bikabe kusu itǝ Bonamute. Bimuǝ mi ǝsuǝ bitsyǝ kukɔnɔ itǝ wǝ bubǝ. ");
INSERT INTO lip_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Biti okplo saa okplo nya beba atini ku akpenkpe kenke bekatesǝ. Lǝ bɛtsyɔnsǝ esu nya lebo. Nya nlebe bo diyifo kplobi kplobii, biyifo mu tsyɛtsyɛtsyɛ. ");
INSERT INTO lip_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Nya betidi kenke luunyǝ Ofomfokǝtǝ wǝ Onanto letsyese nɛ!’ ” ");
INSERT INTO lip_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Betidi kpǝ ǝbǝ bǝ Yohanes flǝsǝ mǝ ntu. Fɛɛ Yohanes átɛyi mǝ nkǝ, “Mi mba nte fe bawa eto befluflu! Owoe lɛlɛ mi kɔlɛ nkǝ bitsyetsyi lǝ Onanto eto kotonǝnǝ ko nlɛ bubǝ eto kɛnyɛ? ");
INSERT INTO lip_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Bete lǝ mi eyifosa ǝsuǝ biǝnkǝ bɛtsyi bɛwuninsǝ lǝ mi abua ǝsuǝ. Nya biembu biǝ se ini Abraham eto befluflu bini esoo, Onanto embunǝ mi koto. Bɛlɔ bɛnɔ biǝ Onanto ebofo befluflu bulǝkǝ ketsyiko aba nyamfo ǝsuǝ kǝtǝ Abraham. ");
INSERT INTO lip_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Bebe se banlɛ kefiebi bǝńyǝ bǝ baala eyi nyamǝ taa keyudu ke. Kuyi saa ko laanwɔ ebibi sɛɛ, boola ko befi bakpe lǝ ditefɛnku kǝmiǝ.” ");
INSERT INTO lip_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Nyaso betidi bamǝ átɔ wǝ bǝnkǝ, “Nyalɛɛ, be ele bǝ buyifo mɔmɔ?” ");
INSERT INTO lip_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Mfó nya útǝ mǝ mbuayɛ nkǝ, “Mi utsyuǝ wǝ nkpe awu leyo lekpe sinuǝǝ, ufi lekpe lɔni utǝ utidi wǝ lǝmbǝ kuǝtsyuǝ. Nya utidi wǝ didisa nte tsyaa, usie ni nko ke.” ");
INSERT INTO lip_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Mba laafo umǝnko bǝtsyuǝ tsya ǝbǝ bǝ bǝflǝsǝ mǝ ntu. Bátɔ wǝ bǝnkǝ, “Oteasa, be ele bǝ buyifo?” ");
INSERT INTO lip_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Mfó nya Yohanes lɛtɛyi mǝ nkǝ, “Biamfo umǝnko besonsǝ kase kɔfi dítǝ mi kusu nkǝ befo.” ");
INSERT INTO lip_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Bamamanyǝ bǝtsyuǝ tsya átɔ wǝ bǝnkǝ, “Nya bo nkpǝ? Be ele bǝ buyifo?” Mfó ɔ́tɛyi mǝ tsya nkǝ, “Bitǝ lǝ mi kayo ka banlɛ mi bofo lǝ kemi mi. Nya lǝ nyamfo eto kamaa, biensu bɛnyinkǝ utidi kuutsyuǝ bekpe lǝ ǝsuǝale lǝ befo wǝ atabi saa, nye bela utidi kuutsyuǝ kɛnyɛ lǝ kusu bua ǝsuǝ belo wǝ dikpi.” ");
INSERT INTO lip_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Betidi bamfo eto kusubebe esi ébe kato ekpe nya békebu bǝ Yohanes nkpa ni Nwǝ Onanto Lékpo Ɔhile Utsyǝ, wǝ bǝńyǝ banlɛ kusu bobe. ");
INSERT INTO lip_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Nyaso Yohanes ákpasǝ mǝmblɛ nkǝ, “Mɔɔ, ntu ete meefi kǝflǝsǝ mi. Fɛɛ utidi utsyuǝ tǝkǝ mɛ kama ɔlɛ bubǝ wǝ lɛmɔ nya onkpe ǝsuǝale onso mɛ famfamfa! Mǝńyǝ tsya kon ntǝ bǝ mbǝ kasɔ miǝ maanyankli wǝ afokpa eto kekue lǝ akpa ǝsuǝ ntǝ wǝ tsya. Nya utidi ǝmfo ebufi Lɛwɔnɔ Kɛnkɛ ku uté uflǝsǝ mi fe ntu. ");
INSERT INTO lip_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ɔlɛ wǝ kɔfɛ ko wuufi ɔflɛ wǝ kamɔ ulǝkǝ kofo uwí nya wookpa kamɔ kosate okpo lǝ unwũ. Fɛɛ kofo saa kofoo, wootonsǝ ko lǝ ute wǝ lɛmbɔni kulefe kulefe.” ");
INSERT INTO lip_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Nya Yohanes lídi betidi Anantotiki lǝ esu kpǝ ǝsuǝ, nya ɔ́lɛ mǝ kɔlɛ nkǝ batsyi mǝ ditsyǝbi ku mǝ nkpǝ bo bensi bawuninsǝ. ");
INSERT INTO lip_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Nya se Oka Herodes wǝ ni Aba eto Unyɛsiǝ lɛlɛ wǝ ɔyimi eto usiǝ wǝ baakpo Herodia ófo lǝ ǝsuǝale ku lǝ asa bua kpǝ nya úyifo esoo, Yohanes ǝnyǝnki okpe wǝ. ");
INSERT INTO lip_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Idu ɛkɔ lǝ nyamfo ǝsuǝǝ, útǝ bǝmuǝ Yohanes béti bákpe lǝ diyo. ");
INSERT INTO lip_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Se Yohanes díflǝsǝ betidi kenke ntu ólosǝǝ, úflǝsǝ Yesu tsya ntu. Nya se Yesu nlɛ ola botoo, kato ásini. ");
INSERT INTO lip_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Lɛwɔnɔ Kɛnkɛ nǝ eto ditsyǝbi nte fe lɛblɛkpaa, áyifǝ díbǝ dísiǝ lǝ wǝ ǝsuǝ. Mfó nya bánɔ Onanto eto ɔkɔɛ wǝ dítsyi kato díkatɛyi nkǝ, “Fǝ ni mɔ Ubi lala. Fǝ asa eedufǝ mɛ ǝnǝ tinti.” ");
INSERT INTO lip_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu áfo fe alɛ fosi ǝtsyǝ fɛ útsyǝ wǝ keyifo kasɔ. Betidi eto nsusu ni bǝ wǝ anto ni Yosef wǝ eto anto ni Eli ");
INSERT INTO lip_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","wǝ eto anto ni Mata wǝ eto anto ni Lewi wǝ eto anto ni Melki wǝ eto anto ni Yanai wǝ eto anto ni Yosef ");
INSERT INTO lip_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","wǝ eto anto ni Matatia wǝ eto anto ni Amos wǝ eto anto ni Nahum wǝ eto anto ni Hesli wǝ eto anto ni Nagai ");
INSERT INTO lip_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","wǝ eto anto ni Mahat wǝ eto anto ni Matatia wǝ eto anto ni Semein wǝ eto anto ni Yosef wǝ eto anto ni Yoda ");
INSERT INTO lip_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","wǝ eto anto ni Yohanan wǝ eto anto ni Resa wǝ eto anto ni Sorobabel wǝ eto anto ni Sealtiel wǝ eto anto ni Neri ");
INSERT INTO lip_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","wǝ eto anto ni Melki wǝ eto anto ni Adi wǝ eto anto ni Kosam wǝ eto anto ni Elmadam wǝ eto anto ni Er. ");
INSERT INTO lip_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","wǝ eto anto ni Yosua wǝ eto anto ni Elieser wǝ eto anto ni Yorim wǝ eto anto ni Matat wǝ eto anto ni Lewi ");
INSERT INTO lip_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","wǝ eto anto ni Simeon wǝ eto anto ni Yuda wǝ eto anto ni Yosef wǝ eto anto ni Yonam wǝ eto anto ni Eliakim ");
INSERT INTO lip_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","wǝ eto anto ni Melea wǝ eto anto ni Mena wǝ eto anto ni Matata wǝ eto anto ni Natan wǝ eto anto ni David ");
INSERT INTO lip_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","wǝ eto anto ni Isai wǝ eto anto ni Obed wǝ eto anto Boas wǝ eto anto ni Salmon wǝ eto anto ni Naheson ");
INSERT INTO lip_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","wǝ eto anto ni Aminadab wǝ eto anto ni Admin wǝ eto anto ni Arni wǝ eto anto ni Hesron wǝ eto anto ni Peres wǝ eto anto ni Yuda ");
INSERT INTO lip_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","wǝ eto anto ni Yakob wǝ eto anto ni Isak wǝ eto anto ni Abraham wǝ eto anto ni Tara wǝ eto anto ni Nahor ");
INSERT INTO lip_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","wǝ eto anto ni Serug wǝ eto anto ni Regu wǝ eto anto ni Peleg wǝ eto anto ni Eber wǝ eto anto ni Sala ");
INSERT INTO lip_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","wǝ eto anto ni Kainan wǝ eto anto ni Arfaksad wǝ eto anto ni Sem wǝ eto anto ni Noah wǝ eto anto ni Lamek ");
INSERT INTO lip_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","wǝ eto anto ni Metusala wǝ eto anto ni Henok wǝ eto anto ni Yared wǝ eto anto ni Mehaleel wǝ eto anto ni Kainan ");
INSERT INTO lip_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","wǝ eto anto ni Enos wǝ eto anto ni Set wǝ eto anto ni Adam wǝ eto anto ni Onanto. ");
INSERT INTO lip_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Se Lɛwɔnɔ Kɛnkɛ dísiǝ lǝ wǝ ǝsuǝǝ, Yesu édu lǝ Yordan eto Ketu mfó. Nya Lɛwɔnɔ nǝmǝ lékpa wǝ dísuko mfiminti kaka kuutsyuǝ lǝmbǝ. ");
INSERT INTO lip_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Mfo nya Obonsam lékplatsya óto wǝ óbe lǝ eyifosi ana sɔ̃ɔ̃ ǝsuǝ. Nya lefe nǝmfó kenke, Yesu méndi kulesa nyaso lǝ kalosǝkɔɔ, kukpɛnsɛ álɛ wǝ. ");
INSERT INTO lip_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Mfó nya Obonsam lɛtɛyi wǝ nkǝ, “Lǝ Onanto eto Ubi fenii, tɛyi lebambi nǝmfo lǝ efiani didisa.” ");
INSERT INTO lip_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Fɛɛ Yesu átɛyi wǝ nkǝ, “Awɔnisa Kɛnkɛ Eto Kukue átɛyi nkǝ, ‘Inni didisa mate lǝǝtǝ utidi nkpǝ.’ ” ");
INSERT INTO lip_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Lǝ nnya kamaa, Obonsam esi ókpa wǝ úsuko kaka letaka fanlofanlo. Nya óte wǝ kawunsiǝ eto asa ku nnya sekakedikɔ kenke lǝ lefe kliminti ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Nya ɔ́tɛyi wǝ nkǝ, “Muufi kawunsiǝ eto ǝsuǝale ku ke setabikɛ ntǝ fǝ, itsyise befi nnya bǝtǝ mɛ, nya moofo nnya bufi kǝtǝ nwǝ ke minla. ");
INSERT INTO lip_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Nyaso asa nyamfo kenke ebofiani fǝ ale lǝ akpe disi kasɔ esumu mɛ.” ");
INSERT INTO lip_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Mfó nya Yesu lɛtɛyi wǝ nkǝ, “Awɔnisa Kɛnkɛ eto Kukue lɛ bɔtɛyi nkǝ, ‘Bonamute Onanto hã ele bǝ utidi fi dibu utǝ, okpe disi kasɔ usumu.’ ” ");
INSERT INTO lip_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Nyamfo eto kamaa, Obonsam ákpa Yesu úsuko Yerusalem lǝ Yudafɔ eto Disumuyo eto kaka nso botaka nya ɔ́tɛyi wǝ nkǝ, “Lǝ Onanto eto ubi fenii, yani fǝ ǝsuǝ ǝbǝ asɔ lǝ kasɔ. ");
INSERT INTO lip_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Itsyise Awɔnisa Kɛnkɛ eto Kukue lɛ bɔtɛyi nkǝ, ‘Onanto ebutǝ nkǝ wǝ batɔnkpe ńyǝ bakase fǝ.’ ");
INSERT INTO lip_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","‘Bɔɔkɔbe fǝ lǝ ani, itǝ bǝ embutusǝ kokpa lǝ leba ǝsuǝ kulaa tsya.’ ” ");
INSERT INTO lip_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Fɛɛ Yesu átɛyi wǝ nkǝ, “Awɔnisa Kɛnkɛ eto Kukue átɛyi nkǝ, ‘Manto fǝ Onamute Onanto abe.’ ” ");
INSERT INTO lip_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Se Obonsam léto Yesu óbe nko ólosǝǝ, údu wǝ lǝ ɔflɔ nya ɔ́yɛ wǝ bulǝ itǝ lefe ditsyuǝ. ");
INSERT INTO lip_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Nya Yesu dísinkli úsu Galilea eto kasɔ nya Lɛwɔnɔ Kɛnkɛ eto ǝsuǝale lɛkɛ wǝ lǝ ǝsuǝ. Nya wǝ diye dísensǝ isu lekpake nǝmfó kenke. ");
INSERT INTO lip_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Óte asa lǝ Yudafɔ eto ntsyakɔ nya utidi saa lɛtɛsǝ wǝ asatete. ");
INSERT INTO lip_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Lǝ nyamfó eto kamaa, Yesu ésu Nasaret eto umǝ wǝ úsiǝ óbe. Nya lǝ Ɔnwɛditsyǝyii, úsu Yudafɔ eto katsyakɔ fe kase woala buyifo. Nya ótaka úńyǝ nkǝ lǝ okla asa lǝ Awɔnisa Kɛnkɛ eto Kukue ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Mfó nya béfi Onanto eto unyɛlǝkǝtidi Yesaya eto kukue bǝtǝ wǝ. Ɔ́sini kukue komǝ nya útsyiko bokla lǝ kaka báwɔni bǝnkǝ, ");
INSERT INTO lip_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Onanto eto Lɛwɔnɔ si mɛ lǝ ǝsuǝ, bédiki mɛ nnuǝbi, itsyise úlǝkǝ mɛ nkǝ mfó Ditiki Sɛɛ nǝmfo mboko bakombo. Nya ótsyese mɛ nkǝ nsu mbe bulǝkǝ eto letsya ntǝ betidi ba bǝmuǝ bakpe lǝ diyo. Nya mba eto ǝnǝmi lébaa, lǝ bǝnyǝ asa. Nya betidi ba báyinkǝ bakpe lǝ kasɔ nlɛ kanyi bunyǝ, lǝ bǝnyǝ bɔbɔkafe. ");
INSERT INTO lip_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Nya lǝ ntǝ lǝ bate bǝ Onanto eto lefe nǝ wuulǝkǝ wǝ betidi eboyo.” ");
INSERT INTO lip_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Nya Yesu díti kukue ko mǝ, nya úsinkli ko útǝ wǝ ɔwunsǝkotsyuǝ nya úsiǝ kasɔ. Betidi bamǝ kenke éfi mǝ ǝnǝmi bǝtǝkǝ lǝ wǝ ǝsuǝ nya bǝńyǝ banlɛ wǝ bobe kpoo. ");
INSERT INTO lip_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Nya ɔ́tɛyi mǝ nkǝ, “Awɔnisa Kɛnkɛ nnya eto etiki bɛnɔ mínkla mfoo, ibǝ itǝ lǝ mmi eto diyi nǝmfo.” ");
INSERT INTO lip_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Nya wǝ etiki nnya údi ǝmuǝ mǝ lǝ utu tinti nya kase odiakami tsya létaka wǝ mlǝmlǝmlǝǝ, ǝtǝ iyifo mǝ yanii. Nya bátɔ mǝ ǝsuǝ bǝnkǝ, “Inni Yosef eto ubi ni nwǝ mfo, fɛɛ?” ");
INSERT INTO lip_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Nya Yesu lɛtɛyi mǝ nkǝ, “Nyi miǝ biɔtɛyi mɛ lekpa lǝ nnya minlɛ bɔtɛyi mfo ǝsuǝ biǝ, ‘Ofate, tsya fǝ ǝsuǝ.’ Nya binsi biɔtɛyi mɛ tsya biǝ, ‘Asa nnya eto okle bɔ́nɔ bǝ éyifo lǝ Kapernaum, yifo nnya lǝ fǝ kosate eto umǝ mfo tsya.’ ” ");
INSERT INTO lip_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Nya Yesu disi ɔ́tɛyi mǝ nkǝ, “Fɛɛ nlɛ mi bɔtɛyi minkǝ, bǝǝntǝ Onanto eto unyɛlǝkǝtidi kuutsyuǝ dibu lǝ wǝ kosate eto umǝ. ");
INSERT INTO lip_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ɛkpɛ ini bǝ bakɔbǝsiǝ kpǝ ákɛ lǝ Israel eto kasɔ lǝ lefe nǝ Onanto eto Unyɛlǝkǝtidi Elia lɛkɛ. Nya ɔsɔmi lɛyɛ bɔni itǝ alɛ ǝtsyǝ ku kutsyǝ. Nya kukpɛnsɛ kplɛ díbǝ lǝ kasɔ kamǝ kenke ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Fɛɛ Onanto mánkpe Elia kɔtɔ nkǝ usu kutsyuǝ saa ɔflɔ lǝ Israel, enso ɔkɔsiǝ utsyuǝ lǝ Sarep eto umǝ lǝ Sidon eto kasɔ. ");
INSERT INTO lip_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Nya tsyaa, betidi kpǝ ákɛ ba díkefi bufisia lǝ Israel eto kasɔ lǝ Onanto eto Unyɛlǝkǝtidi Elisa eto lefe. Fɛɛ wántsya mǝ kuutsyuǝ enso Naeman wǝ ditsyi Siria eto kasɔ mate hã.” ");
INSERT INTO lip_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Se betidi ba lɛkɛ mfó lɛnɔ nyamfoo, kafo ányi mǝ tinti. ");
INSERT INTO lip_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Nya bátaka bǝńyǝ nya bála Yesu bǝlǝkǝ lǝ umǝ ǝmǝ kafo bésu bǝńyǝnsǝ lǝ umǝ ǝmǝ eto kɔtini ko ǝsuǝ bála umǝ ǝmǝ eto kotosi ku nsusu bǝ lǝ bǝkǝ wǝ bakpe lǝ kukpio kafo. ");
INSERT INTO lip_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Fɛɛ Yesu áyɛ lǝ mǝ nti ɔ́bɔ údu. ");
INSERT INTO lip_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Lǝ nyamfo eto kamaa, Yesu édu úsu Kapernaum eto umǝ lǝ Galilea eto kasɔ. Mfó nya útsyiko betidi asa bote lǝ Ɔnwɛditsyǝyi ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Nya lǝ wǝ etikididi ku ǝsuǝale esoo, wǝ asatete éyifo betidi bamǝ yanii. ");
INSERT INTO lip_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Osani utsyuǝ ákɛ lǝ Yudafɔ eto katsyakɔ mfó wǝ ǝsuǝ lɛwɔnɔ bua dísiǝ. Nya ófa ku ɔkɔɛ bembembe ɔ́tɛyi nkǝ, ");
INSERT INTO lip_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Yesu Nasaretnyǝ, be fanlɛ bɔbɛbɛ ketsyiko lǝ bo ɔflɔ mfo? Bubǝ fǝbǝ fǝ ǝǝbǝ atsylɔsǝ bo lee? Nyi futsyǝ feni. Fǝ ni Onanto eto Ɔkɛnkɛnyǝ wǝ ótsyese nɛ!” ");
INSERT INTO lip_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Mfó nya Yesu léla Lɛwɔnɔ bua nǝmǝ ɔ́bɔsǝ lǝ wǝ ǝsuǝ ɔ́tɛyi nkǝ, “Yɛ kudu bokpo! Lǝ abɔ lǝ utidi ǝmǝ ǝsuǝ!” Lɛwɔnɔ bua nǝmǝ étsyi osani ǝmǝ ɔ́sɔ lǝ kasɔ lǝ mǝ ǝnǝmi, nya lɛbɔ lǝ wǝ ǝsuǝ dídu. Fɛɛ utidi ǝmǝ mámfo lefabe saa. ");
INSERT INTO lip_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Iyifo betidi bamfó kenke yanii nya bátɔ bǝtsyuǝ bǝnkǝ, “Nte etiki nnya eto okle ni nyamfo? Utidi ǝmfo kpe ǝsuǝle nya wǝǝkumi kakpe awɔnɔ bua kǝlǝkǝ lǝ betidi ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Nya asa nnya bátɛyi lǝ Yesu ǝsuǝ mfóo, dísensǝ ɛyɛ ísu kuse komfó kenke. ");
INSERT INTO lip_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu édu lǝ Yudafɔ eto katsyakɔ mfó úsu Simen eto diyo. Atikesi ǝmuǝ Simon eto usiǝambe élabesǝ kekleke. Nya bǝtǝ Yesu léte. ");
INSERT INTO lip_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Lǝ nnya ǝsuǝǝ, úsu úńyǝ lɛ wǝ ɔflɔ lǝ wǝ kalabekɔ, nya óla bufi bomǝ úlǝkǝ lǝ wǝ ǝsuǝ. Nya lefe nǝ bufi bomǝ lɛyɛ wǝǝ, ótaka nya útsyiko lesa bonwa kǝtǝ mǝ. ");
INSERT INTO lip_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Nya se kofe nlɛ diyo budufǝǝ, bákpa befimfi ba nlɛ bufi ate ate kenke báboko Yesu ɔflɔ. Nya úfi ani útǝkǝ mǝ lǝ ǝsuǝ ɔni, ɔni nya ótsya mǝmblɛ bufi. ");
INSERT INTO lip_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Awɔnɔ bua kpǝ eto kakle tsya ábɔ lǝ betidi kpǝ ǝsuǝ nya báfa bátɛyi bǝnkǝ, “Fǝ ni Onanto eto Ubi kosate ǝmǝ!” Fɛɛ Yesu éti awɔnɔ bua nyamǝ kusu nya wǝntǝ kusu nkǝ batɛyi kulesa, itsyise béyi bǝ wǝ ni Nwǝ Onanto Lékpo Ɔhile Utsyǝ. ");
INSERT INTO lip_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Se kale disiǝǝ, Yesu édu lǝ umǝ ǝmfó úsu kaka lɛbiɔ. Mfó nya betidi dítsyiko wǝ bɔbɛbɛ katsyilama. Nya se bǝnyǝ wǝǝ, bákplatsya bǝ lǝ ɔyɛ budu lǝ mǝ ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Fɛɛ ɔ́tɛyi mǝ nkǝ, “Ele bǝ nsu ndi etiki lǝ kǝmǝ bamba tsya itsyi lǝ Onanto eto Sekakedidi ǝsuǝ, itsyise nyamfo eso Onanto létsyese mɛ nɛ.” ");
INSERT INTO lip_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Nyaso údi Anantotiki lǝ Yudafɔ eto ntsyakɔ kenke lǝ kasɔ kamǝ. ");
INSERT INTO lip_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Diyi lɔnii, se Yesu díńyǝ lǝ ditumbukplɛ nǝ baakpo bǝ Genesaret ɔflɔɔ, betidi kpǝ ákpɔ bǝ lǝ banyi bafi wǝ lǝ banɔ Anantotiki nnya ɔnlɛ budi. ");
INSERT INTO lip_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Yesu ǝnyǝ nkǝ kaklɔ inuǝ ńyǝ lǝ ditumbukplɛ nǝmǝ ɔflɔ mfó nya mba laata asabu kǝlǝkǝ akpɛ ébudu bésu mǝ asabu kǝflǝkɔ. ");
INSERT INTO lip_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Nya Yesu lébe údufǝ lǝ Simon eto ole kafo, nya ɔ́tɛyi wǝ nkǝ, onwa ɔklɔ ǝmǝ usuko ntu bomǝ ǝsuǝ sɛkɛ. Yesu ǝsiǝ lǝ ɔklɔ ǝmǝ kafo nya óte betidi bamǝ asa. ");
INSERT INTO lip_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Se óte mǝ asa ólosǝǝ, Yesu átɛyi Simon nkǝ, “Nwa ɔklɔ ǝmǝ esuko kaka ntu letsyo sɛkɛɛ, lǝ fonko fǝ bayɛtsyuǝ lǝ beta mi asabu lǝ bilǝkǝ binǝ.” ");
INSERT INTO lip_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Nya Simon dítǝ mbuayɛ nkǝ, “Bonamute, ketsye kamfo kenke búyifo keyifo kekleke tsya bóǝnlǝkǝ kulesa. Fɛɛ lǝ kase fátɛyi esoo, muutǝ lǝ bota asabu nyamǝ.” ");
INSERT INTO lip_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Se báta asabu nyamǝǝ, bǝlǝkǝ akpɛ kpǝ itǝ bǝ asabu nyamǝ étsyiko bola. ");
INSERT INTO lip_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Lǝ nyamfo esoo, básɔ ani bákpadi mǝ bǝtsyuǝ ba nkpe lǝ ɔklɔ nuǝfǝ bátɛyi bǝnkǝ bǝbǝ bawunsǝko mǝ. Bǝbǝ nya bǝnǝ asabu nyamǝ bǝlǝsǝ nya binǝ biamǝ díyi kaklɔ inuǝ kamǝ kinkinki ibu sɛkɛ lǝ kanya kedufǝ lǝ ntu ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Se Simon Petro dínyǝ nnya díbǝ mfoo, óse akonki lǝ Yesu eto ǝnǝmi nya ɔ́tɛyi wǝ nkǝ, “Bonamute, mannyi ǝbǝ mɛ ɔflɔ, itsyise obuayifo mini.” ");
INSERT INTO lip_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Binǝ kpǝ bia bǝlǝkǝ mfó esoo, íyifo wǝ ku wǝ bǝtsyuǝ yanii. ");
INSERT INTO lip_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Nko ke íyifo Simon eto bayɛtsyuǝ, Yakobo ku Yohanes ba ni Sebedeo eto bebi tsya nɛ. Mfó ǝmǝ nya Yesu lɛtɛyi Simon nkǝ, “Mante sikpi. Idu mɔmɔ ɛntɔɔ, mfe betidi fuukǝlǝkǝ.” ");
INSERT INTO lip_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Se báyo ditukpenkpee, báyani lesa saa bǝtsyǝ nya bédu bǝtǝkǝko Yesu. ");
INSERT INTO lip_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Lefe lɔnii, Yesu ésu umǝ utsyuǝ kaka utidi utsyuǝ nlɛ bufisia bufi. Nya se utidi ǝmfo dínyǝ Yesu, ókpo kasɔ lǝ Yesu eto ǝnǝmi nya ɔ́lɛ wǝ lekpakpa ɔ́tɛyi nkǝ, “Bonamute! Lǝ aalaa, ebofo butǝ mɔ bufi bomfo yuǝ mɛ.” ");
INSERT INTO lip_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesu ǝnǝ kɔni útidi wǝ nya ɔ́tɛyi osani ǝmǝ nkǝ, “Nla nko. Lǝ nyasoo, bufi bomǝ yuǝ fǝ.” Lamfolamfo, bufi bomǝ ǝyuǝ wǝ. ");
INSERT INTO lip_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Mfó nya Yesu lékpe wǝ kɔfi nkǝ, “Mantɛyi utidi sa nyamfo. Bomu yɛ tentente lǝ edu lǝ efi ǝsuǝ esu ate Onanto eto usumunyǝ. Wǝ loobe fǝ unyǝ nkǝ ǝmuǝ ale nya uudi fǝ adansiɛ itǝ utidi saa nkǝ sitintii, bufi bomǝ ǝyuǝ fǝ. Nya lǝ efi lɛninsɔ ǝtǝ fe kase Moses eto kɔfi lɛtɔ.” ");
INSERT INTO lip_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Fɛɛ Yesu eto etiki nyamfo ésensǝ ɛyɛ etsyo. Nya betidi kpǝ díbǝ bǝ lǝ banɔ wǝ asatete nya lǝ ótsya mǝ bufi bo nlɛ mǝ bulǝ. ");
INSERT INTO lip_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Fɛɛ ɔ́kabɔ kesu kaka lɛbiɔ úsu úkato ola. ");
INSERT INTO lip_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Diyi lɔni se Yesu lɛkɛ mfó ókaté asaa, Yudafɔ eto ditsyukpa lɔni nǝ baakpo Farisifɔ ku afi eto bateasa bǝtsyuǝ ba ditsyi nlebe nlebe lǝ Galilea ku Yudea eto nsɔ ku Yerusalem ǝbǝ mfó. Nya Onanto eto ǝsuǝale nnya Yesu leefi katsya befimfi tsya ǝsiǝ wǝ lǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Nya mfóo, betidi bǝtsyuǝ étsyi utidi wǝ léba onkpo kasɔ lǝ belabekǝ ǝsuǝ báboko wǝ ɔflɔ. Nya bábɛbɛ kusu ko bɔɔyɛ befi wǝ bedufǝnko diyo kafo lǝ befi wǝ bǝtsyǝ lǝ kasɔ lǝ Yesu eto ǝnǝmi. ");
INSERT INTO lip_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Fɛɛ betidi bamǝ eto etu esoo, bámfo kusu bunyǝ. Nko esoo, bétsyi wǝ báyɛnko lǝ diyo eto letsya. Nya bǝlǝkǝ ofo lǝ letsya ǝsuǝ nya báyifǝsǝ wǝ ku wǝ belabekǝ bǝtsyǝ lǝ kasɔ lǝ Yesu eto ǝnǝmi lǝ betidi bamǝ eto nti lǝ diyo kafo mfó. ");
INSERT INTO lip_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Nya se Yesu dínyǝ mǝ bofokanɔ esoo, ɔ́tɛyi utidi ǝmǝ nkǝ, “Osani, mfi fǝ abua ntsyɛ fǝ!” ");
INSERT INTO lip_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Mfó nya Farisifɔ ku afi eto bateasa dítsyiko mǝ ǝsuǝ bɔtɔ bǝ, “Owoe ni nwǝ mfo leedi mbusiotiki kefi wǝ ǝsuǝ kakatesǝ ko Onanto nko! Onanto hã ni futsyǝ wǝ loofo utidi eto abua bufi katsyɛ wǝ!” ");
INSERT INTO lip_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Nya se Yesu dínyǝ mǝ nsusu útsyǝ lekpo esoo, ɔ́tɔ mǝ nkǝ, “Beso bɛnlɛ nsusu bomfo eto okle bufi? ");
INSERT INTO lip_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Nte nnya nso buyuǝ ku bɔtɛyi, ‘Befi fǝ abua bátsyǝ fǝ,’ lee ‘Taka ǝńyǝ lǝ ayɛ edu’? ");
INSERT INTO lip_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Muulǝkǝ nte mi miǝ Utidi Eto Ubi kpe ǝsuǝale lǝ kawunsiǝ kamfo bǝ ufi abua ɔtsyɛ.” Nyaso ɔ́tsyi ɔ́wuninsǝ nya ɔ́tɛyi nwǝ léba oonkpo kasɔ nkǝ, “Nlɛ fǝ bɔtɛyi minkǝ taka lǝ efi fǝ okla lǝ esu diyo!” ");
INSERT INTO lip_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Mfo ǝmǝǝ, osani ǝmǝ átaka uńyǝ lǝ betidi bamǝ eto ǝnǝmi nya úfi wǝ okla, nya údu ɔ́ntɔ lǝ diyo ɔnlɛ Onanto bɔtɛsǝ. ");
INSERT INTO lip_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Nyamfó éyifo betidi bamfó kenke yanii! Nya se sikpi dímuǝ mǝmblɛ kenke lǝ nnya ǝsuǝ esoo, bátɛsǝ Onanto nya bátɛyi bǝnkǝ, “Nte ayanisa nnya búnyǝ mfo mmi mǝǝ?” ");
INSERT INTO lip_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Nyamfo eto kamaa, Yesu ábɔ útsyi lǝ diyo nǝmǝ kafo nya únyǝ utsyuǝ wǝ laafo umǝnko wǝ baakpo Lewi nkpe lǝ wǝ keyifokɔ. Mfó nya Yesu lɛtɛyi wǝ nkǝ, “Taka lǝ ǝtǝkǝko mɛ.” ");
INSERT INTO lip_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lewi áyani lesa saa útsyǝ nya ótaka útǝkǝko wǝ. ");
INSERT INTO lip_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lewi ǝtǝ bánwa lesa kǝn nya úfi útsyue ɔpunu ókpe Yesu disuǝyuǝ lǝ wǝ diyo. Nya betidi kpǝ díbǝ mfó ku mba laafo umǝnko tsya. ");
INSERT INTO lip_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Farisifɔ ku afi eto bateasa ba díbǝ katsyakɔ mfó étsyiko etiki bunǝ ku Yesu eto bakasebi katɛyi bǝ, “Beso biedi kǝnǝ ku mba laafo umǝnko ku babuayifo bamfo?” ");
INSERT INTO lip_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Mfó nya Yesu dítǝ mbuayɛ nkǝ, “Betidi ba nkpe ǝsuǝale manhiã ofanyǝ enso mba ni Onanto hã. ");
INSERT INTO lip_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Mǝmbǝ miǝ mǝǝbǝ nlǝkǝ betidi sɛɛ, bomu babuayifo eso mímbǝ.” ");
INSERT INTO lip_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Betidi bǝtsyuǝ átɔ Yesu bǝnkǝ, “Ntsyǝ ibǝ bǝ Yohanes eto bakasebi aakle kɛnyɛ nya baato ola, nya mba ntǝkǝko Farisifɔ tsya leeyifo nko, fɛɛ fǝ bale leedi kǝnǝ lefe saa?” ");
INSERT INTO lip_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesu ǝtǝ mbuayɛ nkǝ, “Bubu bibu biǝnkǝ baklobo ebofo kɛnyɛ bokle lǝ lefe nǝ eto lefe okafɔsǝ ǝmǝ nkpe lǝ mǝ lenti? Kulefe! Yembubǝ itǝ nkomǝ! ");
INSERT INTO lip_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Fɛɛ diyi ditsyuǝ ebubǝ ni lefe nǝ bookpa okafɔsǝ ǝmǝ bedunko lǝ mǝ ɔflɔ. Nya lǝ lefe nǝmfó ǝsuǝǝ, insini utidi saa luubǝ ɔtɛyi mǝ fɛ bookle kɛnyɛ.” ");
INSERT INTO lip_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Lǝ nyamfo eto kamaa, Yesu esi ɔ́tɛyi mǝ lekpa nǝmfo nkǝ, “Utidi kuutsyuǝ embofuadi kafia fɔfɔ ufi otale kakoko. Lǝ utsyuǝ éyifo nkoo, ebunyǝ fǝ obiasǝ kafia fɔfɔ kamǝ. Nya kakoko kamfó tsya ku kafɔfɔ kamǝ ǝmbɔlɛkɛ itǝ boka kǝtǝkǝ lǝ bǝtsyuǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Nya bemfi nte fɔfɔ kakpo lǝ kubukikuetobe. Lenni nkoo, nte fɔfɔ bomǝ ebɔkpɔ bobe kato nnya luutǝ kubukikuetobe komǝ la nya nte bomǝ tsya luuwui buyifo nsɔsɔ. ");
INSERT INTO lip_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Nyasoo, ntǝ fɔfɔ beefi kakpo lǝ kubukikuetobe fɔfɔ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Nya mɔmɔ tsyaa, utidi kuutsyuǝ ǝnnǝ nte koko kesi kala nkǝ wǝǝnǝ mfɔfɔ lamfolamfo, etsyisee, wɔɔtɛyi nkǝ, ‘Ntutɛ, bo ni nkokoo, alɛkɛ boso!’ ” ");
INSERT INTO lip_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Lǝ Yudafɔ eto Ɔnwɛditsyǝyi lɔnii, Yesu ku wǝ bakasebi ákayɛ lǝ kusu kutsyuǝ ko lɛyɛ lǝ anta eto ɔkuɛ utsyuǝ kafo kafe. Mfó nya wǝ bakasebi dítsyiko anta nnya ńyǝ mfó bufǝsǝ kǝfǝ akayimi. ");
INSERT INTO lip_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Mfó nya Farisifɔ bǝtsyuǝ lɛtɔ mǝ bǝnkǝ, “Beso bɛnlɛ lesa nǝ bo kɔfi dimǝntǝ bo kusu nkǝ buyifo lǝ Ɔnwɛditsyǝyi ǝsuǝ buyifo?” ");
INSERT INTO lip_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Nya Yesu dítǝ mbuayɛ ɔ́tɔ mǝ nkǝ, “Bíankla lǝ Awɔnisa Kɛnkɛ eto Kukue ǝsuǝ lesa nǝ Oka David díyifo lǝ lefe nǝ kukpɛnsɛ lɛlɛ wǝ ku wǝ betidi ba dítǝkǝko wǝ? ");
INSERT INTO lip_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Oka David ésu údufǝ Onanto eto kedikǝtǝkɔ úsu úfi lesa nǝ béfi bǝtǝ Onanto kedii, údi. Nya útǝ wǝ bǝtsyuǝ tsya ni ditsyuǝ bédi lǝ lefe nǝ iyifo botakebu lǝ bo kɔfi ǝsuǝ bǝ utidi bamba lǝ udi lesa nǝmfo. Kuutsyuǝ sa ǝmbǝ kusu enso Onanto eto Usumunyǝ hã.” ");
INSERT INTO lip_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Lǝ nnya kalosǝkɔɔ, Yesu átɛyi mǝ nkǝ, “Utidi Eto Ubii, wǝ ni Onamute itǝ Ɔnwɛditsyǝyi nɛ.” ");
INSERT INTO lip_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Lǝ Ɔnwɛditsyǝyi bamba ǝsuǝǝ, Yesu ésu Yudafɔ eto katsyakɔ nya ɔnlɛ asa bote. Osani utsyuǝ ákɛ mfó wǝ eto kodiani díkpǝ konyoma. ");
INSERT INTO lip_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Nya se kɔfi eto bateasa ku Farisifɔ bǝtsyuǝ díkabɛbɛ kusu ko ǝsuǝ bɔɔyɛ bǝmuǝ Yesu bǝ óta kɔfi ubu esoo, béfi ǝnǝmi bǝtǝkǝ lǝ wǝ kekleke balɛ bobe lǝ wootsya bufi lǝ Ɔnwɛditsyǝyi. ");
INSERT INTO lip_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Fɛɛ se Yesu dínyǝ mǝ nsusu utsyǝ lekpo esoo, ɔ́tɛyi osani ǝmǝ nkǝ, “Taka ǝńyǝ, lǝ abɔ ǝbǝ sɛtɔ mfo.” Nya osani ǝmǝ létaka úbǝ úńyǝ lǝ mǝ ǝnǝmi. ");
INSERT INTO lip_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Nya Yesu lɛtɔ mǝ nkǝ, “Be kɔfi dítǝ bo kusu nkǝ buyifo lǝ Ɔnwɛditsyǝyi ǝsuǝ? Ɛlɛkɛ bǝ buyifo kasɛɛ lǝ Ɔnwɛditsyǝyi lee bǝ buyifo kabua? Nye, ɛlɛkɛ bǝ bafo utidi lǝ nkpǝ lee babiasǝ mu bomu?” ");
INSERT INTO lip_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yesu átsyilamasǝ ǝnǝmi óbe mǝ nya ɔ́tɛyi osani ǝmǝ nkǝ, “Nǝ fǝ kɔni etsyue, nya úyifo nko.” Nya wǝ kɔni komǝ létsya wǝ. ");
INSERT INTO lip_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Nyaso mǝmblɛ kenke éyenki ku lɛblɔfi nya bétsyiko nsusu bufi lǝ lesa nǝ boofo Yesu buyifo ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Lǝ lefe nǝmfóo, Yesu ábe úsu kɔtini disi. Ɔ́kɛ mfó óto ola útǝ Onanto ketsye kamfó kenke. ");
INSERT INTO lip_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Se kale dísiǝǝ, ókpadi wǝ bakasebi kenke útsyǝ nya úlǝkǝ lefosi inuǝ ba útǝkǝ diye nkǝ wǝ Batɔnkpe. ");
INSERT INTO lip_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Mǝ ni Simon wǝ útǝkǝ diye nkǝ Petro ku wǝ ɔyimi Andreas ku Yakobo, Yohanes ku Filipo ku Bartolomeo, ");
INSERT INTO lip_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ku Mateo ku Tomas, ku Alfeo eto ubi Yakobo ku Simon wǝ baakpo bǝ utidi wǝ laakpɔ kǝtǝ wǝ umǝ ");
INSERT INTO lip_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ku Yakobo eto ubi Yuda ku Yuda Iskariot wǝ léfiani nwǝ lídu Yesu útǝ. ");
INSERT INTO lip_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Lǝ lefe nǝ Yesu ku wǝ batɔnkpe lɛyifǝ bétsyi kɔtini koǝ eto disi bǝbǝǝ, bǝbǝ bǝńyǝ lǝ kaka diyifo tsyɛ tsyɛ tsyɛ nya mba dítǝkǝko wǝ eto bǝtsyuǝ kpǝ ákɛ mfó nya sitiditu kplɛ sia dítsyi Yudea eto kasɔ ǝsuǝ kenke ku Yerusalem eto kǝmǝ ka lɛfi lekpo kɛnyɛ ka ni Tiro ku Sidon. ");
INSERT INTO lip_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Bǝbǝ bǝ lǝ banɔ asa nnya Yesu díkate ku lǝ otsya mǝ efimbi kpǝ nnya banlɛ. Betidi ba awɔnɔ bua díkelǝ tsya ǝbǝ nya ótsya mǝ bufi. ");
INSERT INTO lip_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Betidi bamfo kenke ákplatsya bǝ lǝ betidi Yesu lǝ mǝ efimbi lǝ ɛyɛ mǝ, itsyise ǝsuǝale ǝtsyuǝ eto okle ákabɔ ketsyi lǝ Yesu ǝsuǝ nnya díkatsya betidi bamǝ kenke. ");
INSERT INTO lip_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesu átakasǝ ǝnǝmi óbe wǝ bakasebi, nya ɔ́tɛyi mǝ nkǝ, “Ǝsuǝ ebuyuǝ mi bakombo, itsyise Onanto eto sekakedikɔ eyifo mi kale! ");
INSERT INTO lip_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ǝsuǝ ebuyuǝ mimba kukpɛnsǝ nlɛ mɔmɔ, itsyise biumi! Ǝsuǝ ebuyuǝ mimba nlɛ nku mɔmɔ, itsyise biumǝ simǝ! ");
INSERT INTO lip_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ǝsuǝ ebuyuǝ mi lǝ betidi eekisi mi, nya baani mi, nya baaka mi, nya baatɛyi mi bǝnkǝ bekpe ditsyǝbi bua lǝ mɔ wǝ ni Utidi Eto Ubi eso! ");
INSERT INTO lip_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Binyǝ disuǝyuǝ lǝ nyamfo kenke ǝbǝ, lǝ biwi kewi ku disuǝyuǝ, itsyise Onanto ebutǝ mi kayofofo kplɛ lǝ Onanto eto oto kato. Itsyise asa nyamfo eto okle mǝ bana díyifo Onanto eto bǝnyɛlǝkǝtidi ba lɛkɛ kɔ kenke nɛ. ");
INSERT INTO lip_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Fɛɛ mbɔbɔɛ itǝ mi batabinyǝ, itsyise bíofo mi disuǝyuǝ eto kayofofo lǝ kasɔ mfo! ");
INSERT INTO lip_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Mbɔbɔɛ mǝǝtǝ mimba díkedi bími mɔmɔ, itsyise kukpɛnsɛ ɛbɔlɛ mi! Mbɔbɔɛ mǝǝtǝ mimba nlɛ simǝ bumǝ mɔmɔ, itsyise mi asa ebɔkɛ kaminsǝ nya biuwi nku! ");
INSERT INTO lip_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Mbɔbɔɛ mǝǝtǝ mi mba betidi kenke laatɛsǝ mɔmɔ, itsyise nko ke ibǝ bǝ mǝ banamǝ lɛtɛsǝ betidi ba lɛwɛ betidi bǝ mǝ ni Onanto eto bǝnyɛlǝkǝtidi nɛ. ");
INSERT INTO lip_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Fɛɛ mimba nlɛ mɔ etiki bɔnɔɔ, nlɛ mi bɔtɛyi minkǝ bela mi balo lǝ biyifo kasɛɛ bitǝ mǝ. ");
INSERT INTO lip_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Nya betidi ba leekudi mii, bekpo mǝ atsyɔ. Nya betidi ba laalo fǝ sɛsi nye beeyifo disialee, to ola lǝ mǝ disi. ");
INSERT INTO lip_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nya lǝ utsyuǝ ásɔ fǝ lǝ kotosii, tsyi nkonse tsya ǝtǝ wǝ. Nya lǝ utidi utsyuǝ éfi fǝ awu katoo, tǝ lǝ ufi nnya kalɔ tsya lǝ woala. ");
INSERT INTO lip_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Utidi saa wǝ laadia asa lǝ fǝ ɔflɔɔ, tǝ wǝ. Nya lǝ utsyuǝ éfi fǝ lǝsatsyuǝǝ, mantɛyi fǝ usinkliko ni oboko. ");
INSERT INTO lip_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Lesa nǝ faala fǝ beyifo bǝtǝ fǝǝ, ni ke ele bǝ fintsya yifo ǝtǝ betidi nɛ. ");
INSERT INTO lip_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Lǝ ibǝ bǝ betidi ba laala mi ete mi tsya laalaa, nte atɛsǝ nye lɛninsɔ nǝ biunyǝ bitsyiko lǝ nnya ǝsuǝ? Mba ni babuayifo tsya aala betidi ba laala mǝǝ. ");
INSERT INTO lip_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Nya lǝ betidi ba díyifo fǝ kasɛɛ ete fintsya leeyifo kasɛɛ kǝtǝǝ, nte lɛninsɔ nǝ ele bǝ befi bǝtǝ fǝ? Mba ni babuayifo tsya eeyifo nkoo. ");
INSERT INTO lip_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Nya lǝ betidi ba ni mba leesinkli kǝbǝ kǝtsyǝ fǝ lǝ nnya kɛnyɛ hã faadia asa kǝtǝǝ, beso faala fǝ batɛsǝ fǝ? Babuayifo tsya aaba kǝtǝ mǝ bayɛtsyuǝ bǝ lǝ bǝtsyǝ mǝ nnya lǝ kɛnyɛ! ");
INSERT INTO lip_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Bomuu, bela mi balo lǝ biyifo mǝ kasɛɛ. Beba asa bitǝ mǝ, nya biambe kusu biǝ besinkliko kulesa bǝbǝ bǝtsyǝ lǝ nnya kɛnyɛ kokooko. Lǝ biyifo nkoo, biunyǝ kayofofo kplɛ lǝ nnya disi. Nya bookpo mi bǝ Onanto wǝ ni Onanto Fanlofanlo eto bebi. Itsyise Onanto kpe kafoɛkpɛ itǝ mba lǝǝnnyǝ kasɛɛ kǝtsyǝ lekpo ku mba nkpe disiale kulaa tsya. ");
INSERT INTO lip_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Biyifo mba lǝǝnyǝ asa kaminsǝ fe kase mi Anto Onanto lǝǝnyǝ kaminsǝ. ");
INSERT INTO lip_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Biankponko betidi bamba akpo lǝ Onanto tsya lǝ ɔyɛ mi lekpo bokponko. Bianlo betidi dikpi, lǝ Onanto tsya lǝ ɔyɛ mi dikpi bolo, bifi asa bɛtsyɛ betidi lǝ Onanto tsya lǝ ufi ɔtsyɛ mi. ");
INSERT INTO lip_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ele bǝ bitǝ betidi asa bǝ lǝ Onanto tsya lǝ utǝ mi asa. Lǝ sitintii, Onanto ebuyisǝ mi kenwu keyi kaba kakpo ɛyɛ lǝ wǝ lefonǝ eso. Kase faaklá asa yeyi kaba kakpo kǝtǝ utidii, nko eto okle ke Onanto looklá utǝ fǝ nɛ.” ");
INSERT INTO lip_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Mfó nya Yesu lɛtɛyi mǝ lekpa nkǝ, “Unǝmba anyɛnko wǝ unǝmbatsyuǝ. Lenni nkoo, mǝ inuǝ ba tã ebudu banɔ bedufǝ lǝ dibiǝ kafo. ");
INSERT INTO lip_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Okasebi saa ante kaso wǝ oteasa. Fɛɛ lefe nǝ okasebi ǝmǝ lelosǝ asa bokasee, wǝǝtsyǝ fe wǝ oteasa ke. ");
INSERT INTO lip_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Ntsyǝ fɛ fanlɛ dikubi kɛkɛ nǝ ntǝkǝ fǝ ɔyimitsyuǝ lǝ dinǝmi bobe fɛ fannlɛ dikubi kplɛ nǝ ntǝkǝ lǝ fǝ lele bunyǝ? ");
INSERT INTO lip_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ntsyǝ fɛ foofo fǝ ɔyimitsyuǝ bɔtɛyi fǝnkǝ, ‘Lekpakpa, tǝ lǝ nlǝkǝ dikubi kɛkɛ nǝ ntǝkǝ fǝ lǝ dinǝmi’ se dikubi kplɛ ntǝkǝ lǝ fǝ kosate eto lele ǝsuǝ? Fǝ, ǝnǝmi ǝnǝmi eto utidi! Ka dikubi kplɛ nǝ ntǝkǝ fǝ lǝ dinǝmi bulǝkǝ fɛ lǝ ǝnyǝ kusu ǝlǝkǝ fǝ ɔyimitsyuǝ eto lele kɛkɛ nǝ ntǝkǝ lǝ wǝ lele. ");
INSERT INTO lip_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Kuyi sɛɛ aannwɔ ebibi bua, nya kuyi bua tsya laannwɔ ebibi sɛɛ. ");
INSERT INTO lip_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kuyi saa eto ebibi ǝsuǝ beefi kǝtsyǝ ko lekpo. Banlɛ koto eto awɔnsa lǝ kanyi ǝsuǝ, nya banlɛ awɔnsa nya beedi lǝ otonkpa tsya ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Utidi sɛɛ saa, asa sɛɛ laabɔ ketsyi lǝ wǝ asayifoyifo ǝsuǝ nnya leetsyi lǝ wǝ utu kǝmiǝ. Nya utidi bua tsya lǝǝlǝkǝ asa bua kate ketsyiko lǝ wǝ utu kǝmiǝ. Itsyise asa nnya nkpe lǝ utidi eto utu kǝmiǝǝ, nnya ni lesa nǝ laabɔ ketsyi lǝ wǝ kɛnyɛ nɛ. ");
INSERT INTO lip_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Beso biakpadi mɛ biǝ Bonamute, Bonamute, fɛ bienyifo lǝ lesa nǝ maatɛyi mi ǝsuǝ? ");
INSERT INTO lip_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Utidi saa wǝ lǝǝbǝ mɛ ɔflɔ nya wǝǝbǝ nkǝ wǝǝbǝ ɔnɔ lesa nǝ maatɛyi nya weeyifo lǝ nnya ǝsuǝǝ, moote mi futsyǝ eto okle uni. ");
INSERT INTO lip_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ute fe utidi wǝ laato diyo nya óba kakplo nya óse ni unyǝnsǝ lǝ aba ǝsuǝ fɛ óto diyo nǝmǝ unyǝnsǝ. Se ketu díyi nya káyɛ mfó káfee, kulesa ményifo diyo nǝmǝ, itsyise dińyǝ lǝ kǝńyǝkɔ sɛɛ. ");
INSERT INTO lip_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Fɛɛ utidi saa wǝ laanɔ mɔ ditiki nya woenyifo lǝ ni ǝsuǝǝ, uyifo fe utidi wǝ léto diyo nya wánse ni lǝ kasɔ ka nkpe ale ǝsuǝ nya wénku kasɔ fɛ útsyiko ofatiǝ ǝmǝ bose lǝ umuǝ sui. Nyaso lefe nǝ ketu díyi kába káyɛ lǝ diyo nǝmǝ ɔflɔ káfee, léba kenke lékpo lǝ kasɔ!” ");
INSERT INTO lip_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Se Yesu lɛtɛyi betidi bamfo asa nyamfo kenke olosǝǝ, údu úsu Kapernaum. ");
INSERT INTO lip_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Romafɔ eto omamanyǝninǝ utsyuǝ akɛ mfó nya ɔkɛ uyifoyifo wǝ eto asa óla tinti. Uyifoyifo ǝmǝ ánɔ bufi kekleke, nya ɔkɛ lǝ ukpǝ ku menkpǝ eto nti. ");
INSERT INTO lip_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Se uninǝ ǝmfo lɛnɔ Yesu eto kɔsɔɔ, ókpe Yudafɔ eto beninǝ bǝtsyuǝ nkǝ batɛyi wǝ lǝ ubǝ otsya wǝ uyifoyifo ǝmǝ utǝ wǝ. ");
INSERT INTO lip_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Bǝbǝ Yesu ɔflɔ nya bálɛ wǝ lekpakpa kekleke bǝnkǝ, “Utidi ǝmfo ǝńyǝ utǝ bǝ wunsǝko wǝ, ");
INSERT INTO lip_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","itsyise woala bo kuse eto betidi. Nya wǝ kosate léto bo katsyakɔ útǝ bo.” ");
INSERT INTO lip_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Lǝ nyamfo eso Yesu átaka útǝkǝko mǝ. Yesu ménsitsyonko diyo nǝmǝ fɛ uninǝ ǝmfo lékpe wǝ bayɛtsyuǝ bǝtsyuǝ nkǝ besu batɛyi wǝ bǝnkǝ, “Boanto, mensilǝ ǝsuǝ fǝ ǝǝbǝ. Itsyise mɔɔ, mǝnńyǝ ntǝ bǝ lǝ ǝbǝ mɔ diyo. ");
INSERT INTO lip_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Nya mǝnńyǝ ntǝ tsya bǝ mbǝ ntsyako fǝ, nńyǝ lǝ fǝ ǝnǝmi. Nyasoo, fǝ tɛyi ditiki ete, mɔ uyifoyifo eto ǝsuǝ ebumuǝ ale. ");
INSERT INTO lip_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Mintsya nyifo uninǝ wǝ nkpe lǝ beninǝ ba nsi nso mɛ eto ǝsuǝale eto kalɔ. Nya nkpe bamamanyǝ ba nkpe mɛ kalɔ. Lǝ ntɛyi nwǝ miǝkǝ, ‘Su,’ woesu. Nya lǝ ntɛyi obamba tsya miǝ, ‘Bǝ,’ wǝǝbǝ. Nya lǝ ntɛyi mɔ uyifoyifo miǝ, ‘Yifo mmǝǝ,’ woǝyifo.” ");
INSERT INTO lip_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Se ɔ́tɛyi nkoo, íyifo Yesu yanii. Mfó ǝmǝ nya ɔ́tsyi ɔ́wuninsǝ ɔ́tɛyi sitiditu sia ba dítǝkǝko wǝ mfó nkǝ, “Nlɛ mi bɔtɛyi minkǝ mǝnyǝ tɔ bofokanɔ bomfo eto okle lǝ Israelfɔ nti tɔ kulatsya!” ");
INSERT INTO lip_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Mfó ǝmǝ nya betidi ba bátsyese mfó dísinkli bésu oto nya bǝnyǝ bǝ uyifoyifo ǝmǝ eto bufi ǝyuǝ wǝ. ");
INSERT INTO lip_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Nyamfo eto kamaa, Yesu ésu umǝ wǝ baakpo Naim, nya wǝ bakasebi ku betidi kpǝ bǝtsyuǝ dítǝkǝko wǝ bésu. ");
INSERT INTO lip_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Lefe nǝ óyo umǝ ǝmǝ eto kabɔsiee, ótsyako bǝtsyuǝ ba nlɛ keku nya banyɛ banlɛ bɔbɔ lǝ umǝ ǝmǝ. Ɔkɔsiǝ eto ubi ɔni kplo eto ɔkɔ ni wǝ béntsyi banlɛ bɔbɔnko bantɔ kebikǝkɔ nɛ. Nya umǝ eto betidi kpǝ dítǝkǝko wǝ. ");
INSERT INTO lip_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Se Yesu dínyǝ usio ǝmfoo, wǝ asa álɛ wǝ kaminsǝ. Mfó nya ɔ́tɛyi wǝ nkǝ, “Sinkli ayɛ keku.” ");
INSERT INTO lip_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Yesu édufǝ mǝ lenti nya útidi ɔkɔ ǝmǝ, nya mba ntsyi wǝ ǝmǝ díńyǝ. Mfó Yesu lɛtɛyi nkǝ, “Okosobi! Nlɛ fǝ bɔtɛyi minkǝ taka!” ");
INSERT INTO lip_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Nya ɔkɔ ǝmǝ létaka úsiǝ nya útsyiko etiki budi. Nya Yesu dífi wǝ ókpe wǝ ambe lǝ kɔni. ");
INSERT INTO lip_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Íyifo betidi bamfó kenke yanii ku sikpi tinti, nya bátɛsǝ Onanto. Lǝ nyamfo eso bátɛyi bǝnkǝ, “Onanto eto Unyɛlǝkǝtidi wǝ nkpe kɛnyɛ ale tinti ǝbǝ údufǝ bo lenti! Onanto áyifǝ úbǝ nkǝ lǝ ubǝ ulǝkǝ wǝ betidi!” ");
INSERT INTO lip_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Yesu eto etiki nyamfó esensǝ éba ékpo lǝ Yudea eto kasɔ ku lekpake nǝmfo kenke. ");
INSERT INTO lip_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Lefe nǝmfóo, se Yohanes eto bakasebi lɛtɛyi Yohanes asa nyamfoo, ókpadi inuǝ lǝ mǝ nti, ");
INSERT INTO lip_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","nya óla mǝ ótsyese Bonamute Yesu ɔflɔ ku kɛnyɛ kamfo nkǝ, “Fǝ ni utidi wǝ bǝ ɔlɛ bubǝ lee, lee buńyǝ bukabe utidi bamba kusu?” ");
INSERT INTO lip_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Nyaso se bǝbǝ Yesu ɔflɔɔ, batɛyi wǝ bǝnkǝ, “Ntuflǝsǝtidi Yohanes ni nwǝ lékpe bo nkǝ bubǝ bɔtɔ fǝ nkǝ, ‘Fǝ ni utidi wǝ bǝ ɔlɛ bubǝ lee, lee buńyǝ bukabe utidi bamba kusu?’ ” ");
INSERT INTO lip_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Lǝ lefe nǝmfó ǝsuǝǝ, Yesu átsya betidi kpǝ bufi nya óla awɔnɔ bua, nya útǝ bǝnǝmba kpǝ dínyǝ asa. ");
INSERT INTO lip_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Mfoti ǝmǝ nya útǝ mbuayɛ ɔ́tɛyi Yohanes eto batɔnkpe nkǝ, “Bisinkli bisu bɛtɛyi Yohanes asa nnya bínyǝ ku nnya bɛnɔ banlɛ bɔtɛyi bǝnkǝ bǝnǝmba lɛ bunyǝ, mba léba bankpoo kasɔ lɛ bɔyɛ kafe, mba nlɛ bufisia bufi eto ǝsuǝ lɛ bokpa, batoti lɛ asa bɔnɔ, bǝkpǝnkpǝ lɛ botaka kǝbǝ nkpǝ, nya maatɛyi bakombo Onanto eto Ditiki Sɛɛ nǝmǝ. ");
INSERT INTO lip_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Disuǝyuǝ itǝ utidi wǝ dímǝnnyǝ kabua lǝ mɛ ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Se Yohanes eto batɔnkpe dídu eto kamaa, Yesu étsyiko etiki budi ketsyiko lǝ Yohanes ǝsuǝ kate betidi bamfó nkǝ, “Lǝ lefe nǝ bɛbɔ bisu kaka Yohanes nkpe lǝ mfiminti mfóo, be ni lesa nǝ bibu biǝ biusu binyǝ? Utidi wǝ nte fe lefanto nǝ ufiebi nlɛ bɔsɔ ketinkǝsǝ lee? ");
INSERT INTO lip_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Be tutuutu ni lesa nǝ bísu kabekɔ? Lee Utidi wǝ nkpe awu nnya laanɔ bobe? Betidi ba laakpe awu nnya lefo koya nya beedi nkpǝǝ, mǝ kakɛnkɔ ni bakankplɛ eto ayo. ");
INSERT INTO lip_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Bɛtɛyi mɛ lesa nǝ bísu kabekɔ! Onanto eto unyɛlǝkǝtidi utsyuǝ bísu kabekɔ? Lǝ sitintii, nlɛ mi bɔtɛyi minkǝ oso Onanto eto unyɛlǝkǝtidi. ");
INSERT INTO lip_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Itsyise Yohanes ǝsuǝ eto etiki nya Awɔnisa Kɛnkɛ eto Kukue lɛtɛyi ni nkǝ, ‘Mootsyese mɔ ɔtɔnkpe ntɔnsǝ fǝ bubǝ, nya wɔɔtɔ ɔlɔ kusu utsyǝ utǝ fǝ bubǝ.’ ” ");
INSERT INTO lip_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yesu esi ɔ́tɛyi mǝ nkǝ, “Yohanes so utidi saa wǝ bale lǝ kawunsiǝ kamfo. Fɛɛ utidi wǝ ni ɔkɛkɛ kulaa tsya lǝ Onanto eto sekakedikɔ, so Yohanes.” ");
INSERT INTO lip_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ɛtɔnsǝǝ, betidi bamǝ kenke ánɔ Yohanes eto Ditiki Sɛɛ nǝ údi nya titlu mǝ ku mba laafo umǝnko tsya áfo lesa nǝ Onanto nlɛ bɔbɛbɛ ketsyiko mǝ ɔflɔɔ, ku mǝ ketu kenke nya Yohanes díflǝsǝ mǝ ntu. ");
INSERT INTO lip_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Fɛɛ Farisifɔ ku afi eto bateasa kplɛ áni lesa nǝ ni Onanto eto ketsyue itǝ mǝ nya bántɔnɔ bǝ Yohanes flǝsǝ mǝ ntu. ");
INSERT INTO lip_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesu ésukosǝ wǝ etiki sɛtɔ nya ɔ́tɛyi mǝ nkǝ, “Mɔmɔɔ, be ele bǝ mfi mi mmi eto betidi nkatesǝ ko kɛɛ? Ntsyǝ bente kɛɛ? ");
INSERT INTO lip_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Bete fe bekpefi kɛkɛ ba laakpe kɔyɛ lǝ obia. Mǝ bǝtsyuǝ lɛ kudu bokpo katɛyi mǝ bǝtsyuǝ bǝ, ‘Búsǝ kusiǝkpakpa eto ǝsǝ bútǝ mi, fɛɛ bíenwui kewui! Búsǝ keku eto ǝsǝ bútǝ mi, tsya bíenwi nku.’ ");
INSERT INTO lip_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ntuflǝsǝtidi Yohanes ǝbǝ, nya ókle kɛnyɛ, nya wǝnnǝ ntǝ saa tsya, fɛɛ bɛlɛ bɔtɛyi biǝ, ‘Lɛwɔnɔ bua si wǝ lǝ ǝsuǝ.’ ");
INSERT INTO lip_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Nya Utidi Eto Ubi tsya díbǝ nya wǝǝ, údi únǝ. Nya bɛnlɛ bɔtɛyi biǝnkǝ, ‘Bebe udikpu ku utǝnǝ ǝmfoo! Uyifo mba laafo umǝnko ku babuayifo eto ɔyɛtsyuǝ!’ ");
INSERT INTO lip_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Fɛɛ betidi ba kenke lǝǝtǝkǝko Onanto eto kobe kamaa, balɛ bulǝkǝ kate lǝ mǝ eyifosa ǝsuǝ bǝ nnya ni kobe tinti nɛ.” ");
INSERT INTO lip_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Farisinyǝ utsyuǝ ákpadi Yesu nkǝ ubǝ udi lesa lǝ wǝ diyo. Nya se Yesu dísu mfóo, úsiǝ kasɔ lǝ ɔpunu ɔflɔ nkǝ lǝ udi lesa. ");
INSERT INTO lip_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Usio wǝ dísiǝ nkpǝ bua utsyuǝ akɛ lǝ umǝ ǝmǝ. Nyaso se ɔ́nɔ nkǝ Yesu ǝbǝ Farisinyǝ ǝmǝ eto diyo lesakedikɔɔ, úfi nnuǝbi bo laanyi fififi bo nkpe lǝ dituntu nǝ laanɔ bobe ǝsuǝ úsuko mfó. ");
INSERT INTO lip_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Úsu úńyǝ lǝ Yesu ɔflɔ nya úwi binǝntu okpo wǝ lǝ akpa. Nya usio ǝmǝ dífi wǝ disi eto sɛwɔni ɔ́si binǝntu bia lékpo lǝ Yesu eto akpa mfoo, nya ɔ́kɔbe wǝ akpa ɔnlɛ bɔfiɔ ku lelabi. Nya úfi nnuǝbi bomǝ ókpo lǝ Yesu eto akpa tsya. ");
INSERT INTO lip_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Se Farisinyǝ wǝ lékpadi Yesu dínyǝ nyamfoo, úbu disi ɔ́tɛyi nkǝ, “Lǝ utidi ǝmfo ete ni Onanto eto Unyɛlǝkǝtidi tintii, eni ele bǝ ote usio wǝ eto okle díbǝ ɔnlɛ wǝ butidi mfo, eni óte nkpǝ bua bo tsya unsi!” ");
INSERT INTO lip_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Nya Yesu lɛtɛyi wǝ nkǝ, “Simon, nkpe lesatsyuǝ nǝ minla miǝ matɛyi fǝ.” Nya Simon lɛtɛyi nkǝ, “Oteasa, tɛyi mɛ.” ");
INSERT INTO lip_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesu ǝtsyǝ kasɔ ɔ́tɛyi Simon nkǝ, “Utidi utsyuǝ ákɛ mfo wǝ díkaba atabi ukǝtǝ betidi, nya betidi inuǝ bǝtsyuǝ dísiǝ wǝ kayo. Ɔni dísiǝ wǝ sika eto atabi akpi alofa anɔ. Nnya unuǝfǝ dísiǝ wǝ atabi akpi fosi anɔ. ");
INSERT INTO lip_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Se kulesa dímǝtsyǝ mǝ boofo kayo kamǝ esoo, úfi kayo kamǝ kenke ɔ́tsyɛ mǝ. Nya betidi inuǝ bamfo eto ntii, owoe fafo fanɔ fǝ woola otabinyǝ ǝmfo oso?” ");
INSERT INTO lip_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Nya Simon lɛtɛyi wǝ nkǝ, “Mfo nnɔ miǝ utidi wǝ úfi kayo ka nso utu ɔ́tsyɛ.” Mfó nya Yesu lɛtɛyi wǝ nkǝ, “Átɛyi ɛlɛkɛ.” ");
INSERT INTO lip_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Yesu étsyi ɔwuninsǝ óbe usio ǝmǝ nya ɔ́tɛyi Simon nkǝ, “Alɛ usio ǝmfo bunyǝ? Se mímbǝ fǝ ɔflɔɔ, ǝmǝntǝ mɛ ntu fǝ mflǝ akpa. Fɛɛ usio ǝmfo éfi wǝ binǝntu úflǝ mɛ akpa, nya úfi wǝ disi eto sɛwɔni ɔ́si nnya. ");
INSERT INTO lip_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ámamfo mɛ ku disuǝyuǝ abuta mɛ alɛ. Fɛɛ idu lǝ lefe nǝ mímbǝ mfo, wóanyɛ tɔ mɔ akpa bɔlɛ kafiɔ. ");
INSERT INTO lip_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Fǝǝ, ǝmǝntǝ mɛ nnuǝbi saa fǝ mfi nkpo lǝ disi. Fɛɛ wǝ éfi nnuǝbi bo laanyi fififi ókpo mɛ lǝ akpa. ");
INSERT INTO lip_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Nyaso nlɛ fǝ bɔtɛyi minkǝ, lelabi nǝ úlǝkǝ óte mɛ esoo, ófo abua kpǝ nya úyifo kenke eto bufikatsyɛ. Nya utidi wǝ díyifo abua sɛkɛ béfi bátsyɛ wǝ, nko ke wǝ lelabi tsya lɛfɛ nɛ.” ");
INSERT INTO lip_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Mfó nya Yesu lɛtɛyi usio ǝmǝ nkǝ, “Befi fǝ abua batsyɛ fǝ.” ");
INSERT INTO lip_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Se betidi ba tsya dísiǝ lǝ kedikɔ mfo lɛnɔ Yesu eto asa nnya ɔ́tɛyii, batɔ mǝ ǝsuǝ bǝnkǝ, “Owoe ni nwǝ mfo wǝ laafo betidi eto abua kulaa tsya bufi katsyɛ?” ");
INSERT INTO lip_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Mfó ǝmǝ nya Yesu lɛtɛyi usio ǝmǝ nkǝ, “Fǝ bofokanɔ ǝlǝkǝ fǝ, nyaso du esu lǝ diyuǝ ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Nya lefe ditsyuǝ eto kamaa, Yesu átsyilama nti bomfo úsu kǝmǝ ku mbuto ntsyuǝ. Nya úkedi Ditiki Sɛɛ nǝmǝ itsyi lǝ Onanto eto sekakedikɔ ǝsuǝ. Batɔnkpe lefosi inuǝ ba úlǝkǝ tsya ǝtǝkǝko wǝ. ");
INSERT INTO lip_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Besio ba Yesu létsya bufi akpa akpa ku mba óla awɔnɔ bua úlǝkǝ lǝ mǝ ǝsuǝ eto bǝtsyuǝ tsya ǝkǝtǝkǝko wǝ. Nya utsyuǝ wǝ lɛkɛ lǝ mǝ nti ni Maria wǝ baakpo Magdalanyǝ nwǝ ǝsuǝ Yesu léla awɔnɔ bua akuanse úlǝkǝ. ");
INSERT INTO lip_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Usio bamba tsya ákɛ lǝ mǝ nti mfó wǝ baakpo bǝ Yohana nwǝ eto usǝ baakpo Kusa wǝ díyifo keyifo lǝ Oka Herodes eto lekpokakpokɔ nya údi uninǝ utsyuǝ wǝ díkabe mfó. Besio kpǝ bǝtsyuǝ ku nwǝ baakpo Susana tsya ǝtǝkǝko Yesu nya banlɛ mǝ asa bufi kawunsǝ ko wǝ ku wǝ bakasebi. ");
INSERT INTO lip_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Betidi kpǝ éketsyi kǝmǝ ate ate ate kǝbǝ Yesu ɔflɔ. Nnya lǝ lefe nǝ betidi kpǝ díbǝ bátsyaa, Yesu átɛyi mǝ lekpa nǝmfo nkǝ, ");
INSERT INTO lip_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ɔkuɛmfo utsyuǝ ésu nkǝ wǝǝsǝ eyibibi ǝtsyuǝ. Nya lefe nǝ ɔnlɛ eyibibi nyamǝ busǝǝ, íbǝ bǝ ǝtsyuǝ álo ekpo lǝ kusu nya betidi lémankli nya, nya baklɔbɛ lɛsɛ nnya bamini. ");
INSERT INTO lip_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ǝtsyuǝ tsya álo ekpo lǝ akpankplamboe ǝsuǝ. Nya se íkǝǝ, yǝnyǝ ntu ku sitǝ sɛɛ. Nyaso yɛylɔbe nya íkpǝ. ");
INSERT INTO lip_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Eyibibi nyamǝ ǝtsyuǝ édufǝ lǝ biyufa nti. Nya biyufa biamǝ lébe bíti eyibibi nyamǝ, nya békle nnya kenke itǝ íkpǝ. ");
INSERT INTO lip_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Nya abamba dísu ékpo lǝ kasɔ sɛɛ ǝsuǝ. Nya se íkǝǝ, ɛnwɔ ebibi alofa, alofa.” Mfó ǝmǝ nya Yesu lɛtɛyi mǝ nkǝ, “Nyaso fǝǝ ke ato nnya laanɔ asa nkpee, tsyue ato lǝ anɔ!” ");
INSERT INTO lip_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Yesu eto bakasebi átɔ wǝ lekpá nǝmfó eto kasɔ. ");
INSERT INTO lip_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Mfó ɔ́tɛyi mǝ nkǝ, “Onanto éfi wǝ sekakedikɔ eto asakulakula eto kobe útǝ mi. Fɛɛ betidi bambaa, akpá ǝsuǝ bɔɔnɔ nnya itǝ bǝ, ‘balɛ bunyǝ tsyaa, bembunyǝ. Nya balɛ bɔnɔ tsyaa, bǝmbǝ kasɔ bɔnɔ.’ ");
INSERT INTO lip_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Lekpá nǝ míntɛyi eto kasɔ ni bǝ, eyibibi nyamǝ ni Onanto eto ditiki. ");
INSERT INTO lip_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Nya eyibibi nnya díbǝ ekpo lǝ kusu ɔflɔ te fe betidi ba laanɔ, fɛ Obonsam ǝbǝ kǝlǝkǝ ditiki nǝmǝ lǝ mǝ akɔɛsi. Nya wǝǝtǝ nkǝ bembofo bofo kanɔ bǝ lǝ Onanto lǝ ofo mǝ bulǝkǝ. ");
INSERT INTO lip_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Nya, nnya díbǝ ékpo lǝ akpankplamboe ǝsuǝǝ, te fe betidi ba lɛnɔ ditiki nǝmǝ nya báfo ni ku disuǝyuǝ lamfolamfo, fɛɛ díendufǝ lǝ mǝ akɔɛsi sitinti. Nyaso baafo kanɔ itǝ lefe kliminti hã. Nya lǝ lefe nǝ botokabe sɛkɛ díbǝ mǝ lǝ ǝsuǝǝ, bǝǝtǝ disi. ");
INSERT INTO lip_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Eyibibi nya lékpo lǝ biyufa ntii, te fe betidi ba laanɔ ditiki nǝmǝ, fɛɛ kawunsiǝ eto bulǝ ku kǝ asa eto bɔbɛbɛ ku kawunsiǝ kamfo eto kamini eesensǝ keti mǝ, nya yǝǝntǝ kusu bǝ ebibi nyamǝ be, ɛsɛ lǝ balɛ nnya. ");
INSERT INTO lip_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Nya eyibibi nnya díbǝ ékpo lǝ kasɔ sɛɛ ǝsuǝǝ, te fe betidi ba laanɔ ditiki nǝmǝ nya baafo ni kakpe lǝ utu kǝmiǝ. Nya baabokosǝ ǝsuǝ kasɔ nya bǝǝńyǝ kekleke isu ese lǝ kalosǝkɔ itǝ bǝ baawɔ ebibi kpǝ. ");
INSERT INTO lip_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Utidi kuutsyuǝ anto okandiɛ kefi asa keti wǝ nye ufi wǝ usu okpe lǝ lesa kalɔ. Bomu weefi wǝ kǝtǝkǝ lǝ wǝ kǝtǝkǝkɔ kaka betidi ba lǝǝbǝ mfó luunyǝ asa wuee. ");
INSERT INTO lip_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Lesa saa nǝ béfi bákula lǝ kalebe saa, ebɔbɔ lǝ lekple bǝnyǝ. Nya lesa nǝ ke béti bákpee, ebɔbɔ lǝ lekple bǝnyǝ. ");
INSERT INTO lip_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Bebe ǝsuǝ kukɔnɔ lǝ etiki nnya bianɔ ǝsuǝ. Utidi wǝ ke asa ntee, buusi bǝtǝ wǝ bawunsǝ. Nya utidi wǝ ke kulesa lentee, nnya úbu nkǝ ite wǝ tsyaa, bɔɔlɛ nnya bafo wǝ lǝ ani.” ");
INSERT INTO lip_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yesu eto bayimi ku mǝ ambe ǝbǝ wǝ ɔflɔ, fɛɛ bamfó kusu bunyǝ bǝnyǝ Yesu itsyi lǝ sitiditu sia eso. ");
INSERT INTO lip_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Utidi utsyuǝ ésu ɔ́tɛyi Yesu nkǝ, “Fǝ ambe ku fǝ bayimi ńyǝ lǝ lekple balɛ fǝ bɔbɛbɛ.” ");
INSERT INTO lip_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Mfó nya Yesu lɛtɛyi mǝmblɛ nkǝ, “Mɔ ambe ku mɔ bayimi ni mba laanɔ Onanto eto ditiki nya beeyifo lǝ ni ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Diyi lɔnii, Yesu édufǝ ɔklɔ kafo ku wǝ bakasebi. Mfó nya ɔ́tɛyi mǝ nkǝ, “Bitǝ lǝ bɔyila ditumbukplɛ nǝmǝ busu lekpake nǝ nse.” Nyaso bédu bésu. ");
INSERT INTO lip_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Se bányɛ lǝ ntu bomǝ ǝsuǝ bantɔɔ, Yesu álabe selabe. Nya lǝ lefe nǝmǝ ǝsuǝǝ, ufiebi étsyiko bɔsɔ kekleke nya ntu dítsyiko bɔsɔ kedufǝ lǝ ɔklɔ ǝmǝ kafo itǝ bǝ bédufǝ lǝ ukpǝ ku mǝnkpǝ eto nti. ");
INSERT INTO lip_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Bakasebi bamǝ ésu básanklisǝ Yesu nya bátɛyi wǝ bǝnkǝ, “Boanto! Boanto! Boǝbǝ bukpǝ!” Mfó nya Yesu létaka úńyǝ nya óto ɔkɔɛ uti ufiebi ku ntu bo nlɛ bonwa kakpanka, nya nyamblɛ díyuǝ kɛnyɛ nya lesa saa diyuǝ kanana. ");
INSERT INTO lip_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Nya ɔ́tɔ bakasebi bamǝ nkǝ, “Beso bimbǝ bofokanɔ?” Fɛɛ iyifo mǝ naa, nya sikpi tsya dímuǝ mǝ. Nya bátɔ mǝ bǝtsyuǝ bǝnkǝ, “Owoe ko ni utidi ǝmfo? Woedi ufiebi ku lekpo etiki nya yetsyue wǝ koto!” ");
INSERT INTO lip_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yesu ku wǝ bakasebi áyila bésu bédufǝ Gadara eto kasɔ lǝ ditumbukplɛ eto lekpake nǝ nkpiɔ Galilea eto kasɔ. ");
INSERT INTO lip_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Se Yesu lɛbɔ lǝ ɔklɔ ǝmǝ ǝsuǝ koo, osani utsyuǝ wǝ awɔnɔ bua nsi lǝ ǝsuǝ étsyi umǝ ǝmǝ úbǝ ótsyako wǝ. Yóofo lefe kpǝ se utidi ǝmfo díkayɛ leyaleya katsyilama. Nya wóakatɔnɔ nkǝ woǝsiǝ lǝ diyo enso lǝ edi nti. ");
INSERT INTO lip_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Se únyǝ Yesuu, ófa nya óto wǝ ǝsuǝ ókpo lǝ kasɔ lǝ Yesu eto akɔ. Nya ɔ́tɔ wǝ bembembe nkǝ, “Yesu, Onanto Fanlofanlo eto Ubi! Be nkpe lǝ bonko ku fǝ lenti mfo? Nlɛ fǝ lekpakpa, mǝnnǝ mɛ koto!” ");
INSERT INTO lip_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Utidi ǝmfo átɛyi nyamfo, itsyise Yesu áto ɔkuɛ ókpe lɛwɔnɔ nǝ nsi lǝ wǝ ǝsuǝ mfó, nya ɔ́tɛyi ni nkǝ, “Bɔ wǝ lǝ ǝsuǝ!” Lefe kpǝ lǝ lɛwɔnɔ nǝmǝ ǝsiǝ utidi ǝmǝ lǝ ǝsuǝǝ, lǝ bákle wǝ ani ku akpa kulaa tsya bákpe wǝ lǝ amanaa, úkǝfǝsǝ amana nyamǝ nya lɛwɔnɔ nǝmǝ díkǝnǝ wǝ kesuko mfiminti. ");
INSERT INTO lip_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesu átɔ wǝ nkǝ, “Ntsyǝ baakpo fǝ?” Mfó nya útǝ mbuayɛ nkǝ, “Mɔ baakpo bǝ Omantsya.” Ɔ́tɛyi nko itsyise awɔnɔ bua kpǝ dídufǝ ísiǝ wǝ lǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Mfóo, awɔnɔ bua nyamǝ álɛ Yesu lekpakpa yǝnkǝ woanla nnya otsyese kaka awɔnɔ bua lǝǝsiǝ kǝnyǝ kanyi. ");
INSERT INTO lip_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Mfóo, bakplako kpǝ ǝńyǝ lǝ kɔtini ǝsuǝ békedi. Nya awɔnɔ bua nyamǝ lɛlɛ Yesu lekpakpa bǝnkǝ utǝ lǝ bedufǝ lǝ bakplako bamǝ ǝsuǝ. Nya Yesu dítǝ mǝ kusu. ");
INSERT INTO lip_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Nyaso bábɔ lǝ utidi ǝmǝ ǝsuǝ nya bédufǝ lǝ bakplako bamǝ ǝsuǝ. Nya mǝmblɛ dítsyetsyi báwunini lǝ kɔtini komǝ eto kotosi nya bédufǝ lǝ ditumbukplɛ nǝmǝ nya bánya bátsylɔ kenke. ");
INSERT INTO lip_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Lefe nǝ betidi ba díkabe bakplako bamǝ dínyǝ asa nnya díbǝ mfóo, bétsyetsyi bésu bátɛyi betidi ba lɛkɛ lǝ umǝ ku mbuto bo letsylama mfó kenke. ");
INSERT INTO lip_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Nya betidi bamǝ lɛbɔ bésu bǝ lǝ besu babe lesa nǝ díbǝ. Nya se bésu báyo Yesu ɔflɔɔ, bǝnyǝ osani wǝ ǝsuǝ Yesu léla awɔnɔ bua utsyiko nya unsi lǝ Yesu eto akɔ untǝkǝ ǝnǝ wuee nya onkpe awu lǝ ǝsuǝ unsi kpoo. Mfóo, mǝmblɛ áte sikpi. ");
INSERT INTO lip_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Betidi ba dínyǝ kase asa nyamfó díbǝǝ, átɛyi mba mfó kase Yesu létsya utidi wǝ ǝsuǝ awɔnɔ bua dísiǝ fɛ íkakpa wǝ. ");
INSERT INTO lip_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Lǝ nyamfo esoo, Gadare eto kasɔ eto betidi átɛyi Yesu bǝnkǝ udu lǝ mǝ kasɔ, itsyise sikpi ǝmuǝ mǝ tinti. Nyaso Yesu édufǝ lǝ ɔklɔ údu. ");
INSERT INTO lip_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mfó nya utidi wǝ ǝsuǝ Yesu léla awɔnɔ bua úlǝkǝ álɛ Yesu lekpakpa nkǝ, “Tǝ kusu lǝ ntǝkǝko fǝ.” Fɛɛ Yesu mántɔnɔ nya ɔ́tɛyi wǝ nkǝ, ");
INSERT INTO lip_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Sinkli esu oto lǝ esu atɛyi lesa nǝ Onanto diyifo útǝ fǝ.” Lǝ nyaso utidi ǝmfó ésu ɔ́yɛ lǝ kǝmǝ ka nkpe mfó úkatɛyi asa nnya kenke Yesu díyifo útǝ wǝ. ");
INSERT INTO lip_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Lefe nǝ Yesu dísinkli úsu ɔ́yila ditumbukplɛ nǝ nkpe mfó, betidi bamfó áfo wǝ kukɔnɔ, itsyise mǝmblɛ ǝsiǝ bákabe wǝ kusu. ");
INSERT INTO lip_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Mfó nya osani wǝ baakpo Yairo wǝ lídi Yudafɔ eto katsyakɔ eto uninǝ ɔni ǝbǝ óse akonki lǝ Yesu eto akɔ nya ɔ́lɛ wǝ lekpakpa nkǝ utǝkǝko wǝ lǝ besu wǝ diyo, ");
INSERT INTO lip_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","itsyise wǝ ubisiobi ɔni wǝ díkafo fe alɛ lefosi ǝnuǝ, labe ɔlɛ bufi nya okpe lǝ ukpǝ ku mǝnkpǝ eto nti. Se Yesu lɛyɛ ɔntɔɔ, betidi kpǝ ǝtǝkǝko wǝ báma wǝ bákpe. ");
INSERT INTO lip_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Nya lǝ betidi bamfó ntii, usio wǝ kɔtɔ díkakpo itǝ lefosi alɛ ǝnuǝ sɔ̃ɔ̃ tsya akɛ mǝ lenti. Usio ǝmfo ábiasǝ wǝ atabi kenke nkǝ lǝ otsya wǝ bufi bomǝ, fɛɛ ókplatsya ɔ́nɔ. ");
INSERT INTO lip_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ɔ́yɛ buɛɛ lǝ Yesu eto kama lǝ betidi nti nya útidi wǝ awu eto kotosi. Lamfolamfo kɔtɔ komǝ áyɛ wǝ bokpo. ");
INSERT INTO lip_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Mfó nya Yesu lɛtɔ nkǝ, “Owoe dítidi mɛ?” Fɛɛ kuutsyuǝ saa mántɔnɔ. Mfó nya Petro lɛtɛyi wǝ nkǝ, “Boanto, be kase betidi kpǝ ntǝkǝko fǝ nya bama fǝ bakpe!” ");
INSERT INTO lip_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Tsyaa, Yesu átɛyi nkǝ, “Nnyi miǝ utidi utsyuǝ étidi mɛ, itsyise ǝsuǝale ǝtsyuǝ ábɔ lǝ mɛ ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Se usio ǝmǝ léte nkǝ wǝmbofo ǝsuǝ bɔbiɔsǝ esoo, útsyiko butinkǝ nya óse akonki ókpe disi kasɔ lǝ Yesu eto akɔ. Mfó nya ɔ́tɛyi lesa nǝ eso útidi Yesu eto awu lǝ betidi ba kenke eto ǝnǝmi. Nya úlǝkǝ ɔ́tɛyi lesa nǝ eso útidi wǝ awu ku kase bufi bomǝ lɛyɛ wǝ lamfolamfo. ");
INSERT INTO lip_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Lǝ nyamfo eso Yesu átɛyi wǝ nkǝ, “Mɔ ubisiobi, fǝ bofokanɔ átsya fǝ. Su lǝ diyuǝ ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Lefenǝ Yesu nsi ɔnlɛ etiki budii, ɔtɔyɛ ɔni ǝbǝ údufǝ wǝ dítsyi Yudafɔ eto katsyakɔ eto uninǝ wǝ baakpo Yairo ɔflɔ. Nya úbǝ ɔ́tɛyi wǝ nkǝ, “Fǝ ubisiobi ǝmǝ ébukpǝ koko, nyaso yɛ oteasa ǝmǝ bulǝ.” ");
INSERT INTO lip_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Fɛɛ Yesu ánɔ ditiki nǝmǝ nya ɔ́tɛyi Yairo nkǝ, “Mante sikpi. Fǝ fo anɔ fǝ ubi ǝmǝ ebɔkɛ ale.” ");
INSERT INTO lip_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Lǝ lefe nǝ bésu bédufǝ Yairo eto diyo mfóo, wǝntǝ utidi saa kusu nkǝ udufǝ diyo kafo enso Petro ku Yohanes ku Yakobo ku ubisiobi ǝmǝ eto anto ku ambe hã. ");
INSERT INTO lip_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Nya betidi kpǝ díńyǝ mfó banlɛ nku buwi ku kudu lǝ ubi ǝmǝ eso. Mfó nya Yesu lɛtɛyi mǝ nkǝ, “Biensiwi keku. Ubi ǝmǝ mǝnkpǝ. Selabe ete ɔnlɛ.” ");
INSERT INTO lip_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Mfóo, nya mǝmblɛ dímǝ wǝ, itsyise mǝ yi bǝnkǝ úkpǝ. ");
INSERT INTO lip_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Yesu ákɔbe wǝ lǝ kɔni nya ókpadi wǝ nkǝ, “Ubi, taka ǝńyǝ!” ");
INSERT INTO lip_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Usiobi ǝmǝ ésinkli úbǝ nkpǝ nya ótaka úńyǝ lamfolamfo. Nya Yesu lɛtɛyi mǝ nkǝ bǝtǝ ubisiobi ǝmǝ lesatsyuǝ lǝ udi. ");
INSERT INTO lip_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Asa nyamfo kenke éyifo wǝ antomǝ yanii, fɛɛ Yesu ǝkǝ mǝ ato nkǝ bantɛyi utidi saa lesa nǝ díbǝ mfó. ");
INSERT INTO lip_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Lǝ nyamfó eto kamaa, Yesu ákpadi wǝ bakasebi lefosi inuǝ bamfó óboko wǝ akɔ nya útǝ mǝ kusu ku ǝsuǝale lǝ befi bala awɔnɔ bua kenke ku lǝ batsya efimbi akpa akpa tsya. ");
INSERT INTO lip_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Nya óla mǝ ótsyese nkǝ besu bedi betidi etiki itsyi lǝ Onanto eto sekakedikɔ ǝsuǝ lǝ batsya befimfi bufi. ");
INSERT INTO lip_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Fɛ booduu, Yesu átɛyi mǝ nkǝ, “Bientsyi kulesa bisuko lǝ mi esu bɔyɛ ǝsuǝ fe uyilɛlɛ nye fe mba laadia asa eto katobe nye didisa nye atabi. Nya bientsyi akpesa bamba kulaa tsya. ");
INSERT INTO lip_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Diyo nǝ kee baafo mii, bisiǝ mfó isu ese lefe nǝ ke biudu lǝ umǝ ǝmǝ. ");
INSERT INTO lip_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Nya kaka ke bamfo mii, bidu lǝ umǝ ǝmfó lǝ bɛflɛ mi akpa eto utembu bekpo mfó. Nyamfo loote Onanto eto kotonǝnǝ eto ditsyǝbi nǝ lǝǝbǝ bubǝ itǝ lǝ umǝ ǝmǝ.” ");
INSERT INTO lip_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Nya bakasebi bamǝ dídu bésu bátsyilama mbuto bomǝ kenke nya bédi Onanto eto Ditiki Sɛɛ nǝmǝ, bátsya befimfi kalebe saa tsya. ");
INSERT INTO lip_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Se Oka Herodes wǝ nlɛ seka budi lǝ Galilea eto kasɔ lɛnɔ asa nnya kenke nlɛ bubǝǝ, wǝ nsusu ǝlǝ wǝ itsyise betidi bǝtsyuǝ lɛ bɔtɛyi bǝnkǝ Ntuflǝsǝtidi Yohanes ni nwǝ disi ótaka utsyi ɔkɔmǝ úbǝ nkpǝ. ");
INSERT INTO lip_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Nya bǝtsyuǝ tsya nlɛ bɔtɛyi bǝnkǝ Elia ni nwǝ disi úsinkli úbǝ. Nya bǝtsyuǝ tsya nlɛ bɔtɛyi bǝnkǝ Onanto eto bǝnyɛlǝkǝtidi koko bǝtsyuǝ eto ɔni uni wǝ dísinkli úbǝ nkpǝ. ");
INSERT INTO lip_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Mfó nya Oka Herodes lɛtɛyi nkǝ, “Mɔ dítǝ kusu miǝ bala Yohanes eto disi, nyaso owoe uni wǝ disi úbǝ ɔnlɛ asa nyamfo buyifo nya maanɔ wǝ diye mfo?” Nyaso Oka Herodes kábɛbɛ kusu ko wɔɔyɛ lǝ unyǝ Yesu. ");
INSERT INTO lip_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Se bakasebi bamǝ dísinkli bǝbǝ bátɛyi Yesu lesa saa nǝ béyifo. Mfó nya ókpa mǝ hã ɔ́yɛnko nya bédu bésu umǝ wǝ baakpo Betsaida. ");
INSERT INTO lip_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Se betidi kpǝ lɛnɔ nkoo, bǝtǝkǝko wǝ bésu mfó. Yesu tsya áfo mǝ nya údi mǝ etiki utsyi lǝ Onanto eto sekakedikɔ ǝsuǝ, nya ótsya mba bufi nlɛ bulǝ. ");
INSERT INTO lip_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Se kale nlɛ boloo, lefosi bakasebi inuǝ bamǝ ǝbǝ Yesu ɔflɔ nya bátɛyi wǝ bǝnkǝ, “Tǝ lǝ betidi bamfo lǝ bedu lǝ besu mbuto bo nkpe lǝ lekpake mfó, lǝ babɛbɛ lesa ku kasɔnɔkɔ, itsyise mfo eyifo ntɛnti.” ");
INSERT INTO lip_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Nya Yesu lɛtɛyi mǝ nkǝ, “Bitǝ mǝ lesatsyuǝ lǝ bedi.” Mfó nya bátɛyi wǝ bǝnkǝ, “Didisa nǝ bɔnlɛ mfo eyifo abolo anɔ ku akpɛ ǝnuǝ. Ala fǝ busu boya lesa boboko betidi kpenkpe bamfo?” ");
INSERT INTO lip_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Nya basani bamǝ eyifo akpi anɔ. Mfó nya Yesu lɛtɛyi wǝ bakasebi nkǝ, “Bitǝ lǝ betidi bamǝ lǝ bǝsiǝ lǝ etsyukpa etsyukpa fe betidi awosi anɔ anɔ.” ");
INSERT INTO lip_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Nya se bakasebi bamǝ ditǝ bǝsiǝ nko, ");
INSERT INTO lip_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yesu éfi abolo anɔ ku akpɛ ǝnuǝ nyamǝ nya óbesǝ wǝ ǝnǝmi kato. Ɔ́sɔ Onanto ani, úbudi nnya nya úfi útǝ wǝ bakasebi nkǝ befi besiǝ bǝtǝ betidi bamǝ. ");
INSERT INTO lip_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nya mǝmblɛ dídi bémi nya bakasebi bamǝ lɛsɛ nnya wɛlɛwɛlɛ díbu nya íyi etsyitsya lefosi ǝnuǝ. ");
INSERT INTO lip_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Diyi lɔni se Yesu mate nlɛ ola botoo, wǝ bakasebi ǝbǝ wǝ ɔflɔ. Nya ɔ́tɔ mǝ nkǝ, “Owoe betidi laatɛyi bǝ wǝ mini?” ");
INSERT INTO lip_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Mfó nya bǝlǝkǝ kɛnyɛ bátɛyi bǝnkǝ, “Bǝtsyuǝ aatɛyi bǝnkǝ fǝ ni Ntuflǝsǝtidi Yohanes. Betsyuǝ tsya bǝ Elia. Nya bǝtsyuǝ laatɛyi bǝ Onanto eto unyɛlǝkǝtidi koko eto ɔni wǝ disi úsinkli úbǝ nkpǝ feni.” ");
INSERT INTO lip_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Mfó nya ɔ́tɔ mǝ nkǝ, “Nya mimii, owoe biebu biǝ wǝ mini?” Mfó nya Petro dítǝ mbuayɛ nkǝ, “Fǝ ni Nwǝ Onanto Lékpo Ɔhile Utsyǝ.” ");
INSERT INTO lip_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yesu ǝkǝ mǝ ato kekleke nkǝ bántɛyi utidi saa ditiki nǝmfo. ");
INSERT INTO lip_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Yesu esi ɔ́tɛyi mǝ nkǝ, “Ele bǝ ibǝ bǝ mɔ, Utidi Eto Ubi, nyǝ kanyi tinti lǝ beninǝ ku besumunyǝ eto beninǝ ku afi eto bateasa eto ani nya bɔɔni mɛ boolo mɛ. Fɛɛ lǝ diyi tsyǝfǝ esuǝǝ, Onanto ebotakasǝ mɛ utsyiko ɔkɔmǝ mbǝ nkpǝ.” ");
INSERT INTO lip_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Mfó nya ɔ́tɛyi mǝmblɛ kenke nkǝ, “Lǝ utsyuǝ ala nkǝ wǝǝtǝkǝko mɛɛ, ele bǝ ulǝkǝ wǝ ato ku wǝ ǝsuǝ utsyiko lǝ wǝ alasa ǝsuǝ nya lǝ utsyi wǝ uyikabie utǝkǝko mɛ diyi saa. ");
INSERT INTO lip_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Itsyise utidi saa wǝ laala nkǝ waata wǝ disi eto nkpǝ, woonyansǝ mu. Nya utidi saa wǝ loonyansǝ wǝ nkpǝ nkǝ lǝ utǝkǝko mɛ, wuunyǝ nkpǝ manlo. ");
INSERT INTO lip_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Nte kutǝkǝ ko utidi luunyǝ lǝ únyǝ kawunsiǝ ka kenke eto bikǝ nya ónyansǝ wǝ nkpǝ manlo? ");
INSERT INTO lip_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Lǝ mɔ ku mɔ asa nnya maate kenke álɛ utidi utsyuǝ kofanii, wǝ tsya ebɔlɛ Utidi Eto Ubi kofani lǝ lefe nǝ uubǝ lǝ wǝ diyǝnde ku wǝ Anto eto diyǝnde ku batɔnkpe kɛnkɛ kenke eto diyǝnde ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nlɛ mi bɔtɛyi sitinti minkǝ mi bǝtsyuǝ ba nkpe mfoo, embukpǝ isu ese lefe nǝ bǝnyǝ Onanto sekadidi siamǝ.” ");
INSERT INTO lip_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Fe Kɔsida kɔni eto kama se Yesu lɛtɛyi nyamfoo, ókpa Petro ku Yohanes ku Yakobo ɔ́yɛnko bésu bábe kɔtini besu ko disinti ola katokɔ. ");
INSERT INTO lip_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Se ɔnlɛ ola botoo, wǝ ǝnǝmi eto ditsyǝbi afloma nya wǝ awu nnya onkpe léfloma iflubi futututu ɛnlɛ boto lǝ ǝnǝmi. ");
INSERT INTO lip_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Lamfolamfoo, betidi inuǝ bǝtsyuǝ ǝbǝ bǝńyǝ lǝ wǝ ɔflɔ ba ni Moses ku Elia nya banlɛ wǝ etiki budinko. ");
INSERT INTO lip_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Bábɔ ku Onanto eto sekakedikɔ eto diyǝnde nya bédi etiki ku Yesu itsyi lǝ kusu ko diyifo Onanto eto lelabi nkǝ ɔyɛ lǝ ko ǝsuǝ lǝ ukpǝ lǝ Yerusalem. ");
INSERT INTO lip_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petro ku wǝ bǝtsyuǝ álabe selabe sio sio sio, tsya básankli bǝnyǝ diyǝnde kplɛ nǝ ǝsuǝ Yesu lɛkɛ ku betidi inuǝ ba wonko mǝ díńyǝ mfó. ");
INSERT INTO lip_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Se betidi inuǝ bamfo nlɛ budu lǝ Yesu flɔɔ, Petro átɛyi Yesu nkǝ, “Bonamute, bo mfo bubǝ alɛkɛ itǝ bo tinti! Tǝ lǝ boto ebu ǝtsyǝ mfo. Lɔni itǝ fǝ, lɔni itǝ Moses, nya lɔni tsya itǝ Elia.” Nya asa nnya ɔnlɛ bɔtɛyi mfo kenkee, wóante lefe nǝ ɔ́tɛyi nnya tsya. ");
INSERT INTO lip_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Lefe nǝ úńyǝ ɔnlɛ etiki budii, lɛtɔntɔ ábɔ díti mǝ kenke. Nya bakasebi bamǝ léte sikpi lǝ lefe nǝ lɛtɔntɔ nǝmfo léba lékpo mǝ lǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Mfó ǝmǝ bánɔ ɔkɔɛ utsyuǝ lǝ lɛtɔntɔ nǝmǝ kafo wǝ lɛtɛyi nkǝ, “Nyǝ nwǝ mfo ni mɔ Ubi Wǝ Bákpo Ɔhile Bǝtsyǝ. Bitsyue wǝ ditiki koto!” ");
INSERT INTO lip_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Se ditiki eto ɔkɔɛ ǝmǝ lélaa, bǝnyǝ bǝnkǝ Yesu mate ete díńyǝ mfó. Bakasebi bamǝ éfi nnya bǝnyǝ mfó bákula, bántɛyi utidi saa nnya kulesa lǝ lefe nǝmǝ. ");
INSERT INTO lip_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Se kale dísiǝǝ, Yesu ku wǝ bakasebi itsyǝ bamǝ áyifǝ betsyi kɔtini komǝ ǝsuǝ bǝbǝ kasɔ. Nya bǝbǝ bétu betidi kpǝ bǝtsyuǝ. ");
INSERT INTO lip_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Mfó ǝmǝ nya osani utsyuǝ léfa ɔ́tɛyi nkǝ, “Oteasa! Nlɛ fǝ lekpakpa, be mɔ ubi ǝmfo! Wǝ ete ni mɔ ubi nɛ! ");
INSERT INTO lip_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Lɛwɔnɔ bua ditsyuǝ ǝsiǝ wǝ lǝ ǝsuǝ nya diǝtǝ woafa bembembe. Diǝtinkǝsǝ wǝ kekleke kǝmuǝ wǝ kasɔ lǝ kasɔ nya waafo afabe nya efu laabɔ wǝ lǝ kɛnyɛ. Yeeyifo wǝ nko kekleke kaklɛ fɛ lɛwɔnɔ nǝmǝ laataka lǝ wǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nlɛ fǝ bakasebi lekpakpa minkǝ bala lɛwɔnɔ bua nǝmǝ bǝtǝ mɛ, fɛɛ bámfo ni bola.” ");
INSERT INTO lip_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Mfó nya Yesu lɛtɛyi mǝ nkǝ, “Mi mmi eto betidi, beso biamfo mɛ kanɔ nya bitidi ato mmǝ? Nte lefe nǝ eto okle ele bǝ mfi nkɛ mi lǝ ɔflɔ isu ese? Nya nte lefe nǝ sɔ̃ɔ̃ ele bǝ nkpe utu ntǝ mi fɛ lǝ ndu mi lǝ ɔflɔ.” Nya ɔ́tɛyi osani ǝmǝ nkǝ, “Kpa fǝ ubi ǝmǝ aboko mfo.” ");
INSERT INTO lip_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Kase ubi ǝmǝ nlɛ bubǝ koo, lɛwɔnɔ nǝmǝ ko dísiǝ wǝ lǝ ǝsuǝ dímuǝ wǝ lɛsɔ lǝ kasɔnti nya dítinkǝsǝ wǝ. Mfó nya Yesu díti lɛwɔnɔ nǝmǝ kusu nya ótsya ubi ǝmǝ nya úfi wǝ útǝ wǝ anto. ");
INSERT INTO lip_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Onanto eto ǝsuǝale kplɛ nyamfo éyifo betidi bamfó kenke yanii. Yesu eto eyifosa kenke édufǝ mǝ lǝ ǝsuǝ iyifo mǝ yanii lǝ lefe nǝ Yesu lɛtɛyi wǝ bakasebi nkǝ, ");
INSERT INTO lip_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Bianta lesa nǝ mǝǝbǝ mi bɔtɛyi ǝsuǝ! Nyamblɛ ebubǝ itǝ itsyi lǝ Utidi Eto Ubi ǝsuǝ, buufi wǝ bakpe lǝ betidi eto ani.” ");
INSERT INTO lip_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Fɛɛ wǝ bakasebi bamǝ mánnɔ asa nyamfo eto kasɔ. Iyifo lesa nǝ béfi bákula mǝ, fɛɛ báte sikpi lǝ kase bɔɔtɔ wǝ lesatsyuǝ itsyi lǝ nnya ǝsuǝ lǝ banɔ kasɔ. ");
INSERT INTO lip_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Kǝnǝ kǝtsyuǝ ǝbǝ kédufǝ lǝ bakasebi bamǝ nti itsyi lǝ futsyuǝ ni ɔkplɛnyǝ onso lǝ mǝ nti. ");
INSERT INTO lip_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Nya se Yesu léte mǝ nsusu esoo, úfi dikpefi ditsyuǝ úbǝ úńyǝnsǝ lǝ mǝ ǝnǝmi. ");
INSERT INTO lip_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Mfó nya ɔ́tɛyi mǝ nkǝ, “Utidi wǝ ke loofo dikpefi nǝmfo lǝ mɔ diye ǝsuǝǝ, ófo mintsya. Nya utidi wǝ loofo mɛɛ, oofo utidi wǝ létsyese mɛ. Itsyise utidi wǝ laabokosǝ ǝsuǝ kasɔ kenke lǝ mi ntii, wǝ ni utidi wǝ nso kenke nɛ.” ");
INSERT INTO lip_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Mfó ǝmǝ nya Yohanes lɛtɛyi wǝ nkǝ, “Bonamute, búnyǝ utidi ɔni wǝ nlɛ awɔnɔ bua bola kǝlǝkǝ lǝ fǝ diye ǝsuǝ nya bɔ́tɛyi wǝ boǝnkǝ úsinkli ɔyɛ, itsyise umbǝ bo lenti.” ");
INSERT INTO lip_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Mfó nya Yesu lɛtɛyi wǝ bakasebi bamǝ nkǝ, “Bienti wǝ kusu, bete biǝnkǝ uńyǝ mi kama.” ");
INSERT INTO lip_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Nya se lefe nǝ ele bǝ Onanto kpa Yesu usuko kato nlɛ boyoo, Yesu áse uyi nkǝ wuusu Yerusalem. ");
INSERT INTO lip_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ótsyese batɔnkpe bǝtsyuǝ nkǝ bátɔ bésu umǝ utsyuǝ wǝ nkpe lǝ Samaria eto kasɔ lǝ besu bǝmuǝ ǝsuǝ bǝtsyǝ itǝ wǝ bubǝ. ");
INSERT INTO lip_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Fɛɛ se umǝ ǝmfo eto betidi léte bǝ wɔɔyɛ mfo ofe lǝ ɔtɔ lǝ Yerusalem esoo, bámfo wǝ. ");
INSERT INTO lip_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Mfó se bakasebi ba ni Yohanes ku Yakobo dínyǝ nko esoo, bátɔ Yesu bǝnkǝ, “Bonamute, aala fǝ bokpadi ute utsyi kato ubǝ ɔtsylɔsǝ mǝ?” ");
INSERT INTO lip_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Mfó nya Yesu lɛtsyi ɔ́wuninsǝ, úyenki ókpe mǝ. ");
INSERT INTO lip_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Nya Yesu ku wǝ bakasebi bamǝ léfe bésu umǝ bamba. ");
INSERT INTO lip_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Se banyɛ bantɔɔ, osani utsyuǝ átɛyi Yesu nkǝ, “Muutǝkǝko fǝ nsu kaka ke fantɔ.” ");
INSERT INTO lip_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Mfó ǝmǝ nya Yesu lɛtɛyi wǝ nkǝ, “Nkpaflɔbɛ kpe ǝbiǝ nnya kafo baalabe, nya baklɔbɛ nkpe ayo. Fɛɛ Utidi Eto Ubi ǝmbǝ kaka wuuluǝ wǝ disi.” ");
INSERT INTO lip_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Nya Yesu lɛtɛyi utidi bamba nkǝ, “Tǝkǝko mɛ.” Fɛɛ utidi ǝmfo nkǝ, “Bonamute, tǝ mɛ kusu lǝ nsu mbikǝ mɔ anto fɛ.” ");
INSERT INTO lip_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Mfó ǝmǝ nya Yesu lɛtɛyi wǝ nkǝ, “Tǝ mba nsi nkpǝ fe bekpǝnkpǝ lǝ besu bebikǝ mǝ bekpǝnkpǝ tsyuǝ. Nya mii, bisu bikatɛyi Onanto eto sekakedikɔ eto ditiki nǝmǝ.” ");
INSERT INTO lip_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Utidi ɔni tsya nkǝ, “Bonamute, muutǝkǝko fǝ. Fɛɛ tǝ mɛ kusu lǝ nsu nkla mɔ betidi fɛ.” ");
INSERT INTO lip_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Mfó nya Yesu lɛtɛyi wǝ nkǝ, “Nwǝ ditsyǝ keyifo kasɔ ku dinwuǝ, fɛ weesinkli kabe kamaa, mǝńyǝ utǝ keyifo kǝtǝ Onanto eto sekakedikɔ.” ");
INSERT INTO lip_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Lǝ nyamfo eto kamaa, Bonamute ǝlǝkǝ betidi fosi akuanse ku inuǝ bamba nya óla mǝ ótsyese inuǝ, inuǝ nkǝ besu kǝmǝ ku mbuto bo útsyue útsyǝ nkǝ lǝ usu ɔyɛ ofe. ");
INSERT INTO lip_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Nya ɔ́tɛyi mǝ nkǝ, “Bɛkuɛnkǝ bia díkayo bulǝkǝ fui, fɛɛ beyifoyifo bamǝ emfui. Nyaso bɛlɛ ɔkuɛnsate ǝmǝ lekpakpa lǝ otsyese beyifoyifo lǝ bǝbǝ bawunsǝ lǝ bǝlǝkǝ bɛkuɛnkǝ biamǝ. ");
INSERT INTO lip_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Bisu! Nlɛ mi botsyese fe asamubi lǝ bekiti eto nti. ");
INSERT INTO lip_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Bientsyi atabitobe nye asatɔtɔ eto katobe nye afokpa, nya biǝnńyǝ lǝ kusu bisiǝsǝ kuutsyuǝ saa. ");
INSERT INTO lip_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Diyo saa biudufǝ, bisiǝsǝ mǝ bɛtɛyi biǝnkǝ, ‘Diyuǝ itǝ diyo nǝmfo ku ni betidi.’ ");
INSERT INTO lip_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Nya lǝ utidi utsyuǝ wǝ laala diyuǝ kpe lǝ mfóo, bitǝ lǝ mi diyuǝ lǝ ditǝkǝko futsyǝ ǝmǝ. Fɛɛ lǝ kuutsyuǝ saa ǝmbǝ lǝ mfóo, bidu ku mi diyuǝ eto kǝsiǝ kamǝ. ");
INSERT INTO lip_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Bisiǝ lǝ diyo nǝ ke bɛsɔnɔ. Nya lesa saa nǝ ke boofi bǝtǝ mi, bidi lǝ binǝ faa. Itsyise uyifoyifo saa, ǝńyǝ itǝ kayofofo. Biekedu lǝ diyo lɔni bisu lebamba. ");
INSERT INTO lip_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Nya umǝ saa wǝ báfo mii, bidi lesa saa nǝ bootǝ mi. ");
INSERT INTO lip_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Betsya befimfi ba nkpe lǝ umǝ ǝmǝ. Nya bɛtɛyi umǝ ǝmǝ eto betidi biǝnkǝ, ‘Onanto eto sekakedidi ebɔfi mi.’ ");
INSERT INTO lip_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Fɛɛ lǝ bisu umǝ utsyuǝ nya báni bámfo mii, bidu bisu obia nti lǝ bɛtɛyi biǝnkǝ, ");
INSERT INTO lip_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Mi umǝ ǝmfo eto utembu bo nkpo bo lǝ akpa kulaa tsyaa, nnyǝ mu bɔ́flɛ bókpo mi mfo. Fɛɛ bekloma biǝ Onanto eto sekadidi eto lefe ebɔfi mi!’ ");
INSERT INTO lip_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nya nlɛ mi bɔtɛyi sitinti kekleke minkǝ lǝ diyi nǝ bookponko betidi lekpo ayoo, Onanto ebunyǝ Sodom eto umǝ kulaa tsya kaminsǝ eso umǝ ǝmfo. ");
INSERT INTO lip_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Mbɔbɔɛ mǝǝtǝ mi Korasimfɔ! Nya mbɔbɔɛ mǝǝtǝ mi Betsaidafɔ! Itsyise lǝ ayanisa nnya mínyifo lǝ mi nti ete mínyifo lǝ Tiro ku Sidon eto kǝmǝ bua inii, eni bǝsiǝ lǝ kasɔ, béfi afianku báyimi, bédiki ntɔ lǝ ǝsuǝ, nnya léte bǝnkǝ báni abua nnya béyifo! ");
INSERT INTO lip_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Onanto ebunyǝ Tiro ku Sidon eto kǝmǝ kaminsǝ eso mi lǝ Lekpoyi ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Nya fǝ Kapernaum eto umǝ, bubu fanlɛ fǝ babesǝ fǝ ku fǝ betidi kato eso? Bɔɔtsylɔsǝ mi, bato mi bakpe lǝ ute!” ");
INSERT INTO lip_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Mfó nya Yesu lɛtɛyi wǝ bakasebi nkǝ, “Utidi wǝ ke lɔɔnɔ mi ditikii, mɔ ditiki ɔnɔ. Nya utidi saa wǝ lɛni mii, mɔ ɔ́ni. Nya utidi saa wǝ lɛni mɛ, wote nkǝ ɔ́ni Onanto wǝ létsyese mɛ.” ");
INSERT INTO lip_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Betidi fosi akuanse ku inuǝ bamǝ ésinkli bǝbǝ ku disuǝyuǝ. Nya bǝbǝ bátɛyi wǝ bǝnkǝ, “Bonamute, awɔnɔ bua kulaa tsya étsyue bo ditiki koto se bóla nnya búlǝkǝ lǝ fǝ diye ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesu átɛyi mǝ nkǝ, “Nnyǝ Obonsam se ófankli útsyi kato úbǝ kasɔ fe ofamfa seka. ");
INSERT INTO lip_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Bɛnɔ kukɔnɔ! Ntǝ mi ǝsuǝale bǝ biofo buńyǝ lǝ bawa ku bakpoe ǝsuǝ. Ku lǝ beso olontidi eto ǝsuaǝle kenke ani nya kulesa saa embuyifo mi. ");
INSERT INTO lip_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Fɛɛ yenyifo mi disuǝyuǝ bǝ awɔnɔ bua etsyue mi ditiki ato. Bomu binyǝ disuǝyuǝ bǝ Onanto áwɔni mi aye ókpe lǝ wǝ sekakedikɔ kato.” ");
INSERT INTO lip_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Lǝ lefe nǝmfo ǝsuǝǝ, Lɛwɔnɔ Kɛnkɛ ákpe disuǝyuǝ lǝ Yesu ǝsuǝ kenke nya Yesu lɛtɛyi nkǝ, “Anto, kato ku kasɔ eto Onamute, maasɔ fǝ ani, itsyise asa nnya féfi fákula bekuente ku babesibe, ǝlǝkǝ nnya áte mba lenni kulesa ku mba nte fe bekpefi. Sitintii, Anto, nko nkpe fǝ ɔkɔɛ nɛ.” ");
INSERT INTO lip_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Nya usi ɔ́tɛyi nkǝ, “Mɔ Anto éfi asa nnya kenke utǝ mɛ. Kuutsyuǝ saa enyi nwǝ ni Onanto eto Ubi ǝmǝ, enso Onanto mate hã. Nya kuutsyuǝ saa lenyi utidi wǝ Anto ǝmǝ tsya ni, enso wǝ Ubi ɔni kplo wǝ mate hã ku betidi ba Ubi ǝmǝ dílǝkǝ nkǝ bate Anto ǝmǝ tsya.” ");
INSERT INTO lip_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Nya Yesu lɛtsyi ɔ́wuninsǝ óbe wǝ bakasebi bamǝ nya ɔ́tɛyi mǝ mate buɛɛ nkǝ, “Ǝsuǝ yuǝ mi sitinti bǝ bɛlɛ asa nnya bɛnlɛ bunyǝ mfo bunyǝ! ");
INSERT INTO lip_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nlɛ mi bɔtɛyi minkǝ, Onanto eto bǝnyɛlǝkǝtidi kpǝ ku baka tsya ála bǝ lǝ bǝnyǝ lesa nǝ bɛnlɛ bunyǝ, fɛɛ bǝnnyǝ, nya lǝ bánnɔ lesa nǝ bɛnlɛ bɔnɔ, fɛɛ bɔ́nnɔ.” ");
INSERT INTO lip_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Kɔfi eto oteasa utsyuǝ ǝbǝ nkǝ woato Yesu obe. Nya ɔ́tɔ wǝ nkǝ, “Oteasa, be ele bǝ nyifo fɛ lǝ nyǝ nkpǝ manlo?” ");
INSERT INTO lip_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesu ǝtǝ mbuayɛ ɔ́tɔ wǝ nkǝ, “Be Asawɔniwɔni Kɛnkɛ eto Kukue lɛtɛyi? Nya ntsyǝ faanɔ ditiki nǝmǝ kasɔ?” ");
INSERT INTO lip_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Nya osani ǝmǝ dítǝ mbuayɛ nkǝ, “La Bonamute Onanto ku fǝ utu kenke, ku fǝ lɛwɔnɔ kenke ku fǝ ǝsuǝale kenke ku fǝ nsusu kenke tsya, nya laala fǝ ɔyimitsyuǝ fe fǝ ǝsuǝ ke.” ");
INSERT INTO lip_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Mfó nya Yesu lɛtɛyi wǝ nkǝ, “Átɛyi ɛlɛkɛ nko. Yifo nko ete ebunyǝ nkpǝ manlo.” ");
INSERT INTO lip_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Fɛɛ se kɔfi eto oteasa ǝmǝ léla lǝ utǝ wǝ ǝsuǝ lɛbɛ esoo, usi ɔ́tɔ Yesu nkǝ, “Owoe ni mɔ ɔyimitsyuǝ?” ");
INSERT INTO lip_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Mfó nya Yesu dítǝ mbuayɛ nkǝ, “Lefe ditsyuǝ nǝ léfe mǝǝ, osani utsyuǝ étsyi Yerusalem ɔ́tɔ lǝ Yeriko nya beyu dímuǝ wǝ lǝ kusu. Báblɛ wǝ nya bǝlǝkǝ wǝ bikǝ kenke lǝ ǝsuǝ nya báyani wǝ betsyǝ mfó lǝ ukpǝ ku mǝnkpǝ eto nti. ");
INSERT INTO lip_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Íbǝ bǝ Onanto eto usumunyǝ utsyuǝ ǝbǝ ɔlɛ bɔyɛ kafe lǝ kusu komǝ mfó. Fɛɛ se únyǝ utidi ǝmfo lǝ kusu ɔflɔ, ɔ́yɛ lǝ lekpake bamba fe údu. ");
INSERT INTO lip_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Nko kǝ Lewinyǝ, utsyuǝ tsya díbǝ ɔ́yɛ mfo ɔnlɛ bofe. Nya se únyǝ osani ǝmǝ, wuntsya áyɛ lǝ ɔflɔ bamba ófe údu. ");
INSERT INTO lip_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Fɛɛ Samarianyǝ utsyuǝ wǝ dibǝ ɔ́yɛ lǝ kusu mfo ɔnlɛ bofe, ǝbǝ útu utidi ǝmǝ. Nya se únyǝ wǝ, wǝ asa ǝnǝ wǝ kafo. ");
INSERT INTO lip_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ɔ́yɛ úsu wǝ ɔflɔ nya úfi nnuǝbi ku ntǝ ókpo lǝ wǝ afabe nyamǝ ǝsuǝ nya ókle nnya kenke, nya útsyi osani ǝmǝ útǝkǝ lǝ wǝ ubuki ǝsuǝ. Nya úfi wǝ úsuko bafɔ eto kasɔnɔkɔ nya ɔ́lɛ wǝ ola óbe wǝ. ");
INSERT INTO lip_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Se kale disiǝ, úlǝkǝ atabi ǝtsyuǝ útǝ nwǝ laabe bafɔ eto kasɔnɔkɔ kamǝ nya ɔ́tɛyi wǝ nkǝ, ‘Kalɛ wǝ ola. Nya lǝ nsinkli mbǝ nlɛ bofe mfoo, moofo fǝ lesa nǝ ke fesi fábiasǝ lǝ wǝ bobe ǝsuǝ.’ ” ");
INSERT INTO lip_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Mfó ǝmǝ nya Yesu lɛtɔ afi eto oteasa ǝmǝ nkǝ, “Nya lǝ fǝ nsusu ǝsuǝ, betidi itsyǝ bamfo nti eto owoe lǝ fǝ ǝnyǝsa ǝsuǝ, ni utidi wǝ didufǝ lǝ bewudifɔ bamfo eto ani eto ɔyimitsyuǝ?” ");
INSERT INTO lip_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Afi eto oteasa ǝmǝ ǝtǝ mbuayɛ nkǝ, “Utidi wǝ dinyǝ wǝ kaminsǝ.” Nya Yesu lɛtɛyi wǝ nkǝ, “Fintsya su lǝ esu eyifo nko.” ");
INSERT INTO lip_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Se Yesu ku wǝ bakasebi lɛyɛ lǝ kusu bantɔ, bésu bedufǝ kebuto kǝtsyuǝ. Usio utsyuǝ wǝ baakpo Marta ákpa wǝ úsuko wǝ diyo. ");
INSERT INTO lip_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ɔyimisio utsyuǝ akɛ Marta wǝ baakpo Maria. Usio ǝmfo ǝsiǝ lǝ Yesu ɔflɔ nya ɔnlɛ wǝ asa nnya ɔnlɛ bote bɔnɔ. ");
INSERT INTO lip_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Diyo bobe eto asa nnya dísu ítǝkǝ lǝ Marta mate ǝsuǝ étsyiko wǝ bulǝ. Nya úbǝ ɔ́tɛyi Yesu nkǝ, “Bonamute, yenyifo fǝ kulesa bǝ mɔ ɔyimisio áyani diyo bobe eto asa buyifo nyamfó kenke utǝkǝ mɛ lǝ ǝsuǝ? Tɛyi wǝ lǝ ubǝ ɔwunsǝko mɛ!” ");
INSERT INTO lip_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Nya Yesu lɛtɛyi wǝ nkǝ, “O Marta! Be kase fanlɛ ǝsuǝ bulǝ lǝ asa kpǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Fɛɛ lesa lɔni ete loohiã bǝ babɛbɛ. Nya lesa nǝmǝ ni nǝ Maria dílǝkǝ nɛ. Nya bensiembofo ni lǝ wǝ ani.” ");
INSERT INTO lip_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Diyi lɔnii, Yesu ákɛ lǝ kalebe kǝtsyuǝ ókato ola. Se ólosǝ, wǝ bakasebi eto ɔni, ǝbǝ wǝ ɔflɔ úbǝ ɔ́tɛyi wǝ nkǝ, “Bonamute, te bo kase buukato ola fe kase Yohanes léte wǝ bakasebi.” ");
INSERT INTO lip_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Mfó nya Yesu lɛtɛyi mǝ nkǝ, “Lǝ bɛlɛ ola botoo, bɛtɛyi biǝnkǝ, ‘Bo Anto, tǝ lǝ bakpasǝ fǝ diye. Fǝ sekadidi lǝ sibǝ. Beyifo lǝ fǝ lelabi ǝsuǝ lǝ kasɔ mfo fe kase inte kato. ");
INSERT INTO lip_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Tǝ bo bo diyi saa eto didisa. ");
INSERT INTO lip_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Nya lǝ efi bo abua atsyɛ bo, fe kase bo tsya leefi katsyɛ utidi saa wǝ laata bo kebu. Nya mǝntǝ lǝ budufǝ lǝ botokabe ǝsuǝ nya le ǝlǝkǝ bo etsyiko lǝ abua ǝsuǝ.’ ” ");
INSERT INTO lip_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Nya Yesu lɛtɛyi wǝ bakasebi nkǝ, “Lǝ ibǝ bǝ mi nti eto utsyuǝ áyɛ úsu wǝ ɔyɛtsyuǝ eto diyo ku ntsyenti úsu ɔ́tɛyi wǝ nkǝ, ‘Ɔyɛtsyuǝ, dia ǝlǝmbo ǝtsyǝ ǝtsyuǝ ǝtǝ mɛ, ");
INSERT INTO lip_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","itsyise mɔ ɔyɛtsyuǝ ɔni etsyi kusu ubǝ ɔsɔnɔ mɛ mɔmɔ. Nya didisa saa ente muutǝ wǝ!’ ");
INSERT INTO lip_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Nya fǝ ɔyɛtsyuǝ ǝmǝ lɛtɛyi fǝ nkǝ, ‘Mǝmbǝ ǝlǝ mɛ! Bonko mɔ bebi ebolabe nya búti siku lǝ diyo. Mensi embofo botaka mɔmɔ kǝbǝ kǝtǝ fǝ kulesa.’ ");
INSERT INTO lip_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Lǝ íbǝ bǝ ɔ́tɛyi nkoo, be ni lesa nǝ fuuyifo? Nlɛ mi bɔtɛyi minkǝ lǝ mǝ sɛyɛtsyuǝ mate esoo, wǝmbotaka. Fɛɛ lǝ kase fǝnyǝ fanlɛ wǝ lekpakpa bɔlɛ hã esoo, wootaka utǝ fǝ lesa saa nǝ fanlɛ bɔbɛbɛ. ");
INSERT INTO lip_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Bɛtɔ asa lǝ befi bǝtǝ mi. Bɛbɛbɛ asa lǝ binyǝ. Bɛsɔ siku lǝ basini mi. ");
INSERT INTO lip_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Itsyise utsyuǝ saa wǝ laatɔ asaa, bǝǝtǝ wǝ. Nya utsyuǝ saa wǝ laabɛbɛɛ, wǝǝnyǝ. Nya utsyuǝ saa wǝ laasɔ sikuu, bɔɔsini wǝ. ");
INSERT INTO lip_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Nya mimba ni bebiantomǝǝ, biefi owa kǝtǝ lǝ lɛkpɛ nǝ ubi lɛtɔ mi eto kɛnyɛ? ");
INSERT INTO lip_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Nye okpoe bomu biefi kǝtǝ wǝ lǝ dikusɛmfɔ nǝ ɔ́tɔ eto kɛnyɛ? ");
INSERT INTO lip_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Mimba ni babuayifo kulaa tsya yi kase buifi asa sɛɛ bitǝ mi bebi. Nya ntsyǝ yuutsyǝ ku Boanto wǝ nkpe kato itǝ bo? Ntsyǝ yoofó bubǝ bǝ wǝmbufi wǝ Lɛwɔnɔ Kɛnkɛ utǝ betidi ba laatɔ wǝ?” ");
INSERT INTO lip_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Lefe lɔnii, Yesu ákala lɛwɔnɔ bua nǝ lǝǝndi etiki ketsyiko lǝ osani utsyuǝ ǝsuǝ. Nyaso se lɛwɔnɔ nǝmǝ lɛbɔ lǝ utidi ǝmǝ ǝsuǝ ko, utidi ǝmǝ étsyiko etiki budi. Nyamfo éyifo betidi ba díńyǝ mfó yanii. ");
INSERT INTO lip_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Fɛɛ mǝ bǝtsyuǝ átɛyi bǝnkǝ, “Awɔnɔ bua kenke eto uninǝ wǝ baakpo Beelsebul eto ǝsuǝale ǝsuǝ woafo nya bola kǝlǝkǝ lǝ betidi ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Nya bǝtsyuǝ tsya léla bǝ baato Yesu babe eso bátɛyi wǝ bǝnkǝ úyifo ayanisa ǝtsyuǝ lǝ ulǝkǝ ote nkǝ Onanto ɔflɔ utsyi. ");
INSERT INTO lip_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Fɛɛ Yesu wǝ ate mǝ nsusu lǝ wǝ ǝsuǝ. Nyaso ɔ́tɛyi mǝ nkǝ, “Sekakedikɔ saa sia lema akpa akpa nya mǝ sɔ̃ɔ̃ nlɛ bɔkpɔ lǝ bǝtsyuǝ ǝsuǝ, sekakedikɔ siamfo eboba. Nya diyo nǝ ke eto betidi lǝǝńyǝ lǝ bǝtsyuǝ ǝsuǝ, diyo nǝmǝ eboba. ");
INSERT INTO lip_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Nyaso lǝ boma kpe lǝ Obonsam eto sekakedikɔɔ, ntsyǝ fɛ wǝ sekakedikɔ siamǝ luunyǝ? Bɛlɛ bɔtɛyi biǝnkǝ maala awɔnɔ bua kǝlǝkǝ ɛyɛ lǝ Beelsebul eto ǝsuǝale nnya wǝǝtǝ mɛ eso. ");
INSERT INTO lip_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Nya lǝ Beelsebul ǝsuǝ maala mǝǝ, bawoe ǝsuǝ mba ntǝkǝko mi laayɛ kala awɔnɔ bua kǝlǝkǝ lǝ betidi ǝsuǝ? Mi kosate eto mba ntǝkǝko mi lɛ bulǝkǝ kate nkǝ bidia baatɛyi. ");
INSERT INTO lip_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Owo lo! Onanto eto ǝsuǝale bomu ǝsuǝ maala awɔnɔ bua kǝlǝkǝ. Nyalɛ nyamfo lɛ bulǝkǝ kate mi wuee nkǝ, Onanto eto sekakedidi ébubǝ sékpe lǝ mi nti koko. ");
INSERT INTO lip_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Lǝ ǝsuǝaletidi utsyuǝ ǝmuǝ ǝsuǝ ku wǝ bemamakǝ uńyǝ ɔlɛ wǝ diyo bosee, te fǝ bike bia nte wǝ embonya. ");
INSERT INTO lip_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Fɛɛ lǝ utidi wǝ nkpe ale nso wǝ ǝbǝ nkǝ woakpɔ ku wǝ nya óso wǝ anii, woalɛ wǝ bemamakǝ bia ǝsuǝ ufi wǝ disi utǝkǝ kafo nya woalɛ utidi ǝmǝ eto bikǝ kafo kesiǝ kǝtǝ bǝtsyuǝ. ");
INSERT INTO lip_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Utidi wǝ ke lǝmbǝ lǝ mɔ lekpakee, te fǝ uńyǝ lǝ mɛ ǝsuǝ sitinti. Nya utidi wǝ ke laankpa asa kǝtsyǝ ditsyu ku mɛ, te fǝ ɔlɛ nnya busense kewi. ");
INSERT INTO lip_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Lǝ lɛwɔnɔ bua ábɔ lǝ utidi ǝsuǝǝ, diesu katsyilama nlebe nlebe bo lekoe kabɛbɛ kaka diɔkɛ ditsyǝ ɔnwɛ. Nya lǝ díǝnnyǝ kedufǝkɔɔ, diatɛyi ǝsuǝ nkǝ, ‘Muusinkli nsu mɔ diyo nǝ mínsiǝ kɔ.’ ");
INSERT INTO lip_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Nyaso diesinkli kesu kabe ǝkǝnyǝ nkǝ bákpa diyo nǝmǝ kafo kɛnkɛnkɛ nya lesa saa nte kukɔnɔ. ");
INSERT INTO lip_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Lǝ nnya esoo, diabɛbɛ awɔnɔ bua akuanse nnya nkpe disiale enso ni nya bǝǝbǝ bǝ lǝ bǝsiǝ mfo. Lǝ kalosǝkɔ, utidi ǝmfo eto nkpǝ bo woǝsiǝ abia kaso mbo úsiǝ kɔ kulaa tsya.” ");
INSERT INTO lip_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Lefe nǝ Yesu lɛtɛyi asa nyamfoo, usio utsyuǝ wǝ lɛkɛ lǝ betidi bamǝ nti áfa bembembe ɔ́tɛyi nkǝ, “Onanto lǝ okpo usio wǝ lélé fǝ ku nwǝ dítǝ fǝ lɛmi fáyimi atsyɔ!” ");
INSERT INTO lip_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Nya Yesu dítǝ mbuayɛ nkǝ, “Betidi ba laanɔ Onanto eto ditiki nya beeyifo lǝ ni ǝsuǝ, mǝ bomu ele bǝ bǝnyǝ disuǝnyuǝ nɛ!” ");
INSERT INTO lip_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Nya se betidi bamǝ dítsyiko bufui lǝ Yesu ǝsuǝǝ, úsukosǝ nya ɔ́tɛyi mǝ nkǝ, “Bebe kase mi mmi eto betidi nkpe sibusufɔ! Ayanisa eto bulǝkǝ kate nya baala bǝ bǝǝnyǝ, fɛɛ bembunyǝ anyinisa saa enso nya díbǝ lǝ Yona ǝsuǝ seka. ");
INSERT INTO lip_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Fe kase Onanto eto unyɛlǝkǝtidi Yona eto ale díbǝ itǝ lǝ Ninivefɔ ǝsuǝǝ, nko ke Utidi eto Ubi tsya eto ale luubǝ fe ditsyǝbi itǝ mmi eto betidi nɛ. ");
INSERT INTO lip_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Nya lǝ diyi fɛfɛ eto Lekpoyi ǝsuǝǝ, Besio eto Oka wǝ dítsyi Ɔnwɛdikue ebotaka uńyǝ nya woote mi lɛnimi lǝ lɛwɔ olo mi dikpi, itsyise ótaka útsyi lǝ wǝ kasɔ ka letso famfamfa úsu nkǝ lǝ ɔnɔ Oka Salomo eto kobetete eto asa. Fɛɛ nlɛ mi bɔtɛyi minkǝ utidi wǝ nso Salomoo, wǝ ni nwǝ mfo nɛ. ");
INSERT INTO lip_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ninivefɔ ebotaka bǝńyǝ lǝ Lekpoyi Fɛfɛ ǝsuǝ nya boolo mi mmi eto betidi bamfo dikpi. Itsyise lefe nǝ Yona lɛtɛyi mǝ Onanto eto ditikii, bátsyi báwuninsǝ nya báyɛ mǝ abua buyifo. Fɛɛ nlɛ mi bɔtɛyi sitinti minkǝ, utidi ɔni utsyuǝ kpe lǝ mi nti mfo wǝ lɛmɔ onso Yona kulaa tsya! ");
INSERT INTO lip_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Utidi kuutsyuǝ saa anto okandiɛ kefi kakula nye kakpe lǝ asa kalɔ. Bomu weefi wǝ kǝtǝkǝ lǝ wǝ kǝtǝkǝkɔ kaka betidi ba lǝǝbǝ mfó luunyǝ asa wue. ");
INSERT INTO lip_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Utidi eto ǝnǝmi eyifo fe okandiɛ itǝ wǝ utidi ǝmǝ. Lǝ fǝ ǝnǝmi ǝnyǝ asa kukɔnɔɔ, fǝ utidi ǝmǝ kenke tsya, yuutǝ ǝnyǝ asa ekpa kenke. Fɛɛ lǝ fǝ ǝnǝmi ǝmbǝ kɔnɔɔ, te fǝ fǝ utidi ǝmǝ kenke kpe lǝ ketuntu ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Nyaso lɔ abe fǝ ǝsuǝ kukɔnɔ bǝ diyǝnde nǝ nkpe fǝ lǝ ǝsuǝ mamfiani ketuntu. ");
INSERT INTO lip_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Lǝ diyǝnde akpasǝ fǝ ǝsuǝ kenke nya fǝ kukalebe saa lǝmbǝ lǝ ketuntu ǝsuǝǝ, te fǝ fǝ kalebe saa ebunyǝ lekpasǝ fe kase okandiɛ lǝǝyǝnde nya wǝ diyǝnde laakpo fǝ lǝ ǝsuǝ seka.” ");
INSERT INTO lip_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Se Yesu dídi etiki ólosǝǝ, Farisinyǝ ɔni utsyuǝ ákpadi wǝ nkǝ ubǝ udi lesa lǝ wǝ diyo. Mfó nya úsu úsiǝ lǝ kasɔ lǝ diyo nǝmǝ lǝ udi lesa. ");
INSERT INTO lip_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Íyifo Farisinyǝ ǝmǝ buɛ se únyǝ nkǝ Yesu mǝmflǝ kɔni fe kase mǝ lekpa lete fɛ útsyiko budi. ");
INSERT INTO lip_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Nyaso Bonamute Yesu átɛyi wǝ nkǝ, “Mɔmɔɔ, mi Farisifɔ biǝflǝ mi kedikpɛ ku akɔbe eto kama, fɛɛ lǝ ɔnukualɛ ǝsuǝǝ, biyi ku lefomfi ku asa buayifoyifo sɔ̃ɔ̃. ");
INSERT INTO lip_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Bieninǝ! Inni Onanto ǝmǝ ete ni nwǝ díyifo asa nnya kenke eto kafo ku kama lee ntsyǝ? ");
INSERT INTO lip_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Bifi lesa saa nǝ nkpe lǝ mi kakpɛ ku akɔbe kafo bitǝ bakombo bǝ lǝ mi lesa saa lǝ ele kɛnkɛnkɛ lǝ Onanto eto ǝnǝmi. ");
INSERT INTO lip_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Mbɔbɔɛ mǝǝtǝ mi Farisifɔ! Biefi mi edisa ku mi nyoma eto bekolenkǝ ku seko ku afantosi akpa akpa, nnya laanyi fififi eto lekpafosile kǝtǝ Onanto. Fɛɛ bɛni asa sɛɛ buyifo lǝ kɔnukualɛsu ǝsuǝ nya biannla Onanto tsya. Nyamfo ni lesa nǝ ele bǝ biyifo bɛkɔ lǝ nnya bímfi bɛnlɛ buyifo koko, nya yanle bǝ bilǝkǝ ku kuǝtsyuǝ bitsyɛ kama. ");
INSERT INTO lip_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Mbɔbɔɛ mǝǝtǝ mi Farisifɔ! Itsyise biala biǝ biǝsiǝ lǝ nsiǝkɔ kplɛ bo nso lǝ ntsyakɔ. Nya biala biǝ betidi kǝsiǝsǝ mi ku dibu lǝ obia. ");
INSERT INTO lip_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Mbɔbɔɛ mǝǝtǝ mi, itsyise bite fe edi nnya mbikǝ lǝ kasɔ bǝǝnyǝ kǝtsyǝ lekpo, nya betidi laayɛ lǝ nnya ǝsuǝ kafe itsyise baante nko.” ");
INSERT INTO lip_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Mfó ǝmǝ kɔfi eto oteasa ɔni lǝ mǝ nti átɛyi wǝ nkǝ, “Oteasa, lǝ atɛyi nyamfo nkoo, áka bontsya.” ");
INSERT INTO lip_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Nya Yesu dítǝ wǝ mbuayɛ nkǝ, “Mbɔbɔɛ mǝǝtǝ mi afi eto bateasa tsya. Itsyise bietsyisǝ betidi bikǝ bia bembofo butsyi. Nya biemfi nsusu kabe biǝ biawunsǝko mǝ lǝ mi butsyi ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Mbɔbɔɛ mǝǝtǝ mi sitinti, itsyise béto edi kukɔnɔ bitǝ Onanto eto bǝnyɛlǝkǝtidi. Fɛɛ Onanto eto bǝnyɛlǝkǝtidi bamfoo, lǝ ɔnukualɛ ǝsuǝǝ, mi bana mǝ lélo mǝ. ");
INSERT INTO lip_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Nya mi kosatee, bɛtɔnɔ lǝ nyamfo ǝsuǝ biǝ lesa nǝ mi anto mǝ díyifo álɛkɛ. Mǝ lélo Onanto eto bǝnyɛlǝkǝtidi bamǝ nya mi léto mǝ edi. ");
INSERT INTO lip_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Nyamfo eso Onanto lǝ wǝ kobetete ǝsuǝ lɛtɛyi nkǝ, ‘Mootsyese mɔ bǝnyɛlǝkǝtidi ku batɔnkpe nya boolo mǝ bǝtsyuǝ nya bootǝkǝko bǝtsyuǝ kama.’ ");
INSERT INTO lip_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Nyaso mi mmi eto betidi kenkee, boonǝ mi koto lǝ Onanto eto bǝnyɛlǝkǝtidi ba kenke bálo idu taa kawunsiǝ eto kasɔ ketsyikokɔ kǝ. ");
INSERT INTO lip_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Idu lefe nǝ bálo Abel ibǝ eyo Sakaria wǝ bálo lǝ kedikǝtǝkɔ eto leba ku kakɛnkɛkɔ eto nti. Sitinti minlɛ mi bɔtɛyi minkǝ, Onanto ebunǝ mi, mmi eto betidi ato lǝ nyamfo kenke eso! ");
INSERT INTO lip_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Mbɔbɔɛ mǝǝtǝ mi kɔfi eto bateasa! Itsyise diyo nǝ kafo kobe nkpee, bíti ni siku bílǝkǝ safui bídunko. Fɛɛ mi kosate áni biǝ biembudufǝ lǝ ni kafo. Nya bieti betidi bamba ba nlɛ bokplatsya bǝ beedufǝ lǝ ni tsya kusu.” ");
INSERT INTO lip_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Se Yesu dídu lǝ kaka mfóo, Farisifɔ ku kɔfi eto bateasa étsyiko bunyǝnki nya bátɔ wǝ etiki kpǝ ku lɛblɔfi. ");
INSERT INTO lip_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Nya banlɛ kusu bɔbɛbɛ lǝ kase bɔɔyɛ bǝmuǝ wǝ lǝ wǝ ditiki ǝsuǝ bǝ ɔtɛyi kabua. ");
INSERT INTO lip_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Se betidi akpi akpi bǝtsyuǝ díbǝ bátsya mfóo, itǝ bǝ bétsyiko bǝtsyuǝ bukǝ kamanklii, Yesu étsyiko wǝ bakasebi etiki budi katɛyi nkǝ, “Bebe sinini lǝ Farisifɔ eto bidiabidia eto asayifoyifo nnya laayansǝ betidi ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Lesa saa nǝ betidi díyifo bákula, ǝbɔbɔ lǝ lekple utidi saa nyǝ wuǝ, nya akulasa saa ǝbɔbɔ bate. ");
INSERT INTO lip_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Nyaso lesa saa nǝ ke bátɛyi lǝ kaka lenaa, diɔbɔ lǝ lekple banɔ. Nya asa nnya bátɛyi lǝ kawɛ ǝsuǝ lǝ diyo kǝmiǝǝ, boolǝkǝ nnya babe letsya utsyuǝ saa nɔ. ");
INSERT INTO lip_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Bayɛtsyuǝ, nlɛ mi bɔtɛyi minkǝ, bianté sikpi betidi ba laafo etidisuǝ ete bolo nya bensiembofo kulesa buyifo lǝ nnya kama. ");
INSERT INTO lip_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Utidi wǝ ele bǝ bete sikpii, muulǝkǝ wǝ nte mi. Bete sikpi Onanto wǝ lǝ ólo fǝ ólosǝǝ, nya unsi onkpe ǝsuǝale uufi fǝ oto okpe lǝ ditefɛnku nǝ lǝǝnyǝ lefe saa kǝmiǝ. Befo mɛ bɛnɔ biǝ, wǝ ni utsyuǝ ele bǝ bete sikpi nɛ. ");
INSERT INTO lip_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Inni pɛsewa inuǝ ete baate ntsyuɛ nnɔɔ? Fɛɛ Onanto anta mǝ kuutsyuǝ saa ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Mi disi eto sɛwɔni kulaa tsya, Onanto yi se leklambi. Nyasoo, biensite sikpi itsyise befo koya beso baklɔbɛ kpǝ. ");
INSERT INTO lip_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Nlɛ mi bɔtɛyi kasini minkǝ, utidi wǝ ke lɔɔtɛyi lǝ betidi eto ǝnǝmi nkǝ uyifo mɔ olee, Utidi Eto Ubi tsya ebofo wǝ fe wǝ ole lǝ Onanto eto batɔnkpe eto ǝnǝmi. ");
INSERT INTO lip_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Fɛɛ utidi wǝ lɔɔni mɛ lǝ betidi eto ǝnǝmii, Utidi Eto Ubi tsya ebɔni wǝ lǝ Onanto eto batɔnkpe kenke eto ǝnǝmi. ");
INSERT INTO lip_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Nya utidi saa wǝ lɔɔtɛyi lesatsyuǝ uńyǝ lǝ Utidi Eto Ubi ǝsuǝǝ, Onanto ebufi ɔtsyɛ wǝ. Fɛɛ utidi wǝ luudi mbusiotiki lǝ Lɛwɔnɔ Kɛnkɛ ǝsuǝǝ, Onanto embufi nnya ɔtsyɛ wǝ kulefe. ");
INSERT INTO lip_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Lǝ ibǝ bǝ bakpa mi besuko Yudafɔ eto katsyakɔ nye baka eto ǝnǝmi bǝ baakponko mi lekpoo, biǝntǝ lǝ ilǝ mi lǝ lesa nǝ biusu bɛtɛyi ǝsuǝ nye kase biota mi ǝsuǝ disi. ");
INSERT INTO lip_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Itsyise Lɛwɔnɔ Kɛnkɛ ebote mi lesa nǝ biɔtɛyi lǝ lefe nǝmǝ ayo.” ");
INSERT INTO lip_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Utidi utsyuǝ ákɛ mfo lǝ betidi nti wǝ lɛtɛyi Yesu nkǝ, “Oteasa, tɛyi mɔ ɔyimi fǝnkǝ usie bo anto eto bikǝ bia utsyǝ bo lǝ mfo mɔ bele.” ");
INSERT INTO lip_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Mfó Yesu dítǝ mbuayɛ nkǝ, “Osani, owoe dítǝ mɛ kusu nkǝ nsie bikǝ nye nyifo okponkpo lǝ mi inuǝ eto bikǝ busie ǝsuǝ?” ");
INSERT INTO lip_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Mfó nya ɔ́tɛyi mǝmblɛ nkǝ, “Bitǝkǝ ǝnǝ lǝ bebe kukɔnɔ lǝ bikǝtanta ku kunǝnkpǝ saa eto okle ǝsuǝ, itsyise utidi eto nkpǝ sitinti manyɛ lǝ bikǝ bia nkpe wǝ, lǝ uyifo otabinyǝ kulaa tsya ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Yesu ésukosǝ ɔ́tɛyi mǝ lekpa nǝmfo nkǝǝ, “Otabinyǝ utsyuǝ ǝsiǝ lǝ lefe nǝ léfe mmǝ wǝ lɛkɛ nsɔ kpǝ bo lɛlɛkɛ bidikǝ tinti. ");
INSERT INTO lip_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Lǝ nyamfo eso úfi nsusu nkǝ, ‘Se mǝnnyǝ kaka muutsyǝ mɔ bidikǝ biamfoo, be ele bǝ nyifo? ");
INSERT INTO lip_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“ ‘Lesa nǝ ele bǝ nyifo ni bǝ mooba mɔ kenwu ka kɔ nya mooto kafɔfɔ ka lɔɔmɔ eso nka kɔ. Mfó muunyǝ kǝtsyǝkɔ itǝ mɔ bidikǝ ku bikǝ kenke. ");
INSERT INTO lip_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Nya mɔɔtɛyi mɔ ǝsuǝ minkǝ disiɛkpɛ kpe mɛ. Nkpe asa sɛɛ kpǝ nnya mɔɔlɔ ntsyǝ itǝ alɛ kpǝ. Muusiǝ ntsyǝ ɔnwɛ nya muudi, nnǝ nya muudi nkpǝ nyǝ disuǝyuǝ.’ ");
INSERT INTO lip_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Fɛɛ Onanto átɛyi wǝ nkǝ, ‘Fǝ utidimumu! Ketsye kamfo hã moofo fǝ nkpǝ lǝ fǝ ani. Nya owoe luudi asa nnya fála fǝ alɔ ǝtsyǝ fǝ ǝsuǝ mfo?’ ” ");
INSERT INTO lip_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Mfó nya Yesu lélosǝ wǝ etiki nkǝ, “Mmǝ yuutsyǝ itǝ betidi ba laabɛbɛ asa kpǝ kǝtsyǝ ǝsuǝ lǝ kasɔ mfo nya baanlɔ kulesa kǝtsyǝ lǝ Onanto eto nɛ.” ");
INSERT INTO lip_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Nya Yesu lɛtɛyi wǝ bakasebi nkǝ, “Nyaso nlɛ mi bɔtɛyi minkǝ biankpɔnko ǝsuǝ lǝ lesa nǝ biudi bisiǝ nkpǝ nye lesa nǝ biɔlɛ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Nkpǝ afo koya boso didisa, nya etidisuǝ tsya afo koya eso lesa nǝ bɔɔlɛ lǝ ǝsuǝ ");
INSERT INTO lip_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Bɛlɛ ǝnǝmi bebe baklɔbɛ ba laamfó ɔkɔɛ nya bǝǝmfǝsǝ nye bǝlǝkǝ bidikǝ lǝ ɔkuɛ tsya. Bǝmbǝ kenwu nye bikǝ kǝtsyǝkɔ. Fɛɛ Onanto ǝǝtǝ mǝ didisa! Nya mimba lefo koya benso baklɔbɛ nkpǝ! ");
INSERT INTO lip_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nya mi utsyuǝ ebofo nkpǝ busiǝ diyi lɔni kplo kasonsǝ alɛ nnya ele bǝ usiǝ ɛyɛ lǝ wǝ lekplatsya ǝsuǝ? ");
INSERT INTO lip_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Nya lǝ biembofo kulesa buyifo lǝ asa kɛkɛ nyamfo ǝsuǝǝ, beso bia bakplatsya kele ǝsuǝ lǝ asa bamba tsya ǝsuǝ? ");
INSERT INTO lip_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Bibu bebe kase dituwinimi lǝǝmǝ kanɔ bobee. Kaanta olokotutu nya keendi kafia kefi keti ǝsuǝ. Fɛɛ nlɛ mi bɔtɛyi minkǝ Oka Salomo kulaa tsya lǝ wǝ kɔlɔkɔ eto diyǝnde ǝsuǝǝ, mánnɔ bobe fe dituwunimi nǝ lǝǝmǝ mfó. ");
INSERT INTO lip_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Lǝ Onanto lǝǝtǝ sefa kɔlɔkɔ komfo eto oklee, sefa sia lǝǝńyǝ mmi ete nya lǝ kǝsiǝsǝ ete baala se kato kakpé lǝ ditefɛnku kǝmiǝǝ, ntsyǝ yuubǝ bǝ Onanto ǝmfo kǝ embutǝ mi alɛsa nnya lǝmboso sefa eto ale nyamǝ? Be dítǝ eso mi bofokanɔ lǝmbǝ ale mmǝ? ");
INSERT INTO lip_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Nyaso biante sikpi lǝ bɛsɛsǝ ǝnǝmi bikatɔ biǝnkǝ be biudi nye be biunǝ. ");
INSERT INTO lip_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Itsyise betidi ba dímamfo Onanto bánɔɔ, mǝ ni mba leefi mǝ ǝnǝmi kǝtǝkǝ lǝ asa nyamfo ǝsuǝ nɛ. Mi Anto yi nkǝ asa nyamfo kenke afe itǝ mi. ");
INSERT INTO lip_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Bomu bikebu disi ketsyiko lǝ Onanto eto sekakedikɔ ǝsuǝ nya uufi nyamfo kenke utǝ mi. ");
INSERT INTO lip_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Mi ditsyukpa kɛkɛ nǝ ntǝkǝko mɛ, biante sikpi. Itsyise iyifo Onanto eto lelabi bǝ utǝ mi kǝsiǝkɔ lǝ wǝ sekakedikɔ. ");
INSERT INTO lip_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Bifi mi bikǝ bia nte mi bisu bete lǝ bifi atabi nyamǝ bitǝ bakombo. Lǝ bɛbɛbɛ otabitobe wǝ lǝǝmbobia bitsyǝ ǝsuǝ lǝ Onanto eto. Mfóo, nya mi bikǝ bia lefo koya luutsyǝ kpoo nya biembolo kulefe. Itsyise uyu saa ǝmbofo budufǝ mfo nya balɛ lembobiasǝ mi. ");
INSERT INTO lip_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Itsyise kaka fǝ bikǝ bia lefo koya ntee, mfo mi ketu tsya luusiǝ nɛ. ");
INSERT INTO lip_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Bimuǝ ǝsuǝ bitsyǝ itǝ lesa nǝ ke luubǝ, lǝ mi kakandiɛ lǝ kǝkǝnyǝ. Nya biǝntǝ lǝ mi okandiɛ lǝ ɔni. ");
INSERT INTO lip_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Bimuǝ ǝsuǝ bińyǝ fe kase beyifoyifo lǝǝńyǝ kǝsǝkǝ mǝ Onamute wǝ luutsyi kusiǝ kakpakɔ ubǝ. Lǝ ubǝ ɔsɔ sikuu, lǝ basini bǝtǝ wǝ lamfolamfo. ");
INSERT INTO lip_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Beyifoyifo ba Onamute luubǝ unyǝ nkǝ bǝńyǝ balɛ bose itǝ wǝ bubǝǝ, ebunyǝ disuǝyuǝ tinti! Nlɛ mi bɔtɛyi minkǝ, wɔɔwuninsǝ kafia lǝ lɛmɔkɔsi ɔtsyimi, nya wuutǝ nkǝ bǝsiǝ lǝ wǝ kedikɔ, nya wǝ kosate luutǝ mǝ lesa bedi. ");
INSERT INTO lip_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Lǝ ibǝ bǝ ntsyenti nye kolensiǝnto kplɛ úbǝ nya únyǝ mǝ se bǝńyǝ bensǝkǝ wǝ bubǝǝ, nte disuǝyuǝ nǝ eto okle wookpe mǝ! ");
INSERT INTO lip_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Mɔmɔɔ, bete biǝ lǝ oyosate ebote lefe nǝ uyu luubǝ uyu wǝǝ, eni wǝmbutǝ wǝ kusu nkǝ oba udufǝ wǝ diyo. ");
INSERT INTO lip_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Nyaso nko ele bǝ itsyǝ mi tsya bǝ bińyǝ bikabe kusu nɛ, itsyise mɔ, Utidi Eto Ubi, ebubǝ udufǝ lǝ lefe nǝ bɛnnlɛ wǝ kusu bobe.” ");
INSERT INTO lip_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Mfó ǝmǝ nya Petro lɛtɔ Yesu nkǝ, “Bonamute, bo fanlɛ lekpa nǝmfo bɔtɛyi kǝtǝ, lee dińyǝ itǝ utidi saa?” ");
INSERT INTO lip_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Nya Yesu ditǝ mbuayɛ nkǝ, “Uyifoyifo ni nwǝ ntǝkǝ ǝnǝ nya weeyifo keyifo lǝ ɔnukualɛ eto kusu ǝsuǝ, wǝ ni nwǝ wǝ Onamute leefi kǝtsyǝ lǝ wǝ beyifoyifo fɛfɛ eto kɛnyɛ nɛ. Nya wǝ ni futsyǝ luutǝ wǝ beyifoyifo fɛfɛ mǝ didisa lǝ lefe sɛɛ ǝsuǝ nɛ. ");
INSERT INTO lip_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Bebe, lǝ uyifoyifo ǝmǝ afo nya woeyifo ke kukɔnɔ fɛ wǝ Onamute díbǝǝ, wuunyǝ disuǝyuǝ tinti lǝ uyifoyifo ǝmǝ ǝsuǝ! ");
INSERT INTO lip_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Sitintii, nlɛ mi bɔtɛyi minkǝ wǝ Onamute ǝmfó ebufi uyifoyifo ǝmǝ utsyǝ lǝ wǝ bikǝ kenke eto kɛnyɛ. ");
INSERT INTO lip_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","“Fɛɛ lǝ uyifoyifo ǝmǝ átɛyi nkǝ, ‘Mɔ Onamute ésu kusu wǝǝmbubǝ mlǝ,’ nyaso útsyiko budi kǝnǝ kǝkpǝ ntǝ nya woablɛ beyifoyifo fɛfɛ ba ni basani ku besio kenke ku disialee, ");
INSERT INTO lip_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","wǝ Onamute ebubǝ lǝ lefe nǝ wǝ uyifoyifo lenyi, ɔnnlɛ kusu bobe. Mfó Onamute ǝmǝ ebunǝ wǝ koto kekleke ko dinyǝ itǝ mba ditidi ato bamfó eto okle. ");
INSERT INTO lip_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Uyifoyifo wǝ nyi lesa nǝ wǝ Onamute laala nkǝ uyifo utǝ wǝ fɛ woani ni buyifo se woanla nkǝ woeyifo lǝ nnya ǝsuǝ esoo, ablɛ hã buukablɛ wǝ nya luutǝ ofo afabe lǝ wǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Fɛɛ uyifoyifo wǝ lennyi lesa nǝ wǝ Onamute laala nkǝ uyifo fɛ uyifo lesa nǝ dińyǝ itǝ kotonǝnǝ, sɛkɛ ete boonǝ wǝ koto. Utidi saa wǝ bǝtǝ asa kpǝǝ, nko ke ele bǝ uyifo asa kpǝ nɛ. Nyaso utidi saa wǝ bǝtǝ asa kpǝ isi ensoo, nko ke ele bǝ uyifo keyifo isi eso nɛ. ");
INSERT INTO lip_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Mfi Onanto eto kotonǝnǝ ko nte fe ute seka mboko kawunsiǝ. Nya nla sitinti minkǝ eni utsyiko buńyǝ koko. ");
INSERT INTO lip_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ntuflǝsǝflǝsǝ eto bulǝ kplɛ butsyuǝ kpe ele bǝ mfo fe kase ketu leetsyi utidi kedunko. Nya membunyǝ lɛwɔnɔ nsiǝ isu ese lefe nǝ bulǝ bomfó díbǝ bófe. ");
INSERT INTO lip_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Bíbu biǝ mbǝ kawunsiǝ miǝ mǝǝtǝ mi diyuǝ? Owo lo! Inni diyuǝsǝ, bomu nti busǝnsǝ eso. ");
INSERT INTO lip_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Nya idu mɔmɔ ɛntɔɔ, ayo nnya fe kaka betidi ɛnɔ nkpee, boosensǝ lǝ bǝtsyuǝ ǝsuǝ. Inuǝ ebotaka bǝńyǝ lǝ itsyǝ ǝsuǝ nya itsyǝ lootaka bǝńyǝ lǝ inuǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ubianto ebotaka uńyǝ lǝ wǝ bebisaibi ǝsuǝ, nya bebisaibi lootaka bǝńyǝ lǝ mǝ anto ǝsuǝ. Ambemǝ ebotaka bǝńyǝ lǝ mǝ bebisiobi ǝsuǝ, nya bebisiobi tsya lootaka bǝńyǝ lǝ mǝ ambemǝ ǝsuǝ. Nya bǝsǝambe mǝ lootaka bǝńyǝ lǝ mǝ bebisaibi eto bǝsiǝ ǝsuǝ, nya bebi eto bǝsiǝ lootaka bǝńyǝ lǝ mǝ bǝsǝambemǝ ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu átɛyi betidi bamfó tsya nkǝ, “Lǝ binyǝ biǝ lɛsɔmiloku ana ditsyi kofe eto diyo kedufǝkɔ lǝ difule lɛlɛ bubǝǝ, biatɛyi mfó ǝmǝ biǝ ɔsɔmi ebubǝ ɔni. Nya yǝǝbǝ kǝtǝ nko. ");
INSERT INTO lip_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Nya lǝ binyǝ biǝ ufiebi lɛ bɔsɔ ketsyi Ɔnwɛdukuǝ eti ɔnlɛ bubǝǝ, biatɛyi biǝ utefofo nye diwi ɛbɔkɛ. Nya yǝǝbǝ kǝtǝ nko. ");
INSERT INTO lip_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ǝnǝmi, ǝnǝmi eto betidi, lǝ binyǝ kato ku kasɔ eto ditsyǝbii, biate lefe nǝ ɛnlɛ bote, beso bɛnnlɛ mɔmɔ eto lefe kasɔ bɔnɔ kǝlǝkǝ kate? ");
INSERT INTO lip_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Beso biamfo budufǝ lǝ asa kǝmiǝ kabe lɛsɛ nǝ ele bǝ biyifo? ");
INSERT INTO lip_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Lǝ utidi utsyuǝ ákpadi fǝ etiki lǝ lekpokakpokɔ nkǝ fonko wǝ ákɛ etiki ǝtsyuǝǝ, yɛ lǝ kusu saa ǝsuǝ lǝ alɔ etiki nyamǝ ǝtsyǝ fɛ lǝ bidufǝ lekpokakpokɔ. Leni nkoo, wuufi fǝ utǝ bakponkpo nya mba lǝǝmuǝ betidi luufi fǝ bato bakpe lǝ diyo. ");
INSERT INTO lip_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nya nlɛ fǝ butǝ bote minkǝ ebɔkɛ mfó isu ese lefe nǝ fafó fǝ kotonǝnǝ eto kayo kenke falosǝ.” ");
INSERT INTO lip_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Lǝ lefe nǝmfóo, betidi bǝtsyuǝ ákɛ mfó ba lɛtɛyi Yesu kase Pilato lélo Galileafɔ bǝtsyuǝ lǝ lefe nǝ bǝkǝtǝ Onanto kedi. ");
INSERT INTO lip_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Mfó nya Yesu lɛtɔ mǝ nkǝ, “Bibu biǝnkǝ se bálo Galileafɔ bamfo nko esoo, mǝ abua nnya béyifo amɔ eso Galileafɔ fɛfɛ kenke? ");
INSERT INTO lip_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Owo lo! Inni nko ini kon! Fɛɛ nnya míntɛyi mi ni bǝ, lǝ bianyɛ mi asa bua buyifoo, nko ke mi tsya luubǝ bikpǝ nɛ. ");
INSERT INTO lip_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Nya betidi lefosi mflamfla ba Siloa eto diyo kplɛ nǝmǝ léba lékpo mǝ lǝ ǝsuǝ bǝkpǝǝ, bibu biǝ lǝ nyamfo eso beyifo babuatidi banso mba nsi lǝ Yerusalem mfó kenke? ");
INSERT INTO lip_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Owo lo! Inni nko ini kon! Nlɛ mi bɔtɛyi minkǝ lǝ bientsyi mi akɔɛsi bɛwuninsǝ, nko ke mimblɛ kenke luubǝ bikpǝ fe mǝ ke nɛ.” ");
INSERT INTO lip_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Mfó nya Yesu lɛtɛyi mǝ lekpa nǝmfo nkǝ, “Lefe ditsyuǝ nǝ lefe mǝ, osani utsyuǝ ákɛ mfó wǝ lɛkɛ kudiyi kutsyuǝ lǝ wǝ ɔkuɛ. Úsu nkǝ lǝ usu ɔbɛbɛ kuyi komǝ eto ebibi, fɛɛ wǝnnyǝ ku ǝtsyuǝ. ");
INSERT INTO lip_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Mfó ǝmǝ ɔ́tɛyi nwǝ laabe wǝ ɔkuɛ ǝmǝ nkǝ, ‘Bebe! Alɛ ǝtsyǝ ni nyamfo nɛ se mǝǝbǝ mfo kǝbǝ kabɛbɛ kuyi komfo eto ebibi kanɔ nɛ. La ko akpo kasɔ, itsyise kumbǝ kutǝkǝ saa itǝ kasɔ ka ǝsuǝ kuńyǝ mfo.’ ");
INSERT INTO lip_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Fɛɛ nwǝ laabe ɔkuɛ ǝmǝ ǝtǝ mbuayɛ nkǝ, ‘Bonamute, yani ko lǝ kusi kunyǝ lɛlɛ lɔni kplo lǝ bobe. Muuku ko kalɔ ntsyilama nkpo asa nnya lɔɔlɛkǝsǝ kasɔ kamǝ lǝ bobe. ");
INSERT INTO lip_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Nya lǝ kofó ebibi kpǝ bɔnwɔɔ, ɛlɛkɛ. Fɛɛ lǝ koamfo bɔnwɔ lɛlɛ nǝ luubǝ, ebofo ko bola kakpo kasɔ.’ ” ");
INSERT INTO lip_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Nya lǝ Ɔnwɛditsyǝyi lɔni ǝsuǝǝ, Yesu ákɛ mfó úkate asa lǝ Yudafɔ eto katsyakɔ kǝtsyuǝ. ");
INSERT INTO lip_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Nya usio utsyuǝ tsya ákɛ mfó wǝ lɛwɔnɔ bua ditsyuǝ díkǝlǝ fe lefosi alɛ mflamfla sɔ̃ɔ̃. Lɛwɔnɔ nǝmǝ ǝtǝ bǝ usio ǝmǝ ǝnwǝ úkǝnǝ lefe saa eso woamfo bɔtsyɔ kǝńyǝ tente. ");
INSERT INTO lip_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Se Yesu dínyǝ wǝǝ, ókpadi wǝ nya ɔ́tɛyi wǝ nkǝ, “Usio, báyankli fǝ lǝ fǝ bufi ǝsuǝ!” ");
INSERT INTO lip_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Nya Yesu dífi wǝ ani útǝkǝ lǝ usio ǝmǝ ǝsuǝ. Lamfolamfo, usio ǝmǝ átaka úńyǝ ɔ́tsyɔ nya ɔ́tɛsǝ Onanto. ");
INSERT INTO lip_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Nwǝ laabe Yudafɔ eto katsyakɔ kamǝ ǝnyǝ ɔblɔ tinti lǝ kase Yesu létsya ufimfi ǝmǝ lǝ Ɔnwɛditsyǝyi ǝsuǝ eso. Nyaso ɔ́tɛyi betidi bamfó kenke nkǝ, “Bokpe eyi akua nnya ele bǝ bufi buyifo bo nyifo. Nyaso bekpe eyi nyamfo bǝ lǝ lesatsyuǝ lɛ mii, bibǝ lǝ batsya mi, inni lǝ Ɔnwɛditsyǝyi ǝsuǝ!” ");
INSERT INTO lip_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Mfó ǝmǝ nya Bonamute dítǝ wǝ mbuayɛ nkǝ, “Mi, ǝnǝmi ǝnǝmi eto betidi, mii, biǝlǝkǝ bebuki ba leeyifo mi keyifo nye leetsyi mi bikǝ ketsyiko lǝ kakuɛ nya biakpa mǝ kesuko ntu kǝnǝkɔ lǝ Ɔnwɛditsyǝyi. ");
INSERT INTO lip_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Nya mɔmɔɔ, biǝnyǝ Abraham eto ketsyikɔ eto ubi sionko wǝ ńyǝ mfo, wǝ Obonsam dífi kǝkuǝ ókle lefosi alɛ mflamfla sɔ̃ɔ̃ ni nyamfo. Yenyifo lesa nǝ lɛlɛkɛ bǝ bǝlǝkǝ wǝ lǝ kǝkuǝ lǝ Ɔnwɛditsyǝyi ǝsuǝ?” ");
INSERT INTO lip_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Etiki nnya Yesu dílǝkǝ ɔ́tɛyi mfo ǝtǝ bǝ kofani ǝmuǝ wǝ balo, nya betidi bamba dínyǝ disuǝyuǝ lǝ anyinisa nnya kenke ɔnlɛ bulǝkǝ kate eso. ");
INSERT INTO lip_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Mfó ǝmǝ nya Yesu lɛtɔ mǝ nkǝ, “Biyi kase Onanto eto Sekadidi laayɛ kesensǝ? Nya be ele bǝ bufi nnya bokatesǝ ko? ");
INSERT INTO lip_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Bebe! Osani utsyuǝ éfi diyibibi ditsyuǝ nǝ nso bɔfɛ óto lǝ wǝ ɔkuɛ. Se diyibibi nǝmǝ díkǝǝ, díbǝ lébe léfiani kuyi kplɛ kutsyuǝ eto kɔlɔmɔ ǝsuǝ baklɔbɛ díbǝ báto ayo bakpe.” ");
INSERT INTO lip_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesu esi ɔ́tɛyi mǝ lekpa bamba nkǝ, “Be muufi Onanto sekadidi nkatesǝ ko? ");
INSERT INTO lip_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Usio utsyuǝ éfi ǝyǝnkisǝsa úfi ótsyakasǝ ku nnamfo eto ɔkpɛ ɔni, nya ɔ́fɔkɔtisǝ ɔ́wɔ mu isu ese lefe nǝ ǝyǝnkisǝsa nyamǝ léba ídufǝ lǝ nnamfo bomǝ kenke ǝsuǝ nya dítǝ botaka.” ");
INSERT INTO lip_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu ésu ɔ́yɛ lǝ kǝmǝ ku mbuto kafo nya óte betidi asa lǝ lefe nǝ ɔntɔ lǝ Yerusalem. ");
INSERT INTO lip_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Mfó ǝmǝ nya utidi utsyuǝ lɛtɔ wǝ nkǝ, “Bonamute, ɛkpɛ ini bǝ betidi ba luubǝ bǝnyǝ bofo, ǝmbufui lee ntsyǝ ini?” Mfó ǝmǝ nya Yesu dítǝ mbuayɛ nkǝ, ");
INSERT INTO lip_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Bekpe ale lǝ bɛyɛ lǝ kesie ka nso bɔfɛ bidufǝ. Itsyise betidi kpǝ ebola sitinti bǝ baayɛ mfo lǝ bedufǝ, fɛɛ bǝmbofo budufǝ. ");
INSERT INTO lip_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Lefe ebubǝ leyo itǝ buudufǝ nya Onamute ǝmǝ lootaka uńyǝ nya wuuti kesie kamǝ. Nya mimba dibu biińyǝ lǝ lekple biu kasɔ siku katɛyi biǝnkǝ, ‘Onamute, sini bo!’ “Fɛɛ Onamute ǝmǝ ebulǝkǝ kɛnyɛ ɔtɛyi nkǝ, ‘Minnyi mi ku kaka bitsyi!’ ");
INSERT INTO lip_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Nya biɔtɛyi biǝnkǝ, ‘Bo ku fǝ lídi búnǝ, nya fáte asa lǝ bo umǝ!’ ");
INSERT INTO lip_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Fɛɛ usi ɔɔtɛyi mi nkǝ, ‘Minnyi mi! Bidu mɛ lǝ akɔ mi babuayifotidi.’ ");
INSERT INTO lip_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Mfo ǝmǝ nya nku buwi ku animi bunǝ lɔɔkɛ lǝ lefe nǝ biunyǝ Abraham ku Isak ku Yakob Ku Onanto eto bǝnyɛlǝkǝtidi kenke lǝ Onanto eto sekakedikɔ lǝ lefe nǝ Onanto léla mi ɔnlɛ bɔtɛyi nkǝ biendufǝ mfó. ");
INSERT INTO lip_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Betidi ebutsyi kofekatokɔ ku diyo kedufǝkɔ bǝbǝ. Nya mba ditsyi ɔnwɛ kato ku ɔnwɛ dikuǝ ebotsya nya boodi bǝnǝ lǝ Onanto eto sekakedikɔ. ");
INSERT INTO lip_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Nya betidi bǝtsyuǝ ba ni bafɛfɛ, mǝ luubǝ bedi betutɛ. Nya mba ni betutɛ eto bǝtsyuǝ, mǝ luubǝ bafiani bafɛfɛ nɛ.” ");
INSERT INTO lip_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Nya lǝ lefe nǝmfo kǝmiǝ, Farisifɔ bǝtsyuǝ ǝbǝ Yesu ɔflɔ nya bátɛyi wǝ bǝnkǝ, “Kɔse lǝ abɔ mfo edu mɔmɔ mɔmɔ lǝ esu kalebe bamba, itsyise Oka Herodes ala nkǝ wǝ alo fǝ.” ");
INSERT INTO lip_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Mfo ǝmǝ nya Yesu lɛtɛyi mǝ nkǝ, “Bisu bɛtɛyi wǝ obiasǝtidi ǝmfó biǝnkǝ mɔ nlɛ bɔtɛyi minkǝ, ‘Mmi, moola awɔnɔ bua nlǝkǝ nya mootsya betidi efimbi, efimbi nya banlɛ isu ese kusɛɛ. Nya lǝ diyi tsyǝfǝ ǝsuǝ, moolosǝ mɔ keyifo.’ ");
INSERT INTO lip_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Nyaso ele bǝ ndiǝ ndiǝ ndiǝ nyɛ nsu sɛtɔ mmi isu ese kusɛɛ ku kǝsiǝsǝ. Itsyise yanle bǝ ibǝ bǝ balo Onanto eto unyɛlǝkǝtidi ku utsyuǝ sa lǝ kalebesa enso lǝ Yerusalem eto umǝ kafo. ");
INSERT INTO lip_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Yerusalem, Yerusalem! Fǝ betidi laalo Onanto eto bǝnyɛlǝkǝtidi, nya biakpɔ aba Onanto eto batɔnkpe ba ótsyese mi. Lǝ lefe kpǝ ǝsuǝǝ, nla miǝ lǝ nkpa fǝ betidi ntsyǝ ditsyu fe kase ukusɛsiǝle leesensǝ wǝ mbamba keti wǝ bebi, fɛɛ áni. ");
INSERT INTO lip_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Lǝ nyamfo esoo, Onanto ebulǝkǝ wǝ ato utsyiko lǝ umǝ ǝmfo. Nya lǝ ntɛyi mi sitinti minkǝ, biensiembunyǝ mɛ bio isu ese lefe nǝ biudi etiki bɛtɛyi biǝnkǝ, ‘Atɛsǝ itǝ nwǝ luubǝ lǝ Boanto Onanto eto diye ǝsuǝ!’ ” ");
INSERT INTO lip_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Lǝ Ɔnwɛditsyǝyi ditsyuǝ ǝsuǝǝ, Yesu ésu Farisifɔ eto beninǝ ɔni eto diyo lǝ kaka bákpadi wǝ bǝ ubǝ udi lesa. Nya bǝtsyuǝ akɛ mfo ékeyu kalɛ ola lǝ wǝ ǝsuǝ kekleke. ");
INSERT INTO lip_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Mfó nya osani utsyuǝ wǝ eto ani ku akpa lɛfɔɔ, díbǝ wǝ ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Nya Yesu lɛtɔ kɔfi eto bateasa ku Farisifɔ bǝtsyuǝ nkǝ, “Bo kɔfi ǝtǝ bo kusu nkǝ batsya utidi lǝ Ɔnwɛditsyǝyi ǝsuǝ, lee koǝntǝ bo kusu?” ");
INSERT INTO lip_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Fɛɛ bámfo kɛnyɛ bufǝ katɛyi kulesa. Mfó ǝmǝ nya Yesu lɛkɔbe utidi ǝmfo ókpa wǝ úsuko kutsyǝ nya ótsya wǝ nya útǝ wǝ kusu údu. ");
INSERT INTO lip_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Mfó ǝmǝ nya ɔ́tɛyi mǝ nkǝ, “Lǝ mi utsyuǝ kpe ubi nye onantsyui nya ófankli údufǝ lǝ dibiǝ ditsyuǝ kafo lǝ Ɔnwɛditsyǝyi, embunǝ wǝ ǝlǝkǝ lǝ Ɔnwɛditsyǝyi lamfolamfo?” ");
INSERT INTO lip_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Fɛɛ bámfo wǝ ditiki eto mbuayɛ butǝ bio. ");
INSERT INTO lip_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Se Yesu dínyǝ kase betidi ba bákpadi báboko mfó eto bǝtsyuǝ nlɛ nsiǝkɔ kplɛ bota kǝtǝ ǝsuǝ, ɔ́tɛyi mǝ lekpa ditsyuǝ nkǝ, ");
INSERT INTO lip_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Lǝ utidi utsyuǝ ákpadi fǝ nkǝ bǝ wǝ kusiǝkakpakɔ, mensu ǝsiǝ lǝ kakplɛkɔ. Itsyise ǝtsyuǝ ókpadi utidi wǝ nkpe dibu onso fǝ tsya oboko mfó. ");
INSERT INTO lip_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Nya utidi wǝ lékpadi mi inuǝ ba kenke díbǝ mfó ɔ́tɛyi fǝ nkǝ, ‘Tǝ lǝ utidi ǝmfo lǝ ubǝ usiǝ mfó.’ Yoohiã bǝ taka lǝ esu ǝsiǝ lǝ kaka lǝmbǝ dibu ku kofani. ");
INSERT INTO lip_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Bomu lǝ bákpadi fǝ bakoko kalebe kǝtsyuǝ, su ǝsiǝ lǝ kaka lenni kakplɛkɔ. Nya lǝ utidi wǝ lékpadi fǝ ǝbǝǝ, mfo wɔɔtɛyi fǝ nkǝ, ‘Ɔyɛtsyuǝ, taka lǝ mfó lǝ ǝbǝ ǝsiǝ lǝ kakplɛkɔ mfo.’ Nya nyamfo ebokpe fǝ dibu lǝ betidi bamba ba bákpadi báboko mfó kenke eto ǝnǝmi. ");
INSERT INTO lip_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Itsyise utidi saa wǝ labesǝ ǝsuǝ kato, Onanto ebobokosǝ wǝ kasɔ. Nya utidi saa wǝ laabokosǝ ǝsuǝ kasɔ, Onanto ebobesǝ wǝ kato.” ");
INSERT INTO lip_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Mfó nya Yesu lɛtɛyi utidi wǝ lékpadi wǝ nkǝ ubǝ kedikɔ mfó nkǝ, “Lǝ akpadi betidi fǝ bǝbǝ bedi lǝfǝ diyo, mankpadi fǝ bayɛtsyuǝ nye fǝ bayimi nye fǝ betidi nye fǝ bayotsya ba ni batabinyǝ. Itsyise mǝ tsya ebokpadi fǝ nko kǝ bǝ, bǝ lǝ ǝbǝ edi. Nya lǝ ibǝ nko, nyalɛ te fǝ lesa nǝ féyifo fǝtǝ mǝǝ, eto oko banlɛ bulǝkǝ kǝtǝ fǝ nɛ. ");
INSERT INTO lip_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Bomu lǝ alɛ diyi nǝmfo eto okle budii, kpadi bakombo ku betidi ba lamfo bɔyɛ kukɔnɔ ku mba lɛtsyini ku benǝmba. ");
INSERT INTO lip_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Nyamfo luutǝ Onanto kpo fǝ atsyɔ nɛ. Itsyise betidi bamfó ǝmbofo fǝ kayo bofo lǝ nnya kɛnyɛ kulesa. Onanto ebofo fǝ nya kayo lǝ diyi nǝ ǝsuǝ betidi sɛɛ lootaka betsyi ɔkɔmǝ bǝbǝ nkpǝ.” ");
INSERT INTO lip_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Se betidi ba nsi lǝ kedikɔ mfó eto ɔni lɛnɔ ditiki nǝmfo, ɔ́tɛyi Yesu nkǝ, “Sitinti, disuǝyuǝ ebɔkɛ lǝ betidi ba luubǝ bedi lesa lǝ Onanto eto sekakedikɔ!” ");
INSERT INTO lip_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Mfó ǝmǝ nya Yesu lɛtɛyi wǝ nkǝ, “Lǝ lefe nǝ léfe mǝǝ, osani utsyuǝ ákpadi betidi kpǝ lǝ wǝ diyi kplɛ ditsyuǝ eto lesakedikɔ. ");
INSERT INTO lip_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Se lefe léyo bǝ betsyiko budi kǝnǝǝ, óla wǝ beyifoyifo ókpe nkǝ batɛyi wǝ betidi ba kenke ókla utsyǝ nkǝ bǝbǝ. Itsyise lesa saa ebɔflɔ! ");
INSERT INTO lip_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Fɛɛ mǝmblɛ kenke étsyiko taflatsyɛ boto. Utidi tutɛ átɛyi uyifoyifo ɔni ǝmǝ nkǝ, ‘Nya kasɔ kǝtsyuǝ nya ele bǝ nsu mbe kǝ. Nyaso tɛyi wǝ fǝnkǝ, “Nlɛ wǝ lekpakpa, mǝmbofo bubǝ.” ’ ");
INSERT INTO lip_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Obamba tsya nkǝ, ‘Ńnya banantsyui lefosi ba lɔɔwunsǝko mǝ lǝ ɔkuɛ. Nya kusu mintɔ miǝ lǝ nsu nto mǝ mbe lǝ boofo keyifo buyifo. Nyamfo esoo, tɛyi wǝ fǝnkǝ, “Nlɛ wǝ lekpakpa, mǝmbofo bubǝ.” ’ ");
INSERT INTO lip_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Obamba tsya nkǝ, ‘Mɔmɔ ete minkpa kusiǝ nɛ, nyaso mǝmbofo bubǝ.’ ");
INSERT INTO lip_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Uyifoyifo ɔni ǝmǝ esinkli úsu, úsu ɔ́tɛyi wǝ Onamute asa nyamfo kenke. Mfó kafo ányi wǝ Onamute ǝmǝ tinti nya ɔ́tɛyi wǝ uyifoyifo ǝmǝ nkǝ, ‘Kɔse lǝ esu ǝńyǝ lǝ esu ku nlebe nlebe kenke lǝ umǝ ǝmǝ lǝ akpa bakombo ku betidi ba lɛtsyini ku bǝnǝmba ku mba kenke leba bankpo lǝ kasɔ aboko mfo.’ ");
INSERT INTO lip_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Mfo ǝmǝ nya uyifoyifo ǝmǝ dísu úyifo nko. Nya úsinkli úbǝ ɔ́tɛyi wǝ Onamute nkǝ ókpadi mǝ, fɛɛ nsiǝkɔ kpǝ esi bubu bute. ");
INSERT INTO lip_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Mfó ǝmǝ nya Onamute lɛtɛyi wǝ nkǝ, ‘Su lǝ esu ayɛ lǝ umǝ ku mbuto eto esu lǝ akpe nkɛale lǝ akpa betidi ba kenke aboko itǝ lǝ diyo nǝmǝ kafo kenke lǝ diyi. ");
INSERT INTO lip_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nya nlɛ fǝ bɔtɛyi kakpasǝ minkǝ betidi ba kenke mínkpadi miǝ bǝbǝ lesakedikɔ fɛ báni, mǝ kuutsyuǝ saa embutidi mɔ lesa nǝmfo kɛnyɛ babe!’ ” ");
INSERT INTO lip_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Lefe ditsyuǝ se betidi kpǝ bǝtsyuǝ dítǝkǝko Yesu, ɔ́tsyi ɔ́wuninsǝ nya ɔ́tɛyi mɛ nkǝ, ");
INSERT INTO lip_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Utidi saa wǝ luubǝ mɔ ɔflɔɔ, ǝmbofo mɔ okasebi budi lǝ waanla mɛ kaso wǝ anto ku wǝ usiǝ ku bebi ku wǝ bayimisani ku bayimisio ku wǝ kosate eto ǝsuǝ kulaa tsya. ");
INSERT INTO lip_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Utsyuǝ saa ke dimentsyi wǝ uyikabie ɔyɛ mɔ kayɛkɔ utǝkǝko mɛɛ, mǝnńyǝ utǝ bǝ uyifo mɔ okasebi. ");
INSERT INTO lip_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Lǝ utidi utsyuǝ aala nkǝ woato diyo kplɛ ditsyuǝ, tutɛ ele bǝ usiǝ kasɔ ubu bikǝ bia kenke loofe ku mi koya kenke obe lǝ okpe atabi nya loohiãa, bǝ woofo diyo nǝmǝ boto kalosǝ fɛ utsyǝ ni kasɔ. ");
INSERT INTO lip_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Nya lǝ weenyifo nyamfo, wǝmbofo diyo nǝmǝ boto kalosǝ, lǝ ɔ́sisǝ ni kasɔ kekleke ku abambi fɛ utsyǝ kafati kasɔ boto kulaa tsya. Nya utsyuǝ saa wǝ luunyǝ nii, ebumǝ wǝ katɛyi nkǝ, ");
INSERT INTO lip_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Utidi ǝmfo étsyiko diyo nǝmfo boto kasɔ, fɛɛ wǝmbofo ni boto kalosǝ.’ ");
INSERT INTO lip_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Lǝ oka utsyuǝ átaka ku bamamanyǝ akpi lefosi nnya usu nkǝ woakpɔnko oka bamba wǝ nkpe bamamanyǝ akpi fosi ǝnuǝ, wuusiǝ ubu disi obe kukɔnɔ lǝ wǝ ǝsuǝale nya onkpe ebutǝ bǝ ofo wǝ olo ǝmǝ bɔkpɔnko. ");
INSERT INTO lip_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Nya lǝ unyǝ nkǝ umbǝ ǝsuǝale nyamfo eto okle, wootsyese wǝ batɔnkpe nya boosu batsya ku oka ǝmǝ lǝ lefe nǝ batsyoko bǝtsyuǝ nya bɔɔlɛ wǝǝ lekpakpa nkǝ bayɛ bɔkpɔ lǝ bafiani bayɛtsyuǝ bomu, fɛ lǝ oka ǝmfó lǝ ɔnyi ɔfi kulaa tsya.” ");
INSERT INTO lip_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Mfó ǝmǝ Yesu lélosǝ wǝ etiki nyamǝ, nya ɔ́tɛyi mǝ nkǝ, “Nko ini itǝ mi bǝ mi kutsyuǝ ǝmbofo mɔ okasebi budi lǝ woenlǝkǝ wǝ ato utsyiko lǝ lesa saa ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Mba kpe alɛkɛ. Fɛɛ lǝ kamini kamǝ alo lǝ mba bomǝ ǝsuǝǝ, kusu ku kutsyuǝ saa ensimbǝ ǝsuǝ bookpe kamini lǝ mu bio. ");
INSERT INTO lip_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Yensilɛkɛ bǝ befi mu bakpe balɛkɛsǝ kasɔ, nya yanlɛkɛ itǝ kuku kulaa tsya. Buwi ele bǝ bewi mu. “Nyaso fǝǝ ke ato nnya laanɔ asa kpee, tsyue ato lǝ anɔ!” ");
INSERT INTO lip_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Diyi lɔnii, mba laafo umǝnko kpǝ ku babuatidi bamba ǝbǝ Yesu ɔflɔ bǝ baanɔ wǝ ditiki. ");
INSERT INTO lip_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Mfó nya Farisifɔ ku afi eto bateasa dítsyiko dinyǝfi bokpe ku wǝ katɛyi bǝnkǝ, “Utidi ǝmfo aafo babuatidi nya wǝ ku mǝ leedi lesa kulaa tsya!” ");
INSERT INTO lip_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Nyaso Yesu átɛyi mǝ lekpa nǝmfo nkǝ, ");
INSERT INTO lip_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Lǝ utsyuǝ lǝ mi nti kpe basamu kolofa, nya ɔni lénya lǝ mǝ ntii, be fuuyifo? Eboyani awosi ɔwɔnɔmbǝ ɔwɔnɔmbǝ bamfó ǝtsyǝ lǝ kedikɔ mfó, esu kabɛbɛ ɔni wǝ lénya mfó isu ese lefe nǝ fǝnyǝ wǝ. ");
INSERT INTO lip_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Nya lǝ ǝnyǝ wǝǝ, ebunyǝ disuǝyuǝ tinti, nya fuutsyi wǝ ǝtǝkǝ lǝ simuǝ. ");
INSERT INTO lip_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Nya fuufi wǝ aboko oto. Nya fookpadi fǝ bayɛtsyuǝ ku mba lǝ koyotsya nya fɔɔtɛyi mǝ fǝnkǝ, ‘Nlɛ disuǝyuǝ bunyǝ tinti, itsyise nnyǝ mɔ osamu wǝ lénya nyaso binyǝnko mɛ disuǝyuǝ!’ ");
INSERT INTO lip_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nya nlɛ mi bɔtɛyi minkǝ, nko ke disuǝyuǝ tinti lɔɔkɛ lǝ Onanto eto sekakedikɔ lǝ obuatidi ɔni wǝ hã lɛtsyi lɛkɔɛsi ɔwuninsǝ enso disuǝyuǝ nǝ boonyǝ lǝ fe betidi awosi ɔwɔnɔmbǝ ɔwɔnɔmbǝ ba dimensihiã bɔtsyi kawuninsǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Nya lǝ usio utsyuǝ kpe sika flubia lefosi nya ónyansǝ sɔnii, be ele bǝ uyifo? Wooto okandiɛ, okpa wǝ diyo kafo kenke, ɔbɛbɛ se lǝ diyo eto akpɔ nnya kenke kukɔnɔ isu ese lefe nǝ unyǝ atabi nyamǝ. ");
INSERT INTO lip_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Nya lǝ unyǝ see, wookpadi wǝ bǝtsyuǝ ku mba nkpe lǝ koyotsya, nya wɔɔtɛyi mǝ nkǝ, ‘Nlɛ disuǝyuǝ bunyǝ tinti itsyise nnyǝ mɔ atabi nnya lénya nyaso binyǝ ku mɛ disuǝyuǝ.’ ");
INSERT INTO lip_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nya nlɛ mi bɔtɛyi sitinti minkǝ, nko ke Onanto eto batɔnkpe tsya luunyǝ disuǝyuǝ lǝ obuatidi ɔni wǝ ditsyi lɛkɔɛsi ɔwuninsǝ eso.” ");
INSERT INTO lip_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu ésukosǝ nya ɔ́tɛyi mǝ nkǝ, “Osani utsyuǝ akɛ wǝ bebisaibi inuǝ lɛkɛ. ");
INSERT INTO lip_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Nya dikpefile lɛtɛyi wǝ anto nkǝ, ‘Nto, fi mɔ kedikɔ ka luutu mɛ lǝ fǝ bikǝ nti ǝtǝ mɛ mɔmɔ mɔmɔ.’ Lǝ nyamfo eso osani ǝmǝ éfi wǝ bikǝ biamǝ nya úsie mi lǝ akpa ǝnuǝ útǝ wǝ bebi inuǝ bamǝ. ");
INSERT INTO lip_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Nya lǝ eyi asiani eto kamaa, dikpefile nǝmǝ éfi asa nnya kenke dítu wǝ óte nya úfi atabi nyamǝ nya údu úsu kusu famfamfa kaka úsu úsiǝ údi nkpǝ bua bua, nya óbiasǝ wǝ atabi nyamǝ kenke. ");
INSERT INTO lip_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Údi lesa saa nǝ dítsyǝ wǝ ólosǝ. Lǝ nyamfó eto kamaa, kukpɛnsɛ kekleke kutsyuǝ ǝbǝ lǝ kasɔ kamǝ kenke nyaso kukpɛnsɛ ǝbǝ kúmuǝ wǝ nya kulesa ménsibu wǝ lǝ udi. ");
INSERT INTO lip_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Nyamfo esoo, úfi ǝsuǝ úsu ɔ́tsyɛ osani utsyuǝ nya ɔ́tɛyi nkǝ wuukeyifo keyifo saa ka ke eto okle wuutǝ wǝ nke uyifo. Nya osani ǝmǝ tsya dífi wǝ ókpe lǝ kaka wǝ bakplako nkpe banlɛ kota bɔnwɔ lǝ wǝ kebuto kǝtsyuǝ. ");
INSERT INTO lip_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Kukpɛnsɛ esoo, óla nkǝ eni lǝ ɔkɛ bakplako eto didisa nǝ bǝǝtǝ mǝ mfó eto ditsyuǝ lǝ udi, fɛɛ utidi saa mǝntǝ wǝ ni. ");
INSERT INTO lip_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Lǝ kalosǝkɔɔ, úsinkli údufǝ lǝ wǝ ǝsuǝ nya ɔ́tɛyi nkǝ, ‘Betidi ba ni mɔ anto eto beyifoyifo, baakɛ lesa kedi kemi kulaa tsya diebu. Nya mɔ nsi mfo nya kukpɛnsɛ luubǝ kolo mɛ. ");
INSERT INTO lip_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mootaka ńyǝ nsikli nsu mɔ anto ɔflɔ, lǝ ntɛyi wǝ minkǝ, “Mɔ Anto, nyifo kabua nya mínta Onanto ku fintsya mimbu. ");
INSERT INTO lip_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Mensińyǝ ntǝ bǝ kpadi mɛ fe fǝ ubi. Bomu fi mɛ fe betidi ba nlɛ keyifo buyifo kǝtǝ fǝ eto ɔni.” ’ ");
INSERT INTO lip_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Mfó ǝmǝ nya ótaka nya úfi wǝ bikǝ nya ɔ́yifǝ kusu ɔntɔ lǝ wǝ anto ɔflɔ. “Se wǝ anto dínyǝ wǝǝ, óte nkǝ wǝ ubi uni nkpe fãã ɔnlɛ bubǝ. Wǝ ubi eto asa álɛ wǝ kaminsǝ, nya útsyetsyi úsu ɔ́buta wǝ ku disuǝyuǝ. ");
INSERT INTO lip_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Mfo nya wǝ úbi lɛtɛyi wǝ nkǝ, ‘Mɔ Anto, nyifo kabua nta Onanto ku fintsya mbu. Nya mensinyǝ ntǝ bǝ akpadi mɛ fe fǝ ubi tsya!’ ");
INSERT INTO lip_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Fɛɛ wǝ anto ákpadi wǝ beyifoyifo nya ɔ́tɛyi mǝ nkǝ, ‘Bɛkɔse! Bifi awu nnya laanɔ bobe bibǝ bekpe wǝ. Nya lǝ bifi lɛsukpɛ ku afokpa nnya laanɔ bobe tsya bekpe wǝ lǝ ani ku akpa. ");
INSERT INTO lip_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Nyamfo eto kamaa, bisu bimuǝ lenantsyuikpɔ nǝ nkpe ayinkua lǝ belo ni. Nya bitǝ lǝ budi bunye disuǝyuǝ. ");
INSERT INTO lip_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Itsyise mɔ ubi ǝmfoo, búfi wǝ fe nwǝ díkpǝ. Fɛɛ úsinkli úbǝ nkpǝ. Ónya nya busi búnyǝ wǝ.’ Nyamfo eso bétsyiko diyi budi kǝnyǝ disuǝyuǝ. ");
INSERT INTO lip_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Lǝ lefe nǝmfo kenke ǝsuǝǝ, wǝ ubi ninǝ ésu nkǝ lǝ usu obe mǝ kakuɛ. Se utsyi ɔnlɛ bubǝ nya ibu sɛkɛ lǝ udufǝ otoo, ɔ́nɔ ǝsǝ sǝnsǝ ku nwui wuinwui eto kɔsɔ. ");
INSERT INTO lip_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Mfo nya ókpadi beyifoyifo eto ɔni lǝ mǝ nti nya ɔ́tɔ wǝ nkǝ, ‘Be nlɛ bubǝ lǝ oto?’ ");
INSERT INTO lip_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","“Uyifoyifo ǝmǝ ǝtǝ mbuayɛ nkǝ, ‘Fǝ ɔyimisani úsinklii úbǝ oto nya fǝ anto dítǝ bálo lenantsyuikpɔ nǝ nkpe ayinkua, itsyise usinkli ubǝ fɛ kulesa dímǝnyifo wǝ eso.’ ");
INSERT INTO lip_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Nyamfo ǝtǝ kafo ányi wǝ ɔyimisani ninǝ ǝmǝ tinti eso ɔ́ni nkǝ wǝmbudufǝ diyo kulaa tsya. Lǝ nnya eso wǝ anto ábɔ úbǝ wǝ ɔflɔ mfó, nya úbǝ ɔ́lɛ wǝ lekpakpa nkǝ udufǝ diyo. ");
INSERT INTO lip_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Fɛɛ wǝ ubi ǝmǝ ésinkli ɔ́tɛyi wǝ anto ǝmǝ nkǝ, ‘Beso mińyǝ minlɛ keyifo buyifo kǝteǝ fǝ alɛ kpǝ ni nyamfo, fe fǝ uyifoyifo nya mǝnńyǝ lǝ fǝ ǝsuǝ kulefe kulefe, nya ǝmǝntǝ mɛ kulesa fe ote kulaa tsya, fǝ lǝ nyǝ disuǝyuǝ ku mɔ bayɛtsyuǝ? ");
INSERT INTO lip_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Fɛɛ se fǝ ubi wǝ lébiasǝ fǝ bikǝ nya úsu útǝkǝko batsyetɔ dísinkli úbǝ otoo, álo lenantsyuikpɔ nǝ dísiǝ ayinkua ǝtǝ wǝ!’ ");
INSERT INTO lip_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Mfó ǝmǝ nya wǝ anto lɛtɛyi nkǝ, ‘Mɔ ubi, fǝ kpe mfo lǝ mɔ ɔflɔ lefe saa nya asa nnya nte mɛ kenke, eyifo fǝ ale. ");
INSERT INTO lip_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Fɛɛ ɛlɛkɛ bǝ budi diyi bunyǝ disuǝyuǝ, itsyise búfi boǝ iyifo fe bukpǝ fǝ ɔyimi díkpǝ nya úsinkli úbǝ nkpǝ. Iyifo fe bonya ónya nya busi búnyǝ wǝ bio.’ ” ");
INSERT INTO lip_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu átɛyi wǝ bakasebi nkǝ, “Lefe nǝ léfe mmǝǝ, otabinyǝ utsyuǝ akɛ mfó wǝ lɛkɛ uyifoyifo ɔni wǝ díkabe wǝ bikǝ. Nya bǝbǝ bátɛyi otabinyǝ ǝmǝ bǝ nwǝ laabe wǝ bikǝ mfó lɛ wǝ atabi bobiasǝ. ");
INSERT INTO lip_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Lǝ nyamfo eso otabinyǝ ǝmǝ ákpadi nwǝ laabe wǝ bikǝ mfo nya ɔ́tɛyi wǝ nkǝ, ‘Be ni nnya eto okle mínɔ itsyi lǝ fǝ ǝsuǝ mmǝ? Yifo nkunta itsyi lǝ kase fanlɛ mɔ bikǝ bobe ǝsuǝ kenke aboko mɛ, itsyise ensiembofo mɔ bikǝ bobe bio tsya.’ ");
INSERT INTO lip_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Mfó nya uyifoyifo ǝmǝ lɛtɛyi wǝ ǝsuǝ nkǝ, ‘Mɔ Onamute ǝbǝ mɛ bola lǝ mɔ keyifokɔ. Be muuyifo? Mimbǝ ǝsuǝale nnya mukeyifo kakuɛnyifo. Nya asa bɔtɔ tsya aalɛ mɛ kofani. ");
INSERT INTO lip_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ahaa! Mbote lesa nǝ muuyifo! Itǝ bǝ lǝ mɔ keyifo ábɔ mɛ lǝ ani tsyaa, lǝ mɔ bayɛtsyuǝ lǝ bafo mɛ lǝ mǝ ayo.’ ");
INSERT INTO lip_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Lǝ nyamfo esoo, ókpadi betidi ba nsi wǝ Onamute kayo ɔni, ɔni. Ɔ́tɔ ututɛ nkǝ, ‘Kayo kasia fensi mɔ Onamute?’ ");
INSERT INTO lip_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Oyonyǝ ǝmǝ ǝtǝ mbuayɛ nkǝ, ‘Nnuǝ eto atase nnya lɛmɔ kolofa kɔni.’ “Mfó ǝmǝ nya nwǝ laabe bikǝ biamǝ lɛtɛyi wǝ nkǝ, ‘Be fǝ kayo eto kukue mfo. Siǝ lǝ kasɔ lǝ awɔni awosi anɔ fe nnya fensi nɛ.’ ");
INSERT INTO lip_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Nko ke ɔ́tɔ oyonyǝ bamba nkǝ, ‘Ntsyǝ ni fǝ ale? Kayo kasia fensi?’ “Oyonyǝ ǝmǝ tsya nkǝ, ‘Iyifo antabi eto atoku kplɛ kolofa kɔni.’ “Mfo nya nwǝ laabe bikǝ ǝmfo lɛtɛyi wǝ nkǝ, ‘Be fǝ kayo eto kukue mfo. Wɔni awosi mflamfla ǝtsyǝ.’ ");
INSERT INTO lip_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Nyamfo esoo, Onamute ǝmǝ átɛsǝ nwǝ laabe bikǝ wǝ dímenyifo asa lǝ kusu ǝsuǝ ǝmǝ lǝ wǝ kobe ko óte mfo eso. Sitintii, betidi ba lǝǝsiǝ lǝ kawunsiǝ kamfo eto asa eto kɛnyɛɛ, mǝ etsyuesa lǝ mǝ asayifoyifo ǝsuǝ kulaa tsya so mba difi mǝ etsyuesa bǝtǝkǝ lǝ Onanto eto sekadidi ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Mfó nya Yesu dísukosǝ ɔ́tɛyi mǝ nkǝ, “Bifi mi kawunsiǝ eto bikǝ bɔkɛ bɛwunsǝ ko betidi. Itǝ lǝ béloo, Onanto ebofo fǝ okpe lǝ wǝ kǝsiǝkɔ. ");
INSERT INTO lip_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Utidi wǝ laalɛ asa nnya ni akɛkɛ lǝ kusu ǝsuǝ, wǝ loofo asa nnya ni akplɛ enso tsya bɔlɛ lǝ kusu ǝsuǝ nɛ. Nya utidi wǝ laanyɛ lǝ kusu ǝsuǝ keyifo asa nnya ni akɛkɛ, wǝmbɔyɛ lǝ kusu sɛɛ ǝsuǝ uyifo asa nnya ni akplɛ enso tsya. ");
INSERT INTO lip_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Lǝ nnya eso lǝ bianyɛnko kawunsiǝ kamfo eto asa lǝ kusu sɛɛ ǝsuǝǝ, ntsyǝ yoofo bubǝ bǝ utidi ebofo mi ɔnɔ bǝ biɔlɛ asa nnya ni lɛwɔnɔ eto ale nnya ni Onanto eto ǝtǝsa ola lǝ kusu sɛɛ ǝsuǝ? ");
INSERT INTO lip_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Nya lǝ amanlɛ utidi bamba eto asa nnya nkpe fǝ lǝ ɔflɔ lǝ kusu sɛɛ ǝsuǝ, ntsyǝ yuubǝ fɛ booyani fǝ kosate eto ale bǝtǝ fǝ? ");
INSERT INTO lip_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Uyifoyifo saa embofo banamute inuǝ busumu. Woola ɔni, ukisi unuǝfǝ. Wuutsyue ɔni koto nya ɔɔni unuǝfǝ. Ǝmbofo Onanto ku atabi bɔkɔ kesumu.” ");
INSERT INTO lip_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Lefe nǝ Farisifɔ lɛnɔ asa nnya Yesu lɛtɛyii, bǝmǝ wǝ itsyise bála atabi fefe. ");
INSERT INTO lip_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Mfó nya Yesu lɛtɛyi mǝ nkǝ, “Biyifo betidi ba laate ǝsuǝ fe betidi sɛɛ lǝ babamba eto ǝnǝmi. Fɛɛ Onanto yi mi akɔɛsi kafo kenke. Itsyise asa nnya lefo koya lǝ betidi eto ǝnǝmii, eyifo asinsa lǝ Onanto eto ǝnǝmi. ");
INSERT INTO lip_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Moses eto kɔfi eto kukue ku Onanto eto bǝnyɛlǝkǝtidi eto asa nnya báwɔni bǝtsyǝǝ, éyifo mǝ keyifo isu ese Ntuflǝsǝtidi Yohanes eto lefe. Nya idu lǝ lefe nǝmfó ǝsuǝǝ, bianɔ se baatɛyi dikiti sɛɛ nǝ ditsyi lǝ Onanto eto sekakedikɔ ǝsuǝ. Nya utidi saa nlɛ bokplatsya nkǝ lǝ udufǝ mfó. ");
INSERT INTO lip_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Fɛɛ iyuǝ eso itǝ bǝ kato ku kasɔ lǝ enya, enso bǝ afi nyamfo eto awɔnisa eto lekpa sɛkɛ saa bɔ lǝ Onanto eto afi nyamǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Osani saa wǝ lɔɔni wǝ usiǝ nya uufi obambaa, okpo kusiǝ. Nya osani wuufi kusiǝ ko bánii, okpo kusiǝ. ");
INSERT INTO lip_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Lǝ lefe ditsyuǝǝ, otabinyǝ sani ɔni akɛ wǝ díkalɛ bikǝ bia lefo koya tinti, nya úkǝnyǝ disuǝyuǝ lefe saa lǝ wǝ nkpǝ kenke ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Nya okombo utsyuǝ wǝ baakpo bǝ Lasaro tsya lɛkɛ mfo. Afabe édi okombo ǝmfo ǝsuǝ kenke nya béketsyi wǝ bǝkǝtsyǝ lǝ kasɔ lǝ otabinyǝ ǝmǝ eto diyo eto kesie. ");
INSERT INTO lip_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Úkabe kusu nkǝ lǝ otabinyǝ ǝmǝ lɛ budii, ewuliwuli nnya díkakpo lǝ kasɔ eboyo wǝ lǝ udi. Bakpa kula tsya kǝbǝ kadia wǝ afabe nyamǝ. ");
INSERT INTO lip_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Íbǝ íbǝ bǝ Okombo ǝmǝ ésu úkpǝ nya Onanto eto bɔtɔnkpe díbǝ bétsyi wǝ bésu bǝtsyǝ lǝ Abraham eto akɔ kato. Otabinyǝ ǝmǝ tsya ǝbǝ úkpǝ nya bébikǝ wǝ. ");
INSERT INTO lip_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Nya lǝ ɔkɔmǝǝ, únyǝ nkǝ ɔ́kɛ lǝ kanyi kǝnyǝkɔ. Mfó se óbesǝ ǝnǝmi kato, únyǝ Abraham famfamfa nya Lasaro dísiǝ wǝ lǝ akɔ. ");
INSERT INTO lip_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Mfó ǝmǝ nya ókpadi bembembe ɔtɛyi nkǝ, ‘Anto Abraham! Nyǝ mɛ kaminsǝ lǝ ǝtǝ lǝ Lasaro lǝ ufi lɛnimi oto lǝ ntu ntsyuǝ ǝsuǝ lǝ ufi ubǝ utǝkǝ lǝ mɔ odiakami ǝsuǝ lǝ iyuǝ ko mɛ. Itsyise nlɛ kanyi bunyǝ lǝ ute ǝsuǝ mfo!’ ");
INSERT INTO lip_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Fɛɛ Abraham átɛyi wǝ nkǝ, ‘Ubi, kloma fǝnkǝ lǝ fǝ nkpǝ disiǝfee, áfo asa sɛɛ kpǝ tinti. Nya Lasaro wǝ alɛɛ, asa bua sɔ̃ɔ̃ ófo. Fɛɛ mɔmɔɔ, ɔlɛ disuǝyuǝ bunyǝ nya fǝ nlɛ kanyi bunyǝ. ");
INSERT INTO lip_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Nya, nnya nsi nkpe lǝ nnyaa, kukpio kplɛ kutsyuǝ kpe mfo lǝ bo ku fǝ eto nti. Nya lǝ utidi utsyuǝ aala nkǝ woayila ubǝ mfóo, wǝǝmbofo. Nya nko ke kutsyuǝ tsya lǝmbofo bɔyɛ kedu mfó kǝbǝ bo ɔflɔ mfo.’ ");
INSERT INTO lip_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Mfó otabinyǝ ǝmǝ lɛtɛyi wǝ nkǝ, ‘Anto Abraham, nlɛ fǝ lekpakpa kpe Lasaro lǝ usu mɔ anto eto. ");
INSERT INTO lip_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Mfóo, nkpe bayimisani ɛnɔ. Tǝ lǝ usu ɔlɛ mǝ kɔlɛ kukɔnɔ itǝ lǝ mǝ lǝ bayɛ kaka minkpe bubǝ, kaka kanyi nkpe mfo.’ ");
INSERT INTO lip_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Mfó ǝmǝ nya Abraham lɛtɛyi wǝ nkǝ, ‘Fǝ bayimisani kpe Moses ku Onanto eto bǝnyɛlǝkǝtidi lǝ ɔflɔ. Nya ele bǝ betsyue mǝ koto.’ ");
INSERT INTO lip_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Mfó nya otabinyǝ ǝmǝ dítǝ mbuayɛ nkǝ, ‘Anto Abraham, bǝmbɔnɔ mǝ ditiki! Fɛɛ lǝ utidi utsyuǝ ataka utsyi ɔkɔmǝ mfo úsu mǝ ɔflɔɔ, bɔɔnɔ wǝ ditiki bayɛ mǝ asa bua buyifo.’ ");
INSERT INTO lip_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Fɛɛ Abraham átɛyi wǝ nkǝ, ‘Lǝ bǝbɔnɔ Moses ku Onanto eto bǝnyɛlǝkǝtidi eto ditikii, lǝ yuubǝ bǝ utidi utsyuǝ ataka utsyi ɔkɔmǝ mfo usu mǝ ɔflɔ kulaa tsyaa, bembofo wǝ ditki banɔ!’ ” ");
INSERT INTO lip_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu átɛyi wǝ bakasebi nkǝ, “Asa nnya lǝǝtǝ utidi leeyifo lebua, ebubǝ kokooko. Fɛɛ mbɔbɔɛ mǝǝtǝ utidi wǝ ǝsuǝ asa nyamfo lɔɔyɛ ibǝ! ");
INSERT INTO lip_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Lǝ béfi kukuǝ ko lɛmɔ kutsyuǝ bátsyasǝ wǝ lǝ simuǝ nya báto wǝ bákpe lǝ lekpo kǝmiǝ kulaa tsya, ɛlɛkɛ itǝ wǝ eso koto ko Onanto luunǝ nwǝ luutǝ bekpefi kɛkɛ bamfo eto utsyuǝ yifo lebua. ");
INSERT INTO lip_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Nyaso lɔ abe asa nnya feeyifo kukɔnɔ. “Nya lǝ fǝ ɔyɛtsyuǝ éyifo fǝ kabua kǝtsyuǝǝ, kǝ wǝ ato. Nya lǝ údi dikpi nya ɔnɔ ǝsuǝ kasɔɔ, nyalɛ fi atsyɛ wǝ. ");
INSERT INTO lip_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Lǝ úyifo lesa bua óta fǝ úbu sekuanse lǝ diyi lɔni ǝsuǝ nya usi usinkli úbǝ, úbǝ ɔlɛ fǝ lekpakpa sekuanse diyi nǝmǝ ke ǝsuǝǝ, fi atsyɛ wǝ.” ");
INSERT INTO lip_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Yesu eto batɔnkpe álɛ Yesu lekpakpa bǝnkǝ, “Bonamute, tǝ lǝ bo bofokanɔ lǝ bumuǝ ale boso.” ");
INSERT INTO lip_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Mfó ǝmǝ nya Bonamute lɛtɛyi mǝ nkǝ, “Lǝ bekpe bofokanɔ bo leyo fe diyibibi nǝ nso bɔfɛ kenkee, biofo kuyi komfo bɔtɛyi biǝ, ‘Su lǝ mfo lǝ esu edufǝ lǝ lekpo kǝmiǝ mǝ.’ Nya kuuyifo nko mǝ. ");
INSERT INTO lip_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Bibu nyamfo be be. Lǝ mi utsyuǝ kpe uyifoyifo wǝ laafo ɔkuɛ kǝtǝ wǝ nye ɔnlɛ fǝ basamu bobe nya utsyi ɔkuɛ ubǝ udufǝǝ, bɔtɛyi fɔɔtɛyi wǝ fǝ ubǝ usiǝ lǝ kasɔ mlǝ lǝ udi wǝ lesa? ");
INSERT INTO lip_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Owo lo! Bomu ebɔtɛyi wǝ fǝ, ‘Muǝ fǝ ǝsuǝ lǝ atsyasǝ kafia lǝ nkɛ, lǝ anwa lesa, lǝ efi mɔ didisa ǝtsyǝ mɛ lǝ ndi nlosǝ fɛ lǝ fintsya lǝ edi.’ ");
INSERT INTO lip_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Yanle bǝ sɔ wǝ ani se ini wǝ uyifoyifo eto keyifo ete ini. ");
INSERT INTO lip_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Nko ke ini itǝ mi tsya nɛ. Lǝ biyifo lesa saa nǝ mintɛyi mi miǝ biyifoo, ele bǝ bɛtɛyi biǝ, ‘Beyifoyifo ete buni. Nya lesa nǝ buyifoo, eyifo lesa nǝ ete ele bǝ buuyifo.’ ” ");
INSERT INTO lip_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Nya se Yesu dídu ɔntɔ lǝ Yerusalem, ɔ́yɛ Samaria ku Galilea eto kumǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Nya se ɔnlɛ kebuto kǝtsyuǝ budufǝǝ, basani lefosi bǝtsyuǝ ba nlɛ bufisia bufi ǝbǝ batsyako wǝ. Befimfi bamfo ǝńyǝ kɔsɛsɛ. ");
INSERT INTO lip_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Nya báfa bembembe bátɛyi bǝ, “Anto Yesu, be bo lǝ ǝnyǝ bo kaminsǝ!” ");
INSERT INTO lip_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yesu ǝnyǝ mǝ nya ɔ́tɛyi mǝ nkǝ, “Bisu lǝ bifi mi ǝsuǝ bisu bete Onanto eto nwǝ lǝǝtǝ wǝ kedi lǝ ɔlɛ ola obe mi.” Se bányɛ bantɔɔ, bǝnyǝ bǝ mǝ bufi áyɛ mǝ. ");
INSERT INTO lip_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Fɛɛ se mǝ ɔni dínyǝ nkǝ wǝ bufi ǝyuǝ wǝǝ, úsinkli úsu nya ɔnlɛ Onanto bɔtɛsǝ ku ɔkɔɛ bembembe. ");
INSERT INTO lip_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Nya úsu óse akonki lǝ Yesu eto ǝnǝmi nya ɔ́sɔ wǝ ani. Nya utidi ǝmǝ eyifo Samarianyǝ. ");
INSERT INTO lip_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Mfó nya Yesu lɛtɔ nkǝ, “Nya inni betidi lefosi míntsya fɛɛ? Se ɔwɔnɔmbǝ fɛfɛ léfe? ");
INSERT INTO lip_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ntsyǝ ibǝ bǝ utidi wǝ lenni Yudanyǝ ǝmfo hã ni nwǝ dísinkli úbǝ nkǝ wǝǝbǝ ɔsɔ Onanto ani?” ");
INSERT INTO lip_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Mfó ǝmǝ nya Yesu lɛtɛyi wǝ nkǝ, “Taka ǝńyǝ, lǝ edu. Fǝ bofokanɔ átsya fǝ bufi.” ");
INSERT INTO lip_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Farisifɔ bǝtsyuǝ átɔ Yesu bǝnkǝ bala bǝ baate lefe nǝ kon Onanto eto sekakedikɔ luubǝ itǝ. Mfó nya Yesu dítǝ mbuayɛ nkǝ, “Onanto eto Sekadidi embubǝ lǝ kusu ko ǝsuǝ betidi loofo bunyǝ. ");
INSERT INTO lip_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Kuutsyuǝ ǝmbɔtɛyi nkǝ, ‘Bebe! Nnyǝ se mfo!’ nye ‘Nnyǝ se mmǝ.’ Itsyise Onanto eto Sekadidi siamǝ fe sekpe mfo lǝ mi nti.” ");
INSERT INTO lip_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Nya Yesu lɛtɛyi wǝ bakasebi nkǝ, “Lefe ditsyuǝ ebubǝ nǝ biɔbɛbɛ biǝ biǝnyǝ diyi nǝ mɔ, Utidi Eto Ubi, luubǝ. Fɛɛ biembunyǝ! ");
INSERT INTO lip_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Betidi bǝtsyuǝ ebubǝ mi nti ini mba lɔɔtɛyi mi nkǝ, ‘Bebe, nnyǝ wǝ mmǝ!’ nye ‘Bebe, nnyǝ wǝ mfo!’ Fɛɛ biensu bɛbɛbɛ mɛ mfó! ");
INSERT INTO lip_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Itsyise fe kase ofamfa laafa ku ute ketsyi lekpake nǝ kesu lebamba, nko kǝ sitinti Utidi Eto Ubi eto bubǝ luutsyǝ nɛ. ");
INSERT INTO lip_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Fɛɛ ele bǝ ibǝ bǝ wooka kanyi bunyǝ tinti nya mmi eto betidi lɔɔni wǝ. ");
INSERT INTO lip_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Asa nnya díbǝ lǝ Noa eto lefe, nnya kǝ nnya luubǝ itǝ le lefe nǝ mɔ, Utidi Eto Ubi, luubǝ bio nɛ. ");
INSERT INTO lip_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Betidi ékedi, bǝkǝnǝ. Nya basani díkakpa bǝsiǝ nya bǝkǝtǝ besio bese isu ese diyi nǝ ǝsuǝ Noa dídufǝ lǝ ɔklɔ kplɛ ǝmǝ kafo. Nya ɔsɔmi lɛni nya ntubibi díyi bóba bókpo kasɔ ka kenke nya bólo betidi kenke. ");
INSERT INTO lip_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Nko kǝ yuubǝ itǝ fe kase íbǝ lǝ Lot eto lefe tsya nɛ. Betidi ékedi, bǝkǝnǝ, nya bákasa asi tsya. Bǝtsyuǝ ǝnyǝ bákakpe bidikǝ, nya bǝtsyuǝ díkato ayo. ");
INSERT INTO lip_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Nya diyi nǝ Lot lɛbɔ lǝ Sodom, ute ku etebambi nnya nkpe lɛyimbi bua lɛwunini itsyi kato íbǝ ékpo lǝ umǝ ǝmǝ ǝsuǝ nya étonsǝ mɛmblɛ kenke. ");
INSERT INTO lip_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Nko ke yuutsyǝ lǝ diyi nǝ ǝsuǝ mɔ, Utidi Eto Ubi, lɔɔbɔ mbǝ nɛ. ");
INSERT INTO lip_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Diyi nǝmfoo, utidi wǝ ńyǝ lǝ wǝ letsya ǝsuǝǝ, mensitɛyi nkǝ weesu diyo lǝ usu ufi kulesa. Nko ke ini lǝ ɔkuɛ utsyǝ ńyǝǝ, wensitɛyi nkǝ weesinkli ubǝ oto lǝ ubǝ ufi kulesa. ");
INSERT INTO lip_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Bekloma lesa nǝ díbǝ lǝ Lot eto usiǝ ǝsuǝ! ");
INSERT INTO lip_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Utidi saa wǝ lela nkǝ wǝǝlǝkǝ wǝ nkpǝǝ, wooyansǝ mu. Nya utidi saa wǝ leyansǝ wǝ nkpǝǝ, wuusinkli unyǝ mu. ");
INSERT INTO lip_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nya ketsye kamfoo, betidi inuǝ ebolabe lǝ bikǝ biɔni ǝsuǝ, nya Onanto ebofo ɔni nya wooyani ɔni olabesǝ. ");
INSERT INTO lip_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Besio inuǝ ebukǝkuǝ nnamfo lǝ kukuǝ kɔni ǝsuǝ. Nya Onanto luulǝkǝ ɔni nya wooyani ɔni uńyǝnsǝ mfó. ");
INSERT INTO lip_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Basani inuǝ ebuńyǝ bakafo nya wuutsyi ɔni udunko nya wooyani unuǝfǝ uńyǝnsǝ mfó.” ");
INSERT INTO lip_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Mfó ǝmǝ nya bakasebi bamǝ lɛtɔ Yesu bǝnkǝ, “Bonamute, lǝ sie?” Nya Yesu dítǝ mbuayɛ nkǝ, “Kaka lesakpǝnkpǝ ntǝ, mfó ebintsyǝ laakpo nɛ.” ");
INSERT INTO lip_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yesu átɛyi wǝ bakasebi lekpa ditsyuǝ óte mǝ nkǝ ele bǝ bakato ola lefe saa nya yanle bǝ elo mǝ ani. ");
INSERT INTO lip_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ɔ́tɛyi mǝ nkǝ, “Okponkpo bua utsyuǝ akɛ lǝ umǝ utsyuǝ wǝ dímankate Onanto sikpi nya wénkebu utidi tsya. ");
INSERT INTO lip_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Nya lǝ umǝ ǝmǝ kee, ɔkɔsiǝ utsyuǝ akɛ mfo wǝ díkesu wǝ ɔflɔ úsukalɛ wǝ lekpakpa nkǝ, ‘Lǝkǝ mɛ lǝ mɔ olo eto bulǝ ǝsuǝ.’ ");
INSERT INTO lip_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Éfo lefe kpǝ, okponkpo ǝmǝ áni wényifo kulesa lǝ etiki nyamǝ ǝsuǝ. Fɛɛ lǝ kalosǝkɔɔ, ɔ́tɛyi wǝ ǝsuǝ nkǝ, ‘Ite bǝ maanté Onanto sikpi nya meemfi utidi keyifo kulesa, ");
INSERT INTO lip_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","lǝ bulǝ bo ɔkɔsiǝ ǝmfo nlɛ mɛ bulǝ esoo, moobe miǝ nwunsǝko wǝ nla wǝ olo eto etiki nyamǝ nlǝkǝ. Lenni nko, wǝǝmbɔyɛ bubǝ nya wǝǝmbutǝ nkɛ lɛnwɔ mfe mfe.’ ” ");
INSERT INTO lip_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Mfó nya Bonamute dísukosǝ nya ɔ́tɛyi mǝ nkǝ, “Bɛnɔ lesa nǝ okponkpo bua ǝmǝ lɛtɛyi. ");
INSERT INTO lip_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Nya mɔmɔɔ, yuubǝ bǝ Onanto embulǝkǝ wǝ betidi ba leewi kakpadi wǝ ketsye ku kakɔmi kato ola kǝtǝ wǝ bǝ ɔwunseko mǝǝ? Nye bomu ebu fǝnkǝ wǝ ofe kama lǝ mǝ bulǝkǝ ǝsuǝ? ");
INSERT INTO lip_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nlɛ mi bɔtɛyi sitinti minkǝ Onanto ebokpo lekpo nya wuutǝ mǝ lɛbɛ lamfolamfo. Fɛɛ lǝ Utidi Eto Ubi ǝbǝǝ, wuunyǝ betidi ba léfo wǝ bánɔ?” ");
INSERT INTO lip_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yesu átɛyi lekpa nǝmfo utǝ betidi ba leebu bǝ mǝ kakle hã ni basɛɛ nya bensi embunyǝ utidi sa wǝ ntǝ fǝ mǝ. ");
INSERT INTO lip_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Nya ɔ́tɛyi nkǝ, “Lǝ lefe ditsyuǝ ǝsuǝǝ, betidi inuǝ bǝtsyuǝ ésu Onanto eto Kedikǝtǝkɔ bǝ lǝ bato ola. Ɔni eyifo Farisinyǝ nya unuǝfǝ diyifo nwǝ laafo oko. ");
INSERT INTO lip_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farisinyǝ ǝmǝ ǝlǝkǝ wǝ ǝsuǝ lete nya óto ola nkǝ, ‘Onanto, maasɔ fǝ ani, itsyise maansɛsǝ ǝnǝmi lǝ atabi ǝsuǝ, nya meenyifo utidi kabua, nya maankpo kusiǝ fe kase betidi bamba leeyifo. Nya maasɔ fǝ ani tsya, itsyise minte fe nwǝ laafo oko wǝ ńyǝ mmǝ tsya seka. ");
INSERT INTO lip_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Maakle kɛnyɛ eyi ǝnuǝ lǝ kɔsida saa ǝsuǝ. Nya meefi lesa nǝ kee minyǝ eto lekpafosile kǝtǝ fǝ.’ ");
INSERT INTO lip_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Fɛɛ nwǝ laafo oko ǝmǝ ǝńyǝ kɔsɛsɛ nya wónla nkǝ woabesǝ wǝ ǝnǝmi kato kulaa tsya. Fɛɛ úfi wǝ ani utǝkǝ lǝ wǝ lɛkɔɛsi nya ɔ́tɛyi nkǝ, ‘Onanto, be mɔ obuayifo ǝmfo lǝ ǝnyǝ mɛ kaminsǝ!’ ” ");
INSERT INTO lip_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Mfó nya Yesu lɛtɛyi mǝ nkǝ, “Nlɛ mi bɔtɛyi nkǝ, se besinkli bésu ayo, nwǝ laafo oko ǝmǝ ale kɛnkɛnkɛ lǝ Onanto eto ǝnǝmi nya inni Farisinyǝ ǝmǝ. Itsyise utidi saa wǝ laabesǝ ǝsuǝ kato, Onanto ebobokosǝ wǝ kasɔ. Nya utidi saa wǝ laaboko sǝ ǝsuǝ kasɔɔ, Onanto ebobesǝ wǝ kato.” ");
INSERT INTO lip_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Betidi bǝtsyuǝ éfi mǝ bebi báboko Yesu ɔflɔ, katɛyi bǝ ufi wǝ ani utǝkǝ lǝ mǝ. Se Yesu eto bakasebi dínyǝ nyamfo, béyǝnki bákpe betidi bamǝ lǝ nnya eso. ");
INSERT INTO lip_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Fɛɛ Yesu ákpadi bekpefi bamǝ óboko wǝ ɔflɔ nya ɔ́tɛyi nkǝ, “Bitǝ lǝ bekpefi lǝ bǝbǝ mɔ ɔflɔ nya bienti mǝ kusu. Itsyise Onanto eto sekakedikɔ te itǝ betidi ba laabokosǝ mǝ ǝsuǝ kasɔ fe bekpefi bamfo eto okle. ");
INSERT INTO lip_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nya bekloma nyamfo biǝnkǝ, utidi saa wǝ dímamfo Onanto eto sekadidi fe dikpefi seka, wǝmbudufǝ se kafo kulefe kulefe, kulefe.” ");
INSERT INTO lip_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Yudafɔ eto uninǝ utsyuǝ átɔ Yesu nkǝ, “Oteasa sɛɛ, be ele bǝ nyifo fɛ lǝ nyǝ nkpǝ manlo?” ");
INSERT INTO lip_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Mfó nya Yesu lɛtɔ wǝ nkǝ, “Beso faakpadi mɛ fǝ ɔsɛɛ? Utidi kuutsyuǝ saa menyifo ɔsɛɛ enso Onanto hã. ");
INSERT INTO lip_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Nyi miǝ biyi kɔfi ko laatɛyi nkǝ, ‘Mankpo kusǝ nye kusiǝ, manlo utidi, menyu, manla fǝ utsyuǝ kɛnyɛ, nya bu fǝ anto ku fǝ ambe.’ ” ");
INSERT INTO lip_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Mfó nya utidi ǝmǝ dítǝ mbuayɛ nkǝ, “Ntsyue afi nyamfo kenke koto kukɔnɔ, itsyi lǝ mɔ sikpefi lefe kǝ.” ");
INSERT INTO lip_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Se Yesu lɛnɔ wǝ ditiki nǝmǝ, ɔ́tɛyi wǝ nkǝ, “Ibu lesa lɔni ele bǝ yifo. Fi bikǝ bia kenke nte fǝ ate, lǝ efi atabi nyamfó ǝtǝ bakombo. Nyamfo luutǝ ǝnyǝ bikǝ ǝtsyǝ lǝ Onanto eto kato nɛ. Nyamfo kama lǝ edu ǝbǝ ǝtǝkǝko mɛ.” ");
INSERT INTO lip_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Fɛɛ lefe nǝ osani ǝmǝ lɛnɔ nya mfo, ǝsuǝ ába wǝ itsyise bikǝ kpǝ kpe wǝ. ");
INSERT INTO lip_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu ǝnyǝ kase ǝsuǝ léba wǝ nya údi etiki ɔ́tɛyi nkǝ, “Ekpe ale itǝ otabinyǝ fɛ lǝ ofo Onanto eto sekakedikɔ budufɔ! ");
INSERT INTO lip_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Nya ekpe ale itǝ otabinyǝ bǝ lǝ udufǝ Onanto eto sekakedikɔ, enso kase ɔtɔmli ku lekoko lɔɔyɛ lǝ okasa eto ofo ofe.” ");
INSERT INTO lip_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Mfó nya betidi ba lɛnɔ nyamfo lɛtɔ Yesu bǝnkǝ, “Nyalɛ owoe kon luunyǝ bofo?” ");
INSERT INTO lip_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Mfó nya Yesu dítǝ mbuayɛ nkǝ, “Lesa nǝ utidi lembofo buyifoo, iyuǝ itǝ Onanto ku buyifo.” ");
INSERT INTO lip_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Mfó nya Petro lɛtɛyi Yesu nkǝ, “Bebe, bo áyani bo ayo eto asa kenke butsyǝ nya búbǝ búntǝkǝko fǝ.” ");
INSERT INTO lip_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Nya Yesu lɛtɛyi mǝ nkǝ, “Sitinti, ɔnukualɛ uni. Nya nla miǝ bete biǝ utidi saa wǝ léyani wǝ diyo utsyǝ nye óyani wǝ usiǝ nye bayimisani nye wǝ antomǝ nye bebi utsyǝ lǝ Onanto eto Sekadidi esoo, ");
INSERT INTO lip_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","wuunyǝ asa nyamfó eto okle kpǝ lǝ nkpǝ bomfo kǝmiǝ ku nkpǝ bo lǝmbɔkɛ kalokɔ ku lǝ lefe nǝ luubǝ tsya kǝmiǝ.” ");
INSERT INTO lip_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu ákpa wǝ bakasebi lefosi inuǝ ba úkǝlǝkǝ mate hã óboko wǝ ɔflɔ nya ɔ́tɛyi mǝ nkǝ, “Bɛnɔ! Bɔtɔ lǝ Yerusalem, kaka asa nnya kenke Onanto eto bǝnyɛlǝkǝtidi lɛwɔni bǝtsyǝ lǝ mɛ, Utidi Eto Ubi ǝsuǝ, luubǝ itǝ nko. ");
INSERT INTO lip_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Betidi ebufi mɛ bakpe lǝ betidi ba lenni Yudafɔ eto ani bǝ lǝ befi mɛ beyifo ǝmǝnsa. Booka mɛ nya bootufǝ ntufǝ bakpo mɛ lǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Bɔɔblɛ wǝ nya boolo wǝ. Fɛɛ lǝ diyi tsyǝfǝ ǝsuǝǝ, nsi wootaka utsyi ɔkɔmǝ ubǝ.” ");
INSERT INTO lip_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Nya asa nyamfo kenkee, bakasebi bamǝ mánnɔ nnya kasɔ. Etiki nyamfo eto kasɔnɔnɔ tsya akula mǝ. Bánnɔ lesa nǝ Yesu lɛtɛyi mǝ mfo eto kasɔ. ");
INSERT INTO lip_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Lǝ lefe nǝ Yesu ńlɛ bɔnyi kafi Yerikoo, unǝmba utsyuǝ ǝsiǝ lǝ kusu ɔflɔ mfó úkatɔ asa. ");
INSERT INTO lip_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Se ɔ́nɔ betidi kpǝ ba nlɛ bofe eto kuduu, ɔ́tɔ nkǝ, “Be nlɛ bubǝ?” ");
INSERT INTO lip_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Bátɛyi wǝ bǝnkǝ, “Yesu Nasaretnyǝ uni nlɛ bofe.” ");
INSERT INTO lip_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Mfó nya ófa bembembe nkǝ, “Yesu, Oka David eto ubi! Be mɛ lǝ ǝnyǝ mɛ kaminsǝ!” ");
INSERT INTO lip_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Mfó nya betidi ba ntɔ sɛtɔ dínyenki bákpe wǝ bátɛyi bǝnkǝ údika. Fɛɛ mɔmɔ bomu óbesǝ ɔkɔɛ kato ófa bembembe nkǝ, “David eto ubi! Be mɛ lǝ ǝnyǝ mɛ kaminsǝ!” ");
INSERT INTO lip_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Lǝ nnya eso Yesu ále únyǝ nya ɔ́tɛyi nkǝ bakpa unǝmba ǝmǝ baboko wǝ ɔflɔ. Se úbǝ óyo wǝ ɔflɔ, Yesu átɔ wǝ nkǝ, ");
INSERT INTO lip_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Be faala fǝ nyifo ntǝ fǝ?” Unǝmba ǝmǝ ǝtǝ mbuayɛ nkǝ, “Anto, nla miǝ lǝ nsi nnyǝ asa.” ");
INSERT INTO lip_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Mfó nya Yesu lɛtɛyi wǝ nkǝ, “Nyalɛ sinkli ǝnyǝ asa! Fǝ bofokanɔ átsya fǝ.” ");
INSERT INTO lip_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Lamfolamfo, usinkli únyǝ asa nnya útǝkǝko Yesu nya ɔ́yɛ ɔntɔ ɔnlɛ Onanto bɔtɛsǝ. Nya se betidi kpǝ bamfó dínyǝ nyamfoo, mǝmblɛ kenke átɛsǝ Onanto. ");
INSERT INTO lip_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu ésu údufǝ Yeriko, nya ɔ́yɛ lǝ umǝ ǝmǝ kafo ɔntɔ. ");
INSERT INTO lip_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Mfó nya mba laafo umǝnko eto uninǝ utsyuǝ wǝ baakpo Sakeo lɛkɛ, nya úyifo otabinyǝ tinti. ");
INSERT INTO lip_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Úkabɛbɛ kusu ko ǝsuǝ wɔɔyɛ lǝ unyǝ utidi wǝ kon Yesu ni. Fɛɛ se úyifo utidi kliminti esoo, ɔnlɛ kusu ku kutsyuǝ bunyǝ se betidi mfui eso. ");
INSERT INTO lip_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Nyaso útsyetsyi ɔ́tɔ betidi bamfo sɛtɔ nya óbe kuyi bǝ lǝ unyǝ Yesu, itsyise óte nkǝ wuubǝ ɔyɛ mfo. ");
INSERT INTO lip_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Se Yesu léyo kuyi komǝ kalɔɔ, úkǝnǝ úńyǝ nya óbesǝ ǝnǝmi kato nya ɔ́tɛyi Sakeo nkǝ, “Sakeo, kɔse lǝ ayifǝ ǝbǝ kasɔ, itsyise fǝ diyo mɔɔsɔnɔ mi nɛ.” ");
INSERT INTO lip_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sakeo ákɔse ɔ́yifǝ úbǝ kasɔ nya útǝ Yesu edufǝ ku disuǝyuǝ tinti. ");
INSERT INTO lip_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Betidi ba dínyǝ nyamfó étsyiko etiki budi kawɔnɔnɔ lǝ Yesu ǝsuǝ katɛyi bǝ, “Osani ǝmfo esukayɛ utidi ǝmfo wǝ ni obuayifo eto diyo.” ");
INSERT INTO lip_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Mfó nya Sakeo létaka úńyǝ nya ɔ́tɛyi Bonamute ǝmǝ nkǝ, “Anto! Muufi mɔ bikǝ bia nkpe mɛ kenke eto kutsyǝ ntǝ bakombo. Nya betidi ba kenke eto bikǝ míntafa mímfoo, moofo mǝ nnya kayo eto sena ntsyǝ lǝ nnya kɛnyɛ.” ");
INSERT INTO lip_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Mfó nya Yesu lɛtɛyi wǝ nkǝ, “Mmi ǝmfo bofo ǝbǝ diyo nǝmfo, itsyise utidi wǝ mfo tsya eyifo Abraham eto kafo eto ubi. ");
INSERT INTO lip_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Nya mɔ, Utidi Eto Ubii, mbǝ miǝ lǝ nlǝkǝ betidi ba kenke lénya kusu mboko nkpǝ.” ");
INSERT INTO lip_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Mfó nya betidi bamfó ńyǝ banlɛ asa nnya Yesu nlɛ mǝ bɔtɛyi bɔnɔ. Nya úsukosǝ nya ɔ́tɛyi mǝ lekpa ditsyuǝ, itsyise ofe ɔlɛ bɔnyi kafi Yerusalem nya bébu bǝ Onanto eto Sekadidi siamǝ ebubǝ sitinti mɔmɔ. ");
INSERT INTO lip_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Nya ɔ́tɛyi nkǝ, “Lǝ lefe nǝ léfe mǝǝ, osani wǝ nkpe dibu utsyuǝ ákɛ mfó wǝ létaka úsu kasɔ famfamfa kǝtsyuǝ ǝsuǝ lǝ bǝtsyǝ wǝ seka. Nya úfi nsusu nkǝ, wuusinkli ubǝ wǝ umǝ. ");
INSERT INTO lip_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Fɛ úduu, ókpadi wǝ beyifoyifo lefosi utsyǝ. Nya útǝ utsyuǝ saa atabi eto otobe ɔni. Nya ɔ́tɛyi mǝ nkǝ, ‘Bifi atabi nyamǝ beto ɔlɔ isu ese lefe nǝ muubǝ.’ ");
INSERT INTO lip_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Fɛɛ osani ǝmfo eto umǝ eto betidi ékekisi wǝ, nyaso bátsyese batɔnkpe bǝtsyuǝ bǝtǝkǝko wǝ bǝ besu batɛyi Okankplɛ nkǝ, ‘Boanla boǝ osani ǝmfo di bo oka.’ ");
INSERT INTO lip_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Tsya, bǝtsyǝ osani ǝmǝ seka nya usi úsinkli úbǝ umǝ ǝmǝ. Lamfolamfo, útǝ bákpadi wǝ beyifoyifo bamǝ bǝbǝ bátsya lǝ wǝ ǝnǝmi nkǝ lǝ ɔnɔ kutǝkǝ ko bǝnyǝ. ");
INSERT INTO lip_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Uyifoyifo tutɛ ǝbǝ nya ɔ́tɛyi wǝ nkǝ, ‘Bonamute, nnyǝ atabi eto etobe lefosi ntǝkǝ lǝ ɔni ǝmǝ fǝtǝ mɛ mfó ǝsuǝ.’ ");
INSERT INTO lip_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Mfó nya Onamute ǝmǝ lɛtɛsǝ wǝ ɔ́tɛyi nkǝ, ‘Álɔ eyifo! Eyifo uyifoyifo sɛɛ! Se fálɛ keyifo kɛkɛ kamfo ola fáyɛnko ke lǝ kusu sɛɛ esoo, muufi fǝ ntsyǝ seka lǝ kǝmǝ lefosi ǝsuǝ.’ ");
INSERT INTO lip_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Uyifoyifo nuǝfǝ tsya ǝbǝ ɔ́tɛyi wǝ nkǝ, ‘Bonamute, nnyǝ atabi eto etobe ɛnɔ ntǝkǝ lǝ ɔni wǝ fǝtǝ mɛ ǝsuǝ!’ ");
INSERT INTO lip_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Nya Onamute ǝmǝ lɛtɛyi uyifoyifo ǝmǝ tsya nkǝ, ‘Fǝǝ, ebudi seka lǝ kǝmǝ ɛnɔ ǝsuǝ!’ ");
INSERT INTO lip_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Uyifoyifo bamba ǝbǝ nya ɔ́tɛyi nkǝ, ‘Bonamute, nyǝ fǝ atabi eto otobe ɔni wǝ fǝtǝ mɛ. Mfí nnya nkle lǝ mɔ ofiamɛ ǝsuǝ nkula. ");
INSERT INTO lip_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nte fǝ sikpi itsyise eyifo nwǝ nkpe ale. Nya feefi lesa nǝ lenni fǝ lele kafloma keyifo fǝ lele. Nya feefi didisa nǝ fǝmankpe kulaa tsya keyifo fǝ lele.’ ");
INSERT INTO lip_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Mfó nya Onamute ǝmǝ lɛtɛyi wǝ nkǝ, ‘Uyifoyifo bua feni! Fǝ kosate eto kɛnyɛ eto etiki ni nnya muufi nlo fǝ dikpi! Eyi fǝ nyifo utidi wǝ nkpe ale. Nya meefi lesa nǝ lenni mɔ lele kafloma keyifo mɔ lele. Nya meefi lesa lǝ kaka mánkpe ku ditsyuǝ. ");
INSERT INTO lip_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Nya lǝ eyi nkoo, beso fémemfi mɔ atabi esu akpe lǝ atabi kǝtsyǝkɔ? Mfóo, nyi miǝ muunyǝ kutǝkǝ lǝ nnya ǝsuǝ lǝ nsinkli ntsyi mbǝ.’ ");
INSERT INTO lip_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Mfó nya ɔ́tɛyi betidi ba ńyǝ mfo nkǝ, ‘Bɛlɛ atabi nyamǝ befo lǝ wǝ ani bitǝ uyifoyifo wǝ nkpe atabi eto etobe lefosi.’ ");
INSERT INTO lip_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Fɛɛ betidi bamfo átɛyi wǝ bǝnkǝ, ‘Bonamute, uyifoyifo ǝmfó ebunyǝ atabi eto etobe lefosi útsyǝ!’ ");
INSERT INTO lip_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Mfó nya Onamute ǝmǝ dítǝ mbuayɛ nkǝ, ‘Nlɛ fǝ bɔtɛyi sitinti minkǝ, utidi wǝ asa ntee, wǝ ni nwǝ Onanto luutǝ okpe enso nɛ. Nya utidi wǝ kulesa lentee, nnya nte wǝ kulaa tsyaa, bɔɔlɛ ni bafo wǝ lǝ ani. ");
INSERT INTO lip_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Nya mɔmɔɔ, binǝ mɔ balo ba dímanla bǝ ndi seka lǝ mǝ ǝsuǝ beboko mfo lǝ belo mǝ lǝ mɔ ǝnǝmi.’ ” ");
INSERT INTO lip_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Se Yesu lɛtɛyi mǝ asa nyamfo ólosǝǝ, ɔ́tɔ mǝ sɛtɔ úsu Yerusalem. ");
INSERT INTO lip_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Lefe nǝ ɔnlɛ Betfage ku Betania bɔfi lǝ Nnuǝbi eto Eyi eto Kɔtini ɔflɔɔ, ótsyese wǝ bakasebi inuǝ ɔ́tɛyi nkǝ bakatɔ. ");
INSERT INTO lip_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Mfó nya ɔ́tɛyi mǝ nkǝ, “Bikatɔ lǝ umǝ kɛkɛ wǝ nkpe sɛtɔ mfó. Nya lǝ bɛlɛ wǝ budufǝǝ, biunyǝ ɔflimu eto lɛkpɔ ditsyuǝ nǝ bátsyasǝ lǝ ukuǝ bǝńyǝsǝ nǝ utidi kuutsyuǝ saa dímǝnsiǝ tɔ unyǝ. Benyankli ni ku ukuǝ lǝ bifi wǝ beboko mfo. ");
INSERT INTO lip_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Lǝ utidi utsyuǝ atɔ mi lesa nǝ eso bényankli nii, bɛtɛyi wǝ biǝnkǝ, ‘Bonamute nlɛ ni bohiã.’ ” ");
INSERT INTO lip_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Bakasebi bamǝ áyifǝ lǝ kusu bésu bǝnyǝ lesa saa fe kase Yesu lɛtɛyi mǝ. ");
INSERT INTO lip_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Nya lǝ lefe nǝ bǝńyǝ banlɛ ubuki ǝmǝ bonyankli kǝlǝkǝǝ, ubuki ǝmǝ eto basate átɔ mǝ bǝnkǝ, “Beso bɛnlɛ wǝ bonyankli?” ");
INSERT INTO lip_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Mfó nya bakasebi bamǝ dítǝ mbuayɛ bǝnkǝ, “Bonamute ahiã wǝ.” ");
INSERT INTO lip_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Nya béfi ubuki ǝmǝ báboko Yesu. Mfó nya béfi mǝ mfia bésensǝ bákpo lǝ ubuki ǝmǝ ǝsuǝ nya báwunsǝko Yesu óbe úsiǝ lǝ wǝ. ");
INSERT INTO lip_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Se úsiǝ lǝ wǝ ǝsuǝ nya báyɛ bantɔɔ, betidi bǝtsyuǝ éfi mǝ mfia bésensǝ bákpo lǝ kusu. ");
INSERT INTO lip_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Lefe nǝ Yesu ńlɛ bɔnyi kafi Yerusalem lǝ kusu kaka ɔnlɛ Nnuǝbi eto Eyi eto Kɔtini bɔyifǝ kǝbǝǝ, wǝ bakasebi kpǝ bamǝ étsyiko Onanto ani bɔsɔ nya báto keyudu banlɛ bofa bembembe lǝ asa kplɛ nnya bǝnyǝ eso. ");
INSERT INTO lip_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Nya bátɛyi bǝnkǝ, “Atɛsǝ itǝ Oka wǝ nlɛ bubǝ lǝ Bonamute eto diye ǝsuǝ! Diyuǝ lǝ lefo kato kenke. Nya diyǝnde itǝ Onanto!” ");
INSERT INTO lip_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Mfó nya Farisifɔ ba lɛkɛ lǝ sitiditu siamǝ nti lɛtɛyi Yesu bǝnkǝ, “Oteasa, ninko fǝ bakasebi lǝ bayɛ kudu bokpo!” ");
INSERT INTO lip_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Mfó nya Yesu dítǝ mbuayɛ nkǝ, “Nlɛ mi bɔtɛyi sitinti minkǝ lǝ bayɛ kudu bokpoo, aba nyamfo kosate ebutsyǝ kasɔ ku kudu bokpo.” ");
INSERT INTO lip_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Kase Yesu lɛyɛ ɔntɔ lǝ Yerusalem kedufǝkɔɔ, nya únyǝ umǝ ǝmǝǝ, úwi keku lǝ wǝ disi. ");
INSERT INTO lip_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Nya ɔ́tɛyi nkǝ, “Nla sitinti miǝ lǝ nnya ete biunyǝ bete mmi eto diyi nǝmfo eto lesa nǝ loohiã itǝ bǝ lǝ binyǝ diyuǝ ini! Fɛɛ ibǝ ese mɔmɔɔ, bɛnlɛ bunyǝ lǝ bete! ");
INSERT INTO lip_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Lefe ditsyuǝ ebubǝ se mi balo luuńyǝ batsyilama mi lǝ kalebe saa kenke. Nya booti ǝbiǝ kenke nya kulesa lembofo budufǝ nye kabɔ kǝbǝ lekple. ");
INSERT INTO lip_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Betidi ebɔtsylɔsǝ umǝ mfo kenke nya boolo betidi ba nkpe lǝ wǝ kenke. Nya leba ku ditsyuǝ sa embubu ditǝkǝ lǝ ni kǝtsyǝkɔ. Itsyise bɛni nya bíǝnyǝ lǝ bete lefe nǝ Onanto díbǝ nkǝ lǝ ofo mi lǝ nkpǝ!” ");
INSERT INTO lip_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesu ésu údufǝ Onanto eto kedikǝtǝkɔ nya útsyiko mba nlɛ bikǝ bote mfó bola kabɔsǝ. ");
INSERT INTO lip_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Nya ɔ́tɛyi mǝ nkǝ, “Báwɔni bákpe lǝ Awɔnisa Kɛnkɛ eto Kukue ǝsuǝ bǝ Onanto átɛyi nkǝ, ‘Mɔ diyoo, betidi ebokpadi ni bǝ diyo kaka betidi laato ola.’ Nya mi dífi mfó befianisǝ beyu eto kabiɔkɔ!” ");
INSERT INTO lip_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Diyi saa, Yesu ákate asa lǝ Onanto eto Kedikǝtǝkɔ mfó. Onanto eto besumunyǝ ninǝ ku Afi eto bateasa ku betidi eto batɔnkotɔnko ála bǝ lǝ balo wǝ. ");
INSERT INTO lip_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Fɛɛ bǝnyǝ kusu ko ǝsuǝ bɔɔyɛ, itsyise betidi kpǝ akɛ mfó ba eto ato léfo wǝ etiki nyamǝ kekleke eso. ");
INSERT INTO lip_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Diyi lɔni se Yesu lɛkɛ katé betidi asa lǝ Onanto eto kedikǝtǝkɔ, kedi mǝ Ditiki Sɛɛ eto asa, besumunyǝ ninǝ ku afi eto bateasa ku umǝ eto beninǝ ǝbǝ mfó. ");
INSERT INTO lip_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Mfó nya bǝbǝ bátɛyi wǝ bǝnkǝ, “Tɛyi bo ǝsuǝale nnya fankpe fɛ feeyifo asa nyamfo eto okle. Nya owoe dítǝ fǝ ǝsuǝale nyamǝ?” ");
INSERT INTO lip_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Mfó nya Yesu dítǝ mbuayɛ nkǝ, “Bitǝ lǝ ntɔ mi etiki ǝtsyuǝ lǝ nnɔ. ");
INSERT INTO lip_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Nte ǝsuǝale nnya Yohanes lɛkɛ fɛ úyifo ntuflǝsǝflǝsǝ eto lekpa útǝ betidi, Onanto ɔflɔ itsyi lee, betidi bomu ɔflɔ itsyi?” ");
INSERT INTO lip_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Mfó nya bétsyiko kǝnǝ kasɔ lǝ mǝ nti katɛyi bǝ, “Be ele bǝ bɔtɛyi? Lǝ bɔ́tɛyi boǝ Onanto ɔflɔ únyǝ ǝsuǝale nyamǝ utsyiko, ɔtɔ bo nkǝ, ‘Be díbǝ eso biamfó Yohanes bɛnɔ?’ ");
INSERT INTO lip_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Nya lǝ bɔtɛyi boǝ utidi ɔflɔ ófo nnya utsyiko, katsyakɔ eto betidi bamfo kenke ebubǝ bakpɔ bo aba, itsyise mǝmblɛ kenke áfo bánɔ bǝ Onanto eto Unyɛlǝkǝtidi wǝ Yohanes ni nɛ.” ");
INSERT INTO lip_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Lǝ nyaso bǝlǝkǝ kɛnyɛ bátɛyi bǝnkǝ, “Boante kaka únyǝ ǝsuǝale nyamǝ útsyiko.” ");
INSERT INTO lip_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Mfó nya Yesu tsya lɛtɛyi mǝ nkǝ, “Nko ke eso mintsya mǝmbɔtɛyi mi kaka mimfo ǝsuǝale fɛ meeyifo asa nyamfo eto okle.” ");
INSERT INTO lip_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Mfó nya Yesu lɛtɛyi bǝtidi bamǝ lekpa nǝmfo nkǝ, “Lǝ lefe nǝ lefe mǝ, osani utsyuǝ áfo kudiyi eto ɔkuɛ utsyuǝ. Se úsu kusu kutsyuǝ nkǝ lǝ usu usiǝ itǝ lefe nǝ dikulǝ esoo, úfi wǝ ɔkuɛ ǝmǝ ókpe lǝ beyifoyifo bǝtsyuǝ eto ani. ");
INSERT INTO lip_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Se lefe léyo bǝ betsyiko eyibibi nyamǝ bɔlɛɛ, ótsyese wǝ uyifoyifo utsyuǝ nkǝ usu ofo wǝ kedikɔ lǝ ɔkuɛ ǝmǝ ǝsuǝ lǝ beyifoyifo ɔflɔ oboko wǝ. Fɛɛ beyifoyifo bamǝ áblɛ uyifoyifo ǝmǝ nya bála wǝ babɔsɛ, nya bǝntǝ wǝ kulesa. ");
INSERT INTO lip_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Lǝ nyaso ótsyese uyifoyifo bamba. Fɛɛ beyifoyifo bamǝ áblɛ wuntsya, nya bákpe wǝ kofani, nya bála wǝ bátsyese, nya bǝntǝ wǝ kulesa. ");
INSERT INTO lip_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ótsyese uyifoyifo tsyǝfǝ. Nya beyifoyifo bamǝ lɛblɛ wǝ bǝtǝkǝ wǝ afabe lǝ ǝsuǝ nya bála wǝ bǝlǝkǝ lǝ mfó. ");
INSERT INTO lip_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Mfó ǝmǝ nya ɔkuɛnsate ǝmǝ lɛtɔ wǝ ǝsuǝ nkǝ, ‘Be ele bǝ nyifo? Mootsyese mɔ ubi lala nya mfo nnɔ miǝ boobu wǝ.’ ");
INSERT INTO lip_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Fɛɛ se beyifoyifo bamǝ dínyǝ ubi ǝmǝ, bátɛyi mǝ ǝsuǝ bǝnkǝ, ‘Biǝnyǝ ɔkuɛnsate ǝmǝ eto ubi kosate ni nwǝ mfo. Bitǝ lǝ bolo wǝ ete wǝ bikǝ biamfo kenke lǝ befiani bo bele!’ ");
INSERT INTO lip_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Nyaso bǝnǝ wǝ babɔsǝ lǝ ɔkpɔ ǝmǝ kafo nya bálo wǝ.” Mfó ǝmǝ nya Yesu lɛtɔ mǝ nkǝ, “Be ɔkuɛnsate ǝmǝ luuyifo beyifoyifo bamǝ mfo? ");
INSERT INTO lip_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Nla miǝ bete biǝ woolo beyifoyifo bamǝ kenke nya wuufi ɔkuɛ ǝmǝ okpe lǝ beyifoyifo bamba lǝ ani.” Se betidi bamǝ lɛnɔ nko, bátɛyi bǝnkǝ, “Owo lo! Yanle bǝ ibǝ nko!” ");
INSERT INTO lip_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yesu ábe mǝ tũũ nya ɔ́tɔ mǝ nkǝ, “Bíankla Awɔnisa Kɛnkɛ nyamfo eto kasɔ nlɛ bote, ‘Leba nǝ mba laato ayo lɛni bǝ dimbǝ kɔnɔɔ, ni bomu díbǝ lefiani nǝ nso bofe lǝ afɛfɛ kenke nti?’ ");
INSERT INTO lip_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Utidi saa wǝ luutusǝ ɔsɔ lǝ leba nǝmǝ ǝsuǝ, eboba wuli wuli wuli. Nya lǝ leba nǝmǝ tsya ǝbǝ lɛsɔ utsyuǝ lǝ ǝsuǝǝ, diukuǝ wǝ muɛmuɛmuɛ.” ");
INSERT INTO lip_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Afi eto bateasa ku Onanto eto besumunyǝ eto beninǝ ákpe nkɛale bǝ lǝ bǝmuǝ Yesu lamfolamfo, itsyise bǝnyǝ bǝ mǝ ɔnlɛ sitinti nyaso ɔ́tɛyi lekpa nǝmǝ nɛ. Fɛɛ báte betidi bamfo sikpi. ");
INSERT INTO lip_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Lǝ nnya esoo, bákabɛbɛ kusu bamba ko ǝsuǝ bɔɔyɛ bǝmuǝ wǝ. Bǝlǝkǝ betidi bǝtsyuǝ kalɔ kalɔ. Nya bákle ku mǝ bǝnkǝ besu Yesu ɔflɔ. Nya béyifo ǝsuǝ fe Ditiki Sɛɛ nǝmǝ mǝ kosate léla bǝ lǝ bate itǝ mǝ ǝsuǝ. Nya bátsyese mǝ bǝnkǝ babio Yesu uyibi lǝ etiki ǝsuǝ lǝ bǝnyǝ kusu ko bɔɔyɛ befi wǝ bakpe lǝ Roma eto Aba eto uninǝ eto ani. ");
INSERT INTO lip_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Lǝ nnya esoo, mba laabio kanɔ asa bamfó ésu Yesu ɔflɔ. Nya bátɔ wǝ bǝnkǝ, “Oteasa, buyi boǝnkǝ asa nnya faatɛyi ku nnya fate kenke eyifo etiki tlolololo. Nya buyi tsya boǝ aambe utidi eto ǝnǝmi lǝ alɛ asa buyifo. Bomu aate ɔnukualɛtiki nnya ǝsuǝ Onanto laala nkǝ betidi yifo. ");
INSERT INTO lip_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Lǝ nyamfo eso bola boǝ boate lǝ bo kɔfi ǝtǝ kusu bǝ bofo umǝnko butǝ Romafɔ eto Okankplɛ lee yǝntǝ kusu?” ");
INSERT INTO lip_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Fɛɛ Yesu ǝnyǝ mǝ kɔwɛsu bua útsyǝ lekpo nya ɔ́tɛyi mǝ nkǝ, ");
INSERT INTO lip_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Bifi sika flubia eto atabi beboko lǝ mbe. Owoe eto disi ku diye ntǝkǝ mfo?” ");
INSERT INTO lip_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Bátɛyi bǝnkǝ, “Okankplɛ Kaisare eto ale ini.” Nya Yesu lɛtɛyi mǝ nkǝ, “Bifi lesa saa nǝ ni Okankplɛ eto lele bitǝ Okankplɛ. Nya bifi lesa saa nǝ ni Onanto eto lele bitǝ Onanto.” ");
INSERT INTO lip_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Nya lǝ betidi eto ǝnǝmi mfóo, bamfó wǝ bumuǝ lǝ kulesa ǝsuǝ. Mǝ kɛnyɛ ǝkpǝ mǝ nya iyifo mǝ yani lǝ ditiki nǝ Yesu lɛtɛyi eso. ");
INSERT INTO lip_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadukifɔ bǝtsyuǝ mba laatɛyi bǝnkǝ bǝkpǝnkpǝ ensi embotakaa, ǝbǝ Yesu ɔflɔ nya bátɛyi wǝ bǝnkǝ, ");
INSERT INTO lip_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Oteasa, Moses áwɔni lǝ afi nnya útǝ bo nkǝ, ‘Lǝ osani utsyuǝ ǝkpǝ nya oyani wǝ usiǝ utsyǝ nya bánle bebi saa, nyalɛ ele bǝ osani ǝmfo eto ɔyimisani, fi usio ǝmǝ ufi. Nya wǝ ku ɔkɔsiǝ ǝmǝ lǝ bale bebi. Nya bebi bamfóo, betidi ebunyǝ mǝ fe osani wǝ dimankɛ ubi saa eto bale.’ ");
INSERT INTO lip_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Lǝ lefe ditsyuǝ, bayimisani ekuanse akɛ. Osaibi ninǝ éfi kusiǝ nya úbǝ úkpǝ nya wǝ ku wǝ usiǝ mánle ubi saa. ");
INSERT INTO lip_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ɔyimisani nuǝfǝ tsya éfi ɔkɔsiǝ ǝmǝ. ");
INSERT INTO lip_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Utsyǝfǝ tsya nko kǝ. Nya lesa nǝmǝ diyifo nko itǝ bayimisani ekuanse bamfo kenke. Mǝmblɛ kenke ǝkpǝ lǝ lefǝ nǝ mǝ kuutsyuǝ saa manle. ");
INSERT INTO lip_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Lǝ kalosǝkɔ kenke, usio ǝmǝ kosate ǝbǝ úkpǝ. ");
INSERT INTO lip_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Nya mɔmɔɔ, diyi nǝ ǝsuǝ bekpǝnkpǝ luusinkli bataka, owoe eto usiǝ usio ǝmǝ luudi se mǝmblɛ kenke dífi wǝ lǝ lefe nǝ lefe mǝ?” ");
INSERT INTO lip_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesu ǝtǝ mbuayɛ nkǝ, “Nkpǝ bomfo ǝsuǝ ete basani ku besio leefi bǝsiǝ kǝsiǝ bese. ");
INSERT INTO lip_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Fɛɛ basani ku besio kenke ba díńyǝ itǝ bǝ bataka betsyi ɔkɔmǝ bǝbǝ nkpǝ bo lensiembolo kulefee, bensiembufi bǝsiǝ nye bǝsiǝ bese. ");
INSERT INTO lip_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Bootsyǝ fe kase Onanto eto batɔnkpe nte, nya bensiembukpǝ tsya. Beyifo Onanto eto bebi itsyise bátaka betsyi ɔkɔmǝ. ");
INSERT INTO lip_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Nyamfo ni ɔnukualɛ wǝ Moses dílǝkǝ ote lǝ Asawɔni Kɛnkɛ eto Kukue ǝsuǝ nkǝ bekpǝnkpǝ si bootaka bǝbǝ bǝsiǝ nkpǝ. Itsyise lǝ lefe nǝ únyǝ lǝ kuyi ko díkǝnyǝ ute eto ǝnǝmi, ókpadi Onamute fe Abraham eto Onanto ku Isak eto Onanto ku Yakob tsya eto Onanto. ");
INSERT INTO lip_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Nyamfo lɛ bote bǝ mba díkekpǝ kokoo, besi nkpǝ. Nyaso uyifo mǝ Onanto tsya.” ");
INSERT INTO lip_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Mfó afi eto bateasa bamfo eto bǝtsyuǝ dítǝ mbuayɛ bǝnkǝ, “Oteasa, ǝtǝ mbuayɛ kukɔnɔ!” ");
INSERT INTO lip_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Nyamfo eto kamaa, kutsyuǝ saa ménsikpe ɔkɔɛ lǝ ɔtɔ kulesa tsya. ");
INSERT INTO lip_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesu átɔ mǝ nkǝ, “Ntsyǝ ibǝ fɛ betidi lɛtɛyi bǝ Nwǝ Onanto Lékpo Ɔhile Utsyǝ ebutsyi Oka David eto bebi eto kafo? ");
INSERT INTO lip_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Nya Oka David ǝmǝ kosate átɛyi lǝ kusǝ eto kukue ǝsuǝ nkǝ, ‘Onamute ǝmǝ átɛyi mɔ Onamute nkǝ, “Si ǝsiǝ lǝ mɔ kodiani eto kutsyǝ ");
INSERT INTO lip_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","isu ese lefe nǝ muufi fǝ balo nkpe lǝ fǝ kokpa kalɔ.” ’ ");
INSERT INTO lip_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Nya lǝ Oka David ákpadi wǝ nkǝ Onamutee, ntsyǝ íbǝ fɛ Nwǝ Onanto Lékpo Ɔhile Utsyǝ luuyifo Oka David eto kafo eto ubi?” ");
INSERT INTO lip_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Lǝ lefe nǝ betidi ba tã dínyǝ béketsyue ato lǝ asa nnya Yesu nlɛ bɔtɛyi, ɔ́tɛyi wǝ bakasebi nkǝ, ");
INSERT INTO lip_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Bebe kukɔnɔ lǝ afi eto bateasa ǝsuǝ. Betidi ba laala botsyilama lǝ mǝ awu kplɛ kplɛ ǝsuǝ. Nya baala bǝ betidi kǝsiǝsǝ mǝ ku dibu lǝ asi kafo. Mǝ laala nlebe kplɛ busiǝ lǝ Yudafɔ eto katsyakɔ nya baala ndikɔ kpaa busiǝ lǝ eyikedikɔ. ");
INSERT INTO lip_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Beesu bakɔɛsiǝ ɔflɔ bǝ lǝ bawunsǝ ko mǝ, fɛɛ baawɛ mǝ kalɛ mǝ asa kafo. Nya baato kala kǝntsyɛ, kate ǝsuǝ lǝ betidi eto ǝnǝmi. Nyaso mǝ kotonǝnǝ ebɔkɛ ale eso utsyuǝ saa eto kole!” ");
INSERT INTO lip_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Lǝ kedikǝtǝkɔ mfoo, Yesu ábesǝ ǝnǝmi kato nya únyǝ kase batabinyǝ leefi mǝ ǝtǝsa kesu kakpe lǝ kedikǝtǝkɔ eto otobe kafo. ");
INSERT INTO lip_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Nya únyǝ tsya kase ɔkɔsiǝ okombo utsyuǝ dífi pesewa inuǝ butsyuǝ ókpe lǝ otobe ǝmǝ kafo. ");
INSERT INTO lip_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Nya ɔ́tɛyi nkǝ, “Nlɛ mi bɔtɛyi minkǝ ɔkɔsiǝ okombo ǝmfoo, útǝ lesa nǝ nso bafɛfɛ bamfo kenke. ");
INSERT INTO lip_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Itsyise babamba bamfoo, mǝǝ, lesa nǝ baala lǝ nǝ bǝǝnyǝ nti, ete ni nǝ bǝtǝ nɛ. Fɛɛ usio ǝmfo wǝ sekombo, lesa nǝ kenke ntǝ wǝ nǝ wuudi mfó, nya ni nǝ úfi útǝ mfo nɛ.” ");
INSERT INTO lip_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Lefe nǝmfóo, bakasebi bǝtsyuǝ akɛ mfó kedi etiki itsyi lǝ Onanto eto kedikǝtǝkɔ ǝsuǝ. Nya bátɛyi kase kedikǝtǝkɔ kamǝ laanɔ bobe ku kase aba nnya béfi báto diyo nǝmǝ laanɔ bobe ku asa nnya betidi dítǝ béfi bálɔ Onanto eto kedikǝtǝkɔ kamǝ. Mfó ǝmǝ nya Yesu lɛtɛyi mǝ nkǝ, ");
INSERT INTO lip_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Lesa saa nǝ bɛnlɛ bunyǝ mfoo, lefe ditsyuǝ ebubǝ se leba saa lensiembubu lǝ ni kǝsiǝkɔ. Bomu betidi ebusense ditsyuǝ saa lekpo lǝ kasɔ.” ");
INSERT INTO lip_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Mfó nya bátɔ wǝ bǝnkǝ, “Oteasa, dimamfe yuubǝ itǝ nko? Nya be ini buufi bunyǝ lǝ bote boǝ lefe nǝ asa nyamfo luubǝ éboyo?” ");
INSERT INTO lip_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesu átɛyi mǝ nkǝ, “Bińyǝ bikabe kusu itǝ bǝ kuutsyuǝ saa ǝmbɔwɛ mi okpe. Betidi kpǝ ebubǝ batɛyi bǝnkǝ mɔ ditiki bǝbǝ bulǝkǝ kate, bookǝbǝ katɛyi bǝnkǝ, ‘Mɔ uni,’ nya ‘Lefe nǝmǝ éboyo.’ Fɛɛ biǝntǝkǝko mǝ kama. ");
INSERT INTO lip_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Bíanté sikpi lǝ bɛnɔ lema eto kudu nya betidi letaka bǝńyǝ lǝ bǝtsyuǝ ǝsuǝ. Asa nyamfo eto kakle ebutsyiko bubǝ, fɛɛ inni nya kasɔ ni bǝnkǝ kalosǝkɔ ebubǝ eyo elo.” ");
INSERT INTO lip_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yesu esi úsukosǝ nya ɔ́tɛyi nkǝ, “Ese ebɔkpɔ ku mǝ bǝtsyuǝ, nya bekakedikɔ lɔɔbɔkpɔ ku mǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kasɔ ebutinkǝ kekleke. Nya kukpɛnsɛ tsya luubǝ kekleke. Nya efimbi akpa akpa tsya luubǝ nlebe nlebe kenke. Nya ekpinsa kpǝ luutsyiko bubǝ lǝ difule ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Nya fɛ asa nyamfo luubǝ ibǝ, betidi ebumuǝ mi nya bookpe mi bulǝ, bate mi ohiã. Betidi ebokpa mi besuko akpokakpokɔ lǝ Yudafɔ eto ntsyakɔ nya bookpe mi lǝ ayo. Nya bookpa mi besuko baka ku Aba eto bǝnyɛsiǝ eto ǝnǝmi bǝ lǝ bakponko mi akpo lǝ mɔ disi eso. ");
INSERT INTO lip_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Nya lǝ lefe nǝmfóo, kusu ebɔsini mi bǝ lǝ bidi Onanto eto Ditiki Sɛɛ nǝmǝ. ");
INSERT INTO lip_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Bimuǝ ǝsuǝ bitsyǝ bɛtɔnsǝ itǝ bǝ biembulǝ ǝsuǝ lǝ kusu ko biɔyɛ bilǝkǝ mi ǝsuǝ kɛnyɛ eso. ");
INSERT INTO lip_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Itsyise muutǝ mi kobe ku kɛnyɛ yayaya itǝ bǝ mi balo eto kuutsyuǝ embofo buńyǝ lǝ mi ǝnǝmi nye bǝtǝ mi etiki eto mbuayɛ kulefe. ");
INSERT INTO lip_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Mi anto mǝ ku bayimisani ku mi betidi ku mi bayɛtsyuǝ ebufi mi bakpe lǝ ani. Nya boolo mi bǝtsyuǝ. ");
INSERT INTO lip_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Betidi ba tã ebukisi mi lǝ mɔ disi eso. ");
INSERT INTO lip_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Fɛɛ mi disi eto sɛwɔnii, lɛ sɔni kplon embonya. ");
INSERT INTO lip_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Bińyǝ kekleke lǝ binyǝ nkpǝ bo lǝmbɔkɛ kalokɔ kulefe. ");
INSERT INTO lip_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Lefe nǝ bínyǝ biǝ bamamanyǝ esu bǝńyǝ batsyilama Yerusalem, ete biote biǝ umǝ ǝmfo eto boba kakpo lǝ kasɔ eto lefe eboyo. ");
INSERT INTO lip_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Lefe nǝ mfóo, betidi ba kenke nkpe lǝ Yudea, ele bǝ betsyetsyi bedu besu babiɔ lǝ atini ǝsuǝ lǝ babɔ lǝ kanyi ǝsuǝ. Nya betidi bakenke nkpe lǝ umǝnkplɛ ǝmǝ kafo, ele bǝ babɔ lǝ wǝ bedu. Nya betidi ba kenke nkpe lǝ mbuto ku kǝmǝ ka lɛfi mfo, yanle bǝ besu umǝnkplɛ ǝmǝ kafo. ");
INSERT INTO lip_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Itsyise lefe nǝ mfó ni kotonǝnǝ eto eyi nnya ele bǝ ibǝ fe kase Awɔnisa Kɛnkɛ eto Kukue eto etiki léte. ");
INSERT INTO lip_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Yɔɔkɛ ale tinti itǝ besio ba ni bafonlɛ ku bebiambe ba nlɛ bebi bɔyimisǝ. Kanyinyǝnyǝ kekleke kǝtsyuǝ ebubǝ kasɔ kamfo ǝsuǝ. Nya Onanto eto kotonǝnǝ ebubǝ betidi bamfo ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Boolo bǝtsyuǝ ku asiabi. Nya boomuǝ bǝtsyuǝ lǝ ǝsuǝale besuko nsɔ bamba kpǝ ǝsuǝ. Nya betidi ba lenni Yudafɔ, luudi sɛkplɛ baayinkǝ Yerusalemfɔ bakpe isu ese lefe nǝ Onanto lɛtɔnɔ utǝ mǝ. ");
INSERT INTO lip_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Ekpinsa kpǝ ebubǝ lǝ kofe ku kofande ku befandebi eto ǝnǝmi ǝsuǝ. Nya kasɔ eto betidi kenke eboyansǝ kusubebe saa. Nya sikpi kplɛ ebubǝ lǝ betidi ǝsuǝ lǝ kase lekpo eto kudu ku kase diuyǝnki nyanklaa eso. ");
INSERT INTO lip_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ǝnǝmi ebutsyiko betidi bonanko lǝ sikpi sia luumuǝ mǝ lǝ lefe nǝ befi bǝńyǝ bensǝkǝ itǝ lesa nǝ luubǝ lǝ kawunsiǝ kenke ǝsuǝ eso. Itsyise asa nnya nkpe lǝ difule ensiembuńyǝ lǝ nnya kǝńyǝnkɔ. ");
INSERT INTO lip_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Nyamfo eto kamaa, Utidi Eto Ubi ebɔbɔ ubǝ lǝ difule lǝ asɔmi loku kǝmiǝ lǝ ǝsuǝale kplɛ ku lǝ diyǝnde kplɛ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Lefe nǝ asa nyamfo mfe nlɛ bubǝǝ, bɛlɔ mi ǝsuǝ bitsyǝ lǝ bikabe kusu, itsyise mi dilǝkǝfe ebɔfi elo.” ");
INSERT INTO lip_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Mfó nya Yesu lɛtɛyi mǝ lekpa ditsyuǝ nkǝ, “Bibu disi bitsyi lǝ kudiyi ku eyi bamba kenke ǝsuǝ bebe. ");
INSERT INTO lip_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Lǝ binyǝ biǝ afanto fɔfɔ etsyiko bɔbɔɔ, bete biǝ kasɔmite eboyo elo. ");
INSERT INTO lip_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Nko kǝ ini lǝ binyǝ biǝ asa nyamfo nlɛ bubǝǝ, bete biǝ Onanto eto Sekadidi siamǝ eto dibǝfe fe yaala lǝ eyo. ");
INSERT INTO lip_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Nlɛ mi bɔtɛyi sitinti minkǝ asa nyamfo kenke ebubǝ fɛ bǝtsyuǝ ba nsi nkpǝ mfo luukpǝ balo. ");
INSERT INTO lip_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Kato ku kasɔ ebubǝ efe, fɛɛ mɔ etiki embubǝ efe kulefe. ");
INSERT INTO lip_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Bebe kukɔnɔ biǝ biemfi mi lefe bitǝ budi ku sitekpe eto disuǝyuǝ mate. Nya kuutsyuǝ memfi wǝ ǝsuǝ utǝ bɔkpɔ lǝ kawunsiǝ kamfo eto asa ǝsuǝ. Lenni nko, diyi nǝmǝ ebubǝ ditu mi lǝ kafuafua ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Nya yuuyifo fe kase uyibibiobio lǝǝlǝkǝ ubuki seka. Etsyise yuubǝ lǝ kawunsiǝ kenke eto betidi ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Nyaso bitǝkǝ ǝnǝ lǝ bińyǝ bikato ola lefe saa bǝ lǝ binyǝ ǝsuǝale lǝ bɛbɔ befe lǝ keni saa ǝsuǝ lǝ lesa saa nǝ luubǝ mfo ǝsuǝ lǝ itǝ bǝ biofo buńyǝ lǝ mɔ, Utidi Eto Ubi eto lekpokakpokɔ.” ");
INSERT INTO lip_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Lǝ eyi nyamfó kenke ǝsuǝǝ, Yesu éfi ɔ́lɛ betidi bamfo asa bote lǝ Onanto eto kedikǝtǝkɔ. Nya lǝ ditsyitsyo lefee, úkesu Nnuǝbi eto Eyi eto Kɔtini ékesu kalabe. ");
INSERT INTO lip_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Nya olesiǝtu saa, betidi bamfo ékesu kedikǝtǝkɔ kamǝ lǝ banɔ wǝ asatete. ");
INSERT INTO lip_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Lefe nǝ Yudafɔ leedi Nnamfokuã eto Abolo eto Diyi nǝ baakpo bǝ Ukpǝ Asa Bo Ɔ́yila ebɔfi. ");
INSERT INTO lip_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Fɛɛ se Onanto eto besumunyǝ ninǝ mǝ ku afi eto bateasa díkate betidi bamfó sikpi esoo, bákabɛbɛ kusu ko ǝsuǝ bɔɔyɛ balo Yesu lǝ kabiɔbiɔ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Mfó nya Obonsam dídufǝ lǝ Yuda wǝ baakpo tsya bǝ Iskariot ǝsuǝ. Nyaa uyifo Yesu eto lefosi bakasebi inuǝ bamǝ eto ɔni. ");
INSERT INTO lip_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Nyaso Yuda ésu Onanto eto besumunyǝ ninǝ ku Onanto eto kedikǝtǝkɔ eto mba laase mfó eto beninǝ ɔflɔ. Nya bédi etiki itsyi lǝ kusu ko ǝsuǝ wɔɔyɛ fɛ boomuǝ Yesu ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Bǝnyǝ disuǝyuǝ, nya bátɛyi wǝ bǝ bootǝ wǝ atabi. ");
INSERT INTO lip_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Nya Yuda tsya lɛtɔnɔ nko. Nyaso útsyiko lefe sɛɛ bɔbɛbɛ lǝ kusu ko ǝsuǝ wɔɔyɛ ufi Yesu okpe mǝ lǝ ani lǝ betidi bamǝ eto mante mante ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Lǝ nnya kamaa, diyi nǝ baalo basamubi itǝ Ukpǝ Asa Bo Ɔ́yila eto Diyi itǝ Nnamfokuã eto Diyididi ǝbǝ léyo. ");
INSERT INTO lip_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Nya Yesu létsyese Petro ku Yohanes ɔtɔnsǝ ku kɛnyɛ kamfo nkǝ, “Bisu bɛlɔ Ukpǝ Asa Bo Ɔ́yila eto didisa bitsyǝ itǝ bo budi.” ");
INSERT INTO lip_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Bátɔ wǝ bǝnkǝ, “Sie faala fǝ bɔlɔ ni butsyǝ?” ");
INSERT INTO lip_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Nya útǝ mbuayɛ nkǝ, “Lǝ bidufǝ Yerusalem eto umǝ ǝmǝǝ, osani utsyuǝ ebubǝ otsyako mi wǝ ntsyi ntu ku ɔlɔtsyi. Bitǝkǝko wǝ lǝ bidufǝ diyo nǝ wuudufǝ. ");
INSERT INTO lip_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Nya lǝ bɛtɛyi oyosate ǝmǝ biǝnkǝ, ‘Oteasa nkǝ bɔtɔ fǝ nkǝ, “Nte diyo nǝ kafo ele bǝ Mɔ ku mɔ bakasebi luubǝ bedi Ukpǝ Asa Bo Ɔ́yila eto didisa?” ’ ");
INSERT INTO lip_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Woote mi abanslo kato eto diyo kplɛ ditsyuǝ nǝ bálɔ bǝtsyǝ nya bétsyue ǝsiǝsa lǝ ni kafo bǝtsyǝ. Bɛlɔ didisa nǝmǝ bitsyǝ mfó.” ");
INSERT INTO lip_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Mfó nya báyifǝ kusu bésu bǝnyǝ lesa saa pɛpɛɛpɛ fe kase Yesu lɛtɛyi mǝ. Nya bálɔ Ukpǝ Ása Bo Ɔ́yila eto edisa nyamǝ bǝtsyǝ mfó. ");
INSERT INTO lip_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Se lefe léyoo, Yesu ku wǝ batɔnkpe bamǝ ésu bǝsiǝ kasɔ bǝ lǝ bedi lesa. ");
INSERT INTO lip_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ɔ́tɛyi mǝ nkǝ, “Iyifo mɔ lelabi kokooko bǝ lǝ ndi Ukpǝ Asa Bo Ɔ́yila eto didisa nǝmfo ku mi fɛ lǝ nnyǝ kanyi. ");
INSERT INTO lip_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Nya nlɛ mi bɔtɛyi sitinti minkǝ mensiembudi ni bio isu ése lefe nǝ muudi ni lǝ Onanto eto sekakedikɔ.” ");
INSERT INTO lip_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Nnya kamaa, Yesu éfi ditǝnǝkɔbe nya ɔ́sɔ ani. Nya ɔ́tɛyi nkǝ, “Befo nyamfo lǝ binǝ bitǝ bǝtsyuǝ. ");
INSERT INTO lip_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nlɛ mi bɔtɛyi minkǝ idu mɔmɔ ɛntɔɔ, mensiembunǝ ntu bo lɛbɔ itsyi lǝ wanyi eto awɔnsa ǝsuǝ isu ese lefe nǝ Onanto eto sekadidi luubǝ.” ");
INSERT INTO lip_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Nya úfi abolo utsyuǝ nya ɔ́sɔ Onanto ani. Nya úbudi nnya nya úfi útǝ mǝ. Nya ɔ́tɛyi mǝ nkǝ, “Nyamfo ni mɔ ǝsuǝ eto sinǝ sia muufi ntǝ Onanto kedi lǝ mi disi. Biyifo nyamfo bifi bikakloma mɛ.” ");
INSERT INTO lip_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Nko ke tsya úfi ntǝ ku lɛkɔbe úfi utǝ mǝ lǝ didisa nǝmǝ kama nya ɔ́tɛyi mǝ nkǝ, “Lɛkɔbetɔ nǝmfo eyifo Onanto eto ketsyue fɔfɔ ka utsyue utsyǝ fe ditsyǝbi, nǝ ni mɔ kɔtɔ ko mookpo lǝ kasɔ lǝ mi disi. ");
INSERT INTO lip_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Fɛɛ bete biǝ nwǝ dídu mɛ útǝǝ, si ɔlɛ kɔni bokpe ko mɛ lǝ ɔkpɛ ɔni mfo. ");
INSERT INTO lip_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Nya mɔ, Utidi Eto Ubi, mbǝ nlɛ bofe fe kase Onanto lése uyi utsyǝ. Fɛɛ mbɔbuɛ itǝ utidi wǝ luudu mɛ utǝ.” ");
INSERT INTO lip_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Mfó nya beetsyiko bǝtsyuǝ bɔtɔ kanɔ bǝ owoe luuyifo nyamfo. ");
INSERT INTO lip_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Kǝnǝ ǝbǝ kedufǝ bakasebi bamǝ nti itsyi nwǝ luudi ɔkplɛ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Nya Yesu lɛtɛyi mǝ nkǝ, “Betidi ba lenni Yudafɔɔ, mǝ baka kpe ǝsuǝale lǝ mǝ betidi ǝsuǝ kenke. Nya baka bamfo kpe diye nǝ baala bǝ betidi bamfo kakpo mǝǝ, nǝ ni bǝ ‘Bafonǝtidi.’ ");
INSERT INTO lip_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Fɛɛ inni nko ele bǝ itsyǝ lǝ mi nti. Bomu utidi wǝ ni nwǝ nso kenke lǝ mi ntii, ele bǝ uyifo wǝ ǝsuǝ ɔkɛkɛ enso. Fɛɛ nwǝ ni ɔtɔnkotɔnkoo, ele bǝ ofiani nwǝ leesumu betidi. ");
INSERT INTO lip_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Nya owoe ni ɔkplɛnyǝ onso? Nwǝ lǝǝsiǝ lǝ ɔpunu ekedi lee, nwǝ leesumu wǝ? Lǝ ɔnukualɛɛ, nwǝ lǝǝsiǝ lǝ ɔpunu ekedi. Fɛɛ mɔɔ, nkpe mi lǝ nti fe nwǝ leesumu. ");
INSERT INTO lip_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Bíokpe ɔkɔɛ koko bítǝkǝko mɛ lǝ mɔ lefe kekleke kenke ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Nya fe kase mɔ Anto dítǝ mɛ ǝsuǝale nkǝ ndi sekaa, nko kǝ mintsya luutǝ mi ǝsuǝale nyamǝ eto okle nɛ. ");
INSERT INTO lip_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Biudi binǝ lǝ mɔ lesakedikɔ lǝ mɔ sekakedikɔ. Nya biusiǝ lǝ akankpomɛ ǝsuǝ lǝ bidi seka lǝ Israel eto lefosi atobi ǝnuǝ nyamfo ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Mfó nya Yesu lɛtɛyi Simon Petro nkǝ, “Simon, Simon! Tsyue ato lǝ anɔ! Onanto ǝtǝ Obonsam kusu nkǝ oto mimblɛ obe lǝ usense mi nti, mba nkpe kɔnɔku mba lǝmbǝ kɔnɔ lǝ fe kase ɔkuɛmfo laaflɛ kamɔ kǝlǝkǝ lǝ kofo nti. ");
INSERT INTO lip_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Fɛɛ Simon, mboto ola lǝ fǝ disi bǝ lǝ fǝ bofokanɔ lǝ bɔyɛ kɛnyɛ buyuǝ. Nya lefe nǝ fuusinkli ǝbǝ mɔ ɔflɔɔ, kpe fǝ bayimitsyuǝ nkɛale.” ");
INSERT INTO lip_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Nya Petro lɛtɛyi wǝ nkǝ, “Bonamute, nńyǝ nlɛ kusu bobe miǝ bonko fǝ kenke ebolabe lǝ Aba eto diyo nya lǝ nkpǝ ku fǝ kulaa tsya!” ");
INSERT INTO lip_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Nya Yesu lɛtɛyi wǝ nkǝ, “Petro, nlɛ fǝ bɔtɛyi miǝ ketsye kamfo fɛ ukusɛ luutǝ kɛnyɛɛ, ebutudi sitsyǝ fǝ enyi mɛ.” ");
INSERT INTO lip_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Mfó nya Yesu lɛtɔ wǝ bakasebi nkǝ, “Lefe ditsyuǝ nǝ léfe se míntsyese mi kusu nya míntǝ bíentsyi otabitobe nye kusuyɛyɛtobe nye afɔkpa kuǝtsyuǝ, béhiã lesatsyuǝ?” Bǝtǝ mbuayɛ bǝnkǝ, “Kulesa mánhiã bo kula kon.” ");
INSERT INTO lip_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Nya Yesu lɛtɛyi mǝ nkǝ, “Fɛɛ mɔmɔɔ, utidi wǝ nkpe atabi eto otobe utsyuǝ nye kusuyɛyɛtobe utsyuǝ, ufi ɔlɛ. Nya nwǝ kalande kukǝtsyuǝ lentee, ele bǝ ufi wǝ awu nye kafia ote, lǝ usu oya ke. ");
INSERT INTO lip_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Nya nlɛ mi bɔtɛyi minkǝ Awɔnisa Kɛnkɛ eto Kukue eto lesa nǝ báwɔni bákpe mfó lɛ bɔtɛyi nkǝ, ‘Bákla wǝ bákpe lǝ betidi bua ntii,’ ele bǝ ibǝ itǝ nko lǝ mɛ ǝsuǝ. Itsyise lesa nǝ báwɔni itsyi lǝ mɛ ǝsuǝǝ, lɛ bubǝ kǝtǝ.” ");
INSERT INTO lip_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Nya bakasebi bamǝ lɛtɛyi bǝnkǝ, “Bonamute, bee! Nnyǝ nlanle nnuǝ nte mfo!” Mfó nya útǝ mbuayɛ nkǝ, “Isiǝ.” ");
INSERT INTO lip_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesu áyɛ ɔ́bɔ lǝ umǝ ǝmǝ nya úsu Nnuǝbi eto Eyi eto Kɔtini ǝsuǝ fe kase woala buyifo. Nya wǝ bakasebi bamǝ tsya dítǝkǝko wǝ. ");
INSERT INTO lip_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Se óyo kaka ǝmǝǝ, Yesu átɛyi wǝ bakasebi nkǝ, “Beto ola, lǝ bɛyɛ disi butǝ le botokabe ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Nnya kamaa, óyani mǝ utsyǝ mfó ɔ́yɛ usu sɛtɔ sɛkɛ nya óse akonki óto ola. ");
INSERT INTO lip_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Nya ɔ́tɛyi nkǝ, “Nto, lǝ alaa, lǝkǝ kanyi eto lɛkɔbe nǝmfo etsyiko lǝ mɔ ɔflɔ. Fɛɛ menyifo lǝ mɔ lelabi ǝsuǝ, bomu lǝ fǝ lele ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Mfó nya Onanto eto ɔtɔnkpe dítsyi kato úbǝ úlǝkǝ ǝsuǝ óte wǝ nya ókpe wǝ nkɛale. ");
INSERT INTO lip_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Nya lǝ kanyi kplɛ ka ɔnlɛ bunyǝ esoo, usi óto ola kekleke ókpe. Nya diwi nǝ lɛbɔ lekpo wǝ eyifo fe atɔbo nya nlɛ bola kakpo lǝ kasɔ. ");
INSERT INTO lip_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Se Yesu létaka lǝ kaka ɔnlɛ ola boto mfóo, úsinkli úsu wǝ bakasebi bamǝ ɔflɔ. Nya úbǝ únyǝ nkǝ bálabe selabe itsyi lǝ lɛwɛnlo nǝ ǝsuǝ bakɛ eso. ");
INSERT INTO lip_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Mfo nya ɔ́tɛyi mǝ nkǝ, “Beso bɛnlɛ selabe? Betaka lǝ beto ola lǝ kase biembudufǝ lǝ botokabe ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Lefe nǝ Yesu ńyǝ ɔnlɛ etikii, betidi kpǝ bǝtsyuǝ áyɛ bétu wǝ. Yuda wǝ ni bakasebi lefosi inuǝ bamǝ eto ɔni lɛtɔnko mǝ. Ɔ́yɛ úsu Yesu ɔflɔ nkǝ lǝ ɔfiɔ wǝ lǝ kola. ");
INSERT INTO lip_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Fɛɛ Yesu átɛyi Yuda nkǝ, “Yuda, bubǝ fǝbǝ fǝ aafiɔ mɔ, Utidi Eto Ubi, lǝ kola lǝ efi mɛ akpe lǝ betidi eto ani?” ");
INSERT INTO lip_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Lefe nǝ bakasebi ba lɛkɛ mfó ku Yesu dínyǝ lesa nǝ luubǝ ibǝ, bátɔ Yesu bǝnkǝ, “Bonamute, bɔkpɔnko mǝ ku bo nlande lee?” ");
INSERT INTO lip_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Mfó nya bakasebi bamǝ nti eto ɔni lésiabe Usumunyǝ Ninǝ Kenke eto uyifoyifo eto kodianito úfǝ. ");
INSERT INTO lip_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Fɛɛ Yesu áni ko mǝ ɔ́tɛyi nkǝ, “Isiǝ! Bitǝ mǝ kusu!” Mfó nya útidi uyifoyifo ǝmǝ eto koto nya wǝ koto dísinkli kótsya wǝ. ");
INSERT INTO lip_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Nya Yesu lɛtɛyi besumufɔ ninǝ ku mba laase Disumuyo eto beninǝ ku kusǝ eto beninǝ ba díbǝ mfo bǝ lǝ bǝbǝ bǝmuǝ wǝ nkǝ, “Beso ele bǝ bifi keyi ku nlande bibǝ fe uwudifɔ mini? ");
INSERT INTO lip_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Bonko mi ákɛ lǝ Yudafɔ eto kedikǝtǝkɔ diyi saa tsya bíatɛtsyi biǝ biǝmuǝ lǝ ǝsuǝale mɛ ǝsuǝ. Fɛɛ mi lefe léyo bǝ biyifo nko se Obonsam eto ǝsuǝale ntekǝ kato.” ");
INSERT INTO lip_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Besumunyǝ ninǝ ku baka bamfó ǝmuǝ Yesu, nya béfi wǝ bésuko Usumunyǝ Ninǝ Kenke eto diyo. Nya Petro tsya dítǝkǝko mǝ kama kama. ");
INSERT INTO lip_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Betidi bǝtsyuǝ ákpe ute utsyuǝ lǝ diyo nǝmǝ eto lekple, nya Petro tsya dísu úsiǝ lǝ mǝ nti. ");
INSERT INTO lip_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Se besio eto uyifoyifo ɔni dínyǝ Petro se ute díyǝnde okpo wǝ lǝ ǝsuǝ se usi mfóo, óbe wǝ tũũ nya ɔ́tɛyi nkǝ, “Utidi ǝmfo tsya ǝǝtǝkǝko Yesu.” ");
INSERT INTO lip_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Fɛɛ Petro áni nyamfo nya ɔ́tɛyi nkǝ, “Usio, minyi wǝ kulaa tsya!” ");
INSERT INTO lip_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Lǝ lefe kliminti ditsyuǝ eto kama, osani utsyuǝ tsya ǝnyǝ Petro wǝ únyi nya ɔ́tɛyi wǝ nkǝ, “Fintsya mǝ nti eto ɔnɔ feni?” Fɛɛ Petro esi útǝ mbuayɛ nkǝ, “Osani, nni mɔ uni!” ");
INSERT INTO lip_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Íyifo fe lebombosɔsɔ lɔni eto kama, osani bamba utsyuǝ tsya ébǝ únyǝ kekleke ɔ́tɛyi nkǝ, “Kǝnǝ ku kǝtsyuǝ saa ǝmbǝ lǝ nyamfo ǝsuǝ bǝnkǝ osani ǝmfo tsya ǝtǝkǝko Yesu, itsyise Galileanyǝ uni!” ");
INSERT INTO lip_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Fɛɛ Petro ǝtǝ mbuayɛ nkǝ, “Osani, mante lesa nǝ fanlɛ bɔtɛyi mfo kula kula!” Lamfolamfo, fe kase unsi únyǝ ɔnlɛ etiki, ukusɛ ko ditǝ kɛnyɛ. ");
INSERT INTO lip_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Bonamute ǝmǝ ékensǝ óbe Petro. Mfó ǝmǝ nya Petro lékloma nkǝ Bonamute ǝmǝ átɛyi wǝ nkǝ, “Fɛ ukusɛ luutǝ kɛnyɛ ketsye kamfoo, ebutudi kɛnyɛ sitsyǝ sɔ̃ɔ̃ fǝ enyi mɛ.” ");
INSERT INTO lip_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Petro ábɔ úsu lekple nya úwi keku kekleke. ");
INSERT INTO lip_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Betidi ba díkase Yesu, ǝmǝ wǝ nya báblɛ wǝ. ");
INSERT INTO lip_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Bákle wǝ ǝnǝmi nya báblɛwǝ, nya bátɔ wǝ bǝnkǝ, “Owoe lɛsɔ fǝ? Tɛyi bo!” ");
INSERT INTO lip_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Nya báka wǝ lǝ esu bamba kpǝ ǝsuǝ tsya. ");
INSERT INTO lip_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Se kale dísiǝǝ, kusǝ komǝ eto beninǝ ku besumunyǝ ninǝ ku afi eto bateasa ǝbǝ bǝsiǝ. Nya bákpa Yesu bésuko mǝ ǝnǝmi. ");
INSERT INTO lip_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Nya betidi ba díbǝ batsya mfó lɛtɔ Yesu bǝnkǝ, “Tɛyi bo lǝ fǝ ni Nwǝ Onanto Lékpo Ɔhile Utsyǝ ǝmǝ.” Mfo nya útǝ mbuayɛ nkǝ, “Lǝ ntɛyi mi lesatsyuǝ tsyaa, biǝmbofo bɛnɔ. ");
INSERT INTO lip_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Nya lǝ ntɔ mi etiki ǝtsyuǝ, biǝmbofo kɛnyɛ bulǝkǝ katɛyi mɛ kulesa. ");
INSERT INTO lip_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Fɛɛ idu mɔmɔ ɛntɔɔ, Onanto wǝ ni ǝsuǝalenyǝ kenke ebutsyǝ mɔ, Utidi Eto Ubi, lǝ wǝ kodiani.” ");
INSERT INTO lip_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Mfó nya mǝmblɛ lɛtɔ wǝ bǝnkǝ, “Nyalɛ, fǝ ni Onanto eto Ubi ǝmǝ?” Útǝ mbuayɛ nkǝ, “Mi kosate nlɛ bɔtɛyi biǝnkǝ wǝ mini, nya nko ini nɛ.” ");
INSERT INTO lip_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Bátɛyi bǝnkǝ, “Yensihiã bo bǝ kuutsyuǝ saa si ubǝ udi adansiɛ lǝ nyamfo ǝsuǝ. Bo kosate ánɔ asa nnya ɔ́tɛyi!” ");
INSERT INTO lip_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Nya mǝmblɛ létaka nya béfi Yesu bésuko Pilato ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Mfó bétsyiko etiki butsyi lǝ wǝ ǝsuǝ katɛyi bǝnkǝ, “Búmuǝ utidi ǝmfo se ɔnlɛ bo kusǝ eto betidi bokpa kayɛnko lǝ kusu bua ǝsuǝ. Nya ɔnlɛ mǝ bɔtɛyi nkǝ, bénsiko umǝnko bǝtǝ Roma eto Okankplɛ. Nya úsi ɔ́tɛyi tsya nkǝ wǝ ni Nwǝ Onanto Lékpo Ɔhile Utsyǝ nya uni Oka tsya.” ");
INSERT INTO lip_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilato átɔ wǝ nkǝ, “Fǝ ni Yudafɔ eto Oka ǝmǝ?” Nya Yesu dítǝ mbuayɛ nkǝ, “Nko ini fe kase fanlɛ bɔtɛyi nɛ.” ");
INSERT INTO lip_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Mfó nya Pilato lɛtɛyi besumunyǝ ninǝ ku sitiditu siamǝ nkǝ, “Mǝnnyǝ kulesa lǝ utidi ǝmfo ǝsuǝ nǝ eso ele bǝ nlo wǝ dikpi.” ");
INSERT INTO lip_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Fɛɛ mǝmǝ ǝńyǝ kekleke bátɛyi bǝnkǝ, “Wǝ asa nnya woate ǝtǝ botaka kǝńyǝ ǝbǝ idufǝ lǝ Yudea eto betidi kenke nti. Útsyǝ nyamfo kasɔ lǝ Galilea, nya úkaboko nnya mfo tsya.” ");
INSERT INTO lip_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Se Pilato lɛnɔ ditiki nǝmfoo, ɔ́tɔ mǝ nkǝ, “Galileanyǝ ni utidi ǝmfo?” ");
INSERT INTO lip_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Nyaso se óte nkǝ Yesu étsyi Galilea eto lekpake nǝ ǝsuǝ Herodes nlɛ seka budi esoo, úfi wǝ ótsyese Herodes ɔflɔ. Nya Herodes ǝmfo akɛ lǝ Yerusalem lǝ lefe nǝmfó ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ǝsuǝ ǝyuǝ Herodes tinti se únyǝ Yesu, itsyise wɔ́ɔnɔ wǝ kɔsɔ koko nya óla nkǝ lǝ unyǝ wǝ kokooko. Nya ɔnlɛ kusu bobe nkǝ wuunyǝ Yesu lǝ uyifo ayanisa ǝtsyuǝ lǝ obe. ");
INSERT INTO lip_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Nyaso Herodes átɔ Yesu etiki kpǝ, fɛɛ Yesu ménfe kɛnyɛ utǝ mbuayɛ saa. ");
INSERT INTO lip_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Besumunyǝ ninǝ ku afi eto bateasa ábɔ bǝbǝ sɛtɔ nya bála nnyɛ kplɛ, kplɛ bǝtǝkǝ Yesu. ");
INSERT INTO lip_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herodes ku wǝ bamamanyǝ ákpe Yesu kɔfiɔ ku kofani. Nya béfi awu nnya lefo koya ǝtsyuǝ bákpe wǝ nya besi bákpa wǝ bésuko Pilato ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Diyi nǝmfo hã ǝsuǝ nya Herodes ku Pilato léfiani bayɛtsyuǝ, itsyise kɔɔ, balo bédi lǝ bǝtsyuǝ. ");
INSERT INTO lip_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilato ákpadi besumunyǝ ninǝ ku umǝ eto beninǝ ku betidi ba létsya mfo ɔkɔ. ");
INSERT INTO lip_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Nya ɔ́tɛyi mǝ nkǝ, “Mi lékpa utidi ǝmfo béboko mɛ biǝ ɔlɛ betidi bokpa kayɛnko lǝ kusu bua ǝsuǝ. Nya mɔmɔɔ, ńtɔ wǝ etiki lǝ mi kosate eto ǝnǝmi. Nya mǝnnyǝ kabua saa lǝ wǝ ǝsuǝ fe kase mi léla bítǝkǝ wǝ. ");
INSERT INTO lip_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodes tsya mǝnnyǝ kulesa bua saa lǝ wǝ ǝsuǝ, itsyise úsinkliko wǝ ótsyese bo. Utidi ǝmfo ményifo kulesa nǝ ele bǝ bolo wǝ dikpǝnkpi. ");
INSERT INTO lip_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Nyaso muutǝ lǝ bablɛ wǝ kuyibi lǝ nyani wǝ lǝ udu.” ");
INSERT INTO lip_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Lǝ Ukpǝ Ása Bo Ɔ́yila eto eyididi saa ǝsuǝǝ, iyifo Pilato eto ketsyue bǝ oyani mba bákpe lǝ diyo eto ɔni lǝ mǝ nti utǝ mǝ. ");
INSERT INTO lip_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Mǝmblɛ áfa bembembe bátɛyi bǝnkǝ, “Lo wǝ! Lǝ ayani Baraba ǝtǝ bo!” ");
INSERT INTO lip_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Baraba ǝmfoo, bákpe wǝ lǝ diyo ɛyɛ lǝ bulǝ butsyuǝ bo ókpe únyǝ lǝ Yerusalem eto umǝ ku wǝ utidi wǝ ólo ǝsuǝ eso. ");
INSERT INTO lip_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Nya se Pilato léla nkǝ lǝ oyani Yesu esoo, usi údi betidi bamǝ etiki. ");
INSERT INTO lip_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Fɛɛ bákpo kudu bembembe bákpe lǝ wǝ etiki nnya ɔnlɛ bɔtɛyi ǝsuǝ bǝ “Sɔ wǝ amanklasǝ lǝ uyikabie ǝsuǝ! Sɔ wǝ amanklasǝ lǝ uyikabie ǝsuǝ!” ");
INSERT INTO lip_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilato esi ɔ́tɛyi mǝ ditsyǝfǝ nkǝ, “Nya nte kabua ka úyifo? Mǝnnyǝ kabua ka úyifo eso ele bǝ nlo wǝ dikpǝnkpi! Muutǝ lǝ bablɛ wǝ keyibi lǝ nyani wǝ.” ");
INSERT INTO lip_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Fɛɛ bofa ko bensi banlɛ bembembe katɛyi bǝnkǝ, “Ele bǝ lǝ basɔ Yesu bamanklasǝ lǝ uyikabie ǝsuǝ.” Nya lǝ kalosǝkɔ, bǝtǝkǝ wǝ kato. ");
INSERT INTO lip_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Nyaso Pilato ála etiki nyamǝ úlǝkǝ fe kase betidi bamǝ léla. ");
INSERT INTO lip_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Óyani utidi nwǝ baala útǝ mǝ. Utidi wǝ bakponkpo lékpe lǝ diyo itǝ bulǝ bo ókpe ku wǝ utidilolo eso. Nya óyani Yesu ókpe mǝ lǝ ani nkǝ lǝ beyifo lesa nǝ bála ku wǝ. ");
INSERT INTO lip_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Bamamanyǝ bamǝ ákpa Yesu bédunko. Nya se bányɛ lǝ kusu bantɔ, bátsyako Kirenenyǝ utsyuǝ wǝ baakpo Simon wǝ dítsyi kebuto kǝtsyuǝ ɔntɔ lǝ Yerusalem. Bǝńyǝnsǝ wǝ báyinkǝ wǝ bákpe bǝnkǝ ofo uyi wǝ Yesu ntsyi mfo utsyi lǝ utǝkǝko wǝ kama. ");
INSERT INTO lip_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Betidi kpǝ bǝtsyuǝ ǝtǝkǝko Yesu kama. Nya besio bǝtsyuǝ akɛ lǝ mǝ nti ba díkewi nku ku kaminsǝ kǝtǝ wǝ. ");
INSERT INTO lip_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesu ékensǝ óbe nya ɔ́tɛyi mǝ nkǝ, “Yerusalem eto besio, bienwi keku bitǝ mɛ. Bomu biwi lǝ mi ku mi bebi eto disi. ");
INSERT INTO lip_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Itsyise lefe ditsyuǝ ebubǝ nǝ betidi lɔɔtɛyi bǝnkǝ, ‘Diyuǝ itǝ bakonɔ ku mba eto belefie ubi dímǝnsiǝtɔ unyǝ ku ami nnya bányimi tɔ bǝnyǝ!’ ");
INSERT INTO lip_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Lefe nǝmfó ni lefe nǝ betidi lɔɔtɛyi atini bǝ, ‘Beba bekpo bo lǝ ǝsuǝ!’ Nya bɔɔtɛyi akpenkpe bǝ, ‘Bɛkula bo!’ ");
INSERT INTO lip_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Itsyise lǝ balɛ asa nyamfo eto okle buyifo lǝ kuyi kuã ǝsuǝǝ, ntsyǝ yuutsyǝ itǝ kuyi koya?” ");
INSERT INTO lip_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Bákpa betidi bamba inuǝ ba ni babuayifo bésu kalokɔ ku Yesu. ");
INSERT INTO lip_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Se bésu báyo kaka baakpo Ditidisikɔbee, básɔ Yesu bámanklasǝ lǝ uyikabie ǝsuǝ mfó. Nya betidi inuǝ bamǝ tsyaa, básɔ mǝ bámanklasǝ lǝ keyi ǝsuǝ lǝ Yesu eto simǝni ku sediani. ");
INSERT INTO lip_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Mfó nya Yesu lɛtɛyi nkǝ, “Nto, fi atsyɛ mǝ, itsyise benyi lesa nǝ banlɛ buyifo.” Lǝ nyamfo eto kamaa, bamamanyǝ bamǝ ésie Yesu eto awu bǝtǝ bǝtsyuǝ lǝ kase asa nnya bákpo basɛ lété ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Betidi bamǝ kenke ǝńyǝ mfó balɛ bobe nya Yudafɔ eto beninǝ bamǝ ńyǝ bánlɛ Yesu bumǝ katɛyi bǝnkǝ, “Ófo betidi bamba lǝ nkpǝ, bitǝ lǝ ulǝkǝ wǝ ǝsuǝ lǝ bobe, lǝ wǝ ni Kristo, Nwǝ Onanto Lékpo Ɔhile Utsyǝ ǝmǝ!” ");
INSERT INTO lip_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Nko ke bamamanyǝ bamfó tsya dímǝ wǝ nɛ. Bésu wǝ ɔflɔ nya béfi ntǝ bo nkpe kalo bǝtǝ wǝ bǝ unǝ. ");
INSERT INTO lip_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Nya bátɛyi bǝnkǝ, “Lǝ fǝ ni Yudafɔ eto Okaa, nyalɛ kpɔ lǝ ǝlǝkǝ fǝ ǝsuǝ!” ");
INSERT INTO lip_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Báwɔni etiki nyamfo lǝ wǝ disikato nya nlɛ bɔtɛyi nkǝ, “Nwǝ mfo ni Yudafɔ eto Oka ǝmǝ nɛ.” ");
INSERT INTO lip_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Babuayifo ba básɔ bámanklasǝ lǝ eyi ǝsuǝ eto ɔni lǝ mǝ nti áka Yesu nkǝ, “Inni fǝ ni Nwǝ Onanto Lékpo Ɔhile Utsyǝ? Kpɔ lǝ ǝlǝkǝ fǝ ǝsuǝ, lǝ ǝlǝkǝ bo tsya!” ");
INSERT INTO lip_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Fɛɛ unuǝfǝ áni ko wǝ ɔ́tɛyi nkǝ, “Aante Onanto sikpi lee? Kotonǝnǝ kɔni eto okle befi bǝtǝ fǝ ku wǝ kenke. ");
INSERT INTO lip_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nya bo kotonǝnǝ, kɔyɛ lǝ kusu ǝsuǝ. Itsyise lesa nǝ dińyǝ itǝ boo, ni ni nǝ béfi bǝtǝ bo nɛ. Fɛɛ wǝ ményifo kabua saa.” ");
INSERT INTO lip_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Nya ɔ́tɛyi Yesu nkǝ, “Yesu, kloma mɛ lǝ esu edufǝ fǝ sekakedikɔ!” ");
INSERT INTO lip_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Mfó Yesu lɛtɛyi wǝ nkǝ, “Nlɛ fǝ bɔtɛyi sitinti miǝ mmi ǝmfo kee, ebudufǝ Paradiso kafo ku mɛ.” ");
INSERT INTO lip_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Nya se éyo kakɔmi eto lefosi ǝnuǝǝ, kofe áyɛ bofa nya kale ku kawunsiǝ kenke lena tũũ itsyi lǝ kakɔmi isu ese lǝ abombo ǝtsyǝ. Nya Onanto eto kedikǝtǝkɔ eto kafia ka mfaka mfo léla, késie lǝ akpa ǝnuǝ. ");
INSERT INTO lip_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesu áfa ku ɔkɔɛ bembembe nkǝ, “Nto, mfi mɔ lɛwɔnɔ ńkpe fǝ lǝ ani!” Se ɔ́tɛyi nyamfó nkoo, óma kɛnyɛ. ");
INSERT INTO lip_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Se omamanyǝ ninǝ ǝmǝ dínyǝ lesa nǝ díbǝǝ, ɔ́tɛsǝ Onanto ɔ́tɛyi nkǝ, “Sitintii, utidi ǝmfo eyifo utidi sɛɛ.” ");
INSERT INTO lip_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Se betidi ba díbǝ bǝ baabe lesa nǝ díbǝ nya bǝnyǝ lesa nǝ díbǝǝ, bésinkli bésu ayo nya béfi ani bétsyi lǝ esi ku kaminsǝ. ");
INSERT INTO lip_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Nya betidi ba kenke léte Yesu ku besio ba dítǝkǝko wǝ ditsyi Galilea bǝbǝǝ, ǝńyǝ kɔsɛsɛ balɛ asa nyamfo bobe. ");
INSERT INTO lip_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Osani utsyuǝ ákɛ mfó baakpo Yosef wǝ dítsyi Arimatea lǝ Yudea eto kasɔ. Uyifo utidi sɛɛ wǝ betidi lǝǝtǝ dibu tinti. Nya uńyǝ ɔnlɛ kusu bobe itǝ Onanto eto sekadidi sia nlɛ bubǝ. Ite bǝ ɔ́kɛ lǝ Yudafɔ eto bakponkpo nti tsyaa, wántɔnɔ ko mǝ lǝ lesa nǝ báse uyi ku lesa nǝ béyifo ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Úsu Pilato ɔflɔ úsu ɔ́tɔ wǝ nkǝ lǝ ofo Yesu eto ɔkɔ. ");
INSERT INTO lip_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Úlǝkǝ ɔkɔ ǝmǝ nya úfi kafia flubia kǝtsyuǝ úmini wǝ kenke. Nya úfi wǝ úsu úbikǝ lǝ leba kafo eto kudi kutsyuǝ ko bembikǝtɔ kuutsyuǝ bǝnyǝ. ");
INSERT INTO lip_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Diyi nǝmfó eyifo Fida wǝ bǝǝmuǝ ǝsuǝ fɛ Ɔnwɛditsyǝyi lǝǝsiǝ kale. ");
INSERT INTO lip_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Besio ba dítǝkǝko Yesu se betsyi Galilea, ǝtǝkǝko Yosef bésu kudi komǝ eti nya bésu bábe kase bébikǝ Yesu ǝmǝ. ");
INSERT INTO lip_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Nya bésinkli bésu oto nya bǝkuǝ asa nnya laanyi fififi ku nnuǝbi bo beefi kediki bakɔ lǝ ǝsuǝ bǝtsyǝ. Nya bǝtsyǝ ɔnwɛ lǝ Ɔnwɛditsyǝyi fe kase mǝ afi nyamǝ léte. ");
INSERT INTO lip_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Lǝ Kɔsida eto olensiǝntoo, besio bamǝ ésu kudi komǝ ɔflɔ bétsyi afa nnya bálɔ bǝtsyǝ bésuko kudi komǝ ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Mfóo, bǝnyǝ bǝ kudi komǝ eto kɛnyɛ ásini kute nya leba kplɛ nǝ béfi béti mfó ámina dite kutsyǝ. ");
INSERT INTO lip_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Nyaso bédufǝ bésu kudi komǝ kafo, fɛɛ bǝnnyǝ Bonamute Yesu eto ɔkɔ ǝmǝ. ");
INSERT INTO lip_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Nyamfo ǝtǝ difufu ǝmuǝ mǝ. Nya ete basani inuǝ bǝtsyuǝ dílǝkǝ ǝsuǝ báte mǝ. Nya bikǝ bia banlɛ nlɛ buyǝnde kaba mǝ ǝnǝmi. ");
INSERT INTO lip_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Sikpi ǝmuǝ mǝ tinti nyaso báse esi kasɔ bǝtǝ basani bamǝ. Nya basani bamǝ lɛtɔ mǝ bǝnkǝ, “Beso bɛnlɛ utidi wǝ nkpe nkpǝ bɔbɛbɛ lǝ bǝkpǝnkpǝ nti? ");
INSERT INTO lip_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Umbǝ mfo. Ótaka! Bekloma lesa nǝ ɔ́tɛyi mi lefe nǝ ɔkɛ lǝ Galilea nkǝ, ");
INSERT INTO lip_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","ele bǝ befi Utidi Eto Ubi bakpe lǝ betidi bua eto ani. Bɔɔsɔ wǝ bamanklasǝ lǝ uyikabie ǝsuǝ. Nya lǝ eyi ǝtsyǝ eto kamaa, wuusinkli otaka utsyi ɔkɔmǝ ubǝ.” ");
INSERT INTO lip_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Besio bamǝ ákloma wǝ etiki nyamǝ. ");
INSERT INTO lip_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Nya se bésinkli bétsyi kebikǝkɔ mfó bǝbǝǝ, bésu bátɛyi bakasebi lefosi ɔnwɛ bamǝ ku babamba kenke tsya asa nyamfo. ");
INSERT INTO lip_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Besio bamǝ ni Maria Magdalene ku Yohana ku Maria wǝ ni Yakobo eto ambe. Mǝ ku besio bamba ni mba lɛtɛyi batɔnkpe bamfo asa nyamfo. ");
INSERT INTO lip_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Fɛɛ batɔnkpe bamǝ efi asa nnya besio bamǝ díbǝ bátɛyi mǝ fe ebukitiki. Nyaso bámfo mǝ bánɔ. ");
INSERT INTO lip_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Fɛɛ Petro alɛɛ, ótaka nya útsyetsyi úsu kudi komǝ ɔflɔ. Nya se úsu óbe kudi komǝ kafoo, únyǝ mfia bo bébikǝ ɔkɔ ǝmǝ. Fɛɛ wénsinyǝ kulesa mfó. Nyaso usinkli úsu se íyifo wǝ yanii lǝ kase asa nyamǝ díbǝ eso. ");
INSERT INTO lip_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Nya lǝ diyi nǝmfo ke ǝsuǝǝ, Yesu eto mba ntǝkǝko wǝ eto inuǝ bǝtsyuǝ yɛ lǝ kusu bátɔ lǝ umǝ kɛkɛ utsyuǝ wǝ baakpo Emaus. Nya yuutsyǝ fe esunkpo kɛntsyɛ akuanse idu mfo isu Yerusalem. ");
INSERT INTO lip_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Nya banyɛ mfó banlɛ etiki budi itsyi lǝ lesa nǝ díbǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Se bányɛ bánlɛ etiki budi kedufǝ lǝ etiki nyamǝ ǝsuǝǝ, Yesu kosate ésu útu mǝ nya wǝ ku mǝ lɛyɛ bantɔ. ");
INSERT INTO lip_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Bǝnyǝ wǝ, fɛɛ bǝntsyǝ wǝ lekpo. ");
INSERT INTO lip_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yesu átɔ mǝ nkǝ, “Be ǝsuǝ bɛnyɛ lǝ kusu bɛnlɛ etiki budi ketsyiko?” Bǝkǝnǝ bǝńyǝ. Nya mǝ ǝnǝmi nlɛ bote fe baminsǝtidi. ");
INSERT INTO lip_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Nya mǝ ɔni wǝ baakpo Kleopa lɛtɔ Yesu nkǝ, “Nyalɛ fǝ mate hã ete ni ɔfɔ lǝ Yerusalem wǝ lenyi asa nnya nlɛ bubǝ lǝ eyi nnya kliminti mfo eto nti lee?” ");
INSERT INTO lip_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ɔ́tɔ mǝ nkǝ, “Be eto asa?” Bǝtǝ mbuayɛ bǝnkǝ, “Asa nnya díbǝ lǝ Yesu Nasaretnyǝ ǝsuǝ. Utidi emfo ni Onanto eto Unyɛlǝkǝtidi wǝ Onanto ku betidi ba tã dínyǝ bǝ okpe ǝsuǝale tinti lǝ wǝ asayifoyifo ku asa nnya ɔ́tɛyi kenke ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Nya bo besumunyǝ ninǝ ku bo baka dífi wǝ bákpe lǝ Romamfɔ eto uninǝ lǝ ani bǝ olo wǝ dikpǝnkpi nya básɔ wǝ bamanklasǝ lǝ uyikabie ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Fɛɛ búfi ǝnǝmi butǝkǝ lǝ wǝ ǝsuǝ boǝ wǝ loofo Israel eto betidi kenke lǝ nkpǝ. Nya mmi ni diyi tsyǝfǝ sɔ̃ɔ̃ se asa nyamfo díbǝ nɛ. ");
INSERT INTO lip_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Bo nti eto besio bǝtsyuǝ ǝtǝ bo ketu étinkǝ. Itsyise bésu wǝ kudi komǝ ɔflɔ ku olesiǝtu ǝmfo. ");
INSERT INTO lip_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Fɛɛ bǝnnyǝ wǝ ɔkɔ ǝmǝ. Nya bésinkli bǝbǝ bátɛyi bo bǝnkǝ Onanto eto batɔnkpe bǝtsyuǝ ǝbǝ bǝlǝkǝ ǝsuǝ báte mǝ. Nya bátɛyi mǝ bǝnkǝ Yesu kpe nkpǝ. ");
INSERT INTO lip_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Bo nti eto bǝtsyuǝ ésu kudi komǝ ɔflɔ mfó nya bǝnyǝ fe kase besio bamǝ lɛtɛyi pɛpɛɛpɛ, fɛɛ bǝnnyǝ wǝ kosate.” ");
INSERT INTO lip_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Nya Yesu lɛtɛyi mǝ nkǝ, “Bieninǝ! Nya tsyaa, mi bofokanɔ lǝ asa nnya Onanto eto bǝnyɛlǝkǝtidi lɛtɛyi mi ǝsuǝ ǝmbǝ ale! ");
INSERT INTO lip_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Binyi biǝnkǝ ele bǝ, Nwǝ Onanto Lékpo Ɔhile Utsyǝ ǝmǝ nyǝ kanyi kamfo eto okle fɛ lǝ udufǝ wǝ sekakedikɔ eto diyǝnde ǝsuǝ?” ");
INSERT INTO lip_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Nya Yesu dílǝkǝ asa nyamfo kasɔ óte mǝ lǝ asa nnya báwɔni bakpe lǝ Awɔnisa Kɛnkɛ eto Kukue ǝsuǝ itsyi lǝ Moses eto Ǝkue ku asa nnya kenke Onanto eto bǝnyɛlǝkǝtidi lɛwɔni bǝtsyǝ itsyi lǝ wǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Se íbu sɛkɛ lǝ bedufǝ umǝ kɛkɛ wǝ bántɔɔ, Yesu éyifo fe bofe ɔnlɛ kedu. ");
INSERT INTO lip_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Fɛɛ báninko wǝ bátɛyi bǝnkǝ, “Kale ébolo kalo nyaso kɛ lǝ bo ɔflɔ mfo.” Nyaso úsu ɔ́sɔnɔ lǝ mǝ ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Úsiǝ lǝ kasɔ nkǝ lǝ udi lesa ku mǝ. Nya úfi abolo nyamǝ nya ɔ́sɔ Onanto ani, nya úbudi nnya úfi útǝ mǝ. ");
INSERT INTO lip_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Mfó nya mǝ ǝnǝmi lɛsini nya bǝnyǝ wǝ bǝtsyǝ lekpo. Fɛɛ ónya fĩĩ lǝ mǝ ǝnǝmi. ");
INSERT INTO lip_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Bátɛyi mǝ bǝtsyuǝ bǝnkǝ, “Lefe nǝ ɔ́kɛ mfó úkedinko bo etiki nya úkǝlǝkǝ Awɔnisa Kɛnkɛ eto Kukue eto etiki kasɔ kate bo lǝ kusuu, disuǝyuǝ ditsyuǝ eto okle akɛ bo lǝ lɛkɔɛsi!” ");
INSERT INTO lip_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Bátaka lamfolamfo nya bésinkli bésu Yerusalem. Nya bésu bǝnyǝ lefosi ɔnwɛ bamǝ ku betidi bamba bákɔ bensi. ");
INSERT INTO lip_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Nya bánlɛ bɔtɛyi bǝ, “Bonamute átaka útsyi ɔkɔmǝ sitinti, nya úlǝkǝ ǝsuǝ óte Simon.” ");
INSERT INTO lip_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Mfó nya betidi inuǝ bamǝ lɛtɛyi mǝ asa nnya díbǝ lǝ kusu ku kase bǝnyǝ Yesu bǝtsyǝ lekpo lefe nǝ úbudi abolo nyamǝ útǝ mǝ. ");
INSERT INTO lip_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Se betidi inuǝ bamfo nlɛ mǝ etiki budii, mfó ǝmǝ Yesu kosate ǝbǝ úńyǝ lǝ mǝ nti. Nya ɔ́tɛyi nkǝ, “Diyuǝ lǝ disiǝko mi.” ");
INSERT INTO lip_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Báyakla nya bébu bǝnkǝ ɔkɔ banlɛ bunyǝ. ");
INSERT INTO lip_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Fɛɛ ɔ́tɛyi mǝ nkǝ, “Beso bietinkǝ mǝ! Beso biamfo kanɔ? ");
INSERT INTO lip_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Bebe mɔ ani ku mɔ akpa. Nya bitidi mɛ lǝ bete biǝ mɔ uni. Itsyise ɔkɔ ǝmbǝ ǝsuǝ eto sinǝ ku ekubi fe kase bɛnlɛ mɛ bunyǝ minte mmǝ.” ");
INSERT INTO lip_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Se ɔ́tɛyi nkoo, úfi wǝ ani ku akpa óte mǝ. ");
INSERT INTO lip_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Lǝ kase banlɛ disuǝyuǝ bunyǝ tinti nya asa nyamǝ díyifo mǝ yani esoo, bámfo bofo kanɔ. Mfó nya Yesu lɛtɔ mǝ nkǝ, “Didisa ditsyuǝ te mi mfo?” ");
INSERT INTO lip_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Béfi lɛkpɛ sǝnsǝ báboko wǝ. ");
INSERT INTO lip_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Nya ófo ni ɔ́yimi lǝ mǝ ǝnǝmi mfó. ");
INSERT INTO lip_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Nya ɔ́tɛyi mǝ nkǝ, “Asa nyamfo ǝsuǝ tututu míntɛyi mi lefe nǝ minkɛ mi lǝ ɔflɔ nɛ. Lesa saa nǝ báwɔni lǝ Moses eto afi eto kukue nye Onanto eto bǝnyɛlǝkǝtidi eto asa nnya báwɔni lǝ Ǝsǝnkue itsyi lǝ mɛ ǝsuǝǝ, ele bǝ ibǝ itǝ nko.” ");
INSERT INTO lip_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Mfó nya ɔ́sini mǝ nsusu itǝ lǝ banɔ Awɔnisa Kɛnkɛ eto Kukue eto etiki nnya nkpe mfó kasɔ. ");
INSERT INTO lip_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Nya ɔ́tɛyi mǝ nkǝ, “Báwɔni bǝtsyǝ bǝ Nwǝ Onanto Lékpo Ɔhile Utsyǝ mfo ebunyǝ kanyi nya wootaka utsyi bekpǝnkpǝ nti ubǝ lǝ diyi tsyǝfǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Nya wǝ bakasebi ebobe letsya lǝ wǝ diye ǝsuǝ bǝtǝ kawunsiǝ eto betidi kenke bǝ batsyi mǝ akɔɛsi bawuninsǝ itǝ lǝ Onanto lǝ ufi mǝ abua ɔtsyɛ mǝ. Nya letsyabebe nǝmfo ebutsyǝ kasɔ lǝ Yerusalem. ");
INSERT INTO lip_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Mi luudi adansiɛ bilǝkǝ ditiki nǝmfo bete lǝ kalebe saa. ");
INSERT INTO lip_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Nya mɔ kosate ebufi lesa nǝ mɔ Anto lɛtɛyi útsyǝ ntsyese mi. Fɛɛ ele bǝ bińyǝ bisǝkǝ Onanto eto ǝsuǝale nyamfo lǝ Yerusalem isu ese lefe nǝ biofo nyamǝ itsyi kato.” ");
INSERT INTO lip_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Lǝ nyamfo eto kamaa, Yesu ákpa mǝ nya bédu lǝ Yerusalem eto umǝ bésu Betania eti. Mfó óbesǝ ani kato nya ókpo mǝ atsyɔ. ");
INSERT INTO lip_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Nya lefe nǝ tututu ɔnlɛ mǝ atsyɔ bokpo mfóo, údu lǝ mǝ ɔflɔ nya Onanto étsyi wǝ úsuko kato. ");
INSERT INTO lip_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Báse akonki bésumu wǝ nya bésinkli bésu Yerusalem ku disuǝyuǝ tinti. ");
INSERT INTO lip_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Békesu Onanto eto kedikǝtǝkɔ mlǝ mlǝ mlǝ késu késumu Onanto kasɔ wǝ ani. ");
INSERT INTO lip_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ditiki nǝmǝ akɛ fɛ béyifo kawunsiǝ. Ditiki nǝmǝ ku Onanto lɛkɛ. Nya Ni ku Onanto ni ɔni. ");
INSERT INTO lip_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ditiki nǝmǝ ku Onanto lɛkɛ taa kasɔ ketsyikokɔ. ");
INSERT INTO lip_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ɛyɛ lǝ wǝǝ, nya Onanto díyifo lesa saa nɛ. Bényifo kulesa nǝ wǝ dímankɛ lenti. ");
INSERT INTO lip_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ditiki nǝmǝ ǝǝtǝ nkpǝ, nya nkpǝ bomǝ ɔflɔ betidi dínyǝ diyǝnde betsyiko. ");
INSERT INTO lip_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Diyǝnde nǝmǝ ǝǝyǝnde kakpo lǝ ketuntu ǝsuǝ. Fɛɛ ketuntu kamǝ mamfotɔ diyǝnde nǝmǝ bɔninsǝ. ");
INSERT INTO lip_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Onanto átsyese utidi utsyuǝ. Wǝ diye ni Yohanes. ");
INSERT INTO lip_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Úbǝ nkǝ woedi betidi etiki itsyiko lǝ diyǝnde nǝmǝ ǝsuǝ bǝ lǝ utsyuǝ saa wǝ lɛnɔ ditiki nǝmǝ lǝ ofo ɔnɔ. ");
INSERT INTO lip_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Inni Yohanes kosate ni diyǝnde nǝmǝ. Bomu úbǝ nkǝ lǝ udi etiki itsyi lǝ diyǝnde nǝmǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Nyamfo ni lekpasǝ kosate nǝmǝ nɛ, lekpasǝ nǝ nlɛ kawunsiǝ bubǝ nǝ luuyǝnde ditǝ utsyuǝ saa lekpasǝ. ");
INSERT INTO lip_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ditiki nǝmǝ ákɛ lǝ kawunsiǝ, nya wǝ ǝsuǝ Onanto lɛyɛ úyifo kawunsiǝ, fɛɛ kawunsiǝ eto betidi mǝnnyǝ wǝ bǝtsyǝ lekpo. ");
INSERT INTO lip_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Úbǝ wǝ kosate eto betidi ɔflɔ, fɛɛ wǝ betidi mámfo wǝ. ");
INSERT INTO lip_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Fɛɛ bǝtsyuǝ ete léfo wǝ. Nya mba kenke léfo wǝ bánɔɔ, útǝ mǝ ǝsuǝale nnya dítǝ báfiani Onanto eto bebi. ");
INSERT INTO lip_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Bámfiani Onanto eto bebi ɛyɛ lǝ kawunsiǝ eto ditsyǝbi ǝsuǝ nye ɛyɛ lǝ usǝ ku usiǝ eto ubilele eto ketsyue ǝsuǝ. Bomu Onanto kosate lɛtɔnɔ nkǝ woafo mǝ lǝ bafiani wǝ bebi. ");
INSERT INTO lip_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ditiki nǝmǝ ǝbǝ léfiani utidinini wǝ dísiǝ lǝ bo nti, nya úyi ku Onanto eto lefonǝ ku sitinti kenke. Nya búnyǝ wǝ diyǝnde kplɛ nǝ eto okle ófo útsyiko wǝ anto ɔflɔ fe Onanto eto Ubi ɔni kplo eso. ");
INSERT INTO lip_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yohanes ǝlǝkǝ wǝ óte betidi lǝ lefe nǝ óbe letsya. Ófa ɔ́tɛyi nkǝ, “Nwǝmfo ni utidi wǝ ǝsuǝ míndi etiki mintsyiko minkǝ, ‘Nwǝ ntǝkǝ mɛ kama ɔnlɛ bubǝǝ, amɔ oso mɛ, itsyise okpe koko fɛ bále mɛ.’ ” ");
INSERT INTO lip_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ɛyɛ lǝ wǝ lefonǝ kplɛ ǝsuǝǝ, ókpo bomblɛ kenke atsyɔ kpǝ. ");
INSERT INTO lip_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Itsyise Onanto ǝtǝ bo kɔfi komǝ ɛyɛ lǝ Moses ǝsuǝ. Fɛɛ wǝ lefonǝ ku sitinti siamǝ ǝbǝ bo ɔflɔ ɛyɛ lǝ Yesu Kristo ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Kuutsyuǝ saa mǝnnyǝ tɔ Onanto unyǝ. Wǝ ubi ɔni kplo wǝ lekate ko Onanto wǝ nsi lǝ wǝ Anto ǝmǝ eto akɔɔ, wǝ ni díbǝ úlǝkǝ futsyǝ Onanto ni óte bo nɛ. ");
INSERT INTO lip_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yudafɔ eto beninǝ ba nkpe lǝ Yerusalem ákpe besumunyǝ ku Lewifɔ bésu Yohanes ɔflɔ. Bátɔ wǝ bǝnkǝ, “Owoe ko feni?” ");
INSERT INTO lip_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Mfóo, Yohanes mánni mbuayɛ butǝ bomu ókpasǝ mǝ nkǝ, “Inni mɔ ni Nwǝ Onanto Lékpo Ɔhile Utsyǝ.” ");
INSERT INTO lip_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Bátɔ wǝ bǝnkǝ, “Nyalɛ owoe feni? Fǝ ni Unyɛlǝkǝtidi Elia?” Útǝ mǝ mbuayɛ nkǝ, “Inni mɔ ni.” Bésukosǝ bátɔ wǝ bǝnkǝ, “Nyalɛ, fǝ ni Unyɛlǝkǝtidi wǝ bátɛyi bǝtsyǝ bǝ wuubǝ?” Útǝ mǝ mbuayɛ nkǝ, “Owo lo.” ");
INSERT INTO lip_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Nyaso bátɔ wǝ bǝnkǝ, “Tɛyi bo lesatsyuǝ nǝ busu bɔtɛyi mba lékpe bo kɔtɔ! Owoe feni? Nya be fanlɛ bɔtɛyi itsyi lǝ fǝ ǝsuǝ?” ");
INSERT INTO lip_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yohanes ǝtǝ mǝ mbuayɛ fe kase Unyɛlǝkǝtidi Yesaya lɛwɔni utsyǝ nkǝ, “Mɔ ni utidi wǝ nlɛ bofa lǝ mfiminti kafe eto ɔkɔɛ katɛyi nkǝ, ‘Bɛtsyɔnsǝ Bonamute eto kusu bitsyǝ itǝ wǝ bubǝ!’ ” ");
INSERT INTO lip_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Nya betidikpekpe ba dítsyi Yudafɔ ba baakpo Farisifɔ ɔflɔ bǝbǝǝ, ");
INSERT INTO lip_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","lɛtɔ Yohanes bǝ, “Lenni fǝ ni Nwǝ Onanto Lékpo Ɔhile Utsyǝ, nye Elia, nye unyɛlǝkǝtidi ǝmǝǝ, ntsyǝ ibǝ fɛ fanlɛ ntuflǝsǝflǝsǝ eto lekpa buyifo?” ");
INSERT INTO lip_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yohanes ǝtǝ mǝ mbuayɛ nkǝ, “Mɔ alɛɛ, meefi ntu keyifo ntuflǝsǝflǝsǝ eto lekpa nǝmfo. Fɛɛ utidi utsyuǝ ńyǝ mi lenti, wǝ binnyi. ");
INSERT INTO lip_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Utǝkǝ mɛ kama ɔlɛ bubǝ nya wǝ afokpa eto kekue mǝnńyǝ ntǝ kulaa tsya bǝ nyankli.” ");
INSERT INTO lip_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Asa nyamfo ǝbǝ lǝ Betania eto umǝ lǝ Yordan eto ketu eto ditukpenkpe nǝ nse. Mfó Yohanes nlɛ ntuflǝsǝflǝsǝ eto lekpa buyifo kǝtǝ betidi nɛ. ");
INSERT INTO lip_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Kǝsiǝsǝǝ, Yohanes ǝnyǝ Yesu nlɛ wǝ ɔflɔ bubǝ nya ɔ́tɛyi mba ńyǝ wǝ lǝ ɔflɔ nkǝ, “Nyǝ Onanto eto Lesamubi nǝ ntsyi kawunsiǝ eto abua ɔntɔnko. ");
INSERT INTO lip_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Wǝ ni utidi wǝ ǝsuǝ míntɛyi mintsyiko lefe nǝ míndi etiki míntɛyi minkǝ, ‘Utidi utsyuǝ tǝkǝ mɛ kama ɔnlɛ bubǝ wǝ lɛmɔ onso mɛ, itsyise okpe kokooko fɛ bále mɛ.’ ");
INSERT INTO lip_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Mɔ kosate tsya mánte utidi ǝmǝ. Fɛɛ wǝ bubǝ eso mímbǝ minlɛ ntuflǝsǝflǝsǝ eto lekpa nǝmfo buyifo bǝ lǝ nlǝkǝ wǝ nte Israel eto kusǝ eto betidi.” ");
INSERT INTO lip_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Mfó nya Yohanes disi ɔ́tɛyi lǝ wǝ ǝsuǝ nkǝ, “Nnyǝ miǝ Onanto eto Lɛwɔnɔ áyifǝ dítsyi kato dísiǝ lǝ wǝ ǝsuǝ fe lɛblɛkpa seka. ");
INSERT INTO lip_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Tutɛ mánte miǝ wǝ uni. Fɛɛ lefe nǝ Onanto létsyese mɛ nkǝ mbǝ keyifo ntuflǝsǝflǝsǝ eto lekpa nǝmǝǝ, ɔ́tɛyi mɛ nkǝ, ‘Ebunyǝ se mɔ Lɛwɔnɔ lɔɔyifǝ ditsyi kato dibǝ disiǝ lǝ utsyuǝ ǝmǝ ǝsuǝ, ete ebote fǝ wǝ ni utidi wǝ luufi Lɛwɔnɔ Kɛnkɛ ukeyifo ntuflǝsǝflǝsǝ eto lekpa nǝmǝ nɛ.’ ");
INSERT INTO lip_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nya mínyǝ se íbǝ nkomǝ lǝ utidi ǝmfo ǝsuǝ. Nya minlɛ mi bɔtɛyi sitinti miǝ wǝ ni Onanto eto Ubi kosate ǝmǝ nɛ.” ");
INSERT INTO lip_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Kǝsiǝsǝǝ, Yohanes ku wǝ bakasebi inuǝ si bǝńyǝ mfó ke, ");
INSERT INTO lip_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","nya únyǝ Yesu díbǝ ɔnlɛ bofe. Nya se únyǝ wǝǝ, ɔ́tɛyi nkǝ, “Bebee, nyǝ Onanto eto Lesamubi nǝmǝǝ!” ");
INSERT INTO lip_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Bakasebi inuǝ bamfo ánɔ nnya Yohanes lɛtɛyi nya bédu bésu bǝtǝkǝko wǝ. ");
INSERT INTO lip_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Se Yesu lɛtsyi ɔwuninsǝ únyǝ nkǝ bǝtǝkǝko wǝǝ, ɔ́tɔ mǝ nkǝ, “Be biabɛbɛ?” Bǝtǝ wǝ mbuayɛ bǝnkǝ, “Rabi,” eto kasɔ ni Oteasa, “Lekpakpa, se fankpe?” ");
INSERT INTO lip_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ɔ́tɛyi mǝ nkǝ, “Bibǝ bebe.” Lefe nǝmfó ebutsyǝ fe ditsyitsyo eto abombo ana seka. Nyaso bǝtǝkǝko wǝ bésu kaka onkpe, nya bǝsiǝ wǝ lǝ ɔflɔ diyi fɛfɛ nǝmǝ. ");
INSERT INTO lip_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Bakasebi inuǝ ba lɛnɔ Yohanes eto ditiki nǝmǝ fɛ bǝtǝtǝko Yesuu, eto ɔni ni Andrea wǝ ni Simon Petro eto ɔyimi. ");
INSERT INTO lip_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Lesa tutɛ nǝ Andrea ǝmǝ díyifo ni bǝ úsu ɔ́bɛbɛ wǝ ɔyimi, ini Simon nya ɔ́tɛyi wǝ nkǝ, “Búnyǝ Mesia ǝmǝ,” eto kasɔ ni Kristo wǝ ni Nwǝ Onanto Lékpo Ɔhile Utsyǝ. ");
INSERT INTO lip_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Nya ókpa Simon úsuko Yesu ɔflɔ. Yesu ábe wǝ tũũ, nya ɔ́tɛyi wǝ nkǝ, “Fǝ ni Simon, Yohanes eto ubi. Idu mɔmɔ ɛntɔɔ, bookpo fǝ bǝ Kefas,” nye Petro eto kasɔ ni kobansǝ. ");
INSERT INTO lip_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Kǝsiǝsiǝǝ, Yesu ála nkǝ weesu kasɔ ka baakpo bǝ Galilea. Nya se ɔnyɛ ɔntɔɔ, únyǝ utsyuǝ wǝ baakpo Filipo nya ɔ́tɛyi wǝ nkǝ, “Bǝtǝkǝko mɛ.” ");
INSERT INTO lip_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipo etsyi Betsaida, umǝ wǝ Andrea ku Petro tsya ditsyi. ");
INSERT INTO lip_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Se Filipo dísu únyǝ Nataniel, ɔ́tɛyi wǝ nkǝ, “Búunyǝ utidi ǝmǝ ǝsuǝ Moses ku Onanto eto bǝnyɛlǝkǝtidi lɛwɔni asa betsyiko bǝtsyǝ lǝ Awɔnisa Kɛnkɛ eto Kukue ǝsuǝ! Wǝ ni Yosef eto ubi Yesu wǝ ditsyi Nasaret!” ");
INSERT INTO lip_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nataniel átɔ nkǝ, “Lesa sɛɛ ditsyuǝ ebofo bɔbɔ ketsyi Nasaret kǝbǝǝ?” Filipo átɛyi wǝ nkǝ, “Bǝ lǝ ǝbǝ abe!” ");
INSERT INTO lip_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Se Yesu dínyǝ Nataniel lɛyɛ ɔnlɛ wǝ ɔflɔ bubǝǝ, ɔ́tɛyi itsyi lǝ wǝ ǝsuǝ nkǝ, “Nyǝ Israelnyǝ tinti nlɛ bubǝ mǝǝ, woanwɛ betidi.” ");
INSERT INTO lip_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataniel átɔ wǝ nkǝ, “Ntsyǝ féyifo fáte utidi wǝ eto okle mini?” Yesu ǝtǝ mbuayɛ nkǝ, “Fɛ Filipo díbǝ ókpadi fǝ lǝ lefe nǝ fakɛ lǝ koto komǝ kalɔɔ, mbúnyǝ fǝ koko.” ");
INSERT INTO lip_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nataniel átɛyi wǝ nkǝ, “Oteasa, eyifo Onanto eto Ubi kosate. Fǝ ni Israelfɔ eto Oka ǝmǝ!” ");
INSERT INTO lip_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Mfó nya Yesu lɛtɔ wǝ nkǝ, “Eni nnya míntɛyi fǝ miǝ nnyǝ fǝ lǝ koto komǝ kalɔ eso fáfo fánɔɔ? Ebunyǝ asa nnya nsi nso nyamfo.” ");
INSERT INTO lip_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Nya ɔ́tɛyi mǝ nkǝ, “Sitinti minlɛ mi bɔtɛyi minkǝ, biunyǝ se kato lɔɔsini nya Onanto eto batɔnkpe nlɛ kato bobe kesu kayifǝ kǝbǝ mɔ, Utidi eto Ubi, ɔflɔ.” ");
INSERT INTO lip_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Lǝ diyi tsyǝfǝ ǝsuǝǝ, bákpa kusiǝ kutsyuǝ lǝ umǝ wǝ baakpo Kana lǝ Galilea eto kasɔ. Yesu eto ambe Maria ákɛ mfó. ");
INSERT INTO lip_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Nya bákpadi Yesu ku wǝ bakasebi tsya báboko kusiǝ kakpakɔ kamǝ. ");
INSERT INTO lip_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Se nte bo banlɛ bunǝ léloo, Yesu eto ambe ǝbǝ Yesu ɔflɔ nya ɔ́tɛyi wǝ nkǝ, “Nte bo banlɛ bunǝ álo.” ");
INSERT INTO lip_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Mfó Yesu lɛtɛyi wǝ nkǝ, “Mbe, yanle bǝ tɛyi mɛ lesa nǝ ele bǝ nyifo. Mɔ lefe mányo tɔ.” ");
INSERT INTO lip_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Nya Yesu eto ambe lɛtɛyi besumubi bamǝ nkǝ, “Biyifo lesa nǝ kee wɔɔtɛyi mi nkǝ biyifo.” ");
INSERT INTO lip_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Se ini lekpa ídi itǝ Yudafɔ bǝ bǝflǝ mǝ ǝsuǝ esoo, bǝtsyǝ ntu eto kalɔtsyi kplɛ ekua ka bǝlǝkǝ lǝ abansǝ ǝsuǝ mfó. Nya ketulɔtsyi ɛnɔ nye ekua leeyi ɔlɔtsyi kplɛ ɔni. ");
INSERT INTO lip_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Mfó nya Yesu lɛtɛyi besumubi bamǝ nkǝ békuti ntu béyisǝ kalɔtsyi kplɛ kamǝ. Nyaso békuti ntu béyisǝ kalɔtsyi kplɛ kamǝ klɛlɛlɛlɛ. ");
INSERT INTO lip_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Mfó nya ɔ́tɛyi mǝ nkǝ, “Bikuti ntu bomǝ eto ntsyuǝ bisuko utidi wǝ nsi lǝ ketsyue kamǝ eto kɛnyɛ.” Nya békuti mu bésuko wǝ. ");
INSERT INTO lip_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Se útu ntu bo léfiani nte óbee, wǝ ánte kaka nte bomǝ dítsyi. Fɛɛ besumubi ba díkuti ntu bomǝ bésuko alɛɛ, mǝmǝ áte. Nyaso nwǝ nsi lǝ ketsyue kamǝ eto kɛnyɛ ákpadi okafɔse ǝmǝ, ");
INSERT INTO lip_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","nya ɔ́tɛyi wǝ nkǝ, “Utsyuǝ saa, nte sɛɛ woaka betidi butǝ bǝǝnǝ, nya lǝ betidi ǝnǝ bǝkpǝ eto kamaa, nya fɛ weefi mbo dimanlɛkɛ kǝtǝ betidi lǝǝnǝ nɛ. Fɛɛ fǝ ébu nsɛɛ ǝtsyǝ kama!” ");
INSERT INTO lip_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Nnya díbǝ lǝ Kana lǝ Galilea eto kasɔ mfóo, ni ayanisa tutɛ nnya úyifo. Úyifo nyamfo úlǝkǝ wǝ diyǝnde óte, nya wǝ bakasebi léfo wǝ bánɔ. ");
INSERT INTO lip_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Nyamfo eto kamaa, Yesu ku wǝ ambe, ku wǝ bayimi, ku wǝ bakasebi édu bésu Kapernaum nya bǝsiǝ mfó eyi asiani. ");
INSERT INTO lip_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ukpǝ Ása Bo Ɔ́yila eto didife eboyo elo, nyaso Yesu ésu Yerusalem. ");
INSERT INTO lip_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Se údufǝ Onanto eto Disumuyoo, únyǝ se betidi nlɛ banantsyui ku basamu ku ablonuma bote ku mba laafloma atabi tsya nsi lǝ mǝ kapunu eto akɔ. ");
INSERT INTO lip_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Nyaso ófio ukuǝ nya úfi wǝ óla basamu ku banantsyui kenke ɔ́bɔsǝ lǝ Disumuyo mfó. Úsensǝ mba nlɛ atabi boba eto atabi úwui nya úkǝ mǝ kapunu ókpo lǝ kasɔ. ");
INSERT INTO lip_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ɔ́tɛyi mba nlɛ ablonuma bote nkǝ, “Bitsyi asa nyamfo bɛbɔnko lǝ mfo, nya biemfi mɔ Anto eto diyo biyifo bikǝkatekɔ.” ");
INSERT INTO lip_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Nya wǝ bakasebi lékloma nnya Awɔnisa Kɛnkɛ eto Kukue lɛtɛyi nkǝ, “Onanto, mɔ lelabi itǝ fǝ Disumuyoo, ǝtǝ ǝnǝmi asɛ mɛ lǝ ni ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Yudafɔ eto beninǝ ǝbǝ Yesu ɔflɔ nya bátɔ wǝ bǝnkǝ, “Se féyifo asa nyamfo mǝǝ, nte ayanisa nnya fuuyifo ate bo bǝ akpe kusu feeyifo nnya okle?” ");
INSERT INTO lip_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesu ǝtǝ mǝ mbuayɛ nkǝ, “Beba Onanto eto Disumuyo kamfo, nya mootakasǝ ke ńyǝnsǝ lǝ diyi tsyǝfǝ ǝsuǝ!” ");
INSERT INTO lip_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Yudafɔ bamǝ átɔ wǝ bǝnkǝ, “Disumuyo ka befi alɛfosi ana alɛ akua bátoo, bɔtɛyi fanlɛ fǝ ebusinkli atakasǝ ke ǝńyǝnsǝ lǝ eyi ǝtsyǝ ǝsuǝ?” ");
INSERT INTO lip_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Fɛɛ bánte bǝ wǝ sinǝ ǝsuǝ ɔnlɛ etiki budi ketsyiko fe Onanto eto Disumuyo. ");
INSERT INTO lip_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Nyaso lefe nǝ Onanto létakasǝ wǝ utsyiko ɔkɔmǝǝ, nya fɛ wǝ bakasebi lékloma bǝ ɔ́tɛyi nko utsyǝ. Nyaso báfo asa nnya báwɔni bakpe lǝ Awɔnisa Kɛnkɛ eto Kukue ku nnya Yesu lɛtɛyi bánɔ. ");
INSERT INTO lip_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Lefe nǝ Yesu lɛkɛ lǝ Yerusalem lǝ Ukpe Ása Bo Ɔ́yila eto diyididi lefee, betidi kpǝ áfo wǝ bánɔ lǝ ayanisa kpǝ nnya bǝnyǝ úyifo eso. ");
INSERT INTO lip_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Fɛɛ Yesu mémfi wǝ ǝsuǝ utǝ mǝ, itsyise uyi betidi kenke. ");
INSERT INTO lip_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Yensife bǝ kuutsyuǝ saa si ɔtɛyi wǝ kulesa itsyi lǝ betidi ǝsuǝ itsyise wǝ kosate áte lesa nǝ lɛkɛ lǝ mǝ ketu kǝmiǝ. ");
INSERT INTO lip_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Lefe nǝmfóo, Yudafɔ eto uninǝ ɔni wǝ baakpo bǝ Nikodemo akɛ lǝ mǝ ditsyukpa nǝ baakpo Farisifɔ nti. ");
INSERT INTO lip_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Kǝtsyǝ kanii, úbǝ Yesu ɔflɔ nya ɔ́tɛyi wǝ nkǝ, “Oteasa, buyi boǝ fǝ ni nwǝ ditsyi Onanto ɔflɔ fǝbǝ, itsyise kutsyuǝ saa embofo ayanisa nnya feeyifo buyifo lenni Onanto nsi ko wǝ.” ");
INSERT INTO lip_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Mfó nya Yesu lɛtɛyi wǝ nkǝ, “Sitinti minlɛ fǝ bɔtɛyi minkǝ, lǝ bensinkli utidi balee, wǝmbunyǝ Onanto eto Sekadidi siamǝ.” ");
INSERT INTO lip_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemo átɔ wǝ nkǝ, “Ntsyǝ boofo utidi wǝ díkabe businkli kale bio? Businkli ele bǝ usinkli udufǝ lǝ wǝ ambe eto kafo fɛ lǝ besinkli bale wǝ dinuǝfǝ lee?” ");
INSERT INTO lip_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Mfó nya Yesu lɛtɛyi wǝ nkǝ, “Nlɛ fǝ bɔtɛyi sitinti minkǝ, lǝ bánle utidi betsyiko lǝ ntu ku Onanto eto Lɛwɔnɔ nǝmǝ ǝsuǝǝ, weembofo budufǝ lǝ Onanto eto Sekadidi siamǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Utidininii, bále wǝ ɛyɛ lǝ etidisuǝ ǝsuǝ. Fɛɛ nnya ditsyi lǝ Onanto eto Lɛwɔnɔ ǝsuǝǝ, bále wǝ lǝ Lɛwɔnɔ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Nyaso mǝntǝ lǝ iyifo fǝ naa lǝ ntɛyi fǝ miǝ ele bǝ bale fǝ bio. ");
INSERT INTO lip_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ufiebi aasɔ kesu kakake ola, nya wǝ kɔsɔ hã faanɔ, fɛɛ inni lǝ kaka utsyi ku kaka ɔntɔ. Nko inte itǝ utsyuǝ saa wǝ bále ɛyɛ lǝ Lɛwɔnɔ ǝsuǝ nɛ.” ");
INSERT INTO lip_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Mfó nya Nikodemo lɛtɔ wǝ nkǝ, “Ntsyǝ nyamfo loofo bubǝ kǝtǝ?” ");
INSERT INTO lip_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesu ǝtǝ wǝ mbuayɛ nkǝ, “Oteasa kplɛ feni lǝ Israel, ntsyǝ ibǝ fámannɔ nyamfo kasɔ? ");
INSERT INTO lip_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nlɛ fǝ bɔtɛyi sitinti miǝ asa nnya bunyii, nnya ǝsuǝ boedi etiki ketsyiko nɛ. Nya lesa nǝ ke búkenyǝǝ, ni ǝsuǝ boedi adansiǝ nɛ. Fɛɛ biamfo bo etiki nyamǝ kanɔ. ");
INSERT INTO lip_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Lǝ ndi fǝ etiki itsyi lǝ kasɔ mfo eto asa ǝsuǝ nya fámamfo mɛ ánɔɔ, ntsyǝ foofo mɛ bofo kanɔ lǝ ndi fǝ etiki itsyi lǝ kato eto asa ǝsuǝ? ");
INSERT INTO lip_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Nya kuutsyuǝ saa ménsu tɔ kato unyǝ enso mɔ, Utidi Eto Ubi wǝ ditsyi kato úbǝ kawunsiǝ mfo. ");
INSERT INTO lip_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Fe kase Moses lébesǝ owa wǝ béfi situ béyifo kato lǝ uyi ǝsuǝ lǝ mfimintii, nko ke ele bǝ babesǝ mɔ, Utidi Eto Ubi kato nɛ, ");
INSERT INTO lip_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","bǝ utidi wǝ ke léfo mɛ ɔ́nɔɔ, lǝ unyǝ nkpǝ manlo. ");
INSERT INTO lip_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Itsyise Onanto ála kawunsiǝ kamfo kon bǝnkǝ úfi wǝ Ubi ɔni kplo útǝ nkǝ utsyuǝ saa ke laafo wǝ kanɔɔ, lǝ ɔyɛ bukpǝ kanya, bomu lǝ unyǝ nkpǝ manlo. ");
INSERT INTO lip_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Itsyise Onanto mántsyese wǝ Ubi kawunsiǝ nkǝ lǝ ubǝ olo ke dikpi, bomu bǝ lǝ uyifo ke Ofomfokǝtǝ. ");
INSERT INTO lip_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Utidi wǝ ke laafo wǝ Ubi kanɔɔ, bembolo wǝ dikpi. Fɛɛ utsyuǝ saa wǝ laamfo wǝ kanɔɔ, bóolo wǝ dikpi koko itsyise wóamfo Onanto eto Ubi ɔni kplo ǝmǝ ɔnɔ eso. ");
INSERT INTO lip_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Kase baayɛ kaalo dikpi nǝmǝ ni bǝnkǝ, diyǝnde nǝmǝ ǝbǝ kawunsiǝ, fɛɛ betidi aala ketuntu kaso diyǝnde nǝmǝ, itsyise baala asa buayifoyifo kaso. ");
INSERT INTO lip_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Utsyuǝ saa wǝ leeyifo asa buaa, weekisi diyǝnde, nya woannyi kafi ni. Itsyise woate sikpi nkǝ lǝ ɔnyi ɔfi diyǝndee, yuulǝkǝ wǝ asa bua nnya weeyifo ote bǝnyǝ. ");
INSERT INTO lip_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Fɛɛ utsyuǝ saa wǝ nsi nkpǝ lǝ kusu sɛɛ ǝsuǝǝ, aanyi kafi diyǝnde, itsyise woala nkǝ diyǝnde nǝmǝ lǝkǝ lete nkǝ kase unsi nkpǝ yɛ lǝ Onanto eto lelabi ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Lǝ nyamfo eto kamaa, Yesu ku wǝ bakasebi édu bésu Yudea eto lekpake mfó. Bǝsiǝ mfó itǝ lefe ditsyuǝ, nya úkeyifo betidi ntuflǝsǝflǝsǝ eto lekpa. ");
INSERT INTO lip_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Lefe nǝmǝǝ, Yohanes tsya ákɛ lǝ Ainon lǝ Salim ɔflɔ kǝflǝsǝ betidi ntu, itsyise ntu abɔ lǝ mfó nya betidi ékesu wǝ ɔflɔ nya úkǝflǝsǝ mǝ ntu. ");
INSERT INTO lip_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Lefe nǝmfóo, bǝmmuǝ tɔ Yohanes beti bakpe lǝ aba eto diyo. ");
INSERT INTO lip_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Diyi lɔnii, etikinǝnǝ ǝtsyuǝ édufǝ lǝ Yohanes eto bakasebi ku Yudanyǝ utsyuǝ eto nti itsyi lǝ ǝsuǝflǝflǝ eto lekpa ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Nyaso bǝbǝ Yohanes ɔflɔ bátɛyi wǝ bǝ, “Oteasa, akloma utidi utsyuǝ wǝ fǝ ku wǝ díńyǝ lǝ Ketu Yordan eto ditukpenkpe nǝ nse, ini wǝ ǝsuǝ fédi adansiɛ fetsyiko? Wǝ ni nwǝ mfe nlɛ betidi ntuflǝsǝflǝsǝ eto lekpa buyifo nɛ, nya betidi ba kenke nlɛ budu kesu wǝ ɔflɔ.” ");
INSERT INTO lip_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yohanes átɛyi mǝ nkǝ, “Kuutsyuǝ saa embofo kulesa bɔkɛ, lenni Onanto dífi ni útǝ wǝ. ");
INSERT INTO lip_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Mi kosate ni mɔ badansiɛ bǝ ntɛyi mi nkpasǝ wuee miǝ inni mɔ ni Nwǝ Onanto Lékpo Ɔhile Utsyǝ ǝmǝ. Fɛɛ Onanto létsyese mɛ nkǝ ntɔ wǝ sɛtɔ. ");
INSERT INTO lip_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Nwǝ ni Okafɔsee, wǝ ni nwǝ mbǝ Okafɔ ǝmǝ nɛ. Fɛɛ nwǝ ni Okafɔse ǝmǝ eto okloboo, lǝ unyǝ ɔlɛ Okafɔse ǝmǝ eto ɔkɔɛ bɔɔnɔ, yeakpe wǝ disuǝyuǝ tinti. Nko ǝmǝ eso mintsya nlɛ disuǝyuǝ bunyǝ tinti fe okafɔse ǝmǝ eto oklobo nɛ. ");
INSERT INTO lip_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Nya nko ele bǝ wǝ diye be kato lǝ mɔ lele lǝ dibǝ kasɔ nɛ. ");
INSERT INTO lip_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Nwǝ ditsyi kato ubǝǝ, so utsyuǝ saa. Nya nwǝ ditsyi kasɔ mfo tsyaa, kasɔ mfo eto utidi ete uni. Nya kasɔ mfo eto asa eto etiki ete weedi. Fɛɛ nwǝ ditsyi kato úbǝǝ, tǝkǝ mǝmblɛ kato. ");
INSERT INTO lip_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Waatɛyi lesa nǝ úkǝnyǝ ku nnya úkanɔ mfó. Fɛɛ kuutsyuǝ saa aamfo wǝ sedansiɛdidi siamǝ. ");
INSERT INTO lip_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Fɛɛ nwǝ ke léfo wǝ kɛnyɛ kamǝ ɔ́nɔɔ, lɛ uyi bose kǝtǝ nkǝ Onanto eyifo utintinyǝ. ");
INSERT INTO lip_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Nwǝ Onanto létsyesee, eedi Onanto eto etiki, itsyise Onanto éfi wǝ Lɛwɔnɔ úyisǝ wǝ ǝsuǝ kenke. ");
INSERT INTO lip_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Anto ǝmǝ aala wǝ Ubi ǝmǝ nya úfi lesa saa ókpe wǝ lǝ ani nɛ. ");
INSERT INTO lip_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","“Nwǝ léfo Ubi ǝmǝ ɔ́nɔɔ, kpe nkpǝ manlo. Nya nwǝ laani weentsyue Ubi ǝmǝ kotoo, weembunyǝ nkpǝ manlo bomǝ. Bomu Onanto eto kotonǝnǝ manlo ebutǝkǝ wǝ lǝ ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Farisifɔ ánɔ bǝ Yesu lɛ ntuflǝsǝflǝsǝ eto lekpa nǝmǝ buyifo kǝtǝ betidi, nyaso betidi kpǝ tǝkǝko wǝ baso Yohanes. ");
INSERT INTO lip_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Lǝ sitintii, Yesu kosate ményifo ntuflǝsǝflǝsǝ eto lekpa útǝ kuutsyuǝ saa, bomu wǝ bakasebi hã díkeyifo nko. ");
INSERT INTO lip_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Se Yesu léte nkǝ Farisifɔ ánɔ ditiki nǝmfo nkoo, údu lǝ Yudea eto kasɔ úsu Galilea eto kasɔ. ");
INSERT INTO lip_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Nya lǝ kusu ko ɔnyɛ ɔntɔɔ, ele bǝ ɔyɛ Samaria eto kasɔ ofe. ");
INSERT INTO lip_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Yesu ésu óyo Samaria eto umǝ wǝ baakpo Sikar, wǝ lɛfi kasɔ ka mǝ ona Yakob dítǝ wǝ ubi Yosef. ");
INSERT INTO lip_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Lɛtidibo ditsyuǝ nǝ Yakob díku akɛ mfó. Nya se ílǝ Yesu fɛ úsu óyo mfó lǝ nkɔminti lefe itsyi lǝ kusu komǝ eto bɔyɛ esoo, úkǝnǝ úsiǝ lǝ lɛtidibo nǝmǝ ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Nya ete Samariasio utsyuǝ díbǝ ntu kekutikɔ. Nya Yesu lɛtɛyi wǝ nkǝ, “Tǝ mɛ ntu lǝ nnǝ.” ");
INSERT INTO lip_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Lǝ lefe nǝ mfó ǝsuǝǝ, Yesu eto bakasebi ébudu bésu umǝ didisa kayakɔ. ");
INSERT INTO lip_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Usio ǝmǝ átɛyi nkǝ, “Beso fǝ Yudanyǝ laatɔ mɔ Samariasio fǝ ntǝ fǝ ntu lǝ ǝnǝ?” Usio ǝmǝ átɔ nko itsyise Yudafɔ ku Samariafɔ anka. ");
INSERT INTO lip_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesu ǝtǝ wǝ mbuayɛ nkǝ, “Lǝ nnya ete fenyi lesa nǝ Onanto lǝǝtǝ ku nwǝ nlɛ fǝ bɔtɔ nkǝ tǝ wǝ ntu lǝ unǝǝ, eni fǝ bomu ebɔtɔ wǝ fǝ utǝ fǝ ntu bo lǝǝtǝ nkpǝ.” ");
INSERT INTO lip_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Usio ǝmǝ átɔ wǝ nkǝ, “Boanto, ǝmbǝ lesa nǝ beefi kekuti ntu, nya lɛtidibo nǝmǝ tsya atsyo. Sie fuunyǝ ntu bo lǝǝtǝ nkpǝ bomǝ etsyiko? ");
INSERT INTO lip_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Lee fǝ nso bo Ona Yakob wǝ díku lɛtidibo nǝmfo útǝ bo, kaka wǝ ku wǝ bebi ku wǝ bebuki kenke dínǝ ntu betsyiko?” ");
INSERT INTO lip_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Mfó nya Yesu dítǝ wǝ mbuayɛ nkǝ, “Lǝ betidi ǝnǝ ntu bomfoo, utukuɛ si wɔɔlɛ mǝ. ");
INSERT INTO lip_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Fɛɛ ntu bo mɔ luutǝǝ, utukuɛ ensi ǝmbɔlɛ nwǝ luunǝ mu. Ntu bo mɔ luutǝ wǝ ebofiani nkpǝ eto ntu eto kayifǝkɔ lǝ wǝ. Ntu bomfo ebukabɔdi lǝ wǝ nya buutǝ wǝ nkpǝ manlo.” ");
INSERT INTO lip_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Usio ǝmfo átɛyi wǝ nkǝ, “Boanto, tǝ mɛ ntu bomfo bǝ lǝ utukuɛ lǝ ɔyɛ mɛ bɔlɛ bio, nya lǝ nyɛ mfo bubǝ kekuti ntu.” ");
INSERT INTO lip_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesu átɛyi wǝ nkǝ, “Su akpadi fǝ usǝ lǝ bibǝ.” ");
INSERT INTO lip_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Usio ǝmǝ átɛyi wǝ nkǝ, “Minsi kusǝ.” Yesu átɛyi wǝ nkǝ, “Átɛyi sitinti fǝ ensi kusǝ. ");
INSERT INTO lip_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ébusiǝko basani ɛnɔ áfe. Nya nwǝ fǝ ku wǝ nkpe mɔmɔ kulaa tsya enni fǝ usǝ. Sitinti fátɛyi.” ");
INSERT INTO lip_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Usio emǝ átɛyi Yesu nkǝ, “Bonamute, nnyǝ miǝ eyifo Onanto eto unyɛlǝkǝtidi. ");
INSERT INTO lip_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Bo Samariafɔɔ, bo banamǝ ésumu Onanto lǝ kɔtini komfo ǝsuǝ. Fɛɛ mi Yudafɔ aatɛyi biǝnkǝ Yerusalem ni kaka ele bǝ busumu Onanto.” ");
INSERT INTO lip_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesu átɛyi wǝ nkǝ, “Usionko, fo mɛ anɔ fǝ lefe ditsyuǝ lǝ bubǝ nǝ betidi lensiembusumu Onanto lǝ kɔtini komfo ǝsuǝ nye lǝ Yerusalem. ");
INSERT INTO lip_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Mi Samariafɔɔ, binyi lesa nǝ biesumu. Fɛɛ bo Yudafɔɔ, buyi futsyǝ boesumu. Itsyise Yudafɔ ǝsuǝ nnya bofokǝtǝ laayɛ kǝbǝ. ");
INSERT INTO lip_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Fɛɛ lefe lɛ bubǝ nya díkǝbǝ tsya koko, se betidi luusumu Anto ǝmǝ ɛyɛ lǝ kusu sɛɛ ku lǝ lɛwɔnɔ eto ǝsuǝale ku lǝ sitinti ǝsuǝ. Itsyise mǝ ni besumunyǝ ba eto okle Onanto laala nkǝ besumu wǝ nɛ. ");
INSERT INTO lip_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Se Onanto ni Lɛwɔnɔ esoo, betidi ba luusumu wǝǝ, ele bǝ bayɛ lǝ lɛwɔnɔ nǝmǝ eto ǝsuǝale ku lǝ sitinti ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Usio ǝmǝ átɛyi wǝ nkǝ, “Nyi miǝ Nwǝ Onanto Lékpo Ɔhile Utsyǝ, wǝ baakpo Kristoo, ebubǝ. Nya lǝ ubǝǝ, wuulǝkǝ lesa saa kasɔ ote bo.” ");
INSERT INTO lip_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesu átɛyi wǝ nkǝ, “Mɔ nwǝ nlɛ etiki budi ku fǝ mfoo, mɔ ni wǝ nɛ.” ");
INSERT INTO lip_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Lefe nǝmfóo, wǝ bakasebi bamǝ ǝbǝ bédufǝ nya íyifo mǝ naa se bǝnyǝ wǝ ɔnlɛ etiki budi ku usio. Fɛɛ mǝ kuutsyuǝ saa mántɔ usio ǝmǝ bǝ be woabɛbɛ nye bátɔ wǝ bǝ beso ɔnlɛ etiki budi ku usio ǝmǝ. ");
INSERT INTO lip_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Usio ǝmǝ áyani wǝ ɔlɔtsyi ǝmǝ útsyǝ lǝ lɛtidibo nǝmǝ ɔflɔ nya údu úsu umǝ úsu ɔ́tɛyi betidi nkǝ, ");
INSERT INTO lip_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Bibǝ bebe osani utsyuǝ wǝ lɛtɛyi mɛ lesa saa nǝ mínkeyifo mínyǝ lǝ mɔ nkpǝ! Lee wǝ ni Onanto eto nwǝ Bákpo Ɔhile Bǝtsyǝ ǝmǝ?” ");
INSERT INTO lip_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Nyaso betidi bamǝ ábɔ bétsyi umǝ ǝmǝ bésu bǝ beesu bǝnyǝ wǝ. ");
INSERT INTO lip_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Lefe nǝmfóo, bakasebi bamǝ álɛ Yesu lekpakpa bátɛyi bǝnkǝ, “Oteasa, bedi lesa!” ");
INSERT INTO lip_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Fɛɛ ɔ́tɛyi mǝ nkǝ, “Nkpe lesa nǝ muudi nǝ ǝsuǝ binyi kulesa saa bitsyiko.” ");
INSERT INTO lip_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Nyaso bakasebi bamǝ étsyiko mǝ ǝsuǝ bɔtɔ bǝnkǝ, “Lee utsyuǝ áboko wǝ lesa údi?” ");
INSERT INTO lip_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesu átɛyi mǝ nkǝ, “Mɔ didisa ni bǝ nyifo nwǝ lékpe mɛ eto lelabi, nya lǝ nlosǝ keyifo ka útǝ mɛ nkǝ nyifo. ");
INSERT INTO lip_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Biatɛyi biǝnkǝ, ‘Afa ana sɔ̃ɔ̃ kama fɛ lesa loobe oto.’ Fɛɛ nlɛ mi bɔtɛyi minkǝ bɛlɛ ola bebe kakuɛ eto ditsyǝbi lǝ bebe kase bidikǝ biamǝ díkabe! Bíoyo nnya bulǝkǝ. ");
INSERT INTO lip_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Onanto aafo kayo nwǝ lǝǝlǝkǝ bidikǝ lǝ ɔkuɛ nya waakpa mi kakpo lǝ unwu itǝ nkpǝ manlo. Lǝ nyamfo eso nwǝ laato ku nwǝ lǝǝlǝkǝǝ, mǝmblɛ ebunyǝ disuǝyuǝ tinti. ");
INSERT INTO lip_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Nyaso nnya baatɛyi bǝ utidi ɔni laato nya obamba lǝǝlǝkǝ, eyifo sitinti. ");
INSERT INTO lip_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Mɔ létsyese mi miǝ bisu bilǝkǝ bidikǝ lǝ ɔkuɛ wǝ inni mi léto bikǝ biamǝ. Betidi bamba díyifo keyifo kekleke lǝ kasɔ ketsyikokɔ lǝ mfó, nya mi dínyǝ kutǝkǝ lǝ keyifo ka mǝ díyifo ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Samariafɔ kpǝ lǝ umǝ ǝmǝ áfo Yesu bánɔ ɛyɛ lǝ nnya usio ǝmǝ lɛtɛyi nkǝ, “Ɔ́tɛyi mɛ lesa saa nǝ mínkeyifo lǝ mɔ nkpǝ ǝsuǝ mínyǝ,” eso. ");
INSERT INTO lip_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Nyaso se Samariafɔ bamǝ díbǝ bǝnyǝ Yesu lǝ lɛtidibo nǝmǝ ɔflɔɔ, bálɛ wǝ lekpakpa bǝ usiǝ lǝ mǝ ɔflɔ nya Yesu dísiǝ mfó eyi ǝnuǝ. ");
INSERT INTO lip_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Betidi bamba kpǝ esi báfo wǝ bánɔ lǝ wǝ ditiki nǝ údi mǝ eso. ");
INSERT INTO lip_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Nya bátɛyi usio ǝmǝ bǝnkǝ, “Bófo bɔ́nɔ mɔmɔ inni lǝ nnya fátɛyi bo eso, bomu bo kosate ánɔ etiki nnya údi eso, nya buyi boǝ wǝ ni kawunsiǝ kamfo eto Ofomfokǝtǝ tinti ǝmǝ.” ");
INSERT INTO lip_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Lǝ eyi ǝnuǝ eto kamaa, Yesu édu mfó úsu Galilea eto kasɔ. ");
INSERT INTO lip_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Itsyise wǝ kosate ǝlǝkǝ ɔ́tɛyi nkǝ, “Dibu ankɛ kǝtǝ Onanto Eto Unyɛlǝkǝtidi lǝ wǝ kosate eto kasɔ.” ");
INSERT INTO lip_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Fɛɛ se Yesu dísu údufǝ Galilea, betidi bamǝ áfo wǝ atuu ku disuǝyuǝ, itsyise se bésu Ukpǝ Ása Bo Ɔ́yila eto Diyisɛɛ kedikɔ lǝ Yerusalem, bǝnyǝ asa nnya kenke úyifo. ");
INSERT INTO lip_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Lǝ nnya kamaa, Yesu ésinkli úsu Kana lǝ Galilea eto kasɔ, kaka úkatsyi ntu ɔ́wuninsǝ bófiani nte. Lefe nǝmfóo, Aba eto unyɛsiǝ ninǝ utsyuǝ wǝ dítsyi Kapernaum eto ubi ánɔ bufi. ");
INSERT INTO lip_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Se ɔ́nɔ nkǝ Yesu etsyi Yudea úbǝ Galilea, úsu wǝ ɔflɔ nya ɔ́lɛ wǝ lekpakpa nkǝ úsu Kapernaum lǝ usu otsya wǝ ubisaibi utǝ wǝ, itsyise wǝ ubi ǝmǝ fe woala lǝ ukpǝ. ");
INSERT INTO lip_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesu átɛyi wǝ nkǝ, “Lǝ biǝnnyǝ nyifo ayanisa ntee, biamfo mɛ kanɔ.” ");
INSERT INTO lip_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Uninǝ ǝmfo álɛ wǝ lekpakpa ɔ́tɛyi nkǝ, “Bonamute, bǝ lǝ ǝbǝ abe mɔ ubi ǝmǝ bǝ lǝ ɔyɛ bukpǝ.” ");
INSERT INTO lip_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Mfó nya Yesu lɛtɛyi wǝ nkǝ, “Su! Fǝ ubi ǝmǝ ebɔkɛ nkpǝ.” Uninǝ ǝmǝ áfo etiki nnya Yesu lɛtɛyi wǝ ɔ́nɔ nya úsinkli údu. ");
INSERT INTO lip_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Se úsinkli ɔntɔɔ, wǝ diyo eto beyifoyifo betsyuǝ átsyako wǝ lǝ kusu nya bátɛyi wǝ bǝnkǝ wǝ ubi ǝmǝ kpe nkpǝ. ");
INSERT INTO lip_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ɔ́tɔ mǝ lefe nǝ tutuutu íyuǝ wǝ ubi ǝmǝ. Nya bǝtǝ mbuayɛ bǝnkǝ, “Kǝnǝ ku kakɔmi lefe, fe lebombo lɛwɛ eti nnya bɔyila bomǝ léyani wǝ nɛ.” ");
INSERT INTO lip_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ubi anto ǝmǝ ákloma nkǝ lefe nǝmfo ǝsuǝ tutuutu Yesu lɛtɛyi wǝ nkǝ, “Fǝ ubi ǝmǝ ebɔkɛ nkpǝ.” Nya uninǝ ǝmfo ku wǝ diyo eto betidi kenke léfo Yesu bánɔ. ");
INSERT INTO lip_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Nyamfo díyifo ayanisa nuǝfǝ nnya Yesu díyifo lǝ Galilea se utsyi Yudea eto kasɔ úsu mfó nɛ. ");
INSERT INTO lip_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Lǝ nyamfo eto kamaa, Yesu ésu Yerusalem se Yudafɔ eto diyisɛɛ ditsyuǝ didife léyo. ");
INSERT INTO lip_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Lǝ umǝ ǝmǝ eto kaka baakpo Basamu eto Kesie ɔflɔɔ, ditumbu ditsyuǝ kpe mfó nǝ baakpo bǝ Betesda lǝ Hebrifɔ eto sele ǝsuǝ. Bákpo mpatampa ɛnɔ beńyǝnsǝ lǝ ditumbu nǝmǝ ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Mfó befimfi kpǝ ateate ba ni bǝnǝmba, mba lɛtsyini, ku mba leba bankpoo kasɔ díbǝ kakpo. Nya bǝńyǝ bensekǝ ntu bomǝ eto butinkǝsǝ butsyuǝ. ");
INSERT INTO lip_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","(Itsyise afe ǝtsyuǝǝ, Onanto eto ɔtɔnkpe utsyuǝ kǝbǝ kémunisǝ ntu bomǝ. Nya ufimfi tutɛ wǝ ke dídufǝ lǝ ntu bomǝ ǝsuǝǝ, ǝnyǝ bufitsyantsya.) ");
INSERT INTO lip_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Osani utsyuǝ kálabǝ mfó wǝ díkǝfi alɛ fosi ǝtsyǝ alɛ mflamfla sɔ̃ɔ̃. ");
INSERT INTO lip_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Se Yesu dínyǝ wǝ nya unyi nkǝ onlabe lǝ ufinkla ǝsuǝ mfó itǝ alɛ kpǝǝ, ɔ́tɔ wǝ nkǝ, “Ala bǝ, fǝ bufi yɛ fǝ?” ");
INSERT INTO lip_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ufimfi ǝmǝ ǝtǝ mbuayɛ nkǝ, “Uninǝ, mimbǝ kuutsyuǝ wǝ lɔɔwunsǝko mɛ ndufǝ ntu bomǝ kafo lǝ bémunisǝ mu. Lǝ nkplatsya miǝ meedufǝ tsyaa, utidi bamba éboka mɛ budufǝ koko.” ");
INSERT INTO lip_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesu átɛyi wǝ nkǝ, “Taka ǝńyǝ, fi fǝ okla lǝ ayɛ edu!” ");
INSERT INTO lip_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Lamfolamfo, osani ǝmǝ eto ǝsuǝ ǝmuǝ wǝ ale! Úfi wǝ okla nya ɔ́yɛ údu. Diyi nǝ nyamfo díbǝǝ, eyifo Yudafɔ eto Ɔnwɛditsyǝyi. ");
INSERT INTO lip_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Nyaso Yudafɔ eto beninǝ átɛyi osani wǝ Yesu létsya bufi bǝnkǝ, “Mmi eyifo Ɔnwɛditsyǝyi. Kɔfi mǝntǝ kusu bǝ lǝ etsyi fǝ okla.” ");
INSERT INTO lip_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ɔ́tɛyi nkǝ, “Nwǝ létsya mɛ bufi ke lɛtɛyi mɛ nkǝ, ‘Taka ǝńyǝ, fi fǝ okla lǝ ayɛ edu!’ ” ");
INSERT INTO lip_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Bátɔ wǝ bǝnkǝ, “Owoe ni utsyǝ lɛtɛyi fǝ nkǝ, ‘Tsyi fǝ okla lǝ ayɛ’?” ");
INSERT INTO lip_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Fɛɛ nwǝ bátsya bufi bomǝ mánte nkǝ utsyǝ ǝmǝ ni Yesu. Nya Yesu tsya ébonya údufǝ lǝ betidi kpǝ ba díńyǝ mfó eto nti. ");
INSERT INTO lip_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Nyamfo eto kamaa, Yesu ǝnyǝ wǝ lǝ Onanto eto kedikǝtǝkɔ nya ɔ́tɛyi wǝ nkǝ, “Bebe! Ǝsuǝ búmuǝ fǝ ale. Nyaso mensiyifo lebua bio! Lenni nkoo, lesa nǝ nkpe ale enso mmǝ ebuyifo fǝ!” ");
INSERT INTO lip_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Nya osani ǝmǝ dídu nya úsu ɔ́tɛyi Yudafɔ eto beninǝ bamǝ nkǝ Yesu ni utidi wǝ létsya wǝ bufi. ");
INSERT INTO lip_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Nyaso bétsyiko Yesu bulǝ, itsyise ótsya utidi bufi lǝ Ɔnwɛditsyǝyi ǝsuǝ ");
INSERT INTO lip_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yesu átɛyi mǝ nkǝ, “Mɔ Anto si ɔlɛ keyifo buyifo lefe saa, nyaso ele bǝ mintsya yifo nko.” ");
INSERT INTO lip_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Lǝ nnya ɔ́tɛyi mfo esoo, Yudafɔ eto beninǝ esi bábɛbɛ esu kekleke bǝ baalo wǝ. Itsyise inni Ɔnwɛditsyǝyi ǝsuǝ eto kɔfi ete óta úbu, bomu usi ɔ́tɛyi nkǝ Onanto eyifo wǝ Anto. Nya nyamfo eto kasɔ ni bǝ wǝ ku Onanto akate. ");
INSERT INTO lip_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Mfó nya Yesu lɛtɛyi mǝ nkǝ, “Nlɛ mi bɔtɛyi sitinti minkǝ, Onanto eto Ubi embofo kulesa buyifo lǝ wǝ kosate eto ǝsuǝale ǝsuǝ. Bomu lesa nǝ wǝǝnyǝ wǝ Anto leeyifoo, ni wintsya leeyifo nɛ. ");
INSERT INTO lip_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Itsyise Anto ǝmǝ aala wǝ Ubi ǝmǝ nya woate wǝ lesa saa nǝ wǝ kosate nlɛ buyifo. Nya woote wǝ asa kplɛ kpǝ enso nyamfo nnya luuyifo mimblɛ yanii. ");
INSERT INTO lip_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Fe kase Anto ǝmǝ laatakasǝ bǝkpenkpe ketsyiko ɔkɔmǝ kaboko nkpǝǝ, nko ke Ubi ǝmǝ tsya luutǝ nkpǝ mba úlǝkǝ nɛ. ");
INSERT INTO lip_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Nya Anto ǝmǝ kosate tsya ankponko kuutsyuǝ lekpo, bomu útǝ wǝ Ubi kusu nkǝ okponko betidi kenke lekpo, ");
INSERT INTO lip_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","bǝ lǝ utsyuǝ saa lǝ ufi dibu utǝ Ubi ǝmǝ fe kase bǝǝtǝ Anto ǝmǝ dibu. Futsyǝ kee dímembu Ubi ǝmǝǝ, mémbu Anto ǝmǝ létsyesǝ wǝ tsya. ");
INSERT INTO lip_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Nlɛ mi bɔtɛyi sitinti minkǝ, utsyuǝ saa wǝ laanɔ mɔ ditiki nya ófo nwǝ létsyese mɛ ɔ́nɔɔ, wuunyǝ nkpǝ manlo. Bembokponko wǝ lekpo, fɛɛ ɔ́yɛ lǝ ukpǝ ǝsuǝ ófe údufǝ lǝ nkpǝ ǝsuǝ koko. ");
INSERT INTO lip_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nlɛ mi bɔtɛyi sitinti miǝ, lefe lɛ bubǝ nǝ bekpǝnkpǝ luutsyue Onanto eto Ubi koto, nya mba leetsyue we ɔkɔɛ koto ebunyǝ nkpǝ tinti. Lefe nǝmǝ kulaatsya ébubǝ koko. ");
INSERT INTO lip_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Fe kase Anto ǝmǝ ni nkpǝ eto ketsyikokɔ, nko ke útǝ nkǝ wǝ Ubi tsya yifo nkpǝ eto ketsyikokɔ nɛ. ");
INSERT INTO lip_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Nya útǝ wǝ ǝsuǝale nkǝ okponko kawunsiǝ kenke lekpo, itsyise wǝ ni Utidi Eto Ubi ǝmǝ. ");
INSERT INTO lip_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Biǝntǝ lǝ nyamfo lǝ iyifo mi yanii, itsyise lefe lɛ bubǝ nǝ bekpǝnkpǝ ba nkpe lǝ edi lɔɔnɔ Utidi Eto Ubi ǝmǝ eto ɔkɔɛ. ");
INSERT INTO lip_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Nya bɔɔbɔ lǝ edi bǝbǝ. Mba dísiǝ nkpǝ sɛɛ ebotaka bǝnyǝ nkpǝ manlo. Nya mba dísiǝ nkpǝ bua, tsya ebotaka bafo dikpilolo. ");
INSERT INTO lip_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Mǝmbofo kulesa buyifo lǝ mɔ ǝsuǝale ǝsuǝ. Lesa nǝ Onanto laatɛyi mɛɛ, nnya meefi kakpo lekpo nɛ. Nyaso mɔ lekpokponkpo yɛ lǝ kusu ǝsuǝ, itsyise meenyifo kulesa lǝ mɔ lelabi ǝsuǝ, bomu lǝ nwǝ létsyese mǝ eto lelabi ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Yesu esi ɔ́tɛyi nkǝ, “Lǝ nlǝkǝ kɛnyɛ lǝ mɔ kosate ǝsuǝǝ, yanle bǝ bafo lesa nǝ míntɛyi ǝmbǝ kalende. ");
INSERT INTO lip_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Fɛɛ utidi bamba kpe wǝ leedi adansiɛ lǝ mɛ ǝsuǝ, nya nyi miǝ adansiɛ nnya ɔnlɛ budi lǝ mɛɛ, kpe kalende. ");
INSERT INTO lip_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Bíokpe batɔnkpe Yohanes ɔflɔ nya úkatɛyi mi sitinti siamǝ itsyi lǝ mɛ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Fɛɛ mɔɔ, minlɛ bɔtɛyi miǝ utidinini eto sedansiɛdidi lǝ mɛ ǝsuǝ afe itǝ mɛ. Bomu ńtɛyi nyamfo bǝ lǝ binyǝ bofokǝtǝ. ");
INSERT INTO lip_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohanes ǝtsyǝ fe okandiɛ wǝ nlɛ bunyǝ nya ɔnlɛ lekpasǝ butǝ, nya béla biǝ biǝnyǝ disuǝyuǝ lǝ wǝ lekpasǝ nǝmǝ ǝsuǝ itǝ lefe sɛkɛ ete. ");
INSERT INTO lip_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Fɛ mɔɔ, sedansiɛ sia lɛflɔ senso Yohanes eto selee, se nkpe mɛ nɛ. Itsyise keyifo ka mɔ Anto dítǝ mɛ nkǝ nyifo nlose, ka minlɛ buyifoo, ke nlɛ adansiɛ budi lǝ mɛɛ nɛ. Ke nlɛ bote bǝ mɔ Anto ǝmǝ létsyese mɛ. ");
INSERT INTO lip_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Nya Anto wǝ létsyese mɛ tsyaa, wǝ kosate leedi adansiǝ lǝ mɛ ǝsuǝ. Bíannɔ tɔ wǝ ɔkɔɛ bɛnɔ, nya bíǝnyǝ tɔ kase unte bínyǝ. ");
INSERT INTO lip_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Fɛɛ biamfo wǝ ditiki nǝmǝ kakpe lǝ mi akɔɛsi itsyise biamfo utidi wǝ ótsyese bɛnɔ. ");
INSERT INTO lip_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Biakase Awɔnisa Kɛnkɛ eto Kukue eto asa itsyise bibu biǝ biunyǝ nkpǝ manlo lǝ nnya ǝsuǝ. Nya ko etiki nyamfoo, lɛ etiki budi ketsyi lǝ mɛ ǝsuǝ! ");
INSERT INTO lip_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Fɛɛ bɛni biǝ biembubǝ mɛ ɔflɔ lǝ binyǝ nkpǝ. ");
INSERT INTO lip_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Minlɛ kasɔ mfo eto betidi eto atɛsǝ bɔbɛbɛ, ");
INSERT INTO lip_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","itsyise nyi betidi ba eto okle bini, nya nyi miǝ bianla Onanto lǝ mi akɔɛsi. ");
INSERT INTO lip_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Mbǝ lǝ mɔ Anto eto diye ǝsuǝ, fɛɛ biamfo mɛ. Nya lǝ utidi bamba ebubǝ lǝ wǝ kosate eto diye ǝsuǝ alɛɛ, biofo wǝ. ");
INSERT INTO lip_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ntsyǝ yuubǝ fɛ biofo mɛ bɛnɔ lǝ lefe nǝ eto lefe bɛnlɛ atɛsǝ bɔbɛbɛ ketsyiko mi bǝtsyuǝ ɔflɔ, nya biambɛbɛ atɛsǝ nnya ditsyi Onanto ɔni kplo ǝmǝ ɔflɔ? ");
INSERT INTO lip_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Fɛɛ biembu biǝ mɔ ni nwǝ loolo mi dikpi lǝ mɔ Anto ɔflɔ. Bomu Moses, nwǝ ǝsuǝ bífi mi kusubebe bítǝkǝ, wǝ ni futsyǝ loolo mi dikpi nɛ. ");
INSERT INTO lip_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Lǝ nnya ete béfo Moses bɛnɔ sitintii, eni béfo mɛ bɛnɔ, itsyise ɔ́wɔni asa utsyǝ itsyi lǝ mɛ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Fɛɛ se bíamfo lesa nǝ ɔ́wɔni utsyǝ bɛnɔɔ, ntsyǝ yuubǝ fɛ biofo lesa nǝ maatɛyi bɛnɔ?” ");
INSERT INTO lip_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Nyamfo eto kamaa, Yesu áyila Galilea eto Ditumbukplɛ nǝ bensi baakpo bǝ Tiberia eto Ditumbukplɛ úsu ni lekpake nǝ nse. ");
INSERT INTO lip_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Nya betidi kpǝ dítǝkǝko wǝ, itsyise bǝnyǝ ayanisa nnya úyifo ótsya mba nlɛ bufi eso. ");
INSERT INTO lip_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesu ku wǝ bakasebi ábe bésu bǝsiǝ lǝ lekpenkpe ditsyuǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Lefe nǝ Yudafɔ leedi Ukpe Ása Bo Ɔ́yila eto Diyi éboyo elo. ");
INSERT INTO lip_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Se Yesu létakasǝ ǝnǝmi únyǝ sitiditu kplɛ sia nlɛ wǝ ɔflɔ bubǝǝ, ɔ́tɔ Filipo nkǝ, “Sieti buunyǝ didisa boya butǝ betidi bamfo kenke lǝ bedi?” ");
INSERT INTO lip_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Fɛɛ Yesu átɔ nyamfo nkǝ lǝ ufi oto Filipo obe, ite bǝ uyi lesa nǝ wǝ kosate lǝǝbǝ buyifo tsya fɛ. ");
INSERT INTO lip_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipo ǝtǝ wǝ mbuayɛ nkǝ, “Lǝ bufi betidi alofa ǝnuǝ eto diyi eto kayofofo eto atabi boya didisa kulaa tsyaa, diemboyo bǝ betidi bamfo eto utsyuǝ saa nyǝ sɛkɛ udi!” ");
INSERT INTO lip_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Mfó nya Yesu eto okasebi wǝ ni Simon Petro, eto ɔyimi wǝ baakpo Andrea, lɛtɛyi wǝ nkǝ, ");
INSERT INTO lip_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Okosobi utsyuǝ si mfo wǝ ntsyi abolo anɔ ku akpɛ ǝnuǝ. Fɛɛ bǝ ni nyamfo itǝ betidi ba kpenkpe mfo?” ");
INSERT INTO lip_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesu átɛyi mǝ nkǝ, “Bitǝ lǝ betidi bamǝ lǝ bǝsiǝ lǝ kasɔ lǝ kaka lékpa wuee.” Nyaso betidi bamǝ kenke ǝsiǝ lǝ kasɔ. Basani mate eyifo fe akpi anɔ. ");
INSERT INTO lip_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Nya Yesu dífi abolo nyamǝ, nya ɔ́sɔ Onanto ani nya úsie nnya útǝ betidi bamǝ nsi mfó. Nko ke úyifo ku akpɛ nyamǝ tsya nɛ, nya mǝ utsyuǝ saa lɛkɛ kase óla. ");
INSERT INTO lip_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Se bédi bémii, Yesu átɛyi wǝ bakasebi bamǝ nkǝ, “Bɛsɛ nnya díbu, bǝ lǝ ku ni ditsyuǝ saa lǝ lɛyɛ bobia.” ");
INSERT INTO lip_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Nyaso básɛ nnya díbu bakɔ. Nya nnya díbu lǝ abolo anɔ nnya bédi ǝsuǝǝ, éyi lefosi etsyitsya ǝnuǝ. ");
INSERT INTO lip_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Se betidi bamǝ dínyǝ ayanisa nnya Yesu díyifoo, bátɛyi bǝnkǝ, “Sitinti nwǝ mfo ni Onanto eto Unyɛlǝkǝtidi wǝ luubǝ kawunsiǝ nɛ!” ");
INSERT INTO lip_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Nya, Yesu áte nkǝ bǝǝbǝ wǝ bubǝ kǝmuǝ lǝ ǝsuǝale ǝsuǝ kǝtsyǝ seka. Itǝ eso úlǝkǝ ǝsuǝ lǝ mǝ nti úsu ɔkɛ lǝ akpenkpe nnya nkpe mfó nti wǝ mate. ");
INSERT INTO lip_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Se ditsyitsyo lefe léyoo, Yesu eto bakasebi áyifǝ bésu ditumbukplɛ nemǝ kɛnyɛ. ");
INSERT INTO lip_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Bédufǝ lǝ ɔklɔ utsyuǝ ǝsuǝ nya bétsyiko ditumbukplɛ nǝmǝ bɔyila kesu Kapernaum eti. Kale ébolo, tsya fɛɛ Yesu mǝmbǝ óyotɔ mǝ ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ditumbukplɛ nǝmǝ eto ntu étsyiko bonwa ketu flɛmflɛmflɛ, itsyise ufiebi étsyiko bɔsɔ kekleke. ");
INSERT INTO lip_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Bakasebi bamǝ ébonwa ɔklɔ ǝmǝ báyɛ fe esunkpo ǝtsyǝ nye ana ku kama fɛ bǝnyǝ se Yesu nyɛ lǝ ntu bomǝ ǝsuǝ ɔnlɛ ɔklɔ ǝmǝ ɔflɔ bubǝ. Se bǝnyǝ wǝǝ, sikpi ko dímuǝ mǝ! ");
INSERT INTO lip_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Nya Yesu lɛtɛyi, mǝ nkǝ, “Biante sikpi! Mɔ uni.” ");
INSERT INTO lip_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Mfó fɛ ǝsuǝ diyuǝ mǝ nɛ! Nya bǝtǝ údufǝ lǝ ɔklɔ ǝmǝ nya ete bédufǝ kaka bántɔ tsya nɛ. ");
INSERT INTO lip_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Se kale dísiǝǝ, betidi ba díbu bǝńyǝ lǝ ditumbukplɛ nǝmǝ eto situma sia nsee, ǝnyǝ bǝtsyǝ lekpo bǝ diyi nǝ léfee, ɔklɔ ɔni hã díńyǝ lǝ utuflɔ mfó. Báte bǝ Yesu méndufǝ lǝ ɔklɔ ǝmǝ ǝsuǝ ku wǝ bakasebi fɛ bétsyiko ditumbukplɛ nǝmǝ bɔyila. Bakasebi bamǝ mate ete dídufǝ lǝ ɔklɔ ǝmǝ kafo. ");
INSERT INTO lip_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Nya efue bamba nnya ditsyi Tiberia eto umǝ ǝbǝ ídufǝ kaka dímantsyonko kaka bédi abolo, se Bonamute lékasɔ Onanto ani ólosǝ eto kama. ");
INSERT INTO lip_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Se sitiditu nǝmǝ dínyǝ nkǝ Yesu nye wǝ bakasebi mankɛ mfó esoo, bédufǝ lǝ efue nyamǝ nya bédu bésu Kapernaum bésu banlɛ Yesu bɔbɛbɛ. ");
INSERT INTO lip_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Se betidi bamǝ dínyǝ Yesu lǝ ditumbukplɛ eto lekpake nǝ nsee, bátɔ wǝ bǝnkǝ, “Oteasa, dimamfe fǝbǝ mfo?” ");
INSERT INTO lip_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesu ǝtǝ mǝ mbuayɛ nkǝ, “Nlɛ mi bɔtɛyi sitinti minkǝ, inni ayanisa nnya bínyǝ mínyifo bɛnɔ kasɔ eso bɛnlɛ mɛ bɔbɛbɛ, bomu lǝ didisa nǝ bɛkɛ bídi bími eso. ");
INSERT INTO lip_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Biankplatsya itǝ didisa nǝ laabia, bomu bekplatsya itǝ didisa nǝ lambia, nǝ luutsyǝ itǝ nkpǝ manlo. Didisa nǝmfoo, ni ni nǝ Utidi Eto Ubi luutǝ mi nɛ, itsyise Anto Onanto ébutǝkǝ wǝ kɔni utsyǝ.” ");
INSERT INTO lip_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Mfó nya betidi bamǝ lɛtɔ Yesu bǝnkǝ, “Be ele bǝ buyifo lǝ ete bǝ bɔlɛ Onanto eto keyifo buyifo?” ");
INSERT INTO lip_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesu ǝtǝ mǝ mbuayɛ nkǝ, “Lesa nǝ Onanto lela nkǝ biyifo ni bǝ befo utidi wǝ ótsyese bɛnɔ.” ");
INSERT INTO lip_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Bátɔ wǝ bǝnkǝ, “Nte ayanisa nnya fuuyifo ate bo, bǝ lǝ bofo fǝ bɔnɔ? Be fuuyifo? ");
INSERT INTO lip_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Bo banamǝ édi didisa nǝ baakpo mana lǝ mfiminti fe kase báwɔni bǝtsyǝ lǝ Awɔnisa Kɛnkɛ eto Kukue ǝsuǝ bǝnkǝ, ‘Útǝ mǝ didisa nǝ dítsyi kato nkǝ bedi.’ ” ");
INSERT INTO lip_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Mfó nya Yesu lɛtɛyi mǝ nkǝ, “Nlɛ mi bɔtɛyi sitinti minkǝ inni Moses ni nwǝ dítǝ mi didisa nǝ dítsyi kato. Bomu mɔ Anto ni nwǝ lǝǝtǝ mi didisa tinti nǝ ditsyi kato. ");
INSERT INTO lip_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Itsyise Onanto eto didisa ni nwǝ ditsyi kato úbǝ. Wǝ ni nwǝ lǝǝtǝ nkpǝ kawunsiǝ nɛ.” ");
INSERT INTO lip_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Bátɛyi wǝ bǝnkǝ, “Bonamute, tǝ bo didisa nǝmfo lefe saa.” ");
INSERT INTO lip_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Mfó Yesu lɛtɛyi mǝ nkǝ, “Mɔ ni didisa nǝ lǝǝtǝ nkpǝ nɛ. Fǝǝ ke díbǝ mɔ ɔflɔɔ, kukpɛnsɛ ǝmbɔlɛ fǝ kulefe, nya nwǝ léfo mɛ ɔ́nɔɔ, utukuɛ ǝmbɔlɛ wǝ kulefe kulefe. ");
INSERT INTO lip_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Fɛɛ ntɛyi mi minkǝ ite bǝ bíunyǝ mɛ tsyaa, bíamfo mɛ bɛnɔ. ");
INSERT INTO lip_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Utsyuǝ saa ke mɔ Anto ǝmǝ dífi útǝ mɛɛ, ebubǝ mɛ ɔflɔ, nya nwǝ díbǝ mɛ ɔflɔɔ, mǝmbɔni wǝ kulefe. ");
INSERT INTO lip_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Itsyise ntsyi kato mbǝ inni bǝ lǝ nyifo lǝ mɔ lelabi ǝsuǝ, bomu mbǝ miǝ lǝ nyifo lǝ nwǝ létsyese mɛ eto lele ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Nya utidi wǝ létsyese mɛ eto lelabi ni nkǝ mba kenke úfi útǝ mɛ eto kutsyuǝ mannya, bomu bǝ lǝ ntakasǝ mǝ nńyǝnsǝ lǝ diyi fɛfɛ ǝsuǝ lǝ mǝmblɛ kenke lǝ bǝnyǝ nkpǝ manlo. ");
INSERT INTO lip_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Itsyise mɔ Anto eto lelabi ni nkǝ, utsyuǝ saa wǝ dínyǝ mɔ Onanto eto Ubi nya ófo mɛ ɔ́nɔɔ, lǝ unyǝ nkpǝ manlo, nya mootakasǝ wǝ nńyǝnsǝ lǝ diyi fɛfɛ ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Mfó nya Yudafɔ bamǝ dítsyiko bɔwɔnɔnɔ lǝ wǝ ǝsuǝ itsyise ɔ́tɛyi nkǝ, “Mɔ ni didisa nǝ ditsyi kato díbǝ” eso. ");
INSERT INTO lip_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Nyaso bátɔ mǝ ǝsuǝ bǝnkǝ, “Inni Yesu ǝmfo wǝ ni Yosef eto Ubi lee? Buyi wǝ anto ku ambe. Ntsyǝ ibǝ fɛ woatɛyi nkǝ, utsyi kato úbǝ?” ");
INSERT INTO lip_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesu átɛyi mǝ nkǝ, “Bɛyɛ kǝnǝ lǝ mi nti. ");
INSERT INTO lip_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Kuutsyuǝ embofo mɛ ɔflɔ bubǝ lenni mɔ Anto ǝmǝ lékpa wǝ óboko mɔ ɔflɔ. Nya mootakasǝ wǝ mboko nkpǝ lǝ diyi fɛfɛ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Onanto eto bǝnyɛlǝkǝtidi áwɔni bǝnkǝ, ‘Onanto ebote mǝmblɛ kenke asa.’ Nyaso utsyuǝ saa wǝ leetsyue ato nya woakase asa ketsyi lǝ Anto ǝmǝ ɔflɔɔ, ǝǝbǝ mɔ ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Nyamfo mante bǝ utsyuǝ ébunyǝ Anto ǝmǝ unyǝ enso nwǝ ditsyi Onanto ǝmǝ ɔflɔ hã díkǝnyǝ wǝ unyǝ. ");
INSERT INTO lip_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nlɛ mi bɔtɛyi sitinti minkǝ nwǝ lefo ɔnɔɔ, nkpǝ manlo kpe wǝ. ");
INSERT INTO lip_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Mɔ ni dídisa nǝ lǝǝtǝ nkpǝ. ");
INSERT INTO lip_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Mi banamǝ édi lesa nǝ baakpo mana lǝ mfiminti, fɛɛ bekpǝ. ");
INSERT INTO lip_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Fɛɛ didisa nǝ ditsyi kato díbǝǝ, eyifo didisa nǝ utsyuǝ saa ke leedi nii, embukpǝ. ");
INSERT INTO lip_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Mɔ ni didisa nǝ lǝǝtǝ nkpǝ, nǝ dítsyi kato díbǝ. Utsyuǝ saa wǝ leedi lesa nǝmfoo, wuusiǝ nkpǝ lefe saa. Nya didisa nǝ muufi ntǝ kawunsiɛ eto betidi bǝ lǝ bǝnyǝ nkpǝǝ, eyifo mɔ ǝsuǝ eto sinǝ sia muumfi ntǝ.” ");
INSERT INTO lip_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Nyamfo áboko kǝnǝ kekleke lǝ Yudafɔ bamǝ nti nya bátɔ bǝ, “Ntsyǝ utidi ǝmfo loofo wǝ ǝsuǝ eto sinǝ bufi kǝtǝ bo nkǝ budi?” ");
INSERT INTO lip_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Mfó nya Yesu lɛtɛyi mǝ nkǝ, “Nlɛ mi bɔtɛyi sitinti minkǝ, lǝ biendi mɔ Utidi Eto Ubi eto ǝsuǝ eto sinǝ, binǝ mɔ kɔtɔɔ, biembunyǝ nkpǝ lǝ mi ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Utsyuǝ saa ke leedi mɔ ǝsuǝ eto sinǝ nya wǝǝnǝ mɔ kɔtɔɔ, ebunyǝ nkpǝ manlo, nya mootakasǝ wǝ mboko nkpǝ, lǝ diyi fɛfɛ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Itsyise mɔ ǝsuǝ eto sinǝ ni didisa tinti nya mɔ kɔtɔ ni ǝnǝsa tinti. ");
INSERT INTO lip_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Utsyuǝ saa ke leedi mɔ ǝsuǝ eto sinǝ nya wǝǝnǝ mɔ kɔtɔɔ, okpe lǝ mɛ, nya mintsya nsi nkpǝ lǝ wǝ. ");
INSERT INTO lip_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Fe kase Anto wǝ nsi nkpǝ lǝ mɛ nya minsi nkpǝ lǝ wǝǝ, nko ke utidi wǝ leedi mɔ ǝsuǝ eto sinǝǝ, luusiǝ nkpǝ ɛyɛ lǝ mɛ eso nɛ. ");
INSERT INTO lip_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Nyamfo ni didisa nǝ ditsyi kato díbǝ. Dinte fe didisa nǝ eto okle mi banamǝ dídi nya bǝkpǝ. Utsyuǝ saa kee leedi didisa nǝ maatɛyi mfoo, ebusiǝ nkpǝ itǝ lefe nǝmǝ kenke.” ");
INSERT INTO lip_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Asa nyamfo Yesu léte mǝ lǝ Yudafɔ eto katsyakɔ lǝ Kapernaum nɛ. ");
INSERT INTO lip_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Se Yesu eto bakasebi kpǝ lɛnɔ etiki nyamfoo, bátɛyi bǝnkǝ, “Ditiki nǝmfo eto kasɔnɔnɔ kpe ale tinti! Owoe loofo ni bofo?” ");
INSERT INTO lip_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ite bǝ mǝ kuutsyuǝ mémfe kɛnyɛ ɔ́tɛyi kulesa tsyaa, Yesu áte nkǝ íkǝlǝ mǝ lǝ akɔɛsi nya ɔ́tɔ mǝ nkǝ, “Nyamfo ǝlǝ mi? ");
INSERT INTO lip_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Nyalɛ, lǝ ibǝ bǝ binyǝ Utidi eto Ubi ǝmǝ ɔntɔ kato kaka usiǝ kɔɔ, ntsyǝ biuyifo? ");
INSERT INTO lip_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Onanto eto Lɛwɔnɔ Kɛnkɛ lǝǝtǝ nkpǝ. Utidi eto ǝsuǝ eto sinǝ ǝmbǝ kutǝkǝ saa. Etiki nnya kenke míntɛyi eyifo Onanto eto Lɛwɔnɔ eto etiki nnya lǝǝtǝ nkpǝ. ");
INSERT INTO lip_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Fɛɛ bǝtsyuǝ kpe lǝ mi nti ba dímamfo bánɔ.” Yesu áte taa kasɔ ketsyikokɔ mba dímamfo wǝ bánɔ ku nwǝ luufi wǝ okpe kɔni. ");
INSERT INTO lip_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ɔ́tɛyi úsukosǝ nkǝ, “Nyamfo eso míntɛyi mi miǝ kuutsyuǝ saa embofo mɛ ɔflɔ bubǝ lenni Anto ǝmǝ dítǝ wǝ kusu.” ");
INSERT INTO lip_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Lǝ nyamfo eto kamaa, mba dítǝkǝko wǝ kpǝ ésinkli lǝ wǝ kama nya bǝkǝtǝkǝko wǝ kama bio. ");
INSERT INTO lip_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Mfó nya Yesu lɛtɔ wǝ bakasebi lefosi inuǝ bamǝ nkǝ, “Mi tsyaa, biusinkli mɛ kama?” ");
INSERT INTO lip_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Petro ǝtǝ wǝ mbuayɛ nkǝ, “Bonamute, owoe ɔflɔ buudu busu? Fǝ nkpe nkpǝ manlo eto etiki nyamǝ! ");
INSERT INTO lip_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nya mɔmɔɔ, bófo bɔ́nɔ nya bunyi boǝ fǝ ni Onanto eto Ubi, wǝ ni Ɔkɛnkɛnyǝ ǝmǝ.” ");
INSERT INTO lip_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Mfó nya Yesu dítǝ mbuayɛ nkǝ, “Mɔ ni nwǝ dílǝkǝ mi lefosi inuǝ bamǝ tsyaa, ɔni eyifo oboatidi lǝ mi nti!” ");
INSERT INTO lip_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yesu átɛyi nyamfo itsyi lǝ Yuda wǝ ni Simon Iskariot eto ubi ǝsuǝ. Itsyise uyifo bakasebi lefosi inuǝ bamǝ eto ɔni wǝ luufi wǝ okpe kɔni. ");
INSERT INTO lip_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Lǝ nyamfo eto kamaa, Yesu ésu ɔ́yɛ lǝ Galilea eto kasɔ, nya wánla nkǝ weesu Yudea eto kasɔ itsyise Yudafɔ akabɛbɛ kusu lǝ balo wǝ eso. ");
INSERT INTO lip_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Lefe nǝmfoo, Yudafɔ eto Mpatampa Kalɔsiǝsiǝ eto Diyisɛɛ nǝmǝ éboyo. ");
INSERT INTO lip_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Nyaso Yesu eto bayimisani átɛyi wǝ nkǝ, “Du mfo lǝ esu Yudea eto kasɔ lǝ fǝ bakasebi lǝ bǝnyǝ asa nnya fanlɛ buyifo. ");
INSERT INTO lip_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Itsyise utidi wǝ laala nkǝ bate wǝǝ, enyifo asa kakula. Se fanlɛ asa nyamfo buyifoo, lǝkǝ nnya ate kawunsiǝ kenke lǝ betidi lǝ bate fǝ!” ");
INSERT INTO lip_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Bátɛyi wǝ nko itsyise wǝ bayimisani kulaa tsya mámfo wǝ bánɔ. ");
INSERT INTO lip_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yesu átɛyi mǝ nkǝ, “Mɔ lefe mányo tɔ. Fɛɛ mii, lefe saa alɛkɛ itǝ mi. ");
INSERT INTO lip_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Kawunsiǝ embofo mi bukisi. Fɛɛ mɔɔ, keekisi mɛ itsyise nlɛ bulǝkǝ kate minkǝ ke asayifoyifo eyi ku abuayifoyifo. ");
INSERT INTO lip_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Mii, bisu diyisɛɛ nǝmǝ kedikɔ. Mɔɔ, membusu diyi nǝmǝ kedikɔ itsyise mɔ lefe mányo tɔ.” ");
INSERT INTO lip_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Se ɔ́tɛyi mǝ nyamfoo, ɔ́tsyimɛ ɔkɛ lǝ Galilea mfó. ");
INSERT INTO lip_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Fɛɛ se wǝ bayimisani bamǝ dídu bésu diyi nǝmǝ kedikɔ eto kamaa, Yesu tsya ésu mfó, fɛɛ wǝnlǝkǝ wǝ ǝsuǝ ote, ɔ́kula ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Yudafɔ eto beninǝ ákabɛbɛ wǝ lǝ diyisɛɛ nǝmǝ kedikɔ ákatɔ bǝ, “Sieti osani ǝmǝ nkpe?” ");
INSERT INTO lip_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Betidi kpǝ lǝ sitiditu nǝmǝ nti ékedi etiki kawɛkawɛ lǝ Yesu ǝsuǝ katɛyi bǝnkǝ, “Uyifo utidi sɛɛ.” Nya bǝtsyuǝ tsya díkatɛyi bǝnkǝ, “Owo lo! Ɔlɛ betidi bɔwɛ kakpe kanyansǝ!” ");
INSERT INTO lip_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Fɛɛ se banlɛ Yudafɔ sikpi bote esoo, kuutsyuǝ mámfo nnya bulǝkǝ katɛyi lǝ betidi lǝ banɔ. ");
INSERT INTO lip_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Se diyisɛɛ nǝmǝ didi eto eyi leyo ni ntinti etii, Yesu ésu Yudafɔ eto Disumuyo nya úsu óte asa mfó. ");
INSERT INTO lip_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Wǝ asatete nyamǝ éyifo Yudafɔ bamǝ yanii, nya bátɛyi bǝnkǝ, “Sieti okosobi ǝmfo ditsyi ku kobe komfo eto okle, se wénsu asa kakasekɔ lǝ kukalebe saa?” ");
INSERT INTO lip_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Mfó Yesu dítǝ mbuayɛ ɔ́tɛyi mǝ nkǝ, “Mɔ asatete méntsyi mɔ kosate ɔflɔ. Bomu itsyi Onanto wǝ létsyese mɛ ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Utidi wǝ laala nkǝ weeyifo Onanto eto lelabii, ebote lǝ asa nnya maate etsyi Onanto ɔflɔ lee, mɔ kosate eto ǝsuǝale ǝsuǝ maate nnya. ");
INSERT INTO lip_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Utidi wǝ leedi etiki itsyi lǝ wǝ ǝsuǝale ǝsuǝǝ, wǝ ǝsuǝ eto atɛsǝ waabɛbɛ. Fɛ, utidi wǝ laala nkǝ waatɛsǝ nwǝ létsyese wǝǝ, weeyifo asa kayɛnko lǝ sitinti ǝsuǝ nya waantɛyi sidia. ");
INSERT INTO lip_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Inni Moses ni nwǝ dítǝ mi kɔfi komǝ lee? Fɛɛ mi kuutsyuǝ entsyue kɔfi komǝ koto. Beso bela biǝ bialo mɛ?” ");
INSERT INTO lip_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Mfó sitiditu siamǝ dítǝ wǝ mbuayɛ bǝnkǝ, “Lɛwɔnɔ bua tǝkǝko fǝ! Owoe nlɛ bola nkǝ waalo fǝ?” ");
INSERT INTO lip_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesu ǝtǝ mǝ mbuayɛ nkǝ, “Ayanisa ani nyamfo mínyifo nya íyifo mimblɛ tã yanii mmǝ. ");
INSERT INTO lip_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moses ǝtǝ mi kɔfi nkǝ bela mi bebisaibi eto alo. Ite bǝ inni Moses uni dítsyiko nko, bomu itsyi taa mi bana lefe. Nyaso biala osaibi lelo lǝ Ɔnwɛditsyǝyi nɛ. ");
INSERT INTO lip_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Nya lǝ boofo osaibi lelo bola lǝ Ɔnwɛditsyǝyi ǝsuǝ lǝ kase yembonta Moses eto kɔfi ibuu, beso biǝnyǝ ɔblɔ kakpe mɛ biǝ ntsya utidi wǝ nlɛ bufi, úmuǝ ale kenke lǝ Ɔnwɛditsyǝyi ǝsuǝ? ");
INSERT INTO lip_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Biemfi ǝnyǝnsa bekpo lekpo! Bomu bekpo etiki eto lekpo ɛyɛ lǝ sitintisu ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Betidi bǝtsyuǝ ba dítsyi Yerusalem átɔ bǝ, “Inni utidi ǝmfo banlɛ bɔbɛbɛ bǝ baalo? ");
INSERT INTO lip_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Bebe wǝ! Ɔlɛ etiki budi lǝ obianti, nya bántɛyi wǝ kulesa! Lee, bote bákate sitinti biǝnkǝ wǝ ni Nwǝ Onanto Lékpo Ɔhile Utsyǝ ǝmǝ? ");
INSERT INTO lip_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Lǝ Nwǝ Onanto Lékpo Ɔhile Utsyǝ ǝmǝ ǝbǝǝ, kuutsyuǝ saa embote kaka utsyi úbǝ. Fɛɛ utidi ǝmfo alɛɛ, bomblɛ yi kaka utsyi úbǝ.” ");
INSERT INTO lip_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Lefe nǝ Yesu díkate asa lǝ Disumuyo mfóo, ófa bembembe ɔ́tɔ nkǝ, “Inni biǝnkǝ biyi mɛ sitinti ku kaka mintsyii? Mǝmbǝ mfo lǝ mɔ ǝsuǝale ǝsuǝ! Nwǝ létsyese mɛɛ, waantɛyi sidia. Nya mii, binyi wǝ. ");
INSERT INTO lip_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Fɛɛ mɔɔ, nyi wǝ, itsyise intsyi wǝ ɔflɔ nya wǝ ni nwǝ létsyese mɛ.” ");
INSERT INTO lip_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Nya bákplatsya bǝ bǝmuǝ wǝ. Fɛɛ mǝ kuutsyuǝ saa mámfo wǝ butidi, itsyise wǝ lefe mányo tɔ. ");
INSERT INTO lip_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Fɛɛ kpǝ lǝ mǝ nti áfo wǝ bánɔ nyaso bátɔ bǝnkǝ, “Nya lǝ Nwǝ Onanto Lékpo Ɔhile Utsyǝ díbǝǝ, uteyifo ayanisa ote enso nnya utidi ǝmfo díkeyifoo?” ");
INSERT INTO lip_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Farisifɔ bamǝ ánɔ se sitiditu siamǝ nlɛ etiki nyamfo bɔtɛyi lǝ kawɛ lǝ mǝ nti lǝ Yesu ǝsuǝ, nyaso mǝ ku besumunyǝ ninǝ átsya nya batsyese kedikǝtǝkɔ eto mba laase mfo bǝ besu bǝmuǝ Yesu baboko. ");
INSERT INTO lip_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yesu átɛyi mǝ nkǝ, “Nsi mɔɔkɛ mi lenti itǝ lefe kliminti ditsyuǝ ete muusinkli nsu nwǝ letsyese mɛ ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Biɔbɛbɛ mɛ, fɛɛ biembunyǝ mɛ, itsyise kaka mɔɔkɛɛ, biembofo mfó bubǝ.” ");
INSERT INTO lip_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ete Yudafɔ eto beninǝ lɛtɔ mǝ ǝsuǝ benkǝ, “Sieti nwǝ mfo laala nkǝ weesu fɛ boembunyǝ wǝ? Lee, bubu ɔnlɛ nkǝ weedu usu Helafɔ eto kǝmǝ ka bo betidi nkpe bǝ lǝ ote Helafɔ bamǝ asa mfóo? ");
INSERT INTO lip_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Nnya ɔnlɛ bɔtɛyi nkǝ, ‘Biɔbɛbɛ mɛ, fɛɛ biembunyǝ mɛ,’ nya ‘Kaka mɔɔkɛɛ, biǝmbofo mfó bubǝǝ,’ eto kasɔ ni be?” ");
INSERT INTO lip_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Lǝ diyi fɛfɛ nǝ ni diyi nǝ nso bofe lǝ diyididi nǝmǝ ǝsuǝǝ, Yesu átaka úńyǝ nya óbesǝ ɔkɔɛ kato ɔ́tɛyi nkǝ, “Lǝ utukuɛ lɛ utsyuǝǝ, utsyǝ ǝmǝ bǝ mɔ ɔflɔ lǝ ubǝ unǝ ntu. ");
INSERT INTO lip_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Fe kase báwɔni bákpe lǝ Awɔnisa Kɛnkɛ eto Kukue ǝsuǝ bátɛyi bǝnkǝ, ‘Utidi wǝ léfo mɛ ɔ́nɔɔ, ketukplo ka lǝǝtǝ ntu bo lǝǝtǝ utidi lǝǝsiǝ nkpǝ eto ntuu, ebɔbɔdi butsyi lǝ wǝ utu kǝmiǝ.’ ” ");
INSERT INTO lip_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesu átɛyi nyamfo itsyi lǝ Lɛwɔnɔ nǝ mba léfo wǝ bánɔ loofo ǝsuǝ. Itsyise éyo lefe nǝmfoo, bǝntǝ tɔ Lɛwɔnɔ nǝmǝ, se bántakasǝ tɔ Yesu betsyiko ɔkɔmǝ báboko wǝ diyǝnde esuǝ eso. ");
INSERT INTO lip_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Se betidi bamǝ lɛnɔ etiki nyamfoo, bátɛyi benkǝ, “Sitintii, utidi ǝmfo eyifo Onanto eto Unyɛlǝkǝtidi ǝmǝ.” ");
INSERT INTO lip_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Babamba tsya átɛyi bǝnkǝ, “Nwǝ mfo ni Nwǝ Onanto Lékpo Ɔhile Utsyǝ nɛ.” Fɛɛ mǝ bǝtsyuǝ átɔ bǝnkǝ, “Nwǝ Onanto Lékpo Ɔhile Utsyǝǝ, ebofo Galilea butsyi? ");
INSERT INTO lip_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Awɔnisa Kɛnkɛ eto Kukue átɛyi nkǝ Nwǝ Onanto Lékpo Ɔhile Utsyǝ ebutsyi Oka David eto kafo lǝ Betlehem eto umǝ kaka Oka David dísiǝ.” ");
INSERT INTO lip_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Lǝ nnya eso kabakǝfǝ édufǝ lǝ betidi bamǝ eto nti itsyi lǝ Yesu eso. ");
INSERT INTO lip_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Bǝtsyuǝ ala bǝ bǝǝmuǝ wǝ, fɛɛ kuutsyuǝ saa méntidi wǝ. ");
INSERT INTO lip_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Se mbalaase Disumuyo eto mba bákpe dísinkli besuu, Farisifɔ ku besumunyǝ ninǝ bamǝ ɔflɔ, bátɔ mǝ bǝnkǝ, “Beso bíǝmmuǝ wǝ lǝ ǝsuǝale beboko?” ");
INSERT INTO lip_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Mfó nya bǝtǝ mbuayɛ bǝnkǝ, “Boannɔ tɔ kuutsyuǝ saa di etiki fe kase utidi ǝmfo didi kulefe!” ");
INSERT INTO lip_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Farisifɔ bamǝ átɔ mǝ bǝnkǝ, “Nyalɛ úflu mi tsyaa, mi nsusu, ɔ́wɛ mi ókpe? ");
INSERT INTO lip_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Bíɔnɔ tɔ bɛnɔ biǝ beninǝ bǝtsyuǝ nye Farisinyǝ utsyuǝ áfɔ wǝ ɔ́nɔ? ");
INSERT INTO lip_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Kulefe, kulefe! Ditiditu nǝmfo enyi Moses eto kɔfi eto kulesa. Nyaso Onanto eto ekudi tǝkǝko mǝ!” ");
INSERT INTO lip_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Farisifɔ eto uninǝ ɔni wǝ baakpo Nikodemo, ébusu Yesu ɔflɔ únyǝ. Ɔ́tɔ mǝ nkǝ, ");
INSERT INTO lip_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Nyalɛ, bo kɔfi ǝtǝ bo kusu nkǝ bokponko utidi lekpo bolo wǝ dikpi lefe nǝ eto lefe boannɔ tɔ wǝ kɛnyɛ eto etiki nye batɔ wǝ lesa nǝ úyifo?” ");
INSERT INTO lip_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Bǝtǝ mbuayɛ bátɔ wǝ bǝnkǝ, “Nyalɛ, fintsya Galileanyǝ feni? Dufǝ lǝ Anantotiki eto Ekue abe, ete ebote fǝ Onanto eto unyɛlǝkǝtidi kuutsyuǝ embɔbɔ utsyi lǝ Galilea.” ");
INSERT INTO lip_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","(Nya utsyuǝ saa dídu úsu diyo.) ");
INSERT INTO lip_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Fɛɛ Yesu wǝ édu úsu Nnuǝbi eto Eyi eto Kɔtini ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Kǝsiǝsǝ eto olesiǝ tuu, úsinkli úsu Yudafɔ eto Disumuyo. Betidi bamǝ kenke ǝbǝ bátsyilama wǝ, nya úsiǝ lǝ mǝ nti, útsyiko mǝ asa bote. ");
INSERT INTO lip_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Mfóo, kɔfi eto bateasa ku Farisifɔ lékpa usio utsyuǝ wǝ bǝmuǝ kɔni kɔni lǝ disǝnkpo ǝsuǝ báboko mfó. Nya bǝńyǝnsǝ wǝ lǝ mǝmblɛ kenke eto ǝnǝmi. ");
INSERT INTO lip_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Bátɛyi Yesu bǝnkǝ, “Oteasa, bǝmuǝ usio ǝmfo kɔni kɔni lǝ disǝnkpo ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Lǝ Moses eto kɔfi ǝsuǝǝ, ele bǝ boto wǝ okle aba bolo,” lǝ bǝnyǝ etiki lǝ wǝ, “Ntsyǝ fanlɛ bɔtɛyi lǝ nnya ǝsuǝ?” ");
INSERT INTO lip_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Bátɔ wǝ nyamfo bǝ lǝ befi bato wǝ babe lǝ bayɛ lǝ nnya ǝsuǝ bǝmuǝ wǝ. Fɛɛ Yesu ǝbǝ kasɔ nya úfi wǝ lɛnimi útsyiko asa bɔwɔni lǝ kasɔnti. ");
INSERT INTO lip_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Nya se bensi bǝńyǝ banlɛ wǝ etiki bɔtɔɔ, óbesǝ ǝsuǝ kato nya ɔ́tɛyi mǝ nkǝ, “Mi nti eto nwǝ dímenyifo tɔ lebua unyǝǝ, di ututɛ lǝ oto wǝ leba.” ");
INSERT INTO lip_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Nya usi úbǝ kasɔ, ɔ́wɔni asa lǝ kasɔnti ku wǝ lɛnimi. ");
INSERT INTO lip_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Se beninǝ bamǝ lɛnɔ nnya nkoo, mǝmblɛ kenke édu ɔni, ɔni, idu lǝ beninǝtidi ǝsuǝ. Isi íbu Yesu ku usio ǝmǝ mate nsi nyǝ mfó. ");
INSERT INTO lip_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesu átakasǝ ǝsuǝ únyǝ nya ɔ́tɔ usio ǝmǝ nkǝ, “Boambe, se báfe? Nyalɛ, mǝ kuutsyuǝ mémbu loolo fǝ dikpi?” ");
INSERT INTO lip_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Mfó usio ǝmǝ dítǝ mbuayɛ nkǝ, “Owo lo, Bonamute.” Nyaso Yesu átɛyi wǝ nkǝ, “Nko ke mintsya lǝmbolo fǝ dikpi nɛ. Nyaso du esu. Fɛɛ mensisu eyifo lebua bio.” ");
INSERT INTO lip_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesu esi údi Farisifɔ etiki ɔ́tɛyi nkǝ, “Mɔ ni kawunsiǝ eto diyǝnde. Utidi wǝ ke ntekǝko mǝǝ, wuunyǝ diyǝnde nǝ lǝǝtǝ utidi nkpǝ tinti nya wǝǝmbɔyɛ lǝ ketuntu ǝsuǝ kulefe.” ");
INSERT INTO lip_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Farisifɔ bamǝ átɛyi wǝ bǝnkǝ, “Alɛ etiki budi ketsyi lǝ fǝ ǝsuǝ. Nyaso nnya fanlɛ bɔtɛyi ǝmbǝ kalende saa.” ");
INSERT INTO lip_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Mfó nya Yesu lɛtɛyi mǝ nkǝ, “Owo lo, ite bǝ nlɛ etiki budi ketsyi lǝ mɔ ǝsuǝ tsyaa, lesa nǝ minlɛ bɔtɛyi kpe kalende, itsyise nyi kaka mintsyi, nya minyi kaka mintɔ. Fɛɛ mimii, binyi kaka mintsyi nye kaka mintɔ. ");
INSERT INTO lip_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Mii, kawunsiǝ eto nsusu ǝsuǝ nnya biefi kakponko asa lekpo nɛ, fɛ mɔɔ, mankponko kuutsyuǝ lekpo. ");
INSERT INTO lip_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Fɛɛ lǝ bǝ nyifo nkoo, mɔ lekpokponkpo ebɔyɛ lǝ sitinti eto kusu ǝsuǝ. Itsyise inni mɔ mate lookpo ni. Bomu Anto wǝ létsyese mɛɛ, ǝǝńyǝ mɛ kama. ");
INSERT INTO lip_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Nya lǝ mi kɔfi ǝsuǝǝ, báwɔni bákpe bǝ, lǝ badansiɛ inuǝ eto kɛnyɛ akate lǝ etiki ǝtsyuǝ ǝsuǝǝ, lesa nǝ bátɛyi kpe kalende. ");
INSERT INTO lip_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Mɔɔ, meedi adansiɛ lǝ lesa nǝ maatɛyi ǝsuǝ, nya mɔ Anto wǝ létsyese mɛ tsya eedi adansiɛ lǝ mɛ ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Mfó bátɔ wǝ bǝnkǝ, “Se fǝ anto ǝmǝ nkpe?” Yesu ǝtǝ mbuayɛ nkǝ, “Binyi mɛ nya binyi mɔ Anto ǝmǝ tsya. Lǝ bote ete bete mɛɛ, eni biote mɔ Anto tsya.” ");
INSERT INTO lip_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesu átɛyi nyamfo lǝ okokakokɔ se ɔnlɛ asa bote lǝ Disumuyo nǝmǝ. Fɛɛ kuutsyuǝ saa mǝmmuǝ wǝ, itsyise wǝ lefe mányo tɔ. ");
INSERT INTO lip_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesu esi ɔ́tɛyi mǝ nkǝ, “Mǝǝbǝ budu lǝ mi ɔflɔ, nya biɔbɛbɛ mɛ, fɛɛ biukpǝ lǝ mi abua ǝsuǝ. Nya kaka mintɔɔ, biembofo mfó bubǝ.” ");
INSERT INTO lip_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Nyaso Yudafɔ bamǝ átɔ mǝ ǝsuǝ bǝnkǝ, “Wǝ ǝsuǝ ɔntɔ kalokɔ eso ɔ́tɛyi nkǝ, ‘Biembofo kaka mintɔ bubǝ lee’?” ");
INSERT INTO lip_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesu ǝtǝ mǝ mbuayɛ nkǝ, “Mimii, kasɔ mfo eto betidi bini. Nya mɔɔ, ntsyi kato. Mi etsyi kawunsiǝ mfo, fɛɛ mɔɔ, mentsyi kawunsiǝ mfo. ");
INSERT INTO lip_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Nyaso míntɛyi mi minkǝ biukpǝ lǝ mi abua ǝsuǝ nɛ. Nya lǝ biamfo bɛnɔ biǝ mɔ ni nwǝ minii, biukpǝ lǝ mi abua ǝsuǝ sitinti.” ");
INSERT INTO lip_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Bátɔ wǝ bǝ, “Owoe feni?” Yesu ǝtǝ mǝ mbuayɛ nkǝ, “Lesa nǝ míntɛyi mi itsyi taa kasɔ ketsyikokɔɔ, ni ǝmǝ ete nɛ. ");
INSERT INTO lip_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nkpe etiki kpǝ lǝ mi ǝsuǝ nnya ele bǝ mfi nlo mi dikpi. Fɛɛ nwǝ létsyese mɛɛ, sitintitidi uni. Nya asa nnya minɔ mintsyiko wǝ ɔflɔɔ, nnya mimfi minlɛ letsya bobe kǝtǝ kawunsiǝ nɛ.” ");
INSERT INTO lip_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Mfóo, bánnɔ kasɔ bǝ Yesuu, Anto ǝmǝ ǝsuǝ ɔnlɛ etiki budi ketsyiko. ");
INSERT INTO lip_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Nyaso ɔ́tɛyi mǝ nkǝ, “Lǝ bebesǝ Utidi Eto Ubi ǝmǝ katoo, nyafɛ biote biǝ mɔ ni nwǝ mini nɛ, nya meenyifo kulesa lǝ mɔ ǝsuǝale ǝsuǝ. Bomu lesa nǝ mɔ Anto léte mɛ nkǝ ntɛyii, ni hã maatɛyi nɛ. ");
INSERT INTO lip_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Nwǝ lekpe mɛ kɔtɔɔ, si ko mɛ. Wóanyani mɔ mate utsyǝ, itsyise meeyifo lesa nǝ lǝǝyuǝsǝ wǝ kafo lefe saa.” ");
INSERT INTO lip_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Nya se ɔ́tɛyi nyamfo mmǝǝ, betidi kpǝ ba lɛnɔ ɔ́tɛyi nyamfoo, áfo wǝ bánɔ. ");
INSERT INTO lip_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Nyaso Yesu átɛyi Yudafɔ ba léfo wǝ bánɔ nkǝ, “Lǝ biyifo lǝ mɔ asatete ǝsuǝǝ, ete bǝ biyifo mɔ bakasebi sitinti nɛ. ");
INSERT INTO lip_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Biote sitinti siamǝ, nya sitinti siamǝ ebutǝ bisiǝ lǝ mi ǝsuǝ ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Bátɛyi wǝ bǝnkǝ, “Abraham eto befluflu buni, nya bóendi tɔ ndomufɔ butǝ kuutsyuǝ saa tɔ búnyǝ! Ntsyǝ ibǝ fɛ faatɛyi fǝnkǝ, bootǝ busiǝ lǝ bo ǝsuǝ ǝsuǝ?” ");
INSERT INTO lip_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesu ǝtǝ mǝ mbuayɛ nkǝ, “Nlɛ mi bɔtɛyi sitinti minkǝ utsyuǝ saa ke leeyifo lebuaa, uyifo ndomunyǝ utǝ lebua. ");
INSERT INTO lip_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ndomunyǝ aamfiani oyobi wǝ nkpe kedikɔ kulefe. Bomu oyosate eto ubii, wǝ kpe kedikɔ lefe saa. ");
INSERT INTO lip_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Nyaso lǝ mɔ Onanto eto Ubi ǝtǝ kusu nkǝ bisiǝ lǝ mi ǝsuǝ ǝsuǝ ǝsuǝǝ, ete bǝ bisi lǝ ǝsuǝ ǝsuǝ sitinti nɛ. ");
INSERT INTO lip_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nyi miǝ Abraham eto bebi bini. Fɛɛ bela biǝ bialo mɛ, itsyise biamfo asa nnya maate mi bɛnɔ, eso. ");
INSERT INTO lip_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Lesa nǝ mímfo mintsyiko mɔ Anto ɔflɔɔ, ni maatɛyi nɛ. Nya mi tsyaa, lesa nǝ bɛnɔ bitsyiko mi anto ɔflɔɔ, ni bɛnlɛ buyifo nɛ.” ");
INSERT INTO lip_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Yudafɔ bamǝ átɛyi wǝ bǝnkǝ, “Abraham ni bo anto.” Yesu átɛyi mǝ nkǝ, “Lǝ Abraham eto bebi bini sitintii, eni biuyifo asa nnya Abraham díyifo seka. ");
INSERT INTO lip_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Fɛɛ bela biǝ bialo mɔ nwǝ laatɛyi mi sitinti sia mínɔ mintsyiko Onanto ɔflɔ. Abraham ményifo nko. ");
INSERT INTO lip_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Asa nnya mi anto kosate díyifoo, nya bɛnlɛ buyifo nɛ.” Mfó bátɛyi wǝ bǝnkǝ, “Bunni basɔnɔbi! Anto ɔni nkpe bo, wǝ ni Onanto!” ");
INSERT INTO lip_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesu átɛyi mǝ nkǝ, “Lǝ Onanto ete ni mi antoo, eni biala mɛ. Itsyise Onanto ɔflɔ míntsyi mímbǝ mfo. Inni mɔ kosate eto lelabi ǝsuǝ mímbǝ. Bomu wǝ ni nwǝ létsyese mɛ. ");
INSERT INTO lip_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ntsyǝ eso biannɔ lesa nǝ minlɛ mi bɔtɛyi kasɔ? Nnya ni bǝ bianla biǝ bianɔ ditiki nǝ minlɛ mi bɔtɛyi. ");
INSERT INTO lip_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Mi anto Obonsam eto bebi bini, nya bela biǝ bieyifo wǝ lelabi. Idu taa kasɔ ketsyikokɔɔ, uyifo nwǝ laalo betidi. Nya woanla ditiki tinti nǝmǝ itsyise woantɛyi sitinti kulefe. Lǝ ɔtɛyi sidiaa, wǝǝlǝkǝ wǝ ditsyǝbi kate. Itsyise nwǝ laatɛyi sidia uni, nya wǝ ni bidia kenke eto anto. ");
INSERT INTO lip_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Fɛɛ mɔɔ se ini sitinti maatɛyi mi esoo, biamfo mɛ kanɔ. ");
INSERT INTO lip_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Mi nti eto owoe loofo mɛ dikpi bolo nkǝ nyifo lebua? Lǝ ntɛyi mi sitintii, beso biamfo mɛ kanɔ? ");
INSERT INTO lip_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Utidi wǝ ni Onanto eto olee, aanɔ Onanto eto etiki. Nnya eso biannɔ Onanto eto etiki ni bǝ binni wǝ bale.” ");
INSERT INTO lip_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Yudafɔ átɔ Yesu bǝnkǝ, “Lǝ bɔ́tɛyi boǝnkǝ Samarianyǝ feni nya lɛwɔnɔ bua tǝkǝko fǝǝ, bɔ́tɛyi sidia?” ");
INSERT INTO lip_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesu ǝtǝ mǝ mbuayɛ nkǝ, “Lɛwɔnɔ bua saa ǝntǝkǝko mɛ. Nlɛ mɔ Anto dibu butǝ, fɛɛ mi ǝntǝ mɛ dibu. ");
INSERT INTO lip_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Mɔɔ, maambɛbɛ dibu kǝtǝ ǝsuǝ. Fɛɛ nwǝ laabɛbɛ nkǝ betidi tɛsǝ mɛɛ, kpe. Wǝ ni nwǝ laakpo lekpo kayɛnko lǝ kusu ǝsuǝ nɛ. ");
INSERT INTO lip_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nlɛ mi bɔtɛyi sitinti minkǝ, lǝ utsyuǝ eetsyue mɔ asatete kotoo, wǝmbukpǝ kulefe!” ");
INSERT INTO lip_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Yudafɔ átɛyɛ wǝ bǝnkǝ, “Mfe fɛ buunyǝ boǝ lɛwɔnɔ bua tǝkǝko fǝ nɛ! Abraham ǝkpǝ, nya Onanto eto bǝnyɛlǝkǝtidi tsya díkpǝ, fɛɛ fǝ lɛ bɔtɛyi fǝ nwǝ ke ditsyue fǝ asatete kotoo, ǝmbukpǝ kulefe! ");
INSERT INTO lip_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Bubu feebu fǝ fǝ lɛmɔ fanso Boanto Abraham wǝ díkpǝ, fɛɛ? Onanto eto bǝnyɛlǝkǝtidi tsya ǝkpǝ! Owoe eto okle feebu fǝ wǝ feni?” ");
INSERT INTO lip_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Mfó nya Yesu dítǝ mbuayɛ nkǝ, “Lǝ mɔ ǝsuǝ maatɛsɛɛ, nyalɛ mɔ atɛsǝ nyamǝ manle kulesa. Fɛɛ nwǝ laatɛsǝ mɛɛ, wǝ ni mɔ Anto. Wǝ ni nwǝ bíatɛyi biǝ wǝ ni mi Onanto nɛ. ");
INSERT INTO lip_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Mii, binyi wǝ. Fɛ mɔɔ, nyi wǝ. Lǝ ntɛyi miǝ minnyi wǝǝ, nyalɛ moofiani odia fe mi ke, fɛɛ nyi wǝ, nya meetsyue wǝ ditiki koto. ");
INSERT INTO lip_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Mi anto Abraham ǝnyǝ disuǝyuǝ se ɔ́nɔ mɔ bubǝ eto asa. Nyaso úfi ǝnǝmi útǝkǝ lǝ mɔ bubǝ ǝsuǝ nya únyǝ disuǝyuǝ.” ");
INSERT INTO lip_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Yudafɔ bamǝ átɛyi wǝ bǝnkǝ, “Ámamfo tɔ alɛ fosi anɔ kulaa tsya, nya bɔtɛyi fanlɛ bɔtɛyi fǝ eyi Abraham?” ");
INSERT INTO lip_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Mfó Yesu lɛtɛyi mǝ nkǝ, “Nlɛ mi bɔtɛyi sitinti miǝ, mɔɔ, mfe nkpe koko fɛ bále Abraham.” ");
INSERT INTO lip_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ete básɛ abambi bǝ baato wǝ, fɛɛ Yesu ákula ǝsuǝ nya ɔ́bɔ údu lǝ Kedikǝtǝkɔ mfó. ");
INSERT INTO lip_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Se Yesu díbǝ ófe ɔntɔɔ, únyǝ utidi utsyuǝ wǝ bále unǝmba. ");
INSERT INTO lip_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Wǝ bakasebi átɔ wǝ bǝnkǝ, “Oteasa, owoe eto lebua dítǝ bále osani ǝmfo unǝmba? Wǝ kosate eso lee wǝ antomǝ eto abua eso?” ");
INSERT INTO lip_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Mfó Yesu dítǝ mǝ mbuayɛ nkǝ, “Inni nwǝ mfo nye wǝ antomǝ díyifo lebua eso. Bomu bále wǝ nko bǝ lǝ ɛyɛ lǝ wǝ ǝsuǝ lǝ Onanto lǝ ulǝkǝ wǝ keyifo eto ǝsuǝale ote betidi. ");
INSERT INTO lip_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Se bonkpe lǝ kalesiǝsiǝ ǝsuǝ esoo, ele bǝ buyifo keyifo butǝ nwǝ létsyese mɛ. Kale ǝǝbǝ bolo nya kuutsyuǝ saa lensiembofo keyifo buyifo. ");
INSERT INTO lip_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Lefenǝ eto lefe minsi minkpe lǝ kawunsiǝǝ, mɔ ni kawunsiǝ eto diyǝnde.” ");
INSERT INTO lip_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Se Yesu lɛtɛyi nko ólosǝǝ, ókpo ntufǝ lǝ kasɔ, ɔ́wɔ site úfi se údikiti wǝ lǝ ǝnǝmi, ");
INSERT INTO lip_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","nya ɔ́tɛyi wǝ nkǝ, “Su lǝ esu ǝflǝ ntu lǝ Siloa eto Ditubiǝ ǝsuǝ.” Siloa eto kasɔ ni nkǝ Bákpe wǝ. Nyaso osani ǝmǝ ésu úflǝ ntu bomǝ. Nya wǝ ǝnǝmi lɛsini ɔnlɛ asa bunyǝ, nya úsinkli úbǝ oto. ");
INSERT INTO lip_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Wonko mba nkpe lǝ koyotsya ku betidi ba kenke díkǝnyǝ wǝ ɔnlɛ asa bɔtɔɔ, átɔ bǝnkǝ, “Inni osani ǝmfo ni nwǝ díkǝsiǝ lǝ mfó úkatɔ asa?” ");
INSERT INTO lip_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Bǝtsyuǝ átɛyi bǝ wǝ uni. Fɛɛ babamba átɛyi bǝnkǝ, “Owo lo, inni wǝ uni. Bole ete ole wǝ.” Mfó nya utidi ǝmǝ kosate lɛtɛyi nkǝ, “Mɔ uni!” ");
INSERT INTO lip_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Bátɔ wǝ bǝnkǝ, “Ntsyǝ ibǝ fɛ fanlɛ asa bunyǝ?” ");
INSERT INTO lip_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Útǝ mbuayɛ nkǝ, “Utidi wǝ baakpo Yesu lɛwɔ sitǝ udikiti mɛ lǝ ǝnǝmi nya ɔ́tɛyi mɛ nkǝ nsu mflǝ ǝnǝmi lǝ Siloa eto ditubiǝ. Nyaso nsu, nya se mímflǝ ǝnǝmi mínlosǝ ete míntsyiko asa bunyǝ.” ");
INSERT INTO lip_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Bátɔ wǝ bǝ, “Sieti onkpe?” Útǝ mǝ mbuayɛ nkǝ, “Mante kaka onkpe.” ");
INSERT INTO lip_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Bákpa nwǝ eto ǝnǝmi léba kɔ ǝmǝǝ, bésuko Farisifɔ bamǝ ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Diyi nǝ Yesu lɛnwɔ sitǝ údikiti lǝ unǝmba ǝmǝ eto ǝnǝmi fɛ ótsya wǝǝ, éyifo Ɔnwɛditsyǝyi. ");
INSERT INTO lip_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Nya Farisifɔ bamǝ tsya lɛtɔ osani ǝmǝ kase íyifo fɛ útsyiko asa bunyǝ. Ɔ́tɛyi mǝ nkǝ, “Sitǝ ɔ́nwɔ úfi údikiti mɛ lǝ ǝnǝmi. Nya mímflǝ mɔ ǝnǝmi ete míntsyiko asa bunyǝ.” ");
INSERT INTO lip_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Mfó nya Farisifɔ bamǝ eto bǝtsyuǝ lɛtɛyi wǝ bǝnkǝ, “Utidi wǝ díyifo nyamfo embofo Onanto ɔflɔ butsyi! Itsyise weenyifo lǝ Ɔnwɛditsyǝyi eto kɔfi ǝsuǝ.” Fɛɛ mǝ bǝtsyuǝ bamba átɛyi bǝnkǝ, “Ntsyǝ yoofo bubǝ bǝ obuayifo ebofo ayanisa nyamfo eto okle buyifo kate?” Itǝ kǝsǝnsǝ édufǝ mǝ lenti. ");
INSERT INTO lip_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Nyaso Farisifɔ bamǝ esi bátɔ osani ǝmǝ bǝnkǝ, “Se fanlɛ bɔtɛyi fǝnkǝ wǝ lɛsini fǝ ǝnǝmii, be ni fǝ nsusu itsyi lǝ wǝ ǝsuǝ?” Mfó nya osani ǝmǝ dítǝ mbuayɛ nkǝ, “Onanto eto Unyɛlǝkǝtidi uni.” ");
INSERT INTO lip_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Yudafɔ bamǝ mámfo bánɔ sitinti bǝ osani ǝmǝ ába ǝnǝmi fɛ usi útsyiko asa bunyǝ isu ese lefe nǝ bákpadi wǝ anto mǝ díbǝ. ");
INSERT INTO lip_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Bátɔ mǝ bǝ, “Mi ubisaibi ni nwǝ mfo? Biǝ béle wǝ unǝmba, nya ntsyǝ iyifo fɛ omfe ɔnlɛ asa bunyǝ mɔmɔ?” ");
INSERT INTO lip_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Wǝ anto mǝ ǝtǝ mbuayɛ bǝnkǝ, “Buyi boǝ bo ubi uni. Nya bunyi tsya boǝ bole wǝ unǝmba. ");
INSERT INTO lip_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Fɛɛ bunyi kase íyifo fɛ omfe ɔnlɛ asa bunyǝ. Nya bunyi futsyǝ tsya létsya wǝ ǝnǝmi nyamǝ. Bɛtɔ wǝ kosate lǝ ɔtɛyi mi itsyise wóobe!” ");
INSERT INTO lip_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Wǝ antomǝ átɛyi nyamfo nko itsyise balɛ Yudafɔ sikpi bote, itsyise Yudafɔ átɛyi bǝtsyǝ bǝ utsyǝǝ ke lɛtɛyi nkǝ ófo Yesu ɔ́nɔ fe Nwǝ Onanto Lékpo Ɔhile Utsyǝǝ, boolǝkǝ wǝ betsyiko lǝ mǝ katsyakɔ. ");
INSERT INTO lip_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Nyamfo eso wǝ antomǝ lɛtɛyi bǝnkǝ, “Wóobe, bɛtɔ wǝ kosate nɛ!” ");
INSERT INTO lip_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Bákpadi nwǝ bále unǝmba ǝmǝ dinuǝfǝ nya bátɛyi wǝ bǝnkǝ, “Te Onanto sikpi lǝ atɛyi bo sitinti! Buyi boǝ utidi wǝ létsya fɛ mfó eyifo obuayifo!” ");
INSERT INTO lip_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Osani ǝmǝ ǝtǝ mǝ mbuayɛ nkǝ, “Mɔɔ, minnyi lǝ obuayifo ni osani ǝmfo lee unni. Lesa lɔni minyi mɔɔtɛyi ni bǝnkǝ, kɔɔ mba ǝnǝmi. Fɛɛ mɔmɔɔ, mfe nlɛ bunyǝ!” ");
INSERT INTO lip_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Bátɔ wǝ bǝnkǝ, “Be úyifo fǝ nya ntsyǝ ɔ́yɛ ótsya fǝ ǝnǝmi nyamǝ?” ");
INSERT INTO lip_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Útǝ mbuayɛ nkǝ, “Mboka mi bɔtɛyi éfe, fɛɛ bianla biǝ biafo nnya. Beso bela biǝ bisi bianɔ nnya? Lee, bela biǝ miitsya afiani wǝ bakasebii?” ");
INSERT INTO lip_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Báka wǝ bátɛyi bǝnkǝ, “Fǝ ete ni wǝ okasebi. Boo, Moses eto bakasebi buni. ");
INSERT INTO lip_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Buyi boǝ Onanto édiko Moses etiki. Nya nwǝ mfo alɛɛ, boante kaka utsyi kulaa tsya!” ");
INSERT INTO lip_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Mfó nya osani ǝmǝ lɛtɛyi mǝ nkǝ, “Nte ditiki nǝ eto okle ni nǝmfo? Binyi kaka utsyi, fɛɛ wǝ lɛsini mɛ ǝnǝmi nɛ! ");
INSERT INTO lip_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Buyi boǝ Onanto eentsyue babuayifo koto, fɛɛ lǝ utsyuǝ eesumu Onanto, nya weeyifo wǝ lelabii, weetsyue wǝ koto kanɔ wǝ olatoto. ");
INSERT INTO lip_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Idu taa kawunsiǝ eto kasɔ ketsyikokɔɔ, bóannɔ tɔ bǝ kuutsyuǝ saa wǝ átsya nwǝ bále unǝmba. ");
INSERT INTO lip_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Lenni Onanto ɔflɔ utsyii, eni wǝmbofo kulesa buyifo.” ");
INSERT INTO lip_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Batɛyi wǝ bǝnkǝ, “Fǝǝ bále ku lebua fábe ku nii! Nya fǝ bomu lela fǝ aate bo asaa?” Nyaso bála wǝ, bábɔnko lǝ Yudafɔ eto katsyakɔ kamǝ. ");
INSERT INTO lip_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu ánɔ nkǝ bála wǝ nyaso se únyǝ osani ǝmǝǝ, ɔ́tɔ wǝ nkǝ, “Áfo Utidi Eto Ubi ánɔ?” ");
INSERT INTO lip_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Osani ǝmǝ ǝtǝ wǝ mbuayɛ nkǝ, “Nto, te mɛ futsyǝ uni, bǝ lǝ mfo wǝ nnɔ.” ");
INSERT INTO lip_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Mfó nya Yesu lɛtɛyi wǝ nkǝ, “Ébunyǝ utidi ǝmǝ koko, nnyǝ wǝ ni nwǝ nlɛ fǝ etiki budinko mfo mɔmɔ nɛ.” ");
INSERT INTO lip_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Osani ǝmǝ átɛyi nkǝ, “Bonamute, mfo nnɔɔ!” Nya óse akonki lǝ Yesu eto ǝnǝmi úsumu wǝ. ");
INSERT INTO lip_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesu átɛyi nkǝ, “Mbǝ kawunsiǝ kamfo bǝ lǝ nkponko betidi lekpo, bǝ lǝ bǝnǝmba lǝ bǝnyǝ asa, nya mba lǝǝnyǝǝ, lǝ bafiani bǝnǝmba.” ");
INSERT INTO lip_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Farisifɔ ba díńyǝ mfo lɛnɔ nnya Yesu lɛtɛyii, átɔ wǝ nkǝ, “Nyalɛ bɔtɛyi fanlɛ fǝ bo tsya ába ǝnǝmi lee?” ");
INSERT INTO lip_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesu ǝtǝ mǝ mbuayɛ nkǝ, “Lǝ boba mi ǝnǝmi lebaa, eni biebudi dikpi, fɛɛ se biǝ bɛlɛ bunyǝ esoo, mi abua tǝkǝ mi lǝ ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesu átɛyi mǝ nkǝ, “Nlɛ mi bɔtɛyi sitinti miǝ, utsyuǝ saa ke dímanyɛ lǝ lesamuyo eto kesie údufǝ lesamuyo nǝmǝǝ, bomu ɔ́yɛ kusu bamba saa údufǝ lǝ ni kafoo, eyifo uyu ku nwǝ laabiasǝ asa. ");
INSERT INTO lip_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Nyaa, nwǝ ke laayɛ lǝ kesie kedufǝ lesamuyo nǝmǝ kafoo, wǝ ni nwǝ laayɛnko basamu tinti nɛ. ");
INSERT INTO lip_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Nya nwǝ laase lesamuyo eto kesie aasini kesie eto siku kǝtǝ wǝ. Woakpadi basamu bamǝ lǝ mǝ aye nya baanɔ wǝ ɔkɔɛ nya woakpa mǝ kabɔnko. ");
INSERT INTO lip_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Lǝ okpadi mǝ nya ɔyɛnko mǝ ɔbɔnkoo, woatɔ mǝ sɛtɔ kayɛnko mǝ nya bǝǝtǝkǝko wǝ kama itsyise beeyi wǝ ɔkɔɛ. ");
INSERT INTO lip_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Bǝmbutǝkǝko kuutsyuǝ bamba kama. Bomu bootsyetsyi bedu itsyise benyi wǝ ɔkɔɛ.” ");
INSERT INTO lip_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu átɛyi mǝ lekpa nǝmfo, fɛɛ bánnɔ nnya ɔ́tɛyi mǝ eto kasɔ. ");
INSERT INTO lip_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Lǝ nyamfo esoo, Yesu esi ɔ́tɛyi mǝ nkǝ, “Lǝ sitintii, mɔ ni kesie itǝ basamu bamǝ. ");
INSERT INTO lip_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Betidi ba kenke lɛtɔ mɛ sɛtɔ bǝbǝǝ, beyifo beyu ku mba laabiasǝ asa. Fɛɛ basamu bamǝ méntsyue mǝ koto. ");
INSERT INTO lip_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Mɔ ni kesie kamǝ. Lǝ utsyuǝ ayɛ lǝ mɛ udufǝ lǝ kafoo, wuunyǝ bofo. Wuudufǝ lǝ mfó ukabɔ, nya wuunyǝ didisa sɛɛ ukedi. ");
INSERT INTO lip_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Uyuu, bubǝ ete woǝbǝ nkǝ lǝ uyu, olo utidi, obiasǝ asa. Mɔɔ, mbǝ miǝ lǝ binyǝ nkpǝ, nkpǝ bo lɛflɔ. ");
INSERT INTO lip_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Mɔ ni utinti wǝ laayɛnko basamu, nwǝ lɛtɔnɔ nkǝ weefi wǝ nkpǝ utǝ lǝ wǝ basamu eto disi. ");
INSERT INTO lip_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Utidi wǝ laayɛnko basamu wǝ baafo diyi eto kayo nya benni wǝ kosate eto balee, weetsyetsyi kedu lǝ unyǝ ukiti nlɛ bubǝ. Ukiti ǝmǝ eedufǝ mǝ lenti kǝmuǝ mǝ nya wǝǝsensǝ mǝ. ");
INSERT INTO lip_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Utidi ǝmfo eetsyetsyi kedu itsyise diyi eto uyifoyifo ete uni. Nya basamu bamǝ eto bɔflɔ nye mǝ kasɛɛ aanka wǝ. ");
INSERT INTO lip_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Mɔ ni utinti wǝ laayɛnko basamu. Fe kase Anto ǝmǝ nyi mɛɛ, nya mintsya nyi wǝǝ, nko ke mintsya nyi mɔ basamu, nya mǝǝtsya nyi mɛ nɛ. Nya míntɔnɔ miǝ mǝǝkpǝ lǝ mǝ disi. ");
INSERT INTO lip_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Nkpe basamu bamba ba lǝmbǝ lǝ lesamuyo nǝmfo tɔ. Ele bǝ nyɛnko mǝ tsya mboko, nya mǝ tsya lǝ banɔ mɔ ɔkɔɛ. Nya mǝmblɛ loofíani basamu eto ditsyukpa lɔni lǝ ɔyɛnkoyɛnko ɔni eto kalɔ. ");
INSERT INTO lip_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Anto ǝmǝ aala mɛ, itsyise ntɔnɔ miǝ mǝǝkpǝ lǝ mǝ disi, bǝ lǝ nsinkli mbǝ nsiǝ nkpǝ bio. ");
INSERT INTO lip_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Kuutsyuǝ saa embofo mɔ nkpǝ bofo lǝ mɔ ani, bomu mɔ kosate dífi mu míntǝ miǝ mǝǝkpe. Nkpe ǝsuǝale bǝ moofo mu bufi kǝtǝ. Nya ǝsuǝale si ekpe mɛ bǝ nsinkli mfo mu. Nko ǝmǝ mɔ Anto dítǝ mɛ nkǝ nyifo nɛ.” ");
INSERT INTO lip_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Lǝ etiki nnya Yesu lɛtɛyi mfo esoo, kabakǝfǝ esi kédufǝ lǝ Yudafɔ bamǝ nti. ");
INSERT INTO lip_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Mǝ nti eto bǝtsyuǝ kpǝ átɛyi bǝnkǝ, “Lɛwɔnɔ bua tǝkǝko wǝ. Ɔlɛ kumunǝ bukpǝ! Beso ele bǝ besi betsyue wǝ koto fɛ?” ");
INSERT INTO lip_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Fɛɛ babamba tsya átɛyi bǝnkǝ, “Utidi wǝ ǝsuǝ lɛwɔnɔ bua nkpee, embofo etiki nyamfo eto okle bɔtɛyi! Ntsyǝ lɛwɔnɔ bua luuyifo unǝmba si unyǝ asa fɛ?” ");
INSERT INTO lip_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Lɛyɔlefee, nya beedi Yudafɔ eto Disumuyo Bufikakpe lǝ Onanto kɔni eto Diyi lǝ Yerusalem. ");
INSERT INTO lip_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesu ákayɛ kafe lǝ Disumuyo eto lekpake nǝ baakpo Solomo eto Ablanase mfó. ");
INSERT INTO lip_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Mfó nya Yudafɔ bamǝ létsyilama wǝ, nya bátɔ wǝ bǝnkǝ, “Isu ese dimamfe lefe kon fookpe bo lǝ ketuntu ǝsuǝ esu ase? Tɛyi bo sitinti siamǝ, lǝ fǝ ni Utidi ǝmǝ Bákpo Ɔhile Bǝtsyǝ.” ");
INSERT INTO lip_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesu ǝtǝ mǝ mbuayɛ nkǝ, “Mbɔtɛyi mi nyamfo koko, tsya biamfo mɛ akanɔ. Asa nnya meeyifo lǝ mɔ Anto eto ǝsuǝale ǝsuǝǝ, lɛ mɛ bulǝkǝ kate. ");
INSERT INTO lip_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Fɛɛ biǝmbofo mɛ bɛnɔ, itsyise bientsyi mɔ basamu bamǝ nti. ");
INSERT INTO lip_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Mɔ basamu eetsyue mɛ koto. Nyi mǝ, nya bǝǝtǝkǝko mɛ. ");
INSERT INTO lip_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ntǝ mǝ nkpǝ manlo, nya bemuukpǝ kulefe. Nya kuutsyuǝ saa embofo mǝ lǝ ǝsuǝale ǝsuǝ lǝ mɔ kɔni. ");
INSERT INTO lip_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Mɔ Anto wǝ dífi mǝ útǝ mɛɛ, kpe ale oso lesa saa. Kuutsyuǝ saa embofo mǝ bofo lǝ ǝsuǝale ǝsuǝ lǝ mɔ Anto eto kɔni kulefe kulefe. ");
INSERT INTO lip_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Anto ǝmǝ ku mɔɔ, eyifo bani.” ");
INSERT INTO lip_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Mfó nya Yudafɔ bamǝ dísi básɛ aba bǝ bato wǝ. ");
INSERT INTO lip_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yesu átɛyi mǝ nkǝ, “Nyifo nnyifo sɛɛ kpǝ bo mɔ Anto lékpe mɛ lǝ mi nti. Nya nte nnya eso bela biǝ biakpɔ mɛ aba?” ");
INSERT INTO lip_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Yudafɔ bamǝ ǝtǝ wǝ mbuayɛ bǝnkǝ, “Inni nnyifo sɛɛ bo féyifo eso boǝ boakpɔ fǝ aba. Bomu mbusiotiki nnya fédi eso! Utidinini ete feni, fɛɛ éfi fǝ ǝsuǝ éyifo fe Onanto!” ");
INSERT INTO lip_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Mfó nya Yesu dítǝ mbuayɛ nkǝ, “Báwɔni bákpe lǝ mi kosate eto Kɔfi eto Kukue bǝ Onanto átɛyi nkǝ, ‘Beyifo fe bananto.’ ");
INSERT INTO lip_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Buyi boǝ lesa nǝ báwɔni bákpe lǝ Awɔnisa Kɛnkɛ eto Kukue, eyifo sitinti itǝ lefe saa. Nya mfó Onanto lékpadi betidi ba léfo wǝ Ditiki Sɛɛ nǝmǝ nkǝ, ‘Beyifo fe bananto.’ ");
INSERT INTO lip_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Fɛɛ mɔɔ, Anto ǝmǝ dílǝkǝ mɛ nya ótsyese mɛ kawunsiǝ nɛ. Nya ntsyǝ eso fɛ biɔtɛyi biǝ ndi mbusiotiki lǝ nnya míntɛyi miǝ nyifo Onanto eto Ubi? ");
INSERT INTO lip_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Lǝ minlɛ mɔ Anto eto nnyifo buyifoo, nyalɛ biamfo mɛ bɛnɔ. ");
INSERT INTO lip_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Fɛɛ lǝ nlɛ mu buyifoo, lǝ biamfo mɛ bɛnɔ tsyaa, ele bǝ befo asa nnya meeyifo bɛnɔ, bǝ lǝ bete lǝ bɛnɔ nnya kasɔ biǝ Anto ǝmǝ si lǝ mɛ, nya mintsya nsi nkpǝ lǝ wǝ.” ");
INSERT INTO lip_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Mfó tsyaa, besi bála bǝ bǝǝmuǝ Yesu, fɛɛ usi ɔ́bɔ lǝ mǝ nti údu. ");
INSERT INTO lip_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yesu esi úsu ɔ́yila Ketu Yordan úsu kaka Yohanes díyifo betidi ntuflǝsǝflǝsǝ eto lekpa tutɛ, nya ɔ́tsyimɛ mfó. ");
INSERT INTO lip_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Betidi kpǝ ǝbǝ wǝ ɔflɔ nya bátɛyi bǝnkǝ, “Yohanes ményifo ayanisa saa óte. Fɛɛ lesa saa nǝ ɔ́tɛyi itsyi lǝ utidi ǝmfo ǝsuǝ eyifo sitinti.” ");
INSERT INTO lip_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Nya betidi kpǝ lǝ mfó léfo wǝ bánɔ. ");
INSERT INTO lip_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Osani utsyuǝ baakpo Lazaro wǝ dísiǝ lǝ umǝ wǝ baakpo Betania ánɔ bufi. Wǝ ku wǝ bayimisio inuǝ ba baakpo Maria ku Marta dísiǝ lǝ umǝ ǝmǝ. ");
INSERT INTO lip_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maria ǝmfo ni nwǝ dífi nnuǝbi bo laanyi fififi ókpo Bonamute Yesu lǝ akpa nya úfi wǝ disi eto sɛwɔni ɔ́si wǝ akpa nyamǝ. Wǝ ɔyimisani ni Lazaro wǝ lɛnɔ bufi bɔnlɛ bɔtɛyi mfo nɛ. ");
INSERT INTO lip_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Wǝ bayimisio bamfo átsyese Yesu kɛnyɛ bǝ, “Bonamute, fǝ ɔyɛtsyuǝ lala ánɔ bufi!” ");
INSERT INTO lip_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Se Yesu léfo kɛnyɛ kamfoo, ɔ́tɛyi nkǝ, “Bufi bomfo enni bukpǝmfi itǝ wǝ, bomu iyifo nnya ǝsuǝ buufi babesǝ Onanto eto diye kato, nya ɛyɛ lǝ nnya ǝsuǝ babesǝ Onanto eto Ubi tsya kato.” ");
INSERT INTO lip_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Nyaa, Yesu ála Marta ku wǝ ɔyimisio ku Lazaro eto asa tinti. ");
INSERT INTO lip_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Fɛɛ se ɔ́nɔ nkǝ ɔ́nɔ bufii, usi ɔ́kɛ mfó eyi ǝnuǝ okpe. ");
INSERT INTO lip_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Nyamfo eto kamaa, ɔ́tɛyi wǝ bakasebi nkǝ, “Bitǝ lǝ businkli busu Yudea.” ");
INSERT INTO lip_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Mfó nya wǝ bakasebi lɛtɛyɛ wǝ nkǝ, “Oteasa, kayinkǝnǝ ete Yudafɔ díkabɛbɛ kusu bǝ baakpɔ fǝ aba, nya fanlɛ bɔtɛyi fǝnkǝ busi boesu mfó?” ");
INSERT INTO lip_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesu ǝtǝ mǝ mbuayɛ nkǝ, “Inni lefosi abombosɔsɔ ǝnuǝ nkpe lǝ diyi eto kalekpakpa ǝsuǝ? Lǝ utsyuǝ lɛ bɔyɛ lǝ kalekpakpa ǝsuǝǝ, weentusǝ itsyise ɔlɛ kawunsiǝ kamfo eto lekpasǝ bunyǝ. ");
INSERT INTO lip_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Fɛɛ lǝ ketsye ɔnlɛ bɔyɛɛ, wuutusǝ itsyise lekpasǝ ǝmbǝ itǝ wǝ.” ");
INSERT INTO lip_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Se Yesu lɛtɛyi nyamfo ólosǝǝ, usi ɔ́tɛyi úkǝ nkǝ, “Bo ɔyɛtsyuǝ Lazaro lɛ selabe, nyaso ntɔ wǝ kasanklisǝ kɔ.” ");
INSERT INTO lip_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Se bakasebi bamǝ lɛnɔ nkoo, bátɛyi wǝ bǝnkǝ, “Bonamute, lǝ selabe onlabee, nyalɛ yuuyuǝ wǝ.” ");
INSERT INTO lip_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Fɛɛ Yesu wǝ lɛ bɔtɛyi nkǝ Lazaro ébukpǝ, fɛɛ wǝ bakasebi ébu bǝnkǝ selabe tinti ɔ́tɛyi utsyiko. ");
INSERT INTO lip_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Nyaso Yesu ákpasǝ mǝ ɔ́tɛyi nkǝ, “Lazaro ǝkpǝ. ");
INSERT INTO lip_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Fɛɛ lǝ mi esoo, ɛlɛkɛ itǝ bǝ mánkɛ lǝ mfó fɛ úkpǝ, bǝ lǝ befo bɛnɔ esoo. Nyaso bítǝ lǝ busu wǝ ɔflɔ mfó.” ");
INSERT INTO lip_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Mfó nya Toma wǝ baakpo Ɔfimfinyǝ lɛtɛyi wǝ bakaseyimitsyuǝ bamǝ nkǝ, “Bitǝ lǝ bo tsya lǝ butǝkǝko Oteasa busu bǝ lǝ busu bukpǝ ku wǝ!” ");
INSERT INTO lip_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Lefe nǝ Yesu dísu údufǝ mfoo, ɔ́nɔ nkǝ bébikǝ Lazaro diyi nale ni diyi nǝmfó nɛ. ");
INSERT INTO lip_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Idu lǝ Betania isu Yerusalem eyifo fe esunkpo ǝnuǝ seka. ");
INSERT INTO lip_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Nyaso Yudafɔ kpǝ ǝbǝ mfó bǝ bǝǝbǝ bamansǝ Maria ku Marta lɛkɔ se mǝ ɔyimisani díkpǝ eso. ");
INSERT INTO lip_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Se Marta lɛnɔ nkǝ Yesu lɛ bubǝǝ, úsu nkǝ weesu otsyako wǝ, fɛɛ Maria ebu ɔkɛ lǝ diyo. ");
INSERT INTO lip_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta átɛyi Yesu nkǝ, “Bonamute, lǝ nnya ete fakɛ mfoo, eni mɔ ɔyimisani mǝnkpǝ! ");
INSERT INTO lip_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Fɛɛ nnyi miǝ mɔmɔ kulaa tsyaa, lesa saa nǝ fɔɔtɔ Onantoo, wuutǝ fǝ ni.” ");
INSERT INTO lip_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Mfó Yesu lɛtɛyi wǝ nkǝ, “Fǝ ɔyimisani ebotaka ubǝ nkpǝ.” ");
INSERT INTO lip_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Nya Marta lɛtɛyi wǝ nkǝ, “Nyi miǝ wootaka ubǝ nkpǝ lǝ lefe nǝ bǝkpǝnkpǝ lootaka lǝ Diyi Fɛfɛ ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Mfó Yesu lɛtɛyi wǝ nkǝ, “Mɔ ni nwǝ lǝǝtǝ bǝkpǝkpǝ eto botaka kǝńyǝ ku businkli kǝbǝ bǝsiǝ lǝ nkpǝ nɛ. Utsyuǝ saa ke léfo mɛ ɔ́nɔɔ, lǝ úkpǝ kulaa tsyaa, wuusiǝ nkpǝ. ");
INSERT INTO lip_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Nya utsyuǝ saa ke nsi nkpǝ nya ófo mɛ ɔ́nnɔ, embukpǝ kulefe. Afo nyamfo anɔ?” ");
INSERT INTO lip_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Útǝ mbuayɛ nkǝ, “Ee, Bonamute. Mfo nnɔ miǝ fǝ ni Nwǝ Onanto Lékpo Ɔhile Utsyǝ, Onanto eto Ubi nwǝ bátɛyi bǝtsyǝ bǝ wuubǝ kawunsiǝ.” ");
INSERT INTO lip_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Se Marta lɛtɛyi nyamfo ólosǝǝ, úsu ókpadi wǝ ɔyimisio Maria, nya ɔ́tɛyi wǝ buɛɛ nkǝ, “Oteasa ǝmǝ ebubǝ nya ɔnlɛ fǝ disi bɔtɔ.” ");
INSERT INTO lip_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Se Maria lɛnɔ nkoo, ótaka mlǝ nya úsu wǝ katsyakokɔ. ");
INSERT INTO lip_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Lefe nǝmfoo, Yesu méndufǝ tɔ umǝ kafo. Bomu usi úńyǝ lǝ kaka Marta díbǝ otsyako wǝ mfó. ");
INSERT INTO lip_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Se Yudafɔ ba nsi lǝ diyo lǝ Maria ɔflɔ banlɛ wǝ lɛkɔ bomansǝ dínyǝ bǝ ótaka kplaa, mǝ tsya átaka bǝtǝkǝko Maria kama. Bébu bǝ kudi komǝ eti ɔntɔ lǝ usi usu uwi keku. ");
INSERT INTO lip_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Se Maria dísu údufǝ kaka Yesu ńyǝǝ, óse akonki lǝ wǝ akɔ nya ɔ́tɛyi wǝ nkǝ, “Bonamute, lǝ nnya ete fákɛ mfoo, eni mɔ ɔyimisani mǝnkpǝ!” ");
INSERT INTO lip_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesu ǝnyǝ kase Maria ku betidi ba dítǝkǝko wǝ nlɛ nku. Ílǝ wǝ lǝ utu nya óla ɔ́wɔnɔ hũũ. ");
INSERT INTO lip_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ɔ́tɔ mǝ nkǝ, “Sieti bíbikǝ wǝ?” Bǝtǝ mbuayɛ bǝnkǝ, “Bonamute, bǝ lǝ ǝbǝ abe.” ");
INSERT INTO lip_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Mfóo, Yesu éwi keku. ");
INSERT INTO lip_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Nya Yudafɔ bamǝ lɛtɛyi bǝnkǝ, “Bebe kase ko óla wǝǝ!” ");
INSERT INTO lip_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Fɛɛ mǝ bǝtsyuǝ átɛyi bǝnkǝ, “Ɔ́sini unemba ǝnǝmi nya ɔnlɛ asa bunyǝ. Beso wǝntǝ lǝ Lazaro lǝ ɔyɛ bukpǝ?” ");
INSERT INTO lip_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Isi ílǝ Yesu tinti, nya ɔ́nyi úsu kudi komǝ ɔflɔ. Kudi komǝ eyifo dibiǝ lǝ koba kafo nya béfi leba béti ko kɛnyɛ. ");
INSERT INTO lip_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesu átɛyi mǝ nkǝ, “Bɛnyi leba nǝmǝ lǝ kudi komǝ eto kɛnyɛ.” Mfó nya Lazaro ǝmǝ eto ɔyimisio Marta lɛtɛyi Yesu nkǝ, “Bonamute, wuukanyi mɔmɔ, itsyise mmi ni diyi nale se bébikǝ wǝ nɛ!” ");
INSERT INTO lip_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesu átɛyi wǝ nkǝ, “Mántɛyi fǝ minkǝ lǝ áfo mɛ ánɔɔ, ebunyǝ Onanto eto diyǝnde?” ");
INSERT INTO lip_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Nyaso bányi leba nǝmǝ lǝ kudi komǝ eto kɛnyɛ. Yesu ábesǝ ǝnǝmi kato óbe nya ɔ́tɛyi nkǝ, “Nto, maasɔ fǝ ani, itsyise eetsyue mɛ koto lǝ nkpadi fǝ. ");
INSERT INTO lip_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nyi miǝ eetsyue mɛ koto lefe saa. Fɛɛ mba ńyǝ mfo eso minlɛ nyamfo bɔtɛyi nko, bǝ lǝ bafo banɔ bǝ fǝ lékpe mɛ kɔtɔ.” ");
INSERT INTO lip_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Se ɔ́tɛyi nyamfo nkoo, ófa bembembe nkǝ, “Lazaro, bɔ ǝbǝ!” ");
INSERT INTO lip_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Nya ukpǝnkpǝ ǝmǝ lɛbɔ úbǝ ku kafia ka béfi bémini wǝ ǝsuǝ ku nka béfi bémini wǝ ǝnǝmi. Nya Yesu lɛtɛyi mǝ nkǝ, “Beyankli we bikǝ biamǝ lǝ ǝsuǝ lǝ udu.” ");
INSERT INTO lip_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Lǝ nyamfo esoo, Yudafɔ ba díbǝ Maria ɔflɔ nya bǝnyǝ nnya Yesu díyifoo, eto bǝtsyuǝ kpǝ áfo wǝ bánɔ. ");
INSERT INTO lip_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Fɛɛ mǝ bǝtsyuǝ édu bésu Farisifɔ ɔflɔ nya bátɛyi mǝ lesa nǝ Yesu díyifo. ");
INSERT INTO lip_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Nyaso Farisifɔ ku besumunyǝ ninǝ ákpe disi ku Yudafɔ eto batɔnkotɔnko nya bátɔ bǝtsyuǝ bǝnkǝ, “Be ele bǝ buyifo? Bebe ayanisa kpǝ nnya osani ǝmfo nlɛ buyifo kate! ");
INSERT INTO lip_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Lǝ butǝ wǝ kusu ɔnlɛ nyamfo buyifo nkoo, utsyuǝ saa ebofo wǝ ɔnɔ. Nya Romafɔ luubǝ baba bo Disumuyo kɛnkɛ kamǝ ku kusǝ komǝ tsya!” ");
INSERT INTO lip_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Mfóo, mǝ nti eto nwǝ baakpo Kayafa, wǝ ni Usumunyǝ Ninǝ lɛlɛ nǝmfoo, lɛtɛyi mǝ nkǝ, “Ntsyǝ asakasɔnɔnɔ lǝǝlǝ mi mmǝ! ");
INSERT INTO lip_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Binyi tɔ biǝ ɛlɛkɛ bǝ utidi ɔni kpǝ lǝ kusǝ komǝ eto disi enso bǝ kusǝ komǝ kenke eto betidi tsylɔ lee?” ");
INSERT INTO lip_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Lǝ sitintii, wóantɛyi nyamfo ɛyɛ lǝ wǝ kosate eto nsusu ǝsuǝ. Bomu fe nwǝ ni Usumunyǝ Ninǝ itǝ lɛlɛ nǝmfo esoo, Onanto áyɛ lǝ wǝ ǝsuǝ útǝ nkǝ ɔtɛyi nyamfo, nnya ni katɛyikǝtsyǝ bǝ Yesu ebubǝ ukpǝ lǝ Yudafɔ kenke eto disi. ");
INSERT INTO lip_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Inni bǝnkǝ lǝ ukpǝ lǝ kusǝ komǝ eto disi mate ete. Bomu bǝ ɛyɛ lǝ nnya ǝsuǝǝ, lǝ ɔsɔ Onanto eto bebi ba kenke dísensǝ bankpo lǝ kawunsiǝ eto akpɔ akpɔ nnya kenke lebo, beyifo bani. ");
INSERT INTO lip_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Lǝ nyaso ídu dinǝmfo ǝsuǝ, Yudafɔ eto beninǝ bamǝ dítsyiko esu bɔbɛbɛ kase bomuǝ Yesu lǝ balo wǝ. ");
INSERT INTO lip_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Lǝ nyamfo esoo, Yesu ménsifo bɔyɛ kafe mmǝ lǝ Yudafɔ nti. Bomu údu úsu úsiǝ lǝ umǝbibi wǝ baakpo Efraim kaka lefi mfiminti. Mfó wonko wǝ bakasebi dísiǝ. ");
INSERT INTO lip_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Lefe nǝmfoo, Yudafɔ eto Ukpǝ Ása Bo Ɔ́yila eto Diyi didife éboyo elo. Nya betidi kpǝ dítsyi kasɔ kamǝ eto akpɔakpɔ bésu Yerusalem lǝ besu bǝmuǝ ǝsuǝ beyifo ǝsuǝflǝflǝ eto lekpa nǝmǝ fɛ lɛ diyididi nǝmǝ lǝ leyo. ");
INSERT INTO lip_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Se bǝńyǝ lǝ Disumuyo nǝmǝǝ, bákabɛbɛ Yesu nya bákatɔ bǝtsyuǝ bǝnkǝ, “Ntsyǝ bibu? Nyi miǝ wǝmbofo diyi nǝmǝ kedikɔ bubǝ, lee ntsyǝ ini?” ");
INSERT INTO lip_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Lefe nǝmfóo, besumunyǝ ninǝ ku Farisifɔ ébutǝ bote bǝ lǝ utsyuǝ yi kaka Yesu nkpee, lǝ ubǝ utǝ mǝ bote, lǝ besu bǝmuǝ wǝ. ");
INSERT INTO lip_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Se ibu eyi akua lǝ bedi Ukpǝ Ása Bo Ɔ́yila eto Diyii, Yesu ésu Betania, kaka Lazaro wǝ Yesu létakasǝ utsyiko ɔkɔmǝ ditsyi. ");
INSERT INTO lip_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Mfóo, banwa ditsyitsyosa bǝtǝ wǝ bǝ lǝ udi. Marta ni nwǝ lɛwunsǝko mǝ lǝ lesa nǝmǝ kedikɔ. Lazaro tsya akɛ lǝ mba ku Yesu dídi lesa nǝmǝ nti. ");
INSERT INTO lip_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mfó ǝmǝ nya Maria dífi nnuǝbi bo laanyi fififi béyifo betsyiko lǝ nnya baakpo naadi ǝsuǝ, nya bofo koya tinti eto dituntu kplɛ tɔ úsu ókpo Yesu lǝ akpa. Nya úfi wǝ disi eto sɛwɔni ɔ́si wǝ akpa. Bɔnyi fififi bomǝ éyi diyo nǝmǝ kenke. ");
INSERT INTO lip_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Nya Yesu eto okasebi ɔni wǝ ni Yuda Iskariot, nwǝ luubǝ udu Yesu utǝ lɛtɛyi nkǝ, ");
INSERT INTO lip_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Beso bánte nnuǝbi bomfo sika flubia alofa ǝtsyǝ befi atabi nyamǝ bǝtǝ bakombo?” ");
INSERT INTO lip_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Fɛɛ inni lǝ kase Yuda dífi kǝtsyuǝ lǝ bakombo eto asa eso ɔtɛyi nyamfo nko. Bomu uyu uni. Wǝ ɔflɔ atabi eto otobe dítsyǝ, nya úkeyu atabi nyamǝ eto ǝtsyuǝ kǝlǝkǝ kǝtǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yesu átɛyi nkǝ, “Beyani wǝ kpoo. Bitǝ lǝ uyifo lesa nǝ woofo buyifo kǝtsyǝ itǝ mɔ kǝbikǝ. ");
INSERT INTO lip_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Bakombo kpe lǝ mi ɔflɔ lefe saa. Fɛɛ mɔɔ, mǝmɔɔkɛ lǝ mi ɔflɔ lefe saa.” ");
INSERT INTO lip_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Se Yudafɔ kpǝ lɛnɔ bǝ Yesu kpe lǝ Betania, béti wǝ bésu mfó. Nya inni Yesu mate eso bésu mfó, bomu lǝ bǝnyǝ Lazaro wǝ Yesu létakasǝ utsyiko ɔkɔmǝ tsya. ");
INSERT INTO lip_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Lǝ nyaso besumunyǝ ninǝ átsya béfi nsusu bǝ boolo wuntsya. ");
INSERT INTO lip_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Itsyise ɛyɛ lǝ Lazaro ǝsuǝ esoo, Yudafɔ kpǝ lǝ kesumu bɔni kǝtǝnko Yesu kama. ");
INSERT INTO lip_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Se kale dísiǝ, betidi eto ditsyukpa kplɛ nǝ díbǝ Ukpǝ Ása Bo Ɔ́yila eto diyisɛɛ nǝmǝ kedikɔɔ, ánɔ bǝ Yesu lɛ Yerusalem bubǝ. ");
INSERT INTO lip_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Nyaso béfi katodi nya bésu bǝ baatsyako wǝ. Bákafa katɛyi bǝnkǝ, “Hosiana! Atɛsǝ itǝ Onanto! Bɛtɛsǝ nwǝ nlɛ bubǝ lǝ Bonamute eto diye ǝsuǝ! Atɛsǝ itǝ Israelfɔ eto Oka!” ");
INSERT INTO lip_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu ǝnyǝ ɔflimubi utsyuǝ nya úsiǝ lǝ wǝ fe kase báwɔni bákpe lǝ Awɔnisa Kɛnkɛ eto Kukue ǝsuǝ bǝnkǝ, ");
INSERT INTO lip_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Biante sikpi mi Sion eto umǝ eto betidi! Nyǝ fǝ Oka nsi lǝ ɔflimubi ǝsuǝ ɔnlɛ bubǝ!” ");
INSERT INTO lip_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Tutɛɛ, wǝ bakasebi mánnɔ nyamfo kasɔ. Fɛɛ lefe nǝ Onanto díkatakasǝ Yesu utsyi ɔkɔmǝ úbǝ ku dibuu, nya fɛ bákloma bǝ nnya báwɔni bákpe lǝ Awɔnisa Kɛnkɛ eto Kukue ǝsuǝ etsyi lǝ wǝ ǝsuǝ, nya nnya ni asa nyamfo kenke béyifo bǝtǝ wǝ nɛ. ");
INSERT INTO lip_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Betidi ba díńyǝ mfó fɛ Yesu lékpadi Lazaro útsyiko kudi kafo lǝ ɔkɔmǝ óboko nkpǝǝ, ésu bátɛyi lesa nǝ díbǝ mfó. ");
INSERT INTO lip_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Nyamfo esoo, betidi kpǝ ésu bátsyako wǝ, itsyise bánɔ ayanisa nnya úyifo óte eso. ");
INSERT INTO lip_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Mfó Farisifɔ bamǝ lɛtɛyi mǝ bǝtsyuǝ bǝnkǝ, “Bebe, kulesa anlɛ bɔlɛkɛ kǝtǝ bo! Binyǝ biǝ kawunsiǝ kenke édu bésu bǝtǝkǝko wǝ!” ");
INSERT INTO lip_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Grikifɔ bǝtsyuǝ tsya akɛ lǝ betidi ba dísu Disumuyo lǝ Yerusalem lǝ diyi nǝmǝ kedikɔ nti. ");
INSERT INTO lip_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Bésu Filipo wǝ dítsyi Betsaida lǝ Galilea ɔflɔ, nya bátɛyi wǝ bǝnkǝ, “Boanto, bola boǝ boǝnyǝ Yesu.” ");
INSERT INTO lip_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipo ésu ɔ́tɛyi Andrea nya mǝ inuǝ bamǝ dídu bésu bátɛyi Yesu. ");
INSERT INTO lip_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Mfó nya Yesu lɛtɛyi nkǝ, “Lefe nǝmǝ eboyo bǝ babesǝ Utidi Eto Ubi ǝmǝ eto diye kato. ");
INSERT INTO lip_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nlɛ mi bɔtɛyi sitinti miǝ lǝ banto lentabi nǝmǝ lǝ kasɔ dibuu, lentabi lɔɔni ete disi diudi. Fɛɛ lǝ dibuu, nya fɛ diɔnwɔ ebibi kpǝ nɛ. ");
INSERT INTO lip_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Utidi wǝ lela wǝ kosate eto nkpǝǝ, ebonyansǝ mu. Fɛɛ nwǝ dikisi wǝ kosate eto nkpǝ lǝ kawunsiǝ kamfoo, ebɔlɔ mu utsyǝ itǝ nkpǝ manlo. ");
INSERT INTO lip_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Utsyuǝ saa ke lela nkǝ weeyifo mɔ keyifoo, ele bǝ utǝkǝko mɛ, itǝ bǝ mɔ uyifoyofo ǝmǝ ebusiǝ lǝ kaka minsi. Nya utsyuǝ saa ke ni mɔ uyifoyifoo, mɔ Anto ebokpe wǝ dibu. ");
INSERT INTO lip_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Mɔmɔɔ, ɛlɛ mɛ bulǝ lǝ mɔ lɛkɔɛsi. Fɛɛ be ko ele bǝ ntɛyi? Bɔtɛyi ele bǝ ntɛyi minkǝ, ‘Nto, mǝntǝ lǝ kanyi kamfo eto okle lǝ kǝtǝkǝ mɛ lǝ ǝsuǝ lee’? Owo lo! Fɛɛ nyamfo eso mímbǝ kawunsiǝ, bǝ lǝ nnyǝ kanyi kamfo eto okle nɛ. ");
INSERT INTO lip_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Nyaso Nto, tǝ lǝ babesǝ fǝ diye kato!” Nya ɔkɔɛ lɛbɔ utsyi kato nlɛ bɔtɛyi nkǝ, “Mbóbesǝ ni kato koko. Nya nsi muuyifo nko.” ");
INSERT INTO lip_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Se betidi ba dińyǝ mfo lɛnɔ ɔkɔɛ ǝmǝǝ, mǝ bǝtsyuǝ átɛyi bǝnkǝ ɔsɔmi uni díkumi. Nya bǝtsyuǝ lɛtɛyi bǝnkǝ, “Onanto eto ɔtɔnkpe utsyuǝ ni lɛtɛyi wǝ lesaatsyuǝ.” ");
INSERT INTO lip_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Mfó Yesu lɛtɛyi mǝ nkǝ, “Inni mɔ eso ɔkɔɛ ǝmfó lɛbɔ, bomu mi eso. ");
INSERT INTO lip_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","“Mɔmɔ ni lefe nǝ Onanto lookponko kawunsiǝ kamfo eto betidi lekpo. Nya Onanto luutu kawunsiǝ kamfo eto ǝsuǝalenyǝ lǝ wǝ seka ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Fɛɛ lǝ betsyi mɛ lǝ kasɔ babesǝ katoo, muunǝ betidi kenke mboko mɔ ɔflɔ.” ");
INSERT INTO lip_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Lefe nǝ Yesu lɛtɛyi nyamfoo, óte ukpǝ wǝ eto okle wǝǝbǝ bukpǝ. ");
INSERT INTO lip_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Mfó nya sitiditu siamǝ lɛtɛyi nkǝ, “Bo kɔfi eto kukue lɛ bo bɔtɛyi nkǝ, Utidi Wǝ Bákpo Ɔhile Bǝtsyuǝ ebusiǝ nkpǝ isu manlo manlo. Nya ntsyǝ ibǝ fɛ fanlɛ bɔtɔyi fǝnkǝ boobesǝ Utidi Eto Ubi ǝmǝ kato? Owoe ni Utidi Eto Ubi ǝmǝ mfo?” ");
INSERT INTO lip_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yesu ǝtǝ mǝ mbuayɛ nkǝ, “Diyǝnde nǝmǝ si diɔkɛ lǝ mi nti itǝ lefe sɛkɛ ete. Se diyǝnde nǝmǝ nsi nkpe mi lenti esoo, bɛyɛ bɛtɔ, bǝ lǝ kale lǝ kayɛ mi bolo lǝ bidufǝ lǝ ketuntu ǝsuǝ. Itsyise nwǝ laayɛ lǝ ketuntuu, ante kaka ɔntɔ. ");
INSERT INTO lip_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Nyaso se lekpasǝ nkpe lǝ mi ntii, befo lekpasǝ nǝmǝ bɛnɔ bǝ lǝ biyifo lekpasǝ eto betidi.” Se Yesu lɛtɛyi mǝ nyamfo ólosǝǝ, údu lǝ mǝ ɔflɔ úsu ɔbiɔ. ");
INSERT INTO lip_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ite bǝ Yesu éyifo ayanisa kpǝ lǝ mǝ ǝnǝmi óte tsyaa, bámfo wǝ bánɔ. ");
INSERT INTO lip_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Fɛɛ nyamfo ǝbǝ itǝ nko, bǝ lǝ Onanto eto Unyɛlǝkǝtidi Yesaya eto lesa nǝ ɔ́tɛyi utsyǝ lǝ ibǝ itǝ nko nkǝ, “Bonamute, owoe léfo ditiki nǝ bɔ́tɛyi ɔnɔ? Nya owoe Bonamute ǝmǝ dílǝkǝ wǝ ǝsuǝale óte?” ");
INSERT INTO lip_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Lǝ nyamfó eso bámfo bofo kanɔ, itsyise Yesaya esi ɔ́tɛyi nkǝ, ");
INSERT INTO lip_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Onanto átɛyi nkǝ, “Mba mǝ ǝnǝmi nya míninǝsǝ mǝ, bǝ lǝ mǝ ǝnǝmi lǝ ɛyɛ asa bunyǝ. Nya lǝ mǝ nsusu lǝ bɔyɛ asa kasɔ bɔnɔ. Itǝ bǝmbɔtsyi bawuninsǝ befi mǝ ǝsuǝ bǝtǝ mɛ, bǝ lǝ ntsya mǝ bufi.” ");
INSERT INTO lip_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Yesaya átɛyi nyamfo itsyise úbunyǝ Yesu eto diyǝnde kokoko, nya údi etiki utsyi lǝ wǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Fɛɛ ite nko tsyaa, Yudafɔ eto beninǝ kpǝ áfo Yesu banɔ. Fɛɛ lǝ Farisifɔ bamǝ eso baamfo etiki nyamfo budi kabɔsǝǝ lekple betidi nɔ, bǝ lǝ bayɛ mǝ bola lǝ mǝ katsyakɔ eso. ");
INSERT INTO lip_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Baala bǝ baafo betidi eto atɛsǝ enso atɛsǝ nya ditsyi Onanto ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Nyaso Yesu édi etiki ófa bembembe ɔ́tɛyi nkǝ, “Utsyuǝ saa ke laafo mɛ kanɔɔ, inni mɔ mate ete ófo ɔ́nɔ. Bomu ófo nwǝ létsyese mɛ tsya ɔ́nɔ. ");
INSERT INTO lip_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Nya utsyuǝ saa ke lǝǝnyǝ mɛɛ, ǝǝnyǝ nwǝ létsyese mɛ tsya. ");
INSERT INTO lip_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Mbǝ kawunsiǝ fe lekpasǝ, nya utsyuǝ saa ke léfo mɛ ɔnɔɔ, ensiembɔkɛ lǝ ketuntu ǝsuǝ bio. ");
INSERT INTO lip_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Lǝ utsyuǝ aanɔ mɔ ditiki nya weentsyue ni koto, mǝmbolo wǝ dikpi, itsyise mǝmbǝ miǝ maalo kawunsiǝ eto betidi dikpi. Bomu mbǝ miǝ lǝ mmfo ntǝ mǝ. ");
INSERT INTO lip_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Utidi wǝ kee lɛni mɛ nya wámmfo mɔ ditikii, kpe nwǝ lookponko wǝ lekpo. Etiki nya míndii, nya lookponko wǝ lekpo lǝ diyi fɛfɛ nǝmǝ nɛ. ");
INSERT INTO lip_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Nyamfo eyifo sitinti itsyise mántɛyi kulesa lǝ mɔ ǝsuǝale ǝsuǝ. Bomu mɔ Anto wǝ létsyese mɛɛ, léte mɛ lesa nǝ ele bǝ ntɛyi ku kase ele bǝ ntɛyi ni. ");
INSERT INTO lip_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nya nnyi miǝ wǝ kɔfi komǝ ǝǝtǝ nkpǝ manlo. Nyaso lesa nǝ kee míntɛyii, ni ni lesa nǝ Anto ǝmǝ lɛtɛyi mɛ nkǝ ntɛyi nɛ.” ");
INSERT INTO lip_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ibu diyi lɔni fɛ lǝ bedi Ukpǝ Ása Bo Ɔ́yila eto diyisɛɛ nǝmǝ. Yesu áte nkǝ wǝ lefe éboyo bǝ udu lǝ kawunsiǝ kamfo usu wǝ Anto ɔflɔ. Úkala mba ni wǝ bale lǝ kawunsiǝ mfo, nya óla mǝ sitinti isu ese taa kalosǝkɔ. ");
INSERT INTO lip_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yesu ku wǝ bakasebi akɛ lǝ lesakedikɔ ku ditsyitsyo nǝmfó. Olo ǝmǝ ébusu údufǝ lǝ Yuda wǝ ni Simon Iskariot eto ubi eto nsusu nkǝ lǝ udi wǝ okpe lǝ udu Yesu utǝ wǝ balo. ");
INSERT INTO lip_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu áte nkǝ wǝ Anto éfi ǝsuǝale saa útǝ wǝ lǝ lesa saa ǝsuǝ. Uyi nkǝ útsyi Onanto ɔflɔ nya usinkli ɔntɔ lǝ Onanto ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Nyaso ótaka lǝ lesakedikɔ kamǝ nya úlǝkǝ wǝ awubunte kplɛ nnya kato útsyǝ nya úfi sebo ótsyasɛ lǝ nkɛ. ");
INSERT INTO lip_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Úkuti ntu ókpo lǝ ɔkpɛ kplɛ utsyuǝ kafo nya útsyiko wǝ bakasebi bamǝ eto akpa buflǝ, ákasi nnya ku sebo sia ótsyasǝ lǝ nkɛ. ");
INSERT INTO lip_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Se éyo Simon Petro ǝsuǝǝ, ɔ́tɔ Yesu nkǝ, “Bonamute, buflǝ fǝǝbǝ mɛ akpa lee?” ");
INSERT INTO lip_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesu ǝtǝ wǝ mbuayɛ nkǝ, “Amannɔ tɔ lesa nǝ minlɛ buyifo mfo eto kasɔ, fɛɛ kamaa, ǝbɔnɔ nnya kasɔ.” ");
INSERT INTO lip_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Simon Petro ǝtǝ mbuayɛ nkǝ, “Kulefe! Mǝmbutǝ kusu miǝ lǝ ǝflǝ mɔ akpa kulefe.” Mfó nya Yesu lɛtɛyi wǝ nkǝ, “Lǝ mǝmflǝ fǝ akpaa, nyalɛ ensiembuyǝ kedikɔ lǝ mɛ.” ");
INSERT INTO lip_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simon Petro átɛyi wǝ nkǝ, “Bonamute, nyalɛ mǝmflǝ mɔ akpa mate, bomu flǝ mɔ ani ku mɔ disi tsya!” ");
INSERT INTO lip_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesu ǝtǝ wǝ mbuayɛ nkǝ, “Utsyuǝ saa ke díkǝflǝ ntuu, ole. Nya weensihiã bǝ uflǝ wǝ ǝsuǝ bio, nnya lehiã ete ni bǝ uflǝ akpa. Itsyise wǝ kalebe saa ebole koko. Mi ǝsuǝ ébole, fɛɛ inni mimblɛ.” ");
INSERT INTO lip_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesu fe úyi nwǝ lǝǝbǝ wǝ bokpe lǝ ani, nyaso ɔ́tɛyi nkǝ, “Inni mimblɛ kenke lele.” ");
INSERT INTO lip_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Se Yesu díflǝ mǝ akpa ólosǝǝ, úsinkli úfi wǝ awu ókpe, nya úsinkli úsu úsiǝ lǝ kasɔ lǝ kedikɔ kamǝ. Mfó nya ɔ́tɔ wǝ bakasebi bamǝ nkǝ, “Bɛnɔ lesa nǝ mínyifo mi mfo eto kasɔ? ");
INSERT INTO lip_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Biakpadi mɛ biǝ Oteasa ku Onamute, nya ɛflɔ bǝ bekpadi mɛ nko. Itsyise wǝ mini nɛ. ");
INSERT INTO lip_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Mɔ, nwǝ ni mi Onamute ku Oteasa ébuflǝ mi akpa. Lǝ nko inii, ele bǝ mi tsya flǝ mi bǝtsyuǝ eto akpa. ");
INSERT INTO lip_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ditsyǝbi dini mínyifo mínte mi, bǝ mi tsya lǝ biyifo fe kase mínyifo mínte mi. ");
INSERT INTO lip_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nlɛ mi bɔtɛyi sitinti miǝ uyifoyifo mamɔ oso wǝ Onamute. Nko ke ini bǝ ɔtɔyɛ mamɔ onso nwǝ lékpe wǝ kɔtɔ. ");
INSERT INTO lip_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Se binyi sitinti siamfo esoo, Onanto ebokpo mi atsyɔ lǝ bɛyɛ lǝ sitintisu ǝsuǝ biyifo asa! ");
INSERT INTO lip_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Inni mimblɛ eto etiki minlɛ bɔtɛyi mfo. Nyi mba mínlǝkǝ lǝ mi nti. Fɛɛ ele bǝ Awɔnisa Kɛnkɛ eto Kukue eto etiki bǝ itǝ fe kase báwɔni nnya bǝtsyǝ, ‘Utidi wǝ lékpe kɔni lǝ ɔkpɛ ɔni ku mɛ búdi lesaa, wǝ ni nwǝ létaka úńyǝ lǝ mɛ ǝsuǝ nɛ.’ ");
INSERT INTO lip_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Nlɛ mi nyamfo bɔtɛyi katɔnsǝ fɛ lǝ ibǝ ibǝ, bǝ lǝ ibǝ ibǝ nko sitintii, biofo bɛnɔ biǝ Mɔ ni Nwǝ Mini. ");
INSERT INTO lip_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Sitinti ini minlɛ mi bɔtɛyi minkǝ, utsyuǝ saa ke lefo utidi wǝ míntsyesee, mɔ ófo. Nya utsyuǝ saa ke léfo mɛɛ, nwǝ létsyese mɛ uni ófo.” ");
INSERT INTO lip_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Se Yesu lɛtɛyi etiki nyamfo ólosǝǝ, ílǝ wǝ tinti lǝ lɛkɔɛsi. Nya ɔ́tɛyi ókpasǝ nkǝ, “Sitinti minlɛ mi bɔtɛyi mi nkǝ, mi nti eto ɔni ebudu mɛ utǝ.” ");
INSERT INTO lip_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Mfó nya Yesu eto bakasebi bamǝ dítsyi bawuninsǝ bábe mǝ bǝtsyuǝ eto ǝnǝmi itsyise íyifo mǝ yaa, nya bánte mǝ nti eto nwǝ Yesu nlɛ. ");
INSERT INTO lip_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Bakasebi bamǝ eto ɔni wǝ Yesu laala tintii, ǝsiǝ ɔfi Yesu. ");
INSERT INTO lip_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Lǝ nyaso Simon Petro áma ǝnǝmi ókpe okasebi ǝmǝ, ɔ́tɛyi wǝ nkǝ, “Tɔ wǝ futsyǝ ɔnlɛ.” ");
INSERT INTO lip_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Nyaso wuntsya étsyue kɛnyɛ lǝ Yesu ɔflɔ nya ɔ́tɔ wǝ buɛ nkǝ, “Bonamute, owoe ni futsyǝ?” ");
INSERT INTO lip_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Mfó nya Yesu dítǝ mbuayɛ nkǝ, “Utidi wǝ muubudi lesa nto kutu ntǝǝ, wǝ uni nɛ.” Lǝ nyaso Yesu ébudi lesa sɛkɛ úfi óto kutu nya úfi útǝ Yuda wǝ ni Simon Iskariot eto ubi. ");
INSERT INTO lip_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Kase Yuda lefo lesa nǝmǝ koo, Obonsam ko dídufǝ wǝ lǝ ǝsuǝ. Mfó nya Yesu lɛtɛyi wǝ nkǝ, “Kɔse mlǝ lǝ eyifo lesa nǝ faala fǝ eeyifo.” ");
INSERT INTO lip_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Fɛɛ bafɛfɛ ba nsi lǝ lesakedikɔ mfó mánnɔ kasɔ lesa nǝ eso Yesu lɛtɛyi Yuda nko. ");
INSERT INTO lip_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Mǝ bǝtsyuǝ ébu bǝ se ini Yuda díkalɛ mǝ otabitobe esoo, bɔtɛyi Yesu nlɛ wǝ nkǝ usu oya bikǝ bia boohiã itǝ mǝ diyisɛɛ nǝmǝ eto budi oboko lee usu utǝ bakombo lesatsyuǝ. ");
INSERT INTO lip_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Nya se Yuda léfo lesa nǝmǝ koo, ete ɔ́bɔ údu. Kǝtsyǝ tsya idi lefe nǝmfó. ");
INSERT INTO lip_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Se Yuda dídu eto kamaa, Yesu átɛyi nkǝ, “Mɔmɔɔ, bábesǝ Utidi Eto Ubi ǝmǝ eto diye kato. Nya ɛyɛ lǝ wǝ ǝsuǝǝ, bábesǝ Onanto eto diye kato. ");
INSERT INTO lip_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Lǝ bábesǝ Onanto eto diye kato ɛyɛ lǝ Utidi Eto Ubi ǝmǝ ǝsuǝǝ, nyalɛ Onanto ebulǝkǝ Utidi Eto Ubi eto diyǝnde nǝ ǝsuǝ onkpe ote. Nya wuuyifo nkomǝ mɔmɔ mfoti. ");
INSERT INTO lip_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Mɔ bebi, mensiembusiǝ lǝ mi ɔflɔ ɛklɛ bio. Biɔbɛbɛ mɛ, fɛɛ nlɛ mi bɔtɛyi mɔmɔ fe kase míntɛyi Yudafɔ eto beninǝ léfee miǝ, ‘Kaka mintɔɔ, biembofo mfó bubǝ.’ ");
INSERT INTO lip_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Nya mɔmɔɔ, nlɛ mi kɔfi fɔfɔ butǝ. Bela mi bǝtsyuǝ! Kase minla mii, mi tsya la mi bǝtsyuǝ nko ke. ");
INSERT INTO lip_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Lǝ bela bǝtsyuǝǝ, betidi ba tã ebɔyɛ lǝ nnya ǝsuǝ bate bǝ mɔ bakasebi bini.” ");
INSERT INTO lip_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Petro átɔ wǝ nkǝ, “Bonamute, se fantɔ?” Yesu ǝtǝ wǝ mbuayɛ nkǝ, “Kaka mintɔɔ, embofo mɛ butǝkǝko kesu mɔmɔ. Fɛɛ kamaa, ebutǝkǝko mɛ ǝbǝ mfó.” ");
INSERT INTO lip_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petro átɔ wǝ nkǝ, “Bonamute, beso mǝmbofo fǝ butǝkǝko mɔmɔ kesu? Muukpǝ lǝ fǝ disi faa!” ");
INSERT INTO lip_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Mfó Yesu ǝtǝ wǝ mbuayɛ nkǝ, “Ebofo bukpǝ sitinti lǝ mɔ disi fɛ? Sitinti, nlɛ fǝ bɔtɛyi miǝ, fɛ ukusɛ luutǝ kɛnyɛɛ, ǝbɔni mɛ sitsyǝ, fǝ enyi mɛ kon.” ");
INSERT INTO lip_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesu átɛyi mǝ nkǝ, “Biǝntǝ lǝ ilǝ mi lǝ lɛkɔɛsi. Fe kase béfo Onanto bɛnɔɔ, befo mintsya bɛnɔ. ");
INSERT INTO lip_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Lǝ mɔ Anto eto diyoo, nsiǝkɔ kpǝ kpe. Ntɔ lǝ nsu nlɔ nsiǝkɔ ntsyǝ mi. Nya mǝmbɔtɛyi mi nko, lenni nko ini. ");
INSERT INTO lip_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nya lǝ nsu nlɔ nsiǝkɔ ntsyǝ ntǝ mi nlosǝǝ, muusinkli mbǝ nkpa mi nsuko mɔ ɔflɔ, itǝ bǝ kaka minkpee, lǝ mi tsya lǝ bisiǝ mfó. ");
INSERT INTO lip_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Biyi kusu ko ntɔ lǝ kaka mintɔ.” ");
INSERT INTO lip_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Toma átɛyi wǝ nkǝ, “Bonamute, bunyi kaka fantɔ. Nya ntsyǝ buuyifo bote kusu ko bɔɔyɛ bubǝ fǝ aflɔ?” ");
INSERT INTO lip_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesu ǝtǝ wǝ mbuayɛ nkǝ, “Mɔ ni kusu komǝ, sitinti siamǝ ku nkpǝ bomǝ. Kuutsyuǝ saa embubǝ Anto ǝmǝ ɔflɔ lǝ woanyɛ lǝ mɛ ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Yesu átɛyi mǝ nkǝ, “Mɔmɔ ǝmǝ bimfi biinyi mɛɛ, bíote mɔ Anto ǝmǝ tsya. Nya idu mɔmɔ ɛntɔɔ, bifi biyi wǝ nya bíkǝnyǝ wǝ tsya.” ");
INSERT INTO lip_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipo átɛyi wǝ nkǝ, “Bonamute, te bo Anto ǝmǝ ete imi bo.” ");
INSERT INTO lip_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesu átɛyi wǝ nkǝ, “Filipo, kokooko ǝmǝ minkpe mi lǝ ɔflɔɔ, ete binyi mɛ tɔ? Nwǝ ke díkǝnyǝ mɛɛ, ǝnyǝ mɔ Anto ǝmǝ tsya nɛ. Ntsyǝ eso fanlɛ bɔtɛyi fǝnkǝ, ‘Te bo Anto ǝmǝ’? ");
INSERT INTO lip_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Filipo, nyalɛ ámamfo ánɔ fǝ nkpe lǝ Anto ǝmǝ ǝsuǝ nya wuntsya nkpe lǝ mɛ? Etiki nnya míntɛyi mii, mentsyi mɔ kosate ɔflɔ. Anto wǝ nkpe lǝ mɛɛ, leeyifo wǝ kosate eto keyifo. ");
INSERT INTO lip_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Befo mɛ bɛnɔ lǝ ntɛyi mi minkǝ, nkpe lǝ Anto ǝmǝ ǝsuǝ, nya wuntsya nkpe lǝ mɛ. Lǝ biamfo bɛnɔɔ, befo bɛnɔ lǝ ayanisa nnya meeyifo mate eso. ");
INSERT INTO lip_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Nlɛ mi bɔtɛyi sitinti minkǝ, nwǝ ke léfo mɛ ɔ́nɔɔ, ebuyifo asa nnya meeyifo. Sitinti, wuuyifo asa nnya nso nko kulaa tsya, itsyise ntɔ lɔ mɔ Anto ǝmǝ ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Nya muuyifo lesa saa nǝ ke bɛtɔ lǝ mɔ diye ǝsuǝ ntǝ mi, bǝ lǝ babesǝ Anto ǝmǝ eto diye kato ɛyɛ lǝ Ubi ǝmǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Lǝ bɛtɔ lesa saa lǝ mɔ diye ǝsuǝǝ, muuyifo ni ntǝ mi.” ");
INSERT INTO lip_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Yesu esi ɔ́tɛyi nkǝ, “Lǝ biala mɛɛ, biutsyue mɔ afi koto. ");
INSERT INTO lip_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Mɔɔtɔ Anto ǝmǝ lǝ utǝ mi Ɔwunsǝkotsyuǝ bamba wǝ luusiǝ ko mi lefe saa. ");
INSERT INTO lip_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Wǝ ni Lɛwɔnɔ nǝ lǝǝlǝkǝ sitinti lǝ Onanto ǝsuǝ kate. Fɛɛ kawunsiǝ eto betidi ǝmbofo wǝ bunyǝ fɛ lǝ besu bǝtsyǝ wǝ lekpo. Fɛɛ mii, biyi Lɛwɔnɔ nǝmǝ itsyise usi ko mi nya onkpe lǝ mi ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Lɛ ndu lǝ mi ɔflɔɔ, memoonyani mi mate ntsyǝ fe bakɔbebi. Bomu muusinkli mbǝ mi ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Lǝ lefe kliminti ǝsuǝǝ, kawunsiǝ eto betidi ensiembunyǝ mɛ. Fɛɛ mi ebunyǝ mɛ. Nya se minsi nkpǝ esoo, mi tsya ebusiǝ nkpǝ. ");
INSERT INTO lip_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Lǝ lefe nǝmfóo, biunyǝ bitsyǝ lekpo biǝ nkpe lǝ Anto ǝmǝ ǝsuǝ, nya mi tsya nkpe lǝ mɛ, fe kase mintsya nkpe lǝ mi ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Utsyuǝ saa wǝ laafo mɔ afi nya woeyifo lǝ nnya ǝsuǝ, wǝ ni nwǝ laala mɛ nɛ. Mɔ Anto ebola nwǝ laala mɛ. Nya mintsya loola wǝ nya muulǝkǝ mɔ ǝsuǝ nte wǝ.” ");
INSERT INTO lip_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Nya Yuda, wǝ lenni Iskariot, lɛtɔ Yesu nkǝ, “Bonamute, ntsyǝ fɛ ini bo mate ete fuulǝkǝ ǝsuǝ ate, nya fǝmbulǝkǝ ǝsuǝ ate kawunsiǝ eto betidi?” ");
INSERT INTO lip_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Mfó nya Yesu dítǝ wǝ mbuayɛ nkǝ, “Utsyuǝ saa ke laala mɛɛ, wuutsyue ditiki nǝ maate koto, nya mɔ Anto loola wǝ. Nya mɔ ku mɔ Anto ǝmǝ luubǝ bɔsɔnɔ wǝ, busiǝ wǝ lǝ ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Utsyuǝ saa ke laanla mɛɛ, entsyue mɔ asatete koto. Nya asatete nnya bíkanɔɔ, enni mɔ kosate eto ale. Bomu mɔ Anto wǝ létsyese mɛ eto ale ini. ");
INSERT INTO lip_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Mbɔtɛyi mi nyamfo kenke lǝ lefe minsi minkpe mi lǝ ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Lɛwɔnɔ Kɛnkɛ nǝ ni Ɔwunsǝkotsyuǝ wǝ Onanto lootsyese lǝ mɔ diye ǝsuǝǝ, ebote mi lesa saa nya wooklomasǝ mi lesa saa nǝ míntɛyi mi. ");
INSERT INTO lip_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Diyuǝ lǝ disiǝko mi. Nya mɔ diyuǝ mimfi minlɛ mi butǝ. Inni lǝ kase kawunsiǝ eto betidi lǝǝtǝ. Biǝntǝ lǝ ilǝ mi lǝ lɛkɔɛsi. Nya biante sikpi. ");
INSERT INTO lip_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Bɛnɔ se míntɛyi mi miǝ, ‘Nlɛ budu lǝ mi ɔflɔ, nya muusinkli mbǝ mi ɔflɔ.’ Lǝ nnya ete biala mɛɛ, eni biunyǝ disuǝyuǝ bǝ ndu ntɔ lǝ Anto ǝmǝ ɔflɔ. Itsyise ɔmɔ oso mɛ. ");
INSERT INTO lip_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Mbɔtɛyi mi nyamfo mɔmɔ fɛ lǝ ibǝ ibǝ, bǝ lǝ ibǝ ibǝ itǝǝ, lǝ befo bɛnɔ. ");
INSERT INTO lip_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Mensiembofo mi etiki budinko kaklɛ itsyise kawunsiǝ kamfo eto oka lɛ bubǝ. Umbǝ ǝsuǝale lǝ mɛ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Fɛɛ ele bǝ kawunsiǝ te nkǝ maala Anto ǝmǝ, nyaso meeyifo lǝ kase ɔ́tɛyi mɛ nkǝ nyifo. “Mɔmɔɔ, bibǝ lǝ budu mfo.” ");
INSERT INTO lip_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Mɔ ni kudiyi tinti komǝ, nya mɔ Anto ni kudiyi komǝ eto ɔkuɛmfo ǝmǝ. ");
INSERT INTO lip_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Waala mɔ kalɛ ka laannwɔ kǝlǝkǝ lǝ mɛ ǝsuǝ nya nka laanwɔ ebibii, waalɔ ke ǝsuǝ lǝ kase ufiebi lɔɔsɔ okpo ke bǝ lǝ kafo bɔnwɔ kukɔnɔ. ");
INSERT INTO lip_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Mimii, bɔ́ɔlɔ mi ǝsuǝ bǝtsyǝ koko tsya, ɛyɛ lǝ asa nnya mínte mi eso. ");
INSERT INTO lip_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Bɛkɔ lǝ mɛ lǝ mintsya lǝ nyifo lɔni ku mi. Kuyi eto ɔlɛ ǝmbofo bɔnwɔ lǝ wǝ mate ǝsuǝ, woofo bɔnwɔ lǝ ɔlɛ ǝmǝ akɔ lǝ kuyi komǝ ǝsuǝ. Nko ke biembofo ebibi bɔnwɔ lǝ biankɔ lǝ mɛ ǝsuǝ nɛ. ");
INSERT INTO lip_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Mɔ ni kudiyi komǝ nɛ, nya mi ni ko kalɛ. Utidi wǝ ke lɛkɔ lǝ mɛɛ, nya mintsya lɛkɔ ku wǝǝ, ɛbɔnwɔ ebibi kpǝ. Itsyise biembofo kulesa buyifo lǝ mimbǝ lǝ mi. ");
INSERT INTO lip_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Futsyǝ ke dimankɔ ku mɛɛ, booto wǝ bakpe fe uyilɛ nya wookoe ofiani ɔtɔni. Baakpa kalɛ kamfo eto okle kǝtsyǝ ditsyu kakpe lǝ ute katonsǝ. ");
INSERT INTO lip_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Lǝ biyifo lɔni ku mɛ nya mɔ etiki tsya nkpe lǝ mii, bɛtɔ lesa saa nǝ ke lefe itǝ mi, ete biofo ni. ");
INSERT INTO lip_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Mɔ Anto eto diyǝnde ni bǝ lǝ bɛnwɔ ebibi kpǝ, nya ɛyɛ lǝ nyamfo ǝsuǝǝ, nnya yuulǝkǝ ete bǝ biyifo mɔ bakasebi nɛ. ");
INSERT INTO lip_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Maala mi fe kase mɔ Anto laala mɛ. Nyaso bitǝ lǝ mɔ lelabi lǝ lɛkɛ mi lǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Lǝ bitsyue mɔ afi kotoo, mɔ lelabi itǝ mi ebɔkɔ lǝ mi fe kase mintsya leetsyue mɔ Anto koto, nya mintsyimɛ lǝ wǝ lelabi ǝsuǝ lefe saa. ");
INSERT INTO lip_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Nlɛ mi asa nyamfo bɔtɛyi bǝ lǝ disuǝyuǝ nǝ nkpe lǝ mɛɛ, lǝ lɛkɛ mi tsya lǝ ǝsuǝ lɛflɔ. ");
INSERT INTO lip_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Kɔfi ko minlɛ mi butǝ ni nkǝ bela bǝtsyuǝ fe kase maala mi. ");
INSERT INTO lip_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Lelabi nǝ utidi loofo bufi kǝtǝ wǝ bayɛtsyuǝ enso kenke ni bǝnkǝ lǝ ufi wǝ nkpǝ utǝ lǝ mǝ disi. ");
INSERT INTO lip_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Lǝ biyifo lǝ mɔ afi ǝsuǝǝ, ete bǝ biyifo mɔ bayɛtsyuǝ. ");
INSERT INTO lip_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Mensiembokpo mi miǝ mɔ beyifoyifo mɔmɔ, itsyise nwǝ leeyifo utidi bamba eto keyifo aante asa nnya wǝ onamute leeyifo. Bomu maakpo mi miǝ mɔ bayɛtsyuǝ. Itsyise asa nnya kenke mínɔ mintsyiko mɔ Anto ɔflɔɔ, mbɔtɛyi mi nnya. ");
INSERT INTO lip_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Inni mi díkǝlǝkǝ mɛ. Bomu mɔ dílǝkǝ mi. Nya nlǝkǝ mi miǝ lǝ bisu bɛnwɔ ebibi kpǝ, nya ebibi nnya biɔnwɔɔ, lǝ itsyǝ lefe saa. Itǝ bǝ lesa saa nǝ biɔtɔ Anto lǝ mɔ diye ǝsuǝǝ, wuutǝ mi ni. ");
INSERT INTO lip_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Lǝ nyaso kɔfi ko minlɛ mi butǝ ni nkǝ bela mi bǝtsyuǝ.” ");
INSERT INTO lip_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Yesu ésukosǝ nkǝ, “Lǝ kawunsiǝ eto betidi eekisi mii, bete biǝ mɔ baka bukisi nko. ");
INSERT INTO lip_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Lǝ kawunsiǝ kamfo eto betidi binii, eni boola mi fe mǝ ke. Fɛɛ nlǝkǝ mi ntsyiko kawunsiǝ kamfo eto betidi nti nyaso binsini mǝ bale. Nyamfo eso beekisi mi nɛ. ");
INSERT INTO lip_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Bekloma ditiki nǝ míntɛyi mi minkǝ, ‘Ndomunyǝ saa ammɔ kaso wǝ onamute.’ Lǝ betidi ǝńyǝ mɛ lǝ ǝsuǝǝ, bete biǝ boońyǝ mi tsya lǝ ǝsuǝ. Lǝ bétsyue mɔ etiki kotoo, bootsyue mi ale tsya koto. ");
INSERT INTO lip_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Fɛɛ booyifo mi nyamfo kenke lǝ mɔ disi eso, itsyise benyi futsyǝ létsyese mɛ. ");
INSERT INTO lip_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Lǝ nnya ete mǝmbǝ ntɛyi mǝ kulesaa, eni bǝmbolo mǝ lebua yifoyifo eto dikpi. Fɛɛ mɔmɔɔ, béyifo lebua nya taflatsyɛ saa ensibǝ booto bǝ bánte. ");
INSERT INTO lip_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Utsyuǝ saa wǝ leekisi mɛɛ, eekisi mɔ Anto tsya. ");
INSERT INTO lip_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Lǝ nnya ete ményifo keyifo ka kuutsyuǝ saa dímenyifo tɔ únyǝ lǝ mǝ ntii, eni bǝmbolo mǝ lebua yifoyifo eto dikpi. Fɛɛ bǝnyǝ asa nnya mínyifo, tsyaa balɛ mɔ ku mɔ Anto kenke bukisi. ");
INSERT INTO lip_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ele bǝ nyamfo bǝ itǝ nko bǝ lesa nǝ báwɔni bákpe lǝ mǝ kɔfi eto kukue ǝsuǝǝ, lǝ ibǝ itǝ nko bǝ, ‘Bukisi bimba ete békisi mɛ.’ ");
INSERT INTO lip_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Lǝ nyasoo, mootsyese mi Lɛwɔnɔ Kɛnkɛ nǝ ni Ɔwunsǝkotsyuǝ itsyi lǝ Onanto ɔflɔ. Wǝ luulǝkǝ sitinti lǝ Onanto ǝsuǝ ote. Lefe nǝ utsyi Anto ǝmǝ ɔflɔ ubǝǝ, wuudi adansiǝ lǝ mɛ ǝsuǝ utǝ mi. ");
INSERT INTO lip_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Mi tsya badansiɛ biudi bitǝ mɛ, itsyise bekpe lǝ mɔ ɔflɔ idu taa kasɔ ketsyikokɔ ke. ");
INSERT INTO lip_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Ntɛyi mi etiki nyamfo kenke bǝ lǝ betidi lǝ bayɛ butǝ lǝ ani lǝ elo mi lǝ mi bofokanɔ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Boolǝkǝ mi lǝ mǝ nti lǝ katsyakɔ, nya lefe ebubǝ nǝ lǝ utsyuǝ lɛ mi bolo tsyaa, wuubu nkǝ ɔlɛ Onanto busumu lǝ nnya ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Betidi ebuyifo mi nyamfo eto okle, itsyise benyi mɛ nye Anto ǝmǝ tsya. ");
INSERT INTO lip_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Bomu mbɔtɛyi mi nyamfo ntɔnsǝ bǝ lǝ lefe nǝmǝ áyo bǝ beyifo nnya nkoo, lǝ bekloma biǝ ntɛyi mi nnya nko. “Mántɛyi mi nyamfo lǝ kasɔ ketsyikokɔ itsyise nkɛ mi lǝ ɔflɔ lefe nǝmfo. ");
INSERT INTO lip_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Fɛ mɔmɔɔ, ntɔ lǝ nwǝ létsyese mɛ ɔflɔ. Fɛɛ mi kuutsyuǝ saa anlɛ mɛ bɔtɔ nkǝ sieti mintɔ. ");
INSERT INTO lip_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Nya se míntɛyi mi nyamfoo, mi ketu eyi ku nkuɛnlo. ");
INSERT INTO lip_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Fɛɛ nlɛ mi bɔtɛyi sitinti minkǝ, ɛlɛkɛ itǝ mi bǝ ndu lǝ mi ɔflɔ. Itsyise lǝ mensuu, Ɔwunsǝkotsyuǝ ǝmǝ embubǝ mi ɔflɔ. Fɛɛ lǝ nsuu, mootsyese wǝ mi. ");
INSERT INTO lip_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Nya lǝ ubǝǝ, wuulǝkǝ ote kawunsiǝ eto betidi ekpa wue bate bǝ bánya kusu lǝ lesa nǝ ni lebua ku lesa nǝ ni kasɛɛ yifoyifo ku lesa nǝ ni Onanto eto lekpo kpokpo. ");
INSERT INTO lip_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Bembote lesa nǝ ni lebua itsyise bámfo mɛ bánɔ eso. ");
INSERT INTO lip_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Nya boonyǝ bǝtsyǝ lekpo se banyɛ lǝ kusu sɛɛ komǝ ǝsuǝ, itsyise ntɔ lǝ Anto ǝmǝ ɔflɔ nya biensiembunyǝ mɛ bio. ");
INSERT INTO lip_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Nya bebote lesa nǝ ni lekpo kpokpo itsyise Onanto ébolo kawunsiǝ kamfo eto ǝsuǝalenyǝ ǝmǝ dikpi koko. ");
INSERT INTO lip_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Asa kpǝ si ekpe nnya ele bǝ ntɛyi mi. Fɛɛ yooso mi butsyi mɔmɔ. ");
INSERT INTO lip_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Fɛɛ lefe nǝ Lɛwɔnɔ nǝ lǝǝlǝkǝ sitinti lǝ Onanto ǝsuǝ kate ǝbǝǝ, diutǝ bete sitinti siamǝ kenke itsyi lǝ Onanto ɔflɔ. Nya wǝǝmbɔtɛyi kulesa lǝ wǝ ǝsuǝale ǝsuǝ. Bomu wɔɔtɛyi mi lesa nǝ waanɔ ku nnya lǝǝbǝ bubǝ. ");
INSERT INTO lip_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Wuutǝ babesǝ mɔ diye kato itsyise wuulǝkǝ lesa nǝ ófo utsyiko mɔ ɔflɔ ote mi. ");
INSERT INTO lip_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Lesa saa nǝ ni Anto ǝmǝ eto lelee, eyifo mɔ lele. Nyaso míntɛyi mi minkǝ Lɛwɔnɔ nǝmǝ ebufi lesa nǝ mintǝ wǝ ubǝ ote mi.” ");
INSERT INTO lip_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Yesu esi ɔ́tɛyi nkǝ, “Ibu sɛkɛ biensiembunyǝ mɛ bio, nya lǝ lefe sɛkɛ kama bisi biunyǝ mɛ.” ");
INSERT INTO lip_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Mfó nya wǝ bakasebi bǝtsyuǝ lɛtɔ mǝ bǝtsyuǝ bǝnkǝ, “Nya ɔ́tɛyi mfo eto kasɔ nkpǝ? Ɔ́tɛyi bo nkǝ, Ibu sɛkɛ boensi embunyǝ wǝ bio. Nya sɛkɛ tsya lǝ nnya kamaa, busi buunyǝ wǝ. Nya usi ɔ́tɛyi bo tsya nkǝ, ‘Itsyise ntɔ lǝ Anto ǝmǝ ɔflɔ.’ ");
INSERT INTO lip_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Nnya ɔ́tɛyi nkǝ, ‘Ibu sɛkɛ,’ eto kasɔ ni be? Bóannɔ lesa nǝ ɔnlɛ bɔtɛyi eto kasɔ!” ");
INSERT INTO lip_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu áte nkǝ etiki ǝtsyuǝ kpe bála lǝ batɔ wǝ. Nyaso ɔ́tɛyi mǝ nkǝ, “Ntɛyi minkǝ ibu sɛkɛ biensi embunyǝ mɛ bio, nya sɛkɛ lǝ nnya kamaa, bisi biunyǝ mɛ bio. Etiki nyamfo bɛnlɛ bɔlɛ kabe lǝ mi bǝtsyuǝ nti lee? ");
INSERT INTO lip_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Sitinti minlɛ mi bɔtɛyi minkǝ biuwi kaminsǝku, bilǝkǝ binǝntu. Fɛɛ kawunsiǝ eto betidi luunyǝ disuǝyuǝ. Nya mii, nkuɛnlo ebumuǝ mi, fɛɛ mi nkuɛnlo bomǝ ebofiani disuǝyuǝ. ");
INSERT INTO lip_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Lǝ usio labe kolee, woakɛ lǝ bulǝ ǝsuǝ itsyise ɔlɛ kanyi bunyǝ. Fɛɛ lǝ óle ubi ǝmǝ ólosǝǝ, woata kanyi ka únyǝ ǝsuǝ, itsyise wǝǝnyǝ disuǝyuǝ nkǝ óle ubi ókpe lǝ kawunsiǝ. ");
INSERT INTO lip_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Nko seka inte itǝ mi tsya nɛ. Mɔmɔɔ, bekpe lǝ nkuɛnlo ǝsuǝ. Fɛɛ muunyǝ mi bio. Nya disuǝyuǝ luuyi mi akɔɛsi kenke, disuǝyuǝ nǝ eto okle kuutsyuǝ saa lǝmbofo bofo ketsyiko mi ani kulefe. ");
INSERT INTO lip_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Lǝ diyi nǝmǝ ayoo, biembɔtɔ mɛ kulesa. Itsyise nlɛ mi bɔtɛyi sitinti miǝ lesa nǝ ke biɔtɔ mɔ Anto lǝ mɔ diye ǝsuǝǝ, wuufi ni utǝ mi. ");
INSERT INTO lip_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ibǝ ese mɔmɔɔ, bíantɔ tɔ kulesa lǝ mɔ diye ǝsuǝ. Bɛtɔ ete lǝ utǝ mi lǝ mi disuǝyuǝ lǝ lɛflɔ lelo. ");
INSERT INTO lip_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Ndi mi etiki ɛyɛ lǝ akpa ǝsuǝ. Fɛɛ lefe ebubǝ nǝ mensiembudi mi etiki nyɛnko lǝ akpa ǝsuǝ. Bomu muudi mi etiki wuee itsyi lǝ Anto ǝmǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Lǝ lefe nǝmǝ ayoo, bɛtɔ wǝ asa lǝ mɔ diye ǝsuǝ. Minlɛ bɔtɛyi miǝ mɔɔ, mɔɔtɔ ntɛ mi. ");
INSERT INTO lip_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Itsyise Anto ǝmǝ kosate aala mi. Waala mi itsyise mi tsya aala mɛ, nya béfo bɛnɔ biǝ Onanto ɔflɔ mintsyi mímbǝ. ");
INSERT INTO lip_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Sitintii, Anto ǝmǝ ɔflɔ mintsyi mímbǝ kawunsiǝ, nya mɔmɔ nsi nlɛ budu lǝ kawunsiǝ kesu Anto ǝmǝ ɔflɔ.” ");
INSERT INTO lip_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Nya wǝ bakasebi lɛtɛyi wǝ nkǝ, “Mɔmɔɔ, efe alɛ etiki budi kakpasǝ wuee, insini lǝ akpa ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Mfe ko bote boǝ eyi lesa saa, nya yensife bǝ kuutsyuǝ saa si ɔtɔ fǝ etiki eto kasɔ. Nyamfo mate ǝtǝ bofo bɔnɔ boǝ Onanto ɔflɔ fétsyi.” ");
INSERT INTO lip_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Mfó Yesu lɛtɔ mǝ nkǝ, “Mɔmɔ alɛ befo bɛnɔ? ");
INSERT INTO lip_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Lefe lɛ bubǝ, nya díubǝ tsya lélo nǝ boosensǝ mi nya utsyuǝ saa luusu wǝ umǝ beyani mɔ mate bitsyǝ. Fɛɛ lǝ sitintii, yembuyifo mɔ mate. Itsyise Anto ǝmǝ si ko mɛ. ");
INSERT INTO lip_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ntɛyi mi nyamfo lǝ binyǝ diyuǝ se biyifo lɔni ku mɛ eso. Kawunsiǝ eto betidi ebutǝ binyǝ kanyi. Fɛɛ bińyǝ kekleke! Itsyise mbutǝkǝ kawunsiǝ kamfo kato!” ");
INSERT INTO lip_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Se Yesu lɛtɛyi mǝ nyamfo ólosǝǝ, óbesǝ ǝnǝmi kato nya ɔ́tɛyi nkǝ, “Nto, lefe nǝmǝ éboyo. Besǝ fǝ Ubi eto diye kato bǝ lǝ fǝ Ubi tsya lǝ obesǝ fǝ diye kato. ");
INSERT INTO lip_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Itsyise éfi ǝsuǝale kenke ǝtǝ wǝ lǝ kawunsiǝ eto betidi kenke ǝsuǝ bǝ mba kenke féfi fǝtǝ wǝǝ, lǝ utǝ mǝ nkpǝ manlo. ");
INSERT INTO lip_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Nya nkpǝ manlo ni bǝ lǝ betidi lǝ bate fǝ, fǝ nwǝ hã mate ni Onanto kosate ǝmǝ nya lǝ bate Yesu Kristo wǝ fátsyese. ");
INSERT INTO lip_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Mbesǝ fǝ diye kato nte lǝ betidi nti. Nya mínyifo keyifo ka fákpe mɛ lǝ kɔni fǝ nyifo lǝ kawunsiǝ mínlosǝ. ");
INSERT INTO lip_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Mɔmɔɔ, Nto, besǝ fǝ Ubi eto diyǝnde kato lǝ fǝ ǝnǝmi, diyǝnde nǝ ǝsuǝ mínkɛ ku fǝ fɛ béyifo kawunsiǝ. ");
INSERT INTO lip_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Ntǝ miǝ mba fǝlǝkǝ fǝtǝ mɛ lǝ kawunsiǝ eto betidi ntii, te fǝ. Fǝ bale beni nya féfi mǝ fǝtǝ mɛ nya bétsyue fǝ ditiki koto. ");
INSERT INTO lip_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Nya mɔmɔɔ, beyi bǝ lesa saa nǝ féfi fǝtǝ mɛɛ, etsyi fǝ ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Mfi kɛnyɛ ka fǝtǝ mɛ fǝ nsu ntɛyi mǝ nsuko mǝ nya báfo ke. Nya beyi sitinti bǝ fǝ ɔflɔ mintsyi, nya fǝ ni nwǝ létsyese mɛ. ");
INSERT INTO lip_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Nlɛ ola boto lǝ mǝ disi, minlɛ ola boto lǝ kawunsiǝ eto betidi kenke eto disi. Bomu lǝ mba féfi fǝtǝ mɛ eto disi, itsyise fǝ kosate eto bale beni. ");
INSERT INTO lip_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","“Mba kenke ni mɔ bale eyifo fǝ bale, nko ke fǝ bale tsya diyifo mɔ bale nɛ. Nya mɔ diyǝnde lébe kato ɛyɛ lǝ mǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Mɔmɔɔ, nlɛ fǝ ɔflɔ bubǝ. Minsibǝ lǝ kawunsiǝ mfo. Fɛɛ mǝǝ, besi bakpe lǝ ke. Anto Kɛnkɛ, fǝ kosate fi fǝ diye eto ǝsuǝale nnya fǝtǝ mɛ abe mǝ bǝ lǝ beyifo bani fe kase bo ku fǝ diyifo bani. ");
INSERT INTO lip_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Lefe nǝ mínkɛ lǝ mǝ ɔflɔɔ, nlɛ mǝ wɛkɛkɛkɛkɛ nya mínse mǝ ɛyɛ lǝ diye nǝ fǝtǝ mɛ ǝsuǝ. Nse mǝ, itǝ bǝ kuutsyuǝ saa mánnya lǝ mǝ nti, enso utidi wǝ ele bǝ onya kokooko, bǝ lǝ nnya báwɔni bákpe lǝ Awɔnisa Kɛnkɛ eto Kukue ǝsuǝ lǝ ibǝ itǝ. ");
INSERT INTO lip_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Nya mɔmɔɔ, nlɛ fǝ ɔflɔ bubǝ. Ntɛyi nyamfo lǝ kawunsiǝ bǝ lǝ mǝ tsya lǝ beyi kenke lǝ mǝ akɔɛsi ku mɔ disuǝyuǝ nǝ minlɛ bunyǝ. ");
INSERT INTO lip_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mbe fǝ ditiki nǝmǝ letsya ntǝ mǝ, nya benni kawunsiǝ kamǝ eto bale fe kase mintsya lenni kawunsiɛ kamfo eto ole ke. Lǝ nyasoo, kawunsiǝ kamǝ eekisi mǝ. ");
INSERT INTO lip_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","“Minlɛ bɔtɔ miǝ lǝkǝ mǝ lǝ kawunsiǝ kamǝ. Bomu nlɛ bɔtɔ miǝ lǝ ase mǝ, ǝlǝkǝ mǝ etsyiko Obuale ǝmǝ eto ani. ");
INSERT INTO lip_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Fe kase minni kawunsiǝ kamfo eto olee, nko ke mǝ tsya lenni kawunsiǝ kamfo eto bale nɛ. ");
INSERT INTO lip_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Yifo mǝ kɛnkɛ lǝ sitinti siamǝ ǝsuǝ, itsyise fǝ ditiki nǝmǝ eyifo sitinti. ");
INSERT INTO lip_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ntsyese mǝ kawunsiǝ fe kase fintsya létsyese mɛ kawunsiǝ seka. ");
INSERT INTO lip_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Lǝ mǝ esoo, nyifo mɔ ǝsuǝ kɛnkɛ ntǝ fǝ, bǝ lǝ mǝ tsya lǝ beyifo kɛnkɛ lǝ sitinti siamǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Minlɛ nyamfo bɔtɔ kǝtǝ mǝ mate, bomu nlɛ bɔtɔ kǝtǝ mba kenke loofo mɛ banɔ ɛyɛ lǝ fǝ Ditiki Sɛɛ nǝmǝ mǝ bɔɔtɛyi ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Anto, nlɛ bɔtɔ miǝ lǝ ǝtǝ bǝ lǝ beyifo bani fe kase fankpe lǝ mɛ nya mintsya nkpe lǝ fǝ ǝsuǝ. Tǝ lǝ beyifo bani ku bo bǝ lǝ kawunsiǝ eto betidi lǝ bafo banɔ bǝ fǝ uni létsyese mɛ. ");
INSERT INTO lip_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","“Ntǝ mǝ diyǝnde nǝ eto okle ke fǝtǝ bǝ lǝ mǝmblɛ lǝ beyifo bani fe kase bo fǝ diyifo bani. ");
INSERT INTO lip_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nkpe lǝ mǝ, nya fintsya nkpe lǝ mɛ. Tǝ lǝ beyifo bani kenke bǝ lǝ kawunsiǝ eto betidi lǝ bate bǝ fǝ létsyese mɛ nya faala mǝ fe kase faala mɛ. ");
INSERT INTO lip_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Anto, nla miǝ mba féfi fǝtǝ mɛ lǝ bǝsiǝ mɛ lǝ ɔflɔ lǝ kaka minsi bǝ lǝ bǝnyǝ mɔ diyǝnde, diyǝnde nǝ fǝtǝ mɛ itsyise ála mɛ fɛ béyifo kawunsiǝ. ");
INSERT INTO lip_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Anto Sɛɛ, kawunsiǝ eto betidi enyi fǝ, fɛɛ mɔ yi fǝ nya mba mfo tsya yi bǝ fǝ létsyese mɛ. ");
INSERT INTO lip_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ntǝ báte fǝ wuee, nya muutǝ besi bate fǝ eso nko, bǝ lǝ lelabi nǝ féfi fǝtǝ mɛɛ, lǝ lɛkɛ lǝ mǝ nya lǝ mintsya lǝ nkɛ lǝ mǝ.” ");
INSERT INTO lip_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Se Yesu léto ola ǝmfo ólosǝǝ, wǝ ku wǝ bakasebi édu mfó nya báyɛ lǝ Kidron eto utukplo bésu kaka nnuɛbi eto eyi eto ɔkuɛ kɛkɛ utsyuǝ lɛkɛ. Nya Yesu ku wǝ bakasebi dídufǝ mfó. ");
INSERT INTO lip_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yuda wǝ dídu wǝ utǝǝ, áte mfó itsyise lefe kpǝǝ, Yesu ku wǝ bakasebi ála disi busu kakpe mfó. ");
INSERT INTO lip_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Nyasoo, Yuda áyɛnko Romafɔ eto bamamanyǝ ku mba laase Disumuyo eto betsyuǝ, ba besumunyǝ ninǝ ku Farisifɔ létsyese nya ókpa mǝ úsuko ɔkuɛ kɛkɛ ǝmǝ. Bétsyi bemakǝ ku kakandiɛ ku atɛ. ");
INSERT INTO lip_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Se Yesu léte asa nnya kenke lǝǝbǝ wǝ bubǝ lǝ ǝsuǝ esoo, ɔ́bɔ úbǝ ótsyako mǝ nya ɔ́tɔ mǝ nkǝ, “Owoe bɛnlɛ bɔbɛbɛ?” ");
INSERT INTO lip_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Bǝtǝ mbuayɛ bǝnkǝ, “Yesu Nasaretnyǝ ǝmǝ.” Ɔ́tɛyi mǝ nkǝ, “Nyǝ mɔ ni wǝ mfo.” Yuda wǝ dídu wǝ útǝ tsya ńyǝ mǝ lenti. ");
INSERT INTO lip_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Lefe nǝ Yesu dítǝ mǝ mbuayɛ nkǝ, “Nyǝ mɔ ni wǝ mfoo,” bésinkli kama kama nya bédu bánɔ. ");
INSERT INTO lip_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Usi ɔ́tɔ mǝ nkǝ, “Owoe bɛnlɛ bɔbɛbɛ?” Bǝtǝ mbuayɛ bǝnkǝ, “Yesu Nasaretnyǝ ǝmǝ.” ");
INSERT INTO lip_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Mfó nya Yesu lɛtɛyi mǝ nkǝ, “Mɔ́tɛyi mi koko minkǝ, nyǝ mɔ ni wǝ mfoo. Nyaso lǝ mɔ uni bɛnlɛ bɔbɛbɛɛ, bitǝ lǝ mbamfo lǝ bedu.” ");
INSERT INTO lip_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ɔ́tɛyi nyamfo nko, bǝ lǝ lesa nǝ úkatɛyi kokoo, lǝ ibǝ itǝ sitinti nkǝ, “Nto, mányansǝ mba féfi fǝtǝ mɛ eto lɛ ɔni lǝ mǝnti.” ");
INSERT INTO lip_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Mfó Simon Petro dínǝ kalande nǝ untsyi úlǝkǝ lǝ akpatsya, nya ówe Usumunyǝ Ninǝ Kenke eto uyifoyifo eto kodianito úfǝ. Ndomunyǝ ǝmǝ eto diye ni Malko. ");
INSERT INTO lip_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Fɛɛ Yesu átɛyi Petro nkǝ, “Fi fǝ kalande kamǝ akpe lǝ akpatsya kafo! Bubu febu fǝ yanle bǝ nnǝ lesa nǝ nkpe lǝ kanyi eto lɛkɔbe nǝ mɔ Anto dítǝ mɛ?” ");
INSERT INTO lip_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Nyamfo eto kamaa, Romafɔ eto bamamanyǝ eto ditsyukpa ku mǝ ɔtɔnkotɔnko ku Yudafɔ eto batɔnkpe bǝtsyuǝ ǝmuǝ Yesu lǝ ǝsuǝale ǝsuǝ bákle. ");
INSERT INTO lip_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Tutɛɛ, bákpa wǝ bésuko Annas ɔflɔ. Annas ǝmfo eyifo Kayafa eto usiǝanto. Nya Kayafa ǝmfo ni Usumunyǝ Ninǝ Kenke wǝ díyifo kesumu eto keyifo lɛlɛ itǝ nǝmfó. ");
INSERT INTO lip_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayafa ǝmfo ni nwǝ lɛlɛ Yudafɔ eto beninǝ kɔlɛ nkǝ ɛlɛkɛ eso bǝ utidi ɔni kpǝ lǝ betidi ba tã eto kɛnyɛ. ");
INSERT INTO lip_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Petro ku okasebi bamba ǝtǝkǝko Yesu kama. Okasebi bamba ǝmfo eyifo Usumunyǝ Ninǝ Kenke eto utidiyiyi, nyaso wǝ dítǝkǝko Yesu bésu Usumunyǝ Ninǝ Kenke eto diyo, ");
INSERT INTO lip_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Fɛɛ Petroo, ǝńyǝ lǝ kesie. Okasebi bamba ǝmǝ ésinkli úbǝ údi etiki ku usiobi wǝ díńyǝ lǝ kesie kɛnyɛ mfó, nya útǝ nkǝ Petro tsya dufǝ lǝ diyo nǝmǝ kafo. ");
INSERT INTO lip_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Mfó nya usiobi ǝmǝ lɛtɔ Petro nkǝ, “Fintsya, osani ǝmfo eto bakasebi eto ɔni fenii, lee?” Mfó Petro dítǝ mbuayɛ nkǝ, “Owo, minni!” ");
INSERT INTO lip_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Nya se lɛyɔ nlɛ mǝ esoo, beyifobi ku mba laase mfó átsyaka ute nya bǝńyǝ banlɛ bɔyifǝ. Nya Petro tsya lɛnyi úsu úńyǝ lǝ mǝ ɔflɔ mfó ɔnlɛ ute ǝmǝ bɔyifǝ. ");
INSERT INTO lip_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Lefe nǝmfóo, Usumunyǝ Ninǝ Kenke ákatɔ Yesu asa itsyi lǝ wǝ bakasebi ku asa nnya waate ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesu ǝtǝ mbuayɛ nkǝ, “Meedi betidi ba tã etiki lǝ obia lǝ kusǝ komǝ kenke eto ǝnǝmi lefe saa. Maate asa lǝ Disumuyo ku lǝ ntsyakɔ kaka Yudafɔ kenke lǝǝbǝ katsya. Méndi etiki saa kulefe lǝ kabiɔkɔ. ");
INSERT INTO lip_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Nya beso ini mɔ fanlɛ etiki nyamfo bɔtɔ? Tɔ betidi bamfo lesa nǝ míntɛyi mǝ. Beyi lǝsanǝ míntɛyi.” ");
INSERT INTO lip_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Se Yesu lɛtɛyi nyamfo, mba laase mfó eto ɔni ko lɛsɔ wǝ lǝ kotosi nya ɔ́tɔ Yesu nkǝ, “Ntsyǝ feebu fɛ feedi Usumunyǝ Ninǝ Kenke ǝmǝ etiki nko?” ");
INSERT INTO lip_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesu ǝtǝ wǝ mbuayɛ nkǝ, “Lǝ ndi etiki bua ǝtsyuǝǝ, tɛyi utsyuǝ saa mfo lǝ ɔnɔ lesa nǝ ini. Fɛɛ lǝ méndi etiki bua saa, beso fásɔ mɛ?” ");
INSERT INTO lip_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Mfó nya Annas dífi Yesu wǝ disi ɔkɛ lǝ bokle lǝ ukuǝ ǝsuǝǝ, ótsyese Usumunyǝ Ninǝ Kenke Kayafa ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Lefe nǝmfóo, Simon Petro si uńyǝ mfó ɔlɛ ute bɔyifǝ. Nyaso bafɛfɛ ba díńyǝ mfó lɛtɔ wǝ bǝnkǝ, “Fintsya, ini osani ǝmǝ eto bakasebi eto ɔni fenii, lee?” Mfó Petro áni nya ɔ́tɛyi nkǝ, “Owo lo, minni mǝ ɔni!” ");
INSERT INTO lip_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Mfó nya Usumunyǝ Ninǝ Kenke eto ndomunyǝ ɔni eto ɔyimi wǝ eto koto Petro léwe lɛtɔ wǝ nkǝ, “Inni fǝ uni mínyǝ lǝ ɔkuɛ mfó lee?” ");
INSERT INTO lip_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Petro esi útudi kɛnyɛ ɔ́tɛyi nkǝ, “Owo lo!” Lamfolamfoo, nya ukusɛ dítǝ kɛnyɛ. ");
INSERT INTO lip_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Olesiǝnto ǝmfóo, bákpa Yesu lǝ Kayafa eto diyo bésuko Romafɔ eto Aba eto Unyɛsiǝ eto kǝsiǝkɔ. Fɛɛ Yudafɔ bamǝ méndufǝ mfó, itsyise bánla bǝ bakpe mǝ ǝsuǝ kɔfiɔ fɛ lǝ bedi Ukpǝ Ása Bo Ɔ́yila eto Diyisɛɛ nǝmǝ. ");
INSERT INTO lip_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Lǝ nyamfo esoo, Pilato ábɔ úbǝ ótsyako mǝ lǝ kesie kɛnyɛ mfó, nya ɔ́tɔ mǝ nkǝ, “Nte kabua ka osani ǝmfo díyifo?” ");
INSERT INTO lip_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Bǝtǝ wǝ mbuayɛ bǝnkǝ, “Lenni kabua kplɛ kukǝtsyuǝ úyifo, eni boǝmbokpa wǝ boboko fǝ ɔflɔ.” ");
INSERT INTO lip_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Nyaso Pilato átɛyi mǝ nkǝ, “Nyalɛ bekpa wǝ bisuko lǝ mi kosate lǝ bisu bekponko wǝ lekpo lǝ mi kosate eto afi ǝsuǝ.” Bǝtǝ mbuayɛ bǝnkǝ, “Bǝntǝ bo kusu bǝnkǝ bokponko kuutsyuǝ saa lekpo bolo wǝ dikpǝnkpi.” ");
INSERT INTO lip_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Asa nyamfo ǝbǝ nko bǝ lǝ lesa nǝ Yesu lɛtɛyi itsyi lǝ ukpǝ wǝ eto okle wǝǝbǝ bukpǝ lǝ ibǝ itǝ nko sitinti. ");
INSERT INTO lip_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Mfó nya Pilato dísinkli úsu údufǝ wǝ lekanyo mfó, nya ókpadi Yesu ɔ́tɔ wǝ nkǝ, “Fǝ ni Yudafɔ eto Oka ǝmǝ?” ");
INSERT INTO lip_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesu ǝtǝ wǝ mbuayɛ ɔ́tɔ wǝ nkǝ, “Fǝ kosate ete nlɛ mɛ etiki nyamfo bɔtɔ lee, betidi bamba lɛtɛyi fǝ nko itsyi lǝ mɛ ǝsuǝ?” ");
INSERT INTO lip_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato ǝtǝ mbuayɛ nkǝ, “Ebu fǝ Yudanyǝ mini? Mi kosate eto betidi ku besumunyǝ ninǝ dífi fǝ bákpe mɛ lɛ kɔni. Be féyifo?” ");
INSERT INTO lip_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesu ǝtǝ mbuayɛ nkǝ, “Mɔ sekakedikɔ mentsyi kasɔ mfo. Lǝ nya ete mɔ sekakedikɔ dítsyi kasɔ mfo ini, eni mɔ batɔnkpe ebota mɛ disi bǝlǝkǝ mɛ betsyiko Yudafɔ eto ani. Fɛɛ mɔ sekakedikɔ mentsyi kawunsiǝ mfo.” ");
INSERT INTO lip_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Se ɔ́tɛyi wǝ nko, Pilato átɔ wǝ nkǝ, “Nyalɛ Oka feni?” Mfó Yesu lɛtɛyi wǝ nkǝ, “Fǝ nlɛ bɔtɛyi fǝ Oka mini. Nyamfo eso bale mɛ mímbǝ kawunsiǝ nɛ, bǝ lǝ mbǝ nlǝkǝ sitinti siamǝ nte. Nya utsyuǝ saa ke lǝǝtǝkǝko sitinti siamǝǝ, aanɔ lesa nǝ maatɛyi.” ");
INSERT INTO lip_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato átɔ wǝ nkǝ, “Nya be ni sitinti siamǝ?” Se Pilato lɛtɛyi nyamfo ólosǝǝ, úsinkli úsu Yudafɔ ɔflɔ lǝ lekple nya ɔ́tɛyi mǝ nkǝ, “Mǝnnyǝ kabua saa lǝ wǝ ǝsuǝ lǝ nnya eso ele bǝ nlo wǝ dikpi. ");
INSERT INTO lip_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Fɛɛ lǝ mi lekpa ǝsuǝǝ, lǝ éyo Ukpǝ Ása Bo Ɔ́yila eto Diyi eto didifee, ele bǝ nlǝkǝ mba bákpe lǝ diyo eto ɔni ntǝ mi. Nyaso bela biǝ nyani Yudafɔ eto Oka ǝmǝ ntǝ mi?” ");
INSERT INTO lip_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Mfó nya mǝmblɛ léfã bátɛyi bǝnkǝ, “Owo lo! Inni nwǝ mfo, bomu Baraba!” Nya Baraba ǝmfo eyifo nwǝ létaka úńyǝ lǝ aba ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Nyaso Pilato ǝtǝ bákpa Yesu bédunko nya báblɛ wǝ fefe ku katambo. ");
INSERT INTO lip_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Nya bamamanyǝ bamǝ dífi biyu eto kalɛmɛ béyifo lekpakpa béti wǝ lǝ disi. Nya béfi kafia sia béti wǝ fe Oka seka. ");
INSERT INTO lip_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Nya lǝ bányi bésu wǝ ɔflɔɔ bákatɛyi wǝ bǝnkǝ, “Yuu, yuuduu! Yudafɔ eto Oka o-o!” Nya lǝ bátɛyi wǝ nkoo, bákanyi kafi wǝ kasɔ wǝ lǝ atosi. ");
INSERT INTO lip_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato esi ɔ́bɔ úsu sitiditu nǝmǝ ɔflɔ lǝ lekple nya ɔ́tɛyi mǝ nkǝ, “Bebe, mookpa wǝ mboko mi lǝ bete biǝ mǝnnyǝ kabua saa ka úyifo bǝ lǝ nlo wǝ dikpǝnkpi.” ");
INSERT INTO lip_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Nyaso Yesu ábɔ úbǝ lekple mfó, ku biyu eto lekpakpa lǝ wǝ disi nya onkpe awusia kǝntsyɛ. Mfó Pilato átɛyi mǝ nkǝ, “Bebe! Nyǝ utidi ǝmǝ ńyǝ mfo!” ");
INSERT INTO lip_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Se besumunyǝ ninǝ ku mba laase Disumuyo dínyǝ wǝǝ, báfa bátɛyi bǝnkǝ, “Sɔ wǝ amanklasǝ lǝ uyikabie ǝsuǝ! Sɔ wǝ amanklasǝ lǝ uyikabie ǝsuǝ!” Pilato átɛyi mǝ nkǝ, “Mi kosate kpa wǝ bisuko, lǝ bisu bɛsɔ wǝ lǝ uyikabie ǝsuǝ. Mǝnnyǝ lebua saa lǝ wǝ ǝsuǝ nǝ eso moolo wǝ dikpǝnkpi.” ");
INSERT INTO lip_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Yudafɔ bamǝ ǝtǝ mbuayɛ bǝnkǝ, “Bokpe kɔfi ko léte nkǝ ele bǝ ukpǝ. Itsyise ɔ́tɛyi nkǝ uyifo Onanto eto Ubi.” ");
INSERT INTO lip_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Lefe nǝ Pilato lɛnɔ nnya bátɛyi mfoo, sikpi esi símuǝ wǝ sekpe. ");
INSERT INTO lip_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Usinkli údufǝ lekayo nǝmǝ nya ɔ́tɔ Yesu nkǝ, “Se fetsyi?” Fɛɛ Yesu mǝntǝ wǝ mbuayɛ saa. ");
INSERT INTO lip_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilato átɔ wǝ nkǝ, “Nyalɛ, bɔni fani fǝ embudiko mɛ etiki? Lee enyi fǝ nkpe ǝsuǝale moofo butǝ miǝ bayani fǝ nye basɔ fǝ lǝ uyikabie ǝsuǝ?” ");
INSERT INTO lip_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesu ǝtǝ wǝ mbuayɛ nkǝ, “Eni embɔkɛ ǝsuǝale saa lǝ mɔ ǝsuǝ lenni Onanto dítǝ fǝ nnya. Nya ǝmǝ eso nwǝ dífi mɛ ókpe fǝ lǝ kɔni díyifo lebua enso fǝ nɛ.” ");
INSERT INTO lip_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Se Pilato lɛnɔ nyamfoo, ɔ́bɛbɛ kusu nkǝ eni lǝ oyani wǝ. Fɛɛ betidi bamǝ áfa bembembe bátɛyi bǝnkǝ, “Lǝ ayani wǝǝ, nyalɛ ensini Romafɔ eto Okankplɛ eto ɔyɛtsyuǝ! Utsyuǝ saa wǝ dífi wǝ ǝsuǝ úyifo oka, átaka úńyǝ lǝ Romafɔ eto Okankplɛ Kaisare ǝsuǝ!” ");
INSERT INTO lip_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Se Pilato lɛnɔ etiki nyamfoo, ókpa Yesu ɔ́bɔnko nya úsiǝ lǝ lekpokpomɛ ǝsuǝ lǝ kaka baakpo bǝ leba eto kasɔ nya baakpo bǝ Gabata lǝ Hebri eto sele ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Diyi nǝmǝ éyifo fe kakɔmi eto lefosi ǝnuǝ eti lǝ diyi nǝ eto kǝsiǝsǝ boodi Ukpǝ Ása Bo Ɔ́yila eto diyi. Nya Pilato lɛtɛyi betidi bamǝ nkǝ, “Nyǝ mi Oka!” ");
INSERT INTO lip_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Báfa bátɛyi bǝnkǝ, “Lo wǝ! Lo wǝ! Sɔ wǝ lǝ uyikabie ǝsuǝ!” Pilato átɔ mǝ nkǝ, “Bela biǝ nsɔ mi oka ǝmǝ mmanklasǝ lǝ uyikabie ǝsuǝ?” Mfó nya besumunyǝ ninǝ dítǝ wǝ mbuayɛ benkǝ, “Bunsibǝ oka saa enso Romafɔ eto Okankplɛ Kaisare!” ");
INSERT INTO lip_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Se bátɛyi wǝ nkoo, Pilato áyani Yesu útǝ bamamanyǝ nkǝ basɔ wǝ lǝ uyikabie ǝsuǝ. Nyaso bákpa Yesu bédunko. ");
INSERT INTO lip_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Bǝtǝ wǝ kosate étsyi wǝ uyi ǝmǝ úsu údufu kaka baakpo Ditidisi Ku Kalua. Baakpo mfó lǝ Hebri eto sele bǝ Golgata. ");
INSERT INTO lip_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Mfó básɔ wǝ lǝ uyikabie ǝsuǝ. Básɔ betidi inuǝ bamba tsya lǝ mǝ keyikabie bamba ǝsuǝ bakɔ ku wǝ, ɔni lǝ Yesu eto kǝmǝni nya unuǝfǝ lǝ wǝ kodiani. ");
INSERT INTO lip_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato áwɔni etiki ǝtsyuǝ útǝ béfi básɔ lǝ uyi ǝmǝ ǝsuǝ lǝ Yesu eto disi kato. Nnya báwɔni ni bǝ, “Yesu Nasaretnyǝ, Yudafɔ Eto Oka Ǝmǝ.” ");
INSERT INTO lip_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Yudafɔ kpǝ ákla etiki nyamfo, itsyise kaka básɔ Yesu bamanklasǝ lǝ uyikabie mantsyo ku umǝnkplɛ ǝmǝ. Báwɔni asa nyamǝ lǝ Hebri ku Roma ku Griki eto bele ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Besumunyǝ ninǝ áni etiki nyamfo nya bátɛyi Pilato bǝnkǝ, “Manwɔ ni fǝnkǝ, ‘Yudafɔ eto Oka,’ bomu wɔni fǝnkǝ, ‘Utidi ǝmfo átɛyi nkǝ, “Mɔ ni Yudafɔ eto Oka.” ’ ” ");
INSERT INTO lip_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Mfó Pilato dítǝ mbuayɛ nkǝ, “Lesa nǝ míwɔnii, mbɔwɔni nlosǝ.” ");
INSERT INTO lip_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Se bamamanyǝ bamǝ lɛsɔ Yesu lǝ uyikabie bálosǝǝ, béfi wǝ awu nnya ókpe nya bésie nnya lǝ akpa ana. Nya utsyuǝ saa dífi lekpa lɔni. Fɛɛ wǝ awu ani ébu. Awu nyamfoo, bánka nnya kukalebe saa, bomu budi bédi nnya idu lǝ simuǝ isu ekpo lǝ akpa eti. ");
INSERT INTO lip_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Bamamanyǝ bamǝ átɛyi mǝ bǝtsyuǝ bǝnkǝ, “Boembusie awu nyamfo bǝtsyuǝ. Bomu bitǝ lǝ bokpo asa bɔsɛ lǝ bobe futsyǝ luudi lǝ bufi nnya butǝ wǝ.” Nyamfo ǝbǝ itǝ nko bǝ nnya báwɔni bákpe lǝ Awɔnisa Kɛnkɛ eto Kukue ǝsuǝǝ, ǝbǝ itǝ nko sitinti bǝ, “Bésie mɔ awu bǝtǝ bǝtsyuǝ. Nya bákpo asa basɛɛ lǝ mɔ awu ǝsuǝ.” Nya lǝ sitinti tsyaa, nko bamamanyǝ bamǝ díyifo nɛ. ");
INSERT INTO lip_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Nya mba díńyǝ lǝ Yesu eto uyikabie komǝ ɔflɔ ni Yesu eto ambe ku wǝ ambe eto ɔyimisio ku Maria wǝ ni Klopa eto usiǝ, ku Maria Magdalenyǝ. ");
INSERT INTO lip_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Se Yesu dínyǝ wǝ ambe ku wǝ okasebi wǝ eto asa waala tinti ńyǝ mfóo, ɔ́tɛyi wǝ ambe nkǝ, “Mbe, nnyǝ fǝ ubi!” ");
INSERT INTO lip_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Mfó nya ɔ́tɛyi okasebi ǝmǝ tsya nkǝ, “Nnyǝ fǝ ambe.” Nyaso idu lǝ lefe nǝmfóo, okasebi ǝmǝ ákpa wǝ úsuko wǝ diyo nya ɔ́lɛ wǝ ola. ");
INSERT INTO lip_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yesu áte nkǝ mɔmɔɔ, wóolosǝ lesa saa nǝ ele bǝ uyifo. Nya, bǝ lǝ lesa nǝ báwɔni bákpe lǝ Awɔnisa Kɛnkɛ eto Kukue ǝsuǝ lǝ ibǝ itǝ nko esoo, Yesu átɛyi nkǝ, “Utukɔɛ lɛ mɛ.” ");
INSERT INTO lip_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Lǝ mfóo, ɔlɔtsyi utsyuǝ ǝtsyǝ mfó wǝ béyisǝ ku nte bo dínyǝnki. Nyaso béfi sekuayɛbo bákpe lǝ nte bomǝ ǝsuǝ nya béfi bákle lǝ uyi utsyuǝ wǝ baakpo hisopo ǝsuǝ bábesǝ kato bǝtǝkǝ wǝ lǝ kɛnyɛ. ");
INSERT INTO lip_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Se Yesu dínǝ nte bomǝ ólosǝǝ, ɔ́tɛyi nkǝ, “Mɔmɔɔ, yóolo!” Nya óbokosǝ wǝ disi kasɔ, nya ɔ́ma kɛnyɛ. ");
INSERT INTO lip_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Diyi nǝmfo eyifo Fida, nya ni kǝsiǝsǝ eyifo Ɔnwɛditsyǝyi kplɛ itǝ Yudafɔ, nyaso bánla bǝ bekpǝnkpǝ kɛ bafaka lǝ uyikabie ǝsuǝ eyo Ɔnwɛditsyǝyi mfó. Nyaso bátɔ Pilato bǝ utǝ mǝ kusu lǝ besu bǝfǝsǝ mǝ akpa lǝ bǝlǝkǝ mǝ betsyiko lǝ uyikabie ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Itǝ bamamanyǝ bamǝ ǝbǝ bǝfǝsǝ utidi tutɛ ku nwǝ nse eto akpa. Mǝ básɔ báfakasǝ lǝ keyikabie ǝsuǝ lǝ Yesu ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Fɛɛ se báyo Yesu ɔflɔɔ, bǝnyǝ bǝ wǝ ébukpǝ koko. Nyaso bénsifǝsǝ wǝ akpa. ");
INSERT INTO lip_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Bomu omamanyǝ ɔni éfi wǝ lefle óto wǝ lǝ lekpake. Lamfolamfo kɔtɔ ku ntu ko lɛbɔ. ");
INSERT INTO lip_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Nwǝ dínyǝ asa nyamfo, wǝ dídi nnya adansiɛ bǝ lǝ mi tsya lǝ befo bɛnɔ. Nya nnya ɔ́tɛyi eyifo sitinti. Nya uyi wuee nkǝ sitinti ini ɔ́tɛyi. ");
INSERT INTO lip_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Béyifo nyamfo bǝ lǝ nnya nkpe lǝ Awɔnisa Kɛnkɛ eto Kukue ǝsuǝ lǝ ibǝ itǝ fe kase báwɔni bǝnkǝ, “Lɛ wǝ dikubi lɔni kulaa tsyaa, bembufǝsǝ ni.” ");
INSERT INTO lip_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Nya báwɔni asa bamba bákpe lǝ Awɔnisa Kɛnkɛ eto Kukue ǝsuǝ tsya nlɛ bɔtɛyi nkǝ, “Betidi ebotakasǝ ǝnǝmi babe nwǝ eto lekpake báse lefle bédunsǝ.” ");
INSERT INTO lip_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Nyamfo eto kamaa, Yosef wǝ ditsyi umǝ wǝ baakpo Arimatia, ǝbǝ ɔ́tɔ Pilato nkǝ lǝ oyani Yesu eto ɔkɔ utǝ wǝ. Yosef ǝmfo eyifo Yesu eto okasebi utsyuǝ. Fɛɛ wóanla nkǝ betidi te, itsyise úkate Yudafɔ eto beninǝ sikpi eso. Pilato átɔnɔ útǝ wǝ. Nyaso Yosef ǝbǝ ófo ɔkɔ ǝmǝ údunko. ");
INSERT INTO lip_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemo wǝ lɛbiɔ úsu Yesu ɔflɔ ketsye kani tsya ǝtǝkǝko Yosef ǝmfo. Útsyi afa nnya beefi kalɔ ɔkɔ itǝ busu kebikǝ, fe uyudu ku afa nnya laanyi fifiifi baakpo bǝ alɔɛ, nya nyamblɛ eto kalende eboyo kilo awosi ǝtsyǝ, úsuko. ");
INSERT INTO lip_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Betidi inuǝ bamfo éfi afa nyamfo bédiki Yesu eto ɔkɔ ǝmǝ lǝ ǝsuǝ nya béfi kafia flubia ka lefo koya bémli wǝ lǝ ǝsuǝ fe kase Yudafɔ díkalɔ ɔkɔ itǝ bubikǝ. ");
INSERT INTO lip_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Nya ɔkɔɛ kɛkɛ utsyuǝ akɛ lǝ kaka bálo Yesu ɔflɔ. Nya lǝ mfóo, béku kudi fɔfɔ ko kafo bembikǝtɔ kuutsyuǝ bǝnyǝ. ");
INSERT INTO lip_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Se diyi nǝmfo eto kǝsiǝsǝ luudi Ɔnwɛditsyǝyi nya kudi komǝ tsya lɛfi mfó esoo, béfi Yesu eto ɔkɔ ǝmǝ bésu bébikǝ mfó. ");
INSERT INTO lip_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Kɔsida eto kolensiǝnto se kale dímǝnsiǝ tɔ kaloo, Maria Magdalene ésu kudi komǝ ɔflɔ nya únyǝ nkǝ báminansǝ leba nǝ díti lǝ kudi komǝ kɛnyɛ mfó. ");
INSERT INTO lip_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Nyaso útsyetsyi úsu Simon Petro ku okasebi wǝ Yesu laala ɔflɔ. Nya ɔ́tɛyi mǝ nkǝ, “Bǝtsyǝ ǝbǝ bétsyi Bonamute bédunko lǝ kudi komǝ kafo. Nya bunyi kaka bétsyi wǝ bésu bǝtsyǝ!” ");
INSERT INTO lip_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Mfó nya Petro ku okasebi ɔni ǝmǝ dídu bǝ beesu kudi komǝ ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Mǝ inuǝ bamǝ étsyetsyi batɔ, fɛɛ okasebi ǝmǝ áfe Petro nya oka wǝ kudi komǝ ɔflɔ mfó budufǝ. ");
INSERT INTO lip_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Úbǝ kasɔ útsyue ǝnǝmi óbe kudi komǝ kafo. Únyǝ mfia flubia bomǝ, fɛɛ wéndufǝ ko kafo. ");
INSERT INTO lip_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simon Petro wǝ dítǝkǝ kama ubǝǝ, áyɛ údufǝ kudi komǝ kafo nya únyǝ se mfia flubia bomǝ nkpo lǝ kudi kafo lǝ kasɔ mfó. ");
INSERT INTO lip_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Fɛɛ béfi kafia ka béfi bákle Yesu disi bǝtsyǝ lete, ke mánkɔ ku mfia flubia fɛfɛ bomǝ. Bǝkǝnǝ ke bǝtsyǝ lete. ");
INSERT INTO lip_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Mfó nya okasebi wǝ leka kudi komǝ ɔflɔ búdufǝ tsya dídufǝ ko kafo. Únyǝ asa nyamǝ, nya ófo ɔ́nɔ. ");
INSERT INTO lip_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Tsya, fɛɛ bánnɔ tɔ kasɔ nnya Awɔnisa Kɛnkɛ lɛtɛyi nkǝ ele bǝ Yesu taka utsyi ɔkɔmǝ ubǝ nkpǝ. ");
INSERT INTO lip_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Nyamfo eto kama nya bakasebi bamǝ dísinkli bésu oto. ");
INSERT INTO lip_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Fɛɛ Maria ǝbǝ únyǝ lǝ kudi komǝ ɔflɔ kewi keku. Nya lefe nǝ úńyǝ mfó ɔnlɛ keku buwii, usi úbǝ kasɔ óbe kudi komǝ kafo. ");
INSERT INTO lip_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Mfó únyǝ Onanto eto batɔnkpe inuǝ ba nlɛ mfia flubia bensi lǝ kafo mfó. Ɔni si lǝ kaka Yesu eto disi dítsyǝ nya unuǝfǝ nsi lǝ wǝ akpa eti. ");
INSERT INTO lip_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Bátɔ wǝ bǝ, “Boambe, beso fanlɛ keku buwi?” Mfó nya Maria tsya dítǝ mbuayɛ nkǝ, “Bǝtsyǝ ǝbǝ bétsyi mɔ Onamute bedunko, nya mante kaka bétsyi wǝ besuko!” ");
INSERT INTO lip_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Lamfolamfo se ɔ́tsyi ɔwuninsǝǝ, únyǝ se Yesu nyǝ mfó. Fɛɛ woante nkǝ Yesu uni. ");
INSERT INTO lip_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Mfó Yesu lɛtɔ wǝ nkǝ, “Boambe, beso fanlɛ keku buwi? Owoe fanlɛ bɔbɛbɛ?” Fɛɛ úbu nkǝ, nwǝ laabe mfó uni, nyaso ɔ́tɛyi wǝ nkǝ, “Boanto, lǝ fǝ uni dítsyi wǝ fédunko, nyalɛ tɛyi mɛ kaka fétsyi wǝ fésuko lǝ nsu ntsyi wǝ ndunko.” ");
INSERT INTO lip_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Nya Yesu lékpadi wǝ nkǝ, “Maria!” Ɔ́tsyi ɔwuninsǝ útǝ ǝnǝmi Yesu nya ókpadi wǝ lǝ Hebri eto sele ǝsuǝ nkǝ, “Rabuni!” Eto kasɔ ni Oteasa. ");
INSERT INTO lip_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Mfó Yesu lɛtɛyi wǝ nkǝ, “Sinkli ayɛ mɛ butidi etɔ, itsyise ménsinkli tɔ nsu Anto ǝmǝ ɔflɔ kato. Bomu du esu atɛyi mɔ bayimi fǝ nsinkli ntɔ lǝ nwǝ ni mɔ Anto ku mǝ Anto, mɔ Onanto ku mǝ Onanto ɔflɔ.” ");
INSERT INTO lip_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Nyasoo, Maria Magdalenyǝ ésu ɔ́tɛyi bakasebi bamǝ nkǝ únyǝ Bonamute ǝmǝ nya ɔ́tɛyi mǝ asa nnya Yesu lɛtɛyi wǝ. ");
INSERT INTO lip_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Kɔsida komǝ eto ditsyitsyo lefee, bakasebi bamǝ ákɔ besi lǝ diyo nya béti mǝ ǝsuǝ bákpe kekleke, se banlɛ Yudafɔ eto beninǝ sikpi bote eso. Nya Yesu díbǝ unyǝ lǝ mǝ ntinti, nya ɔ́tɛyi mǝ nkǝ, “Diyuǝ lǝ disiǝko mi.” ");
INSERT INTO lip_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Se ɔ́tɛyi nyamfo ólosǝǝ, úfi wǝ ani ku lekpake óte mǝ. Ǝsuǝ ǝyuǝ bakasebi bamǝ se bǝńyǝ Bonamute ǝmǝ eso. ");
INSERT INTO lip_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Nnya kamaa, Yesu esi ɔ́tɛyi mǝ nkǝ, “Diyuǝ lǝ disiǝko mi. Fe kase Anto ǝmǝ létsyese mɛɛ, nko ke mintsya nlɛ mi botsyese nɛ.” ");
INSERT INTO lip_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Se ɔ́tɛyi nyamfo ólosǝǝ, ɔ́wula ókpo lǝ mǝ nya ɔ́tɛyi mǝ nkǝ, “Befo Lɛwɔnɔ Kɛnkɛ nǝmǝ. ");
INSERT INTO lip_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Lǝ bifi betidi eto abua bɛtsyɛ mǝǝ, Onanto éfi nnya ɔ́tsyɛ mǝ, fɛɛ mba eto abua bɛni bufi katsyɛɛ, Onanto tsya mémfi nnya ɔtsyɛ mǝ.” ");
INSERT INTO lip_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Lefe nǝ Yesu díbǝǝ, Toma, lefosi bakasebi inuǝ bamǝ eto ɔni wǝ bensi baakpo Ɔfimfinyǝǝ, mankɛ mǝ lenti. ");
INSERT INTO lip_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Nyaso se úbǝǝ, bakasebi fɛfɛ bamǝ átɛyi wǝ bǝnkǝ, “Búnyǝ Bonamute ǝmǝ.” Mfó nya Toma lɛtɛyi mǝ nkǝ, “Lǝ mǝnnyǝ belakabi eto afabe lǝ wǝ ani bǝ lǝ mfi mɔ lɛnimi inkpe lǝ nnya kafo nya mimfi mɔ kɔni minkpe lǝ wǝ lekpakee, mǝmbofo nnɔ kulefe.” ");
INSERT INTO lip_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Kɔsida kɔni eto kamaa, bakasebi bamǝ esi bákɔ bési lǝ diyo kafo, nya Toma ákɛ mǝ lenti. Besi béti biku le diyo nǝmǝ ǝsuǝ bakɛ. Tsya fɛɛ, Yesu ǝbǝ úńyǝ lǝ mǝ ntinti nya ɔ́tɛyi nkǝ, “Diyuǝ lǝ disiǝko mi.” ");
INSERT INTO lip_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Nya ɔ́tɛyi Toma nkǝ, “Bǝ lǝ ǝbǝ efi fǝ lɛnimi akpe mfo, lǝ abe mɔ ani. Lǝ efi fǝ kɔni akpe lǝ mɔ lekpake, lǝ ayɛ fǝ mamfokanɔ, nya lǝ afo anɔ!” ");
INSERT INTO lip_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomasi ǝlǝkǝ kɛnyɛ ɔ́tɛyi nkǝ, “Mɔ Onamute ku mɔ Onanto!” ");
INSERT INTO lip_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Mfó nya Yesu lɛtɛyi wǝ nkǝ, “Se fǝnyǝ mɛ esoo, áfo ánɔ. Diyuǝ itǝ mba dímǝnyǝ mɛ, fɛɛ báfo bánɔ!” ");
INSERT INTO lip_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu esi úyifo ayanisa kpǝ óte lǝ wǝ bakasebi kpǝ eto ǝnǝmi nnya báwɔni bákpe lǝ kukue komfo. ");
INSERT INTO lip_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Fɛɛ báwɔni nyamfo bǝtsyǝ bǝ lǝ befo bɛnɔ biǝ Yesu ni Nwǝ Onanto Lékpo Ɔhile Utsyǝ ku Onanto eto Ubi kosate ǝmǝ. Nya ɛyɛ lǝ boofo kanɔ lǝ wǝ ǝsuǝǝ, biunyǝ nkpǝ manlo. ");
INSERT INTO lip_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Nyamfo eto kamaa, Yesu esi úlǝkǝ wǝ ǝsuǝ óte wǝ bakasebi lǝ Tiberia eto Ditumbukplɛ ɔflɔ. Nya nyǝ kase íbǝ. ");
INSERT INTO lip_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Diyi lɔnii, Yesu eto bakasebi bǝtsyuǝ átsya besi. Mǝ ni Simon Petro ku Tomasi nwǝ tsya bensi baakpo Ɔfimfinyǝ ku Nataniel nwǝ ditsyi Kana lǝ Galilea eto kasɔ ku Sebedeo eto bebi ku Yesu eto bakasebi bamba. ");
INSERT INTO lip_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Mfó nya Simon Petro lɛtɛyi mǝ nkǝ, “Meesu nta asabu lǝ mbǝ.” Mfó nya mǝ tsya lɛtɛyi wǝ bǝnkǝ, “Bontsya ebutǝkǝko fǝ busu.” Nyaso bésu bédufǝ lǝ ɔklɔ ǝsuǝ nya bédu bésu. Fɛɛ lǝ ketsye ka kenkee, bǝnlǝkǝ akpɛ saa. ");
INSERT INTO lip_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Nya lefe nǝ kofe lela koǝ koatoo, Yesu ǝbǝ úńyǝ lǝ ditimbu nǝmǝ kɛnyɛ. Fɛɛ bakasebi bamǝ mǝnnyǝ wǝ bǝtsyǝ lekpo. ");
INSERT INTO lip_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Nya ɔ́tɔ mǝ nkǝ, “Bakosobi, bíǝnlǝkǝ akpɛ saa lee?” Bǝtǝ mbuayɛ bǝnkǝ, “Owo lo!” ");
INSERT INTO lip_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Nya ɔ́tɛyi mǝ nkǝ, “Beta mi asabu nyamǝ bekpo lǝ ɔklɔ ǝmǝ eto kodiani, lǝ binyǝ lesaatsyuǝ bilǝkǝ.” Nyaso béyifo nko. Binǝ bia bǝlǝkǝ efui bǝǝ, bamfo asabu nyamǝ bunǝ kǝlǝkǝ. ");
INSERT INTO lip_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Okasebi wǝ eto asa Yesu laala átɛyi Petro nkǝ, “Bonamute uni!” Se Simon Petro lɛnɔ nkǝ Bonamute unii, úfi wǝ awukɛntsyɛ ótsyasǝ lǝ nkɛ, itsyese úlǝkǝ nnya utsyǝ, nya ósa údufǝ lǝ ntu bomǝ ǝsuǝ tuu. ");
INSERT INTO lip_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Fɛɛ bakasebi fɛfɛ bamǝ ǝsiǝ lǝ ɔklɔ ǝmǝ balɛ bubǝ, balɛ asabu nnya díyi ku akpɛ bunǝ. Bántsyonko utuflɔ, yuutsyǝ fe akpalǝkǝlǝkǝ kolofa. ");
INSERT INTO lip_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Se bábɔ lǝ ɔklɔ ǝmǝ kafo bǝńyǝ kasɔɔ, bǝnyǝ se bátsyaka aka eto ute wǝ ǝsuǝ bákpe akpɛ ǝtsyuǝ. Abolo utsyuǝ tsya ǝtsyǝ mfó. ");
INSERT INTO lip_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Nya Yesu lɛtɛyi mǝ nkǝ, “Bifi akpɛ ǝtsyuǝ nnya bílǝkǝ mɔmɔ beboko.” ");
INSERT INTO lip_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Mfó nya Simon Petro dísu údufǝ lǝ ɔklɔ ǝmǝ nya únǝ asabu nnya díyi ku akpɛ nnya lɛmɔ óboko ketu kɛnyɛ. Akpɛ nyamǝ eto etu ni kolofa awosi anɔ ǝtsyǝ. Ite bǝ akpɛ nyamǝ efui nko tsyaa, asabu nyamǝ mánla. ");
INSERT INTO lip_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Lǝ nyamfo eto kamaa, Yesu átɛyi mǝ nkǝ, “Bibǝ bidi lesa.” Fɛɛ bakasebi bamǝ eto kuutsyuǝ mámfo ɔkɔɛ bokpe katɔ wǝ nkǝ, “Owoe feni?” Itsyise báte bǝ Bonamute uni. ");
INSERT INTO lip_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Nyaso Yesu ésu mǝ ɔflɔ nya úfi abolo ǝmǝ útǝ mǝ. Nko ke úfi akpɛ nyamǝ tsya útǝ mǝ nɛ. ");
INSERT INTO lip_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Nyamfo ni ditsyǝfǝ se Yesu dílǝkǝ wǝ ǝsuǝ óte wǝ bakasebi se bátakasǝ wǝ betsyiko ɔkɔmǝ nɛ. ");
INSERT INTO lip_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Se bédi lesa bálosǝ, Yesu átɔ Simon Petro nkǝ, “Simon, Yohanes eto ubi, aala mɛ aso kase bafɛfɛ bamfo laala mɛ?” Útǝ mbuayɛ nkǝ, “Ee, Bonamute! Fǝ kosate yi fǝnkǝ maala fǝ.” Mfó nya Yesu lɛtɛyi wǝ nkǝ, “Lɛ mɔ basamubi ola.” ");
INSERT INTO lip_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Lǝ nyamfo eto kamaa, Yesu esi ɔ́tɔ wǝ dinuǝfǝ nkǝ, “Simon, Yohanes eto ubi, aala mɛ?” Petro esi útǝ wǝ mbuayɛ nkǝ, “Ee, Bonamute! Fǝ kosate yi fǝnkǝ maala fǝ.” Mfó Yesu disi ɔ́tɛyi wǝ nkǝ, “Lɛ mɔ basamu ola!” ");
INSERT INTO lip_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yesu esi ɔ́tɔ wǝ ditsyǝfǝ nkǝ, “Simon, Yohanes eto ubi, aala mɛ?” Bɔtɔ bomfo ǝlǝ Petro, itsyise ditsyǝfǝ sɔ̃ɔ̃ ni nǝmfo nɛ se Yesu lɛtɔ wǝ nkǝ, “Aala mɛ?” Nyaso ɔ́tɛyi Yesu nkǝ, “Bonamute, eyi lesa saa. Nya fǝ kosate nyi fǝnkǝ maala fǝ!” Mfó nya Yesu lɛtɛyi wǝ nkǝ, “Lɛ mɔ basamu ola. ");
INSERT INTO lip_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Sitinti minlɛ fǝ bɔtɛyi minkǝ, lefe nǝ fedi okosobii, ákafo kafia buti fǝ kosate kesu kaka ke fála. Fɛɛ lefe nǝ fákabee, ebobesɛ fǝ ani kato nya utidi bamba luubǝ okle fǝ kafia fɛ wookpa fǝ usuko kaka fanla fǝ eesu.” ");
INSERT INTO lip_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesu átɛyi nyamfo nko lǝ ufi ulǝkǝ ukpǝ wǝ eto okle Petro lǝǝbǝ bukpǝ wǝ luulǝkǝ Onanto eto diyǝnde ote. Nyamfo eto kamaa, Yesu átɛyi wǝ nkǝ, “Tǝkǝko mɛ.” ");
INSERT INTO lip_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Se Petro lɛtsyi ɔwuninsǝǝ, únyǝ se okasebi wǝ Yesu laala ńyǝ wǝ kama. Wǝ ni okasebi wǝ dísiǝ ɔkpiɔ Yesu, lǝ lefe nǝ békedi ditsyitsyosa fɛfɛ fɛ ɔ́tɔ Yesu nkǝ, “Bonamute, owoe luudu fǝ utǝ?” ");
INSERT INTO lip_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Nyaso se Petro dínyǝ wǝǝ, ɔ́tɔ Yesu nkǝ, “Bonamute, ntsyǝ ini lǝ wǝ ǝsuǝ?” ");
INSERT INTO lip_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesu ǝtǝ wǝ mbuayɛ nkǝ, “Lǝ nla miǝ usiǝ nkpǝ isu ese lefe nǝ muusinkli mbǝ bioo, be eka fǝ ela? Fǝǝ, tǝkǝko mɛ!” ");
INSERT INTO lip_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Etiki nyamfo ába ékpo lǝ mba ntǝkǝko Yesu kama nti bǝ okasebi ǝmfo ǝmbǝ bukpǝ. Fɛɛ Yesu mántɛyi wǝ nkǝ wǝǝmbukpǝ. Nnya ɔtɛyi ni nkǝ, “Lǝ nla miǝ usiǝ nkpǝ isu ese lefe nǝ muubǝǝ, be eka fǝ ela?” ");
INSERT INTO lip_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Wǝ ni okasebi wǝ nlɛ adansiɛ budi lǝ asa nyamfo ǝsuǝ, nya wǝ tsya ni nwǝ lɛwɔni nnya utsyǝ nɛ. Nya buyi boǝ nnya ǝsuǝ údi adansiɛɛ, eyifo sitinti. ");
INSERT INTO lip_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesu esi úyifo asa bamba kpǝ tsya. Lǝ nnya ete báwɔni nyamblɛ bǝtsyǝ lɔni lɔni lɔnii, mfo nnɔ miǝ eni bembunyǝ ekue nyamǝ eto kǝtsyǝkɔ lǝ kawunsiǝ kamfo kenke kulaa tsya. ");
INSERT INTO lip_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Mɔyimisani Tiofilo, lǝ mɔ kukue tutɛ ko míwɔnii, ntɛyi asa nnya kenke Yesu díyifo idu lǝ lefe nǝ útsyǝ wǝ keyifo ku asatete kasɔ isu ese lefe nǝ Anto Onanto díbǝ ókpa wǝ úsuko kato. Fɛ wookpa wǝ usuko katoo, Yesu áyɛ lǝ Lɛwɔnɔ Kɛnkɛ eto ǝsuǝale ǝsuǝ óte asa wǝ batɔnkpe ba úlǝkǝ asa. ");
INSERT INTO lip_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Lǝ eyi fosi ana se úkpǝ ótaka kǝmiǝ, úlǝkǝ wǝ ǝsuǝ óte lǝ esu kpǝ nnya lete sitinti bǝ okpe nkpǝ. Mba dínyǝ wǝǝ, údi mǝ etiki itsyi lǝ Onanto eto sekakedikɔ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Se bǝbǝ bátsya bensii, ókpe mǝ kɔfi nkǝ, “Biendu lǝ Yerusalem, bomu bisiǝ bikabe kusu itǝ Lɛwɔnɔ Kɛnkɛ nǝ míntɛyi mi mintɔnsǝ miǝ mɔ Anto lɛtɛyi utsyǝ nkǝ wootsyese mi. ");
INSERT INTO lip_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yohanes alɛɛ, ntu te úfi úyifo betidi ntuflǝsǝflǝsǝ eto lekpa nǝmǝ. Fɛɛ lǝ eyi asiani eto kamaa, Onanto ebufi Lɛwɔnɔ Kɛnkɛ uflǝsǝ mi.” ");
INSERT INTO lip_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Lefe nǝ batɔnkpe bamǝ ku Yesu létsya bioo, bátɔ wǝ bǝnkǝ, “Bonamute, dimamfe foola fǝ atakasǝ Israel eto Sekadidi siamǝ ǝńyǝnsǝ bio, mɔmɔ lee?” ");
INSERT INTO lip_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Nya Yesu lɛtɛyi mǝ nkǝ, “Yanle bǝ bete lefe nye eyi nnya mɔ Anto lǝ wǝ ǝsuǝale ǝsuǝǝ, lɛtɛyi utsyǝ nkǝ lesatsyuǝ ebubǝ itǝ. ");
INSERT INTO lip_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Nya lǝ lefe nǝmǝ ayo bǝ Lɛwɔnɔ Kɛnkɛ bǝ mi ɔflɔɔ, wuubǝ udufǝ mimblɛ kenke lǝ ǝsuǝ nya wuufi wǝ ǝsuǝale okpe mi nya biudi mɔ badansiɛ lǝ Yerusalem ku Yudea kenke ku Samaria idu isu ese kawunsiǝ eto nsekɔ ke.” ");
INSERT INTO lip_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Se ɔ́tɛyi nyamfo ólosǝǝ, Onanto étsyi wǝ úsuko kato nya bǝńyǝ banlɛ wǝ bobe isu ese lefe nǝ údufǝ lǝ difule ǝsuǝ ónya lǝ mǝ ǝnǝmi. ");
INSERT INTO lip_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Nya se bǝńyǝ banlɛ kato bobe tũũ lǝ kase údu ɔ́ntɔɔ, lamfolamfo basani inuǝ bǝtsyuǝ ba nkpe awu flubia ǝlǝkǝ ǝsuǝ báte mǝ, ");
INSERT INTO lip_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","nya bátɛyi bǝnkǝ, “Galilea eto basani, beso bińyǝ bɛnlɛ kato bobe mǝ? Yesu ǝmfo, wǝ bínyǝ Onanto dítsyi úsuko katoo, ebusinkli ubǝ fe kase bínyǝ ɔnlɛ budu kesu kato mmǝ.” ");
INSERT INTO lip_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Lǝ nyamfo eto kamaa, batɔnkpe bamǝ ésinkli betsyi kɔtini ko baakpo Nnuǝbi eto Eyi eto Kɔtini ǝsuǝ mfó bésu Yerusalem. Idu mfó ibǝ umǝ nti ebutsyǝ fe disunkpo eto ɔnwɛkǝtsyǝkɔ kani eto kusu. ");
INSERT INTO lip_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Se bédufǝ umǝǝ, bésinkli bésu kaka bakɛ lǝ abanslo kato. Mǝ mba lɛkɛ mfó ni Petro, Yohanes, Yakobo, Andreas, Filipo, Tomas, Bartolomeo, Mateo, Yakobo wǝ ni Alfeo eto ubisaibi, Simon wǝǝ léta mǝ kasɔ eto disi ku Yuda wǝ ni Yakobo eto ubisaibi. ");
INSERT INTO lip_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Betidi bamfo ákatsya mlǝmlǝmlǝ ku besio bǝtsyuǝ ku Maria, Yesu eto ambe ku Yesu eto bayimisani fe ditsyukpa ákato ola ku nsusu bɔni. ");
INSERT INTO lip_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Lǝ eyi nyamfó ǝsuǝ, bafokanɔfɔ ba eto leklabi lídi fe kolofa awosi ǝnuǝ ákatsya kato ola. ");
INSERT INTO lip_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Mfó nya Petro létaka úńyǝ ɔ́tɛyi mǝ nkǝ, “Mɔ bayimi, asa nnya báwɔni bǝtsyǝ lǝ Awɔnisa Kɛnkɛ eto Kukue ǝsuǝ, lǝ kase Lɛwɔnɔ Kɛnkɛ ɛyɛ lǝ Oka David ǝsuǝ, lɛtɛyi utsyǝ itsyi lǝ Yuda wǝ lɛtɔnko betidi bǝmuǝ Yesuu, ǝbǝ itǝ. ");
INSERT INTO lip_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yuda éyifo mba lɛkɛ lǝ bo ditsyukpa nǝmfo eto ɔni, itsyise Yesu ǝlǝkǝ wǝ nkǝ wuntsya nyǝ kedikɔ lǝ bo keyifo kamfo kǝmiǝ.” ");
INSERT INTO lip_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Nyaa, béfi kabua ka úyifo eto atabi bésu báya kasɔ ka ǝsuǝ úsu úkpǝ. Kaka ófankli úbǝ ɔ́sɔ kasɔɔ, óba úsensǝ nya wǝ befonkǝ kenke lɛbɔ békpo lǝ kasɔ mfó. ");
INSERT INTO lip_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Wǝ ukpǝ ǝmfo eto etiki ába ékpo lǝ Yerusalem itǝ betidi bata ánɔ nnya. Nyaso béfi kaka úkpǝ mfó bǝtǝkǝ bǝ Akeldama lǝ mǝ sele ǝsuǝ eto kasɔ ni bǝ Kɔtɔ eto Kasɔ. ");
INSERT INTO lip_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Petro ésukosǝ nkǝ, “Nyaso báwɔni bákpe lǝ David eto Ǝsǝ eto Kukue ǝsuǝ bǝnkǝ, ‘Beyani wǝ diyo bitsyǝ nya kutsyuǝ saa mǝnsiǝ lǝ ni!’ Besi báwɔni bǝ, ‘Bitǝ lǝ utidi bamba lǝ usiǝ lǝ wǝ keyifo eto kɛnyɛ.’ ");
INSERT INTO lip_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Nyaso ele bǝ utsyuǝ dufǝ bo nti fe futsyǝ luudi adansiɛ itǝ Bonamute Yesu itsyi lǝ wǝ botaka ketsyi ɔkɔmǝ kǝbǝ nkpǝ ǝsuǝ. Nya ele bǝ uyifo futsyǝ lɛkɛ lǝbo nti idu lǝ lefe nǝ kenke bo ku Yesu díkatsyilama, idu lefe nǝ Yohanes lébe letsya itsyi lǝ ntuflǝsǝflǝsǝ eto lekpa ǝsuǝ ibǝ ese lefe nǝ Onanto léfo Yesu úsuko kato.” ");
INSERT INTO lip_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Nyaso bǝlǝkǝ betidi inuǝ ba ni Matias ku Yosef wǝ baakpo Barsaba nya bensi baakpo wǝ tsya bǝ Yusto. ");
INSERT INTO lip_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Nya báto ola bátɛyi bǝnkǝ, “Bonamute, fǝ nyi utidi saa eto nsusu kǝmiǝ. Nyaso té bo ɔni lǝ betidi inuǝ bamfo eto nti, wǝ luusiǝ fe ɔtɔnkpe lǝ Yuda eto kɛnyɛ wǝ léyani údu úsu kaka dińyǝ itǝ wǝ.” ");
INSERT INTO lip_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Nya lefe nǝ bákpo aba básɛ lǝ bǝlǝkǝ betidi inuǝ bamfo eto ɔnii, Matias ni nwǝ bǝlǝkǝ bákpe lǝ betidi lefosi ɔnwɛ bamǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Nyaso se Pentekoste eto Diyi léyoo, bafokanɔfɔ kenke átsya lǝ kalebe kani kplo. ");
INSERT INTO lip_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Lamfolamfoo, bánɔ kɔsɔ fe ufiebi kekleke eto bɔsɔ ditsyi kato. Nya ufiebi ǝmǝ díyi diyo nǝ kafo bakɛ kenke. ");
INSERT INTO lip_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Nya lesatsyuǝ fe ute eto odiakami díbǝ dísiǝ lǝ mǝ utsyuǝ saa ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Nya Lɛwɔnɔ Kɛnkɛ dídufǝ lǝ mǝmblɛ ǝsuǝ, nya bétsyiko Onanto bɔtɛsǝ lǝ bele ate ate ǝsuǝ fe kase Lɛwɔnɔ nǝmǝ dítǝ mǝ nkǝ bedi. ");
INSERT INTO lip_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Nya lǝ lefe nǝmfó tututuu, Yudafɔ ba lǝǝtǝ Onanto dibu ba dítsyi kawunsiǝ eto ese ese ǝbǝ bakɛ lǝ Yerusalem. ");
INSERT INTO lip_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Nyaso lefe nǝ bánɔ kudu kplɛ komfóo, betidi kpǝ ésu bátsya mfó. Iyifo mǝ yanii ku sikpi se mǝ utsyuǝ saa lɛnɔ banlɛ etiki budi lǝ wǝ sele ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Lǝ nyamfo esoo, íyifo mǝ yanii ku sikpi nya bétsyiko mǝ ǝsuǝ bɔtɔ bǝnkǝ, “Nya betidi ba kenke nlɛ etiki budi mfoo, inni Galileafɔ beni fɛ? ");
INSERT INTO lip_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Nya ntsyǝ ibǝ fɛ bo utsyuǝ saa nlɛ etiki bɔnɔ lǝ bo bele ǝsuǝ? ");
INSERT INTO lip_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","10","Bo mba ni Partiafɔ ku Mediafɔ ku Elamfɔ, ku mba dítsyi Mesopotamia ku Yudea ku Kapadokia ku Ponto ku Asia ku Frigia ku Pamfilia ku Egipte ku Libia eto lekpake nǝ lɛfi Kirene ku bafɔ bamba ba dítsyi Roma ku Yudafɔ ku betidi ba díkedufǝ lǝ Yudafɔ eto ditsyukpa ǝsuǝ ");
INSERT INTO lip_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ku Kretafɔ ku Arabiafɔ. Bomblɛ lɛ bɔnɔ se banlɛ Onanto eto asa kplɛ nnya ɔnlɛ buyifo bulǝkǝ kate lǝ bo bele ǝsuǝ!” ");
INSERT INTO lip_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Kuutsyuǝ saa wǝ díńyǝ mfó mánnɔ eyifosa nyamǝ kasɔ. Íyifo mǝ yanii, nya bákatɔ mǝ ǝsuǝ bǝnkǝ, “Nnya díbǝ mfo eto kasɔ nkpǝ?” ");
INSERT INTO lip_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Fɛɛ mba díńyǝ mfó eto bǝtsyuǝ ǝkǝmǝ mǝ ákatɛyi bǝ, “Ntǝ ete békpǝ, inni kulesa ini kon!” ");
INSERT INTO lip_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Mfó nya Petro létaka úńyǝ ku lefosi ɔnwɛ fɛfɛ bamǝ nya óbesǝ ɔkɔɛ kato ɔ́tɛyi nkǝ, “Mi Yudafɔ ku mimba nkpe lǝ Yerusalem, nla miǝ bitsyue ato lǝ nkpasǝ mi lǝ bɛnɔ lesa nǝ díbǝ mfo. ");
INSERT INTO lip_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Inni nte betidi bamfo díkpǝ fe kase bǝtsyuǝ díbu seka, itsyise olesiǝ eto abombo ɔwɔnɔmbǝ ete ni nyamfo nɛ. ");
INSERT INTO lip_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Bomu lesa nǝ nlɛ bubǝ mfoo, eyifo lesa nǝ Onanto eto Unyɛlǝkǝtidi Yoel lɛtɛyi utsyǝ kokooko nkǝ, ");
INSERT INTO lip_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Onanto átɛyi nkǝ, “Lǝ eyi fɛfɛ nnya luubǝ ǝsuǝǝ, muufi mɔ Lɛwɔnɔ nkpo lǝ utsyuǝ saa ǝsuǝ, nya mi bebisaibi ku bebisiobi loobe mɔ ditiki letsya, nya mi bakosobi luunyǝ Onanto eto asakulakula, nya mi beninǝ tsya luusiǝ ala. ");
INSERT INTO lip_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ee, sitinti lǝ lefe nǝmfoo, muutǝ mɔ Lɛwɔnɔ Kɛnkɛ yifǝ disiǝ lǝ mɔ beyifoyifo, besio ku basani kenke ǝsuǝ. Nya boolǝkǝ mɔ ditiki kɛnyɛ bate. ");
INSERT INTO lip_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Nya muutǝ asa kplɛ kplɛ ku anyinsa bǝ lǝ difule ku kasɔ kenke utsyuǝ saa nyǝ. Biunyǝ kɔtɔ ku ute ku kuyuǝ kplɛ bɔ. ");
INSERT INTO lip_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Kofe ebona tũũ, nya kofande eto ǝnǝmi lɔɔsɛ hǝǝ fe kɔtɔ, fɛ Bonamute eto diyǝnde eto diyi kplɛ nǝmǝ looyo. ");
INSERT INTO lip_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Lǝ lefe nǝmfoo, boofo utsyuǝ saa ke lookpadi Bonamute eto diye, nya wɔɔtɔ bɔwunsǝkoo, wɔɔkɛ bofo.” ’ ” ");
INSERT INTO lip_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Petro esi údi etiki ɔ́tɛyi nkǝ, “Israelfɔ bɛnɔ etiki nyamfo. Yesu Nasaretnyǝ ni Nwǝ Onanto Lékpo Ɔhile Utsyǝ. Nya óte nyamfo lefe nǝ ɔ́yɛ lǝ wǝ ǝsuǝ úlǝkǝ wǝ ǝsuǝale óte, nya úyifo asa kplɛ ku ayanisa kpǝ óte fe kase mi kosate nyi. Itsyisee, íbǝ lǝ mi nti mfo. ");
INSERT INTO lip_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Nya Onanto lɛtɔnɔ faa lǝ wǝ ketsyue ǝsuǝ óyani wǝ útǝ mi nya bítǝ babuayifo lélo wǝ lǝ lefe nǝ bɛsɔ wǝ bémanklasǝ lǝ uyikabie ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Tsyaa, Onanto esi ótakasǝ wǝ utsyiko ɔkɔmǝ nya ɔ́bɔ útsyi lǝ ukpǝ eto ani, itsyise ukpǝ embofo wǝ buti kakpe. ");
INSERT INTO lip_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Nyamfo Oka David lɛtɛyi itsyi lǝ wǝ ǝsuǝ nkǝ, ‘Nnyǝ se Bonamute ńyǝ lǝ mɔ kodiani nya unsiko mɛ lefe saa esoo, mante kulesa sikpi. ");
INSERT INTO lip_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Lǝ nyamfo esoo, disuǝyuǝ eyi mɛ ǝsuǝ, nyaso muufi atɛsǝ ntǝ wǝ lefe saa! Ite bǝ utidi wǝ luukpǝ mini tsyaa, muusiǝ nkpǝ nkabe wǝ kusu. ");
INSERT INTO lip_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Itsyise ǝmbutǝ kusu ukpǝ tǝkǝ mɛ kato. Nya fǝmbutǝ tsya bǝ fǝ ubi kɛnkɛ eto sinǝ bu. ");
INSERT INTO lip_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Fǝ dítǝ mínte nkpǝ eto kusu itǝ lǝ nńyǝ lǝ fǝ ǝnǝmi koo, muunyǝ disuǝyuǝ lefe saa.’ ");
INSERT INTO lip_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Nyaso, mɔ bayimi, nlɛ mi bɔtɛyi sitinti minkǝ, bo ona Oka David wǝ lefo diye ǝkpǝ nya bébikǝ wǝ nya wǝ kudi nkpe lǝ bo nti mfo eyo mmi. ");
INSERT INTO lip_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Fɛɛ uyifo Onanto eto unyɛlǝkǝtidi. Nyaso óte lesa nǝ Onanto lɛtɛyi utsyǝ nkǝ wootsyese David eto kafo eto ubi lǝ ubǝ udi seka lǝ David eto kɛnyɛ. ");
INSERT INTO lip_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Se David léte nyamfo ɔtɔnsǝ esoo, ɔ́tɛyi utsyǝ nkǝ Kristo ebotaka utsyi ɔkɔmǝ. Ɔ́tɛyi nkǝ Onanto mányani wǝ utsyǝ lǝ ɔkɔmǝ, nya wǝ ǝsuǝ eto sinǝ tsya mémbu lǝ wǝ kudi kafo mfó. ");
INSERT INTO lip_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Wǝ ni Yesu ǝmǝ Onanto létakasǝ utsyiko ɔkɔmǝ, nya ini etiki eto ɔnukualɛɛ, bomblɛ ni wǝ badansiɛ. ");
INSERT INTO lip_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Wǝ Anto Onanto ábesǝ wǝ kato úsu unsi lǝ wǝ kodiani, nya ófo Lɛwɔnɔ Kɛnkɛ utsyiko lǝ wǝ ɔflɔ fe kase ɔ́tɛyi utsyǝ. Lesa nǝ bɛnlɛ bunyǝ, kanɔ mfoo, eyifo wǝ ǝtǝsa nnya úfi útǝ bo. ");
INSERT INTO lip_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Ite bǝ inni David kosate létaka úsu kato mfó tsyaa, ɔ́tɛyi utsyǝ nkǝ, ‘Bonamute Onanto ǝmǝ átɛyi mɔ Onamute ǝmǝ nkǝ, “Siǝ lǝ mɔ kodiani isu ese lefe nǝ moobokosǝ fǝ balo kasɔ ǝtǝkǝ mǝ akpa lǝ disinti.” ’ ");
INSERT INTO lip_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Nyaso nla miǝ mi Israelfɔ kenke te biǝnkǝ wǝ Anto Onanto ni futsyǝ dítǝ Yesu wǝ básɔ lǝ uyikabie ǝsuǝ bélo Onanto dítǝ ófiani Bonamute ku Nwǝ Onanto Lékpo Ɔhile Bǝtsyǝ.” ");
INSERT INTO lip_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Nya se betidi bamfo lɛnɔ Petro eto etiki nyamfoo, ílǝ mǝ lǝ akɔɛsi. Nyaso bátɔ Petro ku batɔnkpe fɛfɛ bǝnkǝ, “Bayimi, be ele bǝ buyifo?” ");
INSERT INTO lip_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Nyaso Petro átɛyi mǝ nkǝ, “Ele bǝ mi utsyuǝ saa sinkli ɔyɛ abua buyifo, lǝ ofloma, lǝ ofo ntuflǝsǝflǝsǝ eto lekpa nǝmǝ lǝ Yesu Kristo eto diye ǝsuǝ, lǝ Onanto lǝ ufi wǝ abua ɔtsyɛ wǝ, lǝ ofo Onanto eto ǝtǝsa nnya ni Lɛwɔnɔ Kɛnkɛ. ");
INSERT INTO lip_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Nkomǝ eto kɛnyɛtsyǝtsyǝ te itǝ mi ku mi bebi ku mba kenke ditsyi katsyontsyokɔ ku betidi ba kenke Bonamute bo Anto lookpadi bafiani wǝ bale.” ");
INSERT INTO lip_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Nnya kamaa, Petro édi adansiɛ údi mǝ etiki kpǝ nya ɔ́lɛ mǝ kɔlɛ, ɔ́lɛ mǝ lekpakpa nkǝ, “Bilǝkǝ mi ǝsuǝ bitsyiko lǝ kotonǝnǝ ko nlɛ bubǝ lǝ kawunsiǝ bua kamfo eto betidi ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Lǝ nyamfo esoo, betidi kpǝ ba lɛnɔ Petro eto ditiki nǝmǝ áfo banɔ, nya bǝflǝsǝ mǝ ntu, nya mǝ utú ébutsyǝ fe betidi akpi ǝtsyǝ. Mǝ dísu bákɔ diyi nǝmfo lǝ bafokanɔfɔ ǝsuǝ nɛ. ");
INSERT INTO lip_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Béfi mǝ lefe bǝtǝ batɔnkpe bamǝ nya báte mǝ asa, nya bákato ola kǝtǝ Onanto, nya békedi lesa kakɔ tsya, nya bǝsiǝ ku bǝtsyuǝ lǝ lɔniyifoyifo ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Se batɔnkpe bamǝ díyifo ayanisa kpǝ esoo, íyifo betidi bamǝ yanii. ");
INSERT INTO lip_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Nyaso bafokanɔfɔ lǝ mfo ákatsya lefe saa nya békesie mǝ asa kenke kǝtǝ bǝtsyuǝ. ");
INSERT INTO lip_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Nya lǝ báte mǝ bikǝǝ, békefi atabi nnya bǝnyǝ késuko békesie, utsyuǝ saa lǝ kase éhiã wǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Nya békesu kátsya lǝ Anto Onanto eto Disumuyo diyi saa, nya bákatsya lǝ etsyukpa etsyukpa kédi asa lǝ mǝ ayo ku disuǝyuǝ ku utu faa. ");
INSERT INTO lip_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Nya bákatɛsǝ Onanto. Itǝ betidi ba tã ékebu mǝ. Nya diyi saa, Bonamute kǝtǝ betidi fɔfɔ ba bofo lǝ nkpǝ díkǝbǝ kákɔ lǝ mǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Diyi lɔnii, Petro ku Yohanes ésu Onanto eto Disumuyo lǝ lefe nǝ Yudafɔ laato ola kǝtǝ Onanto. Iyifo fe kakɔmi eto abombo ǝtsyǝ lefe. ");
INSERT INTO lip_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Se báyo Disumuyo nǝmǝ eto kesie ka baakpo Kesie Ka Laanɔ Bobee. Mfó bǝnyǝ osani utsyuǝ wǝ léba onkpo lǝ kasɔ taa wǝ lelefe ke. Wǝ betidi éketsyi wǝ kǝbǝkǝtsyǝ mfo diyi saa bǝ lǝ úkatɔ asa lǝ betidi ba laayɛ kedufǝ Disumuyo nǝmǝ. ");
INSERT INTO lip_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Se únyǝ Petro ku Yohanes nlɛ bofe kédufǝ diyo nǝmǝǝ, ɔ́tɔ mǝ nkǝ bǝtǝ wǝ lesatsyuǝ. ");
INSERT INTO lip_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Bále bǝńyǝ nya bábe wǝ tũũ, nya Petro lɛ́tɛyi wǝ nkǝ, “Be bo mfo!” ");
INSERT INTO lip_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Nya utidi ǝmǝ létakasǝ ǝnǝmi útǝkǝ lǝ mǝ, ku nsusu nkǝ bǝǝbǝ wǝ lesatsyuǝ butǝ. ");
INSERT INTO lip_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Mfó nya Petro dídi etiki ɔ́tɛyi wǝ nkǝ, “Mɔɔ, atabi saa ente mɛ muutǝ fǝ! Nyaso muutǝ fǝ lesa nǝ nte mɛ. Nlɛ fɛ bɔtɛyi lǝ Yesu Kristo Nasaretnyǝ eto diye ǝsuǝ minkǝ taka ǝńyǝ lǝ ayɛ edu!” ");
INSERT INTO lip_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Nya Petro lɛkɔbe utidi ǝmfo eto kodiani nya útǝ nkǝ otaka uńyǝ. Nya lamfolamfoo, wǝ akpa ku bɛkplɔbɛ eto ekubi dímuǝ ale! ");
INSERT INTO lip_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Nya óbe ósa úńyǝ lǝ wǝ akpa ǝsuǝ. Mfó útsyiko bɔyɛ kesu kesinkli. Nya útǝkǝko mǝ údufǝ Disumuyo mfó, kayɛ kabé kasa katɛsǝ Onanto. ");
INSERT INTO lip_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Betidi ba kenke lɛkɛ mfó, ǝnyǝ wǝ ɔnlɛ bɔyɛ nya ɔnlɛ Onanto bɔtɛsǝ. ");
INSERT INTO lip_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Se bǝnyǝ wǝǝ, bǝtsyǝ lekpo bǝ wǝ ni futsyǝ díkǝsiǝ lǝ Kesie Ka Laanɔ Bobe kátɔ asa mfó. Nyaso íyifo mǝ yanii ku sikpi lǝ lesa nǝ béyifo bǝtǝ wǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Se osani ǝmǝ dímuǝ Petro ku Yohanes ɔnlɛ kekle lǝ lekpake nǝ baakpo Oka Solomo eto Lekpata nǝ nkpe lǝ Onanto eto Disumuyo mfóo, betidi kpǝ étsyetsyi bésu mǝ ɔflɔ. Wǝ botsya éyifo mǝ yanii sekasitsyuǝ. ");
INSERT INTO lip_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Nya se Petro dínyǝ betidi bamǝǝ, ɔ́tɛyi mǝ nkǝ, “Israelfɔ, bǝ díyifo mi yanii lǝ nyamfo ǝsuǝ fɛ? Nya beso bɛnlɛ bo bobe fe bo kosate eto ǝsuǝale ku Boanto eto sikpitete ǝsuǝ eso utidi emfo lɛyɛ? ");
INSERT INTO lip_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Nnya ni bǝnkǝ Onanto lébesǝ wǝ Usumubi Yesu kato. Onanto ǝmfo ni Abraham ku Isak ku Yakob tsya eto Onanto nɛ. Wǝ tsya nsi ni bo bana eto Onanto. Wǝ Ubi ni Yesu wǝ bífi bítǝ biǝ balo. Nya bɛni wǝ lǝ Pilato eto ǝnǝmi lǝ lefe nǝ bɛtɛyi biǝ binyi wǝ kulaa tsya, lǝ lefe nǝ Pilato wǝ léla nkǝ wóayani wǝ fɛ. ");
INSERT INTO lip_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Bɛni utidi kɛnkɛ ku ɔsɛɛ, nya bɛtɔnɔ biǝ oyani uwudifɔ bomu lǝ wǝ kɛnyɛ. ");
INSERT INTO lip_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Bélo utidi wǝ lǝǝtǝ betidi nkpǝ. Nya Onanto dísinkli ótakasǝ wǝ utsyiko ɔkɔmǝ! Nya bo kosate dínyǝ wǝ ku bo ǝnǝmi! ");
INSERT INTO lip_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ɛyɛ lǝ Yesu eto diye ǝsuǝǝ, nya utidi wǝ lɛtsyini bɛnlɛ bunyǝ mfoo, dímuǝ ǝsuǝale nɛ. Nya se ófo Yesu ɔ́nɔ esoo, nnya dítǝ únyǝ bufitsyatsya fe kase mimblɛ nlɛ bunyǝ ku mi ǝnǝmi mfo nɛ. ");
INSERT INTO lip_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Mɔ bayimi, nyi miǝ mi ku mi beninǝ éyifo nyamfo eto okloe ɛyɛ lǝ mante mante ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Fɛɛ Onanto ébɔtɛyi utsyǝ nkǝ ɛyɛ lǝ wǝ bǝnyɛlǝkǝtidi ǝsuǝ wǝ ubi Kristo, Utidi Wǝ Onanto Lékpo Ɔhile Utsyǝ ebudi ohiã. Nko eso útǝ nkǝ wǝ bǝnyɛlǝkǝtidi eto lesa nǝ bátɛyi bǝtsyǝ bǝ itǝ. ");
INSERT INTO lip_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","20","Nyaso bisinkli lǝ abuayifoyifo kama lǝ bitǝkǝko Onanto, lǝ uflǝ mi abua uwi. Lǝ biyifo nkoo, buinyǝ Lɛwɔnɔ Kɛnkɛ eto ǝsuǝale itsyi lǝ Bonamute ɔflɔ, nya wootsyese Yesu wǝ ni Kristo Wǝ Onanto Lékpo Ɔhile Utsyǝ. ");
INSERT INTO lip_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Nko ini eso Yesu luusiǝ kato isu ese lefe nǝ Onanto lɔɔlɔ lesa saa utsyǝ fe kase útǝ wǝ bǝnyɛlǝkǝtidi kɛnkɛ lɛtɛyi bǝtsyǝ taa kɔ ke. ");
INSERT INTO lip_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Fe kase Moses lɛtɛyi utsyǝ nkǝ, ‘Bonamute Onanto ebulǝkǝ unyɛlǝkǝtidi utsyuǝ utsyiko lǝ mi nti fe kase útǝ mímbɔ. Nyaso bitsyuǝ wǝ ditiki nǝ ke wɔɔtɛyi mi koto. ");
INSERT INTO lip_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Nyaso nwǝ ke lembutsyue unyɛlǝkǝtidi ǝmǝ kotoo, Onanto ebulǝkǝ wǝ lǝ wǝ betidi nti nya wɔɔtsylɔsǝ wǝ.’ ");
INSERT INTO lip_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Lǝ sitintii, Onanto eto bǝnyɛlǝkǝtidi kenke idu lǝ Samuel ɛntɔɔ, ébɔtɛyi asa nnya nlɛ bubǝ mfo mmi bǝtsyǝ. ");
INSERT INTO lip_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Nnya Onanto lɛtɛyi utsyǝ ɛyɛ lǝ wǝ bǝnyɛlǝkǝtidi ǝsuǝ eyifo mi ale. Nya mi tsya kpe kedikɔ lǝ kɛnyɛ ka Onanto lékle ku mi bana ǝsuǝ. Fe kase ɔ́tɛyi Abraham nkǝ, ‘Ɛyɛ lǝ fǝ ufluflu ǝsuǝǝ, mookpo kasɔ eto betidi kenke atsyɔ.’ ");
INSERT INTO lip_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Nyaso se Onanto dílǝkǝ wǝ Uyifoyifo Kristo ótee, tutɛ ótsyese wǝ mi ɔflɔ nkǝ lǝ okpo mi atsyɔ, nya lǝ utǝ mi utsyuǝ saa lǝ ɔyɛ abua buyifo.” ");
INSERT INTO lip_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Lefe nǝ Petro ku Yohanes ńyǝ banlɛ betidi bamǝ etiki budii, Yudafɔ eto besumunyǝ ku Disumuyo eto mba laase mfó eto beninǝ ku Sadukifɔ tsya ǝbǝ mfó. ");
INSERT INTO lip_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Se bánɔ bǝ Petro ku Yohanes ńyǝ mfó balɛ etiki itsyi lǝ Yesu eto botaka ketsyi ɔkɔmǝ ǝsuǝ, nnya nlɛ bote bǝnkǝ utidi wǝ díkǝkpǝ ebotaka ubǝ nkpǝǝ, kafo ányi mǝ tinti. ");
INSERT INTO lip_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Nyaso bǝmuǝ mǝ. Nya se kale mfe nlɛ bolo esoo, béti mǝ bákpe le diyo isu ǝsǝ kǝsiǝsǝ. ");
INSERT INTO lip_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Fɛɛ betidi kpǝ ba lɛnɔ mǝ etikii, báfo etiki sɛɛ nyamfo bánɔ. Mǝ utú ebuyifo fe basani akpi anɔ. ");
INSERT INTO lip_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Nya se kale dísiǝǝ, ibǝ bǝ Yudafɔ eto bǝsuǝaletidi ku beninǝ ku afi eto bateasa ákpe disi lǝ Yerusalem. ");
INSERT INTO lip_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Bátsya ku Usumunyǝ Ninǝ Kenke Annas ku Kayafa ku Yohanes ku Aleksandro ku besumunyǝ ninǝ eto betidi tsya. ");
INSERT INTO lip_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Nyaso bákpa Petro ku Yohanes bamǝ báboko mǝ ǝnǝmi. Nya bátɔ mǝ bǝnkǝ, “Owoe eto diye ku ǝsuǝale ǝsuǝ bíyifo nyamfo?” ");
INSERT INTO lip_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Petro wǝ díyi ku Lɛwɔnɔ Kɛnkɛ eto ǝsuǝale átaka úńyǝ nya ɔ́tɛyi mǝ nkǝ, “Bo bǝsuǝaletidi ku umǝ eto beninǝ, ");
INSERT INTO lip_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","lǝ bela biǝnkǝ bianɔ lesa sɛɛ nǝ búyifo bútǝ utidi wǝ lɛtsyini mfo ku kase bótsya wǝǝ, ");
INSERT INTO lip_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","bitǝ mɛ kusu lǝ ntɛyi mi ku Israel eto betidi kenke lesatsyuǝ. Yesu Kristo wǝ ditsyi Nasaret wǝ bítǝ básɔ lǝ uyikabie ǝsuǝ, nya Onanto disi ótakasǝ wǝ utsyiko ɔkɔmǝǝ, wǝ diye ǝsuǝ nya utidi ǝmfo dímuǝ ale nɛ. ");
INSERT INTO lip_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Nya Yesu ǝmfo ǝsuǝ Awɔnisa Kɛnkɛ lɛtɛyi nkǝ, ‘Leba nǝ mba laato ayo lɛni bǝ dimbǝ kɔnɔɔ, ni bomu díbǝ lefiani nǝ nso bofe lǝ afɛfɛ kenke nti.’ ");
INSERT INTO lip_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Wǝ hã ni futsyǝ loofo utidi bulǝkǝ, itsyise wǝ hã ni futsyǝ Onanto dítǝkǝ diye nya útǝ wǝ ǝsuǝale lǝ betidi ba tã nti, nkǝ utǝ utidi nkpǝ.” ");
INSERT INTO lip_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Se bǝsuǝaletidi ku beninǝ dínyǝ kase Petro ku Yohanes ba lenni bekuente nya bámfo bunǝ saa, nlɛ etiki budi ku ute ku ute ku ǝsuǝale nkoo, íyifo mǝ yanii. Nya bǝnyǝ bǝtsyǝ lekpo sitinti bǝ mǝ ku Yesu áyɛ béyifo keyifo lǝ bǝtsyuǝ. ");
INSERT INTO lip_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Nya se bǝnyǝ utidi ǝmǝ bátsya ńyǝ mfó lǝ mǝ ɔflɔɔ, kɛnyɛ ǝkpǝ mǝ, bánte lesa nǝ baatɛyi bio. ");
INSERT INTO lip_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Nyaso bátɛyi mǝ bǝ banyi besu kama etɔ, nya mǝ hã dísiǝ mfó kefi nsusu lǝ lesa nǝ booyifo ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Mǝ bǝtsyuǝ átɔ bǝ, “Be ele bǝ buyifo ku betidi bamfo? Boǝmbofo bɔtɛyi boǝ lesa nǝ béyifo mfo enni ayanisa itsyise utidi saa wǝ nkpe lǝ Yerusalem yi nya ɔ́nɔ ditiki nǝmfo. ");
INSERT INTO lip_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Bomu bǝ lǝ etiki nyamfo lǝ ɛyɛ bokpantsyaa, bitǝ lǝ bukǝ mǝ ato boǝ bensidi etiki saa lǝ Yesu eto diye ǝsuǝ bio.” ");
INSERT INTO lip_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Nya bésinkli bákpadi mǝ báboko disikakpekɔ mfó nya bákpe mǝ kɔfi bǝ idu lefe nǝmfó ɛntɔɔ, bénsidi kutsyuǝ saa etiki nye báte kulesa itsyi lǝ Yesu ǝsuǝ bio. ");
INSERT INTO lip_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Nya Petro ku Yohanes dífe kɛnyɛ bátɛyi mǝ bǝnkǝ, “Mi kosate bibu nnya bebe biǝ nte nnya lɔɔkɛ Onanto ɔkɔɛ? Bǝ buyifo lǝ mi kɔfi ǝsuǝ lee, lǝ Onanto eto kole ǝsuǝ? ");
INSERT INTO lip_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Bo alɛɛ, asa nnya búnyǝ ku bɔ́nɔɔ, boembofo kɛnyɛ boma lǝ nnya ǝsuǝ kǝsiǝ kpoo nko.” ");
INSERT INTO lip_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Nyaso beninǝ bamǝ nlɛ disi bokpe mfó ǝnyǝnki bákpe nya békǝ mǝ ato kekleke nya báyani mǝ. Kase betidi bamǝ kenke díńyǝ mfo nlɛ Bonamute bɔtɛsɛ lɛ wǝ eyifosa esoo, beninǝ bamǝ mánte kusu ko bɔɔyɛ bǝnǝ mǝ koto. ");
INSERT INTO lip_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Utidi ǝmǝ bátsya ébofo alɛ fosi ana ku kama. ");
INSERT INTO lip_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Lefe nǝ báyani mǝ kamaa, Petro ku Yohanes ésu mǝ betidi bamǝ ɔflɔ nya bátɛyi mǝ lesa nǝ betidi bamǝ lɛtɛyi mǝ lǝ disikakpekɔ kamǝ. ");
INSERT INTO lip_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Nyaso bafokanɔfɔ lǝ mfó kenke átsya nya báto ola bǝtǝ Onanto bǝ, “Bonamute, fǝ díyifo kato ku kasɔ ku lekpo ku asa nnya kenke nkpe lǝ nya. ");
INSERT INTO lip_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Fǝ lɛyɛ lǝ Lɛwɔnɔ Kɛnkɛ ǝsuǝ fǝtǝ bo Ona David wǝ ni fǝ Uyifoyifo dídi etiki ɔ́tɛyi nkǝ, ‘Beso kawunsiǝ eto betidi ba lenni Yudafɔ nlɛ bunyenki kefi nsusu bua? ");
INSERT INTO lip_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Kawunsiǝ mfo eto baka átsya, báto ákpatsya, nya bǝsuǝaletidi lékpe disi béfi nsusu lǝ Onanto ǝmǝ ku Utidi Wǝ Ókpo Ɔhile Utsyǝ ǝsuǝ.’ ");
INSERT INTO lip_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ɔnukualɛ uni bǝ Herodes ku Pontio Pilato ku Israelfɔ ku mba lenni Israelfɔ átsya lǝ umǝ ǝmfó nya bátaka bǝńyǝ lǝ fǝ Uyifoyifo Kɛnkɛ Yesu wǝ fákpo ɔhile fǝtsyǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Fɛɛ lǝ fǝ ǝsuǝale ku kobe ǝsuǝǝ, ábe fǝnkǝ lǝ batsyaa, beyifo lǝ asa nnya fétsyue fǝtsyǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Nya mɔmɔɔ, O Bonamute, be sikpi sia banlɛ bo bokpe, lǝ ǝtǝ bo fǝ beyifoyifo lɛkɔɛsi nǝ luutǝ boofo fǝ Ditiki Sɛɛ nǝmǝ budi. ");
INSERT INTO lip_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Nnǝ fǝ kɔni etsyue lǝ atsya betidi, lǝ eyifo ayanisa kpǝ, lǝ fǝ Uyifoyifo Kɛnkɛ Yesu eto diye ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Se báto ola bálosǝǝ, diyo nǝ kafo bankpe ko dítinkǝ nya Lɛwɔnɔ Kɛnkɛ lɛyifǝ dísiǝ lǝ mǝmblɛ ǝsuǝ nya bétsyiko Ditiki Sɛɛ nǝmǝ bɔtɛyi ku ǝsuǝale. ");
INSERT INTO lip_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Lǝ lefe nǝmfo kenkee, bafokanɔfɔ kenke eyifo kɛnyɛ kani lǝ ditsyǝbi ku nsusu ǝsuǝ mǝ kuutsyuǝ saa membu wǝ hã eto lɛlɛkɛsǝ eto disi, bomu mǝ lesa saa eyifo mǝmblɛ eto lele. ");
INSERT INTO lip_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Nya batɔnkpe bamfo kenke dífi ǝsuǝale kplɛ bábe Onanto eto Ditiki Sɛɛ ditsya itsyi lǝ Bonamute Yesu eto botaka ketsyi ɔkɔmǝ ǝsuǝ. Nya Onanto eto atsyɔkpokpo kplɛ dísiǝ ko mǝ kenke. ");
INSERT INTO lip_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Mǝ kutsyuǝ saa mánhiã kulesa, itsyise mba ayo nye nsɔ nkpee, efi asa nyamfo báte nya béfi atabi nnya bǝnyǝ, ");
INSERT INTO lip_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","bésuko batɔnkpe bamǝ nya bésie nnya bǝtǝ utsyuǝ saa lǝ kase ińyǝ itǝ wǝ. ");
INSERT INTO lip_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Lǝ mfóo, osani utsyuǝ akɛ lǝ mǝ nti baakpo Yosef, wǝ ni Lewinyǝ wǝ ditsyi kasɔ ka baakpo Kipro. Batɔnkpe bamǝ ǝtǝkǝ diye bǝ Barnaba, eto kasɔ ni nwǝ laakpe betidi otsyekle. ");
INSERT INTO lip_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Úfi wǝ kasɔ kǝtsyuǝ óte nya úfi atabi nnya únyǝ úsuko batɔnkpe bamǝ. ");
INSERT INTO lip_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Nya osani utsyuǝ tsya dísiǝ wǝ baakpo Ananias ku wǝ usiǝ Safira. Mǝ tsya éfi mǝ kasɔ kǝtsyuǝ báte. ");
INSERT INTO lip_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Nya úfi atabi nyamǝ eto ǝtsyuǝ ɔ́kula fɛ úfi afɛfɛ óboko batɔnkpe bamǝ. Ditsyǝbi nǝmfo eyifo wǝ usiǝ Safira eto bote nya ɔ́tɔnɔ nkǝ beeyifo nko. ");
INSERT INTO lip_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Nya Petro lɛtɔ wǝ nkǝ, “Ananias, beso fǝtǝ Obonsam dítǝkǝ fǝ kato, nya útǝ fátɛyi Lɛwɔnɔ Kɛnkɛ sidia? Nya féfi fǝ kasɔ ka fáte eto atabi ǝtsyuǝ fákula fǝtsyǝ ǝsuǝ? ");
INSERT INTO lip_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Kasɔ kamǝǝ, fǝ kale keni fɛ fáte ke, nya atabi nnya báfo fǝ kayo tsya eyifo fǝ ale. Be dítǝ eso féfi nsusu bua bomfó eto okle? Inni bo betidi bamfo fátɛyi sidia, bomu Onanto!” ");
INSERT INTO lip_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Kase Ananias lɛnɔ ditiki nǝmfo koo, lamfolamfo úduɔnɔ ókpo kasɔ, úkpǝ! Nyamfo ǝtǝ sikpi kplɛ ǝmuǝ mba kenke lɛnɔ nnya. ");
INSERT INTO lip_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Nya bakosobi ba lɛkɛ mǝ lenti dífi kafia beti wǝ nya béfi wǝ bésu bébikǝ. ");
INSERT INTO lip_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Fe abombosɔsɔ ǝtsyǝ eto kamaa, wǝ usiǝ tsya ǝbǝ údufǝ mfó. Fɛɛ wóannɔ tɔ lesa nǝ díkǝbǝ. ");
INSERT INTO lip_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Nya Petro lɛtɔ wǝ nkǝ, “Tɛyi mɛ, se fǝ ku fǝ usǝ dífi mi kasɔ bétee, atabi nnya kenke báfó mi kayo ni nyamfoo?” Nya usio ǝmǝ dítǝ mbuayɛ nkǝ, “Ee, nyamblɛ nɛ.” ");
INSERT INTO lip_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Nya Petro lɛtɛyi wǝ nkǝ, “Beso fonko fǝ usǝ lékle kɛnyɛ bɛnlɛ Lɛwɔnɔ Kɛnkɛ boto kabe? Bebe bakosobi ba dítsyi fǝ usǝ bésu bébikǝ ni mba mfo nɛ. Mǝ ke luutsyi fintsya besuko nɛ.” ");
INSERT INTO lip_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Lamfolamfo, wuntsya édu ɔ́nɔ nya úkpǝ. Nya se bakosobi bamǝ díbǝ bǝńyǝ se úkpǝ onlabee, bétsyi wuntsya bésu bébikǝ lǝ kaka bébikǝ wǝ usǝ ke. ");
INSERT INTO lip_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Itǝ eso sikpi kplɛ ǝmuǝ mba kenke díkafo Ditiki Sɛɛ nǝmǝ bánɔ ku betidi ba kenke lɛnɔ lesa nǝ díbǝ mfó. ");
INSERT INTO lip_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Lefe nǝmfo kenkee, batɔnkpe bamǝ éyifo ayanisa kpǝ lǝ betidi bamǝ nti. Bafokanɔfɔ ba lǝ mfóo, ákatsya lǝ Yudafɔ eto Disumuyo kaka baakpo Solomo eto Lekpata. ");
INSERT INTO lip_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ite bǝ betidi bamba kpǝ éfi lelabi ku díbu bǝtǝ bafokanɔfɔ tsyaa, báte sikpi bámfo budufǝ lǝ mǝ nti. ");
INSERT INTO lip_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Tsya fɛɛ betidi kpǝ, basani ku besio ésinkli lǝ nkpǝ bua bo bensi kama nya báfo Bonamute bánɔ. ");
INSERT INTO lip_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Nya betidi lékpa mǝ befimfi bálabesǝ lǝ mǝ belabekǝ ǝsuǝ lǝ kpakpaakpe kaka bébu bǝ Petro ebɔyɛ lǝ ɔlɛ botsyilama, lǝ wǝ koyo lǝ kokpo lǝ befimfi bamfó ǝsuǝ lǝ bǝmuǝ ale. ");
INSERT INTO lip_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Nya betidi kpǝ lǝ kǝmǝ ka letsyilama Yerusalem lékpa mǝ befimfi ku mba awɔnɔ bua nlɛ bule báboko mǝ ɔflɔ nya bátsya mǝmblɛ bufi. ");
INSERT INTO lip_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Nya Yudafɔ eto Usumunyǝ Ninǝ Kenke ku wǝ betidi ba ni Sadukifɔ eto ditsyukpa lɛsɛsǝ ǝnǝmi kekleke lǝ batɔnkpe bamǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Lǝ nyamfo esoo, bǝmuǝ mǝ bákpe lǝ umǝ eto diyo. ");
INSERT INTO lip_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Lǝ kǝtsyǝ kamfóo, Onanto eto ɔtɔnkpe utsyuǝ ǝbǝ ɔ́sini diyo nǝmǝ eto siku nya úlǝkǝ mǝ nya ɔ́tɛyi mǝ nkǝ, ");
INSERT INTO lip_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Bidu bisu Yudafɔ eto Disumuyo lǝ bisu bidi betidi ba kenke etiki itsyi lǝ nkpǝ fɔfɔ bomǝ ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Nyaso se kale dísiǝǝ, lǝ kase Onanto eto ɔtɔnkpe lɛtɛyi mǝ ǝsuǝǝ, bésu bédufǝ Disumuyo mfó nya bétsyiko mǝ asa bote. Lǝ lefe nǝmfoo, Usumunyǝ Ninǝ ku wǝ betidi ákpadi Yudafɔ kenke eto beninǝ itǝ botsya nya bákpe betidi bǝtsyuǝ bǝ besu bǝlǝkǝ batɔnkpe bamǝ lǝ diyo nǝmǝ baboko. ");
INSERT INTO lip_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Fɛɛ se bésu mfóo, bǝnnyǝ mǝ! Nyaso bésinkli bǝbǝ bátɛyi mǝ bǝnkǝ, ");
INSERT INTO lip_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Se búsuu, búnyǝ buǝ diyo nǝmǝ eto biku kenke ti, nya mba laase kesie ńyǝ mfó. Fɛɛ se bɔ́sini bikuu biamǝǝ, bóǝnnyǝ betidi bamǝ eto kuutsyuǝ lǝ diyo nǝmǝ kafo.” ");
INSERT INTO lip_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Lefe nǝ mba laase Disumuyo nǝmǝ eto uninǝ ku besumunyǝ ninǝ bamfo lɛnɔ ditiki nǝmfoo, íyifo mǝ yanii tinti, itsyise bánte lesa nǝ díbǝ lǝ batɔnkpe bamǝ lǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Nyamfo eto kamaa, utsyuǝ ǝbǝ ɔ́tɛyi mǝ nkǝ, “Betidi ba bímuǝ békpe lǝ diyoo, bebe, nyǝ mǝ ńyǝ lǝ Disumuyo nǝmǝ banlɛ betidi asa botee!” ");
INSERT INTO lip_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Lamfolamfoo, mba laase mfo eto uninǝ ku wǝ betidi édu bésu Disumuyo mfo bésu bǝmuǝ mǝ baboko. Fɛɛ se báte sikpi bǝ betidi bamǝ ebubǝ bato mǝ aba esoo, bǝnnǝ mǝ lǝ ǝsuǝale ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Se bákpa mǝ bésuko, bésu bǝńyǝnsǝ mǝ lǝ bakponkpo bamǝ eto ǝnǝmi. Usumunyǝ Ninǝ átɔ mǝ nkǝ, ");
INSERT INTO lip_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Bóantɛyi mi boǝnkǝ biensidi etiki bɛtɛyi kulesa itsyi lǝ Yesu ǝmfo ǝsuǝ? Fɛɛ bíusensǝ wǝ ditiki nǝmǝ békpo lǝ Yerusalem kenke. Nya bela biǝ biefi wǝ ukpǝ eto dikpilolo bitǝkǝ bo lǝ ǝsuǝ!” ");
INSERT INTO lip_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Mfó nya Petro ku batɔnkpe bamba bamǝ dílǝkǝ kɛnyɛ bátɛyi bǝ, “Etiki eto ɔnukualɛ ni bǝ Onanto ni futsyǝ ele bǝ butsyue koto, inni utidi. ");
INSERT INTO lip_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Yesu wǝ bélo se bítǝ básɔ bámanklasǝ lǝ uyikabie ǝsuǝǝ, bo bana eto Onantoo, ni nwǝ létakasǝ wǝ utsyiko ɔkɔmǝ úbǝ nkpǝ nɛ. ");
INSERT INTO lip_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Onanto ǝtsyǝ wǝ lǝ wǝ sediani lǝ kato kaka ni kakplɛkɔ kenke fe ɔtɔnkotɔnko ku Ofomfokǝtǝ itǝ lǝ Israelfɔ lǝ bǝnyǝ kusu batsyi mǝ akɔɛsi bawuninsǝ lǝ Onanto lǝ ufi mǝ abua ɔtsyɛ mǝ. ");
INSERT INTO lip_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Bo ku Lɛwɔnɔ Kɛnkɛ, nǝ Onanto leefi kǝtǝ mba leetsyue wǝ koto ni mba ni ditiki nǝmfo eto badansiɛ.” ");
INSERT INTO lip_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Se bakponkpo bamǝ lɛnɔ ditiki nǝmfo lǝ batɔnkpe bamǝ eto kɛnyɛɛ, kafo esi kányi mǝ tinti, nyaso báse nnya uyi bǝnkǝ ele bǝ balo mǝ. ");
INSERT INTO lip_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Fɛɛ Farisifɔ eto osani ɔni wǝ lɛkɛ lǝ bakponkpo bamǝ nti baakpo Gamaliel áni ko mǝ. Úyifo utidi wǝ betidi kenke díkebu tinti, nya úyifo afi eto oteasa tsya. Wǝ ni futsyǝ létaka uńyǝ ɔ́tɛyi nkǝ, bǝtǝ lǝ batɔnkpe bamǝ lǝ babɔ, fɛ lǝ befi nsusu lǝ etiki nyamǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Nya ɔ́tɛyi mǝ nkǝ, “Israelfɔ, bɛlɔ bebe sinini lǝ lesa nǝ bela biǝ bieyifo betidi bamfo! ");
INSERT INTO lip_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Lefe ditsyuǝ nǝ lefe mmǝǝ, osani utsyuǝ wǝ lɛkɛ baakpo Teuda, wǝ dífi wǝ ǝsuǝ uyifo fe uninǝ wǝ nkpe díbu onso. Betidi alofa ana dítǝkǝko wǝ. Nya lefe nǝ bálo wǝǝ, wǝ betidi ba dítǝkǝko wǝ ésensǝ, nya wǝ ditsyukpa nǝmǝ léba. ");
INSERT INTO lip_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Lǝ nnya kamaa, lǝ betidi eto leklafee, Yuda wǝ ni Galileanyǝ ákpa betidi ókpo lǝ ǝsuǝ fe wǝ bǝtǝkǝkotsyuǝ. Nko ke se úkpǝǝ, wǝ bǝtǝkǝkotsyuǝ mfó ko dísensǝ. ");
INSERT INTO lip_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Nyaso lesa nǝ minyǝ mɔɔtɛyi mi ko ni bǝ, beyani betidi bamfo. Lǝ asa nnya banlɛ bote nye asa nnya banlɛ buyifo eyifo mǝ kosate eto etsyuesaa, yǝmbɔklɛ fɛ yuusensǝ ");
INSERT INTO lip_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Fɛɛ lǝ Onanto eto etsyuesa inii, boǝmbofo mǝ kusu buti. Lǝ boambe kukɔnɔ kulaa tsyaa, buubǝ bunyǝ boǝ bɔlɛ botaka kǝńyǝ lǝ Onanto Kosate ǝsuǝ!” ");
INSERT INTO lip_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Bakponkpo bamǝ áfo Gamaliel eto nsusu bo útǝ mǝ. Nyaso bákpadi batɔnkpe bamǝ báboko mǝ nti, nya báblɛ mǝ. Nya besi bǝkǝ mǝ ato bǝ bensi tɛyi kulesa saa itsyi lǝ Yesu eto ditiki ǝsuǝ bio. Nya báyani mǝ bédu. ");
INSERT INTO lip_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Se batɔnkpe bamǝ dídu lǝ lekpokakpokɔ bantɔɔ, bǝnyǝ disuǝyuǝ tinti, itsyise bǝnyǝ bǝnkǝ Onanto ákla mǝ ókpe lǝ betidi ba baakpe kofani lǝ Yesu eto disi nti. ");
INSERT INTO lip_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Nya diyi saa, bákate Ditiki Sɛɛ nǝme kátɛyi lǝ Yudafɔ eto Disumuyo ku ayo ayo kafe bǝnkǝ Yesu ni Nwǝ Onanto Lékpo Ɔhile Utsyǝ. ");
INSERT INTO lip_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Lefe nǝmfo se bakasebi bamǝ dítsyiko bufuii, kǝnǝ ǝbǝ kédufǝ lǝ Yudafɔ ba laatɛyi Sigriki ku mba laatɛyi Sihebri eto nti. Nnya ni bǝ lǝ bésie diyi eto lesaa, díankayo mba laatɛyi Sigriki eto bakɔ besiǝ. ");
INSERT INTO lip_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Lǝ nyamfo esoo, lefosi inuǝ bamǝ ákpadi bafokanɔfɔ bamǝ kenke, nya bátɛyi mǝ bǝnkǝ, “Yanlɛkɛ bǝ bobiasǝ lefe lǝ didisa siesie eto etiki ǝsuǝ lǝ lefe nǝ ele bǝ bufi bo lefe kenke butǝ Ditiki Sɛɛ nǝmǝ eto budi. ");
INSERT INTO lip_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","4","Nyaso mɔmɔɔ, bayimi, betsyilamasǝ ǝnǝmi lǝ bilǝkǝ basani ekuanse ba nyi kobe nya Lɛwɔnɔ Kɛnkɛ nsi ko mǝ. Buufi mǝ butsyǝ lǝ keyifo kamfo eto kɛnyɛ itǝ bǝ bofo lefe bɔkɛ itǝ olatoto ku Ditiki Sɛɛ nǝmǝ letsya bobe.” ");
INSERT INTO lip_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ditiki nǝmǝ álɛkɛ itǝ mǝmblɛ kenke, nyaso bǝlǝkǝ Stefano wǝ ni utidi wǝ nkpe bofokanɔ nya Lɛwɔnɔ Kɛnkɛ nsi ko wǝ lefe saa. Nya bǝlǝkǝ Filipo ku Prokoro ku Nikanɔ ku Timona ku Parmena ku nwǝ díkafiani Yudanyǝ wǝ baakpo Nikolas wǝ ditsyi Antiokia. ");
INSERT INTO lip_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Bǝlǝkǝ betidi ekuanse bamfo báte batɔnkpe bamǝ. Nya báto ola bǝtǝkǝ mǝ ani lǝ disi itǝ keyifo kamǝ eto buyifo. ");
INSERT INTO lip_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Lǝ nyaso Onanto eto Ditiki Sɛɛ nǝmǝ dísukosǝ busǝnsǝ kakpe. Nya bafokanɔfɔ lǝ Yerusalem dífui bakpe. Yudafɔ eto besumunyǝ kpǝ tsya átsyi báwuninsǝ báfo Ditiki Sɛɛ nǝmǝ. ");
INSERT INTO lip_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Nyaso Stefano wǝ Onanto lékpo atsyɔ útǝ ǝsuǝalee, éyifo ayanisa kpǝ lǝ betidi bamǝ nti. ");
INSERT INTO lip_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Fɛɛ Yudafɔ ba díkafo mǝ ǝsuǝ ǝsuǝ eto busiǝ ba dítsyi Kirene ku Aleksandria ku bǝtsyuǝ ba dítsyi Kilikia ku Asia eto ditsyukpa étsyiko etiki bunǝ ku Stefano. ");
INSERT INTO lip_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Fɛɛ mǝ kutsyuǝ saa mámfo buńyǝ lǝ wǝ ǝnǝmi lǝ kobe ko Lɛwɔnɔ Kɛnkɛ dítǝ wǝ eso. ");
INSERT INTO lip_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Nyaso bákpe disi ku betidi bamba bǝ lǝ batɛyi bidia lǝ wǝ ǝsuǝ bǝ, “Bɔ́nɔ se úkedi etiki uńyǝ lǝ Moses ku Onanto tsya ǝsuǝ!” ");
INSERT INTO lip_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Kɛnyɛlala kamfo ǝnǝ lefonyi lékpe lǝ betidi bamfo ku beninǝ ku afi eto bateasa bamǝ kenke ǝsuǝ. Nya bǝmuǝ Stefano nya béfi wǝ bésuko bakponkpo eto ǝnǝmi. ");
INSERT INTO lip_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Nya báboko betidi bǝtsyuǝ ba lékle kɛnyɛ bátɛyi sidia bǝnkǝ, “Osani ǝmfo ékedi etitiki lefe saa kǝńyǝ lǝ Disumuyo Kɛnkɛ kamfo ku lǝ Moses eto kɔfi ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Nya bɔ́nɔ bǝ ɔ́tɛyi tsya nkǝ utidi ǝmǝ ditsyi Nasaret baakpo Yesu mfóo, átɛyi nkǝ wooba Onanto eto Disumuyo Kɛnkɛ kamfo nya woofloma akpa nnya Moses dítǝ bo!” ");
INSERT INTO lip_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Nya mba kenke lɛkɛ lǝ lekpokakpokɔ mfó létakasǝ ǝnǝmi bákpo lǝ Stefano ǝsuǝ, nya bǝnyǝ bǝ wǝ ǝnǝmi ǝkǝyǝnde fe kato eto ɔtɔnkpe eto ale. ");
INSERT INTO lip_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Nya Usumunyǝ Ninǝ Kenke lɛtɔ Stefano nkǝ, “Etiki nnya banlɛ budi mfoo, sitinti ini banlɛ bɔtɛyi?” ");
INSERT INTO lip_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Nya Stefano dítǝ wǝ mbuayɛ nkǝ, “Boantomǝ ku mɔ bayimi, bitsyue koto kukɔnɔ lǝ bɛnɔ! Diyǝnde eto Onanto ǝlǝkǝ wǝ ǝsuǝ óte bo ona Abraham lǝ Mesopotamia eto kasɔ fɛ údu mfo úsu úsiǝ lǝ kasɔ ka baakpo Haran. ");
INSERT INTO lip_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ɔ́tɛyi wǝ nkǝ, ‘Taka lǝ edu lǝ kasɔ kamfo ku lǝ fǝ betidi ɔflɔ lǝ esu kasɔ ka moote fǝ ǝsuǝ!’ ");
INSERT INTO lip_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Nyaso údu lǝ wǝ kasɔ nya úsu úsiǝ lǝ Haran. Lǝ Abraham eto anto eto ukpǝ eto kamaa, nya Onanto lékpa wǝ óboko kasɔ ka binsi mfo mmi nɛ. ");
INSERT INTO lip_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Onanto mémbudi kasɔ kamfo eto dikuku sɛkɛ saa útǝ Abraham fe wǝ kale, inni lɛ kokpa kɔni. Bomu ɔ́tɛyi wǝ ɔtɔnsǝ nkǝ kasɔ kamǝ ebofiani wǝ ku wǝ befluflu eto kale, ite bǝ ibǝ ese lefe nǝmfóo, ubi saa mánkɛ wǝ. ");
INSERT INTO lip_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Nnya Onanto lɛtɛyi wǝ ni nkǝ, ‘Fǝ befluflu ebofiani bafɔ lǝ kasɔ ka lenni mǝ kalɛ ǝsuǝ. Boosiǝ mfo fe ndomufɔ nya boote mǝ ohiã itǝ alɛ alofa ana flɔflɔflɔ.’ ");
INSERT INTO lip_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Nya usi ɔ́tɛyi wǝ tsya nkǝ, ‘Moolo betidi ba díyifo mǝ mǝ ndomufɔ dikpi. Nya lǝ nnya kamaa, buudu lǝ kasɔ kamfó bǝbǝ basumu mɛ lǝ kaka mfo.’ ");
INSERT INTO lip_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Mmǝǝ ini Onanto lékle kɛnyɛ ku Abraham ini lelolala eto kɛnyɛklekle nɛ. Nyaso Abraham ála Isak lelo lǝ diyi flamflale se bále wǝ. Isak tsya ála Yakob lelo, nya Yakob tsya léla lelo lefosi bebi inuǝ ba bále díbǝ báfiani Yudafɔ eto ese lefosi ǝnuǝ ba lefo diye. ");
INSERT INTO lip_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Yakob eto bebi bamfo ásɛsǝ ǝnǝmi lǝ mǝ ɔyimi Yosef ǝsuǝ. Nya bǝmuǝ wǝ báte fe ndomunyǝ lǝ Egipte eto kasɔ. Fɛɛ Onanto ǝsiǝko wǝ, ");
INSERT INTO lip_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","nya úlǝkǝ wǝ útsyiko kanyi ku bulǝ saa ǝsuǝ. Se Yosef lɛbɔ úńyǝ lǝ Egipte eto Oka Farao eto ǝnǝmii, Onanto ǝtǝ wǝ ditsyǝbi sɛɛ ku kobe, itǝ Oka ǝmǝ éfi wǝ útsyǝ nwǝ laabe Egipte eto kasɔ ku wǝ diyo ku bikǝ kenke. ");
INSERT INTO lip_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Lǝ lefe nǝmfoo, kukpɛnsɛ kekleke ǝbǝ lǝ Egipte ku Kanan eto nsɔ kenke, nya ínǝ kanyinyǝnyǝ kpǝ éboko. Bo bana mánkɛ didisa nǝ buudi. ");
INSERT INTO lip_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Nya se Yakob lɛnɔ nkǝ didisa kpe lǝ Egipte, ókpe wǝ bebi ba ni bo bana ditutɛ nkǝ besu baya didisa baboko wǝ. ");
INSERT INTO lip_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Lǝ mǝ dísu nuǝfǝǝ, Yosef ǝlǝkǝ wǝ ǝsuǝ óte wǝ bayimi nya Egipte eto Oka tsya díbǝ óte Yosef eto bayimi bamǝ. ");
INSERT INTO lip_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Lǝ nnya eso Yosef ákpe wǝ bayimi nkǝ besu bakpa wǝ anto Yakob ku wǝ betidi kenke ba diyifo fe betidi fosi akuanse ku ɛnɔ báboko. ");
INSERT INTO lip_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Nyaso Yakob édu úsu Egipte kaka wǝ ku wǝ bebi díkpǝ. ");
INSERT INTO lip_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Kamaa, bétsyi bǝkpǝnkpǝ bamǝ bésinkli bésuko umǝ wǝ baakpo Sikem bésu bébikǝ mfó. Bébikǝ mǝ lǝ kudi ko Abraham léya ku sika flubia eto atabi ǝtsyuǝ lǝ Hamɔ eto bebi ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Se kɛnyɛtsyǝtsyǝ ka Onanto dítsyǝ útǝ Abraham eto lefe nlɛ boyoo, wǝ befluflu ba mfe nkpe lǝ Egipte ébole béfui tinti. ");
INSERT INTO lip_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Kafɛfɛkɔɔ, Oka fɔfɔ wǝ dímante Yosef étsyiko seka budi lǝ Egipte eto kasɔ. ");
INSERT INTO lip_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Farao emfo ǝlǝkǝ nsusu bua úyifo Abraham eto befluflu bamfo disiale nya úkisi mǝ tsya. Itǝ ɔ́hiɛ mǝ bǝlǝkǝ mǝ bebisambi ba bále lǝ ayo báto bákpe lǝ kase buukpǝ. ");
INSERT INTO lip_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Lefe nǝmfo eto lefe nnya bále Moses nɛ. Nya bǝnyǝ bǝ úyifo ubi wǝ laanɔ bobe tsya. Lǝ nyamfo esoo, wǝ antomǝ éfi wǝ bákula afa ǝtsyǝ sɔ̃ɔ̃ lǝ diyo. ");
INSERT INTO lip_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Nya lefe nǝ bǝnyǝ bǝ bensiembofo wǝ bɔkulaa, bǝlǝkǝ wǝ lǝ mǝ ǝsuǝ. Nya Farao eto ubisiobi dísu ɔ́kɛ wǝ nya úfi wǝ ófianisǝ wǝ kafo eto ubi. ");
INSERT INTO lip_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Óbe wǝ nya békluǝsǝ wǝ fe Egiptenyǝ lǝ mǝ esu ku mǝ asayifofo ǝsuǝ. Nya óbe ófiani utidi wǝ lɛkɛ ǝsuǝale lǝ wǝ etikididi ku wǝ eyifosa kenke ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Se Moses léfo alɛ fosi anaa, íbǝ wǝ lǝ nsusu nkǝ lǝ usu obe kase banlɛ wǝ bayimi Israelfɔ buyifo. ");
INSERT INTO lip_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Lǝ lefe nǝ úsu mfoo, únyǝ kase Egiptenyǝ nlɛ mǝ ɔni disiale buyifo. Esoo, úsu ɔ́wunsǝko wǝ ɔ́sɔ Egiptenyǝ ǝmfo ólo. ");
INSERT INTO lip_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moses ébu nkǝ wǝ kosate eto betidi ǝbɔnɔ kasɔ nkǝ Onanto ebɔyɛ lǝ wǝ ǝsuǝ úlǝkǝ mǝ, fɛɛ mǝ mánnɔ nnya kasɔ nko. ");
INSERT INTO lip_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Kǝsiǝsǝǝ, únyǝ Israelfɔ inuǝ ba nlɛ bɔkpɔ. Úsu nkǝ lǝ usu okpla mǝ nya ɔ́tɛyi mǝ nkǝ, ‘Bebee! Bayimi, bini! Yanle bǝ bikakpɔ keyifo lesafimfi mi bǝtsyua nko!’ ");
INSERT INTO lip_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Nya mǝ inuǝ bamǝ eto nwǝ nlɛ wǝ ɔyimi disiale buyifo dínǝ Moses útsyǝ kutsyǝ nya ɔ́tɔ wǝ nkǝ, ‘Be leka fǝ lǝ nnya ǝsuǝ? Owoe dílǝkǝ fǝ bo ɔtɔnkotɔnko ku okponkpo lǝ bo etiki nyamfo ǝsuǝ fɛ? ");
INSERT INTO lip_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Lee, ala fǝ aalo mɛ fe kase fálo Egiptenyǝ ǝmǝ kǝnǝ?’ ");
INSERT INTO lip_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Se Moses lɛ́nɔ ditiki nǝmfoo, útsyetsyi úsu ɔ́biɔ lǝ Midia eto kasɔ fe ɔfɔ. Nya mfó óle bebisaibi inuǝ. ");
INSERT INTO lip_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Lǝ alɛ fosi ana eto kamaa, Onanto eto ɔtɔnkpe ǝlǝkǝ ǝsuǝ óte wǝ fe ute wǝ nlɛ biyu eto kuyi botonsǝ eto ditsyǝbi lǝ Sinai eto kɔtini ɔflɔ lǝ mfiminti mfo. ");
INSERT INTO lip_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Se Moses dínyǝ nyamfo nkoo, íyifo wǝ naa. Nyaso lefe nǝ ɔ́nyi ɔ́fi nkǝ lǝ obe lesa nǝ inii, nnya Onanto eto ɔkɔɛ ábɔ ɔ́tɛyi nkǝ, ");
INSERT INTO lip_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Mɔ ni fǝ banamǝ eto Onanto, Abraham ku Isak ku Yakob eto Onanto.’ Moses étinkǝ ku sikpi eso wénsifo mfó bobe. ");
INSERT INTO lip_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Onanto ǝmǝ átɛyi wǝ nkǝ, ‘Lǝkǝ fǝ afokpa! Itsyise kaka fǝńyǝǝ, kasɔ kɛnkɛ keni. ");
INSERT INTO lip_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Mbunyǝ kase mɔ betidi nlɛ kanyi bunyǝ lǝ Egipte eto kasɔ mfó. Mbɔnɔ mǝ bɔwɔnɔnɔ ku nku bo banlɛ kakpadi mɛ. Nyaso mbubǝ miǝ lǝ mbǝ nlǝkǝ mǝ. Bǝ, mookpe fǝ kɔtɔ lǝ Egipte!’ ");
INSERT INTO lip_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Moses emfo ni utidi wǝ Israelfɔ lɛ́ni nya bátɔ wǝ bǝnkǝ, ‘Owoe dílǝkǝ fǝ bo ɔtɔnkotɔnko ku okponkpo lǝ bo etiki nyamfo ǝsuǝ fɛ?’ Wǝ ni nwǝ Onanto létsyese nkǝ udi seka lǝ mǝ ǝsuǝ ku mǝ Ofomfokǝtǝ, ɛyɛ lǝ Onanto eto ɔtɔnkpe wǝ dílǝkǝ ǝsuǝ óte lǝ ute wǝ díkǝnyǝ lǝ mfiminti mfó nɛ. ");
INSERT INTO lip_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ókpa mǝ betidi bamǝ údunko lǝ Egipte nya úyifo ayanisa úlǝkǝ asa kpǝ óte lǝ Egipte eto kasɔ ku lǝ Lekpo Sia eto kɛnyɛ ku lǝ lefe nǝ banyɛ lǝ mfiminti alɛ fosi ana sɔ̃ɔ̃. ");
INSERT INTO lip_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Moses ǝmfo ni nwǝ lɛtɛyi Israelfɔ nkǝ, ‘Onanto ebotsyese mi wǝ unyɛlǝkǝtidi fe kase ótsyese mɛ, nya wuulǝkǝ wǝ utsyiko lǝ mi kosate eto nti.’ ");
INSERT INTO lip_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Wǝ ni nwǝ lɛtɔnko Israelfɔ ba lɛkɛ lǝ mfiminti mfó. Wǝ lɛkɛ mfó ku bo banamǝ. Wǝ ni nwǝ dídinko Onanto eto ɔtɔnkpe etiki lǝ Sinai eto kɔtini ǝsuǝ. Wǝ nsi ni futsyǝ léfo Onanto eto ditiki nǝ lǝǝtǝ nkpǝ óboko bo. ");
INSERT INTO lip_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Fɛɛ bo banamǝ mámfo Moses eto etiki nyamǝ nyaso bǝkǝ wǝ bǝtsyǝ kutsyǝ nya bála bǝ eni lǝ beesinkli besu Egipte eto kasɔ. ");
INSERT INTO lip_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Nyaso bátɛyi Aaron bǝnkǝ, ‘Tsyǝ bǝfiǝ ba loofo bo bɔtɔnko ǝtǝ bo, itsyise boante lesa nǝ dísu íyifo Moses ǝmfo wǝ dínǝ bo ɔ́bɔnko lǝ Egipte eto kasɔ.’ ");
INSERT INTO lip_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Lǝ nyaso báto ufiǝ fe onantsyui eto ubi. Wǝ bǝkǝtǝ kedi nya bǝnyǝ disuǝyuǝ diyi nǝmfo lǝ ufiǝ ǝmǝ béfi mǝ ani béyifo mfó eso. ");
INSERT INTO lip_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Lǝ nyamfo eso Onanto étsyi kama ókpe mǝ. Nya oyani mǝ utǝ kofe ku kofande ku befandebi eto kesumu, fe kase báwɔni bákpe lǝ bɛnyɛlǝkǝtidi eto kukue nkǝ, ‘Israelfɔ, inni mɔ bélo bebuki bítǝ kedi lǝ alɛfosi ana nnya bɛkɛ lǝ mfiminti mfó. ");
INSERT INTO lip_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Bomu Molok eto dibú ku Romfa eto befandebi bia béfianinsǝ bǝfiǝ ba bíkǝtǝ kedi nɛ. Lǝ nyaso muutǝ bǝmuǝ mi besuko kasɔ fãã lǝ Babilonia eto kama bisu bɛkɛ mfo.’ ");
INSERT INTO lip_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Bo banamǝ étsyi Onanto eto diyo nya ɔ́tɔ, ɔ́yɛnko mǝ lǝ mfiminti kafo. Báto diyo nǝmǝ fe kase Onanto dílǝkǝ óte Moses nkǝ bato ni pɛpɛɛpɛ. ");
INSERT INTO lip_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Kama kamaa, bo bana ba léfo diyo nǝmǝ betsyiko lǝ mǝ antomǝ ɔflɔɔ, étsyi ni ku mǝ lǝ lefe nǝ báyɛ ku Yosua, nya bésu báfo kasɔ kamǝ betsyiko lǝ ese nnya Onanto lélà lǝ mfó se bántɔ. Nya lɛkɛ lǝ mǝ nti mfó isu ese Oka David eto lefe. ");
INSERT INTO lip_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Onanto ála David eto asa tinti. Lǝ nnya eso David átɔ Onanto nkǝ utǝ wǝ kusu lǝ oto kǝsiǝkɔ utǝ wǝ, Yakob eto Onanto. ");
INSERT INTO lip_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Fɛɛ Salomo ko díbǝ óto diyo nǝmǝ. ");
INSERT INTO lip_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Fɛɛ Onanto Ǝsuǝalenyǝ Kenke ǝnsiǝ lǝ ayo nnya kawunsiǝ mfo eto betidi léto. Onanto áyɛ lǝ wǝ bǝnyɛlǝkǝtidi ǝsuǝ ɔ́tɛyi nkǝ, ");
INSERT INTO lip_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Kato ni mɔ sekakedikɔ eto lekpomɛ, nya kasɔ ni mɔ akpa eto kǝtǝkǝkɔ. Lǝ nnya esoo, nte diyo nǝ eto okle footo ǝtǝ mɛ. Sie ni kaka ele bǝ nsiǝ? ");
INSERT INTO lip_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Lee, inni mɔ kosate díyifo asa nyamfo kenke?’ ” ");
INSERT INTO lip_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Lǝ nyaso Stefano ési ɔ́tɛyi mǝ nke, “Letotidi kon eto betidi bini! Ntsyǝ bimbǝ bofokanɔ mǝ! Bíti ato lǝ Onanto eto ditiki ǝsuǝ fe kase mi antomǝ díyifo. Lefe saa biataka kǝńyǝ lǝ Lɛwɔnɔ Kɛnkɛ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nte Onanto eto bǝnyɛlǝkǝtidi ba mi banamǝ dímǝńyǝ lǝ ǝsuǝ? Bálo Onanto eto bǝnyɛlǝkǝtidi ba díbǝ bábe letsya taa kɔ bǝ Ɔsɛɛtidi Wǝ Onanto Lékpo Ɔhile Utsyǝ lɛ bubǝ. Nya Ɔsɛɛtidi Wǝ Onanto Lékpo Ɔhile Utsyǝ ǝmǝǝ, wǝ bɛni nya bíkǝ wǝ bítǝ bálo wǝ nɛ. ");
INSERT INTO lip_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Mi ni mba léfo Onanto eto kɔfi ko útǝ mi ɛyɛ lǝ Onanto eto ɔtɔnkpe eto ani, fɛɛ bɛni bíentsyue ko koto!” ");
INSERT INTO lip_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Se bánɔ etiki nnya Stefano lɛtɛyi lǝ mǝ ǝsuǝǝ, kafo ányi mǝ tinti nya báyimi mǝ anyi ku lɛblɔfi. ");
INSERT INTO lip_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Fɛɛ se Lɛwɔnɔ Kɛnkɛ nsiko Stefano esoo, óbesǝ wǝ ǝnǝmi kato fãã, nya únyǝ Onanto eto diyǝnde ku Yesu wǝ ńyǝ lǝ wǝ sediani. ");
INSERT INTO lip_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Nya ɔ́tɛyi mǝ nkǝ, “Bebe! Nnyǝ se kato lɛsini nya mínyǝ Utidi eto Ubi ǝmǝ se uńyǝ lǝ Onanto eto sediani!” ");
INSERT INTO lip_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Nya báfã bembembe nya béti mǝ ato eto kafo nya bédufǝ wǝ lǝ ǝsuǝ bǝmuǝ wǝ. ");
INSERT INTO lip_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Nya bǝnǝ wǝ bábɔnko lǝ umǝ ǝmǝ, nya bétsyiko wǝ aba. Nya mba ǝmǝ dínǝ wǝ bábɔnkoo, bǝlǝkǝ mǝ awukplɛ nnya bankpe bǝtsyǝ lǝ okosobi wǝ baakpo Saulo eto akɔ. ");
INSERT INTO lip_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Nya lefe nǝ banlɛ wǝ aba bɔkpɔɔ, Stefano ákpadi Bonamute nya óto ola nkǝ, “Bonamute Yesu, fo mɔ lɛwɔnɔ!” ");
INSERT INTO lip_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Óse akonki nya ófa bembembe ɔ́tɛyi nkǝ, “Bonamute, fi mǝ abua nnya béyifo mfo atsyɛ mǝ!” Nya se ɔ́tɛyi nyamfo ólosǝǝ, úkpǝ. ");
INSERT INTO lip_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Lǝ lefe nǝ banlɛ Stefano boloo, Saulo ni futsyǝ díkǝdi ute kakpe mǝ. Diyi nǝmfo ke nya bétsyiko bɔkpɔ ku bafokanɔfɔ kate mǝ ohiã lǝ Yerusalem. Nya mǝmblɛ dítsyetsyi bésu Yudea ku Samaria eto lekpake. Fɛɛ batɔnkpe bamǝ alɛɛ, mǝmǝ akɛ lǝ mfó. ");
INSERT INTO lip_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Nya mba léfo Yesu bánɔ eto bǝtsyuǝ ésu bétsyi Stefano bésu bébikǝ ku nkuɛnlo. ");
INSERT INTO lip_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Lǝ nnya kamaa, Saulo ǝtǝkǝko nya úlǝ bafokanɔfɔ bamǝ kekleke nya údufǝ ayo kafo úkabɛbɛ basani ku besio ta kǝnǝ kǝlǝkǝ kakpe mǝ lǝ ayo. ");
INSERT INTO lip_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Nya bafokanɔfɔ lǝ mfó ésensǝ bésu kalebe saa nya banlɛ Boanto eto Ditiki Sɛɛ nǝmǝ letsya bobe. ");
INSERT INTO lip_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Nya Filipo wǝǝ, údu úsu Samaria nya ɔ́tɛyi betidi Ditiki Sɛɛ nǝmǝ itsyi lǝ Nwǝ Onanto Lékpo Ɔhile Utsyǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Betidi kpǝ étsyue ato bánɔ etiki nnya ɔnlɛ budi itsyise bǝnyǝ ayanisa kpǝ nnya úyifo eso báfo wǝ ditiki nǝmǝ. ");
INSERT INTO lip_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Óla awɔnɔ bua kpǝ utsyiko lǝ betidi ǝsuǝ, nya nkomǝ eto awɔnɔ bua nyamfó lékpo kudu bembembe fɛ bábɔ lǝ mǝ ǝsuǝ. Nya ótsya mba eto ani ku akpa díkpǝ ku mba léba bákpo lǝ kasɔ tsya nya bátaka báyɛ. ");
INSERT INTO lip_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Nyamfo esoo, disuǝyuǝ akɛ lǝ Samaria eto umǝ tinti! ");
INSERT INTO lip_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Osani utsyuǝ akɛ lǝ Samaria baakpo Simon, uyifo utsyuǝ wǝ leeyifo afantosi eto afa. Lǝ lefe kɛntsyɛ nǝ léfe ǝsuǝǝ, uyifo utsyuǝ wǝ díkatsya betidi kekleke nya íkeyifo betidi yanii. Nya úkǝbú wǝ ǝsuǝ ɔkplɛnyǝ wǝ lefé lǝ wǝ eyifosa ku etiki nnya úkedi eso. ");
INSERT INTO lip_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Samariafɔ eto bekpefi ku beninǝ kenke ékebu wǝ lǝ kase úkate ǝsuǝ keyifo eso. Le nnya esoo, béfi wǝ etikididi fe, “Wǝ ni Onanto eto ǝsuǝale nya baakpo Ǝsuǝale Kplɛ.” ");
INSERT INTO lip_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Se úkeyifo afa éfo lefe kɛntsyɛ esoo, béfi mǝ ǝnǝmi bǝtǝkǝ lǝ wǝ ǝsuǝ. Itsyise beetsyuǝ wǝ koto kanɔ wǝ etiki. ");
INSERT INTO lip_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Fɛɛ mɔmɔɔ, báfo Filipo eto ditiki nǝ ɔnlɛ bɔtɛyi banɔ itsyi lǝ Onanto eto Sekadidi ku Yesu Kristo ǝsuǝ. Nya basani ku besio kpǝ léfo ntuflǝsǝflǝsǝ eto lekpa lǝ Bonamute Yesu Kristo eto diye ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Nya Simon ǝmǝ mfo tsya léfo ɔ́nɔ. Nya lefe nǝ ófo ntuflǝsǝflǝsǝ eto lekpa nǝmfoo, úkǝtǝkǝko Filipo kesu kalebe saa ka ɔntɔ. Nya lǝ ǝnyǝsa ku ayanisa nnya úkeyifo esoo, íyifo wǝ naa! ");
INSERT INTO lip_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Nya lefe nǝ batɔnkpe ba lɛkɛ lǝ Yerusalem lɛnɔ bǝ Samariafɔ ébofo Onanto eto Ditiki Sɛɛ nǝmǝ banɔɔ, bákpe Petro ku Yohanes lǝ mǝ ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Se bésu bédufǝǝ, báto ola lǝ bafokanɔfɔ fɔfɔ bamǝ eto disi bǝ lǝ bafo Lɛwɔnɔ Kɛnkɛ. ");
INSERT INTO lip_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Nko ini nɛ itsyise isu ese lefe nǝmfoo, bámfo tɔ Lɛwɔnɔ Kɛnkɛ. Ntu ete bǝflǝsǝ mǝ lǝ Bonamute Yesu eto diye ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Nyamfo esoo, Petro ku Yohanes éfi mǝ ani bǝtǝkǝ mǝ lǝ esi, nya mǝ tsya léfo Lɛwɔnɔ Kɛnkɛ. ");
INSERT INTO lip_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Se Simon dínyǝ nkǝ lǝ batɔnkpe bamfo éfi ani bǝtǝkǝ mǝ lǝ esi koo, báfo Lɛwɔnɔ Kɛnkɛɛ, úfi atabi nkǝ lǝ utǝ Petro ku Yohanes nya ɔ́tɛyi mǝ nkǝ, ");
INSERT INTO lip_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Bitǝ mintsya ǝsuǝale nyamfo itǝ bǝ utsyuǝ saa ke mimfi ani mintǝkǝ lǝ ofo Lɛwɔnɔ Kɛnkɛ.” ");
INSERT INTO lip_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Nya Petro lɛtɛyi wǝ nkǝ, “Ekudi itǝ fǝ ku fǝ atabi kenke! Membu fǝ ebofo Onanto eto atɛsǝ boya ku atabi. ");
INSERT INTO lip_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Embofo lekpa saa bokpa lǝ keyifo kamfo ǝsuǝ itsyise lɛkɔɛsi mankpa fǝ lǝ Onanto eto ǝnǝmi. ");
INSERT INTO lip_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Lǝkǝ fǝ nsusu lǝ asa buayifoyifo ǝsuǝ lǝ alɛ Bonamute lekpakpa. Ǝtsyǝnǝ wuufi fǝ abua ɔtsyɛ fǝ lǝ fǝ nsusu bua bufi lǝ asa nyamfo eto okle ǝsuǝ eso. ");
INSERT INTO lip_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Itsyise nnyǝ miǝ akpe kǝnǝnsɛ kplɛ nya asa bua eto buyifo tsya eyi fǝ utu, nya fafiani ndomunyǝ itǝ lebua.” ");
INSERT INTO lip_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Nya Simon lɛtɛyi Petro ku Yohanes nkǝ, “Beto ola bɛlɛ Onanto lekpakpa bitǝ mɛ bǝ kotonǝnǝ kekleke ko bɛtɛyi mfo eto okle embubǝ mɛ lǝ ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Nya lefe nǝ Petro ku Yohanes díkedi mǝ sedansiɛ nya bédi etiki itsyi lǝ Bonamute eto Ditiki Sɛɛ nǝ mǝ ǝsuǝ lǝ Samaria mfóo, báyɛ lǝ Samaria eto kǝmǝ kpǝ bédi mǝ etiki lǝ Ditiki Sɛɛ nǝmǝ ǝsuǝ lefe nǝ besinkli bantɔ lǝ Yerusalem. ");
INSERT INTO lip_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Itǝ Filipoo, Bonamute eto ɔtɔnkpe wǝ dítsyi kato ǝbǝ ɔ́tɛyi wǝ nkǝ, “Taka lǝ esu ɔnwɛdikueti lǝ mfiminti eto kusu ko lidu lǝ Yerusalem kɔntɔ lǝ Gasa.” ");
INSERT INTO lip_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Mfo ótaka nya ɔ́yɛ kusu komǝ. Lefe nǝ ɔ́ntɔɔ, ótsyako utidi utsyuǝ lǝ kusu nlɛ bubǝ. Utidi ǝmfo éyifo uyifoyifo ninǝ wǝ nsi lǝ Etiopia eto Besio eto Oka baakpo Kandake eto sekakedikɔ eto atabi eto kɛnyɛ. Uyifoyifo ninǝ ǝmfo étsyi olakatokɔ lǝ Yerusalem. ");
INSERT INTO lip_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ɔ́tɔ lǝ oto nya unsi lǝ nkenke bo ɔtɔmini nlɛ bunǝ kafo, nya lǝ kase ɔnyɛ ɔntɔɔ, úkakla asa itsyi lǝ Unyɛlǝkǝtidi Yesaya eto Awɔnisa Kɛnkɛ eto Kukue ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Nya Lɛwɔnɔ Kɛnkɛ dídi Filipo etiki ɔ́tɛyi nkǝ, “Yɛ mlǝ lǝ etu ɔtɔmini eto nkeke bomfó.” ");
INSERT INTO lip_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filipo akɔse ɔ́yɛ útu wǝ nya ɔ́nɔ se uyifoyifo ninǝ ǝmfo nlɛ asa bokla ketsyi ko lǝ Yesaya eto kukue ko ɔ́wɔni kafo. Nya ɔ́tɔ wǝ nkǝ, “Asa nnya fanlɛ bokla mfo anɔ nnya kasɔ?” ");
INSERT INTO lip_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Nya uyifoyifo ninǝ ǝmfo dítǝ mbuayɛ nkǝ, “Owo lo, ntsyǝ yuubǝ bǝ moofo nnya kasɔ bɔnɔ lǝ lefe nǝ kuutsyuǝ saa lǝmbǝ mfo loofo nnya kasɔ bulǝkǝ kate mɛ?” Nyaso ɔ́lɛ Filipo lekpakpa nkǝ ubǝ udufǝ lǝ nkenke eto kufue komǝ kafo usiǝ lǝ wǝ ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Nya etiki nnya úkakla lǝ Kukue Kɛnkɛ eto Awɔnisa nnya nkpe mfó ni nkǝ, “Bákpa wǝ báyɛnko fe kase baayɛnko osamu kesuko wǝ kalokɔ. Nya unsi kpoo fe osamu wǝ dímemfi nnya kulesa lǝ bákɔ wǝ bisǝ, nya wémfe kɛnyɛ ɔ́tɛyi kulesa. ");
INSERT INTO lip_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Bákpe wǝ kofani, nya bǝntǝ ota wǝ ǝsuǝ disi. Kuutsyuǝ saa embofo kulesa bɔtɛyi itsyi lǝ wǝ befluflu ǝsuǝ, itsyise bála wǝ nkpǝ diku lǝ kasɔ mfo.” ");
INSERT INTO lip_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Nya uyifoyifo ninǝ ǝmfo lɛtɛyi Filipo nkǝ, “Tɛyi mɛ, wǝ kosate Unyɛlǝkǝtidi Yesaya ɔnlɛ, lee utidi bamba utsyuǝ?” ");
INSERT INTO lip_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Mmǝ nnya Filipo dítsyiko, ɔ́tɛyi wǝ asa lǝ Awɔnisa Kɛnkɛ eto Kukue komǝ ǝsuǝ, nya úlǝkǝ Ditiki Sɛɛ nǝmǝ kasɔ ku kase ɛnlɛ bote itsyi lǝ Yesu ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Nya se banyɛ lǝ kusu bantɔɔ, bésu báyo kaka ntu ntsyuǝ nńyǝ lǝ usunte ɔflɔ. Nya uyifoyifo ninǝ ǝmǝ lɛtɛyi Filipo nkǝ, “Be, nyǝ ntu ntsyuǝ! Beso fǝmbofo mɛ ntuflǝsǝflǝsǝ eto lekpa nǝmǝ buyifo mfó?” Nya Filipo lɛtɛyi wǝ nkǝ, “Lǝ afo anɔ ku fǝ utu kenkee, ebofo mu bofo.” ");
INSERT INTO lip_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Nya uyifoyifo ninǝ ǝmfo lɛtɛyi nkǝ, “Mfo nnɔ miǝ Yesu Kristo ni Onanto eto Ubi.” Nya útǝ nkǝ bǝńyǝsǝ ɔtɔmini eto nkenke bomǝ, nya bédufǝ lǝ ntu bomǝ ǝsuǝ, nya Filipo díflǝsǝ wǝ ntu. ");
INSERT INTO lip_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Nya lǝ lefe nǝ bábɔ lǝ ntu bomǝ ǝsuǝǝ, Bonamute eto Lɛwɔnɔ ákpa Filipo dídunko, nya uyifoyifo ninǝ ǝmfo ménsinyǝ wǝ bio. Úsukosǝ wǝ kusu ko ɔnyɛ ku disuǝyuǝ. ");
INSERT INTO lip_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Nnya kamaa, Filipo ǝńyǝ nkǝ uńyǝ lǝ umǝ wǝ baakpo Asoto. Idu mfóo, óbe Ditiki Sɛɛ nǝmǝ letysa lǝ kǝmǝ ka nkpe lǝ kusu mfó kenke isu ese lefe nǝ údufǝ Kaisarea eto umǝ. ");
INSERT INTO lip_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Le lefe nǝmfo kenke ǝsuǝǝ, Saulo áti kama Bonamute eto bafokanɔfɔ kekleke nkǝ lǝ olo mǝ. Nya úsu Yudafɔ eto Usumunyǝ Ninǝ Kenke ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Mfó úsu ɔ́tɔ nkǝ bǝtǝ wǝ ekue lǝ ufi ɔlɛ usuko Yudafɔ eto ntsyakɔ lǝ Damasko lǝ ɔkɛ ǝsuǝale umuǝ basani ku besio ba kenke díkafo Ditiki Sɛɛ eto kusu fɔfɔ komfo bánɔ lǝ okpa mǝ usuko Yerusalem. ");
INSERT INTO lip_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Nya lefe nǝ Saulo díkanyi ɔfi Damasko ku wǝ nsusu bomfoo, dikunǝ diyǝnde ditsyuǝ ko dítsyi kato lékpo wǝ lǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Údu ɔ́nɔ nya ɔ́nɔ ɔkɔɛ utsyuǝ nlɛ wǝ bɔtɛyi nkǝ, “Saulo, Saulo, beso fanlɛ mɛ bɔkpɔnko kekleke nko?” ");
INSERT INTO lip_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Nya Saulo lɛtɔ nkǝ, “Bonamute, fǝ owoe uni?” Ɔkɔɛ ǝmǝ ǝtǝ mbuayɛ nkǝ, “Mɔ Yesu wǝ fanlɛ bɔkpɔnko kekleke uni. ");
INSERT INTO lip_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Mɔmɔɔ, taka lǝ esu umǝ ǝmǝ. Bɔɔtɛyi fǝ lesa nǝ ele bǝ yifo.” ");
INSERT INTO lip_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Nya betidi bamǝ ku Saulo nyɛ lǝ kusu bantɔ mfó léle bǝńyǝ, bánte lesa nǝ baatɛyi. Bánɔ nkomǝ eto etikididi, fɛɛ bǝnnyǝ kuutsyuǝ saa. ");
INSERT INTO lip_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Nya lefe nǝ Saulo létaka úńyǝ fɛ úminkli ǝnǝmii, wénsifo bunyǝ. Nya bálɛ wǝ lǝ kɔni bákpa wǝ bédufǝnko Damasko eto umǝ. ");
INSERT INTO lip_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Úsiǝ mfo eyi ǝtsyǝ wǝnńyǝ asa, wéndi lesa, wǝnnǝ kulesa. ");
INSERT INTO lip_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Nya lǝ lefe nǝmfóo, okasebi wǝ léfo ɔ́nɔ ákɛ lǝ Damasko wǝ baakpo Ananias. Bonamute ǝlǝkǝ ǝsuǝ óte wǝ ókpadi wǝ ɔ́tɛyi nkǝ, “Ananias!” Nya ɔ́tɔnɔ nkǝ, “Bonamute, nnyǝ mɔɔ!” ");
INSERT INTO lip_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Nya Bonamute lɛtɛyi wǝ nkǝ, “Taka lǝ ayɛ lǝ kusu ko baakpo Kusutsyɔtsyɔ, nya lǝ esu Yuda eto diyo lǝ atɔ nwǝ baakpo Saulo wǝ ditsyi Tarso eto disi. Okpe mfo ɔlɛ ɔla boto. ");
INSERT INTO lip_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Nya lǝ bulǝkǝkate bomǝ ǝsuǝǝ, únyǝ osani utsyuǝ wǝ baakpo Ananias wǝ díbǝ úfi ani útǝkǝ wǝ lǝ disi itǝ bǝ usinkli nyǝ asa.” ");
INSERT INTO lip_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Mfo nya Ananias dílǝkǝ kɛnyɛ ɔ́tɛyi nkǝ, “Bonamute, mbɔnɔ sesiasesia bulǝ bo eto okle utidi ǝmfo nlɛ bafokanɔfɔ bokpe lǝ Yerusalem! ");
INSERT INTO lip_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Nya míkanɔ tsya bǝ ófo ǝsuǝale eto ekue utsyiko lǝ besumunyǝ ninǝ ɔflɔ nkǝ ubǝ umuǝ bafokanɔfɔ kenke lǝ Damasko!” ");
INSERT INTO lip_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Fɛɛ Bonamute átɛyi wǝ nkǝ, “Su lǝ esu eyifo lesa nǝ míntɛyi fǝ. Nnya ni bǝ mbulǝkǝ utidi ǝmfo miǝ lǝ udi mɔ ɔyɛkpa wǝ luufi Ditiki Sɛɛ nǝmǝ usuko mba lenni Israelfɔ ku baka ku Israelfɔ kenke lǝ bate mɛ. ");
INSERT INTO lip_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Mɔ kosate ebote wǝ kase sɔ̃ɔ̃ ele bǝ ɔyɛ udi ohiã lǝ mɔ disi.” ");
INSERT INTO lip_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Nyaso Ananias ésu údufǝ diyo nǝ Saulo lɛkɛ, nya úfi wǝ ani útǝkǝ lǝ wǝ, nya ɔ́tɛyi wǝ nkǝ, “Mɔyimi Saulo, Bonamute Yesu wǝ dílǝkǝ wǝ ǝsuǝ óte fǝ lǝ kusuu, wǝ Yesu kosate ke ni futsyǝ létsyese mɛ fǝ ɔflɔ nkǝ lǝ esinkli ǝnyǝ asa nnya lǝ Lɛwɔnɔ Kɛnkɛ lǝ disiǝko fǝ.” ");
INSERT INTO lip_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Lamfolamfoo, iyifo Saulo fe bufǝ bǝfǝ lesatsyuǝ nǝ nte fe akpɛ eto dikpǝ seka lǝ wǝ ǝnǝmi nya útsyiko asa bunyǝ. Nya se ótaka uńyǝǝ, béyifo wǝ ntuflǝsǝflǝsǝ eto lekpa lǝ Yesu eto diye ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Nya se údi lesa ólosǝǝ, usinkli údufǝ lǝ wǝ ǝsuǝ úmuǝ ale. Saulo ǝsiǝ lǝ bafokanɔfɔ ɔflɔ lǝ Damasko itǝ eyi asiani. ");
INSERT INTO lip_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Lǝ lefe nǝmfo ǝsuǝǝ, údu úsu Yudafɔ eto ntsyakɔ úsu údi etiki úlǝkǝ óte nkǝ Yesu eyifo Onanto eto Ubi. ");
INSERT INTO lip_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Iyifo mba kenke lɛnɔ wǝ ditiki nǝmfo yanii. Nya bátɔ mǝ ǝsuǝ bǝnkǝ, “Inni utidi ǝmfo létsya ófe úkalo Yesu eto mba ntǝkǝko wǝ lǝ Yerusalem lefe nǝ léfe mǝǝ? Nya inni bubǝ úbǝ nkǝ wǝǝbǝ umuǝ bafokanɔfɔ usuko besumunyǝ ninǝ ɔflɔ?” ");
INSERT INTO lip_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Nya Saulo dísukosǝ wǝ etiki sɛtɔ ókpasɛ ɔ́tɛyi nkǝ sitinti ɔnlɛ bɔtɛyi. Yudafɔ ba lɛkɛ lǝ Damasko mfó eto kuutsyuǝ mámfo kulesa bɔtɛyi kǝńyǝ lǝ wǝ ǝsuǝ. Ókpasɛ mǝ nkǝ Yesu ni Nwǝ Onanto Lékpo Ɔhile Utsyǝ ǝmǝ. ");
INSERT INTO lip_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Lǝ lefe kpǝ eto kamaa, Yudafɔ bamǝ átsya báse uyi bǝnkǝ boolo Saulo. ");
INSERT INTO lip_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Fɛɛ bǝtsyuǝ ǝbǝ bátɛyi wǝ itsyi lǝ ketsyue kamǝ ǝsuǝ. Lǝ nyamfo esoo, bákase umǝ ǝmǝ eto mbɔsie ketsye ku kakɔmi itǝ kase buunyǝ wǝ balo eso. ");
INSERT INTO lip_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Nyaso lǝ ketsye kanii, Saulo eto bayɛnkotsyuǝ éfi wǝ bákpe lǝ ditsyitsya kafo nya báyɛko wǝ ku ukuǝ lǝ dibiǝ nǝ nkpe lǝ ofati ǝsuǝ úbǝ kasɔ ɔ́bɔ údu lǝ umǝ ǝmǝ. ");
INSERT INTO lip_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Se úsu údufǝ Yerusalem, óla nkǝ lǝ usu ɔkɔ ku bakasebi ba nkpe mfó. Fɛɛ bámfo bánnɔ bǝ uyifo okasebi eso mǝ tsya áte wǝ sikpi. ");
INSERT INTO lip_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Nyaso Barnaba áwunsǝko wǝ ókpa wǝ úsuko batɔnkpe bamǝ ɔflɔ ɔ́teyi mǝ kase ótsyako Bonamute lǝ kusu, nya Bonamute dídi wǝ etiki. Usi ɔ́tɛyi mǝ kase Saulo dílǝkǝ ǝsuǝ óte údi etiki lǝ kpakpaakpe itsyi lǝ Yesu ǝsuǝ lǝ Damasko. ");
INSERT INTO lip_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Lǝ nyasoo, báfo wǝ bákpe lǝ mǝ nti, ɔ́kɛ ku mǝ nya báyɛ bábé Ditiki Sɛɛ nǝmǝ letsya lǝ Yesu eto diye ǝsuǝ lǝ Yerusalem. ");
INSERT INTO lip_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Nya kama údi etiki nya ókpe kǝnǝ ku Yudafɔ bǝtsyuǝ ba laatɛyi Sigriki, fɛɛ bábɛbɛ kusu bǝ lǝ balo wǝ. ");
INSERT INTO lip_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Lefe nǝmfóo, se wǝ bayimi ba ni bafokanɔfɔ lɛnɔ nnya nkoo, bákpa Saulo bésuko Kaisarea nya bákpa wǝ bátsyese wǝ umǝ Tarso. ");
INSERT INTO lip_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Lǝ lefe nǝmfóo, bafokanɔfɔ kenke ba lɛkɛ lǝ Yudea ku Galilea ku Samariaa, ála báwɔnɔ bǝsiǝ, sikpi eto bulǝ saa mensikɛ mǝ lǝ ǝsuǝ, nya bǝnyǝ sɛtɔsusu nya bǝsiǝ nkpǝ lǝ Bonamute eto kototsyuetsyue ǝsuǝ, nya béfi mǝ ǝsuǝ bákpe lǝ Lɛwɔnɔ Kɛnkɛ eto ǝsuǝale eto bɔwunsǝko ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Petro áyɛ ótsyilama nlebe kpǝ óbe bafokanɔfɔ kenke. Nya úsu únyǝ bafokanɔfɔ ba nkpe lǝ umǝ wǝ baakpo Lida tsya. ");
INSERT INTO lip_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Mfó úsu únyǝ osani utsyuǝ wǝ baakpo Ainea wǝ nlɛ bufi nlabe lǝ kalebe kani, ani ku akpa díkpǝ alɛ mfamfla sɔ̃ɔ̃. ");
INSERT INTO lip_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Nya se Petro dínyǝ wǝǝ, ɔ́tɛyi wǝ nkǝ, “Ainea, Yesu Kristo átsya fǝ bufi! Taka ǝńyǝ lǝ ǝkǝnǝ fǝ belabeke!” Lamfolamfo Ainea átaka uńyǝ. ");
INSERT INTO lip_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Nya se betidi ba kenke nkpe lǝ Lida ku Saron eto kǝmǝ dínyǝ bǝ Ainea átaka ɔlɛ bɔyɛ kafe mfóo, bátsyi bawuninsǝ béfi ǝsuǝ bǝtǝ Bonamute ǝmǝ. ");
INSERT INTO lip_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Usio utsyuǝ wǝ léfo ɔ́nɔ akɛ lǝ Yopa wǝ baakpo Tabita nya lǝ Sigriki ǝsuǝ bǝ Dorkas eto kasɔ ni kafɛ. Úfi wǝ lefe kenke úyifo kasɛɛ kpǝ nya úyifo kafo ɛkpɛ útǝ bakombo. ");
INSERT INTO lip_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Úbǝ ɔ́nɔ bufi nya úkpǝ. Se bǝflǝsǝ wǝ ntu bálosǝǝ, bésu bálɔ wǝ bákpo lǝ abanslo kato. ");
INSERT INTO lip_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lefe nǝmfó se bánɔ bǝ Petro ǝbǝ údufǝ Lida itsyise Lida mantsyo lǝ Yopa ɔflɔɔ, bafokanɔfɔ lǝ Yopa ákpe wǝ betidi inuǝ bǝ bakpa wǝ baboko Yopa akpa akpa. ");
INSERT INTO lip_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Nyaso Petro ǝmuǝ ǝsuǝ nya útǝkǝko mǝ besu kaka balabesǝ wǝ kato. Nya bakɔbǝsiǝ ba nkpe mfóo, díńyǝ batsyilama Petro banlɛ nku buwi, nya béfi awu akpa akpa nya Dorkas léka lǝ wǝ nkpǝ lefe banlɛ wǝ bote. ");
INSERT INTO lip_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Petro ǝtǝ nkǝ mǝmblɛ bɔ lǝ diyo nǝmǝ kafo nya óse akonki óto ola. Nya útsyi ǝnǝmi útǝ ɔkɔ ǝmǝ nya ɔ́tɛyi nkǝ, “Tabita, taka!” Lamfolamfo úmǝnkli wǝ ǝnǝmi, nya kase únyǝ Petro koo, ótaka úsiǝ. ");
INSERT INTO lip_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Nya Petro ǝnǝ kɔni utsyuǝ nya ɔ́wunsǝko wǝ ótaka únyǝ. Petro esinkli ókpadi bafokanɔfɔ ku bakɔbǝsiǝ bamǝ bǝbǝ, nya úfi wǝ ókpe mǝ lǝ ani ku nkpǝ. ");
INSERT INTO lip_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Nya ditiki nǝmfo dísensǝ lékpo lǝ Yopa mfó, itǝ betidi kpǝ áfo Bonamute bánɔ. ");
INSERT INTO lip_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Lǝ nnya kamaa, Petro ǝsiǝ lǝ Yopa mfó itǝ eyi kpǝ lǝ nwǝ baakpo Simon wǝ díkeyifo kubukikue eto keyifo mfó ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Lǝ lefe nǝmfóo, osani utsyuǝ ǝsiǝ lǝ Kaisarea eto umǝ wǝ baakpo Kornelio. Uyifo uninǝ utǝ Romafɔ eto bamamanyǝ eto ditsyukpa nǝ baakpo Italiafɔ. ");
INSERT INTO lip_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Uyifo utidi sɛɛ nya wǝ ku wǝ diyo eto betidi kenke díyifo mba leesumu Onanto. Utidi ǝmfo ákawunsǝko Yudafɔ eto bakombo, nya úkato ola lefe saa kǝtǝ Onanto. ");
INSERT INTO lip_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Diyi lɔni lǝ ketsyitsyokɔmi eto abombo ǝtsyǝ sekaa, únyǝ bulǝkǝkate butsyuǝ. Únyǝ lǝ bulǝkǝkate ǝsuǝ bomǝ nkǝ Onanto eto ɔtɔnkpe utsyuǝ ǝbǝ, nya ókpadi wǝ nkǝ, “Kornelio!” ");
INSERT INTO lip_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Nya lefe nǝ Kornelio dínyǝ wǝǝ, óbe wǝ tũũ ku sikpi nya ɔ́tɔ wǝ nkǝ, “Onamute, be ini?” Onanto eto ɔtɔnkpe ǝmfo átɛyi wǝ nkǝ, “Kase faato ola ku kase feeyifo kafo ɛkpɛ kǝtǝ betidi édufǝ Onanto ǝnǝ. ");
INSERT INTO lip_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Kpe betidi bǝtsyuǝ lǝ besu Yopa lǝ besu bakpadi osani wǝ baakpo Simon wǝ bensi baakpo Petro baboko. ");
INSERT INTO lip_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Okpe lǝ Simon wǝ nsi lǝ lekpo ɔflɔ wǝ leeyifo kubukikuǝ eto keyifo mfo.” ");
INSERT INTO lip_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Se Onanto eto ɔtɔnkpe ǝmfo díduu, Kornelio ákpadi wǝ diyo eto betidi inuǝ ku bamamanyǝ eto mba laase wǝ tsya eto ɔni wǝ ni utidi sɛɛ. ");
INSERT INTO lip_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Nya ɔ́tɛyi mǝ lesa nǝ díbǝ, nya ókpe mǝ nkǝ besu Yopa. ");
INSERT INTO lip_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Se kale dísiǝ nya banyɛ lǝ kusu bantɔ nya ibu sɛkɛ lǝ bedufǝ Yopa mfóo, Petro ábe úsu diyo nǝ bankpe eto kato itǝ kakɔmi eto lefosi abombo ǝnuǝ eto olatoto. ");
INSERT INTO lip_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Kukpɛnsɛ étsyiko wǝ bɔlɛ, fɛɛ mfe banlɛ lesa bonwa nɛ. Nya únyǝ bulǝkǝkate butsyuǝ. ");
INSERT INTO lip_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Únyǝ se kato lɛsini, nya únyǝ lesa nǝ fe kafia flubia kplɛ kǝtsyuǝ ka lɛmɔ, nya banlɛ kǝ lǝ esi ana nyamǝ ketsyi kato kanlɛ kasɔ bubǝ. ");
INSERT INTO lip_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Lǝ kafia kamǝ kafo aakǝ bebuki akpa akpa ku bawa ku baklɔbɛ. ");
INSERT INTO lip_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Mfó ɔ́nɔ ɔkɔɛ utsyuǝ nlɛ bɔtɛyi nkǝ, “Petro, taka, lo lǝ edi!” ");
INSERT INTO lip_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Fɛɛ Petro édi etiki ɔ́tɛyi nkǝ, “Owo lo! Kulefe! Bonamute, méndi tɔ kulesa nǝ Yudafɔ leekisi budi nyǝ!” ");
INSERT INTO lip_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ɔkɔɛ emfo esi ɔ́tɛyi wǝ nkǝ, “Lesa nǝ Onanto díyifo kɛnkɛɛ, mantɛyi fǝ iyifo ekisisa!” ");
INSERT INTO lip_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Únyǝ bulǝkǝ kate bomfo sitsyǝ sɔ̃ɔ̃. Nya ditsyǝfǝ kamaa, bétsyi kafia kamfo besuko kato. ");
INSERT INTO lip_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Lefe nǝmfoo, ditsyǝbi nǝ dílǝkǝ ǝsuǝ léte mfó éyifo Petro yanii, nyaso ɔ́tɔ wǝ ǝsuǝ nkǝ, “Be nnya mínyǝ mfo lete, nnya kasɔ nkpǝ?” Lefe nǝmfo kee, betidi ba Kornelio lékpe mfó ǝbǝ bédufǝ umǝ ǝmǝ. Nya se bǝnyǝ diyo nǝ banlɛ bɔbɔbɛɛ, bǝbǝ bǝńyǝ lǝ ni kesie. ");
INSERT INTO lip_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Nya bǝńyǝ banlɛ kaka Simon Petro nkpe disi bɔtɔ. ");
INSERT INTO lip_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Nya se Petro dísiǝ úkǝbu disi itsyi lǝ bulǝkǝkate bo únyǝ ǝsuǝǝ, Lɛwɔnɔ ídi wǝ etiki lɛtɛyi nkǝ, “Bebe basani itsyǝ ǝbǝ balɛ fǝ bɔbɛbɛ. ");
INSERT INTO lip_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Taka, muǝ ǝsuǝ lǝ esu ko mǝ. Mante sikpi ku mǝ butǝkǝko kesu. Mɔ uni létsyese mǝ.” ");
INSERT INTO lip_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Nyaso Petro ésu únyǝ mǝ nya ɔ́tɛyi mǝ nkǝ, “Mɔ ni nwǝ bɛnlɛ bɔbɛbɛ. Bomfo buɛɛ.” ");
INSERT INTO lip_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Bǝtǝ wǝ mbuayɛ bǝnkǝ, “Butsyi Kornelio wǝ ni Romafɔ eto omamanyǝ ninǝ ɔflɔ. Uyifo utidi sɛɛ wǝ lǝǝsumu Onanto. Nya Yudafɔ kenke laala wǝ asa tinti. Onanto eto ɔtɔnkpe utsyuǝ lɛtɛyi wǝ nkǝ okpe fǝ utidi lǝ ǝbǝ wǝ diyo lǝ ɔnɔ fǝ kɛnyɛ eto etiki nya fanyɛnko.” ");
INSERT INTO lip_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Lǝ nyaso Petro átɔnɔ ókpa mǝ údufǝnko kaka onkpe nya ófo mǝ fe wǝ bafɔ útǝ bátsyimɛ wǝ ɔflɔ. Se kale dísiǝǝ, ótaka útǝkǝko mǝ. Nya bafokanɔfɔ ba ditsyi Yopa mfo eto bǝtsyuǝ dítǝkǝko mǝ bésu. ");
INSERT INTO lip_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Bésu bédufǝ Kaisarea kǝsiǝsǝ. Lefe nǝmfóo, Kornelio ébokpo wǝ diyo eto betidi utsyǝ ku wǝ bayɛtsyuǝ bǝtsyuǝ nya bensi bensǝkǝ Petro eto bubǝ kedufǝ. ");
INSERT INTO lip_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Kase Petro nlɛ diyo nǝmǝ budufǝǝ, Kornelio átsyako wǝ nya óse akonko lǝ Petro eto ǝnǝmi nya óbokosǝ wǝ disi kasɔ. ");
INSERT INTO lip_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Fɛɛ Petro átɛyi wǝ nkǝ, “Taka ǝńyǝ! Mintsya utidi ǝtǝ mini.” ");
INSERT INTO lip_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Nya lǝ kase bantɔ banlɛ etiki budii, Kornelio ákpa wǝ úsuko kaka betidi fɛfɛ létsya bensi. ");
INSERT INTO lip_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Nya Petro lɛtɛyi mǝ nkǝ, “Mi kosate yi biǝ bo Yudafɔ eto kɔfi mǝntǝ kusu nkǝ ndufǝ utidi wǝ lenni bo ɔni eto diyo nye nsu wǝ ɔflɔ kulaatsya. Fɛɛ Onanto ǝlǝkǝ óte mɛ nkǝ membu kuutsyuǝ saa fe utidi wǝ dimeńyǝ utǝ lee menyifo kɛnkɛ. ");
INSERT INTO lip_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Lǝ nyaso se fákpe fǝ bakpadi mɛɛ, mánni nya míntaka mímbǝ nɛ. Nya beso bɛnlɛ mɛ bokpadi?” ");
INSERT INTO lip_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kornelio átɛyi wǝ nkǝ, “Fe eyi ana ni nnya léfee mmǝǝ, nya lǝ lefe nǝmfo sekaa, se minlɛ ola boto lǝ kakɔmi eto ǝtsyǝ eto lefe lǝ mɔ diyoo, lefua utidi utsyuǝ ko lɛbɔ úńyǝ mɛ lǝ ǝnǝmi, okpe awu nnya díkǝyǝnde! ");
INSERT INTO lip_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","32","Ɔ́tɛyi mɛ nkǝ, ‘Kornelio, Onanto ánɔ fǝ olatoto ku kase feeyifo kafo ɛkpɛ kǝtǝ betidi. Nyaso kpe betidi lǝ besu Yopa lǝ bakpadi nwǝ baakpo Simon wǝ bensi baakpo Petro wǝ nkpe lǝ Simon wǝ leeyifo keyifo kubukikue eto lǝ lekpo ɔflɔ baboko.’ ");
INSERT INTO lip_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Nko eso lamfolamfo mínkpe fǝ ɔtɔnkpe miǝ ubǝ okpadi fǝ lǝ ǝbǝ nya fintsya lekplatsya fátaka fákpe akpa kusu fǝbǝ nɛ. Nyaso bomblɛ si lǝ Onanto eto ǝnǝmi mfo busǝkǝ fǝ bǝ lǝ ǝbǝ atɛyi bo ditiki nǝ Bonamute lɛtɛyi fǝ nkǝ batɛyi bo.” ");
INSERT INTO lip_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Nyaso Petro édi mǝ etiki nkǝ, “Nnyǝ ntsyǝ lekpo sitinti minkǝ Onanto aambe betidi eto ǝnǝmi lǝ wǝ eyifosa ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Bomu kusǝ saa eto utidi wǝ laabokosǝ wǝ ǝsuǝ kasɔ kǝtǝ wǝ, keyifo kasɛɛ, wǝ waala nɛ. ");
INSERT INTO lip_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Mfo nnɔ miǝ bɛnɔ Ditiki Sɛɛ nǝ Onanto dílǝkǝ óte Israelfɔ bǝ, ɛyɛ lǝ Yesu Kristo wǝ ni betidi kenke eto Onamute ǝsuǝǝ, boonyǝ diyuǝ. ");
INSERT INTO lip_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Biyi lesa kplɛ nǝ díbǝ Israel eto kasɔ kenke idu lǝ lefe nǝ Yohanes lébe letsya lǝ Galilea eto kasɔ itsyi lǝ ntuflǝsǝflǝsǝ eto lekpa nǝmɔ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Nya bɛnɔ tsya kase Onanto lékpo Yesu wǝ ditsyi Nasaret ɔhile utsyǝ lǝ lefe nǝ úfi Lɛwɔnɔ Kɛnkɛ ku ǝsuǝale útǝ wǝ. Nya ótsyilama úkeyifo asa sɛɛ, nya ótsya mba Obonsam díkelǝ kɛlɛkɛ mǝ ketsyiko lǝ bulǝ bomǝ ǝsuǝ itsyise Onanto ǝsiǝ ko wǝ. ");
INSERT INTO lip_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Búdi adansiɛ lǝ asa nnya kenke úyifo lǝ Israel eto kasɔ ku Yerusalem. Mfó ǝmǝ básɔ wǝ lǝ uyikabie ǝsuǝ bálo nɛ. ");
INSERT INTO lip_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Fɛɛ Onanto esi ótaka wǝ utsyiko ɔkɔmǝ úbǝ nkpǝ lǝ diyi tsyǝfǝ ǝsuǝ nya úlǝkǝ wǝ óte betidi dínyǝ. ");
INSERT INTO lip_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Fɛɛ inni betidi ba kenke dínyǝ wǝ. Bomu bo mba Onanto dílǝkǝ nkǝ budi wǝ badansiɛɛ, bo ni mba dínyǝ wǝ nɛ. Nya búdi nya búnǝ ku wǝ lǝ wǝ botaka kǝńyǝ eto kama. ");
INSERT INTO lip_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Bo ni mba ótsyese nkǝ busu bɔtɛyi Ditiki Sɛɛ nǝmǝ lǝ kalebe saa butǝ betidi nɛ. Nya lǝ bulǝkǝ bote boǝnkǝ, Onanto ni futsyǝ dílǝkǝ Yesu fe Okponkpo itǝ bǝkpǝnkpǝ ku kawunsiǝ eto betidi kenke. ");
INSERT INTO lip_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Nya Onanto eto bǝnyɛlǝkǝtidi ba kenke dídi etiki itsyi lǝ wǝ bǝnkǝ utsyuǝ saa kee léfo wǝ ɔ́nɔɔ, Onanto ebufi wǝ abua ɔtsyɛ wǝ lǝ Yesu eto diye eto ǝsuǝale ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Nya lefe nǝ Petro ńyǝ ɔnlɛ etiki nyamfo budii, Lɛwɔnɔ Kɛnkɛ áyifǝ dísiǝ lǝ mba kenke lɛkɛ mfo banlɛ Petro eto ditiki nǝmǝ bɔnɔ ǝsuǝ! ");
INSERT INTO lip_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Yudafɔ eto bafokanɔfɔ ba dítǝkǝko Petro betsyi Yopa bǝbǝ mfóo, etiki nyamǝ éyifo mǝ yanii! Itsyise Onanto ǝtǝ wǝ Lɛwɔnɔ Kɛnkɛ nǝmǝ áyifǝ díbǝ dísiǝ lǝ mba lenni Yudafɔ tsya ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Fɛɛ bǝmbofo bɔtɛyi bǝ inni nko ini. Itsyise bánɔ se banlɛ bele bamba kpǝ bɔtɛyi katɛsɛ Onanto. Nya Petro lɛtɛyi nkǝ, ");
INSERT INTO lip_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Betidi bamfo tsya áfo Lɛwɔnɔ Kɛnkɛ fe kase bo tsya lefo esoo, boǝmbofo bɔni boǝ boǝmbuflǝsǝ mǝ ntu.” ");
INSERT INTO lip_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Nyaso útǝ kusu nkǝ bǝflǝsǝ mǝ ntu lǝ Yesu Kristo eto diye ǝsuǝ. Lǝ nyamfo eto kamaa, bálɛ Petro lekpakpa bǝ usiǝ lǝ mǝ ɔflɔ itǝ eyi asiani. ");
INSERT INTO lip_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Yanklɛ fɛ batɔnkpe bamǝ ku bafokanɔfɔ bamba lǝ Yudea lɛnɔ bǝ betidi ba lenni Yudafɔ tsya ébɔtsyi báwuninsǝ báfo Onanto eto Ditiki Sɛɛ nǝmǝ bánɔ. ");
INSERT INTO lip_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Nyaso lefe nǝ Petro dísinkli úsu Yerusalem eto umǝǝ, Yudafɔ eto bafokanɔfɔ ba lɛkɛ mfóo, mántɔnɔ ko wǝ. Nya bátɔ wǝ bǝnkǝ, ");
INSERT INTO lip_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Beso fésu fásɔnɔ lǝ bafɔ ba dímanla alo nya fákpe kɔni lǝ ɔkpɛ ɔni ǝsuǝ fédi lesa ku mǝ?” ");
INSERT INTO lip_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Nyaso Petro ǝlǝkǝ etiki nyamfo kenke kasɔ óte mǝ nkǝ, ");
INSERT INTO lip_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Lǝ lefe nǝ minkɛ lǝ Yopa minlɛ ola botoo, nnyǝ bulǝkǝkate butsyuǝ. Mfó mínyǝ kafia kplɛ kǝtsyuǝ ka banlɛ lǝ esi ana kétsyi kato banlɛ kǝ kasɔ bobokosǝ lǝ mɔ ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Se minlɛ ola mímbee, nnyǝ bebuki akpa akpa eto kakle kpe lǝ kafia kamǝ kafo, batobuki ku betubuki ku mba laabɔdi lǝ kasɔ ku baklɔbɛ ákpo mfó. ");
INSERT INTO lip_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ete mínɔ ɔkɔɛ utsyuǝ nlɛ etiki budi katɛyi nkǝ, ‘Petro! Taka, lo lǝ edi!’ ");
INSERT INTO lip_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Nyaso nlǝkǝ kɛnyɛ ntɛyi minkǝ, ‘Kula o-o! Kulefe! Bonamute, méndi tɔ kulesa nǝ Yudafɔ leekisi budi nyǝ.’ ");
INSERT INTO lip_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Fɛɛ ɔkɔɛ ǝmfo esi údi etiki útsyi kato ɔ́tɛyi nkǝ, ‘Lesa nǝ Onanto diyifo kɛnkɛɛ, mantɛyi fǝ diyifo dimankpa.’ ");
INSERT INTO lip_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","“Nnyǝ bulǝkǝkate bomfo sitsyǝ sɔ̃ɔ̃. Lǝ nnya kamaa, kafia kplɛ kamfo ka eto kafo bebuki bamfo nkpoo, bétsyi ke bábesǝ kato isu ese lefe nǝ kánya vĩĩ. ");
INSERT INTO lip_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Lǝ lefe nǝmfó tututuu, betidi itsyǝ ba bákpe bǝ bakpa mɛ baboko Kaisarea ǝbǝ bédufǝ diyo nǝ minkɛ. ");
INSERT INTO lip_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Nya Lɛwɔnɔ Kɛnkɛ lɛtɛyi mɛ nkǝ ntǝkǝko mǝ lǝ busu. Mɔ bayimi ekua bamfo ditsyi Yopaa, ǝtǝkǝko mɛ busu Kaisarea búsu búdufǝ osani wǝ lekpe mɛ batɔnkpe ini Kornelio eto diyo. ");
INSERT INTO lip_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ɔ́tɛyi bo kase Onanto eto ɔtɔnkpe dílǝkǝ ǝsuǝ óte wǝ nya ɔ́tɛyi wǝ nkǝ, ‘Bɛbɛ utsyuǝ akpe Yopa lǝ usu ɔbɛbɛ nwǝ baakpo Simon Petro. ");
INSERT INTO lip_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Wuudi mi etiki nnya luutǝ bǝ fǝ ku fǝ diyo eto betidi kenke luunyǝ bofo.’ ");
INSERT INTO lip_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Fɛ míntsyiko Ditiki Sɛɛ nǝmǝ bɔtɛyii, Lɛwɔnɔ Kɛnkɛ ébubǝ dídufǝ mǝ mǝmblɛ kenke lǝ ǝsuǝ fe kase dídufǝ bo lǝ ǝsuǝ lǝ kasɔ ketsyikokɔ kamǝ! ");
INSERT INTO lip_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Nyamfo dítǝ mínkloma lesa nǝ Bonamute lɛtɛyi lefe nǝ ɔ́tɛyi nkǝ, ‘Sitinti Yohanes efi ntu uflǝsǝ betidi. Fɛɛ Onanto ebufi Lɛwɔnɔ Kɛnkɛ uflǝsǝ mi.’ ");
INSERT INTO lip_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Nya lǝ Onanto ǝtǝ betidi ba lenni Yudafɔ ǝtǝsa nyamfo fe kase úfi útǝ bo lǝ lefe nǝ bófo Bonamute Yesu Kristo bɔ́nɔɔ, owoe mini bǝ lǝ mmfo Onanto kusu buti nko?” ");
INSERT INTO lip_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Se bánɔ etiki nyamfoo, bénsite lesa nǝ bɔtɛyi. Bomu bátɛsǝ Onanto bátɛyi bǝnkǝ, “Sitinti Onanto ǝtǝ betidi ba lenni Yudafɔ tsya kusu nkǝ batsyi bawuninsǝ lǝ bǝnyǝ nkpǝ.” ");
INSERT INTO lip_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Nya lefe nǝ asa nyamfo nlɛ bubǝ nkoo, bafokanɔfɔ ba dítsyǝtsyi bédu lǝ bulǝ bo dítu mǝ itsyi lǝ kase bálo Stefano ǝsuǝǝ, bésu bédufǝ Foinike ku Kipro ku Antiokia eto kǝmǝ. Nya bátsyilama banlɛ ditiki sɛɛ nǝmǝ bɔtɛyi Yudafɔ hã. ");
INSERT INTO lip_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Nya bafokanɔfɔ ba ditsyi Kipro ku Kirene dísu Antiokia bésu bátɛyi betidi ba lenni Yudafɔ Bonamute Yesu eto Ditiki Sɛɛ nǝmǝ. ");
INSERT INTO lip_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Nya se Bonamute eto ǝsuǝale lɛkɛ ko mǝ esoo, bafokanɔfɔ ba dífi ǝsuǝ bǝtǝ Bonamute ǝbǝ befui bakpe. ");
INSERT INTO lip_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Lefe nǝ bafokanɔfɔ ba nkpe lǝ Yerusalem lɛnɔ ditiki nǝmfoo, bátsyese Barnaba bǝ usu lǝ usu obe lesa nǝ nlɛ bubǝ lǝ Antiokia. ");
INSERT INTO lip_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Se úsu údufǝ mfó nya únyǝ kase Onanto lɛwunsǝ ko mǝǝ, únyǝ disuǝyuǝ tinti nya usi ókpe mǝ nkɛale nkǝ bǝńyǝ kekleke lǝ bofokanɔ ǝsuǝ nya lǝ bedi ɔnukualɛ bǝtǝ Bonamute ku mǝ utu kenke. ");
INSERT INTO lip_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnaba eyifo utidi sɛɛ wǝ nkpe bofokanɔ nya Lɛwɔnɔ Kɛnkɛ nsi ko wǝ tinti. Ɛyɛ lǝ wǝ bɔwunsǝko ǝsuǝǝ, bafokanɔfɔ bamǝ ǝbǝ befui bakpe. ");
INSERT INTO lip_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Lǝ nnya kamaa, Barnaba ésu Tarso, úsu ɔ́bɛbɛ Saulo mfo. ");
INSERT INTO lip_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Se únyǝ wǝǝ, ókpa wǝ bédu bǝbǝ Antiokia nya mǝ inuǝ bamǝ dísiǝ mfó lɛlɛ wɔlɔlɔ. Bakɛ mfó bákate betidi kpǝ asa. Antiokia mfóo, nya betsyiko bafokanɔfɔ bokpo bǝ Kristofɔ nɛ. ");
INSERT INTO lip_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Lǝ lefe nǝmfo tututuu, Onanto eto bǝnyɛlǝkǝtidi bǝtsyuǝ etsyi Yerusalem bǝbǝ Antiokia. ");
INSERT INTO lip_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Mfó mǝ nti eto ɔni wǝ baakpo Agabo, létaka uńyǝ lǝ Lɛwɔnɔ Kɛnkɛ eto ǝsuǝale ǝsuǝ nya ɔ́tɛyi nkǝ kukpɛnsɛ kekleke ebubǝ lǝ kawunsiǝ kenke. Nyamfo ǝbǝ ítǝ lǝ lefe nǝ Romafɔ eto Okankplɛ wǝ baakpo Klaudio nlɛ seka budi. ");
INSERT INTO lip_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Nyaso bafokanɔfɔ bamǝ éfi nsusu bǝ baako asa lǝ befi batsyese bafokanɔfɔ ba nkpe lǝ Yudea eto kasɔ. Nya mǝ utsyuǝ saa léko kase woofo. ");
INSERT INTO lip_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Nya se báko bikǝ biamǝǝ, béfi mi bǝtǝ Barnaba ku Saulo nya béfi mi bésu bǝtǝ Yudea eto bafokanɔfɔ eto beninǝ. ");
INSERT INTO lip_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Lǝ lefe nǝmfo ǝsuǝ, Oka Herodes ǝmuǝ bafokanɔfɔ eto bǝtsyuǝ nkǝ lǝ ókpe mǝ bulǝ kekleke. ");
INSERT INTO lip_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Útǝ balo Yakobo wǝ ni Yohanes eto ɔyimisani ku lesiabi. ");
INSERT INTO lip_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Nya se únyǝ nkǝ nnya úyifo ákɛ Yudafɔ ɔkɔɛɛ, úmuǝ Petro tsya lǝ lefe nǝ beedi Abolo nnya Ǝyǝnkisǝsa Lǝmbǝ eto Diyi. ");
INSERT INTO lip_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Se bǝmuǝ wǝǝ, bákpe wǝ lǝ diyo kaka mba laase diyo nǝmǝ eto ena ena eto akpa ana ba laafloma bǝtsyuǝ ńyǝ lefe saa banlɛ wǝ bose. Herodes eto nsusu ni bǝ lǝ ubǝ ufi wǝ utǝ betidi lǝ bakponko wǝ lekpo lǝ mǝ diyisɛɛ nǝ baakpo Ukpǝ Ása Bo Ɔ́yila eto kama. ");
INSERT INTO lip_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Nyaso mba laase mfó ákase Petro lǝ diyo nǝmǝ. Fɛɛ bafokanɔfɔ bamǝ ákato ola kekleke ákalɛ Onanto lekpakpa lǝ wǝ disi. ");
INSERT INTO lip_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Nya lǝ ketsye ka eto kǝsiǝsǝ ka Herodes díbu disi nkǝ wútǝlǝkǝ Petro lǝ diyo utǝ betidi bamǝǝ, Petro álabe selabe lǝ mba laase eto inuǝ eto nti. Nya bákpe wǝ lǝ kɔnyɔ kplɛ ko béfi batsyasǝ lǝ mǝ kosate eto ani ǝsuǝ. Nya fɛ mba laase mfó eto bǝtsyuǝ díńyǝ banlɛ siku siamǝ bose. ");
INSERT INTO lip_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Akpaakpa koo, Kato eto Ɔtɔnkpe ko lɛbɔ nya lekpasǝ léfo diyo nǝmǝ kenke. Nya Kato eto Ɔtɔnkpe dífi wǝ kɔni útǝkǝ Petro lǝ lekpake ósanklisǝ wǝ nya ɔ́tɛyi nkǝ, “Kɔse mlǝ lǝ ataka ǝńyǝ!” Kɔnyɔ kplɛ ko nkpe wǝ lǝ kɔni lɛsini kɔ́bɔ kókpo lǝ kasɔ. ");
INSERT INTO lip_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Nya Kato eto Ɔtɔnkpe ǝmǝ lɛtɛyi wǝ nkǝ, “Fi fǝ awu ku afɔkpa akpe.” Nya Petro díyifo nko. Nya Ɔtɔnkpe ǝmǝ disi ɔ́tɛyi wǝ nkǝ, “Fi fǝ awu kɛntsyɛ akpe lǝ ǝtǝkǝko mɛ.” ");
INSERT INTO lip_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Nya Petro létaka útǝkǝko wǝ, nya ɔ́bɔ lǝ diyo nǝmǝ kafo. Lefe nǝmfo kenkee, wánte lǝ lesa nǝ Kato eto Ɔtɔnkpe ǝmǝ nlɛ buyifo eyifo sitinti, úbu nkǝ kola ete ɔnlɛ busiǝ. ");
INSERT INTO lip_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Nya báyɛ báfe mba laase eto ditsyukpa tutɛ ku bǝnuǝfǝ. Nya se báyo situ eto kesie kplɛ ka baayɛ kedufǝ umǝ ǝmǝǝ, siku siamǝ kosate ko lɛsini ǝsuǝ. Nya báyɛ lǝ kesie kamǝ tsya báfe. Nya se báyɛ bésu sɛtɔ sɛkɛɛ, Kato eto Ɔtɔnkpe ǝmǝ ko lénya údu lǝ wǝ ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Lǝ nnya kamaa, fɛ Petro léte lesa nǝ díbǝ wǝ lǝ ǝsuǝ nya ɔ́tɛyi wǝ ǝsuǝ nkǝ, “Mɔmɔ mbote miǝ sitinti ini bǝ Bonamute létsyese wǝ Ɔtɔnkpe ǝmfo nkǝ ubǝ ulǝkǝ mɛ utsyiko lǝ Herodes eto ani ku asa nnya Yudafɔ díbu bǝ booyifo mɛ tsya lǝ diyo nǝmfo kafo!” ");
INSERT INTO lip_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Nya se únyǝ nnya díbǝ utsyǝ lekpoo, údu úsu Maria wǝ ni Yohanes Marko eto ambe eto diyo kaka betidi kpǝ létsya banlɛ ola boto. ");
INSERT INTO lip_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Nya se Petro léyo diyo nǝmǝ eto kǝsiǝǝ, ɔ́sɔ siku siamǝ. Nya uyifoyifosiobi utsyuǝ wǝ baakpo Roda ábɔ úsu nkǝ woabe futsyuǝ uni. ");
INSERT INTO lip_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Se ɔ́nɔ Petro eto ɔkɔɛ utsyǝ lekpoo, únyǝ disuǝyuǝ ofensǝ! Itǝ wánsini wǝ siku siamǝ, bomu útsyetsyi úsu wǝ betidi ɔflɔ úsu ɔ́tɛyi mǝ nkǝ Petro ǝbǝ uńyǝ lǝ siku kama. ");
INSERT INTO lip_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Bátɛyi wǝ bǝnkǝ, “Ntɔ disi lébia fǝ?” Nya usi úńyǝ lǝ nnya ǝsuǝ nkǝ sitinti ini. Nyaso bátɛyi wǝ bǝnkǝ, “Nyalɛ ǝtsyuǝǝ, wǝ kato eto ɔtɔnkpe uni!” ");
INSERT INTO lip_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Lǝ lefe nǝmfo kenke ǝsuǝǝ, Petro esi úńyǝ ɔlɛ kesie eto siku bɔsɔ. Nya lefe nǝ básini se nya bǝnyǝ wǝǝ, íyifo mǝ yanii. ");
INSERT INTO lip_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Úyifo mǝ kɔni nkǝ bánkpo kudu. Ɔ́tɛyi mǝ asa nnya díbǝ ku kase Bonamute díbǝ úlǝkǝ we utsyiko lǝ diyo nǝmǝ kafo. Nya ɔ́tɛyi mǝ nkǝ, “Bisu bɛtɛyi Yakobo ku bayimi bafɛfɛ asa nnya díbǝ.” Nya udu mǝ lǝ ɔflɔ úsu kalebe bamba. ");
INSERT INTO lip_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Nya se kale dísiǝǝ, íyifo mba laase mfó yaa, nya éboko bulǝ kpǝ. Bátɔ mǝ ǝsuǝ bǝnkǝ, “Se tutuutu Petro lefe mɔmɔ?” ");
INSERT INTO lip_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Nya Herodes ǝtǝ bábɛbɛ wǝ tinti, fɛɛ bǝnnyǝ wǝ. Útǝ bǝmuǝ mba laase diyo nǝmǝ bákpoko mǝ lekpo, nya útǝ nkǝ balo mǝ. Lǝ nnya kamaa, Herodes édu lǝ Yudea úsu úsiǝ lǝ Kaisarea itǝ lefe ditsyuǝ. ");
INSERT INTO lip_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Lǝ lefe nǝmfóo, Herodes ǝnyǝ ɔblɔ tinti ókpe Tiro ku Sidon eto betidi, nyaso bésu lǝ sitiditu ǝsuǝ bǝ lǝ besu bǝnyǝ wǝ. Bésu bátɔ bɔwunsǝko betsyi lǝ Blasto wǝ ni Herodes eto nwǝ laabe diyo ɔflɔ bǝ ɔlɛ Herodes lekpakpa lǝ utǝ lǝ lɔniyifoyifo lǝ dibǝ lǝ mǝ inuǝ bamǝ ku Herodes eto nti. Ibǝ nko itsyise Herodes eto kasɔ bǝkǝnyǝ mǝ didisa ketsyiko. ");
INSERT INTO lip_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Nya lǝ diyi nǝ Oka Herodes ditsyǝ mǝǝ, ókpe wǝ bekankǝ nya úsiǝ lǝ wǝ lekankpomɛ ǝsuǝ údi betidi bamǝ etiki. ");
INSERT INTO lip_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Se údi etiki ólosǝǝ, betidi bamǝ áfa básɔ ani bǝtǝ wǝ nya bátɛyi bǝnkǝ, “Onanto Kosate eto ɔkɔɛ uni! Inni utidi!” ");
INSERT INTO lip_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Lamfolamfoo, Bonamute eto Ɔtɔnkpe ákpe Herodes bufi lǝ ǝsuǝ, itsyise wémfi atɛsɛ Onanto. Nya batsyini dídi wǝ ǝsuǝ kenke, nya úkpǝ. ");
INSERT INTO lip_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Nya Onanto eto Ditiki Sɛɛ nǝmǝ lɛyɛ letsyo, dísensǝ nya bafokanɔfɔ difui bakpe. ");
INSERT INTO lip_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Nya lefe nǝ Barnaba ku Saulo lélosǝ mǝ keyifo ka bákpe mǝ bǝ besu beyifoo, bésinkli betsyi Yerusalem bǝbǝ nya bákpa Yohanes wǝ tsya baakpo Marko báyɛnko báboko. ");
INSERT INTO lip_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Lǝ Antiokiaa, Onanto eto bǝnyɛlǝkǝtidi bǝtsyuǝ ku bateasa ákɛ lǝ bafokanɔfɔ eto ditsyukpa nǝmǝ nti. Mǝ ni Barnaba ku Simon wǝ baakpo utidi naa ku Lukio wǝ ditsyi Kirene ku Manaen nwǝ ku Oka Herodes békluǝsǝ bakɔ taa mǝ sikpefi lefe ku Saulo. ");
INSERT INTO lip_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Nya lefe nǝ banlɛ Bonamute bɔtǝsǝ nya bakɛ lǝ kɛnyɛklekle ǝsuǝǝ, Lɛwɔnɔ Kɛnkɛ ǝbǝ dídi mǝ etiki nkǝ, “Bilǝkǝ Barnaba ku Saulo bitsyǝ itǝ keyifo ka eso mínkpadi mǝ.” ");
INSERT INTO lip_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Lǝ nyamfo esoo, beninǝ bamǝ ákle kɛnyɛ nya báto ola nya bǝtǝkǝ mǝ ani, nya bǝtsyǝ mǝ kusu. ");
INSERT INTO lip_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Se Lɛwɔnɔ Kɛnkɛ ditsyǝ mǝ kusu lélosǝǝ, bésu umǝ wǝ baakpo Seleukia. Mfó béfi ɔklɔ báyila lekpo nǝmǝ bésu kasɔ ka ntu letsyilama eto umǝ wǝ baakpo Kipro. ");
INSERT INTO lip_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Se bésu bédufǝ umǝ wǝ baakpo Salamii, bésu Yudafɔ eto ntsyakɔ bésu bédi mǝ ditiki sɛɛ nǝmǝ. Nya Marko Yohanes díkǝko mǝ fe mǝ ɔwunsǝkotsyuǝ. ");
INSERT INTO lip_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Se bédu mfóo, báyɛ lǝ kasɔ kamǝ bésu bédufǝ umǝ wǝ baakpo Pafo. Mfó bátsyako Yudanyǝ wǝ ni ofate wǝ ni sedia eto unyɛlǝkǝtidi wǝ baakpo Bar-Yesu eto ubi. ");
INSERT INTO lip_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ofate ǝmfo ku Aba eto unyɛsiǝ wǝ baakpo Sergio Paulo eyifo bayɛtsyuǝ. Nko eto Aba eto unyɛsiǝ ǝmfo wǝ diyifo obesibe ákpadi Barnaba ku Saulo nkǝ bǝbǝ bǝnyǝ wǝ, itsyise óla nkǝ lǝ ɔnɔ Onanto eto ditiki nǝmǝ. ");
INSERT INTO lip_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Nya se bésuu, ofate ǝmǝ wǝ baakpo tsya bǝ Elima lǝ Sigriki ǝsuǝǝ, ǝnǝ etiki ku mǝ. Óla nkǝ lǝ ulǝkǝ Aba eto unyɛsiǝ ǝmfo eto nsusu utsyiko lǝ etiki nnya Saulo ku Barnaba lela bǝ beedi ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","10","Fɛɛ Saulo wǝ tsya bensi baakpo Pauloo, ábe ofate ǝmfo ku lɛblɔfi kekleke. Nya úlǝkǝ óte wǝ lǝ Lɛwɔnɔ Kɛnkɛ eto ǝsuǝale nkǝ, “Fǝ Obonsam eto ubi, eyifo odia ku nwǝ laawɛ betidi kakpe. Nya feekisi kasɛyifoyifo, nya faatsyi Bonamute eto ɔnukualɛtiki kawuninsǝ keyifo bidia! ");
INSERT INTO lip_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Bonamute ebutǝkǝ fǝ kɔni mɔmɔ nya wuutǝ fǝ ǝnǝmi ba, nya fensiembunyǝ kofe bio isu ese lǝ lefe ditsyuǝ eto kama!” Lamfolamfo lɛtɔntɔ eti Elima lǝ ǝnǝmi, nya wénsifo asa bunyǝ bio. Úkawunya ani kabɛbɛ utidi nkǝ lǝ ɔyɛnko wǝ. ");
INSERT INTO lip_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Lefe nǝmfo se Aba eto unyɛsiǝ ǝmfó dínyǝ nyamfo nkoo, íyifo wǝ yanii, nya ófo Bonamute eto ditiki nǝmǝ ɔ́nɔ. ");
INSERT INTO lip_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Nnya kamaa, Paulo ku mba ntǝkǝko wǝ ésu bédufǝ lǝ ɔklɔ nya bédu lǝ Pafo bésu Perge wǝ ni umǝnkplɛ wǝ nkpe lǝ Pamfilia eto kasɔ. Mfó nya Marko Yohanes dídu mǝ lǝ ɔflɔ úsinkli úsu Yerusalem. ");
INSERT INTO lip_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Se bédu lǝ Pergee, bésu Antiokia, umǝnkplɛ wǝ nkpe lǝ Pisidia. Nya lǝ Ɔnwɛditsyǝyii, bésu Yudafɔ eto katsyakɔ nya bǝsiǝ kasɔ lǝ betidi bamǝ nti. ");
INSERT INTO lip_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Lefe nǝ bákakla asa betsyiko lǝ Moses eto kɔfi eto kukue ku Onanto eto bǝnyɛlǝkǝtidi eto asawɔniwɔni bálosǝǝ, katsyakɔ eto batɔnkotɔnko ǝtǝ Paulo ku wǝ bǝtsyuǝ bote bǝ, “Bayimi, lǝ utsyuǝ kpe ditiki ditsyuǝ nkǝ woatɛyi lǝ ufi okpe bo nkɛalee, lǝ ubǝ ɔtɛyi.” ");
INSERT INTO lip_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Mfó Paulo létaka uńyǝ nya óte kɔni kato lete bǝ bedi kaa, nya ɔ́tɛyi mǝ nkǝ, “Israelfɔ ku mimba kenke ba lenni Israelfɔ ba leetsyue Onanto koto, bitsyue ato lǝ bɛnɔ! ");
INSERT INTO lip_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Israelfɔ eto Onanto ni nwǝ dílǝkǝ bo banamǝ nya ókpo mǝ atsyɔ. Nya úyifo mǝ kusǝ kplɛ eto betidi lǝ lefe nǝ bǝsiǝ kafɔle ka ni Egipte. Onanto ǝlǝkǝ mǝ utsyiko Egipte ɛyɛ lǝ wǝ ǝsuǝale kplɛ nyamǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Óbe mǝ nya ókpa mǝ ɔ́yɛnko lǝ mfiminti itǝ alɛ fosi ana nnya bákɛ mfo. ");
INSERT INTO lip_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Se ɔ́tsylɔsǝ ǝsǝ akuanse lǝ Kanan eto kasɔɔ, úfi mǝ kasɔ kamǝ utǝ Israelfɔ fe mǝ kedikɔ. ");
INSERT INTO lip_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Nyamfo kenke ǝbǝ itǝ fe alɛ alofa ana awosi anɔ eto nti. “Lǝ nyamfo eto kamaa, Onanto ǝtǝ mǝ bakponkpo ba dídi seka lǝ mǝ ǝsuǝ isu ese Onanto eto Unyɛlǝkǝtidi Samuel eto lefe. ");
INSERT INTO lip_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Nya bálɛ wǝ lekpakpa bǝ utsyǝ oka utǝ mǝ. Nya Onanto dítǝ mǝ Kis eto ubi Saulo wǝ ditsyi Benyamin eto kafo, nya údi seka itǝ alɛ fosi ana. ");
INSERT INTO lip_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Nnya kamaa, Onanto átakasǝ wǝ lǝ seka ǝsuǝ nya úfi David úsiǝsǝ lǝ lekankpomɛ nǝmǝ ǝsuǝ. David ǝmfo ni utidi wǝ ǝsuǝ Onanto dídi etiki utsyiko nkǝ, ‘Yese eto ubi David ni utidi wǝ mɔ utu laala, itsyise wuuyifo lesa nǝ maala.’ ");
INSERT INTO lip_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Nko ke ini bǝ Onanto áyɛ lǝ David eto kafo, nya úlǝkǝ Ofomfokǝtǝ wǝ ni Yesu utǝ Israelfɔ fe kase utsyǝ bo kɛnyɛ. ");
INSERT INTO lip_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Nya fɛ Yesu luubǝǝ, Ntuflǝsǝtidi Yohanes ǝbǝ ɔ́tɛyi Israelfɔ kenke nkǝ batsyi mǝ nkpǝ bawuninsɛ lǝ mǝ akɔɛsi bayɛ abua buuyifo lǝ uflǝsǝ mǝ ntu. ");
INSERT INTO lip_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Lǝ lefe nǝ Yohanes eto keyifo nlɛ kalosɛkɔ bubǝǝ, ɔ́tɛyi betidi bamǝ nkǝ, ‘Owoe bibu biǝ wǝ mini? Mɔ ni nwǝ bɛnlɛ kusu bobe le? Owo lo! Fɛɛ wǝ kpe lǝ kusu ɔlɛ bubǝ mɛ kama, nya mǝnńyǝtǝ bǝ nyankli wǝ afukpa eto kekue kulaa tsya!’ ");
INSERT INTO lip_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Mɔ bayimi, Israel bebi, mi mba ni Abraham eto bebi ku mimba lenni Yudafɔ fɛ biesumu Onanto, nkpǝ manlo eto bofo bomfo ǝbǝ itǝ bomblɛ kenke. ");
INSERT INTO lip_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Betidi ba nkpe lǝ Yerusalem ku mǝ beninǝ mámfo Yesu bánɔ bǝ wǝ ni mǝ Ofomfokǝtǝ ǝmǝ. Nya bánnɔ kasɔ Onanto eto bǝnyɛlǝkǝtidi eto ditiki nǝ baakla kate bo lǝ Ɔnwɛditsyǝyi saa ǝsuǝ. Fɛɛ bǝtǝ bǝnyɛlǝkǝtidi eto etiki ǝbǝ itǝ se bálo wǝ dikpǝnkpi eso. ");
INSERT INTO lip_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Nya ite bǝ bǝnnyǝ kabua saa lǝ wǝ ǝsuǝ tsyaa, bátɛyi Pilato bǝ utǝ kusu lǝ balo wǝ. ");
INSERT INTO lip_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","“Nya lefe nǝ békeyifo lesa nǝ Awɔnisa Kɛnkɛ eto Kukue lɛtɛyi utsyǝ itsyi lǝ lǝ wǝ ǝsuǝ bálosǝǝ, bǝlǝkǝ wǝ lǝ uyikabie ǝsuǝ bésu bebikǝ. ");
INSERT INTO lip_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Fɛɛ Onanto átakasǝ wǝ utsyiko ɔkɔmǝ. ");
INSERT INTO lip_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Nya lǝ eyi kpǝ ǝsuǝǝ, úlǝkǝ wǝ ǝsuǝ óte betidi ba wonko mǝ lɛyɛ itsyi Galilea isu Yerusalem. Mǝ ni betidi ba nlɛ adansiɛ budi lǝ wǝ ǝsuǝ lǝ Israel eto kusǝ nɛ. ");
INSERT INTO lip_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","“Nya mɔmɔɔ, búbǝ mfo boǝ boefi Ditiki Sɛɛ nǝmǝ boboko mi bǝ Onanto eto kɛnyɛ ka útsyǝ bo banamǝǝ, ǝbǝ itǝ bo, bo mba ni mǝ bebi. Nnya ni bǝ Onanto ǝtǝ nkǝ Yesu si otaka utsyi ɔkɔmǝ ubǝ nkpǝ. Nyamfo ni lesa nǝ David lɛwɔni lǝ wǝ kusǝnkue nuǝfǝ kafo nkǝ Onanto átɛyi itsyi lǝ Yesu ǝsuǝ nkǝ, ‘Mɔ Ubi feni. Nya mmii, mbofiani fǝ anto.’ ");
INSERT INTO lip_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Nya nyamfo ni lesa nǝ Onanto lɛtɛyi itsyi lǝ wǝ botakasǝ ketsyiko ɔkɔmǝ kǝbǝ ni nkǝ wembubu lǝ kudi kafo. ‘Mookpo fǝ atsyɔ nnya diyifo kɛnkɛ fe kase mínse uyi mintsyǝ miǝ mookpo David.’ ");
INSERT INTO lip_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Nko usi ɔ́tɛyi lǝ David eto kusǝ bamba nkǝ, ‘Mǝmbutǝ bǝ fǝ uyifoyifo kɛnkɛ ǝmfo kɛ lǝ kudi kafo ebú.’ ");
INSERT INTO lip_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Ditiki nǝmfo manyɛ lǝ David eto kutsyǝ itsyise usiǝ nkpǝ úyifo Onanto eto lelabi ǝsuǝ, nya ukpǝ nya bébikǝ wǝ ku wǝ bana mǝ nya wǝ ǝsuǝ eto sinǝ tsya díbú. ");
INSERT INTO lip_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Fɛɛ nwǝ Onanto létakasǝ utsyiko ɔkɔmǝǝ, wǝ ǝsuǝ eto sinǝ mémbú lǝ kudi kafo. ");
INSERT INTO lip_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Nyaso bayimi, bola boǝ bete lǝ ekpa bǝ ɛyɛ lǝ Yesu ǝmfo ǝsuǝǝ, nya bábe abuabufikatsyɛ eto ditiki nǝmǝ letsya bǝtǝ mi nɛ. ");
INSERT INTO lip_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Nya utsyuǝ saa wǝ lefo Yesu ɔnɔɔ, Onanto ebufi wǝ abua ɔtsyɛ wǝ nya weembolo wǝ dikpi. Nyamfo ni lesa lɔni nǝ Moses eto kɔfi dímamfo buyifo kulefe nɛ. ");
INSERT INTO lip_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Nyaso bebe kukɔnɔ! Biǝntǝ lǝ Onanto eto bǝnyɛlǝkǝtidi eto etiki nnya bátɛyi bǝtsyǝ lǝ ɛyɛ bubǝ kǝtǝ lǝ mi ǝsuǝ nko. ");
INSERT INTO lip_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Itsyise Onanto átɛyi nkǝ, ‘Bebe mimba lǝǝmǝ mɔ ditiki. Bitǝ lǝ iyifo mi yanii lǝ bǝtsylɔ! Itsyise lesa nǝ minlɛ buyifo mmii, iyifo lesa nǝ biembofo bɛnɔ, lǝ utsyuǝ ǝlǝkǝ ni kasɔ ote mi kulaa tsya.’ ” ");
INSERT INTO lip_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Se Paulo ku Barnaba nlɛ bɔbɔ lǝ disikakpekɔ mfóo, betidi bamǝ átɛyi mǝ bǝ besi bǝbǝ bedi mǝ etiki nyamfo lǝ Ɔnwɛditsyuǝ eto diyi nǝ luubǝ. ");
INSERT INTO lip_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Nya lefe nǝ bésensǝ lǝ disikakpekɔ mfóo, Yudafɔ kpǝ ku bafokanɔfɔ ba léfiani Yudafɔ nya baate Onanto sikpi ba lɛkɛ lǝ disikakpekɔ mfóo, ǝtǝkǝko Paulo ku Barnaba. Batɔnkpe bamǝ édi mǝ etiki nya balɛ mǝ kɔlɛ bǝ bǝńyǝ kekleke lǝ bǝsiǝ nkpǝ le lefonǝ Onanto ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Lǝ Ɔnwɛditsyǝyi nǝ disi dítǝkǝko nǝmfóo, ibu sɛkɛɛ eni umǝ ǝmǝ kenke eto betidi ǝbǝ disikakpekɔ nǝmǝ lǝ banɔ Bonamute eto ditiki nǝmǝ. ");
INSERT INTO lip_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Nya lefe nǝ Yudafɔ eto beninǝ dínyǝ sitiditu sia díbǝ disikakpekɔ mfóo, básɛsǝ ǝnǝmi lǝ mǝ ǝsuǝ, nya bétsyiko etiki bunǝ ku Paulo lǝ etiki nnya ɔnlɛ bɔtɛyi ǝsuǝ nya báka wǝ. ");
INSERT INTO lip_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Fɛɛ Paulo ku Barnaba ákpe utu besi bédi etiki bátɛyi mǝ bǝnkǝ, “Ele bǝ budi Onanto eto Ditiki Sɛɛ nǝmfo itǝ Yudafɔ bɔtɔnsǝ. Nya se bɛnɔ ditiki nǝmfo nya bɛtɛyi biǝnkǝ bianla nkpǝ manlo bomfoo, búfi ni bɔlɛ mba lenni Yudafɔ butǝ. ");
INSERT INTO lip_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Nyamfo ni kɔfi ko Bonamute dítǝ bo nkǝ, ‘Nnyifo fǝ fe okandiɛ ntǝ mba lenni Yudafɔ bǝ lǝ efi bofo aboko kawunsiǝ eto lɛkpɔ saa.’ ” ");
INSERT INTO lip_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Nya lefe nǝ mba lenni Yudafɔ lɛnɔ lesa nǝ bátɛyi mfoo, bǝnyǝ disuǝyuǝ tinti, nya bátɛsǝ Bonamute eto ditiki nǝmǝ. Nya mba kenke Onanto dílǝkǝ itǝ nkpǝ manloo, áfo bánɔ. ");
INSERT INTO lip_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Nya Bonamute eto ditiki nǝmǝ dísensǝ dísu kasɔ kamǝ kenke. ");
INSERT INTO lip_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Fɛɛ Yudafɔ bǝtsyuǝ édi ute bákpe lǝ besio ba nkpe dibu ba leesumu Onanto ku umǝ eto beninǝ eto nti. Nya bétsyiko Paulo ku Barnaba bulǝ kǝńyǝ mǝ lǝ ǝsuǝ, nya bála mǝ babɔsǝ lǝ mǝ lekpake mfó. ");
INSERT INTO lip_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Fɛɛ lefe nǝ banlɛ budu lǝ umǝ ǝmǝǝ, báflɛ utembu wǝ nkpo mǝ lǝ akpa bákpo lǝ umǝ ǝmǝ nnya léte bǝ umǝ ǝmǝ eto betidi áni mǝ. Nyamfo eto kamaa, bédu mfo bésu Ikonion. ");
INSERT INTO lip_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Nya bafokanɔfɔ ba lɛkɛ lǝ Antiokia mfó dínyǝ disuǝyuǝ tinti nya béyi ku Lɛwɔnɔ Kɛnkɛ. ");
INSERT INTO lip_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Nya se bédufǝ Ikonion tsyaa, Paulo ku Barnaba ésu Yudafɔ eto katsyakɔ mfó. Nya se bátɛyi Yudafɔ ku mba lenni Yudafɔ Ditiki Sɛɛ nǝmǝǝ, mǝ nti eto betidi kpǝ áfo bánɔ. ");
INSERT INTO lip_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Nya Yudafɔ ba dímamfo Onanto eto Ditiki Sɛɛ nǝmfo bánɔɔ, ǝnǝ etiki ku mǝ nya bábiasǝ mba lenni Yudafɔ eto nsusu nya bǝtǝ bǝ bátaka bǝńyǝ lǝ Paulo ku Barnaba lǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Fɛɛ batɔnkpe bamǝ ǝsiǝ lǝ umǝ ǝmǝ itǝ lefe kɛntsyɛ ditsyuǝ ákate Ditiki Sɛɛ nǝmǝ ku ute. Nya Onanto tsya dílǝkǝ wǝ lefonǝ eto etiki eto sitinti óte ɛyɛ lǝ ayanisa kpǝ nnya útǝ béyifo ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ibǝ bǝ umǝ ǝmǝ eto betidi áma lǝ akpa ǝnuǝ, bǝtsyuǝ ǝtǝkǝ lǝ Yudafɔ eto kama nya bǝtsyuǝ tsya dítǝkǝ lǝ batɔnkpe bamǝ eto kama. ");
INSERT INTO lip_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","6","Lǝ lefǝ ditsyuǝ eto kamaa, umǝ ǝmǝ eto betidi betsyuǝ ba leeni Yudafɔ ku Yudafɔ ku mǝ beninǝ éfi nsusu bǝ bataka bǝńyǝ lǝ mǝ ǝsuǝ bakpɔ mǝ aba. Batɔnkpe bamǝ ánɔ mǝ ketsyue kamǝ, nya bétsyetsyi bédu bésu Likaonia eto kǝmǝ ka ni Listra ku Derbe ku kǝmǝ ka nkpe lǝ lekpake mfó. ");
INSERT INTO lip_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Nya bédi Ditiki Sɛɛ nǝmǝ mfó. ");
INSERT INTO lip_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Se bésu Listraa, osani utsyuǝ akɛ mfó wǝ lɛtsyini taa lefe nǝ bále wǝ nya wámfo tɔ botaka kayɛ kulefe. ");
INSERT INTO lip_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Úsiǝ mfó úkanɔ ditiki sɛɛ nǝ Paulo ńyǝ ɔnlɛ budi. Nya se Paulo lébe wǝ tũũ, únyǝ nkǝ ófo ɔ́nɔ nya wǝ bufi bomǝ luuyuǝ wǝǝ, ");
INSERT INTO lip_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Nyaso Paulo áfã bembembe ɔ́tɛyi wǝ nkǝ, “Taka ǝńyǝ lǝ fǝ akpa ǝsuǝ!” Nya osani ǝmfo lésa ótaka úńyǝ nya útsyiko bɔyɛ kafe. ");
INSERT INTO lip_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Se betidi ba díńyǝ mfó banlɛ ditiki nǝmǝ ato butsyue dínyǝ lesa nǝ Paulo díyifoo, báfã bembembe lǝ Likaoniafɔ eto sele ǝsuǝ bátɛyi nkǝ, “Bananto beni! Báyifǝ bǝbǝ bo nti fenkǝ betidi!” ");
INSERT INTO lip_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Lǝ nyaso bǝtǝkǝ Barnaba diye bǝ Seus. Nya bǝtǝkǝ Paulo tsya bǝ Herme, itsyise wǝ ni futsyǝ díńyǝ nlɛ etiki budi nɛ. ");
INSERT INTO lip_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Nya Seus eto usumunyǝ, nwǝ eto kesumukɔ ńyǝ lǝ umǝ ǝmǝ eto kabanto mfóo, éfi banantsyui ku kaflawasi óboko nkǝ lǝ wǝ ku wǝ betidi bamǝ lǝ befi bǝtǝ batɔnkpe bamfo kedi lǝ umǝ ǝmǝ eto kabɔsie. ");
INSERT INTO lip_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Nya lefe nǝ Paulo ku Barnaba lɛnɔ lesa nǝ baala bǝ beeyifoo, bǝnǝ mǝ kosate eto awu nnya bankpe báfuadi, nya bétsyetsyi bédufǝ lǝ betidi bamǝ nti. Mfó nya báfã ");
INSERT INTO lip_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","bátɛyi bǝnkǝ, “Boantomǝ, be bɛnlɛ buyifo mfó? Bontsya kasɔ kamfo eto betidi ete buni fe mi ke. Búbǝ mfo boǝ boefi ditiki sɛɛ nǝmfo boboko mi. Bisinkli bɛyɛ asa bimba nyamfo eto kakle buyifo lǝ bifi atɛsǝ bitǝ Onanto wǝ dítǝ bo nkpǝ. Wǝ ni futsyǝ díyifo kato ku kasɔ ku lekpo ku asa nnya nkpe lǝ nnya kenke! ");
INSERT INTO lip_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Kɔɔ Onanto ǝtǝ kusu betidi kenke nkǝ bǝsiǝ nkpǝ lǝ kase mǝ léla ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Tsya usi wǝǝlǝkǝ kate mi nkǝ okpe sitinti ɛyɛ lǝ asa sɛ nnya weeyifo kǝtǝ mi. Wǝǝtǝ mi ɔsɔmi ku bekelenkǝ lǝ lefe sɛɛ ǝsuǝ nya wǝǝtǝ mi edisa ku disuǝyuǝ tsya.” ");
INSERT INTO lip_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ite bǝ bátɛyi mǝ nyamfo kenke tsyaa, ilǝ fɛ betidi bamfo lɛyɛ kedi kamfo mǝ butǝ. ");
INSERT INTO lip_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Nya Yudafɔ bǝtsyuǝ ditsyi Antiokia, umǝ wǝ nkpe lǝ Pisidia ku Ikonion bǝbǝ bábiasǝ betidi bamfo eto nsusu, nya bátɔnɔ ku mǝ báto Paulo aba nya bákpi wǝ lǝ kasɔ bábɔnko lǝ umǝ ǝmǝ, nya bébu bǝ úkpǝ. ");
INSERT INTO lip_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Nya lefe nǝ bafokanɔfɔ ba ńkpe mfo díbǝ bǝńyǝ batsyilama wǝǝ, ótaka nya usinkli úsu umǝ ǝmǝ. Nya se kale disiǝǝ, wǝ ku Barnaba édu bésu Derbe. ");
INSERT INTO lip_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Nya besu bedi Ditiki Sɛɛ nǝmǝ lǝ Derbe. Nya se betidi kpǝ bǝtsyuǝ díkafo bánɔ, bési besinkli bésu Listra ku Ikonion ku Antiokia lǝ Pisidia eto kasɔ. ");
INSERT INTO lip_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Mfoo, besi bákpe bafokanɔfɔ nkpe mfo nkɛale bǝ bǝnyǝ kekleke lǝ mǝ bofokanɔ ǝsuǝ. Nya bátɛyi mǝ tsya bǝ, “Ele bǝ bunyǝ kanyi kpǝ fɛ lǝ bunyǝ disuǝyuǝ lǝ Onanto eto sekakedikɔ.” ");
INSERT INTO lip_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Lǝ nnya kama Paulo ku Barnaba tsya ǝlǝkǝ batɔnkotɔnko bǝtǝ bafokanɔfɔ eto etsyukpa nyamǝ kenke, nya lǝ olatoto kǝtǝ Onanto ku lǝ kɛnyɛklekle ǝsuǝǝ, béfi mǝ bákpe lǝ Bonamte wǝ báfo bánɔ eto ani. ");
INSERT INTO lip_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Nya lefe nǝ bábɔ lǝ kǝmǝ ka nkpe lǝ Pisidiaa, bésinkli bésu Pamfilia eto kasɔ. ");
INSERT INTO lip_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Nya batɛyi Ditiki Sɛɛ nǝmǝ lǝ Perge fɛ báfe bésu Atalia. ");
INSERT INTO lip_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Mfó bǝsiǝ lǝ ɔklɔ báyɛ bésu Antiokia, kaka eto batɔnkotɔnko díkefi batɔnkpe bamǝ bákpe lǝ Onanto eto ani itǝ keyifo ka bákalosǝ mɔmɔ. ");
INSERT INTO lip_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Se bésu bédufǝ Antiokiaa, bákpadi bafokanɔfɔ ba nkpe mfó kenke bǝtsyǝ ditsyu nya bátɛyi mǝ kusu ko báyɛ eto etiki. Nya bátɛyi mǝ asa nnya kenke Onanto lɛyɛnko mǝ béyifo ku kase ɔ́sini bofokanɔ eto kusu utǝ mba lenni Yudafɔ. ");
INSERT INTO lip_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Nya bǝsiǝ lǝ Antiokia ku bafokanɔfɔ mfo itǝ lefe kɛntsyɛɛ ditsyuǝ. ");
INSERT INTO lip_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Lǝ lefe nǝ Paulo ku Barnaba lɛkɛ lǝ Antiokiaa, betidi bǝtsyuǝ ba ditsyi Yudea ǝbǝ mfó nya bákate bafokanɔfɔ bamǝ asa nnya ni bǝnkǝ, “Lǝ bánla fǝ lelo fe kase Moses eto lekpa letee, embunyǝ bofo.” ");
INSERT INTO lip_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Paulo ku Barnaba ku betidi bamfo ǝnǝ ditiki nǝmfo ɛklɛ. Lǝ nyamfo esoo, bǝtǝ bǝnkǝ bafokanɔfɔ eto bǝtsyuǝ tǝkǝko Paulo ku Barnaba lǝ besu Yerusalem lǝ mǝ ku batɔnkpe bamǝ ku bafokanɔfɔ eto beninǝ ba nkpe lǝ mfó lǝ balɛ lelolala eto etiki nyamfo babe. ");
INSERT INTO lip_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Nyaso se bafokanɔfɔ eto ditsyukpa nǝmǝ dítsyǝ mǝ kusu bálosǝǝ, bédu bésu Foinike ku Samaria eto kǝmǝ nya bésu bǝnyǝ bafokanɔfɔ ba nkpe mfó. Bátɛyi mǝ bǝ mɔmɔɔ, mba lenni Yudafɔ tsya éfi mǝ ǝsuǝ bǝtǝ Onanto, nnya ni bǝnkǝ mǝ tsya áfo bánɔ. Ditiki nǝmfo ákpe mǝmblɛ disuǝyuǝ tinti. ");
INSERT INTO lip_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Nya se bésu bédufǝ Yerusalem, mǝ beninǝ bamǝ ku bafokanɔfɔ ku batɔnkpe bamǝ áfo mǝ kukɔnɔ. Nya Paulo ku Barnaba dífi mǝ kusu ko bésu eto amaniǝ bábɔ mǝ ku asa nnya kenke Onanto díyifo ɔ́yɛ lǝ mǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Fɛɛ Farisifɔ ba díkafo Ditiki Sɛɛ nǝmǝ eto ditsyukpa eto bǝtsyuǝ átaka bǝńyǝ lǝ mǝ nti bátɛyi bǝnkǝ, “Ele be bayimi ba lenni Yudafɔ tsya la lelo nya lǝ beyifo lǝ Moses eto kɔfi ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Nyaso mǝ beninǝ ku batɔnkpe bamǝ átsya fe ditsyukpa nya bédufǝ lǝ ditiki nǝmfo ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Nya lǝ katsyakɔ kamfóo, lǝ lefe nǝ bákalɛ etiki nyamǝ bábe ɛklɛɛ, Petro átaka úńyǝ nya ɔ́tɛyi mǝ nkǝ, “Bayimi, mi kosate yi biǝ Onanto dílǝkǝ mɛ taa kɔ utsyiko mi nti nkǝ ntɛyi betidi ba lenni Yudafɔ tsya Ditiki Sɛɛ nǝmfo lǝ mǝ tsya lǝ bafo banɔ. ");
INSERT INTO lip_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Nya Onanto wǝ nyi betidi eto utu kǝmiǝǝ, ǝlǝkǝ óte nkǝ ófo mǝ nya útǝ mǝ wǝ Lɛwɔnɔ Kɛnkɛ fe kase úfi útǝ bo tsya. ");
INSERT INTO lip_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Wánkpe kabakǝfǝ lǝ bonko mǝ nti, nyaso ófo mǝ lǝ bofokanɔ ǝsuǝ. Nya úfi mǝ abua ɔ́tsyǝ mǝ fe bo ke. ");
INSERT INTO lip_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Nya mɔmɔɔ, beso biato Onanto kabe mmǝ? Bo ku bo banamǝ mámfo bikǝ bia nkpe kalende butsyi! Beso bɔnlɛ mi bufi ketsyisǝ bafokanɔfɔ mfo? ");
INSERT INTO lip_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Owo lo! Nnya ni bǝ bófo bɔ́nɔ boǝ kase Onanto dínyǝ bo kaminsǝ nya ófo bo lǝ nkpǝ ɛyɛ lǝ Bonamute Yesu eto lefonǝ ǝsuǝǝ, woofo mǝ tsya fe kase mǝǝtsya léfo bánɔ.” ");
INSERT INTO lip_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Lǝ nyasoo, mǝmblɛ kenke ésinkli báyɛ etiki budi nya bǝsiǝ bétsyue ato lǝ nnya Barnaba ku Paulo lɛtɛyi bǝnkǝ, Onanto áyɛ lǝ mǝ ǝsuǝ úyifo ayanisa kpǝ itǝ mba lenni Yudafɔ. ");
INSERT INTO lip_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Lefe nǝ bákalosǝǝ, Yakobo tsya átaka úńyǝ ɔ́tɛyi nkǝ, “Bayimi, bitsyue ato lǝ bɔnɔ. ");
INSERT INTO lip_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simon Petro éboklomasǝ bo ibǝ efe ditutɛ, lǝ kase Onanto dílǝkǝ wǝ lelabi óte betidi ba lenni Yudafɔ nya úlǝkǝ bǝtsyuǝ útsyiko lǝ mǝ nti nkǝ bafiani wǝ bale. ");
INSERT INTO lip_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Nya ditiki nǝ wǝ bǝnyɛlǝkǝtidi lɛtɛyi bǝtsyǝ ǝbǝ ítǝ fe kase bawɔni bǝ Bonamute átɛyi nkǝ, ");
INSERT INTO lip_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Lǝ nyamfo eto kamaa, muusinkli mbǝ nya muusinkli nto Oka David eto sekakedikɔ. Nya muusinkli nto asa nnya lébia mfó bǝ lǝ isinkli ɛlɔ itsyǝ kukɔnɔ. ");
INSERT INTO lip_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Itǝ bǝ betidi ba díbu, ku mba lenni Yudafɔ kenke ba mínkpadi minkǝ bedi mɔ betidi ebubǝ mɔ ɔflɔ. Nko ini nɛ bǝ Bonamute éyifo lǝ lesa saa nǝ ɔ́tɛyi útsyǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Onanto lɛtɛyi ditiki nǝmfo betidi léte taa kɔ ke.’ ");
INSERT INTO lip_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Nyaso mɔ, Yakobo, nlɛ mi bɔtɛyi minkǝ betidi ba lenni Yudafɔ mfo nya béfi mǝ ǝsuǝ bǝtǝ Onantoo, yanle bǝ ibǝ bǝ buti mǝ kusu lǝ asa nyamfo ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Bomu bitǝ lǝ bɔwɔni mǝ kukue buǝ bayɛ asa nnya beefi kǝtǝ bǝfiǝ kedi nnya lǝǝtǝ baanansǝ ǝsuǝ budi ku sɛsɔnɔdi ku bebuki ba báwaninsǝ simuǝ bálo ku kɔtɔ eto budi. ");
INSERT INTO lip_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Itsyi taa kɔɔ, asa nnya Moses lɛwɔni utsyǝǝ, baakla nnya nya baatɛyi nnya lǝ Yudafɔ eto katsyakɔ lǝ Ɔnwɛditsyǝyi saa lǝ umǝ saa.” ");
INSERT INTO lip_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Nya batɔnkpe ku beninǝ ku bafokanɔfɔ kenke eto ditsyukpa lɛtɔnɔ bǝlǝkǝ betidi bǝtsyuǝ bǝ bǝtǝkǝko Paulo ku Barnaba besu Antiokia. Betidi inuǝ ba bǝlǝkǝ eyifo bafokanɔfɔ eto beninǝ. Mǝ ni Yuda wǝ bensi baakpo tsya bǝ Barsaba ku Sila. ");
INSERT INTO lip_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Nya kukue ko bálɛ bésuko eto etiki nnya nkpe lǝ ko ǝsuǝ ni nkǝ, Bo, batɔnkpe ku beninǝ ba ni mi bayimi ba nkpe lǝ Yerusalem, boǝ boǝsiǝsǝ mi, bo bayimi ba lenni Yudafɔ mba nkpe lǝ Antiokia ku Siria ku Kilikia. ");
INSERT INTO lip_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Bɔ́nɔ boǝ bo mfo eto bafokanɔfɔ eto bǝtsyuǝ ǝbǝ mfó bǝbǝ bǝnǝ etiki ǝtsyuǝ ku mi itsyi lǝ bo Yudafɔ eto lelolala eto lekpa ǝsuǝ. Nyaa, inni bo létsyese mǝ bǝ bǝbǝ batɛyi mi etiki nyamfo eto okle. ");
INSERT INTO lip_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","26","Nyamfo eso se bókpe disi bǝtsyuǝǝ, bɔlɛ beninǝ inuǝ lǝ bo nti botsyese ku bo bayimi lala Barnaba ku Paul ba díkefi mǝ nkpǝ bǝtǝ fǝ keditǝtǝ itǝ Bonamute Yesu Kristo bǝ lǝ bǝbǝ mi ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Yuda ku Sila tsya ebɔtɛyi mi asa nnya bɔ́wɔni bokpe mfo. ");
INSERT INTO lip_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Itsyise iyifo Lɛwɔnɔ Kɛnkɛ eto lelabi ku bo lele tsya boǝnkǝ yanle bǝ ibǝ bǝ bufi Yudafɔ eto afi buyifo bitsyikǝ butsyisǝ mi enso asa nyamfo. ");
INSERT INTO lip_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Bɛni asa nnya béfi bǝtǝ bǝfiǝ kedi ku kɔtɔ budi ku bebuki ba báwaninsǝ simuǝ bálo eto budi ku sɛsɔnɔdi. Lǝ biɔlɛ mi ǝsuǝ mǝǝ, lesa saa ebuyuǝ ko mi. Bisiǝ kukɔnɔ. ");
INSERT INTO lip_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Nyaso batɔnyɛ bamfo áma kusu bésu Antiokia. Nya se bésu bédufǝǝ, bákpadi bafokanɔfɔ bamǝ kenke bǝbǝ bátsya. Nya béfi kukue ko bétsyiko Yerusalem mfó bǝtǝ mǝ. ");
INSERT INTO lip_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Nya mba kenke lɛkɛ mfo ǝnyǝ disuǝyuǝ ku nkɛale itsyi lǝ etiki nnya bákla lǝ kukue komǝ ǝso. ");
INSERT INTO lip_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Nya se Yuda ku Sila díyifo Onanto eto bǝnyɛlǝkǝtidi esoo, bǝlǝkǝ asa kasɔ báte mǝ, bálɛ mǝ kɔlɛ, nya bákpe mǝ nkɛale. ");
INSERT INTO lip_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Nya se bǝsiǝ mfó eyi asianii, bafokanɔfɔ bamǝ ǝtǝ mǝ kusu bǝ besinkli besu Yerusalem lǝ diyuǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Fɛɛ Sila nkǝ wuusiǝ mǝ lǝ ɔflɔ mfó. ");
INSERT INTO lip_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Nya Paulo ku Barnaba dísiǝ lǝ Antiokia mfó nya mǝ ku babamba kpǝ ákɛ mfo bákate mǝ asa kedi mǝ etiki utsyi lǝ Bonamute ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Lǝ eyi ǝtsyuǝ kamaa, Paulo átɛyi Barnaba nkǝ, “Tǝ lǝ busi busu bobe bo bayimi ba nkpe lǝ kǝmǝ ka kenke búkesu budi Ditiki Sɛɛ nǝmfó ku nka bɔ́yɛ bófe lǝ bobe kase banlɛnko.” ");
INSERT INTO lip_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnaba átɔnɔ nya óla nkǝ lǝ okpa Yohanes nwǝ tsya besi baakpo Marko ɔyɛnko. ");
INSERT INTO lip_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Fɛɛ Paulo mántɔnɔko wǝ kulaa! Itsyise lefe nǝ mǝ ku wǝ dísu Pamfiliaa, Marko Yohanes ésikli lǝ mǝ kama údu, nya wǝnsiǝ bálosǝ mǝ keyifo. ");
INSERT INTO lip_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Nyaso Marko Yohanes eto etiki nyamfo ǝbǝ ékpe mǝ inuǝ bamǝ kǝnǝ ɛklɛ, itǝ bǝ bésense lǝ bǝtsyuǝ. Barnaba ákpa Marko ɔ́yɛnko nya béfi ɔklɔ bésu Kipro. ");
INSERT INTO lip_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Nya Paulo lékpa Sila ɔ́yɛnko, nya bafokanɔfɔ ba nkpe mfó dífi mǝ bákpe lǝ Onanto eto ani fɛ bédu. ");
INSERT INTO lip_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Nya báyɛ lǝ Siria ku Kilikia nya bákpe bafokanɔfɔ eto etsyuka nnya kenke nkpe mfó nkɛale. ");
INSERT INTO lip_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Nya Paulo ku Sila dídu bésu umǝ wǝ baakpo Derbe, nya báyɛ mfo bésu Listra. Lǝ mfóo, bésu bǝnyǝ ofokanɔnyǝ utsyuǝ wǝ baakpo Timoteo. Wǝ ambe éyifo Yudanyǝ wǝ díkafo Kristo ɔ́nɔ. Fɛɛ wǝ anto éyifo Grikinyǝ. ");
INSERT INTO lip_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Bafokanɔfɔ kenke ba nkpe lǝ Listra ku Ikonion, ékebu Timoteo tinti. ");
INSERT INTO lip_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Wǝ ni futsyǝ Paulo lela kekleke nkǝ lǝ okpa wǝ ɔyɛnko. Nyaso útǝ bala wǝ lelo fe kase Yudafɔ eto lekpa léte, itsyise Yudafɔ ba kenke nkpe lǝ lɛkpɔ nǝmfo yi bǝnkǝ wǝ anto éyifo Grikinyǝ. ");
INSERT INTO lip_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Nya se báma kusuu, báyɛ lǝ kǝmǝ ka kenke nkpe mfó báfe, nya bátɛyi mǝ ketsyue ka batɔnkpe eto beninǝ ba nkpe lǝ Yerusalem dítsyue bǝtsyǝ. Nyaso bátɛyi mǝ bǝ lǝ beyifo lǝ nnya ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Nyamfo eso betidi bamǝ ǝbǝ befui bakpe, nya nko ke tsya mǝ bofokanɔ tsya dimuǝ ale enso nɛ. ");
INSERT INTO lip_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Lǝ nyamfo eto kamaa, báyɛ bésu Frigia ku Galatia, itsyise Lɛwɔnɔ Kɛnkɛ mǝntǝ mǝ kusu nkǝ bátɛyi Ditiki Sɛɛ nǝmǝ lǝ Asia eto kasɔ. ");
INSERT INTO lip_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Nya lefe nǝ bésu bédufǝ Misiaa, bála bǝ lǝ besu Bitinia eto kasɔ. Fɛɛ mfó tsyaa, Yesu eto Lɛwɔnɔ Kɛnkɛ mǝntǝ kusu nkǝ besu mfó. ");
INSERT INTO lip_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Nyaso bésinkli báyɛ lǝ Misia eto kasɔ ɔflɔ nya bésu bédufǝ umǝ wǝ nkpe lǝ lekpo ɔflɔ baakpo Troa. ");
INSERT INTO lip_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ketsye kamfóo, Paulo ǝńyǝ kǝlǝkǝkate. Únyǝ nkǝ osani utsyuǝ wǝ ditsyi Makedonia nya únyǝ ɔnlɛ wǝ lekpakpa bɔlɛ ákatɛyi nkǝ, “Yila ǝbǝ Makedonia lǝ ǝbǝ mfo lǝ ǝbǝ awunsǝko bo o-o!” ");
INSERT INTO lip_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Nya lǝ bulǝkǝkate bomfo esoo, búmuǝ ǝsuǝ akpa kpa nya búdu búsu Makedonia. Itsyise nyamfo lǝ bo bote nkǝ Onanto ála nkǝ lǝ otsyese bo lǝ busu bɔtɛyi Ditiki Sɛɛ nǝmǝ mfó. ");
INSERT INTO lip_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Nyaso búsu búfi ɔklɔ lǝ Troa, nya bɔ́yɛ bófe búsu Samotrake. Nya se kale dísiǝǝ, búdu búsu Neapoli. ");
INSERT INTO lip_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Se búdu mfóo, búsu búdufǝ Filipi wǝ ni Makedonia eto umǝ nkplɛ. Nya mfó tsya eyifo Romafɔ eto umǝ. Nya búsiǝ mfó itǝ eyi ǝtsyuǝ. ");
INSERT INTO lip_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Lǝ Ɔnwɛditsyǝyii, búdu lǝ umǝ ǝmfó búsu utuflɔ utsyuǝ kaka búbu boǝ mfó eto bediti aato ola kǝtǝ Onanto. Nya búsiǝ mfó bɔnlɛ besio ba díbǝ mfó Onanto eto Ditiki Sɛɛ nǝmǝ bɔtɛyi. ");
INSERT INTO lip_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Nya ɔni akɛ mǝ lenti baakpo Lidia Tiatira. Woate ago eto mfia nya uyifo utidi wǝ léfo Onanto ɔ́nɔ kekleke. Nya lefe nǝ unsi mfó ɔnlɛ etiki nya bɔnlɛ bɔtɛyi ato butsyuee, Onanto ásini wǝ nsusu nya ófo etiki nnya Paulo nlɛ budi mfó kenke ɔ́nɔ. ");
INSERT INTO lip_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Nya se wonko wǝ diyo eto betidi kenke léfo ntuflǝsǝflǝsǝ eto lekpa nǝmǝǝ, ɔ́lɛ bo lekpakpa nkǝ, “Lǝ befo bɛnɔ biǝ mintsya eyifo Bonamute eto ofokanɔnyǝ sitintii, nyalɛ bibǝ bɛsɔnɔ lǝ mɔ ɔflɔ.” Nya únǝnko bo ditiki nǝmfo isu ese lefe nǝ bɔ́tɔnɔ búsu bɔ́sɔnɔ lǝ wǝ ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Nya diyi lɔni se bɔ́ntɔ lǝ ola katokɔɔ, bótsyako ndomunyǝ siobi utsyuǝ wǝ lɛwɔnɔ bua nsi lǝ ǝsuǝ wǝ lǝǝnyǝ asa katɛyi. Nya woayɛ lǝ nnya ǝsuǝ keyifo atabi kǝtǝ wǝ banamute mǝ. ");
INSERT INTO lip_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Nya usiobi ǝmfo dítǝkǝko bo ku Paulo kama kafã katɛyi nkǝ, “Betidi bamfo eyifo Onanto eto beyifoyifo, nya bǝbǝ mfo bǝ lǝ bate mi konantosu ko luutǝ Onanto tǝ mi nkpǝ.” ");
INSERT INTO lip_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Nko eto eyifosa ǝtsyǝ nko éfo eyi kpǝ. Nya se ditsyǝbi nǝmǝ díbe dílǝ Pauloo, útsyi ɔwuninsǝ nya údi lɛwɔnɔ nǝ nsi lǝ usiobi ǝmǝ ǝsuǝ nkǝ, “Nlɛ fǝ bola lǝ Yesu Kristo eto diye ǝsuǝ miǝ bɔ lǝ wǝ ǝsuǝ!” Nya lamfolamfoo, lɛwɔnɔ bua nǝmǝ ko lɛbɔ lǝ wǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Nya se wǝ banamute dínyǝ bǝ mǝ kudisu étii, bǝmuǝ Paulo ku Silas nya bǝnǝ mǝ bésuko umǝ ǝmǝ eto beninǝ ɔflɔ lǝ obia nti. ");
INSERT INTO lip_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Nya bátɛyi lǝ obia nti mfó bǝnkǝ, “Betidi bamfo eyifo Yudafɔ, nya bǝbǝ mfo banlɛ bo umǝ bobiasǝ. ");
INSERT INTO lip_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Bǝbǝ mfo balɛ asa nnya díńyǝ lǝ Romafɔ eto afi ǝsuǝ bote.” ");
INSERT INTO lip_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Nya betidi kpǝ díbǝ bátsyilama mǝ, nya bétsyiko Paulo ku Sila bunǝ kesuko sɛtɔ ku kama. Nya bakponkpo bamǝ dítǝ kusu bǝnkǝ bǝlǝkǝ mǝ bikǝ lǝ ǝsuǝ, nya bǝtǝ kusu bǝnkǝ bablɛ mǝ ku akete. ");
INSERT INTO lip_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Lefe nǝ báblɛ mǝ báfo afabe lǝ ǝsuǝ tintii, béfi mǝ bésu bákpe lǝ Aba eto diyo. Nya bátɛyi utidi wǝ laase mba bákpe lǝ diyo mfó bǝnkǝ ɔlɔ obe Paulo ku Sila kekleke. ");
INSERT INTO lip_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Nya se bǝkǝ wǝ ato nko esoo, ókpa mǝ úsu ókpe diyo nǝmǝ eto kaka nso ale nya úti mǝ ókpe mfó, ókpe mǝ lǝ amana. ");
INSERT INTO lip_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Nya lǝ ntsyǝnti lefe nǝ Paulo ku Sila lɛkɛ mfo bákato ola kǝtǝ Onanto nya banlɛ ǝsǝ busǝ katɛsǝ wǝ nya mba nkpe lǝ diyo nǝmǝ ku mǝ ǝkǝtsyuǝ ato. ");
INSERT INTO lip_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Dikunǝ, kasɔ ko dítinkǝ kekleke, nya diyo nǝmǝ kenke tsya dítinkǝ itǝ bǝ diyo ni biku kenke ásini, nya amana nnya bákpe mba bákape lǝ diyo nǝmǝ dífǝsǝ ɛbɔ. ");
INSERT INTO lip_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Se nwǝ laabe mba bákpe lǝ diyo lésanklii, únyǝ nkǝ ayo nyamǝ eto biku kenke ásini bite leya. Nyaso se úbu nkǝ mba bákpe lǝ diyo nǝmǝ kenke étsyǝtsyi béluu, úlǝkǝ wǝ lesiabi nkǝ lǝ olo ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Nya se Paulo dínyǝ lesa nǝ óla nkǝ lǝ uyifo ǝsuǝǝ, ófã ókpadi wǝ ɔ́tɛyi nkǝ, “Menyifo nko! Bomblɛ kenke kpe mfo.” ");
INSERT INTO lip_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Nyaso utidi ǝmfo ákpadi nkǝ befi okandiɛ baboko. Nya lǝ ketinkǝ ku difufu ǝsuǝǝ, úsu óse akonki lǝ Paulo ku Sila ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Nya se ókpa mǝ ɔbɔnko lǝ diyo nǝmǝ kafoo, ɔ́tɔ mǝ nkǝ, “Boantomǝ, be ele bǝ nyifo lǝ nyǝ bofo?” ");
INSERT INTO lip_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Nya bátɛyi wǝ bǝnkǝ, “Fo Bonamute Yesu anɔ nya ɛyɛ lǝ nnya ǝsuǝǝ, ebunyǝ bofo itǝ fǝ ku fǝ diyo eto betidi kenke.” ");
INSERT INTO lip_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Nya bésu bátɛyi wǝ ku wǝ diyo eto betidi kenke Bonamute eto ditiki nǝmǝ. ");
INSERT INTO lip_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Nya ketsye kamfo ke nya úsǝ mǝ afabe nnya báfo, nya wǝ ku wǝ diyo eto betidi kenke léfo ntuflǝsǝflǝsǝ eto lekpa nǝmǝ. ");
INSERT INTO lip_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Lǝ nnya kamaa, ókpa Paulo ku Sila úsuko wǝ diyo nya útǝ mǝ lesa bédi. Nya wǝ diyo eto betidi kenke dínyǝ disuǝyuǝ tinti, itsyise báfo Onanto bánɔ. ");
INSERT INTO lip_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Se kale dísiǝǝ, umǝ ǝmǝ eto bakponkpo ákpe wǝ bamamanyǝ nkǝ besu bátɛyi nwǝ laabe mba bákpe lǝ diyo eto uninǝ nkǝ, “Nyani bafɔ bamǝ lǝ bedu.” ");
INSERT INTO lip_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Nyaso mǝ obebe ǝmfo átɛyi Paulo ku Sila bǝnkǝ, “Bakponkpo bǝnkǝ nyani mi lǝ bidu. Nyaso bisu lǝ diyuǝ ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Nya Paulo lɛtɛyi bamamanyǝ bamfo bǝnkǝ, “Bablɛ bo lǝ umǝ ta eto ǝnǝmi lǝ lefe nǝ eto lefe bánkponko bo tɔ lekpo nya béfi bo bésu bákpe lǝ Aba eto diyo. Fɛɛ Romafɔ buni! Nya mɔmɔɔ, beso bala bǝnkǝ beyu bǝlǝkǝ kaa lǝ budu bǝ lǝ betidi mante? Kulefe! Tǝ lǝ mǝ kosate lǝ bǝbǝ bǝlǝkǝ bo kusu!” ");
INSERT INTO lip_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Nyaso bamamanyǝ bamfo ésinkli bésu bátɛyi bakponkpo bamǝ kɛnyɛ kamfo. Nya se bánɔ bǝ Paulo ku Sila eyifo Romafɔɔ, sikpi ǝmuǝ mǝ tinti! ");
INSERT INTO lip_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Lǝ nya mfo eso bésu bálɛ mǝǝ lekpakpa bǝyuǝsǝ mǝ kafo, fɛ bǝlǝkǝ mǝ lǝ aba eto diyo nǝmǝ. Nya bálɛ mǝǝ lekpakpa bǝ bédu lǝ umǝ ǝmǝ lǝ besu kalebe bamba. ");
INSERT INTO lip_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Nyaso Paulo ku Sila édu bésu Lidia eto. Mfó nya bésu bǝnyǝ bafokanɔfɔ bamba. Nya bési bákpe mǝ nkɛale enso, fɛ bédu lǝ umǝ ǝmǝ. ");
INSERT INTO lip_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Nya se bésu báyɛ lǝ Amfipoli ku Apoloniaa, bésu bédufǝ Tesalonika. Nya mfóo, Yudafɔ eto katsyakɔ ákɛ. ");
INSERT INTO lip_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Nya fe kase Paulo laala buyifoo, úsu mfó nkǝ lǝ úsu udi mǝ etiki lǝ disikakpekɔ kamǝ. Nya lǝ Ɔnwɛditsyǝyi ǝtsyǝ nya dítǝkǝ lǝ bǝtsyuǝ ǝsuǝǝ, úsukate mǝ asa itsyi lǝ etiki nnya nkpe lǝ Awɔnisa kɛnkɛ eto kukue ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Nya ókpasǝ mǝ bulǝ bo bátɛyi bǝtsyǝ bǝ Kristo ebubǝ unyǝ ku kase lǝ nnya kamaa, wootaka utsyi ɔkɔmǝ ubǝ nkpǝ. Paulo átɛyi mǝ nkǝ, “Utidi wǝ eto etiki minlɛ mi bɔtɛyi mfo ni Yesu wǝ ni Nwǝ Onanto Lékpo Ɔhile Utsyǝ nɛ.” ");
INSERT INTO lip_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Etiki nnya ókpasǝ óte mǝ mfó átsyi mǝ bǝtsyuǝ eto nsusu bɔ́wuninsǝ, nya báfo bánɔ bǝtǝkǝko Paulo ku Sila. Nya Grikifɔ kpǝ ba laate Onanto sikpi ku besio kpǝ ba nkpe díbu tsya átsyi bawuninsǝ lǝ umǝ ǝmǝ bǝtǝkǝko mǝ. ");
INSERT INTO lip_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Fɛɛ Yudafɔ asɛsǝ ǝnǝmi lǝ mǝ ǝsuǝ. Nyaso babɛbɛ betidi bua bǝtsyuǝ lǝ umǝ ǝmǝ ba bǝtǝ bǝ umǝ ǝmǝ eto betidi lǝ bataka bǝńyǝ lǝ mǝ ǝsuǝ. Nyaso bákpa betidi kpǝ ba lányǝ lǝ ditsyǝbi saa ǝsuǝ ku kudu besu batsyilama Yason eto diyo ku nsusu bǝ lǝ bǝmuǝ Paulo ku Sila lǝ bakpa mǝ besuko umǝ ǝmǝ eto katsyakɔ. ");
INSERT INTO lip_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Nya se bǝnnyǝ mǝ esoo, bǝmuǝ Yason ku bafokanɔfɔ bǝtsyuǝ nya bǝnǝ mǝ besuko katsyakɔ kamǝ. Mfó banlɛ bofa katɛyi bǝnkǝ, “Betidi bǝtsyuǝ lɛ bɔyɛ katsyilama kakpe bulǝ lǝ kalebe saa, nya bǝbǝ mfo tsya bǝ lǝ bakpe, bulǝ. ");
INSERT INTO lip_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Nya Yason tsya léfo mǝ ókpe lǝ wǝ diyo. Nya betidi bamǝ létaka bǝńyǝ lǝ Roma eto Okankplɛ eto kɔfi ǝsuǝ. Nya mǝ asatete nlɛ bɔtɛyi nkǝ oka bamba wǝ baakpo Yesu si okpe!” ");
INSERT INTO lip_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Nya se bánɔ nyamfoo, betidi bamǝ ku umǝ eto beninǝ ǝnyǝnki nyanklaa. ");
INSERT INTO lip_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Nya bátɛyi bǝnkǝ ele bǝ Yason ku wǝ betidi fo kayo fe mba díńyǝ mǝ kama fɛ lǝ bayani mǝ. ");
INSERT INTO lip_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Nyaso diyi nǝmfo eto ketsyee, bafokanɔfɔ lǝ umǝ ǝmǝ ákpa Paulo ku Sila bétsyetsyiko bésuko Beroia. Nya se bésu bédufǝ mfóo, bésu Yudafɔ eto katsyakɔ. ");
INSERT INTO lip_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Mba lǝ Beroiaa, mǝ nsusu ásini lǝ Ditiki Sɛɛ nǝmǝ ǝsuǝ esó Tesalonikafɔ. Nyaso bétsyue ato bánɔ lesa nǝ banlɛ bɔtɛyi. Nya diyi saa, nya banlɛ budufǝ lǝ Awɔnisa Kɛnkɛ eto Kukue komǝ ǝsuǝ kabe lǝ etiki nnya Paulo nlɛ bɔtɛyi eyifo sitinti. ");
INSERT INTO lip_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Itǝ eso mǝ nti eto bǝtsyuǝ kpǝ áfo bánɔ. Grikifɔ eto besio kpǝ ba nkpe díbu ku basani kpǝ tsya áfo bánɔ bátsyi bawuninsǝ. ");
INSERT INTO lip_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Fɛɛ lefe nǝ Yudafɔ ba nkpe lǝ Tesalonika lɛnɔ bǝ Paulo kpe ɔlɛ Ditiki Sɛɛ nǝmǝ budi lǝ Beroiaa, bésu mfó bésu bákpe kǝnǝ ku bulǝ lǝ umǝ ǝmǝ. ");
INSERT INTO lip_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Nyaso bafokanɔfɔ ba nkpe mfoo átaka kpla bǝńyǝ nya bákpa Paulo bésuko lekpo kɛnyɛ. Nya íbu Sila ku Timoteo lǝ Beroia mfó. ");
INSERT INTO lip_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Mba lékpa Paulo bayɛnko, áyɛnko wǝ bédufǝnko Atene. Se bétsyi mfo banlɛ bubǝǝ, Paulo ǝtǝkǝ mǝ kɛnyɛ nkǝ bǝbǝ batɛyi Sila ku Timoteo lǝ bakɔse bǝbǝ betu wǝ mfó. ");
INSERT INTO lip_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Lefe nǝ Paulo lɛkɛ lǝ Atene unsi unsǝkǝ Sila ku Timoteo, iyifo lesa nǝ dílǝ wǝ tinti se únyǝ kase betidi bamfo dítsyǝ bǝfiǝ beesumu, nya umǝ ǝmǝ kenke díyi ku bǝfiǝ. ");
INSERT INTO lip_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Lǝ nyasoo, úsu mfó nkǝ weesu udi Yudafɔ ku betidi bamba ba laate Onanto sikpi tsya etiki lǝ mǝ katsyakɔ. Nya diyi saa, úkedi mba úkǝnyǝ lǝ asi tsya etiki. ");
INSERT INTO lip_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Nya lefe lɔnii, betidi bǝtsyuǝ ba ni Epikurofɔ ku Stoafɔ ba ni kawunsiǝ eto babesibe kplɛ ǝnǝ etiki ku Paulo nya bátɛyi bǝnkǝ, “Be kon utikidi wǝ leenyi kulesa ǝmfo nlɛ bɔtɛyi?” Nya babamba tsya lɛtɛyi bǝnkǝ, “Iyifo fenkǝ nsɔ bamba eto bǝfiǝ ǝsuǝ ɔnlɛ etiki budi ketsyiko.” Nya betidi bamfó édi etiki nko itsyise bánɔ bǝ Paulo édi etiki itsyi lǝ Yesu ku wǝ botaka ketsyi ɔkɔmǝ kǝbǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Lǝ nyamfo esoo, bákpa wǝ bésuko kaka baakpo akpo lǝ Areopago ini umǝ eto beninǝ eto disikakpekɔ, nya bátɛyi bǝnkǝ, “Bola boǝ boate asafɔfɔ nnya fanlɛ bote mfo eto kasɔ. ");
INSERT INTO lip_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Itsyise asa nnya fanlɛ bote eyifo bo yanii. Nyaso bola boǝ boanɔ nnya kasɔ.” ");
INSERT INTO lip_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Nya Atenefɔ kenke ku bafɔ ba nkpe lǝ kasɔ mfóo, eefi mǝ lefe kǝtǝ asafɔfɔ saa eto etiki bɔtɛyi ku nnya bɔnɔ. ");
INSERT INTO lip_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Nyaso Paulo átaka únyǝ lǝ disikakpekɔ kamǝ lǝ betidi bamfó eto ǝnǝmi, nya ɔ́tɛyi mǝ nkǝ, “Lǝ kusu saa ǝsuǝǝ, nyǝ ntsyǝ lekpo miǝ mi Atenefɔɔ, biyifo betidi ba laala kesumu tinti. ");
INSERT INTO lip_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Itsyise se minlɛ botsyilama kalɛ asa ola kabee, nya se mínyǝ mi nsumukɔɔ, nnyǝ kesumukɔ kani ka báwɔni bǝtǝkǝ lǝ kǝ leba ǝsuǝ bǝnkǝǝ, ‘Búfi nyamfo bútǝ bo Anto wǝ bunyi.’ Nya Anto wǝ binyi fɛ bɛnlɛ wǝ busumu mfoo, wǝ ǝsuǝ minla miǝ meedi mi etiki mɔmɔ nɛ. ");
INSERT INTO lip_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Anto ǝmfo ni Bonamute wǝ diyifo kawunsiǝ, kato ku kasɔ ku asa nnya kenke nkpe lǝ ke. Nya woǝnsiǝ kpoo lǝ disumuyo fe nǝ kasɔ mfo eto betidi dífi mǝ ani báto. ");
INSERT INTO lip_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Nya woanhiã bǝ udi kulesa itsyi lǝ betidi eto ani ɛyɛ lǝ mǝ keyifo tsya ǝsuǝ, itsyise wǝ kosate ni futsyǝ lǝǝtǝ utsyuǝ saa nkpǝ ku lesa saa nǝ baahiã. ");
INSERT INTO lip_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Wǝ dílǝkǝ utidi saa ɛyɛ lǝ utidi ɔni ǝsuǝ bǝ lǝ busiǝ nkpǝ fe kɔtɔ kɔni eto bebi lǝ kasɔ kamfo kenke ǝsuǝ. Wǝ kosate dítsyǝ lefe ku kedikɔ útǝ mǝ tsya. ");
INSERT INTO lip_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Nya Boanto dítsyue nyamfo utǝ bo betidi itǝ bǝ lǝ bɔbɛbɛ wǝ esu lǝ bunyǝ wǝ, ekpe bǝ lǝ sintintii, woantsyonko bo. ");
INSERT INTO lip_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Itsyise fe kase mi mba laatɛyi akpa lɛtɛyii, ‘Wǝ ni nwǝ nsi nkpǝ nyaso bo tsya nsi nkpǝ, nya bunsi nkpǝ ku wǝ nya boalabe selabe lǝ wǝ.’ Nya baatɛyi tsya bǝnkǝ, ‘Bɔ́bɔ butsyi lǝ wǝ.’ ");
INSERT INTO lip_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Nya se buni Onanto eto bebi esoo, yanle bǝ ibǝ bǝ bubú boǝ Onanto ǝmfo te fe lesa nǝ bo betidi dífi sika sia nye siflubia nye kuyi nye leba búyifo ku bo ani nye lesaatsyuǝ nǝ baawoe nye lǝ ditsyǝbi saa ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Nya idu lǝ kawunsiǝ eto kasɔ ketsyikokɔ ibǝ ese mɔmɔɔ, Onanto mǝnnǝ utidi saa koto itsyise bánte wǝ eso. Fɛɛ mɔmɔ mfoo, úkǝ bo ato nkǝ bulǝkǝ bo ǝsuǝ lǝ asa nyamfo eto kakle ǝsuǝ lǝ butsyi ǝnǝmi butǝ wǝ. ");
INSERT INTO lip_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Itsyise útsyǝ diyi nǝ utidi wǝ úlǝkǝ utsyǝ luubǝ okponko bo lekpo itsyi lǝ bo ditsyǝbi ǝsuǝ ɛyɛ lǝ kɔtsyɔntsyɔsu ǝsuǝ Nya úlǝkǝ Nwǝ Onanto Lékpo Ɔhile Utsyǝ óte bo idu lǝ lefe ne ótakasǝ wǝ utsyiko ɔkɔmǝ ubǝ nya unsi nkpǝ.” ");
INSERT INTO lip_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Nya lefe nǝ bánɔ bǝ Paulo edi etiki itsyi lǝ botakaketsyi ɔkɔmǝ kǝ bǝ ǝsuǝǝ, mǝ nti eto bǝtsyuǝ ǝmǝ wǝ. Fɛɛ mǝ bǝtsyuǝ tsya ǝmǝ wǝ bátɛyi bǝnkǝ, “Bola boǝ busi boanɔ lesatsyuǝ itsyi lǝ utidi eto businkli kataka ketsyi ɔkɔmǝ ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Nyaso se íbǝ nko esoo, Paulo édu mǝ lǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Fɛɛ betidi bǝtsyuǝ ǝtǝkǝko wǝ nya bétsyi báwuninsǝ báfo bánɔ. Nya utsyuǝ uni ákɛ mǝ lenti wǝ díyifo Areopago eto uninǝ wǝ baakpo Dionisio ku usio wǝ baakpo Damari ku babamba bǝtsyuǝ tsya áfo bánɔ. ");
INSERT INTO lip_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Lǝ nnya kamaa, Paulo édu lǝ Atene úsu Korinto. ");
INSERT INTO lip_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Mfó úsu únyǝ Yudanyǝ wǝ baakpo Akwila, nwǝ bále lǝ Ponto. Wǝ ku wǝ usiǝ Priskila étsyi Italia bǝbǝ mfó yanklɛ tɔ, itsyise kasɔ kamǝ eto Okankplɛ wǝ baakpo Klaudo átɛyi nkǝ Yudafɔ kenke du lǝ Roma. Paulo ésu úsunyǝ mǝ, ");
INSERT INTO lip_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","nya úsiǝ lǝ mǝ ɔflɔ ɔnlɛ mǝ bɔwunsǝko lǝ kubukikue kanka eto keyifo ka woeyifo kedi ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Nya lǝ Ɔnwɛditsyǝyi saa, Paulo ékesu Yudafɔ eto katsyakɔ nya úkǝlǝkǝ asa kasɔ kate Yudafɔ ku Grikifɔ kenke itǝ lǝ bǝ lǝ batsyi mǝ akɔɛsi bawuninsǝ. ");
INSERT INTO lip_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Nya lefe nǝ Sila ku Timoteo dítsyi Makedonia bǝbǝǝ, Paulo ǝnyǝ lefe kpǝ úfi útǝ Ditiki Sɛɛ nǝmǝ bote ku ni kasɔlǝkǝlǝkǝ kate Yudafɔ bamǝ nkǝ Yesu ni Nwǝ Onanto Lékpo Ɔhile Utsyǝ tinti. ");
INSERT INTO lip_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Nya lǝ lefe nǝ Yudafɔ bamfó létaka bǝńyǝ lǝ wǝ ǝsuǝǝ, nya bésie wǝ abie lǝ Yesu eto disi esoo, Paulo áflɛ sitǝ lǝ wǝ ǝsuǝ, nya ɔ́tɛyi mǝ nkǝ, “Lǝ bikpǝ nye benyaa, nyǝ mɔ ani, nyǝ mɔ akpa minyi nnya kulesa saa. Idu mɔmɔ mfoo, ndu ntɔ lǝ betidi ba lenni Yudafɔ ɔflɔ lǝ nsu ntɛyi mǝ Ditiki Sɛɛ nǝmfo.” ");
INSERT INTO lip_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Nya se údu mfóo, úsu ɔ́kɛ lǝ osani utsyuǝ wǝ lenni Yudanyǝ wǝ baakpo Tito Yusto wǝ laate Onanto sikpi nya wǝ diyo nkpe lǝ Yudafɔ eto katsyakɔ ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Fɛɛ katsyakɔ kamǝ eto uninǝ wǝ baakpo Krispo ku wǝ diyo eto betidi kenke áfo Bonamute bánɔ, nya béyifo mǝ ntuflǝsǝflǝsǝ eto lekpa. Nko ke, béyifo ntuflǝsǝflǝsǝ eto lekpa bǝtǝ bafokanɔfɔ kpǝ bamba tsya lǝ Korinto mfó nɛ. ");
INSERT INTO lip_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Nya lǝ diyi lɔni eto ketsyee, Bonamute ǝtǝ Paulo ǝnyǝ kǝlǝkate ka ǝsuǝ ɔ́tɛyi wǝ nkǝ, “Mante sikpi! Nya mensinkli lǝ Ditiki Sɛɛ nǝmfo bɔtɛyi eto kama. ");
INSERT INTO lip_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Itsyise nsiko fǝ, nya kutsyuǝ saa ǝmbofo fǝ kabua buyifo. Betidi kpǝ kpe lǝ umǝ mfó ba ni mɔ bale.” ");
INSERT INTO lip_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Nyaso Paulo ǝsiǝ lǝ umǝ ǝmfo lɛlɛ lɔni ku kutsyǝ kedi Onanto eto Ditiki Sɛɛ nǝmfo kate betidi. ");
INSERT INTO lip_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Lǝ lefe nǝ bǝtsyǝ Galio fe Roma eto Aba eto unyɛsiǝ lǝ Akaia eto kasɔɔ, Yudafɔ bǝtsyuǝ ásɔ mǝ ǝsuǝ lebo nya báwoe etiki lǝ Paulo ǝsuǝ nya bǝmuǝ wǝ bésuko lekpokakpokɔ. ");
INSERT INTO lip_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Nya bátɛyi Aba eto unyɛsiǝ ǝmǝ nkǝ, “Utidi ǝmfo lɛ betidi eto nsusu bobiasǝ nkǝ basumu Onanto lǝ kusu ko nńyǝ lǝ bo afi ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Nya kase Paulo nkǝ lǝ ulǝkǝ kɛnyɛ lǝ udi etiki koo, Aba eto Unyɛsiǝ Galio ǝmfo ko dídi etiki ɔ́tɛyi Yudafɔ bamǝ nkǝ, “Mi Yudafɔ bɛnɔ! Lǝ bǝnkǝ etiki nnya bɛyɛnko béboko mfo eyifo etiki kekleke nnya léta kɔfi ibuu, nyalɛ mɔɔkɛ nnya lefe ntsyue mi etiki koto. ");
INSERT INTO lip_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Fɛɛ se iyifo kǝnǝ itsyi lǝ etiki ku aye ku mi afi eto asa ini esoo, mi kosate su bɛtɛyi nnya. Bǝntsyǝ mɛ okponkpo lǝ mi asa nyamfo ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Nyaso óla mǝ ɔ́bɔnko lǝ wǝ lekpokakpokɔ mfó. ");
INSERT INTO lip_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Nyaso betidi eto ditsyukpa nǝmfo ǝmuǝ Sostene wǝ ni mǝ katsyakɔ kamǝ eto ununǝ nya báblɛ wǝ lǝ lekpokpakpokɔ ɔflɔ mfo. Fɛɛ Galio mánkpe mǝ kɛnyɛ. ");
INSERT INTO lip_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paulo esi úsiǝ lǝ Korinto eto umǝ mfó éfo eyi kpǝ. Lǝ nnya kamaa, ókla bafokanɔfɔ bamfó nya wǝ ku Akwila ku Priskila léyila lekpo bésu Siria. Tsya fɛ úduu, Paulo ǝtǝ nkǝ bakpi wǝ disi lǝ Kenkrea itsyi lǝ ntamu bo óka utsyǝ eso. ");
INSERT INTO lip_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Se úsu údufǝ Efesoo, óyani Priskila ku Akwila útsyǝ mfo. Nya wǝ dídu úsu Yudafɔ eto katsyakɔ lǝ úsu ɔlɛ asa obe ku Yudafɔ ba nkpe mfo. ");
INSERT INTO lip_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Betidi álɛ wǝ lekpakpa bǝ lǝ ɔkɛ lǝ mǝ ɔflɔ sɛkɛ, fɛɛ wántɔnɔ. ");
INSERT INTO lip_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Lǝ nyaso se ɔnlɛ buluu, ɔ́tɛyi mǝ nkǝ, “Lǝ Onanto atɔnɔɔ, muusinkli mbǝ mi ɔflɔ.” Nya údufǝ lǝ ɔklɔ ǝsuǝ nya údu lǝ Efeso. ");
INSERT INTO lip_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Se úsu údufǝ lǝ Kaisareaa, ófe úsu Yerusalem nya úsu úsiǝsǝ bafokanɔfɔ mfo. Nya usi ófe úsu Antiokia. ");
INSERT INTO lip_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Se úsiǝ mfo sɛkɛɛ, usi údu ɔ́yɛ ɔbɔ lǝ Galatia ku Frigia. Nya lǝ lefe nǝmfó ǝsuǝǝ, ótsyilama mfó kenke óbe bafokanɔfɔ ba nkpe lǝ dikuku mfó, nya ókakpe mǝ nkɛale. ");
INSERT INTO lip_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Nya Yudanyǝ utsyuǝ díbǝ Efeso. Wǝ ni Apolo. Bále wǝ lǝ Aleksandria. Nya uyifo utidi wǝ nkpe kɛnyɛ laafo etiki budi, nya unyi Awɔnisa Kɛnkɛ eto kúkue eto etiki tsya. ");
INSERT INTO lip_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ekpe bǝ wɔ́ɔnɔ Bonamute eto diye ɔnɔ nya woedi etiki itsyi lǝ Yesu ǝsuǝ ku ute tsyaa, Yohanes eto ntu flǝsǝflǝsǝ eto etiki hã ete unyi. ");
INSERT INTO lip_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Nya se úńyǝ ɔnlɛ etiki budi ku wǝ utu ku ǝsuǝale lǝ Yudafɔ eto katsyakɔ mfó fɛ Priskila ku Akwila lɛnɔɔ, bákpa wǝ bésuko mǝ diyo bésu bǝlǝkǝ Boanto eto Ditiki Sɛɛ nǝmǝ kasɔ kukɔnɔ báte wǝ nya báte wǝ asa bawunsǝ. ");
INSERT INTO lip_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Nya se Apolo díbu disi nkǝ woesu Akaiaa, Efeso eto bafokanɔfɔ ésu báwunsǝko wǝ nya báwɔni kukue bátsyese bafokanɔfɔ lǝ Akaia mfó bǝ lǝ úbǝ mfóo, lǝ bafo wǝ kukɔnɔ. Se úsu údufǝ mfóo, ɔ́wunsǝko betidi kpǝ ba léfiani bafokanɔfɔ ɛyɛ lǝ Onanto eto lefonǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Nya óso Yudafɔ ani lǝ kase unǝ etiki ku ku ute lǝ betidi nti. Nya etiki nnya nkpe lǝ Awɔnisa Kɛnkɛ eto Kukue ǝsuǝǝ, úfi úlǝkǝ óte ékpa wuee bǝ Yesu ni Nwǝ Onanto Lékpo Ɔhile Utsyǝ. ");
INSERT INTO lip_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Lǝ lefe nǝ Apolo lɛkɛ lǝ Korintoo, Paulo tsya áyɛ lǝ akpa eto kusu nya úsu údufǝ lǝ Efeso. Mfo úsu únyǝ bafokanɔfɔ bǝtsyuǝ. ");
INSERT INTO lip_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Nya ɔ́tɔ mǝ nkǝ, “Idu lefe nǝ béfo bɛnɔɔ, bíofo Lɛwɔnɔ Kɛnkɛ?” Nya bátɛyi wǝ bǝnkǝ, “Owo lo! Be ni Lɛwɔnɔ Kɛnkɛ fɛ? Bóannɔ tɔ ni kulesa saa.” ");
INSERT INTO lip_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Nya usi ɔ́tɔ mǝ nkǝ, “Nyalɛ nte ntuflǝsǝflǝsǝ eto lekpa beyifo mi?” Nya bátɛyi wǝ bǝnkǝ, “Yohanes eto ntuflǝsǝflǝsǝ eto lekpa.” ");
INSERT INTO lip_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Nya Paulo dílǝkǝ kasɔ óte mǝ nkǝ, “Yohanes ǝflǝsǝ betidi ba ditsyi báwuninsǝ lǝ mǝ abua ǝsuǝ. Nya ɔ́tɛyi mǝ nkǝ ele bǝ bafo utidi wǝ luubǝ lǝ wǝ kama banɔ. Nya utidi ǝmfo ni Yesu.” ");
INSERT INTO lip_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Nya se bánɔ ditiki nǝmfoo, bátɔnɔ nya úflǝsǝ mǝ ntu lǝ Bonamute Yesu eto diye ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Nya se nǝ Paulo dífi ani útǝkǝ lǝ mǝ ǝsuǝǝ, Lɛwɔnɔ Kɛnkɛ ǝbǝ dísiǝ lǝ mǝmblɛ ǝsuǝ, nya bétsyiko bele bele bɔtɛyi nya bǝlǝkǝ Onanto eto ditiki kɛnyɛ báte. ");
INSERT INTO lip_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Nya basani bamǝ eto utu lídi fe lefosi inuǝ. ");
INSERT INTO lip_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Nya se Paulo dísu Yudafɔ eto katsyakɔɔ, údi mǝ etiki ku ute lǝ afa ǝtsyǝ ǝsuǝ, úlǝkǝ asa kasɔ óte mǝ ku kasɔnɔnɔ nya ókplatsya kekleke lǝ kase wookpa mǝ nsusu usuko Onanto eto Sekakedikɔ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Fɛɛ mǝ bǝtsyuǝ méntsyue wǝ ditiki sɛɛ nǝmǝ ato nya báni bofokanɔ, nya lǝ betidi eto ǝnǝmii, bédi etiki bua nnya dińyǝ lǝ Onanto eto kusu sɛ ǝsuǝ. Nyaso Paulo édu lǝ mǝ ɔflɔ nya ókpa bafokanɔfɔ ɔ́yɛnko nya bédu bésu Tirano eto suku eto diyo. Mfóo, nya ókatsyako mǝ diyi saa, kédufǝ lǝ etiki ǝsuǝ ku mǝ. ");
INSERT INTO lip_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Itǝ alɛ ǝnuǝ ǝsuǝǝ, ɔ́kɛ mfó óte mǝ asa. Nya Ditiki Sɛɛ nǝmfo dísensǝ ɛyɛ ísu Asia ku lekpake nǝmfó kenke. Nya mba ni Yudafɔ ku mba lenni Yudafɔ tsya lɛnɔ ditiki nǝmǝ. ");
INSERT INTO lip_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Nya Onanto dítǝ Paulo ǝsuǝale nnya úfi keyifo ayanisa. ");
INSERT INTO lip_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Nya lǝ béfi wǝ ofiamɛ nye wǝ ǝsuǝ eto awu bétidi ufimfi utsyuǝ lǝ ǝsuǝ koo, úkǝnyǝ bufitsyatsya, nya ékala awɔnɔ bua tysa kabɔnko lǝ betidi ba ǝsuǝ ɛkɛ. ");
INSERT INTO lip_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Nya Yudafɔ bǝtsyuǝ ba ni bafate ba laatsyilama idu kalebe isu kalebee, ébu bǝnkǝ boofo bɔyɛ lǝ Bonamute Yesu eto diye ǝsuǝ bala awɔnɔ bua lǝ betidi ǝsuǝ. Nya bátɛyi bǝnkǝ, “Nnla mi lǝ Yesu wǝ eto diye ǝsuǝ Paulo laayɛ kala mi mbɔsǝ lǝ utidi ǝmfo ǝsuǝ!” ");
INSERT INTO lip_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Nya betidi ba nlɛ nyamfó eto okle buyifo éyifo bakosobi ekuanse ba ni Yudanyǝ utsyuǝ wǝ ni Usumunyǝ Ninǝ wǝ baakpo Skefa eto bebi. ");
INSERT INTO lip_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Fɛɛ se bésu bǝ beedi lɛwɔnɔ bua ditsyuǝ etikii, lɛtɛyi mǝ nkǝ, “Mɔɔ nnyi Yesu, nya minyi Paulo tsya. Fɛɛ mimii, bawoe bini?” ");
INSERT INTO lip_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Nya utidi ǝmǝ ǝsuǝ lɛwɔnɔ bua nǝmfo nsii, lɛblɛ mǝ! Nya báfo afabe tinti, nya bétsyetsyi bábɔ lǝ diyo nǝmǝ leyaleya! ");
INSERT INTO lip_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Nnya díbǝ mfó ésensǝ efia Efeso kenke itǝ bǝ Yudafɔ ku mba lenni Yudafɔ kenke ánɔ nnya. Lǝ nyamfo esoo, sikpi ǝmuǝ mǝ tinti, nya Bonamute Yesu eto diye disi lebe kato lekpe. ");
INSERT INTO lip_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Nya mba lɛtsyi akɔɛsi báwuninsǝ eto bǝtsyuǝ kpǝ díbǝ bǝlǝkǝ mǝ asa bua nnya béyifo kasɔ lǝ betidi eto ǝnǝmi. ");
INSERT INTO lip_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Nya mba ni bafate lǝ mǝ nti dífi mǝ afa eto ekue ku kekue ku bɛbɛ báboko nya bátonsǝ nnya lǝ betidi eto ǝnǝmi mfó. Ekue ku asa nyamfo kenke eto koya ebuyifo fe sika flubia eto akpi fosi anɔ. ");
INSERT INTO lip_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Nyamfo lǝ bote kase Bonamute eto ditiki dísensǝ ku ǝsuǝale, nya éfo mfo kenke. ");
INSERT INTO lip_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Nyamfo eto kamaa, Lɛwɔnɔ Kɛnkɛ ǝlǝkǝ léte Paulo nkǝ ɔyɛ usu Makedonia ku Akaia lǝ usu Yerusalem. Nya Paulo lɛtɛyi nkǝ, “Lǝ ndufǝ mfóo, ele bǝ nyɛ nsu Roma tsya.” ");
INSERT INTO lip_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Nya ótsyese wǝ bawunsǝkotsyuǝ inuǝ, Timoteo ku Erasto nkǝ bákatɔ wǝ lǝ Makedonia lǝ ubǝ. Nya wǝ lɛtsyimɛ ɔkɛ kama lǝ Asia mfó itǝ lefe sɛkɛ. ");
INSERT INTO lip_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Nya lǝ lefe nǝmfóo, bulǝ kplɛ ǝbǝ lǝ Efeso itsyi lǝ kusu ko ǝsuǝ Kristo nkǝ bǝǝsiǝ nkpǝ eso. ");
INSERT INTO lip_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Nwǝ dínǝ bulǝ bomfo óboko ni utidi wǝ baakpo Demetrio wǝ ni ɔtsyuɛntsyuɛ wǝ leefi sika flubia katsyuɛ Artemi eto esumuyo kɛkɛ. Nya nnya bote kǝnǝ kutǝkǝ kpǝ kaboko wǝ ku wǝ bawunsǝkotsyuǝ. ");
INSERT INTO lip_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Diyi lɔnii, Demetrio ákpadi batsyuɛntsyuɛ ba kenke bátsya nya ɔ́tɛyi mǝ nkǝ, “Bayimi, biyi biǝ buǝnyǝ kutǝkǝ kpǝ ketsyi lǝ bo keyifo kamfo ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Nya bɛnlɛ bɔnɔ, kǝnyǝ sitinti kase Paulo ǝmfo nlɛ bo keyifo kamfo bobiasǝ kakpe bo kofani, nya ɔnlɛ betidi kpǝ eto nsusu bobiasǝ nkǝ befiǝ eto asa nnya boeyifo kenke menyifo lesa nǝ ele bǝ bakpe disi kasɔ bǝtǝ! Lǝ nyamfo eso bo bikǝtete ébubǝ kasɔ! Nya inni Efeso mfo mate ni kaka nyamfo nlɛ bubǝ. Bomu ɛlɛ bubǝ lǝ Asia eto kasɔ kenke! ");
INSERT INTO lip_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Nya inni bo mate eto keyifo ete lɔɔsɔɔ kasɔ! Sitintii, Boambe Ufiǝ Kplɛ Artemi eto diyo ku wǝ dibu ebonya lǝ Asia mfo ku lǝ kawunsiǝ kenke!” ");
INSERT INTO lip_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Se bánɔ Demetrio eto etiki nyamfoo, ɔblɔ éfi mǝ nya bényenki tinti nya báfã bembembe bátɛyi bǝnkǝ, “Efoso eto Ambe Artemi ni Ufiǝ Kplɛ Kenke!” ");
INSERT INTO lip_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Nya kudu ko bákpo dísensǝ kófo umǝ ǝmǝ kenke. Nyaso bátsya fe ditsyukpa nya bǝmuǝ Paulo eto bayɛtsyuǝ inuǝ bǝtsyuǝ ba baakpo Gaio ku Aristarko ba ditsyi Makedonia. Nya bákpa mǝ bésuko umǝ ǝmǝ eto katsyakɔ. ");
INSERT INTO lip_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Nya Paulo tsya léla nkǝ lǝ wontsya lǝ usu mfo, fɛɛ bafokanɔfɔ fɛfɛ mántɔnɔko wǝ nko. ");
INSERT INTO lip_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Nya lekpake nǝmfo eto beninǝ ba díyifo Paulo eto bayɛtsyuǝ tsyaa, léla ɔtɔnkpe bákpe wǝ bálɛ wǝ lekpakpa bǝnkǝ woensu mfó lǝ usu ufi wǝ ǝsuǝ okpe lǝ nnya ǝsuǝ kulaa! ");
INSERT INTO lip_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Nya lǝ lefe nǝmfó ǝsuǝǝ, diyo nǝmǝ kafo eyi ku kudu. Nya betidi ba díbǝ bátsya mfóo eto utsyuǝ saa ku wǝ lesa nǝ ɔnlɛ bɔtɛyi. Nya mǝ nti kpǝ mánte lesa nǝ eso bǝbǝ mfo. ");
INSERT INTO lip_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Nya Yudafɔ bǝtsyuǝ díkǝ Aleksandro bǝ usu unyǝ sɛtɔ lǝ okpasǝ lesa nǝ díbǝ. Nya Aleksandro lébesǝ ani kato nkǝ utsyuǝ saa yɛ kudu bokpo lǝ ɔtɛyi mǝ lesatsyuǝ. ");
INSERT INTO lip_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Nya se betidi bamfo dínyǝ bǝ Yudanyǝ unii, besi betsyiko kudu bokpo kafa bembembe itǝ fe abombosɔsɔ ǝnuǝ. Nya bátɛyi bǝnkǝ, “Efoso eto Ambe Artemi ni Ufiǝ Kplɛ Kenke!” ");
INSERT INTO lip_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Efo lefe fɛ Aba eto unyɛsiǝ ninǝ wǝ nkpe mfo léfo mǝ bɔkɔnsǝ, nya údi etiki ɔ́tɛyi mǝ nkǝ, “Mɔ bayimi, Efesofɔ, utsyuǝ saa lǝ mi nti yi nkǝ Efeso mfo ni Ufiǝ Kplɛ Artemi eto kǝsiǝkɔ. Nya wǝ kakpakɔ eto leba kɛnkɛɛ, áfankli ditsyi kato díbǝ kasɔ, nya lenkpe lǝ bo nti. ");
INSERT INTO lip_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Nya kutsyuǝ saa ǝmbǝ loofo ditiki nǝmfo sidia butǝkǝ. Nyaso biyuǝsǝ mi akɔɛsi nya bieyifo kulesa saa lǝ lɛblɔfi ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Itsyise betidi ba bímuǝ békpa béboko mfoo, bényu kulesa betsyiko lǝ Disumuyo nye babiasǝ bo Ufiǝ Artemi eto diye tsya. ");
INSERT INTO lip_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Fɛɛ lǝ Demetrio ku wǝ batsyuɛntsyuɛ ǝnyǝ bǝ bakpe ditiki ditsyuǝ lǝ utsyuǝ ǝsuǝǝ, bakponkpo kpe mfo. Nya bonkpe eyi nnya ǝsuǝ baakpo akpo. Lǝ béyifo kabua kǝtsyuǝ, boofo ke bulǝkǝ kate mǝ mfó. ");
INSERT INTO lip_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Fɛɛ lǝ lesa bamba ditsyuǝ kpe bela biǝ biefi bisukoo, bitǝ lǝ bufi busuko umǝ eto beninǝ ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Itsyise nyamfo lɛ bote fenkǝ bɔlɛ botaka kǝńyǝ lǝ Aba ǝsuǝ. Lǝ Romafɔ eto bamamanyǝ ǝbǝ bǝnyǝ mmi eto diyi nǝmfo eto asayifoyifoo, boǝmbofo kɛnyɛ bulǝkǝ, nya buunǝ bo koto.” ");
INSERT INTO lip_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Nya se ɔ́tɛyi etiki nyamfo nkoo, útǝ bésensǝ bédu. ");
INSERT INTO lip_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Lefe nǝ bulǝ bomǝ díyuǝ kɛnyɛɛ, Paulo ákpadi bafokanɔfɔ bǝbǝ bátsya lǝ kalebe kani. Nya se ókpe mǝ nkɛale lǝ mǝ bofokanɔ ǝsuǝ ólosǝǝ, ókla mǝ fɛ údu úsu Makedonia. ");
INSERT INTO lip_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Se údu ɔntɔɔ, Paulo áyɛ lǝ kǝmǝ ka nkpe lǝ lekpake nǝmfó kenke nya údi mǝ etiki kpǝ úfi ókpe mǝ nkɛale fɛ úsu údufǝ Akaia. ");
INSERT INTO lip_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Úsiǝ mfó fe afa ǝtsyǝ. Lefe nǝ ɔnlɛ ǝsuǝ bumuǝ nkǝ lǝ usu Siria, únyǝ útsyǝ lekpo nkǝ Yudafɔ ba nkpe mfó lǝ wǝ ukpǝ eto esu bɔbɛbɛ. Nyaso úfi nsusu bio nkǝ wesinkli usu ɔyɛ Makedonia. ");
INSERT INTO lip_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Lefe nǝ ɔnlɛ buduu, betidi kpǝ ǝtǝkǝnko wǝ. Betidi bamǝ ni Sopater wǝ dítsyi Beroia wǝ ni Piro eto ubi ku Aristarko ku Sekundo ba ditsyi Tesalonika ku Gaio wǝ dítsyi Derbe ku Tihiko ku Trofimo ba ditsyi Asia eto lekpake ku Timoteo. ");
INSERT INTO lip_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Mba mfo átɔ̃ bo bǝ beesu bǝńyǝ bǝsǝkǝ bo lǝ umǝ wǝ baakpo Troa. ");
INSERT INTO lip_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Nya lǝ Yudafɔ eto Nnamfokuã Eto Abolo Eto Eyididi eto kamaa, búfi ɔklɔ nya búdu lǝ Filipi, nya búsu bútu mǝ lǝ Troa lǝ eyi anɔ eto kama. Nya búsiǝ mfó éfo eyi akuanse. ");
INSERT INTO lip_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Nya lǝ Kɔsida eto diyi tutɛɛ, bótsya lǝ kalebe kani boǝ lǝ budi Bonamute eto didisa lǝ bǝtsyuǝ. Nya se Paulo lǝǝbǝ budu kǝsiǝsǝ esoo, údi etiki ikulǝ isu taa ntsyenti. ");
INSERT INTO lip_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Nya báto kakadiɛ kpǝ bǝtsyǝ lǝ abanslo eto diyo nǝ ǝsuǝ bótsya mfó. ");
INSERT INTO lip_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Nya se Paulo eto etiki nlɛ bukulǝ esoo, selabe éfi okosobi wǝ baakpo Eutiko lǝ lefe nǝ unsi lǝ diyo nǝmǝ eto mfɛnsle ǝsuǝ. Ófankli utsyi lǝ abanslo eto botokǝtǝkǝ tsyǝfǝ mfó úbǝ ɔ́sɔ lǝ kasɔ. Nya se bésu bétsyi wǝǝ, bǝnyǝ bǝ úkpǝ. ");
INSERT INTO lip_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Fɛɛ Paulo áyifǝ úsu kasɔɔ, úsu dikpefi nǝmǝ ɔflɔ nya úbǝ kasɔ ɔ́buta ni nya útsyi ni óboko wǝ akɔ nya ɔ́tɛyi mǝ nkǝ, “Biankpo kudu! Okpe nkpǝ!” ");
INSERT INTO lip_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Nya mǝmblɛ dísinkli bésu kato mfó bésu bédi Bonamute eto lesa nǝmǝ. Lǝ nnya kama Paulo esi úsiǝ údi etiki isu ese kalesiǝsiǝ fɛ údu. ");
INSERT INTO lip_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Nya se bákpa okosobi ǝmǝ ku nkpǝ besuko diyoo, ǝsuǝ ǝyuǝ mǝ tinti. ");
INSERT INTO lip_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Nya Paulo dífi akpa eto kusu úsu Aso. Fɛɛ lǝ kase útsyue ǝsuǝǝ, bo éfi ɔklɔ bɔ́tɔ wǝ sɛtɔ bǝ lǝ busu butsyi wǝ lǝ mfó. ");
INSERT INTO lip_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Nyaso se úbǝ útu bo lǝ Aso mfóo, údufǝ lǝ ɔklɔ ǝmǝ ǝsuǝ nya bonko wǝ kenke lídu búsu Mitilene. ");
INSERT INTO lip_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Búdu lǝ mfó nya lǝ kǝsiǝsǝǝ, búsu bóyo Kio. Nya lǝ diyi nǝmfo eto kǝsiǝsǝ tsyaa, bóyo Samo.Lǝ diyi tsyǝfǝ ǝsuǝǝ, búsu búdufǝ Mileto. ");
INSERT INTO lip_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paulo mánla nkǝ bobiasǝ lefe kpǝ lǝ Asia mfó nyaso útǝ bókpia Efeso bófe, itsyise ɔlɛ bɔkɔse. Nya utsyue nkǝ lǝ woofoo, ele bǝ udufǝ Yerusalem lǝ Pentekoste eto diyi ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Nya se búsu búdufǝ Miletoo, ókpe batɔnkpe lǝ Efesofɔ eto bafokanɔfɔ eto beninǝ ɔflɔ nkǝ bǝbǝ bǝnyǝ wǝ mfó. ");
INSERT INTO lip_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Nya se bǝbǝǝ, ɔ́tɛyi mǝ nkǝ, “Bayimi, mimblɛ ta yi kase minkɛ lǝ mi le nti lefe nǝ kenke minkɛ mfo ǝsuǝ, idu lǝ diyi tutɛ nǝ mímbǝ míndufǝ lǝ Asia eto kasɔ mfo ibǝ ǝsǝ mɔmɔ. ");
INSERT INTO lip_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Binyǝ kase mímbokosǝ ǝsuǝ kasɔ míntǝ Bonamute, lǝ kanyi ku binǝntu ǝsuǝ ɛyɛ lǝ Yudafɔ eto kase bála bǝ balo mɛ eso. ");
INSERT INTO lip_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Bɛlɛ ola bebe mɛ. Minni futsyǝ nkpe disiale. Bonamute eto asa nnya minyi lǝ wǝ ǝsuǝǝ, nnya ni lesa nǝ mínte mi nɛ, nya mémfi kulesa nkula mi. Nte Bonamute eto Ditiki Sɛɛ nǝmǝ lǝ betidi nti ku lǝ mi ayo. ");
INSERT INTO lip_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Nya kalebe saa mínsuu, ntɛyi Yudafɔ ku mba lenni Yudafɔ kekleke minkǝ bayɛ asa bua buyifo lǝ batsyi bawuninsǝ befi mǝ ǝsuǝ bǝtǝ Onanto, lǝ bafo Bonamute Yesu banɔ. ");
INSERT INTO lip_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Nya mɔmɔɔ, Lɛwɔnɔ Kɛnkɛ lɛ mǝ bɔtɛyi nkǝ nsu Yerusalem, nya minnyi lesa nǝ lǝbǝ mɛ busu ketu mfó. ");
INSERT INTO lip_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Fɛɛ lǝ kǝmǝ ka kenke mínyɛ mínfee, nyi miǝ Lɛwɔnɔ Kɛnkɛ ǝlǝkǝ óte mɛ nkǝ moolabee diyo nyǝ kanyi. ");
INSERT INTO lip_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Fɛɛ meenfi mɔ nkpǝ fe lesa nǝ lefe itǝ mɛ. Lesa nǝ lefe itǝ mɛ ni bǝ nlosǝ keyifo ka Bonamute Yesu lékpe mɛ kɔni nkǝ nyifo. Nya keyifo ka ókpe kɔni nkǝ nsu nyifo ni bǝ ntɛyi betidi Ditiki Sɛɛ nǝmǝ itsyi lǝ Onanto eto lefonǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Nyasoo, nyi miǝ mimba kenke lɛnɔ mɔ asatete itsyi lǝ Onanto eto sekakedikɔ ǝsuǝǝ, ensie embotsya ku mɛ bio. ");
INSERT INTO lip_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Nyaso mmii, mǝǝtǝ mi bote minkǝ lǝ utsyuǝ áyansǝ wǝ nkpǝ eto kusuu, beembufi utidi ǝmfo eto kabua balo mɛ dikpi. ");
INSERT INTO lip_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Sitintii, mémfi Onanto eto sekakedikɔ eto kusu eto asa nkula mi. ");
INSERT INTO lip_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Lǝ nnya esoo, bebe mi ǝsuǝ kukɔnɔ. Lɛwɔnɔ Kɛnkɛ díyifo mi mba ni batɔnkotɔnko bǝ lǝ bɛlɛ wǝ bebi ba Onanto dífi útǝ mi nkǝ bɛlɛ mǝ ola. Bɛlɛ mǝ kukɔnɔ, itsyise Onanto eto ubi dífi wǝ kɔtɔ ókpo kasɔ lǝ mǝ disi úfi úlǝkǝ mǝ utsyiko lǝ mǝ abua ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Nnya minyi ekpa ko mǝ ni bǝnkǝ lǝ nyani mi ntsyǝǝ, betidi ebubǝ bataka bǝńyǝ bakpɔ mi bǝlǝ mi nya boosensǝ mi fe kase bekiti laakpɔ ku basamu kesensǝ mǝ. ");
INSERT INTO lip_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Nya lǝ mi nti kulaa tsyaa, mi bǝtsyuǝ ébusinkli lǝ Ditiki Sɛɛ nǝmǝ kama bawɛ mi, bákpa betidi kpǝ báyɛnko lǝ mǝ kosate eto bidiabidia eto asatete ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Bitǝkǝ ǝnǝ bikabe lǝ bekloma kase mínkplatsya ku binǝntu lǝ mi disi nya mínte mi asa ketsye ku kakɔmi itǝ alɛ ǝtsyǝ nnya minkɛ mi lenti ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Nya mɔmɔ mfoo, mfi mi nkpe lǝ Onanto eto ani bǝ lǝ ose mi. Lǝ wǝ ditiki nǝ laawunsǝko betidii lǝ lekpe mi nkɛale lǝ bofokanɔ ǝsuǝ bo luutǝ biunyǝ kedikɔ lǝ Onanto eto, fe mba úlǝkǝ ókpo atsyɔ utsyǝ itǝ wǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Mánsɛsǝ ǝnǝmi lǝ kuutsyuǝ saa eto sika sia nye sika flubia nye bikǝlɛlɛ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Mi kosate yi biǝnkǝ mɔ ani nyamfo mímfi mínyifo keyifo fɛ minlɛ budi nya mimfi minlɛ betidi ba lǝǝtǝkǝko mɛ bobe. ");
INSERT INTO lip_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Nyifo nyamfo kenke lǝ mfi nte mi kase ele bǝ bukawunsǝ ko bakombo, nya lǝ bekloma ditiki nǝ Bonamute Yesu lɛtɛyi nkǝ, ‘Asa butǝ ǝtǝ disuǝyuǝ enso bofo.’ ” ");
INSERT INTO lip_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Nya lefe nǝ Paulo dídi etiki nyamfo ólosǝǝ, óse akonki nya wǝ ku mǝ léto ola. ");
INSERT INTO lip_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Nya mǝmblɛ lɛkɔbǝ wǝ bálɛ nya béwi nku itsyise balɛ budu lǝ bǝtsyuǝ ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Nya nnya kulaa leso mǝ nkuɛnlo bokpe ni nnya ɔ́tɛyi mǝ nkǝ bensiebunyǝ wǝ bio eso. Nya bákpa wǝ bésu bǝtsyǝ kusu lǝ ɔklɔ ǝmǝ ɔflɔ lǝ lekpo kɛnyɛ mfó. ");
INSERT INTO lip_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Nya se bǝtsyǝ bo kusu bálosǝǝ, búsu búdufǝ lǝ ɔklɔ ǝmǝ nya bɔ́yila búsu Kos. Se kale dísiǝǝ, búsu búdufǝ Rodo nya búdu mfo búsu Patara. ");
INSERT INTO lip_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Mfo nya búfi ɔklɔ wǝ ntɔ lǝ Foinike, nya búdu. ");
INSERT INTO lip_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Se bɔ́ntɔɔ, búnyǝ Kipro eto kasɔ, nya bɔ́yɛ boofe mfo nya búdu bɔ́yɛ ukúe eto lekpake búsu búdufǝ Tiro lǝ Siria eto kasɔ. Nya búsu kaka boolǝkǝ bikǝ bia nkpe lǝ ɔklɔ ǝmǝ kafo. ");
INSERT INTO lip_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Se bɔ́yifǝ búsu umǝǝ, búnyǝ bafokanɔfɔ ba nkpe mfó. Búsiǝ lǝ mǝ ɔflɔ eyi akuanse, itsyise Lɛwɔnɔ Kɛnkɛ díkǝlǝkǝ óte bafokanɔfɔ bamfo lesa nǝ luubǝ lǝ Paulo ǝsuǝ, nyaso bálɛ Paulo lekpakpa bǝ woensu Yerusalem lefe nǝmfó. ");
INSERT INTO lip_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Fɛɛ se lefe nǝ ele bǝ budu lǝ mǝ ɔflɔ léyoo, bafokanɔfɔ mfó ku mǝ besio ku bebi kenke ákpa bo esu bétsyǝ kusu lǝ lekpo kɛnyɛ, nya bomblɛ lése akonki bóto ola. ");
INSERT INTO lip_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Nya bútsyǝ bǝtsyuǝ esu fɛ búdufǝ lǝ ɔklɔ ǝmǝ kafo, nya mǝǝ tsya dísinkli bésu mǝ ayo. ");
INSERT INTO lip_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Se búdu lǝ Tiroo, búnyǝ lǝ Ptolemai. Mfo búsu búsiǝsǝ bafokanɔfɔ ba nkpe mfo, nya búsiǝ lǝ mǝ ɔflɔ diyi lɔni. ");
INSERT INTO lip_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Nya se kale dísiǝǝ, búdu mfó búsu Kaisarea. Búsu bɔsɔnɔ Ditiki Sɛɛ eto otsyabe Filipo. Uyifo bawunsǝkotsyuǝ ekuanse ba bǝlǝkǝ lǝ Yerusalem eto ɔni. ");
INSERT INTO lip_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Ɔkɛ bebisiobi ena ba lensi tɔ bǝsǝ. Beyifo Onanto eto bǝnyɛlǝkǝtidi. ");
INSERT INTO lip_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Nya búsiǝ mfó eyi ǝtsyuǝ. Lǝ lefe nǝ bɔkɛ mfóo, Onanto eto unyɛlǝkǝtidi utsyuǝ wǝ baakpo Agabo étsyi Yudea úbǝ mfó. ");
INSERT INTO lip_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Nya se úbǝ bo ɔflɔɔ, ónyankli abɔsu nya Paulo lékle lǝ nkɛ nya úfi óklǝ wǝ kosate eto ani ku akpa nya ɔ́tɛyi nkǝ, “Lɛwɔnɔ Kɛnkɛ lɛ bɔtɛyi nkǝ, ‘Nko ke Yudafɔ lookle abɔsu nyamfo eto osate lǝ Yerusalem nya boofi wǝ besu bakpe lǝ mba lenni Yudafɔ eto beninǝ eto ani nɛ.’ ” ");
INSERT INTO lip_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Nya se bɔ́nɔ etiki nyamfóo, bo ku betidi ba nkpe mfó kenke álɛ Paulo lekpakpa boǝ wensu Yerusalem. ");
INSERT INTO lip_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Mfó nya ɔ́tɛyi bo nkǝ, “Beso bǝǝnlɛ nku buwi nya bɛnlɛ mɛ ani bolo mǝ? Ntɔnɔ miǝ bakle mɛ lǝ Yerusalem, lǝ nsu nkpǝ lǝ Bonamute Yesu eso.” ");
INSERT INTO lip_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Nyaso lefe nǝ búnyǝ boǝ boǝmbofo wǝ nsusu bɔtsyi kawuninsǝǝ, bóyani wǝ nya bɔ́tɛyi wǝ boǝnkǝ, “Bonamute Yesu eto lelabi bǝ itǝ.” ");
INSERT INTO lip_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Lǝ eyi nyamfo eto kamaa, bomblɛ ǝmuǝ bikǝ nya búdu búsu Yerusalem. ");
INSERT INTO lip_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Nya Kaisarea eto bafokanɔfɔ eto bǝtsyuǝ tsya dítǝnko bo. Bákpa bo besuko Kipro eto uninǝ wǝ baakpo Mnason bǝ lǝ búsu bɔsɔnɔ wǝ ɔflɔ mfó. Uninǝ ǝmfo eyifo ofokanɔnyǝ koko. ");
INSERT INTO lip_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Nya se búdufǝ Yerusalem bafokanɔfɔ nkpe mfó áfo bo kukɔnɔ tinti. ");
INSERT INTO lip_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Se kale dísiǝǝ, Paulo ákpa bo nya búsu búnyǝ Yakobo ku Yerusalem eto bafokanɔfɔ eto beninǝ. ");
INSERT INTO lip_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Nya se búsiǝsǝ mǝ bólosǝǝ, Paulo átɛyi mǝ asa nnya kenke Onanto lɛyɛ lǝ wǝ ǝsuǝ úyifo lǝ betidi ba lenni Yudafɔ nti. ");
INSERT INTO lip_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Se bétsyue wǝ ato balosǝǝ, mǝmblɛ kenke átɛsǝ Onanto. Nya bátɛyi wǝ bǝnkǝ, “Ɔyimi lala, ǝnyǝ kase Yudafɔ akpi akpi kpǝ díkafo bánɔ nya banlɛ Moses eto afi lǝ kɔni kekleke. ");
INSERT INTO lip_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Bǝtsyuǝ átɛyi mǝ bǝnkǝ fǝ lɛtɛyi Yudafɔ ba nkpe lǝ nlebe nlebe fǝ bensidi Moses eto afi ku bo akpayifoyifo, nya fátɛyi tsya fǝnkǝ mba ni Yudafɔ tsya mensila mǝ bebi alo. ");
INSERT INTO lip_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Lǝ nyamfo eso be ele bǝ buyifo mɔmɔ? Buyi boǝ bǝǝbǝ esu bɔbɛbɛ kǝbǝ. Itsyise bɔɔnɔ bǝ ǝbǝ ákpe lǝ bo ɔflɔ mfo.” ");
INSERT INTO lip_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Nya bǝtǝ wǝ nsusu bǝnkǝ, “Bokpe betidi ena bǝtsyuǝ lǝ bo mfo, ba díkaka ntamu. ");
INSERT INTO lip_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Yɛnko mǝ esuko Yudafɔ eto Disumuyo mfó nya lǝ fǝ nku lǝ bɛkpi mi esi nya lǝ awunsǝko mǝ lǝ bafo mǝ disikpinkpi eto kayo. Nyamfo luutǝ utidi saa nyǝ nkǝ sidia bátɛyi lǝ fǝ ǝsuǝ, nyaso fintsya lɛ Moses eto kɔfi budi lǝ kɔni. ");
INSERT INTO lip_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Nya bafokanɔfɔ ba lenni Yudafɔɔ, bɔ́ɔwɔni ekue bútǝ mǝ bɔ́tɛyi mǝ boǝ, bayɛ̀ edisa nnya béfi bǝtǝ bǝfiǝ kedi ku kɔtɔ ku bebuki ba baawaninsǝ simuǝ kaalo eto sinǝ eto budi, lǝ bayɛ sɛsɔnɔ budi.” ");
INSERT INTO lip_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Nyaso se kale disiǝǝ, Paulo ákpa basani bamǝ nya bésu béyifo disikpinkpi eto lekpa nǝmǝ. Nyamfo eto kamaa, úsu Yudafɔ eto Disumuyo úsu útǝ besumunyǝ bote eyi nnya kama fɛ disikpinkpi eto lekpa nǝmǝ loolo itǝ lǝ befi kedi eto bikǝ baboko lǝ beyifo keditǝtǝ eto lekpa lǝ mǝ disi. ");
INSERT INTO lip_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Nya se íbu sɛkɛ lǝ eyi akuanse nyamǝ lǝ eyoo, Yudafɔ bǝtsyuǝ étsyi Asia eti bǝbǝ bǝnyǝ Paulo lǝ Yudafɔ eto Disumuyo mfo. Nyaso bákpadi betidi bǝtsyuǝ básɔ lebo nya bǝmuǝ wǝ. ");
INSERT INTO lip_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Nya bǝńyǝ mfó banlɛ kudu bokpo bǝnkǝ, “Israel eto basani, bɛwunsǝko bo! Osani ǝmfo ni nwǝ nlɛ botsyilama kate betidi kenke lǝ nlebe nlebe asa nnya ńyǝ lǝ bo betidi ku afi ku Disumuyo nǝmfo ǝsuǝ. Nya kama tsyaa, woakpa mba lenni Yudafɔ kedufǝnko Disumuyo nnya nlɛ bote nkǝ bákpe bo Yudafɔ eto kakɛnkɛkɔ kamfo kɔfiɔ!” ");
INSERT INTO lip_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Bátɛyi nko itsyise lefe nǝ lefe mǝǝ, bǝnyǝ bǝ Paulo ku Trofimo wǝ ni Efesonyǝ balɛ bɔyɛ kafe lǝ Yerusalem. Lǝ nyaso béfi nsusu bǝ ókpa wǝ úsuko Yudafɔ eto Disumuyo mfó. ");
INSERT INTO lip_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Nyaso se banlɛ kudu bokpo nkoo, étakasǝ betidi kenke lǝ umǝ ǝmǝ nya bátaka ku kudu nya bétsyetsyi bésu bátsya lǝ kusumukɔ mfó. Bǝtsyuǝ ǝnǝ Paulo babɔnko lǝ Disumuyo nya béti biku kenke. ");
INSERT INTO lip_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Nya lefe nǝ bála bǝ lǝ balo wǝǝ, Romafɔ eto bamamanyǝ eto ɔtɔnkotɔnko kplɛ ánɔ nkǝ Yerusalemfɔ kenke átaka bǝńyǝ balɛ bulǝ bokpe. ");
INSERT INTO lip_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Lamfolamfo, ókpa bamamanyǝ ninǝ ku bamamanyǝ bǝtsyuǝ ɔ́yɛnko nya bésu kaka banlɛ bulǝ bokpe mfó. Nya se mba ntɔnko mba nlɛ bulǝ bokpe dínyǝ bamamanyǝ bamfóo, báyɛ Paulo bɔblɛ. ");
INSERT INTO lip_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Mfó nya ɔtɔnkotɔnko kplɛ ǝmǝ dítǝ kusu nkǝ bǝmuǝ Paulo nya béfi amana ǝnuǝ bákpe wǝ. Nya fɛ ɔ́tɔ ɔ́nɔ utsyǝ eto okle utidi ǝmfo ni ku lesa nǝ úyifo. ");
INSERT INTO lip_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Nya betidi bamfó eto utsyuǝ saa eto lesa nǝ ɔ́tɛyi lɛbɔ lete. Nya se bamamanyǝ eto ɔtɔnkotɔnko ǝmfo mámfo ditiki saa nǝ banlɛ bɔtɛyi kasɔ bɔnɔ itsyi lǝ kudu ko betidi bamǝ nlɛ bokpo esoo, ɔ́tɛyi nkǝ bakpa Paulo besu beti bakpe lǝ bamamanyǝ eto diyo. ");
INSERT INTO lip_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","36","Nya lefe nǝ báyo kesiee, ibǝ bǝ ele bǝ bamamanyǝ bamǝ tsyi Paulo ku mǝ ani babesǝ kato itsyi lǝ lɛblɔfi kekleke nǝ sitiditu siamǝ dífi lǝ Paulo ǝsuǝ eso. Nya bǝtǝkǝko mǝ ku kudu bembembe ku etiki bǝnkǝ, “Belo wǝ!” ");
INSERT INTO lip_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Nya lǝ lefe nǝ baala bǝ befi wǝ besu beti bakpe lǝ diyoo, Paulo átɛyi bamamanyǝ eto ɔtɔnkotɔnko kplɛ nkǝ, “Ǝǝntǝ mɛ kusu lǝ ndinko fǝ etiki sɛkɛɛ?” Nya bamamanyǝ eto uninǝ ǝmǝ lɛtɔ wǝ nkǝ, “Bee! Aanɔ Sigriki fɛ?” ");
INSERT INTO lip_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Nya usi ɔ́tɔ wǝ nkǝ, “Inni fǝ ni Egiptenyǝ wǝ lékpa bewudifɔ akpi ana ba létaka bǝńyǝ lǝ Aba ǝsuǝ lefe nǝ léfe mǝ lǝ mfóo, nya bétsyetsyi bédu bésu mfiminti kafo?” ");
INSERT INTO lip_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Nya Paulo dílǝkǝ kɛnyɛ nkǝ, “Yudanyǝ mini. Bále mɛ lǝ Tarso lǝ Kilikia eto kasɔ. Nya umǝ ǝmfóo, enni umǝ kɛkɛ. Lǝ nyasoo, lekpakpa tǝ kusu lǝ ndi ko betidi bamfo etiki.” ");
INSERT INTO lip_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Nyaso uninǝ ǝmfo átɔnɔ útǝ Paulo kusu nkǝ udinko mǝ etiki. Nya Paulo lɛbɔ úbǝ úńyǝ lǝ kesie eto atalakpoe mfo nya óbesǝ ani kato nya ɔ́tɛyi mǝ nkǝ bedi kã. Nya se bédi kãã, údi mǝ etiki lǝ Yudafɔ eto sele ǝsuǝ nkǝ, ");
INSERT INTO lip_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Boantomǝ ku bayimi ba letsya mfo, nlɛ mi taflatsyɛ boto! Bitǝ kusu lǝ nkpasǝ mi etiki nyamfo lǝ bɛnɔ.” ");
INSERT INTO lip_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Nya lefe nǝ bánɔ bǝ Yudafɔ eto sele ɔnlɛ budii, bésinkli báyɛ kudu bokpo, betsyue wǝ ato. Nya Paulo lɛtɛyi mǝ nkǝ, ");
INSERT INTO lip_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Yudanyǝ mini, nya bále mɛ lǝ Tarso lǝ Kilikia eto kasɔ. Fɛɛ Yerusalem mfo mínsu suku. Gamaliel léte mɛ asa. Báte mɛ boantomǝ eto afi ku mǝ akpa kenke. Nya mímfi mɔ lɛkɔɛsi kenke míntǝ Onanto fe kase mi tsya nlɛ buyifo mmi. ");
INSERT INTO lip_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Nya idu lǝ lefe nǝmfóo, ntsyǝ kasɔ ku bafokanɔfɔ lǝ kusu fɔfɔ komfo ǝsuǝ butǝkǝko, nya mínla miǝ balo mǝ. Nyaso ḿmuǝ basani ku besio nkpe lǝ Aba eto diyo. ");
INSERT INTO lip_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Usumunyǝ Ninǝ Kenke ku katsyakɔ kamǝ eto uninǝ saa ebudi nya minlɛ bɔtɛyi mfo eto adansiɛ, itsyise mǝ díkawɔni ekue kǝtǝ mɛ bǝ nsunkeyifo asa nyamfo. Nya lefe nǝ míntɔ lǝ Damaskoo, bǝtǝ mɛ ǝsuǝale bǝnkǝ nnyǝ bafokanɔfɔ ba nkpe mfóo, lǝ mmuǝ mǝ, lǝ nkle mǝ mfi mboko Yerusalem bǝ lǝ bǝnǝ mǝ koto. ");
INSERT INTO lip_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Lǝ lefe nǝ mínyɛ míntɔ ibu sɛkɛ lǝ ndufǝ Damaskoo, iyifo fe kakɔmi eto lefosi abombo ǝnuǝǝ, lamfolamfo diyǝnde kekleke ditsyuǝ dítsyi kato díbǝ lékpo mɛ lǝ ǝsuǝ! ");
INSERT INTO lip_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Nya míndu mínɔ mínkpo lǝ kasɔ nya mínɔ se ɔkɔɛ utsyuǝ nlɛ etiki budi kátɛyi mɛ nkǝ, ‘Saulo, Saulo, beso fǝńyǝ mɛ lǝ ǝsuǝ mmǝ?’ ");
INSERT INTO lip_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","“Nya míntɔ mínkǝ, ‘Bonamute, owoe feni?’ “Nya usi údi mɛ etiki nkǝ, ‘Mɔ ni Yesu Nasaretnyǝ.’ ");
INSERT INTO lip_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Nya betidi ba ku mɛ nyɛɛ, ǝnyǝ diyǝnde nǝmfo. Fɛɛ bánnɔ utsyǝ wǝ nlɛ etiki budinko mfo eto ɔkɔɛ. ");
INSERT INTO lip_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","“Nya míntɔ wǝ minkǝ, ‘Bonamute, be ele bǝ nyifo?’ “Nya usi ɔ́tɛyi mɛ nkǝ, ‘Taka, lǝ esu Damasko. Mfó moote fǝ lesa nǝ mínlǝkǝ fǝ miǝ lǝ eyifo.’ ");
INSERT INTO lip_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Diyǝnde kplɛ nǝmfo ába mɛ ǝnǝmi itǝ bǝ betidi ba bonko mǝ nyɛɛ, lɛkɔbe mɛ lǝ kɔni bálɛ fɛ búsu búdufǝ Damasko. ");
INSERT INTO lip_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Nya, osani utsyuǝ akɛ mfó wǝ baakpo Ananias. Uyifo utidi wǝ leebu Onanto tinti, nya woayɛ lǝ bo afi ǝsuǝ tsya. Nya Yudafɔ ba nkpe mfó kenke leebu wǝ tinti. ");
INSERT INTO lip_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Utidi ǝmfo ǝbǝ úńyǝ mɛ lǝ ɔflɔ nya ɔ́tɛyi mɛ nkǝ, ‘Ɔyimisani Saulo, sinkli ǝnyǝ asa!’ Lǝ nya koo, mɔ ǝnǝmi lékpa kɛ, nya mínyǝ wǝ! ");
INSERT INTO lip_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","“Nya ɔ́tɛyi mɛ nkǝ, ‘Bo bana eto Onanto ni futsyǝ dílǝkǝ fǝ nkǝ laate wǝ lelabi, nya lǝ ǝnyǝ wǝ Ubi Kɛnkɛ lǝ ate wǝ tsya, lǝ anɔ wǝ etiki itsyi lǝ wǝ kɛnyɛ. ");
INSERT INTO lip_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Ele bǝ fi nkomǝ eto ditiki nǝmfo esuko kalebe saa fe odansiɛ esu atɛyi betidi kenke lesa nǝ fǝnyǝ nya fanɔ tsya. ");
INSERT INTO lip_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Nya mɔmɔɔ, kulesa mensi bu. Taka ǝńyǝ, lǝ afo ntuflǝsǝflǝsǝ eto lekpa. Lǝ akpadi wǝ diye, lǝ uflǝ fǝ abua uwi.’ ");
INSERT INTO lip_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Nyamfo eto kamaa, nsinkli nsu Yerusalem. Nya lefe nǝ mínsu Disumuyo minlɛ ola botoo, íyifo mɛ fe selabe minlɛ, nya mínyǝ bulǝkǝkate butsyuǝ. ");
INSERT INTO lip_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Mfó nya Bonamute kosate lɛtɛyi mɛ nkǝ, ‘Kɔse lǝ edu lǝ Yerusalem, itsyise betidi ba nkpe mfo embutsyue fǝ ditiki nǝ fɔɔtɛyi itsyi lǝ mɛ ǝsuǝ koto.’ ");
INSERT INTO lip_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","“Nya míntǝ mbuayɛ minkǝ, ‘Bonamute, mǝmblɛ yi bǝnkǝ mɔ díkesu katsyakɔ isu katsyakɔ kesu kǝmuǝ bafokanɔfɔ nya mínkablɛ mǝ. ");
INSERT INTO lip_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Lǝ lefe nǝ banlɛ Otsyabe Stefano boloo, mintsya átɔnɔ ku mǝ, nya bǝlǝkǝ mǝ awu kato bǝtǝ mɛ mínlɛ fɛ bákato wǝ aba kalo.’ ");
INSERT INTO lip_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","“Nya Bonamute lɛtɛyi mɛ nkǝ, ‘Taka, lǝ ama kusu itsyise kaka minlɛ fǝ botsyese atsyo tinti lǝ betidi ba lenni Yudafɔ nti!’ ” ");
INSERT INTO lip_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Lǝ lefe nǝmfo kenkee, betidi bamfó ńyǝ kpoo banlɛ wǝ ditiki ato butsyuǝ. Fɛɛ lefe nǝ údi wǝ ditiki nǝmfo ólosǝǝ, mǝmblɛ ákpo kudu bátɛyi bǝnkǝ, “Aa! Lo wǝ ku wǝ ditsyǝbi kenke! Yensile bǝ ɔkɛ lǝ kawunsiǝ kamfo kon!” ");
INSERT INTO lip_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Nya mǝmblɛ lekpo kudu bembembe ku lɛblɔfi bála mǝ awu lǝ ǝsuǝ, nya bákpa utembu bǝsǝ wǝ, nya utembu ǝmǝ lébe kato ófo mfo kenke. ");
INSERT INTO lip_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Nya Roma eto bamamanyǝ eto ɔtɔnkotɔnko kplɛ ǝmǝ dítǝ nkǝ bákpa wǝ bedufǝnko diyo kafo lǝ bablɛ wǝ lǝ babɛbɛ lesa nǝ eso Yudafɔ bamfo nlɛ wǝ kudu bokpo. ");
INSERT INTO lip_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Fɛɛ lefe nǝ bákle wǝ bǝǝbǝ wǝ bɔblɛɛ, Paulo átɔ omamanyǝ ninǝ ɔni wǝ dińyǝ mfó nkǝ, “Kusu kpe bǝ bablɛ Romanyǝ wǝ bánkponko tɔ lekpo?” ");
INSERT INTO lip_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Se uninǝ ǝmfo lɛnɔ nyafoo, úsu ɔtɔnkotɔnko kplɛ ǝmǝ ɔflɔ nya ɔ́tɔ wǝ nkǝ, “Be biǝ bieyifo mfo mmǝ? Osani ǝmfoo, Romanyǝ uni lo!” ");
INSERT INTO lip_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Nyaso bamamanyǝ eto ɔtɔnkotɔnko kplɛ ǝmfo dísu Paulo ɔflɔ nya ɔ́tɔ wǝ nkǝ, “Be fanlɛ bɔtɛyi? Romanyǝ feni?” Nya Paulo dítǝ mbuayɛ nkǝ, “Ee!” ");
INSERT INTO lip_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Nya ɔtɔnkotɔnko kplɛ ǝmfo lɛtɛyi wǝ nkǝ, “Mintsya Romanyǝ mini. Fɛɛ mɔɔ, atabi kpǝ míntǝ fɛ mimfiani Romanyǝ!” Nya Paulo dítǝ wǝ mbuayɛ bio nkǝ, “Mɔ alɛɛ, mɔ anto ku ambe kenke eyifo Romafɔ.” ");
INSERT INTO lip_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Lamfolamfo se betidi ba bǝ bablɛ wǝ lǝ batɔ wǝ kɛnyɛ eto etiki banɔ léte bǝ Romanyǝ unii, difufu ǝmuǝ mǝmblɛ kenke nya bányi besu kama. Nya lefe nǝ mǝ ɔtɔnkotɔnko kplɛ léte nkǝ Romanyǝ unii, sikpi ǝmuǝ wǝ tinti, itsyise wǝ ni futsyǝ dítǝ kusu nkǝ bakpe wǝ lǝ amana ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Bamamanyǝ eto ɔtɔnkotɔnko kplɛ ǝmfo ála nkǝ waate lesa nǝ díbǝ fɛ béfi etiki lǝ Paulo ǝsuǝ. Nyaso se kale dísiǝǝ, ókpadi Yudafɔ eto besumunyǝ ninǝ ku mǝ bakponkpo kenke nya mǝmblɛ díbǝ bakɔ. Nya útǝ nkǝ banyankli Paulo nya bákpa wǝ báboko mǝ ǝnǝmi bǝ lǝ bedufǝ lǝ wǝ etiki ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Lefe nǝ Paulo létsyilamasǝ ǝnǝmii, únyǝ Yudafɔ eto bakponkpo ba díkǝbǝ bensi lǝ lekpokakpokɔ mfó, nya ɔ́tɛyi mǝ nkǝ, “Bayimi, mɔ lɛkɔɛsi anlɛ mɛ dikpi bolo lǝ Onanto eto ǝnǝmi ibǝ ese lǝ mmi eto diyi nǝ mfo.” ");
INSERT INTO lip_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Nya se Ananias wǝ ni Yudafɔ eto Usumunyǝ Ninǝ Kenke lǝ mǝ nti mfó lɛnɔ kase Paulo dítǝ mbuayɛ bomfoo, ɔ́tɛyi mba ńyǝ lǝ Paulo ɔflɔ mfo nkǝ basɔ wǝ lǝ kɛnyɛ. ");
INSERT INTO lip_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Mfó Paulo lɛtɛyi wǝ nkǝ, “Onanto ǝbɔsɔ fǝ nko ke! Fǝ nwǝ ni ofati wǝ bákua diflubi futututu! Nte okponkpo wǝ eto okle fe ni mfo? Nte kɔfi ko eto okle ǝsuǝ fáyɛ fanlɛ mɛ lekpo bokponko, fɛɛ fǝ ǝmǝ ke ńyǝ lǝ ko ǝsuǝ se fǝtǝ kusu fǝ basɔ mɛ!” ");
INSERT INTO lip_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Nya mba díńyǝ lǝ Paulo ɔflɔ mfó lɛtɔ wǝ bǝnkǝ, “Onanto eto Usumunyǝ Ninǝ Kenke fanlɛ boka mmǝ?” ");
INSERT INTO lip_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Lǝ nyasoo, Paulo ǝtǝ mbuayɛ nkǝ, “Mɔ bayimi, Israelfɔ, mánte nko minkǝ wǝ ni Usumunyǝ Ninǝ Kenke. Lǝ nko inii, eni méndi wǝ etiki nko. Itsyise bátɛyi lǝ Awɔnisa Kɛnkɛ eto Kukue nkǝ, ‘Mántɛyi etiki bua saa nnya dińyǝ lǝ mi batɔnkotɔnko ǝsuǝ.’ ” ");
INSERT INTO lip_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Nya Paulo ǝnyǝ nkǝ, betidi ba díbǝ bátsya mfó eto bǝtsyuǝ eyifo ditsyukpa nǝ baakpo Sadukifɔ, nya bǝtsyuǝ tsya diyifo Farisifɔ. Lǝ nyasoo, ófã bembembe ɔ́tɛyi nkǝ, “Mɔ bayimi, Farisinyǝ mini! Nya Farisinyǝ eto kafo bale mɛ bétsyiko! Nyaso banlɛ mɛ lekpo bokponko mmi nɛ itsyise mfo nnɔ miǝ bǝkpǝnkǝ si bootaka betsyi ɔkɔmǝ bǝbǝ bio!” ");
INSERT INTO lip_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Nya lefe nǝ Paulo lɛtɛyi nko eto ditiki nǝmfo ólosǝǝ, dikunǝ kǝdiǝ ko dídufǝ lǝ etsyukpa ǝnuǝ nyamfo eto nti, nya báma lǝ akpa ǝnuǝ. ");
INSERT INTO lip_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Itsyise Sadukifɔ aatɛyi bǝnkǝ bekpǝnkpǝ ǝnsiǝmbotaka, nya Onanto eto batɔnkpe ku awɔnɔ ǝmbǝ, fɛɛ Farisifɔ áfo nyamfo kenke bánɔ. ");
INSERT INTO lip_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Mfo nya kǝdiǝ dídufǝ mǝ lenti nyanklaa. Mfo nya kɔfi eto bateasa ba ni Farisifɔ díńyǝ lǝ Paulo eto ditiki nǝmǝ eto kama bǝ ɔnukualɛ ɔ́tɛyi. Nya bákpo kudu bembembe bátɛyi bǝnkǝ, “Boǝnyǝ lesa bua saa lǝ wǝ ǝsuǝ! Nya lǝ lɛwɔnɔ ditsyuǝ nye Onanto eto ɔtɔnkpe utsyuǝ nlɛ wǝ etiki budinkoo, be lebia lǝ nnya ǝsuǝ?” ");
INSERT INTO lip_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Mfóo, etiki eto kǝnǝ kamǝ ǝbǝ kakɛ ale tinti. Nyaso bamamanyǝ eto ɔtɔnkotɔnko kplɛ ǝmǝ áte sikpi nkǝ boonǝ Paulo bésense nyasoo, ɔ́tɛyi wǝ bamamanyǝ nkǝ bakpa wǝ besu beti bakpe lǝ Aba eto diyo. ");
INSERT INTO lip_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Nya diyi nǝmfo eto ntsyǝntii, Bonamute ǝbǝ Paulo ɔflɔ nya ɔ́tɛyi wǝ nkǝ, “Paulo, kpe utu! Fe kase fǝńyǝ fédi mɔ ditiki nǝmǝ eto adansiɛ lǝ Yerusalem, nko ke fuuńyǝ edi ni lǝ Roma tsya nɛ.” ");
INSERT INTO lip_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Nya se kale dísiǝǝ, Yudafɔ bǝtsyuǝ áka ntamu bǝnkǝ bǝǝmbudi lesa nye bǝnǝ ntu isu ese lefe nǝ eto lefe balo Paulo! ");
INSERT INTO lip_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Nya betidi bamfo ebuyifo fe betidi fosi ana ku kama. ");
INSERT INTO lip_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Nya bésu besumunyǝ ninǝ kenke ku mǝ batɔnkotɔnko ɔflɔ nya bésu bátɛyi mǝ bǝnkǝ, “Boka ntamu boǝnkǝ boembudi nye bunǝ kulesa isu ese lefe nǝ boolo Paulo. ");
INSERT INTO lip_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Lǝ nyaso mi ku bakponkpo tɛyi bamamanyǝ eto ɔtɔnkotɔnko bǝ lǝ okpa Paulo oboko katsyakɔ mfó. Biyifo fenkǝ bela biǝ bisi biatɔ wǝ etiki nyamǝ eto lekpasǝ. Nya lǝ bakpa wǝ balɛ bobokoo, lǝ bolo wǝ lǝ kusu.” ");
INSERT INTO lip_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Nya se Paulo eto utitabo lɛnɔ etiki nya kenke bátɛyi mfo esoo, útsyǝtsyi úsu Aba eto diyo kaka bákpe Paulo nya úsu úyu ɔ́tɛyi wǝ etiki nya bátɛyi. ");
INSERT INTO lip_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Nyaso Paulo ákpadi omamanyǝ ninǝ wǝ díńyǝ lǝ mfó nya ɔ́tɛyi wǝ nkǝ, “Kpa okosobi ǝmfo esuko mi ununǝ ɔflɔ. Ɔyɛnko ditiki kekleke nkǝ lǝ ɔtɛyi wǝ.” ");
INSERT INTO lip_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Lǝ nya esoo, omamanyǝ ǝmǝ ákpa okosobi ǝmfo úsuko mǝ uninǝ ǝmǝ ɔflɔ. Nya ɔ́tɛyi wǝ nkǝ, “Paulo wǝ bákpe lǝ diyo mfo lekpadi mǝ nya ɔ́tɛyi mɛ nkǝ nkpa dikpefi nǝmfo mboko fǝ ɔflɔ lǝ ɔtɛyi fǝ ditiki ditsyuǝ nǝ ɔnyɛnko.” ");
INSERT INTO lip_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Nyaso bamamanyǝ ninǝ kenke eto ɔtɔnkotɔnko ǝmfo ákɔbe okosobi ǝmfo lǝ kɔni nya ókpa wǝ usuko lɛkpɔ nya ɔ́tɔ wǝ nkǝ, “Be fanyɛnko fǝ atɛyi mɛ?” ");
INSERT INTO lip_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Nya ɔ́tɛyi wǝ nkǝ, “Yudafɔ bǝtsyuǝ ákle kɛnyɛ ku mǝ beninǝ bǝnkǝ bǝǝbǝ balɛ fǝǝ lekpakpa bǝ lǝ akpa Paulo aboko katsyakɔ mfó kusɛɛ ku nsusu bǝ lǝ batɔ wǝ etiki ǝtsyuǝ. ");
INSERT INTO lip_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Fɛɛ mamfo mǝ etiki, itsyise mǝ betidi fe awosi ana ku kama ǝbɔbiǝ lǝ kusu komǝ kala wǝ kusu. Betidi bamfo akle kɛnyɛ bǝ boolo Paulo fɛ boodi lesa nye bǝnǝ ntu. Nyaso balɛ kusu bɔbɛbɛ ɛɛyɛ lǝ fǝ. Boomuǝ ǝsuǝ besu babiɔ lǝ kusu mfo, itsyise balɛ kusu bobe bǝ ǝbɔtɔnɔ ǝtǝ mǝ nko.” ");
INSERT INTO lip_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Bamamanyǝ eto ɔtɔnkotɔnko ǝmfo ǝkǝ wǝ ato nkǝ, “Mǝntǝ lǝ kutsyuǝ saa lǝ usi ɔnɔ ditiki nǝ fátɛyi mɛ mfo blɛmblɛ!” Nya útǝ okosobi ǝmfo kusu dídu. ");
INSERT INTO lip_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Nyamfo eto kamaa, omamanyǝ ninǝ ǝmfo ákpadi wǝ beninǝ inuǝ nya ɔ́tɛyi mǝ nkǝ, “Bɛbɛbɛ bamamanyǝ alofa ǝnuǝ ba luusu Kaisarea mmi ku kǝtsyǝ abombo ɔwɔnɔmbɛ. Bɛbɛbɛ betidi alofa ǝnuǝ ba tsya luutsyi afle ku betidi fosi akuanse ba lǝǝsiǝ lǝ batɔmini. ");
INSERT INTO lip_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Bitǝ Paulo batɔmini lǝ usiǝ lǝ bekpa wǝ bɛyɛnko buɛ bisuko Aba eto Unyɛsiǝ Felike ɔflɔ.” ");
INSERT INTO lip_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Nya ɔ́wɔni kukue kutsyuǝ nkǝ befi besuko unyɛsiǝ ǝmǝ nkǝ, ");
INSERT INTO lip_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Kukue komfo etsyi mɔ Klaudio Lisia ɔflɔ nya minlɛ ko bufi katsyese fǝ Boote kplɛ Felike minlɛ fǝ busiǝsǝ. ");
INSERT INTO lip_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Yudafɔ dímuǝ utidi ǝmfo nya yoofo budi bǝ bala bǝ baalo wǝ fɛ mintǝ bamamanyǝ miǝ bafo wǝ, itsyise nnɔ bǝ Romanyǝ uni. ");
INSERT INTO lip_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Nyaso nkpa wǝ nsuko mǝ katsyakɔ bǝ lǝ banɔ lesa nǝ uyifo. ");
INSERT INTO lip_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Nnyǝ ntsyǝ lekpo minkǝ nnya eso bǝmuǝ wǝ mfo yɛ lǝ mǝ Yudafɔ eto afi ǝsuǝ nya inni bota kebu bo eso ele bǝ bakpe wǝ lǝ diyo nye balo wǝ. ");
INSERT INTO lip_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Lǝ lefe nǝ utsyuǝ lɛtɛyi mɛ ǝnkǝ balɛ disi bubu lǝ wǝ ǝsuǝ bǝ lǝ balo wǝǝ, lamfolamfo mbu disi minkǝ lǝ nkpa wǝ mboko fǝ ɔflɔ nya lǝ ntɛyi mba wǝ ku mǝ lɛkɛ etiki miǝ befi kabua ka uyifo baboko fǝ ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Nyaso bamamanyǝ bamfó eyifo lǝ lesa nǝ bátɛyi mǝ ǝsuǝ. Nyaso ketsye kamfóo, bákpa Paulo báyɛnko taa Antipatri. ");
INSERT INTO lip_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Nya se kale dísiǝǝ, bamamanyǝ ba nyɛ lǝ akpa ésinkli bésu Aba eto diyokakpekɔ mfó, nya bǝtǝ mba lǝǝsiǝ lǝ batɔmini bǝ bayɛnko Paulo besuko Kaisarea. ");
INSERT INTO lip_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Se bésu bédufǝǝ, bákpa Paulo ku kukue ko bǝtǝ mǝ mfo bésu bǝtǝ Aba eto Unyɛsiǝ ǝmǝ. ");
INSERT INTO lip_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Nya lǝ lefe nǝ ɔnlɛ kukue komǝ boklaa, ɔ́tɔ Paulo kaka útsyi. Se ɔ́nɔ nkǝ Paulo etsyi Kilikiaa, ");
INSERT INTO lip_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","usi ɔ́tɛyi wǝ nkǝ, “Muudufǝ lǝ fǝ etiki nyamfo ǝsuǝ nnɔ nya kukɔnɔ lǝ lefe nǝmǝ ayo lǝ fonko betidi ba lɛkɛ etiki mfó ǝbǝ.” Nya usi útǝ wǝ bamamanyǝ ba ńyǝ mfó nkǝ bákpa Paulo besu beti bakpe lǝ diyo nǝ Oka Herodes léto lǝ bakase wǝ. ");
INSERT INTO lip_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Eyi anɔ eto kamaa, Usumunyǝ Ninǝ Kenke Ananias ku Yudafɔ eto beninǝ bǝtsyuǝ ku mǝ Otsyiami wǝ bákpo Tertulo ǝbǝ Kaisarea. Bǝbǝ Felike ɔflɔ bǝ lǝ bǝbǝ babɔ wǝ kabua ka Paulo nlɛ buyifo. ");
INSERT INTO lip_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Nya se bákpadi Pauloo, Tertulo ákpe kɛnyɛ ɔ́tɛyi nkǝ, “Bo Ububutidi, lefe kpǝ ni nǝmfoo, diyuǝ akɛ bo lenti ɛyɛ lǝ fǝ kobe ku bote butsyue bo fefi fanyɛnko bo eso. Nya bunyǝ boǝ bɔtsyikawuninsǝ sɛɛ kpǝ tsya ǝbǝ lǝ bo kasɔ mfo kenke. ");
INSERT INTO lip_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Nyamfo eso bo Yudafɔ kenke lɛ fǝ ani bɔsɔ. ");
INSERT INTO lip_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Nya bɔlɛ fǝ lekpakpa bɔlɛ boǝ lǝ bɔyɛ fǝ lefe bobiasǝǝ, lǝ etsyue ato anɔ etiki nya boǝbǝ bɔtɛyi itsyi lǝ osani ǝmfo ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","“Se bunyǝ wǝǝ, bunyǝ boǝ uyifo nwǝ laakpe bulǝ, nya woatsyilama kafe lefe saa akabiasǝ Yudafɔ eto nsusu lǝ kalebe saa lǝ kasɔ kamfo kenke bǝ lǝ bǝnǝ asa bua baboko lǝ bǝnyǝ Aba lǝ ǝsuǝ. Nya wǝ ni ditsyukpa nǝ baakpo Nasaretfɔ eto ɔtɔnkotɔnko. ");
INSERT INTO lip_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Nya búnyǝ tsya boǝ úkatsyilama kéyifo asa nnya dítǝ bǝ ókpe bo Yudafɔ eto Disumuyo kɔfiɔ fɛ búmuǝ wǝ. Bola boǝ eni boeyifo wǝ lesa nǝ díńyǝ itǝ asa bua nnya uyifo úńyǝ lǝ bo afi ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Fɛɛ bamamanyǝ eto ɔtɔnkotɔnko ninǝ Lisia díbǝ ɔ́lɛ wǝ ófo, nya útǝ ǝsuǝale nkǝ wonko mba lǝkǝ etiki bǝ lekpo eti lǝ fǝ ǝnǝmi. ");
INSERT INTO lip_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Nyaso ebofo wǝ bɔtɔ lǝ anɔ lǝ etiki nnya bɔ́tɛyi mfo eyifo sidia.” ");
INSERT INTO lip_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Nya Yudafɔ bamǝ kenke lɛkɔ bédi adansiɛ bátɛyi bǝtǝkǝ lǝ nnya kenke Tertulo lɛtɛyi bǝ iyifo ɔnukualɛ. ");
INSERT INTO lip_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Nya lefe nǝ Aba eto unyɛsiǝ emfo diyifo Paulo kɔni nkǝ udi etikii, Paulo ǝtsyǝ kasɔ nkǝ, “Anto, nnyi miǝ fǝ ni futsyuǝ laakpo akpo lǝ Yudafɔ nti alɛ kpǝ ni nyamfo. Lǝ nyaso iyifo mɛ disuǝyuǝ bǝ ndi etiki nlǝkǝ mɔ ǝsuǝ kasɔ lǝ fǝ ǝnǝmi. ");
INSERT INTO lip_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Yuuyifo fǝ bote bǝnkǝ iyifo fe lefosi eyi ǝnuǝ ni nyamfo se mímbǝ Yerusalem mímbǝ lǝ Yudafɔ eto Disumuyo mfó bǝ lǝ ntǝ kedi. ");
INSERT INTO lip_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Nya kuutsyuǝ mǝnyǝ se bonko kuutsyuǝ nlɛ etiki bunǝ nye mínkpe bulǝ saa lǝ Yudafɔ eto Disumuyo mfó nye lǝ Yudafɔ eto ntsyakɔ tsya nnye lǝ umǝ ǝmǝ kafo. ");
INSERT INTO lip_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Nya betidi bamfo eto kuutsyuǝ saa ǝmbofo kulesa bunyǝ kate sitinti, bǝ etiki nnya bátɛyi mfo eyifo sitinti. ");
INSERT INTO lip_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Nyaa, ditiki nǝ ǝsuǝ mɔɔtɔnɔ ku mǝ ni bǝnkǝ nńyǝ lǝ boantomǝ eto Onanto eto bofokanɔ eto kusu ko mǝ bǝnkǝ iyifo ditsyukpa nǝ nńyǝ lǝ mǝ ǝsuǝ. Nnya ni bǝ mmfo Moses eto kɔfi nnɔ kekleke ku asa nnya báwɔni bákpe lǝ Onanto eto bǝnyɛlǝkǝtidi eto ekue ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Mfi ǝnǝmi ntǝkǝ lǝ Onanto ǝsuǝ fe kase mǝ tsya dífi mǝ ǝnǝmi bǝtǝkǝ bǝ betidi ba kenkee, bǝ basɛɛ ku babua tã ebotaka betsyi ɔkɔmǝ bǝbǝ. ");
INSERT INTO lip_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Lǝ nyamfo esoo, mfi mɔ ǝsuǝale kenke nkpe bǝ nlǝkǝ mɔ nsusu nte lǝ nkpa lǝ nyamfo ǝsuǝ lǝ Onanto ku betidi kenke eto ǝnǝmi. ");
INSERT INTO lip_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Alɛ kpǝ ni nyamfo mensikɛ lǝ Yerusalem. Nya misinkli mimbǝ miǝ mufi ǝtǝsa ntǝ bakombo ba ni mɔ kosate eto betidi nya lǝ ntǝ Onanto kedi tsya. ");
INSERT INTO lip_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Lǝ lefe nǝ mínyifo disikpinkpi eto lekpa mínlosǝǝ, Yudafɔ bǝtsyuǝ ǝbǝ bǝnyǝ mɛ lǝ Disumuyo mfó. Nya bonko mba laakpo kudu kakpe bulǝ saa mányɛ. Nya mɔ ǝmǝ tsya mánkpe bulǝ saa. ");
INSERT INTO lip_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Yoofo budi bǝ Yudafɔ ba ditsyi Asia eto kasɔɔ, mǝ ele bǝ bebǝ fǝ ɔflɔ. Nya lǝ mɔ ku mǝ kpe etiki ǝtsyuǝǝ, nnya boolǝkǝ batɛyi nɛ. ");
INSERT INTO lip_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Nnye betidi ba nsi mfóo, yoofo budi bǝ bɔɔtɛyi asa bua nnya eto dikpi nǝ bálo mǝ lefe nǝ Yudafɔ eto bakponkpo ninǝ ba lɛkɛ mfó fɛ bákponko mɛ lekpo. ");
INSERT INTO lip_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Enso ditiki nǝ mímbesǝ ɔkɔɛ kato míntɛyi lǝ lefe nǝ míńyǝ lǝ mǝ ǝnǝmi minkǝ, ‘Mbǝ katsyakɔ mfo lǝ nlǝkǝ mɔ ǝsuǝ kɛnyɛ minkǝ mfo nnɔ minkǝ bǝkpǝnkpǝ si bootaka betsyi ɔkɔmǝ bǝbǝ’ eso békponko mɛ lekpo?” ");
INSERT INTO lip_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Nyaso Felike wǝ nyi kusufɔfɔtsyɔntsyɔ eto ditsyukpa nya ófo ditiki nǝmfo ɔ́nɔ tintii, átɛyi Yudafɔ bamfo nkǝ, “Bisinkli bɛyɛ isu ese lefe nǝ bamamanyǝ eto ɔtɔnkotɔnko kplɛ Lisia luubǝ fɛ lǝ nla ditiki nǝmfo nlǝkǝ.” ");
INSERT INTO lip_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Nya útǝ kusu nkǝ omamanyǝ ninǝ kpa Paulo usu okpe lǝ diyo. Fɛɛ balɛ wǝ ola kukɔnɔ, lǝ bǝtǝ wǝ bayɛtsyuǝ ba luubǝ bǝ bǝǝnyǝ wǝ nnye baboko wǝ asaa, kusu. ");
INSERT INTO lip_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Lǝ eyi asiani ǝtsyuǝ eto kamaa, Felike ku wǝ usiǝ Drusila wǝ ni Yudanyǝ ǝbǝ, nya útǝ nkǝ bakpa Paulo baboko, nya údi mǝ etiki itsyi lǝ Yesu Kristo eto bofokanɔ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Nya lefe nǝ unsi ɔnlɛ asa kasɔ bulǝkǝ kate mǝ itsyi lǝ nkpǝ sɛɛ siǝsiǝ ku ǝsuǝ ola bɔlɛ ku Onanto eto lekpo kponkpo nǝ lǝǝbǝ bubǝ kama kamaa, sikpi alɛ Felike tinti. Mfóo, nya Felike lɛtɛyi wǝ nkǝ, “Taka lǝ edu. Nya lǝ nsi nkɛ lefe sɛɛ, muutǝ bakpadi fǝ bǝtǝ mɛ.” ");
INSERT INTO lip_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Nya se úbu nkǝ Paulo ebuyifo nte butsyuǝ utǝ wǝ esoo, úkakpe nkǝ bákakpadi wǝ lefe saa lǝ wonko wǝ lǝ bǝkǝdi etiki lǝ bǝtsyuǝ. ");
INSERT INTO lip_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Lǝ alɛ ǝnuǝ eto kamaa, bǝlǝkǝ Felike bédunko nya báboko Porkio Festo lǝ wǝ kɛnyɛ. Nya se Felike lɛbɛbɛ nkǝ Yudafɔ la wǝ asa esoo, útǝ kusu nkǝ Paulo si ɔkɛ diyo nǝmǝ mfó. ");
INSERT INTO lip_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Eyi ǝtsyǝ eto kama se Festo díbǝ údufǝ lǝ wǝ sininǝ kedikɔɔ, údu lǝ Kaisarea úsu Yerusalem. ");
INSERT INTO lip_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Mfó nya besumunyǝ ninǝ ku Yudafɔ eto beninǝ lɛtɛyi wǝ etiki itsyi lǝ Paulo ǝsuǝ. Nya bálɛ wǝ lekpakpa bǝnkǝ ");
INSERT INTO lip_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","okpa Paulo oboko Yerusalem. Nya mǝ nsusu ni bǝnkǝ bɔɔbiɔ bǝsǝkǝ wǝ lǝ kusu. Nya lǝ ubǝ ɔlɛ bofee, lǝ balo wǝ. ");
INSERT INTO lip_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Nya Festo lɛtɛyi mǝ nkǝ, “Paulo labe lǝ diyo lǝ Kaesarea. Nya mintsya luubǝ mfo lefe kliminti eto kama. ");
INSERT INTO lip_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Nyaso bitǝ lǝ mi beninǝ lǝ bǝbǝ mfó lǝ bǝbǝ bǝlǝkǝ kabua ka úyifo bate.” ");
INSERT INTO lip_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Lǝ eyi mflamfla nye lefosi eto kamaa, Festo ésinkli úsu Kaesarea. Se kale dísiǝǝ, ókpadi Paulo eto lekpo nǝmfo. ");
INSERT INTO lip_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Nya se Paulo díbǝ údufǝ lekpokakpokɔ mfóo, Yudafɔ ba ditsyi Yerusalem ǝbǝ bǝńyǝ bátsyilama wǝ nya báwe etiki kpǝ bǝtǝkǝ wǝ lǝ ǝsuǝ nya bámfo kɛnyɛ bulǝkǝ kate ɔnukualɛ wǝ nkpe lǝ nnya. ");
INSERT INTO lip_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Paulo édi etiki ɔ́tɛyi nkǝ, “Ményifo kabua saa nta Yudafɔ eto kɔfi nye Disumuyo nye Okankplɛ Kaisare eto kɔfi ǝsuǝ mbu.” ");
INSERT INTO lip_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Nya se Festo léla nkǝ lǝ Yudafɔ la wǝ asa esoo, ɔ́tɔ Paulo nkǝ, “Ala fǝnkǝ eesu Yerusalem lǝ nsu nkponko fǝ lekpo nǝmǝ mfó?” ");
INSERT INTO lip_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Nya Paulo lɛtɛyi wǝ nkǝ, “Owo. Iyifo mɛ kusutǝtǝ bǝnkǝ kasɔ kamfo eto Okankplɛ Kaisare kosate kponko mɛ lekpo nǝmfo. Fǝ kosate yi sitinti fǝnkǝ manta kɔfi sa mbu nyifo kabua sa lǝ Yudafɔ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Lǝ nyifo lesa nǝ díńyǝ itǝ bǝ balo mǝǝ, mɔɔtɔnɔ miǝ balo mɛ! Fɛɛ lǝ mánta kɔfi saa mbuu, yembutǝ kusu bǝ fǝ nye utidi bamba lǝ ufi mɛ utǝ betidi bamfo lǝ balo. Lǝ nyaso mfi mɔ etiki nlɛ butsyǝ lǝ Okankplɛ Kaisare eto ǝnǝmi!” ");
INSERT INTO lip_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Nyamfo eto kamaa, Festo ku wǝ beninǝ álɛ etiki nyamǝ bábe nya ɔ́tɛyi Paulo bǝnkǝ, “Se féfi fǝ etiki fanlɛ Okankplɛ Kaisare butǝ esoo, ebusu Okankplɛ Kaisare eto ǝnǝmi.” ");
INSERT INTO lip_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Lǝ eyi ǝtsyuǝ eto kamaa, Oka Agripa ku wǝ ɔyimisio wǝ baakpo Bernike ǝbǝ Festo ɔflɔ lǝ Kaisarea bǝ lǝ bǝbǝ bǝnyǝ wǝ bǝsiǝsǝ. ");
INSERT INTO lip_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Bǝsiǝ mfó eyi kpǝ nya Festo dífi Paulo eto etiki ɔ́tɛyi Oka ǝmfo nkǝ, “Osani utsyuǝ labe lǝ Aba eto diyo mfo, nya Felike léyani utsyǝ. ");
INSERT INTO lip_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Lefe nǝ mínsu Yerusalem, besumunyǝ ninǝ ku mǝ batɔnkotɔnko átɛyi mɛ etiki nnya bála bǝtǝkǝ wǝ, nya bátɛyi mɛ bǝ ntǝ kusu lǝ balo wǝ dikpi. ");
INSERT INTO lip_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","“Nya mínlǝkǝ kasɔ mínte mǝ miǝ Romafɔ eto kɔfi mǝntǝ kusu bǝ balo utidi dikpi fɛ lǝ bakponko wǝ lekpo. Ele bǝ bǝtǝ wǝ kusu lǝ wǝ ku betidi ba lɛkɛ etiki lǝ batsya batɛyi nya fɛ lǝ balo wǝ dikpi. ");
INSERT INTO lip_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Lefe nǝ bǝbǝ mfo lǝ etiki nyamfo ǝsuǝǝ, mintsya mémfi nnya ntsyǝ lǝ ǝsuǝ. Lǝ nnya kǝsiǝsǝ eto olesiǝǝ, ntǝ miǝ bakpa osani ǝmfo baboko mɔ lekpokakpokɔ. ");
INSERT INTO lip_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Fɛɛ etiki nnya béfi lɛ wǝǝ, menyifo etiki bua nnya mímbu miǝ nnya boofi lǝ wǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Asa nnya bátɛyi mfó eyifo etiki nnya ditsyi lǝ mǝ kafokanɔ ku utidi wǝ baakpo Yesu wǝ díkpǝ, nya Paulo, wǝ nlɛ bɔtɛyi nkǝ okpe nkpǝ ǝsuǝ! ");
INSERT INTO lip_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Iyifo mɛ basaa nya mante kase mɔɔyɛ nla etiki nyamǝ. Lǝ nyaso ntɔ Paulo lǝ woola nkǝ woefi ditiki nǝmǝ usuko Yerusalem lǝ usu ulǝkǝ etiki nyamfo kɛnyɛ lǝ Yerusalem mfó. ");
INSERT INTO lip_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Nya Paulo lɛtɛyi nkǝ óla nkǝ woefi wǝ etiki usuko Okankplɛ Kaisare lǝ udi, lǝ nyaso ntǝ miǝ beti wǝ bakpe lǝ diyo isu ese lefe nǝ mootsyese wǝ Okankplɛ ǝmǝ ɔflɔ.” ");
INSERT INTO lip_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Nya Oka Agripa lɛtɛyi Festo nkǝ, “Nla miǝ mɔ kosate lǝ nnɔ wǝ ditiki nǝmǝ.” Nya Festo lɛtɛyi wǝ nkǝ, “Ɛbɔnɔ ditiki nǝmfo kusɛɛ!” ");
INSERT INTO lip_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Nya se kale disiǝǝ, Oka Agripa ku Berenike álɔkɔ ku bekankǝ bǝbǝ lekayo nya bédufǝ lekpokakpokɔ mfó. Nya bamamanyǝ ku umǝ ǝmǝ eto beninǝ dítǝkǝko mǝ bǝǝbǝ. Nya Festo dítǝ ǝsuǝale nkǝ bakpa Paulo baboko. ");
INSERT INTO lip_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Nya Festo lɛtɛyi nkǝ, “Oka Agripa ku mi mba kenke díbǝ bétsya mfo, osani ǝmfo ni utidi wǝ Yudafɔ ba nkpe lǝ Yerusalem ku Kaisarea mfo kenke tsya léla bǝ balo! ");
INSERT INTO lip_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Fɛɛ lǝ mɔ nsusu ǝsuǝǝ, wényifo kulesa nǝ dítǝ bǝ balo wǝ dikpǝnkpi. Fɛɛ wǝ ǝmǝ tsya nkǝ úfi wǝ etiki útǝ bo Okankplɛ. Nya mintsya mánni nko. ");
INSERT INTO lip_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Fɛɛ be ni lesa nǝ ele bǝ nwɔni ntǝ bo Okankplɛ ǝmfo? Itsyisee, wényifo tɔ kabua saa mǝ. Lǝ nyaso nkpa wǝ mboko mi ku fǝ Oka Agripa titlu, minkǝ lǝ bidufǝ lǝ wǝ ditiki ǝsuǝ lǝ bete mɛ ditiki nǝ ele bǝ nwɔni ntsyese wǝ. ");
INSERT INTO lip_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Itsyisee, yanlɛkɛ bǝ nkpa nwǝ bákpe lǝ diyo ntsyese kasɔ kamfo eto Okankplɛ lǝ lefe nǝ eto lefe mǝnnyǝ kabua ka úyifo ka mɔɔwɔni ntsyese wǝ.” ");
INSERT INTO lip_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Nya Agripa lɛtɛyi Paulo nkǝ, “Kusu kpe bǝ di fǝ etiki.” Lǝ nnya esoo, Paulo ábesǝ wǝ kɔni kato nya údi etiki ɔ́tɛyi nkǝ, ");
INSERT INTO lip_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Bo Oka Sɛɛ Agripa, disi ɛkpɛ kpe mɛ mmi bǝ moofo mɔ ditiki bulǝkǝ kate lǝ fǝ ǝnǝmi lǝ nnya eso Yudafɔ dífi etiki lǝ mɛ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Itsyise nyi miǝ fǝǝ, eyi Yudafɔ eto kǝnǝ ka nkpe lǝ mǝ nti ku mǝ akpa kenke kukɔnɔ. Nyamfo esoo, minlɛ fǝ lekpakpa nɛ. Kpe utu lǝ anɔ mɔ etiki ǝtǝ mɛ. ");
INSERT INTO lip_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Yudafɔ kenke yi kase mínlɛ mɔ ǝsuǝ ola idu lǝ mɔ sikpefi lefe lǝ mɔ umǝ ku lǝ Yerusalem tsya. ");
INSERT INTO lip_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Lǝ bɔɔtɛyi ɔnukualɛɛ, nko seka mísiǝ nkpǝ fe Farisinyǝ itsyi taa mɔ sikpefi lefe nɛ. Nya Yudafɔ eto afi ku akpa kpe ale eso nsumu bamba saa eto ale kenke. ");
INSERT INTO lip_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Lǝ nyaso ete béfi etiki nyamfo banlɛ butǝkǝ mɛ lǝ ǝsuǝ nɛ lǝ kase mińyǝ minlɛ kusu bobe itǝ kɛnyɛ ka Onanto lɛtɛyi bo bana mǝ utsyǝ eso. ");
INSERT INTO lip_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Israelfɔ eto lefosi atobi ǝnuǝ nnya kenke lǝ bokplatsya kekleke kǝtsyǝ ku kakɔmi bǝ lǝ mǝ tsya lǝ bǝnyǝ kusu ko minlɛ bobe mfo. Bo Oka Sɛɛ, nyamfo eso Yudafɔ nlɛ mɛ kɛnyɛ bola kǝtǝkǝ mɛ etiki lǝ ǝsuǝ nɛ. ");
INSERT INTO lip_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Beso ele bǝ ilǝ bǝ mi mba nkpe mfo kenke fo bɛnɔ biǝ Onanto aatakasǝ bǝkpǝnkpǝ? ");
INSERT INTO lip_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Lefe nǝ léfe mmǝǝ, mfi nnya ntǝkǝ lǝ mɔ ǝsuǝ miǝ muuyifo lesa saa nǝ moofo lǝ nńyǝ lǝ Yesu wǝ ni Nasaretnyǝ eto mba ntǝkǝko wǝ lǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Yudafɔ eto besumunyǝ ninǝ ǝtǝ mɛ ǝsuǝale bǝ mmuǝ betidi kɛnkɛ kpǝ nkpe lǝ diyo lǝ Yerusalem. Nya mba bálo lǝ mǝ nti tsyaa, íyifo mɔ lelabi bǝ ibǝ nko ");
INSERT INTO lip_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Ntǝkǝko mǝ nya mínkpɔ mǝ nya mínte mǝ ohiã ɛyɛ isu kǝmǝ bamba ka letsyo kulaa tsya. Nya míntǝ miǝ beyifo mǝ asafimfi lǝ Yudafɔ eto ntsyakɔ kenke. Nya míńyǝ mǝ lǝ ǝsuǝ ku lɛblɔfi miǝ bedi mbusiotiki nnya dińyǝ lǝ Yesu ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Nko eto ditsyǝbi ǝsuǝ minkɛ minyɛ mintɔ lǝ Damasko ku ǝsuǝale fe kase besumunyǝ ninǝ dítǝ mɛ. ");
INSERT INTO lip_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Bo Oka Sɛɛ, kase minyɛ kusu lǝ kakɔmi eto lefosi ǝnuǝ lefee, nnyǝ diyǝnde nǝ lekpa lenso mfenti eto kofe ditsyi kato nya lékpo létsyilama bonko mba nyɛ bɔntɔ. ");
INSERT INTO lip_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Nya mfó se bomblɛ dídu bɔ́nɔɔ, nnɔ ɔkɔɛ utsyuǝ lǝ Yudafɔ eto sele ǝsuǝ nlɛ bɔtɛyi nkǝ, ‘Saulo, Saulo, beso fǝńyǝ mɛ lǝ ǝsuǝ nko? Lǝ áta biyu kokpaa, fǝ kosate ete loofo lefabe.’ ");
INSERT INTO lip_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","“Nya míntɔ wǝ minkǝ, ‘Bonamute, owoe fe ni?’ “Nya ɔkɔɛ ǝmǝ lɛtɛyi nkǝ, ‘Mɔ ni Yesu wǝ fanlɛ bɔkpɔnko kekleke. ");
INSERT INTO lip_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Mɔmɔɔ, taka ǝńyǝ! Se mínkǝlǝkǝ ǝsuǝ mínte fǝ esoo, muufi fǝ nyifo mɔ uyifoyifo. Ɛbɔtɛyi kawunsiǝ eto betidi kenke lesa nǝ fǝnyǝ mfo ku asa nnya muukǝlǝkǝ nkate fǝ. ");
INSERT INTO lip_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Nya kaka minlɛ fǝ botsyesee, moose fǝ, nlǝkǝ fǝ ntsyiko lǝ fǝ betidi ku lǝ bele bamba tsya nti. ");
INSERT INTO lip_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Muutǝ asini mǝ ǝnǝmi nnya luutǝ bǝ ebulǝkǝ mǝ etsyiko lǝ Obonsam eto ǝsuǝale ku ketuntu ka bankpe ǝsuǝ bǝ lǝ bafo Onanto eto ǝsuǝale ku diyǝnde nǝ ǝsuǝ onkpe banɔ. Bǝ lǝ Onanto lǝ ufi mǝ abua ɔtsyɛ mǝ itǝ bǝ lǝ bǝnyǝ kǝsiǝkɔ kato fe mba úlǝkǝ óboko wǝ akɔ báfiani mba úlǝkǝ utsyǝ itsyise báfo mɛ bánɔ eso.’ ");
INSERT INTO lip_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Lǝ nyasoo, Oka Agripa, nyamfo eso mányɛ buyifo lǝ nnya Onanto dílǝkǝ óte mɛ itsyi kato ǝsuǝ nɛ. ");
INSERT INTO lip_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Ntsyiko Ditiki Sɛɛ nǝmǝ budi kate Damaskofɔ lǝ nnya kama Yerusalemfɔ, lǝ nnya kama Yudafɔ kenke ku mba lenni Yudafɔ tsya miǝ besinkli lǝ mǝ abua ǝsuǝ lǝ befi mǝ ǝsuǝ bǝtǝ Onanto, lǝ bate lǝ mǝ asayifoyifo ǝsuǝ bǝ bátsyi báwuninsǝ sitinti. ");
INSERT INTO lip_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Nyamfo eso Yudafɔ dímuǝ mɛ lǝ Yudafɔ eto Disumuyo nɛ. Nya bála bǝ eni baalo mɛ. ");
INSERT INTO lip_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Fɛɛ Onanto ǝlǝkǝ mɛ utsyiko lǝ mǝ ani. Nyaso minsi minkpe nkpǝ minlɛ adansiɛ nyamfo budi kate mi beninǝ ku betidi kenke tsya nɛ. Lesa nǝ minlɛ bɔtɛyi mfoo, nnya tututu ni nnya Onanto eto bǝnyɛlǝkǝtidi ku nnya Moses lɛtɛyi bǝ yuubǝ itǝ nɛ. ");
INSERT INTO lip_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Nnya ni bǝ Nwǝ Onanto Lékpo Ɔhile Utsyǝ ebubǝ unyǝ kanyi. Nya wǝ ni utidi tutɛ wǝ lootaka utsyi ɔkɔmǝ ubǝ, nya wǝ luunǝ diyǝnde oboko Yudafɔ ku mba lenni Yudafɔ kenke.” ");
INSERT INTO lip_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Lamfolamfoo, Festo áfa ɔ́tɛyi nkǝ, “Paulo, disi ábia fǝ! Fǝ sikuente kplɛ siamǝ ábiasǝ fǝ disi!” ");
INSERT INTO lip_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Nya Paulo lɛtɛyi nkǝ, “Ububutidi Festo, disi mambia mɛ. Biemfi ditiki nǝmfo fe ayɛtiki. Etiki tinti minlɛ bɔtɛyi. ");
INSERT INTO lip_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Sitinti, Oka Agripa yi etiki nnya minlɛ bɔtɛyi mfo. Nyaso minlɛ wǝ etiki budinko ku utu faa nɛ. Mfo nnɔ miǝ nyamfo eto kulesa menyifo wǝ akulasa, uyi nnya lesa saa. ");
INSERT INTO lip_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Oka Agripa, áfo nnya Onanto eto bǝnyɛlǝkǝtidi lɛtɛyi ánɔ? Nyi miǝ áfo mǝ ánɔ.” ");
INSERT INTO lip_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Nya Agripa lɛtɔ Paulo nkǝ, “Ala fǝ ntsyi nwuninsǝ mfiani Ukristonyǝ lǝ lefe kliminti nǝmfo ǝsuǝ?” ");
INSERT INTO lip_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Nya Paulo dítǝ mbuayɛ nkǝ, “Lefe kliminti dini o-o, lɛkɛntsyɛ dinii, nlɛ ola boto mmi minkǝǝ, mi mba nkpe mfo kenke tsyi bɛwuninsǝ fe mintsya kǝ. Fɛɛ biunyǝ kanyi bakpe mi amana fe kase mɔ nlɛ bunyǝ mǝ!” ");
INSERT INTO lip_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Nya Oka Agripa ku Festo ku Bernike ku betidi bamba bamfó kenke létaka bǝńyǝ. ");
INSERT INTO lip_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Nya se bataka bábɔ lǝ mfoo, bákpe disi lǝ Paulo eto ditiki nǝmfo ǝsuǝ bátɛyi bǝnkǝ, “Utidi ǝmfo menyifo lesa saa bua nǝ ele bǝ balo wǝ nye bakpe wǝ lǝ diyo.” ");
INSERT INTO lip_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Nya Agripa lɛtɛyi Festo nkǝ, “Eni boofo wǝ boyani lenni nya úkefi ditiki nǝmfo útsyǝ Okankplɛ Kaisare lǝ ǝnǝmi eso.” ");
INSERT INTO lip_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Nya lefe nǝ báse uyi bǝnkǝ ele bǝ busu Roma lǝ Italiaa, bákpa Paulo ku mba bákpe lǝ diyo ku babamba bákpe lǝ omamanyǝ ninǝ wǝ baakpo Yulio eto ani. We ni Okankplɛ eto bamamanyǝ eto ditsyukpa eto uninǝ. ");
INSERT INTO lip_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Nya búfi ɔklɔ wǝ dítsyi Adramitio nya útǝ ǝnǝmi Asia eto lekpake eti. Nya bo ku Makedonianyǝ wǝ baakpo Aristarko wǝ ditsyi Tesalonika dísiǝ lǝ ɔklɔ ǝmǝ. ");
INSERT INTO lip_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Nya lefe nǝ kale dísiǝǝ, bóyo Sidon eto lekpo kɛnyɛ. Mfó Yulio dítǝ Paulo kusu kafo faa nkǝ usu umǝ lǝ usu unyǝ wǝ bayɛtsyuǝ itǝ lǝ bǝtǝ wǝ asa nnya wuufi ɔyɛ kusu. ");
INSERT INTO lip_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Nya se busi búdu mfóo lǝ ɔklɔ ǝsuǝ nya lǝ kase ufiebi ǝmǝ lɛkɛ kɛnyɛ ale esoo, bɔyɛ Kipro eto Ɔnwɛdukue eti kaka bɔ́bɔ lǝ ufiebi ǝmǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Nya se bófe mfóo, bɔ́yɛ lǝ Kilikia ku Pamfilia eto lekpo kɛnyɛ, nya búsu búńyǝ lǝ umǝ wǝ baakpo Mira lǝ Likia eto lekpake. ");
INSERT INTO lip_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Lǝ mfó omamanyǝ ninǝ wǝ nyɛnko bo ǝnyǝ ɔklɔ utsyuǝ wǝ ditsyi Aleksandria ɔntɔ lǝ Italia eto kasɔ. Nya útǝ búsiǝ lǝ wǝ. ");
INSERT INTO lip_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Nya lǝ eyi kpǝ eto kamaa, ílǝ fɛ búsu bóyo umǝ wǝ baakpo Knido. Nya lǝ ufiebi wǝ nlɛ bɔsɔ kekleke esoo, bóamfo bɔyɛ kesu sɛtɔ. Nyaso se búdufǝ Salmonee, bɔ́tsyi bɔ́yɛ búsu Kreta ɔflɔ kaka kasɔ kamǝ díti ufiebi ǝmǝ eso wánkɛ kɛnyɛ ale. ");
INSERT INTO lip_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Disiale fɛ bɔ́yɛ búsu búdufǝ kaka baakpo Ɔklɔ eto Kǝńyǝnkɔ ka lɛlɛkɛ ka dimensitsyo ku umǝ wǝ baakpo Lasea. ");
INSERT INTO lip_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Nya se búkedi eyi kpǝ lǝ kusu ko bɔnyɛ esoo, Yudafɔ eto kɛnyɛ leklefe ébofe. Nya bɔyɛ lǝ ntu ǝsuǝ lǝ lefe nǝmfo ebubǝ ɛkɛ ale eso. Lǝ nyamfo esoo, Paulo álɛ mǝ kɔlɛ nkǝ, ");
INSERT INTO lip_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Boanto mǝǝ, nnyǝ minkǝ bo kusu bɔyɛ idu mɔmɔ ɛntɔ ǝbǝ ale bɔkɛ kaso, itsyise ɔklɔ ǝmfo ebudufǝ lǝ bulǝ ǝsuǝ, nya asa kpǝ ku betidi tsya ebɔtsylɔ.” ");
INSERT INTO lip_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Fɛɛ bamamanyǝ eto uninǝ ǝmfo áfo ɔklɔ ǝmǝ eto okanka ku ɔklɔ sate eto lesa nǝ bátɛyi ɔ́nɔ enso nnya Paulo lɛtɛyi. ");
INSERT INTO lip_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Nyaso se ɔnwɛkǝtsyǝkɔ kamǝ mánlɛkɛ itǝ lefe kentsyɛ se lɛyɔ lefe nlɛ bubǝ esoo, mba wǝ ku mǝ nyɛ kusu átɛyi bǝnkǝ bala bǝ baayɛ besu bedufǝ Foinike bomu. Mfoti ebɔlɛkɛ itǝ mǝ bɔkɛ lǝ lɛyɔ lefe nǝmǝ. Itsyise Foinike eyifo umǝ lǝ Kreta eto kasɔ eto kaka kakɔlɔ kpǝ lǝǝtsyǝ ɔnwɛ nnya leeti ufiebi kusu lǝ kofe eto diyo kedufǝkɔ eti. ");
INSERT INTO lip_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Lǝ lefe nǝmfó ufiebi sɛɛ utsyuǝ etsyiko bɔsɔ ketsyi Ɔnwɛdikue eti, nya iyifo fe yɔɔlɛkɛ itǝ kusu bɔyɛ. Lǝ nyaso bǝmuǝ ǝsuǝ nya bédu báyɛ lǝ Kreta ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Fɛɛ lamfolamfoo, ufiebi bua utsyuǝ ko dítsyiko bɔsɔ itsyi lǝ kodiani eto lekpake itsyi lǝ Kreta eti. ");
INSERT INTO lip_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Nya ɔ́sɔ útsyi ɔklɔ ǝmǝ eto sɛtɔ óbesǝ kato. Bala bǝ lǝ yɔɔlɛkɛ lǝ batsyi ɔklɔ ǝmǝ eto ǝnǝmi bawuninsǝ besuko kasɔ eti, tsya bamfo. Nyaso báyani wǝ nya ufiebi ǝmǝ lɛsɔ útsyi wǝ ɔ́yɛnko. ");
INSERT INTO lip_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Nya kama kamaa, búsu búnyǝ kabiɔnkɔ sɛkɛ kǝtsyuǝ lǝ kasɔ ka ntu letsyilama ka baakpo Kauda eto kutsyǝ kɔni. Nya disiǝale fɛ bófo bo ɔklɔ kɛkɛ ǝmǝ botsyasǝ lǝ ɔkplɛ wǝ ǝsuǝ bunsi. ");
INSERT INTO lip_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Nya se bǝnyǝ bǝ bulǝ saa ensibǝǝ, béfi kekuǝ bákle ɔklɔ kplɛ ǝmǝ tsya. Báte sikpi bǝnkǝ ufiebi ebɔsɔ utsyi wǝ usu okpe lǝ kota eto kɔwunimi bua ǝsuǝ lǝ Libia eto lekpo kɛnyɛ. Nyaso bábokosǝ ufiebi nto mfia bo bátsyasǝ lǝ ɔklɔ ǝmǝ ǝsuǝ kasɔ. Lǝ nyamfo eso ufiebi ǝmǝ ǝnǝ wǝ ɔ́yɛnko. ");
INSERT INTO lip_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Se kale dísiǝ fɛ ufiebi ǝmǝ dímanyɛ tɔ bɔsɔɔ, bétsyiko bikǝ bia nkpe lǝ wǝ kafo bulǝkǝ kato kakpe lǝ ntu ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Nya lǝ diyi tsyǝfǝ ǝsuǝǝ, bétsyiko ɔklɔ ǝmǝ eto biyifokǝ kpǝ tsya bɔsɛ kato kakpe. ");
INSERT INTO lip_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Lǝ eyi kpǝ nnya dítǝkǝǝ, ufiebi ǝmǝ ásɔ kekleke isi eso itǝ bǝ bóǝnyǝ kofe nye befandebi. Nya itǝ bǝ bo kpǝ ménsibe kusu boǝ busi bɔɔkɛ nkpǝ kon! ");
INSERT INTO lip_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Nya lefe kpǝ ǝbǝ léfe bankɛ kɔni bendi lesa, mfó Paulo létaka úńyǝ lǝ mǝ ǝnǝmi nya ɔ́tɛyi mǝ nkǝ, “Mɔ bayimi, lǝ nnya ete bɛnɔ mɔ etikii, eni bóendu lǝ Kreta, enni asa nyamfo kenke mǝmbǝ itsyǝ bo mmǝ. ");
INSERT INTO lip_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Nyaso nlɛ mi lekpakpa tinti minkǝ bekpe utu, ɔklɔ ǝmǝ ebonya, fɛɛ bo kuutsyuǝ saa embukpǝ! ");
INSERT INTO lip_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Itsyise kǝnǝ ku ketsyee, Onanto wǝ mbǝ mɛ ini wǝ meesumuu, wǝ ɔtɔnkpe ǝbǝ úńyǝ mɛ lǝ ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Nya ɔ́tɛyi mɛ nkǝ, ‘Paulo, mensite sikpi. Ele bǝ efi fǝ ditiki ǝsuko Kaisare ǝflɔ! Itsyise Onanto kpe kafo ɛkpɛ, úńyǝ fonko mba nyɛ kusu kaminsǝ eso mi kutsyuǝ saa embonya.’ ");
INSERT INTO lip_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Nyaso mɔ betidi, bimuǝ utu bɛlɛ! Mfo Onanto nnɔ, lesa saa ebubǝ itǝ fe kase ɔ́tɛyi mɛ. ");
INSERT INTO lip_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Fɛɛ ele bǝ ɔklɔ ǝmǝ su ɔsi lǝ kɔwunimi ǝsuǝ lǝ kasɔ ka ntu letsyilama.” ");
INSERT INTO lip_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Nya ufiebi dísukosǝ bɔsɔ ketinkǝsǝ bo sɛtɔ ku kama lǝ Adria eto lekpo ǝsuǝ itǝ lefosi eyi ana. Nya lǝ lefosi diyi nale eto ntsyentii, bo ɔklɔ ǝmǝ eto beyifoyifo ebu bǝnkǝ bɔɔnyi bafi kasɔ kǝtsyuǝ. ");
INSERT INTO lip_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Mfo nya bésusu ntu bomǝ eto letsyobi bábe, nya bǝnyǝ bǝnkǝ ntu bomǝ eto letsyobi eyifo fe akpa kolofa akpafosi ǝnuǝ. Nya se besi báyɛ bésu sɛtɔ sɛkɛɛ, besi bésusu nya bǝnyǝ bǝ ntu bomǝ eto letsyobi eyifo akpa afosi ɔwɔnɔmbǝ. ");
INSERT INTO lip_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Nya se báte sikpi bǝnkǝ ufiebi ebɔsɔ utsyi ɔklɔ ǝmǝ usu ɔsɔ lǝ abansǝ ǝtsyuǝ ǝsuǝ esoo, báyani bitu bena bia nkpe kalende tinti lǝǝmuǝ ɔklɔ kǝńyǝnsǝ lǝ kalebe kani. Nya bǝńyǝ nya bákato ola kekleke bǝ kale lǝ kǝsiǝ mlǝ. ");
INSERT INTO lip_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Nyaso se ɔklɔ ǝmǝ eto beyifoyifo léla bǝ lǝ betsyetsyi bedu esoo, bǝlǝkǝ ɔklɔ kɛkɛ ǝmǝ bǝtǝkǝ lǝ ntu ǝsuǝ nya báko bátɛyi bǝnkǝ bála bǝ babe lǝ ɔklɔ kplɛ ǝmǝ eto sɛtɔ sia bákpe bitu bia nkpe kalende ebofo ɔklɔ ǝmǝ bumuǝ kǝtsyǝ. ");
INSERT INTO lip_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Fɛɛ Paulo átɛyi bamamanyǝ ku mǝ uninǝ nkǝ, “Lǝ betidi bamfo mankɛ lǝ ɔklɔ ǝmfo kafoo, biukpǝ.” ");
INSERT INTO lip_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Nyaso bamamanyǝ bamfo ála ukuǝ wǝ lɛkɔbe ɔklɔ kɛkɛ ǝmǝ ɔnlɛ, nya báyani wǝ bákpe lǝ ntu bomǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Nya lefe nǝ kale nlɛ busiǝǝ, Paulo álɛ mǝ lekpakpa nkǝ mǝmblɛ di lesa. Nya usi ɔ́tɛyi mǝ nkǝ, “Eyi lefosi ana nɛ se bɔkɛ lǝ bulǝ ǝsuǝ nya mi kuutsyuǝ saa ménsifi tɔ kulesa okpe kɛnyɛ. ");
INSERT INTO lip_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Lǝ nyaso nlɛ mi lekpakpa minkǝ, bidi lesatsyuǝ lǝ binyǝ ǝsuǝale itǝ bǝ biembukpǝ. Itsyise lɛ ɔsɔsɔ ɔni embusiǝ lǝ mi ǝsuǝ.” ");
INSERT INTO lip_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Nyaso Paulo éfi didisa, nya se ɔ́sɔ Onanto ani lǝ mǝmblɛ eto ǝnǝmi mfóo, úbudi lesa nǝmǝ ditsyuǝ údi. ");
INSERT INTO lip_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Lamfolamfoo, utsyuǝ saa eto utu ǝsiǝǝ kasɔ nya mǝmblɛ dítsyiko lesa nǝmǝ budi. ");
INSERT INTO lip_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Betidi ba lɛkɛ lǝ ɔklɔ ǝmǝ kafo eyifo betidi alofa ǝnuǝ awosi akuanse ku ekua. ");
INSERT INTO lip_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Nya se bédi bálosǝǝ, betidi bamǝ esi bǝlǝkǝ bidikǝ bia kenke díbu lǝ ɔklɔ ǝmǝ kafo bákpe lǝ ntu ǝsuǝ, itǝ bǝ ɔklɔ ǝmǝ átaka kalende. ");
INSERT INTO lip_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Lefe nǝ kale dísiǝ kakpaa, bǝnnyǝ lekpo kɛnyɛ bǝtsyǝ lekpo mfó. Fɛɛ bǝnyǝ ɔklɔ eto ɔnwɛkǝtsyǝkɔ kǝtsyuǝ lǝ lekpo kɛnyɛ mfó kaka beebu bǝ yɔɔlɛkɛ bǝ bayɛ lǝ besu bǝńyǝnsǝ ɔklɔ ǝmǝ. ");
INSERT INTO lip_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Nyaso bala kekue ka lɛkɔbe bitu bia lǝǝmuǝ ɔklɔ kǝnyǝnsǝ, nya bányankli kekue ka lɛkɔbe ɔklɔ ǝmǝ eto nnya laate wǝ kusu lǝ ɔlɛ bɔyɛ. Nya bábesǝ ɔklɔ ǝmǝ eto mfia bo ufiebi leetsyi itǝ lǝ ufiebi ǝmǝ lǝ unǝ mǝ ɔyɛnko usuko. ");
INSERT INTO lip_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Nya se báyɛ bantɔɔ, ɔklɔ ǝmǝ ésu ɔ́si lǝ kɔwunimi ǝsuǝ itǝ bǝ wénsifo bɔyɛ bio. Nya se ufiebi tsya nlɛ bɔsɔ kǝkǝ wǝ kama esoo, óba úsensǝ kenke. ");
INSERT INTO lip_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Nya se bamamanyǝ bamfo díbu bǝ mba bákpe lǝ Aba eto diyo bamǝ ebutsyetsyi beduu, bǝlǝkǝ nsusu bǝ lǝ basɔ mǝ balo. ");
INSERT INTO lip_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Fɛɛ se mǝ ɔtɔnkotɔnko ǝmfo léla nkǝ woafo Paulo lǝ nkpǝ esoo, wántɔnɔ ku mǝ. Nyaso útǝ kusu nkǝ nwǝ kee loofoo, lǝ basa bedufǝ lǝ ntu bomǝ ǝsuǝ lǝ bake babɔ. ");
INSERT INTO lip_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Nya mba luubu tsyaa, lǝ bǝsiǝ lǝ ɔklɔ ǝmǝ eto kǝtsyǝ ku lesa nǝ kee loofo mǝ butsyi kayɛnko lǝ ntu bomǝ ǝsuǝ kabɔsǝ kesuko utuflɔ. Lǝ nyaso bomblɛ éyifo nko nya bɔ́bɔ búsu lekpo kɛnyɛ mfó, bo kutsyuǝ saa ménkpǝ. ");
INSERT INTO lip_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Lefe nǝ bɔ́bɔ bófe lǝ bulǝ bomǝ ǝsuǝǝ, búsu bóte boǝnkǝ mfó ni kasɔ ka ntu letsyilama baakpo Malta. ");
INSERT INTO lip_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Nya kasɔ kamfo eto betidi léfo bo kukɔnɔ. Lefe nǝmfo eyifo ɔsɔmi ku lɛyɔ lefe, nyaso bátsyaka ute kplɛ lǝ lekpo kɛnyɛ bǝtǝ bo nya báfo bo kukɔnɔ. ");
INSERT INTO lip_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Nya lefe nǝ Paulo nlɛ atɔni ǝtsyuǝ bɔsɛ lǝ ubǝ okpe lǝ ute ǝmǝ ǝsuǝ, owa utsyuǝ ko lɛbɔ lǝ atɔni nyamǝ nti itsyi lǝ ute ǝmǝ eto lɛyilabi eso, nya óbe ɔ́yɛ ókle Paulo eto kɔni. ");
INSERT INTO lip_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Nya se mfó eto betidi dínyǝ bǝ owa ǝmfo faka lǝ wǝ kɔni ǝsuǝ, bátɛyi bǝnkǝ, “Utidi ǝmfo eyifo nwǝ laalo betidi. Nyaso itǝ bǝ ɔbɔ utsyi lǝ lekpo eto ukpǝ kǝmiǝ tsyaa, bo Ufiǝ ɔnukualɛ embɔtɔnɔ nkǝ usiǝ nkpǝ.” ");
INSERT INTO lip_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Nya Paulo lɛwunya wǝ lǝ wǝ kɔni ókpe lǝ ute ǝmǝ kǝmiǝ nya kulesa saa ményifo wǝ tsya. ");
INSERT INTO lip_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Nya betidi ba díńyǝ banlɛ wǝ bobee, díbu bǝ wɔɔfɔ nye wɔɔsɔ kasɔ ukpǝ lamfolamfo. Nya se bǝńyǝ bábe wǝ ɛklɛɛ fɛ kulesa mǝmbǝǝ, bétsyi mǝ nsusu lǝ wǝ ǝsuǝ báwuninsǝ nya bátɛyi bǝnkǝ ufiǝ utsyuǝ uni. ");
INSERT INTO lip_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Nya kaka búsu bɔ́yifǝ mfóo, éyifo kasɔ ka lɛfi Oka Publio eto diyo. Nya oka ǝmfo tsya léfo bo ku disuǝyuǝ, nya óbe bo itǝ eyi ǝtsyǝ sɔ̃ɔ̃. ");
INSERT INTO lip_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Lǝ lefe nǝmfo tututu, Publio eto anto ánɔ bufi. Atikesi ǝmuǝ wǝ, nya ɔnlɛ kafo boto tsya. Nya se Paulo dísu wǝ ɔflɔ lǝ diyo nya óto ola nya úfi ani útǝkǝ lǝ wǝǝ, bufi bomǝ áyɛ wǝ. ");
INSERT INTO lip_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Se bánɔ bǝ bufi bomǝ áyɛ wǝǝ, befimfi ba kenke nkpe lǝ kasɔ kamǝ mǝmblɛ ábɔ bǝbǝ, nya Paulo létsya mǝ. ");
INSERT INTO lip_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Nya lǝ eyifosa nyamfo esoo, bátsyɛ bo asa kpǝ. Nya se lefe léyo bǝ budu mfoo, báboko bo asa kpǝ bǝ bufi bɔyɛ kusu. ");
INSERT INTO lip_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Búsiǝ mfó éfo afa ǝtsyǝ fɛ búdu. Lefe nǝ bɔnlɛ buluu, búsiǝ lǝ ɔklɔ wǝ baakpo bǝnkǝ Bafimfi Eto Bǝfiǝ wǝ dítsyi Aleksandria wǝ díbǝ úńyǝ lǝ kasɔ kamfó lǝ lɛyɔ lefe nǝmǝ mfó. ");
INSERT INTO lip_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Se búdu mfóo, umǝnkplɛ wǝ búsu búńyǝ ni Sirakusa. Nya búsiǝ mfo tsya eyi ǝtsyǝ. ");
INSERT INTO lip_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Se búdu mfóo, bɔyɛ búsu búdufǝ Regio. Nya se kale dísiǝǝ, ufiebi sɛɛ etsyiko bɔsɔ ketsyi bo kama wǝ lɛwunsǝko bo, wǝ lékpa bo úsuko Puteoli lǝ diyi nuǝfǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Nya mfóo, búsu búnyǝ mba bafokanɔfɔ bǝtsyuǝ, nya bálɛ bo lekpakpa bǝ busiǝ lǝ mǝ ɔflɔ eyi akuanse. Lǝ nyamfo eto kama se búdu mfóo, búsu búdufǝ Roma. ");
INSERT INTO lip_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Nya se bayimi ba nkpe lǝ Roma tsya lɛnɔ bǝ bokpe kusu bɔlɛ bubǝǝ, bǝtsyuǝ ba dítsyi faa ǝbǝ bákɔ lǝ bo lǝ Apia eto asi. Nya bǝtsyuǝ tsya díbǝ bákɔ lǝ bo lǝ kaka baakpo Nsɔnɔkɔ Ntsyǝ. Se Paulo dínyǝ mǝǝ, ɔsɔ Onanto ani, nya isi ékpe wǝ nkɛale enso. ");
INSERT INTO lip_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Nya lefe nǝ búsu búdufǝ Romaa, bǝtǝ Paulo kusu bǝ úsiǝ kaka woala. Nya bǝtǝ kusu bǝ bamamanyǝ bamǝ eto ɔni kase wǝ. ");
INSERT INTO lip_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Lǝ eyi ǝtsyǝ kamaa, Paulo ákpadi Yudafɔ eto batɔnkotɔnko ba nkpe lǝ mfó kenke bǝbǝ básɔ lebo. Se bátsyaa, ɔ́tɛyi mǝ nkǝ, “Mɔ bayimi, Yudafɔ ba nkpe lǝ Yerusalem dímuǝ mɛ nya befi mɛ bésu bǝtǝ Romafɔ eto Aba bǝnkǝ okponko mɛ lekpo lǝ lefe nǝ eto lefe nǝ ményifo bo Yudafɔ eto kutsyuǝ saa kulesa nye ńta bo banamǝ eto lekpa saa mbu. ");
INSERT INTO lip_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Romafɔ bamfó ákponko mɛ lekpo nya bála bǝ lǝ bayani mɛ. Itsyisee, bǝnnyǝ lesa nǝ ǝsuǝ bɔɔyɛ balo mɛ nye balo mɛ dikpi fe kase Yudafɔ eto beninǝ ba dimuǝ mɛ lela. ");
INSERT INTO lip_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Nya lefe nǝmfo se Yudafɔ bamfó dímantɔnɔ lǝ nyamfó ǝsuǝǝ, ɔ́tɔnɔ nkǝ ntɛyi mǝ lǝ nla miǝ bakpa mɛ lǝ nsu nnyǝ Okankplɛ Kaisare kosate ɔflɔ. Nya yenyifo mɔ lelabi miǝ maala bo kasɔ eto betidi kɛnyɛ. ");
INSERT INTO lip_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Nyamfo eso mínkpadi mi lǝ ndiko mi etiki nɛ. Itsyise Nwǝ Onanto Lékpo Ɔhile Utsyǝ ini Israelfɔ kenke eto nwǝ banlɛ kusu bobee, wǝ ni nwǝ mimfo minɔ miǝ wǝ ni nwǝ eso baakpe mɛ lǝ amana ǝsuǝ nɛ.” ");
INSERT INTO lip_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Nya bátɛyi wǝ bǝnkǝ, “Bo alɛɛ, bóamfo tɔ kulesa itsyi lǝ fǝ ǝsuǝ. Nya bóamfo kukue nye kɛnyɛ bua saa lǝ fǝ ǝsuǝ itsyi lǝ bayimi ba dítsyi Yudea bǝbǝ bo ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Fɛɛ bola boǝ boanɔ lesatsyuǝ itsyi lǝ lesa nǝ fáfo fánɔ mfo ǝsuǝ. Itsyise sintintii, baantɛyi kulesa sɛɛ sa itsyi lǝ ditsyukpa nǝmfo ǝsuǝ ku kalebe saa.” ");
INSERT INTO lip_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Nyaso bǝtsyǝ wǝ diyi lɔni, nya betidi kpǝ díbǝ wǝ ɔflɔ. Mfo nya údi mǝ etiki itsyi lǝ Onanto eto sekakedikɔ ǝsuǝ. Nya ókpa mǝ nsusu úsuko kaka Moses ku Onanto eto bǝnyɛlǝkǝtidi lɛwɔni asa bǝtsyǝ itsyi lǝ Yesu ǝsuǝ. Nya údi mǝ etiki idu lǝ olesiǝ isu ese lǝ ditsyitsyo lefe. ");
INSERT INTO lip_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Nya betidi bǝtsyuǝ lǝ mǝ nti léfo wǝ bánɔ, fɛɛ bǝtsyuǝ tsya dímamfo lesa nǝ ɔ́tɛyi banɔ. ");
INSERT INTO lip_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Nya etiki nyamfo léboko kǝnǝ lǝ mǝ nti. Nya se banlɛ busǝnsǝ keluu, Paulo átɛyi mǝ etiki fɛfɛ nǝmfo nkǝ, “Ɔnukualɛ uni bǝ Lɛwɔnɔ Kɛnkɛ lɛyɛ lǝ Yesaya ǝsuǝ nya ɔ́tɛyi bo banamǝ bǝnkǝ, ");
INSERT INTO lip_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘Bisu bikatɛyi Yudafɔ bǝnkǝ, “Biɔnɔ fɛ biǝmbɔnɔ kasɔ, nya buinyǝ nya biǝmbunyǝ fɛ bisu bete.” ");
INSERT INTO lip_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Itsyise betidi bamfo eto ketu kpe ale, nya mǝ ato etidi, nya béti mǝ ǝnǝmi tsya. Lenni nko innii, eni ele bǝ mǝ ǝnǝmi nnyǝ, nya mǝ ato tsya ebɔnɔ, nya mǝ nsusu tsya ebokpa kɛ̃ bǝ lǝ batsyi bawuninsǝ lǝ bǝbǝ mɔ ɔflɔ bǝ lǝ mɔ, Onantoo, lǝ ntsya mǝ.’ ” ");
INSERT INTO lip_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","29","Nya Paulo lélosǝ wǝ etiki nyamǝ nkǝ, “Ele bǝ ntɛyi mi lǝ bete biǝnkǝ, ditiki nǝ Onanto luufi ofo betidi lǝ nkpǝǝ, béfi ni bésuko mba lenni Yudafɔ. Nya mǝǝ, boofo ni banɔ!” ");
INSERT INTO lip_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Nya Paulo lɛkɛ mfoó alɛ ǝnuǝ lǝ diyo nǝ ófo úkafó kayo, nya úkafo betidi ba kenke ba díkǝbǝ wǝ ɔflɔ. ");
INSERT INTO lip_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Óbe Onanto eto sekakedikɔ letsya ku wǝ utu ku ǝsuǝale útǝ mǝ, nya óte mǝ asa nnya lɛyɛ lǝ Bonanto Yesu Kristo ǝsuǝ. Nya kutsyuǝ saa ménti wǝ kusu. ");
INSERT INTO lip_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Mɔ, Paulo, wǝ ni Yesu Kristo eto uyifoyifo, nya mini nwǝ bátsyese ku Onanto dílǝkǝ nkǝ mbé wǝ Ditiki Sɛɛ letsyaa, mɔ ni nwǝ lɛwɔni kukue komfo nɛ. ");
INSERT INTO lip_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Onanto eto Ditiki Sɛɛ nǝ ɔ́tɛyi wǝ bǝnyɛlǝkǝtidi ba úlǝkǝ útsyǝ nkǝ wuulǝkǝ ote kawunsiǝ fe kase báwɔni bákpe lǝ Awɔnisa Kɛnkɛ eto Kukue ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Katɛyiketsye kamfo etsyi lǝ Onanto eto Ubi wǝ ni Bonamute Yesu Kristo ǝsuǝ. Bále wǝ fe kawunsiǝ kamfo eto utidi wǝ ni Oka David eto kafo eto ubi. ");
INSERT INTO lip_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Nya ɛyɛ lǝ Lɛwɔnɔ Kɛnkɛ ǝsuǝǝ, Onanto ǝlǝkǝ wǝ óte betidi lǝ wǝ ǝsuǝale ǝsuǝ nkǝ wǝ ni wǝ ubi wǝ ótakasǝ utsyiko ɔkɔmǝ. ");
INSERT INTO lip_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Nya ɛyɛ lǝ Kristo ǝsuǝǝ, Onanto ǝnyǝ bo kaminsǝ nya úfi bo úyifo wǝ batɔnkpe itǝ Kristo bǝ lǝ butǝ kawunsiǝ eto betidi lǝ bafo wǝ banɔ lǝ beyifo wǝ lelabi. ");
INSERT INTO lip_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Nya mimba nkpe lǝ Roma tsya, eyifo betidi ba Onanto lékpadi nkǝ bibǝ befiani Yesu Kristo eto bale. ");
INSERT INTO lip_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Nyamfo eso minlɛ kukue komfo bɔwɔni kǝtǝ mi mba kenke nkpe lǝ Roma nya Onanto laala mi, nya ókpadi mi nkǝ, bibǝ befiani wǝ bale nɛ. Boanto Onanto ku Bonamute Yesu Kristo eto lefonǝ ku diyuǝ lǝ disiǝko mi. ");
INSERT INTO lip_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Ditutɛɛ, nyɛ lǝ Yesu Kristo ǝsuǝ nlɛ mɔ Onanto ani bɔsɔ lǝ mi disi, itsyise kawunsiǝ eto betidi kenke ánɔ kase béfo Onanto bɛnɔ. ");
INSERT INTO lip_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Onanto wǝ eto keyifo meeyifo ku kafo faa, nwǝ eto Ditiki Sɛɛ nǝ maabe letsya itsyi lǝ wǝ ubi ǝsuǝǝ, wǝ ni futsyǝ luulǝkǝ ote nkǝ maanta mi ǝsuǝ kulefe lǝ nlɛ ola boto nɛ. ");
INSERT INTO lip_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Nya lefe saa nǝ minlɛ ola botoo, maalɛ Onanto lekpakpa minkǝ lǝ iyifo wǝ lelabii, lǝ nyǝ kusu lǝ mbǝ nyǝ mi lǝ lefe nǝmfo ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Iyifo mɔ lelabi kekleke bǝ lǝ mbǝ nnyǝ mi lǝ nwunsǝko mi lǝ lɛwɔnɔ ǝsuǝ bǝ lǝ binyǝ ǝsuǝale. ");
INSERT INTO lip_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Lesa nǝ minlɛ bɔtɛyi mfo ni bǝnkǝ lǝ bokpe bo ǝsuǝ nkɛale lǝ lefe nǝmfo kemiǝ, lǝ mi bofokanɔ lǝ bokpe mɛ nkɛale, lǝ mintsya lǝ nkpe mi nkɛale. ");
INSERT INTO lip_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Mɔ bayimi, nla miǝ bete biǝnkǝ iyifo mɔ ketsyue lǝ lefe kpǝ ǝsuǝ bǝ lǝ mbǝ mi ɔflɔ, fɛɛ yǝntǝ mɛ kusu nko. Iyifo mɔ lelabi bǝnkǝ nwunsǝko betidi lǝ bafo Kristo banɔ lǝ mi nti fe kase mínyifo lǝ betidi ba lenni Yudafɔ bamba nti. ");
INSERT INTO lip_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Nko eto keyifo kamfo eyifo lesa nǝ ele bǝ nyifo ntǝ utidi saa, Grikifɔ ku mba lenni Grikifɔ, ku betidi ba nyi ekue ku mba lenyi ekue tsya. ");
INSERT INTO lip_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Lǝ nyamfo eso maabɛbɛ kekleke bǝ mbǝ ntɛyi mi mba nkpe lǝ Roma tsya Ditiki Sɛɛ nǝmfo. ");
INSERT INTO lip_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Ditiki Sɛɛ nǝmǝ eto bɔtɛyi anlɛ mɛ kofani, itsyise iyifo Onanto eto ǝsuǝale nya lǝǝtǝ utsyuǝ saa wǝ laafokanɔ lǝ unyǝ nkpǝ. Yudafɔ ni betutɛ ba lɔɔnɔ fɛ mba lenni Yudafɔ lǝ bǝtǝkǝ. ");
INSERT INTO lip_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Ditiki Sɛɛ nǝmfo ǝǝlǝkǝ kusu sɛɛ ko lǝǝlǝkǝ Onanto eto lelabi kate. Nya kusu sɛɛ komfo etsyi lǝ bofokanɔ ǝsuǝ idu lǝ kasɔ ketsyikokɔ isu ese lǝ kalosǝkɔ. Lǝ fe kase báwɔni lǝ Awɔnisa Kɛnkɛ eto Kukue ǝsuǝ bǝnkǝ, “Utidi wǝ ke ni ɔsɛɛ lǝ Onanto eto ǝnǝmi ɛyɛ lǝ bofokanɔ ǝsuǝǝ, wǝ hã luusiǝ nkpǝ nɛ.” ");
INSERT INTO lip_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Onanto ǝǝlǝkǝ wǝ lɛblɔfi itsyi taa kato kate lǝ asa nnya dińyǝ wǝ ǝsuǝ ku asa bua eto eyifosa nnya leeti betidi kusu bǝ lǝ bayɛ ɔnukualɛ ǝmǝ kosate bote. ");
INSERT INTO lip_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Wǝǝnyǝ ɔblɔ itsyise betidi ǝǝnyǝ Onanto eto asa nnya úyifo ketsye lekpo wuee. Itsyise Onanto kosate dílǝkǝ nnya wuee óte mǝ. ");
INSERT INTO lip_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Itsyise idu lǝ lefe nǝ Onanto díyifo kawunsiǝǝ, asa nnya kenke úyifo utsyǝ lǝ kee, ǝǝlǝkǝ Wǝ ǝsuǝale manlo nnya boǝnnyǝ ku wǝ ditsyǝbi boǝnnyǝ ku bo ǝnǝmi kate. Nyaso kuutsyuǝ saa bio ǝmbofo bɔtɛyi nkǝ woamfo Onanto ɔnɔ. ");
INSERT INTO lip_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Ite bǝ betidi yi Onanto tsyaa, beemfi dibu nǝ dińyǝ itǝ wǝ kǝtǝ wǝ. Nya baansɔ wǝ ani tsya. Lǝ nnya kɛnyɛɛ, asa bimba eto disi ete beebu. Nsusu sɛ saa ǝmbǝ mǝ nya mǝ nsusu leena tũũ. ");
INSERT INTO lip_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Nya bǝǝnyǝ mǝ ǝsuǝ fe babesibe, fɛɛ bamumu beni. ");
INSERT INTO lip_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Nya baayɛ Onanto wǝ ni nkpǝ kenke busumu, kefi atɛsǝ kǝtǝ asa bimba nnya lǝmbǝ nkpǝ. Beefi asa fe utidi nye baklɔbɛ nye bebuki akpa ana nye bebuki ba laakpi lǝ kasɔ fe owa eto okle kesumu bon. ");
INSERT INTO lip_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Lǝ nyasoo, Onanto ǝlǝkǝ mǝ ani, nkǝ beyifo lesa nǝ kee baala. Nya beefi mǝ ǝsuǝ eto sinǝ keyifo asinsa ku afanisa ku mǝ betsyuǝ. ");
INSERT INTO lip_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Nya beefi bidiatɛyitɛyi kǝtsyǝ lǝ Onanto eto Ditiki Sɛɛ nǝmǝ eto kɛnyɛ. Bomu lǝ kedi bufi kǝtǝ Onanto eto kɛnyɛɛ, beefi ke kǝtǝ asa nnya Onanto ǝmǝ díyifo. Fɛɛ Onanto kosate wǝ dińyǝ utǝ atɛsǝ lefe saa, wǝ ele bǝ besumu nɛ. Ibǝ itǝ nko. ");
INSERT INTO lip_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Asa nyamfo eto okle eto buyifo eso Onanto léyani betidi bamfó nɛ, nya beeyifo asa nnya ni mǝ sinǝ eto alasa nnya lǝǝnǝ mǝ kakpe lǝ afanisa ǝsuǝ. Nya besio kulaa tsya laayani basani ketsye kesu kalabeko mǝ besiotsyuǝ nnya lanyɛ lǝ kusu ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Nya nko ke ini bǝ mǝ basani tsya laayani besio ketsye nya beeyifo afanisa nyamfo eto okle kalabeko bǝtsyuǝ fe sisǝ ku sisiǝ seka. Nya lǝ nyamfo esoo, Onanto ǝnǝ mǝ koto ko dińyǝ itǝ mǝ lǝ mǝ ditsyǝbi bua nǝ baate mfo eso. ");
INSERT INTO lip_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Nya se báni bǝ bembokase asa nnya dińyǝ itǝ itsyi lǝ Onanto ǝsuǝ esoo, Onanto ǝlǝkǝ mǝ ani, nkǝ béyifo asa nnya dimalɛkɛ léfo mǝ nsusu kenke. Nya beeyifo asa nnya yanle bǝ beyifo. ");
INSERT INTO lip_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Nya asa bua saa yifoyifo eto okle lefo mǝ nkpǝ kenke. Nya asa bua nyamǝ ni nsusu bua fifi, kunǝnkpǝ ku kabua eto bɔbɛbɛ kǝtǝ utsyuǝ. Nnya disi iyi mǝ nkpǝ ǝsuǝ ni kǝnǝnsɛ, betidilolo ku ekiti kpɔnkpɔ ku bidiatɛyitɛyi ku kekisi ku mǝ bǝtsyuǝ eto ketikimadidi. ");
INSERT INTO lip_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Nya beedi etiki bua kabiasǝ mǝ bǝtsyuǝ eto aye. Beyifo betidi ba leekisi Onanto. Baaka bǝtsyuǝ, nya baabesǝ ǝsuǝ kato, nya baate ǝsuǝ. Nya baabɛbɛ kabua kǝtǝ bǝtsyuǝ lǝ esu kpǝ ǝsuǝ. Nya bǝǝmbu mǝ anto ku ambemǝ. ");
INSERT INTO lip_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Beyifo betidi ba lenyi kasɛɛ lǝ kabua ǝsuǝ. Nya mǝ kosate eto lesa nǝ baatɛyi tsyaa, beenyifo lǝ nnya ǝsuǝ. Bakpe lefomfi nya bǝǝnnyǝ utidi kaminsǝ nya bankpe disiale. ");
INSERT INTO lip_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Beeyi bǝnkǝ lǝ Onanto eto afi ǝsuǝǝ, betidi ba lǝǝsiǝ nkpǝ nkoo, Onanto ebolo mǝ dikpi. Fɛɛ mfe bǝǝńyǝ kekleke lǝ mǝ asa bua nyamfo buyifo ǝsuǝ nɛ. Nya inni nyamfo mate, bomu beekeko betidi ba leeyifo asa nyamfo tsya. ");
INSERT INTO lip_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Nyaso, mɔ ɔyimi, fǝ nlɛ betidi bamba lekpo bokponko? Niǝ, niǝ, niǝ inii, ǝmbofo bɔtɛyi fǝ, fǝ yɛ lǝ kusu sɛɛ ǝsuǝ. Lǝ álo fuutsyuǝ dikpii, nko ke foolo fǝ ǝsuǝ dikpi nɛ. Itsyise asa nnya beeyifoo, nnya okle ke fintsya leeyifo nɛ. ");
INSERT INTO lip_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Buyi boǝ Onanto hã ni ɔsɛɛ nya okpe ǝsuǝale bǝ okponko betidi ba leeyifo asa nyamfo eto okle lekpo. ");
INSERT INTO lip_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Nya lǝ fǝ mɔ ɔyimi, wǝ ni kawunsiǝ kamfo eto utidi wǝ leeyifo asa nyamfo eto kakle lɛ betidi bamba dikpi boloo, ebu fǝ ebofo butsyetsyi kedu lǝ Onanto eto lekpokponkpo ǝsuǝ? ");
INSERT INTO lip_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Nye ebu fǝ bimba ete ini bǝ Onanto leeyifo fǝ kafoɛkpɛ nya onkpe dibusǝ ku disuǝtsyǝ itǝ fǝ? Enyi sitinti fǝ, Onanto eeyifo fǝ kafoɛkpɛ kamfo itsyise woala nkǝ woawunsǝko fǝ lǝ atsyi awuninsǝ. ");
INSERT INTO lip_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Nya se fetidi ato, fáni fǝ ǝmbɔtsyi fǝ lɛkɔɛsi awuninsǝ esoo, fǝ kosate dítǝ Onanto lǝǝbǝ fǝ koto bunǝ kon lǝ diyi nǝ ǝsuǝ wookponko kawunsiǝ kenke lekpo tsyɔntsyɔ. Diyi nǝmfo nya wuulǝkǝ wǝ lefonyi ote nɛ. ");
INSERT INTO lip_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Nya Onanto loobofo utsyuǝ sa kayo lǝ wǝ keyifo ka úyifo kumǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Betidi ba laakpe otsyekle lǝ kasɛyifoyifo ǝsuǝ nya baabɛbɛ Onanto eto diyǝnde ku dibu ku nkpǝ manloo, Onanto ebutǝ mǝ nkpǝ manlo. ");
INSERT INTO lip_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Fɛɛ betidi ba ini kǝdiǝ hã baabɛbɛ nya beentsyue ɔnuakualɛ ǝmǝ koto, nya baala asa bua buyifoo, Onanto ebunyǝ ɔblɔ okpe mǝ unǝ mǝ koto kekleke. ");
INSERT INTO lip_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Betidi ba kenke difi asa buayifoyifo betsyi disii, ebudi ohiã nya boonyǝ kanyi. Yudafɔ luudi betutɛ, nya mba lenni Yudafɔ luutǝkǝ. ");
INSERT INTO lip_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Fɛɛ mba leeyifo asa sɛɛ, Onanto ebutǝ mǝ kato eto diyǝnde ku dibu ku diyuǝsǝ. Yudafɔ luudi betutɛ, nya mba lenni Yudafɔ luutǝkǝ. ");
INSERT INTO lip_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Itsyise Onanto ambe utidi eto ǝnǝmi fɛ woala etiki kǝlǝkǝ. ");
INSERT INTO lip_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Betidi ba kenke dímante Mose eto afi fɛ béyifo abuaa, tsya ebukpǝ banya, ite bǝ Onanto embufi afi nyamǝ okponko mǝ lekpo tsyafɛ. Fɛɛ mba nyi Moses eto afi nyamǝ fɛ beeyifo asa buaa, Onanto ebokponko mǝ lekpo ɛyɛ lǝ afi nyamǝ ǝsuǝ. ");
INSERT INTO lip_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Itsyise inni betidi ba leetsyue ato kanɔ afi nyamǝ ba luudi basɛɛ lǝ Onanto eto ǝnǝmi. Bomu, betidi ba leeyifo lǝ afi nyamǝ ǝsuǝǝ, mǝ ni mba luudi basɛɛ nɛ. ");
INSERT INTO lip_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Afi nyamfo ǝmbe mba lenni Yudafɔ, fɛɛ lǝ kawu