﻿USE sofia;
DROP TABLE IF EXISTS sofia.lin_vpl;
CREATE TABLE lin_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES lin_vpl WRITE;
INSERT INTO lin_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Na ebandeli, Nzambe akelaki Likolo mpe mokili. ");
INSERT INTO lin_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Mokili ezalaki na lolenge te mpe ezalaki pamba. Molili ezalaki na likolo ya mozindo ; mpe Molimo ya Nzambe azalaki kopepa na likolo ya mayi. ");
INSERT INTO lin_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Mpe Nzambe alobaki : « Tika ete pole ezala ! » Mpe pole ezalaki. ");
INSERT INTO lin_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Nzambe amonaki ete pole ezali malamu, akabolaki pole na molili. ");
INSERT INTO lin_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Nzambe abengaki pole « moyi, » mpe abengaki molili « butu. » Pokwa ezalaki mpe tongo ezalaki. Yango ezalaki mokolo moko. ");
INSERT INTO lin_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Bongo Nzambe alobaki : « Tika ete etando ezala kati na mayi mpo na kokabola yango ! » ");
INSERT INTO lin_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Nzambe akelaki etando ; akabolaki mayi oyo ezalaki na se ya etando na mayi ya likolo. Yango esalemaki mpe bongo. ");
INSERT INTO lin_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Nzambe abengaki etando « likolo. » Pokwa ezalaki, tongo mpe ezalaki. Yango ezalaki mokolo ya mibale. ");
INSERT INTO lin_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Bongo Nzambe alobaki : « Tika ete mayi oyo ezali na se ya likolo esangana esika moko mpo ete mabele ya kokawuka ebima ! » Yango esalemaki mpe bongo. ");
INSERT INTO lin_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Nzambe abengaki mabele ya kokawuka « mokili, » mpe abengaki mayi oyo esanganaki esika moko « ebale monene. » Nzambe amonaki ete ezali malamu. ");
INSERT INTO lin_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Nzambe alobaki : « Tika ete mokili ebimisa matiti, milona oyo ezali na nkona mpe banzete ya mbuma oyo ebotaka mbuma kolanda lolenge ya nzete moko na moko ! » Yango esalemaki mpe bongo. ");
INSERT INTO lin_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Mabele ebimisaki matiti, milona oyo ebotaka nkona kolanda lolenge ya molona moko na moko mpe banzete oyo ebotaka mbuma kolanda lolenge ya nzete moko na moko. Nzambe amonaki ete ezali malamu. ");
INSERT INTO lin_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Pokwa ezalaki, tongo mpe ezalaki. Yango ezalaki mokolo ya misato. ");
INSERT INTO lin_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Bongo Nzambe alobaki : « Tika ete biloko oyo ebimisaka pole ezala na etando ya likolo mpo na kokabola moyi wuta na butu, mpo na kozala bilembo oyo ekolakisa bileko, mikolo mpe mibu, ");
INSERT INTO lin_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","mpe mpo na kongengisa mokili ! » Yango esalemaki mpe bongo. ");
INSERT INTO lin_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Nzambe akelaki biloko mibale ya minene oyo ebimisaka pole : oyo eleki monene, mpo na kongenga na moyi ; mpe oyo ya moke, mpo na kongenga na butu. Mpe akelaki lisusu minzoto. ");
INSERT INTO lin_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Nzambe atiaki yango na etando ya likolo mpo ete engengisa mokili, ");
INSERT INTO lin_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","engenga na moyi mpe na butu, mpe ekabola pole na molili. Nzambe amonaki ete ezali malamu. ");
INSERT INTO lin_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Pokwa ezalaki, tongo mpe ezalaki. Yango ezalaki mokolo ya minei. ");
INSERT INTO lin_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Bongo Nzambe alobaki : « Tika ete bikelamu ya bomoi etonda kati na mayi, mpe bandeke epumbwa na mokili na etando ya likolo ! » ");
INSERT INTO lin_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Nzambe akelaki banyama minene ya mayi mpe bikelamu nyonso ya bomoi oyo etambolaka kati na mayi mpe etondi meke kati na mayi : ekelamu na ekelamu na lolenge na yango. Akelaki mpe bandeke nyonso ya mapapu : ndeke na ndeke na lolenge na yango. Nzambe amonaki ete ezali malamu. ");
INSERT INTO lin_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Nzambe apambolaki yango mpe alobaki : « Bobotana, bokoma ebele, botondisa mayi ya bibale, mpe tika ete bandeke ekoma ebele kati na mokili. » ");
INSERT INTO lin_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Pokwa ezalaki, tongo mpe ezalaki. Yango ezalaki mokolo ya mitano. ");
INSERT INTO lin_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Bongo Nzambe alobaki : « Tika ete mokili ebimisa bikelamu ya bomoi kolanda lolenge na yango : bibwele, bikelamu oyo etambolaka na libumu, banyama ya mike-mike mpe banyama ya zamba ! » Yango esalemaki mpe bongo. ");
INSERT INTO lin_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Nzambe akelaki banyama ya zamba kolanda lolenge na yango : bibwele mpe bikelamu nyonso ya mike-mike. Nzambe amonaki ete ezali malamu. ");
INSERT INTO lin_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Bongo Nzambe alobaki : « Tika ete tosala bato na elilingi na biso, na lolenge oyo biso tozali, mpo ete bakonza bambisi ya ebale, bandeke ya likolo, bibwele kati na mokili mobimba, bikelamu nyonso oyo etambolaka na libumu mpe banyama ya mike-mike ! » ");
INSERT INTO lin_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Nzambe akelaki bato na elilingi na Ye, akelaki bango na elilingi ya Nzambe ; akelaki bango mobali mpe mwasi. ");
INSERT INTO lin_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Nzambe apambolaki bango mpe alobaki na bango : « Bobotana, bokoma ebele, botondisa mokili mpe bobongola yango. Bokonza bambisi ya bibale, bandeke ya likolo, bikelamu oyo etambolaka na libumu mpe banyama nyonso ya mike-mike. » ");
INSERT INTO lin_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Bongo Nzambe alobaki : « Tala, kati na mokili mobimba, napesi bino milona oyo ezali na nkona mpe banzete nyonso oyo ebotaka mbuma. Yango nde ekozala bilei na bino. ");
INSERT INTO lin_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Napesi matiti nyonso ya mobesu lokola bilei epai ya banyama nyonso ya mokili, epai ya bandeke nyonso ya likolo, epai ya bikelamu nyonso oyo etambolaka na libumu, mpe epai ya bikelamu nyonso oyo ezali na bomoi. » Yango esalemaki mpe bongo. ");
INSERT INTO lin_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Nzambe atalaki biloko nyonso oyo akelaki mpe amonaki ete ezali malamu koleka. Pokwa ezalaki, tongo mpe ezalaki. Yango ezalaki mokolo ya motoba. ");
INSERT INTO lin_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Ezalaki bongo nde likolo mpe mokili ekelamaki elongo na biloko nyonso oyo ezali kati na yango. ");
INSERT INTO lin_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Na mokolo ya sambo, Nzambe asilisaki mosala oyo asalaki. Boye, na mokolo ya sambo, akataki mosala nyonso oyo azalaki kosala. ");
INSERT INTO lin_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Nzambe apambolaki mokolo ya sambo, abulisaki yango, pamba te na mokolo yango nde akataki mosala nyonso ya kokela oyo azalaki kosala. ");
INSERT INTO lin_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Tala ndenge likolo mpe mokili elongo na biloko oyo ezali kati na yango ezalaki tango ekelamaki. Tango Yawe Nzambe akelaki mokili mpe likolo, ");
INSERT INTO lin_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","ata nzete moko te ya elanga ezalaki, mpe ata molona moko te ya elanga etikalaki kobimisa moto, pamba te Yawe Nzambe anokisaki nanu mvula te na mokili, mpe moto azalaki te mpo na kolona yango na mabele. ");
INSERT INTO lin_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Kasi mayi ezalaki kobima wuta na se mpe ezalaki kopanzana na etando nyonso ya mokili. ");
INSERT INTO lin_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Yawe Nzambe asalaki moto wuta na putulu ya mabele, afulaki pema ya bomoi na madusu ya zolo na ye ; mpe moto akomaki ekelamu ya bomoi. ");
INSERT INTO lin_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Yawe Nzambe alonaki elanga moko kati na Edeni, na ngambo ya este. Atiaki moto oyo akelaki kati na yango. ");
INSERT INTO lin_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Yawe Nzambe abimisaki wuta na mabele banzete ya lolenge nyonso oyo ezalaki kitoko mpo na kotala mpe elengi mpo na kolia. Atiaki mpe nzete ya bomoi na kati-kati ya elanga ; lisusu atiaki nzete ya koyeba malamu mpe mabe. ");
INSERT INTO lin_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Ebale moko ezalaki kobima na Edeni mpe ezalaki kosopa mayi na elanga. Mayi ya ebale yango ekabwanaki na biteni minei. ");
INSERT INTO lin_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Eteni ya liboso, kombo na yango « Pishoni. » Yango ezingeli mokili mobimba ya Avila oyo mabele na yango ezalaki na wolo. ");
INSERT INTO lin_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Wolo ya mokili yango ezalaki kitoko. Ezalaki lisusu na molona ya malasi mpe na mabanga ya onikisi kati na mokili yango. ");
INSERT INTO lin_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Eteni ya mibale, kombo na yango « Giyoni. » Yango ezingeli mokili mobimba ya Kushi. ");
INSERT INTO lin_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Eteni ya misato, kombo na yango « Tigre. » Yango elekana na este ya Asiri. Mpe eteni ya minei, kombo na yango « Efrate. » ");
INSERT INTO lin_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Yawe Nzambe azwaki moto mpe atiaki ye kati na elanga ya Edeni mpo na kolona yango mpe kobatela yango. ");
INSERT INTO lin_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Mpe Yawe Nzambe apesaki mitindo oyo na moto : « Okoki kolia mbuma nyonso ya elanga, ");
INSERT INTO lin_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","kasi okolia te mbuma ya nzete ya koyeba malamu mpe mabe ; pamba te mokolo oyo okolia yango, okokufa solo. » ");
INSERT INTO lin_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Yawe Nzambe alobaki : « Ezali malamu te ete mobali azala ye moko ; nakosalela ye mosungi oyo azali ndenge moko na ye. » ");
INSERT INTO lin_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Yawe Nzambe asalaki, wuta na mabele, banyama nyonso ya zamba mpe bandeke nyonso ya likolo. Amemaki yango epai ya mobali mpo na kotala ndenge akopesa yango kombo, mpo ete ekelamu nyonso ya bomoi ebengama na kombo oyo mobali akopesa yango. ");
INSERT INTO lin_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Yango wana, mobali apesaki bakombo na bibwele nyonso, na bandeke nyonso ya likolo mpe na banyama nyonso ya zamba. Kasi amonaki te mosungi oyo akokaki kozala ndenge moko na ye. ");
INSERT INTO lin_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Na yango, Yawe Nzambe alalisaki mobali pongi ya makasi. Mpe wana mobali azalaki kolala, Yawe Nzambe azwaki mokuwa moko na mopanzi ya mobali mpe azipaki mosuni na esika yango. ");
INSERT INTO lin_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Yawe Nzambe asalaki mwasi na mokuwa oyo azwaki na mopanzi ya mobali mpe amemaki ye epai ya mobali. ");
INSERT INTO lin_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Boye, mobali alobaki : « Tala na mbala oyo, oyo azali mokuwa ya mikuwa na ngai, mosuni ya mosuni na ngai. Bakobenga ye mwasi, pamba te awuti na mobali. » ");
INSERT INTO lin_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Yango wana, mobali akotika tata na ye mpe mama na ye, akosangana na mwasi na ye, mpe bakokoma nzoto moko. ");
INSERT INTO lin_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Mobali mpe mwasi na ye bazalaki bolumbu mpe bazalaki koyokana soni te. ");
INSERT INTO lin_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Nzokande, kati na banyama nyonso ya zamba oyo Yawe Nzambe akelaki, nyoka nde elekaki na mayele mabe. Alobaki na mwasi : — Nzambe alobaki na bino solo ete bolia mbuma ata moko te ya banzete ya elanga ? ");
INSERT INTO lin_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Mwasi azongisaki epai ya nyoka : — Toliaka bambuma ya banzete ya elanga. ");
INSERT INTO lin_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Kasi na oyo etali mbuma ya nzete oyo ezali na kati-kati ya elanga, Nzambe alobaki : « Bosengeli te kolia yango, mpe bosengeli te kosimba yango ; noki te bokokufa. » ");
INSERT INTO lin_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Nyoka alobaki na mwasi : — Solo penza, bokokufa te. ");
INSERT INTO lin_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Pamba te Nzambe ayebi malamu ete mokolo oyo bokolia yango, miso na bino ekofungwama mpe bokokoma lokola Ye : koyeba malamu na mabe. ");
INSERT INTO lin_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Mwasi amonaki ete mbuma ya nzete ezali elengi mpo na kolia, kitoko mpo na kotala mpe malamu mpo na kofungola mayele. Boye azwaki mbuma mpe aliaki yango. Apesaki yango mpe na mobali na ye, oyo azalaki elongo na ye ; bongo ye mpe mobali aliaki yango. ");
INSERT INTO lin_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Mbala moko, miso na bango mibale efungwamaki, mpe basosolaki ete bazali bolumbu. Boye, basangisaki makasa ya nzete ya figi mpe bamizipaki. ");
INSERT INTO lin_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Na pokwa, bayokaki makelele ya matambe ya Yawe Nzambe kotambola kati na elanga. Boye, mobali mpe mwasi babombamaki kati na banzete ya elanga mpo na kokima Yawe. ");
INSERT INTO lin_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Kasi Yawe Nzambe abengaki mobali mpe atunaki ye : — Ozali wapi ? ");
INSERT INTO lin_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Azongisaki : — Nayoki makelele ya matambe na Yo kotambola kati na elanga mpe nabangi mpo ete nazali bolumbu ; yango wana nabombami. ");
INSERT INTO lin_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Nzambe alobaki : — Ndenge nini oyebi ete ozali bolumbu ? Boni, oliaki mbuma ya nzete oyo napekisaki yo kolia ? ");
INSERT INTO lin_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Adamu azongisaki : — Ezali mwasi oyo opesaki ngai lokola mosungi nde apesaki ngai mbuma ya nzete yango, mpe nalie yango. ");
INSERT INTO lin_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Yawe Nzambe alobaki na mwasi : — Mpo nini osali bongo ? Mwasi azongisaki : — Ezali nyoka nde akosaki ngai, mpe naliaki yango. ");
INSERT INTO lin_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Boye Yawe Nzambe alobaki na nyoka : « Lokola osali bongo, olakelami mabe kati na bibwele mpe banyama nyonso ya zamba. Okotambola na libumu mpe okobanda kolia putulu bomoi na yo mobimba. ");
INSERT INTO lin_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Nakotia koyinana kati na yo mpe mwasi, mpe kati na bakitani na yo mpe bakitani na ye. Bakitani ya mwasi bakonyata moto na yo, mpe yo okoswa bango na litindi. » ");
INSERT INTO lin_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Nzambe alobaki na mwasi : « Nakobakisa pasi na zemi na yo ; okobota na pasi. Posa na yo ekomema yo epai ya mobali na yo, kasi ye akozala mokonzi na yo. » ");
INSERT INTO lin_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Yawe Nzambe alobaki na Adamu : « Lokola oyokelaki mwasi na yo mpe oliaki mbuma ya nzete oyo, na tina na yango, napesaki yo mobeko oyo : ‹ Kolia yango te, › mabele elakelami mabe likolo na yo. Bomoi na yo mobimba, okolia na motoki na yo. ");
INSERT INTO lin_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Mabele ekobotela yo nzube mpe nzete ya sende. Okolia matiti ya bilanga. ");
INSERT INTO lin_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Okolia lipa na yo na motoki ya elongi na yo kino okozonga na mabele epai wapi owutaki, pamba te ozali putulu mpe okozonga na putulu. » ");
INSERT INTO lin_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Mobali apesaki mwasi na ye kombo « Eva, » pamba te azali mama ya bato nyonso na mokili. ");
INSERT INTO lin_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Yawe Nzambe asalelaki Adamu mpe mwasi na ye bilamba ya poso ya nyama mpe alatisaki bango yango. ");
INSERT INTO lin_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Yawe Nzambe alobaki : « Tala, moto akomi lokola moko kati na biso mpo na koyeba malamu mpe mabe. Sik’oyo, esengeli te kopesa ye nzela ya kotia loboko na ye mpo na kozwa lisusu mbuma ya nzete ya bomoi mpe kolia yango, noki te awumela libela na bomoi. » ");
INSERT INTO lin_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Boye, Yawe Nzambe abenganaki ye na elanga ya Edeni mpo ete asala mosala ya mabele epai wapi awutaki. ");
INSERT INTO lin_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Sima na kobengana moto, atiaki basheribe, na ngambo ya este ya elanga ya Edeni, na mopanga ya moto oyo ezalaki kobaluka bipai na bipai mpo na kobatela nzela ya nzete ya bomoi. ");
INSERT INTO lin_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adamu asangisaki nzoto na mwasi na ye Eva ; mpe Eva akomaki na zemi, bongo abotaki Kayina. Alobaki : « Nasali moto na lisungi ya Yawe. » ");
INSERT INTO lin_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Sima na yango, abotaki lisusu Abele, ndeko ya Kayina. Abele akomaki kobokola bibwele mpe Kayina akomaki kosala bilanga. ");
INSERT INTO lin_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Sima na mwa tango, Kayina amemaki mbuma ya mabele mpo na kobonzela Yawe. ");
INSERT INTO lin_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Abele, ye mpe amemaki bibwele oyo ebotamaki liboso kati na etonga na ye mpe biteni oyo eleki mafuta. Yawe asepelaki na Abele mpe na makabo na ye, ");
INSERT INTO lin_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","kasi asepelaki te na Kayina mpe na makabo na ye. Bongo, Kayina asilikaki makasi mpe elongi na ye ekomaki mawa-mawa. ");
INSERT INTO lin_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Yawe alobaki na Kayina : — Mpo na nini osiliki ? Mpo na nini elongi na yo ekomi mawa-mawa ? ");
INSERT INTO lin_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Boni, soki osali malamu, bakondima yo te ? Kasi soki osali malamu te, lisumu elali penza na ekuke na yo, mpe posa na yango ezali kobenda yo makasi ; kasi yo, longa yango. ");
INSERT INTO lin_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Kayina alobaki na Abele, ndeko na ye. Wana bazalaki kati na bilanga, Kayina akangaki Abele, ndeko na ye, mpe abomaki ye. ");
INSERT INTO lin_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Yawe atunaki Kayina : — Wapi ndeko na yo Abele ? Kayina azongisaki : — Nayebi te. Boni, ngai nazali mokengeli ya ndeko na ngai ? ");
INSERT INTO lin_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Nzambe alobaki : — Osali nini ? Likambo nini penza osali ? Makila ya ndeko na yo ezali koganga wuta na mabele kino epai na Ngai. ");
INSERT INTO lin_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Sik’oyo, olakelami mabe mpe obwakami mosika ya mabele oyo efungolaki monoko na yango mpo na komela makila ya ndeko na yo, oyo maboko na yo esopaki. ");
INSERT INTO lin_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Tango okobalola mabele, ekobotela yo mbuma te. Okozala koyengayenga mpe kotelengana na mokili. ");
INSERT INTO lin_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kayina alobaki na Yawe : — Etumbu na ngai eleki pasi mpo na komema ! ");
INSERT INTO lin_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Tala, obwaki ngai lelo mosika ya mabele ; nasengeli sik’oyo kobombama liboso na Yo, nakokoma koyengayenga mpe kotelengana na mokili, mpe moto nyonso oyo akomona ngai akoboma ngai. ");
INSERT INTO lin_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Kasi Yawe alobaki na ye : — Ezali bongo te ! Soki moto abomi Kayina, bakozongisa mabe mpo na Kayina mbala sambo. Mpe Yawe atiaki elembo na nzoto ya Kayina na tina ete moto oyo akokutana na ye aboma ye te. ");
INSERT INTO lin_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Kayina alongwaki liboso ya Yawe, akendeki kovanda na mokili ya Nodi, na este ya Edeni. ");
INSERT INTO lin_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kayina asangisaki nzoto na mwasi na ye ; mpe mwasi na ye akomaki na zemi, bongo abotaki Enoki. Kayina atongaki engumba. Apesaki yango kombo « Enoki, » kombo ya mwana na ye ya mobali. ");
INSERT INTO lin_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enoki abotaki Iradi ; Iradi abotaki Mewuyayeli ; Mewuyayeli abotaki Metusaeli ; Metusaeli abotaki Lemeki. ");
INSERT INTO lin_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lemeki abalaki basi mibale : moko, kombo na ye ezalaki « Ada, » mpe mosusu, « Tsila. » ");
INSERT INTO lin_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada abotaki Yabali, koko ya bavandi ya bandako ya kapo mpe ya babokoli bibwele. ");
INSERT INTO lin_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Ndeko na ye ya mobali, Yubali, azalaki koko ya bato oyo babetaka lindanda mpe flite. ");
INSERT INTO lin_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Tsila mpe abotaki mwana mobali, Tubali-Kayina, oyo azalaki kosala bisalelo nyonso ya bronze mpe ya bibende. Tubali-Kayina azalaki na ndeko mwasi, kombo na ye ezalaki « Naama. » ");
INSERT INTO lin_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lemeki alobaki na basi na ye : « Ada mpe Tsila, boyoka ngai malamu ; bino basi ya Lemeki, bolanda ngai malamu : Solo, likolo ya pota moko, ngai nabomaki moto ; mpe likolo ya mwa pota, nabomaki elenge mobali ! ");
INSERT INTO lin_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Solo, bakozongisa mbala sambo mabe oyo basali Kayina ; kasi mpo na Lemeki, ekozala mbala tuku sambo na sambo ! » ");
INSERT INTO lin_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adamu asangisaki lisusu nzoto na mwasi na ye, bongo mwasi na ye abotaki Seti, pamba te alobaki : « Nzambe apesi ngai mwana mosusu na esika ya Abele oyo Kayina abomaki. » ");
INSERT INTO lin_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Seti mpe abotaki mwana mobali, apesaki ye kombo « Enoshi. » Ezalaki na tango wana nde bato bakomaki kobelela Kombo ya Yawe. ");
INSERT INTO lin_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Tala lisolo ya libota ya Adamu. Tango Nzambe akelaki bato, asalaki bango na elilingi ya Nzambe. ");
INSERT INTO lin_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Akelaki bango mobali mpe mwasi, mpe apambolaki bango. Na mokolo oyo akelaki bango, apesaki bango kombo « bato. » ");
INSERT INTO lin_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Tango Adamu akokisaki mibu nkama moko na tuku misato ya mbotama, abotaki mwana mobali na elilingi na ye mpe na lolenge na ye. Apesaki ye kombo « Seti. » ");
INSERT INTO lin_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Sima na mbotama ya Seti, Adamu awumelaki lisusu na bomoi mibu nkama mwambe mpe abotaki bana mosusu ya mibali mpe ya basi. ");
INSERT INTO lin_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Mibu nyonso oyo Adamu awumelaki na bomoi ezalaki nkama libwa na tuku misato, sima akufaki. ");
INSERT INTO lin_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Tango Seti akokisaki mibu nkama moko na mitano ya mbotama, abotaki Enoshi. ");
INSERT INTO lin_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Sima na kobota Enoshi, Seti awumelaki lisusu na bomoi mibu nkama mwambe na sambo mpe abotaki bana mosusu ya mibali mpe ya basi. ");
INSERT INTO lin_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Mibu nyonso oyo Seti awumelaki na bomoi ezalaki nkama libwa na zomi na mibale, sima akufaki. ");
INSERT INTO lin_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Tango Enoshi akokisaki mibu tuku libwa ya mbotama, abotaki Kena. ");
INSERT INTO lin_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Sima na kobota Kena, Enoshi awumelaki lisusu na bomoi mibu nkama mwambe na zomi na mitano mpe abotaki bana mosusu ya mibali mpe ya basi. ");
INSERT INTO lin_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Mibu nyonso oyo Enoshi awumelaki na bomoi ezalaki nkama libwa na mitano, sima akufaki. ");
INSERT INTO lin_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Tango Kena akokisaki mibu tuku sambo ya mbotama, abotaki Maalalele. ");
INSERT INTO lin_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Sima na kobota Maalalele, Kena awumelaki lisusu na bomoi mibu nkama mwambe na tuku minei mpe abotaki bana mosusu ya mibali mpe ya basi. ");
INSERT INTO lin_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Mibu nyonso oyo Kena awumelaki na bomoi ezalaki nkama libwa na zomi, sima akufaki. ");
INSERT INTO lin_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Tango Maalalele akokisaki mibu tuku motoba na mitano ya mbotama, abotaki Yeredi. ");
INSERT INTO lin_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Sima na kobota Yeredi, Maalalele awumelaki lisusu na bomoi mibu nkama mwambe na tuku misato mpe abotaki bana mosusu ya mibali mpe ya basi. ");
INSERT INTO lin_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mibu nyonso oyo Maalalele awumelaki na bomoi ezalaki nkama mwambe na tuku libwa na mitano, sima akufaki. ");
INSERT INTO lin_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Tango Yeredi akokisaki mibu nkama moko na tuku motoba na mibale ya mbotama, abotaki Enoki. ");
INSERT INTO lin_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Sima na kobota Enoki, Yeredi awumelaki lisusu na bomoi mibu nkama mwambe mpe abotaki bana mosusu ya mibali mpe ya basi. ");
INSERT INTO lin_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Mibu nyonso oyo Yeredi awumelaki na bomoi ezalaki nkama libwa na tuku motoba na mibale, sima akufaki. ");
INSERT INTO lin_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Tango Enoki akokisaki mibu tuku motoba na mitano ya mbotama, abotaki Metusalemi. ");
INSERT INTO lin_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Sima na kobota Metusalemi, Enoki azalaki kosala mokano ya Nzambe mibu nkama misato mpe abotaki bana mosusu ya mibali mpe ya basi. ");
INSERT INTO lin_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Mibu nyonso oyo Enoki awumelaki na bomoi ezalaki nkama misato na tuku motoba na mitano. ");
INSERT INTO lin_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enoki atambolaki na boyengebene elongo na Nzambe ; bongo alimwaki, pamba te Nzambe azwaki ye. ");
INSERT INTO lin_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Tango Metusalemi akokisaki mibu nkama moko na tuku mwambe na sambo ya mbotama, abotaki Lemeki. ");
INSERT INTO lin_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Sima na kobota Lemeki, Metusalemi awumelaki lisusu na bomoi mibu nkama sambo na tuku mwambe na mibale mpe abotaki bana mosusu ya mibali mpe ya basi. ");
INSERT INTO lin_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Mibu nyonso oyo Metusalemi awumelaki na bomoi ezalaki nkama libwa na tuku motoba na libwa, sima akufaki. ");
INSERT INTO lin_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Tango Lemeki akokisaki mibu nkama moko na tuku mwambe na mibale ya mbotama, abotaki mwana mobali. ");
INSERT INTO lin_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Abengaki ye Noa mpe alobaki : « Ye oyo akobondisa biso na mosala mpe na pasi ya maboko na biso likolo ya mabele oyo Yawe alakelaki mabe. » ");
INSERT INTO lin_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Sima na kobotama ya Noa, Lemeki awumelaki lisusu na bomoi mibu nkama mitano na tuku libwa na mitano mpe abotaki bana mosusu ya mibali mpe ya basi. ");
INSERT INTO lin_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Mibu nyonso oyo Lemeki awumelaki na bomoi ezalaki nkama sambo na tuku sambo na sambo, sima akufaki. ");
INSERT INTO lin_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Tango Noa akokisaki mibu nkama mitano ya mbotama, abotaki Semi, Cham mpe Jafeti. ");
INSERT INTO lin_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Tango bato babandaki kokoma ebele na mokili mpe babotaki bana basi, ");
INSERT INTO lin_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","milimo emonaki ete bana basi ya bato bazali kitoko ; boye ekomisaki ba-oyo eponaki basi na yango. ");
INSERT INTO lin_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Yango wana, Yawe alobaki : « Pema na Ngai ekowumela libela te kati na moto, pamba te abengami na kokufa ; mibu ya bomoi na ye ekozala kaka nkama moko na tuku mibale. » ");
INSERT INTO lin_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Na tango wana, ezalaki na bingambe kati na mokili ; mpe lisusu, milimo esangisaki nzoto na bana basi ya bato, bongo bana basi babotelaki yango bana. Bana yango bazalaki bilombe na tango ya kala, bato oyo bakenda sango. ");
INSERT INTO lin_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Yawe amonaki ndenge nini mabe ya moto ekomaki mingi kati na mokili, mpe tango nyonso, makanisi ya motema ya moto ezalaki kaka mabe. ");
INSERT INTO lin_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Boye Yawe ayokaki mawa na ndenge akelaki moto kati na mokili mpe abongolaki makanisi na Ye. ");
INSERT INTO lin_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Boye Yawe alobaki : « Nakosilisa koboma kati na mokili bato oyo nakelaki ; solo, nakosilisa koboma bato kino na bibwele, na bandeke ya likolo mpe na bikelamu oyo etambolaka na libumu kati na mokili, pamba te nabongoli makanisi na Ngai na ndenge nakelaki bango. » ");
INSERT INTO lin_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Kasi Noa azwaki ngolu na miso ya Yawe. ");
INSERT INTO lin_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Tala lisolo ya libota ya Noa. Noa azalaki moto ya sembo mpe azanga pamela kati na bato ya tango na ye ; azalaki kosala mokano ya Nzambe. ");
INSERT INTO lin_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noa azalaki na bana mibali misato : Semi, Cham mpe Jafeti. ");
INSERT INTO lin_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Mokili ebebaki na miso ya Nzambe mpe etondaki na makambo ya mobulu. ");
INSERT INTO lin_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Nzambe amonaki ndenge mokili ebebaki, pamba te bato nyonso ya mokili babebisaki banzela na bango. ");
INSERT INTO lin_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Boye, Nzambe alobaki na Noa : « Nazwi mokano ya koboma bikelamu nyonso ya bomoi, pamba te mokili etondi na mabe likolo na bango. Solo, nakobebisa bango elongo na mokili. ");
INSERT INTO lin_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Sala masuwa ya mabaya ya goferi mpo na lobiko na yo ; kabola yango na bashambre. Okopakola gudron na kati mpe na libanda na yango. ");
INSERT INTO lin_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Tala ndenge okotonga yango : molayi na yango ekozala na bametele pene nkama moko na tuku mitano, bametele pene tuku mibale na mitano na mokuse mpe bametele pene zomi na mitano na bosanda. ");
INSERT INTO lin_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Okotia likolo na yango lidusu ya basantimetele pene tuku mitano, okotia ekuke na mopanzi na yango ; mpe na kati, okosala etaje ya liboso, ya mibale mpe ya misato. ");
INSERT INTO lin_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Nakotinda mpela na mokili mpo na koboma nyonso oyo ezali na bomoi na se na moyi : ekelamu nyonso ya bomoi oyo ezali na mabele ekokufa. ");
INSERT INTO lin_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Kasi nasali boyokani elongo na yo, yango wana okokota na masuwa : yo, bana na yo ya mibali, mwasi na yo mpe basi ya bana na yo. ");
INSERT INTO lin_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Okokotisa mpe kati na masuwa, mibale-mibale, bikelamu nyonso ya bomoi, mwasi mpe mobali, mpo ete obatela yango na bomoi elongo na yo. ");
INSERT INTO lin_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Bikelamu mibale ya lolenge moko na moko ya bandeke, ya bibwele mpe ya bikelamu nyonso oyo etambolaka na libumu ; nyonso ekoya epai na yo mpo ete obatela yango na bomoi. ");
INSERT INTO lin_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Okozwa biloko ya kolia ya lolenge na lolenge mpe okobomba yango mpo ete ezala bilei na yo elongo na yango. » ");
INSERT INTO lin_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Noa asalaki makambo nyonso ndenge kaka Nzambe atindaki ye. ");
INSERT INTO lin_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Yawe alobaki na Noa : « Kota na masuwa, yo mpe libota na yo mobimba, pamba te yo kaka nde omonani sembo na miso na Ngai kati na bato ya ekeke oyo. ");
INSERT INTO lin_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Kamata banyama sambo ya mibali mpe sambo ya basi kati na banyama ya lolenge nyonso oyo ezangi mbindo ; mpe nyama moko ya mobali mpe moko ya mwasi kati na banyama oyo ezali mbindo. ");
INSERT INTO lin_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Kamata lisusu bandeke sambo ya mibali mpe sambo ya basi kati na lolenge nyonso ya bandeke mpo ete esila te kati na mokili. ");
INSERT INTO lin_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Pamba te etikali mikolo sambo mpo ete nanokisa mvula oyo ekowumela mikolo tuku minei mpe babutu tuku minei mpe nakosilisa koboma bikelamu nyonso oyo nasala kati na mokili oyo. » ");
INSERT INTO lin_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Bongo, Noa asalaki makambo nyonso ndenge kaka Yawe atindaki ye. ");
INSERT INTO lin_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noa azalaki na mibu nkama motoba ya mbotama tango mpela eyaki na mokili. ");
INSERT INTO lin_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Noa mpe bana na ye ya mibali elongo na mwasi na ye mpe basi ya bana na ye bakotaki na masuwa mpo ete babika na mpela. ");
INSERT INTO lin_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Kati na banyama ya lolenge nyonso, moko ya mobali mpe moko ya mwasi, ezala oyo ezanga mbindo to oyo ezali mbindo, bandeke mpe banyama oyo etambolaka na libumu ");
INSERT INTO lin_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","eyaki epai na Noa mpe ekotaki na masuwa, mwasi na mobali, ndenge Nzambe atindaki Noa. ");
INSERT INTO lin_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Bongo sima na mikolo sambo, mpela eyaki na mokili. ");
INSERT INTO lin_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Tango Noa akokisaki mibu nkama motoba ya mbotama, na sanza ya mibale, na mokolo ya zomi na sambo, bitima nyonso ya se mpe maninisa nyonso ya likolo efungwamaki. ");
INSERT INTO lin_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Mvula enokaki na mokili mikolo tuku minei mpe babutu tuku minei. ");
INSERT INTO lin_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Kaka na mokolo wana, Noa mpe bana na ye ya mibali : Semi, Cham mpe Jafeti, elongo na mwasi na ye mpe basi misato ya bana na ye, bakotaki na masuwa. ");
INSERT INTO lin_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Elongo na bango, ekotaki mpe banyama ya zamba ya lolenge nyonso, bibwele ya lolenge nyonso, bikelamu ya lolenge nyonso oyo etambolaka na libumu mpe bandeke ya lolenge nyonso mpe bikelamu nyonso oyo ezali na mapapu. ");
INSERT INTO lin_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Mwasi na mobali, kati na bikelamu nyonso oyo ezali na bomoi, eyaki epai ya Noa mpo na kokota na masuwa. ");
INSERT INTO lin_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Banyama nyonso oyo ekotaki kuna ezalaki mwasi na mobali kati na bikelamu nyonso oyo ezali na bomoi, ndenge Nzambe atindaki Noa. Sima, Yawe akangaki ekuke ya masuwa. ");
INSERT INTO lin_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Mpela ewumelaki na mokili mikolo tuku minei ; mayi ekomaki ebele mpe etombolaki masuwa likolo na yango. ");
INSERT INTO lin_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Mayi emataki mpe ekomaki ebele, bongo masuwa ekomaki kotepatepa likolo ya mayi. ");
INSERT INTO lin_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Mayi emataki lisusu makasi mpe bangomba nyonso ya milayi oyo ezalaki na mokili ezindaki na se ya mayi. ");
INSERT INTO lin_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Mayi emataki lisusu likolo ya bangomba na bosanda ya bametele pene sambo to mwambe. ");
INSERT INTO lin_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Bikelamu nyonso ya bomoi kati na mokili ekufaki, ezala bandeke, bibwele, banyama ya zamba to mpe banyama ya mike-mike oyo etambolaka na mabele to mpe bato nyonso. ");
INSERT INTO lin_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Nyonso oyo ezalaki na pema ya bomoi ekufaki kati na mokili. ");
INSERT INTO lin_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Boye, Yawe alongolaki kati na mokili bikelamu nyonso oyo ezalaki na bomoi, kobanda na moto kino na ebwele, ekelamu oyo etambolaka na libumu mpe ndeke ya likolo ; alongolaki bango na mokili mpe etikalaki kaka Noa na ba-oyo bazalaki na ye elongo na masuwa. ");
INSERT INTO lin_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Mayi etondaki na mokili mikolo nkama moko na tuku mitano. ");
INSERT INTO lin_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Nzambe akanisaki Noa mpe banyama nyonso oyo ezalaki elongo na ye kati na masuwa, atindaki mopepe na mokili mpe mayi ekitaki. ");
INSERT INTO lin_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Bitima ya se mpe maninisa ya likolo ekangamaki mpe mvula etikaki konoka. ");
INSERT INTO lin_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Mayi ekomaki kolongwa moke-moke likolo ya mabele, mpe sima na mikolo nkama moko na tuku mitano, mayi ekitaki. ");
INSERT INTO lin_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Na mokolo ya zomi na sambo ya sanza ya sambo, masuwa esemaki likolo ya bangomba Ararati. ");
INSERT INTO lin_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Mayi ezalaki kokoba kokita kino na sanza ya zomi. Na mokolo ya liboso ya sanza yango, basonge ya bangomba emonanaki. ");
INSERT INTO lin_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Sima na mikolo tuku minei, Noa afungolaki lininisa ya masuwa oyo asalaki ");
INSERT INTO lin_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","mpe abimisaki yanganga. Yanganga yango ezalaki kokende mpe kozonga kino tango mayi ekawukaki na mokili. ");
INSERT INTO lin_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Mpe lisusu, Noa abimisaki ebenga mpo na kotala soki mayi ekawuki na mokili. ");
INSERT INTO lin_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Kasi ebenga ezwaki esika ya kotia matambe na yango te, pamba te mayi ezalaki na etando nyonso ya mokili. Boye, ezongaki na masuwa epai ya Noa. Noa abimisaki loboko, azwaki ebenga mpe akotisaki yango kati na masuwa. ");
INSERT INTO lin_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Azelaki mikolo sambo mpe abimisaki lisusu ebenga libanda ya masuwa. ");
INSERT INTO lin_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Tango ebenga ezongaki epai na ye na pokwa, ememaki lokasa ya olive ya mobesu na monoko na yango. Boye, Noa asosolaki ete mayi ekiti na mokili. ");
INSERT INTO lin_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Azelaki lisusu mikolo sambo mosusu, mpe abimisaki ebenga. Kasi ebenga ezongaki lisusu te. ");
INSERT INTO lin_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Na mokolo ya liboso na sanza ya liboso, tango Noa akokisaki mibu nkama motoba na moko ya mbotama, mayi ekawukaki na mokili ; Noa afungolaki masuwa na likolo na yango mpe amonaki ete mabele ekawuki. ");
INSERT INTO lin_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Na mokolo ya tuku mibale na sambo ya sanza ya mibale, mabele ekawukaki penza. ");
INSERT INTO lin_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Boye, Nzambe alobaki na Noa : ");
INSERT INTO lin_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","« Bima na masuwa elongo na mwasi na yo, mpe bana na yo ya mibali elongo na basi na bango. ");
INSERT INTO lin_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Bimisa mpe bikelamu oyo ezali elongo na yo : bandeke, banyama mpe bikelamu nyonso oyo etambolaka na libumu, mpo ete ebotana mpe ekoma ebele kati na mokili. » ");
INSERT INTO lin_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Boye, Noa abimaki libanda elongo na bana na ye ya mibali, mwasi na ye mpe basi ya bana na ye. ");
INSERT INTO lin_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Banyama nyonso, bikelamu nyonso oyo etambolaka na libumu mpe bandeke nyonso, bikelamu nyonso oyo etambolaka na mokili, ebimaki na masuwa na molongo kolanda lolenge na yango. ");
INSERT INTO lin_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Noa atongaki etumbelo mpo na Yawe mpe azwaki ndambo ya banyama mpe bandeke ezanga mbindo, abonzelaki yango Yawe lokola mbeka ya kotumba. ");
INSERT INTO lin_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Boye, Yawe ayokaki solo kitoko mpe amilobelaki : « Nakolakela lisusu mabele mabe te likolo ya moto, pamba te wuta bomwana ya moto, motema ya moto elukaka kaka makambo mabe ; nakoboma lisusu te bikelamu nyonso ya bomoi ndenge nawuti kosala. ");
INSERT INTO lin_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Na tango nyonso oyo mokili ekozala, tango ya kolona mpe tango ya kobuka, tango ya malili mpe tango ya molunge, tango ya mvula mpe tango ya elanga, tango ya moyi mpe tango ya butu, ekozanga te. » ");
INSERT INTO lin_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Nzambe apambolaki Noa mpe bana na ye ya mibali. Alobaki na bango : « Bobota bana, bokoma ebele mpe botondisa mokili. ");
INSERT INTO lin_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Banyama nyonso ya mokili, bandeke nyonso ya likolo mpe bikelamu oyo etambolaka na mokili elongo na mbisi ya ebale, ekobanga bino makasi ; nyonso epesami na maboko na bino. ");
INSERT INTO lin_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Bikelamu nyonso oyo ezali na bomoi mpe oyo etambolaka, ekozala bilei na bino. Ndenge kaka napesaki bino matiti, sik’oyo napesi bino biloko nyonso. ");
INSERT INTO lin_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Kasi bokolia te mosuni oyo ezali na makila, pamba te makila ezali bomoi. ");
INSERT INTO lin_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Bongo lokola makila na bino ezali bomoi na bino, nakosambisa oyo nyonso akotangisa yango, ezala nyama to moto. Nakosambisa moto nyonso mpo na bomoi ya moninga na ye. ");
INSERT INTO lin_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Yango wana, soki moto asopi makila ya moto, bakosopa mpe makila na ye epai ya moto, pamba te Nzambe asalaki moto na elilingi na Ye. ");
INSERT INTO lin_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Kasi bino, bobota bana, bokoma ebele mpe botondisa mokili. » ");
INSERT INTO lin_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Boye, Nzambe alobaki na Noa mpe na bana na ye ya mibali : ");
INSERT INTO lin_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","« Nasali sik’oyo boyokani elongo na yo mpe na bakitani na yo sima na yo, ");
INSERT INTO lin_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","na bikelamu nyonso ya bomoi oyo ezali elongo na yo : bandeke, bibwele mpe banyama ya zamba, banyama nyonso oyo ebimaki na masuwa elongo na yo, bikelamu nyonso ya bomoi oyo ezali na mokili. ");
INSERT INTO lin_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Nasali boyokani elongo na yo : bikelamu nyonso oyo ezali na bomoi ekobebisama te na mayi ya mpela. Mpe mpela ekozala lisusu te mpo na kobebisa mokili. » ");
INSERT INTO lin_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Nzambe alobaki lisusu : « Tala elembo ya boyokani oyo natie kati na Ngai mpe bino, mpe bikelamu nyonso ya bomoi oyo ezali na bino elongo. Ezali boyokani mpo na milongo nyonso oyo ekoya : ");
INSERT INTO lin_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","natie monama na Ngai na mapata, mpe yango ekozala elembo ya boyokani kati na Ngai mpe mokili. ");
INSERT INTO lin_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Tango nyonso nakosangisa mapata na likolo ya mokili mpe monama ekobima na mapata, ");
INSERT INTO lin_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","nakokanisa boyokani na Ngai elongo na bino mpe na bikelamu ya lolenge nyonso oyo ezali na bomoi. Mpe mayi ekokoma lisusu mpela te mpo na kobebisa nyonso oyo ezali na bomoi. ");
INSERT INTO lin_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Tango nyonso monama ekobima na mapata, nakomona yango mpe nakokanisa boyokani ya seko kati na Nzambe mpe bikelamu nyonso ya bomoi oyo ezali na mokili. » ");
INSERT INTO lin_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Nzambe alobaki lisusu na Noa : « Yango nde ezali elembo ya boyokani oyo natie kati na Ngai mpe bikelamu nyonso ya bomoi oyo ezali kati na mokili. » ");
INSERT INTO lin_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Tala bana mibali ya Noa oyo babimaki na masuwa : Semi, Cham mpe Jafeti. Cham azalaki tata ya Kanana. ");
INSERT INTO lin_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Bango misato bazalaki bana ya Noa mpe na nzela na bango nde mokili etondaki lisusu na bato. ");
INSERT INTO lin_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noa azalaki mosali bilanga mpe alonaki elanga ya vino. ");
INSERT INTO lin_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Tango amelaki masanga ya vino oyo ewutaki na elanga na ye, alangwaki mpe atikalaki bolumbu kati na ndako na ye ya kapo. ");
INSERT INTO lin_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Cham, tata ya Kanana, amonaki bolumbu ya tata na ye mpe ayebisaki bandeko na ye ya mibali oyo bazalaki na libanda. ");
INSERT INTO lin_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Kasi Semi mpe Jafeti bazwaki elamba mpe batiaki yango na mapeka na bango. Bazongaki sima-sima mpe bazipaki bolumbu ya tata na bango. Lokola bilongi na bango etalaki na ngambo mosusu, bamonaki bolumbu ya tata na bango te. ");
INSERT INTO lin_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Tango milangwa ya Noa esilaki, ayokaki likambo oyo mwana na ye ya suka asalaki. ");
INSERT INTO lin_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Alobaki : « Tika ete Kanana alakelama mabe, azala mowumbu ya suka ya bandeko na ye ! » ");
INSERT INTO lin_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Alobaki lisusu : « Tika ete Yawe, Nzambe ya Semi, apambolama ! Tika ete Kanana azala mowumbu ya Semi ! ");
INSERT INTO lin_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Tika ete Nzambe ayeisa monene mabele ya Jafeti ! Tika ete Jafeti avanda na bandako ya kapo ya Semi, mpe Kanana azala mowumbu na ye ! » ");
INSERT INTO lin_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Sima na mpela, Noa awumelaki na bomoi mibu nkama misato na tuku mitano. ");
INSERT INTO lin_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Mibu nyonso ya bomoi ya Noa ezalaki nkama libwa na tuku mitano, sima akufaki. ");
INSERT INTO lin_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Tala libota ya Noa : Semi, Cham mpe Jafeti ; bango mpe babotaki bakitani sima na mpela. ");
INSERT INTO lin_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Bana mibali ya Jafeti : Gomeri, Magogi, Madayi, Yavani, Tubali, Mesheki mpe Tirasi. ");
INSERT INTO lin_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Bana mibali ya Gomeri : Ashikenazi, Rifati mpe Togarima. ");
INSERT INTO lin_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Bana mibali ya Yavani : Elisha, Tarsisi, Kitimi mpe Dodanimi. ");
INSERT INTO lin_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Bakitani na bango nde bavandaki na bisanga mpe na bamboka ya pembeni ya mayi. Moko na moko kati na bango azwaki mokili na ye kolanda lokota na ye, etuka na ye mpe libota na ye. ");
INSERT INTO lin_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Bana mibali ya Cham : Kushi, Mitsirayimi, Puti mpe Kanana. ");
INSERT INTO lin_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Bana mibali ya Kushi : Seba, Avila, Sabita, Raema mpe Sabiteka. Bana mibali ya Raema : Sheba mpe Dedani. ");
INSERT INTO lin_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kushi azalaki mpe tata ya Nimirodi oyo azalaki elombe ya liboso ya bitumba kati na mokili. ");
INSERT INTO lin_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Azalaki mobomi monene ya banyama na miso ya Yawe. Yango wana, balobaka : « Mobomi monene ya banyama lokola Nimirodi na miso ya Yawe. » ");
INSERT INTO lin_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Bingumba ya liboso ya mokili na ye ezalaki Babeli, Ereki, Akadi mpe Kaline na mokili ya Shineari. ");
INSERT INTO lin_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Longwa na mokili wana, alekaki na Asiri mpe atongaki Ninive, Reoboti-Iri, Kala ");
INSERT INTO lin_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","mpe Reseni, engumba monene na kati-kati ya Ninive mpe Kala. ");
INSERT INTO lin_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Mitsirayimi azalaki koko ya bato ya Ludi, ya Anami, ya Leabi, ya Nafitu, ");
INSERT INTO lin_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","ya Patrusi, ya Kasilu (oyo babimisa bato ya Filisitia) mpe ya Kereti. ");
INSERT INTO lin_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanana azalaki tata ya Sidoni, mwana na ye ya liboso, ya Eti, ");
INSERT INTO lin_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","ya Yebusi, ya Amori, ya Girigazi, ");
INSERT INTO lin_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","ya Evi, ya Ariki, ya Sini, ");
INSERT INTO lin_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","ya Arivadi, ya Tsemari mpe ya Amati. (Mpe na sima, bato ya mabota nyonso ya Kanana bapalanganaki bipai na bipai. ");
INSERT INTO lin_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Mokili ya bato ya Kanana ebandaki wuta na Sidoni, na nzela ya Gerari, kino na Gaza ; mpe na nzela ya Sodome, ya Gomore, ya Adima mpe ya Tseboyimi kino na Lesha.) ");
INSERT INTO lin_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Bango nde bazalaki bakitani ya Cham kolanda mabota mpe nkota na bango, kati na mikili mpe bikolo na bango. ");
INSERT INTO lin_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Semi, kulutu ya Jafeti, abotaki mpe bana ; azalaki koko ya Eberi mpe ya bakitani na ye. ");
INSERT INTO lin_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Bana mibali ya Semi : Elami, Asuri, Aripakishadi, Ludi mpe Arami. ");
INSERT INTO lin_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Bana mibali ya Arami : Utsi, Uli, Geteri mpe Mashi. ");
INSERT INTO lin_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Aripakishadi abotaki Shela ; Shela abotaki Eberi. ");
INSERT INTO lin_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eberi abotaki bana mibali mibale : moko, kombo na ye ezalaki « Pelegi, » pamba te na tango na ye nde bakabolaki mabele ; mpe mosusu, « Yokitani. » ");
INSERT INTO lin_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yokitani abotaki Alimodadi, Shelefi, Atsarimaveti, Yera, ");
INSERT INTO lin_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Adorami, Uzali, Dikila, ");
INSERT INTO lin_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obali, Abimaeli, Saba, ");
INSERT INTO lin_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofiri, Avila mpe Yobabi. Bango nyonso wana bazalaki bakitani ya Yokitani. ");
INSERT INTO lin_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","(Mokili oyo bazalaki kovanda ebandaki wuta na Mesha kino na Sefari, na mokili ya bangomba ya este.) ");
INSERT INTO lin_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Bango nde bazalaki bana mibali ya Semi kolanda bituka mpe nkota na bango, kati na mikili mpe bikolo na bango. ");
INSERT INTO lin_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Wana nde bituka ya bana mibali ya Noa kolanda milongo mpe mikili na bango. Bato nyonso oyo batondisaki mokili sima na mpela babotamaki na nzela na bango. ");
INSERT INTO lin_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Na tango wana, bato ya mokili mobimba bazalaki koloba monoko moko mpe bazalaki na elobeli moko. ");
INSERT INTO lin_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Tango bato bazalaki kotambola mpo na kokende na ngambo ya weste, bamonaki etando moko ya monene na mokili ya Shineari mpe bavandaki kuna. ");
INSERT INTO lin_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Balobanaki bango na bango : « Tosala babiliki mpe totumba yango na moto. » Boye, basalelaki babiliki lokola mabanga mpe potopoto ya mwindo mpo na kotongela. ");
INSERT INTO lin_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Balobaki : « Tokende, totonga engumba mpo na biso mpe ndako molayi oyo songe na yango ekokoma kino na lola, mpo ete kombo na biso ekende sango mpe topanzana te na mokili mobimba. » ");
INSERT INTO lin_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Kasi Yawe akitaki mpo na kotala engumba mpe ndako molayi oyo bato babandaki kotonga. ");
INSERT INTO lin_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Yawe alobaki : « Lokola bato oyo nyonso balongi kokoma ekolo moko mpe koloba monoko moko, bongo bakomi kino kosala mosala monene oyo, eloko moko te ekopekisa bango sik’oyo kokokisa mabongisi nyonso oyo bakokana kosala ! ");
INSERT INTO lin_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Boye, tokita mpe totia mobulu kati na maloba na bango mpo ete bango na bango bayokana lisusu te. » ");
INSERT INTO lin_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Wuta na Babeli, Yawe apanzaki bango na mokili mobimba mpe batikaki kotonga engumba. ");
INSERT INTO lin_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Yango wana, babengaka yango Babeli, pamba te kuna nde Yawe atiaki mobulu kati na maloba ya bato ya mokili mobimba, mpe wuta kuna, Yawe apanzaki bato na mokili mobimba. ");
INSERT INTO lin_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Tala libota ya Semi : Mibu mibale sima na mpela, wana Semi azalaki nanu na mibu nkama moko ya mbotama, akomaki tata ya Aripakishadi. ");
INSERT INTO lin_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Sima na mbotama ya Aripakishadi, Semi awumelaki na bomoi mibu nkama mitano mpe abotaki bana mosusu ya mibali mpe ya basi. ");
INSERT INTO lin_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Tango Aripakishadi akokisaki mibu tuku misato na mitano ya mbotama, abotaki mwana mobali na kombo « Shela. » ");
INSERT INTO lin_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Sima na mbotama ya Shela, Aripakishadi awumelaki na bomoi mibu nkama minei na misato mpe abotaki bana mosusu ya mibali mpe ya basi. ");
INSERT INTO lin_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Tango Shela akokisaki mibu tuku misato ya mbotama, abotaki Eberi. ");
INSERT INTO lin_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Mpe sima na mbotama ya Eberi, Shela awumelaki lisusu na bomoi mibu nkama minei na misato mpe abotaki bana mosusu ya mibali mpe ya basi. ");
INSERT INTO lin_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Tango Eberi akokisaki mibu tuku misato na minei ya mbotama, abotaki Pelegi. ");
INSERT INTO lin_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Mpe sima na mbotama ya Pelegi, Eberi awumelaki lisusu na bomoi mibu nkama minei na tuku misato mpe abotaki bana mosusu ya mibali mpe ya basi. ");
INSERT INTO lin_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Tango Pelegi akokisaki mibu tuku misato ya mbotama, abotaki Rewu. ");
INSERT INTO lin_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Mpe sima na mbotama ya Rewu, Pelegi awumelaki lisusu na bomoi mibu nkama mibale na libwa mpe abotaki bana mosusu ya mibali mpe ya basi. ");
INSERT INTO lin_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Tango Rewu akokisaki mibu tuku misato na mibale ya mbotama, abotaki Serugi. ");
INSERT INTO lin_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Sima na mbotama ya Serugi, Rewu awumelaki lisusu na bomoi mibu nkama mibale na sambo mpe abotaki bana mosusu ya mibali mpe ya basi. ");
INSERT INTO lin_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Tango Serugi akokisaki mibu tuku misato ya mbotama, abotaki Naori. ");
INSERT INTO lin_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Sima na mbotama ya Naori, Serugi awumelaki lisusu na bomoi mibu nkama mibale mpe abotaki bana mosusu ya mibali mpe ya basi. ");
INSERT INTO lin_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Tango Naori akokisaki mibu tuku mibale na libwa ya mbotama, abotaki Tera. ");
INSERT INTO lin_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Mpe sima na mbotama ya Tera, Naori awumelaki lisusu na bomoi mibu nkama moko na zomi na libwa mpe abotaki bana mosusu ya mibali mpe ya basi. ");
INSERT INTO lin_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tango Tera akokisaki mibu tuku sambo ya mbotama, abotaki Abrami, Naori mpe Arani. ");
INSERT INTO lin_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Tala libota ya Tera : Tera abotaki Abrami, Naori mpe Arani. Arani nde azalaki tata ya Loti. ");
INSERT INTO lin_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Wana tata na ye, Tera, azalaki nanu na bomoi, Arani akufaki kati na Uri, mokili ya bato ya Chalide, mokili epai wapi abotamaki. ");
INSERT INTO lin_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Kombo ya mwasi ya Abrami ezalaki « Sarayi, » mpe kombo ya mwasi ya Naori ezalaki « Milika. » Milika azalaki mwana mwasi ya Arani ; mpe Arani azalaki na mwana mwasi mosusu : kombo na ye ezalaki « Yisika. » ");
INSERT INTO lin_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarayi azalaki ekomba : azalaki na mwana te. ");
INSERT INTO lin_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tera azwaki Abrami, mwana na ye ya mobali ; Loti, koko na ye mpe mwana mobali ya Arani ; mpe Sarayi, bokilo na ye mpe mwasi ya mwana na ye Abrami, babimaki na Uri ya bato ya Chalide mpo na kokende na Kanana. Kasi tango bakomaki na engumba Arani, bavandaki kuna. ");
INSERT INTO lin_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tera awumelaki na bomoi mibu nkama mibale na mitano, sima akufaki na engumba Arani. ");
INSERT INTO lin_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Yawe alobaki na Abrami : « Bima wuta na mokili na yo, wuta na libota na yo mpe wuta na ndako ya tata na yo, mpo na lobiko na yo, mpe kende na mokili oyo nakolakisa yo. ");
INSERT INTO lin_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Nakokomisa yo ekolo monene mpe nakopambola yo ; nakokomisa kombo na yo monene, mpe okozala etima ya mapamboli. ");
INSERT INTO lin_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Nakopambola bato oyo bakopambola yo, mpe nakolakela mabe moto oyo akolakela yo mabe ; mpe bato ya bituka nyonso ya mabele bakomipambola mpo na yo. » ");
INSERT INTO lin_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Abrami akendeki ndenge Yawe alobaki na ye ; mpe Loti akendeki na ye elongo. Abrami azalaki na mibu tuku sambo na mitano tango abimaki na engumba Arani. ");
INSERT INTO lin_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abrami azwaki mwasi na ye Sarayi ; Loti, mwana ya ndeko na ye ; bomengo nyonso oyo akomaki na yango mpe bato oyo azwaki na Arani. Babimaki wuta na Arani mpo na kokende na Kanana mpe bakomaki kuna. ");
INSERT INTO lin_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abrami atambolaki kati na mokili yango kino na esika oyo babengaka Sishemi, na nzete monene ya More. Na tango wana, bato ya Kanana bazalaki kovanda na mokili yango. ");
INSERT INTO lin_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Yawe amimonisaki epai ya Abrami mpe alobaki : « Nakopesa mokili oyo epai ya bakitani na yo. » Boye Abrami atongaki na esika yango etumbelo mpo na Yawe oyo amimonisaki epai na ye. ");
INSERT INTO lin_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Longwa wana, akendeki na bangomba ya este ya Beteli. Atongaki ndako na ye ya kapo kati ya Beteli mpe Ayi, na esika oyo atongaki etumbelo mpo na Yawe mpe abelelaki Kombo ya Yawe. Beteli ezalaki na ngambo ya weste mpe Ayi, na ngambo ya este. ");
INSERT INTO lin_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Sima, Abrami alongwaki wana mpe akendeki malembe-malembe kino na Negevi. ");
INSERT INTO lin_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Nzala makasi ekotaki na mokili ; bongo Abrami akendeki kovanda na Ejipito mpo na tango moke, pamba te nzala makasi ekotaki na mokili. ");
INSERT INTO lin_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Tango akomaki pene ya kokota na Ejipito, alobaki na mwasi na ye Sarayi : « Nayebi ete ozali mwasi kitoko penza. ");
INSERT INTO lin_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Tango bato ya Ejipito bakomona yo, bakoloba : ‹ Azali mwasi na ye. › Boye, bakoboma ngai mpe bakotika yo na bomoi. ");
INSERT INTO lin_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Kasi yo, loba na bango ete ozali ndeko na ngai ya mwasi. Na bongo, bakosalela ngai bolamu mpo na yo, mpe bomoi na ngai ekobika mpo na yo. » ");
INSERT INTO lin_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Tango Abrami akomaki na Ejipito, bato ya Ejipito bamonaki ete Sarayi azalaki mwasi kitoko penza. ");
INSERT INTO lin_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Wana bakonzi ya basali ya Faraon bamonaki ye, bakumisaki ye liboso ya Faraon mpe bamemaki ye na ndako ya Faraon mpo ete akoma mwasi na ye. ");
INSERT INTO lin_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Basalelaki Abrami bolamu likolo ya Sarayi, mpe Abrami azwaki bameme, bantaba mpe bangombe, ba-ane, basali ya basi mpe ya mibali, bana ya ba-ane mpe bashamo. ");
INSERT INTO lin_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Kasi Yawe apesaki etumbu makasi epai ya Faraon mpe ndako na ye mpo na Sarayi, mwasi ya Abrami. ");
INSERT INTO lin_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Boye, Faraon abengisaki Abrami mpe alobaki na ye : « Likambo nini osali ngai ? Mpo na nini oyebisaki ngai te ete azali mwasi na yo ? ");
INSERT INTO lin_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Mpo na nini olobaki : ‹ Azali ndeko na ngai ya mwasi ? › Mpo na yango, nakomisaki ye mwasi na ngai. Sik’oyo tala mwasi na yo, kamata ye mpe kende ! » ");
INSERT INTO lin_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Boye, Faraon apesaki mitindo epai ya bato na ye na tina na Abrami ete babengana ye elongo na mwasi na ye mpe biloko nyonso oyo azalaki na yango. ");
INSERT INTO lin_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Boye Abrami alongwaki na Ejipito mpe akendeki na Negevi elongo na mwasi na ye mpe biloko nyonso oyo azalaki na yango ; Loti mpe akendeki na ye elongo. ");
INSERT INTO lin_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abrami akomaki na bozwi mingi : bibwele, palata mpe wolo. ");
INSERT INTO lin_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Longwa na Negevi, akendeki malembe-malembe kino na Beteli, na esika oyo ezalaki kati ya Beteli mpe Ayi, epai wapi ndako na ye ya kapo ezalaki ");
INSERT INTO lin_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","mpe atongaki etumbelo ya liboso. Ezalaki na esika yango nde Abrami abelelaki Kombo ya Yawe. ");
INSERT INTO lin_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Loti, oyo azalaki kotambola elongo na Abrami, azalaki mpe na bameme, bantaba, bangombe mpe basali. ");
INSERT INTO lin_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Boye etuka ekomaki moke mpo na bango mibale, pamba te bomengo na bango ezalaki ebele penza, mpe bakokaki lisusu te kovanda esika moko ; ");
INSERT INTO lin_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","mpe koswana ekotaki kati na babateli bibwele ya Abrami mpe babateli bibwele ya Loti. Nzokande, na tango wana, bato ya Kanana mpe ya Perizi bazalaki kovanda kati na mokili yango. ");
INSERT INTO lin_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Abrami alobaki na Loti : « Tika ete koswana ezala te kati na ngai mpe yo to kati na babateli bibwele na yo mpe babateli bibwele na ngai, pamba te tozali bandeko. ");
INSERT INTO lin_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Mokili mobimba ezali liboso na yo. Ezali malamu tokabwana : soki yo okeyi na ngambo ya loboko ya mwasi, ngai nakokende na ngambo ya loboko ya mobali ; soki okeyi na ngambo ya loboko ya mobali, ngai nakokende na ngambo ya loboko ya mwasi. » ");
INSERT INTO lin_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Boye Loti atalaki mpe amonaki etando nyonso ya Yordani oyo ezalaki na mabele kitoko mpe ekenda kino na Tsoari. Liboso ete Yawe abebisa Sodome mpe Gomore, ezalaki lokola elanga ya Yawe, lokola mokili ya Ejipito. ");
INSERT INTO lin_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Loti aponaki etando ya Yordani mpe akendeki na ngambo ya este. Ezalaki ndenge wana nde bakabwanaki. ");
INSERT INTO lin_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abrami avandaki na mokili ya Kanana, mpe Loti avandaki kati na bingumba ya etando mpe atelemisaki bandako na ye ya kapo pene ya Sodome. ");
INSERT INTO lin_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Bato ya Sodome bazalaki penza bato mabe mpe bato ya masumu na miso ya Yawe. ");
INSERT INTO lin_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Sima na bokabwani ya Abrami na Loti, Yawe alobaki na Abrami : « Na esika oyo ozali, tombola miso na yo mpe tala na ngambo ya nor, ya sude, ya este mpe ya weste. ");
INSERT INTO lin_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Mokili nyonso oyo ozali komona, nakopesa yango epai na yo mpe na bakitani na yo mpo na libela. ");
INSERT INTO lin_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Nakokomisa bakitani na yo ebele lokola putulu ya mabele ; bongo soki moto akoki kotanga putulu, akokoka mpe kotanga bakitani na yo. ");
INSERT INTO lin_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Telema, tambola kati na mokili na bangambo nyonso, pamba te nakopesa yango epai na yo. » ");
INSERT INTO lin_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Abrami alongolaki bandako na ye ya kapo mpe akendeki kovanda na Ebron, pene ya banzete minene ya Mamire epai wapi atongaki etumbelo mpo na Yawe. ");
INSERT INTO lin_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Na tango wana, Amirafeli, mokonzi ya Shineari ; Arioki, mokonzi ya Elasari ; Kedorilaomeri, mokonzi ya Elami, mpe Tideali, mokonzi ya Goyimi, ");
INSERT INTO lin_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","bakendeki kobundisa Bera, mokonzi ya Sodome ; Birisha, mokonzi ya Gomore ; Shineabi, mokonzi ya Adima ; Shemeberi, mokonzi ya Tseboyimi mpe mokonzi ya Bela oyo elakisi Tsoari. ");
INSERT INTO lin_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Bakonzi mitano oyo, basangisaki mampinga na bango ya basoda na lubwaku ya Sidimi oyo ezali ebale monene ya Barozo. ");
INSERT INTO lin_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Bazalaki na se ya bokonzi ya Kedorilaomeri mibu zomi na mibale, kasi na mobu oyo ya zomi na misato, batombokelaki ye. ");
INSERT INTO lin_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Na mobu ya zomi na minei, Kedorilaomeri elongo na bakonzi oyo basanganaki na ye, babundisaki mpe balongaki bato ya Refayimi na Ashiteroti-Karinayimi ; bato ya Zuzimi, na Ami ; mpe bato ya Emimi, na Shave-Kiriatayimi ; ");
INSERT INTO lin_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","bato ya Ori, na Seiri, mokili ya bangomba kino na Parani, pene ya esobe. ");
INSERT INTO lin_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Tango bazongaki, bakendeki na Eyini-Mishipati oyo elakisi Kadeshi mpe babotolaki mokili mobimba ya bato ya Amaleki. Balongaki mpe bato ya Amori oyo bazalaki kovanda na Atsatsoni-Tamari. ");
INSERT INTO lin_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Boye mokonzi ya Sodome, mokonzi ya Gomore, mokonzi ya Adima, mokonzi ya Tseboyimi mpe mokonzi ya Bela oyo elakisi Tsoari, babimaki mpe babongamaki na lubwaku ya Sidimi ");
INSERT INTO lin_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","mpo na kobundisa Kedorilaomeri, mokonzi ya Elami ; Tideali, mokonzi ya Goyimi ; Amirafeli, mokonzi ya Shineari, mpe Arioki, mokonzi ya Elasari. Bakonzi minei babundisaki bakonzi mitano. ");
INSERT INTO lin_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Nzokande, lubwaku ya Sidimi ezalaki na mabulu oyo etonda na potopoto ya mwindo ; bongo tango bakonzi ya Sodome mpe ya Gomore bazalaki kokima, ndambo ya bato bazalaki kozinda kati na yango mpe ndambo mosusu bazalaki kokima na bangomba. ");
INSERT INTO lin_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Bakonzi oyo minei, babotolaki biloko nyonso ya Sodome mpe ya Gomore mpe bakendeki na biloko na bango nyonso ya kolia. ");
INSERT INTO lin_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Bamemaki mpe lisusu Loti, mwana ya ndeko ya Abrami, elongo na bomengo na ye nyonso oyo azwaki tango azalaki kovanda na Sodome. ");
INSERT INTO lin_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Bongo, moto moko akimaki na bitumba mpe akendeki kopesa sango epai ya Abrami, Mo-Ebre oyo azalaki kovanda pene ya banzete minene ya Mamire, moto ya Amori, ndeko ya Eshikoli mpe ya Aneri. Bango nyonso misato basalaki lisanga na Abrami. ");
INSERT INTO lin_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Tango Abrami ayokaki ete bakangi ndeko na ye, abengisaki bato nkama misato na zomi na mwambe oyo bayebi kobunda mpe babotama na ndako na ye. Boye balandaki bango kino na Dani. ");
INSERT INTO lin_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Na butu, Abrami akabolaki bato na ye mpo na kobundisa bango, abetaki bango mpe alandaki bango kino na Oba, na nor ya Damasi. ");
INSERT INTO lin_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Abotolaki bango bomengo nyonso ya bitumba mpe azongaki na ndeko na ye Loti elongo na biloko na ye nyonso, basi mpe bato mosusu. ");
INSERT INTO lin_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Mokonzi ya Sodome akendeki na lubwaku ya Shave oyo ezali lubwaku ya bokonzi, mpo na kokutana na Abrami oyo azali kozonga sima na ye kolonga Kedorilaomeri elongo na bakonzi oyo basanganaki na ye, na bitumba. ");
INSERT INTO lin_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Melishisedeki, mokonzi ya Salemi, amemaki mapa mpe masanga ya vino. Azalaki Nganga-Nzambe ya Nzambe-Oyo-Aleki-Likolo ");
INSERT INTO lin_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","mpe apambolaki Abrami na maloba oyo : « Tika ete Nzambe-Oyo-Aleki-Likolo, Mokeli ya likolo mpe ya mokili, apambola Abrami ! ");
INSERT INTO lin_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Tika ete Nzambe-Oyo-Aleki-Likolo apambolama, Ye oyo akabi na maboko na yo banguna na yo ! » Abrami apesaki ye eteni ya zomi ya biloko nyonso oyo azwaki lokola bomengo ya bitumba. ");
INSERT INTO lin_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Mokonzi ya Sodome alobaki na Abrami : — Pesa ngai bato, kamata na yo biloko. ");
INSERT INTO lin_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Kasi Abrami azongiselaki mokonzi ya Sodome : — Nalapi ndayi na Kombo na Yawe, Nzambe-Oyo-Aleki-Likolo, Nzambe oyo akela likolo mpe mokili, ");
INSERT INTO lin_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","ete nakozwa eloko moko te kati na biloko na yo : ezala singa ya kotongela to ya kokangela sapato, mpo ete oloba te : « Nakomisi Abrami mozwi. » ");
INSERT INTO lin_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Nakondima eloko te longola kaka biloko oyo bato na ngai baliaki mpe biloko ya bato oyo bazalaki elongo na ngai : Aneri, Eshikoli mpe Mamire ; bango nde bakozwa biloko na bango. ");
INSERT INTO lin_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Sima na makambo oyo, Yawe alobaki na Abrami na nzela ya emoniseli : — Kobanga te, Abrami ! Nazali nguba na yo, lifuti na yo ekozala monene. ");
INSERT INTO lin_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Kasi Abrami azongisaki : — Oh Nkolo Yawe, okopesa ngai nini ? Nazali na mwana te, mpe ezali Eliezeri ya Damasi nde akokitana na libula na ngai. ");
INSERT INTO lin_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Abrami alobaki lisusu : — Opesi ngai mwana te ; yango wana mosali moko kati na ndako na ngai akozala mokitani ya libula na ngai ! ");
INSERT INTO lin_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Yawe alobaki na ye : — Moto wana akozala mokitani ya libula na yo te. Kasi mwana oyo akobima na mokongo na yo nde akozala mokitani ya libula na yo. ");
INSERT INTO lin_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Yawe amemaki Abrami na libanda mpe alobaki na ye : — Tala na likolo mpe tanga minzoto soki okokoka kotanga yango. Alobaki na ye lisusu : — Ezali boye nde bakitani na yo bakozala. ");
INSERT INTO lin_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abrami azalaki na kondima epai ya Yawe, yango wana Yawe atangaki ye lokola moto ya sembo. ");
INSERT INTO lin_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Alobaki na ye lisusu : — Nazali Yawe oyo nabimisaki yo wuta na Uri, mokili ya bato ya Chalide, mpo na kopesa yo mokili oyo. ");
INSERT INTO lin_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Kasi Abrami alobaki : — Ah Nkolo Yawe, nakoyeba ndenge nini ete mokili oyo epesameli ngai ? ");
INSERT INTO lin_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Yawe alobaki na ye : — Memela Ngai mwana ngombe moko ya mwasi ya mibu misato, ntaba ya mwasi ya mibu misato, meme ya mobali ya mibu misato, ebenga moko ya zamba mpe ebenga moko ya mboka. ");
INSERT INTO lin_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Abrami amemelaki Ye banyama oyo nyonso, akataki yango na biteni mibale mpe atiaki yango etalana eteni moko na eteni mosusu ; kasi akataki bandeke te. ");
INSERT INTO lin_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Bandeke oyo eliaka misuni ekitaki mpo na kolia misuni yango, kasi Abrami abenganaki yango. ");
INSERT INTO lin_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Tango moyi ekitaki, Abrami alalaki pongi makasi. Na kati ya molili makasi, somo ekangaki ye. ");
INSERT INTO lin_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Boye, Yawe alobaki na Abrami : — Yeba solo ete bakitani na yo bakozala bapaya kati na mokili ya bapaya epai wapi bakozala bawumbu ; mpe bakonyokola bango kuna mibu nkama minei. ");
INSERT INTO lin_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Kasi nakopesa etumbu na ekolo oyo ekokomisa bango bawumbu ; mpe na sima, bakobima longwa na mokili yango elongo na bozwi ebele. ");
INSERT INTO lin_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Bongo yo, okokufa na kimia mpe okokundama sima na kimobange ya esengo. ");
INSERT INTO lin_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Na molongo ya minei, bakitani na yo bakozonga awa, pamba te masumu ya bato ya Amori ekomi nanu ebele te. ");
INSERT INTO lin_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Tango moyi elalaki mpe molili eyaki makasi, mbabola ya milinga mpe koni ya moto elekaki kati ya biteni ya banyama. ");
INSERT INTO lin_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Na mokolo yango, Yawe asalaki boyokani elongo na Abrami mpe alobaki : « Nakopesa mokili oyo na bakitani na yo wuta na moluka ya Ejipito kino na ebale Efrate : ");
INSERT INTO lin_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","mokili ya bato ya Keni, ya bato ya Kenizi, ya bato ya Kadimoni, ");
INSERT INTO lin_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","ya bato ya Iti, ya bato ya Perizi, ya bato ya Refayimi, ");
INSERT INTO lin_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","ya bato ya Amori, ya bato ya Kanana, ya bato ya Girigazi mpe ya bato ya Yebusi. » ");
INSERT INTO lin_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Sarayi, mwasi ya Abrami, abotelaki ye mwana te. Nzokande azalaki na mosali moko ya mwasi, moto ya Ejipito ; kombo na ye « Agari. » ");
INSERT INTO lin_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Sarayi alobaki na Abrami : — Yawe apesi ngai mabota te. Kende, sangisa nzoto na mosali na ngai ya mwasi, tango mosusu nakotonga libota na nzela na ye. Abrami ayokaki maloba ya Sarayi. ");
INSERT INTO lin_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Sima na mibu zomi, wana Abrami avandaki na Kanana, mwasi na ye Sarayi apesaki ye Agari, mosali na ye ya mwasi, moto ya Ejipito, mpo ete azala mwasi na ye. ");
INSERT INTO lin_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abrami asangisaki nzoto na Agari, mpe Agari akomaki na zemi. Tango Agari asosolaki ete akomi na zemi, akomaki kotiola Sarayi, nkolo na ye. ");
INSERT INTO lin_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Boye, Sarayi alobaki na Abrami : — Ezali mpo na yo nde ngai nazali komona pasi ya boye ; napesaki mosali na ngai ya mwasi na maboko na yo. Mpe sik’oyo lokola amoni ete azali na zemi, akomi kotiola ngai. Tika ete Yawe akata likambo kati na ngai mpe yo. ");
INSERT INTO lin_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abrami alobaki : — Mosali na yo azali na maboko na yo. Sala epai na ye nyonso oyo omoni malamu. Boye, Sarayi akomaki konyokola Agari mpe Agari akimaki mosika na ye. ");
INSERT INTO lin_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Anjelu ya Yawe amonaki Agari na esobe, pene ya etima oyo ezali na nzela ya Shuri. ");
INSERT INTO lin_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Atunaki ye : — Agari, mosali ya Sarayi, owuti wapi mpe ozali kokende wapi ? Azongisaki : — Nazali kokima mosika ya Sarayi, nkolo na ngai. ");
INSERT INTO lin_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Anjelu ya Yawe alobaki na ye : — Zonga epai ya nkolo na yo mpe mikitisa liboso na ye. ");
INSERT INTO lin_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Anjelu ya Yawe alobaki na ye lisusu : — Nakokomisa bakitani na yo ebele penza mpe moto moko te akokoka kotanga bango. ");
INSERT INTO lin_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Alobaki na ye lisusu : — Ozali na zemi mpe okobota mwana mobali, okopesa ye kombo « Isimaeli, » pamba te Yawe ayoki yo, kati na mawa na yo. ");
INSERT INTO lin_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Akozala lokola ane ya zamba. Loboko na ye ekobundisa moto nyonso, mpe loboko ya moto nyonso ekobundisa ye ; akovanda esika moko te na bandeko na ye. ");
INSERT INTO lin_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Agari amitunaki : « Boni, namoni solo Nzambe oyo azali komona ngai ? » Boye, Agari apesaki Yawe oyo asololaki na ye Kombo « Ata-Eli-Royi, » oyo elakisi : Nzambe oyo azali komona ngai. ");
INSERT INTO lin_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Yango wana babengaka libulu ya mayi yango Beri Lakai-Royi. Libulu ya mayi yango ezali na kati-kati ya Kadeshi mpe Beredi. ");
INSERT INTO lin_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Boye, Agari abotelaki Abrami mwana mobali mpe Abrami apesaki ye kombo « Isimaeli. » ");
INSERT INTO lin_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abrami azalaki na mibu tuku mwambe na motoba ya mbotama tango Agari abotelaki ye Isimaeli. ");
INSERT INTO lin_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Tango Abrami akokisaki mibu tuku libwa na libwa ya mbotama, Yawe abimelaki ye mpe alobaki na ye : « Nazali Nzambe-Na-Nguya-Nyonso. Tambola liboso na Ngai mpe zala moto azanga pamela. ");
INSERT INTO lin_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Nakosala boyokani kati na Ngai mpe yo, mpe nakokomisa bakitani na yo ebele penza. » ");
INSERT INTO lin_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abrami afukamaki elongi kino na mabele, mpe Nzambe alobaki na ye lisusu : ");
INSERT INTO lin_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","« Mpo na Ngai, tala boyokani oyo nazali kosala elongo na yo : ‹ Okozala tata ya bikolo ebele. ");
INSERT INTO lin_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Bakobenga yo lisusu Abrami te ; kombo na yo ekokoma Abrayami, pamba te nakokomisa yo tata ya bikolo ebele. ");
INSERT INTO lin_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Nakopesa yo mabota ebele, nakobimisa bikolo mpe bakonzi na nzela na yo. ");
INSERT INTO lin_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Nakobatela boyokani na Ngai lokola boyokani ya libela na libela kati na Ngai mpe yo, mpe elongo na bakitani na yo sima na yo, mpo na milongo oyo ekoya na sima, mpo ete nazala Nzambe na yo mpe Nzambe ya bakitani na yo sima na yo. ");
INSERT INTO lin_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Nakopesa lokola libula ya seko na seko, epai na yo mpe epai ya bakitani na yo sima na yo, mokili nyonso ya Kanana epai wapi ozali mopaya. Nakozala Nzambe ya bakitani na yo. › » ");
INSERT INTO lin_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Nzambe alobaki lisusu na Abrayami : « Kasi mpo na yo, osengeli kobatela boyokani na Ngai, yo elongo na bakitani na yo sima na yo mpo na milongo oyo ekoya sima. ");
INSERT INTO lin_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Tala boyokani na Ngai elongo na yo mpe bakitani na yo sima na yo, boyokani oyo osengeli kobatela : Mwana mobali nyonso kati na bino asengeli kokatama ngenga. ");
INSERT INTO lin_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Kokatama ngenga ekozala elembo ya boyokani kati na bino mpe Ngai. ");
INSERT INTO lin_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Mpo na milongo nyonso oyo ekoya, mwana mobali nyonso kati na bino, oyo akokisi mikolo mwambe asengeli kokatama ngenga : ezala mwana mobali oyo abotami kati na ndako na yo to mwana mobali oyo osombi na mosolo na yo epai ya mopaya, mwana mobali oyo azali mokitani na yo te, ye mpe asengeli kokatama ngenga. ");
INSERT INTO lin_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Mowumbu nyonso oyo abotami kati na ndako na yo to oyo osombi na mosolo na yo asengeli kokatama ngenga. Boyokani na Ngai ekozala kati na banzoto na bino lokola boyokani ya libela na libela. ");
INSERT INTO lin_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Mwana mobali nyonso oyo akokatama ngenga te, bakolongola ye kati na bato na ye, mpo ete abebisi boyokani na Ngai. » ");
INSERT INTO lin_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Nzambe alobaki lisusu na Abrayami : « Mpo na Sarayi, mwasi na yo, okobenga ye lisusu te Sarayi, kasi okokoma kobenga ye Sara. ");
INSERT INTO lin_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Nakopambola ye mpe nakopesa yo penza mwana mobali na nzela na ye ; nakopambola ye mpo ete akoma mama ya bikolo. Bakonzi ya bikolo bakobima na nzela na ye. » ");
INSERT INTO lin_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Abrayami afukamaki elongi kino na mabele, asekaki mpe amilobelaki : « Eh ! Mobali oyo azali na mibu nkama moko ya mbotama akoki lisusu kobota mwana ! Bongo Sara, mwasi oyo azali na mibu tuku libwa ya mbotama, akoki penza kokumba zemi ! » ");
INSERT INTO lin_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Boye Abrayami alobaki na Nzambe : — Tika ete Isimaeli awumela na se ya lipamboli na Yo ! ");
INSERT INTO lin_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Nzambe alobaki : — Te ! Mwasi na yo, Sara, akobotela yo mwana mobali, mpe okobenga ye « Izaki. » Nakobatela boyokani na Ngai lokola boyokani ya libela elongo na ye mpe bakitani na ye sima na ye. ");
INSERT INTO lin_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Kasi mpo na Isimaeli, nayoki yo. Solo, nakopambola ye, nakopesa ye mabota ebele mpe nakokomisa bakitani na ye ebele. Akozala tata ya bakambi zomi na mibale, mpe nakokomisa ye tata ya ekolo monene. ");
INSERT INTO lin_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Kasi na oyo etali boyokani na Ngai, nakosala yango elongo na Izaki, mwana mobali oyo Sara akobotela yo na eleko oyo, na mobu oyo ezali koya. ");
INSERT INTO lin_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Tango Nzambe asilisaki kosolola na Abrayami, akendeki. ");
INSERT INTO lin_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Kaka na mokolo wana, Abrayami azwaki mwana na ye ya mobali, Isimaeli, mpe bawumbu nyonso, ezala ba-oyo babotamaki na ndako na ye to ba-oyo asombaki na mosolo, akatisaki bango nyonso ngenga ndenge kaka Nzambe alobaki na ye. ");
INSERT INTO lin_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abrayami azalaki na mibu tuku libwa na libwa ya mbotama tango akatamaki ngenga ; ");
INSERT INTO lin_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","mpe Isimaeli, mwana na ye ya mobali, azalaki na mibu zomi na misato tango akatamaki ngenga. ");
INSERT INTO lin_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Abrayami mpe mwana na ye ya mobali, Isimaeli, bakatamaki ngenga mokolo moko. ");
INSERT INTO lin_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Mibali nyonso kati na ndako ya Abrayami, ezala ba-oyo babotamaki na ndako na ye to ba-oyo asombaki na mokili ya bapaya, bakatamaki ngenga elongo na ye. ");
INSERT INTO lin_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Yawe abimelaki Abrayami pene ya banzete minene ya Mamire, wana avandaki na ekotelo ya ndako na ye ya kapo, na moyi makasi ya midi. ");
INSERT INTO lin_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Tango Abrayami atombolaki miso, amonaki mibali misato pene na ye. Mpe tango kaka amonaki bango, atelemaki wuta na ndako na ye ya kapo mpe akendeki mbangu mpo na kokutana na bango ; bongo agumbamaki kino na mabele. ");
INSERT INTO lin_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Alobaki : — Nabondeli bino, bankolo na ngai, soki nazwi ngolu na miso bino, boleka mosali na bino te. ");
INSERT INTO lin_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Tika ete namemela bino mwa mayi mpo ete bokoka kosukola makolo mpe bopema na se ya nzete oyo. ");
INSERT INTO lin_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Tika ete namemela bino mwa eloko ya kolia mpo ete bozwa lisusu makasi na nzoto ; bongo bokokoba mobembo na bino, pamba te ezali mpo na yango nde boleki epai na ngai mosali na bino. Bazongisaki : — Ezali malamu, sala ndenge olobi. ");
INSERT INTO lin_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Abrayami akotaki na lombangu na ndako na ye ya kapo mpe alobaki na Sara : « Kamata katini misato ya farine mpe sala bagato na lombangu. » ");
INSERT INTO lin_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Mpe Abrayami apotaki mbangu na lopango ya bibwele, azwaki mwana ngombe ya mafuta mpe apesaki yango na mosali na ye mpo ete alamba yango noki-noki. ");
INSERT INTO lin_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Azwaki mafuta ya ngombe, miliki mpe mosuni oyo alambaki, mpe atiaki yango liboso na bango. Abrayami atelemaki pembeni na bango, na se ya nzete, wana bazalaki kolia. ");
INSERT INTO lin_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Sima, batunaki ye : — Wapi Sara, mwasi na yo ? Abrayami azongisaki : — Azali na ndako. ");
INSERT INTO lin_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Bongo moko kati na bango alobaki : — Solo, na mobu oyo ezali koya, kaka na eleko oyo, nakozonga epai na yo, mpe Sara, mwasi na yo, akozala na mwana mobali. Nzokande, Sara ayokaki maloba wana na ekotelo ya ndako ya kapo, na sima ya Abrayami. ");
INSERT INTO lin_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abrayami mpe Sara bazalaki mibange, mpo ete bakomaki na mibu ebele penza mpe Sara azalaki lisusu na makoki te ya kobota. ");
INSERT INTO lin_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Sara asekaki mpe amilobelaki : « Awa nasili konuna boye, nakoki lisusu koyoka posa ya mobali ? Kutu nkolo na ngai akomi mpe mobange ! » ");
INSERT INTO lin_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Yawe alobaki na Abrayami : — Mpo na nini Sara aseki mpe alobi : « Nakoki solo kobota mwana awa nasili kokoma mobange ? » ");
INSERT INTO lin_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Boni, ezali na eloko oyo Yawe akoki kolembana ? Na mobu oyo ezali koya, na tango oyo ekatama, kaka na eleko oyo, nakozonga epai na yo, mpe Sara akozala na mwana mobali. ");
INSERT INTO lin_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sara abangaki ; boye awanganaki : — Naseki te. Kasi Yawe alobaki : — Ezali ya solo, oseki. ");
INSERT INTO lin_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Tango mibali yango batelemaki mpo na kokoba mobembo na bango na Sodome, Abrayami akendeki kotika bango na nzela. ");
INSERT INTO lin_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Yawe amilobelaki : « Boni, nakoki solo kobombela Abrayami likambo oyo nalingi kosala ? ");
INSERT INTO lin_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Solo, Abrayami akokoma ekolo monene mpe ya nguya, mpe bato ya bikolo nyonso ya mabele bakomipambola mpo na ye. ");
INSERT INTO lin_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Pamba te naponaki ye mpo ete ateya bana na ye mpe ndako na ye sima na ye ete bayeba kobatela nzela ya Yawe na kozalaka na etamboli ya malamu mpe ya sembo ; na bongo nde, Ngai Yawe, nakokokisela Abrayami elaka oyo napesaki ye. » ");
INSERT INTO lin_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Bongo Yawe alobaki : « Nayoki sango ete mabe ya bato ya Sodome mpe ya Gomore eleki ndelo, mpe masumu na bango eleki mingi penza. ");
INSERT INTO lin_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Nakokita mpo na kotala soki makambo oyo bazali kosala ekokani na oyo Ngai nayoki. Soki ezali bongo te, nakoyeba. » ");
INSERT INTO lin_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Mibali yango babalukaki mpe bakendeki na Sodome, kasi Abrayami atelemaki kaka liboso ya Yawe. ");
INSERT INTO lin_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Bongo Abrayami apusanaki mpe alobaki : — Boni, Nkolo na ngai, okoboma penza elongo moto ya sembo mpe moto mabe ? ");
INSERT INTO lin_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Soki bato ya sembo bazali tuku mitano kati na engumba, okoboma bango kaka ? Okolimbisa engumba yango te mpo na bato ya sembo tuku mitano oyo bazali kati na yango ? ");
INSERT INTO lin_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Te, okoki kosala likambo ya boye te ! Okoki te koboma elongo bato ya sembo mpe bato mabe, okoki kosala ndenge moko te na bato ya sembo mpe na bato mabe. Okoki kosala bongo te ! Boni, Mosambisi ya mokili mobimba akosambisa na bosembo te ? ");
INSERT INTO lin_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Yawe azongisaki : — Soki nakuti na Sodome bato ya sembo tuku mitano, nakolimbisa engumba mobimba mpo na bango. ");
INSERT INTO lin_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abrayami alobaki lisusu : — Solo, nazali na ngai moto pamba mpe putulu, kasi limbisa ete nameka kosolola na Nkolo na ngai. ");
INSERT INTO lin_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Bongo soki motango na bato ya sembo ezali tuku minei na mitano ? Boni, okobebisa engumba mobimba mpo na bato mitano oyo bazangi ? Yawe azongisaki : — Soki nakuti bato ya sembo tuku minei na mitano, nakobebisa yango te. ");
INSERT INTO lin_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abrayami alobaki na Ye lisusu : — Bongo soki bato ya sembo bazali kaka tuku minei ? Azongisaki : — Soki bazali kaka tuku minei, nakobebisa yango te. ");
INSERT INTO lin_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Bongo Abrayami alobaki : — Tika ete Nkolo na ngai asilika te soki nakobi koloba : Bongo soki bato ya sembo bazali kaka tuku misato ? Azongisaki : — Soki nakuti bato ya sembo tuku misato, nakobebisa yango te. ");
INSERT INTO lin_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abrayami alobaki : —Awa nameki kosolola na Nkolo, boni, okosala nini soki bato ya sembo bazali kaka tuku mibale ? Azongisaki : — Mpo na bato ya sembo tuku mibale, nakobebisa engumba te. ");
INSERT INTO lin_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Bongo Abrayami alobaki : — Tika ete Nkolo na ngai asilika te, pamba te nazali koloba mpo na mbala ya suka : Bongo soki bato ya sembo bazali kaka zomi ? Azongisaki : — Mpo na bato ya sembo zomi, nakobebisa engumba te. ");
INSERT INTO lin_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Sima na Yawe kosolola na Abrayami, akendeki ; mpe Abrayami azongaki na ndako na ye. ");
INSERT INTO lin_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Ba-anjelu oyo mibale bakomaki na Sodome na pokwa. Wana Loti avandaki na ekuke, amonaki bango, akendeki koyamba bango mpe afukamaki elongi kino na mabele. ");
INSERT INTO lin_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Alobaki na bango : — Nabondeli bino, bankolo na ngai, boya na ndako ya mosali na bino. Bokoki kosukola kuna makolo na bino mpe kolekisa butu, bongo na tongo, bokoki kokoba mobembo na bino. Bazongiselaki ye : — Te, tokolala kaka libanda. ");
INSERT INTO lin_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Kasi Loti abondelaki bango mingi ; boye bandimaki kokende na ye elongo mpe bakotaki na ndako na ye. Alambelaki bango bilei ya kitoko, atumbaki mapa ezanga levire mpe baliaki. ");
INSERT INTO lin_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Liboso ete bakende kolala, mibali nyonso ya engumba Sodome, bilenge mpe mibange, bawutaki bipai na bipai mpe bayaki kozingela ndako. ");
INSERT INTO lin_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Babelelaki Loti : — Wapi mibali oyo bayaki epai na yo na butu oyo ? Bimisela biso bango mpo ete tosangisa na bango nzoto. ");
INSERT INTO lin_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Loti abimaki mpo na kosolola na bango ; akangaki ekuke sima na ye. ");
INSERT INTO lin_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Alobaki : — Te, baninga na ngai, bosala mabe te ! ");
INSERT INTO lin_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Boyoka ! Nazali na bana basi mibale oyo bayebi nanu nzoto ya mibali te. Tika ete namemela bino bango libanda ! Bosala bango nyonso oyo bolingi. Kasi bosala bato oyo eloko moko te mpo ete bayei kovanda na ndako na ngai. ");
INSERT INTO lin_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Bazongisaki : — Longwa wana. Balobaki lisusu : — Botala moto oyo, ayaki awa lokola mopaya ; sik’oyo alingi komikomisa mosambisi. Tokosala yo mabe koleka bango. Bongo batindikaki Loti na makasi mpe bapusanaki pene ya ekuke mpo na koluka kobuka yango. ");
INSERT INTO lin_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Kasi mibali oyo bazalaki kati na ndako babimisaki maboko mpe babendaki Loti na kati ya ndako mpe bakangaki ekuke. ");
INSERT INTO lin_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Bakangaki miso ya bato nyonso oyo bazalaki na ekuke ya ndako, ezala bilenge to mibange ; boye bazalaki lisusu komona ekuke te. ");
INSERT INTO lin_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Mibali yango mibale balobaki na Loti : — Ozali lisusu na moto mosusu na engumba oyo, ndakisa : mibali ya bana na yo ya basi, bana na yo ya mibali mpe ya basi to mpe ndeko mosusu ? Bimisa bango libanda ya esika oyo ");
INSERT INTO lin_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","mpo ete tolingi kobebisa yango. Sango ya makambo mabe ya bato oyo ekomi kino epai na Yawe ; yango wana Yawe atindi biso mpo na kobebisa engumba oyo. ");
INSERT INTO lin_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Boye Loti abimaki mpe akendeki koyebisa babandami ya mabala ya bana na ye ya basi. Alobaki : « Bosala noki mpe bobima na esika oyo, pamba te Yawe alingi kobebisa engumba oyo ! » Kasi babandami ya mabala ya bana na ye ya basi bakanisaki ete azali kosala maseki. ");
INSERT INTO lin_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Tango kaka tongo etanaki, ba-anjelu batungisaki Loti mpe balobaki : — Sala noki, kamata mwasi na yo mpe bana na yo mibale ya basi oyo bazali awa ; soki te, bokobebisama tango engumba oyo ekozwa etumbu. ");
INSERT INTO lin_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Lokola azalaki kowumela, mibali yango bakangaki na makasi loboko na ye, maboko ya mwasi mpe ya bana na ye ya basi ; mpe bamemaki bango na libanda ya engumba, pamba te Yawe ayokelaki bango mawa. ");
INSERT INTO lin_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Tango kaka babimisaki bango na libanda, moko kati na mibali yango alobaki : — Bokima mpo ete bobikisa bomoi na bino ! Botala sima te mpe botelema ata esika moko te kati na engumba oyo ! Bokima na likolo ya bangomba, noki te bokobebisama ! ");
INSERT INTO lin_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Kasi Loti azongisaki : — Te, nkolo na ngai, tika ete esalema bongo te ! ");
INSERT INTO lin_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Mosali na yo azwi ngolu na miso na yo, mpe otalisi ngai bolamu makasi na ndenge obikisi bomoi na ngai. Kasi nakokoka te kokima na likolo ya bangomba, noki te likama ekokomela ngai mpe nakokufa. ");
INSERT INTO lin_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Tala, ezali na engumba moko pene awa mpo na kokimela, yango ezali penza moke. Tika ngai nakimela kuna atako ezali moke mpo ete nabikisa bomoi na ngai ! ");
INSERT INTO lin_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Anjelu alobaki na ye : — Malamu mingi, nakokokisela yo lisusu bosenga oyo. Nakobebisa te engumba oyo ozali kolobela. ");
INSERT INTO lin_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Kasi kima noki, pamba te nakoki kosala eloko moko te soki okomi nanu kuna te. Yango wana babengaka engumba yango Tsoari. ");
INSERT INTO lin_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Loti akomaki na Tsoari tango tongo etanaki. ");
INSERT INTO lin_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Boye wuta na likolo, Yawe anokisaki mvula ya moto makasi ya fofolo, na sodome mpe na Gomore. ");
INSERT INTO lin_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Abebisaki bingumba yango, etando nyonso elongo na bato nyonso oyo bazalaki kovanda kuna mpe banzete nyonso. ");
INSERT INTO lin_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Kasi mwasi ya Loti atalaki na sima mpe akomaki ekeko ya mungwa. ");
INSERT INTO lin_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Na tongo makasi, Abrayami amataki na esika oyo atelemaki liboso ya Yawe ; ");
INSERT INTO lin_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","atalaki na ngambo ya Sodome mpe ya Gomore, mpe na ngambo ya mokili ya etando ; amonaki molinga makasi komata wuta na mokili lokola molinga ya fulu monene ya moto. ");
INSERT INTO lin_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Boye, tango Nzambe abebisaki bingumba ya etando, akanisaki Abrayami mpe abikisaki Loti na likama oyo atindelaki bingumba epai wapi Loti azalaki kovanda. ");
INSERT INTO lin_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Loti mpe bana na ye mibale ya basi babimaki na Tsoari, bakendeki kovanda na bangomba, pamba te azalaki kobanga kotikala kuna. Ye elongo na bana na ye mibale ya basi bakendeki kovanda kati na lidusu ya libanga. ");
INSERT INTO lin_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Mokolo moko, kulutu alobaki na leki na ye : « Tata na biso akomi mobange, mpe na etuka oyo, mobali oyo akosangisa na biso nzoto ndenge esalemaka na mokili mobimba, azali te. ");
INSERT INTO lin_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Tika ete tomelisa tata na biso masanga ya vino mpe tosangisa na ye nzoto mpo ete, na nzela ya tata na biso, libota na biso ebunga te. » ");
INSERT INTO lin_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Na butu wana, bazwaki masanga ya vino mpe bamelisaki tata na bango. Boye kulutu akendeki mpe asangisaki nzoto na tata na ye, mpe tata na ye atikalaki koyeba likambo yango te, ezala tango mwana na ye ya mwasi akendeki epai na ye to tango alongwaki. ");
INSERT INTO lin_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Mokolo oyo elandaki, kulutu alobaki na leki : « Na butu oyo ewuti koleka, nasangisaki nzoto na tata na ngai. Tika ete topesa ye lisusu masanga ya vino na butu ya lelo, mpe yo okokende kosangisa na ye nzoto mpo ete, na nzela ya tata na biso, libota na biso ebunga te. » ");
INSERT INTO lin_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Na butu wana lisusu, bazwaki masanga ya vino mpe bamelisaki tata na bango ; bongo leki akendeki mpe asangisaki nzoto na tata na ye. Tata na ye atikalaki kaka koyeba likambo yango te, ezala tango mwana na ye ya mwasi akendeki epai na ye to tango alongwaki. ");
INSERT INTO lin_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Boye bana basi oyo mibale ya Loti bakomaki na zemi ya tata na bango. ");
INSERT INTO lin_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Kulutu abotaki mwana mobali mpe apesaki ye kombo « Moabi ; » azali tata ya ekolo ya Moabi, kino na mokolo ya lelo. ");
INSERT INTO lin_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Leki mpe abotaki lisusu mwana mobali mpe apesaki ye kombo « Beni-Ami ; » azali tata ya ekolo ya Amoni, kino na mokolo ya lelo. ");
INSERT INTO lin_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abrayami alongwaki na mboka wana mpo na kokende na etuka ya Negevi mpe avandaki na mboka oyo ezalaki kati ya Kadeshi mpe Shuri ; sima na tango moke, akendeki kovanda na Gerari. ");
INSERT INTO lin_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Abrayami azalaki koloba kuna na tina na Sara, mwasi na ye : « Azali ndeko na ngai ya mwasi ! » Yango wana Abimeleki, mokonzi ya Gerari, atindaki bato mpo na koluka Sara mpe akamataki ye na makasi. ");
INSERT INTO lin_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Kasi na butu, Nzambe ayaki epai ya Abimeleki kati na ndoto mpe alobaki na ye : « Okokufa mpo na mwasi oyo osili kozwa, pamba te azali mwasi ya libala. » ");
INSERT INTO lin_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Nzokande, Abimeleki apusanaki nanu te pembeni na ye. Agangaki : — Nkolo, okoboma penza ekolo ata soki esali na yango mabe te ? ");
INSERT INTO lin_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Ezali mobali na ye moko nde alobaki : « Azali ndeko na ngai ya mwasi ; » mpe ye moko andimaki : « Azali ndeko na ngai ya mobali. » Nasali yango na motema sembo mpe na maboko ezanga mbindo. ");
INSERT INTO lin_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Nzambe alobaki na ye na ndoto : — Solo, nayebi ete osali yango na motema sembo. Yango wana nabatelaki yo mpo ete osala lisumu te epai na Ngai, mpe natikaki te ete osimba ye. ");
INSERT INTO lin_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Sik’oyo, zongisa mwasi yango epai ya mobali na ye mpo ete azali mosakoli. Akobondela mpo na yo mpe okokufa te. Soki ozongisi ye te, yeba ete okokufa, yo mpe bato na yo nyonso. ");
INSERT INTO lin_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Na tongo-tongo, Abimeleki alamukaki mpe abengisaki basali na ye nyonso. Tango ayebisaki bango makambo oyo ekomelaki ye, babangaki makasi. ");
INSERT INTO lin_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Abimeleki abengaki Abrayami mpe alobaki na ye : — Likambo nini osali biso, lisumu nini nasali yo mpo ete omemisa ngai mpe mokili na ngai ngambo ya monene boye ? Osali ngai makambo oyo ekoki kosalema te. ");
INSERT INTO lin_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Abimeleki atunaki Abrayami : — Makanisi nini ozalaki na yango mpo ete osala boye ? ");
INSERT INTO lin_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abrayami azongisaki : — Namilobelaki : « Solo, bato ya esika oyo batosaka Nzambe ata moke te mpe bakoboma ngai mpo na mwasi na ngai. ");
INSERT INTO lin_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Lisusu, azali ya solo ndeko na ngai ya mwasi, mwana ya tata na ngai ; kasi azali mwana ya mama na ngai te. Nzokande akoma mwasi na ngai. » ");
INSERT INTO lin_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Tango Nzambe alongolaki ngai na ndako ya tata na ngai mpo na kokende bipai na bipai, nayebisaki mwasi na ngai : « Tala bolamu oyo okosalela ngai : Bisika nyonso oyo tokokende, okolobaka na tina na ngai : ‹ Azali ndeko na ngai. › » ");
INSERT INTO lin_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Boye Abimeleki azwaki bameme, bantaba, bangombe, basali ya mibali mpe ya basi, apesaki na Abrayami. Mpe azongiselaki ye mwasi na ye Sara. ");
INSERT INTO lin_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimeleki alobaki : « Mboka na ngai ezali liboso na yo, vanda na esika oyo olingi. » ");
INSERT INTO lin_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Abalukaki mpe alobaki lisusu epai na Sara : « Tala, napesi mbongo ya bibende, nkoto moko, epai ya ndeko na yo ya mobali. Ezali mpo na kozipa mabe oyo basali yo mpe bato nyonso oyo bazali elongo na yo ; boye okomi sembo na nyonso. » ");
INSERT INTO lin_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Abrayami abondelaki Nzambe, mpe Nzambe abikisaki Abimeleki, mwasi na ye, mpe basi bawumbu na ye. Na nzela wana, bazwaki lisusu bana ; ");
INSERT INTO lin_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","pamba te Yawe akangaki mabota kati na ndako mobimba ya Abimeleki likolo ya Sara, mwasi ya Abrayami. ");
INSERT INTO lin_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Yawe atalisaki bolamu na Ye epai ya Sara ndenge kaka alobaki mpe akokisaki elaka oyo apesaki ye. ");
INSERT INTO lin_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sara azwaki zemi mpe abotelaki Abrayami mwana na kimobange na ye kaka na tango oyo Nzambe alakaki ye. ");
INSERT INTO lin_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abrayami apesaki na mwana oyo Sara abotelaki ye kombo « Izaki. » ");
INSERT INTO lin_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Abrayami akatisaki Izaki ngenga tango akokisaki mikolo mwambe ya mbotama, ndenge Nzambe atindaki ye. ");
INSERT INTO lin_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abrayami azalaki na mibu nkama moko ya mbotama tango mwana na ye, Izaki, abotamaki. ");
INSERT INTO lin_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sara alobaki : « Nzambe apesi ngai libaku ya koseka ; mpe moto nyonso oyo akoyoka sango oyo akoseka elongo na ngai. » ");
INSERT INTO lin_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Abakisaki : « Nani akokaki koloba na Abrayami ete Sara akomelisa bana mabele ? Pamba te naboteli ye mwana na kimobange na ye. » ");
INSERT INTO lin_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Mwana akolaki mpe Sara akataki kopesa ye mabele. Mokolo bakataki kopesa Izaki mabele, Abrayami asalisaki feti monene. ");
INSERT INTO lin_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Kasi tango Sara amonaki ete Isimaeli, mwana oyo Agari, moto ya Ejipito, abotelaki Abrayami, azali koseka ; ");
INSERT INTO lin_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","ayebisaki Abrayami : « Bengana mwasi mowumbu oyo elongo na mwana na ye ya mobali, pamba te mwana ya mwasi mowumbu oyo, akoki te kokabola libula elongo na Izaki, mwana na ngai ya mobali. » ");
INSERT INTO lin_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Tango Abrayami ayokaki bongo, esalaki ye pasi makasi na motema mpo na mwana na ye. ");
INSERT INTO lin_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Kasi Nzambe ayebisaki Abrayami : « Tika koyoka pasi na motema mpo na mwana na yo ya mobali mpe mwasi mowumbu na yo. Yoka nyonso oyo Sara azali koyebisa yo, pamba te ezali na nzela ya Izaki nde okozwa bakitani. ");
INSERT INTO lin_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Nakokomisa mpe mwana mobali ya mwasi mowumbu na yo ekolo, pamba te ye mpe azali makila na yo. » ");
INSERT INTO lin_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Na tongo makasi ya mokolo oyo elandaki, Abrayami azwaki lipa mpe mbeki ya mayi ; apesaki yango na Agari. Atiaki yango likolo ya lipeka na ye, apesaki ye mwana mpe abenganaki ye. Agari akendeki mpe atambolaki bipai na bipai na esobe ya Beri-Sheba. ");
INSERT INTO lin_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Tango mayi oyo ezalaki na mbeki esilaki, Agari asundolaki mwana na se ya nzete moko ya moke. ");
INSERT INTO lin_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Akendeki kovanda na monkama ya bametele, pamba te alobaki : « Nalingi te komona kufa ya mwana na ngai. » Lokola avandaki mosika ya mwana, atombolaki mongongo mpe alelaki. ");
INSERT INTO lin_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Nzambe ayokaki mongongo ya mwana, mpe Anjelu na Nzambe abengaki Agari wuta na likolo. Ayebisaki ye : « Agari, likambo nini ? Kobanga te, pamba te Nzambe ayoki mongongo ya mwana wuta na esika oyo otikaki ye. ");
INSERT INTO lin_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Telema, tombola mwana mpe zwa ye na loboko na yo, pamba te nakokomisa ye ekolo monene. » ");
INSERT INTO lin_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Nzambe afungolaki ye miso, mpe amonaki libulu ya mayi. Akendeki kotondisa mbeki mpe amelisaki mwana. ");
INSERT INTO lin_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Nzambe azalaki elongo na mwana. Akolaki, avandaki kati na esobe mpe akomaki mobomi nyama na tolotolo. ");
INSERT INTO lin_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Wana azalaki kovanda kati na esobe ya Parani, mama na ye azwelaki ye mwasi ya mokili ya Ejipito. ");
INSERT INTO lin_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Kaka na tango yango, Abimeleki mpe Pikoli, mokonzi ya mampinga na ye, bakendeki kokutana na Abrayami ; mpe Abimeleki alobaki na Abrayami : — Nzambe azali kolongisa yo na makambo nyonso oyo ozali kosala. ");
INSERT INTO lin_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Bongo sik’oyo, lapa ndayi awa na Kombo ya Nzambe ete okokosa ngai te, bana na ngai te, mpe bakoko na ngai te ; kasi okosalela ngai bolamu elongo na mboka oyo epai wapi ozali kovanda lokola mopaya, ndenge ngai nasaleli yo. ");
INSERT INTO lin_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abrayami azongisaki : — Nalapi ndayi ! ");
INSERT INTO lin_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Bongo Abrayami alobelaki Abimeleki na tina na libulu ya mayi oyo basali ya Abimeleki babotolaki na makasi. ");
INSERT INTO lin_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimeleki azongisaki : — Nayebi te nani asalaki bongo. Oyebisaki ngai likambo moko te na tina na yango, mpe nayoki yango kaka lelo. ");
INSERT INTO lin_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Abrayami azwaki bameme, bantaba, bangombe, mpe apesaki yango na Abimeleki ; bongo bango mibale basalaki boyokani. ");
INSERT INTO lin_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abrayami atiaki pembeni bana meme sambo oyo azwaki kati na etonga. ");
INSERT INTO lin_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimeleki atunaki Abrayami : — Bana meme sambo oyo otie pembeni elakisi nini ? ");
INSERT INTO lin_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Azongisaki : — Ndima bana meme sambo oyo ewuti na maboko na ngai lokola litatoli ete ngai nde natimolaki libulu yango. ");
INSERT INTO lin_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Yango wana babengaki esika yango Beri-Sheba, pamba te na esika yango nde bango mibale balapaki ndayi. ");
INSERT INTO lin_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Sima na bango kosala boyokani kuna na Beri-Sheba, Abimeleki mpe Pikoli, mokonzi ya mampinga na ye, bazongaki na mokili ya Filisitia. ");
INSERT INTO lin_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abrayami alonaki nzete ya tamarisi na Beri-Sheba mpe abelelaki Yawe, Nzambe ya bileko na bileko. ");
INSERT INTO lin_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Abrayami avandaki lisusu tango molayi na mokili ya Filisitia. ");
INSERT INTO lin_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Na sima na makambo wana, Nzambe amekaki Abrayami. Alobaki na ye : — Abrayami ! Abrayami azongisaki : — Ngai oyo. ");
INSERT INTO lin_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Nzambe alobaki na ye : — Zwa Izaki, mwana na yo ya mobali, mwana na yo se moko oyo olingaka ; kende na mokili ya Morija, mpe kuna, okopesa Ngai ye lokola mbeka ya kotumba na likolo ya ngomba oyo nakolakisa yo. ");
INSERT INTO lin_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Na tongo-tongo, Abrayami atelemaki mpe abongisaki ane na ye. Azwaki basali mibale kati na basali na ye, azwaki mpe Izaki, mwana na ye. Abukaki bakoni mpo na kotumba mbeka, atelemaki mpe akendeki na esika oyo Nzambe ayebisaki ye. ");
INSERT INTO lin_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Na mokolo ya misato, Abrayami atombolaki miso na ye mpe amonaki esika yango na mosika. ");
INSERT INTO lin_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Bongo Abrayami ayebisaki basali na ye : « Botikala awa elongo na ane, wana ngai elongo na mwana tozali kokende kino kuna na likolo mpo na kogumbamela Nzambe ; sima na yango, tokozongela bino. » ");
INSERT INTO lin_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abrayami azwaki bakoni ya kotumbela mbeka mpe amemisaki yango Izaki, mwana na ye ; mpe ye moko amemaki moto mpe mbeli, bongo bango mibale bakendeki nzela moko. ");
INSERT INTO lin_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Izaki atunaki Abrayami, tata na ye : — Tata na ngai ! Abrayami azongisaki : — Ngai oyo ! Izaki alobaki : — Tozali na moto mpe koni, kasi wapi mpate mpo na mbeka ya kotumba ? ");
INSERT INTO lin_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abrayami azongisaki : — Mwana na ngai, Ye moko Nzambe akopesa mpate mpo na mbeka ya kotumba. Boye bango mibale bakendeki nzela moko. ");
INSERT INTO lin_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Tango bakomaki na esika oyo Nzambe alakisaki ye, Abrayami atongaki etumbelo na esika yango mpe abongisaki bakoni na likolo na yango. Akangaki Izaki, mwana na ye ya mobali, basinga mpe alalisaki ye na etumbelo likolo ya bakoni. ");
INSERT INTO lin_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Boye Abrayami azwaki mbeli mpe asembolaki loboko na ye mpo na koboma mwana na ye ya mobali. ");
INSERT INTO lin_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Kasi anjelu ya Yawe abengaki ye wuta na likolo : — Abrayami ! Abrayami ! Abrayami azongisaki : — Ngai oyo. ");
INSERT INTO lin_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Anjelu alobaki : — Kosembola loboko na yo te likolo ya mwana, kosala ye mabe te. Nasosoli sik’oyo ete otosaka Nzambe, pamba te oboyi te kopesa Ngai mwana na yo ya mobali, mwana na yo se moko. ");
INSERT INTO lin_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Abrayami atombolaki miso na ye mpe amonaki meme ya mobali oyo maseke na yango ezalaki ya kokangama na nzete ya moke. Azwaki yango mpe apesaki yango mbeka ya kotumba na esika ya mwana na ye ya mobali. ");
INSERT INTO lin_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Abrayami abengaki esika yango « Nkolo akopesa. » Yango wana balobaka kino lelo : « Na likolo ya ngomba ya Yawe, ekopesama. » ");
INSERT INTO lin_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Anjelu ya Yawe abengaki Abrayami na mbala ya mibale wuta na likolo ");
INSERT INTO lin_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","mpe alobaki : « Nakati seleka na Kombo na Ngai, elobi Yawe, ete lokola osali likambo ya boye, lokola oboyi te kopesa Ngai mwana na yo ya mobali, mwana na yo se moko, ");
INSERT INTO lin_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","nakopambola yo solo mpe nakokomisa bakitani na yo ebele lokola minzoto ya likolo, mpe ebele lokola zelo ya ebale. Bakitani na yo bakokamata bingumba ya banguna na bango. ");
INSERT INTO lin_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Bato ya bikolo nyonso ya mabele bakomipambola mpo na bakitani na yo, pamba te otosi Ngai. » ");
INSERT INTO lin_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Abrayami azongaki epai ya basali na ye mpe bakendeki elongo na Beri-Sheba epai wapi akobaki kovanda. ");
INSERT INTO lin_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Sima na makambo wana, bayebisaki Abrayami ete Milika mpe abotelaki Naori, ndeko ya Abrayami, bana : ");
INSERT INTO lin_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Mwana na ye ya liboso, Utsi ; Buzi, ndeko na ye mobali ; Kemweli, tata ya Arami ; ");
INSERT INTO lin_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kesedi, Azo, Pilidashi, Yidilafi mpe Betweli. ");
INSERT INTO lin_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betweli azalaki tata ya Rebeka. Milika abotelaki Naori, ndeko mobali ya Abrayami, bana mibali mwambe. ");
INSERT INTO lin_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Makangu ya Naori, oyo kombo na ye ezalaki Reuma, ye mpe abotelaki Naori bana : Teba, Gami, Taashi mpe Maaka. ");
INSERT INTO lin_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara awumelaki na bomoi mibu nkama moko na tuku mibale na sambo. ");
INSERT INTO lin_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Akufaki na Kiriati-Ariba oyo ezali Ebron, na mokili ya Kanana. Abrayami asalaki matanga mpo na Sara mpe alelaki ye. ");
INSERT INTO lin_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Abrayami alongwaki liboso ya ebembe ya mwasi na ye mpe asololaki na bato ya Iti. ");
INSERT INTO lin_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Alobaki na bango : — Nazali mopaya mpe navandaka kati na bino ; botekela ngai eteni ya mabele kati na bino mpo ete nakunda mwasi na ngai. ");
INSERT INTO lin_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Bato ya Iti bazongiselaki Abrayami : ");
INSERT INTO lin_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","— Yoka biso, nkolo na ngai ; ya solo, ozali moto monene kati na biso. Kunda mwasi na yo kati na kunda oyo eleki kitoko kati na bakunda na biso. Moko te kati na biso akoboya kopesa yo kunda na ye mpo ete okunda mwasi na yo. ");
INSERT INTO lin_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Boye, Abrayami atelemaki mpe agumbamaki liboso ya bato ya mboka wana, bato ya Iti. ");
INSERT INTO lin_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Ayebisaki bango : — Soki ezali mokano na bino ete nakunda nzoto ya mwasi na ngai awa, boyoka ngai mpe bosengela ngai epai ya Efroni, mwana mobali ya Tsoari, ");
INSERT INTO lin_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ete atekela ngai libulu na ye ya mabanga oyo ezali na Makipela, na suka ya elanga na ye. Boyebisa ye ete atekela ngai yango na motuya oyo ekoki na yango mpo ete nakomisa yango mabele ya kokunda bato na ngai. ");
INSERT INTO lin_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Nzokande, Efroni, moto ya Iti, oyo azalaki kovanda kati na bato na ye, azongiselaki Abrayami na miso ya bato ya Iti, liboso ya bato nyonso oyo bayaki na ekuke ya engumba na ye : ");
INSERT INTO lin_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","— Te, nkolo na ngai, yoka ngai ! Napesi yo elanga mpe libulu ya mabanga oyo ezali kati na yango. Napesi yo yango liboso ya bato na ngai mpo ete okunda mwasi na yo. ");
INSERT INTO lin_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Abrayami agumbamaki liboso ya bato ya mboka ");
INSERT INTO lin_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","mpe azongiselaki Efroni : — Nabondeli yo, yoka ngai ! Soki olingi, nakopesa yo motuya oyo ekoki na elanga. Ndima yango mpo ete nakunda mwasi na ngai kuna. ");
INSERT INTO lin_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efroni azongiselaki Abrayami : ");
INSERT INTO lin_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","— Yoka, nkolo na ngai ! Mabele ya motuya ya mbongo ya bibende, nkama minei, ezali penza nini kati na ngai mpe yo ? Kamata mabele yango mpe kunda mwasi na yo. ");
INSERT INTO lin_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abrayami andimaki maloba ya Efroni mpe amemelaki ye motuya oyo alobaki na miso ya bato ya Iti : mbongo ya bibende, nkama minei, kolanda ndenge bazalaki kotanga mbongo na tango wana. ");
INSERT INTO lin_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Boye elanga ya Efroni oyo ezalaki na Makipela, pembeni ya Mamire, elongo na libulu ya mabanga oyo ezalaki kati na yango, banzete nyonso oyo ezalaki kati na elanga mpe na bandelo ya zingazinga na yango, epesamaki ");
INSERT INTO lin_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","epai ya Abrayami mpe ekomaki ya ye na miso ya bato ya Iti oyo bayaki na ekuke ya engumba. ");
INSERT INTO lin_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Sima na yango, Abrayami akundaki mwasi na ye Sara na libulu ya mabanga ya elanga ya Makipela, pembeni ya Mamire oyo ezali Ebron, na mokili ya Kanana. ");
INSERT INTO lin_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Bato ya Iti bapesaki Abrayami elanga yango elongo na libulu ya mabanga oyo ezalaki na kati mpo ete ekoma ya ye mpe akundaka bato na ye kuna. ");
INSERT INTO lin_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abrayami akomaki mobange mpe mibu ya bomoi na ye epusanaki. Yawe apambolaki ye na makambo nyonso. ");
INSERT INTO lin_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Abrayami alobaki na mosali na ye, oyo awumelaki mingi na ndako na ye mpe azalaki kokamba biloko na ye nyonso : — Tia loboko na yo na se ya mopende na ngai ");
INSERT INTO lin_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","mpe lapa ndayi na Kombo na Yawe, Nzambe oyo asala likolo mpe mokili, ete okozwela te mwana na ngai ya mobali mwasi kati na bana basi ya Kanana, ba-oyo nazali kovanda kati na bango. ");
INSERT INTO lin_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Kasi okokende na mokili na ngai mpe na libota na ngai, mpe okozwa mwasi moko mpo na Izaki, mwana na ngai ya mobali. ");
INSERT INTO lin_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Mosali atunaki ye : — Tango mosusu mwasi yango akolinga na ye te kolanda ngai na mokili oyo. Boni, nakoki na ngai kozongisa mwana na yo ya mobali na mokili epai wapi owuta ? ");
INSERT INTO lin_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abrayami alobaki : — Keba na yo ! Kozongisa mwana na ngai kuna te. ");
INSERT INTO lin_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Yawe, Nzambe ya likolo, oyo abimisaki ngai na ndako ya tata na ngai mpe na mokili epai wapi nabotama, oyo alobaki na ngai mpe alakaki ngai na nzela ya ndayi ete akopesa mokili oyo na bakitani na ngai, akotindela yo anjelu na Ye mpo ete azala liboso na yo mpe mpo ete okoka koyela mwana na ngai ya mobali mwasi ya mokili wana. ");
INSERT INTO lin_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Soki mwasi yango aboyi na ye kolanda yo, wana okangolami na ndayi oyo nazali kosenga yo kolapa. Kasi komeka kozongisa mwana na ngai ya mobali kuna te. ");
INSERT INTO lin_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Boye, mosali atiaki loboko na se ya mopende ya Abrayami, nkolo na ye, alapaki ndayi ya kosala makambo yango. ");
INSERT INTO lin_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Bongo mosali azwaki bashamo zomi kati na bashamo ya nkolo na ye elongo na biloko ya ndenge na ndenge oyo eleki kitoko ; akendeki na Arami mpe azwaki nzela ya engumba ya Naori. ");
INSERT INTO lin_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Tango akomaki kuna, avandisaki bashamo pembeni ya libulu ya mayi, na libanda ya engumba. Ezalaki na pokwa, na tango oyo basi babimaka mpo na kotoka mayi. ");
INSERT INTO lin_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Abondelaki : « Eh Yawe, Nzambe ya Abrayami, nkolo na ngai, longisa ngai na mokolo ya lelo mpe lakisa bolamu na Yo epai ya Abrayami, nkolo na ngai. ");
INSERT INTO lin_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Tala, natelemi pene ya libulu ya mayi mpe bana basi ya engumba bazali kobima mpo na koya kotoka mayi. ");
INSERT INTO lin_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Tika ete mwana mwasi oyo nakoloba na ye : ‹ Nabondeli yo, tengemisa mbeki na yo mpo ete namela mayi, › mpe ye akozongisela ngai : ‹ Mela na yo, mpe nakomelisa lisusu bashamo na yo, › azala mwasi oyo oponi mpo na Izaki, mosali na Yo. Na nzela oyo, nakoyeba ete olakisi bolamu na Yo epai ya nkolo na ngai. » ");
INSERT INTO lin_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Liboso ete asilisa kosambela, Rebeka abimaki na mbeki na ye na lipeka. Azalaki mwana mwasi ya Betweli, mwana mobali ya Milika oyo azalaki mwasi ya Naori, ndeko ya Abrayami. ");
INSERT INTO lin_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Elenge mwasi azalaki kitoko penza, ayebaki nanu nzoto ya mibali te ; ata mobali moko te asangisaki na ye nzoto. Akitaki na libulu ya mayi, atondisaki mbeki na ye mpe amataki. ");
INSERT INTO lin_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Mosali akimaki mbangu mpo na kokutana na ye mpe alobaki : — Nabondeli yo, tika ngai namela ndambo ya mayi na mbeki na yo. ");
INSERT INTO lin_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Mwana mwasi alobaki : — Mela na yo, nkolo na ngai ! Akitisaki mbeki mbangu na maboko na ye mpe apesaki ye mpo ete amela. ");
INSERT INTO lin_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Sima na kopesa ye mayi ya komela, alobaki : — Nakotoka lisusu mayi mpo na bashamo na yo nyonso kino ekosilisa komela. ");
INSERT INTO lin_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Asalaki na lombangu mpe asopaki mayi nyonso ya mbeki na ye na esika oyo banyama emelelaka mayi ; akimaki lisusu na libulu mpe atokaki mayi mpo na bashamo na ye nyonso. ");
INSERT INTO lin_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Mosali azalaki kotala ye na bokebi, alobaki eloko moko te mpo na koyeba soki Yawe alongisi mobembo na ye to te. ");
INSERT INTO lin_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Tango bashamo esilisaki komela mayi, mosali azwaki lopete moko ya wolo, oyo batiaka na zolo mpe ezalaki ya bagrame motoba. Azwaki mpe basheneti mibale ya wolo : moko na moko ezalaki na bagrame koleka nkama moko. ");
INSERT INTO lin_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Atunaki ye : — Ozali mwana mwasi ya nani ? Nabondeli yo, yebisa ngai. Boni, esika ekoki komonana na ndako ya tata na yo mpo na biso mpo ete tolekisa kuna butu ? ");
INSERT INTO lin_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Azongiselaki ye : — Nazali mwana ya Betweli, mwana mobali ya Milika mpe Naori. ");
INSERT INTO lin_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Abakisaki : — Tozali na matiti mpe biloko ebele ya koleisa bibwele ; tozali mpe na esika mpo na yo mpo ete olekisa butu. ");
INSERT INTO lin_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Boye, mosali akitisaki moto na ye na se mpe agumbamelaki Yawe. ");
INSERT INTO lin_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Alobaki : « Tika ete Yawe, Nzambe ya nkolo na ngai, Abrayami, akumisama ; Ye oyo atiki te kolakisa bolamu na Ye mpe boyengebene na Ye epai ya nkolo na ngai, pamba te atambolisi ngai na mobembo kino na ndako ya bandeko ya nkolo na ngai ! » ");
INSERT INTO lin_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Elenge mwasi akimaki mbangu na ndako mpe alobaki epai ya mama na ye makambo oyo elekaki. ");
INSERT INTO lin_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rebeka azalaki na ndeko moko ya mobali oyo kombo na ye ezalaki « Labani. » Ye mpe abimaki mbangu mpo na kokutana na mosali ya Abrayami kuna na libulu ya mayi. ");
INSERT INTO lin_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Tango kaka amonaki lopete oyo batiaki na zolo mpe basheneti na maboko ya ndeko na ye ya mwasi, mpe ayokaki Rebeka koloba makambo oyo mosali alobaki mpo na ye, akendeki epai ya mosali mpo ete amonaki ye ya kotelema pene ya bashamo, pembeni ya libulu ya mayi. ");
INSERT INTO lin_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Alobaki : « Yaka na ndako na biso, yo oyo opambolama na Yawe. Mpo na nini otelemi awa na libanda ? Nabongisi ndako mpe esika mpo na bashamo. » ");
INSERT INTO lin_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Boye mosali ya Abrayami akotaki na ndako ya Labani, mpe bakitisaki biloko oyo ezalaki na likolo ya bashamo. Bamemaki bashamo na ye na esika oyo ezalaki na matiti mpe bilei ya banyama. Bamemaki mpe mayi mpo na ye mpe mpo na bato oyo bazalaki elongo na ye mpo ete basukola makolo. ");
INSERT INTO lin_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Batielaki ye lisusu biloko ya kolia, kasi alobaki : — Nakoki kolia te kino nakosilisa koloba makambo nyonso oyo nazali na yango. Labani alobaki na ye : — Yebisa biso makambo yango. ");
INSERT INTO lin_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Azongisaki : — Nazali mosali ya Abrayami. ");
INSERT INTO lin_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Yawe apambola mingi nkolo na ngai mpe akomisa ye mozwi : apesa ye bameme, bantaba, bangombe, palata mpe wolo, basali ya mibali mpe ya basi, ba-ane mpe bashamo. ");
INSERT INTO lin_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Sara, mwasi ya nkolo na ngai, na kimobange na ye, abotelaki nkolo na ngai mwana mobali, mpe nkolo na ngai apesaki biloko na ye nyonso epai ya mwana yango. ");
INSERT INTO lin_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Nzokande, nkolo na ngai alapisaki ngai ndayi na maloba oyo : « Kati na bana basi ya Kanana epai wapi nazali kovanda, okozwela mwana na ngai mwasi awa te. ");
INSERT INTO lin_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Kasi okokende na libota ya tata na ngai mpe na ekolo na ngai, kuna nde okozwa mwasi mpo na mwana na ngai ya mobali. » ");
INSERT INTO lin_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Nazongiselaki nkolo na ngai : « Tango mosusu, mwasi yango akolinga na ye kolanda ngai te. » ");
INSERT INTO lin_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Mpe ye alobaki na ngai lisusu : « Yawe oyo natambolaki liboso na Ye akotinda anjelu na Ye elongo na yo mpe akolongisa mobembo na yo mpo ete ozwela mwana na ngai ya mobali mwasi oyo akowuta na ekolo na ngai mpe na libota ya tata na ngai. ");
INSERT INTO lin_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Boye tango okokende na ekolo na ngai, soki baboyi kopesa yo ye, okozala na ngambo te na ndayi oyo nalapisi yo. » ");
INSERT INTO lin_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Nzokande lelo, tango nakomaki na libulu ya mayi, nasambelaki : « Oh Yawe, Nzambe ya nkolo na ngai, Abrayami, nabondeli Yo, longisa mobembo na ngai. ");
INSERT INTO lin_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Tala ngai, natelemi pembeni ya libulu oyo ya mayi, elenge mwasi oyo akobima mpo na koya kotoka mayi mpe oyo nakoloba na ye : ‹ Nabondeli yo, nakoki kozwa ndambo ya mayi ya komela na mbeki na yo ? › ");
INSERT INTO lin_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Mpe ye akozongisela ngai : ‹ Mela na yo, mpe nakotoka lisusu mayi mpo na bashamo na yo, › tika ete ye nde azala mwasi oyo Yawe aponi mpo na mwana mobali ya nkolo na ngai. » ");
INSERT INTO lin_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Liboso ete nasilisa kosambela kati na motema na ngai, Rebeka abimaki na mbeki na lipeka na ye. Akitaki na libulu ya mayi mpe atokaki mayi. Nalobaki na ye : « Nabondeli yo, pesa ngai mayi ya komela. » ");
INSERT INTO lin_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Akitisaki mbangu mbeki na ye wuta na lipeka na ye mpe alobaki : « Mela na yo, mpe nakomelisa lisusu bashamo na yo. » Boye namelaki mayi, mpe amelisaki lisusu bashamo mayi. ");
INSERT INTO lin_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Natunaki ye : « Ozali mwana mwasi ya nani ? » Azongisaki : « Nazali mwana mwasi ya Betweli, mwana mobali oyo Milika abotelaki Naori. » Boye natiaki lopete na zolo na ye mpe basheneti na maboko na ye. ");
INSERT INTO lin_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Nakitisaki elongi na se mpe nagumbamelaki Yawe ; nakumisaki Yawe, Nzambe ya nkolo na ngai, Abrayami, oyo atambolisaki ngai na nzela ya sembo mpo na kozwela mwana na ye ya mobali mwana mwasi ya ndeko ya nkolo na ngai. ");
INSERT INTO lin_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Mpe sik’oyo, boyebisa ngai soki bokosalela nkolo na ngai bolamu mpe boyengebene. Soki te, boyebisa ngai mpo ete naluka nzela mosusu. ");
INSERT INTO lin_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Labani mpe Betweli bazongisaki : — Makambo oyo nyonso ewuti epai na Yawe. Tozali na likambo mosusu te ya koloba na yo. ");
INSERT INTO lin_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Tala Rebeka, azali liboso na yo ! Kamata ye mpe kende na ye ; mpe tika ete azala mwasi ya mwana mobali ya nkolo na yo, ndenge Yawe abongisi. ");
INSERT INTO lin_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Tango mosali ya Abrayami ayokaki makambo oyo bayebisaki ye, akitisaki elongi na ye kino na se liboso ya Yawe. ");
INSERT INTO lin_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Abimisaki biloko ya wolo, ya palata mpe bilamba ; bongo apesaki yango na Rebeka. Apesaki mpe bakado ya motuya epai ya ndeko na ye ya mobali mpe epai ya mama na ye. ");
INSERT INTO lin_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Sima na yango, mosali ya Abrayami mpe bato oyo bazalaki elongo na ye baliaki, bamelaki mpe balekisaki butu kati na ndako wana. Na tongo, tango balamukaki, mosali ya Abrayami alobaki na bango : — Botika ete nazonga epai ya nkolo na ngai. ");
INSERT INTO lin_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Ndeko mobali mpe mama ya Rebeka bazongisaki : — Tika ete elenge mwasi atikala nanu elongo na biso mikolo zomi, sima nde bokoki kokende. ");
INSERT INTO lin_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Kasi alobaki na bango : — Bowumisa ngai te, pamba te Yawe alongisi mobembo na ngai ; botika ngai kokende mpo ete nazonga epai ya nkolo na ngai. ");
INSERT INTO lin_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Balobaki na ye : — Tika ete tobenga elenge mwasi mpe totuna posa na ye. ");
INSERT INTO lin_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Babengaki Rebeka mpe batunaki ye : — Ondimi solo kokende na mobali oyo ? Rebeka azongisaki : — Iyo, nandimi. ");
INSERT INTO lin_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Boye batikaki ndeko na bango ya mwasi Rebeka ete akende elongo na mama oyo asungaka ye, na mosali ya Abrayami elongo na bato na ye. ");
INSERT INTO lin_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Bapambolaki Rebeka mpe balobaki na ye : « Ndeko na biso ya mwasi, tika ete okoma mama ya nkoto ya bato, mpe tika ete bana na yo bakamata bingumba ya banguna na bango ! » ");
INSERT INTO lin_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Boye Rebeka elongo na basali na ye ya basi batelemaki, bamataki likolo ya bashamo mpe balandaki mosali ya Abrayami. Bongo mosali ya Abrayami akamataki Rebeka mpe bakendeki na ye nzela moko. ");
INSERT INTO lin_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Nzokande, Izaki azalaki kovanda na Negevi mpe awutaki na libulu ya mayi na Lakai-Royi. ");
INSERT INTO lin_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Na pokwa, Izaki akendeki na bilanga mpo na kozwa tango ya kokanisa na bozindo. Tango atombolaki miso, amonaki bashamo kopusana pene ya esika oyo azalaki. ");
INSERT INTO lin_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Tango Rebeka mpe atombolaki miso, amonaki Izaki mpe akitaki wuta na shamo na ye. ");
INSERT INTO lin_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Atunaki mosali ya Abrayami : — Nazali komona mobali moko kati na bilanga, azali koya kokutana na biso ; azali nani ? Mosali ya Abrayami azongisaki : — Azali nkolo na ngai. Bongo Rebeka azwaki vwale na ye mpe amizipaki na elongi. ");
INSERT INTO lin_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Mosali ya Abrayami ayebisaki Izaki makambo nyonso oyo asalaki. ");
INSERT INTO lin_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Na yango, Izaki amemaki Rebeka kati na ndako ya kapo ya mama na ye Sara, azwaki ye mpo ete azala mwasi na ye mpe alingaki ye. Boye Izaki abondisamaki na kufa ya mama na ye. ");
INSERT INTO lin_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abrayami abalaki mwasi mosusu, kombo na ye « Ketura. » ");
INSERT INTO lin_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ketura abotelaki ye : Zimirani, Yokishani, Medani, Madiani, Ishibaki mpe Shuwa. ");
INSERT INTO lin_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yokishani azalaki tata ya Saba mpe Dedani. Tala bato oyo bazalaki bakitani ya Dedani : Bato ya Ashuri, ya Letushi mpe ya Lewumi. ");
INSERT INTO lin_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Madiani azalaki tata ya Efa, ya Eferi, ya Enoki, ya Abida mpe ya Elida. Bato oyo nyonso bazalaki bakitani ya Ketura. ");
INSERT INTO lin_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abrayami atikaki biloko na ye nyonso na maboko ya Izaki. ");
INSERT INTO lin_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Kasi wana Abrayami azalaki nanu na bomoi, apesaki bakado epai ya bana mibali ya bamakangu na ye mpe atindaki bango na mokili ya este, mosika ya mwana na ye ya mobali Izaki. ");
INSERT INTO lin_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abrayami awumelaki na bomoi mibu nkama moko na tuku sambo na mitano. ");
INSERT INTO lin_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Bongo Abrayami akataki motema mpe akufaki. Sima na ye kotonda mikolo mpe kokoma mobange makasi, akendeki kokutana na bakoko na ye. ");
INSERT INTO lin_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Bana na ye ya mibali, Izaki mpe Isimaeli, bakundaki ye na lilita ya mabanga ya Makipela pene ya Mamire, kati na elanga ya Efroni, mwana mobali ya Tsoari, moto ya Iti. ");
INSERT INTO lin_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Abrayami asombaki elanga yango epai ya bato ya Iti. Ezalaki kuna nde bakundaki mwasi na ye Sara. ");
INSERT INTO lin_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Sima na kufa ya Abrayami, Nzambe apambolaki Izaki, mwana mobali ya Abrayami. Izaki azalaki kovanda pene ya Lakai-Royi. ");
INSERT INTO lin_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Tala molongo ya bakitani ya Isimaeli, mwana mobali ya Abrayami, oyo Agari, moto ya Ejipito mpe mwasi mosali ya Sara, abotelaki Abrayami. ");
INSERT INTO lin_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Tala bakombo ya bana mibali ya Isimaeli kolanda ndenge babotamela : Nebayoti, mwana mobali ya liboso ya Isimaeli ; Kedari, Adibeli, Mibisami, ");
INSERT INTO lin_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mishima, Duma, Masa, ");
INSERT INTO lin_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Adadi, Tema, Yeturi, Nafishi mpe Kedima. ");
INSERT INTO lin_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Bango nde bazalaki bana mibali zomi na mibale ya Isimaeli. Moko na moko azalaki mokambi ya libota, mpe apesaki kombo na ye na mboka na ye mpe na molako na ye. ");
INSERT INTO lin_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Isimaeli awumelaki na bomoi mibu nkama moko na tuku misato na sambo. Akataki motema mpe akufaki ; akendeki kokutana na bakoko na ye. ");
INSERT INTO lin_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Bakitani na ye bazalaki kovanda na mokili oyo ezalaki kati na Avila mpe Shuri, pene ya Ejipito, na nzela oyo ekenda na Asiri. Bazalaki tango nyonso kovanda lokola banguna ya bandeko na bango nyonso. ");
INSERT INTO lin_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Tala libota ya Izaki, mwana mobali ya Abrayami. Abrayami azalaki tata ya Izaki, ");
INSERT INTO lin_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","mpe Izaki azalaki na mibu tuku minei ya mbotama tango abalaki Rebeka, mwana mwasi ya Betweli, moto ya Arami ya Padani-Arami, mpe ndeko mwasi ya Labani, moto ya Arami. ");
INSERT INTO lin_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Izaki abondelaki Yawe mpo na Rebeka, mwasi na ye, oyo azalaki ekomba. Yawe ayanolaki libondeli na ye, mpe Rebeka akomaki na zemi. ");
INSERT INTO lin_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Kati na libumu na ye, bana bazalaki kowelana. Alobaki : « Likambo nini oyo ekomeli ngai ? » Boye, akendeki kotuna Yawe. ");
INSERT INTO lin_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Yawe alobaki na ye : « Bikolo mibale ezali kati na libumu na yo, mpe mabota mibale ekabwana ekobima na libumu na yo ; ekolo moko ekoleka ekolo mosusu na makasi, mpe kulutu akosalela leki. » ");
INSERT INTO lin_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Wana tango na ye ya kobota ekokaki, azalaki na mapasa mibale kati na libumu na ye. ");
INSERT INTO lin_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Lipasa ya liboso oyo abimaki azalaki motane mpe nzoto na ye mobimba ezalaki etonda na bapwale lokola elamba ya bapwale ; yango wana babengaki ye « Ezawu. » ");
INSERT INTO lin_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Sima na yango, ndeko na ye mpe abimaki, loboko na ye ekanga litindi ya Ezawu ; yango wana bapesaki ye kombo « Jakobi. » Izaki azalaki na mibu tuku motoba ya mbotama tango Rebeka abotaki. ");
INSERT INTO lin_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Bana mibali yango bakolaki. Ezawu akomaki mobomi makasi ya banyama mpe azalaki kolekisa tango mingi na zamba ; Jakobi azalaki moto ya kimia, azalaki kosepela kovanda na ndako. ");
INSERT INTO lin_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Izaki abandaki kosepela mingi na misuni, yango wana alingaki mingi Ezawu ; mpe Rebeka alingaki mingi Jakobi. ");
INSERT INTO lin_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Mokolo moko, wana Jakobi azalaki kolamba elubu, Ezawu oyo awutaki na bilanga ayaki na kolemba. ");
INSERT INTO lin_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Ezawu alobaki na Jakobi : — Nalembi makasi ; tika ngai nalia elubu oyo, elubu oyo kaka. Yango wana bazalaki mpe kobenga ye Edomi. ");
INSERT INTO lin_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Jakobi azongisaki : — Tekela ngai liboso boyaya na yo. ");
INSERT INTO lin_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Ezawu azongisaki : — Tala, nakokufa na nzala. Boyaya na ngai ekopesa ngai nini ? ");
INSERT INTO lin_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Kasi Jakobi alobaki : — Lapa liboso ndayi. Ezawu alapaki ndayi epai ya Jakobi ; mpe na nzela wana, atekaki boyaya na ye epai ya Jakobi. ");
INSERT INTO lin_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Jakobi apesaki Ezawu lipa mpe elubu ya misili. Ezawu aliaki mpe amelaki, bongo atelemaki mpe akendeki. Ezali ndenge wana nde Ezawu atiolaki boyaya na ye. ");
INSERT INTO lin_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Wana nzala makasi ekotaki lisusu na mokili lokola na tango ya Abrayami, Izaki akendeki na Gerari epai ya Abimeleki, mokonzi ya bato ya Filisitia. ");
INSERT INTO lin_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Boye Yawe abimelaki ye mpe ayebisaki ye : — Kokende na Ejipito te ! Vanda na mokili oyo nakolakisa yo. ");
INSERT INTO lin_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Vanda kati na mokili oyo ; nakozala na yo elongo mpe nakopambola yo, pamba te nakopesa mabele oyo nyonso epai na yo mpe epai ya bana na yo ; nakokokisa ndayi oyo nalapaki epai ya Abrayami, tata na yo. ");
INSERT INTO lin_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Nakokomisa bakitani na yo ebele lokola minzoto ya likolo mpe nakopesa bango mabele oyo nyonso. Boye mpo na bakitani na yo, bikolo nyonso ya mokili ekomipambola. ");
INSERT INTO lin_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Nakosala yango mpo ete Abrayami atosaki Ngai, abatelaki bikateli na Ngai, mitindo na Ngai mpe mibeko na Ngai. ");
INSERT INTO lin_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Boye, Izaki avandaki na Gerari. ");
INSERT INTO lin_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Tango bato ya esika wana batunaki ye na tina na mwasi na ye, azongisaki : — Azali ndeko na ngai ya mwasi. Azalaki koloba te ete azali mwasi na ye mpo ete azalaki kobanga ete bato ya mboka baboma ye mpo na Rebeka, pamba te azalaki penza kitoko. ");
INSERT INTO lin_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Tango awumelaki na mboka yango, Abimeleki, mokonzi ya bato ya Filisitia, atalaki wuta na lininisa mpe amonaki Izaki kosakana na mwasi na ye Rebeka. ");
INSERT INTO lin_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Bongo Abimeleki abengisaki ye mpe alobaki na ye : — Rebeka azali solo mwasi na yo. Mpo na nini olobaki : « Azali ndeko na ngai ya mwasi ? » Izaki azongisaki : — Kati na ngai, nazalaki koloba ete nakokaki kokufa mpo na ye. ");
INSERT INTO lin_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimeleki alobaki lisusu : — Nasali bino likambo nini ? Etikalaki kaka moke ete mobali moko kati na bato na ngai akota mpe asangisa nzoto na mwasi na yo. Boye, olingaki komemisa biso ngambo. ");
INSERT INTO lin_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Abimeleki apesaki mitindo na bato nyonso : — Moto nyonso oyo akosala mabe na moto oyo mpe na mwasi na ye, akokufa. ");
INSERT INTO lin_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Izaki alonaki mbuma na mabele oyo mpe abukaki monkama na monkama na oyo alonaki, pamba te Yawe apambolaki ye. ");
INSERT INTO lin_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Izaki akomaki mozwi, mpe bozwi na ye ekobaki kaka komata kino akomaki moto na bozwi ebele. ");
INSERT INTO lin_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Bato ya Filisitia bakomaki koyokela ye likunya, pamba te azalaki na bameme ebele, bantaba ebele, bangombe ebele mpe basali ebele. ");
INSERT INTO lin_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Boye bato ya Filisitia bakundaki mabulu nyonso oyo basali ya Abrayami, tata na ye, batimolaki tango azalaki nanu na bomoi mpe batondisaki yango na mabele. ");
INSERT INTO lin_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Bongo Abimeleki alobaki na Izaki : — Kende mosika na biso, pamba te okomi na nguya mingi koleka biso. ");
INSERT INTO lin_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Izaki alongwaki wana mpe akendeki kotonga ndako na ye ya kapo na lubwaku ya Gerari epai wapi avandaki. ");
INSERT INTO lin_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Atimolaki lisusu mabulu ya mayi oyo batimolaki na tango ya tata na ye Abrayami. Mabulu yango ezalaki bato ya Filisitia nde bakundaki yango sima na kufa ya Abrayami, mpe Izaki abengaki yango kaka na bakombo oyo tata na ye Abrayami apesaka yango. ");
INSERT INTO lin_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Basali ya Izaki batimolaki na lubwaku mpe bamonaki kuna libulu ya mayi ya peto. ");
INSERT INTO lin_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Babateli bibwele ya Gerari baswanisaki babateli bibwele ya Izaki mpe balobaki na bango : « Mayi oyo ezali ya biso. » Izaki apesaki libulu yango kombo « Eseki, » pamba te baswanisaki ye na tina na yango. ");
INSERT INTO lin_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Batimolaki libulu mosusu, kasi baswanisaki ye lisusu na tina na yango, mpe apesaki yango kombo « Sitina. » ");
INSERT INTO lin_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Alongwaki wana mpe akendeki kotimola libulu mosusu ; mpe moto moko te aswanisaki ye na tina na yango. Yango wana apesaki yango kombo « Reoboti, » pamba te alobaki : « Sik’oyo, Yawe apesi biso esika monene, mpe tokofuluka na mokili oyo. » ");
INSERT INTO lin_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Kolongwa wana, akendeki na Beri-Sheba. ");
INSERT INTO lin_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Na butu ya mokolo oyo Izaki akomaki na Beri-Sheba, Yawe abimelaki ye mpe alobaki na ye : « Nazali Nzambe ya Abrayami, tata na yo ; kobanga te, nazali elongo na yo. Mpo na Abrayami, mosali na Ngai, nakopambola yo mpe nakokomisa bakitani na yo ebele. » ");
INSERT INTO lin_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Kaka na esika yango, Izaki atongaki etumbelo, abelelaki Kombo ya Yawe, atongaki ndako na ye ya kapo. Basali na ye batimolaki libulu mosusu ya mayi. ");
INSERT INTO lin_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Wuta na Gerari, Abimeleki elongo na Awuzati, mopesi toli na ye, mpe Pikoli, mokonzi ya mampinga na ye, bayaki kokutana na Izaki. ");
INSERT INTO lin_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Izaki atunaki bango : — Mpo na nini boyei epai na ngai, bino bato oyo bolingaka ngai te mpe bobenganaki ngai epai na bino ? ");
INSERT INTO lin_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Bazongiselaki ye : — Tomoni ya solo ete Yawe azali elongo na yo, yango wana tolobaki : « Tika ete tosala boyokani kati na biso mpe yo na nzela ya ndayi. ");
INSERT INTO lin_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Lapa ndayi ete okosala biso mabe te ndenge biso mpe tosalaki yo mabe te ; tosalelaki yo kaka bolamu mpe totikaki yo kokende na kimia. Sik’oyo, Yawe apamboli yo. » ");
INSERT INTO lin_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Izaki asalelaki bango feti monene ; baliaki mpe bamelaki. ");
INSERT INTO lin_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Na tongo-tongo ya mokolo oyo elandaki, balapanaki ndayi ; bongo Izaki abimisaki bango na nzela mpe atikaki bango kokende na kimia. ");
INSERT INTO lin_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Kaka na mokolo yango, basali ya Izaki bayaki kopesa ye sango ete bamoni mayi na libulu oyo bazalaki kotimola. ");
INSERT INTO lin_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Izaki apesaki libulu yango kombo « Sheba. » Yango wana engumba yango ebengami kino lelo Beri-Sheba. ");
INSERT INTO lin_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Tango Ezawu akokisaki mibu tuku minei ya mbotama, abalaki Jiditi, mwana mwasi ya Beri, moto ya mokili ya Iti, mpe Basimati, mwana mwasi ya Eloni, moto ya mokili ya Iti. ");
INSERT INTO lin_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Basi yango bazalaki koyokisa Izaki mpe Rebeka pasi na motema. ");
INSERT INTO lin_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Tango Izaki akomaki mobange mpe miso na ye ezalaki komona lisusu malamu te, abengaki Ezawu, mwana na ye ya liboso ya mobali. Alobaki na ye : — Mwana na ngai ! Ezawu azongisaki : — Ngai oyo ! ");
INSERT INTO lin_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Izaki alobaki : — Nakomi mobange mpe nayebi mokolo ya kufa na ngai te. ");
INSERT INTO lin_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Yango wana, zwa sik’oyo mandoki na yo ya bokila, saki ya bokila mpe tolotolo ; kende na zamba mpe bomela ngai nyama. ");
INSERT INTO lin_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Okolambela ngai elubu ya kitoko ndenge nalingaka mpe okomemela ngai yango ; nakolia mpo ete napambola yo liboso ete nakufa. ");
INSERT INTO lin_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Nzokande, Rebeka azalaki koyoka makambo oyo Izaki azalaki koyebisa mwana na ye Ezawu. Tango Ezawu akendeki na zamba mpo na koboma nyama mpe kozonga na yango, ");
INSERT INTO lin_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebeka ayebisaki Jakobi, mwana na ye ya mibale : — Tala, nayokaki tata na yo koyebisa Ezawu, ndeko na yo : ");
INSERT INTO lin_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","« Memela ngai nyama ! Okolambela ngai elubu ya kitoko, mpe nakolia yango mpo ete napambola yo na miso ya Yawe liboso ete nakufa. » ");
INSERT INTO lin_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Mwana na ngai, yoka ngai malamu sik’oyo mpe sala makambo oyo nakoyebisa yo : ");
INSERT INTO lin_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Kende na etonga ya bibwele mpe pona bana ntaba mibale mpe memela ngai yango mpo ete nalambela tata na yo elubu ya kitoko ndenge alingaka. ");
INSERT INTO lin_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Bongo, okomemela yango tata na yo ; akolia yango mpo ete apambola yo liboso ete akufa. ");
INSERT INTO lin_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Jakobi azongiselaki Rebeka, mama na ye : — Ezawu, ndeko na ngai, azali na bapwale ebele na nzoto, kasi ngai nazali na yango te. ");
INSERT INTO lin_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Soki tata na ngai asimbi ngai, akososola ete nalingi kokosa ye ; wana nakomibendela bilakeli mabe na esika ete napambolama. ");
INSERT INTO lin_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Mama na ye alobaki : — Mwana na ngai, tika ete bilakeli mabe yango ekweya likolo na ngai ; yo, sala kaka makambo oyo ngai nayebisi yo. ");
INSERT INTO lin_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Boye Jakobi akendeki, azwaki bana ntaba mpe amemaki yango epai ya mama na ye, mpe mama na ye alambaki elubu ya kitoko ndenge tata na ye azalaki kolinga. ");
INSERT INTO lin_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Bongo Rebeka azwaki na ndako, bilamba oyo elekaki kitoko kati na bilamba ya Ezawu, mwana na ye ya liboso, mpe alatisaki yango Jakobi, mwana na ye ya suka. ");
INSERT INTO lin_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Azipaki ye maboko mpe kingo na poso ya bana ntaba. ");
INSERT INTO lin_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Bongo Rebeka apesaki na maboko ya Jakobi, mwana na ye, elubu ya kitoko mpe lipa oyo alambaki. ");
INSERT INTO lin_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Jakobi akendeki epai ya tata na ye mpe alobaki : — Tata na ngai ! Izaki azongisaki : — Ngai oyo, mwana na ngai ; yo nani ? ");
INSERT INTO lin_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Jakobi alobaki na tata na ye : — Nazali Ezawu, mwana na yo ya liboso. Nasali ndenge oyebisaki ngai. Nabondeli yo, lamuka, vanda mpe lia nyama, mpo ete opambola ngai. ");
INSERT INTO lin_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Izaki atunaki mwana na ye : — Mwana na ngai, osali ndenge nini mpo ete ozwa nyama noki ? Jakobi azongisaki : — Ezali Yawe, Nzambe na yo, nde atindaki yango na nzela na ngai. ");
INSERT INTO lin_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Izaki alobaki na Jakobi : — Mwana na ngai, pusana pembeni na ngai mpo ete nasimba yo mpe nayeba soki ozali solo mwana na ngai Ezawu. ");
INSERT INTO lin_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Jakobi akendeki pembeni na ye, bongo Izaki asimbaki ye mpe alobaki : — Mongongo ezali ya Jakobi, kasi maboko ezali ya Ezawu. ");
INSERT INTO lin_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Tata na ye ayebaki ye te, pamba te maboko ya Jakobi ezalaki na bapwale lokola ya Ezawu, ndeko na ye ; boye apambolaki ye. ");
INSERT INTO lin_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Kasi liboso, atunaki ye : — Ozali penza mwana na ngai Ezawu ? Jakobi azongisaki : — Iyo, ezali ngai solo. ");
INSERT INTO lin_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Izaki alobaki : — Mwana na ngai, memela ngai nyama na yo mpo ete nalia mpe napambola yo. Jakobi amemelaki ye nyama, mpe Izaki aliaki. Amemelaki ye lisusu masanga ya vino mpe amelaki. ");
INSERT INTO lin_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Sima, tata na ye, Izaki, alobaki na ye : — Mwana na ngai, yaka awa mpe pesa ngai beze. ");
INSERT INTO lin_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Jakobi akendeki mpe apesaki ye beze. Tango Izaki ayokaki solo ya bilamba na ye, apambolaki ye na maloba oyo : « Ah ! Solo ya mwana na ngai ezali lokola solo ya bilanga oyo Yawe apamboli. ");
INSERT INTO lin_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Tika ete Nzambe apesa yo mvula ya likolo mpe mabele ya bozwi ; apesa yo mbuma ya ble mpe vino ebele penza ! ");
INSERT INTO lin_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Tika ete bikolo esalela yo, bato bafukamela yo ! Zala mokonzi ya bandeko na yo ya mibali, mpe tika ete bana mibali ya mama na yo bafukama liboso na yo ! Tika ete moto oyo akolakela yo mabe alakelama mabe ; tika ete moto oyo akopambola yo apambolama ! » ");
INSERT INTO lin_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Tango Izaki asilisaki kopambola ye, Jakobi atikaki tata na ye ; bongo ndeko na ye, Ezawu, azongaki wuta na bokila. ");
INSERT INTO lin_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ye mpe alambaki elubu mpe amemaki yango epai ya tata na ye. Alobaki na ye : — Tata na ngai, telema mpe lia nyama na ngai mpo ete opambola ngai. ");
INSERT INTO lin_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Tata na ye, Izaki, atunaki ye : — Yo nani ? Azongisaki : — Ngai Ezawu, mwana na yo ya liboso. ");
INSERT INTO lin_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Bongo Izaki alengaki makasi mpe alobaki : — Nani wana abomaki nyama mpe amemelaki ngai yango ? Naliaki yango liboso ete yo oya, mpe napambolaki ye. Boye apambolami solo ! ");
INSERT INTO lin_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Tango Ezawu ayokaki maloba ya tata na ye, atombolaki mongongo makasi mpe agangaki. Alobaki na tata na ye : — Ah ! Tata na ngai, pambola ngai, pambola ngai mpe lokola ! ");
INSERT INTO lin_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Izaki alobaki : — Ndeko na yo ayaki na mayele mabe, ayibi mapamboli na yo. ");
INSERT INTO lin_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Ezawu alobaki : — Mpo ete kombo na ye ezali « Jakobi, » yango wana akosi ngai mbala mibale ? Ya liboso, azwaki boyaya na ngai, mpe tala sik’oyo azwi lisusu mapamboli na ngai ! Bongo atunaki : — Boni, obombelaki ngai mapamboli te ? ");
INSERT INTO lin_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Izaki azongiselaki Ezawu : — Tala, nakomisi ye nkolo na yo mpe napesi ye bandeko na ye nyonso lokola basali ; napesi ye ble mpe vino. Mwana na ngai, nasala lisusu nini mpo na yo ? ");
INSERT INTO lin_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Ezawu alobaki na tata na ye : — Tata na ngai, ozalaki kaka na lipamboli moko wana ? Tata na ngai, pambola ngai mpe ! Ezawu atombolaki mongongo na ye mpe alelaki makasi. ");
INSERT INTO lin_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Tata na ye, Izaki, alobaki na ye : — Okovanda mosika ya mabele oyo ebotaka malamu, mpe mosika ya mvula ya likolo. ");
INSERT INTO lin_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Okobika na nzela ya mopanga na yo mpe okosalela ndeko na yo ya mobali. Kasi tango okotambola bipai na bipai, okobuka ekangiseli oyo akotia yo na kingo. ");
INSERT INTO lin_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Ezawu ayinaki Jakobi likolo ya mapamboli oyo azwaki epai ya tata na ye mpe amilobelaki : « Etikali moke tata na ngai akufa ; bongo nakoboma ndeko na ngai Jakobi. » ");
INSERT INTO lin_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Tango Rebeka asosolaki makanisi ya Ezawu, mwana na ye ya liboso, abengaki Jakobi, mwana na ye ya suka, mpe alobaki na ye : « Tala, Ezawu, ndeko na yo, azali koluka koboma yo. ");
INSERT INTO lin_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Mwana na ngai, yoka ngai sik’oyo mpe sala makambo oyo nazali koyebisa yo : ‹ Longwa awa mpe kima na mboka Arani, epai ya ndeko na ngai Labani. ");
INSERT INTO lin_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Vanda mwa mikolo epai na ye kino kanda ya ndeko na yo ekosila. ");
INSERT INTO lin_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Tango kanda na ye ekosila mpe akobosana makambo oyo osalaki ye, nakotindela yo maloba mpo ete olongwa kuna mpe ozonga. Mpo na nini nazanga bino mibale mokolo moko ? › » ");
INSERT INTO lin_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Rebeka akendeki koyebisa Izaki : « Nalembi mokili likolo ya basi oyo ya mokili ya Iti. Soki Jakobi abali mwasi kati na bana basi ya mokili oyo, tina nazala na bomoi ekozala lisusu te. » ");
INSERT INTO lin_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Bongo Izaki abengaki Jakobi, apambolaki ye mpe apesaki ye mitindo oyo : « Okobala mwasi te kati na bana basi ya Kanana. ");
INSERT INTO lin_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Telema ! Kende mbala moko na Padani-Arami, na ndako ya koko na yo, Betweli, tata ya mama na yo. Zwa mwasi kuna kati na bana basi ya Labani, ndeko ya mama na yo. ");
INSERT INTO lin_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Tika ete Nzambe-Na-Nguya-Nyonso apambola yo, apesa yo bana, akomisa bana na yo ebele mpe okoma lisanga monene ya bato. ");
INSERT INTO lin_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Tika ete apesa na yo mpe na bakitani na yo lipamboli oyo apesaki na Abrayami mpo ete okamata mokili oyo ozali kovanda lokola mopaya, mokili oyo Nzambe apesaki na Abrayami. » ");
INSERT INTO lin_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Izaki atindaki Jakobi na nzela na ye, mpe Jakobi akendeki na Padani-Arami epai ya Labani, mwana mobali ya moto ya Arami, Betweli, mpe ndeko mobali ya Rebeka, mama ya Ezawu mpe Jakobi. ");
INSERT INTO lin_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Ezawu ayokaki ete Izaki apambolaki Jakobi mpe atindaki ye na Padani-Arami mpo na kobala mwasi ; ayokaki mpe ete, tango apambolaki ye, apesaki ye mitindo oyo : « Okobala mwasi te kati na bana basi ya Kanana. » ");
INSERT INTO lin_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Jakobi atosaki tata na ye mpe mama na ye, mpe akendeki na Padani-Arami. ");
INSERT INTO lin_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Bongo Ezawu asosolaki ete Izaki, tata na ye, azalaki kosepela te na bana basi ya Kanana. ");
INSERT INTO lin_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Boye Ezawu akendeki epai ya Isimaeli, mwana mobali ya Abrayami, mpe abalaki, kobakisa na basi oyo azalaki na bango, Maalati, ndeko mwasi ya Nebayoti. ");
INSERT INTO lin_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Jakobi alongwaki na Beri-Sheba mpe akendeki na Arani. ");
INSERT INTO lin_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Tango akomaki na esika moko, apemaki mpo na kolekisa butu. Azwaki libanga moko kati na mabanga oyo ezalaki na esika yango, atiaki yango na se ya moto na ye mpe alalaki. ");
INSERT INTO lin_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Na se ya pongi, alotaki ndoto : Amonaki ematelo moko ebanda na mabele mpe songe na yango etutaki likolo. Ba-anjelu ya Nzambe bazalaki komata mpe kokita na ematelo yango. ");
INSERT INTO lin_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Mpe Yawe atelemaki likolo ya ematelo mpe alobaki na ye : « Nazali Yawe, Nzambe ya koko na yo Abrayami mpe Nzambe ya Izaki. Nakopesa epai na yo mpe na bana na yo mabele oyo, esika olali. ");
INSERT INTO lin_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Bana na yo bakozala ebele lokola putulu ya mabele, bakopanzana na bangambo nyonso : wuta na weste kino na este, wuta na nor kino na sude. Mabota nyonso ya mokili ekomipambola mpo na yo mpe mpo na bakitani na yo. ");
INSERT INTO lin_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Nazali elongo na yo, nakobatela yo bisika nyonso oyo okokende mpe nakozongisa yo na mabele oyo, nakotika yo te kino nakokokisa makambo nyonso oyo nalakaki yo. » ");
INSERT INTO lin_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Tango Jakobi alamukaki na pongi, alobaki : « Ya solo penza, Yawe azali na esika oyo mpe ngai nayebaki yango te ! » ");
INSERT INTO lin_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Jakobi abangaki mpe abakisaki : « Oyo esika ya somo boye ! Ekoki kozala eloko mosusu te, bobele Ndako ya Nzambe. Awa nde ekuke ya lola. » ");
INSERT INTO lin_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Na tongo-tongo, Jakobi azwaki libanga oyo atiaki moto, atelemisaki yango lokola elembo mpe asopaki mafuta na songe na yango. ");
INSERT INTO lin_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Apesaki esika yango kombo « Beteli. » Na kala, bazalaka kobenga esika yango « Luze. » ");
INSERT INTO lin_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Bongo Jakobi akataki ndayi na koloba : « Soki Nzambe akozala elongo na ngai mpe akobatela ngai na mobembo oyo nazali kosala, mpe soki akopesa ngai bilei mpe bilamba ya kolata ; ");
INSERT INTO lin_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","soki nazongi na kimia na ndako ya tata na ngai, wana Yawe akozala Nzambe na ngai, ");
INSERT INTO lin_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","libanga oyo natelemisi lokola elembo ekokoma Ndako ya Nzambe mpe nakopesa Ye eteni ya zomi ya biloko nyonso oyo akopesa ngai. » ");
INSERT INTO lin_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Jakobi akobaki mobembo na ye mpe akomaki na mokili ya bato ya este. ");
INSERT INTO lin_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Kuna, amonaki libulu ya mayi kati na elanga mpe bitonga misato ya bameme elali pembeni ya libulu, pamba te bameme ezalaki komela mayi na libulu yango. Libanga moko ya monene ezipaki monoko ya libulu. ");
INSERT INTO lin_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Tango bibwele nyonso ezalaki kosangana wana, babateli bibwele bazalaki kolongola libanga na monoko ya libulu ya mayi mpe komelisa bameme. Mpe na sima, bazalaki kozongisa libanga na esika na yango, na monoko ya libulu. ");
INSERT INTO lin_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jakobi atunaki babateli bibwele : — Bandeko na ngai ya mibali, bowuti wapi ? Bazongisaki : — Towuti na Arani. ");
INSERT INTO lin_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Atunaki bango lisusu : — Boyebi Labani, koko ya Naori ? Bazongisaki : — Iyo, toyebi ye. ");
INSERT INTO lin_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Jakobi abakisaki lisusu : — Boni, azali malamu ? Bazongisaki : — Iyo, azali malamu. Tala kutu Rasheli, mwana na ye ya mwasi, azali koya elongo na bameme. ");
INSERT INTO lin_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Kasi Jakobi alobaki : — Tala, moyi ezali nanu makasi ; tango ekoki nanu te mpo na kozongisa bibwele. Bomelisa bameme mpe bozonga lisusu koleisa yango matiti. ");
INSERT INTO lin_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Bazongisaki : — Tokoki kosala yango kaka soki bibwele nyonso esangani ; bongo tokolongola libanga na monoko ya libulu mpe tokomelisa bameme mayi. ");
INSERT INTO lin_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Wana azalaki nanu kosolola na bango, Rasheli ayaki elongo na bameme ya tata na ye, pamba te azalaki mwasi mobateli bibwele. ");
INSERT INTO lin_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Tango Jakobi amonaki Rasheli, mwana mwasi ya noko na ye Labani, elongo na bibwele ya Labani, apusanaki, alongolaki libanga na monoko ya libulu ya mayi mpe amelisaki yango mayi. ");
INSERT INTO lin_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Jakobi apesaki Rasheli beze mpe alelaki makasi. ");
INSERT INTO lin_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Jakobi ayebisaki Rasheli : « Nazali mwana ya Rebeka mpe moto ya libota ya tata na yo. » Bongo Rasheli akimaki mbangu mpo na koyebisa tata na ye. ");
INSERT INTO lin_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Tango kaka Labani ayokaki sango na tina na Jakobi, mwana ya ndeko na ye ya mwasi, akendeki mbangu kokutana na ye. Ayambaki ye, apesaki ye beze mpe amemaki ye na ndako na ye ; mpe kuna, Jakobi ayebisaki ye makambo nyonso oyo elekaki. ");
INSERT INTO lin_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Labani alobaki na ye : « Solo, ozali penza makila na ngai, moto ya libota na ngai penza ! » Jakobi avandaki elongo na ye sanza mobimba. ");
INSERT INTO lin_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Labani alobaki na Jakobi : — Boni, osalela ngai mosala ya ofele mpo ete ozali moto ya libota na ngai ? Yebisa ngai : olingi ete lifuti na yo ezala nini ? ");
INSERT INTO lin_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Nzokande, Labani azalaki na bana basi mibale ya mikolo : Lea mpe leki na ye Rasheli. ");
INSERT INTO lin_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea azalaki na miso elala kasi Rasheli azalaki na nzoto kitoko mpe elongi kitoko. ");
INSERT INTO lin_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Jakobi alingaki Rasheli mpe alobaki : — Nakosalela yo mibu sambo mpe okopesa ngai Rasheli, mwana na yo ya mwasi oyo ya leki, mpo ete azala mwasi na ngai. ");
INSERT INTO lin_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Labani alobaki : — Eleki malamu ete napesa ye epai na yo na esika ete napesa ye epai ya mobali mosusu. Vanda awa elongo na ngai. ");
INSERT INTO lin_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Jakobi asalaki mibu sambo mpo na kozwa Rasheli na libala, mpe mibu yango emonanaki kaka lokola mwa mikolo epai na ye, pamba te alingaki Rasheli. ");
INSERT INTO lin_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Sima, Jakobi alobaki na Labani : — Mikolo na ngai ekoki ; pesa ngai mwasi na ngai, pamba te nalingi kozala na ye. ");
INSERT INTO lin_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Na boye, Labani abengisaki bato nyonso ya esika wana mpe asalisaki feti. ");
INSERT INTO lin_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Tango pokwa ekomaki, Labani azwaki Lea, mwana na ye ya mwasi, apesaki ye epai ya Jakobi mpe Jakobi asangisaki na ye nzoto. ");
INSERT INTO lin_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Labani apesaki Zilipa, mwasi mosali na ye, epai ya Lea, mwana na ye ya mwasi, lokola mwasi mosali na ye. ");
INSERT INTO lin_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Tango tongo etanaki, Jakobi amonaki ete ezalaki nde Lea. Bongo alobaki na Labani : — Likambo nini oyo osali ngai ? Boni, ezali mpo na Rasheli te nde ngai nasalelaki yo ? Mpo na nini okosi ngai ? ");
INSERT INTO lin_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Labani azongisaki : — Na bokoko na biso awa, topesaka te leki na libala liboso ya kulutu. ");
INSERT INTO lin_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Silisa nanu poso ya babalani elongo na ye. Bongo sima, oyo ya leki mpe akopesamela yo soki osaleli ngai lisusu mibu sambo. ");
INSERT INTO lin_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Jakobi asalaki bongo : asilisaki poso wana elongo na Lea, sima Labani apesaki ye mwana na ye ya mwasi Rasheli mpo ete azala mwasi na ye. ");
INSERT INTO lin_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Labani apesaki Bila, mwasi mosali na ye, epai ya Rasheli, mwana na ye ya mwasi, lokola mwasi mosali na ye. ");
INSERT INTO lin_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Jakobi asangisaki lisusu nzoto na Rasheli. Alingaki ye mingi koleka Lea. Bongo asalelaki lisusu Labani mibu sambo. ");
INSERT INTO lin_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Lokola Yawe amonaki ete Jakobi alingaka Lea te, afungolaki ye mabota ; kasi Rasheli azalaki kobota te. ");
INSERT INTO lin_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Boye Lea azwaki zemi mpe abotaki mwana mobali. Apesaki ye kombo « Ribeni ; » alobaki : « Yawe amoni pasi na ngai ; mpe sik’oyo, mobali na ngai akolinga ngai. » ");
INSERT INTO lin_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Sima, azwaki lisusu zemi mpe abotaki mwana mobali. Alobaki : « Yawe amoni ete nalingami te, mpe apesi ngai lisusu mwana. » Boye apesaki ye kombo « Simeoni. » ");
INSERT INTO lin_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Azwaki lisusu zemi mpe abotaki mwana mobali. Alobaki : « Na mbala oyo, mobali na ngai akokangama na ngai, pamba te naboteli ye bana mibali misato. » Boye bapesaki ye kombo « Levi. » ");
INSERT INTO lin_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Azwaki lisusu zemi mpe abotaki mwana mobali. Agangaki : « Na mbala oyo, nakokumisa Yawe. » Yango wana apesaki ye kombo « Yuda. » Mpe akataki kobota. ");
INSERT INTO lin_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Tango Rasheli amonaki ete azali kobotela Jakobi bana te, akomaki na zuwa mpo na ndeko na ye ya mwasi. Boye alobaki na Jakobi : — Pesa ngai bana, noki te nakokufa. ");
INSERT INTO lin_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Jakobi asilikaki makasi mpo na Rasheli mpe alobaki : — Boni, ngai nakomi nde Nzambe oyo akangi yo mabota ? ");
INSERT INTO lin_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Rasheli alobaki : — Tala Bila, mwasi mowumbu na ngai ; sangisa na ye nzoto mpo ete abotela ngai bana, mpe na nzela na ye, ngai mpe nakoka kotonga libota. ");
INSERT INTO lin_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Rasheli apesaki ye Bila, mwasi mosali na ye, mpo ete akoma mwasi na ye. Jakobi asangisaki na ye nzoto, ");
INSERT INTO lin_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","mpe Bila akomaki na zemi. Abotelaki Jakobi mwana mobali. ");
INSERT INTO lin_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Rasheli alobaki : « Nzambe alongisi ngai, ayoki kolela na ngai mpe apesi ngai mwana mobali. » Boye apesaki ye kombo « Dani. » ");
INSERT INTO lin_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Sima na yango, Bila, mwasi mosali ya Rasheli, azwaki lisusu zemi mpe abotelaki Jakobi mwana mobali ya mibale. ");
INSERT INTO lin_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rasheli alobaki : « Nabundisi ndeko na ngai ya mwasi bitumba ya Nzambe mpe nalongi. » Boye apesaki ye kombo « Nefitali. » ");
INSERT INTO lin_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Tango Lea amonaki ete azali kobota lisusu te, azwaki Zilipa, mwasi mosali na ye, mpe apesaki ye epai ya Jakobi mpo ete akoma mwasi na ye. ");
INSERT INTO lin_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Zilipa, mwasi mosali ya Lea, abotelaki Jakobi mwana mobali. ");
INSERT INTO lin_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Lea alobaki : « Oyo nde esengo ! » Boye apesaki ye kombo « Gadi. » ");
INSERT INTO lin_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Sima na yango, Zilipa, mwasi mosali ya Lea, abotelaki Jakobi mwana mobali ya mibale. ");
INSERT INTO lin_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Lea alobaki : « Oyo esengo ya ndenge nini nakomi na yango ! Pamba te basi bakobenga ngai moto ya esengo. » Boye apesaki ye kombo « Aseri. » ");
INSERT INTO lin_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Na eleko ya kokata ble, Ribeni akendeki na bilanga mpe amonaki bambuma ya mandragore ; amemelaki yango Lea, mama na ye. Bongo Rasheli alobaki na Lea : — Nabondeli yo, pesa ngai ndambo ya bambuma ya mandragore oyo mwana na yo amemaki. ");
INSERT INTO lin_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Kasi Lea azongiselaki ye : — Boni, ndenge ozwi mobali na ngai, ekoki te ? Olingi lisusu kozwa bambuma ya mandragore ya mwana na ngai ? Rasheli alobaki na ye : — Malamu ! Soki opesi ngai bambuma ya mandragore ya mwana na yo, Jakobi akolala epai na yo na butu ya lelo. ");
INSERT INTO lin_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Na pokwa, wana Jakobi awutaki bilanga, Lea akendeki kokutana na ye mpe alobaki na ye : « Okolala epai na ngai, pamba te napesi bambuma ya mandragore ya mwana na ngai mpo na yo. » Boye Jakobi asangisaki na ye nzoto na butu wana. ");
INSERT INTO lin_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Nzambe ayokelaki Lea mawa, akomaki na zemi mpe abotelaki Jakobi mwana mobali ya mitano. ");
INSERT INTO lin_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Lea alobaki : « Nzambe apesi ngai lifuti na ngai lokola napesaki mosali na ngai ya mwasi epai ya mobali na ngai. » Boye apesaki ye kombo « Isakari. » ");
INSERT INTO lin_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Lea azwaki lisusu zemi mpe abotelaki Jakobi mwana mobali ya motoba. ");
INSERT INTO lin_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Lea alobaki : « Nzambe apesi ngai likabo ya motuya. Sik’oyo, mobali na ngai akopesa ngai lokumu mpo ete naboteli ye bana mibali motoba. » Boye apesaki ye kombo « Zabuloni. » ");
INSERT INTO lin_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Sima na mikolo, abotaki lisusu mwana mwasi mpe apesaki ye kombo « Dina. » ");
INSERT INTO lin_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Nzambe akaniselaki Rasheli, ayokaki kolela na ye mpe afungolaki ye mabota. ");
INSERT INTO lin_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Akomaki na zemi, abotaki mwana mobali mpe alobaki : « Nzambe alongoli soni na ngai. » ");
INSERT INTO lin_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Apesaki ye kombo « Jozefi, » mpe alobaki : « Tika ete Yawe abakisela ngai mwana mosusu ya mobali ! » ");
INSERT INTO lin_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Sima na Rasheli kobota Jozefi, Jakobi alobaki na Labani : — Pesa ngai nzela mpo ete nazonga na mboka na ngai. ");
INSERT INTO lin_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Pesa ngai mpe basi mpe bana na ngai, ba-oyo mpo na bango nasaleli yo ; bongo nakokende na ngai. Pamba te oyebi malamu mosala makasi oyo nasaleli yo. ");
INSERT INTO lin_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Kasi Labani alobaki na ye : — Soki nazwi ngolu na miso na yo, nabondeli yo, kokende te ; pamba te nasosoli na bosoloka ete Yawe apamboli ngai na nzela na yo. ");
INSERT INTO lin_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Abakisaki : — Katela ngai lifuti na yo mpe nakofuta yo yango. ");
INSERT INTO lin_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Jakobi alobaki na ye : — Oyebi yo moko ndenge nini ngai nasaleli yo mpe ndenge nini, na nzela na ngai, bibwele na yo ekomi ebele. ");
INSERT INTO lin_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Moke oyo ozalaki na yango, liboso ete ngai naya, ekomi ebele penza. Yawe apamboli yo na nzela na ngai. Kasi sik’oyo, nakosala tango nini mpo na libota na ngai moko ? ");
INSERT INTO lin_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Labani atunaki ye : — Nasengeli kopesa yo nini ? Jakobi azongisaki : — Okopesa ngai eloko te. Kasi soki olingi kosala likambo oyo mpo na ngai, nakokoba koleisa mpe kobatela bibwele na yo. ");
INSERT INTO lin_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Lelo, nakoleka na kati-kati ya bibwele na yo, nakolongola kati na bana meme, bameme nyonso ya madodo-madodo mpe oyo ezali ya banzela-nzela ya mwindo ; mpe lisusu kati na bantaba nyonso ya madodo-madodo mpe ya banzela-nzela ya pembe. Wana nde ezala lifuti na ngai. ");
INSERT INTO lin_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Boye bosembo na ngai ekomonana sima na mikolo tango okoya kotala lifuti na ngai. Soki omoni epai na ngai ntaba ezanga madodo to ezanga banzela ya pembe to mwana meme ezanga madodo to ezanga banzela ya mwindo, wana ekozala lokola nayibi yango. ");
INSERT INTO lin_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Labani alobaki : — Iyo ! Tika ete ezala ndenge olobi. ");
INSERT INTO lin_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Kaka na mokolo wana, Labani alongolaki kati na bibwele, bantaba ya mibali ya madodo-madodo mpe ya banzela-nzela ya pembe, bantaba nyonso ya basi ya madodo-madodo mpe ya banzela-nzela ya pembe, mpe bibwele nyonso oyo ezalaki mwa pembe mpe mwa mwindo kati na bana meme. Apesaki yango na maboko ya bana na ye ya mibali. ");
INSERT INTO lin_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Sima, Labani atambolaki mikolo misato mpo na kokabwana na Jakobi, wana Jakobi akobaki kobatela ndambo ya bibwele ya Labani oyo etikalaki. ");
INSERT INTO lin_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Jakobi azwaki bitape ya mobesu ya nzete ya pepiliye, ya amande mpe ya platane. ");
INSERT INTO lin_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Bongo atiaki kati na basani mpe kati na bimelelo, liboso ya bibwele, bitape oyo apalolaki, na esika oyo bibwele ezalaki koya komela mayi. Wana bibwele ya basi ezalaki koyoka posa ya mayi, ezalaki mpe koyoka posa ya kosangisa nzoto na bibwele ya mibali. ");
INSERT INTO lin_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Boye, bibwele ezalaki koya kosangisa nzoto liboso ya bitape wana ; mpe tango ezalaki kobota, bana na yango ezalaki na banzela-nzela ya pembe, banzela-nzela ya mwindo mpe madodo-madodo. ");
INSERT INTO lin_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Jakobi atiaki pembeni bana meme mpe atindaki yango na esika oyo bana meme ya nzela-nzela mpe ya mwa mwindo ezalaki ; pamba te yango ezalaki kobotama mingi kati na bibwele ya Labani. Ezali boye nde akomaki na bibwele ya ye moko oyo asangisaki te na bibwele ya Labani. ");
INSERT INTO lin_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Tango nyonso bibwele ya basi, oyo ezalaki na nzoto minene, ezalaki na posa ya kosangisa nzoto, Jakobi azalaki kotia liboso ya bibwele yango bitape ya nzete kati na basani oyo yango ezalaki komelela mayi mpo ete esangisa nzoto pembeni ya bitape wana. ");
INSERT INTO lin_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Kasi, na esika yango, azalaki kotia te bibwele oyo ekonda. Boye bibwele oyo ekonda ezalaki ya Labani, mpe oyo ya minene ezalaki ya Jakobi. ");
INSERT INTO lin_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Na nzela wana nde moto oyo akomaki na bozwi mingi koleka. Azwaki bibwele ebele, basali ya basi mpe ya mibali, bashamo mpe ba-ane. ");
INSERT INTO lin_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Jakobi ayokaki bana mibali ya Labani koloba : « Jakobi azwi biloko nyonso ya tata na biso mpe ezali na nzela ya biloko yango nde akomi na bozwi oyo nyonso. » ");
INSERT INTO lin_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Jakobi amonaki lisusu ete ezaleli ya Labani epai na ye etikalaki lisusu te ndenge ezalaki liboso. ");
INSERT INTO lin_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Yawe ayebisaki Jakobi : « Zonga na mboka ya batata na yo, epai ya bandeko na yo, mpe nakozala na yo elongo. » ");
INSERT INTO lin_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Boye Jakobi abengisaki Rasheli mpe Lea na bilanga epai wapi azalaki elongo na bibwele. ");
INSERT INTO lin_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Alobaki na bango : — Namoni ete ezaleli ya tata na bino epai na ngai etikali lisusu te ndenge ezalaki liboso ; kasi Nzambe ya tata na ngai azalaki elongo na ngai. ");
INSERT INTO lin_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Boyebi bino moko ete nasalelaki tata na bino na makasi na ngai nyonso. ");
INSERT INTO lin_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Kasi ye asakanaki na ngai na kobongola lifuti na ngai mbala zomi. Atako bongo, Nzambe apesaki ye nzela te ya kosala ngai mabe. ");
INSERT INTO lin_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Tango azalaki koloba : « Bibwele ya nzela-nzela ekozala lifuti na yo, » bibwele nyonso ezalaki kobota bana ya nzela-nzela. Mpe tango azalaki koloba : « Bibwele ya madodo-madodo nde lifuti na yo, » bibwele nyonso ezalaki kobota bana ya madodo-madodo. ");
INSERT INTO lin_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Ezalaki bongo nde Nzambe azalaki kobotola bibwele ya tata na bino mpe kopesa ngai yango. ");
INSERT INTO lin_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Bongo, na tango oyo bibwele esengelaki kosangisa nzoto, namonaki na ndoto ete bantaba ya mibali, oyo ezalaki kosangisa nzoto na bantaba ya basi, ezalaki ya madodo-madodo, ya banzela-nzela ya mwindo mpe ya banzela-nzela ya pembe. ");
INSERT INTO lin_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Anjelu na Nzambe alobaki na ngai kati na ndoto : « Jakobi ! » Mpe ngai nazongisaki : « Ngai oyo, nazali awa. » ");
INSERT INTO lin_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Alobaki na ngai : « Tombola miso mpe tala : bantaba nyonso ya mibali, oyo ezali kosangisa nzoto na bantaba ya basi, ezali na madodo-madodo, na banzela-nzela ya mwindo mpe na banzela-nzela ya pembe ; pamba te namoni makambo nyonso oyo Labani asali yo. ");
INSERT INTO lin_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Nazali Nzambe ya Beteli epai wapi osopaki mafuta na likolo ya libanga oyo otelemisaki lokola elembo mpe olapaki ndayi liboso na Ngai. Sik’oyo, telema, wuta na mokili oyo, mpe zonga na mokili na yo epai wapi obotama. » ");
INSERT INTO lin_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Rasheli mpe Lea bazongisaki : — Boni, tozali lisusu na eloko to na libula kati na ndako ya tata na biso ? ");
INSERT INTO lin_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Azalaki komona biso lokola bapaya, pamba te atekaki biso mpe aliaki mbongo na mito na biso. ");
INSERT INTO lin_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Yango wana, bozwi nyonso oyo Nzambe abotolaki tata na biso ekomi ya biso na bana na biso. Sik’oyo, sala makambo nyonso oyo Nzambe ayebisaki yo. ");
INSERT INTO lin_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Boye Jakobi amatisaki bana na ye mpe basi na ye likolo ya bashamo. ");
INSERT INTO lin_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Amemaki bibwele na ye nyonso mpe biloko nyonso oyo azwaki, bibwele oyo azwaki tango avandaki na Padani-Arami, mpo na kozonga epai ya Izaki, tata na ye, na mokili ya Kanana. ");
INSERT INTO lin_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Nzokande tango Labani akendeki kolongola bapwale ya bameme na ye, Rasheli ayibaki banzambe ya bikeko ya tata na ye. ");
INSERT INTO lin_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Boye Jakobi akosaki Labani, moto ya Arami, pamba te atikalaki koyebisa ye te ete akokende. ");
INSERT INTO lin_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Akimaki elongo na nyonso oyo ezalaki ya ye, akatisaki ebale mpe akendeki na mokili ya bangomba ya Galadi. ");
INSERT INTO lin_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Sima na mikolo misato, bayebisaki Labani ete Jakobi asili kokima. ");
INSERT INTO lin_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Boye Labani azwaki elongo na ye bandeko na ye ya mibali, alandaki Jakobi mikolo sambo mpe akangaki ye na mokili ya bangomba ya Galadi. ");
INSERT INTO lin_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Na butu, Nzambe ayaki epai ya Labani, moto ya Arami, kati na ndoto ; alobaki na ye : « Keba ! Komeka koloba ata likambo moko te ya malamu to ya mabe epai ya Jakobi. » ");
INSERT INTO lin_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Labani akangaki Jakobi, sima na Jakobi kotonga ndako na ye ya kapo kati na mokili ya bangomba ya Galadi. Boye Labani elongo na bandeko na ye ya mibali bavandaki mpe wana. ");
INSERT INTO lin_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Labani alobaki na Jakobi : — Makambo nini osali ngai ? Okosi ngai mpe omemi bana na ngai ya basi lokola bakangami ya bitumba ! ");
INSERT INTO lin_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Mpo na nini okimi na nkuku mpe okosi ngai ? Mpo na nini oyebisaki ngai te ? Nalingaki kutu kotika yo kokende na esengo elongo na banzembo, na makelele ya bambunda mpe ya lindanda. ");
INSERT INTO lin_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Otikeli ngai ata tango te ya kopesa beze na bakoko na ngai mpe na bana na ngai ya basi ! Osali penza lokola moto ya liboma ! ");
INSERT INTO lin_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Tala, nazali na makoki ya kosala yo mabe, kasi na butu oyo eleki, Nzambe ya tata na yo alobaki na ngai : « Keba ! Komeka koloba ata likambo moko te ya malamu to ya mabe epai ya Jakobi. » ");
INSERT INTO lin_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Sik’oyo, lokola okeyi mpo ete ozalaki na posa ya ndako ya tata na yo, mpo na nini oyibi banzambe na ngai ? ");
INSERT INTO lin_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Jakobi azongiselaki Labani : — Nabangaki, pamba te nakanisaki ete okobotola ngai bana na yo ya basi na makasi. ");
INSERT INTO lin_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Kasi tika ete moto oyo okokuta awa na banzambe na yo akufa. Na miso ya bandeko na biso ya mibali, luka epai na ngai nyonso oyo ezali ya yo mpe zwa yango. Nzokande, Jakobi ayebaki te ete ezalaki Rasheli nde moto ayibaki banzambe yango. ");
INSERT INTO lin_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Labani akotaki na ndako ya kapo ya Jakobi, na ndako ya kapo ya Lea, mpe na ndako ya kapo ya basi bawumbu mibale ; kasi amonaki eloko te. Sima na ye kobima na ndako ya kapo ya Lea, akotaki na oyo ya Rasheli. ");
INSERT INTO lin_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Nzokande Rasheli azwaki banzambe ya Labani, abombaki yango likolo ya shamo mpe avandaki na likolo na yango. Labani alukaki kati na ndako mobimba ya kapo, kasi amonaki eloko moko te. ");
INSERT INTO lin_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rasheli alobaki na tata na ye : — Tika ete nkolo na ngai asilika te soki nakoki kotelema te na miso na yo, pamba te nazali na mikolo ya sanza oyo ekomelaka basi nyonso. Labani alukaki, kasi amonaki banzambe yango te. ");
INSERT INTO lin_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Bongo Jakobi asilikaki mpe aswanisaki Labani. Alobaki na ye : — Mbeba nini nasalaki ? Lisumu nini nasalaki mpo ete olanda ngai na kanda boye ? ");
INSERT INTO lin_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Tango oluki kati na biloko na ngai nyonso, eloko nini ya ndako na yo omoni ? Tia yango awa liboso ya bandeko na yo ya mibali mpe ya ngai mpo bakatela biso mibale likambo. ");
INSERT INTO lin_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Nasalaki epai na yo mibu tuku mibale ; bameme na yo mpe bantaba na yo elongwaki zemi te, mpe natikalaki te kolia bameme ya mibali kati na bibwele na yo. ");
INSERT INTO lin_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Namemelaki yo nyama moko te oyo banyama ya zamba ebomaki. Ngai moko nazalaki kofuta yango. Ozalaki kofutisa ngai oyo bazalaki koyiba ngai na moyi to na butu. ");
INSERT INTO lin_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Moyi ezalaki kobeta ngai na mokolo, malili ezalaki kokanga ngai na butu, mpe pongi ezalaki kokima ngai na miso. ");
INSERT INTO lin_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Navandi na ndako na yo mibu tuku mibale : nasalelaki yo mibu zomi na minei mpo na bana na yo mibale ya basi, mpe mibu motoba mpo na bibwele na yo ; mbala zomi obongolaki lifuti na ngai. ");
INSERT INTO lin_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Soki Nzambe ya tata na ngai, Nzambe ya Abrayami mpe oyo Izaki abangaka, azalaki elongo na ngai te, ya solo, olingaki kozongisa ngai lelo maboko pamba. Kasi Nzambe amonaki minyoko na ngai mpe pasi ya mosala ya maboko na ngai, yango wana apamelaki yo na butu oyo eleki. ");
INSERT INTO lin_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Labani azongiselaki Jakobi : — Basi oyo bazali bana na ngai ya basi, bana oyo bazali bana na ngai, bibwele oyo ezali ya ngai mpe nyonso oyo ozali komona ezali ya ngai. Bongo lelo, eloko nini nakoki kosala mpo na bana na ngai ya basi mpe mpo na bana oyo bango baboti ? ");
INSERT INTO lin_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Sik’oyo Jakobi, tosala boyokani kati na yo mpe ngai, mpe tika ete yango ezala litatoli kati na biso. ");
INSERT INTO lin_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Boye Jakobi azwaki libanga mpe atelemisaki yango lokola elembo. ");
INSERT INTO lin_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Jakobi alobaki na bandeko na ye ya mibali : « Bolokota mabanga ! » Balokotaki mabanga, batiaki yango liboke, mpe bango nyonso baliaki wana na likolo ya liboke ya mabanga. ");
INSERT INTO lin_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Labani abengaki esika yango Yegari-Saduta mpe Jakobi abengaki yango Galedi. ");
INSERT INTO lin_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Labani alobaki : — Lelo, liboke oyo ya mabanga ezali litatoli kati na yo mpe ngai. Yango wana babengaki yango Galedi. ");
INSERT INTO lin_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Babengaki yango lisusu Mitsipa ; pamba te Labani alobaki lisusu : « Tika ete Yawe akengelaka kati na yo mpe ngai tango tokomonana lisusu te. ");
INSERT INTO lin_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Soki onyokoli bana na ngai ya basi mpe soki ozwi basi mosusu likolo na bana na ngai ya basi, atako moto moko te akozala kati na biso, kasi yeba ete Nzambe nde azali motatoli kati na yo mpe ngai. » ");
INSERT INTO lin_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Labani alobaki lisusu na Jakobi : — Tala liboke oyo ya mabanga mpe libanga ya elembo oyo natelemisi kati na ngai mpe yo. ");
INSERT INTO lin_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Liboke oyo ya mabanga ezali motatoli, mpe libanga oyo ya elembo ezali motatoli. Nasengeli te kokatisa liboke oyo ya mabanga mpe libanga oyo ya elembo mpo ete naya kosala yo mabe na ngambo na yo ; mpe yo osengeli te kokatisa liboke ya mabanga mpe libanga ya elembo mpo na koya kosala ngai mabe na ngambo na ngai. ");
INSERT INTO lin_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Tika ete Nzambe ya Abrayami mpe Nzambe ya Naori, Nzambe ya tata na bango, azala Mosambisi kati na biso ! Bongo Jakobi alapaki ndayi na Kombo ya Nzambe oyo tata na ye, Izaki, azalaki kobanga. ");
INSERT INTO lin_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Jakobi abonzaki mbeka likolo ya ngomba mpe abengisaki bandeko na ye ya mibali mpo na kolia bilei. Tango basilisaki kolia, balekisaki butu na esika wana, likolo ya ngomba. ");
INSERT INTO lin_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Na tongo-tongo ya mokolo oyo elandaki, Labani apesaki bakoko na ye mpe bana na ye ya basi beze ; apambolaki bango mpe azongaki na ndako na ye. ");
INSERT INTO lin_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Wana Jakobi azalaki kokoba mobembo na ye, ba-anjelu ya Nzambe bayaki kokutana na ye. ");
INSERT INTO lin_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Tango Jakobi amonaki bango, alobaki : « Oyo ezali molako ya Nzambe ! » Mpe abengaki esika yango : Maanayimi. ");
INSERT INTO lin_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Jakobi atindaki bantoma liboso na ye epai ya Ezawu, ndeko na ye, na mokili ya Seiri, kati na zamba ya Edomi. ");
INSERT INTO lin_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Apesaki bango malako oyo : « Tala makambo oyo bokoloba epai ya nkolo na ngai Ezawu : ‹ Mosali na yo Jakobi alobi : ‘ Navandaki epai ya Labani mpe natikalaki kuna kino sik’oyo. ");
INSERT INTO lin_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Nazali na bangombe, ba-ane, bameme, bantaba, basali ya mibali mpe ya basi ; natindi sango oyo epai ya nkolo na ngai mpo ete nazwa ngolu na miso na ye. ’ › » ");
INSERT INTO lin_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Tango bantoma bazongaki epai ya Jakobi, balobaki : « Tokendeki epai ya Ezawu, ndeko na yo, mpe sik’oyo azali koya elongo na bato nkama minei mpo na kokutana na yo. » ");
INSERT INTO lin_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Na kobanga makasi mpe na komitungisa, Jakobi akabolaki bato oyo bazalaki elongo na ye na masanga mibale ; ndenge moko mpe mpo na bameme, bantaba mpe bashamo. ");
INSERT INTO lin_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Azalaki komilobela : « Soki Ezawu abundisi lisanga moko, lisanga oyo etikali ekoki kokima. » ");
INSERT INTO lin_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Sima, Jakobi abondelaki : « Oh Nzambe ya Abrayami, tata na ngai ! Nzambe ya Izaki, tata na ngai ! Oh Yawe, Yo oyo olobaki na ngai : ‹ Zonga na mokili na yo, na libota na yo, mpe Ngai nakosalela yo bolamu. › ");
INSERT INTO lin_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Nazali nani mpo ete otalisa ngai mosali na Yo bolamu mpe bosembo nyonso oyo ! Nazalaki kaka na lingenda tango nakatisaki Yordani, kasi sik’oyo nazali na masanga mibale. ");
INSERT INTO lin_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Nabondeli Yo, kangola ngai na maboko ya ndeko na ngai, Ezawu, pamba te nazali kobanga ete aya kobundisa ngai elongo na bamama mpe bana na bango. ");
INSERT INTO lin_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Nzokande, Yo olobaki na ngai : ‹ Ya solo nakosalela yo bolamu mpe nakokomisa bakitani na yo ebele lokola zelo ya ebale monene, oyo moto moko te akoki kotanga. › » ");
INSERT INTO lin_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Jakobi alekisaki butu na esika wana. Kati na biloko oyo azalaki na yango, aponaki kado mpo na Ezawu, ndeko na ye : ");
INSERT INTO lin_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","bantaba ya basi nkama mibale mpe bantaba ya mibali tuku mibale, bameme ya basi nkama mibale mpe bameme ya mibali tuku mibale, ");
INSERT INTO lin_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","shamo ya basi tuku misato elongo na bana na yango, bangombe ya basi tuku minei mpe bangombe ya mibali zomi, ba-ane ya basi tuku mibale mpe ya mibali zomi. ");
INSERT INTO lin_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Akabolaki yango na bitonga mpe apesaki yango epai ya basali na ye. Alobaki na bango : « Boleka liboso na ngai mpe botia etonga moko mosika na mosusu. » ");
INSERT INTO lin_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Jakobi apesaki mitindo oyo epai ya mosali na ye ya liboso : « Tango Ezawu, ndeko na ngai, akokutana na yo mpe akotuna yo : ‹ Yo ozali mosali ya nani, ozali kokende wapi mpe nani nkolo ya banyama nyonso oyo ezali liboso na yo ? › ");
INSERT INTO lin_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Okozongisa : ‹ Ezali ya Jakobi, mosali na yo, ezali kado oyo atindeli nkolo na ngai Ezawu. Mpe tala ye moko azali koya sima na biso. › » ");
INSERT INTO lin_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Apesaki lisusu mitindo wana epai ya mosali ya mibale, ya misato mpe epai ya basali nyonso oyo bazalaki kolanda bibwele : « Bokoloba kaka maloba moko tango bokokutana na Ezawu. ");
INSERT INTO lin_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Bokoyebisa ye lisusu : ‹ Tala ye moko Jakobi, mosali na yo, azali koya na sima na biso ! › » Pamba te azalaki komilobela : « Nakokitisa kanda na ye na kado oyo natindi liboso na ngai ; sima tango nakokutana na ye, mbala mosusu akoyamba ngai malamu. » ");
INSERT INTO lin_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Boye kado ya Jakobi ekendeki liboso, kasi ye moko alekisaki butu kati na Molako. ");
INSERT INTO lin_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Na butu wana, Jakobi alamukaki, azwaki basi na ye mibale, basali na ye mibale ya basi, bana na ye zomi na moko mpe akatisaki mayi ya Yaboki. ");
INSERT INTO lin_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Sima na kokatisa bango mayi, akatisaki mpe biloko na ye nyonso. ");
INSERT INTO lin_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Jakobi atikalaki kaka ye moko. Bongo moto moko abundaki na ye kino tango tongo elingaki kotana. ");
INSERT INTO lin_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Wana moto yango amonaki ete akoki kolonga Jakobi te, abetaki Jakobi na loketo mpe mokuwa ya loketo na ye ebukanaki tango bazalaki kobunda. ");
INSERT INTO lin_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Sima, moto yango alobaki : — Tika ngai nakende, pamba te tongo elingi kotana. Kasi Jakobi azongisaki : — Nakotika yo te kokende soki opamboli ngai te. ");
INSERT INTO lin_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Moto yango atunaki Jakobi : — Kombo na yo nani ? Jakobi azongisaki : — Kombo na ngai ezali Jakobi. ");
INSERT INTO lin_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Moto yango alobaki lisusu : — Kobanda lelo, kombo na yo ekozala lisusu Jakobi te, kasi Isalaele, pamba te obundi na Nzambe mpe na bato, bongo olongi. ");
INSERT INTO lin_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Jakobi alobaki : — Nabondeli yo, yebisa ngai kombo na yo. Azongiselaki ye : — Mpo na nini ozali kotuna kombo na ngai ? Boye apambolaki ye na esika wana. ");
INSERT INTO lin_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Jakobi abengaki esika yango « Penieli, » pamba te alobaki : « Namoni Nzambe na miso na ngai, mpe bomoi na ngai ebiki. » ");
INSERT INTO lin_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Tango moyi ebimaki, Jakobi alekaki Penueli. Azalaki kotambola tengu-tengu mpo na loketo na ye. ");
INSERT INTO lin_vpl VALUES ("GN32_33","002_32_33","GEN","32","33","33","Yango wana kino lelo, bana ya Isalaele baliaka mosuni ya mopende te, pamba te Nzambe abetaki Jakobi na mosuni oyo ekangami na mokuwa ya loketo. ");
INSERT INTO lin_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Tango Jakobi atombolaki miso na ye, amonaki na mosika Ezawu koya elongo na bato nkama minei. Boye Jakobi akabolaki bana na ye : ndambo epai ya Lea, ndambo epai ya Rasheli mpe ndambo mosusu epai ya basali mibale ya basi. ");
INSERT INTO lin_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Atiaki basali ya basi elongo na bana na bango na liboso ; Lea mpe bana na ye na sima ; mpe Rasheli na Jozefi na suka. ");
INSERT INTO lin_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Ye moko alekaki liboso na bango mpe afukamaki na mabele mbala sambo wana azalaki kopusana liboso ya ndeko na ye ya mobali. ");
INSERT INTO lin_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ezawu akimaki mbangu mpo na kokutana na ye ; ayambaki ye, amibwakaki na nzoto na ye mpo na koyamba ye mpe apesaki ye beze ; bongo bakomaki kolela. ");
INSERT INTO lin_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Tango atombolaki miso na ye, amonaki na mosika basi mpe bana. Atunaki : — Banani wana bazali elongo na yo ? Jakobi azongisaki : — Ezali bana oyo Nzambe apesi, na bolingo na Ye, epai ya mosali na yo. ");
INSERT INTO lin_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Boye, basali ya basi elongo na bana na bango bapusanaki mpe bafukamaki. ");
INSERT INTO lin_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Na sima, Lea elongo na bana na ye bayaki kofukama. Bongo na suka, Jozefi elongo na Rasheli bayaki mpe kofukama. ");
INSERT INTO lin_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Ezawu atunaki : — Ngulupa nyonso oyo nakutani na yango, tina na yango nini ? Jakobi azongisaki : — Ezali mpo ete nazwa ngolu na miso na yo, nkolo na ngai. ");
INSERT INTO lin_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Kasi Ezawu azongisaki : — Ndeko na ngai, biloko nyonso oyo, nazali na yango ebele ; bomba biloko na yo mpo na yo moko. ");
INSERT INTO lin_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Jakobi alobaki : — Nabondeli yo : soki nazwi ngolu na miso na yo, ndima kozwa biloko oyo lokola kado kowuta na maboko na ngai ; pamba te ndenge namoni yo, ezali lokola namoni Nzambe, mpo ete oyambi ngai na boboto. ");
INSERT INTO lin_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Nabondeli yo penza, ndima makabo oyo namemeli yo ; pamba te Nzambe nde apesaki ngai yango na ngolu na Ye mpe nazali na nyonso. Lokola Jakobi azalaki kaka kotia molende, Ezawu andimaki kozwa yango. ");
INSERT INTO lin_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Ezawu alobaki : — Telema tokende, nakotambola na yo nzela moko. ");
INSERT INTO lin_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Kasi Jakobi azongiselaki ye : — Oh nkolo na ngai ! Oyebi malamu ete bana bazwi nanu makasi te, mpe nazali lisusu na bameme, bangombe mpe bantaba ya basi oyo ezali nanu komelisa mabele. Soki tomeki kotambolisa yango mbangu makasi kaka na mokolo moko, bibwele nyonso ekokufa. ");
INSERT INTO lin_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Boye, tika ete nkolo na ngai akende liboso, wana ngai nakotambola malembe-malembe na sima, kolanda etamboli ya bibwele oyo ezali liboso na ngai, mpe kolanda etamboli ya bana, kino nakokoma epai ya nkolo na ngai, na Seiri. ");
INSERT INTO lin_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Ezawu alobaki : — Nabondeli yo, ndima ete natikela yo ndambo ya bato na ngai. Kasi Jakobi atunaki : — Mpo na nini kosala bongo ? Tika ete nazwa kaka ngolu na miso ya nkolo na ngai ! ");
INSERT INTO lin_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Boye, kaka na mokolo wana, Ezawu azwaki nzela mpe azongaki na Seiri. ");
INSERT INTO lin_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Nzokande, Jakobi akendeki na Sukoti. Atongaki kuna ndako mpo na ye moko mpe mpo na bibwele na ye ; yango wana babengi esika yango Sukoti. ");
INSERT INTO lin_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Longwa na mokili ya Padani-Arami, Jakobi akomaki na kimia na engumba Sishemi oyo ezali na mokili ya Kanana ; mpe atelemisaki ndako na ye ya kapo liboso ya engumba. ");
INSERT INTO lin_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Na motuya ya bibende ya palata nkama moko, asombaki na maboko ya bana mibali ya Amori, tata ya Sishemi, eteni ya mabele epai wapi atongaki ndako na ye ya kapo. ");
INSERT INTO lin_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Atongaki kuna etumbelo moko oyo abengaki : « El, Nzambe ya Isalaele. » ");
INSERT INTO lin_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Nzokande, Dina, mwana mwasi oyo Lea abotelaki Jakobi, abimaki mpo na kokende kotala basi ya mokili wana. ");
INSERT INTO lin_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Tango Sishemi, mokambi ya mokili wana mpe mwana mobali ya Amori, moto ya Evi, amonaki ye, akangaki ye mpe asangisaki na ye nzoto na makasi. ");
INSERT INTO lin_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Motema na ye emipesaki mobimba epai ya Dina, mwana mwasi ya Jakobi, alingaki ye mpe akomaki koloba na ye maloba ya bolingo. ");
INSERT INTO lin_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Sishemi alobaki na Amori, tata na ye : « Balela ngai elenge mwasi oyo. » ");
INSERT INTO lin_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Tango Jakobi ayokaki ete lokumu ya Dina, mwana na ye ya mwasi, ebebisami, abatelaki kimia kino bana na ye ya mibali bazongaki na ndako, pamba te bazalaki na esobe elongo na bibwele. ");
INSERT INTO lin_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Boye, Amori, tata na Sishemi, akendeki kosolola na Jakobi. ");
INSERT INTO lin_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Tango bana mibali ya Jakobi bazongaki wuta na esobe, bayokaki sango ya makambo oyo esalemaki. Bongo, bayokaki pasi mingi na mitema mpe basilikaki makasi, pamba te Sishemi asalaki likambo ya soni na Isalaele, wana asangisaki nzoto na makasi na mwana mwasi ya Jakobi. Likambo ya bongo esengelaki kosalema te. ");
INSERT INTO lin_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Kasi Amori alobaki na bango : « Motema ya Sishemi, mwana na ngai ya mobali ezali kopela na bolingo mpo na mwana na bino ya mwasi. Nabondeli bino, bopesa ye na libala mpo na Sishemi. ");
INSERT INTO lin_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Na bongo, bokoki kosala elongo na biso boyokani na nzela ya libala : bokobalisa biso bana na bino ya basi mpe biso tokobalisa bino bana na biso ya basi, ");
INSERT INTO lin_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","bokovanda elongo na biso. Mboka ezali liboso na bino, bovanda, bosala mombongo mpe bokoma bankolo mabele. » ");
INSERT INTO lin_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Boye, Sishemi alobaki na tata mpe na bandeko mibali ya Dina : — Tika ete nazwa ngolu na miso na bino mpe nakopesa bino nyonso oyo bokosenga ngai. ");
INSERT INTO lin_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Bokatela ngai motuya makasi ya mbongo ya libala mpe biloko ebele ya libala ; nakofuta bino eloko nyonso oyo bokosenga ngai. Kasi bopesa ngai kaka elenge mwasi oyo na libala. ");
INSERT INTO lin_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Lokola lokumu ya Dina, ndeko mwasi na bango, ebebaki, bana mibali ya Jakobi basalelaki mayele mabe mpo na kopesa eyano epai ya Sishemi mpe tata na ye Amori. ");
INSERT INTO lin_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Balobaki na bango : — Tokoki kosala likambo ya boye te, tokoki te kopesa na libala ndeko na biso ya mwasi epai ya mobali oyo akatama ngenga te, pamba te ezali likambo ya soni mpo na biso. ");
INSERT INTO lin_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Tokoki kondima yango kaka soki bokomi lokola biso, soki bana na bino nyonso ya mibali bakatisi ngenga. ");
INSERT INTO lin_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Boye biso tokopesa na libala bana na biso ya basi mpe tokozwa bana na bino ya basi na libala. Tokovanda elongo na bino mpe tokokoma libota moko. ");
INSERT INTO lin_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Kasi soki boboyi kokatisa ngenga ndenge biso tolobi, tokozwa ndeko na biso ya mwasi mpe tokokende na biso. ");
INSERT INTO lin_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Likanisi na bango emonanaki malamu epai ya Amori mpe Sishemi, mwana na ye ya mobali. ");
INSERT INTO lin_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Lokola elenge mobali, oyo azalaki na lokumu koleka bato nyonso ya ndako ya tata na ye, alingaki mwana mwasi ya Jakobi, akokisaki na lombangu likambo oyo bayebisaki ye. ");
INSERT INTO lin_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Boye, Amori mpe Sishemi, mwana na ye ya mobali, bakendeki na ekuke ya engumba na bango mpo na koloba na bana mboka na bango : ");
INSERT INTO lin_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","« Bato oyo bazali na boboto epai na biso ; tika ete bavanda elongo na biso mpe basala mombongo, mpo ete mboka ezali na yango monene ! Tokoki na biso kobala bana na bango ya basi, mpe bango bakoki na bango kobala bana na biso ya basi. ");
INSERT INTO lin_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Kasi mibali bakondima kovanda elongo na biso lokola bandeko ya libota moko soki kaka mibali nyonso kati na biso bakatisi ngenga lokola bango. ");
INSERT INTO lin_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Bibwele na bango, bomengo na bango, banyama na bango nyonso ; boni ekokoma ya biso te soki kaka tondimi ete bavanda elongo na biso ? » ");
INSERT INTO lin_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Boye, bato nyonso oyo bazalaki kobima na ekuke ya engumba bandimaki Amori mpe mwana na ye ya mobali, Sishemi ; mpe mibali nyonso bakatisaki ngenga. ");
INSERT INTO lin_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Sima na mikolo misato, wana mibali nyonso kati na bango bazalaki nanu na pasi ya bapota, bana mibali mibale ya Jakobi, bandeko mibali ya Dina, Simeoni mpe Levi, bakamataki mipanga na bango, bakotaki na pwasa kati na engumba mpe babomaki mibali nyonso. ");
INSERT INTO lin_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Babomaki na mopanga Amori mpe mwana na ye ya mobali Sishemi. Bakamataki Dina wuta na ndako ya Sishemi mpe bazongaki na ye. ");
INSERT INTO lin_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Bana mibali mosusu ya Jakobi bayaki kosasa mibali oyo bazalaki na bapota mpe kobebisa engumba mpo ete babebisaki lokumu ya ndeko na bango ya mwasi. ");
INSERT INTO lin_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Babotolaki bangombe na bango, bameme mpe bantaba na bango, ba-ane na bango, biloko nyonso oyo ezalaki kati na engumba mpe na bilanga. ");
INSERT INTO lin_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Bakamataki bomengo na bango nyonso : bana, basi mpe biloko nyonso oyo ezalaki kati na bandako na bango. ");
INSERT INTO lin_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Boye, Jakobi alobaki na Simeoni mpe na Levi : — Bopesi ngai pasi mpe bobimisi ngai moto mabe na miso ya bato ya Kanana mpe ya Perizi oyo bazali kovanda na mboka oyo. Biso tozali kaka moke ; mpe soki basangisi makasi na bango mpo na kobundisa ngai, bakoboma ngai elongo na ndako na ngai mobimba. ");
INSERT INTO lin_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Bango bazongisaki : — Boni, esengelaki bazwa ndeko na biso lokola mwasi ya ndumba ? ");
INSERT INTO lin_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Nzambe alobaki na Jakobi : « Kende na Beteli, vanda kuna mpe tonga kuna etumbelo mpo na Nzambe oyo abimelaki yo tango ozalaki kokima ndeko na yo Ezawu. » ");
INSERT INTO lin_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Jakobi alobaki na bato ya libota na ye mpe na bato nyonso oyo bazalaki na ye elongo : « Bolongola banzambe ya bapaya oyo ezali kati na bino, bomipetola mpe bolata bilamba mosusu. ");
INSERT INTO lin_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Tokomata na Beteli epai wapi nakotonga etumbelo mpo na Nzambe oyo ayanolaki ngai na mokolo oyo nazalaki na pasi mpe azalaki elongo na ngai bisika nyonso oyo nazalaki kokende. » ");
INSERT INTO lin_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Bapesaki Jakobi banzambe nyonso ya bapaya, oyo bazalaki na yango mpe biloko na bango ya matoyi. Boye Jakobi akundaki yango na se ya nzete ya terebente oyo ezalaki pene ya Sishemi. ");
INSERT INTO lin_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Sima, bakendeki. Kanda na Nzambe ekweyelaki bingumba nyonso ya zingazinga na bango, mpe moko te alandaki bana mibali ya Jakobi. ");
INSERT INTO lin_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Jakobi mpe bato nyonso oyo bazalaki elongo na ye bakomaki na Luze, oyo ezali Beteli, kati na mokili ya Kanana. ");
INSERT INTO lin_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Kuna nde atongaki etumbelo mpe abengaki esika yango « Eli Beteli, » pamba te ezalaki kuna nde Nzambe amimonisaki epai na ye tango azalaki kokima ndeko na ye. ");
INSERT INTO lin_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Ezalaki wana nde Debora, mama mobokoli ya Rebeka, akufaki. Bakundaki ye pembeni ya Beteli, na se ya nzete oyo, wuta na tango wana, bakomaki kobenga « Aloni-Bakuti. » ");
INSERT INTO lin_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Nzambe abimelaki lisusu Jakobi tango azongaki wuta na Padani-Arami mpe apambolaki ye. ");
INSERT INTO lin_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Nzambe alobaki na ye : « Kombo na yo ezali Jakobi ; kasi okobengama lisusu Jakobi te, kombo na yo ekomi Isalaele. » Yango wana Nzambe apesaki ye kombo « Isalaele. » ");
INSERT INTO lin_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Nzambe alobaki na ye lisusu : « Nazali Nzambe-Na-Nguya-Nyonso. Bota bana mpe bokoma ebele ; bokoma ekolo moko mpe bikolo ebele ekobima na nzela na yo, bakonzi bakobima kati na yo. ");
INSERT INTO lin_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Mokili oyo napesaki na Abrayami mpe na Izaki, napesi yango mpe na yo. Nakopesa yango lisusu na bakitani na yo. » ");
INSERT INTO lin_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Sima, Nzambe atikaki ye na esika oyo asololaki na ye. ");
INSERT INTO lin_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Jakobi atelemisaki libanga ya elembo na esika oyo Nzambe asololaki na ye ; asopaki likolo ya libanga yango likabo ya masanga mpe mafuta. ");
INSERT INTO lin_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Jakobi apesaki esika oyo Nzambe asololaki na ye kombo « Beteli. » ");
INSERT INTO lin_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Jakobi mpe libota na ye balongwaki na Beteli. Wana bazalaki nanu mwa mosika na Efrata, Rasheli abotaki, kasi na pasi makasi. ");
INSERT INTO lin_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Lokola azalaki na pasi makasi ya kobota, mwasi mobotisi ayebisaki ye : « Kobanga te ! Pamba te ozali na mwana mobali mosusu. » ");
INSERT INTO lin_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Lokola azalaki kobundana mpo na kokufa, liboso ya kokata motema, apesaki mwana na ye ya mobali kombo Beni-Oni. Kasi tata na ye apesaki ye kombo Benjame. ");
INSERT INTO lin_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Rasheli akufaki mpe bakundaki ye na nzela ya Efrata, elingi koloba Beteleemi. ");
INSERT INTO lin_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Jakobi atelemisaki libanga ya elembo likolo ya kunda ya Rasheli ; mpe kino lelo oyo, libanga wana ya elembo elakisaka kunda ya Rasheli. ");
INSERT INTO lin_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Sima, Isalaele alongwaki mpe akendeki kotonga ndako na ye ya kapo mosika ya Migidali-Ederi. ");
INSERT INTO lin_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Wana Isalaele azalaki kowumela na mokili wana, Ribeni ayaki kuna mpe asangisaki nzoto na Bila, makangu ya tata na ye ; mpe Isalaele ayokaki yango. Jakobi azalaki na bana mibali zomi na mibale : ");
INSERT INTO lin_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Bana mibali ya Lea : Ribeni, mwana mobali ya liboso ya Jakobi ; Simeoni, Levi, Yuda, Isakari mpe Zabuloni. ");
INSERT INTO lin_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Bana mibali ya Rasheli : Jozefi mpe Benjame. ");
INSERT INTO lin_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Bana mibali ya Bila, mwasi mosali ya Rasheli : Dani mpe Nefitali. ");
INSERT INTO lin_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Bana mibali ya Zilipa, mwasi mosali ya Lea : Gadi mpe Aseri. Bango nde bana mibali ya Jakobi oyo babotelaki ye na Padani-Arami. ");
INSERT INTO lin_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Jakobi azongaki epai ya Izaki, tata na ye, na Mamire, pene ya Kiriati-Ariba oyo ebengami Ebron, epai wapi Abrayami mpe Izaki bazalaki kovanda. ");
INSERT INTO lin_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Izaki awumelaki na bomoi mibu nkama moko na tuku mwambe. ");
INSERT INTO lin_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Sima, Izaki akataki motema mpe akufaki ; awumelaki na bomoi mibu ebele, akomaki mobange mpe alandaki bakoko na ye. Bana na ye ya mibali, Ezawu mpe Jakobi, bakundaki ye. ");
INSERT INTO lin_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Tala libota ya Ezawu oyo azali Edomi. ");
INSERT INTO lin_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Ezawu abalaki basi na ye kati na bana basi ya Kanana : Ada, mwana mwasi ya Eloni, moto ya Iti ; Olibama, mwana mwasi ya Ana mpe koko ya Tsibeoni, moto ya Evi ; ");
INSERT INTO lin_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","mpe Basimati, mwana mwasi ya Isimaeli mpe ndeko mwasi ya Nebayoti. ");
INSERT INTO lin_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada abotelaki Ezawu Elifazi ; mpe Basimati abotelaki ye Reweli. ");
INSERT INTO lin_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Olibama abotaki Yewushi, Yaelami mpe Kora. Bango nde bana mibali oyo babotelaki Ezawu na mokili ya Kanana. ");
INSERT INTO lin_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Ezawu azwaki basi na ye, bana na ye ya mibali, bana na ye ya basi, bato nyonso ya ndako na ye mpe bibwele na ye, banyama na ye nyonso mpe biloko nyonso oyo azwaki na mokili ya Kanana, akendeki na mokili mosusu, mosika ya ndeko na ye Jakobi. ");
INSERT INTO lin_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Bomengo na bango ekomaki mingi penza, mpe bakokaki lisusu te kovanda esika moko ; pamba te mokili oyo bazalaki kovanda ekokaki bango lisusu te likolo ya motango ya bibwele na bango. ");
INSERT INTO lin_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Yango wana Ezawu, oyo azali Edomi, akendeki kovanda na ngomba Seiri. ");
INSERT INTO lin_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Tala libota ya Ezawu, koko ya bato ya Edomi, na ngomba Seiri : ");
INSERT INTO lin_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Tala bakombo ya bana mibali ya Ezawu : Elifazi, mwana mobali ya Ada, mwasi ya Ezawu ; mpe Reweli, mwana mobali ya Basimati, mwasi ya Ezawu. ");
INSERT INTO lin_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Bana mibali ya Elifazi : Temani, Omari, Tsefo, Gaetami mpe Kenazi. ");
INSERT INTO lin_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Elifazi, mwana mobali ya Ezawu, azalaki na makangu oyo kombo na ye ezalaki « Timina ; » Timina abotelaki ye Amaleki. Bango nde bakoko ya Ada, mwasi ya Ezawu. ");
INSERT INTO lin_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Bana mibali ya Reweli : Naati, Zera, Shama mpe Miza. Bango nde bakoko ya Basimati, mwasi ya Ezawu. ");
INSERT INTO lin_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Tala bana mibali oyo Olibama, mwasi ya Ezawu, mwana mwasi ya Ana mpe koko ya Tsibeoni, abotelaki Ezawu : Yewushi, Yaelami mpe Kora. ");
INSERT INTO lin_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Tala bakonzi ya mabota ya bana mibali ya Ezawu : Bana ya Elifazi, mwana liboso ya Ezawu : mokonzi Temani, mokonzi Omari, mokonzi Tsefo, mokonzi Kenazi, ");
INSERT INTO lin_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","mokonzi Kora, mokonzi Gaetami mpe mokonzi Amaleki. Bango nde bakonzi ya libota ya Elifazi, oyo babotamaki na Edomi ; bazalaki bakoko ya Ada. ");
INSERT INTO lin_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Bana mibali ya Reweli, mwana mobali ya Ezawu : mokonzi Naati, mokonzi Zera, mokonzi Shama mpe mokonzi Miza. Bango nde bakonzi ya libota ya Reweli, oyo babotamaki na Edomi ; bazalaki bakoko ya Basimati, mwasi ya Ezawu. ");
INSERT INTO lin_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Bana mibali ya Olibama, mwasi ya Ezawu : mokonzi Yewushi, mokonzi Yaelami mpe mokonzi Kora. Bango nde bakonzi ya libota ya Olibama, mwana mwasi ya Ana mpe mwasi ya Ezawu. ");
INSERT INTO lin_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Bango nde bazalaki bana mibali ya Ezawu oyo azali Edomi, mpe bango nde bazalaki bakonzi ya mabota ya Edomi. ");
INSERT INTO lin_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Tala bakitani ya Seiri, moto ya Ori, bato ya liboso oyo bavandaki na mokili yango : Lotani, Shobali, Tsibeoni, Ana, ");
INSERT INTO lin_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dishoni, Etseri mpe Dishani. Bango nde bakonzi ya libota ya Ori, mwana mobali ya Seiri, na mokili ya Edomi. ");
INSERT INTO lin_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Bana mibali ya Lotani : Ori mpe Emami. Timina azalaki ndeko mwasi ya Lotani. ");
INSERT INTO lin_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Bana mibali ya Shobali : Alivani, Manaati, Ebali, Shefo mpe Onami. ");
INSERT INTO lin_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Bana mibali ya Tsibeoni : Aya mpe Ana. Ezali Ana nde amonaki maziba ya mayi kati na esobe tango azalaki koleisa ba-ane ya Tsibeoni, tata na ye. ");
INSERT INTO lin_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Bana ya Ana : Dishoni, mwana na ye ya mobali ; mpe Olibama, mwana na ye ya mwasi. ");
INSERT INTO lin_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Bana mibali ya Dishoni : Emidani, Eshibani, Yitirani mpe Kerani. ");
INSERT INTO lin_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Tala bana mibali ya Etseri : Bilani, Zavani mpe Akani. ");
INSERT INTO lin_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Bana mibali ya Dishani : Utsi mpe Arani. ");
INSERT INTO lin_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Tala bakonzi ya mabota ya Ori : mokonzi Lotani, mokonzi Shobali, mokonzi Tsibeoni, mokonzi Ana, ");
INSERT INTO lin_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","mokonzi Dishoni, mokonzi Etseri mpe mokonzi Dishani. Bango nde bazalaki bakonzi ya mabota ya Ori, na mokili ya Seiri. ");
INSERT INTO lin_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Tala bakonzi oyo bakonzaki kati na Edomi liboso ete bana ya Isalaele bazwa mokonzi : ");
INSERT INTO lin_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela, mwana mobali ya Beori, akomaki mokonzi ya Edomi. Kombo ya engumba na ye ezalaki « Dinaba. » ");
INSERT INTO lin_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Tango Bela akufaki, Yobabi, mwana mobali ya Zera, moto ya mokili ya Botsira, akitanaki na ye na bokonzi. ");
INSERT INTO lin_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Tango Yobabi akufaki, Ushami, moto ya mokili ya Temani, akitanaki na ye na bokonzi. ");
INSERT INTO lin_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Tango Ushami akufaki, Adadi, mwana mobali ya Bedadi oyo alongaki Madiani na bilanga ya Moabi, akitanaki na ye na bokonzi. Kombo ya engumba na ye ezalaki Aviti. ");
INSERT INTO lin_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Tango Adadi akufaki, Samila, moto ya engumba Masireka, akitanaki na ye na bokonzi. ");
INSERT INTO lin_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Tango Samila akufaki, Saulo, moto ya engumba Reoboti, engumba oyo etongama pembeni ya ebale, akitanaki na ye na bokonzi. ");
INSERT INTO lin_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Tango Saulo akufaki, Bala-Anani, mwana mobali ya Akibori, akitanaki na ye na bokonzi. ");
INSERT INTO lin_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Tango Bala-Anani, mwana mobali ya Akibori, akufaki, Adari akitanaki na ye na bokonzi. Kombo ya engumba na ye ezalaki « Pawu, » mpe kombo ya mwasi na ye ezalaki « Meetabeli. » Meetabeli azalaki mwana mwasi ya Matiredi, mwana mwasi ya Mezaabi. ");
INSERT INTO lin_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Tala bato oyo bazalaki bakonzi ya mabota ya Ezawu kolanda mabota ya botata, bisika oyo bazalaki kovanda mpe bakombo na bango : Timina, Aliva, Yeteti, ");
INSERT INTO lin_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Olibama, Ela, Pinoni, ");
INSERT INTO lin_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenazi, Temani, Mibitsari, ");
INSERT INTO lin_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magidieli mpe Irami. Bango nde bazalaki bakonzi ya Edomi kolanda bituka na bango, kati na mokili oyo bazalaki kovanda. Ezawu azalaki koko ya bato ya Edomi. ");
INSERT INTO lin_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jakobi avandaki na mokili ya Kanana epai wapi tata na ye azalaki kovanda. ");
INSERT INTO lin_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Tala molongo ya libota ya Jakobi. Elenge mobali Jozefi azalaki na mibu zomi na sambo ya mbotama mpe azalaki kobatela bibwele. Azalaki kosala mosala yango elongo na bandeko na ye ya mibali, bana ya Bila mpe ya Zilipa, basi ya tata na ye. Jozefi azalaki koyebisa tata na bango makambo mabe ya bandeko na ye. ");
INSERT INTO lin_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Isalaele azalaki kolinga Jozefi mingi koleka bana na ye nyonso, pamba te abotaki ye na kimobange. Asalelaki ye elamba ya kitoko mpe ya talo. ");
INSERT INTO lin_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Tango bandeko na ye ya mibali bamonaki ete tata na bango azali kolinga ye koleka bango nyonso, bayinaki ye mpe bakokaki lisusu te koloba na ye na motema malamu. ");
INSERT INTO lin_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Jozefi alotaki ndoto mpe tango ayebisaki yango epai ya bandeko na ye ya mibali, bayinaki ye lisusu makasi. ");
INSERT INTO lin_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Alobaki na bango : — Boyoka ndoto oyo nalotaki : ");
INSERT INTO lin_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","« Tozalaki kokanga maboke ya ble kati na bilanga. Mbala moko, liboke na ngai elamuki mpe etelemi ngwi ; bongo maboke na bino, oyo ezalaki zingazinga ya liboke na ngai, egumbamaki liboso ya liboke na ngai. » ");
INSERT INTO lin_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Bandeko na ye ya mibali balobaki na ye : — Okanisi ete okokoma mokonzi na biso mpe okokonza biso ? Bongo bayinaki ye lisusu koleka likolo ya ndoto na ye mpe likolo ya makambo oyo alobaki. ");
INSERT INTO lin_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Alotaki lisusu ndoto mosusu mpe ayebisaki yango epai ya bandeko na ye ya mibali. Alobaki : — Boyoka, naloti lisusu ndoto mosusu : « Namonaki moyi, sanza mpe minzoto zomi na moko kogumbama liboso na ngai. » ");
INSERT INTO lin_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Tango ayebisaki tata na ye ndenge ayebisaki bandeko na ye ya mibali, tata na ye agangelaki ye mpe alobaki : — Ndoto nini wana yo osili kolota ? Okanisi ete ngai, mama na yo mpe bandeko na yo ya mibali, tokoya mpe tokogumbama na mabele liboso na yo ? ");
INSERT INTO lin_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Bandeko na ye ya mibali bakomaki na motema likunya epai na ye, kasi tata na ye abombaki kaka likambo yango na motema. ");
INSERT INTO lin_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Bandeko mibali ya Jozefi bakendeki koleisa bibwele ya tata na bango pembeni ya Sishemi. ");
INSERT INTO lin_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Isalaele alobaki na Jozefi : — Oyebi ete bandeko na yo bazali koleisa bibwele pembeni ya Sishemi ; yaka, pamba te nalingi kotinda yo epai na bango. Jozefi azongisaki : — Malamu ! ");
INSERT INTO lin_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Tata na ye alobaki na ye : — Kende mpe tala soki makambo nyonso ezali kotambola malamu mpo na bandeko na yo mpe mpo na bibwele, bongo omemela ngai sango. Boye, atindaki ye wuta na lubwaku ya Ebron. Wana Jozefi akomaki na Sishemi, ");
INSERT INTO lin_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","moto moko amonaki ye tango azalaki koyengayenga na bilanga. Atunaki ye : — Ozali koluka nini ? ");
INSERT INTO lin_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Jozefi azongisaki : — Nazali koluka bandeko na ngai. Okoki koyebisa ngai esika nini bazali koleisa bibwele na bango ? ");
INSERT INTO lin_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Moto yango azongisaki : — Balongwaki awa mpe nayokaki bango koloba : « Tokende na Dotani. » Boye Jozefi alandaki bandeko na ye mpe amonaki bango pembeni ya Dotani. ");
INSERT INTO lin_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Tango bango bamonaki ye na mosika liboso ete akoma pene na bango, bayokanaki mpo ete baboma ye. ");
INSERT INTO lin_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Balobanaki bango na bango : — Tala moloti bandoto azali koya. ");
INSERT INTO lin_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Sik’oyo, boya mpo ete toboma ye mpe tobwaka ye na moko kati na mabulu oyo. Tokoloba ete nyama mabe eliaki ye. Bongo tokotala oyo ekoya sima na bandoto na ye. ");
INSERT INTO lin_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Tango Ribeni ayokaki bongo, alukaki nzela ya kokangola ye na maboko na bango. Alobaki : — Toboma ye te ! ");
INSERT INTO lin_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Bosopa makila na ye te ! Bobwaka ye kaka na libulu oyo ezali kati na esobe, kasi bosala ye mabe te. Ribeni alobaki bongo pamba te azalaki na makanisi ya kokangola ye na maboko na bango mpe kozongisa ye na maboko ya tata na ye. ");
INSERT INTO lin_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Tango kaka Jozefi akomaki epai ya bandeko na ye ya mibali, balongolaki ye elamba na ye ya kitoko mpe ya talo oyo alataki. ");
INSERT INTO lin_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Bakangaki ye mpe babwakaki ye na libulu. Libulu yango ezalaki na eloko te, ezalaki mpe na mayi te na kati. ");
INSERT INTO lin_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Wana bavandaki mpo na kolia, batombolaki miso mpe bamonaki bato ya libota ya Isimaeli elongo na bashamo na bango koya wuta na Galadi. Bashamo na bango ezalaki komema na Ejipito : biloko ya mike-mike ya solo kitoko oyo balambelaka, mafuta ya solo kitoko mpe mire. ");
INSERT INTO lin_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Boye Yuda alobaki na bandeko na ye ya mibali : « Litomba nini tokozwa soki tobomi ndeko na biso mpe tozipi makila na ye ? ");
INSERT INTO lin_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Malamu toteka ye epai ya bato ya ekolo ya Isimaeli, kasi toboma ye te ; pamba te azali kaka ndeko na biso mpe tozali na ye makila moko. » Boye bandeko na ye bandimaki. ");
INSERT INTO lin_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Nzokande tango bato ya mombongo ya mokili ya Madiani balekaki wana, babimisaki Jozefi wuta na libulu mpe batekaki ye epai ya bato ya ekolo ya Isimaeli, na motuya ya mbongo ya bibende, tuku mibale ; mpe bango bamemaki ye na Ejipito. ");
INSERT INTO lin_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Tango Ribeni azongaki na libulu mpe amonaki ete Jozefi azali lisusu kuna te, apasolaki bilamba na ye, ");
INSERT INTO lin_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","azongaki epai ya bandeko na ye mpe alobaki : « Elenge mobali azali lisusu kuna te ! Sik’oyo ngai, nakosuka wapi ? » ");
INSERT INTO lin_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Boye babomaki ntaba, bazwaki elamba ya Jozefi mpe bazindisaki yango na makila ya ntaba. ");
INSERT INTO lin_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Sima, bazongisaki elamba yango ya kitoko mpe ya talo epai ya tata na bango. Balobaki : — Tala eloko oyo tomoni ; tala yango malamu soki ezali penza elamba ya mwana na yo to te ! ");
INSERT INTO lin_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Jakobi asosolaki ete ezali elamba ya Jozefi mpe agangaki : — Ezali elamba ya mwana na ngai ! Nyama moko ya mabe elie ye ! Solo, bakati-kati Jozefi na biteni ! ");
INSERT INTO lin_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Jakobi apasolaki bilamba na ye, alataki saki mpe asalaki matanga mpo na mwana na ye mikolo ebele. ");
INSERT INTO lin_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Bana na ye nyonso ya mibali mpe ya basi bayaki kobondisa ye ; kasi aboyaki kobondisama. Alobaki : « Te ; nakozala na matanga kino nakolanda mwana na ngai na mboka ya bakufi epai wapi mwana na ngai azali. » Boye, tata na ye alelaki ye. ");
INSERT INTO lin_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Bato ya mokili ya Madiani batekaki Jozefi na Ejipito epai ya Potifari, kalaka ya lokumu ya Faraon mpe mokonzi ya bakengeli ya mokonzi. ");
INSERT INTO lin_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Nzokande na tango wana, Yuda atikaki bandeko na ye mpe akendeki kovanda epai ya Ira, moto ya Adulami. ");
INSERT INTO lin_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Yuda akutanaki kuna na mwana mwasi ya Shuwa, moto ya Kanana. Abalaki ye mpe asangisaki na ye nzoto. ");
INSERT INTO lin_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Mwasi yango akomaki na zemi mpe abotelaki Yuda mwana mobali. Mpe Yuda apesaki ye kombo « Eri. » ");
INSERT INTO lin_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Mwasi yango azwaki lisusu zemi mpe abotaki mwana mobali ; apesaki ye kombo « Onani. » ");
INSERT INTO lin_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Abotaki mwana mobali mosusu mpe apesaki ye kombo « Shela. » Yuda azalaki na Kezibi tango mwasi na ye abotaki mwana ya misato. ");
INSERT INTO lin_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Yuda abalelaki Eri, mwana na ye ya liboso, mwasi : Tamari. ");
INSERT INTO lin_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Kasi Eri, mwana liboso ya Yuda, azalaki moto mabe na miso ya Yawe ; yango wana Yawe abomaki ye. ");
INSERT INTO lin_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Bongo Yuda alobaki na Onani : « Sangisa nzoto na semeki na yo mpo ete obota bana mpo na ndeko na yo ya mobali oyo akufa. » ");
INSERT INTO lin_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Kasi lokola Onani ayebaki ete bana oyo bakobotama bakozala ya ye te, azalaki kobwaka mayi na ye ya mibali na mabele tango nyonso azalaki kosangisa nzoto na semeki na ye, mpo ete abotela ndeko na ye ya mobali bana te. ");
INSERT INTO lin_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Likambo oyo Onani azalaki kosala ezalaki kosepelisa Yawe te. Boye ye mpe lisusu, Yawe abomaki ye. ");
INSERT INTO lin_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Yuda alobaki na Tamari, bokilo na ye ya mwasi : « Lokola okufisi mibali, kende kovanda na ndako ya tata na yo kino Shela, mwana na ngai ya mobali, akokoma mokolo. » Pamba te azalaki komilobela : « Tango mosusu ye mpe akoki kokufa lokola bandeko na ye ya mibali. » Boye Tamari akendeki kovanda na ndako ya tata na ye. ");
INSERT INTO lin_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Sima na tango molayi, mwana mwasi ya Shuwa, mwasi ya Yuda, akufaki. Lokola tango na ye ya matanga esilaki, Yuda akendeki na Timina epai ya bato oyo bazalaki kolongola bapwale ya bameme na ye. Boye, moninga na ye Ira, moto ya Adulami, akendeki elongo na ye. ");
INSERT INTO lin_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Tango bayebisaki Tamari : « Bokilo na yo ya mobali azali kokende na Timina mpo na kolongolisa bapwale ya bameme na ye, » ");
INSERT INTO lin_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","alongolaki bilamba na ye ya mwasi akufisa mobali mpe amizipaki elongi na vwale mpo ete bayeba ye lisusu te. Avandaki na ekuke ya Enayimi oyo ezalaki na nzela ya Timina, pamba te amonaki ete Shela akolaki, kasi bapesaki ye te na libala epai ya Shela. ");
INSERT INTO lin_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Tango Yuda amonaki ye, akanisaki ete azali mwasi ya ndumba, pamba te azipaki elongi na ye. ");
INSERT INTO lin_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Lokola Yuda ayebaki te ete ezali bokilo na ye ya mwasi, apusanaki na esika oyo azalaki, pembeni ya nzela, mpe alobaki na ye : — Yaka, ndima ete tosangisa na yo nzoto. Tamari atunaki : — Okopesa ngai nini soki osangisi na ngai nzoto ? ");
INSERT INTO lin_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Yuda azongisaki : — Nakotindela yo mwana ntaba oyo nakozwa na etonga na ngai. Tamari atunaki lisusu : — Ndanga nini okosimbisa ngai kino tango okotindela ngai yango ? ");
INSERT INTO lin_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Yuda alobaki : — Ndanga nini olingi ete nasimbisa yo ? Tamari azongisaki : — Lopete na yo, singa na yo mpe lingenda na yo, oyo osimbi na loboko. Boye Yuda apesaki ye yango, asangisaki na ye nzoto mpe Tamari akomaki na zemi. ");
INSERT INTO lin_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Tamari atelemaki mpe akendeki ; alongolaki vwale na ye mpe azongisaki lisusu na nzoto bilamba na ye ya mwasi akufisa mobali. ");
INSERT INTO lin_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Boye Yuda atindaki moninga na ye Ira, moto ya Adulami, mpo ete amemela mwasi yango mwana ntaba mpe azwa ndanga oyo asimbisaki ye. Kasi Ira amonaki ye te. ");
INSERT INTO lin_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Boye atunaki epai ya bavandi ya esika wana, na Enayimi : — Wapi mwasi ya ndumba oyo azalaki na nzela, na Enayimi ? Bazongiselaki ye : — Esika oyo etikala kozala na mwasi ya ndumba te. ");
INSERT INTO lin_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Ira azongaki epai ya Yuda mpe ayebisaki ye : — Namoni ye te ; kutu bavandi ya Enayimi bayebisi ngai ete mwasi ya ndumba atikala kozala na esika wana te. ");
INSERT INTO lin_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yuda alobaki : — Atikala na biloko oyo azwaki, noki te tokobima babolole. Ngai nazali na likambo te ; natindeli ye mwana ntaba, mpe yo omoni ye te. ");
INSERT INTO lin_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Sima na sanza misato, bayebisaki Yuda : — Tamari, bokilo na yo ya mwasi, asalaki kindumba, mpe tala kutu akomi na zemi. Yuda alobaki : — Babimisa ye mpe batumba ye na moto ! ");
INSERT INTO lin_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Wana bazalaki kobimisa ye libanda, Tamari atindaki sango oyo epai ya Yuda, bokilo na ye : — Nazali na zemi ya nkolo biloko oyo. Mpe abakisaki : — Tala soki okoki koyeba nani azali nkolo ya lopete oyo, ya singa oyo mpe ya lingenda oyo. ");
INSERT INTO lin_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yuda asosolaki ete ezali biloko na ye mpe alobaki : — Azali sembo koleka ngai, pamba te nabalisaki ye te epai ya Shela, mwana na ngai ya mobali. Boye Yuda atikalaki lisusu te kosangisa na ye nzoto. ");
INSERT INTO lin_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Wana tango na ye ya kobota ekokaki, emonanaki ete ezalaki na mapasa mibale ya mibali kati na libumu na ye. ");
INSERT INTO lin_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Na tango ya kobota, moko kati na bango abimisaki loboko ; mpe mwasi oyo abotisaka asimbaki loboko yango, akangaki yango singa ya motane mpe alobaki : « Mwana oyo nde abimi liboso. » ");
INSERT INTO lin_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Kasi azongisaki loboko na ye, mpe ndeko na ye ya mobali abimaki. Bongo mwasi oyo abotisaka alobaki : « Ofungoli nzela nini mpo na kobima ? » Mpe bapesaki ye kombo « Peretsi. » ");
INSERT INTO lin_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Sima, ndeko na ye oyo azalaki na singa ya motane na loboko mpe abotamaki ; bapesaki ye kombo « Zera. » ");
INSERT INTO lin_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Sima, bamemaki Jozefi na Ejipito. Potifari, kalaka ya lokumu ya Faraon mpe mokonzi ya bakengeli ya mokonzi, moto ya Ejipito, asombaki ye na maboko ya bato ya Isimaeli oyo bamemaki ye kuna. ");
INSERT INTO lin_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Yawe azalaki elongo na Jozefi ; boye Jozefi azalaki kolonga na makambo nyonso oyo azalaki kosala, mpe avandaki kati na ndako ya moto ya Ejipito, nkolo na ye. ");
INSERT INTO lin_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Tango nkolo na ye asosolaki ete Yawe azali elongo na Jozefi, mpe ete Yawe azali kolongisa ye na makambo nyonso oyo azali kosala, ");
INSERT INTO lin_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Jozefi azwaki ngolu na miso ya nkolo na ye, oyo apesaki ye mokumba ya kobatela bozwi na ye nyonso : Potifari akomisaki Jozefi mokonzi kati na ndako na ye mpe apesaki ye mokumba ya kobatela biloko na ye nyonso. ");
INSERT INTO lin_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Wuta tango Potifari akomisaki Jozefi mokonzi kati na ndako na ye mpe mokonzi ya biloko nyonso oyo azalaki na yango, Yawe apambolaki ndako ya moto ya Ejipito mpo na Jozefi ; lipamboli ya Yawe ezalaki na likolo ya biloko nyonso oyo azalaki na yango, kati na ndako na ye mpe na bilanga. ");
INSERT INTO lin_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Boye Potifari atikaki biloko na ye nyonso kati na maboko ya Jozefi, azalaki lisusu kotala eloko moko te longola kaka bilei na ye. Jozefi azalaki na nzoto kitoko mpe elongi kitoko. ");
INSERT INTO lin_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Sima na yango, mwasi ya nkolo ya Jozefi alulaki ye Jozefi mpe alobaki na ye : — Yaka kosangisa na ngai nzoto ! ");
INSERT INTO lin_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Kasi Jozefi aboyaki mpe alobaki na mwasi ya nkolo na ye : — Tala, nkolo na ngai atunaka ngai ata eloko moko te na oyo etali ndako na ye, mpe atika biloko na ye nyonso kati na maboko na ngai. ");
INSERT INTO lin_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Moto moko te aleki ngai na monene kati na ndako oyo. Nkolo na ngai apekisi ngai eloko moko te longola kaka yo, pamba te ozali mwasi na ye. Boye ndenge nini penza ngai nakoki kosala likambo ya mabe boye mpe kosala masumu liboso ya Nzambe ? ");
INSERT INTO lin_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Mokolo na mokolo, mwasi ya Potifari azalaki kaka kotungisa Jozefi, kasi ye mpe azalaki kaka koboya kosangisa na ye nzoto to kozala na ye elongo. ");
INSERT INTO lin_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Mokolo moko, awa Jozefi akotaki na ndako mpo na kosala mosala na ye, mpe ata mosali moko te azalaki wana, ");
INSERT INTO lin_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","mwasi ya Potifari akangaki ye na bilamba mpe alobaki na ye : — Yaka kosangisa na ngai nzoto ! Kasi Jozefi asundolaki elamba na ye kati na maboko ya mwasi ya Potifari mpe akimaki libanda ya ndako. ");
INSERT INTO lin_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Tango mwasi ya Potifari amonaki ete Jozefi asundoli elamba na ye kati na maboko na ye mpe akimi libanda, ");
INSERT INTO lin_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","abengaki basali ya ndako na ye mpe alobaki : — Botala ! Mo-Ebre oyo bamemelaki biso ayaki nde kosakanela biso ! Aluki kosangisa na ngai nzoto, kasi ngai nagangi makasi. ");
INSERT INTO lin_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Tango ayoki ete nagangi makasi mpo na koluka lisalisi, asundoli elamba na ye pembeni na ngai mpe akimi libanda ! ");
INSERT INTO lin_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Mwasi ya Potifari abombaki elamba ya Jozefi pembeni na ye kino mobali na ye azongaki na ndako. ");
INSERT INTO lin_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Bongo abetelaki ye lisolo : — Mowumbu Mo-Ebre oyo omemelaki biso, ayaki epai na ngai mpo na kosakana na ngai. ");
INSERT INTO lin_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Kasi tango nagangaki makasi mpo na koluka lisalisi, asundolaki elamba na ye pembeni na ngai mpe akimaki libanda. ");
INSERT INTO lin_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Tango nkolo ya Jozefi ayokaki lisolo oyo mwasi na ye abetelaki ye na maloba oyo : « Tala ndenge mowumbu na yo asali ngai, » Potifari asilikaki makasi. ");
INSERT INTO lin_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Potifari akangaki Jozefi mpe abwakaki ye na boloko epai wapi mokonzi Faraon atiaka bakangami. Kasi, wana Jozefi azalaki kati na boloko, ");
INSERT INTO lin_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Yawe azalaki elongo na Jozefi mpe atalisaki ye bolamu na Ye ; asalelaki ye ngolu na miso ya mokonzi ya boloko. ");
INSERT INTO lin_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Mokonzi ya boloko apesaki Jozefi mokumba ya kokengela bato nyonso ya boloko mpe ya kotambolisa makambo nyonso oyo ezalaki kosalema kuna. ");
INSERT INTO lin_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Mokonzi ya boloko azalaki kotala lisusu likambo moko te kati na makambo oyo apesaki Jozefi mokumba ya kosala, pamba te Yawe azalaki elongo na ye mpe azalaki kolongisa ye na makambo nyonso oyo azalaki kosala. ");
INSERT INTO lin_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Sima na mwa tango, kalaka oyo azalaki kotala makambo oyo etali masanga ya mokonzi ya Ejipito mpe oyo azalaki kotala makambo oyo etali mapa ya mokonzi ya Ejipito, basalaki mabe liboso ya nkolo na bango, mokonzi ya Ejipito. ");
INSERT INTO lin_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Faraon asilikelaki bakalaka na ye mibale ya lokumu : kalaka oyo azalaki kotala makambo oyo etali masanga mpe oyo azalaki kotala makambo oyo etali mapa. ");
INSERT INTO lin_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Abwakaki bango na boloko kati na ndako ya mokonzi ya bakengeli ya mokonzi, boloko epai wapi Jozefi azalaki. ");
INSERT INTO lin_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Mokonzi ya bakengeli ya mokonzi apesaki bango na maboko ya Jozefi mpo ete alandela bango. Boye basalaki mikolo mwa mingi na boloko. ");
INSERT INTO lin_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Ezalaki mokolo moko na butu, bango mibale, kalaka oyo azalaki kotala makambo oyo etali masanga mpe oyo azalaki kotala makambo oyo etali mapa ya mokonzi ya Ejipito, balotaki moto na moto ndoto na ye mpe ndoto na ndoto ezalaki na ndimbola na yango. ");
INSERT INTO lin_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Na tongo, Jozefi akendeki epai na bango mpe amonaki ete bazali mawa-mawa. ");
INSERT INTO lin_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Jozefi atunaki bakalaka ya lokumu ya Faraon, oyo bazalaki kati na boloko elongo na ye, kati na ndako ya nkolo na ye : — Mpo na nini lelo bilongi na bino ezali mawa-mawa ? ");
INSERT INTO lin_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Bazongiselaki ye : — Biso mibale toloti bandoto ; kasi moto ya kolimbola yango mpo na biso azali te. Jozefi alobaki na bango : — Boyebi te ete Nzambe nde apesaka ndimbola ya bandoto ? Nabondeli bino, boyebisa ngai bandoto na bino. ");
INSERT INTO lin_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Bongo kalaka oyo azalaki kotala makambo oyo etali masanga ya mokonzi ya Ejipito ayebisaki Jozefi ndoto na ye. Alobaki : — Na ndoto na ngai, namonaki nzete ya vino liboso na ngai. ");
INSERT INTO lin_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Nzete yango ya vino ezalaki na bitape misato. Bongo ekomaki kobimisa mito, fololo mpe maboke ebimisaki bambuma ya kotela. ");
INSERT INTO lin_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Kopo ya Faraon ezalaki na maboko na ngai. Nazwaki bambuma ya vino, nakamolaki yango na kopo ya Faraon mpe napesaki ye kopo yango na maboko na ye. ");
INSERT INTO lin_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Jozefi alobaki na ye : — Tala ndimbola ya ndoto na yo : « Bitape misato ezali mikolo misato. ");
INSERT INTO lin_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Sima na mikolo misato, Faraon akotombola moto na yo mpe akozongisa yo na esika na yo ya mosala. Okotia lisusu kopo ya Faraon na maboko na ye ndenge ozalaki kosala na kala. ");
INSERT INTO lin_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Kasi tango makambo nyonso oyo ekotambola malamu mpo na yo, nabondeli yo, kanisa ngai mpe salela ngai bolamu, zala molobeli na ngai epai ya Faraon mpo ete abimisa ngai na boloko oyo. ");
INSERT INTO lin_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Pamba te babimisaki ngai na makasi wuta na mokili ya Ba-Ebre ; mpe awa nasali likambo moko te ya mabe mpo ete batia ngai na boloko. » ");
INSERT INTO lin_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Tango kalaka oyo azalaki kotala makambo oyo etali mapa ya mokonzi ya Ejipito asosolaki ete Jozefi apesaki ndimbola ya malamu, alobaki na Jozefi : — Ngai mpe nalotaki ndoto : « Bitunga misato ya mapa ezalaki likolo ya moto na ngai. ");
INSERT INTO lin_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Kitunga ya likolo ezalaki na bagato ya ndenge na ndenge, oyo Faraon alingaka ; kasi bandeke ezalaki kolia yango wuta na kitunga oyo ezalaki na moto na ngai. » ");
INSERT INTO lin_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Jozefi alobaki na ye : — Tala ndimbola ya ndoto na yo : « Bitunga misato ezali mikolo misato. ");
INSERT INTO lin_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Sima na mikolo misato, Faraon akokata moto na yo mpe akodiembika yo na nzete. Bongo bandeke ekolia mosuni na yo. » ");
INSERT INTO lin_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Sima na mikolo misato, ezalaki mokolo ya mbotama ya Faraon. Faraon asalisaki feti monene mpe abengisaki bakalaka na ye nyonso. Abimisaki na boloko, liboso ya bakalaka na ye, kalaka oyo azalaki kotala makambo oyo etali masanga ya mokonzi mpe kalaka oyo azalaki kotala makambo oyo etali mapa. ");
INSERT INTO lin_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Faraon azongisaki na mosala, kalaka oyo azalaki kotala makambo oyo etali masanga. Boye azongelaki lisusu kotia kopo na maboko ya Faraon. ");
INSERT INTO lin_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Kasi Faraon adiembikaki kalaka oyo azalaki kotala makambo oyo etali mapa, ndenge kaka Jozefi ayebisaki bango. ");
INSERT INTO lin_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Kasi kalaka oyo azalaki kotala makambo oyo etali masanga ya mokonzi ya Ejipito atikalaki kokanisa lisusu Jozefi te : abosanaki ye. ");
INSERT INTO lin_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Sima na mibu mibale, Faraon alotaki ndoto : atelemaki pembeni ya ebale Nili, ");
INSERT INTO lin_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","amonaki bangombe sambo ya basi, ya kitoko mpe ya mafuta. Bangombe yango ebimaki wuta na ebale mpe ezalaki kolia matiti pembeni ya ebale Nili. ");
INSERT INTO lin_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Sima na yango, bangombe mosusu sambo ya basi, ya mabe mpe ekonda, ebimaki wuta na ebale, etelemaki pembeni ya bangombe ya basi oyo ezalaki pembeni ya ebale Nili. ");
INSERT INTO lin_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Bangombe sambo ya basi ya mabe mpe ekonda eliaki bangombe sambo ya kitoko mpe ya mafuta. Kaka na tango yango, Faraon alamukaki. ");
INSERT INTO lin_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Alalaki lisusu mpe alotaki ndoto ya mibale : nzete moko ya ble ebimisaki mito sambo ya ble, ya minene mpe ya kitoko. ");
INSERT INTO lin_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Mito mosusu sambo ya ble, ekonda mpe ezika na mopepe ya este, ebimaki sima na oyo ya minene. ");
INSERT INTO lin_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Mito sambo oyo ekonda eliaki mito sambo oyo ya minene mpe etonda. Kaka na tango yango, Faraon alamukaki, asosolaki ete ezali ndoto. ");
INSERT INTO lin_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Na tongo, lokola molimo na ye etungisamaki, abengaki bato nyonso ya soloka mpe ya bwanya ya Ejipito. Faraon ayebisaki bango ndoto na ye, kasi ata moto moko te akokaki kolimbolela ye yango. ");
INSERT INTO lin_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Kalaka oyo azalaki kotala makambo oyo etali masanga ya mokonzi alobaki na Faraon : « Na mokolo ya lelo, nalingi kokanisa mbeba na ngai. ");
INSERT INTO lin_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Mokolo moko, Faraon asilikelaki basali na ye mpe atiaki ngai na boloko elongo na kalaka oyo azalaki kotala makambo oyo etali mapa ya mokonzi kati na ndako ya mokonzi ya bakengeli ya mokonzi. ");
INSERT INTO lin_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Biso mibale tolotaki bandoto na butu moko : ndoto na ndoto ezalaki na ndimbola na yango. ");
INSERT INTO lin_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Kuna, tozalaki na elenge mobali moko, azali Mo-Ebre mpe mosali ya mokonzi ya bakengeli ya mokonzi. Toyebisaki ye bandoto na biso mpe alimbolaki yango mpo na biso, apesaki moto na moto ndimbola ya ndoto na ye. ");
INSERT INTO lin_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Makambo nyonso esalemaki ndenge kaka alimbolelaki biso yango. Ngai nazongelaki misala na ngai ; mpe moninga mosusu, badiembikaki ye. » ");
INSERT INTO lin_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Faraon abengaki Jozefi, mpe babimisaki ye na lombangu na boloko. Bakataki ye suki, alataki bilamba mosusu mpe ayaki liboso ya Faraon. ");
INSERT INTO lin_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Faraon alobaki na Jozefi : — Nalotaki ndoto mpe ata moto moko te alongi kolimbola yango ; kasi nayoki sango na tina na yo ete soki oyoki ndoto, okolimbola yango. ");
INSERT INTO lin_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Jozefi azongiselaki Faraon : — Ngai nakolonga te kosala yango, kasi Nzambe akopesa na Faraon eyano oyo azali na yango posa. ");
INSERT INTO lin_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Faraon alobaki na Jozefi : — Na ndoto na ngai, natelemaki pembeni ya ebale Nili. ");
INSERT INTO lin_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Namonaki bangombe sambo ya basi, ya kitoko mpe ya mafuta. Bangombe yango ebimaki wuta na ebale mpe ezalaki kolia matiti pembeni ya ebale Nili. ");
INSERT INTO lin_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Sima na yango, bangombe mosusu sambo ya basi ebimaki : ya mike, ya mabe penza mpe ekonda ; nanu natikala komona te bangombe ya ndenge wana na mokili mobimba ya Ejipito. ");
INSERT INTO lin_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Ngombe ya basi ekonda mpe ya mabe eliaki bangombe sambo ya mafuta oyo ebimaki liboso. ");
INSERT INTO lin_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Bongo ekotaki na mabumu na yango kasi ezalaki komonana te ete bangombe ya mafuta ekoti na mabumu ya bangombe ekonda, mpe lolenge na yango ezalaki kaka mabe lokola ndenge ezalaki liboso. Kaka na tango yango, nalamukaki. ");
INSERT INTO lin_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Na ndoto na ngai mosusu, namonaki mito sambo ya ble ya kitoko mpe ya mafuta kobima na nzete moko. ");
INSERT INTO lin_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Sima na yango, mito sambo mosusu ya ble ebimaki. Ezalaki ya kokawuka, ekonda mpe ezika na mopepe ya este. ");
INSERT INTO lin_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Mito sambo ya ble oyo ekonda emelaki mito sambo ya ble oyo ya malamu. Nayebisaki yango epai ya bato ya soloka kasi ata moto moko te akokaki kolimbolela ngai yango. ");
INSERT INTO lin_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Jozefi alobaki na Faraon : — Ndoto ya Faraon ezali kaka ndoto moko mpe ezali kaka na ndimbola moko. Nzambe amonisaki Faraon makambo oyo Ye akosala. ");
INSERT INTO lin_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Bangombe sambo ya basi ya kitoko ezali mibu sambo, mpe mito sambo ya ble ezali mibu sambo : ezali kaka ndoto moko. ");
INSERT INTO lin_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Bangombe sambo ya basi ekonda mpe ya mabe oyo ebimaki sima na oyo ya mafuta mpe ya kitoko, ezali mibu sambo ; mpe mito sambo ya ble oyo ekonda mpe ezika na mopepe ya este ezali mibu sambo ya nzala makasi. ");
INSERT INTO lin_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Tala maloba oyo nazalaki na yango mpo na koyebisa Faraon. Nzambe atalisi na Faraon makambo oyo Ye akosala. ");
INSERT INTO lin_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Mibu sambo ya bofuluki ekoya na mokili mobimba ya Ejipito. ");
INSERT INTO lin_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Kasi mibu sambo ya nzala makasi ekolanda yango ; boye bakobosana bofuluki nyonso ya mokili ya Ejipito mpo ete nzala makasi yango ekokawusa mokili. ");
INSERT INTO lin_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Bakokanisa lisusu te bofuluki nyonso ya mokili likolo ya nzala makasi oyo ekolanda, pamba te nzala ekozala makasi penza. ");
INSERT INTO lin_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Soki Faraon alotaki ndoto yango na lolenge mibale, elingi koloba ete Nzambe asilaki kozwa mokano na likambo yango mpe akokokisa yango na lombangu. ");
INSERT INTO lin_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Tika sik’oyo Faraon aluka moto moko ya mayele mpe ya bwanya, atia ye na moto ya mokili ya Ejipito. ");
INSERT INTO lin_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Tika ete Faraon asala bongo ; tika ete apona basali na mokili, ba-oyo bakokongola eteni ya mitano ya bambuma ya Ejipito na tango ya mibu sambo ya bofuluki. ");
INSERT INTO lin_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Boye, na se ya bokonzi ya Faraon, bakobanda kosangisa biloko nyonso ya kolia oyo mibu ya malamu ekobimisa, bakobomba ble na bingumba mpe bakobatela yango lokola biloko ya kolia mpo na bingumba. ");
INSERT INTO lin_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Bakobatela biloko yango mpo na mokili, mpo na mibu sambo ya nzala makasi oyo ekozala na mokili ya Ejipito ; na bongo nzala makasi ekobebisa mokili te. ");
INSERT INTO lin_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Likambo yango esepelisaki Faraon mpe basali na ye nyonso. ");
INSERT INTO lin_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Faraon atunaki bango : — Tokoki komona moto lokola oyo, moto oyo Molimo na Nzambe avandi kati na ye ? ");
INSERT INTO lin_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Faraon alobaki na Jozefi : — Lokola Nzambe ayebisi yo makambo oyo nyonso, ezali na moto moko te oyo azali na mayele mpe na bwanya lokola yo. ");
INSERT INTO lin_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Okozala mokonzi ya ndako na ngai mpe bato na ngai nyonso bakobanda kotosa mitindo na yo. Kaka kiti ya bokonzi nde ekosala ete ngai nazala na likolo na yo. ");
INSERT INTO lin_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Faraon alobaki na Jozefi : — Natie yo mokonzi ya mokili mobimba ya Ejipito. ");
INSERT INTO lin_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Faraon alongolaki lopete na ye na mosapi na ye mpe atiaki yango na mosapi ya Jozefi. Alatisaki ye bilamba ya lino ya kitoko mpe atiaki ye singa ya wolo na kingo. ");
INSERT INTO lin_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Amatisaki ye na shareti na ye ya mibale mpe bato bazalaki koganga : « Bofukama ! » Boye, atiaki Jozefi mokonzi ya mokili mobimba ya Ejipito. ");
INSERT INTO lin_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Faraon alobaki lisusu na Jozefi : — Nazali Faraon. Kasi awa na Ejipito, moto moko te akotombola loboko to lokolo soki kaka na mitindo na yo te. ");
INSERT INTO lin_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Faraon apesaki Jozefi kombo « Tsafinati-Paenea, » mpe apesaki ye Asinati, mwana mwasi ya Poti-Fera, nganga-nzambe ya Oni, mpo ete azala mwasi na ye. Jozefi atambolaki na mokili ya Ejipito. ");
INSERT INTO lin_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Azalaki na mibu tuku misato ya mbotama tango akotaki na mosala ya Faraon, mokonzi ya Ejipito. Jozefi alongwaki na miso ya Faraon mpe atambolaki na mokili mobimba ya Ejipito. ");
INSERT INTO lin_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Na mibu sambo ya bofuluki, mabele ebotaki mingi. ");
INSERT INTO lin_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Jozefi asangisaki biloko nyonso ya kolia oyo ebotaki na mibu yango sambo ya bofuluki kati na Ejipito mpe abombaki yango kati na engumba. Na engumba moko na moko, atiaki biloko ya kolia oyo ewutaki na bilanga oyo ezalaki zingazinga na yango. ");
INSERT INTO lin_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Jozefi abombaki ble ebele lokola zelo ya ebale monene, ezalaki mingi koleka ; yango wana bakataki kotanga, pamba te bakokaki kotanga yango lisusu te. ");
INSERT INTO lin_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Liboso ete mibu ya nzala makasi eya, Asinati, mwana mwasi ya Poti-Fera, nganga-nzambe ya Oni, abotelaki Jozefi bana mibali mibale. ");
INSERT INTO lin_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Jozefi apesaki mwana na ye ya liboso kombo « Manase, » pamba te amilobelaki : « Nzambe asali ete nabosana pasi na ngai nyonso mpe bokabwani na ngai na libota mobimba ya tata na ngai. » ");
INSERT INTO lin_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Apesaki mwana na ye ya mibale kombo « Efrayimi, » pamba te amilobelaki : « Nzambe apesi ngai mabota na mokili epai wapi namonaki pasi. » ");
INSERT INTO lin_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Mibu sambo ya bofuluki oyo ezalaki na Ejipito ekomaki na suka, ");
INSERT INTO lin_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","mpe mibu sambo ya nzala makasi ebandaki, ndenge kaka Jozefi alobaki. Nzala makasi ekotaki na mikili nyonso, kasi na mokili mobimba ya Ejipito biloko ya kolia ezangaki te. ");
INSERT INTO lin_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Tango bato nyonso ya Ejipito bakomaki na nzala makasi, bagangaki epai ya Faraon mpo na koluka biloko ya kolia. Bongo Faraon alobaki na bato nyonso ya Ejipito : « Bokende epai ya Jozefi mpe bosala makambo oyo akoyebisa bino. » ");
INSERT INTO lin_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Tango nzala ekotaki na mokili mobimba ya Ejipito, Jozefi afungolaki ndako oyo batiaki biloko mpe atekaki ble epai ya bato ya Ejipito ; kasi nzala makasi ekobaki kaka. ");
INSERT INTO lin_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Mikili nyonso ezalaki koya na Ejipito mpo na kosomba ble epai ya Jozefi mpo ete nzala makasi ekotaki na mokili mobimba. ");
INSERT INTO lin_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Tango Jakobi ayokaki ete ble ezali na Ejipito, alobaki na bana na ye ya mibali : « Mpo na nini bozali kotalana bino na bino ? ");
INSERT INTO lin_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Nayoki ete ble ezali na Ejipito. Bokende kuna mpe bosomba ndambo mpo na biso mpo ete towumela na bomoi mpe tokufa te na nzala. » ");
INSERT INTO lin_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Bandeko mibali zomi ya Jozefi bakendeki na Ejipito mpo na kosomba ble. ");
INSERT INTO lin_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Kasi Jakobi atikaki te Benjame, ndeko ya Jozefi ya mobali, ete akende elongo na bango, pamba te azalaki kobanga ete likama ekweyela ye. ");
INSERT INTO lin_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Kati na bato oyo bakendeki kosomba ble na Ejipito, bana mibali ya Isalaele mpe bazalaki ; pamba te nzala makasi ekotaki mpe na mokili ya Kanana. ");
INSERT INTO lin_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Jozefi azalaki moyangeli ya mokili. Ye nde azalaki koteka ble epai ya bato na ye nyonso. Bongo tango bandeko ya Jozefi bakomaki, bagumbamaki liboso na ye mpe bakitisaki mito na se. ");
INSERT INTO lin_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Tango kaka Jozefi amonaki bango, asosolaki mbala moko ete bazali bandeko na ye. Kasi asalaki lokola nde azali mopaya liboso na bango mpe azalaki na maloba makasi epai na bango. Atunaki bango : — Bowuti wapi ? Bazongisaki : — Towuti na mokili ya Kanana ; toyei nde kosomba biloko ya kolia. ");
INSERT INTO lin_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Atako Jozefi asosolaki ete bazali bandeko na ye, kasi bango basosolaki ye te. ");
INSERT INTO lin_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Bongo Jozefi akanisaki ndoto oyo alotaki na tina na bango mpe alobaki na bango : — Bino bozali penza banongi ! Boyei nde kotala bisika nini mokili na biso ebatelami malamu te ! ");
INSERT INTO lin_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Bazongisaki : — Te nkolo na ngai, basali na yo bayei nde kosomba biloko ya kolia. ");
INSERT INTO lin_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Tozali biso nyonso bana ya moto moko. Basali na yo bazali bato ya sembo, kasi bazali banongi te. ");
INSERT INTO lin_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Alobaki na bango : — Te ! Boyei na mokili na biso mpo na kotala bisika oyo ebatelami malamu te ! ");
INSERT INTO lin_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Kasi bango bazongisaki : — Basali na yo bazalaki bandeko mibali zomi na mibale ; tozali bana ya moto moko oyo azali kovanda na mokili ya Kanana. Mwana ya suka azali sik’oyo elongo na tata na biso, mpe mosusu azalaka lisusu te. ");
INSERT INTO lin_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Kasi Jozefi alobaki na bango : — Ezali ndenge kaka nalobaki na bino : bozali banongi. ");
INSERT INTO lin_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Tala ndenge nakomeka bino : Na kombo ya Faraon, bokolongwa na esika oyo te soki leki na bino ya suka akomi awa te ! ");
INSERT INTO lin_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Botinda moko kati na bino ete akende kozwa ndeko na bino ya mobali ; mpe bino oyo bokotikala, bokozala na boloko mpo na komeka maloba na bino mpe kotala soki bolobi solo. Soki te, na kombo ya Faraon, bozali banongi ! ");
INSERT INTO lin_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Atiaki bango nyonso na boloko mikolo misato. ");
INSERT INTO lin_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Na mokolo ya misato, Jozefi ayebisaki bango : — Nazali moto oyo abangaka Nzambe. Bosala oyo nazali koloba mpe bokozala na bomoi. ");
INSERT INTO lin_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Soki bozali bato ya sembo, tika ete moko kati na bino atikala awa kati na boloko ; bongo bino bamosusu bokende, bomema ble oyo esengeli mpo na mabota na bino, oyo ezali na nzala makasi. ");
INSERT INTO lin_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Kasi bomemela ngai leki na bino ya suka. Yango ekolakisa ete bolobaki solo mpe bokokufa te. Basalaki bongo. ");
INSERT INTO lin_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Balobanaki bango na bango : — Solo, tozwi etumbu mpo na makambo oyo tosalaki ndeko na biso ; pamba te tomonaki pasi na ye tango azalaki kobondela biso, kasi toyokaki ye te. Yango wana pasi oyo ekomeli biso. ");
INSERT INTO lin_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ribeni alobaki na bango : — Nayebisaki bino ete bosala mwana wana mabe te ? Kasi boyokelaki ngai te. Sik’oyo tosengeli kofuta makila na ye ! ");
INSERT INTO lin_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Bayebaki te ete Jozefi akokaki kososola maloba na bango, mpo ete azalaki kosalela molimboli mpo na kosolola na bango. ");
INSERT INTO lin_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Jozefi apesaki mokongo, apusanaki mosika mpe abandaki kolela. Bongo azongelaki bango mpe asololaki lisusu na bango. Azwaki Simeoni kati na bango mpe akangaki ye na miso na bango. ");
INSERT INTO lin_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Jozefi apesaki mitindo ete batondisa ble na basaki na bango, bazongisa mbongo ya moto na moto na saki na ye mpe bapesa bango bilei mpo na nzela. Esalemelaki bango bongo. ");
INSERT INTO lin_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Batiaki ble na bango likolo ya ba-ane na bango mpe bakendeki. ");
INSERT INTO lin_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Na esika oyo batelamaki mpo na kolekisa butu, moko na bango afungolaki saki na ye mpo na koleisa ane na ye mpe amonaki mbongo na ye na moto ya saki na ye. ");
INSERT INTO lin_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Ayebisaki bandeko na ye : — Bazongiseli ngai mbongo na ngai, tala yango oyo na saki na ngai ! Mitema na bango ebetaki mpe babandaki kolenga, balobanaki bango na bango : — Likambo nini oyo Nzambe asali biso ! ");
INSERT INTO lin_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Tango bakomaki epai ya tata na bango Jakobi na mokili ya Kanana, bayebisaki ye makambo nyonso oyo ekomelaki bango. Balobaki : ");
INSERT INTO lin_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","— Moto oyo azali mokonzi ya mokili alobelaki biso na maloba makasi. Azwaki biso lokola banongi. ");
INSERT INTO lin_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Kasi tolobaki na ye : « Tozali bato ya sembo, tozali banongi te. ");
INSERT INTO lin_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Tozalaki bandeko mibali zomi na mibale, bana ya tata moko. Moko azalaka lisusu te mpe oyo ya suka azali sik’oyo elongo na tata na biso, na mokili ya Kanana. » ");
INSERT INTO lin_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Na boye, moto oyo azali mokonzi ya mokili azongiselaki biso : « Tala lolenge nakoyeba ete bozali bato ya sembo : ‹ Botikela ngai awa ndeko moko kati na bino. Bozwa biloko ya kolia oyo esengeli mpo na mabota na bino oyo ezali na nzala makasi mpe bokende. ");
INSERT INTO lin_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Boyela ngai leki na bino ya suka. Na bongo, nakoyeba ete bozali banongi te, kasi bato ya sembo ; mpe ngai nakozongisela bino ndeko na bino, sima nakotika bino mpo ete bokoka kosala mombongo na mokili. › » ");
INSERT INTO lin_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Tango bafungolaki basaki na bango, moko na moko amonaki mbongo na ye na saki. Bango na tata na bango bamonaki mbongo mpe bango nyonso babangaki. ");
INSERT INTO lin_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Tata na bango Jakobi alobaki na bango : — Bozangisi ngai bana na ngai mibale ya mibali : Jozefi azali lisusu te, Simeoni mpe azali lisusu te. Mpe sik’oyo bolingi kozwa lisusu Benjame ! Makambo oyo nyonso ezali kokweyela kaka ngai ! ");
INSERT INTO lin_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ribeni alobaki na tata na ye : — Pesa ngai Benjame, mpe nakomemela yo ye. Soki namemeli yo ye te, boma bana na ngai mibale ya mibali. ");
INSERT INTO lin_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Jakobi azongisaki : — Te ! Mwana na ngai akokende elongo na bino te. Ndeko na ye ya mobali akufa ; natikala kaka na ye. Soki likama ekweyeli ye na mobembo oyo bozali kokende, wana bokoboma ngai na pasi, na kimobange na ngai ! ");
INSERT INTO lin_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Nzala makasi ekotaki kati na mokili. ");
INSERT INTO lin_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Tango libota ya Jakobi baliaki biloko nyonso oyo bamemaki wuta na Ejipito, Jakobi alobaki na bana na ye : — Bozonga kuna kosomba ndambo ya biloko. ");
INSERT INTO lin_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Yuda azongisaki : — Moto wana alobaki na biso ete tozonga kuna te soki ndeko na biso azali elongo na biso te. ");
INSERT INTO lin_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Soki otiki ndeko na biso kokende elongo na biso, wana tokokende na Ejipito mpe tokosombela yo biloko. ");
INSERT INTO lin_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Kasi soki otiki ye te, biso mpe tokokende te ; pamba te moto wana ayebisaki biso malamu : « Bokotelema liboso na ngai te soki ndeko na bino azali te. » ");
INSERT INTO lin_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Isalaele azongisaki : — Mpo na nini bosali ngai mabe boye ? Mpo na nini boyebisaki moto wana ete bozali na ndeko mosusu ? ");
INSERT INTO lin_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Bazongisaki : — Moto yango atunaki biso malamu makambo oyo etali biso moko mpe libota na biso. Atunaki biso : « Tata na bino azali nanu na bomoi ? Bozali na ndeko mosusu ya mobali ? » Mpe biso topesaki eyano na mituna na ye. Tokokaki te koyeba ete akoloba na biso : « Boya na ndeko na bino ya mobali awa. » ");
INSERT INTO lin_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Yuda ayebisaki tata na ye Isalaele : — Tata, tika Benjame akende elongo na ngai. Tokotelema mpe tokokende mpo ete biso elongo na yo mpe bana na biso, tozala na bomoi, kasi tokufa te na nzala. ");
INSERT INTO lin_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Nandimi kobatela ye ; boye okotuna ye na maboko na ngai. Soki nazongiseli yo ye te mpe namemi ye liboso na yo te, tika ete nazala na ngambo epai na yo bomoi na ngai mobimba. ");
INSERT INTO lin_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Soki towumelaki te, tokokaki kozonga mbala ya mibale. ");
INSERT INTO lin_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Tata na bango Isalaele alobaki na bango : — Soki esengeli kozala bongo, wana bosala boye : botia na basaki na bino biloko oyo eleki kitoko kati na mokili mpe bopesa yango lokola kado epai ya moto wana : ndambo ya mafuta ya solo kitoko, ndambo ya mafuta ya nzoyi, biloko ya mike-mike ya solo kitoko, lodanumi, pisitashi mpe bambuma ya amande. ");
INSERT INTO lin_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Bozwa mbala mibale motuya ya mbongo oyo ezalaki kati na basaki na bino mpe bozongisa mbongo oyo bokutaki na basaki na bino ; tango mosusu ezalaki libunga. ");
INSERT INTO lin_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Bozwa ndeko na bino ya mobali, botelema mpe bozonga epai ya moto wana. ");
INSERT INTO lin_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Tika ete Nzambe-Na-Nguya-Nyonso ayokela bino mawa tango bokotelema liboso ya moto wana, mpo ete bokoka kozwa ndeko na bino mosusu, mpe Benjame azonga elongo na bino. Kasi mpo na ngai, soki nakozanga bana, malamu nazanga bango ! ");
INSERT INTO lin_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Boye bato yango bazwaki bakado ; bazwaki lisusu mbala mibale motuya ya mbongo oyo ezalaki na basaki na bango mpe Benjame. Bakendeki na Ejipito mpe bamilakisaki na miso ya Jozefi. ");
INSERT INTO lin_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Tango Jozefi amonaki Benjame elongo na bango, alobaki na moto oyo azalaki na mokumba ya kobatela bozwi na ye : « Mema bato oyo na ndako na ngai ; boboma nyama moko mpe bolamba yango mpo ete bato oyo bakolia elongo na ngai na midi. » ");
INSERT INTO lin_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Moto yango asalaki ndenge kaka Jozefi alobaki na ye mpe amemaki bango na ndako ya Jozefi. ");
INSERT INTO lin_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Bato yango babangaki makasi tango bamemaki bango na ndako ya Jozefi mpe bazalaki kolobana bango na bango : — Bamemi biso awa likolo ya mbongo oyo batiaki na basaki na biso, na mbala ya liboso. Bakokweya likolo na biso, bakolonga biso, bakokanga biso lokola bawumbu mpe bakozwa ba-ane na biso. ");
INSERT INTO lin_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Bapusanaki pembeni ya moto oyo azalaki na mokumba ya kobatela bozwi ya ndako ya Jozefi mpe balobaki na ye na ekuke ya ndako : ");
INSERT INTO lin_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","— Limbisa biso, nkolo na ngai ! Toyaki mbala ya liboso mpo na kosomba biloko ya kolia ; ");
INSERT INTO lin_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","kasi tango totelemaki na esika ya kolekisa butu, tofungolaki basaki na biso ; mpe moko na moko kati na biso amonaki mbongo na ye kati na saki na ye ndenge kaka ezalaki, yango wana tozongi na yango. ");
INSERT INTO lin_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Tomemi mbongo mosusu mpo na kosomba biloko ya kolia, toyebi te nani azongisaki mbongo na biso na basaki na biso. ");
INSERT INTO lin_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Alobaki na bango : — Malamu ! Bobanga te. Ezali Nzambe na bino, Nzambe ya tata na bino, nde atiaki bomengo kati na basaki na bino. Kasi mpo na mbongo na bino, ngai nazwaki yango. Sima, amemelaki bango Simeoni. ");
INSERT INTO lin_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Moto yango akotisaki bango na ndako ya Jozefi, apesaki bango mayi ya kosukola makolo mpe abongisaki bilei mpo na ba-ane na bango. ");
INSERT INTO lin_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Babongisaki bakado na bango mpo na boyei ya Jozefi na midi, pamba te bayokaki ete bakolia kuna. ");
INSERT INTO lin_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Tango Jozefi ayaki na ndako, bapesaki ye bakado oyo bamemaki na ndako mpe bagumbamaki liboso na ye mito na se. ");
INSERT INTO lin_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Atunaki bango : — Boni, bozali malamu ? Abakisaki : — Boni tata na bino ya mobange oyo boyebisaki ngai, azali malamu ? ");
INSERT INTO lin_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Bazongisaki : — Mosali na yo, tata na biso, azali nanu na bomoi mpe azali malamu. Bakitisaki mito mpe bagumbamaki liboso na ye. ");
INSERT INTO lin_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Tango Jozefi atombolaki miso, amonaki Benjame, ndeko na ye ya mobali, mwana ya mama na ye. Atunaki : — Ye wana nde ndeko na bino ya suka oyo boyebisaki ngai ? Abakisaki : — Tika ete Nzambe atalisa yo ngolu na Ye. ");
INSERT INTO lin_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Jozefi ayokaki pasi makasi na motema tango amonaki ndeko na ye, akimaki mbangu na libanda mpe alukaki esika mpo na kolela. Akotaki na shambre na ye mpe alelaki kuna. ");
INSERT INTO lin_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Tango asilisaki kosukola elongi na ye, abimaki libanda, akangaki motema mpe alobaki : — Botia biloko ya kolia na mesa. ");
INSERT INTO lin_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Batielaki Jozefi bilei na mesa na ye moko, bandeko na ye mpe na mesa na bango ; bongo bato ya Ejipito oyo bazalaki kolia na ye esika moko, bango mpe na mesa na bango, pamba te bato ya Ejipito bakokaki te kolia esika moko na Ba-Ebre, pamba te ezalaki ekila mpo na bato ya Ejipito. ");
INSERT INTO lin_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Bavandisaki bango, kobanda na mwana ya liboso kino na oyo ya suka, bazalaki kotalana bango na bango na kokamwa. ");
INSERT INTO lin_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Jozefi apesaki bango biloko oyo ewutaki na mesa na ye ; mpe Benjame azwaki mbala mitano koleka bango nyonso. Na bongo, bamelaki elongo na ye mpe balangwaki. ");
INSERT INTO lin_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Jozefi apesaki mitindo epai ya moto oyo azalaki na mokumba ya kobatela bozwi ya ndako na ye : « Tondisa biloko ya kolia na basaki ya bato oyo kolanda kilo oyo bakoki komema mpe tia mbongo ya moko na moko na moto ya saki na ye. ");
INSERT INTO lin_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Okotia kopo na ngai oyo ya palata na moto ya saki ya leki na bango ya suka elongo na mbongo na ye ya ble. » Moto yango asalaki ndenge kaka Jozefi alobaki na ye. ");
INSERT INTO lin_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Na tongo-tongo, batikaki bandeko ya Jozefi kozonga elongo na ba-ane na bango. ");
INSERT INTO lin_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Wana babimaki na engumba, bamikomelaki nanu mosika te, Jozefi alobaki na moto oyo azalaki na mokumba ya kobatela bozwi ya ndako na ye : « Telema, landa bato wana ! Mpe tango okokanga bango, tuna bango : mpo na nini bozongisi mabe na malamu ? ");
INSERT INTO lin_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Mpo na nini boyibi kopo oyo nkolo na ngai amelelaka mayi mpe asalelaka mpo na koyeba makambo oyo ekoya ? Likambo oyo bosali ezali penza mabe. » ");
INSERT INTO lin_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Mokambi ya ndako ya Jozefi akangaki bango mpe alobelaki bango lolenge nkolo na ye atindaki ye. ");
INSERT INTO lin_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Kasi bazongiselaki ye : — Mpo na nini nkolo na biso alobi makambo ya boye ? Basali na yo bakoki kosala makambo ya boye te. ");
INSERT INTO lin_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Tomemelaki yo mbongo oyo tomonaki tango tofungolaki basaki na biso wuta na mokili ya Kanana. Ndenge nini tokoki lisusu koyiba wolo to palata kati na ndako ya nkolo na yo ? ");
INSERT INTO lin_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Soki moko kati na basali na yo amonani ete azali na yango, akokufa ; mpe biso bamosusu oyo totikali, tokokoma bawumbu ya nkolo na biso. ");
INSERT INTO lin_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Moto oyo azalaki na mokumba ya kobatela bozwi ya ndako ya Jozefi alobaki : — Malamu mingi ! Tika ete ezala ndenge bolobi ! Moto oyo akomonana ete azali na yango, akokoma mowumbu na ngai. Bino ba-oyo botikali, bokozala na likambo te. ");
INSERT INTO lin_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Moko na moko akitisaki saki na ye na lombangu na mabele mpe afungolaki yango. ");
INSERT INTO lin_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Moto oyo azalaki na mokumba ya kobatela bozwi ya Jozefi abandaki koluka kobanda na kulutu kino na leki. Mpe kopo emonanaki na saki ya Benjame. ");
INSERT INTO lin_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Tango bamonaki bongo, bapasolaki bilamba na bango ; bazongisaki biloko na ba-ane na bango mpe bazongaki bango nyonso na engumba. ");
INSERT INTO lin_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Jozefi azalaki kaka na ndako. Tango Yuda na bandeko na ye ya mibali bakotaki na ndako, bagumbamaki kino na se liboso na ye. ");
INSERT INTO lin_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Jozefi alobaki na bango : — Likambo nini oyo bosali ? Boyebi te ete moto lokola ngai nazali na makoki ya komona makambo na bosoloka ? ");
INSERT INTO lin_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yuda azongisaki : — Likambo nini tokoki koloba na nkolo na ngai ? Tokoloba lisusu nini ? Ndenge nini tokoki kotalisa ete toyebi likambo te ? Nzambe alakisi polele mbeba ya basali na yo. Tokomi sik’oyo bawumbu ya nkolo na ngai, biso nyonso elongo na ye oyo amonani ete azalaki na kopo kati na saki na ye. ");
INSERT INTO lin_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Kasi Jozefi alobaki : — Nakoki kosala likambo ya boye te ! Kaka moto oyo amonani ete azalaki na kopo kati na saki na ye nde akozala mowumbu na ngai. Bino ba-oyo botikali, bozonga na kimia epai ya tata na bino. ");
INSERT INTO lin_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Yuda apusanaki pembeni na ye mpe alobaki : — Nabondeli yo, nkolo na ngai ! Tika ete mosali na yo aloba liloba moko epai ya nkolo na ngai. Kosilikela mosali na yo te, pamba te ndenge Faraon azali, ndenge wana mpe yo ozali. ");
INSERT INTO lin_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Nkolo na ngai atunaki basali na ye : « Bozali na tata to na ndeko mosusu ya mobali ? » ");
INSERT INTO lin_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Tozongiselaki nkolo na ngai : « Tozali na tata oyo akomi mobange mpe ndeko mobali ya leki oyo babotelaki tata na biso na kimobange. Ndeko na ye ya mobali akufa mpe atikala kaka ye moko mwana mobali na libumu ya mama na ye, mpe tata na ye alingaka ye mingi. » ");
INSERT INTO lin_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Bongo olobaki na basali na yo : « Bomemela ngai ye mpo ete nakoka komona ye na miso na ngai. » ");
INSERT INTO lin_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Tozongiselaki nkolo na ngai : « Elenge mobali akoki kotika tata na ye te ; soki atiki ye, tata na ye akokufa. » ");
INSERT INTO lin_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Kasi olobaki na basali na yo : « Soki leki na bino ya mobali ayei elongo na bino te, bokomona lisusu elongi na ngai te. » ");
INSERT INTO lin_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Tango tozongaki epai ya mosali na yo, tata na ngai, toyebisaki ye makambo nyonso oyo nkolo na ngai alobaki. ");
INSERT INTO lin_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Bongo tata na biso alobaki : « Bozonga mpe bosomba ndambo ya biloko ya kolia. » ");
INSERT INTO lin_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Kasi tozongisaki : « Tokoki kokende te. Tokokende kaka soki leki na biso ya mobali azali elongo na biso. Tokoki komona elongi ya moto wana te soki leki na biso ya mobali azali elongo na biso te. » ");
INSERT INTO lin_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Mosali na yo, tata na biso, alobaki na biso : « Boyebi ete mwasi na ngai, Rasheli, abotelaki ngai bana mibale ya mibali. ");
INSERT INTO lin_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Moko na bango akenda mosika na ngai. Nakanisi ete ezali ya solo, nyama moko ya mabe esila kolia ye. Banda tango wana, natikala komona ye lisusu te. ");
INSERT INTO lin_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Soki bozwi ngai lisusu mwana oyo mpe soki likama ekweyeli ye, bokoboma ngai na pasi, na kimobange na ngai. » ");
INSERT INTO lin_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Sik’oyo, soki elenge mobali azali elongo na biso te tango nakozonga epai ya tata na ngai, mosali na yo, mpe soki tata na ngai, oyo motema na ye ekangama makasi na motema ya elenge mobali oyo, ");
INSERT INTO lin_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","amoni ete elenge mobali azali elongo na biso te, wana akokufa. Basali na yo bakoboma tata na biso na pasi na kimobange na ye. ");
INSERT INTO lin_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Pamba te ngai mosali na yo, nandimaki, na miso ya tata na ngai, kobatela elenge mobali oyo. Nalobaki : « Soki nazongiseli yo ye te, nakozala na ngambo liboso na yo tata na ngai, bomoi na ngai mobimba. » ");
INSERT INTO lin_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Yango wana sik’oyo, nabondeli yo, tika ete mosali na yo akoma mowumbu ya nkolo na ngai na esika ya elenge mobali oyo mpe tika ete elenge mobali azonga elongo na bandeko na ye ya mibali. ");
INSERT INTO lin_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Ndenge nini nakoki kozonga epai ya tata na ngai soki elenge mobali azali elongo na ngai te ? Kotika te ete namona pasi oyo ekokomela tata na ngai ! ");
INSERT INTO lin_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Jozefi akokaki lisusu komikanga te liboso ya bato nyonso oyo bazalaki liboso na ye, agangaki : « Bobimisa bato nyonso ! » Boye, moto moko te azalaki pembeni na ye tango amimonisaki epai ya bandeko na ye ya mibali. ");
INSERT INTO lin_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Lokola alelaki na mongongo makasi, bato ya Ejipito bayokaki ye ; mpe sango ekendeki kino na ndako ya Faraon. ");
INSERT INTO lin_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Jozefi alobaki na bandeko na ye ya mibali : — Nazali Jozefi ! Tata na ngai azali nanu na bomoi ? Kasi bandeko na ye bakokaki koyanola ye te, pamba te bazalaki kolenga liboso na ye. ");
INSERT INTO lin_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Jozefi alobaki na bango : — Bopusana pembeni na ngai ! Tango bapusanaki, alobaki : — Nazali Jozefi, ndeko na bino ya mobali oyo botekaki mpo ete bamema ngai na Ejipito. ");
INSERT INTO lin_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Kasi sik’oyo, bomitungisa te mpe bozala na mawa te na ndenge botekaki ngai awa. Ezali mpo na kobikisa bomoi na bino nde Nzambe atindaki ngai liboso na bino. ");
INSERT INTO lin_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Oyo ezali mobu ya mibale wuta nzala makasi ekotaki na mokili ; mpe na mibu mitano oyo ezali koya, bakolona te mpe bakobuka te. ");
INSERT INTO lin_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Kasi Nzambe atindaki ngai liboso na bino mpo ete bowumela na mokili mpe bobikisa bomoi na bino na nzela ya kokangolama monene. ");
INSERT INTO lin_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Ezali bino te bato botindaki ngai awa, kasi ezali nde Nzambe. Akomisaki ngai tata ya Faraon, nkolo ya ndako na ye mpe moyangeli ya mokili mobimba ya Ejipito. ");
INSERT INTO lin_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Bozonga noki epai ya tata na ngai mpe boloba na ye : « Mwana na yo, Jozefi, alobi : ‹ Nzambe akomisa ngai nkolo ya Ejipito mobimba ; yaka epai na ngai, kowumela te. ");
INSERT INTO lin_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Okovanda na etuka ya Gosheni mpe okozala pembeni na ngai : yo, bana na yo mpe bakitani na yo, bameme na yo, bantaba na yo, bangombe na yo mpe biloko nyonso oyo ozali na yango. ");
INSERT INTO lin_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Kuna, nakokokisa baposa na yo nyonso, pamba te mibu mitano ya nzala makasi ezali koya ; soki te, yo elongo na bana na yo mpe bibwele na yo nyonso, bokokoma na pasi. ");
INSERT INTO lin_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Bino moko bozali komona ! Ndeko na ngai, Benjame, akoki mpe komona yango, ete ezali ngai moto nazali koloba na bino. ");
INSERT INTO lin_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Boyebisa tata na ngai lokumu nyonso oyo nazali na yango awa na Ejipito, boyebisa ye makambo nyonso oyo bosili komona mpe bomemela ngai ye awa na lombangu. › » ");
INSERT INTO lin_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Sima, amibwakaki na kingo ya ndeko na ye Benjame mpe alelaki ; Benjame mpe akangaki ye na kingo, bongo alelaki. ");
INSERT INTO lin_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Apesaki bandeko na ye nyonso beze mpe alelaki. Sima na yango, basololaki. ");
INSERT INTO lin_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Tango sango ekomaki na ndako ya Faraon ete bandeko ya Jozefi bayei, Faraon elongo na bakambi na ye nyonso basepelaki. ");
INSERT INTO lin_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Faraon alobaki na Jozefi : — Yebisa bandeko na yo : « Botia biloko likolo ya banyama na bino mpe bozonga na mokili ya Kanana. ");
INSERT INTO lin_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Boyela ngai tata na bino mpe mabota na bino ; nakopesa bino mabele oyo eleki kitoko kati na Ejipito mpe bokolia biloko na yango oyo eleki kitoko. » ");
INSERT INTO lin_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Okoyebisa bango lisusu : « Bozwa ndambo ya bashario ya Ejipito mpo na bana mpe basi na bino ; bongo bozwa tata na bino mpe bozonga awa. ");
INSERT INTO lin_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Boyoka mawa te mpo na oyo bokotika na Kanana, pamba te biloko nyonso ya kitoko oyo ezali na Ejipito ekozala mpo na bino. » ");
INSERT INTO lin_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Bana ya Isalaele basalaki makambo oyo bayebisaki bango. Jozefi apesaki bango bashario ndenge Faraon apesaki mitindo mpe apesaki bango bilei mosusu mpo na mobembo na bango. ");
INSERT INTO lin_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Jozefi apesaki epai ya moko na moko kati na bango bilamba ya sika ; apesaki Benjame mbongo ya bibende, nkama misato, elongo na bilamba ya sika. ");
INSERT INTO lin_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Atindelaki tata na ye biloko oyo : ba-ane zomi etonda na bilamba ya kitoko ya Ejipito mpe bampunda zomi ya basi etonda na ble, mapa mpe bilei mpo na mobembo na ye. ");
INSERT INTO lin_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Jozefi atikaki bandeko na ye kokende. Tango bazali kolongwa, alobaki na bango : — Boswana te na nzela. ");
INSERT INTO lin_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Balongwaki na Ejipito mpe bakendeki epai ya tata na bango Jakobi, na mokili ya Kanana. ");
INSERT INTO lin_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Balobaki na ye : — Jozefi azali nanu na bomoi. Ye nde moto azali koyangela Ejipito mobimba. Jakobi ayokaki nzoto malili mpe andimelaki bango te. ");
INSERT INTO lin_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Kasi tango bayebisaki ye makambo nyonso oyo Jozefi alobaki mpo na bango mpe tango amonaki bashario oyo Jozefi atindaki mpo na komema ye na Ejipito, molimo ya tata na bango Jakobi ezongaki. ");
INSERT INTO lin_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Mpe Isalaele alobaki : — Ya solo, nandimi ete mwana na ngai Jozefi azali nanu na bomoi ; nakokende mpe nakomona ye liboso ete nakufa. ");
INSERT INTO lin_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Isalaele akendeki na nyonso oyo azalaki na yango. Tango akomaki na Beri-Sheba, abonzaki mbeka epai ya Nzambe ya Izaki, tata na ye. ");
INSERT INTO lin_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Na butu, Nzambe alobaki na Isalaele na nzela ya emoniseli : — Jakobi ! Jakobi ! Jakobi azongisaki : — Ngai oyo. ");
INSERT INTO lin_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Nzambe alobaki : — Nazali Nzambe, Nzambe ya tata na yo. Kobanga te kokende na Ejipito, pamba te nakokomisa yo ekolo monene kuna. ");
INSERT INTO lin_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ngai moko nakokende elongo na yo na Ejipito ; mpe ya solo, nakozongisa yo lisusu. Loboko ya Jozefi ekozipa miso na yo. ");
INSERT INTO lin_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Bongo Jakobi alongwaki na Beri-Sheba. Bana mibali ya Isalaele bamatisaki na bashario oyo Faraon atindaki mpo na komema ye : tata na bango Jakobi, bana na bango mpe basi na bango. ");
INSERT INTO lin_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Bamemaki lisusu bibwele na bango mpe biloko nyonso oyo bazalaki na yango na mokili ya Kanana ; mpe Jakobi elongo na bakitani na ye nyonso bakendeki na Ejipito. ");
INSERT INTO lin_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Azwaki elongo na ye mpo na kokende na Ejipito : bana na ye ya mibali, bakoko na ye ya mibali mpe bana na ye ya basi elongo na bakoko na ye ya basi : bakitani na ye nyonso. ");
INSERT INTO lin_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Tala bakombo ya bana mibali ya Isalaele, oyo bakendeki na Ejipito : Ribeni, mwana liboso ya Jakobi. ");
INSERT INTO lin_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Bana mibali ya Ribeni : Enoki, Palu, Etsironi mpe Karimi. ");
INSERT INTO lin_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Bana mibali ya Simeoni : Yemuweli, Yamini, Owadi, Yakini, Tsoari mpe Saulo, mwana mobali oyo babotelaki ye na mwasi ya mokili ya Kanana. ");
INSERT INTO lin_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Bana mibali ya Levi : Gerishoni, Keati mpe Merari. ");
INSERT INTO lin_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Bana mibali ya Yuda : Eri, Onani, Shela, Peretisi mpe Zera. Kasi Eri mpe Onani bakufaki na mokili ya Kanana. Bana mibali ya Peretsi : Etsironi mpe Amuli. ");
INSERT INTO lin_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Bana mibali ya Isakari : Tola, Puwa, Yashubi mpe Shimironi. ");
INSERT INTO lin_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Bana mibali ya Zabuloni : Seredi, Eloni mpe Yaleyeli. ");
INSERT INTO lin_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Bango nde bazalaki bana mibali oyo Lea abotelaki Jakobi kati na Padani-Arami ; bakisa Dina, mwana mwasi. Bana na ye nyonso ya basi mpe ya mibali bazalaki tuku misato na misato. ");
INSERT INTO lin_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Bana mibali ya Gadi : Tsefoni, Agi, Shuni, Etsiboni, Eri, Arodi mpe Areeli. ");
INSERT INTO lin_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Bana mibali ya Aseri : Yimina, Yishiva, Yishivi, Beria mpe ndeko na bango ya mwasi Sera. Bana mibali ya Beria : Eberi mpe Malikieli. ");
INSERT INTO lin_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Bango nde bazalaki bana mibali oyo Zilipa abotelaki Jakobi ; Zilipa azalaki mwasi mosali oyo Labani apesaki epai ya Lea, mwana na ye ya mwasi. Bana na ye nyonso ya basi mpe ya mibali bazalaki zomi na motoba. ");
INSERT INTO lin_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Bana mibali ya Rasheli, mwasi ya Jakobi : Jozefi mpe Benjame. ");
INSERT INTO lin_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Kati na mokili ya Ejipito, Asinati, mwana mwasi ya Poti-Fera, nganga-nzambe ya engumba Oni, abotelaki Jozefi bana mibali mibale : Manase mpe Efrayimi. ");
INSERT INTO lin_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Bana mibali ya Benjame : Bela, Bekeri, Ashibeli, Gera, Namani, Eyi, Roshi, Mupimi, Upime mpe Aridi. ");
INSERT INTO lin_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Bango nde bazalaki bana mibali oyo Rasheli abotelaki Jakobi : bango nyonso bazalaki zomi na minei. ");
INSERT INTO lin_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Mwana mobali ya Dani : Ushimi. ");
INSERT INTO lin_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Bana mibali ya Nefitali : Yatseyeli, Guni, Yetseri mpe Shilemi. ");
INSERT INTO lin_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Bango nde bazalaki bana mibali oyo Bila abotelaki Jakobi ; bango nyonso bazalaki sambo. Bila azalaki mwasi mosali oyo Labani apesaki epai ya mwana na ye ya mwasi Rasheli. ");
INSERT INTO lin_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Bato nyonso oyo bakendeki na Ejipito elongo na Jakobi, oyo bazalaki penza bakitani na ye, longola basi ya bana na ye, bango nyonso bazalaki tuku motoba na motoba. ");
INSERT INTO lin_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Bana mibali ya Jozefi oyo babotamaki na Ejipito bazalaki mibale. Bato nyonso ya libota ya Jakobi oyo bakendeki na Ejipito bazalaki tuku sambo. ");
INSERT INTO lin_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Liboso ete Jakobi akutana na Jozefi, atindaki Yuda epai ya Jozefi mpo na kobongisa bokutani na bango na Gosheni. Tango bakomaki na Gosheni, ");
INSERT INTO lin_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Jozefi abongisaki Shario na ye mpe akendeki kokutana na Isalaele, tata na ye, na Gosheni. Tango kaka akomaki liboso na ye, ayambaki tata na ye mpe alelaki mingi. ");
INSERT INTO lin_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Isalaele alobaki na Jozefi : — Sik’oyo, nakoki na ngai kokufa mpo ete namoni yo penza na miso na ngai moko, mpe ozali nanu na bomoi ! ");
INSERT INTO lin_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Jozefi alobaki na bandeko na ye mpe na libota ya tata na ye : — Nakokende koyebisa Faraon : « Bandeko na ngai mpe libota ya tata na ngai, ba-oyo bavandaka na mokili ya Kanana, bayei epai na ngai. ");
INSERT INTO lin_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Bazali babateli bibwele, babokolaka bibwele. Bamemi bameme, bantaba, bangombe na bango mpe biloko nyonso oyo bazalaki na yango. » ");
INSERT INTO lin_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Tango Faraon akobenga bino mpe akotuna bino : « Bosalaka mosala nini ? » ");
INSERT INTO lin_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Bokozongisa : « Basali na yo babokolaka bibwele wuta bomwana na biso kino sik’oyo ndenge bakoko na biso bazalaki kosala. » Soki kaka bolobi bongo, akopesa bino nzela ya kovanda na Gosheni, pamba te bato ya Ejipito balingaka te babateli nyonso ya bibwele. ");
INSERT INTO lin_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Jozefi akendeki mpe alobaki na Faraon : — Tata na ngai elongo na bandeko na ngai bayei wuta na mokili ya Kanana na bameme, bantaba, bangombe mpe biloko na bango nyonso ; bazali sik’oyo na Gosheni. ");
INSERT INTO lin_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Jozefi aponaki bandeko na ye mitano mpe alakisaki bango epai ya Faraon. ");
INSERT INTO lin_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Faraon atunaki bandeko ya Jozefi : — Bosalaka mosala nini ? Bazongiselaki Faraon : — Basali na yo bazali babateli bibwele ndenge kaka bakoko na biso bazalaki. ");
INSERT INTO lin_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Balobaki lisusu na Faraon : — Toyei kovanda awa, pamba te nzala makasi ezali kati na mokili ya Kanana mpe matiti ezali lisusu te mpo na bibwele ya basali na yo ; yango wana, tobondeli yo, pesa basali na yo nzela ya kovanda na Gosheni. ");
INSERT INTO lin_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Faraon alobaki na Jozefi : — Tata na yo mpe bandeko na yo bayei epai na yo ; ");
INSERT INTO lin_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","mokili ya Ejipito mpe ezali na maboko na yo. Vandisa tata na yo mpe bandeko na yo na eteni ya mabele oyo eleki kitoko ; tika ete bavanda na Gosheni. Mpe soki oyebi kati na bango bato ya mayele, pesa bango mokumba ya kobatela bibwele na ngai. ");
INSERT INTO lin_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Jozefi amemaki tata na ye mpo na kolakisa ye epai ya Faraon. Tango Jakobi asilisaki kopambola Faraon, ");
INSERT INTO lin_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Faraon atunaki Jakobi : — Ozali na mibu boni ? ");
INSERT INTO lin_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Jakobi azongiselaki Faraon : — Nazali na mibu nkama moko na tuku misato ya mbotama. Mikolo ya bomoi na ngai ezali moke mpe ya pasi, ekokokana te na mikolo ya bomoi ya bakoko na ngai. ");
INSERT INTO lin_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Jakobi apambolaki Faraon mpe alongwaki liboso na ye. ");
INSERT INTO lin_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Jozefi avandisaki tata na ye mpe bandeko na ye na Ejipito mpe apesaki bango eteni ya mabele oyo eleki kitoko kati na mokili, na mabele ya Ramisesi, ndenge kaka Faraon atindaki. ");
INSERT INTO lin_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Jozefi apesaki lisusu biloko ya kolia epai ya tata na ye, bandeko na ye mpe epai ya libota ya tata na ye mobimba kolanda motango ya bana na bango. ");
INSERT INTO lin_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Biloko ya kolia ezalaki lisusu te kati na mokili mobimba mpe nzala makasi eyaki. Mokili ya Ejipito mpe oyo ya Kanana ekawukaki na nzala makasi. ");
INSERT INTO lin_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Jozefi azwaki mbongo nyonso oyo azalaki kobomba tango bato ya mokili ya Ejipito mpe ya Kanana bazalaki kosomba ble epai na ye, amemaki yango na ndako ya Faraon. ");
INSERT INTO lin_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Tango mbongo ya bato ya Ejipito mpe ya Kanana esilaki, bato nyonso ya Ejipito bayaki epai ya Jozefi mpe balobaki : — Pesa biso biloko ya kolia ! Mpo na nini tokufa na nzala na miso na yo ? Mpo ete mbongo na biso esili ? ");
INSERT INTO lin_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Jozefi azongisaki : — Soki bozali lisusu na mbongo te, bomemela ngai bibwele na bino. Bokopesa ngai bibwele na bino na esika ya mbongo. ");
INSERT INTO lin_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Bamemaki epai ya Jozefi bampunda, bantaba mpe bangombe na bango ; bongo Jozefi apesaki bango bilei na esika ya bampunda, ba-ane, bameme, bantaba mpe bangombe na bango. Na mibu nyonso wana oyo Jozefi azalaki kopesa bango bilei, bango bazalaki kopesa ye bibwele na bango. ");
INSERT INTO lin_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Tango mibu wana esilaki, bayaki lisusu epai na ye na mibu oyo elandaki. Balobaki : — Tokoki kobombela nkolo na biso te ete mbongo na biso esili mpe bibwele na biso ekomi ya yo. Totikali lisusu na eloko moko te longola kaka banzoto na biso mpe mabele na biso. ");
INSERT INTO lin_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Mpo na nini, biso elongo na mabele na biso, tokufa na miso na yo ? Somba biso kaka elongo na mabele na biso na motuya ya biloko ya kolia ; mpe biso elongo na mabele na biso, tokokoma bawumbu ya Faraon. Toboyi na biso kokufa na nzala, pesa biso milona ya kolona mpo ete tobika mpe mabele na biso ekoma esobe te. ");
INSERT INTO lin_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Jozefi asombaki mabele nyonso ya Ejipito mpo na Faraon, pamba te bato nyonso ya Ejipito batekaki bilanga na bango mpo ete nzala elekaki makasi. Boye mabele ekomaki ya Faraon. ");
INSERT INTO lin_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Jozefi akomisaki bavandi ya bingumba nyonso ya Ejipito bawumbu ya Faraon. ");
INSERT INTO lin_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Kasi asombaki mabele ya banganga-nzambe te, pamba te bazalaki kozwa tango nyonso biloko ebele kolanda mobeko ya Faraon ete bazwaka biloko ya kolia. Yango wana, banganga-nzambe batekaki mabele na bango te. ");
INSERT INTO lin_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Jozefi alobaki na bato : — Nasombi bino lelo mpo na Faraon, bino mpe mabele na bino. Tala milona mpo na bino mpo ete bokoka kolona mabele. ");
INSERT INTO lin_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Kasi tango bokobuka mbuma, bokopesa eteni ya mitano epai ya Faraon. Biteni minei oyo mosusu, bokobomba yango lokola milona mpo na bilanga mpe lokola biloko ya kolia mpo na bino moko, mpo na mabota na bino mpe mpo na bana na bino. ");
INSERT INTO lin_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Bazongisaki : — Obikisi bomoi na biso ! Lokola tozwi ngolu na miso na yo nkolo na biso, tokozala bawumbu ya Faraon. ");
INSERT INTO lin_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Bongo Jozefi akomisaki yango mobeko kino lelo kati na mabele ya Ejipito : eteni ya mitano ya bambuma nyonso oyo ekowuta na mabele ezali mpo na Faraon. Kasi mabele ya Banganga-Nzambe ekomaki ya Faraon te. ");
INSERT INTO lin_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Boye bana ya Isalaele bavandaki na Ejipito, na Gosheni. Kuna bakomaki na bozwi ebele, babotaki bana mpe bakomaki ebele. ");
INSERT INTO lin_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jakobi awumelaki mibu zomi na sambo na Ejipito. Mpe mibu ya bomoi na ye ezalaki nkama moko na tuku minei na sambo. ");
INSERT INTO lin_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Tango mokolo ya kufa ya Isalaele ekomaki pene, abengaki Jozefi, mwana na ye ya mobali, mpe alobaki na ye : — Soki nazwi ngolu na miso na yo, tia loboko na yo na se ya mopende na ngai ; laka ngai ete okotalisa ngai bolamu mpe boyengebene, mpe okokunda ngai na Ejipito te. ");
INSERT INTO lin_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Kasi tango nakolala elongo na bakoko na ngai, okobimisa ngai na Ejipito mpe okokunda ngai na esika oyo bakunda bango. Jozefi azongisaki : — Nakosala ndenge olobi. ");
INSERT INTO lin_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Bongo Jakobi alobaki lisusu : — Lapa ndayi mpo na kolakisa ete okosala ndenge olobi. Boye, Jozefi alapaki ndayi na miso na ye ; mpe Isalaele agumbamaki na koyekama na moto ya mbeto na ye. ");
INSERT INTO lin_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Sima na makambo wana, bayaki koyebisa Jozefi : « Tala, tata na yo azali kobela. » Jozefi azwaki bana na ye mibale ya mibali : Manase mpe Efrayimi. ");
INSERT INTO lin_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Bapesaki sango epai ya Jakobi ete mwana na ye ya mobali Jozefi azali koya epai na ye. Isalaele asalaki makasi mpe avandaki na mbeto. ");
INSERT INTO lin_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Jakobi alobaki na Jozefi : — Nzambe-Na-Nguya-Nyonso abimelaki ngai na Luze, na mokili ya Kanana ; mpe kuna, apambolaki ngai. ");
INSERT INTO lin_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Alobaki na ngai : « Nakopesa yo mabota mpe nakokomisa yo ebele ; nakokomisa yo lisanga ya bikolo ebele mpe nakopesa mokili oyo lokola libula ya seko na seko epai ya bakitani na yo sima na yo. » ");
INSERT INTO lin_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Mpe sik’oyo, bana na yo ya mibali oyo babotamaki na Ejipito liboso ete ngai naya awa, bakomi lokola bana na ngai. Efrayimi mpe Manase bakomi bana na ngai lokola Ribeni mpe Simeoni. ");
INSERT INTO lin_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Bana oyo okobota sima na bango bakozala ya yo ; bakozwa eteni na bango ya libula na kombo ya bayaya na bango. ");
INSERT INTO lin_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Pamba te, tango nawutaki na Padani, Rasheli akufaki na nzela, na maboko na ngai, wana nazalaki kokende na mokili ya Kanana, pene ya Efrata ; nakundaki ye kuna pembeni ya Efrata oyo babengaka Beteleemi. ");
INSERT INTO lin_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Tango Isalaele amonaki bana mibali ya Jozefi, atunaki : — Ba-oyo bazali banani ? ");
INSERT INTO lin_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Jozefi azongiselaki tata na ye : — Bazali bana mibali oyo Nzambe apesi ngai awa. Isalaele alobaki : — Pusa bango mpo ete napambola bango. ");
INSERT INTO lin_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Miso ya Isalaele elembaki mpo na kimobange mpe azalaki komona lisusu malamu te. Yango wana, Jozefi apusaki bana na ye ya mibali pembeni ya tata na ye, Isalaele apesaki bango beze mpe ayambaki bango. ");
INSERT INTO lin_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Isalaele alobaki na Jozefi : — Nazalaki na elikya te ete nakomona lisusu elongi na yo ; kasi sik’oyo Nzambe apesi ngai nzela ya komona kutu bana na yo. ");
INSERT INTO lin_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Jozefi alongolaki bana na ye na mabolongo ya Isalaele mpe agumbamaki elongi na ye kino na se. ");
INSERT INTO lin_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Jozefi azwaki bango mibale : Efrayimi na loboko na ye ya mobali, loboko ya mwasi ya Isalaele ; mpe Manase, na loboko na ye ya mwasi, loboko ya mobali ya tata na ye. Apusaki bango pembeni ya Isalaele. ");
INSERT INTO lin_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Isalaele asembolaki loboko na ye ya mobali mpe atiaki yango likolo ya moto ya Efrayimi oyo azalaki leki ; mpe loboko na ye ya mwasi likolo ya moto ya Manase. Na bongo, abongolaki maboko na ye mpo ete Manase azalaki mwana ya liboso. ");
INSERT INTO lin_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Isalaele apambolaki Jozefi mpe alobaki : Tika ete Nzambe oyo, liboso na Ye, bakoko na ngai, Abrayami mpe Izaki, batambolaki, Nzambe oyo azali Mobateli na ngai wuta mokolo ya mbotama na ngai kino na mokolo ya lelo, ");
INSERT INTO lin_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","anjelu oyo akangolaki ngai na mabe nyonso, apambola bana oyo ya mibali ! Tika ete babengama na kombo na ngai, mpe na bakombo ya bakoko na ngai, Abrayami mpe Izaki ! Tika ete bakoma ebele kati na mokili ! ");
INSERT INTO lin_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Tango Jozefi amonaki ete tata na ye atiaki loboko na ye ya mobali na moto ya Efrayimi, asepelaki te. Azwaki loboko ya tata na ye, alongolaki yango na moto ya Efrayimi mpo na kotia yango na moto ya Manase. ");
INSERT INTO lin_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Jozefi alobaki na tata na ye : — Boye te, tata na ngai ! Oyo azali mwana ya liboso ; tia loboko na yo ya mobali likolo ya moto na ye. ");
INSERT INTO lin_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Kasi tata na ye aboyaki mpe alobaki : — Nayebi, mwana na ngai ! Nayebi ! Ye mpe akokoma ekolo, akokoma monene. Nzokande, leki na ye akozala monene koleka ye mpe bakitani na ye bakokoma lisanga ya bikolo. ");
INSERT INTO lin_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Apambolaki bango wana mpe alobaki : Bato ya Isalaele bakotangaka bakombo na bino mpo na kopambola : « Tika ete Nzambe akomisa bino lokola Efrayimi mpe Manase ! » Boye Isalaele atiaki Efrayimi liboso ya Manase. ");
INSERT INTO lin_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Bongo Isalaele alobaki na Jozefi : — Etikali moke nakufa. Nzambe akozala na bino mpe akozongisa bino na mokili ya bakoko na bino. ");
INSERT INTO lin_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Mpo na ngai, napesi yo koleka oyo napesaki epai na bandeko na yo : eteni ya mabele oyo nabotolaki, na mopanga mpe na tolotolo na ngai, epai ya bato ya Amori. ");
INSERT INTO lin_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Jakobi abengaki bana na ye ya mibali mpe alobaki : — Bosangana mpo ete nakoka koyebisa bino makambo oyo ekokomela bino na mikolo oyo ekoya. ");
INSERT INTO lin_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Bosangana mpe boyoka, bana mibali ya Jakobi ! Boyoka oyo tata na bino Isalaele akoloba : ");
INSERT INTO lin_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","« Ribeni, ozali mwana na ngai ya liboso, makasi na ngai, elembo ya liboso ya makasi na ngai ; oleki na lokumu mpe na nguya. ");
INSERT INTO lin_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Mobulu lokola mayi, okokende liboso te, pamba te omataki na mbeto ya tata na yo, esika oyo ngai nalalaka, mpe okomisi yango mbindo. ");
INSERT INTO lin_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeoni mpe Levi bazali bandeko, mipanga na bango ezali bibundeli mpo na kotia mobulu. ");
INSERT INTO lin_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Molimo na ngai, kosangana te na mabongisi na bango ya kosala mabe ! Lokumu na ngai, kokota te na lisanga na bango ! Pamba te na kanda na bango, babomaki bato ; mpe na esengo na bango, basepelaki kokata misisa ya makolo ya bangombe ya mibali. ");
INSERT INTO lin_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Tika ete kanda na bango elakelama mabe, pamba te ezali makasi ! Tika ete kotomboka na bango elakelama mabe, pamba te ezanga mawa ! Nakokabola bango na Jakobi mpe nakopanza bango kati na Isalaele. ");
INSERT INTO lin_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Yuda, bandeko na yo ya mibali bakokumisa yo, loboko na yo ekozala na kingo ya banguna na yo ; bana mibali ya tata na yo bakogumbama liboso na yo. ");
INSERT INTO lin_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yuda, ozali mwana ya nkosi ; mwana na ngai ya mobali, owuti na bokila. Agunzami mpe alali lokola nkosi ya mobali ; mpe lokola nkosi ya mwasi, nani akomeka kotelemisa ye ? ");
INSERT INTO lin_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Nzete ya bokonzi ekolongwa te na Yuda, lingenda mpe ekolongwa te kati na makolo na ye, kino tango nkolo na ye akoya, nkolo oyo bikolo nyonso ekotosa. ");
INSERT INTO lin_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Akokanga ane na ye na nzete ya vino, mpe mwana ya ane na etape oyo ye akopona ; akosukola bilamba na ye na vino ; mpe kazaka na ye, na masanga ya vino ya motane. ");
INSERT INTO lin_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Miso na ye ekozala motane koleka vino, mpe minu na ye ekozala pembe koleka miliki. ");
INSERT INTO lin_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zabuloni akowumela pene ya ebale monene, eteni ya mabele na ye ekozala libongo ya masuwa, mpe mabele na ye ekokende kino na Sidoni. ");
INSERT INTO lin_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isakari azali ane ya makasi oyo elali kati na mapango mibale. ");
INSERT INTO lin_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Amonaki ete bopemi ezali malamu, mpe mokili na ye ezali kitoko ; boye mapeka na ye ekomema mikumba mpe abongi mpo na misala ya bowumbu. ");
INSERT INTO lin_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dani akokamba bato na ye lokola moko kati na bikolo ya Isalaele. ");
INSERT INTO lin_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dani akozala lokola nyoka na balabala to lokola etupa na nzela, oyo eswaka litindi ya mpunda mpo ete motambolisi na yango akweya. ");
INSERT INTO lin_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Oh Yawe, nazali na elikya ete okobikisa ngai ! ");
INSERT INTO lin_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gadi, banguna ebele bakobundisa ye, kasi ye mpe akobundisa bango kino kobengana bango. ");
INSERT INTO lin_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Bilei oyo ekobima na mokili ya Aseri ekozala ebele penza ; mabele na ye ekobota biloko oyo ebongi mpo na bakonzi. ");
INSERT INTO lin_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Nefitali azali lokola mboloko ya nsomi, oyo ebotaka bana kitoko. ");
INSERT INTO lin_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Jozefi azali lokola nzete oyo ebotaka mbuma mingi, nzete oyo ezalaka pembeni ya etima, mpe oyo bitape na yango elekaka bosanda ya mir. ");
INSERT INTO lin_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Banguna batumbolaki ye, babwakelaki ye makonga mpe babundisaki ye ; ");
INSERT INTO lin_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","kasi ye asimbaki kaka makasi tolotolo na ye, mpe maboko na ye etikalaki kolenga te mpo na loboko ya Elombe ya Jakobi, oyo azali Mobateli mpate, Libanga ya Isalaele. ");
INSERT INTO lin_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Mpo na Nzambe ya tata na yo, tika ete asungaka yo ! mpo na Nkolo-Na-Nguya-Nyonso, tika ete apambola yo, apambola yo na mapamboli ya Lola, wuta na likolo ; na mapamboli ya bozindo, na se ; na mapamboli ya mabele mpe ya libumu. ");
INSERT INTO lin_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Mapamboli ya tata na yo ezali na motuya koleka mapamboli ya bangomba ya kala, koleka bomengo ya bangomba mike ya kala ; tika ete mapamboli nyonso ekita na moto ya Jozefi, ekitela ye oyo atombolami kati na bandeko na ye ! ");
INSERT INTO lin_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benjame azali lokola mbwa ya zamba ; na tongo, apasolaka mosuni na ye ; na pokwa, akabolaka bomengo ya bitumba. » ");
INSERT INTO lin_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Bango nyonso nde basali bikolo zomi na mibale ya Isalaele ; mpe oyo ezali maloba oyo tata na bango alobaki na bango tango apambolaki bango. Apesaki na moko na moko lipamboli oyo ekoki na ye. ");
INSERT INTO lin_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Jakobi apesaki bango malako oyo : « Nakomi pene ya kokende kokutana na batata na ngai. Bokunda ngai esika moko na bango, na lilita oyo ezali na elanga ya Efroni, moto ya Iti, ");
INSERT INTO lin_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","kati na lidusu ya mabanga ya Makipela, pembeni ya Mamire, na mokili ya Kanana, elanga oyo Abrayami asombaki na Efroni, moto ya Iti, lokola lilita. ");
INSERT INTO lin_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Ezalaki kuna nde bakundaki Abrayami mpe Sara, mwasi na ye ; Izaki mpe Rebeka, mwasi na ye. Ezali kuna nde ngai nakundaki Lea. ");
INSERT INTO lin_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Elanga mpe lidusu ya mabanga oyo ezali kati na yango esombamaki epai ya bato ya Iti. » ");
INSERT INTO lin_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Tango Jakobi asilisaki kopesa malako epai ya bana na ye, asembolaki makolo na ye na mbeto, akataki motema mpe akendeki kokutana na batata na ye. ");
INSERT INTO lin_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Jozefi amibwakaki na nzoto ya tata na ye, alelaki ye mpe apesaki ye beze. ");
INSERT INTO lin_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Bongo Jozefi apesaki mitindo na minganga oyo bazalaki kosala epai na ye ete bakawusa nzoto ya Isalaele, tata na ye. Boye minganga bakawusaki nzoto ya Isalaele, ");
INSERT INTO lin_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","bakokisaki mikolo tuku minei oyo esengelaki mpo na kokawusa nzoto ya mowei. Bato ya Ejipito basalelaki ye matanga mikolo tuku sambo. ");
INSERT INTO lin_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Tango mikolo ya matanga esilaki, Jozefi alobaki na bakonzi oyo basalaka na ndako ya Faraon : — Soki nazwi ngolu na miso na bino, bolobela ngai epai ya Faraon. Boyebisa ye ");
INSERT INTO lin_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","ete tata na ngai alapisaki ngai ndayi : « Nakomi pembeni ya kokufa, bokunda ngai kati na kunda oyo natobolaki na libanga, na mokili ya Kanana. » Mpe sik’oyo, tika ete apesa ngai nzela mpo ete nakende kokunda tata na ngai, bongo na sima nde nakozonga. ");
INSERT INTO lin_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Faraon azongisaki : — Kende mpe kunda tata na yo ndenge alapisaki yo ndayi. ");
INSERT INTO lin_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Boye Jozefi akendeki kokunda tata na ye ; bakalaka nyonso ya lokumu ya Faraon bakendeki elongo na ye : bakonzi oyo bazalaki kosala na ndako na ye mpe bakonzi nyonso ya Ejipito ");
INSERT INTO lin_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","elongo na bato nyonso ya ndako ya Jozefi, bandeko na ye ya mibali mpe bato nyonso oyo bazalaki na ndako ya tata na ye. Bana na bango kaka nde batikalaki na Gosheni na bameme, bantaba mpe bangombe na bango. ");
INSERT INTO lin_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Jozefi atambolaki lisusu elongo na bashareti mpe bato oyo batambolaka likolo ya bampunda. Ezalaki mobembo ya bato ebele penza. ");
INSERT INTO lin_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Tango bakomaki na etando ya Atadi, pembeni ya Yordani, basalaki matanga ya monene penza. Jozefi asalaki mikolo sambo ya matanga mpo na tata na ye. ");
INSERT INTO lin_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Bongo tango bato ya Kanana oyo bazalaki kovanda kuna bamonaki matanga wana na etando ya Atadi, balobaki : « Bato ya Ejipito bazali na milulu minene ya matanga. » Yango wana babengaki esika yango Abele-Mitsirayimi, oyo ezali pembeni ya Yordani. ");
INSERT INTO lin_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Bana mibali ya Jakobi basalaki ndenge tata na bango atindaki bango. ");
INSERT INTO lin_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Bamemaki ye na mokili ya Kanana mpe bakundaki ye na lidusu ya mabanga oyo ezali na elanga ya Makipela, pembeni ya Mamire, elanga oyo Abrayami asombaki epai ya Efroni, moto ya Iti, mpo ete akomisa yango lilita na ye. ");
INSERT INTO lin_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Sima na kokunda tata na ye, Jozefi azongaki na Ejipito elongo na bandeko na ye ya mibali mpe bato nyonso oyo balandaki ye mpo na kokunda tata na ye. ");
INSERT INTO lin_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Tango bandeko mibali ya Jozefi bamonaki ete tata na bango asili kokufa, balobaki : « Tango mosusu Jozefi akoyina biso mpe akozongisela biso mabe nyonso oyo tosalaki ye ! » ");
INSERT INTO lin_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Boye batindelaki Jozefi maloba oyo : « Liboso ete tata na yo akufa, atikaki maloba oyo : ‹ Tala makambo oyo bokoyebisa Jozefi : ");
INSERT INTO lin_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘ Nasengi ete olimbisa masumu ya bandeko na yo mpe mabe oyo basalaki yo ! Sik’oyo, nabondeli yo, limbisa masumu ya basali ya Nzambe ya tata na yo ! ’ › » Tango Jozefi ayokaki maloba yango, alelaki. ");
INSERT INTO lin_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Bandeko na ye bayaki, bamibwakaki liboso na ye mpe balobaki : — Tozali bawumbu na yo. ");
INSERT INTO lin_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Kasi Jozefi alobaki na bango : — Bobanga te ! Boni, ngai nazali na esika ya Nzambe ? ");
INSERT INTO lin_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Bino bokanisaki kosala ngai mabe, kasi Nzambe abongolaki yango bolamu mpo na kokokisa, ndenge ezali kosalema sik’oyo, lobiko ya bomoi ya bato ebele. ");
INSERT INTO lin_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Yango wana, bobanga te ! Nakokokisa posa na bino mpe ya bana na bino. Akitisaki bango mitema mpe alobelaki bango na boboto nyonso. ");
INSERT INTO lin_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Jozefi avandaki na Ejipito elongo na libota nyonso ya tata na ye. Awumelaki na bomoi mibu nkama moko na zomi. ");
INSERT INTO lin_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Amonaki bakitani ya Efrayimi kino na molongo ya misato. Amonaki lisusu bana ya Makiri, mwana mobali ya Manase, ba-oyo babotamaki na mabolongo ya Jozefi. ");
INSERT INTO lin_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Jozefi alobaki na bandeko na ye ya mibali : « Nakomi pene ya kokufa. Kasi ya solo, Nzambe akosalisa bino mpe akobimisa bino na mokili oyo, mpo na kokotisa bino na mokili oyo alakaki epai ya Abrayami, ya Izaki mpe ya Jakobi tango alapaki ndayi. » ");
INSERT INTO lin_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Jozefi alapisaki bana mibali ya Isalaele ndayi mpe alobaki na bango : « Tango Nzambe akosunga bino, bokolongola mikuwa na ngai na esika oyo. » ");
INSERT INTO lin_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Bongo Jozefi akufaki tango akokisaki mibu ya mbotama nkama moko na zomi. Tango basilisaki kokawusa nzoto na ye, batiaki ye na sanduku na Ejipito.");
INSERT INTO lin_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Tala bakombo ya bana ya Isalaele oyo bakendeki na Ejipito elongo na Jakobi, moko na moko elongo na libota na ye : ");
INSERT INTO lin_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ribeni, Simeoni, Levi mpe Yuda ; ");
INSERT INTO lin_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isakari, Zabuloni mpe Benjame ; ");
INSERT INTO lin_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dani mpe Nefitali ; Gadi mpe Aseri. ");
INSERT INTO lin_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Bakitani ya Jakobi bazalaki bango nyonso tuku sambo. Nzokande Jozefi amizalelaki na Ejipito. ");
INSERT INTO lin_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Jozefi mpe bandeko na ye nyonso ya mibali elongo na bato ya ekeke na bango basilaki na kokufa. ");
INSERT INTO lin_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Kasi bana ya Isalaele babotanaki mingi mpe bakomaki ebele penza. Bakomaki lisusu ebele koleka mpe makasi mingi : batondisaki mokili ya Ejipito. ");
INSERT INTO lin_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Mokonzi moko ya sika, oyo ayebaki Jozefi te, azwaki bokonzi na Ejipito. ");
INSERT INTO lin_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Alobaki na bato na ye : « Botala bana ya Isalaele, bakomi ebele koleka biso mpe baleki biso na makasi. ");
INSERT INTO lin_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Tosengeli kosala keba mpo na bango, mpo ete bakoma lisusu ebele te. Pamba te soki bitumba ekweyi, bakoki kokende na ngambo ya banguna na biso mpe kobundisa biso mpo ete babima na mokili oyo. » ");
INSERT INTO lin_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Boye batiaki bakonzi ya misala makasi mpo na konyokola bana ya Isalaele na nzela ya misala makasi. Na bongo, batongelaki Faraon bingumba ya Pitomi mpe ya Ramisesi mpo ete ezala bisika ya kobomba biloko. ");
INSERT INTO lin_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Kasi wana bazalaki konyokola bango, bazalaki kokoba kaka kobotana mpe kokoma ebele. Bongo bato ya Ejipito bakomaki kobanga bana ya Isalaele. ");
INSERT INTO lin_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Bato ya Ejipito bakotisaki bana ya Isalaele na bowumbu ya makasi ");
INSERT INTO lin_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","mpe bakomaki konyokola bango na misala makasi : kosala potopoto, kobeta babiliki mpe kosala misala nyonso ya bilanga. Misala nyonso oyo bazalaki kosalisa bango ezalaki ya pasi mpe ya makasi. ");
INSERT INTO lin_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Mokonzi ya Ejipito alobaki na basi oyo babotisaka basi ya Ba-Ebre, oyo bakombo na bango ezalaki Shifra mpe Puwa : ");
INSERT INTO lin_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","« Tango bokobotisa basi ya Ba-Ebre, botala soki mwana nini abotami ; soki azali mwana mobali, boboma ye ; kasi soki azali mwana mwasi, botika ye na bomoi. » ");
INSERT INTO lin_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Kasi basi oyo babotisaka babangaki Nzambe mpe basalaki te makambo oyo mokonzi ya Ejipito atindaki bango kosala ; batikaki bana mibali na bomoi. ");
INSERT INTO lin_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Boye mokonzi ya Ejipito abengisaki basi oyo babotisaka mpe atunaki bango : — Mpo na nini bosali boye ? Mpo na nini botiki bana mibali na bomoi ? ");
INSERT INTO lin_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Basi oyo babotisaka bazongiselaki Faraon : — Basi ya Ba-Ebre bazali lokola basi ya Ejipito te. Bazali makasi, babotaka liboso ete basi oyo babotisaka bakoma. ");
INSERT INTO lin_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Nzambe asalaki bolamu epai ya basi oyo babotisaka. Boye bana ya Isalaele bakobaki kaka kokoma ebele mpe makasi koleka. ");
INSERT INTO lin_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Lokola basi oyo babotisaka bazalaki kobanga Nzambe, Nzambe afulukisaki mabota na bango. ");
INSERT INTO lin_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Bongo, Faraon apesaki mitindo epai ya bato na ye nyonso : « Bobwaka na ebale Nili bana mibali nyonso ya Isalaele oyo bakobotama, kasi botika na bomoi bana basi nyonso. » ");
INSERT INTO lin_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Mobali moko ya libota ya Levi abalaki mwasi kati na libota ya Levi. ");
INSERT INTO lin_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Mwana mwasi yango azwaki zemi mpe abotaki mwana mobali. Wana amonaki ete mwana yango azali kitoko, abombaki ye basanza misato. ");
INSERT INTO lin_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Lokola amonaki ete akokoka lisusu te kobomba ye, azwaki kitunga moko basala na poso ya nzete oyo babengaka papirisi, apakolaki yango gudron mpe potopoto ya mwindo ; bongo atiaki mwana kati na yango. Sima, atiaki kitunga yango kati na matiti ya ebale Nili, pembeni ya mokili. ");
INSERT INTO lin_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Ndeko mwasi ya mwana yango atelemaki mosika mpo na kotala likambo oyo ekokaki kokomela ye. ");
INSERT INTO lin_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Tango mwana mwasi ya Faraon akendeki kosukola na ebale Nili, wana basi basali na ye bazalaki kotambola pembeni ya ebale Nili, amonaki kitunga kati na matiti ya ebale ; mpe atindaki mwasi mosali na ye kozwa yango. ");
INSERT INTO lin_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Afungolaki yango mpe amonaki kati na yango mwana moko ya mobali azali kolela. Ayokelaki ye mawa mpe alobaki : « Oyo azali solo mwana ya Ba-Ebre. » ");
INSERT INTO lin_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Boye, ndeko na ye ya mwasi alobaki na mwana mwasi ya Faraon : — Boni, nakoki kokende kolukela yo kati na basi ya Ba-Ebre mwasi oyo akoki komelisa mwana oyo mabele mpo na yo ? ");
INSERT INTO lin_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Mwana mwasi ya Faraon azongiselaki ye : — Iyo, kende ! Elenge mwasi akendeki mpe azwaki mama ya mwana mobali yango. ");
INSERT INTO lin_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Mwana mwasi ya Faraon alobaki na mama yango : « Kamata mwana oyo, melisa ye mabele mpo na ngai, mpe nakofuta yo. » Bongo mama yango azwaki mwana mpe akomaki komelisa ye mabele. ");
INSERT INTO lin_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Tango mwana akolaki, amemaki ye epai ya mwana mwasi ya Faraon oyo akomisaki ye mwana na ye ya mobali. Apesaki ye kombo « Moyize, » pamba te alobaki : « Nazwaki ye na mayi. » ");
INSERT INTO lin_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Mokolo moko, wana Moyize akomaki mokolo, akendeki na esika oyo bandeko na ye bazalaki mpe amonaki bango kosala misala makasi oyo bapesaki bango mpo na konyokola bango. Amonaki moto moko ya Ejipito kobeta moko kati na bato na ye Ba-Ebre. ");
INSERT INTO lin_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Atalaki ngambo na ngambo mpe amonaki moto te ; bongo abomaki moto ya Ejipito mpe akundaki ye na zelo. ");
INSERT INTO lin_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Mokolo oyo elandaki, Moyize abimaki mpe amonaki Ba-Ebre mibale bazali kobunda. Atunaki na moto oyo asalaki mabe : — Mpo na nini ozali kobeta moninga na yo ? ");
INSERT INTO lin_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Moto wana azongisaki : — Boni, nani akomisi yo mokonzi mpe mosambisi kati na biso ? Olingi koboma ngai ndenge obomaki moto ya Ejipito ? Moyize abangaki mpe amilobelaki : « Solo, likambo oyo nasalaki, esili koyeba. » ");
INSERT INTO lin_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Tango Faraon ayokaki likambo yango, alukaki nzela ya koboma Moyize ; kasi Moyize akimaki liboso ya Faraon mpe akendeki kovanda na mokili ya Madiani. ");
INSERT INTO lin_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Moyize avandaki pembeni ya libulu ya mayi. Nzokande, Nganga-Nzambe ya Madiani azalaki na bana basi sambo. Bayaki kotoka mayi mpe batondisaki bimelelo mpo ete bamelisa bibwele ya tata na bango. ");
INSERT INTO lin_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Kasi babateli bibwele bayaki mpe babenganaki bango. Moyize atelemaki, akotelaki bango mpe amelisaki bibwele na bango mayi. ");
INSERT INTO lin_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Tango bana basi bazongaki epai ya tata na bango Reweli, atunaki bango : — Mpo na nini lelo bozongi noki ? ");
INSERT INTO lin_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Bango bazongisaki : — Moto moko ya Ejipito abundelaki biso liboso ya babateli bibwele, atokelaki biso mayi mpe amelisaki bibwele. ");
INSERT INTO lin_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Reweli atunaki bana na ye ya basi : — Moto yango ya Ejipito azali wapi ? Mpo na nini botiki ye kuna ? Bobenga ye mpo ete aya kolia. ");
INSERT INTO lin_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Moyize andimaki kovanda elongo na Reweli ; bongo Reweli apesaki Sefora, mwana na ye ya mwasi, mpo ete azala mwasi ya Moyize. ");
INSERT INTO lin_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Sefora abotaki mwana mobali mpe Moyize apesaki ye kombo « Gerishomi, » pamba te alobaki : « Nazali mopaya na mboka mopaya. » ");
INSERT INTO lin_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Sima na tango molayi, mokonzi ya Ejipito akufaki. Bato ya Isalaele bazalaki kolela mpe koganga na se ya pasi ya bowumbu. Bongo koganga na bango ekomaki kino epai ya Nzambe. ");
INSERT INTO lin_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Nzambe ayokaki koganga na bango mpe akanisaki boyokani na Ye oyo asalaki elongo na Abrayami, Izaki mpe Jakobi. ");
INSERT INTO lin_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Nzambe atalaki bana ya Isalaele mpe asosolaki pasi na bango. ");
INSERT INTO lin_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Moyize azalaki koleisa bibwele ya Jetro, bokilo na ye mpe Nganga-Nzambe ya Madiani. Amemaki bibwele mosika, kati na esobe, mpe akomaki na Orebi, ngomba ya Nzambe. ");
INSERT INTO lin_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Kuna, Anjelu ya Yawe abimelaki ye kati na ndemo ya moto oyo ezalaki komata longwa kati na mwa nzete. Moyize amonaki nzete moke yango kopela moto, kasi ezalaki kozika te. ");
INSERT INTO lin_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Moyize amilobelaki : « Tika ete nabaluka mpo ete natala emoniseli oyo ya kokamwa mpe nayeba mpo na nini nzete moke oyo ezali kozika te. » ");
INSERT INTO lin_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Tango Yawe amonaki ete Moyize azali kobaluka mpo na kotala, Nzambe abengaki ye wuta na nzete moke yango : — Moyize, Moyize ! Moyize azongisaki : — Ngai oyo ! ");
INSERT INTO lin_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Nzambe alobaki na ye : — Kopusana awa te, longola basandale na yo na makolo na yo, pamba te esika oyo otelemi ezali mabele ya bule. ");
INSERT INTO lin_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Alobaki lisusu : — Nazali Nzambe ya bakoko na yo, Nzambe ya Abrayami, Nzambe ya Izaki, mpe Nzambe ya Jakobi. Boye Moyize abombaki elongi na ye, pamba te abangaki kotala Nzambe. ");
INSERT INTO lin_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Yawe alobaki : — Namoni pasi ya bato na Ngai kuna na Ejipito ; nayoki koganga na bango mpo na misala makasi oyo bakonzi ya misala makasi bazali kopesa bango. Nayebi pasi na bango. ");
INSERT INTO lin_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Yango wana nakiti mpo na kokangola bango na maboko ya bato ya Ejipito mpe kobimisa bango na mokili oyo, mpo na kokotisa bango na mokili ya kitoko mpe ya monene, mokili oyo ezali kobimisa miliki mpe mafuta ya nzoyi. Ezali mokili oyo evandaka bato ya Kanana, ya Iti, ya Amori, ya Perizi, ya Evi mpe ya Yebusi. ");
INSERT INTO lin_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Sik’oyo, koganga ya bana ya Isalaele ekomi kino epai na Ngai mpe namoni ndenge nini bato ya Ejipito bazali konyokola bango. ");
INSERT INTO lin_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Yango wana natindi yo sik’oyo mpo ete okende epai ya Faraon mpo na kobimisa bato na Ngai, Isalaele, na Ejipito. ");
INSERT INTO lin_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Moyize alobaki na Nzambe : — Ngai nazali nani mpo ete nakende epai ya Faraon mpe mpo ete nabimisa bana ya Isalaele na Ejipito ? ");
INSERT INTO lin_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Nzambe alobaki : — Nakozala na yo elongo. Mpe tala elembo oyo ekolakisa yo ete Ngai nde natindi yo : tango okobimisa bato na Ngai na Ejipito, bokogumbamela Nzambe na ngomba oyo. ");
INSERT INTO lin_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Moyize alobaki na Nzambe : — Soki nakeyi epai ya bana ya Isalaele mpe nalobi na bango : « Nzambe ya bakoko na bino atindi ngai epai na bino, » bongo soki bango batuni ngai : « Kombo na Ye nani ? » Nakoyebisa bango nini ? ");
INSERT INTO lin_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Nzambe alobaki na Moyize : — Ngai nazali oyo akosala. Tala makambo oyo okoloba na bana ya Isalaele : « Nazali atindi ngai epai na bino. » ");
INSERT INTO lin_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Nzambe alobaki lisusu na Moyize : — Loba na bana ya Isalaele : « Yawe Nzambe ya bakoko na bino, Nzambe ya Abrayami, Nzambe ya Izaki, mpe Nzambe ya Jakobi, atindi ngai epai na bino. » ");
INSERT INTO lin_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Boye, kende, sangisa bakambi ya Isalaele mpe loba na bango : « Yawe, Nzambe ya bakoko na bino, Nzambe ya Abrayami, ya Izaki mpe ya Jakobi, abimelaki ngai mpe alobi : ‹ Nazwi mokano ya kobundela bino, pamba te namoni pasi na bino na Ejipito. › » ");
INSERT INTO lin_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Mpe nalobi : « Nakolongola bino na minyoko ya Ejipito mpo na komema bino na mokili ya bato ya Kanana, ya Iti, ya Amori, ya Perizi, ya Evi mpe ya Yebusi, na mokili oyo ezali kobimisa miliki mpe mafuta ya nzoyi. » ");
INSERT INTO lin_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Bakambi ya Isalaele bakoyokela yo, bongo yo elongo na bakambi, bokokende epai ya mokonzi ya Ejipito mpe bokoloba na ye : « Yawe Nzambe ya Ba-Ebre akutanaki na biso. Sik’oyo, pesa biso nzela ya kotambola mikolo misato kati na esobe mpo ete tokende kotumbela Yawe, Nzambe na biso, mbeka. » ");
INSERT INTO lin_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Kasi nayebi ete mokonzi ya Ejipito akopesa bino te nzela ya kokende, ata soki amoni loboko na Ngai ya nguya. ");
INSERT INTO lin_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Yango wana, nakosembola loboko na Ngai ; nakobeta Ejipito na nzela ya bikamwa na Ngai nyonso oyo nakosala kati na yango. Sima na yango, mokonzi ya Ejipito akotika bino kokende. ");
INSERT INTO lin_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Nakosala ete bana ya Isalaele bazwa ngolu na miso ya bato ya Ejipito mpo ete, tango bokolongwa, bokende maboko pamba te. ");
INSERT INTO lin_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Mwasi nyonso akosenga epai ya moninga na ye mpe epai ya mwasi oyo avandi na ndako na ye : biloko ya palata, ya wolo mpe bilamba. Bokopesa yango epai ya bana na bino ya mibali mpe ya basi mpo ete bamema. Na bongo nde bokosilisa biloko ya bato ya Ejipito. ");
INSERT INTO lin_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Moyize azongisaki : — Bongo soki bandimi ngai te, bayoki ngai te ? Solo, bakoloba kaka : « Yawe amonanaki na yo te. » ");
INSERT INTO lin_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Yawe atunaki ye : — Ozali na nini na loboko na yo ? Moyize azongisaki : — Nazali na lingenda. ");
INSERT INTO lin_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Yawe alobaki : — Bwaka yango na mabele. Moyize abwakaki lingenda yango na mabele mpe ebongwanaki nyoka. Bongo Moyize akimaki mosika na yango. ");
INSERT INTO lin_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Kasi Yawe alobaki na ye : — Sembola loboko na yo mpe kanga nyoka yango na mokila ! Moyize asembolaki loboko mpe akangaki nyoka ; mpe nyoka yango ebongwanaki lisusu lingenda na loboko na ye. ");
INSERT INTO lin_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Yawe alobaki na ye : — Esalemi bongo mpo ete bandima solo ete Yawe, Nzambe ya bakoko na bango, Nzambe ya Abrayami, ya Izaki mpe ya Jakobi, amonanaki na yo. ");
INSERT INTO lin_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Sima, Yawe alobaki na ye lisusu : — Tia loboko na yo na tolo na yo. Moyize atiaki loboko na ye na tolo na ye ; mpe tango alongolaki yango, loboko yango ezwaki bokono ya maba ; ekomaki pembe lokola mvula ya pembe. ");
INSERT INTO lin_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Yawe alobaki na ye : — Sik’oyo, zongisa loboko na yo na tolo na yo. Moyize azongisaki loboko na ye na tolo na ye. Mpe tango alongolaki yango, loboko yango ekomaki lisusu malamu lokola biteni mosusu ya nzoto na ye. ");
INSERT INTO lin_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Yawe alobaki na ye : — Soki bandimi yo te to soki babeti tembe mpo na elembo ya liboso, bakondima na elembo ya mibale. ");
INSERT INTO lin_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Kasi soki na bilembo oyo mibale, bandimi kaka te to bayoki te, wana okotoka mayi na ebale Nili, okosopa yango na esobe. Mayi oyo okozwa na ebale Nili ekokoma makila tango okosopa yango na mabele. ");
INSERT INTO lin_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Moyize alobaki na Yawe : — Ah, Nkolo, nakokaka koloba malamu te ! Yango ezali likambo ya lobi oyo eleki te to ya wuta tango obandi koloba na mosali na Yo te, pamba te nazali na monoko mpe na lolemo kilo. ");
INSERT INTO lin_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Yawe alobaki na ye : — Nani apesaka monoko epai ya moto ? Nani akomisaka moto baba to mokufi matoyi ? Nani akomisaka moto, moto oyo amonaka to mokufi miso ? Boni, ezali Ngai Yawe te ? ");
INSERT INTO lin_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Sik’oyo kende, Ngai moko nakosunga yo mpo ete oloba malamu, mpe nakoteya yo makambo oyo osengeli koloba. ");
INSERT INTO lin_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Kasi Moyize azongisaki : — Te Nkolo ! Nabondeli Yo ! Tinda moto mosusu oyo olingi mpo na kosala yango. ");
INSERT INTO lin_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Boye Yawe asilikelaki Moyize mpe alobaki na ye : — Boni, Aron, moto ya libota ya Levi, azali ndeko na yo te ? Nayebi ete alobaka malamu mpe ye wana azali koya kokutana na yo ; mpe motema na ye ekosepela tango akomona yo. ");
INSERT INTO lin_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Okoloba na ye mpe okotia maloba na monoko na ye, bongo Ngai nakosunga bino mibale mpo ete bokoka koloba malamu, mpe nakoteya bino makambo oyo bosengeli kosala. ");
INSERT INTO lin_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Ye akoloba epai ya bato na esika na yo, akozala molobeli na yo ; bongo yo okozala lokola nzambe na ye. ");
INSERT INTO lin_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Kasi zwa lingenda oyo ezali na maboko na yo mpo ete osala bilembo ya kokamwa na nzela na yango. ");
INSERT INTO lin_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Moyize azongaki epai ya Jetro, tata-bokilo na ye, mpe alobaki na ye : — Nasengeli kokende epai ya bandeko na ngai, na Ejipito, mpo ete natala soki ndambo kati na bango bazali nanu na bomoi. Jetro ozongisaki : — Kende na kimia ! ");
INSERT INTO lin_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Yawe alobaki na Moyize tango azalaki nanu na mokili ya Madiani : — Telema mpe zonga na Ejipito, pamba te bato nyonso oyo balingaki koboma yo basili kokufa. ");
INSERT INTO lin_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Moyize azwaki mwasi na ye mpe bana na ye ya mibali, atiaki bango likolo ya ane mpe azongaki na Ejipito. Azwaki lisusu lingenda ya Nzambe na loboko na ye. ");
INSERT INTO lin_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Yawe alobaki na Moyize : — Sik’oyo, lokola ozali kozonga na Ejipito, tala bikamwa nyonso oyo napesi yo nguya ya kosala ; okosala yango liboso ya Faraon. Ngai nakokomisa motema na ye libanga mpo ete akoka kotika te bato na Ngai kokende. ");
INSERT INTO lin_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Okoloba na Faraon : « Tala liloba oyo Yawe alobi : ‹ Isalaele azali mwana na Ngai ya liboso ya mobali. ");
INSERT INTO lin_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Mpe nalobi na yo : Tika mwana na Ngai ya mobali kokende mpo ete asalela Ngai. Soki kaka oboyi kotika ye, nakoboma mwana na yo ya liboso ya mobali. › » ");
INSERT INTO lin_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Nzokande na nzela, na esika oyo balekisaki butu, Yawe akutanaki na Moyize mpe alukaki koboma ye. ");
INSERT INTO lin_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Kasi Sefora azwaki libanga ya songe, akataki ngenga ya mwana na ye ya mobali mpe atutisaki ngenga yango na makolo ya Moyize ; alobaki : — Solo, ozali penza mpo na ngai mobali ya makila. ");
INSERT INTO lin_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Bongo Yawe atikaki Moyize. Ezalaki na tango wana nde Sefora alobaki na Moyize likolo na likambo ya kokatama ngenga : — Mobali ya makila. ");
INSERT INTO lin_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Yawe alobaki na Aron : — Kende kokutana na Moyize na esobe. Aron akendeki, akutanaki na Moyize na ngomba ya Nzambe mpe apesaki ye beze. ");
INSERT INTO lin_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Moyize ayebisaki Aron makambo nyonso oyo Yawe atindaki ye koloba mpe bikamwa nyonso oyo atindaki ye kosala. ");
INSERT INTO lin_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Bongo Moyize mpe Aron bakendeki kosangisa bakambi nyonso ya Isalaele. ");
INSERT INTO lin_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Aron ayebisaki bango maloba nyonso oyo Yawe alobaki na Moyize. Asalaki bikamwa liboso ya bato. ");
INSERT INTO lin_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Bato bandimaki. Bongo tango bayokaki ete Yawe akanisaki bana ya Isalaele mpe amonaki pasi na bango, bafukamaki mpe bagumbamelaki Yawe. ");
INSERT INTO lin_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Sima na yango, Moyize mpe Aron bakendeki epai ya Faraon mpe balobaki : — Tala makambo oyo Yawe, Nzambe ya Isalaele, alobi : « Tika bato na Ngai kokende kosala feti na esobe mpo na lokumu na Ngai. » ");
INSERT INTO lin_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Faraon azongisaki : — Ye Yawe nde nani mpo ete ngai natosa ye mpe natika Isalaele kokende ? Nayebi ye te mpe nakotika te ete Isalaele akende. ");
INSERT INTO lin_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Balobaki : — Nzambe ya Ba-Ebre akutanaki na biso. Sik’oyo, tika biso totambola mikolo misato kati na esobe mpo ete tokobonzela Yawe, Nzambe na biso, mbeka ; noki te akoboma biso na bokono to na mopanga. ");
INSERT INTO lin_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Kasi mokonzi ya Ejipito alobaki : — Moyize mpe Aron, mpo na nini bozali kopekisa bato kosala misala na bango ? Bozonga na mosala na bino ! ");
INSERT INTO lin_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Faraon abakisaki lisusu : — Botala ! Bato oyo bakomi ebele kati na mokili, bongo bino bozali kopekisa bango kosala mosala ! ");
INSERT INTO lin_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Kaka na mokolo wana, Faraon apesaki mitindo oyo epai ya bakambi oyo balandelaka misala makasi ya bawumbu mpe na bakapita ya bana ya Isalaele : ");
INSERT INTO lin_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","— Bokopesa lisusu matiti te epai ya bato oyo mpo na kosala babiliki ndenge bozalaki kopesa bango liboso ; botika bango moko bakende kolokota matiti na bango. ");
INSERT INTO lin_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Kasi botinda bango kosala kaka motango ya babiliki oyo basalaka wuta kala, bokitisa motango na yango te. Bazali bagoyigoyi, yango wana bazali koganga : « Tika biso tokende kobonzela Nzambe na biso mbeka ! » ");
INSERT INTO lin_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Bokomisa makasi misala na bango mpo ete bakoma na mosala ebele mpe batia matoyi te na makambo ya lokuta. ");
INSERT INTO lin_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Bongo bakambi oyo balandelaka misala makasi ya bawumbu mpe bakapita ya bana ya Isalaele babimaki mpe balobaki na bato : — Tala makambo oyo Faraon alobi : « Nakopesa bino lisusu matiti te. ");
INSERT INTO lin_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Bokende kozwa matiti bino moko na esika oyo bokoki komona yango ! Kasi motango ya babiliki oyo bakatela bino ekokita ata moke te. » ");
INSERT INTO lin_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Boye bana ya Isalaele bapanzanaki na Ejipito mobimba mpo na kolokota matiti ya kotumba na yango babiliki. ");
INSERT INTO lin_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Bakambi oyo balandelaka misala makasi ya bawumbu bazalaki kotindika bango na makasi mpe koloba : — Bokokisa motango ya babiliki oyo bakatela bino mpo na mokolo na mokolo lokola na tango oyo bazalaki kopesa bino matiti ! ");
INSERT INTO lin_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Bakambi oyo Faraon aponaki mpo na kolandela misala makasi ya bawumbu babetaki bakapita ya bana ya Isalaele oyo bango batiaki mpe batunaki bango : — Mpo na nini lobi oyo eleki mpe lelo bokokisi te motango ya babiliki oyo bosalaka wuta kala ? ");
INSERT INTO lin_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Bakengeli ya bana ya Isalaele bakendeki kolela epai ya Faraon : — Mpo na nini ozali kosala basali na yo boye ? ");
INSERT INTO lin_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Bazali kopesa lisusu te matiti epai ya basali na yo, nzokande bazali koloba na biso : « Bosala babiliki ! » Sik’oyo tala, basali na yo bazali kobetama, kasi mbeba ezali epai ya bato na yo moko. ");
INSERT INTO lin_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Faraon alobaki : — Bagoyigoyi ! Bozali penza bagoyigoyi ! Yango wana bozali koloba : « Tika biso tokende kobonzela Yawe mbeka. » ");
INSERT INTO lin_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Sik’oyo, bozonga na mosala ! Bakopesa bino lisusu matiti te, kasi bokosala kaka motango ya babiliki oyo bakatela bino. ");
INSERT INTO lin_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Bakengeli ya bana ya Isalaele bamonaki ete bakomi na pasi koleka tango bayebisaki bango : « Motango ya babiliki oyo bakatela bino mpo na mokolo na mokolo ekokita te. » ");
INSERT INTO lin_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Tango batikaki Faraon, batombokelaki Moyize mpe Aron oyo bazalaki kozela bango. ");
INSERT INTO lin_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Balobaki : — Tika ete Yawe atala bino mpe asambisa bino ! Bokomisi biso eloko ya nkele liboso ya Faraon mpe ya basali na ye mpe botie mopanga na maboko na bango mpo ete baboma biso ! ");
INSERT INTO lin_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Boye Moyize abalukaki epai na Yawe mpe abondelaki : — Nkolo ! Mpo na nini ozali komemela bato oyo pasi ? Boni, ezali mpo na yango nde otindaki ngai ? ");
INSERT INTO lin_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Wuta tango nakendeki koloba na Faraon na Kombo na Yo, Faraon akomi konyokola bato oyo, bongo Yo ozali kosala ata eloko moke te mpo na kokangola bango ! ");
INSERT INTO lin_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Yawe alobaki na Moyize : — Sik’oyo, okomona makambo oyo nakosala Faraon : na loboko na Ngai ya nguya, Faraon akotika bato na Ngai kokende mpe akobimisa bango na mokili na ye. ");
INSERT INTO lin_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Nzambe alobaki lisusu na Moyize : — Nazali Yawe. ");
INSERT INTO lin_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Namimonisaki epai ya Abrayami, ya Izaki mpe ya Jakobi lokola Nzambe-Na-Nguya-Nyonso, kasi namimonisaki te epai na bango na Kombo na Ngai : Yawe. ");
INSERT INTO lin_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Nasalaki boyokani na Ngai elongo na bango mpo na kopesa bango mokili ya Kanana epai wapi bazalaki kowumela lokola bapaya. ");
INSERT INTO lin_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Mpe lisusu nayoki kolela ya bana ya Isalaele oyo bato ya Ejipito bakomisi bawumbu, bongo nakanisi lisusu boyokani na Ngai. ");
INSERT INTO lin_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Yango wana, loba na bana ya Isalaele : « Nazali Yawe ! Nakokangola bino na misala makasi oyo bato ya Ejipito bapesi bino. Nakokangola bino na se ya bowumbu na bango na loboko na nguya mpe na bitumbu ya makasi. ");
INSERT INTO lin_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Nakozwa bino lokola bato na Ngai moko, bongo nakozala Nzambe na bino. Boye bokoyeba ete Ngai Yawe, nazali Nzambe na bino, oyo akangolaki bino na se ya misala makasi ya bato ya Ejipito. ");
INSERT INTO lin_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Mpe nakokotisa bino na mokili oyo nalapaki ndayi, na kotombola loboko, ete nakopesa yango epai ya Abrayami, epai ya Izaki mpe epai ya Jakobi ; nakopesa bino yango mpo ete ekoma ya bino. Nazali Yawe. » ");
INSERT INTO lin_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Moyize alobaki makambo oyo epai ya bana ya Isalaele, kasi bayokaki ye te, pamba te misala makasi oyo bazalaki kopesa bango elembisaki mitema na bango. ");
INSERT INTO lin_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","— Kende koyebisa Faraon, mokonzi ya Ejipito, ete abimisa bana ya Isalaele na mokili na ye. ");
INSERT INTO lin_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Kasi Moyize azongiselaki Yawe : — Soki kutu bana ya Isalaele bayoki ngai te, ndenge nini Faraon ayoka ngai moto ya likukuma ? ");
INSERT INTO lin_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Yawe alobaki na Moyize mpe Aron na tina na bana ya Isalaele mpe ya Faraon, mokonzi ya Ejipito, oyo epai ya nani apesaki mitindo ete abimisa bana ya Isalaele na Ejipito. ");
INSERT INTO lin_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Tala bakambi ya mabota na bango : Bana mibali ya Ribeni, mwana mobali ya liboso ya Isalaele : Enoki, Palu, Etsironi mpe Karimi. Wana nde mabota ya Ribeni. ");
INSERT INTO lin_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Bana mibali ya Simeoni : Yemuweli, Yamini, Owadi, Yakini, Tsoari mpe Saulo, mwana mobali oyo abotamaki na mwasi ya Kanana. Wana nde mabota ya Simeoni. ");
INSERT INTO lin_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Tala bakombo ya bana mibali ya Levi oyo awumelaki na bomoi mibu nkama moko na tuku misato na sambo kolanda ndenge babotamela : Gerishoni, Keati mpe Merari. ");
INSERT INTO lin_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Bana mibali ya Gerishoni kolanda mabota na bango : Libini mpe Shimei. ");
INSERT INTO lin_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Bana mibali ya Keati oyo awumelaki na bomoi mibu nkama moko na tuku misato na misato : Amirami, Yitseari, Ebron mpe Uzieli. ");
INSERT INTO lin_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Bana mibali ya Merari : Maali mpe Mushi. Wana nde mabota ya Levi kolanda ndenge babotamela. ");
INSERT INTO lin_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amirami abalaki Yokebedi, tata mwasi na ye, oyo abotelaki ye Aron mpe Moyize. Amirami awumelaki na bomoi mibu nkama moko na tuku misato na sambo. ");
INSERT INTO lin_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Bana mibali ya Yitseari : Kore, Nefegi mpe Zikiri. ");
INSERT INTO lin_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Bana mibali ya Uzieli : Mishaeli, Elitsafani mpe Sitiri. ");
INSERT INTO lin_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aron abalaki Elisheba, mwana mwasi ya Aminadabi mpe ndeko mwasi ya Nashoni. Elisheba abotelaki Aron : Nadabi, Abiyu, Eleazari mpe Itamari. ");
INSERT INTO lin_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Bana mibali ya Kore : Asiri, Elikana mpe Abiazafi. Wana nde mabota ya Kore. ");
INSERT INTO lin_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eleazari, mwana mobali ya Aron, abalaki moko kati na bana basi ya Putieli, oyo abotelaki ye mwana mobali : Pineasi. Wana nde bakambi ya mabota ya Levi kolanda mabota ya botata na bango. ");
INSERT INTO lin_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Ezali epai ya Aron mpe Moyize nde Yawe alobaki : « Bobimisa bana ya Isalaele na Ejipito lokola mampinga oyo etandami na molongo. » ");
INSERT INTO lin_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Ezali bango nde bakendeki kokutana na Faraon, mokonzi ya Ejipito, mpo na kobimisa bana ya Isalaele na mokili na ye. Ezali nde Moyize mpe Aron wana. ");
INSERT INTO lin_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Tala makambo oyo ekomaki tango Yawe alobaki na Moyize, na Ejipito : ");
INSERT INTO lin_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","Yawe ayebisaki Moyize : — Nazali Yawe. Loba na Faraon, mokonzi ya Ejipito, makambo nyonso oyo nayebisi yo. ");
INSERT INTO lin_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Kasi Moyize azongiselaki Yawe : — Tala, nazali na likukuma ; ndenge nini Faraon akoyoka ngai ? ");
INSERT INTO lin_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Yawe alobaki na Moyize : « Tala, nakomisi yo nzambe liboso ya Faraon, mpe Aron, ndeko na yo ya mobali, akozala mosakoli na yo. ");
INSERT INTO lin_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Okoloba makambo nyonso oyo natindi yo ; mpe Aron, ndeko na yo ya mobali, akoyebisa yango epai ya Faraon mpo ete Faraon abimisa bana ya Isalaele na mokili na ye. ");
INSERT INTO lin_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Kasi Ngai, nakokomisa motema ya Faraon makasi lokola libanga, nakosala bilembo mpe bikamwa ebele na Ejipito. ");
INSERT INTO lin_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Atako bongo, Faraon akoyokela bino te. Boye, nakosembola loboko na Ngai kati na Ejipito ; mpe na nzela ya bitumbu minene, nakobimisa wuta na Ejipito mampinga na Ngai, bato na Ngai, bana ya Isalaele. ");
INSERT INTO lin_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Bato ya Ejipito bakoyeba ete nazali Yawe tango nakosembola loboko na Ngai kati na mokili na bango mpe nakobimisa bana ya Isalaele wuta na Ejipito. » ");
INSERT INTO lin_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Moyize mpe Aron basalaki makambo nyonso oyo Yawe atindaki bango. ");
INSERT INTO lin_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Tango basololaki na Faraon, Moyize azalaki na mibu ya mbotama tuku mwambe ; mpe Aron, tuku mwambe na misato. ");
INSERT INTO lin_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Yawe alobaki na Moyize mpe Aron : ");
INSERT INTO lin_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","« Tango Faraon akoloba na bino : ‹ Bosala bikamwa, › yo Moyize, okoloba na Aron : ‹ Kamata lingenda na yo, bwaka yango liboso ya Faraon, › mpe lingenda ekobongwana nyoka. » ");
INSERT INTO lin_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Boye Moyize mpe Aron bakendeki epai ya Faraon mpe basalaki makambo nyonso oyo Yawe atindaki bango. Aron abwakaki lingenda na ye liboso ya Faraon mpe bakalaka na ye, mpe yango ebongwanaki nyoka. ");
INSERT INTO lin_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Faraon abengisaki bato ya bwanya mpe bato ya soloka. Bongo bato ya maji ya Ejipito, bango mpe basalaki bikamwa ya ndenge moko na nzela ya misala na bango ya soloka. ");
INSERT INTO lin_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Moko na moko kati na bango abwakaki lingenda na ye na mabele mpe ebongwanaki nyoka. Kasi lingenda ya Aron emelaki mangenda na bango. ");
INSERT INTO lin_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Atako bongo, motema ya Faraon ekomaki lisusu makasi ; mpe aboyaki koyokela bango, ndenge kaka Yawe alobaki. ");
INSERT INTO lin_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Yawe alobaki na Moyize : « Motema ya Faraon ezali kaka makasi, aboyi kaka kotika bato na Ngai kokende. ");
INSERT INTO lin_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Kende epai ya Faraon na tongo-tongo, na tango oyo abimaka mpo na kokende na mayi. Zela ye pembeni ya Nili mpo na kokutana na ye mpe simba na loboko na yo lingenda oyo ebongwanaki nyoka. ");
INSERT INTO lin_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Bongo okoloba na ye : ‹ Yawe, Nzambe ya Ba-Ebre, atindi ngai epai na yo mpo na koyebisa yo : ‘ Tala makambo oyo Yawe alobi : Tika bato na Ngai kokende kogumbamela Ngai na esobe. Kasi kino lelo, ozali kaka koyoka te. ");
INSERT INTO lin_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Tala makambo oyo Yawe alobi : Tala ndenge nini okoyeba ete Ngai nazali Yawe : Nakobeta na mayi ya Nili lingenda oyo nazali na yango na maboko, mpe mayi yango ekobongwana makila. ");
INSERT INTO lin_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Mbisi ya Nili ekokufa mpe mayi ya Nili ekokoma solo ya kopola, bongo bato ya Ejipito bakokoka lisusu komela yango te. ’ › » ");
INSERT INTO lin_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Yawe alobaki na Moyize : « Yebisa Aron : ‹ Kamata lingenda na yo mpe sembola yango na ngambo ya mayi nyonso ya Ejipito : etima mpe miluka, maziba mpe mabulu nyonso ya mayi ekobongwana makila. › Makila ekozala na bisika nyonso ya Ejipito kino na bimelelo ya mayi oyo esalema na nzete to na mabanga. » ");
INSERT INTO lin_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Moyize mpe Aron basalaki ndenge kaka Yawe atindaki bango. Aron atombolaki nzete na ye mpe abetaki lingenda oyo azalaki na yango, na mayi ya Nili na miso ya Faraon mpe ya basali na ye ; mpe mayi nyonso ebongwanaki makila. ");
INSERT INTO lin_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Mbisi ya Nili ekufaki mpe mayi elumbaki solo ya kopola na ndenge ete bato ya Ejipito bakokaki lisusu te komela yango. Makila ezalaki na bisika nyonso ya Ejipito. ");
INSERT INTO lin_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Kasi bato ya maji ya Ejipito, bango mpe basalaki bikamwa ya ndenge moko na nzela ya misala na bango ya soloka. Motema ya Faraon ekomaki lisusu makasi mpe aboyaki koyokela Moyize mpe Aron ndenge kaka Yawe alobaki. ");
INSERT INTO lin_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Atako bongo, Faraon abalukaki, akotaki na ndako na ye mpe azwaki likambo yango na motema te. ");
INSERT INTO lin_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Bato nyonso ya Ejipito batimolaki mabulu pene ya Nili mpo na kozwa mayi ya komela, pamba te bakokaki lisusu te komela mayi ya ebale. ");
INSERT INTO lin_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Mikolo sambo elekaki sima na Yawe kobebisa mayi ya Nili. ");
INSERT INTO lin_vpl VALUES ("EX7_26","003_7_26","EXO","7","26","26","Sima na yango, Yawe atindaki Moyize : « Kende kokutana na Faraon mpe loba na ye : ‹ Tala makambo oyo Yawe alobi : Tika bato na Ngai kokende kogumbamela Ngai. ");
INSERT INTO lin_vpl VALUES ("EX7_27","003_7_27","EXO","7","27","27","Soki oboyi kotika bango kokende, nakotinda etumbu ya magorodo na mokili na yo mobimba. ");
INSERT INTO lin_vpl VALUES ("EX7_28","003_7_28","EXO","7","28","28","Nili ekotonda na magorodo ; bongo magorodo yango ekobima wuta na Nili, ekokota kino na ndako na yo ya bokonzi, na shambre na yo ya kolala, na mbeto na yo, na bandako ya basali na yo, na bandako ya bato na yo, na bafulu na yo ya mapa mpe kino na bisika oyo babalolaka farine. ");
INSERT INTO lin_vpl VALUES ("EX7_29","003_7_29","EXO","7","29","29","Magorodo ekomatela yo, basali na yo mpe bato na yo nyonso. › » ");
INSERT INTO lin_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Yawe alobaki na Moyize : « Loba na Aron ete asembola loboko na ye mpe lingenda na ye na ngambo ya mayi, ya miluka mpe ya maziba, mpo ete abimisa magorodo na mokili ya Ejipito. » ");
INSERT INTO lin_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Boye Aron asembolaki loboko na ye na ngambo ya mayi ya Ejipito ; bongo magorodo ebimaki mpe etondisaki mokili ya Ejipito. ");
INSERT INTO lin_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Kasi bato ya maji ya Ejipito mpe basalaki bikamwa ya ndenge moko na nzela ya misala na bango ya soloka : bango mpe babimisaki magorodo na mokili ya Ejipito. ");
INSERT INTO lin_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Faraon abengisaki Moyize mpe Aron, alobaki na bango : — Bobondela Yawe ete alongola magorodo pene na ngai mpe pene ya bato na ngai ; bongo nakotika bato na bino kokende kobonzela Yawe mbeka. ");
INSERT INTO lin_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Moyize alobaki na Faraon : — Tika ete mokonzi apona tango nini nasengeli kobondela Yawe mpo na yo, basali na yo mpe bato na yo, mpo ete Yawe alongola magorodo pene na yo mpe pene ya bandako na yo ; kasi etikala kaka na ebale Nili. ");
INSERT INTO lin_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Faraon azongisaki : — Tika ete esalema lobi. Moyize alobaki : — Iyo, ekosalema ndenge osengi, mpo oyeba ete moko te azali lokola Yawe, Nzambe na biso. ");
INSERT INTO lin_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Magorodo ekolongwa pene na yo, pene na bandako na yo, ya basali na yo mpe ya bato na yo ; kasi ekotikala kaka na ebale Nili. ");
INSERT INTO lin_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Sima, Moyize mpe Aron batikaki Faraon. Bongo Moyize agangaki epai na Yawe na tina na magorodo oyo atindelaki Faraon. ");
INSERT INTO lin_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Yawe asalaki makambo oyo Moyize asengaki : magorodo ekufaki na bandako, na mapango mpe na bilanga. ");
INSERT INTO lin_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Basangisaki yango na maboke mpe mabele elumbaki solo ya kopola. ");
INSERT INTO lin_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Kasi tango Faraon amonaki ete kimia ekoti, ayeisaki lisusu motema na ye makasi lokola libanga mpe ayokelaki te Moyize mpe Aron ndenge kaka Yawe alobaki. ");
INSERT INTO lin_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Yawe alobaki na Moyize : — Loba na Aron ete asembola lingenda na ye mpe abeta yango na putulu ya mabele ; mpe yango ekokoma bangungi kati na mokili mobimba ya Ejipito. ");
INSERT INTO lin_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Basalaki kaka ndenge wana. Tango Aron asembolaki loboko mpe lingenda na ye, abetaki yango na putulu ya mabele ; bongo putulu yango ekomaki bangungi oyo ematelaki bato mpe banyama. Putulu nyonso ya mokili ya Ejipito ebongwanaki bangungi. ");
INSERT INTO lin_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Kasi tango bato ya maji bamekaki kobimisa bangungi na nzela ya misala na bango ya soloka, balongaki te. Bongo bangungi ematelaki bato mpe banyama. ");
INSERT INTO lin_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Boye bato ya maji balobaki na Faraon : « Oyo ezali penza mosapi ya Nzambe ! » Kasi Faraon ayeisaki lisusu motema na ye makasi lokola libanga mpe aboyaki koyoka, ndenge kaka Yawe alobaki. ");
INSERT INTO lin_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Yawe alobaki na Moyize : — Lamuka na tongo-tongo mpe kende kokutana na Faraon na tango oyo abimaka mpo na kokende na mayi. Loba na ye : « Tala makambo oyo Yawe alobi : Tika bato na Ngai kokende kogumbamela Ngai. ");
INSERT INTO lin_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Soki oboyi kotika bato na Ngai kokende, nakotinda banzinzi epai na yo, epai ya bakalaka na yo, epai ya bato na yo mpe kino na bandako na yo. Boye bandako ya bato na Ejipito, ezala mabele epai wapi bazali, ekotonda na banzinzi oyo eswaka. ");
INSERT INTO lin_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Na mokolo wana, nakosala bokeseni mpo na etuka ya Gosheni epai wapi bato na Ngai bazali kovanda ; banzinzi oyo eswaka ekozala kuna te, mpo oyeba ete, Ngai Yawe, nazali kati na etuka yango. ");
INSERT INTO lin_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Bongo nakotia bokeseni kati na bato na Ngai mpe bato na yo. Elembo yango ekosalema lobi. » ");
INSERT INTO lin_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Yawe asalaki bongo : banzinzi ebele oyo eswaka ekotaki mpe epanzanaki kati na ndako ya Faraon, na bandako ya bakalaka na ye mpe kati na mokili mobimba ya Ejipito. Boye mokili ebebisamaki na banzinzi oyo eswaka. ");
INSERT INTO lin_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Faraon abengisaki Moyize mpe Aron, alobaki na bango : — Bokende, bobonzela Nzambe na bino mbeka kati na mokili oyo. ");
INSERT INTO lin_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Kasi Moyize azongisaki : — Ekoki kosalema bongo te ; noki te mbeka oyo tokobonzela Yawe, Nzambe na biso, ekomonana lokola eloko ya nkele na miso ya bato ya Ejipito. Boni, soki tobonzi mbeka oyo emonani lokola eloko ya nkele na miso na bango, bakobamba biso mabanga te ? ");
INSERT INTO lin_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Tosengeli kotambola mikolo misato kati na esobe, sima tokobonzela Yawe, Nzambe na biso, mbeka ndenge atindaki biso. ");
INSERT INTO lin_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Faraon alobaki : — Nakotika bino kokende kobonzela Yawe, Nzambe na bino, mbeka kati na esobe ; kasi bokende mosika te. Sik’oyo, bobondela mpo na ngai ! ");
INSERT INTO lin_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Moyize azongisaki : — Ndenge nazali kobima boye na ndako na yo, nakobondela Yawe ; bongo lobi, banzinzi oyo eswaka ekolongwa epai ya Faraon, epai ya bakalaka na ye mpe epai ya bato na ye. Kasi tika ete Faraon akoba te kotiola Yawe na koboya kotika bato kokende kobonzela Yawe mbeka. ");
INSERT INTO lin_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Tango Moyize abimaki na ndako ya Faraon, abondelaki Yawe ");
INSERT INTO lin_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","mpe Yawe akokisaki makambo oyo Moyize asengaki : banzinzi oyo eswaka etikaki Faraon, bakalaka na ye mpe bato na ye. Ata nzinzi moko te etikalaki. ");
INSERT INTO lin_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Kasi na mbala oyo, Faraon ayeisaki lisusu motema na ye makasi lokola libanga mpe aboyaki kaka kotika bato kokende. ");
INSERT INTO lin_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Yawe alobaki na Moyize : « Kende koyebisa Faraon : ‹ Tala makambo oyo Yawe, Nzambe ya Ba-Ebre, alobi : ‘ Tika bato na Ngai kokende kogumbamela Ngai ! ’ ");
INSERT INTO lin_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Soki oboyi kotika bango kokende mpe okobi kokanga bango, ");
INSERT INTO lin_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","loboko na Yawe ekomema mopepe ya bokono ya somo kati na bibwele na yo, oyo ezali na elanga : bampunda, ba-ane, bashamo, bangombe, bameme mpe bantaba. ");
INSERT INTO lin_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Kasi Yawe akotia bokeseni kati na bibwele ya bana ya Isalaele mpe ya bato ya Ejipito, pamba te nyama moko te ya bana ya Isalaele ekokufa. › » ");
INSERT INTO lin_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Yawe abongisaki tango mpe alobaki : « Lobi, Yawe akokokisa likambo oyo na mokili. » ");
INSERT INTO lin_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Mpe mokolo oyo elandaki, Yawe akokisaki yango : bibwele nyonso ya bato ya Ejipito ekufaki, kasi ebwele ata moko te ya bana ya Isalaele ekufaki. ");
INSERT INTO lin_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Faraon atindaki bato mpo na kolandela likambo oyo mpe bamonaki ete ata ebwele moko te kati na bibwele ya bana ya Isalaele ekufaki. Atako bongo, Faraon ayeisaki lisusu motema na ye makasi mpe aboyaki kaka kotika bato kokende. ");
INSERT INTO lin_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Yawe alobaki na Moyize mpe Aron : « Botondisa maboko na bino na putulu oyo ewuti na fulu ya moto makasi, mpe tika ete Moyize abwaka yango likolo, na miso ya Faraon. ");
INSERT INTO lin_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Yango ekopanzana na mokili mobimba ya Ejipito mpe ekobimisa, kati na Ejipito mobimba, na banzoto ya bato mpe ya bibwele, babibon oyo ekokoma bapota ya kopola. » ");
INSERT INTO lin_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Bazwaki putulu na fulu ya moto mpe batelemaki liboso ya Faraon. Moyize abwakaki yango likolo mpe ebimisaki babibon oyo ekomaki bapota ya kopola na banzoto ya bato mpe ya bibwele. ");
INSERT INTO lin_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Bato ya soloka bakokaki te kotelema liboso ya Moyize likolo ya bapota oyo ezalaki na banzoto na bango mpe ya bato nyonso ya Ejipito. ");
INSERT INTO lin_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Kasi Yawe akomisaki lisusu motema ya Faraon makasi mpe Faraon ayokelaki te Moyize mpe Aron, ndenge kaka Yawe alobaki yango na Moyize. ");
INSERT INTO lin_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Yawe alobaki na Moyize : « Lamuka na tongo-tongo, kende kokutana na Faraon mpe loba na ye : ‹ Tala makambo oyo Yawe, Nzambe ya Ba-Ebre, alobi : Tika bato na Ngai kokende kogumbamela Ngai. ");
INSERT INTO lin_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Ya mbala oyo, nakotinda mopepe na Ngai nyonso ya bokono epai na yo, epai ya bakalaka na yo mpe epai ya bato na yo, mpo oyeba ete moko te azali lokola Ngai, na mokili mobimba. ");
INSERT INTO lin_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Pamba te kino sik’oyo, nakokaki kosembola loboko na Ngai mpe kotindela yo elongo na bato na yo nyonso, mopepe ya bokono oyo ekokaki kolimwisa bino na mokili. ");
INSERT INTO lin_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Kasi natikaki yo na bomoi mpo na tina oyo : kotalisa yo nguya na Ngai mpe kosala ete lokumu ya Kombo na Ngai epanzana na mokili mobimba. ");
INSERT INTO lin_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Lokola ozali kokoba koboya kotika bato na Ngai kokende, ");
INSERT INTO lin_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","lobi na ngonga oyo, nakobetisa mvula ya mabanga ya moto makasi, oyo etikala nanu kobeta te wuta mokili ya Ejipito ezala. ");
INSERT INTO lin_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Sik’oyo, pesa mitindo ete bamema na ebombelo, bibwele na yo mpe biloko nyonso oyo ozali na yango kati na elanga. Pamba te mvula ya mabanga ekokweyela mpe ekoboma moto mpe nyama nyonso oyo bokokotisa kuna te to oyo ekotikala kati na elanga. › » ");
INSERT INTO lin_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Kati na basali ya Faraon, ba-oyo babangaki Liloba na Yawe bakotisaki na lombangu bawumbu mpe bibwele na bango kati na bandako. ");
INSERT INTO lin_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Kasi ba-oyo babangaki te Liloba na Yawe, batikaki bawumbu mpe bibwele na bango kati na elanga. ");
INSERT INTO lin_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Yawe alobaki na Moyize : « Sembola loboko na yo na likolo mpo ete mvula ya mabanga enoka na mokili mobimba ya Ejipito : likolo ya bato, ya bibwele mpe ya matiti nyonso oyo ebotaka na elanga kati na Ejipito. » ");
INSERT INTO lin_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Tango Moyize asembolaki lingenda na ye na likolo, Yawe abetisaki bakake mpe mvula ya mabanga. Bakake ebetaki na mokili. Bongo Yawe anokisaki mvula ya mabanga na mokili ya Ejipito. ");
INSERT INTO lin_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Boye mvula ya mabanga mpe bakake ebetaki. Ezalaki mvula moko ya makasi penza oyo etikala nanu kobeta te wuta Ejipito ekoma ekolo. ");
INSERT INTO lin_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Ebomaki, kati na Ejipito, nyonso oyo ezalaki kati na elanga, ezala bato to bibwele ; ebebisaki matiti nyonso ya elanga mpe ebukaki banzete nyonso. ");
INSERT INTO lin_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Kasi enokaki te kati na etuka ya Gosheni epai wapi bana ya Isalaele bazalaki. ");
INSERT INTO lin_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Faraon abengisaki Moyize mpe Aron, alobaki na bango : — Ya mbala oyo, nasali lisumu. Yawe azali sembo ; ngai mpe bato na ngai tosali mabe. ");
INSERT INTO lin_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Bobondela Yawe mpo ete asilisa mvula ya mabanga mpe bakake. Bongo ngai nakotika bino kokende, mpe bino bokowumela lisusu awa te. ");
INSERT INTO lin_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Moyize azongisaki : — Tango nakobima na engumba, nakotombola maboko na ngai mpo na kobondela Yawe. Bakake ekosila mpe mvula ya mabanga ekonoka lisusu te, mpo ete oyeba ete mokili ezali ya Yawe. ");
INSERT INTO lin_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Kasi nayebi ete, yo elongo na bakalaka na yo, bokobanga na bino kaka Yawe Nzambe te. ");
INSERT INTO lin_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Lino mpe Orje ebebaki, pamba te lino ebimisaki mito mpe Orje ebimisaki bafololo. ");
INSERT INTO lin_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Ble mpe epotele ebebaki te, pamba te tango na yango ya kobota ekokaki nanu te. ");
INSERT INTO lin_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Bongo Moyize atikaki Faraon mpe abimaki libanda ya engumba. Atombolaki maboko na ye epai na Yawe ; boye bakake mpe mvula ya mabanga etikaki kobeta, mpe mvula esilaki kati na Ejipito. ");
INSERT INTO lin_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Tango Faraon amonaki ete mvula ya mabanga mpe bakake etiki kobeta, asalaki lisusu lisumu. Ye mpe bakalaka na ye bayeisaki lisusu mitema na bango makasi. ");
INSERT INTO lin_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Boye motema ya Faraon ekomaki penza makasi mpe aboyaki kotika bana ya Isalaele kokende, ndenge kaka Yawe alobaki na nzela ya Moyize. ");
INSERT INTO lin_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Yawe alobaki na Moyize : « Kende epai ya Faraon, pamba te nakomisi motema na ye mpe ya bakalaka na ye makasi, mpo ete nasala bilembo na Ngai ya kokamwa kati na bango, ");
INSERT INTO lin_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","mpe ete oyebisa bana na yo mpe bakoko na yo makambo oyo nasalaki na Ejipito mpe bilembo ya kokamwa oyo nasalaki kati na bango. Bongo bokoyeba ete Ngai nazali Yawe. » ");
INSERT INTO lin_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Boye Moyize mpe Aron bakendeki epai ya Faraon mpe balobaki na ye : « Tala makambo oyo Yawe, Nzambe ya Ba-Ebre, alobi : ‹ Kino tango nini okoboya komikitisa liboso na Ngai ? Tika bato na Ngai kokende kogumbamela Ngai. ");
INSERT INTO lin_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Soki oboyi kotika bango kokende, lobi nakotinda mabanki na mokili na yo. ");
INSERT INTO lin_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Ekotondisa mokili ya Ejipito na ndenge ete mabele ekomonana lisusu te. Mabanki yango ekolia mwa biloko moke oyo mvula ya mabanga etikaki ; ekolia mpe banzete na bino nyonso oyo ezali kokola kati na bilanga. ");
INSERT INTO lin_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Ekotonda na bandako na yo, ya bakalaka na yo mpe ya bato nyonso ya Ejipito ; ezala batata na yo to bakoko na yo batikala nanu komona te likambo ya boye wuta bazala na mokili oyo kino lelo. › » Moyize abalukaki mpe atikaki ndako ya Faraon. ");
INSERT INTO lin_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Bakalaka ya Faraon balobaki na ye : — Kino tango nini moto oyo akozala motambo mpo na biso ? Tika bango bakende kogumbamela Yawe, Nzambe na bango. Ozali komona te ete Ejipito ebebi ? ");
INSERT INTO lin_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Bongo bazongisaki Moyize mpe Aron epai ya Faraon ; mpe Faraon alobaki na bango : — Bokende kogumbamela Yawe, Nzambe na bino. Kasi banani oyo bakokende ? ");
INSERT INTO lin_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Moyize azongisaki : — Tokokende elongo na bilenge na biso, bampaka na biso, bana na biso ya mibali mpe ya basi, bameme na biso, bantaba na biso mpe bangombe na biso ; pamba te tokosala feti mpo na lokumu ya Yawe. ");
INSERT INTO lin_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Faraon alobaki na bango : — Soki nakotika bino kokende elongo na bana na bino, wana tika ete Yawe azala elongo na bino ! Nzokande emonani solo ete bozali na makanisi mabe. ");
INSERT INTO lin_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Ekosalema bongo te ! Kaka mibali nde bakokende kogumbamela Yawe, pamba te yango nde likambo oyo bozali kosenga ngai. Boye babenganaki Moyize mpe Aron liboso ya Faraon. ");
INSERT INTO lin_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Yawe alobaki na Moyize : — Sembola loboko na yo na mokili ya Ejipito mpo ete obimisa mabanki kati na mokili yango mpe mabanki yango elia matiti nyonso ya bilanga, biloko nyonso oyo mvula ya mabanga ebebisaki te. ");
INSERT INTO lin_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Boye Moyize asembolaki lingenda na ye na mokili ya Ejipito mpe Yawe atindaki mopepe ya este mokolo mobimba mpe butu mobimba. Mpe tango tongo etanaki, mopepe yango eyaki na mabanki. ");
INSERT INTO lin_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Mabanki ekotaki kati na Ejipito nyonso mpe evandaki ebele na bisika nyonso ya Ejipito. Etumbu ya mabanki ya ndenge wana etikala nanu kozala te mpe ekotikala kozala lisusu te. ");
INSERT INTO lin_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Ezipaki mabele nyonso mpe mabele eyindaki. Eliaki nyonso oyo mvula ya mabanga ebebisaki te : matiti nyonso ya bilanga mpe bambuma nyonso ya banzete. Kati na mokili mobimba ya Ejipito, eloko moko te ya mobesu etikalaki na banzete to na matiti ya bilanga. ");
INSERT INTO lin_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Faraon abengisaki Moyize mpe Aron na lombangu, alobaki : — Nasali lisumu epai na Yawe, Nzambe na bino, mpe epai na bino. ");
INSERT INTO lin_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Sik’oyo lisusu, bolimbisa lisumu na ngai. Bobondela Yawe, Nzambe na bino, mpo ete alongola etumbu oyo ya kufa kati na ngai. ");
INSERT INTO lin_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Moyize atikaki Faraon mpe abondelaki Yawe. ");
INSERT INTO lin_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Bongo Yawe akomisaki mopepe ya este ekumbaki moko ya weste oyo ememaki mabanki mpe ebwakaki yango na ebale monene ya Barozo. Ata libanki moko te etikalaki na bisika nyonso ya Ejipito. ");
INSERT INTO lin_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Kasi Yawe akomisaki lisusu motema ya Faraon makasi mpe Faraon aboyaki kotika bana ya Isalaele kokende. ");
INSERT INTO lin_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Yawe alobaki na Moyize : — Sembola loboko na yo likolo mpo ete molili epanzana na mokili ya Ejipito, molili oyo ekosala ete bato batambola na kosimbasimba. ");
INSERT INTO lin_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Boye Moyize asembolaki loboko na ye likolo mpe molili makasi ezipaki mokili mobimba ya Ejipito mikolo misato. ");
INSERT INTO lin_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Na mikolo misato yango, moto moko te akokaki komona moto mosusu mpe kolongwa na esika oyo azali mpo na kokende na esika mosusu. Nzokande pole ezalaki na bisika nyonso oyo bana ya Isalaele bazalaki kovanda. ");
INSERT INTO lin_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Faraon abengisaki Moyize mpe alobaki : — Bokende kogumbamela Yawe ; bokende bino nyonso nzela moko, ezala basi mpe bana na bino. Kasi botika kaka bangombe, bameme mpe bantaba na bino. ");
INSERT INTO lin_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Kasi Moyize alobaki : — Okopesa biso mbeka mpe makabo ya kotumba oyo tokobonzela Yawe, Nzambe na biso. ");
INSERT INTO lin_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Bitonga na biso ya bibwele mpe ekokende nzela moko na biso ; ata linzaka moko te ya ebwele ekotikala. Pamba te ezali kati na bibwele yango nde tokopona oyo tokobonzela Yawe, Nzambe na biso ; mpe wana tokomi nanu kuna te, toyebi te ebwele nini tokobonza mpo na kogumbamela Yawe. ");
INSERT INTO lin_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Kasi Yawe akomisaki lisusu motema ya Faraon makasi ; mpe Faraon aboyaki kaka kotika bango kokende. ");
INSERT INTO lin_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Faraon alobaki na Moyize : — Longwa liboso na ngai mpe keba na yo ! Koya lisusu liboso na ngai te ! Mokolo oyo okoya lisusu liboso na ngai, okokufa. ");
INSERT INTO lin_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Moyize azongisaki : — Ndenge kaka olobi, nakotikala koya lisusu liboso na yo te ! ");
INSERT INTO lin_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Yawe alobaki na Moyize : « Nakoyeisa lisusu etumbu moko na bomoi ya Faraon mpe ya Ejipito. Sima na yango, Faraon akotika bino ete bokende ; kutu, akobengana bino libela. ");
INSERT INTO lin_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Loba na bato ete basenga biloko ya palata mpe ya wolo : mobali nyonso asenga yango epai ya moninga na ye mobali mpe mwasi nyonso, epai ya moninga na ye mwasi. » ");
INSERT INTO lin_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Yawe asalaki ete bana ya Isalaele bazwa ngolu na miso ya bato ya Ejipito. Mpe Moyize ye moko azalaki moto monene kati na Ejipito, na miso ya basali ya Faraon mpe ya bato nyonso. ");
INSERT INTO lin_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Moyize alobaki na Faraon : « Tala makambo oyo Yawe alobi : ‹ Na kati-kati ya butu, nakotambola kati na mokili mobimba ya Ejipito. ");
INSERT INTO lin_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Mwana mobali nyonso ya liboso kati na Ejipito akokufa, kobanda na mwana mobali ya liboso ya Faraon oyo avandi na kiti ya bokonzi kino na mwana mobali ya liboso ya mwasi mowumbu oyo azali konika ble mpe bana mibali nyonso ya liboso ya bibwele. ");
INSERT INTO lin_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Bongo koganga makasi ekozala na mokili mobimba ya Ejipito, koganga oyo ezala nanu te mpe ekotikala kozala te. ");
INSERT INTO lin_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Kasi kati na bana nyonso ya Isalaele, ezala mbwa ekoganga te liboso ya moto to ya nyama. › Na bongo, bokoyeba ete Yawe asali bokeseni kati na bato ya Ejipito mpe ya Isalaele. ");
INSERT INTO lin_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Boye, bakalaka na yo nyonso oyo bazali zingazinga na yo bakoya epai na ngai, bakofukama liboso na ngai mpe bakoloba : ‹ Kende, yo mpe bato nyonso oyo bazali kotambola sima na yo. › Mpe sima na yango, nakobima. » Bongo Moyize abimaki na ndako ya Faraon na kanda makasi. ");
INSERT INTO lin_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Yawe alobaki na Moyize : « Faraon akoboya koyokela bino mpo ete bikamwa na Ngai ekoka komonana ebele kati na Ejipito. » ");
INSERT INTO lin_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Boye Moyize mpe Aron basalaki bikamwa wana nyonso liboso ya Faraon. Kasi Yawe akomisaki motema ya Faraon makasi mpe Faraon aboyaki kaka kotika bana ya Isalaele kobima na mokili na ye. ");
INSERT INTO lin_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Yawe alobaki na Moyize mpe Aron kati na Ejipito : ");
INSERT INTO lin_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","« Sanza oyo ekozala mpo na bino sanza ya liboso ya mobu. ");
INSERT INTO lin_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Boloba boye na lisanga mobimba ya Isalaele : Na mokolo ya zomi na sanza oyo, libota moko na moko to ndako moko na moko esengeli kozala na mwana meme to na mwana ntaba. ");
INSERT INTO lin_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Kasi soki bato ya ndako bazali ebele te mpo na kolia mwana meme ya mobimba, bakolia yango elongo na bato ya ndako oyo ezali pene na ndako na bango kolanda motango ya bato. Bakopona mwana meme kolanda oyo moko na moko akoki kolia. ");
INSERT INTO lin_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Mwana meme to mwana ntaba oyo bakopona esengeli kozala ya mobali, ya mobu moko mpe ezanga mbeba. ");
INSERT INTO lin_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Bokobatela yango kino na mokolo ya zomi na minei ya sanza yango. Na mokolo yango, bato nyonso ya lisanga ya Isalaele bakokata yango kingo na pokwa. ");
INSERT INTO lin_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Bakozwa makila na yango mpe bakopakola yango na libaya ya likolo mpe na mabaya mibale ya mipanzi oyo esimbaka ekuke ya bandako epai wapi bakolia nyama yango. ");
INSERT INTO lin_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Na butu ya mokolo yango, bakotumba mosuni na yango na moto mpe bakolia yango elongo na mapa ezanga levire mpe matiti ya bololo. ");
INSERT INTO lin_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Bakolia te mosuni oyo ebela malamu te to oyo batokisa, kasi bakolia kaka mosuni oyo batumba na moto elongo na makolo, moto mpe biloko ya kati. ");
INSERT INTO lin_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Bokotika ata ndambo te kino na tongo. Kasi soki ndambo ekomi na tongo, botumba yango na moto. ");
INSERT INTO lin_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Tala ndenge nini bokolia yango : bokolata mokaba na loketo, basandale na makolo, mpe bokosimba lingenda na loboko. Bokolia yango na lombangu. Ezali feti ya Pasika mpo na Yawe. ");
INSERT INTO lin_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Kaka na butu yango, nakoleka na Ejipito ; nakoboma bana nyonso ya liboso kati na Ejipito kobanda na bato kino na banyama ; mpe nakosambisa banzambe nyonso ya Ejipito na nzela ya bitumbu. Nazali Yawe. ");
INSERT INTO lin_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Na bandako epai wapi bokozala, makila ekozala elembo mpo na bino ; bongo tango Ngai nakomona makila yango, nakoleka bino. Boye etumbu moko te ya kufa ekokweya kati na bino tango nakopesa etumbu na mokili ya Ejipito. ");
INSERT INTO lin_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Mokolo yango ekozala mokolo ya ekaniseli mpo na bino. Bileko na bileko, bokobanda kosala feti na mokolo yango mpo na lokumu ya Yawe ; yango ekozala mpo na bino mobeko ya libela na libela mpo na bakitani oyo bakoya sima na bino. ");
INSERT INTO lin_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Mikolo sambo, bokolia mapa ezanga levire. Na mokolo ya liboso, bokolongola levire na bandako na bino ; pamba te moto nyonso oyo akolia eloko oyo ezali na levire, kobanda na mokolo ya liboso kino na mokolo ya sambo, bakolongola ye kati na bato ya Isalaele. ");
INSERT INTO lin_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Bokozala na mayangani ya bule na mokolo ya liboso mpe na mokolo ya sambo. Bokosala mosala moko te na mikolo wana longola kaka mosala ya kolamba bilei oyo moto na moto akolia. Yango kaka nde bokosala. ");
INSERT INTO lin_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Bokosala feti ya Mapa ezanga levire, pamba te ezalaki na mokolo yango nde nabimisaki mampinga na bino na Ejipito. Bokosala feti na mokolo yango lokola mobeko ya libela na libela mpo na bakitani oyo bakoya sima na bino. ");
INSERT INTO lin_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Na sanza ya liboso, bokolia mapa ezanga levire kobanda na pokwa ya mokolo ya zomi na minei kino na pokwa ya mokolo ya tuku mibale na moko. ");
INSERT INTO lin_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Mikolo sambo, levire esengeli te komonana kati na bandako na bino ; pamba te moto nyonso oyo akolia eloko oyo ezali na levire, esengeli balongola ye na lisanga ya Isalaele, azala mopaya to mwana mboka ya Isalaele. ");
INSERT INTO lin_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Bokolia eloko moko te oyo ezali na levire. Na bisika nyonso oyo bokozala, bokolia kaka mapa ezanga levire. » ");
INSERT INTO lin_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Moyize abengisaki bakambi nyonso ya Isalaele mpe alobaki na bango : « Bokende kozwa na libota moko na moko mwana meme to mwana ntaba mpe bokata yango kingo lokola mbeka ya Pasika. ");
INSERT INTO lin_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Bokokamata etape ya nzete ya izope, bokozindisa yango na makila oyo ekozala kati na sani monene, bokopakola yango na libaya ya likolo mpe na mabaya mibale ya mipanzi oyo esimbaka ekuke. Moko te kati na bino abima libanda ya ekuke ya ndako na ye kino na tongo. ");
INSERT INTO lin_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Wana Yawe akoleka na mokili mpo na koboma bato ya Ejipito mpe akomona makila na libaya ya likolo mpe na mabaya mibale ya mipanzi oyo esimbaka ekuke, akoleka ekuke yango mpe akopesa nzela te na mobomi ete akota na bandako na bino mpo na koboma. ");
INSERT INTO lin_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Bokotosa malako oyo lokola mobeko ya libela na libela mpo na bino mpe mpo na bakitani na bino. ");
INSERT INTO lin_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Tango bokokota na mokili oyo Yawe akopesa bino ndenge alakaki, bosalela likambo oyo. ");
INSERT INTO lin_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Bongo tango bana na bino bakotuna bino : ‹ Molulu oyo elakisi nini mpo na bino ? › ");
INSERT INTO lin_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Bokoloba na bango : ‹ Ezali mbeka ya feti ya Pasika mpo na Yawe oyo alekaki bandako ya bana ya Isalaele kati na Ejipito mpe abikisaki bandako na biso tango abomaki bato ya Ejipito. › » Na bongo, bana ya Isalaele bafukamaki mpe bagumbamelaki Yawe. ");
INSERT INTO lin_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Bato ya Isalaele basalaki ndenge kaka Yawe atindaki Moyize mpe Aron. ");
INSERT INTO lin_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Na kati-kati ya butu, Yawe abomaki bana mibali nyonso ya liboso kati na Ejipito kobanda na mwana mobali ya liboso ya Faraon oyo azalaki kokonza na kiti ya bokonzi kino na mwana mobali ya liboso ya mokangami oyo azalaki kati na boloko, mpe bana mibali ya liboso ya bibwele nyonso. ");
INSERT INTO lin_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Na butu wana, Faraon elongo na bakalaka na ye nyonso mpe bato nyonso ya Ejipito batelemaki ; mpe koganga makasi ezalaki na Ejipito, pamba te ezalaki na ndako moko te oyo ezangaki ebembe. ");
INSERT INTO lin_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Kaka na butu wana, Faraon abengisaki Moyize mpe Aron, alobaki na bango : « Botelema, bobima kati na bato na ngai, bino mpe bana ya Isalaele. Bokende kogumbamela Yawe ndenge bosengaki. ");
INSERT INTO lin_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Bokamata bibwele na bino ndenge bolobaki : bangombe, bameme mpe bantaba ; mpe bokende. Boye, bopambola mpe ngai. » ");
INSERT INTO lin_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Bato ya Ejipito batindikaki bana ya Isalaele ete babima noki na mokili na bango. Bazalaki koloba : « Bokende na bino, noki te biso tokokufa. » ");
INSERT INTO lin_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Boye bato bazwaki potopoto na bango ya farine liboso ete batia yango levire, bazingaki na banzambala na bango banzungu oyo basalelaka potopoto mpe batiaki yango na mapeka na bango. ");
INSERT INTO lin_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Bato ya Isalaele basalaki ndenge Moyize alobaki na bango mpe basengaki epai ya bato ya Ejipito biloko ya palata, ya wolo mpe bilamba. ");
INSERT INTO lin_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Bongo Yawe asalaki ete bana ya Isalaele bazwa ngolu na miso ya bato ya Ejipito oyo bapesaki bango biloko oyo basengaki. Na ndenge wana nde basilisaki biloko ya bato ya Ejipito. ");
INSERT INTO lin_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Bato ya Isalaele balongwaki na Ramisesi mpe bakendeki na Sukoti ; bazalaki mibali nkoto nkama motoba oyo bazalaki kotambola na makolo longola basi mpe bana. ");
INSERT INTO lin_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Ezalaki lisusu na ebele ya bato oyo bakendeki na bango elongo ; bamemaki lisusu bibwele : bameme, bantaba mpe bangombe. ");
INSERT INTO lin_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Basalaki na farine oyo bamemaki wuta na Ejipito bagato ezanga levire, pamba te tango babenganaki bango, potopoto emivimbelaki te mpe bazangaki tango ya kobongisa biloko ya kolia mpo na bango moko. ");
INSERT INTO lin_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Mibu oyo bana ya Isalaele bavandaki na Ejipito ezalaki nkama minei na tuku misato. ");
INSERT INTO lin_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Na suka ya mobu oyo ya nkama minei na tuku misato, mampinga nyonso ya Yawe batikaki Ejipito. ");
INSERT INTO lin_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Lokola Yawe akengelaki butu wana mpo na kobimisa bana ya Isalaele na Ejipito, butu yango ekomi ya Yawe : ekobanda kozala butu ya kokengela mpo na bana ya Isalaele na milongo na bango nyonso oyo ekoya. ");
INSERT INTO lin_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Yawe alobaki na Moyize mpe Aron : « Tala mibeko na tina na Pasika : ‹ Mopaya moko te akoki kolia yango. ");
INSERT INTO lin_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Kasi mowumbu nyonso oyo bakosomba, basengeli liboso kokata ye ngenga, sima nde akoki kolia Pasika. ");
INSERT INTO lin_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Mopaya oyo akozala na bino mpo na tango moke mpe mosali oyo azwaka lifuti bakolia yango te. ");
INSERT INTO lin_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Ekoliama kaka kati na ndako moko na moko, bakobimisa ata mosuni moko te na libanda ya ndako mpe bakobuka ata mokuwa na yango moko te. ");
INSERT INTO lin_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Lisanga mobimba ya Isalaele ekosala feti ya Pasika. ");
INSERT INTO lin_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Soki mopaya oyo azali kati na bino alingi kosepela na feti ya Pasika ya Yawe, esengeli ete mibali nyonso oyo bazali kati na ndako na ye bakatama ngenga ; bongo nde akozwa nzela ya kolia Pasika lokola mwana mboka ya Isalaele. Kasi mobali oyo akokatama ngenga te akoki kolia Pasika te. ");
INSERT INTO lin_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Mibeko ezali se ndenge moko mpo na mwana mboka ya Isalaele mpe mpo na mopaya oyo azali kati na bino. › » ");
INSERT INTO lin_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Bato nyonso ya Isalaele basalaki ndenge kaka Yawe atindaki Moyize mpe Aron. ");
INSERT INTO lin_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Mpe na mokolo wana, Yawe abimisaki bana ya Isalaele na molongo, wuta na Ejipito, lokola mampinga ya basoda. ");
INSERT INTO lin_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","« Bulisela Ngai mwana mobali nyonso ya liboso kati na bana ya Isalaele ; ezala moto to nyama, azali ya Ngai. » ");
INSERT INTO lin_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Moyize alobaki na bato : « Bokanisa mokolo oyo bobimaki na Ejipito, mokolo oyo bobimaki na bowumbu, pamba te Yawe abimisaki bino na loboko na Ye ya nguya. Bokolia eloko moko te oyo ezali na levire. ");
INSERT INTO lin_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Bozali kobima nde lelo oyo, na sanza ya abibi. ");
INSERT INTO lin_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Tango Yawe akokotisa yo na mokili ya bato ya Kanana, ya bato ya Iti, ya bato ya Amori, ya bato ya Evi mpe ya bato ya Yebusi, mokili oyo alakaki na batata na bino, na nzela ya ndayi, ete akopesa bino yango, mokili oyo ezali kobimisa miliki mpe mafuta ya nzoyi, okosala feti oyo na sanza oyo. ");
INSERT INTO lin_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Mikolo sambo, bokolia mapa ezanga levire ; na mokolo ya sambo, bokosala feti mpo na Yawe. ");
INSERT INTO lin_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Bokolia mapa ezanga levire mikolo sambo, mpe eloko moko te oyo ezali na levire ekomonana kati na mokili na bino mobimba. ");
INSERT INTO lin_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Na mokolo wana, bokoyebisa na bana na bino ya mibali : ‹ Nazali kosala molulu oyo mpo na kokanisa makambo oyo Yawe asalelaki ngai tango abimisaki ngai na Ejipito. › ");
INSERT INTO lin_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Feti oyo bokosala ekozala lokola elembo na loboko na bino mpe ekaniseli na elongi na bino mpo ete mibeko ya Yawe ezala na bibebu na bino, pamba te Ye nde abimisaki bino na Ejipito na loboko na Ye ya nguya. ");
INSERT INTO lin_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Bokobatela mobu na mobu mibeko oyo na eleko na yango. ");
INSERT INTO lin_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Tango Yawe akokotisa bino na mokili ya Kanana mpe akopesa bino yango ndenge alakaki yango, na nzela ya ndayi, epai ya bakoko na bino mpe epai na bino, ");
INSERT INTO lin_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","bokobonzela Ye bana mibali nyonso ya liboso : bana nyonso ya liboso ya banyama ekozala ya Yawe. ");
INSERT INTO lin_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Kasi soki mwana yango ya liboso ya nyama ezali mwana ya ane, bosengeli kobonza na esika na yango mwana meme ; soki te, bokobuka yango kingo. Kasi bokosikola na mbongo mwana nyonso ya liboso kati na bana na bino ya mibali. ");
INSERT INTO lin_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Mikolo ekoya, tango bana na bino ya mibali bakotuna bino : ‹ Molulu oyo elakisi nini ? › Bokoloba na bango : ‹ Ezali na nguya na Ye nde Yawe abimisaki biso na Ejipito, mokili ya bowumbu. ");
INSERT INTO lin_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Tango Faraon aboyaki kotika biso kokende, Yawe abomaki kati na Ejipito mwana nyonso ya liboso, ezala ya moto to ya nyama. Yango wana nazali kobonzela Yawe bana nyonso ya liboso kati na banyama mpe nazali kosikola bana nyonso ya liboso kati na bana na ngai. › ");
INSERT INTO lin_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Mpe yango ekozala lokola elembo na loboko na bino mpe ekaniseli na elongi na bino, pamba te Yawe abimisaki bino na Ejipito na nzela ya loboko na Ye ya nguya. » ");
INSERT INTO lin_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Tango Faraon atikaki bana ya Isalaele kokende, Nzambe amemaki bango te na nzela ya mboka ya Filisitia atako yango nde ezalaki mokuse, pamba te Nzambe amilobelaki : « Soki bakutani na bitumba, bakoyoka mawa na ndenge babimaki na Ejipito mpe bakoluka kozonga kuna. » ");
INSERT INTO lin_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Boye, Nzambe amemaki bato na nzela ya molayi, na nzela oyo ekenda na esobe, na ngambo ya ebale monene ya barozo. Bato ya Isalaele babimaki libanda ya Ejipito na molongo lokola mampinga ya basoda. ");
INSERT INTO lin_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Moyize azwaki mikuwa ya Jozefi, pamba te Jozefi alapisaki bana ya Isalaele ndayi ; alobaki : « Solo, Nzambe akozanga te kosunga bino, boye bokolongola mikuwa na ngai na esika oyo mpe bokomema yango elongo na bino. » ");
INSERT INTO lin_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Tango balongwaki na Sukoti mpe batongaki molako na Etami, na mondelo ya esobe, ");
INSERT INTO lin_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Yawe atambolaki liboso na bango, na moyi lokola likonzi ya lipata mpo na kolakisa bango nzela, mpe na butu lokola likonzi ya moto mpo na kongengisa bango, mpo ete batambola butu mpe moyi. ");
INSERT INTO lin_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Likonzi ya lipata na moyi to likonzi ya moto na butu elongwaki na esika na yango te liboso ya bana ya Isalaele. ");
INSERT INTO lin_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","« Loba na bana ya Isalaele ete bazonga mpe batonga molako pembeni ya Pi-Ayiroti, kati ya Migidoli mpe ebale monene. Batonga yango etalana na Bala-Tsefoni pembeni ya ebale monene. ");
INSERT INTO lin_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Faraon akokanisa ete bana ya Isalaele babungi na mokili, esobe ekangi bango. ");
INSERT INTO lin_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Nakokomisa motema ya Faraon libanga, mpe ye akolanda bango ; kasi nakomonisa nkembo na Ngai, nakotelemela Faraon mpe mampinga na ye ; bongo bato ya Ejipito bakoyeba ete Ngai nazali Yawe. » Bana ya Isalaele basalaki bongo. ");
INSERT INTO lin_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Tango bayebisaki mokonzi ya Ejipito ete bana ya Isalaele bakimi, Faraon mpe bakalaka na ye babongolaki makanisi na bango mpo na bana ya Isalaele mpe balobaki : « Likambo nini oyo tosali ? Totiki Isalaele kokende mpe tozangeli bato oyo bakoki kosalela biso ! » ");
INSERT INTO lin_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Boye Faraon azwaki shar oyo ezalaki ya kobombama mpe azwaki mampinga na ye elongo na ye. ");
INSERT INTO lin_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Akamataki bashar nkama motoba oyo eleki malamu elongo na bashar nyonso ya Ejipito ; shar moko na moko ezalaki na basoda misato. ");
INSERT INTO lin_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Yawe akomisaki motema ya Faraon, mokonzi ya Ejipito, libanga mpo ete alanda bana ya Isalaele oyo bazalaki kotambola na bonsomi nyonso. ");
INSERT INTO lin_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Bato ya Ejipito, bampunda nyonso ya Faraon mpe shar mosusu ya Faraon elongo na bato oyo batambolisaka yango mpe mampinga mosusu ya Faraon balandaki bana ya Isalaele mpe bazwaki bango tango batongaki molako na bango pembeni ya Pi-Ayiroti oyo etalana na Bala-Tsefoni. ");
INSERT INTO lin_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Lokola Faraon apusanaki, bana ya Isalaele batombolaki miso na bango mpe bamonaki ete bato ya Ejipito bazali kolanda bango na sima. Bana ya Isalaele babangaki makasi mpe bagangaki epai na Yawe. ");
INSERT INTO lin_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Balobaki na Moyize : — Boni, ezali mpo ete malita ezali te na Ejipito, yango wana omemi biso mpo ete tokufa na esobe ? Osali biso nini awa obimisi biso na Ejipito ? ");
INSERT INTO lin_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Toyebisaki yo te tango tozalaki na Ejipito : « Tika biso kimia, tika biso tosalela bato ya Ejipito ? » Pamba te elekaki malamu mpo na biso kosalela bato ya Ejipito na esika ya kokufa na esobe. ");
INSERT INTO lin_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Moyize azongiselaki bango : — Bobanga te, boyika mpiko ! Bokomona kokangolama oyo Yawe akomemela bino lelo ; bato ya Ejipito oyo bozali komona lelo, bokotikala komona bango lisusu te. ");
INSERT INTO lin_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Yawe akobunda mpo na bino, mpe bino bovanda kimia. ");
INSERT INTO lin_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Yawe alobaki na Moyize : — Mpo na nini ozali koganga boye epai na Ngai ? Loba na bana ya Isalaele ete batambola. ");
INSERT INTO lin_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Kasi yo, tombola lingenda na yo, sembola loboko na yo likolo ya ebale monene mpe kabola mayi mpo ete bana ya Isalaele bakoka kokatisa ebale monene lokola na mabele ya kokawuka. ");
INSERT INTO lin_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Bongo Ngai, nakoyeisa motema ya bato ya Ejipito libanga mpo ete balanda bino mpe nakomonisa nkembo na Ngai na kotelemela Faraon mpe mampinga na ye nyonso elongo na bashar na ye mpe bato na ye oyo batambolisaka bampunda. ");
INSERT INTO lin_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Bongo bato ya Ejipito bakoyeba ete nazali Yawe tango nakomonisa nkembo na Ngai na kotelemela Faraon, bashar na ye mpe bato na ye oyo batambolisaka bampunda. ");
INSERT INTO lin_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Anjelu na Nzambe oyo azalaki kotambola liboso ya mampinga ya Isalaele azongaki sima na bango, mpe likonzi ya lipata elongwaki liboso na bango mpo ete etelema sima na bango. ");
INSERT INTO lin_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Likonzi ya lipata etelemaki kati ya mampinga ya bato ya Ejipito mpe ya bana ya Isalaele. Likonzi ya lipata epesaki molili na ngambo moko mpe engengisaki ngambo mosusu ; yango wana butu mobimba, bato ya Ejipito bakokaki kopusana te pembeni ya bana ya Isalaele. ");
INSERT INTO lin_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Moyize asembolaki loboko na ye likolo ya ebale monene ; bongo na butu mobimba, Yawe atindaki na ebale monene mopepe makasi ya este oyo ekabolaki mayi ya ebale monene. ");
INSERT INTO lin_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Bato ya Isalaele batambolaki na ebale monene lokola na mabele ya kokawuka. Mayi etelemaki lokola mir na ngambo ya loboko na bango ya mobali mpe na ngambo ya loboko na bango ya mwasi. ");
INSERT INTO lin_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Bato ya Ejipito balandaki bango mpe bango nyonso bakotaki kati na ebale monene : bampunda nyonso ya Faraon, bashar na ye mpe batambolisi ya bampunda. ");
INSERT INTO lin_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Liboso ete tongo etana, Yawe atelemaki na likolo ya likonzi ya moto mpe ya lipata, atalaki mampinga ya bato ya Ejipito mpe akotisaki mobulu kati na yango. ");
INSERT INTO lin_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Alongolaki bapine na bashar na bango mpo ete bamona pasi mpo na kokumba. Boye bato ya Ejipito balobaki : — Tokima mosika ya bana ya Isalaele, pamba te Yawe azali kobundela bango liboso na biso. ");
INSERT INTO lin_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Yawe alobaki na Moyize : — Sembola loboko na yo likolo ya ebale monene mpo ete mayi ezonga mpe ekweyela bato ya Ejipito, bashar na bango mpe batambolisi ya bampunda. ");
INSERT INTO lin_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Moyize asembolaki loboko na ye likolo ya ebale monene, mpe liboso ete tongo etana, ebale monene ezongaki na esika na yango mpe bato ya Ejipito oyo balukaki kokima, bakutanaki na mayi liboso na bango. Boye Yawe azindisaki bango kati na ebale monene. ");
INSERT INTO lin_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Mayi ezongaki mpe ezipaki bashar elongo na batambolisi ya bampunda mpe mampinga ya Faraon oyo elandaki bana ya Isalaele kati na ebale monene. Moko te kati na bango abikaki. ");
INSERT INTO lin_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Kasi bana ya Isalaele batambolaki na ebale monene lokola na mabele ya kokawuka. Mayi etelemaki lokola mir na ngambo ya loboko na bango ya mobali mpe na ngambo ya loboko na bango ya mwasi. ");
INSERT INTO lin_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Na mokolo wana, Yawe abikisaki bana ya Isalaele liboso ya bato ya Ejipito mpe bana ya Isalaele bamonaki bibembe ya bato ya Ejipito etandami na libongo ya ebale monene. ");
INSERT INTO lin_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Tango bana ya Isalaele bamonaki nguya monene oyo Yawe atalisaki liboso ya bato ya Ejipito, babangaki Yawe mpe batiaki elikya na bango kati na Ye mpe kati na mosali na Ye Moyize. ");
INSERT INTO lin_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Moyize mpe bana ya Isalaele bayembaki loyembo oyo mpo na lokumu ya Yawe : Nakoyemba mpo na lokumu ya Yawe, mpo ete amonisi monene ya nkembo na Ye ! Azindisi mpunda mpe motambolisi na yango kati na ebale monene. ");
INSERT INTO lin_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Yawe azali makasi na ngai, azali solo loyembo na ngai, azali mobikisi na ngai, azali Nzambe na ngai, nakokumisa Ye ; azali Nzambe ya tata na ngai, nakonetola Ye. ");
INSERT INTO lin_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Yawe azali elombe ya bitumba ; Kombo na Ye ezali Yawe. ");
INSERT INTO lin_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Azindisi na ebale monene, bashar mpe mampinga ya Faraon ; abwaki na ebale monene ya barozo, bakonzi mpe basoda oyo Faraon atielaka motema. ");
INSERT INTO lin_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Mozindo ya mayi ezipi bango, bakiti kino na se ya ebale monene lokola libanga. ");
INSERT INTO lin_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Loboko na Yo ya mobali, oh Yawe, emonisi nguya na Yo ; loboko na Yo ya mobali, oh Yawe, enyati monguna. ");
INSERT INTO lin_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Na monene ya nguya na Yo, obebisi batelemeli na Yo ; na kanda na Yo, otombokeli bango, mpe baziki lokola matiti. ");
INSERT INTO lin_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Na pema ya zolo na Yo, mayi ekabwani, bambonge etelemi lokola mir, mpe mozindo ya mayi ekangami kati na ebale monene. ");
INSERT INTO lin_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Monguna amilobelaki : « Nakolanda bango kino nakokanga bango, molimo na ngai ekotonda na biloko oyo nakobotola ; nakobimisa mopanga na ngai, mpe loboko na ngai ekobebisa bango. » ");
INSERT INTO lin_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Kasi Yo, Yawe, ofuli mopepe na Yo, mpe ebale monene ezipi bango. Bazindi lokola mbodi kati na mayi makasi. ");
INSERT INTO lin_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Oh Yawe, nani kati na banzambe azali lokola Yo ? Nani azali lokola Yo, kitoko makasi kati na bosantu, somo, mpe abongi na lokumu, mpe asalaka makambo ya kokamwa ? ");
INSERT INTO lin_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Osembolaki loboko na Yo ya mobali, mpe mabele emeli bango. ");
INSERT INTO lin_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Na bolingo na Yo, otambolisi bato oyo okangoli. Na makasi na Yo, omemi bango na Ndako na Yo ya bule. ");
INSERT INTO lin_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Bikolo eyoki sango na yango mpe ekomi kolenga, somo ekangaki bato ya Filisitia. ");
INSERT INTO lin_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Bakambi ya Edomi bakomi na somo, bankumu ya Moabi bakomi kolenga, bato ya Kanana balembi nzoto. ");
INSERT INTO lin_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Kobanga mpe somo ekweyeli bango. Na nguya ya loboko na Yo, bakomi bababa lokola libanga kino bato na Yo, oh Yawe, balekaki, kino bato oyo osikolaki balekaki. ");
INSERT INTO lin_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Okomema bango mpe okovandisa bango na ngomba na Yo, esika oyo obongisaki, oh Nkolo, mpo na kovanda, Esika ya bule, oh Yawe, esika oyo maboko na Yo esalaki. ");
INSERT INTO lin_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Yawe akotikala mokonzi libela na libela ! ");
INSERT INTO lin_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Tango bampunda ya Faraon, bashar na ye elongo na bato oyo batambolisaka yango bamikotisaki kati na ebale monene, Yawe azongisaki mayi ya ebale monene likolo na bango. Nzokande bana ya Isalaele bakatisaki ebale monene lokola na esobe. ");
INSERT INTO lin_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Miriami, mwasi mosakoli mpe ndeko mwasi ya Aron, azwaki mbunda moke na loboko na ye mpe basi nyonso balandaki ye ; bazalaki kobeta bambunda mike mpe kobina. ");
INSERT INTO lin_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miriami ayembaki elongo na bango : « Boyembela Yawe, pamba te amonisi monene ya nkembo na Ye ; azindisi na ebale monene, mpunda mpe motambolisi na yango. » ");
INSERT INTO lin_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Moyize atambolisaki bana ya Isalaele wuta na ebale monene ya barozo mpe amemaki bango na nzela oyo ekenda na esobe ya Shuri. Batambolaki mikolo misato kati na esobe mpe bamonaki mayi te. ");
INSERT INTO lin_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Tango bakomaki na Mara epai wapi bamonaki mayi, bakokaki te komela mayi yango, pamba te ezalaki bololo. Yango wana babengaki esika yango Mara. ");
INSERT INTO lin_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Boye bato bayimaki-yimaki na tina na Moyize mpe balobaki : « Tokomela nini ? » ");
INSERT INTO lin_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Boye Moyize abelelaki Yawe, mpe Yawe alakisaki ye eteni ya nzete. Moyize abwakaki yango na mayi, mpe mayi ekomaki elengi mpo na komela. Ezalaki kuna nde Yawe apesaki bango bikateli, mibeko mpe amekaki bango. ");
INSERT INTO lin_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Alobaki : « Soki boyoki na bokebi mongongo na Yawe, Nzambe na bino, mpe bosali oyo ezali sembo na miso na Ye, soki bosali keba na malako na Ye mpe bobateli bikateli na Ye nyonso, nakotindela bino ata bokono moko te oyo natindelaki bato ya Ejipito ; pamba te nazali Yawe oyo abikisaka bino na bokono. » ");
INSERT INTO lin_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Bongo bana ya Isalaele bakomaki na Elimi epai wapi bitima zomi na mibale mpe banzete ya mbila tuku sambo ezalaki. Ezalaki kuna nde batongaki molako na bango, pene ya mayi. ");
INSERT INTO lin_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Lisanga nyonso ya bana ya Isalaele balongwaki na Elimi mpe bakomaki na esobe ya Tsini, oyo ezali kati ya Elimi mpe ngomba Sinai, na mokolo ya zomi na mitano, na sanza ya mibale sima na kobima na bango na Ejipito. ");
INSERT INTO lin_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Lisanga nyonso ya bana ya Isalaele bayimaki-yimaki na tina na Moyize mpe Aron kati na esobe. ");
INSERT INTO lin_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Bana ya Isalaele balobaki na bango : — Ah ! Ebongaki kutu loboko na Yawe epamela biso kati na Ejipito, pamba te, kuna, tozalaki kovanda pembeni ya banzungu etonda na misuni ; tozalaki kolia mpe kotonda biloko. Kasi bino bomemi biso kati na esobe oyo mpo na koboma lisanga oyo nyonso na nzala ! ");
INSERT INTO lin_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Yawe alobaki na Moyize : — Tala, nakokitisela bino mapa wuta na likolo. Mokolo na mokolo, bato bakobanda kobima mpe kolokota mapa oyo ekoki mpo na kolia mokolo wana. Na nzela wana, nakomeka bango mpo na kotala soki bakobatela to te malako na Ngai. ");
INSERT INTO lin_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Na mokolo ya motoba, bakolokota mbala mibale ndambo oyo bazalaki kolokota mpo na mokolo moko mpe bakolamba yango. ");
INSERT INTO lin_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Moyize mpe Aron balobaki na bana nyonso ya Isalaele : — Na pokwa ya lelo, bokoyeba solo ete ezali Yawe nde abimisaki bino na Ejipito. ");
INSERT INTO lin_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Boye lobi na tongo, bokomona nkembo na Yawe ; pamba te ayoki koyimayima na bino na tina na Ye. Mpo na yango, biso tozali banani mpo ete boyimayima epai na biso ? ");
INSERT INTO lin_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Moyize alobaki lisusu : — Bokoyeba ete ezali solo Yawe tango akopesa bino misuni ya kolia na pokwa mpe mapa ebele na tongo. Pamba te ayoki koyimayima na bino na tina na Ye. Biso tozali banani ? Boyimaki-yimaki na tina na biso te, kasi na tina na Yawe. ");
INSERT INTO lin_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Boye Moyize alobaki na Aron : — Yebisa lisanga nyonso ya bana ya Isalaele ete bapusana pene ya Yawe mpo ete ayoki koyimayima na bango. ");
INSERT INTO lin_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Wana Aron azalaki koloba na lisanga nyonso ya bana ya Isalaele, babalolaki miso na bango na ngambo ya esobe, mpe bamonaki nkembo na Yawe kobima na mapata. ");
INSERT INTO lin_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","— Nayoki koyimayima ya bana ya Isalaele. Yebisa bango : « Na pokwa ya lelo, bokolia misuni ; bongo na tongo, bokotonda mana. Boye, bokoyeba solo ete nazali Yawe, Nzambe na bino. » ");
INSERT INTO lin_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Kaka na pokwa wana, bakayi eyaki mpe etondisaki molako ; mpe na tongo, mamwe ezalaki zingazinga ya molako. ");
INSERT INTO lin_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Tango mamwe elimwaki, biloko ya mike-mike penza lokola bambuma ya mike-mike emonanaki na mabele ya esobe, pembe lokola mvula ya pembe. ");
INSERT INTO lin_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Tango bana ya Isalaele bamonaki yango, batunanaki bango na bango : — Oyo nini ? Pamba te bayebaki te soki ezali nini. Moyize alobaki na bango : — Ezali mapa oyo Yawe apesi bino mpo ete bolia. ");
INSERT INTO lin_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Tala mibeko oyo Yawe apesi na tina na likambo oyo : « Tika ete moto na moto alokota oyo ekoki mpo na ye kolia, omeri moko mpo na moto moko. Moto na moto akolokota kolanda motango ya bato oyo bazali kati na ndako na ye ya kapo. » ");
INSERT INTO lin_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Bato ya Isalaele basalaki bongo : bamoko balokotaki moke ; mpe bamosusu, ebele. ");
INSERT INTO lin_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Mpe bamekaki na omeri : moto oyo alokotaki ebele, alekelaki te ; mpe oyo alokotaki moke, azangelaki te. Balokotaki moto na moto kolanda oyo ekokaki mpo na ye kolia. ");
INSERT INTO lin_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Moyize ayebisaki bango : — Moko te abomba ata moke kino na tongo. ");
INSERT INTO lin_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Kasi bamosusu kati na bango bayokelaki Moyize te mpe babombaki ndambo na yango kino na tongo. Boye bankusu etondaki na ndambo oyo babombaki, mpe ekomaki kolumba solo ya kopola. Mpo na yango, Moyize atombokelaki bango. ");
INSERT INTO lin_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Tongo nyonso, moto na moto abandaki kolokota oyo ekokaki mpo na ye kolia. ");
INSERT INTO lin_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Na mokolo ya motoba, bana ya Isalaele bazalaki kolokota mbala mibale ndambo oyo bazalaki kolokota mpo na mokolo moko : omeri mibale mpo na moto moko. Bakambi nyonso ya lisanga bayaki koyebisa yango Moyize. ");
INSERT INTO lin_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Moyize alobaki na bango : — Tala mibeko oyo Yawe apesi : « Lobi ezali mokolo ya kopema, mokolo ya Saba oyo ebulisami mpo na Yawe. Bokolamba oyo bolingi kolamba mpe bokotokisa oyo bolingi kotokisa ; kasi oyo ekotikala, bobatela yango kino lobi. » ");
INSERT INTO lin_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Bato ya Isalaele babatelaki yango kino na tongo, ndenge kaka Moyize atindaki ; mana elumbaki te solo ya kopola, mpe bankusu ezalaki te kati na yango. ");
INSERT INTO lin_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Moyize ayebisaki bango : — Mokolo ya lelo ezali mokolo ya Saba, mokolo ya Yawe. Bolia mana oyo bobombaki ; pamba te lelo, bokotikala te komona mana na libanda. ");
INSERT INTO lin_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Bokobanda kolokota yango mikolo motoba ; kasi na mokolo ya sambo, mokolo ya Saba, mana ekobanda kozala te. ");
INSERT INTO lin_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Atako bongo, na mokolo ya sambo, bato mosusu kati na bango babimaki mpo na kolokota yango, kasi bamonaki eloko te. ");
INSERT INTO lin_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Boye Yawe alobaki na Moyize : — Kino tango nini bokoboya kobatela mibeko mpe malako na Ngai ? ");
INSERT INTO lin_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Botia na mito na bino ete Ngai Yawe, napesaki bino mokolo ya Saba. Yango wana, na mokolo ya motoba, napesaka bino mapa mpo na mikolo mibale. Boye tika ete, na mokolo ya sambo, moto na moto avanda epai na ye ; moko te abima na libanda. ");
INSERT INTO lin_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Boye bato bapemaki na mokolo ya sambo. ");
INSERT INTO lin_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Bato ya Isalaele babengaki lipa yango mana. Ezalaki pembe lokola bambuma ya koriande mpe elengi lokola mikate balamba na mafuta ya nzoyi. ");
INSERT INTO lin_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Moyize alobaki : — Tala mibeko oyo Yawe apesi : « Bozwa omeri moko ya mana mpe bobomba yango mpo na milongo ya bakitani na bino oyo ekoya, mpo ete bamona mapa oyo naleisaki bino na esobe tango nabimisaki bino na Ejipito. » ");
INSERT INTO lin_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Boye Moyize alobi na Aron : — Kamata ekolo moko mpe tia omeri moko ya mana kati na yango ; bongo tia yango liboso ya Yawe mpo ete ebombama mpo na milongo oyo ekoya. ");
INSERT INTO lin_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Ndenge kaka Yawe atindaki Moyize, Aron atiaki mana yango liboso ya Sanduku ya Boyokani mpo ete ebombama malamu. ");
INSERT INTO lin_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Bana ya Isalaele baliaki mana mibu tuku minei kino tango bakomaki na mondelo ya mokili ya Kanana. ");
INSERT INTO lin_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Omeri moko ekokani na eteni ya zomi ya efa. ");
INSERT INTO lin_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Lisanga mobimba ya bana ya Isalaele elongwaki na esobe ya Tsini mpe ezalaki kotambola kolanda ndenge Yawe azalaki kotinda. Batongaki molako na bango na Refidimi, kasi mayi ya komela ezalaki te mpo na bato. ");
INSERT INTO lin_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Bato ya Isalaele baswanisaki Moyize, balobaki na ye : — Pesa biso mayi ya komela ! Moyize azongiselaki bango : — Mpo na nini bozali koswanisa ngai ? Mpo na nini bolingi komeka Yawe ? ");
INSERT INTO lin_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Lokola posa ya mayi elekaki makasi, bato bayimaki-yimaki epai ya Moyize mpe balobaki : — Mpo na nini obimisaki biso na Ejipito ? Ezali mpo ete obomisa biso, bana na biso mpe bibwele na biso na posa ya mayi ? ");
INSERT INTO lin_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Moyize abelelaki Yawe : — Nasala nini mpo na bato oyo ? Etikali kaka moke ete babamba ngai mabanga ! ");
INSERT INTO lin_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Yawe azongiselaki Moyize : — Leka liboso ya bato, kamata ndambo ya bakambi ya Isalaele. Zwa na loboko na yo, lingenda oyo obetaki na ebale Nili, mpe kende. ");
INSERT INTO lin_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Ngai nakotelema kuna, liboso na yo, na likolo ya libanga oyo ezali na ngomba Orebi. Okobeta libanga yango, mpe yango ekobimisa mayi, bongo bato bakomela. Moyize asalaki bongo na miso ya bakambi ya Isalaele. ");
INSERT INTO lin_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Abengaki esika yango Masa mpe Meriba, pamba te bana ya Isalaele baswanisaki ye mpe bamekaki Yawe tango balobaki : « Boni, Yawe yango azali kati na biso to te ? » ");
INSERT INTO lin_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Bato ya Amaleki bayaki mpe babundisaki bana ya Isalaele na Refidimi. ");
INSERT INTO lin_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Moyize alobaki na Jozue : — Ponela biso bilombe ya bitumba kati na bato ; mpe lobi ; wana yo okende kobundisa bato ya Amaleki, ngai nakotelema na likolo ya ngomba moke elongo na lingenda ya Nzambe na loboko na ngai. ");
INSERT INTO lin_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Jozue asalaki ndenge Moyize atindaki ye mpe abundisaki bato ya Amaleki ; wana Moyize, Aron mpe Wuri bamataki likolo ya ngomba. ");
INSERT INTO lin_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Tango nyonso Moyize abandaki kotombola maboko na ye mpo na kobondela, bana ya Isalaele bazalaki kolonga ; kasi tango nyonso azalaki kokitisa maboko na ye, bato ya Amaleki bazalaki kolonga. ");
INSERT INTO lin_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Tango maboko ya Moyize elembaki, Aron mpe Wuri bakamataki libanga mpe batielaki ye yango mpo ete avandela yango ; mpe Moyize avandelaki yango. Aron mpe Uri batombolaki maboko na ye, moko na ngambo moko, mpe mosusu na ngambo mosusu. Boye maboko na ye etikalaki ya kosembolama kino na pokwa. ");
INSERT INTO lin_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Mpe Jozue alongaki basoda ya bato ya Amaleki na mopanga. ");
INSERT INTO lin_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Yawe alobaki na Moyize : — Koma yango na buku lokola ekaniseli, mpe loba na Jozue ete nakosilisa bato ya Amaleki na mokili ; bakotikala kokanisa bango lisusu te. ");
INSERT INTO lin_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Moyize atongaki etumbelo mpe abengaki yango « Nkolo azali bendele na ngai ya lokumu. » ");
INSERT INTO lin_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Moyize alobaki : « Lokola esali ete babundisi Kiti ya Bokonzi ya Yawe, Yawe akobundisa bato ya Amaleki tango nyonso. » ");
INSERT INTO lin_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Jetro, Nganga-Nzambe ya Madiani mpe bokilo ya Moyize, ayokaki makambo nyonso oyo Nzambe asalelaki Moyize mpe Isalaele, bato na Ye, mpe ndenge nini Yawe abimisaki Isalaele na Ejipito. ");
INSERT INTO lin_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Jetro amemaki Sefora, mwasi ya Moyize, oyo ye Moyize azongisaki nanu epai ya baboti na ye, ");
INSERT INTO lin_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","elongo na bana mibali mibale oyo Sefora abotelaki Moyize. Mwana ya liboso, kombo na ye ezalaki « Gerishomi, » pamba te Moyize amilobelaki : « Nakomaki mopaya kati na mokili ya mopaya ; » ");
INSERT INTO lin_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","mwana ya mibale, kombo na ye ezalaki « Eliezeri, » pamba te amilobelaki : « Nzambe ya tata na ngai asungaki ngai mpe akangolaki ngai wuta na mopanga ya Faraon. » ");
INSERT INTO lin_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Jetro, bokilo ya Moyize, elongo na bana mibali ya Moyize mpe mwasi ya Moyize bayaki epai ya Moyize, na esobe epai wapi batongaki molako pembeni ya ngomba ya Nzambe. ");
INSERT INTO lin_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Jetro atindelaki Moyize maloba oyo : — Ngai Jetro, bokilo na yo, nazali koya epai na yo elongo na mwasi na yo mpe bana na yo mibale ya mibali. ");
INSERT INTO lin_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Moyize abimaki mpo na kokutana na bokilo na ye ; agumbamaki liboso na ye mpe apesaki ye beze. Batunanaki basango ya moko na moko mpe bakotaki na ndako ya kapo. ");
INSERT INTO lin_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Moyize ayebisaki bokilo na ye makambo nyonso oyo Yawe asalaki Faraon mpe bato ya Ejipito mpo na kokangola Isalaele, pasi nyonso oyo bakutanaki na yango na nzela mpe ndenge nini Yawe abikisaki bango. ");
INSERT INTO lin_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Jetro asepelaki koyoka makambo wana nyonso ya kitoko oyo Yawe asalelaki bana ya Isalaele tango akangolaki bango wuta na maboko ya bato ya Ejipito. ");
INSERT INTO lin_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Jetro alobaki : — Tika ete Yawe akumisama, Ye oyo akangolaki yo wuta na maboko ya bato ya Ejipito mpe ya Faraon, Ye oyo akangolaki bato wuta na bowumbu ya bato ya Ejipito. ");
INSERT INTO lin_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Nandimi sik’oyo ete Yawe azali monene koleka banzambe nyonso, pamba te asali makambo ya lolenge oyo epai ya banyokoli ya Isalaele. ");
INSERT INTO lin_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Bongo Jetro, bokilo ya Moyize, abonzelaki Nzambe mbeka ya kotumba mpe bambeka mosusu. Aron elongo na bakambi nyonso ya Isalaele bayaki mpo na kolia lipa elongo na bokilo ya Moyize, na miso ya Nzambe. ");
INSERT INTO lin_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Mokolo oyo elandaki, Moyize avandaki mpo na kosambisa bato. Bato batelemaki liboso ya Moyize, kobanda na tongo kino na pokwa. ");
INSERT INTO lin_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Tango bokilo na ye amonaki makambo nyonso oyo Moyize azalaki kosala mpo na bato, alobaki : — Mpo na nini ozali kosala bongo tango ozali kotala makambo ya bato ? Mpo na nini ozali yo moko lokola mosambisi ? Mpo na nini bato oyo nyonso batelemi pembeni na yo, kobanda na tongo kino na pokwa ? ");
INSERT INTO lin_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Moyize azongiselaki ye : — Bayaka epai na ngai mpo na kotuna toli ya Nzambe. ");
INSERT INTO lin_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Soki bazali na kowelana, bayaka epai na ngai ; mpe ngai nakataka makambo, sima nalakisaka bango mibeko mpe bikateli ya Nzambe. ");
INSERT INTO lin_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Bokilo ya Moyize alobaki na ye : — Lolenge na yo ya kosala ezali malamu te. ");
INSERT INTO lin_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Okolemba noki elongo na bato oyo bazali koya epai na yo. Mosala oyo eleki makasi mpo na yo ; okolonga kosala yango yo moko te. ");
INSERT INTO lin_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Yoka sik’oyo toli oyo nalingi kopesa yo, mpe tika ete Nzambe azala na yo. Mosala na yo ezali : kozala molobeli ya bato liboso ya Nzambe, komema mikumba na bango epai ya Nzambe ");
INSERT INTO lin_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","mpe kolakisa bango bikateli elongo na mibeko oyo ekotalisa bango nzela ya kolanda mpe makambo oyo basengeli kosala. ");
INSERT INTO lin_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Mpe lisusu, kati na bato, pona mibali ya mayele, oyo batosaka Nzambe, oyo bato bakoki kotiela motema mpo ete basalelaka bosembo mpe bazwaka kanyaka te. Okotia bango lokola bakambi ya bato : bakambi ya bankoto, ya bankama, ya batuku mitano mpe ya bazomi. ");
INSERT INTO lin_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Okopesa bango mosala ya kosambisa bato tango nyonso mpe ndingisa ya kokata bango moko makambo ya mike ; kasi babanda komemela yo kaka makambo ya minene. Soki osali bongo, okozala lisusu na mokumba ya makasi te ; pamba te okokabola yango elongo na bango. ");
INSERT INTO lin_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Soki osaleli toli oyo napesi yo mpe soki Nzambe akambi yo, okolonga, mpe bato oyo nyonso bakobanda kozonga na esengo epai na bango. ");
INSERT INTO lin_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Moyize ayokaki toli oyo bokilo na ye apesaki ye mpe asalelaki makambo nyonso oyo alobaki. ");
INSERT INTO lin_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Moyize aponaki bato ya mayele kati na bana ya Isalaele mpe akomisaki bango bakambi ya bato : bakambi ya bankoto, ya bankama, ya batuku mitano mpe ya bazomi. ");
INSERT INTO lin_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Bazalaki tango nyonso kati na bato mpo na kosambisa bato mpe kokata makambo ; bazalaki kokata bango moko makambo ya mike, kasi bazalaki komema oyo ya minene epai ya Moyize. ");
INSERT INTO lin_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Moyize apesaki nzela ete bokilo na ye akende, mpe Jetro azongaki na mokili na ye. ");
INSERT INTO lin_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Sanza misato sima na bana ya Isalaele kobima na Ejipito, kaka na mokolo yango, bana ya Isalaele bakomaki na esobe ya Sinai. ");
INSERT INTO lin_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Tango balongwaki na Refidimi, bakotaki na esobe ya Sinai, mpe Isalaele atongaki kuna kati na esobe molako etalana na ngomba. ");
INSERT INTO lin_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Moyize amataki na ngomba mpo na kosolola na Nzambe ; mpe wuta na likolo ya ngomba, Yawe abengaki ye mpe alobaki na ye : — Tala makambo oyo okoyebisa bakitani ya Jakobi mpe oyo okotalisa na bana ya Isalaele : ");
INSERT INTO lin_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","« Bomonaki bino moko ndenge nini nasalaki bato ya Ejipito mpe ndenge nini namemaki bino lokola na mapapu ya mpongo kino epai na Ngai. ");
INSERT INTO lin_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Soki botosi Ngai penza mpe bobateli boyokani na Ngai, bokozala mpo na Ngai ekolo ya motuya kati na bikolo nyonso. Atako mokili mobimba ezali ya Ngai, ");
INSERT INTO lin_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","kasi bino bokozala mpo na Ngai ekolo oyo ekosala mosala ya bonganga-Nzambe, ekolo ya bule. » Oyo nde maloba okoyebisa bana ya Isalaele. ");
INSERT INTO lin_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Moyize azongaki, abengisaki bakambi ya Isalaele mpe ayebisaki bango maloba nyonso oyo Yawe atindaki ye koloba. ");
INSERT INTO lin_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Bato nyonso bazongisaki lokola moto moko : — Tokosala nyonso oyo Yawe alobi. Bongo Moyize amemaki eyano na bango epai na Yawe. ");
INSERT INTO lin_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Yawe alobaki na Moyize : — Nazali koya epai na yo kati na lipata monene, mpo ete bana ya Isalaele bayoka tango nakosolola na yo mpe mpo ete batia tango nyonso elikya na bango epai na yo. Moyize ayebisaki Yawe makambo nyonso oyo bana ya Isalaele balobaki. ");
INSERT INTO lin_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Yawe alobaki na Moyize : — Kende epai ya bato, bulisa bango lelo mpe lobi, bongo yebisa bango ete basukola bilamba na bango ; ");
INSERT INTO lin_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","bamibongisa mpo na mokolo ya misato, pamba te na mokolo wana nde Ngai Yawe, nakokita na likolo ya ngomba Sinai, na miso ya bana nyonso ya Isalaele. ");
INSERT INTO lin_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Okotia bandelo zingazinga ya ngomba mpo na bato mpe okoyebisa bango : « Bosala keba ete bomata te na ngomba oyo mpe bopusana te pembeni na yango. Moto nyonso oyo akotuta yango akokufa penza. ");
INSERT INTO lin_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Soki moto moko abuki mobeko oyo, bakosimba ye te, kasi bakoboma ye na mabanga to bakotobola ye likonga ; ezala moto to nyama, asengeli kokufa. Kaka soki lokito ya liseke ya meme eyokani makasi nde ndambo ya bato bakomata na ngomba. » ");
INSERT INTO lin_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Moyize alongwaki na ngomba, akendeki epai ya bana ya Isalaele, abulisaki bango, mpe basukolaki bilamba na bango. ");
INSERT INTO lin_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Moyize alobaki na bango : — Bomilengela mpo na mokolo ya misato, bosangisa nzoto te na basi na bino. ");
INSERT INTO lin_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Na tongo ya mokolo ya misato, bakake ebetaki, mikalikali ezalaki kongenga, mpe lipata monene ezipaki ngomba ; bongo bato bayokaki bakelelo kobeta makasi. Bato nyonso kati na molako balengaki. ");
INSERT INTO lin_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Moyize abimisaki bato mpo ete bakende kokutana na Nzambe, na libanda ya molako. Mpe bato batelemaki na ebandeli ya ngomba. ");
INSERT INTO lin_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Milinga ezipaki ngomba Sinai mpo ete Yawe akitaki na likolo na yango na lolenge ya moto, bongo milinga yango ezalaki komata lokola milinga oyo ebimaka na fulu ya moto. Mpe ngomba nyonso eninganaki makasi. ");
INSERT INTO lin_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Mongongo ya kelelo ezalaki kaka komata se komata. Boye Moyize abandaki koloba na Nzambe, mpe Nzambe azalaki koyanola ye na lokito ya kake. ");
INSERT INTO lin_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Yawe akitaki na likolo ya ngomba Sinai mpe abengaki Moyize mpo ete amata na songe ya ngomba yango. Boye Moyize amataki. ");
INSERT INTO lin_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Yawe alobaki na Moyize : — Kita mpe kebisa bato ete baleka bandelo te mpo na koluka komona Ngai Yawe, noki te mingi kati na bango bakokufa. ");
INSERT INTO lin_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Ezala Banganga-Nzambe oyo basengeli kopusana pene na Ngai, basengeli komibulisa ; noki te Ngai Yawe, nakoboma bango. ");
INSERT INTO lin_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Moyize alobaki na Yawe : — Bato ya Isalaele bakoki te komata na ngomba Sinai, pamba te Yo moko oyebisaki biso ete totia bandelo zingazinga ya ngomba mpe tomona yango lokola bule. ");
INSERT INTO lin_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Yawe azongiselaki ye : — Kita lisusu ; bongo omata elongo na Aron. Kasi mpo na Banganga-Nzambe mpe bana ya Isalaele, tika ete bawelela komata te epai na Ngai Yawe, noki te nakoboma bango. ");
INSERT INTO lin_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Moyize akitaki, akendeki epai ya bana ya Isalaele mpe ayebisaki bango makambo oyo Yawe alobaki. ");
INSERT INTO lin_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Tala maloba oyo Nzambe alobaki : ");
INSERT INTO lin_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","« Nazali Yawe, Nzambe na yo, oyo abimisaki yo wuta na mokili ya Ejipito epai wapi ozalaki na bowumbu. ");
INSERT INTO lin_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Okozalaka na banzambe mosusu te, bobele Ngai. ");
INSERT INTO lin_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Okomisalelaka te nzambe ya ekeko to bililingi ya biloko oyo ezali na likolo, na se to na mayi oyo ezali na se ya mabele. ");
INSERT INTO lin_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Okogumbamelaka yango te mpe okosalelaka yango te, pamba te Ngai Yawe, Nzambe na yo, nazali Nzambe ya zuwa ; napesaka bana etumbu mpo na masumu ya batata kino na molongo ya misato mpe ya minei ya bato oyo bayinaka Ngai. ");
INSERT INTO lin_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Kasi natalisaka bolingo na Ngai kino na molongo ya nkoto epai ya bato oyo balingaka Ngai mpe babatelaka mibeko na Ngai. ");
INSERT INTO lin_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Okotangaka te na pamba Kombo ya Yawe, Nzambe na yo, pamba te Yawe akopesa etumbu na moto nyonso oyo akotanga Kombo na Ye na pamba. ");
INSERT INTO lin_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Kanisaka mokolo ya Saba mpe bulisaka yango. ");
INSERT INTO lin_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Okosalaka misala na yo nyonso mikolo motoba. ");
INSERT INTO lin_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Kasi mokolo ya sambo ezali mokolo ya Saba ya Yawe, Nzambe na yo. Na mokolo wana, okosalaka mosala ata moko te ; ezala yo, mwana na yo ya mobali, mwana na yo ya mwasi, mowumbu na yo ya mobali, mwasi mowumbu na yo, bibwele na yo to mopaya oyo azali kati na bingumba na yo. ");
INSERT INTO lin_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Pamba te na mikolo motoba, Yawe asalaki Likolo, mabele, ebale monene mpe nyonso oyo ezali kati na yango, kasi akataki mosala na mokolo ya sambo. Yango wana, Yawe apambolaki mokolo ya Saba mpe abulisaki yango. ");
INSERT INTO lin_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Okopesaka tata na yo mpe mama na yo lokumu mpo ete ozala na bomoi ya molayi kati na mokili oyo Yawe, Nzambe na yo, azali kopesa yo. ");
INSERT INTO lin_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Okobomaka te. ");
INSERT INTO lin_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Okosalaka ekobo te. ");
INSERT INTO lin_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Okoyibaka te. ");
INSERT INTO lin_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Okolobaka te matatoli ya lokuta mpo na kokosela moninga na yo makambo. ");
INSERT INTO lin_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Okolulaka te ndako ya moninga na yo ; okolulaka te mwasi ya moninga na yo, mowumbu na ye ya mobali to mwasi mowumbu na ye, ngombe na ye, ane na ye to eloko nyonso oyo ezali ya moninga na yo. » ");
INSERT INTO lin_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Tango bato bayokaki bakake mpe koganga ya kelelo, mpe bamonaki mikalikali mpe milinga kobima na ngomba, balengaki. Batelemaki mosika ");
INSERT INTO lin_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","mpe balobaki na Moyize : — Tika ete yo moko oloba na biso, mpe tokoyoka yo ; kasi Nzambe te, noki te tokokufa ! ");
INSERT INTO lin_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Moyize azongiselaki bango : — Bobanga te ! Nzambe ayei nde komeka bino mpo ete kobanga Nzambe ezala kati na bino mpe bosala masumu te. ");
INSERT INTO lin_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Bato bazalaki kaka mosika, wana Moyize apusanaki pembeni ya lipata oyo kati na yango Nzambe azalaki. ");
INSERT INTO lin_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Yawe alobaki na Moyize : — Yebisa makambo oyo epai ya bana ya Isalaele : « Bomonaki bino moko ndenge nini nalobelaki bino wuta na likolo. ");
INSERT INTO lin_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Bokomisalela te banzambe ya bikeko ya palata to ya wolo, mpo na kosangisa yango na Ngai. ");
INSERT INTO lin_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Okotongela Ngai etumbelo ya mabele epai wapi okobonza bambeka na yo ya kotumba, bambeka na yo ya boyokani, meme na yo, ntaba na yo, ngombe na yo. Esika nyonso oyo nakomimonisa mpo na lokumu ya Kombo na Ngai, nakoya epai na yo mpe nakopambola yo. ");
INSERT INTO lin_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Soki otongeli Ngai etumbelo ya mabanga, okotonga yango te na mabanga oyo bakata ; pamba te soki okati yango, okobebisa bosantu na yango. ");
INSERT INTO lin_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Okomata te na etumbelo na Ngai na ematelo mpo ete bolumbu na yo emonana te. » ");
INSERT INTO lin_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Yawe alobaki na Moyize : — Tala mibeko oyo okoyebisa bana ya Isalaele : ");
INSERT INTO lin_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","« Soki bosombi Mo-Ebre moko lokola mowumbu, akosalela bino mibu motoba ; na mobu ya sambo, akozwa bonsomi mpe akofuta eloko moko te. ");
INSERT INTO lin_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Soki azalaki monzemba tango ayaki, asengeli kokende ye moko ; kasi soki azalaki na mwasi tango ayaki, mwasi na ye asengeli kokende na ye elongo. ");
INSERT INTO lin_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Soki nkolo na ye apesaki ye mwasi mpe mwasi yango abotelaki ye bana mibali to bana basi, mwasi mpe bana bakozala ya nkolo na ye ; mobali akokende ye moko. ");
INSERT INTO lin_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Kasi soki mowumbu alobi : ‹ Nalingaka nkolo na ngai, mwasi na ngai mpe bana na ngai, nalingi te kozwa bonsomi, › ");
INSERT INTO lin_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","wana nkolo na ye asengeli komema ye liboso ya basambisi ; akomema ye na ezipelo ya ekuke to na mabaya oyo esimbaka ekuke mpe akotobola ye litoyi na motonga ; mpe mowumbu akosalela nkolo yango mpo na libela. ");
INSERT INTO lin_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Soki moto ateki mwana na ye ya mwasi lokola mwasi mowumbu, mwana yango akozwa bonsomi te ndenge bawumbu bazwaka yango. ");
INSERT INTO lin_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Soki mwana mwasi asepelisi te nkolo oyo aponaki ye mpo ete azala mowumbu na ye, nkolo yango akotika ete mwana mwasi asikolama ; azali na ndingisa te ya koteka ye epai ya bapaya. Kasi soki ateki ye, wana asambwisi ye. ");
INSERT INTO lin_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Soki aponaki mwana mwasi yango mpo ete azala mwasi ya mwana na ye ya mobali, asengeli kokokisa makambo oyo mibeko esengaka mpo na kobala mwasi. ");
INSERT INTO lin_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Soki abali mwasi mosusu, akolongola eloko te na oyo etali kolia, kolata mpe oyo basalelaka mwasi ya libala. ");
INSERT INTO lin_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Soki apimeli ye ata eloko moko kati na biloko oyo misato, wana mwasi oyo akoki kokende na bonsomi mpe akofuta eloko moko te. ");
INSERT INTO lin_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Moto oyo akobeta moninga na ye kino koboma ye, basengeli koboma ye. ");
INSERT INTO lin_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Nzokande, soki azalaki na likanisi ya koboma te, kasi Nzambe atiki ete yango esalema na nzela ya maboko na ye, moto wana akokima na esika oyo Ngai Yawe nakopona. ");
INSERT INTO lin_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Kasi soki moto akaneli moninga na ye mpe aluki koboma ye na mayele mabe, okomema ye mosika ya etumbelo na Ngai mpo na koboma ye. ");
INSERT INTO lin_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Moto oyo akobeta tata to mama na ye, asengeli kozwa etumbu ya kufa. ");
INSERT INTO lin_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Moto oyo akokanga moto mosusu na makasi mpo na kokima na ye, ezala soki ateki moto yango to bakangi ye na moto yango na maboko, asengeli kozwa etumbu ya kufa. ");
INSERT INTO lin_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Moto oyo akolakela tata to mama na ye mabe, asengeli kozwa etumbu ya kufa. ");
INSERT INTO lin_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Soki bato baswani, bongo moko abeti moninga likofi to libanga ; mpe moto oyo babeti likofi to libanga akufi te kasi abeli makasi ; ");
INSERT INTO lin_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","soki moto oyo babeti atelemi mpe atamboli na nzete kino na libanda, bakokatela moto oyo abetaki ye etumbu te, kasi akofuta kaka mikolo oyo moto yango azalaki kosala te mpe akosalisa ye kino akobika. ");
INSERT INTO lin_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Soki moto abeti mowumbu na ye ya mobali to mwasi mowumbu na ye, bongo mowumbu yango akufi na mbala moko, moto wana asengeli kozwa etumbu. ");
INSERT INTO lin_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Kasi soki mowumbu yango awumeli lisusu na bomoi mokolo moko to mibale, wana nkolo na ye akozwa etumbu te, pamba te asombaki ye na mbongo. ");
INSERT INTO lin_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Soki mibali, wana bazali kobunda, batutani na mwasi ya zemi, bongo mwasi yango aboti mwana matsombe mpe likama mosusu emonani te, wana basengeli kofuta lomande ndenge mobali ya mwasi yango akokata kolanda mokano ya basambisi. ");
INSERT INTO lin_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Kasi soki likama ezali, okofuta bomoi mpo na bomoi : ");
INSERT INTO lin_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","liso mpo na liso, linu mpo na linu, loboko mpo na loboko, lokolo mpo na lokolo, ");
INSERT INTO lin_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","kozika mpo na kozika, pota mpo na pota, litutu mpo na litutu. ");
INSERT INTO lin_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Soki moto abeti mowumbu na ye ya mobali to mwasi mowumbu na ye na liso, mpe liso yango ekufi, moto yango akopesa bonsomi na mowumbu mpo na liso na ye. ");
INSERT INTO lin_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Soki abuki linu ya mowumbu na ye ya mobali to ya mwasi mowumbu na ye, akopesa ye bonsomi mpo na linu na ye. ");
INSERT INTO lin_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Soki ngombe ebomi moto na maseke, basengeli koboma ngombe yango na mabanga, mpe bakolia mosuni na yango te ; nzokande nkolo na yango akozwa etumbu te. ");
INSERT INTO lin_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Soki ngombe ezali na momesano ya kobeta bato maseke, bongo bakebisi makasi nkolo na yango, kasi ye abateli kaka ngombe na ye malamu te mpe yango ebomi moto ; basengeli koboma ngombe yango na mabanga mpe nkolo na yango asengeli kozwa etumbu ya kufa. ");
INSERT INTO lin_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Kasi soki basengi ye lomande mpo na kosikola bomoi na ye, akofuta nyonso oyo bakosenga ye. ");
INSERT INTO lin_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Bakosalela mpe mobeko oyo soki ngombe ebeti mwana mobali to mwana mwasi maseke. ");
INSERT INTO lin_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Soki ngombe ebeti mowumbu ya mobali to mwasi mowumbu maseke, nkolo na yango asengeli kofuta mbongo ya bibende, tuku misato, epai ya nkolo ya mowumbu, mpe bakobamba ngombe yango mabanga. ");
INSERT INTO lin_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Soki moto atiki libulu polele to atimoli libulu mpe azipi yango te, bongo ngombe to ane ezindi kuna ; ");
INSERT INTO lin_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","nkolo libulu asengeli kofuta epai ya nkolo nyama mbongo oyo ekokani na motuya ya nyama oyo esili kokufa, mpe nyama yango ekokoma ya ye. ");
INSERT INTO lin_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Soki ngombe ya moto moko ebomi ngombe ya moto mosusu, esengeli koteka ngombe oyo ezali na bomoi mpe kokabola na kati-kati mbongo mpe ngombe oyo esili kokufa. ");
INSERT INTO lin_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Kasi soki eyebani ete ngombe yango emesana kobeta bato maseke, bongo nkolo na yango abateli yango malamu te ; wana asengeli kofuta ngombe mpo na ngombe, mpe ngombe ya kokufa ekokoma ya ye. ");
INSERT INTO lin_vpl VALUES ("EX21_37","003_21_37","EXO","21","37","37","Soki moto ayibi ngombe moko to meme moko, bongo abomi yango to ateki yango ; asengeli kofuta bangombe mitano mpo na ngombe moko oyo ayibaki to bameme minei mpo na meme moko oyo ayibaki. ");
INSERT INTO lin_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Soki bakangi moto azali koyiba, bongo babeti ye mpe akufi ; mobomi akozwa etumbu te mpo na makila oyo esopani. ");
INSERT INTO lin_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Kasi soki makambo yango esalemi na moyi, moto oyo akoboma ye akozwa etumbu mpo na makila oyo esopani. Moyibi nyonso asengeli kozongisa biloko oyo ayibi. Soki azali na eloko te, bakoteka ye mpo na kofuta eloko oyo ayibaki. ");
INSERT INTO lin_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Soki ayibaki nyama, ezala ngombe, ane to meme, bongo bakuti nyama yango ya bomoi na maboko na ye, akofuta banyama mibale. ");
INSERT INTO lin_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Soki moto azali koleisa bibwele na ye matiti na elanga na ye to na elanga na ye ya vino, bongo atiki bibwele yango koyengayenga mpe ekeyi kolia matiti na elanga to na elanga ya vino ya moto mosusu, nkolo bibwele asengeli kofuta mbuma oyo eleki kitoko kati na elanga na ye to kati na elanga na ye ya vino. ");
INSERT INTO lin_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Soki moto apelisi moto, bongo moto yango ekutani na banzete ya sende, epanzani mpe ezikisi ble oyo basili kotia na maboke to ble oyo babuki nanu te, moto oyo apelisaki moto asengeli kofuta biloko nyonso oyo eziki. ");
INSERT INTO lin_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Soki moto abombisi palata to biloko na ye ya motuya epai ya moninga na ye, bongo bayibi yango kati na ndako ya moninga wana ; soki bakangi moyibi ya biloko yango, akozongisa mbala mibale biloko oyo ayibaki. ");
INSERT INTO lin_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Kasi soki moyibi amonani te, nkolo ndako asengeli kosamba liboso ya basambisi mpo na koyeba soki ayibaki biloko ya moninga na ye to te. ");
INSERT INTO lin_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Na likambo nyonso ya moyibi, soki bato mibale bazali kowela ngombe, ane, meme, elamba to eloko nyonso oyo ebungaki, bongo moto na moto azali koloba : ‹ Ezali ya ngai ! › bango mibale bakomema likambo na bango liboso ya basambisi ; bongo moto oyo basambisi bakokweyisa akozongisa yango mbala mibale epai ya moninga na ye. ");
INSERT INTO lin_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Soki moto apesi moninga na ye ngombe to ane to meme to nyama mosusu mpo ete abokola, bongo nyama yango ekufi to ebukani to bayibi yango mpe ata moto moko te amoni mpo na kotatola ndenge nini likambo yango esalemaki, ");
INSERT INTO lin_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","kaka ndayi oyo balapi na Kombo na Yawe nde ekokabola bango : Moto oyo andimaki kobokola akolapa ndayi liboso ya Yawe mpo na kotalisa ete ayebi likambo te. Bongo nkolo nyama asengeli kondima maloba ya moninga na ye mpe ye akofuta nyama yango te. ");
INSERT INTO lin_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","Kasi soki bayibi nyama yango na maboko ya moto oyo andimaki kobokola yango, akofuta nyama yango epai ya nkolo na yango. ");
INSERT INTO lin_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Soki ezali nyama ya zamba nde ebomaki nyama yango, moto oyo andimaki kobokola yango akomema lokola litatoli biteni oyo etikali ; bongo akofuta nyama yango te. ");
INSERT INTO lin_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Soki moto adefi nyama epai ya moninga na ye, bongo ebukani lokolo to ekufi na tango oyo nkolo na yango azali te, moto wana asengeli kofuta yango. ");
INSERT INTO lin_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Nzokande soki nkolo na yango azalaki wana, moto oyo adefaki akofuta nyama yango te. Soki bayokanaki ete akofuta mbongo sima na kosalela yango, asengeli kofuta mbongo oyo bayokanaki. ");
INSERT INTO lin_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Soki mobali alingi elenge mwasi oyo ayebi nanu nzoto ya mibali te mpe azali na mobandami na libala te, bongo asangisi na ye nzoto, asengeli kofuta mbongo ya libala mpo ete akoma mwasi na ye. ");
INSERT INTO lin_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Soki tata ya elenge mwasi aboyi kopesa mwana na ye na libala epai ya mobali wana, mobali yango akofuta mbongo ya libala na motuya oyo babalelaka elenge mwasi oyo ayebi nanu nzoto ya mibali te. ");
INSERT INTO lin_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Okotika te na bomoi mwasi oyo asalaka maji. ");
INSERT INTO lin_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Moto nyonso oyo akosangisa nzoto na nyama, asengeli kozwa etumbu ya kufa. ");
INSERT INTO lin_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Moto nyonso oyo akotumba mbeka mpo na nzambe mosusu, basengeli koboma ye ; mbeka ekotumbama kaka mpo na Yawe Ye moko. ");
INSERT INTO lin_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Okosalisa mopaya mosala na ndenge ya mabe te mpe okonyokola ye te, pamba te bino mpe bozalaki bapaya na Ejipito. ");
INSERT INTO lin_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Bokonyokola te mwasi oyo akufisa mobali to mwana etike. ");
INSERT INTO lin_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Soki bonyokoli bango, bongo bango bagangi epai na Ngai, solo nakoyoka koganga na bango. ");
INSERT INTO lin_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Nakosilikela bino, nakoboma bino na mopanga ; bongo basi na bino mpe bakokoma basi bakufisa mibali mpe bana na bino, bana bitike. ");
INSERT INTO lin_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Soki odefisi mbongo na moko kati na bato na Ngai, na mobola oyo azali kati na bino, okosala te ndenge modefisi mbongo asalaka ; okosenga ye mileki te. ");
INSERT INTO lin_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Soki moninga na yo asimbisi yo kazaka na ye lokola ndanga, okozongisela ye yango liboso ete butu eya ; ");
INSERT INTO lin_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","pamba te azali kaka na kazaka wana mpo na kofinika nzoto na ye. Akofinika lisusu nini tango akolala ? Soki agangi epai na Ngai, nakoyoka ye mpo ete nazali Nzambe ya mawa. ");
INSERT INTO lin_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Okofingaka Nzambe te mpe okolakelaka mokambi ya bato na yo mabe te. ");
INSERT INTO lin_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Okowumisa te kopesa Ngai mbuma ya liboso oyo ekomela mpe vino oyo okamoli. Okopesa Ngai mwana na yo ya liboso ya mobali. ");
INSERT INTO lin_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Okosala mpe lolenge moko mpo na bana liboso ya bangombe, bameme mpe bantaba na yo : ekotikala mikolo sambo elongo na bamama na yango ; bongo na mokolo ya mwambe, okopesa Ngai yango. ");
INSERT INTO lin_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Bokozala bule mpo na Ngai : bokolia te mosuni ya nyama oyo babomi na nyama ya zamba ; bosengeli kopesa yango na bambwa. ");
INSERT INTO lin_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Okopanza sango ya lokuta te ; okosangana te na moto mabe mpo na koloba litatoli ya lokuta. ");
INSERT INTO lin_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Okolanda ebele ya bato te mpo na kosala mabe. Tango okoloba litatoli liboso ya basambisi, okotatola te kolanda mokano ya bato ebele mpo na kokweyisa bosembo. ");
INSERT INTO lin_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Okokotela mobola te na tango azali kosamba liboso ya basambisi. ");
INSERT INTO lin_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Soki okutani na ngombe to ane ya monguna na yo, oyo ebungi, osengeli kozongisela ye yango. ");
INSERT INTO lin_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Soki omoni ane ya moto oyo ayinaka yo ekweyi na se ya mokumba oyo yango ememi, okotika yango wana te ; osengeli kosalisa yango. ");
INSERT INTO lin_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Okokweyisa bosembo ya mobola te tango azali kosamba liboso ya basambisi. ");
INSERT INTO lin_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Okozala mosika ya makambo ya lokuta. Okoboma te ezala moto oyo ayebi likambo te to moto ya sembo ; pamba te nalongisaka te moto mabe. ");
INSERT INTO lin_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Okondimaka kanyaka te, pamba te kanyaka ezipaka miso ya bato oyo bamonaka malamu mpe ebebisaka maloba ya moto ya sembo. ");
INSERT INTO lin_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Okonyokola mopaya te, pamba te oyebi yo moko ndenge ezalaka soki ozali mopaya ; bino mpe bozalaki bapaya na Ejipito. ");
INSERT INTO lin_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Mibu motoba, okolona bilanga na yo mpe okobuka mbuma. ");
INSERT INTO lin_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Kasi na mobu ya sambo, okopemisa mabele. Boye babola kati na bato na yo bakozwa bilei ya kolia kati na yango mpe nyama ya zamba ekolia bilei oyo bato bakotika. Okosala ndenge moko mpo na elanga na yo ya vino mpe mpo na nzete na yo ya olive. ");
INSERT INTO lin_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Mikolo motoba, okosala mosala na yo ; kasi na mokolo ya sambo, okosala mosala moko te mpo ete ngombe na yo elongo na ane na yo ekoka kopema, mpe mpo ete mwana mobali ya mwasi mowumbu na yo mpe mopaya bazwa lisusu makasi. ");
INSERT INTO lin_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Bokosala keba na makambo nyonso oyo nayebisi bino. Bokobelela kombo ya banzambe mosusu te ; bokomeka kutu te kotanga yango na bibebu na bino. ");
INSERT INTO lin_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Mbala misato na mobu, bokosala bafeti misato mpo na Ngai. ");
INSERT INTO lin_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Bokosala feti ya Mapa ezanga levire. Na mikolo sambo kolanda ndenge napesaki bino mitindo, bokolia mapa ezanga levire na tango oyo ekatama, na sanza ya Abibi, mpo ete ezali na sanza yango nde bobimaki na Ejipito. ");
INSERT INTO lin_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Okosala feti ya kobuka bambuma, okosala mpe feti ya bambuma ya liboso ya bilanga na yo, oyo olonaki. Na suka ya mobu, okosala feti ya kobuka bambuma tango okobuka mbuma ya elanga. ");
INSERT INTO lin_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Mbala misato na mobu, bato nyonso bakoya liboso ya Nkolo Yawe. ");
INSERT INTO lin_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Okobonzela Ngai te mbeka ya makila elongo na mapa batia levire. Mafuta ya nyama ya feti na Ngai ekoki kobombama te kino na tongo. ");
INSERT INTO lin_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Okomema na Ndako ya Yawe, Nzambe na yo, bambuma ya liboso ya mabele na yo. Okolamba te mwana ntaba oyo ezali nanu komela mabele ya mama na yango. ");
INSERT INTO lin_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Nakotinda anjelu liboso na bino mpo ete abatela bino na nzela mpe amema bino na esika oyo nabongisaki mpo na bino. ");
INSERT INTO lin_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Bosala keba na miso na ye mpe boyoka makambo oyo akoloba ; botombokela ye te mpo ete akolimbisa botomboki na bino te, pamba te Kombo na Ngai ezali kati na ye. ");
INSERT INTO lin_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Kasi soki boyoki na bokebi makambo oyo akoyebisa bino mpe soki bosaleli nyonso oyo nalobi, nakozala monguna ya banguna na bino mpe nakotelemela bato oyo bakotelemela bino. ");
INSERT INTO lin_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Anjelu na Ngai akotambola liboso na bino mpe akokotisa bino na mokili ya bato ya Amori, ya bato ya Iti, ya bato ya Perizi, ya bato ya Kanana, ya bato ya Evi mpe ya bato ya Yebusi ; bongo Ngai nakosilisa bango. ");
INSERT INTO lin_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Bokogumbamela banzambe na bango te mpe bokosalela yango te to bokolanda te lolenge na bango ya kosalela. Bokokweyisa banzambe yango mpe bokobuka-buka bikeko na bango na biteni. ");
INSERT INTO lin_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Soki bokosalela Yawe, Nzambe na bino, akopambola mapa mpe mayi na bino, mpe akolongola bokono kati na bino. ");
INSERT INTO lin_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Na mboka na bino, ekozala na mwasi moko te oyo akosopa zemi to akozanga kobota. Nakobakisela bino mikolo ebele na bomoi na bino. ");
INSERT INTO lin_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Nakotinda somo na Ngai liboso na bino mpe nakokotisa mobulu kati na bikolo nyonso oyo bokokota. Banguna na bino nyonso bakopesa bino mokongo mpe bakokima. ");
INSERT INTO lin_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Nakotinda banzoyi ya minene liboso na bino mpo na kobengana bato ya Evi, ya Kanana mpe ya Iti na liboso na bino. ");
INSERT INTO lin_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Kasi nakobengana bango te na mbala moko mpo ete mboka ekoma te lokola ndako ezanga bato, mpe mpo ete banyama ya zamba ekoma mingi te mpo na kotungisa bino. ");
INSERT INTO lin_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Nakobengana bango moke-moke liboso na bino kino bokokoma ebele mpo na kozwa mboka. ");
INSERT INTO lin_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Nakotia bandelo na bino kobanda na ebale monene ya barozo kino na ebale monene ya bato ya Filisitia mpe kobanda na esobe ya Sinai kino na ebale Efrate ; pamba te nakopesa bato ya mboka na maboko na bino, bongo bino bokobengana bango liboso na bino. ");
INSERT INTO lin_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Bokosala boyokani te elongo na bango mpe elongo na banzambe na bango. ");
INSERT INTO lin_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Botika bango te ete bawumela na mokili na bino, noki te bakotinda bino kosala masumu liboso na Ngai mpe kosalela banzambe na bango ; pamba te ekozala solo motambo mpo na bino. » ");
INSERT INTO lin_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Yawe alobaki na Moyize : — Mata epai na Yawe, yo elongo na Aron, Nadabi, Abiyu mpe bakambi tuku sambo ya Isalaele ; bokogumbama na mosika. ");
INSERT INTO lin_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Moyize kaka nde asengeli kopusana pene ya Yawe ; kasi bato mosusu te. Lisanga mobimba ya Isalaele mpe ekomata te elongo na ye. ");
INSERT INTO lin_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Tango Moyize akendeki koyebisa bato makambo mpe mibeko nyonso ya Yawe, bato bazongisaki elongo : — Tokosala makambo nyonso oyo Yawe alobi. ");
INSERT INTO lin_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Moyize akomaki maloba nyonso oyo Yawe ayebisaki ye. Mokolo oyo elandaki, alamukaki na tongo makasi mpe atongaki etumbelo na ebandeli ya ngomba. Bongo, atelemisaki mabanga zomi na mibale oyo ezali kotalisa mabota zomi na mibale ya Isalaele. ");
INSERT INTO lin_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Atindaki bilenge mibali ya Isalaele ete babonzela Yawe mbeka ya kotumba ya bangombe ya mibali lokola mbeka ya boyokani. ");
INSERT INTO lin_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Moyize azwaki ndambo ya makila, atiaki yango na sani ; bongo ndambo mosusu, abwakaki-bwakaki yango na likolo ya etumbelo. ");
INSERT INTO lin_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Azwaki lisusu buku ya Boyokani mpe atangaki yango liboso ya bana ya Isalaele. Boye bango bazongisaki : — Tokosala makambo nyonso oyo Yawe alobi mpe tokotosa yango. ");
INSERT INTO lin_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Moyize azwaki makila, abwakelaki-bwakelaki yango bato mpe alobaki : — Oyo ezali makila ya boyokani oyo Yawe asali elongo na bino kolanda maloba oyo nyonso. ");
INSERT INTO lin_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Sima na yango, Moyize elongo na Aron, Nadabi, Abiyu mpe bakambi tuku sambo ya Isalaele, bamataki likolo ya ngomba ");
INSERT INTO lin_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","epai wapi bamonaki Nzambe ya Isalaele ; se ya matambe na Ye ezalaki lokola mabanga ya talo ya safiri mpe ezalaki na langi ya ble ya kitoko lokola ble ya likolo. ");
INSERT INTO lin_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Kasi Nzambe asembolaki loboko na Ye te mpo na kobeta bakambi ya Isalaele ; bamonaki Nzambe, baliaki mpe bamelaki. ");
INSERT INTO lin_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Yawe alobaki na Moyize : « Yaka pene na Ngai na likolo ya ngomba mpe telema wana. Ngai nakopesa yo bitando ya mabanga ya papala oyo na likolo na yango nakomi Mobeko mpe mitindo mpo na kopesa bana ya Isalaele malako. » ");
INSERT INTO lin_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Boye Moyize atelemaki elongo na mosungi na ye Jozue mpe amataki na ngomba ya Nzambe. ");
INSERT INTO lin_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Moyize alobaki na bakambi : « Bozela biso awa kino tokozonga. Aron mpe Wuri bazali elongo na bino. Tika ete soki moto azali na likambo, ayebisa bango yango. » ");
INSERT INTO lin_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Tango Moyize amataki likolo ya ngomba, mapata ezipaki ye ");
INSERT INTO lin_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","mpe nkembo ya Yawe ewumelaki na likolo ya ngomba Sinai. Mikolo motoba, mapata ezipaki ngomba. Bongo na mokolo ya sambo, Yawe abengaki Moyize kati na mapata. ");
INSERT INTO lin_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Na miso ya bana ya Isalaele, Nkembo ya Yawe emonanaki na likolo ya ngomba lokola moto oyo etumbaka. ");
INSERT INTO lin_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Tango Moyize amataki likolo ya ngomba, akotaki kati na mapata. Awumelaki kuna mikolo tuku minei mpe babutu tuku minei. ");
INSERT INTO lin_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","— Yebisa bana ya Isalaele ete bamemela Ngai makabo. Okozwa yango na maboko ya moto nyonso oyo akopesa na motema malamu. ");
INSERT INTO lin_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Tala makabo oyo okozwa na maboko na bango : wolo, palata mpe bronze, ");
INSERT INTO lin_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","bilamba ya langi ya ble, ya motane, ya motane makasi, lino ya kitoko, bapwale ya ntaba, ");
INSERT INTO lin_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","baposo ya bameme batia langi ya motane mpe baposo ya banyama ya ebale, banzete ya akasia, ");
INSERT INTO lin_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","mafuta ya olive mpo na kopelisela mwinda, biloko ya mike-mike ya solo kitoko mpo na kosala mafuta ya epakolami mpe malasi ya solo kitoko ; ");
INSERT INTO lin_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","mabanga ya onikisi mpe mabanga mosusu ya talo mpo na kotia yango na efode mpe na elamba ya tolo oyo Nganga-Nzambe akobanda kolata. ");
INSERT INTO lin_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Bakosalela Ngai Ndako ya bule, mpe nakovanda kati na bango. ");
INSERT INTO lin_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Bokosala yango kolanda lolenge ya Mongombo mpe bisalelo oyo nakolakisa yo. ");
INSERT INTO lin_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Bokosala sanduku na nzete ya akasia. Molayi na yango ekozala na basantimetele pene nkama moko na tuku mibale na mitano ; mokuse na yango, basantimetele tuku sambo na mitano mpe bosanda na yango, basantimetele tuku sambo na mitano. ");
INSERT INTO lin_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Okobamba yango wolo ya peto, na kati mpe na libanda. Okolatisa mpe songe na yango na wolo. ");
INSERT INTO lin_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Okosalela yango bapete minei ya wolo mpe okotia yango na basonge minei : mibale na ngambo moko, mpe mibale na ngambo mosusu. ");
INSERT INTO lin_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Okosala mabaya mibale na nzete ya akasia mpe okobamba yango wolo. ");
INSERT INTO lin_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Okokotisa mabaya yango na bapete oyo ezali na songe ya sanduku, mpo na komemela yango. ");
INSERT INTO lin_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Mabaya yango ekotikala libela kati na bapete ya sanduku : bakolongola yango te. ");
INSERT INTO lin_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Okotia kati na sanduku bitando ya mabanga ya mibeko, oyo nakopesa yo. ");
INSERT INTO lin_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Okosala mofinuku na wolo ya peto. Molayi na yango ekozala na basantimetele pene nkama moko na tuku mibale na mitano ; mpe mokuse na yango, basantimetele pene tuku sambo na mitano. ");
INSERT INTO lin_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Okosala bikeko mibale ya basheribe oyo okotia na suka mibale ya mofinuku ; okosala yango na wolo oyo batuti na nzela ya marto. ");
INSERT INTO lin_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Okotia ekeko moko ya sheribe na suka moko, mpe mosusu, na suka mosusu. Okokangisa bikeko ya basheribe na mofinuku, na suka nyonso mibale. ");
INSERT INTO lin_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Mapapu ya basheribe ekozala ya kofungwama na likolo mpo na kobatela mofinuku ; bakozala ngambo na ngambo, mpe miso na bango ekotala mofinuku. ");
INSERT INTO lin_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Okotia kati na sanduku, bitando ya mabanga ya mibeko oyo nakopesa yo mpe okotia mofinuku na likolo ya sanduku. ");
INSERT INTO lin_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Ezali wana, na likolo ya mofinuku nde Ngai nakomimonisa epai na yo, na kati-kati ya basheribe mibale oyo bakozala na likolo ya Sanduku ya Litatoli ; mpe nakopesa yo mitindo na Ngai nyonso mpo na bana ya Isalaele. ");
INSERT INTO lin_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Okosala mesa moko na mabaya ya akasia. Molayi na yango ekozala na basantimetele pene nkama moko ; mokuse na yango, basantimetele pene tuku mitano mpe bosanda na yango, basantimetele pene tuku sambo na mitano. ");
INSERT INTO lin_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Okobamba yango wolo ya peto mpe okotia lisusu wolo na pembeni na yango. ");
INSERT INTO lin_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Okozingela mesa yango na libaya oyo ekozala na basantimetele pene mwambe na monene, mpe okotia wolo na pembeni ya libaya yango. ");
INSERT INTO lin_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Okosala bapete minei ya wolo mpe okotia yango na songe minei ya mesa epai wapi makolo na yango ezali. ");
INSERT INTO lin_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Bapete ekozala pene ya libaya oyo ekozingela mesa, mpe bakokotisa kati na bapete yango mabaya ya komemela sanduku. ");
INSERT INTO lin_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Okosala na nzete ya akasia mabaya ya komemela mesa mpe okobamba yango wolo. ");
INSERT INTO lin_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Okosala na wolo ya peto basani, bakopo, bambilika mpe bambeki, mpo na makabo ya masanga. ");
INSERT INTO lin_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Okotia tango nyonso mapa na likolo ya mesa liboso na Ngai. ");
INSERT INTO lin_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Okosala na wolo ya peto etelemiselo ya minda ; okosala yango na wolo oyo batuti na nzela ya marto. Evandelo na yango, likonzi na yango, bakeni na yango, bambuma mpe bafololo na yango, nyonso ekozala ekangana lokola eloko moko. ");
INSERT INTO lin_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Mipanzi ya likonzi ya etelemiselo ya minda esengeli kozala na bitape motoba : misato na ngambo moko, mpe misato na ngambo mosusu. ");
INSERT INTO lin_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Na likolo ya etape moko na moko ya etelemiselo ya minda, okotia bakeni misato oyo ezali na lolenge ya fololo ya madame, elongo na bambuma mpe bafololo. ");
INSERT INTO lin_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Na moto ya likonzi ya etelemiselo ya minda, esengeli kozala na bakeni minei oyo ezali na lolenge ya bafololo ya madame, elongo na bambuma mpe bafololo. ");
INSERT INTO lin_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Na se ya bitape mibale-mibale ya etelemiselo ya minda, ekozala na mbuma moko ; mpe ekozala bongo mpo na bitape nyonso motoba ya etelemiselo ya minda. ");
INSERT INTO lin_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Bambuma mpe bitape ekozala ekangana na etelemiselo ya minda ; mpe nyonso ekosalema na wolo ya peto, wolo oyo batuti na nzela ya marto. ");
INSERT INTO lin_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Okosala minda sambo oyo okotia na likolo ya etelemiselo ya minda mpo ete epesa pole na etando oyo ezali na liboso ya etelemiselo. ");
INSERT INTO lin_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Okosala na wolo ya peto bibende oyo bazwelaka makala ya moto mpe basani ya putulu. ");
INSERT INTO lin_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Okosalela bakilo tuku misato na minei ya wolo ya peto mpo na kosala etelemiselo ya minda mpe bisalelo na yango nyonso. ");
INSERT INTO lin_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Tala malamu mpe sala mosala nyonso kolanda ndakisa oyo natalisi yo na likolo ya ngomba. ");
INSERT INTO lin_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Okotonga Mongombo elongo na batapi zomi ya lino ya kitoko oyo bakotonga bililingi na likolo na yango, ya langi ya ble, ya motane ya pete mpe ya motane makasi, elongo na basheribe ; ekozala mosala ya bato oyo basalaka bililingi na maboko. ");
INSERT INTO lin_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Tapi moko na moko ekozala na bametele pene zomi na minei na molayi ; mpe bametele pene mibale, na mokuse. Batapi nyonso ekozala ndenge moko na mokuse mpe na molayi. ");
INSERT INTO lin_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Okokangisa batapi mitano, moko na mosusu, mpe okosala ndenge moko mpo na batapi mitano mosusu. ");
INSERT INTO lin_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Okotia basinga ya langi ya ble na pembeni ya tapi ya suka ya lisanga ya batapi mitano ya liboso, mpe na pembeni ya tapi ya suka ya lisanga ya batapi mitano ya mibale. ");
INSERT INTO lin_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Okotia basinga tuku mitano na suka ya lisanga ya batapi mitano ya liboso, mpe na suka ya lisanga ya batapi mitano ya mibale ; basinga yango ekotalana. ");
INSERT INTO lin_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Okosala na wolo bibende tuku mitano oyo ezali lokola ndobo ; mpe okokangisa na bibende oyo ezali lokola ndobo lisanga ya batapi mitano ya liboso mpe lisanga ya batapi mitano ya mibale. Na boye, Mongombo ekobima eloko moko. ");
INSERT INTO lin_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Okosala batapi zomi na moko na bapwale ya ntaba mpo na kotia yango na likolo ya Mongombo. ");
INSERT INTO lin_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Molayi ya tapi moko na moko ekozala na bametele pene zomi na mitano, mpe mokuse na yango ekozala na bametele pene mibale. Batapi nyonso zomi na moko ekozala ndenge moko na mokuse mpe na molayi. ");
INSERT INTO lin_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Okokangisa batapi mitano na ngambo moko, mpe batapi motoba na ngambo mosusu ; mpe okogumba tapi ya motoba na liboso ya Mongombo. ");
INSERT INTO lin_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Okotia basinga tuku mitano na suka ya liboke ya batapi ya liboso, mpe basinga tuku mitano na suka ya liboke ya batapi ya mibale. ");
INSERT INTO lin_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Okosala na bronze bibende tuku mitano oyo ezali lokola ndobo ; okokotisa yango na basinga mpo na kokangisa Mongombo mpo ete ekoma eloko moko. ");
INSERT INTO lin_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Batapi oyo ekozala na likolo ya Mongombo ekoleka molayi mpe ndambo na yango ekokita na sima ya Mongombo. ");
INSERT INTO lin_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Mpe na molayi ya batapi oyo ezali na likolo ya Mongombo, basantimetele pene tuku mitano ekolekana na bangambo mibale ya Mongombo mpo na kozipa yango. ");
INSERT INTO lin_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Okosalela baposo ya bameme oyo bapakola langi ya motane mpo na kozipa Mongombo, mpe okobakisa na likolo na yango baposo ya banyama ya ebale. ");
INSERT INTO lin_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Okosala bizingelo ya Mongombo na banzete ya akasia mpe okotelemisa yango. ");
INSERT INTO lin_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Ezingelo moko na moko ekozala na bametele mitano na molayi, mpe basantimetele tuku sambo na mitano na mokuse. ");
INSERT INTO lin_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Okobeta banzete mibale-mibale na ezingelo ; okosala bongo mpo na bizingelo nyonso ya Mongombo. ");
INSERT INTO lin_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Okotia bizingelo tuku mibale na ngambo ya Negevi, na sude ; ");
INSERT INTO lin_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","mpe makolo tuku minei ya palata na se ya bizingelo tuku mibale : makolo mibale na se ya ezingelo moko na moko oyo babeta banzete mibale ; ");
INSERT INTO lin_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","bizingelo tuku mibale na ngambo mosusu ya Mongombo, na nor, ");
INSERT INTO lin_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","elongo na makolo na yango tuku minei ya palata : makolo mibale mpo na ezingelo moko na moko ; ");
INSERT INTO lin_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","bizingelo motoba na suka ya Mongombo, na ngambo ya weste, ");
INSERT INTO lin_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","mpe bizingelo mibale na suka mpo na kolendisa Mongombo. ");
INSERT INTO lin_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Bizingelo yango ekozala ya kofungwama na se, kasi ekosala songe na likolo mpe ekokota na lopete ya liboso : nyonso mibale ekozala ndenge moko mpe ekolendisa Mongombo. ");
INSERT INTO lin_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Boye, bizingelo ekozala mwambe elongo na makolo na yango zomi na motoba ya palata : makolo mibale-mibale na se ya ezingelo moko na moko. ");
INSERT INTO lin_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Sima, okosala, na nzete ya akasia, mabaya mitano mpo na bizingelo ya ngambo moko ya Mongombo, ");
INSERT INTO lin_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","mabaya mitano mpo na bizingelo ya ngambo mosusu ya Mongombo, mabaya mitano mpo na bizingelo oyo ekozala na suka ya Mongombo, na ngambo ya weste. ");
INSERT INTO lin_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Libaya ya kati ekoleka na kati-kati ya bizingelo, ekoleka ngambo na ngambo. ");
INSERT INTO lin_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Okobamba wolo na bizingelo, okosala bapete na yango na wolo mpo na kolekisa mabaya ; mpe okobamba mabaya wolo. ");
INSERT INTO lin_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Okotonga Mongombo ndenge kaka balakisaki yo yango na likolo ya ngomba. ");
INSERT INTO lin_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Okosala rido ya langi ya ble, ya motane ya pete, ya motane makasi, mpe na lino ya kitoko oyo bakotonga bililingi na likolo na yango, elongo na basheribe ; ekozala mosala ya bato oyo basalaka bililingi na maboko. ");
INSERT INTO lin_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Okotia yango na makonzi minei ya nzete ya akasia, oyo bapakola wolo ; okokangisa yango na bibende ya wolo oyo ezali lokola ndobo mpe okotelemisa yango na makolo minei ya palata. ");
INSERT INTO lin_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Okokangisa rido na bibende oyo ezali lokola ndobo mpe okotia Sanduku ya Litatoli na sima ya rido yango. Rido nde ekokabola Esika ya bule mpe Esika-Oyo-Eleki-Bule. ");
INSERT INTO lin_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Kati na Esika-Oyo-Eleki-Bule, okotia mofinuku na likolo ya Sanduku ya Litatoli. ");
INSERT INTO lin_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Okotia mesa na liboso ya rido, na ngambo ya nor ya Mongombo, mpe okotia etelemiselo ya minda na liboso ya mesa, na ngambo ya sude. ");
INSERT INTO lin_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Mpo na ekotelo ya Ndako ya kapo, okosala rido ya langi ya ble, ya motane ya pete, ya motane makasi mpe na lino ya kitoko oyo bakotonga bililingi na likolo na yango ; ekozala mosala ya bato oyo batongaka bililingi na bilamba. ");
INSERT INTO lin_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Okosala na wolo, bibende mitano oyo ezali lokola ndobo mpo na kokangisela rido mpe banzete mitano ya akasia babamba wolo ; okosala makolo mitano ya bronze mpo na kotelemisela banzete yango. ");
INSERT INTO lin_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Okosala na mabaya ya nzete ya akasia etumbelo : ekozala ndenge moko na molayi mpe na mokuse, bametele mibale na basantimetele tuku mitano ; bongo bosanda na yango ekozala ya metele moko na basantimetele tuku mitano. ");
INSERT INTO lin_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Okosala maseke minei na basonge nyonso minei ya etumbelo, mpo ete maseke mpe etumbelo esala eloko moko ; mpe okobamba bronze na etumbelo. ");
INSERT INTO lin_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Okosala na bronze banzungu ya mike mpo na kolongola putulu ya moto, bapawu, basani ya minene, bakanya mpe basani mpo na komema makala ya moto. ");
INSERT INTO lin_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Okosala motalaka ya bronze mpo na etumbelo ; okokangisa bapete minei ya bronze, na basonge nyonso minei ya motalaka. ");
INSERT INTO lin_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Okotia motalaka na se ya etumbelo, na bandelo na yango, mpo ete ekoma na kati-kati ya etumbelo. ");
INSERT INTO lin_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Okosala na nzete ya akasia, mabaya mpo na etumbelo mpe okobamba yango bronze. ");
INSERT INTO lin_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Boye, mpo na komema etumbelo, bakokotisa mabaya yango na bapete oyo ezali na basonge mibale ya etumbelo. ");
INSERT INTO lin_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Okosala etumbelo na mabaya ; ekozala polele kati na yango. Okosala yango ndenge kaka balakisaki yo na ngomba. ");
INSERT INTO lin_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Tala ndenge okotonga lopango ya Mongombo : ngambo ya sude oyo ekozala ya bametele pene tuku mitano na molayi, ekozipama na rido ya lino ya kitoko oyo bakotonga bililingi na likolo na yango. ");
INSERT INTO lin_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Makonzi na yango tuku mibale elongo na makolo na yango tuku mibale ekosalema na bronze ; bongo bibende ya makonzi elongo na biloko na yango ya kosimbela ekozala ya palata. ");
INSERT INTO lin_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Ngambo ya nor ekozala na bametele pene tuku mitano na molayi. Ekozala mpe na barido, na makonzi tuku mibale mpe na makolo tuku mibale, oyo esalema na bronze. Makonzi yango ekozala na bibende ya palata egumbama lokola ndobo elongo na biloko na yango ya kosimbela, oyo ekozala ya palata. ");
INSERT INTO lin_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Ngambo ya weste ya lopango ya Mongombo ekozala na bametele pene tuku mibale na mitano na mokuse. Ekozala mpe na barido, makonzi zomi mpe makolo zomi. ");
INSERT INTO lin_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Ngambo ya este ya lopango ya Mongombo, epai wapi moyi ebimelaka, ekozala na bametele pene tuku mibale na mitano na mokuse. ");
INSERT INTO lin_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Ngambo moko ya ekuke ekozala na barido ya bametele sambo na basantimetele tuku mitano elongo na makonzi misato mpe makolo misato. ");
INSERT INTO lin_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Ngambo mosusu ya ekuke ekozala mpe na barido ya bametele sambo na basantimetele tuku mitano, elongo na makonzi misato mpe makolo misato. ");
INSERT INTO lin_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Mpo na ekuke ya lopango ya Mongombo, bongisa rido ya bametele pene zomi na molayi, ya langi ya ble, ya motane ya pete, ya motane makasi ; mpe ekosalema na lino ya kitoko oyo bakotonga bililingi na likolo na yango, elongo na makonzi minei mpe makolo minei ; ekozala mosala ya bato oyo batongaka bililingi na bilamba. ");
INSERT INTO lin_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Makonzi nyonso oyo ekozala zingazinga ya lopango esengeli kozala na biloko na yango ya kosimbela, bibende na yango egumbama lokola ndobo, ya palata ; mpe makolo na yango ya bronze. ");
INSERT INTO lin_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Lopango ya Mongombo ekozala ya bametele tuku mitano na molayi, bametele tuku mibale na mitano na mokuse na ngambo moko na moko, bametele mibale na basantimetele tuku mitano na bosanda. Barido na yango ekozala ya lino ya kitoko oyo bakotonga bililingi na likolo na yango, mpe makolo na yango ekozala ya bronze. ");
INSERT INTO lin_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Biloko nyonso oyo bakosalela misala ya Mongombo, bapike nyonso ya Mongombo mpe ya lopango ekozala ya bronze. ");
INSERT INTO lin_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Okopesa mitindo na bana ya Isalaele ete bamemela yo mafuta ya olive ya peto mpo na minda, mpo ete minda ekoka kopela tango nyonso. ");
INSERT INTO lin_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Ezali kati na Ndako ya kapo ya Bokutani, libanda ya rido oyo ezali liboso ya Sanduku ya Litatoli, nde Aron mpe bana na ye ya mibali bakobanda kopelisa minda tango nyonso liboso ya Yawe, kobanda na pokwa kino na tongo. Ezali mobeko ya libela mpo na milongo nyonso ya bana ya Isalaele. ");
INSERT INTO lin_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Kamata kati na bana ya Isalaele Aron, ndeko na yo ya mobali, elongo na bana na ye ya mibali : Nadabi mpe Abiyu, Eleazari mpe Itamari ; mpo ete basala mosala ya bonganga-Nzambe liboso na Ngai. ");
INSERT INTO lin_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Okotonga mpo na Aron, ndeko na yo ya mobali, bilamba ya bule lokola elembo ya nkembo mpe ya lokumu. ");
INSERT INTO lin_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Bongo yo, okoloba na bato nyonso ya mayele oyo, kati na bango, natondisi molimo ya bwanya mpo ete batonga bilamba ya Aron mpo na kobulisa ye na mosala ya bonganga-Nzambe liboso na Ngai. ");
INSERT INTO lin_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Tala bilamba oyo bakotonga : elamba ya tolo, efode, kazaka mpe nzambala oyo batia bililingi likolo na yango, kitendi ya kokanga na moto mpe mokaba. Bakotonga bilamba ya bule mpo na Aron, ndeko na yo ya mobali, mpe mpo na bana na ye ya mibali oyo bakosala mosala ya bonganga-Nzambe liboso na Ngai. ");
INSERT INTO lin_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Bakosalela wolo, langi ya ble, ya motane ya pete, ya motane makasi mpe lino ya kitoko. ");
INSERT INTO lin_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Bakotonga na wolo efode ya langi ya ble, ya motane ya pete, ya motane makasi mpe na lino ya kitoko oyo bakotonga bililingi na likolo na yango ; ekozala mosala ya bato oyo basalaka bililingi na maboko. ");
INSERT INTO lin_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Ekozala na bankamba mibale na basuka na yango mibale mpo na kolata efode yango ; bankamba ekoleka likolo ya mapeka. ");
INSERT INTO lin_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Mokaba ya efode ekosalema ndenge moko na efode : ekozala ya wolo, ya langi ya ble, ya motane ya pete, ya motane makasi mpe na lino ya kitoko oyo bakotonga bililingi na likolo na yango. ");
INSERT INTO lin_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Okozwa mabanga mibale ya onikisi mpe okokoma na likolo na yango bakombo ya bana mibali ya Isalaele ");
INSERT INTO lin_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","kolanda ndenge babotama : bakombo motoba na libanga ya liboso mpe bakombo motoba oyo etikali, na libanga ya mibale. ");
INSERT INTO lin_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Okokoma bakombo ya bana mibali ya Isalaele na mabanga nyonso mibale ndenge bato basalaka bililingi na kashe na libanga ; mpe okozingela yango na wolo. ");
INSERT INTO lin_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Okotia mabanga yango na bankamba ya efode lokola mabanga ya ekaniseli mpo na bana mibali ya Isalaele. Aron akomema likolo ya mapeka na ye lokola ekaniseli liboso ya Yawe bakombo na bango. ");
INSERT INTO lin_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Okotia bikangelo ya wolo ");
INSERT INTO lin_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","mpe okosala basheneti mibale ya wolo basangisa na eloko mosusu te ; okosala yango lokola suki ya maboko mpe okokangisa basheneti yango pembeni-pembeni ya mabanga. ");
INSERT INTO lin_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Okosala elamba ya tolo mpo na koyeba mokano ya Nzambe ; ekozala mosala ya bato oyo basalaka bililingi na maboko. Okotonga yango lokola efode : ekozala ya wolo, ya langi ya ble, ya motane ya pete, ya motane makasi mpe na lino ya kitoko oyo bakotonga bililingi na likolo na yango. ");
INSERT INTO lin_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Soki bagumbi yango na biteni mibale, molayi mpe mokuse esengeli kozala ndenge moko : basantimetele pene tuku mibale na mitano. ");
INSERT INTO lin_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Okotia na likolo na yango milongo minei ya mabanga ya talo. Na molongo ya liboso, okotia libanga ya saridwane, ya topaze mpe ya emerode ; ");
INSERT INTO lin_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","na molongo ya mibale, okotia libanga ya ribisi, ya safiri mpe ya diama ; ");
INSERT INTO lin_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","na molongo ya misato, okotia libanga ya opale, ya agate mpe ya ametisite ; ");
INSERT INTO lin_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","mpe na molongo ya minei, okotia libanga ya krizolite, ya onikisi mpe ya jasipe. Okokanga mabanga yango na bikangelo ya wolo. ");
INSERT INTO lin_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Mabanga yango ekozala zomi na mibale kolanda bakombo ya bana mibali ya Isalaele. Na likolo ya libanga moko na moko, bakokoma kombo ya moko kati na mabota zomi na mibale ; bakokoma yango ndenge basalaka bililingi na kashe. ");
INSERT INTO lin_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Okosala basheneti ya wolo ya peto mpo na elamba ya tolo ; okosala yango ndenge bakangaka suki ya maboko. ");
INSERT INTO lin_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Okosala bapete mibale ya wolo mpo na elamba ya tolo mpe okokangisa yango na basonge mibale ya elamba yango. ");
INSERT INTO lin_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Okolekisa basheneti mibale ya wolo kati na bapete mibale oyo ezali na basonge ya elamba ya tolo, ");
INSERT INTO lin_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","mpe okokangisa basonge mibale mosusu ya basheneti yango, na bikangelo nyonso mibale ; mpe okokangisa yango na bankamba ya efode ; bankamba yango ekoleka na liboso. ");
INSERT INTO lin_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Okosala bapete mibale ya wolo oyo okotia na basonge mibale ya se ya elamba ya tolo, na ngambo ya kati oyo etala efode. ");
INSERT INTO lin_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Okosala bapete mosusu mibale ya wolo oyo okotia na bankamba mibale ya efode, na se, na liboso mpe na pembeni ya mokaba ya efode. ");
INSERT INTO lin_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Okokangisa na singa ya langi ya ble bapete ya wolo ya elamba ya tolo mpe bapete ya wolo ya efode, mpo ete elamba ya tolo ezala likolo ya efode mpe elongwa te na likolo na yango. ");
INSERT INTO lin_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Boye tango Aron akokota na Esika-Oyo-Eleki-Bule, akomema na motema na ye, na elamba ya tolo ya kokata makambo, bakombo ya bana mibali ya Isalaele lokola ekaniseli liboso ya Yawe mpo na libela. ");
INSERT INTO lin_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Okotia lisusu Urimi mpe Tumimi kati na elamba ya tolo ya kokata makambo mpe yango ekozala likolo ya motema ya Aron tango akotelema liboso ya Yawe. Boye Aron akomema makambo ya bana ya Isalaele liboso ya Yawe mpo na libela. ");
INSERT INTO lin_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Okosala mobimba ya nzambala oyo ekozala na se ya efode na langi ya ble. ");
INSERT INTO lin_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Nzambala esengeli kozala na lidusu na kati-kati mpo na kokotisa moto ; bakotonga pembeni-pembeni ya lidusu yango poso ya makasi mpo ete epasuka te. ");
INSERT INTO lin_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Na se mpe zingazinga ya nzambala, okotia bambuma ya grenade bakangisa na singa ya langi ya ble, ya motane ya pete mpe ya motane makasi ; mpe okotia bangonga ya mike-mike kati na bambuma ya grenade. ");
INSERT INTO lin_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Ekolandana boye : ngonga moko ya moke ya wolo, mbuma moko ya grenade, mpe bongo na bongo, zingazinga ya basonge nyonso ya nzambala. ");
INSERT INTO lin_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Aron asengeli kolata yango tango azali kosala mosala. Makelele ya bangonga ya mike-mike ekoyokana tango akotelema liboso ya Yawe na Esika-Oyo-Eleki-Bule mpe tango akobima ; wana ekolakisa ete akufi te. ");
INSERT INTO lin_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Okosala na wolo ya peto medaye mpe okokoma na likolo na yango ndenge basalaka bililingi na kashe : abulisama mpo na Yawe. ");
INSERT INTO lin_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Okokangisa yango na singa ya ble, mpe ekozala na likolo ya kitendi ya kokanga na moto, na mbunzu. ");
INSERT INTO lin_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Linzanza yango ekozala na mbunzu ya Aron mpo ete akoka komema bambeba oyo bana ya Isalaele bakosala na tina na biloko ya bule oyo bakobonza mpe bakobulisa. Linzanza yango ekozala tango nyonso na mbunzu ya Aron mpo ete Ngai Yawe, nandima makabo yango. ");
INSERT INTO lin_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Okotongela Aron nzambala ya lino mpe kitendi ya lino mpo na moto ; okosalela ye mpe mokaba oyo bato oyo batongaka bililingi na bilamba bakoyeba kotia bililingi. ");
INSERT INTO lin_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Okosala lisusu mpo na bana ya Aron banzambala, mikaba mpe bikoti, lokola elembo ya lokumu mpe ya nkembo. ");
INSERT INTO lin_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Sima na kolatisa Aron, ndeko na yo ya mobali, elongo na bana na ye ya mibali, okopakola bango mafuta mpe okobulisa bango. Okokomisa bango Banganga-Nzambe mpo ete basalela Ngai. ");
INSERT INTO lin_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Okosalela bango bakaputula ya lino mpo na kozipa bolumbu na bango : bakaputula yango ekobanda na loketo kino na mipende. ");
INSERT INTO lin_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Aron mpe bana na ye ya mibali bakolata yango tango nyonso bakobanda kokota na Ndako ya kapo ya Bokutani to kopusana pembeni ya etumbelo mpo na kosala mosala kati na Esika ya bule, mpo ete bazala na ngambo te mpe bakufa te. Ezali mobeko ya libela mpo na Aron mpe bakitani na ye. ");
INSERT INTO lin_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Tala ndenge okosala mpo na kobulisa Aron elongo na bana na ye ya mibali, na mosala ya bonganga-Nzambe mpo ete basalela Ngai. Okozwa mwana ngombe ya mobali mpe bameme mibale ya mibali, ezanga mbeba ; ");
INSERT INTO lin_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","okosala mapa mpe bagato ezanga levire, oyo farine na yango basangisa na mafuta ; okosala mpe mikate ezanga levire, kasi bapakola yango mafuta ; okosala yango na farine oyo batuta mpe bayungola malamu. ");
INSERT INTO lin_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Okotia yango nyonso na kitunga moko mpe okomema yango na ekuke ya Mongombo, elongo na mwana ngombe ya mobali mpe bameme mibale ya mibali. ");
INSERT INTO lin_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Okomema Aron mpe bana na ye ya mibali na ekotelo ya Ndako ya kapo ya Bokutani mpe okosukola bango na mayi. ");
INSERT INTO lin_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Okozwa bilamba ya bule mpe okolatisa Aron nzambala, kazaka, efode mpe elamba ya tolo ; mpe okokanga ye mokaba ya efode. ");
INSERT INTO lin_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Okokanga ye kitendi na moto mpe okobakisa na likolo ya kitendi yango elembo ya libulisi. ");
INSERT INTO lin_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Okozwa mafuta ya epakolami, okosopa yango na moto na ye mpe okopakola ye yango. ");
INSERT INTO lin_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Okomema bana na ye ya mibali mpe okolatisa bango banzambala. ");
INSERT INTO lin_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Okolatisa Aron mpe bana na ye ya mibali mikaba na loketo na bango mpe okolatisa bango bikoti. Na bongo, okobulisa bango na mosala ya bonganga-Nzambe oyo ekozala ya bango kolanda mobeko ya libela na libela. ");
INSERT INTO lin_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Okomema ngombe ya mobali liboso ya Ndako ya kapo ya Bokutani ; Aron mpe bana na ye ya mibali bakotia maboko na bango na moto na yango. ");
INSERT INTO lin_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Okokata ngombe yango kingo liboso na Ngai Yawe, na ekotelo ya Ndako ya kapo ya Bokutani. ");
INSERT INTO lin_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Okozwa ndambo ya makila ya ngombe yango, mpe okosalela mosapi na yo mpo na kotia makila yango na maseke ya etumbelo ; okosopa na makolo ya etumbelo makila oyo ekotikala. ");
INSERT INTO lin_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Okozwa mafuta nyonso oyo ezalaka pembeni-pembeni ya biloko ya kati, mafuta oyo ezipaka bafwa mpe bambuma nyonso mibale oyo ezalaka kati na loketo elongo na mafuta na yango ; mpe okotumba yango na etumbelo. ");
INSERT INTO lin_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Kasi okotumba na libanda ya molako misuni ya ngombe yango, poso na yango mpe nyei na yango. Ezali mbeka mpo na masumu. ");
INSERT INTO lin_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Okozwa lisusu meme moko ya mobali ; Aron mpe bana na ye ya mibali bakotia maboko na bango na moto na yango. ");
INSERT INTO lin_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Okokata meme yango kingo, okozwa makila na yango mpe okosopa yango na bapembeni nyonso ya etumbelo. ");
INSERT INTO lin_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Okokata-kata meme yango na biteni, okosukola biloko na yango ya kati elongo na makolo na yango mpe okotia yango likolo ya biteni mosusu mpe likolo ya moto. ");
INSERT INTO lin_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Okotumba meme mobimba ya mobali na etumbelo ; ezali mbeka ya kotumba mpo na Yawe, likabo bazikisa na moto mpo na Yawe, likabo oyo solo kitoko na yango esepelisaka Yawe. ");
INSERT INTO lin_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Okozwa meme mosusu ya mobali ; Aron elongo na bana na ye ya mibali bakotia maboko na bango na moto na yango. ");
INSERT INTO lin_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Okokata meme yango kingo, okozwa ndambo ya makila na yango mpe okotia yango na songe ya litoyi ya ngambo ya loboko ya mobali ya Aron mpe ya bana na ye ya mibali. Okotia yango lisusu na mosapi ya monene ya loboko na bango ya ngambo ya mobali mpe na mosapi ya monene ya lokolo na bango ya ngambo ya loboko ya mobali. ");
INSERT INTO lin_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Okozwa makila oyo ekozala na etumbelo mpe mafuta ya epakolami, okosopela yango Aron mpe bilamba na ye, bana na ye mpe bilamba na bango. Na bongo, ye mpe bana na ye elongo na bilamba na bango bakobulisama. ");
INSERT INTO lin_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Tala biteni ya mafuta ya meme ya mobali oyo okozwa : mokila, mafuta nyonso oyo ezalaka pembeni-pembeni ya biloko ya kati, mafuta oyo ezipi bafwa, bambuma mibale oyo ezalaka kati na loketo elongo na mafuta na yango mpe mopende ya ngambo ya mobali, pamba te meme yango ya mobali ezali ya libulisi. ");
INSERT INTO lin_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Tala biloko oyo okozwa kati na kitunga ya mapa ezanga levire, oyo ezali liboso ya Yawe : lipa moko, gato moko balamba na mafuta mpe galeti moko. ");
INSERT INTO lin_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Okotia biloko oyo nyonso na maboko ya Aron mpe ya bana na ye ya mibali ; okoyebisa bango ete batombola yango liboso ya Yawe lokola likabo ya kotombola. ");
INSERT INTO lin_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Okozwa yango lisusu na maboko na bango mpe okotumba yango na etumbelo, na likolo ya mbeka ya kotumba ; ezali likabo bazikisa na moto mpo na Yawe, likabo oyo solo kitoko na yango esepelisaka Yawe. ");
INSERT INTO lin_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Okozwa tolo ya meme ya mobali mpo na kobulisa Aron, okotombola yango liboso ya Yawe lokola mbeka ya kotombola ; ekozala eteni na yo. ");
INSERT INTO lin_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Okobulisa biteni ya libulisi mpo na Aron mpe bana na ye ya mibali : tolo mpe mopende ya meme oyo batombolaki mpo na kobonzela Yawe. ");
INSERT INTO lin_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Biteni yango ekozala ya Aron mpe ya bana na ye ya mibali lokola mobeko ya libela na libela. Pamba te ezali makabo ya bana ya Isalaele mpo na Yawe, makabo oyo ekowuta na mbeka na bango ya boyokani. ");
INSERT INTO lin_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Bilamba ya bule ya Aron ekotikala sima na ye epai ya bana na ye. Bakolata yango tango bakopakola bango mafuta mpe bakobulisa bango. ");
INSERT INTO lin_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Mikolo sambo, moko kati na bana na ye ya mibali oyo akokitana na ye lokola Nganga-Nzambe, akolata yango mpe akokota na Ndako ya kapo ya Bokutani mpo na kosala mosala ya bonganga-Nzambe kati na Esika ya bule. ");
INSERT INTO lin_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Okokamata meme ya mobali ya libulisi mpe okolamba mosuni na yango na esika moko ya bule. ");
INSERT INTO lin_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Aron mpe bana na ye ya mibali bakolia mosuni ya meme mpe lipa oyo ezali kati na kitunga, na ekotelo ya Ndako ya kapo ya Bokutani. ");
INSERT INTO lin_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Kaka bango nde bakolia makabo oyo na nzela na yango mosala ya bolimbisi masumu esalemaki tango babulisaki bango mpo na mosala ya bonganga-Nzambe ; kasi moto oyo abulisama te akoki kolia yango te, pamba te ezali bule. ");
INSERT INTO lin_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Soki mosuni ya mbeka ya libulisi mpe lipa ekomi kino na tongo, okotumba yango na moto. Bakoki kolia yango lisusu te, pamba te ezali bule. ");
INSERT INTO lin_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Sala mpo na Aron mpe mpo na bana na ye ya mibali makambo nyonso oyo natindi yo. Okosala mikolo sambo mpo na kobulisa bango na mosala ya bonganga-Nzambe. ");
INSERT INTO lin_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Mokolo na mokolo, okobonza mbeka ya ngombe ya mobali lokola mbeka mpo na bolimbisi masumu. Okopetola etumbelo na nzela ya mosala ya bolimbisi masumu, oyo okosala mpo na etumbelo yango mpe okosopela yango mafuta ya epakolami mpo na kobulisa yango. ");
INSERT INTO lin_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Mikolo sambo, okosala mosala ya bolimbisi masumu na etumbelo mpo na kobulisa yango. Boye etumbelo ekokoma bule koleka mpe nyonso oyo ekotutana na yango ekokoma bule. ");
INSERT INTO lin_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Tala mbeka oyo okopesela mitindo ete batumbaka mokolo na mokolo na etumbelo mpo na libela : bana meme mibale ya mobu moko. ");
INSERT INTO lin_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Okotumba mwana meme moko na tongo, mpe mosusu, na pokwa. ");
INSERT INTO lin_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Mpo na mwana meme ya liboso, okopesa bakilo misato ya farine basangisa na litele moko na kati-kati ya litele ya mafuta, mpe okosopa litele moko na kati-kati ya litele ya vino lokola mbeka ya masanga. ");
INSERT INTO lin_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Mpo na mwana meme ya mibale, okobonza yango na pokwa elongo na lolenge moko ya makabo oyo obonzaki na tongo : farine, mafuta mpe mbeka ya masanga ya vino ; okobonza yango lokola likabo bazikisa na moto mpo na Yawe, oyo solo kitoko na yango esepelisaka Yawe. ");
INSERT INTO lin_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Ezali mbeka ya kotumba ya tango nyonso, kati na bikeke nyonso : bokobanda kotumba yango na ekuke ya Ndako ya kapo ya Bokutani liboso ya Yawe ; ezali na esika wana nde nakobanda kokutana mpe kolobana na bino. ");
INSERT INTO lin_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Ezali na esika yango nde nakobanda kokutana na bana ya Isalaele ; bongo nkembo na Ngai ekobulisa esika yango. ");
INSERT INTO lin_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Nakobulisa Ndako ya kapo ya Bokutani mpe etumbelo ; nakobulisa lisusu Aron mpe bana na ye ya mibali mpo ete basalela Ngai lokola Banganga-Nzambe. ");
INSERT INTO lin_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Boye nakovanda kati na bana ya Isalaele mpe nakozala Nzambe na bango. ");
INSERT INTO lin_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Bakoyeba solo ete Ngai nazali Yawe, Nzambe na bango, Nzambe oyo abimisaki bango wuta na Ejipito mpo na kovanda kati na bango. Nazali Yawe, Nzambe na bango. ");
INSERT INTO lin_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Okosala lisusu etumbelo ya malasi na nzete ya akasia. ");
INSERT INTO lin_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Molayi mpe mokuse na yango ekozala ndenge moko, basantimetele pene tuku mitano ; mpe bosanda na yango ekozala na metele moko. Maseke na yango ekokangana na etumbelo. ");
INSERT INTO lin_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Okobamba wolo ya peto na likolo ya etumbelo, na mipanzi na yango mpe na maseke ; mpe okozingela pembeni na yango na libende ya wolo. ");
INSERT INTO lin_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Okosala mpo na etumbelo bapete ya wolo na se ya ebende ya wolo oyo ezingeli yango : mibale na ngambo moko, mpe mibale na ngambo mosusu ; mpo na kokotisa mabaya ya komemela etumbelo. ");
INSERT INTO lin_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Okosala mabaya yango na nzete ya akasia mpe okobamba yango wolo. ");
INSERT INTO lin_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Okotia etumbelo liboso ya rido oyo ezali liboso ya Sanduku ya Litatoli, liboso ya esika ya bolimbisi masumu oyo ezali na likolo ya Sanduku ya Litatoli. Ezali na esika yango nde nakobanda kokutana na yo. ");
INSERT INTO lin_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Tongo nyonso, Aron akotumba ansa na etumbelo yango tango akobongisa minda ; mpe pokwa nyonso, tango akopelisa yango. ");
INSERT INTO lin_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Aron asengeli kotumba lisusu ansa tango akopelisa minda na pokwa mpo ete ansa epelaka tango nyonso liboso ya Yawe mpo na libela. ");
INSERT INTO lin_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Kobonza te na etumbelo : ansa oyo elongobani te, mbeka ya kotumba to makabo ya bambuma. Mpe kosopa te likolo na yango makabo ya masanga ya vino. ");
INSERT INTO lin_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Mbala moko na mobu, Aron asengeli kosala mosala ya bolimbisi masumu, na maseke ya etumbelo ; akosala yango na makila ya mbeka ya masumu mpo na milongo oyo ekoya. Etumbelo ekozala bule koleka mpo na Yawe. ");
INSERT INTO lin_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","— Tango okotanga bana ya Isalaele, moko na moko kati na bango akofuta mpo na Yawe, mpako mpo na kosikola bomoi na ye tango bakotanga ye. Boye etumbu moko te ekokweyela bango tango bakotangama. ");
INSERT INTO lin_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Moto nyonso oyo batangi asengeli kofuta motuya oyo mpo na Yawe lokola mpako, kolanda ndenge bamekaka kilo kati na Mongombo : bagrame motoba ya palata. ");
INSERT INTO lin_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Moto nyonso oyo batangi, kobanda mibu tuku mibale to koleka, akofuta mpako mpo na Yawe. ");
INSERT INTO lin_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Na tango ya kofuta mpako mpo na Yawe, mpo na kosikola bomoi na bino, mozwi akofuta te motuya koleka bagrame motoba ya palata, mpe mobola akofuta te motuya oyo ezali na se ya bagrame motoba. ");
INSERT INTO lin_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Okozwa epai ya bana ya Isalaele mpako mpo na kosikola bomoi na bango mpe okosalela yango mpo na mosala ya kobongisa Ndako ya kapo ya Bokutani. Ekozala mpo na bana ya Isalaele ekaniseli liboso ya Yawe mpo na lisiko ya bomoi na bango. ");
INSERT INTO lin_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","— Okosala na bronze sani moko monene mpo na komipetola mpe evandelo na yango ; okotia yango na kati-kati ya Ndako ya kapo ya Bokutani mpe etumbelo, mpe okotia mayi kati na yango. ");
INSERT INTO lin_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Aron mpe bana na ye ya mibali bakobanda kosukola maboko mpe makolo na bango na mayi ya sani yango. ");
INSERT INTO lin_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Basengeli kosukola na mayi yango mpo ete bakufa te tango bakokota na Ndako ya kapo ya Bokutani to tango bakopusana pembeni ya etumbelo mpo na kotumba makabo bazikisa na moto mpo na Yawe. ");
INSERT INTO lin_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Basengeli kosukola makolo mpe maboko na bango mpo ete bakufa te. Oyo ezali mobeko oyo ekobongwana te mpo na Aron mpe bakitani na ye mpo na libela. ");
INSERT INTO lin_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","— Zwa mafuta ya solo kitoko : bakilo motoba ya mire, kati-kati na yango to bakilo misato ya sinamoni, bakilo misato ya kaneli, ");
INSERT INTO lin_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","bakilo misato ya kasia, kolanda ndenge bamekaka kilo kati na Esika ya bule, mpe balitele motoba ya mafuta ya olive. ");
INSERT INTO lin_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Na biloko oyo nyonso, okosala mafuta ya epakolami ya bule, ya solo kitoko, oyo esalemi na mosali malasi ; ekozala mafuta ya bule mpo na epakolami. ");
INSERT INTO lin_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Okosalela mafuta yango mpo na kopakola Ndako ya kapo ya Bokutani, Sanduku ya Litatoli, ");
INSERT INTO lin_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","mesa mpe bisalelo na yango nyonso, etelemiselo ya minda mpe biloko na yango nyonso, etumbelo ya malasi, ");
INSERT INTO lin_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","etumbelo ya bambeka ya kotumba mpe bisalelo na yango nyonso elongo na sani mpo na komipetola mpe evandelo na yango. ");
INSERT INTO lin_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Okobulisa yango mpo ete ezala bule koleka. Nyonso oyo ekotutana na yango ekozala bule. ");
INSERT INTO lin_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Okopakola Aron mpe bana na ye ya mibali mafuta mpe okobulisa bango mpo ete basalela Ngai lokola Banganga-Nzambe. ");
INSERT INTO lin_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Sima, okoloba na bana ya Isalaele : « Mafuta oyo ya epakolami ebulisami libela na libela mpo na Yawe. ");
INSERT INTO lin_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Bokopakola yango te na banzoto ya bato mpe bomekola te ndenge basalela yango, pamba te ezali bule mpe bosengeli komona yango bule. ");
INSERT INTO lin_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Moto nyonso oyo akomekola mafuta yango mpe akosopa yango na nzoto ya moto oyo abulisami te, basengeli kolongola ye kati na bato na ye. » ");
INSERT INTO lin_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Yawe alobaki na Moyize : — Zwa biloko ya mike-mike ya solo kitoko : sitakite, onikisi, galibanumi mpe ansa oyo basangisa na eloko mosusu te ; biloko nyonso ezala kilo moko. ");
INSERT INTO lin_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Okosala na yango ansa ya solo kitoko oyo esalemi na moto oyo asalaka malasi. Ekozala malasi oyo ezali na mungwa, ya peto mpe ya bule. ");
INSERT INTO lin_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Okosala na ndambo na yango mosusu putulu oyo okotia liboso ya Sanduku ya Litatoli kati na Ndako ya kapo ya Bokutani epai wapi nakokutana na yo. Ekozala bule koleka mpo na bino. ");
INSERT INTO lin_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Bokomisalela te ansa mosusu ya lolenge wana. Okomona yango bule mpe ekozala kaka mpo na Yawe. ");
INSERT INTO lin_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Moto nyonso oyo akomekola yango mpo na kosepela na solo na yango ya kitoko, basengeli kolongola ye kati na bato na ye. ");
INSERT INTO lin_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","— Yoka, naponi Betisaleyeli, mwana mobali ya Uri, mwana mobali ya Wuri, moto ya libota ya Yuda ; ");
INSERT INTO lin_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","natondisi ye na Molimo ya Nzambe, na bwanya, na mayele mpe na boyebi mpo na kosala misala ya lolenge nyonso ; ");
INSERT INTO lin_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","mpo na kokanisa mpe kosala misala ya wolo, ya palata mpe ya bronze ; ");
INSERT INTO lin_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","mpo na kokata mabanga ya talo, kobamba yango, kosala bililingi na banzete mpe mpo na kosala misala ya lolenge nyonso. ");
INSERT INTO lin_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Tala, napesi ye lokola mosungi Oliabi, mwana mobali ya Ayisamaki, moto ya libota ya Dani. Mpe napesi bwanya epai ya bato nyonso ya misala ya maboko mpo ete basala misala nyonso oyo natindi yo : ");
INSERT INTO lin_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Ndako ya kapo ya Bokutani, Sanduku ya Litatoli, esika ya bolimbisi masumu oyo ezali likolo ya Sanduku, mpe bisalelo nyonso ya Ndako ya kapo ; ");
INSERT INTO lin_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","mesa elongo na biloko na yango ; etelemiselo ya minda, basala na wolo oyo basangisa na eloko mosusu te, elongo na biloko na yango nyonso ; etumbelo ya malasi, ");
INSERT INTO lin_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","etumbelo ya bambeka ya kotumba elongo na bisalelo na yango nyonso ; sani mpo na komipetola elongo na evandelo na yango ; ");
INSERT INTO lin_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","bilamba ya mosala, bilamba nyonso ya bule ya Nganga-Nzambe Aron, bilamba oyo bana na ye ya mibali bakolata tango bakosala mosala na bango ya bonganga-Nzambe, ");
INSERT INTO lin_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","mafuta ya epakolami mpe ansa ya solo kitoko mpo na Esika ya bule. Basengeli kosala yango ndenge kaka natindaki yo. ");
INSERT INTO lin_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","— Loba na bana ya Isalaele : « Bosengeli kobatela mikolo na Ngai ya Saba ; ekozala elembo ya libela na libela kati na Ngai mpe bino, mpo ete boyeba ete ezali Ngai Yawe nde nabulisi bino. ");
INSERT INTO lin_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Lisusu, bokobatela mokolo ya Saba, pamba te ekozala mpo na bino mokolo ya bule. Moto nyonso oyo akobuka mobeko yango, basengeli koboma ye ; mpe moto nyonso oyo akosala mosala ata ya lolenge nini na mokolo yango, basengeli kolongola ye kati na bato na ye. ");
INSERT INTO lin_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Bokosala mosala mikolo motoba, mpe mokolo ya sambo ezali mokolo ya Saba, mokolo ya kopema, mokolo oyo ebulisami mpo na Yawe. Moto nyonso oyo akosala mosala na mokolo ya Saba, basengeli koboma ye. ");
INSERT INTO lin_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Bana ya Isalaele bakobatela mokolo ya Saba ; bango mpe bakitani na bango bakotosa yango lokola boyokani ya libela na libela. ");
INSERT INTO lin_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Ekozala elembo kati na Ngai mpe bana ya Isalaele mpo na libela na libela, pamba te na mikolo motoba, Yawe asalaki likolo mpe mokili ; bongo na mokolo ya sambo, akataki mosala mpe apemaki. » ");
INSERT INTO lin_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Tango Yawe asilisaki kosolola na Moyize, na ngomba Sinai, Yawe apesaki ye bitando mibale ya mabanga ya litatoli oyo Nzambe akomaki na mosapi na Ye. ");
INSERT INTO lin_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Tango bato bamonaki ete Moyize azali kowumela mpo na kokita na ngomba, basanganaki zingazinga ya Aron mpe balobaki : — Yaka mpe salela biso nzambe oyo akotambola liboso na biso. Pamba te Moyize, moto oyo abimisaki biso na Ejipito, toyebi te makambo nini ekomeli ye. ");
INSERT INTO lin_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Aron azongiselaki bango : — Bolongola biloko ya matoyi oyo ezali na matoyi ya basi na bino, ya bana na bino ya basi mpe ya mibali, mpe bomemela ngai yango. ");
INSERT INTO lin_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Bato nyonso balongolaki biloko ya matoyi mpe bamemaki yango epai ya Aron. ");
INSERT INTO lin_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Aron azwaki biloko oyo bapesaki ye, anyangwisaki yango na moto, mpe sima, asalaki ekeko ya mwana ngombe. Bongo balobaki : — Tala nzambe na yo, oh Isalaele, oyo abimisaki yo na Ejipito. ");
INSERT INTO lin_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Tango Aron amonaki yango, atongaki etumbelo liboso ya mwana ngombe mpe alobaki : — Feti ekozala lobi mpo na Yawe. ");
INSERT INTO lin_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Mokolo oyo elandaki, bato balamukaki na tongo makasi, babonzaki bambeka ya kotumba mpe bambeka ya boyokani. Sima na yango, bavandaki mpo na kolia mpe mpo na komela ; mpe batelemaki mpo na kosakana. ");
INSERT INTO lin_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Yawe alobaki na Moyize : — Kita, pamba te bato na yo, oyo obimisaki na Ejipito babungi nzela, ");
INSERT INTO lin_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","bapesi mokongo noki na makambo oyo natindaki bango mpe bamisaleli ekeko ya mwana ngombe. Bagumbameli yango, babonzeli yango makabo mpe balobi : « Tala nzambe na yo, Oh Isalaele, oyo abimisaki yo na Ejipito. » ");
INSERT INTO lin_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Yawe alobaki lisusu na Moyize : — Namoni ete bato oyo bazali batomboki. ");
INSERT INTO lin_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Sik’oyo, tika Ngai moko nasala mpo ete kanda na Ngai ekweyela bango mpe naboma bango. Kasi nakokomisa yo libota monene. ");
INSERT INTO lin_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Moyize abondelaki Yawe, Nzambe na ye, mpe alobaki : — Eh Yawe ! Mpo na nini kanda na Yo ekweyela bato na Yo, oyo obimisaki na Ejipito, na nguya monene mpe na loboko ya makasi ? ");
INSERT INTO lin_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Mpo na nini bato ya Ejipito baloba : « Nzambe na bango azalaki na makanisi mabe tango abimisaki bango na Ejipito. Ezali nde mpo na koboma bango na mokili ya bangomba mpe kosilisa bango na mokili. » Lembisa kanda na Yo ya makasi mpe kosala lisusu mabe te na bato na Yo. ");
INSERT INTO lin_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Kanisa Abrayami, Izaki mpe Isalaele, basali na Yo, oyo Yo moko olapelaki ndayi mpe olobaki : « Nakokomisa bakitani na yo ebele lokola minzoto na likolo, nakopesa bango mokili oyo nyonso ndenge kaka nalobaki na bango ; mpe yango ekozala libula na bango mpo na libela. » ");
INSERT INTO lin_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Mpe Yawe asalaki lisusu te mabe oyo akanaki kosala bato na Ye. ");
INSERT INTO lin_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Moyize abalukaki mpe akitaki wuta na ngomba, elongo na bitando mibale ya mabanga ya boyokani na maboko na ye ; mabanga yango ekomama na bangambo mibale, na liboso mpe na sima. ");
INSERT INTO lin_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Bitando yango ya mabanga ezalaki mosala ya Nzambe, mpe makomi oyo ezalaki ya kokomama na bitando yango ya mabanga ezalaki ya Nzambe. ");
INSERT INTO lin_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Tango Jozue ayokaki makelele ya bato oyo bazalaki koganga, alobaki na Moyize : — Ezali na makelele ya bitumba kati na molako ! ");
INSERT INTO lin_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Moyize azongisaki : — Te, ezali makelele ya elonga te, makelele ya kokweyisama mpe te ! Oyo ngai nazali koyoka, ezali nde makelele ya banzembo. ");
INSERT INTO lin_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Tango Moyize apusanaki pembeni ya molako, amonaki ekeko ya mwana ngombe mpe bato bazali kobina ; asilikaki makasi, abwakaki bitando ya mabanga wuta na maboko na ye mpe apanzaki yango na biteni, na ebandeli ya ngomba. ");
INSERT INTO lin_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Moyize azwaki ekeko ya mwana ngombe oyo basalaki, atumbaki yango na moto mpe anikaki yango malamu kino ekomaki putulu. Bongo apanzaki yango likolo ya mayi mpe amelisaki bana ya Isalaele mayi yango. ");
INSERT INTO lin_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Moyize atunaki Aron : — Likambo nini bato oyo basali yo mpo ete okamba bango kino kosala lisumu ya monene boye ? ");
INSERT INTO lin_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aron azongisaki : — Tika ete nkolo na ngai asilika te ! Oyebi bato, balingaka kaka kosala mabe. ");
INSERT INTO lin_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Balobaki na ngai : « Salela biso Nzambe oyo akotambola liboso na biso, pamba te toyebi te likambo nini ekweyeli Moyize oyo abimisaki biso na Ejipito. » ");
INSERT INTO lin_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Bongo nayebisaki bango : « Tika ete moto nyonso oyo azali na biloko ya matoyi ya wolo alongola yango. » Bapesaki ngai wolo, nanyangwisaki yango na moto mpe nasalaki na yango ekeko ya mwana ngombe oyo. ");
INSERT INTO lin_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Moyize amonaki ete bato bazalaki kati na mobulu, pamba te Aron akambaki bango mabe ; yango wana bakomaki eloko ya kotiola na miso ya banguna na bango. ");
INSERT INTO lin_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Moyize atelemaki na ekotelo ya molako mpe alobaki : — Tika ete moto nyonso oyo azali mpo na Yawe aya epai na ngai. Mpe Balevi nyonso basanganaki pene na ye. ");
INSERT INTO lin_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Alobaki na bango : — Tala makambo oyo Yawe, Nzambe ya Isalaele, alobi : « Tika ete moto nyonso atia mopanga na mopende na ye. Botambola kati na molako wuta na ndako ya kapo moko kino na ndako ya kapo mosusu ; mpe moko na moko na bino aboma ndeko na ye ya mobali, moninga na ye mpe mozalani na ye. » ");
INSERT INTO lin_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Balevi basalaki ndenge Moyize atindaki ; mpe na mokolo wana, bato pene nkoto misato bakufaki. ");
INSERT INTO lin_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Moyize alobaki : — Na mokolo ya lelo, Yawe atie bino pembeni mpo ete bobomi bana na bino moko ya mibali mpe bandeko na bino ya mibali. Bongo mpo na yango, apamboli bino. ");
INSERT INTO lin_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Mokolo elandaki, Moyize alobaki na bato : — Bosalaki lisumu monene. Kasi sik’oyo, nakomata epai na Yawe ; tango mosusu, nakozwa bolimbisi mpo na lisumu na bino. ");
INSERT INTO lin_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Moyize azongaki epai na Yawe mpe alobaki : — Ah ! Tala lisumu monene bato oyo basali. Bamisalelaki nzambe ya wolo. ");
INSERT INTO lin_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Kasi sik’oyo, nabondeli Yo, limbisa lisumu na bango, soki te longola kombo na ngai na buku ya bomoi oyo okomaki. ");
INSERT INTO lin_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Yawe azongiselaki Moyize : — Moto nyonso oyo asalaki lisumu liboso na Ngai, ye nde nakolongola na buku na Ngai. ");
INSERT INTO lin_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Sik’oyo, kende ! Kamba bato na esika oyo nalobaki na yo. Tala, anjelu na Ngai akozala liboso na yo. Atako bongo, tango mokolo ekokoka mpo ete napesa etumbu, nakopesa bango etumbu mpo na lisumu na bango. ");
INSERT INTO lin_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Yawe apesaki bato etumbu likolo ya ekeko ya mwana ngombe oyo balobaki na Aron ete asala. ");
INSERT INTO lin_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Yawe alobaki na Moyize : — Kende, longwa na esika oyo elongo na bato oyo obimisaki na Ejipito ; kende na mokili oyo nalakaki na ndayi epai ya Abrayami, Izaki mpe Jakobi ete nakopesa yango epai na bana na yo. ");
INSERT INTO lin_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Nakotinda anjelu liboso na yo, nakobengana bato ya Kanana ya Amori, ya Iti, ya Perizi, ya Evi mpe ya Yebusi. ");
INSERT INTO lin_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Bokende na mokili oyo ezali kobimisa miliki mpe mafuta ya nzoyi. Mpo na Ngai, nakotambola elongo na bino te, pamba te bozali batomboki, noki te nakosilisa koboma bino na nzela. ");
INSERT INTO lin_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Tango bato bayokaki maloba oyo ya somo, balataki pili, mpe ata moto moko te alataki lisusu biloko ya monzele. ");
INSERT INTO lin_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Bongo Yawe alobaki na Moyize : — Loba na bana ya Isalaele : « Bozali batomboki ; soki natamboli elongo na bino ata mpo na tango moke, nakosilisa koboma bino. Bolongola biloko na bino ya monzele, mpe nakoyebisa bino makambo oyo nakosala bino. » ");
INSERT INTO lin_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Bana ya Isalaele balongolaki biloko na bango ya monzele na ngomba Orebi. ");
INSERT INTO lin_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Moyize azwaki ndako ya kapo mpe atelemisaki yango mwa mosika, na libanda ya molako, mpo na bolamu na bango ; mpe abengaki yango Ndako ya kapo ya Bokutani. Moto nyonso oyo alingaki kokutana na Yawe, asengelaki kokende na Ndako ya kapo ya Bokutani, na libanda ya molako. ");
INSERT INTO lin_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Mbala nyonso oyo Moyize azalaki kokende na Ndako ya kapo ya Bokutani, bato nyonso bazalaki kotelema : moko na moko azalaki kotelema na ekuke ya ndako na ye ya kapo mpo na kotala Moyize kino akokota na Ndako ya kapo ya Bokutani. ");
INSERT INTO lin_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Soki Moyize akoti na kati, likonzi ya lipata ezalaki kokita mpe kotelema na ekotelo ya Ndako ya kapo ya Bokutani ; bongo Yawe azalaki kosolola na Moyize. ");
INSERT INTO lin_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Bato nyonso bazalaki komona likonzi ya lipata kotelema na ekotelo ya Ndako ya kapo ya Bokutani. Boye bazalaki kotelema mpe kofukamela Yawe, moko na moko na ekuke ya ndako na ye ya kapo. ");
INSERT INTO lin_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Yawe azalaki kosolola na Moyize ndenge moto asololaka na moninga na ye. Wana Moyize azalaki kozonga na molako ; Jozue, mwana mobali ya Nuni, elenge oyo azalaki kosunga ye, azalaki kotikala kati na ndako ya kapo. ");
INSERT INTO lin_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Moyize alobaki na Yawe : — Tala, ozali koloba na ngai ete nakamba bato oyo, kasi ozali koyebisa ngai te nani okotinda elongo na ngai. Nzokande Yo nde olobaki na ngai : « Nayebi yo na kombo na yo, » mpe lisusu : « Ozwi ngolu na miso na Ngai. » ");
INSERT INTO lin_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Sik’oyo, soki penza nazwi ngolu na miso na Yo, teya ngai banzela na Yo mpo ete nayeba Yo mpe nazwa ngolu na miso na Yo. Mpe kanisa lisusu ete libota wana bazali bato na Yo. ");
INSERT INTO lin_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Yawe azongisaki : — Ngai moko nakotambola elongo na yo mpe nakopesa yo bopemi. ");
INSERT INTO lin_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Moyize azongisaki : — Soki Yo moko okotambola elongo na biso te, kolongola biso te na esika oyo. ");
INSERT INTO lin_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Soki otamboli elongo na biso te, ndenge nini bato bakoyeba ete ngai mpe bato na Yo tozwi ngolu na miso na Yo ? Ezali nde tango okotambola elongo na biso nde ngai mpe bato na yo tokokesana na bikolo nyonso oyo ezali kati na mokili. ");
INSERT INTO lin_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Yawe alobaki na Moyize : — Nakosala makambo nyonso oyo osengi Ngai, pamba te ozwi ngolu na miso na Ngai mpe nayebi yo na kombo na yo. ");
INSERT INTO lin_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Moyize azongisaki : — Monisa ngai nkembo na Yo. ");
INSERT INTO lin_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Yawe azongisaki : — Nakolekisa bolamu na Ngai nyonso liboso na yo mpe nakotatola nani oyo nazali liboso na yo ; natalisaka ngolu epai ya moto oyo Ngai nasepeli kosalela ngolu, mpe nayokelaka mawa moto oyo Ngai nasepeli koyokela mawa. ");
INSERT INTO lin_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Kasi okokoka komona elongi na Ngai te, pamba te moto moko te akoki komona Ngai mpe azala na bomoi. ");
INSERT INTO lin_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Yawe alobaki lisusu : — Ezali na esika moko awa, pembeni na Ngai, epai wapi okoki kotelema na likolo ya libanga. ");
INSERT INTO lin_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Tango nkembo na Ngai ekoleka, nakotia yo kati na lidusu ya libanga mpe nakozipa yo na loboko na Ngai kino nakoleka. ");
INSERT INTO lin_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Bongo tango nakolongola loboko na Ngai, okomona Ngai kaka na mokongo ; kasi okokoka komona elongi na Ngai te. ");
INSERT INTO lin_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Yawe alobaki na Moyize : — Bongisa bitando mibale ya mabanga lokola oyo ya liboso ; nakokoma na bitando yango maloba oyo ezalaki na likolo ya bitando ya liboso oyo obukaki. ");
INSERT INTO lin_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Omilengela mpo na lobi na tongo. Na tongo-tongo, okomata na ngomba Sinai mpe okotelema liboso na Ngai, kuna na songe ya ngomba. ");
INSERT INTO lin_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Moto moko te asengeli komata elongo na yo ; na ngomba mobimba, moto moko te amonana ; bameme, bantaba to bangombe esengeli mpe te kolia na ebandeli ya ngomba. ");
INSERT INTO lin_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Moyize abongisaki bitando mibale ya mabanga lokola oyo ya liboso. Bongo na tongo-tongo ya mokolo oyo elandaki, amataki ngomba Sinai ndenge kaka Yawe atindaki ye ; amemaki bitando mibale ya mabanga, na maboko na ye. ");
INSERT INTO lin_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Yawe akitaki kati na lipata, atelemaki wana pene na ye, mpe Moyize abelelaki Kombo ya Yawe. ");
INSERT INTO lin_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Yawe alekaki liboso ya Moyize, mpe Moyize atatolaki : — Yawe, Yawe, Nzambe na mawa mpe na ngolu, Nzambe oyo asilikaka noki te, atondi na bolingo mpe na boboto, ");
INSERT INTO lin_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","atalisaka bolingo na Ye kino na milongo nkoto, alimbisaka mabe, botomboki mpe masumu, kasi azangaka te kopesa etumbu na moto oyo asali mabe, Nzambe oyo apesaka bakitani etumbu mpo na mabe ya batata na bango kino na molongo ya misato mpe ya minei ! ");
INSERT INTO lin_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Mbala moko, Moyize afukamaki mpe agumbamelaki Yawe ; ");
INSERT INTO lin_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","alobaki : — Eh Nkolo, soki penza nazwi ngolu na miso na Yo, nabondeli Yo : tambola kati na biso. Atako bato oyo bazali batomboki, kasi limbisa mabe mpe masumu na biso, mpe zwa biso lokola bato na Yo ! ");
INSERT INTO lin_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Yawe azongisaki : — Nalingi kosala boyokani elongo na bino. Liboso ya bato na yo nyonso, nakosala makambo ya kokamwa oyo etikala nanu kosalema te na mokili mobimba to na ekolo moko. Boye bato nyonso oyo bazali zingazinga na yo bakomona misala ya somo oyo Ngai Yawe nakosala na nzela na yo. ");
INSERT INTO lin_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Botosa makambo oyo nazali kotinda bino lelo. Nakobengana liboso na bino : bato ya Amori, ya Kanana, ya Iti, ya Perizi, ya Evi mpe ya Yebusi. ");
INSERT INTO lin_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Bokeba ! Bosala boyokani te elongo na bavandi ya mokili oyo bozali kokende, noki te bakokoma motambo kati na bino ! ");
INSERT INTO lin_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Bokweyisa bitumbelo na bango, bopanza bikeko na bango mpe bobuka makonzi oyo bapika mpo na nzambe mwasi Ashera. ");
INSERT INTO lin_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Bogumbamela nzambe mosusu te, pamba te Yawe andimaka bombanda te ; Kombo na Ye ezali Nzambe ya zuwa. ");
INSERT INTO lin_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Bokeba ! Bosala boyokani te elongo na bavandi ya mokili yango ; noki te tango bakosambela banzambe na bango mpe bakobonzela yango mbeka, babenga bino mpo ete bolia mbeka na bango elongo ; ");
INSERT INTO lin_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","mpe soki bozwi na libala bana na bango ya basi mpo na bana na bino ya mibali, wana bana na bango ya basi bakokoba kosambela banzambe na bango ya bikeko, bakotindika bana na bino ya mibali na kosambela banzambe na bango. ");
INSERT INTO lin_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Bokosala nzambe ya ekeko te. ");
INSERT INTO lin_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Bokosala feti ya Mapa ezanga levire. Mikolo sambo, bokolia mapa ezanga levire ndenge natindaki yo. Bokosala yango na tango ekatama, na sanza ya Abibi, pamba te ezali na sanza yango nde bobimaki na Ejipito. ");
INSERT INTO lin_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Mwana mobali nyonso ya liboso azali ya Ngai ; ekozala mpe bongo mpo na mwana mobali nyonso ya liboso kati na bibwele na bino : ezala mwana ngombe, mwana ntaba to mwana meme. ");
INSERT INTO lin_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Nzokande, mpo na mwana liboso ya ane, bokosikola yango na mwana meme. Soki bosikoli yango te, bokobuka yango kingo. Bokosikola bana na bino nyonso ya liboso ya mibali. Moto moko te akoya kotelema liboso na Ngai maboko pamba. ");
INSERT INTO lin_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Bokosala mosala mikolo motoba, kasi na mokolo ya sambo, bosengeli kopema : ezala na tango ya kolona to na tango ya kobuka. ");
INSERT INTO lin_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Bokosala feti ya Baposo mpo na kosepela na tina na bambuma ya liboso ya ble oyo ekomeli, mpe feti ya kobuka bambuma na suka ya mobu. ");
INSERT INTO lin_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Mbala misato na mobu, mibali nyonso basengeli koya liboso ya Nkolo Yawe, Nzambe ya Isalaele. ");
INSERT INTO lin_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Mpo na bolamu na yo, nakobengana bikolo liboso na yo mpe nakoyeisa mokili na yo monene. Moto moko te akoluka kobotola mokili na yo tango okobanda komata mbala misato na mobu, mpo na kokutana na Yawe, Nzambe na yo. ");
INSERT INTO lin_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Okobonzela Ngai te makila ya nyama elongo na mapa batia levire ; okobomba te kino lobi na tongo mbeka oyo babonzi mpo na Pasika. ");
INSERT INTO lin_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Okomema na Ndako ya Yawe, Nzambe na yo, bambuma ya liboso ya mabele na yo. Okolamba te mwana ntaba oyo ezali nanu komela mabele ya mama na yango. ");
INSERT INTO lin_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Yawe alobaki lisusu na Moyize : — Koma maloba oyo, pamba te ezali na nzela na yango nde nasalaki boyokani elongo na yo mpe Isalaele. ");
INSERT INTO lin_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Moyize asalaki kuna elongo na Yawe mikolo tuku minei mpe babutu tuku minei ; aliaki ata eloko moko te mpe amelaki mayi te. Bongo Moyize akomaki na bitando ya mabanga maloba ya Boyokani oyo babengi mibeko zomi. ");
INSERT INTO lin_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Nzokande, tango Moyize akitaki wuta na ngomba Sinai, na bitando ya mabanga mibale ya mibeko na maboko na ye, ayebaki te ete elongi na ye ezalaki kongenga, mpo ete asololaki na Yawe. ");
INSERT INTO lin_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Tango Aron mpe bana nyonso ya Isalaele bamonaki ete elongi ya Moyize ezali kongenga, babangaki kopusana pembeni na ye. ");
INSERT INTO lin_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Moyize abengaki bango ; bongo Aron mpe bakambi nyonso ya lisanga ya Isalaele bapusanaki pembeni ya Moyize, mpe ye Moyize asololaki na bango. ");
INSERT INTO lin_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Sima na yango, bana nyonso ya Isalaele bapusanaki pembeni ya Moyize mpe ayebisaki bango mibeko nyonso oyo Yawe apesaki ye na ngomba Sinai. ");
INSERT INTO lin_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Tango Moyize asilisaki kosolola na bango, azipaki elongi na ye na vwale. ");
INSERT INTO lin_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Kasi tango nyonso Moyize azalaki kokota liboso ya Yawe mpo na kosolola na Ye, azalaki kolongola vwale kino tango akobima. Mpe soki abimi, azalaki koyebisa na bana ya Isalaele mibeko nyonso oyo azalaki kozwa epai na Yawe. ");
INSERT INTO lin_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Mpe bana ya Isalaele bazalaki komona elongi ya Moyize kongenga. Bongo azalaki kozongisa vwale na elongi na ye kino tango azalaki kozonga mpo na kosolola na Yawe. ");
INSERT INTO lin_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Moyize asangisaki lisanga mobimba ya bana ya Isalaele mpe alobaki na bango : « Boyoka makambo oyo Yawe atindi bino kosala : ");
INSERT INTO lin_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","— Mikolo motoba, bokosala mosala na bino, kasi mokolo ya sambo ekozala mokolo ya bule, mokolo ya Saba mpo na Yawe, mokolo na bino ya kopema. Moto nyonso oyo akosala mosala na mokolo yango, bakoboma ye. ");
INSERT INTO lin_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Na mokolo yango ya Saba, bokopelisa ata moto te na bandako na bino. » ");
INSERT INTO lin_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Moyize alobaki na lisanga mobimba ya bana ya Isalaele : « Boyoka makambo oyo Yawe atindi bino kosala : ");
INSERT INTO lin_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","— Kati na biloko oyo bozali na yango, botia pembeni ndambo oyo bokobonza epai na Yawe lokola makabo. Moto nyonso oyo azali na motema malamu akomemela Yawe makabo : wolo, palata mpe bronze, ");
INSERT INTO lin_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","langi ya ble, ya motane ya pete, ya motane makasi, lino ya kitoko, bapwale ya ntaba, ");
INSERT INTO lin_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","baposo ya bameme batia langi ya motane mpe baposo ya banyama ya ebale ; banzete ya akasia, ");
INSERT INTO lin_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","mafuta ya olive mpo na kopelisela mwinda, biloko ya mike-mike ya solo kitoko mpo na kosala mafuta ya epakolami mpe malasi ya solo kitoko, ");
INSERT INTO lin_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","mabanga ya onikisi mpe mabanga mosusu ya talo mpo na kotia yango na efode mpe na elamba ya tolo oyo Nganga-Nzambe akobanda kolata. ");
INSERT INTO lin_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Tika ete bato nyonso oyo kati na bino bayebi misala, baya kosala misala nyonso oyo Yawe atindi : ");
INSERT INTO lin_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Mongombo, ndako na yango ya kapo, ezipelo na yango, bibende na yango oyo ezali lokola ndobo, bikangelo na yango, mabaya na yango, makonzi na yango mpe bivandelo na yango ; ");
INSERT INTO lin_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Sanduku elongo na mabaya ya komemela yango, mofinuku na yango, barido, ");
INSERT INTO lin_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","mesa, mabaya na yango, bisalelo na yango nyonso mpe mapa oyo esengeli kozala liboso ya Yawe, ");
INSERT INTO lin_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","etelemiselo ya minda, bisalelo na yango, minda na yango mpe mafuta mpo na kopelisa minda, ");
INSERT INTO lin_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","etumbelo ya malasi, mabaya ya komemela yango, mafuta ya epakolami mpe malasi ya solo kitoko, rido ya ekotelo ya ndako ya kapo epai wapi Mongombo ezali, ");
INSERT INTO lin_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","etumbelo ya bambeka ya kotumba, motalaka na yango ya bronze, mabaya ya komemela yango mpe bisalelo na yango nyonso, sani ya bronze mpe evandelo na yango, ");
INSERT INTO lin_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","batapi ya lopango, makonzi na yango, makolo na yango mpe rido mpo na ekotelo ya lopango, ");
INSERT INTO lin_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","bapike ya Mongombo, bapike ya lopango mpe basinga na yango, ");
INSERT INTO lin_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","bilamba ya mosala ya bonganga-Nzambe mpo na kosala kati na Mongombo, bilamba ya bule mpo na Nganga-Nzambe Aron mpe bilamba ya bonganga-Nzambe mpo na bana na ye ya mibali. » ");
INSERT INTO lin_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Lisanga mobimba ya bana ya Isalaele batikaki Moyize. ");
INSERT INTO lin_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Bongo bato nyonso oyo bazalaki na motema malamu mpe na bolingo ya kopesa, babonzelaki Yawe makabo mpo na mosala ya Ndako ya kapo ya Bokutani, mpo na misala nyonso mpe kotonga bilamba ya bule. ");
INSERT INTO lin_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Bato nyonso oyo bazalaki na motema malamu, ezala mobali to mwasi, bayaki na basheneti, biloko ya matoyi, bapete mpe biloko ya ndenge na ndenge oyo esalema na wolo. Bango nyonso bamemaki biloko na bango ya wolo liboso ya Yawe mpe babonzelaki Ye yango. ");
INSERT INTO lin_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Bato nyonso oyo bazalaki na langi ya ble, ya motane ya pete, ya motane makasi to mpe ya motane ya kongenga, lino, bapwale ya ntaba, baposo ya bameme batia langi ya motane mpe baposo ya banyama ya ebale, bamemaki yango. ");
INSERT INTO lin_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Bato nyonso oyo batiaki pembeni makabo ya palata to ya bronze bamemaki yango mpe babonzelaki yango Yawe ; ndenge moko mpe na bato oyo bazalaki na banzete ya akasia mpo na misala nyonso. ");
INSERT INTO lin_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Basi nyonso oyo bayebaki kosala bilamba basalaki yango na maboko na bango mpe bamemaki bilamba ya langi ya ble, ya motane ya pete, ya motane makasi mpe lino ya kitoko. ");
INSERT INTO lin_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Mpe basi nyonso oyo bazalaki na motema malamu mpe bayebaki kosala bilamba, basalaki yango na bapwale ya ntaba. ");
INSERT INTO lin_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Bakambi bamemaki mabanga ya talo ya onikisi mpe mabanga mosusu ya talo mpo na kotia yango na efode mpe na elamba ya tolo oyo Nganga-Nzambe akobanda kolata. ");
INSERT INTO lin_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Bamemaki mpe biloko ya mike-mike ya solo kitoko mpe mafuta mpo na etelemiselo ya minda, mafuta mpo na epakolami mpe malasi ya solo kitoko. ");
INSERT INTO lin_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Bato nyonso ya Isalaele, ezala basi to mibali, oyo mitema na bango esimbamaki mpo na komema eloko mpo na misala oyo Yawe atindaki na nzela ya Moyize, bamemaki epai na Yawe makabo oyo bango moko bakataki kopesa wuta na mokano ya mitema na bango. ");
INSERT INTO lin_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Moyize alobaki na bana ya Isalaele : « Botala, Yawe aponi Betisaleyeli, mwana mobali ya Uri, mwana mobali ya Wuri, moto ya libota ya Yuda ; ");
INSERT INTO lin_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","atondisi ye na Molimo ya Nzambe, na bwanya, na mayele mpe na boyebi mpo na kosala misala ya lolenge nyonso : ");
INSERT INTO lin_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","mpo na kokanisa mpe kosala misala ya wolo, ya palata mpe ya bronze, ");
INSERT INTO lin_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","mpo na kokata mabanga ya talo, kobamba yango, kosala bililingi na banzete mpe mpo na kosala misala ya lolenge nyonso. » ");
INSERT INTO lin_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Yawe apesaki na Betisaleyeli mpe Oliabi, mwana mobali ya Ayisamaki, moto ya libota ya Dani, makoki ya koteya bato mosusu lolenge ya kosala. ");
INSERT INTO lin_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Apesaki bango lisusu makoki ya kosala misala ya lolenge nyonso : kosala bililingi, kosala bilamba na basinga ya langi ya ble, ya motane ya pete, ya motane makasi mpe ya lino, kosala misala ya lolenge nyonso mpe kobongisa ndenge misala esengeli kosalema. ");
INSERT INTO lin_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Betisaleyeli, Oliabi mpe bato nyonso epai ya banani Yawe apesaki makoki mpe mayele ya kosala misala ya lolenge nyonso mpo na kotonga Mongombo, basalaki yango ndenge kaka Yawe atindaki. ");
INSERT INTO lin_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Bongo Moyize abengisaki Betisaleyeli, Oliabi mpe bato nyonso epai ya banani Yawe apesaki makoki mpe mayele elongo na bato oyo bamibongisaki mpo na kosala misala yango. ");
INSERT INTO lin_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Bazwaki na maboko ya Moyize makabo nyonso oyo bana ya Isalaele bamemaki mpo na kosala misala ya botongi Mongombo. Tongo nyonso, bana ya Isalaele bakobaki komema epai ya Moyize makabo oyo bango moko bakataki kopesa wuta na mokano ya mitema na bango. ");
INSERT INTO lin_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Boye bato oyo bazalaki kosala misala ya kotonga Mongombo batikaki misala na bango ");
INSERT INTO lin_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","mpe bayaki koloba na Moyize : — Makabo oyo bana ya Isalaele bazali kopesa eleki mingi mpo na kosala mosala oyo Yawe atindaki. ");
INSERT INTO lin_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Bongo Moyize atindaki maloba oyo epai ya bana ya Isalaele : — Tika ete moto moko te, azala mwasi to mobali, apesa lisusu makabo mpo na Mongombo ! Boye bato batikaki komema makabo, ");
INSERT INTO lin_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","pamba te biloko nyonso ezalaki ya kokoka mpo na misala nyonso oyo esengelaki kosalema : ezalaki kutu ya koleka. ");
INSERT INTO lin_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Bato oyo balekaki mayele kati na basali batongaki Mongombo elongo na batapi zomi ya lino ya kitoko oyo batongaki bililingi na likolo na yango, ya langi ya ble, ya motane ya pete mpe ya motane makasi, elongo na bililingi ya basheribe ; ezalaki mosala ya bato oyo basalaka bililingi na maboko. ");
INSERT INTO lin_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Tapi moko na moko ezalaki na bametele pene zomi na minei na molayi ; mpe bametele pene mibale, na mokuse. Batapi nyonso ezalaki ndenge moko na mokuse mpe na molayi. ");
INSERT INTO lin_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Bakangisaki batapi mitano, moko na mosusu, mpe basalaki ndenge moko mpo na batapi mitano mosusu. ");
INSERT INTO lin_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Batiaki basinga ya langi ya ble, na pembeni ya tapi ya suka ya lisanga ya batapi mitano ya liboso, mpe na pembeni ya tapi ya suka ya lisanga ya batapi mitano ya mibale. ");
INSERT INTO lin_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Batiaki basinga tuku mitano na suka ya lisanga ya batapi mitano ya liboso, mpe na suka ya lisanga ya batapi mitano ya mibale ; basinga yango etalanaki. ");
INSERT INTO lin_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Basalaki na wolo bibende tuku mitano oyo ezali lokola ndobo ; mpe bakangisaki na bibende oyo ezali lokola ndobo lisanga ya batapi mitano ya liboso mpe lisanga ya batapi mitano ya mibale. Boye, Mongombo ebimaki eloko moko. ");
INSERT INTO lin_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Basalaki batapi zomi na moko, na bapwale ya ntaba mpo na kotia yango na likolo ya Mongombo. ");
INSERT INTO lin_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Molayi ya tapi moko na moko ezalaki na bametele pene zomi na mitano mpe mokuse na yango ezalaki na bametele pene mibale. Batapi nyonso zomi na moko ezalaki ndenge moko na molayi mpe na mokuse. ");
INSERT INTO lin_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Bakangisaki batapi mitano na ngambo moko, mpe batapi motoba na ngambo mosusu. ");
INSERT INTO lin_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Batiaki basinga tuku mitano na suka ya liboke ya batapi ya liboso, mpe basinga tuku mitano na suka ya liboke ya batapi ya mibale. ");
INSERT INTO lin_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Basalaki na bronze bibende tuku mitano oyo ezali lokola ndobo ; bakotisaki yango na basinga mpo na kokangisa Mongombo mpo ete ekoma eloko moko. ");
INSERT INTO lin_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Basalelaki baposo ya bameme oyo bapakola langi ya motane mpo na kozipa Mongombo, mpe babakisaki na likolo na yango baposo ya banyama ya ebale. ");
INSERT INTO lin_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Basalaki bizingelo ya Mongombo na banzete ya akasia mpe batelemisaki yango. ");
INSERT INTO lin_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Ezingelo moko na moko ezalaki na bametele mitano na molayi, mpe basantimetele tuku sambo na mitano na mokuse. ");
INSERT INTO lin_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Babetaki banzete mibale-mibale na ezingelo moko na moko ; basalaki bongo mpo na bizingelo nyonso ya Mongombo. ");
INSERT INTO lin_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Batiaki bizingelo tuku mibale na ngambo ya Negevi, na sude ya Mongombo, ");
INSERT INTO lin_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","mpe makolo tuku minei ya palata, na se ya bizingelo tuku mibale : makolo mibale na se ya ezingelo moko na moko oyo babeta banzete mibale ; ");
INSERT INTO lin_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","bizingelo tuku mibale na ngambo mosusu ya Mongombo, na nor, ");
INSERT INTO lin_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","elongo na makolo na yango tuku minei ya palata : makolo mibale mpo na ezingelo moko na moko ; ");
INSERT INTO lin_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","bizingelo motoba na suka ya Mongombo, na ngambo ya weste, ");
INSERT INTO lin_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","mpe bizingelo mibale na suka mpo na kolendisa Mongombo. ");
INSERT INTO lin_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Bizingelo yango ezalaki ya kofungwama na se, kasi esalaki songe na likolo mpe ekotaki na lopete ya liboso : nyonso mibale ezalaki ndenge moko mpe elendisaki Mongombo. ");
INSERT INTO lin_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Boye, bizingelo ezalaki mwambe elongo na makolo na yango ya palata zomi na motoba : makolo mibale-mibale na se ya ezingelo moko na moko. ");
INSERT INTO lin_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Sima, basalaki, na nzete ya akasia, mabaya mitano mpo na bizingelo ya ngambo moko ya Mongombo, ");
INSERT INTO lin_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","mabaya mitano mpo na bizingelo ya ngambo mosusu ya Mongombo, mabaya mitano mpo na bizingelo oyo ezalaki na suka ya Mongombo, na ngambo ya weste. ");
INSERT INTO lin_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Libaya ya kati elekaki na kati-kati ya bizingelo, elekaki ngambo na ngambo. ");
INSERT INTO lin_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Babambaki wolo na bizingelo, basalaki bapete na yango na wolo mpo na kolekisa mabaya ; mpe babambaki mabaya wolo. ");
INSERT INTO lin_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Basalaki rido ya langi ya ble, ya motane ya pete, ya motane makasi mpe na lino ya kitoko oyo batongaki bililingi na likolo na yango. Mpe bato oyo basalaka bililingi batongaki basheribe ya kitoko na rido yango. ");
INSERT INTO lin_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Batiaki yango na makonzi minei ya nzete ya akasia, oyo bapakola wolo ; bakangisaki yango na bibende ya wolo oyo ezali lokola ndobo mpe batelemisaki yango na makolo minei ya palata. ");
INSERT INTO lin_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Mpo na ekotelo ya Ndako ya kapo, asalaki rido ya langi ya ble, ya motane ya pete, ya motane makasi mpe na lino ya kitoko ; ezalaki mosala ya bato oyo batongaka bililingi na bilamba. ");
INSERT INTO lin_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Basalaki na wolo bibende mitano oyo ezali lokola ndobo mpo na kokangisela rido, mpe banzete mitano ya akasia babamba wolo ; basalaki makolo mitano ya bronze mpo na kotelemisela banzete yango. ");
INSERT INTO lin_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Betisaleyeli asalaki Sanduku na nzete ya akasia. Molayi na yango ezalaki na basantimetele pene nkama moko na tuku mibale na mitano ; mokuse na yango, basantimetele pene tuku sambo na mitano ; mpe bosanda na yango, basantimetele pene tuku sambo na mitano. ");
INSERT INTO lin_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Abambaki yango wolo ya peto, na kati mpe na libanda. Alatisaki mpe songe na yango wolo. ");
INSERT INTO lin_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Asalelaki yango bapete minei ya wolo mpe atiaki yango basonge minei : mibale na ngambo moko, mpe mibale na ngambo mosusu. ");
INSERT INTO lin_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Asalaki mabaya mibale na nzete ya akasia mpe abambaki yango wolo. ");
INSERT INTO lin_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Akotisaki mabaya yango na bapete oyo ezali na songe ya Sanduku, mpo na komemela yango. ");
INSERT INTO lin_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Asalaki mofinuku na wolo ya peto. Molayi na yango ezalaki na basantimetele pene nkama moko na tuku mibale na mitano ; mpe mokuse na yango, basantimetele pene tuku sambo na mitano. ");
INSERT INTO lin_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Asalaki bikeko mibale ya basheribe oyo atiaki na suka mibale ya mofinuku ; asalaki yango na wolo oyo batuti na nzela ya marto. ");
INSERT INTO lin_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Atiaki ekeko moko ya sheribe na suka moko, mpe ekeko mosusu, na suka mosusu. Akangisaki bikeko ya basheribe na mofinuku, na suka nyonso mibale. ");
INSERT INTO lin_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Mapapu ya basheribe ezalaki ya kofungwama na likolo mpo na kobatela mofinuku ; bazalaki ngambo na ngambo, mpe miso na bango etalaki mofinuku. ");
INSERT INTO lin_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Asalaki mesa moko na mabaya ya akasia. Molayi na yango ezalaki na basantimetele pene nkama moko ; mokuse na yango, basantimetele pene tuku mitano ; mpe bosanda na yango, basantimetele pene tuku sambo na mitano. ");
INSERT INTO lin_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Abambaki yango wolo ya peto mpe atiaki lisusu wolo na pembeni na yango. ");
INSERT INTO lin_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Azingelaki mesa yango na libaya oyo ezalaki na basantimetele pene mwambe na monene mpe atiaki wolo na pembeni ya libaya yango. ");
INSERT INTO lin_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Asalaki bapete minei ya wolo mpe atiaki yango na songe minei ya mesa epai wapi makolo na yango ezalaki. ");
INSERT INTO lin_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Bapete ezalaki pene ya libaya oyo ezingelaki mesa, mpe bakotisaki kati na bapete yango mabaya ya komemela Sanduku. ");
INSERT INTO lin_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Asalaki na nzete ya akasia mabaya ya komemela mesa, mpe abambaki yango wolo. ");
INSERT INTO lin_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Asalaki na wolo ya peto basani, bakopo, bambilika mpe bambeki, mpo na makabo ya masanga. ");
INSERT INTO lin_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Asalaki na wolo ya peto etelemiselo ya minda ; asalaki yango na wolo oyo batuti na nzela ya marto. Evandelo na yango, likonzi na yango, bakeni na yango, bambuma mpe bafololo na yango, nyonso ezalaki ekangana lokola eloko moko. ");
INSERT INTO lin_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Mipanzi ya likonzi ya etelemiselo ya minda ezalaki na bitape motoba : misato na ngambo moko, mpe misato na ngambo mosusu. ");
INSERT INTO lin_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Na likolo ya etape moko na moko ya etelemiselo ya minda, atiaki bakeni misato oyo ezali na lolenge ya fololo ya madame, elongo na bambuma mpe bafololo. ");
INSERT INTO lin_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Na moto ya likonzi ya etelemiselo ya minda, ezalaki na bakeni minei oyo ezali na lolenge ya bafololo ya madame, elongo na bambuma mpe bafololo. ");
INSERT INTO lin_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Na se ya bitape mibale-mibale ya etelemiselo ya minda, ezalaki na mbuma moko ; mpe ezalaki bongo mpo na bitape nyonso motoba ya etelemiselo ya minda. ");
INSERT INTO lin_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Bambuma mpe bitape ezalaki ekangana na etelemiselo ya minda ; mpe nyonso esalemaki na wolo ya peto, wolo oyo batuti na nzela ya marto. ");
INSERT INTO lin_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Asalaki minda sambo ; mpe asalaki na wolo ya peto bisimbelo elongo na basani ya putulu. ");
INSERT INTO lin_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Asalelaki bakilo tuku misato na minei ya wolo ya peto mpo na kosala etelemiselo ya minda mpe bisalelo na yango nyonso. ");
INSERT INTO lin_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Betisaleyeli asalaki etumbelo ya malasi na nzete ya akasia. Molayi mpe mokuse na yango ezalaki ndenge moko, basantimetele pene tuku mitano ; mpe bosanda na yango ezalaki na metele moko. Maseke na yango ekangamaki na etumbelo mpe esalaki kaka eloko moko. ");
INSERT INTO lin_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Abambaki wolo ya peto na likolo ya etumbelo, na mipanzi na yango mpe na maseke na yango ; mpe azingelaki pembeni na yango na libende ya wolo. ");
INSERT INTO lin_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Asalaki mpo na etumbelo bapete ya wolo na se ya ebende ya wolo oyo ezingeli yango : mibale na ngambo moko, mpe mibale na ngambo mosusu ; mpo na kokotisa mabaya ya komemela etumbelo. ");
INSERT INTO lin_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Asalaki mabaya yango na nzete ya akasia mpe abambaki yango wolo. ");
INSERT INTO lin_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Asalaki mafuta ya epakolami ya bule, malasi ya solo kitoko mpe ya peto, oyo esalemi na mosali malasi. ");
INSERT INTO lin_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Betisaleyeli asalaki na mabaya ya nzete ya akasia etumbelo ya bambeka ya kotumba ; ezalaki ndenge moko na molayi mpe na mokuse, bametele mibale na basantimetele tuku mitano ; bongo bosanda na yango ezalaki ya metele moko na basantimetele tuku mitano. ");
INSERT INTO lin_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Asalaki maseke minei na basonge nyonso minei ya etumbelo, mpo ete maseke mpe etumbelo esala eloko moko ; mpe abambaki bronze na etumbelo. ");
INSERT INTO lin_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Asalaki na bronze banzungu ya mike mpo na kolongola putulu ya moto, bapawu, basani ya minene, bakanya mpe basani mpo na komema makala ya moto. ");
INSERT INTO lin_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Asalaki motalaka ya bronze mpo na etumbelo ; akangisaki bapete minei ya bronze na basonge nyonso minei ya motalaka. ");
INSERT INTO lin_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Asalaki na bronze bapete minei oyo atiaki na basonge nyonso minei ya motalaka mpo na koyamba mabaya. ");
INSERT INTO lin_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Asalaki na nzete ya akasia, mabaya mpo na etumbelo mpe abambaki yango bronze. ");
INSERT INTO lin_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Boye, mpo na komema etumbelo, bakotisaki mabaya yango na bapete oyo ezali na basonge mibale ya etumbelo. Bongo etumbelo yango ezalaki polele kati na yango. ");
INSERT INTO lin_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Asalaki lisusu na bronze ya bitalatala ya basi oyo bazalaki kosangana na ekuke ya Ndako ya kapo ya Bokutani : sani monene mpo na komipetola mpe evandelo na yango. ");
INSERT INTO lin_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Tala ndenge atongaki lopango ya Mongombo : ngambo ya sude oyo ezalaki ya bametele pene tuku mitano na molayi, ezipamaki na rido ya lino oyo basali bilamba basalaki. ");
INSERT INTO lin_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Makonzi na yango tuku mibale mpe bivandelo tuku mibale esalemaki na bronze ; bongo bibende ya makonzi elongo na biloko na yango ya kosimbela ezalaki ya palata. ");
INSERT INTO lin_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Ngambo ya nor ezalaki na bametele pene tuku mitano na molayi, na makonzi tuku mibale mpe na makolo tuku mibale, oyo esalema na bronze. Makonzi yango ezalaki na bibende ya palata egumbama lokola ndobo elongo na biloko na yango ya kosimbela, oyo ezalaki ya palata. ");
INSERT INTO lin_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Ngambo ya weste ezalaki na bametele pene tuku mibale na mitano na mokuse mpe barido elongo na makonzi zomi, makolo zomi, bibende ya palata egumbama lokola ndobo mpe biloko na yango ya kosimbela. ");
INSERT INTO lin_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Ngambo ya este ya lopango ya Mongombo, epai wapi moyi ebimelaka, ezalaki na bametele pene tuku mibale na mitano na mokuse. ");
INSERT INTO lin_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Ngambo moko ya ekuke ezalaki na barido ya bametele pene sambo na basantimetele tuku mitano, elongo na makonzi misato mpe makolo misato. ");
INSERT INTO lin_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Ngambo mosusu ya ekuke ezalaki mpe na barido ya bametele pene sambo na basantimetele tuku mitano, elongo na makonzi misato mpe makolo misato. ");
INSERT INTO lin_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Barido nyonso zingazinga ya lopango ezalaki ya lino ya kitoko oyo batongaki bililingi na likolo na yango. ");
INSERT INTO lin_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Makolo ya makonzi ezalaki ya bronze ; bibende egumbama lokola ndobo mpe biloko na yango ya kosimbela ezalaki ya palata, mpe balatisaki basonge na yango palata. Makonzi nyonso ya lopango ezalaki na biloko ya palata ya kosimbela. ");
INSERT INTO lin_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Rido ya ekuke ya lopango ezalaki ya langi ya ble, ya motane ya pete, ya motane makasi mpe ya lino ya kitoko oyo batongaki bililingi na likolo na yango ; ezalaki mosala ya bato oyo batongaka bililingi na bilamba. Molayi na yango ezalaki na bametele pene zomi, mpe bosanda na yango, bametele pene mibale na basantimetele pene tuku mitano, ndenge barido nyonso ya lopango ezalaki. ");
INSERT INTO lin_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Ezalaki mpe na makonzi minei mpe bivandelo minei ya bronze. Bibende na yango oyo egumbama lokola ndobo mpe biloko na yango ya kosimbela rido ezalaki ya palata, mpe balatisaki basonge na yango palata. ");
INSERT INTO lin_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Bapike nyonso ya Mongombo mpe ya lopango ezalaki ya bronze. ");
INSERT INTO lin_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Tala motuya ya biloko oyo basalelaki Mongombo oyo, kati na yango, ezalaki na buku ya Boyokani, ndenge kaka Moyize atindaki. Balevi batongaki yango na bokambami ya Itamari, mwana mobali ya Nganga-Nzambe Aron. ");
INSERT INTO lin_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Betisaleyeli, mwana mobali ya Uri, mwana mobali ya Wuri, ya libota ya Yuda, asalaki nyonso oyo Yawe atindaki Moyize. ");
INSERT INTO lin_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Asungamaki na Oliabi, mwana mobali ya Ayisamaki, moto ya libota ya Dani, mosali mpe motongi bililingi na maboko, oyo azalaki kobimisa makanisi mpe kotonga bililingi na bilamba ya langi ya ble, ya motane ya pete, ya motane makasi mpe na lino ya kitoko. ");
INSERT INTO lin_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Wolo nyonso oyo basalelaki mpo na kotonga mpe mpo na misala nyonso ya Mongombo, wolo oyo babonzelaki Yawe, ezalaki bakilo nkoto moko mpe bagrame nkama moko na tuku mibale, kolanda ndenge bamekaka kilo kati na Mongombo. Wolo nyonso wana ewutaki na makabo ya kotombola. ");
INSERT INTO lin_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Palata oyo bazwaki na maboko ya bato oyo batangamaki na lisanga, ezalaki bakilo nkoto misato mpe bagrame nkama minei na tuku minei, kolanda ndenge bamekaka kilo kati na Mongombo. ");
INSERT INTO lin_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Elingi koloba ete moto nyonso oyo batangaki amemaki bagrame mitano na badesigrame sambo, kolanda ndenge bamekaka kilo kati na Mongombo. Bato nyonso oyo batangamaki, oyo bazalaki na mibu ya mbotama tuku mibale mpe koleka, bazalaki nkoto nkama motoba na misato na nkama mitano na tuku mitano. ");
INSERT INTO lin_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Basalelaki bakilo ya palata nkoto misato na nkama minei na tuku mibale mpo na kosala bivandelo nkama moko ya Mongombo mpe barido nkama moko : elingi koloba ete basalelaki bakilo pene tuku misato na minei mpe bagrame pene nkama mibale mpo na evandelo moko. ");
INSERT INTO lin_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Shekeli nkoto moko na nkama sambo na tuku sambo na mitano oyo etikalaki, basalelaki yango bibende oyo egumbama lokola ndobo, biloko ya kosimbela rido mpe balatiselaki yango basonge ya makonzi. ");
INSERT INTO lin_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Bronze oyo ewutaki na makabo ya kotombola ezalaki bakilo pene nkoto mibale na nkama minei na tuku mibale na moko. ");
INSERT INTO lin_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Bazwaki yango mpo na kosala bivandelo ya ekuke ya Ndako ya kapo ya Bokutani, etumbelo ya bronze elongo na motalaka na yango mpe bisalelo na yango nyonso. ");
INSERT INTO lin_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Basalelaki yango lisusu bivandelo nyonso oyo ezalaki pembeni-pembeni ya lopango ya Mongombo, bivandelo ya ekotelo na yango, bapike nyonso ya Mongombo mpe bapike oyo ezingelaki lopango. ");
INSERT INTO lin_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Batongaki na langi ya ble, ya motane ya pete mpe ya motane makasi bilamba ya mosala ya bonganga-Nzambe kati na Mongombo ; batongaki mpe bilamba ya bule mpo na Aron, ndenge kaka Yawe atindaki yango na Moyize. ");
INSERT INTO lin_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Betisaleyeli atongaki efode ya wolo, ya langi ya ble, ya motane ya pete, ya motane makasi mpe na lino ya kitoko oyo batongaki bililingi na likolo na yango ; asalaki yango kitoko penza. ");
INSERT INTO lin_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Batandaki mabende mike-mike ya wolo, bakataki-kataki yango lokola basinga mpe bakotisaki kati na langi ya ble mpe ya motane ya pete, langi ya motane makasi mpe lino ya kitoko ; ezalaki mosala ya bato oyo basalaka bililingi na maboko. ");
INSERT INTO lin_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Atiaki bankamba mibale na basuka na yango mibale mpo na kolata efode yango ; bankamba elekaki likolo ya mapeka. ");
INSERT INTO lin_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Mokaba ya efode esalemaki lolenge moko na efode : ezalaki ya wolo, ya langi ya ble, ya motane ya pete, ya motane makasi mpe na lino ya kitoko oyo batongaki bililingi na likolo na yango, ndenge kaka Yawe atindaki Moyize. ");
INSERT INTO lin_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Abongisaki mabanga ya onikisi, mpe bakangaki yango na bikangelo ya wolo ; akomaki likolo na yango bakombo ya bana mibali ya Isalaele, ndenge basalaka bililingi na kashe. ");
INSERT INTO lin_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Atiaki yango na bankamba ya efode lokola mabanga ya ekaniseli mpo na bana mibali ya Isalaele, ndenge kaka Yawe atindaki Moyize. ");
INSERT INTO lin_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Betisaleyeli asalaki elamba ya tolo ; esalemaki kitoko penza. Atongaki yango ndenge moko na efode : ezalaki ya wolo, ya langi ya ble, ya motane ya pete, ya motane makasi mpe na lino ya kitoko oyo batongaki bililingi na likolo na yango. ");
INSERT INTO lin_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Agumbaki yango na biteni mibale ; molayi mpe mokuse ezalaki ndenge moko, basantimetele pene tuku mibale na mitano. ");
INSERT INTO lin_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Atiaki milongo minei ya mabanga ya talo na likolo ya elamba ya tolo : na molongo ya liboso, libanga ya saridwane, ya topaze mpe ya emerode. ");
INSERT INTO lin_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Na molongo ya mibale, libanga ya ribisi, ya safiri mpe ya diama. ");
INSERT INTO lin_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Na molongo ya misato, libanga ya opale, ya agate mpe ya ametisite ; ");
INSERT INTO lin_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","na molongo ya minei, libanga ya krizolite, ya onikisi mpe ya jasipe. Akangaki mabanga yango na bikangelo ya wolo. ");
INSERT INTO lin_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Mabanga yango ezalaki zomi na mibale kolanda bakombo ya bana mibali ya Isalaele. Na likolo ya libanga moko na moko, bakomaki kombo ya moko kati na mabota zomi na mibale ; bakomaki yango ndenge basalaka bililingi na kashe. ");
INSERT INTO lin_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Basalaki basheneti ya wolo ya peto mpo na elamba ya tolo ; basalaki yango ndenge bakangaka suki ya maboko. ");
INSERT INTO lin_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Basalaki bikangelo mibale ya wolo mpe bapete mibale ya wolo mpe bakangisaki yango na basonge mibale ya elamba ya tolo. ");
INSERT INTO lin_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Alekisaki basheneti mibale ya wolo kati na bapete mibale oyo atiaki na basonge mibale ya elamba ya tolo. ");
INSERT INTO lin_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Akangisaki basonge mibale mosusu ya basheneti oyo mibale na bikangelo mibale oyo atiaki na bankamba ya efode ; bankamba yango elekaki na liboso. ");
INSERT INTO lin_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Asalaki lisusu bapete mibale ya wolo mpe atiaki yango na basonge mibale ya se ya elamba ya tolo, na ngambo ya kati oyo etala efode. ");
INSERT INTO lin_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Asalaki bapete mosusu mibale ya wolo oyo atiaki na bankamba mibale ya efode, na se, na liboso mpe na pembeni ya mokaba ya efode. ");
INSERT INTO lin_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Akangisaki na singa ya langi ya ble bapete ya wolo ya elamba ya tolo mpe bapete ya wolo ya efode, mpo ete elamba ya tolo ezala likolo ya efode mpe elongwa te na likolo na yango. Asalaki yango ndenge kaka Yawe atindaki Moyize. ");
INSERT INTO lin_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Basalaki nzambala oyo ezalaki na se ya efode : ezalaki ya langi ya ble na mobimba na yango, mpe ezalaki mosala ya bato oyo basalaka bilamba na maboko. ");
INSERT INTO lin_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Nzambala ezalaki na lidusu na kati-kati mpo na kokotisa moto ; batongaki pembeni-pembeni ya lidusu yango poso ya makasi mpo ete epasuka te. ");
INSERT INTO lin_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Na se mpe zingazinga ya nzambala, batiaki bambuma ya grenade bakangisa na singa ya langi ya ble, ya motane ya pete, ya motane makasi mpe na singa ya lino ya kitoko oyo batongaki bililingi na likolo na yango. ");
INSERT INTO lin_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Basalaki na wolo ya peto bangonga ya mike-mike mpe batiaki yango kati na bagrenade, na se ya nzambala. ");
INSERT INTO lin_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Balandisaki yango boye : ngonga moko ya moke, grenade moko, mpe bongo na bongo, zingazinga ya basonge nyonso ya nzambala mpo na mosala, ndenge kaka Yawe atindaki Moyize. ");
INSERT INTO lin_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Batongaki na lino ya kitoko, mpo na Aron mpe bana na ye ya mibali, banzambala, ");
INSERT INTO lin_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","bitendi ya lino ya kitoko mpo na moto, bikoti, bakaputula ");
INSERT INTO lin_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","mpe mikaba oyo batonga bililingi na likolo na yango na basinga ya lino ya langi ya ble, ya motane ya pete mpe ya motane makasi, ndenge kaka Yawe atindaki Moyize. ");
INSERT INTO lin_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Basalaki na wolo ya peto medaye lokola elembo ya libulisi na ye epai na Yawe mpe bakomaki na likolo na yango ndenge basalaka bililingi na kashe : abulisama mpo na Yawe. ");
INSERT INTO lin_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Batiaki yango singa ya ble mpo na kokangisa yango na likolo ya kitendi ya moto, ndenge kaka Yawe atindaki Moyize. ");
INSERT INTO lin_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Boye misala nyonso ya Mongombo, ya Ndako ya kapo ya Bokutani, esilaki. Bana ya Isalaele basalaki misala nyonso ndenge kaka Yawe atindaki Moyize. ");
INSERT INTO lin_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Bamemaki Mongombo epai ya Moyize, elongo na biloko na yango nyonso : ndako ya kapo mpe bibende na yango oyo ezali lokola ndobo, bikangelo na yango, mabaya na yango, makonzi mpe bivandelo na yango, ");
INSERT INTO lin_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","ezipelo ya poso ya meme oyo bapakola langi ya motane, ezipelo ya poso ya nyama ya ebale mpe barido, ");
INSERT INTO lin_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Sanduku ya Litatoli, mabaya ya komemela yango mpe mofinuku na yango, ");
INSERT INTO lin_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","mesa, bisalelo na yango nyonso mpe mapa oyo esengeli kozala liboso ya Yawe ; ");
INSERT INTO lin_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","etelemiselo ya minda, oyo basala na wolo ya peto, minda na yango, bisalelo na yango nyonso mpe mafuta mpo na kopelisa minda yango, ");
INSERT INTO lin_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","etumbelo oyo esalema na wolo, mafuta ya epakolami, malasi ya solo kitoko, rido ya ekotelo ya ndako ya kapo, ");
INSERT INTO lin_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","etumbelo esalema na bronze, motalaka na yango ya bronze, mabaya ya komemela yango mpe bisalelo na yango nyonso, sani ya bronze mpe evandelo na yango, ");
INSERT INTO lin_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","batapi ya lopango, makonzi na yango, makolo na yango, rido mpo na ekotelo ya lopango, basinga na yango, bapike na yango, bisalelo nyonso mpo na mosala ya Mongombo, Ndako ya kapo ya Bokutani, ");
INSERT INTO lin_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","bilamba ya mosala ya bonganga-Nzambe mpo na kosala kati na Mongombo, bilamba ya bule mpo na Nganga-Nzambe Aron mpe bilamba ya mosala ya bonganga-Nzambe mpo na bana na ye ya mibali. ");
INSERT INTO lin_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Bana ya Isalaele basalaki misala nyonso ndenge kaka Yawe atindaki Moyize. ");
INSERT INTO lin_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Moyize atalaki malamu misala yango mpe amonaki ete basalaki yango ndenge kaka Yawe atindaki. Boye Moyize apambolaki bango. ");
INSERT INTO lin_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","— Na mokolo ya liboso ya sanza ya liboso, okotelemisa Mongombo, Ndako ya kapo ya Bokutani ; ");
INSERT INTO lin_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","okotia kati na yango Sanduku ya Litatoli mpe okozipa yango na rido. ");
INSERT INTO lin_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Okokotisa mesa mpe okotia biloko oyo esengeli kozala likolo na yango ; okokotisa etelemiselo ya minda mpe okopelisa minda na yango. ");
INSERT INTO lin_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Okotia etumbelo ya malasi, oyo basala na wolo liboso ya Sanduku ya Litatoli mpe okotia rido, na ekotelo ya Mongombo. ");
INSERT INTO lin_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Okotia etumbelo ya mbeka ya kotumba liboso ya ekotelo ya Mongombo, Ndako ya kapo ya Bokutani, ");
INSERT INTO lin_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","mpe okotia sani mpo na komipetola na kati-kati ya Ndako ya kapo ya Bokutani mpe etumbelo, mpe okotia mayi kati na yango. ");
INSERT INTO lin_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Okotonga lopango zingazinga na yango mpe okotia rido na ekotelo ya lopango. ");
INSERT INTO lin_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Okozwa mafuta ya epakolami, okopakola Mongombo mpe nyonso oyo ezali kati na yango, mpe okobulisa yango elongo na bisalelo na yango nyonso mpe yango ekozala bule. ");
INSERT INTO lin_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Okopakola mafuta na etumbelo ya mbeka ya kotumba mpe bisalelo na yango nyonso ; okobulisa etumbelo mpe yango ekozala bule koleka. ");
INSERT INTO lin_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Okopakola mafuta na sani mpo na komipetola mpe evandelo na yango, mpe okobulisa yango. ");
INSERT INTO lin_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Okomema Aron mpe bana na ye ya mibali na ekotelo ya Ndako ya kapo ya Bokutani mpe okosukola bango na mayi. ");
INSERT INTO lin_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Sima na yango, okolatisa Aron bilamba ya bule, okopakola ye mafuta mpe okobulisa ye mpo ete asalela Ngai lokola Nganga-Nzambe. ");
INSERT INTO lin_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Okomema mpe bana na ye ya mibali mpe okolatisa bango banzambala. ");
INSERT INTO lin_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Okopakola bango mafuta ndenge opakolaki tata na bango, mpo ete basalela Ngai lokola Banganga-Nzambe : epakolami na bango ekopesa bango nzela mpo na kosala mosala ya bonganga-Nzambe libela na libela kati na bakitani na bango. ");
INSERT INTO lin_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Moyize asalaki nyonso oyo Yawe atindaki ye. ");
INSERT INTO lin_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Boye, Mongombo etelemisamaki na mokolo ya liboso ya sanza ya liboso na mobu ya mibale. ");
INSERT INTO lin_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Tango Moyize atelemisaki Mongombo, atiaki bivandelo na esika na yango, atiaki bakadre, akotisaki mabaya mpe atelemisaki makonzi ; ");
INSERT INTO lin_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","atandaki ndako ya kapo na likolo ya Mongombo mpe atiaki ezipelo na likolo ya ndako ya kapo, ndenge kaka Yawe atindaki ye Moyize. ");
INSERT INTO lin_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Moyize azwaki bitando nyonso mibale ya mabanga ya Boyokani mpe atiaki yango kati na Sanduku, akangisaki mabaya na Sanduku mpe atiaki esika ya bolimbisi masumu na likolo na yango. ");
INSERT INTO lin_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Moyize akotisaki Sanduku kati na Mongombo mpe atiaki rido mpo na kokabola Esika ya bule mpe Esika-Oyo-Eleki-Bule, mpo ete bato bakoka komona Sanduku ya Litatoli te, ndenge kaka Yawe atindaki ye. ");
INSERT INTO lin_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Moyize atiaki mesa kati na Ndako ya kapo ya Bokutani na ngambo ya nor ya Mongombo libanda ya rido ; ");
INSERT INTO lin_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","mpe atiaki mapa na molongo, liboso ya Yawe, ndenge kaka Yawe atindaki ye Moyize. ");
INSERT INTO lin_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Atiaki etelemiselo ya minda kati na Ndako ya kapo ya Bokutani, etalana na mesa, na ngambo ya sude ya Mongombo. ");
INSERT INTO lin_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Apelisaki minda liboso ya Yawe, ndenge kaka Yawe atindaki ye Moyize. ");
INSERT INTO lin_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Atiaki etumbelo ya wolo kati na Ndako ya kapo ya Bokutani liboso ya rido, ");
INSERT INTO lin_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","mpe atumbaki likolo na yango ansa ya solo kitoko, ndenge kaka Yawe atindaki ye Moyize. ");
INSERT INTO lin_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Bongo atiaki rido na ekotelo ya Mongombo. ");
INSERT INTO lin_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Atiaki etumbelo ya mbeka ya kotumba pembeni ya ekuke ya Mongombo, Ndako ya kapo ya Bokutani, abonzaki likolo na yango bambeka ya kotumba mpe makabo ya mbuma, ndenge kaka Yawe atindaki ye Moyize. ");
INSERT INTO lin_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Atiaki sani mpo na komipetola na kati-kati ya Ndako ya kapo ya Bokutani mpe etumbelo mpe atiaki kati na yango mayi ya kosukola. ");
INSERT INTO lin_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Moyize, Aron mpe bana mibali ya Aron basalelaki yango mpo na kosukola maboko mpe makolo na bango. ");
INSERT INTO lin_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Bazalaki komisukola tango nyonso bazalaki kokota na Ndako ya kapo ya Bokutani to kopusana pembeni ya etumbelo, ndenge kaka Yawe atindaki ye Moyize. ");
INSERT INTO lin_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Moyize atelemisaki lopango pembeni-pembeni ya Mongombo mpe ya etumbelo, mpe atiaki rido na ekuke ya lopango. Ezali boye nde Moyize asilisaki mosala. ");
INSERT INTO lin_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Lipata ezipaki Ndako ya kapo ya Bokutani mpe nkembo na Yawe etondaki kati na Mongombo. ");
INSERT INTO lin_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Moyize akokaki lisusu te kokota na Ndako ya kapo ya Bokutani, pamba te lipata evandaki likolo na yango mpe nkembo na Yawe etondaki kati na Mongombo. ");
INSERT INTO lin_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Tango nyonso lipata ezalaki kolongwa na likolo ya Ndako ya kapo ya Bokutani, bana ya Isalaele bazalaki kotelema mpo na kokende na mobembo na bango. ");
INSERT INTO lin_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Kasi soki lipata elongwe te, bango mpe bazalaki kolongwa te, bazalaki kozela kino na mokolo oyo lipata ekolongwa. ");
INSERT INTO lin_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Na moyi, lipata ya Yawe ezalaki na likolo ya Mongombo ; bongo na butu, moto ezalaki kongala kati na lipata, mpe miso ya bana nyonso ya Isalaele ezalaki komona yango. Esalemaki bongo na mibembo na bango nyonso.");
INSERT INTO lin_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Yawe abengaki Moyize mpe ayebisaki ye, wuta na Ndako ya kapo ya Bokutani : ");
INSERT INTO lin_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","« Yebisa bana ya Isalaele : ‹ Soki moko kati na bino alingi kobonza nyama lokola mbeka epai na Yawe, asengeli komema nyama oyo azwi kati na bangombe, bantaba mpe bameme. ");
INSERT INTO lin_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Soki azali kobonza ngombe lokola mbeka ya kotumba, amema nde oyo ezangi mbeba. Bongo akobonza yango na ekotelo ya Ndako ya kapo ya Bokutani mpo ete Yawe andima yango. ");
INSERT INTO lin_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Moto oyo akobonza yango akotia loboko na ye na moto ya mbeka. Mbeka yango ekondimama lokola mbeka mpo na bolimbisi masumu ya moto oyo abonzi yango. ");
INSERT INTO lin_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Akokata kingo ya ngombe liboso ya Yawe, bongo bakitani ya Aron, Banganga-Nzambe, bakozwa makila na yango mpe bakosopa yango na bangambo nyonso ya etumbelo oyo ezali na ekotelo ya Ndako ya kapo ya Bokutani. ");
INSERT INTO lin_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Bakolongola poso ya mbeka yango mpe bakokata yango na biteni. ");
INSERT INTO lin_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Sima, bakitani ya Nganga-Nzambe Aron bakopelisa moto na etumbelo mpe bakotanda bakoni likolo ya moto. ");
INSERT INTO lin_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Bana mibali ya Aron, Banganga-Nzambe, bakotia lisusu biteni ya ngombe, moto mpe biteni ya mafuta, na likolo ya bakoni oyo ezali kopela na etumbelo. ");
INSERT INTO lin_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Bakosukola na mayi biloko na yango ya kati mpe makolo na yango ; sima, Nganga-Nzambe akotumba nyonso na etumbelo. Ezali mbeka ya kotumba, likabo bazikisa na moto, oyo solo kitoko na yango ekosepelisa Yawe. ");
INSERT INTO lin_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Soki ezali nyama ya moke nde azali kobonza lokola mbeka ya kotumba, akomema mwana ntaba to mwana meme ya mobali oyo ezanga mbeba. ");
INSERT INTO lin_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Akokata yango kingo liboso ya Yawe, na ngambo ya nor ya etumbelo. Bakitani ya Nganga-Nzambe Aron basengeli kosopa makila na yango na bangambo nyonso ya etumbelo. ");
INSERT INTO lin_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Akokata-kata mbeka yango na biteni ; bongo Nganga-Nzambe akobongisa yango : akotia moto mpe biteni ya mafuta likolo ya bakoni oyo ezali kopela moto na etumbelo ; ");
INSERT INTO lin_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","akosukola na mayi biloko ya kati mpe makolo. Sima, Nganga-Nzambe akomema nyonso mpe akotumba yango na etumbelo. Ezali mbeka ya kotumba, likabo bazikisa na moto, oyo solo kitoko na yango ekosepelisa Yawe. ");
INSERT INTO lin_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Kasi soki ezali ndeke nde azali kobonzela Yawe lokola likabo ya kotumba, akomema ebenga ya zamba to mwana ebenga ya mboka. ");
INSERT INTO lin_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Nganga-Nzambe akomema yango na etumbelo, akokata yango moto, akotumba moto yango na etumbelo mpe akosopa makila na yango zingazinga ya etumbelo. ");
INSERT INTO lin_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Akolongola eloko oyo ezalaka na kingo mpe bansala na yango nyonso ; akobwaka yango na ngambo ya este ya etumbelo, na esika oyo batiaka putulu ya moto. ");
INSERT INTO lin_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Sima, akofungola ndeke na kati-kati ya mapapu ; kasi akokata mapapu yango te. Bongo Nganga-Nzambe akotumba yango likolo ya bakoni oyo ezali kopela moto na etumbelo. Ezali mbeka ya kotumba, likabo bazikisa na moto, oyo solo kitoko na yango ekosepelisa Yawe. ");
INSERT INTO lin_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Soki moto alingi komema makabo ya mbuma epai na Yawe, makabo yango ekozala ya farine. Bongo na likolo na yango, akosopa mafuta mpe akotia ansa. ");
INSERT INTO lin_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Akomema yango epai ya Banganga-Nzambe, bana mibali ya Aron, oyo moko kati na bango akozwa loboko mobimba ya farine mpe mafuta elongo na ansa nyonso, mpe akotumba yango na etumbelo lokola ekaniseli. Ezali likabo bazikisa na moto, oyo solo kitoko na yango ekosepelisa Yawe. ");
INSERT INTO lin_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Ndambo oyo ekotikala, kati na makabo ya mbuma, ekozala ya Aron mpe ya bana na ye. Ezali eteni ya bule penza kati na makabo bazikisa na moto mpo na Yawe. ");
INSERT INTO lin_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Soki amemi likabo ya farine batumba na fulu ya moto, likabo yango esengeli kozala ya gato oyo ezanga levire, oyo basangisa na mafuta to ya mikate oyo ezanga levire mpe bapakola mafuta na likolo na yango. ");
INSERT INTO lin_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Soki ezali likabo bakalinga na kikalungu, esengeli kozala ya farine ezanga levire mpe basangisa na mafuta. ");
INSERT INTO lin_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Bakokata yango na biteni mpe bakosopa mafuta likolo na yango. Ezali likabo ya bambuma. ");
INSERT INTO lin_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Bongo soki likabo yango ezali ya bambuma bakalinga na kikalungu, ekozala ya farine basangisa na mafuta. ");
INSERT INTO lin_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Bakomema epai na Yawe makabo ya mbuma oyo babongisi mpe bakopesa yango epai ya Nganga-Nzambe oyo akomema yango na etumbelo. ");
INSERT INTO lin_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Nganga-Nzambe akolongola na makabo ya mbuma eteni oyo esengeli kobonzama lokola ekaniseli mpe akotumba yango na etumbelo. Ezali likabo bazikisa na moto oyo solo kitoko na yango ekosepelisa Yawe. ");
INSERT INTO lin_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Bongo bagato oyo ekotikala, ekozala ya Aron mpe ya bana na ye ya mibali. Ezali eteni ya bule penza kati na makabo bazikisa na moto mpo na Yawe. ");
INSERT INTO lin_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Likabo moko te ya mbuma, oyo bokomemela Yawe ekozala na levire, pamba te bokotumba te levire to mafuta ya nzoyi lokola likabo bazikisa na moto mpo na Yawe. ");
INSERT INTO lin_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Okomema yango epai na Yawe lokola likabo ya bambuma ya liboso, kasi bokobonza yango te na etumbelo lokola makabo ya solo kitoko. ");
INSERT INTO lin_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Okotia mungwa na makabo na yo nyonso ya bambuma mpe okobosana te kotia mungwa na likabo na yo ya bambuma, pamba te ezali elembo ya boyokani oyo Nzambe na yo asalaki. Okotia mungwa na makabo na yo nyonso. ");
INSERT INTO lin_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Soki omemeli Yawe likabo ya bambuma ya liboso, okomema bambuma ya sika bakalinga na moto mpe batuta. ");
INSERT INTO lin_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Okosopela yango mafuta mpe ansa. Ezali likabo ya bambuma. ");
INSERT INTO lin_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Bongo Nganga-Nzambe asengeli kotumba eteni ya likabo elongo na ansa nyonso lokola ekaniseli. Ezali likabo bazikisa na moto mpo na Yawe. ");
INSERT INTO lin_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Soki moto moko alingi kobonza ngombe ya mobali to ya mwasi lokola mbeka ya boyokani, nyama ya kobonza liboso ya Yawe esengeli kozala ezanga mbeba. ");
INSERT INTO lin_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Akotia loboko na ye na moto ya mbeka, akokata yango kingo na ekuke ya Ndako ya kapo ya Bokutani. Bongo, Banganga-Nzambe, bana mibali ya Aron, bakosopa makila na yango na bangambo nyonso ya etumbelo. ");
INSERT INTO lin_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Kati na mbeka yango ya kozongisa boyokani, tala biteni oyo akobonza liboso ya Yawe lokola likabo bazikisa na moto : mafuta nyonso oyo ezipaka biloko ya kati, mafuta nyonso oyo ekangami na biloko ya kati, ");
INSERT INTO lin_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","bambuma mibale oyo ezalaka na kati ya loketo, mafuta oyo ezipaka yango, na kati-kati ya mipanzi na loketo. Akolongola bafwa mpe bambuma mibale wana. ");
INSERT INTO lin_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Bana mibali ya Aron bakotumba yango na etumbelo, na likolo ya mbeka ya kotumba oyo ezali likolo ya bakoni oyo ezali kopela moto. Ezali likabo bazikisa na moto, oyo solo kitoko na yango ekosepelisa Yawe. ");
INSERT INTO lin_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Soki alingi kobonza meme to ntaba lokola mbeka ya boyokani liboso ya Yawe, asengeli kobonza nyama ya mobali to ya mwasi oyo ezanga mbeba. ");
INSERT INTO lin_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Soki azali nde kobonza mwana meme lokola mbeka, akomema yango liboso ya Yawe. ");
INSERT INTO lin_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Akotia loboko na ye na moto ya mbeka na ye, akokata yango kingo liboso ya Ndako ya kapo ya Bokutani. Bongo bana mibali ya Aron bakosopa makila na yango na bangambo nyonso ya etumbelo. ");
INSERT INTO lin_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Kati na mbeka yango ya kozongisa boyokani, tala biteni oyo akobonza epai na Yawe lokola likabo bazikisa na moto : mafuta ya mbeka, mokila mobimba, mafuta oyo ezipaka biloko ya kati mpe mafuta nyonso oyo ekangami na kati, ");
INSERT INTO lin_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","bambuma mibale oyo ezalaka na kati ya loketo, mafuta oyo ezipaka yango mpe mafuta oyo ezali kati-kati ya mipanzi na loketo. Akolongola bafwa na bambuma mibale wana. ");
INSERT INTO lin_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Nganga-Nzambe akotumba biteni nyonso wana na etumbelo. Ezali likabo bazikisa na moto mpo na Yawe. ");
INSERT INTO lin_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Soki alingi kobonza ntaba ya mobali to ya mwasi, akomema yango liboso ya Yawe. Akotia loboko na ye na moto ya mbeka na ye, ");
INSERT INTO lin_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","akokata yango kingo liboso ya Ndako ya kapo ya Bokutani. Bongo bana mibali ya Aron bakosopa makila na yango na bangambo nyonso ya etumbelo. ");
INSERT INTO lin_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Akobonza liboso ya Yawe lokola likabo bazikisa na moto : mafuta nyonso oyo ezipaka biloko ya kati, ");
INSERT INTO lin_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","bambuma mibale oyo ezalaka na kati ya loketo, mafuta oyo ekangami na yango mpe bafwa. Bakolongola yango nzela moko na bambuma mibale oyo ezalaka na kati ya loketo. ");
INSERT INTO lin_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Nganga-Nzambe akotumba yango na etumbelo. Ezali likabo bazikisa na moto, oyo solo kitoko na yango ekosepelisa Yawe. Biteni nyonso ya mafuta ezali ya Yawe. ");
INSERT INTO lin_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Ezali mobeko ya seko mpo na milongo oyo ekoya, na bisika nyonso oyo bokovanda : bokolia te ezala mafuta to makila. › » ");
INSERT INTO lin_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Yawe ayebisaki Moyize : ");
INSERT INTO lin_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","« Loba na bana ya Isalaele mpe yebisa bango : ‹ Soki moto asali masumu to likambo moko oyo epekisami na mibeko ya Yawe, tala ndenge bokosala : ");
INSERT INTO lin_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","‘ Soki Nganga-Nzambe oyo bapakola mafuta asali masumu, bongo na nzela ya masumu na ye amemisi bato nyonso ngambo, akobonza liboso ya Yawe mpo na masumu oyo asili kosala, mwana ngombe ya mobali oyo ezanga mbeba lokola mbeka mpo na masumu. ");
INSERT INTO lin_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Boye akobonza liboso ya Yawe, mwana ngombe yango ya mobali na ekotelo ya Ndako ya kapo ya Bokutani. Akotia loboko na ye na moto ya mwana ngombe mpe akokata yango kingo liboso ya Yawe. ");
INSERT INTO lin_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Nganga-Nzambe oyo bapakola mafuta akozwa ndambo ya makila ya mwana ngombe yango ya mobali mpe akomema yango kati na Ndako ya kapo ya Bokutani. ");
INSERT INTO lin_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Nganga-Nzambe akozindisa mosapi na ye na makila mpe akosopa ndambo ya makila mbala sambo liboso ya Yawe, liboso ya rido ya Esika ya bule. ");
INSERT INTO lin_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Nganga-Nzambe akotia ndambo ya makila na maseke ya etumbelo ya ansa oyo ezali liboso ya Yawe kati na Ndako ya kapo ya Bokutani. Bongo ndambo mosusu ya makila ya ngombe oyo ekotikala, akosopa yango na makolo ya etumbelo ya bambeka ya kotumba, oyo ezali na ekotelo ya Ndako ya kapo ya Bokutani. ");
INSERT INTO lin_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Akolongola mafuta nyonso ya mwana ngombe oyo asili kobonza lokola mbeka mpo na masumu, mafuta oyo ezipaka biloko ya kati, mpe nyonso oyo ekangami kati na yango ");
INSERT INTO lin_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","elongo na bambuma mibale oyo ezalaka na loketo, na mafuta oyo ezali kati-kati ya mipanzi na loketo ; akolongola bafwa mpe bambuma wana mibale ");
INSERT INTO lin_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","ndenge balongolaka mafuta ya ngombe oyo babonzi lokola mbeka ya boyokani. Nganga-Nzambe akotumba yango na etumbelo ya mbeka ya kotumba. ");
INSERT INTO lin_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Kasi poso ya ngombe ya mobali, mosuni na yango nyonso, moto na yango, makolo na yango, biloko ya kati ; ");
INSERT INTO lin_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","elingi koloba biteni mosusu ya ngombe oyo etikali, Nganga-Nzambe asengeli komema yango libanda ya molako, na esika moko ya bule oyo ebongisama mpo na kotumba biteni ya mbeka oyo etikalaka, na esika oyo babwakaka putulu ; bongo bakotumba yango na likolo ya bakoni oyo ezali kopela moto, na esika oyo babwakaka putulu. ’ ");
INSERT INTO lin_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","‘ Soki lisanga mobimba ya Isalaele basali masumu na nko te mpe basali likambo moko oyo epekisami kati na mibeko ya Yawe, ata soki likambo yango eyebani te kati na lisanga, lisanga ekomema solo ngambo. ");
INSERT INTO lin_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Bakobonza ngombe ya mobali lokola mbeka mpo na masumu mpe bakomema yango liboso ya Ndako ya kapo ya Bokutani. ");
INSERT INTO lin_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Bakambi ya lisanga bakotia maboko na bango na moto ya ngombe yango liboso ya Yawe. ");
INSERT INTO lin_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Nganga-Nzambe oyo bapakola mafuta akomema ndambo ya makila ya ngombe yango kati na Ndako ya kapo ya Bokutani. ");
INSERT INTO lin_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Nganga-Nzambe akozindisa mosapi na ye kati na makila mpe akosopa ndambo ya makila mbala sambo liboso ya Yawe mpe ya rido. ");
INSERT INTO lin_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Nganga-Nzambe akotia makila na maseke ya etumbelo ya ansa oyo ezali liboso ya Yawe kati na Ndako ya kapo ya Bokutani mpe akosopa makila nyonso oyo ekotikala na se ya etumbelo ya mbeka ya kotumba oyo ezali na ekotelo ya Ndako ya kapo ya Bokutani. ");
INSERT INTO lin_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Akolongola mafuta nyonso ya ngombe mpe akotumba yango na etumbelo. ");
INSERT INTO lin_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Akosala ndenge kaka asalaki na ngombe oyo ebonzamaki lokola mbeka mpo na masumu. Na bongo, Nganga-Nzambe akosala mosala ya bolimbisi masumu ya bato ; mpe bakolimbisama. ");
INSERT INTO lin_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Nganga-Nzambe akomema ngombe yango libanda ya molako mpe akotumba yango ndenge atumbaki ngombe ya liboso oyo ezalaki mbeka mpo na masumu na ye moko Nganga-Nzambe. ’ ");
INSERT INTO lin_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","‘ Soki mokambi moko asali masumu na nko te, mpo ete asali likambo oyo epekisami na mibeko ya Yawe, Nzambe na ye ; amemi solo ngambo. ");
INSERT INTO lin_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Tango kaka akososola masumu na ye oyo asili kosala, asengeli kobonza lokola mbeka, ntaba ya mobali oyo ezanga mbeba. ");
INSERT INTO lin_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Akotia loboko na ye na moto ya ntaba yango mpe akokata yango kingo na esika oyo bakataka kingo ya bambeka ya kotumba, liboso ya Yawe. Ezali mbeka mpo na bolimbisi masumu. ");
INSERT INTO lin_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Nganga-Nzambe akozwa na mosapi na ye ndambo ya makila ya mbeka oyo ebonzami mpo na bolimbisi masumu, akotia yango na maseke ya etumbelo ya mbeka ya kotumba mpe akosopa makila oyo ekotikala na makolo ya etumbelo. ");
INSERT INTO lin_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Akotumba mafuta nyonso na etumbelo ndenge batumbaka mafuta ya mbeka ya boyokani. Boye, Nganga-Nzambe akosala mosala ya bolimbisi masumu ya mokonzi ; mpe mokonzi wana akolimbisama. ’ ");
INSERT INTO lin_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","‘ Soki moto moko kati na lisanga asali masumu na nko te, mpo ete asali likambo moko oyo epekisami na mibeko ya Yawe ; amemi solo ngambo. ");
INSERT INTO lin_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Tango kaka akososola masumu na ye oyo asali, asengeli kobonza lokola mbeka, ntaba ya mwasi ezanga mbeba. ");
INSERT INTO lin_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Akotia loboko na ye na moto ya mbeka mpo na masumu na esika oyo bakataka kingo ya bambeka ya kotumba. ");
INSERT INTO lin_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Nganga-Nzambe akozwa na mosapi na ye ndambo ya makila ya mbeka mpo na masumu, akotia yango na maseke ya etumbelo ya mbeka ya kotumba, mpe akosopa makila nyonso oyo etikali na makolo ya etumbelo. ");
INSERT INTO lin_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Akolongola mafuta nyonso ndenge kaka balongolaka mafuta na mbeka ya boyokani ; bongo Nganga-Nzambe akotumba yango na etumbelo lokola likabo oyo solo kitoko na yango ekosepelisa Yawe. Nganga-Nzambe akosala mosala ya bolimbisi masumu ya moto wana ; mpe moto yango akolimbisama. ");
INSERT INTO lin_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Soki abonzi mwana meme lokola mbeka mpo na masumu na ye, asengeli komema mwana meme ya mwasi ezanga mbeba. ");
INSERT INTO lin_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Akotia loboko na ye na moto ya mbeka mpo na masumu, na esika oyo bakataka kingo ya bambeka ya kotumba. ");
INSERT INTO lin_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Nganga-Nzambe akozwa na mosapi na ye ndambo ya makila ya mbeka mpo na masumu, mpe akotia yango na maseke ya etumbelo ya bambeka ya kotumba. Bongo akosopa makila nyonso oyo etikali, na makolo ya etumbelo. ");
INSERT INTO lin_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Akolongola mafuta nyonso ndenge kaka balongolaka mafuta ya mwana meme kati na mbeka ya boyokani. Mpe Nganga-Nzambe akotumba yango na etumbelo, na likolo ya makabo bazikisa na moto mpo na Yawe. Nganga-Nzambe akosala mosala ya bolimbisi masumu ya moto wana ; mpe moto yango akolimbisama. ’ › » ");
INSERT INTO lin_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","« Soki moto ayoki mbela ya elakeli mabe na tina na likambo oyo amonaki mpe ayebi, bongo aboyi kotatola yango, asali masumu mpe amemi ngambo. ");
INSERT INTO lin_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Soki moto asimbi na kozanga koyeba eloko ya mbindo, ezala ebembe ya nyama ya zamba ya mbindo to ebembe ya nyama ya mboka ya mbindo to ebembe ya nyama ya mbindo oyo etambolaka na libumu, moto yango akomi mbindo mpe amemi ngambo. ");
INSERT INTO lin_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Soki moto asimbi na kozanga koyeba moto ya mbindo, mbindo oyo ezwamaka na kotutana, akokoma mbindo mpe akomema ngambo na yango tango kaka akososola yango. ");
INSERT INTO lin_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Soki moto alapi ndayi na kozanga koyeba, ata soki ezali mpo na bolamu na ye to ya moto mosusu, bongo ayei kososola yango na sima, moto yango akomema ngambo. ");
INSERT INTO lin_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Boye, soki amemi ngambo na moko kati na makambo oyo, asengeli kotubela masumu oyo asali ");
INSERT INTO lin_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","mpe kobonzela Yawe meme to ntaba ya mwasi lokola mbeka mpo na masumu na ye. Bongo, Nganga-Nzambe akosala mosala ya bolimbisi masumu ya moto yango. ");
INSERT INTO lin_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Soki moto azangi makoki ya kozwa mwana meme, akomema epai na Yawe bibenga mibale ya zamba to bana mibale ya ebenga ya mboka : moko ekozala mbeka mpo na masumu, mpe mosusu, mpo na mbeka ya kotumba. ");
INSERT INTO lin_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Akomema yango epai ya Nganga-Nzambe oyo akobonza liboso mbeka ya masumu : akokata yango kingo kasi akolongola moto te. ");
INSERT INTO lin_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Akosopa ndambo ya makila na yango pembeni ya etumbelo ; mpe ndambo mosusu, na makolo ya etumbelo : ezali mbeka mpo na masumu. ");
INSERT INTO lin_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Sima na yango, Nganga-Nzambe akobonza mbeka oyo ya mibale lokola mbeka ya kotumba, kolanda ndenge ekatama na mibeko. Boye, Nganga-Nzambe akosala mosala ya bolimbisi masumu ya moto wana ; mpe moto yango akolimbisama. ");
INSERT INTO lin_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Soki azangi makoki ya kozwa bibenga mibale ya zamba to bana mibale ya ebenga ya mboka, akomema epai ya Nganga-Nzambe bakilo misato ya farine lokola mbeka. Akotia te mafuta to ansa likolo na yango, pamba te ezali mbeka mpo na masumu. ");
INSERT INTO lin_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Sima, akomema yango epai ya Nganga-Nzambe oyo akozwa loboko moko lokola eteni ya ekaniseli mpe akotumba yango na moto mpo na Yawe : ezali mbeka mpo na masumu. ");
INSERT INTO lin_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Nganga-Nzambe akosala mosala ya bolimbisi masumu ya moto wana ; mpe moto yango akolimbisama. Ndambo ya mbeka oyo ekotikala ekozala ya Nganga-Nzambe, ndenge kaka esalemaka mpo na mbeka ya bambuma. » ");
INSERT INTO lin_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","« Soki moto abuki mobeko mpe asali na nko te masumu liboso ya biloko oyo ebulisama mpo na Yawe, akobonzela Yawe lokola mbeka mpo na masumu na ye meme ya mobali ezanga mbeba, oyo akozwa kati na etonga na ye. Meme yango esengeli kokokana na motuya ya palata oyo okokata, kolanda ndenge bamekaka kilo kati na Esika ya bule : ezali mbeka mpo na kozongisa boyokani. ");
INSERT INTO lin_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Lisusu, mpo na mabe oyo asali liboso ya Esika ya bule, moto yango asengeli kobakisa likolo ya mbeka mpo na kozongisa boyokani : eteni moko kati na biteni mitano ya motuya ya mbeka wana. Boye akopesa biloko nyonso epai ya Nganga-Nzambe, mpe Nganga-Nzambe akosala mosala ya bolimbisi masumu ya moto wana na nzela ya meme ya mobali oyo ebonzami lokola mbeka mpo na kozongisa boyokani ; boye moto yango akolimbisama. ");
INSERT INTO lin_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Soki moto asali na kozanga koyeba masumu mpo ete abuki mobeko na Yawe, amemi ngambo ; mpe akomema mokumba ya mabe na ye. ");
INSERT INTO lin_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Bongo, lokola mbeka mpo na kozongisa boyokani, akomema epai ya Nganga-Nzambe meme ya mobali oyo ezanga mbeba, oyo akozwa kati na etonga na ye. Meme yango esengeli kokokana na motuya ya palata oyo okokata. Nganga-Nzambe akosala mosala ya bolimbisi masumu mpo na mabe oyo moto wana asalaki na kozanga koyeba ; boye moto yango akolimbisama. ");
INSERT INTO lin_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Ezali mbeka mpo na kozongisa boyokani, pamba te amemaki ngambo na ndenge asalaki masumu liboso ya Yawe. » ");
INSERT INTO lin_vpl VALUES ("LV5_20","004_5_20","LEV","5","20","20","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("LV5_21","004_5_21","LEV","5","21","21","« Soki moto asali masumu mpe abuki mobeko ya Yawe na kokosa moninga na ye mpo na eloko oyo babombisaki epai na ye to oyo adefaki to oyo ayibaki to oyo abotolaki na makasi ");
INSERT INTO lin_vpl VALUES ("LV5_22","004_5_22","LEV","5","22","22","to atako amoni eloko oyo ebungaki, kasi akosi mpe alapi ndayi ya lokuta na tina na moko kati na masumu oyo moto akoki kosala ; ");
INSERT INTO lin_vpl VALUES ("LV5_23","004_5_23","LEV","5","23","23","moto oyo asali masumu ya boye mpe amemi ngambo, akozongisa eloko oyo ayibisaki to oyo abotolaki na makasi to oyo babombisaki epai na ye to oyo amonaki sima na kobungisa yango. ");
INSERT INTO lin_vpl VALUES ("LV5_24","004_5_24","LEV","5","24","24","To lisusu, akozongisa eloko nyonso oyo na tina na yango ye alapaki ndayi ya lokuta mpe akobakisa eteni moko kati na biteni mitano. Akozongisa yango na nkolo eloko na mokolo oyo akobonza mbeka na ye mpo na masumu. ");
INSERT INTO lin_vpl VALUES ("LV5_25","004_5_25","LEV","5","25","25","Mpe akomema epai ya Nganga-Nzambe mbeka na ye mpo na kozongisa boyokani elongo na Yawe. Akomema meme ya mobali oyo ezanga mbeba ; akozwa yango kati na bameme mpe bantaba na ye kolanda ndenge okokata. ");
INSERT INTO lin_vpl VALUES ("LV5_26","004_5_26","LEV","5","26","26","Nganga-Nzambe akosala mpo na moto wana, liboso ya Yawe, mosala ya bolimbisi masumu ; mpe moto yango akolimbisama. » ");
INSERT INTO lin_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","« Pesa mitindo oyo epai ya Aron mpe epai ya bana na ye ya mibali : ‹ Tala mobeko mpo na mbeka ya kotumba : mbeka ya kotumba ekowumela na likolo ya motalaka ya etumbelo butu mobimba kino na tongo, mpe moto ya etumbelo ekozikisa yango. ");
INSERT INTO lin_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","Nganga-Nzambe akolata nzambala na ye ya lino mpe bakaputula na ye ya lino. Akolongola putulu ya mbeka ya kotumba oyo moto ezikisaki na etumbelo mpe akotia yango na mopanzi ya etumbelo. ");
INSERT INTO lin_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Sima, akolongola bilamba wana mpe akolata bilamba mosusu ; bongo akomema putulu na libanda ya molako, na esika ya peto. ");
INSERT INTO lin_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","Moto ya etumbelo ekobanda kopela tango nyonso mpe ekoki kokufa te. Nganga-Nzambe akobanda kobakisa tongo nyonso bakoni mpe kotia mbeka ya kotumba na likolo ya bakoni ; bongo akotumba biteni ya mafuta ya mbeka ya boyokani na likolo na yango. ");
INSERT INTO lin_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Moto esengeli kopela tango nyonso na etumbelo, ekoki kokufa te. › ");
INSERT INTO lin_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","‹ Tala mobeko mpo na likabo ya gato : ‘ Bana mibali ya Aron bakomema yango liboso ya Yawe, liboso ya etumbelo. ");
INSERT INTO lin_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Nganga-Nzambe akozwa na loboko na ye ndambo ya farine, mafuta mpe ansa nyonso oyo ezali na likolo ya gato ; akotumba yango na likolo ya etumbelo mpo ete solo kitoko na yango esepelisa Yawe mpe ezala ekaniseli mpo na Ye. ");
INSERT INTO lin_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","Ndambo oyo ekotikala, Aron mpe bana na ye ya mibali bakolia yango. Kasi bakolia yango ezanga levire, na Esika ya bule, na libanda ya Ndako ya kapo ya Bokutani. ");
INSERT INTO lin_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Bakotumba yango te na levire : ezali eteni oyo napesi bango kati na bambeka na Ngai oyo etumbami na moto : ezali eloko ya bule penza lokola mbeka mpo na masumu mpe mpo na kozongisa boyokani. ");
INSERT INTO lin_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Bana mibali nyonso kati na bakitani ya Aron bakolia yango. Ezali eteni na bango mpo na tango nyonso mpe na milongo nyonso kati na makabo bazikisa na moto mpo na Yawe. Bato nyonso oyo bakosimba yango bakokoma bule. ’ › » ");
INSERT INTO lin_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","« Tala likabo oyo Aron mpe bana na ye ya mibali bakopesa epai na Yawe, na mokolo oyo bakozwa epakolami : eteni ya zomi ya efa ya farine lokola likabo ya tango nyonso. Na tongo, akopesa eteni moko kati na biteni mibale ; mpe eteni mosusu, na pokwa. ");
INSERT INTO lin_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Okosangisa yango liboso na mafuta, bongo okokalinga yango na kikalungu. Sima okobonza yango na biteni lokola mbeka oyo solo kitoko na yango ekosepelisa Yawe. ");
INSERT INTO lin_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Mwana mobali ya Aron oyo bakopakola mafuta mpo na kokitana na Aron lokola Nganga-Nzambe akobonza mpe likabo yango : ezali likabo ya libela mpo na Yawe mpe bakotumba yango mobimba. ");
INSERT INTO lin_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Mbeka nyonso oyo Nganga-Nzambe akobonza na mobimba na yango ekoliama te, ezala ata ndambo na yango. » ");
INSERT INTO lin_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","« Loba na Aron mpe na bana na ye ya mibali : ‹ Tala mobeko ya mbeka mpo na masumu : ‘ Bakokata kingo ya mbeka mpo na masumu liboso ya Yawe, na esika oyo bakataka bakingo ya bambeka ya kotumba ; ezali mbeka ya bule penza. ");
INSERT INTO lin_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Nganga-Nzambe oyo azali kobonza yango mpo na masumu akolia yango na Esika ya bule, na libanda ya Ndako ya kapo ya Bokutani. ");
INSERT INTO lin_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Moto nyonso oyo akosimba mosuni na yango akozala bule. Soki kaka makila ya mbeka yango ezwi elamba na ye, asengeli kosukola esika oyo ezwi makila, na esika moko ya bule. ");
INSERT INTO lin_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Bongo soki basaleli nzungu ya mabele mpo na kokalinga mosuni ya mbeka mpo na masumu, bakopanza nzungu yango. Soki bakalingi yango na nzungu ya bronze, bakopalola nzungu yango mpe bakosukola yango na mayi ebele. ");
INSERT INTO lin_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Kaka mibali oyo bazali na libota ya Nganga-Nzambe nde bakoki kolia yango, pamba te ezali eloko ya bule penza. ");
INSERT INTO lin_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Nzokande, mbeka moko te mpo na masumu ekoki koliama soki bamemi makila na yango na Ndako ya kapo ya Bokutani mpo na kosala mosala ya bolimbisi masumu ; esengeli kotumba yango na moto. ’ › » ");
INSERT INTO lin_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","« ‹ Tala mobeko ya mbeka mpo na kozongisa boyokani ; ezali eloko ya bule penza : ");
INSERT INTO lin_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","‘ Bakokata kingo ya mbeka mpo na kozongisa boyokani, na esika oyo bakataka kingo ya bambeka ya kotumba. Bongo bakobwaka makila na yango pembeni-pembeni ya etumbelo. ");
INSERT INTO lin_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Bakobonza biteni na yango ya mafuta : mokila, mafuta oyo ezipaka biloko ya kati, ");
INSERT INTO lin_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","bambuma mibale oyo ezalaka na kati ya loketo mpe mafuta oyo ezipaka yango, oyo ezali kati na mipanzi mpe loketo. Bakolongola bafwa mpe bambuma mibale wana. ");
INSERT INTO lin_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Nganga-Nzambe akotumba yango na etumbelo lokola likabo bazikisa na moto mpo na Yawe : ezali mbeka mpo na kozongisa boyokani. ");
INSERT INTO lin_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Mibali nyonso kati na Banganga-Nzambe bakoki kolia yango. Basengeli kolia yango na Esika ya bule : ezali eloko ya bule penza. ");
INSERT INTO lin_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Mobeko yango ezali kaka moko, ezala mpo na mbeka mpo na kozongisa boyokani to mpo na mbeka ya masumu. Nyama ezali ya Nganga-Nzambe oyo asali mosala ya bolimbisi masumu. ");
INSERT INTO lin_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Nganga-Nzambe oyo akobonza mbeka ya kotumba mpo na moto, akozwa poso ya nyama oyo abonzi mpe ekozala ya ye. ");
INSERT INTO lin_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Likabo nyonso ya gato oyo batumbi na fulu ya moto to bakalingi na kikalungu to mpe batumbi na likolo ya manzanza ezali ya Nganga-Nzambe oyo abonzi yango. ");
INSERT INTO lin_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Likabo nyonso ya gato oyo basangisi na mafuta to oyo ezali ya kokawuka ekozala ya bana mibali nyonso ya Aron ; bakozwa yango ndenge moko. ’ › ");
INSERT INTO lin_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","‹ Tala mibeko mpo na mbeka ya boyokani oyo moto akoki kobonza epai na Yawe : ");
INSERT INTO lin_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","‘ Soki moto abonzi yango mpo na kozongisa matondi, asengeli kobonza, elongo na mbeka ya kozongisa matondi, likabo ya bagato ezanga levire kasi basangisa na mafuta, bagalete ezanga levire kasi bapakola yango mafuta mpe bagato basala na farine oyo basangisa malamu na mafuta. ");
INSERT INTO lin_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Na likolo ya mbeka na ye ya boyokani oyo abonzi mpo na kozongisa matondi, akobakisa likabo ya bagato oyo esalemi na farine batia levire. ");
INSERT INTO lin_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Akomema eteni ya likabo moko na moko mpe akobonza yango epai na Yawe : ekozala ya Nganga-Nzambe oyo asopaki makila ya mbeka yango ya boyokani pembeni-pembeni ya etumbelo. ");
INSERT INTO lin_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Mosuni ya mbeka ya boyokani oyo abonzi mpo na kozongisa matondi esengeli koliama kaka na mokolo oyo abonzi yango, eloko moko te ekoki kotikala kino na tongo. ");
INSERT INTO lin_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Soki abonzi mbeka na ye ya boyokani mpo ete apesaki elaka, na kolapa ndayi to wuta na mokano ya motema na ye moko, mbeka esengeli koliama kaka na mokolo oyo abonzi yango. Kasi soki ndambo etikali, ekoliama na mokolo oyo ekolanda. ");
INSERT INTO lin_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Mosuni oyo ekotikala na mbeka, na mokolo oyo ekolanda, esengeli kotumba yango. ");
INSERT INTO lin_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Soki mosuni ya mbeka ya boyokani eliami na mokolo ya misato, mbeka yango ekondimama te. Ekotangama te likolo ya moto oyo abonzi yango, pamba te ezali likabo ya mbindo ; mpe moto oyo akomeka kolia yango akomema masumu. ");
INSERT INTO lin_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Bongo soki mosuni yango etutani na eloko ya mbindo, esengeli batumba mosuni yango na moto. Kasi mpo na oyo etali mosuni ya mbeka ya boyokani, kaka moto oyo azali peto nde akoki kolia yango. ");
INSERT INTO lin_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Nzokande, soki moto ya mbindo alie mosuni ya mbeka ya boyokani oyo ezali ya Yawe, basengeli kolongola ye kati na bato na ye. ");
INSERT INTO lin_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Soki moto moko asimbi eloko ya mbindo, ezala moto ya mbindo to nyama ya mbindo to eloko mosusu ya mabe mpe ya mbindo, mpe alie mosuni ya mbeka ya boyokani oyo ezali ya Yawe, basengeli kolongola ye kati na bato na ye. ’ › » ");
INSERT INTO lin_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","« Loba na bana ya Isalaele : ‹ Bokolia te mafuta ya ngombe, ya meme to ya ntaba. ");
INSERT INTO lin_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Nzokande bokoki na bino kosalela mafuta ya nyama oyo ekufa to ya nyama oyo babomi na nyama ya zamba misala nyonso, kasi bokoki te kolia yango. ");
INSERT INTO lin_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Moto nyonso oyo akolia mafuta ya nyama oyo babonzi epai na Yawe lokola likabo bazikisa na moto, bakolongola ye kati na bato na ye. ");
INSERT INTO lin_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Na esika nyonso oyo bokovanda, bokoki te kolia makila, ezala makila ya ndeke to ya nyama. ");
INSERT INTO lin_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Moto nyonso oyo akolia makila, bakolongola ye kati na bato na ye. › » ");
INSERT INTO lin_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","« Loba na bana ya Isalaele : ‹ Moto nyonso oyo akobonza epai na Yawe mbeka ya boyokani akomema eteni ya mbeka na ye lokola mbeka na ye epai na Yawe. ");
INSERT INTO lin_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Akomema yango ye moko, na maboko na ye, mpo ete etumbama lokola likabo bazikisa na moto mpo na Yawe. Akomema mafuta mpe tolo ya mbeka mpe akotombola liboso ya Yawe tolo yango lokola likabo ya kotombola. ");
INSERT INTO lin_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Nganga-Nzambe akotumba mafuta na etumbelo, kasi tolo ekozala mpo na Aron mpe bana na ye ya mibali. ");
INSERT INTO lin_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Bokopesa epai ya Nganga-Nzambe lokola likabo mopende ya ngambo ya loboko ya mobali ya bambeka ya boyokani. ");
INSERT INTO lin_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Mwana mobali ya Aron oyo akobonza makila mpe mafuta ya mbeka ya boyokani akozwa mopende ya ngambo ya loboko ya mobali. ");
INSERT INTO lin_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Pamba te, nakobanda kozwa kati na bambeka ya boyokani ya bana ya Isalaele tolo oyo batomboli mpe mopende oyo babonzi lokola likabo ya kotombola. Napesi yango epai ya Nganga-Nzambe Aron mpe bana na ye ya mibali lokola eteni na bango oyo bakobanda kozwa tango nyonso epai ya bana ya Isalaele. ");
INSERT INTO lin_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Yango nde eteni ya makabo bazikisa na moto, oyo bana ya Isalaele basengeli kopesa epai ya Aron mpe bana na ye ya mibali wuta mokolo oyo akobulisa bango mpo na kosalela Yawe lokola Banganga-Nzambe. › » ");
INSERT INTO lin_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Yango nde mitindo oyo Yawe apesaki epai ya bana ya Isalaele mpo ete, wuta mokolo oyo apakolaki bango mafuta, babanda kopesa bango yango lokola eteni na bango. Ezali mibeko ya seko mpo na milongo nyonso ya bana na bango. ");
INSERT INTO lin_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Yango nde mibeko mpo na mbeka ya kotumba, likabo ya gato, mbeka mpo na masumu, mbeka mpo na kozongisa boyokani, mbeka mpo na kobulisa mpe mpo na mbeka ya boyokani ");
INSERT INTO lin_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","oyo Yawe apesaki epai ya Moyize, na ngomba Sinai kati na esobe ya Sinai na mokolo oyo apesaki mitindo epai ya bana ya Isalaele ete babonzela Ye bambeka mpe makabo na bango. ");
INSERT INTO lin_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","« Mema Aron mpe bana na ye ya mibali, bilamba na bango ya mosala ya bonganga-Nzambe, mafuta ya epakolami, mwana ngombe ya mobali mpo na mbeka ya masumu, bameme mibale ya mibali, mpe kitunga oyo ezali na mapa ezanga levire ; ");
INSERT INTO lin_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","mpe sangisa lisanga mobimba na ekotelo ya Ndako ya kapo ya Bokutani. » ");
INSERT INTO lin_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Moyize asalaki ndenge Yawe atindaki ye mpe lisanga esanganaki na ekotelo ya Ndako ya kapo ya Bokutani. ");
INSERT INTO lin_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Moyize alobaki na lisanga makambo oyo Yawe atindaki ye kosala. ");
INSERT INTO lin_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Moyize amemaki Aron elongo na bana na ye ya mibali liboso mpe asukolaki bango na mayi. ");
INSERT INTO lin_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Alatisaki Aron nzambala mpe akangaki ye mokaba na loketo ; alatisaki ye kazaka mpe efode, azingelaki ye na mokaba ya efode. ");
INSERT INTO lin_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Alatisaki Aron elamba ya tolo mpe atiaki Urimi mpe tumimi likolo ya elamba yango. ");
INSERT INTO lin_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Akangaki kitendi na moto ya Aron ; bongo liboso na yango, atiaki medaye ya wolo, elembo ya libulisi, ndenge kaka Yawe atindaki Moyize. ");
INSERT INTO lin_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Moyize azwaki mafuta ya epakolami mpe apakolaki Mongombo elongo na biloko nyonso oyo ezalaki kati na yango ; na bongo nde abulisaki yango. ");
INSERT INTO lin_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Asopaki na etumbelo ndambo ya mafuta mbala sambo mpe apakolaki mafuta mpo na kobulisa etumbelo, bisalelo na yango nyonso, sani monene mpe se na yango. ");
INSERT INTO lin_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Asopaki ndambo ya mafuta ya epakolami na moto ya Aron mpe apakolaki ye mafuta yango mpo na kobulisa ye. ");
INSERT INTO lin_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Moyize amemaki bana mibali ya Aron liboso, alatisaki bango banzambala, akangaki bango mikaba na loketo mpe alatisaki bango bikoti, ndenge kaka Yawe atindaki Moyize. ");
INSERT INTO lin_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Bongo amemaki ngombe ya mobali lokola mbeka ya masumu ; Aron elongo na bana na ye ya mibali batiaki maboko na bango na moto ya ngombe yango. ");
INSERT INTO lin_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Moyize akataki yango kingo mpe asalelaki mosapi na ye mpo na kotia makila ya ngombe yango na maseke ya etumbelo. Boye, apetolaki etumbelo ; bongo asopaki makila oyo etikalaki, na makolo ya etumbelo oyo abulisaki mpo na mosala ya bolimbisi masumu. ");
INSERT INTO lin_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Moyize azwaki lisusu mafuta nyonso oyo ezalaki pembeni-pembeni ya biloko ya kati, mafuta oyo ezipaka bafwa mpe bambuma nyonso mibale oyo ezalaka kati na loketo elongo na mafuta na yango, atumbaki yango na etumbelo. ");
INSERT INTO lin_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Kasi atumbaki na libanda ya molako ngombe yango ya mobali, poso na yango, misuni na yango mpe nyei na yango, ndenge kaka Yawe atindaki Moyize. ");
INSERT INTO lin_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Bongo amemaki meme ya mobali mpo na kobonza yango lokola mbeka ya kotumba ; Aron mpe bana na ye ya mibali batiaki maboko na bango na moto na yango. ");
INSERT INTO lin_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Moyize akataki kingo ya meme yango mpe asopaki makila na yango na bapembeni nyonso ya etumbelo. ");
INSERT INTO lin_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Akataki-kataki meme yango na biteni. Moyize atumbaki biteni yango, moto mpe mafuta. ");
INSERT INTO lin_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Asukolaki na mayi biloko ya kati mpe makolo, atumbaki meme yango mobimba na likolo ya etumbelo ; ezalaki mbeka ya kotumba, likabo bazikisa na moto mpo na Yawe, oyo solo kitoko na yango esepelisaki Yawe, ndenge kaka Yawe atindaki Moyize. ");
INSERT INTO lin_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Bongo amemaki meme mosusu ya mobali mpo na libulisi ; Aron mpe bana na ye ya mibali batiaki maboko na bango na moto na yango. ");
INSERT INTO lin_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Moyize akataki yango kingo, azwaki ndambo ya makila na yango mpe atiaki yango na songe ya litoyi ya ngambo ya loboko ya mobali ya Aron, na mosapi ya monene ya loboko ya mobali ya Aron mpe na mosapi ya monene ya lokolo ya ngambo ya loboko ya mobali ya Aron. ");
INSERT INTO lin_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Moyize amemaki bana mibali ya Aron liboso, atiaki ndambo ya makila na basonge ya matoyi na bango ya ngambo ya loboko ya mobali, na misapi ya minene ya maboko na bango ya mobali mpe na misapi ya minene ya makolo na bango ya ngambo ya loboko ya mobali. Sima, asopaki makila na bangambo nyonso ya etumbelo. ");
INSERT INTO lin_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Azwaki biteni oyo ya mafuta : mokila, mafuta nyonso oyo ezalaka pembeni-pembeni ya biloko ya kati, mafuta oyo ezipi bafwa, bambuma mibale oyo ezalaka kati na loketo elongo na mafuta na yango mpe mopende ya lokolo ya ngambo ya loboko ya mobali. ");
INSERT INTO lin_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Kati na kitunga ya mapa ezanga levire oyo ezalaki liboso ya Yawe, azwaki lipa moko, gato moko balamba na mafuta mpe galeti moko ; atiaki yango likolo ya biteni ya mafuta mpe ya mopende ya ngambo ya loboko ya mobali. ");
INSERT INTO lin_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Atiaki biloko yango nyonso na maboko ya Aron mpe ya bana na ye ya mibali ; bongo ayebisaki bango ete batombola yango liboso ya Yawe lokola likabo ya kotombola. ");
INSERT INTO lin_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Moyize azwaki yango lisusu na maboko na bango mpe atumbaki yango na etumbelo, na likolo ya mbeka ya kotumba. Ezalaki mbeka ya libulisi, likabo bazikisa na moto mpo na Yawe, oyo solo kitoko na yango esepelisaka Yawe. ");
INSERT INTO lin_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Moyize azwaki tolo ya meme ya libulisi, atombolaki yango liboso ya Yawe lokola mbeka ya kotombola ndenge kaka Yawe atindaki Moyize. ");
INSERT INTO lin_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Moyize azwaki na etumbelo, mafuta ya epakolami mpe ndambo ya makila ; asopelaki yango Aron, bilamba na ye, bana na ye ya mibali mpe bilamba na bango. Bongo abulisaki Aron, bilamba na ye, bana na ye ya mibali mpe bilamba na bango. ");
INSERT INTO lin_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Moyize alobaki na Aron mpe na bana na ye ya mibali : « Bolamba mosuni na ekotelo ya Ndako ya kapo ya Bokutani, mpe bolia yango wana elongo na lipa oyo ezali kati na kitunga oyo ezali na mbeka ya libulisi, ndenge kaka natindaki tango nalobaki : ‹ Aron mpe bana na ye ya mibali nde bakolia yango. › ");
INSERT INTO lin_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Oyo ekotikala kati na mosuni ya mbeka ya libulisi mpe lipa, bokotumba yango na moto. ");
INSERT INTO lin_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Mikolo sambo, bokolongwa te na ekotelo ya Ndako ya kapo ya Bokutani kino mikolo ya libulisi na bino ekokoka, pamba te libulisi na bino ekowumela mikolo sambo. ");
INSERT INTO lin_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Makambo oyo esalemi lelo, yango nde Yawe atindi mpo na kosala mosala ya bolimbisi masumu na bino. ");
INSERT INTO lin_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Bokovanda mikolo sambo, butu mpe moyi, na ekotelo ya Ndako ya kapo ya Bokutani mpe bokosala makambo oyo Yawe atindi mpo ete bokufa te. Pamba te, yango nde epesamelaki ngai lokola mitindo. » ");
INSERT INTO lin_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Aron mpe bana na ye ya mibali basalaki makambo nyonso oyo Yawe atindaki Moyize. ");
INSERT INTO lin_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Na mokolo ya mwambe, Moyize abengisaki Aron, bana na ye ya mibali mpe bakambi ya Isalaele. ");
INSERT INTO lin_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Alobaki na Aron : « Zwa mwana ngombe lokola mbeka mpo na masumu na bino mpe meme ya mobali mpo na mbeka na bino ya kotumba ; nyonso mibale esengeli kozala ezanga mbeba, mpe bonza yango liboso ya Yawe. ");
INSERT INTO lin_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Bongo loba na bana ya Isalaele : ‹ Bozwa ntaba ya mobali lokola mbeka ya masumu, mwana ngombe mpe mwana meme ezanga mbeba mpe ya mobu moko lokola mbeka ya kotumba, ");
INSERT INTO lin_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","mpe ngombe moko ya mobali mpe meme moko ya mobali lokola mbeka ya boyokani, mpo na kobonza lokola mbeka liboso ya Yawe elongo na likabo ya bambuma basangisa na mafuta. Pamba te, na mokolo ya lelo, Yawe akobimela bino. › » ");
INSERT INTO lin_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Bamemaki liboso ya Ndako ya kapo ya Bokutani biloko oyo Moyize atindaki bango ; mpe lisanga mobimba bapusanaki mpe batelemaki liboso ya Yawe. ");
INSERT INTO lin_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Moyize alobaki : « Tala makambo oyo Yawe atindi bino kosala mpo ete nkembo na Yawe ebimela bino. » ");
INSERT INTO lin_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Moyize alobaki na Aron : « Pusana pene ya etumbelo mpe bonza mbeka na yo ya masumu mpe mbeka na yo ya kotumba ; mpe sala mosala ya bolimbisi masumu mpo na yo moko mpe mpo na bato. Bonza likabo ya bato mpe sala mosala ya bolimbisi masumu mpo na bango, kolanda ndenge Yawe apesaki mitindo. » ");
INSERT INTO lin_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Aron apusanaki pene ya etumbelo mpe akataki kingo ya mwana ngombe lokola mbeka mpo na masumu na ye moko. ");
INSERT INTO lin_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Bongo bana mibali ya Aron bamemelaki ye makila. Aron azindisaki mosapi na ye kati na makila, apakolaki makila yango na maseke ya etumbelo mpe asopaki makila oyo etikalaki na makolo ya etumbelo. ");
INSERT INTO lin_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Atumbaki na etumbelo : mafuta, bambuma mibale oyo ezalaka na kati ya loketo mpe fwa oyo ewutaki na mbeka mpo na masumu, ndenge kaka Yawe atindaki Moyize. ");
INSERT INTO lin_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Atumbaki na moto mosuni mpe poso na libanda ya molako. ");
INSERT INTO lin_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Aron akataki kingo ya mbeka ya kotumba. Bana na ye ya mibali bapesaki ye makila mpe asopaki yango na bangambo nyonso ya etumbelo. ");
INSERT INTO lin_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Bapesaki ye mbeka ya kotumba bakata biteni-biteni elongo na moto, mpe atumbaki yango na etumbelo. ");
INSERT INTO lin_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Asukolaki biloko ya kati mpe makolo, atumbaki yango na etumbelo, na likolo ya mbeka ya kotumba. ");
INSERT INTO lin_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Aron amemaki likabo oyo ezalaki mpo na bato. Azwaki ntaba ya mobali lokola mbeka mpo na masumu ya bato, akataki yango kingo mpe abonzaki yango lokola mbeka ya masumu ndenge asalaki na mbeka ya liboso. ");
INSERT INTO lin_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Aron amemaki mbeka ya kotumba mpe abonzaki yango kolanda mitindo. ");
INSERT INTO lin_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Amemaki mpe likabo ya bambuma, atondisaki yango na loboko na ye mpe atumbaki yango na etumbelo elongo na mbeka ya kotumba ya tongo. ");
INSERT INTO lin_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Aron akataki kingo ya ngombe ya mobali mpe ya meme ya mobali lokola mbeka ya boyokani mpo na bato ; bana na ye ya mibali bapesaki ye makila mpe asopaki yango na bangambo nyonso ya etumbelo. ");
INSERT INTO lin_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Bapesaki ye mpe biteni ya mafuta ya ngombe ya mobali mpe ya meme ya mobali, mokila, mafuta ya biloko ya kati, mafuta ya bambuma mibale oyo ezalaka na kati ya loketo mpe bafwa. ");
INSERT INTO lin_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","Batiaki biteni yango na batolo ya banyama nyonso mibale mpe Aron atumbaki mafuta na etumbelo. ");
INSERT INTO lin_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Aron atombolaki liboso ya Yawe likabo ya kotombola, batolo mpe mopende ya ngambo ya loboko ya mobali ndenge Moyize atindaki. ");
INSERT INTO lin_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Aron atombolaki maboko na ye epai ya bato mpe apambolaki bango ; bongo akitaki sima na kobonza mbeka ya masumu, mbeka ya kotumba mpe mbeka ya boyokani. ");
INSERT INTO lin_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Moyize mpe Aron bakotaki na Ndako ya kapo ya Bokutani. Bongo tango babimaki, bapambolaki bato, mpe nkembo ya Yawe ebimelaki bato nyonso. ");
INSERT INTO lin_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Moto ebimaki liboso ya Yawe mpe ezikisaki na etumbelo, mbeka ya kotumba mpe biteni ya mafuta. Mpe tango bamonaki bongo, bagangaki na esengo mpe bakweyaki bilongi na bango kino na se. ");
INSERT INTO lin_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Bana mibali ya Aron, Nadabi mpe Abiyu, bazwaki moko na moko mbabola na ye ; batiaki yango makala ya moto mpe batiaki ansa na likolo ya makala yango. Lokola bakokisaki te kolanda oyo basengelaki kosala, bamemaki moto ya mopaya liboso ya Yawe. ");
INSERT INTO lin_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Boye moto ebimaki longwa liboso ya Yawe mpe etumbaki bango nyonso ; bakufaki na mbala moko. ");
INSERT INTO lin_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Moyize alobaki na Aron : « Tomoni kokokisama ya maloba oyo Yawe asakolaki tango alobaki : ‹ Bato nyonso oyo bakobelema liboso na Ngai basengeli kotosa bosantu na Ngai, mpe Ngai nakomonisa nkembo na Ngai na miso ya bato nyonso. › » Aron alobaki ata liloba moko te. ");
INSERT INTO lin_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Moyize abengisaki Mishaeli mpe Elitsafani, bana mibali ya Uzieli, noko ya Aron. Alobaki na bango : « Boya kolongola bibembe ya bandeko na bino liboso ya Esika ya bule mpe bomema yango na libanda ya molako. » ");
INSERT INTO lin_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Basalaki ndenge kaka Moyize alobaki na bango : bapusanaki mpe bamemaki bibembe elongo na banzambala na bango na libanda ya molako. ");
INSERT INTO lin_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Sima na yango, Moyize alobaki na Aron, Eleazari mpe Itamari, bana mibali ya Aron : « Bopanza te suki ya mito na bino, bopasola te bilamba na bino lokola nde bozali na matanga, noki te bokokufa mpe bokobenda kanda ya Yawe likolo ya lisanga mobimba. Ezali bandeko na bino nyonso ya Isalaele nde bakolela bato oyo Yawe atumbi na moto. ");
INSERT INTO lin_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Kasi bino, bosengeli te kolongwa liboso ya Ndako ya kapo ya Bokutani, noki te bokokufa ; pamba te bapakola bino mafuta mpo na kosala mosala ya Yawe. » Aron mpe bana na ye batosaki makambo oyo Moyize alobaki na bango. ");
INSERT INTO lin_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Yawe alobaki na Aron : ");
INSERT INTO lin_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","« Tango bokobanda kokota na Ndako ya kapo ya Bokutani, yo mpe bana na yo ya mibali, bosengeli te komela masanga oyo elangwisaka, noki te bokokufa. Yango ezali mobeko ya libela na libela mpo na bino mpe milongo nyonso oyo ekoya sima na bino, ");
INSERT INTO lin_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","mpo ete boyeba kokesenisa eloko ya bule mpe eloko oyo ezangi bule, eloko ya peto mpe eloko ya mbindo ; ");
INSERT INTO lin_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","lisusu mpo ete boyeba koteya bana ya Isalaele mibeko nyonso oyo Yawe apesaki bino na nzela ya Moyize. » ");
INSERT INTO lin_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Moyize alobaki na Aron, Eleazari mpe Itamari, bana mibali ya Aron : « Kati na makabo bazikisa na moto mpo na Yawe, bokobanda kozwa likabo oyo ekotikala, oyo ekozika te na moto, mpe bokobanda kolia yango pembeni ya etumbelo ; bokotia yango ezanga levire, pamba te ezali eteni ya bule koleka. ");
INSERT INTO lin_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Bokolia yango na Esika ya bule, pamba te yango nde epesameli yo mpe bana mibali na yo kati na makabo bazikisa na moto mpo na Yawe, ndenge kaka atindaki ngai. ");
INSERT INTO lin_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Kati na bambeka ya boyokani oyo bana ya Isalaele bakobanda kobonza, yo mpe bana na yo, bokobanda kolia, na Esika ya bule, lokola eteni oyo epesameli bino, tolo oyo ekobonzama lokola likabo ya kotombola mpe mopende ya banyama oyo ekobonzama epai ya Yawe. ");
INSERT INTO lin_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Bana ya Isalaele bakobonza elongo na biteni ya mafuta bazikisa na moto : tolo mpe mopende ya banyama oyo batombolaka liboso ya Yawe. Ekokoma ya yo mpe ya bana mibali na yo mpo na libela, ndenge kaka Yawe atindaki ngai. » ");
INSERT INTO lin_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Bongo, tango Moyize atunaki ntaba ya mobali oyo ebonzamaki lokola mbeka mpo na masumu, ayokaki ete basilaki kotumba yango na moto. Boye asilikelaki Eleazari mpe Itamari, bana mibali ya Aron, mpe atunaki bango : ");
INSERT INTO lin_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","— Mpo na nini boliaki te mosuni ya mbeka mpo na masumu na Esika ya bule, pamba te ezali eteni ya bule ? Yawe apesaki bino yango mpo ete bokangola lisanga ya Isalaele na masumu na bango mpe bosala liboso ya Yawe mosala ya bolimbisi masumu na bango. ");
INSERT INTO lin_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Lokola makila ya mbeka yango ekotaki te kati na Esika ya bule, bosengelaki kolia mosuni na yango na Esika ya bule kolanda ndenge nalobaki na tina na yango. ");
INSERT INTO lin_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Aron azongiselaki Moyize : — Na mokolo oyo bana na ngai babonzelaki Yawe mbeka na bango mpo na masumu mpe mbeka na bango ya kotumba, oyebi malamu makambo oyo ekweyelaki ngai. Soki, na mokolo lokola oyo wana, ngai naliaki mosuni ya mbeka mpo na masumu, Yawe akokaki na Ye kondima ete ngai nasala likambo ya bongo ? ");
INSERT INTO lin_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Moyize ayokaki eyano oyo mpe amonaki ete ezali malamu. ");
INSERT INTO lin_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Yawe alobaki na Moyize mpe Aron : ");
INSERT INTO lin_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","« Loba na bana ya Isalaele : ‹ Kati na banyama nyonso oyo ezali kati na mokili, tala banyama oyo bokoki kolia : ");
INSERT INTO lin_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","banyama oyo ezali na litindi epasuka na kati-kati mpe ezongisaka na monoko biloko oyo ewuti na libumu. ");
INSERT INTO lin_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Kasi, kati na banyama oyo ezongisaka na monoko biloko oyo ewuti na libumu, mpe kati na banyama oyo litindi na yango epasuka na kati-kati, tala banyama oyo bosengeli te kolia : shamo, pamba te ezongisaka na monoko biloko oyo ewuti na libumu, kasi litindi na yango epasuka te na kati-kati : ezali mbindo mpo na bino ; ");
INSERT INTO lin_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","mpanya ya zamba, pamba te ezongisaka te na monoko biloko oyo ewuti na libumu, kasi litindi na yango epasuka te na kati-kati : ezali mbindo mpo na bino ; ");
INSERT INTO lin_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","mpanya ya matoyi milayi, pamba te ezongisaka na monoko biloko oyo ewuti na libumu, kasi litindi na yango epasuka te na kati-kati : ezali mbindo mpo na bino ; ");
INSERT INTO lin_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","ngulu, pamba te ezali na litindi epasuka na kati-kati kasi ezongisaka te na monoko biloko oyo ewuti na libumu : ezali mbindo mpo na bino. ");
INSERT INTO lin_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Bosengeli te kolia misuni ya banyama yango to kosimba bibembe na yango, pamba te ezali mbindo mpo na bino. ");
INSERT INTO lin_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Kati na bikelamu nyonso oyo evandaka na mayi lokola bibale minene mpe miluka, bokoki kolia nyonso oyo ezali na binyanyeli mpe biteku. ");
INSERT INTO lin_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Kasi bokolia te nyonso oyo ezangi binyanyeli mpe biteku : ezali mbindo mpo na bino. ");
INSERT INTO lin_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Bosengeli te kolia misuni ya banyama yango to kosimba bibembe na yango, pamba te ezali mbindo mpo na bino. ");
INSERT INTO lin_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Bikelamu nyonso oyo evandaka na mayi kasi ezangi binyanyeli mpe biteku, ezali mbindo mpo na bino. ");
INSERT INTO lin_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Kati na bandeke, tala oyo ezali mbindo mpo na bino, oyo bosengeli te kolia : mpongo, engondo, mpongo ya ebale monene, ");
INSERT INTO lin_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","nzengo mpe bandeke ya lolenge nyonso oyo eliaka misuni, ");
INSERT INTO lin_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","bayanganga ya lolenge nyonso ; ");
INSERT INTO lin_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","maligbanga, kumu, ndeke ya ebale monene mpe bakombekombe ya lolenge nyonso, ");
INSERT INTO lin_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","esulungutu, libata ya mayi, esulungutu ya monene, ");
INSERT INTO lin_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","esulungutu ya pembe, libeke, ndeke oyo eliaka misuni ya kopola, ");
INSERT INTO lin_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","nkoko, mokwela ya lolenge nyonso, kengele mpe lolema. ");
INSERT INTO lin_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Bokolia te banyama nyonso ya mike-mike oyo ezali na mapapu mpe etambolaka na makolo minei ; ezali mbindo mpo na bino. ");
INSERT INTO lin_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Nzokande, kati na banyama nyonso ya mike-mike oyo ezali na mapapu, bokoki kolia oyo ezali lisusu na makolo oyo esungaka yango mpo na kopumbwa wuta na mabele : ");
INSERT INTO lin_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","lolenge nyonso ya mabanki, mankoko, makelele mpe mayoyo. ");
INSERT INTO lin_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Kasi banyama mike nyonso oyo ezali na mapapu mpe na makolo minei ezali mbindo mpo na bino. ");
INSERT INTO lin_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Soki te, ekokomisa bino mbindo ; mpe moto nyonso oyo akosimba bibembe na yango akozala mbindo kino na pokwa. ");
INSERT INTO lin_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Moto nyonso oyo akosimba bibembe na yango akosukola bilamba na ye mpe akozala mbindo kino na pokwa. ");
INSERT INTO lin_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Tala banyama mosusu oyo bokomona lokola mbindo : nyama oyo ezali na litindi epasuka te mpe ezongisaka te na monoko biloko oyo ewuti na libumu. Moto nyonso oyo akosimba yango akozala mbindo. ");
INSERT INTO lin_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Nyama nyonso oyo ezali na makolo minei mpe etambolaka na matambe na yango ezali mbindo. Moto nyonso oyo akosimba bibembe na yango akozala mbindo kino na pokwa. ");
INSERT INTO lin_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Mpe moto nyonso oyo akolokota bibembe na yango akosukola bilamba na ye mpe akozala mbindo kino na pokwa. Bokomona yango mbindo. ");
INSERT INTO lin_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Kati na banyama mike oyo etambolaka na mabele, tala oyo bosengeli komona lokola mbindo : mpuku ya se ya mabele, mpuku mpe lolenge nyonso ya miselekete, ");
INSERT INTO lin_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","moselekete ya ndako, moselekete ya zelo, moselekete ya zamba, moselekete ya langi ya pondu, mongungu. ");
INSERT INTO lin_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Kati na bibwele nyonso oyo etambolaka na libumu, bokomona oyo wana lokola mbindo. Moto nyonso oyo akosimba yango wana esili kokufa akozala mbindo kino na pokwa. ");
INSERT INTO lin_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Eloko nyonso oyo nyama yango ekokweyela, wana esili kokufa, ekozala mbindo, ezala esalelo ya libaya, elamba, poso to sakosi ; botia yango na mayi mpe ekozala mbindo kino na pokwa ; sima na yango nde ekozonga lisusu peto. ");
INSERT INTO lin_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Soki moko kati na banyama yango ekweyi na mbeki basala na mabele, biloko nyonso oyo ezali kati na mbeki yango ekokoma mbindo mpe bokopanza mbeki yango. ");
INSERT INTO lin_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Soki basopi mayi ya mbeki yango na eloko nyonso oyo baliaka, eloko yango ekokoma mbindo ; ezali mpe bongo mpo na eloko nyonso oyo bamelaka : soki basopeli yango mayi ya mbeki wana, ekokoma mbindo ata soki ezali kati na mbeki ya lolenge nini. ");
INSERT INTO lin_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Eloko nyonso oyo ebembe ya moko kati na banyama wana ekokweya likolo na yango ekokoma mbindo. Soki ezali fulu ya moto to mbabola, esengeli kopanza yango ; pamba te ekozala mbindo mpe bokomona yango bongo. ");
INSERT INTO lin_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Nzokande soki nyama yango ya mbindo ekweyi kati na etima to kati na libulu ya mayi, mayi ekotikala peto kasi moto oyo akosimba ebembe na yango akozala mbindo. ");
INSERT INTO lin_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Soki eteni moko ya ebembe na yango ekweyi likolo ya nkona oyo basengeli kolona, nkona ekotikala peto ; ");
INSERT INTO lin_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","kasi soki basilaki kosopela nkona yango mayi, bongo eteni ya ebembe ya nyama ya mbindo ekweyi lisusu likolo na yango, bokomona nkona yango mbindo. ");
INSERT INTO lin_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Soki nyama oyo bozali na ndingisa ya kolia ekufi, moto nyonso oyo akosimba ebembe na yango akozala mbindo kino na pokwa ; ");
INSERT INTO lin_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","mpe moto oyo akolia mosuni ya nyama oyo esili kokufa asengeli kosukola bilamba na ye, mpe akozala mbindo kino na pokwa. Moto oyo mpe akomema ebembe na yango akosukola bilamba na ye mpe akozala mbindo kino na pokwa. ");
INSERT INTO lin_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Bosengeli komona lokola mbindo banyama nyonso oyo etambolaka na libumu, mpe epekisami kolia yango. ");
INSERT INTO lin_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Bokolia ata nyama moko te oyo etambolaka na libumu ; ata oyo etambolaka na makolo minei to koleka, pamba te ezali mbindo. ");
INSERT INTO lin_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Bino moko mpe bomikomisa mbindo te na nzela ya moko kati na bikelamu wana oyo etambolaka na libumu. Bomikomisa mbindo te na nzela na yango to tika ete yango mpe ekomisa bino mbindo te. ");
INSERT INTO lin_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Pamba te, nazali Yawe, Nzambe na bino. Botambola lokola bato ya bule mpe bozala bule, pamba te Ngai nazali Bule. Bomikomisa mbindo te na nzela ya banyama nyonso oyo etambolaka na libumu. ");
INSERT INTO lin_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Nazali Yawe oyo abimisaki bino na Ejipito mpo ete nazala Nzambe na bino. Boye bozala bule, pamba te Ngai nazali Bule. ");
INSERT INTO lin_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Yango wana nde ezali mobeko oyo etali banyama, bandeke, bikelamu nyonso ya bomoi oyo etambolaka kati na mayi to na libumu. ");
INSERT INTO lin_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Bosengeli kosala bokeseni kati na oyo ezali mbindo mpe oyo ezali peto, kati na bikelamu ya bomoi oyo bakoki kolia mpe oyo bakoki kolia te. › » ");
INSERT INTO lin_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Yawe ayebisaki Moyize : ");
INSERT INTO lin_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","« Loba na bana ya Isalaele : ‹ Soki mwasi aboti mwana mobali, akozala mbindo mikolo sambo lokola tango amonaka makila na ye ya sanza. ");
INSERT INTO lin_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Bongo na mokolo ya mwambe, basengeli kokata mwana ngenga. ");
INSERT INTO lin_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Sima, akolekisa lisusu mikolo tuku misato na misato mpo ete apetolama na makila na ye oyo ebimaki tango abotaki. Akosimba eloko moko te ya bule mpe akokende te na Esika ya bule kino mikolo ya kopetolama na ye ekokoka. ");
INSERT INTO lin_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Soki mwasi aboti mwana mwasi, akozala mbindo baposo mibale lokola tango amonaka makila na ye ya sanza. Bongo akolekisa mikolo tuku motoba na motoba mpo ete apetolama na makila na ye oyo ebimaki tango abotaki. ");
INSERT INTO lin_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Soki mikolo ya kopetolama na ye ekoki, ezala abotaki mwana mobali to mwana mwasi, akomema epai ya Nganga-Nzambe, na ekotelo ya Ndako ya kapo ya Bokutani, mwana meme ya mobu moko lokola mbeka ya kotumba mpe ebenga moko ya mboka to ebenga moko ya zamba lokola mbeka mpo na masumu. ");
INSERT INTO lin_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Nganga-Nzambe akobonza bambeka yango liboso ya Yawe mpe sima, akosala mosala ya bolimbisi masumu ya mwasi. Soki kaka asilisi kosala yango nde mwasi akokoma peto. Wana nde mobeko mpo na mwasi oyo aboti mwana mobali to mwana mwasi. ");
INSERT INTO lin_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Soki azangi makoki ya kozwa mwana meme, akoki komema bana mibale ya ebenga ya mboka to bibenga mibale ya zamba : moko mpo na mbeka ya kotumba, mpe mosusu, mpo na mbeka mpo na masumu. Sima na Nganga-Nzambe kosala mosala ya bolimbisi masumu, mwasi akokoma peto. › » ");
INSERT INTO lin_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Yawe alobaki na Moyize mpe Aron : ");
INSERT INTO lin_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","« Soki poso ya nzoto ya moto ebimisi bambuma ya mike-mike to esali kolokoto to lipalata, bongo ezwi lolenge ya bokono ya maba, bakomema moto yango epai ya Nganga-Nzambe Aron to epai ya moko kati na bana na ye, Banganga-Nzambe. ");
INSERT INTO lin_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Nganga-Nzambe akotala malamu poso ya nzoto oyo esili kozwa bokono. Soki amoni ete bapwale oyo ezali na esika oyo ezwi bokono na poso ebongwani mpe ekomi pembe ; bongo bapota efungwami na poso ya nzoto, wana elakisi ete ezali bokono ya maba ; mpe Nganga-Nzambe akoki koloba mbala moko ete moto yango azali mbindo. ");
INSERT INTO lin_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Soki lipalata oyo ebimi na poso ezali ya pembe mpe ezali kongenga, bongo efungwami te mpo na kosala pota na poso ya nzoto, Nganga-Nzambe akolongola kati na lisanga, moto oyo abeli mpe akotia ye na esika oyo akozala ye moko mikolo sambo. ");
INSERT INTO lin_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Sima na mikolo yango sambo, Nganga-Nzambe akotala ye lisusu malamu : soki amoni ete lipalata oyo ebimaki na poso ya nzoto efungwami te mpe epanzani te na nzoto mobimba, akotika moto oyo abeli na esika oyo atiaki ye mpo ete asala lisusu mikolo sambo. ");
INSERT INTO lin_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Sima na mikolo sambo yango, Nganga-Nzambe akotala ye lisusu malamu : soki lipalata oyo ebimaki na poso ya nzoto ekawuki mpe epanzani te na nzoto mobimba, Nganga-Nzambe akoloba ete moto yango azali mbindo te ; ezali kolokoto ya pamba. Moto yango akosukola bilamba na ye mpo ete azali mbindo te. ");
INSERT INTO lin_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Nzokande, soki sima na Nganga-Nzambe kotala mpe koloba ete moto yango azali peto, kolokoto yango epanzani na poso, moto yango asengeli kozonga epai ya Nganga-Nzambe mpo ete atala ye lisusu. ");
INSERT INTO lin_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Soki amoni ete kolokoto epanzani na poso ya nzoto, Nganga-Nzambe akoloba ete moto yango azali na bokono ya maba mpe azali mbindo. ");
INSERT INTO lin_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Soki moto azwi bokono ya maba, basengeli komema ye epai ya Nganga-Nzambe. ");
INSERT INTO lin_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Nganga-Nzambe akotala ye malamu. Soki amoni ete poso ya nzoto na ye ebimisi bambuma ya pembe ya mike-mike, ekomisi bapwale ya nzoto na ye pembe, efungwami mpe ebimisi bapota, ");
INSERT INTO lin_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","wana elakisi ete ezali bokono ya maba ya libela kati na poso ya nzoto na ye, mpe Nganga-Nzambe akoloba ete moto yango azali mbindo. Ekozala na tina te kotia ye na esika oyo akozala ye moko, pamba te emonani ete azali mbindo. ");
INSERT INTO lin_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Kasi soki bokono na ye ya maba ebimisi bambuma ya mike-mike na poso ya nzoto na ye mobimba, kobanda na moto kino na makolo, na bisika nyonso oyo Nganga-Nzambe akoki kotala, ");
INSERT INTO lin_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","Nganga-Nzambe akotala ye lisusu malamu : soki amoni ete bambuma ya mike-mike etondi ye penza na nzoto mobimba, akoloba ete moto yango azali mbindo te mpo ete akomi pembe nzoto mobimba. ");
INSERT INTO lin_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Kasi akokoma mbindo na mokolo kaka poso ya nzoto na ye ekofungwama mpe ekobimisa bapota. ");
INSERT INTO lin_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Soki kaka Nganga-Nzambe atali mpe amoni bapota oyo ebimi na poso, akoloba ete moto yango azali mbindo mpe bapota oyo efungwami ezali mbindo : ezali bokono ya maba. ");
INSERT INTO lin_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Mpe soki bapota oyo efungwami ekomi lisusu pembe, moto yango akozonga lisusu epai ya Nganga-Nzambe ");
INSERT INTO lin_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","mpo ete atala ye malamu. Soki Nganga-Nzambe amoni ete bapota yango ekomi penza pembe, akoloba ete nzoto ezali mbindo te mpe ye moko moto yango azali mbindo te. ");
INSERT INTO lin_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Soki moto moko abelaki bibon mpe yango ekawuki ; ");
INSERT INTO lin_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","bongo bambuma mike-mike ya pembe to lipalata ya mwa pembe mpe mwa motane ebimi na esika oyo bibon ezalaki, moto yango asengeli kokende epai ya Nganga-Nzambe oyo akotala ye malamu. ");
INSERT INTO lin_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Soki Nganga-Nzambe amoni ete lidusu moko esalemi na poso ya nzoto ya moto wana, bapwale na ye ebongwani mpe ekomi pembe, akoloba ete moto yango azali mbindo, pamba te ezali bokono ya maba oyo ebimi na esika oyo elembo ya pota ya bibon ezali. ");
INSERT INTO lin_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Nzokande, soki na ngonga ya kotala ye, Nganga-Nzambe amoni te bapwale ya moto yango kobongwana pembe mpe lidusu kosalema na poso na ye, akotia ye na esika oyo akozala ye moko mpo na mikolo sambo. ");
INSERT INTO lin_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Sima na yango, soki Nganga-Nzambe amoni ete lipalata yango epanzani na poso ya nzoto, akoloba ete moto yango azali mbindo, pamba te azali na bokono ya maba. ");
INSERT INTO lin_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Kasi soki lipalata yango epanzani te, wana elakisi ete ezali bobele elembo ya pota ya bibon ; mpe Nganga-Nzambe akoloba ete moto yango azali na ye mbindo te. ");
INSERT INTO lin_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Soki poso ya nzoto ya moto moko eziki na moto, bongo litono moko ya pembe to ya motane esalemi kati na esika oyo eziki, ");
INSERT INTO lin_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","Nganga-Nzambe akotala moto yango malamu : soki bapwale oyo ezali kati na litono ebongwani, ekomi pembe mpe litono yango kati na poso ebongwani, esali pota : elakisi ete ezali bokono ya maba nde ebimi na esika oyo ezikaki. Boye, Nganga-Nzambe akoloba ete moto yango azali mbindo, pamba te azali na bokono ya maba. ");
INSERT INTO lin_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Nzokande, soki tango Nganga-Nzambe atali moto yango malamu, amoni te bapwale ya pembe kati na litono ; mpe soki litono ebongwani te, esali na yango pota te na poso mpe epanzani te ; akotia ye na esika oyo akozala ye moko mpo na mikolo sambo. ");
INSERT INTO lin_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Na mokolo ya sambo, Nganga-Nzambe akotala ye malamu : soki litono epanzani solo na poso, Nganga-Nzambe akoloba ete moto yango azali mbindo, pamba te ezali bokono ya maba. ");
INSERT INTO lin_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Nzokande, soki litono yango etikali kaka esika moko, epanzani te na poso kasi ekawuki, wana etalisi ete ezali kaka kobeba ya poso ya nzoto mpo na kozika na ye na moto. Boye Nganga-Nzambe akoloba ete azali mbindo te, pamba te ezali kaka elembo ya pota ya moto. ");
INSERT INTO lin_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Soki mobali to mwasi abeli bokono ya poso ya nzoto, ezala na moto to na mbanga, ");
INSERT INTO lin_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","Nganga-Nzambe akotala malamu poso ya nzoto ya moto yango : soki amoni ete bapota ebimi na poso ya nzoto ya moto yango, bapwale eteli mpe kotela na yango epanzani, akoloba ete mobali to mwasi yango azali mbindo, pamba te ezali lipalata ya moto to ya mbanga. ");
INSERT INTO lin_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Nzokande, soki Nganga-Nzambe amoni ete poso ya nzoto ebimisi na yango bapota te, atako bapwale ezali kaka ya mwindo, akotia ye na esika oyo akozala ye moko mpo na mikolo sambo. ");
INSERT INTO lin_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Na mokolo ya sambo, Nganga-Nzambe akotala malamu poso : soki bokono yango epanzani te, bapwale eteli te, bapota ebimi te na poso, ");
INSERT INTO lin_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","mobeli akokokola suki na ye kasi akotika suki oyo ezali na bisika oyo bokono emonani. Bongo Nganga-Nzambe akotia lisusu mobeli na esika oyo akozala ye moko mpo na mikolo sambo. ");
INSERT INTO lin_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Na mokolo ya sambo, Nganga-Nzambe akotala malamu bokono yango ya poso ya nzoto : soki epanzani te mpe ebimisi bapota te, Nganga-Nzambe akoloba ete mobali to mwasi yango azali mbindo te. Boye mobali to mwasi yango akosukola kaka bilamba na ye mpe akokoma peto. ");
INSERT INTO lin_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Nzokande, atako Nganga-Nzambe asili koloba ete mobali to mwasi wana azali peto kasi soki bokono yango epanzani ye kaka na poso ya nzoto, ");
INSERT INTO lin_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","Nganga-Nzambe akotala malamu : lokola bokono epanzani ye penza na poso ya nzoto, ekozala na tina te ete Nganga-Nzambe aluka lisusu koyeba soki bapwale eteli to te, pamba te mobali to mwasi yango azali penza mbindo. ");
INSERT INTO lin_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Nzokande, soki bokono epanzani na yango te mpe bapwale ya mwindo ebimi na bisika oyo bokono ezali, wana elakisi ete mobeli abiki na bokono na ye mpe azali peto : Nganga-Nzambe akoloba ete azali peto. ");
INSERT INTO lin_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Soki mobali to mwasi amoni matono ya pembe kobima na poso ya nzoto na ye, ");
INSERT INTO lin_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","Nganga-Nzambe akotala ye malamu : soki pembe ya matono yango ezali na yango ya pete, wana elakisi ete ezali na yango penza bokono te : moto yango azali peto. ");
INSERT INTO lin_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Soki suki ya mobali moko ekatani, bongo akomi na libandi, elakisi te ete akomi mbindo. ");
INSERT INTO lin_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Soki suki yango ekataneli ye na mbunzu, bongo akomi na libandi, wana elakisi ete azali peto. ");
INSERT INTO lin_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Kasi soki lipalata moko ya mwa pembe mpe ya mwa motane ebimi ye na libandi, ezala na dikosi to na mbunzu, wana elakisi ete bokono ya maba ebandi kobima ye na libandi. ");
INSERT INTO lin_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Nganga-Nzambe akotala ye malamu : soki amoni ete bokono yango ya maba ebandi kobimisa bambuma ya mike-mike ya mwa pembe mpe ya mwa motane, ezala na dikosi to na mbunzu ; wana elakisi ete azali na bokono ya maba na libandi. ");
INSERT INTO lin_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","Boye mobali yango azali na bokono ya maba, azali mbindo ; mpe Nganga-Nzambe asengeli koloba ete azali mbindo mpo na bokono oyo akomi na yango na moto. ");
INSERT INTO lin_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Moto oyo azwi bokono ya boye asengeli kolata bilamba epasuka, akokatisa suki te, akozipa mandefu na ye mpe akoganga : ‹ Mbindo ! Mbindo ! › ");
INSERT INTO lin_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Lokola bokono oyo akomi na yango ezali mbindo, ye moko mpe akozala mbindo. Boye akotonga ndako na ye mosika na bato mpe akovanda libanda ya molako. ");
INSERT INTO lin_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Soki elamba ya kolata ezwi mbungi, ebebi mpe ekomi lokola nzoto ya moto oyo abeli bokono ya maba, ezala elamba basala na lino to na bapwale ya meme ");
INSERT INTO lin_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","to elamba ya pete to elamba ya lino mpo na komibatela na malili to elamba basala na bapwale ya meme to mpe ezala mbungi yango emonani na likolo ya eloko basala na kapo ya pete to na kapo ya makasi, ");
INSERT INTO lin_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","soki mbungi yango ezwi langi ya mayi ya pondu to ezwi langi ya motane, na likolo ya elamba, wana elakisi ete ezali litono ya maba ; boye basengeli komema yango epai ya Nganga-Nzambe mpo ete atala yango malamu. ");
INSERT INTO lin_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Sima na Nganga-Nzambe kotala yango malamu, akotia yango na esika oyo ekozala yango moko mpo na mikolo sambo. ");
INSERT INTO lin_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Na mokolo ya sambo, Nganga-Nzambe akotala lisusu malamu litono yango. Soki amoni ete epanzani na likolo ya elamba ya kolata, ya elamba ya pamba, ya elamba ya malili to na likolo ya kapo ; wana elakisi ete ezali litono ya bokono ya maba oyo bakoki kolongola te mpe elakisi lisusu ete elamba yango ezali mbindo. ");
INSERT INTO lin_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Boye basengeli kotumba elamba yango, atako ezali ndenge nini, pamba te ezali na litono oyo bakoki kolongola te : basengeli kotumba yango. ");
INSERT INTO lin_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Nzokande, soki sima na kotala elamba yango malamu, Nganga-Nzambe amoni ete litono epanzani te na likolo ya elamba yango to na likolo ya kapo, ");
INSERT INTO lin_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","Nganga-Nzambe akopesa mitindo ete basukola yango ; bongo akotia yango lisusu na esika oyo ekozala yango moko mpo na mikolo sambo. ");
INSERT INTO lin_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Sima na kosukola yango, Nganga-Nzambe akotala lisusu malamu litono ; soki amoni ete ebongwani te mpe epanzani na yango te, wana elakisi ete elamba ezali mbindo mpe esengeli kotumba yango na moto : ezali elamba oyo ebebi na liboso mpe na sima. ");
INSERT INTO lin_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Nzokande, soki Nganga-Nzambe, sima na kotala malamu elamba, amoni ete litono elongwaki na tango basukolaki elamba ; akokata kaka eteni ya elamba epai wapi litono ezali. ");
INSERT INTO lin_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Soki sima na mwa tango, litono yango ezongi lisusu, wana elakisi ete ezali bokono ya maba oyo ezali kokola. Boye esengeli kotumba na moto eteni oyo ezali na litono na elamba. ");
INSERT INTO lin_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Tango bakosukola elamba oyo ezali na litono, soki litono yango elongwe, esengeli kosukola yango lisusu na mbala ya mibale mpo ete ezala peto. » ");
INSERT INTO lin_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Wana nde mitindo oyo etali litono ya bokono ya maba na likolo ya elamba basala na bapwale ya meme to elamba ya lino, na likolo ya eloko nyonso basala na poso ya nyama, mpo na koyeba soki elamba ezali peto to mbindo. ");
INSERT INTO lin_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","« Tala mobeko oyo etali moto oyo azali na bokono ya maba, na mokolo ya kopetolama na ye : ‹ Basengeli komema moto oyo azali na bokono ya maba epai ya Nganga-Nzambe. ");
INSERT INTO lin_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Nganga-Nzambe akokende libanda ya molako mpo na kotala ye malamu. Soki abiki na bokono na ye ya maba, ");
INSERT INTO lin_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","Nganga-Nzambe akopesa mitindo ete bamema biloko oyo, mpo na kopetolama ya moto oyo abiki na bokono ya maba : bandeke mibale ya peto mpe ya bomoi, eteni ya nzete ya sedele, eteni ya elamba ya motane makasi mpe eteni ya nzete ya izope. ");
INSERT INTO lin_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Nganga-Nzambe akopesa mitindo ete bakata kingo ya ndeke moko kati na bandeke wana mibale, na likolo ya sani basala na mabele mpe etondi na mayi ya peto. ");
INSERT INTO lin_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Bongo akokamata ndeke ya mibale, ya bomoi, elongo na eteni ya nzete ya sedele, eteni ya elamba ya motane makasi mpe eteni ya nzete ya izope ; akozindisa yango kati na makila ya ndeke oyo bawuti kokata kingo na likolo ya mayi ya peto ; ");
INSERT INTO lin_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","akosopa makila yango mbala sambo na nzoto ya moto oyo asengeli kopetolama na maba. Sima na yango, Nganga-Nzambe akotatola ete moto yango akomi peto ; mpe akotika ndeke oyo ya bomoi kopumbwa mpe kokende na zamba. ");
INSERT INTO lin_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Moto oyo asengeli na kopetolama akosukola bilamba na ye, akokata bapwale na ye nyonso mpe akomisukola nzoto na mayi ; sima na yango, akokoma peto. Bongo, akoki kozonga kati na molako, kasi akovanda mikolo sambo libanda ya ndako na ye ya kapo. ");
INSERT INTO lin_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Na mokolo ya sambo, akokata lisusu bapwale na ye, suki na ye ya moto mpe ya miso, mandefu na ye mpe bapwale nyonso mosusu ; akosukola bilamba na ye mpe akomisukola nzoto na mayi. Na bongo, akozala peto. ");
INSERT INTO lin_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Na mokolo ya mwambe, akokamata bana meme mibale ezanga mbeba elongo na meme moko ya mwasi ezanga mbeba mpe esili kokokisa mobu moko, kilo libwa ya farine basangisa na mafuta lokola, likabo ya bambuma, mpe kati-kati ya litele moko ya mafuta. ");
INSERT INTO lin_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Nganga-Nzambe oyo azali kosala mosala ya kopetola akotia ye elongo na makabo na ye liboso ya Yawe, na ekotelo ya Ndako ya kapo ya Bokutani. ");
INSERT INTO lin_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Nganga-Nzambe akozwa mwana meme ya liboso mpe akobonza yango elongo na kati-kati ya litele moko ya mafuta lokola mbeka mpo na kozongisa boyokani ; akotombola yango liboso ya Yawe. ");
INSERT INTO lin_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Akokata mwana meme yango kingo na esika oyo babomaka banyama oyo babonzi epai ya Nzambe lokola mbeka mpo na bolimbisi masumu mpe lokola mbeka ya kotumba, kati na esika yango ya bule ; pamba te, ezala mbeka mpo na kozongisa boyokani to mbeka mpo na bolimbisi masumu, ezali ya Nganga-Nzambe : ezali eloko ya bule koleka. ");
INSERT INTO lin_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Nganga-Nzambe akozwa makila ya mbeka oyo ebonzami mpo na kozongisa boyokani, akopakola yango na likolo ya litoyi ya ngambo ya loboko ya mobali ya moto oyo azali komipetola, na mosapi ya liboso ya loboko na ye ya ngambo ya mobali mpe na mosapi ya liboso ya lokolo na ye ya ngambo ya loboko ya mobali. ");
INSERT INTO lin_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Nganga-Nzambe akokamata kati-kati ya litele ya mafuta mpe akosopa ndambo na yango na loboko na ye ya ngambo ya mwasi. ");
INSERT INTO lin_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Nganga-Nzambe akozindisa, kati na mafuta oyo asili kosopa na loboko na ye ya ngambo ya mwasi, mosapi ya mibale ya loboko na ye ya ngambo ya mobali mpe akosalela yango mpo na kosopa mbala sambo mafuta liboso ya Yawe. ");
INSERT INTO lin_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Bongo kati na mafuta oyo ekotikala ye na loboko, Nganga-Nzambe akokamata ndambo na yango mpo na kopakola na likolo ya litoyi ya ngambo ya loboko ya mobali ya moto oyo azali komipetola, na mosapi ya liboso ya loboko na ye ya ngambo ya mobali mpe na mosapi ya liboso ya lokolo na ye ya ngambo ya loboko ya mobali, kaka na esika oyo awuti kotia makila ya mwana meme oyo ebonzami lokola mbeka mpo na kozongisa boyokani. ");
INSERT INTO lin_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Bongo Nganga-Nzambe akosopa, na moto ya moto oyo azali komipetola, mafuta oyo ekotikala na loboko na ye mpo na kosala, liboso ya Yawe, mosala ya bolimbisi masumu na ye. ");
INSERT INTO lin_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Sima na yango, Nganga-Nzambe akobonza, liboso ya Nzambe, mbeka mpo na masumu, mpo ete asala mosala ya bolimbisi masumu ya moto oyo azali komipetola na mbindo na ye ; mpe akokata lisusu kingo ya nyama oyo ebonzami lokola mbeka ya kotumba. ");
INSERT INTO lin_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Nganga-Nzambe akotia mbeka yango na likolo ya etumbelo elongo na makabo ya farine. Boye, Nganga-Nzambe akosala mosala ya bolimbisi masumu ya moto yango, mpe akozala peto. ");
INSERT INTO lin_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Soki moto yango azali mobola, bongo akoki kozwa te biloko wana nyonso, akokamata kaka mwana meme moko lokola mbeka mpo na kozongisa boyokani, mpo na kobonza yango mpo na mosala ya bolimbisi masumu ya moto yango ; akobakisa na likolo na yango lokola makabo bakilo misato ya farine basangisa na mafuta mpe kati-kati ya litele moko ya mafuta. ");
INSERT INTO lin_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Akobonza lisusu bibenga mibale kolanda bozwi na ye : moko lokola mbeka mpo na bolimbisi masumu, mosusu lokola mbeka ya kotumba. ");
INSERT INTO lin_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Na mokolo ya mwambe, akomema yango epai ya Nganga-Nzambe, na ekotelo ya Ndako ya kapo ya Bokutani, liboso ya Yawe, mpo na kopetolama na ye. ");
INSERT INTO lin_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Nganga-Nzambe akokamata mafuta mpe mwana meme oyo ebonzami lokola mbeka mpo na bolimbisi masumu, mpe akobonza yango epai na Yawe. ");
INSERT INTO lin_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Akokata kingo ya mwana meme yango oyo ebonzami lokola mbeka mpo na bolimbisi masumu. Nganga-Nzambe akotia makila ya mbeka mpo na bolimbisi masumu, na likolo ya litoyi ya ngambo ya loboko ya mobali ya moto oyo azali komipetola, na mosapi ya liboso ya loboko na ye ya ngambo ya mobali mpe na mosapi ya liboso ya lokolo na ye ya ngambo ya loboko ya mobali. ");
INSERT INTO lin_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Nganga-Nzambe akosopa lisusu ndambo ya mafuta na loboko na ye ya ngambo ya mwasi. ");
INSERT INTO lin_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","Mpe na nzela ya mosapi ya mibale ya loboko na ye ya ngambo ya mobali, Nganga-Nzambe akokamata mpe akosopa mafuta yango mbala sambo, liboso ya Yawe. ");
INSERT INTO lin_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Nganga-Nzambe akokamata ndambo mosusu mpe akotia yango na likolo ya litoyi ya ngambo ya loboko ya mobali, ya moto oyo azali komipetola, na mosapi ya liboso ya loboko na ye ya ngambo ya mobali mpe na mosapi na ye liboso ya lokolo na ye ya ngambo ya loboko ya mobali, mpe na bisika oyo atiaki makila ya mbeka mpo na bolimbisi masumu. ");
INSERT INTO lin_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Bongo mpo na ndambo ya makila oyo ekotikala na loboko na ye ya mwasi, Nganga-Nzambe akosopa yango na moto ya moto oyo azali komipetola, mpo na kosala mosala ya bolimbisi masumu na ye liboso ya Yawe. ");
INSERT INTO lin_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Nganga-Nzambe akozwa moko kati na bibenga mibale oyo moto wana abonzi kolanda bozwi na ye ");
INSERT INTO lin_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","mpe akobonza yango lokola mbeka mpo na masumu ; bongo akobonza ebenga mosusu lokola mbeka ya kotumba elongo na makabo ya farine. Mpe Nganga-Nzambe akosala liboso ya Yawe, mosala ya bolimbisi masumu ya moto oyo azali komipetola. › ");
INSERT INTO lin_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Wana nde mibeko oyo ezali kotala moto oyo abeli bokono ya maba, oyo azali penza na makoki te mpo na kopetolama na ye. » ");
INSERT INTO lin_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Yawe alobaki na Moyize mpe Aron : ");
INSERT INTO lin_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","« Tango bokokota na mokili ya Kanana oyo napesi bino, soki natie litono ya maba na ndako moko ya mokili oyo napesi bino, ");
INSERT INTO lin_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","nkolo ndako asengeli kokende koloba boye epai ya Nganga-Nzambe : ‹ Namoni litono ya maba kati na ndako na ngai. › ");
INSERT INTO lin_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Bongo Nganga-Nzambe akopesa mitindo ya kobima na ndako yango liboso ete ye akota kuna mpo na kotala malamu litono yango. Bongo akoloba ete biloko nyonso kati na ndako yango ezali peto. Sima na yango, Nganga-Nzambe akokota kati na yango mpo na kotala malamu. ");
INSERT INTO lin_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Akobanda kotala malamu litono yango kati na mir. Soki amoni ete ezwi langi ya mayi ya pondu to ya motane mpe esali lidusu kati na mir, ");
INSERT INTO lin_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","Nganga-Nzambe asengeli kobima wuta na ndako mpe kotelema na ekotelo na yango ; bongo akokanga ndako yango mpo na mikolo sambo. ");
INSERT INTO lin_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Na mokolo ya sambo, Nganga-Nzambe akozonga mpo na kotala lisusu malamu. Soki litono yango epanzani kati na mir, ");
INSERT INTO lin_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","Nganga-Nzambe akopesa mitindo ete balongola mabanga oyo ebebi na matono mpe babwaka yango libanda ya engumba na esika ya mbindo. ");
INSERT INTO lin_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Bongo akosenga ete bakokola mir nyonso na ngambo na yango ya kati mpe babwaka libanda ya engumba na esika ya mbindo mabele nyonso oyo bakokola. ");
INSERT INTO lin_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Sima, bakozongisa mabanga mosusu na bisika oyo balongolaki mpe bakozwa mabele mosusu mpo na kopakola ndako. ");
INSERT INTO lin_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Sima na kolongola mabanga oyo ebebaki, kokokola bamir mpe kopakola mabele mosusu, soki litono esalemi lisusu, ");
INSERT INTO lin_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","Nganga-Nzambe akokende kotala lisusu malamu : soki amoni solo ete litono esalemi lisusu mpe epanzani, wana elakisi ete maba ezali kati na ndako mpe ndako yango ekokoma mbindo. ");
INSERT INTO lin_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Boye bakokweyisa ndako yango : mabanga mpe mabaya na yango nyonso ekobwakama na libanda ya engumba na esika ya mbindo. ");
INSERT INTO lin_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Na mikolo nyonso oyo ndako ekozala ya kokangama, moto nyonso oyo akokota akozala mbindo kino na pokwa. ");
INSERT INTO lin_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Moto nyonso oyo akolekisa butu to kolia kati na ndako yango, asengeli kosukola bilamba na ye. ");
INSERT INTO lin_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Nzokande, soki na ngonga ya kotala malamu ndako sima na kopakola yango mabele, Nganga-Nzambe amoni te kobima ya litono, wana akoloba ete ndako yango ezali peto, pamba te mbindo na yango esili kolongwa. ");
INSERT INTO lin_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Boye mpo na kopetolama na yango, Nganga-Nzambe akozwa bandeke mibale, mabaya ya sedele, eteni ya elemba ya motane makasi mpe eteni ya nzete ya izope ; ");
INSERT INTO lin_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","akokata kingo ya ndeke ya liboso na likolo ya sani oyo basala na mabele mpe ezali na mayi ya peto kati na yango. ");
INSERT INTO lin_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Akokamata mabaya ya sedele, eteni ya nzete ya izope, eteni ya elamba ya motane makasi mpe ndeke mosusu, akozindisa yango kati na makila ya ndeke oyo asilaki kokata kingo mpe kati na mayi ya peto oyo akobwaka na likolo ya ndako mbala sambo. ");
INSERT INTO lin_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Akopetola ndako na nzela ya makila ya ndeke, ya mayi ya peto, ya ndeke oyo ezali na bomoi, ya mabaya ya sedele, ya eteni ya nzete ya izope mpe ya eteni ya elamba ya motane. ");
INSERT INTO lin_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Bongo akotika ndeke oyo etikalaki ya bomoi kokende na zamba, na libanda ya engumba. Ezali ndenge wana nde akosala mosala ya bolimbisi masumu ya ndako ; mpe ndako yango ekokoma peto. » ");
INSERT INTO lin_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Wana nde mibeko oyo etali lolenge nyonso ya maba, litono, ");
INSERT INTO lin_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","maba ya elamba mpe ya ndako, ");
INSERT INTO lin_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","bambuma ya mike-mike, mapalata mpe matono oyo ezali kongenga, ");
INSERT INTO lin_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","mpo na kotalisa soki moto azali mbindo to te. Yango nde mibeko oyo etali maba. ");
INSERT INTO lin_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Yawe alobaki na Moyize mpe Aron : ");
INSERT INTO lin_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","« Boloba na bana ya Isalaele mpe boyebisa bango : ‹ Soki nzoto ya mibali ya mobali moko ezali kobimisa tofina to mayi, kobima yango ekomisi mobali yango mbindo. ");
INSERT INTO lin_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Ata soki tofina to mayi ekobi kobima na nzoto na ye to ekangami, azali kaka mbindo. Tala ndenge kobima ya tofina to ya mayi yango ekomisaka moto mbindo : ");
INSERT INTO lin_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","mbeto nyonso oyo mobali oyo azali kobimisa tofina to mayi na nzoto na ye ya mibali akolala to eloko nyonso oyo akovandela ekokoma mbindo. ");
INSERT INTO lin_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Moto nyonso oyo akosimba mbeto na ye asengeli kosukola bilamba na ye mpe nzoto na ye na mayi, mpe akozala mbindo kino na pokwa. ");
INSERT INTO lin_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Moto oyo akovanda likolo ya eloko oyo mobali oyo azali kobima tofina to mayi na nzoto na ye ya mibali avandelaki, asengeli kosukola bilamba na ye mpe nzoto na ye na mayi, mpe akozala mbindo kino na pokwa. ");
INSERT INTO lin_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Moto oyo akosimba mobali oyo azali kobima tofina to mayi na nzoto na ye ya mibali, asengeli kosukola bilamba na ye mpe nzoto na ye na mayi, mpe akozala mbindo kino pokwa. ");
INSERT INTO lin_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Soki mobali oyo azali kobima tofina to mayi na nzoto na ye ya mibali abwakeli moto oyo azali peto soyi, moto yango asengeli kosukola bilamba na ye mpe nzoto na ye na mayi, mpe akozala mbindo kino na pokwa. ");
INSERT INTO lin_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Eloko nyonso oyo mobali oyo azali kobima tofina to mayi na nzoto na ye ya mibali akovandela likolo ya mpunda tango azali kosala mobembo, ekokoma mbindo. ");
INSERT INTO lin_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Moto nyonso oyo akosimba eloko nyonso kati na biloko oyo ezali na se ya mobali yango, akozala mbindo kino na pokwa ; mpe moto nyonso oyo akolokota biloko yango asengeli kosukola bilamba na ye mpe nzoto na ye na mayi, mpe akozala mbindo kino na pokwa. ");
INSERT INTO lin_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Moto nyonso oyo mobali oyo azali kobima tofina to mayi na nzoto na ye ya mibali akosimba na kozanga komisukola maboko na mayi, asengeli kosukola bilamba na ye mpe nzoto na ye na mayi, mpe akozala mbindo kino na pokwa. ");
INSERT INTO lin_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Mbeki nyonso oyo esalema na mabele oyo bakosimba na mobali oyo azali kobima tofina to mayi, basengeli kopanza yango ; mpe eloko nyonso oyo esalema na nzete basengeli kosukola yango na mayi. ");
INSERT INTO lin_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Soki tofina to mayi etiki kobima na nzoto ya mibali ya mobali yango, akotanga mikolo sambo mpo na kopetolama na ye ; sima akosukola bilamba na ye, akosukola nzoto na ye na mayi ya etima mpe akokoma peto. ");
INSERT INTO lin_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Na mokolo ya mwambe, akozwa bibenga mibale ya zamba to bana bibenga mibale mpe akoya liboso ya Yawe na ekuke ya Ndako ya kapo ya Bokutani. Akopesa yango epai ya Nganga-Nzambe. ");
INSERT INTO lin_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Nganga-Nzambe akobonza yango, moko lokola mbeka ya masumu mpe mosusu lokola mbeka ya kotumba. Na nzela wana nde Nganga-Nzambe akosala mosala ya bolimbisi masumu mpo na mobali yango liboso ya Yawe likolo ya kobima tofina to mayi na nzoto na ye ya mibali. ");
INSERT INTO lin_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Soki mobali abimi mayi ya mibali na nzoto na ye ya mibali, asengeli kosukola nzoto na ye mobimba na mayi mpe akozala mbindo kino na pokwa. ");
INSERT INTO lin_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Elamba nyonso to eloko nyonso oyo esalema na poso ya nyama oyo ekweyeli mayi ya mibali, esengeli basukola yango na mayi, mpe ekozala mbindo kino na pokwa. ");
INSERT INTO lin_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Soki mobali asangisi nzoto na mwasi, bango mibale basengeli kosukola nzoto na mayi mpe bakozala mbindo kino na pokwa. ");
INSERT INTO lin_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Soki mwasi amoni makila na ye ya sanza, akozala mbindo mikolo sambo, mpe moto nyonso oyo akosimba ye akozala mbindo kino na pokwa. ");
INSERT INTO lin_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Eloko nyonso oyo akolalela na tango wana ekokoma mbindo, mpe eloko nyonso oyo akovandela ekokoma mbindo. ");
INSERT INTO lin_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Moto nyonso oyo akosimba mbeto na ye akosukola bilamba na ye mpe nzoto na ye na mayi mpe akozala mbindo kino na pokwa. ");
INSERT INTO lin_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Moto nyonso oyo akosimba eloko oyo mwasi yango avandeli, asengeli kosukola bilamba na ye mpe nzoto na ye na mayi, mpe akozala mbindo kino na pokwa. ");
INSERT INTO lin_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Soki eloko ezali na mbeto na ye to likolo ya eloko oyo avandeli, moto oyo akosimba yango akozala mbindo kino na pokwa. ");
INSERT INTO lin_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Soki mobali moko asangisi na ye nzoto mpe makila na ye ya sanza ezwi mobali yango, akozala mbindo mikolo sambo. Bongo mbeto nyonso oyo mobali yango akolalela, ekokoma mbindo. ");
INSERT INTO lin_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Soki mwasi azali kobima makila mikolo ebele na tango oyo amonaka makila na ye ya sanza te to azali kokoba kobima makila penza na tango oyo amonaka makila na ye ya sanza, akozala mbindo mikolo nyonso oyo azali kobima makila lokola na mikolo oyo amonaka makila na ye ya sanza. ");
INSERT INTO lin_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Mbeto nyonso oyo akolalela na tango oyo makila na ye ezali kokoba kobima, ekozala mbindo ; mpe eloko nyonso oyo akovandela ekokoma mbindo lokola na tango oyo amonaka makila na ye ya sanza. ");
INSERT INTO lin_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Moto nyonso oyo akosimba biloko wana akokoma mbindo. Asengeli kosukola bilamba mpe nzoto na ye na mayi ; akozala mbindo kino na pokwa. ");
INSERT INTO lin_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Soki apetolami na kobima makila na ye, asengeli kotanga mikolo sambo ; sima na yango, akokoma peto. ");
INSERT INTO lin_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Na mokolo ya mwambe, akozwa bibenga mibale ya zamba to bana bibenga mibale mpe akomema yango epai ya Nganga-Nzambe na ekuke ya Ndako ya kapo ya Bokutani. ");
INSERT INTO lin_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Nganga-Nzambe akobonza yango, moko lokola mbeka ya masumu mpe mosusu lokola mbeka ya kotumba. Na nzela wana nde Nganga-Nzambe akosala mosala ya bolimbisi masumu mpo na mwasi yango liboso ya Yawe mpo na mbindo ya kobima makila na ye. ");
INSERT INTO lin_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Bosengeli kosala ete bana ya Isalaele bazala mosika ya makambo oyo ekokomisa bango mbindo ; boye bakokufa te na mbindo na bango, na kokomisa mbindo Mongombo na Ngai, oyo ezali kati na bango. › ");
INSERT INTO lin_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Oyo nde mibeko mpo na mobali oyo azali kobima tofina to mayi na nzoto na ye ya mibali to mpo na mobali oyo abimi mayi ya mibali oyo ekomisi ye mbindo ; ");
INSERT INTO lin_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","mpo na mwasi oyo azali komona makila na ye ya sanza mpe mpo na mobali oyo azali kobima tofina to mayi to mpo na mwasi oyo azali kobima makila, mpe mpo na mobali oyo asangisi nzoto na mwasi ya mbindo. » ");
INSERT INTO lin_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Yawe alobaki na Moyize, sima na kufa ya bana mibali mibale ya Aron, oyo bakufaki tango bapusanaki liboso ya Yawe. ");
INSERT INTO lin_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Yawe alobaki na Moyize : « Loba na Aron, ndeko na yo ya mobali, ete akotaka tango nyonso te na Esika ya bule, na sima ya rido, liboso ya esika ya bolimbisi masumu, likolo ya Sanduku mpo ete akufa te ; pamba te namimonisaka na nzela ya lipata likolo ya esika ya bolimbisi masumu. ");
INSERT INTO lin_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Tala ndenge Aron akobanda kokota na Esika ya bule : akomema ngombe moko ya mobali lokola mbeka ya masumu mpe meme moko ya mobali lokola mbeka ya kotumba. ");
INSERT INTO lin_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Akolata na nzoto na ye : nzambala ya bule basala na lino mpe bakaputula ya lino ; akomikanga mokaba ya lino mpe kitendi ya lino na moto na ye. Lokola bilamba oyo ezali ya bule, asengeli komisukola nzoto na ye na mayi liboso ya kolata yango. ");
INSERT INTO lin_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Aron akozwa kati na lisanga ya bana ya Isalaele : bantaba mibale ya mibali lokola mbeka ya masumu mpe meme moko ya mobali lokola mbeka ya kotumba. ");
INSERT INTO lin_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Aron akobonza mpo na ye moko, ngombe ya mobali lokola mbeka ya masumu mpe akosala mosala ya bolimbisi masumu mpo na ye moko mpe mpo na ndako na ye. ");
INSERT INTO lin_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Akozwa bantaba ya mibali nyonso mibale mpe akotia yango liboso ya Yawe, na ekotelo ya Ndako ya kapo ya Bokutani. ");
INSERT INTO lin_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Aron akobeta zeke mpo na bantaba ya mibali nyonso mibale : moko mpo na Yawe, mpe mosusu, mpo na Azazeli. ");
INSERT INTO lin_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Bongo Aron akomema ntaba oyo zeke ekolakisa ete ezali mpo na Yawe, mpe akobonza yango lokola mbeka mpo na masumu. ");
INSERT INTO lin_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Kasi ntaba ya mobali oyo zeke ekolakisa ete ezali mpo na Azazeli, akomema yango ya bomoi liboso ya Yawe mpo ete basala na yango mosala ya bolimbisi masumu, bongo bakotinda yango na esobe mpo na Azazeli. ");
INSERT INTO lin_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Aron akobonza, mpo na ye moko, ngombe ya mobali lokola mbeka mpo na masumu mpe akosala mosala ya bolimbisi masumu na ye moko mpe ya ndako na ye. Sima na ye kokata kingo ya ngombe ya mobali oyo abonzi mpo na ye moko lokola mbeka ya masumu, ");
INSERT INTO lin_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","akotondisa mbabola ya kotumba malasi na makala ya moto oyo ewuti na etumbelo liboso ya Yawe mpe akotondisa maboko na ye mibale na malasi ya putulu, bongo akomema yango na sima ya rido. ");
INSERT INTO lin_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Akotia malasi na moto liboso ya Yawe mpo ete milinga na yango ezipa esika ya bolimbisi oyo ezali likolo ya Sanduku ya Boyokani mpo ete akufa te. ");
INSERT INTO lin_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Akozwa makila ya ngombe ya mobali mpe, na nzela ya mosapi na ye, akobwaka yango liboso ya esika ya bolimbisi masumu, na ngambo ya este. Boye, na nzela ya mosapi na ye, akobwaka makila mbala sambo liboso ya esika ya bolimbisi masumu. ");
INSERT INTO lin_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Akokata kingo ya ntaba ya mobali ya mbeka mpo na masumu ya bato mpe akomema makila na yango na sima ya rido. Bongo akosala na makila yango ndenge asalaki na makila ya ngombe ya mobali : akobwaka liboso mpe likolo ya esika ya bolimbisi masumu. ");
INSERT INTO lin_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Na nzela wana, akosala mosala ya bolimbisi masumu mpo na Esika ya bule likolo ya mbindo, botomboki mpe masumu ya bana ya Isalaele. Akosala mpe ndenge moko mpo na Ndako ya kapo ya Bokutani oyo ezali elongo na bango kati na mbindo na bango. ");
INSERT INTO lin_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Moto moko te akozala kati na Ndako ya kapo ya Bokutani tango Aron akokota kuna mpo na kosala mosala ya bolimbisi masumu kati na Esika ya bule kino tango akobima na libanda. Mpe akosala mosala ya bolimbisi masumu mpo na ye moko, mpo na ndako na ye mpe mpo na lisanga mobimba ya Isalaele. ");
INSERT INTO lin_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Sima na yango, akobima mpo na kokende na etumbelo oyo ezali liboso ya Yawe mpe akosala mosala ya bolimbisi masumu mpo na etumbelo yango. Akozwa makila ya ngombe ya mobali mpe ya ntaba ya mobali mpe akotia yango na maseke ya etumbelo. ");
INSERT INTO lin_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Mpe na nzela ya mosapi na ye, akobwaka makila mbala sambo na etumbelo. Ezali na nzela wana nde akopetola mpe akobulisa yango na mbindo ya bana ya Isalaele. ");
INSERT INTO lin_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Tango Aron akosilisa kosala mosala ya bolimbisi masumu mpo na Esika ya bule, mpo na Ndako ya kapo ya Bokutani mpe mpo na etumbelo, akomema ntaba ya mobali ya bomoi. ");
INSERT INTO lin_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Aron akotia maboko na ye mibale na moto ya ntaba yango, akotubela mabe, botomboki mpe masumu nyonso ya bana ya Isalaele na moto ya ntaba yango. Na nzela wana akotia masumu nyonso na moto ya ntaba yango ; sima akopona moto moko mpo na kobengana ntaba yango na esobe. ");
INSERT INTO lin_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Boye ntaba ekomema masumu na bango nyonso na esika oyo ezanga bato, mpe moto yango akotika ntaba kokende na esobe. ");
INSERT INTO lin_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Bongo Aron akokota na Ndako ya kapo ya Bokutani, akolongola bilamba ya lino oyo alataki tango akotaki na Esika ya bule mpe akotika yango kuna. ");
INSERT INTO lin_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Akosukola nzoto na ye na mayi na esika moko ya bule ; mpe akolata bilamba na ye. Sima, akobima libanda mpe akobonza mbeka ya kotumba mpo na ye moko mpe mpo na bato. Na nzela wana nde akosala mosala ya bolimbisi masumu mpo na ye moko mpe mpo na bato. ");
INSERT INTO lin_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Akotumba mafuta ya mbeka ya masumu na likolo ya etumbelo. ");
INSERT INTO lin_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Moto oyo akobengana ntaba ya mobali mpo na Azazeli, asengeli kosukola nzoto na ye na mayi ; mpe sima na yango, akozonga na molako. ");
INSERT INTO lin_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Bakomema libanda ya molako ngombe ya mobali mpe ntaba ya mobali ya mbeka ya masumu oyo bamemaki makila na yango na Esika ya bule mpo na kosala mosala ya bolimbisi masumu mpe bakotumba na moto poso na yango, misuni na yango mpe banyei na yango. ");
INSERT INTO lin_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Moto oyo akotumba yango asengeli kosukola na mayi bilamba na ye mpe nzoto na ye, sima na yango nde akoki kozonga na molako. ");
INSERT INTO lin_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Tala malako oyo bosengeli kosalela mpo na libela : na mokolo ya zomi ya sanza ya sambo, ezala mwana mboka to mopaya oyo avandi kati na bino, bosengeli komikitisa mpe bokosala mosala ata moko te, ");
INSERT INTO lin_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","pamba te na mokolo wana nde bokosala mosala ya bolimbisi masumu mpo na bino mpe kopetolama bino. Boye bokopetolama na masumu na bino nyonso liboso ya Yawe. ");
INSERT INTO lin_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Ekozala mpo na bino mokolo ya Saba, mokolo ya bopemi, mpe bosengeli komikitisa. Ezali malako ya libela. ");
INSERT INTO lin_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Nganga-Nzambe oyo bakopakola mafuta mpe akobulisama mpo na kosala mosala ya bonganga-Nzambe na esika ya tata na ye, akosala mosala ya bolimbisi masumu. Akolata bilamba ya bule ya lino. ");
INSERT INTO lin_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Akosala mosala ya bolimbisi masumu mpo na ndako ya bule, mpo na Ndako ya kapo ya Bokutani, mpo na etumbelo, mpo na Nganga-Nzambe mpe mpo na bato nyonso ya lisanga. ");
INSERT INTO lin_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Oyo nde ekozala mpo na bino malako ya libela : mbala moko na mobu, bokosala mosala ya bolimbisi masumu nyonso ya bana ya Isalaele. » Mpe basalaki ndenge kaka Yawe atindaki Moyize. ");
INSERT INTO lin_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","« Yebisa Aron, bana na ye ya mibali mpe bana nyonso ya Isalaele, mpe loba na bango : ‹ Tala maloba oyo Yawe alobi : ");
INSERT INTO lin_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","‘ Moto nyonso kati na bana ya Isalaele, oyo akokata kingo ya ngombe, ya meme to ya ntaba, ezala kati na molako to na libanda ya molako ; ");
INSERT INTO lin_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","mpe amemi yango te na ekotelo ya Ndako ya kapo ya Bokutani mpo na kobonza yango lokola likabo epai na Yawe liboso ya Mongombo ya Yawe, makila na yango ekotangama na moto ya moto yango. Lokola asopi makila, bakolongola ye kati na bato na ye. ");
INSERT INTO lin_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Boye, na esika ete bana ya Isalaele bamemaka bambeka na bango na bilanga, bakomema yango mpo na Yawe epai ya Nganga-Nzambe, na ekotelo ya Ndako ya kapo ya Bokutani lokola mbeka ya boyokani epai na Yawe. ");
INSERT INTO lin_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Nganga-Nzambe akobwaka makila na etumbelo ya Yawe, na ekotelo ya Ndako ya kapo ya Bokutani mpe akotumba mafuta na yango lokola mbeka oyo solo kitoko na yango ekosepelisa Yawe. ");
INSERT INTO lin_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Bana ya Isalaele bakobonza lisusu te bambeka na bango epai banzambe ya bikeko ya bantaba ya mibali, oyo basambelaka. Oyo ekozala malako ya libela mpo na bango mpe mpo na milongo oyo ekoya. ’ › ");
INSERT INTO lin_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Loba na bango : ‹ Moto nyonso ya Isalaele to mopaya nyonso oyo azali kati na bango, oyo akobonza mbeka ya kotumba to mbeka mosusu, ");
INSERT INTO lin_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","na kozanga komema yango na ekotelo ya Ndako ya kapo ya Bokutani mpo na kobonza yango epai ya Yawe, bakolongola ye kati na bato ya Isalaele. ");
INSERT INTO lin_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Nakobalukela mpe nakolongola kati na bato na ye, moto nyonso oyo akolia makila, azala moto ya Isalaele to mopaya nyonso oyo avandi kati na bango ; ");
INSERT INTO lin_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","pamba te bomoi ya ekelamu nyonso ezali kati na makila. Napesi bino yango mpo ete bosala na yango mosala ya bolimbisi masumu mpo na bomoi na bino, na etumbelo. Lokola bomoi ya moto ezali kati na makila, yango wana makila esalaka mosala ya bolimbisi masumu. ");
INSERT INTO lin_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Boye, nalobaki na bana ya Isalaele : ‘ Moto moko te mpe mopaya moko te kati na bino akoki kolia makila. ’ ");
INSERT INTO lin_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Moto nyonso kati na bana ya Isalaele to mopaya oyo avandi kati na bango, oyo akokende bokila mpe akokanga nyama ya zamba to ndeke oyo baliaka, asengeli kosopa makila na yango mpe kozipa yango na mabele, pamba te bomoi ya ekelamu nyonso ezali kati na makila na yango. ");
INSERT INTO lin_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Yango wana, nalobaki na bana ya Isalaele : ‘ Bokoki kolia makila ya ekelamu ata moko te, pamba te bomoi ya ekelamu nyonso ezali kati na makila na yango. Moto oyo akolia yango, bakolongola ye kati na bato. ’ ");
INSERT INTO lin_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Moto nyonso, azala mwana mboka to mopaya, oyo akolia mosuni ya nyama oyo ekufi yango moko to oyo babomi na nyama ya zamba, akosukola bilamba na ye mpe nzoto na ye na mayi. Akozala mbindo kino na pokwa, sima na yango akokoma peto. ");
INSERT INTO lin_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Kasi soki asukoli bilamba mpe nzoto na ye te, akomema ngambo. › » ");
INSERT INTO lin_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","« Yebisa bana ya Isalaele : ‹ Ngai nazali Yawe, Nzambe na bino. ");
INSERT INTO lin_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Bokoki te kosala makambo ndenge esalemaka na Ejipito epai wapi bozalaki kovanda to na Kanana epai wapi nazali komema bino. ");
INSERT INTO lin_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Bosengeli kotosa bobele mibeko mpe bikateli na Ngai. Nazali Yawe, Nzambe na bino. ");
INSERT INTO lin_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Bobatela mitindo mpe mibeko na Ngai, pamba te moto oyo akosalela yango akobika bomoi na ye na nzela na yango. Nazali Yawe. ");
INSERT INTO lin_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Mobali moko te akosangisa nzoto na mwasi ya libota na ye penza. Nazali Yawe. ");
INSERT INTO lin_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Okosambwisa te tata na yo na kosangisa nzoto na mama na yo. Lokola azali mama na yo, kosambwisa ye te. ");
INSERT INTO lin_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Okosangisa nzoto te na mwasi mosusu ya tata na yo, soki te okosambwisa tata na yo. ");
INSERT INTO lin_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Okosangisa nzoto te na ndeko na yo ya mwasi, ezala na mwana mwasi ya tata na yo to ya mama na yo, oyo abotami na ndako to na libanda ya ndako. ");
INSERT INTO lin_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Okosangisa nzoto te na mwana mwasi ya mwana na yo ya mobali to ya mwasi ; kosambwisa ye te. ");
INSERT INTO lin_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Okosangisa nzoto te na mwana mwasi ya mwasi ya tata na yo, azali ndeko na yo ya mwasi. ");
INSERT INTO lin_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Okosangisa nzoto te na ndeko mwasi ya tata na yo, azali tata mwasi na yo. ");
INSERT INTO lin_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Okosangisa nzoto te na ndeko mwasi ya mama na yo, azali mama leki to mama kulutu na yo. ");
INSERT INTO lin_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Okosambwisa te ndeko mobali ya tata na yo na kosangisa nzoto na mwasi na ye. Azali mama na yo. ");
INSERT INTO lin_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Okosangisa nzoto te na bokilo na yo. Azali mwasi ya mwana na yo, kosangisa na ye nzoto te. ");
INSERT INTO lin_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Okosambwisa te ndeko na yo ya mobali na kosangisa nzoto na mwasi na ye. ");
INSERT INTO lin_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Okosangisa nzoto te na mama mpe na mwana na ye ya mwasi to na mwana mwasi ya mwana na ye ya mobali mpe ya mwasi ; pamba te bazali makila moko mpe ekozala likambo ya nkele penza na miso ya Nzambe. ");
INSERT INTO lin_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Okosangisa nzoto te na ndeko mwasi ya mwasi na yo, wana mwasi na yo azali nanu na bomoi, noki te ekoyeisa bombanda. ");
INSERT INTO lin_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Okosangisa nzoto te na mwasi oyo azali komona makila na ye ya sanza, pamba te azali mbindo. ");
INSERT INTO lin_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Okosangisa nzoto te na mwasi ya moninga na yo, noki te okokoma mbindo elongo na ye. ");
INSERT INTO lin_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Okopesa moko kati na bana na yo te lokola mbeka epai ya nzambe Moloki, pamba te osengeli te kobebisa lokumu ya Kombo ya Nzambe na yo. Ngai nazali Yawe. ");
INSERT INTO lin_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Okosangisa nzoto te na mwana mobali ndenge basangisaka nzoto na mwana mwasi ; ezali likambo ya nkele. ");
INSERT INTO lin_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Okosangisa nzoto te na nyama, noki te okokoma mbindo elongo na yango. Ndenge moko mpe mwasi akosangisa nzoto te na nyama : ezali kotiola Nzambe. ");
INSERT INTO lin_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Bomikomisa mbindo te na moko ya makambo oyo, pamba te ezali na nzela na yango nde bato ya bikolo oyo nazali kobengana liboso na bino bamikomisaki mbindo. ");
INSERT INTO lin_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Lokola mboka yango moko mpe ekomaki mbindo, napesaki yango mpe etumbu mpo na lisumu na yango ; bongo esanzaki bavandi na yango. ");
INSERT INTO lin_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Kasi, ezala mwana mboka to mopaya oyo bazali kati na bino, bosengeli kotosa malako mpe bikateli na Ngai ; mpe bosengeli koboya kosala makambo nyonso oyo ya nkele na miso ya Nzambe. ");
INSERT INTO lin_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Pamba te bato oyo bazalaki kovanda na mboka oyo liboso na bino babandaki kosala makambo oyo nyonso, bongo mboka ekomaki mbindo. ");
INSERT INTO lin_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Bino bokeba ete bokomisa mboka mbindo te, mpo ete yango esanza bino te ndenge esanzaki bato ya bikolo oyo bazalaki liboso na bino. ");
INSERT INTO lin_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Moto nyonso oyo akosala moko ya makambo oyo ya nkele na miso ya Nzambe, esengeli balongola ye kati na bato na ye. ");
INSERT INTO lin_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Boye, bobatela malako na Ngai mpe bolanda ata likambo moko te kati na makambo mabe oyo ezalaki kosalema liboso ete bino boya, mpo ete bomikomisa mbindo te na nzela na yango. Nazali Yawe, Nzambe na bino. › » ");
INSERT INTO lin_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","« Yebisa lisanga mobimba ya bana ya Isalaele : ‹ Bozala bule, pamba te Ngai Yawe, Nzambe na bino, nazali Bule. ");
INSERT INTO lin_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Moto nyonso kati na bino asengeli kotosa mama mpe tata na ye, mpe bosengeli kotosa mikolo na Ngai ya Saba. Nazali Yawe, Nzambe na bino. ");
INSERT INTO lin_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Bomipesa te na banzambe ya bikeko to bomisalela te banzambe ya bikeko ya bibende ; Ngai nazali Yawe, Nzambe na bino. ");
INSERT INTO lin_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Tango bokobonza mbeka ya boyokani epai na Yawe, bosala yango na ndenge esengeli mpo ete endimama mpo na bolamu na bino. ");
INSERT INTO lin_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Bosengeli kolia yango kaka na mokolo oyo bobonzi yango lokola mbeka to na mokolo oyo elandi. Mpe eloko nyonso oyo ekotikala, bosengeli kozikisa yango na moto na mokolo ya misato. ");
INSERT INTO lin_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Kasi na mokolo yango ya misato, mbeka yango ekokoma mbindo ; soki moto moko alie yango, nakondima yango lisusu te. ");
INSERT INTO lin_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Moto nyonso oyo akolia yango, akomema mokumba ya mabe na ye mpo ete asambwisi eloko oyo ezali bule mpo na Yawe, mpe basengeli kobengana ye kati na bato na ye. ");
INSERT INTO lin_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Tango okobuka mbuma ya bilanga na yo, okobuka yango te kino na mondelo, mpe okozonga te mpo na kolokota mbuma oyo ekokweya. ");
INSERT INTO lin_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Okobuka mpe te mbuma ya vino oyo ekotikala to kolokota oyo ekokweya. Okotika yango mpo na babola to bapaya : nazali Yawe Nzambe na yo. ");
INSERT INTO lin_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Okoyiba te, okoloba lokuta te, moto moko te akosa moninga na ye. ");
INSERT INTO lin_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Okolapa te ndayi ya lokuta na Kombo na Ngai mpe okobebisa te bosantu ya Kombo ya Nzambe na yo. Nazali Yawe, Nzambe na yo. ");
INSERT INTO lin_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Okonyokola te moninga na yo to okoyiba ye te. Okobomba te lifuti ya mosali na yo butu mobimba kino na tongo. ");
INSERT INTO lin_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Okolakela mabe te moto oyo akufa matoyi mpe okotia libaku te liboso ya mokufi miso, kasi okotosa Nzambe na yo. Nazali Yawe. ");
INSERT INTO lin_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Okosambisa na bosembo. Okokotela te, ezala mobola to mozwi. Okosambisa moninga na yo na bosembo. ");
INSERT INTO lin_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Okokende te kotonga bato na yo bipai na bipai. Okosala eloko moko te oyo ekoyeisa pasi na bomoi ya moninga na yo. Nazali Yawe. ");
INSERT INTO lin_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Okoyina ndeko na yo te na motema na yo ; kasi pamela moninga mpo ete omema ngambo te na likambo na ye. ");
INSERT INTO lin_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Okozongisa mabe na mabe te to okobombela moko kati na bato na yo kanda te, kasi okolinga moninga na yo ndenge yo moko omilingaka. Nazali Yawe. ");
INSERT INTO lin_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Okobatela bikateli na ngai : okosangisa nzoto te ya banyama mibale ya lolenge mibale ekesana ; okolona mpe te na elanga na yo nkona mibale ekesana. Okolata te elamba oyo batongi na basinga mibale ekesana. ");
INSERT INTO lin_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Soki mobali moko asangisi nzoto na mwasi oyo azali mobandami ya mobali mosusu, kasi nanu bapeseli ye te biloko ya libala to kopesa ye bonsomi, esengeli mobali wana afuta lomande. Nzokande bango mibale, bakoboma bango te mpo ete mwasi yango asikolamaki nanu te. ");
INSERT INTO lin_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Mpe mobali asengeli komema na ekotelo ya Ndako ya kapo ya Bokutani meme ya mobali oyo akobonza epai na Yawe lokola mbeka mpo na masumu. ");
INSERT INTO lin_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Bongo na nzela ya meme yango ya mbeka mpo na masumu, Nganga-Nzambe akosala mosala ya bolimbisi masumu ya mobali yango liboso ya Yawe, mpe masumu oyo asilaki kosala ekolimbisama. ");
INSERT INTO lin_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Tango bokokota na mokili ya Kanana, bokolona banzete ya lolenge nyonso oyo ebotaka mbuma. Na mibu misato, bokozwa bambuma na yango nyonso lokola bambuma ya mbindo ; boye bokolia yango te. ");
INSERT INTO lin_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Na mobu ya minei, bokobulisa bambuma na yango nyonso ekozala bule mpo na Yawe lokola litatoli ya kozongisa matondi epai na Ye. ");
INSERT INTO lin_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Nzokande na mobu ya mitano, bokoki kolia bambuma yango. Na nzela wana, bambuma na bino ekokoma ebele. Nazali Yawe, Nzambe na bino. ");
INSERT INTO lin_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Bokolia te nyama oyo ezali na makila kati na yango. Bokosalela soloka to kindoki te. ");
INSERT INTO lin_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Okokata suki te na bangambo nyonso ya moto na yo, okokata mpe te mandefu na bapembeni na yango. ");
INSERT INTO lin_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Soki bozwi matanga, bomikata-kata banzoto na bino te to bomikatisa banzoloko te. Nazali Yawe. ");
INSERT INTO lin_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Bobebisa te lokumu ya bana na bino ya basi na kokomisa bango basi ya ndumba, noki te mboka mobimba ekomipesa na kindumba mpe ekotonda na mabe. ");
INSERT INTO lin_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Bokobatelaka mikolo na Ngai ya Saba mpe bokotosaka Esika na Ngai ya bule. Nazali Yawe. ");
INSERT INTO lin_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Bokende te kotuna makambo na bino epai ya bato oyo basololaka na bakufi to epai ya banganga-kisi, noki te bokomikomisa mbindo ; Ngai nazali Yawe, Nzambe na bino. ");
INSERT INTO lin_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Bokotelema liboso ya bato oyo banuni, bokolakisa botosi na bino epai ya mibange ; na nzela wana, bokokumisa Nzambe na bino. Nazali Yawe. ");
INSERT INTO lin_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Soki mopaya moko ayei kovanda kati na bino, na mokili na bino, bonyokola ye te. ");
INSERT INTO lin_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Nzokande bozwa ye kati na bino lokola mwana mboka. Bokolinga ye lokola bino moko, pamba te bino mpe bozalaki bapaya kati na Ejipito. Nazali Yawe, Nzambe na bino. ");
INSERT INTO lin_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Bokosalela lokuta te tango bokomeka molayi, bakilo mpe tango bokoluka koyeba ebele oyo ekoki kozala na kati. ");
INSERT INTO lin_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Bokosalela bimekelo ya malamu, bakilo ya malamu, efa ya malamu ; Ngai nazali Yawe, Nzambe na bino, oyo abimisaki bino na Ejipito. ");
INSERT INTO lin_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Bokobatela bikateli mpe mibeko na Ngai nyonso mpe bokosalela yango. Nazali Yawe. › » ");
INSERT INTO lin_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Yawe alobaki na Moyize ");
INSERT INTO lin_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","ete apesa malako oyo epai ya bana ya Isalaele : « Soki moto moko ya Isalaele to mopaya oyo avandi kati na Isalaele abonzi moko kati na bana na ye lokola mbeka epai ya nzambe Moloki, esengeli baboma ye. Bato ya mokili bakobamba ye mabanga. ");
INSERT INTO lin_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Ngai nakotombokela moto yango mpe nakolongola ye kati na bato na ye, pamba te abonzaki mwana na ye lokola mbeka epai ya nzambe Moloki mpo na kokomisa mbindo Esika na Ngai ya bule mpe mpo na kobebisa bosantu ya Kombo na Ngai. ");
INSERT INTO lin_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Mpe soki bato ya mokili bakangi miso na bango tango moto wana azali kobonza mwana na ye lokola mbeka epai ya nzambe Moloki mpe baboyi koboma ye, ");
INSERT INTO lin_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","ngai nakotombokela moto yango mpe libota na ye, nakolongola bango na ekolo na bango, elongo na bato nyonso oyo balandaki ye mpo na kosalela nzambe Moloki. ");
INSERT INTO lin_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Nakotombokela lisusu bato nyonso oyo balandaka moto oyo asololaka na bakufi mpe banganga-kisi mpo na kosalela banzambe ya bikeko. Nakolongola bango kati na bato na bango. ");
INSERT INTO lin_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Bomibulisa mpe bozala bule, pamba te nazali Yawe, Nzambe na bino. ");
INSERT INTO lin_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Bobatela bikateli na Ngai mpe bosalela yango. Nazali Yawe oyo akomisi bino basantu. ");
INSERT INTO lin_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Moto nyonso oyo akolakela tata na ye to mama na ye mabe, esengeli baboma ye ; pamba te alakeli tata na ye to mama na ye mabe : makila na ye ekotangama na moto na ye moko. ");
INSERT INTO lin_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Soki mobali asali ekobo na mwasi ya mobali mosusu, mwasi ya moninga na ye ; bango mibale, mwasi na mobali oyo basali ekobo, esengeli koboma bango. ");
INSERT INTO lin_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Soki mobali asangisi nzoto na mwasi ya tata na ye, asambwisi tata na ye ; bango mibale, esengeli koboma bango : makila na bango ekotangama na mito na bango moko. ");
INSERT INTO lin_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Soki mobali asangisi nzoto na mwasi ya mwana na ye ya mobali ; bango mibale esengeli koboma bango, pamba te basali bosoto : makila na bango ekotangama na mito na bango moko. ");
INSERT INTO lin_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Soki mobali asangisi nzoto na moninga na ye mobali ndenge basangisaka nzoto na mwasi, bango mibale basali likambo moko ya mbindo ; boye esengeli koboma bango mpe makila na bango ekotangama na mito na bango moko. ");
INSERT INTO lin_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Soki mobali abali mwasi mpe mama ya mwasi, ezali likambo ya mabe koleka. Bango nyonso misato : mobali mpe basi nyonso mibale, esengeli kotumba bango na moto, mpo ete mabe moko te ezala kati na bino. ");
INSERT INTO lin_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Soki mobali asangisi nzoto na nyama, esengeli koboma ye elongo na nyama yango. ");
INSERT INTO lin_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Ndenge moko mpe soki mwasi asangisi nzoto na nyama, bakoboma ye elongo na nyama yango : makila na bango ekotangama na mito na bango moko. ");
INSERT INTO lin_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Soki mobali abali mwasi oyo azali ndeko na ye mpo ete abotami na mama mosusu to tata mosusu, bongo asangisi na ye nzoto, ezali likambo ya soni. Bakolongola bango na miso ya bato na bango. Lokola mobali asambwisi ndeko na ye ya mwasi, akomema ngambo. ");
INSERT INTO lin_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Soki mobali asangisi nzoto na mwasi oyo azali komona makila na ye ya sanza ; bango mibale, esengeli kobengana bango kati na bato na bango, mpo te basangisaki nzoto na tango mwasi azalaki komona makila na ye ya sanza. ");
INSERT INTO lin_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Okosangisa nzoto te na ndeko mwasi ya tata to ya mama na yo, pamba te ekosambwisa bondeko. Soki moto asali yango, bango mibale bakomema ngambo mpo na mabe na bango. ");
INSERT INTO lin_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Soki mobali moko asangisi nzoto na mwasi ya ndeko ya tata na ye to mwasi ya ndeko ya mama na ye, asambwisi ndeko ya tata na ye to ya mama na ye ; bango mibale bakomema ngambo mpo na mabe na bango mpe bakokufa bazanga bana. ");
INSERT INTO lin_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Soki mobali asangisi nzoto na mwasi ya ndeko na ye ya mobali, ezali likambo ya mbindo ; asambwisi ndeko na ye ya mobali ; bakokufa bazanga bana. ");
INSERT INTO lin_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Bobatela mpe botosa bikateli mpe mibeko na Ngai nyonso ; bosalela yango mpo ete mokili epai wapi nakomema bino mpo na kovanda esanza bino te. ");
INSERT INTO lin_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Bolanda te bizaleli ya bikolo oyo nakobengana liboso na bino, pamba te basalaki makambo wana nyonso mpe nayinaki bango. ");
INSERT INTO lin_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Boye nayebisaki bino : ‹ Bino nde bato bokozwa mokili na bango, mokili oyo ebimisaka miliki mpe mafuta ya nzoyi ; napesi bino yango lokola libula. › Nazali Yawe, Nzambe na bino, oyo alongolaki bino kati na bikolo mpe atiaki bino pembeni. ");
INSERT INTO lin_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Yango wana bosengeli kosala bokeseni kati na nyama oyo ezali mbindo mpe oyo ezangi mbindo, kati na ndeke oyo ezali mbindo mpe oyo ezali peto. Bosengeli te komikomisa mbindo na nzela ya nyama, ya ndeke to ya nyama nyonso oyo etambolaka na libumu, oyo natiaki pembeni mpo ete bino mpe bomona yango lokola mbindo. ");
INSERT INTO lin_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Bozala bule, bato oyo babulisami mpo na Ngai ; pamba te Ngai Yawe, nazali Bule ; nalongolaki bino kati na bikolo mosusu, natiaki bino pembeni, mpo ete bozala bato na Ngai moko. ");
INSERT INTO lin_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Mobali to mwasi oyo asololaka na bakufi to oyo azali nganga-kisi kati na bino, esengeli baboma ye : bakobamba bango mabanga mpe makila na bango ekotangama na mito na bango moko. » ");
INSERT INTO lin_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Yawe ayebisaki Moyize : « Loba na Banganga-Nzambe, bana mibali ya Aron : ‹ Nganga-Nzambe akoki te komikomisa mbindo na kosimba ebembe ya moto moko kati na libota na ye, ");
INSERT INTO lin_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","longola kaka soki ezali ebembe ya mama na ye, ya tata na ye, ya mwana na ye ya mobali to ya mwana na ye ya mwasi, ya ndeko na ye ya mobali. ");
INSERT INTO lin_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","Mpo na ndeko na ye ya mwasi oyo ayebi nanu nzoto ya mibali te, oyo azali nanu na maboko na ye awa abali nanu te ; Nganga-Nzambe akoki komikomisa mbindo. ");
INSERT INTO lin_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Lokola azali mokambi kati na bato na ye, akoki te komikomisa mbindo ; noki te akobebisa bosantu mpe lokumu na ye. ");
INSERT INTO lin_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Banganga-Nzambe bakoki te komikokola suki ya moto, kokata mandefu na bapembeni to kokata nzoloko na banzoto na bango. ");
INSERT INTO lin_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Nzokande basengeli kozala bato bamibulisi mpo na mosala na Ngai Nzambe na bango. Boye, basengeli te kobebisa lokumu mpe bosantu ya Kombo ya Nzambe na bango ; pamba te ezali bango nde babonzaka makabo bazikisa na moto mpo na Yawe, bilei ya Nzambe na bango. Mpo na yango, basengeli kozala bule mpo na Yawe. ");
INSERT INTO lin_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Banganga-Nzambe basengeli te kobala basi oyo basalaka kindumba to ba-oyo babebisa lokumu na bango na nzela ya mibali mosusu to ba-oyo babengana bango na libala. Pamba te, Banganga-Nzambe bazali basantu oyo babulisami mpo na mosala na Ngai Nzambe na bango. ");
INSERT INTO lin_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Bato nyonso ya Isalaele basengeli komona bango lokola basantu, pamba te babonzaka bilei ya Nzambe na bino. Bomona bango basantu mpo ete Ngai Yawe oyo naponi Isalaele mpe nakomisi bino basantu, nazali Mosantu. ");
INSERT INTO lin_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Mwana mwasi ya Nganga-Nzambe oyo abebisi lokumu na ye na kosala kindumba asambwisi nde tata na ye ; boye esengeli kotumba ye ya bomoi na moto. ");
INSERT INTO lin_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Mokonzi ya Banganga-Nzambe azali na bokonzi likolo ya Banganga-Nzambe mosusu ; basopelaki ye mafuta ya epakolami na moto mpo na kobulisa ye, mpe asengeli kolata bilamba ya bonganga-Nzambe. Mpo na yango, asengeli te kopanza suki na ye ya moto to kopasola bilamba na ye na mokolo ya matanga. ");
INSERT INTO lin_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Akoki te kopusana pembeni ya ebembe mpe komikomisa mbindo mpo na kufa ya tata na ye to ya mama na ye. ");
INSERT INTO lin_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Azali na ndingisa te ya kotika Esika ya bule ya Nzambe na ye to kobebisa bosantu na yango, pamba te abulisamaki na nzela ya mafuta ya epakolami ya Nzambe na ye. Nazali Yawe. ");
INSERT INTO lin_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Mokonzi ya Banganga-Nzambe asengeli kobala mwasi oyo ayebi nanu nzoto ya mibali te. ");
INSERT INTO lin_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Akoki kobala te mwasi oyo akufisa mobali, mwasi oyo babengani na libala to mwasi oyo abebisa lokumu na ye na kosala kindumba ; kasi akobala kaka, kati na bato na ye, mwasi oyo ayebi nanu nzoto ya mibali te. ");
INSERT INTO lin_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Na bongo, akobebisa te bosantu ya bakitani na ye kati na bato na ye ; pamba te ezali Ngai Yawe nde nabulisi ye. › » ");
INSERT INTO lin_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Yawe ayebisaki Moyize : ");
INSERT INTO lin_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","« Loba na Aron : ‹ Kati na bana na yo nyonso na milongo oyo ekoya, moto moko te oyo azali na mbeba na nzoto na ye, akoki kopusana mpo na kobonza bilei ya Nzambe na ye. ");
INSERT INTO lin_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Moto moko te oyo azali na mbeba na nzoto akoki kopusana pembeni ya etumbelo : mokufi miso, moto oyo atambolaka tengu-tengu ; moto oyo abeba na elongi, na makolo mpe oyo maboko to makolo na ye ekokana te, ");
INSERT INTO lin_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","moto oyo abukana lokolo to loboko, ");
INSERT INTO lin_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","moto oyo azali na kunki na mokongo to oyo azali penza mokuse ; moto oyo azali na liso ekufa, na makwanza, na mapalata to oyo baboma mokongo. ");
INSERT INTO lin_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Kati na bakitani ya Nganga-Nzambe Aron, moko te oyo azali na mbeba na nzoto akopusana pembeni ya etumbelo mpo na kobonza makabo bazikisa na moto mpo na Yawe. Lokola azali na mbeba na nzoto na ye, akoki te kopusana mpo na kobonza bilei ya Nzambe na ye. ");
INSERT INTO lin_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Akoki na ye kolia bilei nyonso oyo bakobonzela Ngai Nzambe na ye, bilei ya bule mpe bilei oyo eleki bule. ");
INSERT INTO lin_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Kasi mpo na mbeba ya nzoto na ye, akoki te kopusana pembeni ya rido ya Esika ya bule to ya etumbelo, mpo ete abebisa te bosantu ya Esika na Ngai ya bule, pamba te Ngai nazali Yawe, mpe ezali Ngai nde nabulisaki Banganga-Nzambe mpo na mosala na Ngai. › » ");
INSERT INTO lin_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Moyize alobaki makambo oyo epai ya Aron, epai ya bana na ye ya mibali, mpe epai ya bana nyonso ya Isalaele. ");
INSERT INTO lin_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","« Talisa Aron mpe bana na ye ya mibali ndenge nini basengeli kozala mosika ya makabo oyo bana ya Isalaele babonzelaka Ngai, mpo ete babebisa te bosantu ya Kombo na Ngai ya bule ; Ngai nazali Yawe. ");
INSERT INTO lin_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Loba na bango : ‹ Mpo na milongo oyo ekoya na sima mpe kati na bakitani na bino, soki moko azali mbindo mpe apusani pembeni ya makabo ya bule oyo bana ya Isalaele babonzeli Ngai Yawe, esengeli balongola moto wana na miso na Ngai. Nazali Yawe. ");
INSERT INTO lin_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Soki moko ya bakitani ya Aron azali na bokono na poso ya nzoto lokola maba, bokono ya kobima tofina to makila na nzoto ya mibali, akoki te kolia likabo ya bule kino tango akokoma peto. Ndenge moko mpe, akozala mbindo soki asimbi eloko oyo ekomi mbindo mpo ete etuti ebembe to mobali oyo abimisi mayi ya mibali ; ");
INSERT INTO lin_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","soki asimbi nyama oyo etambolaka na libumu mpe ekomisaka mbindo to soki asimbi moto nyonso oyo akoki kokomisa ye mbindo ata na nzela ya ndenge nini. ");
INSERT INTO lin_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Moto oyo akosimba eloko ya ndenge wana akozala mbindo kino na pokwa. Akoki kolia likabo ya bule te kino tango akosukola na mayi. ");
INSERT INTO lin_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Akokoma peto tango moyi ekolala mpe sima na yango nde akoki kolia makabo ya bule, pamba te ezali bilei na ye. ");
INSERT INTO lin_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Akoki te kolia nyama oyo ekufi yango moko to oyo nyama ya zamba ebomi, noki te akokoma mbindo na nzela na yango. Nazali Yawe. ");
INSERT INTO lin_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Banganga-Nzambe bakotosa malako na Ngai tango nyonso mpo ete bamema ngambo te mpe bakufa te, noki te bakokufa solo. Ngai nazali Yawe oyo abulisaki bango mpe akomisaka bango basantu mpo na mosala na Ngai. ");
INSERT INTO lin_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Moto moko te oyo azali na libota ya Banganga-Nzambe te akoki kolia makabo ya bule : ezala mopaya oyo Nganga-Nzambe abengi to mosali oyo Nganga-Nzambe azwi na mosala. ");
INSERT INTO lin_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Kasi soki Nganga-Nzambe asombi mowumbu na mbongo na ye to soki mowumbu abotami na ndako na ye, mowumbu wana akolia makabo ya bule. ");
INSERT INTO lin_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Soki mwana mwasi ya Nganga-Nzambe abali mobali oyo azali Nganga-Nzambe te, akolia te makabo ya bule. ");
INSERT INTO lin_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Kasi soki mwana mwasi ya Nganga-Nzambe akufisi mobali to akabwani na mobali, bongo amiboteli mwana te mpe azongi kovanda na ndako ya tata na ye lokola tango azalaki elenge, akoki kolia biloko ya ndenge moko na tata na ye ; kasi moto oyo azali Nganga-Nzambe te akolia yango te. ");
INSERT INTO lin_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Soki moto alie likabo ya bule na kozanga koyeba, asengeli kozongisa epai ya Nganga-Nzambe motuya ya likabo yango mpe akobakisa eteni moko kati na mitano ya motuya na yango. ");
INSERT INTO lin_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Banganga-Nzambe basengeli te kobebisa lokumu ya makabo ya bule oyo bana ya Isalaele babonzeli Yawe. ");
INSERT INTO lin_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Soki, wana bazali mbindo, balie yango, bakomemisa bana ya Isalaele ngambo oyo ekosala ete bapesa likabo mpo na kozongisa boyokani, pamba te ezali Ngai Yawe nde nabulisaka bango mpo na mosala na Ngai. › » ");
INSERT INTO lin_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","« Yebisa Aron, bana na ye ya mibali mpe bana nyonso ya Isalaele : ‹ Soki moto ya Isalaele to mopaya oyo azali kovanda kati na Isalaele alingi kobonza mbeka ya kotumba epai na Yawe mpo na kokokisa ndayi to likabo oyo apesi kolanda mokano ya motema na ye moko, ");
INSERT INTO lin_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","asengeli kobonza nyama ya mobali oyo ezangi mbeba kati na bangombe, bameme to bantaba mpo ete Nzambe andima yango. ");
INSERT INTO lin_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Asengeli te kobonza nyama oyo ezali na mbeba, pamba te ekondimama te. ");
INSERT INTO lin_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Ndenge moko mpe, soki moto alingi kobonza epai na Yawe mbeka ya boyokani oyo azwi kati na bangombe, bameme to bantaba, mpo na kokokisa ndayi to likabo oyo apesi kolanda mokano ya motema na ye moko, nyama yango esengeli kozala ezanga mbeba. ");
INSERT INTO lin_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Bokobonza te epai na Yawe nyama oyo ekufa liso to ezoka, oyo ezali kotambola tengu-tengu to oyo ezali na bokono na poso ya nzoto, oyo ezali na makwanza to na mapalata ; bokoki te kotia nyama ya boye na likolo ya etumbelo lokola likabo bazikisa na moto mpo na Yawe. ");
INSERT INTO lin_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Nzokande bokoki mpe te kobonza mpo na Yawe lokola likabo oyo bopesi kolanda mokano ya mitema na bino moko, ngombe ya mobali to meme oyo ezali na makolo to maboko ekokana te. Mbeka ya boye ekoki kondimama te mpo na kokokisa ndayi. ");
INSERT INTO lin_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Bokobonza kaka epai na Yawe, nyama oyo mapumbu na yango bafina penza to banika, balongola to bakata ; bokoki kosala bongo te kati na mboka na bino moko. ");
INSERT INTO lin_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Bokoki kondima nyama ya lolenge oyo te na maboko ya bapaya mpo na kobonza yango epai na Yawe lokola bilei ya Nzambe na bino. Ekoki kondimama te, pamba te ezali na mbeba. › » ");
INSERT INTO lin_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","« Soki mwana ngombe, mwana meme to mwana ntaba ebotami, ekosala mikolo sambo epai ya mama na yango, bongo na mokolo ya mwambe, ekondimama lokola likabo bazikisa na moto mpo na Yawe. ");
INSERT INTO lin_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Bokoki te kokata kingo ya ngombe ya mwasi to ya meme ya mwasi mokolo moko na mwana na yango. ");
INSERT INTO lin_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Tango bokobonza mbeka ya kozongisa matondi epai na Yawe, bobonza yango na lolenge oyo ekosala ete Nzambe andima bino. ");
INSERT INTO lin_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Esengeli bolia yango kaka mokolo wana. Bokotika eloko moko te kino na tongo. Nazali Yawe. ");
INSERT INTO lin_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Bobatela mitindo na Ngai mpe bosalela yango. Nazali Yawe. ");
INSERT INTO lin_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Bokobebisa te lokumu ya Kombo na Ngai ya bule, mpo ete bana ya Isalaele bayeba solo ete Ngai nazali Mosantu. Ezali Ngai Yawe nde nabulisaki bino. ");
INSERT INTO lin_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Nabimisaki bino na mokili ya Ejipito mpo ete nazala Nzambe na bino. Nazali Yawe. » ");
INSERT INTO lin_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","« Yebisa bana ya Isalaele : ‹ Tango bokobanda kosangana mpo na kosala bafeti mpo na lokumu na Ngai, bokobanda kobengisa bato mpo na kogumbamela Ngai Yawe, pamba te ezali mayangani ya bule. ");
INSERT INTO lin_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Bokosala mikolo motoba, kasi mokolo ya sambo ezali Saba, mokolo ya kopema ; mokolo ya mayangani ya bule. Na esika nyonso oyo bokozala, bokosala ata mosala moko te : ezali mokolo ya Saba ya Yawe. ");
INSERT INTO lin_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Tala bafeti mosusu ya Yawe, mayangani ya bule oyo bokobengisela bato na mikolo oyo ekatama mpo na kopesa Ngai lokumu. ");
INSERT INTO lin_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Pasika ya Yawe ekobanda na pokwa ya mokolo ya zomi na minei ya sanza ya liboso. ");
INSERT INTO lin_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Na mokolo ya zomi na mitano ya sanza wana nde feti ya Mapa ezanga levire mpo na Yawe ekobanda. Bokolia mapa ezanga levire mikolo sambo. ");
INSERT INTO lin_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Na mokolo ya liboso, bokozala na mayangani ya bule ; bokosala mosala moko te oyo bosalaka mokolo na mokolo. ");
INSERT INTO lin_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Mikolo sambo, bokobonzela Yawe makabo bazikisa na moto. Mpe na mokolo oyo ya sambo, bokozala na mayangani ya bule ; bokosala mosala moko te oyo bosalaka mokolo na mokolo. › » ");
INSERT INTO lin_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","« Yebisa bana ya Isalaele : ‹ Tango bokokota na mokili oyo nakopesa bino mpe tango bokobuka bambuma kati na mokili yango, bokomema epai ya Nganga-Nzambe liboke ya liboso ya bambuma oyo bokobuka. ");
INSERT INTO lin_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Na mokolo oyo ekolanda Saba, Nganga-Nzambe akobonza liboke yango na kotombola liboso ya Yawe mpo ete Ngai nandima yango. ");
INSERT INTO lin_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Na mokolo yango, bakobonza liboke yango na kotombola, bokobonzela Yawe mwana meme ya mobu moko mpe ezanga mbeba lokola mbeka ya kotumba. ");
INSERT INTO lin_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Bokobakisa bakilo motoba ya farine basangisa na mafuta lokola likabo bazikisa na moto mpo na Yawe, oyo solo kitoko na yango ekosepelisa Yawe, mpe bokobakisa lisusu litele moko na ndambo ya vino lokola likabo na yango ya masanga. ");
INSERT INTO lin_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Bokoki kolia ata lipa moko te, ezala bambuma bakalinga to bambuma ya sika, kino na mokolo oyo bokobonza likabo yango epai ya Nzambe na bino. Oyo mpe ezali mobeko ya libela mpo na milongo ya bakitani na bino oyo bakoya sima na bino na bisika nyonso oyo bokozala. ");
INSERT INTO lin_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Bosengeli kotanga baposo sambo, kobanda na mokolo oyo elandi mokolo ya Saba, mokolo oyo bokomema liboke ya bambuma mpo ete batombola yango ; baposo nyonso sambo esengeli kozala ya kokoka. ");
INSERT INTO lin_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Bokotanga mikolo tuku mitano kino na mokolo oyo ekolanda mokolo ya Saba. Na mokolo wana ya Saba, bokobonza epai na Yawe likabo ya bambuma ya sika. ");
INSERT INTO lin_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Bokomema, wuta na bisika nyonso oyo bokozala, mapa mibale mpo na kobonza yango na kotombola ; bakosala moko na moko kati na yango na bakilo motoba ya farine basangisa na levire mpe batumba na moto. Ekozala likabo ya bambuma na bino ya liboso mpo na Yawe. ");
INSERT INTO lin_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Elongo na mapa wana, bokobonza lokola mbeka ya kotumba : bana meme sambo ya mibali ya mobu moko mpe ezanga mbeba, ngombe moko ya mobali mpe bameme mibale ya mibali. Bokobonza yango mpo na Yawe, elongo na makabo na yango ya bambuma mpe ya masanga, lokola likabo bazikisa na moto, oyo solo kitoko na yango ekosepelisa Yawe. ");
INSERT INTO lin_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Bokobonzela Ngai lisusu ntaba moko ya mobali lokola mbeka mpo na masumu mpe bana meme mibale ya mobu moko lokola mbeka ya boyokani. ");
INSERT INTO lin_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Nganga-Nzambe akobonza na kotombola, liboso ya Yawe, bana meme yango mibale elongo na mapa ya bambuma ya liboso. Ekozala makabo ya bule mpo na Ngai Yawe mpe ekozala ya Nganga-Nzambe. ");
INSERT INTO lin_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Kaka na mokolo wana, bokobengisa bato na mayangani mpo na lokumu na Ngai. Ekozala mayangani ya bule, mpe bokosala mosala moko te oyo bosalaka mokolo na mokolo. Na bisika nyonso oyo bokovanda, ekozala mitindo ya libela mpo na milongo ya bakitani na bino oyo bakoya sima na bino. ");
INSERT INTO lin_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Tango bokobuka bambuma na mboka na bino, bobuka te kino na bandelo ya bilanga na bino mpe bolokota te oyo ekobanda kokweya. Botika yango mpo na mobola to mopaya. Nazali Yawe, Nzambe na bino. › » ");
INSERT INTO lin_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","« Yebisa bana ya Isalaele : ‹ Mokolo ya liboso ya sanza ya sambo ekozala mpo na bino mokolo ya kopema, mokolo ya ekaniseli mpe ya kobeta kelelo, mokolo ya mayangani ya bule mpo na lokumu na Ngai. ");
INSERT INTO lin_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Bokosala mosala moko te oyo bomesana kosala, kasi bokobonzela Yawe makabo bazikisa na moto. › » ");
INSERT INTO lin_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","« Mokolo ya zomi ya sanza ya sambo ezali mokolo ya bolimbisi masumu. Bokozala na mayangani ya bule mpo na lokumu na Ngai ; bokomikitisa mpe bokobonzela Yawe makabo bazikisa na moto. ");
INSERT INTO lin_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Bokosala mosala moko te na mokolo wana, pamba te ezali mokolo ya kosala mosala ya bolimbisi masumu liboso na Ngai Yawe, Nzambe na bino. ");
INSERT INTO lin_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Moto nyonso oyo akokila bilei te na mokolo wana, bakolongola ye kati na bato na ye. ");
INSERT INTO lin_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Nakoboma moto nyonso oyo akosala mosala na mokolo wana. ");
INSERT INTO lin_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Bokoki kosala ata mosala moko te. Na bisika nyonso oyo bokozala, oyo nde ekozala mobeko ya libela mpo na milongo ya bakitani na bino oyo bakoya sima na bino. ");
INSERT INTO lin_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Ekozala mpo na bino mokolo ya kopema lokola mokolo ya Saba, mokolo ya komikitisa. Bokobatela mokolo na bino ya Saba, kobanda na pokwa ya mokolo ya libwa kino na pokwa ya mokolo oyo ekolanda. » ");
INSERT INTO lin_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","« Yebisa bana ya Isalaele : ‹ Na mokolo ya zomi na mitano ya sanza ya sambo, feti ya Bandako ya kapo esengeli kobanda, mpe bakosepela yango mikolo sambo mpo na lokumu ya Yawe. ");
INSERT INTO lin_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Mokolo ya liboso ekozala mokolo ya mayangani ya bule mpo na lokumu na Ngai Yawe ; bokosala mosala moko te oyo bomesana kosala mokolo na mokolo. ");
INSERT INTO lin_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Mikolo sambo, bokobonzela Yawe makabo bazikisa na moto. Na mokolo ya mwambe, bokozala na mayangani ya bule mpo na lokumu na Ngai Yawe, mpe bokobonza makabo bazikisa na moto. Ekozala mokolo ya suka ya mayangani ; bokosala mosala moko te oyo bomesana kosala. ");
INSERT INTO lin_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Oyo nde bafeti oyo bokobanda kosala mpo na lokumu ya Yawe, mpe oyo bokobanda kobengisela bato na mayangani ya bule mpo ete basambela Yawe mpe babonzela Ye makabo bazikisa na moto, bambeka ya kotumba mpe makabo ya bagato, bambeka mpe bambeka ya masanga ya vino, kolanda ndenge ekatama mpo na mokolo na mokolo. ");
INSERT INTO lin_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Bokobakisa makabo oyo na likolo ya makabo oyo bokobonzela Ngai na mikolo ya Saba ya Yawe, na likolo ya bakado na bino, na likolo ya makabo na bino mpo na kokokisa ndayi to na likolo ya makabo oyo bokokata kopesa wuta na mokano ya mitema na bino moko. ");
INSERT INTO lin_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Kasi na mokolo ya zomi na mitano ya sanza ya sambo, sima na kobuka bambuma ya mabele, bokosala feti mpo na Yawe, mikolo sambo. Mokolo ya liboso mpe mokolo ya mwambe ekozala mikolo ya kopema. ");
INSERT INTO lin_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Na mokolo ya liboso, bokopona bambuma ya banzete, mandalala ya banzete ya mbila, bitape ya banzete oyo ezali na makasa ebele mpe banzete oyo babengaka sole mpe ebotaka pembeni ya mayi. Bokosepela liboso ya Yawe, Nzambe na bino, mikolo sambo. ");
INSERT INTO lin_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Na mikolo sambo, bokobanda kosala feti oyo mibu nyonso mpo na lokumu na Yawe. Oyo ezali mobeko ya libela mpo na milongo ya bakitani oyo bakoya sima na bino ; bokosala feti yango na sanza ya sambo. ");
INSERT INTO lin_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Bokovanda na bandako ya matiti mikolo sambo ; bato nyonso oyo bazali bana mboka ya Isalaele bakovanda kati na bandako yango ya matiti ");
INSERT INTO lin_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","mpo ete bakitani na bino bayeba ete navandisaki bana ya Isalaele na bandako ya matiti tango nabimisaki bango na Ejipito. Nazali Yawe, Nzambe na bino. › » ");
INSERT INTO lin_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Moyize ayebisaki bana ya Isalaele malako nyonso oyo etali bafeti ya Yawe. ");
INSERT INTO lin_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","« Pesa mitindo na bana ya Isalaele ete bamemela yo mafuta ya olive ya peto mpo na minda, mpo ete minda ekoka kopela tango nyonso. ");
INSERT INTO lin_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Ezali kati na Ndako ya kapo ya Bokutani, libanda ya rido oyo ezali liboso ya Sanduku ya Litatoli, nde Aron akobanda kopelisa minda tango nyonso liboso ya Yawe, kobanda na pokwa kino na tongo. Ezali mobeko ya libela mpo na milongo na bino nyonso. ");
INSERT INTO lin_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Minda ekozala likolo ya etelemiselo ya minda, esalema na wolo ya peto, liboso ya Yawe ; bakobongisa yango tango nyonso. ");
INSERT INTO lin_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Okozwa farine mpe okolamba bagato zomi na mibale, okosalela biteni mibale kati na biteni zomi ya efa mpo na gato moko na moko. ");
INSERT INTO lin_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Okotanda yango na milongo mibale, gato motoba na molongo moko, likolo ya mesa oyo esalema na wolo ya peto, liboso ya Yawe. ");
INSERT INTO lin_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Na molongo moko na moko, okosopa ansa ya peto oyo ekotumbama na esika ya gato lokola likabo bazikisa na moto mpo na Yawe, mpe ekozala ekaniseli. ");
INSERT INTO lin_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Mikolo nyonso ya Saba, bokobonza lipa yango liboso ya Yawe na kombo ya bana ya Isalaele lokola boyokani ya libela. ");
INSERT INTO lin_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Gato yango ekozala mpo na Aron mpe bana na ye ya mibali ; bana na ye ya mibali bakolia yango na Esika ya bule, pamba te ezali eteni ya bule koleka kati na biteni na bango oyo bazwaka na makabo bazikisa na moto mpo na Yawe. Ezali mobeko mpo na libela. » ");
INSERT INTO lin_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Ezalaki na mwana mobali moko oyo mama na ye azalaki moto ya Isalaele mpe tata na ye, moto ya Ejipito ; apusanaki kati na bana ya Isalaele mpe abundisaki moto ya Isalaele kati na molako. ");
INSERT INTO lin_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Mwana mobali ya mwana mwasi ya Isalaele atiolaki Kombo ya Yawe mpe alakelaki yango mabe, boye bamemaki ye epai ya Moyize. Kombo ya mama na ye ezalaki « Shelomiti. » Shelomiti azalaki mwana mwasi ya Dibiri, kati na libota ya Dani. ");
INSERT INTO lin_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Batiaki ye na boloko kino kozela ete Yawe alakisa bango mokano na Ye. ");
INSERT INTO lin_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","« Mema na libanda ya molako moto oyo atioli Nzambe. Bato nyonso oyo bayokaki ye, bakotia maboko na bango na moto na ye, mpe bato nyonso ya lingomba bakobamba ye mabanga. ");
INSERT INTO lin_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Loba na bana ya Isalaele : ‹ Soki moto alakeli Nzambe na ye mabe, amemi ngambo ; ");
INSERT INTO lin_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","soki moto atioli Kombo ya Yawe, basengeli koboma ye : bato nyonso ya lingomba basengeli kobamba ye mabanga. Azala mopaya to mwana mboka, soki atioli Kombo ya Yawe, basengeli koboma ye. ");
INSERT INTO lin_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Soki moto abomi moto, basengeli koboma ye. ");
INSERT INTO lin_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Soki moto abomi nyama ya moto mosusu, asengeli kozongisa nyama ya bomoi na esika ya nyama oyo ekufi : kolanda mobeko ya bomoi mpo na bomoi. ");
INSERT INTO lin_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Soki moto azokisi moninga na ye, bakosala ye ndenge asalaki moninga : ");
INSERT INTO lin_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","soki abuki eteni ya nzoto, ye mpe bakobuka ye eteni ya nzoto ; soki atoboli liso, ye mpe bakotobola ye liso ; soki abuki linu, ye mpe bakobuka ye linu ; ndenge azokisi moto mosusu, ndenge wana mpe bakozokisa ye. ");
INSERT INTO lin_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Moto nyonso oyo abomi nyama ya moninga na ye, akozongisa nyama mosusu ; kasi oyo abomi moto, basengeli koboma ye. ");
INSERT INTO lin_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Ezala mopaya to mwana mboka, bino nyonso bozali na mobeko moko ; Ngai nazali Yawe, Nzambe na bino. › » ");
INSERT INTO lin_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Bongo Moyize alobaki na bana ya Isalaele ; mpe babimisaki na libanda ya molako moto oyo alakelaki Nzambe mabe mpe babambaki ye mabanga. Bana ya Isalaele basalaki kolanda ndenge Yawe atindaki Moyize. ");
INSERT INTO lin_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Yawe alobaki na Moyize na ngomba Sinai : ");
INSERT INTO lin_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","« Yebisa bana ya Isalaele mpe loba na bango : ‹ Tango bokokota na mokili oyo nakopesa bino ; ezala mabele esengeli kopema, yango ekozala Saba mpo na Yawe. ");
INSERT INTO lin_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Mibu motoba, bokolona bilanga na bino mpe mibu motoba, bokobongisa bilanga na bino ya vino mpe bokobuka bambuma na yango. ");
INSERT INTO lin_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Kasi na mobu ya sambo, mabele esengeli kozala na bopemi, ekozala mobu ya Saba mpo na Yawe. Bokolona bilanga na bino te mpe bokobongisa bilanga na bino ya vino te, mabele esengeli kozala na Saba mpo na Yawe. ");
INSERT INTO lin_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Bokoki kobuka te bambuma oyo ebotaki yango moko na mbala eleki to kobuka bambuma ya vino na elanga oyo babongisa te ; ekozala mobu ya bopemi mpo na mabele. ");
INSERT INTO lin_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Nzokande, biloko oyo mabele ekobota na mobu ya Saba, ekozala bilei na bino : yo, mowumbu na yo ya mobali, mwasi mowumbu na yo, mwana mosala na yo mpe mopaya oyo azali kovanda kati na yo ");
INSERT INTO lin_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","elongo na banyama ya mboka mpe ya zamba oyo bazali kati na mokili na bino. Bosengeli kolia biloko nyonso oyo mabele ekobota. ");
INSERT INTO lin_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Bokotanga mibu sambo ya Saba, mbala sambo, na mibu sambo ; mpe mibu sambo ya Saba ekosala mibu tuku minei na libwa. ");
INSERT INTO lin_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Bongo na sima, na mokolo ya zomi, na sanza ya sambo, na mokolo ya bolimbisi masumu, bokobeta kelelo na bisika nyonso kati na mokili na bino mobimba. ");
INSERT INTO lin_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Bokobulisa mobu ya tuku mitano mpe bokosakola, kati na mokili mobimba, kokangolama ya bavandi na yango nyonso. Ekozala mpo na bino mobu ya kosepela kokangolama na bino ; moto moko na moko kati na bino akozonga na mabele na ye, na libota na ye. ");
INSERT INTO lin_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Mobu ya tuku mitano ekozala mobu ya kosepela kokangolama na bino : bokolona te, bokobuka te biloko oyo bilanga ekobota yango moko, mpe bokobuka te bambuma ya vino ya elanga oyo babongisa te. ");
INSERT INTO lin_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Pamba te ezali mobu ya kosepela kokangolama na bino, mpe esengeli kozala bule mpo na bino. Bokolia kaka bambuma ya bilanga. ");
INSERT INTO lin_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Na mobu yango ya kosepela kokangolama na bino, moto nyonso kati na bino akozonga na mabele na ye. ");
INSERT INTO lin_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Soki bozali koteka mabele epai ya ndeko na bino to soki bozali kosomba eloko songolo epai na ye, wana bozali bana mboka moko, tika ete moko te kati na bino akosa ndeko na ye. ");
INSERT INTO lin_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Okosomba epai ya ndeko na yo ya mboka, na motuya ya mbongo oyo bakokata kolanda motango ya mibu oyo eleki wuta mobu ya suka oyo bosepelaki kokangolama na bino ; mpe akotekela yo na motuya ya mbongo oyo ekokatama kolanda motango ya mibu oyo ekotikala, mibu ya kobuka bambuma, kino bokoma na mobu oyo ekolanda, mobu ya kosepela kokangolama na bino. ");
INSERT INTO lin_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Soki mibu etikali ebele, bosengeli komatisa motuya ; mpe soki mibu ezali moke, bosengeli kokitisa motuya, pamba te ezali motango ya mibu ya kobuka bambuma nde etekamaka : yango nde bakotekela yo. ");
INSERT INTO lin_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Tika ete moko te akosa moninga, kasi banga Nzambe na yo ; Ngai nazali Yawe, Nzambe na bino. ");
INSERT INTO lin_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Bosalela bikateli na Ngai mpe botosa mibeko na Ngai, bongo bokowumela na kimia kati na mokili ; ");
INSERT INTO lin_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","mpe mabele ekobota mbuma na yango, bokolia mpe bokotonda mpe bokovanda na kimia. ");
INSERT INTO lin_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Bokoki kotuna : ‘ Tokolia nini na mobu ya sambo soki toloni te mpe tobuki te bambuma na biso ? ’ ");
INSERT INTO lin_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Nakotindela bino mapamboli mingi na mobu ya motoba mpo ete mabele ekoka kobota bambuma mingi oyo bokoki kolia mibu misato. ");
INSERT INTO lin_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Wana bokolona na mobu ya mwambe, bokolia nanu bambuma ya kala mpe bokokoba kolia yango kino bokobuka bambuma ya mobu ya libwa. ");
INSERT INTO lin_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Bokoki te koteka mabele mpo na libela, pamba te mabele ezali ya Ngai, mpe bino bozali bapaya mpe baleki nzela. ");
INSERT INTO lin_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Kati na mokili oyo bokozwa lokola libula, bosengeli kondima ete moto asikola mabele na ye. ");
INSERT INTO lin_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Soki mwana mboka moko kati na bino akomi mobola mpe ateki mabele na ye, moto moko ya libota na ye ya pembeni akoki koya kosikola oyo mwana mboka wana atekaki. ");
INSERT INTO lin_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Soki moto wana azali na ndeko te oyo akoki kosikola yango mpo na ye ; mpe ye moko akomi na bozwi bongo azwi makoki ya kosikola yango ; ");
INSERT INTO lin_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","asengeli kotanga motango ya mibu wuta atekaki mabele na ye mpe akozongisa motuya ya mibu oyo etikali epai ya moto oyo asombaki yango. Boye, akoki kozongela mabele na ye. ");
INSERT INTO lin_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Soki azwaki te makoki ya kosikola yango, mabele oyo atekaki ekotikala na maboko ya moto oyo asombaki yango kino na mobu ya kosepela kokangolama na ye. Ekozala na mobu yango nde mabele na ye ekozongela ye mpe akokoma lisusu nkolo na yango. ");
INSERT INTO lin_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Soki moto ateki ndako kati na engumba oyo bazingela na bamir, azali na makoki ya kosikola yango kaka mpo na mobu moko wuta mokolo oyo atekaki yango. Ezali kaka na tango wana nde akoki kosikola yango. ");
INSERT INTO lin_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Soki asikoli yango te liboso ete mobu mobimba eleka, ndako oyo ezali kati na engumba oyo bazingela na bamir ekotikala libela mpo na moto oyo asombaki yango mpe mpo na bakitani na ye ; bakoki te kozongisa yango na mobu ya kosepela kokangolama. ");
INSERT INTO lin_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Kasi bandako oyo ezali kati na bamboka oyo bazingela te na bamir pembeni-pembeni, ekozala lokola bilanga ya mboka. Bakoki kosikola yango, mpe ekozonga epai na nkolo na yango na mobu ya kosepela kokangolama. ");
INSERT INTO lin_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Balevi bazali tango nyonso na makoki ya kosikola bandako na bango, oyo ezali kati na bingumba ya Balevi. ");
INSERT INTO lin_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Soki Molevi ateki ndako na ye kati na bingumba ya Balevi, moto oyo asombi yango akozongisela ye yango na mobu ya kosepela kokangolama ; pamba te bandako oyo ezali kati na bingumba ya Balevi ezali libula na bango ya libela kati na bana ya Isalaele. ");
INSERT INTO lin_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Kasi bilanga oyo ezali zingazinga ya bingumba ya Balevi, bakoki koteka yango te : ezali libula na bango mpo na libela. ");
INSERT INTO lin_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Soki moto oyo azali pembeni na yo akomi mobola mpe azali lisusu te na makoki ya komisunga ; okosunga ye, azala mopaya to moleki nzela ; mpo ete azala malamu pembeni na yo. ");
INSERT INTO lin_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Okoki te kozwa mileki na maboko na ye ; kasi banga Nzambe na yo, mpo ete mwana mboka na yo akoka kozala malamu pembeni na yo. ");
INSERT INTO lin_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Soki odefisi ye mbongo, okosenga mileki te na oyo odefisi ye ; mpe soki odefisi ye bilei, okosenga te koleka oyo opesi. ");
INSERT INTO lin_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Ngai nazali Yawe, Nzambe na yo, oyo abimisaki yo na Ejipito ; mpo na kopesa yo mokili ya Kanana, mpe na kozala Nzambe na yo. ");
INSERT INTO lin_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Soki ndeko na yo, mwana mboka, akomi mobola mpe amiteki epai na yo, kopesa ye te misala na makasi lokola mowumbu. ");
INSERT INTO lin_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Okozwa ye lokola moto na yo ya mosala to lokola moleki nzela oyo azali kati na bino ; akosalela yo kino na mobu ya kosepela kokangolama ; ");
INSERT INTO lin_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","mpe na sima, akozwa bonsomi elongo na bana na ye, akozonga na etuka na ye mpe akozongela mabele ya batata na ye. ");
INSERT INTO lin_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Pamba te, bana ya Isalaele bazali bawumbu na Ngai, oyo nabimisaki na Ejipito ; bakoki te koteka bango lokola bawumbu. ");
INSERT INTO lin_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Kokonza bango te na makasi, kasi banga Nzambe na yo. ");
INSERT INTO lin_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Okozwa bawumbu na yo ya mibali mpe basi bawumbu na yo kati na bikolo oyo ezingeli yo ; okosomba bango kaka na bikolo yango. ");
INSERT INTO lin_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Okoki mpe kosomba bapaya oyo bazali kovanda kati na mokili na yo, mpe bato ya bituka na bango, oyo babotami kati na mokili na yo ; boye bakokoma bawumbu na yo. ");
INSERT INTO lin_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Okoki kotika bango epai ya bana na yo lokola libula mpo ete sima na yo bakoma bawumbu na bango mpo na libela ; kasi kokonza te na makasi bandeko na yo, bana ya Isalaele. ");
INSERT INTO lin_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Soki mopaya to moleki nzela moko kati na mokili na yo akomi na bozwi mpe moko kati na bandeko na yo, mwana mboka, akomi mobola ; bongo amiteki epai ya mopaya to moleki nzela yango to epai ya moto moko ya libota na ye ; ");
INSERT INTO lin_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","ndeko na yo, mwana mboka, akoki kosikolama sima na ye komiteka : moto moko kati na bandeko na ye akoki kosikola ye. ");
INSERT INTO lin_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Soki ndeko azali te mpo na kosikola ye, tata kulutu to tata leki na ye to bana mibali ya tata kulutu to ya tata leki na ye to ndeko na ye mosusu ya libota ya botata akoki kosikola ye. Nzokande soki akomi na makoki, akoki mpe komisikola ye moko. ");
INSERT INTO lin_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Boye, ye elongo na moto oyo asombaki ye, bakotanga mibu oyo eleki wuta na mobu oyo amitekaki kino na mobu ya kosepela kokangolama ; bakokata motuya ya lisiko na ye kolanda motango ya mibu ndenge ezali lifuti ya moto ya mosala. ");
INSERT INTO lin_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Soki etikali mibu ebele, asengeli kofuta mpo na kosikolama na ye, mbongo kolanda talo oyo basombaki ye. ");
INSERT INTO lin_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Soki etikalaki mibu moke kino na mobu ya kosepela kokangolama, akotanga mibu yango mpe akofuta mpo na lisiko na ye kolanda motango ya mibu oyo etikali. ");
INSERT INTO lin_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Na mibu nyonso oyo akosala epai ya mosombi na ye, bakozwa ye lokola moto ya mosala ; okotika te ete mosombi na ye akonza ye na makasi. ");
INSERT INTO lin_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Ata soki asikolami te na moko kati na banzela oyo, ye elongo na bana na ye basengeli kozwa bonsomi na mobu ya kosepela kokangolama. ");
INSERT INTO lin_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Pamba te, bana ya Isalaele bazali bawumbu na Ngai, oyo nabimisaki na Ejipito. Nazali Yawe, Nzambe na bino. ");
INSERT INTO lin_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Bokosalaka te banzambe ya bikeko to kotelemisa ekeko to likonzi ya bule mpe bokotiaka te kati na mokili na bino ata libanga moko oyo batia bililingi mpo ete bofukamela yango ; pamba te nazali Yawe, Nzambe na bino. ");
INSERT INTO lin_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Bokobatelaka mikolo na Ngai ya Saba mpe bokotosaka Esika na Ngai ya bule. Nazali Yawe. ");
INSERT INTO lin_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Soki botosi mibeko na Ngai, soki botosi mitindo na Ngai mpe bosaleli yango, ");
INSERT INTO lin_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","nakonokisela bino mvula na tango na yango ; mabele mpe banzete ya zamba ekobota bambuma na yango. ");
INSERT INTO lin_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Mosala ya kobeta ble ekowumela kino na tango ya kobuka, mpe tango ya kobuka ekowumela kino na tango ya kolona ; bokolia na kotonda mpe bokovanda na kimia kati na mokili na bino. ");
INSERT INTO lin_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Nakotia kimia kati na mokili, bokolala pongi, mpe moto moko te akotungisa bino ; nakolongola banyama oyo ebomaka kati na mokili mpe bitumba ekozala lisusu te kati na mokili na bino. ");
INSERT INTO lin_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Bokobengana banguna liboso na bino mpe bakokufa na mopanga liboso na bino. ");
INSERT INTO lin_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Bato mitano kati na bino bakolanda bato nkama moko, bato nkama moko kati na bino bakolanda bato nkoto zomi ; mpe banguna na bino bakokufa liboso na bino na mopanga. ");
INSERT INTO lin_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Nakosalela bino ngolu, nakopesa bino mabota nakokomisa bino ebele mpe nakobatela boyokani na Ngai elongo na bino. ");
INSERT INTO lin_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Bambuma ya bilanga na bino ekozala penza ebele mpe ekosala ete bokolia tango molayi bambuma oyo bokozala na yango kati na bibombelo ; kino bokokaba mosusu mpo ete bokotisa bambuma ya sika. ");
INSERT INTO lin_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Nakotia Ndako na Ngai kati na bino mpe nakotombokela bino te. ");
INSERT INTO lin_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Nakotambola kati na bino mpo ete nazala Nzambe na bino mpe bino bozala bato na Ngai. ");
INSERT INTO lin_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Nazali Yawe, Nzambe na bino, oyo abimisaki bino na Ejipito mpo ete bozala lisusu bawumbu kuna te ; nakataki basinga ya bikangiseli na bino mpe nabimisaki bino lokola balongi. ");
INSERT INTO lin_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Soki boboyi kotosa mpe kosalela mibeko wana nyonso, ");
INSERT INTO lin_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","soki bobwaki bikateli na Ngai, mpe soki molimo na bino etombokeli malako na Ngai kino koboya kosalela mibeko na Ngai nyonso mpe kokata boyokani na Ngai, ");
INSERT INTO lin_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","tala ndenge nakosala bino : nakokotisa kati na bino mobulu, libebi, bokono oyo ekoboma bino miso mpe ekobebisa bomoi na bino ; bokolona milona na bino na pamba mpe banguna na bino bakolia yango. ");
INSERT INTO lin_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Nakotombokela bino, mpe bokokweya liboso ya banguna na bino ; ba-oyo bayinaka bino bakokonza bino mpe bokokima ata soki moto moko te azali kolanda bino. ");
INSERT INTO lin_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Soki atako bongo boyoki kaka te, nakopesa bino bitumbu mbala sambo mpo na masumu na bino. ");
INSERT INTO lin_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Nakosilisa makasi na bino, nakokomisa lola makasi lokola ebende mpo na bino, mpe mabele na bino lokola bronze. ");
INSERT INTO lin_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Makasi na bino ekosila na pamba, mpo ete mabele na bino ekobota te mpe banzete ekobota te bambuma na yango. ");
INSERT INTO lin_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Soki botelemeli Ngai mpe boboyi koyoka Ngai, nakopesa bino bitumbu mbala sambo mpo na masumu na bino. ");
INSERT INTO lin_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Nakotinda kati na mokili na bino banyama ya zamba oyo ekoboma bana na bino, ekolia bibwele na bino mpe ekosilisa koboma bino kino banzela na bino ezanga bato. ");
INSERT INTO lin_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Soki bitumbu yango ekoki kaka te mpo na kozongisa bino na nzela, nzokande bokobi kaka koboya kotosa Ngai, ");
INSERT INTO lin_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","Ngai mpe nakotelemela bino mpe nakopesa bino bitumbu mbala sambo mpo na masumu na bino. ");
INSERT INTO lin_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Nakopesa nzela na mopanga mpo ete eboma bino mpo na kozongisa mabe na mabe likolo ya boyokani oyo bino bobebisi. Tango bokosangana kati na bingumba na bino, nakotindela bino bokono oyo ebomaka, mpe nakokaba bino na maboko ya monguna. ");
INSERT INTO lin_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Tango nakopimela bino bilei, basi zomi bakotumba mapa na fulu moko mpe bakobanda kopesa bino mapa yango na kilo : bokolia kasi bokotonda te. ");
INSERT INTO lin_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Soki, atako bongo, boyoki kaka te mpe bokobi kaka kotelemela Ngai, ");
INSERT INTO lin_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","Ngai mpe nakotelemela bino lisusu na kanda makasi mpe nakopesa bino bitumbu mbala sambo mpo na masumu na bino. ");
INSERT INTO lin_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Bokolia bana na bino ya mibali mpe ya basi. ");
INSERT INTO lin_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Nakokweyisa bisambelo na bino ya likolo ya bangomba, nakokweyisa bitumbelo na bino ya malasi, nakotia bibembe na bino likolo ya bibembe ya banzambe na bino ya bikeko mpe nakotombokela bino. ");
INSERT INTO lin_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Nakokomisa bingumba na bino bisobe, nakobebisa bisika na bino ya bule mpe nakosepela te lisusu na solo kitoko ya malasi na bino. ");
INSERT INTO lin_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Ngai moko nakokotisa mobulu kati na mokili, mpe ezala banguna na bino oyo bakoya kovanda kati na yango bakokamwa. ");
INSERT INTO lin_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Nakopanza bino kati na bikolo ya bapaya mpe nakobengana bino na mopanga ; mokili na bino ekozanga bato mpe bingumba na bino ekokawuka. ");
INSERT INTO lin_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Boye, mokili na bino ekosepela Saba na yango mibu nyonso oyo ekozanga bato mpe oyo bokokima epai ya banguna na bino ; ekozwa bopemi mpe ekosepela Saba na yango. ");
INSERT INTO lin_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Na tango nyonso oyo ekozanga bato, ekozwa bopemi oyo ezalaki na yango na tango ya Saba na bino tango bozalaki kovanda kati na yango. ");
INSERT INTO lin_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Bongo na mikili ya banguna na bino, bato oyo bakotikala na bomoi kati na bino, nakolembisa bango nzoto : bakokima ata makelele ya lokasa oyo mopepe eningisi, bakokima lokola nde bazali kokima liboso ya mopanga mpe bakobambana na mabele ata soki moto moko te azali kolanda bango. ");
INSERT INTO lin_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Bakokweya moko likolo ya moninga lokola nde bazali kokima mopanga ata soki moto moko te azali kolanda bango. Bokolonga te liboso ya banguna na bino. ");
INSERT INTO lin_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Bokokufa kati na bikolo ya bapaya mpe mokili ya banguna na bino ekolia bino. ");
INSERT INTO lin_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Kati na mikili ya banguna na bino, bato oyo bakotikala na bomoi kati na bino bakokufa kuna mpo na masumu na bango moko mpe mpo na masumu ya batata na bango. ");
INSERT INTO lin_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Nzokande, soki bakotubela masumu na bango mpe masumu ya batata na bango, misala na bango ya mabe mpe botomboki na bango liboso na Ngai, ");
INSERT INTO lin_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","oyo mpo na yango, Ngai natelemelaki bango mpe namemaki bango na mokili ya banguna na bango, wana mitema na bango oyo ekatama ngenga te ekomikitisa mpe bakozwa lifuti ya mabunga na bango, ");
INSERT INTO lin_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","nakokanisa boyokani na Ngai, oyo nasalaki elongo na Jakobi, na Izaki mpe na Abrayami ; mpe nakokanisa mokili. ");
INSERT INTO lin_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Boye, wana bakotika mokili mpe wana mokili yango ekosepela Saba na yango, na mikolo nyonso oyo yango ekozala ezanga bato, na tango yango, bakozwa lifuti ya mabe na bango mpo ete batosaki mibeko na Ngai te mpe batombokelaki bikateli na Ngai. ");
INSERT INTO lin_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Nzokande, ezala tango bakozala kati na mokili ya banguna na bango, nakosundola bango te, nakotombokela bango te kino kobebisa bango mpe kokata boyokani na Ngai elongo na bango ; pamba te Ngai nazali Yawe, Nzambe na bango. ");
INSERT INTO lin_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Nakokanisa boyokani oyo nasalaki elongo na batata na bango, oyo Ngai nabimisaki na Ejipito, na miso ya bikolo mosusu, mpo ete nazala Nzambe na bango. Nazali Yawe. › » ");
INSERT INTO lin_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Oyo nde bikateli, mitindo mpe mibeko oyo Yawe atiaki kati ya Ye mpe bana ya Isalaele, na ngomba Sinai, na nzela ya Moyize. ");
INSERT INTO lin_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","« Yebisa bana ya Isalaele mpe loba na bango : ‹ Soki moko kati na bino alapi ndayi ya kopesa moto lokola likabo epai na Yawe, asengeli kopesa motuya oyo ekokani na lolenge ya moto na moto. ");
INSERT INTO lin_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Tala motuya ya kopesa kolanda ndenge batangaka mbongo ya bibende kati na Mongombo : mpo na moto oyo mibu na ye ya mbotama ezali kati na mibu tuku mibale mpe tuku motoba, bagrame nkama motoba ya palata mpo na mobali ; ");
INSERT INTO lin_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","bagrame nkama misato na tuku motoba ya palata mpo na mwasi ; ");
INSERT INTO lin_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","mpo na moto oyo mibu na ye ya mbotama ezali kati na mibu mitano mpe tuku mibale, bagrame nkama mibale na tuku minei ya palata mpo na mobali, mpe bagrame nkama moko na tuku mibale ya palata mpo na mwasi ; ");
INSERT INTO lin_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","mpo na moto oyo mikolo ya mbotama na ye ya mbotama ezali kati na sanza moko mpe mibu mitano, bagrame tuku motoba ya palata mpo na mobali, mpe bagrame tuku misato na motoba ya palata mpo na mwasi ; ");
INSERT INTO lin_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","mpo na moto oyo mibu na ye ya mbotama ezali kobanda na tuku motoba mpe komata, bagrame nkama moko na tuku mwambe ya palata mpo na mobali, mpe bagrame nkama moko na tuku mibale ya palata mpo na mwasi. ");
INSERT INTO lin_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Soki moto oyo alapi ndayi azali mobola to azali na makoki te ya kopesa motuya oyo ekatama, akomema epai ya Nganga-Nzambe moto oyo ye alapelaki ndayi ya kopesa lokola likabo. Boye Nganga-Nzambe akokata motuya ya kopesa kolanda makoki ya moto oyo alapi ndayi. ");
INSERT INTO lin_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Soki moko kati na bino alapi ndayi ya kopesa lokola likabo epai na Yawe nyama oyo esengeli, nyama yango ekokoma bule ; ");
INSERT INTO lin_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","asengeli te kobongola to kopesa nyama mosusu na esika ya nyama ya liboso, noki te banyama nyonso mibale ekokoma bule. ");
INSERT INTO lin_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Soki nyama oyo alapelaki ndayi ezali mbindo, nyama oyo esengeli te kopesama lokola likabo epai na Yawe, bakomema nyama yango liboso ya Nganga-Nzambe ");
INSERT INTO lin_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","oyo akotala soki nyama yango ezali malamu to mabe. Motuya nyonso oyo Nganga-nzambe akokata, ekotikala bongo. ");
INSERT INTO lin_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Soki mokolo nyama alingi kosikola yango, asengeli kobakisa eteni moko kati na biteni mitano ya motuya na yango. ");
INSERT INTO lin_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Soki moto abulisi ndako na ye lokola eloko oyo ebulisami mpo na Yawe, Nganga-Nzambe akokata motuya na yango kolanda ndenge ndako yango ezali malamu to mabe. Motuya nyonso oyo Nganga-Nzambe akokata, ekotikala bongo. ");
INSERT INTO lin_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Soki moto oyo abulisi ndako na ye lokola likabo epai na Yawe alingi kosikola yango, asengeli kobakisa eteni moko kati na biteni mitano ya motuya na yango ; mpe ndako yango ekokoma lisusu ya ye. ");
INSERT INTO lin_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Soki moto abulisi mpo na Yawe eteni ya mabele kati na mabele na ye, bakokata motuya ya eteni ya mabele yango kolanda milona oyo bakoki kolona kuna : bagrame nkama motoba ya palata mpo na bakilo nkama minei ya bambuma ya orje. ");
INSERT INTO lin_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Soki abulisi elanga na ye, na mobu ya kosepela kokangolama, motuya oyo bakata ekotikala bongo. ");
INSERT INTO lin_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Kasi soki abulisi elanga na ye epai na Yawe sima na mobu ya kosepela kokangolama, Nganga-Nzambe akokata motuya na yango kolanda motango ya mibu oyo etikali kino na mobu oyo ekolanda, mobu ya kosepela kokangolama. Boye bakokitisa motuya oyo ekatama. ");
INSERT INTO lin_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Soki moto oyo abulisi elanga alingi kosikola yango, akobakisa eteni moko kati na biteni mitano ya motuya oyo ekatama ; boye elanga yango ekokoma lisusu ya ye. ");
INSERT INTO lin_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Kasi soki asikoli yango te, bongo bateki yango epai ya moto mosusu, akoki lisusu kosikola yango te. ");
INSERT INTO lin_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Soki elanga esikolami na mobu ya kosepela kokangolama, ekokoma bule lokola elanga oyo babulisi mpo na Yawe : ekozala mabele ya Banganga-Nzambe. ");
INSERT INTO lin_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Soki moto abulisi epai na Yawe elanga oyo asombaki, nzokande ezali mabele ya libota na bango te, ");
INSERT INTO lin_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","Nganga-Nzambe akokata motuya na yango kolanda mibu oyo etikali kino na mobu ya kosepela kokangolama ; kaka na mokolo oyo Nganga-Nzambe akokata motuya na yango nde moto yango akopesa motuya na yango lokola eloko ya bule epai na Yawe. ");
INSERT INTO lin_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Na mobu ya kosepela kokangolama, elanga yango ekozonga na maboko ya moto oyo atekaki yango : mokolo mabele. ");
INSERT INTO lin_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Mituya nyonso ekokatama ndenge batangaka mbongo ya bibende kati na Mongombo. Mbongo moko ya ebende esengeli kozala na bagrame zomi na mibale. ");
INSERT INTO lin_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Moto moko te akoki kobulisa mwana liboso ya nyama na ye, pamba te mwana ya liboso ezali ya Yawe ; ezala ya ngombe, ya meme to ya ntaba. ");
INSERT INTO lin_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Soki ezali mwana liboso ya nyama moko ya mbindo, mokolo nyama yango akoki kosikola yango na kobakisa eteni moko kati na biteni mitano ya motuya na yango ; kasi soki asikoli yango te, bakoteka yango na motuya oyo ekatama. ");
INSERT INTO lin_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Nyonso oyo moto akopesa epai na Yawe lokola likabo ekoki kotekama te to kosikolama ; ezala moto, nyama to mabele, pamba te nyonso oyo epesami epai na Yawe ezali bule mpo na Yawe. ");
INSERT INTO lin_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Moto moko te oyo abongisami mpo na kobebisama akoki kosikolama, basengeli koboma ye. ");
INSERT INTO lin_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Eteni nyonso ya zomi ya biloko nyonso oyo ekowuta na mabele, ezala bambuma ya bilanga to bambuma ya banzete, ezali ya Yawe : ezali bule mpo na Yawe. ");
INSERT INTO lin_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Soki moto alingi kosikola eteni na ye ya zomi, asengeli kobakisa eteni moko kati na biteni mitano ya motuya na yango. ");
INSERT INTO lin_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Eteni nyonso ya zomi ; ezala ya ngombe, ya meme to ya ntaba, elingi koloba nyama nyonso ya zomi oyo ekoleka na se ya lingenda ya mobateli bibwele, ekozala bule mpo na Yawe ; ");
INSERT INTO lin_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","ezala ya malamu to ya mabe, akoki te kopona nyama mosusu na esika ya nyama oyo ya zomi. Soki atie nyama moko na esika ya nyama mosusu, nyonso mibale ekokoma bule mpo na Yawe ; mpe ekoki kosikolama te. › » ");
INSERT INTO lin_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Oyo nde mitindo oyo Yawe apesaki Moyize, na ngomba Sinai, mpo na bana ya Isalaele.");
INSERT INTO lin_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Kati na esobe ya Sinai, Yawe asololaki na Moyize kati na Ndako ya kapo ya Bokutani ; ezalaki na mokolo ya liboso ya sanza ya mibale, na mobu ya mibale, sima na bango kobima na mokili ya Ejipito. Alobaki na ye : ");
INSERT INTO lin_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","« Tanga motango ya lisanga mobimba ya bana ya Isalaele kolanda mabota na bango mpe bituka na bango ; mpe koma bakombo ya mibali nyonso, moto moko na moko. ");
INSERT INTO lin_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Yo mpe Aron, bokotanga motango ya mibali oyo bazali na mibu tuku mibale mpe koleka, ba-oyo nyonso bazali na makoki ya kosala mosala ya soda kati na Isalaele ; bokotanga bango kolanda milongo na bango ya mampinga. ");
INSERT INTO lin_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Kati na libota moko na moko, ekozala na mobali moko mpo na kosunga bino : asengeli kozala mokambi ya etuka na ye. ");
INSERT INTO lin_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Tala bakombo ya mibali oyo bakosunga bino : mpo na libota ya Ribeni : Elitsuri, mwana mobali ya Shedewuri ; ");
INSERT INTO lin_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","mpo na libota ya Simeoni : Shelumieli, mwana mobali ya Tsurishadayi ; ");
INSERT INTO lin_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","mpo na libota ya Yuda : Nashoni, mwana mobali ya Aminadabi ; ");
INSERT INTO lin_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","mpo na libota ya Isakari : Netaneeli, mwana mobali ya Tsuwari ; ");
INSERT INTO lin_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","mpo na libota ya Zabuloni : Eliabi, mwana mobali ya Eloni ; ");
INSERT INTO lin_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","mpo na bana mibali ya Jozefi : mpo na libota ya Efrayimi : Elishama, mwana mobali ya Amiwudi ; mpo na libota ya Manase : Gamilieli, mwana mobali ya Pedakitsuri ; ");
INSERT INTO lin_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","mpo na libota ya Benjame : Abidani, mwana mobali ya Gideoni ; ");
INSERT INTO lin_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","mpo na libota ya Dani : Akiezeri, mwana mobali ya Amishadayi ; ");
INSERT INTO lin_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","mpo na libota ya Aseri : Pagieli, mwana mobali ya Okirani ; ");
INSERT INTO lin_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","mpo na libota ya Gadi : Eliazafi, mwana mobali ya Deweli ; ");
INSERT INTO lin_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","mpo na libota ya Nefitali : Akira, mwana mobali ya Enani. » ");
INSERT INTO lin_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Ezali bango nde baponamaki kati na lisanga : bazalaki bakambi ya mabota na bango, bakambi ya mampinga ya Isalaele. ");
INSERT INTO lin_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Moyize mpe Aron bakamataki bato oyo baponamaki na bakombo mpo ete basala na bango elongo. ");
INSERT INTO lin_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","Basangisaki lisanga mobimba na mokolo ya liboso, na sanza ya mibale ; boye bana ya Isalaele batalisaki bokoko na bango kolanda mabota na bango mpe bituka na bango. Bakomaki bakombo ya mibali nyonso oyo bazalaki na mibu tuku mibale mpe koleka, mobali moko na moko na kombo na ye, ");
INSERT INTO lin_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","ndenge Yawe atindaki Moyize oyo atangaki motango na bango na esobe ya Sinai. ");
INSERT INTO lin_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Mpo na bakitani ya Ribeni, mwana mobali ya liboso ya Isalaele : bakomaki bakombo ya bato nyonso oyo bazalaki na mibu tuku mibale mpe koleka, oyo bazalaki na makoki ya kosala mosala ya soda, moto na moto kolanda libota na ye mpe etuka na ye. ");
INSERT INTO lin_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Motango na bango nyonso oyo batangamaki kati na libota ya Ribeni ezalaki nkoto tuku minei na motoba na nkama mitano. ");
INSERT INTO lin_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Mpo na bakitani ya Simeoni : bakomaki bakombo ya bato nyonso oyo bazalaki na mibu tuku mibale mpe koleka, oyo bazalaki na makoki ya kosala mosala ya soda, moto na moto kolanda libota na ye mpe etuka na ye. ");
INSERT INTO lin_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Motango na bango nyonso oyo batangamaki kati na libota ya Simeoni ezalaki nkoto tuku mitano na libwa na nkama misato. ");
INSERT INTO lin_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Mpo na bakitani ya Gadi : bakomaki bakombo ya bato nyonso oyo bazalaki na mibu tuku mibale mpe koleka, oyo bazalaki na makoki ya kosala mosala ya soda, moto na moto kolanda libota na ye mpe etuka na ye. ");
INSERT INTO lin_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Motango na bango nyonso oyo batangamaki kati na libota ya Gadi ezalaki nkoto tuku minei na mitano na nkama motoba. ");
INSERT INTO lin_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Mpo na bakitani ya Yuda : bakomaki bakombo ya bato nyonso oyo bazalaki na mibu ya mbotama kobanda tuku mibale mpe koleka, oyo bazalaki na makoki ya kosala mosala ya soda, moto na moto kolanda libota na ye mpe etuka na ye. ");
INSERT INTO lin_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Motango na bango nyonso oyo batangamaki kati na libota ya Yuda ezalaki nkoto tuku sambo na minei na nkama motoba. ");
INSERT INTO lin_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Mpo na bakitani ya Isakari : bakomaki bakombo ya bato nyonso oyo bazalaki na mibu tuku mibale mpe koleka, oyo bazalaki na makoki ya kosala mosala ya soda, moto na moto kolanda libota na ye mpe etuka na ye. ");
INSERT INTO lin_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Motango na bango nyonso oyo batangamaki kati na libota ya Isakari ezalaki nkoto tuku mitano na minei na nkama minei. ");
INSERT INTO lin_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Mpo na bakitani ya Zabuloni : bakomaki bakombo ya bato nyonso oyo bazalaki na mibu tuku mibale mpe koleka, oyo bazalaki na makoki ya kosala mosala ya soda, moto na moto kolanda libota na ye mpe etuka na ye. ");
INSERT INTO lin_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Motango na bango nyonso oyo batangamaki kati na libota ya Zabuloni ezalaki nkoto tuku mitano na sambo na nkama minei. ");
INSERT INTO lin_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Mpo na bana mibali ya Jozefi : Mpo na bakitani ya Efrayimi : bakomaki bakombo ya bato nyonso oyo bazalaki na mibu tuku mibale mpe koleka, oyo bazalaki na makoki ya kosala mosala ya soda, moto na moto kolanda libota na ye mpe etuka na ye. ");
INSERT INTO lin_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Motango na bango nyonso oyo batangamaki kati na libota ya Efrayimi ezalaki nkoto tuku minei na nkama mitano. ");
INSERT INTO lin_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Mpo na bakitani ya Manase : bakomaki bakombo ya bato nyonso oyo bazalaki na mibu tuku mibale mpe koleka, oyo bazalaki na makoki ya kosala mosala ya soda, moto na moto kolanda libota na ye mpe etuka na ye. ");
INSERT INTO lin_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Motango na bango nyonso oyo batangamaki kati na libota ya Manase ezalaki nkoto tuku misato na mibale na nkama mibale. ");
INSERT INTO lin_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Mpo na bakitani ya Benjame : bakomaki bakombo ya bato nyonso oyo bazalaki na mibu tuku mibale mpe koleka, oyo bazalaki na makoki ya kosala mosala ya soda, moto na moto kolanda libota na ye mpe etuka na ye. ");
INSERT INTO lin_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Motango na bango nyonso oyo batangamaki kati na libota ya Benjame ezalaki nkoto tuku misato na mitano na nkama minei. ");
INSERT INTO lin_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Mpo na bakitani ya Dani : bakomaki bakombo ya bato nyonso oyo bazalaki na mibu tuku mibale mpe koleka, oyo bazalaki na makoki ya kosala mosala ya soda, moto na moto kolanda libota na ye mpe etuka na ye. ");
INSERT INTO lin_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Motango na bango nyonso oyo batangamaki kati na libota ya Dani ezalaki nkoto tuku motoba na mibale na nkama sambo. ");
INSERT INTO lin_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Mpo na bakitani ya Aseri : bakomaki bakombo ya bato nyonso oyo bazalaki na mibu tuku mibale mpe koleka, oyo bazalaki na makoki ya kosala mosala ya soda, moto na moto kolanda libota na ye mpe etuka na ye. ");
INSERT INTO lin_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Motango na bango nyonso oyo batangamaki kati na libota ya Aseri ezalaki nkoto tuku minei na moko na nkama mitano. ");
INSERT INTO lin_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Mpo na bakitani ya Nefitali : bakomaki bakombo ya bato nyonso oyo bazalaki na mibu tuku mibale mpe koleka, oyo bazalaki na makoki ya kosala mosala ya soda, moto na moto kolanda libota na ye mpe etuka na ye. ");
INSERT INTO lin_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Motango na bango nyonso oyo batangamaki kati na libota ya Nefitali ezalaki nkoto tuku mitano na misato na nkama minei. ");
INSERT INTO lin_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Bango nde bato oyo Moyize mpe Aron elongo na bakambi zomi na mibale ya Isalaele, oyo moko na moko azalaki kotalisa libota na ye, batangaki. ");
INSERT INTO lin_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Bongo bato nyonso ya Isalaele oyo batangamaki kolanda mabota na bango mpo ete bazalaki na mibu tuku mibale mpe koleka, mpe bazalaki na makoki ya kosala mosala ya soda, ");
INSERT INTO lin_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","bazalaki bango nyonso nkoto nkama motoba na misato na nkama mitano na tuku mitano. ");
INSERT INTO lin_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Nzokande batangaki te nzela moko na mabota mosusu motango ya bato ya libota ya Levi. ");
INSERT INTO lin_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","« Kotanga te motango ya bato ya libota ya Levi, kokotisa bango te na molongo ya bato mosusu ya Isalaele. ");
INSERT INTO lin_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Okopesa na bato ya libota ya Levi mokumba ya Mongombo ya Litatoli mpe ya bisalelo na yango nyonso elongo na biloko nyonso oyo ezalaka kati na Mongombo. Bango bakozwa mokumba ya komemaka yango elongo na bisalelo na yango mpe bakovanda zingazinga na yango. ");
INSERT INTO lin_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Tango nyonso Mongombo ekolongwa na esika moko mpo na kokende na esika mosusu, Balevi nde bakolongola yango ; mpe tango ekotelema, bango mpe kaka nde bakotelemisa yango. Moto mosusu oyo akopusana pembeni na yango asengeli kokufa. ");
INSERT INTO lin_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Bana ya Isalaele bakotelemisa bandako na bango ya kapo kolanda milongo na bango ya mampinga, mpe moto na moto akozala kati na molako na ye, na se ya bendele na ye. ");
INSERT INTO lin_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Kasi bato ya libota ya Levi bakotelemisa bandako na bango ya kapo zingazinga ya Mongombo ya Litatoli mpo ete kanda makasi ya Yawe ekoka kokweya likolo ya lisanga ya bana ya Isalaele te. Bato ya libota ya Levi nde bakosala mosala ya kobatela Mongombo ya Litatoli. » ");
INSERT INTO lin_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Bana ya Isalaele basalaki makambo oyo nyonso, ndenge kaka Yawe atindaki na nzela ya Moyize. ");
INSERT INTO lin_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Yawe alobaki na Moyize mpe Aron : ");
INSERT INTO lin_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","« Bana ya Isalaele bakotelemisa bandako na bango ya kapo kolanda milongo na bango ya mampinga ; moto na moto akozala kati na molako na ye, na se ya bendele na ye, zingazinga ya Ndako ya kapo ya Bokutani, mwa mosika na yango. » ");
INSERT INTO lin_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Na ngambo ya este epai wapi moyi ebimaka, milongo ya mampinga ya Yuda bakotia molako na bango na se ya bendele na bango. Mokambi ya bato ya Yuda ezali Nashoni, mwana mobali ya Aminadabi. ");
INSERT INTO lin_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Mampinga na ye ezali na bato nkoto tuku sambo na minei na nkama motoba. ");
INSERT INTO lin_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Bato ya libota ya Isakari bakotia molako na bango pembeni ya bato ya Yuda. Mokambi ya bato ya Isakari ezali Netaneeli, mwana mobali ya Tsuwari. ");
INSERT INTO lin_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Mampinga na ye ezali na bato nkoto tuku mitano na minei na nkama minei. ");
INSERT INTO lin_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Mpe bato ya libota ya Zabuloni bakozala pembeni ya bato ya libota ya Isakari. Mokambi ya bato ya Zabuloni ezali Eliabi, mwana mobali ya Eloni. ");
INSERT INTO lin_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Mampinga na ye ezali na bato nkoto tuku mitano na sambo na nkama minei. ");
INSERT INTO lin_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Motango nyonso ya bato oyo bazali kati na molako ya Yuda ezali bato nkoto nkama moko na tuku mwambe na motoba na nkama minei kolanda milongo ya mampinga na bango. Bango nde bakozala liboso. ");
INSERT INTO lin_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Na ngambo ya sude, milongo ya mampinga ya Ribeni bakotia molako na bango na se ya bendele na bango. Mokambi ya bato ya Ribeni ezali Elitsuri, mwana mobali ya Shedewuri. ");
INSERT INTO lin_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Mampinga na ye ezali na bato nkoto tuku minei na motoba na nkama mitano. ");
INSERT INTO lin_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Bato ya libota ya Simeoni bakotia molako na bango pembeni ya bato ya Ribeni. Mokambi ya bato ya Simeoni ezali Shelumieli, mwana mobali ya Tsurishadayi. ");
INSERT INTO lin_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Mampinga na ye ezali na bato nkoto tuku mitano na libwa na nkama misato. ");
INSERT INTO lin_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Mpe bato ya libota ya Gadi bakozala pembeni ya bato ya libota ya Simeoni. Mokambi ya bato ya Gadi ezali Eliazafi, mwana mobali ya Deweli. ");
INSERT INTO lin_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Mampinga na ye ezali na bato nkoto tuku minei na mitano na nkama motoba na tuku mitano. ");
INSERT INTO lin_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Motango nyonso ya bato oyo bazali kati na molako ya Ribeni ezali bato nkoto nkama moko na tuku mitano na moko na nkama minei na tuku mitano kolanda milongo ya mampinga na bango. Bango nde bakolanda na sima. ");
INSERT INTO lin_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Bongo Ndako ya kapo ya Bokutani mpe molako ya Balevi ekozala na kati-kati ya milako. Bakokende na molongo ndenge batielaki milako na bango, moko na moko na esika na ye mpe na se ya bendele na ye. ");
INSERT INTO lin_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Na ngambo ya weste, milongo ya mampinga ya Efrayimi bakotia molako na bango na se ya bendele na bango. Mokambi ya bato ya Efrayimi ezali Elishama, mwana mobali ya Amiwudi. ");
INSERT INTO lin_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Mampinga na ye ezali na bato nkoto tuku minei na nkama mitano. ");
INSERT INTO lin_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Bato ya libota ya Manase bakotia molako na bango pembeni ya bato ya Efrayimi. Mokambi ya bato ya Manase ezali Gamilieli, mwana mobali ya Pedakitsuri. ");
INSERT INTO lin_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Mampinga na ye ezali na bato nkoto tuku misato na mibale na nkama mibale. ");
INSERT INTO lin_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Mpe bato ya libota ya Benjame bakozala pembeni ya bato ya libota ya Manase. Mokambi ya bato ya libota ya Benjame ezali Abidani, mwana mobali ya Gideoni. ");
INSERT INTO lin_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Mampinga na ye ezali na bato nkoto tuku misato na mitano na nkama minei. ");
INSERT INTO lin_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Motango nyonso ya bato oyo bazali kati na molako ya Efrayimi ezali bato nkoto nkama moko na mwambe na nkama moko, kolanda milongo ya mampinga na bango. Bango nde bakolanda na molongo ya misato. ");
INSERT INTO lin_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Na ngambo ya nor, milongo ya mampinga ya Dani bakotia molako na bango na se ya bendele na bango. Mokambi ya bato ya Dani ezali Akiezeri, mwana mobali ya Amishadayi. ");
INSERT INTO lin_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Mampinga na ye ezali na bato nkoto tuku motoba na mibale na nkama sambo. ");
INSERT INTO lin_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Bato ya libota ya Aseri bakotia molako na bango pembeni ya bato ya libota ya Dani. Mokambi ya bato ya Aseri ezali Pagieli, mwana mobali ya Okirani. ");
INSERT INTO lin_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Mampinga na ye ezali na bato nkoto tuku minei na moko na nkama mitano. ");
INSERT INTO lin_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Mpe bato ya libota ya Nefitali bakozala pembeni ya bato ya libota ya Aseri. Mokambi ya bato ya Nefitali ezali Akira, mwana mobali ya Enani. ");
INSERT INTO lin_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Mampinga na ye ezali na bato nkoto tuku mitano na misato na nkama minei. ");
INSERT INTO lin_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Motango nyonso ya bato oyo bazali kati na molako ya Dani ezali bato nkoto nkama moko na tuku mitano na sambo na nkama motoba, kolanda milongo ya mampinga na bango. Bango nde bakozala na sima na bango nyonso, na se ya bendele na bango. ");
INSERT INTO lin_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Bango nde bana ya Isalaele oyo batangamaki, kolanda mabota na bango. Motango ya bato nyonso oyo bazalaki kati na milako, kolanda milongo ya mampinga na bango, ezalaki bato nkoto nkama motoba na misato na nkama mitano na tuku mitano. ");
INSERT INTO lin_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Kasi batangaki Balevi te elongo na bato mosusu ya Isalaele, ndenge kaka Yawe atindaki na nzela ya Moyize. ");
INSERT INTO lin_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Boye, bana ya Isalaele basalaki makambo nyonso oyo Yawe atindaki na nzela ya Moyize. Na lolenge wana nde batiaki milako na bango na se ya babendele na bango mpe batambolaki bongo, moto na moto na libota na ye mpe na etuka na ye. ");
INSERT INTO lin_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Tala bakitani ya Aron mpe ya Moyize na tango oyo Yawe asololaki na Moyize, na ngomba Sinai. ");
INSERT INTO lin_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Bakombo ya bana mibali ya Aron ezalaki : Nadabi, mwana ya liboso ; Abiyu, Eleazari mpe Itamari. ");
INSERT INTO lin_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Yango nde bakombo ya bana mibali ya Aron, oyo babulisaki na nzela ya kopakola mafuta mpo na kosala mosala ya bonganga-Nzambe. ");
INSERT INTO lin_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Nadabi mpe Abiyu bakufaki liboso ya Yawe tango bazalaki kobonza mbeka, na nzela ya moto oyo ebulisama te, liboso ya Yawe, na esobe ya Sinai. Batikalaki kozala na bana te. Boye Eleazari mpe Itamari kaka nde batikalaki kosala mosala ya bonganga-Nzambe na bokambami ya tata na bango, Aron. ");
INSERT INTO lin_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","« Yeisa libota ya Levi pene ya Nganga-Nzambe Aron mpe pesa bango na maboko na ye mpo ete basunga ye. ");
INSERT INTO lin_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Bakosalisa ye mpe bakosunga lisanga mobimba liboso ya Ndako ya kapo ya Bokutani, mpo na kosala misala ya Mongombo. ");
INSERT INTO lin_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Bakobatela bisalelo nyonso ya Ndako ya kapo ya Bokutani mpe bakosalisa bana ya Isalaele na nzela ya kosala mosala ya Mongombo. ");
INSERT INTO lin_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Pesa Balevi na maboko ya Aron mpe ya bana na ye ya mibali ; bango nde kati na bana ya Isalaele basengeli komipesa mobimba epai na ye. ");
INSERT INTO lin_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Tia Aron mpe bana na ye ya mibali pembeni mpo ete basala mosala na bango ya Bonganga-Nzambe. Moto mosusu oyo akopusana pene ya Esika ya bule, basengeli koboma ye. » ");
INSERT INTO lin_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Yawe alobaki lisusu na Moyize : ");
INSERT INTO lin_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","« Nakamati Ngai moko Balevi kati na bana ya Isalaele na esika ya bana mibali nyonso ya liboso, mbuma ya liboso ya libumu ya mwasi nyonso ya Isalaele. ");
INSERT INTO lin_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Pamba te, bana nyonso ya liboso bazali ya Ngai. Tango nabomaki bana nyonso ya liboso ya Ejipito, natiaki pembeni bana nyonso ya liboso ya Isalaele mpo ete bazala ya Ngai, ezala bana ya bato to ya banyama. Nazali Yawe. » ");
INSERT INTO lin_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Yawe alobaki na Moyize kati na esobe ya Sinai : ");
INSERT INTO lin_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","« Tanga motango ya Balevi kolanda mabota na bango mpe bituka na bango. Tanga bana mibali nyonso kobanda na ye oyo azali na sanza moko ya mbotama mpe koleka. » ");
INSERT INTO lin_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Boye, Moyize atangaki bango ndenge Yawe atindaki ye. ");
INSERT INTO lin_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Tala bakombo ya bakitani ya Levi : Gerishoni, Keati mpe Merari. ");
INSERT INTO lin_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Tala bakombo ya bakitani ya Gerishoni, kolanda etuka moko na moko : Libini mpe Shimei. ");
INSERT INTO lin_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Bana mibali ya Keati, kolanda etuka moko na moko : Amirami, Yitseari, Ebron mpe Uzieli. ");
INSERT INTO lin_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Bana mibali ya Merari, kolanda etuka moko na moko : Maali mpe Mushi. Bango nde bato ya bituka ya Balevi kolanda mabota na bango. ");
INSERT INTO lin_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Tala bakitani oyo babimelaki na Gerishoni : etuka ya bato ya Libini mpe etuka ya Shimei. Bango nde bato ya bituka ya Gerishoni. ");
INSERT INTO lin_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Motango ya mibali nyonso oyo batangamaki kobanda sanza moko ya mbotama mpe koleka ezalaki nkoto sambo na nkama mitano. ");
INSERT INTO lin_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Bato ya bituka ya Gerishoni batongaki molako na bango na sima ya Mongombo, na ngambo ya weste. ");
INSERT INTO lin_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Eliazafi, mwana mobali ya Laele, nde azalaki mokambi ya libota ya Gerishoni. ");
INSERT INTO lin_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Na Ndako ya kapo ya Bokutani, bakitani ya Gerishoni bazalaki na mokumba ya kobatela Mongombo mpe ndako ya kapo, bizipelo na yango, rido ya ekuke ya Ndako ya kapo ya Bokutani, ");
INSERT INTO lin_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","barido ya lopango, rido ya ekuke ya lopango oyo ezingela Mongombo mpe etumbelo, basinga mpe biloko nyonso oyo bazalaki kosalela na basinga wana. ");
INSERT INTO lin_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Tala bakitani oyo babimelaki na Keati : bituka ya bato ya Amirami, ya Yitseari, ya Ebron mpe ya Uzieli. Bango nde bazalaki bato ya bituka ya Keati. ");
INSERT INTO lin_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Motango ya mibali nyonso oyo bazalaki kobanda na sanza moko ya mbotama mpe koleka ezalaki nkoto mwambe na nkama motoba. Bato ya Keati bazalaki na mokumba ya kobatela Esika ya bule. ");
INSERT INTO lin_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Bato ya bituka ya Keati batongaki molako na bango pembeni ya Mongombo, na ngambo ya sude. ");
INSERT INTO lin_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Elitsafani, mwana mobali ya Uzieli, nde azalaki mokambi ya bato ya bituka ya Keati. ");
INSERT INTO lin_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Bazalaki na mokumba ya kobatela Sanduku, mesa, etelemiselo ya minda, bitumbelo mpe bisalelo ya Esika ya bule oyo basalelaka mosala, rido mpe biloko nyonso oyo bazalaki kosalela. ");
INSERT INTO lin_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Mokambi ya bakambi ya Balevi ezalaki Eleazari, mwana mobali ya Nganga-Nzambe Aron. Aponamaki mpo ete akamba bato oyo bazalaki na mokumba ya kobatela Esika ya bule. ");
INSERT INTO lin_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Tala bakitani oyo babimelaki na Merari : bato ya etuka ya Maali mpe bato ya etuka ya Mushi. Bango nde bazalaki bato ya bituka ya Merari. ");
INSERT INTO lin_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Motango ya mibali nyonso oyo bazalaki na sanza moko ya mbotama mpe koleka, oyo batangamaki ezalaki nkoto motoba na nkama mibale. ");
INSERT INTO lin_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Tsurieli, mwana mobali ya Abiyaili, nde azalaki mokambi ya bato ya bituka ya Merari. Batongaki molako na bango na ngambo ya nor ya Mongombo. ");
INSERT INTO lin_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Bato ya Merari bazalaki na mokumba ya kobatela biloko nyonso ya Mongombo, oyo basala na mabaya : balate na yango, makonzi na yango, makolo na yango mpe biloko nyonso ya mike oyo bazalaki kokangisela yango. ");
INSERT INTO lin_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Bazalaki mpe lisusu na mokumba ya kobatela makonzi oyo ezalaki zingazinga ya lopango, bapike ya Ndako ya kapo mpe basinga na yango. ");
INSERT INTO lin_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Moyize, Aron mpe bana mibali ya Aron batongaki molako na bango na ngambo ya este ya Mongombo, epai wapi moyi ebimaka, etalana na Ndako ya kapo ya Bokutani. Bazalaki na mokumba ya kobatela Esika ya bule mpo na bolamu ya bana ya Isalaele. Moto mosusu oyo akopusana pene ya Esika ya bule, basengeli koboma ye. ");
INSERT INTO lin_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Motango nyonso ya Balevi oyo Moyize mpe Aron batangaki kolanda mitindo ya Yawe, mpe bato ya bituka na bango, mibali nyonso kobanda na sanza moko ya mbotama mpe koleka, ezalaki bato nkoto tuku mibale na mibale. ");
INSERT INTO lin_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Yawe alobaki na Moyize : « Tanga motango ya bana mibali nyonso ya liboso ya bana ya Isalaele, oyo bazali na sanza moko ya mbotama mpe koleka, mpe koma bakombo na bango. ");
INSERT INTO lin_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Okotia Balevi pembeni mpo na Ngai, na esika ya bana nyonso ya liboso ya Isalaele, mpe bibwele nyonso ya Balevi, na esika ya bana ya liboso ya bibwele nyonso ya Isalaele. Nazali Yawe. » ");
INSERT INTO lin_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Boye, Moyize atangaki motango ya bana mibali nyonso ya liboso ya Isalaele ndenge Yawe atindaki ye. ");
INSERT INTO lin_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Motango nyonso ya bana mibali ya liboso, oyo bakomaki bango bakombo, wuta na sanza moko ya mbotama mpe koleka, ezalaki nkoto tuku mibale na mibale na nkama mibale na tuku sambo na misato. ");
INSERT INTO lin_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Yawe alobaki lisusu na Moyize : ");
INSERT INTO lin_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","« Tia Balevi pembeni, na esika ya bana nyonso ya liboso ya Isalaele, mpe bibwele ya Balevi, na esika ya bibwele ya bana ya Isalaele. Balevi bazali ya Ngai. Nazali Yawe. ");
INSERT INTO lin_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Mpo na kosikola bana ya liboso ya Isalaele nkama mibale na tuku sambo na misato oyo baleki na motango ya Balevi, ");
INSERT INTO lin_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","okokongola mbongo ya bibende, nkama mitano, kolanda ndenge batangaka mbongo kati na Esika ya bule, mpo na moto moko na moko. Mbongo moko ya ebende esengeli kozala na bagrame zomi na mibale. ");
INSERT INTO lin_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Okopesa mbongo oyo osikoleli bana mibali nyonso, oyo baleki na motango ya Balevi, epai ya Aron mpe epai ya bana na ye ya mibali. » ");
INSERT INTO lin_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Boye Moyize akongolaki mbongo ya lisiko epai ya bato oyo balekaki na motango ya bana liboso oyo Balevi oyo basikolaki. ");
INSERT INTO lin_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Azwaki na maboko ya bana liboso ya Isalaele mbongo ya bibende nkoto moko na nkama misato na tuku motoba na mitano kolanda ndenge bamekaka kilo kati na Esika ya bule. ");
INSERT INTO lin_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Bongo Moyize apesaki mbongo yango ya lisiko epai ya Aron mpe epai ya bana na ye ya mibali, ndenge kaka Yawe atindaki ye. ");
INSERT INTO lin_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Yawe alobaki na Moyize mpe Aron : ");
INSERT INTO lin_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","« Kati na bana mibali ya Levi, tanga motango ya bakitani ya Keati kolanda bituka mpe mabota na bango. ");
INSERT INTO lin_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Tanga motango ya mibali nyonso oyo bazali na mibu ya mbotama kobanda tuku misato kino tuku mitano, mpo ete baya kosala mosala kati na Ndako ya kapo ya Bokutani. ");
INSERT INTO lin_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Tala mosala ya bato ya Keati kati na Ndako ya kapo ya Bokutani : kobatela biloko oyo eleki bule. ");
INSERT INTO lin_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Tango bakolongola molako, Aron elongo na bana na ye ya mibali bakokota na kati, bakokitisa rido mpe bakozipa na yango Sanduku ya Litatoli. ");
INSERT INTO lin_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Na likolo na yango, bakotia bulangeti oyo esalema na poso ya nyama ya ebale, bakofinika liputa ya langi ya ble mpe bakotia mabaya ya komemela Sanduku ya Litatoli. ");
INSERT INTO lin_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Na likolo ya mesa ya bagato ya bule, bakotanda lisusu liputa ya langi ya ble mpe bakotia na likolo na yango biloko oyo : basani ya mbele, bambeki, bakopo, milangi mpo na makabo ya masanga mpe bagato oyo bakobanda kobonza lokola makabo liboso na Ngai tango nyonso. ");
INSERT INTO lin_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Bongo na likolo ya biloko yango, bakotanda liputa ya langi ya motane makasi, mpe bakozipa biloko wana nyonso na liputa ya makasi basala na poso ya nyama ya ebale. Mpe bakotia balate oyo ekosunga mpo na kotombola mpe komema mesa. ");
INSERT INTO lin_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Bakokamata liputa ya langi ya ble mpe bakofinika na yango etelemiselo ya minda elongo na minda na yango, biloko oyo balongolelaka makala na moto, basani mpo na putulu ya moto mpe basani ya mafuta, oyo basalelaka mosala na mesa. ");
INSERT INTO lin_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Bakosangisa na liboke moko, ezala elamba yango ya langi ya ble mpe biloko na yango nyonso, kati na liputa ya makasi basala na poso ya nyama ya ebale, mpe bakotia yango na likolo ya tsipoyi. ");
INSERT INTO lin_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Bakotanda liputa ya langi ya ble na likolo ya etumbelo ya wolo mpe bakofinika bulangeti basala na poso ya nyama ya ebale ; bongo bakotia balate na yango oyo ekosunga mpo na komema. ");
INSERT INTO lin_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Bakozwa biloko nyonso oyo basalaka na yango kati na Esika ya bule, bakotia yango kati na liputa ya langi ya ble, bakofinika yango bulangeti basala na poso ya nyama ya ebale ; bongo bakotia yango na tsipoyi. ");
INSERT INTO lin_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Sima na bango kolongola putulu ya moto wuta na etumbelo, bakotanda liputa ya langi ya motane na likolo na yango ; ");
INSERT INTO lin_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","bongo bakotia na likolo na yango biloko nyonso oyo basalaka na yango na etumbelo : basani oyo batumbaka na yango ansa, bakanya, bapawu, basani ya minene mpe biloko nyonso oyo basalaka na yango na etumbelo ; bongo bakotanda na likolo ya biloko oyo nyonso, liputa ya makasi basala na poso ya nyama ya ebale, mpe bakotia balate ya etumbelo oyo ekosunga mpo na komema. ");
INSERT INTO lin_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Soki balingi kolongola molako mpo na kokende na esika mosusu, bana mibali ya Keati bakoya komema soki kaka Aron mpe bana na ye ya mibali basilisi kofinika Esika ya bule mpe bisalelo na yango nyonso ; kasi basengeli te kosimba Esika ya bule, noki te bakokufa. Yango wana nde misala ya bana mibali ya Keati kati na Ndako ya kapo ya Bokutani. ");
INSERT INTO lin_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Tala misala ya Eleazari, mwana mobali ya Nganga-Nzambe Aron : kolandela mafuta ya etelemiselo ya minda, ansa ya kozikisa, makabo ya mokolo na mokolo mpe mafuta ya epakolami ; kokengela Mongombo mpe biloko na yango nyonso, ezala Esika ya bule to biloko na yango nyonso. » ");
INSERT INTO lin_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Yawe alobaki na Moyize mpe Aron : ");
INSERT INTO lin_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","« Bolongola te kati na Balevi lisanga ya mabota ya bato ya Keati. ");
INSERT INTO lin_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Tala makambo oyo bosengeli kosala mpo na bango mpo ete bakufa te tango bakopusana pene ya biloko oyo eleki bule : yo, Aron mpe bana na ye ya mibali, bokokota mpe bopesa na moko na moko kati na bango mosala oyo asengeli kosala to eloko oyo asengeli komema. ");
INSERT INTO lin_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Basengeli te kokota bango moko mpo na kotala Esika ya bule, ata mpo na tango moke ; soki te bakokufa. » ");
INSERT INTO lin_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","« Tanga motango ya bato ya Gerishoni kolanda bituka mpe mabota na bango. ");
INSERT INTO lin_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Okotanga mibali nyonso oyo bazali na mibu ya mbotama kobanda tuku misato kino na tuku mitano, ba-oyo bakoki kosala mosala songolo kati na Ndako ya kapo ya Bokutani. ");
INSERT INTO lin_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Tala misala mpe mokumba ya bituka ya bana mibali ya Gerishoni : ");
INSERT INTO lin_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","bakobanda komema batapi ya Mongombo mpe Ndako ya kapo ya Bokutani elongo na elamba na yango, elamba ya makasi basala na poso ya nyama ya ebale mpo na kozipa na likolo, rido ya ekotelo ya Ndako ya kapo ya Bokutani, ");
INSERT INTO lin_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","batapi ya lopango, rido ya ekuke ya lopango, oyo ezingeli Mongombo mpe etumbelo, basinga na yango mpe bisalelo na yango nyonso. Bakosala mosala oyo etali biloko oyo. ");
INSERT INTO lin_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Mosala nyonso ya bato ya Gerishoni ekokambama na Aron mpe bana na ye ya mibali : ezala mpo na komema biloko to mpo na kosala mosala ; bokoyebisa bango mosala nyonso oyo bango basengeli kosala. ");
INSERT INTO lin_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Wana nde misala ya bituka ya bato ya Gerishoni kati na Ndako ya kapo ya Bokutani. Itamari, mwana mobali ya Nganga-Nzambe Aron, nde akokamba misala na bango. ");
INSERT INTO lin_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Okotanga motango ya bato ya Merari, etuka moko na moko mpe libota moko na moko ; ");
INSERT INTO lin_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","okotanga mibali nyonso oyo bazali na mibu ya mbotama kobanda tuku misato kino tuku mitano, ba-oyo bakoki kosala mosala songolo kati na Ndako ya kapo ya Bokutani. ");
INSERT INTO lin_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Tala biteni ya Ndako ya kapo ya Bokutani, oyo bakobanda komema : mabaya ya Mongombo, balate na yango, makonzi mpe makolo na yango, ");
INSERT INTO lin_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","makonzi oyo ezingeli lopango, makolo na yango, bapike na yango, basinga na yango, bisalelo na yango nyonso mpe biloko nyonso oyo esungaka mpo na kokangisa yango. Bokobenga moto moko na moko na kombo mpe bokopesa ye biloko oyo akobanda komema. ");
INSERT INTO lin_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Wana nde misala ya bituka ya bato ya Merari. Itamari, mwana mobali ya Nganga-Nzambe Aron, nde akokamba misala na bango nyonso kati na Ndako ya kapo ya Bokutani. » ");
INSERT INTO lin_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Moyize, Aron mpe bakambi ya lisanga ya Isalaele batangaki motango ya bato ya Keati, kolanda etuka moko na moko mpe libota moko na moko. ");
INSERT INTO lin_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Mibali nyonso oyo bazalaki na mibu ya mbotama kobanda tuku misato kino tuku mitano, ba-oyo bazalaki na makoki ya kosala kati na Ndako ya kapo ya Bokutani, ");
INSERT INTO lin_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","batangamaki kolanda etuka moko na moko : motango na bango ezalaki nkoto mibale na nkama sambo na tuku mitano. ");
INSERT INTO lin_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Wana nde motango ya bato nyonso oyo batangamaki kati na bituka ya bato ya Keati, ba-oyo bazalaki kosala kati na Ndako ya kapo ya Bokutani. Moyize mpe Aron batangaki motango yango kolanda mitindo oyo Yawe apesaki na nzela ya Moyize. ");
INSERT INTO lin_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Batangaki motango ya bato ya Gerishoni kolanda etuka moko na moko mpe libota moko na moko : ");
INSERT INTO lin_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","mibali nyonso oyo bazalaki na mibu ya mbotama kobanda tuku misato kino tuku mitano, ba-oyo bazalaki na makoki ya kosala kati na Ndako ya kapo ya Bokutani, ");
INSERT INTO lin_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","batangamaki kolanda etuka moko na moko mpe libota moko na moko ; motango na bango ezalaki nkoto mibale na nkama motoba na tuku misato. ");
INSERT INTO lin_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Wana nde motango ya bato ya Gerishoni oyo batangamaki mpe bazalaki kosala kati na Ndako ya kapo ya Bokutani. Moyize mpe Aron batangaki bango kolanda mitindo oyo Yawe apesaki na nzela ya Moyize. ");
INSERT INTO lin_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Batangaki motango ya bato ya Merari kolanda etuka moko na moko mpe libota moko na moko : ");
INSERT INTO lin_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","mibali nyonso oyo bazalaki na mibu ya mbotama kobanda tuku misato kino tuku mitano, ba-oyo bazalaki na makoki ya kosala kati na Ndako ya kapo ya Bokutani, ");
INSERT INTO lin_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","batangamaki kolanda etuka moko na moko mpe libota moko na moko ; motango na bango ezalaki nkoto misato na nkama mibale. ");
INSERT INTO lin_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Wana nde motango ya bato oyo batangamaki kati na bituka ya bato ya Merari. Moyize mpe Aron batangaki bango kolanda mitindo oyo Yawe apesaki na nzela ya Moyize. ");
INSERT INTO lin_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Moyize, Aron mpe bakambi ya Isalaele batangaki motango ya Balevi nyonso, kolanda etuka moko na moko mpe libota moko na moko : ");
INSERT INTO lin_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","mibali nyonso oyo bazalaki na mibu ya mbotama kobanda tuku misato kino tuku mitano, ba-oyo bazalaki na makoki ya kosala kati na Ndako ya kapo ya Bokutani, ");
INSERT INTO lin_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","batangamaki ; motango na bango ezalaki nkoto mwambe na nkama mitano na tuku mwambe. ");
INSERT INTO lin_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Moyize apesaki na Molevi moko na moko mosala mpe mokumba, kolanda mitindo ya Yawe. Batangaki bango kolanda mitindo oyo Yawe apesaki na Moyize. ");
INSERT INTO lin_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","« Pesa mitindo epai na bana ya Isalaele ete babimisa libanda ya molako moto nyonso oyo azali na bokono ya poso ya nzoto, moto nyonso oyo atangaka makila, mpe moto nyonso oyo akomi mbindo mpo ete asimbi ebembe. ");
INSERT INTO lin_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Azala mobali to mwasi, bobengana ye, bobimisa ye libanda ya molako mpo ete bakomisa molako na bango mbindo te, pamba te Ngai nazali kowumela elongo na bango. » ");
INSERT INTO lin_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Bana ya Isalaele basalaki bongo ; babimisaki bango libanda ya molako. Basalaki ndenge kaka Yawe atindaki na nzela ya Moyize. ");
INSERT INTO lin_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","« Loba na bana ya Isalaele : ‹ Soki moto, azala mobali to mwasi, atamboli na boyengebene te liboso ya Yawe wana asali moninga na ye mabe, azali na ngambo. ");
INSERT INTO lin_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Boye asengeli koyambola lisumu oyo asalaki. Asengeli kozongisa epai ya moto oyo ye asali mabe : nyonso oyo azwaki mpe akobakisa likolo na yango, ndambo moko kati na mitano. ");
INSERT INTO lin_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Kasi soki moto yango azali na ndeko te oyo akoki kozwa eloko oyo bakozongisa mpo na mabe oyo basalaki ye, bakopesa eloko oyo basengelaki kozongisela ye epai na Yawe na nzela ya Nganga-Nzambe, bakisa meme moko ya mobali oyo Nganga-Nzambe akosala na yango mosala ya bolimbisi masumu mpo na moto oyo asalaki mabe. ");
INSERT INTO lin_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Biloko nyonso kati na makabo ya bule oyo bana ya Isalaele bakomema epai ya Nzambe ekozala ya Nganga-Nzambe. ");
INSERT INTO lin_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Biloko oyo moto nyonso akotia pembeni mpo na Yawe ekopesama epai ya Nganga-Nzambe ; kasi eloko nyonso oyo moto akokabela Nganga-Nzambe ekokoma ya Nganga-Nzambe. › » ");
INSERT INTO lin_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Bongo Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","« Loba na bana ya Isalaele mpe yebisa bango : ‹ Soki mwasi akosi mobali na ye, wana abimi na mobali mosusu ");
INSERT INTO lin_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","mpe asangisi na ye nzoto, amikomisi mbindo atako esalemi na nkuku mpe moto moko te amoni ye ; mpe ezala mobali na ye ayebi eloko te. ");
INSERT INTO lin_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","Soki mobali asali zuwa mpe akomi kokanisa ete mwasi na ye akomi mbindo, azala mbindo to mbindo te, ");
INSERT INTO lin_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","mobali asengeli komema mwasi na ye epai ya Nganga-Nzambe mpe kopesa mpo na ye likabo ya bakilo misato ya farine ya orje ; akosopela yango mafuta te mpe akotia yango ansa te, pamba te ezali likabo oyo epesami mpo na zuwa, likabo mpo na kokanisa mbeba. ");
INSERT INTO lin_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Nganga-Nzambe akobenga mwasi mpe akomema ye liboso ya Yawe. ");
INSERT INTO lin_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Nganga-Nzambe akotoka mayi ya bule, na mbeki basala na mabele batumba mpe akozwa putulu ya mabele ya Mongombo mpo na kotia yango kati na mayi yango. ");
INSERT INTO lin_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Nganga-Nzambe akotia mwasi ya kotelema liboso ya Yawe, akofungola ye suki mpe akotia na maboko na ye likabo ya zuwa, wana ye moko Nganga-Nzambe akobatela na maboko na ye mayi ya bololo oyo ememaka elakeli mabe. ");
INSERT INTO lin_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Nganga-Nzambe akolapisa mwasi yango ndayi, akoloba na ye : ‘ Soki mobali mosusu asangisaki na yo nzoto te, mpe soki omikomisaki mbindo te na kokosa mobali na yo wuta bobalana, wana tika ete mayi oyo ya bololo mpe ememaka elakeli mabe esala yo eloko moko te ! ");
INSERT INTO lin_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Kasi soki, wana ozali ya kobala, okosaki mobali na yo mpe omikomisaki mbindo na kosangisa nzoto na mobali mosusu, ’ ");
INSERT INTO lin_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","Nganga-Nzambe asengeli awa kolapisa mwasi yango ndayi ya kondima kokweyela bilakeli mabe kowuta na maloba oyo : ‘ tika ete Yawe akomisa yo elakeli mabe mpe eloko ya nkele kati na bato na yo ! Tika ete akomisa yo ekomba mpe avimbisa yo libumu ! ");
INSERT INTO lin_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Tika ete mayi oyo ezali komema elakeli mabe ekota kati na yo mpo ete libumu na yo evimba mpe okoma ekomba. ’ Mwasi akozongisa : ‘ Amen ! Tika ete esalema bongo ! ’ ");
INSERT INTO lin_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Nganga-Nzambe akokoma maloba yango ya bilakeli mabe kati na buku mpe akokotisa yango kati na mayi ya bololo mpo na kolongola makomi yango. ");
INSERT INTO lin_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Bongo akomelisa mwasi mayi oyo ya bololo, oyo ezali komema elakeli mabe mpo ete ekokota kati na ye. ");
INSERT INTO lin_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Nganga-Nzambe akozwa wuta na maboko ya mwasi likabo ya zuwa, akotombola yango liboso ya Yawe mpe akomema yango na etumbelo. ");
INSERT INTO lin_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Nganga-Nzambe akotondisa na loboko na ye, bambuma oyo akozwa kati na likabo yango ya zuwa lokola ekaniseli, mpe akotumba yango na likolo ya etumbelo ; sima na yango, akomelisa mwasi mayi. ");
INSERT INTO lin_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Soki penza amikomisaki mbindo na kosangisa nzoto na mobali mosusu, mayi oyo ememaka elakeli mabe ekokota kati na ye, ekovimbisa libumu na ye, akokoma ekomba mpe akolakelama mabe kati na bato na ye. ");
INSERT INTO lin_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Kasi soki mwasi amikomisaki mbindo te, soki azali penza peto, akomona pasi ata moko te mpe akoki kobota bana. ");
INSERT INTO lin_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Wana nde ezali mobeko na tina na zuwa ; ekokanga mwasi ya libala oyo akosi mobali na ye mpe amikomisi mbindo. ");
INSERT INTO lin_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","Bakosalela yango mpe soki mobali asali zuwa mpe akanisi penza ete mwasi na ye abimi na mobali mosusu : mobali akomema mwasi mpe akotelemisa ye liboso ya Yawe ; bongo Nganga-Nzambe akosalela mobeko oyo na mobimba na yango epai ya mwasi. ");
INSERT INTO lin_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Mobali akomema ngambo ata moke te kasi mwasi akozwa etumbu ya lisumu na ye. › » ");
INSERT INTO lin_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","« Yebisa bana ya Isalaele : Mobali to mwasi oyo amibulisi mpo na Yawe na nzela ya ndayi ya libulisi ");
INSERT INTO lin_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","asengeli komipekisa komela vino, masanga oyo elangwisaka, masanga ya ngayi oyo basala na vino mpe masanga ya ngayi oyo basala na masanga mosusu oyo elangwisaka ; asengeli te komela masanga oyo basala na bambuma ya vino ya mayi to ya kokawuka. ");
INSERT INTO lin_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Na mikolo nyonso ya libulisi na ye, asengeli te kolia eloko nyonso oyo basala na bambuma ya vino, kobanda na mokokoli kino na poso. ");
INSERT INTO lin_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Na mikolo nyonso ya ndayi ya libulisi na ye, jileti esengeli te kotutana na moto na ye to basengeli te kokata suki ya moto na ye, kino tango ya libulisi na ye mpo na Yawe ekosila ; akozala bule mpe akotika suki ya moto na ye mpe mandefu na ye kokola. ");
INSERT INTO lin_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Na mikolo nyonso ya libulisi na ye mpo na Yawe, asengeli te kosimba ebembe ; ");
INSERT INTO lin_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","ezala mpo na kufa ya tata na ye, ya mama na ye, ya ndeko na ye ya mobali to ya ndeko na ye ya mwasi, asengeli te komikomisa mbindo ; pamba te na moto na ye, azali na elembo ya libulisi mpo na Nzambe. ");
INSERT INTO lin_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Na mikolo nyonso ya libulisi na ye, akozala bule mpo na Yawe. ");
INSERT INTO lin_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Soki moto akufi na mbalakata pene na ye, moto na ye oyo epesama mpo na libulisi ekokoma mbindo. Bongo asengeli kokatisa suki na ye ya moto mpe mandefu na ye na mokolo ya sambo, mokolo na ye ya kopetolama. ");
INSERT INTO lin_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Na mokolo ya mwambe, asengeli komema epai ya Nganga-Nzambe, na ekotelo ya Ndako ya kapo ya Bokutani : bibenga mibale ya zamba mpe bana mibale ya ebenga ya mboka. ");
INSERT INTO lin_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Nganga-Nzambe akobonza moko lokola mbeka mpo na masumu mpe mosusu, lokola mbeka ya kotumba ; akosala mosala ya bolimbisi masumu na ye lokola asimbaki ebembe. Kaka na mokolo yango, akobulisa lisusu moto na ye epai na Yawe. ");
INSERT INTO lin_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Akokaba lisusu epai na Yawe libulisi na ye mpe akobonza lokola mbeka mpo na kozongisa boyokani, mwana meme ya mobu moko ; pamba te mikolo na ye ya liboso, oyo esilaki koleka, ekotangama lisusu te mpo ete akomaki mbindo. ");
INSERT INTO lin_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Tala mobeko mpo na moto oyo amibulisi mpo na Yawe : ‹ soki mikolo ya libulisi na ye ekoki, basengeli komema ye na ekotelo ya Ndako ya kapo ya Bokutani ");
INSERT INTO lin_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","epai wapi akobonza lokola mbeka mpo na Yawe : mwana meme ya mobu moko mpe ezanga mbeba lokola mbeka ya kotumba ; meme ya mwasi ya mobu moko mpe ezanga mbeba lokola mbeka mpo na masumu ; mpe meme ya mobali mpe ezanga mbeba lokola mbeka mpo na kozongisa boyokani ; ");
INSERT INTO lin_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","kitunga ya mapa ezanga levire mpe basala na farine basangisa na mafuta ; bagalete ezanga levire mpe bapakola mafuta elongo na mbeka ya masanga mpe makabo mosusu. ");
INSERT INTO lin_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Nganga-Nzambe akomema makabo wana nyonso liboso ya Yawe ; akobonza mbeka na ye mpo na masumu mpe mbeka na ye ya kotumba ; ");
INSERT INTO lin_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","akobonza lisusu epai na Yawe meme ya mobali lokola mbeka mpo na kozongisa boyokani, elongo na kitunga ya mapa ezanga levire. Nganga-Nzambe akobakisa na likolo na yango mbeka na ye ya masanga mpe makabo na ye mosusu. ");
INSERT INTO lin_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Bongo moto oyo amipesa na libulisi mpo na Yawe akokata, na ekotelo ya Ndako ya kapo ya Bokutani, suki ya moto na ye mpe ya mandefu na ye ; akolokota yango mpe akobwaka yango na moto oyo ezali kopela na se ya mbeka mpo na kozongisa boyokani. ");
INSERT INTO lin_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Nganga-Nzambe akozwa lipeka ya mbeka ya meme ya mobali tango esili kozika ; akozwa lisusu, kati na kitunga, lipa moko ezanga levire mpe galeti moko ezanga levire, akotia yango na maboko ya moto oyo amipesa na libulisi mpo na Yawe sima na ye kokata suki ya moto na ye mpe mandefu na ye. ");
INSERT INTO lin_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Nganga-Nzambe akobulisa mpe akotombola yango mpo na kopesa yango epai na Yawe, pamba te ezali biloko ya bule mpe ya Nganga-Nzambe, ndenge moko na tolo mpe mopende. ");
INSERT INTO lin_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Wana nde ezali mobeko mpo na moto oyo amibulisi mpo na Yawe, na nzela ya ndayi, elongo na makabo oyo asengeli kobonza epai na Yawe mpo na libulisi na ye. Mpe soki azali na makoki, akoki na ye kopesa makabo mosusu wuta na motema na ye moko. Akokokisa biloko nyonso kolanda ndayi oyo asilaki kolapa mpe mobeko ya libulisi na ye. › » ");
INSERT INTO lin_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","« Loba na Aron mpe na bana na ye ya mibali : ‹ Tala ndenge nini bokobanda kopambola bana ya Isalaele, bokoloba : ");
INSERT INTO lin_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","‘ Tika ete Yawe apambola yo mpe abatela yo ! ");
INSERT INTO lin_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Tika ete Yawe angengisela yo elongi na Ye mpe apesa yo ngolu na Ye ! ");
INSERT INTO lin_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Tika ete Yawe amona yo mpe apesa yo kimia ! ’ › ");
INSERT INTO lin_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Ezali ndenge wana nde bakobanda kobelela Kombo na Ngai mpo na bolamu ya bana ya Isalaele, mpe Ngai nakopambola bango. » ");
INSERT INTO lin_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Na mokolo oyo Moyize asilisaki kotonga Mongombo, asopelaki yango mafuta mpo na kobulisa yango elongo na bisalelo na yango. Asalaki mpe bongo mpo na etumbelo elongo na bisalelo na yango, asopelaki yango mafuta mpo na kobulisa yango. ");
INSERT INTO lin_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Bongo bakambi ya Isalaele, bakonzi ya mabota, elingi koloba bakonzi ya bikolo oyo bakambaki mosala ya kotanga motango ya bato, ");
INSERT INTO lin_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","bamemaki makabo na bango liboso ya Yawe : bashario motoba mpe bangombe zomi na mibale. Shario moko mpo na bakambi mibale, mpe ngombe moko mpo na mokonzi moko na moko ; bamemaki yango liboso ya Mongombo. ");
INSERT INTO lin_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","« Ndima kozwa makabo oyo bayei na yango ; okosala na yango mosala ya Ndako ya kapo ya Bokutani. Okopesa yango epai ya Balevi kolanda mokumba ya moko na moko. » ");
INSERT INTO lin_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Moyize andimaki kozwa bashar mpe bangombe mpe apesaki yango epai ya Balevi. ");
INSERT INTO lin_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Apesaki bashar mibale mpe bangombe minei epai ya bana mibali ya Gerishoni kolanda bosenga ya mosala na bango. ");
INSERT INTO lin_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Apesaki bashar minei mpe bangombe mwambe epai ya bana mibali ya Merari kolanda bosenga ya mosala na bango na bokambami ya Itamari, mwana mobali ya Nganga-Nzambe Aron. ");
INSERT INTO lin_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Apesaki eloko te epai ya bana mibali ya Keati, pamba te bazalaki na mokumba ya komema na mapeka na bango biloko ya bule. ");
INSERT INTO lin_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Bakambi bamemaki makabo na bango mpo na libulisi ya etumbelo, na mokolo oyo basopelaki yango mafuta ; bamemaki makabo yango liboso ya etumbelo. ");
INSERT INTO lin_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Bongo Yawe alobaki na Moyize : « Tika ete mokolo na mokolo, mokambi moko na moko amema likabo na ye mpo na libulisi ya etumbelo ! » ");
INSERT INTO lin_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Na mokolo ya liboso, Nashoni, mwana mobali ya Aminadabi, moto ya libota ya Yuda, amemaki likabo na ye. ");
INSERT INTO lin_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Likabo na ye ezalaki : etando ya palata ya kilo moko na ndambo, mbeki moko ya palata ya bagrame nkama mwambe, kolanda ndenge bamekaka kilo kati na Esika ya bule, nyonso mibale ezalaki ya kotonda na farine basangisa na mafuta mpo na makabo ; ");
INSERT INTO lin_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","mpe mbeki moko ya wolo ya bagrame nkama moko na zomi etonda na ansa, ");
INSERT INTO lin_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","ngombe moko ya mobali, meme moko ya mobali, mwana meme moko ya mobu moko mpo na mbeka ya kotumba, ");
INSERT INTO lin_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","ntaba moko ya mobali lokola mbeka mpo na masumu ; ");
INSERT INTO lin_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","mpe, lokola mbeka mpo na kozongisa boyokani, bangombe mibale ya mibali, bameme mitano ya mibali, bantaba mitano ya mibali mpe bana meme mitano ya mobu moko. Yango nde ezalaki makabo ya Nashoni, mwana mobali ya Aminadabi. ");
INSERT INTO lin_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Na mokolo ya mibale, Netaneeli, mwana mobali ya Tsuwari, mokambi ya libota ya Isakari, ");
INSERT INTO lin_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","amemaki makabo oyo : etando ya palata ya kilo moko na bagrame nkama mitano, mbeki ya palata ya bagrame nkama mwambe, kolanda ndenge bamekaka kilo kati na Esika ya bule, nyonso mibale etonda na farine basangisa na mafuta mpo na makabo, ");
INSERT INTO lin_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","mbeki moko ya wolo ya bagrame nkama moko na zomi etonda na ansa. ");
INSERT INTO lin_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","Amemaki lisusu : mwana ngombe ya mobali, meme moko ya mobali, mwana meme moko ya mobu moko mpo na mbeka ya kotumba, ");
INSERT INTO lin_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","ntaba moko ya mobali lokola mbeka mpo na masumu ; ");
INSERT INTO lin_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","mpe, lokola mbeka mpo na kozongisa boyokani, bangombe mibale ya mibali, bameme mitano ya mibali, bantaba mitano ya mibali mpe bana meme mitano ya mobu moko. Yango nde ezalaki makabo ya Netaneeli, mwana mobali ya Tsuwari. ");
INSERT INTO lin_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Na mokolo ya misato, Eliabi, mwana mobali ya Eloni, mokambi ya libota ya Zabuloni, ");
INSERT INTO lin_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","amemaki makabo oyo : etando ya palata ya kilo moko na bagrame nkama mitano, mbeki ya palata ya bagrame nkama mwambe, kolanda ndenge bamekaka kilo kati na Esika ya bule, nyonso mibale etonda na farine basangisa na mafuta mpo na makabo, ");
INSERT INTO lin_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","mbeki moko ya wolo ya bagrame nkama moko na zomi etonda na ansa. ");
INSERT INTO lin_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","Amemaki lisusu : mwana ngombe ya mobali, meme moko ya mobali, mwana meme moko ya mobu moko mpo na mbeka ya kotumba, ");
INSERT INTO lin_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","ntaba moko ya mobali lokola mbeka mpo na masumu ; ");
INSERT INTO lin_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","mpe, lokola mbeka mpo na kozongisa boyokani, bangombe mibale ya mibali, bameme mitano ya mibali, bantaba mitano ya mibali mpe bana meme mitano ya mobu moko. Yango nde ezalaki makabo ya Eliabi, mwana mobali ya Eloni. ");
INSERT INTO lin_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Na mokolo ya minei, Elitsuri, mwana mobali ya Shedewuri, mokambi ya libota ya Ribeni, ");
INSERT INTO lin_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","amemaki makabo oyo : etando ya palata ya kilo moko na bagrame nkama mitano, mbeki ya palata ya bagrame nkama mwambe, kolanda ndenge bamekaka kilo kati na Esika ya bule, nyonso mibale etonda na farine basangisa na mafuta mpo na makabo, ");
INSERT INTO lin_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","mbeki moko ya wolo ya bagrame nkama moko na zomi etonda na ansa. ");
INSERT INTO lin_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","Amemaki lisusu : mwana ngombe ya mobali, meme moko ya mobali, mwana meme moko ya mobu moko mpo na mbeka ya kotumba, ");
INSERT INTO lin_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","ntaba moko ya mobali lokola mbeka mpo na masumu ; ");
INSERT INTO lin_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","mpe, lokola mbeka mpo na kozongisa boyokani, bangombe mibale ya mibali, bameme mitano ya mibali, bantaba mitano ya mibali mpe bana meme mitano ya mobu moko. Yango nde ezalaki makabo ya Elitsuri, mwana mobali ya Shedewuri. ");
INSERT INTO lin_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Na mokolo ya mitano, Shelumieli, mwana mobali ya Tsurishadayi, mokambi ya libota ya Simeoni, ");
INSERT INTO lin_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","amemaki makabo oyo : etando ya palata ya kilo moko na bagrame nkama mitano, mbeki ya palata ya bagrame nkama mwambe, kolanda ndenge bamekaka kilo kati na Esika ya bule, nyonso mibale etonda na farine basangisa na mafuta mpo na makabo, ");
INSERT INTO lin_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","mbeki moko ya wolo ya bagrame nkama moko na zomi etonda na ansa. ");
INSERT INTO lin_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","Amemaki lisusu : mwana ngombe ya mobali, meme moko ya mobali, mwana meme moko ya mobu moko mpo na mbeka ya kotumba, ");
INSERT INTO lin_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","ntaba moko ya mobali lokola mbeka mpo na masumu ; ");
INSERT INTO lin_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","mpe, lokola mbeka mpo na kozongisa boyokani : bangombe mibale ya mibali, bameme mitano ya mibali, bantaba mitano ya mibali mpe bana meme mitano ya mobu moko. Wana nde ezalaki makabo ya Shelumieli, mwana mobali ya Tsurishadayi. ");
INSERT INTO lin_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Na mokolo ya motoba, Eliazafi, mwana mobali ya Deweli, mokambi ya libota ya Gadi, ");
INSERT INTO lin_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","amemaki makabo oyo : etando ya palata ya kilo moko na bagrame nkama mitano, mbeki ya palata ya bagrame nkama mwambe, kolanda ndenge bamekaka kilo kati na Esika ya bule, nyonso mibale etonda na farine basangisa na mafuta mpo na makabo, ");
INSERT INTO lin_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","mbeki moko ya wolo ya bagrame nkama moko na zomi etonda na ansa. ");
INSERT INTO lin_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","Amemaki lisusu : mwana ngombe ya mobali, meme moko ya mobali, mwana meme moko ya mobu moko mpo na mbeka ya kotumba, ");
INSERT INTO lin_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","ntaba moko ya mobali lokola mbeka mpo na masumu ; ");
INSERT INTO lin_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","mpe, lokola mbeka mpo na kozongisa boyokani, bangombe mibale ya mibali, bameme mitano ya mibali, bantaba mitano ya mibali mpe bana meme mitano ya mobu moko. Yango nde ezalaki makabo ya Eliazafi, mwana mobali ya Deweli. ");
INSERT INTO lin_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Na mokolo ya sambo, Elishama, mwana mobali ya Amiwudi, mokambi ya libota ya Efrayimi, ");
INSERT INTO lin_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","amemaki makabo oyo : etando ya palata ya kilo moko na bagrame nkama mitano, mbeki ya palata ya bagrame nkama mwambe, kolanda ndenge bamekaka kilo kati na Esika ya bule, nyonso mibale etonda na farine basangisa na mafuta mpo na makabo, ");
INSERT INTO lin_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","mbeki moko ya wolo ya bagrame nkama moko na zomi etonda na ansa. ");
INSERT INTO lin_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","Amemaki lisusu : mwana ngombe ya mobali, meme moko ya mobali, mwana meme moko ya mobu moko mpo na mbeka ya kotumba, ");
INSERT INTO lin_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","ntaba moko ya mobali lokola mbeka mpo na masumu ; ");
INSERT INTO lin_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","mpe, lokola mbeka mpo na kozongisa boyokani, bangombe mibale ya mibali, bameme mitano ya mibali, bantaba mitano ya mibali mpe bana meme mitano ya mobu moko. Yango nde ezalaki makabo ya Elishama, mwana mobali ya Amiwudi. ");
INSERT INTO lin_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Na mokolo ya mwambe, Gamilieli, mwana mobali ya Pedakitsuri, mokambi ya libota ya Manase, ");
INSERT INTO lin_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","amemaki makabo oyo : etando ya palata ya kilo moko na bagrame nkama mitano, mbeki ya palata ya bagrame nkama mwambe, kolanda ndenge bamekaka kilo kati na Esika ya bule, nyonso mibale etonda na farine basangisa na mafuta mpo na makabo, ");
INSERT INTO lin_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","mbeki moko ya wolo ya bagrame nkama moko na zomi etonda na ansa. ");
INSERT INTO lin_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","Amemaki lisusu : mwana ngombe ya mobali, meme moko ya mobali, mwana meme moko ya mobu moko mpo na mbeka ya kotumba, ");
INSERT INTO lin_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","ntaba moko ya mobali lokola mbeka mpo na masumu ; ");
INSERT INTO lin_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","mpe, lokola mbeka mpo na kozongisa boyokani, bangombe mibale ya mibali, bameme mitano ya mibali, bantaba mitano ya mibali mpe bana meme mitano ya mobu moko. Yango nde ezalaki makabo ya Gamilieli, mwana mobali ya Pedakitsuri. ");
INSERT INTO lin_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Na mokolo ya libwa, Abidani, mwana mobali ya Gideoni, mokambi ya libota ya Benjame, ");
INSERT INTO lin_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","amemaki makabo oyo : etando ya palata ya kilo moko na bagrame nkama mitano, mbeki ya palata ya bagrame nkama mwambe, kolanda ndenge bamekaka kilo kati na Esika ya bule, nyonso mibale etonda na farine basangisa na mafuta mpo na makabo, ");
INSERT INTO lin_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","mbeki moko ya wolo ya bagrame nkama moko na zomi etonda na ansa. ");
INSERT INTO lin_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","Amemaki lisusu : mwana ngombe ya mobali, meme moko ya mobali, mwana meme moko ya mobu moko mpo na mbeka ya kotumba, ");
INSERT INTO lin_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","ntaba moko ya mobali lokola mbeka mpo na masumu ; ");
INSERT INTO lin_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","mpe, lokola mbeka mpo na kozongisa boyokani, bangombe mibale ya mibali, bameme mitano ya mibali, bantaba mitano ya mibali mpe bana meme mitano ya mobu moko. Yango nde ezalaki makabo ya Abidani, mwana mobali ya Gideoni. ");
INSERT INTO lin_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Na mokolo ya zomi, Akiezeri, mwana mobali ya Amishadayi, mokambi ya libota ya Dani, ");
INSERT INTO lin_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","amemaki makabo oyo : etando ya palata ya kilo moko na bagrame nkama mitano, mbeki ya palata ya bagrame nkama mwambe, kolanda ndenge bamekaka kilo kati na Esika ya bule, nyonso mibale etonda na farine basangisa na mafuta mpo na makabo, ");
INSERT INTO lin_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","mbeki moko ya wolo ya bagrame nkama moko na zomi etonda na ansa. ");
INSERT INTO lin_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","Amemaki lisusu : mwana ngombe ya mobali, meme moko ya mobali, mwana meme moko ya mobu moko mpo na mbeka ya kotumba, ");
INSERT INTO lin_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","ntaba moko ya mobali lokola mbeka mpo na masumu ; ");
INSERT INTO lin_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","mpe, lokola mbeka mpo na kozongisa boyokani, bangombe mibale ya mibali, bameme mitano ya mibali, bantaba mitano ya mibali mpe bana meme mitano ya mobu moko. Yango nde ezalaki makabo ya Akiezeri, mwana mobali ya Amishadayi. ");
INSERT INTO lin_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Na mokolo ya zomi na moko, Pagieli, mwana mobali ya Okirani, mokambi ya libota ya Aseri, ");
INSERT INTO lin_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","amemaki makabo oyo : etando ya palata ya kilo moko na bagrame nkama mitano, mbeki ya palata ya bagrame nkama mwambe, kolanda ndenge bamekaka kilo kati na Esika ya bule, nyonso mibale etonda na farine basangisa na mafuta mpo na makabo, ");
INSERT INTO lin_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","mbeki moko ya wolo ya bagrame nkama moko na zomi etonda na ansa. ");
INSERT INTO lin_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","Amemaki lisusu : mwana ngombe ya mobali, meme moko ya mobali, mwana meme moko ya mobu moko mpo na mbeka ya kotumba, ");
INSERT INTO lin_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","ntaba moko ya mobali lokola mbeka mpo na masumu ; ");
INSERT INTO lin_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","mpe, lokola mbeka mpo na kozongisa boyokani, bangombe mibale ya mibali, bameme mitano ya mibali, bantaba mitano ya mibali mpe bana meme mitano ya mobu moko. Yango nde ezalaki makabo ya Pagieli, mwana mobali ya Okirani. ");
INSERT INTO lin_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Na mokolo ya zomi na mibale, Akira, mwana mobali ya Enani, mokambi ya libota ya Nefitali, ");
INSERT INTO lin_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","amemaki makabo oyo : etando ya palata ya kilo moko na bagrame nkama mitano, mbeki ya palata ya bagrame nkama mwambe, kolanda ndenge bamekaka kilo kati na Esika ya bule, nyonso mibale etonda na farine basangisa na mafuta mpo na makabo, ");
INSERT INTO lin_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","mbeki moko ya wolo ya bagrame nkama moko na zomi etonda na ansa. ");
INSERT INTO lin_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","Amemaki lisusu : mwana ngombe ya mobali, meme moko ya mobali, mwana meme moko ya mobu moko mpo na mbeka ya kotumba, ");
INSERT INTO lin_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","ntaba moko ya mobali lokola mbeka mpo na masumu ; ");
INSERT INTO lin_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","mpe, lokola mbeka mpo na kozongisa boyokani, bangombe mibale ya mibali, bameme mitano ya mibali, bantaba mitano ya mibali mpe bana meme mitano ya mobu moko. Yango nde ezalaki makabo ya Akira, mwana mobali ya Enani. ");
INSERT INTO lin_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Yango nde ezalaki makabo ya bakambi ya Isalaele mpo na libulisi ya etumbelo, na mokolo oyo basopelaki yango mafuta. Na kosangisa, bango nyonso bapesaki : bitando ya palata zomi na mibale, bambeki ya palata zomi na mibale, bambeki ya wolo zomi na mibale. ");
INSERT INTO lin_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Etando moko na moko ya palata ezalaki ya kilo moko na bagrame nkama mitano, mpe mbeki moko na moko ezalaki ya bagrame nkama mwambe : palata nyonso esalaki bakilo tuku mibale na sambo na bagrame nkama mitano, kolanda ndenge bazalaki komeka bakilo na Esika ya bule. ");
INSERT INTO lin_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Mbeki moko na moko ya wolo ezalaki ya bagrame nkama moko na zomi : wolo nyonso esalaki bagrame nkoto moko na nkama misato. ");
INSERT INTO lin_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Mpo na bambeka ya kotumba, bango nyonso bapesaki : bangombe zomi na mibale ya mibali, bameme zomi na mibale ya mibali, bana meme zomi na mibale ya mobu moko elongo na makabo mosusu mpe bantaba zomi na mibale lokola mbeka mpo na masumu. ");
INSERT INTO lin_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Na kosangisa, bango nyonso bapesaki lokola mbeka mpo na kozongisa boyokani : bangombe tuku mibale na minei ya mibali, bameme tuku motoba ya mibali, bantaba tuku motoba ya mibali, bana meme tuku motoba ya mobu moko. Yango nde ezalaki makabo ya libulisi ya etumbelo sima na kosopela yango mafuta. ");
INSERT INTO lin_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Tango Moyize azalaki kokota na Ndako ya kapo ya Bokutani mpo na kosolola na Yawe, azalaki koyoka mongongo koloba na ye wuta na mofinuku oyo ezalaki likolo ya Sanduku ya Litatoli kati na basheribe mibale, mpe azalaki kosolola na ye. ");
INSERT INTO lin_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","« Loba na Aron mpe yebisa ye : ‹ Tango okotia minda, minda sambo esengeli kongengisa liboso ya etelemiselo ya minda. › » ");
INSERT INTO lin_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Aron asalaki kaka bongo : atiaki minda na liboso ya etelemiselo ya minda ndenge Yawe atindaki na nzela ya Moyize. ");
INSERT INTO lin_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Tala ndenge basalaki etelemiselo ya minda : basalaki yango na wolo batuta wuta na likonzi kino na bafololo na yango ; basalaki yango ndenge kaka Yawe alakisaki Moyize. ");
INSERT INTO lin_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","« Kamata Balevi kati na bana ya Isalaele mpe petola bango. ");
INSERT INTO lin_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Tala ndenge okosala mpo na kopetola bango : okobwakela bango mayi ya bopetoli ; bongo bakolekisa jileti na nzoto na bango mobimba mpo na komikokola suki ya nzoto mobimba mpe bakosukola bilamba na bango. Ezali na nzela wana nde bakokoma peto. ");
INSERT INTO lin_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Bakokamata mwana ngombe ya mobali elongo na likabo na yango ya farine oyo basangisa na mafuta ; mpe okokamata mwana ngombe mosusu ya mobali mpo na mbeka ya masumu. ");
INSERT INTO lin_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Yeisa Balevi liboso ya Ndako ya kapo ya Bokutani mpe sangisa lisanga mobimba ya Isalaele. ");
INSERT INTO lin_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Okopusa Balevi liboso ya Yawe mpe bana ya Isalaele bakotia bango maboko. ");
INSERT INTO lin_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Sima na yango, Aron akobonza Balevi lokola likabo oyo bana ya Isalaele babonzeli Yawe mpo ete bazwa makoki ya kosala mosala ya Yawe. ");
INSERT INTO lin_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Mpe na sima, Balevi bakotia maboko na bango likolo ya mito ya bangombe ya mibali. Bonza ngombe moko lokola mbeka ya masumu epai na Yawe mpe mosusu lokola mbeka ya kotumba, mpo na kosala mosala ya bolimbisi masumu mpo na Balevi. ");
INSERT INTO lin_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Tika ete Balevi batelema liboso ya Aron mpe ya bana na ye ya mibali ; bongo bonza bango lokola likabo epai na Yawe. ");
INSERT INTO lin_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Ezali na nzela wana nde okotia pembeni Balevi kati na bana ya Isalaele, mpe bakozala ya Ngai. ");
INSERT INTO lin_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Sima na yo kopetola Balevi mpe kobonza bango lokola likabo, bakozwa ndingisa ya kosala mosala na bango na Ndako ya kapo ya Bokutani. Boye, okopetola bango mpe okobonza bango lokola likabo epai na Yawe, ");
INSERT INTO lin_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","pamba te bango nde bazali bato oyo bapesameli Ngai kati na bana ya Isalaele. Ngai moko nde nazwaki bango na esika ya bana nyonso ya liboso ya bana ya Isalaele. ");
INSERT INTO lin_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Pamba te, bana nyonso ya liboso ya bana ya Isalaele bazali ya Ngai, ezala bana ya liboso ya bana ya bato to ya banyama. Tango nabomaki bana nyonso ya liboso na mokili ya Ejipito, natiaki bango pembeni mpo na Ngai moko. ");
INSERT INTO lin_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Mpe nazwaki Balevi na esika ya bana nyonso ya liboso ya bana ya Isalaele. ");
INSERT INTO lin_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Kati na bato nyonso ya Isalaele, napesi Balevi lokola likabo epai ya Aron mpe ya bana na ye ya mibali, mpo ete basala mosala kati na Ndako ya kapo ya Bokutani mpo na bolamu ya bana ya Isalaele mpe basala mosala ya bolimbisi masumu mpo na bango, mpo ete likama moko te ekomela bana ya Isalaele tango bakopusana pene ya Esika ya bule. » ");
INSERT INTO lin_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Moyize, Aron mpe lisanga mobimba ya bana ya Isalaele basalaki mpo na Balevi, makambo nyonso oyo Yawe atindaki Moyize. ");
INSERT INTO lin_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Balevi bamipetolaki mpe basukolaki bilamba na bango. Aron abonzaki bango lokola likabo epai na Yawe mpe asalaki mpo na bango mosala ya bolimbisi masumu mpo na kopetola bango. ");
INSERT INTO lin_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Sima na yango, Balevi bazwaki ndingisa ya kosala mosala na bango na Ndako ya kapo ya Bokutani, na se ya bokonzi ya Aron mpe ya bana na ye ya mibali. Basalaki mpo na Balevi, makambo oyo Yawe atindaki na nzela ya Moyize. ");
INSERT INTO lin_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","« Tala bikateli oyo etali Balevi : mobali nyonso oyo azali na mibu ya mbotama kobanda tuku mibale na mitano mpe koleka asengeli koya kosala mosala kati na Ndako ya kapo ya Bokutani. ");
INSERT INTO lin_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Kasi soki akokisi mibu tuku mitano, akotika mosala oyo azalaki kosala, akosala lisusu mosala te. ");
INSERT INTO lin_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Akokoma nde kosunga bandeko na ye mpo na kokokisa misala na bango kati na Ndako ya kapo ya Bokutani. Nzokande ye moko akosala lisusu mosala te. Yango nde ekozala bikateli oyo okolanda mpo na mosala ya Balevi. » ");
INSERT INTO lin_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Yawe alobaki na Moyize kati na esobe ya Sinai, na sanza ya liboso ya mobu oyo ya mibale sima na kobima na bango na Ejipito. Alobaki na ye : ");
INSERT INTO lin_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","« Tika ete bana ya Isalaele basepela feti ya Pasika na mokolo oyo ekatama. ");
INSERT INTO lin_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Bosala feti yango na tango oyo ekatama, na pokwa ya mokolo ya zomi na minei, ya sanza oyo, kolanda mibeko mpe malako na yango nyonso. » ");
INSERT INTO lin_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Boye, Moyize ayebisaki bana ya Isalaele ete basepelaka feti ya Pasika. ");
INSERT INTO lin_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Basepelaki Pasika kati na esobe ya Sinai, na pokwa ya mokolo ya zomi na minei, ya sanza ya liboso. Bana ya Isalaele basalaki makambo nyonso ndenge kaka Yawe apesaki mitindo na nzela ya Moyize. ");
INSERT INTO lin_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Kasi bato mosusu kati na bango basepelaki Pasika te na mokolo wana, pamba te bazalaki mbindo mpo ete basimbaki ebembe. Boye, kaka na mokolo wana, bakendeki komona Moyize na Aron ");
INSERT INTO lin_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","mpe bayebisaki Moyize : — Tokomi mbindo mpo ete tosimbaki ebembe. Boye, mpo na nini te biso mpe tomema likabo na biso epai na Yawe elongo na bato mosusu ya Isalaele ? ");
INSERT INTO lin_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Moyize azongiselaki bango : — Bozela nanu ete naluka koyeba makambo oyo Yawe atindi na tina na bino. ");
INSERT INTO lin_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Boye Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","— Yebisa bana ya Isalaele : « Soki moko kati na bino to kati na bakitani na bino akomi mbindo mpo ete asimbi ebembe na mokolo wana, ezala soki azali mosika na mobembo, akoki kosepela feti ya Pasika mpo na lokumu na Yawe. ");
INSERT INTO lin_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Basengeli kosepela yango na pokwa ya mokolo ya zomi na minei ya sanza ya mibale ; bakolia mwana meme elongo na mapa ezanga levire mpe matiti ya bololo. ");
INSERT INTO lin_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Bakotika eloko moko te kino na tongo mpe bakobuka mokuwa ata moko te. Basengeli kolanda mibeko na yango nyonso na tango ya kosepela feti ya Pasika. ");
INSERT INTO lin_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Kasi soki moto moko asepeli feti ya Pasika te, wana azali mbindo te mpe asali mobembo te, basengeli kolongola ye kati na libota na ye, pamba te abonzeli Yawe likabo te na tango oyo ekatama ; akomema mikumba ya masumu na ye. ");
INSERT INTO lin_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Soki mpe mopaya oyo avandi kati na bino alingi kosepela Pasika ya Yawe, asengeli kosala kaka bongo, asengeli kolanda mibeko mpe malako na yango. Ezala mpo na bapaya to mpo na bana mboka, bosengeli kozala na mibeko ya losambo ya ndenge moko. » ");
INSERT INTO lin_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Na mokolo oyo batelemisaki Mongombo, lipata ezipaki Ndako ya kapo ya Litatoli. Wuta na pokwa kino na tongo, lipata oyo ezalaki likolo ya Mongombo ezalaki komonana lokola moto. ");
INSERT INTO lin_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Mpe ekobaki kozala kaka ndenge wana : lipata ezalaki kozipa Mongombo ; bongo na butu, ezalaki komonana lokola moto. ");
INSERT INTO lin_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Tango nyonso lipata ezalaki kolongwa na likolo ya Ndako ya kapo, bana ya Isalaele mpe bazalaki kokende ; mpe esika nyonso oyo lipata ezalaki kotelema, esika wana nde bazalaki mpe kosala molako na bango. ");
INSERT INTO lin_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Ezalaki na mitindo na Yawe kaka nde bana ya Isalaele bazalaki kotambola mpe kosala molako na bango. Tango nyonso lipata ezalaki kowumela na likolo ya Mongombo, bango mpe bazalaki kowumela na molako. ");
INSERT INTO lin_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Soki lipata ewumeli tango molayi likolo ya Mongombo, bana ya Isalaele bazalaki kotosa mitindo na Yawe mpe bazalaki kokende te. ");
INSERT INTO lin_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Soki mpe lipata esali kaka mwa ndambo ya mikolo na likolo ya Mongombo, na mitindo na Yawe, bazalaki kowumela na molako na bango ; mpe bazalaki kokende soki kaka Yawe apesi mitindo. ");
INSERT INTO lin_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Na mbala mosusu, lipata ezalaki kowumela butu moko kaka, wuta na pokwa kino na tongo ; bongo tango ezalaki kolongwa na tongo na esika moko mpo na kokende na esika mosusu, bango mpe bazalaki kokende. To mpe ezalaki kosala mokolo moko mpe butu moko ; mpe soki elongwe, bango mpe bazalaki kokende. ");
INSERT INTO lin_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Soki lipata etelemi na likolo ya Mongombo mikolo mibale to sanza moko to mpe mobu moko, bana ya Isalaele mpe bazalaki kaka kowumela na molako, bazalaki kokende te ; kasi soki elongwe, bango mpe bazalaki kokende. ");
INSERT INTO lin_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Ezalaki kaka na mitindo na Yawe nde bazalaki kowumela na molako to kokende. Boye, bazalaki kosala mosala ya Yawe kolanda mitindo oyo Yawe apesaki na nzela ya Moyize. ");
INSERT INTO lin_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","« Sala bakelelo mibale na palata oyo batuta. Okosalela yango mpo na kobengisa lisanga mpe mpo na kopesa mitindo ya kolongola molako. ");
INSERT INTO lin_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Soki bakelelo nyonso mibale ebeti nzela moko, lisanga mobimba ekosangana pembeni na yo, na ekotelo ya Ndako ya kapo ya Bokutani. ");
INSERT INTO lin_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Soki kelelo moko kaka nde ebeti, kaka bakambi, bakonzi ya bituka ya Isalaele nde bakosangana liboso na yo. ");
INSERT INTO lin_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Soki kelelo ebeti makasi, mabota oyo etongi molako na ngambo ya este ekokende. ");
INSERT INTO lin_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Soki ebeti makasi mpo na mbala ya mibale, mabota oyo etongi molako na ngambo ya sude ekokende. Ebeteli ya kelelo nde ekozala elembo mpo na kopesa mbela ya kokende. ");
INSERT INTO lin_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Mpo na kosangisa lisanga, beta bakelelo, kasi makasi te. ");
INSERT INTO lin_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Bana mibali ya Aron, Banganga-Nzambe, bango nde bakobanda kobeta bakelelo yango. Ekozala mobeko ya libela mpo na bino mpe bakitani na bino. ");
INSERT INTO lin_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Tango, kati na mokili na bino moko, bokokende na bitumba mpo na kotelemela monguna oyo azali konyokola bino, bokobeta bakelelo na bino makasi. Boye, Yawe, Nzambe na bino, akokanisa bino mpe akokangola bino na maboko ya banguna na bino. ");
INSERT INTO lin_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Mpe lisusu, na batango na bino ya kosepela, na bafeti na bino oyo ekatama mpe ya ebandeli ya sanza, bokobeta bakelelo mpo na kobonza mbeka na bino ya kotumba mpe ya boyokani. Yango ekozala ekaniseli mpo na bino na miso ya Nzambe na bino. Nazali Yawe, Nzambe na bino. » ");
INSERT INTO lin_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Na mokolo ya tuku mibale, ya sanza ya mibale, ya mobu oyo ya mibale, lipata etelemaki na likolo ya Mongombo ya Litatoli. ");
INSERT INTO lin_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Boye, bana ya Isalaele balongwaki na esobe ya Sinai, basalaki mobembo mpe batambolaki bisika na bisika kino tango lipata eyaki kopema na esobe ya Parani. ");
INSERT INTO lin_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Ezalaki mbala na bango ya liboso ya kolongwa na molako mpe kotambola kolanda mitindo oyo Yawe apesaki na nzela ya Moyize. ");
INSERT INTO lin_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Mampinga ya molako ya Yuda ezalaki kotambola liboso, elongo na bendele na bango. Nashoni, mwana mobali ya Aminadabi, nde azalaki mokonzi na bango. ");
INSERT INTO lin_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Netaneeli, mwana mobali ya Tsuwari, azalaki mokonzi ya mampinga ya libota ya Isakari. ");
INSERT INTO lin_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Eliabi, mwana mobali ya Eloni, azalaki mokonzi ya mampinga ya libota ya Zabuloni. ");
INSERT INTO lin_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Bongo bakabolaki Mongombo na biteni-biteni. Bakitani ya Gerishoni mpe ya Merari nde bamemaki yango mpe bakendeki. ");
INSERT INTO lin_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Mampinga ya molako ya Ribeni elandaki na sima mpo na kotambola. Elitsuri, mwana mobali ya Shedewuri, nde azalaki mokonzi na bango. ");
INSERT INTO lin_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Shelumieli, mwana mobali ya Tsurishadayi, azalaki mokonzi ya mampinga ya libota ya Simeoni. ");
INSERT INTO lin_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Eliazafi, mwana mobali ya Deweli, azalaki mokonzi ya mampinga ya libota ya Gadi. ");
INSERT INTO lin_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Sima, bato ya Keati bakendeki mpe bamemaki biloko ya bule. Balevi mosusu bazalaki kotonga Mongombo liboso ete bakoma. ");
INSERT INTO lin_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Mampinga ya molako ya Efrayimi elandaki mpe na sima mpo na kotambola. Elishama, mwana mobali ya Amiwudi, nde azalaki mokonzi na bango. ");
INSERT INTO lin_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Gamilieli, mwana mobali ya Pedakitsuri, azalaki mokonzi ya mampinga ya libota ya Manase. ");
INSERT INTO lin_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Abidani, mwana mobali ya Gideoni, azalaki mokonzi ya mampinga ya libota ya Benjame. ");
INSERT INTO lin_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Boye, mpo na kosukisa, mampinga ya libota ya Dani mpe elandaki na sima mpo na kotambola na se ya bendele na bango. Akiezeri, mwana mobali ya Amishadayi, nde azalaki mokonzi na bango. ");
INSERT INTO lin_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Pagieli, mwana mobali ya Okirani, azalaki mokonzi ya mampinga ya libota ya Aseri ; ");
INSERT INTO lin_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","mpe Akira, mwana mobali ya Enani, azalaki mokonzi ya mampinga ya libota ya Nefitali. ");
INSERT INTO lin_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Wana nde ezalaki molongo oyo mampinga ya bana ya Isalaele ezalaki kotambola na yango. ");
INSERT INTO lin_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Moyize alobaki na Obabi, mwana mobali ya Reweli, moto ya Madiani, bokilo ya Moyize : — Tozali kokende na mokili oyo Yawe alobaki : « Nakopesa bino mokili yango. » Yaka kotambola elongo na biso. Tokosala ete obika bolamu oyo Yawe alakaki kosalela Isalaele. ");
INSERT INTO lin_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Obabi azongiselaki ye : — Te ! Nakokende elongo na bino te, nakozonga na mboka na ngai, kati na libota na ngai. ");
INSERT INTO lin_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Kasi Moyize alobaki : — Nabondeli yo : kotika biso te, pamba te yo nde oyebi bisika oyo tosengeli kotonga molako kati na esobe ; okozala motambolisi na biso. ");
INSERT INTO lin_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Soki otamboli na biso elongo, tokokabola elongo na yo eloko nyonso ya malamu oyo Yawe akopesa biso. ");
INSERT INTO lin_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Boye, balongwaki na ngomba ya Yawe mpe batambolaki mikolo misato ya mobembo. Sanduku ya Boyokani ya Yawe etambolaki liboso na bango na mobembo oyo ya mikolo misato mpo na kolukela bango esika ya kopema. ");
INSERT INTO lin_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Na moyi, lipata na Yawe ezalaki likolo na bango, na tango bazalaki kolongola molako. ");
INSERT INTO lin_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Tango nyonso Sanduku ezalaki kokende, Moyize azalaki koloba : « Oh Yawe, telema ! Tika ete banguna na Yo bapalangana ! Tika ete banguna na Yo bakima liboso na Yo ! » ");
INSERT INTO lin_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Mpe tango nyonso lipata ezalaki kopema, azalaki koloba : « Oh Yawe, zonga kati na bana ya Isalaele, pamba te bazali ebele penza ! » ");
INSERT INTO lin_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Mokolo moko, bana ya Isalaele bakomaki kolelalela na tina na pasi na bango. Boye, kolelalela yango ekomaki kino na matoyi ya Yawe. Tango ayokaki yango, kanda na Ye emataki makasi mpe moto kowuta epai na Yawe epelaki kati na bango mpe etumbaki ndambo ya bato kati na molako. ");
INSERT INTO lin_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Bato bagangaki epai ya Moyize ; ye abondelaki Yawe, mpe moto ekufaki. ");
INSERT INTO lin_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Boye, bakomaki kobenga esika yango « Tabeera, » pamba te moto ya Yawe ezikisaki bato ya Isalaele. ");
INSERT INTO lin_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Mokolo moko, bato ya bikolo mosusu oyo bazalaki elongo na bana ya Isalaele bakomaki na posa makasi ya kolia misuni. Bongo bana ya Isalaele bakomaki lisusu kolelalela mpe koloba : « Ah, nani penza akoki kopesa biso misuni ya kolia ? ");
INSERT INTO lin_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Tokanisi lisusu bambisi, bandunda ya ndenge na ndenge, pasiteki, bandembi, matungulu, ayi oyo tozalaki kolia ya ofele na Ejipito. ");
INSERT INTO lin_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Kasi sik’oyo, banzoto na biso ebebi penza, tozali lisusu te kolia biloko wana nyonso ! Tokomi kaka komona mana oyo ! » ");
INSERT INTO lin_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Mana ezalaki lokola mbuma ya koriande mpe ezalaki komonana pembe lokola mayi ya nzete oyo babengaka bedeliumi. ");
INSERT INTO lin_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Bato bazalaki kopanzana bipai na bipai mpo na kolokota yango, mpe na sima, bazalaki konika yango na libanga to mpe kotuta yango na liboka, bongo nde bakokaki kolamba yango na banzungu to kosalela yango mikate. Mikate na yango ezalaki na elengi lokola bagato oyo basala na mafuta ya sika. ");
INSERT INTO lin_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Na butu, tango mamwe ezalaki kokita, mana mpe ezalaki kokweya nzela moko na yango. ");
INSERT INTO lin_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Moyize ayokaki ndenge libota moko na moko ezalaki kolelalela na ekotelo ya ndako na bango ya kapo. Yawe asilikaki makasi ; mpe Moyize ayokaki pasi mingi na motema. ");
INSERT INTO lin_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Moyize alobaki na Yawe : — Mpo na nini komonisa mosali na Yo pasi ya boye ? Mabe nini ngai nasali penza mpo ete osundolela ngai mokumba ya bato oyo ? ");
INSERT INTO lin_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Boni, ngai moto namemaki mokumba ya bato oyo nyonso to nabotaki bango ? Mpo na nini oloba na ngai ete namema bango na maboko lokola bana mike, na mokili oyo olakaki na ndayi epai ya bakoko na bango ? ");
INSERT INTO lin_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Ngai nakozwa misuni ya kolia wapi mpo na bato oyo nyonso oyo bazali kokoba kolelalela epai na ngai : « Pesa biso misuni ya kolia ! » ");
INSERT INTO lin_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Ngai moko nakokoka te komema bato oyo nyonso ; mokumba oyo eleki monene mpo na ngai. ");
INSERT INTO lin_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Soki ezali kaka boye nde ozali kosala ngai, eleki malamu ete oboma ngai kaka sik’oyo. Soki nazwi ngolu na miso na Yo, kotika te ete namona kobebisama na ngai. ");
INSERT INTO lin_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Yawe alobaki na Moyize : — Kati na bakambi ya Isalaele, sangisela Ngai mibali tuku sambo, ba-oyo oyebi ete bazali bakambi mpe bakalaka kati na bato. Tika ete baya na Ndako ya kapo ya Bokutani mpe batelema wana elongo na yo. ");
INSERT INTO lin_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Nakokita mpe nakosolola na yo kuna. Nakokamata Molimo oyo ezali epai na yo mpe nakotia yango epai na bango. Bongo, bakosunga yo mpo na komema mokumba ya bato oyo mpo ete omema yango lisusu yo moko te. ");
INSERT INTO lin_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Loba na bato : « Bomibongisa mpe bomibulisa mpo na lobi, pamba te bokolia misuni. Yawe ayokaki tango bozalaki kolelalela : ‹ Ah, nani penza akoki kopesa biso misuni ya kolia ? Biso oyo tozalaki na biso malamu na Ejipito ! › Sik’oyo Yawe akopesa bino misuni mpe bokolia yango. ");
INSERT INTO lin_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Bokolia yango te kaka mokolo moko to mikolo mibale to mitano to zomi to mpe tuku mibale. ");
INSERT INTO lin_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","Kasi bokolia yango sanza mobimba kino ekobima bino na zolo mpe bokoyoka yango nkele, pamba te bobwakaki Yawe oyo azali kati na bino, bolelaki-lelaki liboso na Ye mpe bolobaki : ‹ Mpo na nini tobimaki na Ejipito ? › » ");
INSERT INTO lin_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Moyize alobaki lisusu : — Bato nkoto nkama motoba bazali kotambola sima na ngai, mpe Yo ozali koloba : « Nakopesa bango misuni ya kolia mpo na sanza mobimba ! » ");
INSERT INTO lin_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Ekokoka penza ata soki babomi bibwele nyonso oyo bazali na yango, ezala ngombe to bantaba ? Ekokoka penza ata soki balobi mbisi nyonso ya ebale monene ? ");
INSERT INTO lin_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Yawe alobaki na Moyize : — Boni, loboko na Yawe ezali solo mokuse ? Okomona sik’oyo soki maloba oyo nalobi ekokokisama to ekokokisama te mpo na yo. ");
INSERT INTO lin_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Boye, Moyize abimaki mpe ayebisaki bato maloba oyo Yawe ayebisaki ye. Asangisaki bakambi tuku sambo mpe atelemisaki bango zingazinga ya Ndako ya kapo. ");
INSERT INTO lin_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Yawe akitaki na nzela ya lipata mpe asololaki na ye ; akamataki nguya ya Molimo, oyo ezalaki epai na Ye, mpe atiaki yango epai ya bakambi tuku sambo. Tango kaka Molimo akitelaki bango, bakomaki kosakola, kasi bakobaki te. ");
INSERT INTO lin_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Nzokande, bato mibale oyo bakombo na bango ezalaki Elidadi mpe Medadi batikalaki kati na molako. Bango mpe bazalaki na molongo ya bampaka, kasi bakendeki te na Ndako ya kapo. Molimo akitelaki bango mpe bakomaki kosakola kati na molako. ");
INSERT INTO lin_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Elenge mobali moko apotaki mbangu mpe akendeki koyebisa Moyize : — Elidadi mpe Medadi bazali kosakola kati na molako ! ");
INSERT INTO lin_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Jozue, mwana mobali ya Nuni, oyo azalaki mosungi ya Moyize wuta bolenge na ye alobaki : — Moyize, nkolo na ngai, pekisa bango ! ");
INSERT INTO lin_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Kasi Moyize azongisaki : — Boni, okosalela ngai zuwa na likambo nini ? Nakosepela kutu ete bato nyonso bakoma basakoli mpe Yawe akitisa Molimo na Ye epai na bango ! ");
INSERT INTO lin_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Bongo, Moyize mpe bakambi nyonso ya Isalaele bazongaki na molako. ");
INSERT INTO lin_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Boye, Yawe atindaki mopepe moko oyo ememaki bankanga wuta na ebale monene mpe ebwakaki yango na molako mpe na zingazinga na yango. Etando oyo bankanga ekweyaki ezalaki molayi ya mobembo ya mokolo moko na makolo, mpe ezipaki mabele na bosanda ya metele moko. ");
INSERT INTO lin_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Bato babimaki mpo na kolokota bankanga mokolo mobimba, butu na yango mpe mokolo oyo elandaki. Moto moko te atikalaki kozwa na se ya bakilo nkoto moko ; mpe batandaki yango na zingazinga ya molako. ");
INSERT INTO lin_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Kasi, wana misuni ezalaki nanu kati na minoko na bango mpe basilisaki nanu kotafuna yango te, kanda ya Yawe epelaki mpo na bango mpe apesaki bango etumbu ya makasi. ");
INSERT INTO lin_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Yango wana, bakomaki kobenga esika yango « Kibiroti-Atava, » pamba te ezalaki na esika wana nde bakundaki bato ya lokoso. ");
INSERT INTO lin_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Longwa na Kibiroti-Atava, bana ya Isalaele basalaki mobembo kino na Atseroti mpe bavandaki kuna. ");
INSERT INTO lin_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Miriami mpe Aron bazalaki kotonga Moyize likolo ya mwasi na ye, pamba te abalaki mwasi ya mokili ya Kushi. ");
INSERT INTO lin_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Balobaki : — Boni, Yawe alobaka kaka na nzela ya Moyize ? Alobaki mpe na nzela na biso te ? Yawe ayokaki bango. ");
INSERT INTO lin_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Nzokande Moyize azalaki moto ya komikitisa makasi koleka bato nyonso ya mokili. ");
INSERT INTO lin_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Mbala moko, Yawe alobaki na Moyize, Aron mpe Miriami : — Boya bino misato na Ndako ya kapo ya Bokutani. Bango nyonso misato bakendeki. ");
INSERT INTO lin_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Yawe akitaki na likonzi ya lipata, atelemaki na ekuke ya Ndako ya kapo mpe abengaki Aron mpe Miriami. Tango bango mibale batelemaki liboso, ");
INSERT INTO lin_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","alobaki : — Boyoka maloba na Ngai ! ");
INSERT INTO lin_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Kasi ezalaka bongo te ");
INSERT INTO lin_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Nasololaka na ye elongi na elongi, ");
INSERT INTO lin_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Bongo Yawe apeliselaki bango kanda na Ye mpe atikaki bango. ");
INSERT INTO lin_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Tango kaka lipata elongwaki likolo ya Ndako ya kapo, bokono ya maba ezwaki mbala moko Miriami : ezalaki pembe lokola mvula ya pembe. Aron abalukaki mpo na kotala Miriami mpe amonaki ete azwi bokono ya maba. ");
INSERT INTO lin_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Bongo Aron alobaki na Moyize : — Nabondeli yo, nkolo na ngai ! Kotangela biso te masumu oyo tosali na bozoba ! ");
INSERT INTO lin_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Kotika te ete Miriami azala lokola mwana oyo abotami ya kokufa, oyo abimi na libumu ya mama na ye na ndambo ya nzoto ya kopola ! ");
INSERT INTO lin_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Boye, Moyize abelelaki Yawe : — Oh Nzambe, nabondeli Yo, bikisa ye ! ");
INSERT INTO lin_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Yawe azongiselaki Moyize : — Soki tata na ye abwakelaki ye soyi na elongi ; boni, alingaki kozala na soni te mikolo sambo ? Tia ye na libanda ya molako mikolo sambo, na sima na yango nde akoki kozonga. ");
INSERT INTO lin_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Boye batiaki Miriami libanda ya molako mikolo sambo mpe bato bazalaki kotambola te kino tango Miriami azongaki. ");
INSERT INTO lin_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Sima na yango, bato batikaki Atseroti mpe bakendeki kotonga molako na bango na esobe ya Parani. ");
INSERT INTO lin_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","« Tinda bato mpo na kononga mokili ya Kanana oyo nalingi kopesa na bana ya Isalaele. Kati na libota moko na moko, pona mpe tinda moto moko kati na bakambi. » ");
INSERT INTO lin_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Na mitindo ya Yawe, Moyize atindaki bango wuta na esobe ya Parani. Bango nyonso bazalaki bakambi ya mabota ya bana ya Isalaele. ");
INSERT INTO lin_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Tala bakombo na bango : mpo na libota ya Ribeni : Chamuwa, mwana mobali ya Zakuri ; ");
INSERT INTO lin_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","mpo na libota ya Simeoni : Shafati, mwana mobali ya Ori ; ");
INSERT INTO lin_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","mpo na libota ya Yuda : Kalebi, mwana mobali ya Yefune ; ");
INSERT INTO lin_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","mpo na libota ya Isakari : Yigali, mwana mobali ya Jozefi ; ");
INSERT INTO lin_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","mpo na libota ya Efrayimi : Oze, mwana mobali ya Nuni ; ");
INSERT INTO lin_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","mpo na libota ya Benjame : Paliti, mwana mobali ya Rafu ; ");
INSERT INTO lin_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","mpo na libota ya Zabuloni : Gadieli, mwana mobali ya Sodi ; ");
INSERT INTO lin_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","mpo na libota ya Jozefi na nzela ya Manase : Gaadi, mwana mobali ya Susi ; ");
INSERT INTO lin_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","mpo na libota ya Dani : Amieli, mwana mobali ya Gemali ; ");
INSERT INTO lin_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","mpo na libota ya Aseri : Seturi, mwana mobali ya Mikaeli ; ");
INSERT INTO lin_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","mpo na libota ya Nefitali : Nakibi, mwana mobali ya Vofisi ; ");
INSERT INTO lin_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","mpo na libota ya Gadi : Geweli, mwana mobali ya Maki. ");
INSERT INTO lin_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Oyo nde bakombo ya bato oyo Moyize atindaki mpo na kononga mokili ya Kanana. Moyize apesaki Oze, mwana mobali ya Nuni, kombo « Jozue. » ");
INSERT INTO lin_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Tango Moyize atindaki bango mpo na kononga mokili ya Kanana, alobaki : « Bolekela na nzela ya etuka ya Negevi mpe bokotela na nzela ya mokili ya bangomba. ");
INSERT INTO lin_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Botala soki mokili yango ezali ndenge nini mpe soki bato oyo bavandaka kuna bazalaka makasi to balemba, soki bazalaka ebele to moke. ");
INSERT INTO lin_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Botala ndenge nini mokili epai wapi bazali kowumela ezali : soki ezali malamu to mabe ; soki bazingela bingumba na yango na bamir to te. ");
INSERT INTO lin_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Botala soki mabele na yango ezali ndenge nini : ebotaka malamu to te ; ezali na banzete to te. Bosala nyonso penza ete bozonga na mbuma ya mokili yango. » Ezalaki eleko ya kobuka bambuma ya liboso ya vino. ");
INSERT INTO lin_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Boye bakendeki mpe banongaki mokili kobanda na esobe ya Tsini kino na Reobi, pembeni ya Lebo-Amati. ");
INSERT INTO lin_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Balekaki na nzela ya etuka ya Negevi mpe bakomaki kino na Ebron epai wapi Ayimani, Sheshayi mpe Talimayi, bakitani ya Anaki, bazalaki kovanda. Engumba Ebron etongamaki mibu sambo liboso ya engumba Tsoani kati na Ejipito. ");
INSERT INTO lin_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Tango bakomaki na lubwaku ya Eshikoli, bakataki etape mobimba ya nzete ya vino oyo ezalaki na liboke ya bambuma ya vino. Lokola ezalaki kilo makasi, bato mibale kati na bango basalelaki banzete mpo na komema yango ; bamemaki lisusu bambuma ya grenade mpe ya figi. ");
INSERT INTO lin_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Wuta na tango wana, bakomaki kobenga esika yango « lubwaku ya Eshikoli, » oyo elingi koloba « lubwaku ya liboke ya bambuma ya vino, » mpo na kokanisa liboke ya bambuma ya vino oyo bana ya Isalaele babukaki kuna. ");
INSERT INTO lin_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Sima na mikolo tuku minei, bazongaki wuta na mokili oyo banongaki. ");
INSERT INTO lin_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Bayaki kokuta Moyize, Aron mpe lisanga mobimba ya bana ya Isalaele na Kadeshi, kati na esobe ya Parani. Ezalaki kuna nde bapesaki bango elongo na lisanga mobimba sango ya mobembo na bango mpe balakisaki bango bambuma ya mokili yango. ");
INSERT INTO lin_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Bapesaki sango oyo epai ya Moyize : « Tokotaki kino na mokili epai wapi otindaki biso. Solo, ezali penza mokili oyo ezali kobimisa miliki mpe mafuta ya nzoyi ; tala kutu bambuma ya mokili yango. ");
INSERT INTO lin_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Kasi bato oyo bavandaka kuna bazali makasi mingi, bingumba na bango etongama makasi mpe ezali minene ; tomonaki lisusu bakitani ya Anaki kuna. ");
INSERT INTO lin_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Bato ya Amaleki bavandaka na etuka ya Negevi ; bato ya Iti, ya Yebusi mpe ya Amori bavandaka na mokili ya bangomba, mpe bato ya mboka Kanana bavandaka pembeni ya ebale monene mpe pembeni-pembeni ya Yordani. » ");
INSERT INTO lin_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Bongo Kalebi apamelaki bato ete batika makelele liboso ya Moyize, mpe alobaki : — Tokende kobotola mokili yango, pamba te tozali solo na makoki mpo na kosala yango ! ");
INSERT INTO lin_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Kasi bato oyo bakendeki elongo na ye balobaki : — Tokokoka te kobundisa bato wana mpo ete bazali makasi koleka biso. ");
INSERT INTO lin_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Bongo bakomaki kopanza sango mabe kati na bana ya Isalaele na tina na mboka oyo banongaki, bazalaki koloba : « Mokili oyo tonongaki ezali penza mabele oyo eliaka bavandi na yango ; bongo bato nyonso oyo tomonaki kuna bazali bingambe. ");
INSERT INTO lin_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Tomonaki kuna lisusu bato milayi, bakitani ya Anaki, oyo babima na nzela ya bato milayi. Na miso na biso moko, tozalaki komimona lokola mabanki ; bango mpe bazalaki komona biso kaka ndenge wana na miso na bango. » ");
INSERT INTO lin_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Bato nyonso ya lisanga batombolaki mingongo na bango mpe bakomaki kolela makasi butu mobimba. ");
INSERT INTO lin_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Bato nyonso ya Isalaele bakomaki koyimayima mpo na Moyize mpe Aron, mpe lisanga mobimba ekomaki koloba : « Ah, elingaki kozala malamu soki tomikufelaki na biso na Ejipito to na esobe ! ");
INSERT INTO lin_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Boni, Yawe amemi biso na mokili oyo kaka mpo ete tokufa na mopanga ? Boye basi mpe bana na biso bakokoma kaka bomengo ya bitumba. Ekozala malamu te mpo na biso ete tozonga na biso na Ejipito ? » ");
INSERT INTO lin_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Boye bakomaki kolobana bango na bango : « Tosengeli kopona mokambi mosusu mpe kozonga na Ejipito. » ");
INSERT INTO lin_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Moyize mpe Aron bakweyaki elongi kino na mabele liboso ya lisanga mobimba ya bana ya Isalaele oyo basanganaki kuna. ");
INSERT INTO lin_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Jozue, mwana mobali ya Nuni, mpe Kalebi, mwana mobali ya Yefune, oyo bazalaki na molongo ya bato oyo bakendeki kononga mokili bapasolaki bilamba na bango ");
INSERT INTO lin_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","mpe balobaki na lisanga mobimba ya Isalaele : « Mokili oyo totambolaki kati na yango mpe tonongaki ezali malamu mingi penza. ");
INSERT INTO lin_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Soki tozwi ngolu na miso ya Yawe, akokamba biso kino na mokili yango, mokili oyo ezali kobimisa miliki mpe mafuta ya nzoyi, mpe akopesa biso yango. ");
INSERT INTO lin_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Kasi botombokela Yawe te mpe bobanga te bato oyo bazali na mokili yango, pamba te tokomela bango ; kobatelama na bango elongwe kati na bango. Nzokande na ngambo na biso, Yawe azali elongo na biso. Bobanga bango te. » ");
INSERT INTO lin_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Wana lisanga mobimba ya Isalaele ezalaki koloba ete baboma bango na mabanga, nkembo ya Yawe emonanaki na Ndako ya kapo ya Bokutani na miso ya bato nyonso ya Isalaele. ");
INSERT INTO lin_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Yawe alobaki na Moyize : — Kino tango nini bato oyo bakotiola Ngai ? Kino tango nini bakoboya penza kondimela Ngai, ezala mpo na bikamwa nyonso oyo nasali kati na bango ? ");
INSERT INTO lin_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Nakokweyisa bango na nzela ya etumbu ya bokono oyo ebomaka mpo na kobebisa bango. Kasi yo, nakokomisa yo ekolo moko monene mpe ya nguya koleka bango. ");
INSERT INTO lin_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Moyize alobaki na Yawe : — Bato ya Ejipito bakoyoka yango ! Nzokande ezali na nguya na Yo nde obimisaki bato oyo kati na bango. ");
INSERT INTO lin_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Mpe bakoyebisa na bavandi ya mokili oyo makambo yango. Oh Yawe, basila koyoka wuta kala ete ozalaka elongo na bato oyo, ete Yo, oh Yawe, omimonisaki epai na bango miso na miso, ete lipata na Yo etelema likolo na bango, ete otambolaka liboso na bango kati na likonzi ya lipata, na moyi, mpe kati na likonzi ya moto, na butu. ");
INSERT INTO lin_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Na bongo, soki obomi bato oyo nyonso na mbala moko, bikolo oyo eyokaki sango oyo mpo na Yo ekoloba : ");
INSERT INTO lin_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","« Yawe azangaki penza makoki ya kokotisa bato oyo na mokili oyo alakaki, na nzela ya ndayi, ete akopesa bango yango, yango wana abomaki bango kati na esobe. » ");
INSERT INTO lin_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Sik’oyo, nabondeli Yo, tika ete makasi ya Nkolo emonisama na nguya na yango kolanda ndenge olobaki : ");
INSERT INTO lin_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","« Nazali Yawe oyo asilikaka noki te, atonda na bolingo, alimbisaka masumu mpe botomboki ; kasi apesaka moto oyo asali mabe etumbu, apesaka bana etumbu mpo na masumu ya batata kino na molongo ya misato mpe ya minei. » ");
INSERT INTO lin_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Nabondeli Yo, kolanda bolingo monene na Yo, limbisa masumu ya bato oyo ndenge kaka olimbisaki bango wuta babimaki na Ejipito kino sik’oyo. ");
INSERT INTO lin_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Yawe azongisaki : — Nalimbisi bango ndenge osengi. ");
INSERT INTO lin_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Kasi na Kombo na Ngai, mpe lokola mokili mobimba etondi na nkembo ya Yawe, ");
INSERT INTO lin_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","moko te kati na bato oyo bamonaki nkembo na Ngai mpe bikamwa oyo nasalaki kati na Ejipito mpe na esobe kasi baboyaki kotosa Ngai mpe bamekaki Ngai mbala zomi, ");
INSERT INTO lin_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","moko te kati na bango akomona lisusu mokili oyo nalakaki na nzela na ndayi epai ya bakoko na bango, moko te kati na ba-oyo batiolaki Ngai akomona lisusu mokili yango. ");
INSERT INTO lin_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Kasi lokola Kalebi, mosali na Ngai, atambolisamaka na molimo mosusu mpe atamboli na bosembo na miso na Ngai, nakokotisa ye na mokili oyo asilaki kokende, mpe bakitani na ye bakokamata yango lokola libula. ");
INSERT INTO lin_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Lokola bato ya Amaleki mpe ya Kanana bazali nanu kovanda na lubwaku, bino bokobaluka mpe bokozonga lobi na tongo na esobe, na nzela oyo ekenda na ebale monene ya Barozo. ");
INSERT INTO lin_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Yawe alobaki na Moyize mpe Aron : ");
INSERT INTO lin_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","— Kino penza tango nini lisanga oyo ya batomboki ekokoba kotelemela Ngai ? Solo, nayoki bileli mpe koyimayima ya bana ya Isalaele na tina na Ngai. ");
INSERT INTO lin_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Yebisa bango : « Nalapi ndayi, » elobi Yawe, « nakosalela bino makambo nyonso oyo nayoki bino koloba. ");
INSERT INTO lin_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Bibembe na bino ekolala na esobe oyo. Bino nyonso oyo bozali na mibu tuku mibale mpe koleka, bino oyo botangamaki na motango mpe boyimaki-yimaki mpo na Ngai, ");
INSERT INTO lin_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","bokokota te na mokili oyo nalakaki na nzela ya ndayi, na kotombola loboko, ete nakokomisa yango mokili na bino, longola kaka Kalebi, mwana mobali ya Yefune, mpe Jozue, mwana mobali ya Nuni. ");
INSERT INTO lin_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Kasi nakomema bana na bino oyo na tina na bango bolobaki ete bakozwa bango lokola bomengo ya bitumba, mpe nakokotisa bango na esengo kati na mokili yango oyo botiolaki. ");
INSERT INTO lin_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Nzokande bino, bibembe na bino ekolala na esobe oyo. ");
INSERT INTO lin_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Bana na bino bakokoma babateli bibwele awa na esobe mibu tuku minei. Lokola botamboli na bosembo te na miso na Ngai, bakomona pasi kino ebembe na bino ya suka elala na esobe. ");
INSERT INTO lin_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Lokola bosalaki mikolo tuku minei mpo na kononga mokili, bokomona pasi mibu tuku minei mpo na masumu na bino : mobu moko mpo na mokolo moko. Na bongo bokoyeba mbano oyo ezali kati na likambo ya kotelemela Ngai. ");
INSERT INTO lin_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Ngai Yawe nde nalobi ; mpe nakosala solo makambo oyo epai ya lisanga oyo mobimba ya batomboki oyo basanganaki mpo na kotelemela Ngai. Bakomona suka na bango kati na esobe oyo ; ezali awa nde bakokufa. » ");
INSERT INTO lin_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Bato oyo Moyize atindaki mpo na kononga mokili mpe, na bozongi na bango, batindikaki lisanga mobimba na koyimayima na tina na ye wana bapanzaki sango mabe na tina na mokili ; ");
INSERT INTO lin_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","bato oyo babimisaki maloba mabe na tina na mokili yango, bazwaki etumbu mpe bakufaki liboso ya Yawe. ");
INSERT INTO lin_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Kati na bato oyo bakendeki kononga mokili, kaka Jozue, mwana mobali ya Nuni, mpe Kalebi, mwana mobali ya Yefune, nde babikaki. ");
INSERT INTO lin_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Tango Moyize ayebisaki makambo oyo epai ya bato nyonso ya Isalaele, balelaki makasi. ");
INSERT INTO lin_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Na tongo-tongo ya mokolo oyo elandaki, bamataki na songe ya ngomba kati na etuka ya bangomba mpe balobaki : — Solo, tosalaki masumu ; kasi sik’oyo, tozali kokende kuna, na esika oyo Yawe alakaki biso. ");
INSERT INTO lin_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Kasi Moyize alobaki : — Mpo na nini bozali koboya kotosa mitindo ya Yawe ? Likambo oyo ekolonga te ! ");
INSERT INTO lin_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Bokende te, pamba te Yawe azali elongo na bino te ; banguna na bino bakolonga bino. ");
INSERT INTO lin_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Bato ya Amaleki mpe ya Kanana bakokutana na bino kuna. Bongo lokola bopesaki Yawe mokongo, bokokweya na mopanga mpo ete akozala elongo na bino te. ");
INSERT INTO lin_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Na lolendo na bango, bakendeki kaka na songe ya ngomba kati na etuka ya bangomba ; kasi Moyize alongwaki te na molako, ndenge moko mpe mpo na Sanduku ya Boyokani ya Yawe. ");
INSERT INTO lin_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Boye, bato ya Amaleki mpe ya Kanana oyo bazalaki kovanda na bangomba yango bakitelaki bango, babundisaki bango, balongaki bango mpe balandaki bango kino na Orima. ");
INSERT INTO lin_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","« Loba na bana ya Isalaele mpe yebisa bango : ‹ Sima na bino kokota na mokili oyo nakopesa bino, mokili epai wapi bokovanda, ");
INSERT INTO lin_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","bokobonzela Yawe likabo bazikisa na moto, oyo solo kitoko na yango ekosepelisa Yawe ; ekowuta kati na bangombe, bameme mpe bantaba na bino. Tika ete ezala mbeka ya kotumba to mbeka mpo na kokokisa ndayi, mbeka oyo bokobonza wuta na mokano ya mitema na bino to mpe mbeka oyo bokobonza na bafeti na bino ya bule. ");
INSERT INTO lin_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","Boye, moto oyo akomema mbeka na ye asengeli kobonzela Yawe likabo ya gato, bakilo misato ya farine oyo basangisa na balitele mibale ya mafuta ya olive. ");
INSERT INTO lin_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Mpo na bana meme moko na moko ya mbeka ya kotumba, bosengeli kobakisa balitele ya vino lokola likabo ya masanga. ");
INSERT INTO lin_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Mpo na meme ya mobali, bokobongisa likabo ya gato, bakilo motoba ya farine oyo basangisa na balitele mibale na ndambo ya mafuta ya olive, ");
INSERT INTO lin_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","mpe balitele mibale na ndambo ya vino lokola likabo ya masanga. Bokobonza yango lokola malasi ya solo kitoko liboso ya Yawe. ");
INSERT INTO lin_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Soki bobongisi mwana ngombe ya mobali lokola mbeka ya kotumba to mbeka mpo na kokisa ndayi to mbeka ya boyokani mpo na Yawe ; ");
INSERT INTO lin_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","bokomema elongo na mwana ngombe, likabo ya gato, bakilo libwa ya farine basangisa na balitele minei ya mafuta. ");
INSERT INTO lin_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Bokomema lisusu balitele minei ya vino lokola likabo ya masanga : ezali likabo bazikisa na moto, oyo solo kitoko na yango ekosepelisa Yawe. ");
INSERT INTO lin_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Ezali ndenge wana nde esengeli kobongisa mbeka nyonso ya ngombe ya mobali to ya meme ya mobali to ya bana meme to mpe ya mwana ntaba. ");
INSERT INTO lin_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Bokosala bongo mpo na nyama moko na moko, ezala soki motango na yango ezali boni. ");
INSERT INTO lin_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Mwana mboka asengeli kosala bongo mpo na makabo wana tango akomema likabo bazikisa na moto, oyo solo kitoko na yango esepelisaka Yawe. ");
INSERT INTO lin_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Pamba te, na milongo oyo ekoya, mopaya nyonso to moto mosusu oyo azali kowumela kati na bino, oyo akobonza likabo bazikisa na moto, oyo solo kitoko na yango ekosepelisa Yawe, asengeli kosala ndenge kaka bino bozali kosala. ");
INSERT INTO lin_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Mibeko ya kosalela ekozala ndenge moko mpo na lisanga mobimba, ezala bino to mopaya oyo akowumela kati na bino. Yango ekozala mobeko ya libela ezala mpo na milongo oyo ekoya. Bino na mopaya bozali ndenge moko liboso ya Yawe. ");
INSERT INTO lin_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Ezala bino to mopaya oyo azali kati na bino, bokosalela kaka mibeko mpe mitindo moko. › » ");
INSERT INTO lin_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","« Loba na bana ya Isalaele mpe yebisa bango : ‹ Tango bokokota na mokili oyo nazali komema bino ");
INSERT INTO lin_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","mpe bokolia bilei ya mokili yango, bobonza ndambo lokola likabo epai na Yawe. ");
INSERT INTO lin_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Bobonza gato oyo ewuti na farine ya liboso oyo bokonika, mpe bobonza yango lokola likabo oyo ewuti na mbuma ya liboso oyo elanga ya ble eboti. ");
INSERT INTO lin_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Boye, bokobonzaka epai na Yawe bambuma ya liboso ya milona na bino : ekozala bongo mpo na milongo oyo ekoya na sima. ");
INSERT INTO lin_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Soki esalemi ete bobuki na nko te moko kati na mibeko oyo Ngai Yawe napesaki na nzela ya Moyize, ");
INSERT INTO lin_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","moko kati na mitindo oyo Ngai Yawe napesaki bino na nzela ya Moyize, kobanda na mokolo oyo napesaki bino yango, mpe nazali kokoba kopesa yango kati na milongo oyo ekoya ; ");
INSERT INTO lin_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","mpe soki mbeba yango esalemi na nko te mpe lisanga esosoli yango te, lisanga mobimba ekobonza mwana ngombe ya mobali lokola mbeka ya kotumba oyo solo kitoko na yango ekosepelisa Yawe, elongo na likabo ya gato mpe likabo ya masanga ndenge ekatama, mpe ntaba ya mobali lokola mbeka mpo na masumu. ");
INSERT INTO lin_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Nganga-Nzambe akosala mosala ya bolimbisi masumu mpo na lisanga mobimba ya Isalaele, mpe bakolimbisama ; pamba te basalaki mabe na nko te mpe bamemelaki Yawe mpo na mabe na bango likabo bazikisa na moto mpe mbeka mpo na masumu. ");
INSERT INTO lin_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Lisanga mobimba ya Isalaele elongo na bapaya oyo bazali kowumela kati na bango bakozwa bolimbisi, pamba te bato nyonso bamikotisaki na mbeba oyo esalemaki na nko te. ");
INSERT INTO lin_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Kasi soki esalemi ete moto moko nde asali lisumu na nko te, asengeli komema mwana ntaba ya mwasi ya mobu moko lokola mbeka mpo na masumu. ");
INSERT INTO lin_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Nganga-Nzambe akosala mosala ya bolimbisi masumu liboso ya Yawe mpo na moto oyo asalaki masumu na nko te. Mpe tango mosala ya bolimbisi masumu ekosalema mpo na ye, akolimbisama solo. ");
INSERT INTO lin_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Bosengeli kosalela mobeko se moko, ezala mpo na mwana mboka kati na bana ya Isalaele to mpo na mopaya oyo azali kowumela kati na bino, oyo asali lisumu na nko te. ");
INSERT INTO lin_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Kasi moto nyonso oyo akosala lisumu na nko, azala mwana mboka to mopaya, atioli nde Yawe ; mpe moto ya lolenge oyo basengeli kolongola ye kati ya bato na ye. ");
INSERT INTO lin_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Pamba te atioli Liloba na Yawe mpe abuki mitindo na ye. Solo, moto ya lolenge oyo basengeli kolongola ye kati na bato na ye mpe akomema ngambo ya mabe na ye. › » ");
INSERT INTO lin_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Wana bana ya Isalaele bazalaki kati na esobe, bamonaki moto moko kolokota bakoni na mokolo ya Saba. ");
INSERT INTO lin_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Bato oyo bamonaki ye kolokota bakoni bamemaki ye epai ya Moyize, Aron mpe lisanga mobimba. ");
INSERT INTO lin_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Batiaki ye na esika oyo bazalaki kokengela ye malamu, pamba te bayebaki nanu malamu-malamu te nini esengelaki kosala mpo na ye. ");
INSERT INTO lin_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Bongo Yawe alobaki na Moyize : « Moto oyo asengeli kokufa. Bato nyonso ya lisanga basengeli komema ye libanda ya molako mpe koboma ye na mabanga. » ");
INSERT INTO lin_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Bongo lisanga mobimba ememaki ye libanda ya molako mpe babambaki ye mabanga kino akufaki ndenge Yawe atindaki yango epai ya Moyize. ");
INSERT INTO lin_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","« Loba na bana ya Isalaele mpe yebisa bango : ‹ Na milongo oyo ekoya, bosengeli kotia singa ya langi ya ble na basonge ya bilamba na bino ; esengeli kokangisa kitendi moko na moko na singa ya langi ya ble. ");
INSERT INTO lin_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Tango nyonso bokotala bitendi yango, bokobanda kokanisa mitindo nyonso ya Yawe, mpo ete botosa yango mpe botika kolanda baposa ya mitema na bino mpe ya miso na bino, oyo ekoki kotindika bino na kobungisa boyengebene. ");
INSERT INTO lin_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Boye, bokokanisa mibeko na Ngai nyonso, bokotosa yango mpe bokozala bule mpo na Nzambe na bino. ");
INSERT INTO lin_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Nazali Yawe, Nzambe na bino ; nabimisaki bino na Ejipito mpo ete nazala Nzambe na bino. Solo, nazali Yawe, Nzambe na bino. › » ");
INSERT INTO lin_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Molevi Kore, mwana mobali ya Yitseari, ya libota ya bato ya Keati, elongo na bato misato ya libota ya bato ya Ribeni basalelaki Moyize likita ; ezalaki : Datani mpe Abirami, bana mibali ya Eliabi, elongo na Oni, mwana mobali ya Peleti. ");
INSERT INTO lin_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","Batombokelaki Moyize. Elongo na bango, ezalaki na bana ya Isalaele nkama mibale na tuku mitano oyo bayebanaki malamu lokola bakambi ya lisanga mpe bazalaki kosangana kati na mayangani ya bakambi ya lisanga. ");
INSERT INTO lin_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Bayaki lisanga mpo na kotelemela Moyize mpe Aron. Balobaki na bango : — Bino mpe bolekisi ! Lingomba mobimba ezali bule mpe moto nyonso kati na yango azali bule, mpe Yawe azali elongo na bango. Boye, mpo na nini bozali komitia likolo ya lisanga ya Yawe ? ");
INSERT INTO lin_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Tango Moyize ayokaki bongo, akweyaki elongi kino na mabele. ");
INSERT INTO lin_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Alobaki na Kore mpe na bato na ye nyonso oyo balandaki ye : — Lobi na tongo, Yawe akolakisa nani azali moto na Ye mpe nani oyo azali bule, mpe akotika ye kopusana pene na Ye ; akotika solo moponami na Ye kopusana pene na Ye. ");
INSERT INTO lin_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Yo, Kore, elongo na bato nyonso oyo bazali kolanda yo, bokosala likambo oyo : Bokamata bambabola oyo batumbelaka malasi ");
INSERT INTO lin_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","mpe, lobi, botia moto mpe malasi ya ansa kati na yango liboso ya Yawe. Moto oyo Yawe akopona, ye nde azali bule. Bino Balevi, bino mpe bolekisi ! ");
INSERT INTO lin_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Moyize alobaki lisusu na Kore : — Bino Balevi, boyoka sik’oyo ! ");
INSERT INTO lin_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Ekoki na bino te ete Nzambe ya Isalaele atia bino pembeni kati na lisanga ya Isalaele mpe abenda bino pembeni na Ye mpo na kosala mosala na Mongombo ya Yawe mpe kotelema liboso ya lisanga mpo na kosalela bango ? ");
INSERT INTO lin_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Abendaki bino pembeni na Ye elongo na Balevi nyonso oyo bazali kolanda bino ; kasi sik’oyo, bazali lisusu koluka kozwa bonganga-Nzambe ! ");
INSERT INTO lin_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Ezali Yawe nde bosalelaki likita, yo elongo na bato oyo bazali kolanda yo. Aron nde nani mpo ete bokoka koyimayima na tina na ye ? ");
INSERT INTO lin_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Mpe na sima, Moyize abengisaki Datani mpe Abirami, bana mibali ya Eliabi. Kasi bazongisaki : — Tokoya te ! ");
INSERT INTO lin_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Ekoki kaka te mpo na yo kobimisa biso na mokili oyo ezali kobimisa miliki mpe mafuta ya nzoyi, mpo na koya kobomisa biso kati na esobe ? Sik’oyo olingi lisusu kokoma mokonzi na biso ? ");
INSERT INTO lin_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Te, okotisi biso kutu te na mokili oyo ezali kobimisa miliki mpe mafuta ya nzoyi to opesi biso ata libula moko te ya bilanga to ya bilanga ya vino. Boni, okanisi ete bato oyo bakufa miso ? Te, tokoya te ! ");
INSERT INTO lin_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Moyize asilikaki makasi mpe alobaki na Yawe : — Kondima makabo na bango te. Nazwaki ata eloko moko te epai na bango, ezala ane ; mpe nasalaki ata moto moko te mabe kati na bango. ");
INSERT INTO lin_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Moyize alobaki na Kore : — Lobi, yo mpe bato nyonso oyo bazali kolanda yo, bokotelema elongo na Aron liboso ya Yawe. ");
INSERT INTO lin_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Moko na moko akokamata mbabola na ye, oyo batumbelaka malasi, bongo akotia malasi ya ansa kati na yango mpe akomema yango liboso ya Yawe. Bambabola nyonso ekozala nkama mibale na tuku mitano ; yo mpe elongo na Aron bokomema bambabola na bino. ");
INSERT INTO lin_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Moto na moto akamataki mbabola na ye, atiaki moto mpe malasi ya ansa kati na yango ; bongo atelemaki esika moko na Moyize mpe Aron, na ekotelo ya Ndako ya kapo ya Bokutani. ");
INSERT INTO lin_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Tango Kore asangisaki bato nyonso oyo bazalaki kolanda ye mpo na kotelemela Moyize mpe Aron, na ekotelo ya Ndako ya kapo ya Bokutani, nkembo ya Yawe ebimelaki lisanga mobimba, ");
INSERT INTO lin_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","mpe Yawe alobaki na Moyize mpe Aron : ");
INSERT INTO lin_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","— Bokabwana na lisanga ya bato oyo mpo ete nalingi kosilisa bango kaka na mbala moko. ");
INSERT INTO lin_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Kasi Moyize mpe Aron bakweyaki bilongi kino na mabele mpe bagangaki : — Eh Nzambe ya milimo nyonso ya bato ! Okosilikela lisanga mobimba likolo ya lisumu ya moto moko kaka ? ");
INSERT INTO lin_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Bongo, Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","— Loba na lisanga ete bakende mosika ya bandako ya kapo ya Kore, ya Datani mpe ya Abirami. ");
INSERT INTO lin_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Moyize atelemaki mpe akendeki epai ya Datani mpe Abirami ; mpe bakambi nyonso ya Isalaele balandaki ye. ");
INSERT INTO lin_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Akebisaki lisanga mobimba : « Bozala mosika ya bandako ya kapo ya bato oyo ya mabe. Bosimba ata eloko moko te ya bango, noki te bokokufa likolo ya masumu na bango ! » ");
INSERT INTO lin_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Boye bakendeki mosika ya bandako ya kapo ya Kore, ya Datani mpe ya Abirami. Datani mpe Abirami elongo na basi, bana mpe bakoko na bango babimaki libanda mpe bakendeki kotelema liboso ya bikotelo ya bandako na bango ya kapo. ");
INSERT INTO lin_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Bongo Moyize alobaki : « Tala ndenge nini bokoyeba solo ete Yawe atindaki ngai kosala makambo oyo nyonso, kasi ezali makanisi ya motema na ngai moko te : ");
INSERT INTO lin_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Soki bato oyo bakufi kufa ya bato nyonso mpe bamoni makambo oyo bato nyonso bamonaka, wana nde Yawe atindaki ngai te ! ");
INSERT INTO lin_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Kasi soki Yawe asali penza likambo moko ya sika, bongo mabele efungoli monoko na yango mpe emeli bango elongo na biloko na bango nyonso, mpe bakiti ya bomoi kati na mokili ya bakufi, wana nde bokoyeba solo ete bato oyo batiolaki Yawe. » ");
INSERT INTO lin_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Tango kaka asilisaki koloba makambo oyo nyonso, mabele efungwamaki na se ya matambe ya Datani mpe Abirami ; ");
INSERT INTO lin_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","efungolaki monoko na yango mpe emelaki bango elongo na mabota na bango, bato ya Kore nyonso elongo na bozwi na bango nyonso. ");
INSERT INTO lin_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Bakitaki ya bomoi kati na mokili ya bakufi elongo na biloko na bango nyonso, mabele ezipaki bango mpe bakufaki ndenge wana. Mpe balimwaki kati na lisanga. ");
INSERT INTO lin_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Bato nyonso ya Isalaele oyo bazalaki pembeni na bango bakimaki tango bayokaki bango koganga. Bazalaki komilobela : « Mabele ekomela biso mpe lokola ! » ");
INSERT INTO lin_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Moto ewutaki epai na Yawe mpe etumbaki bato nkama mibale na tuku mitano oyo bazalaki kobonza malasi ya ansa. ");
INSERT INTO lin_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","« Loba na Eleazari, mwana mobali ya Nganga-Nzambe Aron, ete balongola bambabola oyo batumbelaka malasi na kati-kati ya moto, mpe bapanza makala ya moto mosika, pamba te bambabola wana ezali bule. ");
INSERT INTO lin_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Tika ete bakamata bambabola yango, atako ezali ya bato oyo bakufaki likolo ya masumu na bango ; mpe tika ete batuta yango na marto mpo ete ekoma papala mpe batia yango likolo ya etumbelo, pamba te bamemaki yango liboso ya Yawe mpe ekomaki bule. Tika ete yango ekoma elembo mpo na bana ya Isalaele. » ");
INSERT INTO lin_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Boye, Nganga-Nzambe Eleazari alokotaki bambabola nyonso ya bronze oyo bato oyo bazikaki na moto bamemaki, mpe atutaki yango na marto mpo na kotia yango likolo ya etumbelo ; ");
INSERT INTO lin_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","ndenge Yawe atindaki ye, na nzela ya Moyize. Yango ekozala lokola ekaniseli mpo na bana ya Isalaele ete moto moko te, moto oyo abulisama te, moto oyo azali mopaya liboso ya bakitani ya Aron, akoki koya kotumba malasi ya ansa liboso ya Yawe, noki te akokoma lokola Kore mpe bato oyo balandaki ye. ");
INSERT INTO lin_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Mokolo oyo elandaki, lisanga mobimba ya bana ya Isalaele ekomaki koyimayima mpo na Moyize mpe Aron. Bazalaki koloba : « Bino bobomi bato na Yawe. » ");
INSERT INTO lin_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Kasi tango lisanga mobimba esanganaki mpo na kotelemela Moyize mpe Aron, babalukaki na ngambo ya Ndako ya kapo ya Bokutani, mpe mbala moko lipata ezipaki yango mpe nkembo na Yawe emonisamaki. ");
INSERT INTO lin_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Boye, Moyize mpe Aron bakendeki liboso ya Ndako ya kapo ya Bokutani ");
INSERT INTO lin_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","mpe Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","« Bokende mosika ya lisanga oyo mpo ete nasilisa bango kaka na mbala moko. » Mpe bakweyaki bilongi kino na mabele. ");
INSERT INTO lin_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Moyize alobaki na Aron : « Kamata mbabola na yo mpe tia malasi ya ansa kati na yango elongo na moto ya etumbelo. Bongo, kima mbangu kati na lisanga mpo na kosala mosala ya bolimbisi masumu mpo na bango, pamba te kanda makasi ebimi liboso ya Yawe, etumbu ezali koya. » ");
INSERT INTO lin_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Aron asalaki ndenge kaka Moyize alobaki, mpe akimaki mbangu na kati-kati ya lisanga. Nzokande, etumbu emibandelaki kosala mosala na yango na kati-kati ya bato, kasi Aron abonzaki malasi ya ansa mpe asalaki mosala ya bolimbisi masumu mpo na bango. ");
INSERT INTO lin_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Atelemaki na kati-kati ya bato oyo bazalaki na bomoi mpe oyo bazalaki ya kokufa mpe etumbu esilaki. ");
INSERT INTO lin_vpl VALUES ("NU17_14","005_17_14","NUM","17","14","14","Nzokande, bato nkoto zomi na minei na nkama sambo bakufaki na etumbu wana, bakisa oyo bakufaki likolo ya Kore. ");
INSERT INTO lin_vpl VALUES ("NU17_15","005_17_15","NUM","17","15","15","Bongo, Aron azongaki epai ya Moyize na ekotelo ya Ndako ya kapo ya Bokutani, pamba te etumbu esilaki. ");
INSERT INTO lin_vpl VALUES ("NU17_16","005_17_16","NUM","17","16","16","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("NU17_17","005_17_17","NUM","17","17","17","« Yebisa bana ya Isalaele ete bapesa yo mangenda zomi na mibale, lingenda moko mpo na mokambi ya libota moko na moko kati ya bikolo na bango. Koma kombo ya moto moko na moko na lingenda na ye. ");
INSERT INTO lin_vpl VALUES ("NU17_18","005_17_18","NUM","17","18","18","Koma kombo ya Aron mpo na lingenda ya libota ya Levi, mpo ete mokambi moko na moko ya libota akozala na lingenda moko. ");
INSERT INTO lin_vpl VALUES ("NU17_19","005_17_19","NUM","17","19","19","Tia mangenda yango na Ndako ya kapo ya Bokutani, liboso ya Sanduku ya Litatoli, epai wapi nakutanaka na bino. ");
INSERT INTO lin_vpl VALUES ("NU17_20","005_17_20","NUM","17","20","20","Lingenda ya moto oyo nakopona ekobimisa moto ya etape. Ezali na nzela wana nde nakosukisa Ngai moko koyimayima ya tango nyonso kati na bana ya Isalaele na tina na bino. » ");
INSERT INTO lin_vpl VALUES ("NU17_21","005_17_21","NUM","17","21","21","Moyize ayebisaki bana ya Isalaele, mpe bakambi na bango bapesaki ye mangenda zomi na mibale, lokola lingenda moko mpo na mokambi ya libota moko na moko, lingenda ya Aron mpe ezalaki kati na mangenda wana. ");
INSERT INTO lin_vpl VALUES ("NU17_22","005_17_22","NUM","17","22","22","Moyize atiaki mangenda nyonso liboso ya Yawe, kati na Ndako ya kapo ya Litatoli. ");
INSERT INTO lin_vpl VALUES ("NU17_23","005_17_23","NUM","17","23","23","Mokolo oyo elandaki, Moyize akotaki na Ndako ya kapo ya Litatoli, bongo amonaki ete lingenda ya Aron, oyo ezalaki kolakisa ndako ya Levi, ebimisaki mito ya etape, ebotaki bafololo mpe ezalaki na bambuma ya amande ya kotela. ");
INSERT INTO lin_vpl VALUES ("NU17_24","005_17_24","NUM","17","24","24","Moyize abimisaki mangenda nyonso longwa na liboso ya Yawe mpe amemaki yango na miso ya bato nyonso ya Isalaele. Bamonaki yango mpe moto na moto azwaki lingenda na ye. ");
INSERT INTO lin_vpl VALUES ("NU17_25","005_17_25","NUM","17","25","25","Yawe alobaki na Moyize : « Zongisa lingenda ya Aron liboso ya Sanduku ya Litatoli mpo ete ebombama lokola elembo ya kotomboka na bango. Boye, okosukisa koyimayima na bango mpo na Ngai mpo ete bakufa te. » ");
INSERT INTO lin_vpl VALUES ("NU17_26","005_17_26","NUM","17","26","26","Moyize asalaki ndenge kaka Yawe atindaki ye. ");
INSERT INTO lin_vpl VALUES ("NU17_27","005_17_27","NUM","17","27","27","Bana ya Isalaele balobaki na Moyize : « Tokufi na biso, tobebi na biso, biso nyonso, tobebi na biso ! ");
INSERT INTO lin_vpl VALUES ("NU17_28","005_17_28","NUM","17","28","28","Moto nyonso oyo akopusana pembeni ya Mongombo na Yawe akokufa. Boni, biso nyonso tokufa ? » ");
INSERT INTO lin_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Yawe alobaki na Aron : « Yo elongo na bana na yo ya mibali mpe libota na yo bokomema mokumba ya masumu oyo ekosalema mpo na kobebisa bosantu ya Esika ya bule ; mpe lisusu yo kaka elongo na bana na yo ya mibali nde bokomema mokumba ya masumu oyo ekosalema na mosala ya bonganga-Nzambe. ");
INSERT INTO lin_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Yeisa pene na yo bandeko na yo ya mibali, Balevi, bato ya libota ya koko na yo, mpo ete basunga yo tango yo elongo na bana na yo ya mibali bokosala mosala ya bonganga-Nzambe liboso ya Ndako ya kapo ya Litatoli. ");
INSERT INTO lin_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Bakosunga yo mpe bakosala misala nyonso ya Ndako ya kapo kasi bakopusana te pene ya bisalelo ya Esika ya bule mpe ya etumbelo, noki te bango to bino bokokufa. ");
INSERT INTO lin_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Bakosunga yo mpe bakozala na mokumba ya kobatela Ndako ya kapo ya Bokutani, mosala nyonso ya Ndako ya kapo, mpe moto mosusu te akoki kopusana pene ya esika oyo bozali. ");
INSERT INTO lin_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Bino nde bokozala na mokumba ya kobatela Esika ya bule mpe etumbelo, mpo ete kanda makasi ekweya lisusu likolo ya Isalaele te. ");
INSERT INTO lin_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Tala, Ngai moko nde naponaki bandeko na yo, Balevi, kati na bana ya Isalaele lokola likabo mpo na yo ; babulisami mpo na Yawe mpo na kosala mosala ya Ndako ya kapo ya Bokutani. ");
INSERT INTO lin_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Kasi ekozala kaka yo elongo na bana na yo ya mibali nde bokosala mosala lokola Banganga-Nzambe na makambo nyonso oyo etali etumbelo mpe oyo esalemaka na sima ya rido. Nazali kopesa yo mosala ya bonganga-Nzambe lokola likabo. Moto mosusu oyo akopusana pene ya Esika ya bule asengeli kokufa. » ");
INSERT INTO lin_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Bongo Yawe alobaki lisusu na Aron : « Ngai moko napesi yo mokumba ya kobatela makabo oyo babonzeli Ngai. Napesi na yo mpe na bana na yo ya mibali, lokola eteni na bino, makabo nyonso ya bule oyo bana ya Isalaele bapesi Ngai : ezali mobeko ya libela na libela. ");
INSERT INTO lin_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Tala eteni oyo okozwa kati na makabo ya bule oyo eleki kitoko, oyo batumba na moto te : makabo nyonso oyo bakomemela Ngai lokola makabo oyo eleki bule, ezala makabo ya bagato to bambeka mpo na masumu to bambeka nyonso ya kozongisa boyokani ; biteni wana nyonso ekozala mpo na yo elongo na bana na yo. ");
INSERT INTO lin_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Bokolia yango lokola biloko oyo eleki bule, mwana mobali nyonso akolia yango. Bokotala yango lokola eloko ya bule. ");
INSERT INTO lin_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Tala lisusu biloko oyo ekozala mpo na yo : biloko nyonso oyo bakobonza kati na makabo oyo ekowuta na maboko ya bana ya Isalaele. Napesi yango epai na yo elongo na bana na yo ya mibali mpe ya basi, lokola mobeko ya libela na libela. Moto nyonso kati na ndako na yo, oyo akozala peto akoki kolia yango. ");
INSERT INTO lin_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Napesi yo mafuta nyonso ya olive oyo eleki kitoko, vino ya sika mpe ble oyo bapesi epai na Yawe lokola mbuma ya liboso ya milona na bango. ");
INSERT INTO lin_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Bambuma ya liboso ya mokili, oyo bakomema epai na Yawe ekozala mpo na yo. Moto nyonso kati na ndako na yo, oyo akozala peto, akoki kolia yango. ");
INSERT INTO lin_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Eloko nyonso, kati na Isalaele, oyo ekokabama epai na Yawe ekozala mpo na yo. ");
INSERT INTO lin_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Mpe lisusu, bana liboso nyonso, ezala ya bato to ya banyama oyo bakomema epai na Yawe bakozala mpo na yo. Kasi osengeli kosikola mwana mobali nyonso ya liboso ya moto to ya nyama ya mbindo. ");
INSERT INTO lin_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Tango bakokokisa sanza moko, osengeli kosikola bango na motuya ya mbongo ya bibende mitano ya palata, oyo moko na moko kati na yango ezali ya bagrame zomi, kolanda ndenge bamekaka kilo kati na Mongombo. ");
INSERT INTO lin_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Kasi osengeli te kosikola mwana liboso ya ngombe, ya meme to ya ntaba, pamba te ezali bule. Okosopa makila na yango na etumbelo mpe okotumba mafuta na yango lokola likabo bazikisa na moto, likabo ya solo kitoko mpo na Yawe. ");
INSERT INTO lin_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Misuni na yango ekozala mpo na yo, ndenge moko mpe mpo na tolo mpe mopende ya loboko ya mobali oyo batombolaka mpo na kobonzela Ngai. ");
INSERT INTO lin_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Napesi yo elongo na bana na yo ya mibali mpe ya basi, lokola ekateli ya libele na libela, biloko nyonso oyo bana ya Isalaele bakotiaka pembeni mpo na kobonza epai na Yawe lokola makabo ya bule. Ezali boyokani ya seko, oyo ekobongwanaka te liboso ya Yawe mpo na yo mpe bakitani na yo. » ");
INSERT INTO lin_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Yawe alobaki na Aron : « Okozwa eteni ya mabele te kati na mokili na bango, mpe okozwa ata bomengo moko te lokola libula kati na bana ya Isalaele, pamba te Ngai moko nde nazali bomengo mpe libula na bino kati na bana ya Isalaele. ");
INSERT INTO lin_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Napesi lokola libula, epai ya Balevi, biteni nyonso ya zomi oyo ekozwama kati na Isalaele lokola lifuti ya mosala oyo basalaka kati na Ndako ya kapo ya Bokutani. ");
INSERT INTO lin_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Kobanda sik’oyo, bana ya Isalaele basengeli lisusu te kopusana pene ya Ndako ya kapo ya Bokutani, noki te bakomema mokumba ya masumu na bango mpe bakokufa. ");
INSERT INTO lin_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Ezali Balevi nde bazali na mokumba ya kosala mosala na Ndako ya kapo ya Bokutani mpe ya komema mokumba ya bambeba na bango na kati na yango. Oyo ezali mobeko ya libela mpo na bileko oyo ekoya ya sima. Bakozwa libula moko te elongo na bana ya Isalaele. ");
INSERT INTO lin_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Na esika na yango, napesi epai ya Balevi lokola libula na bango, biteni moko nyonso kati na biteni zomi oyo bana ya Isalaele bakopesa lokola likabo epai na Yawe. Yango wana, nalobaki na tina na bango : ‹ Bakozwa libula moko te elongo na bana ya Isalaele. › » ");
INSERT INTO lin_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","« Loba na Balevi mpe yebisa bango : ‹ Tango bokozwa na maboko ya bana ya Isalaele eteni ya zomi oyo napesi bino lokola libula, bosengeli kopesa eteni ya zomi ya biteni wana ya zomi lokola likabo mpo na Yawe. ");
INSERT INTO lin_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Likabo yango ekozala mpo na bino lokola oyo balongolaka na ble oyo bazali kobuka na elanga mpe na vino ya sika oyo ezali kobima na ekamolelo. ");
INSERT INTO lin_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Na nzela wana nde bino mpe bokobonza makabo epai na Yawe wuta na biteni nyonso ya zomi oyo bokozwa na maboko ya bana ya Isalaele. Mpe wuta na biteni wana ya zomi, bosengeli kopesa eteni ya Yawe epai ya Nganga-Nzambe Aron. ");
INSERT INTO lin_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Kati na makabo nyonso oyo bokozwa, bosengeli kopesa epai na Yawe eteni oyo eleki kitoko mpe eleki bule. › ");
INSERT INTO lin_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Loba na Balevi : ‹ Tango bokopesa eteni oyo eleki kitoko, ekotangama mpo na bino lokola bambuma oyo elanga eboti mpe lokola vino oyo ekamolelo ebimisi. ");
INSERT INTO lin_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Bino elongo na mabota na bino, bokolia yango na bisika nyonso, pamba te yango ezali lifuti na bino mpo na mosala na bino kati na Ndako ya kapo ya Bokutani. ");
INSERT INTO lin_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Na nzela ya kopesa eteni wana oyo eleki kitoko, bokozala na ngambo te na likambo wana, bokobebisa te bosantu ya makabo ya bana ya Isalaele mpe bokokufa te. › » ");
INSERT INTO lin_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Yawe alobaki na Moyize mpe Aron : ");
INSERT INTO lin_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","« Tala malako ya mibeko ya Yawe : Bosenga na bana ya Isalaele ete bamema epai na bino ngombe ya mwasi ya motane ezanga mbeba to litono mpe etikala nanu te komema ekangiseli. ");
INSERT INTO lin_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Bokopesa yango epai ya Nganga-Nzambe Eleazari. Bongo ye akomema yango na libanda ya molako epai wapi akokata yango kingo na miso na ye. ");
INSERT INTO lin_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Na nzela ya mosapi na ye, Nganga-Nzambe Eleazari akozwa makila ya ngombe yango ya mwasi mpe akosopa yango mbala sambo na ngambo ya ekotelo ya Ndako ya kapo ya Bokutani. ");
INSERT INTO lin_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Bongo bakotumba ngombe ya mwasi na miso na ye : poso, mosuni, makila mpe biloko ya kati. ");
INSERT INTO lin_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Nganga-Nzambe akokamata bakoni ya nzete ya sedele, ya izope, singa ya lino ya motane makasi, mpe akobwaka yango kati na moto oyo ezali kopela mpe ezali kozikisa ngombe ya mwasi. ");
INSERT INTO lin_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Sima na yango, Nganga-Nzambe akosukola na mayi bilamba mpe nzoto na ye liboso ete azonga na molako. Atako bongo, Nganga-Nzambe akozala mbindo kino na pokwa. ");
INSERT INTO lin_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Moto oyo akotumba ngombe akosukola mpe bilamba mpe nzoto na ye ; mpe akozala mbindo kino na pokwa. ");
INSERT INTO lin_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Moto ya peto akokamata putulu ya ngombe mpe akotia yango na libanda ya molako na esika ya peto epai wapi bana ya Isalaele bakobatela yango mpo na kobongisa mayi ya bopetolami ; ezali mbeka mpo na masumu. ");
INSERT INTO lin_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Moto oyo akozwa putulu ya ngombe akosukola mpe bilamba na ye mpe akozala mbindo kino na pokwa. Ekozala mobeko ya libela na libela mpo na bana ya Isalaele mpe mpo na mopaya oyo avandi kati na bango. ");
INSERT INTO lin_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Moto nyonso oyo akosimba ebembe ya moto, ata mokufi yango azalaki nani, akozala mbindo mikolo sambo. ");
INSERT INTO lin_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Soki amipetoli na mayi na mokolo ya misato mpe ya minei, akokoma peto ; soki te, akozala kaka mbindo. ");
INSERT INTO lin_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Soki amipetoli te sima na ye kosimba ebembe ya moto, abebisi bosantu ya Mongombo ya Yawe. Basengeli kolongola ye na Isalaele, pamba te basopeli ye te mayi ya bopetoli ; boye akozala kaka mbindo, mbindo na ye ekokangama ye na nzoto. ");
INSERT INTO lin_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Tala mobeko oyo ebongi na kosalela soki moto akufi kati na ndako ya kapo : bato nyonso oyo bakokota na ndako ya kapo mpe ba-oyo bakomizalela na kati bakozala mbindo mikolo sambo. ");
INSERT INTO lin_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Sani nyonso ya kofungwama oyo ekozala na mofinuku te na likolo ekozala mbindo. ");
INSERT INTO lin_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Moto nyonso oyo asimbi kati na bilanga ebembe ya moto oyo akufi mpo ete moninga na ye moto abomi ye to akufi na liwa nyonso kaka to mpe asimbi mikuwa ya moto to kunda, akozala mbindo mikolo sambo. ");
INSERT INTO lin_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Mpo na kopetola moto oyo akomi mbindo, bakokamata putulu ya ngombe ya mwasi oyo batumbi na moto lokola mbeka mpo na masumu, bakotia yango na sani mpe bakosopela yango mayi ya etima. ");
INSERT INTO lin_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Moto oyo azali mbindo te akokamata etape ya izope mpe akotia yango kati na mayi, bongo akosalela yango mpo na kobwaka mayi na ndako ya kapo epai wapi moto akufi, na bisalelo mpe na banzoto ya bato nyonso oyo bazalaki kati na ndako yango ; akosala mpe bongo mpo na moto oyo asimbaki mikuwa, ebembe ya moto oyo moninga na ye moto abomaki to akufaki na liwa nyonso kaka to mpe mpo na moto oyo asimbaki kunda. ");
INSERT INTO lin_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Na mokolo ya misato mpe ya sambo, moto oyo azali mbindo te akobwakela moto ya mbindo. Bongo na mokolo ya sambo, akopetola ye. Moto oyo bapetoli akosukola bilamba na ye mpe akomisukola nzoto na mayi ; boye na pokwa, akokoma peto. ");
INSERT INTO lin_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Kasi soki moto oyo amikomisaki mbindo amipetoli, bakolongola ye kati na lisanga ; pamba te akomisi mbindo Esika ya bule ya Yawe. Mpe lokola basopeli ye te mayi ya bopetoli na nzoto, akozala mbindo. ");
INSERT INTO lin_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Ekozala mpo na bango mobeko ya libela na libela. Moto oyo akobwaka mayi ya bopetoli akosukola bilamba na ye, mpe moto oyo akosimba mayi yango akozala mbindo kino na pokwa. ");
INSERT INTO lin_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Eloko nyonso oyo moto ya mbindo akosimba ekokoma mbindo, mpe moto nyonso oyo asimbi eloko yango akokoma mbindo kino na pokwa. » ");
INSERT INTO lin_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Na sanza ya liboso, lisanga mobimba ya Isalaele ekomaki na esobe ya Tsini mpe bavandaki na Kadeshi. Ezalaki kuna nde Miriami akufaki mpe bakundaki ye. ");
INSERT INTO lin_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Nzokande esika yango ezalaki na mayi ya komela te mpo na lisanga ya Isalaele, mpe bato basanganaki mpo na kotombokela Moyize mpe Aron. ");
INSERT INTO lin_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Baswanisaki Moyize mpe balobaki : « Elingaki kozala malamu soki tokufaki na biso tango bandeko na biso bakufaki liboso ya Yawe ! ");
INSERT INTO lin_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Mpo na nini omemaki lisanga ya Yawe na esobe oyo ? Ezali mpo ete biso mpe bibwele na biso tokufa awa ? ");
INSERT INTO lin_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Mpo na nini obimisaki biso na Ejipito mpe omemi biso na esika oyo ya pasi, esika oyo bakoki kutu kolona ata eloko moko te, esika oyo ezanga ata mbuma ya figi to ya vino to mpe ya grenade, esika oyo ezanga kutu ata mayi ya komela ? » ");
INSERT INTO lin_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Moyize mpe Aron babimaki kati ya lingomba mpe bakendeki na ekuke ya Ndako ya kapo ya Bokutani, bakweyaki elongi kino na mabele, mpe nkembo ya Yawe ebimelaki bango. ");
INSERT INTO lin_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","« Zwa lingenda na yo ; bongo elongo na Aron, ndeko na yo ya mobali, bosangisa lisanga mobimba esika moko. Boloba na libanga wana na miso na bango, mpe ekobimisa mayi wuta na yango. Okobimisa mayi na libanga mpo ete bato ya lisanga mobimba bakoka komela elongo na bibwele na bango. » ");
INSERT INTO lin_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Moyize azwaki lingenda oyo ezalaki liboso ya Yawe, ndenge kaka Yawe atindaki ye. ");
INSERT INTO lin_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Ye mpe Aron basangisaki lisanga ya bato esika moko liboso ya libanga, mpe Moyize alobaki na bango : « Boyoka, bino batomboki, tokoki kobimisela bino mayi na libanga oyo ? » ");
INSERT INTO lin_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Moyize atombolaki loboko na ye mpe abetaki lingenda na ye na libanga mbala mibale. Mayi ebimaki ; bongo lisanga mobimba elongo na bibwele na bango bamelaki. ");
INSERT INTO lin_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Kasi Yawe alobaki na Moyize mpe Aron : « Lokola bondimeli Ngai te mpe bopesi lokumu na bosantu na Ngai te na miso ya bana ya Isalaele, bokokotisa lisusu lingomba oyo te na mokili oyo napesi bango. » ");
INSERT INTO lin_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Ezalaki mayi ya Meriba epai wapi bana ya Isalaele baswanaki na Yawe, mpe epai wapi Yawe alakisaki bosantu na Ye kati na bango. ");
INSERT INTO lin_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Wuta na Kadeshi, Moyize atindaki bantoma epai ya mokonzi ya Edomi mpe alobaki : — Tala maloba oyo ndeko na yo, Isalaele, alobi : « Oyebi pasi nyonso oyo ekomelaki biso. ");
INSERT INTO lin_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Bakoko na biso bakendeki na Ejipito mpe tokomaki kovanda kuna mibu ebele. Bato ya Ejipito banyokolaki biso elongo na bakoko na biso ; ");
INSERT INTO lin_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","kasi tango togangaki epai na Yawe, ayokaki kolela na biso, atindelaki biso anjelu oyo abimisaki biso na Ejipito. Sik’oyo tozali awa na kadeshi, engumba oyo ezali na suka ya mokili na yo. ");
INSERT INTO lin_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Tobondeli yo, tika biso tolekela na mboka na yo. Tokokota na elanga to na elanga ya vino moko te mpe tokomela mayi ya mabulu na bino te. Tokotambola kaka pembeni-pembeni ya nzela ya monene ya mokonzi bongo, tokokatisa ezala na ngambo ya loboko ya mobali to ya mwasi te, kino tokosilisa kokatisa mokili na yo. » ");
INSERT INTO lin_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Kasi mokonzi ya Edomi azongiselaki ye : — Okoki kolekela na mokili na ngai te ; soki omeki, tokobimela bino mpe tokobundisa bino na mopanga. ");
INSERT INTO lin_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Bana ya Isalaele bazongiselaki ye : — Tokotambola kaka pembeni-pembeni ya nzela ya monene mpe soki biso to bibwele na biso tomeli mayi na bino, tokofuta yango. Tolingi kaka eloko moko, eloko mosusu te : toleka kaka na makolo. ");
INSERT INTO lin_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Azongiselaki bango lisusu : — Bokoki kolekela awa te. Boye, bato ya Edomi babimelaki bango na mampinga monene ya basoda mpo na kobundisa bana ya Isalaele. ");
INSERT INTO lin_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Lokola Edomi eboyaki ete bana ya Isalaele balekela na etuka na yango, bana ya Isalaele bazwaki nzela mosusu. ");
INSERT INTO lin_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Lisanga mobimba ya Isalaele babimaki wuta na Kadeshi mpe bakomaki kino na ngomba Ori. ");
INSERT INTO lin_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Bongo, Yawe alobaki na Moyize mpe Aron na ngomba Ori, pembeni ya mondelo ya Edomi : ");
INSERT INTO lin_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","« Aron alingi kokende kokutana na bakoko na ye, pamba te akokota te na mokili oyo napesi bana ya Isalaele, mpo ete bino mibale botombokelaki mitindo na Ngai na mayi ya Meriba. ");
INSERT INTO lin_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Kamata Aron na Eleazari, mwana na ye ya mobali mpe mema bango likolo ya ngomba Ori. ");
INSERT INTO lin_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Longola Aron bilamba na ye mpe latisa yango Eleazari, mwana na ye ya mobali, pamba te Aron alingi kokende kokutana na bakoko na ye, akokufa kuna. » ");
INSERT INTO lin_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Moyize asalaki ndenge kaka Yawe atindaki : bamataki likolo ya ngomba Ori na miso ya lisanga mobimba. ");
INSERT INTO lin_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Moyize alongolaki Aron bilamba mpe alatisaki yango Eleazari, mwana na ye ya mobali. Mpe Aron akufa kuna na likolo ya ngomba. Boye, Moyize mpe Eleazari bakitaki ngomba ; ");
INSERT INTO lin_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","mpe tango lingomba mobimba eyokaki sango ete Aron asilaki kokufa, bato nyonso ya Isalaele basalelaki ye matanga ya mikolo tuku misato. ");
INSERT INTO lin_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Tango moto ya mboka Kanana, mokonzi ya Aradi, oyo azalaki kovanda na Negevi ayokaki ete Isalaele azali koya pembeni ya nzela ya Atarimi, abundisaki bana ya Isalaele mpe akangaki bamosusu kati na bango na boloko. ");
INSERT INTO lin_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Boye, bana ya Isalaele balapaki ndayi oyo epai na Yawe : « Soki okabi bato oyo na maboko na biso, tokobebisa bingumba na bango nyonso. » ");
INSERT INTO lin_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Yawe ayokaki kolela ya bana ya Isalaele mpe apesaki bango elonga likolo ya bato ya mboka Kanana elongo na bingumba na bango. Yango wana, babengaka esika yango « Orima » oyo elingi koloba : kobebisama. ");
INSERT INTO lin_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Bana ya Isalaele batikaki ngomba Ori mpe bakendeki pembeni-pembeni ya nzela ya ebale monene ya Barozo, mpo na kokima mokili ya Edomi. Kasi bato bakokaki lisusu te kokanga motema na nzela. ");
INSERT INTO lin_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Batombokelaki Nzambe mpe Moyize, balobaki : « Mpo na nini boye ! Bobimisaki biso na Ejipito mpo ete toya kokufa na esobe ? Bilei ezali te, mayi ezali te mpe tolembi kolia bilei oyo ya pamba-pamba ! » ");
INSERT INTO lin_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Bongo Yawe atindelaki bango banyoka ya ngenge oyo ekomaki koswa bato mpe bana ya Isalaele ebele bakufaki. ");
INSERT INTO lin_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Bato bayaki epai ya Moyize mpe balobaki : « Tosalaki masumu tango totombokelaki Yawe mpe totombokelaki yo. Bondela Yawe ete alongola mosika na biso banyoka oyo. » Boye, Moyize abondelaki mpo na bato. ");
INSERT INTO lin_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Yawe alobaki na Moyize : — Salisa nyoka moko ya ebende mpe telemisa yango likolo ya nzete mpo ete moto nyonso oyo aswami, atala yango mpe abika. ");
INSERT INTO lin_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Boye, Moyize asalisaki nyoka moko ya ebende mpe atelemisaki yango na likolo ya nzete. Boye moto nyonso oyo nyoka eswaki, bongo atalaki nyoka ya ebende, abikaki. ");
INSERT INTO lin_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Bana ya Isalaele balongwaki wana mpe bakendeki kotonga molako na bango na Oboti. ");
INSERT INTO lin_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Kolongwa na Oboti bakendeki kotonga molako na bango na Iye-Abarimi, na esobe oyo etalana na Moabi, na ngambo oyo moyi ebimaka. ");
INSERT INTO lin_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Kolongwa wana, bakendeki kotonga molako na bango na lubwaku ya Zeredi. ");
INSERT INTO lin_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Kolongwa wana, bakendeki kotonga molako na bango na ngambo mosusu ya Arinoni, mayi oyo elekela na esobe, wuta na etuka ya mokili ya bato ya Amori. Mayi ya Arinoni ezalaki na mondelo ya Moabi, na kati-kati ya mokili ya Moabi mpe ya Amori. ");
INSERT INTO lin_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Yango wana, buku ya bitumba ya Yawe eloba : « Wahebi kati na Sufa mpe miluka na yango, Arinoni ");
INSERT INTO lin_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","mpe nzela ya miluka ya mabwaku oyo ekenda kino na engumba Ari mpe elekela pembeni-pembeni ya mondelo ya Moabi. » ");
INSERT INTO lin_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Kolongwa wana, bakobaki kokende kino na Beri oyo ezalaki libulu ya mayi epai wapi Yawe alobaki na Moyize : « Sangisa bato esika moko mpo ete nakopesa bango mayi. » ");
INSERT INTO lin_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Boye, bana ya Isalaele bayembaki loyembo oyo : « Oh libulu, bimisa mayi ! Boyembela yango ! ");
INSERT INTO lin_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Libulu oyo bana bakonzi batimola, oyo bato minene batobola na mangenda mpe banzete na bango. » Kolongwa na esobe, bakendeki kino na Matana ; ");
INSERT INTO lin_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","kolongwa na Matana bakendeki na Naalieli, kolongwa na Naalieli bakendeki kino na Bamoti ; ");
INSERT INTO lin_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","mpe kolongwa na Bamoti bakendeki kino na lubwaku ya Moabi, na songe ya ngomba Pisiga, oyo eleki molayi na esobe. ");
INSERT INTO lin_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Bana ya Isalaele batindaki bantoma mpo na koyebisa Sikoni, mokonzi ya bato ya Amori : ");
INSERT INTO lin_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","« Tika biso tolekela na mokili na yo. Tokokota te na elanga to na elanga ya vino moko, mpe tokomela te mayi ya mabulu na bino ; tokoleka kaka na nzela ya monene ya mokonzi kino tokosilisa kokatisa mokili na yo. » ");
INSERT INTO lin_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Kasi Sikoni aboyaki kopesa bana ya Isalaele nzela ya kolekela na mokili na ye ; asangisaki mampinga na ye nyonso ya basoda mpe abimaki na esobe mpo na kobundisa Isalaele. Abundisaki Isalaele tango akomaki na Yakatsi. ");
INSERT INTO lin_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Kasi Isalaele alongaki ye mpe akamataki mokili na ye wuta na Arinoni kino na Yaboki, mpe lisusu kino na mokili ya bato ya Amoni, mpo ete bazalaki kokengela mondelo yango makasi. ");
INSERT INTO lin_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Isalaele abotolaki bingumba nyonso ya bato ya Amori mpe bakomaki kovanda kati na yango, bakisa Eshiboni mpe bamboka mike na yango nyonso ya zingazinga. ");
INSERT INTO lin_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Eshiboni ezalaki engumba oyo Sikoni, mokonzi ya bato ya Amori, oyo abundisaki mokonzi ya kala ya Moabi mpe abotolaki na maboko na ye mokili nyonso, kino na Arinoni. ");
INSERT INTO lin_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Yango wana balobaka na masese : « Boya na Eshiboni ! Tika ete etelema lisusu ! Tika ete engumba Sikoni etongama lisusu ! ");
INSERT INTO lin_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Moto ebimaki wuta na Eshiboni, ndemo ya moto ebimaki wuta na engumba ya Sikoni, etumbaki Ari ya Moabi, bavandi ya bangomba ya Arinoni. ");
INSERT INTO lin_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Oh Moabi, mawa na yo ! Oh bato ya Kemoshi, bobebisami ! Bakomisaki bana na ye ya mibali bakimi ; mpe bana basi na ye, bakangami ya mokonzi Sikoni, mokonzi ya Amori. ");
INSERT INTO lin_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Kasi tolongi bango ; Eshiboni nyonso ebebisami kino na Diboni, topanzi yango nyonso kino na Nofaki, mpe kino na Medeba. » ");
INSERT INTO lin_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Boye Isalaele avandaki na mokili ya bato ya Amori. ");
INSERT INTO lin_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Sima na yango, Moyize atindaki banongi na Yaezeri, bana ya Isalaele babotolaki bamboka ya mike-mike oyo ya zingazinga na yango mpe babenganaki bato ya Amori oyo bazalaki kovanda kuna. ");
INSERT INTO lin_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Boye bana ya Isalaele babalukaki mpe bakendeki pembeni-pembeni ya nzela oyo ekenda kino na Bashani. Ogi, mokonzi ya Bashani, elongo na mampinga na ye nyonso babimaki mpo na kokutana na bango mpe kobundisa bango na Edreyi. ");
INSERT INTO lin_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Bongo Yawe alobaki na Moyize : « Kobanga ye te, pamba te nakabi ye elongo na mampinga na ye nyonso mpe mokili na ye na maboko na yo ; sala ye ndenge osalaki Sikoni, mokonzi ya bato ya Amori, oyo azalaki kovanda na Eshiboni. » ");
INSERT INTO lin_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Boye, bana ya Isalaele babomaki ye elongo na bana na ye ya mibali mpe mampinga na ye nyonso ; batikaki ata moto moko te na bomoi, mpe bakamataki mokili na ye. ");
INSERT INTO lin_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Bana ya Isalaele batambolaki mobembo na bitando ya Moabi mpe batongaki molako na bango pembeni-pembeni ya ebale Yordani, oyo ezalaki etalana na Jeriko. ");
INSERT INTO lin_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Boye Balaki, mwana mobali ya Tsipori, ayokaki sango ya makambo nyonso oyo bana ya Isalaele basalaki bato ya Amori. ");
INSERT INTO lin_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Mpe bato ya Moabi bakomaki kobanga makasi mpo ete bana ya Isalaele bazalaki ebele penza. Boye, bakomaki na somo mingi liboso ya bana ya Isalaele. ");
INSERT INTO lin_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Bongo bato ya Moabi balobaki na bakambi ya Madiani : « Ebele ya bato oyo bazali koya mpo na kobebisa biloko nyonso oyo ezingeli biso lokola ngombe oyo ezali kolia matiti ya elanga. » Na tango wana, ezalaki Balaki, mwana mobali ya Tsipori, nde azalaki mokonzi ya Moabi. ");
INSERT INTO lin_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Atindaki bantoma kobenga Balami, mwana mobali ya Beori, oyo azalaki kovanda na Petori, pembeni ya ebale Efrate, mboka oyo ye abotama. Balaki alobaki na Balami : — Bato moko bawuti kobima na Ejipito, batondisi mokili mobimba mpe bayei sik’oyo kovanda pembeni na ngai. ");
INSERT INTO lin_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Nabondeli yo, yaka kolakela bango mabe, pamba te bazali makasi mingi koleka ngai, tango mosusu nakokoka kolonga bango mpe kobengana bango na mboka. Pamba te nayebi ete bato oyo opamboli, bapambolamaka ; mpe ba-oyo olakeli mabe, balakelamaka mpe mabe. ");
INSERT INTO lin_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Bakambi ya Moabi mpe ya Madiani bakendeki mpe bamemaki makabo mpo na kopesa na Balami, momoni makambo. Tango bakomaki epai ya Balami, bayebisaki ye makambo oyo Balaki atindaki. ");
INSERT INTO lin_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Balami alobaki na bango : — Bolekisa butu awa, mpe nakozongisela bino eyano oyo Yawe akopesa ngai. Boye bakambi ya Moabi bavandaki elongo na ye. ");
INSERT INTO lin_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Nzambe ayaki epai ya Balami mpe atunaki ye : — Bato oyo bazali epai na yo bazali banani ? ");
INSERT INTO lin_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balami alobaki na Nzambe : — Balaki, mwana mobali ya Tsipori, mokonzi ya Moabi, atindeli ngai maloba oyo : ");
INSERT INTO lin_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","« Bato moko bawuti kobima na Ejipito mpe batondisi mokili mobimba. Sik’oyo yaka mpe lakela bango mabe mpo na ngai. Tango mosusu nakokoka kobundisa bango mpe kobengana bango. » ");
INSERT INTO lin_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Kasi Nzambe alobaki na Balami : — Kokende elongo na bango te. Okoki kolakela bato wana mabe te, pamba te bazali bato bapambolama. ");
INSERT INTO lin_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Na tongo ya mokolo oyo elandaki, Balami alamukaki mpe alobaki na bakambi ya Balaki : — Bozonga na mboka na bino, pamba te Yawe aboyi ete nakende elongo na bino. ");
INSERT INTO lin_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Boye, bakambi ya Moabi bazongaki epai ya Balaki mpe balobaki : — Balami aboyi koya elongo na biso. ");
INSERT INTO lin_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Balaki atindaki bakambi mosusu oyo bazalaki mingi mpe na lokumu koleka bakambi oyo atindaki liboso. ");
INSERT INTO lin_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Bakomaki epai ya Balami mpe balobaki : — Tala liloba oyo Balaki, mwana ya mobali ya Tsipori alobi : « Tika ete eloko moko te epekisa yo koya epai na ngai ! ");
INSERT INTO lin_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Pamba te nakopesa yo lifuti ya malamu mpe nakosala nyonso oyo okoloba. Yaka penza mpe lakela bato oyo mabe mpo na ngai. » ");
INSERT INTO lin_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Kasi Balami azongiselaki bango : — Ezala soki Balaki apesi ngai palata mpe wolo oyo etondi na ndako na ye, nakokoka kosala eloko moko te ya monene to ya moke oyo ekokende libanda ya mibeko ya Yawe, Nzambe na ngai. ");
INSERT INTO lin_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Bino mpe lisusu bolekisa butu awa ndenge bandeko na bino basalaki, mpo ete naluka koyeba lisusu likambo oyo Yawe akoyebisa na ngai. ");
INSERT INTO lin_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Na butu wana, Nzambe ayaki epai na Balami mpe alobaki : — Lokola bato oyo bayei mpo na kobenga yo, kende elongo na bango. Kasi sala kaka makambo oyo nakoyebisa yo. ");
INSERT INTO lin_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Na tongo ya mokolo oyo elandaki, Balami alamukaki, abongisaki ane na ye ya mwasi mpe akendeki elongo na bakambi ya Moabi. ");
INSERT INTO lin_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Kasi tango akendeki, Nzambe asilikaki makasi mpe anjelu ya Yawe atelemaki na nzela mpo na kokanga ye nzela tango azalaki kotambola likolo ya ane elongo na basali na ye mibale. ");
INSERT INTO lin_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Tango ane emonaki anjelu ya Yawe atelema na kati-kati ya nzela na mopanga ya minu na loboko na ye, ane ebimaki na nzela mpe ekimaki na elanga. Boye, Balami abetaki ane mpo ete ekoka kozonga na nzela. ");
INSERT INTO lin_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Mpe lisusu, anjelu ya Yawe akendeki kotelema na nzela moko ya moke, oyo elekela na kati-kati ya bilanga mibale ya vino, oyo mopanzi moko na moko na yango ezalaki lokola na bamir mibale. ");
INSERT INTO lin_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Tango ane emonaki anjelu ya Yawe, epusanaki pembeni ya mir, efinaki lokolo ya Balami na mir. Balami abetaki yango lisusu. ");
INSERT INTO lin_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Anjelu ya Yawe alekaki liboso na bango mpe akendeki kotelema na esika moko ya moke penza, epai wapi nzela ya kobalukela na ngambo ya loboko ya mobali to ya mwasi ezali te. ");
INSERT INTO lin_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Tango ane emonaki anjelu ya Yawe, evandelaki Balami, nkolo na yango. Balami atombokaki makasi mpe akomaki kobamba ane lingenda na ye. ");
INSERT INTO lin_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Bongo, Yawe afungolaki monoko ya ane, mpe elobaki na Balami : — Likambo nini nasali yo mpo ete okoka kobeta ngai mbala misato ? ");
INSERT INTO lin_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balami azongiselaki ane : — Ozali kosakana na ngai ! Soki nazalaki na mopanga na loboko na ngai, mbele nabomi yo kaka sik’oyo ! ");
INSERT INTO lin_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Ane elobi na Balami : — Boni, nazali ane na yo te oyo osalelaka tango nyonso kino na mokolo ya lelo ? Nazalaka solo na momesano ya kosalela yo makambo ya boye ? Balami azongisaki : — Te ! ");
INSERT INTO lin_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Boye, Yawe afungolaki miso ya Balami, mpe Balami amonaki anjelu ya Yawe atelema na nzela, na mopanga na ye ya monene. Bongo, Balami afukamaki mpe akweyaki elongi kino na mabele. ");
INSERT INTO lin_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Anjelu ya Yawe atunaki ye : — Mpo na nini obeti ane na yo mbala misato ? Nayaki awa mpo na kokanga yo nzela, pamba te nzela na yo ezali mabe liboso na Ngai. ");
INSERT INTO lin_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Ane emonaki Ngai mpe ekimaki Ngai mbala misato. Soki ekimaki Ngai te, solo penza, nalingaki koboma yo, kasi nalingaki kotika yango na bomoi. ");
INSERT INTO lin_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Balami alobaki na anjelu ya Yawe : — Nasali masumu. Nayebaki te ete otelemaki na nzela mpo na kokanga ngai nzela. Kasi soki osepeli na mobembo oyo te, nakozonga na ngai. ");
INSERT INTO lin_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Anjelu ya Yawe alobaki na Balami : — Kende elongo na bato oyo kasi okoloba kaka makambo oyo nakoloba na yo. Boye, Balami akendeki elongo na bakambi ya Balaki. ");
INSERT INTO lin_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Tango Balaki ayokaki sango ete Balami azali koya, akendeki kokutana na ye na engumba ya bato ya Moabi, oyo ezalaka na mondelo ya Arinoni, na suka ya mokili na ye. ");
INSERT INTO lin_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Balaki alobaki na Balami : — Boni, natindaki te bato na lombangu mpo na kobenga yo ? Mpo na nini oyaki epai na ngai te ? Okanisaki ete nazangi makoki ya kofuta yo ? ");
INSERT INTO lin_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Balami azongiselaki Balaki : — Malamu, nayei sik’oyo epai na yo. Kasi nakoki solo koloba na yo kaka likambo moko ? Nakoloba kaka makambo oyo Nzambe akotia na monoko na ngai. ");
INSERT INTO lin_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Boye, Balami akendeki nzela moko na Balaki kino na Kiriati-Utsoti. ");
INSERT INTO lin_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Balaki abonzaki mbeka ya ngombe mpe ya meme, apesaki ndambo epai ya Balami mpe ndambo mosusu epai ya bakambi oyo bazalaki na ye elongo. ");
INSERT INTO lin_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Na tongo ya mokolo oyo elandaki, Balaki amemaki Balami, mpe bamataki na Bamoti-Bala ; mpe wuta kuna, bakokaki komona ndambo ya bana ya Isalaele. ");
INSERT INTO lin_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Balami alobaki na Balaki : « Tongela ngai bitumbelo sambo awa mpe bongisela ngai bangombe ya mibali mpe bameme ya mibali sambo. » ");
INSERT INTO lin_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balaki asalaki ndenge Balami alobaki, mpe bango mibale babonzaki bangombe ya mibali mpe bameme ya mibali wana na etumbelo moko na moko. ");
INSERT INTO lin_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Alobaki na Balaki : « Telema awa, pembeni ya mbeka na yo, bongo ngai napusani mwa mosika. Tango mosusu Yawe akoya kokutana na ngai, bongo nakoyebisa yo makambo nyonso oyo akolakisa ngai. » Balami akendeki likolo ya ngomba moko ya mokuse mpe ezanga matiti. ");
INSERT INTO lin_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Nzambe akutanaki na Balami, mpe Balami alobaki : — Nabongisaki bitumbelo sambo ; mpe na etumbelo moko na moko, nasili kobonza ngombe ya mobali mpe meme ya mobali moko. ");
INSERT INTO lin_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Yawe atiaki maloba na monoko ya Balami mpe alobaki : — Zonga epai ya Balaki mpe yebisa ye maloba oyo. ");
INSERT INTO lin_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Bongo Balami azongaki epai ya Balaki mpe akutaki ye atelemi pembeni ya mbeka na ye, elongo na bakambi nyonso ya Moabi. ");
INSERT INTO lin_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Boye, Balami akomaki koloba maloba oyo : « Balaki abengisaki ngai wuta na Arami, mokonzi ya Moabi abengisaki ngai wuta na bangomba ya este. Alobaki : ‹ Yaka, lakela Jakobi mabe mpo na ngai ; yaka, loba mabe mpo na Isalaele. ");
INSERT INTO lin_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Ndenge nini nakoki solo kolakela mabe bato oyo Nzambe alakela mabe te ? Ndenge nini nakoki solo koloba mabe mpo na bato oyo Yawe alobela mabe te ? ");
INSERT INTO lin_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Tala, wuta na likolo ya mabanga, nazali komona bango ; wuta na likolo ya bangomba, nazali kotala bango. Tala, nazali komona bato moko bavanda bango moko, bazali komitanga na molongo ya bikolo te. ");
INSERT INTO lin_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Nani akoki kotanga putulu ya Jakobi to kotanga motango ya bakitani ya Isalaele ? Tika ete nakufa kufa ya bato ya sembo, mpe tika ete suka na ngai ezala lokola ya bango ! › » ");
INSERT INTO lin_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Balaki alobaki na Balami : — Likambo nini osali ngai ? Nabengisaki yo mpo ete olakela banguna na ngai mabe ; kasi tala, opamboli bango koleka. ");
INSERT INTO lin_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Balami azongisaki : — Boni, naloba te maloba oyo Yawe atie na monoko na ngai ? ");
INSERT INTO lin_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Balaki alobaki na Balami : — Yaka elongo na ngai esika mosusu, epai okoki komona bango ; okomona bango nyonso te, kasi kaka ndambo. Mpe wuta na esika yango, lakela bango mabe mpo na ngai. ");
INSERT INTO lin_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Boye, Balaki amemaki Balami na elanga ya Tsofimi, na songe ya ngomba Pisiga, mpe atongaki kuna bitumbelo sambo mpe abonzaki bangombe ya mibali mpe bameme ya mibali wana na etumbelo moko na moko. ");
INSERT INTO lin_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Balami alobaki na Balaki : — Telema awa, pembeni ya mbeka na yo, wana ngai nakopusana mwa mosika mpo na kokutana na ye. ");
INSERT INTO lin_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Yawe akutanaki na Balami, atiaki maloba na monoko na ye mpe alobaki : — Zonga epai ya Balaki mpe yebisa ye maloba oyo. ");
INSERT INTO lin_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Bongo, Balami azongaki epai ya Balaki mpe akutaki ye atelemi pembeni ya mbeka na ye, elongo na bakambi nyonso ya Moabi. Balaki atunaki ye : — Yawe alobi nini ? ");
INSERT INTO lin_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Bongo Balami akomaki koloba maloba oyo : « Balaki, telema mpe yoka ! Mwana mobali ya Tsipori, yoka ngai malamu ! ");
INSERT INTO lin_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Nzambe azali moto te mpo ete akosa, azali mpe mwana ya moto te mpo ete akoka kobongola makanisi na Ye. Boni, akoki solo koloba mpe kosala eloko moko te ? Akoki solo kopesa elaka mpe kokokisa yango te ? ");
INSERT INTO lin_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Nazwaki nde mokumba ya kopambola. Asila kopambola, mpe ngai nakokoka kobongola te. ");
INSERT INTO lin_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Amonaka mbeba moko te epai ya Jakobi, amonaka minyoko te kati na Isalaele. Yawe, Nzambe na bango, azali elongo na bango ; koganga ya mokonzi ezalaka kati na bango. ");
INSERT INTO lin_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Nzambe abimisaki bango na Ejipito ; bazalaka makasi lokola mpakasa. ");
INSERT INTO lin_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Elakeli mabe moko te ekoki kozwa Jakobi, mpe kindoki ezali na nguya te likolo ya Isalaele. Bakoloba sik’oyo mpo na Jakobi mpe Isalaele : ‹ Tala makambo oyo Nzambe asali ! › ");
INSERT INTO lin_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Bato oyo batelemi lokola nkosi ya mwasi ; epemaka te soki epasoli te mosuni na yango mpe emeli te makila ya nyama oyo ekangi. » ");
INSERT INTO lin_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Bongo Balaki alobaki na Balami : — Ezala soki okoki te kolakela bango mabe, kasi kopambola bango te. ");
INSERT INTO lin_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Balami azongiselaki Balaki : — Nayebisaki yo te ete nakosala kaka makambo oyo Yawe akoloba na ngai ? ");
INSERT INTO lin_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Balaki alobaki na Balami : — Yaka, tika ete namema yo esika mosusu ! Tango mosusu Nzambe akosepela ete olakela bango mabe mpo na ngai wuta na esika yango. ");
INSERT INTO lin_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Balaki amemaki Balami na likolo ya ngomba Peori, esika oyo emonisaka esobe mobimba. ");
INSERT INTO lin_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Balami alobaki na Balaki : — Tongela ngai bitumbelo sambo mpe bongisela ngai bangombe ya mibali mpe bameme ya mibali sambo. ");
INSERT INTO lin_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balaki asalaki ndenge Balami alobaki, mpe abonzaki ngombe moko ya mobali mpe meme moko ya mobali na etumbelo moko na moko. ");
INSERT INTO lin_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Nzokande, tango Balami amonaki ete Yawe azalaki kaka na esengo ya kopambola Isalaele, alukaki lisusu bimoniseli te ndenge azalaki kosala na bambala mosusu, kasi abalolaki elongi na ye na esobe. ");
INSERT INTO lin_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Tango Balami atalaki, amonaki Isalaele bavanda na milako na bango, bato na bato na libota na bango. Molimo na Nzambe ayaki likolo na ye ; ");
INSERT INTO lin_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","mpe akomaki koloba maloba oyo : « Tala maloba ya Balami, mwana mobali ya Beori, maloba ya moto oyo miso na ye emonaka polele, ");
INSERT INTO lin_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","maloba ya moto oyo ayokaka maloba ya Nzambe, oyo amonaka bimoniseli oyo ewutaka epai ya Nkolo-Na-Nguya-Nyonso, oyo miso na ye efungwamaka soki akweyi na molimo : ");
INSERT INTO lin_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","‹ Oh Jakobi, tala ndenge bandako na yo ya kapo ezali kitoko, mpe bisika oyo ovandaka, oh Isalaele ! ");
INSERT INTO lin_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Epanzana lokola miluka ya mike-mike, lokola bilanga oyo ezalaka pembeni ya ebale, lokola banzete ya aloe oyo Yawe alona, lokola banzete ya sedele pembeni ya mayi. ");
INSERT INTO lin_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Mayi ekotiola wuta na bibombelo na bango, bankona na bango ekozwa mayi ebele. Mokonzi na bango akozala monene koleka Agagi, bokonzi na bango ekozala ya lokumu. ");
INSERT INTO lin_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Nzambe abimisaki bango na Ejipito, bazalaka makasi lokola mpakasa, babebisaka bikolo oyo ebundisaka bango mpe babukaka mikuwa na bango na biteni-biteni, batobolaka yango na makonga na bango. ");
INSERT INTO lin_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Bagunzamaka mpe balalaka lokola nkosi ya mobali, lokola nkosi ya mwasi ; nani akokoka kotelemisa bango ? Tika ete oyo akopambola yo apambolama, mpe oyo akolakela yo mabe alakelama mabe ! › » ");
INSERT INTO lin_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Balaki atombokelaki Balami makasi. Abetaki maboko na ye mpe alobaki : — Nabengisaki yo mpo ete olakela banguna na ngai mabe, kasi yo opamboli bango mbala misato. ");
INSERT INTO lin_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Yango wana, longwa na miso na ngai mpe zonga na mboka na yo ! Nalobaki ete nakopesa yo lifuti ya malamu, kasi Yawe azangisi yo lifuti yango. ");
INSERT INTO lin_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Balami azongiselaki Balaki : — Boni, nalobaki te na bantoma oyo otindelaki ngai ete ");
INSERT INTO lin_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","« Ata soki Balaki apesi ngai palata mpe wolo oyo etondi na ndako na ye, nakosala eloko moko te na mokano na ngai moko, ezala ya malamu to ya mabe, mpo ete nakende libanda ya mitindo na Yawe te. Nasala kaka oyo Yawe alobi. » ");
INSERT INTO lin_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Mpe sik’oyo, nazali kozonga na ngai epai ya bato na ngai ; kasi yaka, nakokebisa yo na tina na makambo oyo bato oyo bakosala bato na yo na mikolo ekoya. ");
INSERT INTO lin_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Bongo Balami alobaki maloba oyo : « Tala maloba ya Balami, mwana mobali ya Beori, maloba ya moto oyo miso na ye emonaka polele, ");
INSERT INTO lin_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","oyo ayokaka maloba na Nzambe, oyo ayebaka basekele ya Ye-Oyo-Aleki-Likolo, oyo azwaka emoniseli kowuta na Nkolo-Na-Nguya-Nyonso, oyo soki akweyi na molimo, miso na ye efungwamaka : ");
INSERT INTO lin_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","‹ Namoni ye, kasi sik’oyo te ; natali ye, kasi na pembeni te. Monzoto moko ekobima wuta na Jakobi, mpe lingenda ekobima wuta na Isalaele. Akotobola mito ya bato ya Moabi mpe akoboma bana mibali nyonso ya Seti. ");
INSERT INTO lin_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Bakobotola mokili ya Edomi, bakobotola Seiri, monguna na ye, kasi Isalaele akokoma lisusu makasi koleka. ");
INSERT INTO lin_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Mokonzi moko akobima wuta na Jakobi, mpe akoboma batikali nyonso ya engumba. › » ");
INSERT INTO lin_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Balami amonaki Amaleki mpe alobaki maloba oyo : « Amaleki ezalaki na molongo ya liboso kati na bikolo, kasi ekosuka na libebi. » ");
INSERT INTO lin_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Sima, amonaki bato ya Keni mpe alobaki maloba oyo : « Esika na yo ya kovanda ezali makasi, zala na yo ezalaka kati na mabanga ; ");
INSERT INTO lin_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","kasi bino bato ya Keni, bokobebisama tango Ashuri akozwa bino lokola bakangami. » ");
INSERT INTO lin_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Mpe na suka, alobaki maloba oyo : « Oh mawa ! Nani akoki kozala na bomoi, wana Nzambe akozala kosala makambo ya boye ? ");
INSERT INTO lin_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Bamasuwa ekoya wuta na mabongo ya Kitimi, bakonyokola Ashuri mpe Eberi, kasi bango moko mpe bakobebisama. » ");
INSERT INTO lin_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Bongo Balami atelemaki mpe azongaki epai na ye, Balaki mpe akendeki na nzela na ye. ");
INSERT INTO lin_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Wana bana ya Isalaele bavandaki nanu na Shitimi, bamipesaki na kindumba na bilenge basi ya Moabi. ");
INSERT INTO lin_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Mpe, bilenge basi yango bazalaki kobenga bango na milulu ya mbeka oyo babonzelaka banzambe na bango. Mpe bana ya Isalaele bazalaki kolia mpe kogumbamela banzambe yango. ");
INSERT INTO lin_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Bongo, bana ya Isalaele bamipesaki na kosambela Bala ya Peori mpe, kanda ya Yawe epelaki makasi mpo na bango. ");
INSERT INTO lin_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Yawe alobaki na Moyize : « Kanga bakambi nyonso ya Isalaele mpe diembika bango liboso na Ngai, na se ya moyi, mpo ete kanda makasi na Yawe elongwa likolo ya Isalaele. » ");
INSERT INTO lin_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Moyize alobaki na bakambi ya Isalaele : « Tika ete moko na moko kati na bino aboma bato na ye oyo bamipesi na kosambela nzambe Bala ya Peori. » ");
INSERT INTO lin_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Bongo moto moko ya Isalaele amemaki na libota na ye mwasi moko ya ekolo ya Madiani liboso ya Moyize mpe ya lisanga mobimba ya bana ya Isalaele, wana bazalaki kolela na ekotelo ya Ndako ya kapo ya Bokutani. ");
INSERT INTO lin_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Tango Pineasi, mwana mobali ya Eleazari, mwana mobali ya Nganga-Nzambe Aron amonaki bongo, abimaki kati na lisanga mpe akamataki mopanga ; ");
INSERT INTO lin_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","alandaki moto ya Isalaele wana kino kati na ndako na ye ya kapo mpe atobolaki bango mibale mabumu mpe bakufaki, ezala moto ya Isalaele wana mpe mwasi wana. Mpe etumbu oyo ezalaki likolo ya Isalaele esilaki. ");
INSERT INTO lin_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Bato oyo bakufaki na etumbu wana bazalaki, bato nkoto tuku mibale na minei. ");
INSERT INTO lin_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","« Nganga-Nzambe Pineasi, mwana mobali ya Eleazari, mwana mobali ya Aron, asili kolongola kanda na Ngai likolo ya bana ya Isalaele, pamba te atalisi bolingo oyo eleka ndelo mpo na lokumu na Ngai kati na bango ; yango wana, na kanda na Ngai ya makasi, nasilisaki koboma bana ya Isalaele te. ");
INSERT INTO lin_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Na boye, yebisa ye ete nasili kosala boyokani ya kimia elongo na ye. ");
INSERT INTO lin_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Boyokani yango ekozala mpo na ye mpe mpo na bakitani na ye, mpo ete basala mosala na Ngai ya Bonganga-Nzambe mpo na libela, pamba te atalisi bolingo oyo eleka ndelo mpo na lokumu ya Nzambe na ye, mpe asali mosala ya bolimbisi masumu mpo na bana ya Isalaele. » ");
INSERT INTO lin_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Kombo ya moto ya Isalaele oyo babomaki elongo na mwasi ya Madiani ezalaki Zimiri, mwana mobali ya Salu, mokambi ya libota ya Simeoni ; ");
INSERT INTO lin_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","mpe oyo ya mwasi ya Madiani ezalaki Kozibi, mwana mwasi ya Tsuri, mokambi ya libota moko ya ekolo ya Madiani. ");
INSERT INTO lin_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","« Kamata bato ya Madiani lokola banguna mpe boma bango, ");
INSERT INTO lin_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","pamba te bakamataki bino lokola banguna mpe basalelaki mayele mabe mpo na kokweyisa bino, na likambo ya Peori mpe ya ndeko na bango ya mwasi, Kozibi, mwana mwasi ya moko kati na bakambi ya Madiani, oyo babomaki na tango ya etumbu kati na likambo ya Peori. » ");
INSERT INTO lin_vpl VALUES ("NU25_19","005_25_19","NUM","25","19","19","Sima na etumbu wana, ");
INSERT INTO lin_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Yawe alobaki na Moyize mpe na Nganga-Nzambe Eleazari, mwana mobali ya Aron : ");
INSERT INTO lin_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","« Botanga motango ya bato ya lisanga mobimba ya Isalaele, bato nyonso oyo bazali na mibu tuku mibale mpe koleka, oyo bazali na makoki ya kosala mosala ya kisoda kati na Isalaele. » ");
INSERT INTO lin_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Moyize elongo na Nganga-Nzambe Eleazari basololaki na bango na etando ya Moabi, na libongo ya Yordani, pene na Jeriko, mpe balobaki : ");
INSERT INTO lin_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","« Tokotanga motango ya bana mibali nyonso ya Isalaele oyo bazali na mibu tuku mibale mpe koleka, ndenge Yawe apesaki mitindo epai ya Moyize. » Tala bana ya Isalaele oyo babimaki na Ejipito : ");
INSERT INTO lin_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Bakitani ya Ribeni, mwana mobali ya liboso ya Isalaele : na nzela ya Enoki, bakitani ya libota ya Enoki ; na nzela ya Palu, bakitani ya libota ya Palu ; ");
INSERT INTO lin_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","na nzela ya Etsironi, bakitani ya libota ya Etsironi ; na nzela ya Karimi, bakitani ya libota ya Karimi. ");
INSERT INTO lin_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Yango nde ezalaki mabota ya Ribeni mpe bazalaki bato nkoto tuku minei na misato na nkama sambo na tuku misato. ");
INSERT INTO lin_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Eliabi azalaki mwana mobali ya Palu, ");
INSERT INTO lin_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","mpe bana mibali ya Eliabi bazalaki Nemueli, Datani mpe Abirami. Datani mpe Abirami bazalaki bakalaka ya lisanga ya Isalaele oyo batombokelaki Moyize mpe Aron mpe bazalaki na molongo ya bato oyo bazalaki kolanda Kore oyo atombokelaki Yawe. ");
INSERT INTO lin_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Mabele efungolaki monoko na yango mpe emelaki bango elongo na Kore, oyo bato oyo bazalaki kolanda ye bakufaki tango moto ebomaki bato nkama mibale na mitano. Bakomaki lokola bandakisa. ");
INSERT INTO lin_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Kasi bakitani ya Kore bakufaki te. ");
INSERT INTO lin_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Bakitani ya Simeoni, kolanda mabota na bango, bazalaki : na nzela ya Nemueli, bakitani ya libota ya Nemueli ; na nzela ya Yamini, bakitani ya libota ya Yamini ; na nzela ya Yakini, bakitani ya libota ya Yakini ; ");
INSERT INTO lin_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","na nzela ya Zera, bakitani ya libota ya Zerayi ; na nzela ya Saulo, bakitani ya libota ya Saulo. ");
INSERT INTO lin_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Yango nde ezalaki mabota ya Simeoni mpe bazalaki bato nkoto tuku mibale na mibale na nkama mibale. ");
INSERT INTO lin_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Bakitani ya Gadi kolanda mabota na bango, bazalaki : na nzela ya Tsefoni, bakitani ya libota ya Tsefoni ; na nzela ya Agi, bakitani ya libota ya Agi ; na nzela ya Shuni, bakitani ya libota ya Shuni ; ");
INSERT INTO lin_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","na nzela ya Ozini, bakitani ya libota ya Ozini ; na nzela ya Eri, bakitani ya libota ya Eri ; ");
INSERT INTO lin_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","na nzela ya Arodi, bakitani ya libota ya Eroki ; na nzela ya Areeli, bakitani ya libota ya Areeli. ");
INSERT INTO lin_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Yango nde ezalaki mabota ya Gadi mpe bazalaki bato nkoto tuku minei na nkama mitano. ");
INSERT INTO lin_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Eri mpe Onani bazalaki bana mibali ya Yuda, kasi bakufaki na mokili ya Kanana. ");
INSERT INTO lin_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Bakitani mosusu ya Yuda, kolanda mabota na bango, bazalaki : na nzela ya Shela, bakitani ya libota ya Shela ; na nzela ya Peretsi, bakitani ya libota ya Peretsi ; na nzela ya Zera, bakitani ya libota ya Zera. ");
INSERT INTO lin_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Bakitani ya Peretsi kolanda mabota na bango bazalaki : na nzela ya Etsironi, bakitani ya libota ya Etsironi ; na nzela ya Amuli, bakitani ya libota ya Amuli. ");
INSERT INTO lin_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Yango nde ezalaki mabota ya Yuda ; bazalaki bato nkoto tuku sambo na motoba na nkama mitano. ");
INSERT INTO lin_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Bakitani ya Isakari kolanda mabota na bango bazalaki : na nzela ya Tola, bakitani ya libota ya Tola ; na nzela ya Puwa, bakitani ya libota ya Puwa ; ");
INSERT INTO lin_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","na nzela ya Yashubi, bakitani ya libota ya Yashubi ; na nzela ya Shimironi, bakitani ya libota ya Shimironi. ");
INSERT INTO lin_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Yango nde ezalaki mabota ya Isakari ; bazalaki bato nkoto tuku motoba na minei na nkama misato. ");
INSERT INTO lin_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Bakitani ya Zabuloni, kolanda mabota na bango, bazalaki : na nzela ya Seredi, bakitani ya libota ya Seredi ; na nzela ya Eloni, bakitani ya libota ya Eloni ; na nzela ya Yaleyeli, bakitani ya libota ya Yaleyeli. ");
INSERT INTO lin_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Yango nde ezalaki mabota ya Zabuloni mpe bazalaki bato nkoto tuku motoba na nkama mitano. ");
INSERT INTO lin_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Bakitani ya Jozefi kolanda mabota na bango na nzela ya Manase mpe Efrayimi bazalaki : ");
INSERT INTO lin_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Bakitani ya Manase : na nzela ya Makiri, bakitani ya libota ya Makiri (Makiri azalaki tata na Galadi) ; na nzela ya Galadi, bakitani ya libota ya Galadi. ");
INSERT INTO lin_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Tala bakitani ya Galadi : na nzela ya Yezeri, bakitani ya libota ya Yezeri ; na nzela ya Eleki, bakitani ya libota ya Eleki ; ");
INSERT INTO lin_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","na nzela ya Asirieli, bakitani ya libota ya Asirieli ; na nzela ya Sishemi, bakitani ya libota ya Sishemi ; ");
INSERT INTO lin_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","na nzela ya Shemida, bakitani ya libota ya Shemida ; na nzela ya Eferi, bakitani ya libota ya Eferi. ");
INSERT INTO lin_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Tselofikadi, mwana mobali ya Eferi, azalaki na bana mibali te, kasi azalaki kaka na bana basi ; bongo, tala bakombo na bango : Mala, Noa, Ogila, Milika mpe Tiritsa. ");
INSERT INTO lin_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Yango nde ezalaki mabota ya Manase, mpe bazalaki bato nkoto tuku mitano na mibale na nkama sambo. ");
INSERT INTO lin_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Bakitani ya Efrayimi kolanda mabota na bango bazalaki : na nzela ya Shutela, bakitani ya libota ya Shutela ; na nzela ya Bekeri, bakitani ya libota ya Bekeri ; na nzela ya Tayani, bakitani ya libota ya Tayani. ");
INSERT INTO lin_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Tala bakitani ya Shutela : na nzela ya Erani, bakitani ya etuka ya Erani. ");
INSERT INTO lin_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Yango ezalaki mabota ya Efrayimi mpe bazalaki bato nkoto tuku misato na mibale na nkama mitano. Bango nde bazalaki bakitani ya Jozefi kolanda bituka na bango. ");
INSERT INTO lin_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Bakitani ya Benjame kolanda mabota na bango bazalaki : na nzela ya Bela, bakitani ya libota ya Bela ; na nzela ya Ashibeli, bakitani ya libota ya Ashibeli ; na nzela ya Ayirami, bakitani ya libota ya Ayirami ; ");
INSERT INTO lin_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","na nzela ya Shufami, bakitani ya libota ya Shufami ; na nzela ya Ufami, bakitani ya libota ya Ufami. ");
INSERT INTO lin_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Bakitani ya Bela na nzela ya Aridi mpe Namani bazalaki : na nzela ya Aridi, bakitani ya libota ya Aridi ; na nzela ya Namani, bakitani ya libota ya Namani. ");
INSERT INTO lin_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Yango nde ezalaki mabota ya Benjame mpe bazalaki bato nkoto tuku minei na mitano na nkama mitano. ");
INSERT INTO lin_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Bakitani ya Dani kolanda mabota na bango, bazalaki : na nzela ya Shuami, bakitani ya libota ya Shuami. Bango nde bazalaki bakitani ya Dani : ");
INSERT INTO lin_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","bango nyonso bazalaki bakitani ya libota ya Shuami mpe bazalaki bato nkoto tuku motoba na minei na nkama minei. ");
INSERT INTO lin_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Bakitani ya Aseri, kolanda mabota na bango, bazalaki : na nzela ya Yimina, bakitani ya libota ya Yimina ; na nzela ya Yishivi, bakitani ya libota ya Yishivi ; na nzela ya Beria, bakitani ya libota ya Beria ; ");
INSERT INTO lin_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","na nzela ya bakitani ya Beria : na nzela ya Eberi, bakitani ya libota ya Eberi ; na nzela ya Malikieli, bakitani ya libota ya Malikieli. ");
INSERT INTO lin_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Aseri azalaki mpe na mwana moko ya mwasi na kombo Sera. ");
INSERT INTO lin_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Yango nde ezalaki mabota ya Aseri, mpe bazalaki bato nkoto tuku mitano na misato na nkama minei. ");
INSERT INTO lin_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Bakitani ya Nefitali, kolanda mabota na bango, bazalaki : na nzela ya Yatseyeli, bakitani ya libota ya Yatseyeli ; na nzela ya Guni, bakitani ya libota ya Guni ; ");
INSERT INTO lin_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","na nzela ya Yetseri, bakitani ya libota ya Yetseri ; na nzela ya Shilemi, bakitani ya libota ya Shilemi. ");
INSERT INTO lin_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Yango nde ezalaki mabota ya Nefitali, mpe bazalaki bato nkoto tuku minei na mitano na nkama minei. ");
INSERT INTO lin_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Motango nyonso ya bana ya Isalaele oyo batangaki ezalaki bato nkoto nkama motoba na moko na nkama sambo na tuku misato. ");
INSERT INTO lin_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","« Esengeli kokabolela bango mokili lokola libula, kolanda motango ya bato wana. ");
INSERT INTO lin_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Bokopesa eteni ya mabele ya monene epai ya libota oyo ezali mpe monene, eteni ya mabele ya moke epai ya libota oyo ezali mpe moke. Libota moko na moko ekozwa libula na yango, kolanda motango ya bato oyo batangaki. ");
INSERT INTO lin_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Bakokabola mokili na kobeta zeke mpe libota moko na moko ekozwa libula na yango, kolanda bakombo ya bakoko ya bikolo na bango. ");
INSERT INTO lin_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Esengeli kokabola libula na libula na zeke kati na libota oyo ezali monene mpe libota oyo ezali moke. » ");
INSERT INTO lin_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Tala bakitani ya Levi oyo batangamaki kolanda mabota na bango : na nzela ya Gerishoni, bakitani ya libota ya Gerishoni ; na nzela ya Keati, bakitani ya Keati ; na nzela ya Merari, bakitani ya Merari. ");
INSERT INTO lin_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Tala mabota mosusu ya bakitani ya Levi : bakitani ya libota ya Libini, bakitani ya libota ya Ebron, bakitani ya libota ya Maali, bakitani ya libota ya Mushi, bakitani ya libota ya Kore. Keati azalaki tata ya Amirami ; ");
INSERT INTO lin_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","bongo, kombo ya mwasi ya Amirami ezalaki « Yokebedi. » Yokebedi azalaki mokitani ya Levi, oyo abotamaki na Ejipito. Abotaki na Amirami Aron, Moyize mpe ndeko na bango ya mwasi Miriami. ");
INSERT INTO lin_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Aron azalaki tata ya Nadabi na Abiyu, Eleazari na Itamari. ");
INSERT INTO lin_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Kasi Nadabi na Abiyu bakufaki tango babonzelaki Yawe makabo na moto ya mopaya. ");
INSERT INTO lin_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Bakitani nyonso ya mibali ya Levi oyo batangamaki, kobanda na sanza moko ya mbotama mpe koleka, bazalaki nkoto tuku misato. Batangaki bango te elongo na bato mosusu ya Isalaele mpo ete bazwaki libula te kati na bango. ");
INSERT INTO lin_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Yango nde motango ya bana ya Isalaele oyo Moyize elongo na Nganga-Nzambe Eleazari batangaki na bitando ya Moabi, na libongo ya Yordani pene ya Jeriko. ");
INSERT INTO lin_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Kati na bango, moko te atikalaki na bomoi, kati na ba-oyo Moyize mpe Nganga-Nzambe Aron batangaki, tango batangaki bana ya Isalaele kati na esobe ya Sinai. ");
INSERT INTO lin_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Pamba te Yawe alobaki na bana ya Isalaele wana ete bakokufa solo na esobe, mpe moko te kati na bango longola kaka Kalebi, mwana mobali ya Yefune, mpe Jozue, mwana mobali ya Nuni. ");
INSERT INTO lin_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Bana basi ya Tselofikadi, mwana mobali ya Eferi, mwana mobali ya Galadi, mwana mobali ya Makiri, mwana mobali ya Manase bazalaki bakitani ya libota ya Manase, mwana mobali ya Jozefi. Bakombo na bango ezalaki : Mala, Noa, Ogila, Milika mpe Tiritsa. Bayaki ");
INSERT INTO lin_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","liboso ya Moyize, ya Nganga-Nzambe Eleazari mpe ya bakambi ya lisanga mobimba, na ekotelo ya Ndako ya kapo ya Bokutani mpe balobaki : ");
INSERT INTO lin_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","« Tata na biso akufaki na esobe. Azalaki te na molongo na bato oyo bazalaki kolanda Kore, oyo basanganaki lisanga mpo na kotelemela Yawe, kasi akufaki mpo na masumu na ye moko mpe atikaki bana mibali te. ");
INSERT INTO lin_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Bongo mpo na nini kombo ya tata na biso elimwa kaka boye na libota na ye, mpo ete azalaki na mwana mobali te ? Pesa biso mpe eteni ya mabele kati na bandeko ya tata na biso. » ");
INSERT INTO lin_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Boye, Moyize amemaki likambo na bango liboso ya Yawe. ");
INSERT INTO lin_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Yawe alobaki na Moyize : ");
INSERT INTO lin_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","« Makambo oyo bana basi ya Tselofikadi bazali koloba ezali solo. Osengeli kopesa bango eteni ya mabele lokola libula kati na bandeko ya tata na bango mpe pesa bango libula ya tata na bango. ");
INSERT INTO lin_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Loba na bana ya Isalaele : ‹ Soki moto moko asili kokufa mpe atiki bana mibali te, bokopesa libula na ye epai ya mwana na ye ya mwasi. ");
INSERT INTO lin_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Soki mpe azali na mwana mwasi te, bokopesa libula na ye epai ya bandeko na ye ya mibali. ");
INSERT INTO lin_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Soki mpe azali na bandeko mibali te, bokopesa libula na ye epai ya bandeko mibali ya tata na ye. ");
INSERT INTO lin_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Bongo, soki tata na ye azalaki mpe na bandeko mibali te, bokopesa libula na ye epai ya ndeko ya pene ya libota ya tata na ye ; ye nde akokitana na yango. Oyo ekozala mpo na Isalaele, mobeko oyo bosengeli kolanda ndenge Yawe alobaki na Moyize. › » ");
INSERT INTO lin_vpl VALUES ("NU27_12",