﻿USE sofia;
DROP TABLE IF EXISTS sofia.lik_vpl;
CREATE TABLE lik_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES lik_vpl WRITE;
INSERT INTO lik_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Mina ka ɓatɨtakɨ Yeso-Kilisito nɨma: ɨyɨ ɓɨkpɛ opupa ndɨ ka lɨvananza ka ngama Daudi. Na ɨyɨ ngama Daudi opupa ndɨ ka lɨvananza ka Abalahamʉ. ");
INSERT INTO lik_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abalahamʉ aɓʉkʉta ndɨ Isaka, Isaka aɓʉkʉta ndɨ Yakɔbɔ, Yakɔbɔ aɓʉkʉta ndɨ Yuda na ɓamamakɨ, ");
INSERT INTO lik_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda ɨɓʉ na mukakɨ ɓɛyɔ ka Tamali ɓaɓʉkʉta ndɨ Pelesi na Zela, Pelesi aɓʉkʉta ndɨ Esiloni, Esiloni aɓʉkʉta ndɨ Lamʉ, ");
INSERT INTO lik_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Lamʉ aɓʉkʉta ndɨ Aminadabʉ, Aminadabʉ aɓʉkʉta ndɨ Nasoni, Ɨyɨ Nasoni aɓʉkʉta ndɨ Sɔlɔmɔnɔ, ");
INSERT INTO lik_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Sɔlɔmɔnɔ ɨɓʉ na mukakɨ ɓɛyɔ ka Laaba ɓaɓʉkʉta ndɨ Bɔazɨ, Bɔazɨ aɓʉkʉta ndɨ Obedi. Amakɨ Obedi ndɨ nɨ Luta, Obedi aɓʉkʉta ndɨ Yɛsɛ, ");
INSERT INTO lik_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yɛsɛ aɓʉkʉta ndɨ ngama Daudi. Ngama Daudi aɓʉkʉta ndɨ Sɔlɔmɔnɔ na muka Ulia. Ɨyɨ Ulia a ndɨ nɨ okwini, ");
INSERT INTO lik_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sɔlɔmɔnɔ aɓʉkʉta ndɨ Leoboamʉ, Leoboamʉ aɓʉkʉta ndɨ Abia, Abia aɓʉkʉta ndɨ Asa, ");
INSERT INTO lik_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa aɓʉkʉta ndɨ Yɔzɔfatɨ, Yɔzɔfatɨ aɓʉkʉta ndɨ Yɔlamʉ, Yɔlamʉ aɓʉkʉta ndɨ Uzia, ");
INSERT INTO lik_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzia aɓʉkʉta ndɨ Yɔtamʉ, Yɔtamʉ aɓʉkʉta ndɨ Ahazi, Ahazi aɓʉkʉta ndɨ Izikia, ");
INSERT INTO lik_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Izikia aɓʉkʉta ndɨ Manasɨ, Manasɨ aɓʉkʉta ndɨ Amoni, Amoni aɓʉkʉta ndɨ Yɔsɨa, ");
INSERT INTO lik_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yɔsɨa aɓʉkʉta ndɨ Yekonia na ɓamamakɨ. Ʉɓʉkʉtaga ndɨ ngbingo nɨnɔ ɓuhokisa ndɨ mino Ɓezaleli kaɨnda na ɨɓʉ ka ɓusunzu ka Babiloni. ");
INSERT INTO lik_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Kumbuso kauhokiso Ɓezaleli kaɨnda ka Babiloni, Yekonia aɓʉkʉta ndɨ Salatieli, Ɨyɨ Salatieli aɓʉkʉta ndɨ Zelubabeli, ");
INSERT INTO lik_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zelubabeli aɓʉkʉta ndɨ Abiudi, Abiudi aɓʉkʉta ndɨ Eliakɨmʉ, Eliakɨmʉ aɓʉkʉta ndɨ Azɔlɔ, ");
INSERT INTO lik_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azɔlɔ aɓʉkʉta ndɨ Zadoki, Zadoki aɓʉkʉta ndɨ Akɨmʉ, Akɨmʉ aɓʉkʉta ndɨ Eliudi, ");
INSERT INTO lik_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudi aɓʉkʉta ndɨ Ɨlɨyazalɨ, Ɨlɨyazalɨ aɓʉkʉta ndɨ Matani, Matani aɓʉkʉta ndɨ Yakɔbɔ, ");
INSERT INTO lik_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakɔbɔ aɓʉkʉta ndɨ Yɛzɛfʉ, nɨnɔ a ndɨ mbʉnya Malia. Malia aɓʉkʉta kʉwa ndɨ Yeso nɨnɔ ɓamakaga ɓɛ Kilisito. ");
INSERT INTO lik_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Katʉkya ka Abalahamʉ kadwɛ ka ngama Daudi, a ndɨ ɓɛvananza tɛkɛɓɛ na ɓayɨkwanganya, katʉkya ka Daudi kadwɛ kʉ ɓuhokisa ndɨ mino Ɓezaleli kaɨnda ka Babiloni, a ndɨ ɓɛvananza ɓayagɔgɔ tɛkɛɓɛ na ɓayɨkwanganya, katʉkya wa ɓuhokisa ndɨ mino Ɓezaleli kaɨnda ka Babiloni kadwɛ ka liɓukuti ka Kilisito, a ndɨ ɓɛvananza tɛkɛɓɛ na ɓayɨkwanganya ɓata gɔnɨ. ");
INSERT INTO lik_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yɨɓʉkʉta ka Yeso-Kilisito a ndɨ ɓɛnɛ: Amakɨ ɓɛyɔ ka Malia ɓa ndɨ kavanana na Yɛzɛfʉ. Luki limoti, kambwa ɨɓʉ kavanana, Malia ava ndɨ mʉma ko ngu ya Lɨmbɛngɨ-Lotu. ");
INSERT INTO lik_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yɛzɛfʉ nɨnɔ ɓa ndɨ kavanana na ɨyɨ, a ndɨ mʉtʉ wo wongbingbili. Kɛgʉ ndɨ kapa ka pisiso suni ko misa ka ɓambanzʉ. Kinili, a ndɨ kapa kaasa ɓɨwɛsɛɛ. ");
INSERT INTO lik_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Tamanaga yi nɨyɔ a kʉwa ndɨ kʉsɔ ka Yɛzɛfʉ aka, kanɨ malaika ka Mombukwono-dosu anopuponilyoku ko nziki, aɓɨkya ɓɛ: «Yɛzɛfʉ, mika ngama Daudi, wakoɓongonitɔgʉ kava mukakʉ ɓɛyɔ ka Malia, kyɛ miki nɨnɔ a na ɨyɨ ka mʉma a pisi ko ngu ya Lɨmbɛngɨ-Lotu. ");
INSERT INTO lik_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Aɓʉkʉta ɓanʉ miki mʉlʉkʉ yi, walʉka ɓɛ Yeso. A ɓɛyɔ, ɨyɨ nɔ uhukuso ndɛkɛ ɓatʉ kakɨ ka ɓʉnyɛ kaɓʉ.» ");
INSERT INTO lik_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Nɨyɔ yasɨ igyonosa ndɨ kyɛ ɨtʉlyanɨ mʉnzɨna nɨmɔ Mombukwono-dosu aɓɨkya ndɨ pisi ka mugyalandʉ ɓɛ: ");
INSERT INTO lik_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«Mʉsɨka ɓemoti nɨnɔ kanibigʉ lɨkpʉmʉka ka ɓalʉkʉ avatʉ ndɛkɛ mʉma, aɓʉkʉta miki mʉlʉkʉ yi, ɓalʉka ndɛkɛ ɓɛ Imanueli.» Isi yi ɓɛ: «Kunzi pa imoti na iɓusu». ");
INSERT INTO lik_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Nɨyɔ Yɛzɛfʉ ozuzuko, agya ndɨ ɓɛyɔ aka yɔ malaika ka Mombukwono-dosu akpamya ndɨ mino. Ava kʉwa ndɨ mukakɨ ɓɛyɔ ka Malia. ");
INSERT INTO lik_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Luki limoti, kasyɛgʉ ndɨ na ɨyɨ kambwa Malia kaɓʉkʉta. Yɛzɛfʉ alʉka ndɨ miki ɓɛ Yeso. ");
INSERT INTO lik_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yeso ɨɓʉkʉta ndɨ ko mikya mugi nɨmɔ ina ɓɛ Bɛtɛlɛhɛmʉ ka iwili ya Yudɛa. Ko ngbingo yi nɨnɔ, Ɛlɔdɨ nɔ a ndɨ ngama. Kumbusa wa yɨɓʉkʉta ka Yeso, ɓatʉ ɓa yimibo ɓotukyoku ndɨ misa ka ɨngɛngɛ, ɓosila ndɨ ka Yelusalɛma. ");
INSERT INTO lik_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ɓuusa ndɨ ɓɛ: «Miki nɨnɔ iɓukuti kaiko ngama ka Ɓayuda a yanɨ? Tini ɓi lɨngʉtʉ kakɨ ananzɛ misa ya ɨngɛngɛ, kinili toduku kabibiso.» ");
INSERT INTO lik_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Nɨyɔ ngama Ɛlɔdɨ ʉkana mongoni mi nɨmɔ, ombomboya kʉgbɛ pa imoti na ɓatʉ ɓa Yelusalɛma ɓasɨ. ");
INSERT INTO lik_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ʉmʉmʉla kʉwa ndɨ ɓokumu-kumu na ɓowonisilo ɓa mʉtʉʉ ɓasɨ. Umuusa ndɨ ɓɛ: «Ɓogyalandʉ ɓaɓɨkyaga ndɨ ɓɛ ɓaɓʉkʉta ndɛkɛ Kilisito yanɨ?» ");
INSERT INTO lik_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ɨɓʉ aka ndɨ ɓɛ: «Ka Bɛtɛlɛhɛmʉ, ka iwili ya Yudɛa. A ɓɛyɔ, kyɛ mugyalandʉ okpikaga ndɨ ɓɛ: ");
INSERT INTO lik_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‹Ɨwɛ Bɛtɛlɛhɛmʉ, ka iwili ya Yudɛa, wakɛgʉ mugi ma payaya lugo wo giyo yakpʉkpʉ ya Yudɛa. A ɓɛyɔ, ngama opupa ndɛkɛ kʉ kakʉ nɨnɔ ika ndɛkɛ kaʉnanaga ɓatʉ kamɨ, ɓomikya Ɓezaleli ɓɛyɔ muɓuɓulyo wa ɓakɔndɔlɔ agyago mino.›» ");
INSERT INTO lik_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Kʉwa wa, Ɛlɔdɨ ʉmaka ndɨ ɓatʉ ɓa yimibo ka kpɔlɔ, ʉɓɨkya ɓɛ ɓatʉmbʉlyagɨ ngbinga tino nɔ ɓɨna ndɨ mino lɨngʉtʉ. ");
INSERT INTO lik_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Kumbuso yi, ʉtɨka ndɨ ka Bɛtɛlɛhɛmʉ. Ʉɓɨkya ɓɛ: «Windoni kʉ ɓɛyɔ, muusogo ɓɨnza mongoni ko miki yi nɨnɔ. Makamɨna, modoku kemibiso, iba nɨndɨtɔ gɔnɨ ɨmɨ kabibiso.» ");
INSERT INTO lik_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Nɨyɔ ɓʉkana lɨkpʉmʉka ka ngama, ɓaga ndɨ. Lɨngʉtʉ li nɨlɔ ɓɨna ndɨ misa ya ɨngɛngɛ a ndɨ gɔnɨ ka isisilogo aka kambwa kaɓʉ, amaga ndɨ tili na pa nɨyɔ miki a ndɨ mino. ");
INSERT INTO lik_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Nɨyɔ ɓatʉ ɓa yimibo ɓɨna lɨngʉtʉ, ɓotuma ndɨ na magyagya ɓɨɗɛ. ");
INSERT INTO lik_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ɓingya kʉwa ndɨ ka ndaɓʉ, ɓamɨna miki na amakɨ ɓɛyɔ ka Malia. Ɓoɓuna ndɨ moli kabibiso yi. Kumbuso yi, ɓakʉlaga ndɨ mukumba kaɓʉ, ɓapá apɛpɛ wa ɔlɔ, adʉdʉ na malazi nɨnɔ ɓalɨkyaga ɓɛ manɛmanɛ. ");
INSERT INTO lik_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Kʉwa wa, Kunzi ʉɓɨkya ndɨ ko nziki ɓɛ ɓakigonitɔgʉ ɓata pisi kʉ ka Ɛlɔdɨ. Ɓɨga kʉwa ndɨ kʉ kaɓʉ ko pisi yagɔgɔ. ");
INSERT INTO lik_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ngbingo yi nɨnɔ ɓatʉ ɓa yimibo ɓatʉkyo mino, malaika ka Mombukwono-dosu apuponilyoku ndɨ Yɛzɛfʉ ko nziki, aɓɨkya ɓɛ: «Tʉkya, mʉva miki na amakɨ mapɨkɨta ka Misili, mika kʉ kwa kʉ kadwɛ ko ngbingo yi nɨnɔ nʉɓɨkya ndɛkɛ mino ambɛ wigoku. A ɓɛyɔ, Ɛlɔdɨ apʉngatʉ kakɨsa miki ɓɨvaka-vaka ɓɛkyɛ ɓamwɨ.» ");
INSERT INTO lik_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Yɛzɛfʉ atʉkya kʉwa ndɨ, ava miki ɨɓʉ na amakɨ, ɓatʉkya ndɨ na gʉndʉ kaɨnda ka Misili. ");
INSERT INTO lik_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ɓika ndɨ kʉ kadwɛ ko ngbingo yi nɨnɔ ngama Ɛlɔdɨ okwa ndɨ mino. Nɨyɔ igyonosa ndɨ kyɛ ɨtʉlyanɨ mʉnzɨna nɨmɔ Mombukwono-dosu aɓɨkya ndɨ pisi ka mugyalandʉ ɓɛ: «Namaka ndɨ mikamɨ ambɛ igiku kotukyoku ka Misili.» ");
INSERT INTO lik_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Nɨyɔ Ɛlɔdɨ andʉnga ɓɛ ɓatʉ ɓa yimibo ɓaɓuni, lɨmbɛngɨ akandɨkanaga ndɨ ɓɨsʉlʉ-sʉlʉ. Akpamya kʉwa ndɨ ɓɛ ɓulumwisogi ɓomiki ɓalʉkʉ ɓi ɓasɨ ɓa ɓyanga ɓɨɓa ikanɨ kusili yi ka Bɛtɛlɛhɛmʉ na ko giyo nɨyɔ ka ɓakpɔlɔ-kpɔlɔ ɓi. Agya ndɨ ɓɛyɔ kaɓyɛnɛnɛ no ngbingo yi nɨnɔ ɓatʉ ɓa yimibo ɓɨna ndɨ mina lɨngʉtʉ. ");
INSERT INTO lik_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Nɨlɔ lasɨ, ɨtʉlyana ndɨ kowonisilo nɨlɔ ɨɓɨkya ndɨ pisi ka mugyalandʉ Yelemia ɓɛ: ");
INSERT INTO lik_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«Katʉkya ka Lama, ɓʉkana ndɨ lɨyʉ limoti. A lɨyʉ la mʉgamʉ mo kumbu na yigomisogo yidingi. Lasɛlɛ nɔ akaʉgama ɓomikakɨ, kɛgʉ gʉtʉgʉ kapa ɓɛ ɓatumisi lɨmbɛngɨ, kyɛ ɓomikakɨ ɓolumwogini.» ");
INSERT INTO lik_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Kumbusa wa kukwakʉ ka Ɛlɔdɨ, malaika ka Mombukwono-dosu apuponilya ndɨ ɓata Yɛzɛfʉ ko nziki kʉ ka Misili. ");
INSERT INTO lik_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Aɓɨkya ndɨ ɓɛ: «Zuzuko, mʉva miki na amakɨ, mɨga ka mugi ma Izaleli, kyɛ ɓatʉ nɨɓɔ ɓa ndɨ kapa kamwɔ miki, ɓolumwogini kʉwa.» ");
INSERT INTO lik_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Kʉwa wa, Yɛzɛfʉ ozuzuka ndɨ, ava miki na amakɨ ɓɨga ka Izaleli. ");
INSERT INTO lik_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Luki limoti, Yɛzɛfʉ ʉkana ndɨ ɓɛ Alikelaʉ nɨnɔ a ndɨ mika ngama Ɛlɔdɨ nɔ a kʉwa nɨ ɨyɨ ngama ka iwili ya Yudɛa. Kʉwa wa, Yɛzɛfʉ aɓanga ndɨ kaɨnda kʉ ɓɛyɔ. Mombukwono-dosu anzɨnɨlya ɓata ndɨ ko nziki, Yɛzɛfʉ aga kʉwa ndɨ ka iwili ya Galilaya. ");
INSERT INTO lik_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Kʉ ɓɛyɔ, ika ndɨ ka gʉɗʉ nɨnɔ ɓamakaga ɓɛ Nazalɛtɨ. Nɨmɔ masɨ, igyonosa ndɨ kyɛ ɨtʉlyanɨ nɨlɔ ɨɓɨkya ndɨ pisi ka ɓogyalandʉ ɓɛ: «Ɓamakaga ndɛkɛ ɓɛ mʉtʉ wa Nazalɛtɨ.» ");
INSERT INTO lik_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ko ngbingo yi nɨnɔ, Yuani-Mubatizaɨ opupana ndɨ ka ɨsa ya Yudɛa, anakʉwa kʉʉ yo Mongoni Manza ɓɛ: ");
INSERT INTO lik_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","«Yikosoni mambɛngɨ, kyɛ Ɓʉngama ɓa kʉgʉ wa lɨsyɛ a kʉwa ɓuwobi.» ");
INSERT INTO lik_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Mugyalandʉ Isaya anzɨna ndɨ ko bulya ka Yuani ɓɛ: «Mʉtʉ ɓemoti akapamɨkanaga ka ɨsa ɓɛ: ‹Muɓungusilyoni Mombukwono-dosu pisi! Munonilyoni ɓopisi ɓɨngbɨ-ngbɨngbɨ!›» ");
INSERT INTO lik_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yuani imokisyaga ndɨ kutuko kwo tukatʉ ta ngamia na mʉkaɓa ma sibokuso sa nyama ka ɨɗʉkʉfɨsɔ. Ʉlyaga ndɨ ɓanabʉnyɛnyɛ no nzuki nɨyɔ ikaga ko tutu. ");
INSERT INTO lik_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ɓambanzʉ ɓadulyogoku ndɨ kotukyoku ka Yelusalɛma, ka Yudɛa wasɨ na ko giyo yasɨ nɨyɔ ya mutili ma Yɔlɔdanɨ. ");
INSERT INTO lik_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ɓatwaga ndɨ ɓʉnyɛ kaɓʉ ka pa yangba, Yuani anuɓotiso ka Yɔlɔdanɨ. ");
INSERT INTO lik_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Nɨyɔ Yuani ʉmɨna ndɨ Ɓafalisayɔ na Ɓasadukayɔ ɓakpʉ kadulyoku ɓituteee kyɛ uɓotisi, ʉɓɨkya ndɨ ɓɛ: «Iɓunu lɨvananza ka ɓanzʉkaaa! Wanɨ nɔ amuwonyi pisi kapɨkɨta mʉngɨmbɔ ko Kunzi nɨmɔ akodoku? ");
INSERT INTO lik_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Wonisoni nɛkɨ pisi ka yɨgya ɓɛ moyikosoni mambɛngɨ. ");
INSERT INTO lik_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Makitombyonitɔgʉ kaɓɨkya ɓɛ: ‹Titosu nɨ Abalahamʉ!› A ɓɛyɔ, nakamʉɓɨkya ambɛ, Kunzi akwanana koitiso matamʉ mi nɨma kaiko ɓomika Abalahamʉ. ");
INSERT INTO lik_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Gbɔnɨ a sɛ kʉwa yakɨtʉlya kagbɨta bʉkʉtɔ ka motino mi. Ɓagbɨtatʉ sɨbʉkʉsɔ sasɨ nɨsɔ kɛgʉ kaɓʉkʉta bumo yanzanza, ɓaɗɨkɨta ko ɓuku. ");
INSERT INTO lik_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ɨmɨ, nakamuɓotiso ko liɓo kowonisilo ɓɛ mayikosoni ɔɓɨlɨ kunu. Luki limoti, nɨnɔ akodoku kumbuso kamɨ a no ngu kɛkɨtaga ɨmɨ. Ɨyɨ, amuɓotisa ɓanʉ na Lɨmbɛngɨ-Lotu no ɓuku. Nakakwananɨgʉ gʉtʉgʉ kanyɔgɔ ɓɛkpakʉ kakɨ aka. ");
INSERT INTO lik_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","A na ɗunga mugwi kapɨpa mʉpʉnga. Amʉmʉla ndɛkɛ mʉpʉnga, abiso ka basa ya masɔlɔ kakɨ. Luki limoti, abʉsya ndɛkɛ ɓɛvʉlʉ ko ɓuku nɨɓɔ kolimikogigʉ.» ");
INSERT INTO lik_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Kʉwa wa, Yeso atʉkya ndɨ ka Galilaya ɨnda ka Yɔlɔdanɨ, asilya Yuani ɓɛ kyɛ aɓotisi. ");
INSERT INTO lik_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Luki limoti, Yuani kɛgʉ ndɨ kapa kaɓotiso. Ɨyɨ aka ndɨ na Yeso ɓɛ: «Ɨwɛ nɔ wakwanana keɓotiso, woduku sɛ kʉwa kʉ kamɨ lɨkɨ!» ");
INSERT INTO lik_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Luki limoti, Yeso asikisya ndɨ ɓɛ: «Wasa, igyonosi ko ngbingo yi nɨmʉ ɓɛyɔ aka yɔ. A ɓɛyɔ, okwononi tagyɨ masɨ nɨmɔ Kunzi apaga ɓɛ tagyɨ.» Kʉwa wa, Yuani abaɨlya ndɨ. ");
INSERT INTO lik_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Nɨyɔ ɓaɓotisa Yeso, opupoku ndɨ ko liɓo. Ko ngbingo yi nɨnɔ aka nɔ, lɨsyɛ oukwikono, ɨna Lɨmbɛngɨ ko Kunzi nɨ anosyoku abɛ likpondi, ika kʉgʉ kakɨ. ");
INSERT INTO lik_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Lɨyʉ limoti otukyoku ndɨ kʉgʉ wa lɨsyɛ, aɓɨkya ɓɛ: «Mikamɨ mʉpaka nɨmʉ, nogwaga magyagya na ɨyɨ kʉgbɛ.» ");
INSERT INTO lik_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Kʉwa wa, Lɨmbɛngɨ-Lotu atɨka ndɨ Yeso ka ɨsa ɓɛ kyɛ mumuyoniso aɓɔɓɨ. ");
INSERT INTO lik_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Nɨyɔ Yeso agya masyɛ ɓatɛkɛɓɛ ɓakwanganya, biti na lɨsyɛ nɨ kalyalyagɨgʉ, ɨmʉkana ndɨ nza. ");
INSERT INTO lik_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Mumuyoniso akpuɗoku kʉwa ndɨ kaɓɔɓɔ, aɓɨkya ɓɛ: «Wakika Miko Kunzi, kpamya matamʉ mi nɨma ɨɨtɨ mukati.» ");
INSERT INTO lik_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yeso asikisya ndɨ ɓɛ: «Ikpikaga ɓɛ: ‹Ɔɓɨlɨ ka mʉmbanzʉ kɛgʉ asɨ ko bulya malɨlɨ aka, Luki limoti, a ka lɨkpʉmʉka lasɨ nɨlɔ opupaga ka mʉnɔkʉ ko Kunzi.›» ");
INSERT INTO lik_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kumbuso yi, mumuyoniso aga ndɨ na ɨyɨ ka gʉɗʉ wotu ka Yelusalɛma aɗokisa kugbondo wa Ndaɓʉ ko Kunzi. ");
INSERT INTO lik_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Aɓɨkya ɓɛ: «Wakika Miko Kunzi, bumbuko katʉkya wanʉ wadwɛ wasɨ, kyɛ ikpikaga ɓɛ: ‹Kunzi ʉkpamɨlyatʉ ɓamalaika kakɨ ɓɛ ɓʉbɨnɨkɨ ka maɓɔkʉ, kyɛ wakidwoni kʉgʉkɔ ka lɨtalʉ.›» ");
INSERT INTO lik_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yeso asikisya ndɨ ɓɛ: «Ikpikagatʉ gɔnɨ ɓɛ: ‹Wakaɓoɓonitɔgʉ Kunzi Mombukwana-dakʉ.›» ");
INSERT INTO lik_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Mumuyoniso ɨnda ndɨ ɓata na Yeso kʉgʉ wa ngʉpa nɨyɔ yɨkʉngʉ kʉgbɛ. Kʉ ɓɛyɔ, awonisa ndɨ ɓʉngama ɓasɨ ɓa ɔɓɨlɨ na ɨbɨba yi. ");
INSERT INTO lik_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Aɓɨkya kʉwa ndɨ ɓɛ: «Wakoɓuna moli kambwa kamɨ kebibiso, nʉpá nɨmana masɨ.» ");
INSERT INTO lik_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Luki limoti, Yeso asikisya ndɨ ɓɛ: «Abɨlɨ! Tʉkya! Kyɛ ikpikaga ɓɛ: ‹Mubibisaga Mombukwana-dakʉ Kunzi aka, wanalʉmbaga asɨ ko lino kakɨ aka.›» ");
INSERT INTO lik_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ka muliɓo, mumuyoniso asa ndɨ. Ɓamalaika ɓakpuɗoku kʉwa ndɨ Yeso, ɓapʉnga kagugubyo. ");
INSERT INTO lik_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Nɨyɔ Yeso ʉkana ɓɛ ɓagwini Yuani-Mubatizaɨ, atʉkya ndɨ wa, ɨnda ndɨ ka Galilaya. ");
INSERT INTO lik_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Kʉ ɓɛyɔ, atʉkya ndɨ ka Nazalɛtɨ, ɨnda kaika ka gʉɗʉ wa Kapɛlɛnaumu, ka mutili ma ibombu ya Galilaya, ka iwili ya Zabuloni na nɨyɔ ya Nafutali. ");
INSERT INTO lik_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Igyonosa ndɨ ɓɛyɔ, kyɛ ɨtʉlyanɨ mʉnzɨna nɨmɔ Mombukwono-dosu aɓɨkya ndɨ pisi ka mugyalandʉ Isaya ɓɛ: ");
INSERT INTO lik_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Ka iwili ya Zabuloni na nɨyɔ ya Nafutali, a miso yo liɓo lidingi, kʉsyakʉ wa Yɔlɔdanɨ. Ka Galilaya, mugi ka ɓatʉ nɨɓɔ ɓakɛgʉ Ɓayuda. ");
INSERT INTO lik_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ɓatʉ nɨɓɔ ɓikaga ndɨ ko biti, ɓinini ɓʉngbanganya, nɨɓɔ ɓa ndɨ ɓakiɗukufo ɓiguɓu ka kululuko kwa kukwakʉ, ɓʉngbanganya upupilyini!» ");
INSERT INTO lik_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Katʉkya ko ngbingo yi nɨnɔ aka nɔ, Yeso apʉnga ndɨ kaʉɓɨkyaga ɓambanzʉ Mongoni Manza ɓɛ: «Yikosoni mambɛngɨ, kyɛ ɓʉngama ɓa kʉgʉ wa lɨsyɛ a kʉwa ɓuwobi.» ");
INSERT INTO lik_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ngbingo yi nɨnɔ Yeso a ndɨ mina kakpakyana ka mutili ma ibombu ya Galilaya, ʉmɨna ndɨ ɓanyɔ ɓosi ɓaɓa nɨɓɔ ɓa ndɨ ɓomika-mʉlʉkʉ. A ndɨ nɨ Simoni nɨnɔ ɓamakaga ndɨ gɔnɨ ɓɛ Pɛtɛlɛ sɛ kʉwa mamakɨ ɓɛyɔ ka Andɨlɨa. Ɨɓʉ ɓasɨ ɓaɓa ɓa ndɨ kolubo moyo. ");
INSERT INTO lik_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yeso ʉɓɨkya ndɨ ɓɛ: «Iɓyeniku! Namuitiso kʉwa ɓanyɔ-ɓambanzʉ.» ");
INSERT INTO lik_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Wa aka wa, ɓasa ndɨ moyo kaɓʉ, ɓapʉnga kaɓɨɓya. ");
INSERT INTO lik_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Nɨyɔ Yeso isisilo kambwa yɨkɛɗɛ, ʉmɨna ndɨ ɓata ɓomika Zɛbɛdayɔ ɓaɓa, Yakɔbɔ na mamakɨ ɓɛyɔ ka Yuani. Ɓa ndɨ ka ɨngbɔlɔ yidingi pa imoti na abaɓʉ ɓɛyɔ ka Zɛbɛdayɔ, ɓanoɓungusyo moyo kaɓʉ. Yeso ʉmaka ndɨ. ");
INSERT INTO lik_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Wa aka wa, ɓasa ndɨ ɨngbɔlɔ yidingi, ɓasa abaɓʉ, ɓaɓyɛ ndɨ Yeso. ");
INSERT INTO lik_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yeso ɨnda ndɨ kolingyo giyo yasɨ ya Galilaya. Anatɨwa ka ɓandaɓʉ ɓaya malʉmba ka Ɓayuda. Anʉɓɨkyaga ɓambanzʉ Mongoni Manza ma ɓʉngama ɓa kʉgʉ wa lɨsyɛ. Anohukuso ɓokoloɓu ɓayasɨ na ɓʉpɔ ɓa nzʉyɨ dididi. ");
INSERT INTO lik_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Mongoni kakɨ ɨtʉlyana ndɨ ko giyo yasɨ ya Sulia. Mongoni mi nɨmɔ, ʉkpamya ndɨ ɓambanzʉ kadulyoku na ɓatʉ ɓasɨ ɓa mobi ma ɓokoloɓu na ɓʉpɔ dididi. Luga kaɓʉ, a ndɨ na nɨɓɔ ɓa ndɨ kaɨmʉkana kʉgbɛ, nɨɓɔ ɓa ndɨ na mambɛngɨ ma ɓʉnyɛ, nɨɓɔ ɓa ndɨ na lɨga na nɨɓɔ ɓa ndɨ ɓazɛgɛsɨ. Yeso uhukusa ndɨ ɓasɨ. ");
INSERT INTO lik_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ɓambaza ka ɓambanzʉ ɓudingi kʉgbɛ ɓa kʉwa ndɨ kaɓɨɓya ɓingbooo. Ɓotukyogoku ndɨ ka iwili ya Galilaya, ka iwili ya Ɓagʉɗʉ-Tɛkɛɓɛ, ka Yelusalɛma, ka Yudɛa na kʉsyakʉ wa Yɔlɔdanɨ. ");
INSERT INTO lik_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Nɨyɔ Yeso ʉmina ɓambaza ka ɓambanzʉ, aɗaka ndɨ ka ngʉpa, iko, ɓaɓɨɓya kakɨ ɓakpuɗoku ndɨ. ");
INSERT INTO lik_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Apʉnga kʉwa ndɨ kaʉtɨwa ɓɛ: ");
INSERT INTO lik_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Ɨgyagya ka nɨɓɔ ɓa na yangya ka mambɛngɨ, kyɛ ɓʉngama ɓa kʉgʉ wa lɨsyɛ a ɓa kaɓʉ. ");
INSERT INTO lik_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ɨgyagya ka nɨɓɔ ɓakalya kumbu, kyɛ Kunzi utumisatʉ ndɛkɛ mambɛngɨ. ");
INSERT INTO lik_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ɨgyagya ka nɨɓɔ ɓa ɓitombiii, kyɛ ɓinisanatʉ ndɛkɛ na lisimo nɨlɔ Kunzi ʉwanyaga ndɨ. ");
INSERT INTO lik_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ɨgyagya ka nɨɓɔ ɓa na nza na mʉsasa kagya lɨkpʉmʉka lɔ ngbingbili ko misa ko Kunzi, kyɛ ɓikutagatʉ ndɛkɛ. ");
INSERT INTO lik_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ɨgyagya ka nɨɓɔ ɓʉmɨnɨlyaga ɓɛngɛnɨ kumbu, kyɛ Kunzi ʉmɨnyɨlya ndɛkɛ ɨɓʉ ɓɛgɛyɔ. ");
INSERT INTO lik_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ɨgyagya ka nɨɓɔ ɓa na mambɛngɨ manza, kyɛ ɓamɨnatʉ ndɛkɛ Kunzi. ");
INSERT INTO lik_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ɨgyagya ka nɨɓɔ ɓakapá mazɨyɔ, kyɛ ɓʉmaka ndɛkɛ ɓɛ ɓomiko-Kunzi. ");
INSERT INTO lik_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ɨgyagya ka nɨɓɔ ɓakaugyogyiso kyɛ ɓakagya nɨmɔ okwononi ko misa ko Kunzi, kyɛ ɓʉngama ɓa kʉgʉ wa lɨsyɛ a ɓa kaɓʉ. ");
INSERT INTO lik_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Gwoni magyagya kika nɨ ɓakamʉtʉmbwa, ɓanamugyogyiso, ɓanamʉɓʉkʉlyaga makpʉmʉka manyɛnyɛ ko bulya kamɨ. ");
INSERT INTO lik_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Gwoni magyagya kʉgbɛ, miko ka magyagya aka! Kyɛ minisono ndɛkɛ na mʉkalya mudingi kʉgʉ wa lɨsyɛ. A ɓɛyɔ, a mʉɗɔngɔnɨ ɓɛgɛyɔ ɓugyogyisa ndɨ mino ɓogyalandʉ nɨɓɔ ɓodoku ndɨ kambwa kunu.» ");
INSERT INTO lik_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«Iɓunu, ma liniko ka ɔɓɨlɨ. Luki limoti, liniko kandapamanaga, luki tino ɓata lɔ akwanana kondingimosogo? Kikigʉ ɓata na ɨzangɨya, luki limoti ɓomisya kʉwa kunzi, ɓambanzʉ ɓaɗɨtaga. ");
INSERT INTO lik_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Iɓunu, ma ɓʉngbanganya ka ɔɓɨlɨ. Gʉɗʉ nɨnɔ ipiko kʉgʉ wa ngʉpa kakwananɨgʉ kaɨsʉma. ");
INSERT INTO lik_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ɓakatʉnagɨgʉ tala ɓɛ ɓagbukumisyi ɓata na mʉmbɨ. Luki limoti, ɓabisaga kʉgʉ, ka pa nɨyɔ ɓabisogo mino kyɛ uzigi ɓatʉ ɓasɨ nɨɓɔ ɓa ka ndaɓʉ. ");
INSERT INTO lik_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Okwononi ɓɛ ɓʉngbanganya kunu iki ɓɛyɔ ko misa ka ɓambanzʉ. Ɓika kaɨna yɨgya kunu yanza, ɓabibiso Obonu nɨnɔ a kʉgʉ wa lɨsyɛ.» ");
INSERT INTO lik_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«Makosimonitɔgʉ ɓɛ nodoku ndɨ kolimogo Mʉtʉʉ ka Musa, ikanɨ nɨmɔ ɨɓɨkya ndɨ na ɓogyalandʉ. A ɓɛyɔ, ɨmɨ, nakodokugʉ kolimogo, luki limoti, nodoku kotulyasa masɨ. ");
INSERT INTO lik_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","A lɨngʉnʉ, nakamʉɓɨkya ambɛ, ngbingo yi nɨnɔ lɨsyɛ na ɔɓɨlɨ a mbɛyɨ ɓata mino aka, kɛgʉ na ɨkya liɓiso gʉtʉgʉ limoti aka la Mʉtʉʉ nɨlɔ akwanana kolimiko, gʉtʉgʉ ɨkya lɨngbɛtɨ li aka, kambwa ɓɛ makpʉmʉka mi nɨmɔ masɨ igyonosi. ");
INSERT INTO lik_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Kinili, mʉtʉ wasɨ nɨnɔ oɓuno mʉtʉʉ gʉtʉgʉ nɨmɔ makɛɗɛ aka, uwonisila ɓatʉ ɓagɔgɔ kagya ɓɛgɛyɔ, ɨyɨ ɓɨkpɛ nɔ ika ndɛkɛ mʉtʉ wa payaya kʉgbɛ ka Ɓʉngama ɓa kʉgʉ wa lɨsyɛ. Luki limoti, mʉtʉ nɨnɔ akagya mʉtʉʉ, uwonisila ɓatʉ ɓagɔgɔ kagya ɓɛgɛyɔ, ɨyɨ nɔ ika ndɛkɛ mʉtʉ wa ɨbɨba kʉgbɛ ka Ɓʉngama ɓa kʉgʉ wa lɨsyɛ. ");
INSERT INTO lik_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nakamʉɓɨkya ambɛ, okwononi yɨgya kunu iki yanza kakɨtaga nɨyɔ ka Ɓafalisayɔ na ɓowonisila ɓa mʉtʉʉ. Kiki ɓɛyɔ, makingyigʉ ndɛkɛ ka Ɓʉngama ɓa kʉgʉ wa lɨsyɛ.» ");
INSERT INTO lik_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«Mʉkanatʉ ndɨ ɓɛyɔ ɓʉɓɨkya ndɨ mino ɓotitonu ɓɛ: ‹Wakamwonitɔgʉ mʉmbanzʉ. Mʉmbanzʉ kamwɔ dakɨ, ɓaga na ɨyɨ ka ngbanga.› ");
INSERT INTO lik_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Luki limoti, ɨmɨ, nakamʉɓɨkya ambɛ, mʉmbanzʉ kika na lɨngangɨ na dakɨ, okwononi ɓaga na ɨyɨ ka ngbanga. Na kika nɨ atumbwini mamakɨ ɓɛ: ‹Wa ngingi!›, okwononi ɓaga na ɨyɨ ka Basa-Yidingi. Katʉmbwa gɔnɨ ɓɛ: ‹Wa mʉtʉ wa ibikyasʉ!›, okwononi ɓaɗɨkɨtɨ ko ɓuku ɓa ɓɛnzɛ na ɓɛnzɛ! ");
INSERT INTO lik_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Kika nɛkɨ nɨ wakaɨnda kapá Kunzi apɛpɛ ka gbɔgbɔ, watamana ɓɛ makɛgʉ kaʉkanana na mamakʉ, ");
INSERT INTO lik_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","wasa mbɛyɨ apɛpɛ kakʉ kambwa wa gbɔgbɔ wa, waga kaʉkanana na ɨyɨ. Kumbuso yi, wodoku sɛ kʉwa kapá. ");
INSERT INTO lik_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Hʉkanana ɓɨgala-gala na mumuyoniso kakʉ nɨ ma mbɛyɨ na ɨyɨ ko pisi aka kambwa kadwɛ ka zozi. Kiki ɓɛyɔ, ɨyɨ udwisatʉ ka zozi, zozi ukitisaga ka polisi, polisi ugwi. ");
INSERT INTO lik_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","A lɨngʉnʉ, nakaʉɓɨkya ambɛ, wakopupigʉ kʉ ɓɛyɔ kanɨ wakanokolyigʉ ɓuyi ɓasɨ nɨɓɔ ika nɨ ɓukuni.» ");
INSERT INTO lik_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«Mʉkanatʉ ndɨ ɓɛyɔ ɨɓɨkyo mino ɓɛ: ‹Wakosyonitɔgʉ na muko ikanɨ mbʉnya ɓɛngɛnɨ.› ");
INSERT INTO lik_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Luki limoti, ɨmɨ, nakamʉɓɨkya ambɛ mʉmbanzʉ kanda muko na mʉsasa, ika kanɨ osyini na ɨyɨ pisi ka lɨmbɛngɨ kakɨ. ");
INSERT INTO lik_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Liso kakʉ la kumbanzɨkanɨkɔ kumokyisiso ka ɓʉnyɛ, muko, wombimbo ɓyɨ na ɨwɛ. A ɓɛyɔ, a ɓɨnza kombimbo pa yimoti ya nzʉyɨ kakʉ, nɨ ɓakombimbigʉ nzʉyɨ kakʉ yasɨ ko ɓuku ɓa ɓɛnzɛ na ɓɛnzɛ. ");
INSERT INTO lik_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Kʉɓɔkʉkɔ kakʉ kwa kumbanzɨkanɨkɔ kumokyisiso ka ɓʉnyɛ, kɔ, wombimbo ɓyɨ na ɨwɛ. A ɓɛyɔ, a ɓɨnza kombimbo pa yimoti ya nzʉyɨ kakʉ, nɨ ɓakombimbigʉ nzʉyɨ kakʉ yasɨ ko ɓuku ɓa ɓɛnzɛ na ɓɛnzɛ.» ");
INSERT INTO lik_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«Ɨɓɨkyatʉ ndɨ gɔnɨ ɓɛ: ‹Mʉmbanzʉ kasikisa mukakɨ, apɨ́ balʉwa yi nɨnɔ asikisi na ɨyɨ.› ");
INSERT INTO lik_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Luki limoti, ɨmɨ, nakamʉɓɨkya ambɛ, mʉtʉ wasɨ kasikisa mukakɨ, kiki nɨ agwini na mʉlʉkʉ aka, ahukwilyini muko yi nɨnɔ pisi kasyɛ na mʉlʉkʉ wodi. Mʉtʉ wasɨ kava muko yi nɨnɔ, ɨyɨ gɔnɨ ogyini ɓɨlya.» ");
INSERT INTO lik_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«Mʉkanatʉ ndɨ gɔnɨ ɓɛyɔ ɓʉɓɨkya ndɨ mino ɓotitonu ɓɛ: ‹Wakakonitɔgʉ silika waɓɔngɔ kambwa ka Mombukwono-dosu. Luki limoti, gyogoni masɨ nɨmɔ makʉlya ndɨ mina silika.› ");
INSERT INTO lik_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Luki limoti, ɨmɨ, nakamʉɓɨkya ambɛ makakogonitɔgʉ. Gʉtʉgʉ ko lino la kʉgʉ wa lɨsyɛ, kyɛ a kiti wa ɓʉngama ko Kunzi. ");
INSERT INTO lik_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Gʉtʉgʉ ko lino la ɔɓɨlɨ, kyɛ a ɓuliki nɨɓɔ Kunzi ibisago mina magʉ. Gʉtʉgʉ ko lino la gʉɗʉ wa Yelusalɛma aka, kyɛ a gʉɗʉ ka Ngama mudingi. ");
INSERT INTO lik_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Makakogonitɔgʉ silika ka ɓamʉ kunu, kyɛ makakwananɨgʉ koɓuɓiso ikanɨ kopiyasa litukatʉ gʉtʉgʉ limoti aka la ɓamʉ kunu. ");
INSERT INTO lik_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Makabaɨlya lɨkpʉmʉka, ɓɛ ‹Iyo› iki kʉwa ɓɛyɔ aka yɔ. Makanganya ɓɛ ‹Haaa›, manganya kʉwa lɨngʉnʉ aka. Kyɛ lɨkpʉmʉka nɨlɔ ɓamatɨlaga ɓata kʉgʉ yi, apʉnyaga ka Mumuyoniso.» ");
INSERT INTO lik_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","«Mʉkanatʉ ndɨ ɓɛyɔ ɨɓɨkya ndɨ mino ɓɛ: ‹Liso ko liso, lanzʉ ka lanzʉ.› ");
INSERT INTO lik_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Luki limoti, ɨmɨ, nakamʉɓɨkya ambɛ, makigisonitɔgʉ ɓʉnyɛ ka ɓʉnyɛ. Mʉmbanzʉ kʉɓɨta ka panga ya kumbanzɨkanɨkɔ, wayikosilya gɔnɨ nɨyɔ yagɔgɔ. ");
INSERT INTO lik_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Mʉmbanzʉ kapa kaʉsʉngɨlya kyɛ avɨ simizi kakʉ, wasɨlya gɔnɨ koti kakʉ. ");
INSERT INTO lik_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Mʉmbanzʉ kʉkpamya ka mapʉpʉ ɓɛ mʉbɨnɨkɨlya likumbogi kabisilyoku ka kilomɛtɛlɛ yimoti, wabisilya kʉwa ka kilomɛtɛlɛ yɨɓa. ");
INSERT INTO lik_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mʉmbanzʉ kʉkʉnga luki, wapá. Mʉmbanzʉ kʉkʉnga ɓɛ mukupisa luki, wakamongonyilyonitɔgʉ.» ");
INSERT INTO lik_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«Mʉkanatʉ ndɨ ɓata ɓɛyɔ ɨɓɨkya ndɨ mino ɓɛ: ‹Mʉpa wai-dakʉ, wamʉya mumuyonisa kakʉ.› ");
INSERT INTO lik_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Luki limoti, ɨmɨ, nakamʉɓɨkya ambɛ huponi ɓomuyoniso kunu. Hulumbilyoni nɨɓɔ ɓakamugyogyiso. ");
INSERT INTO lik_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Kʉwa wa, mika ɓomiko Obonu nɨnɔ a kʉgʉ wa lɨsyɛ. A ɓɛyɔ, ɨyɨ opupisaga mɔnɨ ka ɓambanzʉ ɓanza na gʉtʉgʉ ka nɨɓɔ ɓanyɛ aka. Olukusaga mbwayɨ ka ɓatʉ ɓongbingbili na gʉtʉgʉ ka nɨɓɔ ɓakɛgʉ ɓongbingbili aka. ");
INSERT INTO lik_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kika nɨ mʉpaga nɨɓɔ aka ɓɔ ɓamʉpaga, minisana na ɨzangɨya tino? Gʉtʉgʉ ɓandɔmbɛ ɓa manzanza aka ɓʉpaga ɓawai-daɓʉ ɓɛgɛyɔ! ");
INSERT INTO lik_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Kika nɨ mumuusogo ɓomomonu aka, magyaga likpʉmʉka lɨmbanga tino kaʉkɨtaga ɓatʉ ɓagɔgɔ? A ɓɛyɔ, gʉtʉgʉ ɓatʉ nɨɓɔ ɓakamibigʉ Kunzi, ɓagyaga ɨɓʉ ɓɛgɛyɔ! ");
INSERT INTO lik_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Wikoni nɛkɨ ɓanza, mʉɗɔngɔnɨ ɓɛyɔ Obonu nɨnɔ kʉgʉ wa lɨsyɛ o mina wanza.» ");
INSERT INTO lik_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«Wiɓuulyonito, makikonitɔgʉ kaipupisa ko misa ka ɓambanzʉ ngbingo yi nɨnɔ mo mino kagya ɓʉnza. Kyɛ makagya ɓɛyɔ, makinisonigʉ na ɨzangɨya kotukyoku ko Obonu nɨnɔ a kʉgʉ wa lɨsyɛ. ");
INSERT INTO lik_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Kʉwa wa, ngbingo yi nɨnɔ wasingyi mino mʉtʉ wa yangya, wakibibonitɔgʉ. A ɓɛyɔ, ɓatʉ ɓa kʉɓɔɓɔkʉ ɓɔ ɓagyaga ɓɛyɔ ka ɓandaɓʉ kaɓʉ ɓaya malʉmba, ka ɓopisi kyɛ ɓambanzʉ ɓiki kaʉbɨba. A lɨngʉnʉ, nakamʉɓɨkya ambɛ, ɨɓʉ ɓinisononi kʉwa na ɨzangɨya kaɓʉ. ");
INSERT INTO lik_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Luki limoti, ngbingo yi nɨnɔ wo mino kapá mʉtʉ wa yangya luki, kʉɓɔkʉkɔ kakʉ kwa kulekuke kibonitɔgʉ nɨyɔ kʉɓɔkʉkɔ kwa kumbanzɨkanɨkɔ akagya. ");
INSERT INTO lik_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Okwononi yɨgya yi nɨyɔ iki ko dikiɗi. Na Abakʉ nɨnɔ akaɨna gɔnɨ nɨlɔ wakagya ko dikiɗi, ʉkalyatʉ.» ");
INSERT INTO lik_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«Ngbingo yi nɨnɔ miko mino kalʉmba, makikonitɔgʉ mʉɗɔngɔnɨ abɛ ɓatʉ ɓa kʉɓɔɓɔkʉ. Ɨɓʉ ɓapaga kalʉmba ɓomononini ɓɨgba ka ɓandaɓʉ kaɓʉ ɓaya malʉmba na ka ɓakpɔlɔ-kpɔlɔ ɓaya ɓopisi. A lɨngʉnʉ, nakamʉɓɨkya ambɛ, ɨɓʉ ɓinisononi kʉwa na ɨzangɨya kaɓʉ. ");
INSERT INTO lik_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Luki limoti, ɨwɛ, ngbingo yi nɨnɔ wo mina kalʉmba, wingyo ka ndaɓʉ ya kʉsɔ. Wɨdʉlaga mupumi, wakʉnga Abakʉ nɨnɔ a wa ka pa yo dikiɗi. Ɨyɨ Abakʉ nɨnɔ akaɨna nɨlɔ wakagya ko dikiɗi, ʉkalyatʉ. ");
INSERT INTO lik_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ngbingo yi nɨnɔ mo mina kalʉmba, makikonitɔgʉ kaɨgɨlyaga lɨkpʉmʉka limoti ɓɨkyɔ mʉɗɔngɔnɨ ɓɛyɔ ɓatʉ nɨɓɔ ɓakamibigʉ Kunzi ɓakagyo mino. A ɓɛyɔ, mʉtamanagɨ kaɓʉ a ɓɛ Kunzi ʉmʉkana kyɛ ɓanzɨnaga yakpʉ. ");
INSERT INTO lik_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Makogyonitɔgʉ mʉɗɔngɔnɨ abɛ ɨɓʉ. Kyɛ kambwa kakʉnga, Obonu akaiba mʉsasa kunu.» ");
INSERT INTO lik_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","«Iɓunu, makwanana nɛkɨ kaika kalʉmbaga ɓɛ: ‹Obosu nɨnɔ kʉgʉ wa lɨsyɛ, ɓambanzʉ ɓasɨ ɓibi ɓɛ, lino kakʉ a lotu. ");
INSERT INTO lik_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ɓʉngama kakʉ oduku, sɨpananɨsɔ kakʉ igyonosi, ka lɨtɔmbʉ mʉɗɔngɔnɨ abɛ kʉgʉ wa lɨsyɛ. ");
INSERT INTO lik_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Tɨpánɔ masyɛ masɨ, malɨlɨ nɨmɔ okwononi na iɓusu. ");
INSERT INTO lik_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Tɨpɨlyanɔ luɓu kusu, mʉɗɔngɔnɨ ɓɛyɔ iɓusu tʉpɨlyago mino ɓatʉ nɨɓɔ ɓikaga no luɓu kusu. ");
INSERT INTO lik_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Wakatisonitɔgʉ kogwa ka kʉɓɔɓɔkʉ, luki limoti, tiɓuulyogo ka mumuyoniso. Kyɛ ɓʉngama, ngu na ɨbɨba a ɓa kakʉ, ka ɓɛnzɛ na ɓɛnzɛ! Iyo a ɓɛyɔ.›» ");
INSERT INTO lik_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Yeso aɓɨkya ndɨ ɓata ɓɛ: «A ɓɛyɔ, kika nɨ mʉpɨlyagatʉ ɓomomonu ɓʉnyɛ kaɓʉ, Obonu nɨnɔ kʉgʉ wa lɨsyɛ amʉpɨlyatʉ ndɛkɛ gɔnɨ iɓunu. ");
INSERT INTO lik_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Luki limoti, makupilyogi ɓomomonu, Obonu kamʉpɨlyɨgʉ ndɛkɛ ɓɛgɛyɔ.» ");
INSERT INTO lik_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«Ngbingo yi nɨnɔ mo mina kakya malɨlɨ ko ngbingo, makikonitɔgʉ misa mundindilo mʉɗɔngɔnɨ abɛ ɓatʉ ɓa kʉɓɔɓɔkʉ. Ɨɓʉ ɓondindilaga miso ɓɛyɔ kauwonisilo ɓambanzʉ ɓasɨ ɓɛ ɓoginyini malɨlɨ ko ngbingo. A lɨngʉnʉ, nakamʉɓɨkya ambɛ, ɨɓʉ ɓinisononi kʉwa na ɨzangɨya kaɓʉ. ");
INSERT INTO lik_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Luki limoti, ɨwɛ, ngbingo yi nɨnɔ wo mina kakya malɨlɨ ko ngbingo, wɨsʉkʉsa misa ɓɨngɔ na wɨbʉma malazi ɓipupupu ka mʉ. ");
INSERT INTO lik_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Kʉwa wa, ɓambanzʉ ɓakibigʉ ɓɛ wakakya malɨlɨ ko ngbingo ko bulya kaɓʉ. Luki limoti, ko bulya ka Abakʉ nɨnɔ a wa ka pa yo dikiɗi. Ɨyɨ Abakʉ nɨnɔ akaɨna nɨlɔ wakagya ko dikiɗi, ʉkalyatʉ.» ");
INSERT INTO lik_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«Makikonitɔgʉ kapɨmbya lɨngama wa ka ɔɓɨlɨ wa. Makagya ɓɛyɔ, ɓakɛkɛɗʉ ɓalyatʉ na nzʉma apʉta. Ɓatʉ ɓo kuɓakʉ ɓakwanana gɔnɨ koɓuna ndaɓʉ, ɓiɓo. ");
INSERT INTO lik_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Luki limoti, pimbyogoni lɨngama kunu kʉgʉ wa lɨsyɛ. Kʉ ɓɛyɔ, ɓakɛkɛɗʉ ɓakalyɨgʉ na nzʉma kapʉtɨgʉ. Ɓatʉ ɓo kuɓakʉ ɓakakwananɨgʉ gɔnɨ koɓuna ndaɓʉ na kaiɓo. ");
INSERT INTO lik_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","A ɓɛyɔ, pa yi nɨyɔ mukumba kakʉ o mino, lɨmbɛngɨ kakʉ ika kʉ gɔ kʉ.» ");
INSERT INTO lik_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«Miso a tala wa nzʉyɨ. Misa kakʉ kiki no koloɓu, nzʉyɨ kakʉ yasɨ ika ka ɓʉngbanganya. ");
INSERT INTO lik_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Luki limoti, miso kakʉ kidwonoso, nzʉyɨ kakʉ yasɨ ika ko biti. Kika nɛkɨ nɨ ɓʉngbanganya nɨɓɔ a kʉsɔ kakʉ a abɛ biti, biti yi nɨyɔ ika kʉwa yopi kʉgbɛ.» ");
INSERT INTO lik_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«Mʉtʉ ɓemoti kakwananɨgʉ kaugugubya ɓangama ɓaɓa. A ɓɛyɔ, amʉya ɓemoti, apa wagɔgɔ, ikanɨ ɨgʉmya ka ɓemoti, amɨna wagɔgɔ payaya. Makakwananɨgʉ kagugubya ko ngbinga ɓemoti Kunzi no ɓuyi.» ");
INSERT INTO lik_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«Kinili, ɨmɨ, nakamʉɓɨkya ambɛ: Makigbomisonitɔgʉ ɓamʉ ko bulya ɔɓɨlɨ kunu, iki ko bulya malɨlɨ ikanɨ luki limwo, iki ka nzʉyɨ kunu ikanɨ ko luki la kimokisyo. A ɓɛyɔ, ɔɓɨlɨ kunu a na ɨzangɨya kʉgbɛ kakɨtaga malɨlɨ, na nzʉyɨ kunu a na ɨzangɨya kʉgbɛ kakɨtaga ɓotu. ");
INSERT INTO lik_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Huminoni mbɛyɨ ɓombu! Ɓakakʉnagɨgʉ, ɓakobuulyogigʉ, ɓakɛgʉ na pa nɨyɔ ɓobisaga mina masɔlɔ. Obonu nɨnɔ kʉgʉ wa lɨsyɛ ulyolisagatʉ! Wɨna sɛ, iɓunu, ma na ɨzangɨya yidingi kʉgbɛ kaʉkɨtaga ɓombu! ");
INSERT INTO lik_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Wanɨ nɔ akwanana luga kunu, pisi kaigbomisa mʉ, kosisilo mina masyɛ ma ɔɓɨlɨ kakɨ? ");
INSERT INTO lik_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ko bulya ɨkɨ yɔ mo mino kaigbomisa ɓamʉ ko bulya ɓotu? Wondoni mbɛyɨ maʉwa mo tutu ɓizumuuu, winoni ɓɛyɔ aɓakago mino: kagyagɨgʉ ligubo, kakʉɓagɨgʉ ɓotu. ");
INSERT INTO lik_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Luki limoti, nakamʉɓɨkya ambɛ, gʉtʉgʉ ngama Sɔlɔmɔnɔ aka ka ɨbɨba kakɨ yasɨ, kimokisyagʉ ndɨ kutuko kwanza gʉtʉgʉ kumoti aka abɛ lɨʉwa limoti luga wa nɨma. ");
INSERT INTO lik_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Kika nɛkɨ nɨ Kunzi akomokisyogo mapakʉ mo tutu nɨmɔ a na lɨsyɛ li nɨlɨ wa, na ɓʉgala ɓaɗɨkɨta ko ɓuku. Ko bulya ɨkɨ yɔ kakwananɨgʉ mino kamumokisyogo iɓunu ɓɨkpɛ? Eeeze, sɛ kʉwa iɓunu ɓana ma na baya yɨkɛɗɛ aaa! ");
INSERT INTO lik_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Makigbomisonitɔgʉ nɛkɨ ɓamʉ ɓɛ: ‹Talya sɛ ɨkɨ? Tomwo ɨkɨ? Ikanɨ timokisyo ɨkɨ?› ");
INSERT INTO lik_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","A ɓɛyɔ, ɓatʉ nɨɓɔ ɓakamibigʉ Kunzi ɓɔ ɓikaga kaamama kakɨsa masɨ nɨmɔ. Obonu nɨnɔ kʉgʉ wa lɨsyɛ ibagatʉ ɓɛ ma na mʉsasa ma makpʉmʉka mi nɨmɔ. ");
INSERT INTO lik_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Iɓunu, kisoni mbɛyɨ Ɓʉngama ko Kunzi na kaɓyɛ ɓungbingbili nɨɓɔ apaga. Ɨyɨ, amʉmatɨlyatʉ makpʉmʉka magɔgɔ masɨ kʉgʉ yi. ");
INSERT INTO lik_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Kinili, makigbomisonitɔgʉ nɛkɨ ɓamʉ ko bulya ɓʉgala. Ɓʉgala ɨkɨsɨlya nɨ ɨyɨ mombukwana-dakɨ yi. Masyɛ masɨ a na ɓʉkpɛkɨ-kpɛkɨ kakɨ.» ");
INSERT INTO lik_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","«Makokonitɔgʉ mʉkɔmbʉ ka mʉmbanzʉ, iba Kunzi kamukulyonitɔgʉ nɨmɔ kunu ɓɛgɛyɔ. ");
INSERT INTO lik_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","A ɓɛyɔ, Kunzi amʉkʉlya ndɛkɛ mʉkɔmbʉ mʉɗɔngɔnɨ ɓɛyɔ mʉkʉlyago mina ɓɛngɛnɨ. Mʉɗɔngɔnɨ ɓɛyɔ mʉgyago mino ɓɛngɛnɨ, Kunzi amumigisilya ndɛkɛ iɓunu mʉɗɔngɔnɨ ɓɛgɛyɔ. ");
INSERT INTO lik_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ko bulya ɨkɨ yɔ wo mina kamɨna asɨ okuku aka nɨnɔ a ko lisa ka mamakʉ, nɨ wakɛgʉ sɛ kaɨna ingbi nɨyɔ a ka nɨlɔ kakʉ? ");
INSERT INTO lik_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Wakwanana kaɓɨkya mamakʉ lɨkɨ ɓɛ: ‹Gya mbɛyɨ nʉnyʉ okuku ko lisa kakʉ›, nɨ ka nɨlɔ kakʉ ka mombukwana-dakɨ yi a na ingbi? ");
INSERT INTO lik_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Mʉtʉ wa kʉɓɔɓɔkʉ! Wɨnyɔ mbɛyɨ ingbi nɨyɔ a ko lisa kakʉ. Kumbuso yi, wakwanana kʉwa kaɨna ɓɨngbanganya kanyɔ okuku ko lisa ka mamakʉ. ");
INSERT INTO lik_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Makumbimbilyonitɔgʉ ɓɛnva makpʉmʉka nɨmɔ ɓapága Kunzi, kyɛ ɓakwanana kamuikyonilyo, ɓamʉkʉkaga. Na makumbimbilyonitɔgʉ ɓangʉya makpʉmʉka kunu ma lɨsɨka, kyɛ ɓakwanana koɓunaga na magʉ ɓɨkpwɛkpwɛkpwɛ.» ");
INSERT INTO lik_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«Kungoni, ɓamʉpátʉ. Kisoni, minisanatʉ nolu. Yiponi holi, ɓamuhukwilyatʉ. ");
INSERT INTO lik_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","A ɓɛyɔ, mʉtʉ wasɨ nɨnɔ akʉngaga, ɓapágatʉ. Nɨnɔ akɨsaga, inisanagatʉ nolu. Na nɨnɔ ayipaga holi, ɓahukwilyagatʉ mupumi. ");
INSERT INTO lik_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Wanɨ nɔ luga kunu akwanana kapá mikakɨ lɨtalʉ nɨ akungini mukati? ");
INSERT INTO lik_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ikanɨ kakʉnga musi, akwanana lɨkɨ kapá nzʉka? ");
INSERT INTO lik_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Gʉtʉgʉ ɓɛyɔ mo mino ɓanyɛ yɔ, luki limoti, mibagatʉ kaʉpá ɓomiki kunu makpʉmʉka manzanza. Obonu nɨnɔ kʉgʉ wa lɨsyɛ akwanana kapá mʉtʉ wasɨ nɨnɔ akʉngaga makpʉmʉka manzanza kakɨtaga. ");
INSERT INTO lik_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Masɨ nɨmɔ mapaga ɓɛ ɓamʉgyɨlyɨ, hugyilyoni ɓɛngɛnɨ ɓɛgɛyɔ. Ikpikaga ɓɛyɔ ka Mʉtʉʉ ka Musa na ka ɓakɨtaɓʉ ka ɓogyalandʉ.» ");
INSERT INTO lik_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«Wingyogoni pisi ka mupumi makpwɔ. A ɓɛyɔ, mupumi ma kɨnda ka ɓʉnyɛ a makpʉ na pisi yi yahʉ. Na ɓatʉ ɓudingi ɓaɓyɛgɛ kʉ ɓɛyɔ. ");
INSERT INTO lik_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Luki limoti, mupumi ma kɨnda ka ɔɓɨlɨ wa ɓɛnzɛ a makpwɔ, pisi yi a ɓɨmbɨtɨtɨ. Nɨɓɔ ɓakɨtaga kʉ, ɓa ɓakɛɗɛ.» ");
INSERT INTO lik_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«Wiɓuulyonito na ɓogyalandʉ ɓa ɓɔngɔ. Ɓamudulyogoku mʉɗɔngɔnɨ abɛ ɓakɔndɔlɔ, luki limoti, ka mambɛngɨ kaɓʉ, ɓa ɓosukopi. ");
INSERT INTO lik_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mumibaga ndɛkɛ pisi ka yɨgya kaɓʉ. Ɓakapwagɨgʉ bumo ya muzabibu ka muligi mo mowo. Ɓakapwagɨgʉ gɔnɨ bumo yanza ka sɨbʉkʉsɔ so mowo. ");
INSERT INTO lik_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Kinili, sɨbʉkʉsɔ sanza aɓʉkʉtaga bumo yanzanza, nɨsɔ sanyɛ aɓʉkʉta bumo yanyɛnyɛ gɔnɨ. ");
INSERT INTO lik_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Sɨbʉkʉsɔ sanza kakwananɨgʉ kaɓʉkʉta bumo yanyɛnyɛ, na sɨbʉkʉsɔ sanyɛ kakwananɨgʉ kaɓʉkʉta bumo yanzanza. ");
INSERT INTO lik_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Sɨbʉkʉsɔ sasɨ nɨsɔ kaɓʉkʉtagɨgʉ bumo yanza, ɓagbɨtatʉ, ɓaɗɨkɨta ko ɓuku. ");
INSERT INTO lik_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","A ɓɛyɔ, mumibaga ndɛkɛ ɓogyalandʉ ɓa ɓɔngɔ pisi ka yɨgya kaɓʉ.» ");
INSERT INTO lik_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«Kɛgʉ ɓatʉ ɓasɨ nɨɓɔ ɓɛmakaga ɓɛ: ‹Mombukwono-dosu, Mombukwono-dosu!› ɓɔ ɓogulyo ndɛkɛ ka ɓʉngama ɓa kʉgʉ wa lɨsyɛ. Luki limoti, a nɨnɔ aka nɔ akagya sɨpananɨsɔ ka Baba nɨnɔ a kʉgʉ wa lɨsyɛ. ");
INSERT INTO lik_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ka lɨsyɛ li nɨlɔ, ɓambanzʉ ɓudingi ɓɛɓɨkyatʉ ndɛkɛ ɓɛ: ‹Heɓe Mombukwono-dosu, Mombukwono-dosu! Takanzɨnagɨgʉ mbɛyɨ ndɨ na ɓugyalandʉ ko lino kakʉ? Tanokpumyo mambɛngɨ ma ɓʉnyɛ, tagya makpʉmʉka mʉmbanga-mbanga mudingi?› ");
INSERT INTO lik_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","A ɓɛyɔ, nʉɓɨkya ndɛkɛ ɓɨngbanganya ɓɛ: ‹Ɨmɨ, nakamumibagʉ ndɨ ɨmɨ gʉtʉgʉ iki yi aka. Tukyoni ɓuwobi na ɨmɨ, iɓunu ɓagya-manyɛ!›» ");
INSERT INTO lik_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«A ɓɛyɔ, mʉmbanzʉ nɨnɔ ʉkanaga lɨkpʉmʉka kamɨ, anagya ɓɛyɔ iɓikyi mino, ika ndɛkɛ mʉɗɔngɔnɨ abɛ mʉtʉ wa yimibo nɨnɔ opika ndɨ ndaɓʉ kakɨ kʉgʉ wa lɨtalʉ. ");
INSERT INTO lik_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ngbingo yi nɨnɔ mbwayɨ alʉka ndɨ mino, moɓo otumogo, muvivi mapʉ okukwa ndɨ ka ndaɓʉ yi nɨyɔ. Luki limoti, koɗukanagʉ ndɨ kyɛ ɓakpɔ ndɨ muɓumbe mi kʉgʉ wa lɨtalʉ. ");
INSERT INTO lik_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Luki limoti, mʉmbanzʉ nɨnɔ ʉkanaga lɨkpʉmʉka kamɨ nɨ kɛgʉ kagya ɓɛyɔ iɓikyi mino, ika ndɛkɛ mʉɗɔngɔnɨ abɛ ngingi. Kyɛ opika ndɨ ndaɓʉ kakɨ kʉgʉ wo mbumi. ");
INSERT INTO lik_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ngbingo yi nɨnɔ mbwayɨ alʉka ndɨ mino, moɓo otumogo, muvivi mapʉ okukwa ndɨ ka ndaɓʉ yi nɨyɔ. Kʉwa wa, oɗukana ndɨ wasɨ ɓɨgbatata.» ");
INSERT INTO lik_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Nɨyɔ Yeso ama ndɨ mino kanzɨna ɓɛyɔ, ɓambaza ka ɓambanzʉ ɓombombaya ndɨ kʉgbɛ ka inguo ya mʉtʉʉ kakɨ. ");
INSERT INTO lik_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","A ɓɛyɔ, mʉtʉʉ kakɨ a ndɨ no ngu nɨ kɛgʉ mʉɗɔngɔnɨ abɛ nɨmɔ ka ɓowonisilo kaɓʉ ɓa mʉtʉʉ. ");
INSERT INTO lik_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ngbingo yi nɨnɔ Yeso osya ndɨ mino ka ngʉpa, ambaza mudingi ka ɓambanzʉ a ndɨ kaɓyɛ ɓingbooo. ");
INSERT INTO lik_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Kʉwa wa, keɓu-keɓu ɓemoti akpuɗoku ndɨ. Oɓuna moli kambwa kakɨ, aɓɨkya ndɨ ɓɛ: «Hiii, Mombukwono-dosu! Wakapa, wakwanana ɓaka kengumoso.» ");
INSERT INTO lik_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yeso anana ndɨ kʉɓɔkʉkɔ, avɨla. Aɓɨkya ndɨ ɓɛ: «Ɛɛɛ! Noboilyini, ngʉmana!» Wa aka wa, angʉmana ndɨ ɓɨngɔ. ");
INSERT INTO lik_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Kumbuso yi, Yeso agbɨtyaga ndɨ ɓɛ: «Wɨmɨnyatʉ, wakaɓikyonitɔgʉ mʉmbanzʉ gʉtʉgʉ ɓemoti aka! Luki limoti, waga kaimoniso ko kumu, wapá apɛpɛ mʉɗɔngɔnɨ ɓɛyɔ Mʉtʉʉ ka Musa aɓɨkyaga mino, iba mʉtʉ wasɨ ibi ɓɛ woukini ɓi.» ");
INSERT INTO lik_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ngbingo yi nɨnɔ Yeso a ndɨ mino kogulya ka gʉɗʉ wa Kapɛlɛnaumu, ngama ka ɓasʉda akpuɗoku ndɨ, ɨgama na ɨyɨ, ");
INSERT INTO lik_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","aɓɨkya ndɨ ɓɛ: «Kikiliki Mombukwono-dosu, mʉgya-ligubo kamɨ a ɓikpwu ka ndaɓʉ, nzʉyɨ adikogini ɓɨdɛdɛ.» ");
INSERT INTO lik_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yeso asikisya ndɨ ɓɛ: «Nakodoku kahukuso.» ");
INSERT INTO lik_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Luki limoti, ngama yi nɨnɔ asikisya ndɨ ɓɛ: «Eze, Mombukwono-dosu! Nakokwononigʉ ɓɛ wingya ka ndaɓʉ kamɨ. Luki limoti, ɓɨkyanɔ lɨkpʉmʉka limoti aka, mʉgya-ligubo kamɨ ahʉkatʉ. ");
INSERT INTO lik_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","A ɓɛyɔ, gʉtʉgʉ ɨmɨ, na gɔnɨ kusili wa mʉtʉʉ ka ɓangama. Natʉ gɔnɨ na ɓasʉda nɨɓɔ ɓikaga kusili wa mʉtʉʉ kamɨ. Nakaɓɨkya ɓemoti ambɛ: ‹Waga!›, aga. Nakaɓɨkya wagɔgɔ ambɛ: ‹Doku!›, odoku. Na nakaɓɨkya mʉgya-ligubo kamɨ ambɛ: ‹Gya ɓɛnɛ!›, agya ɓɛyɔ aka yɔ.» ");
INSERT INTO lik_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ngbingo yi nɨnɔ Yeso ʉkana ndɨ mino lɨkpʉmʉka li nɨlɔ, ombomboya kʉgbɛ. Ʉɓɨkya ndɨ ɓatʉ nɨɓɔ ɓa ndɨ kaɓɨɓya ɓɛ: «A lɨngʉnʉ, nakamʉɓɨkya ambɛ, luga ka Ɓezaleli ɓasɨ, nakanaminigʉ ndɛkɛ mʉtʉ wa baya yidingi mʉɗɔngɔnɨ abɛ nɨmʉ! ");
INSERT INTO lik_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nakamʉɓɨkya ɓɨngbanganya ambɛ ɓambanzʉ ɓudingi ɓodokuto ndɛkɛ katʉkya ka ɨngɛngɛ na ka Dumbe. Ɓambanzʉ ɓi nɨɓɔ ɓalyalya ndɛkɛ pa imoti na Abalahamʉ, Isaka na Yakɔbɔ ka ɓʉngama ɓa kʉgʉ wa lɨsyɛ. ");
INSERT INTO lik_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Luki limoti, nɨɓɔ ɓɨɓʉkʉta ndɨ ɓɛ ɓingyi ka Ɓʉngama ɓi nɨɓɔ, ɓumbimbo ndɛkɛ kunzi ko biti. Kʉ ɓɛyɔ, ɓagamana ndɛkɛ na kaɨlya manzʉ.» ");
INSERT INTO lik_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Kumbuso yi, Yeso aɓɨkya ndɨ ngama ka ɓasʉda nɔ ɓɛ: «Wɨga kʉ kakʉ! Igyonosi ku kakʉ mʉɗɔngɔnɨ ɓɛyɔ baya kakʉ a mino.» Na ko ngbingo yi nɨnɔ aka nɔ, mʉgya-ligubo kakɨ ahʉka ndɨ. ");
INSERT INTO lik_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Kumbuso yi, Yeso aga ndɨ ka ndaɓʉ ka Pɛtɛlɛ. Kʉ ɓɛyɔ, ogulya ndɨ, atakanya tɨtakɨ Pɛtɛlɛ muko yi wakanga nɨ anɨmʉkana ɓʉdɨ. ");
INSERT INTO lik_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yeso agwi ndɨ kʉɓɔkʉkɔ, ɓʉdɨ asyo. Kʉwa wa, mama nɔ amaga ndɨ, apʉnga kagugubyo Yeso. ");
INSERT INTO lik_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Nɨyɔ ɓʉgɔgɔ osyo, ɓadulyoku ndɨ Yeso na ɓambanzʉ ɓudingi ɓa mambɛngɨ ma ɓʉnyɛ. Yeso okpumya ndɨ mambɛngɨ ma ɓʉnyɛ mi nɨmɔ na mʉnzɨna aka, uhukusa ndɨ ɓatʉ ɓasɨ ɓa ɓokoloɓu. ");
INSERT INTO lik_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Agya ndɨ ɓɛyɔ, kyɛ ɨtʉlyanɨ mʉnzɨna nɨmɔ Mombukwono-dosu aɓɨkya ndɨ pisi ka mugyalandʉ Isaya ɓɛ: «Ɨyɨ, ava ndɨ ɓʉpɔ kusu, abɨnɨka ɓuti ɓa ɓokoloɓu kusu.» ");
INSERT INTO lik_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Nɨyɔ Yeso amɨna ambaza ka ɓambanzʉ akungulini, ʉkpamya ndɨ ɓaɓɨɓya kakɨ ɓɛ ɓazabɨ kʉsyakʉ wa ibombu. ");
INSERT INTO lik_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Kʉwa wa, muwonisilo ɓemoti wa mʉtʉʉ akpuɗoku ndɨ Yeso, aɓɨkya ɓɛ: «Muwonisilo! Ɨmɨ, nʉɓɨɓya pa yasɨ kʉ wɨnda ndɛkɛ mino.» ");
INSERT INTO lik_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yeso asikisya ndɨ ɓɛ: «Ɓanzɨyɔ ɓa na maɓaga, ɓombu ɓa na ɓandaɓʉ. Luki limoti, Mika-mʉmbanzʉ kɛgʉ na pa yakanga na yakimumbiso.» ");
INSERT INTO lik_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Kumbuso yi, ɓemoti luga ka ɓaɓɨɓya kakɨ aɓɨkya ndɨ ɓɛ: «Mombukwono-dosu, ɨsɨlya mbɛyɨ ngbingo kaɨnda kalumba baba.» ");
INSERT INTO lik_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Luki limoti, Yeso asikisya ndɨ ɓɛ: «Ɨwɛ, iɓyeku! Hʉsa ɓamanda, ɓolumbi ɓamanda kaɓʉ.» ");
INSERT INTO lik_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Kʉwa wa, Yeso aɗaka ndɨ ka ɨngbɔlɔ yidingi, pa imoti na ɓaɓɨɓya kakɨ, ɓaga ndɨ. ");
INSERT INTO lik_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ko ngbingo ɓemoti, mbumbo yapʉ apʉnga ndɨ kovivo kʉgʉ wa ibombu. Mʉɓaka a ndɨ ɓuwobi kotikyo ɨngbɔlɔ yidingi. Luki limoti, Yeso a ndɨ nɨ ololini ɓɨpɛ. ");
INSERT INTO lik_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Kʉwa wa, ɓaɓɨɓya ɓisisila ndɨ kazuzukiso, ɓaɓɨkya ɓɛ: «Tihukusanɔ ɓaka, Mombukwono-dosu! Tanolumwogo!» ");
INSERT INTO lik_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yeso usikisya ndɨ ɓɛ: «Ko bulya ɨkɨ yɔ mo mino kaɓanga? Eze, ma na baya yɨkɛɗɛ!» Kʉwa wa, amaga ndɨ, apamɨlya mbumbo na liɓo la ibombu. Pa aka ndɨ lɨngʉnʉ ɓiwo. ");
INSERT INTO lik_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ɓalʉkʉ ɓɔ ɓombombaya ndɨ kʉgbɛ, ɓimuusa ɓɛ: «Mʉtʉ tino pɨyɛ mʉ? Gʉtʉgʉ mbumbo yapʉ no liɓo akamʉkana!» ");
INSERT INTO lik_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ngbingo yi nɨnɔ Yeso ɓazaba ndɨ mino, ɓosila ndɨ ka Ɓagɛlasɨ. Kʉ ɓɛyɔ, ɓatʉ ɓaɓa nɨɓɔ ɓa ndɨ na mambɛngɨ ma ɓʉnyɛ ɓopupoku ndɨ ka ɓekunde, ɓasilya ndɨ Yeso. Ɓatʉ ɓi nɨɓɔ ɓa ndɨ ɓʉɗɨya kʉgbɛ, gʉtʉgʉ mʉmbanzʉ ɓemoti aka kɨkpʉndagɨgʉ ndɨ kaɓyɛ ko pisi yi nɨyɔ. ");
INSERT INTO lik_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ɓapʉnga kʉwa ndɨ kapamɨkanaga ɓɛ: «Miko-Kunzi, nɨlɔ kusu na iɓunu opukogi ɓʉnɨ? Woduku katigyogyiso kambwa ngbingo kaɨtʉlyana?» ");
INSERT INTO lik_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ka kpɔlɔ wa, ambaza mudingi ka ɓangʉya a ndɨ kalyalya. ");
INSERT INTO lik_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Kʉwa wa, mambɛngɨ ma ɓʉnyɛ mɔ ɨtatanaga ndɨ na Yeso ɓɛ: «Kika nɨ watikpumyini, tɨtɨkanɔ ɓaka ka ambaza ka ɓangʉya nɨmʉna kʉ.» ");
INSERT INTO lik_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yeso ʉɓɨkya ndɨ ɓɛ: «Wogoni!» Mambɛngɨ ma ɓʉnyɛ mi nɨmɔ opupo kʉwa ndɨ, ogulyo ka ɓangʉya. Ko ngbingo ɓemoti, ambaza wasɨ ka ɓangʉya yi nɨnɔ okpililoku ndɨ katʉkya ka ngʉpa, ɨɗɨkɨta ka ibombu ɓikudumu, olumwaga ndɨ. ");
INSERT INTO lik_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Nɨyɔ ɓoɓuɓulyo ka ɓangʉya ɓɨna ɓɛyɔ, ɓaga ndɨ mbangʉ ka gʉɗʉ, katʉmbʉlaga masɨ nɨmɔ igyonosa ndɨ mɔ, na nɨlɔ usilya ndɨ ɓatʉ ɓaɓa ɓi nɨɓɔ ɓa ndɨ na mambɛngɨ ma ɓʉnyɛ ɓɔ. ");
INSERT INTO lik_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Kʉwa wa, ɓambanzʉ ɓasɨ ɓa gʉɗʉ ɓɨnda ndɨ kʉ Yeso a ndɨ mino. Nɨyɔ ɓamɨna, ɓɨtatanaga ndɨ na ɨyɨ ɓɛ opupi kʉ kaɓʉ. ");
INSERT INTO lik_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yeso aɗaka ndɨ ka ɨngbɔlɔ yidingi, azaba ɓata ibombu, aga ka Kapɛlɛnaumu ka gʉɗʉ yi nɨnɔ ikaga ndɨ mino. ");
INSERT INTO lik_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Kʉ ɓɛyɔ, ɓadulyoku ndɨ na zɛgɛsɨ wakanga ka kalagba. Nɨyɔ Yeso ɨna baya ka ɓatʉ ɓi nɨɓɔ, aɓɨkya zɛgɛsɨ nɔ ɓɛ: «Mikamɨ! Wigwi lɨmbɛngɨ! Nupilyini ɓʉnyɛ kakʉ.» ");
INSERT INTO lik_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Kʉwa wa, ɓowonisilo ɓa mʉtʉʉ ɓemoti-ɓemoti ɓaɓɨkya ndɨ luga kaɓʉ ɓɛ: «Mʉtʉ yi nɨmʉ akatʉmbwa Kunzi!» ");
INSERT INTO lik_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Luki limoti, Yeso andʉnga ndɨ tamanaga kaɓʉ. Umuusa kʉwa ndɨ ɓɛ: «Ko bulya ɨkɨ yɔ mo mino na tamanaga yanyɛ ɓɛyɔ? ");
INSERT INTO lik_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ɨkɨ yɔ a yopoli kʉgbɛ, kaɓɨkya ɓɛ: ‹Nupilyini ɓʉnyɛ kakʉ›, ikanɨ kaɓɨkya ɓɛ: ‹Wamaga, wakpakyana?› ");
INSERT INTO lik_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ɨmɨ, nakapa ambɛ wiboni ɓɨnza ɓɛ Mika-Mʉmbanzʉ a no ngu yɨpɨlya ɓʉnyɛ kʉnʉ ka ɔɓɨlɨ.» Kʉwa wa, Yeso aɓɨkya ndɨ zɛgɛsɨ nɔ ɓɛ: «Wamaga! Wava kalagba kakʉ, wɨga kʉ kakʉ.» ");
INSERT INTO lik_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Alʉkʉ nɔ amaga ndɨ, ɨga kʉ kakɨ. ");
INSERT INTO lik_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ngbingo yi nɨnɔ ɓambaza ka ɓambanzʉ ɓɨna ndɨ mino ɓɛyɔ, ɓombombaya ndɨ kʉgbɛ. Ɓabibiso Kunzi nɨnɔ ʉpá ɓambanzʉ inguo yo ngu yi nɨyɨ. ");
INSERT INTO lik_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ngbingo yi nɨnɔ Yeso a ndɨ mina kakɨtaga, amɨna ndɨ alʉkʉ ɓemoti nɨnɔ ina ndɨ ɓɛ Matayɔ wakiko ka bilo yilipisa manzanza. Kʉwa wa, Yeso aɓɨkya ndɨ ɓɛ: «Matayɔ! Iɓyeku!» Matayɔ amaga ndɨ, apʉnga kaɓɨɓya. ");
INSERT INTO lik_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Kumbuso yi, Yeso ɨnda ndɨ kalyalya kʉ ka Matayɔ. Kʉ ɓɛyɔ, ɓandɔmbɛ ɓa manzanza ɓudingi na ɓatʉ ɓa ɓʉnyɛ ɓodoku kaiko, na kalyalya pa imoti na Yeso na ɓaɓɨɓya kakɨ. ");
INSERT INTO lik_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ngbingo yi nɨnɔ Ɓafalisayɔ ɓɨna ndɨ mino ɓɛyɔ, ɓumuusa kʉwa ɓaɓɨɓya ka Yeso ɓɛ: «Ko bulya ɨkɨ yɔ muwonisilo kunu akalyalya pa imoti na ɓandɔmbɛ ɓa manzanza na ɓagya-manyɛ?» ");
INSERT INTO lik_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Nɨyɔ Yeso ʉkana ɓɛyɔ, ʉɓɨkya ɓɛ: «Ɓatʉ ɓapʉpʉ ɓakakɨsagɨgʉ mʉnganga, luki limoti, nɨɓɔ aka ɓɔ ɓa ɓokoloɓu. ");
INSERT INTO lik_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Windoni mbɛyɨ katamanaga kʉgʉ wa isi ya mʉnzɨna mi nɨma: ‹Ɨmɨ, nakɛgʉ kapa ɓɛ ipóni apɛpɛ, luki limoti, nakapa ambɛ huminyilyogoni ɓambanzʉ kumbu.› A ɓɛyɔ, nakodokugʉ kaʉkɨsa ɓatʉ ɓongbingbili, luki limoti, nɨɓɔ ɓanyɛ.» ");
INSERT INTO lik_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Kʉwa wa, ɓaɓɨɓya ka Yuani-Mubatizaɨ ɓakpuɗoku ndɨ Yeso, ɓamuusa ɓɛ: «Iɓusu na Ɓafalisayɔ toginyagatʉ malɨlɨ ko ngbingo. Ko bulya ɨkɨ yɔ ɓaɓɨɓya kakʉ ɓakoginyogigʉ ɨɓʉ mino?» ");
INSERT INTO lik_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yeso usikisya ndɨ ɓɛ: «Makasɨma ɓɛ ɓawai-dakɨ mombukwono dumo wo vononi ɓakwanana kalya kumbu ngbingo yi nɨnɔ ɓa mbɛyɨ mino pa imoti na mbʉnya muko? Kigyonosigʉ! Luki limoti, ikatʉ ndɛkɛ na lɨsyɛ nɨlɔ ɓatʉmbo mino mbʉnya muko luga kaɓʉ. Ka lɨsyɛ li nɨlɔ, ɓoginyatʉ ndɛkɛ malɨlɨ ko ngbingo. ");
INSERT INTO lik_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Mʉmbanzʉ gʉtʉgʉ ɓemoti aka koɗikogigʉ ɨnzanza na panga ya kutuko kwambɨya. Kagya ɓɛyɔ, panga yambɨya anʉwatʉ ɨnzanza, ngala ahʉmana ɓata kʉgbɛ. ");
INSERT INTO lik_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Na ɓakaɓʉngwagɨgʉ gɔnɨ vinya wambɨya ka ɓambɨkɛ ɓayo bokuto ta ɓamanya ɓayɨgbangbalaga. Ɓakagya ɓɛyɔ, vinya opumukisagatʉ ɓambɨkɛ, ɓambɨkɛ ʉlɨkaga, vinya agbɔ wasɨ. Luki limoti, ɓaɗukogo vinya wambɨya ka ɓambɨkɛ ɓayambɨya gɔnɨ. Kʉwa wa, makpʉmʉka nɨmɔ masɨ iɓuulyogo ɓɨnza.» ");
INSERT INTO lik_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ngbingo yi nɨnɔ Yeso a mbɛyɨ ndɨ mino kanzɨna aka na ɓambanzʉ ɓi nɨɓɔ, ngama ɓemoti adulyoku ndɨ. Ngama yi nɨnɔ oɓuna ndɨ moli kambwa kakɨ, aɓɨkya ɓɛ: «Mikamɨ mʉsɨka yi apʉnya kosisa lɨmbɛngɨ mbɨya wanʉ. Gʉtʉgʉ ɓɛyɔ, dokunɔ ɓaka, wabisilyo maɓɔkʉ kyɛ inisoni ɓata na ɔɓɨlɨ.» ");
INSERT INTO lik_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Kʉwa wa, Yeso amaga ndɨ, aɓyɛ ngama nɔ pa imoti na ɓaɓɨɓya kakɨ. ");
INSERT INTO lik_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Kʉ ɓɛyɔ, a ndɨ na muka ɓemoti nɨnɔ ɓangʉ apupaga ndɨ ka ɓyanga tɛkɛɓɛ na ɓɨɓa. Muko yi nɨnɔ odoku ndɨ kumbuso ka Yeso, avɨla mʉ ma kutuko kakɨ. ");
INSERT INTO lik_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","A ɓɛyɔ, a ndɨ katamanaga ɓɛ: «Nakavɨla gʉtʉgʉ kutuko kakɨ aka, nahʉkatʉ.» ");
INSERT INTO lik_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Nɨyɔ Yeso ɨkwɛ kumbuso, amɨna ndɨ muko yi nɨnɔ, aɓɨkya kʉwa ɓɛ: «Mikamɨ, wigwi lɨmbɛngɨ! Baya kakʉ uhukusini.» Wa aka wa, muko yi nɨnɔ ahʉka ndɨ. ");
INSERT INTO lik_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Kumbuso yi, Yeso osila ndɨ ka ndaɓʉ ka ngama yi nɨnɔ. Kʉ ɓɛyɔ, ʉtakanya ndɨ ɓambanzʉ nɨ ɓanɨmbɨla mambʉ ma kukwakʉ, ɓatʉ ɓagɔgɔ nɨ ɓanagama. ");
INSERT INTO lik_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Kʉwa wa, Yeso ʉɓɨkya ndɨ ɓɛ: «Puponi wanʉ! Mʉsɨka yi nɨmʉ kɛgʉ mukwo! Luki limoti, a ka tɔtɔ!» Ngbingo yi nɨnɔ ɓambanzʉ ɓʉkana mina ɓɛyɔ, ɓatɨba ndɨ ɓɨkyaaa. ");
INSERT INTO lik_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Gʉtʉgʉ ɓɛyɔ, ɓopupa ndɨ. Kʉwa wa, Yeso ogulya ndɨ ka ndaɓʉ ya kʉsɔ, agwi mʉsɨka nɨnɔ ka kʉɓɔkʉkɔ. Wa aka wa, mʉsɨka nɔ amaga ndɨ. ");
INSERT INTO lik_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Mongoni mi nɨmɔ aɗa ndɨ kʉgbɛ ka mugi masɨ. ");
INSERT INTO lik_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ngbingo yi nɨnɔ Yeso atʉkya ndɨ mino wa, ɓatʉ ɓo ɓokoloɓu ya mamɔmɔ ɓaɓa ɓapʉnga ndɨ kaɓyɛ. Ɓatʉ ɓi nɨɓɔ ɓa ndɨ kapamɨkanaga ɓɛ: «Hiii, Mika ngama Daudi! Tikwilyanɔ ɓaka kumbu!» ");
INSERT INTO lik_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ngbingo yi nɨnɔ Yeso ingyo mina ka ndaɓʉ, ɓatʉ ɓa ɓokoloɓu ya mamɔmɔ ɓi nɨɓɔ ɓakpuɗoku ndɨ. Umuusa kʉwa ndɨ ɓɛ: «Matʉ na baya ɓɛ nakwananatʉ kagya lɨkpʉmʉko li nɨlɔ?» Ɓasikisya ndɨ ɓɛ: «Iyo, Mombukwono-dosu.» ");
INSERT INTO lik_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Kʉwa wa, Yeso ʉvɨlaga ndɨ miso, ʉɓɨkya ɓɛ: «Igyonosi na iɓunu mʉɗɔngɔnɨ ɓɛyɔ baya kunu o mino.» ");
INSERT INTO lik_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Misa kaɓʉ oukwikana ndɨ. Yeso ʉgbɨtyaga ndɨ ɓɛ: «Wiminyonito, mʉmbanzʉ gʉtʉgʉ ɓemoti aka kibonitɔgʉ.» ");
INSERT INTO lik_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Luki limoti, ngbingo yi nɨnɔ aka nɔ ɓopupa ndɨ mina wa, ɓapʉnga ndɨ kowowiso mongoni kʉgʉ ka Yeso ka mugi mi nɨmɔ masɨ. ");
INSERT INTO lik_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ngbingo yi nɨnɔ ɓalʉkʉ ɓaɓa ɓi nɨɓɔ ɓaga ndɨ mino, ɓadulyoku ndɨ Yeso na ɓoɓo. Ɓoɓo yi nɨnɔ a ndɨ nɨ lɨmbɛngɨ la ɓʉnyɛ andungulyogini. ");
INSERT INTO lik_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yeso okpumya ndɨ lɨmbɛngɨ la ɓʉnyɛ li nɨlɔ, ɓoɓo apʉnga kanzɨna. Ɓambaza ka ɓambanzʉ ɓombombaya ndɨ kʉgbɛ, ɓaɓɨkya ɓɛ: «Kʉsɔ wa mugi masɨ ma Izaleli, takaninigʉ ndɛkɛ inguo ya lɨkpʉmʉka li nɨlɨ!» ");
INSERT INTO lik_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Luki limoti, Ɓafalisayɔ ɓaɓɨkya ndɨ ɓɛ: «Ngama ka mambɛngɨ ma ɓʉnyɛ nɔ apága ngu kokpumyo mambɛngɨ ma ɓʉnyɛ!» ");
INSERT INTO lik_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yeso a ndɨ kolingyo ɓagʉɗʉ no giyo yasɨ, anatɨwa ka ɓandaɓʉ ɓaya malʉmba ka Ɓayuda. Anʉɓɨkyaga ɓambanzʉ Mongoni Manza ma Ɓʉngama. Anohukusa ɓokoloɓu ɓayasɨ na ɓʉpɔ ɓa nzʉyɨ dididi. ");
INSERT INTO lik_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ngbingo yi nɨnɔ Yeso ɨna ndɨ mina ɓambaza ka ɓambanzʉ, ukwilya ndɨ kumbu. Ɓa ndɨ kaigyogyiso, ɓupini ɓɨdapaɗa mʉɗɔngɔnɨ abɛ ɓakɔndɔlɔ nɨɓɔ ɓakɛgʉ na muɓuɓulyo. ");
INSERT INTO lik_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Kʉwa wa, ʉɓɨkya ndɨ ɓaɓɨɓya kakɨ ɓɛ: «Masɔlɔ a mudingi, luki limoti, ɓagya-ligubo ɓa ɓakɛɗɛ. ");
INSERT INTO lik_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Yɛkɨ a ɓɛyɔ, muɓikyoni nɛkɨ Mombukwona tiko ambɛ utikiku ɓagya-ligubo ɓudingi kanyɔ masɔlɔ kakɨ.» ");
INSERT INTO lik_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yeso ʉmaka ndɨ ɓaɓɨɓya kakɨ tɛkɛɓɛ na ɓaɓa. Ʉpá kʉwa ndɨ ngu yikpumya mambɛngɨ ma ɓʉnyɛ, yihukuso ɓokoloɓu ɓayasɨ na ɓʉpɔ ɓa nzʉyɨ dididi. ");
INSERT INTO lik_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Mino ka ɓatʉtʉmbwa ɓi ndɨ nɨma: mʉtʉ wa mambwa nɨ Simoni (nɨnɔ ɓamakaga ndɨ gɔnɨ ɓɛ Pɛtɛlɛ) na mamakɨ ɓɛyɔ ka Andɨlɨa, Yakɔbɔ mika Zɛbɛdayɔ, na mamakɨ ɓɛyɔ ka Yuani, ");
INSERT INTO lik_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","kumbuso yi, Filipi, Batulumei, Tʉma, Matayɔ nɨnɔ a ndɨ ndɔmbɛ wa manzanza, Yakɔbɔ mika Alʉfayɔ, Tadei, ");
INSERT INTO lik_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simoni nɨnɔ a ndɨ gɔnɨ ɓemoti ka liɗu ka ɓatʉ ɓi nɨɓɔ ɓa ndɨ kakɨsa kʉlɨkanaga, sɛ kʉwa Yuda Isikalioti nɨnɔ agaba ndɨ Yeso. ");
INSERT INTO lik_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Kʉwa wa, Yeso ʉtɨka ndɨ ɓatʉtʉmbwa tɛkɛɓɛ na ɓaɓa ɓi nɨɓɔ, ʉpá ndɨ mʉtʉʉ ɓɛ: «Makindonitɔgʉ ka ɓatʉ nɨɓɔ ɓakɛgʉ Ɓayuda na makingyonitɔgʉ ka ɓagʉɗʉ ka Ɓasamalia. ");
INSERT INTO lik_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Luki limoti, windoni ka Ɓezaleli aka. A ɓɛyɔ, ɨɓʉ ɓa mʉɗɔngɔnɨ abɛ ɓakɔndɔlɔ nɨɓɔ ɓoɓungogoni ndɨ. ");
INSERT INTO lik_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ko pisi, uɓikyogoni ɓambanzʉ ɓɛ: ‹Ɓʉngama ɓa kʉgʉ wa lɨsyɛ atikpuɗiniku!› ");
INSERT INTO lik_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Huhukusoni ɓatʉ ɓa ɓokoloɓu, mubililiso ɓamanda, huhukusoni ɓakeɓu-keɓu, mokpumya mambɛngɨ ma ɓʉnyɛ. Ɓamʉpá ndɨ payaya, iɓunu, hupóni nɛkɨ gɔnɨ ɓɛngɛnɨ payaya aka. ");
INSERT INTO lik_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Kʉsɔ wa fuku kunu makovonitɔgʉ gʉtʉgʉ ɔlɔ aka, ikanɨ ɓuyi, ikanɨ ɓangwɛyɨ ɓaya lɨgabʉ lapʉ. ");
INSERT INTO lik_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Makuvonitɔgʉ ɓakʉgba ka lɨgʉndʉ, ikanɨ ɓotu ɓayɨɓa, ikanɨ ɓɛkpakʉ, ikanɨ mʉdʉkpɔ. A ɓɛyɔ, mʉgya-ligubo okwononi na malɨlɨ kakɨ. ");
INSERT INTO lik_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ngbingo yi nɨnɔ mogulyaga ɓanʉ mino ka gʉɗʉ ikanɨ ka mugi mimoti ɓɛnɛ, mukisoni mʉtʉ nɨnɔ akwanana kamʉtɨlya. Wikoni kʉ kakɨ aka kadwɛ ko ngbingo yi nɨnɔ mopupa ndɛkɛ mino. ");
INSERT INTO lik_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Nɨyɔ mogulyaga ɓanʉ mino ka ndaɓʉ, uusogoni ɓanʉ ɓɛ: ‹Mazɨyɔ iki pa imoti na iɓunu!› ");
INSERT INTO lik_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kika nɨ ɓatʉ ɓa ndaɓʉ yi nɨyɔ ɓamutilyini, mazɨyɔ mi nɨmɔ asɨkana wa. Luki limoti, kika nɨ ɓakamutilyigʉ, midukulo kambwa na mazɨyɔ mi nɨmɔ. ");
INSERT INTO lik_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Kika nɨ ɓakamutilyigʉ na ɓakamumukonigʉ ka ndaɓʉ imoti ɓɛnɛ ikanɨ ka gʉɗʉ, puponi wa, mɨbʉmaga liɓungu la magʉ kunu. ");
INSERT INTO lik_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","A lɨngʉnʉ, nakamʉɓɨkya ambɛ, ka lɨsyɛ lɨkɔ ngbanga, ɓatʉ ɓa gʉɗʉ yi nɨnɔ ɓigyogyisa ndɛkɛ kʉgbɛ kaʉkɨtaga ɓatʉ ɓa Sɔdɔmʉ na Gɔmɔlɔ.» ");
INSERT INTO lik_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«Hukononi! Ɨmɨ, namutiki mʉɗɔngɔnɨ abɛ ɓakɔndɔlɔ luga ka ɓosukopi. Yɛkɨ a ɓɛyɔ, wikoni nɛkɨ ɓakɨmɨnya abɛ ɓanzʉka na ɓitombiii abɛ ɓonzuwo. ");
INSERT INTO lik_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Wiɓuulyonito, kyɛ ɓambanzʉ ɓamulikisagatʉ ndɛkɛ ko ɓongbongu, ɓamʉtɨna pimbo ka ɓandaɓʉ kaɓʉ ɓaya malʉmba. ");
INSERT INTO lik_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ɓɨndagatʉ ndɛkɛ na iɓunu kambwa ka ɓangama ɓa ɓewili na kambwa ka ɓangama ɓakpʉkpʉ ko bulya kamɨ. Kʉwa wa, mika ndɛkɛ ɓadɛmʉ kamɨ kambwa kaɓʉ na kambwa ka ɓatʉ nɨɓɔ ɓakɛgʉ Ɓayuda. ");
INSERT INTO lik_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Luki limoti, ngbingo yi nɨnɔ ɓamusilisaga ndɛkɛ mina kambwa kaɓʉ, makigbomisonitɔgʉ ɓamʉ ɓɛ tanzɨna sɛ pɨyɛ ɓʉ? Ikanɨ ɓɛ taɓɨkya sɛ pɨyɛ ɨkɨ? Iyo, ko ngbingo yi nɨnɔ aka nɔ, Kunzi amʉpátʉ nɨlɔ maɓɨkya. ");
INSERT INTO lik_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","A ɓɛyɔ, kɛgʉ iɓunu ɓɔ manzɨna ndɛkɛ, luki limoti, Lɨmbɛngɨ ka Obonu lɔ anzɨnaga ndɛkɛ kʉsɔ kunu. ");
INSERT INTO lik_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ko ngbingo yi nɨnɔ, mʉmbanzʉ agabaga ndɛkɛ mamakɨ ɓɨkpɛ ka kukwakʉ, baba agya mikakɨ ɓɛgɛyɔ. Ɓomiki ɓʉɨtɨlya ndɛkɛ ɓaɓʉkʉta kaɓʉ, ɓumwisiso. ");
INSERT INTO lik_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ɓambanzʉ ɓasɨ ɓamʉmʉya ndɛkɛ ko bulya lino kamɨ. Luki limoti, mʉtʉ yi nɨnɔ okibya ndɛkɛ kadwɛ ka muliɓo, inisanatʉ na muhukuso. ");
INSERT INTO lik_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ɓakamʉgyagyaga ndɛkɛ ka gʉɗʉ ɓemoti ɓɛnɛ, mapɨkɨta ka nɨnɔ wagɔ. A lɨngʉnʉ, nakamʉɓɨkya ambɛ, makamagʉ kolingyo giyo yasɨ ya Izaleli nɨ Mika-Mʉmbanzʉ kanodukugʉ. ");
INSERT INTO lik_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Miki wa ɨkɔlɔ kakɨtagɨgʉ muwonisilo kakɨ. Na musunzu kakɨtagɨgʉ mombukwana-dakɨ. ");
INSERT INTO lik_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Okwononi miki wa ɨkɔlɔ iki mʉɗɔngɔnɨ abɛ muwonisilo kakɨ, ɓosunzu abɛ mombukwana-dakɨ. Kika mbɛyɨ nɨ ɓamokini ngama wa lɨvananza ɓɛ Belizebuli, angɛnɛngɛnɛ kʉwa ɓatʉ ɓa lɨvananza la ndaɓʉ kakɨ aka!» ");
INSERT INTO lik_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","«Yɛkɨ a ɓɛyɔ, makuɓongonitɔgʉ ɓambanzʉ. A ɓɛyɔ, masɨ nɨmɔ a makɨsʉma, inisanatʉ ka ɓʉngbanganya, masɨ nɨmɔ a ko dikiɗi, imibisikosatʉ ndɛkɛ. ");
INSERT INTO lik_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Masɨ nɨmɔ nakamʉɓɨkya ko biti, ɓikyoni ka ɓʉngbanganya. Masɨ nɨmɔ ɓakamʉɓɨkya ka ɓepisi-pisi, kuwoni ndɛkɛ ka ɓakugbondo. ");
INSERT INTO lik_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Makuɓongonitɔgʉ ɓatʉ nɨɓɔ ɓakwanana kamwɔ nzʉyɨ aka nɨ ɓakomwigʉ lɨmbɛngɨ. Luki limoti, muɓongoni Kunzi nɨnɔ akwanana ɨyɨ kamwɔ nzʉyɨ na lɨmbɛngɨ pa imoti ko ɓuku ɓa ɓɛnzɛ na ɓɛnzɛ. ");
INSERT INTO lik_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","31","Ambɛ, ɓakʉgabagɨgʉ mbɛyɨ ɓakyɔkyɔɗɔ ɓaɓa ka ambuma ɓemoti aka? Luki limoti, gʉtʉgʉ ɓemoti kaɓʉ kakwananɨgʉ kogwoku wasɨ nɨ Obonu kopagʉ. Makoɓongonitɔgʉ, iɓunu, ma na ɨzangɨya kaʉkɨtaga ɓakyɔkyɔɗɔ ɓudingi! Gʉtʉgʉ tukatʉ ta ɓamʉ kunu aka, Kunzi iba ɨsaɓʉ yi yasɨ. ");
INSERT INTO lik_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Mʉtʉ wasɨ kɛɓɨnɨkyana kambwa ka ɓambanzʉ, ɨmɨ, naɓɨnɨkyana ndɛkɛ ɓɛgɛyɔ ko misa ka Baba nɨnɔ a kʉgʉ wa lɨsyɛ. ");
INSERT INTO lik_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Luki limoti, mʉmbazʉ kɛmanganya ko misa ka ɓambanzʉ, ɨmɨ, namanganya ndɛkɛ ɓɛgɛyɔ ko misa ka Baba nɨnɔ a kʉgʉ wa lɨsyɛ.» ");
INSERT INTO lik_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«Makosimonitɔgʉ ɓɛ nodoku ndɨ kapá mazɨyɔ ka ɔɓɨlɨ. Nakodokugʉ kapá mazɨyɔ, luki limoti nodoku ndɨ kaudwonosa ɓambanzʉ luga kaɓʉ. ");
INSERT INTO lik_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","A ɓɛyɔ, nodoku ndɨ kagbonoso miki na abakɨ, kagbonosa mʉsɨka na amakɨ, kagbonosa muzyozyo na tɨtakɨ. ");
INSERT INTO lik_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ɓomuyonisa ka mʉmbanzʉ ɓopupaga ndɛkɛ ka ndaɓʉ kakɨ aka. ");
INSERT INTO lik_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Mʉtʉ wasɨ nɨnɔ apaga abakɨ ikanɨ amakɨ kɛkɨtaga ɨmɨ, ɨyɨ, kokwononigʉ kɛɓɨɓya. Nɨnɔ apaga mikakɨ mʉlʉkʉ yi ikanɨ nɨnɔ mʉsɨka yi kɛkɨtaga ɨmɨ, kokwononigʉ gɔnɨ kɛɓɨɓya. ");
INSERT INTO lik_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Mʉtʉ nɨnɔ kanobinikigʉ mʉsalaba kakɨ kɛɓɨɓya, kakwananɨgʉ kaika mʉɓɨɓya kamɨ. ");
INSERT INTO lik_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","A ɓɛyɔ, mʉmbanzʉ kapa kahukuso ɔɓɨlɨ kakɨ, aɓungusatʉ. Luki limoti, nɨnɔ aɓunguso ko bulya kamɨ, inisanatʉ ndɛkɛ ɓata na ɨyɨ.» ");
INSERT INTO lik_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«Kika nɨ mʉmbanzʉ amutilyini, etilyi ɨmɨ. Nɨnɔ etilyi, atilyi nɨnɔ etikoku ndɨ. ");
INSERT INTO lik_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kika nɨ mʉmbanzʉ atilyini mugyalandʉ kyɛ a mugyalandʉ, ɓakalya ndɛkɛ mʉtʉ yi nɨnɔ mʉɗɔngɔnɨ abɛ mugyalandʉ. Kika nɨ atilyini mʉmbanzʉ wongbingbili kambwa ko Kunzi, kyɛ a wongbingbili, ɓakalya ndɛkɛ mʉɗɔngɔnɨ abɛ mʉtʉ wongbingbili gɔnɨ. ");
INSERT INTO lik_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","A lɨngʉnʉ, nakamʉɓɨkya ambɛ, mʉmbanzʉ kapá gʉtʉgʉ kɔpɔ wo liɓo ladɛ aka ka ɓemoti ka ɓomiki nɨɓana kyɛ ika kanɨ a mʉɓɨɓya kamɨ, mʉtʉ yi nɨnɔ inisanatʉ ndɛkɛ na mʉkalya kakɨ.» ");
INSERT INTO lik_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ngbingo yi nɨnɔ Yeso ama ndɨ mino kaʉpá ɓaɓɨɓya kakɨ tɛkɛɓɛ na ɓaɓa mʉtʉʉ, atʉkya ndɨ wa. Aga kʉwa ndɨ ka ɓagʉɗʉ ɓa Galilaya kaʉtɨwa ɓambanzʉ na kaʉɓɨkyaga Mongoni Manza ko Kunzi. ");
INSERT INTO lik_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ngbingo yi nɨnɔ Yuani-Mubatizaɨ a ndɨ mino ka bɔlɔkɔ, ʉkana ndɨ mongoni ma mogubo nɨmɔ Kilisito a ndɨ kagya. Kʉwa wa, ʉtɨka ɓaɓɨɓya kakɨ kamuusoku ɓɛ: ");
INSERT INTO lik_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","«Ambɛ, ɨwɛ nɨ mʉtʉ yi nɨnɔ akodoku, ikanɨ takwanana kaɓʉnda wagɔgɔ?» ");
INSERT INTO lik_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yeso usikisya ndɨ ɓɛ: «Windoni katʉmbʉlyaga Yuani lɨkpʉmʉka nɨlɔ makaʉkana na nɨlɔ makaɨna: ");
INSERT INTO lik_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ɓatʉ ɓa ɓokoloɓu ɓaya mamɔmɔ ɓakaɨna ɓata, nɨɓɔ ɓa mʉtɨngbɨ ɓakakpakyana ngbingbili, ɓakeɓu-keɓu ɓoukini, ɓaadʉka ɓakaʉkana, ɓamanda akozuzuko na ɓatʉ ɓa payaya ɓakaʉkana Mongoni Manza. ");
INSERT INTO lik_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ɨgyagya ka mʉtʉ nɨnɔ kupigʉ ndɛkɛ kɛɓɨɓya ka baya!» ");
INSERT INTO lik_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ngbingo yi nɨnɔ ɓaɓɨɓya ka Yuani ɓopupa ndɨ mino, Yeso apʉnga ndɨ kanzɨnɨlya ambaza ka ɓambanzʉ ko bulya ka Yuani, anaɓɨkya ɓɛ: «Mɨnda ndɨ kaɨna ɨkɨ ka ɨsa? Lɨgʉgʉ nɨlɔ a ndɨ kodimbo na muvivi? Kalɨ! ");
INSERT INTO lik_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ambɛ, mɨnda ndɨ kaɨna ɨkɨ? Mʉmbanzʉ ɓemoti wakimokisyaga yanzanza? Luki limoti niɓɔ ɓimokisyaga ɓotu ɓaya lɨgabʉ lapʉ ɓikaga ka ɓandaɓʉ ka ɓangama. ");
INSERT INTO lik_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Mɨnda sɛ kʉwa ndɨ kaɨna ɨkɨ? Mugyalandʉ ɓemoti? Iyo, nakamʉɓɨkya ambɛ akitogito mugyalandʉ. ");
INSERT INTO lik_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","A ɓɛyɔ, Yuani a nɨnɔ Moɓiso Motu ikpikaga kʉgʉ kakɨ ɓɛ: ‹Ɨmɨ, natɨka ɓanʉ atʉtʉmbwa kamɨ kambwa kakʉ, kauɓungusilyaga pisi.› ");
INSERT INTO lik_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","A lɨngʉnʉ, nakamʉɓɨkya ambɛ, kɛgʉ na mʉmbanzʉ nɨnɔ ɨɓʉkʉta na muko, nɨnɔ a mudingi kakɨtaga Yuani-Mubatizaɨ. Luki limoti, nɨnɔ a mʉkɛɗɛ kʉgbɛ ka Ɓʉngama ɓa kʉgʉ wa lɨsyɛ a mudingi kakɨtaga ɨyɨ. ");
INSERT INTO lik_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Katʉkya ka masyɛ ka Yuani-Mubatizaɨ kadwɛ na lɨsyɛ li nɨlɨ, ɓambanzʉ ɓakobumonisa ɓʉngama ɓa kʉgʉ wa lɨsyɛ. Na ɓatʉ ɓo gilito ɓakakɨsa kava ko ngu. ");
INSERT INTO lik_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","A ɓɛyɔ, ɓogyalandʉ ɓasɨ na mʉtʉʉ ka Musa ɓanzɨna ndɨ na ɓugyalandʉ kʉgʉ wa Ɓʉngama kadwɛ ko ngbingo ka Yuani. ");
INSERT INTO lik_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Na makapa kabaɨlya, Yuani nɨ mugyalandʉ Ɨlɨya nɨnɔ akwanana ndɨ kodoku. ");
INSERT INTO lik_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nɨnɔ a na motili, ʉkanɨtɔ! ");
INSERT INTO lik_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Nakwanana pɨyɛ kaukingyasa ɓatʉ ɓa lɨsyɛ li nɨlɨ na ɓɛkɨ? Ɓa mʉɗɔngɔnɨ abɛ ɓa wanɨ? Ɓa mʉɗɔngɔnɨ abɛ ɓomiki ɓi nɨɓɔ ɓa ɓakikaga ka pa yangba, ɓanʉtʉɓɨlaga ɓɛngɛnɨ ɓɛ: ");
INSERT INTO lik_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‹Tamungbotilyi ɓi ɓyɛmbɨ, nɨ makoɓinigʉ! Tamumbimbilyi ɓi mambʉ ma idumasʉ, nɨ makogomigʉ ɓɛgɛyɔ!› ");
INSERT INTO lik_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","A ɓɛyɔ, nɨyɔ Yuani odoku ndɨ, kalyalyagɨgʉ ndɨ ikanɨ komwo luki. Ɓambanzʉ ɓapʉnga ndɨ kaɓɨkya ɓɛ: ‹A na lɨmbɛngɨ la ɓʉnyɛ.› ");
INSERT INTO lik_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Nɨyɔ kʉwa Mika-mʉmbanzʉ odoku, analyalya, anomwo, ɓapʉnga ndɨ kaɓɨkya ɓɛ: ‹Mundoni alʉkʉ wa mʉsasa yi nɨmʉna, akalyalya na kamwa vinya pa imoti na ɓandɔmbɛ ɓa manzanza na ɓatʉ ɓa ɓʉnyɛ!› Luki limoti, yimibo ko Kunzi inisononi pisi ka mogubo nɨmɔ agyaga ndɨ.» ");
INSERT INTO lik_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Kumbuso yi, Yeso apʉnga ndɨ kaʉnyakɨlya ɓatʉ ɓa ɓagʉɗʉ nɨɓɔ agya ndɨ mina makpʉmʉka mʉmbanga-mbanga mudingi. A ɓɛyɔ, ɨɓʉ ɓatʉ ɓi nɨɓɔ ɓakɛgʉ ndɨ kapa kayikoso ɔɓɨlɨ kaɓʉ. Kʉwa wa, apʉnga ndɨ kaʉtɨwa ɓɛ: ");
INSERT INTO lik_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«Kumbu kakʉ, gʉɗʉ wa Kɔlazini! Kumbu kakʉ gʉɗʉ wa Bɛtɛsaida! Makpʉmʉka mʉmbanga-mbanga nɨmɔ igyonosa ndɨ kʉ kunu kigyonosa ndɨ ka Tilo na Sidɔna, iba katʉkya ka ɓʉndɛlɨ, ɓatʉ ɓi ɓowonisiloni ndɨ kumbu kaɓʉ, ɓimokisya ɓotu ɓaya lɨlɛɓʉ, ɓiɓuɓisa nzʉyɨ na libu ɓitu, ɓoikono. ");
INSERT INTO lik_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Kinili, ɨmɨ, nakamʉɓɨkya ambɛ ka lɨsyɛ lɨkɔ ngbanga, yigyogyisa kunu ika ndɛkɛ yapʉ kʉgbɛ kaʉkɨtaga ɓatʉ ɓa Tilo na nɨɓɔ ɓa Sidɔna! ");
INSERT INTO lik_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Sɛ kʉwa iɓunu ɓatʉ ɓa Kapɛlɛnaumu, makasɨma ɓɛ Kunzi amuɗokisatʉ ɓanʉ kadwɛ kʉgʉ wa lɨsyɛ? Makotomononitɔgʉ gʉtʉgʉ iki yi ɨkɛɗɛ aka! Amusisa ndɛkɛ kadwɛ ka ɓabɨlɨ. A ɓɛyɔ, makpʉmʉka mʉmbanga-mbaga nɨmɔ igyonosa ndɨ kʉ kakʉ, kigyonosa ndɨ ka Sɔdɔmʉ, iba gʉɗʉ yi nɨnɔ atʉ mbɛyɨ ɓata aka kadwɛ na lɨsyɛ li nɨlɨ. ");
INSERT INTO lik_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Kinili, ɨmɨ, nakamʉɓɨkya ambɛ ka lɨsyɛ lɨkɔ ngbanga, yigyogyisa ya Sɔdɔmʉ kikigʉ ndɛkɛ yapʉ kʉgbɛ kakɨtaga nɨyɔ kakʉ!» ");
INSERT INTO lik_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ko ngbingo yi nɨnɔ, Yeso aɓɨkya ndɨ ɓɛ: «Baba ooo, Mombukwana masɨ nɨmɔ a kʉgʉ wa lɨsyɛ na nɨmɔ kʉnʉ ka lɨtɔmbʉ, nubibisini kyɛ uwonisiloni ɓatʉ nɨɓɔ ɓakibigʉ luki makpʉmʉka mʉmbanga-mbanga nɨmɔ ʉsʉmɨlya ndɨ ɓatʉ ɓa yimibo na nɨɓɔ ɓa akili. ");
INSERT INTO lik_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Iyo Ba, a ɓɛyɔ kyɛ wabaɨlya ndɨ ɓɛyɔ. ");
INSERT INTO lik_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Baba epóni makpʉmʉka masɨ. Gʉtʉgʉ mʉtʉ ɓemoti kamibigʉ Miki kiki asɨ Baba aka, na gʉtʉgʉ mʉmbanzʉ ɓemoti aka kibigʉ ɓɛ Baba nɨ wanɨ kiki asɨ Miki aka, na sɛ kʉwa nɨɓɔ Miki akapa kaumibiso. ");
INSERT INTO lik_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Doniku kʉ kamɨ! Iɓunu ɓasɨ nɨɓɔ ma ɓakupo na likumbogi liti, ɨmɨ, namumumbisatʉ. ");
INSERT INTO lik_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Wikoni ɓakɨtʉlya kabɨnɨka likumbogi na kaɓyɛ mʉtʉʉ kamɨ. A ɓɛyɔ, ɨmɨ, na wotombiii na na lɨmbɛngɨ la kisiso. Namuyukumisatʉ. ");
INSERT INTO lik_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Likumbogi kamɨ a lanza na ɓuti ɓi a ɓipoli.» ");
INSERT INTO lik_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Kumbuso wo ngbinga mʉkɛɗɛ, Yeso a ndɨ kakɨtaga ka ɓotiko ɓaya nganʉ ka Lɨsyɛ la kimumbiso. Ɓaɓɨɓya kakɨ ɓɨmʉkana ndɨ nza, ɓapʉnga kʉwa kakɔgɔ ɓɛkaza ɓaya nganʉ, ɓanalya. ");
INSERT INTO lik_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Nɨyɔ Ɓafalisayɔ ɓɨna ɓɛyɔ, ɓaɓɨkya Yeso ɓɛ: «Wɨna! Ɓaɓɨɓya kakʉ ɓakagya lɨkpʉmʉka nɨlɔ ɓapakya kagya ka Lɨsyɛ la kimumbiso!» ");
INSERT INTO lik_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Luki limoti, Yeso usikisya ndɨ ɓɛ: «Ambɛ, makonotongulogigʉ ndɨ iɓunu lɨkpʉmʉka nɨlɔ ngama Daudi agya ndɨ, ngbingo yi nɨnɔ ɓɨmʉkana ndɨ mino nza pa imoti na ɓawai-dakɨ? ");
INSERT INTO lik_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ingya ndɨ ka Ndaɓʉ ko Kunzi pa imoti na ɓawai-dakɨ, ɓalya ndɨ mukati nɨnɔ ɓa ndɨ nɨ ɓapíni Kunzi. Wɨna sɛ, mʉtʉʉ kakpamyagʉ ndɨ ɓɛ ɓalyagɨ kiki nɨ ɓokumu aka. ");
INSERT INTO lik_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ambɛ, makanotongulogigʉ ndɨ gɔnɨ ka mʉtʉʉ ka Musa? Masyɛ ma kimumbiso, ɓokumu nɨɓɔ ɓagyaga ligubo ka Ndaɓʉ ko Kunzi, ɓakpakyanaga kunzi wa mʉtʉʉ. Ɨɓʉ ɓakikogigʉ kaiba ɓɛ ɓagyaga ɓʉnyɛ! ");
INSERT INTO lik_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Luki limoti, nakamʉɓɨkya ambɛ, wanʉ atʉ na mbɔkʉ wa ɨzangɨya kakɨtaga Ndaɓʉ ko Kunzi! ");
INSERT INTO lik_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Iɓunu, makibo ɓi ka lɨngʉnʉ isi ya Moɓiso Motu mi nɨma: ‹Ɨmɨ, nakɛgʉ kapa ɓɛ ipóni apɛpɛ, luki limoti, huminyilyogoni ɓambanzʉ kumbu,› makakwananigʉ ɓi kaʉmakya ɓatʉ nɨɓɔ ɓakogyigʉ ɓʉnyɛ ka mʉkɔmbʉ. ");
INSERT INTO lik_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","A ɓɛyɔ, Mika-mʉmbanzʉ nɔ a Mombukwana Lɨsyɛ la kimumbiso.» ");
INSERT INTO lik_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Kʉwa wa, Yeso atʉkya ndɨ ka pa yi nɨyɔ, ogulya ndɨ ka ndaɓʉ ya malʉmba ka Ɓayuda. ");
INSERT INTO lik_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Kʉ ɓɛyɔ, a ndɨ na mʉtʉ ɓemoti wa kʉɓɔkʉkɔ kukwo. Ɓambanzʉ ɓemoti-ɓemoti nɨɓɔ ɓa ndɨ gɔnɨ kʉ ɓɛyɔ ɓa ndɨ kapa kasʉngʉlya Yeso. Kʉwa wa, ɓamuusa ndɨ ɓɛ: «Mʉtʉʉ atɨkpamyagatʉ ɓɛ tahukusi mʉmbanzʉ ka Lɨsyɛ la kimumbiso?» ");
INSERT INTO lik_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yeso usikisya ndɨ ɓɛ: «Kika nɨ ɓemoti kunu a na kɔndɔlɔ ɓemoti aka, kɔndɔlɔ yi nɨnɔ ogwa ka lɨɓyɛ ka Lɨsyɛ la kimumbiso, kanyʉgʉ ka lɨsyɛ li nɨlɔ aka lɔ? ");
INSERT INTO lik_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ɛɛɛ! A ɓɛyɔ, mʉmbanzʉ nɔ a na ɨzangɨya kʉgbɛ kakɨtaga kɔndɔlɔ! Yɛkɨ a ɓɛyɔ, mʉtʉʉ akatɨkpamya ɓɛ tiki tanagyaga ɓʉnza ka Lɨsyɛ la kimumbiso.» ");
INSERT INTO lik_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Kʉwa wa, Yeso aɓɨkya ndɨ alʉkʉ nɔ ɓɛ: «Nana kʉɓɔkʉkɔ.» Anana ndɨ, kʉɓɔkʉkɔ kwi nɨkwɔ ɨɨta ndɨ mʉɗɔngɔnɨ abɛ kwagɔgɔ. ");
INSERT INTO lik_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ɓafalisayɔ ɓamʉmʉkana ndɨ, ɓaga kagya dikiɗi kakɨsa pisi tina yɔ ɓamwisiso mina Yeso. ");
INSERT INTO lik_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Nɨyɔ Yeso ʉkana ɓɛ Ɓafalisayɔ ɓogoni kagyɨlya dikiɗi, opupa ndɨ wa. Ɓambaza ɓakpʉkpʉ ka ɓambanzʉ ɓaɓɨɓya ndɨ. Uhukusa ndɨ ɓatʉ ɓa ɓokoloɓu ɓasɨ. ");
INSERT INTO lik_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ʉgbɨtyaga ndɨ ɓɨkpɔkpɔkpɔ ɓɛ ɓakanyonitɔgʉ mʉgɔngʉ kunzi. ");
INSERT INTO lik_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Igyonosa ndɨ ɓɛyɔ kyɛ ɨtʉlyanɨ lɨkpʉmʉka nɨlɔ ɨɓɨkya ndɨ pisi ka mugyalandʉ Isaya ɓɛ: ");
INSERT INTO lik_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«Muminoni mʉgya-ligubo kamɨ, nɨnɔ napʉnaga ndɨ, a mikamɨ mʉpaka. Napaga kʉgbɛ. Nobisa ndɛkɛ Lɨmbɛngɨ kamɨ kʉgʉ kakɨ. Ʉɓɨkyaga ndɛkɛ mababa ka ɓambanzʉ lɨkpʉmʉka kamɨ longbingbili. ");
INSERT INTO lik_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Kasaanɨgʉ ndɛkɛ na ɓambanzʉ ikanɨ kamakya ɨpʉmbʉ. Na ɓakʉkanɨgʉ ndɛkɛ lɨyʉ kakɨ ko ɓopisi. ");
INSERT INTO lik_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Koɓunigʉ ndɛkɛ lɨgʉgʉ nɨlɔ lɨyɨga, kolimigʉ ndɛkɛ itambi nɨyɔ akoɗunguwo. Agyaga ndɛkɛ ɓɛyɔ, kadwɛ kʉ kwa kʉ ɓungbingbili inisa ndɛkɛ mina ka ɓapa ɓayasɨ. ");
INSERT INTO lik_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Mababa obisa ndɛkɛ mʉtamanagɨ kaɓʉ ko lino kakɨ.» ");
INSERT INTO lik_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Kʉwa wa, ɓadulyoku ndɨ Yeso na mʉtʉ nɨnɔ a ndɨ na lɨmbɛngɨ la ɓʉnyɛ, no koloɓu ya mamɔmɔ, a ndɨ gɔnɨ ɓoɓo. Yeso ahukusa ndɨ, apʉnga ndɨ kanzɨna na kaɨna. ");
INSERT INTO lik_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ɓambaza ka ɓambanzʉ ɓasɨ ɓombombaya ndɨ kʉgbɛ. Ɨɓʉ aka ndɨ ɓɛ: «Kɛgʉ mbɛyɨ Mika ngama Daudi mʉ?» ");
INSERT INTO lik_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ngbingo yi nɨnɔ Ɓafalisayɔ ɓʉkana mina ɓɛyɔ, ɓaɓɨkya ndɨ ɓɛ: «Alʉkʉ yi nɨmʉ akokpumya mambɛngɨ ma ɓʉnyɛ ko ngu ka Belizebuli, ngama ka ɓomuyoniso!» ");
INSERT INTO lik_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Luki limoti, Yeso a ndɨ kaiba tamanaga kaɓʉ, ʉɓɨkya kʉwa ndɨ ɓɛ: «Lɨvananza la ɓʉngama ɓumoti kapʉnga kaɨgbanana luga yi, iba ɓʉngama ɓi nɨɓɔ osyini. Ɓambanzʉ ɓa gʉɗʉ ɓemoti ikanɨ ndaɓʉ yimoti ɓakɨgbanana, gʉɗʉ yi nɨnɔ ikanɨ ndaɓʉ yi nɨyɔ omisikanatʉ. ");
INSERT INTO lik_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Kika nɨ Abɨlɨ akakpumya Abɨlɨ-dakɨ, akaibumoniso ɨyɨ mombukwana-dakɨ yi ɓɨkpɛ. Ɓʉngama kakɨ akwanana kʉwa kaidukulaga kaamaga lɨkɨ? ");
INSERT INTO lik_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Kika nɨ ɨmɨ nakokpumyo mambɛngɨ ma ɓʉnyɛ no ngu ka Belizebuli, ɓomikunu, ɓa kʉwa ɨɓʉ kokpumyo no ngu ka wanɨ? Kinili, iɓunu ɓamombukwana-donu bi ɓɔ mika ndɛkɛ ɓazozi. ");
INSERT INTO lik_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","A ɓɛyɔ, ɨmɨ nakokpumya mambɛngɨ ma ɓʉnyɛ no ngu ya Lɨmbɛngɨ ko Kunzi. Nɨyɔ akowonisilo ɓɛ Ɓʉngama ko Kunzi odunuku luga kunu. ");
INSERT INTO lik_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Kɛgʉ na mʉmbanzʉ nɨnɔ akwanana kogulya ka ndaɓʉ ko tutungyo katʉpa lɨngama kakɨ nɨ kanakondigʉ mbɛyɨ. Luki limoti, kika sɛ kʉwa nɨ akondini, akwanana kagya ɓɛyɔ! ");
INSERT INTO lik_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Mʉtʉ nɨnɔ kɛgʉ pa imoti na ɨmɨ, a mumuyoniso kamɨ. Mʉtʉ nɨnɔ kɛgʉ kamʉmʉla pa imoti na ɨmɨ, a komisyo. ");
INSERT INTO lik_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Kinili nakamʉɓɨkya ambɛ, ɓakwananatʉ kaʉpɨlya ɓambanzʉ ɓʉnyɛ, na mosikoni masɨ nɨmɔ ɓasɨkaga Kunzi. Luki limoti, ɓakakwananɨgʉ ndɛkɛ kapɨlya mʉmbanzʉ nɨnɔ asiki Lɨmbɛngɨ-Lotu. ");
INSERT INTO lik_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Mʉtʉ wasɨ nɨnɔ akanzɨna yanyɛnyɛ ko bulya ko Mika-mʉmbanzʉ, inisatʉ na mʉpɨlya. Luki limoti, nɨnɔ anzɨnaga yanyɛnyɛ ko bulya Lɨmbɛngɨ-Lotu, ɓakapɨlyɨgʉ ndɛkɛ ka ɔɓɨlɨ yi nɨmʉ ikanɨ ka nɨnɔ akodoku.» ");
INSERT INTO lik_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«Kika nɨ sɨbʉkʉsɔ a sanza, bumo yi ika yanza gɔnɨ. Kika nɨ a sanyɛ, bumo yi ika ɓɛgɛyɔ. A ɓɛyɔ, ɓibaga sɨbʉkʉsɔ ko bumo yi. ");
INSERT INTO lik_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Lɨvananza ka ɓanzʉka! Makwanana pɨyɛ kaɓɨkya makpʉmʉka manzanza lɨkɨ, nɨ ma ɓanyɛ? A ɓɛyɔ, mʉnɔkʉ opupisaga nɨmɔ ikaga mutumo ka lɨmbɛngɨ ka mʉmbanzʉ! ");
INSERT INTO lik_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mʉtʉ wanza agyaga makpʉmʉka manzanza nɨmɔ opupaga ka lɨmbɛngɨ kakɨ lanza. Mʉtʉ wanyɛ opupisaga makpʉmʉka manyɛnyɛ nɨmɔ opupaga ka lɨmbɛngɨ kakɨ lanyɛ. ");
INSERT INTO lik_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Nakamʉɓɨkya ɓɨngbanganya ambɛ, ka lɨsyɛ lɨkɔ mʉkɔmbʉ, ɓambanzʉ ɓatʉmbʉlaga ndɛkɛ makpʉmʉka ma payaya masɨ nɨmɔ opupaga ndɨ ka nɔkʉ kaɓʉ. ");
INSERT INTO lik_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","A ɓɛyɔ, muhukuso ikanɨ kukwakʉ kakʉ inisana ndɛkɛ kaɓyɛnɛnɛ na mʉnzɨna kakʉ.» ");
INSERT INTO lik_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Kʉwa wa, ɓemoti-ɓemoti luga ka Ɓafalisayɔ na ɓowonisilo ɓa mʉtʉʉ, ɓaɓɨkya ndɨ Yeso ɓɛ: «Muwonisilo! Takapa ɓɛ tiwoniso likingyosi.» ");
INSERT INTO lik_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yeso usikisya ndɨ ɓɛ: «Iɓunu ɓatʉ ɓa lɨsyɛ li nɨlɨ, ma ɓanyɛ na makokwononigʉ ko misa ko Kunzi! Makakʉnga ɓɛ ɓamuwonisi likingyosi. Luki limoti, makɨnɨgʉ ndɛkɛ ɓata likingyosi lagɔgɔ kiki nɨlɔ aka lɔ ka mugyalandʉ Yɔna. ");
INSERT INTO lik_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ɓɛgɛyɔ, Yɔna agya ndɨ mino masyɛ masaa, biti na lɨsyɛ ka mʉma ka musi mudingi, Mika-Mʉmbanzʉ agya ndɛkɛ ɨyɨ masyɛ masaa ɓɛgɛyɔ, biti na lɨsyɛ ka mbʉkʉ. ");
INSERT INTO lik_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ka lɨsyɛ lɨkɔ ngbanga, ɓatʉ ɓa Nɨnawɛ ɓamanana ndɛkɛ ka mʉɗɔngɔ ɓigwo kaʉsʉngʉlya ɓatʉ ɓa lɨsyɛ li nɨlɨ! Kyɛ ɓagomosyanatʉ ndɨ ɨɓʉ ɔɓɨlɨ kaɓʉ ngbingo yi nɨnɔ ɓamʉkana ndɨ mino Yɔna. Wɨna sɛ wanʉ a na mʉtʉ mudingi kakɨtaga Yɔna! ");
INSERT INTO lik_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ka lɨsyɛ lɨkɔ ngbanga, ngama muko yi nɨnɔ otukyoku ndɨ ɓyɨ ka gʉɗʉ wa Sɨba kodoku kaʉkana mʉnzɨna ma yimibo ka ngama Sɔlɔmɔnɔ amaga ndɛkɛ kambwa ka ɓatʉ ɓa lɨsyɛ li nɨlɨ kaʉsʉngʉlya! Winoni sɛ, wanʉ, a na mʉtʉ mudingi kakɨtaga Sɔlɔmɔnɔ.» ");
INSERT INTO lik_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","«Lɨmbɛngɨ la ɓʉnyɛ kapupa mʉmbanzʉ, aga kolingyo ɓapa ka ɓɛsa ɓilelele. Akɨsa pa ya kimumbiso, luki limoti nɨ kinigʉ, ");
INSERT INTO lik_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ilu aka ɓɛ: ‹Nakaɨga ka ndaɓʉ kamɨ, kʉ nopupiku ɓi mino.› Nɨyɔ ɨga ɓata, atakanya ɓikpo, yɨkpaga ɓɨngɔ na yiɓungusya ɓɨnza. ");
INSERT INTO lik_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Aga kʉwa kava mambɛngɨ ma ɓʉnyɛ magɔgɔ maɗɨya na ɨka nɨmɔ manyɛnyɛ kakɨtaga ɨyɨ, ɓogulyo, ɓilikisyo wa. Ɔɓɨlɨ ka mʉtʉ yi nɨnɔ ika kʉwa wanyɛ kakɨtaga wa a ndɨ mino kambwa. Ika ndɛkɛ mʉɗɔngɔnɨ ɓɛyɔ ka ɓatʉ ɓa lɨvananza lanyɛ li nɨlɨ.» ");
INSERT INTO lik_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ngbingo yi nɨnɔ Yeso a mbɛyɨ ndɨ ɓata mina kanzɨna aka na ɓambaza ka ɓambanzʉ ɓi nɨɓɔ, amakɨ na ɓamamakɨ ɓa ndɨ ɓakamagaga kunzi. Ɨɓʉ, ɓa ndɨ kapa kanzɨna na ɨyɨ. ");
INSERT INTO lik_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Mʉtʉ ɓemoti aɓɨkya kʉwa ndɨ ɓɛ: «Wɨkwɛ! Amakʉ na ɓamamakʉ ɓa ɓakamagaga kunzi. Ɓakapa kanzɨna na ɨwɛ.» ");
INSERT INTO lik_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yeso asikisya ndɨ alʉkʉ nɔ ɓɛ: «Mama nɨ wanɨ? Ɓomika-mama nɨ ɓa ɨkɨ?» ");
INSERT INTO lik_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Kumbuso yi, ʉwanya ndɨ ɓaɓɨɓya kakɨ na kʉɓɔkʉkɔ, aɓɨkya ɓɛ: «Huminoni! Mama na ɓomika-mama nɨɓa! ");
INSERT INTO lik_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","A ɓɛyɔ, mʉtʉ wasɨ nɨnɔ agyaga sɨpananɨsɔ ka Baba nɨnɔ a kʉgʉ wa lɨsyɛ, ɨyɨ nɨ mama, mika-mama mʉlʉkʉ yi ikanɨ mʉsalɨ kamɨ.» ");
INSERT INTO lik_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ka lɨsyɛ li nɨlɔ, Yeso opupa ndɨ ka ndaɓʉ, ikoku ndɨ ka kpɔlɔ wo liɓa lidingi. ");
INSERT INTO lik_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Kʉ ɓɛyɔ, ɓambaza ɓakpʉkpʉ kʉgbɛ ka ɓambanzʉ ɓakungula ndɨ ɓikululu. Kinili, aɗaka ndɨ, ika ka ɨngbɔlɔ yidingi. Ɓambaza ɓi nɨɓɔ ɓasɨkana ndɨ ɓakamanana kubi. ");
INSERT INTO lik_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Kʉwa wa, Yeso ʉnzɨnɨlya ndɨ makpʉmʉka mudingi ɓɨndɨ pisi ka mozuni. Ɨyɨ aka ndɨ na ɨɓʉ ɓɛ: «Lɨsyɛ limoti, alʉkʉ ɓemoti ɨnda ndɨ kakʉna mʉpʉnga. ");
INSERT INTO lik_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Nɨyɔ a ndɨ kakʉna bɛyɔ, bumo yi yagɔgɔ anyʉkaga ko pisi. Ɓombu ɓodoku ndɨ, ɓalya. ");
INSERT INTO lik_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Masɔlɔ magɔgɔ anyʉkaga ndɨ ka pa ya ngyengye nɨyɔ kɛgʉ ndɨ na lɨtɔmbʉ lakpʉ. Nɨmɔ, aɓaka ndɨ ɓɨgala-gala lɨtɔmbʉ kɛgʉ ndɨ lakpʉ wa. ");
INSERT INTO lik_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Luki limoti, nɨyɔ mɔnɨ osumbo, awɨsɨya, ʉmɨlaga kyɛ lyo yi kigwinanagʉ ndɨ ɓɨnza ka lɨtɔmbʉ. ");
INSERT INTO lik_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Masɔlɔ magɔgɔ anyʉkaga ndɨ ko kpokiki. Kpokiki aɓaka ndɨ, akandaga ɓɨkpɛkɨ-kpɛkɨ nɨ kopingigʉ. ");
INSERT INTO lik_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Luki limoti, nɨmɔ anyʉkaga ndɨ ka lɨtɔmbʉ la dɔɓɔ, aɓʉkʉta ɓɨyʉyʉyʉ. Litino limoti aɓʉkʉtaga ndɨ bumo mɨya, lagɔgɔ ɓatɛkɛɓɛ maɗɨya na lagɔgɔ ɓata ɓatɛkɛɓɛ ɓasaa.» ");
INSERT INTO lik_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yeso opipila kʉwa ndɨ ɓɛ: «Nɨnɔ a na motili, ʉkanɨtɔ!» ");
INSERT INTO lik_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Kʉwa wa, ɓaɓɨɓya ka Yeso ɓakpuɗoku ndɨ, ɓamuusa ɓɛ: «Ko bulya ɨkɨ yɔ wo mina kaʉnzɨnɨlya ɓambanzʉ ɓi nɨɓa na mozuni aka?» ");
INSERT INTO lik_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Usikisya ndɨ ɓɛ: «Kunzi amumibisatʉ iɓunu ɓodikiɗi ɓaya Ɓʉngama ɓa kʉgʉ wa lɨsyɛ. Luki limoti, kɛgʉ ɓɛyɔ ka ɓatʉ ɓagɔgɔ. ");
INSERT INTO lik_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","A ɓɛyɔ, mʉmbanzʉ nɨnɔ a no luki, ɓamatɨlyatʉ ɓata, ika kʉwa na imu makpʉ. Luki limoti, mʉtʉ yi nɨnɔ kɛgʉ no luki ɓakʉpya gʉtʉgʉ luki lɨkɛɗɛ aka nɨlɔ akwanano ɓi kaika nolu. ");
INSERT INTO lik_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Kinili, ɨmɨ, nʉnzɨnɨlyaga na mozuni. Gʉtʉgʉ ɓakika kaanda, ɓakɨnɨgʉ, Gʉtʉgʉ ɓakika kaʉkana, ɓakʉkanɨ ikanɨ ɓakotombisyigʉ. ");
INSERT INTO lik_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ɨtʉlyana kʉwa ndɨ kʉgʉ kaɓʉ lɨkpʉmʉka nɨlɔ mugyalandʉ Isaya aɓɨkya ndɨ ɓɛ: Mikatʉ kaʉkana ɓɨnza, luki limoti makotombisyigʉ. Mikatʉ kaanda ɓɨnza, luki limoti makɨnɨgʉ. ");
INSERT INTO lik_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","A ɓɛyɔ, mambɛngɨ ka ɓatʉ nɨɓana a kʉwa muti. Ɓidulogoni ndɨ motili, ɓaɓʉwa miso, kyɛ misa kaɓʉ kinonitɔgʉ, motili kaɓʉ kukononitɔgʉ, mambɛngɨ kaɓʉ kotombisyonitɔgʉ ɓɛkyɛ ɓakemigilyonitɔgʉ, nuhukuso. ");
INSERT INTO lik_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Luki limoti, ɨgyagya ku kunu, kyɛ misa kunu akaɨna na motili kunu akaʉkana. ");
INSERT INTO lik_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","A lɨngʉnʉ, nakamʉɓɨkya ambɛ, ɓogyalandʉ ɓakpʉ na ɓatʉ ɓongbingbili ɓa ndɨ na mʉsasa kaɨna makpʉmʉka mʉmbanga-mbanga nɨmana makaɨna ma, luki limoti ɓakɨnagʉ ndɨ. Ɓa ndɨ gɔnɨ na mʉsasa kaʉkana nɨmana makaʉkana ma, luki limoti ɓakʉkanagʉ ndɨ.» ");
INSERT INTO lik_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«Hukononi nɛkɨ isi ya lizuni ka mʉkʉkʉna. ");
INSERT INTO lik_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Masɔlɔ nɨmɔ anyʉkaga ndɨ ka kpɔlɔ wo pisi, a likingyosi ka mʉtʉ yi nɨnɔ ʉkanaga Lɨkpʉmʉka la Ɓʉngama ko Kunzi, luki limoti, nɨ koɓɨnɨkyonigʉ. Mumuyoniso odoku, anyɔgɔ masɨ nɨmɔ ɨkʉna ndɨ ka lɨmbɛngɨ kakɨ. ");
INSERT INTO lik_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Masɔlɔ nɨmɔ anyʉkaga ndɨ ka pa ya ngyengye nɨyɔ kɛgʉ ndɨ na lɨtɔmbʉ lakpʉ, a likingyosi ka mʉtʉ yi nɨnɔ ʉkanaga Lɨkpʉmʉka ko Kunzi ɓɨkwa, ogwi na magyagya. ");
INSERT INTO lik_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Luki limoti, nɨ lɨkpʉmʉka li nɨlɔ kɛgʉ no lyo kʉsɔ kakɨ, ogwi ko ngbinga mʉkɛɗɛ aka. Nɨyɔ ɓʉkpɛkɨ-kpɛkɨ na yigyogyiso usilyogo mino ko bulya Lɨkpʉmʉka ko Kunzi, ɓatʉkya ɓɨkwa ka baya. ");
INSERT INTO lik_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Masɔlɔ mi nɨmɔ anyʉkaga ndɨ lugo wo kpokiki, a likingyosi ka mʉtʉ yi nɨnɔ ʉkanaga Lɨkpʉmʉka ko Kunzi, luki limoti, ɓʉkpɛkɨ-kpɛkɨ ɓa ɔɓɨlɨ na mʉsasa ma lɨngama, akandaga Lɨkpʉmʉka li nɨlɔ kʉsɔ kakɨ ɓɨkpɛkɨ-kpɛkɨ nɨ kopígʉ bumo. ");
INSERT INTO lik_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Na nɨmɔ anyʉkaga ndɨ ka pa ya ɨdɔɓɔ a likingyosi ka mʉtʉ yi nɨnɔ ʉkanaga Lɨkpʉmʉka ko Kunzi, aɓɨnɨkyana. Lɨkpʉmʉka li nɨlɔ aɓʉkʉta bumo ka ɔɓɨlɨ kakɨ. Mʉmbanzʉ ɓemoti ika no bumo mɨya, wagɔgɔ ɓatɛkɛɓɛ maɗɨya, wagɔgɔ ɓata ɓatɛkɛɓɛ ɓasaa.» ");
INSERT INTO lik_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yeso ʉtwɨlya ɓata ndɨ lizuni lagɔgɔ nɨlɨ: «Tokingyoso Ɓʉngama ɓa kʉgʉ wa lɨsyɛ na mʉtʉ ɓemoti nɨnɔ akʉna ndɨ masɔlɔ manza ko tiko kakɨ. ");
INSERT INTO lik_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Biti yimoti, ngbingo yi nɨnɔ ɓambanzʉ ɓasɨ ɓa ndɨ mina ka ɓatɔtɔ, mumuyoniso kakɨ odoku ndɨ ɓɨpɛlɛ kakʉna tɔnɨtɔ tanyɛ ka mʉpʉnga, aga ndɨ ɨyɨ. ");
INSERT INTO lik_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Nɨyɔ mʉpʉnga aɓaka, aɓʉkʉta, tɔnɨtɔ tanyɛ ti nɨtɔ inisana ndɨ gɔnɨ. ");
INSERT INTO lik_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ɓosunzu ka mombukwano tiko, ɓodoku ndɨ kamuusa ɓɛ: ‹Mombukwono-dosu, wakakʉnagʉ mbɛyɨ ndɨ asɨ masɔlɔ manza aka ko tiko kakʉ? Tɔnɨtɔ tanyɛ ti nɨtɨ apʉnya kʉwa tu yanɨ?› ");
INSERT INTO lik_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Usikisya ndɨ ɓɛ: ‹Mumuyoniso nɔ ogyi ɓi ɓɛyɔ.› Ɓosunzu ɓamuusa ndɨ ɓɛ: ‹Wapatʉ ɓɛ taga kanyɔgɔ?› ");
INSERT INTO lik_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ɨyɨ aka ndɨ na ɨɓʉ ɓɛ: ‹Kalɨ! Makɨnda kanyɔgɔ, yagɔgɔ manyɔgɔtʉ gɔnɨ mʉpʉnga nɨnɔ ko tiko. ");
INSERT INTO lik_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Wosoni masɨ angatɨ pa imoti kadwɛ ko ngbingo mubuulyo. Ngbingo yi nɨnɔ, nʉɓɨkya ɓanʉ ɓagya-ligubo ɓɛ: Nyogoni mbɛyɨ tɔnɨtɔ tanyɛ, makandaga ka ɓegbi kyɛ ɓabʉsyɨ. Kumbuso yi, mamʉmʉla mʉpʉnga ka basa ya masɔlɔ kamɨ.›» ");
INSERT INTO lik_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yeso ʉtwɨlya ndɨ ɓata lizuni lagɔgɔ ɓɛ: «Ɓʉngama ɓa kʉgʉ wa lɨsyɛ a abɛ libumo lɨkɛɗɛ nɨlɔ mʉtʉ ɓemoti ava ndɨ, akʉna ko tiko kakɨ. ");
INSERT INTO lik_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Gʉtʉgʉ ɓɛyɔ a ndɨ mina lɨkɛɗɛ yɔ kakɨtaga bumo yagɔgɔ yasɨ, luki limoti, nɨyɔ aɓaka, opinga kʉwa kakɨtaga malɨlɨ masɨ mo tiko. Ɨɨta sɨbʉkʉsɔ sidingi, ɓombu ɓodoku ndɨ kopika ɓandaɓʉ kaɓʉ kʉgʉ wa tabɨ yi.» ");
INSERT INTO lik_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yeso ʉtwɨlya ɓata ndɨ lizuni lagɔgɔ ɓɛ: «Ɓʉngama ɓa kʉgʉ wa lɨsyɛ a mʉɗɔngɔnɨ abɛ sɨbʉkʉsɔ nɨsɔ ofulisaga mukati. Muko ɓemoti ava ndɨ, opula ka ɓambɨkɛ ɓayɨsaa ɓaya fufu kadwɛ kʉkwakʉ fufu ofula ndɨ mino wasɨ ɓɨdaɨ-daɨ.» ");
INSERT INTO lik_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yeso ʉnzɨnɨlyaga ndɨ ɓambaza ka ɓambanzʉ makpʉmʉka masɨ mi nɨmɔ ka mozuni aka. Na kɛgʉ ndɨ na lɨkpʉmʉka nɨlɔ ʉɓɨkyaga ndɨ nɨ kotwigʉ lizuni. ");
INSERT INTO lik_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","A ɓɛyɔ, igyonosa ndɨ ɓɛyɔ kyɛ ɨtʉlyanɨ nɨlɔ ɨɓɨkya ndɨ pisi ka mugyalandʉ ɓɛ: «Nanzɨnaga ndɛkɛ pisi ka mozuni. Natʉmbʉlaga ndɛkɛ ɓɨngbanganya makpʉmʉka nɨmɔ ɨsʉma ndɨ katʉkya ka mʉpʉnganagɨ ma ɔɓɨlɨ.» ");
INSERT INTO lik_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Kumbuso yi, Yeso ʉsa ndɨ ɓambaza ka ɓambanzʉ, ogulya ndɨ ka ndaɓʉ. Ɓaɓɨɓya kakɨ ɓodoku ndɨ kaɓɨkya ɓɛ: «Tɨtʉmbʉlyaga isi ya lizuni la tɔnɨtɔ tanyɛ nɨtɔ a ndɨ ko tiko.» ");
INSERT INTO lik_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yeso usikisya ndɨ ɓɛ: «Nɨnɔ akʉnaga masɔlɔ manza nɨ Mika-Mʉmbanzʉ. ");
INSERT INTO lik_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Tiko nɨ ɔɓɨlɨ. Masɔlɔ manza nɨ ɓambanzʉ nɨɓɔ ka ɓʉngama ko Kunzi. Na tɔnɨtɔ tanyɛ nɨ ɓambanzʉ niɓɔ ɓʉkananaga na Mumuyoniso. ");
INSERT INTO lik_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Alʉkʉ nɨnɔ odoku ndɨ kakʉna tɔnɨtɔ tanyɛ nɨ mumuyoniso. Buulya masɔlɔ nɨ muliɓo ma ɔɓɨlɨ. Na ɓagya-ligubo nɨ ɓamalaika. ");
INSERT INTO lik_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ɓɛyɔ ɓanyɔgɔ mino tɔnɨtɔ tanyɛ ɓaɗɨkɨta ko ɓuku, ika ndɛkɛ mʉɗɔngɔnɨ ɓɛgɛyɔ ka muliɓo ma ɔɓɨlɨ. ");
INSERT INTO lik_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mika-Mʉmbanzʉ ʉtɨka ndɛkɛ ɓamalaika kakɨ, kaʉtʉmba ka ɓʉngama kakɨ ɓatʉ ɓasɨ nɨɓɔ ɓʉmakyaga ɓɛngɛnɨ ka ɓʉnyɛ na ɓasɨ nɨɓɔ ɓagyaga ɓʉnyɛ. ");
INSERT INTO lik_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ɓʉɗɨkɨta ndɛkɛ ko fulu wo ɓuku. Na kʉ ɓɛyɔ, ɓagamana ndɛkɛ na ɓɨlya manzʉ ɓɨkyalʉ-kyalʉ. ");
INSERT INTO lik_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ko ngbingo yi nɨnɔ, ɓatʉ ɓongbingbili ɓika ndɛkɛ ɓiwenge-wenge abɛ mɔnɨ ka ɓʉngama ka Abaɓʉ. Nɨnɔ a na motili, ʉkanɨtɔ!» ");
INSERT INTO lik_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","«Ɓʉngama ɓa kʉgʉ wa lɨsyɛ a mʉɗɔngɔnɨ abɛ luki la ɨzangɨya nɨlɔ ɨsʉma ndɨ ko tiko. Nɨyɔ mʉtʉ ɓemoti ɨna ndɨ, asʉma ɓata. Ogwa ndɨ magyagya kʉgbɛ, ɨnda kagaba makpʉmʉka kakɨ masɨ ɓingbufu, oluwa tiko yi nɨyɔ. ");
INSERT INTO lik_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ɓʉngama ɓa kʉgʉ wa lɨsyɛ a ɓata mʉɗɔngɔnɨ abɛ ambula ɓemoti nɨnɔ akɨsaga ndɨ koluwo sanga yanzanza. ");
INSERT INTO lik_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ngbingo yi nɨnɔ ɨna ndɨ mino mʉsanga ma lɨgabʉ lapʉ kʉgbɛ, ɨnda ndɨ kagaba makpʉmʉka kakɨ masɨ, odoku ndɨ koluwo.» ");
INSERT INTO lik_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«Ɓʉngama ɓa kʉgʉ wa lɨsyɛ a ɓata mʉɗɔngɔnɨ abɛ moyo nɨmɔ ɓoɗinga ndɨ ko liɓa lidingi. Moyo mi nɨmɔ ugwi mobi ma ɓosi masɨ. ");
INSERT INTO lik_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Nɨyɔ otiwo, ɓoɗuɗula kʉwa ndɨ kubi. Ɓanyɔ ɓosi ɓikanana ndɨ kaʉmʉmʉla ɓosi ɓanzanza ka ɓɛngbɔlɔ. Luki limoti, ɓumbimba ndɨ nɨɓɔ ɓanyɛnyɛ. ");
INSERT INTO lik_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ika ndɛkɛ mʉɗɔngɔnɨ ɓɛgɛyɔ ka muliɓo ma ɔɓɨlɨ. Ɓamalaika ɓodoku ndɛkɛ kaʉgbanana ɓatʉ ɓanyɛ na nɨɓɔ ɓongbingbili. ");
INSERT INTO lik_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Nɨɓɔ ɓanyɛ, ɓʉɗɨkɨtaga ndɛkɛ ko fulu wo ɓuku. Na kʉ ɓɛyɔ, ɓagamana ndɛkɛ na ɓɨlya manzʉ ɓɨkyalʉ-kyalʉ.» ");
INSERT INTO lik_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yeso umuusa kʉwa ndɨ ɓaɓɨɓya kakɨ ɓɛ: «Ambɛ, mukonito ɓɨnza makpʉmʉka masɨ nɨmɔ namuɓikyi?» Ɨɓʉ aka ndɨ ɓɛ: «Iyo.» ");
INSERT INTO lik_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Kumbuso yi, uɓikyoku ndɨ ɓɛ: «Kinili, muwonisilo wa mʉtʉʉ wasɨ nɨnɔ ɓawonisilo lɨkpʉmʉka la Ɓʉngama ɓa kʉgʉ wa lɨsyɛ, a mʉɗɔngɔnɨ abɛ mombukwana ndaɓʉ. Mombukwana ndaɓʉ yi nɨnɔ anyɔgɔ ka lɨngama kakɨ makpʉmʉka mambɨya na nɨmɔ mandɛlɨ.» ");
INSERT INTO lik_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Nɨyɔ Yeso ama ndɨ katwaga mozuni mi nɨmɔ, atʉkya ndɨ wa. ");
INSERT INTO lik_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Aga ndɨ ka Nazalɛtɨ kʉ opinga ndɨ mino. Kʉ ɓɛyɔ, apʉnga ndɨ kapá mʉtʉʉ ka ndaɓʉ ya malʉmba ka Ɓayuda. Nɔkʉ ʉdɨka ndɨ ɓambanzʉ ɓɨdɛ, ɓanimuusa ɓɛ: «Wanɨ nɔ apá yimibo no ngu yɨgya makpʉmʉka mʉmbanga-mbanga ɓɛnɛ? ");
INSERT INTO lik_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ambɛ, kɛgʉ mbɛyɨ mika mʉsɛmala mʉ? Kɛgʉ amakɨ nɨ Malia? Kɛgʉ mbɛyɨ ɓamamakɨ nɨ Yakɔbɔ, Yɛzɛfʉ, Simoni na Yuda? ");
INSERT INTO lik_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Takikogigʉ mbɛyɨ na ɓasalɨ kakɨ ɓasɨ pa imoti wanʉ? Wanɨ nɔ apá kʉwa yimibo no ngu nɨyɔ?» ");
INSERT INTO lik_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Kinili ɓakakwananagʉ ndɨ kaɓɨnɨkyana. Luki limoti, Yeso ʉɓɨkya ndɨ ɓɛ: «Mugyalandʉ a na ɨbɨba pa yasɨ, luki limoti, kɛgʉ nolu ka mugi nɨmɔ ɨɓʉkʉto mino ikanɨ ka lɨvananza kakɨ.» ");
INSERT INTO lik_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Kinili, Yeso kagyagʉ ndɨ ɓata makpʉmʉka mʉmbanga-mbanga mudingi kʉ ɓɛyɔ, kyɛ ɓatʉ ɓi nɨɓɔ ɓakɛgʉ ndɨ kaɓɨnɨkyana. ");
INSERT INTO lik_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ko ngbingo yi nɨnɔ, Ɛlɔdɨ ngama mudingi wa iwili ya Galilaya, ʉkana ndɨ mongoni ka Yeso. ");
INSERT INTO lik_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ʉɓɨkya ndɨ ɓagya-ligubo kakɨ ɓɛ: «Mʉtʉ yi nɨmʉ nɨ Yuani-Mubatizaɨ! Opupiniku ka ɓabɨlɨ! Kinili, a kʉwa no ngu kagya makpʉmʉka mʉmbanga-mbanga.» ");
INSERT INTO lik_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","A ɓɛyɔ, Ɛlɔdɨ a ndɨ nɨ agwisisini Yuani, akondisiso, ɓaɗɨkɨta ka bɔlɔkɔ. Ɛlɔdɨ agya ndɨ ɓɛyɔ, ko bulya ka muka ɓemoti nɨnɔ ina ndɨ ɓɛ Elodia. Ɨyɨ Elodia a ndɨ muka mamakɨ Yuani nɨnɔ ina ndɨ ɓɛ Filipi. ");
INSERT INTO lik_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Yuani a ndɨ kayoyisa ngama Ɛlɔdɨ ɓɨngbanganya ɓɛ: «Kakwananigʉ kava Elodia.» ");
INSERT INTO lik_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Kʉwa wa, Ɛlɔdɨ a ndɨ kapa kamwisisa Yuani. Luki limoti, a ndɨ kaʉɓanga ɓambanzʉ. Ɓambanzʉ ɓasɨ ɓamɨnaga ndɨ Yuani ɓɛ a mugyalandʉ. ");
INSERT INTO lik_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Wɨna sɛ, a ndɨ lɨsyɛ lo dumo mutomosya yɨɓʉkʉta ka ngama Ɛlɔdɨ. Mika Elodia nɨnɔ mʉsɨka yi oɓina ndɨ kambwa ka ɓatʉ nɨɓɔ ɓʉmaka ndɨ wa. Miki nɔ akɔ ndɨ Ɛlɔdɨ lɨmbɛngɨ ɓɨkya, ");
INSERT INTO lik_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","kinili, Ɛlɔdɨ apá ndɨ agʉmɛ pisi ka silika ɓɛ: «Nʉpátʉ luki lasɨ nɨlɔ wɛkʉnga.» ");
INSERT INTO lik_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Kʉwa wa, mʉsɨka nɔ ɨnda ndɨ kamuusa amakɨ. Nɨyɔ amakɨ atɨwa, ɨnda kʉwa kaɓɨkya Ɛlɔdɨ ɓɛ: «Ipóku, wa aka wanʉ, mʉ ka Yuani-Mubatizaɨ ka papɨ.» ");
INSERT INTO lik_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ngama alya ndɨ kumbu kʉgbɛ. Luki limoti, kakwananagʉ ndɨ ɓata kakya ko bulya silika nɨnɔ akɔ ndɨ kambwa ka ɓatʉ nɨɓɔ ʉmaka ndɨ ko dumo wa. ");
INSERT INTO lik_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Atɨka ndɨ kakoku Yuani-Mubatizaɨ mʉ kʉ ka ndaɓʉ ya bɔlɔkɔ. ");
INSERT INTO lik_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Kʉwa wa, ɓodoku nomu ka papɨ, ɓapá ndɨ mʉsɨka yi nɨnɔ. Ɨyɨ, amɨndɨlya ndɨ na imu amakɨ. ");
INSERT INTO lik_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Kumbuso yi, ɓaɓɨɓya ka Yuani ɓodoku ndɨ kava manda kakɨ, ɓaga kolumbo. Ɓɨnda kʉwa ndɨ katʉmbʉlyaga Yeso mongoni mi nɨmɔ. ");
INSERT INTO lik_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ngbingo yi nɨnɔ Yeso ʉkana ndɨ mina mongoni mi nɨmɔ, atʉkya ndɨ wa mʉkaka ka ɨngbɔlɔ yidingi. Ɨnda ndɨ ɓɨkɛɗɛ ka pa nɨyɔ mʉmbanzʉ kɛgʉ ndɨ mino. Luki limoti, wa ɓambanzʉ ɓʉkana mina ɓɛyɔ, ɓatʉkya ndɨ ka ɓagʉɗʉ na magʉ, ɓɨnda kaɓyɛ. ");
INSERT INTO lik_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ngbingo yi nɨnɔ Yeso osya ndɨ mina ka ɨngbɔlɔ, ʉmɨna ndɨ ɓambanzʉ ɓudingi kʉgbɛ, ukwilya kumbu. Luga kaɓʉ, uhukusa ndɨ ɓatʉ nɨɓɔ ɓa ndɨ na ɓokoloɓu. ");
INSERT INTO lik_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Nɨyɔ ɓʉgɔgɔ osyo, ɓaɓɨɓya ɓakpuɗoku ndɨ, ɓaɓɨkya ndɨ ɓɛ: «Wanʉ a ɨsa, na ngbingo okitogini. Yɛkɨ a ɓɛyɔ, ʉkpamya ɓambanzʉ nɨɓa ɓaga ko giyo kailuulyo luki lɨlya.» ");
INSERT INTO lik_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Luki limoti, Yeso usikisya ndɨ ɓɛ: «Kokwononigʉ ɓɛ ɓaga kʉ. Hupóno nɨ iɓunu aka ɓamombukwono-donu ɓi malɨlɨ.» ");
INSERT INTO lik_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ɨɓʉ, ɓaɓɨkya ndɨ ɓɛ: «Wanʉ, iɓusu ta na mukati kuɓukumuti aka na ɓosi ɓaɓa.» ");
INSERT INTO lik_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yeso ʉɓɨkya kʉwa ndɨ ɓɛ: «Ipóniku wanʉ.» ");
INSERT INTO lik_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Kumbuso yi, ʉkpamya ndɨ ɓambanzʉ kaikonono ka tɔnɨtɔ. Ava ndɨ mukati kuɓukumuti na ɓosi ɓaɓa ɓi nɨɓɔ, atʉmba miso kʉgʉ wa lɨsyɛ, abibisa Kunzi. Oɓunanaga ndɨ mukati mi nɨmɔ, ʉpága ɓaɓɨɓya kakɨ. Ɨɓʉ, ɓʉgbananɨlyaga ndɨ ɓambanzʉ. ");
INSERT INTO lik_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ɨɓʉ ɓasɨ ɓalyalya ndɨ na ɓikutogo ɓɨkpɛkɛɗɛ-kpɛkɛɗɛ. Kumbuso yi, ɓaɓɨɓya ɓamʉmʉla ndɨ ɓodongbu nɨɓayɔ asɨkana ndɨ, otumo mʉmbɨ tɛkɛɓɛ na mɨɓa. ");
INSERT INTO lik_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ɓatʉ nɨɓɔ ɓalyalya ndɨ ɓa ndɨ banda ɓalʉkʉ ɓɛlɔfʉ kuɓukumuti nɨ ɓakutongigʉ ɓoko na ɓomiki. ");
INSERT INTO lik_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Kumbusa wa nɨyɔ, Yeso ʉkpamya ndɨ ɓaɓɨɓya kakɨ ɓɛ ɓaɗakɨ ka ɨngbɔlɔ yidingi, ʉtakanyɨ kʉsyakʉ wa ibombu. Ko ngbingo yi nɨnɔ, ɨyɨ asɨkana ndɨ kaʉpá ɓambanzʉ lɨgʉndʉ. ");
INSERT INTO lik_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Nɨyɔ ʉpá ɓambanzʉ lɨgʉndʉ, aɗaka ndɨ ɓɨkɛɗɛ ka ngʉpa kalʉmba. Nɨyɔ biti osyo, Yeso a ɓata ndɨ kʉ kwa kʉ mʉkaka. ");
INSERT INTO lik_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ɨngbɔlɔ yi nɨyɔ a kʉwa ndɨ nɨ itundulini ka lɨmbɛngɨ lo liɓo. Mʉɓaka a ndɨ koyungo ɓiyongo-yongo. Na muvivi a ndɨ kakpɨngbaga. ");
INSERT INTO lik_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ko mbolugo, Yeso ɨnda ndɨ misa kʉ ɓaɓɨɓya kakɨ ɓa ndɨ mino nɨ anakpakyana kʉgʉ wo liɓo ɓɨpapapa. ");
INSERT INTO lik_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Nɨyɔ ɓaɓɨɓya ɓamɨna ndɨ kakpakyana kʉgʉ wo liɓo ɓɛyɔ, ɓaɓanga ndɨ kʉgbɛ. Ɓaɓɨkya ndɨ ɓɛ: «Abɨlɨ mʉ!» Ɓapʉnga ndɨ kakʉgwaga na kʉɓangakʉ. ");
INSERT INTO lik_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Luki limoti, ko ngbingo yi nɨnɔ aka nɔ, Yeso ʉɓɨkya ndɨ ɓɛ: «Wigwini mambɛngɨ, ɨmɨ nɔ! Makoɓongonitɔgʉ.» ");
INSERT INTO lik_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pɛtɛlɛ asikisya ndɨ ɓɛ: «Mombukwono-dosu! Kiko lɨngʉnʉ ɓɛ ɨwɛ nɔ, ɨkpamya nɨndɨ kʉ wo mino nɨ nanakpakyana gɔnɨ kʉgʉ wo liɓo.» ");
INSERT INTO lik_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yeso aka ndɨ na ɨyɨ ɓɛ: «Dokunɔ.» Kʉwa wa, Pɛtɛlɛ osya ndɨ ka ɨngbɔlɔ, apʉnga ndɨ kakpakyana kʉgʉ wo liɓo ɓɨpapapa kaɨnda misa kʉ Yeso a ndɨ mino. ");
INSERT INTO lik_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Luki limoti, ngbingo yi nɨnɔ ɨno mino muvivi mapʉ, aɓanga, apʉnga ndɨ kolindo. Apamɨkana ndɨ ɓɛ: «Hiii Mombukwono-dosu, ihukusanɔ ɓaka!» ");
INSERT INTO lik_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Wa aka wa, Yeso ananɨlya ndɨ kʉɓɔkʉkɔ, agwi. Kʉwa wa, aɓɨkya ndɨ ɓɛ: «Eze, wa mʉtʉ wa baya yɨkɛɗɛ! Ko bulya ɨkɨ yɔ wo ɓi mino na ɓotumo?» ");
INSERT INTO lik_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Nɨyɔ ɓaɗaka ndɨ ɨɓʉ ɓasɨ ɓaɓa ka ɨngbɔlɔ, muvivi mi nɨmɔ osya ndɨ. ");
INSERT INTO lik_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Kʉwa wa, ɓaɓɨɓya nɨɓɔ ɓa ndɨ ka ɨngbɔlɔ ɓoɓuna ndɨ moli kambwa ka Yeso, ɓaɓɨkya ɓɛ: «A lɨngʉnʉ, wa Miko Kunzi!» ");
INSERT INTO lik_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Nɨyɔ Yeso na ɓaɓɨɓya kakɨ ɓazaba ndɨ, ɓosila kʉwa ndɨ ka iwili ya Gɛnɛzalɛtɨ. ");
INSERT INTO lik_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ɓatʉ ɓa kʉ ɓɛyɔ ɓamiba ndɨ Yeso. Ɓapʉnga kʉwa ndɨ kowowisa mongoni kakɨ ka iwili yasɨ, ɓanadulyoku na ɓatʉ ɓa ɓokoloɓu ɓasɨ. ");
INSERT INTO lik_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ɓatʉ ɓa ɓokoloɓu ɓi nɨɓɔ, ɓɨtatanaga ndɨ na Yeso ɓɛ ɓavɨlɨnɔ ɓaka gʉtʉgʉ mʉ ma kutuko kakɨ aka. Ɓatʉ ɓasɨ nɨɓɔ ɓavɨlaga ndɨ, ɓahʉkagatʉ ndɨ. ");
INSERT INTO lik_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Lɨsyɛ limoti, Ɓafalisayɔ na ɓowonisilo ɓa mʉtʉʉ ɓotukyoku ndɨ ka Yelusalɛma. Ngbingo yi nɨnɔ ɓasilya ndɨ mina Yeso, ɓamuusa ɓɛ: ");
INSERT INTO lik_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Ko bulya ɨkɨ yɔ ɓaɓɨɓya kakʉ ɓakoɓuno mina yɨgya ka ɓotitosu? A ɓɛyɔ, ɓakɨsʉkʉsagɨgʉ maɓɔkʉ nɨ ɓakalyalya!» ");
INSERT INTO lik_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yeso usikisya ndɨ ɓɛ: «Yɛgʉ sɛ iɓunu, ko bulya ɨkɨ yɔ mo mino koɓuna mʉtʉʉ ko Kunzi ko bulya yɨɓyɛ yɨgya ka ɓotitonu? ");
INSERT INTO lik_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","A ɓɛyɔ, Kunzi aɓɨkya ndɨ ɓɛ: ‹Mʉɓanga abakʉ na amakʉ.› Omotiloku ɓɛ: ‹Mʉmbanzʉ kagbusyo abakɨ ikanɨ amakɨ, okwononi ɓamwɨ.› ");
INSERT INTO lik_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Luki limoti, iɓunu maɓɨkyaga ɓɛ mʉmbanzʉ akwanana kaɓɨkya abakɨ ikanɨ amakɨ ɓɛ: ‹Luki nɨlɔ nakwanano ɓi nolu kausingyo, nopí kʉwa ka apɛpɛ ko Kunzi.› ");
INSERT INTO lik_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Mʉtʉ yi nɨnɔ kakwananɨgʉ ɓata kaɓanga abakɨ ikanɨ amakɨ. Iɓunu makolimogo Lɨkpʉmʉka ko Kunzi ko bulya yɨɓyɛ yɨgya ka ɓotitonu. ");
INSERT INTO lik_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ɓatʉ ɓa kʉɓɔɓɔkʉ! Ɓugyalandʉ ka Isaya a ndɨ ɓa lɨngʉnʉ kʉgʉ kunu, ngbingo yi nɨnɔ aɓɨkya ndɨ mina ɓɛ: ");
INSERT INTO lik_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‹Ɓatʉ ɓi nɨɓa ɓaɓɨkyaga ɓɛ ɓɛɓangagatʉ, luki limoti, ɓɛmɨnaga payaya. ");
INSERT INTO lik_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Malʉmba nɨmɔ ɓɛgyɨlyaga a payaya. A ɓɛyɔ, mʉtʉʉ kaɓʉ akaɓyɛnɛnɛ na ɓopisi nɨɓayɔ ɓibisilyogo aka.›» ");
INSERT INTO lik_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Kumbuso yi, Yeso amaka ndɨ ambaza ka ɓambanzʉ, ʉɓɨkya ɓɛ: «Hukononi, motombisya ɓɨnza lɨkpʉmʉka li nɨlɨ. ");
INSERT INTO lik_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Luki nɨlɔ ingyaga ka mʉnɔkʉ ka mʉmbanzʉ kapágɨgʉ ɓʉnyɛ. Luki limoti, nɨlɔ opupogo lɔ apága ɓʉnyɛ.» ");
INSERT INTO lik_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Kʉwa wa, ɓaɓɨɓya ka Yeso ɓakpuɗoku ndɨ, ɓamuusa ɓɛ: «Wibito ɓi ɓɛ mʉnzɨna kakʉ utulito ɓi Ɓafalisayɔ?» ");
INSERT INTO lik_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yeso usikisya ndɨ ɓɛ: «Luki lasɨ nɨlɔ aɓakaga nɨ Baba nɨnɔ kʉgʉ wa lɨsyɛ kokunigʉ, ɓomukatʉ. ");
INSERT INTO lik_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Yɛkɨ a ɓɛyɔ, husoni! Ɓa ɓatʉ ɓo koloɓu ya mamɔmɔ nɨɓɔ ɓakaukpokyonisa ɓadaɓʉ! Mʉtʉ wo koloɓu ya mamɔmɔ kika kakpokyonisa dakɨ, ɨɓʉ ɓasɨ ɓaɓa ɓogwatʉ ka lɨɓyɛ.» ");
INSERT INTO lik_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pɛtɛlɛ aɓɨkya ndɨ ɓɛ: «Tɨtʉmbʉlyaga isi ya lizuni li nɨlɨ.» ");
INSERT INTO lik_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yeso usikisya ndɨ ɓɛ: «Ambɛ na gʉtʉgʉ iɓunu aka, makakwananɨgʉ kayibo isi yi? ");
INSERT INTO lik_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ambɛ, makibogigʉ mbɛyɨ ɓɛ luki lasɨ nɨlɔ ingyaga ka mʉnɔkʉ, osyaga ka mʉma, kumbuso yi, opupo, ɨnda ka lɨmbɨ? ");
INSERT INTO lik_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Luki limoti, lasɨ nɨlɔ opupaga ka mʉnɔkʉ ka mʉmbanzʉ, atʉkyaga ka lɨmbɛngɨ kakɨ. Na ilu lɔ apága mʉmbanzʉ ɓʉnyɛ. ");
INSERT INTO lik_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","A ɓɛyɔ, tamanaga yanyɛ opupogo ka lɨmbɛngɨ ka mʉmbanzʉ, lɨmwɔmwɔ, kasyɛ na muko ikanɨ mbʉnya ɓɛngɛnɨ, ɓʉɗanda, kuɓakʉ, mʉtamanagɨ mʉɓɨkya ɓɔngɔ na ɓanvɛnvɛ. ");
INSERT INTO lik_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Nɨmana masɨ mɔ apága mʉmbanzʉ ɓʉnyɛ. Luki limoti, kalyalya nɨ wakisukusigʉ maɓɔkʉ kakwananɨgʉ kapá mʉmbanzʉ ɓʉnyɛ.» ");
INSERT INTO lik_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Kumbuso yi, Yeso atʉkya ndɨ wa, ɨnda ndɨ misa ya iwili ya Tilo na nɨyɔ ya Sidɔna. ");
INSERT INTO lik_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Kʉ ɓɛyɔ, Waɓakanana ɓemoti asilya ndɨ. Muko yi nɨnɔ akʉkwaga ndɨ, aɓɨkya ɓɛ: «Hiii Mombukwono-dosu, Mika ngama Daudi, ikwilyanɔ ɓaka kumbu! Mikamɨ mʉsɨka yi akaigyogyisa kʉgbɛ na lɨmbɛngɨ la ɓʉnyɛ!» ");
INSERT INTO lik_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Luki limoti, Yeso kasikisyagʉ ndɨ lɨkpʉmʉka gʉtʉgʉ limoti aka. Kʉwa wa, ɓaɓɨɓya kakɨ ɓakpuɗoku ndɨ, ɓɨtatanaga na ɨyɨ ɓɛ: «Mʉkpamya nɛkɨ muko yi nɨmʉ aga, kyɛ akatigbomisa ɓamʉ aka na mʉpamʉ.» ");
INSERT INTO lik_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Usikisya ndɨ ɓɛ: «Ɓetikoku ndɨ ka Ɓezaleli aka, nɨɓɔ ɓa mʉɗɔngɔnɨ abɛ ɓakɔndɔlɔ nɨɓɔ ɓoɓungaga ndɨ.» ");
INSERT INTO lik_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Luki limoti, muko yi nɨnɔ odoku ndɨ koɓuna moli kambwa kakɨ, ɨtatanaga ndɨ na ɨyɨ ɓɛ: «Hiii Mombukwono-dosu, kikiliki, isingyanɔ ɓaka!» ");
INSERT INTO lik_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yeso asikisya ndɨ ɓɛ: «Kɛgʉ ɓɨnza kava malɨlɨ ka ɓomiki, kaumbimbilya ɓɛnva.» ");
INSERT INTO lik_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Muko yi nɨnɔ aɓɨkya ndɨ ɓɛ: «A ɓɛyɔ, Mombukwono-dosu. Luki limoti, gʉtʉgʉ ɓɛnva aka ɓalyagatʉ gɔnɨ kumbo ya ɓamalɨlɨ nɨmɔ anyʉkaga ka mɨza ka mombukwana-daɓʉ.» ");
INSERT INTO lik_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Kʉwa wa, Yeso asikisya ndɨ ɓɛ: «Yɛ ma, baya kakʉ a yidingi! Igyonosi ku kakʉ mʉɗɔngɔnɨ ɓɛyɔ baya kakʉ o mino.» Ko ngbingo yi nɨnɔ aka nɔ, mɨkakɨ mʉsɨka yi ahʉka ndɨ. ");
INSERT INTO lik_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Kʉmbuso yi, Yeso atʉkya ndɨ kʉ, ɨnda ka mutili ma ibombu ya Galilaya. Kʉ ɓɛyɔ, aɗaka ndɨ ka ngʉpa, iko. ");
INSERT INTO lik_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Kʉwa wa, ɓambaza ka ɓambanzʉ ɓudingi ɓakpuɗoku ndɨ. Ɓadulyogoku ndɨ na ɓatʉ ɓa mʉtɨngbɨ, nɨɓɔ ɓa ɓokoloɓu ɓaya mamɔmɔ, ɓazɛgɛsɨ, ɓoɓoɓo na ɓatʉ ɓagɔgɔ ɓa ɓokoloɓu ɓudingi. Ɨɓʉ ɓasɨ, ɓubisaga ndɨ kambwa ka Yeso na ɨyɨ anuhukuso. ");
INSERT INTO lik_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Nɔkʉ ʉdɨka ndɨ ɓambanzʉ nɨɓɔ ɓa ndɨ ka ɓambaza wa ɓɨdɛ kaʉmɨna ɓaɓoɓo kanzɨna, ɓatʉ ɓa mʉtɨngbɨ kananɨkana, ɓazɛgɛsɨ kakpakyana na ɓatʉ ɓa ɓokoloɓu ɓaya mamɔmɔ kaɨna. Ɓapʉnga kʉwa ndɨ kabibiso Kunzi wa Izaleli. ");
INSERT INTO lik_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yeso ʉmaka kʉwa ndɨ ɓaɓɨɓya kakɨ, ʉɓɨkya ɓɛ: «Nakaʉmɨnyɨlya ɓatʉ ɓi nɨɓana kumbu. Ta kʉwa na ɨɓʉ na masyɛ masaa, ɓakɛgʉ ɓata no luki lɨlya. Nakɛgʉ kapa kaʉsa ɓɛ ɓaga nɨ ɓanɨmʉkana ɓanza. Ɓakaga ɓɛyɔ, yagɔgɔ nzʉyɨ ʉdɨkagatʉ ko pisi.» ");
INSERT INTO lik_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ɓaɓɨɓya kakɨ ɓamuusa ndɨ ɓɛ: «Wanʉ ka ɨsa, tinisonoku na malɨlɨ yanɨ nɨmɔ akwanana ɓɛ ambaza mudingi ka ɓambanzʉ ɓɛnɛ ikuti?» ");
INSERT INTO lik_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yeso umuusa ndɨ ɓɛ: «Ma na mukati mɨnga?» Ɓasikisya ndɨ ɓɛ: «Ta na mukati maɗɨya na ɨka na ɓosi ɓakɛɗɛ aka.» ");
INSERT INTO lik_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Kʉwa wa, Yeso ʉkpamya ndɨ ɓambanzʉ ɓɛ ɓikononi wasɨ. ");
INSERT INTO lik_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ava ndɨ mukati maɗɨya na ɨka na ɓosi ɓi nɨɓɔ. Kumbuso kabibiso Kunzi, oɓunonogo, ʉpága ɓaɓɨɓya kakɨ, ɓʉgbananɨlyaga kʉwa ndɨ ɓambanzʉ. ");
INSERT INTO lik_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ɨɓʉ ɓasɨ ɓalyalya ndɨ, ɓikutogo ɓɨkpɛkɛɗɛ-kpɛkɛɗɛ. Kumbuso yi, ɓaɓɨɓya ɓamʉmʉlaga ndɨ ɓodongbu nɨɓayɔ asɨkana ndɨ, otuma ndɨ mʉmbɨ maɗɨya na ɨka. ");
INSERT INTO lik_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ɓatʉ nɨɓɔ ɓalyalya ndɨ, ɓa ndɨ banda ɓalʉkʉ ɓɛlɔfʉ ɓakwanganya nɨ ɓakutongigʉ ɓoko na ɓomiki. ");
INSERT INTO lik_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Kumbuso Yeso kaʉpá ɓambanzʉ ɓi nɨɓɔ lɨgʉndʉ, aɗaka ka ɨngbɔlɔ, aga ndɨ ka iwili ya Magadani. ");
INSERT INTO lik_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ɓafalisayɔ na Ɓasadukayɔ ɓakpuɗoku ndɨ Yeso kaɓɔɓɔ. Ɓaɓɨkya kʉwa ndɨ ɓɛ ʉwanyɨ likingyosi kotukyoku kʉgʉ wa lɨsyɛ. ");
INSERT INTO lik_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Luki limoti, usikisya ndɨ ɓɛ: «Na ɓʉgɔgɔ, nɨyɔ mɨnaga ɓɛ ɓɛkʉɓa a ɓɨngbʉ, maɓɨkyaga ɓɛ lɨsyɛ asyɛtʉ lanza na ɓʉgala. ");
INSERT INTO lik_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Na ɓʉsɔɓɨ, ɓɛkʉɓa kopiyo, maɓɨkya ɓɛ mbwayɨ alʉkatʉ. Iɓunu, makwananatʉ kaiba mokingyosi dididi ma ɓɛkʉɓa. Luki limoti, makakwananɨgʉ kaiba mokingyosi mo ngbingo yi nɨmʉ. ");
INSERT INTO lik_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Iɓunu ɓatʉ ɓa lɨsyɛ li nɨlɨ, ma ɓanyɛ na makokwononigʉ ko misa ko Kunzi! Makakʉnga ɓɛ ɓamuwonisi likingyosi. Makɨnɨgʉ likingyosi lagɔgɔ kiki nɨlɔ aka lɔ ka mugyalandʉ Yɔna.» Kʉwa wa, Yeso ʉsa ndɨ, ɨmagalya ɨyɨ. ");
INSERT INTO lik_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ngbingo yi nɨnɔ ɓaɓɨɓya ka Yeso ɓazaba ndɨ mina liɓo lidingi, ɓaɓʉsala ndɨ kava mukati. ");
INSERT INTO lik_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ʉɓɨkya kʉwa ndɨ ɓɛ: «Wiminyonito na kʉɓɔɓɔkʉ ka Ɓafalisayɔ nɨkwɔ a abɛ sɨbʉkʉsɔ nɨsɔ ofulisaga mukati na yɨgya ka Ɓasadukayɔ.» ");
INSERT INTO lik_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ɓaɓɨɓya ɓapʉnga ndɨ kanzɨna luga kaɓʉ ɓɛ: «Akaɓɨkya ɓɛyɔ kyɛ takavigʉ ɓi mukati.» ");
INSERT INTO lik_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yeso iba ndɨ tamanaga kaɓʉ, ʉɓɨkya kʉwa ndɨ ɓɛ: «Eze, ma ɓatʉ ɓa baya yɨkɛɗɛ! Ko bulya ɨkɨ yɔ mo mina kanzɨna luga kunu ɓɛ makɛgʉ na mukati? ");
INSERT INTO lik_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Makonotombisyigʉ ndɛkɛ? Makɛgʉ mbɛyɨ katamana ɓɛyɔ ɓambanzʉ ɛlɔfʉ kuɓukumuti ɓikutaga ndɨ mino mukati kuɓukumuti? Mamʉmʉla ndɨ mʉmbɨ mɨnga ka nɨmɔ asɨkana ndɨ? ");
INSERT INTO lik_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ɓambanzʉ ɛlɔfʉ yɨkwanganya nɨɓɔ ɓikutaga ndɨ mukati maɗɨya na ɨka, na mʉmbɨ mɨnga mɔ mamʉmʉla ndɨ? ");
INSERT INTO lik_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ɨkɨ kʉwa makɛgʉ ɓi kotombisyo ɓɛ nakɛgʉ ɓi kamʉnzɨnɨlya ko bulya mukati ngbingo yi nɨnɔ no ɓi mino kamʉɓɨkya ɓɛ: Wikoni nɨ maniɓuulyo na yɨgya ka Ɓafalisayɔ na Ɓasadukayɔ nɨyɔ a abɛ sɨbʉkʉsɔ nɨsɔ ofulisogo mukati?» ");
INSERT INTO lik_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Kʉwa wa, ɓaɓɨɓya ɓiba ndɨ ɓɛ kɛgʉ kaɓɨkya ɓɛ ɓiki kaiɓuulya na sɨbʉkʉsɔ ka Ɓafalisayɔ na Ɓasadukayɔ nɨsɔ ofulisaga mukati. Luki limoti, a ndɨ kaʉɓɨkya ɓɛ ɓiɓuulyi na mʉtɨwɨ ka Ɓafalisayɔ na Ɓasadukayɔ. ");
INSERT INTO lik_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ngbingo yi nɨnɔ Yeso ɨnda ndɨ mina misa ya mugi ma Kaizalɨa-Filipi, umuusa ndɨ ɓaɓɨɓya kakɨ ɓɛ: «Ɓambanzʉ ɓa pɨyɛ kaɓɨkya ɓɛ Mika-Mʉmbanzʉ nɨ wanɨ?» ");
INSERT INTO lik_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ɓasikisya ndɨ ɓɛ: «Ɓemoti-ɓemoti ɓakaɓɨkya ɓɛ ɨyɨ nɨ Yuani-Mubatizaɨ. Ɓagɔgɔ ɓɛ ɨyɨ nɨ Ɨlɨya. Ɓagɔgɔ ɓata ɓɛ ɨyɨ nɨ Yelemia, ikanɨ ɓemoti ka ɓogyalandʉ.» ");
INSERT INTO lik_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yeso umuusa ndɨ ɓata ɓɛ: «Yɛgʉ sɛ iɓunu, makaɓɨkya ɓɛ ɨmɨ nɨ wanɨ?» ");
INSERT INTO lik_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simoni Pɛtɛlɛ asikisya ndɨ ɓɛ: «Ɨwɛ, wa Kilisito! Wa Miko Kunzi nɨnɔ a na ɔɓɨlɨ!» ");
INSERT INTO lik_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yeso aɓɨkya ndɨ ɓɛ: «Simoni mika Yɔna, wa mʉtʉ wa mazɨyɔ! A ɓɛyɔ, kɛgʉ mʉmbanzʉ nɔ utumbulyogi. Luki limoti, Baba nɨnɔ a kʉgʉ wa lɨsyɛ. ");
INSERT INTO lik_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ɨmɨ, nakaʉɓɨkya ambɛ ɨwɛ nɨ Pɛtɛlɛ. Na kʉgʉ wa lɨtalʉ li nɨlɨ, nopika ɓanʉ mino kanisa kamɨ. Na ngu ya kukwakʉ kikigʉ ndɛkɛ kʉgʉ yi. ");
INSERT INTO lik_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nʉpá ndɛkɛ lifungula la ɓʉngama ɓa kʉgʉ wa lɨsyɛ. Lasɨ nɨlɔ wakandaga ndɛkɛ wanʉ ka ɔɓɨlɨ, ɓakandaga ndɛkɛ kʉgʉ wa lɨsyɛ. Lasɨ nɨlɔ wakʉlaga ndɛkɛ wanʉ ka ɔɓɨlɨ, ɓakʉlaga ndɛkɛ kʉgʉ wa lɨsyɛ ɓɛgɛyɔ.» ");
INSERT INTO lik_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Kʉwa wa, Yeso ʉgbɨtyaga ndɨ ɓaɓɨɓya kakɨ ɓɛ ɓakaɓikyonitɔgʉ mʉmbanzʉ ɓɛ ɨyɨ nɨ Kilisito. ");
INSERT INTO lik_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Katʉkya ko ngbingo yi nɨnɔ, Yeso apʉnga ndɨ kaʉɓɨkya ɓaɓɨɓya kakɨ ɓɨngbanganya ɓɛ okwononi ɨndɨ ka Yelusalɛma. Na kʉ ɓɛyɔ, igyogyisatʉ kʉgbɛ ka maɓɔkʉ ka ɓambɔkʉ-mbɔkʉ, ɓokumu-kumu na ɓowonisilo ɓa mʉtʉʉ. Ɓamwisisatʉ, kumbusa wa masyɛ masaa opupo ka mbʉkʉ. ");
INSERT INTO lik_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Kʉwa wa, Pɛtɛlɛ amaka ndɨ ɓɨkɛɗɛ, apʉnga kayoyiso, anaɓɨkya ɓɛ: «Mombukwono-dosu! Kunzi ʉkpɨngbɨlyɨtɔ ɓaka nɨlɔ! Haaa, nɨlɔ kigyonosigʉ ndɛkɛ na ɨwɛ gʉtʉgʉ iki yi aka!» ");
INSERT INTO lik_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Luki limoti, Yeso oyikana ndɨ, aɓɨkya Pɛtɛlɛ ɓɛ: «Abɨlɨ mʉ! Kɨtaga kumbuso kamɨ! Wakakɨsa kegwisiso! Tamanaga kakʉ kɛgʉ abɛ nɨyɔ ko Kunzi, luki limoti, a abɛ nɨyɔ ka ɓambanzʉ.» ");
INSERT INTO lik_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Kumbuso yi, Yeso ʉɓɨkya ndɨ ɓaɓɨɓya kakɨ ɓɛ: «Mʉmbanzʉ kapa kɛɓɨɓya, okwononi ɨmʉyɨ ɨyɨ mombukwana-dakɨ yi ɓɨkpɛ, abɨnɨka mʉsalaba kakɨ, apʉnga kɛɓɨɓya. ");
INSERT INTO lik_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","A ɓɛyɔ, mʉmbanzʉ kapa kahukuso ɔɓɨlɨ kakɨ, aɓungusatʉ. Luki limoti, nɨnɔ aɓunguso ko bulya kamɨ, inisanatʉ ɓata na ɨyɨ. ");
INSERT INTO lik_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","A ɨzangɨya tino mʉmbanzʉ kainisana na lɨngama lasɨ la ɔɓɨlɨ nɨ aputini ɔɓɨlɨ kakɨ? Ɨkɨ yɔ akwanana ɓata kapá kyɛ ahukusi ɔɓɨlɨ kakɨ? ");
INSERT INTO lik_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Mika-Mʉmbanzʉ odokuto ka ɨbɨba ka Abakɨ pa imoti na ɓamalaika kakɨ. Akalya mʉmbanzʉ yɨkaka-yɨkaka kaɓyɛnɛnɛ na yɨgya kakɨ. ");
INSERT INTO lik_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","A lɨngʉnʉ, nakamʉɓɨkya ambɛ: ‹Ɓambanzʉ ɓemoti-ɓemoti luga kunu wanʉ, ɓakokwigʉ kanɨ nɨ ɓakaminigʉ Mika-Mʉmbanzʉ kodoku ka ɓʉngama kakɨ.›» ");
INSERT INTO lik_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Kumbusa wa masyɛ maɗɨya, Yeso ava ndɨ Pɛtɛlɛ, Yakɔbɔ na mamakɨ ɓɛyɔ ka Yuani. Aɗaka ndɨ na ɨɓʉ ɓasɨ ɓɨkɛɗɛ ka ngʉpa yɨkʉngʉ kʉgbɛ. ");
INSERT INTO lik_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Kʉ ɓɛyɔ, misa ka Yeso igomosyana ndɨ kambwa kaɓʉ, apʉnga kanzɛ abɛ mɔnɨ. Ɓotu kakɨ oɓuɓa ndɨ ɓitu kʉgbɛ abɛ libu. ");
INSERT INTO lik_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ɓaɓɨɓya ɓasaa ɓi nɨɓɔ ɓamɨna ndɨ Musa na Ɨlɨya ɓigbututu nɨ ɓananzɨna na Yeso. ");
INSERT INTO lik_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Kʉwa wa, Pɛtɛlɛ aɓɨkya ndɨ Yeso ɓɛ: «Mombukwono-dosu! A ɓɨnza iɓusu kaiko wanʉ. Wakapa, nopiki wanʉ ɓangbangba ɓayɨsaa, nɨyɔ kakʉ, nɨyɔ ka Musa na nɨyɔ ka Ɨlɨya.» ");
INSERT INTO lik_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ngbingo yi nɨnɔ Pɛtɛlɛ a mbɛyɨ ndɨ mino kanzɨna aka, lindindi lawenge-wenge utikya ndɨ. Kʉsɔ yi kʉ, lɨyʉ opuponoku ndɨ ɓɛ: «Nɨmʉna, a Mikamɨ mʉpaka! Nobisa lɨmbɛngɨ kʉgʉ kakɨ! Mumukononi ɨyɨ!» ");
INSERT INTO lik_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Nɨyɔ ɓaɓɨɓya ɓʉkana mina ɓɛyɔ, ɓaɓanga ndɨ kʉgbɛ. Ɓogwaga ndɨ mokpukpu wasɨ ɓɨngɔmʉ-ngɔmʉ. ");
INSERT INTO lik_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Luki limoti, Yeso ukpuɗoku ndɨ, ʉvɨlaga, ʉɓɨkya ɓɛ: «Womogoni, makoɓongonitɔgʉ!» ");
INSERT INTO lik_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Nɨyɔ ɓɨkwɛ, ɓamɨna kʉwa ndɨ Yeso aka mʉkaka. ");
INSERT INTO lik_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Nɨyɔ ɓa ndɨ kosyoku ka ngʉpa, ʉgbɨtyaga ndɨ ɓɛ: «Kpɔkpɔkpɔ, makatumbulyogonɨtɔgʉ mʉmbanzʉ lɨkpʉmʉka li nɨlɔ mini lɔ, kadwɛ kʉ kwa kʉ Mika-mʉmbanzʉ opupa ɓanʉ mina ka mbʉkʉ.» ");
INSERT INTO lik_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Kumbuso yi, ɓaɓɨɓya ka Yeso ɓamuusa ndɨ ɓɛ: «Ko bulya ɨkɨ yɔ ɓowonisilo ɓa mʉtʉʉ ɓaɓɨkyaga mina ɓɛ okwononi Ɨlɨya igiku mbɛyɨ?» ");
INSERT INTO lik_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yeso usikisya ndɨ ɓɛ: «A ɓɛyɔ, okwononi Ɨlɨya igiku mbɛyɨ, oɓungusyaga makpʉmʉka masɨ. ");
INSERT INTO lik_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Nakamʉɓɨkya ɓɨngbanganya ambɛ Ɨlɨya odoniku ndɨ. Luki limoti, ɓambanzʉ ɓakamibagʉ ndɨ, ɓa ndɨ kagya ɓɛyɔ aka yɔ ɓa ndɨ mina kapa. Gʉtʉgʉ Mika-mʉmbanzʉ aka, ɓagyogyiso ndɛkɛ ɓɛgɛyɔ.» ");
INSERT INTO lik_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ɓaɓɨɓya ɓiba kʉwa ndɨ ɓɛ Yeso a ndɨ kaʉnzɨnɨlya kʉgʉ ka Yuani-Mubatizaɨ. ");
INSERT INTO lik_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Nɨyɔ Yeso na ɓaɓɨɓya kakɨ ɓadwɛ ndɨ ɓuwobi na pa nɨyɔ ambaza ka ɓambanzʉ a ndɨ mino, mʉtʉ ɓemoti akpuɗoku ndɨ. Mʉtʉ yi nɨnɔ oɓuna ndɨ moli kambwa kakɨ. ");
INSERT INTO lik_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Aɓɨkya kʉwa ndɨ ɓɛ: «Hiii, Mombukwono-dosu! Mukwilyanɔ ɓaka mikamɨ kumbu. A na koloɓu ya lɨga, akaigyogyisa kʉgbɛ. Ogwaga kʉwa ɓongbinga ɓasɨ ko ɓuku ikanɨ ko liɓo. ");
INSERT INTO lik_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nindito ɓi na ɨyɨ ka ɓaɓɨɓya kakʉ. Luki limoti, ɓakokwononigʉ ɓi kahukuso.» ");
INSERT INTO lik_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yeso usikisya ndɨ ɓɛ: «Eeeze iɓunu, lɨvananza la masyɛ mi nɨma makɛgʉ na baya, ma ɓanyɛ! Nakwanana ndɛkɛ kaika pa imoti na iɓunu ɓongbinga ɓɨnga? Nakwanana kapɨla ɓʉzʉ kunu ɓongbinga ɓɨnga? Doku nɛkɨ na ɨyɨ kʉnʉ!» ");
INSERT INTO lik_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Nɨyɔ ɓapá ndɨ miki, Yeso apamɨlya lɨmbɛngɨ la ɓʉnyɛ nɨlɔ a ndɨ kʉsɔ kakɨ. Lɨmbɛngɨ la ɓʉnyɛ opupa ndɨ, wa aka wa miki nɔ aʉka ndɨ. ");
INSERT INTO lik_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kumbuso yi, ɓaɓɨɓya kakɨ ɓakpuɗoku ndɨ nɨ ɓa kʉwa asɨ ɨɓʉ aka, ɓamuusa ndɨ ɓɛ: «Ko bulya ɨkɨ yɔ iɓusu takokwononigʉ ɓi mina kokpumyo lɨmbɛngɨ la ɓʉnyɛ li nɨlɔ?» ");
INSERT INTO lik_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yeso usikisya ndɨ ɓɛ: «A kyɛ baya kunu a yɨkɛɗɛ. A lɨngʉnʉ, nakamʉɓɨkya ambɛ makiko ɓi na baya gʉtʉgʉ kanɨ a yɨkɛɗɛ aka abɛ maya ma agbɛɗɛ-gbɛɗɛ, makwanano ɓi kaɓɨkya ngʉpa yi nɨyɨ ɓɛ: ‹Tʉkya wanʉ, waga kʉ›, agatʉ ɓi. Kikigʉ ɓi no luki gʉtʉgʉ limoti aka nɨlɔ kakwananɨgʉ ɓi ku kunu.»  ");
INSERT INTO lik_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ngbingo yi nɨnɔ Yeso a ndɨ mina pa imoti na ɓaɓɨɓya kakɨ ka iwili ya Galilaya, ʉɓɨkya ndɨ ɓɛ: «Ɓasʉtatʉ ɓanʉ Mika-mʉmbanzʉ ka maɓɔkʉ ka ɓambanzʉ, ");
INSERT INTO lik_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ɓamwɔ. Kumbusa wa masyɛ masaa, opupoku ka mbʉkʉ.» Nɨyɔ ɓaɓɨɓya ɓʉkana ɓɛyɔ, ɓalya ndɨ kumbu kʉgbɛ. ");
INSERT INTO lik_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ngbingo yi nɨnɔ Yeso na ɓaɓɨɓya kakɨ ɓadwɛ ndɨ mino ka Kapɛlɛnaumu, ɓatʉ nɨɓɔ ɓolipisaga ndɨ manzanza wa ndaɓʉ ya malʉmba ɓakpuɗoku ndɨ Pɛtɛlɛ, ɓamuusa ɓɛ: «Muwonisilo kunu kakalyagɨgʉ ɨyɨ manzanza ma ndaɓʉ ya malʉmba?» ");
INSERT INTO lik_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pɛtɛlɛ usikisya ndɨ ɓɛ: «Iyo, akalyagatʉ.» Ngbingo yi nɨnɔ Pɛtɛlɛ ingya ndɨ mino ka ndaɓʉ, Yeso apʉnga ndɨ nɨ ɨyɨ kanzɨna. Amuusa ndɨ ɓɛ: «Simoni! Wakaɨna ɓʉnɨ? Ngbingo yi nɨnɔ ɓangama ɓa ɔɓɨlɨ nɨmʉ ɓikogo mino kolipiso manzanza, ɓulipisogo ɓatʉ ɓa lɨvananza kaɓʉ ikanɨ ɓobiko?» ");
INSERT INTO lik_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pɛtɛlɛ asikisya ndɨ ɓɛ: «Ɓulipisogo ɓobiko aka.» Yeso aɓɨkya kʉwa ndɨ ɓɛ: «A ɓɛyɔ, lɨvananza la ɓʉngama kakalyagɨgʉ ilu manzanza. ");
INSERT INTO lik_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Luki limoti, takɛgʉ kapa kaugwisiso ɓatʉ ɓi nɨɓɔ. Kinili, wɨnda ka ibombu, waɗɨkɨta kʉngakʉ. Musi nɨnɔ wanyɔ wa mambwa, wahukwa mʉnɔkʉ, kʉsɔ yi, watakanya ambuma wa lɨfalanga. Wava ambuma yi nɨnɔ, wakalya ko bulya manzanza kusu na ɨwɛ.» ");
INSERT INTO lik_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ko ngbingo yi nɨnɔ aka nɔ, ɓaɓɨɓya ka Yeso ɓakpuɗoku ndɨ, ɓamuusa ɓɛ: «Kʉsɔ wa ɓʉngama ɓa kʉgʉ wa lɨsyɛ, wanɨ nɔ a mʉtʉ wa ɨbɨba kʉgbɛ?» ");
INSERT INTO lik_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yeso amaka kʉwa ndɨ miki, abisa luga kaɓʉ. ");
INSERT INTO lik_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ʉɓɨkya ndɨ ɓɛ: «A lɨngʉnʉ, nakamʉɓɨkya ambɛ, kika nɨ mokoyikonigʉ, mika mʉɗɔngɔnɨ abɛ ɓomiki ɓakɛkɛkɛ, makingyigʉ ndɛkɛ ka Ɓʉngama ɓa kʉgʉ wa lɨsyɛ. ");
INSERT INTO lik_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Kika nɨ mʉmbanzʉ isisini, ika mʉɗɔngɔnɨ abɛ miki mʉkɛɗɛ yi nɨmʉ, ɨyɨ nɔ ika ɓanʉ mudingi ka Ɓʉngama ɓa kʉgʉ wa lɨsyɛ. ");
INSERT INTO lik_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Na kika nɨ mʉmbanzʉ atilyini miki mʉkɛɗɛ mʉɗɔngɔnɨ abɛ nɨmʉ ko lino kamɨ, etilyi ɨmɨ ɓɨkpɛ.» ");
INSERT INTO lik_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","«Luki limoti, mʉmbanzʉ kagwisisa ɓemoti ka ɓomiki nɨɓɔ ɓɛɓɨnɨkyana ka ɓʉnyɛ, okwononi kakpɨkɨla lɨtalʉ lakpʉ ko singasʉ, ɓaɗɨkɨta ko liɓo lidingi ɓikudumu. ");
INSERT INTO lik_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kumbu ka ɔɓɨlɨ! Ɓopisi kogwa ka ɓʉnyɛ a ɓayakpʉ! A ɓɛyɔ, a ɓɨnza ɓɛ ɓopisi ɓa kugwakʉ ikitɔ. Luki limoti, kumbu ka mʉtʉ yi nɨnɔ ulutaga ɓɛngɛnɨ kagya ɓʉnyɛ! ");
INSERT INTO lik_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Kika nɨ kʉɓɔkʉkɔ ikanɨ kʉgʉkɔ kakʉ umokyini ka ɓʉnyɛ, kɔ, wombimba ɓyɨ! A ɓɨnza kʉ kakʉ kogulya ka ɔɓɨlɨ walɨngʉnʉ na kʉɓɔkʉkɔ ikanɨ kʉgʉkɔ kumoti kakɨtaga wa wogulyo ɓi mino nomu masɨ. Kumbuso yi, ɓʉɗɨkɨta kʉwa ko ɓuku ɓa ɓɛnzɛ na ɓɛnzɛ. ");
INSERT INTO lik_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Kika nɨ liso umokyini ka ɓʉnyɛ, muko, wombimbo ɓyɨ! A ɓɨnza kʉ kakʉ kogulya ka ɔɓɨlɨ walɨngʉnʉ no lisa limoti kakɨtaga wa wogulyo ɓi mino nomu masɨ. Kumbuso yi, ɓʉɗɨkɨta ko ɓuku ɓa ɓɛnzɛ na ɓɛnzɛ.» ");
INSERT INTO lik_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","«Wiminyonito, makaminonitɔgʉ gʉtʉgʉ ɓemoti ka ɓomiki ɓi nɨɓa payaya! A ɓɛyɔ, nakamʉɓɨkya ambɛ, ɓamalaika kaɓʉ nɨɓɔ kʉgʉ wa lɨsyɛ ɓa masyɛ masɨ ɓuwobi na Baba.  ");
INSERT INTO lik_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Mika-Mʉmbanzʉ odoku ndɨ ka ɔɓɨlɨ kauhukuso nɨɓɔ ɓoɓungaga ndɨ. ");
INSERT INTO lik_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Makaɨna ɓʉ? Kika nɨ mʉmbanzʉ a mbɛyɨ na ɓakɔndɔlɔ mɨya, ɓemoti luga kaɓʉ oɓungogo. Ambɛ, kʉsɨgʉ mbɛyɨ ɓatɛkɛɓɛ kʉɓɔmʉ na kʉɓɔmʉ ka ngʉpa, aga kakɨsa nɨnɔ ɓemoti kika kanɨ oɓungogini? ");
INSERT INTO lik_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","A lɨngʉnʉ, nakamʉɓɨkya ambɛ, ngbingo yi nɨnɔ amɨno mino, ogwa magyagya kʉgbɛ, kakɨtaga ɓɛyɔ ikago mino na magyagya ka nɨɓɔ ɓakɔndɔlɔ ɓatɛkɛɓɛ kʉɓɔmʉ na kʉɓɔmʉ, nɨɓɔ ɓakoɓungagagʉ ndɨ. ");
INSERT INTO lik_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","A mʉɗɔngɔnɨ ɓɛgɛyɔ, Obonu nɨnɔ kʉgʉ wa lɨsyɛ kapagɨgʉ ɓɛ gʉtʉgʉ ɓemoti aka ka ɓomiki nɨɓana oɓungogi.» ");
INSERT INTO lik_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","«Kika nɨ mamakʉ ugyilyini ɓʉnyɛ, wɨnda kamɨna, miko iɓunu na ɨyɨ aka. Na kika nɨ umukonini, mɨgɨlya kʉwa ɓata yʉkanana. ");
INSERT INTO lik_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Luki limoti, kika nɨ kumukonigʉ, mʉva mʉtʉ wagɔgɔ ɓemoti ikanɨ ɓatʉ ɓaɓa, kyɛ ‹lɨkpʉmʉka imibisikosi lɨngʉnʉ kambwa ka ɓadɛmʉ ɓaɓa ikanɨ ɓasaa.› ");
INSERT INTO lik_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Kika nɨ okyini kaʉmʉkana, wɨnda katʉmbʉlaga ka kanisa. Kakya gɔnɨ kahʉkana kanisa, wava abɛ mʉtʉ nɨnɔ kamibigʉ Kunzi na mʉgya manyɛ abɛ ɓandɔmbɛ ɓa manzanza. ");
INSERT INTO lik_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","A lɨngʉnʉ, nakamʉɓɨkya ambɛ, masɨ nɨmɔ makandaga ndɛkɛ ka ɔɓɨlɨ, ɓakandaga ndɛkɛ kʉgʉ wa lɨsyɛ ɓɛgɛyɔ. Na masɨ nɨmɔ makʉlaga ndɛkɛ ka ɔɓɨlɨ, ɓakʉlaga ndɛkɛ kʉgʉ wa lɨsyɛ ɓɛgɛyɔ. ");
INSERT INTO lik_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","A lɨngʉnʉ, nakamʉɓɨkya ambɛ, kika nɨ ɓatʉ ɓaɓa luga kunu ka ɔɓɨlɨ ɓukononini kakʉnga lasɨ, Baba nɨnɔ kʉgʉ wa lɨsyɛ ʉpátʉ luki li nɨlɔ. ");
INSERT INTO lik_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","A ɓɛyɔ, pa nɨyɔ ɓatʉ ɓaɓa ikanɨ ɓasaa ɓomumukoni mino ko lino kamɨ, ɨmɨ, na wa luga kaɓʉ.» ");
INSERT INTO lik_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Kʉwa wa, Pɛtɛlɛ akpʉɗa ndɨ Yeso, amuusa ɓɛ: «Mombukwono-dosu, kika nɨ mika-mama egyilyini ɓʉnyɛ, nakwanana kapɨlya kadwɛ nganga yɨnga? Kadwɛ nganga maɗɨya na ɨka?» ");
INSERT INTO lik_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yeso asikisya ndɨ ɓɛ: «Nakaʉɓɨkya ambɛ, kɛgʉ asɨ kadwɛ nganga maɗɨya na ɨka aka. Luki limoti, nganga ɓatɛkɛɓɛ maɗɨya na ɨka nganga maɗɨya na ɨka. ");
INSERT INTO lik_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Kinili, likingyosi la Ɓʉngama ɓa kʉgʉ wa lɨsyɛ a mʉɗɔngɔnɨ abɛ ngama ɓemoti, nɨnɔ a ndɨ kapa ɓɛ ɓosunzu kakɨ ɓaɓɨkyɨ ɨsaɓʉ ya ɓoluɓu kaɓʉ. ");
INSERT INTO lik_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ngbingo yi nɨnɔ apʉnga ndɨ mino kaumuusogo, ɓadulyoku ndɨ na ɓemoti nɨnɔ a ndɨ no luɓu wo ɓuyi ɓakpʉ kʉgbɛ. ");
INSERT INTO lik_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Mʉgya-ligubo yi nɨnɔ kɛgʉ ndɨ no pisi yɨkalya luɓu yi nɨnɔ. Mombukwana-dakɨ akpamya ndɨ ɓɛ ɓagabɨ, pa imoti na mukakɨ, ɓomikakɨ na makpʉmʉka kakɨ masɨ, kadwɛ kʉ kwa kʉ igiso mino luɓu kakɨ. ");
INSERT INTO lik_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Musunzu yi nɨnɔ oɓuna ndɨ moli kambwa ka mombukwana-dakɨ, aɓɨkya ɓɛ: ‹Ɨpɨlyanɔ ɓaka! Nakalyatʉ luɓu kakʉ wasɨ.› ");
INSERT INTO lik_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Mombukwana-dakɨ akwilya ndɨ kumbu. Asa luɓu yi nɨnɔ, akpamya ndɨ ɓɛ aga. ");
INSERT INTO lik_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ngbingo yi nɨnɔ opupa ndɨ mino, ɓabangana na dakɨ mʉgya-ligubo. Dakɨ mʉgya-ligubo yi nɨnɔ a ndɨ no luɓu kakɨ mʉkɛɗɛ wa ɓambuma mɨya. Kʉwa wa, agwi ndɨ, ambɨmbɨta ko singasʉ ɓɨmbɨtɨtɨ, aɓɨkya ɓɛ: ‹Ɨkalya makpʉmʉka kamɨ!› ");
INSERT INTO lik_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Dakɨ mʉgya-ligubo yi nɨnɔ oɓuna ndɨ moli kambwa kakɨ. Aɓɨkya ɓɛ: ‹Ɨpɨlyanɔ ɓaka! Nakalyatʉ makpʉmʉka kakʉ.› ");
INSERT INTO lik_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Luki limoti, akya ndɨ. Aga kamokyisiso dakɨ nɨnɔ ka ndaɓʉ ya bɔlɔkɔ, kadwɛ ko ngbingo nɨnɔ akalya ndɛkɛ mino luɓu yi nɨnɔ. ");
INSERT INTO lik_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ngbingo yi nɨnɔ ɓawai-dakɨ ɓagya-ligubo ɓɨna ndɨ mino ɓɛyɔ, mambɛngɨ ʉtʉla ndɨ kʉgbɛ, ɓaga katʉmbʉlyaga mombukwana-daɓʉ masɨ nɨmɔ akɨtanaga ndɨ. ");
INSERT INTO lik_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Kʉwa wa, mombukwana-daɓʉ amaka ndɨ mʉgya-ligubo yi nɨnɔ, ɨyɨ aka na ɨyɨ ɓɛ: ‹Wa mʉgya-ligubo wanyɛ! Ngbingo yi nɨnɔ wɨtatanaga ndɨ mino na ɨmɨ ɓɛ nʉpɨlyɨ luɓu kakʉ, nʉpɨlyatʉ ndɨ ka masɨ. ");
INSERT INTO lik_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ɨwɛ, wakakwananɨgʉ ɓi kapɨlya dakʉ mʉgya-ligubo, mʉɗɔngɔnɨ ɓɛyɔ ɨmɨ nʉpɨlya ndɨ mino?› ");
INSERT INTO lik_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Lɨmbɛngɨ akandɨkanaga kʉwa ndɨ mombukwana-dakɨ ɓɨsʉlʉ-sʉlʉ. Asʉta ndɨ alʉkʉ nɔ ɓɛ ɓagyagyɨ kadwɛ kʉ kwa kʉ akalya ndɛkɛ mino makpʉmʉka kakɨ masɨ.» ");
INSERT INTO lik_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yeso aɓɨkya ndɨ ɓata ɓɛ: «Baba nɨnɔ a kʉgʉ wa lɨsyɛ amʉgya ndɛkɛ ɓɛgɛyɔ, kika nɨ ɓemoti kunu kɛgʉ kapɨlya mamakɨ na lɨmbɛngɨ kakɨ lasɨ.» ");
INSERT INTO lik_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ngbingo yi nɨnɔ Yeso ama ndɨ mina kaɓɨkyaga makpʉmʉka mi nɨmɔ, atʉkya ka Galilaya, ɨnda kʉwa ndɨ ka Yudɛa kʉsyakʉ wa Yɔlɔdanɨ. ");
INSERT INTO lik_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ɓambaza ɓudingi ka ɓambanzʉ ɓaɓyɛ ndɨ. Kʉ ɓɛyɔ, uhukuso nɨɓɔ ɓa ndɨ na ɓokoloɓu. ");
INSERT INTO lik_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Kʉwa wa, Ɓafalisayɔ ɓemoti-ɓemoti ɓakpuɗoku ndɨ kaɓɔɓɔ, ɓamuusa ɓɛ: «Ambɛ, mʉtʉʉ kusu akpamyatʉ mʉlʉkʉ kasikisa mukakɨ ko bulya ɓʉnyɛ ɓasɨ?» ");
INSERT INTO lik_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yeso usikisya ndɨ ɓɛ: «Makanotongulogigʉ ndɛkɛ iɓunu ɓɛ katʉkya ka mʉpʉnganagɨ ‹Kunzi agya ndɨ mʉlʉkʉ na muko?› ");
INSERT INTO lik_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Kumbuso yi, aɓɨkya ndɨ ɓɛ: ‹Kinili, mʉlʉkʉ asaga ndɛkɛ abakɨ na amakɨ. Ɓavanana na mukakɨ, ɨɓʉ ɓasɨ ɓaɓa ɓɨɨta kʉwa nzʉyɨ yimoti.› ");
INSERT INTO lik_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Kʉwa wa, ɓakikigʉ ɓata ɓaɓa, luki limoti, nzʉyɨ yimoti. Yɛkɨ a ɓɛyɔ, mʉmbanzʉ kogbonosonitɔgʉ nɨlɔ Kunzi omotoni.» ");
INSERT INTO lik_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ɓafalisayɔ ɓamuusa ɓata ndɨ ɓɛ: «Ko bulya ɨkɨ Musa akpamya ndɨ ɓɛ mʉlʉkʉ akwanana kapá mukakɨ balʉwa muɓuna ndʉwa kambwa kasikiso?» ");
INSERT INTO lik_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yeso usikisya ndɨ ɓɛ: «Musa amʉkpamya ndɨ kausikiso ɓoko kunu ɓɛyɔ ko bulya ɓʉpʉ ɓa mambɛngɨ kunu. Luki limoti, ka mʉpʉnganagɨ kaɓɨkyagʉ ndɨ ɓɛyɔ. ");
INSERT INTO lik_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nakamʉɓɨkya ambɛ, kika nɨ mʉmbanzʉ asikisini mukakɨ, kiki nɨ agwini na mʉlʉkʉ aka, ava wagɔgɔ, mʉlʉkʉ yi nɨnɔ ogyini ɓɨlya.» ");
INSERT INTO lik_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Kʉwa wa, ɓaɓɨɓya ka Yeso ɓaɓɨkya ndɨ ɓɛ: «Kika nɨ mʉtʉʉ a ɓɛyɔ kʉgʉ ka mʉlʉkʉ na mukakɨ, kɛgʉ nɛkɨ ɓɨnza kavanana!» ");
INSERT INTO lik_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yeso usikisya ndɨ ɓɛ: «Ɓambanzʉ ɓasɨ ɓakakwananɨgʉ kaʉkana mʉtʉʉ mi nɨma. Kiki nɨɓɔ aka ɓɔ Kunzi ʉpʉnaga ndɨ. ");
INSERT INTO lik_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Kaɓyɛnɛnɛ na nɨyɔ, ɓambanzʉ ɓemoti-ɓemoti ɓakavananagɨgʉ, kyɛ ɓɨɓʉkʉta gɔngʉ ɓɨbɔbɔbɔ. Ɓagɔgɔ kyɛ ɓambanzʉ ɓɔ ɓʉgya ndɨ ɓɛ ɓakoɓukutonitɔgʉ ɨɓʉ. Na ɓagɔgɔ nɨɓɔ ɓakakwananɨgʉ kavanana ko bulya ɓʉngama ɓa kʉgʉ wa lɨsyɛ. Nɨnɔ akwanana kaʉkana mʉtʉʉ mi nɨma ʉkana.» ");
INSERT INTO lik_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Kʉwa wa, ɓambanzʉ ɓadulyoku ndɨ Yeso na ɓomiki ɓɛ ubisilyi maɓɔkʉ, ʉlʉmbɨlya. Luki limoti, ɓaɓɨɓya ɓʉnyakɨlya ndɨ. ");
INSERT INTO lik_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yeso ʉɓɨkya kʉwa ndɨ ɓaɓɨɓya kakɨ ɓɛ: «Husoni ɓomiki ɓoduku kʉnʉ no mino! Makupokyonitɔgʉ, kyɛ ɓʉngama ɓa kʉgʉ wa lɨsyɛ a ko bulya ka ɓatʉ ɓi nɨɓɔ ɓa abɛ ɨɓʉ.» ");
INSERT INTO lik_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Kʉwa wa, Yeso ubisilya ndɨ ɓomiki ɓi nɨɓɔ maɓɔkʉ. Kumbuso yi, atʉkya ndɨ wa. ");
INSERT INTO lik_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Kʉwa wa, alʉkʉ ɓemoti adulyoku ndɨ Yeso, amuusa ɓɛ: «Muwonisilo, ɓʉnza tino ɓɔ nakwanana kagya, kyɛ ninisoni na ɔɓɨlɨ wa ɓɛnzɛ na ɓɛnzɛ?» ");
INSERT INTO lik_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yeso asikisya ndɨ ɓɛ: «Ko bulya ɨkɨ yɔ wo mino kemuusa kʉgʉ wa ɓʉnza? A ɓɛyɔ, mʉtʉ ɓemoti aka nɔ a wanza! Wakapa kogulya ka ɔɓɨlɨ wa ɓɛnzɛ na ɓɛnzɛ, ɓyɛgɛ mʉtʉʉ.» ");
INSERT INTO lik_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Mʉwanza nɔ amuusa kʉwa ndɨ Yeso ɓɛ: «Mʉtʉʉ tino?» Yeso asikisya ɓɛ: «Wakamwonitɔgʉ mʉmbanzʉ, wakogyonitɔ ɓɨlya, wakiɓonitɔgʉ, wakaɓukulyogonitɔgʉ mʉmbanzʉ lɨkpʉmʉka. ");
INSERT INTO lik_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Mʉɓanga abakʉ na amakʉ, wapa mamakʉ mʉɗɔngɔnɨ ɓɛyɔ wɨpago mino ɨwɛ mombukwana-dakʉ.» ");
INSERT INTO lik_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Alʉkʉ nɔ aɓɨkya ndɨ ɓɛ: «Nagyaga mʉtʉʉ mi nɨmɔ masɨ. Ɨkɨ ɓata yɔ etigolyi?» ");
INSERT INTO lik_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yeso aɓɨkya kʉwa ndɨ ɓɛ: «Wakapa kaika mʉtʉ wanza, waga, wagaba makpʉmʉka nɨmɔ wa nomu masɨ. Ɓuyi ɓi ʉgbananɨlyaga ɓatʉ ɓa yangya. Kʉwa wa, winisana ndɛkɛ na lɨngama kʉgʉ wa lɨsyɛ. Kumbuso yi doku, wɛɓyoku.» ");
INSERT INTO lik_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Nɨyɔ alʉkʉ nɔ ʉkana ɓɛyɔ, atʉkya ndɨ wa nɨ analya kumbu kyɛ a ndɨ na lɨngama lidingi. ");
INSERT INTO lik_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Kʉwa wa, Yeso ʉɓɨkya ndɨ ɓaɓɨɓya kakɨ ɓɛ: «A lɨngʉnʉ, nakamʉɓɨkya ambɛ: ‹A yapʉpʉ ka mʉtʉ wa mukumbo kogulya ka ɓʉngama ɓa kʉgʉ wa lɨsyɛ!› ");
INSERT INTO lik_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nakamʉɓɨkya ɓata ambɛ: ‹A yapʉpʉ ka ngamia kakɨtanaga ka ngala ya mʉsaɗa. Luki limoti, a ɓata yapʉpʉ kʉgbɛ mʉtʉ wa lɨngama kogulya ka ɓʉngama ko Kunzi!›» ");
INSERT INTO lik_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ngbingo yi nɨnɔ ɓaɓɨɓya ɓʉkana ndɨ mina ɓɛyɔ, ɓombombaya ndɨ kʉgbɛ. Ɓimuusa kʉwa ndɨ ɓɛ: «Wanɨ sɛ kʉwa nɔ akwanana kainisana na muhukuso?» ");
INSERT INTO lik_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yeso ʉnda ndɨ ɓizumuuu, ʉɓɨkya ɓɛ: «Luki nɨlɔ ɓambanzʉ ɓakakwananɨgʉ kagya gʉtʉgʉ iki yi aka, Kunzi agyatʉ ɨyɨ.» ");
INSERT INTO lik_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Kʉwa wa, Pɛtɛlɛ aɓɨkya ndɨ ɓɛ: «Iɓusu, tosoni ndɨ masɨ, tapʉnga kaʉɓɨɓya. Tinisana kʉwa ndɛkɛ iɓusu na ɨkɨ?» ");
INSERT INTO lik_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yeso usikisya ndɨ ɓɛ: «A lɨngʉnʉ, nakamʉɓɨkya iɓunu nɨɓɔ mɛɓɨɓya amɓɛ: ka ɔɓɨlɨ wambɨya, wa Mika-mʉmbanzʉ ika ndɛkɛ mino ka ɓuliki kakɨ ɓa ɨbɨba, iɓunu mika ndɛkɛ gɔnɨ ɓakikonono ka moliki tɛkɛɓɛ na maɓa kosombisa mababa tɛkɛɓɛ na maɓa ka Ɓezaleli. ");
INSERT INTO lik_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Mʉmbanzʉ wasɨ kasa ndɨ ɓandaɓʉ kakɨ, ʉsa ɓamamakɨ, asa abakɨ, ikanɨ amakɨ, ʉsa ɓomikakɨ ikanɨ ɓotiko kakɨ ko bulya kamɨ, inisanatʉ ndɛkɛ ɓata na masɨ nɨmɔ nganga mɨya imoti kakɨtaga. Inisana gɔnɨ na ɔɓɨlɨ wa ɓɛnzɛ na ɓɛnzɛ. ");
INSERT INTO lik_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Luki limoti, ɓatʉ ɓudingi nɨɓɔ ɓa kambwa ɓika ndɛkɛ kumbuso, na nɨɓɔ ɓudingi ɓa kumbuso ɓika kʉwa ndɛkɛ kambwa.» ");
INSERT INTO lik_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","«Takwanana kokingyasa Ɓʉngama ɓa kʉgʉ wa lɨsyɛ na mombukwono tiko nɨnɔ opupa ndɨ kunzi na ɓʉsɔɓɨ ɓiɓo. Opupa ndɨ ɓɛyɔ, kaʉkɨsa ɓagya-ligubo ɓo tiko kakɨ ya muzabibu. ");
INSERT INTO lik_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ʉkanana ndɨ na ɓagya-ligubo ɓi nɨɓɔ ɓɛ akalyaga ɓanʉ mʉmbanzʉ yɨkaka-yɨkaka ambuma ɓemoti ka lɨsyɛ. Kumbuso yi, ʉtɨka ndɨ ko tiko kakɨ. ");
INSERT INTO lik_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Nɨyɔ ɨtʉlyana saa tatʉ, opupo ɓata ndɨ kunzi. Ʉmɨna ɓatʉ ɓagɔgɔ ɓakamanana payaya aka ka pa yangba. ");
INSERT INTO lik_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ʉɓɨkya ndɨ ɓɛ: ‹Windoni gɔnɨ iɓunu kagya ligubo ko tiko kamɨ. Napá ɓanʉ mʉmbanzʉ yɨkaka-yɨkaka mʉkalya nɨmɔ okwononi.› ");
INSERT INTO lik_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Kʉwa wa, ɓaga ndɨ. Mombukwono tiko opupa ɓata ndɨ kunzi na mʉsɨkatʉ, kumbuso yi na saa tisa, anagya asɨ mʉɗɔngɔnɨ aka. ");
INSERT INTO lik_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ɓuwobi kadwɛ ɓʉgɔgɔ, opupa ɓata ndɨ kunzi. Ʉmɨna ɓata ɓatʉ ɓagɔgɔ ɓakamanana ka pa yangba wa. Umuusa ndɨ ɓɛ: ‹Ko bulya ɨkɨ yɔ molipyogi mino ɓakamanana aka ɓɛnɛ?› ");
INSERT INTO lik_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ɓasikisya ndɨ ɓɛ: ‹Kɛgʉ na mʉmbanzʉ nɨnɔ atiwonyi pa ya ligubo.› Ʉɓɨkya kʉwa ndɨ ɓɛ: ‹Windoni gɔnɨ iɓunu kagya ligubo ko tika kamɨ ya muzabibu.› ");
INSERT INTO lik_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Nɨyɔ ɓʉgɔgɔ ogwo, mombukwono tiko yi nɨyɔ aɓɨkya ndɨ kapita kakɨ ɓɛ: ‹Hʉmaka ɓagya-ligubo, wapá mʉmbanzʉ yɨkaka-yɨkaka mʉkalya kakɨ. Wapʉnga na nɨnɔ osiliku ka muliɓo, wopipilo na nɨnɔ wa mambwa.› ");
INSERT INTO lik_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ɓagya-ligubo nɨɓɔ ɓapʉnga ndɨ ligubo na ɓʉgɔgɔ, ɓodoku ndɨ. Ɓapá mʉmbanzʉ yɨkaka-yɨkaka ambuma ɓemoti. ");
INSERT INTO lik_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Nɨɓɔ ɓodoku ndɨ ka ligubo na ɓʉsɔɓɨ, ɓisisiloku ndɨ. Ɓa ndɨ kasɨma ɓɛ ɓʉpátʉ ɓuyi kakɨtaga. Luki limoti, ɓapá gɔnɨ mʉmbanzʉ yɨkaka-yɨkaka ambuma ɓemoti aka. ");
INSERT INTO lik_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Nɨyɔ ɓavago mina mʉkalya kaɓʉ, ɓapʉnga ndɨ kanzɨnzɨnya mombukwono tiko. ");
INSERT INTO lik_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ɓanaɓɨkya ɓɛ: ‹Ɓatʉ nɨɓɔ ɓosiliku ka muliɓo ɓogyi ligubo ka saa imoti aka! Ukolyi mʉɗɔngɔnɨ abɛ iɓusu nɨɓɔ tolipyogi nɨ mɔnɨ anatɨlya ka ligubo lapʉ kʉgbɛ.› ");
INSERT INTO lik_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Luki limoti, mombukwono tiko yi nɨyɔ asikisya ndɨ ɓemoti ka ɓagya-ligubo ɓi nɨɓɔ ɓɛ: ‹Yɛ wai, nakuɓiɓigʉ ɨmɨ! A ɓɛyɔ, tukononi ɓi ambɛ nika kaʉkalya na ambuma ɓemoti ka lɨsyɛ! ");
INSERT INTO lik_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Yɛkɨ a ɓɛyɔ, va mʉkalya kakʉ, watʉkya ko misa kamɨ. Ɨmɨ nɔ noboilyi kakalya mʉtʉ wa muliɓo mʉɗɔngɔnɨ abɛ ɨwɛ. ");
INSERT INTO lik_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ambɛ, nakokwononigʉ kagya na mukumbo kamɨ mʉɗɔngɔnɨ ɓɛyɔ nopo mino? Ikanɨ wa na ɨmɨ no miso mopi kyɛ na na yɨgya yanza?›» ");
INSERT INTO lik_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yeso amatɨla ɓata ndɨ ɓɛ: «A ɓɛyɔ, ɓatʉ nɨɓɔ ɓakumbuso ɓika ndɛkɛ ɓamambwa, na nɨɓɔ ɓamambwa ɓika kʉwa ndɛkɛ ɓakumbuso.» ");
INSERT INTO lik_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ngbingo yi nɨnɔ Yeso a ndɨ mina kaɗaka ka Yelusalɛma, ɨtɛ ndɨ na ɓaɓɨɓya kakɨ tɛkɛɓɛ na ɓaɓa ɓɨkɛɗɛ. Ʉɓɨkya ɓɛ: ");
INSERT INTO lik_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Hukononi! Mbɨya wanʉ, takaɗaka ka Yelusalɛma. Kʉ ɓɛyɔ, ɓasʉtatʉ Mika-mʉmbanzʉ ka maɓɔkʉ ka ɓokumu-kumu na ɓowonisilo ɓa mʉtʉʉ. Ɓaɓɨkya ɓanʉ ɓɛ ɓamwɨ. ");
INSERT INTO lik_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Kumbuso yi, ɓasʉta ka maɓɔkʉ ka ɓatʉ nɨɓɔ ɓakamibigʉ Kunzi. Ɨɓʉ, ɓatɨba ɓanʉ ɓɨkyaaa, ɓatɨna pimbo, ɓabangɨlaga ka mʉsalaba. Luki limoti, kumbusa wa masyɛ masaa, opupoku ka mbʉkʉ.» ");
INSERT INTO lik_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Kʉwa wa, muka Zɛbɛdayɔ pa imoti na ɓomikakɨ ɓakpuɗoku ndɨ Yeso. Ɨyɨ mama nɔ oɓuna ndɨ moli kambwa ka Yeso kakʉnga luki limoti. ");
INSERT INTO lik_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yeso amuusa ndɨ ɓɛ: «Wakapa ɨkɨ?» Ɨyɨ aka ɓɛ: «Ngbingo yi nɨnɔ wika ɓanʉ mino ka Ɓʉngama kakʉ, hʉɓɨkyanɔ ɓaka ikanɨ ɓomikamɨ ɓaɓa ɓi nɨɓana ɓikatʉ ɓemoti ka kumbanzɨkanɨkɔ kakʉ, wagɔgɔ ka kulekuke.» ");
INSERT INTO lik_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yeso usikisya ndɨ ɓɛ: «Makɛgʉ kaiba nɨlɔ makɛkʉnga. Makwananatʉ kamwo kɔpɔ wa yigyogyiso nɨnɔ namwo ɓanʉ?» Ɓasikisya ɓɛ: «Iyo, takwananatʉ.» ");
INSERT INTO lik_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yeso ʉɓɨkya ndɨ ɓɛ: «Makwananatʉ kamwo kɔpɔ wa yigyogyiso yi nɨnɔ. Luki limoti, ka nɨlɔ o ndɨ kalikisa mʉmbanzʉ ka kumbanzɨkanɨkɔ ikanɨ wa kulekuke kamɨ, kɛgʉ liguba kamɨ. Ɓapa nɨɓayɔ a ko bulya ka ɓatʉ nɨɓɔ Baba uɓungusilyaga ndɨ.» ");
INSERT INTO lik_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ngbingo yi nɨnɔ ɓaɓɨɓya ɓagɔgɔ tɛkɛɓɛ ɓʉkana ndɨ mina mongoni mi nɨmɔ, mambɛngɨ ʉtʉla ndɨ na yɨgya ka ɓomika Zɛbɛdayɔ. ");
INSERT INTO lik_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Kʉwa wa, Yeso ʉmaka ndɨ ɨɓʉ ɓasɨ, ʉɓɨkya ɓɛ: «Mibagatʉ ɓɛ ɓangama ɓakpʉkpʉ ɓa ɓɛvananza ɓa ɔɓɨlɨ yi nɨmʉ ɓatɨwaga ɓɛvananza kaɓʉ na mʉpamʉ. Ɓatʉ ɓakpʉkpʉ ɓʉɗɨtaga ɓatʉ ɓagɔgɔ na ɓʉngama kaɓʉ ɓɨnvɨ. ");
INSERT INTO lik_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Luki limoti, kikonitɔgʉ ɓɛyɔ luga kunu. Nɨnɔ akapa kaika mʉtʉ mudingi luga kunu, okwononi iki mʉgya-ligubo kunu. ");
INSERT INTO lik_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Mʉmbanzʉ kapa kaiko wa mambwa luga kunu, okwononi iki musunzu kunu. ");
INSERT INTO lik_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Kinili, gʉtʉgʉ Mika-mʉmbanzʉ aka kodokugʉ ndɨ kyɛ ɓiki kagugubyo. Luki limoti, odoku ndɨ kaugugubya ɓambanzʉ, kapá ɔɓɨlɨ kakɨ abɛ mʉkalya kaʉkʉlaga ɓatʉ ɓudingi ka ɓʉnyɛ.» ");
INSERT INTO lik_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ngbingo yi nɨnɔ Yeso na ɓaɓɨɓya kakɨ ɓa ndɨ mina katʉkya ka gʉɗʉ wa Yeliko, ambaza mudingi ka ɓambanzʉ a ndɨ kaʉɓɨɓya ɓingbooo. ");
INSERT INTO lik_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Na ka kpɔlɔ wo pisi, ɓatʉ ɓaɓa ɓo koloɓu ya mamɔmɔ ɓa ndɨ ɓakikaga wa. Nɨyɔ ɓʉkana ɓɛ Yeso nɔ akakɨtaga, ɓakʉgwaga ndɨ ɓɛ: «Hiii Mombukwono-dosu, Mika ngama Daudi! Tikwilyanɔ ɓaka kumbu!» ");
INSERT INTO lik_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Nɨyɔ ambaza ka ɓambanzʉ ʉkana mino ɓɛyɔ, ʉnyakɨlya ndɨ ɓɨnyaka-nyaka ɓɛ ɓadakɨ. Luki limoti, ɓapamɨkanaga ɓata ndɨ ɓɛ: «Hiii Mombukwono-dosu, Mika ngama Daudi! Tikwilyanɔ ɓaka kumbu!» ");
INSERT INTO lik_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yeso amaga ndɨ, ʉmaka, umuusa ɓɛ: «Makapa ɓɛ namʉgyɨlyɨ ɨkɨ?» ");
INSERT INTO lik_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ɨɓʉ aka ɓɛ: «Mombukwono-dosu, takapa ɓɛ miso atihukwikoni.» ");
INSERT INTO lik_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yeso ukwilya ndɨ kumbu, ʉvɨlaga miso. Wa aka wa, miso uhukwikana ndɨ. Kʉwa wa, ɓaɓyɛ ndɨ Yeso. ");
INSERT INTO lik_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ngbingo yi nɨnɔ Yeso na ɓaɓɨɓya kakɨ ɓa kʉwa ndɨ mina ɓuwobi kadwɛ ka Yelusalɛma, ɓosila ndɨ ka Bɛtɛfagɨ, misa ya Ngʉpa ya Mizeituni. Kʉwa wa, Yeso ʉtɨka ndɨ ɓaɓɨɓya ɓaɓa kambwa, ");
INSERT INTO lik_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ʉɓɨkya ndɨ ɓɛ: «Windoni ka mugi nɨmɔ a kambwa kunu ma, matakanya omoyi wa punda ɓemoti no mikakɨ ɓʉkandɨla. Hukulogoni, modoku na ɨɓʉ kʉnʉ. ");
INSERT INTO lik_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Mʉmbanzʉ kamumuuso lɨkpʉmʉka ko bulya ɓapunda ɓi nɨɓɔ, masikisya ɓɛ: ‹Mombukwono-dosu a no nzoyi yi.› Wa aka wa, mʉtʉ yi nɨnɔ amʉsɨlyatʉ.» ");
INSERT INTO lik_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Nɨlɔ igyonosa ndɨ ɓɛyɔ, kyɛ ɨtʉlyanɨ mʉnzɨna nɨmɔ ɨɓɨkya ndɨ pisi ka mugyalandʉ ɓɛ: ");
INSERT INTO lik_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«Huɓikyoni ɓatʉ ɓa Siona ɓɛ: ‹Winoni, ngama kunu akamudulyoku, mutumo na yisiso, kʉgʉ wa omoyi wa punda, na kʉgʉ wa mʉwanza wa mikya punda, mika omoyi wa punda.›» ");
INSERT INTO lik_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ɓaɓɨɓya ɓaɓa ɓi nɨɓɔ ɓaga ndɨ, ɓagya ɓɛyɔ aka yɔ Yeso ʉkpamya ndɨ mino. ");
INSERT INTO lik_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ɓodoku ndɨ na omoyi wa punda nɨnɔ no mikakɨ. Ɓumolosaga ndɨ na ɓotu, Yeso ika ndɨ kʉgʉ yi. ");
INSERT INTO lik_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ɓambanzʉ ɓudingi ka ambaza ɓa ndɨ koolosaga ɓotu kaɓʉ ko pisi. Ɓagɔgɔ ɓa ndɨ kakɔgɔ mangʉ ma masɨsɨ, ɓanolosaga ɓɛgɛyɔ. ");
INSERT INTO lik_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ɓambanzʉ nɨɓɔ ɓa ndɨ kakpakyana kambwa na kumbuso ka Yeso ɓa ndɨ kapamɨkanaga, ɓanaɓɨkya ɓɛ: «Ɨbɨba ko Mika ngama Daudi! Kunzi aɗukilyi nɨnɔ akodoku ko lino ka Mombukwono-dosu ɓʉɓʉnga! Ɨbɨba ko Kunzi kʉgʉ kʉgbɛ!» ");
INSERT INTO lik_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Nɨyɔ Yeso ingya kʉwa ndɨ mino ka Yelusalɛma, gʉɗʉ wasɨ ogulya ndɨ ka ɓukpwuku-kpwuku ɓudingi. Ɓambanzʉ ɓapʉnga ndɨ kaimuuso ɓɛ: «Wanɨ pɨyɛ mʉ?» ");
INSERT INTO lik_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ɓambanzʉ nɨɓɔ ɓa ndɨ ka ɓambaza ɓosikisya ndɨ ɓɛ: «Yeso nɔ. A mugyalandʉ ka gʉɗʉ wa Nazalɛtɨ, ka Galilaya.» ");
INSERT INTO lik_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yeso ogulya ndɨ ka Ndaɓʉ ko Kunzi. Kʉ ɓɛyɔ, ukpumya ndɨ ɓatʉ ɓasɨ nɨɓɔ ɓa ndɨ kaɨgagaɓya, na nɨɓɔ ɓa ndɨ koluwo. Ugbukumisaga ndɨ ɓamɨza ka ɓogomosyana ɓuyi. Umisya ɓokiti ka nɨɓɔ ɓa ndɨ kaʉgaba ɓonzuwo. ");
INSERT INTO lik_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ʉɓɨkya ndɨ ɓɛ: «Ikpikaga ɓɛ: ‹Ɓalɨkyaga ndɛkɛ ndaɓʉ kamɨ ɓɛ ndaɓʉ ya malʉmba.› Luki limoti, iɓunu moitisini kʉwa pa ya kɨsʉma ka ɓatʉ ɓo kuɓakʉ!» ");
INSERT INTO lik_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Kʉ ka Ndaɓʉ ko Kunzi, ɓatʉ ɓo koloɓu ɓaya mamɔmɔ na ɓatʉ ɓa mʉdɨlɨ ɓasilyoku ndɨ Yeso. Ɨyɨ, uhukusa ndɨ. ");
INSERT INTO lik_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ngbingo yi nɨnɔ Yeso agya ndɨ mina ɓɛyɔ, ɓokumu-kumu, na ɓowonisilo ɓa mʉtʉʉ ɓɨna ndɨ lɨkpʉmʉka lɨmbanga li nɨlɔ. Ɓʉkana ndɨ gɔnɨ ɓɛyɔ ɓomiki ɓa ndɨ mino kapamɨkanaga ka Ndaɓʉ ko Kunzi kʉ ɓɛ: «Ɨbɨba ko Mika ngama Daudi!» Lɨkpʉmʉka li nɨlɔ utulisa ndɨ ɓangama ɓi nɨɓɔ mambɛngɨ kʉgbɛ. ");
INSERT INTO lik_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Kʉwa wa, ɓamuusa ndɨ Yeso ɓɛ: «Watʉ kaʉkana lɨkpʉmʉka li nɨlɔ ɓomiki nɨɓana ɓakaɓɨkya?» Yeso usikisya ndɨ ɓɛ: «Iyo. Ambɛ makanotongulogigʉ mbɛyɨ ndɨ ɓɛyɔ ikpikaga mino ka Moɓiso Motu ɓɛ: ‹Pisi ka nɔkʉ ka ɓomiki ɓakɛkɛkɛ na ka nɨɓɔ ɓawɛsɛ, ɓɨmbɨlaga ɨbɨba kakʉ.› » ");
INSERT INTO lik_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Kumbuso yi, Yeso ʉsa ndɨ. Opupa ka Yelusalɛma, ɨnda ndɨ kasyɛ ka Betania. ");
INSERT INTO lik_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Na ɓʉsɔɓɨ ɓa ɓʉgala ɓi, ko ngbingo nɨnɔ Yeso a ndɨ mino kaigoku ka Yelusalɛma, ɨmʉkana ndɨ nza. ");
INSERT INTO lik_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ka kpɔlɔ wo pisi, ɨna ndɨ sɨbʉkʉsɔ simoti, akpʉɗa. Luki limoti, atakanya ndɨ asɨ mapakʉ aka nɨ kɛgʉ no bumo kʉgʉ yi. Kʉwa wa, agbanga ndɨ sɨbʉkʉsɔ si nɨsɔ ɓɛ: «Katʉkya na lɨsyɛ li nɨlɨ, wakaɓʉkʉtɨgʉ ndɛkɛ ɓata bumo kadwɛ ka muliɓo!» Wa aka wa, sɨbʉkʉsɔ si nɨsɔ okwa ndɨ. ");
INSERT INTO lik_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Nɨyɔ ɓaɓɨɓya ka Yeso ɓɨna ndɨ mina ɓɛyɔ, ɓombombaya ndɨ kʉgbɛ. Ɓamuusa kʉwa ndɨ ɓɛ: «Igyonosi pɨyɛ ɓʉnɨ sɨbʉkʉsɔ si nɨsɨ kokwo ko ngbinga ɓemoti aka ɓɛnɛ?» ");
INSERT INTO lik_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yeso usikisya ndɨ ɓɛ: «A lɨngʉnʉ, nakamʉɓɨkya ambɛ, kika nɨ ma na baya, nɨ makɛgʉ na ɓotumo, iɓunu makwanano ɓi kagya aka mʉɗɔngɔnɨ ɓɛyɔ nogyi mina ka sɨbʉkʉsɔ si nɨsɨ. Luki limoti, gʉtʉgʉ ngʉpa yi nɨyɨ, maɓɨkyatʉ ɓɨ ɓɛ: ‹Mukuko, wiɗikitoku ko liɓa lidingi.› Ko ngbingo ɓemoti aka igyonoso ɓi ɓɛyɔ. ");
INSERT INTO lik_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Kika nɨ ma na baya, yasɨ nɨyɔ makʉnga, Kunzi amʉpátʉ.» ");
INSERT INTO lik_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yeso ingya ndɨ ɓata ka Ndaɓʉ ko Kunzi. Ngbingo yi nɨnɔ a ndɨ mino kaɓɨkyaga Mongoni Manza, ɓokumu-kumu na ɓambɔkʉ-mbɔkʉ ka Ɓayuda ɓodoku ndɨ kamuusa ɓɛ: «Masɨ nɨmana wakagya ma, wakagya no ngu tino? Wanɨ nɔ ʉpá ndɨ ngu yi nɨyɔ?» ");
INSERT INTO lik_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yeso usikisya ndɨ ɓɛ: «Na ɨmɨ, nakamumuusa lɨkpʉmʉka limoti aka. Makesikisyo, namʉtʉmbʉlyaga kʉwa ɓɛ nakagya no ngu ka wanɨ. ");
INSERT INTO lik_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yɛkɨ a ɓɛyɔ! Iɓatiso ka Yuani apʉnya yanɨ? Kʉgʉ wa lɨsyɛ ikanɨ ka ɓambanzʉ?» Kʉwa wa, ɓapʉnga ndɨ kaɨnzɨnzɨnya luga kaɓʉ, ɓanaɓɨkya ɓɛ: «Takosikisya ɓɛ apʉnya kʉgʉ wa lɨsyɛ, atimuusatʉ ɓɛ: ‹Yɛkɨ a ɓɛyɔ! Ko bulya ɨkɨ yɔ makaɓɨnɨkyanagʉ ndɨ lɨkpʉmʉka kakɨ?› ");
INSERT INTO lik_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Takosikisya amɓɛ ka ɓambanzʉ, taɓangatʉ ɓi ambaza ka ɓambanzʉ ɓi nɨɓa. A ɓɛyɔ, ɨɓʉ ɓasɨ ɓibagatʉ ndɨ ɓɛ Yuani a ndɨ mugyalandʉ.» ");
INSERT INTO lik_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Kʉwa wa, ɓasikisya ndɨ Yeso ɓɛ: «Takibigʉ.» Ɨyɨ aka gɔnɨ na ɨɓʉ ɓɛ: «Gʉtʉgʉ ɨmɨ aka, nakamʉtʉmbʉlyɨgʉ gɔnɨ ikanɨ nagyaga makpʉmʉka mi nɨmɔ no ngu ka wanɨ.» ");
INSERT INTO lik_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yeso aɓɨkya ndɨ ɓata ɓɛ: «Iɓunu makaɨna ɓʉnɨ ko bulya lizuni li nɨlɨ? A ndɨ na alʉkʉ ɓemoti nɨnɔ a ndɨ na ɓomiki ɓaɓa. Alʉkʉ yi nɨnɔ aɓɨkya ndɨ mikakɨ wa mambwa ɓɛ: ‹Mikamɨ! Na lɨsyɛ li nɨlɨ waga kagya ligubo ko tika ya muzabibu.› ");
INSERT INTO lik_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ɨyɨ aka ɓɛ: ‹Nakopagʉ!› Luki limoti, kumbuso yi oyikosa ndɨ tamanaga kakɨ, ɨnda ndɨ kagya ligubo. ");
INSERT INTO lik_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Alʉkʉ nɔ aɓɨkya ndɨ mikakɨ wagɔgɔ mʉɗɔngɔnɨ ɓɛyɔ aɓɨkya ndɨ mino nɨnɔ wa mambwa. Ɨyɨ, asikisya ndɨ ɓɛ: ‹Iyo ba, nagatʉ!› Luki limoti, nɨ kogagʉ. ");
INSERT INTO lik_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Yɛkɨ a ɓɛyɔ! Luga ka ɓomiki ɓaɓa ɓi nɨɓɔ, wanɨ nɔ agya ndɨ mʉɗɔngɔnɨ ɓɛyɔ abaɓʉ a ndɨ mino kapa?» Ɓasikisya ndɨ ɓɛ: «Nɨnɔ wa mambwa.» Yeso ʉɓɨkya ndɨ ɓɛ: «A lɨngʉnʉ, nakamʉɓɨkya ambɛ, ɓandɔmbɛ ɓa manzanza na ɓaɗanda ɓɔ ɓogulyo ndɛkɛ kambwa kunu ka Ɓʉngama ko Kunzi. ");
INSERT INTO lik_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","A ɓɛyɔ, Yuani odoku ndɨ ku kunu kamʉwanya pisi ya ɓungbingbili, iɓunu makabaɨlyagʉ ndɨ. Luki limoti, ɓandɔmbɛ na ɓaɗanda, ɓabaɨlyatʉ ndɨ. Gʉtʉgʉ ko ngbingo yi nɨnɔ mɨna ndɨ mino makpʉmʉka mi nɨmɔ, makopupagʉ ndɨ ka ɓʉnyɛ kunu ɓɛ mabaɨlyɨ.» ");
INSERT INTO lik_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yeso ʉɓɨkya ndɨ ɓata ɓɛ: «Hukononi lizuni lagɔgɔ. A ndɨ na mʉtʉ ɓemoti nɨnɔ akʉna ndɨ tiko ya muzabibu, okungula ndɨ, akpɔ ndɨ lɨɓyɛ lɨʉta bumo yi, opika ndɨ na mʉnala manda ko bulya ka ɓoɓuɓulyo. Kumbuso yi, ʉkanana ndɨ na ɓagya-ligubo koɓuulyaga tiko yi nɨyɔ, akpakyana ndɨ. ");
INSERT INTO lik_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Nɨyɔ ngbinga mubuulya masɔlɔ ɨtʉlyana ndɨ, ʉtɨka ɓagya-ligubo kakɨ kʉ ka ɓagya-ligubo ɓi nɨɓɔ ɓɛ ɓapíku kʉwa masɔlɔ mi ma kakɨ. ");
INSERT INTO lik_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Luki limoti, ɓadɨma-ɓotiko ɓi nɨɓɔ ɓugwi ndɨ ɓagya-ligubo kakɨ. Ɓalya ndɨ ɓemoti na bʉma ɓɨsʉsʉsʉ. Ɓamwɔ wagɔgɔ, ɓayipaga ndɨ wagɔgɔ ɓata na matamʉ kadwɛ kʉ kwa kʉ ɓadikisa ndɨ mino. ");
INSERT INTO lik_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Kʉwa wa, ʉtɨka ɓata ndɨ ɓagya-ligubo ɓagɔgɔ. Ɓagya-ligubo ɓi nɨɓɔ ɓa ndɨ ɓudingi kaʉkɨtaga nɨɓɔ a ndɨ nɨ utikini kambwa. Luki limoti, ɓadɨma-ɓotiko ɓʉgyagya ndɨ ɓagya-ligubo ɓi nɨɓɔ mʉɗɔngɔnɨ ɓɛyɔ ɓʉgya ndɨ mino nɨɓɔ ɓa mambwa. ");
INSERT INTO lik_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ka muliɓo, atɨka ndɨ mikakɨ ɓɨkpɛ, anasɨma ɓɛ: ‹ɓaɓangatʉ.› ");
INSERT INTO lik_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Luki limoti, nɨyɔ ɓagya-ligubo ɓo tiko yi nɨyɔ ɓamɨna kodoku, ɓaɓɨkyana luga kaɓʉ ɓɛ: ‹Alʉkʉ yi nɨnɔ alya ndɛkɛ lisima nɨmʉ! Donuku, tamwini, iɓusu kʉwa ɓɔ totigoli na lisimo kakɨ.› ");
INSERT INTO lik_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Kʉwa wa, ɓagwi ndɨ, ɓambimba kunzi wo tiko, ɓamwɔ kʉ ɓɛyɔ.» ");
INSERT INTO lik_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Kumbuso yi, Yeso umuusa ndɨ ɓɛ: «Ngbingo yi nɨnɔ mombukwono tiko igoku ndɛkɛ mino, ʉgya ɓagya-ligubo ɓi nɨɓɔ ɓʉ?» ");
INSERT INTO lik_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ɓasikisya ndɨ ɓɛ: «Mombukwono tiko ulumwisaga nɨ kɛgʉ no nzonzi, ʉpá kʉwa ɓagya-ligubo ɓagɔgɔ tiko yi nɨyɔ nɨɓɔ ɓiko ɓanapága masɔlɔ ko ngbingo nɨnɔ okwononi.» ");
INSERT INTO lik_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Kʉwa wa, Yeso ʉɓɨkya ndɨ ɓata ɓɛ: «Makanotongulogigʉ mbɛyɨ ndɨ ka Moɓiso Motu kʉ ikpikaga mino ɓɛ: ‹Lɨtalʉ nɨlɔ ɓopipiko ɓakya ndɨ, ilu lɔ ɨɨta kʉwa la angba. Mombukwono-dosu nɔ agya ndɨ ɓɛyɔ. Ku kusu, a lɨkpʉmʉka lɨmbanga.› ");
INSERT INTO lik_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Yɛkɨ a ɓɛyɔ, nakamʉɓɨkya ɓata ambɛ: ɓamʉkʉpyatʉ iɓunu ɓʉngama ko Kunzi, ɓʉpá ɓatʉ nɨɓɔ ɓika kaɓʉkʉta bumo yi.  ");
INSERT INTO lik_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Mʉtʉ wasɨ nɨnɔ ogwa kʉgʉ wa lɨtalʉ li nɨlɔ oɓunikaga ndɛkɛ ɓɨsɛkɛ-sɛkɛ, na mʉtʉ yi nɨnɔ lɨtalʉ li nɨlɔ agwilya ndɛkɛ, akpʉtɨkana ndɛkɛ ɓɨsɛkɛ-sɛkɛ.» ");
INSERT INTO lik_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Nɨyɔ ɓokumu-kumu na Ɓafalisayɔ ɓʉkana bɛyɔ, ɓiba ndɨ ɓɛ a ndɨ kaɓɨkya ko bulya kaɓʉ. ");
INSERT INTO lik_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ɓakɨsa kʉwa ndɨ pisi kagwi, luki limoti, ɓaɓanga ɓambaza ka ɓambanzʉ kyɛ ɓambaza ɓi nɨɓɔ ɓibagatʉ ndɨ ɓɛ Yeso a mugyalandʉ aka. ");
INSERT INTO lik_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yeso idukulaga ndɨ kaʉnzɨnɨlya ɓata ɓambaza ka ɓambanzʉ ɓi nɨɓɔ na mozuni, ʉɓɨkya ndɨ ɓɛ: ");
INSERT INTO lik_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Ɓʉngama ɓa kʉgʉ wa lɨsyɛ a mʉɗɔngɔnɨ abɛ ngama ɓemoti nɨnɔ alyisisya ndɨ mikakɨ mʉlʉkʉ yi dumo mudingi mʉvanana. ");
INSERT INTO lik_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ngama yi nɨnɔ ʉtɨka ndɨ ɓagya-ligubo kakɨ kaumokoku ɓatʉ nɨɓɔ ɓutikisya ndɨ ko dumo. Luki limoti, ɓatʉ ɓi nɨɓɔ ɓakya ndɨ kodoku. ");
INSERT INTO lik_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Kʉwa wa, ʉtɨka ndɨ ɓata ɓagya-ligubo ɓagɔgɔ, ʉɓɨkya ɓɛ: ‹Windoni kaʉɓɨkya ɓatʉ nɨɓɔ nutikisyi ɓi ɓɛ: Mbɨya wanʉ, malɨlɨ a kʉwa muɓyo! Numwisisini ɓi ɓangɔmbɛ na ɓanyama kamɨ ɓagɔgɔ ɓanvʉɗʉ-nvʉɗʉ. Masɨ a makɨtʉlya, doniku ko dumo wo vononi!› ");
INSERT INTO lik_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Luki limoti, yalɨkya yi nɨyɔ kudwisagʉ ndɨ pɔ gʉtʉgʉ lɨmbɛngɨ aka. Ɓemoti ɨmagalya ndɨ ɨyɨ ko tiko kakɨ na wagɔgɔ ɨnda ndɨ kagaba makpʉmʉka kakɨ. ");
INSERT INTO lik_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ɓatʉ ɓagɔgɔ ɓugwi ndɨ ɓagya-ligubo ɓi nɨɓɔ, ɓʉlya ndɨ ɓɨsʉsʉsʉ, ɓʉmwɔgɔ. ");
INSERT INTO lik_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Lɨmbɛngɨ akandɨkanaga ndɨ ngama yi nɨnɔ ɓɨsʉlʉ-sʉlʉ. Ʉtɨka kʉwa ndɨ ɓasʉda kakɨ kaulumwisogo ɓatʉ ɓanyɛ ɓi nɨɓɔ ɓʉmwɔgɔ ndɨ ɓagya-ligubo kakɨ na kabʉsya gʉɗʉ yi nɨnɔ. ");
INSERT INTO lik_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Kumbuso yi, ʉɓɨkya ndɨ ɓagya-ligubo kakɨ ɓɛ: ‹Malɨlɨ mo dumo oɓyini ɓi. Luki limoti, ɓatʉ nɨɓɔ nutikisyi ɓi ɓakokwononigʉ kodoku. ");
INSERT INTO lik_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Yɛkɨ a ɓɛyɔ, syoni mʉ ma sɛngɨ. Huɓikyoni ɓatʉ ɓasɨ nɨɓɔ mabangana na ɨɓʉ ɓɛ ɓoduku ko dumo wo vononi.› ");
INSERT INTO lik_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ɓagya-ligubo ɓi nɨɓɔ ɓosya ndɨ pisi. Ɓʉmʉmʉla ɓatʉ ɓasɨ nɨɓɔ ɓa ndɨ kabangana na ɨɓʉ iki ɓatʉ ɓanyɛ ikanɨ ɓanza. Ɓodoku kʉwa ndɨ na ɨɓʉ, ndaɓʉ yo dumo otuma ndɨ ɓɨɗɛ. ");
INSERT INTO lik_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Nɨyɔ ngama yi nɨnɔ ogulya ndɨ ka ndaɓʉ kyɛ ʉmɨnɨ ɓobiko, amɨna ndɨ mʉtʉ ɓemoti nɨnɔ kimokisyagʉ ndɨ ɓotu ɓayo dumo. ");
INSERT INTO lik_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Amuusa ndɨ ɓɛ: ‹Yɛ wai! A ɓʉnɨ wingyiku mino kʉnʉ, nɨ wakimokisyigʉ ɓotu ɓayo dumo?› Luki limoti, alʉkʉ nɔ adaka ndɨ ɨyɨ ɓiwo. ");
INSERT INTO lik_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Kʉwa wa, ngama yi nɨnɔ ʉɓɨkya ndɨ ɓagya-ligubo kakɨ ɓɛ: ‹Mukondoni alʉkʉ yi nɨmʉ magʉ na maɓɔkʉ, mambimba kunzi ko biti! Kʉ ɓɛyɔ, ika ndɛkɛ kaigomisogo na kaɨlya manzʉ ɓɨkyalʉ-kyalʉ.›» ");
INSERT INTO lik_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Kumbuso yi, Yeso omosisyoku ɓɛ: «Ɓatʉ nɨɓɔ ɓʉmakaga ɓa ɓakpʉ, luki limoti nɨɓɔ ɓʉpʉnaga ɓa ɓakɛɗɛ.» ");
INSERT INTO lik_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ɓafalisayɔ ɓaga ndɨ kagyɨlya Yeso dikiɗi, ɓalɨka ndɨ ɓɛ igwinoni pisi ka mʉnzɨna kakɨ. ");
INSERT INTO lik_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Kʉwa wa, ɓatikilyoku ndɨ ɓaɓɨɓya ɓemoti-ɓemoti kaɓʉ pa imoti na ɓatʉ ɓa liɗu ka Ɛlɔdɨ. Ɓatʉ ɓi nɨɓɔ ɓamuusa ndɨ Yeso ɓɛ: «Muwonisilo! Takaiba ɓɛ wa mʉtʉ walɨngʉnʉ, wowonisilogo na ɓungbingbili ɓɛyɔ Kunzi apago mino ɓɛ ɔɓɨlɨ kusu iki. Wakaɓangagɨgʉ mʉmbanzʉ gʉtʉgʉ ɓemoti aka, kyɛ wakʉndagɨgʉ gɔnɨ ɓambanzʉ kaɓyɛnɛnɛ na ɨbɨba kaɓʉ. ");
INSERT INTO lik_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Tɨɓɨkya nɛkɨ mʉtamanagɨ kakʉ: Ambɛ, takwananatʉ kakalya ikanɨ takokolyonitɔgʉ manzanza ka Ngama Kaizalɨ?» ");
INSERT INTO lik_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Luki limoti, Yeso iba ndɨ tamanaga kaɓʉ yanyɛ. Usikisya ɓɛ: «Ɓatʉ ɓa kʉɓɔɓɔkʉ! Ko bulya ɨkɨ yɔ mo mina kakɨsa kɛɓɔ? ");
INSERT INTO lik_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Iwonyoni ɓuyi nɨɓɔ makalyaga na iɓu manzanza.» Ɓapá kʉwa ndɨ ambuma ɓemoti. ");
INSERT INTO lik_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Yeso umuusa ndɨ ɓɛ: «Mulundu no lino li nɨlɨ, a la ka wanɨ?» ");
INSERT INTO lik_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ɓasikisya ndɨ ɓɛ: «Ma ka Ngama Kaizalɨ.» Yeso aka ndɨ na ɨɓʉ ɓɛ: «A ɓɛyɔ, mupóni nɛkɨ Kaizalɨ makpʉmʉka nɨmɔ okwononi na ɨyɨ. Mapá Kunzi nɨmɔ ko Kunzi.» ");
INSERT INTO lik_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Nɨyɔ ɓʉkana sikisyo yi nɨyɔ, ɓombombaya ndɨ kʉgbɛ, ɓasa ndɨ wa, ɓaga. ");
INSERT INTO lik_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ka lɨsyɛ li nɨlɔ aka lɔ, Ɓasadukayɔ ɓemoti-ɓemoti ɓakpuɗoku ndɨ Yeso. (Ɨɓʉ ɓaɓɨkyaga ɓɛ ɓamanda kopupogigʉ ka ɓambʉkʉ.) Ɓamuusa kʉwa ndɨ ɓɛ: ");
INSERT INTO lik_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«Muwonisilo! Musa aɓɨkya ndɨ ɓɛ: ‹Kika nɨ mʉmbanzʉ okwini, asa mukakɨ nɨ koɓukuti na ɨyɨ, akwanana ɓɛ mamakɨ amɨgɨlyɨ woko yi nɨnɔ, kyɛ aɓʉkʉtɨlyagɨ yaa-dakɨ nɨnɔ okwa ndɨ ɓomiki.› ");
INSERT INTO lik_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Wɨna sɛ, luga kusu a ndɨ na ɓomiki ɓalʉkʉ ɓi maɗɨya na ɨka nɨɓɔ ɓopupa ndɨ mʉma mimoti. Pʉta ava ndɨ muko, luki limoti, okwa ndɨ nɨ koɓukutigʉ na ɨyɨ. Asɨlya kʉwa ndɨ syononoga kakɨ woko yi nɨnɔ. ");
INSERT INTO lik_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Syononoga kakɨ yi nɨnɔ okwa ndɨ gɔnɨ. Igyonosa ndɨ mʉɗɔngɔnɨ ɓɛgɛyɔ ka mamaɓʉ yi nɨnɔ wa masaa, kadwɛ ka nɨnɔ wa maɗɨya na ɨka. ");
INSERT INTO lik_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Kumbuso ɨɓʉ ɓasɨ kolumwogo, muko yi nɨnɔ ʉɓyɛ kʉwa ndɨ gɔnɨ ɨyɨ. ");
INSERT INTO lik_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ka lɨsyɛ lipupa ka ɓambʉkʉ, muko yi nɨnɔ ika ndɛkɛ muka wanɨ luga kaɓʉ? A ɓɛyɔ, ɨɓʉ ɓasɨ maɗɨya na ɨka ɓavatʉ ndɨ!» ");
INSERT INTO lik_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yeso usikisya ndɨ ɓɛ: «Ma ɓuɓungogo, kyɛ makɛgʉ kotombisyo Moɓiso Motu ikanɨ ngu ko Kunzi. ");
INSERT INTO lik_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","A ɓɛyɔ, ngbingo yi nɨnɔ ɓamanda opupa ndɛkɛ mino ka ɓambʉkʉ, ɓalʉkʉ ɓakʉvɨgʉ ndɛkɛ ɓata ɓoko ikanɨ ɓoko kavyɛgɛ. Luki limoti, ɓika ndɛkɛ mʉɗɔngɔnɨ abɛ ɓamalaika ɓa kʉgʉ wa lɨsyɛ! ");
INSERT INTO lik_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ko bulyo yipupa ka ɓambʉkʉ, makanotongulogigʉ mbɛyɨ ɓɛyɔ Kunzi aɓɨkya ndɨ mino ɓɛ: ");
INSERT INTO lik_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‹Ɨmɨ, na Kunzi ka Abalahamʉ, ka Isaka na ka Yakɔbɔ.› Yeso omotiloku ndɨ ɓɛ, Kunzi kɛgʉ Kunzi ka ɓamanda, luki limoti, a Kunzi ka ɓatʉ nɨɓɔ ɓa na ɔɓɨlɨ!» ");
INSERT INTO lik_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ɓambaza ka ɓambanzʉ nɨɓɔ ɓʉkana ndɨ mʉtɨwɨ mi nɨmɔ, ɓombombaya ndɨ kʉgbɛ. ");
INSERT INTO lik_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ngbingo yi nɨnɔ Ɓafalisayɔ ɓʉkana ndɨ mina ɓɛ Yeso udokisini Ɓasadukayɔ, Ɓafalisayɔ ɓi nɨɓɔ ɓamʉmʉkana kʉwa ndɨ pa imoti. ");
INSERT INTO lik_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ɓemoti kaɓʉ nɨnɔ ibaga ndɨ mʉtʉʉ kʉgbɛ, akpuɗoku ndɨ Yeso kakɨsa kaɓɔɓɔ, amuusa ɓɛ: ");
INSERT INTO lik_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Muwonisilo! Kʉsɔ wa mʉtʉʉ masɨ, mʉtʉʉ tina mɔ okitogi magɔgɔ na ɨzangɨya kʉgbɛ?» ");
INSERT INTO lik_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yeso asikisya ndɨ ɓɛ: «‹Mʉpa Mombukwana-dakʉ Kunzi na lɨmbɛngɨ kakʉ lasɨ, na mʉtamanagɨ kakʉ masɨ na yimibo kakʉ yasɨ.› ");
INSERT INTO lik_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Mʉtʉʉ ma ɨzangɨya kʉgbɛ na ma mambwa nɨmɔ. ");
INSERT INTO lik_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Mʉtʉʉ ma mɨɓa a mʉɗɔngɔnɨ: ‹Mʉpa mamakʉ mʉɗɔngɔnɨ ɓɛyɔ wɨpago mino ɨwɛ mombukwana-dakʉ yi.› ");
INSERT INTO lik_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Mʉtʉʉ mɨɓa mi nɨmɔ a madʉlʉ ma masɨ nɨmɔ ikpikaga ka Mʉtʉʉ ka Musa na ka ɓakɨtaɓʉ ka ɓogyalandʉ.» ");
INSERT INTO lik_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ngbingo yi nɨnɔ Ɓafalisayɔ ɓa ndɨ mina ɓʉmʉmʉkana, Yeso umuusa ndɨ ɓɛ: ");
INSERT INTO lik_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«Mʉtamanagɨ kunu a ɓʉnɨ kʉgʉ ka Kilisito? Opupa ndɨ ka lɨvananza ka wanɨ?» Ɓasikisya ndɨ ɓɛ: «A miko-mika ngama Daudi.» ");
INSERT INTO lik_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yeso ʉɓɨkya ndɨ ɓɛ: «Yɛkɨ a ɓɛyɔ, pisi ko ngu ya Lɨmbɛngɨ-Lotu, Daudi akwanana ndɨ lɨkɨ kamaka Kilisito ɓɛ Mombukwono-dosu? A ɓɛyɔ, Daudi aɓɨkya ndɨ ɓɛ: ");
INSERT INTO lik_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‹Mombukwono-dosu aɓɨkya ndɨ Mombukwana-damɨ ɓɛ: Da wiki ka kumbanzɨkanɨkɔ kamɨ, kadwɛ kʉ kwa kʉ nubiso mino ɓomuyoniso kakʉ kusili kakʉ.› ");
INSERT INTO lik_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Kika nɛkɨ nɨ Daudi akamaka Kilisito ɓɛ Mombukwono-dosu, igyonosa kʉwa lɨkɨ ɓɛ iki ɓata miko-mikakɨ?» ");
INSERT INTO lik_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Kɛgʉ na mʉmbanzʉ gʉtʉgʉ ɓemoti aka nɨnɔ akwanana ndɨ kasikisya Yeso lɨkpʉmʉka. Katʉkya ka lɨsyɛ li nɨlɔ, kɛgʉ na mʉtʉ nɨnɔ ɨkpʉnda ndɨ ɓata ɓɛ amuusogi makpʉmʉka. ");
INSERT INTO lik_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Yeso ʉɓɨkya kʉwa ndɨ ɓambaza ka ɓambanzʉ na ɓaɓɨɓya kakɨ ɓɛ: ");
INSERT INTO lik_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«Ligubo ka ɓowonisilo ɓa mʉtʉʉ na Ɓafalisayɔ nɨ kaʉtʉmbʉlyaga ɓambanzʉ Mʉtʉʉ ka Musa. ");
INSERT INTO lik_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Yɛkɨ a ɓɛyɔ, humukononi, managya masɨ nɨmɔ ɓika kamʉtʉmbʉlyaga. Luki limoti, makoɓyenitɔgʉ yɨgya kaɓʉ. A ɓɛyɔ, mʉtʉʉ nɨmɔ ɓamʉpága, kɛgʉ imu mɔ ɓagyaga. ");
INSERT INTO lik_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ɓʉkandɨlyaga ɓambanzʉ mokumbogi mutititi, yapʉpʉ kabɨnɨka, ɓubinikisa ka mambɨga. Luki limoti, ɨɓʉ ɓamombukwana-daɓʉ ɓi ɓakavɨlɨgʉ pɔ gʉtʉgʉ na kpɛngbɛ aka kaubinikiso. ");
INSERT INTO lik_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Makpʉmʉka masɨ nɨmɔ ɓakagya, ikaga ko bulya kaiwonisa aka kambwa ka ɓambanzʉ. Ɓɨkpɨkɨlaga ɓapanga ɓaya ɓotu ka tʉndʉkʉtɔ ikanɨ ka makamba. Kʉgʉ yi, ɓokpikaga ndɨ mina gɛlɛ-gɛlɛ yimoti-yimoti ya Mongoni ko Kunzi. Ɓopundisaga ndɨ gɔnɨ ɓamʉ ɓaya ɓalɔpɔ kaɓʉ ɓayɨndanda na malɛndɛ. ");
INSERT INTO lik_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ko dumo, ɓapaga kaikonono ka ɓapa ɓaya ɨbɨba. Ka ɓandaɓʉ ɓaya malʉmba kaɓʉ, ɓikononogo ka moliki ma kambwa. ");
INSERT INTO lik_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ɨɓʉ ɓapaga kʉgbɛ ɓɛ ɓiki kaumuuso na ɨbɨba ka ɓapa ɓaya musilyoni, ɓanʉmaka ɓɛ: ‹Muwonisilo!›. ");
INSERT INTO lik_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Luki limoti, iɓunu makoboilyonitɔgʉ lino la ‹Muwonisilo!›. A ɓɛyɔ, Muwonisilo kunu a ɓemoti aka. Na iɓunu ɓasɨ ma luki-limoti. ");
INSERT INTO lik_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Makamokogonitɔgʉ mʉmbanzʉ gʉtʉgʉ ɓemoti aka ka ɔɓɨlɨ ɓɛ ‹Baba!›. A ɓɛyɔ, Obonu a ɓemoti aka nɨnɔ kʉgʉ wa lɨsyɛ. ");
INSERT INTO lik_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Makoboilyonitɔgʉ ɓɛ ɓamʉmakagɨ ɓɛ ‹Ngama!›. A ɓɛyɔ, Ngama kunu a ɓemoti aka nɨ Kilisito. ");
INSERT INTO lik_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Mʉmbanzʉ wa ɨɓɨba kʉgbɛ luga kunu, akwanana ɓɛ iki mʉgya-ligubo kunu. ");
INSERT INTO lik_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Mʉtʉ wasɨ nɨnɔ ɨbɨnɨkaga, Kunzi asisagatʉ. Luki limoti, nɨnɔ isisogo, Kunzi abɨnɨkagatʉ. ");
INSERT INTO lik_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Kumbu kunu ɓowonisilo ɓa mʉtʉʉ na Ɓafalisayɔ! Ma ɓatʉ ɓa kʉɓɔɓɔkʉ! Makaʉdʉlyaga ɓambanzʉ pisi yigulyo ka ɓʉngama ɓa kʉgʉ wa lɨsyɛ. Iɓunu ɓamombukwono-donu ɓi makɛgʉ kogulya kʉ ɓɛgɛyɔ na manʉkpɨngba gɔnɨ ɓatʉ nɨɓɔ ɓakapa ɓɛ ɓogulyi.  ");
INSERT INTO lik_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Kumbu kunu, ɓowonisilo ɓa mʉtʉʉ na Ɓafalisayɔ! Ma ɓatʉ ɓa kʉɓɔɓɔkʉ! Mʉkʉpyaga ɓowoko mukumba kaɓʉ masɨ, magyaga malʉmba mandandanda ka yiwoniso kambwa ka ɓambanzʉ. Kinili, ɓamusombisa ndɛkɛ yapʉ kʉgbɛ. ");
INSERT INTO lik_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Kumbu kunu, ɓowonisilo ɓa mʉtʉʉ na Ɓafalisayɔ! Ma ɓatʉ ɓa kʉɓɔɓɔkʉ! Molingyogo giyo kʉgbɛ, manakpakyana ko moɓo mudingi-dingi, kakɨsa pisi tino yɔ makwanano mino kayikoso ɔɓɨlɨ ka mʉtʉ gʉtʉgʉ ɓemoti aka ɓɛ ɨɨtɨ mʉɓɨɓya kunu. Kamʉbaɨlya, maɗikitisa kʉwa ko ɓuku ɓa ɓɛnzɛ na ɓɛnzɛ nganga yɨɓa kamʉkɨtaga iɓunu! ");
INSERT INTO lik_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Kumbu kunu, iɓunu ɓatʉ ɓokoloɓu ɓaya mamɔmɔ nɨɓɔ mukpokyonisogo ɓodonu! Maɓɨkyaga ɓɛ mʉmbanzʉ kakɔ silika ko lino la Ndaɓʉ ko Kunzi, nɨyɔ kagyɨgʉ lɨkpʉmʉka. Luki limoti, kika nɨ akuni ko lino la ɔlɔ nɨnɔ ikaga ka Ndaɓʉ ko Kunzi, okwononi ɓɛ agyɨ nɨlɔ aku mina silika. ");
INSERT INTO lik_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ma ɓongingi na ɓatʉ ɓa koloɓu ya mamɔmɔ! Ɨkɨ yɔ a na ɨzangɨya kʉgbɛ kakɨtaga? Ɔlɔ ikanɨ Ndaɓʉ ko Kunzi nɨyɔ aɓuɓisaga ɔlɔ yi nɨnɔ ɓitu? ");
INSERT INTO lik_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Maɓɨkyagatʉ gɔnɨ ɓɛ: ‹Mʉmbanzʉ kakɔ silika ko lino la gbɔgbɔ nɨnɔ ɓapágo mino apɛpɛ, nɨyɔ kagyɨgʉ lɨkpʉmʉka. Luki limoti, kika nɨ akuni ko lino la apɛpɛ nɨnɔ a kʉgʉ wa gbɔgbɔ, okwononi ɓɛ agyɨ nɨlɔ aku mino silika.› ");
INSERT INTO lik_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ɓatʉ ɓa koloɓu ya mamɔmɔ! Ɨkɨ yɔ a na ɨzangɨya kʉgbɛ kakɨtaga? Apɛpɛ ikanɨ gbɔgbɔ yi nɨnɔ aɓuɓisaga apɛpɛ ɓitu? ");
INSERT INTO lik_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Yɛkɨ a ɓɛyɔ, mʉtʉ yi nɨnɔ akɔgɔ silika ko lino la gbɔgbɔ nɨnɔ ɓapágo mina apɛpɛ, akakɔ ko lino li nɨlɔ na ko lino la masɨ nɨmɔ a kʉgʉ yi. ");
INSERT INTO lik_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Na gɔnɨ, mʉtʉ yi nɨnɔ akɔgɔ silika ko lina la Ndaɓʉ ko Kunzi, akakɔ ko lino li nɨlɔ na ko lino ko Kunzi nɨnɔ ikaga kʉsɔ yi. ");
INSERT INTO lik_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Na mʉmbanzʉ yi nɨnɔ akɔgɔ silika ko lino la kʉgʉ wa lɨsyɛ, akakɔ ko lino lo kiti wa ɓʉngama ko Kunzi na ko Kunzi nɨnɔ ikaga kʉgʉ yi. ");
INSERT INTO lik_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Kumbu kunu iɓunu ɓowonisilo ɓa mʉtʉʉ na Ɓafalisayɔ! Ma ɓatʉ ɓa kʉɓɔɓɔkʉ! A ɓɛyɔ, mapága Kunzi zaka wa makpʉmʉka masɨ. Luki limoti, mɨnaga payaya makpʉmʉka mi nɨmɔ a na ɨzangɨya kʉgbɛ ka Mʉtʉʉ mʉɗɔngɔnɨ abɛ: kaika ngbingbili, kaika no kumbu na kaika mʉtʉ walɨngʉnʉ. Makwanano ɓi kagya nɨmɔ nɨ makinigʉ magɔgɔ payaya. ");
INSERT INTO lik_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Iɓunu ɓatʉ ɓi nɨɓɔ ɓukpokyonisaga ɓatʉ ɓa koloɓu ya mamɔmɔ! Mʉtʉmbaga ɓoɓingi ɓakɛkɛkɛ ko liɓo limwo, luki limoti, mamyo nyama mudingi abɛ ngamia! ");
INSERT INTO lik_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Kumbu kunu, ɓowonisilo ɓa mʉtʉʉ na Ɓafalisayɔ! Ma ɓatʉ ɓa kʉɓɔɓɔkʉ! Masʉkʉsaga kɔpɔ na sanɨ kunzi yi aka. Luki limoti, kʉsɔ yi ika mutumo na makpʉmʉka mo kuɓakʉ na tamanaga yanyɛ. ");
INSERT INTO lik_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Mufalisayɔ! Wa mʉtʉ wo koloɓu ya mamɔmɔ! Sʉkʉsa mbɛyɨ kɔpɔ kʉsɔ yi, kʉwa wa kunzi yi ɨsʉkʉsatʉ gɔnɨ ɓɨngɔ! ");
INSERT INTO lik_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Kumbu kunu, ɓowonisilo ɓa mʉtʉʉ na Ɓafalisayɔ! Ma ɓatʉ ɓa kʉɓɔɓɔkʉ! Ma mʉɗɔngɔnɨ abɛ ɓambʉkʉ nɨɓayɔ ɓogboɗyaga na mʉkpʉndʉ ɓitu, aninisana ɓayanza kunzi yi. Luki limoti nɨ a ɓayitumo no kuwo ya ɓamanda na pɔpɔtʉ dididi kʉsɔ yi ɓɨɗɛ. ");
INSERT INTO lik_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Iɓunu ma mʉɗɔngɔnɨ ɓɛgɛyɔ, ko misa ka ɓambanzʉ, minisanaga abɛ makika ɓatʉ ɓongbingbili, luki limoti, ma ɓutumo kʉsɔ kunu na kʉɓɔɓɔkʉ na yɨgya yanyɛ. ");
INSERT INTO lik_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Kumbu kunu, ɓowonisilo ɓa mʉtʉʉ na Ɓafalisayɔ! Ma ɓatʉ ɓa kʉɓɔɓɔkʉ! Makopika ɓambʉkʉ ka ɓogyalandʉ ko Kunzi, manoɓungusya ɓɨnza, ɓɨngɔ nɨɓayɔ ka ɓatʉ nɨɓɔ ɓa ndɨ ɓongbingbili ko misa kakɨ. ");
INSERT INTO lik_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Iɓunu, maɓɨkyaga ɓɛ: ‹Takika ndɨ gɔnɨ ko ngbingo ka ɓotitosu, takʉkananɨgʉ ndɨ na ɨɓʉ ko dikiɗi yiɗukusaga ɓangʉ ka ɓogyalandʉ.› ");
INSERT INTO lik_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Iɓunu, miyipaga gɔnɨ kubatʉ ɓɛ ma ɓomiko-mika ɓalʉkʉ nɨɓɔ ɓulumwisaga ndɨ ɓogyalandʉ. ");
INSERT INTO lik_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Lɨkpʉmʉka nɨlɔ ɓotitonu ɓapʉnga ndɨ, iɓunu, wisisiloni kʉwa nolu na kodwisa ka muliɓo! ");
INSERT INTO lik_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Lɨvananza ka ɓanzʉka! Pisi tina yɔ makwanana ndɛkɛ mina kanyɨka yigyogyiso ko ɓuku ɓa ɓɛnzɛ na ɓɛnzɛ? ");
INSERT INTO lik_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Kinili, ɨmɨ, namʉtɨkɨlyatʉ ɓogyalandʉ, ɓatʉ ɓa yimibo na ɓowonisilo. Mʉmwɔgɔ ndɛkɛ ɓemoti-ɓemoti kaɓʉ, mʉbangɨlaga ɓagɔgɔ kʉgʉ wa salaba, mʉtɨna ɓagɔgɔ ɓata pimbo ka ɓandaɓʉ ɓaya malʉmba kunu na mukpumyo ka ɓagʉɗʉ ɓemoti-ɓemoti. ");
INSERT INTO lik_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ɛɛɛ, iɓunu kʉwa ndɛkɛ ɓɔ mɨɓʉnya lɨnʉnʉ ko bulya ɓangʉ ka ɓatʉ ɓasɨ nɨyɔ aɗʉkaga ndɨ payaya ka ɔɓɨlɨ. Ɓapʉnga mbɛyɨ ndɨ koɗukusaga ɓangʉ ka Abeli nɨnɔ a ndɨ mʉtʉ wongbingbili kadwɛ ka nɨyɔ ka Zakalia nɨnɔ a ndɨ mika Balakia. Ɨyɨ Zakalia, mamwɔ ndɨ ka Ndaɓʉ ko Kunzi luga wa pa yotu kʉgbɛ na gbɔgbɔ. ");
INSERT INTO lik_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","A lɨngʉnʉ, nakamʉɓɨkya ambɛ: ɓatʉ ɓa lɨvananza la lɨsyɛ li nɨlɨ, ɓɨɓʉnya ndɛkɛ lɨnʉnʉ ko bulya makpʉmʉka nɨmɔ masɨ.» ");
INSERT INTO lik_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","«Eeeze iɓunu ɓatʉ ɓa Yelusalɛma, ɓatʉ ɓa Yelusalɛma, iɓunu makaumwisiso na matamʉ ɓogyalandʉ nɨɓɔ Kunzi utikoku! Nganga yɨnga yɔ napa ndɨ mino kaʉmʉmʉla ɓatʉ kakʉ mʉɗɔngɔnɨ ɓɛyɔ kɔkʉ ʉmʉmʉlago mino ɓomikakɨ ka ɓɛpapandʉlʉ, luki limoti, iɓunu makapagʉ ndɨ! ");
INSERT INTO lik_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Wiboni sɛ ɓɨnza ambɛ ndaɓʉ kunu otigala ndɛkɛ ngundu. ");
INSERT INTO lik_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nakamʉɓɨkya ambɛ, katʉkya mbɨya wanʉ, makɛmɨnɨgʉ ɓata kadwɛ kʉ kwa kʉ maɓɨkya ndɛkɛ mino ɓɛ: ‹Kunzi aɗukulyi mʉtʉ yi nɨnɔ akodoku ɓʉɓʉnga ko lino ka Mombukwono-dosu!› » ");
INSERT INTO lik_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ngbingo yi nɨnɔ Yeso a ndɨ mino kaaga nɨ opupini ka Ndaɓʉ ko Kunzi, ɓaɓɨɓya kakɨ ɓakpuɗoku ndɨ. Ɓamonisilo kʉwa ɓɛyɔ Ndaɓʉ ko Kunzi ipika ndɨ mino. ");
INSERT INTO lik_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Luki limoti, Yeso ʉɓɨkya ndɨ ɓɛ: «Matʉ kaɨna masɨ nɨma? A lɨngʉnʉ, nakamʉɓɨkya ambɛ, ka masɨ nɨmɔ makaɨna wanʉ, lɨtalʉ gʉtʉgʉ limoti aka kotigoligʉ ndɛkɛ wanʉ kʉgʉ wa lagɔgɔ, apanzɨkana ndɛkɛ masɨ.» ");
INSERT INTO lik_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ngbingo yi nɨnɔ Yeso a ndɨ mina wakika ka Ngʉpa ya Mizeituni, ɓaɓɨɓya kakɨ ɓakpuɗoku ndɨ ɓɨkɛɗɛ, ɓamuusa ɓɛ: «Tɨɓɨkya mbɛyɨ, lɨkpʉmʉka li nɨlɔ igyonosa ndɛkɛ ngbinga tino? Likingyosi tino lɔ atimibisa ndɛkɛ yigoku kakʉ na muliɓo ma ɔɓɨlɨ?» ");
INSERT INTO lik_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yeso usikisya ndɨ ɓɛ: «Wiminyonito, mʉmbanzʉ gʉtʉgʉ ɓemoti aka kamuɓonitɔgʉ! ");
INSERT INTO lik_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ɓambanzʉ ɓudingi ɓodokuto ndɛkɛ ko lino kamɨ, ɓanaɓɨkya ɓɛ: ‹Ɨmɨ nɨ Kilisito!› Ɓuɓungusaga ndɛkɛ ɓambanzʉ ɓudingi! ");
INSERT INTO lik_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mʉkanatʉ ndɛkɛ ɓomongoni ɓa mʉnga na ɓakʉambɛ ɓi. Gʉtʉgʉ ɓɛyɔ, makoɓongonitɔgʉ. A ɓɛyɔ, masɨ nɨmɔ igyonosatʉ, luki limoti kikigʉ mbɛyɨ muliɓo ma ɔɓɨlɨ. ");
INSERT INTO lik_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","A ɓɛyɔ, lɨvananza limoti abʉmanaga ndɛkɛ na lɨvananza lagɔgɔ, ɓʉngama ɓimoti ʉlananaga ndɛkɛ na ɓʉngama ɓagɔgɔ. Ayʉndɨ na ɓazigizo ɓika ndɛkɛ ka ɓapa dididi. ");
INSERT INTO lik_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Luki limoti, nɨyɔ yasɨ ika ndɛkɛ mʉɗɔngɔnɨ abɛ mʉpʉnganagɨ ma mʉzʉzʉla ma liɓukuti aka. ");
INSERT INTO lik_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Kʉwa wa, ɓamʉgaba ndɛkɛ kayigyogyiso, ɓamʉmwɔgɔ. Ɓamʉmʉya ko giyo yasɨ ko bulya lino kamɨ. ");
INSERT INTO lik_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ko ngbingo yi nɨnɔ, ɓambanzʉ ɓudingi ɓogwa ndɛkɛ ka baya kaɓʉ. Ɓagabanaga ndɛkɛ na ɓamʉyana luga kaɓʉ. ");
INSERT INTO lik_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ɓogyalandʉ ɓudingi ɓa ɓɔngɔ ɓopuponokuto ndɛkɛ, ɓuɓungusaga ɓambanzʉ ɓudingi. ");
INSERT INTO lik_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ɓʉnyɛ ika kʉwa ndɛkɛ ɓakpʉ kʉgbɛ, sɨpananɨsɔ ka ɓambanzʉ ɓudingi adɨkaga. ");
INSERT INTO lik_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Luki limoti, mʉtʉ yi nɨnɔ okibya ndɛkɛ kadwɛ ka muliɓo, inisanatʉ na muhukuso. ");
INSERT INTO lik_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ɓaɓɨkyaga ndɛkɛ Mongoni Manza ma Ɓʉngama ɓa kʉgʉ wa lɨsyɛ ka ɔɓɨlɨ wasɨ, iba ɓʉdɛmʉ inisoni ka mababa masɨ. Kʉwa wa, muliɓo ma ɔɓɨlɨ odoku.» ");
INSERT INTO lik_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«Ko ngbingo yi nɨnɔ, mamɨnatʉ ndɛkɛ alʉkʉ nɨnɔ ɓamakaga ɓɛ ‹Mʉpʉpʉta mʉmbanga›, ɓamomosini ka Pa yo Tu. A mʉtʉ yi nɨnɔ mugyalandʉ Danyɛlɛ anzɨna ndɨ ko bulya kakɨ. (Mʉtʉ yi nɨnɔ akatangʉlaga lɨkpʉmʉka li nɨlɨ, ʉkanɨtɔ isi yi.) ");
INSERT INTO lik_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Kʉwa wa, ɓatʉ nɨɓɔ ɓika ndɛkɛ ka Yudɛa ɓogwa ndɛkɛ mbangʉ miso ya ɓangʉpa. ");
INSERT INTO lik_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Mʉmbanzʉ kiko kugbondo, kosyigʉ ndɛkɛ ɓata kava luki ka ndaɓʉ. ");
INSERT INTO lik_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Mʉmbanzʉ kika ko tiko, kɨgɨgʉ ndɛkɛ ɓata kava kutuko. ");
INSERT INTO lik_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ka masyɛ mi nɨmɔ, ɓoko ɓa ɓamʉma na nɨɓɔ ɓika ndɛkɛ kaulunguso ɓomiki ɓalya ndɛkɛ kumbu! ");
INSERT INTO lik_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Lumboni ambɛ mbangʉ kunu kikonitɔgʉ ko ngbinga wa ndɔɓɔ ikanɨ ka Lɨsyɛ la kimumbiso. ");
INSERT INTO lik_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","A ɓɛyɔ, ka masyɛ mi nɨmɔ, yigyogyisa ika ndɛkɛ yakpʉ kʉgbɛ nɨyɔ kanigyonosigʉ ndɛkɛ katʉkya ka mʉpʉnganagɨ ma ɔɓɨlɨ kadwɛ na lɨsyɛ li nɨlɨ. Na inguo ya yigyogyiso yi nɨyɔ kigyonosigʉ ndɛkɛ ɓata. ");
INSERT INTO lik_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kunzi kokundumosi ndɨ masyɛ mi, iba kɛgʉ na mʉmbanzʉ gʉtʉgʉ ɓemoti aka nɨnɔ ahʉka ndɛkɛ. Luki limoti, okundumosa ndɨ ɓɛyɔ ko bulya ka ɓatʉ nɨɓɔ ʉpʉnaga ndɨ. ");
INSERT INTO lik_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Kika nɨ mʉmbanzʉ amuɓikyini ɓɛ: ‹Winoni! Kilisito a wanʉ!› Ikanɨ ‹A kʉ!›, makaɓinikyononitɔgʉ. ");
INSERT INTO lik_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","A ɓɛyɔ, ɓakilisito ɓa ɓɔngɔ na ɓogyalandʉ ɓa kʉɓɔɓɔkʉ ɓopupokuto ndɛkɛ. Ɓagyaga ndɛkɛ mokingyosi makpʉkpʉ na makpʉmʉka mʉmbanga-mbanga kakɨsa kauɓungusaga gʉtʉgʉ ɓatʉ nɨɓɔ aka ɓɔ Kunzi ʉpʉnaga ndɨ. ");
INSERT INTO lik_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ɛɛɛ, hukononi! Ɨmɨ, namutukusyogini motili kambwa aka. ");
INSERT INTO lik_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Kika nɨ mʉmbanzʉ amuɓikyini ɓɛ: ‹Winoni! Kilisto a ka ɨsa!›, makindonitɔgʉ kʉ ɓɛyɔ. Ikanɨ kamʉɓɨkya ɓɛ: ‹Winoni! A ka ndaɓʉ ya kʉsɔ!›, makaɓinikyononitɔgʉ. ");
INSERT INTO lik_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","A ɓɛyɔ, doku ko Mika-mʉmbanzʉ ika ndɛkɛ mʉɗɔngɔnɨ abɛ ngbangbata kangɨnana, ozigo ɔɓɨlɨ wasɨ katʉkya ka ɨngɛngɛ adwɛ ka dumbe. ");
INSERT INTO lik_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Pa yasɨ nɨyɔ manda ika ndɛkɛ mino, ɓombu nɨɓɔ ɓalyaga makɔlɔ ɓamʉmʉkana wa gɔ wa.» ");
INSERT INTO lik_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«Ngbinga mʉkɛɗɛ kumbusa wa masyɛ ma yigyogyiso yi nɨyɔ, ‹Mɔnɨ olimika ndɛkɛ ɓipi. Tɨmba kanzɨgʉ ndɛkɛ ɓata. Mangʉtʉ onyukogoku ndɛkɛ kotukyoku kʉgʉ wa lɨsyɛ. Makpʉmʉka mo ngu nɨmɔ kʉgʉ wa lɨsyɛ ɨzʉkʉla ndɛkɛ ɓingbwuku-ngbwuku.› ");
INSERT INTO lik_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Kʉwa wa, likingyosi ko Mika-Mʉmbanzʉ inisanatʉ ndɛkɛ kʉgʉ wa lɨsyɛ. Mababa masɨ ka ɓambanzʉ nɨɓɔ kusili wa mɔnɨ igomisagatʉ ndɛkɛ. Ɓamɨna kʉwa ndɛkɛ Mika-Mʉmbanzʉ nɨ anodoku ka ɓɛkʉɓa no ngu na ɨbɨba yakpʉ. ");
INSERT INTO lik_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ɓofya ndɛkɛ sɨɓa nɨyɔ apága lɨyʉ lapʉ. Mika-Mʉmbanzʉ ʉtɨka ndɛkɛ ɓamalaika kakɨ ka mondu masɨ makwanganya ma ɔbɨlɨ, kaʉmʉmʉla ɓatʉ ɓasɨ nɨɓɔ ʉpʉnaga ndɨ ka ɓanakpangbala ɓasɨ ɓa ɔɓɨlɨ.» ");
INSERT INTO lik_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«Hukononi mʉtɨwɨ nɨmɔ sɨbʉkʉsɔ akapá. Ngbingo yi nɨnɔ mapakʉ ma sɨbʉkʉsɔ obuukonogo mino, magɔgɔ apʉnga kaɓaka, mibaga ɓɛ syangasʉ a kʉwa ɓuwobi koɓuniko. ");
INSERT INTO lik_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Mʉɗɔngɔnɨ gɔnɨ, ngbingo yi nɨnɔ iɓunu mɨna ndɛkɛ mina makpʉmʉka mi nɨmɔ masɨ, wiboni ambɛ doku ko Mika-Mʉmbanzʉ a kʉwa ɓuwobi, a ka mupumi. ");
INSERT INTO lik_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","A lɨngʉnʉ, nakamʉɓɨkya ambɛ, ɓatʉ ɓa lɨvananza li nɨlɨ ɓakolumwogigʉ ɓasɨ nɨ makpʉmʉka mi nɨmɔ masɨ kanigyonosigʉ. ");
INSERT INTO lik_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Lɨsyɛ na lɨtɔmbʉ olimikatʉ ndɛkɛ, luki limoti lɨkpʉmʉka kamɨ kolimikigʉ ndɛkɛ lu.» ");
INSERT INTO lik_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","«Mʉmbanzʉ gʉtʉgʉ ɓemoti aka kibigʉ lɨsyɛ ikanɨ ngbingo yi nɨnɔ makpʉmʉka mi nɨmɔ igyonosa ndɛkɛ mino, iki ɓamalaika ɓa kʉgʉ wa lɨsyɛ ikanɨ Miki. Luki limoti, Baba mʉkaka aka nɔ akaibo. ");
INSERT INTO lik_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Mʉɗɔngɔnɨ ɓɛgɛyɔ igyonosa ndɨ mino ko ngbingo ka Nʉa, ika ndɛkɛ ɓɛgɛyɔ ko ngbingo yi nɨnɔ Mika-mʉmbanzʉ odoku ndɛkɛ mino. ");
INSERT INTO lik_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","A ɓɛyɔ, kambwa wo tumo yidingi, ɓambanzʉ ɓikaga ndɨ kalyalya, ɓanomwo, ɓanavanana, ɓanʉgaba ɓomikaɓʉ ka ɓovononi kadwɛ ka lɨsyɛ li nɨlɔ Nʉa ogulya ndɨ mino ka ɨngbɔlɔ. ");
INSERT INTO lik_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ɓakatamanagɨgʉ ndɨ lɨkpʉmʉka gʉtʉgʉ limoti aka, kadwɛ kʉ kwa kʉ tumo yidingi odoku ndɨ mino kaulumwisaga ɓasɨ ɓɨgbatata. Ika ndɛkɛ mʉɗɔngɔnɨ ɓɛgɛyɔ ka lɨsyɛ li nɨlɔ Mika-mʉmbanzʉ igoku ndɛkɛ mino. ");
INSERT INTO lik_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ngbingo yi nɨnɔ, ɓambanzʉ ɓaɓa ɓikaga ndɛkɛ ko tiko, ɓavaga ndɛkɛ ɓemoti, ɓasa wagɔgɔ. ");
INSERT INTO lik_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ɓoko ɓaɓa ɓikaga ndɛkɛ kadwa mʉpʉnga, ɓava ndɛkɛ ɓemoti, ɓasa wagɔgɔ. ");
INSERT INTO lik_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Yɛkɨ a ɓɛyɔ, wikoni nɛkɨ ɓuɓisi, kyɛ makibigʉ lɨsyɛ nɨlɔ Mombukwono-donu igoku ndɛkɛ mino. ");
INSERT INTO lik_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Wiboni ɓɨnza ambɛ, mombukwana ndaɓʉ kibaga ndɨ ngbingo yi nɨnɔ mʉtʉ wo kuɓakʉ odoku mino, iba ikaga ɓongbinga ɓasɨ wakɨtʉlya kyɛ ɓakoɓunonitɔgʉ ndaɓʉ kakɨ. ");
INSERT INTO lik_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kinili, wikoni nɛkɨ ɓakɨtʉlya, kyɛ Mika-mʉmbanzʉ odoku ndɛkɛ ko ngbingo yi nɨnɔ makikigʉ mino na mʉtamanagɨ.» ");
INSERT INTO lik_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","«Wanɨ sɛ kʉwa nɔ a mʉgya-ligubo walɨngʉnʉ na wakimibo? A nɨnɔ mombukwana-dakɨ asɨlya ligubo lɨlʉpyaga malɨlɨ ka ɓagya-ligubo ɓagɔgɔ ko ngbingo yi nɨnɔ okwononi mino. ");
INSERT INTO lik_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ɨgyagya ka mʉgya-ligubo nɨnɔ mombukwana-dakɨ kigoku, atakanya iɗukufini ɓiguɓu kagya ligubo li nɨlɔ. ");
INSERT INTO lik_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","A lɨngʉnʉ, nakamʉɓɨkya ambɛ, mombukwana-dakɨ abisa ngama kaanda mukumba kakɨ masɨ. ");
INSERT INTO lik_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Luki limoti, kika mʉgya-ligubo wanyɛ nɨnɔ ɨɓɨkyaga ɓɛ: ‹Mombukwana-damɨ kɛgʉ kaigoku mbɨya wanʉ.› ");
INSERT INTO lik_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Apʉnga kʉwa kaʉbʉma ɓawai-dakɨ ɓagya-ligubo, kalyalya na komwo pa imoti na ɓadangbala. ");
INSERT INTO lik_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Mombukwana-dakɨ yi nɨnɔ igoku ɓanʉ ka lɨsyɛ na ko ngbingo yi nɨnɔ kikigʉ mino kaibo. ");
INSERT INTO lik_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Akpumyo, agyogyisa mʉɗɔngɔnɨ ɓɛyɔ Kunzi ugyogyisa ndɛkɛ mino ɓatʉ ɓa kʉɓɔbɔkʉ, ambimbo ka pa nɨyɔ ɓagamanaga mino, ɓanɨlya manzʉ ɓɨkyalʉ-kyalʉ.» ");
INSERT INTO lik_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","«Ka lɨsyɛ li nɨlɔ, ɓokingyasa ndɛkɛ ɓʉngama ɓa kʉgʉ wa lɨsyɛ na ɓasɨka tɛkɛɓɛ. Ɨɓʉ, ɓʉva ndɨ ɓatala kaɓʉ, ɓaga katɨlya mombukwono dumo wa ndʉwa. ");
INSERT INTO lik_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Luga kaɓʉ, kuɓukumuti ɓa ndɨ nɨɓɔ ɓakimibo. Na kuɓukumuti ɓagɔgɔ ɓatʉ ɓʉzɨnga. ");
INSERT INTO lik_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Nɨɓɔ ɓʉzɨnga ɓʉva ndɨ ɓatala kaɓʉ aka, nɨ ɓakovigʉ molingo magɔgɔ mʉmatɨla kʉsɔ yi. ");
INSERT INTO lik_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Luki limoti, nɨɓɔ ɓakimibo, ɓʉva ndɨ ɓatala na molingo magɔgɔ ka ɓasupa. ");
INSERT INTO lik_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Nɨyɔ mombukwono dumo wa ndʉwa olipya nɨ kanodukugʉ, ɓoko ɓi nɨɓɔ ɓasɨ ɓapʉnga ndɨ kazɨnga ɓatɔtɔ, ɓalalana ndɨ. ");
INSERT INTO lik_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Lugo wo biti, lɨyʉ limoti aɓɨkya ndɨ ɓɛ: ‹Winoni! Mombukwana dumo wa ndʉwa a ko pisi! Gyoni, togoni katɨlya!› ");
INSERT INTO lik_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Kʉwa wa, ɓoko ɓasɨ ɓozuzuka ndɨ, ɓʉtʉnaga ɓatala kaɓʉ. ");
INSERT INTO lik_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ɓasɨka ɓʉzɨnga ɓʉɓɨkya ndɨ nɨɓɔ ɓakimibo ɓɛ: ‹Tipóni gɔnɨ mino ɨkya molingo, kyɛ ɓatala kusu ɓanolimiko.› ");
INSERT INTO lik_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Luki limoti, ɓusikisya ndɨ ɓɛ: ‹Kalɨ! Molingo mi nɨma a makɛɗɛ, kakwananɨgʉ katɨtʉlyana ɓasɨ! Windoni koluwo mokunu ka ɓatʉ nɨɓɔ ɓagabaga.› ");
INSERT INTO lik_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ngbingo yi nɨnɔ ɓɨnda ndɨ mino, mombukwono dumo wo vononi osiloku. Ɓawai daɓʉ kuɓukumuti nɨɓɔ ɓa ndɨ ɓakɨtʉlya, ɓingya ndɨ pa imoti na ɨɓʉ ka ndaɓʉ yo dumo. Kumbuso yi, ɓadʉla ndɨ mupumi. ");
INSERT INTO lik_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Kʉwa wa, nɨɓɔ ɓʉzɨnga ɓigoku ndɨ, ɓaɓɨkya ɓɛ: ‹Hiii Mombukwono-dosu! Mombukwono-dosu! Tihukwilyanɔ ɓaka mupumi!› ");
INSERT INTO lik_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Luki limoti, osikisya ndɨ ɓɛ: ‹A lɨngʉnʉ, nakamʉɓɨkya ambɛ, nakamumibigʉ!›» ");
INSERT INTO lik_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yeso aɓɨkya ɓata ndɨ ɓɛ: «Wikogoni nɛkɨ ɓuɓisi! Kyɛ makibigʉ lɨsyɛ ɨkanɨ ngbingo.» ");
INSERT INTO lik_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","«Ɓokingyasa ndɛkɛ Ɓʉngama ɓa kʉgʉ wa lɨsyɛ na mʉtʉ ɓemoti nɨnɔ a ndɨ na lɨgʉndʉ. Kambwa katʉkya, ʉmaka ndɨ ɓagya-ligubo kakɨ, ʉgbananɨlyaga makpʉmʉka kakɨ. ");
INSERT INTO lik_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Kaɓyɛnɛnɛ no ngu ka mʉmbanzʉ yɨkaka-yɨkaka, apá ndɨ mʉgya-ligubo ɓemoti ɓambuma kuɓukumuti. Wagɔgɔ, apá ndɨ ɓambuma ɓaɓa. Na wagɔgɔ ɓata, apá ambuma ɓemoti. Kumbuso yi, aga ndɨ ɨyɨ. ");
INSERT INTO lik_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Mʉgya-ligubo nɨnɔ ɓapá ɓambuma kuɓukumuti, aga ndɨ na iɓu koyikosogo, inisana ndɨ ɓata na ɓagɔgɔ kʉgʉ yi kuɓukumuti. ");
INSERT INTO lik_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Nɨnɔ ɓapá ndɨ ɓambuma ɓaɓa, aga ndɨ ɨyɨ koyikosogo ɓɛgɛyɔ, inisana ndɨ na ɓagɔgɔ kʉgʉ yi ɓaɓa gɔnɨ. ");
INSERT INTO lik_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Luki limoti, nɨnɔ ɓapá ndɨ ambuma ɓemoti, ɨnda ndɨ kakpɔ lɨɓyɛ, olumbo, asʉma ndɨ. ");
INSERT INTO lik_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Nɨyɔ masyɛ akɨtaga mudingi, mombukwana-daɓʉ igoku ndɨ. Ʉɓɨkya kʉwa ndɨ ɓagya-ligubo kakɨ ɓi nɨɓɔ ɓɛ ɓatʉmbʉlyagɨ ɨsaɓʉ ya makpʉmʉka kakɨ. ");
INSERT INTO lik_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Mʉgya-ligubo nɨnɔ ɓapá ndɨ ɓambuma kuɓukumuti, odoku, apá ɓagɔgɔ kuɓukumuti kʉgʉ yi. Aɓɨkya ndɨ ɓɛ: ‹Mombukwono-dosu! Wɛsa ndɨ na ɓambuma kuɓukumuti. Wɨna! Ninisana ndɨ ɓata na ɓagɔgɔ kuɓukumuti gɔnɨ.› ");
INSERT INTO lik_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Mombukwana-dakɨ aɓɨkya ndɨ ɓɛ: ‹A ɓɨnza! Wa mʉgya-ligubo wanza. Wo ɓi na ɓungbingbili ko luki lɨkɛdɛ, nubisa ɓanʉ ngama koɓuulyaga makpʉmʉka mudingi. Gulyo ka ɨgyagya ka Mombukwana-dakʉ!› ");
INSERT INTO lik_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Mʉgya-ligubo nɨnɔ ɓapá ndɨ ɓambuma ɓaɓa, odoku ndɨ gɔnɨ ɨyɨ, aɓɨkya ndɨ ɓɛ: ‹Mombukwono-dosu! Wɛsa ndɨ na ɓambuma ɓaɓa aka. Wɨna! Ninisana ndɨ ɓata na ɓambuma ɓagɔgɔ ɓaɓa kʉgʉ yi.› ");
INSERT INTO lik_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Mombukwana-dakɨ aɓɨkya ndɨ ɓɛ: ‹A ɓɨnza, wa mʉgya-ligubo wanza na walɨngʉnʉ! Wo ɓi mʉtʉ walɨngʉnʉ koɓuulyogo luki lɨkɛɗɛ, nubisa ɓanʉ ngama koɓuulyogo makpʉmʉka mudingi. Gulyo ka ɨgyagya ka Mombukwana-dakʉ!› ");
INSERT INTO lik_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Kʉwa wa, mʉgya-ligubo nɨnɔ ɓapá ndɨ ambuma ɓemoti, odoku, aɓɨkya ndɨ ɓɛ: ‹Hiii Mombukwono-dosu, nibagatʉ ambɛ wa mʉɗɨya. Wobuulyaga kʉ wakakʉnagɨgʉ mino, wanyɔgɔ masɔlɔ kʉ wakokunigʉ mino. ");
INSERT INTO lik_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Kinili, naɓangatʉ ndɨ, naga kasʉma ambuma kakʉ ka lɨtɔmbʉ. Wɨna! Va ambuma kakʉ nɨmʉ.› ");
INSERT INTO lik_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Mombukwana-dakɨ asikisya ndɨ ɓɛ: ‹Wa mʉgya-ligubo wanyɛ, mʉfɔlɔɓɔndɔ! Wibagatʉ ndɨ ɓɛ nobuulyaga kʉ nakakʉnagɨgʉ mino, namʉmʉla masɔlɔ nɨmɔ nakokunigʉ. ");
INSERT INTO lik_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Yɛkɨ a ɓɛyɔ! Wakwanana ndɨ kobisa ɓuyi kamɨ ka baki, iba wa nigiku mino, nakwanano bi konyoku nɨ itundini. ");
INSERT INTO lik_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Mukupyoni nɛkɨ ambuma yi nɨnɔ, mapá mʉtʉ yi nɨnɔ a ndɨ noɓu tɛkɛɓɛ. ");
INSERT INTO lik_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","A ɓɛyɔ, mʉmbanzʉ kika no luki, ɓamatɨlyatʉ ɓata, ika kʉwa na imu makpʉ. Luki limoti, mʉtʉ yi nɨnɔ kɛgʉ no luki ɓakʉpya gʉtʉgʉ luki lɨkɛɗɛ aka nɨlɔ akwanano ɓi kaika nolu. ");
INSERT INTO lik_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Mʉgya-ligubo yi nɨmʉ kɛgʉ na ɨzangɨya, muɗikitoni kunzi ko biti, a pa ya kigomisogo na kaɨlya manzʉ.›» ");
INSERT INTO lik_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","«Ngbingo yi nɨnɔ Mika-Mʉmbanzʉ odoku ndɛkɛ mina ka ɨbɨba kakɨ, pa imoti na ɓamalaika ɓasɨ, ika ndɛkɛ ko kiti kakɨ wa ɓʉngama, ka ɨbɨba ya kʉgʉ wa lɨsyɛ. ");
INSERT INTO lik_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ɓambanzʉ ɓo giyo yasɨ ɓamʉmʉkana ndɛkɛ kambwa kakɨ. Ʉgbanana ndɛkɛ ɓambanzʉ dididi mʉɗɔngɔnɨ ɓɛyɔ muɓuɓulyo ʉgbananaga mino ɓamɛmɨ na ɓakɔndɔlɔ. ");
INSERT INTO lik_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ubisa ndɛkɛ ɓakɔndɔlɔ ka nakpangbala wa kumbanzɨkanɨkɔ kakɨ, ubisa ɓamɛmɨ ka kulekuke. ");
INSERT INTO lik_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Nɨɓɔ ɓa ka kumbanzɨkanɨkɔ, ngama ʉɓɨkya kʉwa ndɛkɛ ɓɛ: ‹Doniku, iɓunu nɨɓɔ Baba amuɗukulyoni ndɨ ɓʉɓʉnga. Voni lisimo la ɓʉngama nɨlɔ ɓamuɓungusilyaga ndɨ katʉkya ko ngbingo nɨnɔ aka nɔ ɓagya ndɨ mino ɔɓɨlɨ. ");
INSERT INTO lik_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","A ɓɛyɔ, na ndɨ kaɨmʉkana nza, mɛpátʉ ndɨ malɨlɨ. Na ndɨ na mʉsasa, mɛpá liɓo limwo. Na ngbingo yi nɨnɔ na ndɨ mino mubiko, mɛtɨlyatʉ ndɨ. ");
INSERT INTO lik_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ngbingo yi nɨnɔ na ndɨ mino ndumbu, mɛpátʉ ndɨ ɓotu. Na ndɨ no koloɓu, modokutɔ ndɨ kɛnda. Ko ngbingo yi nɨnɔ na ndɨ mino ka bɔlɔkɔ, modokutɔ ndɨ kɛnda.› ");
INSERT INTO lik_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Kʉwa wa, ɓatʉ ɓongbingbili ɓamuusa ndɛkɛ ɓɛ: ‹Mombukwono-dosu, ngbinga tino nɔ tʉmɨna ndɨ mina na nza, tʉpá malɨlɨ? Ikanɨ na mʉsasa, tʉpá liɓo limwo? ");
INSERT INTO lik_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ngbinga tina nɔ wa ndɨ mino mubiko, tʉtɨlya? Ikanɨ wa ndɨ ndumbu, tʉpá ɓotu? ");
INSERT INTO lik_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Na ngbinga tina nɔ tʉmɨna ndɨ mino no koloɓu, ikanɨ ka bɔlɔkɔ taga kaʉnda?› ");
INSERT INTO lik_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Kʉwa wa, ngama usikisya ndɛkɛ ɓɛ: ‹A lɨngʉnʉ, nakamʉɓɨkya ambɛ, lasɨ nɨlɔ magyɨlya ndɨ ɓemoti luga ka ɓomiki ɓakɛkɛkɛ ɓi nɨɓa ɨkanɨ ɓemoti luga ka ɓomika-mama, mɛgyɨlya ndɨ ɨmɨ ɓɨkpɛ.› ");
INSERT INTO lik_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Kʉwa wa, ʉɓɨkya ndɛkɛ nɨɓɔ ɓika ndɛkɛ ka kulekuke kakɨ ɓɛ: ‹Tukyoni ɓuwobi na ɨmɨ, iɓunu migbongisisoni! Windoni ko ɓuku ɓa ɓɛnzɛ na ɓɛnzɛ. Ɓuku ɓi nɨɓɔ iɓungusyaga ndɨ ko bulya ka mumuyoniso na ɓamalaika kakɨ! ");
INSERT INTO lik_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","A ɓɛyɔ, na ndɨ kaɨmʉkana nza, makɛpágʉ ndɨ malɨlɨ. Na ndɨ na mʉsasa, makɛpágʉ ndɨ liɓo limwo. ");
INSERT INTO lik_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ngbingo yi nɨnɔ na ndɨ mina mubiko, makɛtɨlyagʉ ndɨ. Ngbingo yi nɨnɔ na ndɨ mina ndumbu, makɛpágʉ ndɨ ɓotu. Na ngbingo yi nɨnɔ na ndɨ mina no koloɓu ikanɨ ka bɔlɔkɔ, makodokugʉ ndɨ kɛnda.› ");
INSERT INTO lik_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Kʉwa wa, ɓasikisya ndɛkɛ ɓɛ: ‹Mombukwono-dosu, ngbinga tina nɔ wa ndɨ mina kaɨmʉkana nza, ikanɨ mʉsasa, ikanɨ wa ndɨ mubiko, ikanɨ wa ndɨ ndumbu, ikanɨ no koloɓu, ikanɨ ka bɔlɔkɔ nɨ takusingyigʉ?› ");
INSERT INTO lik_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ngama usikisya kʉwa ndɛkɛ ɓɛ: ‹A lɨngʉnʉ, nakamʉɓɨkya ambɛ, lasɨ nɨlɔ makagyɨlyagʉ ndɨ ɓemoti luga ka ɓomiki ɓakɛkɛkɛ bi nɨɓa, makɛgyɨlyagʉ ndɨ ɨmɨ.› ");
INSERT INTO lik_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ɓatʉ ɓi nɨɓɔ ɓopupa ndɛkɛ wa, ɓaga kaigyogyiso ka ɓɛnzɛ na ɓɛnzɛ. Luki limoti, nɨɓɔ ɓongbingbili, ɓogulyo ndɛkɛ ka ɔɓɨlɨ wa ɓɛnzɛ na ɓɛnzɛ.» ");
INSERT INTO lik_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ngbingo yi nɨnɔ Yeso ama ndɨ mina kapá mʉtɨwɨ mi nɨmɔ masɨ, ʉɓɨkya ɓaɓɨɓya kakɨ ɓɛ: ");
INSERT INTO lik_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Makaiba ɓɛ yɨnga wa Pasɨka ika ɓanʉ kumbusa wa masyɛ maɓa. Ɓasʉtatʉ Mika-Mʉmbanzʉ kyɛ ɓabangɨlagɨ ka mʉsalaba.» ");
INSERT INTO lik_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Kʉwa wa, ɓokumu-kumu na ɓambɔkʉ-mbɔkʉ ka Ɓayuda ɓamʉmʉkana ndɨ ka ndaɓʉ ko kumu-kumu ɓɛyɔ ka Kayafa. ");
INSERT INTO lik_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ɓagya ndɨ dikiɗi kagwisiso Yeso ɓɨpɛlɛ na kamwisiso. ");
INSERT INTO lik_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Luki limoti, ɓa ndɨ kaɓɨkya ɓɛ: «Takagwinitɔgʉ ko ngbinga wa yɨnga, kyɛ ɓambanzʉ ɓakovikimonogoni.» ");
INSERT INTO lik_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ngbingo yi nɨnɔ Yeso a ndɨ mina ka Betania, ogulya ndɨ ka ndaɓʉ ka Simoni nɨnɔ a ndɨ keɓu-keɓu. ");
INSERT INTO lik_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Muko ɓemoti akpuɗoku ndɨ. Muko yi nɨnɔ a ndɨ na malazi ma lɨgabʉ lapʉ kʉgbɛ ko supa nɨnɔ ɓagya ndɨ na lɨtalʉ la alibati. Ngbingo yi nɨnɔ Yeso a ndɨ mino kalyalya, muko yi nɨnɔ akpazyaga ndɨ na malazi mi nɨmɔ ka mʉ. ");
INSERT INTO lik_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Nɨyɔ ɓaɓɨɓya kakɨ ɓɨna ɓɛyɔ, ʉtʉla. Ɓaɓɨkya ɓɛ: «Ko bulya ɨkɨ yɔ akapʉta mino malazi ɓɛyɔ? ");
INSERT INTO lik_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ɓakwanano ɓi kagaba ka lɨgabʉ lapʉ kʉgbɛ na kaʉpá ɓatʉ ɓa yangya ɓuyi ɓi!» ");
INSERT INTO lik_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yeso andʉnga ndɨ yɨkpʉkpʉmʉkya kaɓʉ, umuusa kʉwa ɓɛ: «Ko bulya ɨkɨ yɔ mo mino kaɨkpʉkpʉmʉkya kʉgʉ ka muko yi nɨmʉ? Nɨlɔ egyilyi, a yanza! ");
INSERT INTO lik_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","A ɓɛyɔ, mika ndɛkɛ pa imoti na ɓatʉ ɓa yangya masyɛ masɨ. Luki limoti, ɨmɨ, takikigʉ ndɛkɛ pa imoti na iɓunu aka. ");
INSERT INTO lik_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ngbingo yi nɨnɔ ekpozyi mino na malazi nɨma ka nzʉyɨ, akeɓungusyogo ko bulya lɨsyɛ nɨlɔ ɓelumba ɓanʉ mino. ");
INSERT INTO lik_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","A lɨngʉnʉ, nakamʉɓɨkya ambɛ: ɓapa ɓayasɨ kʉ ɓaɓɨkyaga ndɛkɛ mino Mongoni Manza mi nɨma ka ɔɓɨlɨ wasɨ, ɓatamanaga ndɛkɛ nɨlɔ muko yi nɨmʉna ogyi, ɓanatʉmbʉlaga yi.» ");
INSERT INTO lik_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Kʉwa wa, Yuda Isikalioti, ɓemoti luga ka ɓatʉtʉmbwa tɛkɛɓɛ na ɓaɓa, ɨnda ndɨ ka ɓokumu-kumu. ");
INSERT INTO lik_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Umuusa ndɨ ɓɛ: «Nakamʉgabɨlya, mɛpá ɨkɨ?» Kʉwa wa, ɓapá ɓambuma ɓayo ɓuyi ɓatɛkɛɓɛ ɓasaa. ");
INSERT INTO lik_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Katʉkya ko ngbingo yi nɨnɔ, Yuda apʉnga kʉwa ndɨ kakɨsa pisi kaʉgabɨlya Yeso. ");
INSERT INTO lik_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ka lɨsyɛ la mambwa la yɨnga wa Mukati mokofulu, ɓaɓɨɓya ka Yeso ɓakpuɗoku ndɨ, ɓamuusa ɓɛ: «Wakapa ɓɛ tuɓungusilyogiku malɨlɨ ma Pasɨka yanɨ?» ");
INSERT INTO lik_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Usikisya ndɨ ɓɛ: «Windoni ka gʉɗʉ, ka alʉkʉ ɓemoti ɓɛnɛ. Maɓikyoku ɓɛ: Muwonisilo akaɓɨkya ɓɛ: ‹Ngbingo kamɨ a kʉwa ɓuwobi. Nakalya Pasɨka kʉ kakʉ pa imoti na ɓaɓɨɓya kamɨ.›» ");
INSERT INTO lik_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ɓaɓɨɓya ɓagya ndɨ mʉɗɔngɔnɨ ɓɛyɔ Yeso ʉkpamya ndɨ mino, ɓamba kʉwa ndɨ malɨlɨ ma Pasɨka kʉ ɓɛyɔ. ");
INSERT INTO lik_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Nɨyɔ ɓʉgɔgɔ ogwo, Yeso ika ndɨ kalyalya pa imoti na ɓatʉtʉmbwa tɛkɛɓɛ na ɓaɓa. ");
INSERT INTO lik_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ngbingo nɨnɔ ɓa ndɨ mino kalyalya, aɓɨkya ɓɛ: «A lɨngʉnʉ, nakamʉɓɨkya ambɛ, ɓemoti kunu ɛgabatʉ.» ");
INSERT INTO lik_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ɓatʉtʉmbwa ɓalya ndɨ kumbu, ɓapʉnga kamuusogo yɨkaka-yɨkaka ɓɛ: «Mombukwono-dosu! Ɨmɨ?» ");
INSERT INTO lik_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yeso osikisya ɓɛ: «Mʉtʉ yi nɨnɔ akamakyaga kʉɓɔkʉkɔ ka sanɨ pa imoti na ɨmɨ nɔ ɛgaba ɓanʉ. ");
INSERT INTO lik_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mika-mʉmbanzʉ akokwa mʉɗɔngɔnɨ ɓɛyɔ ikpikaga ndɨ mino ko bulya kakɨ. Luki limoti, kumbu yidingi ka mʉtʉ yi nɨnɔ akagaba yi! Ika gʉtʉgʉ ndɨ ɓɨnza kʉgbɛ nɨ kɨɓukutigʉ!» ");
INSERT INTO lik_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Kʉwa wa, Yuda nɨnɔ a ndɨ kagaba, amuusa ɓɛ: «Muwonisilo! Ɨmɨ?» Yeso asikisya ndɨ ɓɛ: «Woɓikyi nɨ ɨwɛ!» ");
INSERT INTO lik_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ngbingo yi nɨnɔ ɓa ndɨ mino kalyalya, Yeso ava ndɨ mukati. Kumbuso kabibisa Kunzi, oɓunonogo, ʉpága ɓaɓɨɓya kakɨ. Ʉɓɨkya kʉwa ndɨ ɓɛ: «Voni, malya, a nzʉyɨ kamɨ.» ");
INSERT INTO lik_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Kʉwa wa, ava ndɨ kɔpɔ, kumbuso kabibiso Kunzi, ʉpá. Ʉɓɨkya ndɨ ɓɛ: «Mwoni iɓunu ɓasɨ! ");
INSERT INTO lik_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","A ɓɛyɔ, nɨyɨna a ɓangʉ kamɨ. Ɓangʉ ya agʉmɛ ko Kunzi. Oɗukonaga ndɛkɛ ko bulya ka ɓatʉ ɓudingi na ko bulya mʉpɨlya ma ɓʉnyɛ. ");
INSERT INTO lik_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nakamʉɓɨkya ambɛ, nakamwigʉ ndɛkɛ ɓata vinya wa muzabibu, kadwɛ ka lɨsyɛ nɨlɔ namwo ndɛkɛ mino nɨnɔ wambɨya pa imoti na iɓunu ɓasɨ ka ɓʉngama ka Baba.» ");
INSERT INTO lik_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Kʉwa wa, ɓɨmbɨla ndɨ lɨmbʉ libibisa Kunzi. Kumbuso yi, ɓopupa ndɨ wa, ɓaga ka Ngʉpa ya Mizeituni. ");
INSERT INTO lik_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Kʉwa wa, Yeso ʉɓɨkya ndɨ ɓaɓɨɓya kakɨ ɓɛ: «No biti ya lɨsyɛ li nɨlɨ, iɓunu ɓasɨ mɛmanganyatʉ. A ɓɛyɔ, ikpikaga ndɨ ɓɛ: ‹Namwɔ ndɛkɛ muɓuɓulyo ka ɓakɔndɔlɔ. Na ambaza kaɓʉ omisikana ɓingbwi.› ");
INSERT INTO lik_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Luki limoti, kumbuso ɨmɨ kopupo ka mbʉkʉ, metokonyoku ndɛkɛ ka Galilaya.» ");
INSERT INTO lik_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Kʉwa wa, Pɛtɛlɛ aɓɨkya ndɨ ɓɛ: «Gʉtʉgʉ ɓɛngɛnɨ ɓasɨ ɓakuginyo, luki limoti, ɨmɨ nakʉmanganyɨgʉ ndɛkɛ!» ");
INSERT INTO lik_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yeso asikisya ndɨ ɓɛ: «A lɨngʉnʉ, nakaʉɓɨkya ambɛ, no biti ya lɨsyɛ li nɨlɨ, kambwa kɔkʉ kaalɨka, wika nɨ wemongonyini nganga yɨsaa.» ");
INSERT INTO lik_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pɛtɛlɛ asikisya ndɨ ɓɛ: «Gʉtʉgʉ kiko ɓɛ tokwi pa imoti, nakʉmanganyɨgʉ ndɛkɛ!» Ɓaɓɨɓya ɓagɔgɔ ɓasɨ ɓaɓɨkya ndɨ ɓɛgɛyɔ. ");
INSERT INTO lik_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Kʉwa wa, Yeso na ɓaɓɨɓya kakɨ ɓosila ndɨ ka Gɛtɛsɛmanɨ. Ngbingo yi nɨnɔ ɓadwɛ ndɨ mino, ʉɓɨkya ɓɛ: «Wikonononi wanʉ ko ngbingo yi nɨnɔ na mbɛyɨ mino kaɨnda kalʉmba kʉ.» ");
INSERT INTO lik_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Kumbuso yi, ɓaga ndɨ na Pɛtɛlɛ na ɓomika Zɛbɛdayɔ ɓaɓa. Yeso apʉnga ndɨ kalya kumbu, otuma na kʉɓangakʉ ɓɨɗɛ. ");
INSERT INTO lik_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Kʉwa wa, ʉɓɨkya ndɨ ɓɛ: «Nakalya kumbu kʉgbɛ ɓuwobi kokwo. Wikoni wanʉ, mika ɓuɓisi aka pa imoti na ɨmɨ.» ");
INSERT INTO lik_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Kumbuso yi, isisila ndɨ kambwa yɨkɛɗɛ, ogwo mokpukpu. Apʉnga kalʉmba ɓɛ: «Babooo! Kika nɨ akwananatʉ, ikiɗisyanɔ ɓaka kɔpɔ wa yigyogyiso yi nɨmʉ! Gʉtʉgʉ ɓɛyɔ, kikonitɔgʉ sɨpananɨsɔ kamɨ. Luki limoti, iki nɨsɔ kakʉ aka.» ");
INSERT INTO lik_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Kumbuso yi, Yeso igoku ndɨ wa ʉsa ndɨ mina ɓaɓɨɓya kakɨ, ʉtakanya kʉwa ndɨ ka ɓatɔtɔ. Amuusa ndɨ Pɛtɛlɛ ɓɛ: «Wakokwononigʉ kaika muɓisi pa imoti na ɨmɨ gʉtʉgʉ ka saa-imoti aka? ");
INSERT INTO lik_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Wikoni ɓuɓisi, manalʉmba, kyɛ makogulyonitɔgʉ ka kʉɓɔɓɔkʉ! Lɨmbɛngɨ a na mʉsasa kagya ɓʉnza, luki limoti, nzʉyɨ a na ɓʉpɔ.» ");
INSERT INTO lik_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yeso ʉkɨɗa ndɨ ka nganga ya yɨɓa, alʉmba ɓɛ: «Babooo! Kika nɨ kokwononigʉ ɓi ɓɛ kɔpɔ wa yigyogyiso yi nɨmʉ akɨɗɨ nɨ nakamwɨgʉ, sɨpananɨsɔ kakʉ igyonosi nɛkɨ!» ");
INSERT INTO lik_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ngbingo yi nɨnɔ igoku ndɨ mino ɓuwobi na ɓaɓɨɓya kakɨ, ʉtakanya ɓata ɓʉlalana aka kyɛ tɔtɔ a ndɨ nɨ ubeɗulini. ");
INSERT INTO lik_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Kʉwa wa, Yeso ʉsa ndɨ ɓata, ɨnda kalʉmba ka nganga ya yɨsaa. Malʉmba mi a ndɨ mʉɗɔngɔnɨ abɛ nɨmɔ ma mambwa aka. ");
INSERT INTO lik_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Kumbuso yi, igoku ndɨ kʉ ɓaɓɨɓya ɓa ndɨ mino, ʉɓɨkya ɓɛ: «Ambɛ, ma asɨ ka ɓatɔtɔ aka na kaimumbiso? Ngbingo itulyonini! Ɓiko kasʉta Mika-mʉmbanzʉ ka maɓɔkʉ ka ɓatʉ ɓanyɛ. ");
INSERT INTO lik_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Zuzukoni, togoni! Winoni, mʉtʉ yi nɨnɔ akɛgaba, osiliniku!» ");
INSERT INTO lik_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ngbingo yi nɨnɔ Yeso a mbɛyɨ ndɨ mina kanzɨna aka nɔ, ɓemoti luga ka ɓaɓɨɓya kakɨ tɛkɛɓɛ na ɓaɓa nɨnɔ ina ndɨ ɓɛ Yuda opuponoku. A ndɨ pa imoti na ambaza mudingi ka ɓambanzʉ. Ɓatʉ ɓi nɨɓɔ ɓa ndɨ na ɓadʉkpa na ɓɛngbɨngɨlɨ. Ɓokumu-kumu na ɓambɔkʉ-mbɔkʉ ka Ɓayuda ɓɔ ɓutikoku ndɨ. ");
INSERT INTO lik_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yuda nɨnɔ a ndɨ nɨ agobini Yeso, a ndɨ nɨ uɓikyini kambwa aka ɓɛyɔ agyo mino, ʉɓɨkya ɓɛ: «Alʉkʉ nɨnɔ napututo, iba ɨyɨ nɨnɔ. Mugwini!» ");
INSERT INTO lik_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Yuda akpuɗoku ndɨ Yeso ɓɨgala-gala, amuusa ɓɛ: «Muwonisilo! wanodokuuu!» Apututa kʉwa. ");
INSERT INTO lik_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ɨyɨ asikisya ndɨ ɓɛ: «Wai! Gyanɔ nɨlɔ woduku kagya.» Kʉwa wa, ɓatʉ ɓi nɨɓɔ ɓisisiloku ndɨ, ɓagwi. ");
INSERT INTO lik_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ɓemoti ka ɓaɓɨɓya ka Yeso anyɔ ndɨ dʉkpa kakɨ, ayipa mʉgya-ligubo ko kumu-kumu, akɔ kutiliko. ");
INSERT INTO lik_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Luki limoti, Yeso aɓɨkya ndɨ ɓɛ: «Wigisa dʉkpa kakʉ ka pa yi! A ɓɛyɔ, mʉtʉ wasɨ nɨnɔ abʉmanaga na dʉkpa, okwa ndɛkɛ dʉkpa gɔnɨ. ");
INSERT INTO lik_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ambɛ, wakɛgʉ kaiba ɓɛ nakwanana kakʉnga Baba kesingyo? Wa aka wa, etikilyoku kakɨtaga ɓambaza tɛkɛɓɛ na ɓaɓa ka ɓamalaika. ");
INSERT INTO lik_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Luki limoti, kutikoku ɓamalaika ɓɛyɔ, Moɓiso Motu akwanana kaɨtʉlyana lɨkɨ? A ɓɛyɔ, Moɓiso mi nɨmɔ akaɓɨkya ɓɛ masɨ okwononi kaigyonasa ɓɛyɔ aka yɔ.» ");
INSERT INTO lik_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Kʉwa wa, Yeso aɓɨkya ndɨ ɓambaza nɔ ɓɛ: «Moduku kegwi na ɓadʉkpa na ɓɛngbɨngɨlɨ abɛ nakika mʉtʉ wo kuɓakʉ? Nikaga ndɨ pa imoti na iɓunu masyɛ masɨ wakiko ka Ndaɓʉ ko Kunzi nɨ nanapá mʉtʉʉ, makegwigʉ ndɨ. ");
INSERT INTO lik_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Luki limoti, masɨ nɨmana akaigyonosa kyɛ ɨtʉlyanɨ ɓɛyɔ ɓogyalandʉ ɓokpikaga ndɨ mino.» Kʉwa wa, ɓaɓɨɓya ɓasɨ ɓasa ndɨ Yeso, ɓogwa mbangʉ. ");
INSERT INTO lik_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ɓambanzʉ nɨɓɔ ɓagwi ndɨ Yeso, ɓaga na ɨyɨ ka Kayafa nɨnɔ a ndɨ kumu-kumu. Ɓowonisilo ɓa mʉtʉʉ na ɓambɔkʉ-mbɔkʉ ɓa ndɨ ɓʉmʉmʉkana kʉ ɓɛyɔ. ");
INSERT INTO lik_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pɛtɛlɛ a ndɨ kaɓyɨɓya Yeso mina ɓyɨ kadwɛ kʉ kwa kʉ ka ndaɓʉ ko kumu-kumu. Ogulya ndɨ ka pa yangba, ikoku pa imoti na ɓazamʉ kaɨna ɓɛyɔ isilyoku mino. ");
INSERT INTO lik_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ɓokumu-kumu na ɓangama ɓagɔgɔ ɓasɨ ɓa Basa-Yidingi ɓa ndɨ kaʉkɨsa ɓadɛmʉ ɓa ɓɔngɔ, kyɛ ɓinisoni no pisi kamwisiso Yeso. ");
INSERT INTO lik_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Luki limoti, ɓakɨnagʉ ndɨ, gʉtʉgʉ ɓɛyɔ ɓatʉ ɓudingi ɓodogoku ndɨ mino kaɓʉkʉlyaga ɓɔngɔ. Ka muliɓo, ɓatʉ ɓaɓa ɓodoku ndɨ kaɓɨkya ɓɛ: ");
INSERT INTO lik_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","«Mʉtʉ yi nɨmʉ aɓɨkya ndɨ ɓɛ: ‹Nakwanana kapanza Ndaɓʉ ko Kunzi, kopika ɓata kumbusa wa masyɛ masaa.›» ");
INSERT INTO lik_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Kʉwa wa, kumu-kumu amaga ndɨ, amuusa Yeso ɓɛ: «Ambɛ, wakɛgʉ kosikisyo? Wakaɓɨkya ɓʉ ka ɓangbanga nɨɓana ɓambanzʉ ɓakaʉpɨ́lyaga ɓa?» ");
INSERT INTO lik_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Luki limoti, Yeso adaka ndɨ ɓiwo. Kumu-kumu aɓɨkya ɓata ndɨ ɓɛ: «Nakaumuuso ko lino ko Kunzi nɨnɔ a na ɔɓɨlɨ, tɨɓɨkya pisi ka silika, ɨwɛ nɨ Kilisito, Miko Kunzi?» ");
INSERT INTO lik_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yeso asikisya ndɨ ɓɛ: «Ɨwɛ mombukwana-dakɨ woɓikyini! Luki limoti, nakamʉɓɨkya ambɛ katʉkya mbɨya wanʉ, mamɨnatʉ Mika-mʉmbanzʉ wakiko ka kumbanzɨkanɨkɔ ko Kunzi nɨnɔ wo Ngu. Na mamɨnatʉ ndɛkɛ gɔnɨ nɨ anodoku ka ɓɛkʉɓa kʉgʉ wa lɨsyɛ.» ");
INSERT INTO lik_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Kʉwa wa, kumu-kumu yi nɨnɔ ɨnʉaga ndɨ ɓotu. Aɓɨkya ɓɛ: «Atumbwini Kunzi! Takɛgʉ ɓata na nzoyi ya ɓadɛmʉ. Mapʉnya kaʉkana ɓɛyɔ atumbwi mino. ");
INSERT INTO lik_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Makaɓɨkya ɓʉ?» Ɓasikisya ndɨ ɓɛ: «Okwononi ɓamwɨ!» ");
INSERT INTO lik_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Kʉwa wa, ɓaɓakyaga ndɨ Yeso na ɓotikito ko miso, ɓayipaga ɓangwasɨ. Ɓagɔgɔ ɓayipaga ndɨ ɓangwasɨ, ");
INSERT INTO lik_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ɓanaɓɨkya ɓɛ: «Kilisito! Ndʉnga pisi ka ɓugyalandʉ! Tɨɓɨkya, wanɨ nɔ uipi?» ");
INSERT INTO lik_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ko ngbingo yi nɨnɔ, Pɛtɛlɛ a ndɨ ɨyɨ wakiko kunzi ka pa yangba. Kʉwa wa, mʉgya-ligubo ɓemoti mʉsɨka yi akpuɗoku ndɨ, aɓɨkya ɓɛ: «Ɨwɛ, watʉ ndɨ gɔnɨ pa imoti na Yeso mʉtʉ wa Galilaya.» ");
INSERT INTO lik_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Luki limoti, Pɛtɛlɛ anganya ndɨ kambwa ka ɓatʉ ɓasɨ ɓɛ: «Ɨmɨ, nakibigʉ nɨlɔ wakapa kaɓɨkya.» ");
INSERT INTO lik_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Kumbuso yi, isisila ndɨ miso ya mupumi ma pa yangba. Mʉgya-ligubo mʉsɨka yi wagɔgɔ amɨna ndɨ, ʉɓɨkya ɓatʉ nɨɓɔ ɓa ndɨ wa ɓɛ: «Mʉtʉ yi nɨmʉna a ndɨ pa imoti na Yeso mʉtʉ wa Nazalɛtɨ.» ");
INSERT INTO lik_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pɛtɛlɛ anganya ɓata ndɨ, akɔ silika ɓɛ: «Ɨmɨ, nakamibigʉ mʉtʉ yi nɨmʉ!» ");
INSERT INTO lik_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Kumbusa yɨkɛɗɛ, ɓatʉ nɨɓɔ ɓa ndɨ wa ɓakpuɗoku ndɨ Pɛtɛlɛ, ɓaɓɨkya ɓɛ: «A ɓɛyɔ, wa gɔnɨ ɓemoti kaɓʉ. Gʉtʉgʉ mʉnzɨna kakʉ aka akowonisilo ɓɨnza ɓɛ wa Mugalilaya!» ");
INSERT INTO lik_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Pɛtɛlɛ akɔ ndɨ silika, aɓɨkya ɓɛ: «Nigyogyisi! Kika nɨ nakaɓɨkya ɓɔngɔ. Nakamibigʉ alʉkʉ yi nɨmʉ!» Wa aka wa, kɔkʉ alɨka ndɨ. ");
INSERT INTO lik_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Pɛtɛlɛ atamana mʉnzɨna nɨmɔ Yeso aɓɨkya ndɨ ɓɛ: «Kambwa kɔkʉ kaalɨka, wika nɨ wemongonyini nganga yɨsaa.» Kʉwa wa, opupa ndɨ kunzi, apʉnga ndɨ kagama no kumbu kʉgbɛ. ");
INSERT INTO lik_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Nɨyɔ lɨsyɛ asyɛ, ɓokumu-kumu na ɓambɔkʉ-mbɔkʉ ɓolikilya ndɨ dikiɗi kakɨsa kamwisiso Yeso. ");
INSERT INTO lik_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Kumbuso kakondisiso, ɓaga na ɨyɨ, ɓamomosa ndɨ ɓɨgbʉ kambwa ka ngama Pilatʉ nɨnɔ andaga ndɨ iwili ya Lʉma. ");
INSERT INTO lik_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Nɨyɔ Yuda nɨnɔ agaba ndɨ Yeso ʉkana ɓɛ ɓomosini mʉtʉʉ kamwɔ Yeso, apʉnga ndɨ kalya kumbu kʉgbɛ. Umigisya kʉwa ndɨ ɓokumu-kumu na ɓambɔkʉ-mbɔkʉ ɓambuma ɓatɛkɛɓɛ ɓasaa ɓaya ɓuyi. ");
INSERT INTO lik_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ʉɓɨkya ndɨ ɓɛ: «Nogyi ɓi ɓʉnyɛ koɗukusaga ɓangʉ ka mʉmbanzʉ yi nɨnɔ kɛgʉ ɓi na ɓʉnyɛ.» Luki limoti, ɨɓʉ ɓasikisya ndɨ ɓɛ: «Katindigʉ iɓusu. Undi ɨwɛ aka.» ");
INSERT INTO lik_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yuda ombimba ndɨ ɓuyi ɓi nɨɓɔ ka Ndaɓʉ ko Kunzi. Kumbuso yi, atʉkya ndɨ, aga kaibongiso. ");
INSERT INTO lik_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ɓokumu-kumu ɓapʉnaga ndɨ, ɓaɓɨkya ɓɛ: «Mʉtʉʉ kusu katɨkpamyagʉ ɓɛ tobisogi inguo yo ɓuyi ɓi nɨɓa ka kpokoyo ya ndaɓʉ ya malʉmba. A ɓɛyɔ, a mʉkalya ma ɓangʉ.» ");
INSERT INTO lik_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Kumbuso wa yʉkanana, ɓoluwa ndɨ no ɓuyi ɓi nɨɓɔ tiko ka maɓɔkʉ ka alʉkʉ ɓemoti nɨnɔ alʉkaga ndɨ ɓambɨkɛ. Ɓoluwa ndɨ tiko yi nɨyɔ ko bulya yilumbo mino ɓobiko. ");
INSERT INTO lik_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Kinili, kadwɛ na lɨsyɛ li nɨlɨ, tiko yi nɨyɔ ɓalɨkyaga ɓɛ «Tiko ya Ɓangu». ");
INSERT INTO lik_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Kʉwa wa, ɨtʉlyana nɨlɔ ɨɓɨkya ndɨ pisi ka mugyalandʉ Yelemia ɓɛ: «Ɓava ndɨ ɓambuma ɓatɛkɛɓɛ ɓasaa ɓaya ɓuyi. Lɨgabʉ li nɨlɔ Ɓezaleli ɓobisa ndɨ ko bulya kakɨ. ");
INSERT INTO lik_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ɓoluwa ndɨ no ɓuyi ɓi nɨɓɔ tiko ka maɓɔkʉ ka mʉlʉka ɓambɨkɛ mʉɗɔngɔnɨ ɓɛyɔ Mombukwono-dosu ɛɓɨkya ndɨ mino.» ");
INSERT INTO lik_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ɓɨnda kʉwa ndɨ na Yeso kambwa ka ngama wa iwili ɓɛyɔ ka Pilatʉ. Ɨyɨ Pilatʉ amuusa ndɨ ɓɛ: «Ɨwɛ nɨ ngama ka Ɓayuda?» Yeso asikisya ɓɛ: «Ɨwɛ nɔ woɓikyi.» ");
INSERT INTO lik_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Kumbuso yi, ɓokumu-kumu na ɓambɔkʉ-mbɔkʉ ɓasʉngʉlya ndɨ. Luki limoti, nɨ kosikisyigʉ. ");
INSERT INTO lik_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Kʉwa wa, Pilatʉ amuusa ndɨ ɓata ɓɛ: «Wakɛgʉ kaʉkana ɓangbanga ɓasɨ nɨɓana ɓakaʉpɨ́lyaga ɓa?» ");
INSERT INTO lik_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Luki limoti, Yeso kasikisyagʉ ndɨ ka lɨkpʉmʉka gʉtʉgʉ limoti aka. Lɨkpʉmʉka li nɨlɔ ambanga ndɨ ngama mudingi kʉgbɛ. ");
INSERT INTO lik_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ka yɨnga ya Pasɨka, ngama mudingi akʉlaga ndɨ mʉtʉ wa bɔlɔkɔ ɓemoti nɨmɔ ambaza ka ɓambanzʉ atwaga ndɨ. Ikaga ndɨ mʉtʉ yi nɨnɔ ambaza apaga ndɨ. ");
INSERT INTO lik_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ko ngbingo yi nɨnɔ, a ndɨ na mʉtʉ wa bɔlɔkɔ ɓemoti wakimibisikoso kʉgbɛ. Lino kakɨ ndɨ nɨ Balaba. ");
INSERT INTO lik_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Kʉwa wa, Pilatʉ umuusa ndɨ ɓambanzʉ nɨɓɔ ɓamʉmʉkana ndɨ wa ɓɛ: «Wanɨ nɔ makapa ɓɛ namʉkʉlyɨ luga ka Balaba ɨɓʉ na Yeso nɨnɔ ɓamakaga ɓɛ Kilisito?» ");
INSERT INTO lik_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Uusa ndɨ ɓɛyɔ kyɛ a ndɨ kaiba ɓɛ ɓasʉta ndɨ Yeso ko bulya imi aka. ");
INSERT INTO lik_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ngbingo nɨnɔ Pilatʉ a mbɛyɨ ndɨ mino wakiko aka kasombiso Yeso, mukakɨ atikilyoku ndɨ lɨyʉ ɓɛ: «Mʉtʉ yi nɨnɔ kɛgʉ na ɓʉnyɛ, wakimokyonitɔgʉ ka lɨkpʉmʉka kakɨ! A ɓɛyɔ, no biti yi nɨyɨ, nigyogyisi kʉgbɛ ko nziki ko bulya kakɨ.» ");
INSERT INTO lik_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Luki limoti, ɓokumu-kumu na ɓambɔkʉ-mbɔkʉ ka Ɓayuda ɓʉtɨwa ndɨ ɓambanzʉ ɓɛ ɓakʉlagɨ Balaba, ɓamwɔ Yeso. ");
INSERT INTO lik_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ngama umuusa ndɨ ɓɛ: «Luga ka ɓatʉ ɓaɓa ɓi nɨɓa, wanɨ nɔ makapa ɓɛ namʉkʉlyɨ?» Ɓasikisya ndɨ ɓɛ: «Balaba.» ");
INSERT INTO lik_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilatʉ umuusa ndɨ ɓata ɓɛ: «Nagya kʉwa ɨkɨ na Yeso nɨnɔ ɓamakaga ɓɛ Kilisito?» Ɓambanzʉ ɓasɨ ɓasikisya ndɨ ɓɛ: «Ɓabangɨlagɨ ka mʉsalaba!» ");
INSERT INTO lik_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilatʉ ɨgɨlya ɓata ɓɛ: «Ɓʉnyɛ tino sɛ ɓɔ agya ndɨ?» Luki limoti, ɓidukulaga ndɨ asɨ kapamɨkanaga aka na lɨyʉ lapʉ ɓɛ: «Ɓabangɨlagɨ ka mʉsalaba!» ");
INSERT INTO lik_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ngbingo yi nɨnɔ Pilatʉ ɨna ndɨ mino ɓɛ kakwananɨgʉ kagya ɓata luki na ɨpʉmbʉ akaisisilogo aka, atɨka ndɨ ɓɛ ɓoviku liɓo, ɨsʉkʉsa maɓɔkʉ kambwa kaɓʉ ɓasɨ. Aɓɨkya ndɨ ɓɛ: «Ɓangu ka mʉtʉ yi nɨmʉ koɗukogonitɔgʉ ko lina kamɨ. A kʉwa lɨkpʉmʉka kunu aka!» ");
INSERT INTO lik_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ɓatʉ ɓasɨ ɓosikisya ndɨ ɓɛ: «Ɓangʉ kakɨ aɗʉkagɨ ka mʉ kusu na ka ɓomikusu!» ");
INSERT INTO lik_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Kʉwa wa, Pilatʉ ʉkʉlya ndɨ Balaba. Atinisisa ndɨ Yeso pimbo. Kumbuso yi, ʉpá ndɨ kyɛ ɓabangɨlagɨ ka mʉsalaba. ");
INSERT INTO lik_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Kʉwa wa, ɓasʉda ɓaga ndɨ na Yeso ka ndaɓʉ ka ngama wa iwili. Kʉ ɓɛyɔ, ɓʉmʉmʉla ndɨ ɓasʉda ɓasɨ, ɓakungulo Yeso ɓikululu. ");
INSERT INTO lik_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ɓanyɔgɔ ndɨ ɓotu, ɓamokisya kanzʉ wangbʉ. ");
INSERT INTO lik_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ɓoɓungusyaga ndɨ ɓiwilili muligi nɨmɔ a ndɨ no mowo, ɓamokisya ka mʉ. Ɓagwisiso lɨgʉgʉ ka kʉɓɔkʉkɔ kwa kumbanzɨkanɨkɔ. Kumbuso yi, ɓoɓuna ndɨ moli kambwa kakɨ katɨba, ɓanaɓɨkya ɓɛ: «Ngama ka Ɓayuda, tumuusito!» ");
INSERT INTO lik_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ɓaɓakyaga ndɨ na ɓotikito. Ɓava kʉwa ndɨ lɨgʉgʉ li nɨlɔ ɓanatɨnaga nolu ka mʉ. ");
INSERT INTO lik_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Kumbuso katɨba ɓɛyɔ, ɓanyɔ ndɨ kanzʉ. Ɓamokisyo ɓata ɓotu kakɨ, ɓaga kʉwa ndɨ na ɨyɨ kabangɨlaga ka mʉsalaba. ");
INSERT INTO lik_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ngbingo yi nɨnɔ ɓasʉda ɓopupa ndɨ mina wa, ɓabangana na alʉkʉ ɓemoti nɨnɔ a ndɨ mʉtʉ wa Kulɛnɛ, ina ndɨ ɓɛ Simoni. Ɓabinikisa ndɨ na mapʉpʉ mʉsalaba ka Yeso. ");
INSERT INTO lik_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Nɨyɔ ɓosila ndɨ ka pa nɨyɔ ɓalɨkyaga ɓɛ Gɔlɔgɔta (isi yi nɨ: Pa ya Mukuwa ma mʉ), ");
INSERT INTO lik_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ɓapá ndɨ Yeso vinya mʉmatanaga no luki lozyo. Luki limoti, ngbingo yi nɨnɔ akɨngɨla ndɨ mino, akya komwo. ");
INSERT INTO lik_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Kʉwa wa, ɓabangɨlaga ndɨ ka mʉsalaba. Ɓatwa ndɨ lɨɓɛsɛ ko bulya yɨgbananaga ɓotu kakɨ. ");
INSERT INTO lik_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Kumbuso yi, ɓikanana ndɨ wa kaɓuulyogo. ");
INSERT INTO lik_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Na kʉgʉ wa mʉ kakɨ, ɓokpika ndɨ isi ya lɨkpʉmʉka nɨlɔ ɓasʉngʉlya ndɨ mina ɓɛ: «Alʉkʉ yi nɨmʉ nɨ Yeso, ngama ka Ɓayuda.» ");
INSERT INTO lik_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","A ndɨ na ɓatʉ ɓo kuɓakʉ ɓaɓa nɨɓɔ ɓʉbangɨlaga ndɨ gɔnɨ ka kpɔlɔ ka Yeso. Ɓemoti ka nakpangbala wa kʉmbanzɨkanɨkɔ, na wagɔgɔ ka kulekuke. ");
INSERT INTO lik_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ɓambanzʉ ɓi nɨɓɔ ɓa ndɨ kakɨtaga wa, ɓa ndɨ katʉmbwa Yeso, ɓanagbɨtya ɓamʉ, ");
INSERT INTO lik_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ɓanaɓɨkya ɓɛ: «Wa ndɨ kapa kapanza Ndaɓʉ ko Kunzi, wopika yagɔgɔ ka masyɛ masaa. Wihukusa nɛkɨ mombukwana-dakɨ yi, kika nɨ wa Miko Kunzi, syoku ka mʉsalaba!» ");
INSERT INTO lik_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ɓokumu-kumu, ɓowonisilo ɓa mʉtʉʉ pa imoti na ɓambɔkʉ-mbɔkʉ ɓa ndɨ gɔnɨ katɨba ɓɛgɛyɔ, ɓanaɓɨkya ɓɛ: ");
INSERT INTO lik_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«Uhukusa ndɨ ɓatʉ ɓagɔgɔ. Kakwananɨgʉ kaihukuso ɨyɨ mombukwana-dakɨ yi ɓɨkpɛ! A ngama ka Ɓezaleli. Osyikunɔ ka mʉsalaba, iɓusu, taɓɨnɨkyana kʉwa gɔnɨ! ");
INSERT INTO lik_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","A ɓɛyɔ, ɨgʉmya ndɨ ko Kunzi, aɓɨkya ndɨ ɓɛ a Miko Kunzi. Kika nɨ Kunzi apagatʉ, ahukusi nɛkɨ mbɨya wanʉ!» ");
INSERT INTO lik_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Gʉtʉgʉ ɓatʉ ɓo kuɓakʉ aka nɨɓɔ ɓʉbangɨlaga ndɨ ka kpɔlɔ ka Yeso, ɓa ndɨ katʉmbwa ɓɛgɛyɔ. ");
INSERT INTO lik_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Katʉkya ndɨ ka saa sita, biti ohuma ndɨ ɔɓɨlɨ wasɨ ka ɓasaa ɓayɨsaa. ");
INSERT INTO lik_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Nɨyɔ saa tisa a kʉwa ndɨ ɓuwobi kaɨtʉlyana, Yeso igomisa ndɨ na lɨyʉ lapʉ ɓɛ: «Eli, Eli, lama sabakatani?» Isi nɨ: «Hiii Kunzi! Hiii Kunzi! Ko bulya ɨkɨ yɔ wesi mino?» ");
INSERT INTO lik_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nɨyɔ ɓatʉ ɓemoti-ɓemoti luga ka nɨɓɔ ɓa ndɨ wa ɓamʉkana mino ɓɛyɔ, ɓaɓɨkya ndɨ ɓɛ: «Akamaka Ɨlɨya.» ");
INSERT INTO lik_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Wa aka wa, ɓemoti kaɓʉ apɨkɨta ndɨ, ovoku luki limoti ɓɨfʉɓʉ-fʉɓʉ, olubo ko vinya wa muzabibu wozyo. Kumbuso yi, abanga kʉwa ndɨ ka lɨgʉgʉ, apá Yeso ɓɛ omwi. ");
INSERT INTO lik_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Luki limoti, ɓagɔgɔ ɓaɓɨkya ndɨ ɓɛ: «Wosoni! Tinini mbɛyɨ ikanɨ Ɨlɨya odokuto kahukuso!» ");
INSERT INTO lik_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Luki limoti, Yeso igomisa ɓata ndɨ na lɨyʉ lapʉ. Osisa lɨmbɛngɨ. ");
INSERT INTO lik_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ko ngbingo yi nɨnɔ aka nɔ, kutuko nɨkwɔ ikaga ndɨ kubongiso kagbanana pa yotu na pa yotu kʉgbɛ kʉ ka Ndaɓʉ ko Kunzi kʉ, anʉɨka ndɨ luga katʉkya kʉgʉ kadwɛ kusili. Mugi ɨzʉkʉla ndɨ ɓingbuku-ngbuku, matamʉ makpʉkpʉ alɨkanaga ndɨ ɓɨkpakpakpa. ");
INSERT INTO lik_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Gʉtʉgʉ ɓambʉkʉ aka oukwikana ndɨ na ɓatʉ ɓudingi nɨɓɔ ɓokwaga ndɨ nɨ ɓaɓinikyonini Kunzi, ɓabɨlɨla ndɨ. ");
INSERT INTO lik_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ɓopupoku kʉwa ka ɓambʉkʉ. Kumbuso gɔnɨ Yeso kopupa ndɨ ka mbʉkʉ, ɓingya ka Yelusalɛma, gʉɗʉ wotu. Kʉ ɓɛyɔ, ɓupuponilya ndɨ ɓambanzʉ ɓudingi. ");
INSERT INTO lik_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Nɨyɔ ngama ka ɓasʉda ka Ɓalʉma pa imoti na ɓatʉ nɨɓɔ ɓa ndɨ na ɨɓʉ kaɓuulyaga Yeso ɓamɨna azigizo na masɨ nɨmɔ akɨtanaga ndɨ wa, ɓogwa ndɨ ombombo kʉgbɛ. Ɓaɓɨkya kʉwa ndɨ ɓɛ: «Ka lɨngʉnʉ, mʉtʉ yi nɨmʉ a ndɨ asɨ Miko Kunzi aka!» ");
INSERT INTO lik_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Wa gɔ wa, a ndɨ na ɓoko ɓudingi nɨɓɔ ɓa ndɨ kaɨna ka ɓʉɓyɨ nɨlɔ akɨtanaga ndɨ lɔ. Ɓotukyoku ndɨ pa imoti na Yeso ka Galilaya, kasingyo ka mogubo. ");
INSERT INTO lik_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Luga kaɓʉ, a mbɛyɨ ndɨ nɨ Malia mʉtʉ wa Magadala, Malia nɨnɔ aɓʉkʉta ndɨ Yakɔbɔ ɨɓʉ na Yɛzɛfʉ sɛ kʉwa amakɨ ɓomika Zɛbɛdayɔ. ");
INSERT INTO lik_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Nɨyɔ ɓʉgɔgɔ ɨtʉlyana, alʉkʉ ɓemoti wa lɨngama, mʉtʉ wa Alimatia nɨnɔ ina ɓɛ Yɛzɛfʉ, a ndɨ gɔnɨ ɨyɨ mʉɓɨɓya ka Yeso, osiloku ndɨ. ");
INSERT INTO lik_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ɨnda kʉwa ndɨ ka ngama mudingi wa iwili ɓɛyɔ ka Pilatʉ, akʉnga ɓɛ ɓapɨ́ nzʉyɨ ka Yeso. Pilatʉ akpamya ndɨ ɓɛ ɓapɨ́. ");
INSERT INTO lik_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yɛzɛfʉ ɨnda ndɨ kava. Akandaga na kutuko kwambɨya, ");
INSERT INTO lik_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","amongosa ndɨ ka mbʉkʉ yambɨya nɨyɔ ɨkpʉlya ndɨ ka lɨtalʉ. Kumbuso yi, adʉla ndɨ mupumi mi na lɨtalʉ lidingi, aga ndɨ. ");
INSERT INTO lik_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ko ngbingo yi nɨnɔ, Malia Magadala na Malia nɨnɔ wagɔgɔ ɓa ndɨ wa, ɓakikonono kambwa wa mbʉkʉ. ");
INSERT INTO lik_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ɓʉgala ɓi, akaɨɓɨkya ɓɛ lɨsyɛ li nɨlɔ a kambwa wa nɨlɔ la kiɓungusyogo ka Lɨsyɛ la kimumbiso, ɓokumu-kumu na Ɓafalisayɔ ɓaga ndɨ ka Pilatʉ. ");
INSERT INTO lik_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ɓaɓɨkya ndɨ ɓɛ: «Mombukwono-dosu! Totomonini ɓata ɓɛyɔ mʉtʉ waɓɔngɔ yi nɨmʉ aɓɨkya ndɨ mino ngbingo yi nɨnɔ a mbɛyɨ ndɨ mino muɓisi aka ɓɛ: ‹Kumbusa wa masyɛ masaa, nopupatʉ ka mbʉkʉ.› ");
INSERT INTO lik_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Yɛkɨ a ɓɛyɔ, pá nɛkɨ mʉtʉʉ ɓɛ ɓoɓuulyogi mbʉkʉ kadwɛ kʉ kwa kʉ masyɛ masaa ɨtʉlyano mino. Ɓaɓɨɓya kakɨ ɓakodonikuto kaɓiɓo, ɓaga kaʉɓɨkya ɓambanzʉ ɓɛ: ‹Opupini ɓi luga ka ɓamanda.› Mʉnzɨma ma mɨɓa mi nɨma ika ɓanʉ manyɛ kakɨtaga nɨmɔ ma mambwa.» ");
INSERT INTO lik_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilatʉ usikisya ndɨ ɓɛ: «Matʉ na ɓasʉda nɨɓɔ ɓokwononi koɓuulya mbʉkʉ. Wogoni, ɓoɓuulyogi mʉɗɔngɔnɨ ɓɛyɔ mini mino ɓɨnza.» ");
INSERT INTO lik_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ɓaga kʉwa ndɨ ka mbʉkʉ, ɓadʉla ndɨ miso ma mbʉkʉ na lɨtalʉ ɓingbufu, ɓubisa ndɨ ɓasʉda wa koɓuulyo. ");
INSERT INTO lik_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Nɨyɔ Lɨsyɛ la kimumbiso akɨtaga ndɨ, kʉwa na ɓʉgala ɓi ka lɨsyɛ la mambwa la pɔsɔ ko mbolugo, Malia nɨnɔ a ndɨ mʉtʉ wa gʉɗʉ wa Magadala pa imoti na Malia wagɔgɔ, ɓaga ndɨ kaanda mbʉkʉ. ");
INSERT INTO lik_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ko ngbingo ɓemoti, azigizo wapʉ apʉnga ndɨ. Malaika ka Mombukwono-dosu, osyoku ndɨ kotukyoku kʉgʉ wa lɨsyɛ, ɨnda ndɨ katɛ ka kpɔlɔ lɨtalʉ lidingi nɨlɔ otikya ndɨ mbʉkʉ, ika ndɨ kʉgʉ yi. ");
INSERT INTO lik_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","A ndɨ kanzɛ kʉgbɛ mʉɗɔngɔnɨ abɛ ngbangbata kangɨnana, ɓotu kakɨ a ndɨ ɓitu abɛ libu. ");
INSERT INTO lik_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ɓoɓuɓulya nɨɓɔ ɓa ndɨ koɓuulyaga mbʉkʉ ɓapʉnga ndɨ kagʉgʉma ɓikpwukpwukpwu na kʉɓangakʉ, kadwɛ kʉ kwa kʉ ɓɨɨta ndɨ mina abɛ ɓamanda. ");
INSERT INTO lik_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Luki limoti, malaika nɨnɔ ʉɓɨkya ndɨ ɓoko ɓi nɨɓɔ ɓɛ: «Makoɓongonitɔgʉ. Nakaiba ambɛ makakɨsa Yeso, nɨnɔ ɓabongilogi ɓi ka mʉsalaba. ");
INSERT INTO lik_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Kɛgʉ ɓata wanʉ! A bɛyɔ, opupini ɓi ka mbʉkʉ mʉɗɔngɔnɨ ɓɛyɔ aɓɨkya ndʉkʉ mino. Doniku, winoni kʉ o bi mino mumongoso. ");
INSERT INTO lik_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Windoni ɓɨgala kaʉɓɨkya ɓaɓɨɓya kakɨ ɓɛ: ‹Opupini ɓi luga ka ɓamanda. Matokonyoku ka Galilaya. Maminoku ɓanʉ kʉ ɓɛyɔ.› Nɨlɔ no ɓi ambɛ namʉɓɨkyɨ nɨlɔ.» ");
INSERT INTO lik_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ɓoko ɓaɓa ɓi nɨɓɔ ɓatʉkya ndɨ ɓɨgala-gala ka mbʉkʉ ɓotumini na kʉɓangakʉ ɓɨɗɛ na magyagya mudingi gɔnɨ. Ɓɨnda ndɨ mbangʉ kaʉtʉmbʉlyaga ɓaɓɨɓya ka Yeso mongoni mi nɨmɔ. ");
INSERT INTO lik_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ko ngbingo ɓemoti, Yeso ɓɨkpɛ abangana ndɨ na ɓoko ɓi nɨɓɔ, umuuso. Ɓakpuɗoku ndɨ, ɓavɨlaga magʉ na ɓabibiso. ");
INSERT INTO lik_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yeso ʉɓɨkya kʉwa ndɨ ɓɛ: «Makoɓongonitɔgʉ! Windoni kaʉɓɨkyaga ɓomika-mama ɓɛ ɓaga ka Galilaya. Ɓeminoku kʉ ɓɛyɔ.» ");
INSERT INTO lik_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ngbingo yi nɨnɔ ɓoko ɓi nɨɓɔ ɓa mbɛyɨ ndɨ mino ko pisɨ aka, ɓoɓuɓulyo ɓemoti-ɓemoti ɓa mbʉkʉ ɓatʉkya ndɨ, ɓaga ka gʉɗʉ. Kʉ ɓɛyɔ, ɓʉtʉmbʉlyaga ndɨ ɓokumu-kumu lasɨ nɨlɔ akɨtanaga ndɨ. ");
INSERT INTO lik_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Kʉwa wa, ɓokumu-kumu ɓi nɨɓɔ pa imoti na ɓambɔkʉ-mbɔkʉ ka Ɓayuda ɓagya ndɨ dikiɗi. Ɓʉkanana ndɨ kaʉpá ɓasʉda ɓi nɨɓɔ ɓuyi ɓudingi ɓɨpɛlɛ. ");
INSERT INTO lik_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ɓʉɓɨkya ndɨ ɓɛ: «Ɓikyoni ambɛ: ‹Ɓaɓɨɓya kakɨ ɓoduku ɓi no biti kaiɓo manda kakɨ ko ngbingo yi nɨnɔ to ɓi mino ka ɓatɔtɔ.› ");
INSERT INTO lik_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Kika nɨ mongoni asilyini ngama mudingi wa iwili, iɓusu ɓamombukwono-dosu ɓi ɓɔ tatʉmbʉlyaga mongoni mi nɨmɔ. Tagya yasɨ ambɛ iɓunu makogulyonitɔgʉ ka ɓukpwuku-kpwuku.» ");
INSERT INTO lik_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Kʉwa wa, ɓasʉda ɓi nɨɓɔ ɓava ndɨ ɓuyi na ɓagya mʉɗɔngɔnɨ ɓɛyɔ ɓʉkpamya ndɨ mino. Mongoni mi nɨmɔ ɨtʉlyana ndɨ luga ka Ɓayuda kadwɛ na lɨsyɛ li nɨlɨ. ");
INSERT INTO lik_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Kʉwa wa, ɓaɓɨɓya ɓi nɨɓɔ tɛkɛɓɛ na ɓemoti ɓaga ndɨ ka Galilaya, ka ngʉpa nɨyɔ Yeso ʉwanyaga ndɨ. ");
INSERT INTO lik_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ngbingo yi nɨnɔ ɓamɨna ndɨ mino, ɓabibiso. Luki limoti, ɓemoti-ɓemoti kaɓʉ ɓa ndɨ na ɓotumo. ");
INSERT INTO lik_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Kumbuso yi, Yeso ukpuɗoku ndɨ, ʉɓɨkya ɓɛ: «Ɓɛpóni ndɨ ngu yasɨ ya kʉgʉ wa lɨsyɛ na kʉnʉ ka ɔɓɨlɨ. ");
INSERT INTO lik_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Yɛkɨ a ɓɛyɔ, windoni ka ɓɛvananza ɓayasɨ, huyikosoni ɓiki ɓaɓɨɓya kamɨ. Huɓotisoni ko lino ka Baba, ko Miki na ka Lɨmbɛngɨ-Lotu. ");
INSERT INTO lik_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Huwonisiloni kaɓyɛ masɨ nɨmɔ namʉɓɨkyaga ndɨ. Wiboni ɓɨnza ambɛ na pa imoti na iɓunu ɓongbinga ɓasɨ kadwɛ ka muliɓo ma ɔɓɨlɨ.»");
INSERT INTO lik_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Mʉpʉnganagɨ ma Mongoni Manza ka Yeso-Kilisito, Miko Kunzi nɨma. ");
INSERT INTO lik_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Kʉsɔ wa kɨtaɓʉ ka mugyalandʉ Isaya, ikpikaga ɓɛ: «Ɨmɨ Kunzi, nakatɨka atʉtʉmbwa kamɨ kambwa kakʉ, kauɓungusilyo pisi. ");
INSERT INTO lik_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Mʉmbanzʉ ɓemoti akatʉɓɨlaga ka ɨsa ɓɛ: ‹Ɓungusyoni pisi ka Mombukwono-dosu, munonilyoni ɓopisi kakɨ ɓingbingbili!›» ");
INSERT INTO lik_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yuani-Mubatizaɨ opuponoku ndɨ ka ɨsa, anʉkʉwa ɓambanzʉ ɓɛ: «Yikosoni mambɛngɨ, miɓotisiso, Kunzi amʉpɨlya ɓʉnyɛ kunu.» ");
INSERT INTO lik_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ɓatʉ ɓasɨ ɓa iwili ya Yudɛa na ɓa gʉɗʉ wa Yelusalɛma ɓasilyogoku ndɨ Yuani-Mubatizaɨ. Ɓatʉ ɓi nɨɓɔ ɓatwaga ndɨ ɓʉnyɛ kaɓʉ ka pa yangba, Yuani anuɓotiso ka Yɔlɔdanɨ. ");
INSERT INTO lik_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yuani imokisyaga ndɨ kutuko kwo tukatʉ ta ngamia na mʉkaɓa ma sibokuso sa nyama ka ɨɗʉkʉfɨsɔ. Ʉlyaga ndɨ ɓanabʉnyɛnyɛ no nzuki nɨyɔ ikaga ko tutu. ");
INSERT INTO lik_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Akʉwaga ndɨ ɓɛ: «Mʉtʉ yi nɨnɔ akodoku kumbusa kamɨ, a no ngu kɛkɨtaga ɨmɨ. Nakakwananɨgʉ gʉtʉgʉ kodidiko, na kakʉlaga ligi ya ɓɛkpakʉ kakɨ. ");
INSERT INTO lik_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ɨmɨ, namuɓotisaga ɓi ko liɓo, luki limoti, ɨyɨ, amuɓotisaga ɓanʉ ka Lɨmbɛngɨ-Lotu.» ");
INSERT INTO lik_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ka masyɛ mi nɨmɔ, Yeso otukyoku ndɨ ka Nazalɛtɨ, ka iwili ya Galilaya adwɛ ka Yɔlɔdanɨ. Kʉ ɓɛyɔ, Yuani aɓotisa ndɨ. ");
INSERT INTO lik_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nɨyɔ aka yɔ Yeso opupoku ko liɓo, ɨna ndɨ lɨsyɛ koukwikono, Lɨmbɛngɨ-Lotu asilyoku ndɨ abɛ likpondi. ");
INSERT INTO lik_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Kʉwa wa, lɨyʉ otukyoku ndɨ kʉgʉ wa lɨsyɛ ɓɛ: «Ɨwɛ, wa mikamɨ mʉpaka, nogwaga na ɨwɛ magyagya kʉgbɛ.» ");
INSERT INTO lik_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Kumbuso yi, Lɨmbɛngɨ-Lotu akpamya ndɨ Yeso kaaga ka ɨsa. ");
INSERT INTO lik_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Kʉ ɓɛyɔ, agya ndɨ masyɛ ɓatɛkɛɓɛ ɓakwanganya nɨ abɨlɨ anaɓɔɓɔ. Ikaga ndɨ pa imoti na ɓanyama ɓo tutu, ɓamalaika ɓanagugubyo. ");
INSERT INTO lik_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Nɨyɔ ɓagwi Yuani-Mubatizaɨ, Yeso aga ndɨ ɨyɨ ka Galilaya. Kʉ ɓɛyɔ, a ndɨ kaɓɨkyaga Mongoni Manza ko Kunzi. ");
INSERT INTO lik_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Aɓɨkyaga ndɨ ɓɛ: «Ngbingo itulyonini. Ɓʉngama ko Kunzi a kʉwa ɓuwobi. Yikosoni mambɛngɨ, maɓɨnɨkyana Mongoni Manza!» ");
INSERT INTO lik_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yeso a ndɨ kakpakyana ka mutili ma ibombu yidingi ya Galilaya, ʉmɨna ndɨ ɓanyɔ-ɓosi ɓaɓa, Simoni ɨɓʉ na mamakɨ ɓɛyɔ ka Andɨlɨa nɨ ɓanolubo moyo. ");
INSERT INTO lik_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ʉɓɨkya ndɨ ɓɛ: «Iɓyeniku. Namuitisa kʉwa ɓanyɔ-ɓambanzʉ.» ");
INSERT INTO lik_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ko ngbingo yi nɨnɔ aka nɔ, ɓasa ndɨ moyo kaɓʉ, ɓapʉnga kaɓɨɓya. ");
INSERT INTO lik_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Nɨyɔ Yeso idukula ndɨ ɓata mina yɨkɛɗɛ ɓɛnɛ, ʉmɨna ndɨ ɓomika Zɛbɛdayɔ, Yakɔbɔ ɨɓʉ na mamakɨ ɓɛyɔ ka Yuani. Ɓa ndɨ ka ɨngbɔlɔ yidingi kaɓʉ nɨ ɓanoɓungusyogo moyo. ");
INSERT INTO lik_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ko ngbingo yi nɨnɔ aka nɔ, ʉmaka ndɨ. Ɓasa ndɨ abaɓʉ ka ɨngbɔlɔ pa imoti na ɓagya-ligubo kakɨ, ɓaga ndɨ ɨɓʉ kaɓɨɓya Yeso. ");
INSERT INTO lik_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yeso na ɓaɓɨɓya kakɨ ɓogulya ndɨ ka Kapɛlɛnaumu. Ka Lɨsyɛ la kimumbiso, Yeso ogulya ndɨ ka ndaɓʉ ya malʉmba ka Ɓayuda, apʉnga kapá mʉtʉʉ. ");
INSERT INTO lik_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Mʉtʉʉ kakɨ ʉmbanga ndɨ ɓambanzʉ nɨɓɔ ɓa ndɨ kamʉkana ɓɔ kʉgbɛ. A ɓɛyɔ, a ndɨ kapá mʉtʉʉ no ngu nɨ kɛgʉ abɛ ɓowonisilo ɓa mʉtʉʉ kaɓʉ. ");
INSERT INTO lik_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Kʉ kwa kʉ, ka ndaɓʉ ya malʉmba ka Ɓayuda kʉ, alʉkʉ ɓemoti ɓɛnɛ a ndɨ na lɨmbɛngɨ la ɓʉnyɛ. Alʉkʉ yi nɨnɔ apʉnga ndɨ kapamɨkanaga ɓɛ: ");
INSERT INTO lik_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«Hu! Yeso, mʉtʉ wa Nazalɛtɨ, lo kusu na iɓunu ogwogi ɓʉnɨ? Woduku katilumwisogo? Nakaumiba ɓɨnza! Ɨwɛ nɨ Mʉtʉ Wotu nɨnɔ Kunzi atikoku!» ");
INSERT INTO lik_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yeso apamɨlyaga ndɨ lɨmbɛngɨ la ɓʉnyɛ, aɓɨkya ɓɛ: «Daka! Pupa ka alʉkʉ yi nɨmʉ!» ");
INSERT INTO lik_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Lɨmbɛngɨ la ɓʉnyɛ nɨlɔ ayunga ndɨ alʉkʉ nɔ ɓɨnyɛ, opupa ndɨ ɓindeɗe nɨ apamɨkana ɓiliya-liya. ");
INSERT INTO lik_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Lɨkpʉmʉka nɨlɔ ʉpá ndɨ ɓambanzʉ ɓasɨ ombombo, ɓapʉnga ndɨ kauusana ɓɛ: «Lɨkpʉmʉka tina sɛ pɨyɛ lɨ? A mʉtʉʉ mambɨya, mutumo no ngu. Akapamɨlyaga gʉtʉgʉ mambɛngɨ ma ɓʉnyɛ aka, anamʉkana!» ");
INSERT INTO lik_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ko ngbinga mʉkɛɗɛ aka, mongoni ka Yeso awawa ndɨ ka iwili ya Galilaya yasɨ. ");
INSERT INTO lik_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Kʉwa wa, Yeso opupa ndɨ ka ndaɓʉ ya malʉmba ka Ɓayuda. Ɓa ndɨ na Yakɔbɔ ɨɓʉ na Yuani, ɓingya ndɨ ka Simoni na ka Andɨlɨa. ");
INSERT INTO lik_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Kʉ ɓɛyɔ, tɨtakɨ Simoni nɨnɔ muko yi a ndɨ wakanga, anɨmʉkana ɓʉdɨ. Nɨyɔ aka yɔ Yeso osila wa, ɓatʉmbʉlyaga ndɨ lɨkpʉmʉka nɨlɔ. ");
INSERT INTO lik_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yeso akpʉɗa, agwi kʉɓɔkʉkɔ, amomoso, muko yi nɨnɔ ahʉka ndɨ. Kumbuso yi, apʉnga ndɨ kaugugubyo. ");
INSERT INTO lik_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Na ɓʉgɔgɔ, nɨyɔ mɔnɨ ogwo, ɓadulyoku ndɨ Yeso na ɓatʉ ɓasɨ nɨɓɔ ɓa ndɨ na ɓokoloɓu na nɨɓɔ ɓa ndɨ na mambɛngɨ ma ɓʉnyɛ. ");
INSERT INTO lik_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ɓambanzʉ ɓasɨ ɓa gʉɗʉ ɓa ndɨ ɓʉmʉmʉkana ko misa ma mupumi ma ndaɓʉ wa. ");
INSERT INTO lik_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yeso uhukusa ndɨ ɓambanzʉ ɓudingi nɨɓɔ ɓa ndɨ kaigyogyiso na ɓokoloɓu dididi, okpumya ndɨ gɔnɨ mambɛngɨ ma ɓʉnyɛ mudingi. Apakya ndɨ mambɛngɨ ma ɓʉnyɛ kanzɨna, kyɛ mambɛngɨ ma ɓʉnyɛ nɨmɔ a ndɨ kamiba ɓɨnza. ");
INSERT INTO lik_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ko mbolugo, Yeso ozuzuka ndɨ, opupa kunzi. Ɨnda kʉwa ndɨ kunzi wa gʉɗʉ ka pa yi nɨyɔ mʉmbanzʉ kɛgʉ ndɨ mino. Kʉ ɓɛyɔ, apʉnga ndɨ kalʉmba. ");
INSERT INTO lik_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simoni na ɓawai-dakɨ ɓɨnda ndɨ kakɨsa. ");
INSERT INTO lik_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Nɨyɔ ɓamɨna, ɓaɓɨkya ɓɛ: «Ɓatʉ ɓasɨ ɓakaʉkɨsa yi.» ");
INSERT INTO lik_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Luki limoti, Yeso usikisya ndɨ ɓɛ: «Togoni ka ɓapa ɓayagɔgɔ, ko giyo nɨyɨna ɓuwobi-ɓuwobi wanʉ. Kʉ ɓɛyɔ, nakwanana gɔnɨ kaɓɨkyaga Mongoni Manza. A ɓɛyɔ, nɨlɔ nodulyoku ndɨ yɨpɛpɛ nɨlɔ.» ");
INSERT INTO lik_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Kʉwa wa, Yeso alingya ndɨ Galilaya wasɨ, anaɓɨkyaga Mongoni Manza ka ɓandaɓʉ ɓaya malʉmba ka Ɓayuda, anokpumya mambɛngɨ ma ɓʉnyɛ. ");
INSERT INTO lik_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Lɨsyɛ limoti, keɓu-keɓu ɓemoti asilyoku ndɨ Yeso, ogwo no moli kambwa kakɨ, ɨtatanaga na ɨyɨ ɓɛ: «Kikiliki, wakapa, wakwanana ɓaka kengumoso.» ");
INSERT INTO lik_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yeso akwilya ndɨ kumbu, anana ndɨ kʉɓɔkʉkɔ, avɨla, aɓɨkya ɓɛ: «Noboilyini, ngʉmana!» ");
INSERT INTO lik_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ko ngbingo yi nɨnɔ aka nɔ, keɓu-keɓu asya ndɨ, angʉmana ɓɨngɔ. ");
INSERT INTO lik_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Wa aka wa, Yeso anzɨnɨlya ndɨ na ɗɨya, kumbuso yi, apupisa ndɨ, anaɓɨkya ɓɛ: ");
INSERT INTO lik_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","«Wɨmɨnyatʉ! Wakatumbulyogonitɔgʉ mʉmbanzʉ. Luki limoti, wɨnda kaimoniso ko kumu. Kumbuso yi, wapá apɛpɛ mʉɗɔngɔnɨ ɓɛyɔ Mʉtʉʉ ka Musa aɓɨkyago mino, iba mʉtʉ wasɨ ibi ɓɛ woukini ɓi.» ");
INSERT INTO lik_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Luki limoti, nɨyɔ aka yɔ alʉkʉ nɔ aga, apʉnga ndɨ kopoɓo na kowowiso lɨkpʉmʉka li nɨlɔ. Kinili, Yeso kipupisogigʉ ndɨ ɓata ɓɨngbanganya ko misa ka ɓambanzʉ ka gʉɗʉ. Ikaga kʉwa ndɨ kunzi aka, ka ɓapa nɨɓayɔ ɓambanzʉ ɓakikogigʉ ndɨ mino. Kʉ ɓɛyɔ, ɓambanzʉ ɓadulyogoku ndɨ kotukyoku ka ɓapa ɓayasɨ. ");
INSERT INTO lik_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Kumbusa wa masyɛ makɛɗɛ, Yeso igoku ndɨ ka Kapɛlɛnaumu. Ɓambanzʉ ɓʉkana ndɨ ɓɛ a ka ndaɓʉ. ");
INSERT INTO lik_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ɓamʉmʉkana kʉwa ndɨ kʉ ɓudingi, kadwɛ kʉ kwa kʉ mikya pa kotigalagʉ ɓata ndɨ mino, iki gʉtʉgʉ ya kunzi aka ikanɨ ko misa ma mupumi. Yeso a ndɨ kaʉɓɨkyaga Lɨkpʉmʉka ko Kunzi. ");
INSERT INTO lik_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Kʉwa wa, ɓatʉ ɓakwanganya ɓadulyoku ndɨ Yeso na zɛgɛsɨ mʉbɨnɨka. ");
INSERT INTO lik_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Luki limoti, ɓakakwananagʉ ndɨ kasiliso kambwa ka Yeso ko bulya ambaza ka ɓambanzʉ. Ɓoukwilya kʉwa ndɨ ngala kugbondo tili na pa nɨyɔ Yeso a ndɨ mino. Kumbuso yi, ɓasisa kʉwa ndɨ zɛgɛsɨ nɔ kʉgʉ wa kalagba nɨyɔ a ndɨ mino wakanga pisi ka ngala yi nɨyɔ. ");
INSERT INTO lik_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Nɨyɔ Yeso ɨna baya kaɓʉ ɓɛyɔ, aɓɨkya ndɨ zɛgɛsɨ nɔ ɓɛ: «Mikamɨ, nupilyini ɓʉnyɛ kakʉ.» ");
INSERT INTO lik_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ɓowonisilo ɓa mʉtʉʉ ɓemoti-ɓemoti nɨɓɔ ɓa ndɨ ɓakikonono wa, ɓapʉnga ndɨ kaimuusa ɓɛ: ");
INSERT INTO lik_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Ko bulya ɨkɨ yɔ alʉkʉ yi nɨmʉna o mino kanzɨna ɓɛyɔ? Akatʉmbwa Kunzi! Wanɨ nɔ akwanana kapɨlya ɓʉnyɛ, kiki Kunzi aka yɨkaka?» ");
INSERT INTO lik_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ko ngbingo yi nɨnɔ aka nɔ Yeso andʉnga ndɨ tamanaga kaɓʉ, umuusa ɓɛ: «Ko bulya ɨkɨ yɔ mo mino na inguo ya tamanaga yi nɨyɔ? ");
INSERT INTO lik_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ɨkɨ yɔ a yopoli kʉgbɛ kaɓɨkya zɛgɛsɨ ɓɛ: ‹Nupilyini ɓʉnyɛ kakʉ›, ikanɨ kaɓɨkya ɓɛ: ‹Wamaga, wava kalagba kakʉ, wakpakyana?› ");
INSERT INTO lik_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Luki limoti, nakapa ambɛ wiboni ɓɛ Mika-mʉmbanzʉ a no ngu yɨpɨlya ɓʉnyɛ ka ɔɓɨlɨ.» Kʉwa wa, aɓɨkya ndɨ zɛgɛsɨ nɔ ɓɛ: ");
INSERT INTO lik_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«Nakaʉɓɨkya ambɛ, wamaga, wava kalagba kakʉ, wɨga kʉ kakʉ!» ");
INSERT INTO lik_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Wa aka wa, alʉkʉ nɔ aka ndɨ ɓɨvanga ko misa ka ɓatʉ ɓasɨ wa, ava kalagba kakɨ, ɨga. Nɔkʉ ʉdɨka ndɨ ɨɓʉ ɓasɨ ɓɨdɛ, ɓapʉnga ndɨ kabibiso Kunzi, ɓanaɓɨkya ɓɛ: «Takaninigʉ ndɨ inguo ya lɨkpʉmʉka li nɨlɨ!» ");
INSERT INTO lik_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Kʉwa wa, Yeso ɨga ɓata ndɨ ka mutili ma ibombu yidingi ya Galilaya. Ambaza ka ɓambanzʉ wasɨ asingyoku ndɨ, apʉnga kaʉpá mʉtɨwɨ. ");
INSERT INTO lik_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Wa a ndɨ mina kakɨtaga wa, amɨna Lawi, mika Alʉfayɔ, wakika ka bilo yilipiso manzanza. Yeso aɓɨkya ndɨ ɓɛ: «Iɓyeku!» Lawi amaga ndɨ, apʉnga kaɓɨɓya. ");
INSERT INTO lik_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Kumbuso yi, Yeso ɨnda ndɨ kalyalya kʉ ka Lawi. Ɓa ndɨ pa imoti na ɓaɓɨɓya kakɨ, ɓandɔmbɛ ɓa manzanza ɓakpʉ na ɓatʉ ɓagɔgɔ ɓudingi nɨɓɔ ɓʉmɨnaga ndɨ abɛ ɓagya-manyɛ. A ɓɛyɔ, ɓudingi ɓa inguo ya ɓatʉ ɓi nɨɓɔ ɓikaga ndɨ kaɓɨɓya ɓingbooo. ");
INSERT INTO lik_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Nɨyɔ ɓowonisilo ɓa mʉtʉʉ nɨɓɔ ɓikaga ndɨ na Ɓafalisayɔ ɓamɨna ndɨ mino Yeso kalyalya pa imoti na ɓandɔmbɛ na ɓagya-manyɛ, ɓumuusa kʉwa ndɨ ɓaɓɨɓya kakɨ ɓɛ: «Ko bulya ɨkɨ yɔ o mina kalyalya pa imoti na ɓandɔmbɛ ɓa manzanza na ɓagya-manyɛ?» ");
INSERT INTO lik_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Nɨyɔ Yeso ʉmʉkana ndɨ ɓɛyɔ, ʉɓɨkya ɓɛ: «Ɓatʉ ɓapʉpʉ ɓakakɨsagɨgʉ mʉnganga, luki limoti, nɨɓɔ aka ɓɔ ɓa ɓokoloɓu. Nakodokugʉ kaʉkɨsa ɓatʉ ɓongbingbili, luki limoti, nɨɓɔ ɓanyɛ.» ");
INSERT INTO lik_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Lɨsyɛ limoti, ɓaɓɨɓya ka Yuani-Mubatizaɨ na Ɓafalisayɔ ɓa ndɨ koginya malɨlɨ ko ngbingo. Kʉwa wa, ɓambanzʉ ɓodoku ndɨ kamuusa Yeso ɓɛ: «Ko bulya ɨkɨ yɔ ɓaɓɨɓya ka Yuani na nɨɓɔ ka Ɓafalisayɔ aka ɓɔ ɓoginyaga ɨɓʉ malɨlɨ ko ngbingo, nɨ nɨɓɔ kakʉ ɓakɛgʉ sɛ ɨɓʉ koginyo?» ");
INSERT INTO lik_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yeso usikisya ndɨ ɓɛ: «Makasɨma ɓɛ ɓawai-dakɨ mombukwono dumo wo vononi ɓakwananatʉ koginya malɨlɨ ngbingo yi nɨnɔ ɓa mbɛyɨ mino pa imoti na mbʉnya muko? Kigyonosigʉ! Ngbingo yi nɨnɔ mbʉnya muko o mino pa imoti na ɨɓʉ aka, ɓakakwananɨgʉ koginyo malɨlɨ. ");
INSERT INTO lik_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Luki limoti, ikatʉ ndɛkɛ na lɨsyɛ nɨlɔ ɓatʉmba mino mbʉnya muko luga kaɓʉ. Ka lɨsyɛ li nɨlɔ, ɓoginyatʉ kʉwa ndɛkɛ malɨlɨ ko ngbingo. ");
INSERT INTO lik_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Mʉmbanzʉ gʉtʉgʉ ɓemoti aka koɗikogigʉ ɨnzanza na panga ya kutuko kwambɨya. Kagya ɓɛyɔ, panga yambɨya yi nɨyɔ anʉwatʉ ɨnzanza, ngala ahʉmana ɓata kʉgbɛ. ");
INSERT INTO lik_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Na ɓata, mʉmbanzʉ gʉtʉgʉ ɓemoti aka kaɓʉngwagɨgʉ vinya wambɨya ka ɓambɨkɛ ɓayo bokuto ta ɓamanya ɓayɨgbangbalaga. Kagya ɓɛyɔ, vinya opumukisagatʉ ɓambɨkɛ, ɓambɨkɛ ʉlɨkaga, vinya agbɔ wasɨ. Kinili, okwononi kaɓʉngwa vinya wambɨya ka ɓambɨkɛ ɓayambɨya gɔnɨ.» ");
INSERT INTO lik_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ka Lɨsyɛ la kimumbiso limoti ɓɛnɛ, Yeso a ndɨ kakɨtaga ka ɓotiko ɓaya nganʉ. Ɓaɓɨɓya kakɨ ɓapʉnga ndɨ katɨnaga ɓɛkaza ɓi na lɨgʉndʉ. ");
INSERT INTO lik_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Kʉwa wa, Ɓafalisayɔ ɓamuusa ndɨ Yeso ɓɛ: «Wɨna! Ko bulya ɨkɨ yɔ ɓaɓɨɓya kakʉ ɓakagya nɨlɔ ɓapakya ka Lɨsyɛ la kimumbiso?» ");
INSERT INTO lik_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yeso usikisya ndɨ ɓɛ: «Makonotongulogigʉ ndɨ iɓunu lɨkpʉmʉka nɨlɔ ngama Daudi agya ndɨ wa a ndɨ mina na yangya pa imoti na ɓatʉ ɓi nɨɓɔ ɓa ndɨ na ɨɓʉ, na ɓɨmʉkana ndɨ nza? ");
INSERT INTO lik_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ogulya ndɨ ka Ndaɓʉ ko Kunzi, alya mukati nɨmɔ ɓapága ndɨ Kunzi, ʉpága ndɨ gɔnɨ ɓatʉ ɓi nɨɓɔ. Likpʉmʉka li nɨlɔ igyonosa ndɨ ko ngbingo ko kumu-kumu Abiatali. Luki limoti, mʉtʉʉ aɓɨkyaga ndɨ ɓɛ ɓokumu aka ɓɔ ɓakwanana ndɨ kalya mukati mi nɨmɔ.» ");
INSERT INTO lik_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yeso opipiloku kʉwa ndɨ ɓɛ: «Kunzi agya ndɨ Lɨsyɛ la kimumbiso ko bulya ka ɓambanzʉ, luki limoti, kʉgyagʉ ndɨ ɓambanzʉ ko bulya Lɨsyɛ la kimumbiso. ");
INSERT INTO lik_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Kinili, Mika-mʉmbanzʉ a gɔnɨ ngama gʉtʉgʉ ka Lɨsyɛ la kimumbiso aka.» ");
INSERT INTO lik_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Kʉwa wa, Yeso ogulya ɓata ndɨ ka ndaɓʉ ya malʉmba ka Ɓayuda. Alʉkʉ ɓemoti a ndɨ kʉ ɓɛyɔ na kʉɓɔkʉkɔ kukwo. ");
INSERT INTO lik_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ɓatʉ nɨɓɔ ɓa ndɨ kʉ ɓɛyɔ, ɓapʉnga ndɨ kanda Yeso ɓɨngbangbangba, ikanɨ ahukusatʉ mʉtʉ yi nɨnɔ ka Lɨsyɛ la kimumbiso. A ɓɛyɔ, ɓa ndɨ kakɨsa ɓɛ ɓamɨna na ɨɓɔ no pisi tino, kyɛ ɓasʉngɨlyɨ. ");
INSERT INTO lik_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yeso aɓɨkya kʉwa ndɨ mʉtʉ yi nɨnɔ ɓɛ: «Wamaga luga ka ɓambanzʉ ɓasɨ kʉʉ.» ");
INSERT INTO lik_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Kʉwa wa, Yeso umuusa ndɨ ɓɛ: «Mʉtʉʉ atɨɓɨkya pɨyɛ ɓɛ okwononi kagya ɓʉnɨ ka Lɨsyɛ la kimumbiso? Okwononi kagya lɨkpʉmʉka lanza, ikanɨ kagya nɨlɔ lanyɛ? Kahukuso ɔɓɨlɨ ka mʉmbanzʉ, ikanɨ kamwɔ?» Luki limoti, ɓadakyana ndɨ ɓiwo. ");
INSERT INTO lik_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yeso ʉnda ndɨ ɨɓʉ ɓasɨ ɓɨngbangbangba, kanɨ anʉmɨnyɨlya kumbu ko bulya mʉ mapʉ kaɓʉ. Aɓɨkya kʉwa ndɨ alʉkʉ nɔ ɓɛ: «Nana kʉɓɔkʉkɔ.» Anana ndɨ, kʉɓɔkʉkɔ ahʉka ɓɛyɔ aka yɔ ikaga ndɨ mino ");
INSERT INTO lik_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Nɨyɔ aka yɔ Ɓafalisayɔ ɓopupa ndɨ ka ndaɓʉ ya malʉmba, ɓamʉmʉkana ko dikiɗɨ ɓɨgala na ɓatʉ ɓa liɗu ka ngama Ɛlɔdɨ kakɨsa pisi tina yɔ ɓamwisiso mina Yeso. ");
INSERT INTO lik_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Kumbuso yi, Yeso ɓakɨɗa ndɨ na ɓaɓɨɓya kakɨ misa ya mutili ma ibombu ya Galilaya, nɨ ambaza mudingi ka ɓambanzʉ anaɓɨɓya ɓingbooo. Ɓatʉ ɓi nɨɓɔ ɓotukyoku ndɨ ka Galilaya, ka Yudɛa, ");
INSERT INTO lik_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ka Yelusalɛma, ka iwili ya Idumeya, ka iwili nɨyɔ kʉsyakʉ wa Yɔlɔdanɨ na ka ɓewili nɨɓayɔ ɓuwobi-ɓuwobi na gʉɗʉ wa Tilo na Sidɔna. Ambaza yi nɨnɔ asilyoku ndɨ Yeso, kyɛ ʉkana ndɨ mongoni ma masɨ nɨmɔ a ndɨ kagya. ");
INSERT INTO lik_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Nɨyɔ ɨna ɓɛyɔ, ʉɓɨkya kʉwa ndɨ ɓaɓɨɓya kakɨ ɓɛ ɓaɓungusyilyogi ɨngbɔlɔ, kyɛ ambaza kamotosyonitɔgʉ. ");
INSERT INTO lik_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Yɛkɨ a ndɨ kauhukuso ɓambanzʉ ɓakpʉ, ɓatʉ ɓasɨ ɓa ɓokoloɓu ɓa ndɨ kaiɗuso ɓɛ ɓavɨlɨ. ");
INSERT INTO lik_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Nɨyɔ ɓatʉ ɓa mambɛngɨ ma ɓʉnyɛ ɓamɨnaga ndɨ Yeso, ɓogwaga ndɨ kambwa kakɨ, ɓanapamɨkanaga ɓɛ: «Ɨwɛ nɨ miko Kunzi!» ");
INSERT INTO lik_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Luki limoti, Yeso ʉgbɨtyaga ndɨ ɓɨkpɔkpɔkpɔ ɓɛ ɓakanyonitɔgʉ mʉgɔngʉ kunzi. ");
INSERT INTO lik_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Kʉwa wa, Yeso aɗaka ndɨ ka ngʉpa, ʉmakaga ɓatʉ ɓi nɨɓɔ a ndɨ na nza yi kaɓʉ, ɓakpuɗoku ndɨ. ");
INSERT INTO lik_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ʉpʉnaga ndɨ tɛkɛɓɛ na ɓaɓa luga kaɓʉ, ʉlʉka kʉwa ndɨ ɓɛ ɓatʉtʉmbwa. Agya ndɨ ɓɛyɔ kyɛ ɓikogi pa imoti na ɨɓʉ, iki kaʉtɨkaga kaɓɨkyaga Mongoni Manza, ");
INSERT INTO lik_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ʉpá ndɨ gɔnɨ ngu yikpumyo mambɛngɨ ma ɓʉnyɛ. ");
INSERT INTO lik_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Mino ka ɓatʉ tɛkɛɓɛ na ɓaɓa ɓi nɨɓɔ nɨma: Simoni, nɨnɔ Yeso alʉka ndɨ gɔnɨ ɓɛ Pɛtɛlɛ, ");
INSERT INTO lik_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakɔbɔ na mamakɨ ɓɛyɔ ka Yuani. Ɨɓʉ ɓasɨ ɓaɓa ɓa ndɨ ɓomika Zɛbɛdayɔ: Yeso ʉlʉka ndɨ ɓɛ Boanɛlɨgɛ, isi yi nɨ «Ɓomika ngbangbata». ");
INSERT INTO lik_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andɨlɨa, Filipi, Batulumei, Matayɔ, Tʉma, Yakɔbɔ mika Alʉfayɔ, Tadei, Simoni nɨnɔ akɨsaga ndɨ kʉlɨkanaga ya lɨvananza kakɨ, ");
INSERT INTO lik_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","sɛ kʉwa Yuda Isikalioti, nɨnɔ agaba ndɨ Yeso. ");
INSERT INTO lik_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Kumbuso yi, Yeso igoku ndɨ ka mʉsɛngɨ. Ambaza mudingi ka ɓambanzʉ omumukonoku ndɨ ɓata. Yeso na ɓaɓɨɓya kakɨ ɓakɛgʉ ɓata ndɨ no ngbingo gʉtʉgʉ nɨnɔ mʉlyalya aka. ");
INSERT INTO lik_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Nɨyɔ ɓava-kʉkakɨ ɓʉkana ɓɛyɔ, ɓotukyoku ndɨ, ɓɨnda kava. A ɓɛyɔ, ɓa ndɨ kaɓɨkya ɓɛ: «Mʉ kakɨ kɛgʉ ɓata tili!» ");
INSERT INTO lik_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Lɨsyɛ limoti, ɓowonisilo ɓa mʉtʉʉ nɨɓɔ ɓodoku ndɨ kotukyoku ka Yelusalɛma, ɓaɓɨkya ndɨ ɓɛ: «Yeso a na Abɨlɨ kʉsɔ kakɨ nɨnɔ ina ɓɛ Belizebuli. Abɨlɨ yi nɨnɔ a ngama wa mambɛngɨ ma ɓʉnyɛ. Ɨyɨ nɔ akapá ngu yikpumyo mambɛngɨ ma ɓʉnyɛ!» ");
INSERT INTO lik_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Kʉwa wa, Yeso ʉmaka ndɨ, ʉtʉlya mozuni mi nɨma: «Igyonosa lɨkɨ Abɨlɨ kayikpumyo ɨyɨ mombukwana-dakɨ yi? ");
INSERT INTO lik_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Lɨvananza la ɓʉngama ɓumoti kapʉnga kabʉmana luga yi, iba ɓʉngama ɓi nɨɓɔ osyini. ");
INSERT INTO lik_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ɓatʉ ɓa lɨvananza limoti ɓakapʉnga kaʉlanana luga kaɓʉ, iba lɨvananza li nɨlɔ oponzikonini. ");
INSERT INTO lik_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kika nɛkɨ nɨ Abɨlɨ akabʉmana na ɨyɨ mombukwana-dakɨ yi ɓɨkpɛ, kɨgbananaga, ngu kakɨ kakwananɨgʉ kaidukulogo. Luki limoti, iko muliɓo mi. ");
INSERT INTO lik_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Gʉtʉgʉ mʉtʉ ɓemoti aka kakwananɨgʉ kaingyo ka ndaɓʉ ko tutungyo katʉpa lɨngama kakɨ nɨ kanagwigʉ mbɛyɨ, akanda. ");
INSERT INTO lik_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","A lɨngʉnʉ, nakamʉɓɨkya ambɛ: Kunzi ʉpɨlyatʉ ndɛkɛ ɓambanzʉ ɓʉnyɛ, na mosikoni masɨ nɨmɔ ɓasɨkaga. ");
INSERT INTO lik_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Luki limoti, mʉmbanzʉ kasɨkaga Lɨmbɛngɨ-Lotu, kikigʉ ndɛkɛ na mʉpɨlya gʉtʉgʉ ikii aka, kyɛ ɓʉnyɛ ɓi nɨɓɔ ika wa aka wa kadwɛ ka ɓɛnzɛ na ɓɛnzɛ.» ");
INSERT INTO lik_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yeso a ndɨ kaʉnzɨnɨlya ɓowonisilo ɓa mʉtʉʉ ɓɛyɔ, kyɛ ɓaɓɨkya ndɨ ɓɛ: «A na lɨmbɛngɨ la ɓʉnyɛ.» ");
INSERT INTO lik_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Kʉwa wa, amakɨ na ɓamamakɨ Yeso ɓodoku ndɨ. Ɓamaga ndɨ kunzi, ɓatɨka mʉtʉ ɓemoti kamaka. ");
INSERT INTO lik_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ambaza ka ɓambanzʉ a ndɨ wakiko, akungulini Yeso ɓikululu, ɓaɓɨkya kʉwa ndɨ ɓɛ: «Amakʉ na ɓamamakʉ ɓa kunzi kʉ, ɓakaʉkɨsa.» ");
INSERT INTO lik_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yeso usikisya ndɨ ɓɛ: «Mama nɨ wanɨ? Ɓomika-mama nɨ ɓa ɨkɨ?» ");
INSERT INTO lik_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Kumbuso yi, ʉnda ndɨ ɓatʉ nɨɓɔ ɓa ndɨ nɨ ɓakungulini wa ɓizumuuu, aɓɨkya ndɨ ɓɛ: «Mama na ɓomika-mama, nɨɓa. ");
INSERT INTO lik_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","A ɓɛyɔ, ɓomika-mama na mama, nɨ mʉtʉ wasɨ nɨnɔ agyaga sɨpananɨsɔ ko Kunzi.» ");
INSERT INTO lik_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yeso apʉnga ɓata ndɨ kapá mʉtɨwɨ nɨ a ka kpɔlɔ-kpɔlɔ wa ibombu ya Galilaya. Ambaza mudingi kʉgbɛ ka ɓambanzʉ asingyoku ndɨ. Kʉwa wa, aɗaka ndɨ ka ɨngbɔlɔ yidingi, iko. Ɨngbɔlɔ yi a ndɨ ka lɨmbɛngɨ lo liɓo, na ɓambanzʉ ɓa ndɨ kubi, ɓuwobi no liɓo. ");
INSERT INTO lik_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Yeso apʉnga ndɨ kauwonisilo makpʉmʉka makpʉ pisi ka mozuni. Kʉsɔ wa mʉtɨwɨ kakɨ, a ndɨ kaʉɓɨkya ɓɛ: ");
INSERT INTO lik_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Hukononi! Mʉtʉ ɓemoti ɨnda ndɨ kakʉna mʉpʉnga ko tiko. ");
INSERT INTO lik_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Nɨyɔ a ndɨ kakʉna ɓɛyɔ, bumo yi yagɔgɔ anyʉkaga ko pisi. Ɓombu ɓodoku ndɨ, ɓalya. ");
INSERT INTO lik_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Masɔlɔ magɔgɔ anyʉkaga ndɨ ka pa ya ngyengye nɨyɔ kɛgʉ ndɨ na lɨtɔmbʉ lakpʉ. Nɨmɔ aɓaka ndɨ ɓɨgala-gala kyɛ lɨtɔmbʉ kɛgʉ ndɨ lakpʉ wa. ");
INSERT INTO lik_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Luki limoti, nɨyɔ mɔnɨ osumbo, awɨsɨya, ʉmɨlaga kyɛ lyo yi kigwinanagʉ ndɨ ɓɨnza ka lɨtɔmbʉ. ");
INSERT INTO lik_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Masɔlɔ magɔgɔ anyʉkaga ndɨ lugo wo kpokiki. Kpokiki aɓaka ndɨ, akandaga ɓɨkpɛkɨ-kpɛkɨ nɨ koɓukutigʉ. ");
INSERT INTO lik_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Luki limoti, magɔgɔ anyʉkaga ndɨ ka lɨtɔmbʉ la dɔɓɔ. Aɓaka, opingo, aɓʉkʉta ndɨ ɓɛkaza ɓɨyʉyʉyʉ. Ɨkaza imoti-imoti aɓʉkʉtaga ndɨ bumo ɓatɛkɛɓɛ ɓasaa, yagɔgɔ ɓatɛkɛɓɛ maɗɨya na yagɔgɔ ɓata mɨya.» ");
INSERT INTO lik_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Kumbuso yi, Yeso omotiloku ndɨ ɓɛ: «Mʉtʉ yi nɨnɔ a na motili ma kʉkana, ʉkanɨtɔ!» ");
INSERT INTO lik_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Nɨyɔ Yeso ɨtɛ ndɨ mina ɓyɨ na ambaza, ɓatʉ nɨɓɔ ɓa ndɨ na ɨɓʉ pa imoti na ɓatʉtʉmbwa tɛkɛɓɛ na ɓaɓa ɓapʉnga ndɨ kamuusogo ko bulya mozuni. ");
INSERT INTO lik_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Usikisya ndɨ ɓɛ: «Kunzi amumibisatʉ iɓunu ɓodikiɗi ɓaya Ɓʉngama kakɨ. Luki limoti, ɓatʉ ɓagɔgɔ ɓʉkanaga ɨɓʉ pisi ka mozuni. ");
INSERT INTO lik_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Kʉwa wa gɔ wa, ‹Ɓakwanana kaanda ɓɨnza, luki limoti, nɨ ɓakɛgʉ kaɨna. Ɓakwanana kaʉkana ɓɨnza, luki limoti, nɨ ɓakɛgʉ kotombisyo. Ɓakotombisyaga ndɨ, ɓakwanana ndɨ kamigilyoku Kunzi, Kunzi ʉpɨlya ɓʉnyɛ.›» ");
INSERT INTO lik_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Kumbuso yi, Yeso ʉɓɨkya ɓata ɓatʉ nɨɓɔ ɓa ndɨ wa ɓɛ: «Makɛgʉ kotombisyo isi ya lizuni li nɨlɨ! Makwanana kʉwa kotombisyo ɓesi ɓaya mozuni magɔgɔ lɨkɨ? ");
INSERT INTO lik_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Mʉkʉkʉna akakʉna Lɨkpʉmʉka ko Kunzi. ");
INSERT INTO lik_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ɓatʉ ɓemoti-ɓemoti ɓa abɛ kpɔlɔ-kpɔlɔ wo pisi kʉ Lɨkpʉmʉka ko Kunzi anyʉkaga ndɨ mino. Ɓʉkanagatʉ, luki limoti Abɨlɨ odoku ɓɨgala, anyɔ Lɨkpʉmʉka li nɨlɔ ikuni kʉsɔ kaɓʉ. ");
INSERT INTO lik_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ɓagɔgɔ ɓa abɛ pa ya ngyengye nɨyɔ kɛgʉ ndɨ na lɨtɔmbʉ lakpʉ. Nɨyɔ ɓʉkanaga Lɨkpʉmʉka ko Kunzi, ɓogwi na magyagya ɓɨgala-gala. ");
INSERT INTO lik_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Luki limoti, Lɨkpʉmʉka li nɨlɔ kikogigʉ no lyo kʉsɔ kaɓʉ, ɓogwigo ko ngbinga mʉkɛɗɛ aka. Nɨyɔ ɓʉkpɛkɨ-kpɛkɨ na yigyogyiso usilyogo mino ko bulya Lɨkpʉmʉka ko Kunzi, ɓatʉkya ɓɨkwa ka baya. ");
INSERT INTO lik_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ɓagɔgɔ ɓata ɓa abɛ pa yo kpokiki kʉ ɓakʉna ndɨ mino masɔlɔ magɔgɔ. Ɓʉkanagatʉ Lɨkpʉmʉka ko Kunzi, ");
INSERT INTO lik_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","luki limoti, ɓʉkpɛkɨ-kpɛkɨ ɓa ɔɓɨlɨ, mʉsasa ma lɨngama na mʉsasa magɔgɔ dididi akandaga Lɨkpʉmʉka li nɨlɔ kʉsɔ kaɓʉ ɓɨkpɛkɨ-kpɛkɨ nɨ kopígʉ bumo. ");
INSERT INTO lik_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ka muliɓo, ɓatʉ ɓagɔgɔ ɓa abɛ lɨtɔmbʉ la dɔɓɔ kʉ masɔlɔ magɔgɔ anyʉkaga ndɨ mino. Ɓʉkanaga Lɨkpʉmʉka ko Kunzi, ɓabaɨlya, aɓʉkʉta bumo. Ɓatʉ ɓa baya ɓi ɓemoti-ɓemoti ɓaɓʉkʉtaga bumo ɓatɛkɛɓɛ ɓasaa, ɓagɔgɔ ɓatɛkɛɓɛ maɗɨya, ɓagɔgɔ ɓata mɨya.» ");
INSERT INTO lik_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Kʉwa wa, Yeso ʉɓɨkya ɓata ndɨ ɓɛ: «Ɓakatʉnagɨgʉ tala kyɛ ɓagbukumisyi na mʉmbɨ ikanɨ ɓabisi kusyokoto. Luki limoti, ɓabisaga kʉgʉ, ka pa nɨyɔ ɓabisogo mino. ");
INSERT INTO lik_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","A ɓɛyɔ, lasɨ nɨlɔ a lakɨsʉma imibisikosatʉ ndɛkɛ, na lasɨ nɨlɔ a ko dikiɗi ipupisa ɓɨngbanganya. ");
INSERT INTO lik_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Mʉtʉ kika na motili ma kʉkana, ʉkanɨtɔ!» ");
INSERT INTO lik_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yeso ʉɓɨkya ɓata ndɨ ɓɛ: «Ɛɛɛ, wiminyonito sɛ na lɨkpʉmʉka nɨlɔ makaʉkana lɔ! Mʉɗɔngɔnɨ ɓɛyɔ mʉgyaga mino ɓɛngɛnɨ, Kunzi amumigisya ndɛkɛ iɓunu mʉɗɔngɔnɨ ɓɛgɛyɔ, na ɓamʉmatɨlya ɓata kakɨtaga. ");
INSERT INTO lik_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","A ɓɛyɔ, mʉtʉ yi nɨnɔ a no luki, ɓamatɨlyatʉ ɓata. Luki limoti, mʉtʉ yi nɨnɔ kɛgʉ no luki ɓakʉpya gʉtʉgʉ luki lɨkɛɗɛ aka nɨlɔ akwanano ɓi kaika nolu.» ");
INSERT INTO lik_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yeso oɓikyoku ndɨ ɓata ɓɛ: «Ɓʉngama ko Kunzi a mʉɗɔngɔnɨ abɛ mʉtʉ nɨnɔ akʉna ndɨ masɔlɔ ko tiko kakɨ. ");
INSERT INTO lik_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Alalaga ndɨ ɓɨpɛ no biti, anozuzuka masyɛ masɨ. Ko ngbingo yi nɨnɔ, tiko anaɓaka, malɨlɨ anopingo nɨ alʉkʉ nɔ kɛgʉ kaiba ɓɛ akaɓaka lɨkɨ. ");
INSERT INTO lik_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Lɨtɔmbʉ yɨkaka aka lɔ oɓokisaga malɨlɨ, apʉngaga mbɛyɨ mapakʉ mi, kumbuso yi ɨkaza, ka muliɓo bumo yɨngata kʉgʉ wa ɨkaza. ");
INSERT INTO lik_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ngbingo yi nɨnɔ mʉpʉnga atana mino, apʉnga kabuulyo kyɛ iko nɨ ngbingo mubuulyo itulyonini.» ");
INSERT INTO lik_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Kumbuso yi, Yeso oɓikyoku ɓata ndɨ ɓɛ: «Takwanana kokingyasa Ɓʉngama ko Kunzi na ɨkɨ? Tokingyasa pɨyɛ na lizuni tino? ");
INSERT INTO lik_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","A abɛ libumo lɨkɛɗɛ nɨlɔ ɓakʉnaga, ikaga lɨkɛɗɛ kʉgbɛ kakɨtaga bumo yasɨ ya ɔɓɨlɨ. ");
INSERT INTO lik_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Luki limoti, opingo kʉwa, ɨɨta sɨbʉkʉsɔ sidingi kakɨtaga bʉkʉtɔ tasɨ to tiko. Aɓaka tabɨ yakpʉkpʉ, ɓombu ɓagya ɓandaɓʉ kaɓʉ kʉgʉ yi, ɓiko kaɨgbʉka ka kululuko kwi.» ");
INSERT INTO lik_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yeso ʉtɨwaga ndɨ ɓambanzʉ pisi ka mozuni dididi ɓɛyɔ ka nɨma. Ʉtɨwaga ndɨ ɓɛyɔ kyɛ ɓakwananɨtɔ kotombisyo. ");
INSERT INTO lik_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ʉnzɨnɨlyaga ndɨ pisi ka mozuni aka. Luki limoti, nɨyɔ ɓikaga ndɨ asɨ na ɓaɓɨɓya kakɨ aka, ʉtʉmbʉlyaga ndɨ makpʉmʉka masɨ. ");
INSERT INTO lik_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Na ɓʉgɔgɔ ɓa lɨsyɛ li nɨlɔ aka lɔ, Yeso ʉɓɨkya ɓaɓɨɓya kakɨ ɓɛ: «Tozobini kʉsyakʉ.» ");
INSERT INTO lik_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ɓasa kʉwa ndɨ ambaza ka ɓambanzʉ, ɓaɓɨɓya ɓaga ndɨ pa imoti na Yeso ka ɨngbɔlɔ yidingi nɨyɔ a ndɨ mino. Ɓɛngbɔlɔ ɓayidingi-dingi ɓayagɔgɔ atʉ ndɨ gɔnɨ ɓuwobi na ɨɓʉ wa. ");
INSERT INTO lik_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Mbumbo yapʉ kʉgbɛ odoku ndɨ ɓigbututu, mʉɓaka apʉnga kokotukosaga liɓo ka ɨngbɔlɔ yi nɨyɔ, ɨngbɔlɔ apʉnga ndɨ komwaga liɓo. ");
INSERT INTO lik_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Luki limoti, Yeso a ndɨ miso ya kumbusa wa ɨngbɔlɔ, mʉlala ɓɨpɛ, mʉ ka apiɓu. Ɓaɓɨɓya kakɨ ɓabanda ndɨ, ɓaɓɨkya ɓɛ: «Muwonisilo, tanolumwogo, nɨlɔ kɛgʉ gʉtʉgʉ ɨwɛ kaudwiso lɨmbɛngɨ aka?» ");
INSERT INTO lik_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Nɨyɔ Yeso ozuzuko, apamɨlya ndɨ mbumbo, aɓɨkya liɓo ɓɛ: «Daka! Pɨla ɓipisiii!» Kʉwa wa, mbumbo adakɨlya ndɨ, pa aka ndɨ lɨngʉnʉ ɓiwo. ");
INSERT INTO lik_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Kumbuso yi, Yeso umuusa ndɨ ɓɛ: «Ko bulya ɨkɨ yɔ mo mino kaɓanga? Makɛgʉ nɛkɨ mbɛyɨ na baya kadwɛ mɔnɨ na ɓʉɓwanʉ?» ");
INSERT INTO lik_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Luki limoti, ɓaɓɨɓya ɓaɓanga ndɨ kʉgbɛ. Ɓapʉnga ndɨ kauusono ɓɛ: «Inguo ya mʉmbanzʉ tino pɨyɛ mʉ? Gʉtʉgʉ mbumbo aka no liɓo akamʉkana!» ");
INSERT INTO lik_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Kumbuso yi, Yeso na ɓaɓɨɓya kakɨ ɓadwɛ ndɨ kʉsyakʉ wagɔgɔ wa ibombu ya Galilaya, kʉ ka Ɓagɛlasɨ. ");
INSERT INTO lik_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Nɨyɔ Yeso osya ndɨ ka ɨngbɔlɔ, wa aka wa, mʉtʉ ɓemoti nɨnɔ a ndɨ na lɨmbɛngɨ la ɓʉnyɛ, opupoku ndɨ ka ɓekunde, asilya ndɨ. ");
INSERT INTO lik_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ikaga kʉwa ndɨ ɨyɨ ka ɓekunde aka. Gʉtʉgʉ mʉtʉ ɓemoti aka kakwananagɨgʉ ndɨ ɓata kagwi, ikanɨ kamakya ka kpʉkpʉ. ");
INSERT INTO lik_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","A ɓɛyɔ, magʉ kakɨ ikaga ndɨ ɓongbinga ɓasɨ ka kpʉkpʉ, maɓɔkʉ mʉkanda na selegeni ɓingbufu. Luki limoti, ɨtɨnaga ndɨ ɓaselegeni ɓi nɨɓɔ ɓitututu, ʉlaga kpʉkpʉ yi nɨyɔ yasɨ. Kikogigʉ ndɨ na mʉtʉ ɓemoti nɨnɔ akwananaga ndɨ kagwigo. ");
INSERT INTO lik_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ɓongbingo ɓasɨ, biti na lɨsyɛ, ikaga ndɨ kaamama ɓɨgbagbagba ka ɓekunde na ka ɓangʉpa, anapamɨkanaga, anɨkɔ ɓapwayɨ na matamʉ. ");
INSERT INTO lik_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nɨyɔ aminoku Yeso asɨ ɓyɨ aka, opikitoku, ogwo na moli ɓikpwu kambwa kakɨ, ");
INSERT INTO lik_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","apamɨkana ɓɛ: «Yeso, Miko-Kunzi nɨnɔ Kʉgʉ-Kʉgbɛ, nɨlɔ kusu na iɓunu opukogi ɓʉnɨ? Kikiliki ko lino ko Kunzi, wakegyogyisonitɔgʉ ɓaka!» ");
INSERT INTO lik_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","A ndɨ kanzɨna ɓɛyɔ kyɛ Yeso a ndɨ nɨ oɓikyini ɓɛ: «Lɨmbɛngɨ la ɓʉnyɛ, pupo ka alʉkʉ yi nɨmʉ!» ");
INSERT INTO lik_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Kʉwa wa, Yeso amuusa ndɨ ɓɛ: «Wina ɓʉ?» Asikisya ɓɛ: «Nina ɓɛ ‹Ndube›, kyɛ ta ɓudingi.» ");
INSERT INTO lik_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ɨtatanaga ndɨ na Yeso kʉgbɛ ɓɛ kokpumyonitɔgʉ ɓaka mambɛngɨ ma ɓʉnyɛ mi nɨmɔ kunzi wa mugi mi nɨmɔ. ");
INSERT INTO lik_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ambaza mudingi ka ɓangʉya a ndɨ kalyalya ka ngʉpa wa. ");
INSERT INTO lik_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Mambɛngɨ ma ɓʉnyɛ ɨtatanaga ndɨ na Yeso ɓɛ: «Tɨtɨkanɔ ɓaka kʉsɔ ka ɓangʉya ɓi nɨɓa, tɨsɨlya pisi kogulya kʉsɔ kaɓʉ.» ");
INSERT INTO lik_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yeso asɨlya ndɨ mambɛngɨ ma ɓʉnyɛ pisi, opupa kʉwa ndɨ, ogulya ka ɓangʉya. Kʉsɔ wa ambaza, ɓangʉya ɓa ndɨ banda ɓɛlɔfʉ ɓaɓa. Ɓongbutukana kʉwa ndɨ ko dida wa ngʉpa kadwɛ ko liɓo lidingi, ɓolumwogo. ");
INSERT INTO lik_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ɓoɓuɓulyo ka ɓangʉya ɓaga ndɨ mbangʉ kapága mongoni mi nɨmɔ ka gʉɗʉ na ko giyo. Ɓambanzʉ ɓodoku ndɨ kaɨna nɨlɔ igyonosa ndɨ lɔ. ");
INSERT INTO lik_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Nɨyɔ ɓosila ɓuwobi na Yeso, ɓamɨna ndɨ mʉtʉ yi nɨnɔ a ndɨ na mambɛngɨ ma ɓʉnyɛ nɔ mukuliko, nɨ imokisyini kutuko, mʉpɨla ɓɨnza ɓipiii. Ɓatʉ ɓi nɨɓɔ ɓaɓanga ndɨ kʉgbɛ. ");
INSERT INTO lik_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Nɨɓɔ ɓɨna ndɨ nɨlɔ igyonosa ndɨ lɔ, ɓutumbulyogoku ɓatʉ ɓagɔgɔ: iki nɨlɔ asilya ndɨ alʉkʉ yi nɨnɔ a ndɨ na mambɛngɨ ma ɓʉnyɛ nɔ, na iki nɨlɔ usilya ndɨ ɓangʉya. ");
INSERT INTO lik_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Kʉwa wa, ɓapʉnga ndɨ kaɨtatanaga na Yeso ɓɛ opupinɔ ɓaka ka lɨtɔmbʉ kaɓʉ. ");
INSERT INTO lik_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ngbingo yi nɨnɔ Yeso a ndɨ mino kaɗaka ka ɨngbɔlɔ, mʉtʉ yi nɨnɔ a ndɨ na mambɛngɨ ma ɓʉnyɛ nɔ ɨtatanaga na Yeso ɓɛ ɓaganɔ ɓaka pa imoti na ɨyɨ. ");
INSERT INTO lik_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yeso akya, luki limoti, aɓɨkya ndɨ ɓɛ: «Wɨga kʉ kakʉ, ka lɨvananza kakʉ, utumbulyogoku lɨkpʉmʉka lasɨ nɨlɔ Mombukwono-dosu ugyilyi, na ɓɛyɔ ukwilyi mino kumbu.» ");
INSERT INTO lik_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Alʉkʉ yi nɨnɔ ɨmagalya ndɨ, apʉnga ndɨ kaɓɨkyaga nɨlɔ Yeso agyɨlya ndɨ ka iwili ya Ɓagʉɗʉ-Tɛkɛɓɛ. Nɔkʉ ʉdɨka ndɨ ɓatʉ ɓasɨ ɓɨdɛ. ");
INSERT INTO lik_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Nɨyɔ Yeso azaba ɓata ndɨ ka ɨngbɔlɔ kʉsyakʉ wa Galilaya, ambaza mudingi ka ɓambanzʉ amʉmʉkana ndɨ ɓuwobi na ɨyɨ wa. A ndɨ wakamaga ka kpɔlɔ-kpɔlɔ wa ibombu wa. ");
INSERT INTO lik_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ngama ɓemoti wa ndaɓʉ ya malʉmba ka Ɓayuda nɨnɔ ina ndɨ ɓɛ Yailo, osiloku ndɨ gɔnɨ wa. Nɨyɔ amɨna Yeso, ogwo kambwa kakɨ, ");
INSERT INTO lik_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ɨtatanaga ndɨ na ɨyɨ kʉgbɛ, anaɓɨkya ɓɛ: «Mikamɨ mʉsɨka yi a ɓuwobi kosisa lɨmbɛngɨ. Kikiliki, dokunɔ ɓaka kabisilya maɓɔkʉ, kyɛ ahʉkɨ, isisilaga na ɔɓɨlɨ.» ");
INSERT INTO lik_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Kʉwa wa, Yeso ɓaga ndɨ na ɨyɨ. Ambaza mudingi a ndɨ kaɓɨɓya ɓingbooo, amotosya ɓɨkpwɔ. ");
INSERT INTO lik_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Kʉsɔ wa ambaza wa, a ndɨ na muko ɓemoti nɨnɔ ɓangʉ apupaga ndɨ katʉkya ɓyanga tɛkɛɓɛ na ɓɨɓa. ");
INSERT INTO lik_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","A ndɨ nɨ igyogyisini kʉgbɛ ka maɓɔkʉ ka ɓamʉnganga. Ama ndɨ mukumbo kakɨ masɨ ɓingbufu ka bʉkʉtɔ, luki limoti ɓangʉ idukulogo kopupo aka. ");
INSERT INTO lik_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Nɨyɔ muko nɔ ʉkana mongoni ka Yeso, ogulya ndɨ ka ambaza, kumbuso ka Yeso, avɨla mʉ ma kutuko kakɨ. ");
INSERT INTO lik_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","A ɓɛyɔ, a ndɨ katamanaga ɓɛ: «Nakavɨla gʉtʉgʉ kutuko kakɨ aka, nahʉkatʉ.» ");
INSERT INTO lik_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Nɨyɔ aka yɔ avɨla kutuko ka Yeso, ɓangʉ asa ndɨ kapupo wa aka wa, ɨmʉkana ndɨ ɓɨnza. ");
INSERT INTO lik_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ko ngbingo yi nɨnɔ aka nɔ, Yeso ɨmʉkana ndɨ ɓɛ ngu apupini mino. Oyikana kʉwa ndɨ ka ambaza ka ɓambanzʉ, uusa ɓɛ: «Wanɨ pɨyɛ nɔ ovili kutuko kamɨ?» ");
INSERT INTO lik_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ɓaɓɨɓya kakɨ ɓasikisya ndɨ ɓɛ: «Wakɛgʉ mbɛyɨ kaɨna ɓɛyɔ ambaza umotosi mino ɓɨkpwɔ ɓɛnɛ? Wa pɨyɛ ɓata kauuso lɨkɨ ɓɛ: ‹Wanɨ nɔ evili?›» ");
INSERT INTO lik_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Luki limoti, Yeso ɨkwɛ ka ɓakpɔlɔ-kpɔlɔ kakɨ kyɛ amɨnɨ mʉtʉ yi nɨnɔ agya ndɨ ɓɛyɔ. ");
INSERT INTO lik_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Nɨyɔ muko yi nɨnɔ iba lɨkpʉmʉka nɨlɔ asilya ndɨ, apʉnga ndɨ kagʉgʉma na kʉɓangakʉ. Odoku kʉwa ndɨ kogwa kambwa ka Yeso, atʉmbʉlyaga lɨkpʉmʉka lasɨ ka ɓungbingbili. ");
INSERT INTO lik_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yeso aɓɨkya ɓɛ: «Mikamɨ, baya kakʉ uhukusini. Waga na mazɨyɔ, woukini.» ");
INSERT INTO lik_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ngbingo yi nɨnɔ Yeso a mbɛyɨ ndɨ mino kanzɨna aka nɔ, ɓambanzʉ ɓotukyoku ndɨ kʉ ka ngama wa ndaɓʉ ya malʉmba ka Ɓayuda, ɓaɓɨkya ɓɛ: «Mikakʉ osisini lɨmbɛngɨ. Wa sɛ pɨyɛ ɓata kadomiso Muwonisilo ko bulya ɨkɨ?» ");
INSERT INTO lik_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Luki limoti, Yeso kobisagʉ ndɨ lɨmbɛngɨ ka lɨkpʉmʉka li nɨlɔ, aɓɨkya ngama nɔ ɓɛ: «Wakoɓongonitɔgʉ! Wika na ɓaya aka!» ");
INSERT INTO lik_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yeso kapagʉ ndɨ kaɨnda na ɓatʉ ɓagɔgɔ kiki asɨ Pɛtɛlɛ aka, Yakɔbɔ na mamakɨ ɓɛyɔ ka Yuani. ");
INSERT INTO lik_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ɓosila kʉwa ndɨ ka ndaɓʉ ka ngama Yailo. Kʉ ɓɛyɔ, Yeso atakanya ndɨ ɨpʉmbʉ, ɓambanzʉ ɓanagamana na ɓanakʉgwaga. ");
INSERT INTO lik_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ingya ndɨ, ʉɓɨkya ɓɛ: «Ko bulya ɨkɨ yɔ mo mino kapá ɨpʉmbʉ na kagamana ɓɛnɛ? Miki kɛgʉ mukwo, luki limoti, a ka tɔtɔ.» ");
INSERT INTO lik_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ɓatʉ ɓi nɨɓɔ ɓatɨba ndɨ ɓɨkyaaa. Luki limoti, Yeso upupisisa ndɨ ɓasɨ kunzi. Ava ndɨ abakɨ miki, amakɨ sɛ kʉwa ɓaɓɨɓya kakɨ ɓasaa ɓi nɨɓɔ, ogulya kʉ miki a ndɨ mino. ");
INSERT INTO lik_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Agwi kʉɓɔkʉkɔ, aɓɨkya ndɨ ɓɛ: «Talita kumu» isi yi ɓɛ: «Mikya ɓasɨka, nakaʉɓɨkya ambɛ, zuzuko!» ");
INSERT INTO lik_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ko ngbingo yi nɨnɔ aka nɔ, miki nɔ amaga ndɨ, apʉnga kakpakyana. A ndɨ na ɓyanga tɛkɛɓɛ na ɓɨɓa. Nɔkʉ ʉdɨka ndɨ ɓambanzʉ ɓɨdɛ kaɨna lɨkpʉmʉka li nɨlɔ. ");
INSERT INTO lik_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Luki limoti, Yeso aka ndɨ na ɨɓʉ ɓɛ: «Kpɔ kpɔ kpɔ, makatumbulyogonitɔgʉ mʉmbanzʉ.» Kumbuso yi, ʉkpamya ndɨ ɓɛ: «Mupóni luki lɨlya.» ");
INSERT INTO lik_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yeso atʉkya ndɨ ka pa yi nɨyɔ, ɨnda ndɨ kʉ opinga ndɨ mino, pa imoti na ɓaɓɨɓya kakɨ. ");
INSERT INTO lik_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Nɨyɔ Lɨsyɛ la kimumbiso ɨtʉlyana, apʉnga ndɨ kapá mʉtʉʉ ka ndaɓʉ ya malʉmba ka Ɓayuda. Nɔkʉ ʉdɨka ndɨ ɓɨdɛ ɓatʉ ɓudingi ɓasɨ nɨɓɔ ɓa ndɨ kamʉkana wa. Ɓapʉnga ndɨ kauusono ɓɛ: «Wanɨ nɔ awonisila masɨ mi nɨma? Yimibo tina yɔ ɓapá ndɨ ɓɛnɛ? Apʉnya no ngu yɨgya makpʉmʉka mʉmbanga-mbaga ɓɛnɛ yanɨ? ");
INSERT INTO lik_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Kɛgʉ mbɛyɨ mutwo maɓaʉ mʉ? Mika Malia? Mamakɨ Yakɔbɔ, Yɔsɛ, Yuda na Simoni? Takikogigʉ mbɛyɨ pa imoti na ɓasalɨ kakɨ wanʉ?» Kinili ɓakakwananagʉ ndɨ kaɓɨnɨkyana. ");
INSERT INTO lik_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Kʉwa wa, Yeso ʉɓɨkya ndɨ ɓɛ: «Mugyalandʉ ikaga na ɨbɨba ka ɓapa ɓayasɨ, luki limoti, kikogigʉ na ɨbɨba kʉ kaɓʉ, luga wa lɨvananza kakɨ na ka ndaɓʉ kakɨ.» ");
INSERT INTO lik_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Yeso kakwananagʉ ndɨ ɓata kagya lɨkpʉmʉka lɨmbanga gʉtʉgʉ limoti aka kʉ ɓɛyɔ. Luki limoti, ubisilya ndɨ ɓatʉ ɓa ɓokoloɓu ɓemoti-ɓemoti aka maɓɔkʉ, ɓahʉka ndɨ. ");
INSERT INTO lik_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","A ndɨ kombomboyo kyɛ ɓambanzʉ ɓakɛgʉ ndɨ kaɓɨnɨkyana. Kumbuso yi, Yeso ɨnda ndɨ kolingyo giyo yasɨ nɨyɔ ɓuwobi-ɓuwobi anapá mʉtʉʉ. ");
INSERT INTO lik_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Kʉwa wa, ʉmaka ndɨ ɓatʉtʉmbwa tɛkɛɓɛ na ɓaɓa, apʉnga ndɨ kaʉtɨka ɓaɓa-ɓaɓa nɨ upíni ngu yikpumyo mambɛngɨ ma ɓʉnyɛ. ");
INSERT INTO lik_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ʉgbɨtyaga ndɨ ɓɛ: «Makigwinonogonitɔgʉ no luki ko pisi kiki asɨ mʉdʉkpɔ aka. Makavonitɔgʉ mukati, kʉgba, gʉtʉgʉ ɓuyi aka ko fuku kunu. ");
INSERT INTO lik_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Wimokisyoni ɓɛkpakʉ, luki limoti, makimokisyonitɔgʉ ɓasimizi ɓaɓa.» ");
INSERT INTO lik_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Yeso uɓikyoku ɓata ndɨ ɓɛ: «Ɓakamʉtɨlya ɓanʉ ka ndaɓʉ imoti ɓɛnɛ, wikoni wa aka wa, kadwɛ kʉ kwa kʉ mopupo mino. ");
INSERT INTO lik_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Puponi ka ɓapa ɓayasɨ kʉ ɓakamʉtɨlyɨgʉ ɓanʉ mino na kʉ ɓakya ɓanʉ mino kamʉmʉkana. Mɨbʉmaga liɓungu la magʉ kunu kauwonisilo ɓɛ ɓamukyini.» ");
INSERT INTO lik_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Kʉwa wa, ɓatʉtʉmbwa ɓaga ndɨ kauɓikyogoku ɓambanzʉ ɓɛ okwononi ɓayikosi ɔɓɨlɨ kaɓʉ ko Kunzi. ");
INSERT INTO lik_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ɓokpumya ndɨ mambɛngɨ ma ɓʉnyɛ makpʉ, ɓugboɗyaga ndɨ gɔnɨ ɓatʉ ɓa ɓokoloɓu ɓudingi molingo, ɓanahʉka. ");
INSERT INTO lik_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ngama mudingi ɓɛyɔ ka Ɛlɔdɨ Atipasɨ ʉkana ndɨ mongoni ka Yeso, kyɛ lino kakɨ a ndɨ na ɨbɨba pa yasɨ. Ɓatʉ ɓemoti-ɓemoti ɓa ndɨ kaɓɨkya ɓɛ: «Yuani-Mubatizaɨ nɔ opupiku ka ɓabɨlɨ! Kinili, a kʉwa no ngu kagya makpʉmʉka mʉmbanga-mbanga.» ");
INSERT INTO lik_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ɓatʉ ɓagɔgɔ ɓɛ: «Ɨlɨya nɔ.» Ɓagɔgɔ ɓata ɓɛ: «A mugyalandʉ ɓemoti abɛ ɓemoti ka ɓogyalandʉ ɓandɛlɨ.» ");
INSERT INTO lik_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Luki limoti, nɨyɔ Ɛlɔdɨ ʉkana mongoni mi nɨmɔ, aɓɨkya ndɨ ɓɛ: «Kɛgʉ Yuani nɨnɔ nakusisa ndɨ mʉ nɔ opupiku ɓata ka ɓabɨlɨ!» ");
INSERT INTO lik_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","A ɓɛyɔ, ɨyɨ Ɛlɔdɨ nɔ akpamya ndɨ ɓɛ ɓagwi Yuani, ɓamakya ka bɔlɔkɔ. Lɨkpʉmʉka li nɨlɔ igyonosa ndɨ kyɛ Ɛlɔdɨ ava ndɨ Elodia. Elodia a ndɨ muko mamakɨ nɨnɔ miki yi ɓɛyɔ ka Filipi. ");
INSERT INTO lik_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Yuani a ndɨ kayoyisa ngama Ɛlɔdɨ ɓɛ kokwononigʉ kava muzyakɨ. ");
INSERT INTO lik_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Nɨyɔ Elodia ɨna ɓɛyɔ, abisa ndɨ Yuani no yoko, a ndɨ kapa kamwisiso. Luki limoti, kɛgʉ ndɨ wakinisono no pisi yi, ");
INSERT INTO lik_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","kyɛ Ɛlɔdɨ aɓangagatʉ ndɨ Yuani. Ibagatʉ ndɨ gɔnɨ ɓɛ a mʉtʉ wongbingbili na wotu, na ikaga ndɨ kaɓuulyogo. Ngbingo yi nɨnɔ Ɛlɔdɨ amʉkanaga ndɨ mino, tamanaga kakɨ amisikanaga ndɨ ɓingbwi, luki limoti apaga ndɨ kamʉkana aka. ");
INSERT INTO lik_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Lɨsyɛ limoti, Elodia inisana ndɨ no pisi yanza kamwisiso Yuani. A ndɨ lɨsyɛ lo dumo yitomosyo yɨɓʉkʉta ka ngama Ɛlɔdɨ. Ɨyɨ Ɛlɔdɨ alyisa ndɨ dumo, ʉmaka kʉwa ɓangama kakɨ nɨɓɔ ɓagyaga ndɨ na ɨɓʉ ligubo, ɓangama ka ɓasʉda na ɓambanzʉ ɓudingi-dingi ɓa Galilaya. ");
INSERT INTO lik_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Mika Elodia nɨnɔ mʉsɨka yi ingya ndɨ ka ndaɓʉ, apʉnga koɓino. Moɓino kakɨ aɓosila ndɨ ngama Ɛlɔdɨ na ɓatʉ ɓasɨ nɨɓɔ ʉmaka ndɨ ko dumo. Ngama aɓɨkya kʉwa ndɨ mʉsɨka nɔ ɓɛ: «Ɨkʉnga luki lasɨ nɨlɔ wakapa, nʉpátʉ.» ");
INSERT INTO lik_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Kumbuso yi, akʉlya ndɨ silika ɓɛ: «Nʉpátʉ luki lasɨ nɨlɔ wɛkʉnga, gʉtʉgʉ kika kagbanana ɓʉngama kamɨ lugo aka.» ");
INSERT INTO lik_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Kʉwa wa, mʉsɨka yi nɨnɔ opupa ndɨ, ɨnda kamuusa amakɨ ɓɛ: «Nakʉngɨ luki tino?» Amakɨ asikisya ndɨ ɓɛ: «Kʉnga mʉ ka Yuani-Mubatizaɨ.» ");
INSERT INTO lik_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Mʉsɨka nɔ ɨga ndɨ ɓɨgala-gala kʉ ka ngama, aɓikyoku ɓɛ: «Nakapa ambɛ ɨpá mbɨya-mbɨya wanʉ mʉ ka Yuani-Mubatizaɨ ka papɨ.» ");
INSERT INTO lik_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ngama alya ndɨ kumbu kʉgbɛ. Luki limoti, kakwananagʉ ndɨ ɓata kakya ko bulya silika nɨnɔ akɔ ndɨ kambwa ka ɓatʉ nɨɓɔ ʉmaka ndɨ ko dumo. ");
INSERT INTO lik_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Atɨka kʉwa ndɨ ɓɨgala-gala sʉda kakɨ ɓemoti nɨnɔ aɓuulyaga ndɨ, akpamya ɓɛ akuku Yuani-Mubatizaɨ mʉ. Alʉkʉ nɔ ɨnda ndɨ ka bɔlɔkɔ, akoku ndɨ mʉ. ");
INSERT INTO lik_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Kumbuso yi, odoku ndɨ nomu ka papɨ, apá mʉsɨka yi nɨnɔ. Mʉsɨka yi nɨnɔ apóku ndɨ amakɨ. ");
INSERT INTO lik_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ngbingo yi nɨnɔ ɓaɓɨɓya ka Yuani ɓʉkana ndɨ mino mongoni mi nɨmɔ ɓɛyɔ, ɓobinikoku ndɨ manda kakɨ, ɓolumba ndɨ. ");
INSERT INTO lik_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Nɨyɔ ɓatʉtʉmbwa ɓigononoku ndɨ ɓuwobi na Yeso, ɓatʉmbʉlyaga ndɨ makpʉmʉka masɨ nɨmɔ ɓagya ndɨ, na mʉtɨwɨ masɨ nɨmɔ ɓapá ndɨ. ");
INSERT INTO lik_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Yeso ʉɓɨkya ndɨ ɓɛ: «Togoni mbɛyɨ iɓusu aka ɓɨkɛɗɛ ka pa nɨyɔ mʉmbanzʉ kɛgʉ mino, mimumbisoku.» Aɓɨkya ndɨ ɓɛyɔ kyɛ ɓambanzʉ ɓudingi kʉgbɛ ɓasilyogoku ndɨ, ɓanaga. Ɓaɓɨɓya ɓakɛgʉ ndɨ gʉtʉgʉ no ngbingo mʉlyalya aka. ");
INSERT INTO lik_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ɓakɨɗa kʉwa ndɨ asɨ ɨɓʉ aka ka ɨngbɔlɔ ɓapʉnga kaɨnda ka pa nɨyɔ mʉmbanzʉ kɛgʉ ndɨ mino. ");
INSERT INTO lik_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Luki limoti, ɓatʉ ɓudingi ɓʉmɨna ndɨ nɨ ɓanaga, ɓumibo. Kʉwa wa, ɓambanzʉ ɓa gʉɗʉ ɓasɨ ɓatɨnɨka ndɨ na mbangʉ, ɓaɗɨkya ndɨ nɨ ɨɓʉ kadwɛ kambwa ka Yeso na ɓaɓɨɓya kakɨ ka pa nɨyɔ ɓa ndɨ mino kaɨnda. ");
INSERT INTO lik_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Nɨyɔ Yeso osya ka ɨngbɔlɔ, amɨna ndɨ ambaza mudingi, alya kumbu kʉgbɛ kyɛ a ndɨ abɛ ɓakɔndɔlɔ nɨɓɔ ɓakɛgʉ na muɓuɓulyo. Apʉnga ndɨ kaupá mʉtʉʉ kʉgʉ wa makpʉmʉka mudingi. ");
INSERT INTO lik_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Yɛkɨ ngbingo a kʉwa ndɨ nɨ okitogini, ɓaɓɨɓya ɓakpuɗoku ndɨ, ɓaɓɨkya ɓɛ: «Wanʉ a ɨsa, na ngbingo okitogini gɔnɨ, ");
INSERT INTO lik_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","hʉkpamya ɓatʉ ɓi nɨɓa, ɓaga ko giyo nɨyɔ a ka ɓakpɔlɔ-kpɔlɔ wanʉ na ka sɛngɨ nɨyɨna ɓuwobi-ɓuwobi wanʉ kailuulyo luki lɨlya.» ");
INSERT INTO lik_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yeso usikisya kʉwa ndɨ ɓɛ: «Hupóno nɨ iɓunu aka malɨlɨ.» Luki limoti, ɓamuusa ndɨ ɓɛ: «Wakapa ɓɛ tuluulyiku mukati ma ɓambuma mɨya yɨɓa todoku kaʉpá?» ");
INSERT INTO lik_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yeso umuusa ndɨ ɓɛ: «Ma na mukati mɨnga? Windoni mbɛyɨ kaɨna.» Nɨyɔ ɓondoku, ɓasikisya ɓɛ: «Ta na mukati kuɓukumuti na ɓosi ɓaɓa aka.» ");
INSERT INTO lik_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Kʉwa wa, Yeso ʉkpamya ndɨ ɓɛ ɓulikisi ɓambanzʉ ɓasɨ ka magbʉta ka tɔnɨtɔ. ");
INSERT INTO lik_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ɓikanana ndɨ ka magbʉta ma mɨya-yimoti-yimoti, na magɔgɔ ma ɓatɛkɛɓɛ kuɓukumuti kuɓukumuti. ");
INSERT INTO lik_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yeso ava ndɨ mukati kuɓukumuti na ɓosi ɓaɓa ɓi nɨɓɔ, ɨkwɛ kʉgʉ wa lɨsyɛ, abibisa Kunzi. Kumbuso yi, oɓunonogo mukati, ʉpága ɓaɓɨɓya kakɨ pa imoti na ɓosi ɓaɓa ɓi nɨɓɔ ɓɛ ɓʉlʉpyagɨ kʉwa. ");
INSERT INTO lik_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ɨɓʉ ɓasɨ ɓalyalya ndɨ, ɓikutaga ɓɨkpɛkɛɗɛ-kpɛkɛɗɛ. ");
INSERT INTO lik_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Kʉwa wa, ɓaɓɨɓya ɓamʉmʉla ndɨ ɓodongbu ɓaya mukati na ɓosi nɨɓɔ ɓasɨkana ndɨ. Otuma ndɨ mʉmbɨ tɛkɛɓɛ na mɨɓa. ");
INSERT INTO lik_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Luga ka ɓatʉ ɓasɨ nɨɓɔ ɓalyalya ndɨ, ɓalʉkʉ ɓa ndɨ ɛlɔfʉ kuɓukumuti. ");
INSERT INTO lik_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Kumbusa yɨkɛɗɛ, Yeso ʉkpamya ndɨ ɓaɓɨɓya kakɨ kaɗaka ka ɨngbɔlɔ kyɛ ɓazabɨ mbɛyɨ ɨɓʉ kambwa kʉsyakʉ wa ibombu, miso ka gʉɗʉ wa Bɛtɛsaida. Ɨyɨ, asɨkana ndɨ kapá ambaza ka ɓambanzʉ lɨgʉndʉ. ");
INSERT INTO lik_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Kumbusa kaʉpá lɨgʉndʉ, aga ndɨ kalʉmba ka ngʉpa. ");
INSERT INTO lik_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Nɨyɔ ɓʉgɔgɔ ogwo, ɨngbɔlɔ yidingi a kʉwa ndɨ ka lɨmbɛngɨ lo liɓo. Yeso a ndɨ ɨyɨ mʉkaka aka kubi. ");
INSERT INTO lik_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ɨna ndɨ ɓɛ ɓaɓɨɓya kakɨ ɓa ndɨ na ɓʉkpɛkɨ-kpɛkɨ kawɔ ɨngbɔlɔ kyɛ avivi a ndɨ kautundulo kumbuso. Kʉwa ɓuwobi lɨsyɛ katɨnɨkaga, ɓamɨna ndɨ Yeso nɨnɔ odoku nɔ misa ya kʉ ɓa ndɨ mino. A ndɨ kakpakyana kʉgʉ wo liɓo, anapa kaʉkɨtaga. ");
INSERT INTO lik_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Nɨyɔ ɓamɨna ɓɛyɔ, ɓakʉgwaga ndɨ kyɛ ɓa ndɨ kasɨma ɓɛ abɨlɨ. ");
INSERT INTO lik_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","A ɓɛyɔ, ɨɓʉ ɓasɨ ɓamɨnatʉ ndɨ, ɓotuma ndɨ na kʉɓangakʉ ɓɨɗɛ. Luki limoti, ko ngbingo yi nɨnɔ aka nɔ, Yeso ʉɓɨkya ndɨ ɓɛ: «Wikoni na lɨlʉkʉ! Ɨmɨ nɔ, makoɓongonitɔgʉ!» ");
INSERT INTO lik_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Kumbuso yi, aɗaka ndɨ ka ɨngbɔlɔ pa imoti na ɨɓʉ, avivi adakɨlya ndɨ. Ɓaɓɨɓya ɓotuma ndɨ na ombombo ɓɨɗɛ, ");
INSERT INTO lik_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","kyɛ ɓakotombisyagʉ ndɨ isi ya lɨkpʉmʉka lɨmbanga nɨlɔ agya ndɨ kʉgʉ wa mukati. A ɓɛyɔ, mambɛngɨ kaɓʉ a ndɨ ɓɨdɨsɨlɨ. ");
INSERT INTO lik_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ngbingo yi nɨnɔ ɓazaba ndɨ mino, ɓosila ka iwili ya Gɛnɛzalɛtɨ, ɓafʉma ɨngbɔlɔ. ");
INSERT INTO lik_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Nɨyɔ aka yɔ ɓosya ka ɨngbɔlɔ, ɓambanzʉ ɓamiba ndɨ Yeso. ");
INSERT INTO lik_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ɓapʉnga ndɨ kolingyo iwili yi nɨyɔ yasɨ. Ɓanadulyoku Yeso na ɓatʉ ɓa ɓokoloɓu kʉgʉ wa ɓakalagba ka ɓapa ɓayasɨ kʉ ɓʉkanaga ndɨ mino ɓɛ a kʉ. ");
INSERT INTO lik_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ɓapa ɓayasɨ kʉ Yeso ɨndaga ndɨ mino, iki ka sɛngɨ, ka ɓagʉɗʉ ikanɨ ka ɓasɔkɔ, ɓambanzʉ ɓabisilyaga ndɨ ɓatʉ ɓa ɓokoloɓu kunzi. Ɨɓʉ ɓatʉ ɓi nɨɓɔ ɓɨtatanaga ndɨ na Yeso ɓɛ ɓatʉ ɓa ɓokoloɓu ɓavɨlɨnɔ ɓaka gʉtʉgʉ mʉ ma kutuko kakɨ aka. Na ɓatʉ ɓasɨ nɨɓɔ ɓavɨlaga ndɨ, ɓahʉkagatʉ ndɨ. ");
INSERT INTO lik_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Lɨsyɛ limoti, Ɓafalisayɔ na ɓowonisilo ɓa mʉtʉʉ ɓemoti-ɓemoti nɨɓɔ ɓotukyoku ndɨ ka Yelusalɛma, ɓamʉmʉkana ɓuwobi na Yeso. ");
INSERT INTO lik_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ɓʉmɨna kʉwa ndɨ ɓaɓɨɓya kakɨ ɓemoti-ɓemoti nɨ ɓanalyalya na maɓɔkʉ ma mokoku, isi yi ɓɛ nɨ ɓakisukusigʉ kaɓyɛnɛnɛ na yɨgya ya kanisa kaɓʉ. ");
INSERT INTO lik_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","A ɓɛyɔ, Ɓafalisayɔ na Ɓayuda ɓasɨ ɓaɓangagatʉ ndɨ yɨgya ka ɓatɨtaɓʉ nɨyɔ akʉngaga ndɨ ɓɛ ɓɨsʉkʉsɨ maɓɔkʉ ɓɨnza kambwa kalyalya. ");
INSERT INTO lik_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ngbingo yi nɨnɔ ɓigononogoku ndɨ mino ka sɔkɔ, ɓakalyalyagɨgʉ ndɨ nɨ ɓakisukusigʉ maɓɔkʉ. Ɓobibisagatʉ ndɨ gɔnɨ yɨgya yagɔgɔ dididi nɨyɔ ka ɓatɨtaɓʉ mʉɗɔngɔnɨ abɛ kaʉsʉkʉsa ɓakɔpɔ, ɓambɨkɛ na ɓasani ɓa ɓangwɛyɨ. ");
INSERT INTO lik_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Kʉwa wa, Ɓafalisayɔ na ɓowonisilo ɓa mʉtʉʉ ɓamuusa ndɨ Yeso ɓɛ: «Ko bulya ɨkɨ yɔ ɓaɓɨɓya kakʉ ɓakaɓyɛgɨgʉ mino ɨɓʉ yɨgya ka ɓotitosu? Wɨna mbɛyɨ, ɓakalyalya na maɓɔkʉ ma mokoku aka!» ");
INSERT INTO lik_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yeso usikisya ndɨ ɓɛ: «Ɓugyalandʉ ka Isaya a ndɨ ɓa lɨngʉnʉ kʉgʉ kunu. Ma ɓatʉ ɓa kʉɓɔɓɔkʉ, mʉɗɔngɔnɨ ɓɛyɔ okpikaga ndɨ mino ɓɛ: ‹Ɓatʉ ɓi nɨɓa ɓaɓɨkyaga ɓɛ ɓɛɓangagatʉ, luki limoti, ɓɛmɨnaga payaya. ");
INSERT INTO lik_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Malʉmba nɨmɔ ɓagyaga a ma payaya, a ɓɛyɔ, mʉtʉʉ kaɓʉ, ikaga asɨ yɨgya ka ɓambanzʉ aka› ");
INSERT INTO lik_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Makaasa mʉtʉʉ ko Kunzi, manɨgʉmya ka yɨgya ka ɓambanzʉ.» ");
INSERT INTO lik_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yeso ʉɓɨkya ɓata ɓɛ: «Masaga mʉtʉʉ ko Kunzi ko bulya yiɓuulyogo yɨgya kunu aka. ");
INSERT INTO lik_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","A ɓɛyɔ, Musa aɓɨkya ndɨ ɓɛ: ‹Mʉɓanga abakʉ na amakʉ.› Omotiloku ɓɛ: ‹Mʉmbanzʉ kagbusya abakɨ ikanɨ amakɨ, okwononi ɓamwɨ.› ");
INSERT INTO lik_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Luki limoti, iɓunu maɓɨkyaga ɓɛ: Mʉmbanzʉ kaɓɨkya abakɨ ikanɨ amakɨ ɓɛ: ‹Luki nɨlɔ nakwanano ɓi nolu kausingyo a kɔlɔbanɨ.› Isi yi ɓɛ ‹apɛpɛ ko Kunzi›, ");
INSERT INTO lik_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","kaɓɨkya ɓɛyɔ, makakpamya mʉtʉ yi nɨnɔ ɓɛ kobinikonitɔgʉ ɓuti ka abakɨ ikanɨ amakɨ. ");
INSERT INTO lik_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Kinili, molimogo lɨkpʉmʉka ko Kunzi pisi kapánana yɨgya ka ɓotitonu. Managya gɔnɨ makpʉmʉka magɔgɔ dididi abɛ nɨmɔ.» ");
INSERT INTO lik_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Kʉwa wa, Yeso alɨkya ɓata ndɨ ambaza ka ɓambanzʉ, ʉɓɨkya ɓɛ: «Iɓunu ɓasɨ, imukononi, motombisyo ɓɨnza lɨkpʉmʉka li nɨlɨ: ");
INSERT INTO lik_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kɛgʉ na lɨkpʉmʉka la kunzi nɨlɔ kingyo kʉsɔ ka mʉmbanzʉ, akwanana kapʉta. Luki limoti, nɨlɔ akwanana kapʉta mʉmbanzʉ, a luki li nɨlɔ opupogo ka lɨmbɛngɨ kakɨ.  ");
INSERT INTO lik_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Nɨnɔ apa kaʉkana, ʉkana.» ");
INSERT INTO lik_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ngbingo yi nɨnɔ Yeso atʉkya ndɨ mino ɓuwobi na ambaza ka ɓambanzʉ, ingya ka ndaɓʉ. Ɓaɓɨɓya kakɨ ɓamuusa kʉwa ndɨ isi ya lizuni li nɨlɔ. ");
INSERT INTO lik_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Uɓɨkya ndɨ ɓɛ: «Gʉtʉgʉ iɓunu aka, makɛgʉ nɛkɨ na yimibo? Makɛgʉ kotombisyo ɓɛ luki lasɨ la kunzi kingyo kʉsɔ ka mʉmbanzʉ akwananatʉ kapʉta? ");
INSERT INTO lik_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Makpʉmʉka mi nɨmɔ kingyogigʉ ka lɨmbɛngɨ ka mʉmbanzʉ, luki limoti, ka mʉma. Kumbuso yi, opupo, ɨnda ka lɨmbɨ.» (Pisi ka mʉnzɨna mi nɨmɔ, Yeso a ndɨ kowonisilo ɓɛ ɓakwanana kalya malɨlɨ masɨ.) ");
INSERT INTO lik_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Yeso oɓikyoku ndɨ ɓata ɓɛ: «Lɨkpʉmʉka nɨlɔ opupaga ka lɨmbɛngɨ ka mʉmbanzʉ lɔ apʉtaga. ");
INSERT INTO lik_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","A ɓɛyɔ, tamanaga yanyɛ opupaga ka lɨmbɛngɨ ka mʉmbanzʉ. Akpamya kʉwa kagya ɓʉɗanda, kaiɓo, kamwɔ mʉmbanzʉ, ");
INSERT INTO lik_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","kasyɛ na muko ikanɨ na mʉlʉkʉ wodi, kaika na lɨgbʉgbʉ, kaika mʉɗɨya, kaika na ɓokoli, kagya ɓɨlya ikanɨ ɓʉɗanda, kaika no misa mopi, kaʉnzɨnzɨnya ɓɛngɛnɨ, kaɨbɨnɨka na kaika na ɓungingi. ");
INSERT INTO lik_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Makpʉmʉka manyɛnyɛ mi nɨmɔ masɨ opupogo kʉsɔ ka mʉmbanzʉ, apʉta.» ");
INSERT INTO lik_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Kumbuso yi, Yeso atʉkya ndɨ wa, aga ka iwili ya Tilo. Kʉ ɓɛyɔ, ingya ndɨ ɓɨpɛlɛ ka ndaɓʉ yimoti ɓɛnɛ. Kɛgʉ ndɨ kapa ɓɛ ɓibito ɓɛ a kʉ ɓɛyɔ, luki limoti, ɓambanzʉ ɓiba ndɨ aka. ");
INSERT INTO lik_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Muka ɓemoti nɨnɔ mikakɨ muko yi a ndɨ kaigyogyiso na lɨmbɛngɨ la ɓʉnyɛ, ʉkana ndɨ gɔnɨ mongoni ka Yeso. Muko yi nɨnɔ akpuɗoku ndɨ ɓɨgala-gala, ogwo kambwa kakɨ. ");
INSERT INTO lik_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Kɛgʉ ndɨ ɨyɨ Waɓayuda. Ɨɓʉkʉta ndɨ ka Foinikia ka iwili ya Sulia. Ɨtatanaga ndɨ na Yeso ɓɛ opupisi lɨmbɛngɨ la ɓʉnyɛ nɨlɔ a ndɨ kʉsɔ ko mikakɨ. ");
INSERT INTO lik_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yeso aɓɨkya ndɨ ɓɛ: «Hʉsa mbɛyɨ ɓomiki ɓikutogi. A ɓɛyɔ, kɛgʉ ɓɨnza kava malɨlɨ kaɓʉ, kaumbimbilyo ɓɛnva.» ");
INSERT INTO lik_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Muko yi nɨnɔ asikisya ndɨ ɓɛ: «Mombukwono-dosu, a ɓɛyɔ! Luki limoti, gʉtʉgʉ ɓɛnva aka ɓalyagatʉ gɔnɨ kumbo ya ɓamalɨlɨ nɨyɔ ʉnyʉkɨlyaga ɓomiki ka mɨza.» ");
INSERT INTO lik_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yeso aɓɨkya kʉwa ndɨ ɓɛ: «Ko bulyo mʉnzɨna mi nɨmɔ wosikisyi mɔ, wɨga kʉ kakʉ, lɨmbɛngɨ la ɓʉnyɛ apupini mikakʉ.» ");
INSERT INTO lik_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Nɨyɔ muko yi nɨnɔ ɨga ndɨ kʉ kakɨ, atakanya mikakɨ wakanga nɨ lɨmbɛngɨ la ɓʉnyɛ nɨlɔ apupini. ");
INSERT INTO lik_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Kumbuso yi, Yeso atʉkya ɓata ndɨ ka iwili ya Tilo, akɨtaga ka Sidɔna, akɨtanaga ka Ɓagʉɗʉ-Tɛkɛɓɛ, igoku kʉwa ndɨ misa ya ibombu ya Galilaya. ");
INSERT INTO lik_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Kʉ ɓɛyɔ, ɓadulyoku ndɨ na adʉka ɓemoti nɨnɔ a ndɨ gɔnɨ na ɓʉkpɛkɨ-kpɛkɨ ɓʉnzɨna. Ɓɨtatanaga ndɨ na ɨyɨ ɓɛ abisilyi maɓɔkʉ kyɛ ahʉkɨ. ");
INSERT INTO lik_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yeso ɨtɛ ndɨ na ɨyɨ katʉkya ka ambaza, amakya ndɨ ɓakpɛngbɛ ka motili, ɨɓakya maɓɔkʉ na ɓotikito, avɨla ndɨ lɨsasʉ ka ɓoɓo yi nɨnɔ. ");
INSERT INTO lik_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Kumbuso yi, Yeso ɨkwɛ ndɨ kʉgʉ wa lɨsyɛ, osiso muyukumi, aɓikyoku alʉkʉ nɔ ɓɛ: «Ɛfata» isi yi ɓɛ: «Hukwikono!» ");
INSERT INTO lik_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Wa aka wa, motili ahukwikana ndɨ, lɨsasʉ apolimono, apʉnga ndɨ kanzɨna ɓɨngbanganya. ");
INSERT INTO lik_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yeso ʉgbɨtyaga ndɨ ɓambanzʉ ɓɛ ɓakatumbulyogonitɔgʉ mʉmbanzʉ. Luki limoti, ngbingo yi nɨnɔ Yeso ʉgbɨtyaga ndɨ mino ɓɛyɔ, ɓowowisa kʉwa ɓata ndɨ mongoni mi nɨmɔ kʉgbɛ. ");
INSERT INTO lik_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ɓambanzʉ ɓombombaya ndɨ ɓata kʉgbɛ, ɓaɓɨkya ɓɛ: «Masɨ nɨmɔ akagya a manza kʉgbɛ! Akauhukwo ɓaadʉka motili, anunziniso ɓoɓoɓo!» ");
INSERT INTO lik_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Lɨsyɛ lagɔgɔ, ambaza mudingi ka ɓambanzʉ amʉmʉkana ndɨ ɓata ka kpɔlɔ ka Yeso. Ɓatʉ ɓi nɨɓɔ ɓakɛgʉ ndɨ no luki nɨlɔ ɓakwanana ndɨ kalya. Yeso ʉmaka kʉwa ndɨ ɓaɓɨɓya kakɨ, ʉɓɨkya ɓɛ: ");
INSERT INTO lik_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Nakaʉmɨnɨlya ɓatʉ ɓi nɨɓana kumbu. Ta kʉwa na ɨɓʉ na masyɛ masaa, ɓakɛgʉ ɓata no luki lɨlya. ");
INSERT INTO lik_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nakumigiso ka ɓakʉkaɓʉ na ɓanza, nzʉyɨ ʉdɨkagatʉ ko pisi, kyɛ ɓagɔgɔ luga kaɓʉ ɓotukyiku ɓi ɓyɨɓyɨ ɓyɨ.» ");
INSERT INTO lik_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ɓaɓɨɓya kakɨ ɓasikisya ndɨ ɓɛ: «Ta wanʉ ka ɨsa, takwanana kainisa na malɨlɨ nɨmɔ ɓikutaga na imu yanɨ?» ");
INSERT INTO lik_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yeso umuusa ndɨ ɓɛ: «Ma na mukati mɨnga?» Ɨɓʉ aka ndɨ na ɨyɨ ɓɛ: «Maɗɨya na ɨka.» ");
INSERT INTO lik_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yeso ʉkpamya kʉwa ndɨ ɓambanzʉ ɓɛ ɓikononi wasɨ. Kumbusa kava mukati maɗɨya na ɨka mi nɨmɔ, abibisa ndɨ Kunzi, oɓunonogo, ʉpága ɓaɓɨɓya kakɨ, ɓʉgbananɨlyaga kʉwa ndɨ ɓambanzʉ. Ɓagya ndɨ ɓɛyɔ aka yɔ. ");
INSERT INTO lik_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ɓatʉ ndɨ gɔnɨ mino na ɓomikya ɓosi ɓakɛɗɛ. Yeso abibisa ndɨ Kunzi ko bulya ɓosi ɓi nɨɓɔ, ʉɓɨkya ndɨ ɓaɓɨɓya kakɨ ɓɛ ɓʉlʉpyagɨ gɔnɨ. ");
INSERT INTO lik_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ɓambanzʉ ɓasɨ ɓalyalya ndɨ, ɓikutogo ɓɨkpɛkɛɗɛ-kpɛkɛɗɛ. Kumbuso yi, ɓaɓɨɓya ɓamʉmʉla ndɨ ɓodongbu ɓaya mukati na ɓosi nɨɓɔ ɓasɨkana ndɨ, ɓotumisa mʉmbɨ maɗɨya na ɨka. ");
INSERT INTO lik_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Wɨna sɛ, ɓambanzʉ nɨɓɔ ɓalyalya ndɨ, ɓa ndɨ banda ɛlɔfʉ yɨkwanganya. Kumbuso yi, Yeso ʉpá ndɨ lɨgʉndʉ kaɨganana ka ɓakʉkaɓʉ. ");
INSERT INTO lik_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Kolipyagʉ ɓata, Yeso na ɓaɓɨɓya kakɨ ɓaɗaka ndɨ ka ɨngbɔlɔ yidingi, ɓaga ka iwili ya Dalamanuta. ");
INSERT INTO lik_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ɓafalisayɔ ɓasilyoku ndɨ Yeso, ɓapʉnga ndɨ na ɨɓʉ ɓoɗongoso kakɨsa kaɓɔ ɓɛ ʉgyɨlyɨ likingyosi kotukyoku kʉgʉ wa lɨsyɛ. ");
INSERT INTO lik_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yeso alya ndɨ kumbu kʉgbɛ ka lɨmbɛngɨ, oɓikyoku ɓɛ: «Ko bulya ɨkɨ yɔ ɓatʉ ɓa lɨsyɛ li nɨlɨ ɓo mino kakʉnga likingyosi? A lɨngʉnʉ, nakamʉɓɨkya ambɛ, ɓakɨnɨgʉ ndɛkɛ gʉtʉgʉ limoti aka!» ");
INSERT INTO lik_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Kumbuso yi, ʉsa ndɨ, aɗaka ndɨ ɓata ka ɨngbɔlɔ, ɓazaba kʉsyakʉ wagɔgɔ wa ibombu. ");
INSERT INTO lik_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ɓaɓɨɓya ɓa ndɨ nɨ ɓoɓusolini kava mukati. Ɓa ndɨ nomu mumoti aka ka ɨngbɔlɔ. ");
INSERT INTO lik_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yeso ʉpá mʉtʉʉ ɓɛ: «Wiminyonito na kʉɓɔɓɔkʉ ka Ɓafalisayɔ na yɨgya ka Ɛlɔdɨ. A ɓɛyɔ, yɨgya kaɓʉ a mʉɗɔngɔnɨ abɛ sɨbʉkʉsɔ nɨsɔ ofulisaga mukati.» ");
INSERT INTO lik_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ɓaɓɨɓya ɓapʉnga ndɨ kanzɨna luga kaɓʉ kyɛ ɓakɛgʉ ndɨ na mukati. ");
INSERT INTO lik_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yeso ʉndʉnga ndɨ, umuusa ɓɛ: «Ko bulya ɨkɨ yɔ mo mino kaidomiso na tamanaga ɓɛ makɛgʉ na mukati? Makɛgʉ mbɛyɨ kotombisya lɨkpʉmʉka? Makanibigʉ mbɛyɨ lɨkpʉmʉka? Mambɛngɨ kunu a nɛkɨ ɓɨdɨsɨlɨ aka? ");
INSERT INTO lik_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ma no miso, makɛgʉ kaɨna? Ma na motili, makɛgʉ kaʉkana? Makɛgʉ katamana, ");
INSERT INTO lik_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ngbingo yi nɨnɔ noɓunanaga ndɨ mino mukati kuɓukumuti, nulyolyisa ɓambanzʉ ɛlɔfʉ kuɓukumuti? Motumisaga ndɨ mbɨyɔ yɨnga na ɓodongbu nɨɓayɔ asɨkana ndɨ?» Ɓasikisya ndɨ ɓɛ: «Tɛkɛɓɛ na mɨɓa.» ");
INSERT INTO lik_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Yeso uusoku ɓata ndɨ ɓɛ: «Ngbingo yi nɨnɔ noɓunanaga ndɨ mina mukati maɗɨya na ɨka, nulyolyisa ɓambanzʉ ɛlɔfʉ yɨkwanganya, motumisa ndɨ mʉmbɨ mɨnga na ɓodongbu nɨɓayɔ asɨkana ndɨ?» Ɓosikisya ndɨ ɓɛ: «Maɗɨya na ɨka.» ");
INSERT INTO lik_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Yeso ʉɓɨkya kʉwa ndɨ ɓɛ: «Makonotombisyigʉ aka?» ");
INSERT INTO lik_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yeso na ɓaɓɨɓya kakɨ ɓosila ndɨ ka Bɛtɛsaida. Kʉ ɓɛyɔ, ɓadulyoku ndɨ na mʉtʉ wa koloɓu ya mamɔmɔ, ɓɨtatanaga na ɨyɨ ɓɛ avɨlɨ. ");
INSERT INTO lik_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Kʉwa wa, Yeso agwi ndɨ kʉɓɔkʉkɔ, ɨnda na ɨyɨ kunzi wa mugi. Kʉ ɓɛyɔ, aɓakya ndɨ na ɓotikito ko miso, abisilya maɓɔkʉ, amuusa ndɨ ɓɛ: «Watʉ kaɨna luki?» ");
INSERT INTO lik_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Alʉkʉ nɔ ɨkwɛ ndɨ, aɓɨkya ɓɛ: «Nakaʉmɨna ɓambanzʉ, nakaʉmɨna mʉɗɔngɔnɨ abɛ bʉkʉtɔ, luki limoti ɓakakpakyana.» ");
INSERT INTO lik_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yeso ɨgɨlya ndɨ ɓata kabisilyo maɓɔkʉ ko miso, alʉkʉ nɔ ɨna ndɨ ɓɨngbanganya. Ahʉka ndɨ, apʉnga kotombisya makpʉmʉka dididi. ");
INSERT INTO lik_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yeso apá ndɨ lɨgʉndʉ kaɨga kʉ kakɨ, aɓɨkya ɓɛ: «Wakigonitɔgʉ ɓata pisi ka mugi mi nɨmɔ.» ");
INSERT INTO lik_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Kʉwa wa, Yeso na ɓaɓɨɓya kakɨ ɓaga ndɨ miso ya sɛngɨ nɨyɔ ikaga ndɨ ɓuwobi na gʉɗʉ wa Kaizalɨa-Filipi. Ko pisi, umuuso ɓaɓɨɓya kakɨ ɓɛ: «Ɓambanzʉ ɓa pɨyɛ kaɓɨkya ɓɛ ɨmɨ nɨ wanɨ?» ");
INSERT INTO lik_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ɓasikisya ndɨ ɓɛ: «Ɓatʉ ɓemoti-ɓemoti ɓaɓɨkyaga ɓɛ ɨwɛ nɨ Yuani-Mubatizaɨ, ɓagɔgɔ ɓɛ ɨwɛ nɨ mugyalandʉ Ɨlɨya, ɓagɔgɔ ɓata ɓɛ wa ɓemoti ka ɓogyalandʉ.» ");
INSERT INTO lik_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yeso umuusa kʉwa ndɨ ɓɛ: «Sɛ kʉwa iɓunu, maɓɨkyaga ɓɛ ɨmɨ nɨ wanɨ?» Pɛtɛlɛ asikisya ndɨ ɓɛ: «Ɨwɛ nɨ Kilisito.» ");
INSERT INTO lik_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yeso ʉgbɨtyaga kʉwa ndɨ ɓɛ ɓakaɓikyonitɔgʉ mʉmbanzʉ lɨkpʉmʉka li nɨlɔ. ");
INSERT INTO lik_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Kumbuso yi, Yeso apʉnga ndɨ kaʉpá ɓaɓɨɓya kakɨ mʉtʉʉ ɓɛ: «Okwononi ɓɛ Mika-mʉmbanzʉ igyogyisi kʉgbɛ. Ɓambɔkʉ-mbɔkʉ ka Ɓayuda, ɓokumu-kumu na ɓowonisilo ɓa mʉtʉʉ ɓakyatʉ ndɛkɛ. Ɓamwisiso, luki limoti, kumbusa wa masyɛ masaa, opupoku ka mbʉkʉ.» ");
INSERT INTO lik_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yeso ʉɓɨkyaga ndɨ lɨkpʉmʉka li nɨlɔ ɓɨngbanganya. Kʉwa wa, Pɛtɛlɛ amaka ndɨ ɓɨkɛɗɛ, apʉnga kayoyiso. ");
INSERT INTO lik_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Luki limoti, Yeso oyikana ndɨ, ʉnda ɓaɓɨɓya kakɨ ɓizumuuu, ayoyiso Pɛtɛlɛ ɓɛ: «Abɨlɨ mʉ! Kɨtaga kumbusa kamɨ! Tamanaga kakʉ kɛgʉ abɛ nɨyɔ ko Kunzi, luki limoti, a abɛ nɨyɔ ka ɓambanzʉ.» ");
INSERT INTO lik_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Kumbuso yi, Yeso amaka ndɨ ambaza ka ɓambanzʉ pa imoti na ɓaɓɨɓya kakɨ, ʉɓɨkya ɓɛ: «Mʉmbanzʉ kapa kɛɓɨɓya, okwononi ɨmʉyɨ ɨyɨ mombukwana-dakɨ yi ɓɨkpɛ, abɨnɨka mʉsalaba kakɨ, apʉnga kɛɓɨɓya. ");
INSERT INTO lik_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","A ɓɛyɔ, mʉmbanzʉ kapa kaɓuulyogo ɔɓɨlɨ kakɨ, aputikosatʉ ɔɓɨlɨ yi nɨnɔ. Luki limoti, nɨnɔ aputikosa ndɛkɛ ɔɓɨlɨ kakɨ ka mombukwana-dakɨ yi ko bulya Mongoni Manza, aɓuulyagatʉ. ");
INSERT INTO lik_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","A na ɨzangɨya tino mʉmbanzʉ kainisono na lɨngama lasɨ la ɔɓɨlɨ nɨ aputini ɔɓɨlɨ kakɨ? Ɨkɨ yɔ akwanana kapá ɓata kyɛ ahukusi ɔɓɨlɨ kakɨ? ");
INSERT INTO lik_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Kɛgʉ no luki gʉtʉgʉ limoti aka nɨlɔ mʉmbanzʉ akwanana kakalya ko bulya yihukuso ɔɓɨlɨ kakɨ. ");
INSERT INTO lik_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mʉtʉ wasɨ nɨnɔ ɨmʉkanaga suni ko bulya kamɨ na ko bulya lɨkpʉmʉka kamɨ, ko misa ka ɓatʉ ɓa lɨsyɛ li nɨlɨ, nɨɓɔ ɓa abɛ ɓaɗanda, ɓanyɛ na ɓakamibigʉ gɔnɨ Kunzi. Ɨmɨ, Mika-mʉmbanzʉ amɨnyɨlya ndɛkɛ gɔnɨ suni ɓɛgɛyɔ wa odoku ndɛkɛ mino ka ɨbɨba ka Abakɨ pa imoti na ɓamalaika ɓotu.» ");
INSERT INTO lik_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yeso uɓikyoku ndɨ ɓata ɓɛ: «A lɨngʉnʉ, nakamʉɓɨkya ambɛ, ɓambanzʉ ɓemoti-ɓemoti luga kunu wanʉ, ɓakokwigʉ kanɨ ɓakaninigʉ Ɓʉngama ko Kunzi kodoku no ngu.» ");
INSERT INTO lik_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Kumbusa wa masyɛ maɗɨya, Yeso ava ndɨ Pɛtɛlɛ, Yakɔbɔ na Yuani, ɓaga ndɨ na ɨɓʉ aka ɓɨkɛɗɛ kʉgʉ wa ngʉpa yɨkʉngʉ kʉgbɛ. Kʉ ɓɛyɔ, misa ka Yeso igomosyana ndɨ kambwa kaɓʉ. ");
INSERT INTO lik_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ɓotu kakɨ oɓuɓa ndɨ ɓiwenge-wenge kʉgbɛ. Kɛgʉ na mʉmbanzʉ gʉtʉgʉ ɓemoti aka ka lɨtɔmbʉ lasɨ nɨnɔ akwanana koɓuɓiso ɓotu ɓɛyɔ. ");
INSERT INTO lik_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Kʉwa wa, ɓaɓɨɓya ɓasaa ɓi nɨɓɔ ɓamɨna ndɨ Ɨlɨya na Musa ɓigbututu nɨ ɓananzɨna na Yeso. ");
INSERT INTO lik_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pɛtɛlɛ aka ndɨ na Yeso ɓɛ: «Muwonisilo, a ɓɨnza iɓusu kaiko wanʉ. Topiki ɓangbangba ɓayɨsaa: nɨyɔ kakʉ, nɨyɔ ka Musa na nɨyɔ ka Ɨlɨya.» ");
INSERT INTO lik_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","A ɓɛyɔ, Pɛtɛlɛ a ndɨ kanzɨna nɨ kɛgʉ kaiba ɓɛ akaɓɨkya ɓʉ. Ɨɓʉ na ɓawai-dakɨ ɓaɓa ɓa ndɨ nɨ ɓotumini na ombombo ɓɨɗɛ. ");
INSERT INTO lik_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ɨkʉɓa odoku ndɨ, utikyo ɨɓʉ ɓasɨ na kululuko. Lɨyʉ kotukyoku ka ɨkʉɓa imoti ɓɛnɛ, aɓɨkya ndɨ ɓɛ: «Mikamɨ mʉpaka nɨmʉ. Mumukononi ɨyɨ aka!» ");
INSERT INTO lik_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ko ngbingo yi nɨnɔ aka nɔ, ɓaɓɨɓya ɓɨkwɛkwɛ ndɨ, luki limoti nɨ ɓakaminigʉ ɓata mʉmbanzʉ. A kʉwa ndɨ asɨ Yeso aka mʉkaka pa imoti na ɨɓʉ. ");
INSERT INTO lik_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Nɨyɔ ɓa ndɨ kosyoku ka ngʉpa, Yeso ʉgbɨtyaga ndɨ ɓɛ: «Kpɔkpɔkpɔ, makatumbulyogonɨtɔgʉ mʉmbanzʉ lɨkpʉmʉka li nɨlɔ mini lɔ, kadwɛ kʉ kwa kʉ Mika-mʉmbanzʉ opupo ɓanʉ mino ka mbʉkʉ.» ");
INSERT INTO lik_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ɨɓʉ ɓoɓuulya ndɨ lɨkpʉmʉka li nɨlɔ ka mambɛngɨ aka. Luki limoti, ɓapʉnga ndɨ kauusono ɓɛ: «Ɨsɨ yi zuzuko ka kukwakʉ nɨ ɨkɨ?» ");
INSERT INTO lik_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Kumbuso yi, ɓaɓɨɓya ɓamuusa ndɨ Yeso ɓɛ: «Ko bulya ɨkɨ yɔ ɓowonisilo ɓa mʉtʉʉ ɓaɓɨkyaga mino ɓɛ: ‹Okwononi Ɨlɨya igiku mbɛyɨ?›» ");
INSERT INTO lik_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yeso usikisyoku ndɨ ɓɛ: «A ɓɛyɔ, Ɨlɨya igiku mbɛyɨ, oɓungusyaga makpʉmʉka masɨ. Luki limoti, ko bulya ɨkɨ yɔ ikpikaga gɔnɨ mino ko Moɓiso Motu ɓɛ okwononi Mika-mʉmbanzʉ igyogyisi kʉgbɛ, ɓamɨna payaya? ");
INSERT INTO lik_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Luki limoti, nakamʉɓɨkya ambɛ Ɨlɨya odoniku ndɨ, ɓambanzʉ ɓagya ɓɛyɔ ɓa ndɨ mino kapa, mʉɗɔngɔnɨ ɓɛgɛyɔ Moɓiso ikpikaga ndɨ mino ko bulya kakɨ.» ");
INSERT INTO lik_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Nɨyɔ Yeso pa imoti na ɓaɓɨɓya ɓasaa ɓi nɨɓɔ ɓosila ndɨ ɓuwobi na ɓaɓɨɓya ɓagɔgɔ, ɓamɨna ambaza mudingi ka ɓambanzʉ ukungulini ɓikululu. Ɓowonisilo ɓa mʉtʉʉ ɓɔ ɓa ndɨ na ɨɓʉ ka ɓoɗongoso. ");
INSERT INTO lik_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Nɨyɔ aka yɔ ɓambanzʉ ɓamɨna Yeso, ɓombombaya ndɨ kʉgbɛ, ɓɨnda mbangʉ kamuuso. ");
INSERT INTO lik_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yeso umuusa ndɨ ɓɛ: «Makagya na ɨɓʉ ɓoɗongoso kʉgʉ wa lɨkpʉmʉka tino?» ");
INSERT INTO lik_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Mʉtʉ ɓemoti luga wa ambaza asikisya ndɨ ɓɛ: «Muwonisilo, nudulyiku no mikamɨ mʉlʉkʉ yi nɨnɔ a na lɨmbɛngɨ la ɓʉnyɛ. Lɨmbɛngɨ la ɓʉnyɛ li nɨlɔ aitisoni ɓoɓo. ");
INSERT INTO lik_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ayungogo pa yasɨ, anabʉmya ɓɨngɔmʉ-ngɔmʉ, ofu anatumo ka mʉnɔkʉ ɓɨɗɛ, anɨlya manzʉ, ʉmɨlaga ɓikokolo-kokolo. Nitotonogi ɓi na ɓaɓɨɓya kakʉ ambɛ ɓokpumyinɔ ɓaka lɨmbɛngɨ la ɓʉnyɛ li nɨlɔ, luki limoti ʉgyagya.» ");
INSERT INTO lik_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yeso usikisya ndɨ ɓɛ: «Eeeze iɓunu, lɨvananza la masyɛ mi nɨma makɛgʉ na baya, ma ɓanyɛ! Nakwanana ndɛkɛ kaika pa imoti na iɓunu ɓongbinga ɓɨnga? Nakwanana kapɨla ɓʉzʉ kunu ɓongbinga ɓɨnga? Doku nɛkɨ na ɨyɨ.» ");
INSERT INTO lik_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ɓadulyoku ndɨ na ɨyɨ. Nɨyɔ lɨmbɛngɨ la ɓʉnyɛ li nɨlɔ amɨna Yeso, ayunga ndɨ miki nɔ no ngu, ogwo ɓɨngɔmʉ, okpungbukonogo ɓikpungbulu-kpungbulu kanɨ ofu anapupo ka mʉnɔkʉ. ");
INSERT INTO lik_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yeso amuusa ndɨ abakɨ miki yi nɨnɔ ɓɛ: «Lɨkpʉmʉka li nɨlɨ apʉnga ndɨ na ɨyɨ ngbingo tino?» Asikisya ɓɛ: «Katʉkya ndɨ ka limiki kakɨ aka. ");
INSERT INTO lik_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ngbingo wagɔgɔ, lɨmbɛngɨ la ɓʉnyɛ li nɨlɨ agwisisogo ko ɓuku ikanɨ ko liɓo kakɨsa kamwɔ. Luki limoti, kika nɨ wakwananatʉ kagya luki, kikiliki, tisingyanɔ ɓaka!» ");
INSERT INTO lik_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yeso aɓɨkya ndɨ ɓɛ: «Ko bulya ɨkɨ yɔ woɓikyi mina ɓɛ: ‹Kika nɨ wakwananatʉ kagya luki?› Kunzi akwanana kagya makpʉmʉka masɨ ka mʉtʉ nɨnɔ a na baya kʉ kakɨ.» ");
INSERT INTO lik_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Wa aka wa, abakɨ miki nɔ aɓɨkya ndɨ na lɨyʉ lapʉ ɓɛ: «Noɓinikyonini! Isingyanɔ ɓaka kyɛ baya kamɨ a yɨkɛɗɛ!» ");
INSERT INTO lik_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Nɨyɔ Yeso ɨna ɓɛ ambaza mudingi ka ɓambanzʉ okomumukonoku aka, apamɨlya kʉwa ndɨ lɨmbɛngɨ la ɓʉnyɛ li nɨlɔ, aɓɨkya ɓɛ: «Lɨmbɛngɨ la ɓʉnyɛ li nɨlɔ aitisogo ɓoɓo ikanɨ adʉka, pupo kʉsɔ ka ɓomikya-ɓalʉkʉ yi nɨmʉ, wakamigilyonitɔgʉ ndɛkɛ ɓata!» ");
INSERT INTO lik_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Lɨmbɛngɨ la ɓʉnyɛ li nɨlɔ apamɨkana ndɨ, ayungo ɓata miki nɔ no ngu kʉgbɛ, apupo kʉwa ndɨ. Miki aka ndɨ ɓɨkpɔngbɔmʉ. Ɓambanzʉ ɓudingi aka ndɨ ɓɛ: «okwini.» ");
INSERT INTO lik_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Luki limoti, Yeso agwi ndɨ kʉɓɔkʉkɔ, amomoso, miki aka ndɨ ɓɨgba. ");
INSERT INTO lik_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Nɨyɔ Yeso ingyo ka ndaɓʉ, ɓaɓɨɓya kakɨ ɓamuusa ndɨ nɨ ɓitini na ɨɓʉ ɓɨkɛɗɛ ɓɛ: «Ko bulya ɨkɨ yɔ iɓusu takokwononigʉ ɓi kokpumyo lɨmbɛngɨ la ɓʉnyɛ li nɨlɔ?» ");
INSERT INTO lik_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yeso usikisya ndɨ ɓɛ: «Ɓakwanana kokpumyo inguo ya lɨmbɛngɨ la ɓʉnyɛ li nɨlɔ pisi ka malʉmba aka.» ");
INSERT INTO lik_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yeso na ɓaɓɨɓya kakɨ ɓatʉkya ndɨ wa, ɓakɨtanaga ka iwili ya Galilaya. Kɛgʉ ndɨ kapa ɓɛ mʉmbanzʉ ibito pa nɨyɔ a ndɨ mino. ");
INSERT INTO lik_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","A ɓɛyɔ, a ndɨ kaʉpá ɓaɓɨɓya kakɨ mʉtʉʉ ɓɛ: «Ɓasʉtatʉ ɓanʉ Mika-mʉmbanzʉ ka maɓɔkʉ ka ɓambanzʉ. Ɓamwɔ, masyɛ masaa kumbusa wa kukwakʉ kakɨ, opupoku ka mbʉkʉ.» ");
INSERT INTO lik_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Luki limoti, ɓaɓɨɓya ɓakɛgʉ ndɨ kotombisyo isi ya mʉnzɨna mi nɨmɔ, ɓanaɓanga kamuuso. ");
INSERT INTO lik_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Yeso na ɓaɓɨɓya kakɨ ɓosila kʉwa ndɨ ka Kapɛlɛnaumu. Ngbingo yi nɨnɔ ɓa ndɨ mino ka ndaɓʉ, Yeso umuusa ndɨ ɓɛ: «Mo ɓi kagya ɓoɗongoso kʉgʉ wo luki tino ko pisi?» ");
INSERT INTO lik_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Luki limoti, ɓaɓɨɓya ɓadakyana ndɨ ɓiwo. A ɓɛyɔ, ɓa ndɨ kagya ɓoɗongoso ko pisi kakɨsa kaiba ɓɛ wanɨ nɔ a mʉtʉ wa ɨbɨba kʉgbɛ. ");
INSERT INTO lik_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Kʉwa wa, Yeso ika ndɨ, ʉmaka ɓaɓɨɓya kakɨ tɛkɛɓɛ na ɓaɓa, ʉɓɨkya ɓɛ: «Mʉtʉ kapa kaika wa mambwa, okwononi iki mʉtʉ wa muliɓo ka ɓatʉ ɓasɨ, ika gɔnɨ mʉgya-ligubo kaɓʉ.» ");
INSERT INTO lik_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Kumbuso yi, ava ndɨ miki, abisa luga kaɓʉ. Nɨyɔ adungo, ʉɓɨkya ndɨ ɓaɓɨɓya kakɨ ɓɛ: ");
INSERT INTO lik_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Mʉtʉ nɨnɔ atɨlya miki abɛ nɨmʉ ko lino kamɨ, etilyi ɨmɨ ɓɨkpɛ. Na nɨnɔ akɛtɨlya, ketilyigʉ ɨmɨ aka, luki limoti, atilyi nɨnɔ etikoku ndɨ.» ");
INSERT INTO lik_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Kʉwa wa, Yuani aɓɨkya ndɨ Yeso ɓɛ: «Muwonisilo, tamini ɓi mʉtʉ ɓemoti kokpumya mambɛngɨ ma ɓʉnyɛ ko lino kakʉ. To ɓi kapa kapakya kyɛ kɛgʉ ka mʉɗɔngɔ kusu.» ");
INSERT INTO lik_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Luki limoti, Yeso asikisya ndɨ ɓɛ: «Makapokyonitɔgʉ, kyɛ kɛgʉ na mʉtʉ gʉtʉgʉ ɓemoti aka nɨnɔ akwanana kagya lɨkpʉmʉka lɨmbanga ko lino kamɨ, kumbuso yi ɛnzɨnɨlya yanyɛnyɛ. ");
INSERT INTO lik_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","A ɓɛyɔ, mʉtʉ yi nɨnɔ kɛgʉ mumuyoniso kusu, a wai-dosu. ");
INSERT INTO lik_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Na mʉtʉ wasɨ nɨnɔ amʉpá ndɛkɛ gʉtʉgʉ kɔpɔ yo liɓo aka kyɛ ma ɓatʉ ka Kilisito, a lɨngʉnʉ, nakamʉɓɨkya ambɛ, mʉtʉ yi nɨnɔ inisanatʉ ndɛkɛ na mʉkalya kakɨ.» ");
INSERT INTO lik_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Yeso aɓɨkya ndɨ ɓɛ: «Mʉmbanzʉ kamokyisiso ɓemoti ka ɓomiki nɨɓɔ ɓɛɓɨnɨkyana ka ɓʉnyɛ, okwononi kakpɨkɨla lɨtalʉ lakpʉ ko singasʉ, ɓaɗɨkɨta ko liɓa lidingi ɓikudumu. ");
INSERT INTO lik_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Kika nɨ kʉɓɔkʉkɔ umokyini ka ɓʉnyɛ, kɔ. A ɓɨnza kʉgbɛ ɨwɛ kogulya ka ɔɓɨlɨ walɨngʉnʉ na kʉɓɔkʉkɔ kumuti kakɨtaga wa wogulyo ɓi mino nomu masɨ. Kumbuso yi, wɨnda kʉwa ko ɓuku ɓa ɓɛnzɛ na ɓɛnzɛ, ko ɓuku nɨɓɔ kolimikigʉ ndɛkɛ. ");
INSERT INTO lik_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Kʉ ɓɛyɔ, a na ɓatʉtʉ nɨɓɔ ɓʉlyaga ɓambanzʉ, ɓakokwogigʉ. A gɔnɨ no ɓuku nɨɓɔ kolimikigʉ ndɛkɛ. ");
INSERT INTO lik_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Kika nɨ kʉgʉkɔ umokyini ka ɓʉnyɛ, kɔ. A ɓɨnza kʉ kakʉ kogulya ka ɔɓɨlɨ walɨngʉnʉ na kʉgʉkɔ kumuti kakɨtaga wa wogulyo ɓi mino nomu masɨ. Kumbuso yi, ɓʉɗɨkɨta kʉwa ko ɓuku ɓa ɓɛnzɛ na ɓɛnzɛ. ");
INSERT INTO lik_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Kʉ ɓɛyɔ, a na ɓatʉtʉ nɨɓɔ ɓʉlyaga ɓambanzʉ, ɓakokwogigʉ. A gɔnɨ no ɓuku nɨɓɔ kolimikigʉ ndɛkɛ. ");
INSERT INTO lik_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Kika nɨ liso umokyini ka ɓʉnyɛ, muko. A ɓɨnza kʉ kakʉ kogulya ka Ɓʉngama ko Kunzi no liso limoti kakɨtaga wa wogulyo ɓi mino nomu masɨ. Kumbuso yi, ɓʉɗɨkɨta ko ɓuku ɓa ɓɛnzɛ na ɓɛnzɛ. ");
INSERT INTO lik_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Kʉ ɓɛyɔ, ‹a na ɓatʉtʉ nɨɓɔ ɓʉlyaga ɓambanzʉ, ɓakokwogigʉ. A gɔnɨ no ɓuku nɨɓɔ kolimikigʉ ndɛkɛ.› ");
INSERT INTO lik_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","A ɓɛyɔ, ɓakongogo ndɛkɛ mʉtʉ yɨkaka-yɨkaka ko ɓuku mʉɗɔngɔnɨ ɓɛyɔ ɓoɓungusyogo mino malɨlɨ na liniko. ");
INSERT INTO lik_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Liniko a luki lanza. Luki limoti, liniko kandapamanaga, luki tino ɓata lɔ akwanana kondingimosogo? Wikoni na liniko kʉsɔ kunu, mika na mazɨyɔ luga kunu.» ");
INSERT INTO lik_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Nɨyɔ Yeso atʉkya ndɨ mino wa, aga ka iwili ya Yudɛa, azaba ndɨ kʉsyakʉ wagɔgɔ wa Yɔlɔdanɨ. Ɓambaza ka ɓambanzʉ ɓamʉmʉkana ɓata ndɨ ka kpɔlɔ kakɨ, apʉnga kaʉpá mʉtʉʉ mʉɗɔngɔnɨ ɓɛyɔ agyaga ndɨ mino. ");
INSERT INTO lik_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ɓafalisayɔ ɓemoti-ɓemoti ɓodoku ndɨ kaɓɔɓɔ na mʉnzɨna, ɓamuusa ɓɛ: «Ambɛ, mʉtʉʉ kusu akpamyatʉ mʉlʉkʉ kasikisa mukakɨ?» ");
INSERT INTO lik_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yeso usikisya ndɨ ɓɛ: «Mʉtʉʉ tino sɛ mbɛyɨ mɔ Musa amʉpá ndɨ?» ");
INSERT INTO lik_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ɨɓʉ aka ndɨ na ɨyɨ ɓɛ: «Musa atɨpá ndɨ mʉtʉʉ ɓɛ mʉlʉkʉ akpikogi balʉwa musikisa muko, kumbuso yi, akpumyo sɛ kʉwa.» ");
INSERT INTO lik_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yeso ʉɓɨkya ndɨ ɓɛ: «Amukpikilya ndɨ mʉtʉʉ mi nɨmɔ ɓɛyɔ ko bulya ɓʉpʉ ɓa mambɛngɨ kunu. ");
INSERT INTO lik_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Luki limoti, katʉkya ndɨ ka mʉpʉnganagɨ, ngbingo yi nɨnɔ Kunzi a ndɨ mino kagya ɔɓɨlɨ, agya ndɨ mʉlʉkʉ na muko. ");
INSERT INTO lik_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‹Kinili, mʉlʉkʉ asaga ndɛkɛ abakɨ na amakɨ, ɓika kʉwa pa imoti na mukakɨ, ");
INSERT INTO lik_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ɨɓʉ ɓasɨ ɓaɓa ɓɨɨta nzʉyɨ yimoti.› Kʉwa wa, ɓakikigʉ ɓata ɓaɓa, luki limoti, nzʉyɨ imoti aka. ");
INSERT INTO lik_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Yɛkɨ a ɓɛyɔ, mʉmbanzʉ kogbonosonitɔgʉ nɨlɔ Kunzi omotoni.» ");
INSERT INTO lik_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Nɨyɔ ɓogulya ka ndaɓʉ, ɓaɓɨɓya ɓamuusa ɓata ndɨ Yeso lɨkpʉmʉka li nɨlɔ. ");
INSERT INTO lik_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ɨyɨ aka ndɨ na ɨɓʉ ɓɛ: «Mʉmbanzʉ kasikisa mukakɨ, ava wagɔgɔ, iba ogyini ɓɨlya. ");
INSERT INTO lik_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Muka wasɨ katʉkya mbʉnyakɨ, avyɛ, iba ogyini gɔnɨ ɓɨlya.» ");
INSERT INTO lik_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ɓambanzʉ ɓemoti-ɓemoti ɓadulyoku ndɨ Yeso na ɓomiki ɓɛ ubisilyi maɓɔkʉ. Luki limoti, ɓaɓɨɓya ɓʉnyakɨlya ndɨ. ");
INSERT INTO lik_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Nɨyɔ Yeso ɨna ɓɛyɔ, lɨmbɛngɨ atʉla ndɨ, ʉɓɨkya ɓaɓɨɓya kakɨ ɓɛ: «Husoni ɓomiki ɓoduku kʉnʉ no mino! Makupokyonitɔgʉ, kyɛ Ɓʉngama ko Kunzi a ko bulya ka ɓatʉ ɓi nɨɓɔ ɓa abɛ ɨɓʉ. ");
INSERT INTO lik_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","A lɨngʉnʉ, nakamʉɓɨkya ambɛ, mʉtʉ wasɨ nɨnɔ kabaɨlyagɨgʉ Ɓʉngama ko Kunzi mʉɗɔngɔnɨ abɛ miki mʉkɛɗɛ, kakwananɨgʉ ndɛkɛ kogulya mino.» ");
INSERT INTO lik_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Kumbuso yi, udungaga ndɨ ɓomiki ɓɔ, ubisilya maɓɔkʉ, uɗukilya ɓʉɓʉnga. ");
INSERT INTO lik_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Nɨyɔ Yeso atʉkɨlya ndɨ lɨgʉndʉ, alʉkʉ ɓemoti adulyoku ndɨ mbangʉ, ogwa na moli kambwa kakɨ, amuusa ɓɛ: «Muwonisilo wanza, nakwanana pɨyɛ kagya ɓʉnɨ kainisono na ɔɓɨlɨ wa ɓɛnzɛ na ɓɛnzɛ?» ");
INSERT INTO lik_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Asikisya ndɨ ɓɛ: «Ko bulya ɨkɨ yɔ wo mino kɛmaka ɓɛ mʉtʉ wanza? Mʉmbanzʉ gʉtʉgʉ ɓemoti aka kɛgʉ wanza kiki nɨ Kunzi aka mʉkaka. ");
INSERT INTO lik_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Wibagatʉ mʉtʉʉ nɨma: ‹Wakamwonitɔgʉ mʉmbanzʉ, wakogyonitɔ ɓɨlya, wakiɓonitɔgʉ, wakaɓukulyogonitɔgʉ mʉmbanzʉ lɨkpʉmʉka, wakagyilyonitɔgʉ mʉmbanzʉ ɓʉnyɛ, mʉɓanga abakʉ na amakʉ.›» ");
INSERT INTO lik_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Alʉkʉ yi nɨnɔ asikisya ndɨ ɓɛ: «Muwonisilo, nagyaga mʉtʉʉ mi nɨmɔ masɨ katʉkya ndɨ ka limiki kamɨ.» ");
INSERT INTO lik_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yeso anda ndɨ ɓizumuuu, na sɨpananɨsɔ sasɨ aɓɨkya ɓɛ: «Uɓwi luki limoti aka: waga, wagaba makpʉmʉka kakʉ masɨ. Ʉgbananɨlyaga ɓatʉ ɓa yangya ɓuyi ɓi. Kʉwa wa, winisana ndɛkɛ na lɨngama kʉgʉ wa lɨsyɛ. Kumbuso yi doku, weɓyoku.» ");
INSERT INTO lik_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Luki limoti, wa alʉkʉ nɔ ʉkana mino ɓɛyɔ, alya ndɨ kumbu, aga nɨ ongbutini ɓikpu kyɛ a ndɨ na lɨngama lidingi. ");
INSERT INTO lik_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yeso ʉnda ndɨ ɓaɓɨɓya kakɨ nɨɓɔ ɓa ndɨ nɨ ɓakungulini ɓizumuuu, ʉɓɨkya ɓɛ: «A yapʉpʉ ka ɓatʉ nɨɓɔ ɓa na mukumbo kogulya ka Ɓʉngama ko Kunzi!» ");
INSERT INTO lik_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ɓaɓɨɓya ɓombombaya ndɨ ngbingo yi nɨnɔ ɓʉkana mino mʉnzɨna mi nɨmɔ. Luki limoti, Yeso uɓikyoku ɓata ɓɛ: «Ɓomikamɨ, a yapʉpʉ kogulya ka Ɓʉngama ko Kunzi! ");
INSERT INTO lik_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","A yapʉpʉ ka ngamia kakɨtanaga ka ngala ya mʉsaɗa. Luki limoti, a ɓata yapʉpʉ kʉgbɛ ka mʉtʉ wa lɨngama kogulya ka Ɓʉngama ko Kunzi.» ");
INSERT INTO lik_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Nɨyɔ ɓaɓɨɓya ɓʉkana ɓɛyɔ, ɓombomboyo ɓata ndɨ kʉgbɛ, ɓanuusana ɓɛ: «Wanɨ sɛ kʉwa nɔ akwanana kainisa na muhukuso?» ");
INSERT INTO lik_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yeso ʉnda ndɨ ɓizumuu, ʉɓɨkya ɓɛ: «Luki nɨlɔ ɓambanzʉ ɓakakwananɨgʉ kagya gʉtʉgʉ iki yi aka, Kunzi agyatʉ ɨyɨ, kyɛ kɛgʉ no luki gʉtʉgʉ limoti aka nɨlɔ agyagya Kunzi.» ");
INSERT INTO lik_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Kʉwa wa, Pɛtɛlɛ aɓɨkya ndɨ ɓɛ: «Iɓusu, tosoni ndɨ masɨ, tapʉnga kaʉɓɨɓya.» ");
INSERT INTO lik_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yeso asikisya ɓɛ: «A lɨngʉnʉ, nakamʉɓɨkya ambɛ, mʉmbanzʉ kasa ndaɓʉ kakɨ, ʉsa ɓamamakɨ, ʉsa ɓasalɨ kakɨ, asa amakɨ ikanɨ abakɨ, ʉsa ɓomikakɨ ikanɨ ɓotiko kakɨ ko bulya kamɨ, na ko bulya Mongoni Manza, ");
INSERT INTO lik_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","katʉkya mbɨya wanʉ, mʉtʉ yi nɨnɔ inisana na ɓandaɓʉ, ɓamamakɨ, ɓasalɨ, ɓamakɨ, ɓomiki na ɓotiko kakɨtaga nganga mɨya imoti, pa imoti na igyogyiso gɔnɨ. Na ka masyɛ nɨmɔ akodoku, inisana ndɛkɛ na ɔɓɨlɨ wa ɓɛnzɛ na ɓɛnzɛ. ");
INSERT INTO lik_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Luki limoti, ɓatʉ ɓudingi nɨɓɔ ɓa kambwa ɓika ndɛkɛ kumbuso, na nɨɓɔ ɓudingi ɓa kumbuso ɓika kʉwa ndɛkɛ kambwa.» ");
INSERT INTO lik_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ngbingo yi nɨnɔ Yeso na ɓaɓɨɓya kakɨ ɓa ndɨ mino ko pisi kaɗaka ka Yelusalɛma, ɨyɨ, a ndɨ kakpakyana kambwa kaɓʉ. Ɓaɓɨɓya ɓa ndɨ kombomboyo, na ɓatʉ nɨɓɔ ɓa ndɨ kaʉɓɨɓya ɓa ndɨ na kʉɓangakʉ. Yeso akɨɗa ndɨ ka kpɔlɔ na ɓaɓɨɓya tɛkɛɓɛ na ɓaɓa, apʉnga kaʉtʉmbʉlyaga nɨlɔ asilyo ɓanʉ. ");
INSERT INTO lik_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ɨyɨ aka ndɨ na ɨɓʉ ɓɛ: «Takaɗaka ka Yelusalɛma. Kʉ ɓɛyɔ, ɓasʉtatʉ Mika-mʉmbanzʉ ka ɓokumu-kumu na ka ɓowonisilo ɓa mʉtʉʉ. Ɨɓʉ, ɓaɓɨkya ɓanʉ ɓɛ ɓamwɨ, ɓasʉta ka maɓɔkʉ ka ɓatʉ nɨɓɔ ɓakamibigʉ Kunzi. ");
INSERT INTO lik_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ɓatʉ ɓi nɨɓɔ ɓatɨba ɓanʉ ɓɨkyaaa, ɓaɓakyaga na ɓotikito, ɓatɨna pimbo, ɓamwɔ. Luki limoti, kumbusa wa masyɛ masaa, opupoku ka mbʉkʉ.» ");
INSERT INTO lik_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Kumbuso yi, ɓomika Zɛbɛdayɔ ɓaɓa ɓɛyɔ ka Yakɔbɔ na Yuani, ɓakpuɗoku ndɨ Yeso, ɓaɓɨkya ɓɛ: «Muwonisilo, to ɓi kapa ambɛ tɨgyɨlya nɨlɔ takaʉkʉnga.» ");
INSERT INTO lik_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yeso umuusa ndɨ ɓɛ: «Makapa ɓɛ namʉgyɨlyɨ ɨkɨ?» ");
INSERT INTO lik_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ɨɓʉ aka ndɨ na ɨyɨ ɓɛ: «Takapa ambɛ ko ngbingo yi nɨnɔ wika ɓanʉ mino ka ɨbɨba kakʉ, tilikiso ɓuwobi na ɨwɛ, mʉtʉ ɓemoti ka kʉmbanzɨkanɨkɔ kakʉ, wagɔgɔ ka kulekuke.» ");
INSERT INTO lik_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Luki limoti, Yeso ʉɓɨkya ndɨ ɓɛ: «Makɛgʉ kaiba nɨlɔ makɛkʉnga. Makwananatʉ kamwo kɔpɔ wa yigyogyiso nɨnɔ namwo ɓanʉ? Ikanɨ kogwo inguo ya iɓatiso nɨyɔ, ɨmɨ, nogwa ɓanʉ?» ");
INSERT INTO lik_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ɓasikisya ndɨ ɓɛ: «Iyo, takwananatʉ.» Yeso ʉɓɨkya ndɨ ɓɛ: «Makwananatʉ kamwo kɔpɔ wa yigyogyiso yi nɨnɔ, mogwa inguo ya iɓatiso yi nɨyɔ, ɨmɨ, nogwo. ");
INSERT INTO lik_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Luki limoti, ka nɨlɔ o ndɨ kalikiso mʉmbanzʉ ka kumbanzɨkanɨkɔ ikanɨ ka kulekuke kamɨ, kɛgʉ ligubo kamɨ. Ɓapa nɨɓayɔ a ko bulya ka ɓatʉ nɨɓɔ ɓuɓungusilyaga ndɨ.» ");
INSERT INTO lik_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Nɨyɔ ɓaɓɨɓya ɓagɔgɔ tɛkɛɓɛ ɓʉkana mino ɓɛyɔ, mambɛngɨ ʉtʉla ndɨ na Yakɔbɔ ɨɓʉ na Yuani. ");
INSERT INTO lik_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yeso ʉmaka kʉwa ndɨ ɓasɨ, ʉɓɨkya ɓɛ: «Mibagatʉ ɓɛ ɓangama ɓakpʉkpʉ ɓa ɓɛvananza ɓa ɔɓɨlɨ yi nɨmʉ ɓatɨwaga ɓɛvananza kaɓʉ na mʉpamʉ. Ɓatʉ ɓakpʉkpʉ ɓʉɗɨtaga ɓatʉ ɓagɔgɔ na ɓʉngama kaɓʉ ɓɨnvɨ. ");
INSERT INTO lik_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Luki limoti, kikonitɔgʉ ɓɛyɔ luga kunu. Ɓemoti kunu kapa kaiko mʉtʉ wa ɨbɨba, okwononi iki mʉgya-ligubo kunu. ");
INSERT INTO lik_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Mʉmbanzʉ kapa kaiko wa mambwa luga kunu, okwononi iki musunzu ka ɓatʉ ɓasɨ. ");
INSERT INTO lik_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","A ɓɛyɔ, Mika-mʉmbanzʉ kodokugʉ ndɨ kyɛ ɓiki kagugubyo. Luki limoti, odoku ndɨ kaugugubyo ɓambanzʉ, kapá ɔɓɨlɨ kakɨ abɛ mʉkalya kaʉkʉlaga ɓatʉ ɓudingi ka ɓʉnyɛ.» ");
INSERT INTO lik_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Kʉwa wa, Yeso na ɓaɓɨɓya kakɨ ɓosila ndɨ ka Yeliko. Wa ɓa ndɨ mino kʉwa kopupa ka gʉɗʉ yi nɨnɔ pa imoti na ambaza mudingi ka ɓambanzʉ, mʉtʉ ɓemoti wo koloɓu ya mamɔmɔ a ndɨ wakiko ka kpɔlɔ wo pisi, anɨkʉkʉngya. Mʉtʉ yi nɨnɔ ina ndɨ ɓɛ Balatimayɔ, mika Tɨmayɔ. ");
INSERT INTO lik_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nɨyɔ ʉkana ɓɛ Yeso wa Nazalɛtɨ nɔ, apʉnga ndɨ kapamɨkanaga ɓɛ: «Yeso, Mika ngama Daudi, ikwilyanɔ ɓaka kumbu!» ");
INSERT INTO lik_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ɓambanzʉ ɓudingi ɓanyakɨlyaga ndɨ ɓɛ adakɨ. Luki limoti, apamɨkanaga kʉwa ɓata ndɨ kʉgbɛ ɓɛ: «Mika ngama Daudi, ikwilyanɔ ɓaka kumbu!» ");
INSERT INTO lik_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yeso amaga ndɨ, aɓɨkya ɓɛ: «Mumokoni.» Ɓamaka kʉwa ndɨ, ɓaɓɨkya ɓɛ: «Wika kʉwa na lɨlʉkʉ aka! Wamaga, akaʉmaka!» ");
INSERT INTO lik_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Kʉwa wa, ambimba ndɨ koti kakɨ, atʉkya ɓɨɗafa, aga kʉ Yeso a ndɨ mino. ");
INSERT INTO lik_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yeso amuusa ndɨ ɓɛ: «Wakapa ɓɛ nʉgyɨlyɨ ɨkɨ?» Ɨyɨ aka na ɨyɨ ɓɛ: «Muwonisilo, nakapa ambɛ napʉngɨ ɓata kaɨna.» ");
INSERT INTO lik_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yeso aɓɨkya ndɨ ɓɛ: «Waga, baya kakʉ uhukusini.» Alʉkʉ nɔ apʉnga ɓata ndɨ kaɨna wa ka wa, apʉnga kʉwa kaɓɨɓya Yeso. ");
INSERT INTO lik_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yeso na ɓaɓɨɓya kakɨ ɓa kʉwa ndɨ ɓuwobi kadwɛ ka Yelusalɛma, misa yo giyo ya Bɛtɛfagɨ na Betania, ɓuwobi na Ngʉpa ya Mizeituni. Kʉwa wa, Yeso ʉtɨka ndɨ ɓaɓɨɓya ɓaɓa kambwa luga ka ɓaɓɨɓya kakɨ, ");
INSERT INTO lik_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ʉɓɨkya ɓɛ: «Windoni ka mugi nɨmana a kambwa kunu ma. Nɨyɔ aka yɔ mosilo, matakanya mikya punda mʉkandɨla wa, nɨnɔ mʉmbanzʉ gʉtʉgʉ ɓemoti aka kanoɗokigʉ mino. Mukuloniku, modoku na ɨyɨ kʉnʉ. ");
INSERT INTO lik_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Mʉmbanzʉ kamumuusa ɓɛ: ‹Ko bulya ɨkɨ yɔ mo mino kagya bɛyɔ?› Musikisyoni ɓɛ: ‹Mombukwono-dosu a no nzoyi yi, luki limoti, kolipyigʉ na ɨyɨ, amigisokuto.›» ");
INSERT INTO lik_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ɓaɓɨɓya ɓaɓa ɓi nɨɓɔ ɓaga kʉwa ndɨ, ɓatakanya mikya punda mʉkandɨla kunzi, ɓuwobi na mupumi ma ndaɓʉ ka kpɔlɔ wo pisi. Ɓakʉla ndɨ. ");
INSERT INTO lik_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ɓatʉ ɓemoti-ɓemoti nɨɓɔ ɓa ndɨ wa, ɓumuusa ndɨ ɓɛ: «Ɨkɨ yɔ makagya yɔ? Ko bulya ɨkɨ yɔ ma mino kakʉla?» ");
INSERT INTO lik_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ɓusikisya ndɨ mʉɗɔngɔnɨ ɓɛyɔ Yeso ʉɓɨkya ndɨ mino. Ɓatʉ ɓi nɨɓɔ ɓʉsa ndɨ kaaga na ɨyɨ. ");
INSERT INTO lik_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ɓadulyoku ndɨ Yeso no mikya punda nɔ, ɓolosogo ɓotu kaɓʉ kʉgʉ yi, ika mino. ");
INSERT INTO lik_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ɓambanzʉ ɓakpʉ ɓa ndɨ koolosogo ɓotu kaɓʉ ko pisi, ɓagɔgɔ ɓanolosogo mangʉ ma masɨsɨ nɨmɔ ɓakɔgɔ ndɨ ka ɓotiko. ");
INSERT INTO lik_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ɓatʉ nɨɓɔ ɓa ndɨ kakpakyana kambwa na kumbuso ka Yeso ɓapʉnga ndɨ kapamɨkanaga ɓɛ: «Kunzi avɨ ɨbɨba! Kunzi aɗukulyi ɓʉɓʉnga nɨnɔ akodoku ko lino ka Mombukwono-dosu! ");
INSERT INTO lik_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Kunzi oɗuki ɓʉɓʉnga ka ɓʉngama nɨɓɔ akodoku, ɓʉngama ka titosu ɓɛyɔ ka Daudi! Kunzi nɨnɔ kʉgʉ kʉgbɛ avɨ ɨbɨba!» ");
INSERT INTO lik_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yeso osila kʉwa ndɨ ka Yelusalɛma, ogulyo ka Ndaɓʉ ko Kunzi. Kʉ ɓɛyɔ, oyikanaga ndɨ, ɨna makpʉmʉka masɨ, opupo. A kʉwa ndɨ ɓʉgɔgɔ, aga pa imoti na ɓaɓɨɓya tɛkɛɓɛ na ɓaɓa miso ya Betania. ");
INSERT INTO lik_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ɓʉgala ɓi, wa ɓa ndɨ mino katʉkya ka Betania, Yeso ɨmʉkana ndɨ nza. ");
INSERT INTO lik_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ɨna ndɨ ɓyɨ sɨbʉkʉsɔ simoti ɓɛnɛ opiyoni mapakʉ ɓipi. Aga ndɨ kaanda anasɨma ɓɛ akwananatʉ kaɨna bumo kʉgʉ yi. Luki limoti, nɨyɔ osila kʉwa ndɨ ɓuwobi nosu, atakanya asɨ mapakʉ aka. A ɓɛyɔ, kɛgʉ ndɨ ko ngbingo wo bumo yi. ");
INSERT INTO lik_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Kʉwa wa, Yeso agbanga ndɨ sɨbʉkʉsɔ si nɨsɔ ɓɛ: «Katʉkya na lɨsyɛ li nɨlɨ, mʉmbanzʉ kalyɨgʉ ndɛkɛ ɓata bumo kakʉ!» Ɓaɓɨɓya kakɨ ɓʉkana ndɨ lɨkpʉmʉka li nɨlɔ. ");
INSERT INTO lik_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Kumbuso yi, ɓosila ndɨ ka Yelusalɛma. Nɨyɔ Yeso ogulyo ka Ndaɓʉ ko Kunzi, apʉnga ndɨ kaukpumya ɓatʉ nɨɓɔ ɓa ndɨ kagaba na nɨɓɔ ɓa ndɨ koluwo kʉ ɓɛyɔ. Utindikaga ndɨ ɓamɨza ka ɓatʉ nɨɓɔ ɓa ndɨ kogomosyono ɓuyi, na ɓokiti ka nɨɓɔ ɓa ndɨ kaʉgaba ɓonzuwo. ");
INSERT INTO lik_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ʉpakya ndɨ gɔnɨ ɓatʉ ɓa likumbogi kakɨtanaga nolu ka pa yangba ya Ndaɓʉ ko Kunzi. ");
INSERT INTO lik_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Kumbuso yi, ʉpá ndɨ mʉtʉʉ ɓɛ: «Kunzi aɓɨkya ndɨ ɓɨngbanganya ka Moɓiso kakɨ ɓɛ: ‹Ɓalɨkyaga ndɛkɛ ndaɓʉ kamɨ ɓɛ ndaɓʉ ya malʉmba ka ɓɛvananza ɓayasɨ.› Luki limoti, iɓunu moitisini kʉwa pa ya kɨsʉma ka ɓatʉ ɓo kuɓakʉ!» ");
INSERT INTO lik_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ngbingo yi nɨnɔ ɓokumu-kumu na ɓowonisilo ɓa mʉtʉʉ ɓʉkana ndɨ mino lɨkpʉmʉka nɨlɔ ɓɛyɔ, ɓapʉnga ndɨ kakɨsa ɓɛ ɓamwɔ sɛ pɨyɛ no pisi tino. A ɓɛyɔ, ɓa ndɨ kaɓanga kyɛ mʉtʉʉ kakɨ a ndɨ kaʉmbanga ɓatʉ ɓasɨ. ");
INSERT INTO lik_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Nɨyɔ ɓʉgɔgɔ ogwo, Yeso na ɓaɓɨɓya kakɨ ɓopupa ndɨ ka Yelusalɛma. ");
INSERT INTO lik_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ɓʉgalo ɓi na ɓʉsɔɓɨ, ngbingo yi nɨnɔ ɓa ɓata ndɨ mino kakɨtaga ko pisi yi nɨyɔ, ɓɨna ndɨ sɨbʉkʉsɔ si nɨsɔ kʉwa sikwo kadwɛ kʉ kwa kʉ ko lyo. ");
INSERT INTO lik_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pɛtɛlɛ atamana nɨlɔ okitogi ɓi, aɓɨkya Yeso ɓɛ: «Muwonisilo, wɨna sɨbʉkʉsɔ si nɨsɔ wogbongi ɓi kʉ okwi mino.» ");
INSERT INTO lik_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yeso ʉɓɨkya kʉwa ndɨ ɓaɓɨɓya kakɨ ɓɛ: «Muboilyoni Kunzi. ");
INSERT INTO lik_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","A lɨngʉnʉ, nakamʉɓɨkya ambɛ, mʉtʉ yi nɨnɔ aɓɨkya ngʉpa yi nɨyɨna ɓɛ: ‹Mukuko, wiɗikitoku ko liɓo lidingi›, nɨ kɛgʉ na ɓotumo ka lɨmbɛngɨ, kika na baya ɓɛ lɨkpʉmʉka nɨlɔ igyonosatʉ, Kunzi agyɨlyatʉ. ");
INSERT INTO lik_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kinili, nakamʉɓɨkya ambɛ, luki lasɨ nɨlɔ makʉngaga, wikoni na baya ɓɛ minisonini nolu. Kunzi amʉpátʉ. ");
INSERT INTO lik_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ngbingo yi nɨnɔ momogi mino kalʉmba, makika na lɨkpʉmʉka na mʉmbanzʉ, mapɨlya, kyɛ Obonu nɨnɔ kʉgʉ wa lɨsyɛ amʉpɨlyɨtɔ gɔnɨ ɓʉnyɛ kunu.  ");
INSERT INTO lik_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Luki limoti, makupilyogi ɓɛngɛnɨ, Obonu nɨnɔ kʉgʉ wa lɨsyɛ kamʉpɨlyɨgʉ ndɛkɛ ɓɛgɛyɔ.» ");
INSERT INTO lik_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yeso na ɓaɓɨɓya kakɨ ɓigoku ɓata ndɨ ka Yelusalɛma. Wa a ndɨ mino kakpakyana ka Ndaɓʉ ko Kunzi, ɓokumu-kumu, ɓowonisilo ɓa mʉtʉʉ na ɓambɔkʉ-mbɔkʉ ɓakpuɗoku ndɨ, ");
INSERT INTO lik_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ɓamuusa ɓɛ: «Wakagya makpʉmʉka mi nɨmana no ngu tino? Wanɨ nɔ ʉpá ndɨ ngu kagya yi?» ");
INSERT INTO lik_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yeso usikisya ndɨ ɓɛ: «Ɨmɨ, nakamumuuso lɨkpʉmʉka limoti aka. Isikisyoni, namʉtʉmbʉlyaga kʉwa ɓɛ nakagya no ngu ka wanɨ. ");
INSERT INTO lik_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Iɓatiso ka Yuani apʉnya kʉgʉ wa lɨsyɛ ikanɨ ka ɓambanzʉ? Isikisyoni.» ");
INSERT INTO lik_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Luki limoti, ɓapʉnga ndɨ kaɨnzɨnzɨnya luga kaɓʉ, ɓanaɓɨkya ɓɛ: «Takosikisyo ɓɛ apʉnya kʉgʉ wa lɨsyɛ,» atimuusatʉ ɓɛ: «Yɛkɨ a ɓɛyɔ! Ko bulya ɨkɨ yɔ makaɓɨnɨkyanagʉ ndɨ lɨkpʉmʉka kakɨ?» ");
INSERT INTO lik_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Takosikisya ɓɛ: «ka ɓambanzʉ», (Ɓa ndɨ kaɓanga ambaza ka ɓambanzʉ ɓi nɨɓɔ ɓa ndɨ wa. A ɓɛyɔ, ɨɓʉ ɓasɨ ɓibagatʉ ndɨ ɓɛ Yuani a ndɨ mugyalandʉ walɨngʉnʉ.) ");
INSERT INTO lik_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Kʉwa wa, ɓasikisya ndɨ Yeso ɓɛ: «Takibigʉ.» Yeso aka ndɨ na ɨɓʉ ɓɛ: «Gʉtʉgʉ ɨmɨ aka, nakamʉtʉmbʉlyɨgʉ gɔnɨ ikanɨ nagyaga makpʉmʉka mi nɨmɔ no ngu ka wanɨ.» ");
INSERT INTO lik_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Kumbuso yi, Yeso apʉnga ndɨ kaʉnzɨnɨlya pisi ka mozuni. Ʉɓɨkya ndɨ ɓɛ: «Alʉkʉ ɓemoti akʉna ndɨ tiko ya muzabibu, okungula ndɨ, akpɔ lɨɓyɛ lɨʉta bumo yi, opika ndɨ mʉnala ko bulya ka ɓoɓuɓulyo ɓo tiko. Kumbuso yi, ʉkanana ndɨ na ɓagya-ligubo koɓuulyaga tiko yi nɨyɔ, akpakyana ndɨ. ");
INSERT INTO lik_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Nɨyɔ ngbinga mubuulyo masɔlɔ ɨtʉlyana, atɨka mʉgya-ligubo kakɨ ɓemoti kʉ ka ɓagya-ligubo ɓo tiko yi nɨyɔ ɓɛ ɓapíku kʉwa masɔlɔ mi ma kakɨ. ");
INSERT INTO lik_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Luki limoti, ɓagwi ndɨ mʉgya-ligubo nɔ, ɓalya na bʉma ɓɨsʉsʉsʉ, ɓamigisoku maɓɔkʉ papuyi. ");
INSERT INTO lik_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Mombukwono tiko atikoku ɓata ndɨ mʉgya-ligubo wagɔgɔ. Ɓayipaga ndɨ ka mʉ, ɓaɓuɓiso ɓitu na mosikoni. ");
INSERT INTO lik_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Atikoku ɓata wagɔ, ɓamwɔ. Utikoku kʉwa ndɨ ɓagɔgɔ ɓakpʉ, ɓagya-ligubo ɓɔ ɓʉbʉma ndɨ ɓemoti-ɓemoti, ɓʉmwɔgɔ ɓagɔgɔ. ");
INSERT INTO lik_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Mombukwono tiko asɨkana kʉwa ndɨ na mʉtʉ ɓemoti aka: mʉtʉ yi ndɨ nɨ mikakɨ nɨnɔ mʉpaka. Ka muliɓo, atɨka ndɨ, anasɨma ɓɛ: ‹ɓaɓangatʉ.› ");
INSERT INTO lik_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Luki limoti, ɓagya-ligubo ɓi nɨɓɔ ɓaɓɨkyana ndɨ luga kaɓʉ ɓɛ: ‹Alʉkʉ yi nɨnɔ alya ndɛkɛ lisima nɨmʉ! Doniku, tamwini, kyɛ lisimo iki kʉwa lo kusu!› ");
INSERT INTO lik_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ɓagwi ndɨ miki nɔ, ɓamwɔ, ɓombimba manda kakɨ kunzi wo tiko.» ");
INSERT INTO lik_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yeso uusa kʉwa ndɨ ɓɛ: «Mombukwono tiko agya kʉwa ɓanʉ ɓʉ? Odoku ɓanʉ, ulumwisaga ɓagya-ligubo ɓi nɨɓɔ, ʉpá kʉwa ɓagya-ligubo ɓagɔgɔ tiko yi nɨyɔ. ");
INSERT INTO lik_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Makanotongulogigʉ nɨlɔ ɓokpikaga ka Moɓiso Motu ɓɛ: ‹Lɨtalʉ nɨlɔ ɓopipiko ɓombimba ndɨ ilu kʉwa lɔ ɨɨta ndɨ lɨtalʉ la ɨzangɨya ka muɓumbe. ");
INSERT INTO lik_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Mombukwono-dosu nɔ agya ndɨ ɓɛyɔ, a lɨkpʉmʉka lɨmbanga ko miso kusu!›» ");
INSERT INTO lik_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ɓangama ka Ɓayuda ɓakɨsa ndɨ pisi kagwi Yeso. Luki limoti, ɓaɓanga ndɨ ambaza ka ɓambanzʉ. Ɓa ndɨ nɨ ɓibini ɓɛ atwa ndɨ lizuni li nɨlɔ ko bulya kaɓʉ. Ɓasa ndɨ, ɓaga. ");
INSERT INTO lik_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ɓatikilyoku ndɨ Yeso Ɓafalisayɔ ɓemoti-ɓemoti na ɓatʉ ɓa liɗu ka Ɛlɔdɨ. Ɓatʉ ɓi nɨɓɔ ɓapʉnga ndɨ kaɓɔɓɔ na mʉnzɨna. ");
INSERT INTO lik_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ɓodoku ndɨ kamuusa Yeso ɓɛ: «Muwonisilo! Tibagatʉ ambɛ wa mʉtʉ walɨngʉnʉ, wakaɓangagɨgʉ mʉmbanzʉ gʉtʉgʉ ɓemoti aka. Wakʉndagɨgʉ gɔnɨ ɓambanzʉ kaɓyɛnɛnɛ na ɨbɨba kaɓʉ. Luki limoti, wowonisilogo na ɓungbingbili ɓɛyɔ Kunzi apaga mino ɓɛ ɔɓɨlɨ kusu iki. Tɨɓɨkya nɛkɨ ambɛ, takwananatʉ kakalya manzanza ka Kaizalɨ, Ngama mudingi wa Ɓalʉma? Takalyɨtɔ ikanɨ takokolyonitɔ?» ");
INSERT INTO lik_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Luki limoti, Yeso iba ndɨ tamanaga kaɓʉ ya kʉɓɔɓɔkʉ, usikisya ɓɛ: «Ko bulya ɨkɨ yɔ mo mino kakɨsa kɛɓɔ? Ipóniku ambuma ɓemoti, namɨnɨ.» ");
INSERT INTO lik_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ɓapá ndɨ ambuma ɓemoti. Yeso umuusa ndɨ ɓɛ: «Mulundu no lino ka wanɨ lɨ?» Ɓasikisya ndɨ ɓɛ: «Ma ka Ngama Kaizalɨ.» ");
INSERT INTO lik_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yeso aka kʉwa ndɨ na ɨɓʉ ɓɛ: «Mupóni nɛkɨ Kaizalɨ makpʉmʉka nɨmɔ okwononi na ɨyɨ. Mapá Kunzi nɨmɔ ko Kunzi.» Nɨyɔ ɓʉkana sikisyo yi nɨyɔ, ɓombombaya ndɨ kʉgbɛ. ");
INSERT INTO lik_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ɓemoti-ɓemoti luga ka Ɓasadukayɔ nɨɓɔ ɓaɓɨkyaga ɓɛ ɓamanda kopupogigʉ ka mbʉkʉ ɓakpuɗoku ndɨ Yeso, ɓamuusa kʉwa ɓɛ: ");
INSERT INTO lik_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Muwonisilo! Musa atɨɓɨkya ndɨ ɓɛ: ‹Mamakɨ mʉmbanzʉ kokwo, asa mukakɨ nɨ koɓukutigʉ na ɨyɨ, akwanana ɓɛ mamakɨ amɨgɨlyɨ woko yi nɨnɔ, kyɛ aɓʉkʉtɨlyagɨ yaa-dakɨ nɨnɔ okwa ndɨ ɓomiki.› ");
INSERT INTO lik_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","A ndɨ na ɓomiki ɓalʉkʉ ɓi maɗɨya na ɨka nɨɓɔ ɓopupa ndɨ mʉma mimoti. Pʉta ava ndɨ muko, luki limoti, okwa ndɨ nɨ koɓukutigʉ na ɨyɨ. ");
INSERT INTO lik_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Syononogo kakɨ amɨgɨlya ndɨ woko yi nɨnɔ, okwa ndɨ nɨ koɓukutigʉ ɨyɨ ɓɛgɛyɔ. Igyonosa ndɨ mʉɗɔngɔnɨ ɓɛgɛyɔ ka mamaɓʉ yi nɨnɔ wa masaa, ");
INSERT INTO lik_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","na kaɓʉ ɓasɨ maɗɨya na ɨka. Ɓolumwaga ndɨ nɨ ɓakoɓukutigʉ na ɨyɨ. Kumbuso yi, muko yi nɨnɔ okwa kʉwa ndɨ gɔnɨ ɨyɨ. ");
INSERT INTO lik_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ka lɨsyɛ lipupo ka ɓambʉkʉ, wa ɓatʉ nɨɓɔ ɓokwoga ndɨ ɓopupo mino, muko yi nɨnɔ ika ndɛkɛ muko wanɨ luga kaɓʉ? A ɓɛyɔ, ɨɓʉ ɓasɨ maɗɨya na ɨka ɓavatʉ ndɨ!» ");
INSERT INTO lik_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yeso usikisya ndɨ ɓɛ: «Kinili maɓuɓungogo, kyɛ makɛgʉ kotombisyo Moɓiso Motu ikanɨ ngu ko Kunzi. ");
INSERT INTO lik_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","A ɓɛyɔ, ngbingo yi nɨnɔ ɓamanda opupa ndɛkɛ mino ka ɓambʉkʉ, ɓalʉkʉ ɓakʉvɨgʉ ndɛkɛ ɓata ɓoko ikanɨ ɓoko kavyɛgɛ. Luki limoti, ɓika ndɛkɛ mʉɗɔngɔnɨ abɛ ɓamalaika ɓa kʉgʉ wa lɨsyɛ. ");
INSERT INTO lik_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ko bulya yipupo ka ɓambʉkʉ, makanotongulogigʉ mbɛyɨ ndɨ ka kɨtaɓʉ ka Musa nɨlɔ Kunzi aɓɨkya ndɨ ɓuwobi na gbɔgɔ nɨyɔ a ndɨ kagbʉndɨkana? Aɓɨkya ndɨ Musa ɓɛ: ‹Ɨmɨ, na Kunzi ka Abalahamʉ, Kunzi ka Isaka na Kunzi ka Yakɔbɔ›» ");
INSERT INTO lik_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Yeso omotiloku ndɨ ɓɛ: «Kunzi kɛgʉ Kunzi ka ɓamanda, luki limoti, a Kunzi ka ɓatʉ nɨɓɔ ɓa ɓuɓisi. Iɓunu, ma ɓuɓungaga lɨngʉnʉ.» ");
INSERT INTO lik_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Muwonisilo wa mʉtʉʉ ɓemoti a ndɨ wa ngbingo yi nɨnɔ Yeso ɓa ndɨ mino ka ɓoɗongoso na Ɓasadukayɔ. Muwonisilo nɔ ɨna ndɨ ɓɛ Yeso usikisya ndɨ yanza. Akpuɗoku kʉwa ndɨ, amuusa ɓɛ: «Mʉtʉʉ tino mɔ a mudingi kʉgbɛ kakɨtaga magɔ masɨ?» ");
INSERT INTO lik_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yeso asikisya ndɨ ɓɛ: «Mʉtʉʉ nɨmɔ a mudingi kʉgbɛ kakɨtaga magɔ masɨ nɨma: ‹Ʉkana, Izaleli! Mombukwono-dosu Kunzi kusu nɨ Mombukwono-dosu yɨkaka aka. ");
INSERT INTO lik_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Mʉpa Mombukwana-dakʉ Kunzi na lɨmbɛngɨ kakʉ lasɨ, na mʉtamanagɨ kakʉ masɨ na yimibo kakʉ yasɨ, no ngu kakʉ yasɨ.› ");
INSERT INTO lik_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Mʉtʉʉ ma yɨɓa nɨma: ‹Mʉpa ɓɛngɛnɨ mʉɗɔngɔnɨ ɓɛyɔ wɨpago mino ɨwɛ mombukwana-dakʉ.› Kɛgʉ na mʉtʉʉ magɔgɔ nɨmɔ okitogi nɨmana mɨɓa ma na ɨzangɨya.» ");
INSERT INTO lik_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Kʉwa wa muwonisilo wa mʉtʉʉ aɓɨkya ndɨ Yeso ɓɛ: «A ɓɨnza, Muwonisilo! Woɓikyi ka lɨngʉnʉ ɓɛ Mombukwono-dosu a Kunzi ɓemoti aka na kɛgʉ no Kunzi wagɔgɔ kiki asɨ ɨyɨ aka. ");
INSERT INTO lik_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Mʉmbanzʉ akwanana kapa Kunzi na lɨmbɛngɨ kakɨ lasɨ, na yimibo kakɨ yasɨ, no ngu kakɨ yasɨ na kapa ɓɛngɛnɨ mʉɗɔngɔnɨ ɓɛyɔ ɨpaga mino ɨyɨ mombukwana-dakɨ yi. Nɨyɔ a na ɨzangɨya kʉgbɛ kaʉkɨtaga gʉtʉgʉ ɓanyama ɓasɨ nɨɓɔ tabʉsyɨlyaga Kunzi ikanɨ ɓapɛpɛ ɓagɔgɔ ɓasɨ nɨɓɔ tapága.» ");
INSERT INTO lik_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Nɨyɔ Yeso ɨna ndɨ ɓɛ asikisyi na yimibo, aɓɨkya ɓɛ: «Wakɛgʉ ɓyɨ na Ɓʉngama ko Kunzi.» Kumbuso yi, mʉmbanzʉ gʉtʉgʉ ɓemoti aka kɨkpʉndagʉ ndɨ ɓata kamuuso lɨkpʉmʉka. ");
INSERT INTO lik_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ngbingo yi nɨnɔ Yeso a ndɨ mino kapá mʉtɨwɨ ka Ndaɓʉ ko Kunzi, uusa ndɨ ɓɛ: «Ɓowonisilo ɓa mʉtʉʉ ɓakwanana pɨyɛ kaɓɨkya lɨkɨ ɓɛ Kilisito a miko-mika ngama Daudi? ");
INSERT INTO lik_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Daudi ɓɨkpɛ, nɨ a mutumo na Lɨmbɛngɨ-Lotu, aɓɨkya ndɨ ɓɛ: ‹Mombukwono-dosu Kunzi aɓɨkya ndɨ Mombukwana-damɨ ɓɛ: Doku kaiko ka kumbanzɨkanɨkɔ kamɨ, kadwɛ kʉ kwa kʉ nubiso ndɛkɛ mino ɓomuyoniso kakʉ kusili wa ɓakagba kakʉ.› ");
INSERT INTO lik_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Daudi ɨyɨ mombukwana-dakɨ yi amakaga Kilisito ɓɛ ‹Mombukwono-dosu.› Igyonoso kʉwa lɨkɨ ɓɛ Kilisito iki miko-mikakɨ?» Ambaza wakpʉ ka ɓambanzʉ a ndɨ kamʉkana Yeso na magyagya. ");
INSERT INTO lik_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Kʉsɔ wa mʉtʉʉ kakɨ, Yeso ʉɓɨkyaga ndɨ ɓambanzʉ ɓɛ: «Wiɓuulyonito na ɓowonisilo ɓa mʉtʉʉ, ɓapaga kakpakyana nɨ ɓimokisyogini ɓalɔpʉ ɓakpʉkpʉ, ɓiki kaumuuso na ɨbɨba ka ɓapa ɓaya musilyoni. ");
INSERT INTO lik_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ɓakɨsaga kaiko ka moliki ma kambwa aka ka ɓandaɓʉ ɓaya malʉmba, na gɔnɨ ka moliki ma ɨbɨba ka ɓapa ɓaya ɓodumo. ");
INSERT INTO lik_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ɓʉkʉpyaga ɓowoko no ɓou makpʉmʉka masɨ nɨmɔ ɓikaga nomu, na ko ngbingo yi nɨnɔ gɔnɨ nɔ, ɓanʉɓɔɓɔ na malʉmba mandandanda kyɛ ɓinisoni abɛ ɓatʉ ɓanza. Kinili, Kunzi usombisa ndɛkɛ yapʉ kʉgbɛ.» ");
INSERT INTO lik_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Kʉwa wa, Yeso ika ndɨ ka kpɔlɔ wa mʉmbɨ ma apɛpɛ ka Ndaɓʉ ko Kunzi. A ndɨ kaɨna ɓɛyɔ ɓambanzʉ ɓa ndɨ mino kaɗɨkɨta ɓuyi ka mʉmbɨ. Ɓatʉ ɓa lɨngama ɓakpʉ ɓa ndɨ kaɗɨkɨta ɓuyi ɓudingi. ");
INSERT INTO lik_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Woko muko yi ɓemoti wa yangya odoku ndɨ gɔnɨ ɨyɨ kaɗɨkɨta ɨkya ɓambuma maɓa nɨɓɔ kɛgʉ ndɨ na ɨzangɨya kʉgbɛ. ");
INSERT INTO lik_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yeso ʉmaka kʉwa ndɨ ɓaɓɨɓya kakɨ, ʉɓɨkya ɓɛ: «A lɨngʉnʉ, nakamʉɓɨkya ambɛ, woko wa yangya yi nɨmʉna nɔ opí ɨyɨ yidingi ka mʉmbɨ kaʉkɨtaga ɓatʉ ɓagɔgɔ ɓasɨ. ");
INSERT INTO lik_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","A ɓɛyɔ, ɓatʉ ɓagɔgɔ ɓasɨ ɓopí ɓuyi nɨɓɔ ɓa kɛgʉ ɓata ɓi na ɨɓʉ na ligubo. Luki limoti, ɨyɨ, ka yangya kakɨ, opí masɨ nɨmɔ o ɓi nomu kaiɓuulyogo ka ɔɓɨlɨ kakɨ.» ");
INSERT INTO lik_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ngbingo yi nɨnɔ Yeso a ndɨ mino kopupo ka Ndaɓʉ ko Kunzi, ɓemoti ka ɓaɓɨɓya kakɨ aɓɨkya ndɨ ɓɛ: «Muwonisilo, wɨna! Matamʉ tino mana manzanza ma! Ɓandaɓʉ tino ɓayɨna ɓayidingi-dingi ɓa!» ");
INSERT INTO lik_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yeso asikisya ndɨ ɓɛ: «Watʉ kaɨna ɓandaɓʉ ɓayidingi-dingi ɓi nɨɓa-yɨna? Lɨtalʉ gʉtʉgʉ limoti aka kotigoligʉ ndɛkɛ kʉgʉ wa lagɔgɔ, apanzɨkana ndɛkɛ masɨ.» ");
INSERT INTO lik_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yeso a ndɨ wakika ka Ngʉpa ya Mizeituni kambwa wa Ndaɓʉ ko Kunzi. Kʉwa wa, Pɛtɛlɛ, Yakɔbɔ, Yuani na Andɨlɨa ɓamuusa ndɨ ɓɨkɛɗɛ ɓɛ: ");
INSERT INTO lik_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«Tɨɓɨkya mbɛyɨ, lɨkpʉmʉka li nɨlɔ igyonosa ndɛkɛ ngbinga tino? Luki tino lɔ atimibisa ndɛkɛ ngbingo yi nɨnɔ makpʉmʉka mi nɨmɔ masɨ odoku ndɛkɛ mino?» ");
INSERT INTO lik_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yeso usikisya ndɨ ɓɛ: «Wiminyonito, mʉmbanzʉ gʉtʉgʉ ɓemoti aka kamuɓonitɔgʉ. ");
INSERT INTO lik_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ɓambanzʉ ɓudingi ɓodokuto ndɛkɛ ko lino kamɨ, ɓanaɓɨkya ɓɛ: ‹Ɨmɨ nɨ Masiya›. Ɓʉɓɔgɔ ndɛkɛ ɓambanzʉ ɓudingi. ");
INSERT INTO lik_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ngbingo yi nɨnɔ mʉkana ndɛkɛ mino ɓomongoni ɓa mʉnga na ɓakʉambɛ ɓi, makoɓongonitɔgʉ. Masɨ nɨmɔ igyonosatʉ, luki limoti, kikigʉ mbɛyɨ muliɓo ma ɔɓɨlɨ. ");
INSERT INTO lik_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","A ɓɛyɔ, lɨvananza limoti abʉmanaga ndɛkɛ na lɨvananza lagɔgɔ, ɓʉngama ɓimoti ʉlananaga ndɛkɛ na ɓʉngama ɓagɔgɔ. Ka ɓapa dididi, ika ndɛkɛ na ɓazigizo na ayʉndɨ wapʉ. Makpʉmʉka mi nɨmɔ masɨ ika ndɛkɛ mʉɗɔngɔnɨ abɛ mʉpʉnganagɨ ma mʉzʉzʉla ma liɓukuti aka. ");
INSERT INTO lik_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Luki limoti, iɓunu, wiɓuulyonito! Ɓamulikisatʉ ndɛkɛ ka ɓongbongu, ɓamʉbʉma ɓɨɓɛtɛlɛ ka ɓandaɓʉ ɓaya malʉmba ka Ɓayuda. Ɓamusombisa ndɛkɛ kambwa ka ɓangama ɓa ɓewili na ɓangama ɓakpʉkpʉ ko bulya kamɨ. Mika kʉwa ndɛkɛ ɓadɛmʉ kamɨ kambwa kaɓʉ. ");
INSERT INTO lik_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","A ɓɛyɔ, okwononi mbɛyɨ ɓɛ ɓaɓɨkyagɨ Mongoni Manza ka ɓambanzʉ ɓasɨ. ");
INSERT INTO lik_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ngbingo yi nɨnɔ ɓamugwi ndɛkɛ mino, ɓɨnda na iɓunu kamusombiso, makombomboyonitɔgʉ kambwa ɓɛ toɓikyoku ɓʉnɨ. Luki limoti, ɓikyoni nɨlɔ aka lɔ amupupo ko ngbingo yi nɨnɔ aka nɔ. A ɓɛyɔ, kɛgʉ iɓunu ɓɔ manzɨna ndɛkɛ, luki limoti a Lɨmbɛngɨ-Lotu. ");
INSERT INTO lik_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ko ngbingo yi nɨnɔ, mʉmbanzʉ agabaga ndɛkɛ mamakɨ ɓɨkpɛ ka kukwakʉ, baba agya mikakɨ ɓɛgɛyɔ. Ɓomiki ɓʉɨtɨlya ndɛkɛ ɓaɓʉkʉta kaɓʉ, ɓumwisiso. ");
INSERT INTO lik_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ɓambanzʉ ɓasɨ ɓamʉmʉya ndɛkɛ ko bulya lino kamɨ, luki limoti, mʉtʉ yi nɨnɔ okibya ndɛkɛ kadwɛ ka muliɓo, inisana na muhukuso.» ");
INSERT INTO lik_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«Mamɨnatʉ ndɛkɛ nɨnɔ ɓamakaga ɓɛ ‹Mʉpʉpʉta mʉmbanga›, ɓamomosini ka pa nɨyɔ kokwononigʉ ɓɛ iki mino. (Mʉtʉ yi nɨnɔ akatangʉlaga lɨkpʉmʉka li nɨlɨ, ʉkanɨtɔ isi yi ɓɨnza.) Kʉwa wa, ɓatʉ nɨɓɔ ɓika ndɛkɛ ka iwili ya Yudɛa ɓogwa ndɛkɛ mbangʉ misa ya ɓangʉpa. ");
INSERT INTO lik_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Mʉtʉ nɨnɔ ikaga ndɛkɛ kugbondo, kakwananɨgʉ ɓata kosyo kovoku luki ka ndaɓʉ. ");
INSERT INTO lik_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Mʉtʉ nɨnɔ ikaga ndɛkɛ ko tiko, kakwananɨgʉ ndɛkɛ ɓata kaɨga kʉ kakɨ kava kutuko. ");
INSERT INTO lik_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ka masyɛ mi nɨmɔ, ɓoko ɓa ɓamʉma na nɨɓɔ ɓika ndɛkɛ kaulunguso ɓomiki ɓalya ndɛkɛ kumbu. ");
INSERT INTO lik_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Lumboni ambɛ lɨkpʉmʉka li nɨlɔ kigyonosonitɔgʉ ko ngbingo wa ndɔɓɔ. ");
INSERT INTO lik_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","A ɓɛyɔ, masyɛ mi nɨmɔ ika ndɛkɛ masyɛ makigyogyisa yakpʉ kʉgbɛ nɨyɔ kanigyonosigʉ ndɛkɛ katʉkya ka mʉpʉnganagɨ ma ɔɓɨlɨ, wa Kunzi agya ndɨ mino masɨ kadwɛ na lɨsyɛ li nɨlɨ. Na inguo ya yigyogyiso yi nɨyɔ kigyonosigʉ ndɛkɛ ɓata. ");
INSERT INTO lik_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Mombukwono-dosu kokundumosi ndɨ masyɛ mi nɨmɔ, iba kɛgʉ na mʉmbanzʉ gʉtʉgʉ ɓemoti aka nɨnɔ ahʉka ndɛkɛ. Luki limoti, okundumosa ndɨ ɓɛyɔ ko bulya ka ɓatʉ nɨɓɔ ʉpʉnaga ndɨ. ");
INSERT INTO lik_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Kika nɨ mʉmbanzʉ amuɓikyini ɓɛ: ‹Winoni! Kilisito a wanʉ!› Ikanɨ ‹A kʉ!›, makaɓinikyononitɔgʉ. ");
INSERT INTO lik_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","A ɓɛyɔ, ɓakilisito ɓa ɓɔngɔ na ɓogyalandʉ ɓa kʉɓɔɓɔkʉ ɓopupokuto ndɛkɛ. Ɓagyaga ndɛkɛ mokingyosi na makpʉmʉka mʉmbanga-mbanga kakɨsa kauɓungusogo gʉtʉgʉ ɓatʉ nɨɓɔ aka ɓɔ Kunzi ʉpʉnaga ndɨ. ");
INSERT INTO lik_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ɛɛɛ iɓunu, wiminyonito nɛkɨ! Ɨmɨ, namutukusyi motili kambwa aka ka masɨ nɨmɔ.» ");
INSERT INTO lik_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«Luki limoti, ka masyɛ mi nɨmɔ, kumbusa wa igyogyiso yi nɨyɔ, mɔnɨ olimika ndɛkɛ ɓipi. Tɨmba kanzɨgʉ ndɛkɛ ɓata. ");
INSERT INTO lik_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Mangʉtʉ onyukogoku ndɛkɛ kotukyoku kʉgʉ wa lɨsyɛ. Makpʉmʉka mo ngu nɨmɔ kʉgʉ wa lɨsyɛ ɨzʉkʉla ndɛkɛ ɓingbwuku-ngbwuku. ");
INSERT INTO lik_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ɓamɨna kʉwa ndɛkɛ Mika-mʉmbanzʉ kodoku ka ɓɛkʉɓa, mutumo no ngu yidingi na ɨbɨba. ");
INSERT INTO lik_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ʉtɨka ndɛkɛ ɓamalaika ka mondu masɨ makwanganya ma ɔɓɨlɨ katʉkya ka mutili mumoti kadwɛ ka magɔgɔ kaʉmʉmʉla ɓambanzʉ ɓasɨ nɨɓɔ ʉpʉnaga ndɨ.» ");
INSERT INTO lik_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","«Hukononi mʉtɨwɨ nɨmɔ sɨbʉkʉsɔ akapá. Ngbingo yi nɨnɔ mapakʉ ma sɨbʉkʉsɔ obuukonogo mino, magɔgɔ apʉnga kaɓaka, mibaga ɓɛ syangasʉ a kʉwa ɓuwobi koɓuniko. ");
INSERT INTO lik_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Mʉɗɔngɔnɨ gɔnɨ, ngbingo yi nɨnɔ iɓunu mɨna ndɛkɛ mino makpʉmʉka mi nɨmɔ kaigyonoso, wiboni ambɛ doku ko Mika-mʉmbanzʉ a kʉwa ɓuwobi, a ka mupumi. ");
INSERT INTO lik_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","A lɨngʉnʉ, nakamʉɓɨkya ambɛ, ɓatʉ ɓa lɨvananza li nɨlɨ ɓakolumwogigʉ ɓasɨ nɨ makpʉmʉka mi nɨmɔ masɨ kanigyonosigʉ. ");
INSERT INTO lik_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Lɨsyɛ na lɨtɔmbʉ olimikatʉ ndɛkɛ, luki limoti lɨkpʉmʉka kamɨ kolimikigʉ ndɛkɛ lu.» ");
INSERT INTO lik_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","«Mʉmbanzʉ gʉtʉgʉ ɓemoti aka kibigʉ lɨsyɛ ikanɨ ngbingo yi nɨnɔ makpʉmʉka mi nɨmɔ igyonosa ndɛkɛ mino, iki ɓamalaika ɓa kʉgʉ wa lɨsyɛ ikanɨ Miki. Luki limoti, Baba mʉkaka aka nɔ akaiba. ");
INSERT INTO lik_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Wiminyonito! Wikogoni ɓuɓisi, kyɛ makibigʉ ɓɛ ika ndɛkɛ ko ngbinga tino. ");
INSERT INTO lik_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ika ndɛkɛ mʉɗɔngɔnɨ abɛ alʉkʉ ɓemoti nɨnɔ atʉkyɨlya ndɨ lɨgʉndʉ. Asa ndɨ ndaɓʉ kakɨ, ʉsɨlya ɓagya-ligubo koɓuulyogo. Apá ndɨ mʉtʉ yɨkaka-yɨkaka pisi ya ligubo, akpamya ndɨ zamʉ ɓɛ iki wakɨtʉlya koɓuulyaga mupumi. ");
INSERT INTO lik_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Yɛkɨ a ɓɛyɔ, wikoni nɛkɨ ɓuɓisi, kyɛ makibigʉ ngbinga tino nɔ mombukwana ndaɓʉ igoku ndɛkɛ mino: yagɔgɔ ika ndɛkɛ na ɓʉgɔgɔ ikanɨ ka gʉndʉ, yagɔgɔ ka kɔkʉ wa mambwa ikanɨ na ɓʉsɔɓɨ. ");
INSERT INTO lik_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Kigoku ɓigbututu, kokwononigʉ ɓɛ amʉtakanyɨ ka ɓatɔtɔ ɓingbwungono. ");
INSERT INTO lik_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nɨlɨna nakamʉɓɨkya lɨ, nakaʉɓɨkya ɓambanzʉ ɓasɨ: ‹Wikogoni ɓuɓisi!›» ");
INSERT INTO lik_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","A ndɨ nɨ otigolini masyɛ maɓa kadwɛ ka yɨnga wa Pasɨka nɨnɔ ɓalyaga ndɨ mino Mukati wokofulu. Ɓokumu-kumu na ɓowonisilo ɓa mʉtʉʉ ɓa ndɨ kakɨsa pisi niyɔ ɓagwisiso mina Yeso ɓɨpɛlɛ na kamwisiso. ");
INSERT INTO lik_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","A ɓɛyɔ, ɓa ndɨ kaɓɨkya ɓɛ: «Takagwinitɔgʉ ko ngbingo wa yɨnga, kyɛ ɓambanzʉ ɓakovikimonogoni.» ");
INSERT INTO lik_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yeso a kʉwa ndɨ ka Betania, ka ndaɓʉ ka Simoni nɨnɔ a ndɨ keɓu-keɓu. Ngbingo yi nɨnɔ ɓa ndɨ mino kalyalya ka mɨza, muko ɓemoti ogulyoku ndɨ. Muko yi nɨnɔ a ndɨ na malazi mutumo ɓɨɗɛ ko mʉkɛʉ nɨmɔ ɓagya ndɨ ka lɨtalʉ la alibati. Malazi nɨmɔ a ndɨ ma lɨgabʉ lapʉ kʉgbɛ. Ʉlandɨ ndɨ mʉkɛʉ mi nɨmɔ, aɗuka ndɨ na imu Yeso ka mʉ. ");
INSERT INTO lik_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Mambɛngɨ ʉtʉla ndɨ ɓambanzʉ ɓemoti-ɓemoti nɨɓɔ ɓa ndɨ wa, ɓaɓɨkya ndɨ luga kaɓʉ ɓɛ: «Ko bulya ɨkɨ yɔ akapʉta mino malazi ɓɛnɛ? ");
INSERT INTO lik_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ɓakwanana gʉtʉgʉ ɓi kagaba ka ɓambuma kakɨtaga mɨya yɨsaa, ɓʉgbananɨlyaga ɓatʉ ɓa yangya ɓuyi ɓi!» Ɓanyakɨlya ndɨ muko yi nɨnɔ ɓɨnyaka-nyaka. ");
INSERT INTO lik_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Luki limoti, Yeso aɓɨkya ndɨ ɓɛ: «Musoni. Ko bulya ɨkɨ yɔ mo mino kanyakɨlya? Egyilyi lɨkpʉmʉka lanza. ");
INSERT INTO lik_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","A ɓɛyɔ, mikaga ndɛkɛ na ɓatʉ ɓa yangya masyɛ masɨ. Makwanana kaʉgyɨlya ɓʉnza ɓongbinga ɓasɨ nɨɓɔ mopo mino. Luki limoti, ɨmɨ, takikigʉ ɓanʉ pa imoti na iɓunu masyɛ masɨ. ");
INSERT INTO lik_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Muko yi nɨmʉ, ogyi nɨlɔ okwononi ɓi kagya. Eɗuki na malazi ka nzʉyɨ, keɓungusyogo ko bulya lɨsyɛ nɨlɔ ɓelumbo ɓanʉ mino. ");
INSERT INTO lik_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","A lɨngʉnʉ, nakamʉɓɨkya ambɛ, ɓapa ɓayasɨ kʉ ɓaɓɨkyaga ndɛkɛ mino Mongoni Manza ka ɔɓɨlɨ wasɨ, ɓatamanaga ndɛkɛ nɨlɔ muko yi nɨmʉna ogyi, ɓanatʉmbʉlaga yi.» ");
INSERT INTO lik_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Kʉwa wa, Yuda Isikalioti, ɓemoti luga ka ɓatʉtʉmbwa tɛkɛɓɛ na ɓaɓa, ɨnda ndɨ ka ɓokumu-kumu kyɛ ʉgabɨlyɨ Yeso. ");
INSERT INTO lik_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Nɨyɔ ɓʉkana ɓɛyɔ, ɓogwa ndɨ magyagya, ɓawanyaga ɓuyi. Yuda apʉnga kʉwa kakɨsa pisi kaʉgabɨlya Yeso. ");
INSERT INTO lik_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ka lɨsyɛ la mambwa la yɨnga wa Mukati mokofulu, lɨsyɛ nɨlɔ ɓʉsasaga ndɨ mino ɓakɔndɔlɔ ɓa Pasɨka, ɓaɓɨɓya ɓamuusa ndɨ Yeso ɓɛ: «Wakapa ɓɛ tɨndɨ kauɓungusilyogo malɨlɨ ma Pasɨka yanɨ?» ");
INSERT INTO lik_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Yeso ʉtɨka kʉwa ndɨ ɓaɓɨɓya ɓaɓa luga ka ɓaɓɨɓya kakɨ, ʉɓɨkya ɓɛ: «Windoni ka gʉɗʉ, alʉkʉ ɓemoti nɨnɔ ika na mbɨkɛ yɔ liɓo yɨbɨnɨka amʉtɨlyatʉ. Muɓyeni. ");
INSERT INTO lik_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Pa nɨyɔ ogulyo mino, mumuusoniku mombukwana ndaɓʉ ɓɛ: ‹Muwonisilo akauuso ɓɛ: ndaɓʉ tino yɔ alya mino malɨlɨ ma Pasɨka pa imoti na ɓaɓɨɓya kakɨ?› ");
INSERT INTO lik_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Amʉwanya kʉwa miso ma ndaɓʉ mudingi ka ndaɓʉ ya kʉgʉ, nɨyɔ ayiɓungusyaga ɓɨnza, ɓɨngɔ. Matiɓungusilyaga kʉwa pa ɨlyalya kʉ ɓɛyɔ.» ");
INSERT INTO lik_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ɓaɓɨɓya ɓaga ndɨ, ɓosila ka gʉɗʉ, ɓatakanya masɨ ɓɛyɔ Yeso a ndɨ mino nɨ uɓikyini, ɓamba kʉwa ndɨ malɨlɨ ma Pasɨka kʉ ɓɛyɔ. ");
INSERT INTO lik_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nɨyɔ ɓʉgɔgɔ ogwo, Yeso odoku na ɓatʉtʉmbwa tɛkɛɓɛ na ɓaɓa. ");
INSERT INTO lik_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ngbingo yi nɨnɔ ɓa ndɨ mina kalyalya, Yeso aɓɨkya ndɨ ɓɛ: «A lɨngʉnʉ, nakamʉɓɨkya ambɛ, mʉtʉ ɓemoti luga kunu, nɨnɔ takalyalya na ɨyɨ pa imoti, akɛgaba.» ");
INSERT INTO lik_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ɓatʉtʉmbwa ɓalya ndɨ kumbu, ɓapʉnga kamuusogo yɨkaka-yɨkaka ɓɛ: «Ɨmɨ?» ");
INSERT INTO lik_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yeso usikisya ndɨ ɓɛ: «A ɓemoti luga kunu, nɨnɔ ta na ɨyɨ kalyalya ka sanɨ ɓemoti. ");
INSERT INTO lik_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mika-mʉmbanzʉ akokwo mʉɗɔngɔnɨ ɓɛyɔ ikpikaga ndɨ mino ko bulya kakɨ. Luki limoti, kumbu yidingi ka mʉtʉ yi nɨnɔ akagaba! Ika gʉtʉgʉ ndɨ ɓɨnza nɨ kɨɓukutigʉ!» ");
INSERT INTO lik_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ngbingo yi nɨnɔ ɓa ndɨ mino kalyalya, Yeso ava mukati. Kumbuso kabibisa Kunzi, oɓunanaga ndɨ, ʉpága ɓaɓɨɓya kakɨ, ʉɓɨkya ndɨ ɓɛ: «Voni, lyoni nzʉyɨ kamɨ nɨyɨ.» ");
INSERT INTO lik_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ava kʉwa ndɨ kɔpɔ wa vinya. Kumbuso kabibisa Kunzi, ʉpága, ɨɓʉ ɓasɨ ɓamwa ndɨ. ");
INSERT INTO lik_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Yeso ʉɓɨkya kʉwa ndɨ ɓɛ: «Ɓangʉ kamɨ nɨyɨ, ɓangʉ yi nɨyɔ akotulyasa agʉmɛ ko Kunzi. Ɓangʉ yi nɨyɔ akoɗukonogo ko bulya ka ɓatʉ ɓudingi. ");
INSERT INTO lik_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","A lɨngʉnʉ, nakamʉɓɨkya ambɛ, nakamwigʉ ndɛkɛ ɓata vinya wa muzabibu kadwɛ ka lɨsyɛ nɨlɔ namwo ndɛkɛ mino nɨnɔ wambɨya ka Ɓʉngama ko Kunzi.» ");
INSERT INTO lik_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Kʉwa wa, ɓɨmbɨla ndɨ lɨmbʉ libibiso Kunzi. Kumbuso yi, ɓopupa ndɨ wa, ɓaga ka Ngʉpa ya Mizeituni. ");
INSERT INTO lik_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Kʉwa wa, Yeso ʉɓɨkya ndɨ ɓaɓɨɓya kakɨ ɓɛ: «Iɓunu ɓasɨ mɛsatʉ ɓanʉ mʉkaka. A ɓɛyɔ, ɓatangʉlaga ko Moɓiso ɓɛ: ‹Namwɔ ndɛkɛ muɓuɓulyo ka ɓakɔndɔlɔ, ɓakɔndɔlɔ ɓazanzʉkana ɓingbwi.› ");
INSERT INTO lik_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Luki limoti, kumbuso ɨmɨ kopupo ka mbʉkʉ, metokonyoku ndɛkɛ ka Galilaya.» ");
INSERT INTO lik_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pɛtɛlɛ aɓɨkya ndɨ ɓɛ: «Gʉtʉgʉ ɓɛngɛnɨ ɓasɨ ɓakʉsa, ɨmɨ, nakʉsɨgʉ gʉtʉgʉ ikii aka!» ");
INSERT INTO lik_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yeso asikisya ndɨ ɓɛ: «A lɨngʉnʉ, nakaʉɓɨkya ambɛ, no biti ya lɨsyɛ li nɨlɨ, kambwa kɔkʉ kaalɨka nganga yɨɓa, wika nɨ wemongonyini nganga yɨsaa.» ");
INSERT INTO lik_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Luki limoti, Pɛtɛlɛ ɨgɨlyaga ndɨ kaɓɨkya na lɨyʉ lapʉ ɓɛ: «Gʉtʉgʉ kiko ɓɛ tokwi pa imoti, nakʉmanganyɨgʉ ndɛkɛ!» Ɓaɓɨɓya ɓagɔgɔ ɓasɨ ɓaɓɨkya ndɨ ɓɛgɛyɔ. ");
INSERT INTO lik_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Kʉwa wa, Yeso na ɓaɓɨɓya kakɨ ɓosila ndɨ ka pa nɨyɔ ɓalɨkyaga ndɨ ɓɛ Gɛtɛsɛmanɨ. Kʉ ɓɛyɔ, ʉɓɨkya ndɨ ɓɛ: «Wikonononi wanʉ, ngbingo yi nɨnɔ no mina kaɨnda kalʉmba.» ");
INSERT INTO lik_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ava ndɨ Pɛtɛlɛ, Yakɔbɔ na Yuani ɓaga na ɨɓʉ. Yeso apʉnga ndɨ kalya kumbu, otumo na kʉɓangakʉ ɓɨɗɛ. ");
INSERT INTO lik_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ʉɓɨkya ndɨ ɓɛ: «Nakalya kumbu kʉgbɛ ɓuwobi kokwo. Wikoni wanʉ, mika ɓuɓisi aka!» ");
INSERT INTO lik_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Isisila ndɨ yɨkɛɗɛ kambwa, ogwo mokpukpu, alʉmba ɓɛ kakwanana, Kunzi ekiɗisilyi ɓyɨ ngbingo wa kigyogyiso yi nɨmʉ. ");
INSERT INTO lik_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ɨyɨ aka ndɨ ɓɛ: «Aba, Babooo, kɛgʉ na lɨkpʉmʉka nɨlɔ ʉkɨtaga ɨwɛ. Ikiɗisyanɔ ɓaka kɔpɔ wa yigyogyiso yi nɨmʉ. Wakogyonito nɨlɔ ɨmɨ nakapa, luki limoti, gya nɨlɔ aka lɔ ɨwɛ wakapa.» ");
INSERT INTO lik_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Kʉwa wa, Yeso igoku ndɨ wa ʉsa ndɨ mino ɓaɓɨɓya ɓasaa ɓi nɨɓɔ, ʉtakanya ka ɓatɔtɔ. Amuusa ndɨ Pɛtɛlɛ ɓɛ: «Simoni, wa ka tɔtɔ? Wakokwononigʉ kaika muɓisi gʉtʉgʉ ka saa-imoti aka? ");
INSERT INTO lik_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Wikoni ɓuɓisi, manalʉmba, kyɛ makogwonitɔgʉ ka kʉɓɔɓɔkʉ. Lɨmbɛngɨ a na mʉsasa kagya ɓʉnza, luki limoti, nzʉyɨ a na ɓʉpɔ.» ");
INSERT INTO lik_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Yeso akɨɗa ɓata ndɨ, alʉmba mʉɗɔngɔnɨ ɓɛyɔ alʉmba ndɨ nɨmɔ ka mambwa. ");
INSERT INTO lik_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Nɨyɔ ɨgɨlya ɓata kaɨnda kʉ ɓaɓɨɓya ɓi nɨɓɔ ɓa ndɨ mino, ʉtakanya ɓata ɓʉlalaga aka kyɛ tɔtɔ a ndɨ nɨ ubeɗulini. Ɓakɛgʉ ɓata ndɨ kaiba ɓɛ ɓaɓɨkya Yeso ɓʉ. ");
INSERT INTO lik_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Yeso ʉsa ndɨ ɓata ka nganga ya yɨsaa. Nɨyɔ igoku, ʉɓɨkya ndɨ ɓɛ: «Ambɛ, ma mbɛyɨ asɨ ka ɓatɔtɔ aka na kaimumbiso? Ama kʉwa ɓʉɓwa! Ngbingo itulyonini! Ɓiko kasʉta Mika-mʉmbanzʉ ka maɓɔkʉ ka ɓatʉ ɓanyɛ. ");
INSERT INTO lik_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Zuzukoni, togoni! Winoni, mʉtʉ yi nɨnɔ akɛgaba, osiliniku!» ");
INSERT INTO lik_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ngbingo yi nɨnɔ Yeso a mbɛyɨ ndɨ mino kanzɨna aka, ɓemoti luga ka ɓatʉtʉmbwa kakɨ tɛkɛɓɛ na ɓaɓa nɨnɔ ina ndɨ ɓɛ Yuda opuponoku. A ndɨ pa imoti na ambaza mudingi ka ɓambanzʉ. Ɓatʉ ɓi nɨɓɔ ɓa ndɨ na ɓadʉkpa na ɓɛngbɨngɨlɨ. Ɓokumu-kumu, ɓowonisilo ɓa mʉtʉʉ na ɓambɔkʉ-mbɔkʉ ka Ɓayuda ɓɔ ɓutikoku ndɨ. ");
INSERT INTO lik_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yuda nɨnɔ a ndɨ nɨ agobini, a ndɨ nɨ uɓikyini kambwa aka ɓɛyɔ agyo mino. Ʉɓɨkya ndɨ ɓɛ: «Alʉkʉ nɨnɔ napututo, iba ɨyɨ nɨnɔ. Mugwini, maga na ɨyɨ nɨ manaɓuulyo ɓɨnza.» ");
INSERT INTO lik_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Nɨyɔ ɓosiloku ndɨ, Yuda akpuɗoku ndɨ Yeso ɓɨgala-gala, amaka ɓɛ: «Muwonisilo!» Apututa kʉwa. ");
INSERT INTO lik_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Kʉwa wa, ɓatʉ ɓi nɨɓɔ ɓisisiloku ndɨ wa Yeso a ndɨ mino, ɓagwi. ");
INSERT INTO lik_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Luki limoti, ɓemoti ka nɨɓɔ ɓa ndɨ wa anyɔ ndɨ dʉkpa kakɨ, ayipo mʉgya-ligubo ko kumu-kumu, akɔ kutiliko. ");
INSERT INTO lik_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Kʉwa wa, Yeso ʉɓɨkya ndɨ ɓɛ: «Moduku kegwi na ɓadʉkpa na ɓɛngbɨngɨlɨ abɛ nakika mʉtʉ wo kuɓakʉ? ");
INSERT INTO lik_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nikaga ndɨ masyɛ masɨ luga kunu kapá mʉtʉʉ ka Ndaɓʉ ko Kunzi, makegwigʉ ndɨ. Luki limoti, masɨ nɨmana akaigyonoso kyɛ Moɓiso Motu ɨtʉlyanɨ.» ");
INSERT INTO lik_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ɓaɓɨɓya ɓasɨ ɓasa kʉwa ndɨ Yeso, ɓogwa mbangʉ. ");
INSERT INTO lik_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Mʉwanza ɓemoti nɨnɔ a ndɨ na ɨkwɛmbɛ ya kɨkandɨla, a ndɨ kaɓɨɓya Yeso. Ɓakɨngɨla ndɨ kagwi, ");
INSERT INTO lik_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","luki limoti, ʉʉkaga, asa ndɨ ɨkwɛmbɛ, apɨkɨta ndumbu. ");
INSERT INTO lik_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ɓaga kʉwa ndɨ na Yeso ko kumu-kumu. Kʉ ɓɛyɔ, ɓokumu-kumu ɓasɨ, ɓambɔkʉ-mbɔkʉ na ɓowonisilo ɓa mʉtʉʉ ɓamʉmʉkana ndɨ. ");
INSERT INTO lik_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pɛtɛlɛ a ndɨ kaɓyɨɓya Yeso mina ɓyɨ kadwɛ ka pa yangba ya ndaɓʉ ko kumu-kumu. Ika ndɨ pa imoti na ɓazamʉ, apʉnga kaʉta ɓuku. ");
INSERT INTO lik_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ɓokumu-kumu na ɓangama ɓagɔgɔ ɓasɨ ɓa Basa-Yidingi ɓa ndɨ kaʉkɨsa ɓadɛmʉ ɓa ɓɔngɔ, kyɛ ɓinisoni no pisi kamwisisa Yeso. Luki limoti, ɓakɨnagʉ ndɨ. ");
INSERT INTO lik_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","A ɓɛyɔ, ɓatʉ ɓakpʉ ɓa ndɨ kaɓʉkʉlyaga Yeso ɓɔngɔ. Luki limoti, mʉnzɨna kaɓʉ a ndɨ asɨ dididi aka. ");
INSERT INTO lik_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ɓemoti-ɓemoti ɓamagaga ndɨ kaɓʉkʉlyaga ɓɔngɔ, ɓanaɓɨkya ɓɛ: ");
INSERT INTO lik_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«Iɓusu, tamʉkanatʉ ndɨ mʉtʉ yi nɨmʉ nɨ anaɓɨkya ɓɛ: ‹Napanzatʉ ɓanʉ Ndaɓʉ ko Kunzi yi nɨyɨ ipika ndɨ na ɓambanzʉ yɨ. Kumbusa wa masyɛ masaa, nopika ɓanʉ nɨyɔ kipikigʉ na ɓambanzʉ.›» ");
INSERT INTO lik_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Gʉtʉgʉ ɓɛyɔ, mʉnzɨna kaɓʉ a ndɨ asɨ dididi aka. ");
INSERT INTO lik_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Kʉwa wa, kumu-kumu amaga ndɨ luga ka ɓambanzʉ, amuusa Yeso ɓɛ: «Ambɛ, wakɛgʉ kosikisyo? Wakaɓɨkya ɓʉ ka ɓangbanga nɨɓana ɓambanzʉ ɓakaʉpɨ́lyaga ɓa?» ");
INSERT INTO lik_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Yeso adaka ndɨ ɓiwo nɨ kosikisyigʉ lɨkpʉmʉka gʉtʉgʉ limoti aka. Kumu-kumu amuusa ndɨ ɓata ɓɛ: «Ɨwɛ nɨ Kilisito, Miko Kunzi nɨnɔ tabibisogo?» ");
INSERT INTO lik_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yeso osikisya ndɨ ɓɛ: «Iyo! Mamɨnatʉ ndɛkɛ Mika-mʉmbanzʉ wakiko misa ka kumbanzɨkanɨkɔ ko Kunzi nɨnɔ wo Ngu. Mamɨnatʉ ndɛkɛ gɔnɨ nɨ anodoku ka ɓɛkʉɓa ɓaya kʉgʉ wa lɨsyɛ.» ");
INSERT INTO lik_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Kʉwa wa, kumu-kumu ɨnʉaga ndɨ ɓotu, aɓɨkya ɓɛ: «Takɛgʉ ɓata na nzoyi ya ɓadɛmʉ. ");
INSERT INTO lik_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mukonini na motili kunu aka ɓɛyɔ atumbwi mino Kunzi. Makaɓɨkya ɓʉ?» Ɨɓʉ ɓasɨ ɓakɔ ndɨ ɓɛ okwononi ɓamwɨ. ");
INSERT INTO lik_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ɓemoti-ɓemoti kaɓʉ ɓaɓakyaga ndɨ Yeso na ɓotikito ko miso. Ɓakandɨla ndɨ miso, ɓapʉnga kayipaga makɔfɨ, ɓanamuusa ɓɛ: «Wanɨ nɔ uipi? Tɨɓɨkya pisi ka ɓugyalandʉ!» Ɓazamʉ ɓa Ndaɓʉ ko Kunzi ɓagwi ndɨ, ɓaɓɨtaga. ");
INSERT INTO lik_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ngbingo yi nɨnɔ Pɛtɛlɛ a mbɛyɨ ndɨ mino ka pa yangba aka wa, mʉgya-ligubo ɓemoti muko yi ko kumu-kumu odoku ndɨ. ");
INSERT INTO lik_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Nɨyɔ amɨna nɨ anʉta ɓuku, anda ɓizumuuu, aɓɨkya ɓɛ: «Ɨwɛ, mikagatʉ ndɨ gɔnɨ pa imoti na Yeso, mʉtʉ wa Nazalɛtɨ.» ");
INSERT INTO lik_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Luki limoti, anganya ndɨ, anaɓɨkya ɓɛ: «Ɨmɨ, nakɛgʉ kaiba nɨlɔ wakaɓɨkya lɔ. Nakɛgʉ gʉtʉgʉ kotombisyo yi» Kumbuso yi, opupa ndɨ misa ya mupumi ma pa yangba. Kʉwa wa, kɔkʉ alɨka ndɨ. ");
INSERT INTO lik_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Nɨyɔ mʉgya-ligubo muko yi nɨnɔ amɨna ndɨ ɓata kʉ, ɨgɨlya kaʉɓɨkya ɓatʉ nɨɓɔ ɓa ndɨ wa ɓɛ: «Alʉkʉ yi nɨmʉ a ɓemoti kaɓʉ!» ");
INSERT INTO lik_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Luki limoti, Pɛtɛlɛ anganya ɓata ndɨ asɨ ɓɨɗaka-ɗaka. Kumbusa yɨkɛɗɛ, ɓatʉ nɨɓɔ ɓa ndɨ wa ɓaɓɨkya ɓata ɓɛ: «A ɓɛyɔ, wa gɔnɨ ɓemoti kaɓʉ, kyɛ ɨwɛ wa Mʉgalilaya gɔnɨ.» ");
INSERT INTO lik_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Kʉwa wa, Pɛtɛlɛ akɔ ndɨ silika ɓɛ: «Kunzi egyogyisi kika nɨ nakaɓɨkya ɓɔngɔ! Nakamibigʉ alʉkʉ yi nɨmʉna makaɓɨkya mʉ!» ");
INSERT INTO lik_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ko ngbingo yi nɨnɔ aka nɔ, kɔkʉ alɨka ndɨ ka nganga ya yɨɓa. Pɛtɛlɛ atamana mʉnzɨna nɨmɔ Yeso aɓɨkya ndɨ ɓɛ: «Kambwa kɔkʉ kaalɨka nganga yɨɓa, wika nɨ wemongonyini nganga yɨsaa.» Kʉwa wa, apʉnga ndɨ mʉgamʉ. ");
INSERT INTO lik_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Na ɓʉsɔɓɨ ɓiɓo, ɓokumu-kumu pa imoti na ɓambɔkʉ-mbɔkʉ, ɓowonisilo ɓa mʉtʉʉ na ɓambɔkʉ ɓasɨ nɨɓɔ ɓa Basa-Yidingi ɓolikilya ndɨ dikiɗi kakɨsa kamwisisa Yeso. Nɨyɔ ɓakondisiso, ɓaga na ɨyɨ, ɓasa ndɨ ka maɓɔkʉ ka ngama Pilatʉ nɨnɔ andaga ndɨ iwili ya Lʉma. ");
INSERT INTO lik_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatʉ amuusa ndɨ ɓɛ: «Ɨwɛ nɨ ngama ka Ɓayuda?» Yeso asikisya ndɨ ɓɛ: «Ɨwɛ mombukwana-dakʉ nɔ woɓikyi ɓɛyɔ.» ");
INSERT INTO lik_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ɓokumu-kumu ɓasʉngʉlya ndɨ ka ɓopisi dididi. ");
INSERT INTO lik_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilatʉ amuusa ndɨ ɓata ɓɛ: «Wakɛgʉ gʉtʉgʉ kosikisya lɨkpʉmʉka limoti aka? Wakɛgʉ kaʉkana ɓɛyɔ ɓo mino kaʉsʉngʉlya ɓɛnɛ?» ");
INSERT INTO lik_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Luki limoti, Yeso kosikisyagʉ ndɨ lɨkpʉmʉka. Lɨkpʉmʉka ambanga ndɨ Pilatʉ. ");
INSERT INTO lik_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ka yɨnga wa Pasɨka wasɨ, Pilatʉ akʉlaga ndɨ mʉtʉ wa bɔlɔkɔ ɓemoti. Ikaga ndɨ mʉtʉ yi nɨnɔ ambaza ka ɓambanzʉ atwaga ndɨ. ");
INSERT INTO lik_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Kʉ ka bɔlɔkɔ kʉ, a ndɨ na alʉkʉ ɓemoti nɨnɔ ina ndɨ ɓɛ Balaba pa imoti na ɓalʉkʉ ɓi nɨɓɔ ɓugwi ndɨ, kyɛ ɓamwɔ ndɨ alʉkʉ ɓemoti ɓɛnɛ ngbingo yi nɨnɔ ɓambanzʉ ɓavɨkɨmanaga ndɨ mino. ");
INSERT INTO lik_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ambaza ka ɓambanzʉ ɨnda ndɨ kʉ ka Pilatʉ. Apʉnga kʉwa ndɨ kakʉnga ɓɛ ʉgyɨlyɨ mʉɗɔngɔnɨ ɓɛyɔ ʉgyɨlyaga ndɨ mino ka ɓʉndɛlɨ. ");
INSERT INTO lik_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Kʉwa wa, Pilatʉ umuusa ndɨ ɓɛ: «Makapa ɓɛ namʉkʉlyɨ ngama ka Ɓayuda?» ");
INSERT INTO lik_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","A ɓɛyɔ, Pilatʉ a ndɨ kaiba ɓɛ ɓokumu-kumu ɓasʉta ndɨ Yeso ko bulya imi aka. ");
INSERT INTO lik_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Luki limoti, ɓokumu-kumu ɓa ndɨ kapɨpya ambaza ka ɓambanzʉ kaɓɨkya Pilatʉ ɓɛ ʉkʉlyɨ nɔ ɨɓʉ Balaba aka. ");
INSERT INTO lik_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilatʉ umuusa ndɨ ɓata ɓɛ: «Ma nɛkɨ kapa ɓɛ nagyɨ ɨkɨ na alʉkʉ yi nɨmʉ mamakaga ɓɛ ngama ka Ɓayuda mʉ?» ");
INSERT INTO lik_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ɓapamɨkanaga ndɨ ɓɛ: «Mʉbangɨlaga ka mʉsalaba!» ");
INSERT INTO lik_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilatʉ umuusa ndɨ ɓata ɓɛ: «Ɓʉnyɛ tino sɛ mbɛyɨ ɓɔ ogyi ɓi?» Luki limoti, ɓidukulaga ndɨ ɓata kapamɨkanaga pʉlʉ ɓɛ: «Mʉbangɨlaga ka mʉsalaba!» ");
INSERT INTO lik_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Kaungongoliso mambɛngɨ, Pilatʉ ʉkʉlya ndɨ Balaba. Atinisisa kʉwa ndɨ Yeso pimbo, ʉpá ɓɛ ɓabangɨlagɨ ka mʉsalaba. ");
INSERT INTO lik_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ɓasʉda ɓaga kʉwa ndɨ na Yeso ka pa yangba ka ɨmbaa ka ngama wa iwili. Kʉ ɓɛyɔ, ɓʉmaka ndɨ ɓasʉda ɓasɨ. ");
INSERT INTO lik_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ɓamokisya ndɨ kanzʉ wangbʉ, ɓalʉka ndɨ muligi nɨmɔ a ndɨ no mowo ɓiwilili, ɓamokisya ka mʉ abɛ sɨkpakpasʉ ka ɓangama. ");
INSERT INTO lik_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Kumbuso yi, ɓamuusaga ndɨ ɓɛ: «Ngama ka Ɓayuda, tumuusito ba!» ");
INSERT INTO lik_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ɓakilyaga ndɨ na lɨgʉgʉ ka mʉ ɓingwengwengwe, ɓanaɓakya na ɓotikito. Ɓoɓunaga ndɨ moli kambwa kakɨ, ɓanodidiko kadwɛ kʉ kwa kʉ ka lɨtɔmbʉ. ");
INSERT INTO lik_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Nɨyɔ ɓama katɨba ɓɛyɔ, ɓanyɔ ndɨ kanzʉ yi nɨnɔ, ɓamokisya ɓata ɓotu kakɨ. Kʉwa wa, ɓɨnda ndɨ na ɨyɨ kunzi kabangɨlaga ka mʉsalaba. ");
INSERT INTO lik_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Nɨyɔ ɓa ndɨ kopupoku kʉ, ɓamɨna ndɨ alʉkʉ ɓemoti nɨnɔ ina ndɨ ɓɛ Simoni, a ndɨ mʉtʉ wa Kulɛnɛ. Ɨyɨ Simoni a ndɨ abakɨ Alesandulia ɨɓʉ na Lufu. Oɓyeku ndɨ wa nɨ anigoku ko tiko. Ɓasʉda ɓabinikisa ndɨ na mapʉpʉ mʉsalaba ka Yeso. ");
INSERT INTO lik_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ɓaga ndɨ na Yeso ka pa nɨyɔ ɓalɨkyaga ɓɛ Gɔlɔgɔta, isi yi nɨ: «Pa ya Ɨkpʉkpʉkʉsɔ.» ");
INSERT INTO lik_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ɓapá ndɨ vinya wa muzabibu mʉmatanaga no luki lozyo, luki limoti, akya kamwo. ");
INSERT INTO lik_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Kʉwa wa, ɓasʉda ɓabangɨlaga ndɨ ka mʉsalaba. Ɓatwa ndɨ lɨɓɛsɛ ko bulya yɨgbananaga ɓotu kakɨ kakɨsa ɓɛ mʉtʉ yɨkaka-yɨkaka ava ɨkɨ. ");
INSERT INTO lik_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","A ndɨ saa-tatʉ ya ɓʉsɔɓɨ ngbingo yi nɨnɔ ɓabangɨlaga ndɨ mino ka mʉsalaba. ");
INSERT INTO lik_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ɓokpika ndɨ kʉgʉ wo mikya lɨɓaʉ moɓiso nɨmɔ a ndɨ katʉmbʉlaga isi ya kukwakʉ kakɨ ɓɛ: «Ngama ka Ɓayuda.» ");
INSERT INTO lik_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ɓʉbangɨlaga ndɨ gɔnɨ ɓatʉ ɓo kuɓakʉ ɓaɓa ka kpɔlɔ ka Yeso. Ɓemoti ka kʉmbanzɨkanɨkɔ, wagɔgɔ ka kulekuke. ");
INSERT INTO lik_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Nɨlɔ otulyoso Moɓiso Motu nɨmɔ ikpikaga ndɨ ɓɛ: «Ɓamatana ndɨ na ɓagya-manyɛ.» ");
INSERT INTO lik_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ɓambanzʉ nɨɓɔ ɓa ndɨ kakɨtaga wa, ɓa ndɨ katʉmbwa Yeso, ɓanagbɨtya ɓamʉ, ɓanaɓɨkya ɓɛ: «Ɛɛɛ, wa ndɨ kapa kapanza Ndaɓʉ ko Kunzi, wopiko yagɔgɔ ka masyɛ masaa, ");
INSERT INTO lik_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","wihukuso nɛkɨ ɨwɛ mombukwana-dakɨ yi, syoku ka mʉsalaba!» ");
INSERT INTO lik_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ɓokumu-kumu na ɓowonisilo ɓa mʉtʉʉ ɓa ndɨ gɔnɨ luga kaɓʉ katɨba ɓɛgɛyɔ, ɓanaɓɨkyana ɓɛ: «Uhukusa ndɨ ɓatʉ ɓagɔgɔ. Kakwananɨgʉ kaihukuso ɨyɨ mombukwana-dakɨ yi ɓɨkpɛ! ");
INSERT INTO lik_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kilisito, ngama wa Izaleli, osyikunɔ mbɨya wanʉ ka mʉsalaba, takɨna ɓɛyɔ, taɓɨnɨkyana kʉwa!» Gʉtʉgʉ ɓatʉ nɨɓɔ ɓʉbangɨlaga ndɨ na ɨɓʉ, ɓa ndɨ katʉmbwa ɓɛgɛyɔ. ");
INSERT INTO lik_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","A ndɨ saa sita, biti ohuma ndɨ ɔɓɨlɨ wasɨ ka ɓasaa ɓayɨsaa. ");
INSERT INTO lik_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Na saa tisa, Yeso apamɨkana ndɨ ɓɛ: «Eloi, Eloi, lama sabakatani?» Isi yi ɓɛ: «Hiii Kunzi kamɨ! Hiii Kunzi kamɨ! Ko bulya ɨkɨ yɔ wesi mino?» ");
INSERT INTO lik_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Nɨyɔ ɓatʉ ɓemoti-ɓemoti luga ka nɨɓɔ ɓa ndɨ wa ɓamʉkana mino ɓɛyɔ, ɓaɓɨkya ndɨ ɓɛ: «Hukononi, akamaka Ɨlɨya.» ");
INSERT INTO lik_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ɓemoti kaɓʉ ɨnda ndɨ mbangʉ, oluboku luki limoti lafʉɓʉ-fʉɓʉ ko vinya nɨnɔ wonzuwo-nzuwo. Kumbuso yi, amakyana ndɨ ka lɨgʉgʉ, ananɨlya Yeso ɓɛ omwi, anaɓɨkya ɓɛ: «Ɓundoni! Tɨnɨ ikanɨ Ɨlɨya odokuto kasisa ka mʉsalaba!» ");
INSERT INTO lik_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Luki limoti, Yeso apamɨkana ndɨ ɓata, osiso kʉwa lɨmbɛngɨ. ");
INSERT INTO lik_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Kutuko nɨkwɔ ikaga ndɨ kubongiso kagbanana pa yotu na pa yotu kʉgbɛ kʉ ka Ndaɓʉ ko Kunzi kʉ, anʉɨka ndɨ luga katʉkya kʉgʉ kadwɛ kusili. ");
INSERT INTO lik_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Nɨyɔ ngama ka ɓasʉda ka Ɓalʉma nɨnɔ a ndɨ wakamaga kambwa ka Yeso wa, ɨna mina ɓɛyɔ osisa ndɨ mino lɨmbɛngɨ, ɨyɨ aka ndɨ ɓɛ: «Ka lɨngʉnʉ, mʉtʉ yi nɨmʉ a ndɨ asɨ Miko Kunzi aka!» ");
INSERT INTO lik_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ɓoko ɓagɔgɔ ɓa ndɨ kʉ gɔ kʉ, ɓanɨna ɓyɨ lɨkpʉmʉka nɨlɔ. Luga kaɓʉ, a ndɨ nɨ Malia mʉtʉ wa Magadala, Malia amakɨ Yakɔbɔ nɨnɔ miki yi na mamakɨ ɓɛyɔ ka Yɔsɛ, sɛ kʉwa Salʉmɛ. ");
INSERT INTO lik_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ɓoko ɓi nɨɓa ɓa ndɨ kaɓɨɓya Yeso, ɓanasingyo ka mogubo ngbingo yi nɨnɔ a mbɛyɨ ndɨ mino ka Galilaya. Atʉ ndɨ gɔnɨ na ɓoko ɓagɔgɔ ɓudingi nɨɓɔ ɓa ndɨ kaɓɨɓya kadwɛ kʉ kwa kʉ ka Yelusalɛma. ");
INSERT INTO lik_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","A kʉwa ndɨ ɓʉgɔgɔ. Lɨsyɛ li nɨlɔ, a ndɨ lɨsyɛ nɨlɔ ɓiɓungusyaga ndɨ mino ka yɨnga. Ikaga ndɨ lɨsyɛ nɨlɔ a kambwa wa Lɨsyɛ la kimumbiso. ");
INSERT INTO lik_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Yɛzɛfʉ, mʉtʉ wa gʉɗʉ wa Alimatia, a ndɨ mʉtʉ wa ɨbɨba ka Basa-Yidingi, osiloku ndɨ. Ikaga ndɨ kaɓʉndaga Ɓʉngama ko Kunzi. Aga kʉwa ndɨ nɨ kɛgʉ na kʉɓangakʉ ka ngama mudingi ɓɛyɔ ka Pilatʉ kakʉnga manda ka Yeso. ");
INSERT INTO lik_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Luki limoti, Pilatʉ ombombaya ndɨ kaʉkana ɓɛ Yeso okwini ɓi. Amaka kʉwa ndɨ ngama ka ɓasʉda ka Ɓalʉma, amuusa ɓɛ: «Okwini ɓi ndɛlɨ?» ");
INSERT INTO lik_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Nɨyɔ ʉkana mʉtʉmbʉlagɨ ka ngama ka ɓasʉda yi nɨnɔ, Pilatʉ akpamya kʉwa ndɨ Yɛzɛfʉ kava manda ka Yeso. ");
INSERT INTO lik_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yɛzɛfʉ oluwa ndɨ kutuko kwanza, asisa ndɨ ka mʉsalaba, otikyaga na kutuko kwi nɨkwɔ, amongosa ka mbʉkʉ nɨyɔ ɓakpɔ ndɨ ka lɨtalʉ. Kumbuso yi, adʉla ndɨ mupumi mi na lɨtalʉ lidingi ɓingbufu. ");
INSERT INTO lik_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Malia Magadala na Malia nɨnɔ amakɨ Yɔsɛ ɓa ndɨ wa kaɨna pa nɨyɔ ɓa ndɨ mino kalumba Yeso. ");
INSERT INTO lik_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Kumbusa wa Lɨsyɛ la kimumbiso, Malia Magadala, Malia nɨnɔ amakɨ Yakɔbɔ na Salʉmɛ ɓoluwa ndɨ malazi kotutwogoku na imu manda ka Yeso. ");
INSERT INTO lik_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ka lɨsyɛ la Mʉngʉ na ɓʉsɔɓɨ ɓiɓo, ngbingo yi nɨnɔ mangbamʉ ma mɔnɨ opupogoku mino, ɓaga ndɨ ka mbʉkʉ. ");
INSERT INTO lik_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ɓa ndɨ kauusana ɓɛ: «Wanɨ sɛ kʉwa nɔ atitindikilya lɨtalʉ nɨlɔ ɓotikyi ɓi nolu mupumi ma mbʉkʉ?» ");
INSERT INTO lik_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Luki limoti, nɨyɔ ɓɨkwɛ, ɓɨna ndɨ lɨtalʉ nɨlɔ lidingi lɔ kanɨ ɓotini ka kpɔlɔ. ");
INSERT INTO lik_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Kʉwa wa, ɓogulya ndɨ ka mbʉkʉ, ɓamɨna mʉwanza ɓemoti wakimokisya kanzʉ wotu, ikini miso ya kʉmbanzɨkanɨkɔ. Kʉɓangakʉ utuma ndɨ ɓamama ɓi nɨɓɔ ɓɨɗɛ. ");
INSERT INTO lik_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Luki limoti, ʉɓɨkya ndɨ ɓɛ: «Makoɓongonitɔgʉ. Makakɨsa Yeso nɨnɔ mʉtʉ wa Nazalɛtɨ, nɨnɔ ɓabongilogi bi ka mʉsalaba. Opupini ɓi ka mbʉkʉ, kɛgʉ ɓata wanʉ. Winoni pa nɨyɔ ɓabisi ɓi mino. ");
INSERT INTO lik_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Mbɨya wanʉ, huɓikyoniku ɓaɓɨɓya kakɨ, gʉtʉgʉ Pɛtɛlɛ aka ɓɛ: ‹Ogoni ɨyɨ kambwa, matokonyokʉ ka Galilaya. Maminoku ɓanʉ kʉ ɓɛyɔ, mʉɗɔngɔnɨ ɓɛyɔ amʉɓɨkya ndɨ mino.›» ");
INSERT INTO lik_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ɓopupa kʉwa ndɨ, ɓaga mbangʉ ɓyɨ na mbʉkʉ, kyɛ nzʉyɨ a ndɨ kaʉtwa ɓɨkyakyakya, ɓanombomboyo. Ɓakatʉmbʉlyagagʉ ndɨ mʉmbanzʉ gʉtʉgʉ ɓemoti aka likpʉmʉka li nɨlɔ, kyɛ ɓa ndɨ na kʉɓangakʉ.  ");
INSERT INTO lik_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Kumbuso Yeso kopupo ka mbʉkʉ ko mbolugo, ka lɨsyɛ la Mungu, apuponilya mbɛyɨ ndɨ Malia Magadala nɨnɔ anyɔ ndɨ mambɛngɨ ma ɓʉnyɛ maɗɨya na ɨka. ");
INSERT INTO lik_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Aga ndɨ kaʉpága ɓatʉ nɨɓɔ ɓikaga ndɨ pa imoti na Yeso mongoni mi nɨmɔ. Ɓatʉ ɓi nɨɓɔ ɓa mbɛyɨ ndɨ asɨ ka idumasʉ aka, ɓanagamana. ");
INSERT INTO lik_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Luki limoti, nɨyɔ ɓʉkana ɓɛyɔ Malia ʉɓɨkya mino ɓɛ Yeso a muɓisi, aminito, kanɨ ɓakaɓinikyonigʉ. ");
INSERT INTO lik_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Kumbuso yi, Yeso upuponilya ndɨ ɓaɓɨɓya ɓaɓa luga kaɓʉ nɨ igomosyonini. Ɓaɓɨɓya ɓi nɨɓɔ ɓa ndɨ kaɨnda ka mugi mumoti ɓɛnɛ. ");
INSERT INTO lik_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ɓigoku ndɨ kaʉpága ɓaɓɨɓya ɓagɔgɔ mongoni mi nɨmɔ. Luki limoti, ɓakʉɓɨnɨkyanagʉ ndɨ ɨɓʉ ɓɛgɛyɔ. ");
INSERT INTO lik_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Yeso upuponilya ndɨ ɓaɓɨɓya tɛkɛɓɛ na ɓemoti wa ɓa ndɨ mino kalyalya. Uyoyisa ndɨ kyɛ ɓakɛgʉ ndɨ na baya na kyɛ ɓa ndɨ na ɓotumo ka mambɛngɨ, kyɛ ɓakɛgʉ ndɨ kaʉɓɨnɨkyana ɓatʉ nɨɓɔ ɓamɨna ndɨ kanɨ opupini ka mbʉkʉ. ");
INSERT INTO lik_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Kumbuso yi, ʉɓɨkya ndɨ ɓɛ: «Windoni ka ɔɓɨlɨ wasɨ, muɓikyogoku ɓatʉ ɓasɨ Mongoni Manza. ");
INSERT INTO lik_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Nɨnɔ aɓɨnɨkyana ndɛkɛ Mongoni Manza mi nɨmɔ na ɓaɓotiso, inisanatʉ ndɛkɛ na muhukuso. Luki limoti, nɨnɔ kaɓɨnɨkyanɨgʉ ndɛkɛ Mongoni Manza mi nɨmɔ, Kunzi amakya ndɛkɛ ka mʉngɨmbɔ. ");
INSERT INTO lik_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ɓumibaga ndɛkɛ ɓasɨ nɨɓɔ ɓaɓɨnɨkyana ka yɨgya yɨmbanga-mbanga yi nɨyɨ: ko lino kamɨ, ɓokpumyaga ndɛkɛ mambɛngɨ ma ɓʉnyɛ, ɓanzɨnaga ndɛkɛ masasʉ mambɨya, ");
INSERT INTO lik_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ɓugwiga ndɛkɛ ɓanzʉka na maɓɔkʉ ikanɨ komwo sʉmʉ, kanɨ luki kʉgyɨgʉ. Ɓubisilyaga ndɛkɛ ɓatʉ ɓa ɓokoloɓu maɓɔkʉ, ɓatʉ ɓi nɨɓɔ ɓahʉka.» ");
INSERT INTO lik_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Nɨyɔ Mombukwono-dosu Yeso ʉɓɨkya ɓɛyɔ, Kunzi aɗokisa ndɨ kʉgʉ wa lɨsyɛ, ikoku ka kʉmbanzɨkanɨkɔ kakɨ. ");
INSERT INTO lik_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ɓaɓɨɓya ɓaga kʉwa ndɨ kaɓɨkyaga Mongoni Manza ka ɓapa ɓayasɨ. Mombukwono-dosu a ndɨ pa imoti na ɨɓʉ ka mogubo mi nɨmɔ masɨ. Lɨngʉnʉ la Mongoni Manza nɨmɔ ɓapága ndɨ, a ndɨ kainisono pisi ka mokingyosi mʉmbanga-mbanga nɨmɔ ɓa ndɨ kagya.");
INSERT INTO lik_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ambɔkʉ Tiofilo, mʉtʉ wa ɨbɨba kʉgbɛ, ɓambanzʉ ɓudingi ɓokingiloni kokpiko mongoni ma lɨkpʉmʉka nɨlɔ igyonosa ndɨ luga kusu. ");
INSERT INTO lik_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Mʉɗɔngɔnɨ ɓɛyɔ ɓatʉ nɨɓɔ ɓɨna ndɨ no miso ka mambwa ɓatɨtʉmbʉlyaga ndɨ mino, na ɓɨɨta kʉwa ndɨ ɓaɓɨɓɨkya ɓa lɨkpʉmʉka ko Kunzi. ");
INSERT INTO lik_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Kinili, kumbuso mʉkpɨma, ɨmɨ, nini ɨmɨ ɓɨnza gɔnɨ kaukpikilyo ka ɓungbingbili, ɨwɛ Tiofilo, lɨkpʉmʉka lasɨ nɨlɔ igyonosa ndɨ katʉkya ka mambwa, ");
INSERT INTO lik_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","iba wibatʉ lɨngʉnʉ la mʉtɨwɨ nɨmɔ ɓʉpá ndɨ. ");
INSERT INTO lik_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ko ngbingo yi nɨnɔ Ɛlɔdɨ Mbɔkʉ a ndɨ mino ngama wa iwili ka Ɓayuda, a ndɨ no kumu ɓemoti nɨnɔ ina ndɨ ɓɛ Zakalia. Ɨyɨ, a ndɨ ko pigo ya ɓukumu ka Abia. Mukakɨ ɓɛyɔ ka Ɛlɨsabɛtɨ a ndɨ ka lɨvananza ka Aluni nɨnɔ a ndɨ kumu mudingi. ");
INSERT INTO lik_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ɨɓʉ ɓasɨ ɓaɓa ɓa ndɨ ɓongbingbili ko misa ko Kunzi. Ɓagyaga ndɨ mʉtʉʉ ka Mombukwono-dosu nɨ ɓakɛgʉ na dakɨ yi. ");
INSERT INTO lik_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Luki limoti, ɓakɛgʉ ndɨ no miki kyɛ Ɛlɨsabɛtɨ a ndɨ ndʉya. Ɨɓʉ ɓasɨ ɓaɓa ɓa kʉwa ndɨ ɓambɔkʉ-mbɔkʉ kʉgbɛ. ");
INSERT INTO lik_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Lɨsyɛ limoti, Zakalia a kʉwa ndɨ kagya ligubo kakɨ la ɓukumu kambwa ko Kunzi kyɛ mʉ ma ligubo a kʉwa ndɨ ka lɨgbʉta kakɨ. ");
INSERT INTO lik_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Kaɓyɛnɛnɛ na mʉtɨwɨ ma ligubo li nɨlɔ, lɨɓɛsɛ awanya kʉwa ndɨ ɨyɨ kogulya ka pa Yotu Kʉgbɛ ka ndaɓʉ ka Mombukwono-dosu Kunzi kasumbo adʉdʉ. ");
INSERT INTO lik_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ko ngbingo yi nɨnɔ Zakalia a ndɨ mino kasumbo adʉdʉ nɔ, ambaza ka ɓambanzʉ nɨɓɔ ɓa ndɨ kunzi, ɓa ndɨ kalʉmba. ");
INSERT INTO lik_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Kʉwa wa, malaika ɓemoti ka Mombukwono-dosu apuponilyoku, amaga ɓɨgba ka kʉmbanzɨkanɨkɔ kwa gbɔgbɔ nɨyɔ a ndɨ mino kasumbo adʉdʉ yɔ. ");
INSERT INTO lik_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ngbingo yi nɨnɔ Zakalia amɨna mino ɓɛyɔ, ombomboyo, ogwa kʉɓangakʉ kʉgbɛ. ");
INSERT INTO lik_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Luki limoti, malaika aɓɨkya ndɨ ɓɛ: «Zakalia, wakoɓongonitɔgʉ, kyɛ Kunzi ukonini malʉmba kakʉ. Mukakʉ ɓɛyɔ ka Ɛlɨsabɛtɨ ʉɓʉkʉtɨlya ɓanʉ miki mʉlʉkʉ yi, walʉka ɓɛ Yuani. ");
INSERT INTO lik_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ɨwɛ wogwa ɓanʉ ɨgyagya kʉgbɛ na ɓambanzʉ ɓudingi ɓogwa ɓanʉ magyagya ko bulya liɓukuti kakɨ. ");
INSERT INTO lik_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","A ɓɛyɔ, ika ndɛkɛ mʉtʉ mudingi kambwa ka Mombukwono-dosu. Ɨyɨ kamwigʉ ndɛkɛ vinya gʉtʉgʉ makana magɔgɔ nɨmɔ mapʉ aka. Ika ndɛkɛ mutumo na Lɨmbɛngɨ-Lotu katʉkya ka mʉma ka amakɨ. ");
INSERT INTO lik_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Uyikosa ndɛkɛ ɓomikya Ɓezaleli ɓudingi kamɨgɨlya Mombukwana-daɓʉ Kunzi. ");
INSERT INTO lik_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Odoku ndɛkɛ kambwa ko Kunzi abɛ atʉtʉmbwa pa imoti na lɨmbɛngɨ no ngu mʉɗɔngɔnɨ abɛ mugyalandʉ Ɨlɨya, kaigiso mambɛngɨ ka ɓaba-ɓomiki ka ɓomikaɓʉ. Uyikosa ndɛkɛ ɓatʉ ɓanyɛ kodoku ɓatʉ ɓa lɨngʉnʉ kaiko ɓakɨtʉlya kagya mʉtʉʉ ka Mombukwono-dosu Kunzi na kagugubyo.» ");
INSERT INTO lik_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Luki limoti, Zakalia aɓɨkya malaika ɓɛ: «Luki tino lɔ emibiso ɓɛ lɨkpʉmʉka nɨlɔ a lɨngʉnʉ? Kyɛ ɨmɨ na kʉwa mbɔkʉ-mbɔkʉ, muka kamɨ a kʉwa mbɔkʉ-mbɔkʉ gɔnɨ.» ");
INSERT INTO lik_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Malaika amigisya ɓɛ «Ɨmɨ nɨ Gabilieli, nikaga ɓuwobi no Kunzi ɓongbinga ɓasɨ kagugubyo. Ɨyɨ nɔ etikiku kaʉɓɨkya na kaʉpá mongoni manza mi nɨma. ");
INSERT INTO lik_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Yɛkɨ ɨwɛ wakoɓinikyonigʉ mʉnzɨna kamɨ nɨmɔ igyonosa ɓanʉ ko ngbingo yi, ɛɛɛ wɨna sɛ, wɨɨta kʉwa ɓoɓo, wakakwananɨgʉ ɓata kanzɨna kadwɛ ndɛkɛ ka lɨsyɛ li nɨlɔ lɨkpʉmʉka li nɨlɔ igyonoso mino.» ");
INSERT INTO lik_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ko ngbingo yi nɨnɔ, ɓatʉ ɓasɨ ɓa ndɨ kunzi kaɓʉnda Zakalia. Nɨyɔ olipya kʉwa ɓɨndɨ ka Ndaɓʉ ko Kunzi kʉ, lɨkpʉmʉka ʉmbanga ndɨ. ");
INSERT INTO lik_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Wa opupoku mino kakwananagʉ ndɨ ɓata kanzɨna na ɨɓʉ. Kinili ɓambanzʉ ɓiba kʉwa ndɨ ɓɛ a abɛ inini lɨkpʉmʉka lɨmbanga kʉ ka ndaɓʉ kʉ. A kʉwa ndɨ kaʉwanyaga ɓapa na maɓɔkʉ kyɛ a kʉwa ndɨ ɓoɓo. ");
INSERT INTO lik_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Nɨyɔ Zakalia ama ngbingo wa ligubo kakɨ ɓɛyɔ, ɨga kʉ kakɨ. ");
INSERT INTO lik_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Kʉwa kumbusa wa masyɛ mi nɨmɔ, mukakɨ ɓɛyɔ ka Ɛlɨsabɛtɨ ava mʉma. Katʉkyagʉ ndɨ kʉ kakɨ ka ɓatɨmba kuɓukumuti. A ndɨ kaɓɨkya ɓɛ: ");
INSERT INTO lik_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«Wɨna lɨkpʉmʉka lanza nɨlɔ Mombukwono-dosu Kunzi ogyi ɓi ko bulya kamɨ, kɛtʉmba suni ya ɓʉndʉya ko misa ka ɓambanzʉ.» ");
INSERT INTO lik_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Nɨyɔ mʉma ka Ɛlɨsabɛtɨ ɨtʉlyana ɓatɨmba maɗɨya, Kunzi atikoku malaika Gabilieli ka gʉɗʉ ɓemoti wa Galilaya nɨnɔ ina ɓɛ Nazalɛtɨ. ");
INSERT INTO lik_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Atikoku ndɨ ka mʉsɨka ɓemoti nɨnɔ a ndɨ kavanana na mʉlʉkʉ ɓemoti nɨnɔ ina ndɨ ɓɛ Yɛzɛfʉ ka lɨvananza ka ngama Daudi. Mʉsɨka yi nɨnɔ ina ndɨ ɓɛ Malia. ");
INSERT INTO lik_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Malaika apuponilya Malia kʉ a ndɨ mino, aɓɨkya ɓɛ: «Gwanɔ magyagya Malia, Mombukwono-dosu uɗukilyini ɓʉɓʉnga. Ɨyɨ a pa imoti na ɨwɛ.» ");
INSERT INTO lik_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Nɨyɔ Malia ʉkana lɨkpʉmʉka li nɨlɔ ɓɛyɔ, ombomboya kʉgbɛ, imuusa ɓɛ: «Inguo ya yuuso tino sɛ yɨna?» ");
INSERT INTO lik_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Malaika aɓɨkya ɓɛ: «Wakoɓongonitɔgʉ, Malia, kyɛ winisonini na ɓʉɓʉnga ko Kunzi. ");
INSERT INTO lik_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Wava ɓanʉ mʉma, waɓʉkʉta miki mʉlʉkʉ yi, walʉka ɓanʉ ɓɛ Yeso. ");
INSERT INTO lik_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ɨyɨ ika ndɛkɛ mʉtʉ wa ɨbɨba, ɓalʉka ndɛkɛ ɓɛ Mika Kunzi nɨnɔ Kʉgʉ-Kʉgbɛ. Mombukwono-dosu Kunzi apá ndɛkɛ ɓʉngama ka tɨtakɨ ɓɛyɔ ka Daudi, ");
INSERT INTO lik_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ika ndɛkɛ ngama kʉgʉ ka Ɓezaleli ka ɓɛnzɛ na ɓɛnzɛ, ɓʉngama kakɨ kikigʉ ndɛkɛ na muliɓo.» ");
INSERT INTO lik_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Kumbuso yi, Malia amuusa malaika ɓɛ: «Lɨkpʉmʉka li nɨlɔ igyonosa kʉwa ɓanʉ lɨkɨ kyɛ ɨmɨ sanibigʉ lɨkpʉmʉka ka ɓalʉkʉ?» ");
INSERT INTO lik_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Malaika amigisyoku ɓɛ: «Lɨmbɛngɨ-Lotu lɔ usilyoku ɓanʉ, ngu ko Kunzi nɨnɔ Kʉgʉ-Kʉgbɛ utikya ɓanʉ abɛ kululuko. Kinili miki yi nɨnɔ waɓʉkʉta ɓanʉ ika ndɛkɛ mʉtʉ Wotu, ɓalʉka ndɛkɛ ɓɛ Miko Kunzi. ");
INSERT INTO lik_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Wɨkwɛ sɛ, Ɛlɨsabɛtɨ nɨnɔ a ndɨ ndʉya ka lɨvananza kakʉ a kʉwa ɨyɨ na mʉma ma ɓatɨmba maɗɨya. Aɓʉkʉta ɓanʉ miki mʉlʉkʉ yi, gʉtʉgʉ ɓɛyɔ a kʉwa mino mbɔkʉ-mbɔkʉ yɔ. ");
INSERT INTO lik_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kyɛ kɛgʉ na lɨkpʉmʉka nɨlɔ a lapʉpʉ kʉgbɛ ko Kunzi.» ");
INSERT INTO lik_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Malia asikisya kʉwa ɓɛ: «Ɨmɨ nɨ musunzu ka Mombukwono-dosu. Yasɨ igyonosi kʉgʉ kamɨ mʉɗɔngɔnɨ ɓɛyɔ weɓikyi mino.» Kumbuso yi, malaika aga ndɨ. ");
INSERT INTO lik_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Kumbuso wa masyɛ makɛɗɛ, Malia ava ndɨ lɨgʉndʉ kaaga ɓɨgala-gala kʉ ka mugi mimoti ka iwili ya ɓangʉpa ɓaya Yudɛa. ");
INSERT INTO lik_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Nɨyɔ adwɛ kʉ ɓɛyɔ, ogulya ndɨ ka ndaɓʉ ka Zakalia, amuusa mukakɨ ɓɛyɔ ka Ɛlɨsabɛtɨ. ");
INSERT INTO lik_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ko ngbingo yi nɨnɔ Ɛlɨsabɛtɨ ʉkana mino yuuso ka Malia, miki aɗwo ɓiɗuku-ɗuku ka mʉma. Ɛlɨsabɛtɨ otuma na Lɨmbɛngɨ-Lotu. ");
INSERT INTO lik_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Kʉwa wa apamɨkana ɓɛ: «Kunzi uɗukilyini ɓʉɓʉnga kahʉkɨtaga ɓoko ɓasɨ na gɔnɨ miki yi nɨnɔ waɓʉkʉta ɓanʉ, ɓʉɓʉnga kakɨ a kʉwa kʉgʉ kakɨ gɔnɨ! ");
INSERT INTO lik_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ngasa yɨmbanga tino sɛ ɨna amakɨ Mombukwana-damɨ edulyiku mina ɓɛnɛ? ");
INSERT INTO lik_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Kyɛ ko ngbingo yi nɨnɔ nukoni mino yuuso kakʉ, miki oɗwa na magyagya ɓiɗuku-ɗuku ka mʉma kamɨ. ");
INSERT INTO lik_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ɨgyagya yidingi kʉ kakʉ kyɛ woɓinikyonini ɓɛ lɨkpʉmʉka nɨlɔ Mombukwono-dosu Kunzi ʉɓɨkya ndʉkʉ igyonosatʉ.» ");
INSERT INTO lik_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Kʉwa wa Malia aɓɨkya ndɨ ɓɛ: «Lɨmbɛngɨ kamɨ akobibiso ɓudingi ka Mombukwono-dosu Kunzi, ");
INSERT INTO lik_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","na mutumo na ɨgyagya ko bulya ko Kunzi, Muhukuso kamɨ, ");
INSERT INTO lik_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","kyɛ umokini ɓazwa kakɨ ɓo kumbu kʉgʉ ka musunzu kakɨ, ɨmɨ mʉtʉ wa payaya. Katʉkya mbɨya wanʉ, ɓɛvananza ɓayasɨ ɓɛmaka kʉwa ɓɛ mʉtʉ wa ɓʉɓʉnga, ");
INSERT INTO lik_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","kyɛ Kunzi Mombukwono Ngu egyilini lɨkpʉmʉka lɨmbanga. Lino kakɨ nɨ Kunzi Wotu. ");
INSERT INTO lik_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Owonisilaga kumbu kakɨ ka ɓɛvananza ɓayasɨ nɨɓayɔ ɓaɓangaga. ");
INSERT INTO lik_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ogyini makpʉmʉka makpʉkpʉ no ngu ya kʉɓɔkʉkɔ kakɨ: ukpumya ɓatʉ ɓa yɨbɨba, ");
INSERT INTO lik_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","usisa ɓangama ka moliki ma ɓʉngama luki limoti uɗokisa ɓatʉ ɓa payaya kʉgʉ. ");
INSERT INTO lik_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ʉpá ɓatʉ ɓanza makpʉmʉka manzanza, luki limoti umigisa ɓatʉ ɓa mukumbo maɓɔkʉ papuyi. ");
INSERT INTO lik_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Usingyoku ɓosunzu kakɨ ɓɛyɔ ka lɨvananza la Izaleli. Ɨyɨ kaɓʉsalagʉ kaukwilya kumbu, ");
INSERT INTO lik_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","kʉgʉ ka Abalahamʉ na ɓɛvananza kakɨ ka ɓɛnzɛ na ɓɛnzɛ, mʉɗɔngɔnɨ ɓɛyɔ ʉpá ndɨ mino ɓotitosu agʉmɛ.» ");
INSERT INTO lik_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Malia asyɛsyɛ ndɨ kʉ ka Ɛlɨsabɛtɨ ɓuwobi kadwɛ ɓatɨmba ɓasaa. Kumbuso yi, ɨga ndɨ kʉ kakɨ. ");
INSERT INTO lik_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Nɨyɔ ngbingo wa liɓukuti ka Ɛlɨsabɛtɨ ɨtʉlyana, aɓʉkʉta miki mʉlʉkʉ yi. ");
INSERT INTO lik_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ɓapɨmbanɨ kakɨ na ɓɛvananza ɓʉkana ndɨ ɓɛ Kunzi Mombukwono-dosu awonisilyini ɓʉnza. Ɨɓʉ ɓasɨ ɓogwa ndɨ magyagya pa imoti na ɨyɨ. ");
INSERT INTO lik_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Nɨyɔ miki otulyasa masyɛ ɓʉgɨna, ɓodoku kʉwa ndɨ kakɔ. Ɓa ndɨ kapa kalʉka na ɨyɨ abakɨ ɓɛyɔ ka Zakalia. ");
INSERT INTO lik_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Luki limoti amakɨ osikisya ɓɛ: «Kalɨ, kɛgʉ ɓɛyɔ, ɓalʉka ɓɛ Yuani.» ");
INSERT INTO lik_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ɨɓʉ aka na ɨyɨ ɓɛ: «Kɛgʉ na mʉtʉ ɓemoti ka lɨvananza kakʉ nɨnɔ ina ɓɛyɔ!» ");
INSERT INTO lik_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Kʉwa wa ɓamuusa ndɨ abakɨ nɨ ɓananzɨna liɓoɓo ɓɛ ɓibi, ɓɛyɔ a ndɨ mino kapa kalʉka mikakɨ. ");
INSERT INTO lik_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zakalia akʉnga ndɨ lɨɓaʉ nɨlɔ ɓokpikaga mino, kumbuso yi okpika ndɨ ɓɛ: «Lino kakɨ ɓɨkpɛ nɨ Yuani.» Ɓombombaya ndɨ ɨɓʉ ɓasɨ. ");
INSERT INTO lik_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Na ko ngbingo yi nɨnɔ gɔnɨ nɔ, mʉnɔkʉ ahukwikana ndɨ, apʉnga kʉwa ndɨ ɓata kanzɨna, apʉnga ndɨ kapamɨkanaga kanɨ anobibisa Kunzi. ");
INSERT INTO lik_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Kʉwa wa, ɓasɨ nɨɓɔ ɓikaga ndɨ pa imoti na ɨɓʉ ka mugi ɓogulya ndɨ ka kʉɓangakʉ, na kʉ ka iwili ya ɓangʉpa ɓaya Yudɛa, ɓatʉ ɓasɨ ɓanatʉmbʉla kʉwa ndɨ lɨkpʉmʉka nɨlɔ aka lɔ. ");
INSERT INTO lik_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ɓatʉ ɓasɨ nɨɓɔ ɓʉkanaga ndɨ lɨkpʉmʉko li nɨlɔ, ɓapʉngaga ndɨ katamana ko bulya yi, ɓanimuusa ɓɛ miki yi nɨmʉna ika sɛ pɨyɛ ndɛkɛ ɓʉnɨ? Kʉɓɔkʉkɔ kwo ngu ka Mombukwono-dosu a ndɨ pa imoti na ɨyɨ. ");
INSERT INTO lik_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Abakɨ ɓɛyɔ ka Zakalia otuma ndɨ na Lɨmbɛngɨ-Lotu, apʉnga ndɨ kanzɨna abɛ mugyalandʉ, anaɓɨkya ɓɛ: ");
INSERT INTO lik_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Mombukwono-dosu Kunzi ka Ɓezaleli avɨ ɨbɨba, kyɛ ohukusogini lɨvananza kakɨ, ʉkʉlaga ka ɓusunzu. ");
INSERT INTO lik_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Atitikilyiniku Muhukuso nɨnɔ wongu, ka lɨvananza ka musunzu kakɨ ɓɛyɔ ka Daudi. ");
INSERT INTO lik_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","A ɓɛgɛyɔ atʉmbʉlaga ndɨ mino ndɛlɨ kʉgbɛ ka mʉnɔkʉ ka ɓogyalandʉ kakɨ ɓɨkpɛ: ");
INSERT INTO lik_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Apá ndɨ agʉmɛ ɓɛ atɨkʉlaga ndɛkɛ ka maɓɔkʉ ka ɓomuyoniso kusu, na ka ɓasɨ nɨɓɔ ɓakɨsaga katɨgya ɓʉnyɛ. ");
INSERT INTO lik_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ɓɛgɛyɔ, ʉmɨnɨlya ndɨ ɓotitosu kumbu, atamana ndɨ agʉmɛ kakɨ wotu ko Kunzi. ");
INSERT INTO lik_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Kyɛ Kunzi apá ndɨ titosu ɓɛyɔ ka Abalahamʉ agʉmɛ wotu kakɨ, ");
INSERT INTO lik_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","katɨkʉlaga ka maɓɔkʉ ka ɓomuyoniso kusu, na katɨsa kagugubyo kʉwa nɨ takɛgʉ na kʉɓangakʉ. ");
INSERT INTO lik_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Agya ndɨ ɓɛyɔ kyɛ tiki ɓotu na ɓongbingbili ko misa kakɨ ka masyɛ masɨ ma ɔɓɨlɨ kusu. ");
INSERT INTO lik_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Na ɨwɛ mikamɨ, ɓʉlʉka ndɛkɛ ɓɛ mugyalandʉ ko Kunzi nɨnɔ Kʉgʉ-Kʉgbɛ, kyɛ wodoku ndɛkɛ koɓungusyaga pisi ka Mombukwono-dosu kambwa, ");
INSERT INTO lik_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","na kowonisilo lɨvananza kakɨ ɓɛ uhukusaga ndɛkɛ pisi kaʉpɨlya ɓʉnyɛ kaɓʉ. ");
INSERT INTO lik_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Kunzi nɨnɔ kusu a na lɨmbɛngɨ lanza kʉgbɛ no kumbu: atitikilyoku ndɛkɛ lɨmɔmɔ kotukyoku kʉgʉ abɛ mangbamʉ ma mɔnɨ, ");
INSERT INTO lik_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","kauzigo nɨɓɔ ɓa ko biti na kʉsɔ wa kʉɓangakʉ kwa kukwakʉ, katiwonisilo kaɓyɛ pisi ya mazɨyɔ.» ");
INSERT INTO lik_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Miki a kʉwa ndɨ kopingo nɨ lɨmbɛngɨ anatumo. Ikaga ndɨ ɨyɨ ka ɨsa aka, kadwɛ ko ngbingo yi nɨnɔ imibisikosa ndɨ mino ɓɨngbanganya ka ɓomikya Ɓezaleli. ");
INSERT INTO lik_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ka masyɛ mi nɨmɔ, ngama mudingi wa Lʉma ɓɛyɔ ka Ogisiti apá ndɨ mʉtʉʉ ɓɛ ɓʉtangɨ ɓambanzʉ kakɨ ɓasɨ. ");
INSERT INTO lik_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Lɨtatanga nɨlɔ la mambwa lɔ igyonosa ndɨ ko ngbingo yi nɨnɔ Kilinio a ndɨ mino ngama wa iwili ya Sulia. ");
INSERT INTO lik_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ɓambanzʉ ɓasɨ ɓɨndaga ndɨ ka yikpikisiso, mʉmbanzʉ yɨkaka-yɨkaka ka mugi mi nɨmɔ ɨɓʉkʉta mino. ");
INSERT INTO lik_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yɛzɛfʉ atʉkya ndɨ gɔnɨ ɨyɨ ka gʉɗʉ wa Nazalɛtɨ, kʉ ka iwili ya Galilaya, kaɨnda ka gʉɗʉ wa Bɛtɛlɛhɛmʉ, mugi ma kɨɓʉkʉta ka ngama Daudi, ka iwili ya Yudɛa. Ɨnda ndɨ kʉ ɓɛyɔ kyɛ a ndɨ ɨyɨ ka lɨvananza ka Daudi, ");
INSERT INTO lik_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","kayikpikisiso ɨɓʉ na Malia nɨnɔ ɓa ndɨ kavanana na ɨyɨ. Malia a sɛ kʉwa ndɨ wa na mʉma. ");
INSERT INTO lik_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ngbingo yi nɨnɔ ɓa ndɨ mino kʉ ka Bɛtɛlɛhɛmʉ, masyɛ kakɨ ma liɓukuti ɨtʉlyana. ");
INSERT INTO lik_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Aɓʉkʉta ndɨ miki mʉlʉkʉ yi, pʉta kakɨ. Atikyogo na ɓotu ɓaya ɓʉdɨ, amongosa ka kpokoyo nɨnɔ ɓanyama ɓalyalyaga ndɨ mino, kyɛ ɓakɛgʉ ndɨ ɓata ɨɓʉ na pa ka ndaɓʉ ka ɓobiko. ");
INSERT INTO lik_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ka iwili yi nɨyɔ gɔnɨ yɔ, ɓoɓuɓulyo ɓa ɓanyama ɓasyɛgɛ ndɨ kunzi ko tutu, kauɓuulyogo ɓanyama kaɓʉ. ");
INSERT INTO lik_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Malaika ka Mombukwono-dosu Kunzi upuponilyo, ɨbɨba ya mangbamʉ ka Mombukwono-dosu ukungulo. Ɓaɓanga ndɨ kʉgbɛ. ");
INSERT INTO lik_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Luki limoti, malaika ʉɓɨkya ɓɛ: «Makoɓongonitɔgʉ, kyɛ noduku kamʉpá mongoni manza nɨmɔ mʉpá ɨgyagya yidingi ka ɓambanzʉ ɓasɨ. ");
INSERT INTO lik_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Na lɨsyɛ li nɨlɨ, Muhukuso iɓukutini ko bulya kunu kʉ ka mugi ka Daudi, ɨyɨ nɨ Masiya, Mombukwono-dosu. ");
INSERT INTO lik_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Mamiba miki yi nɨnɔ ka makpʉmʉka mi nɨma: Matakanya miki wawɛsɛ mutikyogo na ɓotu ɓaya ɓʉdɨ, mumongoso ka kpokoyo nɨnɔ ɓanyama ɓalyalyaga mino.» ");
INSERT INTO lik_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ambaza ka ɓamalaika osyoku ɓigbututu katʉkya kʉgʉ wa lɨsyɛ, pa imoti na malaika wagɔgɔ, ɓapʉnga kabibiso Kunzi, ɓanaɓɨkya ɓɛ: ");
INSERT INTO lik_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Ɨbɨba ko Kunzi kʉgʉ wa lɨsyɛ kʉgbɛ, na mazɨyɔ kʉnʉ ka lɨtɔmbʉ ka ɓatʉ ɓasɨ nɨɓɔ ʉpaga!» ");
INSERT INTO lik_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ngbingo yi nɨnɔ ɓamalaika ɓatʉkya mino kaɨga kʉgʉ wa lɨsyɛ, ɓoɓuɓulyo ɓa ɓanyama ɓaɓɨkyana luga kaɓʉ ɓɛ: «Togoni nɛkɨ ka Bɛtɛlɛhɛmʉ, tiniku nɨlɔ opupi kʉ, nɨlɔ Mombukwono-dosu Kunzi atiwonisili.» ");
INSERT INTO lik_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ɓɨnda ndɨ ɓɨgala-gala, ɓatakanya Malia na Yɛzɛfʉ, sɛ kʉwa miki wawɛsɛ mumongoso ka kpokoyo nɨnɔ ɓanyama ɓalyalyaga ndɨ mino. ");
INSERT INTO lik_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nɨyɔ ɓamɨna, ɓatʉmbʉlaga nɨlɔ malaika ʉɓɨkya ndɨ ko bulya ko miki wawɛsɛ yi nɨnɔ. ");
INSERT INTO lik_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Lɨkpʉmʉka ʉmbanga ndɨ ɓatʉ ɓasɨ nɨɓɔ ɓʉkana ndɨ mongoni mi nɨmɔ. ");
INSERT INTO lik_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Luki limoti, Malia a ndɨ koɓuulyogo lɨkpʉmʉka nɨlɔ lasɨ, obiso mino lɨmbɛngɨ. ");
INSERT INTO lik_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Kumbuso yi, ɓoɓuɓulyo ɓa ɓanyama ɓɨga ndɨ nɨ ɓanabibisa Kunzi, ɓanambɨmbɨlya ka masɨ nɨmɔ ɓʉkana ndɨ na nɨmɔ ɓɨna ndɨ, kyɛ masɨ igyonosa ndɨ mʉɗɔngɔnɨ ɓɛyɔ aka yɔ malaika ʉɓɨkya ndɨ mino. ");
INSERT INTO lik_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Nɨyɔ masyɛ ɓʉgɨna ɨtʉlyana wa miki ɨɓʉkʉta mino, adwɛ ko ngbingo kakɨ mʉkɔ, ɓalʉka ɓɛ Yeso, lino li nɨlɔ malaika atwa ndɨ kambwa amakɨ kava mʉma. ");
INSERT INTO lik_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Kʉwa wa masyɛ ma kiɓuɓiso kaɓʉ ɨtʉlyana mino, kaɓyɛnɛnɛ na mʉtʉʉ ka Musa, Yɛzɛfʉ na Malia ɓaga ndɨ no miki ka Yelusalɛma kabiso ka maɓɔkʉ ka Mombukwono-dosu, ");
INSERT INTO lik_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","kyɛ, ikpika ndɨ ka Mʉtʉʉ ka Mombukwono-dosu ɓɛ: «Okwononi kapá abɛ apɛpɛ ka Mombukwono-dosu miki mʉlʉkʉ yi wasɨ, nɨnɔ pʉto yi.» ");
INSERT INTO lik_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ɓɨnda ndɨ ka Yelusalɛma kapá gɔnɨ apɛpɛ ɓɛgɛyɔ mʉtʉʉ mi nɨmɔ ɨɓɨkya ndɨ mino: «Ɓonzuwo ɓaɓa gʉtʉgʉ ɓomikya ɓamokpondi ɓaɓa aka.» ");
INSERT INTO lik_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Wɨna sɛ wa, alʉkʉ ɓemoti a ndɨ ka Yelusalɛma kʉ ina ndɨ ɓɛ Simioni. A ndɨ mʉtʉ wongbingbili na mʉtʉ mʉɓanga Kunzi kʉgbɛ. Ikaga ndɨ kaɓʉnda mʉtʉ yi nɨnɔ akwanana ndɨ kohukusa lɨvananza la Izaleli. Lɨmbɛngɨ-Lotu a ndɨ kʉgʉ kakɨ. ");
INSERT INTO lik_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Lɨmbɛngɨ li nɨlɔ awonisila ndɨ ɓɛ kokwigʉ nɨ kanaminigʉ Kilisito nɨnɔ Mombukwono-dosu atikoku. ");
INSERT INTO lik_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Akpamya ndɨ kogulya ka Ndaɓʉ ko Kunzi. Ngbingo yi nɨnɔ Yɛzɛfʉ na Malia ɓɨnda mino no mikaɓʉ ɓɛyɔ ka Yeso, kabiso ka maɓɔkʉ ko Kunzi mʉɗɔngɔnɨ ɓɛyɔ mʉtʉʉ aɓɨkyaga ndɨ mino, ");
INSERT INTO lik_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simioni adungo, abibisa Kunzi, aɓɨkya ɓɛ: ");
INSERT INTO lik_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Mbɨya wanʉ, Eeeze Mombukwono-dosu, hutulyosini ɓagʉmɛ kakʉ: Wakwanana kʉwa kasa musunzu kakʉ kokwo ka mazɨyɔ, ");
INSERT INTO lik_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","kyɛ ninini muhukuso kakʉ no misa kamɨ, ");
INSERT INTO lik_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","muhukuso mi nɨmɔ woɓungusyaga ndɨ ko misa ka ɓambanzʉ ɓasɨ: ");
INSERT INTO lik_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","A lɨmɔmɔ li nɨlɔ uziga ɓanʉ ɓambanzʉ ɓasɨ ɓa ɔɓɨlɨ nɨɓɔ ɓakumibigʉ na nɨlɔ apá ɓanʉ ɨbɨba ka Izaleli, lɨvananza kakʉ.» ");
INSERT INTO lik_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Lɨkpʉmʉka lasɨ nɨlɔ Simioni a ndɨ kaɓɨkya ko bulya ka Yeso, ʉmbanga ndɨ ɓaɓʉkʉta kakɨ. ");
INSERT INTO lik_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simioni akʉnga Kunzi ɓɛ uɗukilyi ɓʉɓʉnga, aɓɨkya Malia amakɨ Yeso ɓɛ: «Kunzi atikoku ndɨ miki yi nɨmʉna ko bulya yi nɨyɔ ɓɛ ugwisisi ikanɨ umomosi ɓatʉ ɓudingi luga ko ɓomikya Ɓezaleli. Ika ɓanʉ likingyosi ɓɛ Kunzi akagya ligubo kakɨ nɨ ɓambanzʉ ɓakɛgʉ kabaɨlya, ");
INSERT INTO lik_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","na ɓata opupisa ɓanʉ mʉtamanagɨ masɨ nɨmɔ ɨsʉma ka mambɛngɨ ka ɓambanzʉ ɓudingi. Sɛ kʉwa ɨwɛ, Malia, wigomisaga ndɛkɛ ko bulya ko miki yi nɨmʉ abɛ ɓakutumo dʉkpa.» ");
INSERT INTO lik_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Mugyalandʉ ɓemoti muko yi ina ndɨ ɓɛ Ana, ikaga ndɨ gɔnɨ ɨyɨ ka Yelusalɛma. A ndɨ mika Fanueli, ka lɨvananza ka Aseli. A kʉwa ndɨ mbɔkʉ-mbɔkʉ kʉgbɛ. Ɓagya ndɨ ɓyanga maɗɨya na ɨka na mbʉnyakɨ nɨnɔ ava ndɨ nɨ a mbɛyɨ mʉsɨka aka. ");
INSERT INTO lik_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Kumbuso yi, ika kʉwa ndɨ woko aka, na kʉ odwisa ndɨ mino ɓyanga ɓatɛkɛɓɛ ɓʉgɨna na ɓɨkwanganya. Katʉkyagɨgʉ ndɨ ka Ndaɓʉ ko Kunzi, luki limoti agyɨlyaga ndɨ Kunzi ligubo biti na lɨsyɛ: Avaga ndɨ ngbingo ko ginyo malɨlɨ na kalʉmba. ");
INSERT INTO lik_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Odoku ndɨ ko ngbingo yi nɨnɔ gɔnɨ nɔ, apʉnga kabibiso Kunzi. Ʉtʉmbʉlyaga ɓambanzʉ ɓasɨ nɨɓɔ ɓa ndɨ kaɓʉnda ɓɛ pisi tino yɔ Kunzi ʉkʉlaga mino ɓatʉ ɓa Yelusalɛma ka ɓusunzu. ");
INSERT INTO lik_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ngbingo yi nɨnɔ Yɛzɛfʉ na Malia ɓama mino kagya masɨ nɨmɔ mʉtʉʉ ka Mombukwono-dosu Kunzi akʉngaga ndɨ, ɓɨga na Yeso ka Galilaya, ka gʉɗʉ wa Nazalɛtɨ. ");
INSERT INTO lik_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Miki apʉnga ndɨ kopingo na kopingogo. A ndɨ mutumo na yimibo na ɓʉɓʉnga ko Kunzi a ndɨ pa imoti na ɨyɨ. ");
INSERT INTO lik_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ɓyanga ɓayasɨ, abakɨ na amakɨ Yeso ɓaɗakaga ndɨ ka Yelusalɛma ka yɨnga ya Pasɨka. ");
INSERT INTO lik_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Wa Yeso otulyoso mino ɓyanga tɛkɛɓɛ na ɓɨɓa, ɓaɗaka ndɨ na ɨɓʉ ɓɛyɔ aka yɔ ɓagyaga ndɨ mino ka ɓʉndɛlɨ. ");
INSERT INTO lik_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ngbingo yi nɨnɔ yɨnga osyo mino, ɓɨga, luki limoti miki Yeso asɨkana kʉ ka Yelusalɛma nɨ abakɨ na amakɨ ɓakibigʉ. ");
INSERT INTO lik_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ɓa ndɨ kasɨma ɓɛ Yeso akakpakyana ka ambaza ka ɓambanzʉ nɨɓɔ ɓa ndɨ kaɨganana. Nɨyɔ ɓagya lɨsyɛ limoti ka lɨgʉndʉ nɨ ɓakɛgʉ kamɨna, ɓapʉnga kʉwa ndɨ kakɨsa luga ka ɓɛvananza kaɓʉ na ɓawai-daɓʉ. ");
INSERT INTO lik_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Luki limoti, ɓakamɨnagʉ ndɨ. Kinili ɓɨga ɓata ndɨ kakɨsa kʉ kwa kʉ ka Yelusalɛma. ");
INSERT INTO lik_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Kumbusa wa masyɛ masaa, ɓatokonyoku ka Ndaɓʉ ko Kunzi: A ndɨ mukuliko pa imoti na ɓowonisilo ɓa mʉtʉʉ, anʉmʉkana na anumuuso makpʉmʉka magɔgɔ. ");
INSERT INTO lik_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Lɨkpʉmʉka ʉmbanga ɓatʉ ɓasɨ nɨɓɔ ɓa ndɨ kamʉkana, kaɨna yimibo kakɨ na sikisyo kakɨ ka makpʉmʉka nɨmɔ ɓa ndɨ kamuusogo mɔ. ");
INSERT INTO lik_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ngbingo yi nɨnɔ abakɨ na amakɨ ɓamɨna mino, lɨkpʉmʉka ʉmbanga kʉgbɛ, na kʉ amakɨ amuusi ɓɛ: «Mikamɨ, ɨkɨ pɨyɛ yɔ watigyi ɓi mino ɓɛyɔ? Tomomini iɓusu na abakʉ ɓɨgbagbagba kaʉkɨsa.» ");
INSERT INTO lik_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Umigisya ɓɛ: «Mo ɓi kɛkɨsa ko bulya ɨkɨ? Makɛgʉ kaiba ɓɛ okwononi ɓɛ niki ka ndaɓʉ ka Baba?» ");
INSERT INTO lik_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Luki limoti, ɓakɛgʉ ndɨ kaiba isi ya lɨkpʉmʉka nɨlɔ a ndɨ kaʉɓɨkya lɔ. ");
INSERT INTO lik_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Kʉwa wa Yeso ɨga ndɨ pa imoti na ɨɓʉ ka Nazalɛtɨ. Agyaga ndɨ mʉtʉʉ kaɓʉ masɨ. Amakɨ oɓuulyaga ndɨ lɨkpʉmʉka nɨlɔ lasɨ ka lɨmbɛngɨ. ");
INSERT INTO lik_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yeso a ndɨ kopingo kanɨ yimibo kakɨ anisisilo kambwa, anaɓosilo Kunzi na ɓambanzʉ. ");
INSERT INTO lik_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","A ndɨ syangasʉ sa tɛkɛɓɛ na kuɓukumuti sa ɓʉngama ka Tibelio, ngama mudingi wa Lʉma. Ko ngbingo yi nɨnɔ, Potio Pilatʉ andaga ndɨ iwili ya Yudɛa, Ɛlɔdɨ a ndɨ ngama wa Galilaya. Mamakɨ ɓɛyɔ ka Filipi a ndɨ gɔnɨ ngama wa iwili ya Itulia na Talakoniti ɓɛgɛyɔ Lisania a ndɨ mino ngama wa Abɨlɛnɛ. ");
INSERT INTO lik_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ana na Kayafa ɓa ndɨ ɓokumu-kumu. Mongoni ko Kunzi asilya ndɨ Yuani, mika Zakalia ka ɨsa. ");
INSERT INTO lik_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Kumbuso yi, Yuani ɨnda ndɨ kolingyo giyo yasɨ ya mutili mo liɓo ma Yɔlɔdanɨ, anakʉwa ɓɛ: «Yikosoni mambɛngɨ, miɓotisiso, Kunzi amʉpɨlya ɓʉnyɛ kunu.» ");
INSERT INTO lik_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Igyonosa ndɨ ɓɛyɔ aka yɔ ikpika ndɨ mino ka kɨtaɓʉ ka mugyalandʉ Isaya ɓɛ: «Mʉmbanzʉ ɓemoti akapamɨkanaga ka ɨsa ɓɛ: Ɓungusyoni pisi ka Mombukwono-dosu, nononi ɓopisi kakɨ ɓingbingbili! ");
INSERT INTO lik_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tikyoni mombuɗu masɨ, gbotomosogoni ɓangʉpa ɓayasɨ na ɓokpumo ɓayasɨ mʉɗɔngɔnɨ, nononi ɓopisi ɓaɨyɨgaga, mosulyo nɨɓayɔ ɓaya maɓyɛ. ");
INSERT INTO lik_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Na ɓatʉ ɓasɨ ɓɨna ndɛkɛ muhukuso ko Kunzi.» ");
INSERT INTO lik_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Nɨyɔ Yuani ʉmɨna ɓambanzʉ ɓudingi ɓanadulyoku ɓɛ uɓotisi, ʉɓɨkya ndɨ ɓɛ: «Iɓunu lɨvananza ka ɓanzʉkaaa! Wanɨ nɔ amuwonyi pisi kapɨkɨta ngbʉta ko Kunzi nɨyɔ akodoku? ");
INSERT INTO lik_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Wonisoni nɛkɨ pisi ka yɨgya ɓɛ moyikosoni mambɛngɨ, mosoni kaɓɨkya kʉsɔ kunu ɓɛ: ‹Titosu nɨ Abalahamʉ!› A ɓɛyɔ, nakamʉɓɨkya ambɛ, Kunzi akwanana koitiso matamʉ mi nɨma kaiko ɓomika Abalahamʉ. ");
INSERT INTO lik_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Gbɔnɨ a mbɨya wanʉ yakɨtʉlya kagbɨta bʉkʉtɔ ka motino mi: ɓagbɨtatʉ bʉkʉtɔ tasɨ nɨtɔ kɛgʉ kaɓʉkʉta bumo yanzanza, ɓaɗɨkɨta ko ɓuku.» ");
INSERT INTO lik_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ɓambanzʉ ɓudingi kʉsɔ wa ambaza ɓamuusaga ndɨ Yuani ɓɛ: «Okwononi sɛ kʉwa bɛ tagyɨ ɓʉnɨ?» ");
INSERT INTO lik_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Usikisyaga ndɨ ɓɛ: «Mʉmbanzʉ kika na ɓasimizi ɓaɓa, apá mʉtʉ yi nɨnɔ kɛgʉ na ɨyɨ ɓemoti, na nɨnɔ a na malɨlɨ, agyɨ ɓɛgɛyɔ.» ");
INSERT INTO lik_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ɓandɔmbɛ ɓa manzanza ɓodoku ndɨ gɔnɨ ɨɓʉ kayiɓotisiso, ɓamuusa Yuani ɓɛ: «Muwonisilo, okwononi ɓɛ iɓusu tagyɨ ɓʉnɨ?» ");
INSERT INTO lik_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Usikisya ndɨ ɓɛ: «Makokungonitɔgʉ ɓuyi kakɨtaga nɨɓɔ mʉtʉʉ ka ɓangama aɓɨkya.» ");
INSERT INTO lik_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ɓasʉda ɓamuusa ndɨ gɔnɨ ɨɓʉ ɓɛ: «Sɛ kʉwa iɓusu, takwanana kagya ɓʉnɨ?» Usikisya ndɨ ɓɛ: «Makukupyogonitɔgʉ ɓambanzʉ ɓuyi no ɓou gʉtʉgʉ kaʉɓʉkʉlyaga lɨkpʉmʉka aka. Luki limoti, gwogoni magyagya na mʉkalya kunu aka.» ");
INSERT INTO lik_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ɓambanzʉ ɓasɨ ɓa ndɨ kaɓʉndɨla, na mʉsasa. Ɓimuusaga ndɨ ɓɛ kɛgʉ sɛ ɓanʉ Yuani nɨ Kilisito? ");
INSERT INTO lik_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yuani usikisya ɨɓʉ ɓasɨ ɓɛ: «Ɨmɨ, nakamuɓotiso ko liɓo, luki limoti nɨnɔ akodoku a no ngu kɛkɨtaga ɨmɨ, nakakwananɨgʉ gʉtʉgʉ kakʉla ligi ya ɓɛkpakʉ kakɨ aka. Ɨyɨ, amuɓotisa ɓanʉ na Lɨmbɛngɨ-Lotu no ɓuku. ");
INSERT INTO lik_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","A na ɗunga mugwi, wakɨtʉlya kapɨpa mʉpʉnga. Amʉmʉla ndɛkɛ mʉpʉnga, abiso ka basa ya masɔlɔ kakɨ. Luki limoti, abʉsya ndɛkɛ ɓɛvʉlʉ ko ɓuku nɨɓɔ kolimikogigʉ.» ");
INSERT INTO lik_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Kʉwa wa, Yuani ʉpaga ndɨ mʉtʉʉ mɔgɔgɔ na ɓopisi dididi na kaʉɓɨkyaga Mongoni Manza. ");
INSERT INTO lik_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Luki limoti, Yuani a ndɨ kayoyiso Ɛlɔdɨ ngama wa Galilaya kyɛ ava ndɨ Elodia, muko mamakɨ ɓɛyɔ ka Filipi. Na kyɛ agya ndɨ gɔnɨ makpʉmʉka manyɛnyɛ makpʉ. ");
INSERT INTO lik_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Kumbuso yi, Ɛlɔdɨ agya ɓata ndɨ lɨkpʉmʉka lanyɛ kʉgbɛ kagwisisa Yuani. ");
INSERT INTO lik_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Kumbuso kauɓotiso ɓatʉ nɨɓɔ ɓa ndɨ wa, Yuani aɓotisa ndɨ gɔnɨ Yeso. Ko ngbingo yi nɨnɔ Yeso a ndɨ mino kalʉmba wa, lɨsyɛ ohukwikono, ");
INSERT INTO lik_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Lɨmbɛngɨ-Lotu asilyoku ndɨ abɛ likpondi. Kʉwa wa, lɨyʉ otukyoku ndɨ kʉgʉ wa lɨsyɛ ɓɛ: «Ɨwɛ nɨ Mikamɨ mʉpaka, nɨnɔ nobiso mino lɨmbɛngɨ.» ");
INSERT INTO lik_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yeso a ndɨ na ɓyanga banda ɓatɛkɛɓɛ ɓasaa ko ngbingo yi nɨnɔ apʉnga ndɨ mino ligubo kakɨ. Ɓambanzʉ ɓapandaga ndɨ ɓɛ a mika Yɛzɛfʉ, Yɛzɛfʉ nɨnɔ a ndɨ mika Eli. ");
INSERT INTO lik_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli nɨnɔ a ndɨ mika Matatɨ, Matatɨ nɨnɔ a ndɨ mika Lawi. Lawi nɨnɔ a ndɨ mika Meleki, Meleki nɨnɔ a ndɨ mika Yanaɨ, Yanaɨ nɨnɔ a ndɨ mika Yɛzɛfʉ. ");
INSERT INTO lik_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yɛzɛfʉ nɨnɔ a ndɨ mika Matatɨa, Matatɨa nɨnɔ a ndɨ mika Amosi, Amosi nɨnɔ a ndɨ mika Naʉmʉ, Naʉmʉ nɨnɔ a ndɨ mika Esili, Esili nɨnɔ a ndɨ mika Nagai. ");
INSERT INTO lik_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai nɨnɔ a ndɨ mika Matɨ, Matɨ nɨnɔ a ndɨ mika Matatɨa, Matatɨa nɨnɔ a ndɨ mika Simeini, Simeini nɨnɔ a ndɨ mika Yoseki, Yoseki nɨnɔ a ndɨ mika Yoda. ");
INSERT INTO lik_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda nɨnɔ a ndɨ mika Yuanani, Yuanani nɨnɔ a ndɨ mika Lɛsa, Lɛsa nɨnɔ a ndɨ mika Zelubabeli, Zelubabeli nɨnɔ a ndɨ mika Salatieli, Salatieli nɨnɔ a ndɨ mika Neli. ");
INSERT INTO lik_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neli nɨnɔ a ndɨ mika Meleki, Meleki nɨnɔ a ndɨ mika Adi, Adi nɨnɔ a ndɨ mika Kɔsamʉ, Kɔsamʉ nɨnɔ a ndɨ mika Ɛlɛmadamʉ, Ɛlɛmadamʉ nɨnɔ mika Ɛlɨ. ");
INSERT INTO lik_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ɛlɨ nɨnɔ a ndɨ mika Yeso, Yeso nɨnɔ a ndɨ mika Eliezeli, Eliezeli nɨnɔ a ndɨ mika Yɔlamʉ, Yɔlamʉ nɨnɔ a ndɨ mika Matatɨ, Matatɨ nɨnɔ a ndɨ mika Lawi. ");
INSERT INTO lik_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lawi nɨnɔ a ndɨ mika Simioni, Simioni nɨnɔ a ndɨ mika Yuda, Yuda nɨnɔ a ndɨ mika Yɛzɛfʉ, Yɛzɛfʉ nɨnɔ a ndɨ mika Yɔnamʉ, Yɔnamʉ nɨnɔ a ndɨ mika Eliakɨmʉ. ");
INSERT INTO lik_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakɨmʉ nɨnɔ a ndɨ mika Mɨlɨa, Mɨlɨa nɨnɔ a ndɨ mika Mɨna, Mɨna nɨnɔ a ndɨ mika Matata, Matata nɨnɔ a ndɨ mika Natanɨ, Natanɨ nɨnɔ a ndɨ mika Daudi. ");
INSERT INTO lik_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Daudi nɨnɔ a ndɨ mika Yɛsɛ, Yɛsɛ nɨnɔ a ndɨ mika Obedi, Obedi nɨnɔ a ndɨ mika Bɔazɨ, Bɔazɨ nɨnɔ a ndɨ mika Sɔlɔmɔnɔ, Sɔlɔmɔnɔ nɨnɔ a ndɨ mɨka Nasoni. ");
INSERT INTO lik_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasoni nɨnɔ a ndɨ mika Aminadabʉ, Aminadabʉ nɨnɔ a ndɨ mika Adimi, Adimi nɨnɔ a ndɨ mika Alini, Alini nɨnɔ a ndɨ mika Esiloni, Esilomi nɨnɔ a ndɨ mika Pelesi, Pelesi nɨnɔ a ndɨ mika Yuda. ");
INSERT INTO lik_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yuda nɨnɔ a ndɨ mika Yakɔbɔ, Yakɔbɔ nɨnɔ a ndɨ mika Isaka, Isaka nɨnɔ a ndɨ mika Abalahamʉ, Abalahamʉ nɨnɔ a ndɨ mika Tela, Tela nɨnɔ a ndɨ mika Naholi. ");
INSERT INTO lik_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Naholi nɨnɔ a ndɨ mika Selugi, Selugi nɨnɔ a ndɨ mika Leu, Leu nɨnɔ a ndɨ mika Pelegi, Pelegi nɨnɔ a ndɨ mika Ɨbɛlɛ, Ɨbɛlɛ nɨnɔ a ndɨ mika Sala. ");
INSERT INTO lik_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala nɨnɔ a ndɨ mika Kenanɨ, Kenanɨ nɨnɔ a ndɨ mika Alifakisadi, Alifakisadi nɨnɔ a ndɨ mika Sɛmʉ, Sɛmʉ nɨnɔ a ndɨ mika Nʉa, Nʉa nɨnɔ a ndɨ mika Lameki. ");
INSERT INTO lik_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lameki nɨnɔ a ndɨ mika Metusɛla, Metusɛla nɨnɔ a ndɨ mika Ɨnʉka, Ɨnʉka nɨnɔ a ndɨ mika Yaledi, Yaledi nɨnɔ a ndɨ mika Maleleli, Maleleli nɨnɔ a ndɨ mika Kainana. ");
INSERT INTO lik_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kainana nɨnɔ a ndɨ mika Enosi, Enosi nɨnɔ a ndɨ mika Sɛtɨ, Sɛtɨ nɨnɔ a ndɨ mika Adamʉ, Adamʉ nɨnɔ a ndɨ miko Kunzi. ");
INSERT INTO lik_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yeso igoku kʉwa ka mutili ma Yɔlɔdanɨ, mutumo na Lɨmbɛngɨ-Lotu. Lɨmbɛngɨ lɨ nɨlɔ a ndɨ kakpokyoniso kʉ ka ɨsa. ");
INSERT INTO lik_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Kʉ ɓɛyɔ, mumuyoniso a ndɨ kaɓɔɓɔ ka masyɛ ɓatɛkɛɓɛ ɓakwanganya. Kalyalyagɨgʉ ndɨ ka masyɛ mi nɨmɔ. Nɨyɔ masyɛ mi nɨmɔ ɨtʉlyana, ɨmʉkana ndɨ nza. ");
INSERT INTO lik_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Kʉwa wa, mumuyoniso aɓɨkya ɓɛ: «Wakika Miko Kunzi, kpamya lɨtalʉ li nɨlɨ ɨɨtɨ mukati.» ");
INSERT INTO lik_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yeso asikisya ɓɛ: «Moɓiso ko Kunzi aɓɨkya ɓɛ: ‹Ɔɓɨlɨ ka mʉmbanzʉ kɛgʉ asɨ ko bulya malɨlɨ aka.›» ");
INSERT INTO lik_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Kumbuso yi, mumuyoniso ɨnda ndɨ na ɨyɨ ka pa yɨkʉngʉ kʉgbɛ, amanya ko ngbinga ɓemoti, moliki ma ɓʉngama masɨ ma ɔɓɨlɨ. ");
INSERT INTO lik_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","Aɓɨkya ɓɛ: «Wakoɓuna moli kambwa kamɨ kebibiso, nʉpátʉ ɓʉngama na ɨbɨba yasɨ nɨyɨ wakaɨna yɨ, kyɛ ɓɛpá ndɨ ɨmɨ. Nakwanana gɔnɨ kapá mʉtʉ wasɨ nɨnɔ napa kapá.» ");
INSERT INTO lik_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yeso amigisya ɓɛ: «Moɓiso ko Kunzi aɓɨkya ɓɛ: ‹Mubibiso Mombukwana-dakʉ Kunzi, waɓanga asɨ ɨyɨ aka mʉkaka.›» ");
INSERT INTO lik_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Mumuyoniso aga ndɨ ɓata na ɨyɨ ka Yelusalɛma, aɗokisa kugbondo wa Ndaɓʉ ko Kunzi, aɓɨkya ɓɛ: «Wakika Miko Kunzi, bumbuko katʉkya wanʉ wadwɛ wasɨ, ");
INSERT INTO lik_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","kyɛ ikpikaga ɓɛ: ‹Kunzi ʉkpamɨlyatʉ ɓamalaika kakɨ ɓɛ ɓuɓuulyogi,› ");
INSERT INTO lik_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ɓʉbɨnɨkɨ ka maɓɔkʉ, ‹kyɛ wakidwoni kʉgʉkɔ ka lɨtalʉ.›» ");
INSERT INTO lik_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Luki limoti, Yeso amigisya ɓɛ: «Moɓiso ko Kunzi akaɓɨkya ɓɛ: ‹Wakaɓoɓonitɔgʉ Mombukwana-dakʉ Kunzi.›» ");
INSERT INTO lik_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Nɨyɔ mumuyoniso ama kʉwa ndɨ kaɓɔɓɔ Yeso ka ɓopisi dididi, asa ndɨ mbɛyɨ. ");
INSERT INTO lik_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Katʉkya kʉwa ndɨ wa, Yeso ɨga ndɨ ka Galilaya mutumo ɓɨɗɛ no ngu ya Lɨmbɛngɨ-Lotu, mongoni kakɨ ɨtʉlyana ndɨ ka iwili yi nɨyɔ yasɨ. ");
INSERT INTO lik_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Atɨwaga ndɨ ka ɓandaɓʉ ɓaya malʉmba ka Ɓayuda na ɓambanzʉ ɓasɨ ɓa ndɨ kabɨba. ");
INSERT INTO lik_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yeso ɨnda ndɨ ka Nazalɛtɨ, kʉ opinga ndɨ mino. Lɨsyɛ la kimumbiso, ingya ndɨ ka ndaɓʉ ya malʉmba ka Ɓayuda mʉɗɔngɔnɨ ɓɛgɛyɔ agyaga ndɨ mino. Amaga ndɨ katangʉlaga Moɓiso. ");
INSERT INTO lik_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ɓapá kɨtaɓʉ nɨyɔ mugyalandʉ Isaya okpika ndɨ. Akʉlana, ɨna ndɨ pa nɨyɔ ikpikaga mino ɓɛ: ");
INSERT INTO lik_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Lɨmbɛngɨ ka Mombukwono-dosu a pa imoti na ɨmɨ, kyɛ egboɗya ndɨ molingo kaʉɓɨkyaga ɓatʉ ɓayangya Mongoni Manza. Etikoku kaʉɓɨkyaga ɓatʉ ɓa ligbito ɓɛ ɓakʉlɨkanagatʉ, nɨɓɔ ɓa na ɓokoloɓu ɓaya mamɔmɔ ɓɛ miso ʉkʉlɨkanatʉ ɓata, nɨɓɔ ɓakaigyogyiso ɓɛ ɓakʉlɨkanagatʉ, ");
INSERT INTO lik_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","kaɓɨkya bulyo syangasʉ si nɨsɔ Mombukwono-dosu uwonisila ndɛkɛ mino ɓambanzʉ ɓʉnza kakɨ.» ");
INSERT INTO lik_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Kumbuso yi Yeso oɗukufa kɨtaɓʉ, amigisya ndɨ mʉgya-ligubo. Ɓambanzʉ ɓasɨ nɨɓɔ ɓa ndɨ wa, ɓa kʉwa ndɨ kanda asa ɨyɨ aka ɓɨngbangbangba. ");
INSERT INTO lik_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Kʉwa wa, apʉnga ndɨ kaʉɓɨkya ɓɛ: «Na lɨsyɛ li nɨlɨ, Moɓiso mi nɨma itulyonini kʉgʉ kunu nɨɓɔ makɛmʉkana.» ");
INSERT INTO lik_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ɓambanzʉ ɓasɨ ɓa ndɨ kabibisa Yeso, nɔkʉ ʉdɨka ndɨ ɓɨdɛ ko bulya mʉnzɨna mʉmbanga-mbanga nɨmɔ a ndɨ kopupa ka mʉnɔkʉ kakɨ. Ɓaɓɨkyaga ndɨ ɓɛ: «Kɛgʉ mbɛyɨ asɨ mika Yɛzɛfʉ aka mʉ!» ");
INSERT INTO lik_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yeso ʉɓɨkya ɓɛ: «Lɨngʉnʉ aka makwanana ɓanʉ kɛtʉlya ligbitoku li nɨlɨ: ‹Mʉnganga, wihukusanɔ nɨ ɨwɛ mombukwana-dakɨ yi.› Mɛɓɨkyatʉ ɓanʉ gɔnɨ ɓɛ: ‹Tʉkana ndɨ masɨ nɨmɔ wagya ndɨ ka Kapɛlɛnaumu, gya kʉwa ɓɛgɛyɔ wa kʉnʉ wa.›» ");
INSERT INTO lik_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Uɓikyoku ɓata ɓɛ: «A lɨngʉnʉ, nakamʉɓɨkya ambɛ, mugyalandʉ gʉtʉgʉ ɓemoti aka, kɛgʉ na ɨbɨba ka mugi mi nɨnɔ iɓukuti mino. ");
INSERT INTO lik_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Na ɓata, nakwanana kamʉɓɨkya lɨngʉnʉ aka ambɛ ko ngbingo ka mugyalandʉ Ɨlɨya, ɓowoko ɓoko ɓi ɓa ndɨ ɓakpʉ ka Izaleli. Ko ngbingo yi nɨnɔ mbwayɨ kalʉkagɨgʉ ndɨ ka ɓyanga ɓɨsaa na ɓatɨmba maɗɨya. Kʉwa wa mufefenge ma nza ɨtʉlyana ndɨ ka mugi masɨ. ");
INSERT INTO lik_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Gʉtʉgʉ ɓɛyɔ, Kunzi katɨkagʉ ndɨ Ɨlɨya ka ɓemoti luga kaɓʉ kiki asɨ ko woko ɓemoti muko yi aka nɨnɔ ikaga ndɨ ka Zalɛpɛta ka iwili ya Sidɔna. ");
INSERT INTO lik_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Na gɔnɨ, ɓakeɓu-keɓu ɓa ndɨ ɓudingi kʉgbɛ ka Izaleli ko ngbingo ka mugyalandʉ Elisa. Wɨna sɛ, gʉtʉgʉ ɓemoti kaɓʉ aka luga kaɓʉ kahʉkagʉ ndɨ kiki asɨ Namani aka nɨnɔ mʉtʉ wa iwili ya Sulia.» ");
INSERT INTO lik_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Nɨyɔ ɓambanzʉ ɓasɨ nɨɓɔ ɓa ndɨ ka ndaɓʉ ya malʉmba ka Ɓayuda ɓʉkana lɨkpʉmʉka li nɨlɔ, mambɛngɨ ʉkandɨkanaga ndɨ ɓɨsʉlʉ-sʉlʉ. ");
INSERT INTO lik_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ɓamanana ndɨ ɓigwo, ɓatindikaga ndɨ Yeso kunzi wa gʉɗʉ, ɓɨnda ndɨ na ɨyɨ kʉgʉ wa ngʉpa nɨyɔ ɓopika ndɨ mino gʉɗʉ kaɓʉ, kyɛ ɓa ndɨ kapa katindikoku kʉnʉ wasɨ. ");
INSERT INTO lik_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Luki limoti, akɨtaga ndɨ luga kaɓʉ, ɨmagalya ndɨ ɨyɨ ya kakɨ. ");
INSERT INTO lik_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yeso osya ndɨ kʉwa ka Kapɛlɛnaumu, gʉɗʉ wa iwili ya Galilaya. Kʉ ɓɛyɔ ʉtɨwaga ndɨ ɓambanzʉ ɓasɨ ka Lɨsyɛ la kimumbiso. ");
INSERT INTO lik_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Mʉtʉʉ kakɨ ʉmbangaga ndɨ ɓambanzʉ kʉgbɛ kyɛ atɨwaga ndɨ no ngu. ");
INSERT INTO lik_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Kʉsɔ wa ndaɓʉ ya malʉmba ka Ɓayuda, alʉkʉ ɓemoti a ndɨ na lɨmbɛngɨ la ɓʉnyɛ. Apʉnga ndɨ kakʉgwaga: ");
INSERT INTO lik_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Hu! Yeso mʉtʉ wa Nazalɛtɨ, lo kusu na iɓunu ogwogi ɓʉnɨ? Woduku ɓi katimosisyo? Nakaumiba ɓɨnza ambɛ ɨwɛ nɨ wanɨ. Ɨwɛ nɨ Mʉtʉ Wotu ko Kunzi.» ");
INSERT INTO lik_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yeso apamyaga ndɨ lɨmbɛngɨ la ɓʉnyɛ, aɓɨkya ɓɛ: «Daka! Pupa ka alʉkʉ yi nɨmʉ!» Lɨmbɛngɨ la ɓʉnyɛ li nɨlɔ abʉmya ndɨ alʉkʉ nɔ wasɨ ɓɨngɔmʉ kambwa ka ɓambanzʉ ɓasɨ, opupa ndɨ nɨ kagyogyisigʉ ");
INSERT INTO lik_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Lɨkpʉmʉka li nɨlɔ ʉmbanga ndɨ ɓambanzʉ ɓasɨ, ɓapʉnga ndɨ kaimuusa luga kaɓʉ ɓɛ: «Inguo ya mʉnzɨna tina pɨyɛ ma? Akapa mʉtʉʉ ka mambɛngɨ ma ɓʉnyɛ no ɓou no ngu, anopupo!» ");
INSERT INTO lik_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Mongoni ka Yeso ɨtʉlyana ndɨ pa yasɨ ka iwili yi nɨyɔ. ");
INSERT INTO lik_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yeso opupa ndɨ ka ndaɓʉ ya malʉmba ka Ɓayuda, aga kʉ ka Simoni. Tɨtakɨ Simoni nɨnɔ muko yi a ndɨ kayɨmʉkana ɓʉdɨ, ɓaɓɨkya ndɨ Yeso ɓɛ ahukusi. ");
INSERT INTO lik_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yeso akpʉɗa ndɨ, adidikyo. Apamya ndɨ koloɓu, koloɓu osyo. Wa aka wa, ahʉka ndɨ, apʉnga ndɨ kahugugubyo. ");
INSERT INTO lik_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ngbingo yi nɨnɔ mɔnɨ odidiko mino, ɓadulyoku ndɨ na ɓatʉ ɓasɨ nɨɓɔ ɓa ndɨ na ɓokoloɓu dididi. Ubisilyaga ndɨ maɓɔkʉ yɨkaka-yɨkaka, anuhukuso. ");
INSERT INTO lik_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Mambɛngɨ ma ɓʉnyɛ upupagatʉ ndɨ gɔnɨ ɓatʉ ɓudingi, anapamɨkanaga ɓɛ: «Ɨwɛ, nɨ Miko Kunzi!» Luki limoti Yeso ʉnzɨnɨlyaga ndɨ na ɗɨya, anʉpakya kanzɨna kyɛ ɓa ndɨ kamibo ɓɛ ɨyɨ nɨ Masiya. ");
INSERT INTO lik_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Nɨyɔ lɨsyɛ asyɛ, Yeso opupa ndɨ kaɨnda ka pa nɨyɔ mʉmbanzʉ kɛgʉ ndɨ mino. Ambaza ka ɓambanzʉ apʉnga ndɨ kakɨsa, nɨyɔ ɓamɨna, ɓa ndɨ kapa kakpɨngba ɓɛ kusonitɔgʉ ɓata. ");
INSERT INTO lik_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Luki limoti, Yeso ʉɓɨkya ɓɛ: «Okwononi gɔnɨ kaɓɨkyaga Mongoni Manza ma Ɓʉngama ko Kunzi ka ɓagʉɗʉ ɓagɔgɔ, kyɛ Kunzi etikoku ndɨ ko bulya yi nɨyɔ.» ");
INSERT INTO lik_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Idukulaga ndɨ kaɓɨkyaga Mongoni Manza ka ɓandaɓʉ ɓaya malʉmba ka Ɓayuda. ");
INSERT INTO lik_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Lɨsyɛ limoti, Yeso a ndɨ wakamaga ka kpɔlɔ-kpɔlɔ wa ibombu ya Gɛnɛzalɛtɨ. Ambaza ka ɓambanzʉ otundukonoku ndɨ kahʉkana Mongoni Manza ko Kunzi, ɓamotosyo ɓɨkpwɔ. ");
INSERT INTO lik_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ɨna ndɨ mangbɔlɔ maɓa ɓuwobi na kubi. Ɓogwi ɓosi ɓɔ ɓafʉma ndɨ, ɓosya kasʉkʉsa moyo kaɓʉ. ");
INSERT INTO lik_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yeso aɗaka ndɨ ka ɨngbɔlɔ imoti, nɨyɔ ka Simoni, aɓɨkya ndɨ ɓɛ osisili mbɛyɨ mino ɓyɨ na kubi. Ika kʉwa ndɨ ka ɨngbɔlɔ, apʉnga kapá mʉtɨwɨ ka ambaza ka ɓambanzʉ. ");
INSERT INTO lik_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Nɨyɔ ama kanzɨna ɓɛyɔ, aɓɨkya Simoni ɓɛ: «Sisilo ɨngbɔlɔ ka pa yodu, kumbuso yi, molubo moyo kunu.» ");
INSERT INTO lik_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simoni amigisya ɓɛ: «Muwonisilo, tosilyi luba moyo, luki limoti takogwigʉ musi gʉtʉgʉ ɓemoti aka. Yɛkɨ ɨwɛ kʉwa nɔ wekpomyi, nɨgɨlyatʉ ɓata kolubo.» ");
INSERT INTO lik_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ɓoluba kʉwa ndɨ, ɓugwi ɓosi ɓudingi kʉgbɛ, moyo kaɓʉ apʉnga ndɨ katɨnɨkaga. ");
INSERT INTO lik_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ɓʉmaka ndɨ na maɓɔkʉ ɓawai-daɓʉ nɨɓɔ ɓasɨkana ndɨ ka ɨngbɔlɔ yagɔgɔ ɓɛ ɓusingyiku kanyɔ moyo. Ɓodoku ndɨ, ɨɓʉ ɓasɨ pa imoti, ɓotumisa ndɨ mangbɔlɔ masɨ maɓa na ɓosi, apʉnga ndɨ komwaga liɓo. ");
INSERT INTO lik_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Nɨyɔ Simoni Pɛtɛlɛ ɨna ɓɛyɔ, ogwa no moli kambwa ka Yeso, aɓɨkya ɓɛ: «Mombukwono-dosu, tʉkya ɓuwobi na ɨmɨ kyɛ na mʉtʉ wa ɓʉnyɛ!» ");
INSERT INTO lik_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Kyɛ kʉɓangakʉ agya ndɨ kʉgbɛ, kaʉmɨna ɓosi ɓudingi nɨɓɔ ɓugwi ndɨ ɓɔ. ");
INSERT INTO lik_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Gʉtʉgʉ Yakɔbɔ na Yuani ɓomika Zɛbɛdayɔ aka, ɓawai-dakɨ Simoni, ɓaɓanga ndɨ ɨɓʉ ɓɛgɛyɔ. Luki limoti, Yeso aɓɨkya ndɨ Simoni ɓɛ: «Wakoɓongonitɔgʉ, katʉkya mbɨya wanʉ, wakikigʉ ɓata mʉnyɔ ɓosi, luki limoti wika kʉwa mʉnyɔ ɓambanzʉ ka ɓʉnyɛ kaɓʉ.» ");
INSERT INTO lik_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ɓafʉma ndɨ mangbɔlɔ, ɓasa masɨ, ɓapʉnga kaɓɨɓyo yi. ");
INSERT INTO lik_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ngbingo yi nɨnɔ Yeso a ndɨ mino ka gʉɗʉ ɓemoti ɓɛnɛ, mʉtʉ ɓemoti nɨnɔ keɓu-keɓu a ndɨ nɨ amoni nzʉyɨ yasɨ ɓɨtɨta, asilyoku ndɨ. Nɨyɔ amɨna Yeso, ogwa mokpukpu kambwa kakɨ, ɨgama na ɨyɨ ɓɛ: «Mombukwono-dosu! Wakapa, wakwanana ɓaka kengumoso.» ");
INSERT INTO lik_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yeso anana ndɨ kʉɓɔkʉkɔ, avɨla, aɓɨkya ɓɛ: «Noponi, ngʉmana!» Ko ngbingo yi nɨnɔ aka nɔ, alʉkʉ nɔ angʉmana ndɨ ɓɨngɔ. ");
INSERT INTO lik_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Kʉwa wa Yeso agbɨtyaga ɓɨkpɔkpɔkpɔ ɓɛ: «Wakatumbulyogonitɔgʉ mʉmbanzʉ. Luki limoti, wɨnda kayiwonisyo ko kumu, kumbuso yi, wapá apɛpɛ ɓɛyɔ Mʉtʉʉ ka Musa aɓɨkyo mino, iba mʉtʉ wasɨ ibi ɓɛ woukini ɓi.» ");
INSERT INTO lik_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Gʉtʉgʉ ɓɛyɔ, mongoni ka Yeso a kʉwa ndɨ asɨ kaɗa aka kʉgbɛ. Ɓambaza ɓakpʉkpʉ ka ɓambanzʉ ɓamʉmʉkanaga ndɨ kamʉkana, anohukuso ɓokoloɓu kaɓʉ. ");
INSERT INTO lik_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Luki limoti Yeso atʉkyaga ndɨ ɓɨpɛlɛ luga kaɓʉ, ɨnda ka ɨsa kalʉmba. ");
INSERT INTO lik_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","A kʉwa ndɨ lɨsyɛ limoti, Yeso a ndɨ kapa mʉtɨwɨ. Ɓafalisayɔ na ɓowonisilo ɓa Mʉtʉʉ ka Musa ɓa ndɨ ɓukuliko wa gɔ wa, ɓodoku ndɨ katʉkya ko giyo yasɨ ya Galilaya, ya Yudɛa na ka gʉɗʉ wa Yelusalɛma. Ngu ka Mombukwono-dosu yɔ apága ndɨ ɓututungyo kohukuso ɓokoloɓu. ");
INSERT INTO lik_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Wɨna sɛ ɓambanzʉ ɓosiloku ndɨ, nɨ ɓabinikini zɛgɛsɨ ɓemoti kʉgʉ wa kalagba. Ɓa ndɨ kakɨsa pisi kaguliso ka ndaɓʉ nɨyɔ Yeso a ndɨ mino, na kabiso kambwa kakɨ. ");
INSERT INTO lik_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Luki limoti, ɓakɛgʉ ndɨ kaiba ɓɛ ɓagulisa pisi yanɨ ko bulya ambaza ka ɓambanzʉ. Ɓaɗaka kʉwa ndɨ na ɨyɨ kugbondo, ɓatʉmba ndɨ mino mapala koukulya ngala, ɓasisa kʉwa ndɨ na kalagba kakɨ luga ka ɓambanzʉ, kambwa ka Yeso. ");
INSERT INTO lik_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Nɨyɔ Yeso ɨna baya kaɓʉ ɓɛyɔ, aɓɨkya ndɨ zɛgɛsɨ nɔ ɓɛ: «Yɛ wai, nupilyini ɓʉnyɛ kakʉ.» ");
INSERT INTO lik_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ɓowonisilo ɓa mʉtʉʉ na Ɓafalisayɔ ɓapʉnga ndɨ kaimuusa ɓɛ: «Mʉtʉ tino pɨyɛ mʉna akatʉmbwa Kunzi mʉ? Wanɨ nɔ akwanana kapɨlya ɓʉnyɛ, kiki Kunzi aka yɨkaka?» ");
INSERT INTO lik_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yeso andʉnga ndɨ mʉtamanagɨ kaɓʉ, umuusa ɓɛ: «Ko bulya ɨkɨ yɔ mo mino na mʉtamanagɨ mi nɨmɔ? ");
INSERT INTO lik_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ɨkɨ yɔ a yopoli kʉgbɛ kaɓɨkya ɓɛ: ‹Nupilyini ɓʉnyɛ kakʉ!›, ikanɨ kaɓɨkya ɓɛ: ‹Wamaga, wakpakyana!› ");
INSERT INTO lik_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Luki limoti, nakapa kamumibiso ambɛ Mika-mʉmbanzʉ a no ngu yasɨ kʉnʉ ka lɨtɔmbʉ kapɨlya ɓʉnyɛ.» Kʉwa wa aɓɨkya ndɨ zɛgɛsɨ nɔ ɓɛ: «Nakaʉɓɨkya ambɛ wamaga, wava kalagba kakʉ, wɨga kʉ kakʉ!» ");
INSERT INTO lik_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Wa aka wa, alʉkʉ nɔ amaga ndɨ ko misa ka ɓatʉ ɓasɨ, abɨnɨka kalagba nɨyɔ a ndɨ mino wakanga, aga kʉ kakɨ nɨ anabibiso Kunzi. ");
INSERT INTO lik_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Lɨkpʉmʉka lɔ ʉmbanga ndɨ ɓambanzʉ ɓasɨ. Ɓasɨ ba ndɨ kabibiso Kunzi nɨ kʉɓangakʉ utumini ka mambɛngɨ ɓɨɗɛ, ɓanaɓɨkya ɓɛ: «Tinini lɨkpʉmʉka lɨmbanga na lɨsyɛ li nɨlɨ.» ");
INSERT INTO lik_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Kumbusa wa nɨyɔ, Yeso opupa ndɨ, amɨna ndɔmbɛ wa manzanza ɓemoti, ina ndɨ ɓɛ Lawi, wakiko ka bilo kakɨ. Yeso aka na ɨyɨ aka ɓɛ: «Iɓyeku!» ");
INSERT INTO lik_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lawi amaga, asa ndɨ makpʉmʉka masɨ, apʉnga kaɓɨɓya. ");
INSERT INTO lik_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Kʉwa wa, Lawi alyisisya ndɨ Yeso dumo mudingi kʉ kakɨ, ɓandɔmbɛ ɓa manzanza ɓakpʉ na ɓatʉ ɓagɔgɔ ɓa ndɨ kalyalya pa imoti na ɨɓʉ. ");
INSERT INTO lik_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ɓafalisayɔ na ɓowonisilo ɓa mʉtʉʉ nɨɓɔ ɓikaga ndɨ na ɨɓʉ, ɓapʉnga ndɨ kaɨnzɨnzɨnya ka kpɔlɔ, ɓanumuusa ɓaɓɨɓya ka Yeso ɓɛ: «Ko bulya ɨkɨ yɔ makalyalya na komwo pa imoti na ɓandɔmbɛ ɓa manzanza na ɓagya-manyɛ?» ");
INSERT INTO lik_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yeso umigisya ɓɛ: «Ɓatʉ ɓapʉpʉ ɓakakɨsagɨgʉ mʉnganga, luki limoti, nɨɓɔ aka ɓɔ ɓa ɓokoloɓu ɓɔ ɓakɨsaga. ");
INSERT INTO lik_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nakodokugʉ kaʉkɨsa ɓatʉ ɓongbingbili, luki limoti nɨɓɔ ɓanyɛ, iba kyɛ ɓayikosi ɔɓɨlɨ kaɓʉ.» ");
INSERT INTO lik_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ɓafalisayɔ ɓaɓɨkya ndɨ Yeso ɓɛ: «Ɓaɓɨɓya ka Yuani na nɨɓɔ kusu ɓoginyagatʉ malɨlɨ ko ngbingo ɓɨgala-gala, ɓalʉmbagatʉ gɔnɨ. Luki limoti nɨɓɔ kakʉ, ɓikaga ɨɓʉ asɨ kalyalya na komwo aka ko ngbingo yi nɨnɔ.» ");
INSERT INTO lik_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yeso umigisya ɓɛ: «Makasɨma ɓɛ makwanana kaʉgbʉma ɓambanzʉ nɨɓɔ ɓumoki ko dumo wo vononi ɓɛ ɓakolyolyonitɔgʉ ko ngbingo yi nɨnɔ ɓo mino pa imoti na mbʉnya muko? Kigyonosigʉ! ");
INSERT INTO lik_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Luki limoti, ikatʉ ndɛkɛ na lɨsyɛ nɨlɔ ɓatʉmba mino mbʉnya muko luga kaɓʉ. Ka lɨsyɛ li nɨlɔ, ɓoginyatʉ ndɛkɛ malɨlɨ ko ngbingo.» ");
INSERT INTO lik_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yeso utulyoku gɔnɨ lizuni li nɨlɨ: «Mʉmbanzʉ gʉtʉgʉ ɓemoti aka kanʉagɨgʉ panga ya kutuko kwambɨya koɗiko noyu ɨnzanza, kagya ɓɛyɔ, kutuko nɨkwɔ kwa mbɨya kwɔ anʉɨka kyɛ panga yi nɨyɔ yambɨya yɔ kakwananɨgʉ na ɨnzanza. ");
INSERT INTO lik_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Sɛ kʉwa gɔnɨ, mʉmbanzʉ gʉtʉgʉ ɓemoti aka kaɓʉngwagɨgʉ vinya wambɨya ka ɓambɨkɛ ɓayo bokuto ta ɓanyama ɓayɨgbangbalaga. Kagya ɓɛyɔ, vinya opumukisagatʉ ɓambɨkɛ, vinya agbɔ wasɨ. ");
INSERT INTO lik_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Kinili, okwononi kaɗuko vinya wambɨya ka ɓambɨkɛ ɓayambɨya gɔnɨ. ");
INSERT INTO lik_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Na gɔnɨ, mʉmbanzʉ gʉtʉgʉ ɓemoti aka kakwananɨgʉ kapa kamwo vinya wambɨya nɨ amwini sɛ nɨnɔ mʉkpaga. Kyɛ aɓɨkya ɓɛ: ‹Nɨnɔ mʉkpaga a wanza kʉgbɛ.›» ");
INSERT INTO lik_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Lɨsyɛ la kimumbiso limoti, Yeso na ɓaɓɨɓya kakɨ ɓa ndɨ kakɨtaga pisi ka ɓotiko ɓaya nganʉ. Ɓaɓɨɓya kakɨ ɓanatɨnaga ɓɛkazo ɓi, ɓanatubo na maɓɔkʉ, ɓanalya. ");
INSERT INTO lik_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ɓafalisayɔ ɓemoti-ɓemoti nɨɓɔ ɓa ndɨ wa, ɓumuusa ɓɛ: «Ko bulya ɨkɨ yɔ makagya nɨlɔ ɓapakya kagya ka Lɨsyɛ la kimumbiso?» ");
INSERT INTO lik_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yeso umigisya ɓɛ: «Makatangʉlagagʉ ndɨ lɨkpʉmʉka nɨlɔ ngama Daudi agya ngbingo yi nɨnɔ ɓa ndɨ mino na ɓanza ɨɓʉ na ɓawai-dakɨ? ");
INSERT INTO lik_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ingya ndɨ ka Ndaɓʉ ko Kunzi, ava mukati nɨmɔ ɓapága ndɨ Kunzi. Alya, ʉpá gɔnɨ ndɨ ɓawai-dakɨ, gʉtʉgʉ ɓɛyɔ ɓokumu ɓalyaga ndɨ mino nɨ ɨɓʉ aka mukati mi nɨmɔ.» ");
INSERT INTO lik_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yeso ʉɓɨkya ɓata ndɨ ɓɛ: «Mika-mʉmbanzʉ nɔ a mombukwana Lɨsyɛ la kimumbiso.» ");
INSERT INTO lik_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","A ndɨ ɓata Lɨsyɛ la kimumbiso lagɔgɔ, Yeso ogulya ka ndaɓʉ ya malʉmba ka Ɓayuda, apʉnga ndɨ kapá mʉtɨwɨ. Kʉ ɓɛyɔ, mʉtʉ ɓemoti a ndɨ na kʉɓɔkʉkɔ kwa kʉmbanzɨkanɨkɔ kukwo. ");
INSERT INTO lik_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ɓowonisilo ɓa mʉtʉʉ na Ɓafalisayɔ ɓa ndɨ kanda Yeso ɓɨngbangbangba, ɓɛ ikanɨ ahukusatʉ mʉmbanzʉ ka Lɨsyɛ la kimumbiso. A ɓɛyɔ, ɓa ndɨ kakɨsa ɓɛ ɓamɨna na ɨɓɔ no pisi tino, kyɛ ɓasʉngʉlyɨ. ");
INSERT INTO lik_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Luki limoti, Yeso a ndɨ kaiba tamanaga kaɓʉ. Aɓɨkya kʉwa alʉkʉ nɔ a ndɨ kʉɓɔkʉkɔ kukwa nɔ ɓɛ: «Wamaga, wodoku wa luga ka ɓambanzʉ wa.» Amaga ndɨ, isisilo luga kaɓʉ. ");
INSERT INTO lik_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Kumbuso yi, Yeso ʉɓɨkya ɓɛ: «Nakamumuusa ambɛ: Luki tina pɨyɛ lɔ okwononi kagya ka Lɨsyɛ la kimumbiso? Kagya lɨkpʉmʉka lanza ka Lɨsyɛ la kimumbiso ikanɨgʉ kagya lɨkpʉmʉka lanyɛ? Kahukuso ɔɓɨlɨ ka mʉmbanzʉ ikanɨ kapʉta?» ");
INSERT INTO lik_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yeso ʉnda ɨɓʉ ɓasɨ ɓizumuuu, kumbuso yi, aɓɨkya kʉwa alʉkʉ nɔ ɓɛ: «Nana kʉɓɔkʉkɔ.» Anana ndɨ, kʉɓɔkʉkɔ ahʉka ɓɛyɔ aka yɔ ikaga ndɨ mino. ");
INSERT INTO lik_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Luki limoti, mambɛngɨ ʉkandɨkanaga ndɨ ɓowonisilo ɓa mʉtʉʉ na Ɓafalisayɔ ɓɨsʉlʉ-sʉlʉ, ɓapʉnga ndɨ kaimuusa luga kaɓʉ ɓɛ ɓakwanana kagya Yeso ɓʉnɨ. ");
INSERT INTO lik_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ka masyɛ mi ndɨ nɨmɔ, Yeso aga kalʉmba ka ngʉpa, asɨlya ndɨ asɨ malʉmba aka. ");
INSERT INTO lik_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Nɨyɔ lɨsyɛ asyɛ, ʉmaka ɓaɓɨɓya kakɨ, ʉpʉnaga tɛkɛɓɛ na ɓaɓa luga kaɓʉ nɨɓɔ ʉlʉka kʉwa ndɨ ɓɛ ɓatʉtʉmbwa. ");
INSERT INTO lik_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","A ndɨ nɨ: Simoni (nɨnɔ Yeso alʉka ndɨ gɔnɨ ɓɛ Pɛtɛlɛ), mamakɨ ɓɛyɔ ka Andɨlɨa, Yakɔbɔ, Yuani, Filipi, Batulumei, ");
INSERT INTO lik_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matayɔ, Tʉma, Yakɔbɔ yi nɨnɔ mika Alʉfayɔ, Simoni nɨnɔ a ndɨ kakɨsa ɨpandasɨ ka mugi kaɓʉ, ");
INSERT INTO lik_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yuda mika Yakɔbɔ sɛ kʉwa Yuda Isikalioti nɨnɔ agaba ndɨ Yeso. ");
INSERT INTO lik_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yeso pa imoti na ɓaɓɨɓya kakɨ ɓosyoku ndɨ ka ngʉpa, ɓamaga ndɨ ka pa yanza ɓɨkpa. Wa ɓɛyɔ, ɓaɓɨɓya kakɨ ɓagɔgɔ ɓudingi ɓa ndɨ wa. Ambaza wakpʉ ka ɓambanzʉ a ndɨ wa gɔ wa: ɓambanzʉ nɨɓɔ ɓodoku ndɨ katʉkya iwili yasɨ ya Yudɛa, ka gʉɗʉ wa Yelusalɛma, ka mutili ma Tilo sɛ kʉwa Sidɔna. ");
INSERT INTO lik_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ɓodoku ndɨ kamʉkana na ɓɛ Yeso uhukusi. Gʉtʉgʉ nɨɓɔ mambɛngɨ ma ɓʉnyɛ a ndɨ kaugyogyiso, ɓahʉka ndɨ. ");
INSERT INTO lik_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ɓambanzʉ ɓasɨ ɓakɨsaga ndɨ kavɨla, kyɛ a ndɨ no ngu kʉsɔ kakɨ nɨyɔ uhukusaga ndɨ na iyu ɨɓʉ ɓasɨ. ");
INSERT INTO lik_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Kʉwa wa Yeso ʉnda ndɨ ɓaɓɨɓya kakɨ ɓizumuuu aɓɨkya ɓɛ: «Ɨgyagya kunu iɓunu yi nɨɓɔ ma na yangya, kyɛ Ɓʉngama ko Kunzi a ɓo kunu! ");
INSERT INTO lik_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ɨgyagya kunu iɓunu yi nɨɓɔ ma na nza mbɨya yi nɨmʉ, kyɛ mikutatʉ ndɛkɛ! Ɨgyagya kunu iɓunu yi nɨɓɔ ma kagama mbɨya yi nɨmʉ, kyɛ matɨbatʉ ndɛkɛ! ");
INSERT INTO lik_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Gwoni magyagya kika kanɨ ɓambanzʉ ɓakamʉmʉya, ɓanamʉkya, ɓanamʉtʉmbwa, ɓanamʉbɨnɨkya makpʉmʉka manyɛnyɛ ɓitititi, ko bulya ko Mika-mʉmbanzʉ. ");
INSERT INTO lik_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ka lɨsyɛ li nɨlɔ, gwoni magyagya, mobumbukaga ɓɨtɨta-tɨta, kyɛ minisona ndɛkɛ na mʉkalya mudingi kʉgʉ wa lɨsyɛ. A ɓɛyɔ, a mʉɗɔngɔnɨ ɓɛgɛyɔ ɓatɨtaɓʉ ɓugyogyisaga ndɨ mino ɓogyalandʉ. ");
INSERT INTO lik_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Luki limoti, kumbu kunu iɓunu yi nɨɓɔ ma na mukumbo, kyɛ ɨgyagya kunu kʉwa yu nɨyɔ aka yɔ mo mino yɔ! ");
INSERT INTO lik_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Kumbu kunu iɓunu yi nɨɓɔ ma ɓakikutogo mbɨya yi wanʉ, kyɛ mɨmʉkanatʉ ndɛkɛ nza! Kumbu kunu iɓunu yi nɨɓɔ makatɨba mbɨya wanʉ, kyɛ malyatʉ ndɛkɛ kumbu, migomisogo! ");
INSERT INTO lik_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Kumbu kunu kika nɨ ɓambanzʉ ɓasɨ ɓakamʉbɨba, kyɛ a mʉɗɔngɔnɨ ɓɛgɛyɔ ɓatɨtaɓʉ ɓʉgyaga ndɨ mino ɓogyalandʉ ɓa kʉɓɔɓɔkʉ.» ");
INSERT INTO lik_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«Luki limoti, nakamʉɓɨkya iɓunu nɨɓɔ makɛmʉkana ambɛ: Huponi ɓomuyoniso kunu, hugyoni ɓɨnza nɨɓɔ ɓakamʉmʉya. ");
INSERT INTO lik_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Wolikyoni ɓʉɓʉnga ko Kunzi ka nɨɓɔ ɓakamugbusyo, mʉkʉngʉlya nɨɓɔ ɓakamugyogyiso. ");
INSERT INTO lik_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Mʉmbanzʉ kʉɓɨta ka panga, wayikosilya gɔnɨ nɨyɔ yagɔgɔ. Mʉmbanzʉ kʉkʉpya koti kakʉ, wasɨlya gɔnɨ simizi. ");
INSERT INTO lik_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mʉmbanzʉ wasɨ kʉkʉnga luki, wapá. Mʉmbanzʉ kʉkʉpya luki, wakaɓikyonitɔgʉ ɓɛ umigisilyi. ");
INSERT INTO lik_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Nɨlɔ mapaga ɓɛ ɓamʉgyɨlyɨ, ugyilyoni ɓɛngɛnɨ mʉɗɔngɔnɨ ɓɛgɛyɔ. ");
INSERT INTO lik_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Kika nɨ mʉpaga nɨɓɔ aka ɓɔ ɓamʉpaga, minisana na ɨzangɨya tino? Gʉtʉgʉ ɓatʉ ɓanyɛ ɓapananaga luga kaɓʉ aka gɔnɨ. ");
INSERT INTO lik_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Kika nɨ magyaga ɓʉnza ka nɨɓɔ aka ɓɔ ɓamʉgyɨlyaga ɓʉnza, minisana na ɨzangɨya tino? Gʉtʉgʉ ɓatʉ ɓanyɛ aka ɓagyaga ɓɛgɛyɔ. ");
INSERT INTO lik_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Minisana na ɨzangɨya tino, kika nɨ mukupisaga iɓunu ɓatʉ ɓi nɨɓɔ aka ɓɔ ɓakwanana kamumigisilyo? Gʉtʉgʉ ɓatʉ ɓanyɛ ɓokupisanaga luga kaɓʉ aka iba ɓigisyoni luki li nɨlɔ aka lɔ! ");
INSERT INTO lik_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Luki limoti, iɓunu huponi ɓomuyoniso kunu, hugyoni ɓɨnza. Kupisoni nɨ makɛgʉ ɓata na mʉtamanagɨ ɓɛ ɓamumigisyatʉ. Kʉwa wa, minisana ndɛkɛ na mʉkalya mudingi, mika ndɛkɛ ɓomiko Kunzi nɨnɔ Kʉgʉ-Kʉgbɛ. A ɓɛyɔ, ɓʉnza kakɨ a ka ɓatʉ ɓasɨ iki ka nɨɓɔ ɓakamigisyogigʉ ɨbɨba na ka ɓatʉ ɓanyɛ. ");
INSERT INTO lik_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Wikoni na mambɛngɨ mo kumbu mʉɗɔngɔnɨ ɓɛyɔ Obonu o mino na lɨmbɛngɨ lo kumbu.» ");
INSERT INTO lik_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«Makokonitɔgʉ mʉkɔmbʉ ka mʉmbanzʉ, Kunzi kamʉkʉlyɨgʉ ndɛkɛ nɨmɔ kunu ɓɛgɛyɔ, makubisonitɔgʉ ɓɛngɛnɨ na mʉkɔmbʉ, Kunzi kamubisigʉ ndɛkɛ na mʉkɔmbʉ ɓɛgɛyɔ, hupilyoni ɓɛngɛnɨ, Kunzi amʉpɨlya ndɛkɛ ɓɛgɛyɔ. ");
INSERT INTO lik_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Hupóponi ɓɛngɛnɨ, Kunzi amʉpápa ndɛkɛ ɓɛgɛyɔ. Amuɗukilyaga ndɛkɛ ka mbɨyɔ kunu ɨsangɨ ya mʉpʉnga nɨyɔ yanza, mʉpɨpa, mʉkpɨndɨla ɓɨnza ɓɨmvɨ, mutumo na mʉkala, onogwanana ɓɨgbɨya-gbɨya. A ɓɛyɔ, mʉɗɔngɔnɨ ɓɛyɔ mʉgyaga mino ɓɛngɛnɨ, Kunzi amumigisya ndɛkɛ iɓunu mʉɗɔngɔnɨ ɓɛgɛyɔ.» ");
INSERT INTO lik_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Kʉwa wa Yeso ʉtʉlya ɓata lizuni lagɔgɔ ɓɛ: «Mʉtʉ wa koloɓu ya mamɔmɔ akwananatʉ kakpokyonisa dakɨ? Gʉtʉgʉ iki yi aka! Kagya ɓɛyɔ, ɓogwa ɨɓʉ ɓasɨ ɓaɓa ka lɨɓyɛ. ");
INSERT INTO lik_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Mʉɓɨɓya gʉtʉgʉ ɓemoti aka kakwananɨgʉ kakɨtaga muwonisilo kakɨ, luki limoti mʉɓɨɓya wasɨ nɨnɔ ɓawonisilaga ɓɨnza, ika ndɛkɛ mʉɗɔngɔnɨ abɛ muwonisilo kakɨ. ");
INSERT INTO lik_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ko bulya ɨkɨ yɔ wo mino kamɨna asɨ okuku aka nɨnɔ a ko liso ka mamakʉ, nɨ wakɛgʉ sɛ kaɨna ingbi nɨyɔ a ka nɨlɔ kakʉ? ");
INSERT INTO lik_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Wakwanana pɨyɛ kaɓɨkya mamakʉ lɨkɨ ɓɛ: ‹Ya, gya mbɛyɨ nʉnyʉ okuku ko liso›, ɨwɛ nɨnɔ wakɛgʉ gʉtʉgʉ kaɨna ingbi nɨyɔ a ko liso kakʉ? Ɨwɛ mʉtʉ wa kʉɓɔɓɔkʉ mʉna, wɨnyɔ mbɛyɨ ingbi nɨyɔ a ko liso kakʉ. Kumbuso yi, wakwanana kʉwa kaɨna ɓɨngbanganya kanyɔ okuku nɨnɔ a ko liso ka mamakʉ.» ");
INSERT INTO lik_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«Sɨbʉkʉsɔ sanza kaɓʉkʉtagɨgʉ bumo yanyɛ, na gɔnɨ sɨbʉkʉsɔ sanyɛ kaɓʉkʉtagɨgʉ bumo yanza. ");
INSERT INTO lik_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","A ɓɛyɔ, ɓibaga bʉkʉtɔ tasɨ ko bumo yi aka. Ɓakapwagɨgʉ manga kʉgʉ wa sɨbʉkʉsɔ so mowo, na ɓakapwagɨgʉ mbʉnyɛ kʉgʉ wa muligi mo mowo. ");
INSERT INTO lik_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Mʉtʉ wanza agyaga makpʉmʉka manzanza nɨmɔ opupaga ka lɨmbɛngɨ kakɨ lanza. Mʉtʉ wanyɛ agyaga makpʉmʉka manyɛnyɛ nɨmɔ opupaga ka lɨmbɛngɨ kakɨ lanyɛ. Kyɛ mʉnɔkʉ ka mʉmbanzʉ opupisaga makpʉmʉka nɨmɔ ikaga mutumo ka lɨmbɛngɨ kakɨ.» ");
INSERT INTO lik_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«Ko bulya ɨkɨ yɔ mɛmakaga mino ɓɛ: ‹Mombukwono-dosu, Mombukwono-dosu› nɨ makɛgʉ kagya nɨlɔ nakamʉɓɨkya? ");
INSERT INTO lik_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","48","Mʉtʉ wasɨ nɨnɔ ɛɓɨɓyaga, anʉkana lɨkpʉmʉka kamɨ, anagya, a mʉɗɔngɔnɨ abɛ alʉkʉ ɓemoti nɨnɔ a ndɨ kopika ndaɓʉ. Akpɔ ndɨ lɨɓyɛ lodu, obisa muɓumbe kʉgʉ wa lɨtalʉ. Ngbingo yi nɨnɔ tumo odoku mino, liɓo oɓuna ka ɓakpɔlɔ-kpɔlɔ ɓa ndaɓʉ yi nɨyɔ, luki limoti nɨ koɗukonigʉ, kyɛ ndaɓʉ ipika ndɨ yanza. ");
INSERT INTO lik_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Luki limoti, mʉmbanzʉ wasɨ nɨnɔ ʉkanaga lɨkpʉmʉka kamɨ nɨ kɛgʉ kagya mʉɗɔngɔnɨ ɓɛyɔ no mino kaɓɨkya, a abɛ alʉkʉ ɓemoti nɨnɔ opika ndɨ ndaɓʉ kʉgʉ wa lɨtɔmbʉ aka nɨ kokpugʉ muɓumbe. Ngbingo yi nɨnɔ liɓo okikoku mino ka kpɔlɔ-kpɔlɔ wa ndaɓʉ yi nɨyɔ, oɗukana ndɨ ɓɨgala-gala, yasɨ ɓɨgbatata.» ");
INSERT INTO lik_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ngbingo yi nɨnɔ Yeso ama ndɨ mino kaɓɨkyaga lɨkpʉmʉka lasɨ nɨlɔ a ndɨ na ilu ka ambaza nɨnɔ a ndɨ na ɨyɨ mukungulo nɔ, ogulya kʉwa ndɨ ka gʉɗʉ wa Kapɛlɛnaumu. ");
INSERT INTO lik_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Kʉ ɓɛyɔ, ngama ɓemoti ka ɓasʉda wa Lʉma a ndɨ na mʉgya-ligubo nɨnɔ apaga ndɨ kʉgbɛ. Mʉgya ligubo yi nɨnɔ a ndɨ no koloɓu ɓuwobi kosisa lɨmbɛngɨ. ");
INSERT INTO lik_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Nɨyɔ ngama ka ɓasʉda yi nɨnɔ ʉkana mongoni ka Yeso, atɨkɨlya ndɨ ɓambɔkʉ-mbɔkʉ ɓemoti-ɓemoti ka Ɓayuda ɓɛ ɓamokilyiku, oduku kahukuso mʉgya-ligubo kakɨ. ");
INSERT INTO lik_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Nɨyɔ ɓambɔkʉ-mbɔkʉ ɓi nɨɓɔ ɓadwɛ kʉ Yeso a ndɨ mino, ɓɨtatanaga na ɨyɨ kʉgbɛ, ɓaɓɨkya ɓɛ: «A mʉtʉ nɨnɔ okwononi ɓɛ mʉgyɨlya ɓɛyɔ o mino kaʉɓɨkya, ");
INSERT INTO lik_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","kyɛ apagatʉ mugi kusu, ɨyɨ aka gɔnɨ nɔ atipikisilyo ndaɓʉ kusu ya malʉmba.» ");
INSERT INTO lik_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Kʉwa wa, Yeso aga ndɨ pa imoti na ɨɓʉ. A kʉwa ndɨ ɓuwobi kadwɛ aka ka mʉsɛngɨ, kanɨ ngama yi nɨnɔ anatikilyoku ɓawai-dakɨ kaɓɨkya ɓɛ: «Mombukwono-dosu, wakigbomisonitɔgʉ mʉ. Kokwononigʉ ɓɛ wingyoku kʉnʉ ka ndaɓʉ kamɨ. ");
INSERT INTO lik_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Kinili nimini ɓi gɔnɨ ɨmɨ ambɛ sokwononɨgʉ kaɨnda kʉ kakʉ. Luki limoti, ɓikyanɔ lɨkpʉmʉka limoti aka, mʉgya-ligubo kamɨ akwanana kahʉka. ");
INSERT INTO lik_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ɨmɨ, na kusili wa mʉtʉʉ ka ɓangama kamɨ, na gɔnɨ na na ɓasʉda kusili wa mʉtʉʉ kamɨ. Nakaɓɨkya ɓemoti ambɛ: ‹Waga!›, aga, nakaɓɨkya wagɔgɔ ambɛ: ‹Doku!›, odoku, nakaɓɨkya mʉgya-ligubo kamɨ ambɛ: ‹Gya ɓɛnɛ!›, agya ɓɛyɔ aka yɔ.» ");
INSERT INTO lik_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Nɨyɔ Yeso ʉkana mʉnzɨna mi nɨmɔ ngama ka ɓasʉda a ndɨ kanzɨna mɔ, lɨkpʉmʉka ambanga. Oyikana ndɨ ka ambaza ka ɓambanzʉ nɨnɔ a ndɨ kaɓɨɓya nɔ, ɨyɨ aka ɓɛ: «Nakamʉɓɨkya ɓɨngbanganya ambɛ: Nakaninigʉ ndɛkɛ baya yidingi abɛ nɨyɨ lugo ko ɓomikya Ɓezaleli!» ");
INSERT INTO lik_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Nɨyɔ ɓatʉ nɨɓɔ ɓʉtɨka ndɨ ɓosilo, ɓatakanya ndɨ mʉgya-ligubo nɨ oukini. ");
INSERT INTO lik_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ɓʉgala ɓi, Yeso ɨnda kʉwa ndɨ ka mugi mimoti nɨmɔ ina ndɨ ɓɛ Naini, ɓaɓɨɓya kakɨ na ambaza mudingi ka ɓambanzʉ ɓa ndɨ pa imoti na ɨɓʉ. ");
INSERT INTO lik_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Nɨyɔ ɓa kʉwa ndɨ ɓuwobi kadwɛ ka mupumi ma gʉɗʉ yi nɨnɔ, abangana ndɨ na ɓambanzʉ nɨ ɓanɨnda kolumbo manda ka mʉwanza ɓemoti. Ɨɓʉkʉta ndɨ ɨyɨ mʉkaka aka ka amakɨ, nɨnɔ a kʉwa ndɨ gɔnɨ woko. Ambaza mudingi ka ɓambanzʉ ɓa gʉɗʉ ɓa ndɨ pa imoti no woko yi nɨnɔ. ");
INSERT INTO lik_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Nɨyɔ Mombukwono-dosu amɨna muko yi nɨnɔ, akwilya kumbu, aɓɨkya ɓɛ: «Wasa mʉgamʉ.» ");
INSERT INTO lik_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Kumbuso yi, isisila ndɨ, avɨla sanda, ɓatʉ ɓi nɨɓɔ ɓa ndɨ na iyu yɨbɨnɨka ɓamaga. Kʉwa wa Yeso aka ɓɛ: «Mikya-ɓawanzaaa, nakaʉɓɨkya ambɛ, wamaga!» ");
INSERT INTO lik_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Wa aka wa, mikya ɓalʉkʉ yi nɨnɔ a ndɨ manda nɔ iko, apʉnga ndɨ kanzɨna. Kumbuso yi, Yeso apá ndɨ amakɨ. ");
INSERT INTO lik_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Lɨkpʉmʉka lɔ uɓongisa ndɨ ɓambanzʉ ɓasɨ, ɓapʉnga ndɨ kabibisa Kunzi ɓanaɓɨkya ɓɛ: «Mugyalandʉ ɓemoti mudingi opupiniku luga kusu!» na gɔnɨ: «Kunzi osingyiniku lɨvananza kakɨ!» ");
INSERT INTO lik_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Na mongoni ma lɨkpʉmʉka nɨlɔ Yeso agya ndɨ lɔ, ɨtʉlyana kʉwa ndɨ ka iwili yasɨ ya Yudɛa no giyo yasɨ nɨyɔ ɓuwobi-ɓuwobi wa. ");
INSERT INTO lik_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ɓaɓɨɓya ka Yuani-Mubatizaɨ ɓapága ndɨ Yuani mongoni masɨ. Kʉwa wa, Yuani ʉmaka ndɨ ɓaɓa luga kaɓʉ, ");
INSERT INTO lik_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ʉtɨka ndɨ kʉ ka Mombukwono-dosu kamuusa ɓɛ: «Ɨwɛ nɨ mʉtʉ yi nɨnɔ a ndɨ kodoku, ikanɨgʉ takwanana kaɓʉnda wagɔgɔ?» ");
INSERT INTO lik_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Nɨyɔ ɓatu ɓi nɨɓɔ ɓadwɛ kʉ Yeso a ndɨ mino, ɓaɓɨkya ɓɛ: «Yuani-Mubatizaɨ atitikiku kaumuusa ɓɛ: ‹Ɨwɛ nɨ mʉtʉ yi nɨnɔ a ndɨ kodoku ikanɨgʉ takwanana kaɓʉnda wagɔgɔ?›» ");
INSERT INTO lik_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ko ngbingo yi nɨnɔ aka nɔ, Yeso uhukusa ndɨ ɓatʉ ɓudingi ɓa ɓokoloɓu dididi, nɨɓɔ ɓakɨgyagya, nɨɓɔ ɓa mambɛngɨ ma ɓʉnyɛ, uhukusa ndɨ gɔnɨ ɓatʉ ɓudingi nɨɓɔ ɓa ndɨ no koloɓu ya mamɔmɔ. ");
INSERT INTO lik_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Kumbuso yi, Yeso usikisya ɓatʉ ɓi nɨɓɔ ɓɛ: «Windoni katʉmbʉlyaga Yuani nɨlɔ mini na nɨlɔ mukoni: ɓatʉ ɓa ɓokoloɓu ɓaya mamɔmɔ ɓakaɨna ɓata, nɨɓɔ ɓa mʉtɨngbɨ ɓakakpakyana ngbingbili, ɓakeɓu-keɓu ɓoukini, ɓaadʉka ɓakaʉkana, ɓamanda akozuzuko na ɓatʉ ɓa payaya ɓakaʉkana Mongoni Manza. ");
INSERT INTO lik_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ɨgyagya ka mʉtʉ nɨnɔ kupigʉ ndɛkɛ kɛɓɨɓya ka baya!» ");
INSERT INTO lik_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Nɨyɔ ɓatʉ ɓi nɨɓɔ Yuani utikoku ɓaga ndɨ, Yeso apʉnga ndɨ kanzɨnɨlya ambaza ka ɓambanzʉ ko bulya ka Yuani, anaɓɨkya ɓɛ: «Mɨnda ndɨ kaɨna ɨkɨ kʉ ka ɨsa? Lɨgʉgʉ nɨlɔ a ndɨ kodimbo na muvivi? Kalɨ! ");
INSERT INTO lik_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ambɛ, mɨnda ndɨ kaɨna ɨkɨ? Mʉmbanzʉ ɓemoti wakimokisyaga yanzanza? Luki limoti, niɓɔ ɓimokisyaga ɓotu ɓaya lɨgabʉ lapʉ, ɓika na ɔɓɨlɨ wanza, ɓikaga ka ɓandaɓʉ ka ɓangama. ");
INSERT INTO lik_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Mɨnda sɛ kʉwa ndɨ kaɨna ɨkɨ? Mugyalandʉ ɓemoti? Iyo, nakamʉɓɨkya ambɛ akitogito mugyalandʉ. ");
INSERT INTO lik_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Kyɛ ikpika ko bulya kakɨ ɓɛ: ‹Nakatɨka atʉtʉmbwa kamɨ kambwa kakʉ, kyɛ uɓungusyili pisi.›» ");
INSERT INTO lik_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Nakamʉɓɨkya ambɛ: «Kɛgʉ na mʉmbanzʉ nɨnɔ ɨɓʉkʉta na muko, nɨnɔ a mudingi kakɨtaga Yuani. Luki limoti nɨnɔ a mʉkɛɗɛ kʉgbɛ ka Ɓʉngama ko Kunzi a mudingi kakɨtaga ɨyɨ. ");
INSERT INTO lik_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Nɨyɔ ɓambanzʉ ɓasɨ na gʉtʉgʉ ɓandɔmbɛ ɓa manzanza aka ɓamʉkana ndɨ, ɓiba ɓɛ Kunzi a ngbingbili, Yuani uɓotisa ndɨ. ");
INSERT INTO lik_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Luki limoti Ɓafalisayɔ na ɓowonisilo ɓa mʉtʉʉ ɓakaɓɨnɨkyanagʉ ndɨ lɨkpʉmʉka li nɨlɔ Kunzi a ndɨ kapa kʉgʉ kaɓʉ, ɓamʉya ndɨ ɓɛ Yuani uɓotisi.» ");
INSERT INTO lik_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yeso aɓɨkya ɓata ɓɛ: «Nakwanana pɨyɛ kaukingyoso ɓatʉ ɓa lɨsyɛ li nɨlɨ na ɓɛkɨ? Ɓa mʉɗɔngɔnɨ abɛ ɓa wanɨ? ");
INSERT INTO lik_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ɓa mʉɗɔngɔnɨ abɛ ɓomiki ɓi nɨɓɔ ɓa ɓakikaga ka pa yangba, ɓanʉtʉɓɨlaga ɓɛngɛnɨ ɓɛ: ‹Tamungbotilyi ɓi ɓyɛmbɨ nɨ makoɓinigʉ! Tamumbimbilyi ɓi mambʉ ma idumasʉ nɨ makogomigʉ ɓɛgɛyɔ!› ");
INSERT INTO lik_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","A ɓɛyɔ, nɨyɔ Yuani-Mubatizaɨ odoku ndɨ, kalyagɨgʉ ndɨ mukati, kamwogigʉ ndɨ gɔnɨ vinya, iɓunu aka ɓɛ: ‹A na lɨmbɛngɨ la ɓʉnyɛ.› ");
INSERT INTO lik_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mika-mʉmbanzʉ odoku kʉwa ndɨ, analyalya, anomwo, iɓunu aka ɓɛ: ‹Mundoni alʉkʉ wa mʉsasa yi nɨmʉna, akalyalya na kamwo vinya pa imoti na ɓandɔmbɛ ɓa manzanza na ɓatʉ ɓa ɓʉnyɛ!› ");
INSERT INTO lik_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Luki limoti, yimibo ko Kunzi inisononi ka ɓatʉ ɓasɨ nɨɓɔ ɓabaɨlya.» ");
INSERT INTO lik_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Mufalisayɔ ɓemoti amaka ndɨ Yeso kalyalya ɨɓʉ na ɨyɨ kʉ kakɨ. Yeso ɨnda ndɨ kʉ ka alʉkʉ yi nɨnɔ, iko, ɓapʉnga kalyalya. ");
INSERT INTO lik_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Muka ɓemoti wa yɨgya yanyɛ, ikaga ndɨ ka gʉɗʉ yi nɨnɔ. Nɨyɔ ʉkana ɓɛ Yeso akalyalya kʉ ka Mufalisayɔ nɔ, odoku ndɨ na mʉkɛʉ mimoti nɨmɔ ɓagya ndɨ na lɨtalʉ la alibati, otumini na malazi ɓɨɗɛ. ");
INSERT INTO lik_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Amaga ndɨ kumbusa ka Yeso ka kpɔlɔ wa magʉ kakɨ. A ndɨ kagama, anuɗukusogo ɓomomiso-miso ka magʉ ka Yeso. Kumbuso yi akpaga kʉwa ndɨ no tukatʉ kakɨ, anopututo magʉ, akpazya ndɨ na malazi. ");
INSERT INTO lik_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Nɨyɔ Mufalisayɔ yi ninɔ amaka ndɨ Yeso ɨna ɓɛyɔ, aɓɨkya ndɨ kʉsɔ kakɨ ɓɛ: «Kiko ɓi ɓɛ alʉkʉ yi nɨmʉ a mugyalandʉ walɨngʉnʉ, akwanano ɓi kaiba ɓɛ muko yi nɨnɔ akavɨvɨla nɔ a na yɨgya yanyɛ.» ");
INSERT INTO lik_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Kʉwa wa, Yeso aɓɨkya Mufalisayɔ nɔ ɓɛ: «Simoni, na na lɨkpʉmʉka kaʉɓɨkya.» Simoni asikisya ɓɛ: «Muwonisilo, ɓɨkyanɔ.» ");
INSERT INTO lik_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yeso aɓikyoku ɓɛ: «Ɓalʉkʉ ɓaɓa ɓa ndɨ no luɓu ka mʉtʉ ɓemoti. Ɓemoti a ndɨ no luɓu wa ɓambuma ɓamɨya kuɓukumuti na wagɔgɔ ɓatɛkɛɓɛ kuɓukumuti. ");
INSERT INTO lik_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Yɛkɨ ɨɓʉ ɓasɨ ɓaɓa ɓakɛgʉ ndɨ no ɓuyi kakalya luɓu yi nɨnɔ, ʉpɨlya ndɨ ɨɓʉ ɓasɨ ɓaɓa. Luga ka ɓatʉ ɓaɓa ɓi nɨɓɔ, wanɨ nɔ ika na sɨpananɨsɔ kʉgbɛ na alʉkʉ yi nɨnɔ?» ");
INSERT INTO lik_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simoni asikisya ɓɛ: «Nakaɨna abɛ nɨnɔ apɨlya ndɨ nɨ a na ɓuyi ɓudingi kʉgbɛ.» Yeso aɓɨkya ɓɛ: «Ɛɛɛ, wosikisyiku ngbingbili.» ");
INSERT INTO lik_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Kumbuso, oyikana ndɨ kʉ ka muko yi nɨnɔ, aɓɨkya Simoni ɓɛ: «Watʉ kamɨna muko yi nɨmʉ? Wa nogulyiku mino kʉ kakʉ wanʉ, wakepigʉ liɓo la magʉ, luki limoti muko yi nɨmʉna esukusi magʉ no ɓomomiso-miso, ɛkpaga no tukatʉ kakɨ. ");
INSERT INTO lik_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Waketitilyigʉ ɓi kepututo, luki limoti muko yi nɨmʉ kupigʉ kepututo magʉ katʉkya wa aka wa nogulyiku mino wanʉ. ");
INSERT INTO lik_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Weketikiligʉ molingo ka mʉ, luki limoti ɨyɨ etikilito magʉ na malazi. ");
INSERT INTO lik_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kinili nakaʉɓɨkya ɓɨngbanganya ambɛ: sɨpananɨsɔ sidingi nɨsɔ owonisili, akaibisiso ɓɛ ɓapilyini ɓʉnyɛ ɓudingi nɨɓɔ kakɨ. Luki limoti, nɨnɔ Kunzi apɨlyaga ɓʉnyɛ ɓakɛɗɛ, owonisilaga sɨpananɨsɔ sɨkɛɗɛ gɔnɨ.» ");
INSERT INTO lik_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Kumbuso yi, Yeso aɓɨkya kʉwa muko yi nɔ ɓɛ: «Ɓupilyini ɓʉnyɛ kakʉ.» ");
INSERT INTO lik_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ɓatʉ nɨɓɔ ɓa ndɨ kalyalya pa imoti na Yeso, ɓapʉnga ndɨ kaɨnzɨnzɨnya luga kaɓʉ ɓɛ: «Alʉkʉ yi nɨmʉna a mbɛyɨ wanɨ, kaɨkpʉnda kapɨlya ɓʉnyɛ?» ");
INSERT INTO lik_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Luki limoti Yeso aɓɨkya kʉwa ndɨ muko yi nɨnɔ ɓɛ: «Baya kakʉ uhukusini, waga na mazɨyɔ.» ");
INSERT INTO lik_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Kumbuso yi, Yeso ɨnda ndɨ kaɓɨkyaga Mongoni Manza ma Ɓʉngama ko Kunzi ka ɓagʉɗʉ no giyo dididi. Ɓaɓɨɓya tɛkɛɓɛ na ɓaɓa ɓa ndɨ pa imoti na ɨɓʉ. ");
INSERT INTO lik_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ɓoko ɓemoti-ɓemoti nɨɓɔ Yeso ʉnyɔ ndɨ mambɛngɨ ma ɓʉnyɛ, uhukuso ɓokoloɓu, ɓa ndɨ pa imoti na ɨɓʉ gɔnɨ: a ndɨ nɨ Malia Magadala, nɨnɔ Yeso anyɔ ndɨ mambɛngɨ ma ɓʉnyɛ maɗɨya na ɨka, ");
INSERT INTO lik_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Yuana, muka Suza nɨnɔ a ndɨ zamʉ ka Ɛlɔdɨ Atipasɨ, na ɓagɔgɔ ɓudingi. Ɨɓʉ ɓasɨ ɓapága ndɨ ɓuyi kaɓʉ kabɨnɨka ɓuti ka Yeso na ɓaɓɨɓya kakɨ. ");
INSERT INTO lik_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ɓambanzʉ ɓasingyoku ndɨ Yeso kotukyoku ka ɓagʉɗʉ dididi. Nɨyɔ ambaza mudingi a ndɨ kamʉmʉkana ɓɛyɔ, ʉtʉlya kʉwa lizuni li nɨlɨ: ");
INSERT INTO lik_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Mʉtʉ ɓemoti ɨnda ndɨ kakʉna masɔlɔ kakɨ. Nɨyɔ a ndɨ kakʉna ɓɛyɔ, bumo yi yagɔgɔ anyʉkaga ko pisi. Ɓambanzʉ ɓaɗɨtaga ndɨ, ɓombu ɓalya. ");
INSERT INTO lik_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Nɨyɔ yagɔgɔ anyʉka ndɨ ka lɨtalʉ. Nɨyɔ aɓaka, ʉmɨlaga kyɛ lɨtɔmbʉ kɛgʉ ndɨ no liɓo. ");
INSERT INTO lik_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Yagɔgɔ anyʉka ndɨ ko kpokiki. Nɨyɔ apʉnga kaɓaka, kpokiki aɓaka ndɨ gɔnɨ iyu, akandaga ɓɨkpɛkɨ-kpɛkɨ. ");
INSERT INTO lik_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Luki limoti nɨyɔ yagɔgɔ anyʉka ndɨ ka lɨtɔmbʉ la dɔɓɔ. Aɓaka ndɨ, aɓʉkʉta ɓɛkaza ɓɨyʉyʉyʉ. Ɨkaza imoti-imoti aɓʉkʉtaga ndɨ bumo yakpʉ kʉgbɛ.» Nɨyɔ Yeso ama kaʉtʉmbʉlyaga lɨkpʉmʉka li nɨlɔ ɓɛyɔ, apamɨkana ɓɛ: «Mʉtʉ yi nɨnɔ a na motili ma kʉkana, ʉkanɨtɔ!» ");
INSERT INTO lik_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Kʉwa wa ɓaɓɨɓya kakɨ ɓamuusa ndɨ Yeso isi ya lizuni li nɨlɔ. ");
INSERT INTO lik_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Usikisya ndɨ ɓɛ: «Kunzi amumibisatʉ iɓunu ɓodikiɗi ɓaya Ɓʉngama kakɨ. Luki limoti, ɓatʉ ɓagɔgɔ ɓʉkanaga ɨɓʉ pisi ka mozuni mʉɗɔngɔnɨ ɓɛyɔ ikpikaga ndɨ mino ka moɓiso ɓɛ: ‹Ɓika kaanda nɨ ɓakɛgʉ kaɨna, ɓanʉkana nɨ ɓakɛgʉ kotombisyo.›» ");
INSERT INTO lik_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","«Mʉtʉmbʉlagɨ ma lizuni nɨma: masɔlɔ a likingyosi la lɨkpʉmʉka ko Kunzi. ");
INSERT INTO lik_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ɓatʉ ɓagɔgɔ ɓa abɛ pisi kʉ masɔlɔ magɔgɔ anyʉkaga ndɨ mino. Ɓʉkanagatʉ, luki limoti mumuyoniso odoku, anyɔ lɨkpʉmʉka ka mambɛngɨ kaɓʉ. Ʉkpɨngba kabaɨlya lɨkpʉmʉka li nɨlɔ na kainisono na muhukuso. ");
INSERT INTO lik_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Masɔlɔ nɨmɔ ogwa ndɨ ka lɨtalʉ, a nɨɓɔ ɓʉkanaga lɨkpʉmʉka, ɓogwi na ɨgyagya. Luki limoti ɓa abɛ sɨbʉkʉsɔ nɨsɔ kɛgʉ no lyo, ɓaɓɨnɨkyanaga ko ngbinga mʉkɛɗɛ aka. Ko ngbinga wa ɓʉkpɛkɨ-kpɛkɨ, ɓatʉkya ka baya. ");
INSERT INTO lik_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Nɨmɔ ogwa ndɨ ko kpokiki, a likingyosi ka ɓatʉ nɨɓɔ ɓʉkanaga Lɨkpʉmʉka ko Kunzi, luki limoti ngbingo yi nɨnɔ ɓo mino kaidukulogo ka baya, mʉtamanagɨ mudingi, mʉsasa ma mukumbo na ma lɨtɔmbʉ ʉkanda ɓɨkpɛkɨ-kpɛkɨ. Ka muliɓo mi nɨ ɓakopígʉ masɔlɔ mʉngata. ");
INSERT INTO lik_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Nɨmɔ ogwa ndɨ ka lɨtɔmbʉ la dɔɓɔ a likingyosi ka ɓatʉ ɓi nɨɓɔ ɓʉkanaga Lɨkpʉmʉka ko Kunzi na lɨmbɛngɨ lanza, ɓanagya yi. Ɓoɓuulyogo, aɓʉkʉta masɔlɔ, ɓakoyikonogigʉ ka baya gʉtʉgʉ ko ngbingo wa ɓʉkpɛkɨ-kpɛkɨ aka.» ");
INSERT INTO lik_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yeso ʉɓɨkya ɓata ndɨ ɓɛ: «Kɛgʉ na mʉmbanzʉ gʉtʉgʉ ɓemoti aka nɨnɔ atʉnaga tala agbukumisya ɓata na mʉmbɨ ikanɨ abiso kusyokoto. Luki limoti, abisaga kʉgʉ, ka pa nɨyɔ ɓabisogo mino iba ɓatʉ nɨɓɔ ɓika kogulya ɓɨnɨ ɓʉngbanganya. ");
INSERT INTO lik_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Kʉwa wa gɔ wa, kɛgʉ na lɨkpʉmʉka gʉtʉgʉ limoti aka nɨlɔ la kɨsʉma nɨ kimibisikosigʉ, ipupisa ka pa yangba. ");
INSERT INTO lik_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ɛɛɛ, wiminyonito ɓɛyɔ mo mino kaʉkana yɔ! A ɓɛyɔ, mʉtʉ yi nɨnɔ a no luki, ɓamatɨlyatʉ ɓata. Luki limoti, mʉtʉ yi nɨnɔ kɛgʉ no luki ɓakʉpya gʉtʉgʉ nɨlɔ akasɨma ɓɛ a nolu.» ");
INSERT INTO lik_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Amakɨ na ɓamamakɨ Yeso ɓodoku ndɨ kanda, luki limoti ɓakakwananagʉ ndɨ kasilyo ko bulya ambaza ka ɓambanzʉ. ");
INSERT INTO lik_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ɓaɓikyoku kʉwa ɓɛ: «Amakʉ na ɓamamakʉ ɓakaʉkɨsa kunzi kʉ, ɓakapa kaʉmɨna.» ");
INSERT INTO lik_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Luki limoti Yeso usikisya ndɨ ɨɓʉ ɓasɨ ɓɛ: «Mama na ɓomika-mama nɨ ɓatʉ ɓi nɨɓɔ ɓʉkanaga lɨkpʉmʉka ko Kunzi, ɓanagya yi.» ");
INSERT INTO lik_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Lɨsyɛ limoti Yeso aɗaka ndɨ ka ɨngbɔlɔ pa imoti na ɓaɓɨɓya kakɨ, ʉɓɨkya ɓɛ: «Tozobini kʉsyakʉ wa ibombu.» Kʉwa wa, ɓaga ndɨ. ");
INSERT INTO lik_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ngbingo yi nɨnɔ ɓa ndɨ mino kazaba nɔ, Yeso alala ndɨ ɓɨpɛ. Mbumbo yapʉ apʉnga ndɨ kovivo ko ngbinga ɓemoti aka, ɨngbɔlɔ apʉnga komwaga liɓo. Ɓa kʉwa ndɨ ka mʉkpanga ma kukwakʉ. ");
INSERT INTO lik_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ɓaɓɨɓya ɓɨnda ndɨ kagbugbutiso, ɨɓʉ aka ɓɛ: «Muwonisilo, Muwonisilo, tanolumwogo!» Nɨyɔ Yeso ogbugbutoku, apamɨlya mbumbo na mʉɓaka, mbumbo asa ndɨ kovivo, pa aka ndɨ ɓiwo. ");
INSERT INTO lik_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Kumbuso yi, ʉɓɨkya ɓaɓɨɓya ɓɛ: «Baya kunu a yanɨ?» Luki limoti ɓaɓanga ndɨ, ɓombomboyo, ɓanuusana ɓɛ: «Inguo ya mumbanzʉ tino pɨyɛ mʉ? Akapá mʉtʉʉ gʉtʉgʉ ko mbumbo no liɓo, masɨ anamʉkana!» ");
INSERT INTO lik_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yeso na ɓaɓɨɓya kakɨ ɓazaba ndɨ kʉsyakʉ, ka iwili ya Ɓagɛlasɨ, tili na iwili ya Galilaya. ");
INSERT INTO lik_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ngbingo yi nɨnɔ Yeso a ndɨ mino kosya ka ɨngbɔlɔ, mʉlʉkʉ ɓemoti wa gʉɗʉ yi nɨnɔ, odoku ndɨ kambwa kakɨ. Mʉtʉ yi nɨnɔ a ndɨ na mambɛngɨ ma ɓʉnyɛ. Mututu kɛgʉ ɓuwobi, ikaga kʉwa ndɨ ɨyɨ asɨ ndumbu aka. Kasyɛgɨgʉ ɓata ndɨ ka ndaɓʉ ɓɛgɛyɔ. Luki limoti, ikaga kʉwa ndɨ ɨyɨ ka ɓambʉkʉ aka. ");
INSERT INTO lik_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Nɨyɔ amɨna Yeso ɓɛyɔ, apamɨkana, ogwa kambwa kakɨ, apamɨkana ɓɛ: «Yeso, Miko-Kunzi nɨnɔ Kʉgʉ-Kʉgbɛ, nɨlɔ kusu na ɨwɛ opukogi ɓʉnɨ? Kikiliki, wakegyogyisonito ɓaka!» ");
INSERT INTO lik_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","A ndɨ kanzɨna ɓɛyɔ kyɛ Yeso a ndɨ nɨ opíni mʉtʉʉ ka lɨmbɛngɨ la ɓʉnyɛ ɓɛ opupi kʉsɔ kakɨ. Lɨmbɛngɨ li nɨlɔ a ndɨ nɨ andungulyogini nganga ɓɨkyɔ. Gʉtʉgʉ ɓakakanda ndɨ maɓɔkʉ na magʉ na ɓaselegeni ɓɛ kyɛ kokyogonito, ɨtɨnaga ndɨ asɨ ɓitututu. Lɨmbɛngɨ nɨlɔ la ɓʉnyɛ lɔ akpamyaga ndɨ kaɨnda kʉ ka ɨsa. ");
INSERT INTO lik_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yeso amuusa ɓɛ: «Wina ɓʉ?» Asikisya ɓɛ: «Nina bɛ ‹Ndube›» Aɓɨkya ndɨ ɓɛyɔ kyɛ mambɛngɨ ma ɓʉnyɛ a ndɨ nɨ amingyini mudingi. ");
INSERT INTO lik_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Mambɛngɨ ma ɓʉnyɛ mi nɨmɔ ɨtatanaga ndɨ na Yeso ɓɛ kukpomyonitɔgʉ ɓaka kogwa ka lɨɓyɛ lo ɓuku. ");
INSERT INTO lik_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Wɨna sɛ ambaza mudingi ka ɓangʉya a ndɨ kalyalya ka ngʉpa wa. Mambɛngɨ ma ɓʉnyɛ ɨtatanaga ndɨ na Yeso ɓɛ ʉsɨlyɨ pisi kogulya ka ɓangʉya ɓi nɨɓɔ. Abaɨlya. ");
INSERT INTO lik_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Kʉwa wa mambɛngɨ ma ɓʉnyɛ opupa ndɨ kʉsɔ ka alʉkʉ nɔ, ogulya ndɨ kʉsɔ wa ɓangʉya. Ambaza ka ɓangʉya wasɨ osya ndɨ ko dido wa ngʉpa kadwɛ ka ibombu, ɓolinda ndɨ. ");
INSERT INTO lik_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ngbingo yi nɨnɔ ɓoɓuɓulyo ɓa ɓangʉya ɓɨna ndɨ mino lɨkpʉmʉka nɨlɔ, ɓɨga ndɨ mbangʉ kapága mongoni mi nɨmɔ ka gʉɗʉ na ka ɓogiyo. ");
INSERT INTO lik_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ɓambanzʉ ɓodoku ndɨ kaɨna lɨkpʉmʉka nɨlɔ igyonosa ndɨ lɔ. Nɨyɔ ɓosilo ɓuwobi na Yeso, ɓatakanya kʉwa ndɨ mʉtʉ yi nɨnɔ mambɛngɨ ma ɓʉnyɛ apupa ndɨ nɔ mukuliko ɓuwobi na Yeso, kanɨ imokisyini kutuko, mʉpɨla ɓɨnza ɓipisiii. Ɓaɓanga ndɨ kʉgbɛ. ");
INSERT INTO lik_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Nɨɓɔ ɓɨna ndɨ nɨlɔ igyonosa ndɨ lɔ, ɓutumbulyogoku ɓatʉ ɓagɔgɔ ɓɛyɔ alʉkʉ nɔ ahʉka ndɨ mino. ");
INSERT INTO lik_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Kʉwa wa ɓatʉ ɓasɨ ɓa iwili ya Gɛlasɨ ɓaɓɨkya ndɨ Yeso ɓɛ opupi kʉ kaɓʉ, kyɛ ɓa ndɨ kaɓanga kʉgbɛ. Yeso aɗaka ndɨ ka ɨngbɔlɔ, atʉkyɨlya lɨgʉndʉ. ");
INSERT INTO lik_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mʉtʉ yi nɨnɔ Yeso anyɔ ndɨ mambɛngɨ ma ɓʉnyɛ nɔ ɨtatanaga ndɨ na Yeso ɓɛ ɓaganɔ ɓaka pa imoti na ɨyɨ. Luki limoti, kanɨ Yeso kopagʉ. Aɓɨkya ɓɛ: ");
INSERT INTO lik_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«Wɨga kʉ kakʉ, wotumbulogoku lɨkpʉmʉka lasɨ nɨlɔ Kunzi ugyilyi.» Aga ndɨ, oɓikyogoku ka gʉɗʉ wasɨ nɨlɔ Yeso agyɨlya ndɨ. ");
INSERT INTO lik_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Nɨyɔ Yeso ɨga ɓata kʉsyakʉ wa ibombu, ambaza mudingi ka ɓambanzʉ atɨlya ndɨ, kyɛ ɨɓʉ ɓasɨ ɓa ndɨ kaɓʉnda. ");
INSERT INTO lik_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ko ngbingo yi nɨnɔ aka nɔ, ngama ɓemoti wa ndaɓʉ ya malʉmba ka Ɓayuda nɨnɔ ina ndɨ ɓɛ Yailo odoku ndɨ, ogwa kambwa ka Yeso, ɨtatanaga na ɨyɨ ɓɛ adwɨnɔ ɓaka kʉ kakɨ, ");
INSERT INTO lik_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","kyɛ mikakɨ ɓemoti aka muko yi, wa ɓyanga banda tɛkɛɓɛ na ɓɨɓa, a ɓuwobi kosisa lɨmbɛngɨ. Ngbingo yi nɨnɔ Yeso a kʉwa ndɨ mino kaaga kʉ, ambaza amotosya ndɨ ɓɨkpwɔ. ");
INSERT INTO lik_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Kʉsɔ wa ambaza wa, a ndɨ na muko ɓemoti nɨnɔ ɓangʉ apupaga ndɨ kʉsɔ wa ɓyanga tɛkɛɓɛ na ɓɨɓa. A ndɨ nɨ omoni mukumbo kakɨ masɨ kaʉkalyaga ɓamʉnganga, luki limoti kɛgʉ ndɨ na mʉtʉ nɨnɔ akwanana ndɨ kahukuso. ");
INSERT INTO lik_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Muko yi nɨnɔ akpuɗoku ndɨ Yeso ya kumbuso, avɨla mʉ ma kutuko kakɨ. Wa aka wa, ɓangʉ asa ndɨ kapupo. ");
INSERT INTO lik_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yeso aka ɓɛ: «Wanɨ pɨyɛ nɔ evili?» Ɓatʉ ɓasɨ ɓanganya ndɨ, Pɛtɛlɛ aka ɓɛ: «Muwonisilo, wakɛgʉ mbɛyɨ kaɨna ɓɛyɔ ɓambanzʉ ɓukunguli mino yɨ, ɓumotosya ɓɛnɛ?» ");
INSERT INTO lik_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Luki limoti, Yeso aɓɨkya ɓɛ: «Iyo, mʉmbanzʉ ɓemoti evilito, kyɛ nimukonito ngu kepupo.» ");
INSERT INTO lik_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nɨyɔ muko yi nɨnɔ ɨna ɓɛ ɓandungini, odoku gʉgʉma na kʉɓangakʉ, ogwa kambwa ka Yeso. Kambwa ka ɓambanzʉ ɓasɨ wa, atʉmbʉlaga ndɨ ko bulya tino yɔ avɨla ndɨ mino Yeso na ɓɛyɔ ahʉka ndɨ mino ko ngbinga ɓemoti. ");
INSERT INTO lik_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yeso aɓɨkya ndɨ ɓɛ: «Mikya ɓoko mʉna, baya kakʉ uhukusini. Waga na mazɨyɔ.» ");
INSERT INTO lik_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ngbingo yi nɨnɔ Yeso a ndɨ mino kanzɨna nɔ, mʉtʉ ɓemoti otukyoku ndɨ ka Yailo, ngama wa ndaɓʉ ya malʉmba ka Ɓayuda, aɓɨkya ɓɛ: «Mikakʉ osisini lɨmbɛngɨ. Wasa ɓata kadomiso Muwonisilo.» ");
INSERT INTO lik_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Nɨyɔ Yeso ʉkana ndɨ mongoni mi nɨmɔ ɓɛyɔ, aɓɨkya Yailo ɓɛ: «Wakoɓongonitɔgʉ! Wika na baya aka, mikakʉ ahʉkatʉ.» ");
INSERT INTO lik_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ngbingo yi nɨnɔ Yeso adwɛ mino ka ndaɓʉ ka Yailo, kapagʉ ndɨ mʉtʉ wagɔgɔ kogulya pa imoti na ɨyɨ ka ndaɓʉ, kiki asɨ nɨ Pɛtɛlɛ aka, Yuani, Yakɔbɔ, abakɨ na amakɨ miki. ");
INSERT INTO lik_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ɓatʉ ɓasɨ ɓa ndɨ kagama na kaɨgama ko bulya ko miki yi nɨnɔ okwa ndɨ nɔ. Luki limoti Yeso aɓɨkya ɓɛ: «Wosoni kagama, miki kɛgʉ mukwo, luki limoti a ka tɔtɔ.» ");
INSERT INTO lik_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ɓatʉ ɓi nɨɓɔ ɓatɨba ndɨ ɓɨkyaaa, kyɛ ɓa ndɨ kaiba ɓɛ miki a manda. ");
INSERT INTO lik_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Luki limoti Yeso agwi kʉɓɔkʉkɔ, aɓɨkya na lɨyʉ lapʉ ɓɛ: «Miki aaa, wamaga!» ");
INSERT INTO lik_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ozuzukoku, amaga ndɨ ko ngbingo yi nɨnɔ aka nɔ. Yeso aka ndɨ ɓɛ ɓapɨ́ malɨlɨ. ");
INSERT INTO lik_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Abakɨ na amakɨ ɓombombaya ndɨ kʉgbɛ kaɨna lɨkpʉmʉka nɨlɔ lɨmbanga lɔ, luki limoti Yeso ʉpá ndɨ mʉtɨwɨ ɓɛ ɓakatumbulyogonitɔgʉ mʉmbanzʉ gʉtʉgʉ ɓemoti aka. ");
INSERT INTO lik_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Kʉwa wa, Yeso ʉmʉmʉla ɓatʉtʉmbwa tɛkɛɓɛ na ɓaɓa ʉpá ngu na ɓʉngama kokpumyo mambɛngɨ ma ɓʉnyɛ masɨ na kohukuso ɓokoloɓu. ");
INSERT INTO lik_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Kumbuso yi, ʉtɨka ndɨ kaɓɨkyaga mongoni ma Ɓʉngama ko Kunzi na kauhukuso ɓatʉ ɓa ɓokoloɓu. ");
INSERT INTO lik_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ɨyɨ aka na ɨɓʉ ɓɛ: «Makovonitɔgʉ gʉtʉgʉ luki limoti aka abɛ mʉdʉkpɔ, kʉgba, mukati gʉtʉgʉ ɓuyi aka, na makuvonitɔgʉ ɓasimizi ɓaɓa-ɓaɓa. ");
INSERT INTO lik_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Pa yasɨ kʉ ɓamʉtɨlya ɓanʉ mino, wikoni iɓunu asɨ ka ndaɓʉ yi nɨyɔ aka yɔ, kadwɛ ko ngbingo yi nɨnɔ mopupa ɓanʉ mino ka mugi mi nɨmɔ. ");
INSERT INTO lik_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Pa yasɨ kʉ ɓambanzʉ ɓakamʉtɨlyɨ ɓanʉ mino, puponi ka mugi kaɓʉ, mɨbʉmaga liɓungu la ɓakagba kunu, kaumibisa ɓʉnyɛ kaɓʉ.» ");
INSERT INTO lik_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Kʉwa wa ɓatʉtʉmbwa ɓaga ndɨ, ɓolingya giyo yasɨ. Ɓanaɓɨkyaga Mongoni Manza ka ɓapa ɓayasɨ, ɓanuhukuso ɓatʉ ɓa ɓokoloɓu. ");
INSERT INTO lik_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Wa Ɛlɔdɨ nɨnɔ a ndɨ ngama wa Galilaya ʉkana mino lɨkpʉmʉka lasɨ nɨlɔ a ndɨ kaigyonosa lɔ, amama ɓɨgbagba nɨ kɛgʉ ɓata kaiba ɓɛ agya ɓʉnɨ. Ɓatʉ ɓemoti-ɓemoti ɓa ndɨ kaɓɨkya ɓɛ: «Yuani-Mubatizaɨ opupiniku ka ɓabɨlɨ!» ");
INSERT INTO lik_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ɓagɔgɔ ɓaɓɨkya ndɨ ɓɛ: «Mugyalandʉ Ɨlɨya ipupisiniku ɓata!» Ɓagɔgɔ ɓaɓɨkya ɓata ndɨ ɓɛ: «Mugyalandʉ wandɛlɨ ɓemoti opupiniku ka ɓabɨlɨ!» ");
INSERT INTO lik_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Luki limoti, Ɛlɔdɨ aɓɨkya ɓɛ: «Ɨmɨ nakusisoni ndɨ Yuani mʉ. Wanɨ sɛ kʉwa ɓata mʉna nakaʉkana makpʉmʉka mʉmbanga-mbanga kʉgʉ kakɨ mʉ?» A ndɨ kakɨsa kamɨna Yeso. ");
INSERT INTO lik_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Nɨyɔ ɓatʉtʉmbwa ɓigononoku, ɓatʉmbʉlyaga ndɨ Yeso masɨ nɨmɔ ɓa ndɨ nɨ ɓogyini. Ɨnda ndɨ na ɨɓʉ ka pa nɨyɔ mʉmbanzʉ kɛgʉ ndɨ mino, ɓuwobi na gʉɗʉ ɓemoti nɨnɔ ina ɓɛ Bɛtɛsaida. ");
INSERT INTO lik_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Luki limoti, nɨyɔ ɓambaza ka ɓambanzʉ ɓʉkana ɓɛyɔ, ɓaga ndɨ kaʉkɨsa. Nɨyɔ ɓadwɛ, Yeso ʉtɨlya, ʉnzɨnɨlya kʉgʉ wa Ɓʉngama ko Kunzi, uhukusa ndɨ nɨɓɔ ɓa ndɨ kaigyogyiso na ɓokoloɓu. ");
INSERT INTO lik_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ngbingo yi nɨnɔ mɔnɨ apʉnga mino kogwo, ɓatʉtʉmbwa ɓakpuɗoku ndɨ Yeso, ɓaɓɨkya ɓɛ: «Hʉɓɨkya nɛkɨ ambaza ka ɓambanzʉ ɓɛ ɓaga kakɨsa pa ya ɓusisini no luki lɨlya ka sɛngɨ na ka ɓandaɓʉ nɨɓaɨna ɓuwobi-ɓuwobi wanʉ, kyɛ ta wanʉ ka ɨsa.» ");
INSERT INTO lik_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Luki limoti ʉɓɨkya ɓɛ: «Hupóno malɨlɨ asɨ nɨ iɓunu aka ɓamombukwana-daɓʉ ɓi.» Ɓasikisya ɓɛ: «Ta iɓusu asɨ na mukati kuɓukumuti aka na ɓosi ɓaɓa. Wakapa ɓɛ tɨndɨ koluwo malɨlɨ ko bulya ka ɓatʉ ɓi nɨɓana ɓasɨ?» ");
INSERT INTO lik_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","A ɓɛyɔ, ɓambanzʉ ɓa ndɨ wa banda ɓɛlɔfʉ kuɓukumuti. Yeso ʉɓɨkya ɓaɓɨɓya kakɨ ɓɛ: «Hulikisoni nɛkɨ ka magbʉta. Lɨgbʉta limoti-limoti ika na ɓambanzʉ banda ɓatɛkɛɓɛ kuɓukumuti.» ");
INSERT INTO lik_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ɓaɓɨɓya ɓagya ndɨ ɓɛyɔ aka yɔ, ɓulikisa ndɨ ɓasɨ. ");
INSERT INTO lik_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yeso ava mukati nɨmɔ kuɓukumuti mɔ na ɓosi ɓaɓa, ɨkwɛ kʉgʉ wa lɨsyɛ, amigisya Kunzi ɨbɨba. Kumbuso yi agbananaga, ʉpá ɓaɓɨɓya ɓɛ ɓalʉpyɨ ka ambaza ka ɓambanzʉ. ");
INSERT INTO lik_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ɓasɨ ɓalyalya, ɓikutaga ndɨ ɓɨkpɛkɛɗɛ-kpɛkɛɗɛ. Ɓaɓɨɓya ɓamʉmʉla kʉwa nɨmɔ otigala ndɨ mɔ, ogwa ndɨ mʉmbɨ tɛkɛɓɛ na mɨɓa. ");
INSERT INTO lik_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Lɨsyɛ limoti Yeso akɨɗa ndɨ kalʉmba, ɓaɓɨɓya kakɨ ɓa ndɨ pa imoti na ɨyɨ. Umuusa ɓɛ: «Ɓambanzʉ ɓa pɨyɛ kaɓɨkya ɓɛ ɨmɨ nɨ wanɨ?» ");
INSERT INTO lik_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ɓasikisya ndɨ ɓɛ: «Ɓatʉ ɓemoti-ɓemoti ɓakaɓɨkya ɓɛ ɨwɛ nɨ Yuani-Mubatizaɨ, ɓagɔgɔ ɓɛ ɨwɛ nɨ mugyalandʉ Ɨlɨya, ɓagɔgɔ ɓata ɓɛ ɨwɛ nɨ mugyalandʉ ɓemoti wandɛlɨ nɨnɔ opupiku ɓi ka ɓabɨlɨ.» ");
INSERT INTO lik_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Kumbuso yi, Yeso umuusa kʉwa ndɨ ɨɓʉ ɓɛ: «Sɛ kʉwa iɓunu, makaɓɨkya ɓɛ ɨmɨ nɨ wanɨ?» Pɛtɛlɛ amigisya ɓɛ: «Ɨwɛ nɨ Masiya nɨnɔ ko Kunzi.» ");
INSERT INTO lik_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yeso ʉgbɨtyaga ndɨ ɓɛ ɓakaɓikyonito mʉmbanzʉ. ");
INSERT INTO lik_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Omotiloku ndɨ ɓata ɓɛ: «Okwononi ɓɛ Mika-mʉmbanzʉ igyogyisi kʉgbɛ, ɓambɔkʉ-mbɔkʉ ka Ɓayuda, ɓokumu-kumu na ɓowonisilo ɓa mʉtʉʉ ɓambimbo, ɓamwisiso. Luki limoti, ka lɨsyɛ la masaa kumbusa wa kukwakʉ kakɨ, opupoku ka mbʉkʉ.» ");
INSERT INTO lik_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Kumbuso yi ʉɓɨkya ndɨ ɨɓʉ ɓasɨ ɓɛ: «Mʉmbanzʉ kapa kɛɓɨɓya, okwononi ɨmʉyɨ ɨyɨ mombukwana-dakɨ, abɨnɨka mʉsalaba kakɨ masyɛ masɨ, anɛɓɨɓya. ");
INSERT INTO lik_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","A ɓɛyɔ, mʉmbanzʉ kapa kaɓuulyogo ɔɓɨlɨ kakɨ kʉnʉ kusili wa mɔnɨ, aɓungusatʉ, luki limoti mʉtʉ yi nɨnɔ aɓungusa ndɛkɛ ɔɓɨlɨ kakɨ ko bulya kamɨ, ahukusatʉ ndɛkɛ. ");
INSERT INTO lik_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","A ɨzangɨya tino mʉmbanzʉ kainisono na lɨngama lasɨ la ɔɓɨlɨ, nɨ aɓungusini ikanɨ aputini ɔɓɨlɨ kakɨ ɓɨkpɛ? ");
INSERT INTO lik_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Mʉtʉ wasɨ nɨnɔ ɨmʉkanaga suni ko bulya kamɨ na ko bulya lɨkpʉmʉka kamɨ, Mika-mʉmbanzʉ amɨnyɨlya ndɛkɛ ɨyɨ suni ɓɛgɛyɔ wa odoku ndɛkɛ mino ka ɨbɨba kakɨ na ka ɨbɨba ka Baba pa imoti na ɓamalaika ɓotu. ");
INSERT INTO lik_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Luki limoti, nakamʉɓɨkya ɓɨngbanganya ambɛ, a lɨngʉnʉ: ɓambanzʉ ɓemoti-ɓemoti nɨɓana ɓa wanʉ, ɓakokwigʉ ndɛkɛ kanɨ ɓakinigʉ Ɓʉngama ko Kunzi.» ");
INSERT INTO lik_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ɓuwobi kadwɛ pɔsɔ imoti kumbusa wa mʉnzɨna mi nɨmɔ, Yeso aɗaka ndɨ ka ngʉpa pa imoti na Pɛtɛlɛ, Yuani na Yakɔbɔ kalʉmba. ");
INSERT INTO lik_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ko ngbingo yi nɨnɔ a ndɨ mino kalʉmba nɔ, misa kakɨ igomosyana ndɨ, ɓotu kakɨ oɓuɓa ndɨ ɓitu abɛ ngbangbata kangɨnana. ");
INSERT INTO lik_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ɓambanzʉ ɓaɓa ɓopupana ndɨ ɓigbututu kanzɨna na Yeso: a ndɨ nɨ Musa na mugyalandʉ Ɨlɨya. ");
INSERT INTO lik_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ɨbɨba ko Kunzi ukungula ndɨ ɓikululu. Ɓa ndɨ kanzɨna na Yeso kʉgʉ wa kukwakʉ kakɨ nɨkwɔ igyonosa ndɛkɛ ka Yelusalɛma. ");
INSERT INTO lik_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pɛtɛlɛ na ɓawai-dakɨ ɓa ndɨ ɓuɗukono ka ɓatɔtɔ ɓingbwungono. Nɨyɔ ɓozuzukoku, ɓɨna ndɨ ɨbɨba ka Yeso pa imoti na ɓalʉkʉ ɓaɓa ɓi nɨɓɔ ɓa ndɨ ka kpɔlɔ kakɨ ɓɔ. ");
INSERT INTO lik_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ko ngbingo yi nɨnɔ ɓatu ɓi nɨɓɔ ɓa ndɨ mino kaasanana na Yeso, Pɛtɛlɛ aɓɨkya kʉwa ɨyɨ ɓɛ: «Muwonisilo, a ɓɨnza iɓusu kaika wanʉ. Topiki ɓangbangba ɓayɨsaa, nɨyɔ kakʉ, nɨyɔ ka Musa na nɨyɔ ka Ɨlɨya.» A ndɨ kanzɨna nɨ kɛgʉ kaiba ɓɛ akaɓɨkya ɓʉ. ");
INSERT INTO lik_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Nɨyɔ a ndɨ kanzɨna ɓɛyɔ, lindindi odoku ndɨ ɓɨkwa, utikya ɨɓʉ ɓasɨ na kululuko. Ɓaɓɨɓya ɓaɓanga ndɨ kʉgbɛ wa lindindi utikya ndɨ mino ɓɛyɔ. ");
INSERT INTO lik_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Lɨyʉ otukyoku ka lindindi kʉ ɓɛ: «Nɨmʉna a Mikamɨ mʉpaka nɨnɔ napʉnaga ndɨ. Mumukononi ɨyɨ!» ");
INSERT INTO lik_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Kumbusa wa lɨyʉ nɨlɔ, ɓaɓɨɓya ɓɨkwɛ ndɨ, ɓamɨna kʉwa Yeso aka mʉkaka. Ɓadakyana ndɨ ɓiwo, kanɨ ɓakatumbulyogigʉ mʉmbanzʉ gʉtʉgʉ ɓemoti aka lɨkpʉmʉka nɨlɔ ɓɨna ndɨ lɔ. ");
INSERT INTO lik_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ɓʉgala ɓi, Yeso na ɓaɓɨɓya ɓasaa ɓosya ndɨ ka ngʉpa, ambaza mudingi ka ɓambanzʉ akpuɗoku ndɨ. ");
INSERT INTO lik_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Wɨna sɛ, alʉkʉ ɓemoti kʉsɔ wa ambaza wa apʉnga kapamɨkanaga, ɓɛ: «Muwonisilo, kikiliki, nakaʉkʉnga ambɛ ɨndɨlyanɔ ɓaka mikamɨ mʉlʉkʉ yi nɨmʉ, a ɨyɨ yɨkaka aka kʉ kamɨ! ");
INSERT INTO lik_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Lɨmbɛngɨ la ɓʉnyɛ limoti akagyogyiso, ko ngbinga ɓemoti akugwisogo, anzimbo no ngu, ofu atumo ka mʉnɔkʉ ɓɨɗɛ. Lɨmbɛngɨ la ɓʉnyɛ li nɨlɔ asaga kanɨ agyogyisini. ");
INSERT INTO lik_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nitotonogi ɓi na ɓaɓɨɓya kakʉ ambɛ ɓokpumyi lɨmbɛngɨ la ɓʉnyɛ li nɨlɔ, luki limoti ʉgyagya.» ");
INSERT INTO lik_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yeso usikisya ɓɛ: «Eeeze iɓunu, lɨvananza la masyɛ mi nɨma, makɛgʉ na baya, ma ɓanyɛ! Nakwanana ndɛkɛ kaika pa imoti ɓongbinga ɓɨnga? Nakwanana kapɨla ɓʉzʉ kunu ɓongbinga ɓɨnga? Doku no mikakʉ kʉnʉ!» ");
INSERT INTO lik_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ko ngbingo yi nɨnɔ miki a kʉwa ndɨ mina kaisisilo ɓuwobi na Yeso, lɨmbɛngɨ la ɓʉnyɛ li nɨlɔ abʉmya wasɨ ɓɨngɔmʉ, anzimba ndɨ no ngu. Luki limoti, Yeso apamɨlya ndɨ lɨmbɛngɨ la ɓʉnyɛ, miki ahʉka, amigisya abakɨ. ");
INSERT INTO lik_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Nɔkʉ ʉdɨka ndɨ ɓambanzʉ ɓasɨ ɓɨdɛ kaɨna ngu yidingi ko Kunzi. Ɓambanzʉ yɨkaka-yɨkaka ɓa ndɨ kombomboya ka masɨ nɨmɔ Yeso agya ndɨ. Ʉɓɨkya ɓaɓɨɓya kakɨ ɓɛ: ");
INSERT INTO lik_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Hukononi ɓɨnza nɨlɔ nakamʉɓɨkya: ɓasʉtatʉ ɓanʉ Mika-mʉmbanzʉ ka maɓɔkʉ ka ɓambanzʉ.» ");
INSERT INTO lik_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Luki limoti, ɓaɓɨɓya ɓakɛgʉ ndɨ kotombisyo isi ya mʉnzɨna mi nɨmɔ. Isi a ndɨ na ɨɓʉ yakɨsʉma kyɛ ɓakibonitɔgʉ. Ɓa ndɨ gɔnɨ kaɓanga kamuusa bulyo yi. ");
INSERT INTO lik_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Kumbuso yi, ɓaɓɨɓya ɓapʉnga ndɨ kaɨnzɨnzɨnya luga kaɓʉ ɓɛ wanɨ nɔ a mʉtʉ wa ɨbɨba kʉgbɛ. ");
INSERT INTO lik_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yeso andʉnga ndɨ tamanaga kaɓʉ. Kʉwa wa ava ndɨ miki ɓemoti abiso ɓuwobi na ɨyɨ, ");
INSERT INTO lik_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ʉɓɨkya ɓɛ: «Mʉmbanzʉ yi nɨnɔ abibisa miki ɓɛyɔ ka nɨmʉna ko bulya kamɨ, ebibisi ɨmɨ ɓɨkpɛ, na mʉmbanzʉ yi nɨnɔ akebibiso, akabibiso gɔnɨ nɨnɔ etikoku ndɨ. Kyɛ mʉmbanzʉ yi nɨnɔ akainisono abɛ mʉtʉ wa payaya kʉgbɛ luga kunu ɓasɨ, ɨyɨ nɔ a mʉtʉ wa ɨbɨba.» ");
INSERT INTO lik_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Kʉwa wa, Yuani aɓɨkya ndɨ Yeso ɓɛ: «Muwonisilo, tamini ɓi mʉtʉ ɓemoti kokpumyo mambɛngɨ ma ɓʉnyɛ ko lino kakʉ. To ɓi kapa kapakya kyɛ kɛgʉ ka mʉɗɔngɔ kusu.» ");
INSERT INTO lik_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Luki limoti, Yeso aka na ɨyɨ ɓɛ: «Makapokyonitɔgʉ, kyɛ mʉtʉ yi nɨnɔ kɛgʉ mumuyoniso kakʉ, a wai-dakʉ.» ");
INSERT INTO lik_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Nɨyɔ masyɛ ka Yeso obimono kaɗaka kʉgʉ wa lɨsyɛ, otiwolya ndɨ lɨgʉndʉ kaɗaka ka Yelusalɛma. ");
INSERT INTO lik_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ʉtɨka ndɨ ɓatʉ ɓemoti ɓɛnɛ kambwa. Ɓɨnda ndɨ, ɓingyo ka mugi mimoti ka Ɓasamalia kaɓungusilyo pa ya ɓusisini. ");
INSERT INTO lik_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Luki limoti, ɓatʉ ɓa mugi mi nɨmɔ ɓakya ndɨ katɨlya kyɛ a ndɨ ɨyɨ kaɨnda misa ka Yelusalɛma. ");
INSERT INTO lik_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ngbingo yi nɨnɔ ɓaɓɨɓya kakɨ ɓɛyɔ ka Yakɔbɔ ɨɓʉ na Yuani ɓɨna mino ɓɛyɔ, ɨɓʉ aka ɓɛ: «Mombukwono-dosu, wopatʉ ɓɛ takʉngɨ ɓuku kotukyoku kʉgʉ wa lɨsyɛ na kaulumwisogo?» ");
INSERT INTO lik_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yeso oyikana ndɨ misa kʉ ɓa ndɨ mino, uyoyiso. ");
INSERT INTO lik_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Kumbuso yi, ɓɨnda kʉwa ndɨ ka mugi magɔgɔ. ");
INSERT INTO lik_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ngbingo yi nɨnɔ Yeso na ɓaɓɨɓya kakɨ ɓa ndɨ mino ko pisi, alʉkʉ ɓemoti aɓɨkya ɓɛ: «Nʉɓɨɓya pa yasɨ kʉ wɨnda ndɛkɛ mino.» ");
INSERT INTO lik_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yeso aɓɨkya ɓɛ: «Ɓanzɨyɔ ɓa na maɓaga, ɓombu ɓa na ɓandaɓʉ, luki limoti Mika-mʉmbanzʉ kɛgʉ na pa yakanga na yakimumbiso.» ");
INSERT INTO lik_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Aɓɨkya ndɨ mʉtʉ wagɔgɔ ɓɛ: «Iɓyeku.» Luki limoti, alʉkʉ nɔ aɓɨkya ɓɛ: «Muwonisilo, ɨsɨlya mbɛyɨ ngbingo kaɨnda kalumba baba.» ");
INSERT INTO lik_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yeso amigisya ndɨ ɓɛ: «Hʉsa ɓamanda, ɓolumbi ɓamanda kaɓʉ, ɨwɛ, wɨnda kaɓɨkyaga mongoni ma Ɓʉngama ko Kunzi.» ");
INSERT INTO lik_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Alʉkʉ wagɔgɔ aɓɨkya ɓata ɓɛ: «Muwonisilo, nʉɓɨɓyatʉ ndɛkɛ, luki limoti ɨsɨlya mbɛyɨ ngbingo naga kaɨnanana na lɨvananza kamɨ.» ");
INSERT INTO lik_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yeso aɓɨkya ɓɨngbanganya ɓɛ: «Mʉmbanzʉ yi nɨnɔ apʉngaga kɛɓɨɓya, ɨkwɛ ɓata kumbuso, kakwananɨgʉ ka Ɓʉngama ko Kunzi.» ");
INSERT INTO lik_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Kumbuso yi, Mombukwono-dosu ʉpʉnaga ɓambanzʉ ɓagɔgɔ ɓatɛkɛɓɛ maɗɨya na ɨka na ɓaɓa, ʉtɨka ndɨ ɓaɓa-ɓaɓa kambwa ka ɓagʉɗʉ ɓasɨ no giyo yasɨ nɨyɔ ɨyɨ mombukwana-dakɨ a ndɨ mino kaɨnda. ");
INSERT INTO lik_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Kambwa wa lɨgʉndʉ kaɓʉ, ʉɓɨkya ɓɛ: «Masɔlɔ a mudingi, luki limoti ɓagya-ligubo ɓa ɓakɛɗɛ. Muɓikyoni nɛkɨ mombukwono tiko ambɛ utikiku ɓagya-ligubo kanyɔ masɔlɔ kakɨ. ");
INSERT INTO lik_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Wogoni! Namutiki abɛ ɓomikya ɓakɔndɔlɔ lugo ko ɓosukopi. ");
INSERT INTO lik_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Makovonitɔgʉ ɓuyi, kʉgba, gʉtʉgʉ ɓɛkpakʉ aka, makamuusonito mʉmbanzʉ ko pisi. ");
INSERT INTO lik_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ka ndaɓʉ yasɨ nɨyɔ mogulyaga ɓanʉ mino, ɓikyogoni ɓanʉ amɓɛ: ‹Mazɨyɔ iki ka ndaɓʉ yi nɨyɨ.› ");
INSERT INTO lik_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Kika nɨ mʉtʉ wa mazɨyɔ a ka ndaɓʉ yi nɨyɔ, mazɨyɔ kunu ika kʉgʉ kakɨ. Kiki, mazɨyɔ mi nɨmɔ amumigilyoku. ");
INSERT INTO lik_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Wikoni ka ndaɓʉ yi nɨyɔ aka yɔ, manalya na komwo nɨmɔ ɓika kamʉpá kyɛ mʉgya-ligubo okwononi na mʉkalya kakɨ. Makikonitɔgʉ kaamama ka ɓandaɓʉ gbalɨ. ");
INSERT INTO lik_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Makogulyaga ɓanʉ ka gʉɗʉ ɓemoti ɓɛnɛ, ɓatʉ ɓi ɓamʉtɨlya, lyoni nɨmɔ ɓika kamʉpá, ");
INSERT INTO lik_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","muhukuso ɓatʉ ɓa ɓokoloɓu nɨɓɔ ɓika kʉ, mʉɓɨkya ɓɛ: ‹Ɓʉngama ko Kunzi a kʉwa ɓuwobi.› ");
INSERT INTO lik_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Luki limoti, makogulya ɓanʉ ka gʉɗʉ ɓemoti nɨ ɓakamutilyigʉ, puponi wa, momisikana ka gʉɗʉ yi nɨnɔ, manaɓɨkya ɓɛ: ");
INSERT INTO lik_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‹Tibumini liɓungu la gʉɗʉ kunu, gʉtʉgʉ nɨlɔ a ka ɓakagba kusu aka. Luki limoti, wiboni ɓɨnza ambɛ Ɓʉngama ko Kunzi a kʉwa ɓuwobi.› ");
INSERT INTO lik_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nakamʉɓɨkya ambɛ ka lɨsyɛ lɨkɔ ngbanga, Kunzi ugyogyisa ndɛkɛ ɓatʉ ɓa gʉɗʉ yi nɨnɔ kʉgbɛ kaʉkɨtaga nɨɓɔ ɓa Sɔdɔmʉ.» ");
INSERT INTO lik_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","«Kumbu kakʉ, gʉɗʉ wa Kɔlazini! Kumbu kakʉ gʉɗʉ wa Bɛtɛsaida! Makpʉmʉka mʉmbanga-mbanga nɨmɔ igyonasa ndɨ kʉ kunu kigyonosa ndɨ ka Tilo na Sidɔna, iba ɓatʉ ɓi ɓowonisiloni ndɨ kumbu kaɓʉ ndɛlɨ, ɓimokisya ɓotu ɓaya lɨlɛɓʉ, ɓiɓuɓisa nzʉyɨ na libu ɓitu, ɓoyikono. ");
INSERT INTO lik_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Kinili, ka lɨsyɛ lɨkɔ ngbanga, ɓamugyogyisa ndɛkɛ kʉgbɛ kakɨtaga Tilo na Sidɔna. ");
INSERT INTO lik_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Sɛ ɨwɛ Kapɛlɛnaumu, wakasɨma ɓɛ waɗakatʉ ɓanʉ kadwɛ kʉgʉ wa lɨsyɛ? Usisa ndɛkɛ kadwɛ ka ɓabɨlɨ.» ");
INSERT INTO lik_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yeso ʉɓɨkya ɓata ɓaɓɨɓya kakɨ ɓɛ: «Mʉmbanzʉ kamʉmʉkana, emukoni ɨmɨ, mʉmbanzʉ kamʉmʉya, emuyi ɨmɨ, mʉmbanzʉ kɛmʉya, amuyi nɨnɔ etikoku.» Kumbuso yi ɓaga ndɨ. ");
INSERT INTO lik_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ngbingo yi nɨnɔ ɓaɓɨɓya ɓatɛkɛɓɛ maɗɨya na ɨka na ɓaɓa ɓigononoku mino, ɓa kʉwa ndɨ nɨ ɓotumini na magyagya ɓɨɗɛ, ɓanaɓɨkya ɓɛ: «Mombukwono-dosu, gʉtʉgʉ mambɛngɨ ma ɓʉnyɛ aka o ɓi katɨmʉkana ngbingo yi nɨnɔ to ɓi mino kaʉpamyaga ko lino kakʉ!» ");
INSERT INTO lik_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yeso usikisya ɓɛ: «Namɨna ndɨ Abɨlɨ kogwoku kʉgʉ wa lɨsyɛ mʉɗɔngɔnɨ abɛ ngbangbata kangɨnana. ");
INSERT INTO lik_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Hukononi: namʉpá ndɨ ngu kaʉɗɨtaga ɓanzʉka, ɓanakwaa-gbanɨ, no ngu yasɨ ka Mumuyoniso, luki gʉtʉgʉ limoti aka kamʉgyɨgʉ ndɛkɛ ɓʉnyɛ. ");
INSERT INTO lik_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Luki limoti, makogwonitɔgʉ magyagya asɨ kyɛ mambɛngɨ ma ɓʉnyɛ akamʉmʉkana, gwoni magyagya mudingi kʉgbɛ kyɛ Kunzi okpikoni ndɨ mino kunu kʉgʉ wa lɨsyɛ.» ");
INSERT INTO lik_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ko ngbingo yi nɨnɔ gɔnɨ nɔ, Yeso otuma na magyagya ko ngu ya Lɨmbɛngɨ-Lotu, ɨyɨ aka ɓɛ: «Baba ooo, Mombukwana masɨ nɨmɔ a kʉgʉ wa lɨsyɛ na nɨmɔ kʉnʉ ka lɨtɔmbʉ, nubibisini kyɛ uwonisilo ɓatʉ nɨɓɔ ɓakibigʉ luki makpʉmʉka mʉmbanga-mbanga nɨmɔ ʉsʉmɨlya ndɨ ɓatʉ ɓa yimibo na nɨɓɔ ɓa akili. Iyo Ba, a ɓɛyɔ kyɛ wabaɨlya ndɨ ɓɛyɔ.» ");
INSERT INTO lik_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","«Baba epóni makpʉmʉka masɨ. Gʉtʉgʉ mʉtʉ ɓemoti aka kibigʉ ɓɛ Miki nɨ wanɨ kiki asɨ Baba aka, na gʉtʉgʉ mʉmbanzʉ ɓemoti aka kibigʉ ɓɛ Baba nɨ wanɨ kiki asɨ Miki aka, na sɛ kʉwa nɨɓɔ Miki akapa kaumibiso.» ");
INSERT INTO lik_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Kumbuso yi, Yeso oyikana ndɨ misa ka ɓaɓɨɓya kakɨ, ɨyɨ aka ɓɛ: «Magyagya iɓunu kaɨna nɨlɨna makaɨna lɨ! ");
INSERT INTO lik_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","A ɓɛyɔ, nakamʉɓɨkya ɓɨngbanganya ambɛ, ɓogyalandʉ na ɓangama ɓakpʉ ɓa ndɨ na mʉsasa kaɨna makpʉmʉka mʉmbanga-mbanga nɨmana makaɨna ma, luki limoti ɓakɨnagʉ ndɨ. Ɓa ndɨ gɔnɨ na mʉsasa kaʉkana nɨmana makaʉkana ma, luki limoti ɓakʉkanagʉ ndɨ.» ");
INSERT INTO lik_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Kʉwa wa, muwonisilo wa Mʉtʉʉ ka Musa ɓemoti amaga ndɨ kaɓɔɓɔ Yeso, amuusa ɓɛ: «Muwonisilo, nakwanana pɨyɛ kagya ɓʉnɨ kainisono na ɔɓɨlɨ wa ɓɛnzɛ na ɓɛnzɛ?» ");
INSERT INTO lik_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yeso asikisya ɓɛ: «Ɓokpika sɛ mbɛyɨ ka Mʉtʉʉ ɓʉnɨ? Ʉkanaga ɓʉnɨ kʉsɔ yi wa watangʉlaga mino?» ");
INSERT INTO lik_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Alʉkʉ nɔ amigisya ɓɛ: «Mʉpa Mombukwana-dakʉ Kunzi na lɨmbɛngɨ kakʉ lasɨ, na mʉtamanagɨ kakʉ masɨ, no ngu kakʉ yasɨ, na yimibo kakʉ yasɨ.» Na: «Wapa wai-dakʉ ɓɛyɔ aka yɔ wɨpaga mino.» ");
INSERT INTO lik_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yeso amigisya ɓɛ: «Ɛɛɛ, wosikisyiku ɓɨnza. Gya nɛkɨ ɓɛyɔ winisana na ɔɓɨlɨ wa ɓɛnzɛ na ɓɛnzɛ.» ");
INSERT INTO lik_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Yɛkɨ muwonisilo wa mʉtʉʉ a ndɨ kapa kowonisilo ɓungbingbili kakɨ, amuusa Yeso ɓɛ: «Wai sɛ kʉwa nɨ wanɨ?» ");
INSERT INTO lik_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yeso amigisya na mʉtʉmbʉlagɨ ɓɛ: «A ndɨ lɨsyɛ limoti, mʉtʉ ɓemoti otukyoku ka Yelusalɛma kosya ka mugi ma Yeliko. Kadwɛ ko pisi, abangana na ɓonzikaɓʉ, ɓagwi, ɓabʉma, ɓakʉpya makpʉmʉka masɨ, ɓanyɔ ɓotu, ɓaga, ɓasa ɓuwobi kokwo. ");
INSERT INTO lik_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Kumbuso yi, kumu-kumu ɓemoti a ndɨ kosyoku ko pisi yi nɨyɔ gɔnɨ yɔ. Nɨyɔ amɨna mʉtʉ yi nɨnɔ, ɨkɨta ka kpɔlɔ, akpangba, aga yakakɨ. ");
INSERT INTO lik_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Kagya yɨkɛɗɛ ɓɛnɛ, Mulawi odoku wa gɔ wa. Nɨyɔ amɨna alʉkʉ nɔ, ɨkɨta gɔnɨ ka kpɔlɔ, akpangba, aga. ");
INSERT INTO lik_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Luki limoti, Musamalia ɓemoti nɨnɔ otukyoku ndɨ ɨyɨ ɓyɨ, oɓyeku ko pisi yi nɨyɔ gɔnɨ yɔ. Nɨyɔ odweku wa, amɨna, akwilya kumbu. ");
INSERT INTO lik_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Akpuɗoku, asʉkʉsa ɓapwayɨ na vinya, ogboɗya na molingo, akanda. Kumbuso yi abɨnɨka kʉgʉ wa punda kakɨ, aga na ɨyɨ ka ndaɓʉ ka ɓobiko ɓɛ ɓatʉkɨ. ");
INSERT INTO lik_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Nɨyɔ lɨsyɛ asyɛ kʉwa, Musamalia anyɔ ɓuyi ɓambuma ɓaɓa apá mombukwana ndaɓʉ, aɓɨkya ɓɛ: ‹Mʉtʉka alʉkʉ yi nɨmʉna ɓɨnza, nakalya ɓanʉ masɨ nɨmɔ wagyɨlya ko ngbingo wa kigoku.›» ");
INSERT INTO lik_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ka muliɓo, Yeso amuusa kʉwa ɓɛ: «Wanɨ nɔ luga ka ɓatʉ nɨɓɔ ɓasaa ɓɔ akaʉmɨnɨkyana abɛ kika ndɨ wai-dakɨ mʉtʉ yi nɨnɔ ɓonzikaɓʉ ɓabʉma ndɨ nɔ?» ");
INSERT INTO lik_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Muwonisilo wa Mʉtʉʉ ka Musa asikisya ɓɛ: «Nɨnɔ akwilya ndɨ kumbu.» Yeso opipiloku kʉwa na ɨyɨ ɓɛ: «A ɓɛyɔ, wɨnda, ɨwɛ wogyoku ɓɛgɛyɔ!» ");
INSERT INTO lik_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ngbingo yi nɨnɔ Yeso na ɓaɓɨɓya kakɨ ɓa ndɨ mino ka lɨgʉndʉ, adwɛ ndɨ ka mugi mimoti kʉ muko nɨnɔ ina ndɨ ɓɛ Malata atɨlya ndɨ mino kʉ kakɨ. ");
INSERT INTO lik_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","A ndɨ na mamakɨ ɓemoti mʉsɨka yi nɨnɔ ina ndɨ ɓɛ Malia nɨnɔ a ndɨ wakiko kambwa ka Mombukwono-dosu, anʉkana mʉtɨwɨ kakɨ. ");
INSERT INTO lik_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Luki limoti, Malata a ndɨ kaɗanga ɓɨɗanga-ɗanga na mogubo. Odoku ka kpɔlɔ ka Yeso ko ngbinga mʉkɛɗɛ, aɓɨkya ɓɛ: «Mombukwono-dosu, wɨna mbɛyɨ ɓɛyɔ Malia esi mino mʉkaka na mogubo masɨ ɓɛnɛ! Ɨɓɨkyɨlya nɛkɨ yakakɨ ambɛ esingyiku.» ");
INSERT INTO lik_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Mombukwono-dosu asikisya ɓɛ: «Malata, Malata, wakombomboyo na kahiyungo ko bulya makpʉmʉka ɓinzenge-nzenge, ");
INSERT INTO lik_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","wɨna sɛ, luki limoti aka lɔ a la ɨzangɨya. Malia opuni ɓi nɨlɔ a lanza kʉgbɛ na mʉmbanzʉ gʉtʉgʉ ɓemoti aka kakʉpyɨgʉ ndɛkɛ.» ");
INSERT INTO lik_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Lɨsyɛ limoti, Yeso a ndɨ kalʉmba ka pa imoti ɓɛnɛ. Nɨyɔ ama kalʉmba, mʉɓɨɓya kakɨ ɓemoti amuusa ɓɛ: «Mombukwono-dosu, tiwonisila gɔnɨ iɓusu kalʉmba ɓɛyɔ Yuani-Mubatizaɨ uwonisila ndɨ mino ɓaɓɨɓya kakɨ.» ");
INSERT INTO lik_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Kʉwa wa, Yeso ʉɓɨkya ndɨ ɓɛ: «Ngbingo yi nɨnɔ mo mino kalʉmba, ɓikyogoni ɓɛ: ‹Obosu nɨnɔ kʉgʉ wa lɨsyɛ, lino kakʉ a lotu. Ɓʉngama kakʉ oduku! ");
INSERT INTO lik_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Tɨpáganɔ masyɛ masɨ malɨlɨ nɨmɔ okwononi na iɓusu. ");
INSERT INTO lik_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Watɨpɨlya ɓʉnyɛ kusu, ɓɛgɛyɔ iɓusu tʉpɨlyaga mino ɓatʉ ɓasɨ nɨɓɔ ɓatɨgyɨlyaga ɓʉnyɛ. Wakatisonitɔgʉ kogwa ka kʉɓɔɓɔkʉ.›» ");
INSERT INTO lik_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yeso ʉɓɨkya ɓata ndɨ ɓaɓɨɓya kakɨ ɓɛ: «Kika mbɛyɨ nɨ mʉtʉ ɓemoti luga kunu a na mamakɨ, ɨnda kʉ kakɨ na gʉndʉ kaɓɨkya ɓɛ: ‹Yaya, ɨpá mino malɨlɨ, ");
INSERT INTO lik_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","kyɛ wai ɓemoti esilyiniku, nakɛgʉ gʉtʉgʉ na malɨlɨ kapá mbɨya wanʉ.› ");
INSERT INTO lik_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Kika nɨ mamakʉ usikisyiniku kʉ ka ndaɓʉ ɓɛ: ‹Ɨsa kedomiso! Tidulogini iɓusu na ɓomikamɨ, tangaga, nakakwananɨgʉ katʉkya kaʉpá malɨlɨ.›» ");
INSERT INTO lik_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Yeso omotiloku ɓɛ: «Ɛɛɛ a ɓɛyɔ, nakamʉɓɨkya ambɛ, mamakʉ otukyokuto kaʉpá malɨlɨ! Gʉtʉgʉ kotukyi kyɛ a wai-dakʉ, otukyokuto ʉpá kyɛ ika kanɨ wakungini na lɨmbɛngɨ lɨnda. ");
INSERT INTO lik_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Kinili, ɨmɨ nakamʉɓɨkya ambɛ: Kungoni, ɓamʉpátʉ. Kisoni, minisonisatʉ nolu. Yiponi holi, ɓamuukulyatʉ mupumi. ");
INSERT INTO lik_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","A ɓɛyɔ, mʉtʉ wasɨ nɨnɔ akʉngaga, ɓapágatʉ. Nɨnɔ akɨsaga, inisanagatʉ nolu. Na nɨnɔ ayipogo holi, ɓahukwilyagatʉ mupumi. ");
INSERT INTO lik_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Abakɨ miki tino nɔ luga kunu, mikakɨ kakʉnga musi, akwanana kʉwa kapá nzʉka! ");
INSERT INTO lik_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ikanɨgʉ kakʉnga lakɨ, apá kʉwa nakwaa-gbanɨ? ");
INSERT INTO lik_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Gʉtʉgʉ ɓɛyɔ mo mino ɓanyɛ, luki limoti mibagatʉ kaʉpá ɓomiki kunu makpʉmʉka manzanza. Obonu nɨnɔ kʉgʉ wa lɨsyɛ a wanza, kinili a lɨngʉnʉ ɓɛ ʉtɨkɨlyatʉ ɓatʉ nɨɓɔ ɓakʉngaga Lɨmbɛngɨ-Lotu.» ");
INSERT INTO lik_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Lɨsyɛ limoti, Yeso a ndɨ kokpumya lɨmbɛngɨ la ɓʉnyɛ kʉsɔ ka alʉkʉ ɓemoti. Lɨmbɛngɨ li nɨlɔ a kʉwa ndɨ nɨ aitisini ɓoɓo. Nɨyɔ lɨmbɛngɨ la ɓʉnyɛ apupa ndɨ ɓɛyɔ, ɓoɓo apʉnga kanzɨna. Kʉwa wa, ambaza ka ɓambanzʉ nɨɓɔ ɓa ndɨ wa ɓombombaya ndɨ kʉgbɛ. ");
INSERT INTO lik_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Luki limoti ɓagɔgɔ luga kaɓʉ ɓa ndɨ kaɓɨkya ɓɛ: «Akopkumyo mambɛngɨ ma ɓʉnyɛ no ngu ka Belizebuli, nɨnɔ a ngama wa mambɛngɨ ma ɓʉnyɛ mi nɨmɔ!» ");
INSERT INTO lik_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ɓagɔgɔ ɓa ndɨ kaɓɔɓɔ Yeso, ɓanaɓɨkya ɓɛ agyɨ likingyosi kotukyoku kʉgʉ wa lɨsyɛ. ");
INSERT INTO lik_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Luki limoti, Yeso a ndɨ kaiba tamanaga kaɓʉ, ʉɓɨkya ɓɛ: «Lɨvananza la ɓʉngama ɓumoti kapʉnga kabʉmana lugo yi, iba ɓʉngama ɓi nɨɓɔ osyini. Ɓandaɓʉ ɓoyi oɗukana ɓayasɨ ɓɨgbatata. ");
INSERT INTO lik_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Kika nɛkɨ nɨ Abɨlɨ akabʉmana na mombukwana-dakɨ yi, ɓʉngama kakɨ akwanana kʉwa kaidukulogo kaamaga lɨkɨ? Kyɛ makabɨkya bɛ nokpumyaga mambɛngɨ ma ɓʉnyɛ no ngu ka Belizebuli. ");
INSERT INTO lik_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Kika nɨ ɨmɨ nakokpumyo mambɛngɨ ma ɓʉnyɛ no ngu ka Belizebuli, ɓomikunu, ɓa kʉwa ɨɓʉ kokpumyo no ngu ka wanɨ? Kinili, iɓunu ɓamombukwana-daɓʉ bi ɓɔ mika ndɛkɛ ɓazozi. ");
INSERT INTO lik_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Luki limoti, ɨmɨ, nakokpumyo mambɛngɨ ma ɓʉnyɛ no ngu ko Kunzi. Nɨyɔ akowonisilo ɓɛ Ɓʉngama ko Kunzi odunuku luga kunu! ");
INSERT INTO lik_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ngbingo yi nɨnɔ tutungyo ikaga mino na makpʉmʉka ma lʉnga masɨ, oɓuulyogo ndaɓʉ kakɨ ɓɨnza. Lɨngama kakɨ lasɨ ikaga ka mazɨyɔ gɔnɨ. ");
INSERT INTO lik_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Luki limoti, tutungyo wongu kakɨtaga ɨyɨ kodoku, andʉngʉlyaga, akʉpya makpʉmʉka ma lʉnga nɨmɔ ɨtambyago bi nomu, alʉpyaga masɨ nɨmɔ ika nɨ akupyini. ");
INSERT INTO lik_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Mʉtʉ nɨnɔ kɛgʉ pa imoti na ɨmɨ, a mumuyoniso kamɨ, nɨnɔ kɛgʉ kamʉmʉla pa imoti na ɨmɨ, a komisyo. ");
INSERT INTO lik_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Lɨmbɛngɨ la ɓʉnyɛ kapupo mʉmbanzʉ, aga kolingyo ɓapa ka ɓɛsa ɓilelele. Akɨsa pa ya kimumbiso, luki limoti nɨ kinigʉ. Kʉwa wa ilu aka ɓɛ: ‹Nakaɨga ka ndaɓʉ kamɨ, kʉ nopupiku ɓi mino.› ");
INSERT INTO lik_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Nɨyɔ ɨga ɓata, atakanya yɨkpaga ɓɨngɔ na yiɓungusya ɓɨnza. ");
INSERT INTO lik_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Aga kʉwa kava mambɛngɨ ma ɓʉnyɛ magɔgɔ maɗɨya na ɨka nɨmɔ manyɛnyɛ kakɨtaga ɨyɨ, ɓogulyo, ɓilikisyo wa. Ɔɓɨlɨ ka mʉtʉ yi nɨnɔ ika kʉwa wanyɛ kakɨtaga wa a ndɨ mino kambwa.» ");
INSERT INTO lik_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ngbingo yi nɨnɔ Yeso aɓɨkya ndɨ mino ɓɛyɔ, muko ɓemoti ka ambaza apamɨkana ɓɛ: «Ɨgyagya yidingi ka muko yi nɨnɔ wasyɛ ndɨ ka mʉma kakɨ, ulunguso!» ");
INSERT INTO lik_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Luki limoti, Yeso asikisya ndɨ ɓɛ: «Ɓɨkya yɨpɛpɛ ɓi ambɛ: ‹Ɨgyagya ka nɨɓɔ ɓʉkanaga lɨkpʉmʉka ko Kunzi, ɓanagya!›» ");
INSERT INTO lik_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ngbingo yi nɨnɔ ɓambaza ka ɓambanzʉ ɓa ndɨ mino kobwo, Yeso, idukulaga ndɨ kaɓɨkya ɓɛ: «Ɓatʉ ɓa lɨsyɛ li nɨlɨ ɓa ɓanyɛ. Iɓunu, makakʉnga likingyosi no ɓou, luki limoti makɨnɨgʉ ndɛkɛ ɓata likingyosi lagɔgɔ kiki nɨlɔ aka lɔ ka mugyalandʉ Yɔna. ");
INSERT INTO lik_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","A ɓɛyɔ, mʉɗɔngɔnɨ ɓɛyɔ Yɔna a ndɨ likingyosi ka ɓatʉ ɓa Nɨnawɛ, a mʉɗɔngɔnɨ ɓɛgɛyɔ Mika-mʉmbanzʉ ika ndɛkɛ mino likingyosi kambwa ka ɓatʉ ɓa lɨsyɛ li nɨlɨ. ");
INSERT INTO lik_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ka lɨsyɛ lɨkɔ ngbanga, ngama muko yi nɨnɔ otukyoku ndɨ ɓyɨ ka gʉɗʉ wa Sɨba kodoku kaʉkana mʉnzɨna ma yimibo ka ngama Sɔlɔmɔnɔ, amaga ndɛkɛ kambwa ka ɓatʉ ɓa lɨsyɛ li nɨlɨ kaʉsʉngʉlya! Winoni sɛ, wanʉ, a na mʉtʉ mudingi kakɨtaga Sɔlɔmɔnɔ.» ");
INSERT INTO lik_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ka lɨsyɛ lɨkɔ ngbanga, ɓatʉ ɓa Nɨnawɛ ɓamanana ndɛkɛ ɓigwo kambwa ka ɓatʉ ɓa lɨsyɛ li nɨlɨ ka mʉɗɔngɔ kaʉsʉngʉlya! Kyɛ ɓagomosyanatʉ ndɨ ɨɓʉ ɔɓɨlɨ kaɓʉ ngbingo yi nɨnɔ ɓamʉkana ndɨ mino Yɔna. Wɨna sɛ wanʉ a na mʉtʉ mudingi kakɨtaga Yɔna! ");
INSERT INTO lik_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","«Mʉmbanzʉ gʉtʉgʉ ɓemoti aka katʉnagɨgʉ tala asʉma ikanɨ agbukumisya ɓata na mʉmbɨ. Luki limoti, abisaga kʉgʉ iba ɓatʉ ɓasɨ nɨɓɔ ɓika kogulya ka ndaɓʉ ɓɨnɨ ɓʉngbanganya. ");
INSERT INTO lik_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Miso kakʉ nɨ tala wa nzʉyɨ kakʉ. Ngbingo yi nɨnɔ miso kakʉ kɛgʉ mino no koloɓu, nzʉyɨ kakʉ yasɨ a ka ɓʉngbanganya. Luki limoti, kika no koloɓu, nzʉyɨ kakʉ yasɨ a gɔnɨ ko biti. ");
INSERT INTO lik_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ɛɛɛ, wɨmɨnya sɛ! Ɓʉngbanganya kakʉ kikonitɔgʉ ɓimbusu-mbusu abɛ biti. ");
INSERT INTO lik_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Nzʉyɨ kakʉ yasɨ kika ɓɨngbanganya, nɨ kɛgʉ na ɓumbusu-mbusu, ika yasɨ ka ɓʉngbanganya, mʉɗɔngɔnɨ abɛ tala kuzigo na ɓʉngbanganya kakɨ.» ");
INSERT INTO lik_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Nɨyɔ Yeso ama ndɨ kanzɨna ɓɛyɔ, Mufalisayɔ ɓemoti amaka ndɨ kalyalya kʉ kakɨ. Ogulya ndɨ, iko, apʉnga kalyalya. ");
INSERT INTO lik_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Nɨyɔ Mufalisayɔ nɔ amɨna Yeso kalyalya nɨ kisukusigʉ maɓɔkʉ, lɨkpʉmʉka ambanga. ");
INSERT INTO lik_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Mombukwono-dosu aka ndɨ na ɨyɨ ɓɛ: «Iɓunu Ɓafalisayɔ, masʉkʉsa kɔpɔ na sanɨ asɨ kunzi aka. Luki limoti, kʉsɔ kunu mikaga ɓutumo no kuɓakʉ na ɗɨya ɓɨɗɛ! ");
INSERT INTO lik_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Makibigʉ luki! Makasɨma ɓɛ Kunzi nɨnɔ agya makpʉmʉka ma kunzi kibigʉ gɔnɨ nɨmɔ ma kʉsɔ? ");
INSERT INTO lik_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Hupóni ɓatʉ ɓayangya nɨmɔ ma na imu, iba masɨ iki kʉwa ɓɨngɔ ko bulya kunu. ");
INSERT INTO lik_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Kumbu kunu iɓunu Ɓafalisayɔ! A ɓɛyɔ, mapága Kunzi zaka wa makpʉmʉka masɨ, luki limoti makaɓʉsala kaiko ɓingbingbili na ɓambanzʉ na kapa Kunzi. Makwanano ɓi kagya ɓɛyɔ, nɨ makosigʉ magɔgɔ. ");
INSERT INTO lik_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Kumbu kunu Ɓafalisayɔ! Iɓunu mapaga kaiko ka moliki ma kambwa ka ɓandaɓʉ kunu ɓaya malʉmba. Mapaga gɔnɨ ɓɛ ɓambanzʉ ɓiki kamumuuso na ɨbɨba ka ɓapa ɓaya musilyoni. ");
INSERT INTO lik_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Kumbu kunu! Ma abɛ ɓambʉkʉ nɨɓayɔ kimibisikonogigʉ, ɓambanzʉ ɓanakpakyana kʉgʉ yi nɨ ɓakɛgʉ kaibo.» ");
INSERT INTO lik_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Kʉwa wa, ɓemoti luga ka ɓowonisilo ɓa mʉtʉʉ aɓɨkya ndɨ Yeso ɓɛ: «Muwonisilo, nɨyɔ wakaɓɨkya ɓɛyɔ, wakatɨtʉmbwa na iɓusu gɔnɨ!» ");
INSERT INTO lik_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yeso asikisya ndɨ ɓɛ: «Kumbu kunu gɔnɨ, iɓunu ɓowonisilo ɓa mʉtʉʉ! Mubinikisaga ɓambanzʉ mokumbogi mutititi kabɨnɨka, nɨmɔ iɓunu makavɨlɨgʉ gʉtʉgʉ na kpɛngbɛ aka kaubinikiso. ");
INSERT INTO lik_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Kumbu kunu! Makopika ɓambʉkʉ ka ɓogyalandʉ ko Kunzi nɨɓɔ ɓotitonu ɓulumwisaga ndɨ. ");
INSERT INTO lik_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Kʉwa ɓɛgɛyɔ makowonisila ɓɛ maɓɨnɨkyanatʉ ndɨ gɔnɨ iɓunu lɨkpʉmʉka nɨlɔ ɓotitonu ɓagya ndɨ lɔ. Ɨɓʉ ɓulumwisaga ndɨ ɓogyalandʉ, iɓunu makopika kʉwa ɓambʉkʉ kaɓʉ! ");
INSERT INTO lik_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Kinili Kunzi aɓɨkya ndɨ ka yimibo kakɨ ɓɛ: ‹Nʉtɨkɨlyatʉ ɓogyalandʉ na ɓatʉtʉmbwa. Ɓulumwisaga ndɛkɛ ɓemoti-ɓemoti luga kaɓʉ, ɓugyogyisa ɓagɔgɔ.› ");
INSERT INTO lik_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Katʉkya wa aka wa ɓagya ndɨ mino ɔɓɨlɨ, ɓulumwisogoni ɓogyalandʉ ɓudingi, na iɓunu ɓatʉ ɓa lɨsyɛ li nɨlɨna ɓɔ ɓamugyogyisa ndɛkɛ. ");
INSERT INTO lik_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ɓamwɔ mbɛyɨ ndɨ Abeli, ka muliɓo, ɓamwɔ ndɨ Zakalia, ka pa yangba ya Ndaɓʉ ko Kunzi, luga wa gbɔgbɔ nɨyɔ ɓapága ndɨ mino ɓapɛpɛ na pa yotu kʉgbɛ. Iyo, nakamʉɓɨkya ambɛ ɓugyogyisa ndɛkɛ ɓatʉ ɓa lɨsyɛ li nɨlɨ ko bulya makpʉmʉka nɨmɔ masɨ. ");
INSERT INTO lik_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Kumbu kunu ɓowonisilo ɓa mʉtʉʉ! Mudulyogoni ɓɛngɛnɨ pisi ya kiba lɨkpʉmʉka ko Kunzi ɓɨkpwɔkpwɔkpwɔ. Iɓunu ɓamombukwana-donu ɓi makɛgʉ iɓunu kogulyo, manʉkpɨngba gɔnɨ nɨɓɔ ɓakapa kogulyo.» ");
INSERT INTO lik_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Nɨyɔ Yeso opupa ka ndaɓʉ yi nɨyɔ, ɓowonisilo ɓa mʉtʉʉ na Ɓafalisayɔ ɓanyɔ ndɨ zigo. Ɓapʉnga ndɨ kakpɨma ɓuwobi-ɓuwobi ka ɓopisi ɓaya makpʉmʉka dididi. ");
INSERT INTO lik_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ka lɨngʉnʉ, ɓa ndɨ kalɨkaga ɓɛkyɛ akwanana ndɨ kasakaga ka mʉnzɨna kakɨ. ");
INSERT INTO lik_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ko ngbingo yi nɨnɔ, ɓambaza ɓakpʉkpʉ kʉgbɛ ka ɓambanzʉ ɓamʉmʉkana ndɨ ka kpɔlɔ ka Yeso, ɓotoni ɓikpwɔ, ɓanaɗɨtana magʉ ɓɨnvɨnvɨnvɨ. Yeso apʉnga mbɛyɨ kaʉɓɨkya ɓaɓɨɓya kakɨ aka ɓɛ: «Wiminyonito na kʉɓɔɓɔkʉ ka Ɓafalisayɔ nɨkwɔ a abɛ sɨbʉkʉsɔ nɨsɔ ofulisaga mukati. ");
INSERT INTO lik_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Masɨ nɨmɔ a makɨsʉma inisanatʉ ka ɓʉngbanganya, na nɨmɔ a ko dikiɗi, imibisikosatʉ ndɛkɛ. ");
INSERT INTO lik_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Kinili masɨ nɨmɔ makaɓɨkya ko biti, ɓambanzʉ ɓʉkana ndɛkɛ ka ɓʉngbanganya. Masɨ nɨmɔ makaɓɨkya na ɓepisi-pisi nɨ midulogini ka ndaɓʉ, ɓakʉwa ndɛkɛ ka ɓakugbondo.» ");
INSERT INTO lik_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","«Nakamʉɓɨkya iɓunu ɓawai ambɛ: makuɓongonitɔgʉ ɓatʉ nɨɓɔ ɓamwɔgɔ nzʉyɨ, luki limoti, nɨ kumbuso yi, ɓakakwananɨgʉ kagya luki lagɔgɔ kʉgʉ yi. ");
INSERT INTO lik_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Luki limoti, nakamʉɓɨkya ambɛ wanɨ nɔ mokwononi kaɓanga: muɓongoni Kunzi nɨnɔ, kumbusa wa kukwakʉ, a no ngu kamʉɗɨkɨta ko ɓuku ɓa ɓɛnzɛ na ɓɛnzɛ. Iyo, nakamʉɓɨkya ambɛ ɨyɨ nɔ mokwononi kaɓanga yi! ");
INSERT INTO lik_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ɓakʉgabagɨgʉ mbɛyɨ ɓakyɔkyɔɗɔ kuɓukumuti ka ɓambuma ɓaɓa? Luki limoti, Kunzi kaɓʉsalɨgʉ gʉtʉgʉ ɓemoti aka luga kaɓʉ. ");
INSERT INTO lik_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Gʉtʉgʉ tukatʉ ta ɓamʉ kunu aka tasɨ, atɨtanga. Makoɓongonitɔgʉ nɛkɨ! iɓunu ma na ɨzangɨya kʉgbɛ kaʉkɨtaga ɓakyɔkyɔɗɔ ɓudingi.» ");
INSERT INTO lik_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","«Nakamʉɓɨkya ɓata ambɛ: mʉtʉ wasɨ nɨnɔ ɛɓɨnɨkyana ko misa ka ɓambanzʉ, Mika-mʉmbanzʉ aɓɨnɨkyana ndɛkɛ ɨyɨ ɓɛgɛyɔ ko misa ka ɓamalaika ko Kunzi, ");
INSERT INTO lik_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","luki limoti mʉtʉ wasɨ nɨnɔ ɛmanganya ko misa ka ɓambanzʉ, Mika-mʉmbanzʉ amanganya ndɛkɛ ɨyɨ ɓɛgɛyɔ ko misa ka ɓamalaika ko Kunzi. ");
INSERT INTO lik_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Mʉtʉ wasɨ nɨnɔ akanzɨna yanyɛnyɛ ko bulya ko Mika-mʉmbanzʉ, inisatʉ na mʉpɨlya. Luki limoti nɨnɔ atʉmbwa Lɨmbɛngɨ-Lotu, kinisigʉ ndɛkɛ na mʉpɨlya. ");
INSERT INTO lik_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ngbingo yi nɨnɔ ɓɨnda ɓanʉ mino na iɓunu ka ɓandaɓʉ ɓaya malʉmba ka Ɓayuda, ka ɓangama na ɓatʉ ɓakpʉkpʉ, makomomonitɔgʉ kakɨsa ɓɛyɔ mosomboku mino ikanɨ ɓɛyɔ moɓikyoku mino. ");
INSERT INTO lik_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","A ɓɛyɔ, Lɨmbɛngɨ-Lotu amuwonisilatʉ nɨlɔ moɓikyoku ko ngbingo yi nɨnɔ aka nɔ.» ");
INSERT INTO lik_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Kʉwa wa mʉtʉ ɓemoti ka ambaza aɓɨkya ndɨ Yeso ɓɛ: «Muwonisilo, ɨɓɨkyɨlyanɔ ɓaka mika mama ambɛ tagbananɨ na ɨyɨ mukumbo nɨmɔ baba atɨsɨlya ndɨ.» ");
INSERT INTO lik_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Luki limoti Yeso asikisya ɓɛ: «Alʉkʉ aaa, wanɨ nɔ ebisi zozi kunu ikanɨ mʉtʉ mʉgbananaga lɨngama kunu na mamakʉ?» ");
INSERT INTO lik_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Kumbuso yi ʉɓɨkya ɓɛ: «Wiminyonito na mʉsasa ma mukumbo, kyɛ ɔɓɨlɨ ka mʉmbanzʉ kɛgʉ ko bulya ɓudingi ɓa mukumbo kakɨ, gʉtʉgʉ nɨ a na lɨngama lidingi aka.» ");
INSERT INTO lik_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Kumbuso yi, Yeso atwa kʉwa lizuni li nɨlɨ: «Mʉtʉ wa mukumbo ɓemoti a ndɨ na ɓotiko nɨɓayɔ apá ndɨ masɔlɔ makpʉ. ");
INSERT INTO lik_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Apʉnga ndɨ katamanaga, animuusa ɓɛ: ‹Nagya sɛ kʉwa ɓʉnɨ? Nakɛgʉ na pa nɨyɔ nobisa mino masɔlɔ kamɨ.› ");
INSERT INTO lik_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ɨyɨ aka ɓɛ: ‹Okwononi napanzɨ ɓabasa ɓaya masɔlɔ kamɨ, nopika nɨɓayɔ ɓayakpʉkpʉ kʉgbɛ, kʉsɔ yi nobiso ɓanʉ mino masɔlɔ na mukumbo kamɨ masɨ. ");
INSERT INTO lik_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Kumbuso yi, naɓɨkya kʉwa lɨmbɛngɨ kamɨ ɓɛ: Na kʉwa na mukumbo mudingi ka ɓyanga ɓakpʉ, noyukumatʉ kʉwa mbɛyɨ, nika kʉwa asɨ kalyalya aka, komwo na kazananɨlya ɔɓɨlɨ.› ");
INSERT INTO lik_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Luki limoti Kunzi aɓɨkya ɓɛ: ‹Ɨwɛ ngingi mʉna! Wakokwo no biti yi nɨyɨna aka yɨ. Wasɨlya kʉwa wanɨ mukumbo mi nɨmana wapɨmbya ɓɨkyɔkyɔkyɔ mana?›» ");
INSERT INTO lik_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yeso omotiloku ɓɛ: «A mʉɗɔngɔnɨ ɓɛyɔ ka nɨɓɔ ɓɨmʉmʉlyaga mukumbo, luki limoti kanɨ ɓakɛgʉ nomu kʉ ko Kunzi.» ");
INSERT INTO lik_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Kumbuso yi Yeso ʉɓɨkya ɓaɓɨɓya kakɨ ɓɛ: «Kinili nakamʉɓɨkya ambɛ: Makigbomisonitɔgʉ ɓamʉ ko bulya ɔɓɨlɨ kunu, iki ko bulya malɨlɨ, iki ko bulya nzʉyɨ kunu ikanɨ ko luki la kimokisyo. ");
INSERT INTO lik_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","A ɓɛyɔ, ɔɓɨlɨ a na ɨzangɨya kʉgbɛ kakɨtaga malɨlɨ, nzʉyɨ a na ɨzangɨya kʉgbɛ kakɨtaga ɓotu. ");
INSERT INTO lik_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Huminoni mbɛyɨ ɓombu! Ɓakakʉnagɨgʉ, ɓakobuulyogigʉ, ɓakɛgʉ na pa nɨyɔ ɓobisaga mino masɔlɔ, luki limoti Kunzi ulyolisagatʉ! Wɨna sɛ, iɓunu ma na ɨzangɨya yidingi kʉgbɛ kaʉkɨtaga ɓombu! ");
INSERT INTO lik_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Wanɨ nɔ akwanana luga kunu, pisi kaigbomisa mʉ, kosisilo mino masyɛ ma ɔɓɨlɨ kakɨ? ");
INSERT INTO lik_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Kika nɛkɨ ɓɛ makakwananɨgʉ kagya luki lɨkɛɗɛ abɛ nɨlɔ, ko bulya ɨkɨ yɔ makaigbomisa ɓamʉ ka makpʉmʉka magɔgɔ? ");
INSERT INTO lik_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Wondoni mbɛyɨ maʉwa mo tutu ɓizumuuu, winoni ɓɛyɔ aɓakaga mino: kagyagɨgʉ ligubo, kakʉɓagɨgʉ ɓotu. Luki limoti, nakamʉɓɨkya ambɛ, gʉtʉgʉ ngama Sɔlɔmɔnɔ aka ka lɨngama kakɨ lasɨ, kimokisyagʉ ndɨ kutuko kwanza gʉtʉgʉ kumoti aka abɛ lɨʉwa limoti luga wa nɨma. ");
INSERT INTO lik_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Kika nɛkɨ nɨ Kunzi akomokisyogo mapakʉ mo tutu nɨmɔ a na lɨsyɛ li nɨlɨ wa, na ɓʉgala ɓaɗɨkɨta ko ɓuku, ko bulya ɨkɨ yɔ kakwananɨgʉ mino kamumokisyogo iɓunu ɓɨkpɛ? Eeeze, sɛ kʉwa iɓunu ɓana ma na baya yɨkɛɗɛ aaa! ");
INSERT INTO lik_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Sɛ kʉwa iɓunu, makomomonitɔgʉ kakɨsa ɓɛ talya ɨkɨ, ikanɨ ɓɛ tomwo ɨkɨ. Makigbomisonitɔgʉ ɓamʉ ka nɨlɔ. ");
INSERT INTO lik_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","A ɓɛyɔ, ɓatʉ nɨɓɔ ɓakamibigʉ Kunzi ɓɔ ɓikaga kaamama kakɨsa masɨ mi nɨmɔ. Luki limoti, Obonu ibagatʉ ɓɛ ma na mʉsasa ma makpʉmʉka mi nɨmɔ. ");
INSERT INTO lik_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Luki limoti kisoni mbɛyɨ Ɓʉngama ko Kunzi, kumbuso yi amʉpá kʉwa gɔnɨ magɔgɔ kʉgʉ yi. ");
INSERT INTO lik_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Makoɓongonitɔgʉ, iɓunu ambaza mʉkɛɗɛ aaa! Baba ɨna ndɨ ɓɨnza kamʉpá Ɓʉngama kakɨ! ");
INSERT INTO lik_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Goboni mukumbo kunu, mʉpá ɓatʉ ɓa yangya ɓuyi ɓi. Ika abɛ makɨgyɨlya iɓunu ɓamombukwana-donu ɓi ligi yɨsʉma ɓuyi nɨyɔ ɓuyi koɓungigʉ mino. Bisoni lɨngama kunu kʉgʉ wa lɨsyɛ kʉ kapʉtɨkanɨgʉ ndɛkɛ mino. Mʉtʉ wo kuɓakʉ kakpʉɗɨgʉ, mʉkɛkɛɗʉ kalyɨgʉ ɓɛgɛyɔ. ");
INSERT INTO lik_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","A ɓɛyɔ, pa yi nɨyɔ mukumbo kakʉ o mino, lɨmbɛngɨ kakʉ ika kʉ gɔ kʉ.» ");
INSERT INTO lik_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","«Wikoni ɓakɨtʉlya kagya ligubo, mikondini ɗʉkʉfɨtɔ ɓingbufu, ɓatala kunu ɓʉtʉna ɓingbiii! ");
INSERT INTO lik_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Wikoni abɛ ɓagya-ligubo nɨɓɔ ɓikaga kaɓʉnda mombukwana-daɓʉ nɨ anigoku ko dumo. Ngbingo yi nɨnɔ osiloku mino, koyipa holi ɓahukulya mupumi ɓɨgala-gala. ");
INSERT INTO lik_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Magyagya ka ɓagya-ligubo nɨɓɔ, kika nɨ mombukwana-daɓʉ iginiku, ʉtakanya ɓuɓisi! A lɨngʉnʉ, nakamʉɓɨkya ambɛ, imokisya kutuko kwa ligubo, ulikiso ɓagya-ligubo kakɨ ka mɨza, ʉlʉpyaga malɨlɨ. ");
INSERT INTO lik_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Kagyɨgʉ luki kika nɨ iginiku na gʉndʉ gʉtʉgʉ ko mboluga aka, ʉtakanya ɓuɓisi, ɓika na magyagya! ");
INSERT INTO lik_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Wiboni gɔnɨ ɓɨnza ɓɛ mombukwana ndaɓʉ kibogigʉ ngbingo yi nɨnɔ mʉtʉ wo kuɓakʉ odogoku mino. Kibaga ndɨ, iba kasagɨgʉ mʉtʉ wo kuɓakʉ kogulya kʉ kakɨ. ");
INSERT INTO lik_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Wikoni nɛkɨ ɓakɨtʉlya, kyɛ Mika-mʉmbanzʉ odoku ndɛkɛ ko ngbingo yi nɨnɔ makikigʉ mino na mʉtamanagɨ.» ");
INSERT INTO lik_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Kʉwa wa Pɛtɛlɛ amuusa ndɨ Yeso ɓɛ: «Mombukwono-dosu, lizuni li nɨlɨna wakaɓɨkya lɨ a ko bulya kusu aka ikanɨ ko bulya ka ɓatʉ ɓasɨ?» ");
INSERT INTO lik_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Mombukwono-dosu asikisya ndɨ ɓɛ: «Wanɨ sɛ kʉwa nɔ a mʉgya-ligubo walɨngʉnʉ na wakimibo? A nɨnɔ mombukwana-dakɨ asɨlya ligubo lɨlʉpyaga malɨlɨ ka ɓagya-ligubo ɓagɔgɔ ko ngbingo yi nɨnɔ okwononi mino. ");
INSERT INTO lik_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ɨgyagya ka mʉgya-ligubo nɨnɔ mombukwana-dakɨ kigoku, atakanya iɗukufini ɓiguɓu kagya ligubo li nɨlɔ. ");
INSERT INTO lik_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nakamʉɓɨkya ɓɨngbanganya, a lɨngʉnʉ: mombukwana-dakɨ abisa ngama kaanda mukumbo kakɨ masɨ. ");
INSERT INTO lik_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Luki limoti, kika nɨ mʉgya-ligubo nɔ oɓikyini ɓɛ: ‹Mombukwana-damɨ kɛgʉ kaigoku mbɨya wanʉ!› apʉnga kaʉbʉma ɓagya-ligubo ɓagɔgɔ ɓalʉkʉ na ɓoko ɓi, kalyalya, komwo na kadamʉwa, ");
INSERT INTO lik_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","kʉwa wa mombukwana-dakɨ yi nɨnɔ igoku ɓanʉ ka lɨsyɛ na ko ngbingo yi nɨnɔ kikigʉ mino kaibo, akpumyo, agyogyisa mʉɗɔngɔnɨ ɓɛyɔ Kunzi ugyogyisa ndɛkɛ mino ɓatʉ nɨɓɔ ɓakɛgʉ ka ɓungbingbili. ");
INSERT INTO lik_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Mʉgya-ligubo nɨnɔ ibaga nɨlɔ mombukwana-damɨ apaga, nɨ kɛgʉ wakɨtʉlya kagya ɓɛyɔ, alya pimbo yidingi kʉgbɛ. ");
INSERT INTO lik_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Luki limoti, nɨnɔ kibogigʉ nɨlɔ mombukwana-damɨ apaga, anagya makpʉmʉka nɨmɔ okwononi ɓɛ ɓagyogyisi mino, alya pimbo yɨkɛɗɛ. Nɨnɔ ɓapá mudingi, ɓakʉnga ndɛkɛ kaigiso mudingi gɔnɨ. Kasɨlya mʉmbanzʉ kaanda makpʉmʉka mudingi, akʉnga kʉwa ndɛkɛ ɓata mudingi kakɨtaga.» ");
INSERT INTO lik_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yeso aɓɨkya ɓɛ: «Nodoku ndɨ kaɗɨkɨta ɓuku ka ɔɓɨlɨ, no ɓi kapa kʉgbɛ ambɛ ogbundikoninɔ gʉtʉgʉ ɓi! ");
INSERT INTO lik_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Na na iɓatiso nɨyɔ okwononi ɓɛ nogwi. Lɨmbɛngɨ kamɨ a kʉgʉ ɓɨɗa kadwɛ kʉ kwa kʉ igyonoso mino! ");
INSERT INTO lik_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Makasɨma ɓɛ nodoku ndɨ kapá mazɨyɔ ka ɔɓɨlɨ? Nakamʉɓɨkya ambɛ: kɛgʉ ɓɛyɔ, luki limoti ɓambanzʉ ɓɨgbananagatʉ ko bulya kamɨ. ");
INSERT INTO lik_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Katʉkya mbɨya-mbɨya wanʉ, lɨvananza limoti la ɓambanzʉ kuɓukumuti ɨgbananagatʉ ɓanʉ ko bulya mʉtɨwɨ kamɨ, ɓasaa ɓuyikonilya ɓaɓa na ɓaɓa ɓuyikonilya ɓasaa. ");
INSERT INTO lik_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Abakɨ miki ɓɨgbanana ndɛkɛ no mikakɨ, miki ɓɨgbanana na abakɨ. Amakɨ miki ɓɨgbanana no mikakɨ mʉsɨka yi, miki nɨnɔ mʉsɨka yi nɔ ɓɨgbanana na amakɨ, tɨtakɨ miki ɓɨgbanana na muzyakɨ, muzyozyo ɓɨgbanana na tɨtakɨ.» ");
INSERT INTO lik_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yeso aɓɨkya ɓata ndɨ ambaza ka ɓambanzʉ ɓɛ: «Ngbingo yi nɨnɔ mɨnaga mino ɓɛkʉɓa ɓayo mbwayɨ miso ka dumbe, maɓɨkyaga ɓɨgala-gala ɓɛ: ‹Mbwayɨ alʉkatʉ›, igyonosa ɓɛyɔ aka yɔ. ");
INSERT INTO lik_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ngbingo yi nɨnɔ mɨnaga mino muvivi anovivo katʉkya miso ka zebu, maɓɨkyaga ɓɛ: ‹ɓʉzʉ ikatʉ kʉgbɛ›, igyonosa ɓɛyɔ aka yɔ. ");
INSERT INTO lik_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Iɓunu ɓatʉ ɓa kʉɓɔɓɔkʉ ɓana! Ma ɓakɨtʉlya kaiba isi ya makpʉmʉka ma ɔɓɨlɨ nɨmɔ akainisoniso kʉnʉ ka lɨtɔmbʉ na kʉgʉ wa lɨsyɛ, luki limoti ko bulya ɨkɨ yɔ makɛgʉ mino kaiba isi ya makpʉmʉka nɨmɔ akaigyonosa mbɨya wanʉ?» ");
INSERT INTO lik_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","«Ko bulya ɨkɨ yɔ makakɔgɨgʉ iɓunu ɓamombukwana-donu lɨkpʉmʉka kunu na ɓungbingbili ko pisi ya yɨgya kunu? ");
INSERT INTO lik_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Makika kaɨnda kambwa ka ɓazozi na mumuyoniso kakʉ, gya ngu kaʉkanana na ɨyɨ nɨ ma mbɛyɨ ko pisi aka. Wakagya ɓɛyɔ, iba waukogini mumuyoniso kakʉ ɓɛ kudwisonitɔgʉ kambwa ka zozi, zozi ukitisaga ka maɓɔkʉ ka polisi, polisi ugwi. ");
INSERT INTO lik_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nakaʉɓɨkya bɛyɔ ambɛ ɓakugwi, wakopupikugʉ kʉ ɓɛyɔ kanɨ wakanokolyigʉ ɓuyi ɓasɨ nɨɓɔ ika nɨ ɓukuni.» ");
INSERT INTO lik_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ko ngbingo yi ndɨ nɨnɔ, ɓambanzʉ ɓemoti-ɓemoti ɓodoku ndɨ katʉmbʉlyaga Yeso, ɓɛyɔ Pilatʉ ulumwisaga ndɨ mino Ɓagalilaya ko ngbingo yi nɨnɔ ɓa ndɨ mino kapá Kunzi ɓapɛpɛ. Na ɓangʉ kaɓʉ amatɨkana ndɨ na nɨyɔ ka ɓanyama ɓi nɨɓɔ ɓa ndɨ kaʉpá ka apɛpɛ. ");
INSERT INTO lik_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yeso umigisya ɓɛ: «Makasɨma ɓɛ ɓulumwisaga ndɨ Ɓagalilaya ɓi nɨɓɔ kyɛ ɓa ndɨ ɓatʉ ɓanyɛ kʉgbɛ kaʉkɨtaga ɓagɔgɔ ɓasɨ? ");
INSERT INTO lik_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Haaa, luki limoti nakamʉɓɨkya ambɛ makoyikosi yɨgya kunu, iɓunu ɓasɨ molumwaga ndɛkɛ mʉɗɔngɔnɨ abɛ ɨɓʉ gɔnɨ. ");
INSERT INTO lik_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ikanɨ makasɨma ɓɛ ɓambanzʉ tɛkɛɓɛ na ɓʉgɨna ɓi nɨɓɔ mʉnala ma Siloamu ʉgbɨgbɨla ndɨ, ulumwisogo, ɓɔ ɓa ndɨ ɓagya-manyɛ kaʉkɨtaga ɓatʉ ɓasɨ ɓa Yelusalɛma? ");
INSERT INTO lik_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Haaa, luki limoti nakamʉɓɨkya ambɛ makoyikosi yɨgya kunu, iɓunu ɓasɨ molumwaga ndɛkɛ mʉɗɔngɔnɨ abɛ ɨɓʉ gɔnɨ.» ");
INSERT INTO lik_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Kumbuso yi Yeso ʉɓɨkya ndɨ lizuni li nɨlɨ: «Mʉmbanzʉ ɓemoti a ndɨ na ɓʉgɔ nɨɓɔ akʉna ndɨ ko tiko kakɨ. Odogoku ndɨ kaanda bumo yi, luki limoti nɨ kinigʉ. ");
INSERT INTO lik_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Aɓɨkya kʉwa zamʉ wo tiko ɓɛ: ‹Wɨna mbɛyɨ! A kʉwa ɓyanga ɓɨsaa wa nodogoku mino kaanda magɔ kusili wa ɓʉgɔ ɓi nɨɓa nɨ nakɛgʉ katakanya yi. Gbɨta! Ko bulya ɨkɨ yɔ o mino kohuma pa payaya?› ");
INSERT INTO lik_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Luki limoti zamʉ nɨnɔ asikisya ndɨ ɓɛ: ‹Mombukwono-dosu, wasa mbɛyɨ ɓata ka syangasʉ si nɨsɨ. Nakpɔ mbɛyɨ ka ɓakpɔlɔ-kpɔlɔ ɓi, noɗuka na lɨtɔmbʉ la dɔɓɔ. ");
INSERT INTO lik_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Takagya ɓɛyɔ, akwananatʉ yagɔgɔ kaɓʉkʉta ka syangasʉ sa kumbuso! Koɓukuti sɛ kʉwa, wogbitisiso!›» ");
INSERT INTO lik_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Lɨsyɛ limoti la kimumbiso, Yeso a ndɨ kapá mʉtɨwɨ ka ndaɓʉ imoti ya malʉmba ka Ɓayuda. ");
INSERT INTO lik_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Kʉ ɓɛyɔ, a ndɨ na muko ɓemoti nɨnɔ a ndɨ no koloɓu kʉsɔ wa ɓyanga tɛkɛɓɛ na ɓʉgɨna. Lɨmbɛngɨ la ɓʉnyɛ limoti a ndɨ nɨ andungulyogini, aɗukufo mʉgɔngʉ ɓiguɓu nɨ kɛgʉ wa akwanana ndɨ mino gʉtʉgʉ kananɨkana aka. ");
INSERT INTO lik_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Nɨyɔ Yeso amɨna ɓɛyɔ, amaka, aɓɨkya ɓɛ: «Yɛ ma, koloɓu kakʉ osyini.» ");
INSERT INTO lik_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Abisilya ndɨ maɓɔkʉ, wa aka wa ananɨkana, apʉnga ndɨ kabibiso Kunzi. ");
INSERT INTO lik_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Luki limoti, nɨyɔ ngama wa ndaɓʉ ya malʉmba yi nɨyɔ ɨna ɓɛ Yeso ahukusini mʉmbanzʉ ka Lɨsyɛ la kimumbiso, lɨmbɛngɨ akandɨkanaga ndɨ ɓɨsʉlʉ-sʉlʉ. Ɨyɨ aka na ambaza ka ɓambanzʉ ɓi nɨɓɔ ɓa ndɨ ɓʉmʉmʉkana wa ɓɛ: «Masyɛ ma ligubo a maɗɨya, dogoniku kayihukuso ka masyɛ mi nɨmɔ aka mɔ nɨ kɛgʉ ka Lɨsyɛ la kimumbiso!» ");
INSERT INTO lik_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Luki limoti, Mombukwono-dosu amigisya ɓɛ: «Ma ɓatʉ ɓa kʉɓɔɓɔkʉ! Ka Lɨsyɛ la kimumbiso, mʉmbanzʉ yɨkaka-yɨkaka luga kunu kakʉlagɨgʉ ngɔmbɛ ikanɨ punda kakɨ ka pa ɨlyalya, atundulo komwa liɓo? ");
INSERT INTO lik_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Na muko yi nɨmʉ, miko mika Abalahamʉ nɨnɔ abɨlɨ akandaga ndɨ ka ɓyanga tɛkɛɓɛ na ɓʉgɨna, kokwononigʉ ɓi ɓɛ ɓakʉlagɨ ka ligbito kakɨ ka Lɨsyɛ la kimumbiso?» ");
INSERT INTO lik_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ngbingo yi nɨnɔ Yeso a ndɨ mino kaʉɓɨkya ɓɛyɔ, ɓomuyoniso kakɨ ɓasɨ ɓɨmʉkana ndɨ suni. Luki limoti ambaza wasɨ ka ɓambanzʉ ogwa ndɨ magyagya kaɨna makpʉmʉka mʉmbanga-mbanga masɨ nɨmɔ a ndɨ kagya mɔ. ");
INSERT INTO lik_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Kumbuso yi Yeso aɓɨkya ɓɛ: «Ɓʉngama ko Kunzi a mʉɗɔngɔnɨ na ɨkɨ? Nokingyasa pɨyɛ na ɨkɨ? ");
INSERT INTO lik_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","A abɛ libumo lɨkɛɗɛ nɨlɔ mʉtʉ ɓemoti ava ndɨ, akʉna ko tiko kakɨ. Nɨyɔ aɓaka, ɨɨta kʉwa ndɨ sɨbʉkʉsɔ sidingi, ɓombu ɓodoku kopika ɓandaɓʉ kaɓʉ kʉgʉ wa tabɨ yi.» ");
INSERT INTO lik_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yeso aɓɨkya ɓata ɓɛ: «Nokingyasa Ɓʉngama ko Kunzi na ɨkɨ? ");
INSERT INTO lik_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","A mʉɗɔngɔnɨ abɛ sɨbʉkʉsɔ nɨsɔ ofulisaga mukati. Muka ɓemoti ava ndɨ, opula na fufu wakpʉ kadwɛ kʉkwakʉ fufu ofula ndɨ mino wasɨ ɓɨdaɨ-daɨ!» ");
INSERT INTO lik_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Kumbuso yi, Yeso ɨnda ndɨ misa ka Yelusalɛma, anolingyo ɓagʉɗʉ no giyo dididi, anapá mʉtʉʉ. ");
INSERT INTO lik_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Mʉtʉ ɓemoti amuusa ndɨ ɓɛ: «Mombukwono-dosu, ɓambanzʉ ɓakɛɗɛ aka ɓɔ ɓinisonisa ndɛkɛ na muhukuso?» Yeso usikisya ɓɛ: ");
INSERT INTO lik_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Gyoni ngu yasɨ kogulya ka mupumi makpwɔ. A ɓɛyɔ, nakamʉɓɨkya ambɛ, ɓambanzʉ ɓudingi ɓakɨngɨla ndɛkɛ kogulya mino, luki limoti ɓakakwananɨgʉ. ");
INSERT INTO lik_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ngbingo yi nɨnɔ mombukwana ndaɓʉ amaga ndɛkɛ mino, adʉlaga mupumi, iɓunu, mika ndɛkɛ kunzi, mapʉnga koyipa holi manaɓɨkya ɓɛ: ‹Mombukwono-dosu, tihukulyanɔ ɓaka mupumi.› Ɨyɨ amusikisya ndɛkɛ ɓɛ: ‹Nakibigʉ kʉ mapʉnya mino!› ");
INSERT INTO lik_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Iɓunu aka ndɛkɛ ɓɛ: ‹Talyalyaga ndɨ, tanomwo pa imoti na iɓunu, ɨwɛ gɔnɨ nɔ watɨpága ndɨ mʉtɨwɨ ka ɓapa yangba ɓaya ɓagʉɗʉ kusu.› ");
INSERT INTO lik_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Luki limoti, ɨgɨlya ndɛkɛ ɓata kamʉɓɨkya ɓɛ: ‹Nakibigʉ kʉ mapʉnya mino. Tukyoni ɓuwobi na ɨmɨ, iɓunu ɓasɨ ma ɓagya-manyɛ!› ");
INSERT INTO lik_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Kʉ ɓɛyɔ, ɓagamana ndɛkɛ na kaɨlya manzʉ wa mamɨna ndɛkɛ mino Abalahamʉ, Isaka, Yakɔbɔ na ɓogyalandʉ ɓasɨ nɨɓɔ ka Ɓʉngama ko Kunzi, luki limoti ɓamumbimba ndɛkɛ iɓunu kunzi! ");
INSERT INTO lik_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ɓambanzʉ ɓemoti-ɓemoti ɓodogoku ndɛkɛ katʉkya ka ɨngɛngɛ na ka dumbe, ka zɨɓɔ na zebu, ɓika ndɛkɛ ɓakikogo kalyalya ka ɓʉngama ko Kunzi. ");
INSERT INTO lik_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","A ɓɛyɔ, nɨɓɔ ɓa kumbuso, ɓika ndɛkɛ kambwa, na nɨɓɔ ɓa kambwa ɓika kʉwa ndɛkɛ kumbuso.» ");
INSERT INTO lik_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ko ngbingo yi nɨnɔ aka nɔ, Ɓafalisayɔ ɓemoti-ɓemoti ɓakpuɗoku ndɨ Yeso, ɓaɓɨkya ɓɛ: «Tʉkya wanʉ, waga ka pa yagɔgɔ, kyɛ ngama Ɛlɔdɨ Atipasɨ akapa kaumwisiso.» ");
INSERT INTO lik_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yeso umigisya ɓɛ: «Windoni kaɓɨkya nzɨyɔ nɨnɔ amɓɛ: ‹Na lɨsyɛ li nɨlɨna nakokpumyo mambɛngɨ ma ɓʉnyɛ, kohukuso ɓokoloɓu, na ɓʉgala nagya mʉɗɔngɔnɨ ɓɛgɛyɔ. Kumbusa wa masyɛ mi nɨmɔ, nama ligubo kamɨ.› ");
INSERT INTO lik_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Luki limoti, ʉɓɨkya ɓɛ: okwononi ɓɛ nidukulogi na lɨgʉndʉ kamɨ na lɨsyɛ li nɨlɨ, na ɓʉgala, na lɨsyɛ nɨlɔ lagɔgɔ, kyɛ kokwononigʉ ɓɛ ɓamwɨ mugyalandʉ kunzi wa Yelusalɛma. ");
INSERT INTO lik_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Eeeze iɓunu ɓatʉ ɓa Yelusalɛma, ɓatʉ ɓa Yelusalɛma, makahulumwisogo ɓogyalandʉ, manʉbʉma na matamʉ nɨɓɔ Kunzi utikoku! Nganga yɨnga yɔ napa ndɨ mino kaʉmʉmʉla ɓatʉ kakʉ mʉɗɔngɔnɨ ɓɛyɔ kɔkʉ ʉmʉmʉlaga mino ɓomikakɨ ka ɓɛpapandʉlʉ, luki limoti, iɓunu makapagʉ ndɨ! ");
INSERT INTO lik_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ɛɛɛ winoni sɛ, ndaɓʉ kunu otigala ngundu. Nakamʉɓɨkya ambɛ: makɛmɨnɨgʉ ɓata kadwɛ ko ngbingo yi nɨnɔ maɓɨkya ndɛkɛ mino ɓɛ: ‹Kunzi aɗukulyi mʉtʉ yi nɨnɔ akodoku ɓʉɓʉnga ko lina ka Mombukwono-dosu!›» ");
INSERT INTO lik_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Lɨsyɛ limoti la kimumbiso, Yeso ɨnda ndɨ kʉ ka ngama ɓemoti ka Ɓafalisayɔ nɨnɔ amaka ndɨ kalyalya kʉ kakɨ. Ɓambanzʉ ɓa ndɨ kanda Yeso ɓizumuuu. ");
INSERT INTO lik_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Wɨna sɛ, alʉkʉ ɓemoti wo koloɓu ya ngunde a ndɨ wakamaga wa. ");
INSERT INTO lik_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Kʉwa wa, Yeso umuuso ɓowonisilo ɓa mʉtʉʉ na Ɓafalisayɔ ɓɛ: «Mʉtʉʉ kusu apagatʉ ikanɨ amʉyatʉ kahukuso mʉmbanzʉ ka Lɨsyɛ la kimumbiso?» ");
INSERT INTO lik_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Luki limoti ɓadakyana ndɨ ɓiwo. Kʉwa wa Yeso avɨla ndɨ alʉkʉ nɔ, ahukuso, apá lɨgʉndʉ. ");
INSERT INTO lik_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Kumbuso yi Yeso ʉɓɨkya ndɨ ɓowonisilo ɓa mʉtʉʉ na Ɓafalisayɔ ɓɛ: «Wanɨ nɔ luga kunu, mikakɨ ikanɨ ngɔmbɛ kakɨ kogwa ka lɨɓyɛ, kakwananɨgʉ kanyɔ gʉtʉgʉ ka Lɨsyɛ la kimumbiso aka?» ");
INSERT INTO lik_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Lɨkpʉmʉka li nɨlɔ ʉmbanga ndɨ kaigisyo. ");
INSERT INTO lik_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yɛkɨ Yeso ɨnaga ndɨ ɓɛ ɓatʉ nɨɓɔ ɓʉmakaga ka malɨlɨ ɓakɨsaga kaiko ka moliki ma kambwa aka, ʉtʉlya ndɨ lizuni li nɨlɨ: ");
INSERT INTO lik_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Mʉmbanzʉ kʉmaka ko dumo wo vononi, wakikonitɔgʉ ka ɓuliki ɓa kambwa. Kyɛ yagɔgɔ ɓamokito gɔnɨ mʉtʉ wa ɨbɨba kaʉkɨtaga ɨwɛ, ");
INSERT INTO lik_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","iba mʉtʉ yi nɨnɔ amumoki iɓunu ɓasɨ ɓaɓa, kodonukuto kaʉɓɨkya ɓɛ: ‹Mʉsɨlya mbɛyɨ alʉkʉ yi nɨmʉ ɓuliki ɓi nɨɓa.› Wɨnda kʉwa kaiko ka ɓuliki ɓa kumbuso mutumo no suni ɓɨɗɛ. ");
INSERT INTO lik_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Luki limoti, ɓakʉmaka ko dumo, wɨnda kaiko ka ɓuliki ɓa kumbuso, iba ngbingo yi nɨnɔ mombukwono dumo odoku mino, ʉɓɨkyɨ nɨ ɨyɨ ɓɛ: ‹Waiaaa, da wiki kʉnʉ kambwa.› Wika kʉwa na ɨbɨba kambwa ka ɓatʉ ɓasɨ nɨɓɔ mika na ɨɓʉ kalyalya. ");
INSERT INTO lik_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","A ɓɛyɔ, mʉtʉ wasɨ nɨnɔ ɨbɨnɨkaga, Kunzi asisagatʉ. Na nɨnɔ isisogo, Kunzi abɨnɨkagatʉ.» ");
INSERT INTO lik_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Kumbuso yi, Yeso aɓɨkya mʉtʉ yi nɨnɔ amaka ndɨ nɔ ɓɛ: «Ngbingo yi nɨnɔ wo mino kaʉmaka ɓambanzʉ kalyalya kʉ kakʉ na ɓʉsɔɓɨ ikanɨ gʉtʉgʉ na ɓʉgɔgɔ aka, wakumokonitɔgʉ ɓawai-dakʉ, ɓamamakʉ, lɨvananza kakʉ, gʉtʉgʉ ɓapɨmbanɨ kakʉ aka nɨɓɔ ɓa mukumbo. Kyɛ ɨɓʉ ɓakwananatʉ gɔnɨ kaʉmaka ko ngbingo kaɓʉ, ika kʉwa abɛ ɓakumigisyo masɨ nɨmɔ upí ɓi. ");
INSERT INTO lik_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Luki limoti, ngbingo yi nɨnɔ wo mino kalyisiso dumo, hʉmaka ɓokwino, ɓatʉ ɓakɨgyagya, nɨɓɔ ɓa mʉdɨlɨ na nɨɓɔ ɓa ɓokoloɓu ɓaya mamɔmɔ. ");
INSERT INTO lik_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Wakagya ɓɛyɔ, Kunzi uɗukilyatʉ ɓʉɓʉnga kyɛ ɨɓʉ ɓakakwananɨgʉ kaumigisyo. Kunzi ʉkalya ndɛkɛ gɔnɨ ko ngbingo yi nɨnɔ ɓatʉ ɓongbingbili ɓopupa ndɛkɛ mino ka ɓambʉkʉ.» ");
INSERT INTO lik_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Nɨyɔ ɓʉkana mʉnzɨna mi nɨmɔ ɓɛyɔ, mʉtʉ ɓemoti luga ka nɨɓɔ ɓa ndɨ kalyalya pa imoti na Yeso aɓɨkya ɓɛ: «Ɨgyagya ka mʉtʉ yi nɨnɔ alyalya ndɛkɛ ko dumo nɨnɔ wa Ɓʉngama ko Kunzi!» ");
INSERT INTO lik_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yeso amigisya na lizuni li nɨlɨ: «Mʉtʉ ɓemoti alyisisa ndɨ dumo mudingi, ʉmaka ndɨ ɓambanzʉ ɓudingi. ");
INSERT INTO lik_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Nɨyɔ ngbinga wa malɨlɨ ɨtʉlyana, atɨka mʉgya-ligubo kakɨ kaʉɓɨkyaga ɓambanzʉ ɓasɨ nɨɓɔ ʉmaka ndɨ ɓɛ ɓoduku kyɛ ngbingo wa malɨlɨ itulyonini! ");
INSERT INTO lik_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Luki limoti ɨɓʉ ɓasɨ, yɨkaka-yɨkaka ɓaɓɨkyaga ndɨ ɓɛ ʉpɨlyɨ. Mʉtʉ wa mambwa aɓɨkya mʉgya-ligubo nɔ ɓɛ aɓikyiku mombukwana-dakɨ ɓɛ: ‹Noluwi ɓi tiko, okwononi ɓɛ naga mbɛyɨ kaɨnoku yi. Kikiliki, ɨpɨlyatʉ.› ");
INSERT INTO lik_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Mʉtʉ wagɔgɔ aɓɨkya ɓɛ: ‹Nuluwi ɓi ɓangɔmbɛ tɛkɛɓɛ ko bulya ligubo lɨkpɔ tiko, nakaɨnda kaʉnda. Kikiliki, ɨpɨlyatʉ ɓaka.› ");
INSERT INTO lik_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Mʉtʉ wagɔgɔ ɓata ɓɛ: ‹Navi ɓi muko mbɨya-mbɨya wanʉ, kinili nakɛgʉ ɨmɨ kaɨnda kʉ.› ");
INSERT INTO lik_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Mʉgya-ligubo ɨga ndɨ ka mombukwana-dakɨ, apága mongoni mi nɨmɔ masɨ. Nɨyɔ ʉkana ɓɛyɔ, lɨmbɛngɨ akandɨkanaga ɓɨsʉlʉ-sʉlʉ, aɓɨkya mʉgya-ligubo kakɨ nɔ ɓɛ: ‹Wogoni bɨgala ka mʉ ma sɛngɨ, ka ɓopisi ɓaya gʉɗʉ, idulyoku wanʉ na ɓatʉ ɓa yangya, nɨɓɔ ɓa kɨgyagya, nɨɓɔ ɓa ɓokoloɓu ɓaya mamɔmɔ na nɨɓɔ ɓa mʉdɨlɨ.› ");
INSERT INTO lik_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ngbingo yi nɨnɔ mʉgya-ligubo igoku mino, aɓɨkya ɓɛ: ‹Ngama, nogyi mʉɗɔngɔnɨ ɓɛyɔ aka yɔ weɓikyi mino, luki limoti pa atʉ aka mbɛyɨ ɓata.› ");
INSERT INTO lik_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Kʉwa wa aɓɨkya ɓɛ: ‹Syo ka mʉ ma sɛngɨ na ka ɓapa ɓayagɔgɔ kʉ wakwanana mino kaʉtakanya ɓambanzʉ. Hʉɓɨkya ɓatʉ ɓasɨ nɨɓɔ wabangana na ɨɓʉ ambɛ ɓoduku, iba dumo kamɨ otumi.› ");
INSERT INTO lik_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nakamʉɓɨkya ambɛ: ‹luga ka ɓatʉ ɓi nɨɓɔ ɓʉmaka ndɨ kambwa, kɛgʉ na mʉtʉ gʉtʉgʉ ɓemoti aka nɨnɔ alyalya ndɛkɛ ko dumo kamɨ!›» ");
INSERT INTO lik_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Kʉwa wa, ambaza mudingi ka ɓambanzʉ a ndɨ kaɓɨɓya Yeso. Oyikana ndɨ miso kʉ kaɓʉ, ʉɓɨkya ɓasɨ ɓɛ: ");
INSERT INTO lik_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Mʉmbanzʉ ika mʉɓɨɓya kamɨ iba ɛpaga kʉgbɛ kakɨtaga abakɨ, amakɨ, mukakɨ, ɓomikakɨ, ɓamamakɨ, gʉtʉgʉ kakɨtaga ɔɓɨlɨ kakɨ mombukwana-dakɨ yi aka. Kogyi ɓɛyɔ, kakwananɨgʉ kaika mʉɓɨɓya kamɨ. ");
INSERT INTO lik_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Mʉtʉ yi nɨnɔ kɛgʉ kabɨnɨka mʉsalaba kakɨ kɛɓɨɓya, kakwananɨgʉ kaiko mʉɓɨɓya kamɨ. ");
INSERT INTO lik_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Wanɨ mbɛyɨ nɔ luga kunu kapa kopika mʉnala, kapʉngɨgʉ mbɛyɨ kaiko, imuusa ɓɛ ligubo li nɨlɔ alya ɓuyi ɓɨnga. Kumbuso yi, anda ikanɨ atʉ no ɓuyi ɓudingi nɨɓɔ akwanana komosisyo noɓu ligubo li nɨlɔ. ");
INSERT INTO lik_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Luki limoti, kakpɔ asɨ muɓumbe aka nɨ komagʉ, ɓatʉ ɓasɨ nɨɓɔ ɓika kaɨna, ɓika katɨba, ");
INSERT INTO lik_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ɓanaɓɨkya ɓɛ: ‹Yooo! mʉtʉ yi nɨmʉna aɓʉkʉlaga ndɨ ɓɛ akopiko, luki limoti kanɨ komagʉ!› ");
INSERT INTO lik_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Mʉɗɔngɔnɨ gɔnɨ abɛ ngama ɓemoti mudingi kapa kaɨnda kabʉmana na ngama wagɔgɔ, apʉnga mbɛyɨ iko, imuusa ɓɛ: ‹Na na ɓasʉda ɛlɔfʉ tɛkɛɓɛ aka, nakwananatʉ kakpumyo noɓu mumuyoniso kamɨ nɨnɔ a ɨyɨ na ɨɓʉ ɓɛlɔfʉ ɓatɛkɛɓɛ ɓaɓa?› ");
INSERT INTO lik_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Kɨna ɓɛ kakwananɨgʉ kakpumyo, atɨkɨlya ɓambanzʉ nɨ a mbɛyɨ asɨ ɓyɨ aka kakʉnga ɓɛ ɓʉkananɨ ka mazɨyɔ.» ");
INSERT INTO lik_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Kʉwa wa Yeso opipiloku ɓɛ: «Gʉtʉgʉ mʉtʉ ɓemoti aka luga kunu, kakwananɨgʉ kaiko mʉɓɨɓya kamɨ kanɨ kosigʉ masɨ nɨmɔ a nomu.» ");
INSERT INTO lik_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","«Liniko a luki lanza. Luki limoti, liniko kandapamanaga, luki tino ɓata lɔ akwanana kondingimosogo? ");
INSERT INTO lik_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Kikigʉ ɓata na ɨzangɨya gʉtʉgʉ ko pisi imoti aka, luki limoti ɓombimbo kʉwa limbimbo. Mʉtʉ yi nɨnɔ a na motili ma kʉkana, ʉkanɨtɔ!» ");
INSERT INTO lik_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Lɨsyɛ limoti, ɓandɔmbɛ ɓa manzanza na ɓatʉ ɓagɔgɔ ɓa yɨgya-yanyɛ ɓasɨ ɓakpuɗoku ndɨ Yeso kamʉkana. ");
INSERT INTO lik_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Luki limoti Ɓafalisayɔ na ɓowonisilo ɓa mʉtʉʉ ɓapʉnga ndɨ kaɨnzɨnzɨnya, ɓanaɓɨkya ɓɛ: «Alʉkʉ yi nɨmʉna akaʉtɨlya na kalyalya na ɓatʉ ɓa yɨgya-yanyɛ!» ");
INSERT INTO lik_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yeso utulyoku kʉwa ndɨ lizuni li nɨlɨ: ");
INSERT INTO lik_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Mʉtʉ ɓemoti luga kunu kika na ɓakɔndɔlɔ mɨya, ɓemoti luga kaɓʉ oɓungogo, kakwananɨgʉ kaʉsa nɨɓɔ ɓatɛkɛɓɛ kʉɓɔmʉ na kʉɓɔmʉ ka ɨsa, aga kakɨsa nɨnɔ ika nɨ oɓungogini ɓi kadwɛ kʉ kwa kʉ aminoku mino? ");
INSERT INTO lik_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ngbingo yi nɨnɔ amɨna mino, ogwa magyagya. Abɨnɨka ka mambɨga. ");
INSERT INTO lik_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Kumbuso yi ɨga kʉ kakɨ, ʉmaka ɓawai-dakɨ na ɓapɨmbanɨ kakɨ, ʉɓɨkya ɓɛ: ‹Doniku kogwa magyagya pa imoti na ɨmɨ kyɛ naminini kɔndɔlɔ kamɨ nɨnɔ oɓungaga ndɨ!› ");
INSERT INTO lik_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nakamʉɓɨkya ambɛ a mʉɗɔngɔnɨ ɓɛgɛyɔ, ɨgyagya ikaga yidingi kʉgʉ wa lɨsyɛ wa mʉtʉ wanyɛ oyikasaga mino ɔɓɨlɨ kakɨ kakɨtaga nɨyɔ ɓambanzʉ ɓongbingbili ɓatɛkɛɓɛ kʉɓɔmʉ na kʉɓɔmʉ nɨɓɔ ɓakɛgʉ na mʉsasa koyikoso ɔɓɨlɨ kaɓʉ.» ");
INSERT INTO lik_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Yeso aɓɨkya kʉwa wa ɓɛ: «Kika nɨ muko ɓemoti a na ɓambuma tɛkɛɓɛ, ɓemoti yi oɓungo, kakwananɨgʉ katʉna tala, akpaga ndaɓʉ, akɨsa ɓɨwɛsɛɛɛ kadwɛ kʉ kwa kʉ aminoku mino? ");
INSERT INTO lik_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ngbingo yi nɨnɔ amɨna mino, ʉmaka ɓawai-dakɨ na ɓapɨmbanɨ kakɨ ʉɓɨkya ɓɛ: ‹Da mogwini ɨgyagya pa imoti na ɨmɨ kyɛ naminini ambuma yi nɨnɔ eɓungi ɓi!› ");
INSERT INTO lik_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nakamʉɓɨkya ambɛ a mʉɗɔngɔnɨ ɓɛgɛyɔ: Kunzi na ɓamalaika kakɨ ɓogwaga magyagya mudingi ko bulya ka mʉtʉ wanyɛ ɓemoti nɨnɔ oyikasaga ɔɓɨlɨ kakɨ.» ");
INSERT INTO lik_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yeso idukulaga ndɨ kaɓɨkya ɓɛ: «Mʉtʉ ɓemoti a ndɨ no ɓomiki ɓalʉkʉ ɓi ɓaɓa. ");
INSERT INTO lik_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Mupipilo aɓɨkya abakɨ ɓɛ: ‹Baba, ipóku ɨmɨ mukumbo ma lisimo li la kamɨ.› Kʉwa wa ʉgbananɨlyaga ndɨ ɓomikakɨ mukumbo. ");
INSERT INTO lik_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Kumbuso wa masyɛ makɛɗɛ, mupipilo amʉmʉla ndɨ nɨmɔ kakɨ, aga ndɨ no ɓuyi ɓi ka mugi mimoti ma ɓyɨ. Kʉ ɓɛyɔ, apʉta ndɨ ɓuyi kakɨ ɓasɨ, anakpakyana gbalɨ. ");
INSERT INTO lik_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Nɨyɔ ama kapʉta ɓuyi ɓasɨ, ayʉndɨ mudingi ogulya ndɨ ka mugi mi nɨmɔ, apʉnga ndɨ ka yangya ka makpʉmʉka masɨ. ");
INSERT INTO lik_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ogulya ndɨ ligubo ka mʉtʉ ɓemoti wa mugi mi nɨmɔ. Alʉkʉ yi nɨnɔ atɨka ndɨ ko tutu kauɓuulyogo ɓangʉya kakɨ. ");
INSERT INTO lik_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ikagatʉ ndɨ gɔnɨ na mʉsasa kalya malɨlɨ nɨmɔ ɓangʉya ɓalyaga ndɨ mɔ, luki limoti kɛgʉ gʉtʉgʉ ndɨ na mʉtʉ ɓemoti aka nɨnɔ akwanana ndɨ kapá. ");
INSERT INTO lik_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Kʉwa wa apʉnga ndɨ koyikosogo lɨmbɛngɨ. Ɨyɨ aka ɓɛ: ‹Ɓagya ligubo nɨɓɔ ka baba ɓalyalyaga ɓɨnza, na ɓa na malɨlɨ mudingi kakɨtaga! Wɨna sɛ, na kʉwa ɨmɨ kokwa na nza kʉnʉ! ");
INSERT INTO lik_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Natʉkyatʉ, nɨga ka baba, naɓikyoku ambɛ: Ba, nogyoni ndɨ ɓʉnyɛ ko misa ko Kunzi na ko misa ka kʉ. ");
INSERT INTO lik_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nakokwononigʉ ɓata ambɛ ɨmaka ɓɛ mikakʉ. Ɨva gʉtʉgʉ kʉwa asɨ abɛ mʉgya-ligubo kakʉ.› ");
INSERT INTO lik_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Kʉwa wa, ava ndɨ lɨgʉndʉ kaɨga kʉ ka abakɨ. Ngbingo yi nɨnɔ a mbɛyɨ ndɨ mino asɨ ɓyɨ aka, abakɨ amɨna, amibo, akwilya kumbu kʉgbɛ. Aga ndɨ mbangʉ katɨlya, apututo ɓipututu. ");
INSERT INTO lik_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Kʉwa wa miki aka na ɨyɨ ɓɛ: ‹Ba, nogyoni ndɨ ɓʉnyɛ ko misa ko Kunzi na ko misa ka kʉ, nakokwononigʉ ɓata ɓɛ ɓɛmakɨ ɓɛ mikakʉ.› ");
INSERT INTO lik_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Luki limoti, abakɨ ʉɓɨkya ɓagya-ligubo kakɨ ɓɛ: ‹Doniku na kutuko nɨkwɔ kwanza kʉgbɛ, mamokisya mikamɨ. Mumokyoni pɛtɛ ka kpɛngbɛ, mamokisyogo ɓɛkpakʉ. ");
INSERT INTO lik_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Doniku na ngɔmbɛ nɨnɔ wanvʉɗʉ-nvʉɗʉ, mamwɔ. Tolyolyini, togwa magyagya. ");
INSERT INTO lik_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","A ɓɛyɔ, mikamɨ nɨnɔ a ndɨ nɨ okwini, a ɓata mbɨya-mbɨya wanʉ muɓisi. A ndɨ nɨ oɓungogini, inisonini ɓata!› Kʉwa wa, ɓapʉnga ndɨ dumo. ");
INSERT INTO lik_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ko ngbingo yi nɨnɔ, pʉta a ndɨ ɨyɨ ko tiko. Nɨyɔ a kʉwa ndɨ kaigoku, adwɛ ɓuwobi na mʉsɛngɨ, ʉkana kʉwa ɓyɛmbɨ nɨɓɔ ogwanana ɓɔ. ");
INSERT INTO lik_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Amaka ɓemoti ka ɓagya-ligubo, amuusa ɓɛ lɨkpʉmʉka tino lɔ a kʉnʉ? ");
INSERT INTO lik_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Asikisya ɓɛ: ‹Mamakʉ iginiku, kinili abakʉ amwilyini ngɔmbɛ yi nɨnɔ wanvʉɗʉ-nvʉɗʉ kyɛ mikakɨ igiku wapʉpʉ.› ");
INSERT INTO lik_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Kʉwa wa pʉta angbʉta ndɨ, akya kogulya ka ndaɓʉ. Abakɨ opupoku ndɨ kaɨtatanaga na ɨyɨ ɓɛ ogulyinɔ ɓaka, ");
INSERT INTO lik_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","luki limoti miki asikisya ndɨ abakɨ ɓɛ: ‹Hʉkana! Ɨmɨ nikaga kaugugubyo ka ɓyanga ɓudingi, nakoɓunagʉ mʉtʉʉ kakʉ gʉtʉgʉ lɨsyɛ limoti aka. Luki limoti wakɛpágʉ ɨmɨ mikya mɛmɨ ambɛ togwi na ɨyɨ magyagya na ɓawai-damɨ. ");
INSERT INTO lik_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Luki limoti yɛkɨ mikakʉ nɨnɔ apʉta ndɨ ɓuyi kakʉ na ɓaɗanda igiku ɨyɨ, wamwɨlya ɨwɛ ngɔmbɛ nɨnɔ wanvʉɗʉ-nvʉɗʉ!› ");
INSERT INTO lik_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Abakɨ asikisya ɓɛ: ‹Mikamɨ, ɨwɛ wikaga pa imoti na ɨmɨ masyɛ masɨ. Mukumbo kamɨ masɨ a makakʉ. ");
INSERT INTO lik_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Luki limoti okwononi mbɛyɨ ɓi kalyisa dumo aka na kogwa magyagya, kyɛ mamakʉ yi nɨmʉna wakamɨna mʉ, a kʉwa ndɨ nɨ okwini, luki limoti iginiku muɓisi. A ndɨ nɨ oɓungogini, luki limoti inisini ɓata!›» ");
INSERT INTO lik_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yeso ʉbɨbɨlya ndɨ ɓaɓɨɓya kakɨ bɨbʉ yi nɨyɨ: «Mʉtʉ wa mukumbo ɓemoti a ndɨ na mʉgya-ligubo nɨnɔ a ndɨ kapita wa mukumbo kakɨ. Ɓambanzʉ ɓodogoku ndɨ kaɓɨkya ɓɛ: ‹Kapita kakʉ akapʉta mukumbo kakʉ payaya.› ");
INSERT INTO lik_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Kʉwa wa mombukwana mukumbo amaka ndɨ mʉgya-ligubo yi nɨnɔ aɓɨkya ɓɛ: ‹Nakaʉkana mongoni manyɛnyɛ kʉgbɛ kʉgʉ kakʉ na nakaɨna ambɛ a ɓɛyɔ. Ɨtangɨlya nɛkɨ makpʉmʉka kamɨ masɨ kyɛ wakikigʉ ɓata kapita kamɨ.› ");
INSERT INTO lik_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Kapita yi nɨnɔ imuusa ɓɛ: ‹Ngama kamɨ kɛgʉ ɓata kapa ɓɛ nikito kapita kakɨ. Nagya sɛ kʉwa ɓʉnɨ? Nakɛgʉ no ngu yɨdɨma ɓotiko. A gɔnɨ suni ka mʉtʉ ɓɛyɔ no mino yɨ kaiko kaɨkʉkʉngya. ");
INSERT INTO lik_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Iyaaa! nibini ɓɛyɔ nagya mino iba ngbingo yi nɨnɔ ɓekpumya ɓanʉ mino ka ligubo, ɓambanzʉ ɓɛtɨlyɨtɔ ka ɓa kʉ kaɓʉ.› ");
INSERT INTO lik_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Kʉwa wa apʉnga ndɨ kaʉmakaga ɓatʉ ɓasɨ yɨkaka-yɨkaka nɨɓɔ ɓa ndɨ na ɓoluɓu ka mombukwana-dakɨ. Amuusa ndɨ mʉtʉ wa mambwa ɓɛ: ‹Luki tino lɔ okwononi ɓɛ mumigisyo mombukwana-damɨ?› ");
INSERT INTO lik_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Asikisya ɓɛ: ‹Ɓangbɔngbɔlɔ ɓa molingo mɨya.› Kapita aɓɨkya ɓɛ: ‹Balʉwa kakʉ wa ɓoluɓu nɨmʉ, wika ɓɨgala, wokpika ɓatɛkɛɓɛ kuɓukumuti.› ");
INSERT INTO lik_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Kumbuso yi aɓɨkya wagɔgɔ ɓɛ: ‹Sɛ kʉwa ɨwɛ, wa na luɓu wa ɨnga?› Asikisya ɓɛ: ‹Ɓasaki ɓaya nganʉ mɨya.› Kapita aɓɨkya ɓɛ: ‹Balʉwa kakʉ nɨmʉ, kpiko ɓatɛkɛɓɛ ɓʉgɨna.› ");
INSERT INTO lik_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Kʉwa wa mombukwana mukumbo abɨba ndɨ luga ka ɓatʉ ɓagɔgɔ kapita yi nɨnɔ wa ɓokoli nɔ ko bulya yimibo kakɨ. Ɓatʉ ɓa ɔɓɨlɨ yi nɨmʉ ɓa na ɓokoli kʉgbɛ luga kaɓʉ kaʉkɨtaga nɨɓɔ ɓa ka ɓʉngbanganya.» ");
INSERT INTO lik_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Nakamʉɓɨkya ambɛ husingyoni ɓambanzʉ no ɓuyi kunu kʉnʉ ka ɔɓɨlɨ. Ngbingo yi nɨnɔ ɓuyi osyo mino, ɓamʉtɨlya ka mugi ma ɓɛnzɛ na ɓɛnzɛ. ");
INSERT INTO lik_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Mʉmbanzʉ kika na ɓungbingbili ka makpʉmʉka makɛkɛkɛ, ika na ɓungbingbili gɔnɨ ka nɨmɔ makpʉkpʉkpʉ. Mʉmbanzʉ kika na ɓokoli ka makpʉmʉka makɛkɛkɛ, ika na ɓokɔli gɔnɨ na kʉɓɔɓɔkʉ ka nɨmɔ makpʉkpʉkpʉ. ");
INSERT INTO lik_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Kika nɛkɨ nɨ makɛgʉ na ɓungbingbili ko bulya mukumbo ma payaya nɨmɔ kʉnʉ ka ɔɓɨlɨ, wanɨ nɔ amʉpá ndɛkɛ ɨzangɨya ya lɨngʉnʉ? ");
INSERT INTO lik_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Makiki na ɓungbingbili ko bulya mukumbo ka mʉtʉ wagɔgɔ, wanɨ nɔ amʉpá nɨmɔ kunu? ");
INSERT INTO lik_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","«Kɛgʉ na mʉtʉ ɓemoti nɨnɔ akwanana kaugugubyo ɓangama ɓaɓa. A ɓɛyɔ, amʉya ɓemoti, apa wagɔgɔ, ikanɨ ɨgʉmya ka ɓemoti, amɨna wagɔgɔ payaya. Makakwananɨgʉ kagugubyo ko ngbinga ɓemoti Kunzi no ɓuyi.» ");
INSERT INTO lik_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Nɨyɔ Ɓafalisayɔ ɓa ndɨ kaʉkana mʉnzɨna mi nɨmɔ ɓɛyɔ, ɓatɨba ndɨ Yeso ɓɨkyaaa, kyɛ ɓapagatʉ ndɨ ɨɓʉ ɓuyi. ");
INSERT INTO lik_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yeso ʉɓɨkya ndɨ ɓɛ: «Mɨgyaga ko misa ka ɓambanzʉ abɛ ɓatʉ ɓongbingbili, luki limoti Kunzi ibatʉ mambɛngɨ kunu masɨ. Kyɛ luki nɨlɔ inisaga na ɨbɨba ko misa ka ɓambanzʉ ikaga luki la payaya ko misa ko Kunzi. ");
INSERT INTO lik_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Kadwɛ ko ngbingo ka Yuani-Mubatizaɨ, a ndɨ ngbingo wa Mʉtʉʉ ka Musa na ɓogyalandʉ. Katʉkya ndɨ ko ngbingo yi nɨnɔ aka nɔ, Mongoni Manza ma Ɓʉngama ko Kunzi iɓikyogoni ndɨ, na mʉtʉ wasɨ ɓemoti-ɓemoti akagya kɛkɛlɛ kogulya mino. ");
INSERT INTO lik_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","A yapʉpʉ lɨsyɛ na ɔɓɨlɨ kolimiko, luki limoti a yapʉpʉ kʉgbɛ mikya liɓiso gʉtʉgʉ mʉkɛɗɛ aka wa Mʉtʉʉ kolimiko. ");
INSERT INTO lik_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Mʉtʉ wasɨ nɨnɔ asikisaga mukakɨ, ava wagɔgɔ, ikaga abɛ kasyɛ na muko ikanɨ mbʉnya ɓɛngɛnɨ, na mʉtʉ nɨnɔ avaga muko nɨ mbʉnyakɨ asikisini, mʉtʉ yi nɨnɔ ogyini ɓɨlya.» ");
INSERT INTO lik_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","«A ndɨ na mʉtʉ wa mukumbo ɓemoti nɨnɔ imokisyaga ndɨ ɓotu ɓayanzanza na ɓaya lɨgabʉ lapʉ. Masyɛ masɨ ikaga ndɨ kogwa magyagya, analyalya ɓɨnza. ");
INSERT INTO lik_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","A ndɨ gɔnɨ na mʉtʉ wa yangya ɓemoti nɨnɔ ina ndɨ ɓɛ Lazalɔ, a ndɨ na ɓapwayɨ nzʉyɨ yasɨ. Ikaga ndɨ ɨyɨ wakanga ka kpɔlɔ wa mupumi ma ndaɓʉ ka mʉtʉ wa mukumbo yi nɨnɔ. ");
INSERT INTO lik_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Lazalɔ ikagatʉ ndɨ na mʉsasa kalya makɔmbɔ nɨmɔ anyʉkaga ndɨ ka mɨza ka alʉkʉ nɨnɔ. Luki limoti ɓɛnva kʉwa ɓɔ ɓodogoku ndɨ kaɗyo ɓapwayɨ. ");
INSERT INTO lik_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Lɨsyɛ limoti, mʉtʉ wa yangya nɨnɔ okwa ndɨ, ɓamalaika ɓaga ndɨ na ɨyɨ ɓuwobi na Abalahamʉ ka Paladiso. Kumbuso yi, mʉtʉ wa mukumbo okwa ndɨ gɔnɨ, ɓalumbo. ");
INSERT INTO lik_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ka ɓabɨlɨ kʉ a ndɨ kalya kumbu kʉgbɛ. Kʉwa wa, ɨkwɛ kʉgʉ, amɨna Abalahamʉ ɓyɨ, sɛ kʉwa Lazalɔ ka kpɔlɔ kakɨ. ");
INSERT INTO lik_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Apamɨkana ɓɛ: ‹Baba Abalahamʉ, ɨmɨnɨlyanɔ ɓaka kumbu, mʉtɨkanɔ ɓaka Lazalɔ kalubo kpɛngbɛ ko liɓo, edudulisi lɨsasʉ, kyɛ nakaigyogyisa kʉgbɛ ko ɓuku ɓi nɨɓa.› ");
INSERT INTO lik_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Luki limoti, Abalahamʉ aɓɨkya ndɨ ɓɛ: ‹Mikamɨ, tamana mbɛyɨ ambɛ winisana ndɨ na lɨngama lidingi ka ɔɓɨlɨ kakʉ nɨ Lazalɔ a sɛ ndɨ ɨyɨ kalya kumbu yidingi. Mbɨya wanʉ, a kʉwa ɨyɨ kogwa magyagya kʉnʉ, wa kʉwa ɨwɛ kaigyogyiso. ");
INSERT INTO lik_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Na gɔnɨ, lɨɓyɛ lodu a luga kusu na iɓunu. Kʉwa wa gɔ wa, nɨɓɔ ɓika kapa katʉkya kʉnʉ kaɨnda kʉ mo mino kʉ ɓakakwananɨgʉ. Na nɨɓɔ ɓika kapa katʉkya kʉ kodoku kʉnʉ, ɓakakwananɨgʉ kazaba ɓɛgɛyɔ.› ");
INSERT INTO lik_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Mʉtʉ wa mukumbo aka na ɨyɨ ɓɛ: ‹Kikiliki baba, ɨtɨkɨlyanɔ ɓaka Lazalɔ kʉ ka lɨvananza kamɨ, ");
INSERT INTO lik_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","kyɛ na na ɓomika mama kuɓukumuti. Ɨndɨ kaʉɓɨkya kambwa aka iba ɓakodonikutɔgʉ ɓata ɨɓʉ kʉnʉ ka pa ya kigyogyiso yi nɨyɨ.› ");
INSERT INTO lik_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Luki limoti, Abalahamʉ amigisya ɓɛ: ‹Ɓamamakʉ ɓa no moɓiso ma mʉtʉʉ ka Musa na ɓogyalandʉ, ɓʉmʉkanɨ asɨ ɨɓʉ aka!› ");
INSERT INTO lik_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Mʉtʉ wa mukumbo nɔ aka na ɨyɨ ɓɛ: ‹Baba Abalahamʉ, kɛgʉ nɨlɔ okwononi nɨlɔ aka lɔ. Luki limoti, kika nɨ mʉmbanzʉ opupiniku ka ɓabɨlɨ ɨnda kʉ ɓo mino, ɓoyikosatʉ ɔɓɨlɨ kaɓʉ.› ");
INSERT INTO lik_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Luki limoti, Abalahamʉ aɓɨkya ɓɛ: ‹Ɓakopo kahʉkana mʉtʉʉ ka Musa na kahʉmʉkana ɓogyalandʉ, ɓakabaɨlyɨgʉ kika gʉtʉgʉ nɨ mʉmbanzʉ opupiniku ka ɓabɨlɨ aka.›» ");
INSERT INTO lik_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yeso ʉɓɨkya ɓaɓɨɓya kakɨ ɓɛ: «Ɓopisi ɓayɨgya ɓʉnyɛ kɛgʉ na nyɨka, luki limoti kumbu ka mʉtʉ yi nɨnɔ ulutaga ɓɛngɛnɨ kagya ɓʉnyɛ! ");
INSERT INTO lik_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Akwanano ɓi ɓɛ ɓakpɨkɨlɨ lɨtalʉ lakpʉ ko singasʉ, ɓaɗɨkɨta ko liɓo lidingi, iba kulutonito ɓatʉ ɓa baya yɨkɛɗɛ katʉkya ko pisi ya ɓungbingbili. ");
INSERT INTO lik_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Wiminyonito ɓɨnza: Kika nɨ mamakʉ ugyilyini ɓʉnyɛ, muyoyisatʉ. Kʉkʉnga mʉpɨlya, wapɨlya. ");
INSERT INTO lik_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Kika nɨ ugyilyini ɓʉnyɛ nganga maɗɨya na ɨka ka lɨsyɛ limoti, odoku kaʉkʉnga mʉpɨlya nganga maɗɨya na ɨka gɔnɨ, wapɨlya.» ");
INSERT INTO lik_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ɓatʉtʉmbwa ɓaɓɨkya ndɨ Mombukwono-dosu ɓɛ: «Tɨmatɨlya baya kusu.» ");
INSERT INTO lik_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Mombukwono-dosu igisya ɓɛ: «Makiko ɓi na baya gʉtʉgʉ kanɨ a yɨkɛɗɛ aka abɛ maya ma agbɛɗɛ-gbɛɗɛ, makwanano ɓi kaɓɨkya sɨbʉkʉsɔ si nɨsɨna ɓɛ: ‹Mukuko, wikunoku ka lɨmbɛngɨ lo liɓo lidingi,› Amʉmʉkanatʉ ɓi.» ");
INSERT INTO lik_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","«Tovini mbɛyɨ abɛ mʉtʉ ɓemoti luga kunu a na mʉgya-ligubo ɓemoti nɨnɔ akpɔgɔ ɓotiko ikanɨ uɓuulyaga ɓambaza ka ɓanyama. Ngbingo yi nɨnɔ mʉgya-ligubo igogoku mino ko tiko, akwananatʉ kaɓɨkya ɓɛ: ‹Doku ɓɨkwa kalyalya?› ");
INSERT INTO lik_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Kalɨ, luki limoti aɓɨkya ɓɛ: ‹Ɨmbambɨlya malɨlɨ, kumbuso yi wigomosyana ɓotu, wodoku kegugubyo ko ngbingo yi nɨnɔ niko mino kalyalya na komwo. Kumbuso yi wakwanana kʉwa gɔnɨ ɨwɛ kalyalya na komwo.› ");
INSERT INTO lik_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Abibisa mʉgya-ligubo kakɨ kyɛ ika nɨ ogyini nɨlɔ akpamyi? ");
INSERT INTO lik_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","A mʉɗɔngɔnɨ abɛ iɓunu gɔnɨ: ngbingo yi nɨnɔ mogyini mino masɨ nɨmɔ Kunzi akamʉkpamya, ɓikyoni ambɛ: ‹Ta ɓagya-ligubo ɓapayaya aka, togyi ligubo nɨlɔ aka lɔ kusu.›» ");
INSERT INTO lik_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ngbingo yi nɨnɔ Yeso a ndɨ mino kaɨnda misa ka Yelusalɛma, aɓyɛ ka mʉlɨlɨ ma iwili ya Samalia na Galilaya. ");
INSERT INTO lik_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Nɨyɔ a kʉwa ndɨ ɓuwobi kosila ka mugi mimoti ɓɛnɛ, ɓakeɓu-keɓu tɛkɛɓɛ ɓakpuɗoku ndɨ. Ɓamaga ndɨ ɓyɨ na ɨyɨ, ");
INSERT INTO lik_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ɓapʉnga kapamɨkanaga ɓɛ: «Muwonisilo, Yeso aaa, kikiliki tikwilyanɔ ɓaka kumbu!» ");
INSERT INTO lik_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yeso ʉmɨna ndɨ, ʉɓɨkya ɓɛ: «Windoni kʉ ɓokumu ɓo mino ɓamʉkpɨmɨ nzʉyɨ.» Ngbingo yi nɨnɔ ɓa ndɨ mino kaɨnda aka nɔ, ɓahʉka. ");
INSERT INTO lik_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Nɨyɔ ɓemoti luga kaɓʉ ɨna ɓɛ oukini, igoku ndɨ ka Yeso anabibiso Kunzi na lɨyʉ lapʉ. ");
INSERT INTO lik_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ogwa ndɨ mokpukpu kambwa kakɨ, amigisya ɨbɨba. A ndɨ Musamalia. ");
INSERT INTO lik_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Kʉwa wa Yeso aka ɓɛ: «Kɛgʉ ɓambanzʉ ɓasɨ tɛkɛɓɛ ɓɔ ɓongumoni? Nɨɓɔ ɓagɔgɔ kʉɓɔmʉ ɓa kʉwa yanɨ? ");
INSERT INTO lik_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Kɛgʉ gʉtʉgʉ na mʉtʉ ɓemoti aka nɨnɔ igiku kamigisilyo Kunzi ɨbɨba, kiki asɨ mʉɓyɨ yi aka nɨmʉ.» ");
INSERT INTO lik_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Kumbuso yi, Yeso aɓɨkya ɓɛ: «Wamaga, waga. Baya kakʉ uhukusini.» ");
INSERT INTO lik_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ɓafalisayɔ ɓamuusa ndɨ Yeso ɓɛ: «Ɓʉngama ko Kunzi odoku pɨyɛ ndɛkɛ ngbingo tino?» Umigisya ɓɛ: «Ɓʉngama ko Kunzi kɛgʉ kodoku abɛ luki la kimibisikono. ");
INSERT INTO lik_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ɓakaɓɨkyɨgʉ ndɛkɛ ɓɛ: ‹Winoni, iɓu nɨɓa!› ikanɨ ‹Iɓu nɨɓɔ kʉʉ!› Kyɛ Ɓʉngama ko Kunzi a luga kunu.» ");
INSERT INTO lik_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Kumbuso yi Yeso ʉɓɨkya ɓaɓɨɓya kakɨ ɓɛ: «Ngbingo wagɔ odokuto ndɛkɛ nɨnɔ miko mina na mʉsasa kamɨna Mika-mʉmbanzʉ gʉtʉgʉ ko ngbinga mʉkɛɗɛ aka, luki limoti nɨ makaminigʉ. ");
INSERT INTO lik_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ɓamʉɓɨkyaga ndɛkɛ ɓɛ: ‹A kʉʉ!› ikanɨ ‹A wanʉ!›, luki limoti makindonitɔgʉ kʉ, makogonitɔgʉ mbangʉ kʉ ɓɛyɔ. ");
INSERT INTO lik_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","A ɓɛyɔ, lɨsyɛ li nɨlɔ Mika-mʉmbanzʉ odoku ndɛkɛ mino, ika ndɛkɛ mʉɗɔngɔnɨ abɛ ngbangbata kangɨnana. Mʉɗɔngɔnɨ ɓɛgɛyɔ ngbangbata angɨnanaga mino katʉkya ka muliɓo ma ɔɓɨlɨ na kadwɛ ka magɔgɔ, ɓambanzʉ ɓamɨna ndɛkɛ Mika-mʉmbanzʉ ɓɛgɛyɔ ka lɨsyɛ nɨlɔ opuponoku ndɛkɛ mino. ");
INSERT INTO lik_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Luki limoti okwononi ɓɛ Mika-mʉmbanzʉ igyogyisi mbɛyɨ kʉgbɛ, ɓatʉ ɓa lɨsyɛ li nɨlɨna ɓambimbo. ");
INSERT INTO lik_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Mʉɗɔngɔnɨ ɓɛgɛyɔ igyonosa ndɨ mino ko ngbingo ka Nʉa, ika ndɛkɛ ɓɛgɛyɔ ngbingo yi nɨnɔ Mika-mʉmbanzʉ odoku ndɛkɛ mino. ");
INSERT INTO lik_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ɓambanzʉ ɓikaga ndɨ kalyalya, ɓanomwo, ɓanavanana kadwɛ ka lɨsyɛ li nɨlɔ Nʉa ogulya ndɨ mino ka ɨngbɔlɔ. Tumo odoku kʉwa ndɨ ɓɨyakpa, ɓambanzʉ ɓasɨ ɓolumwaga ndɨ. ");
INSERT INTO lik_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","A ɓata mʉɗɔngɔnɨ ɓɛgɛyɔ igyonosa ndɨ mino ko ngbingo ka Lɔtɨ. Ɓambanzʉ ɓikaga ndɨ kalyalya, ɓanomwo, ɓanaluwo na ɓanagaba makpʉmʉka, ɓanadɨma ɓotiko na ɓanopiko ɓandaɓʉ. ");
INSERT INTO lik_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Luki limoti lɨsyɛ li nɨlɔ Lɔtɨ opupa ndɨ mino ka Sɔdɔmʉ, Kunzi olukusa ndɨ ɓuku na libu longiɗo-ngiɗo katʉkya kʉgʉ wa lɨsyɛ abɛ mbwayɨ, ulumwisaga ndɨ ɓasɨ. ");
INSERT INTO lik_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ika ndɛkɛ mʉɗɔngɔnɨ ɓɛgɛyɔ ka lɨsyɛ li nɨlɔ Mika-mʉmbanzʉ igoku ndɛkɛ mino. ");
INSERT INTO lik_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ka lɨsyɛ li nɨlɔ, mʉmbanzʉ nɨnɔ ikaga ndɛkɛ kugbondo, kingyigʉ ndɛkɛ ɓata ka ndaɓʉ kakɨsa mukumbo kakɨ. Mʉɗɔngɔnɨ abɛ mʉtʉ yi nɨnɔ ikaga ndɛkɛ ko tiko kakwananɨgʉ ndɛkɛ ɓata kaɨga kava luki kʉ kakɨ. ");
INSERT INTO lik_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Eee, tomomoni sɛ nɨlɔ asilya ndɨ muka Lɔtɨ. ");
INSERT INTO lik_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Mʉtʉ yi nɨnɔ akɨsaga kaɓuulyogo ɔɓɨlɨ kakɨ, aɓungusatʉ ndɛkɛ, luki limoti mʉtʉ yi nɨnɔ aɓungusatʉ ndɛkɛ ɔɓɨlɨ kakɨ, aɓuulyagatʉ ndɛkɛ. ");
INSERT INTO lik_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nakamʉɓɨkya ambɛ no biti yi nɨyɔ, ɓambanzʉ ɓaɓa ɓikaga ndɛkɛ ka kanga imoti: ɓavaga ndɛkɛ ɓemoti, ɓasa wagɔgɔ. ");
INSERT INTO lik_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ɓoko ɓaɓa ɓikaga ndɛkɛ kadwa mʉpʉnga pa imoti: ɓavaga ndɛkɛ ɓemoti, ɓasa wagɔgɔ. ");
INSERT INTO lik_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ɓalʉkʉ ɓaɓa ɓikaga ndɛkɛ kagya ligubo ko tiko: ɓavaga ndɛkɛ ɓemoti, ɓasa wagɔgɔ.» ");
INSERT INTO lik_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ɓaɓɨɓya ɓamuusa kʉwa ndɨ Yeso ɓɛ: «Mombukwono-dosu, makpʉmʉka mi nɨmɔ igyonosa ndɛkɛ yanɨ?» Yeso usikisya ɓɛ: «Kʉ manda ma nyama ikago mino, ɓombu nɨɓɔ ɓalyaga makɔlɔ ɓamʉmʉkanaga wa gɔ wa.» ");
INSERT INTO lik_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Kumbuso yi, Yeso ʉtʉlya kʉwa ndɨ ɓaɓɨɓya lizuni nɨlɨ kauwonisilo ɓɛ ɓakwanana kalʉmba masyɛ masɨ nɨ ɓakɛgʉ kadɨkaga. ");
INSERT INTO lik_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ʉɓɨkya ɓɛ: «Kʉsɔ wa gʉɗʉ ɓemoti ɓɛnɛ, a ndɨ na zozi ɓemoti nɨnɔ kaɓangagɨgʉ ndɨ Kunzi, anʉmɨna ɓatʉ ɓasɨ payaya aka. ");
INSERT INTO lik_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Kʉsɔ wa gʉɗʉ yi nɨnɔ gɔnɨ aka nɔ, a ndɨ na woko ɓemoti muko yi nɨnɔ odogoku ndɨ ɓongbinga ɓasɨ kaɓɨkya zozi nɔ ɓɛ: ‹Tɨkʉlya ngbanga kusu na mumuyoniso kamɨ.› ");
INSERT INTO lik_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Kʉsɔ wa masyɛ makpʉ, zozi a ndɨ asɨ kakya aka. Luki limoti ka muliɓo aɓɨkya kʉsɔ kakɨ ɓɛ: ‹A ɓɛyɔ, nakaɓangagɨgʉ Kunzi, na nʉmɨnaga ɓatʉ ɓasɨ payaya aka, ");
INSERT INTO lik_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","luki limoti, woko yi nɨmʉna edomisini. Kinili okwononi ɓɛ nakʉlyɨ ngbanga kakɨ. Kumbuso yi kikigʉ ɓata kodoku ɓongbinga ɓasɨ kegbomisa mʉ.›» ");
INSERT INTO lik_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Kʉwa wa, Mombukwono-dosu omotiloku ɓɛ: «Hukononi ɓɨnza lɨkpʉmʉka li nɨlɔ zozi wanyɛ nɔ akaɓɨkya! ");
INSERT INTO lik_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","A ɓɛyɔ, Kunzi kakwananɨgʉ kaʉkʉlya ɓatʉ kakɨ nɨɓɔ ʉpʉnaga ndɨ ngbanga wanza, ngbingo yi nɨnɔ ɓo mino kaɨgama na ɨyɨ biti na lɨsyɛ? Kusingyigʉ ɓɨgala? ");
INSERT INTO lik_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nakamʉɓɨkya ambɛ: ʉkʉlyatʉ ngbanga kaɓʉ ɓɨkwa. Luki limoti wa Mika-mʉmbanzʉ odoku ndɛkɛ mino kʉnʉ ka lɨtɔmbʉ ʉtakanyatʉ ndɛkɛ ɓatʉ ɓa baya?» ");
INSERT INTO lik_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yeso atwa ndɨ gɔnɨ lizuni nɨlɨna ko bulya ka ɓambanzʉ ɓemoti-ɓemoti nɨɓɔ ɓɨmɨnaga ndɨ ɓingbingbili ko misa ko Kunzi na ɓanʉmɨna ɓatʉ ɓagɔgɔ asɨ payaya aka. Aɓɨkya ɓɛ: ");
INSERT INTO lik_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«A ndɨ lɨsyɛ limoti, ɓalʉkʉ ɓaɓa ɓaɗaka ndɨ kalʉmba ka Ndaɓʉ ko Kunzi, ɓemoti a ndɨ Mufalisayɔ, wagɔgɔ ndɔmbɛ wa manzanza. ");
INSERT INTO lik_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Mufalisayɔ, amaga, apʉnga kʉwa ndɨ kaɨlʉmbɨlya ɓɛ: ‹Kunzi o, nakaubibisa kyɛ na kɛgʉ ɨmɨ abɛ ɓatʉ ɓagɔgɔ. Ɓa ɓatʉ ɓo kuɓakʉ, ɓatʉ ɓʉsyɛ na ɓoko ikanɨ ɓambʉnya ɓɛngɛnɨ, na kɛgʉ ɨmɨ abɛ ndɔmbɛ wa manzanza yi nɨmʉ. ");
INSERT INTO lik_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Noginyagatʉ malɨlɨ ko ngbingo nganga yɨɓa ka pɔsɔ, napágatʉ liɗu limoti la tɛkɛɓɛ la mukumbo kamɨ masɨ.› ");
INSERT INTO lik_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Luki limoti, ndɔmbɛ amaga ndɨ ɨyɨ ɓyɨ, kakwanana gʉtʉgʉ ndɨ kaɨkwɛ kʉgʉ wa lɨsyɛ, luki limoti iyipa ndɨ ikubasʉ, aɓɨkya ɓɛ: ‹Kunzi o, ɨpɨlyanɔ ɓaka kyɛ na ɨmɨ mʉtʉ wanyɛ.›» ");
INSERT INTO lik_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yeso omotiloku ɓɛ: «Nakamʉɓɨkya lɨngʉnʉ ambɛ, alʉkʉ nɔ ɨga ndɨ kʉ kakɨ nɨ Kunzi aitisini mʉtʉ wongbingbili kakɨtaga Mufalisayɔ. Ka lɨngʉnʉ, mʉtʉ wasɨ nɨnɔ ɨbɨnɨkaga, Kunzi asisagatʉ. Na nɨnɔ isisogo, Kunzi abɨnɨkagatʉ.» ");
INSERT INTO lik_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ɓambanzʉ ɓadulyoku ndɨ Yeso na ɓomiki ɓawɛsɛ ɓɛ ubisilyi maɓɔkʉ. Nɨyɔ ɓaɓɨɓya ɓɨna ɓɛyɔ, ɓapʉnga ndɨ kaʉnyakɨlya ɓatʉ ɓi nɨɓɔ. ");
INSERT INTO lik_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Luki limoti Yeso ʉmaka ɓɛ ɓakpuɗiku na ɓomiki, aɓɨkya ɓɛ: «Husoni ɓomiki ɓoduku kʉnʉ no mino! Makupokyonitɔgʉ, kyɛ Ɓʉngama ko Kunzi a ko bulya ka ɓatʉ ɓi nɨɓɔ ɓa abɛ ɨɓʉ. ");
INSERT INTO lik_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","A lɨngʉnʉ, nakamʉɓɨkya ambɛ, nɨnɔ kɛgʉ kaɓɨnɨkyana Ɓʉngama ko Kunzi mʉɗɔngɔnɨ abɛ miki, kakwananɨgʉ ndɛkɛ kogulya mino.» ");
INSERT INTO lik_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ngama ɓemoti ka Ɓayuda amuusa ndɨ Yeso ɓɛ: «Muwonisilo wanza, nakwanana pɨyɛ kagya ɓʉnɨ kainisono na ɔɓɨlɨ wa ɓɛnzɛ na ɓɛnzɛ?» ");
INSERT INTO lik_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yeso aɓɨkya ɓɛ: «Ko bulya ɨkɨ yɔ wo mino kɛmaka ɓɛ mʉtʉ wanza? Mʉmbanzʉ gʉtʉgʉ ɓemoti aka kɛgʉ wanza kiki nɨ Kunzi aka mʉkaka. ");
INSERT INTO lik_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Wibagatʉ mʉtʉʉ: ‹wakogyonitɔ ɓɨlya, wakamwonitɔgʉ mʉmbanzʉ, wakiɓonitɔgʉ, wakaɓukulyogonitɔgʉ mʉmbanzʉ lɨkpʉmʉka, mʉɓanga abakʉ na amakʉ.›» ");
INSERT INTO lik_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Alʉkʉ nɔ asikisya ɓɛ: «Nagyagatʉ mʉtʉʉ mi nɨmɔ masɨ katʉkya ndɨ ka limiki.» ");
INSERT INTO lik_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Nɨyɔ Yeso ʉkana ɓɛyɔ, aɓɨkya ɓɛ: «Utigolyi ɓata luki limoti: Gaba mukumba kakʉ masɨ, hʉlʉpya ɓatʉ ɓa yangya ɓuyi ɓi, wika kʉwa na lɨngama kʉgʉ wa lɨsyɛ. Kumbuso yi doku, wɛɓyoku.» ");
INSERT INTO lik_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Luki limoti, ngbingo yi nɨnɔ alʉkʉ nɔ ʉkana lɨkpʉmʉka lɔ ɓɛyɔ, alya ndɨ kumbu, kyɛ a ndɨ na mukumbo makpʉ kʉgbɛ. ");
INSERT INTO lik_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Nɨyɔ Yeso ɨna ɓɛ alʉkʉ nɔ a ndɨ no kumbu, oɓikyoku ɓɛ: «A yapʉpʉ ka ɓatʉ ɓa mukumbo kogulya ka Ɓʉngama ko Kunzi! ");
INSERT INTO lik_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","A ɓipoli kʉgbɛ ngamia kazabana ka ngala ya mʉsaɗa kakɨtaga mʉtʉ wa mukumbo kogulya ka Ɓʉngama ko Kunzi.» ");
INSERT INTO lik_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ɓatʉ nɨɓɔ ɓamʉkana, ɓaɓɨkya ɓɛ: «Wanɨ sɛ kʉwa nɔ akwanana kainisono na muhukuso?» ");
INSERT INTO lik_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yeso osikisya ɓɛ: «Kɛgʉ na lɨkpʉmʉka gʉtʉgʉ limoti aka nɨlɔ agyagya Kunzi.» ");
INSERT INTO lik_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Kʉwa wa Pɛtɛlɛ aɓɨkya ɓɛ: «Iɓusu, tosoni ndɨ masɨ nɨmɔ ta ndɨ nomu, tapʉnga kaʉɓɨɓya.» ");
INSERT INTO lik_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yeso ʉɓɨkya ɓɛ: «A lɨngʉnʉ, nakamʉɓɨkya ambɛ, kika nɨ mʉmbanzʉ osini ndaɓʉ kakɨ, ikanɨ amakɨ, ɓamamakɨ, ɓaɓʉkʉta kakɨ, ɓomikakɨ, ko bulya Ɓʉngama ko Kunzi, ");
INSERT INTO lik_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","mʉtʉ yi nɨnɔ inisono na ɓʉngama ɓakpʉ ka masyɛ mi nɨma, na ko ngbingo yi nɨnɔ akodoku, inisana ndɛkɛ na ɔɓɨlɨ wa ɓɛnzɛ na ɓɛnzɛ.» ");
INSERT INTO lik_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yeso akɨɗa ndɨ na ɓaɓɨɓya tɛkɛɓɛ na ɓaɓa, ʉɓɨkya ɓɛ: «Hukononi, takaɨnda ka Yelusalɛma, masɨ nɨmɔ ɓogyalandʉ ɓokpika ndɨ ko bulya ko Mika-mʉmbanzʉ igyonosa ɓanʉ kʉ. ");
INSERT INTO lik_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","A ɓɛyɔ, ɓasʉta ɓanʉ ka maɓɔkʉ ka ɓatʉ nɨɓɔ ɓakamibigʉ Kunzi. Ɓatʉ ɓi nɨɓɔ ɓamɨna payaya, ɓatʉmbwa, ɓaɓakyɨlya ɓotikito. ");
INSERT INTO lik_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ɓatɨna pimbo, ka muliɓo mi ɓamwɔ. Kumbusa wa masyɛ masaa, opupoku ka mbʉkʉ.» ");
INSERT INTO lik_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Luki limoti ɓaɓɨɓya ɓakotombisyagʉ ndɨ luki kyɛ isi ya mʉnzɨna nɨmɔ a ndɨ na ɨɓʉ makɨsʉma. Ɓakɛgʉ ndɨ kaiba ɓɛ Yeso akapa kaɓɨkya lɨkpʉmʉka tino. ");
INSERT INTO lik_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ngbingo yi nɨnɔ Yeso a kʉwa ndɨ mino ɓuwobi kadwɛ ka Yeliko, mʉtʉ ɓemoti wo koloɓu ya mamɔmɔ a ndɨ wakiko ka kpɔlɔ-kpɔlɔ wo pisi nɨ anɨkʉkʉngya. ");
INSERT INTO lik_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ʉkana ndɨ mungilito ma ambaza ka ɓambanzʉ nɨ anakɨtaga, uusa ndɨ ɓɛ a pɨyɛ ɓʉnɨ. ");
INSERT INTO lik_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ɓaɓɨkya ndɨ ɓɛ Yeso mʉtʉ wa Nazalɛtɨ nɔ akakɨtaga. ");
INSERT INTO lik_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Kʉwa wa apʉnga ndɨ kapamɨkanaga, anaɓɨkya ɓɛ: «Yeso, Mika ngama Daudi, ikwilyanɔ ɓaka kumbu!» ");
INSERT INTO lik_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ɓatʉ nɨɓɔ ɓa ndɨ kambwa kakɨ ɓanyakɨlya ndɨ ɓɛ adakɨ. Luki limoti idukulogo kapamɨkana kʉwa kʉgbɛ: «Mika ngama Daudi, ikwilyanɔ ɓaka kumbu!» ");
INSERT INTO lik_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yeso amaga, aɓɨkya ndɨ ɓɛ ɓoduku na ɨyɨ. Ngbingo yi nɨnɔ mʉtʉ yi akpuɗoku mino, Yeso amuusa ɓɛ: ");
INSERT INTO lik_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«Wakapa ɓɛ nʉgyɨlyɨ ɨkɨ?» Asikisya ɓɛ: «Mombukwono-dosu, nakapa ambɛ napʉngɨ ɓata kaɨna.» ");
INSERT INTO lik_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yeso aɓɨkya ɓɛ: «A ɓɨnza, miso ʉkʉlɨkanɨ! Baya kakʉ uhukusini.» ");
INSERT INTO lik_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ko ngbingo yi nɨnɔ aka nɔ, miso akʉlɨkana ndɨ, apʉnga kaɓɨɓya Yeso nɨ anabibiso Kunzi. Nɨyɔ ambaza wasɨ ɨna lɨkpʉmʉka nɨlɔ, apʉnga ndɨ gɔnɨ kabibiso Kunzi. ");
INSERT INTO lik_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Nɨyɔ Yeso ogulya ndɨ ka Yeliko, akɨtanaga luga wa gʉɗʉ yi nɨnɔ. ");
INSERT INTO lik_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Kʉ ɓɛyɔ, a ndɨ na alʉkʉ ɓemoti nɨnɔ ina ndɨ ɓɛ Zakayɔ. A ndɨ ngama ka ɓandɔmbɛ ɓa manzanza na mʉtʉ wa lɨngama. ");
INSERT INTO lik_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","A ndɨ kakɨsa kamɨna Yeso, luki limoti yɛkɨ a ndɨ mukuɗu kakwananagʉ ndɨ kamɨna yi ko bulya ambaza ka ɓambanzʉ. ");
INSERT INTO lik_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Aga kʉwa ndɨ mbangʉ kambwa, aɗaka ka sɨbʉkʉsɔ simoti ɓɛ kyɛ amɨnɨ Yeso nɨnɔ a ndɨ kokitogoku wa. ");
INSERT INTO lik_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Nɨyɔ Yeso osila ka pa nɨyɔ, ɨkwɛ kʉgʉ, ɨyɨ aka ɓɛ: «Zakayɔ syoku ɓɨgala! Kyɛ na mubiko kakʉ na lɨsyɛ li nɨlɨ.» ");
INSERT INTO lik_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zakayɔ osyoku ndɨ ɓɨgala, atɨlya ndɨ Yeso na magyagya. ");
INSERT INTO lik_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Nɨyɔ ɓatʉ ɓasɨ ɓɨna ɓɛyɔ, ɓapʉnga ndɨ kaɨnzɨnzɨnya ɓanaɓɨkya ɓɛ: «Alʉkʉ mʉna oga kasyɛ ka mʉtʉ wanyɛ!» ");
INSERT INTO lik_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Luki limoti Zakayɔ amaga ndɨ, aɓɨkya Mombukwono-dosu, ɓɛ: «Muwonisilo, hʉkana: nakagbanana mukumbo kamɨ lugo, nʉpá ɓatʉ ɓa yangya liɗu limoti, na nakavaga ndɨ ɓuyi ka mʉmbanzʉ ka ɓokoli, namigisya kʉwa nganga yɨkwanganya.» ");
INSERT INTO lik_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yeso aka ɓɛ: «Na lɨsyɛ nɨlɨ, muhukuso ogulyini ka ndaɓʉ yi nɨyɨ, kyɛ nɨmʉna a ɨyɨ ka lɨvananza ka Abalahamʉ gɔnɨ. ");
INSERT INTO lik_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ka lɨngʉnʉ, Mika-mʉmbanzʉ odoku ndɨ kaʉkɨsa na kauhukuso nɨɓɔ ɓa ndɨ nɨ ɓoɓungogini.» ");
INSERT INTO lik_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ngbingo yi nɨnɔ ɓambanzʉ ɓʉkana ndɨ mino lɨkpʉmʉka nɨlɔ, Yeso omotiloku lizuni limoti kyɛ a kʉwa ndɨ ɓuwobi na Yelusalɛma. Ɓambanzʉ ɓa ndɨ kasɨma ɓɛ Ɓʉngama ko Kunzi obiko. ");
INSERT INTO lik_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Oɓikyoku kʉwa ndɨ ɓɛ: «Mʉtʉ ɓemoti ka lɨvananza la ɓʉngama aga ndɨ ka mugi ma ɓyɨ kolyoku ɓʉngama, kumbuso yi, igoku kalya ɓʉngama kʉ kaɓʉ. ");
INSERT INTO lik_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Kambwa wa lɨgʉndʉ, ʉmaka ndɨ ɓambanzʉ tɛkɛɓɛ luga ka ɓagya-ligubo kakɨ, ʉpága ndɨ yɨkaka-yɨkaka likuta limoti la ɔlɔ, ʉɓɨkya ɓɛ: ‹Tundisoni ɔlɔ nɨmʉ kadwɛ kʉ kwa kʉ nigoku ndɛkɛ mino.› ");
INSERT INTO lik_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Luki limoti ɓatʉ ɓa mugi kakɨ ɓakapagɨgʉ ndɨ. Ɓʉtɨka kʉwa ndɨ ɓambanzʉ no mongoni kumbusa kakɨ kaɓikyoku ɓɛ: ‹Takɛgʉ kabaɨlya ɓɛ alʉkʉ nɔ alyɨtɔ ɓʉngama ku kusu.› ");
INSERT INTO lik_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Nɨyɔ ɓapá ɓʉngama, igoku. Utikisya ɓagya-ligubo nɨɓɔ ʉpá ndɨ ɔlɔ ɓɛ ibi kʉwa ɓɛyɔ ɓatundisa ndɨ mino. ");
INSERT INTO lik_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Nɨnɔ wa mambwa odoku ndɨ, aɓɨkya ɓɛ: ‹Mombukwono-dosu, kʉgʉ wa likuta limoti la ɔlɔ nɨlɔ wɛpá ndɨ, ninisoni ɓata na makuta magɔgɔ tɛkɛɓɛ.› ");
INSERT INTO lik_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ngama aka ɓɛ: ‹A ɓɨnza! Wa mʉgya-ligubo wanza. Yɛkɨ wo ɓi na ɓungbingbili ko luki lɨkɛdɛ, nubisa ɓanʉ ngama kaʉnda ɓagʉɗʉ tɛkɛɓɛ.› ");
INSERT INTO lik_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Mʉgya-ligubo wa maɓa odoku ndɨ, aɓɨkya ɓɛ: ‹Mombukwono-dosu, kʉgʉ wa likuta limoti la ɔlɔ nɨlɔ wɛpá ndɨ, ninisoni ɓata na makuta magɔgɔ kuɓukumuti.› ");
INSERT INTO lik_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ngama aka ɓɛ: ‹Ɨwɛ, nubisini ngama kaʉnda ɓagʉɗʉ kuɓukumuti.› ");
INSERT INTO lik_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Mʉgya-ligubo wa masaa odoku, aɓɨkya ɓɛ: ‹Yɛ ba, likuta la ɔlɔ kakʉ nɨlɔ wɛpá ndɨ nɨlɨ. Noɓuulyaga ndɨ ɓɨnza, yɨkanda ɓingbufu na ɨnzanza ya kutuko. ");
INSERT INTO lik_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","A ɓɛyɔ, na ndɨ kaʉɓanga, kyɛ wa mʉtʉ mʉɗɨya. Wapʉnaga makpʉmʉka nɨmɔ wakobisogigʉ, wanobuulya masɔlɔ nɨmɔ wakakʉnagɨgʉ.› ");
INSERT INTO lik_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ngama aɓikyoku ɓɛ: ‹Wa mʉgya-ligubo wanyɛ! Nakaʉkʉlya ngbanga kaɓyɛnɛnɛ na mʉnzɨna kakʉ. Wibagatʉ ndɨ ɓɛ na mʉtʉ mʉɗɨya, ɓɛ napʉnaga makpʉmʉka nɨmɔ nakobisogigʉ, nobuulyaga masɔlɔ nɨmɔ nakakʉnagɨgʉ. ");
INSERT INTO lik_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Yɛkɨ a ɓɛyɔ, ko bulya ɨkɨ yɔ wakobisagʉ ndɨ mino ɓuyi kamɨ ka baki? Iba wa nigiku mino, nonyuku nɨ itundini.› ");
INSERT INTO lik_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Kumbuso yi ngama ʉɓɨkya ɓatʉ nɨɓɔ ɓa ndɨ wa ɓɛ: ‹Mukupyoni likuta la ɔlɔ li nɨlɔ, mapá mʉtʉ yi nɨnɔ a nomu tɛkɛɓɛ.› ");
INSERT INTO lik_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ɓaɓɨkya ɓɛ: ‹Ngama, a kʉwa ɨyɨ na makuta tɛkɛɓɛ!› ");
INSERT INTO lik_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Usikisya ɓɛ: ‹Nakamʉɓɨkya ambɛ, kika nɨ mʉmbanzʉ a no luki ɓamatɨlyatʉ ɓata. Luki limoti, mʉtʉ yi nɨnɔ kɛgʉ no luki ɓakʉpya gʉtʉgʉ luki lɨkɛɗɛ aka nɨlɔ akwanano ɓi kaiko nolu. ");
INSERT INTO lik_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Doniku sɛ kʉwa na ɓomuyoniso kamɨ, nɨɓɔ ɓakɛgʉ ndɨ kapa ɓɛ niki ngama kaɓʉ, mʉkɔ ɓingo kambwa kamɨ wa.›» ");
INSERT INTO lik_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Nɨyɔ Yeso ama ndɨ kaɓɨkya lɨkpʉmʉka nɨlɔ, aga ka Yelusalɛma. A ndɨ ɨyɨ kambwa nɨ ambaza anaɓɨɓya kumbuso. ");
INSERT INTO lik_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Wa a kʉwa ndɨ mino ɓuwobi kadwɛ ka Bɛtɛfagɨ na Betania, ɓuwobi na ngʉpa nɨyɔ ɓalɨkyaga ndɨ ɓɛ Ngʉpa ya Mizeituni, ʉtɨka ɓaɓɨɓya ɓaɓa luga ka ɓaɓɨɓya kakɨ kambwa. ");
INSERT INTO lik_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Ʉɓɨkya ɓɛ: «Windoni ka mugi nɨmana kambwa ma. Ngbingo yi nɨnɔ mosilo mino kʉ, matakanya mikya punda mʉkandɨla nɨnɔ mʉmbanzʉ gʉtʉgʉ ɓemoti aka kanoɗokigʉ mino. Mukuloniku, modoku na ɨyɨ kʉnʉ. ");
INSERT INTO lik_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Mʉmbanzʉ kamumuusa ɓɛ: ‹Makakʉla ko bulya ɨkɨ?› Maɓɨkya ɓɛ: ‹Mombukwono-dosu a no nzoyi yi.›» ");
INSERT INTO lik_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ɓaɓɨɓya ɓaɓa nɨɓɔ ɓaga kʉwa ndɨ, ɓatakanya punda mʉɗɔngɔnɨ ɓɛyɔ aka yɔ Yeso ʉɓɨkya ndɨ mino. ");
INSERT INTO lik_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Wa ɓa ndɨ mino kakʉla mikya punda nɔ, ɓamombukwana-dakɨ ɓumuusa ɓɛ: «Ko bulya ɨkɨ yɔ ma mino kakʉla?» ");
INSERT INTO lik_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ɓusikisya ndɨ ɓɛ: «Mombukwono-dosu a no nzoyi yi.» ");
INSERT INTO lik_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Kumbuso yi ɓadulyoku ndɨ Yeso no mikya punda nɔ. Ɓolosa ndɨ ɓotu kaɓʉ kʉgʉ wa nyama, ɓaɗokiso mino Yeso. ");
INSERT INTO lik_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ngbingo yi nɨnɔ a ndɨ mino kaisisilo miso ka Yelusalɛma, ɓambanzʉ ɓolosaga ndɨ ɓotu kaɓʉ ko pisi. ");
INSERT INTO lik_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Wa a kʉwa ndɨ mino ɓuwobi kosila ka mukpulu-kpulu ma Ngʉpa ya Mizeituni, ambaza wasɨ ka ɓaɓɨɓya otuma ndɨ na magyagya ɓɨɗɛ. Apʉnga ndɨ kabibisa Kunzi na lɨyʉ lapʉ ko bulya makpʉmʉka mʉmbanga-mbanga masɨ nɨmɔ ɓɨna ndɨ mɔ. ");
INSERT INTO lik_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ɓa ndɨ kaɓɨkya ɓɛ: «Kunzi aɗukulyi ngama nɨnɔ akodoku ko lina ka Mombukwono-dosu ɓʉɓʉnga! Kunzi apɨ́ mazɨyɔ kʉgʉ wa lɨsyɛ na avɨ ɨbɨba kʉgʉ wa lɨsyɛ kʉgbɛ!» ");
INSERT INTO lik_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Luki limoti, Ɓafalisayɔ ɓemoti-ɓemoti nɨɓɔ ɓa ndɨ kʉsɔ wa ambaza ɓaɓɨkya Yeso ɓɛ: «Muwonisilo, hʉɓɨkya ɓaɓɨɓya kakʉ ambɛ ɓadakɨ.» ");
INSERT INTO lik_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yeso usikisya ndɨ ɓɛ: «Nakamʉɓɨkya ambɛ, ɓakadaka, matamʉ kʉwa mɔ apamɨkanaga!» ");
INSERT INTO lik_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ngbingo yi nɨnɔ Yeso a kʉwa ndɨ mino ɓuwobi na Yelusalɛma, amɨna, apʉnga kagama. ");
INSERT INTO lik_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Anaɓɨkya ɓɛ: «Heee ɓe, Yelusalɛma, kiko ɓi nɨ wa gɔnɨ ɨwɛ kaiba na lɨsyɛ nɨlɨna ɓɛ luki tino lɔ akwanano ɓi kaʉpá mazɨyɔ! Luki limoti mbɨya wanʉ, luki li nɨlɔ a lakɨsʉma ko misa kakʉ, wakakwananɨgʉ kaɨna! ");
INSERT INTO lik_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","A ɓɛyɔ, lɨsyɛ limoti odokuto ndɛkɛ nɨlɔ ɓomuyoniso kakʉ ɓukungula ndɛkɛ mino ɓikululu, ɓʉmbɨmbɨta mutili masɨ ɓɨmbɨtɨtɨ. ");
INSERT INTO lik_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ɓʉpanza ndɛkɛ ɓɨgbatata, ɓulumwisaga ɓatʉ kakʉ. Ɓakasɨgʉ ndɛkɛ gʉtʉgʉ lɨtalʉ limoti aka lakibiso kʉgʉ wa lagɔgɔ, kyɛ wakibagʉ ndɨ ngbingo yi nɨnɔ Kunzi udulyoku ndɨ mino isingo.» ");
INSERT INTO lik_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yeso ogulya kʉwa ndɨ ka Ndaɓʉ ko Kunzi, apʉnga kaukpumyo ɓambula. ");
INSERT INTO lik_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ʉɓɨkya ɓɛ: «Ikpikaga ka Moɓiso Motu ɓɛ: ‹Ndaɓʉ kamɨ ika ndɛkɛ ndaɓʉ ya malʉmba.› Luki limoti, iɓunu moitisini kʉwa pa ya kɨsʉma ka ɓatʉ ɓo kuɓakʉ!» ");
INSERT INTO lik_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Masyɛ masɨ Yeso apága ndɨ mʉtɨwɨ ka Ndaɓʉ ko Kunzi. Ɓokumu-kumu, ɓowonisilo ɓa mʉtʉʉ na ɓangama ɓakɨsaga ndɨ ɓɛ ɓamwɔ sɛ pɨyɛ no pisi tino. ");
INSERT INTO lik_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Luki limoti ɓakɛgʉ ndɨ kaiba ɓɛ ɓamwɔ lɨkɨ, kyɛ ɓambanzʉ ɓagɔgɔ ɓasɨ ɓamʉkanaga ndɨ na mʉsasa kʉgbɛ. ");
INSERT INTO lik_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Lɨsyɛ limoti, Yeso a ndɨ kapá mʉtɨwɨ na kaʉɓɨkyaga ɓambanzʉ Mongoni Manza ka Ndaɓʉ ko Kunzi. Ɓokumu-kumu na ɓowonisilo ɓa mʉtʉʉ ɓopuponoku kʉwa ndɨ pa imoti na ɓambɔkʉ-mbɔkʉ, ");
INSERT INTO lik_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ɓamuusa ɓɛ: «Tɨɓɨkya mbɛyɨ ambɛ wakagya makpʉmʉka mi nɨmana no ngu tino? Wanɨ nɔ ʉpá ndɨ ngu yi nɨyɔ?» ");
INSERT INTO lik_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yeso usikisya ndɨ ɓɛ: «Na mbɛyɨ gɔnɨ ɨmɨ kamumuuso lɨkpʉmʉka limoti aka. Iɓikyoni ambɛ: ");
INSERT INTO lik_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Iɓatiso ka Yuani apʉnya ndɨ kʉgʉ wa lɨsyɛ ikanɨ ka ɓambanzʉ?» ");
INSERT INTO lik_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Luki limoti ɓapʉnga ndɨ kaɨnzɨnzɨnya luga kaɓʉ, ɓanaɓɨkya ɓɛ: «Takosikisya ɓɛ: ‹Apʉnya kʉgʉ wa lɨsyɛ›, atimuusatʉ ɓɛ: ‹Ko bulya ɨkɨ yɔ makaɓɨnɨkyanagʉ ndɨ lɨkpʉmʉka kakɨ?› ");
INSERT INTO lik_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Luki limoti, takosikisya ambɛ: ‹Ka ɓambanzʉ›, ɓatʉ ɓasɨ ɓatɨmakatʉ na matamʉ! Kyɛ ɓibagatʉ ɓɛ Yuani a ndɨ mugyalandʉ.» ");
INSERT INTO lik_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Kʉwa wa, ɓasikisya ndɨ Yeso ɓɛ: «Takibigʉ ambɛ apʉnya yanɨ.» ");
INSERT INTO lik_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yeso uɓikyoku kʉwa ɓɛ: «Gʉtʉgʉ ɨmɨ aka, nakamʉtʉmbʉlyɨgʉ gɔnɨ ikanɨ nagyaga makpʉmʉka mi nɨmɔ no ngu ka wanɨ.» ");
INSERT INTO lik_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Kumbuso yi, Yeso ʉtʉlya ndɨ ɓambanzʉ lizuni li nɨlɨ: «Alʉkʉ ɓemoti akʉna ndɨ tiko ya muzabibu. Kʉwa wa ʉkanana ndɨ na ɓagya-ligubo koɓuulyogo tiko yi nɨyɔ. Aga kʉwa ndɨ ka mugi ma ɓyɨ kʉ osyosyoku ndɨ mino ɓinyeku-nyeku. ");
INSERT INTO lik_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Nɨyɔ ngbinga mubuulyo masɔlɔ ɨtʉlyana, atikoku ndɨ mʉgya-ligubo ɓemoti kʉ ka ɓagya-ligubo ɓi nɨɓɔ ɓʉkanana ndɨ na ɨɓʉ ɓɛ ɓapíku kʉwa masɔlɔ mi ma kakɨ. Luki limoti, ɓatʉ ɓi nɨɓɔ ɓalya ndɨ alʉkʉ nɔ na bʉma ɓɨsʉsʉsʉ, ɓamigisoku maɓɔkʉ papuyi. ");
INSERT INTO lik_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Mombukwono tiko atikoku ɓata ndɨ mʉgya-ligubo wagɔgɔ, luki limoti ɓagya-ligubo ɓi nɨɓɔ ɓabʉma ndɨ ɨyɨ ɓɛgɛyɔ, ɓaɓuɓisa ndɨ ɓitu na mosikoni, ɓamigisoku ndɨ gɔnɨ maɓɔkʉ papuyi. ");
INSERT INTO lik_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Atɨka ndɨ ɓata mʉgya-ligubo wa masaa. Ɓakɔgɔ ndɨ ɓapwayɨ, ɓakpumyo. ");
INSERT INTO lik_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Mombukwono tiko aɓɨkya kʉwa ɓɛ: ‹Nagya sɛ kʉwa ɓʉnɨ? Nakatɨka mikamɨ nɨnɔ mʉpaka. A abɛ ɓakwananatʉ kaɓanga.› ");
INSERT INTO lik_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Luki limoti nɨyɔ ɓagya-ligubo ɓo tiko yi nɨyɔ ɓamɨna kodoku, ɓaɓɨkyana luga kaɓʉ ɓɛ: ‹Ɨyɨ nɔ mombukwana lisimo li nɨlɨ. Tamwini, kyɛ lisimo iki kʉwa lo kusu.› ");
INSERT INTO lik_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ɓapupisa kʉwa ndɨ no gilito kunzi wo tiko, ɓamwɔ.» Kumbuso yi, Yeso umuusa ɓɛ: «Ɛɛɛ, mombukwono tiko yi nɨyɔ ʉgya sɛ kʉwa ndɛkɛ ɓʉnɨ? ");
INSERT INTO lik_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Odoku ndɛkɛ, ulumwisogo ɓagya-ligubo ɓi nɨɓɔ, ʉpá kʉwa ɓagya-ligubo ɓagɔgɔ tiko yi nɨyɔ.» Nɨyɔ ɓambanzʉ ɓʉkana mʉnzɨna mi nɨmɔ, ɓaɓɨkya ɓɛ: «Kɛgʉ ɓɛyɔ, kɨgyananɨgʉ ndɛkɛ gʉtʉgʉ iki yi aka!» ");
INSERT INTO lik_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Luki limoti Yeso ʉnda ɓizumuuu, ʉɓɨkya ɓɛ: «Moɓiso ko Kunzi akaɓɨkya ɓɛ: ‹Lɨtalʉ nɨlɔ ɓopipiko ɓombimba ndɨ, ilu lɔ ɨɨta kʉwa lɨtalʉ lidingi la lindu.› ");
INSERT INTO lik_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Mʉtʉ wasɨ nɨnɔ ogwa kʉgʉ wa lɨtalʉ li nɨlɔ oɓunikaga ndɛkɛ ɓɨsɛkɛ-sɛkɛ, na mʉtʉ yi nɨnɔ lɨtalʉ li nɨlɔ agwilya ndɛkɛ, akpʉta ndɛkɛ ɓɨsɛkɛ-sɛkɛ.» ");
INSERT INTO lik_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ko ngbingo yi nɨnɔ aka nɔ, ɓowonisilo ɓa mʉtʉʉ na ɓokumu-kumu ɓa ndɨ kakɨsa kagwɨ Yeso kyɛ ɓa ndɨ nɨ ɓibini ɓɛ atwa ndɨ lizuni li nɨlɔ ko bulya kaɓʉ aka. Luki limoti, ɓʉɓanga ndɨ ɓambanzʉ. ");
INSERT INTO lik_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ɓapʉnga kʉwa ndɨ kaɓyɛ Yeso no miso ɓɨkyɛkyɛkyɛ. Ɓatɨkɨlya ɓatʉ ɓa ɓokoli nɨɓɔ ɓɨgyaga ndɨ abɛ ɓakiko ɓongbingbili. Ɓa ndɨ kamuusogo kyɛ ɓa ndɨ kapa kagwi na ɓʉnyɛ, ɓanakɨsa ɓɛɓɔ ka mʉnzɨna kakɨ. Ɓa kʉwa ndɨ kakɨsa no pisi tino yo ɓasʉta mino ka maɓɔkʉ ka ngama mudingi wa iwili. ");
INSERT INTO lik_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ɓatʉ ɓi nɨɓɔ ɓʉtɨka ndɨ ɓɔ ɓamuusa kʉwa ɓɛ: «Muwonisilo, takaiba ambɛ nɨlɔ waɓɨkyaga, wanowonisilo ikaga ngbingbili. Wakʉndagɨgʉ ɨwɛ ɓambanzʉ kaɓyɛnɛnɛ na ɨbɨba kaɓʉ, luki limoti wowonisilogo pisi ko Kunzi ka ɓungbingbili. ");
INSERT INTO lik_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Tɨɓɨkyanɔ, mʉtʉʉ kusu akpamyatʉ ikanɨ apakyatʉ koluo manzanza ka Kaizalɨ, Ngama mudingi ka Ɓalʉma?» ");
INSERT INTO lik_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Luki limoti Yeso andʉnga ndɨ ɓokoli kaɓʉ, ʉɓɨkya ɓɛ: ");
INSERT INTO lik_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«Iwonisiloni mbɛyɨ ambuma ɓemoti.» Kumbuso yi umuusa ɓɛ: «Mulundu no lino ka wanɨ lɔ a kʉgʉ yi?» Ɓasikisya ndɨ ɓɛ: «A ma ka Kaizalɨ ngama mudingi wa Lʉma.» ");
INSERT INTO lik_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Kʉwa wa Yeso ʉɓɨkya ɓɛ: «Kika nɛkɨ nɨ a ɓɛyɔ, mupóni Kaizalɨ makpʉmʉka nɨmɔ kakɨ. Mapá Kunzi nɨmɔ kakɨ gɔnɨ.» ");
INSERT INTO lik_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ɓakamɨnagʉ ndɨ na ɓʉnyɛ ka nɨmɔ aɓɨkya ndɨ kambwa ka ɓambanzʉ. Luki limoti, mʉnzɨna mi nɨmɔ usikisya ndɨ mɔ udikisa mʉnɔkʉ ɓɨdɛ, ɓadakyana ndɨ ɓiwo. ");
INSERT INTO lik_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Kʉwa wa Ɓasadukayɔ ɓemoti-ɓemoti ɓakpuɗoku ndɨ Yeso, (Ɓasadukayɔ ɓa ɓatʉ ɓi nɨɓɔ ɓakaɓɨnɨkyanagɨgʉ ndɨ ɓɛ ɓopupagatʉ ka mbʉkʉ kumbusa wa kukwakʉ) ɓamuusa ndɨ Yeso ɓɛ: ");
INSERT INTO lik_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«Muwonisilo, Musa atikpikilya ndɨ ɓɛ: ‹Mʉmbanzʉ kavanana, okwo, asa mukakɨ nɨ kɛgʉ na ɓomiki, okwononi ɓɛ mamakɨ amɨgɨlyɨ woko yi nɨnɔ kyɛ aɓʉkʉtɨlyagɨ mamakɨ ɓomiki.› ");
INSERT INTO lik_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Wɨna sɛ, a ndɨ na ɓomiki ɓalʉkʉ ɓi maɗɨya na ɨka nɨɓɔ ɓopupa ndɨ mʉma mimoti. Pʉta ava ndɨ muko, luki limoti, okwa ndɨ nɨ koɓukutigʉ na ɨyɨ. ");
INSERT INTO lik_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Syononogo kakɨ amɨgɨlya ndɨ woko yi nɨnɔ, kumbuso yi okwa ndɨ nɨ koɓukutigʉ ɨyɨ ɓɛgɛyɔ. ");
INSERT INTO lik_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Kʉwa wa igyonosa ndɨ mʉɗɔngɔnɨ ka mamaɓʉ yi nɨnɔ wa masaa na kaɓʉ ɓasɨ maɗɨya na ɨka. Ɨɓʉ ɓasɨ ɓokwa ndɨ nɨ ɓakaɓukutigʉ miki gʉtʉgʉ ɓemoti aka. ");
INSERT INTO lik_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ka muliɓo, muko yi nɨnɔ okwa kʉwa ndɨ gɔnɨ ɨyɨ. ");
INSERT INTO lik_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ka lɨsyɛ lipupa ka ɓambʉkʉ, muko yi nɨnɔ ika ndɛkɛ muka wanɨ luga kaɓʉ? A ɓɛyɔ, ɨɓʉ ɓasɨ maɗɨya na ɨka ɓavatʉ ndɨ!» ");
INSERT INTO lik_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yeso ukikisya ɓɛ: «Ɓalʉkʉ na ɓoko ɓa ɔɓɨlɨ yi nɨmʉ ɓakavanana. ");
INSERT INTO lik_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Luki limoti, ɓalʉkʉ na ɓoko ɓi nɨɓɔ Kunzi ʉmɨna ɓɛ ɓakwananatʉ kaika ka ɔɓɨlɨ nɨnɔ akodoku, na kopupa ka ɓambʉkʉ, ɓakavananɨgʉ ndɛkɛ. ");
INSERT INTO lik_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","A ɓɛyɔ, ɓakakwananɨgʉ ndɛkɛ kolumwogo, kyɛ ɔɓɨlɨ kaɓʉ ika ndɛkɛ kʉwa mʉɗɔngɔnɨ abɛ ɓamalaika. Ɓa ɓomika Kunzi, kyɛ ika kanɨ ɓopuponi ndɨ ka mbʉkʉ. ");
INSERT INTO lik_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Gʉtʉgʉ Musa uwonisila ndɨ kambwa aka ɓɛ ɓamanda abɨlɨlatʉ ndɛkɛ. Kʉsɔ wa moɓiso nɨmɔ atʉmbʉlaga lɨkpʉmʉka la gbɔgɔ nɨyɔ a ndɨ kagbʉndɨkana nɨ kɛgʉ kosilogo, Musa akamaka Mombukwono-dosu ɓɛ: ‹Kunzi ka Abalahamʉ, Kunzi ka Isaka na Kunzi ka Yakɔbɔ.›» ");
INSERT INTO lik_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Yeso omotiloku ɓɛ: «Kunzi kɛgʉ Kunzi ka ɓamanda, luki limoti a Kunzi ka ɓatʉ ɓi nɨɓɔ ɓa ɓuɓisi na nɨɓɔ ɓʉsɨmaga ɓɛ ɓokwoni ndɨ, kyɛ ɨɓʉ ɓasɨ ɓa na ɔɓɨlɨ ko bulya kakɨ.» ");
INSERT INTO lik_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ɓowonisilo ɓa mʉtʉʉ ɓemoti-ɓemoti ɓaɓɨkya kʉwa ndɨ Yeso ɓɛ: «Muwonisilo, wosikisyiku ɓɨnza.» ");
INSERT INTO lik_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","A ɓɛyɔ, ɓakɨkpʉndagʉ ndɨ ɓata kamuusogo makpʉmʉka magɔgɔ. ");
INSERT INTO lik_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Kʉwa wa Yeso ʉɓɨkya ɓata ɓɛ: «Ɓambanzʉ ɓakwanana pɨyɛ kaɓɨkya lɨkɨ ɓɛ Kilisito a miko-mika ngama Daudi? ");
INSERT INTO lik_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Kyɛ ngama Daudi mombukwana-dakɨ yi akaɓɨkya ka kɨtaɓʉ ya Mambʉ ka Ɓayuda ɓɛ: ‹Mombukwono-dosu Kunzi aɓɨkya Mombukwana-damɨ ɓɛ: Da wiki ka kʉmbanzɨkanɨkɔ kamɨ, ");
INSERT INTO lik_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","na kadwɛ ko ngbingo yi nɨnɔ nubiso mino ɓomuyoniso kakʉ kusili wa ɓakagba kakʉ.› ");
INSERT INTO lik_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","A ɓɛyɔ, Daudi amakaga Masiya ɓɛ ‹Mombukwono-dosu›, igyonosa kʉwa lɨkɨ ɓɛ iki ɓata miko-mikakɨ?» ");
INSERT INTO lik_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Kumbuso yi, Yeso ʉɓɨkya ndɨ ɓaɓɨɓya kakɨ kambwa ka ɓatʉ ɓasɨ nɨɓɔ ɓa ndɨ kamʉkana wa ɓɛ: ");
INSERT INTO lik_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Wiɓuulyonito na ɓowonisilo ɓa mʉtʉʉ, ɓapaga kakpakyana nɨ ɓimokisyogini ɓalɔpʉ ɓakpʉkpʉ. Ɓapaga kʉgbɛ ɓɛ ɓiki kaumuuso na ɨbɨba ka ɓapa ɓaya musilyoni. Ɓakɨsaga kaiko ka moliki ma kambwa aka ka ɓandaɓʉ ɓaya malʉmba, na gɔnɨ ka moliki ma ɨbɨba ka ɓapa ɓaya ɓodumo. ");
INSERT INTO lik_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ɓʉkʉpyaga ɓowoko no ɓou makpʉmʉka masɨ nɨmɔ ɓikaga nomu, na ko ngbingo yi nɨnɔ gɔnɨ nɔ, ɓanʉɓɔɓɔ na malʉmba mandandanda kyɛ ɓinisoni abɛ ɓatʉ ɓanza. Kinili, Kunzi usombisa ndɛkɛ yapʉ kʉgbɛ.» ");
INSERT INTO lik_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ngbingo yi nɨnɔ Yeso a ndɨ mino ka Ndaɓʉ ko Kunzi, ɨkwɛ ka kpɔlɔ kakɨ, ʉmɨna ɓatʉ ɓo ɓuyi nɨ ɓanaɗɨkɨta apɛpɛ kaɓʉ ka mʉmbɨ. ");
INSERT INTO lik_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Amɨna ndɨ gɔnɨ woko muko yi nɨnɔ wa yangya nɨ anaɗɨkɨta ɨkya mafalanga maɓa. ");
INSERT INTO lik_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Aɓɨkya kʉwa ndɨ ɓɛ: «Nakamʉɓɨkya lɨngʉnʉ ambɛ woko wa yangya yi nɨmʉna nɔ opí ɨyɨ yidingi kaʉkɨtaga ɓatʉ ɓagɔgɔ ɓasɨ. ");
INSERT INTO lik_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ɓatʉ ɓagɔgɔ ɓasɨ ɓopí nɨyɔ kɛgʉ ɓata ɓi na ɨɓʉ na ligubo. Luki limoti, woko yi nɨmʉna, ka yangya kakɨ, opí ɨyɨ masɨ nɨmɔ o ɓi nomu kaiɓuulyogo ka ɔɓɨlɨ kakɨ.» ");
INSERT INTO lik_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ɓambanzʉ ɓemoti-ɓemoti ɓapʉnga ndɨ kanzɨna ko bulya Ndaɓʉ ko Kunzi. Ɓa ndɨ kaɓɨkya ɓɛ a yanza kʉgbɛ na matamʉ mi manzanza, na makpʉmʉka manzanza nɨmɔ ɓambanzʉ ɓapá ndɨ apɛpɛ yi ko Kunzi. Luki limoti, Yeso aɓɨkya ndɨ ɓɛ: ");
INSERT INTO lik_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«Lɨsyɛ limoti odokuto ndɛkɛ ka masɨ nɨmɔ makaɨna ma, lɨtalʉ gʉtʉgʉ limoti aka kotigoligʉ ndɛkɛ kʉgʉ wa lagɔgɔ, apanzɨkana ndɛkɛ masɨ.» ");
INSERT INTO lik_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Kumbuso yi ɓamuusa kʉwa ndɨ ɓɛ: «Muwonisilo, lɨkpʉmʉka nɨlɔ igyonosa ndɛkɛ ngbinga tino? Likingyosi tino lɔ atimibisa ndɛkɛ ngbinga yi nɨnɔ lɨkpʉmʉka li nɨlɔ igyonosa ndɛkɛ mino?» ");
INSERT INTO lik_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yeso usikisya ɓɛ: «Wiminyonito, mʉmbanzʉ kamuɓonitɔgʉ. Ɓatʉ ɓudingi ɓodokuto ndɛkɛ ko lino kamɨ, ɓanaɓɨkya ɓɛ: ‹Ɨmɨ nɨ Masiya› na ‹Ngbingo yi nɨnɔ itulyonini.› Luki limoti, makuɓiɓyonitɔgʉ. ");
INSERT INTO lik_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ngbingo yi nɨnɔ mʉkana ndɛkɛ mino ɓomongoni ɓa mʉnga na ɓambanzʉ kavɨkɨmanaga, makombomboyonitɔgʉ. Okwononi ɓɛ nɨlɔ igyonosito ndɛkɛ mbɛyɨ, luki limoti kɛgʉ ɓɛ muliɓo ma ɔɓɨlɨ ika ko ngbingo yi nɨnɔ gɔnɨ nɔ.» ");
INSERT INTO lik_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Kumbuso yi omotiloku ɓɛ: «Lɨvananza limoti abʉmana ndɛkɛ na lɨvananza lagɔgɔ, ɓʉngama ɓimoti ʉlanana ndɛkɛ na ɓʉngama ɓagɔgɔ. ");
INSERT INTO lik_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ka ɓewili dididi, ika ndɛkɛ na ɓazigiso ɓapʉ, ayʉndɨ na ɓokoloɓu ɓayanyɛnyɛ uhuma ndɛkɛ ɓambanzʉ, ika ndɛkɛ gɔnɨ na makpʉmʉka muɓongiso na mʉmbanga-mbanga kainisono kʉgʉ wa lɨsyɛ. ");
INSERT INTO lik_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Luki limoti, kambwa wa nɨmɔ masɨ kaigyonoso, ɓamugwito ndɛkɛ, ɓamugyogyiso. Ɓamulikisa ndɛkɛ ko ngbongu ka ɓandaɓʉ ɓaya malʉmba ka Ɓayuda, ɓamʉmakya ka bɔlɔkɔ. Ɓaga ndɛkɛ na iɓunu kamusombiso kambwa ka ɓangama ɓakpʉkpʉ na ɓangama ɓa ɓewili kyɛ ko bulya lino kamɨ. ");
INSERT INTO lik_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Yigyogyiso yi nɨyɔ ika kʉwa ndɛkɛ kunu pisi ya kʉɓɨkyaga ɓambanzʉ Mongoni kamɨ. ");
INSERT INTO lik_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Wikoni ɓakɨtʉlya kanɨ makɛgʉ kombomboyo kakɨsa ɓɛ maɓɨkya ɓʉnɨ nɨ ɓamulikisini ko ngbongu. ");
INSERT INTO lik_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ɨmɨ mombukwana-dakɨ yi nɔ namuwonisilo mʉnzɨna mi nɨmɔ na yimibo nɨyɔ ɓomuyoniso kunu ɓakakwananɨgʉ mino kobiso ɗongoso na iɓunu, gʉtʉgʉ kamusikisya lɨkpʉmʉka aka. ");
INSERT INTO lik_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Gʉtʉgʉ ɓobonu aka na ɓomonu, ɓomomonu, ɓonguwo kunu na ɓawai-donu ɓamʉgabatʉ ndɛkɛ. Ɓulumwisaga ndɛkɛ ɓatʉ ɓudingi luga kunu. ");
INSERT INTO lik_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ɓatʉ ɓasɨ ɓamʉmʉya ndɛkɛ ko bulya kamɨ. ");
INSERT INTO lik_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Luki limoti iɓunu mika ndɛkɛ ka mazɨyɔ aka nɨ gʉtʉgʉ litukatʉ aka kamunyukigʉ. ");
INSERT INTO lik_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Pisi ka lɨmbɛngɨ lɨnda, mohukusagatʉ mambɛngɨ kunu.» ");
INSERT INTO lik_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Yeso ʉɓɨkya ɓata ndɨ ɓɛ: «Ngbingo yi nɨnɔ mamɨna ndɛkɛ mino Yelusalɛma nɨ ɓasʉda ɓakungulini ɓikululu, miba ndɛkɛ ɓɛ panzɨkana kakɨ a kʉwa ɓuwobi. ");
INSERT INTO lik_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Kʉwa wa nɨɓɔ ɓika ndɛkɛ ka iwili ya Yudɛa ɓogwa ndɛkɛ mbangʉ misa ya ɓangʉpa. Nɨɓɔ ɓika ndɛkɛ ka Yelusalɛma ɓakɨɗa ndɛkɛ ɓɨkɛɗɛ, na nɨɓɔ ɓika ndɛkɛ ka sɛngɨ ɓakogʉlyɨgʉ ndɛkɛ ɓata ka gʉɗʉ. ");
INSERT INTO lik_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kyɛ ka masyɛ mi nɨmɔ Kunzi ogyogyisa ndɛkɛ lɨvananza kakɨ, iba masɨ nɨmɔ ikpikaga ndɨ ka Moɓiso igyonosi. ");
INSERT INTO lik_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ka masyɛ mi nɨmɔ, ɓoko ɓa ɓamʉma na nɨɓɔ ɓika ndɛkɛ kaulunguso ɓomiki ɓalya ndɛkɛ kumbu. Kumbu yidingi ika ndɛkɛ ka mugi mi nɨmɔ na ngbʉta ko Kunzi inisana ndɛkɛ ka ɓatʉ ɓi. ");
INSERT INTO lik_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ɓulumwisaga ndɛkɛ ɓagɔgɔ na ɓadʉkpa, ɓaga ndɛkɛ na ɓagɔgɔ ɓɛdʉnga ka ligbito pa yasɨ ka ɓogiyo ɓayasɨ. Na ɓɛvananza nɨɓayɔ ɓakamibigʉ Kunzi ɓaɗɨtaga ndɛkɛ Yelusalɛma kadwɛ kʉ kwa kʉ ngbingo kaɓʉ osyo mino.» ");
INSERT INTO lik_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Kʉwa wa, Yeso oɓikyoku ɓata ɓɛ: «Makpʉmʉka mʉmbanga-mbanga inisana ndɛkɛ ka mɔnɨ, tɨmba na ka mangʉtʉ. Mbumbo ya moɓo makpʉkpʉ na mʉɓaka apá ndɛkɛ mʉʉngwa mudingi, na ɓɛvananza aɓanga ndɛkɛ kʉgbɛ. ");
INSERT INTO lik_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ɓambanzʉ ɓemoti-ɓemoti ɓahʉmwana ndɛkɛ na kʉɓangakʉ katamana lɨkpʉmʉka nɨlɔ osiloku ndɛkɛ ka ɔɓɨlɨ wasɨ. A ɓɛyɔ, makpʉmʉka mongu masɨ nɨmɔ kʉgʉ wa lɨsyɛ abɛ mɔnɨ, tɨmba na mangʉtʉ atʉkya ndɛkɛ ka ɓapa kaɓʉ. ");
INSERT INTO lik_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Kʉwa wa ɓamɨna ndɛkɛ Mika-mʉmbanzʉ kodoku ka ɨkʉɓa, no ngu pa imoti na ɨbɨba yidingi. ");
INSERT INTO lik_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ko ngbingo yi nɨnɔ makpʉmʉka mi nɨmɔ apʉnga ndɛkɛ mino kaigyonoso, womogoni, mananɨkana, mika ɓakɨtʉlya kyɛ Kunzi ika kʉwa ndɛkɛ ɓuwobi kamʉkʉlaga.» ");
INSERT INTO lik_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Kumbuso yi Yeso ʉpá ndɨ likingyosi li nɨlɨ: «Wondoni mbɛyɨ sɨbʉkʉsɔ si nɨsɨ na bʉkʉtɔ tagɔgɔ tasɨ. ");
INSERT INTO lik_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Kapʉnga kaɓaka mapakʉ mambɨya, iba syangasʉ a kʉwa ɓuwobi koɓuniko. ");
INSERT INTO lik_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Mʉɗɔngɔnɨ ɓɛgɛyɔ makɨna kʉwa ndɛkɛ makpʉmʉka mi nɨmɔ kaigyonoso, miba kʉwa ndɛkɛ ɓɛ Ɓʉngama ko Kunzi a ɓuwobi. ");
INSERT INTO lik_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","A lɨngʉnʉ, nakamʉɓɨkya ambɛ, ɓatʉ ɓa lɨvananza nɨlɨ ɓakolumwogigʉ ɓasɨ nɨ makpʉmʉka nɨmɔ masɨ kanigyonosigʉ. ");
INSERT INTO lik_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Lɨsyɛ na lɨtɔmbʉ olimikatʉ ndɛkɛ, luki limoti lɨkpʉmʉka kamɨ kolimikigʉ ndɛkɛ lu.» ");
INSERT INTO lik_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Yeso omotiloku ɓɛ: «Wiminyonito! Makiɗondomosonitɔgʉ ko bulya malɨlɨ na lɨbʉma, makidomisonitɔgʉ ko bulya ɔɓɨlɨ. Kanɨ kɛgʉ ɓɛ lɨsyɛ nɨlɔ amusilyi ndɛkɛ ɓigbututu kanɨ makɛgʉ na tamanago yi. ");
INSERT INTO lik_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Lɨsyɛ nɨlɔ usilya ndɛkɛ ɓatʉ ɓasɨ ɓa ɔɓɨlɨ ɓigbututu mʉɗɔngɔnɨ ɓɛyɔ ɓosi ɓigwinonogo mino ka kuyakʉ. ");
INSERT INTO lik_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Makololonitɔgʉ, lumboni ɓongbinga ɓasɨ. Iba miki ndɛkɛ no ngu yɨpɨlya masɨ nɨmɔ ika kodoku, makwanana kaamaga kambwa ko Mika-mʉmbanzʉ.» ");
INSERT INTO lik_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Na lɨsyɛ, Yeso olipyaga ndɨ kapá mʉtɨwɨ ka Ndaɓʉ ko Kunzi, luki limoti opupaga ndɨ kaɨnda kasyɛ ka Ngʉpa ya Mizeituni. ");
INSERT INTO lik_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Na ɓatʉ ɓasɨ ɓopupyaga ndɨ na ɓʉsɔɓɨ ɓiɓo ka Ndaɓʉ ko Kunzi kamʉkana. ");
INSERT INTO lik_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Yɨnga nɨnɔ ɓalyaga ndɨ mino mukati wokofulu, nɨnɔ ɓamakaga ɓɛ Pasɨka a kʉwa ndɨ ɓuwobi. ");
INSERT INTO lik_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ɓokumu-kumu na ɓowonisilo ɓa mʉtʉʉ ɓa ndɨ kakɨsa pisi kamwɔ Yeso ɓɨpɛlɛ, kyɛ ɓa ndɨ kaʉɓanga ɓambanzʉ. ");
INSERT INTO lik_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Kʉwa wa, Abɨlɨ ogulya ndɨ kʉsɔ ka Yuda Isikalioti, ɓemoti ka ɓatʉtʉmbwa tɛkɛɓɛ na ɓaɓa. ");
INSERT INTO lik_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Aga ndɨ kaʉkanana na ɓokumu-kumu na ɓangama ka ɓazamʉ ɓa Ndaɓʉ ko Kunzi ko bulya kʉgabɨlya Yeso. ");
INSERT INTO lik_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ɓogwa ndɨ magyagya kʉgbɛ ko bulya yi, ɓʉkanana ndɨ kapá ɓuyi. ");
INSERT INTO lik_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yuda aɓɨnɨkyana kʉwa ndɨ, apʉnga kakɨsa pisi kaʉgabɨlya Yeso ɓɨpɛlɛ. ");
INSERT INTO lik_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ka yɨnga nɨyɔ ɓalyaga mino mukati nɨ ɓakagyɨgʉ na sɨbʉkʉsɔ nɨsɔ ofulisogo, lɨsyɛ nɨlɔ ɓʉmwɔgɔ ndɨ mino ɓomikya ɓakɔndɔlɔ ko bulya malɨlɨ ma Pasɨka ɨtʉlyana ndɨ. ");
INSERT INTO lik_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Kʉwa wa Yeso atɨka ndɨ Pɛtɛlɛ ɨɓʉ na Yuani, ʉɓɨkya ɓɛ: «Wogoni katiɓungusilyogo malɨlɨ ma Pasɨka.» ");
INSERT INTO lik_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ɓamuusa ndɨ ɓɛ: «Wakapa sɛ ɓɛ toɓungusyogiku yanɨ?» ");
INSERT INTO lik_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yeso usikisya ɓɛ: «Hukononi, nɨyɔ mogulya ka gʉɗʉ, mabangana na alʉkʉ ɓemoti obinikini mbɨkɛ yo liɓo. Wogoni pa imoti na ɨɓʉ kadwɛ ka ndaɓʉ yi nɨyɔ ogulyoku mino, ");
INSERT INTO lik_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","mamuuso mombukwana ndaɓʉ ɓɛ: ‹Muwonisilo akaumuusa ɓɛ ndaɓʉ tino yɔ alya mina Pasɨka pa imoti na ɓaɓɨɓya kakɨ?› ");
INSERT INTO lik_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Amʉwanya kʉwa miso ma ndaɓʉ mudingi ka ndaɓʉ ya kʉgʉ, nɨyɔ ayiɓungusyaga ɓɨnza. Moɓungusyaga kʉwa pa ɨlyalya kʉ ɓɛyɔ.» ");
INSERT INTO lik_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ɓaga ndɨ, ɓatakanya masɨ ɓɛyɔ Yeso a ndɨ mino nɨ uɓikyini, ɓamba kʉwa ndɨ malɨlɨ ma Pasɨka kʉ ɓɛyɔ. ");
INSERT INTO lik_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Nɨyɔ ngbinga mʉlyalya ɨtʉlyana, Yeso apʉnga ndɨ kalyalya pa imoti na ɓatʉtʉmbwa. ");
INSERT INTO lik_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Kumbuso yi ɨyɨ aka na ɨɓʉ ɓɛ: «Na ndɨ na mʉsasa kʉgbɛ kalya Pasɨka yi nɨmʉ ma pa imoti na iɓunu kambwa wa kigyogyiso. ");
INSERT INTO lik_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Kyɛ nakamʉɓɨkya ɓɨngbanganya ambɛ nakalyɨgʉ ndɛkɛ ɓata Pasɨka kadwɛ kʉ kwa kʉ igyonosa ndɛkɛ mino ka Ɓʉngama ko Kunzi.» ");
INSERT INTO lik_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Kʉwa wa ɓapá kɔpɔ wa vinya, amigisya Kunzi ɨbɨba, kumbuso yi aɓɨkya ɓɛ: «Muvoni kɔpɔ wa vinya yi nɨmʉ, mamwo luga kunu ɓasɨ. ");
INSERT INTO lik_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","A ɓɛyɔ, nakamʉɓɨkya ambɛ, katʉkya mbɨya-mbɨya wanʉ, nakomwigʉ ndɛkɛ ɓata vinya wa muzabibu kadwɛ ko ngbingo yi nɨnɔ Ɓʉngama ko Kunzi odoku ndɛkɛ mino.» ");
INSERT INTO lik_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Kʉwa wa ava ndɨ mukati, nɨyɔ amigisya Kunzi ɨbɨba, oɓunonogo, ʉlʉpyaga, ʉɓɨkya ɓɛ: «Nzʉyɨ kamɨ nɨyɨ ipi ko bulya kunu. Gyogoni ɓɛyɔ kɛtamana yi.» ");
INSERT INTO lik_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Kumbuso wa malɨlɨ, Yeso ʉpá kɔpɔ wa vinya ɓɛgɛyɔ, ʉɓɨkya ɓɛ: «Kɔpɔ yi nɨmʉna a agʉmɛ wambɨya ko Kunzi pisi ka ɓangʉ kamɨ nɨyɔ oɗukogi ko bulya kunu. ");
INSERT INTO lik_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Luki limoti hukononi! Mʉtʉ yi nɨnɔ akegaba ka ɓomuyoniso akalyalya pa imoti na ɨmɨ. ");
INSERT INTO lik_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","A ɓɛyɔ, Mika-mʉmbanzʉ akokwo mʉɗɔngɔnɨ ɓɛyɔ Kunzi oɓungusyaga ndɨ mino, luki limoti kumbu yidingi ka mʉtʉ yi nɨnɔ akagabo yi!» ");
INSERT INTO lik_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Kʉwa wa ɓatʉtʉmbwa ɓapʉnga ndɨ kauusono luga kaɓʉ ɓɛ wanɨ sɛ nɔ akwanana kagya inguo ya lɨkpʉmʉka li nɨlɔ. ");
INSERT INTO lik_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Kumbuso yi ɓaɓɨɓya ɓapʉnga ndɨ kolutono ɓanimuuso ɓɛ wanɨ nɔ mʉtʉ wa ɨbɨba kʉgbɛ luga kaɓʉ. ");
INSERT INTO lik_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yeso ʉɓɨkya ndɨ ɓɛ: «Ɓangama ɓakpʉkpʉ ɓa ɓɛvananza ɓayɔ ɔɓɨlɨ yi nɨmʉ ɓatɨwaga ɓɛvananza kaɓʉ na mʉpamʉ na nɨɓɔ ɓa no ngu kʉgʉ kaɓʉ ɓapaga ɓɛ ɓʉmakɨ ɓɛ: ‹Ɓagya-manza.› ");
INSERT INTO lik_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Iɓunu makogyonitɔgʉ abɛ ɨɓʉ! Luki limoti mʉtʉ yi nɨnɔ a abɛ pʉta luga kunu okwononi kaiko abɛ miki. Na mʉtʉ yi nɨnɔ a abɛ ngama okwononi kaiko abɛ mʉgya-ligubo. ");
INSERT INTO lik_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Mʉtʉ tino pɨyɛ nɔ a na ɨɓɨba kʉgbɛ? A mʉtʉ yi nɨnɔ ikaga wakiko kalyalya, ikanɨ nɨnɔ ikaga kagya ligubo la malɨlɨ? A mʉtʉ yi nɨnɔ ikaga wakiko. Iyo, a ɓɛyɔ, luki limoti ɨmɨ na luga kunu abɛ mʉgya-ligubo. ");
INSERT INTO lik_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Iɓunu mikaga ndɨ pa imoti na ɨmɨ ɓongbinga ɓasɨ wa ɓikaga ndɨ mino kegyogyiso. ");
INSERT INTO lik_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Na ɨmɨ kamʉpá Ɓʉngama ɓɛgɛyɔ baba ɛpá ndɨ minɔ ɨmɨ. ");
INSERT INTO lik_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Kʉwa ɓɛgɛyɔ malyalya ndɛkɛ, momwo pa imoti na ɨmɨ ka Ɓʉngama kamɨ, mikanana ndɛkɛ ka moliki ma ɓʉngama kosombiso mababa tɛkɛɓɛ na maɓa ka Ɓezaleli.» ");
INSERT INTO lik_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yeso aɓɨkya kʉwa ndɨ Simoni Pɛtɛlɛ ɓɛ: «Hʉkana ɓɨnza, Simoni: Ɓahukulyi Abɨlɨ pisi ɓɛ amʉpɨpɨ ɓasɨ ɓɛyɔ ɓapɨpaga mino mʉpʉnga. ");
INSERT INTO lik_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Luki limoti ɨmɨ nulumbilyito ɓi ambɛ baya kakʉ kodikogonitɔgʉ, ɨwɛ, wakemigilyoku ɓanʉ ɓata, utumisa ɓamamakʉ mambɛngɨ.» ");
INSERT INTO lik_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pɛtɛlɛ aka ndɨ ɓɛ: «Mombukwono-dosu, na wakɨtʉlya kaɨnda ka ligbito, gʉtʉgʉ ka kukwakʉ aka pa imoti na ɨwɛ.» ");
INSERT INTO lik_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yeso asikisya ndɨ ɓɛ: «Pɛtɛlɛ, nakaʉɓɨkya ɓɨngbanganya ambɛ no biti ya lɨsyɛ li nɨlɨ, kɔkʉ kalɨkagʉ nɨ wakanemongonyigʉ nganga yɨsaa.» ");
INSERT INTO lik_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Kʉwa wa Yeso umuusa ndɨ ɓaɓɨɓya ɓɛ: «Ngbingo yi nɨnɔ namʉtɨka ndɨ mino kaɓɨkyaga Mongoni Manza nɨ makigwinonogigʉ no luki abɛ ɓuyi, kʉgba, ɓɛkpakʉ, mazangatʉ ndɨ luki?» Ɓosikisya ndɨ ɓɛ: «Haaa, takazangagʉ ndɨ luki gʉtʉgʉ limoti aka.» ");
INSERT INTO lik_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ʉɓɨkya kʉwa ɓɛ: «Luki limoti mbɨya wanʉ, mʉtʉ nɨnɔ a no ɓuyi okwononi kʉwa kava. A mʉɗɔngɔnɨ gɔnɨ abɛ nɨnɔ a na kʉgba. Na nɨnɔ kɛgʉ na dʉkpa ya lʉnga, okwononi kagaba koti kakɨ, oluwa imoti. ");
INSERT INTO lik_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Kyɛ nakamʉɓɨkya ɓɨngbanganya ambɛ okwononi igyonosi kʉgʉ ka ɨmɨ nɨlɔ ikpikaga ndɨ ka Moɓiso ɓɛ: ‹Ɓamatana ndɨ pa imoti na ɓagya-manyɛ.› Iyo nakamʉɓɨkya ambɛ nɨlɔ ikpikaga ndɨ kʉgʉ kamɨ ika kʉwa kaigyonoso.» ");
INSERT INTO lik_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ɓaɓɨɓya ɓaɓɨkya ndɨ ɓɛ: «Mombukwono-dosu, wɨna ɓadʉkpa ɓayɨɓa nɨɓa yɨ.» Usikisya ndɨ ɓɛ: «Ama ɓʉɓwa.» ");
INSERT INTO lik_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Kʉwa wa Yeso opupa ndɨ kunzi wa gʉɗʉ, aga ka Ngʉpa ya Mizeituni ɓɛyɔ aka yɔ agyaga ndɨ mino. Ɓaɓɨɓya kakɨ ɓaɓyɛ ndɨ. ");
INSERT INTO lik_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Nɨyɔ ɓadwɛ ka pa yi nɨyɔ, ʉɓɨkya ndɨ ɓɛ: «Lumboni kyɛ makogwonitɔgʉ ka kʉɓɔɓɔkʉ.» ");
INSERT INTO lik_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Kumbuso yi idukula ndɨ ɓyɨ na ɨɓʉ, oɓuno moli, alʉmba, ");
INSERT INTO lik_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","ɨyɨ aka ɓɛ: «Baba ooo, wakapa, wekiɗisya ɓaka kɔpɔ yi nɨmʉ. Luki limoti, sɨpananɨsɔ kakʉ sɔ igyonosi nɨ kɛgʉ nɨsɔ kamɨ.» ");
INSERT INTO lik_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Kʉwa wa malaika ɓemoti kotukyoku kʉgʉ wa lɨsyɛ apuponilyoku, atumisa ndɨ lɨmbɛngɨ. ");
INSERT INTO lik_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yeso a ndɨ ko kumbu yidingi, idukulaga kʉwa ndɨ kalʉmba na kɛkɛlɛ. Ɓungu apʉnga ndɨ kaɗʉka wasɨ abɛ ɓɛgbɛtɛtɨyɛ ɓa ya ɓangʉ. ");
INSERT INTO lik_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Kumbuso wa malʉmba, igoku kʉnʉ ɓaɓɨɓya ɓa ndɨ mino. Ʉtakanya ka ɓatɔtɔ ɓingbwungono ko bulya kumbu. ");
INSERT INTO lik_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Umuusa ɓɛ: «Heɓeee, ma kʉwa ka ɓatɔtɔ? Zuzukoni, malʉmba kyɛ makogwonitɔgʉ ka kʉɓɔɓɔkʉ.» ");
INSERT INTO lik_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ngbingo yi nɨnɔ a mbɛyɨ ndɨ mino asɨ kanzɨna aka ɓɛyɔ, ambaza ka ɓambanzʉ opuponoku. Yuda, nɨnɔ a ndɨ ɓemoti ka ɓatʉtʉmbwa tɛkɛɓɛ na ɓaɓa nɔ a ndɨ kaukpokyonisoku. Akpuɗoku ndɨ Yeso kapututo. ");
INSERT INTO lik_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Luki limoti, Yeso amuusa ndɨ ɓɛ: «Yuda, wakapututa Mika-mʉmbanzʉ kowonisilo ɓɛ wagobini?» ");
INSERT INTO lik_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Nɨyɔ ɓaɓɨɓya ɓɨna nɨlɔ a ndɨ kapa kaigyonoso lɔ, ɓamuusa ɓɛ: «Mombukwono-dosu, tʉlananɨtɔ na ɓatʉ ɓi nɨɓa na ɓadʉkpa kusu?» ");
INSERT INTO lik_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ɓemoti luga kaɓʉ ayipo mʉgya-ligubo ko kumu-kumu, akɔ ndɨ kutiliko kwa kʉmbanzɨkanɨkɔ. ");
INSERT INTO lik_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Luki limoti Yeso ʉɓɨkya ɓɛ: «Wosoni, ama ɓʉɓwa.» Avɨla ndɨ kutiliko ka alʉkʉ nɔ, ahukuso. ");
INSERT INTO lik_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Kumbuso yi Yeso ʉɓɨkya ndɨ ɓokumu-kumu, ɓangama ka ɓazamʉ ɓa Ndaɓʉ ko Kunzi na ɓambɔkʉ-mbɔkʉ nɨɓɔ ɓodoku ndɨ kagwi ɓɛ: «Moduku kegwi na ɓadʉkpa na ɓɛngbɨngɨlɨ abɛ nakika mʉtʉ wo kuɓakʉ? ");
INSERT INTO lik_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nikaga ndɨ pa imoti na iɓunu masyɛ masɨ ka Ndaɓʉ ko Kunzi, makegwigʉ ndɨ. Luki limoti ngbingo a kʉwa no kunu iɓunu pa imoti na ngama wo biti.» ");
INSERT INTO lik_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Kʉwa wa ɓagwi ndɨ Yeso. Ɓaga na ɨyɨ, ɓamingyisa ndɨ ka ndaɓʉ ko kumu-kumu. Pɛtɛlɛ a kʉwa ndɨ ɨyɨ kaɓɨɓya nɨ a ɓyɨ. ");
INSERT INTO lik_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ɓagbʉnda ndɨ ɓuku ka pa yangba, ɓikanana ndɨ wa, Pɛtɛlɛ odoku ndɨ gɔnɨ kaiko luga kaɓʉ. ");
INSERT INTO lik_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Mʉgya-ligubo ɓemoti muko yi amɨna ndɨ wakiko ka kpɔlɔ wo ɓuku, anda ɓizumuuu, ɨyɨ aka ɓɛ: «Alʉkʉ yi nɨmʉna a tʉ ndɨ gɔnɨ pa imoti na ɨyɨ.» ");
INSERT INTO lik_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Luki limoti Pɛtɛlɛ anganya ndɨ, aɓɨkya ɓɛ: «Eze, nakamibigʉ ɨmɨ.» ");
INSERT INTO lik_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Kagya ɓata yɨkɛɗɛ ɓɛnɛ, mʉtʉ wagɔgɔ amɨna ndɨ, aɓɨkya ɓɛ: «Gʉtʉgʉ ɨwɛ aka, wa ɓemoti kaɓʉ gɔnɨ.» Luki limoti Pɛtɛlɛ asikisya alʉkʉ nɔ ɓɛ: «Wai aaa, nakɛgʉ ɨmɨ ɓemoti kaɓʉ.» ");
INSERT INTO lik_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Kagya ɓata abɛ saa imoti ɓɛnɛ, mʉtʉ wagɔgɔ otiwolya ɓɛ: «A ɓɛyɔ, mʉtʉ yi nɨmʉ ɓa ndɨ pa imoti na ɨyɨ, kyɛ a Mʉgalilaya.» ");
INSERT INTO lik_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Luki limoti Pɛtɛlɛ asikisya ɓɛ: «Alʉkʉ aaa, nakɛgʉ kaiba ambɛ wakapa kaɓɨkya ɓʉnɨ.» Ko ngbingo yi nɨnɔ aka nɔ a ndɨ mino kanzɨna nɔ, kɔkʉ alɨka. ");
INSERT INTO lik_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Mombukwono-dosu oyikana ndɨ, anda Pɛtɛlɛ ɓɨngbangbangba. Kʉwa wa, Pɛtɛlɛ atamana lɨkpʉmʉka nɨlɔ Mombukwono-dosu aɓɨkya ndɨ ɓɛ: «Kambwa kɔkʉ kaalɨka na lɨsyɛ li nɨlɨ, wika nɨ wemongonyini nganga yɨsaa.» ");
INSERT INTO lik_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pɛtɛlɛ opupa ndɨ kunzi, apʉnga ndɨ kagama no kumbu kʉgbɛ. ");
INSERT INTO lik_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ɓalʉkʉ nɨɓɔ ɓa ndɨ kaɓuulyaga Yeso ɓa ndɨ katɨba na kabʉma. ");
INSERT INTO lik_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ɓakanda ndɨ miso na kutuko, ɓanamuusa ɓɛ: «Tɨtʉlya, wanɨ nɔ uipi!» ");
INSERT INTO lik_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ɓaɓuɓisa ndɨ ɓitu na mosikoni. ");
INSERT INTO lik_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Nɨyɔ lɨsyɛ asyɛ, ɓambɔkʉ-mbɔkʉ ka Ɓayuda, ɓokumu-kumu na ɓowonisilo ɓa mʉtʉʉ ɓamʉmʉkana ndɨ. Ɓaga ndɨ na Yeso kasombiso ka Basa-Yidingi, ");
INSERT INTO lik_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","ɓamuusa ndɨ ɓɛ: «Kika nɨ ɨwɛ nɨ Kilisito, tɨɓɨkya.» Luki limoti, usikisya ndɨ ɓɛ: «Nakamʉɓɨkya, makɛbaɨlyɨgʉ, ");
INSERT INTO lik_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","na nakamumuuso lɨkpʉmʉka, makesikisyigʉ. ");
INSERT INTO lik_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Luki limoti katʉkya mbɨya-mbɨya wanʉ, Mika-mʉmbanzʉ ika ɓanʉ wakiko ka kʉmbanzɨkanɨkɔ ko Kunzi nɨnɔ a nɔ ngu.» ");
INSERT INTO lik_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Kʉwa wa ɓatʉ ɓasɨ ɓaɓɨkya ndɨ ɓɛ: «Ɨwɛ nɔ wa nɛkɨ Miko Kunzi?» Usikisya ndɨ ɓɛ: «Moɓikyini nɨ iɓunu, Ɨmɨ nɨ ɨyɨ.» ");
INSERT INTO lik_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ɓaɓɨkyana kʉwa ndɨ ɓɛ: «Takɛgʉ ɓata na nzoyi ya ɓadɛmʉ! Timukyonili nɨ iɓusu aka nɨlɔ opupisi ka mʉnɔkʉ kakɨ.» ");
INSERT INTO lik_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Kumbuso yi, ambaza wasɨ atʉkya, ɓaga ndɨ na Yeso kʉ ka Pilatʉ. ");
INSERT INTO lik_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Kʉ ɓɛyɔ, ɓapʉnga ndɨ kasʉngʉlya ɓanaɓɨkya ɓɛ: «Tatakanya ndɨ mʉtʉ yi nɨmʉna nɨ anʉpʉta ɓatʉ kusu ɓamʉ. Anʉɓɨkya ɓɛ ɓakuluwonito ɓamanzanza ka ngama mudingi wa Lʉma. Anɨbɨba ɓɛ ɨyɨ nɨ Masiya, ngama.» ");
INSERT INTO lik_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilatʉ aka ndɨ na ɨyɨ ɓɛ: «Ɨwɛ nɔ wa ngama ka Ɓayuda?» Yeso amigisya ɓɛ: «Ɨwɛ nɔ wakaɓɨkya ɓɛyɔ.» ");
INSERT INTO lik_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilatʉ ʉɓɨkya kʉwa ɓokumu-kumu na ambaza nɨnɔ amʉmʉkana ndɨ wa ɓɛ: «Nakɛgʉ ɨmɨ kaɨna lɨkpʉmʉka gʉtʉgʉ limoti aka nɨlɔ okwononi ɓɛ ɓabisi mino alʉkʉ yi nɨmʉ na mʉkɔmbʉ.» ");
INSERT INTO lik_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Luki limoti ɓatʉ nɨɓɔ ɓasʉngʉlya ndɨ Yeso ɓaɓɨkya ɓata ndɨ ɓɨngbanganya na lɨyʉ lapʉ ɓɛ: «Kʉsɔ wa muwonisili kakɨ, alʉkʉ yi nɨmʉna akaʉkpamya ɓambanzʉ kavɨkɨmanaga. Apʉnga ndɨ kapá mʉtʉʉ mi nɨmɔ katʉkya ka Galilaya aka, kumbuso yi akɨtanaga ka mugi masɨ ka Ɓayuda, na mbɨya yi nɨmʉ, osiliniku wanʉ.» ");
INSERT INTO lik_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Wa Pilatʉ ʉkana mino lɨkpʉmʉka nɨlɔ ɓɛyɔ, uusa ɓɛ: «Mʉtʉ mʉna a Mʉgalilaya?» Ɓasikisya ɓɛ: «Iyo ngama!» ");
INSERT INTO lik_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ngbingo yi nɨnɔ ʉkana mino ɓɛ Yeso otukyiku ka iwili nɨyɔ Ɛlɔdɨ Atipasɨ andaga ndɨ, atɨka ndɨ Yeso kʉ kakɨ. Ka masyɛ mi nɨmɔ, ɨyɨ Ɛlɔdɨ a ndɨ gɔnɨ wa ka Yelusalɛma wa. ");
INSERT INTO lik_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Nɨyɔ Ɛlɔdɨ amɨna Yeso, ogwa magyagya kyɛ ʉkanagatʉ ndɨ nɨ ɓananzɨna ko bulya ka Yeso. Kinili katʉkya ka ɓʉndɛlɨ aka ikaga ndɨ na mʉsasa kʉgbɛ kamɨna yi. A ndɨ gɔnɨ na mʉtamanagɨ ɓɛ amininɔ gʉtʉgʉ nɨ anagya makpʉmʉka mʉmbanga-mbanga. ");
INSERT INTO lik_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Amuusaga ndɨ makpʉmʉka mudingi luki limoti nɨ Yeso kosikisyigʉ lɨkpʉmʉka gʉtʉgʉ limoti aka. ");
INSERT INTO lik_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ɓokumu-kumu na ɓowonisilo ɓa mʉtʉʉ ɓa ndɨ wa nɨ ɓanabɨnɨkɨlya Yeso makpʉmʉka ɓitititi. ");
INSERT INTO lik_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ɛlɔdɨ na ɓasʉda kakɨ ɓa ndɨ katɨba ɓikyekyekye, ɓanamɨna payaya. Kumbuso yi, amokisyiso kutuko kwanza, amigiso ɓata kʉ ka Pilatʉ. ");
INSERT INTO lik_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Lɨsyɛ nɨlɔ, Ɛlɔdɨ nɨnɔ ɓakoɓyogɨgʉ ndɨ na Pilatʉ, ɓɨɨta kʉwa ndɨ ɓawai. ");
INSERT INTO lik_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilatʉ ʉmʉmʉla ndɨ ɓokumu-kumu, ɓangama ka Ɓayuda pa imoti na ɓambanzʉ ɓagɔgɔ, ");
INSERT INTO lik_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ʉɓɨkya ɓɛ: «Medulyiku ɓi na mʉtʉ mʉna manaɓɨkya ɓɛ akaʉkpamya ɓambanzʉ kavɨkɨmanaga. A ɓɛyɔ, no ɓi kamuusogo ko misa kunu makpʉmʉka masɨ nɨmɔ motumbulogi ko bulya kakɨ, luki limoti nakaminigʉ na lɨkpʉmʉka lanyɛ gʉtʉgʉ limoti aka. ");
INSERT INTO lik_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ɛlɔdɨ kaminigʉ ɓi ɨyɨ na ɓʉnyɛ ɓɛgɛyɔ, kyɛ amigisikuto ɓi kʉnʉ. A nɛkɨ ɓɨngbanganya ɓɛ mʉtʉ mʉna kogyigʉ luki lanyɛ gʉtʉgʉ limoti aka nɨlɔ okwononi mino ɓɛ ɓamwɨ. ");
INSERT INTO lik_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Kinili, ɨmɨ natinisiso pimbo aka, kumbuso yi nasiso.» ");
INSERT INTO lik_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ka ɓayɨnga ɓaya Pasɨka ɓayasɨ, Pilatʉ ʉkʉlyaga ndɨ mʉtʉ wa ligbito ɓemoti. ");
INSERT INTO lik_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Luki limoti ɓagbʉngʉkana ndɨ ɨɓʉ ɓasɨ ɓɛ: «Mʉmwɔ mʉtʉ yi nɨmʉ! Watikulyoku Balaba!» ");
INSERT INTO lik_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Balaba nɨnɔ ɓagwi ndɨ ka bɔlɔkɔ kyɛ ʉkpamya ndɨ ɓambanzʉ kavɨkɨmanaga ka gʉɗʉ, amwɔ ndɨ gɔnɨ mumbanzʉ. ");
INSERT INTO lik_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Yɛkɨ Pilatʉ a ndɨ kapa aka kakʉla Yeso, ɨgɨlya ɓata ndɨ kaʉɓɨkya ɓɛyɔ. ");
INSERT INTO lik_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Luki limoti ɓidukulaga ndɨ kapamɨkana, ɓanaɓɨkya ɓɛ: «Mʉbangɨlaga ka mʉsalaba! Mʉbangɨlaga ka mʉsalaba!» ");
INSERT INTO lik_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilatʉ ʉɓɨkya ndɨ ka nganga ya yɨsaa ɓɛ: «Ɓʉnyɛ tino ɓɔ ogyi ɓi? Nakaminigʉ ɨmɨ na lɨkpʉmʉka lanyɛ gʉtʉgʉ limoti aka nɨlɔ okwononi mino ɓɛ ɓamwɨ. Natinisisa pimbo aka, kumbuso yi nasiso.» ");
INSERT INTO lik_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Luki limoti ɓambanzʉ ɓotiwolya ndɨ kapamɨkanaga ɓɛ ɓabangɨlagɨnɔ Yeso ka mʉsalaba aka. Lɨmbɛngɨ akundumono Pilatʉ, ");
INSERT INTO lik_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","abaɨlya ndɨ kaʉgyɨlya mʉɗɔngɔnɨ ɓɛyɔ ɓa ndɨ mino kapa. ");
INSERT INTO lik_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Akʉla Balaba, mʉtʉ yi nɨnɔ ɓagwi ndɨ ka ligbito kyɛ ʉkpamya ndɨ ɓambanzʉ kavɨkɨmanaga na amwɔ ndɨ gɔnɨ mʉmbanzʉ. Kʉwa wa, ʉpá ndɨ Yeso ɓɛ ɓagyɨ ɓɛyɔ ɓa mino kapa. ");
INSERT INTO lik_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ngbingo yi nɨnɔ ɓasʉda ɓa ndɨ mino kaaga na Yeso, ɓabangana na Simoni nɨnɔ mʉtʉ wa Kulɛnɛ nɨ anigoku ko tiko. Ɓabinikisa ndɨ mʉsalaba kumbuso ka Yeso no bou. ");
INSERT INTO lik_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ambaza mudingi a ndɨ kaɓɨɓya. Ɓoko nɨɓɔ ɓa ndɨ luga kaɓʉ ɓanagamana, na kalya kumbu ko bulya kakɨ. ");
INSERT INTO lik_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yeso oyikono, ʉɓɨkya ɓɛ: «Iɓunu ɓoka ɓa Yelusalɛma, makegomonitɔgʉ ɨmɨ! Luki limoti wigomoni iɓunu ɓamombukwana-donu pa imoti na ɓomikunu! ");
INSERT INTO lik_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Iyo, kyɛ ngbingo odokuto nɨnɔ ɓambanzʉ ɓaɓɨkya ɓanʉ mino ɓɛ: ‹Ɨgyagya ka ɓandʉya, ko ɓoko ɓi nɨɓɔ ɓakaɓʉkʉtagʉ na nɨɓɔ ɓakulungusagʉ ɓomiki!› ");
INSERT INTO lik_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ɓambanzʉ ɓapʉnga ɓanʉ kaɓɨkya ɓɛ: ‹Gwoni kʉgʉ kusu› na kaɓɨkya ɓokpumo ɓɛ: ‹Titikyoni!› ");
INSERT INTO lik_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","A ɓɛyɔ, kika nɨ ɓakogyogyiso sɨbʉkʉsɔ siɓisi ɓɛyɔ, angɛnɛngɛnɛ kʉwa nɨsɔ sikwo?» ");
INSERT INTO lik_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ɓagatʉ ndɨ gɔnɨ na ɓalʉkʉ ɓagɔgɔ ɓaɓa, ɓagya-manyɛ ɓi, kaʉmwɔ pa imoti na Yeso. ");
INSERT INTO lik_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Nɨyɔ ɓosila ndɨ mino ka pa nɨyɔ ɓalɨkyaga ɓɛ «Ɨkpʉkpʉkʉsɔ sa Mʉ», ɓasʉda ɓabangɨlaga ndɨ Yeso ka mʉsalaba, ɓʉbangɨlaga gɔnɨ ɓagya-manyɛ, ɓemoti ka kʉmbanzɨkanɨkɔ, wagɔgɔ ka kulekuke. ");
INSERT INTO lik_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yeso aka ndɨ ɓɛ: «Baba ooo, hʉpɨlyanɔ ɓaka kyɛ ɓakɛgʉ kaiba nɨlɔ ɓakagya.» Ɓatwa kʉwa ndɨ lɨɓɛsɛ ko bulya yɨgbananaga ɓotu kakɨ. ");
INSERT INTO lik_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ɓambanzʉ ɓa ndɨ ɓakamanana wa ɓigwo, ɓanɨna lɨkpʉmʉka nɨlɔ. Ɓangama ka Ɓayuda ɓa ndɨ katɨba ɓɨkyaaa, ɓanaɓɨkya ɓɛ: «Uhukusa ndɨ ɓatʉ ɓagɔgɔ. Ihukusinɔ kʉwa ɨyɨ mombukwana-dakɨ, kika nɨ ɨyɨ nɨ Kilisito nɨnɔ Kunzi apʉnaga ndɨ.» ");
INSERT INTO lik_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ɓasʉda ɓa ndɨ gɔnɨ katɨba, ɓisisiloku ɓuwobi na ɨyɨ, ɓapá ndɨ vinya wozyo, ");
INSERT INTO lik_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ɨɓʉ aka ɓɛ: «Kika nɨ wa ngama ka Ɓayuda, wihukuso nɛkɨ mombukwana-dakɨ yi!» ");
INSERT INTO lik_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ɓokpika ndɨ ka mʉsalaba kakɨ ɓɛ: «Mʉtʉ yi nɨmʉna nɨ ngama ka Ɓayuda.» ");
INSERT INTO lik_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ɓemoti luga ka ɓagya-manyɛ nɨɓɔ ɓʉbangɨlaga ndɨ ka mʉsalaba ɓɔ a ndɨ katʉmbwa Yeso, anaɓɨkya ɓɛ: «Kɛgʉ mbɛyɨ ɨwɛ nɨ Masiya? Wihukusa nɛkɨ ɨwɛ mombukwana-dakɨ, watihukusa kʉwa gɔnɨ iɓusu!» ");
INSERT INTO lik_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Luki limoti nɨnɔ wagɔgɔ nɔ apamyaga, ɨyɨ aka ɓɛ: «Ɨwɛ mʉnaaa, wakɛgʉ gʉtʉgʉ kaɓanga Kunzi aka, ɨwɛ nɨnɔ wakaigyogyisa mʉɗɔngɔnɨ abɛ ɨyɨ? ");
INSERT INTO lik_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Iɓusu, ɓakatigyogyiso ka ɓungbingbili. Takainisana na mʉkalya nɨmɔ okwononi na yɨgya yanyɛ kusu. Luki limoti, ɨyɨ kagyagʉ ndɨ ɓʉnyɛ gʉtʉgʉ ɓumoti aka.» ");
INSERT INTO lik_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Kumbuso yi omotiloku ɓɛ: «Yeso, wakeɓusolonitɔgʉ ɓaka ngbingo yi nɨnɔ wodoku ndɛkɛ mino ka Ɓʉngama kakʉ.» ");
INSERT INTO lik_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yeso amigisya ɓɛ: «A lɨngʉnʉ, nakaʉɓɨkya ambɛ, na lɨsyɛ li nɨlɨ takaiko pa imoti na ɨwɛ ka Paladiso.» ");
INSERT INTO lik_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","A ndɨ banda saa sita, biti ohuma ɔɓɨlɨ wasɨ kadwɛ ka saa tisa. ");
INSERT INTO lik_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Mɔnɨ olimika ndɨ, kutuko nɨkwɔ ikaga ndɨ kubongiso kagbanana pa yotu na pa yotu kʉgbɛ kʉ ka Ndaɓʉ ko Kunzi, anʉɨka ndɨ lugo. ");
INSERT INTO lik_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yeso igomisa ndɨ na lɨyʉ lapʉ ɓɛ: «Baba ooo, nigisini lɨmbɛngɨ kamɨ ka maɓɔkʉ kakʉ.» Nɨyɔ aɓɨkya ɓɛyɔ, osisa lɨmbɛngɨ. ");
INSERT INTO lik_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Nɨyɔ ngama ka ɓasʉda ɨna nɨlɔ igyonosa ndɨ lɔ, abibisa Kunzi, ɨyɨ aka ɓɛ: «Ka lɨngʉnʉ, mʉtʉ yi nɨmʉna a ndɨ asɨ mʉtʉ wongbingbili aka!» ");
INSERT INTO lik_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ambaza wasɨ ka ɓambanzʉ nɨnɔ odoku ndɨ kaɨna lɨkpʉmʉka nɨlɔ, ɨga kʉwa ndɨ nɨ otumini no kumbu ɓɨɗɛ. ");
INSERT INTO lik_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ɓawai-dakɨ Yeso ɓasɨ, gʉtʉgʉ ɓoko aka nɨɓɔ ɓodoku ndɨ kabiso kotukyoku ka Galilaya, ɓamaga ndɨ ɓyɨ kaɨna lɨkpʉmʉka nɨlɔ a ndɨ kaigyonoso lɔ. ");
INSERT INTO lik_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","A ndɨ na alʉkʉ ɓemoti nɨnɔ ɨɓʉkʉta ndɨ ka Alimatia, ka iwili ya Yudɛa, ina ndɨ ɓɛ Yɛzɛfʉ. A ndɨ ɓemoti ka ɓambɔkʉ-mbɔkʉ niɓɔ ɓakɔgɔ ndɨ mʉkɔmbʉ ka ɓambanzʉ ka Basa-Yidingi. A ndɨ mʉtʉ wa lɨmbɛngɨ lanza, ɔɓɨlɨ kakɨ a ndɨ ɓingbingbili, aɓʉndaga ndɨ Ɓʉngama ko Kunzi. Luki limoti, koɓingisyagʉ ndɨ ɨyɨ nɨlɔ ɓɛngɛnɨ ɓa ndɨ nɨ ɓoɓikyini na nɨlɔ ɓagya ndɨ kʉgʉ ka Yeso. ");
INSERT INTO lik_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Aga ndɨ ka Pilatʉ kakʉnga manda ka Yeso. ");
INSERT INTO lik_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Kumbuso yi, atotisa ndɨ ka mʉsalaba, atikyogo na kutuko kwa hʉɗʉ-hʉɗʉ, abisa ka mbʉkʉ nɨyɔ ɓakpɔ ndɨ ka lɨtalʉ. Mbʉkʉ yi nɨyɔ a ndɨ nɨ ɓakanalumbigʉ mino mʉmbanzʉ gʉtʉgʉ ɓemoti aka. ");
INSERT INTO lik_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","A ndɨ lɨsyɛ la kuɓukumuti, nɨlɔ ɓambanzʉ ɓiɓungusyaga ndɨ mino ko bulya Lɨsyɛ la kimumbiso. ");
INSERT INTO lik_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Kʉwa wa ɓoko ɓi nɨɓɔ ɓodoku ndɨ na Yeso katʉkya ka Galilaya, ɓaɓyɛ Yɛzɛfʉ. Ɓɨna mbʉkʉ na ɓɛyɔ ɓongosa ndɨ mino manda ka Yeso. ");
INSERT INTO lik_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Kumbuso yi, ɓɨganana ndɨ, ɓoɓungusyogo molingo na malazi ko bulya manda. Lɨsyɛ la kimumbiso, ɓolipyaga nɨ ɓakogyigʉ ligubo mʉɗɔngɔnɨ ɓɛyɔ mʉtʉʉ ka Musa ikpika ndɨ mino. ");
INSERT INTO lik_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Kʉwa ka lɨsyɛ la Mungu ko mbolugo, ɓoko ɓava malazi dididi nɨmɔ ɓoɓungusyaga ndɨ, ɓaga ka mbʉkʉ. ");
INSERT INTO lik_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ɓatakanya lɨtalʉ lidingi nɨlɔ otikya ndɨ mbʉkʉ nɨ ɓotini ka kpɔlɔ. ");
INSERT INTO lik_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ɓogulya ndɨ, luki limoti nɨ ɓakotokonyigʉ ɓata manda ka Mombukwono-dosu Yeso. ");
INSERT INTO lik_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ngbingo yi nɨnɔ ɓa ndɨ mino kombomboya nɔ, ɓalʉkʉ ɓaɓa ɓakimokisyo ɓotu ɓayawenge-wenge ɓupuponilya ndɨ, ɓamaga ka kpɔlɔ kaɓʉ. ");
INSERT INTO lik_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Nɨyɔ ɓoko ɓogwa kʉɓangakʉ bɛyɔ, ɓodidika ndɨ. Ɓalʉkʉ ɓi nɨɓɔ aka na ɨɓʉ ɓɛ: «Ko bulya ɨkɨ yɔ mo mino kakɨsa mʉtʉ yi nɨnɔ a muɓisi luga wa ɓamanda? ");
INSERT INTO lik_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Kɛgʉ wanʉ, opupini ka mbʉkʉ. Tomononi lɨkpʉmʉka nɨlɔ amʉɓɨkya ndɨ ngbingo yi nɨnɔ a ndɨ mino ka Galilaya ɓɛ: ");
INSERT INTO lik_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‹Okwononi ɓɛ ɓasʉtɨ Mika-mʉmbanzʉ ka maɓɔkʉ ka ɓatʉ ɓanyɛ, ɓabangɨlaga ka mʉsalaba, kumbusa wa masyɛ masaa, opupa ka mbʉkʉ.›» ");
INSERT INTO lik_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ɓoko ɓatamana kʉwa ndɨ lɨkpʉmʉka nɨlɔ Yeso aɓɨkya ndɨ lɔ. ");
INSERT INTO lik_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ɓatʉkya ndɨ ka mbʉkʉ, ɓaga kapága mongoni mi nɨmɔ ka ɓaɓɨɓya tɛkɛɓɛ na ɓemoti na ka ɓatʉ ɓagɔgɔ ɓasɨ. ");
INSERT INTO lik_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","A ndɨ wa nɨ Malia wa Magadala, Yuana na Malia amakɨ Yakɔbɔ. Ɓoko ɓagɔgɔ nɨɓɔ ɓa ndɨ gɔnɨ pa imoti na ɨɓʉ ɓʉtʉmbʉlyaga ndɨ ɓatʉtʉmbwa mongoni nɨmɔ ɓɛgɛyɔ. ");
INSERT INTO lik_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Luki limoti ɓatʉtʉmbwa ɓa ndɨ kasɨma ɓɛ ɓoko ɓakagya ɓakpɨɓa, kanɨ ɓakoɓinikyonɨgʉ. ");
INSERT INTO lik_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Kʉwa wa Pɛtɛlɛ atʉkya ndɨ, aga mbangʉ ka mbʉkʉ, aɓɨmya, ɨna asɨ ɓapanga ɓaya ɓotu aka. Kumbuso yi ɨga kʉ kakɨ, otumini na ombombo ɓɨɗɛ ko bulya lɨkpʉmʉka nɨlɔ igyonosa ndɨ lɔ. ");
INSERT INTO lik_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ka lɨsyɛ nɨlɔ aka lɔ, ɓaɓɨɓya ɓaɓa luga ka ɓaɓɨɓya ka Yeso ɓa ndɨ kaɨnda ka mugi mimoti nɨmɔ ɓalɨkyaga ndɨ ɓɛ Emausi. Mugi mi nɨmɔ a ndɨ banda kilomɛtɛlɛ tɛkɛɓɛ na imoti kadwɛ ka Yelusalɛma. ");
INSERT INTO lik_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ɓa ndɨ kanzɨna luga kaɓʉ ko bulya lɨkpʉmʉka lasɨ nɨlɔ igyonosa ndɨ lɔ. ");
INSERT INTO lik_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ngbingo yi nɨnɔ ɓa ndɨ mino kanzɨna na kaɨnzɨnzɨnya luga kaɓʉ ɓɛyɔ, Yeso mombukwana-dakɨ yi ukpuɗoku ndɨ, ɓɨsʉngya na ɨɓʉ. ");
INSERT INTO lik_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ɓaɓɨɓya ɓatʉ ndɨ kamɨna yi, luki limoti misa kaɓʉ a ndɨ nɨ upiini ɓipi nɨ ɓakɛgʉ kamibo. ");
INSERT INTO lik_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yeso umuusa ɓɛ: «Lɨkpʉmʉka tino lɔ mo mino kaɨnzɨnzɨnya ko pisi ɓɛnɛ?» Ɓamaga kʉwa ndɨ, ɓotumini no kumbu ɓɨɗɛ. ");
INSERT INTO lik_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ɓemoti luga kaɓʉ nɨnɔ ina ndɨ Kɔlɔpasɨ, asikisya ɓɛ: «Ɨwɛ mʉkaka aka nɔ luga ka ɓatʉ ɓa Yelusalɛma wakukonigʉ lɨkpʉmʉka li nɨlɔ igyonosi ɓi kʉ ka masyɛ mi nɨma?» ");
INSERT INTO lik_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Kumbuso yi umuusa ɓata ɓɛ: «Lɨkpʉmʉka tina sɛ?» Ɓaɓɨɓya ɓasikisya ɓɛ: «Lɨkpʉmʉka li nɨlɔ asilyi ɓi Yeso mʉtʉ wa Nazalɛtɨ, nɨnɔ a ndɨ mugyalandʉ wo ngu. Owonisila ndɨ ngu ya ɓugyalandʉ ko pisi ya yɨgya na mʉnzɨna kakɨ kambwa ko Kunzi na ko misa ka ɓambanzʉ ɓasɨ. ");
INSERT INTO lik_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Luki limoti ɓokumu-kumu na ɓangama kusu ɓasʉta ndʉkʉ ka Pilatʉ ɓɛ ɓamwɨ, ɓabangɨlaga ndʉkʉ ka mʉsalaba. ");
INSERT INTO lik_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Iɓusu ta ndɨ kasɨma ambɛ ɨyɨ nɔ Kunzi atikoku kaʉkʉlaga Ɓezaleli ka ɓubaya. Luki limoti, na lɨsyɛ li nɨlɨ a kʉwa masyɛ masaa wa lɨkpʉmʉka li nɨlɔ igyonosi ɓi mino. ");
INSERT INTO lik_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Luki limoti, ɓoko ɓemoti-ɓemoti ka mʉɗɔngɔ kusu ɓatigugumisito nzʉyɨ kʉgbɛ. Ɓoga na lɨsyɛ li nɨlɨ ko mbolugo ka mbʉkʉ, ");
INSERT INTO lik_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","luki limoti nɨ ɓakotokonyigʉ ɓata manda kakɨ. Ɓigoku katɨtʉmbʉlyaga ɓɛ ɓamalaika ɓupupilyi, ɓʉtʉmbʉlyaga ɓɨngbanganya ɓɛ a muɓisi. ");
INSERT INTO lik_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Kʉwa wa ɓambanzʉ ɓemoti-ɓemoti luga kusu ɓɨnda ka mbʉkʉ, ɓatakanya makpʉmʉka masɨ mʉɗɔngɔnɨ ɓɛyɔ ɓoko ɓʉɓɨkya ndɨ mino, luki limoti kanɨ ɓakaminigʉ ɓata Yeso.» ");
INSERT INTO lik_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Kʉwa wa Yeso ʉɓɨkya ɓɛ: «Iɓunu ɓongingi aaa, ma ɓuti ka baɨlya makpʉmʉka masɨ nɨmɔ ɓogyalandʉ kaɓɨkyaga ndɨ! ");
INSERT INTO lik_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Kakwananɨgʉ mbɛyɨ ndɨ ɓɛ Masiya igyogyisi ɓɛyɔ kambwa kaingya ka ɨbɨba kakɨ?» ");
INSERT INTO lik_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Kumbuso yi ʉtʉmbʉlyaga ndɨ nɨlɔ ɓa ndɨ nɨ ɓokpikini ko bulya kakɨ ka Moɓiso masɨ ko Kunzi. Apʉnga mbɛyɨ ndɨ na kɨtaɓʉ ka Musa, idukulogo kumbuso yi ka ɓakɨtaɓʉ ɓayasɨ nɨɓayɔ ka ɓogyalandʉ. ");
INSERT INTO lik_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Nɨyɔ ɓosila ɓuwobi na mugi mi nɨmɔ ɓaɓɨɓya ɓa ndɨ mino kaɨnda, Yeso agya ndɨ abɛ anʉsaga. ");
INSERT INTO lik_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Luki limoti ɓotiwolya kaɓɨkya ɓɛ: «Tikini na iɓunu wanʉ kyɛ a kʉwa ɓʉgɔgɔ, biti ika gɔnɨ kolipyo.» Ingya kʉwa ndɨ ka ndaɓʉ, ika pa imoti na ɨɓʉ kʉ. ");
INSERT INTO lik_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Nɨyɔ ɓa kʉwa ndɨ kalyalya, ava mukati, abibisa Kunzi. Kumbuso yi, oɓunonogo, ʉpá. ");
INSERT INTO lik_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Kʉwa wa miso uukwikona ndɨ, ɓamibo, luki limoti ko ngbingo yi nɨnɔ aka nɔ ulimikya ndɨ pɛlɛ. ");
INSERT INTO lik_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ɓaɓɨkyana ndɨ ɓɛ: «Iyo, mambɛngɨ o ɓi na iɓusu ɓɨsamʉ-samʉ ngbingo yi nɨnɔ o ɓi mino kanzɨna na iɓusu ko pisi na katɨtʉmbʉlyaga Moɓiso ko Kunzi!» ");
INSERT INTO lik_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ko ngbingo yi nɨnɔ aka nɔ ɓatʉkya, ɓɨga ndɨ ka Yelusalɛma. Nɨyɔ ɓosila kʉ, ɓʉtakanya ɓaɓɨɓya tɛkɛɓɛ na ɓemoti ɓʉmʉmʉkana pa imoti na ɓatʉ nɨɓɔ ɓa ndɨ kaɓɨɓya Yeso. ");
INSERT INTO lik_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ɨɓʉ ɓasɨ ɓʉɓɨkya ndɨ ɓaɓɨɓya ɓaɓa ɓi nɨɓɔ ɓɛ: «A lɨngʉnʉ, Mombukwono-dosu opupini ka mbʉkʉ, apuponilyito Simoni!» ");
INSERT INTO lik_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Kʉwa wa ɨɓʉ ɓʉtʉmbʉlyaga ndɨ gɔnɨ lɨkpʉmʉka lasɨ nɨlɔ igyonosa ndɨ nɨ ɓa ko pisi, na ɓɛyɔ ɓamiba ndɨ mino Yeso ko ngbingo yi nɨnɔ a ndɨ mino koɓunonaga mukati. ");
INSERT INTO lik_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ko ngbingo yi nɨnɔ ɓaɓɨɓya ɓaɓa ɓi nɨɓɔ ɓa ndɨ mino kanzɨna ɓɛyɔ, Yeso mombukwana-dakɨ yi opuponoku ɓigbututu, ʉɓɨkya ɓɛ: «Mazɨyɔ iki pa imoti na iɓunu!» ");
INSERT INTO lik_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ɓotuma ndɨ na kʉɓangakʉ, kyɛ ɓa ndɨ kasɨma ɓɛ ɓaminini abɨlɨ. ");
INSERT INTO lik_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Luki limoti Yeso ʉɓɨkya ɓɛ: «Ko bulya ɨkɨ yɔ makombomboyo? Ko bulya ɨkɨ yɔ ma mino na ɓotumo ka mambɛngɨ? ");
INSERT INTO lik_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Winoni magʉ na maɓɔkʉ kamɨ: Ɨmɨ aka nɔ ɓɨkpɛ! Ivilogoni, mɛndaga, kyɛ abɨlɨ kɛgʉ na nzʉyɨ no kuwo mʉɗɔngɔnɨ ɓɛyɔ mo mina kɛmɨna ɓɛnɛ.» ");
INSERT INTO lik_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","A ndɨ kaɓɨkya ɓɛyɔ nɨ anʉwanya maɓɔkʉ na magʉ. ");
INSERT INTO lik_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ɓaɓɨɓya ɓotuma ndɨ na magyagya ɓɨɗɛ, ɓombombaya ndɨ kʉgbɛ, ɓakakwananagʉ ndɨ kabaɨlya ɓɛ Yeso nɔ akanzɨna nɔ. Kʉwa wa umuusa ɓɛ: «Makɛgʉ no luki lɨlya wanʉ?» ");
INSERT INTO lik_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ɓapá ndɨ dongbu ya musi mukongo. ");
INSERT INTO lik_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Yeso ava ndɨ, alya ko misa ka ɓʉ. ");
INSERT INTO lik_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Kumbuso yi ʉɓɨkya ɓɛ: «Ngbingo yi nɨnɔ na mbɛyɨ ndɨ mino luga kunu, namʉɓɨkya ndɨ ɓɨngbanganya ambɛ: ‹Okwononi ɓɛ masɨ nɨmɔ ikpikaga ndɨ kʉgʉ kamɨ ka Mʉtʉʉ ka Musa, ka moɓiso ka ɓogyalandʉ, ka Mambʉ ka Ɓayuda akwanana ndɨ ɓɛ igyonosi.›» ");
INSERT INTO lik_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Kʉwa wa uhukwa ndɨ yimibo kyɛ ɓʉkanɨ nɨlɔ a ka Moɓiso. ");
INSERT INTO lik_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ʉɓɨkya ɓɛ: «Ikpika ka Moɓisa ɓɛ: ‹Masiya igyogyisatʉ, opupa ka mbʉkʉ kumbusa wa masyɛ masaa.› ");
INSERT INTO lik_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Okwononi kaʉɓɨkyaga ɓɛvananza ɓayasɨ Mongoni Manza ko lino kakɨ, kapʉnga ɓanʉ ka Yelusalɛma kyɛ ɓambanzʉ ɓoyikoni, ɓinisonisa na mʉpɨlya. ");
INSERT INTO lik_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Iɓunu ɓɔ ma ɓadɛmʉ ɓa lɨkpʉmʉka nɨlɔ. ");
INSERT INTO lik_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Na ɨmɨ, mombukwana-dakɨ namʉtɨkɨlyatʉ Lɨmbɛngɨ-Lotu nɨlɔ Baba amʉwanyaga ndɨ. Luki limoti, wikoni ka Yelusalɛma aka kadwɛ ko ngbingo yi nɨnɔ motumo mino no ngu kotukyoku kʉgʉ wa lɨsyɛ.» ");
INSERT INTO lik_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Kumbuso yi, Yeso aga ndɨ na ɓaɓɨɓya kakɨ kunzi wa Yelusalɛma ɓuwobi na mugi mi nɨmɔ ina ndɨ ɓɛ Betania. Kʉ ɓɛyɔ, ubisilya maɓɔkʉ, uɗukilya ndɨ ɓʉɓʉnga. ");
INSERT INTO lik_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ko ngbingo yi nɨnɔ a ndɨ mino kauɗukilyo ɓʉɓʉnga nɔ, asanana na ɨɓʉ, aɗaka ndɨ kʉgʉ wa lɨsyɛ. ");
INSERT INTO lik_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Kumbuso yi ɓabibisa kʉwa ndɨ, ɓɨganana ka Yelusalɛma kanɨ ɓotumini na magyagya ɓɨɗɛ. ");
INSERT INTO lik_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Kʉ ɓɛyɔ, ɓikaga ndɨ ɓongbinga ɓasɨ ka Ndaɓʉ ko Kunzi, ɓanabibiso.");
INSERT INTO lik_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ka mʉpʉnganagɨ, kambwa Kunzi kagya ɔɓɨlɨ, Mʉnzɨna a kʉwa ndɨ wa. Mʉnzɨna a ndɨ pa imoti no Kunzi. Mʉnzɨna a ndɨ Kunzi ɓɨkpɛ. ");
INSERT INTO lik_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","A ɓɛyɔ, Ɨyɨ a ndɨ pa imoti no Kunzi ka mʉpʉnganagɨ. ");
INSERT INTO lik_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Kunzi agya ndɨ makpʉmʉka masɨ pisi ka mʉnzɨna aka, kɛgʉ no luki gʉtʉgʉ limoti aka nɨlɔ kigyonosagʉ ndɨ pisi ka mʉnzɨna. ");
INSERT INTO lik_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ɔɓɨlɨ opupa ndɨ ka Mʉnzɨna. Ɔɓɨlɨ yi nɨnɔ ʉpága ɓambanzʉ ɓʉngbanganya. ");
INSERT INTO lik_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ɓʉngbanganya ɓi nɨɓɔ anzɛgɛ ko biti, luki limoti biti kahumagʉ ndɨ. ");
INSERT INTO lik_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","A ndɨ na mʉtʉ ɓemoti nɨnɔ Kunzi atikoku ndɨ. Mʉtʉ yi nɨnɔ ina ndɨ ɓɛ Yuani. ");
INSERT INTO lik_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Odoku ndɨ abɛ dɛmʉ wa ɓʉngbanganya ɓi nɨɓɔ kyɛ ɓambanzʉ ɓasɨ ɓaɓɨnɨkyanɨ ɓʉngbanganya pisi ka mʉtʉʉ kakɨ. ");
INSERT INTO lik_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ɨyɨ ɓɨkpɛ kɛgʉ ndɨ ɓʉngbanganya, luki limoti, odoku ndɨ kaiko dɛmʉ wa ɓʉngbanganya ɓi nɨɓɔ. ");
INSERT INTO lik_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ɓʉngbanganya ɓi nɨɓɔ a nɨɓɔ ɓa lɨngʉnʉ. Odoku ndɨ ka ɔɓɨlɨ kauzigo ɓatʉ ɓasɨ. ");
INSERT INTO lik_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Mʉnzɨna a ndɨ ka ɔɓɨlɨ. Kunzi agya ndɨ ɔɓɨlɨ pisi ka mʉnzɨna mi nɨmɔ, luki limoti, ɓatʉ ɓa ɔɓɨlɨ ɓakamibagʉ ndɨ. ");
INSERT INTO lik_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Mʉnzɨna odoku ndɨ kʉ kaɓʉ ɓɨkpɛ, luki limoti, nɨ ɓava-kʉkakɨ ɓakatilyigʉ. ");
INSERT INTO lik_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Luki limoti, ɓatʉ ɓemoti-ɓemoti ɓatɨlyatʉ ndɨ, ɓaɓɨnɨkyana. Nɨɓɔ ɓaɓɨnɨkyana ndɨ, ʉpá kʉwa ngu kaiko ɓomiko Kunzi. ");
INSERT INTO lik_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ɓatʉ ɓi nɨɓɔ ɓakɨɓʉkʉtagʉ abɛ ɓomiko Kunzi pisi ka ɓangʉ, ikanɨ ka nzʉyɨ, ɨkanɨ ɓɛyɔ ɓambanzʉ ɓɨɓʉkʉtaga mino, luki limoti ɓɨɓʉkʉta no Kunzi. ");
INSERT INTO lik_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Mʉtʉ yi nɨnɔ ɓa ndɨ kamaka ɓɛ Mʉnzɨna nɔ ɨɨta ndɨ mʉmbanzʉ. Mʉmbanzʉ yi nɨnɔ odoku ndɨ kaiko luga kusu, otumini na ɨzɨyɔ na lɨngʉnʉ ɓɨɗɛ. Tɨna ndɨ ɨbɨba kakɨ, ɨbɨba yi nɨyɔ Kunzi apá ndɨ Mikakɨ wa ɓemoti. ");
INSERT INTO lik_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yuani nɔ a dɛmʉ kakɨ, atʉɓɨlagatʉ ndɨ ɓɛ: «Na ndɨ kanzɨna ko bulya kakɨ ngbingo yi nɨnɔ naɓɨkya ndɨ mino ɓɛ: ‹Mʉtʉ yi nɨnɔ akodoku kumbuso kamɨ a mʉtʉ mudingi kʉgbɛ kɛkɨtaga. A ɓɛyɔ, kambwa wa kɨɓʉkʉta kamɨ, ɨyɨ a kʉwa ndɨ wa.›» ");
INSERT INTO lik_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Iɓusu ɓasɨ tinisanatʉ ndɨ na ɨzɨyɔ kakɨ, totumaga ndɨ ɓasɨ na ɓʉɓʉnga kakɨ ɓakpʉ kakɨtanaga. ");
INSERT INTO lik_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","A ɓɛyɔ, Kunzi apá ndɨ Mʉtʉʉ pisi ka Musa, luki limoti, ɨzɨyɔ na lɨngʉnʉ odoku ndɨ pisi ka Yeso-Kilisito. ");
INSERT INTO lik_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Mʉmbanzʉ gʉtʉgʉ ɓemoti aka kanaminigʉ Kunzi. Luki limoti, mʉtʉ yɨkaka nɨnɔ atimibisisa ndɨ Kunzi nɨ Mikakɨ wa ɓemoti. Ɨyɨ miki yi nɨnɔ a Kunzi, ikaga pa imoti no Kunzi. ");
INSERT INTO lik_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Mʉtʉmbʉlagɨ ka Yuani-Mubatizaɨ nɨma ngbingo yi nɨnɔ Ɓayuda ɓatikilyoku ndɨ mino ɓokumu na Ɓalawi kotukyoku ka Yelusalɛma kamuusa ɓɛ: «Ɨwɛ nɨ wanɨ?» ");
INSERT INTO lik_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yuani kanganyagʉ ndɨ, luki limoti, osikisya ndɨ ɓɨngbanganya kambwa ka ɓatʉ ɓasɨ ɓɛ: «Nakɛgʉ ɨmɨ Kilisito.» ");
INSERT INTO lik_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ɓamuusa ndɨ ɓɛ: «Wa nɛkɨ wanɨ? Ɨwɛ nɨ Ɨlɨya?» Yuani usikisya ndɨ ɓɛ: «Kalɨ, nakɛgʉ ɨmɨ ɨyɨ.» Ɓamuuso ɓata ndɨ ɓɛ: «Wa mugyalandʉ?» Ɨyɨ aka ɓɛ: «Kalɨ.» ");
INSERT INTO lik_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Kʉwa wa, ɓaɓɨkya ɓɛ: «Ɨwɛ sɛ kʉwa nɨ wanɨ? Tɨɓɨkya kyɛ okwononi tɨgɨ kausikisyo ɓatʉ nɨɓɔ ɓatitikiku. Wa pɨyɛ kaɓɨkya ɓʉ ko bulya kakʉ ɓɨkpɛ?» ");
INSERT INTO lik_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yuani usikisya kʉwa ndɨ ɓɛ: «Ɨmɨ nɨ mʉtʉ yi nɨnɔ akatʉɓɨlaga ka ɨsa ɓɛ: ‹Nononi pisi ka Mombukwono-dosu,›» mʉɗɔngɔnɨ ɓɛyɔ mugyalandʉ Isaya aɓɨkya ndɨ mino. ");
INSERT INTO lik_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ɓafalisayɔ ɓatʉ ndɨ gɔnɨ luga ka ɓatʉ nɨɓɔ ɓutikoku ndɨ ka Yuani. ");
INSERT INTO lik_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ɓamuusa ndɨ ɓɛ: «Kika nɛkɨ nɨ wakɛgʉ Kilisito, ikanɨ Ɨlɨya, ikanɨ mugyalandʉ, ko bulya ɨkɨ yɔ wo mino koɓotiso?» ");
INSERT INTO lik_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Usikisya ndɨ ɓɛ: «Ɨmɨ, nakamuɓotiso no liɓo. Luki limoti, atʉ na mʉtʉ ɓemoti luga kunu nɨnɔ makamibigʉ. ");
INSERT INTO lik_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Mʉtʉ yi nɨnɔ akodoku kumbuso kamɨ. Ɨmɨ, nakokwononigʉ gʉtʉgʉ kakʉla ligi ya ɓɛkpakʉ kakɨ aka.» ");
INSERT INTO lik_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Masɨ nɨma akɨtanaga ndɨ ka Betania, kʉsyakʉ wa Yɔlɔdanɨ, kʉ Yuani oɓotisaga ndɨ mino. ");
INSERT INTO lik_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ɓʉgalo ɓi, Yuani amɨna ndɨ Yeso nɨ anodoku, aɓɨkya ɓɛ: «Mikya-Kɔndɔlɔ ko Kunzi nɨnɔ atʉmbaga ɓʉnyɛ ka ɓambanzʉ nɨmʉ. ");
INSERT INTO lik_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Na ndɨ kanzɨna kʉgʉ kakɨ ngbingo yi nɨnɔ naɓɨkya ndɨ mino ɓɛ: ‹Mʉtʉ yi nɨnɔ akodoku kumbuso kamɨ, a mʉtʉ mudingi kʉgbɛ kɛkɨtaga. A ɓɛyɔ, kambwa wa kɨɓʉkʉta kamɨ, ɨyɨ a kʉwa ndɨ wa.› ");
INSERT INTO lik_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ɨmɨ ɓɨkpɛ, nakamibogigʉ ndɨ. Luki limoti, nodoku ndɨ koɓotiso no liɓo kyɛ namibisisi na ɓatʉ ɓasɨ ɓa Izaleli.» ");
INSERT INTO lik_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yuani ʉtʉmbʉlyaga ndɨ nɨlɔ ɨna ndɨ ɓɛ: «Nɨna ndɨ Lɨmbɛngɨ-Lotu kosyoku kʉgʉ wa lɨsyɛ mʉɗɔngɔnɨ abɛ likpondi. Lɨmbɛngɨ li nɨlɔ ika ndɨ kʉgʉ ka Yeso. ");
INSERT INTO lik_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ɨmɨ, nakɛgʉ ndɨ kamibo. Luki limoti, Kunzi nɨnɔ etikoku ndɨ koɓotiso no liɓo, ɛɓɨkya ndɨ ɓɛ: ‹Wɨnatʉ ndɛkɛ Lɨmbɛngɨ-Lotu kosyoku na kaiko kʉgʉ ka mʉmbanzʉ. Mʉtʉ yi nɨnɔ nɔ oɓotisa na Lɨmbɛngɨ-Lotu.› ");
INSERT INTO lik_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nɨnatʉ ndɨ masɨ mi nɨmɔ, nakamʉtʉmbʉlyaga ɓɛ ɨyɨ nɨ Miko Kunzi.» ");
INSERT INTO lik_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Na ɓʉgala ɓi, Yuani a mbɛyɨ ndɨ ɓata wa aka wa pa imoti na ɓaɓɨɓya ɓaɓa luga ka ɓaɓɨɓya kakɨ. ");
INSERT INTO lik_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Nɨyɔ amɨna Yeso kakɨtaga, ɨyɨ aka ndɨ ɓɛ: «Mikya-Kɔndɔlɔ ko Kunzi nɨmʉ.» ");
INSERT INTO lik_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Nɨyɔ ɓaɓɨɓya ɓaɓa ɓi nɨɓɔ ɓʉkana lɨkpʉmʉka li nɨlɔ, ɓapʉnga ndɨ kaɓɨɓya Yeso. ");
INSERT INTO lik_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yeso oyikana ndɨ, ʉmɨna nɨ ɓanaɓɨɓya, ɨyɨ aka ndɨ na ɨɓʉ ɓɛ: «Makakɨsa ɨkɨ?» Ɓasikisya ɓɛ: «Labi, isi yi nɨ ‹Muwonisilo›, wikaga yanɨ?» ");
INSERT INTO lik_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Usikisya ndɨ ɓɛ: «Doniku, mɨnatʉ.» Ɓodoku ndɨ, ɓaga kaɨna pa nɨyɔ a ndɨ mino, ɓika ndɨ na ɨɓʉ na ɓʉgɔgɔ ɓi nɨɓɔ. A ndɨ banda saa-kumi. ");
INSERT INTO lik_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andɨlɨa nɨnɔ mamakɨ Simoni-Pɛtɛlɛ, a ndɨ ɓemoti ka ɓatʉ ɓaɓa ɓi nɨɓɔ ɓʉkana ndɨ mʉnzɨna ka Yuani na kaɓɨɓya Yeso. ");
INSERT INTO lik_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ɨnda mbɛyɨ ndɨ ka mamakɨ ɓɛyɔ ka Simoni, aɓikyoku ɓɛ: «Taminini ɓi Masiya», isi yi nɨ «Kilisito». ");
INSERT INTO lik_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Kumbuso yi, ɨnda kʉwa ndɨ na Simoni kʉ ka Yeso. Yeso anda ndɨ Simoni ɓizumuuu, aɓɨkya ɓɛ: «Ɨwɛ nɨ Simoni, mika Yuani. Ɓʉmakaga kʉwa ɓanʉ ɓɛ Kɛfa». Isi yo lino li nɨlɔ ɓɛ Pɛtɛlɛ. ");
INSERT INTO lik_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Na ɓʉgala ɓagɔgɔ, Yeso a ndɨ wakɨtʉlya kaɨnda ka Galilaya. Ɓabangana kʉwa ndɨ na Filipi, ɨyɨ aka na ɨyɨ ɓɛ: «Iɓyeku!» ");
INSERT INTO lik_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipi a ndɨ mʉtʉ wa gʉɗʉ wa Bɛtɛsaida kʉ Andɨlɨa na Pɛtɛlɛ ɓɨɓʉkʉta ndɨ gɔnɨ ɨɓʉ mino. ");
INSERT INTO lik_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Kumbuso yi, Filipi ɓabangana ndɨ na Natanaeli, aɓɨkya ɓɛ: «Taminini ɓi mʉtʉ yi nɨnɔ Musa okpikaga ndɨ mongoni kakɨ ka kɨtaɓʉ ya Mʉtʉʉ, na nɨnɔ ɓogyalandʉ ko Kunzi ɓokpikaga ndɨ gɔnɨ ko bulya kakɨ. Ɨyɨ nɨ Yeso wa Nazalɛtɨ, mika Yɛzɛfʉ.» ");
INSERT INTO lik_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanaeli amuusa ndɨ ɓɛ: «Luki lanza akwananatʉ gɔnɨ kopupo ka Nazalɛtɨ?» Filipi asikisya ndɨ ɓɛ: «Dawɨnɨ nɔ.» ");
INSERT INTO lik_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Nɨyɔ Yeso amɨna Natanaeli nɨ anodoku, Yeso aɓɨkya ndɨ ɓɛ: «Muizaleli walɨngʉnʉ nɨmʉ. Kɛgʉ mʉtʉ wa ɓokoli.» ");
INSERT INTO lik_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanaeli amuusa ndɨ ɓɛ: «Wemibi lɨkɨ?» Yeso asikisya ndɨ ɓɛ: «Kambwa gʉtʉgʉ Filipi kaʉmaka, numinito ɓi. Wo ɓi kusili wa sɨbʉkʉsɔ simoti ɓɛnɛ.» ");
INSERT INTO lik_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanaeli aka ndɨ ɓata na ɨyɨ ɓɛ: «Muwonisilo, ɨwɛ nɨ Miko Kunzi, ɨwɛ nɨ Ngama ka ɓomikya Ɓezaleli.» ");
INSERT INTO lik_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yeso asikisya ndɨ ɓɛ: «Woɓinikyonini kyɛ nuɓikyi ɓɛ numinito ɓi kusili wa sɨbʉkʉsɔ? Wɨnatʉ ɓanʉ ɓata makpʉmʉka mʉmbanga-mbanga kʉgbɛ!» ");
INSERT INTO lik_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Omotiloku ɓɛ: «A lɨngʉnʉ, a lɨngʉnʉ, nakamʉɓɨkya ambɛ, mɨnatʉ ndɛkɛ lɨsyɛ nɨ oukwikonini, ɓamalaika ko Kunzi ɓanaɗaka, ɓonosyo kʉgʉ ko Mika-mʉmbanzʉ.» ");
INSERT INTO lik_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Kumbusa wa masyɛ maɓa, dumo wa ndʉwa a ndɨ ka Kana, kʉ ka Galilaya. Amakɨ Yeso a ndɨ kʉ gɔ kʉ. ");
INSERT INTO lik_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ɓamaka ndɨ gɔnɨ Yeso na ɓaɓɨɓya kakɨ ko dumo yi nɨnɔ. ");
INSERT INTO lik_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Nɨyɔ vinya osyo, amakɨ Yeso aɓɨkya ndɨ Yeso ɓɛ: «Ɓambanzʉ ɓakɛgʉ ɓata na vinya.» ");
INSERT INTO lik_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Luki limoti, Yeso asikisya ndɨ ɓɛ: «Yɛ ma, nɨlɔ kusu na ɨwɛ ogwi ɓʉ? Ngbingo kamɨ kanitulyonigʉ mbɛyɨ.» ");
INSERT INTO lik_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Amakɨ ʉɓɨkya kʉwa ndɨ ɓagya-ligubo ɓɛ: «Gyoni masɨ nɨmɔ amʉɓɨkya.» ");
INSERT INTO lik_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Wa ɓɛyɔ, a ndɨ na ɓambɨkɛ ɓayakpʉkpʉ maɗɨya nɨɓɔ ɓagya ndɨ na matamʉ. Kʉsɔ yi, Ɓayuda ɓobisaga ndɨ mino moɓo nɨmɔ ɓiɓuɓisaga ndɨ nomu kaɓyɛnɛnɛ na yɨgya kaɓʉ. Mbɨkɛ yimoti akwanana ndɨ kaingyo ɓalitɛlɛ ɓayo liɓo banda mɨya yimoti. ");
INSERT INTO lik_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yeso ʉɓɨkya ndɨ ɓagya-ligubo ɓɛ: «Tumisogoni ɓambɨkɛ ɓi nɨɓa no moɓo.» Ɓotumisaga ndɨ ɓɨkyɛɛkyɛɛ. ");
INSERT INTO lik_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Kumbuso yi, ʉɓɨkya ndɨ ɓɛ: «Tugoni mino liɓo li nɨlɨ, mapóku ngama wo dumo.» Ɓagya ndɨ ɓɛyɔ aka yɔ. ");
INSERT INTO lik_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ngama wo dumo akɨngɨla ndɨ liɓo li nɨlɔ nɨ iitini kʉwa vinya. Kɛgʉ ndɨ kaibo ɓɛ vinya yi nɨnɔ apʉnya yanɨ. Luki limoti, ɓagya-ligubo nɨɓɔ ɓatʉga ndɨ liɓo, ɓatʉ ndɨ ɨɓʉ kaiba. Ngama wo dumo amaka kʉwa alʉkʉ yi nɨnɔ agya ndɨ ndʉwa, ");
INSERT INTO lik_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ɨyɨ aka ndɨ na ɨyɨ ɓɛ: «Ko bulya ɨkɨ yɔ waɓuulyogi mino vinya wanza kadwɛ mɔnɨ ɓʉɓwanʉ? Ɓɛngɛnɨ ɓasɨ ɓapʉngaga mbɛyɨ kapá nɨnɔ wanza. Kumbuso yi, ɓakadamʉwa, ɓapá sɛ kʉwa zalamba.» ");
INSERT INTO lik_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","A lɨkpʉmʉka lɨmbanga la mambwa nɨlɔ Yeso agya ndɨ. A ndɨ ka Kana, kʉ ka Galilaya. Yeso owoniso ɨbɨba kakɨ, ɓaɓɨɓya kakɨ ɓaɓɨnɨkyana ndɨ. ");
INSERT INTO lik_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Kumbuso yi, ɓaga ndɨ ka Kapɛlɛnaumu, ɨɓʉ na amakɨ, ɓamamakɨ na ɓaɓɨɓya kakɨ. Kʉ ɓɛyɔ, ɓagya ndɨ masyɛ makɛɗɛ aka. ");
INSERT INTO lik_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Nɨyɔ yɨnga ya Pasɨka ka Ɓayuda a kʉwa ndɨ ɓuwobi, Yeso aɗaka ndɨ ka Yelusalɛma. ");
INSERT INTO lik_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Kʉ ɓɛyɔ, ʉtakanya ndɨ ɓambanzʉ ka Ndaɓʉ ko Kunzi nɨ ɓanʉgaba ɓangɔmbɛ, ɓakɔndɔlɔ na ɓonzuwo. Ɓatʉ ɓugomosyono ɓuyi ɓa ndɨ nɨ ɓikononini ka ɓamɨza kaɓʉ. ");
INSERT INTO lik_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Yeso agya ndɨ mufimbo no ligi, apʉnga kaukpumyo ɓatʉ ɓasɨ ɓi nɨɓɔ ɓa ndɨ ka Ndaɓʉ ko Kunzi, pa imoti na ɓakɔndɔlɔ na ɓangɔmbɛ kaɓʉ. Omisya ndɨ ɓuyi ka ɓogomosyono ɓuyi, utindika ɓamɨza ɓitigbo-tigbo. ");
INSERT INTO lik_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ɨyɨ aka na ɓogobiso ɓonzuwo ɓɛ: «Tumboni masɨ nɨma wanʉ, mokoitisonitɔgʉ ndaɓʉ ka Baba abɛ sɔkɔ!» ");
INSERT INTO lik_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ɓaɓɨɓya kakɨ ɓatamana ndɨ mʉgɛlɛ-gɛlɛ nɨmɔ ikpikaga ka Moɓiso Motu ɓɛ: «Mombukwono-dosu, sɨpananɨsɔ kamɨ ko bulya ndaɓʉ kakʉ ezungusini lɨmbɛngɨ ɓɨzʉʉʉ.» ");
INSERT INTO lik_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ɓayuda ɓamuusa kʉwa ndɨ Yeso ɓɛ: «Likingyosi lɨmbanga tino lɔ wakwanana katɨgyɨlya katimoniso ɓɛ wa no ngu yɨgya ɓɛyɔ?» ");
INSERT INTO lik_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yeso usikisya ndɨ ɓɛ: «Ponzoni Ndaɓʉ ko Kunzi yi nɨyɨ, nɨgɨlyatʉ kopika ka masyɛ masaa.» ");
INSERT INTO lik_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ɓayuda ɓasikisya ndɨ ɓɛ: «Ɓopika ndɨ Ndaɓʉ ko Kunzi yi nɨyɨ ka ɓyanga ɓatɛkɛɓɛ ɓakwanganya na maɗɨya, ɨwɛ, wɨgɨlya kopika ka masyɛ masaa aka?» ");
INSERT INTO lik_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Luki limoti, Ndaɓʉ ko Kunzi yi nɨyɔ Yeso a ndɨ kanzɨna ko bulya yi nɨ nzʉyɨ kakɨ. ");
INSERT INTO lik_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Kinili, ngbingo yi nɨnɔ Yeso opupoku ndɨ mino ka mbʉkʉ, ɓaɓɨɓya kakɨ ɓatamana ndɨ ɓɛ aɓɨkyatʉ ndɨ lɨkpʉmʉka li nɨlɔ. Ɓaɓɨnɨkyana kʉwa ndɨ Moɓiso na mʉnzɨna nɨmɔ Yeso aɓɨkya ndɨ. ");
INSERT INTO lik_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ngbingo yi nɨnɔ Yeso a ndɨ mino ka Yelusalɛma ka yɨnga ya Pasɨka, ɓambanzʉ ɓudingi ɓaɓɨnɨkyana ndɨ kaɨna mokingyosi mʉmbanga-mbanga nɨmɔ agyaga ndɨ. ");
INSERT INTO lik_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Luki limoti, Yeso kɨtambyagɨgʉ ndɨ na ɨɓʉ, kyɛ a ndɨ kaumibo ɨɓʉ ɓasɨ ɓɨnza. ");
INSERT INTO lik_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Kɛgʉ ndɨ kapa ɓɛ ɓatʉmbʉlyagɨ ɔɓɨlɨ ka mʉmbanzʉ gʉtʉgʉ ɓemoti aka. A ɓɛyɔ, ɨyɨ mombukwana-dakɨ ibagatʉ ndɨ nɨlɔ a ka mambɛngɨ ka ɓambanzʉ. ");
INSERT INTO lik_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Luga ka Ɓafalisayɔ, a ndɨ na mʉtʉ ɓemoti nɨnɔ ina ndɨ ɓɛ Nikodimo. A ndɨ ɓemoti ka ngama ka Ɓayuda. ");
INSERT INTO lik_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Lɨsyɛ limoti, asilyoku kʉwa ndɨ Yeso no biti, aɓɨkya ɓɛ: «Muwonisilo, takaiba ambɛ Kunzi nɔ utikoku ndɨ katiwonisilo. A ɓɛyɔ, mʉmbanzʉ kakwananɨgʉ kagya makpʉmʉka mʉmbanga-mbanga ɓɛyɔ wo mino kagya, kanɨ Kunzi kɛgʉ pa imoti na ɨyɨ.» ");
INSERT INTO lik_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yeso asikisya ndɨ ɓɛ: «A lɨngʉnʉ, a lɨngʉnʉ nakaʉɓɨkya ambɛ, mʉmbanzʉ kigilyi kaɨɓʉkʉta, kakwananɨgʉ kaɨna Ɓʉngama ko Kunzi» ");
INSERT INTO lik_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodimo amuusa ndɨ ɓɛ: «Igyonosa lɨkɨ mʉmbanzʉ kayɨɓʉkʉta ɓata nɨ a kʉwa mbɔkʉ-mbɔkʉ? Akwananatʉ ɓata kogulya ka mʉma ka amakɨ, ɨgɨlya kaɨɓʉkʉta?» ");
INSERT INTO lik_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yeso asikisya ndɨ ɓɛ: «A lɨngʉnʉ, a lɨngʉnʉ, nakaʉɓɨkya ambɛ, mʉmbanzʉ kiɓukuti ko liɓo na ka Lɨmbɛngɨ, kakwananɨgʉ kogulya ka Ɓʉngama ko Kunzi. ");
INSERT INTO lik_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Nɨnɔ ɨɓʉkʉtaga na ɓomikya-ɓambanzʉ, a mʉmbanzʉ, nɨnɔ ɨɓʉkʉtaga na Lɨmbɛngɨ ko Kunzi a lɨmbɛngɨ. ");
INSERT INTO lik_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Wakombomboyonitɔgʉ ka nɨlɔ nuɓikyi ɓɛ: ‹Wokwononi kaɨgɨlya kaɨɓʉkʉta.› ");
INSERT INTO lik_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ovivi ovivaga pa yasɨ kʉ apaga mino. Ʉkanagatʉ kukwo yi, luki limoti, wakibogigʉ ɓɛ apʉnyaga yanɨ ikanɨ ɨndaga yanɨ. Igyonosaga ɓɛgɛyɔ ka mʉtʉ wasɨ nɨnɔ ɨɓʉkʉta na Lɨmbɛngɨ ko Kunzi.» ");
INSERT INTO lik_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Kʉwa wa, Nikodimo amuusa ndɨ ɓɛ: «Lɨkpʉmʉka nɨlɔ igyonosa lɨkɨ?» ");
INSERT INTO lik_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yeso asikisya ndɨ ɓɛ: «Muwonisilo mudingi ka mugi ma Izaleli ɓɛyɔ wo mino yɔ, wakibigʉ lɨkpʉmʉka li nɨlɨ? ");
INSERT INTO lik_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","A lɨngʉnʉ, a lɨngʉnʉ, nakaʉɓɨkya ambɛ, iɓusu, taɓɨkyaga makpʉmʉka nɨmɔ tibogo, ta ɓadɛmʉ ɓa nɨmɔ tinoni. Luki limoti, iɓunu, makapagɨgʉ katɨɓɨnɨkyana. ");
INSERT INTO lik_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Makɛbaɨlyagɨgʉ gʉtʉgʉ iki yi aka ngbingo yi nɨnɔ namʉnzɨnɨlyaga mino ko bulya makpʉmʉka ma lɨtɔmbʉ. Angɛnɛngɛnɛ kʉwa ka makpʉmʉka ma kʉgʉ wa lɨsyɛ aka? ");
INSERT INTO lik_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Wɨna sɛ, kɛgʉ na mʉmbanzʉ gʉtʉgʉ ɓemoti aka nɨnɔ oɗokoni kʉgʉ wa lɨsyɛ, kiki asɨ Mika-Mʉmbanzʉ aka nɨnɔ osyoku ndɨ ɨyɨ kʉ. ");
INSERT INTO lik_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Mʉɗɔngɔnɨ ɓɛgɛyɔ Musa aɗokisa ndɨ mino nzʉka wa ngwɛyɨ kʉgʉ wa mʉngbɨngɨlɨ kʉ ka ɨsa, okwononi ɓɛ ɓaɗokisi Mika-Mʉmbanzʉ ɓɛgɛyɔ, ");
INSERT INTO lik_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","iba mʉtʉ wasɨ nɨnɔ aɓɨnɨkyana inisoni na ɔɓɨlɨ wa ɓɛnzɛ na ɓɛnzɛ. ");
INSERT INTO lik_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","A ɓɛyɔ, Kunzi apa ndɨ ɔɓɨlɨ kʉgbɛ. Kinili, apá ndɨ mino Mikakɨ wa ɓemoti, kyɛ mʉtʉ wasɨ nɨnɔ aɓɨnɨkyana koɓungogonitɔgʉ, luki limoti, inisoni na ɔɓɨlɨ wa ɓɛnzɛ na ɓɛnzɛ. ");
INSERT INTO lik_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kunzi katikokugʉ ndɨ Mikakɨ kakɔ mʉkɔmbʉ ka ɔɓɨlɨ. Luki limoti, atikoku ndɨ kahukuso yi. ");
INSERT INTO lik_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Mʉtʉ yi nɨnɔ aɓɨnɨkyana, ɓakabisigʉ na mʉkɔmbʉ. Luki limoti, nɨnɔ kaɓɨnɨkyanagʉ, ɓabisoni na mʉkɔmbʉ, kyɛ kaɓɨnɨkyanagʉ Miki wa ɓemoti ko Kunzi. ");
INSERT INTO lik_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Winoni ɓɛyɔ Kunzi akɔgɔ mino mʉkɔmbʉ: ɓʉngbanganya odonuku ndɨ ka ɔɓɨlɨ, luki limoti, ɓambanzʉ ɓapaga ɨɓʉ biti aka kakɨtaga ɓʉngbanganya kyɛ yɨgya kaɓʉ a yanyɛ. ");
INSERT INTO lik_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Mʉtʉ wasɨ nɨnɔ agyaga ɓʉnyɛ, amʉyaga ɓʉngbanganya ɓafɛ. Mʉtʉ yi nɨnɔ, amʉyaga kakpʉɗa ɓʉngbanganya, kyɛ yɨgya kakɨ yanyɛ kinisononi. ");
INSERT INTO lik_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Luki limoti, nɨnɔ agyaga lɨkpʉmʉka la lɨngʉnʉ odogoku ɨyɨ ka ɓʉngbanganya, kyɛ yɨgya kakɨ inisoni ɓɨnza ɓɛ akaɓyɛnɛnɛ na sɨpananɨsɔ ko Kunzi.» ");
INSERT INTO lik_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Kumbuso yi, Yeso na ɓaɓɨɓya kakɨ ɓaga ndɨ ka iwili ya Yudɛa. Ika ndɨ pa imoti na ɨɓʉ kʉ ɓɛyɔ ka masyɛ, anuɓotiso ɓambanzʉ. ");
INSERT INTO lik_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yuani atʉ ndɨ gɔnɨ ɨyɨ kauɓotiso ɓambanzʉ ka Ainoni, ɓuwobi na Salimu kyɛ liɓa a ndɨ lakpʉ kʉ ɓɛyɔ. Ɓambanzʉ ɓadulyogoku ndɨ, anuɓotiso. ");
INSERT INTO lik_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ko ngbingo yi nɨnɔ, ɓa mbɛyɨ ndɨ nɨ ɓakanamokyigʉ Yuani ka ligbito. ");
INSERT INTO lik_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Kʉwa wa, ɓaɓɨɓya ɓemoti-ɓemoti ka Yuani ɓapʉnga ndɨ ɓoɗongoso na Muyuda ɓemoti kʉgʉ wa yɨgya kaɓʉ ko bulya kiɓuɓiso. ");
INSERT INTO lik_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ɓɨnda ndɨ ka Yuani, ɓaɓikyoku ɓɛ: «Muwonisilo, alʉkʉ yi nɨnɔ ma ndʉkʉ na ɨɓʉ kʉsyakʉ wa Yɔlɔdanɨ, nɨnɔ watʉmbʉlaga ndɨ lɨkpʉmʉka kakɨ, a kʉwa gɔnɨ koɓotiso. Ɓatʉ ɓasɨ ɓakagbɔ kʉ o mino!» ");
INSERT INTO lik_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yuani usikisya ndɨ ɓɛ: «Kɛgʉ na mʉtʉ ɓemoti nɨnɔ akwanana kainisono no luki, kanɨ Kunzi kapágʉ ndɨ. ");
INSERT INTO lik_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Iɓunu ɓamombukwana-donu ɓi mɛmʉkanatʉ ndɨ kaɓɨkya ɓɛ: ‹Ɨmɨ, nakɛgʉ Kilisito, luki limoti, Kunzi etikoku ndɨ kambwa kakɨ.› ");
INSERT INTO lik_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Mombukwana muko nɔ ikaga mbʉnya muko. Luki limoti, wai-dakɨ mbʉnya muko nɨnɔ a ka kpɔlɔ kakɨ, anamʉkana, ogwaga magyagya kʉgbɛ ko bulya lɨyʉ ka mbʉnya muko. Kinili, na na magyagya ɓɨsɨnɨ-sɨnɨ mbɨya wanʉ. ");
INSERT INTO lik_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Okwononi ɓɛ ɨbɨba kakɨ oɓoɓoyi, nɨyɔ kamɨ agbʉwa.» ");
INSERT INTO lik_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","«Mʉtʉ yi nɨnɔ otukyiku kʉgʉ wa lɨsyɛ ukitogi ɓatʉ ɓasɨ. Nɨnɔ wa lɨtɔmbʉ a ɨyɨ mʉtʉ wa lɨtɔmbʉ aka, anzɨnaga ko bulya makpʉmʉka ma lɨtɔmbʉ. Mʉtʉ yi nɨnɔ otukyiku kʉgʉ wa lɨsyɛ ukitogi ɓatʉ ɓasɨ. ");
INSERT INTO lik_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Atʉmbʉlaga makpʉmʉka nɨmɔ ɨna ndɨ na nɨmɔ ʉkana ndɨ. Luki limoti, mʉmbanzʉ gʉtʉgʉ ɓemoti aka kaɓɨnɨkyanagɨgʉ nɨlɔ ikaga kaɓɨkya. ");
INSERT INTO lik_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Mʉtʉ yi nɨnɔ abaɨlyaga lɨkpʉmʉka kakɨ, oɓinikyononi ɓɛ Kunzi nɨ lɨngʉnʉ. ");
INSERT INTO lik_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Mʉtʉ yi nɨnɔ Kunzi atikoku, aɓɨkyaga lɨkpʉmʉka ko Kunzi, kyɛ Kunzi atumisogo na Lɨmbɛngɨ kakɨ ɓɨɗɛ. ");
INSERT INTO lik_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Baba apagatʉ Mikakɨ, asilyoni makpʉmʉka masɨ. ");
INSERT INTO lik_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Nɨnɔ aɓɨnɨkyana Miki, a na ɔɓɨlɨ wa ɓɛnzɛ na ɓɛnzɛ. Nɨnɔ akya kaɓɨnɨkyana, kinisonigʉ ndɛkɛ na ɔɓɨlɨ yi nɨnɔ. Luki limoti, ngbʉta ko Kunzi ika kʉgʉ kakɨ.» ");
INSERT INTO lik_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Nɨyɔ Yeso iba ɓɛ Ɓafalisayɔ ɓukonini ɓɛ ɨsaɓʉ ka ɓaɓɨɓya kakɨ akobwa kʉgbɛ, na akauɓotisa ɓambanzʉ kakɨtaga Yuani, ");
INSERT INTO lik_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(a ɓɛyɔ, kɛgʉ Yeso mombukwana-dakɨ nɔ uɓotisaga ndɨ, luki limoti, ɓaɓɨɓya kakɨ.) ");
INSERT INTO lik_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Atʉkya ndɨ ka Yudɛa, ɨga ɓata ka Galilaya. ");
INSERT INTO lik_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Kadwɛ kʉ ɓɛyɔ, akwanana ndɨ kakɨtaga pisi ka Samalia. ");
INSERT INTO lik_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Adwɛ kʉwa ndɨ ka gʉɗʉ ɓemoti wa Samalia, nɨnɔ ina ɓɛ Sikali, ɓuwobi no tiko nɨyɔ Yakɔbɔ apá ndɨ mikakɨ ɓɛyɔ ka Yɛzɛfʉ. ");
INSERT INTO lik_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Lɨkɔ ka Yakɔbɔ a ndɨ kʉ ɓɛyɔ. Yeso a ndɨ nɨ hupini na lɨgʉndʉ ɓɨdapaɗa, ika kʉwa ndɨ ka kpɔlɔ wa lɨkɔ. A ndɨ banda mɔnɨ ka mʉsɨkatʉ. ");
INSERT INTO lik_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Waɓasamalia odoku ndɨ katʉga liɓo, Yeso aɓɨkya ɓɛ: «Yɛ ma, imusanɔ ɓaka mino liɓo.» ");
INSERT INTO lik_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ko ngbingo yi nɨnɔ, ɓaɓɨɓya kakɨ ɓa ndɨ nɨ ɓogoni koluwo malɨlɨ ka gʉɗʉ. ");
INSERT INTO lik_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Waɓasamalia aka ndɨ na ɨyɨ ɓɛ: «Eze! Muyuda ɓɛyɔ wo mino yɨ, wakaɨkpʉnda kɛkʉnga ɨmɨ Waɓasamalia liɓo lɨkɨ?» (A ɓɛyɔ, Ɓayuda ɓakʉkananagɨgʉ ndɨ na Ɓasamalia.) ");
INSERT INTO lik_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yeso asikisya ndɨ ɓɛ: «Wakamibo ɓi apɛpɛ nɨnɔ Kunzi apága, wiba ɓɛ wanɨ nɔ akaʉkʉnga liɓo, iba ɨwɛ nɔ wakungi ɓi. Winisono ɓi no liɓo nɨlɔ apága ɔɓɨlɨ.» ");
INSERT INTO lik_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Muko yi nɨnɔ aɓɨkya ndɨ ɓɛ: «Mombukwono-dosu, wakɛgʉ no luki lɨtʉga liɓo na lɨkɔ a lodu kʉgbɛ. Wakwanana kʉwa kainisono no liɓo li nɨlɔ la ɔɓɨlɨ lɔ lɨkɨ? ");
INSERT INTO lik_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Tɨtosu ɓɛyɔ ka Yakɔbɔ nɔ atɨsɨlya ndɨ iɓusu lɨkɔ li nɨlɨ. Ɨyɨ ɓɨkpɛ nɔ omwaga ndɨ, iki ɓomikakɨ gʉtʉgʉ ɓambaza ka ɓanyama kakɨ aka. Wakaɨmɨna abɛ ɨwɛ nɔ wakitogi Yakɔbɔ?» ");
INSERT INTO lik_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yeso asikisya ndɨ ɓɛ: «Mʉtʉ wasɨ komwo liɓo li nɨlɨ, ɨmʉkanatʉ ɓanʉ ɓata mʉsasa. ");
INSERT INTO lik_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Luki limoti, nɨnɔ omwo ndɛkɛ liɓo nɨlɔ ɨmɨ napá, kɨmʉkanɨgʉ ndɛkɛ ɓata mʉsasa gʉtʉgʉ iki yi aka. Liɓo li nɨlɔ ɨɨta ndɛkɛ kʉsɔ kakɨ lɨkpakpa nɨlɔ ika kopupisa liɓo la ɔɓɨlɨ wa ɓɛnzɛ na ɓɛnzɛ.» ");
INSERT INTO lik_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Muko nɔ aɓɨkya ndɨ ɓɛ: «Mombukwono-dosu, ipóku nɛkɨ liɓo li nɨlɔ, iba nakimukononitɔgʉ ndɛkɛ ɓata mʉsasa. Kʉwa wa gɔ wa, nakodukugʉ ndɛkɛ ɓata wanʉ katʉga liɓo.» ");
INSERT INTO lik_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yeso aka ndɨ na ɨyɨ ɓɛ: «Wɨnda kamokoku mbʉnyakʉ, modoku na ɨyɨ wanʉ.» ");
INSERT INTO lik_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Muka nɔ asikisya ɓɛ: «Nakɛgʉ ɨmɨ na mʉlʉkʉ.» Yeso aka ndɨ na ɨyɨ ɓɛ: «Woɓikyi lɨngʉnʉ ɓɛ wakɛgʉ na mulʉkʉ, ");
INSERT INTO lik_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","kyɛ wa kʉwa na ɓovononi kuɓukumuti. Nɨnɔ ma na ɨyɨ mbɨya wanʉ, kɛgʉ mbʉnyakʉ. Woɓikyi lɨngʉnʉ.» ");
INSERT INTO lik_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Kʉwa wa, muka aɓɨkya ndɨ ɓɛ: «Mombukwono-dosu, nakaɨna abɛ wa mugyalandʉ. ");
INSERT INTO lik_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ɓotitosu ɓabibisaga ndɨ Kunzi kʉgʉ wa ngʉpa yi nɨyɨ. Iɓunu, maɓɨkyaga ɓɛ pa nɨyɔ okwononi mino kabibisa Kunzi nɨ Yelusalɛma aka.» ");
INSERT INTO lik_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yeso aɓɨkya ndɨ ɓɛ: «Ma, ɨɓɨnɨkyana nɔ. Ngbingo odokuto nɨnɔ makɨndɨgʉ ndɛkɛ mino kabibiso Baba kʉgʉ wa ngʉpa yi nɨyɨ ikanɨ ka Yelusalɛma. ");
INSERT INTO lik_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Iɓunu Ɓasamalia, mabibisogo Kunzi nɨ makɛgʉ kamibo. Iɓusu Ɓayuda, tabibisogo nɨ tanamibo, kyɛ muhukuso akotukyoku ka Ɓayuda. ");
INSERT INTO lik_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Luki limoti, ngbingo akodoku, na itulyonini, nɨnɔ ɓatʉ ɓi nɨɓɔ ɓabibisogo mino Kunzi ka lɨngʉnʉ, ɓabibisogo ndɛkɛ Baba ka Lɨmbɛngɨ na lɨngʉnʉ. A ɓɛyɔ, Baba ʉkɨsaga inguo ya ɓatʉ ɓi nɨɓɔ. ");
INSERT INTO lik_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Kunzi nɨ Lɨmbɛngɨ, na ɓatʉ ɓi nɨɓɔ ɓabibisogo, okwononi ɓɛ ɓabibisi ka Lɨmbɛngɨ na ka lɨngʉnʉ.» ");
INSERT INTO lik_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Muko nɔ aɓɨkya ndɨ ɓɛ: «Nakaiba ɓɨnza ambɛ Masiya akodoku (nɨnɔ ɓamakaga ɓɛ Kilisito). Wa odoku ndɛkɛ mino, ɨyɨ, atɨtʉmbʉlyagatʉ masɨ.» ");
INSERT INTO lik_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yeso asikisya ndɨ ɓɛ: «Ɨmɨ nɨ Kilisito, nɨnɔ nakaʉnzɨnɨlya nɔ.» ");
INSERT INTO lik_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ko ngbingo yi nɨnɔ aka nɔ, ɓaɓɨɓya ka Yeso ɓigoku ndɨ. Ɓa ndɨ kombomboyo kyɛ ɓamɨna ndɨ Yeso kanzɨna na muko. Wɨna sɛ, gʉtʉgʉ mʉtʉ ɓemoti aka kamuusagʉ ndɨ muko nɔ ɓɛ: «Wakakɨsa ɨkɨ?» Ikanɨ kamuusa Yeso ɓɛ: «Wakanzɨna na ɨyɨ ko bulya ɨkɨ?» ");
INSERT INTO lik_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Muko nɔ asa kʉwa ndɨ mbɨkɛ wa, ɨga, utumbulyogoku ndɨ ɓambanzʉ ɓɛ: ");
INSERT INTO lik_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«Donuku kamɨna! Alʉkʉ ɓemoti a kʉ, etumbulyogi masɨ nɨmɔ nogyoni. Kɛgʉ sɛ ɓanʉ ɓi Kilisito nɨnɔ?» ");
INSERT INTO lik_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ɓatʉkya kʉwa ndɨ wa, ɓɨnda kamɨna Yeso. ");
INSERT INTO lik_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Kʉwa wa, ɓaɓɨɓya ɓɨtatanaga ndɨ na Yeso ɓɛ: «Muwonisilo, lyalya mbɛyɨ!» ");
INSERT INTO lik_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Luki limoti, ʉɓɨkya ndɨ ɓɛ: «Ɨmɨ, nakalya malɨlɨ nɨmɔ makɛgʉ iɓunu kaibo.» ");
INSERT INTO lik_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ɓaɓɨɓya ɓapʉnga kʉwa ndɨ kauusono ɓɛ: «Mʉtʉ ɓemoti sɛ kʉwa nɔ oduku kapá malɨlɨ?» ");
INSERT INTO lik_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yeso ʉɓɨkya ndɨ ɓɛ: «Malɨlɨ kamɨ nɨ kagya sɨpananɨsɔ ka nɨnɔ etikoku ndɨ na kotulyosa ligubo nɨlɔ ɛpá ndɨ. ");
INSERT INTO lik_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Makaɓɨkyagɨgʉ mbɛyɨ iɓunu ɓamombukwono-donu ɓɛ: ‹Osikoni ɓatɨmba ɓakwanganya ngbinga mubuulyo masɔlɔ ɨtʉlyana?› Luki limoti, ɨmɨ nakamʉɓɨkya ambɛ, wikweni, winoni ɓotiko. Malɨlɨ ongotini, a kʉwa kakʉnga kobuulyo. ");
INSERT INTO lik_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Mʉtʉ nɨnɔ akobuulyo inisonini ɨyɨ na mʉkalya kakɨ, a kʉwa kamʉmʉla masɔlɔ ko bulya ɔɓɨlɨ wa ɓɛnzɛ na ɓɛnzɛ. Kʉwa wa, mʉkʉkʉna na mʉtʉ mubuulyo ɓogwa magyagya ɨɓʉ ɓasɨ ɓaɓa. ");
INSERT INTO lik_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","A ɓɛyɔ, a lɨngʉnʉ nɨlɔ ɓaɓɨkyaga ɓɛ: ‹Mʉtʉ ɓemoti nɔ akʉnaga, wagɔgɔ obuulyo.› ");
INSERT INTO lik_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ɨmɨ, namʉtɨka ndɨ kobuulyo ko tiko nɨyɔ makagyagʉ ndɨ mino ligubo. Ɓatʉ ɓagɔgɔ ɓɔ ɓɨkɔ ndɨ mino ɓungu ɓɨkya, iɓunu modoku kobuulya masɔlɔ ma ligubo kaɓʉ aka.» ");
INSERT INTO lik_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ɓasamalia ɓakpʉ ka gʉɗʉ yi nɨnɔ ɓaɓɨnɨkyana ndɨ Yeso, kyɛ muko yi nɨnɔ ʉɓɨkya ndɨ ɓɛ: «Etumbulyogi masɨ nɨmɔ nogyoni.» ");
INSERT INTO lik_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Kinili, nɨyɔ Ɓasamalia ɓodoku ndɨ ɓuwobi na ɨyɨ, ɓɨtatanaga ndɨ na ɨyɨ ɓɛ kogonitɔgʉ mbɛyɨ. Agya ndɨ ɓata wa masyɛ maɓa. ");
INSERT INTO lik_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ɓatʉ ɓagɔgɔ ɓudingi kʉgbɛ ɓabaɨlya ndɨ ko bulya lɨkpʉmʉka nɨlɔ a ndɨ kaɓɨkya. ");
INSERT INTO lik_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ɓaɓɨkyaga kʉwa ndɨ muko nɔ ɓɛ: «Takoɓinikyonigʉ ko bulya nɨlɔ aka lɔ watiɓikyi, luki limoti, kyɛ timukyonili kʉwa nɨ iɓusu aka. Tibini lɨngʉnʉ ambɛ ɨyɨ nɔ a Muhukuso wa ɔɓɨlɨ.» ");
INSERT INTO lik_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Nɨyɔ Yeso agya masyɛ maɓa ka mugi mi nɨmɔ, atʉkya ndɨ wa, aga ka Galilaya. ");
INSERT INTO lik_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ɨyɨ Yeso mombukwana-dakɨ ɓɨkpɛ aɓɨkya ndɨ ɓɛ: «Mugyalandʉ kɛgʉ na ɨbɨba kʉ kaɓʉ.» ");
INSERT INTO lik_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Nɨyɔ osila ka Galilaya, ɓatʉ ɓi nɨɓɔ kʉ ɓatɨlya ndɨ, kyɛ ɓɨndatʉ ndɨ gɔnɨ ɨɓʉ ka yɨnga wa Pasɨka ka Yelusalɛma, ɓɨna ndɨ masɨ nɨmɔ Yeso agya ndɨ kʉ. ");
INSERT INTO lik_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yeso ɨga kʉwa ndɨ ka Kana kʉ ka Galilaya, kʉ oyikosa ndɨ mino liɓo kaɨɨta vinya. Kʉ ɓɛyɔ, a ndɨ na ngama ɓemoti ka ɓasʉda nɨnɔ mikakɨ mʉlʉkʉ yi a ndɨ no koloɓu kʉ ka Kapɛlɛnaumu. ");
INSERT INTO lik_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Nɨyɔ ʉkana ndɨ ɓɛ Yeso otukyiniku ɓi ka Yudɛa, a kʉwa ka Galilaya, odoku ndɨ kamɨna. Ɨtatanaga kʉwa ndɨ na ɨyɨ ɓɛ ɨndɨ nɔ ɓaka ka Kapɛlɛnaumu kahukusilyo mikakɨ nɨnɔ a ndɨ ɓuwobi kosisa lɨmbɛngɨ. ");
INSERT INTO lik_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yeso aɓɨkya ndɨ ɓɛ: «Makini ndɛkɛ iɓunu mokingyosi na makpʉmʉka mʉmbanga-mbanga aka, makaɓɨnɨkyanɨgʉ ndɛkɛ gʉtʉgʉ iki yi aka.» ");
INSERT INTO lik_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ngama yi nɨnɔ asikisya ndɨ ɓɛ: «Mombukwono-dosu, taganɔ ɓaka kʉ kamɨ kanɨ miki kanodokigʉ.» ");
INSERT INTO lik_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yeso aka ndɨ na ɨyɨ ɓɛ: «Wɨga, miki oukini.» Alʉkʉ nɔ ʉkana ndɨ nɨlɔ Yeso aɓɨkya ndɨ, ɨga. ");
INSERT INTO lik_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ngbingo yi nɨnɔ a mbɛyɨ ndɨ mino ko pisi aka, ɓabangana na ɓagya-ligubo kakɨ, ɓaɓɨkya ɓɛ: «Miki oukini.» ");
INSERT INTO lik_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Kʉwa wa, umuusa ndɨ ɓɛ: «Ouki ɓi ngbinga tino?» Ɓasikisya ndɨ ɓɛ: «Ouki ɓi isyeiku ɓi, na saa-saɓa ya mʉsɨkatʉ.» ");
INSERT INTO lik_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Baba nɔ ibo kʉwa ndɨ ɓɛ o ɓi ko ngbingo nɨnɔ aka nɔ Yeso aɓɨkya ndɨ mino ɓɛ: «Miki oukini.» Kʉwa wa, ngama nɔ na ndaɓʉ kakɨ yasɨ ɓaɓɨnɨkyana ndɨ Yeso. ");
INSERT INTO lik_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Nɨlɔ a ndɨ lɨkpʉmʉka lɨmbanga la yɨɓa nɨlɔ Yeso agya ndɨ. Agya ndɨ ngbingo yi nɨnɔ igoku ndɨ mino ka Galilaya kotukyoku ka Yudɛa. ");
INSERT INTO lik_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Kʉwa wa, Ɓayuda ɓa ndɨ no dumo ka Yelusalɛma, Yeso aga ndɨ kʉ gɔ kʉ. ");
INSERT INTO lik_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Kʉ ɓɛyɔ, a ndɨ na ziwa ɓemoti ɓuwobi na mupumi ma gʉɗʉ yi nɨnɔ, nɨmɔ ɓalɨkyaga ɓɛ «mupumi ka Ɓakɔndɔlɔ». Ziwa yi nɨnɔ a ndɨ na ɓangbangba kuɓukumuti ka ɓakpɔlɔ-kpɔlɔ ɓi. Ɓamakaga ndɨ ziwa yi nɨnɔ ka Libelenia ɓɛ «Bɛtɛsaida». ");
INSERT INTO lik_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Kʉsɔ wa ɓangbangba ɓi nɨɓayɔ, ɓatʉ ɓa ɓokoloɓu ɓudingi ɓikaga ndɨ ɓakanganana wa. Ikaga ndɨ na ɓatʉ ɓa ɓokoloɓu ɓaya mamɔmɔ, nɨɓɔ ɓa dɨlɨ na ɓazɛgɛsɨ. Ɓikaga ndɨ kaɓʉnda ɓɛ liɓo obunzikoni, ");
INSERT INTO lik_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","a ɓɛyɔ, malaika ka Mombukwono-dosu osyogoku ndɨ ɓongbingo ɓemoti-ɓemoti ka ziwa yi nɨnɔ kabunzo. Mʉtʉ wo koloɓu wa mambwa nɨnɔ osyaga ndɨ ko liɓo li nɨlɔ kanɨ malaika obunzini, aʉkaga ndɨ lɨngʉnʉ. ");
INSERT INTO lik_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Luga kaɓʉ, a ndɨ na alʉkʉ ɓemoti nɨnɔ a ndɨ no koloɓu ka ɓyanga ɓatɛkɛɓɛ ɓasaa na ɓʉgɨna. ");
INSERT INTO lik_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Nɨyɔ Yeso amɨna wakanga, ʉkana ndɨ gɔnɨ ɓɛ a ndɨ no koloɓu ka masyɛ mudingi, amuusa kʉwa ndɨ ɓɛ: «Watʉ kapa kahʉka?» ");
INSERT INTO lik_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Alʉkʉ nɔ asikisya ndɨ ɓɛ: «Mombukwono-dosu, nakikogigʉ na mʉmbanzʉ nɨnɔ esiso ko liɓo ngbingo yi nɨnɔ ɓobunzaga mino. Nɨyɔ nakɨngɨlaga ambɛ nosyi kʉ ɓɛyɔ, mʉtʉ wagɔgɔ osyo kambwa kamɨ.» ");
INSERT INTO lik_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yeso aɓɨkya ndɨ ɓɛ: «Wamaga, va kalagba kakʉ na wakpakyana!» ");
INSERT INTO lik_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Wa aka wa, alʉkʉ nɔ ahʉka ndɨ. Ava kalagba kakɨ, apʉnga ndɨ kakpakyana. Lɨkpʉmʉka li nɨlɔ igyonosa ndɨ ka Lɨsyɛ la kimumbiso. ");
INSERT INTO lik_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ɓayuda ɓaɓɨkya kʉwa ndɨ mʉtʉ yi nɨnɔ ahʉka ndɨ nɔ ɓɛ: «Lɨsyɛ li nɨlɨ, a Lɨsyɛ la kimumbiso. Wakakwananɨgʉ kabɨnɨka kalagba kakʉ.» ");
INSERT INTO lik_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Usikisya ndɨ ɓɛ: «Mʉtʉ yi nɨnɔ ehukusi nɔ eɓikyi ɓɛ: ‹Va kalagba kakʉ, wakpakyana.›» ");
INSERT INTO lik_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ɓamuusa kʉwa ndɨ ɓɛ: «Mʉtʉ tino nɔ uɓikyi ɓi ɓɛ: ‹Va kalagba kakʉ, wakpakyana?›» ");
INSERT INTO lik_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Luki limoti, alʉkʉ yi nɨnɔ ahʉka ndɨ nɔ kɛgʉ ndɨ kamibo Yeso. A ɓɛyɔ, Yeso a ndɨ nɨ olimikogini ka ambaza nɨnɔ a ndɨ wa. ");
INSERT INTO lik_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Kumbuso yi, Yeso atakanya ka Ndaɓʉ ko Kunzi, aɓɨkya ɓɛ: «A ɓɛyɔ, mbɨya wanʉ wohukini. Wakogyonitɔgʉ ɓata ɓʉnyɛ, kyɛ wigyogyisa kʉwa kakɨtaga ɓɛyɔ wo ɓi mino.» ");
INSERT INTO lik_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Mʉtʉ yi nɨnɔ ɨnda ndɨ kaʉɓɨkya Ɓayuda ɓɛ Yeso nɔ ahukusa ndɨ. ");
INSERT INTO lik_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Kinili, ɓapʉnga ndɨ mino kakɨsa kagyogyiso Yeso, kyɛ ahukusa ndɨ mʉmbanzʉ ka Lɨsyɛ la kimumbiso. ");
INSERT INTO lik_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yeso usikisya ndɨ ɓɛ: «Baba agyaga ligubo ɓongbinga ɓasɨ, ɨmɨ na gɔnɨ mino aka ɓilubi.» ");
INSERT INTO lik_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Nɨyɔ Ɓayuda ɓʉkana mʉnzɨna mi nɨmɔ, ɓidukulaga kʉwa ndɨ ɓata kakɨsa Yeso ɓɨvaka-vaka kamwɔ. Ɓa ndɨ kagya ɓɛyɔ, kɛgʉ asɨ kyɛ Yeso ɨnaga ndɨ Lɨsyɛ la kimumbiso payaya, luki limoti, kyɛ aɓɨkyaga ndɨ gɔnɨ ɓɛ Kunzi nɨ abakɨ ɓɨkpɛ, na ɨyɨ mombukwana-dakɨ a mʉɗɔngɔnɨ no Kunzi. ");
INSERT INTO lik_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yeso uɓikyoku ndɨ ɓata Ɓayuda ɓɛ: «A lɨngʉnʉ, a lɨngʉnʉ, nakamʉɓɨkya ambɛ, Miki kakwananɨgʉ kagya luki na mʉtamanagɨ kakɨ, kiki nɨlɔ aka lɔ ɨnaga na Abakɨ. Nɨlɔ Baba agyaga, Miki agya mʉɗɔngɔnɨ ɓɛgɛyɔ. ");
INSERT INTO lik_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","A ɓɛyɔ, Baba apagatʉ Miki, awonisilaga masɨ nɨmɔ agyaga. Awonisila kʉwa ndɛkɛ ɓata makpʉmʉka mudingi-dingi kʉgbɛ, kʉwa wa gɔ wa, nɔkʉ amʉdɨka ndɛkɛ ɓɨdɛ. ");
INSERT INTO lik_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Mʉɗɔngɔnɨ ɓɛyɔ Baba ubililisogo mino ɓamanda, ʉpá ɔɓɨlɨ, ka lɨngʉnʉ, Miki ʉpága ɓatʉ nɨɓɔ ɨyɨ ʉbaɨlyaga ɓɛgɛyɔ. ");
INSERT INTO lik_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Na gɔnɨ, Baba kakɔgɨgʉ ngbanga ka mʉmbanzʉ, luki limoti, apóni ndɨ Miki ngu yi nɨyɔ yasɨ, ");
INSERT INTO lik_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","kyɛ ɓatʉ ɓasɨ ɓaɓangɨ Miki mʉɗɔngɔnɨ ɓɛyɔ ɓaɓangaga mino Baba. Mʉtʉ yi nɨnɔ kaɓangagɨgʉ Miki, kaɓangagɨgʉ gɔnɨ Baba nɨnɔ atikoku. ");
INSERT INTO lik_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","A lɨngʉnʉ, a lɨngʉnʉ, nakamʉɓɨkya ambɛ, mʉtʉ wasɨ nɨnɔ ʉkanaga lɨkpʉmʉka kamɨ, na aɓɨnɨkyana nɨnɔ etikoku ndɨ, a na ɔɓɨlɨ wa ɓɛnzɛ na ɓɛnzɛ. Ɓakamakyɨgʉ ndɛkɛ ka mʉngɨmbɔ, luki limoti, otukyoni ka kukwakʉ akɨtaga ka ɔɓɨlɨ. ");
INSERT INTO lik_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","A lɨngʉnʉ, a lɨngʉnʉ, nakamʉɓɨkya ambɛ, ngbingo akodoku, na a kʉwa gɔnɨ wakɨtʉlyana aka, nɨnɔ ɓamanda ɓʉkana ndɛkɛ mino lɨyʉ ko Miko-Kunzi. Na nɨɓɔ ɓʉkana ndɛkɛ, ɓinisanatʉ na ɔɓɨlɨ. ");
INSERT INTO lik_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","A ɓɛyɔ, mʉɗɔngɔnɨ ɓɛyɔ ɔɓɨlɨ wasɨ o mino ka maɓɔkʉ ka Baba, apá gɔnɨ Miki, ɔɓɨlɨ yi nɨnɔ wasɨ a kʉwa gɔnɨ ka maɓɔkʉ ko Miki. ");
INSERT INTO lik_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Apá ndɨ Miki ngu yɨkɔ ɓangbanga, kyɛ a Mika-mʉmbanzʉ. ");
INSERT INTO lik_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Makombomboyonitɔgʉ, kyɛ ngbingo akodoku nɨnɔ ɓamanda ɓayasɨ nɨɓayɔ a ka ɓambʉkʉ ɓʉkana ndɛkɛ mino lɨyʉ ko Mika-mʉmbanzʉ, ");
INSERT INTO lik_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ɓopupogoku. Nɨɓɔ ɓagyaga ndɨ ɓʉnza, ɓopupoku ndɛkɛ kainisoniso na ɔɓɨlɨ, luki limoti, nɨɓɔ ɓagyaga ndɨ ɓʉnyɛ, ɓopupoku ndɛkɛ kaingyo ka mʉngɨmbɔ.» ");
INSERT INTO lik_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Yeso omotiloku ndɨ ɓɛ: «Nakakwananɨgʉ kagya luki gʉtʉgʉ limoti aka no ngu kamɨ. Nakɔgɔ ngbanga kaɓyɛnɛnɛ na nɨlɔ baba ɛkpamyaga, na ngbanga kamɨ ikaga wongbingbili kyɛ nakakɨsagɨgʉ kagya sɨpananɨsɔ kamɨ, luki limoti, nɨsɔ ka mʉtʉ yi nɨnɔ etikoku.» ");
INSERT INTO lik_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Yeso omotiloku ndɨ kʉwa ɓɛ: «Nakika dɛmʉ kamɨ mombukwana-dakɨ yi, ɓʉdɛmʉ kamɨ kɛgʉ ɓa lɨngʉnʉ. ");
INSERT INTO lik_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Luki limoti, mʉtʉ wagɔ nɔ a dɛmʉ kamɨ, na nakaiba ambɛ ɓʉdɛmʉ kakɨ kʉgʉ kamɨ a ɓa lɨngʉnʉ. ");
INSERT INTO lik_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Iɓunu, mʉtɨkatʉ ndɨ ɓatʉtʉmbwa kʉ ka Yuani, na ɓʉdɛmʉ kakɨ kʉgʉ kamɨ a ndɨ ɓa lɨngʉnʉ. ");
INSERT INTO lik_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ɨmɨ, nakɛgʉ na nza ya ɓʉdɛmʉ ka mʉmbanzʉ. Luki limoti, nakaɓɨkya ɓɛyɔ kyɛ winisononi na muhukuso. ");
INSERT INTO lik_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yuani a ndɨ abɛ tala mʉtʉna na mʉnzɛ. Iɓunu, mabaɨlya ndɨ kazananɨlyaga ɓʉngbanganya ɓi nɨɓɔ ko ngbinga mʉkɛɗɛ aka. ");
INSERT INTO lik_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Luki limoti, ɓʉdɛmʉ kamɨ a ɓudingi kʉgbɛ kakɨtaga nɨɓɔ ka Yuani. A ɓɛyɔ, mogubo nɨmɔ Baba ɛpá ndɨ ɓɛ nagyagɨ, imu mɔ nagyaga, na imu mɔ epupilyaga ɓʉdɛmʉ na kowonisilo ɓɛ Baba nɔ etikoku ndɨ. ");
INSERT INTO lik_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Na Baba nɨnɔ etikoku ndɨ a gɔnɨ dɛmʉ kamɨ. Makanukonigʉ ndɛkɛ lɨyʉ kakɨ ikanɨ kamɨna. ");
INSERT INTO lik_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Makoɓuulyogigʉ lɨkpʉmʉka kakɨ ka mambɛngɨ kunu, kyɛ makaɓɨnɨkyanagʉ mʉtʉ yi nɨnɔ atikoku ndɨ. ");
INSERT INTO lik_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mikaga ɓakiɗukufo ɓiguɓu katangʉlaga Moɓiso Motu, kyɛ matamanaga ɓɛ makiko kagya ɓɛyɔ, makwanana kainiso na ɔɓɨlɨ wa ɓɛnzɛ na ɓɛnzɛ. Luki limoti, dɛmʉ kamɨ nɨ Moɓiso mi nɨmɔ gɔnɨ mɔ. ");
INSERT INTO lik_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Luki limoti, makya kodoku kʉ kamɨ kainiso na ɔɓɨlɨ. ");
INSERT INTO lik_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Nakakɨsagɨgʉ ɨbɨba kotukyoku ka ɓambanzʉ, ");
INSERT INTO lik_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","luki limoti, nakamumibo: kʉsɔ kunu, makɛgʉ na sɨpananɨsɔ ko Kunzi. ");
INSERT INTO lik_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ɨmɨ, nodoku ndɨ ko lino ka Baba, luki limoti, makapagɨgʉ kɛtɨlya. Mʉtʉ wagɔ kodoku ko lino kakɨ ɓɨkpɛ, matɨlyatʉ ndɛkɛ. ");
INSERT INTO lik_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Makwanana kaɓɨnɨkyana lɨkɨ? Iɓunu mapánanaga ɨbɨba luga kunu aka nɨ makɛgʉ kakɨsa nɨyɔ otukyogoku ko Kunzi yɨkaka. ");
INSERT INTO lik_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Makotomononitɔgʉ ɓɛ ɨmɨ, namʉpɨ́lyagatʉ ndɛkɛ ɓangbanga ka Baba. Musa nɨnɔ mobisa ndɨ baya kunu kʉgʉ kakɨ, ɨyɨ nɔ amʉpɨ́lyaga ndɛkɛ. ");
INSERT INTO lik_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","A ɓɛyɔ, makaɓɨnɨkyana ndɨ Musa, iba meɓinikyononi gɔnɨ, kyɛ ɨyɨ, okpikagatʉ ndɨ mongoni kʉgʉ kamɨ. ");
INSERT INTO lik_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Luki limoti, kika nɨ makɛgʉ kaɓɨnɨkyana moɓiso kakɨ, makwanana kʉwa kaɓɨnɨkyana mʉnzɨna kamɨ lɨkɨ?» ");
INSERT INTO lik_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Kumbuso yi, Yeso azaba ndɨ kʉsyakʉ wa ibombu ya Galilaya nɨyɔ ɓalɨkyaga gɔnɨ ɓɛ Tibelia. ");
INSERT INTO lik_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ambaza mudingi ka ɓambanzʉ a ndɨ kaɓɨɓya. A ɓɛyɔ, ɓambanzʉ ɓi nɨɓɔ ɓa ndɨ kaɨna mokingyosi mʉmbanga-mbanga nɨmɔ Yeso agyaga ndɨ kauhukuso ɓatʉ ɓa ɓokoloɓu. ");
INSERT INTO lik_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yeso aɗaka ndɨ ka ngʉpa, ɓikanana ndɨ kʉ ɓɛyɔ pa imoti na ɓaɓɨɓya kakɨ. ");
INSERT INTO lik_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Wɨna sɛ, yɨnga ka Ɓayuda nɨyɔ ɓalɨkyaga ɓɛ Pasɨka a kʉwa ndɨ ɓuwobi. ");
INSERT INTO lik_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yeso ɨkwɛ ndɨ, amɨna ambaza mudingi nɨ anadulyoku. Aɓɨkya kʉwa ndɨ Filipi ɓɛ: «Taluwoku mukati yanɨ kaulyoliso na ɨyɨ ɓatʉ ɓi nɨɓa?» ");
INSERT INTO lik_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Aɓɨkya ndɨ ɓɛyɔ ko bulya yɨkɨngɨla Filipi aka. A ɓɛyɔ, Yeso atʉ ndɨ kaiba kambwa aka ɓɛ agya ɓʉ. ");
INSERT INTO lik_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipi asikisya ndɨ ɓɛ: «Gʉtʉgʉ takaluwo mukati ma ɓambuma ɓamɨya ɓaɓa, kɨtʉlyanigʉ ka ɓatʉ ɓasɨ.» ");
INSERT INTO lik_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ɓemoti luga ka ɓaɓɨɓya kakɨ ɓɛyɔ ka Andɨlɨa nɨnɔ a ndɨ mamakɨ Simoni-Pɛtɛlɛ, aɓɨkya ɓɛ: ");
INSERT INTO lik_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«Miki ɓemoti atʉ na mukati kuɓukumuti ma saili wanʉ pa imoti na ɓosi ɓaɓa. Luki limoti, malɨlɨ mi nɨmɔ kɛgʉ gʉtʉgʉ luki aka ka ɓambanzʉ ɓudingi ɓɛnɛ.» ");
INSERT INTO lik_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yeso aɓɨkya ndɨ ɓɛ: «Hulikisoni ɓambanzʉ ɓasɨ.» Tɔnɨtɔ a ndɨ tidingi wa ɓɨgbɛsɛɛɛ, ɓikonono kʉwa ndɨ. Ɓalʉkʉ ɓa ndɨ banda ɓɛlɔfʉ kuɓukumuti. ");
INSERT INTO lik_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yeso ava kʉwa ndɨ mukati, nɨyɔ abibiso Kunzi, ʉgbananɨlyaga ndɨ ɓambanzʉ nɨɓɔ ɓa ndɨ wa. Agya ndɨ na ɓosi ɓɛgɛyɔ, ʉpága mʉɗɔngɔnɨ ɓɛyɔ ɓa ndɨ mino kapa. ");
INSERT INTO lik_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Nɨyɔ ɓikutaga ndɨ, Yeso ʉɓɨkya ɓaɓɨɓya kakɨ ɓɛ: «Mumuloni ɓodongbu nɨɓayɔ osikoni kyɛ koputikononitɔgʉ.» ");
INSERT INTO lik_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ɓamʉmʉla kʉwa ndɨ, ɓotumisa mʉmbɨ tɛkɛɓɛ na mɨɓa na ɓodongbu ɓaya mukati kuɓukumuti ɓaya saili nɨɓayɔ asɨkana ndɨ. ");
INSERT INTO lik_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Nɨyɔ ɓambanzʉ ɓɨna ndɨ lɨkpʉmʉka lɨmbanga nɨlɔ Yeso agya ndɨ lɔ, ɓaɓɨkya ndɨ ɓɨngbanganya ɓɛ: «Alʉkʉ yi nɨmʉna a lɨngʉnʉ mugyalandʉ nɨnɔ a ndɨ kakwanana kodoku ka ɔɓɨlɨ.» ");
INSERT INTO lik_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yeso andʉnga kʉwa ndɨ ɓɛ ɓakodoku kagwi ka mapʉpʉ ɓɛ kyɛ iki ngama, atʉkya ndɨ, aga ɓata mʉkaka ka ngʉpa. ");
INSERT INTO lik_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Nɨyɔ ɓʉgɔgɔ ogwo, ɓaɓɨɓya kakɨ ɓɨnda ndɨ ka mutili ma ibombu. ");
INSERT INTO lik_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ɓaɗaka kʉwa ndɨ ka ɨngbɔlɔ, ɓapʉnga kazaba, ɓaga misa ka Kapɛlɛnaumu. Biti a ndɨ nɨ olipyini, Yeso kɛgʉ ndɨ mudoku kaʉtakanya. ");
INSERT INTO lik_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ovivi a ndɨ wapʉ, mʉɓaka anokotukosa liɓo la ibombu ɓɨgbɨya-gbɨya. ");
INSERT INTO lik_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Nɨyɔ ɓaɓɨɓya ɓagya ɓakilɔmɛtɛlɛ banda kuɓukumuti ikanɨ maɗɨya kʉgʉ wo liɓo, ɓamɨna ndɨ Yeso nɨ anukpuɗoku. A ndɨ kakpakyana kʉgʉ wo liɓo ɓɨpapapa. Ɓogwa ndɨ ombombo kʉgbɛ. ");
INSERT INTO lik_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Luki limoti, Yeso ʉɓɨkya ndɨ ɓɛ: «Ɨmɨ nɔ, makoɓongonitɔgʉ.» ");
INSERT INTO lik_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ɓaɓɨɓya ɓa kʉwa ndɨ kapa ɓɛ ɓavɨ, luki limoti, ɨngbɔlɔ ɨfʉma ndɨ ɓɨgala kubi ka pa nɨyɔ ɓa ndɨ mino kaɨnda. ");
INSERT INTO lik_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Na ɓʉgalo ɓi, ambaza ka ɓambanzʉ nɨɓɔ ɓotigala ndɨ kʉsyakʉ wagɔgɔ wa ibombu ɓatamana ndɨ ɓɛ ɨngbɔlɔ o ɓi wa imoti aka. Yeso kaɗakagʉ ndɨ pa imoti na ɓaɓɨɓya kakɨ, luki limoti, ɓaɓɨɓya ɓɨnda ndɨ asɨ ɨɓʉ aka. ");
INSERT INTO lik_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Wɨna sɛ, mangbɔlɔ magɔgɔ otukyoku ndɨ ka gʉɗʉ wa Tibelia. Mangbɔlɔ mi nɨmɔ a kʉwa ndɨ nɨ osilini ɓuwobi na pa nɨyɔ ɓambanzʉ ɓalya ndɨ mino mukati, kumbuso Mombukwono-dosu kabibiso Kunzi. ");
INSERT INTO lik_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ambaza ka ɓambanzʉ ɨna ndɨ ɓɛ Yeso ikanɨ ɓaɓɨɓya kakɨ ɓakɛgʉ ɓata wa. Ɓaɗaka kʉwa ndɨ ka mangbɔlɔ, ɓaga kakɨsa ka Kapɛlɛnaumu. ");
INSERT INTO lik_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Nɨyɔ ɓatʉ ɓi nɨɓɔ ɓadwɛ, ɓatokonyoku ndɨ Yeso kʉsyakʉ wagɔgɔ wa ibombu, ɓamuusa ɓɛ: «Muwonisilo, wosiliku wanʉ ngbingo tino?» ");
INSERT INTO lik_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yeso usikisya ndɨ ɓɛ: «A lɨngʉnʉ, a lɨngʉnʉ, nakamʉɓɨkya ambɛ, makɛgʉ kɛkɨsa asɨ kyɛ mini ɓi makpʉmʉka mʉmbanga-mbanga, luki limoti kyɛ malyi ɓi mukati, mikutogo ɓɨkpɛkɛɗɛ-kpɛkɛɗɛ. ");
INSERT INTO lik_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Makogyonitɔgʉ ligubo ko bulya malɨlɨ nɨmɔ apʉtɨkanaga. Luki limoti, gyoni ka nɨmɔ olipyogo, apá ɔɓɨlɨ wa ɓɛnzɛ na ɓɛnzɛ. Mika-mʉmbanzʉ amʉpátʉ ndɛkɛ malɨlɨ mi nɨmɔ. A ɓɛyɔ, Baba nɨnɔ a Kunzi ɓɨkpɛ owonisila ndɨ ɓɨngbanganya ɓɛ ɨyɨ nɔ atikoku.» ");
INSERT INTO lik_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ɓamuusa kʉwa ndɨ ɓɛ: «Takwanana kagya ɓʉ kotulyoso mogubo nɨmɔ Kunzi apaga?» ");
INSERT INTO lik_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yeso usikisya ndɨ ɓɛ: «Ligubo nɨlɔ Kunzi akapa ɓɛ gyoni nɨlɨ: iɓinikyononi ɨmɨ yi nɨnɔ ɓetikoku ndɨ.» ");
INSERT INTO lik_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ɓaɓɨkya kʉwa ndɨ ɓɛ: «Lɨkpʉmʉka lɨmbanga tino lɔ wakwanana katɨgyɨlya kyɛ tʉɓɨnɨkyanɨ? Wakagya luki tino? ");
INSERT INTO lik_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ɓotitosu ɓalyatʉ ndɨ malɨlɨ nɨmɔ ɓalɨkyaga ɓɛ mana kʉ ka ɨsa. Mʉɗɔngɔnɨ ɓɛyɔ ikpikaga ndɨ mino ka Moɓiso Motu ɓɛ: ‹Kunzi ʉpá ndɨ mukati nɨmɔ otukyoku ndɨ kʉgʉ wa lɨsyɛ.›» ");
INSERT INTO lik_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yeso usikisya ndɨ ɓɛ: «A lɨngʉnʉ, a lɨngʉnʉ, nakamʉɓɨkya ambɛ, kɛgʉ Musa nɔ amʉpá ndɨ mukati nɨmɔ otukyoku ndɨ kʉgʉ wa lɨsyɛ. Luki limoti, Baba nɔ apága mukati ma lɨngʉnʉ nɨmɔ otukyoku kʉgʉ wa lɨsyɛ. ");
INSERT INTO lik_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","A ɓɛyɔ, mukati ko Kunzi, a nɨmɔ osyogoku kotukyoku kʉgʉ wa lɨsyɛ, apá ɔɓɨlɨ ka lɨtɔmbʉ.» ");
INSERT INTO lik_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ɓaɓɨkya kʉwa ndɨ ɓɛ: «Mombukwono-dosu, tɨpága masyɛ masɨ mukati mi nɨmɔ aka mɔ.» ");
INSERT INTO lik_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yeso ʉɓɨkya ndɨ ɓɛ: «Ɨmɨ nɨ mukati nɨmɔ apága ɔɓɨlɨ. Mʉmbanzʉ kodoku kʉ kamɨ, ɛɓɨnɨkyana, kɨmʉkanɨgʉ ndɛkɛ ɓata nza na mʉsasa gʉtʉgʉ iki yi aka. ");
INSERT INTO lik_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Luki limoti, namʉɓɨkyatʉ ndɨ ambɛ: wɨna sɛ, mɛmɨnatʉ ndɨ kanɨ makoɓinikyonigʉ. ");
INSERT INTO lik_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Mʉtʉ wasɨ nɨnɔ baba ɛpá, odokuto kʉ kamɨ. Kedulyoku, nakakpumyigʉ ndɛkɛ. ");
INSERT INTO lik_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","A ɓɛyɔ, nakotukyokugʉ ndɨ kʉgʉ wa lɨsyɛ kagya sɨpananɨsɔ kamɨ, luki limoti nɨsɔ ka nɨnɔ etikoku ndɨ. ");
INSERT INTO lik_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Na sɨpananɨsɔ ka nɨnɔ etikoku ndɨ a ɓɛ nakaɓungusogonitɔgʉ gʉtʉgʉ ɓemoti aka ka nɨɓɔ epóku, luki limoti nupupisatʉ ɓasɨ ka ɓambʉkʉ ka lɨsyɛ la muliɓo. ");
INSERT INTO lik_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","A ɓɛyɔ, sɨpananɨsɔ ka baba a ɓɛ mʉtʉ wasɨ nɨnɔ amɨna Miki, aɓɨnɨkyana, inisoni na ɔɓɨlɨ wa ɓɛnzɛ na ɓɛnzɛ. Ɨmɨ, napupisatʉ ndɛkɛ ka mbʉkʉ ka lɨsyɛ la muliɓo.» ");
INSERT INTO lik_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ɓayuda ɓapʉnga kʉwa ndɨ kanzɨnzɨnya Yeso kyɛ aɓɨkya ndɨ ɓɛ ɨyɨ nɨ mukati nɨmɔ osyoku kʉgʉ wa lɨsyɛ. ");
INSERT INTO lik_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ɓa ndɨ kaɓɨkya ɓɛ: «Kɛgʉ mbɛyɨ Yeso mʉ? Mika Yɛzɛfʉ? Takamibigʉ mbɛyɨ abakɨ na amakɨ? Akwanana pɨyɛ kaɓɨkya ɓata lɨkɨ ɓɛ osyoku kʉgʉ wa lɨsyɛ?» ");
INSERT INTO lik_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yeso usikisya ndɨ ɓɛ: «Wosoni kaɨnzɨnzɨnya luga kunu. ");
INSERT INTO lik_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Mʉmbanzʉ gʉtʉgʉ ɓemoti aka kakwananɨgʉ kodoku kʉ kamɨ, kiki nɨ Baba nɨnɔ etikoku ndɨ aka nɔ alutiniku. Ɨmɨ, napupisatʉ ndɛkɛ mʉtʉ yi nɨnɔ ka mbʉkʉ ka lɨsyɛ la muliɓo. ");
INSERT INTO lik_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ikpikaga ka moɓiso ka ɓogyalandʉ ɓɛ: ‹Kunzi ʉtɨwa ndɛkɛ ɓambanzʉ ɓasɨ.› Mʉtʉ wasɨ nɨnɔ amʉkana Baba, aɓyɛ mʉtʉʉ kakɨ, odokuto kʉ kamɨ. ");
INSERT INTO lik_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Kɛgʉ na mʉtʉ gʉtʉgʉ ɓemoti aka nɨnɔ aminoni Baba, kiki nɨnɔ aka nɔ otukyoku ko Kunzi, ɨyɨ nɔ aminoni Baba. ");
INSERT INTO lik_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","A lɨngʉnʉ, a lɨngʉnʉ, nakamʉɓɨkya ambɛ, nɨnɔ ɛɓɨnɨkyana, a na ɔɓɨlɨ wa ɓɛnzɛ na ɓɛnzɛ. ");
INSERT INTO lik_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ɨmɨ nɨ mukati nɨmɔ apága ɔɓɨlɨ. ");
INSERT INTO lik_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ɓotitonu ɓalyatʉ ndɨ mana ka ɨsa, gʉtʉgʉ ɓɛyɔ, ɓolumwaga ndɨ. ");
INSERT INTO lik_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Luki limoti, mukati mi nɨmɔ osyoku kʉgʉ wa lɨsyɛ nɨma. Mʉtʉ yi nɨnɔ alya, kokwigʉ ndɛkɛ. ");
INSERT INTO lik_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ɨmɨ nɨ mukati ma ɔɓɨlɨ nɨmɔ osyoku kʉgʉ wa lɨsyɛ. Mʉmbanzʉ kalya, ika ndɛkɛ na ɔɓɨlɨ wa ɓɛnzɛ na ɓɛnzɛ. Mukati mi nɨmɔ napá ndɛkɛ ambɛ ɓambanzʉ ɓinisoni na ɔɓɨlɨ nɨ nzʉyɨ kamɨ.» ");
INSERT INTO lik_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Kʉwa wa, Ɓayuda ɓapʉnga ndɨ ɓoɗongoso luga kaɓʉ, ɓanaɓɨkya ɓɛ: «Alʉkʉ yi nɨmʉ akwanana pɨyɛ katɨpá nzʉyɨ kakɨ ɓɛ talyɨ lɨkɨ?» ");
INSERT INTO lik_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yeso ʉɓɨkya ndɨ ɓɛ: «A lɨngʉnʉ, a lɨngʉnʉ, nakamʉɓɨkya ambɛ, makolyi nzʉyɨ ko Mika-mʉmbanzʉ, momwo ɓangʉ kakɨ, makikigʉ na ɔɓɨlɨ kʉsɔ kunu. ");
INSERT INTO lik_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Mʉmbanzʉ kalya nzʉyɨ kamɨ, omwo ɓangʉ kamɨ, ika na ɔɓɨlɨ wa ɓɛnzɛ na ɓɛnzɛ. Napupisa ndɛkɛ ka mbʉkʉ ka lɨsyɛ la muliɓo. ");
INSERT INTO lik_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","A ɓɛyɔ, nzʉyɨ kamɨ a malɨlɨ ma lɨngʉnʉ, ɓangʉ kamɨ a luki limwo la lɨngʉnʉ. ");
INSERT INTO lik_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Mʉtʉ nɨnɔ alyaga nzʉyɨ kamɨ, omwa ɓangʉ kamɨ, ikaga kʉsɔ kamɨ na ɨmɨ kʉsɔ kakɨ. ");
INSERT INTO lik_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Baba nɨnɔ etikoku ndɨ a na ɔɓɨlɨ, ɨmɨ, na na ɔɓɨlɨ ko ngu kakɨ. A ɓɛgɛyɔ, mʉmbanzʉ nɨnɔ ɛlya, inisa na ɔɓɨlɨ pisi kʉ kamɨ. ");
INSERT INTO lik_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Mukati mi nɨma otukyoku kʉgʉ wa lɨsyɛ. Kɛgʉ abɛ nɨmɔ ɓotitonu ɓalya ndɨ, gʉtʉgʉ ɓɛyɔ, ɓokwaga ndɨ aka. Luki limoti, nɨnɔ alya mukati mi nɨma, ika na ɔɓɨlɨ wa ɓɛnzɛ na ɓɛnzɛ.» ");
INSERT INTO lik_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yeso anzɨna ndɨ mʉnzɨna mi nɨmana ka Kapɛlɛnaumu nɨ akapá mʉtʉʉ ka ndaɓʉ ya malʉmba. ");
INSERT INTO lik_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Nɨyɔ ɓʉkana mʉnzɨna ka Yeso ɓɛyɔ, ɓudingi ɓa ɓaɓɨɓya kakɨ aka ndɨ ɓɛ: «Mʉnzina mi nɨmana a mʉmbanga kʉgbɛ, wanɨ nɔ akwanana kapa kaʉkana?» ");
INSERT INTO lik_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yeso andʉnga ndɨ ɓɛ ɓaɓɨɓya kakɨ ɓakaɨnzɨnzɨnya ko bulya mʉnzɨna mi nɨmɔ. Kinili, umuusa kʉwa ndɨ ɓɛ: «Lɨkpʉmʉka li nɨlɨ amutulisito mambɛngɨ? ");
INSERT INTO lik_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Kika nɨ a ɓɛyɔ, ika kʉwa lɨkɨ nɨ maminini Mika-mʉmbanzʉ kaɗaka ɓata ka pa nɨyɔ a ndɨ mino kambwa? ");
INSERT INTO lik_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Lɨmbɛngɨ ko Kunzi lɔ apága ɔɓɨlɨ. Nzʉyɨ kakwananɨgʉ kagya luki. Mʉnzɨna nɨmɔ namʉɓɨkya ndɨ mɔ a mutumo no ngu ya lɨmbɛngɨ, na imu mɔ apága ɔɓɨlɨ. ");
INSERT INTO lik_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Luki limoti, ɓambanzʉ ɓemoti-ɓemoti luga kunu ɓakɛgʉ kaɓɨnɨkyana. A ɓɛyɔ, Yeso ibagatʉ ndɨ katʉkya ka ɓʉndɛlɨ aka ɓɛ atʉ na nɨɓɔ ɓakaɓɨnɨkyanagɨgʉ ndɨ na nɨnɔ agaba ndɛkɛ.» ");
INSERT INTO lik_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Omotiloku ndɨ ɓɛ: «Kinili, namuɓikyi ambɛ: ‹Kɛgʉ na mʉmbanzʉ nɨnɔ akwanana kodoku kʉ kamɨ kiki nɨ baba aka nɔ ahukwilyini pisi.›» ");
INSERT INTO lik_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Katʉkya ko ngbingo yi nɨnɔ aka nɔ, ɓudingi ɓa ɓaɓɨɓya kakɨ ɓasa ndɨ, ɓakakpakyanagɨgʉ ndɨ ɓata na ɨɓʉ. ");
INSERT INTO lik_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yeso umuusa kʉwa ndɨ ɓaɓɨɓya tɛkɛɓɛ na ɓaɓa ɓɛ: «Yɛgʉ iɓunu, ma kʉwa gɔnɨ iɓunu kapa kɛsa?» ");
INSERT INTO lik_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simoni-Pɛtɛlɛ asikisya ndɨ ɓɛ: «Mombukwono-dosu, tɨnda ɓata ka wanɨ? Ɨwɛ wa na mʉnzɨna nɨmɔ apága ɔɓɨlɨ wa ɓɛnzɛ na ɓɛnzɛ. ");
INSERT INTO lik_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Iɓusu, takaɓɨnɨkyana, takaiba ambɛ ɨwɛ nɨ Mʉtʉ Wotu nɨnɔ Kunzi atikoku ndɨ.» ");
INSERT INTO lik_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yeso usikisya ndɨ ɓɛ: «Kɛgʉ mbɛyɨ ɨmɨ aka nɔ namʉpʉnaga ndɨ iɓunu ɓasɨ tɛkɛɓɛ na ɓaɓa? Luki limoti, ɓemoti luga kunu a mumuyoniso!» ");
INSERT INTO lik_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yeso a ndɨ kanzɨna ko bulya ka Yuda nɨnɔ a ndɨ mika Simoni Isikalioti. A ɓɛyɔ, Yuda nɔ a ndɨ kagaba, gʉtʉgʉ ɓɛyɔ a ndɨ mino ɓemoti ka ɓaɓɨɓya tɛkɛɓɛ na ɓaɓa yɔ. ");
INSERT INTO lik_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Kumbuso yi, Yeso alingya ndɨ Galilaya wasɨ. A ɓɛyɔ, kɛgʉ ndɨ kapa kalingyo Yudɛa kyɛ ɓangama ka Ɓayuda ɓa ndɨ kakɨsa kamwisiso. ");
INSERT INTO lik_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Wɨna sɛ, yɨnga ɓemoti ka Ɓayuda nɨnɔ ɓamakaga ndɨ ɓɛ yɨnga wa Ɓangbangba a kʉwa ndɨ ɓuwobi. ");
INSERT INTO lik_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ɓamamakɨ Yeso ɓaɓɨkya kʉwa ndɨ ɓɛ: «Tɨtʉkyɨlya iɓusu wanʉ, waga ka Yudɛa iba ɓaɓɨɓya kakʉ nɨɓɔ kʉ ɓɨnɨtɔ gɔnɨ ɨɓʉ nɨlɔ wika kagya. ");
INSERT INTO lik_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Kɛgʉ na mʉmbanzʉ gʉtʉgʉ ɓemoti aka nɨnɔ agyaga lɨkpʉmʉka ko dikiɗi, nɨ a sɛ kakɨsa kaimibisisoko ɓɨngbanganya. Kika nɨ wakagya makpʉmʉka mʉmbanga-mbanga, wiwonisa nɛkɨ ka ɓambanzʉ ɓasɨ.» ");
INSERT INTO lik_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","A ɓɛyɔ, gʉtʉgʉ ɓamamakɨ ɓɨkpɛ ɓakɛgʉ ndɨ kaɓɨnɨkyana. ");
INSERT INTO lik_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yeso ʉɓɨkya ndɨ ɓɛ: «Ngbingo yi nɨnɔ kamɨ wanza kanitulyonigʉ mbɛyɨ. Luki limoti, nɨnɔ kunu ikaga ɨyɨ asɨ wanza aka ɓongbinga ɓasɨ. ");
INSERT INTO lik_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ɓatʉ ɓa ɔɓɨlɨ ɓakakwananɨgʉ kamʉmʉya iɓunu. Luki limoti, ɓɛmʉyatʉ ɨmɨ kyɛ na dɛmʉ kaʉɓɨkyaga yɨgya kaɓʉ yanyɛ. ");
INSERT INTO lik_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Windoni iɓunu ka yɨnga. Nakɛgʉ mino ɨmɨ kaɨnda kyɛ ngbingo kamɨ kɛgʉ mbɛyɨ wakɨtʉlyana.» ");
INSERT INTO lik_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Nɨyɔ aɓɨkya ɓɛyɔ, asɨkana ndɨ ɨyɨ ka Galilaya. ");
INSERT INTO lik_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Nɨyɔ ɓamamakɨ ɓɨnda ndɨ ka yɨnga, Yeso ɨnda ndɨ gɔnɨ ɨyɨ ɓɨpɛlɛ nɨ ɓambanzʉ ɓakibigʉ. ");
INSERT INTO lik_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Kʉwa wa, ɓangama ka Ɓayuda ɓapʉnga ndɨ kakɨsa ɓɨvaka-vaka, ɓanuusogo ɓɛ: «Alʉkʉ yi nɨnɔ a yanɨ?» ");
INSERT INTO lik_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Kʉsɔ wa ambaza kʉ, ɓambanzʉ ɓa ndɨ kaɨnzɨnzɨnya yakpʉ kʉgʉ ka Yeso. Ɓatʉ ɓagɔ ɓa ndɨ kaɓɨkya ɓɛ: «A mʉtʉ wanza.» Ɓatʉ ɓɔ ɓɛ: «Haaa, akauluta ɓambanzʉ ko pisi yanyɛ.» ");
INSERT INTO lik_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Luki limoti, kɛgʉ na mʉtʉ ɓemoti nɨnɔ aɓɨkyaga ndɨ lɨkpʉmʉka ɓɨngbanganya, kyɛ ɓʉɓangaga ndɨ ɓangama ka Ɓayuda. ");
INSERT INTO lik_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ngbingo yi nɨnɔ dumo a kʉwa ndɨ mino ɓɨkɔkpwɔ, Yeso aga ndɨ ka Ndaɓʉ ko Kunzi, apʉnga kapá mʉtɨwɨ. ");
INSERT INTO lik_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ɓayuda ɓombombaya ndɨ, ɓanaɓɨkya ɓɛ: «Alʉkʉ mʉna apʉnya mbɛyɨ na yimibo yanɨ? Wɨna sɛ, kɨndagʉ gʉtʉgʉ ndɨ ka ɨkɔlɔ ɓɛgɛyɔ.» ");
INSERT INTO lik_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yeso usikisya ndɨ ɓɛ: «Mʉtɨwɨ nɨmɔ ɨmɨ napága, kikogigʉ makamɨ, luki limoti, ikaga ma ko Kunzi nɨnɔ etikoku ndɨ. ");
INSERT INTO lik_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Mʉmbanzʉ kika wakɨtʉlya kagya nɨlɔ Kunzi apaga, iba pisi ka mʉtʉʉ mi nɨmɔ ɓɛ akotukyoku ka Baba ikanɨ kamɨ ɓɨkpɛ. ");
INSERT INTO lik_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Mʉtʉ yi nɨnɔ anzɨnaga ko lina kakɨ ɓɨkpɛ, akɨsaga ɨbɨba kakɨ aka mombukwana-dakɨ yi. Luki limoti, nɨnɔ akɨsaga ɨbɨba ka nɨnɔ atikoku ndɨ, aɓɨkyaga lɨngʉnʉ nɨ kʉɓɔɓɔkʉ kɛgʉ kʉsɔ kakɨ. ");
INSERT INTO lik_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Musa kamʉpágʉ mbɛyɨ ndɨ mʉtʉʉ? Luki limoti, mʉmbanzʉ gʉtʉgʉ ɓemoti aka kɛgʉ kaɓyɛ mʉtʉʉ mi nɨmɔ. Mbɨya wanʉ, ko bulya ɨkɨ yɔ mo mino kakɨsa kemwisiso?» ");
INSERT INTO lik_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ambaza asikisya ndɨ ɓɛ: «Wa na lɨmbɛngɨ la ɓʉnyɛ! Wanɨ mbɛyɨ nɔ akakɨsa kaumwisiso?» ");
INSERT INTO lik_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yeso usikisya ndɨ ɓɛ: «Nagya ndɨ lɨkpʉmʉka lɨmbanga limoti aka, amudikisa ndɨ iɓunu ɓasɨ nɔkʉ ɓɨdɛ. ");
INSERT INTO lik_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Iɓunu mʉkɔgɔ ɓomiki gʉtʉgʉ ka Lɨsyɛ la kimumbiso aka kyɛ Musa amʉpá ndɨ mʉtʉʉ kagyaga ɓɛyɔ. Ka lɨngʉnʉ, kodokugʉ ndɨ ka Musa, luki limoti, ka ɓotitonu. ");
INSERT INTO lik_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Kika nɛkɨ nɨ ɓʉkɔgɔtʉ ɓomiki ka Lɨsyɛ la kimumbiso, a ko bulya yiɓuulya mʉtʉʉ ka Musa. Ko bulya ɨkɨ sɛ kʉwa yɔ mambɛngɨ o mino kamʉkandɨkana wa nauhukusi mino mʉmbanzʉ ka Lɨsyɛ la kimumbiso? ");
INSERT INTO lik_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Makokogonitɔgʉ mʉkɔmbʉ kaɓyɛnɛnɛ na nɨyɔ mɨnaga no miso aka, luki limoti, kogoni ka ɓungbingbili.» ");
INSERT INTO lik_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ɓatʉ ɓagɔgɔ ɓa Yelusalɛma ɓa ndɨ kaɓɨkya ɓɛ: «Kɛgʉ mʉtʉ yi nɨnɔ ɓakakɨsa kamwisiso nɨmʉ? ");
INSERT INTO lik_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Wɨna sɛ, akanzɨna ɓɨngbanganya kambwa ka ɓambanzʉ na ɓakɛgʉ gʉtʉgʉ kaɓukyo aka. Ɓangama ɓibito nɛkɨ ɓi lɨngʉnʉ ɓɛ ɨyɨ nɨ Masiya? ");
INSERT INTO lik_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Takaiba ambɛ mʉtʉ yi nɨmʉna apʉnya yanɨ. Luki limoti, ngbingo yi nɨnɔ Masiya odoku ndɛkɛ mino, mʉmbanzʉ gʉtʉgʉ ɓemoti aka kibigʉ ndɛkɛ ɓɛ apʉnya yanɨ.» ");
INSERT INTO lik_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ngbingo yi nɨnɔ Yeso a kʉwa ndɨ mino kapá mʉtɨwɨ ka Ndaɓʉ ko Kunzi, aɓɨkya ndɨ na lɨyʉ lapʉ ɓɛ: «Matʉ kemibo ɓɨnza na mibatʉ kʉ no mino kapʉnya? Nakodokugʉ ndɨ ko ngu kamɨ ɓɨkpɛ, luki limoti, nɨnɔ etikoku ndɨ aɓɨkyaga ɨyɨ asɨ lɨngʉnʉ aka. Iɓunu, makamibigʉ. ");
INSERT INTO lik_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ɨmɨ, namibatʉ kyɛ notukyoku ndɨ kʉ kakɨ, ɨyɨ nɔ etikoku.» ");
INSERT INTO lik_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ɓakɨsa kʉwa ndɨ ɓɛ ɓagwi Yeso lɨkɨ, luki limoti, mʉmbanzʉ gʉtʉgʉ ɓemoti aka kakwananagʉ ndɨ kagwi, kyɛ ngbingo kakɨ kɛgʉ mbɛyɨ ndɨ wakɨtʉlyana. ");
INSERT INTO lik_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Kʉsɔ wa ambaza, ɓambanzʉ ɓaɓɨnɨkyana ndɨ, ɓaɓɨkya ɓɛ: «Ngbingo yi nɨnɔ Masiya odoku ndɛkɛ mino, agyatʉ ndɛkɛ gɔnɨ ɨyɨ makpʉmʉka mʉmbanga-mbanga makpʉ kakɨtaga alʉkʉ yi nɨmʉ?» ");
INSERT INTO lik_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ɓafalisayɔ ɓʉmʉkana ndɨ ɓambanzʉ nɨ ɓanɨnzɨnzɨnya ko bulya ka Yeso ka ambaza kʉ. Kʉwa wa, ɓokumu-kumu na Ɓafalisayɔ ɓʉtɨka ndɨ ɓazamʉ kagwi. ");
INSERT INTO lik_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yeso ʉɓɨkya ndɨ ɓatʉ nɨɓɔ ɓa ndɨ wa ɓɛ: «Na mbɛyɨ ɓata pa imoti na iɓunu ko ngbinga mʉkɛɗɛ. Kumbuso yi, nɨgatʉ katakanya nɨnɔ etikoku ndɨ. ");
INSERT INTO lik_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Mɛkɨsatʉ ndɛkɛ ɓɨvaka-vaka, luki limoti, makɛmɨnɨgʉ. Makakwananɨgʉ ndɛkɛ kosila kʉ niko mino.» ");
INSERT INTO lik_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ɓayuda ɓuusana ndɨ luga kaɓʉ ɓɛ: «A sɛ kʉwa kaɨnda yanɨ, nɨyɔ takakwananɨgʉ mino kamɨna? A sɛ kapa kaɨnda ka Ɓayuda ɓi nɨɓɔ ɓa ɓumisikono luga ka Ɓagiliki na kaʉpá Ɓagiliki mʉtɨwɨ kakɨ? ");
INSERT INTO lik_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Atiɓikyi ɓi ɓɛ: ‹Mɛkɨsatʉ ndɛkɛ ɓɨvaka-vaka, luki limoti, makɛmɨnɨgʉ. Makakwananɨgʉ ndɛkɛ kosila kʉ niko mino.› Isi ya mʉnzɨna mi nɨmɔ nɨ ɨkɨ?» ");
INSERT INTO lik_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Lɨsyɛ la muliɓo la yɨnga yi nɨnɔ a ndɨ lɨsyɛ lidingi kʉgbɛ. Lɨsyɛ li nɨlɔ, Yeso amaga ndɨ ɓɨgba, aɓɨkya na lɨyʉ lapʉ ɓɛ: «Mʉmbanzʉ kika na mʉsasa, oduku komwo liɓo kʉnʉ no mino. ");
INSERT INTO lik_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ka mʉtʉ yi nɨnɔ, ika ndɛkɛ mʉɗɔngɔnɨ ɓɛyɔ Moɓiso Motu aɓɨkyaga mino ɓɛ: ‹Mambɛngɨ mo moɓo mudingi-dingi nɨmɔ apága ɔɓɨlɨ akɨka ndɛkɛ katʉkya ka lɨmbɛngɨ ka mʉtʉ nɨnɔ ɛɓɨnɨkyana.›» ");
INSERT INTO lik_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yeso a ndɨ kanzɨna ɓɛyɔ ko bulya Lɨmbɛngɨ ko Kunzi nɨlɔ ɓatʉ ɓi nɨɓɔ ɓaɓɨnɨkyana ɓika ndɛkɛ nolu. A ɓɛyɔ, Lɨmbɛngɨ li nɨlɔ kɛgʉ mbɛyɨ ndɨ lidoku, kyɛ Kunzi a ndɨ nɨ kanapígʉ Yeso ɨbɨba. ");
INSERT INTO lik_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Nɨyɔ ɓambanzʉ ɓagɔgɔ luga wa ambaza ɓʉkana mino mʉnzɨna mi nɨmɔ, ɓaɓɨkya ndɨ ɓɛ: «A lɨngʉnʉ aka Mugyalandʉ nɨnɔ ɓawanyaga ndɨ!» ");
INSERT INTO lik_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ɓagɔgɔ ɓaɓɨkya ndɨ ɓɛ: «Masiya nɔ!» Luki limoti, ɓagɔgɔ ɓata ɓɛ: «Ambɛ, Masiya akwananatʉ kotukyoku ka Galilaya? ");
INSERT INTO lik_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Moɓiso Motu kaɓɨkyagɨgʉ mbɛyɨ ɓɛ Masiya ɨɓʉkʉta ndɛkɛ ka lɨvananza ka ngama Daudi na ka Bɛtɛlɛhɛmʉ, mugi nɨmɔ Daudi a ndɨ mino?» ");
INSERT INTO lik_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Kʉwa wa, ambaza ɨgbananaga ndɨ ko bulya ka Yeso. ");
INSERT INTO lik_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ɓatʉ ɓagɔgɔ luga kaɓʉ ɓa ndɨ kapa kagwi, luki limoti, mʉmbanzʉ gʉtʉgʉ ɓemoti aka kavɨlagʉ ndɨ. ");
INSERT INTO lik_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Kumbuso yi, ɓazamʉ nɨɓɔ ɓokumu-kumu na Ɓafalisayɔ ɓʉtɨka ndɨ, ɓigoku. Ɓumuusa kʉwa ndɨ ɓazamʉ ɓɛ: «Ko bulya ɨkɨ yɔ makodukugʉ mino na Yeso?» ");
INSERT INTO lik_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ɓusikisya ndɨ ɓɛ: «A lɨmbanga! Takanamukonigʉ ndɛkɛ mʉmbanzʉ ananzɨna abɛ alʉkʉ yi nɨnɔ kʉ!» ");
INSERT INTO lik_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ɓafalisayɔ ɓumuusa ndɨ ɓɛ: «Ambɛ, mogulyini kʉwa gɔnɨ iɓunu ka kʉɓɔɓɔkʉ kwi nɨkwɔ? ");
INSERT INTO lik_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Atʉ mbɛyɨ na mʉmbanzʉ gʉtʉgʉ ɓemoti aka luga kusu ka ɓangama ikanɨ ka Ɓafalisayɔ nɨnɔ aɓɨnɨkyana? ");
INSERT INTO lik_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Luki limoti, ɓatʉ ɓi nɨɓɔ ɓakibigʉ mʉtʉʉ ka Musa. Ɓovoni ndɨ ligbongoni.» ");
INSERT INTO lik_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodimo a ndɨ ɓemoti ka Ɓafalisayɔ nɨɓɔ ɓa ndɨ wa. Ɨyɨ nɔ odoku ndɨ kamɨna Yeso kambwa, ʉɓɨkya ndɨ ɓɛ: ");
INSERT INTO lik_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«Mʉtʉʉ kusu, akɔgɔtʉ mʉkɔmbʉ ka mʉmbanzʉ nɨ ɓakanomukonigʉ ikanɨ ɓakanibigʉ ɓɛ ogyi ɓi ɨkɨ?» ");
INSERT INTO lik_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Luki limoti, ɓasikisya ndɨ ɓɛ: «Wa kʉwa ɨwɛ mʉtʉ wa Galilaya gɔnɨ? Kpɨma mbɛyɨ Moɓiso Motu ɓɨnza ikanɨ wɨnatʉ gʉtʉgʉ ɓɛ mugyalandʉ ɓemoti opupatʉ ndɛkɛ ka Galilaya.»  ");
INSERT INTO lik_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Kumbuso yi, ɨɓʉ ɓasɨ ɓɨganana ndɨ ka ɓakʉkaɓʉ. ");
INSERT INTO lik_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Luki limoti, Yeso aga ndɨ ɨyɨ ka Ngʉpa ya Mizeituni. ");
INSERT INTO lik_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ɓʉgala ɓi na ɓʉsɔɓɨ ɓiɓo, ɨga ndɨ ɓata ka Ndaɓʉ ko Kunzi. Ɓambanzʉ ɓasɨ ɓakpuɗoku ndɨ. Iko, apʉnga ndɨ kaʉpá mʉtɨwɨ. ");
INSERT INTO lik_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ɓowonisilo ɓa mʉtʉʉ na Ɓafalisayɔ ɓodoku kʉwa ndɨ wa na muko ɓemoti nɨnɔ ɓagwi ndɨ na mʉlʉkʉ. Ɓamomosa ndɨ kambwa ka ɓambanzʉ ɓɨgbʉ, ");
INSERT INTO lik_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ɓaɓɨkya Yeso ɓɛ: «Muwonisilo, ɓagwi muko yi nɨmʉ na mʉlʉkʉ mbɨya wa. ");
INSERT INTO lik_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Kaɓyɛnɛnɛ na mʉtʉʉ kusu, Musa atɨkpamya ndɨ kaʉmwɔgɔ inguo ya ɓoko ɓi nɨɓa na matamʉ. Ɨwɛ, wa sɛ kʉwa kaɓɨkya ɓʉ?» ");
INSERT INTO lik_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ɓa ndɨ kaɓɨkya ɓɛyɔ ko bulya yɨkɨngɨla Yeso, kyɛ ɓa ndɨ kakɨsa kasʉngʉlya. Luki limoti, Yeso odidika ndɨ, apʉnga kokpiko na kpɛngbɛ ka lɨtɔmbʉ. ");
INSERT INTO lik_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Nɨyɔ ɓisisilaga ndɨ mino kamuusogo, Yeso ananʉkana ndɨ, ʉɓɨkya ɓɛ: «Mʉtʉ nɨnɔ kanogyigʉ ndɛkɛ ɨyɨ ɓʉnyɛ luga kunu, apʉngɨ nɨ ɨyɨ kamaka lɨtalʉ la mambwa.» ");
INSERT INTO lik_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Kumbuso yi, odidika ndɨ ɓata, apʉnga ɓata kokpiko ka lɨtɔmbʉ. ");
INSERT INTO lik_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ngbingo yi nɨnɔ ɓʉkana mino ɓɛyɔ, ɓapʉnga ndɨ katʉkya yɨkaka-yɨkaka kaɨpʉnga na ɓambɔkʉ. Yeso otigolo mʉkaka aka wa ɨɓʉ na muko yi nɨnɔ wa a mbɛyɨ ndɨ ɓata mino wakamaga kambwa ka ɓatʉ nɨɓɔ ɓa ndɨ wa. ");
INSERT INTO lik_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Kʉwa wa, Yeso amaga ɓata ndɨ, amuuso muko nɔ ɓɛ: «Yɛ ma, ɓatʉ nɨɓɔ ɓusungulyi ɓa yanɨ? Kɛgʉ nɛkɨ na mʉmbanzʉ nɨnɔ ubisi na mʉkɔmbʉ?» ");
INSERT INTO lik_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Asikisya ndɨ ɓɛ: «Gʉtʉgʉ ɓemoti aka Mombukwono-dosu.» Yeso aka na ɨyɨ ɓɛ: «Ɛɛɛ, nakubisigʉ ɨmɨ na mʉkɔmbʉ ɓɛgɛyɔ. Waganɔ, luki limoti, wakigilyonitɔgʉ ɓata kagya ɓʉnyɛ.» ");
INSERT INTO lik_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yeso ʉɓɨkya ɓata ndɨ ɓambanzʉ ɓɛ: «Ɨmɨ nɨ ɓʉngbanganya ɓa ɔɓɨlɨ. Mʉmbanzʉ kɛɓɨɓya kakpakyanɨgʉ ndɛkɛ ko biti, luki limoti, inisona ndɛkɛ na ɓʉngbanganya ɓa ɔɓɨlɨ.» ");
INSERT INTO lik_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ɓafalisayɔ ɓaɓɨkya ndɨ ɓɛ: «Ɨwɛ nɔ wa dɛmʉ kakʉ ka mombukwana-dakɨ yi. Ɓʉdɛmʉ kakʉ kɛgʉ nɛkɨ ɓa lɨngʉnʉ.» ");
INSERT INTO lik_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yeso usikisya ndɨ ɓɛ: «Gʉtʉgʉ nakika dɛmʉ kamɨ mombukwana-dakɨ yi, ɓʉdɛmʉ kamɨ a ɓa lɨngʉnʉ, kyɛ nakaiba ambɛ napʉnya yanɨ na nakaɨnda yanɨ. Luki limoti, iɓunu, makɛgʉ kaiba ɓɛ napʉnya yanɨ ikanɨ nakaɨnda yanɨ. ");
INSERT INTO lik_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Iɓunu, makɔgɔ lɨkpʉmʉka kaɓyɛnɛnɛ na tamanaga ka ɓambanzʉ. Luki limoti, ɨmɨ, nakakɔgɨgʉ lɨkpʉmʉka ka mʉmbanzʉ. ");
INSERT INTO lik_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Na gʉtʉgʉ nakakɔ lɨkpʉmʉka ka mʉmbanzʉ, ika ka ɓungbingbili aka kyɛ nakɛgʉ mʉkaka. Luki limoti, ta pa imoti na Baba nɨnɔ etikoku. ");
INSERT INTO lik_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Wɨna sɛ, ka mʉtʉʉ kunu, ɓokpikatʉ ndɨ ɓɛ ɓʉdɛmʉ ka ɓatʉ ɓaɓa ɓɔ ikaga ɓa lɨngʉnʉ. ");
INSERT INTO lik_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Na dɛmʉ kamɨ mombukwana-dakɨ yi. Baba nɨnɔ etikoku ndɨ a gɔnɨ dɛmʉ kamɨ.» ");
INSERT INTO lik_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ɓafalisayɔ ɓamuusa kʉwa ndɨ ɓɛ: «Abakʉ a sɛ kʉwa yanɨ?» Yeso aka ndɨ na ɨɓʉ ɓɛ: «Makemibigʉ na makamibigʉ Baba. Makemiba ndɨ, iba mamibatʉ gɔnɨ Baba.» ");
INSERT INTO lik_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yeso a ndɨ kanzɨna ɓɛyɔ ngbingo yi nɨnɔ a ndɨ mino ka Ndaɓʉ ko Kunzi. A ndɨ ka kpɔlɔ wa kpokoyo nɨnɔ ɓaɗɨkɨtaga mino apɛpɛ. Mʉmbanzʉ gʉtʉgʉ ɓemoti aka kagwigʉ ndɨ kyɛ ngbingo kakɨ kɛgʉ ndɨ wakɨtʉlyana. ");
INSERT INTO lik_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yeso ʉɓɨkya ɓata ndɨ ɓɛ: «Ɨmɨ, nogoni ɨmɨ. Mɛkɨsatʉ ɓanʉ, luki limoti, mokwo ndɛkɛ ka ɓʉnyɛ kunu. Makakwananɨgʉ kosila kʉ no mino kaɨnda.» ");
INSERT INTO lik_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ɓayuda ɓuusana ndɨ luga kaɓʉ ɓɛ: «A sɛ kʉwa kaɨnda kaibongiso, kyɛ akaɓɨkya ɓɛ: ‹Makakwananɨgʉ kosila kʉ no mino kaɨnda?›» ");
INSERT INTO lik_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yeso usikisya ndɨ ɓɛ: «Iɓunu, ma ɓatʉ ɓa wasɨ wanʉ, luki limoti, ɨmɨ, na mʉtʉ wa kʉgʉ. Iɓunu, ma ɓatʉ ɓa ɔɓɨlɨ yi nɨmʉ, luki limoti, ɨmɨ, nakɛgʉ mʉtʉ wa ɔɓɨlɨ yi nɨmʉ. ");
INSERT INTO lik_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Kinili, namuɓikyi ɓi ambɛ mokwaga ndɛkɛ ka ɓʉnyɛ kunu. A ɓɛyɔ, makoɓinikyoni ɓɛ ɨmɨ nɨ, ‹Natʉ›, mokwaga ndɛkɛ ka ɓʉnyɛ kunu aka.» ");
INSERT INTO lik_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ɓamuusa kʉwa ndɨ ɓɛ: «Ɨwɛ mbɛyɨ nɨ wanɨ ɓɨkpɛ?» Yeso usikisya ndɨ ɓɛ: «Ɨmɨ nɨ nɨnɔ namʉɓɨkya ndɨ katʉkya ka mʉpʉnganagɨ. ");
INSERT INTO lik_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Na na makpʉmʉka makpʉ kamʉɓɨkya na kamubiso mino na mʉngɨmbɔ. Luki limoti, naɓɨkyaga ka ɔɓɨlɨ nɨlɔ aka lɔ nʉkana ndɨ na nɨnɔ etikoku ndɨ. Ɨyɨ, aɓɨkyaga lɨngʉnʉ.» ");
INSERT INTO lik_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ɓakɛgʉ ndɨ kaiba ɓɛ a ndɨ kaʉnzɨnɨlya ko bulya ka Abakɨ. ");
INSERT INTO lik_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yeso ʉɓɨkya kʉwa ndɨ ɓɛ: «Ngbingo yi nɨnɔ maɗokisa ndɛkɛ mino Mika-mʉmbanzʉ, miba kʉwa ndɛkɛ ɓɛ ɨmɨ nɨ ‹Natʉ›. Miba ɓɛ nakagyagɨgʉ luki gʉtʉgʉ limoti aka ka sɨpananɨsɔ kamɨ, luki limoti, naɓɨkyaga nɨlɔ aka lɔ Baba ewonisila ndɨ. ");
INSERT INTO lik_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Nɨnɔ etikoku ndɨ a pa imoti na ɨmɨ. Kɛsagʉ ndɨ mʉkaka, kyɛ nagyaga ɓongbinga ɓasɨ nɨlɔ aka lɔ aɓosogo.» ");
INSERT INTO lik_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ngbingo yi nɨnɔ Yeso a ndɨ mino kanzɨna ɓɛyɔ, ɓambanzʉ ɓakpʉ ɓaɓɨnɨkyana ndɨ. ");
INSERT INTO lik_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yeso ʉɓɨkya kʉwa ndɨ Ɓayuda nɨɓɔ ɓaɓɨnɨkyana ndɨ ɓɛ: «Makiko kaɓyɛ mʉnzɨna kamɨ ɓɨnza, miko ka lɨngʉnʉ ɓaɓɨɓya kamɨ. ");
INSERT INTO lik_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Miba ndɛkɛ lɨngʉnʉ, na lɨngʉnʉ amʉkʉlaga.» ");
INSERT INTO lik_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ɓasikisya ndɨ ɓɛ: «Ta lɨvananza ka Abalahamʉ, mʉmbanzʉ katibisagʉ iɓusu ɓusunzu gʉtʉgʉ lɨsyɛ limoti aka. Wakatɨɓɨkya lɨkɨ ɓɛ takʉlɨkanagatʉ ndɛkɛ?» ");
INSERT INTO lik_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yeso usikisya ndɨ ɓɛ: «A lɨngʉnʉ, a lɨngʉnʉ, nakamʉɓɨkya ambɛ, mʉtʉ wasɨ nɨnɔ agyaga ɓʉnyɛ a musunzu wa ɓʉnyɛ. ");
INSERT INTO lik_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Musunzu kikogigʉ ɓongbinga ɓasɨ ka lɨvananza. Luki limoti, miki ikaga ɨyɨ mino ka ɓongbinga ɓasɨ. ");
INSERT INTO lik_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Kika nɛkɨ nɨ Miki amukulogini, mika kʉwa ndɛkɛ ɓʉkʉlɨkanaga lɨngʉnʉ. ");
INSERT INTO lik_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nakaiba ambɛ ma lɨvananza ka Abalahamʉ. Luki limoti, makakɨsa kemwisiso, kyɛ makɛgʉ kabaɨlya mʉnzɨna kamɨ. ");
INSERT INTO lik_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ɨmɨ, nakaɓɨkya nɨlɔ nɨna ndɨ ka Baba. Iɓunu, makagya nɨlɔ mʉkana ndɨ na obonu.» ");
INSERT INTO lik_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ɓasikisya ndɨ ɓɛ: «Obosu nɨ Abalahamʉ.» Yeso aka ndɨ na ɨɓʉ ɓɛ: «Makiko ɓi ka lɨngʉnʉ ɓomika Abalahamʉ, makwanano ɓi kagya mʉɗɔngɔnɨ ɓɛyɔ Abalahamʉ agyaga ndɨ mino. ");
INSERT INTO lik_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Luki limoti, mbɨya wanʉ makakɨsa kemwisiso. Wɨna sɛ, Abalahamʉ kagyagʉ ndɨ ɨyɨ inguo ya lɨkpʉmʉka li nɨlɔ. Ɨmɨ namʉɓɨkyaga ndɨ lɨngʉnʉ nɨlɔ nʉkana ndɨ kotukyoku ko Kunzi. ");
INSERT INTO lik_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Iɓunu, makagya mʉɗɔngɔnɨ ɓɛyɔ obonu wagɔgɔ agyaga ndɨ mino.» Ɓasikisya ndɨ Yeso ɓɛ: «Takɛgʉ ɓomiki ɓa ɓʉɗanda. Obosu ɓemoti nɨ Kunzi aka.» ");
INSERT INTO lik_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yeso ʉɓɨkya ndɨ ɓɛ: «Kunzi kiko ɓi Obonu, makwananatʉ ɓi kɛpa. A ɓɛyɔ, ɨmɨ nopupa ndɨ ko Kunzi, nodoku sɛ kʉwa. Nakodokugʉ ndɨ ko ngu kamɨ ɓɨkpɛ, luki limoti, ɨyɨ nɔ etikoku ndɨ. ");
INSERT INTO lik_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ko bulya ɨkɨ yɔ makɛgʉ mino kotombisyo lɨkpʉmʉka nɨlɔ nakamʉɓɨkya? A kyɛ makakwananɨgʉ kaʉkana mʉnzɨna kamɨ. ");
INSERT INTO lik_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Obonu nɨ mumuyoniso, mapaga kagya nɨlɔ aka lɔ aɓosilogo. Ɨyɨ, a ndɨ mʉmwɔ ɓambanzʉ katʉkya ka mʉpʉnganagɨ. Gʉtʉgʉ lɨsyɛ limoti aka kanomogigʉ ndɛkɛ ka lɨngʉnʉ, kyɛ lɨngʉnʉ kɛgʉ kʉsɔ kakɨ. Ngbingo yi nɨnɔ aɓʉkʉlaga mino ɓɔngɔ, anzɨnaga ɨyɨ asɨ mʉɗɔngɔnɨ aka, kyɛ ikaga ɨyɨ ɓɛyɔ aka yɔ katʉkya ndɨ ka ɓʉndɛlɨ. A ɓɛyɔ, a mʉtʉ wa kʉɓɔɓɔkʉ na mombukwana kʉɓɔɓɔkʉ. ");
INSERT INTO lik_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Luki limoti, ɨmɨ naɓɨkyaga lɨngʉnʉ, kinili, makɛɓɨnɨkyanagɨgʉ. ");
INSERT INTO lik_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Mʉtʉ tino luga kunu nɔ akwanana kaɓɨkya ɓɨngbanganya ɓɛ nagya ndɨ ɓʉnyɛ? Kika nɛkɨ nɨ nakaɓɨkya lɨngʉnʉ, ko bulya ɨkɨ yɔ makɛgʉ mino kɛɓɨnɨkyana? ");
INSERT INTO lik_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Mʉtʉ ko Kunzi ʉkanaga lɨkpʉmʉka ko Kunzi. Kika nɨ iɓunu makʉkanagɨgʉ, a kyɛ makɛgʉ ɓatʉ ko Kunzi.» ");
INSERT INTO lik_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Kʉwa wa, Ɓayuda ɓasikisya ndɨ Yeso ɓɛ: «Iɓusu, toɓikyito ɓi lɨngʉnʉ ambɛ wa Musamalia, na gɔnɨ ɓɛ wa na lɨmbɛngɨ la ɓʉnyɛ.» ");
INSERT INTO lik_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yeso usikisya ndɨ ɓɛ: «Nakɛgʉ ɨmɨ na lɨmbɛngɨ la ɓʉnyɛ, luki limoti, naɓangagatʉ Baba. Iɓunu, makɛɓangagɨgʉ ɨmɨ. ");
INSERT INTO lik_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ɨmɨ, nakakɨsagɨgʉ ɨbɨba kamɨ, luki limoti, Kunzi nɔ ɛkɨsɨlyaga ɨmɨ. Ɨyɨ nɔ akɔgɔ mʉngɨmbɔ. ");
INSERT INTO lik_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","A lɨngʉnʉ, a lɨngʉnʉ, nakamʉɓɨkya ambɛ, mʉmbanzʉ koɓuulyogo mʉnzɨna kamɨ, kokwigʉ ndɛkɛ.» ");
INSERT INTO lik_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ɓayuda ɓaɓɨkya kʉwa ndɨ ɓɛ: «Mbɨya wanʉ, tibini sɛ kʉwa lɨngʉnʉ ambɛ wa na lɨmbɛngɨ la ɓʉnyɛ! Abalahamʉ okwoni ndɨ, ɓogyalandʉ ɓokwogo gɔnɨ. Ɨwɛ, wakaɓɨkya ɓɛ: ‹Mʉmbanzʉ koɓuulyogo mʉnzɨna kamɨ, kokwigʉ ndɛkɛ.› ");
INSERT INTO lik_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Wa mʉtʉ wa ɨbɨba kakɨtaga obosu ɓɛyɔ ka Abalahamʉ? Okwoni ndɨ, ɓogyalandʉ ɓokwogo gɔnɨ. Wa mbɛyɨ kaɨva abɛ wanɨ?» ");
INSERT INTO lik_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yeso osikisya ɓɛ: «Nakɨbɨba ɨmɨ mombukwana-dakɨ yi, ɨbɨba yi nɨyɔ kikigʉ na ɨzangɨya. Baba yi nɨnɔ maɓɨkyaga ɓɛ Obonu, ɨyɨ nɔ ɛbɨbaga ɨmɨ. ");
INSERT INTO lik_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Luki limoti, makamibigʉ. Ɨmɨ, namibatʉ ɨmɨ. Nakaɓɨkyo ɓi ambɛ nakamibigʉ, niko ɓi mʉtʉ waɓɔngɔ abɛ iɓunu. Luki limoti, namibatʉ na noɓuulyagatʉ mʉnzɨna kakɨ. ");
INSERT INTO lik_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Obonu ɓɛyɔ ka Abalahamʉ ogwaga ndɨ magyagya ka tamanaga kaɨna lɨsyɛ nɨlɔ nodoku ndɛkɛ mino. A lɨngʉnʉ, ɨnatʉ ndɨ, otumo na magyagya ɓɨɗɛ.» ");
INSERT INTO lik_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ɓayuda ɓaɓɨkya ndɨ ɓɛ: «Wakanotulyosigʉ ɓyanga ɓatɛkɛɓɛ kuɓukumuti. Wamɨna kʉwa ndɨ Abalahamʉ yi lɨkɨ?» ");
INSERT INTO lik_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yeso aka na ɨɓʉ ɓɛ: «A lɨngʉnʉ, a lɨngʉnʉ, nakamʉɓɨkya ambɛ, kambwa Abalahamʉ kaɨɓʉkʉta, ɨmɨ ‹natʉ.›» ");
INSERT INTO lik_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ɓapʉnaga kʉwa ndɨ matamʉ kamakaga nomu. Luki limoti, Yeso ɨsʉma ndɨ, opupo ka Ndaɓʉ ko Kunzi. ");
INSERT INTO lik_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Lɨsyɛ limoti, Yeso a ndɨ kakpakyana ko pisi, amɨna alʉkʉ ɓemoti nɨnɔ ɨɓʉkʉta ndɨ nɨ kɨnagɨgʉ. ");
INSERT INTO lik_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ɓaɓɨɓya kakɨ ɓamuusa ndɨ ɓɛ: «Muwonisilo, ko bulya ɨkɨ yɔ alʉkʉ yi nɨmʉ ɨɓʉkʉta ndɨ mino nɨ kɨnagɨgʉ? A ndɨ ko bulya ɓʉnyɛ kakɨ ikanɨ nɨɓɔ ka ɓaɓʉkʉta kakɨ?» ");
INSERT INTO lik_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yeso osikisya ndɨ ɓɛ: «Kɛgʉ ko bulya ɓʉnyɛ kakɨ ikanɨ nɨɓɔ ka ɓaɓʉkʉta kakɨ. Luki limoti, a ɓɛyɔ kyɛ ligubo ko Kunzi inisoni pisi kʉ kakɨ. ");
INSERT INTO lik_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Okwononi tagyɨ ligubo ka nɨnɔ etikoku ndɨ na lɨsyɛ. Biti a kʉwa kolipyo, ngbingo yi nɨnɔ mʉmbanzʉ kakwananɨgʉ mino kagya ligubo. ");
INSERT INTO lik_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ngbingo yi nɨnɔ na mbɛyɨ mino ka ɔɓɨlɨ, ɨmɨ nɨ ɓʉngbanganya ɓa ɔɓɨlɨ.» ");
INSERT INTO lik_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Nɨyɔ Yeso anzɨna ɓɛyɔ, aɓakya ndɨ ɓotikito ka lɨtɔmbʉ, opula kʉwa, agboɗya noɓu alʉkʉ yi nɨnɔ ko miso. ");
INSERT INTO lik_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Aɓɨkya ndɨ ɓɛ: «Wɨnda kaɨsʉkʉsa miso ka ziwa wa Siloamu.» Isi ya «Siloamu» nɨ «Mʉtʉ yi nɨnɔ ɓatiki». Alʉkʉ nɔ aga ndɨ ɓɛyɔ aka yɔ, ɨsʉkʉsa miso, igoku kʉwa nɨ anɨna ɓɨngbanganya. ");
INSERT INTO lik_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ɓapɨmbanɨ kakɨ na ɓatʉ nɨɓɔ ɓamɨnaga ndɨ kambwa kaɨkʉkʉngya, ɓuusa ndɨ ɓɛ: «Kɛgʉ mbɛyɨ alʉkʉ nɨnɔ ikaga ndɨ wakiko kaɨkʉkʉngya nɨmʉ?» ");
INSERT INTO lik_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ɓagɔgɔ ɓosikisya ndɨ ɓɛ: «Iyo, ɨyɨ aka nɔ.» Ɓagɔgɔ ɓata ɓɛ: «Kalɨ, kɛgʉ ɨyɨ, ɓaɓyɛnɛnɛ na ɨyɨ.» Luki limoti, alʉkʉ nɔ aɓɨkya ndɨ ɓɛ: «Ɨmɨ aka nɔ.» ");
INSERT INTO lik_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ɓamuusa kʉwa ndɨ ɓɛ: «Miso uhukwikoni ɓi lɨkɨ?» ");
INSERT INTO lik_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Osikisya ndɨ ɓɛ: «Alʉkʉ nɨnɔ ɓamakaga ɓɛ Yeso opuli ɓi lɨtɔmbʉ, egboɗyo nolu ko miso, ɛɓɨkya ɓɛ: ‹Wɨnda kaɨsʉkʉsa ka Siloamu.› Nago ɓi, nogyoku ɓɛyɔ aka yɔ, napʉnga kaɨna.» ");
INSERT INTO lik_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ɓamuusa ɓata ndɨ ɓɛ: «Alʉkʉ yi nɨnɔ a yanɨ?» Usikisya ɓɛ: «Sibigʉ.» ");
INSERT INTO lik_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Kʉwa wa, ɓɨnda ndɨ na alʉkʉ nɨnɔ ahʉka ndɨ nɔ kʉ ka Ɓafalisayɔ. ");
INSERT INTO lik_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Wɨkwɛ sɛ a ndɨ Lɨsyɛ la kimumbiso lɔ Yeso opula ndɨ mino lɨtɔmbʉ, ahukusa alʉkʉ yi nɨnɔ. ");
INSERT INTO lik_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ɓafalisayɔ ɓamuusa ndɨ gɔnɨ alʉkʉ yi nɨnɔ ɓɛ igyonosa ndɨ lɨkɨ ɓɛ apʉngɨ kaɨna ɓɛyɔ? Uɓɨkya ndɨ ɓɛ: «Egboɗya ndɨ lɨtɔmbʉ ko miso, nisukusoku, mbɨya wanʉ nakaɨna.» ");
INSERT INTO lik_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ɓafalisayɔ ɓagɔgɔ ɓaɓɨkya ndɨ ɓɛ: «Mʉtʉ yi nɨnɔ kɛgʉ mʉtʉ ko Kunzi, kyɛ kɛgʉ kaɓanga Lɨsyɛ la kimumbiso.» Luki limoti, ɓagɔgɔ ɓata ɓaɓɨkya ndɨ ɓɛ: «Mʉtʉ wanyɛ akwanana pɨyɛ kagya makpʉmʉka mʉmbanga-mbanga ɓɛnɛ lɨkɨ?» Ɓafalisayɔ ɓɨgbananaga ndɨ luga kaɓʉ. ");
INSERT INTO lik_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ɓamuusa ɓata ndɨ alʉkʉ nɨnɔ ahʉka ndɨ nɔ ɓɛ: «Ɨwɛ, wakaɓɨkya ɓʉ kʉgʉ ka mʉtʉ yi nɨnɔ uhukusi ɓi?» Osikisya ndɨ ɓɛ: «A mugyalandʉ.» ");
INSERT INTO lik_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Luki limoti, ɓangama ka Ɓayuda ɓakaɓɨnɨkyanagʉ ndɨ ɓɛ alʉkʉ nɔ ɨɓʉkʉta ndɨ nɨ kɨnagɨgʉ, mbɨya wanʉ akaɨna ɓɨngbanganya. Ɓʉmaka kʉwa ndɨ ɓaɓʉkʉta kakɨ, ");
INSERT INTO lik_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ɓumuusa ndɨ ɓɛ: «Alʉkʉ yi nɨmʉ a mikunu ɓɨkpɛ? Makaɓɨkya lɨngʉnʉ ɓɛ ɨɓʉkʉta ndɨ kanɨ kɨnagɨgʉ? Ɨkɨ yɔ igyonosi kʉwa ɓɛ apʉngɨ kaɨna?» ");
INSERT INTO lik_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ɓaɓʉkʉta kakɨ ɓosikisya ndɨ ɓɛ: «Takaiba ɓɛ a mikusu na ɨɓʉkʉta ndɨ nɨ kɨnagɨgʉ. ");
INSERT INTO lik_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Luki limoti, takɛgʉ kaiba ɓɛyɔ opungi mino kaɨna ɓɛnɛ. Takɛgʉ gɔnɨ kamibo mʉtʉ yi nɨnɔ ahukusi. Takibigʉ iɓusu. Mumuusogono ɨyɨ aka, a kʉwa iti ya mʉmbanzʉ, akwanana kamʉtʉmbʉlyaga.» ");
INSERT INTO lik_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ɓaɓʉkʉta kakɨ ɓaɓɨkya ndɨ ɓɛyɔ kyɛ ɓa ndɨ kaʉɓanga ɓangama ka Ɓayuda. A ɓɛyɔ, ɨɓʉ ɓangama ɓi nɨɓɔ ɓa ndɨ nɨ ɓukononini ɓɛ mʉmbanzʉ kaɓɨkya ɓɛ Yeso nɨ Masiya, ɓakpumyo lɨngʉnʉ ka ndaɓʉ ya malʉmba. ");
INSERT INTO lik_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Kinili, ɓaɓʉkʉta ko miki yi nɨnɔ ɓosikisya ndɨ ɓɛ: «A iti ya mʉmbanzʉ, mumuusogoni ɨyɨ aka.» ");
INSERT INTO lik_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ka nganga ya yɨɓa, Ɓafalisayɔ ɓamaka ndɨ ɓata alʉkʉ yi nɨnɔ ahʉka ndɨ nɔ, ɓaɓɨkya ndɨ ɓɛ: «Ɓɨkya lɨngʉnʉ kambwa ko Kunzi. Iɓusu, takaiba ambɛ mʉtʉ yi nɨnɔ a mʉtʉ wanyɛ.» ");
INSERT INTO lik_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Usikisya ndɨ ɓɛ: «Nakibigʉ ikanɨ a mʉtʉ wanyɛ. Luki limoti, nakaiba lɨkpʉmʉka limoti aka: nakɨnagɨgʉ ndɨ, mbɨya wanʉ na kʉwa kaɨna.» ");
INSERT INTO lik_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ɓamuusa ndɨ ɓɛ: «Ugyi ɓi ɓʉ? Uhukusi ɓi lɨkɨ?» ");
INSERT INTO lik_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Usikisya ndɨ ɓɛ: «Namutumbulyogini ɓi, luki limoti, makɛgʉ kaʉkana. Ko bulya ɨkɨ makapa ɓɛ namʉtʉmbʉlyagɨ ɓata? Ma kʉwa gɔnɨ iɓunu kapa kaɨɨta ɓaɓɨɓya kakɨ?» ");
INSERT INTO lik_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ɓapʉnga kʉwa ndɨ katʉmbwa, ɓanaɓɨkya ɓɛ: «Sɨ ɨwɛ nɔ wa mʉɓɨɓya kakɨ! Luki limoti, ta iɓusu ɓaɓɨɓya ka Musa. ");
INSERT INTO lik_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Iɓusu, tibagatʉ ɓɛ Kunzi akpʉmʉkaga ndɨ na Musa. Luki limoti, mʉtʉ yi nɨmʉ, takibigʉ ɓɛ apʉnya yanɨ!» ");
INSERT INTO lik_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Alʉkʉ nɔ usikisya ndɨ ɓɛ: «Lɨkpʉmʉka lɨmbanga a kyɛ makibigʉ ɓɛ apʉnya yanɨ, luki limoti, ehukusini! ");
INSERT INTO lik_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Takaiba ɓɛ Kunzi kʉmʉkanagɨgʉ ɓatʉ ɓanyɛ. Luki limoti, amʉkanaga mʉtʉ wasɨ nɨnɔ aɓangaga, anagya sɨpananɨsɔ kakɨ. ");
INSERT INTO lik_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Tanukonigʉ ndɛkɛ ɓɛ mʉmbanzʉ ahukusini mʉtʉ nɨnɔ ɨɓʉkʉta ndɨ nɨ kɨnagɨgʉ. ");
INSERT INTO lik_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Alʉkʉ yi nɨmʉ kotukyiku ndɨ ko Kunzi, kakwananɨgʉ ɓi kagya luki.» ");
INSERT INTO lik_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ɓasikisya ndɨ ɓɛ: «Katʉkya wa aka wa ɓʉɓʉkʉta ndɨ mino, wikaga ɨwɛ ka ɓʉnyɛ aka. Wakapa kʉwa katɨtɨwa?» Kʉwa wa, ɓapupisa ndɨ kunzi wa ndaɓʉ ya malʉmba. ");
INSERT INTO lik_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yeso ʉkana ndɨ mongoni ɓɛ Ɓafalisayɔ ɓakpumyini alʉkʉ nɨnɔ ahʉka ndɨ nɔ. Ɨnda kʉwa ndɨ katakanya, amuusa ɓɛ: «Watʉ kaɓɨnɨkyana Mika-mʉmbanzʉ?» ");
INSERT INTO lik_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Alʉkʉ nɔ asikisya ndɨ ɓɛ: «Mombukwono-dosu, ɨɓɨkya ɓɛ ɨyɨ nɨ wanɨ iba naɓɨnɨkyanɨ.» ");
INSERT INTO lik_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yeso aɓɨkya ndɨ ɓɛ: «Ɛɛɛ, waminini, ɨyɨ nɔ wakanzɨna na ɨyɨ mbɨya wanʉ.» ");
INSERT INTO lik_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Alʉkʉ nɔ aɓɨkya kʉwa ndɨ ɓɛ: «Mombukwono-dosu, noɓinikyonini.» Oɓuna ndɨ moli kambwa kakɨ. ");
INSERT INTO lik_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Kumbuso yi, Yeso aka ndɨ ɓɛ: «Ɨmɨ, nodoku ndɨ ka ɔɓɨlɨ ko bulya mʉngɨmbɔ: okwononi ɓɛ ɓatʉ ɓa ɓokoloɓu ɓaya mamɔmɔ ɓɨnɨ na nɨɓɔ ɓɨnaga ɓagʉna ɓokoloɓu ɓaya mamɔmɔ.» ");
INSERT INTO lik_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Nɨyɔ Ɓafalisayɔ ɓagɔgɔ nɨɓɔ ɓa ndɨ pa imoti na ɨɓʉ ɓʉkana mʉnzɨna mi nɨmɔ ɓɛyɔ, ɓamuusa kʉwa ndɨ ɓɛ: «Ambɛ, ta kʉwa gɔnɨ iɓusu ɓʉgʉna koloɓu ya mamɔmɔ?» ");
INSERT INTO lik_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yeso usikisya ndɨ ɓɛ: «Makiko ɓi no koloɓu ya mamɔmɔ, makikigʉ ɓi na ɓʉnyɛ. Luki limoti, mbɨya wanʉ makaɓɨkya ɓɛ: ‹Takaɨna.› Kinili, ma ka ɓʉnyɛ aka.» ");
INSERT INTO lik_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yeso oɓikyoku ndɨ ɓɛ: «A lɨngʉnʉ, a lɨngʉnʉ, nakamʉɓɨkya ambɛ, mʉmbanzʉ kogulyi pisi ka mupumi ma lindilo ka ɓakɔndɔlɔ, luki limoti aɗaka, ingya ka ngala, a mʉtʉ wo kuɓakʉ na munzikaɓʉ. ");
INSERT INTO lik_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Luki limoti, muɓuɓulyo ka ɓakɔndɔlɔ nɔ ogulyaga ɨyɨ pisi ka mupumi. ");
INSERT INTO lik_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Zamʉ ahukwilyaga mupumi, ɓakɔndɔlɔ ɓʉkana lɨyʉ ka muɓuɓulyo. Ɨyɨ, apʉnga kaʉmaka yɨkaka-yɨkaka no mino kaɓʉ, upupisa kunzi. ");
INSERT INTO lik_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Kupupiso ɓasɨ kunzi, akɨtaga kambwa kaɓʉ, apʉnga kakpakyana. Ɓakɔndɔlɔ aka ɓingbooo kumbusa kakɨ kyɛ ɓibatʉ lɨyʉ kakɨ. ");
INSERT INTO lik_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ɓakaɓɨɓyagɨgʉ mubiko. Luki limoti, ɓomisikono ɓingbwi, kyɛ ɓakibigʉ lɨyʉ ka mubiko.» ");
INSERT INTO lik_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yeso ʉtwɨlya ndɨ lizuni li nɨlɨ, luki limoti, ɓambanzʉ ɓakotombisyagʉ ndɨ. ");
INSERT INTO lik_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yeso ʉɓɨkya ɓata ndɨ ɓɛ: «A lɨngʉnʉ, a lɨngʉnʉ, nakamʉɓɨkya ambɛ, ɨmɨ nɨ mupumi ma lindilo ka ɓakɔndɔlɔ. ");
INSERT INTO lik_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ɓasɨ nɨɓɔ ɓodoku ndɨ kambwa kamɨ, ɓa ɓatʉ ɓo kuɓakʉ na ɓonzikaɓʉ. Luki limoti, ɓakɔndɔlɔ ɓakʉmʉkanagʉ ndɨ. ");
INSERT INTO lik_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ɨmɨ nɨ mupumi. Mʉmbanzʉ kingyo pisi kʉ kamɨ inisanatʉ na muhukuso. Akwananatʉ kaingyo, opupoku, atakanya malɨlɨ aka. ");
INSERT INTO lik_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Mʉtʉ wo kuɓakʉ odogoku ɨyɨ kaiɓo aka, kamwɔ na kapʉta. Ɨmɨ, nodoku kyɛ ɓambanzʉ ɓinisoni na ɔɓɨlɨ, na ɓiki na ɨyɨ wakpʉ kʉgbɛ. ");
INSERT INTO lik_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ɨmɨ na muɓuɓulyo wanza. Muɓuɓulyo wanza apága ɔɓɨlɨ kakɨ ko bulya ɓakɔndɔlɔ kakɨ. ");
INSERT INTO lik_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Luki limoti, mʉtʉ yi nɨnɔ ogugubyaga ɓuyi aka kɛgʉ muɓuɓulyo, na gʉtʉgʉ ɓakɔndɔlɔ aka ɓakɛgʉ ɓakakɨ. Kamɨna sukopi kodoku, ʉsa, apɨkɨta. Sukopi yi nɨnɔ ubumbukya ɓakɔndɔlɔ, umisyo ɓingbwi. ");
INSERT INTO lik_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","A ɓɛyɔ, alʉkʉ yi nɨnɔ agyaga ligubo ko bulya ɓuyi aka, kikogigʉ no kumbu ka ɓakɔndɔlɔ. ");
INSERT INTO lik_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Ɨmɨ na muɓuɓulyo wanza. Numibatʉ ɓakɔndɔlɔ kamɨ, ɓakɔndɔlɔ kamɨ ɓemiba gɔnɨ, ");
INSERT INTO lik_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","mʉɗɔngɔnɨ ɓɛyɔ Baba emibaga mino, namiba gɔnɨ Baba. Ɨmɨ, nakapá ɔɓɨlɨ kamɨ ko bulya ɓakɔndɔlɔ kamɨ. ");
INSERT INTO lik_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Natʉ ɓata na ɓakɔndɔlɔ ɓagɔgɔ nɨɓɔ ɓakɛgʉ ka lindilo li nɨlɨ. Nokwononi gɔnɨ kaaga na ɨɓʉ, ɓʉkana lɨyʉ kamɨ. Moɗu masɨ maɓa ɓodoku kʉwa ambaza ɓemoti na muɓuɓulyo ɓemoti. ");
INSERT INTO lik_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Baba ɛpaga kyɛ nakapá ɔɓɨlɨ kamɨ, kumbuso yi, ninisanatʉ ɓata na ɨyɨ. ");
INSERT INTO lik_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Kɛgʉ na mʉmbanzʉ nɨnɔ akwanana kɛkʉpya ɔɓɨlɨ, luki limoti, nakapá na lɨmbɛngɨ kamɨ. Na no ngu kapá, na no ngu kainisono ɓata na ɨyɨ. Nɨyɔ akaɓyɛnɛnɛ na mʉtʉʉ nɨmɔ Baba ɛpá ndɨ.» ");
INSERT INTO lik_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ɓayuda ɓɨgbananaga ɓata ndɨ ka nganga ya yɨɓa ko bulya mʉnzɨna mi nɨmɔ. ");
INSERT INTO lik_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ɓatʉ ɓudingi luga kaɓʉ ɓaɓɨkya ndɨ ɓɛ: «A na lɨmbɛngɨ la ɓʉnyɛ! A na ibikyasʉ! Ma mbɛyɨ kamʉkana ko bulya ɨkɨ?» ");
INSERT INTO lik_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Luki limoti, ɓatʉ ɓagɔgɔ ɓɛ: «Mʉnzɨna mi nɨma kɛgʉ mʉnzɨna ka mʉtʉ wa lɨmbɛngɨ la ɓʉnyɛ. Lɨmbɛngɨ la ɓʉnyɛ akwanana mbɛyɨ kauhukuso ɓatʉ ɓa ɓokoloɓu ɓaya mamɔmɔ lɨkɨ?» ");
INSERT INTO lik_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ka masyɛ mi nɨmɔ, ɓa ndɨ kalya dumo wakɨgɨlya koukwo Ndaɓʉ ko Kunzi ka Yelusalɛma. A ndɨ ko ngbingo wa ɓʉdɨ ɓapʉ. ");
INSERT INTO lik_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yeso a ndɨ kaɨnanaga magʉ ka Ndaɓʉ ko Kunzi kʉ ka Pa nɨyɔ ɓalɨkyaga ɓɛ Pa ka Sɔlɔmɔnɔ. ");
INSERT INTO lik_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ɓayuda ɓakungula kʉwa ndɨ ɓikululu, ɓamuusa ndɨ ɓɛ: «Wakatigbomisa ɓamʉ ɓɛnɛ kadwɛ ko ngbingo tino? Kika nɨ ɨwɛ nɨ Masiya, tɨɓɨkya nɛkɨ ɓɨngbanganya.» ");
INSERT INTO lik_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yeso usikisya ndɨ ɓɛ: «Namuɓikyoni ndɨ. Luki limoti, makaɓɨnɨkyanagɨgʉ. Mogubo nɨmɔ nakagya ko lino ka Baba imu mɔ akepupilyo ɓʉdɛmʉ. ");
INSERT INTO lik_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Luki limoti, iɓunu, makɛgʉ kaɓɨnɨkyana kyɛ makɛgʉ ɓakɔndɔlɔ kamɨ. ");
INSERT INTO lik_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ɓakɔndɔlɔ kamɨ ɓʉkanagatʉ lɨyʉ kamɨ, numibagatʉ, na ɓɛɓɨɓyagatʉ. ");
INSERT INTO lik_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ɨmɨ, nʉpága ɔɓɨlɨ wa ɓɛnzɛ na ɓɛnzɛ, ɓakoɓungogigʉ ndɛkɛ. Gʉtʉgʉ mʉmbanzʉ ɓemoti aka kɛkʉpyɨgʉ ndɛkɛ ya kaɓʉ. ");
INSERT INTO lik_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Baba nɔ ɛpá ndɨ ya kaɓʉ, na ɨyɨ a no ngu kakɨtaga makpʉmʉka masɨ. Kɛgʉ na mʉmbanzʉ gʉtʉgʉ ɓemoti aka nɨnɔ akwanana kakʉpya luki. ");
INSERT INTO lik_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Wɨna sɛ, iɓusu na Baba ta luki limoti.» ");
INSERT INTO lik_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ɓayuda ɓɨgɨlya kʉwa ndɨ kava matamʉ ɓɛ ɓamakagɨ nomu. ");
INSERT INTO lik_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yeso ʉɓɨkya ndɨ ɓata ɓɛ: «Namuwonisila ndɨ mogubo manzanza mudingi kotukyoku ka Baba. Luga wa mogubo mi nɨmɔ, tino lɔ mo mino kapa kɛmaka na matamʉ?» ");
INSERT INTO lik_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ɓayuda ɓasikisya ndɨ ɓɛ: «Kɛgʉ ko bulya ligubo lanza lɔ to mino kapa kaʉmakaga na matamʉ, luki limoti, a kyɛ wakatʉmbwa Kunzi. Ɨwɛ wa mikya-ɓambanzʉ aka na wakapa kaɨgya abɛ Kunzi.» ");
INSERT INTO lik_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yeso usikisya ndɨ ɓɛ: «Ikpikaga ka mʉtʉʉ kunu ɓɛ Kunzi aɓɨkya ndɨ ɓɛ: ‹Iɓunu ma ɓokunzi.› ");
INSERT INTO lik_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Mʉmbanzʉ gʉtʉgʉ ɓemoti aka kakwananɨgʉ kolimogo Moɓiso. Luki limoti, Kunzi ʉmaka ndɨ ɓɛ ɓokunzi ɓatʉ nɨɓɔ ɓamʉkanaga ndɨ. ");
INSERT INTO lik_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Baba ɛpʉnaga ndɨ ɨmɨ, etikoku ka ɔɓɨlɨ. Kinili, naɓɨkyaga ɓɛ na Miko Kunzi. Makwanana pɨyɛ kaɓɨkya lɨkɨ ɓɛ nakatʉmbwa Kunzi? ");
INSERT INTO lik_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Kika nɨ nakɛgʉ kagya mogubo ka Baba, makeɓinikyonito. ");
INSERT INTO lik_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Luki limoti, nakagya, ɓinikyononi gʉtʉgʉ kʉwa mogubo kamɨ aka, gʉtʉgʉ makɛɓinikyoni ɨmɨ. Wiboni, motombisyo ɓɨnza ɓɛ Baba a kʉsɔ kamɨ, na ɨmɨ kʉsɔ kakɨ.» ");
INSERT INTO lik_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ɓakɨsa ɓata ndɨ kagwi, luki limoti, ʉʉkaga. ");
INSERT INTO lik_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yeso ɨga ndɨ kʉsyakʉ wa Yɔlɔdanɨ kʉ Yuani oɓotisaga ndɨ mino ka ɓʉndɛlɨ, ika ndɨ kʉ ɓɛyɔ. ");
INSERT INTO lik_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ɓambanzʉ ɓudingi ɓadulyoku ndɨ, ɓanaɓɨkya ɓɛ: «Yuani kagyagʉ ndɨ lɨkpʉmʉka lɨmbanga gʉtʉgʉ limoti aka. Luki limoti, lasɨ nɨlɔ atʉmbʉlaga ndɨ ko bulya ka Yeso a ndɨ lɨngʉnʉ.» ");
INSERT INTO lik_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Na kʉ ɓɛyɔ, ɓatʉ ɓudingi ɓaɓɨnɨkyana ndɨ. ");
INSERT INTO lik_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","A ndɨ na mʉtʉ wo koloɓu ɓemoti nɨnɔ ina ndɨ ɓɛ Lazalɔ. Ɨyɨ Lazalɔ ikaga ndɨ ka mugi ma Betania. Ɓasalɨ kakɨ ɓɛyɔ ka Malia na Malata ɓikaga ndɨ kʉ gɔ kʉ. ");
INSERT INTO lik_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(A Malia yi nɨnɔ ogboɗya ndɨ magʉ ka Mombukwono-dosu na malazi, akpaga no tukatʉ kakɨ. Mamakɨ ɓɛyɔ ka Lazalɔ nɔ a ndɨ no koloɓu.) ");
INSERT INTO lik_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ɓasalɨ ɓaɓa ɓi nɨɓɔ ɓatɨkɨlya ndɨ Yeso mayʉ ɓɛ: «Mombukwono-dosu, wai-dakʉ akaɨmʉkana.» ");
INSERT INTO lik_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Nɨyɔ Yeso ʉkana mino mongoni mi nɨmɔ, ɨyɨ aka ɓɛ: «Kokwigʉ no koloɓu yi nɨyɔ. Luki limoti, isi yi nɨ kowonisilo ɨbɨba ko Kunzi, kyɛ Mikakɨ avɨ ɨbɨba.» ");
INSERT INTO lik_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Wɨna sɛ, Yeso apaga ndɨ Lazalɔ pa imoti na ɓasalɨ kakɨ ɓɛyɔ ka Malia na Malata. ");
INSERT INTO lik_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Luki limoti, nɨyɔ ʉkana ndɨ ɓɛ Lazalɔ a no koloɓu, agya mbɛyɨ ɓata masyɛ maɓa ka pa nɨyɔ a ndɨ mino yɔ, ");
INSERT INTO lik_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","kumbuso yi, ʉɓɨkya ndɨ ɓaɓɨɓya kakɨ ɓɛ: «Tigini ɓata ka Yudɛa.» ");
INSERT INTO lik_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ɓaɓɨɓya ɓaɓɨkya ndɨ ɓɛ: «Muwonisilo, Ɓayuda ɓo ɓi kakɨsa kaʉmwɔ na matamʉ mbɨya aka ɓi wanʉ. Wa ɓata kapa kaɨga kʉ ɓɛyɔ?» ");
INSERT INTO lik_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yeso usikisya ndɨ ɓɛ: «Takɛgʉ mbɛyɨ na ɓasaa tɛkɛɓɛ na ɓaɓa ka lɨsyɛ limoti? Kika nɨ mʉmbanzʉ akakpakyana na lɨsyɛ kakwananɨgʉ kasakaga, kyɛ akaɨna ɓɨngbanganya. ");
INSERT INTO lik_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Luki limoti, mʉmbanzʉ kakpakyana no biti, asakagatʉ kyɛ kɛgʉ kaɨna ɓɨngbanganya.» ");
INSERT INTO lik_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Kumbuso kaɓɨkya ɓɛyɔ, Yeso amatɨla ɓata ndɨ ɓɛ: «Wai-dosu ɓɛyɔ ka Lazalɔ a ka tɔtɔ, luki limoti, nakaɨnda kazuzukiso.» ");
INSERT INTO lik_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ɓaɓɨɓya ɓaɓɨkya ndɨ ɓɛ: «Mombukwono-dosu, kika nɨ a ka tɔtɔ, ahʉkatʉ.» ");
INSERT INTO lik_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","A ɓɛyɔ, Yeso a ndɨ kaɓɨkya ɓɛ Lazalɔ okwini, luki limoti, ɓaɓɨɓya ɓa ndɨ ɨɓʉ kasɨma ɓɛ a kanzɨna ko bulya tɔtɔ aka. ");
INSERT INTO lik_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Yeso ʉɓɨkya kʉwa ndɨ ɓɨngbanganya ɓɛ: «Lazalɔ okwini ɓi. ");
INSERT INTO lik_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Nakogwa magyagya ko bulya kunu, kyɛ nakɛgʉ ɓi kʉ. Na ɓɛyɔ, makwananatʉ kɛɓɨnɨkyana. Luki limoti, togoni kʉ kakɨ.» ");
INSERT INTO lik_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Kʉwa wa, Tʉma nɨnɔ ɓamakaga gɔnɨ ɓɛ «Muɓigi» ʉɓɨkya ndɨ ɓaɓɨɓya ɓadakɨ ɓɛ: «Togoni nɛkɨ kʉwa ɓasɨ aka, iba tolumwogi pa imoti na ɨɓʉ.» ");
INSERT INTO lik_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Nɨyɔ Yeso osila ndɨ, atakanya Lazalɔ nɨ a kʉwa na masyɛ makwanganya ka mbʉkʉ. ");
INSERT INTO lik_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania a ɓuwobi na Yelusalɛma, banda ɓakilɔmɛtɛlɛ ɓasaa aka. ");
INSERT INTO lik_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Kinili, Ɓayuda ɓakpʉ ɓa ndɨ nɨ ɓodunuku katakanya Malia na Malata, kautumiso mambɛngɨ ko bulya kukwakʉ ka mamaɓʉ. ");
INSERT INTO lik_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ngbingo yi nɨnɔ Malata ʉkana mino ɓɛ Yeso akodoku, ɨnda ndɨ katɨlya. Luki limoti, Malia asɨkana ndɨ ɨyɨ wakiko ka ndaɓʉ. ");
INSERT INTO lik_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Malata aɓɨkya ndɨ Yeso ɓɛ: «Mombukwono-dosu, wakiko ɓi wanʉ, iba mika-mama kokwigʉ. ");
INSERT INTO lik_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Luki limoti, mbɨya wanʉ, nakaiba ambɛ masɨ nɨmɔ wakʉnga Kunzi, ʉpátʉ.» ");
INSERT INTO lik_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yeso aɓɨkya ndɨ ɓɛ: «Mamakʉ akopupa ka mbʉkʉ.» ");
INSERT INTO lik_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Malata asikisya ndɨ ɓɛ: «Nakaiba ambɛ opupokuto ndɛkɛ ngbingo yi nɨnɔ ɓambanzʉ ɓopupa ndɛkɛ mino ka lɨsyɛ la muliɓo.» ");
INSERT INTO lik_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yeso aka ndɨ na ɨyɨ ɓɛ: «Ɨmɨ nɔ nupupisaga ɓambanzʉ ka ɓambʉkʉ, ɨmɨ nɨ ɔɓɨlɨ. Mʉtʉ yi nɨnɔ ɛɓɨnɨkyana, ika ndɛkɛ na ɔɓɨlɨ gʉtʉgʉ kokwo. ");
INSERT INTO lik_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Mʉmbanzʉ wasɨ nɨnɔ ikaga kʉsɔ kamɨ, kɛɓɨnɨkyana, kokwigʉ ndɛkɛ. Watʉ kaɓɨnɨkyana lɨkpʉmʉka li nɨlɔ?» ");
INSERT INTO lik_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Asikisya ndɨ ɓɛ: «Iyo, Mombukwono-dosu, nakaɓɨnɨkyana ambɛ ɨwɛ nɨ Masiya, Miko Kunzi, nɨnɔ akwanana ndɨ kodoku ka ɔɓɨlɨ.» ");
INSERT INTO lik_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Nɨyɔ Malata aɓɨkya ɓɛyɔ, aga ndɨ. Kʉwa wa, amaka Malia, aɓɨkya na ɓepisi-pisi ɓɛ: «Muwonisilo a kʉ, akaʉmaka.» ");
INSERT INTO lik_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Nɨyɔ aka yɔ Malia ʉkana ɓɛyɔ, atʉkya ndɨ ɓɨkwa, ɨnda katakanya. ");
INSERT INTO lik_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Wɨna sɛ, Yeso a ndɨ nɨ kanodwigʉ ka mʉsɛngɨ. A mbɛyɨ ndɨ ka pa nɨyɔ Malata ɨnda ndɨ mino katɨlya. ");
INSERT INTO lik_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ɓayuda nɨɓɔ ɓa ndɨ katumisa Malia lɨmbɛngɨ ka ndaɓʉ kʉ, ɓamɨna ndɨ kaamaga ɓɨkwa na kopupo. Ɓaɓyɛ, ɓa ndɨ kasɨma ɓɛ akaɨnda kagama ka mbʉkʉ. ");
INSERT INTO lik_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Nɨyɔ Malia osila kʉ Yeso a ndɨ mino, amɨna, ogwa ka magʉ kakɨ, aɓɨkya ɓɛ: «Mombukwono-dosu, wakiko ɓi wanʉ, iba mika-mama kokwigʉ.» ");
INSERT INTO lik_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ngbingo yi nɨnɔ Yeso amɨna ndɨ mino kagama, ʉmɨna gɔnɨ Ɓayuda nɨɓɔ ɓodoku ndɨ na ɨɓʉ kagama, nzʉyɨ atwa ndɨ ɓɨkyakyakya, alya kumbu kʉgbɛ. ");
INSERT INTO lik_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Uusa ndɨ ɓɛ: «Mabisiku ɓi yanɨ?» Ɓasikisya ɓɛ: «Mombukwono-dosu, dawɨnɨnɔ.» ");
INSERT INTO lik_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yeso agama ndɨ. ");
INSERT INTO lik_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ɓayuda ɓaɓɨkya kʉwa ndɨ ɓɛ: «A lɨngʉnʉ, a ndɨ wai-dakɨ aka!» ");
INSERT INTO lik_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Luki limoti, ɓagɔgɔ luga kaɓʉ ɓaɓɨkya ndɨ ɓɛ: «Sɨ ɨyɨ nɔ ahukusa ndɨ mʉtʉ wo koloɓu ya mamɔmɔ. Kakwananɨgʉ gɔnɨ ɓi kakpɨngbɨlya Lazalɔ kukwakʉ?» ");
INSERT INTO lik_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Nzʉyɨ atwa ɓata ndɨ Yeso, aga ka mbʉkʉ. Mbʉkʉ yi nɨyɔ ɓakpɔ ndɨ ka lɨtalʉ, ɓotikya na lɨtalʉ lidingi ɓikpwu. ");
INSERT INTO lik_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yeso aɓɨkya ndɨ ɓɛ: «Tumboni lɨtalʉ!» Mamakɨ Lazalɔ ɓɛyɔ ka Malata aɓɨkya ɓɛ: «Mombukwono-dosu, a kʉwa kolumbo, kyɛ a kʉwa na masyɛ makwanganya wa ɓalumbi ɓi mino.» ");
INSERT INTO lik_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yeso asikisya ndɨ ɓɛ: «Nakuɓikyigʉ mbɛyɨ ɓi ambɛ wakaɓɨnɨkyana, wɨnatʉ ɨbɨba ko Kunzi?» ");
INSERT INTO lik_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ɓatʉmba kʉwa ndɨ lɨtalʉ. Yeso ɨkwɛ ndɨ kʉgʉ wa lɨsyɛ, aɓɨkya ɓɛ: «Babooo, nakaubibiso kyɛ wemukonini. ");
INSERT INTO lik_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ɨmɨ, nibagatʉ ambɛ wɛmʉkanaga masyɛ masɨ. Luki limoti, noɓikyi ɓɛyɔ ko bulya ka ɓambanzʉ nɨɓana ɓekunguli ɓa, iba ɓaɓɨnɨkyanitɔ ɓɛ ɨwɛ nɔ wetikoku ndɨ.» ");
INSERT INTO lik_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Nɨyɔ aɓɨkya ɓɛyɔ, apamɨkana ndɨ na lɨyʉ lapʉ ɓɛ: «Lazalɔ, pupoku!» ");
INSERT INTO lik_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Opupoku kʉwa ndɨ, magʉ na maɓɔkʉ mʉkandaga na ɓapanga ɓaya ɓotu, miso mutikya na kutuko. Yeso ʉɓɨkya kʉwa ndɨ ɓɛ: «Mukulogoni, masa aga.» ");
INSERT INTO lik_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ɓayuda ɓakpʉ nɨɓɔ ɓodoku ndɨ ka Malia, ɓaɓɨnɨkyana ndɨ Yeso kaɨna nɨlɔ agya ndɨ. ");
INSERT INTO lik_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Luki limoti, ɓagɔgɔ luga kaɓʉ, ɓɨnda ndɨ ka Ɓafalisayɔ na ɓʉtʉmbʉlyaga lɨkpʉmʉka nɨlɔ Yeso agya ndɨ lɔ. ");
INSERT INTO lik_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Kʉwa wa, ɓokumu-kumu na Ɓafalisayɔ ɓamʉmʉkana ndɨ ka Basa-Yidingi kaɓʉ, ɓaɓɨkya ɓɛ: «Tagya sɛ ɓʉ? Alʉkʉ mʉna a kʉwa kagya mokingyosi makpʉ. ");
INSERT INTO lik_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Takasɨlya ngbingo kagyaga aka ɓɛyɔ, ɓatʉ ɓasɨ ɓaɓɨnɨkyanatʉ. Kumbuso yi, Ɓalʉma ɓodoku kʉwa ɓanʉ kapʉta Ndaɓʉ ko Kunzi na mugi kusu.» ");
INSERT INTO lik_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Luki limoti, ɓemoti luga kaɓʉ, nɨnɔ ina ndɨ ɓɛ Kayafa na nɨnɔ a ndɨ kumu-kumu ka syangasʉ si nɨsɔ, ʉɓɨkya ndɨ ɓɛ: «Iɓunu, makibigʉ luki! ");
INSERT INTO lik_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Makibigʉ ambɛ a gʉtʉgʉ ɓɨnza mʉmbanzʉ ɓemoti kokwo ko bulya ka ɓatʉ ɓudingi? Kigyonoso ɓɛyɔ, lɨvananza lasɨ kolumwogigʉ.» ");
INSERT INTO lik_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","(Mʉnzɨna mi nɨmɔ kotukyokugʉ ndɨ kakɨ ka mombukwana-dakɨ yi. Luki limoti, ɓɛyɔ a ndɨ mino kumu-kumu ka syangasʉ nɨsɔ, a ndɨ kaɓɨkya na ɓugyalandʉ ɓɛ Yeso akwanana ndɨ kokwo ko bulya lɨvananza ka Ɓayuda. ");
INSERT INTO lik_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Na kukwakʉ kakɨ kɛgʉ asɨ ko bulya ka Ɓayuda aka. Luki limoti, a gɔnɨ ko bulya kaʉmʉmʉla ka imoti, ɓomiko Kunzi nɨɓɔ ɓomisikana ndɨ ɓingbwi.) ");
INSERT INTO lik_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Katʉkya kʉwa ndɨ ka lɨsyɛ nɨlɔ aka lɔ, ɓangama ka Ɓayuda ɓʉkanana ndɨ kamwisiso Yeso. ");
INSERT INTO lik_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Kinili, Yeso kipupisogigʉ ndɨ ɓata ɓɨngbanganya luga ka Ɓayuda. Luki limoti, atʉkya kʉwa ndɨ wa, ɨnda ka iwili nɨyɔ ɓuwobi na ɨsa, ka gʉɗʉ nɨnɔ ina ndɨ ɓɛ Efulaimu. Ɓikaga kʉwa ndɨ kʉ pa imoti na ɓaɓɨɓya kakɨ. ");
INSERT INTO lik_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Yɨnga ya Pasɨka ka Ɓayuda a kʉwa ndɨ ɓuwobi. Ɓambanzʉ ɓudingi ɓatʉkya ndɨ ko giyo kaɓʉ, ɓaɗamba ka Yelusalɛma kaiɓuɓiso kambwa wa yɨnga ya Pasɨka. ");
INSERT INTO lik_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ɓa ndɨ kakɨsa Yeso ɓɨvaka-vaka, ɓanimuuso luga kaɓʉ kʉ ka Ndaɓʉ ko Kunzi ɓɛ: «Makaɨna ɓʉnɨ? Odokutɔ gɔnɨ ka yɨnga ikanɨ kodukugʉ?» ");
INSERT INTO lik_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ɓokumu-kumu na Ɓafalisayɔ ɓa ndɨ nɨ ɓopíni mʉtʉʉ ɓɛ mʉmbanzʉ kibo kʉ Yeso o mino, akwanana kaʉɓɨkya kyɛ ɓɨndɨ kagwi. ");
INSERT INTO lik_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Masyɛ maɗɨya kambwa wa yɨnga ya Pasɨka, Yeso aga ndɨ ka Betania, kʉ ka Lazalɔ nɨnɔ apupisa ndɨ ka mbʉkʉ. ");
INSERT INTO lik_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Kʉ ɓɛyɔ, ɓambambambya ndɨ. Malata nɔ a ndɨ kaugugubyo. Lazalɔ a ndɨ ɓemoti ka nɨɓɔ ɓa ndɨ pa imoti na Yeso ka mɨza. ");
INSERT INTO lik_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Kʉwa wa, Malia ava ndɨ supa ya malazi matʉmbɛ-tʉmbɛ na ma lɨgabʉ lapʉ. Agboɗyo kʉwa ndɨ na imu Yeso ka magʉ, akpaga no tukatʉ kakɨ. Sʉ ya malazi ohuma ndɨ ndaɓʉ yasɨ. ");
INSERT INTO lik_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Luki limoti Yuda Isikalioti, ɓemoti ka ɓaɓɨɓya ka Yeso, nɨnɔ agaba ɓanʉ, aɓɨkya ndɨ ɓɛ: ");
INSERT INTO lik_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«Ko bulya ɨkɨ yɔ ɓakogobigʉ mino malazi mi nɨma ka ɓambuma ɓamɨya ɓasaa, ɓʉpá ɓatʉ ɓa yangya ɓuyi ɓi?» ");
INSERT INTO lik_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Kaɓɨkyagʉ ndɨ ɓɛyɔ kyɛ a ndɨ kaʉmɨnɨlya ɓatʉ ɓa yangya kumbu, luki limoti, kyɛ a ndɨ mʉtʉ wo kuɓakʉ. Ɨyɨ nɔ oɓuulyaga ndɨ mʉmbɨ ma apɛpɛ na iɓagatʉ ndɨ mino ɓuyi ɓi. ");
INSERT INTO lik_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Luki limoti, Yeso aɓɨkya ndɨ ɓɛ: «Mʉsa! Ogyi ɓɛyɔ ko bulya lɨsyɛ nɨlɔ ɓelumbo ndɛkɛ mino. ");
INSERT INTO lik_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","A ɓɛyɔ, mika ndɛkɛ pa imoti na ɓatʉ ɓa yangya masyɛ masɨ. Luki limoti, ɨmɨ, takikigʉ ndɛkɛ pa imoti na iɓunu aka.» ");
INSERT INTO lik_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ambaza mudingi ka Ɓayuda iba ndɨ ɓɛ Yeso a ndɨ ka Betania. Ɓɨnda kʉwa ndɨ kʉ, kɛgʉ asɨ ko bulya ka Yeso aka, luki limoti, kyɛ ɓamɨnɨ gɔnɨ Lazalɔ nɨnɔ ɨyi Yeso apupisa ndɨ ka mbʉkʉ. ");
INSERT INTO lik_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Kʉwa wa, ɓokumu-kumu ɓʉkanana ndɨ gɔnɨ ɓɛ ɓamwisisi Lazalɔ, ");
INSERT INTO lik_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","kyɛ Ɓayuda ɓakpʉ ɓa ndɨ kopupo ka mʉɗɔngɔ kaɓʉ ko bulya kakɨ, na kaɓɨnɨkyana Yeso. ");
INSERT INTO lik_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Na ɓʉgalo ɓi, ambaza wakpʉ nɨnɔ odoku ndɨ ka yɨnga wa Pasɨka ʉkana ndɨ ɓɛ Yeso a gɔnɨ kodoku ka Yelusalɛma. ");
INSERT INTO lik_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ɓava ndɨ mangʉ, ɓaga katɨlya nɨ ɓanapamɨkanaga ɓɛ: «Ɨbɨba ko Kunzi! Kunzi aɗukulyi mʉtʉ yi nɨnɔ akodoku ko lino ka Mombukwono-dosu ɓʉɓʉnga! Kunzi aɗukulyi ngama wa Izaleli ɓʉɓʉnga.» ");
INSERT INTO lik_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yeso inisana ndɨ no mikya punda, aɗaka kʉgʉ yi. Igyonosa ndɨ mʉɗɔngɔnɨ ɓɛyɔ ikpikaga ndɨ mino ɓɛ: ");
INSERT INTO lik_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«Makoɓongonitɔgʉ, iɓunu ɓatʉ ɓa gʉɗʉ wa Siona! Winoni, ngama kunu odunuku, a wakiko kʉgʉ wa mikya punda.» ");
INSERT INTO lik_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ɓaɓɨɓya kakɨ ɓakotombisyagʉ mbɛyɨ ndɨ lɨkpʉmʉka li nɨlɔ ɓɨkwa. Luki limoti, ngbingo yi nɨnɔ Yeso ogulya ndɨ mino ka ɨbɨba, ɓatamana sɛ kʉwa ɓɛ lɨkpʉmʉka li nɨlɔ ikpikaga ndɨ ko bulya kakɨ, ɓambanzʉ ɓagyɨlya ndɨ ɓɛyɔ aka yɔ. ");
INSERT INTO lik_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ɓambanzʉ ɓasɨ nɨɓɔ ɓa ndɨ pa imoti na Yeso ngbingo yi nɨnɔ apupisoku ndɨ mino Lazalɔ ka mbʉkʉ, na azuzukiso luga ka ɓamanda, ɓatʉmbʉlaga ndɨ nɨlɔ ɓɨna ndɨ no miso. ");
INSERT INTO lik_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Kinili, ambaza ka ɓambanzʉ odoku ndɨ katɨlya. A ndɨ nɨ ukonini ɓɛ Yeso nɔ agya ndɨ likingyosi nɨlɔ. ");
INSERT INTO lik_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ɓafalisayɔ ɓaɓɨkyana kʉwa luga kaɓʉ ɓɛ: «Minini! Makakwananɨgʉ ɓata kagya luki. Ɓambanzʉ ɓasɨ ɓa kʉwa kumbuso kakɨ aka!» ");
INSERT INTO lik_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Luga ka ɓatʉ nɨɓɔ ɓodoku ndɨ kabibiso Kunzi ngbinga wa yɨnga, Ɓagiliki ɓemoti-ɓemoti ɓatʉ ndɨ gɔnɨ wa. ");
INSERT INTO lik_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ɓakpuɗoku ndɨ Filipi, nɨnɔ a ndɨ mʉtʉ wa gʉɗʉ wa Bɛtɛsaida ka iwili ya Galilaya, ɓaɓɨkya ndɨ ɓɛ: «Alʉkʉ, to ɓi kapa kamɨna Yeso.» ");
INSERT INTO lik_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipi ɨnda ndɨ kaɓɨkya Andɨlɨa. Ɨɓʉ ɓasɨ ɓaɓa ɓɨnda kaɓɨkya Yeso. ");
INSERT INTO lik_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yeso usikisya ndɨ ɓɛ: «Ngbingo itulyonini nɨnɔ Mika-mʉmbanzʉ ava mino ɨbɨba. ");
INSERT INTO lik_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","A lɨngʉnʉ, a lɨngʉnʉ, nakamʉɓɨkya ambɛ, lɨsɔlɔ kogwi ka lɨtɔmbʉ, okwo, ika ndɛkɛ asɨ ilu aka. Luki limoti, kokwo, aɓʉkʉta kʉwa bumo yakpʉ. ");
INSERT INTO lik_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Mʉtʉ yi nɨnɔ apaga ɔɓɨlɨ kakɨ aɓungusatʉ. Luki limoti, nɨnɔ amʉyaga ɔɓɨlɨ kakɨ ka lɨtɔmbʉ li nɨlɨ, ika ndɛkɛ na ɔɓɨlɨ wa ɓɛnzɛ na ɓɛnzɛ. ");
INSERT INTO lik_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Mʉmbanzʉ kapa kegugubyo, ɛɓɨɓyɨ. Mʉgya-ligubo kamɨ ika ndɛkɛ kʉ gɔ kʉ ɨmɨ niko mino. Mʉmbanzʉ kika mʉgya-ligubo kamɨ, Baba abibisatʉ.» ");
INSERT INTO lik_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","«Mbɨya wanʉ, lɨmbɛngɨ egwini ɓʉpɔ. Naɓɨkya ɓʉ? Naɓɨkyɨ sɛ kʉwa ɓɛ: Babooo, ihukusaganɔ ɓaka ko ngbingo wa yigyogyiso yi nɨmʉ? Luki limoti, ngbingo yi nɨnɔ nadulyoku ndɨ nɨmʉna aka mʉ. ");
INSERT INTO lik_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ba, bibisanɔ lino kakʉ!» Kʉwa wa, lɨyʉ otukyoku ndɨ kʉgʉ wa lɨsyɛ ɓɛ: «Nobibisoni lino kamɨ, nɨgɨlyatʉ ndɛkɛ ɓata kobibiso.» ");
INSERT INTO lik_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ambaza ka ɓambanzʉ nɨnɔ a ndɨ wakamaga wa, ʉkana ndɨ lɨyʉ li nɨlɔ, aɓɨkya ɓɛ: «Ngbangbata sɛ nɔ opomikoni!» Ɓagɔgɔ ɓɛ: «Malaika nɔ anzinilyi!» ");
INSERT INTO lik_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Luki limoti, Yeso ʉɓɨkya ndɨ ɓɛ: «Lɨyʉ li nɨlɨ kopupigʉ ko bulya kamɨ, luki limoti, ko bulya kunu. ");
INSERT INTO lik_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ngbingo itulyonini, Kunzi akapʉnga kakɔ mʉngɨmbɔ ma ɔɓɨlɨ yi nɨmʉ. Mbɨya wanʉ, akakpumyo ngama wa ɔɓɨlɨ yi nɨmʉ. ");
INSERT INTO lik_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Wa ɓeɗokisa ndɛkɛ mino kʉgʉ, nuluta ndɛkɛ ɓambanzʉ ɓasɨ kʉ kamɨ.» ");
INSERT INTO lik_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yeso aɓɨkya ndɨ ɓɛyɔ kowonisilo ɓɛ inguo ya kukwakʉ tina kwɔ okwa ndɛkɛ. ");
INSERT INTO lik_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ambaza ka ɓambanzʉ asikisya ndɨ ɓɛ: «Iɓusu, tʉkana ndɨ ka mʉtʉʉ ɓɛ Masiya ika ndɛkɛ ɨyɨ na ɔɓɨlɨ aka kadwɛ ka ɓɛnzɛ na ɓɛnzɛ. Wa kʉwa kaɓɨkya lɨkɨ ɓɛ: ‹Okwononi ɓɛ ɓaɗokisi Mika-mʉmbanzʉ kʉgʉ.› Mika-mʉmbanzʉ yi nɨnɔ nɨ wanɨ?» ");
INSERT INTO lik_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yeso aka ndɨ na ɨɓʉ ɓɛ: «Ɓʉngbanganya atʉ mbɛyɨ ɓata luga kunu ko ngbinga mʉkɛɗɛ. Kpokyononi na lɨsyɛ, kyɛ biti kamuhumonito. Mʉtʉ nɨnɔ akpakyanaga no biti, kibogigʉ ɓɛ akaaga yanɨ. ");
INSERT INTO lik_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ɓinikyononi nɛkɨ ɓʉngbanganya ngbingo yi nɨnɔ ma mbɛyɨ mino na ɨɓʉ aka, kyɛ mɨɨtɨ ɓatʉ ɓa ɓʉngbanganya.» Kumbuso Yeso kaɓɨkya ɓɛyɔ, ɨmagalya ndɨ ɨyɨ, isumoku. ");
INSERT INTO lik_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Gʉtʉgʉ ɓɛyɔ Yeso agya ndɨ mino mokingyosi mʉmbanga-mbanga ko misa ka ɓʉ ɓɛyɔ, ɓakaɓɨnɨkyanagʉ ndɨ, ");
INSERT INTO lik_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","kʉwa wa gʉ wa, mʉnzɨna nɨmɔ mugyalandʉ Isaya aɓɨkya ndɨ ɨtʉlyana: «Mombukwono-dosu, wanɨ nɔ aɓɨnɨkyana ndɨ lɨkpʉmʉka nɨlɔ ta ndɨ kaɓɨkyaga? Mombukwono-dosu awonisila ndɨ wanɨ kʉɓɔkʉkɔ kwo ngu kakɨ?» ");
INSERT INTO lik_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Kinili, ɓakakwananɨgʉ ndɨ kaɓɨnɨkyana, kaɓyɛnɛnɛ na nɨlɔ Isaya aɓɨkya ndɨ ɓata ɓɛ: ");
INSERT INTO lik_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«Kunzi udulogoni ndɨ miso, ʉdʉlaga yimibo. Agya ndɨ ɓɛyɔ, kyɛ ɓakinogonitɔgʉ ɓata, yimibo kaɓʉ kotombisyogonitɔgʉ ɓata luki. Kinili, ɓakoyikosagʉ ndɨ ɔɓɨlɨ kaɓʉ, Iba nuhukusatʉ ndɨ!» ");
INSERT INTO lik_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaya aɓɨkya ndɨ ɓɛyɔ kyɛ ɨna ndɨ ɨbɨba ka Yeso kambwa, anzɨnagatʉ ndɨ ko bulya kakɨ. ");
INSERT INTO lik_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Gʉtʉgʉ ɓɛyɔ, ɓudingi luga ka ɓangama ka Ɓayuda ɓaɓɨnɨkyanatʉ ndɨ. Ɓakɛgʉ ndɨ kapa kaipupiso kyɛ Ɓafalisayɔ ɓakukpumyoni ka ndaɓʉ ya malʉmba kaɓʉ. ");
INSERT INTO lik_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","A ɓɛyɔ, Ɓafalisayɔ ɓapaga ndɨ ɨɓʉ ɨbɨba ka ɓambanzʉ kakɨtaga nɨyɔ odogoku ko Kunzi. ");
INSERT INTO lik_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Kʉwa wa, Yeso apamɨkana ɓɛ: «Nɨnɔ ɛɓɨnɨkyana, kɛɓɨnɨkyanagʉ ɨmɨ aka, luki limoti, aɓɨnɨkyana gɔnɨ nɨnɔ etikoku ndɨ. ");
INSERT INTO lik_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Nɨnɔ akɛmɨna, akamɨna gɔnɨ nɨnɔ etikoku ndɨ. ");
INSERT INTO lik_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ɨmɨ, nodoku ndɨ ka ɔɓɨlɨ abɛ ɓʉngbanganya, kyɛ mʉtʉ wasɨ nɨnɔ ɛɓɨnɨkyana kikonitɔgʉ ko biti. ");
INSERT INTO lik_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Mʉmbanzʉ kʉkana lɨkpʉmʉka kamɨ nɨ kogyigʉ, nakakʉlyɨgʉ mʉkɔmbʉ. A ɓɛyɔ, nakodokugʉ ndɨ kakɔ mʉngɨmbɔ ka ɔɓɨlɨ, luki limoti, nodoku ndɨ kahukuso. ");
INSERT INTO lik_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Mʉmbanzʉ kɛmʉya, akya kaɓɨnɨkyana lɨkpʉmʉka kamɨ, a na zozi kakɨ. Mʉtɨwɨ nɨmɔ napága ndɨ mɔ abisa ndɛkɛ ka mʉngɨmbɔ ka lɨsyɛ la muliɓo. ");
INSERT INTO lik_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","A ɓɛyɔ, nakanzɨnagɨgʉ ko ngu kamɨ ɓɨkpɛ. Baba nɨnɔ etikoku ndɨ nɔ ɛkpamya ndɨ ɨyɨ mombukwana-dakɨ yi ɓɛ nakwanana kaɓɨkya ikanɨ katɨwa ɓʉnɨ. ");
INSERT INTO lik_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nakaiba ɓɨnza ambɛ, mʉtʉʉ ka Baba apága ɔɓɨlɨ wa ɓɛnzɛ na ɓɛnzɛ. Kinili, nɨlɔ naɓɨkyaga, ikaga mʉɗɔngɔnɨ ɓɛyɔ aka yɔ Baba ɛkpamya ndɨ mino.» ");
INSERT INTO lik_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","A ndɨ nɨ otigolini lɨsyɛ limoti kadwɛ ka Pasɨka. Yeso a kʉwa ndɨ kaimibo ɓɛ ngbingo kakɨ itulyonini katʉkya ka ɔɓɨlɨ yi nɨmʉ na kaaga ka abakɨ. Ʉpaga ndɨ ɓava-kʉkakɨ nɨɓɔ ɓikaga ndɨ ka ɔɓɨlɨ, idukulogo kaʉpa kadwɛ ka muliɓo. ");
INSERT INTO lik_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yeso na ɓaɓɨɓya kakɨ ɓa ndɨ kalya malɨlɨ ma ɓʉgɔgɔ. Mumuyoniso a ndɨ nɨ amingyini Yuda mika Simoni-Isikalioti ɓɛ agabɨ Yeso. ");
INSERT INTO lik_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yeso a ndɨ kaiba ɓɛ Abakɨ apá ndɨ ngu ka makpʉmʉka masɨ, na gɔnɨ ɓɛ otukyoku ndɨ kʉ kakɨ ko Kunzi na a ndɨ kaɨga kʉ gɔ kʉ. ");
INSERT INTO lik_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ngbingo yi nɨnɔ ɓa mbɛyɨ ndɨ mino aka ka mɨza, amaga ndɨ, ɨnyɔ kutuko kwa mbanzɨ, ava kutuko kumoti ɓɛnɛ, ɨkpɨkɨla ka ɨɗʉkʉfɨsɔ. ");
INSERT INTO lik_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Kumbuso yi, oɗuka ndɨ liɓo ka sani, apʉnga kaʉsʉkʉsa ɓaɓɨɓya kakɨ magʉ na kaʉkpaga na kutuko nɨkwɔ ɨkpɨkɨla ndɨ ka ɨɗʉkʉfɨsɔ. ");
INSERT INTO lik_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Nɨyɔ adwɛ ka Simoni Pɛtɛlɛ, ɨyɨ Pɛtɛlɛ amuusa ndɨ ɓɛ: «Mombukwono-dosu, ɨwɛ kʉwa nɔ wakɛsʉkʉsa magʉ?» ");
INSERT INTO lik_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yeso asikisya ndɨ ɓɛ: «Nɨlɔ nakagya mbɨya wanʉ wakibigʉ, luki limoti, wibatʉ ɓanʉ.» ");
INSERT INTO lik_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pɛtɛlɛ aka ndɨ ɓɛ: «Ɨwɛ kɛsʉkʉsa ɨmɨ magʉ? Kɨgyananɨgʉ!» Luki limoti, Yeso aka na ɨyɨ ɓɛ: «Nakusukusi magʉ, takikigʉ ndɛkɛ ɓata pa imoti na ɨwɛ.» ");
INSERT INTO lik_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simoni Pɛtɛlɛ aɓɨkya kʉwa ndɨ ɓata ɓɛ: «Mombukwono-dosu, kiko nɛkɨ nɨ a ɓɛyɔ, wakɛsukusonitɔgʉ asɨ magʉ aka. Luki limoti, ɨsʉkʉsatʉ gɔnɨ maɓɔkʉ na mʉ!» ");
INSERT INTO lik_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yeso aɓɨkya ndɨ ɓɛ: «Mʉtʉ yi nɨnɔ isukusogi, kɛgʉ ɓata na nza ya kɨsʉkʉsaga, akwanana kʉwa kaɨsʉkʉsa asɨ magʉ aka. A ɓɛyɔ, iɓunu ma ɓɨngɔ, luki limoti kɛgʉ iɓunu ɓasɨ.» ");
INSERT INTO lik_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","A ɓɛyɔ, Yeso a ndɨ kamibo mʉtʉ nɨnɔ agaba ɓanʉ, kinili aɓɨkya ndɨ ɓɛ: «Iɓunu ɓasɨ makɛgʉ ɓɨngɔ.» ");
INSERT INTO lik_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Nɨyɔ ʉma kaʉsʉkʉsa magʉ, imokisyo ɓata ndɨ kutuko kakɨ kwa mbanzɨ, igoku ɓata kalyalya, umuusa ndɨ ɓɛ: «Mibito isi ya lɨkpʉmʉka li nɨlɔ namugyilyi? ");
INSERT INTO lik_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Iɓunu, mɛmakaga ɓɛ Muwonisilo, Mombukwono-dosu, maɓɨkyaga lɨngʉnʉ, kyɛ na ɓɛyɔ aka yɔ. ");
INSERT INTO lik_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Kika nɛkɨ nɨ ɨmɨ, Muwonisilo na Mombukwono-donu, namusukusini magʉ, iɓunu makwanana gɔnɨ kasʉkʉsana magʉ luga kunu. ");
INSERT INTO lik_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","A ɓɛyɔ, ɨmɨ namupí likingyosi, kyɛ gyoni iɓunu mʉɗɔngɔnɨ ɓɛgɛyɔ namugyilyi mino. ");
INSERT INTO lik_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","A lɨngʉnʉ, a lɨngʉnʉ, nakamʉɓɨkya ambɛ, musunzu kakwananɨgʉ kaiko ngama ka mombukwana-dakɨ, gʉtʉgʉ atʉtʉmbwa aka kakwananɨgʉ kakɨtaga mʉtʉ yi nɨnɔ atiki. ");
INSERT INTO lik_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Mbɨya wanʉ mibini lɨkpʉmʉka li nɨlɔ, makagya ɓɛyɔ namugyilyi mino, mika ndɛkɛ ɓatʉ ɓa magyagya.» ");
INSERT INTO lik_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Yeso omotiloku ndɨ ɓɛ: «Lɨkpʉmʉka li nɨlɨ, nakɛgʉ kamʉɓɨkya iɓunu ɓasɨ. Ɨmɨ, nakaumibo ɓatʉ nɨɓɔ nupunogoni ndɨ. Luki limoti, okwononi itulyosi nɨlɔ ikpikaga ndɨ ka Moɓiso Motu ɓɛ: ‹Mʉtʉ yi nɨnɔ talyalyaga ndɨ na ɨyɨ, eitilyini›. ");
INSERT INTO lik_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Namuɓikyi lɨkpʉmʉka li nɨlɨ mbɨya yi nɨmʉ kambwa ɓɛ igyonosi. Ngbingo yi nɨnɔ igyonosa ɓanʉ mino, maɓɨnɨkyana ɓanʉ ɓɛ ‹ɨmɨ, natʉ›. ");
INSERT INTO lik_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","A lɨngʉnʉ, a lɨngʉnʉ, nakamʉɓɨkya ambɛ, mʉmbanzʉ katɨlya mʉtʉ yi nɨnɔ natiki, etilyi ɨmɨ. Mʉmbanzʉ kɛtɨlya, atilyi gɔnɨ nɨnɔ etikoku ndɨ.» ");
INSERT INTO lik_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Nɨyɔ Yeso ama ndɨ mino kanzɨna ɓɛyɔ, lɨmbɛngɨ alya ndɨ kumbu, aɓɨkya ndɨ ɓɨngbanganya ɓɛ: «A lɨngʉnʉ, a lɨngʉnʉ, nakamʉɓɨkya ambɛ, ɓemoti kunu ɛgabatʉ.» ");
INSERT INTO lik_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ɓaɓɨɓya ɓapʉnga ndɨ kaandanana luga kaɓʉ, nɨ ɓakɛgʉ kotombisyo ɓɛ akanzɨna ko bulya ka wanɨ. ");
INSERT INTO lik_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Wa ɓa ndɨ mino kalyalya, ɓemoti ka ɓaɓɨɓya kakɨ nɨnɔ ɨyɨ Yeso apaga ndɨ, a ndɨ ka kpɔlɔ kakɨ. ");
INSERT INTO lik_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simoni Pɛtɛlɛ anʉta ndɨ mʉɓɨɓya yi nɨnɔ ɓɛ kyɛ amuusi Yeso ikanɨ a ndɨ kaɓɨkya lɨkpʉmʉka li nɨlɔ ko bulya ka wanɨ. ");
INSERT INTO lik_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Mʉɓɨɓya yi nɨnɔ ɨgʉmya ndɨ ka Yeso, amuusa ɓɛ: «Mombukwono-dosu, wanɨ?» ");
INSERT INTO lik_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yeso asikisya ndɨ: «Nakolubo dongbu ya mukati mi nɨma ko supu, mʉtʉ yi nɨnɔ napá, iba ɨyɨ nɨnɔ.» Yeso olubo kʉwa ndɨ, apá Yuda Isikalioti mika Simoni. ");
INSERT INTO lik_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Nɨyɔ aka yɔ Yuda ava, Abɨlɨ ingya ndɨ kʉsɔ kakɨ. Yeso aka ndɨ na ɨyɨ ɓɛ: «Nɨyɔ wakapa kagya, gya ɓɨgala-gala.» ");
INSERT INTO lik_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Gʉtʉgʉ mʉtʉ ɓemoti aka luga ka nɨɓɔ ɓa ndɨ kalyalya wa, kotombisyagʉ ndɨ isi ya mʉnzɨna mi nɨmɔ. ");
INSERT INTO lik_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","A ɓɛyɔ, yɛkɨ Yuda nɔ oɓuulyaga ndɨ ɓuyi, ɓatʉ ɓagɔgɔ luga ka ɓaɓɨɓya ɓa ndɨ kasɨma ɓɛ Yeso akaɓɨkya ɓɛ oluwi malɨlɨ nɨmɔ ɓakwanana ndɨ kalya ka yɨnga, ikanɨ ɨndɨ kaʉpá ɓatʉ ɓa yangya luki lɨkɛɗɛ. ");
INSERT INTO lik_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yuda ava kʉwa ndɨ dongbu ya mukati mi nɨmɔ, ko ngbingo yi nɨnɔ aka nɔ, opupa ndɨ. A kʉwa ndɨ nɨ biti olipyini. ");
INSERT INTO lik_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Nɨyɔ Yuda opupo, Yeso aɓɨkya ndɨ ɓɛ: «Mbɨya-mbɨya yi nɨmʉ, Mika-Mʉmbanzʉ ovini ɨbɨba, Kunzi ovini gɔnɨ ɨbɨba pisi kʉ kakɨ. ");
INSERT INTO lik_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Kika nɨ Kunzi ovini ɨbɨba pisi kʉ kakɨ, ɨyɨ Kunzi mombukwana-dakɨ yi owonisilatʉ gɔnɨ ɨyɨ ɨbɨba ko Miki pisi kʉ kakɨ ɓɨkwa. ");
INSERT INTO lik_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ɓomikamɨ, nakɛgʉ ɓata na iɓunu ko ngbingo mʉnda. Mɛkɨsatʉ, luki limoti, mʉɗɔngɔnɨ ɓɛyɔ nʉɓɨkya ndɨ mino Ɓayuda, namuɓikyi kʉwa gɔnɨ iɓunu mbɨya yi nɨmʉ ɓɛ: makakwananɨgʉ kaɨnda kʉ ɨmɨ no mino kaaga. ");
INSERT INTO lik_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nakamʉpá mʉtʉʉ mambɨya: ponononi luga kunu. Mʉɗɔngɔnɨ ɓɛyɔ ɨmɨ namʉpa ndɨ mino, ponononi iɓunu ɓɛgɛyɔ. ");
INSERT INTO lik_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Kika nɨ ma na sɨpananɨsɔ luga kunu, ɓatʉ ɓasɨ ɓiba ndɛkɛ ɓɛ ma ɓaɓɨɓya kamɨ.» ");
INSERT INTO lik_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simoni Pɛtɛlɛ amuusa ndɨ Yeso ɓɛ: «Mombukwono-dosu, wa sɛ kʉwa kaɨnda yanɨ?» Yeso asikisya ndɨ ɓɛ: «Kʉ no mino kaɨnda, wakakwananɨgʉ kɛɓyɛ mbɨya wanʉ, luki limoti, wɛɓyɛtʉ ndɛkɛ kumbuso.» ");
INSERT INTO lik_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pɛtɛlɛ amuuso ɓata ndɨ ɓɛ: «Mombukwono-dosu, ko bulya ɨkɨ nakakwananɨgʉ kaʉɓyɛ mbɨya wanʉ? Na wakɨtʉlya kapá ɔɓɨlɨ kamɨ ko bulya kakʉ.» ");
INSERT INTO lik_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yeso asikisya ndɨ ɓɛ: «Watʉ aka wakɨtʉlya kapá ɔɓɨlɨ kakʉ ko bulya kamɨ? A lɨngʉnʉ, a lɨngʉnʉ, nakaʉɓɨkya ambɛ, kambwa kɔkʉ kaalɨka, wika nɨ wemongonyini nganga yɨsaa.» ");
INSERT INTO lik_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yeso ʉɓɨkya ndɨ ɓaɓɨɓya kakɨ ɓɛ: «Makombomboyonitɔgʉ. Muɓinikyononi Kunzi, mɛɓɨnɨkyana gɔnɨ ɨmɨ. ");
INSERT INTO lik_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ka ndaɓʉ ka Baba ɓapa a ɓayakpʉ. Kiki ɓi ɓɛyɔ, nakakwananigʉ ɓi kamʉɓɨkya ambɛ nogoni kamuɓungusilyogo yi. ");
INSERT INTO lik_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nakaaga kamuɓungusilyogo pa, nigokuto ɓata kamʉva, iba kʉ ɨmɨ niko mino, wikoni iɓunu kʉ gɔ kʉ. ");
INSERT INTO lik_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Mibatʉ kʉ no mino kaɨnda, mibatʉ gɔnɨ pisi yi.» ");
INSERT INTO lik_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tʉma aɓɨkya kʉwa ndɨ ɓɛ: «Mombukwono-dosu, takibigʉ kʉ wo mino kaɨnda. Tiba kʉwa pisi lɨkɨ?» ");
INSERT INTO lik_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yeso aɓɨkya ndɨ ɓɛ: «Ɨmɨ nɨ pisi, lɨngʉnʉ na ɔɓɨlɨ. Mʉmbanzʉ gʉtʉgʉ ɓemoti aka kakwananɨgʉ kaɨnda ka Baba nɨ koɓyigʉ pisi kʉ kamɨ. ");
INSERT INTO lik_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Makemibo ɓi ɓɨnza, mamibatʉ gɔnɨ ɓi Baba. Katʉkya mbɨya wanʉ, mamibatʉ na maminoni.» ");
INSERT INTO lik_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipi aɓɨkya ndɨ Yeso ɓɛ: «Mombukwono-dosu, tɨwanya kʉwa asɨ Baba aka, ama kʉwa gʉtʉgʉ ɓʉɓwa.» ");
INSERT INTO lik_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yeso asikisya ndɨ ɓɛ: «Eze, Filipi, mututu kɛgʉ ɓuwobi wa tiko mino na iɓunu, wakemibagʉ? Mʉtʉ yi nɨnɔ ɛmɨna, aminoni gɔnɨ Baba. Ko bulya ɨkɨ yɔ wo mino kaɓɨkya ɓɛ: ‹Tɨwanya Baba?› ");
INSERT INTO lik_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Wakɛgʉ kaɓɨnɨkyana ambɛ, ɨmɨ, na kʉsɔ ka Baba na Baba kʉsɔ kamɨ? Mʉnzɨna masɨ nɨmɔ namʉɓɨkyaga, kopupogigʉ na ɨmɨ, luki limoti, Baba nɨnɔ a kʉsɔ kamɨ nɔ agyaga mogubo kakɨ. ");
INSERT INTO lik_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Iɓinikyononi ngbingo yi nɨnɔ no mino kamʉɓɨkya ɓɛ: Ɨmɨ na kʉsɔ ka Baba na Baba a kʉsɔ kamɨ. Makoɓinikyoni ɓɛyɔ, iɓinikyononi gʉtʉgʉ asɨ ko bulya mogubo kakɨ aka. ");
INSERT INTO lik_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","A lɨngʉnʉ, a lɨngʉnʉ, nakamʉɓɨkya ambɛ, mʉtʉ yi nɨnɔ eɓinikyononi, agya ndɛkɛ mogubo nɨmɔ nagyaga. Agyaga ndɛkɛ gɔnɨ makpʉmʉka makpʉkpʉ kʉgbɛ, kyɛ ɨmɨ nakaaga ka Baba. ");
INSERT INTO lik_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Makpʉmʉka masɨ nɨmɔ makʉnga ndɛkɛ ko lino kamɨ, namʉgyɨlyatʉ ndɛkɛ iba Baba avɨ ɨbɨba pisi ko Miki. ");
INSERT INTO lik_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Makakʉnga luki ko lino kamɨ, namʉgyɨlyatʉ.» ");
INSERT INTO lik_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Yeso omotiloku ndɨ ɓɛ: «Makɛpa, magya mʉtʉʉ kamɨ. ");
INSERT INTO lik_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ɨmɨ, nakʉnga ɓanʉ Baba, amʉpɨ́ mʉtʉ wagɔgɔ nɨnɔ ika na iɓunu ka ɓɛnzɛ na ɓɛnzɛ kamʉtʉngbʉlaga: ");
INSERT INTO lik_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","mʉtʉ yi nɨ Lɨmbɛngɨ nɨlɔ la lɨngʉnʉ. Ɓatʉ ɓa ɔɓɨlɨ ɓakakwananɨgʉ kabaɨlya, kyɛ ɓakamɨnagɨgʉ na ɓakamibogigʉ. Luki limoti, iɓunu mamibatʉ kyɛ ikaga ɓuwobi na iɓunu, na a ka mambɛngɨ kunu. ");
INSERT INTO lik_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Nakamʉsɨgʉ ndɛkɛ ɓokwino, nigokuto ndɛkɛ ɓata ɓuwobi na iɓunu. ");
INSERT INTO lik_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Otigoli yɨkɛɗɛ, ɓatʉ ɓa ɔɓɨlɨ ɓakɛmɨnɨgʉ ndɛkɛ ɓata, luki limoti, iɓunu, mɛmɨnatʉ. Ɨmɨ na na ɔɓɨlɨ, iɓunu mika ndɛkɛ na ɔɓɨlɨ gɔnɨ. ");
INSERT INTO lik_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ka lɨsyɛ li nɨlɔ, mibatʉ ndɛkɛ ɓɛ ɨmɨ na kʉsɔ ka Baba, iɓunu kʉsɔ kamɨ na ɨmɨ kʉsɔ kunu. ");
INSERT INTO lik_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Mʉtʉ yi nɨnɔ ibaga mʉtʉʉ kamɨ, agya, ɨyɨ nɔ ɛpaga. Baba apa ndɛkɛ mʉtʉ yi nɨnɔ ɛpaga, ɨmɨ napa ndɛkɛ gɔnɨ, nimibisisa kʉ kakɨ.» ");
INSERT INTO lik_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yuda yi nɨmʉ kɛgʉ ndɨ Yuda Isikalioti, amuusa Yeso ɓɛ: «Mombukwono-dosu, ko bulya ɨkɨ yɔ wiwoniso mino ku kusu aka nɨ kɛgʉ ka ɓatʉ ɓa ɔɓɨlɨ?» ");
INSERT INTO lik_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yeso asikisya ndɨ ɓɛ: «Mʉmbanzʉ kɛpa, agyatʉ nɨlɔ niko kaɓɨkya. Baba apatʉ, iɓusu na Baba todoku ndɛkɛ kʉ kakɨ, tiko kʉsɔ kakɨ. ");
INSERT INTO lik_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Mʉtʉ yi nɨnɔ kɛpagɨgʉ, kagyagigʉ nɨlɔ niko kaɓɨkya. Mʉtʉʉ mi nɨmɔ makaʉkana kɛgʉ ma kamɨ, luki limoti a nɨmɔ ka Baba nɨnɔ etikoku ndɨ. ");
INSERT INTO lik_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Namuɓikyi ɓɛyɔ kyɛ na mbɛyɨ ɓata luga kunu aka. ");
INSERT INTO lik_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Luki limoti, mʉtʉ wagɔgɔ nɨnɔ noɓikyi ɓi ambɛ odoku ndɛkɛ kamʉtʉngbʉlaga nɨ Lɨmbɛngɨ-Lotu nɨnɔ Baba atikoku ko lino kamɨ. Ɨyɨ amuwonisila ndɛkɛ makpʉmʉka masɨ, amutomosya masɨ nɨmɔ namʉɓɨkyaga ndɨ. ");
INSERT INTO lik_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Namusilyi mazɨyɔ, namʉpá mazɨyɔ kamɨ. Ɨmɨ, nakamupígʉ mʉɗɔngɔnɨ ɓɛyɔ ɓatʉ ɓa ɔɓɨlɨ ɓapága mino. Makombomboyonitɔgʉ ikanɨ kaɓanga. ");
INSERT INTO lik_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Mukonito ɓi ɓɛyɔ namuɓikyi ɓi mino ɓɛ: ‹Nogoni, luki limoti, nigokuto ndɛkɛ ɓuwobi na iɓunu.› Kiko ɓi nɨ mɛpagatʉ, gwoni magyagya kyɛ nakaaga ka Baba. A ɓɛyɔ, Baba a mʉtʉ wa ɨbɨba kʉgbɛ kɛkɨtaga ɨmɨ. ");
INSERT INTO lik_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Namuɓikyi lɨkpʉmʉka li nɨlɨ mbɨya wanʉ kanɨ kanigyonosigʉ, kyɛ ngbingo yi nɨnɔ igyonosa ɓanʉ mino, ɓinikyononito. ");
INSERT INTO lik_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Nakɛgʉ ɓata na iɓunu na mʉnzɨna manda kyɛ ngama wa ɔɓɨlɨ yi nɨmʉ a kʉwa kodoku. Ɨyɨ kakwananɨgʉ kagya luki gʉtʉgʉ limoti aka, ");
INSERT INTO lik_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","luki limoti, okwononi ɓatʉ ɓa ɔɓɨlɨ ɓibi ɓɛ napagatʉ Baba, na ɨmɨ nagyaga mʉɗɔngɔnɨ ɓɛyɔ ɛkpamya ndɨ mino. Womogoni, totukyini wanʉ.» ");
INSERT INTO lik_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","«Ɨmɨ nɨ muzabibu ma lɨngʉnʉ, Baba nɔ a mombukwono tiko. ");
INSERT INTO lik_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Akɔgɔ tabɨ kamɨ yasɨ nɨyɔ kaɓʉkʉtagɨgʉ. Oɓungusyogo nɨyɔ aɓʉkʉtaga, kyɛ aɓʉkʉtɨ yakpʉ kakɨtaga. ");
INSERT INTO lik_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Iɓunu, ma kʉwa ɓɨngɔ pisi ka mʉtɨwɨ nɨmɔ namʉpága ndɨ. ");
INSERT INTO lik_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Wikoni kʉsɔ kamɨ, mʉɗɔngɔnɨ ɓɛyɔ ɨmɨ no mino kʉsɔ kunu. Mʉtabɨ mumoti kakwananɨgʉ kaɓʉkʉta bumo yɨkaka nɨ kɛgʉ ka muzabibu. Mʉɗɔngɔnɨ ɓɛgɛyɔ, iɓunu makakwananɨgʉ kaɓʉkʉta bumo makiki kʉsɔ kamɨ. ");
INSERT INTO lik_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ɨmɨ nɨ muzabibu, iɓunu ma tabɨ. Nɨnɔ ikaga kʉsɔ kamɨ, ɨmɨ kʉsɔ kakɨ, aɓʉkʉta bumo yakpʉ. A ɓɛyɔ, kiki na ɨmɨ, makakwananɨgʉ kagya luki gʉtʉgʉ limoti aka. ");
INSERT INTO lik_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Mʉmbanzʉ kiki kʉsɔ kamɨ, ɓambimba kunzi mʉɗɔngɔnɨ abɛ mʉtabɨ, ʉmɨla. Ɓavaga tabɨ yi nɨyɔ ʉmɨlaga, ɓabʉsya ko ɓuku, agbʉndɨkana. ");
INSERT INTO lik_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Makiko kʉsɔ kamɨ na lɨkpʉmʉka kamɨ iko kʉsɔ kunu, kungoni masɨ nɨmɔ makapa, minisanatʉ na imu. ");
INSERT INTO lik_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Makaɓʉkʉta bumo yakpʉ, lino ka Baba avatʉ ɨbɨba, kʉwa wa, mɨɨta ndɛkɛ ɓaɓɨɓya kamɨ ɓa lɨngʉnʉ. ");
INSERT INTO lik_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Mʉɗɔngɔnɨ ɓɛyɔ Baba ɛpa mino, namupa ɨmɨ ɓɛgɛyɔ. Wikoni ka sɨpananɨsɔ kamɨ. ");
INSERT INTO lik_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Makagya mʉtʉʉ kamɨ, mika ndɛkɛ ka sɨpananɨsɔ kamɨ. Mʉɗɔngɔnɨ ɓɛyɔ ɨmɨ, nagyaga ndɨ mino mʉtʉʉ ka Baba, nikaga ka sɨpananɨsɔ kakɨ. ");
INSERT INTO lik_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Namʉɓɨkyaga ndɨ lɨkpʉmʉka li nɨlɔ kyɛ gwoni magyagya abɛ ɨmɨ. Ɨgyagya kunu ika kʉwa yidingi kakɨtaga. ");
INSERT INTO lik_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Nakamʉpá mʉtʉʉ ambɛ ponononi luga kunu mʉɗɔngɔnɨ ɓɛyɔ namʉpa ndɨ mino ɨmɨ. ");
INSERT INTO lik_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Kɛgʉ na mʉmbanzʉ nɨnɔ a na sɨpananɨsɔ sidingi kakɨtaga mʉtʉ yi nɨnɔ apága ɔɓɨlɨ kakɨ ka ɓawai-dakɨ. ");
INSERT INTO lik_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Iɓunu, mika ɓawai kika nɨ makagya nɨlɔ ɨmɨ, nakamʉkpamya kagya. ");
INSERT INTO lik_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Nakamʉmakɨgʉ ɓata ɓɛ ɓosunzu, kyɛ musunzu kibogigʉ nɨlɔ mombukwana-dakɨ agyaga. Nakamʉmaka ambɛ ɓawai, kyɛ namumibisoni masɨ nɨmɔ nʉkana ndɨ na Baba. ");
INSERT INTO lik_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Kɛgʉ iɓunu ɓɔ mɛpʉnaga ndɨ, luki limoti, ɨmɨ nɔ namʉpʉnaga. Namʉtɨka ambɛ windoni, ɓukutogoni bumo na bumo nɨyɔ kikigʉ ndɛkɛ na muliɓo. Kʉwa wa, Baba amʉpá masɨ nɨmɔ makʉngaga ndɛkɛ ko lino kamɨ. ");
INSERT INTO lik_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ka muliɓo, mʉtʉʉ kamɨ nɨma: ponononi luga kunu.» ");
INSERT INTO lik_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","«Kika nɨ ɔɓɨlɨ akamʉmʉya, wiboni ambɛ apʉnga ndɨ kɛmʉya ɨmɨ kambwa kunu. ");
INSERT INTO lik_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Makika ndɨ ɓatʉ ɓa ɔɓɨlɨ, ɔɓɨlɨ amʉpatʉ ɓi kyɛ miko ɓi ɓatʉ kakɨ. Luki limoti, ɨmɨ, namupunogoni ndɨ katʉkya luga ka ɓatʉ ɓa ɔɓɨlɨ. Iɓunu, makɛgʉ ɓata ɓatʉ ɓa ɔɓɨlɨ, kinili ɔɓɨlɨ akamʉmʉya. ");
INSERT INTO lik_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Tomononi lɨkpʉmʉka nɨlɔ namʉɓɨkya ndɨ ɓɛ: ‹Musunzu kɛgʉ na ɨbɨba kakɨtaga mombukwana-dakɨ.› Kika nɨ ɓambanzʉ ɓegyogyisa ndɨ, ɓamugyogyiso ndɛkɛ iɓunu ɓɛgɛyɔ. Na kika nɨ ɓagyatʉ ndɨ mʉtɨwɨ kamɨ, ɓagya ndɛkɛ nɨmɔ kunu ɓɛgɛyɔ. ");
INSERT INTO lik_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Luki limoti, ɓamʉgya ndɛkɛ nɨmɔ masɨ ko bulya kamɨ, kyɛ ɓakamibigʉ nɨnɔ etikoku ndɨ. ");
INSERT INTO lik_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Nakoduku ndɨ na nakunzinilyi ndɨ, iba ɓakɛgʉ na ɓʉnyɛ. Mbɨya wanʉ, ɓakɛgʉ ɓata no pisi ya kanganya ɓʉnyɛ kaɓʉ. ");
INSERT INTO lik_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Nɨnɔ akɛmʉya, akamʉya gɔnɨ Baba. ");
INSERT INTO lik_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nakogyi ndɨ luga kaɓʉ makpʉmʉka mʉmbanga-mbanga nɨmɔ mʉmbanzʉ gʉtʉgʉ ɓemoti aka kagyagʉ ndɨ, iba ɓakɛgʉ na ɓʉnyɛ. Mbɨya wanʉ, ɓɨnatʉ ndɨ, luki limoti, ɓa asɨ katɨmʉya aka iɓusu na Baba. ");
INSERT INTO lik_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Luki limoti, igyonosa ndɨ ɓɛyɔ kyɛ ɨtʉlyanɨ lɨkpʉmʉka nɨlɔ ɓokpika ndɨ ka mʉtʉʉ kaɓʉ ɓɛ: ‹Ɓɛmʉya ndɨ payaya aka.› ");
INSERT INTO lik_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Namutikilyokuto ndɛkɛ kotukyoku ka Baba, mʉtʉ nɨnɔ ikaga ndɛkɛ kamʉtʉngbʉlaga. Mʉtʉ yi nɨ Lɨmbɛngɨ la lɨngʉnʉ nɨlɔ akodoku ka Baba. Ɨyɨ nɔ ika ndɛkɛ dɛmʉ kamɨ. ");
INSERT INTO lik_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Na iɓunu mika ndɛkɛ ɓadɛmʉ kamɨ gɔnɨ, kyɛ ma ndɨ pa imoti na ɨmɨ katʉkya ka mʉpʉnganagɨ.» ");
INSERT INTO lik_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","«Namʉɓɨkya ndɨ makpʉmʉka nɨmɔ kyɛ makotukyonitɔgʉ ka baya kunu. ");
INSERT INTO lik_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ɓamukpumyagatʉ ndɛkɛ ka ɓandaɓʉ ɓaya malʉmba. Na ngbingo atʉ ndɛkɛ kodoku nɨnɔ ɓamʉmwɔgɔ ndɛkɛ mino, ɓanasɨma ɓɛ ɓakapá Kunzi apɛpɛ. ");
INSERT INTO lik_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ɓagyaga ndɛkɛ ɓɛyɔ kyɛ ɓakamibigʉ Baba, gʉtʉgʉ ɨmɨ aka. ");
INSERT INTO lik_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Luki limoti, namuɓikyi ɓɛyɔ kyɛ wa ngbingo yi nɨnɔ ɨtʉlyana ndɛkɛ mino, matamana ɓɛ, ɨmɨ, namʉɓɨkyatʉ ndɨ.» «Nakamʉɓɨkyagʉ ndɨ katʉkya ka mʉpʉnganagɨ, kyɛ ta ndɨ pa imoti na iɓunu. ");
INSERT INTO lik_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Mbɨya wanʉ, nanɨga kʉ ka mʉtʉ yi nɨnɔ etikoku ndɨ. Na mʉmbanzʉ gʉtʉgʉ ɓemoti aka kɛgʉ kemuuso ɓɛ: ‹Wakaɨnda yanɨ?› ");
INSERT INTO lik_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Luki limoti, yɛkɨ namuɓikyi ɓɛyɔ, kumbu amutumini kʉwa ka mambɛngɨ ɓɨɗɛ. ");
INSERT INTO lik_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Wɨna sɛ, ɨmɨ, nakamʉɓɨkya lɨngʉnʉ. A ɨzangɨa kunu ɓɛ ɨmɨ naga. A ɓɛyɔ, nakogo, nɨnɔ akwanana ndɛkɛ kamʉtʉngbʉlaga kamudulyikugʉ ndɛkɛ ɓata. Luki limoti, nakaga, namutikilyokuto ndɛkɛ. ");
INSERT INTO lik_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ngbingo yi nɨnɔ odoku ndɛkɛ mino, uwonisila ndɛkɛ ɓɨngbanganya ɓatʉ ɓa ɔɓɨlɨ yi nɨmʉ ko bulya ɓʉnyɛ, bulyo ɓungbingbili na bulyo mʉngɨmbɔ ko Kunzi. ");
INSERT INTO lik_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ko bulyo ɓʉnyɛ, kyɛ ɓakapagʉ kaɓɨnɨkyana. ");
INSERT INTO lik_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ko bulyo ɓungbingbili, kyɛ nakaaga ka Baba na makɛmɨnɨgʉ ndɛkɛ ɓata. ");
INSERT INTO lik_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ko bulyo mʉngɨmbɔ ko Kunzi, kyɛ ɓokoni ndɨ mʉngɨmbɔ ka ngama wa ɔɓɨlɨ yi nɨmʉ. ");
INSERT INTO lik_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Na ɓata na makpʉmʉka mudingi kamʉɓɨkya. Luki limoti, makakwananɨgʉ kabɨnɨka ɓuti ɓi mbɨya wanʉ. ");
INSERT INTO lik_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ngbingo yi nɨnɔ Lɨmbɛngɨ la lɨngʉnʉ odoku ndɛkɛ mino, amukpokyonisaga ndɛkɛ ka lɨngʉnʉ aka. A ɓɛyɔ, kanzɨnagɨgʉ ndɛkɛ ko lino kakɨ ɓɨkpɛ. Luki limoti, aɓɨkyaga ndɛkɛ masɨ nɨmɔ ʉkanaga na amʉɓɨkyaga makpʉmʉka nɨmɔ igyonosa ndɛkɛ. ");
INSERT INTO lik_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Owonisaga ndɛkɛ ɨbɨba kamɨ kyɛ makpʉmʉka masɨ nɨmɔ amʉɓɨkyaga ndɛkɛ, opupaga ndɛkɛ ka nɨmɔ a kʉsɔ kamɨ. ");
INSERT INTO lik_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Makpʉmʉka masɨ nɨmɔ ka Baba a makamɨ gɔnɨ. Kinili namuɓikyi ambɛ makpʉmʉka masɨ nɨmɔ Lɨmbɛngɨ amʉɓɨkyaga ndɛkɛ, opupaga ndɛkɛ ka nɨmɔ a kʉsɔ kamɨ.» ");
INSERT INTO lik_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","«Osikoni yɨkɛɗɛ, makɛmɨnɨgʉ ɓata, kumbuso wo ngbinga mʉkɛɗɛ mɛmɨnatʉ ɓata.» ");
INSERT INTO lik_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ɓaɓɨɓya kakɨ ɓagɔgɔ ɓapʉnga kʉwa ndɨ kaimuuso luga kaɓʉ ɓɛ: «Lɨkpʉmʉka tino lɔ akatɨɓɨkya lɔ? Akatɨɓɨkya ɓɛ: ‹Osikoni yɨkɛɗɛ, makɛmɨnɨgʉ ɓata, na kumbuso wo ngbinga mʉkɛɗɛ mɛmɨnatʉ ɓata›. Na ɓɛ: ‹Nakaɨnda ka Baba.›» ");
INSERT INTO lik_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ɓisisilaga ndɨ kaimuuso ɓɛ: «Nɨyɔ akaɓɨkya ɓɛ: ‹Ngbinga mʉkɛɗɛ› isi yi nɨ ɨkɨ? Takɛgʉ kaiba ikanɨ akanzɨna ko bulyo luki tino.» ");
INSERT INTO lik_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yeso iba ndɨ ɓɛ ɓa ndɨ kapa kamuuso lɨkpʉmʉka. Ʉɓɨkya kʉwa ndɨ ɓɛ: «Makaimuuso ko bulya lɨkpʉmʉka nɨlɔ namuɓikyi ɓi ɓɛ: ‹Osikoni yɨkɛɗɛ, makɛmɨnɨgʉ ɓata, na kumbuso wo ngbinga mʉkɛɗɛ mɛmɨnatʉ ɓata?› ");
INSERT INTO lik_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","A lɨngʉnʉ, a lɨngʉnʉ, nakamʉɓɨkya ambɛ, iɓunu, magamanatʉ ndɛkɛ, mogulya ko kumbu. Luki limoti, ɓatʉ ɓa ɔɓɨlɨ ɓogwa ndɛkɛ ɨɓʉ magyagya. Iɓunu, mika ndɛkɛ ko kumbu luki limoti, kumbu kunu oyikana ndɛkɛ magyagya. ");
INSERT INTO lik_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ngbingo nɨnɔ muko o mino kaɓʉkʉta, ikaga ko kumbu kyɛ a ngbingo kakɨ wa yigyogyiso. Luki limoti, kaɓʉkʉta, katamanɨgʉ ɓata yigyogyiso yi nɨyɔ. Ikaga kʉwa na magyagya kyɛ oɓukutini. ");
INSERT INTO lik_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Iɓunu gɔnɨ, ma ko kumbu mbɨya wanʉ. Luki limoti, namʉmɨnatʉ ndɛkɛ ɓata nɨ mambɛngɨ amutumini na magyagya ɓɨɗɛ. Mʉmbanzʉ gʉtʉgʉ ɓemoti aka kamʉkʉpyɨgʉ ndɛkɛ magyagya mi nɨmɔ. ");
INSERT INTO lik_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ka lɨsyɛ li nɨlɔ, makemuusigʉ ndɛkɛ ɓata lɨkpʉmʉka gʉtʉgʉ limoti aka. A lɨngʉnʉ, a lɨngʉnʉ, nakamʉɓɨkya ambɛ, Baba amʉpátʉ masɨ nɨmɔ makʉngaga ndɛkɛ ko lino kamɨ. ");
INSERT INTO lik_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Kadwɛ na lɨsyɛ nɨlɨ, makonokungigʉ luki ko lino kamɨ. Kungoni, minisanatʉ nolu iba ɨgyagya kunu iki kʉwa yidingi.» ");
INSERT INTO lik_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Yeso oɓikyoku ɓata ɓɛ: «Namʉɓɨkyaga ndɨ makpʉmʉka mi nɨmɔ masɨ pisi ka mozuni. Ngbingo odokuto ndɛkɛ nɨnɔ nakamʉnzɨnɨlyɨgʉ ɓata mino ɓɛyɔ, luki limoti, namʉnzɨnɨlya ndɛkɛ ɓɨngbanganya ko bulya ka Baba. ");
INSERT INTO lik_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ka lɨsyɛ li nɨlɔ, makʉngaga ndɛkɛ Baba makpʉmʉka masɨ ko lino kamɨ. Nakɛgʉ kamʉɓɨkya ambɛ ɨmɨ nɔ namʉkʉngʉlyaga ndɛkɛ. ");
INSERT INTO lik_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","A ɓɛyɔ, ɨyɨ Baba ɓɨkpɛ amʉpagatʉ, kyɛ iɓunu, mɛpagatʉ, maɓɨnɨkyana ɓɛ notukyoku ndɨ ko Kunzi. ");
INSERT INTO lik_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Notukyoku ndɨ ka Baba, nodoku ka ɔɓɨlɨ. Mbɨya wanʉ, nakasa ɔɓɨlɨ, nɨga ka Baba.» ");
INSERT INTO lik_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ɓaɓɨɓya kakɨ ɓaɓɨkya kʉwa ndɨ ɓɛ: «Iyaaa, mbɨya wanʉ, wa kʉwa kanzɨna ɓɨngbanganya. Wakɛgʉ ɓata katwa mozuni. ");
INSERT INTO lik_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Mbɨya wanʉ, takaiba ambɛ wibaga makpʉmʉka masɨ, kɛgʉ ɓata na ɨzangɨya ɓɛ mʉmbanzʉ umuusito ɓata lɨkpʉmʉka. Kinili, takaɓɨnɨkyana ɓɛ wotukyoku ndɨ ko Kunzi.» ");
INSERT INTO lik_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yeso umuusa ndɨ ɓɛ: «Moɓinikyonini sɛ kʉwa mbɨya wanʉ? ");
INSERT INTO lik_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ɛɛɛ, ngbingo a sɛ kodoku, itulyonini, nɨnɔ momisikana ndɛkɛ mino ɓingbwi, mʉmbanzʉ yɨkaka-yɨkaka ɨmagalya ka nakpangbala kakɨ. Ngbingo nɨnɔ mɛsa ndɛkɛ mino mʉkaka ɓɨnvʉɓʉ. Luki limoti, nakɛgʉ mʉkaka kyɛ Baba a pa imoti na ɨmɨ. ");
INSERT INTO lik_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Namʉɓɨkya ndɨ masɨ nɨmɔ kyɛ winisononi na mazɨyɔ kʉsɔ kamɨ. Migyogyisatʉ ndɛkɛ ka ɔɓɨlɨ. Luki limoti, makoɓongonitɔgʉ. Ɨmɨ, noɗitoni ndɨ masɨ ka ɔɓɨlɨ ɓɨnvɨ.» ");
INSERT INTO lik_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Nɨyɔ Yeso ama kanzɨna ɓɛyɔ, ɨkwɛ ndɨ kʉgʉ wa lɨsyɛ, aɓɨkya ɓɛ: «Babooo, ngbingo itulyonini. Mubibiso mikakʉ, kyɛ ɨyɨ ubibisi gɔnɨ. ");
INSERT INTO lik_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Wapóni ndɨ ɓʉngama kʉgʉ ka ɓambanzʉ ɓasɨ, kyɛ ʉpɨ́ ɓatʉ ɓasɨ nɨɓɔ wapá ɔɓɨlɨ wa ɓɛnzɛ na ɓɛnzɛ. ");
INSERT INTO lik_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ɔɓɨlɨ wa ɓɛnzɛ na ɓɛnzɛ yi nɨ kaumibo ɨwɛ, Kunzi ɓemoti, nɨnɔ walɨngʉnʉ na ɨmɨ Yeso-Kilisito nɨnɔ wetikoku ndɨ. ");
INSERT INTO lik_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ɨmɨ, nubibisoni kʉnʉ ka ɔɓɨlɨ. Nomoni ligubo nɨlɔ wetikoku ndɨ kagya. ");
INSERT INTO lik_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Babooo, mbɨya wanʉ, imigisyoku ɨbɨba ɓuwobi na ɨwɛ, ɨbɨba mʉɗɔngɔnɨ abɛ nɨyɔ nikaga ndɨ noyu kʉ kakʉ kambwa wagyɨ ɔɓɨlɨ. ");
INSERT INTO lik_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Numibisikosoni ka ɓatʉ nɨɓɔ ʉpʉnaga ndɨ ka ɔɓɨlɨ, wɛpá. Ɓa ndɨ ɓatʉ kakʉ, wepóku, ɓoɓuulyogo lɨkpʉmʉka kakʉ. ");
INSERT INTO lik_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Mbɨya yi nɨmʉ, ɓakaiba ɓɛ masɨ nɨmɔ wɛpá ndɨ, apʉnya kʉ kakʉ. ");
INSERT INTO lik_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Kyɛ nukitisyaga ndɨ lɨkpʉmʉka nɨlɔ aka lɔ wɛɓɨkyaga ndɨ, ɓaɓɨnɨkyana. Ɓiba ndɨ ka lɨngʉnʉ ɓɛ nopunyoku kʉ kakʉ na kaɓɨnɨkyana ɓɛ ɨwɛ nɔ wetikoku ndɨ. ");
INSERT INTO lik_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ɨmɨ, nakaʉkʉngɨlya. Nakɛgʉ kaʉkʉngɨlya ɓatʉ ɓa ɔɓɨlɨ, luki limoti, nɨɓɔ wɛpá ndɨ kyɛ ɓa kʉwa ɓatʉ kakʉ. ");
INSERT INTO lik_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Masɨ nɨmɔ na nomu a ma kakʉ na nɨmɔ kakʉ a ma kamɨ, ɨbɨba kamɨ akainisoniso ko pisi kaɓʉ. ");
INSERT INTO lik_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Nakɛgʉ ɓata ka ɔɓɨlɨ, luki limoti ɨɓʉ ɓa mbɛyɨ kʉ kwa kʉ, wɨna sɛ, ɨmɨ nakaaga kʉ kakʉ. Baba Wotuooo, huɓuulyogo ko ngu yo lino kakʉ. Lino nɨlɔ wɛpá ndɨ, kyɛ ɓiki luki limoti mʉɗɔngɔnɨ ɓɛyɔ iɓusu to mino na ɨwɛ. ");
INSERT INTO lik_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ngbingo yi nɨnɔ nikaga ndɨ mino pa imoti na ɨɓʉ, nuɓuulyaga ndɨ ko ngu yo lino kakʉ nɨlɔ wɛpá ndɨ. Nuɓuulyaga ndɨ ɓɨnza na gʉtʉgʉ ɓemoti luga kaɓʉ koɓungagagʉ ndɨ, kiki nɨnɔ aka nɔ oɓungaga ndɨ kyɛ Moɓiso Motu ɨtʉlyanɨ. ");
INSERT INTO lik_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Mbɨya wanʉ, nakaaga kʉ kakʉ. Nakaɓɨkya lɨkpʉmʉka li nɨlɨ nɨ na mbɛyɨ ɓata ka ɔɓɨlɨ aka iba ɨgyagya kamɨ iki ɓɨɗɛ kʉsɔ kaɓʉ. ");
INSERT INTO lik_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ɨmɨ, nʉɓɨkya ndɨ lɨkpʉmʉka kakʉ, na ɓatʉ ɓa ɔɓɨlɨ ɓʉmʉya ndɨ ɓɨkanganga kyɛ ɨɓʉ mʉɗɔngɔnɨ abɛ ɨmɨ gɔnɨ takɛgʉ ɓatʉ ɓa ɔɓɨlɨ. ");
INSERT INTO lik_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nakɛgʉ kalʉmba ambɛ hʉtʉmba ka ɔɓɨlɨ, luki limoti, huɓuulyogo ka mumuyoniso. ");
INSERT INTO lik_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ɨɓʉ mʉɗɔngɔnɨ abɛ ɨmɨ gɔnɨ takɛgʉ ɓatʉ ɓa ɔɓɨlɨ. ");
INSERT INTO lik_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Huɓuɓisa ɓitu pisi ka lɨngʉnʉ, kyɛ mʉnzɨna kakʉ nɨ lɨngʉnʉ. ");
INSERT INTO lik_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nakaʉtɨka ka ɔɓɨlɨ mʉɗɔngɔnɨ ɓɛyɔ wɛtikoku ndɨ gɔnɨ mino ɨmɨ. ");
INSERT INTO lik_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Nakaʉpá ɔɓɨlɨ kamɨ abɛ apɛpɛ ko bulya kaɓʉ, kyɛ ɓɨpɨ́ gɔnɨ ɨɓʉ na lɨngʉnʉ kʉ kakʉ. ");
INSERT INTO lik_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Nakɛgʉ kahʉlʉmbɨlya ɓaɓɨɓya ɓi nɨɓana aka ɓa, luki limoti, nakaʉlʉmbɨlya gɔnɨ ɓatʉ ɓasɨ nɨɓɔ ɓʉkana ndɛkɛ mʉtʉʉ kaɓʉ, ɓɛɓɨnɨkyana. ");
INSERT INTO lik_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nakalʉmba kyɛ ɨɓʉ ɓasɨ ɓiki luki limoti, mʉɗɔngɔnɨ ɓɛyɔ ɨwɛ Baba wo mino kʉsɔ kamɨ na ɨmɨ kʉsɔ kakʉ. Ɨɓʉ gɔnɨ ɓiki luki limoti kyɛ ɓatʉ ɓa ɔɓɨlɨ ɓaɓɨnɨkyanɨ ɓɛ ɨwɛ nɔ wetikoku ndɨ. ");
INSERT INTO lik_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ɨmɨ, nupóni ndɨ ɨbɨba nɨyɔ wɛpá ndɨ kyɛ ɓiki luki limoti mʉɗɔngɔnɨ ɓɛyɔ to mino na ɨwɛ. ");
INSERT INTO lik_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ɔɓɨlɨ kamɨ a kʉsɔ kaɓʉ na nɨnɔ kakʉ kʉsɔ kamɨ, iba ɓiki ka imoti na lɨngʉnʉ. A ɓɛyɔ, ɓatʉ ɓa ɔɓɨlɨ ɓiba ɓɛ ɨwɛ nɔ wetikoku, hʉpaga mʉɗɔngɔnɨ ɓɛyɔ wɛpaga mino. ");
INSERT INTO lik_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Babooo, ka ɓatʉ ɓi nɨɓɔ wɛpá ndɨ, nakapa ambɛ kʉ niko mino, ɓiki ɨɓʉ kʉ gɔ kʉ, kyɛ ɓɨnɨ ɨbɨba nɨyɔ kamɨ. Ɨbɨba yi nɨyɔ wɛpá ndɨ kyɛ wɛpatʉ ndɨ kambwa kagya ɔɓɨlɨ. ");
INSERT INTO lik_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Babooo, wa mʉtʉ wongbingbili. Ɓatʉ ɓa ɔɓɨlɨ ɓakumibigʉ, luki limoti, ɨmɨ numibatʉ pa imoti na ɓaɓɨɓya ɓi nɨɓɔ ɓaɓɨnɨkyana ɓɛ ɨwɛ nɔ wetikoku ndɨ. ");
INSERT INTO lik_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ɨmɨ, numibisikosoni ko misa ka ɓʉ na nidukulagatʉ kaumibisikoso, kyɛ sɨpananɨsɔ nɨsɔ wa nosu kʉgʉ kamɨ iki gɔnɨ ka mambɛngɨ kaɓʉ, na ɨmɨ niki gɔnɨ ka mambɛngɨ kaɓʉ.» ");
INSERT INTO lik_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Nɨyɔ ama kanzɨna ɓɛyɔ, Yeso opupa ndɨ na ɓaɓɨɓya kakɨ, aga kʉsyakʉ wo liɓo nɨlɔ ina ɓɛ Kidoloni. Ɓogulya ndɨ ko tiko yimoti nɨyɔ a ndɨ kʉ ɓɛyɔ. ");
INSERT INTO lik_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yuda, nɨnɔ agaba ndɨ, ibagatʉ ndɨ pa nɨyɔ kyɛ Yeso ɓamʉmʉkanagatʉ ndɨ na ɓaɓɨɓya kakɨ kʉ ɓɨgala-gala. ");
INSERT INTO lik_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ɨyɨ Yuda ɨnda kʉwa ndɨ ko tiko kʉ. A ndɨ pa imoti na ambaza ka ɓasʉda na ɓazamʉ ɓa Ndaɓʉ ko Kunzi nɨɓɔ ɓokumu-kumu na Ɓafalisayɔ ɓapá ndɨ. Ɓatʉ ɓi nɨɓɔ ɓa ndɨ na mamɔmɔ, ɓatala na makpʉmʉka ma ɓangʉ. ");
INSERT INTO lik_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yeso a ndɨ kaiba masɨ nɨmɔ a ndɨ kasilyo. Ukpuɗoku ndɨ, umuusa ɓɛ: «Makakɨsa wanɨ?» ");
INSERT INTO lik_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ɓasikisya ndɨ ɓɛ: «Yeso nɨnɔ mʉtʉ wa Nazalɛtɨ.» Ʉɓɨkya ɓɛ: «Ɨmɨ nɨmʉ.» Yuda nɨnɔ a ndɨ nɨ agobini, a ndɨ gɔnɨ wakamaga pa imoti na ɨɓʉ wa. ");
INSERT INTO lik_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Nɨyɔ Yeso ʉɓɨkya kʉwa ɓɛ: «Ɨmɨ nɨmʉ», ɓɨga na lɨbɔ kumbuso, ɓogwaga wasɨ ɓɨngɔmʉ-ngɔmʉ. ");
INSERT INTO lik_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ɨgɨlya ɓata ndɨ kaumuusa ɓɛ: «Makakɨsa wanɨ?» Ɨɓʉ aka ɓɛ: «Yeso, mʉtʉ wa Nazalɛtɨ.» ");
INSERT INTO lik_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yeso usikisya ndɨ ɓɛ: «Namuɓikyi ambɛ ɨmɨ nɨmʉ. Kika nɛkɨ nɨ ɨmɨ nɔ makɛkɨsa, husoni ɓatʉ ɓi nɨɓa ɓaga.» ");
INSERT INTO lik_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Anzɨna ndɨ ɓɛyɔ, kotulyoso mʉnzɨna nɨmɔ aɓɨkya ndɨ ɓɛ: «Babaooo, mʉtʉ gʉtʉgʉ ɓemoti aka koɓungagagʉ ndɨ luga ka ɓatʉ nɨɓɔ wɛpá ndɨ.» ");
INSERT INTO lik_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simoni Pɛtɛlɛ a ndɨ na dʉkpa, anyʉʉlya, ayipo mʉgya-ligubo ko kumu-kumu, akɔ kutiliko kwa kʉmbanzɨkanɨkɔ ɓɨkya. Lino ka mʉgya-ligubo nɔ ndɨ nɨ Malikusi. ");
INSERT INTO lik_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Luki limoti, Yeso aɓɨkya kʉwa ndɨ Pɛtɛlɛ ɓɛ: «Wigiso dʉkpa ka sɨkpakasʉ si. Baba nɔ eɓungusyilyaga ndɨ kɔpɔ wa yigyogyiso yi nɨmʉ. Ambɛ, wakapa ɓɛ nakamwonitɔgʉ?» ");
INSERT INTO lik_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ambaza ka ɓasʉda na ngama kaɓʉ, sɛ kʉwa ɓazamʉ ka ɓambɔkʉ-mbɔkʉ ka Ɓayuda ɓagwi kʉwa ndɨ Yeso, ɓakanda. ");
INSERT INTO lik_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ɓaga mbɛyɨ ndɨ na ɨyɨ ka Ana. Ɨyɨ Ana, a ndɨ abakɨ muka Kayafa nɨnɔ a ndɨ kumu-kumu ka syangasʉ si nɨsɔ. ");
INSERT INTO lik_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayafa nɔ ʉpá ndɨ ɓambɔkʉ ka ɓayuda mʉtʉʉ ɓɛ: «A gʉtʉgʉ ɓɨnza mʉtʉ ɓemoti kokwo ko bulya ka ɓatʉ ɓasɨ.» ");
INSERT INTO lik_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simoni Pɛtɛlɛ na mʉɓɨɓya wagɔgɔ ɓa ndɨ kaɓyɨɓya Yeso kumbuso. Mʉɓɨɓya yi nɨnɔ ɓibananagatʉ ndɨ no kumu-kumu, kinili ɓogulya ndɨ pa imoti na Yeso ka pa yangba ya ndaɓʉ ko kumu-kumu. ");
INSERT INTO lik_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Luki limoti, Pɛtɛlɛ asɨkana ndɨ ɨyɨ kʉnzi, ɓuwobi na mupumi. Mʉɓɨɓya yi nɨnɔ ɓibananaga ndɨ no kumu-kumu nɔ opupoku ndɨ, ɓanzɨna na muko yi nɨnɔ a ndɨ zamʉ wa mupumi, kumbuso yi, agulyiso Pɛtɛlɛ. ");
INSERT INTO lik_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Muko yi nɨnɔ amuusa ndɨ Pɛtɛlɛ ɓɛ: «Wakɛgʉ mbɛyɨ gɔnɨ ɨwɛ ɓemoti ka ɓaɓɨɓya ka alʉkʉ yi nɨmʉ?» Pɛtɛlɛ asikisya ndɨ ɓɛ: «Kalɨ, nakɛgʉ ɨmɨ mʉɓɨɓya kakɨ.» ");
INSERT INTO lik_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ɓʉdɨ a ndɨ ɓapʉ kʉgbɛ. Ɓagya-ligubo na ɓazamʉ ɓa ndɨ nɨ ɓogbundini ɓuku, ɓamanana ka kpɔlɔ yi kaʉta. Pɛtɛlɛ a ndɨ gɔnɨ ɨyɨ wakamaga wa, anʉta. ");
INSERT INTO lik_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Kumu-kumu apʉnga ndɨ kamuusogo Yeso ko bulya ɓaɓɨɓya kakɨ na ko bulya mʉtɨwɨ kakɨ. ");
INSERT INTO lik_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yeso asikisya ndɨ ɓɛ: «Ɨmɨ, nʉnzɨnɨlyaga ndɨ ɓambanzʉ ɓasɨ ɓɨngbanganya. Masyɛ masɨ natɨwaga ndɨ ka ɓandaɓʉ ɓaya malʉmba, ka Ndaɓʉ ko Kunzi na ka ɓapa ɓayasɨ nɨɓayɔ Ɓayuda ɓasɨ ɓamʉmʉkanaga ndɨ mino. Nakaɓɨkyagʉ ndɨ lɨkpʉmʉka gʉtʉgʉ limoti aka ko dikiɗi. ");
INSERT INTO lik_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Wakemuusogo ko bulya ɨkɨ? Umuuso ɓatʉ nɨɓɔ ɓɛmʉkanaga ndɨ. Ɨɓʉ, ɓibatʉ ɓɨnza nɨlɔ naɓɨkyaga ndɨ.» ");
INSERT INTO lik_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Nɨyɔ Yeso aɓɨkya ɓɛyɔ, zamʉ ɓemoti nɨnɔ a ndɨ wa aɓɨta Yeso, aɓɨkya ɓɛ: «Ambɛ, kumu-kumu nɔ wakasikisya ɓɛyɔ?» ");
INSERT INTO lik_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yeso asikisya ndɨ ɓɛ: «Kika nɨ noɓikyi ɓɨnyɛ, wonisila ɓʉnyɛ ɓi. Luki limoti, kika nɨ noɓikyi ɓɨnza, ko bulya ɨkɨ yɔ weipi mino?» ");
INSERT INTO lik_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Kʉwa wa, Ana atɨka ndɨ Yeso kʉ ko kumu-kumu ɓɛyɔ ka Kayafa. Ɨyɨ Yeso a mbɛyɨ ndɨ mʉkanda aka. ");
INSERT INTO lik_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ko ngbingo yi nɨnɔ, Simoni Pɛtɛlɛ a ndɨ wakamaga aka wa, anʉta ɓuku. Ɓamuusa ndɨ ɓɛ: «Wakikogigʉ mbɛyɨ gɔnɨ mʉɓɨɓya kakɨ?» Luki limoti, Pɛtɛlɛ anganya ndɨ, aɓɨkya ɓɛ: «Kalɨ! Nakɛgʉ ɨmɨ mʉɓɨɓya kakɨ.» ");
INSERT INTO lik_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ɓemoti ka ɓagya-ligubo ko kumu-kumu, nɨnɔ a ndɨ mamakɨ alʉkʉ nɨnɔ Pɛtɛlɛ akɔ ndɨ kutiliko, aɓɨkya ɓɛ: «Ambɛ, ɨmɨ, nakamuminigʉ mbɛyɨ ɓi na ɨyɨ ko tiko?» ");
INSERT INTO lik_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pɛtɛlɛ ɨgɨlya ɓata ndɨ kaanganya. Wa aka wa, kɔkʉ alɨka ndɨ. ");
INSERT INTO lik_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Kʉwa wa, ɓasʉda ɓatʉkya ndɨ na Yeso ka Kayafa ko mbolugo, ɓaga ndɨ na ɨyɨ ka basa ka ngama mudingi. Luki limoti, ɓangama ka ɓayuda ɓakogulyagʉ ndɨ ɨɓʉ kʉ ɓɛyɔ. Ɓa ndɨ kapa kaiko ɓakiɓuɓiso aka kyɛ ɓiki ɓakɨtʉlya kalya Pasɨka. ");
INSERT INTO lik_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Kinili, ngama mudingi ɓɛyɔ ka Pilatʉ opupoku ndɨ kaʉtakanya, umuusa ɓɛ: «Magwi alʉkʉ yi nɨmʉna ko bulya ɨkɨ?» ");
INSERT INTO lik_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ɓasikisya ndɨ ɓɛ: «Kiki ɓi mʉtʉ wanyɛ, iba takodukugʉ na ɨyɨ kʉ kakʉ.» ");
INSERT INTO lik_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilatʉ aɓɨkya kʉwa ndɨ ɓɛ: «Muvoni iɓunu ɓamombukwana-daɓʉ ɓi, masombiso kaɓyɛnɛnɛ na mʉtʉʉ kunu.» Ɓasikisya ndɨ ɓɛ: «Takɛgʉ iɓusu na luusa kamwɔ mʉmbanzʉ.» ");
INSERT INTO lik_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Igyonosa ndɨ ɓɛyɔ kyɛ lɨkpʉmʉka nɨlɔ Yeso aɓɨkya ndɨ ɨtʉlyanɨ, kowonisilo inguo ya kukwakʉ nɨkwɔ okwa ndɛkɛ. ");
INSERT INTO lik_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Kʉwa wa, Pilatʉ ogulya ɓata ndɨ ka basa, amaka Yeso, amuusa ɓɛ: «Ɨwɛ nɨ ngama ka Ɓayuda?» ");
INSERT INTO lik_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yeso aka ndɨ na ɨyɨ ɓɛ: «Upupi asɨ ɨwɛ aka ɓɨkpɛ, ikanɨ ɓatʉ ɓagɔgɔ ɓɔ ɓutumbulyogi?» ");
INSERT INTO lik_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilatʉ asikisya ɓɛ: «Na sɛ ɨmɨ muyuda? Sɨ ɓava-kʉkakʉ na ɓokumu-kumu ɓɔ ɓoduku na ɨwɛ. Wogyi ɓi ɨkɨ?» ");
INSERT INTO lik_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yeso asikisya ndɨ ɓɛ: «Ɓʉngama kamɨ kɛgʉ ɓa ɔɓɨlɨ yi nɨmʉ. Kika ndɨ ɓa ɔɓɨlɨ yi nɨmʉ, iba ɓatʉ kamɨ ɓebumonilyito ɓi ɓɛ ɓakegobonitɔgʉ ka Ɓayuda. Luki limoti, ɓʉngama kamɨ kɛgʉ ɓa wanʉ.» ");
INSERT INTO lik_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilatʉ amuusa kʉwa ndɨ ɓɛ: «Wa nɛkɨ ngama?» Yeso asikisya ɓɛ: «Ɨwɛ nɔ wakaɓɨkya ɓɛ na ngama. Ɨmɨ, nɨɓʉkʉta ndɨ na nodoku ndɨ ka ɔɓɨlɨ, kyɛ naɓɨkyagɨ ɓɨngbanganya makpʉmʉka ma lɨngʉnʉ. Mʉtʉ wasɨ nɨnɔ akɨsaga makpʉmʉka ma lɨngʉnʉ, ɛmʉkanagatʉ.» ");
INSERT INTO lik_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilatʉ amuusa ndɨ ɓɛ: «Lɨngʉnʉ mbɛyɨ nɨ ɨkɨ?» Nɨyɔ Pilatʉ aɓɨkya ɓɛyɔ, opupa ɓata ndɨ kʉ Ɓayuda ɓa ndɨ mino, ʉɓɨkya ɓɛ: «Nakinigʉ ɨmɨ ɨɓɔ gʉtʉgʉ imoti aka nɨyɔ okwononi mino ɓɛ ɓamwɨ alʉkʉ yi nɨmʉ. ");
INSERT INTO lik_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Luki limoti, kaɨna ɓɛyɔ magyaga mino ka ɓʉndɛlɨ, namʉkʉlyagatʉ mʉtʉ ɓemoti wa ligbito ka Pasɨka. Ma nɛkɨ kapa ɓɛ namʉkʉlyɨ ngama ka Ɓayuda?» ");
INSERT INTO lik_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Kʉwa wa, ɓapʉnga ndɨ kagbʉngbʉkana ɓɛ: «Kalɨ, kɛgʉ alʉkʉ yi nɨmʉ! Takapa Balaba aka.» Wɨna sɛ, Balaba yi nɨnɔ a ndɨ munzikaɓʉ. ");
INSERT INTO lik_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Kʉwa wa, Pilatʉ akpamya ndɨ ɓɛ ɓaga na Yeso, ɓatiniku pimbo. ");
INSERT INTO lik_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ɓasʉda ɓoipa ndɨ muligi mo mowo ɓiwilili abɛ ɨkpakpasʉ, ɓamokisya ndɨ. Ɓamokisya gɔnɨ ndɨ kanzʉ wangbʉ. ");
INSERT INTO lik_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ɓɨndaga ndɨ ɓuwobi na ɨyɨ, ɓanatɨba ɓikyekyekye ɓanaɓɨkya ɓɛ: «Tumuusito, ngama ka Ɓayuda!» Ɓanaɓɨtaga. ");
INSERT INTO lik_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilatʉ opupoku ndɨ ɓata, ʉɓɨkya Ɓayuda ɓɛ: «Hukononi, nakamunyulyoku kyɛ wiboni ambɛ, nakaminigʉ ɨmɨ na ɨɓɔ gʉtʉgʉ imoti aka nɨyɔ namakyɨ mino ka mʉngɨmbɔ.» ");
INSERT INTO lik_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Yeso opupoku kʉwa ndɨ, na ɨkpakpasʉ so mowo ka mʉ, ɓamokisyini kanzʉ wangbʉ. Pilatʉ aka na ɨɓʉ ɓɛ: «Mʉtʉ kunu nɨmʉ.» ");
INSERT INTO lik_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Nɨyɔ ɓokumu-kumu na ɓazamʉ ɓamɨna, ɓagbʉngʉkana ndɨ ɓɛ: «Mʉbangɨlaga ka mʉsalaba! Mʉbangɨlaga ka mʉsalaba!» Pilatʉ ʉɓɨkya ndɨ ɓɛ: «Muvoni iɓunu ɓamombukwana-donu, mabongilogoku. A ɓɛyɔ, nakaminigʉ ɨmɨ na ɨɓɔ nɨyɔ namakyɨ mino ka mʉngɨmbɔ.» ");
INSERT INTO lik_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ɓayuda ɓasikisya ndɨ ɓɛ: «Iɓusu ta na mʉtʉʉ, kaɓyɛnɛnɛ na mʉtʉʉ mi nɨmɔ, okwononi ɓɛ alʉkʉ yi nɨmʉ okwi, kyɛ akaɨbɨba ɓɛ a Miko Kunzi.» ");
INSERT INTO lik_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Nɨyɔ Pilatʉ ʉkana ɓɛyɔ, aɓanga ndɨ ɓata kʉgbɛ. ");
INSERT INTO lik_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ɨga ndɨ ka ndaɓʉ, amuusa Yeso ɓɛ: «Wa mbɛyɨ mʉkɨ?» Luki limoti, nɨ Yeso kasikisyigʉ. ");
INSERT INTO lik_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilatʉ amuusa kʉwa ndɨ ɓɛ: «Ambɛ, wedokilyi ɨmɨ? Wakɛgʉ mbɛyɨ kaiba ambɛ ɨmɨ nɔ nakwanana kaʉkʉlaga ikanɨ kaʉbangɨlaga ka mʉsalaba?» ");
INSERT INTO lik_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yeso asikisya ɓɛ: «Ɓʉngama kakʉ kɛgʉ kʉgʉ kamɨ, kiki asɨ nɨɓɔ aka ɓɔ Kunzi upóku ndɨ kotukyoku kʉgʉ wa lɨsyɛ. Kinili, mʉtʉ yi nɨnɔ egobi ɓi ka maɓɔkʉ kakʉ, obinikini ɓʉnyɛ ɓudingi kakɨtaga nɨɓɔ kakʉ.» ");
INSERT INTO lik_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Katʉkya ko ngbingo yi nɨnɔ, Pilatʉ apʉnga ndɨ kakɨsa pisi kasiso Yeso. Luki limoti, Ɓayuda ɓapʉnga ɓata ndɨ kagbʉngbʉkana ɓɛ: «Wakasisa alʉkʉ yi nɨmʉ iba wakɛgʉ wai-dakɨ Kaizalɨ. Mʉtʉ wasɨ nɨnɔ akaidondiso ɓɛ a ngama, a mumuyoniso ka Kaizalɨ.» ");
INSERT INTO lik_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Nɨyɔ Pilatʉ ʉkana ɓɛyɔ, apupisisa ndɨ Yeso. Ika ndɨ ko kiti nɨnɔ ʉkɔgɔ ndɨ mino ɓangbanga, ka pa nɨyɔ ɓoɗukya ndɨ na matamʉ. Pa nɨyɔ ɓalɨkyaga na Libelenia ɓɛ «Gabata.» ");
INSERT INTO lik_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Lɨsyɛ li nɨlɔ a ndɨ lɨsyɛ la kiɓungusyogo ka yɨnga wa Pasɨka, banda sa-sita. Pilatʉ ʉɓɨkya kʉwa ndɨ Ɓayuda ɓɛ: «Ngama kunu nɨmʉ!» ");
INSERT INTO lik_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Luki limoti, ɓagbʉngʉkana ndɨ ɓɛ: «Mʉmwɔ! Mʉmwɔ! Mʉbangɨlaga ka mʉsalaba!» Pilatʉ umuusa ndɨ ɓɛ: «Makapa ɓɛ nabangɨlagɨ ngama kunu ka mʉsalaba?» Ɓokumu-kumu ɓasikisya ndɨ ɓɛ: «Takɛgʉ iɓusu na ngama wagɔgɔ, asɨ Kaizalɨ aka.» ");
INSERT INTO lik_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Pilatʉ ʉpá kʉwa ndɨ Yeso ɓɛ kyɛ ɓabangɨlagɨ ka mʉsalaba. Ɓasʉda ɓava kʉwa ndɨ Yeso. ");
INSERT INTO lik_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ɨyɨ Yeso mombukwana-dakɨ yi nɔ abɨnɨka ndɨ mʉsalaba kakɨ, opupa ndɨ kunzi wa gʉɗʉ. Ɨnda kʉwa ndɨ miso ya pa nɨyɔ ɓalɨkyaga ɓɛ «Pa ya Ɨkpʉkpʉkʉsɔ» isi yi na Libelenia ɓɛ «Gɔlɔgɔta.» ");
INSERT INTO lik_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Kʉ ɓɛyɔ, ɓabangɨlaga ndɨ Yeso ka mʉsalaba na ɓatʉ ɓagɔgɔ ɓaɓa, nɔ kʉ, nɔ kʉ. ");
INSERT INTO lik_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilatʉ okpika ndɨ ko mikya-lɨɓaʉ, ɓabanga ka mʉsalaba. A ndɨ yikpiko ɓɛ: «Yeso mʉtʉ wa Nazalɛtɨ, Ngama ka Ɓayuda.» ");
INSERT INTO lik_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ɓayuda ɓudingi ɓatangʉlaga ndɨ moɓiso mi nɨmɔ, kyɛ pa nɨyɔ ɓabangɨlaga ndɨ mino Yeso a ndɨ ɓuwobi na gʉɗʉ. A ndɨ yikpiko ka Libelenia, Lilatini na Ligiliki. ");
INSERT INTO lik_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Kʉwa wa, ɓokumu-kumu ka Ɓayuda ɓaɓɨkya ndɨ Pilatʉ ɓɛ: «Wokokpikoni ɓɛ: ‹Ngama ka Ɓayuda,› luki limoti kpiko ɓɛ: ‹Alʉkʉ yi nɨmʉ aɓɨkya ndɨ ɓɛ: Ɨmɨ nɨ Ngama ka Ɓayuda!›» ");
INSERT INTO lik_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Luki limoti, Pilatʉ usikisya ndɨ ɓɛ: «Nɨyɔ nokpiki, ikpikini.» ");
INSERT INTO lik_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Nɨyɔ ɓasʉda ɓama kabangɨlaga Yeso, ɓava ndɨ ɓotu kakɨ, ɓagbananaga ka ɓapanga ɓayɨkwanganya. Sʉda ɓemoti-ɓemoti ava ndɨ panga yi yimoti. Ɓava ndɨ gɔnɨ kanzʉ kakɨ nɨnɔ ɨtɨla ndɨ nɨ kɛgʉ na ɓapanga, katʉkya kʉgʉ adwɛ kusili, a ndɨ kutuko kumuti aka. ");
INSERT INTO lik_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ɓasʉda ɓaɓɨkyana ndɨ luga kaɓʉ ɓɛ: «Takayiɓogonitɔgʉ kanzʉ yi nɨmʉ, totwini mino lɨɓɛsɛ, iba tɨnɨ ɓɛ wanɨ nɔ asumbo.» Lɨkpʉmʉka li nɨlɨ igyonosa ndɨ kyɛ ɨtʉlyanɨ Moɓiso Motu nɨmɔ akaɓɨkya ɓɛ: «Ɓagbananaga ndɨ ɓotu kamɨ, ɓatwa lɨɓɛsɛ ko bulya kanzʉ kamɨ.» Ɓasʉda ɓagya ndɨ ɓɛyɔ. ");
INSERT INTO lik_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Amakɨ Yeso, mamakɨ-amakɨ nɨnɔ muko yi, Malia nɨnɔ a ndɨ muko Kɨlɨɔpasɨ sɛ kʉwa Malia mʉtʉ wa Magadala ɓa ndɨ ɓakamaga ɓuwobi na mʉsalaba ka Yeso. ");
INSERT INTO lik_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Nɨyɔ Yeso amɨna ndɨ amakɨ pa imoti na mʉɓɨɓya yi nɨnɔ apága ndɨ kʉgbɛ, aɓɨkya ndɨ ɓɛ: «Mama, mikakʉ nɨmʉ.» ");
INSERT INTO lik_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Kumbuso yi, aɓɨkya ndɨ mʉɓɨɓya nɔ ɓɛ: «Amakʉ kʉwa nɨmʉ.» Katʉkya ka lɨsyɛ li nɨlɔ, mʉɓɨɓya nɔ aga ndɨ na Malia kʉ kakɨ. ");
INSERT INTO lik_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Kumbuso yi, Yeso a ndɨ kaiba ɓɛ masɨ itulyonini. Kotulyasa nɨlɔ ikpikaga ndɨ ka Moɓiso Motu, aɓɨkya ɓɛ: «Nakaɨmʉkana mʉsasa mo liɓo.» ");
INSERT INTO lik_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Wa ɓɛyɔ, a ndɨ na mbɨkɛ yimoti yitumo na vinya wozyo ɓɨɗɛ. Kʉwa wa, ɓasʉda ɓava ndɨ luki limoti la fʉɓʉ-fʉɓʉ, ɓoluba ndɨ ka vinya yi nɨnɔ, ɓakpɨkɨla ndɨ ka mʉ ma mikya mʉngbɨngɨlɨ ma sɨbʉkʉsɔ nɨsɔ ɓalɨkyaga ɓɛ ɨsɔpɔ, ɓokpuɗisa ndɨ ka mʉnɔkʉ ka Yeso. ");
INSERT INTO lik_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Nɨyɔ Yeso amya vinya wozyo yi nɨnɔ, aɓɨkya ndɨ ɓɛ: «Masɨ itulyonini.» Abʉmya kʉwa ndɨ mʉ, osisa lɨmbɛngɨ. ");
INSERT INTO lik_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Lɨsyɛ li nɨlɔ a ndɨ lɨsyɛ la kiɓungusyogo ka Lɨsyɛ la kimumbiso. Kinili, Ɓayuda ɓakɛgʉ ndɨ kapa ɓɛ ɓamanda ka ɓatʉ ɓi nɨɓɔ ɓʉbangɨlaga ndɨ iki ka mʉsalaba aka kyɛ Lɨsyɛ la kimumbiso li nɨlɔ, a ndɨ lidingi. Ɓakʉnga kʉwa ndɨ Pilatʉ ɓɛ ɓuɓunogi magʉ kyɛ ɓutotisogi. ");
INSERT INTO lik_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ɓasʉda ɓodoku kʉwa ndɨ koɓunaga magʉ ka ɓatʉ nɨɓɔ ɓʉbangɨlaga ndɨ na ɓa Yeso ka mʉsalaba. Ɓapʉnga ndɨ na mʉtʉ wa mambwa sɛ kʉwa nɨnɔ wagɔ. ");
INSERT INTO lik_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Nɨyɔ ɓosilo ka Yeso, ɓɨna ndɨ ɓɛ okwini, kinili, ɓakaɓunagʉ ndɨ ɓata magʉ. ");
INSERT INTO lik_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Luki limoti, sʉda ɓemoti atuma ndɨ na syogbu ka mbanzɨ, ko ngbinga ɓemoti aka, liɓo na ɓangʉ opupa ndɨ. ");
INSERT INTO lik_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Mʉtʉ yi nɨnɔ ɨna ndɨ lɨkpʉmʉka li nɨlɨ nɔ akatʉmbʉlaga yi. Mʉtʉmbʉlagɨ kakɨ a ma lɨngʉnʉ. Ɨyɨ akaiba ɓɛ akaɓɨkya lɨngʉnʉ ko bulya kyɛ iɓunu ɓinikyononito gɔnɨ. ");
INSERT INTO lik_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Masɨ nɨmɔ igyonosa ndɨ kyɛ ɨtʉlyanɨ nɨlɔ Moɓiso Motu aɓɨkyaga ɓɛ: «Gʉtʉgʉ mukuwo kakɨ mumuti aka koɓunikigʉ ndɛkɛ.» ");
INSERT INTO lik_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Moɓiso magɔgɔ Motu akaɓɨkya ɓɛ: «Ɓandaga ndɛkɛ mʉtʉ yi nɨnɔ ɓatuma ndɨ na syogbu.» ");
INSERT INTO lik_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Kumbuso yi, Yɛzɛfʉ mʉtʉ wa Alimatia, ɨnda ndɨ kakʉnga Pilatʉ manda ka Yeso. Pilatʉ abaɨlya ndɨ. Yɛzɛfʉ ikaga ndɨ mʉɓɨɓya ka Yeso ko dikiɗi kyɛ a ndɨ kaʉɓanga ɓangama ka Ɓayuda, ovoku kʉwa ndɨ manda ka Yeso. ");
INSERT INTO lik_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodimo nɨnɔ ɨnda ndɨ ka Yeso lɨsyɛ limoti no biti, odoku ndɨ na malazi nɨmɔ ɓalɨkyaga ndɨ ɓɛ manɛmanɛ mʉmatanaga no luki abɛ adʉdʉ. Malazi mi nɨmɔ a ndɨ banda kilo ɓatɛkɛɓɛ ɓasaa. ");
INSERT INTO lik_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Kʉwa wa, ɨɓʉ ɓasɨ ɓaɓa ɓava ndɨ manda ka Yeso, ɓakandaga ndɨ na ɓabandi ɓi nɨɓayɔ ɓogboɗyaga ndɨ na malazi mi nɨmɔ, mʉɗɔngɔnɨ ɓɛyɔ Ɓayuda ɓagyaga ndɨ mino kambwa kalumbo mʉmbanzʉ. ");
INSERT INTO lik_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Tiko yimoti a ndɨ ka pa nɨyɔ ɓabangɨlaga ndɨ mino Yeso ka mʉsalaba. Kʉsɔ wo tiko yi nɨyɔ, a ndɨ na mbʉkʉ yimoti yambɨya nɨyɔ a ndɨ nɨ ɓakanalumbigʉ mino mʉmbanzʉ. ");
INSERT INTO lik_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Kaɨna ɓɛ lɨsyɛ li nɨlɔ a ndɨ lɨsyɛ la kiɓungusyogo ka Lɨsyɛ la kimumbiso ka Ɓayuda, ɓalumba ndɨ Yeso wa kyɛ mbʉkʉ yi nɨyɔ a ndɨ ɓuwobi. ");
INSERT INTO lik_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ka lɨsyɛ la Mungu ko mbolugo, Malia nɨnɔ mʉtʉ wa gʉɗʉ wa Magadala ɨnda ndɨ ka mbʉkʉ. Nɨyɔ osila kʉ, ɨna ɓɛ lɨtalʉ lidingi nɨlɔ ɓadʉla ndɨ nolu mbʉkʉ, ɓa ndɨ nɨ ɓotumbini. ");
INSERT INTO lik_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Aga ndɨ mbangʉ ka Simoni Pɛtɛlɛ na ka mʉɓɨɓya wagɔ nɨnɔ Yeso apaga ndɨ, ʉɓɨkya ɓɛ: «Ɓanyuni Mombukwono-dosu ka mbʉkʉ, takibigʉ ambɛ ɓabisiku yanɨ.» ");
INSERT INTO lik_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Pɛtɛlɛ na mʉɓɨɓya nɨnɔ wagɔ nɔ ɓaga ndɨ ka mbʉkʉ. ");
INSERT INTO lik_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ɨɓʉ ɓasɨ ɓaɓa ɓaga ndɨ mbangʉ. Luki limoti, mʉɓɨɓya nɨnɔ wagɔ nɔ a ndɨ kapɨkɨta mbangʉ yapʉ kakɨtaga Pɛtɛlɛ, adwɛ ndɨ ɨyɨ kambwa. ");
INSERT INTO lik_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Odidika ndɨ, aɓɨmya, ɨna ɓotu ɓayiɗukusila ka kpɔlɔ, luki limoti, nɨ kingyigʉ. ");
INSERT INTO lik_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Kʉwa wa, Simoni Pɛtɛlɛ, nɨnɔ a ndɨ kaɓiɓyoku, osiloku. Ogulya ndɨ ka mbʉkʉ, ɨna ɓabandɨ ɓayiɗukusilo wa, ");
INSERT INTO lik_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ɨna gɔnɨ ndɨ panga ya kutuko nɨkwɔ ɓatikya ndɨ noku Yeso mʉ. Panga ya kutuko yi nɨyɔ a ndɨ yiɗukufogo, yibisa di ka pa yagɔgɔ nɨ kɛgʉ pa imoti na ɓabandɨ. ");
INSERT INTO lik_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Kʉwa wa, mʉɓɨɓya wagɔgɔ nɨnɔ aɗɨkya ndɨ kosila ka mbʉkʉ, ogulya gɔnɨ. Ɨna ndɨ, aɓɨnɨkyana. ");
INSERT INTO lik_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","A ɓɛyɔ, kadwɛ ko ngbingo yi nɨnɔ, ɓaɓɨɓya ɓa ndɨ nɨ ɓakonotombisyigʉ isi ya lɨkpʉmʉka nɨlɔ ɓokpika ndɨ ko Moɓiso ɓɛ Yeso opupatʉ ndɛkɛ ka mbʉkʉ. ");
INSERT INTO lik_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Kumbuso yi, ɓaɓɨɓya ɓaɓa ɓi nɨɓɔ ɓɨganana ndɨ. ");
INSERT INTO lik_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Malia a ndɨ wakamaga kunzi, ka kpɔlɔ wa mbʉkʉ, anagama. Ngbingo yi nɨnɔ a mbɛyɨ ndɨ mina kagama aka nɔ, odidika ndɨ kaɓɨmya mbʉkʉ, ");
INSERT INTO lik_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ʉmɨna kʉwa ndɨ ɓamalaika ɓaɓa ɓimokisyogini ɓotu ɓayotutu, ɓikogini ka pa nɨyɔ ɓongosa ndɨ mina manda ka Yeso. Ɓemoti a ndɨ miso ya mʉ, wagɔ miso ya magʉ. ");
INSERT INTO lik_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ɓamuusa ndɨ ɓɛ: «Yɛ ma, wakagama ɨkɨ?» Usikisya ndɨ ɓɛ: «Ɓanyuni Mombukwana-damɨ ka mbʉkʉ, nakibigʉ ambɛ ɓabisiku yanɨ.» ");
INSERT INTO lik_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Kumbuso kaɓɨkya ɓɛyɔ, oyikana ndɨ, amɨna Yeso wakamaga, luki limoti, nɨ kamibigʉ. ");
INSERT INTO lik_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yeso amuusa ndɨ ɓɛ: «Yɛ ma, wakagama ɨkɨ? Wakakɨsa wanɨ?» Malia a ndɨ kasɨma ɓɛ zamʉ wo ɓotiko nɔ. Aɓɨkya kʉwa ndɨ ɓɛ: «Yɛ ba, kika nɨ ɨwɛ nɔ wanyu ɓi, ɨwanya kʉ wabisi ɓi mino, naviku.» ");
INSERT INTO lik_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yeso amaka ndɨ ɓɛ: «Malia!» Malia oyikana ndɨ, aɓɨkya na Libelenia ɓɛ: «Labuni!» isi yi ɓɛ «Muwonisilo.» ");
INSERT INTO lik_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yeso aɓɨkya ndɨ ɓɛ: «Wakevilonitɔgʉ, kyɛ nakanoɗokigʉ mbɛyɨ ka Baba. Luki limoti, wɨnda kaʉɓɨkya ɓomika-mama ambɛ nakaɗaka ka Baba nɨnɔ a gɔnɨ Obonu, ko Kunzi kamɨ nɨnɔ a gɔnɨ Kunzi kunu.» ");
INSERT INTO lik_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Malia yi nɨnɔ wa Magadala nɔ ɨnda kʉwa ndɨ kaʉɓɨkya ɓaɓɨɓya ɓɛ aminito Mombukwono-dosu, ʉtʉmbʉlyaga ɓɛyɔ aɓɨkya ndɨ mino. ");
INSERT INTO lik_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ɓʉgɔgɔ ɓa lɨsyɛ la Mungu li nɨlɔ aka lɔ, ɓaɓɨɓya ɓa ndɨ ɓʉmʉmʉkana. Ɓadʉlaga ndɨ pumi ya ndaɓʉ nɨyɔ ɓa ndɨ mino ɓɨkpwɔkpwɔkpwɔ, kyɛ ɓa ndɨ kaʉɓanga Ɓayuda. Yeso odoku ndɨ, amaga luga kaɓʉ ɓɨgba, ɨyɨ aka na ɨɓʉ ɓɛ: «Mazɨyɔ iki pa imoti na iɓunu!» ");
INSERT INTO lik_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Kumbusa kaɓɨkya ɓɛyɔ, ʉwanya maɓɔkʉ na mbanzɨ. Ɓaɓɨɓya ɓogwa kʉwa ndɨ magyagya kamɨna Mombukwono-dosu. ");
INSERT INTO lik_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yeso ɨgɨlya ɓata ndɨ kaʉɓɨkya ɓɛ: «Mazɨyɔ iki pa imoti na iɓunu! Mʉɗɔngɔnɨ ɓɛyɔ Baba ɛtɨka ndɨ mino, nakamʉtɨka ɨmɨ ɓɛgɛyɔ.» ");
INSERT INTO lik_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Nɨyɔ aɓɨkya ndɨ ɓɛyɔ, uusya ndɨ na ahʉ, ʉɓɨkya ɓɛ: «Lɨmbɛngɨ-Lotu iki kʉsɔ kunu. ");
INSERT INTO lik_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ɓatʉ ɓasɨ nɨɓɔ mʉpɨlyaga ndɛkɛ ɓʉnyɛ, ɓinisanaga ndɛkɛ na mʉpɨlya. Ɓasɨ nɨɓɔ makʉpɨlyɨgʉ ndɛkɛ, ɓakinisonigʉ ndɛkɛ na mʉpɨlya.» ");
INSERT INTO lik_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Luki limoti, ngbingo yi nɨnɔ Yeso upuponilya ndɨ mino, Tʉma nɨnɔ ɓamakaga ndɨ gɔnɨ ɓɛ «Muɓigi», ɓemoti ka ɓaɓɨɓya tɛkɛɓɛ na ɓaɓa, kɛgʉ ndɨ ɨyɨ wa. ");
INSERT INTO lik_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ɓaɓɨɓya ɓagɔgɔ ɓaɓɨkya kʉwa ndɨ ɓɛ: «Taminito sɛ iɓusu Mombukwono-dosu.» Luki limoti, Tʉma usikisya ndɨ ɓɛ: «Nakini ɓepukulu ɓayo sumani ka maɓɔkʉ kakɨ, nakatuni kpɛngbɛ ka ɓepukulu ɓi nɨɓɔ, nakovili mbanzɨ kakɨ, nakaɓɨnɨkyanɨgʉ pɔ.» ");
INSERT INTO lik_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Kumbusa wa pɔsɔ ɓemoti, ɓaɓɨɓya ɓamʉmʉkana ɓata ndɨ ka ndaɓʉ yi nɨyɔ. Tʉma a kʉwa ndɨ pa imoti na ɨɓʉ. Gʉtʉgʉ ɓɛyɔ pumi a ndɨ mino yɨdʉlaga aka yɔ, Yeso odoku ndɨ, ɨyɨ aka luga kaɓʉ ɓɨgba, ʉɓɨkya ndɨ ɓɛ: «Mazɨyɔ iki pa imoti na iɓunu!» ");
INSERT INTO lik_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Kʉwa wa, aɓɨkya ndɨ Tʉma ɓɛ: «Mʉtʉna kpɛngbɛ kakʉ wanʉ, wɨna maɓɔkʉ kamɨ. Makya kʉɓɔkʉkɔ wanʉ, wɛvɨla mbanzɨ. Wakikonitɔgʉ ɓata na ɓotumo, luki limoti, ɓɨnɨkyana kʉwa.» ");
INSERT INTO lik_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tʉma asikisya ndɨ ɓɛ: «Mombukwana-damɨ, Kunzi kamɨ!» ");
INSERT INTO lik_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yeso aka ndɨ na ɨyɨ ɓɛ: «Woɓinikyonini sɛ kʉwa kyɛ weminini? Ɨgyagya ka ɓatʉ nɨɓɔ ɓaɓɨnɨkyanaga nɨ ɓakinigʉ!» ");
INSERT INTO lik_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yeso agyatʉ ndɨ ɓata makpʉmʉka mʉmbanga-mbanga magɔ makpʉ ko misa ka ɓaɓɨɓya kakɨ. Makpʉmʉka mi nɨmɔ kikpikagagʉ ndɨ ka kɨtaɓʉ yi nɨyɨ. ");
INSERT INTO lik_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Luki limoti, ɓokpika ndɨ nɨmana kyɛ maɓɨnɨkyanɨ ɓɛ Yeso nɨ Masiya, Miko-Kunzi. Makaɓɨnɨkyana ɓɛyɔ, minisana na ɔɓɨlɨ pisi ko lino kakɨ. ");
INSERT INTO lik_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Kumbuso yi, Yeso upuponilya ɓata ndɨ ɓaɓɨɓya kakɨ ka kpɔlɔ wa ibombu ya Tibelia. Upuponilya ndɨ ɓɛnɛ: ");
INSERT INTO lik_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Lɨsyɛ limoti, Simoni Pɛtɛlɛ, Tʉma nɨnɔ ɓamakaga ndɨ gɔnɨ ɓɛ Muɓigi, Natanaeli nɨnɔ a ndɨ mʉtʉ wa Kana ka iwili ya Galilaya, ɓomika Zɛbɛdayɔ ɓaɓa na ɓaɓɨɓya kakɨ ɓagɔgɔ ɓaɓa, ɓa ndɨ pa imoti. ");
INSERT INTO lik_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simoni Pɛtɛlɛ aka ndɨ na ɨɓʉ ɓɛ: «Nakaaga ka ɓosi.» Ɨɓʉ ɓasikisya ndɨ ɓɛ: «Gʉtʉgʉ iɓusu aka, taga na iɓunu.» Ɓaga kʉwa ndɨ, ɓaɗaka ka ɨngbɔlɔ. Luki limoti, biti yi nɨyɔ, ɓakanyɔgʉ ndɨ musi gʉtʉgʉ ɓemoti aka. ");
INSERT INTO lik_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Nɨyɔ lɨsyɛ a ndɨ kosyoku, Yeso a ndɨ wakamaga kubi, luki limoti ɓaɓɨɓya ɓakɛgʉ ndɨ kamibo. ");
INSERT INTO lik_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yeso umuusa kʉwa ndɨ ɓɛ: «Ɓomikamɨ, mugwito ɓosi?» Ɨɓʉ aka ndɨ ɓɛ: «Haaa.» ");
INSERT INTO lik_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Yeso ʉɓɨkya ndɨ ɓɛ: «Luboni moyo ka kʉmbanzɨkanɨkɔ kwa ɨngbɔlɔ, mugwito ɓosi kʉ ɓɛyɔ.» Ɓoluba kʉwa ndɨ, moyo ʉgyagya kanyɔ kyɛ ɓosi ɓa ndɨ nɨ ɓoyumonini mino ɓɨyʉ. ");
INSERT INTO lik_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Mʉɓɨɓya nɨnɔ Yeso apaga ndɨ aɓɨkya Pɛtɛlɛ ɓɛ: «Mombukwono-dosu aka mʉ!» Nɨyɔ Simoni Pɛtɛlɛ ʉkana ɓɛyɔ, imokisya ndɨ kutuko kyɛ a ndɨ ndumbu, ɨyɨ aka ndɨ ko liɓo ɓikudumu. ");
INSERT INTO lik_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ɓaɓɨɓya ɓagɔgɔ ɓa ndɨ kodoku aka ɓɨwɛsɛɛ na ɨngbɔlɔ nɨ ɓananyɔ moyo nɨmɔ a ndɨ nɨ oyumonini na ɓosi mɔ. A ɓɛyɔ, ɓakɛgʉ ndɨ ɓata ɓyɨ na kubi, a kʉwa ndɨ abɛ mɛtɛlɛ mɨya imoti aka. ");
INSERT INTO lik_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Nɨyɔ ɓɨfʉma, ɓatakanya ndɨ musi kʉgʉ wa makamʉ, na mukati. ");
INSERT INTO lik_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yeso ʉɓɨkya ndɨ ɓɛ: «Doniku mino na ɓosi nɨɓɔ mapʉnya kaʉnyɔ.» ");
INSERT INTO lik_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simoni Pɛtɛlɛ aɗaka kʉwa ndɨ ka ɨngbɔlɔ, apʉnga koluta moyo nɨmɔ a ndɨ mʉyʉmana na ɓosi ɓakpʉkpʉ mɨya imoti ɓatɛkɛɓɛ kuɓukumuti na ɓasaa. Gʉtʉgʉ ɓɛyɔ ɓa ndɨ mino ɓudingi yɔ, moyo katɨnɨkagagʉ ndɨ. ");
INSERT INTO lik_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yeso ʉɓɨkya kʉwa ndɨ ɓɛ: «Doniku kalyalya.» Gʉtʉgʉ mʉɓɨɓya ɓemoti aka kɨkpʉndagʉ ndɨ kamuusa ɓɛ: «Ɨwɛ nɨ wanɨ?» Ɓa ndɨ kaiba ɓɨnza ɓɛ Mombukwono-dosu nɔ. ");
INSERT INTO lik_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yeso ukpuɗoku ndɨ, ava mukati, ʉpága pa imoti na ɓosi. ");
INSERT INTO lik_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","A kʉwa ndɨ nganga ya yɨsaa Yeso kaupuponilyo ɓaɓɨɓya kakɨ, katʉkya wa opupoku ndɨ mino ka mbʉkʉ. ");
INSERT INTO lik_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Nɨyɔ ɓama kalyalya, Yeso amuusa ndɨ Simoni Pɛtɛlɛ ɓɛ: «Simoni, mika Yuani, wɛpagatʉ kaʉkɨtaga ɓatʉ ɓi nɨɓa?» Pɛtɛlɛ asikisya ndɨ ɓɛ: «Iyo, Mombukwono-dosu, wibatʉ ɓɨnza ɓɛ nʉpagatʉ.» Yeso aka ndɨ na ɨyɨ ɓɛ: «Huɓuulyogo ɓomikya ɓakɔndɔlɔ kamɨ!» ");
INSERT INTO lik_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ɨgyɨlya ɓata ndɨ kamuusa ɓɛ: «Simoni, mika Yuani, wɛpagatʉ?» Pɛtɛlɛ asikisya ndɨ ɓɛ: «Iyo, Mombukwono-dosu, wibatʉ ɓɨnza ɓɛ nʉpagatʉ.» Yeso aka ndɨ ɓata na ɨyɨ ɓɛ: «Huɓuulyogo ɓakɔndɔlɔ kamɨ!» ");
INSERT INTO lik_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Kumbuso yi, Yeso amuusa ɓata ndɨ ka nganga ya yɨsaa ɓɛ: «Simoni, mika Yuani, wɛpagatʉ?» Pɛtɛlɛ alya ndɨ kumbu kʉgbɛ ka yuuso ya yɨsaa yi nɨyɔ ɓɛ: «Wɛpagatʉ?» Asikisya kʉwa ndɨ ɓɛ: «Mombukwono-dosu, wibaga makpʉmʉka masɨ, wibatʉ ɓɛ nʉpatʉ!» Yeso aɓɨkya ndɨ ɓɛ: «Huɓuulyogo ɓakɔndɔlɔ kamɨ! ");
INSERT INTO lik_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","A lɨngʉnʉ, a lɨngʉnʉ, nakaʉɓɨkya ambɛ, ngbingo yi nɨnɔ wa ndɨ mino mʉwanza, wɨkpɨkɨlaga ndɨ ɨwɛ mombukwana-dakɨ yi mʉkaɓa, waga kʉ wapaga ndɨ mino. Luki limoti, ngbingo yi nɨnɔ wadʉɓa ndɛkɛ mino, wananaga ndɛkɛ maɓɔkʉ, mʉtʉ wagɔgɔ ʉkpɨkɨla mʉkaɓa, aga na ɨwɛ kʉ wakɛgʉ ɓi mino kapa.» ");
INSERT INTO lik_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ka mʉnzɨna mi nɨmɔ, Yeso a ndɨ kowonisila ɓɛyɔ Pɛtɛlɛ okwa mino, apá ɨbɨba ko Kunzi. Kumbuso yi, Yeso aka ndɨ na ɨyɨ ɓɛ: «Iɓyeku!» ");
INSERT INTO lik_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Nɨyɔ Pɛtɛlɛ oyikono, amɨna ndɨ mʉɓɨɓya nɨnɔ Yeso apaga ndɨ nɨ anodoku. Mʉɓɨɓya yi nɨnɔ nɔ amuusa ndɨ Yeso na ɓepisi-pisi lɨsyɛ nɨlɔ ɓa ndɨ mina kalya Pasɨka ɓɛ: «Mombukwono-dosu, wanɨ nɔ akaʉgaba?» ");
INSERT INTO lik_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Nɨyɔ Pɛtɛlɛ amɨna mʉɓɨɓya yi nɨnɔ ɓɛyɔ, amuusa Yeso ɓɛ: «Mombukwono-dosu, yɛgʉ sɛ kʉwa nɨmʉ, lɨkpʉmʉka tino lɔ asilya ndɛkɛ?» ");
INSERT INTO lik_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yeso asikisya ndɨ ɓɛ: «Nakapa ambɛ kokwonito kadwɛ kʉ kwa kʉ nigoku ndɛkɛ mino, la kakʉ mino nɨ ɨkɨ? Ɨwɛ, iɓyeku.» ");
INSERT INTO lik_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Kinili, mongoni mi nɨmɔ aɗa kʉwa luga ka ɓatʉ nɨɓɔ ɓaɓɨnɨkyana ndɨ Yeso ɓɛ mʉɓɨɓya yi nɨnɔ kokwigʉ ndɛkɛ ɨyɨ. Wɨna sɛ, Yeso kaɓɨkyagʉ ndɨ ɓɛ kokwigʉ, luki limoti, aɓɨkya ndɨ ɓɛ: «Nakapa ɓɛ kokwonito kʉ kwa kʉ nigoku ndɛkɛ mino, la kakʉ mino nɨ ɨkɨ?» ");
INSERT INTO lik_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Dɛmʉ wa makpʉmʉka mi nɨmɔ nɨ mʉɓɨɓya yi nɨnɔ. Ɨyɨ gɔnɨ nɔ okpikaga. Takaiba ambɛ ɓʉdɛmʉ kakɨ a ɓalɨngʉnʉ. ");
INSERT INTO lik_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yeso agyatʉ ndɨ makpʉmʉka magɔgɔ mudingi. Nakaɨna abɛ ɓakokpikaga ndɨ masɨ, imoti-imoti, iba pa kikigʉ ndɨ ka ɔɓɨlɨ wasɨ nɨyɔ ɓakwanana kobiso mino ɓakɨtaɓʉ ɓi nɨɓayɔ.");
INSERT INTO lik_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ambɔkʉ Tiofilo, Kʉsɔ wa kɨtaɓʉ kamɨ ya mambwa, natʉmbʉlaga ndɨ makpʉmʉka masɨ nɨmɔ Yeso apʉnga ndɨ kagya na kowonisilo katʉkya ka ɓʉndɛlɨ, ");
INSERT INTO lik_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","kadwɛ ka lɨsyɛ li nɨlɔ Kunzi aɗokisa ndɨ mino kʉgʉ wa lɨsyɛ. Yeso a ndɨ nɨ upunogini ɓatʉtʉmbwa, kambwa kaɗaka kʉgʉ wa lɨsyɛ, ʉpá mʉtʉʉ pisi ka Lɨmbɛngɨ-Lotu. ");
INSERT INTO lik_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","A ɓɛyɔ, kumbusa wa kukwakʉ kakɨ, Yeso upuponilya ndɨ ɓatʉtʉmbwa kauwonisilo ɓɨngbanganya ka ɓopisi dididi ɓɛ opupiniku ɓi ka mbʉkʉ. Kʉsɔ wa masyɛ ɓatɛkɛɓɛ ɓakwanganya, Yeso upuponilyaga ndɨ, anʉnzɨnɨlya ko bulya Ɓʉngama ko Kunzi. ");
INSERT INTO lik_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Lɨsyɛ limoti, ngbingo yi nɨnɔ ɓa ndɨ mino kalyalya pa imoti, ʉgbɨtyaga ndɨ ɓɛ: «Makotukyonitɔgʉ ka Yelusalɛma wa. Luki limoti, muɓundogoni apɛpɛ nɨnɔ aka nɔ Baba amʉwanyaga ndɨ. Apɛpɛ yi nɨnɔ ɨmɨ mombukwana-dakɨ namʉpá ndɨ mongoni mi. ");
INSERT INTO lik_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","A ɓɛyɔ, Yuani oɓotisa ndɨ ko liɓo. Luki limoti, iɓunu, kumbusa wa masyɛ makɛɗɛ, ɓamuɓotiso ɓanʉ na Lɨmbɛngɨ-Lotu.» ");
INSERT INTO lik_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Kʉwa wa, ɓatʉtʉmbwa nɨɓɔ ɓa ndɨ ɓʉmʉmʉkana pa imoti na Yeso, ɓamuusa ndɨ ɓɛ: «Mombukwono-dosu, wakaumigisilyo Ɓezaleli Ɓʉngama mbɨya wanʉ?» ");
INSERT INTO lik_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yeso usikisya ndɨ ɓɛ: «Kɛgʉ bulyo kunu kaiba ngbingo ikanɨ lɨsyɛ nɨlɔ lɨkpʉmʉka li nɨlɔ igyonosa ndɛkɛ mino. Baba yɨkaka aka nɔ akaiba ko ngu kakɨ. ");
INSERT INTO lik_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Luki limoti, motumo ɓanʉ no ngu ngbingo yi nɨnɔ Lɨmbɛngɨ-Lotu amusilya mino. Miko ɓadɛmʉ kamɨ ka gʉɗʉ yi nɨnɔ ina ɓɛ Yelusalɛma, ka iwili ya Yudɛa na Samalia wasɨ na kadwɛ ka mondu ma ɔɓɨlɨ wasɨ.» ");
INSERT INTO lik_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Kumbusa wa mʉnzɨna mi nɨmɔ, Kunzi aɗokisa ndɨ Yeso kʉgʉ wa lɨsyɛ nɨ ɓatʉtʉmbwa kakɨ ɓanamɨna. Kʉwa wa, ɨkʉɓa aɗika ndɨ ɓiwaɗi nɨ ɓakaminigʉ ɓata. ");
INSERT INTO lik_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ko ngbingo yi nɨnɔ ɓazwa kaɓʉ ɓa mbɛyɨ ndɨ mino ɓakɨtʉlya aka kʉgʉ wa lɨsyɛ kʉ Yeso a ndɨ mino kaaga, ɓatʉ ɓaɓa ɓakimokisyogo ɓotu ɓitutu ɓupuponilyoku ndɨ ɓigbututu. ");
INSERT INTO lik_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ɓʉɓɨkya ndɨ ɓatʉtʉmbwa ɓɛ: «Iɓunu ɓatʉ ɓa Galilaya, ko bulya ɨkɨ yɔ momononi mino ɓigwo, mananda asɨ kʉgʉ wa lɨsyɛ aka ɓɛyɔ? Yeso nɨnɔ Kunzi atumbi luga kunu kaɗokiso kʉgʉ wa lɨsyɛ, igoku ndɛkɛ mʉɗɔngɔnɨ ɓɛgɛyɔ mamini mino kaaga yi.» ");
INSERT INTO lik_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Kʉwa wa, ɓatʉtʉmbwa ɓatʉkya ka ngʉpa nɨyɔ ɓalɨkyaga ndɨ ɓɛ Ngʉpa ya Mizeituni, ɓɨga ka Yelusalɛma. Ngʉpa yi nɨyɔ kɛgʉ ndɨ ɓyɨ na gʉɗʉ, a ndɨ abɛ kilomɛtɛlɛ imoti aka. ");
INSERT INTO lik_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ngbingo yi nɨnɔ ɓosilo mino ka Yelusalɛma, ɓaɗaka ndɨ ka ndaɓʉ ya kʉgʉ nɨyɔ ɓamʉmʉkanaga ndɨ mino. A ndɨ nɨ Pɛtɛlɛ, Yuani, Yakɔbɔ, Andɨlɨa, Filipi, Tʉma, Batulumei, Matayɔ, Yakɔbɔ mika Alʉfayɔ, Simoni nɨnɔ a ndɨ kakɨsa ɨpandasɨ ka mugi kaɓʉ na Yuda mika Yakɔbɔ. ");
INSERT INTO lik_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ɨɓʉ ɓasɨ ɓamʉmʉkanaga ndɨ masyɛ masɨ kalʉmba pa imoti na mʉtamanagɨ mimoti. Ɓalʉmbaga ndɨ na ɓoko, na Malia amakɨ Yeso, na ɓamamakɨ Yeso. ");
INSERT INTO lik_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ka masyɛ mi nɨmɔ aka mɔ, ɓambanzʉ abɛ mɨya na ɓatɛkɛɓɛ-ɓaɓa nɨɓɔ ɓabaɨlya ndɨ, ɓamʉmʉkana ndɨ. Pɛtɛlɛ amaga ndɨ luga ka ɨɓʉ, ɨyɨ aka ɓɛ: ");
INSERT INTO lik_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«Ɓomika-mamaaa, okwononi ɓi ɓɛ ɨtʉlyanɨ nɨlɔ Lɨmbɛngɨ-Lotu aɓɨkya ndɨ ka Moɓiso. Lɨmbɛngɨ li nɨlɔ anzɨna ndɨ kambwa kʉsɔ ka Daudi ko bulya ka Yuda. Ɨyɨ Yuda nɔ ɨɨta ndɨ kʉwa ngama ka ɓatʉ ɓi nɨɓɔ ɓagwi ndɨ Yeso. ");
INSERT INTO lik_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yuda a ndɨ ɓemoti kusu, ikaga ndɨ gɔnɨ na ligubo mʉɗɔngɔnɨ abɛ iɓusu. ");
INSERT INTO lik_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Oluwa ndɨ tiko no ɓuyi ɓi nɨɓɔ ɓakalya ndɨ na ɨɓʉ ko bulya lɨkpʉmʉka lanyɛ li nɨlɔ agya ndɨ lɔ. Kʉ ɓɛyɔ, ogwoku ndɨ na mʉ ɓɨpɛ, mʉma amalɨka, ɓasɔpʉ ɓayasɨ ayobuka ndɨ ɓigbondo. ");
INSERT INTO lik_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ɓatʉ ɓasɨ ɓa Yelusalɛma ɓʉkana ndɨ mongoni mi nɨmɔ. Kinili ɓalʉka ndɨ tiko yi nɨyɔ ka lɨsasʉ kaɓʉ ɓɛ: ‹Akɛlɨdamʉ›, isi yi nɨ: ‹Tiko ya Ɓangʉ›. ");
INSERT INTO lik_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Wina sɛ, ikpikaga ka kɨtaɓʉ ya Mambʉ ka Ɓayuda ɓɛ: ‹Pa kakɨ iki ndɛkɛ ngundu, mʉmbanzʉ gʉtʉgʉ ɓemoti aka kikigʉ ndɛkɛ mino.› Ikpiko gɔnɨ ɓɛ: ‹Mʉtʉ wagɔgɔ nɔ avɨ ndɛkɛ pa ya ligubo kakɨ.› ");
INSERT INTO lik_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Kinili, okwononi ɓɛ mʉtʉ ɓemoti ogulyi luga kusu, kaiko dɛmʉ wo pupo ka Mombukwono-dosu Yeso ka mbʉkʉ. Iki ɓemoti ka nɨɓɔ tikaga ndɨ na ɨɓʉ ɓongbinga ɓasɨ, wa tolingyaga ndɨ mino giyo pa imoti na Ɓamombukwono-dosu Yeso, katʉkya ko ngbingo yi nɨnɔ Yuani aɓotisa ndɨ mino, na kadwɛ ka lɨsyɛ li nɨlɔ Kunzi aɗokisa ndɨ mino kʉgʉ wa lɨsyɛ.» ");
INSERT INTO lik_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Kʉwa wa, ɓumomosa ndɨ ɓatʉ ɓaɓa: A ndɨ nɨ Yɛzɛfʉ, nɨnɔ ɓamakaga ndɨ ɓɛ Balisaba, ɓalʉka ndɨ gɔnɨ ɓɛ Yusuto sɛ kʉwa Matɨasɨ. ");
INSERT INTO lik_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Kumbuso yi, ɓatʉ nɨɓɔ ɓamʉmʉkana ndɨ wa, ɓalʉmba ɓɛ: «Mombukwono-dosu, ɨwɛ nɨnɔ wiba mambɛngɨ ka ɓatʉ ɓasɨ, tiwonisilo nɨnɔ wapunogi luga ka ɓatʉ ɓaɓa ɓi nɨɓa, ");
INSERT INTO lik_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","iki atʉtʉmbwa ka Yeso, agyɨ ɓanʉ ligubo li nɨlɔ Yuda osi ɓi ɨyɨ, ɨmagalya ka pa yi nɨyɔ kakɨ.» ");
INSERT INTO lik_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Kʉwa wa, ɓatwa ndɨ lɨɓɛsɛ. Lɨɓɛsɛ awanya Matɨasɨ nɨnɔ ɓamakya ndɨ ka mʉɗɔngɔ ka ɓatʉtʉmbwa tɛkɛɓɛ na ɓemoti. ");
INSERT INTO lik_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Nɨyɔ lɨsyɛ la Patɛkɔtɨ ɨtʉlyana, ɓaɓɨɓya ɓasɨ ɓa ndɨ ɓʉmʉmʉkana pa imoti. ");
INSERT INTO lik_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ko ngbingo ɓemoti, mungbi oɓuka ndɨ katukyoku kʉgʉ wa lɨsyɛ mʉɗɔngɔnɨ abɛ muvivi mapʉ, otumo ɓɨɗɛ ka ndaɓʉ yasɨ nɨyɔ ɓa ndɨ mino ɓakikonono. ");
INSERT INTO lik_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ɓɨna kʉwa ndɨ luki anipupisoku abɛ maɗaɗa mo ɓuku. Ɨgbananaga ndɨ, ibisogo limoti-limoti kʉgʉ ka mʉmbanzʉ yɨkaka-yɨkaka. ");
INSERT INTO lik_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ɨɓʉ ɓasɨ ɓotuma ndɨ na Lɨmbɛngɨ-Lotu, ɓapʉnga kanzɨna masasʉ magɔgɔ mʉɗɔngɔnɨ ɓɛyɔ Lɨmbɛngɨ li nɨlɔ a ndɨ mino kaʉkpamya. ");
INSERT INTO lik_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Wɨna sɛ, Ɓayuda nɨɓɔ ɓotukyoku ndɨ ko giyo yasɨ ya ɔɓɨlɨ, ɓikaga ndɨ ka Yelusalɛma wa. Ɓaɓangaga ndɨ Kunzi kʉgbɛ. ");
INSERT INTO lik_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ngbingo yi nɨnɔ ɓʉkana ndɨ mino mungbi mi nimɔ, ɓamʉmʉkana ambaza ɓemoti. Ɨɓʉ ɓasɨ ɓanombomboya kʉgbɛ, kyɛ mʉtʉ ɓemoti-ɓemoti luga kaɓʉ a ndɨ kaʉmʉkana ɓaɓɨɓya nɨ ɓakanzɨna ka lɨsasʉ kakɨ ɓɨkpɛ. ");
INSERT INTO lik_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Lɨkpʉmʉka lɔ ʉmbanga ndɨ kʉgbɛ, ɓotumo na ombombo ɓɨɗɛ, ɓaɓɨkya ɓɛ: «Ɓatʉ nɨɓana ɓakanzɨna ɓa, ɓakɛgʉ mbɛyɨ ɓasɨ asɨ Ɓagalilaya aka? ");
INSERT INTO lik_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Igyonoso kʉwa ɓʉnɨ ɓɛ mʉtʉ yɨkaka-yɨkaka luga kusu ʉmʉkanɨ kanzɨna lɨsasʉ kakɨ la kɨɓʉkʉta? ");
INSERT INTO lik_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Atʉ ndɨ na ɓambanzʉ nɨɓɔ ɓotukyoku ndɨ ka mugi ma Palatɨ, Medi, Elamu, Mezopotamia, Yudɛa, Kapadokia, Poto na ka iwili ya Azia, ");
INSERT INTO lik_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Fuligia, Pamufilia, Misili, ka pa yimoti ya Libia nɨyɔ a ɓuwobi na gʉɗʉ yi nɨnɔ ina ɓɛ Kuleni. Atʉ ndɨ na nɨɓɔ ɓotukyoku ndɨ ka gʉɗʉ wa Lʉma, ");
INSERT INTO lik_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ka mugi ma Kɛlɛtɛ na nɨmɔ ma Alabia. Luga kaɓʉ, atʉ ndɨ na Ɓayuda ɓɨkpɛ, na ɓagɔgɔ niɓɔ ɓagyaga mʉtʉʉ ka Musa. Wɨna sɛ, iɓusu ɓasɨ takaʉmʉkana kanzɨna makpʉmʉka mʉmbanga-mbanga ko Kunzi ka masasʉ kusu.» ");
INSERT INTO lik_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ɓombombaya ndɨ ɓasɨ, lɨkpʉmʉka ʉmbanga kʉgbɛ. Ɓuusono ɓɛ: «Isi ya lɨkpʉmʉka lɨna pɨyɛ nɨ ɨkɨ?» ");
INSERT INTO lik_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Luki limoti, ɓagɔgɔ ɓapʉnga kaʉtɨba ɓaɓɨɓya, ɓanaɓɨkya ɓɛ: «Nɨɓana ɓokwini lɨbʉma!» ");
INSERT INTO lik_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Kʉwa wa, Pɛtɛlɛ amaga ndɨ pa imoti na ɓatʉtʉmbwa tɛkɛɓɛ na ɓemoti, apʉnga ndɨ kaɓɨkya na lɨyʉ lapʉ ɓɛ: «Iɓunu ɓomikya Ɓayuda, na iɓunu ɓasɨ nɨɓɔ mikaga ka Yelusalɛma, pongoni motili, mibo nɨlɨ, mʉkana ɓɨnza nɨlɔ nakamʉɓɨkya. ");
INSERT INTO lik_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ɓatʉ nɨɓana ɓakɛgʉ na lɨbʉma ɓɛyɔ mo mino kaʉmɨna yɨ, kyɛ mɔnɨ a mbɛyɨ ka saa-tatʉ ya ɓʉsɔɓɨ aka. ");
INSERT INTO lik_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Luki limoti, lɨkpʉmʉka nɨlɔ mugyalandʉ Yueli aɓɨkya ndɨ, a kʉwa kaigyonoso mbɨya wanʉ: ");
INSERT INTO lik_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‹Kunzi akaɓɨkya ɓɛ: Ka masyɛ ma muliɓo, nuɗukulya ndɛkɛ ɓambanzʉ ɓasɨ Lɨmbɛngɨ kamɨ, ɓomikunu, ɓalʉkʉ na ɓoko ɓi ɓika ndɛkɛ ɓogyalandʉ, ɓawanza na ɓambɔkʉ-mbɔkʉ kunu ɓalʉtaga ndɛkɛ ɓonziki. ");
INSERT INTO lik_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Iyo, ka masyɛ mi nɨmɔ, noɗuka ndɛkɛ Lɨmbɛngɨ kamɨ kʉgʉ ka ɓagya-ligubo kamɨ ɓoko na ɓalʉkʉ ɓi, ɓika kʉwa ndɛkɛ ɓogyalandʉ. ");
INSERT INTO lik_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Nagya ndɛkɛ makpʉmʉka mʉmbanga-mbanga kʉgʉ wa lɨsyɛ na mokingyosi mʉpá ombombo ka ɔɓɨlɨ wa. Mɨna ndɛkɛ ɓangʉ, ɓuku na muki ɓindegbu-ndengbu. ");
INSERT INTO lik_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Mɔnɨ opiya ndɛkɛ ɓipi, tɨmba angbamya ɓɨngbʉ abɛ ɓangʉ. Nɨmɔ igyonosa ndɛkɛ kambwa wa lɨsyɛ nɨlɔ Mombukwono-dosu odoku ndɛkɛ mino, lɨsyɛ li nɨlɔ lidingi na la ɨbɨba. ");
INSERT INTO lik_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Kʉwa wa, mʉtʉ wasɨ nɨnɔ ɨgama ndɛkɛ no lino ko Mombukwono-dosu, inisono ndɛkɛ na muhukuso.› ");
INSERT INTO lik_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Iɓunu ɓomikya Ɓezaleli, hukononi ɓɨnza lɨkpʉmʉka nɨlɨna nakamʉɓɨkya lɨ: Kunzi amuwonisatʉ ndɨ ɓɛ Yeso nɨnɔ mʉtʉ wa Nazalɛtɨ nɨ wanɨ. Makaiba ɓɨnza ɓɛ Kunzi agya ndɨ luga kunu, pisi ka Yeso, makpʉmʉka makpʉkpʉ, mʉmbanga-mbanga na mokingyosi mʉpá ombombo. ");
INSERT INTO lik_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ɓasʉta ndɨ alʉkʉ yi nɨnɔ ka maɓɔkʉ kunu, Kunzi a ndɨ kaiba nɨlɔ kambwa aka, abaɨlya ɓɛ igyonosi ɓɛyɔ. Mamwɔ ndɨ pisi kabongisiso ka mʉsalaba ka maɓɔkʉ ka ɓatʉ ɓi nɨɓɔ ɓakamibigʉ Kunzi. ");
INSERT INTO lik_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Luki limoti, Kunzi, akʉlaga ndɨ ka mʉzʉzʉla ma kukwakʉ pisi kapupiso ka mbʉkʉ, kyɛ kukwakʉ kakwananɨgʉ ndɨ kakʉkʉmɨlyaga. ");
INSERT INTO lik_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","A ɓɛyɔ, Daudi anzɨna ndɨ ko bulya kakɨ ɓɛ: ‹Namɨnaga ndɨ Mombukwono-dosu kambwa kamɨ ɓongbinga ɓasɨ, a ɓuwobi na ɨmɨ kyɛ nakomomonitɔgʉ. ");
INSERT INTO lik_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Kinili, lɨmbɛngɨ kamɨ a na mazɨyɔ, mʉnɔkʉ kamɨ amutumo na magyagya ɓɨɗɛ, gʉtʉgʉ nzʉyɨ kamɨ ika ndɛkɛ yakɨtʉlya ka mʉtamanagɨ, ");
INSERT INTO lik_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","a ɓɛyɔ, wakasɨgʉ ndɛkɛ lɨmbɛngɨ kamɨ kozingo ka ɓabɨlɨ, wakasɨgʉ ndɛkɛ mʉgya-ligubo kakʉ Wotu kapɔ. ");
INSERT INTO lik_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Wewonisila ndɨ ɓopisi ɓaya ɔɓɨlɨ walɨngʉnʉ, wetumisa ndɛkɛ na magyagya ɓɨɗɛ wa tiko mino na ɨwɛ.› ");
INSERT INTO lik_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Ɓomika-mama, nakwanana kamʉɓɨkya lɨngʉnʉ ko bulya ka titosu ɓɛyɔ ka Daudi ɓɛ: okwoni ndɨ, ɓalumbo. Mbʉkʉ kakɨ a mbɛyɨ ɓata wa aka wa kadwɛ na lɨsyɛ li nɨlɨ. ");
INSERT INTO lik_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Luki limoti, a ndɨ mugyalandʉ, iba ndɨ ɓɛ Kunzi akʉlya ndɨ silika ɓɛ amomosa ndɛkɛ miki ɓemoti luga wa lɨvananza kakɨ nɨnɔ alya ndɛkɛ ɓʉngama ka pa kakɨ. ");
INSERT INTO lik_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Daudi ɨna ndɨ kambwa aka ɓɛ Kilisito opupokuto ndɛkɛ ka mbʉkʉ ngbingo yi nɨnɔ aɓɨkya ndɨ mino ɓɛ: ‹Kunzi kasɨgʉ ndɛkɛ kozingo ka ɓabɨlɨ, na nzʉyɨ kakɨ kapʉgʉ ndɛkɛ.› ");
INSERT INTO lik_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Kunzi apupisatʉ ndɨ Yeso yi nɨnɔ nakanzɨna ko bulya kakɨ ka mbʉkʉ, iɓusu ɓasɨ ta ɓadɛmʉ ɓa lɨkpʉmʉka li nɨlɔ. ");
INSERT INTO lik_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Kʉwa wa, Kunzi aɗokisa ndɨ kʉgʉ, alikiso ka kʉmbanzɨkanɨkɔ kakɨ. Apá ndɨ Lɨmbɛngɨ-Lotu mʉɗɔngɔnɨ ɓɛyɔ awanyaga ndɨ mino. Yeso atitikilyoku ndɨ. A nɨlɔ makaɨna na kaʉkana mbɨya wanʉ. ");
INSERT INTO lik_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","A ɓɛyɔ, Daudi kaɗakagʉ ndɨ ɨyɨ kʉgʉ wa lɨsyɛ, luki limoti aɓɨkya ndɨ ɓɛ: ‹Mombukwono-dosu Kunzi aɓɨkya ndɨ Mombukwana-damɨ ɓɛ: dawiki ka kʉmbanzɨkanɨkɔ kamɨ, ");
INSERT INTO lik_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","kadwɛ kʉ kwa kʉ nubiso mino ɓomuyoniso kakʉ kusili wa ɓakagba kakʉ.› ");
INSERT INTO lik_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Kinili, ɓɛvananza ɓayasɨ ɓaya Izaleli ɓokwononi kaiba ɓɨnza ɓɛ Yeso yi nɨnɔ mabangɨlaga ndɨ ka mʉsalaba, Kunzi aitisa ndɨ Mombukwono-dosu na Kilisito!» ");
INSERT INTO lik_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Nɨyɔ ɓambanzʉ ɓʉkana mino lɨkpʉmʉka li nɨlɔ ɓɛyɔ, ɓogwa ndɨ ombombo kʉgbɛ. Ɓamuuso Pɛtɛlɛ na ɓatʉtʉmbwa ɓagɔgɔ ɓɛ: «Ɓomika-mama, tagya nɨlɨna ɓʉ?» ");
INSERT INTO lik_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pɛtɛlɛ usikisya ɓɛ: «Ikosoni mambɛngɨ na mʉmbanzʉ yɨkaka-yɨkaka ogwo iɓatiso ko lino ka Yeso-Kilisito, Kunzi amʉpɨlyatʉ ɓʉnyɛ kunu, amʉpá Lɨmbɛngɨ-Lotu. ");
INSERT INTO lik_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","A ɓɛyɔ, agʉmɛ ko Kunzi a ko bulya kunu na ɓomikunu. A ko bulya ka ɓatʉ ɓasɨ nɨɓɔ ɓa ɓyɨ, na ɓasɨ nɨɓɔ Mombukwono-dosu Kunzi ʉmaka ndɛkɛ.» ");
INSERT INTO lik_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pɛtɛlɛ idukulogo ɓata ndɨ kaʉtʉmbʉlyaga makpʉmʉka magɔgɔ kaʉpá mʉsasa ka baya na kautumiso mambɛngɨ, anaɓɨkya ɓɛ: «Puponi ka mʉɗɔngɔ ka ɓatʉ ɓa lɨsyɛ li nɨlɨ kyɛ ɓa ɓanyɛ, Kunzi amuusagatʉ.» ");
INSERT INTO lik_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ɓudingi luga kaɓʉ ɓabaɨlya ndɨ mʉnzɨna ka Pɛtɛlɛ, ɓogwo iɓatiso. Lɨsyɛ li nɨlɔ, ɓambanzʉ abɛ ɓɛlɔfʉ ɓasaa ɓabaɨlya ndɨ, ɓɨmatɨla ka liɗu ka ɓatʉ ɓa baya. ");
INSERT INTO lik_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ɓikaga ndɨ ɓakɨtʉlya ɓongbinga ɓasɨ kaʉkana mʉtɨwɨ ka ɓatʉtʉmbwa, ɔɓɨlɨ kaɓʉ ikaga ndɨ abɛ ɓomika-muko, ɓanalyalya pa imoti na ɓanalʉmba pa imoti. ");
INSERT INTO lik_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Mʉmbanzʉ yɨkaka-yɨkaka luga kaɓʉ ikaga ndɨ na kʉɓangakʉ, kyɛ Kunzi agyaga ndɨ makpʉmʉka mʉmbanga-mbanga makpʉ pisi ka ɓatʉtʉmbwa. ");
INSERT INTO lik_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ɓikaga ndɨ ɨɓʉ ɓasɨ luki limoti, ɓanobiso mukumbo kaɓʉ pa imoti. ");
INSERT INTO lik_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ɓagabaga ndɨ lɨngama na mukumbo kaɓʉ, ɓagbananaga ɓuyi ɓi luga kaɓʉ ɓasɨ kaɓyɛnɛnɛ na yangya ka mʉtʉ yɨkaka-yɨkaka. ");
INSERT INTO lik_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Lɨmbɛngɨ limoti, ɓamʉmʉkanaga ndɨ masyɛ masɨ ka Ndaɓʉ ko Kunzi, ɓanalyalya pa yimoti. Ɓalyalyaga ndɨ na magyagya, na mambɛngɨ makisiso ka ɓandaɓʉ kaɓʉ. ");
INSERT INTO lik_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ɓabibisaga ndɨ Kunzi, ɓambanzʉ ɓasɨ ɓanʉpa. Masyɛ masɨ Mombukwono-dosu ʉmatɨlaga ndɨ ka liɗu kaɓʉ, ɓambanzʉ nɨɓɔ ɓinisanaga ndɨ na muhukuso. ");
INSERT INTO lik_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Lɨsyɛ limoti, Pɛtɛlɛ na Yuani ɓa ndɨ kaɗaka ka Ndaɓʉ ko Kunzi ka malʉmba ma saa-tisa. ");
INSERT INTO lik_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ɓuwobi na mupumi mi, nɨmɔ ɓalɨkyaga ndɨ ɓɛ «Mupumi Manza», mʉlʉkʉ ɓemoti ikaga ndɨ wa. Mʉlʉkʉ yi nɨnɔ ɨɓʉkʉta ndɨ zɛgɛsɨ. Masyɛ masɨ ɓabinikogoku ndɨ wa, kyɛ iki kaɨkʉkʉngya ka ɓatʉ nɨɓɔ ɓogulyaga ndɨ kʉ ɓɛyɔ. ");
INSERT INTO lik_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Nɨyɔ amɨna ndɨ Pɛtɛlɛ na Yuani nɨ ɓanogulyo kʉ, ʉkʉnga ɓuyi. ");
INSERT INTO lik_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ɓanda ndɨ ɓɨngbangbangba, Pɛtɛlɛ aka na ɨyɨ ɓɛ: «Tindoku!» ");
INSERT INTO lik_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Alʉkʉ nɔ ʉnda ndɨ ɓizumuuu, kyɛ a ndɨ na mʉtamanagɨ ɓɛ ɓakapá luki. ");
INSERT INTO lik_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Kʉwa wa, Pɛtɛlɛ aɓɨkya ndɨ ɓɛ: «Nakɛgʉ gʉtʉgʉ na lɨfalanga aka ikanɨ ɔlɔ. Luki limoti, nakaʉpá tʉmatʉ nɨtɔ na notu: ko lino ka Yeso-Kilisito nɨnɔ mʉtʉ wa Nazalɛtɨ, wamaga, wakpakyana!» ");
INSERT INTO lik_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Kumbuso yi, Pɛtɛlɛ agwi ndɨ kʉɓɔkʉkɔ kwa kʉmbanzɨkanɨkɔ kamomoso. Wa aka wa, magʉ apingaga ndɨ, ");
INSERT INTO lik_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ɨyɨ aka ndɨ ɓɨndɔmʉ, ɓɨgba, apʉnga kakpakyana. Ɓogulya ndɨ na Pɛtɛlɛ ɨɓʉ na Yuani, anobumbukogo nɨ anabibiso Kunzi. ");
INSERT INTO lik_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ɓatʉ ɓasɨ nɨɓɔ ɓa ndɨ wa, ɓamɨna nɨ anakpakyana, anabibiso Kunzi. ");
INSERT INTO lik_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Nɨyɔ ɓibo ɓɛ ɨyɨ nɔ ikaga ndɨ wakiko kaɨkʉkʉngya ka kpɔlɔ wa mupumi ma Ndaɓʉ ko Kunzi, nɨmɔ ɓalɨkyaga ndɨ ɓɛ «Mupumi Manza», ɓaɓanga ndɨ, ɓapʉnga kombomboyo ko bulya lɨkpʉmʉka nɨlɔ akɨtyanaga ndɨ lɔ. ");
INSERT INTO lik_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Alʉkʉ nɔ kɛgʉ ndɨ ɓata kapa katʉkya ka kpɔlɔ ka Pɛtɛlɛ na Yuani. Ɓatʉ ɓasɨ ɓombomboya ndɨ kʉgbɛ, ɓaga mbangʉ kʉ ɓa ndɨ mino ka pa nɨyɔ ɓalɨkyaga ndɨ ɓɛ «Pa ya kɨgbʉka ka ngama Sɔlɔmɔnɔ.» ");
INSERT INTO lik_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Nɨyɔ Pɛtɛlɛ ɨna ndɨ ɓɛyɔ, ʉɓɨkya ɓambanzʉ ɓɛ: «Iɓunu Ɓezaleli, ko bulya ɨkɨ yɔ mo mino kombomboyo ka lɨkpʉmʉka li nɨlɨ? Ko bulya ɨkɨ yɔ mo mino katɨnda ɓɨngbangbangba abɛ iɓusu ɓɔ takpokyonisi pisi ko ngu na ɓungbingbili kusu kambwa ko Kunzi? ");
INSERT INTO lik_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Kunzi ka Abalahamʉ, ka Isaka na ka Yakɔbɔ, Kunzi ka ɓotitosu, owonisi ɨbɨba ka musunzu kakɨ ɓɛyɔ ka Yeso. Iɓunu masʉta ndɨ, mamanganya kambwa ka Pilatʉ nɨnɔ a ndɨ wakɨtʉlya kakʉlaga. ");
INSERT INTO lik_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","A ndɨ Wotu na Wongbingbili, luki limoti, iɓunu mamanganya ndɨ, maɓɨkya Pilatʉ ɓɛ amʉkʉlyɨ mʉgya-manyɛ. ");
INSERT INTO lik_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Wɨna sɛ, iɓunu mamwisisa ndɨ mʉtʉ yi nɨnɔ atɨpága ɔɓɨlɨ walɨngʉnʉ, luki limoti Kunzi apupisa ndɨ ka mbʉkʉ. Tɨna ndɨ lɨkpʉmʉka li nɨlɔ no miso. ");
INSERT INTO lik_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Alʉkʉ yi nɨmʉna makamɨna mʉ, mamibagatʉ. Ohuki pisi ka baya yo lino ka Yeso, lino li nɨlɔ apingisogini. Baya yɔ ahukusi lɨngʉnʉ ɓɛyɔ ma kʉwa mino kamɨna yɨ. ");
INSERT INTO lik_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Ɓomika-mama, mbɨya wanʉ, nakaiba ɓɨnza ambɛ iɓunu na ɓangama kunu magya ndɨ Yeso ɓɛyɔ kyɛ makɛgʉ ndɨ kaiba. ");
INSERT INTO lik_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Luki limoti, Kunzi otulyosa ndɨ nɨlɔ aɓɨkya ndɨ ka ɓʉndɛlɨ pisi ka ɓogyalandʉ ɓasɨ ɓɛ Masiya kakɨ igyogyisatʉ ndɛkɛ. ");
INSERT INTO lik_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Yikosoni nɛkɨ ɔɓɨlɨ kunu, mamigilyoku Kunzi kyɛ olimogi ɓʉnyɛ kunu. ");
INSERT INTO lik_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Kʉwa wa, Mombukwono-dosu amʉpátʉ ndɛkɛ ngbingo muyukumo, amʉtɨkɨlya Yeso, Masiya nɨnɔ amʉpʉnɨlyaga ndɨ katʉkya ka ɓʉndɛlɨ. ");
INSERT INTO lik_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Mbɨya wanʉ, okwononi ɓɛ Yeso iki mbɛyɨ kʉgʉ wa lɨsyɛ aka kadwɛ ko ngbingo yi nɨnɔ Kunzi obiso ndɛkɛ mino masɨ ka ɓungbingbili. Katʉkya ka ɓʉndɛlɨ, Kunzi oɓikyoni ndɨ nɨlɔ pisi ka ɓogyalandʉ kakɨ ɓotu. ");
INSERT INTO lik_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","A ɓɛyɔ, Musa aɓɨkya ndɨ ɓɛ: ‹Mombukwono-donu Kunzi amʉtɨkɨlya ndɛkɛ mugyalandʉ abɛ ɨmɨ, opupa ndɛkɛ luga wa lɨvananza kunu. Ukonogoni ndɛkɛ masɨ nɨmɔ iko kamʉɓɨkya. ");
INSERT INTO lik_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Mʉtʉ yi nɨnɔ kikigʉ ndɛkɛ kamʉkana, ɓapupisa ndɛkɛ ka lɨvananza ko Kunzi, ɓamwɔ.› ");
INSERT INTO lik_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Katʉkya ko ngbingo ka Samueli, ɓogyalandʉ ɓasɨ na nɨɓɔ ɓa ndɨ kumbuso kaɓʉ, ɓanzɨnagatʉ ndɨ ko bulya nɨlɔ akaigyonoso ka masyɛ mi nɨma. ");
INSERT INTO lik_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Iɓunu ma ka ɨkɔngɔ ka ɓogyalandʉ na nɨɓɔ ɓa agʉmɛ nɨnɔ Kunzi agya ndɨ na ɓotitonu, kaɓɨkya Abalahamʉ ɓɛ: ‹Ɓopiga ɓaya ɔɓɨlɨ ɓayasɨ inisana ndɛkɛ na ɓʉɓʉnga pisi ka lɨvananza kakʉ.› ");
INSERT INTO lik_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Kinili, Kunzi atikoku mbɛyɨ ndɨ mʉgya-ligubo kakɨ ko bulya kunu, kyɛ amuɗukilyi ɓʉɓʉnga, anyɔgɔ mʉtʉ yɨkaka-yɨkaka luga kunu ka ɓʉnyɛ kakɨ.» ");
INSERT INTO lik_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pɛtɛlɛ na Yuani ɓa ndɨ kanzɨna kambwa ka ɓambanzʉ. Ko ngbingo yi nɨnɔ, ɓokumu, ngama ka ɓazamʉ ya Ndaɓʉ ko Kunzi na Ɓasadukayɔ ɓopuponoku ndɨ ɓɨwɛɛɛ. ");
INSERT INTO lik_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Mambɛngɨ a ndɨ kaʉtʉla kyɛ ɓatʉtʉmbwa ɓaɓa ɓi nɨɓɔ ɓa ndɨ kaʉpá ɓambanzʉ mʉtʉʉ na kaʉɓɨkya ɓɛ yɛkɨ Yeso opupa ndɨ ka mbʉkʉ, ɓatʉ nɨɓɔ ɓokwaga ndɨ, ɓopupa ndɛkɛ ɨɓʉ ɓɛgɛyɔ. ");
INSERT INTO lik_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ɓugwi kʉwa ndɨ, yɛkɨ a kʉwa ndɨ ɓʉgɔgɔ, ɓʉmakya ka bɔlɔkɔ kadwɛ na ɓʉgala ɓi. ");
INSERT INTO lik_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Luki limoti, ɓatʉ ɓudingi luga ka nɨɓɔ ɓʉkana ndɨ mʉtʉʉ, ɓabaɨlya ndɨ. Ɓa kʉwa ndɨ banda ɓɛlɔfʉ kuɓukumuti. ");
INSERT INTO lik_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ɓʉgala ɓi, ɓangama ka Ɓayuda, ɓambɔkʉ-mbɔkʉ na ɓowonisilo ɓa mʉtʉʉ ɓamʉmʉkana ndɨ ka Yelusalɛma. ");
INSERT INTO lik_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Kumu-kumu ɓɛyɔ ka Ana a ndɨ wa gɔ wa, Kayafa, Yuani, Alesandulia sɛ kʉwa ɓatʉ ɓasɨ ɓa lɨvananza ko kumu-kumu. ");
INSERT INTO lik_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ɓupupisoku ndɨ Pɛtɛlɛ na Yuani, ɓumomoso kambwa kaɓʉ, ɓumuusa ndɨ ɓɛ: «Ko ngu ka wanɨ ikanɨ ko lino ka wanɨ yɔ mogyi ɓi mino lɨkpʉmʉka li nɨlɔ?» ");
INSERT INTO lik_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Kʉwa wa, yɛkɨ Pɛtɛlɛ a ndɨ mutumo na Lɨmbɛngɨ-Lotu ɓɨɗɛ, usikisya ɓɛ: «Iɓunu ɓangama, sɛ kʉwa iɓunu ɓambɔkʉ-mbɔkʉ, ");
INSERT INTO lik_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","na lɨsyɛ li nɨlɨ, kika nɨ iɓusu ta ko ngbongu, a ko bulya ɓʉnza nɨɓɔ tagyilyi ɓi zɛgɛsɨ yi nɨmʉ na ɓɛyɔ ouki mino yi. ");
INSERT INTO lik_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Iɓunu na ɓomikya Ɓezaleli ɓasɨ wibonito sɛ ɓɨnza ambɛ kika nɨ alʉkʉ yi nɨmʉna omogi kambwa kunu mʉna a wapʉpʉ, a ko lino ka Yeso-Kilisito mʉtʉ wa Nazalɛtɨ. Ɨyɨ nɨnɔ mabangɨlaga ndɨ ka mʉsalaba, Kunzi apupisoku ka mbʉkʉ. ");
INSERT INTO lik_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ɨyɨ nɨnɔ Moɓiso Motu aɓɨkyaga ko bulya kakɨ ɓɛ: ‹Lɨtalʉ nɨlɔ iɓunu, ɓopipiko, mombimba ndɨ iitoni kʉwa lɨtalʉ la ɨzangɨya la muɓumbe.› ");
INSERT INTO lik_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Muhukuso kɛgʉ ka mʉtʉ wagɔgɔ gʉtʉgʉ ɓemoti aka, kyɛ kɛgʉ no lino gʉtʉgʉ limoti aka nɨlɔ ɓʉpá ɓambanzʉ kʉnʉ kusili wa mɔnɨ ɓɛ kyɛ ʉpɨ́ muhukuso.» ");
INSERT INTO lik_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ɓatʉ nɨɓɔ ɓamʉmʉkanaga ndɨ ka Basa-Yidingi ɓombomboya ndɨ kʉgbɛ, kaɨna ɓɛyɔ Pɛtɛlɛ na Yuani ɓa ndɨ mino kanzɨna nɨ ɓakɛgʉ na kʉɓangakʉ, kyɛ ɓumibagatʉ ndɨ ɓɛ ɓa ɓatʉ ɓa payaya na ɓakaɓyɛgʉ ndɨ ɨkɔlɔ. Ɓandʉnga kʉwa ndɨ ɓɛ ɓikaga ndɨ pa imoti na Yeso. ");
INSERT INTO lik_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Luki limoti, ɓatʉ ndɨ kamɨna alʉkʉ nɨnɔ ahʉka ndɨ wakamaga ɓuwobi na ɨɓʉ. Nɔkʉ ʉdɨka ndɨ ɓɨdɛ. ");
INSERT INTO lik_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ɓʉkpamya kʉwa ndɨ ɓɛ ɓopupi kunzi. Ɓapʉnga ndɨ kanzɨna luga kaɓʉ, ");
INSERT INTO lik_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","ɓanaɓɨkya ɓɛ: «Tʉgya sɛ ɓatʉ nɨɓana ɓʉnɨ? A ɓɨngbanganya ɓɛ ɓagyatʉ ndɨ lɨkpʉmʉka lɨmbanga, ɓatʉ ɓasɨ ɓa Yelusalɛma ɓakaiba, kɛgʉ na yanganya. ");
INSERT INTO lik_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Luki limoti, kɛgʉ ɓɨnza ɓɛ mongoni mi nɨmɔ isisilogi kawawa luga ka ɓambanzʉ. Tʉpakya nɛkɨ na ɗɨya ambɛ ɓakanzinilyonitɔgʉ ɓata mʉmbanzʉ gʉtʉgʉ ɓemoti aka ko lino ka Yeso.» ");
INSERT INTO lik_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Kumbuso yi, ɓʉmaka ɓata ndɨ, ɓʉgbɨtyaga ɓɨkpɔkpɔkpɔ ɓɛ ɓakonzinonitɔgʉ ɓata ikanɨ ɓakowonisilonitɔgʉ ko lino ka Yeso. ");
INSERT INTO lik_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Luki limoti, Pɛtɛlɛ na Yuani ɓusikisya ɓɛ: «Gʉtʉgʉ mbɛyɨ iɓunu aka, atʉ ngbingbili ko misa ko Kunzi kamʉɓanga iɓunu nɨ takɛgʉ kaɓanga Ɨyɨ? ");
INSERT INTO lik_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Kiko iɓusu aka, takakwananɨgʉ kaasa kanzɨna ko bulya lɨkpʉmʉka nɨlɔ tɨna ndɨ, tʉkana.» ");
INSERT INTO lik_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ɓatʉ ɓa Basa-Yidingi ɓʉnyakɨlya ɓata ndɨ, ɓʉsa. Ɓakɨnagʉ ndɨ pisi nɨyɔ ɓakwanana ndɨ mino kaugyogyiso ko bulya ka ɓambanzʉ. A ɓɛyɔ, ɓatʉ ɓasɨ ɓa ndɨ kabibiso Kunzi ka nɨlɔ akɨtaga ndɨ lɔ. ");
INSERT INTO lik_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Alʉkʉ yi nɨnɔ inisana ndɨ na muhukuso mʉmbanga nɔ, a ndɨ na ɓyanga kakɨtaga ɓatɛkɛɓɛ ɓakwanganya. ");
INSERT INTO lik_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Nɨyɔ ɓasisa Pɛtɛlɛ ɨɓʉ na Yuani, ɓɨnda kʉwa ndɨ kaʉtʉmbʉlyaga ɓawai-daɓʉ masɨ nɨmɔ ɓokumu-kumu na ɓambɔkʉ-mbɔkʉ ɓʉɓɨkya ndɨ. ");
INSERT INTO lik_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Nɨyɔ ɓʉkana ɓɛyɔ, ɓalʉmba ndɨ ɓasɨ na lɨmbɛngɨ limoti ɓɛ: «Ngamaaa, ɨwɛ nɔ wagya ndɨ lɨsyɛ, lɨtɔmbʉ, moɓo makpʉkpʉ na masɨ nɨmɔ a kʉsɔ yi. ");
INSERT INTO lik_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Pisi ka Lɨmbɛngɨ-Lotu, wanzinisa ndɨ titosu ɓɛyɔ ka Daudi, mʉgya-ligubo kakʉ ɓɛ: ‹Ko bulya ɨkɨ yɔ ɓɛvananza ɓo mino kavɨkɨmanaga? Ko bulya ɨkɨ yɔ ɓambanzʉ ɓo mino kagya ɓodikiɗi ɓaya payaya? ");
INSERT INTO lik_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ɓangama ɓa ɔɓɨlɨ ɓɨmbamba ndɨ ka lʉnga, Ɓatʉ ɓakpʉkpʉ ɓamʉmʉkana ndɨ kagyogyiso Mombukwono-dosu na kagyogyiso Masiya nɨnɔ apʉnaga ndɨ.› ");
INSERT INTO lik_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Iyo, a ɓɛyɔ, ngama Ɛlɔdɨ ɨɓʉ na Pɔsɔ Pilatʉ ɓamʉmʉkana ndɨ ka gʉɗʉ yi nɨnɔ, pa imoti na ɓɛvananza ɓayagɔgɔ na ɓomikya-Ɓezaleli. Ɓamʉmʉkana ndɨ kagyogyiso Yeso, mʉgya-ligubo kakʉ wotu, nɨnɔ wapʉnaga ndɨ ɓɛ iki Masiya. ");
INSERT INTO lik_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ɓagya ndɨ ɓɛyɔ kotulyoso nɨlɔ wosisilya ndɨ katʉkya ka ɓʉndɛlɨ, ko ngu na ka sɨpananɨsɔ kakʉ. ");
INSERT INTO lik_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Mombukwono-dosu, mbɨya wanʉ, wɨnanɔ ɓaka ɓɛyɔ ɓo mino katigyogyiso yi. Ʉpá ɓosunzu kakʉ ngu kaɓɨkyaga lɨkpʉmʉka kakʉ nɨ ɓakɛgʉ na kʉɓangakʉ. ");
INSERT INTO lik_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Nonokunɔ kʉɓɔkʉkɔ kakʉ ɓambanzʉ ɓahʉkɨ, ɓɨnɨ makpʉmʉka mʉmbanga-mbanga na mokingyosi ko lino ka mʉgya-ligubo kakʉ wotu ɓɛyɔ ka Yeso.» ");
INSERT INTO lik_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Nɨyɔ ɓama kalʉmba ɓɛyɔ, pa nɨyɔ ɓa ndɨ mino ɓʉmʉmʉkana yɔ ɨzʉkʉla ndɨ ɓingbwuku-ngbwuku. Ɨɓʉ ɓasɨ ɓotuma ndɨ na Lɨmbɛngɨ-Lotu, ɓapʉnga kaɓɨkyaga Mongoni ko Kunzi nɨ ɓakɛgʉ na kʉɓangakʉ. ");
INSERT INTO lik_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ambaza ka ɓatʉ nɨɓɔ ɓabaɨlya ndɨ ɓikaga ndɨ lɨmbɛngɨ limoti na mʉtamanagɨ mumoti. Kɛgʉ na mʉtʉ ɓemoti nɨnɔ aɓɨkyaga ndɨ ɓɛ mukumbo kakɨ a makakɨ ɓɨkpɛ. Luki limoti, ɓobisaga ndɨ masɨ pa yimoti ko bulya kaɓʉ. ");
INSERT INTO lik_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ɓatʉtʉmbwa ɓatʉmbʉlaga ndɨ no ngu yasɨ mongoni nɨmɔ Mombukwono-dosu Yeso opupa ndɨ mino ka mbʉkʉ. Kunzi uɗukilya ndɨ ɨɓʉ ɓasɨ ɓʉɓʉnga ɓudingi. ");
INSERT INTO lik_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Mʉtʉ wa yangya kikogigʉ ndɨ luga kaɓʉ. A ɓɛyɔ, nɨɓɔ ɓikaga ndɨ na ɓotiko ikanɨ ɓandaɓʉ ɓagabaga ndɨ, ɓodoku no ɓuyi ɓi ");
INSERT INTO lik_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ɓʉpá ɓatʉtʉmbwa. Ɨɓʉ ɓʉgbananɨlyaga kʉwa ndɨ kaɓyɛnɛnɛ na yangya ka mʉtʉ yɨkaka-yɨkaka. ");
INSERT INTO lik_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","A ndɨ na alʉkʉ ɓemoti ina ndɨ ɓɛ Yɛzɛfʉ, ɓatʉtʉmbwa ɓalʉka ndɨ ɓɛ Balanaba, isi yi ɓɛ «Nɨnɔ utumisaga ɓɛngɛnɨ mambɛngɨ». Alʉkʉ yi nɨnɔ a ndɨ Mulawi, mʉtʉ wa uzu ya Kipulo, ");
INSERT INTO lik_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","agaba ndɨ tiko kakɨ, aga ndɨ na ɓuyi ɓi, upóku ɓatʉtʉmbwa. ");
INSERT INTO lik_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Luki limoti, atʉ ndɨ na mʉtʉ ɓemoti nɨnɔ ina ndɨ ɓɛ Anania. Nɨyɔ ɓʉkanana na mukakɨ ɓɛyɔ ka Safila, ɓagaba ndɨ gɔnɨ tiko kaɓʉ. ");
INSERT INTO lik_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ɓʉkanana ndɨ na mukakɨ, asʉma ndɨ ɓuyi ɓagɔgɔ, ɨnda kʉwa ndɨ kaʉpá ɓatʉtʉmbwa nɨɓɔ otigala ndɨ. ");
INSERT INTO lik_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Kʉwa wa, Pɛtɛlɛ amuusa ndɨ ɓɛ: «Anania, ko bulya ɨkɨ yɔ abɨlɨ umingyi mino ɓɛyɔ kaɓɔ Lɨmbɛngɨ-Lotu, wasʉma ɓuyi ɓagɔgɔ nɨɓɔ wogobi ɓi mino tiko? ");
INSERT INTO lik_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Kambwa kagaba tiko, tiko yi nɨyɔ kɛgʉ ɓi ya kakʉ? Kumbuso kagabo yi, ɓuyi ɓi kɛgʉ ɓi gɔnɨ ɓa kakʉ? Ipungonogi mbɛyɨ na ɨwɛ ɓʉnɨ kagya ɓɛyɔ? Ɛɛɛ, wakuɓugʉ sɛ ɓambanzʉ, luki limoti, waɓu Kunzi!» ");
INSERT INTO lik_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Nɨyɔ aka yɔ Anania ʉkana ɓɛyɔ, ogwa ndɨ ɓingbiii, okwo wa aka wa. Ɓatʉ ɓasɨ nɨɓɔ ɓʉkana ndɨ mongoni mi nɨmɔ, ɓaɓanga ndɨ kʉgbɛ. ");
INSERT INTO lik_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ɓotugbo ɓodoku kʉwa ndɨ, ɓatikyogo, ɓabɨnɨka, ɓaga ndɨ kalumbo. ");
INSERT INTO lik_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Nɨyɔ agya abɛ saa yɨsaa ɓɛnɛ, mukakɨ osiloku ndɨ, nɨ kɛgʉ kaiba nɨlɔ okitonogi. ");
INSERT INTO lik_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pɛtɛlɛ aka ndɨ na ɨyɨ ɓɛ: «Ɨɓɨkya mbɛyɨ, ɓuyi ɓasɨ nɨɓɔ ogwi ɓi ko tiko nɨɓana aka ɓa?» Asikisya ndɨ ɓɛ: «Iyo, iɓu nɨɓɔ aka ɓɔ.» ");
INSERT INTO lik_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Kʉwa wa, Pɛtɛlɛ aɓɨkya ndɨ ɓɛ: «Mukononi pɨyɛ ɓi na mbʉnyakʉ ɓʉnɨ kakɨngɨlaga Lɨmbɛngɨ ka Mombukwono-dosu? Ʉkana, ɓatʉ nɨɓɔ ɓapʉnya kalumbo mbʉnyakʉ, ɓa mbɨya wanʉ ka mupumi wa, ɓakaaga na ɨwɛ ɓɛgɛyɔ.» ");
INSERT INTO lik_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ko ngbingo yi nɨnɔ aka nɔ, ogwo ka magʉ ka atʉtʉmbwa wa, okwa ndɨ. Ɓotugbo ɓogulyoku ndɨ, ɓatakanya nɨ odokini. Ɓaga ndɨ na ɨyɨ, ɓalumboku ka kpɔlɔ ka mbʉnyakɨ. ");
INSERT INTO lik_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Kʉwa wa, kanisa yasɨ na ɓatʉ ɓasɨ nɨɓɔ ɓʉkana ndɨ mongoni mi nɨmɔ, ɓaɓanga ndɨ kʉgbɛ. ");
INSERT INTO lik_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ɓatʉtʉmbwa ɓagyaga kʉwa ndɨ makpʉmʉka mʉmbanga-mbanga na mokingyosi makpʉ luga ka ɓambanzʉ. Ɓatʉ nɨɓɔ ɓabaya ndɨ ɓamʉmʉkanaga ndɨ ɓasɨ ka pa nɨyɔ ɓalɨkyaga ndɨ ɓɛ pa ya yɨgbʉka ka Sɔlɔmɔnɔ. ");
INSERT INTO lik_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Kɛgʉ ndɨ na mʉtʉ wodi nɨnɔ ɨkpʉndaga ndɨ kamatɨkana na ɨɓʉ. Wɨna sɛ, ɓambanzʉ ɓubibisaga ndɨ kʉgbɛ. ");
INSERT INTO lik_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ambaza ka ɓalʉkʉ na ɓoko nɨɓɔ ɓaɓɨnɨkyanaga ndɨ Mombukwono-dosu ikaga ndɨ kobwo, anɨmatɨla ka ɓatʉ ɓa baya. ");
INSERT INTO lik_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ɓʉbɨnɨkaga ndɨ ɓatʉ ɓa ɓokoloɓu ko ɓopisi, ɓumongoso ka ɓakʉlʉgbʉ ikanɨ ka ɓakalagba. Ɓagyaga ndɨ ɓɛyɔ kyɛ Pɛtɛlɛ kakɨtaga wa, mulundu kakɨ akwananɨ kaʉdʉnda mino ɓatʉ ɓemoti-ɓemoti luga kaɓʉ. ");
INSERT INTO lik_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ambaza ka ɓambanzʉ odogokuto ndɨ gɔnɨ kotukyoku ka ɓagʉɗʉ nɨɓɔ ɓuwobi na Yelusalɛma. Ɓodogoku ndɨ na ɓatʉ ɓa ɓokoloɓu na nɨɓɔ ɓa mambɛngɨ ma ɓʉnyɛ. Ɨɓʉ ɓasɨ ɓahʉkagatʉ ndɨ. ");
INSERT INTO lik_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Kʉwa wa, Kumu-Kumu pa imoti na ɓatʉ ɓasɨ nɨɓɔ ɓikaga ndɨ na ɨɓʉ, isi yi ɓɛ liɗu ka Ɓasadukayɔ, ɓʉmɨnɨlya ndɨ ɓatʉtʉmbwa imi. ");
INSERT INTO lik_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ɓugwi, ɓʉmakya ndɨ ka bɔlɔkɔ yidingi. ");
INSERT INTO lik_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Luki limoti, no biti malaika ɓemoti ka Mombukwono-dosu oukwa ndɨ pumi ya bɔlɔkɔ, upupisoku, ʉɓɨkya ɓɛ: ");
INSERT INTO lik_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Wogoni ka Ndaɓʉ ko Kunzi, mʉɓɨkyaga ɓambanzʉ lɨkpʉmʉka lasɨ nɨlɔ la ɔɓɨlɨ wambɨya.» ");
INSERT INTO lik_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Nɨyɔ ɓatʉtʉmbwa ɓʉkana ɓɛyɔ, ɓagya ndɨ ɓɛyɔ aka yɔ. Ɓopupya ndɨ ɓiɓo ka Ndaɓʉ ko Kunzi, ɓapʉnga kapá mʉtʉʉ. Kumu-Kumu na ɓatʉ nɨɓɔ ɓa ndɨ na ɨɓʉ, ɓʉmʉmʉla ndɨ ɓambɔkʉ-mbɔkʉ ɓasɨ ka Ɓayuda ka mʉnzɨna ka Basa-Yidingi. Ɓʉtɨka kʉwa ndɨ ɓambanzʉ kaumokoku ɓatʉtʉmbwa ka bɔlɔkɔ. ");
INSERT INTO lik_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Luki limoti, nɨyɔ ɓatʉ ɓi nɨɓɔ ɓosilo kʉ ɓɛyɔ, ɓakʉtakanyagʉ ndɨ ɓata ɓatʉtʉmbwa. Ɓigoku ndɨ kaʉpága mongoni mi nɨma: ");
INSERT INTO lik_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","«Totokonyi pumi ya bɔlɔkɔ yɨdʉlaga ɓɨnza ɓɨkpwɔkpwɔkpwɔ. Ɓazamʉ ɓo ɓi ka pa kaɓʉ aka kambwa wo pumi. Luki limoti, nɨyɔ toukwi mupumi, takatokonyigʉ mʉmbanzʉ gʉtʉgʉ ɓemoti aka.» ");
INSERT INTO lik_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Nɨyɔ ngama ka ɓazamʉ ɓa Ndaɓʉ ko Kunzi na ɓokumu-kumu ɓʉkana ɓɛyɔ, ɓamama ndɨ ɓɨgbagbagba, ɓanimuuso ɓɛ isilyoku sɛ kʉwa ɓʉ. ");
INSERT INTO lik_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Kʉwa wa, mʉtʉ ɓemoti upuponilyoku ndɨ ɓɨwɛɛɛ, ʉɓɨkya ɓɛ: «Ɓatʉ nɨɓɔ mugwi ɓi ɓa sɛ kaʉpá ɓambanzʉ mʉtʉʉ ka Ndaɓʉ ko Kunzi kʉ.» ");
INSERT INTO lik_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Kumbuso yi, ngama ka ɓazamʉ na ɓatʉ kakɨ ɓɨnda ndɨ kaugwi. Ɓodoku na ɨɓʉ, luki limoti, ɓakʉgya ndɨ na ɓou kyɛ ɓa ndɨ kaɨɓangɨlya ɓɛ ɓambanzʉ ɓakubumonitɔgʉ na matamʉ. ");
INSERT INTO lik_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Nɨyɔ ɓosiloku ndɨ na ɨɓʉ, ɓumomoso kambwa wa Basa-Yidingi. Kʉwa wa, Kumu-Kumu apʉnga ndɨ kausombiso, ");
INSERT INTO lik_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","ɨyɨ aka na ɨɓʉ ɓɛ: «Takamupokyigʉ mbɛyɨ ɓi kapá mʉtʉʉ ko lino ka mʉtʉ yi nɨnɔ? Mʉtʉʉ kunu itulyonini ka Yelusalɛma wasɨ. Makapa katigboɗyo molingo ma ndʉga ka mʉnɔkʉ ko bulya kukwakʉ kakɨ!» ");
INSERT INTO lik_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pɛtɛlɛ na ɓatʉtʉmbwa ɓagɔgɔ ɓosikisya ndɨ ɓɛ: «Okwononi kaɓanga Kunzi nɨ kɛgʉ kaʉɓanga ɓambanzʉ aka. ");
INSERT INTO lik_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Mabangɨlaga ndɨ Yeso ka mʉsalaba, mamwɔ. Luki limoti, Kunzi nɨnɔ ka ɓotitosu apupisoku ndɨ ka mbʉkʉ. ");
INSERT INTO lik_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Kunzi aɗokisa ndɨ kʉgʉ, alikiso ka kʉmbanzɨkanɨkɔ kakɨ, abisa ndɨ Ngama na Muhukuso kyɛ Ɓezaleli ɓoyikoni, Kunzi ʉpɨlya ɓʉnyɛ kaɓʉ. ");
INSERT INTO lik_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Iɓusu, ta ɓadɛmʉ ɓa lɨkpʉmʉka li nɨlɔ, pa imoti na Lɨmbɛngɨ-Lotu nɨlɔ Kunzi ʉpá ɓatʉ ɓi nɨɓɔ ɓaɓangaga.» ");
INSERT INTO lik_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Nɨyɔ ɓatʉ ɓa Basa-Yidingi ɓʉmʉkana mino ɓɛyɔ, miso ʉtana ndɨ ɓɨngbʉ, ɓa ndɨ kapa kaʉma ɓatʉtʉmbwa. ");
INSERT INTO lik_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Luki limoti, luga kaɓʉ wa, a ndɨ na Mufalisayɔ ɓemoti nɨnɔ ina ndɨ ɓɛ Gamalieli, muwonisilo wa mʉtʉʉ ka Musa. Ɓambanzʉ ɓasɨ ɓaɓangaga ndɨ kʉgbɛ. Amaga ndɨ luga kaɓʉ, aɓɨkya ɓɛ ɓupupisi mbɛyɨ ɓatʉtʉmbwa kunzi. ");
INSERT INTO lik_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Kumbuso yi, aɓɨkya ɓɛ: «Iɓunu Ɓezaleli, wiminyonito ka nɨlɔ makapa kagya ko bulya ka ɓatʉ ɓi nɨɓa. ");
INSERT INTO lik_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Kanokitogigʉ masyɛ makpʉ wa Teuda ipupisa ndʉkʉ mino. Ɨyɨ, ɨmɨnaga ɓi abɛ kika mʉtʉ mudingi, ɓambanzʉ banda ɓamɨya ɓakwanganya ɓaɓɨɓyaga ndʉkʉ ɓingbooo. Luki limoti, ɓamwoni ndʉkʉ, ɓaɓɨɓya kakɨ ɓasɨ ɓomisikono ɓingbwi, gʉtʉgʉ ɓemoti aka kasɨkanagʉ ndʉkʉ. ");
INSERT INTO lik_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Kumbusa kakɨ, Yuda nɨnɔ mʉtʉ wa Galilaya ipupisoku ɓi ɓɛgɛyɔ, wa ɓa ndʉkʉ mino kaʉtanga ɓambanzʉ. Ɨyɨ, uluta ndɨ ɓambanzʉ ɓakpʉ kaɓɨɓya. Luki limoti, ɓamwɔ ndʉkʉ gɔnɨ, ɓaɓɨɓya kakɨ ɓasɨ ɓomisikono. ");
INSERT INTO lik_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Mbɨya wanʉ, na nɛkɨ kamʉɓɨkya ambɛ tumboni tamanaga kunu ka ɓatʉ ɓi nɨɓa, musiso. Kiko lɨkpʉmʉka ka ɓambanzʉ, osyatʉ. ");
INSERT INTO lik_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Luki limoti, kika nɨ akotukyoku ko Kunzi, makakwananɨgʉ kakpɨngba. Ɛɛɛ, wiminyonito sɛ, makulonononito no Kunzi!» Ɓatʉ ɓa Basa-Yidingi ɓabaɨlya ndɨ mʉnzɨna ka Gamalieli. ");
INSERT INTO lik_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ɓʉmaka kʉwa ndɨ ɓatʉtʉmbwa, ɓutinisiso fimbo, ɓʉgbɨtyaga ɓɛ ɓakoɓikyonitɔgʉ ɓata lɨkpʉmʉka ko lino ka Yeso. Kumbuso yi, ɓusisa ndɨ. ");
INSERT INTO lik_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Kʉwa wa, ɓatʉtʉmbwa ɓopupa ndɨ ka Basa-Yidingi. Ɓa ndɨ ɓutumo na magyagya ɓɨɗɛ, kyɛ Kunzi ɨna ndɨ ɓɨnza ɓɛ ɓigyogyisi ko bulya lino ka Yeso. ");
INSERT INTO lik_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Masyɛ masɨ, ka Ndaɓʉ ko Kunzi na ka ɓandaɓʉ ɓayagɔgɔ dididi, ɓisisilaga ndɨ kaɓɨkyaga Mongoni Manza ka Yeso ɓɛ ɨyɨ nɨ Masiya. ");
INSERT INTO lik_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ka masyɛ mi nɨmɔ, yɛkɨ ɓaɓɨɓya ɓa ndɨ kobwo kʉgbɛ, Ɓayuda nɨɓɔ ɓanzɨnaga Ligiliki ɓapʉnga ndɨ kaɨgama na nɨɓɔ ɓanzɨnaga Libelenia, ɓanaɓɨkya ɓɛ masyɛ masɨ, ngbingo mʉgbananaga malɨlɨ, ɓakʉpágɨgʉ ɓowoko kaɓʉ malɨlɨ ɓɨnza. ");
INSERT INTO lik_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Kʉwa wa, ɓatʉtʉmbwa tɛkɛɓɛ na ɓaɓa ɓʉmʉmʉla ndɨ ɓaɓɨɓya ɓagɔgɔ ɓasɨ, ɓʉɓɨkya ɓɛ: «Kokwononigʉ ɓɛ tasɨ kaɓɨkyaga Mongoni Manza ko bulya yɨgbananaga malɨlɨ. ");
INSERT INTO lik_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Kinili, ɓomika-mama, hupunogoni ɓambanzʉ maɗɨya na ɨka luga kunu nɨɓɔ ɓa yɨgya yanza, ɓutumo na Lɨmbɛngɨ-Lotu na yimibo. Tʉpá ɨɓʉ ligubo li nɨlɔ. ");
INSERT INTO lik_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Iɓusu, togulyonogo malʉmba na kaɓɨkyaga Mongoni Manza.» ");
INSERT INTO lik_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Lɨkpʉmʉka lɔ uɓosa ndɨ ɓatʉ ɓasɨ. Ɓʉpʉnaga kʉwa ndɨ ɓatʉ ɓi nɨɓa: Etieni, mʉtʉ wa baya yidingi na mutumo na Lɨmbɛngɨ-Lotu, Filipi, Pɔlɔkɔlɔ, Nikanɔlɔ, Timoni, Palamɛna sɛ kʉwa Nɨkʉla, mʉtʉ wa Atiokia nɨnɔ abaya ndɨ ka kanisa ka Ɓayuda. ");
INSERT INTO lik_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Kumbuso yi, ɓodoku ndɨ na ɨɓʉ kambwa ka ɓatʉtʉmbwa, ɓubisilya maɓɔkʉ, ɓʉlʉmbɨlya. ");
INSERT INTO lik_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Mongoni Manza ko Kunzi a kʉwa ndɨ ka isisilogo aka. Ka Yelusalɛma, ɓaɓɨɓya ɓobwa ndɨ ɓakpʉ na ɓokumu ɓudingi ɓaɓɨnɨkyana ndɨ Yeso. ");
INSERT INTO lik_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Etieni nɨnɔ Kunzi aɗukilya ndɨ ɓʉɓʉnga, atumiso no ngu, agyaga ndɨ makpʉmʉka mʉmbanga-mbanga na mokingyosi makpʉkpʉ luga ka ɓambanzʉ. ");
INSERT INTO lik_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Kʉwa wa, ɓatʉ ɓagɔgɔ ɓapʉnga ndɨ ɓoɗongoso na Etieni. Ɓatʉ ɓi nɨɓɔ ɓa ndɨ ɓatʉ ɓa ndaɓʉ ya malʉmba nɨyɔ ɓalɨkyaga ndɨ ɓɛ «Ɓosunzu ɓʉkʉlɨkanaga.» A ndɨ Ɓayuda ɓa gʉɗʉ wa Kulɛnɛ, nɨyɔ ya Alesandulia, sɛ kʉwa nɨɓɔ ɓa iwili ya Kilikia na nɨyɔ ya Azia. Ɨɓʉ ɓɔ ɓa ndɨ kobiso ɓoɗongoso na Etieni, ");
INSERT INTO lik_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","luki limoti, ɓakakwananagʉ ndɨ kakɨtaga kyɛ a ndɨ kanzɨna na yimibo nɨyɔ Lɨmbɛngɨ-Lotu apága ndɨ. ");
INSERT INTO lik_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Kʉwa wa, ɓʉkalyaga ndɨ ɓambanzʉ kyɛ ɓaɓɨkyɨ ɓɛ: «Tamukoni ɓi nɨ anatʉmbwa Musa no Kunzi.» ");
INSERT INTO lik_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ɓuvikimosaga ndɨ ɓambanzʉ, ɓambɔkʉ-mbɔkʉ na ɓowonisilo ɓa mʉtʉʉ. Kʉwa wa, ɓodoku ndɨ kagwi Etieni, ɓaga na ɨyɨ ka Basa-Yidingi. ");
INSERT INTO lik_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ɓodokuto ndɨ gɔnɨ na ɓadɛmʉ ɓa ɓɔngɔ nɨɓɔ ɓa ndɨ kaɓɨkya ɓɛ: «Alʉkʉ mʉna kɛgʉ kaɨga kumbuso na mʉnzɨna manyɛnyɛ ko bulya ndaɓʉ yotu ko Kunzi na ko bulya mʉtʉʉ ka Musa! ");
INSERT INTO lik_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","A ɓɛyɔ, tamukonito ɓi nɨ anaɓɨkya ɓɛ Yeso yi nɨnɔ mʉtʉ wa Nazalɛtɨ apanza ɓanʉ Ndaɓʉ ko Kunzi yi nɨyɨna, ogomosyono yɨgya nɨyɔ Musa atɨsɨlya ndɨ.» ");
INSERT INTO lik_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ɓatʉ ɓasɨ nɨɓɔ ɓa ndɨ ka Basa-Yidingi ɓa ndɨ kanda Etieni ɓɨngbangbangba. Ɓɨna ndɨ miso kakɨ mʉɗɔngɔnɨ abɛ nɨmɔ ka malaika. ");
INSERT INTO lik_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Kʉwa wa, kumu-kumu amuusa ndɨ Etieni ɓɛ: «A lɨngʉnʉ nɨlɔ ɓakaɓɨkya ko bulya kakʉ?» ");
INSERT INTO lik_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Etieni asikisya ndɨ ɓɛ: «Iɓunu ɓomika-mamaaa na iɓunu ɓababaaa, imukononito ɓɨnza! Kunzi nɨnɔ wa ɨbɨba apuponilyatʉ ndɨ titosu Abalahamʉ ngbingo yi nɨnɔ a mbɛyɨ ndɨ mino ka mugi ma Mezopotamia, kambwa kaiko ka mugi ma Alani. ");
INSERT INTO lik_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Aɓɨkya ndɨ ɓɛ: ‹Tʉkya ku kunu, ka lɨvananza kakʉ, waga ka mugi nɨmɔ nakaʉwanya.› ");
INSERT INTO lik_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Kʉwa wa, Abalahamʉ atʉkya ndɨ ka mugi ka Ɓakalidea, ɨnda ndɨ kaiko ka Alani. Kʉ ɓɛyɔ, abakɨ okwa ndɨ. Kumbuso yi, Kunzi atumboku ndɨ kʉ, adukusoku ka mugi mi nɨma mo mino mbɨya wanʉ. ");
INSERT INTO lik_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Kʉ ɓɛyɔ, Kunzi kapágʉ ndɨ gʉtʉgʉ mugi aka ɨkanɨ mikya pa mʉkɛɗɛ kaɗɨta lɨsɔkʉ. Luki limoti, awanyaga ndɨ ɓɛ apátʉ mugi mi nɨma, na ka ɓomiko-mikakɨ. Wɨna sɛ, ko ngbingo yi nɨnɔ, Abalahamʉ kɛgʉ ndɨ no miki. ");
INSERT INTO lik_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Kunzi aɓɨkya ndɨ ɓɛ: ‹Lɨvananza kakʉ ika ndɛkɛ ka mugi ka ɓatʉ ɓagɔgɔ. Kʉ ɓɛyɔ, ɓuitisa ndɛkɛ ɓosunzu, ɓugyogyisa ndɛkɛ ka ɓyanga ɓamɨya ɓakwanganya.› ");
INSERT INTO lik_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Luki limoti, Kunzi aɓɨkya ndɨ gɔnɨ ɓɛ: ‹Ɨmɨ, nakɔtʉ ndɛkɛ mʉkɔmbʉ ka ɓatʉ ɓa mugi mi nɨmɔ ɓika ndɛkɛ nɨ ɓuitisini ɓosunzu. Kʉwa wa, nupupisatʉ ndɛkɛ, ɓodoku kebibiso ka pa yi nɨyɨ.› ");
INSERT INTO lik_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Kumbuso yi, Kunzi ɓʉkanana ndɨ na Abalahamʉ. Yʉkanana yi a ndɨ pisi ka sɨmʉɨsɔ. Kinili, Abalahamʉ akusisa ndɨ mikakɨ ɓɛyɔ ka Isaka kumbusa wa masyɛ ɓʉgɨna ma yɨɓʉkʉta kakɨ. Isaka agya ndɨ ɓɛgɛyɔ na nɨnɔ kakɨ ɓɛyɔ ka Yakɔbɔ. Yakɔbɔ agya ndɨ ɓɛgɛyɔ na ɓotitosu tɛkɛɓɛ na ɓaɓa. ");
INSERT INTO lik_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Titosu ɓikaga ndɨ no miso mopi na mamaɓʉ ɓɛyɔ ka Yɛzɛfʉ. Ɓagaba ndɨ ka ɓusunzu ka Misili. Luki limoti, Kunzi a ndɨ pa imoti na ɨyɨ, ");
INSERT INTO lik_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","anyɔgɔ ndɨ ka yigyogyiso kakɨ yasɨ. Apá ndɨ ɨzɨyɔ na yimibo kanzɨna kambwa ka Falaɔ. Ngama amomosa ndɨ kaanda mugi ma Misili na kaamalya ndaɓʉ kakɨ yasɨ. ");
INSERT INTO lik_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Luki limoti, ayʉndɨ ogulya ndɨ ka mugi masɨ ma Misili na nɨmɔ ma Kanana. Kumbu yidingi, ɓotitosu ɓakɛgʉ ndɨ na malɨlɨ. ");
INSERT INTO lik_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Yakɔbɔ ʉkana ndɨ ɓɛ malɨlɨ a ka Misili, ʉtɨka mbɛyɨ ndɨ ɓotitosu ka nganga ya mambwa. ");
INSERT INTO lik_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ka nganga ya yɨɓa, Yɛzɛfʉ imibisikoso na ɓamamakɨ. Kʉwa wa, Ngama Falaɔ iba ndɨ litino ka Yɛzɛfʉ. ");
INSERT INTO lik_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Kumbuso yi, Yɛzɛfʉ ʉtɨka ndɨ ɓambanzʉ kavoku abakɨ ɓɛyɔ ka Yakɔbɔ na lɨvananza kakɨ lasɨ. Ɓatʉ ɓasɨ ɓa ndɨ ɓatɛkɛɓɛ maɗɨya na ɨka na kuɓukumuti. ");
INSERT INTO lik_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yakɔbɔ ɨnda ndɨ ka Misili, okwa ndɨ kʉ ɓɛyɔ, gʉtʉgʉ ɓotitosu aka. ");
INSERT INTO lik_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ɓabɨnɨka ndɨ ɓamanda kaɓʉ ka Sekemu, ɓolumboku ka pa ya ɓambʉkʉ nɨyɔ Abalahamʉ oluwa ndɨ no ɓuyi ka maɓɔkʉ ka ɓomika Hamoli ka iwili ya Sekemu. ");
INSERT INTO lik_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Yɛkɨ masyɛ nɨmɔ Kunzi awanyaga ndɨ Abalahamʉ kapá mino agʉmɛ a kʉwa ndɨ ɓuwobi kaɨtʉlyana, ɓambanzʉ ɓɨtʉndaga ndɨ, ɓobwo ɓakpʉ kʉ ka Misili. ");
INSERT INTO lik_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Kumbuso yi, ngama mudingi wagɔgɔ alya ndɨ ɓʉngama ka Misili. Ɨyɨ ngama yi nɨnɔ kamibagʉ ndɨ Yɛzɛfʉ. ");
INSERT INTO lik_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Aɓɔ ndɨ lɨvananza kusu, ʉgyagya ɓotitosu, ʉpá ndɨ mʉtʉʉ mapʉ ɓɛ ɓumbimbogi ɓomikaɓʉ nɨɓɔ ɓawɛsɛ kyɛ ɓokwogi. ");
INSERT INTO lik_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Musa ɨɓʉkʉta ndɨ ko ngbingo yi nɨnɔ, a ndɨ miki wanza ko misa ko Kunzi. Ɓakwisa ndɨ ka ɓatɨmba ɓasaa aka ka ndaɓʉ ka abakɨ. ");
INSERT INTO lik_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ngbingo yi nɨnɔ ɓabisoku ndɨ mino ɓɨkɛɗɛ, mika Ngama Falaɔ muko yi ɨvɨlya ndɨ, ikwisilyo abɛ mikakɨ mʉɓʉkʉta. ");
INSERT INTO lik_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Kʉwa wa, ɓawonisila ndɨ Musa yimibo yasɨ ka Ɓamisili, ɨɨta mʉtʉ wa kibo mʉnzɨna na mogubo dididi. ");
INSERT INTO lik_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Nɨyɔ otulyoso ɓyanga ɓatɛkɛɓɛ ɓakwanganya, ɨkandaga ndɨ kaɨnda kaʉndoku ɓamamakɨ ɓɛyɔ ka ɓomikya Ɓezaleli. ");
INSERT INTO lik_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Kʉ ɓɛyɔ, amɨna ndɨ Mumisili ɓemoti nɨ anagyogyiso mʉva-kʉkakɨ. Asingyoku ndɨ alʉkʉ nɔ ɓa ndɨ kagyagya nɔ, igiso likosi, amwɔ Mumisili. ");
INSERT INTO lik_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Musa a ndɨ kasɨma ɓɛ ɓamamakɨ ɓakwanana ndɨ kaiba ɓɛ Kunzi apʉnaga ndɨ ɨyɨ kauhukuso. Luki limoti, ɓakotombisyagʉ ndɨ. ");
INSERT INTO lik_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ɓʉgala ɓi, upuponilya ndɨ Ɓezaleli ɓaɓa nɨ ɓanabʉmana. Akɨsa ndɨ kaʉgbʉmaga, ʉɓɨkya ɓɛ: ‹Ɓawai, ma ɓatʉ ɓemoti, ko bulya ɨkɨ yɔ mo mino kabʉmana?› ");
INSERT INTO lik_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Luki limoti, nɨnɔ a ndɨ kagyogyiso ɓɛngɛnɨ, atindika ndɨ Musa, amuusa ɓɛ: ‹Wanɨ nɔ utwi ngama na kaiko zozi kusu? ");
INSERT INTO lik_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Wakapa kɛmwɔ mʉɗɔngɔnɨ ɓɛyɔ wamwi ɓi mino Mumisili isyeiku ɓi?› ");
INSERT INTO lik_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Nɨyɔ Musa ʉkana ɓɛyɔ, apɨkɨta ndɨ wa, ɨnda kaiko ka mugi nɨmɔ ina ɓɛ Madiani. Kʉ ɓɛyɔ, ʉɓʉkʉta ndɨ ɓomiki ɓaɓa. ");
INSERT INTO lik_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Kumbusa wa ɓyanga ɓatɛkɛɓɛ ɓakwanganya, malaika apuponilya ndɨ Musa ka gbɔgɔ nɨyɔ a ndɨ kagbʉndɨkana ka ɨsa ka ngʉpa ya Sinai. ");
INSERT INTO lik_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Nɨyɔ Musa ɨna lɨkpʉmʉka nɨlɔ, ombombaya ndɨ kʉgbɛ. Ngbingo yi nɨnɔ a ndɨ mino kaisisilo ɓɛkyɛ ɨnɨ ɓɨnza, ʉkana ndɨ lɨyʉ ka Mombukwono-dosu anaɓɨkya ɓɛ: ");
INSERT INTO lik_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‹Ɨmɨ nɨ Kunzi ka ɓatɨtakʉ, Kunzi ka Abalahamʉ, ka Isaka na ka Yakɔbɔ.› Nzʉyɨ atwa ndɨ Musa ɓɨkyakyakya nɨ kikpundigʉ ɓata kaɨkwɛ kʉ. ");
INSERT INTO lik_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Mombukwono-dosu aka na ɨyɨ ɓɛ: ‹Wɨnyɔgɔ ɓɛkpakʉ, kyɛ pa yi nɨyɔ wo mino wakamaga yɔ, a pa yotu. ");
INSERT INTO lik_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ninini ɓɛyɔ ɓo mino kaugyogyiso ɓatʉ kamɨ ka Misili. Nukonini mʉgamʉ kaɓʉ, ɨmɨ nosyiku kaʉkʉlaga. Doku mbɨya wanʉ, nakaʉtɨka ka Misili.› ");
INSERT INTO lik_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Musa yi nɨnɔ Ɓezaleli ɓamanganya ndɨ, ɓamuusa ɓɛ: ‹Wanɨ nɔ utwi ngama na kaiko zozi?› Ɨyɨ kʉwa nɔ Kunzi atɨka ndɨ kaiko ngama na kaʉkʉlaga pisi ka malaika yi nɨnɔ apuponilya ndɨ ka gbɔgɔ. ");
INSERT INTO lik_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Musa nɔ upupisoku ndɨ ɓomikya Ɓezaleli ka Misili. Agya ndɨ makpʉmʉka mʉmbanga-mbanga na nɨmɔ muɓongiso ka Misili, ko liɓo la liniko lidingi nɨlɔ ɓalɨkyaga ɓɛ liɓo Langbʉ na ka ɨsa ka ɓyanga ɓatɛkɛɓɛ ɓakwanganya. ");
INSERT INTO lik_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Musa yi nɨnɔ gɔnɨ nɔ ʉɓɨkya ndɨ ɓomikya Ɓezaleli ɓɛ: ‹Kunzi amʉtɨkɨlyatʉ ndɛkɛ mugyalandʉ abɛ ɨmɨ, iko mʉva-kukunu.› ");
INSERT INTO lik_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ngbingo yi nɨnɔ ɓomikya Ɓezaleli ɓamʉmʉkana ndɨ mino ka ɨsa, Musa a ndɨ wa pa imoti na ɓotitosu. Malaika anzɨnaga ndɨ na ɨyɨ kʉgʉ wa ngʉpa ya Sinai, apá kʉwa ndɨ mʉnzɨna ma ɔɓɨlɨ nɨmɔ atikitisyaga ndɨ iɓusu. ");
INSERT INTO lik_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Luki limoti, ɓotitosu ɓakapagɨgʉ ndɨ kamʉkana, ɓamʉya ndɨ ɓɨkanganga, ɓa ndɨ kapa kaɨga ɓata ka Misili. ");
INSERT INTO lik_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ɓaɓɨkya ndɨ Aluni ɓɛ: ‹Tɨgyɨlya ɓokunzi nɨɓɔ ɓakwanana katikpokyoniso. A ɓɛyɔ, Musa yi nɨmʉ nɔ atipupisiku ɓi ka Misili, takɛgʉ kaiba ɓɛ ɨkɨ yɔ agyi ɓi.› ");
INSERT INTO lik_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ka masyɛ mi nɨmɔ aka mɔ, ɓɨgyɨlya ndɨ mulundu ko mikya ngɔmbɛ, ɓapá ndɨ mulundu ma mikya ngɔmbɛ yi nɨnɔ ɓapɛpɛ. Ɓalisisa ndɨ dumo ko luki li nɨlɔ ɨɓʉ ɓamombukwana-daɓʉ ɓagya ndɨ lɔ. ");
INSERT INTO lik_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Kʉwa wa, Kunzi ʉpá ndɨ mʉgɔngʉ, ʉsa ɓɛ ɓiki kobibiso mangʉtʉ, mʉɗɔngɔnɨ ɓɛyɔ ikpikaga ndɨ mino ka kɨtaɓʉ ka ɓogyalandʉ ɓɛ: ‹Iɓunu Ɓezaleli, ɨmɨ nɔ mɛpá ndɨ apɛpɛ wa ɓanyama na ɓapɛpɛ ɓagɔgɔ ka ɓyanga ɓatɛkɛɓɛ ɓakwanganya ka ɨsa? ");
INSERT INTO lik_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Iɓunu mabɨnɨkaga ndɨ ɓangbangba ko kunzi kunu ɓɛyɔ ka Moloki na lɨngʉtʉ ko kunzi kunu ɓɛyɔ ka Lefani. Mɨgyɨlya ndɨ lundu yi nɨyɔ ɓɛkyɛ miki kobibiso. Kinili, namuhokiso ndɛkɛ ɓyɨ kakɨtaga mugi ma Babiloni.› ");
INSERT INTO lik_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Kʉ ka ɨsa, ɓotitosu ɓa ndɨ na ngbangba nɨyɔ ikaga ndɨ na kpokoyo wa agʉmɛ. Musa opika ndɨ ngbangba yi nɨyɔ mʉɗɔngɔnɨ ɓɛyɔ Kunzi akpamya ndɨ mino, agya ndɨ ka likingyosi li nɨlɔ ɨna ndɨ. ");
INSERT INTO lik_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Kumbuso yi, ɓʉpá kʉwa ndɨ ɓomika ɓotitosu ngbangba yi nɨyɔ. Ɨɓʉ ɓabɨnɨka ndɨ ngbingo yi nɨnɔ Yɔsʉa a ndɨ mino ngama kaɓʉ. Ɓɨnda ndɨ gɔnɨ na iyu ka mugi ka ɓatʉ ɓi nɨɓɔ Kunzi ukpumya ndɨ kambwa kaɓʉ. Ngbangba yi nɨyɔ ikaga ndɨ kʉ ɓɛyɔ kadwɛ ko ngbingo ka ngama Daudi. ");
INSERT INTO lik_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Daudi inisana ndɨ na ɨzɨyɔ ko misa ko Kunzi, aɓɨkya ndɨ ɓɛ akapikilyo Kunzi ka Yakɔbɔ ndaɓʉ. ");
INSERT INTO lik_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Luki limoti, Sɔlɔmɔnɔ kʉwa nɔ opika ndɨ. ");
INSERT INTO lik_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Luki limoti, Kunzi nɨnɔ Kʉgʉ-Kʉgbɛ kikogigʉ ka ɓandaɓʉ nɨɓayɔ ɓambanzʉ ɓopikogo. Mʉɗɔngɔnɨ ɓɛyɔ mugyalandʉ aɓɨkya ndɨ mino ɓɛ: ");
INSERT INTO lik_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‹Mombukwono-dosu akaɓɨkya ɓɛ, kʉgʉ wa lɨsyɛ a kiti wa ɓʉngama kamɨ, na lɨtɔmbʉ a pa kamɨ ya kibiso magʉ. Makepikilyo inguo ya ndaɓʉ tino? Pa kamɨ ya kimumbiso ika ndɛkɛ yanɨ? ");
INSERT INTO lik_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Kɛgʉ mbɛyɨ ɨmɨ nɔ nagya makpʉmʉka masɨ mi nɨma?› ");
INSERT INTO lik_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Eze iɓunu ɓatʉ ɓa mʉ mapʉaaa! Mambɛngɨ ɓingbongili, nɨ makɛgʉ kaʉkana. Mikaga kobiso ɓoɗongoso na Lɨmbɛngɨ-Lotu ɓongbinga ɓasɨ mʉɗɔngɔnɨ abɛ ɓotitonu ndɨ gɔnɨ! ");
INSERT INTO lik_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Mugyalandʉ tino pɨyɛ nɔ ɓotitonu ɓakagyogyisagʉ ndɨ? Ɓulumwisaga ndɨ nɨɓɔ ɓa ndɨ kaɓɨkyaga ɓɛ Mʉtʉ Wongbingbili odokuto ndɛkɛ. Mbɨya wanʉ, masutini ɓi, mamwɔ. ");
INSERT INTO lik_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","A ɓɛyɔ, minisana ndɨ na mʉtʉʉ ko Kunzi pisi ka ɓamalaika. Luki limoti, nɨ makoɓuulyogigʉ.» ");
INSERT INTO lik_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Nɨyɔ ɓatʉ ɓi nɨɓɔ ɓa ndɨ ka Basa-Yidingi ɓʉkana mʉnzɨna mi nɨmɔ, miso ʉtana ndɨ ɓɨngbʉ na Etieni, ɓɨlya manzʉ ɓɨkyalʉkyalʉ. ");
INSERT INTO lik_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Luki limoti, Etieni a ndɨ mutumo na Lɨmbɛngɨ-Lotu. Ɨkwɛ ndɨ kʉgʉ wa lɨsyɛ, ɨna ɨbɨba ko Kunzi, na Yeso wakamaga ka kʉmbanzɨkanikɔ ko Kunzi. ");
INSERT INTO lik_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ɨyɨ aka ndɨ ɓɛ: «Nakaɨna lɨsyɛ ɓikpo, na Mika-mʉmbanzʉ wakamaga ka kʉmbanzɨkanikɔ ko Kunzi.» ");
INSERT INTO lik_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Nɨyɔ ɓʉkana ɓɛyɔ, ɓagbʉngʉkana ndɨ ɓihooo, ɓɨdʉlaga motili, ɨɓʉ ɓasɨ ɓagwi ndɨ Etieni. ");
INSERT INTO lik_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ɓopupa ndɨ na ɨyɨ kunzi wa gʉɗʉ, ɓapʉnga ndɨ kabʉma na matamʉ. Ɓadɛmʉ ɓava ndɨ ɓotu kaɓʉ, ɓoɗukusilo kambwa ka mʉwanza ɓemoti nɨnɔ ina ndɨ ɓɛ Saulo. ");
INSERT INTO lik_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ngbingo yi nɨnɔ ɓa ndɨ mino kabʉma na matamʉ nɔ, Etieni alʉmba ɓɛ: «Mombukwono-dosu Yeso, va lɨmbɛngɨ kamɨ.» ");
INSERT INTO lik_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Kʉwa wa, oɓuna ndɨ moli, apamɨkana ɓɛ: «Mombukwono-dosu, wakondonitɔgʉ ɓʉnyɛ kaɓʉ!» Kumbuso yi, osisa ndɨ lɨmbɛngɨ. ");
INSERT INTO lik_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saulo abaɨlyatʉ ndɨ gɔnɨ ɓɛ ɓamwɨ Etieni. Ka lɨsyɛ li nɨlɔ aka lɔ, yigyogyiso yidingi ɨpʉnganaga ndɨ ka kanisa ya Yelusalɛma. Ɓatʉtʉmbwa ɓotigala ndɨ ɨɓʉ wa aka wa, ɓatʉ nɨɓɔ ɓabaɨlya ndɨ ɓasɨ ɓomisikono ɓingbwi ka iwili ya Yudɛa na nɨyɔ ya Samalia. ");
INSERT INTO lik_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ɓatʉ ɓi nɨɓɔ ɓaɓangaga ndɨ Kunzi ɓalumba ndɨ Etieni, ɓagama ndɨ no kumbu kʉgbɛ. ");
INSERT INTO lik_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Luki limoti, Saulo a ndɨ kakɨsa no ngu kolumwisaga kanisa, anakpɨma ɓandaɓʉ ɓɨkpɛkpɛkpɛ kaugwi ɓatʉ nɨɓɔ ɓabaɨlya ndɨ iki ɓalʉkʉ ikanɨ ɓoko ɓi, anʉɗɨkɨta ka bɔlɔkɔ. ");
INSERT INTO lik_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ɓatʉ ɓi nɨɓɔ ɓomisikana ndɨ ɓɔ ɓikaga ndɨ kaɓɨkyaga Mongoni Manza ka pa yasɨ kʉ ɓakpakyanaga ndɨ mino. ");
INSERT INTO lik_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipi ɨnda ndɨ ka gʉɗʉ ɓemoti mudingi wa Samalia kaɓɨkyaga mongoni ko bulya ka Kilisito. ");
INSERT INTO lik_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ambaza ka ɓambanzʉ ɓamʉkanaga ndɨ lɨmbɛngɨ limoti, ɓanɨna makpʉmʉka mʉmbanga-mbanga nɨmɔ ikaga ndɨ kagya. ");
INSERT INTO lik_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Mambɛngɨ ma ɓʉnyɛ upupaga ndɨ ɓambanzʉ ɓakpʉ nɨ anapamɨkanaga. Ɓazɛgɛsɨ ɓakpʉ na ɓatʉ ɓakɨgyagya ɓahʉkagatʉ ndɨ gɔnɨ. ");
INSERT INTO lik_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Kʉwa wa, magyagya mudingi ingya ndɨ ka gʉɗʉ yi nɨnɔ. ");
INSERT INTO lik_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Wɨna sɛ, ka gʉɗʉ yi nɨnɔ, a ndɨ na alʉkʉ ɓemoti nɨnɔ ina ndɨ ɓɛ Simoni. Katʉkya ka ɓʉndɛlɨ, ʉkɨmaga ndɨ ɓanɛkɔ, ɓatʉ Ɓasamalia ɓanaɓanga. Ɨbɨbaga ndɨ kʉgbɛ. ");
INSERT INTO lik_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ɓatʉ ɓasɨ, iki ɓomiki ikanɨ ɓambɔkʉ ɓamʉkanaga ndɨ kʉgbɛ, ɓanaɓɨkya ɓɛ: «Alʉkʉ yi nɨmʉ a ngu ko Kunzi, nɨyɔ ɓalɨkyaga ɓɛ ‹Ngu Yidingi.›» ");
INSERT INTO lik_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ɓamʉkanaga ndɨ Simoni kyɛ katʉkya ka ɓʉndɛlɨ, udikisaga ndɨ nɔkʉ ɓɨdɛ na ɓanɛkɔ ɓi nɨɓɔ kakɨ ɓɔ. ");
INSERT INTO lik_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Luki limoti, nɨyɔ ɓabaɨlya Mongoni Manza nɨmɔ Filipi a ndɨ kaɓɨkyaga ko bulya Ɓʉngama ko Kunzi na ko lino ka Yeso-Kilisito, ɓalʉkʉ na ɓoko ɓiɓotisisa ndɨ. ");
INSERT INTO lik_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Gʉtʉgʉ Simoni mombukwana-dakɨ yi abaɨlya ndɨ, ɓaɓotisiso, ɓikaga kʉwa ndɨ na Ɓafilipi aka. Mʉnɔkʉ adɨkaga ndɨ ɓɨdɛ kaɨna mokingyosi na makpʉmʉka mʉmbanga-mbanga nɨmɔ igyonosaga ndɨ. ");
INSERT INTO lik_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ka Yelusalɛma, ɓatʉtʉmbwa ɓʉkana ɓɛ Ɓasamalia ɓoboilyini lɨkpʉmʉka ko Kunzi, ɓʉtɨkɨlya kʉwa ndɨ Pɛtɛlɛ ɨɓʉ na Yuani. ");
INSERT INTO lik_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Nɨyɔ ɓosilo ka Samalia, ɓʉlʉmbɨlya ndɨ ɓatʉ nɨɓɔ ɓabaɨlya ndɨ ɓɔ kyɛ Lɨmbɛngɨ-Lotu usilyi. ");
INSERT INTO lik_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","A ɓɛyɔ, Lɨmbɛngɨ-Lotu kɛgʉ na ɨɓʉ lisilyo, ɓuɓotiso mbɛyɨ ndɨ ko lino ka Mombukwono-dosu Yeso aka. ");
INSERT INTO lik_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Kʉwa wa, Pɛtɛlɛ ɨɓʉ na Yuani ɓubisilya ndɨ maɓɔkʉ, Lɨmbɛngɨ-Lotu usilya kʉwa ndɨ. ");
INSERT INTO lik_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Nɨyɔ Simoni ɨna ɓɛ Lɨmbɛngɨ-Lotu usilyini ɓatʉ nɨɓɔ ɓabaɨlya ndɨ ɓɔ ngbingo yi nɨnɔ ɓatʉtʉmbwa ɓubisilya ndɨ mino maɓɔkʉ, udulyoku ndɨ Pɛtɛlɛ ɨɓʉ na Yuani no ɓuyi, ʉɓɨkya ɓɛ: ");
INSERT INTO lik_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","«Ipóniku gɔnɨ ngu yi nɨyɔ, iba nakabisilyogo ɓanʉ mʉmbanzʉ maɓɔkʉ, Lɨmbɛngɨ-Lotu asyilyo.» ");
INSERT INTO lik_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Luki limoti, Pɛtɛlɛ asikisya ndɨ ɓɛ: «Wigyogyinɔ gʉtʉgʉ pa imoti no ɓuyi kakʉ! Wakasɨma ɓɛ wakwananatʉ koluwo no ɓuyi luki nɨlɔ Kunzi apága ka ɨzɨyɔ! ");
INSERT INTO lik_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Wakɛgʉ na pa ka lɨkpʉmʉka li nɨlɨ, kundigʉ ɓɛgɛyɔ, kyɛ wakɛgʉ ngbingbili kambwa ko Kunzi. ");
INSERT INTO lik_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Wasa tamanaga yanyɛ, walʉmba Mombukwono-dosu, yagɔgɔ akwananatʉ kaʉpɨlya inguo ya tamanaga yi nɨyɔ. ");
INSERT INTO lik_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","A ɓɛyɔ, nakaɨna ɓɛ wa mutumo na mʉsasa, na wa ka bɔlɔkɔ ya ɓʉnyɛ.» ");
INSERT INTO lik_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simoni asikisya kʉwa ndɨ Pɛtɛlɛ ɨɓʉ na Yuani ɓɛ: «Ilumbilyono asɨ nɨ iɓunu aka, iba lɨkpʉmʉka gʉtʉgʉ limoti aka kesilyonitɔgʉ ɓɛyɔ moɓikyi mino.» ");
INSERT INTO lik_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Kumbuso kapága mongoni ka nɨmɔ igyonosa ndɨ na kaɓɨkyaga lɨkpʉmʉka ka Mombukwono-dosu, Pɛtɛlɛ na Yuani ɓɨga ndɨ ka Yelusalɛma. Ko pisi, ɓa ndɨ kaɓɨkyaga Mongoni Manza ko giyo dididi ya Samalia. ");
INSERT INTO lik_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Malaika ɓemoti ka Mombukwono-dosu aɓɨkya ndɨ Filipi ɓɛ: «Wɨnda miso ya zebu, ka syʉngbʉ wo pisi yi nɨyɔ atʉkyaga ka Yelusalɛma kaɨnda ka Gaza.» ");
INSERT INTO lik_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Filipi atʉkya ndɨ, aga. Ko pisi, abangana ndɨ na Muetiopia ɓemoti. Ɨyɨ alʉkʉ yi nɨnɔ a ndɨ mʉtʉ wa ɨbɨba kʉgbɛ kʉ kaɓʉ. Ɨyɨ gɔnɨ nɔ andaga ndɨ lɨngama lasɨ ka ngama mudingi muko yi wa Etiopia ɓɛyɔ ka Kandaki. Ɨyɨ Muetiopia yi nɨnɔ a ndɨ nɨ ogoni kabibiso Kunzi ka Yelusalɛma. ");
INSERT INTO lik_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","A kʉwa ndɨ kaɨga kʉ kakɨ. Ikini ka masuwa kakɨ nɨnɔ ɓapunda ɓalutaga ndɨ, anatangʉlaga kɨtaɓʉ ka mugyalandʉ Isaya. ");
INSERT INTO lik_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Lɨmbɛngɨ-Lotu aɓɨkya ndɨ Filipi ɓɛ: «Mʉkpʉɗa masuwa yi nɨmʉ.» ");
INSERT INTO lik_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filipi ɨnda ndɨ mbangʉ, amʉkana Muetiopia nɨ anatangʉlaga kɨtaɓʉ ka mugyalandʉ Isaya. Filipi amuusa ɓɛ: «Watʉ kotombisyo lɨkpʉmʉka li nɨlɔ wakatangʉlaga lɔ?» ");
INSERT INTO lik_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Asikisya ɓɛ: «Nakwanana kotombisyo lɨkɨ nɨ mʉmbanzʉ ketumbulyogigʉ?» Kʉwa wa, amaka ndɨ Filipi ɓɛ oɗokiku kaiko ka kpɔlɔ kakɨ. ");
INSERT INTO lik_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","A ndɨ katangʉlaga Moɓiso mi nɨma: «Ɓɨnda ndɨ na ɨyɨ mʉɗɔngɔnɨ abɛ kɔndɔlɔ ka pa yi nɨyɔ ɓumwɔgɔ mino ɓanyama, mʉɗɔngɔnɨ abɛ mikya kɔndɔlɔ mʉdaka ɓiwo kambwa ka mʉtʉ yi nɨnɔ ʉkɔgɔ tukatʉ, nɨ kɛgʉ kaiɓukuso. ");
INSERT INTO lik_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ɓayopisaga ndɨ nɨ ɓakakugʉ ngbanga kakɨ ka ɓungbingbili. Wanɨ nɔ apága ndɛkɛ mongoni mo puponogo kakɨ? Kyɛ ɓatumboni ndɨ ɔɓɨlɨ kakɨ kʉnʉ ka lɨtɔmbʉ.» ");
INSERT INTO lik_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Alʉkʉ yi nɨnɔ aka na Filipi ɓɛ: «Kikiliki, mugyalandʉ akanzɨna ɓɛyɔ ko bulya ka wanɨ? A ko bulya kakɨ aka ikanɨ ka mʉtʉ wagɔgɔ?» ");
INSERT INTO lik_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Kʉwa wa, Filipi apʉnga ndɨ kozukogo pa ya Moɓiso mi nɨmɔ aka mɔ, aɓɨkyaga Mongoni Manza ka Yeso. ");
INSERT INTO lik_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ɓidukulaga ndɨ na lɨgʉndʉ, ɓadwɛ ka pa yimoti nɨyɔ a ndɨ no liɓo. Mʉtʉ wa ɨbɨba yi nɨnɔ aɓɨkya ndɨ Filipi ɓɛ: «Yɛ ba! Liɓo nɨlɨ, ɨkɨ ɓata yɔ otigoli ɓɛ ɓeɓotisi?»  ");
INSERT INTO lik_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filipi asikisya ndɨ ɓɛ: «Kika nɨ woɓinikyonini na lɨngʉnʉ, ɓakwanana kauɓotiso.» Alʉkʉ nɔ asikisya ɓɛ: «Na na baya ambɛ Yeso-Kilisito a Miko Kunzi.» ");
INSERT INTO lik_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Akpamya ɓɛ ɓamomosi masuwa. Ɨɓʉ ɓasɨ ɓaɓa ɓosya ndɨ ko liɓo, Filipi aɓotiso. ");
INSERT INTO lik_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Nɨyɔ ɓopupoku ndɨ ko liɓo, Lɨmbɛngɨ ka Mombukwono-dosu aga ndɨ na Filipi nɨ alʉkʉ yi nɨnɔ kaminigʉ ɓata. Luki limoti, aga kʉwa ndɨ nɨ otumini na magyagya ɓɨɗɛ. ");
INSERT INTO lik_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filipi ɨzʉkyana kʉwa ndɨ nɨ odwini ka mugi ma Azoto. A ndɨ kaɓɨkyaga Mongoni Manza ka ɓagʉɗʉ ɓasɨ nɨɓɔ a ndɨ mino kakɨtaga, kadwɛ kʉ kwa kʉ adwɛ ndɨ mino ka mugi ma Kaizalɨa. ");
INSERT INTO lik_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ka masyɛ mi nɨmɔ, Saulo ikaga ndɨ kaʉnyakɨlya ɓaɓɨɓya ka Mombukwono-dosu, anʉpapandɨa kukwakʉ. Lɨsyɛ limoti, aga ndɨ kʉ ko kumu-kumu, ");
INSERT INTO lik_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","akʉnga ndɨ ɓabalʉwa kaɨnda ka ɓandaɓʉ ɓaya malʉmba ka Ɓayuda ka gʉɗʉ wa Damasɨkɨ. Kʉsɔ wa ɓabalʉwa ɓi nɨɓɔ, ɓasɨlya ndɨ pisi ɓikpo ɓɛ kʉtakanya ɓambanzʉ nɨɓɔ ɓakaɓyɨɓya lɨkpʉmʉka ka Mombukwono-dosu iki ɓalʉkʉ ikanɨ ɓoko, ugwi, ɨndɨ na ɨɓʉ ka Yelusalɛma. ");
INSERT INTO lik_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Nɨyɔ a mbɛyɨ ndɨ mino ko pisi aka, ɓuwobi kadwɛ ka Damasɨkɨ, ko ngbinga ɓemoti aka, mangbamʉ kotukyoku kʉgʉ wa lɨsyɛ akungula ndɨ ɓikululu. ");
INSERT INTO lik_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ɨyɨ aka ndɨ wasɨ ɓɨngɔmʉ, ʉkana lɨyʉ nɨ anaɓɨkya ɓɛ: «Saulo, Saulo, wakegyogyiso ko bulya ɨkɨ?» ");
INSERT INTO lik_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Amuusa ɓɛ: «Mombukwono-dosu, ɨwɛ nɨ wanɨ?» Lɨyʉ asikisya ɓɛ: «Ɨmɨ nɨ Yeso nɨnɔ wakagyogyiso nɔ. ");
INSERT INTO lik_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Luki limoti, wamaga, wingya ka gʉɗʉ. Kʉ ɓɛyɔ, ɓʉɓɨkyatʉ nɨlɔ wakwanana kagya.» ");
INSERT INTO lik_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ɓatʉ nɨɓɔ ɓa ndɨ na ɨɓʉ ka mʉɗɔngɔ, ɓamaga ndɨ. Nɔkʉ ʉdɨka ɓɨdɛ. Ɓa ndɨ kaʉkana lɨyʉ, luki limoti nɨ ɓakɛgʉ kamɨna mʉmbanzʉ. ");
INSERT INTO lik_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saulo amaga ndɨ, akʉla miso, gʉtʉgʉ ɓɛyɔ akʉla ndɨ mino miso yɔ, luki limoti kɛgʉ ɓata kaɨna. Ɓagwi kʉwa ndɨ kʉɓɔkʉkɔ, ɓaga na ɨyɨ ka Damasɨkɨ. ");
INSERT INTO lik_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Agya ndɨ masyɛ masaa nɨ kɛgʉ kaɨna, nɨ kɛgʉ kalyalya gʉtʉgʉ komwo liɓo aka. ");
INSERT INTO lik_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Kʉ ka Damasɨkɨ kʉ, a ndɨ na mʉɓɨɓya ɓemoti nɨnɔ ina ndɨ ɓɛ Anania. Mombukwono-dosu apuponilya ndɨ ko nziki, amaka ɓɛ: «Anania!» Anania aka ndɨ ɓɛ: «Ɨmɨ nɨmʉna, Mombukwono-dosu». ");
INSERT INTO lik_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Mombukwono-dosu aɓɨkya ɓɛ: «Wɨnda ko pisi nɨyɔ ɓalɨkyaga ɓɛ ‹Yongbingbili›, wingyo ka ndaɓʉ ka Yuda. Kʉ ɓɛyɔ, ɓʉwanyɨ alʉkʉ ɓemoti nɨnɔ ina ɓɛ Saulo, nɨnɔ a mʉtʉ wa Talasɨ. Akalʉmba mbɨya wanʉ. ");
INSERT INTO lik_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ɨyɨ aminito ɓi ko nziki alʉkʉ ɓemoti nɨnɔ ina ɓɛ Anania nɨ anogulyo kʉ a ndɨ mino, abisilya maɓɔkʉ ɓɛ kyɛ apʉngɨ ɓata kaɨna.» ");
INSERT INTO lik_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Anania osikisya ndɨ ɓɛ: «Mombukwono-dosu, numukoni ɓi ɓambanzʉ ɓudingi ɓananzɨna lɨkpʉmʉka ka alʉkʉ yi nɨmʉ ɓɛyɔ ugyogyisogo ɓi mino ɓatʉ kakʉ ka Yelusalɛma. ");
INSERT INTO lik_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Oduku ɓi wanʉ kyɛ ɓokumu-kumu ɓɔ ɓatwi ɓi ɓɛ oduku kaugwi ɓatʉ ɓasɨ nɨɓɔ ɓʉɓɨnɨkyana.» ");
INSERT INTO lik_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Luki limoti, Mombukwono-dosu aɓɨkya ndɨ Anania ɓɛ: «Wɨnda, kyɛ napunogini alʉkʉ yi nɨnɔ ɓɛ iki kegugubyo. Aɓɨkyaga lɨkpʉmʉka kamɨ ka ɓɛvananza dididi, kambwa ka ɓangama na kambwa ka Ɓezaleli. ");
INSERT INTO lik_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Nawonisila ɓanʉ nɨ ɨmɨ yigyogyiso yasɨ nɨyɔ asilyo ɓanʉ ko bulya kamɨ.» ");
INSERT INTO lik_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Kʉwa wa, Anania aga ndɨ. Nɨyɔ agulyo ka ndaɓʉ, abisilya ndɨ Saulo maɓɔkʉ, aɓɨkya ɓɛ: «Saulo, mika-mama, Mombukwono-dosu Yeso nɨnɔ upuponilyi ɓi ko pisi ngbingo yi nɨnɔ wo ɓi mino kodoku kʉnʉ nɔ etikiku. Etikiku kyɛ miso ʉkʉlɨkanɨ, wotumo na Lɨmbɛngɨ-Lotu.» ");
INSERT INTO lik_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ko ngbingo yi nɨnɔ aka nɔ, makpʉmʉka nɨmɔ a ndɨ ko misa ka Saulo abɛ masɔbɨ apupo, apʉnga ndɨ kʉwa ɓata kaɨna. Kʉwa wa, amaga ndɨ, ɓaɓotiso. ");
INSERT INTO lik_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Kumbuso yi, alyalya ndɨ, ngu amigilyoku ɓata. Saulo agya ɓata ndɨ mino masyɛ makɛɗɛ na ɓaɓɨɓya nɨɓɔ ɓa ndɨ ka Damasɨkɨ wa. ");
INSERT INTO lik_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Kolipyagʉ ndɨ, apʉnga kaɓɨkyaga Mongoni Manza ka ɓandaɓʉ ɓaya malʉmba ka Ɓayuda ɓɛ Yeso nɨ Miko Kunzi. ");
INSERT INTO lik_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Nɔkʉ ʉdɨkaga ndɨ ɓatʉ ɓasɨ nɨɓɔ ɓamʉkanaga ndɨ ɓɨdɛ. Ɓanuuso ɓɛ: «Kɛgʉ mbɛyɨ alʉkʉ yi nɨmʉ nɔ ugyogyisaga ndɨ ɓatʉ nɨɓɔ ɓatwaga ndɨ lino ka Yeso ka Yelusalɛma? Kodukugʉ ɓi mbɛyɨ kaugwi na kaaga na ɨɓʉ kambwa ka ɓokumu-kumu?» ");
INSERT INTO lik_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Luki limoti, Saulo ikaga kʉwa ndɨ asɨ kaɓɨkyaga Mongoni Manza na kɛkɛlɛ. Owoniso ɓɛ Yeso nɨ Kilisito, gʉtʉgʉ Ɓayuda aka nɨɓɔ ɓikaga ndɨ ka Damasɨkɨ ɓakɛgʉ ɓata ndɨ kaiba ɓɛ ɓaɓɨkya ɓʉ. ");
INSERT INTO lik_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Nɨyɔ olipya ɓɛyɔ, Ɓayuda ɓʉkanana ndɨ ɓɛ okwononi ɓamwɨ Saulo. ");
INSERT INTO lik_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Luki limoti, ʉkana ndɨ dikiɗi yi nɨyɔ. Biti na lɨsyɛ ɓikaga kʉwa ndɨ koɓuulyogo pumi ya gʉɗʉ ɓɛ kyɛ ɓamwɨ. ");
INSERT INTO lik_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Biti yimoti, ɓaɓɨɓya kakɨ ɓava ndɨ, ɓamakya ka mʉmbɨ, ɓasiso ka mʉzʉlʉ ɓɨyɛɛɛ kunzi wa gʉɗʉ. ");
INSERT INTO lik_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Nɨyɔ Saulo osilo ka Yelusalɛma, a ndɨ kapa kamatɨkana na ɓaɓɨɓya ɓagɔgɔ. Luki limoti, ɨɓʉ ɓasɨ ɓa ndɨ kaɓanga kyɛ ɓakɛgʉ ndɨ kaɓɨnɨkyana ɓɛ a kʉwa mʉɓɨɓya gɔnɨ. ");
INSERT INTO lik_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Kʉwa wa, Balanaba ava ndɨ, ɨnda na ɨyɨ kambwa ka ɓatʉtʉmbwa. Ʉtʉmbʉlyaga ndɨ ɓɛyɔ Saulo amɨna ndɨ mino Mombukwono-dosu ko pisi, na ɓɛyɔ Mombukwono-dosu anzɨnɨlya ndɨ mino. Ʉtʉmbʉlyaga gɔnɨ ɓɛyɔ Saulo aɓɨkyaga ndɨ mino Mongoni Manza ko lino ka Yeso ka Damasɨkɨ nɨ kɛgʉ na kʉɓangakʉ. ");
INSERT INTO lik_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Katʉkya kʉwa wa aka wa, Saulo amatɨkana ndɨ na ɨɓʉ. Ɓagaga ndɨ, ɓanigoku ka Yelusalɛma kaɓɨkyaga Mongoni Manza ko lino ka Mombukwono-dosu nɨ ɓakɛgʉ na kʉɓangakʉ. ");
INSERT INTO lik_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ikaga ndɨ kanzɨna, anagya ɓoɗongoso na Ɓayuda nɨɓɔ ɓanzɨnaga ndɨ Ligiliki. Luki limoti, ɨɓʉ ɓa ndɨ kakɨsa kamwɔ aka. ");
INSERT INTO lik_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Nɨyɔ ɓatʉ ɓi nɨɓɔ ɓalʉmbaga ndɨ na ɨɓʉ ɓʉkana ɓɛyɔ, ɓaga ndɨ na ɨyɨ ka Kaizalɨa, katʉkya wa, ɓamogosa ndɨ ka mugi ma Talasɨ. ");
INSERT INTO lik_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ko ngbingo yi nɨnɔ, Kanisa a ndɨ ka mazɨyɔ ka Yudɛa wasɨ, ka Galilaya na ka Samalia. Kanisa idukulaga ndɨ ka baya, ikaga ndɨ kaɓanga Mombukwono-dosu, ɨtʉndaga ndɨ pisi ko ngu ya Lɨmbɛngɨ-Lotu ");
INSERT INTO lik_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pɛtɛlɛ ikaga ndɨ kolingyo ɓewili ɓayasɨ ɓi nɨɓayɔ. Lɨsyɛ limoti, ɨnda ndɨ kaʉnda ɓatʉ nɨɓɔ ɓabaya ndɨ kʉ ka gʉɗʉ wa Luda. ");
INSERT INTO lik_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Kʉ ɓɛyɔ, atakanya ndɨ mʉtʉ ɓemoti nɨnɔ ina ndɨ ɓɛ Ayɨnɨya. Alʉkʉ yi nɨnɔ a ndɨ zɛgɛsɨ, ikaga ndɨ wakanga aka ka kalagba ka ɓyanga ɓʉgɨna. ");
INSERT INTO lik_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pɛtɛlɛ aka ndɨ na ɨyɨ ɓɛ: «Ayɨnɨya, Yeso-Kilisito uhukusini. Wamaga, woɓungusyaga ɓusisini kakʉ!» Ko ngbingo yi nɨnɔ aka nɔ, amaga ndɨ. ");
INSERT INTO lik_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Nɨyɔ ɓatʉ ɓasɨ ɓa gʉɗʉ wa Luda na ɓatʉ ɓa ɨsa ya Salɔnɨ ɓɨna ɓɛyɔ, ɓaɓɨnɨkyana ndɨ Mombukwono-dosu. ");
INSERT INTO lik_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ka mugi ma Yɔpa, a ndɨ na mʉɓɨɓya muko yi ɓemoti nɨnɔ ina ndɨ ɓɛ Tabita. Lino li nɨlɔ ka Ligiliki nɨ «Dolika», isi yi nɨ «Longu». Ʉgyaga ndɨ ɓambanzʉ ɓɨnza, anusingyo ɓatʉ ɓa yangya. ");
INSERT INTO lik_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Lɨsyɛ limoti, agʉna ndɨ, okwo. Nɨyɔ ɓasʉkʉsaga, ɓamongosa ka ndaɓʉ yimoti ya kʉgʉ. ");
INSERT INTO lik_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ɓaɓɨɓya ɓʉkana ndɨ ɓɛ Pɛtɛlɛ a ka Luda nɨnɔ a ɓuwobi na Yɔpa. Ɓatɨkɨlya kʉwa ndɨ ɓalʉkʉ ɓaɓa kaɓikyoku ɓɛ: «Kikiliki, doku mbɛyɨ kʉnʉ ɓɨkwa.» ");
INSERT INTO lik_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pɛtɛlɛ atʉkya ndɨ, ɓɨnda pa imoti na ɨɓʉ. Nɨyɔ ɓosilo, ɓaga ndɨ na ɨɓʉ ka ndaɓʉ yi nɨyɔ ya kʉgʉ yɔ. Ɓowoko ɓasɨ ɓakpuɗoku ndɨ nɨ ɓanagamana, ɓanawoniso ɓakoti na ɓotu nɨɓayɔ Dolika ʉtɨlyaga ndɨ ngbingo yi nɨnɔ ɓikaga ndɨ mino na ɨɓʉ. ");
INSERT INTO lik_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pɛtɛlɛ upupisa ndɨ ɓatʉ ɓasɨ kunzi, oɓuno moli, alʉmba ndɨ. Kumbuso yi, oyikono kʉ manda a ndɨ mino, ɨyɨ aka ɓɛ: «Tabita, wamaga!» Kʉwa wa, akʉla miso, amɨna Pɛtɛlɛ, ɨyɨ aka ɓiziko. ");
INSERT INTO lik_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pɛtɛlɛ agwi ndɨ kʉɓɔkʉkɔ, amomoso. Ʉmaka kʉwa ndɨ ɓaɓɨɓya na ɓowoko, umomosilyo nɨ a kʉwa ɓata muɓisi. ");
INSERT INTO lik_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ɓatʉ ɓasɨ ɓa Yɔpa ɓʉkana ndɨ lɨkpʉmʉka li nɨlɔ, ɓatʉ ɓudingi ɓaɓɨnɨkyana ndɨ Mombukwono-dosu. ");
INSERT INTO lik_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pɛtɛlɛ asyɛsyɛ ndɨ ɓɨndɨ ka Yɔpa, ka alʉkʉ ɓemoti nɨnɔ ina ndɨ ɓɛ Simoni nɨnɔ oɓungusyaga ndɨ bokuto ta ɓanyama. ");
INSERT INTO lik_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","A ndɨ na mʉtʉ ɓemoti ka Kaizalɨa nɨnɔ ina ndɨ ɓɛ Kuneli. Alʉkʉ yi nɨnɔ a ndɨ ngama ka ɓasʉda mɨya yimoti. Ambaza yi nɨnɔ ɓamakaga ndɨ ɓɛ «ambaza ka Ɓetalia». ");
INSERT INTO lik_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","A ndɨ mʉtʉ wongbingbili, aɓangaga ndɨ Kunzi pa imoti na ɓatʉ ɓasɨ ɓa ndaɓʉ kakɨ. Ʉpapága ndɨ kʉgbɛ Ɓayuda ɓi nɨɓɔ ɓa yangya, na alʉmbaga ndɨ masyɛ masɨ. ");
INSERT INTO lik_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Lɨsyɛ limoti, mɔnɨ kadwɛ ɓuwobi ɓasaa-tisa, malaika ɓemoti ko Kunzi apuponilyoku ndɨ ɓɨwɛɛɛ abɛ kika ko nziki. Ɨyɨ malaika nɔ ogulya ndɨ kʉ kakɨ, amaka ɓɛ: «Kuneli!» ");
INSERT INTO lik_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kuneli anda ndɨ ɓɨngbangbangba, kʉɓangakʉ atumini ɓɨɗɛ, amuusa ɓɛ: «A sɛ ɓʉnɨ, Mombukwono-dosu?» Malaika asikisya ɓɛ: «Kunzi ukonini malʉmba kakʉ, atamana ɓɛyɔ usingyogo mino ɓatʉ ɓa yangya. ");
INSERT INTO lik_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Mbɨya wanʉ, ʉtɨka nɛkɨ ɓambanzʉ ka gʉɗʉ wa Yɔpa, ɓɨndɨ kamokoku alʉkʉ ɓemoti nɨnɔ ina ɓɛ Simoni, ɓamakagatʉ gɔnɨ ɓɛ Pɛtɛlɛ. ");
INSERT INTO lik_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ɨyɨ alʉkʉ nɔ ikaga ka Simoni, nɨnɔ oɓungusyogo bokuto ta ɓanyama. Obiso mugi ka mutili mo liɓo lidingi.» ");
INSERT INTO lik_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Nɨyɔ malaika yi nɨnɔ ɓa ndɨ kanzɨna na Kuneli nɔ aga, Kuneli ʉmaka kʉwa ndɨ ɓagya-ligubo ɓaɓa luga ka ɓagya-ligubo kakɨ na sʉda ɓemoti. Sʉda yi nɨnɔ a ndɨ mʉgya-ligubo kakɨ wandɛlɨ, na mʉtʉ mʉɓanga Kunzi kʉgbɛ. ");
INSERT INTO lik_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Kumbuso Kuneli kaʉtʉmbʉlyaga lɨkpʉmʉka lasɨ nɨlɔ akɨtanaga ndɨ lɔ, ʉtɨka ka Yɔpa. ");
INSERT INTO lik_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ɓʉgala ɓi, ɓagya-ligubo ɓaɓa ɓi nɨɓɔ na sʉda yi nɨnɔ ɓatʉkyɨlya ndɨ lɨgʉndʉ kaɨnda ka Yɔpa. Nɨyɔ, ɓa kʉwa ndɨ ɓuwobi kadwɛ, Pɛtɛlɛ aɗaka ndɨ kalʉmba na mʉsɨkatʉ ka ndaɓʉ ya kʉgʉ. ");
INSERT INTO lik_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ɨmʉkana ndɨ nza, akʉnga malɨlɨ. Luki limoti, ko ngbingo yi nɨnɔ ɓa ndɨ mino kambambambya aka nɔ, ahʉmwana ndɨ abɛ kika nɨ okwini. ");
INSERT INTO lik_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ɨna ndɨ ko nziki nɨ lɨsyɛ oukwikonini, luki limoti anosyoku kotukyoku abɛ kɨkwɛmbɛ yidingi ɓogwigogini ka mondu mi masɨ makwanganya kadwɛ kʉ kwa kʉnʉ ka lɨtɔmbʉ. ");
INSERT INTO lik_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Kʉsɔ yi, a ndɨ na mobi masɨ ma ɓanyama ɓa magʉ makwanganya, ɓanyama nɨɓɔ ɓakpakyanaga na ɓamʉma wasɨ na ɓombu. ");
INSERT INTO lik_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Kʉwa wa, ʉkana ndɨ lɨyʉ ɓɛ: «Pɛtɛlɛ, wamaga. Ʉmwɔgɔ, ʉlya!» ");
INSERT INTO lik_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pɛtɛlɛ osikisya ɓɛ: «Kalɨ, Mombukwono-dosu! Nakonolyigʉ ndɛkɛ luki lanyɛ ikanɨ nɨlɔ la mʉsʉgʉ.» ");
INSERT INTO lik_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ʉkana ɓata ndɨ lɨyʉ ka nganga ya yɨɓa ɓɛ: «Luki nɨlɔ Kunzi oɓuɓisoni, wakoitisonitɔgʉ abɛ kiko lanyɛ.» ");
INSERT INTO lik_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Lɨyʉ li nɨlɔ ɨgɨlya ndɨ nganga yɨsaa. Kumbuso yi, luki li nɨlɔ aɗaka ndɨ kʉgʉ wa lɨsyɛ. ");
INSERT INTO lik_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pɛtɛlɛ a kʉwa ndɨ kombomboyo ko bulya isi yo nziki yi nɨyɔ. Ko ngbingo yi nɨnɔ aka nɔ, ɓatʉ nɨɓɔ Kuneli utikoku ndɨ ɓopuponoku ko miso ma mupumi wa, kyɛ ɓa ndɨ nɨ ɓuwonyogini ndaɓʉ ka Simoni. ");
INSERT INTO lik_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ɓoipa ndɨ holi, ɓuusa ɓɛ: «Simoni nɨnɔ ina ɓɛ Pɛtɛlɛ ikaga wanʉ?» ");
INSERT INTO lik_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Ko ngbingo yi nɨnɔ Pɛtɛlɛ a mbɛyɨ ndɨ mino lɨmbɛngɨ ko bulya isi yo nziki yi nɨyɔ aka yɔ, Lɨmbɛngɨ-Lotu aɓɨkya ɓɛ: «Ɓatʉ ɓasaa ɓakaʉkɨsa. ");
INSERT INTO lik_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Wamaga, wosyo, maga pa yimoti na ɨɓʉ nɨ wakɛgʉ na ɓotumo, kyɛ ɨmɨ nɔ nutikiku.» ");
INSERT INTO lik_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Nɨyɔ Pɛtɛlɛ osyoku, ɨyɨ aka ndɨ na ɓalʉkʉ nɨɓɔ ɓɛ: «Ɨmɨ nɔ makɛkɨsa? A sɛ ɓʉnɨ?» ");
INSERT INTO lik_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ɓasikisya ɓɛ: «Ngama ka ɓasʉda ɓɛyɔ ka ambɔkʉ Kuneli nɔ atitikiku. Ɨyɨ, a mʉtʉ wongbingbili, aɓangagatʉ Kunzi, Ɓayuda ɓasɨ ɓabɨbaga kʉgbɛ. Malaika ɓemoti ko Kunzi aɓikyi ɓɛ utikiku ɓambanzʉ kaʉmaka, ʉkanɨ nɨlɔ waɓikyoku.» ");
INSERT INTO lik_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ɓogulyo kʉwa ndɨ na Pɛtɛlɛ ka ndaɓʉ, ʉwanya pa ya ɓusisini. Ɓʉgala ɓi, ɓapʉngaga ndɨ lɨgʉndʉ pa imoti na ɨɓʉ. Ɓatʉ ɓagɔgɔ nɨɓɔ ɓa ndɨ nɨ ɓoboilyini ka Yɔpa, ɓubisoku ndɨ. ");
INSERT INTO lik_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ɓosila ndɨ ka Kaizalɨa na ɓʉgala ɓi. Kuneli a kʉwa ndɨ kaʉɓʉndaga aka nɨ umumulini ɓava-kʉkakɨ pa imoti na ɓawai-dakɨ ɓa lɨmbɛngɨ nɨɓɔ ʉmaka ndɨ. ");
INSERT INTO lik_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Ngbingo yi nɨnɔ Pɛtɛlɛ a ndɨ mino kogulya ka Kaizalɨa, Kuneli ɨnda ndɨ katɨlya. Oɓuna ndɨ moli kambwa kakɨ, odidiko kadwɛ kʉ kwa kʉ ka lɨtɔmbʉ. ");
INSERT INTO lik_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Luki limoti, Pɛtɛlɛ amomosa ndɨ, aɓɨkya ɓɛ: «Wamaga, kyɛ na mʉmbanzʉ abɛ ɨwɛ gɔnɨ.» ");
INSERT INTO lik_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ɓogulya ndɨ ɨɓʉ na Kuneli ka ndaɓʉ nɨ ɓanɨkpʉkpʉmʉkya. Kʉ ɓɛyɔ, ɓʉtakanya ɓambanzʉ ɓakpʉ ɓʉmʉmʉkana. ");
INSERT INTO lik_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ɨyɨ aka ndɨ na ɨɓʉ ɓɛ: «Mibaga ɓɨnza ɓɛ kokwononigʉ Muyuda kakɔ lɨmbɨda na mʉtʉ yi nɨnɔ kɛgʉ Muyuda ikanɨ kogulya ka ndaɓʉ kakɨ. Luki limoti, Kunzi ewonisini ɓi ɓɛ nakaminonitɔgʉ mʉmbanzʉ gʉtʉgʉ ɓemoti aka abɛ kiko wanyɛ ikanɨ mʉtʉ wa mʉsʉgʉ. ");
INSERT INTO lik_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Kinili, ngbingo yi nɨnɔ mutiki ɓi mino ɓambanzʉ kɛmaka, noduku nɨ nakɛgʉ na ɓotumo. Iɓikyoni nɛkɨ nɨlɔ metikisyi mino.» ");
INSERT INTO lik_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kuneli asikisya ndɨ ɓɛ: «A kʉwa masyɛ masaa, wa no ɓi mino kalʉmba kʉ kamɨ na saa-tisa mɔnɨ ɓʉɓwa gɔnɨ ɓʉɓwa nʉ. Alʉkʉ ɓemoti wakimokisyogo ɓotu ɓayawenge-wenge epuponilyo ndʉkʉ ɓigbututu, ɨyɨ aka ɓɨgba kambwa kamɨ. ");
INSERT INTO lik_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ɛɓɨkya ɓɛ: ‹Kuneli, Kunzi ukonini ɓi malʉmba kakʉ, ʉtamana gɔnɨ ɓɛyɔ ʉpápaga mino ɓatʉ ɓa yangya. ");
INSERT INTO lik_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ʉtɨka nɛkɨ ɓambanzʉ ka Yɔpa, ɓɨndɨ kamaka alʉkʉ ɓemoti nɨnɔ ina ɓɛ Simoni, lino kakɨ lagɔgɔ nɨ Pɛtɛlɛ. Ikaga ka mʉtʉ ɓemoti nɨnɔ ina gɔnɨ ɓɛ Simoni. Simoni yi nɨnɔ oɓungusyogo bokuto ta ɓanyama, ibiso mugi ka mutili mo liɓo lidingi.› ");
INSERT INTO lik_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Kinili, nutiki ɓi ɓambanzʉ ɓɨgala-gala kaʉmaka, wogyi ɓɨnza kodoku. Ta kʉwa mbɨya wanʉ ɓasɨ kambwa ko Kunzi, kaʉkana lɨkpʉmʉka lasɨ nɨlɔ Mombukwono-dosu utikiku katɨɓɨkya.» ");
INSERT INTO lik_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pɛtɛlɛ aka ndɨ ɓɛ: «Mbɨya wanʉ, nibini lɨngʉnʉ ambɛ ko misa ko Kunzi ɓatʉ ɓasɨ ɓa mʉɗɔngɔnɨ aka, ");
INSERT INTO lik_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","luki limoti, ko giyo yasɨ, mʉtʉ wasɨ nɨnɔ aɓangaga Kunzi, anagya masɨ ka ɓungbingbili, Kunzi apaga mʉtʉ yi nɨnɔ. ");
INSERT INTO lik_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Kunzi utikilyoku ndɨ Ɓezaleli lɨkpʉmʉka kakɨ, ʉɓɨkyaga Mongoni Manza ma mazɨyɔ pisi ka Yeso-Kilisito nɨnɔ a Mombukwana ɓatʉ ɓasɨ. ");
INSERT INTO lik_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Makaiba lɨkpʉmʉka nɨlɔ akitanaga ndɨ ka Yudɛa wasɨ, kapʉnga ka Galilaya kumbusa wa kʉʉ ka Yuani ko bulya iɓatiso. ");
INSERT INTO lik_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Makaiba ɓɛyɔ Kunzi atumisa ndɨ mino Yeso mʉtʉ wa Nazalɛtɨ na Lɨmbɛngɨ-Lotu, apá ngu. Olingyaga ndɨ giyo yasɨ, anagya asɨ ɓʉnza aka, anuhukuso ɓatʉ ɓasɨ nɨɓɔ mumuyoniso a ndɨ na ɨɓʉ ɓʉɗɨta ɓɨnvɨ kyɛ Kunzi a ndɨ pa yimoti na ɨyɨ. ");
INSERT INTO lik_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Iɓusu ta ɓadɛmʉ ɓa lɨkpʉmʉka lasɨ nɨlɔ agya ndɨ kʉ ka mugi ka Ɓayuda na ka Yelusalɛma. Ɓamwɔ ndɨ pisi ka bangɨlaga ka mʉsalaba. ");
INSERT INTO lik_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Luki limoti, Kunzi apupisoku ndɨ ka mbʉkʉ kumbusa wa masyɛ masaa, awoniso ɓɨngbanganya, ");
INSERT INTO lik_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","kɛgʉ ka ɓatʉ ɓasɨ, luki limoti kusu nɨɓɔ Kunzi atɨpʉnaga ndɨ kambwa ɓɛ tiki ɓadɛmʉ. Iɓusu nɨɓɔ talyalya ndɨ, tomwo na ɨɓʉ kumbuso wo pupo kakɨ ka mbʉkʉ. ");
INSERT INTO lik_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Atɨkpamya ndɨ kaʉɓɨkyaga ɓambanzʉ Mongoni Manza, kaumibiso ɓɛ ɨyɨ nɔ Kunzi atikoku ndɨ kaiko zozi ka ɓatʉ nɨɓɔ ɓa mbɛyɨ ɓuɓisi na nɨɓɔ ɓokwaga ndɨ. ");
INSERT INTO lik_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ɓogyalandʉ ɓasɨ ɓaɓɨkyaga ndɨ ko bulya kakɨ ɓɛ: ‹Mʉtʉ wasɨ nɨnɔ aɓɨnɨkyana Yeso, inisono na mʉpɨlya ma ɓʉnyɛ ko lino kakɨ.›» ");
INSERT INTO lik_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Ko ngbingo yi nɨnɔ Pɛtɛlɛ a mbɛyɨ ndɨ mino kanzɨna aka nɔ, Lɨmbɛngɨ-Lotu usilya ndɨ ɓatʉ ɓasɨ nɨɓɔ ɓa ndɨ kaʉkana lɨkpʉmʉka ko Kunzi. ");
INSERT INTO lik_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ɓayuda nɨɓɔ ɓabaya ndɨ, nɨɓɔ ɓakpakyana ndɨ pa imoti na Pɛtɛlɛ, ɓombomboya ndɨ kʉgbɛ. Ɓa ndɨ kombomboyo kaɨna ɓɛ Lɨmbɛngɨ-Lotu nɨlɔ Kunzi otikoku ndɨ a gɔnɨ kausilyo ɓatʉ nɨɓɔ ɓakɛgʉ Ɓayuda. ");
INSERT INTO lik_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","A ɓɛyɔ, ɓa ndɨ kanzɨna masasʉ dididi, kabibiso Kunzi. Pɛtɛlɛ aka kʉwa ndɨ ɓɛ: ");
INSERT INTO lik_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","«Mbɨya wanʉ, ɓatʉ nɨɓana ɓinisonini na Lɨmbɛngɨ-Lotu abɛ iɓusu. Wanɨ ɓata nɔ aɓɨkya ɓɛ ɓakuɓotisoni?» ");
INSERT INTO lik_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Akpamya ndɨ ɓɛ ɓuɓotisi ko lino ka Yeso-Kilisito. Ka muliɓo, ɓaɓɨkya ndɨ Pɛtɛlɛ ɓɛ ɓagyɨ mbɛyɨ ɓata mino na ɨɓʉ masyɛ makɛɗɛ. ");
INSERT INTO lik_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ɓatʉtʉmbwa pa imoti na ɓatʉ ɓa baya nɨɓɔ ɓikaga ndɨ ka Yudɛa ɓʉkana ndɨ ɓɛ ɓɛvananza ɓayagɔgɔ ɓoboilyini gɔnɨ ɨɓʉ lɨkpʉmʉka ko Kunzi. ");
INSERT INTO lik_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Nɨyɔ Pɛtɛlɛ igoku ka Yelusalɛma, Ɓayuda ɓi nɨɓɔ ɓʉkɔ ndɨ, ɓapʉnga na ɨɓʉ ɓoɗongoso, ");
INSERT INTO lik_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ɓanaɓɨkya ɓɛ: «Wogulyi ɓi ka ɓatʉ ɓi nɨɓɔ ɓakɛgʉ ɓava-kukusu, malyalyo ɓi pa yimoti na ɨɓʉ!» ");
INSERT INTO lik_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Luki limoti, Pɛtɛlɛ apʉnga ndɨ kaʉtʉmbʉlyaga ɓɨnza-ɓɨnza makpʉmʉka masɨ nɨmɔ igyonosa ndɨ. Ʉɓɨkya ɓɛ: ");
INSERT INTO lik_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«Ɨmɨ, na ndɨ kalʉmba ka Yɔpa. Kumbuso yi, nahʉmwana ndɨ, ɛgya abɛ nakika ko nziki, nɨna luki limoti anosyoku abɛ kɨkwɛmbɛ yidingi ɓogwigogini ka mondu mi masɨ makwanganya kadwɛ ɓuwobi na ɨmɨ. ");
INSERT INTO lik_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Nanda ndɨ kʉsɔ yi ɓɨngbangbangba, nʉmɨna ɓanyama ɓa magʉ makwanganya, nɨɓɔ ɓotutu, nɨɓɔ ɓakpakyanaga na ɓamʉma wasɨ na ɓombu. ");
INSERT INTO lik_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Nʉkana ndɨ gɔnɨ lɨyʉ anɛɓɨkya ɓɛ: ‹Pɛtɛlɛ, wamaga. Ʉmwɔgɔ, ʉlya!› ");
INSERT INTO lik_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Luki limoti, nosikisya ndɨ ɓɛ: ‹Kalɨ, Mombukwono-dosu! Nakonolyigʉ ndɛkɛ luki lanyɛ ikanɨ nɨlɔ la mʉsʉgʉ.› ");
INSERT INTO lik_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Nukonoku ɓata ndɨ lɨyʉ ka nganga ya yɨɓa ɓɛ: ‹Luki nɨlɔ Kunzi oɓuɓisoni, wakoitisonitɔgʉ abɛ kiko lanyɛ.› ");
INSERT INTO lik_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Igyonosana ndɨ ɓɛyɔ nganga yɨsaa, kumbuso yi, luki li nɨlɔ ɨga ndɨ kʉgʉ wa lɨsyɛ. ");
INSERT INTO lik_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ko ngbingo yi nɨnɔ aka nɔ, ɓatʉ ɓasaa nɨɓɔ ɓutikoku ndɨ kɛmaka kotukyoku ka Kaizalɨa, ɓosiloku ka ndaɓʉ yi nɨyɔ ta ndɨ mino. ");
INSERT INTO lik_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Lɨmbɛngɨ-Lotu ɛɓɨkya ndɨ ɓɛ taga na ɨɓʉ nɨ nakɛgʉ na ɓotumo. Ɓomika-mama nɨɓana maɗɨya ɓana ɓebisoku ndɨ, togulya ka Kuneli. ");
INSERT INTO lik_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ɨyɨ atɨtʉmbʉlyaga ndɨ ɓɛyɔ malaika apuponilya ndɨ mino ka ndaɓʉ kakɨ, aɓɨkya ndɨ ɓɛ: ‹Mʉtɨka mʉmbanzʉ ka Yɔpa kamokoku Simoni, nɨnɔ ɓamakaga gɔnɨ ɓɛ Pɛtɛlɛ. ");
INSERT INTO lik_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ɨyɨ Simoni amʉɓɨkyaga ɓanʉ makpʉmʉka nɨmɔ amʉpá muhukuso na ɓatʉ ɓa ndaɓʉ kakʉ ɓasɨ.› ");
INSERT INTO lik_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Nɨyɔ napʉnga kanzɨna, Lɨmbɛngɨ-Lotu usilyo mʉɗɔngɔnɨ ɓɛyɔ atisilya ndɨ mino ka mambwa. ");
INSERT INTO lik_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Natamana kʉwa ndɨ lɨkpʉmʉka nɨlɔ Mombukwono-dosu aɓɨkya ndɨ mino ɓɛ: ‹Yuani oɓotisa ndɨ ko liɓo. Luki limoti, iɓunu, ɓamuɓotiso ndɛkɛ ka Lɨmbɛngɨ-Lotu› ");
INSERT INTO lik_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Kika nɛkɨ nɨ Kunzi utikilyiniku ka ɨzɨyɔ Lɨmbɛngɨ-Lotu li nɨlɔ gɔnɨ lɔ atitikilyoku ndɨ iɓusu, ngbingo yi nɨnɔ taɓɨnɨkyana ndɨ mino Mombukwono-dosu Yeso-Kilisito, ɨmɨ sɛ pɨyɛ kʉwa nɨ wanɨ kagya ɓoɗongoso no Kunzi?» ");
INSERT INTO lik_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Nɨyɔ ɓʉkana ɓɛyɔ, mambɛngɨ ʉdʉdʉla ndɨ, ɓapʉnga kabibiso Kunzi, ɓanaɓɨkya ɓɛ: «A nɛkɨ lɨngʉnʉ ɓɛ Kunzi uhukwilyini gɔnɨ ɓatʉ nɨɓɔ ɓakɛgʉ Ɓayuda pisi kayikoso ɔɓɨlɨ, na kainisono na ɔɓɨlɨ walɨngʉnʉ.» ");
INSERT INTO lik_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Nɨyɔ Etieni okwo, ɓapʉnga ndɨ kaugyogyiso ɓatʉ nɨɓɔ ɓabaya ndɨ, ɓomisikono kʉwa ndɨ ɓingbwi. Ɓaga ndɨ, ɓadwɛ kʉ kwa kʉ ka mugi ma Foinikia, Kipulo na Atiokia. Kʉ ɓɛyɔ, ɓa ndɨ kaʉɓɨkyaga Ɓayuda aka Mongoni Manza ko Kunzi. ");
INSERT INTO lik_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Luki limoti, luga kaɓʉ, ɓagɔgɔ nɨɓɔ ɓa ndɨ ɓatʉ ɓa Kipulo na Kulɛnɛ, ɓosila ndɨ ka Atiokia. Ɓapʉnga kʉwa ndɨ kanzɨna na ɓatʉ ɓi nɨɓɔ ɓanzɨnaga ndɨ Ligiliki, na kaʉɓɨkyaga Mongoni Manza ka Mombukwono-dosu Yeso. ");
INSERT INTO lik_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Kʉɓɔkʉkɔ kwo ngu ka Mombukwono-dosu a ndɨ pa yimoti na ɨɓʉ. Kinili, ɓambanzʉ ɓudingi kʉgbɛ ɓaɓɨnɨkyana ndɨ, ɓamɨgɨlya Mombukwono-dosu. ");
INSERT INTO lik_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Nɨyɔ ɓatʉ ɓa kanisa ya Yelusalɛma ɓʉkana ndɨ mongoni mi nɨmɔ, ɓatɨka kʉwa ndɨ Balanaba ka Atiokia. ");
INSERT INTO lik_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ngbingo yi nɨnɔ osilo mino, ɨna ɓɛyɔ Kunzi uɗukilya ndɨ mino ɓatʉ ɓi nɨɓɔ ɓabaya ndɨ ɓʉɓʉnga, ogwa magyagya. Utumisa ndɨ ɨɓʉ ɓasɨ mambɛngɨ kaigwinonogo na Mombukwono-dosu lɨmbɛngɨ limoti. ");
INSERT INTO lik_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","A ɓɛyɔ, Balanaba a ndɨ mʉtʉ wongbingbili, mutumo na Lɨmbɛngɨ-Lotu na baya ɓɨɗɛ. Ambaza mudingi ka ɓambanzʉ aɓɨnɨkyana ndɨ Mombukwono-dosu. ");
INSERT INTO lik_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Kʉwa wa, Balanaba aga ndɨ kakɨsa Saulo ka Talasɨ. ");
INSERT INTO lik_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Nɨyɔ amɨna ndɨ, ɓaga na ɨyɨ ka Atiokia. Kʉsɔ wa syangasʉ simoti iti, ɓamʉmʉkanaga ndɨ ka kanisa yi nɨyɔ kʉ, ɓanʉtɨwa ɓambanzʉ ɓakpʉ. Ɓapʉnga ndɨ kaʉmaka ɓaɓɨɓya ɓɛ ɓakilisito ka nganga ya mambwa kʉ ɓɛyɔ. ");
INSERT INTO lik_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ka masyɛ mi nɨmɔ, ɓogyalandʉ ɓotukyoku ndɨ ka Yelusalɛma ɓodoku ka Atiokia. ");
INSERT INTO lik_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ɓemoti kaɓʉ nɨnɔ ina ndɨ ɓɛ Agabʉ, amaga ndɨ, Lɨmbɛngɨ-Lotu akpamya kaɓɨkyaga ɓɛ ayʉndɨ wapʉ ahumatʉ ɓanʉ ɔɓɨlɨ wasɨ. Igyonosa ndɨ ɓɛyɔ aka yɔ ko ngbingo nɨnɔ Kɔlɔdɛ a ndɨ mino ngama mudingi wa Lʉma. ");
INSERT INTO lik_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ɓaɓɨɓya ɓʉkanana ndɨ ɓɛ mʉtʉ yɨkaka-yɨkaka kaɓyɛnɛnɛ no ngu kakɨ, apɨ́ luki, ɓʉtɨtɨkyɨ ɓamamaɓʉ nɨɓɔ ɓa Yudɛa. ");
INSERT INTO lik_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ɓagya ndɨ ɓɛyɔ aka yɔ. Ɓʉtɨkɨlya ndɨ ɓambɔkʉ-mbɔkʉ ɓa Yudɛa ɓangyɔ ɓi nɨɓɔ na Balanaba ɨɓʉ na Saulo. ");
INSERT INTO lik_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ko ngbingo yi nɨnɔ, ngama Ɛlɔdɨ apʉnga ndɨ kaugyogyiso ɓambanzʉ ɓemoti-ɓemoti ɓa kanisa. ");
INSERT INTO lik_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Akpamya ndɨ ɓɛ ɓamwɨ Yakɔbɔ nɨnɔ mamakɨ Yuani na dʉkpa. ");
INSERT INTO lik_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Nɨyɔ ɨna ndɨ ɓɛ Ɓayuda ɓakogwa magyagya ko bulya lɨkpʉmʉka li nɨlɔ, agwisisa ndɨ gɔnɨ Pɛtɛlɛ. A ndɨ ko ngbingo wa yɨnga nɨyɔ ɓalyaga mino mukati ɓikofulu. ");
INSERT INTO lik_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Nɨyɔ agwi Pɛtɛlɛ, amakya ka bɔlɔkɔ, obisa ndɨ magbʉta makwanganya dididi ma ɓasʉda ɓakwanganya-ɓakwanganya kaɓuulyogo. A ndɨ kapa kasombiso kumbusa wa yɨnga wa Pasɨka. ");
INSERT INTO lik_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ɓa kʉwa ndɨ kaɓuulyogo Pɛtɛlɛ ka bɔlɔkɔ aka kʉ, nɨ kanisa iɗukufini ɓiguɓu kalʉmbɨlya. ");
INSERT INTO lik_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ɛlɔdɨ a kʉwa ndɨ kapa kasombiso na ɓʉgala ɓi, no biti yi nɨyɔ, Pɛtɛlɛ a ndɨ wakanga luga ka ɓasʉda ɓaɓa mʉkanda na ɓaselegeni ɓayɨɓa kanɨ ɓazamʉ ɓanoɓuulyo mupumi ma bɔlɔkɔ. ");
INSERT INTO lik_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Malaika ɓemoti ka Mombukwono-dosu opuponoku ndɨ ɓigbututu, ndaɓʉ yi nɨyɔ a ndɨ mino yɔ oɓuɓa ndɨ ɓitu. Malaika azʉkʉla ndɨ Pɛtɛlɛ, azuzukiso, aɓɨkya ɓɛ: «Wamaga ɓɨgala-gala!» Kʉwa wa, ɓaselegeni nɨɓayɔ ɓakanda ndɨ na iɓu maɓɔkʉ atɨnɨkaga ndɨ. ");
INSERT INTO lik_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Malaika aka ndɨ na ɨyɨ ɓɛ: «Wɨkandɨla mʉkaɓa, wɨkandɨlaga ɓɛkpakʉ.» Agya ndɨ ɓɛyɔ aka yɔ. Malaika aɓɨkya ɓata ndɨ ɓɛ: «Wimokisyo koti kakʉ, weɓyeku.» ");
INSERT INTO lik_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pɛtɛlɛ opupa ndɨ ka bɔlɔkɔ nɨ anaɓɨɓya malaika. Luki limoti, kɛgʉ ndɨ kaiba ɓɛ nɨlɔ malaika a ndɨ kagya a lɨngʉnʉ. A ndɨ kasɨma ɓɛ nziki. ");
INSERT INTO lik_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ngbingo yi nɨnɔ ɓakɨtaga ndɨ mino lɨgbʉta la mambwa ka ɓasʉda, kumbuso yi nɨlɔ la maɓa, ɓosila kʉwa ndɨ ka mupumi nɨmɔ ɓagya ndɨ na ɓangwɛyɨ, nɨmɔ ɓaɓyɛgɛ ndɨ mino kaɨnda ka gʉɗʉ. Mupumi mɔ oukwikana ndɨ nɨ imu aka kambwa kaɓʉ, ɓopupa ndɨ. Ɓisisilogo ko pisi yimoti ɓɛnɛ, malaika alimikya ndɨ ɓɨpɛlɛ. ");
INSERT INTO lik_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Niyɔ Pɛtɛlɛ imibo, ɨyɨ aka ndɨ ɓɛ: «Nibini sɛ kʉwa mbɨya wanʉ ambɛ Mombukwono-dosu atikiku malaika kakɨ kɛkʉlaga ka maɓɔkʉ ka Ɛlɔdɨ, na ka masɨ nɨɓɔ Ɓayuda ɓo ɓi kapa kɛgya.» ");
INSERT INTO lik_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ngbingo yi nɨnɔ ibo mino lɨkpʉmʉka li nɨlɔ ɓɛyɔ, aga ndɨ ka Malia, amakɨ Yuani nɨnɔ ɓamakaga ndɨ gɔnɨ ɓɛ Malɨkɔ. Ɓambanzʉ ɓudingi ɓa ndɨ ɓʉmʉmʉkana kʉ ɓɛyɔ kalʉmba. ");
INSERT INTO lik_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pɛtɛlɛ oyipa ndɨ holi ka mupumi ma kunzi. Mʉgya-ligubo muko yi nɨnɔ ina ndɨ ɓɛ Lɔda akpuɗoku ndɨ, kaʉkanɨlya. ");
INSERT INTO lik_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Iba ndɨ lɨyʉ ka Pɛtɛlɛ, ogwa magyagya kʉgbɛ, kanɨ koukwigʉ mupumi. Ɨga ndɨ mbangʉ kaʉɓɨkya ɓatʉ ɓagɔgɔ ɓɛ Pɛtɛlɛ a kunzi kʉ. ");
INSERT INTO lik_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ɨɓʉ aka ndɨ na ɨyɨ ɓɛ: «Wa na ibikyasʉ!» Luki limoti, otiolya ndɨ kaɓɨkya ɓɛ a lɨngʉnʉ. Ɓaɓɨkya kʉwa ɓɛ: «A nɛkɨ malaika kakɨ!» ");
INSERT INTO lik_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Luki limoti, Pɛtɛlɛ a ndɨ asɨ koipa aka holi. Nɨyɔ ɓoukwa kʉwa ndɨ mupumi, ɓamɨna, ɓombomboya ndɨ kʉgbɛ. ");
INSERT INTO lik_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Udokisa ndɨ na maɓɔkʉ, ʉtʉmbʉlyaga ɓɛyɔ Mombukwono-dosu apupisi mino ka bɔlɔkɔ. Uɓikyoku ɓata ɓɛ: «Muɓikyonikuto gɔnɨ Yakɔbɔ na ɓakilisito ɓagɔgɔ.» Kumbuso yi, opupa ndɨ, aga ka pa yagɔgɔ. ");
INSERT INTO lik_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Nɨyɔ lɨsyɛ asyɛ, ɓasʉda ɓapʉnga ndɨ ɨpʉmbʉ luga kaɓʉ, ɓanuusono ɓɛ: «Pɛtɛlɛ a yanɨ?» ");
INSERT INTO lik_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ɛlɔdɨ apá mʉtʉʉ ɓɛ ɓakɨsɨ ɓɨvaka-vaka, luki limoti nɨ ɓakaminigʉ. Usombisa ndɨ ɓasʉda nɨɓɔ ɓa ndɨ kaɓuulyogo, akpamya ɓɛ ɓulumwisogi. Kumbuso yi, atʉkya ndɨ ka Yudɛa, aga ka Kaizalɨa, agya ndɨ mino masyɛ kʉ ɓɛyɔ. ");
INSERT INTO lik_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Ɛlɔdɨ ikaga ndɨ no yoko yapʉ na ɓatʉ ɓa mugi ma Tilo na Sidɔna. Ɓatʉ ɓi nɨɓɔ ɓʉkanana ndɨ kaɨnda kamɨna. Ɓapʉnga mbɛyɨ ndɨ kaʉkanana na Balasɨtɔ, nɨnɔ oɓuulyaga ndɨ ndaɓʉ ka ngama, kumbuso yi, ɓaga ndɨ kaɨtatanaga na Ɛlodɨ kyɛ malɨlɨ nɨmɔ ɓalyaga ndɨ otukyogoku ndɨ kʉ kakɨ. ");
INSERT INTO lik_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ka lɨsyɛ nɨlɔ ɓʉkanana ndɨ mino, Ɛlɔdɨ imokisyaga ɓotu ɓaya ɓʉngama, ika ka ɓuliki kakɨ ɓa ɓʉngama, apʉnga kanzɨna kambwa ka ɓambanzʉ. ");
INSERT INTO lik_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ɓambanzʉ ɓapʉnga ndɨ kapamɨkanaga, ɓanaɓɨkya ɓɛ: «Kɛgʉ ɓata mʉmbanzʉ nɔ akanzɨna, a kʉwa lɨyʉ ko kunzi.» ");
INSERT INTO lik_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ko ngbingo yi nɨnɔ aka nɔ, malaika ɓemoti ka Mombukwono-dosu agyogyisa ndɨ kyɛ kapágʉ ndɨ Kunzi ɨbɨba, ugwa ndɨ ɓodulu wakamaga, okwo. ");
INSERT INTO lik_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Kʉwa wa, Lɨkpʉmʉka ko Kunzi isisilaga ndɨ kʉgbɛ, omisikana ka ɓapa ɓa yasɨ. ");
INSERT INTO lik_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Nɨyɔ Balanaba na Saulo ɓama ndɨ ligubo kaɓʉ ka Yelusalɛma, ɓɨga kʉwa ndɨ pa imoti na Yuani nɨnɔ ɓamakaga ndɨ gɔnɨ ɓɛ Malɨkɔ. ");
INSERT INTO lik_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Kʉsɔ wa kanisa ya Atiokia, a ndɨ na ɓogyalandʉ na ɓowonisilo. Luga kaɓʉ, a ndɨ nɨ: Balanaba, Simioni nɨnɔ ɓamakaga ndɨ gɔnɨ ɓɛ Mʉtʉ Wopi, Lukio mʉtʉ wa Kulɛnɛ, Manaeni nɨnɔ ɓopinga ndɨ na ngama Ɛlɔdɨ Atipasɨ sɛ kʉwa Saulo. ");
INSERT INTO lik_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Lɨsyɛ limoti, ɓa ndɨ kabibiso Mombukwono-dosu nɨ ɓanoginyo gɔnɨ malɨlɨ. Kʉwa wa, Lɨmbɛngɨ-Lotu aɓɨkya ndɨ ɓɛ: «Itilyoni di Balanaba na Saulo ka ligubo nɨlɔ nʉmakaga ndɨ mino.» ");
INSERT INTO lik_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Kumbusa koginyo malɨlɨ na kalʉmba, ɓubisilya kʉwa ndɨ maɓɔkʉ, ɓʉpá kʉwa ndɨ lɨgʉndʉ. ");
INSERT INTO lik_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Kʉwa wa, Lɨmbɛngɨ-Lotu ʉtɨka ndɨ Balanaba na Saulo ka lɨsʉ la Seleukia. Kʉ ɓɛyɔ, ɓaɗaka ndɨ ka bato, ɓaga ko uzu ya Kipulo. ");
INSERT INTO lik_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Nɨyɔ ɓosila ka Salamɨ, ɓaɓɨkyaga ndɨ mongoni ko Kunzi ka ɓandaɓʉ ɓaya malʉmba ka Ɓayuda. Yuani-Malɨkɔ a ndɨ pa imoti na ɨɓʉ, anusingyo gɔnɨ ka ligubo. ");
INSERT INTO lik_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Kʉwa wa, ɓakpata ndɨ uzu wasɨ, ɓadwɛ ka gʉɗʉ wa Pafɔ. Kʉ ɓɛyɔ, ɓatakanya ndɨ mʉkɨma ɓanɛkɔ ɓemoti nɨnɔ ɨna ndɨ ɓɛ Bala-Yeso. A ndɨ Muyuda, ɨvaga ndɨ abɛ mugyalandʉ. ");
INSERT INTO lik_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ɓikaga ndɨ na ngama wa iwili ɓɛyɔ ka Seligio-Pɔlɔ nɨnɔ a ndɨ na yimibo yakpʉ. Ngama yi nɨnɔ ʉmaka kʉwa ndɨ Balanaba na Saulo kʉ kakɨ, kyɛ a ndɨ na mʉsasa kaʉkana lɨkpʉmʉka ko Kunzi. ");
INSERT INTO lik_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Luki limoti, Ɨlɨma (Isi yo lino li nɨlɔ ka Ligiliki nɨ mʉkpɨma ɓanɛkɔ) obisa ndɨ ɗongoso na ɨɓʉ, kyɛ kɛgʉ ndɨ kapa ɓɛ ngama abaɨlyɨ. ");
INSERT INTO lik_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Saulo nɨnɔ ina ndɨ gɔnɨ ɓɛ Pɔlɔ, otuma ndɨ na Lɨmbɛngɨ-Lotu, anda Ɨlɨma ɓɨngbangbangba, ");
INSERT INTO lik_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ɨyɨ aka na ɨyɨ ɓɛ: «Wa mika mumuyoniso, wa mutumo na ɓokoli ɓɨɗɛ, wa mʉtʉ wa kʉɓɔɓɔkʉ kʉgbɛ! Wakagyɨgʉ lɨkpʉmʉka la lɨngʉnʉ! Wasa kʉwa ndɛkɛ koɓuna muki ka ɓopisi ɓaya ɓungbingbili ka Mombukwono-dosu ngbingo tino? ");
INSERT INTO lik_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Hʉkana, mbɨya wanʉ, Mombukwono-dosu akaugyogyiso, wakagʉna koloɓu ya mamɔmɔ. Ko ngbingo ɓemoti ɓɛnɛ, wakɨnɨgʉ ɓanʉ ɓata mangbamʉ ma mɔnɨ.» Kolipyagʉ ɓata ndɨ, miso apiyo Ɨlɨma ɓipi, ingya ndɨ ko biti nɨyɔ yopi. Apʉnga kʉwa ndɨ kaamama ɓɨgbagbagba kakɨsa mʉtʉ nɨnɔ akwanana kakpokyoniso. ");
INSERT INTO lik_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Nɨyɔ ngama ɨna lɨkpʉmʉka nɨlɔ igyonosa ndɨ lɔ, aɓɨnɨkyana ndɨ. A ɓɛyɔ, lɨkpʉmʉka ka Mombukwono-dosu atʉngana ndɨ pima. ");
INSERT INTO lik_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Katʉkya ka Pafɔ, Pɔlɔ na ɓatʉ nɨɓɔ ɓa ndɨ na ɨɓʉ ɓaɗaka ndɨ ka bato, ɓɨnda miso ya Peliga ka iwili ya Pamufilia. Kʉ ɓɛyɔ, Yuani-Malɨkɔ ʉsa ndɨ, ɨga ka Yelusalɛma. ");
INSERT INTO lik_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ɓidukulaga ndɨ na lɨgʉndʉ kaɓʉ katʉkya ka Peliga ɓadwɛ ndɨ ka Atiokia nɨnɔ ka Pisidia. Ka Lɨsyɛ la kimumbiso, ɓogulya ndɨ ka ndaɓʉ ya malʉmba ka Ɓayuda, ɓikonono. ");
INSERT INTO lik_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Nɨyɔ ɓama katangʉlaga ka kɨtaɓʉ ya Mʉtʉʉ ka Musa na nɨyɔ ka Ɓogyalandʉ, ɓangama ɓa ndaɓʉ ya likungoni yi nɨyɔ, ɓatɨka ndɨ mʉmbanzʉ kaʉɓɨkya kʉwa ɓɛ: «Ɓomika-mama, makika na lɨkpʉmʉka nɨlɔ utumiso ɓambanzʉ mambɛngɨ, makwanana kaɓɨkya!» ");
INSERT INTO lik_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pɔlɔ amaga ndɨ, ʉgbʉma na maɓɔkʉ, ʉɓɨkya ɓɛ: «Hukononi, iɓunu ɓomikya Ɓezaleli na iɓunu ɓatʉ ɓagɔgɔ nɨɓɔ mabibisogo Kunzi! ");
INSERT INTO lik_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Kunzi wa lɨvananzo li nɨlɨ, Kunzi ka Ɓezaleli upunogoni ndɨ ɓotitosu. Umbuwisa ndɨ ngbingo yi nɨnɔ ɓa ndɨ mino ɓobiko ka Misili. Kumbuso yi, upupisoku ndɨ pisi ko ngu kakɨ. ");
INSERT INTO lik_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Abɨnɨka ndɨ ɓuti kaɓʉ ka ɨsa ka ɓyanga banda ɓatɛkɛɓɛ-ɓakwanganya. ");
INSERT INTO lik_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Kumbuso yi, olumwisaga ndɨ ɓɛvananza maɗɨya na ɨka ka Kanana. Ava kʉwa ndɨ giyo kaɓʉ, ʉpá lɨvananza kakɨ ɓɛ iki lisimo kaɓʉ. ");
INSERT INTO lik_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Masɨ nɨmɔ igyonosa ndɨ ka ɓyanga banda ɓamɨya ɓakwanganya na ɓatɛkɛɓɛ kuɓukumuti. Kumbuso yi, Kunzi umomosilyo kʉwa ndɨ ɓotitosu ɓazozi, kadwɛ ko ngbingo ka mugyalandʉ Samueli. ");
INSERT INTO lik_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Kʉwa wa, ɓotitosu ɓakʉnga ndɨ ngama. Kunzi ʉpá Saulo nɨnɔ a ndɨ mika Kisi ka lɨbaba ka Benyamini. Alya ndɨ ɓʉngama ka ɓyanga ɓatɛkɛɓɛ ɓakwanganya. ");
INSERT INTO lik_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Kumbuso katʉmba Saulo, Kunzi apá ndɨ Daudi ɓʉngama. Kunzi mombukwana-dakɨ aɓɨkya ndɨ ko bulya ka Daudi ɓɛ: ‹Naminini Daudi mika Yɛsɛ, nasyɛ lɨmbɛngɨ kʉ kakɨ, agyaga ndɛkɛ sɨpananɨsɔ kamɨ.› ");
INSERT INTO lik_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Kunzi ʉwanyaga ndɨ ɓomikya Ɓezaleli mʉtʉ ɓemoti ka lɨvananza ka Daudi. Mʉtʉ yi nɨnɔ ina ndɨ ɓɛ Yeso, Muhukuso ka Ɓezaleli. ");
INSERT INTO lik_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Kambwa Yeso kodoku, Yuani ʉɓɨkyagatʉ ndɨ ɓomikya Ɓezaleli ɓasɨ ɓɛ ɓoyikosi yɨgya kaɓʉ, ɓiɓotisiso. ");
INSERT INTO lik_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ngbingo yi nɨnɔ Yuani a kʉwa ndɨ mino ɓuwobi na muliɓo ma ligubo kakɨ, uusaga ndɨ ɓɛ: ‹Masɨmaga ɓɛ ɨmɨ nɨ wanɨ? Ɨmɨ nakɛgʉ mʉtʉ yi nɨnɔ makaɓʉndaga. Luki limoti, ɨyɨ akodoku kumbuso kamɨ. Nakokwononigʉ gʉtʉgʉ kakʉla ligi ya ɓɛkpakʉ kakɨ.› ");
INSERT INTO lik_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Ɓomika-mama, iɓunu lɨvananza ka Abalahamʉ na iɓunu ɓatʉ ɓagɔgɔ nɨɓɔ mabibisogo, Kunzi otikoku ndɨ mongoni ma muhukuso mi nɨma ko bulya kusu. ");
INSERT INTO lik_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ɓatʉ ɓa Yelusalɛma na ɓangama kaɓʉ ɓakamibagʉ ndɨ Yeso. Ɓakotombisyagʉ ndɨ ɓɨnza moɓiso ka ɓogyalandʉ nɨmɔ ɓatangʉlaga ndɨ ka Masyɛ masɨ ma kimumbiso. Luki limoti, ɓotulyosa ndɨ moɓiso mi nɨmɔ pisi kakɔ ngbanga ka Yeso. ");
INSERT INTO lik_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Gʉtʉgʉ ɓɛyɔ ɓakɨnagʉ ndɨ mino ɨɓɔ gʉtʉgʉ imoti aka nɨyɔ okwononi ndɨ ɓɛ ɓamwisisi mino, ɓakʉnga ndɨ Pilatʉ ɓɛ ɓamwɨ. ");
INSERT INTO lik_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Nɨyɔ ɓotulyoso masɨ nɨmɔ ikpikaga ndɨ ko bulya kakɨ, ɓasisoku ndɨ katʉkya ka mʉsalaba, ɓalumbo. ");
INSERT INTO lik_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Luki limoti, Kunzi apupisa ndɨ ka mbʉkʉ. ");
INSERT INTO lik_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Kʉsɔ wa masyɛ mudingi, Yeso upuponilyaga ndɨ ɓatʉ nɨɓɔ ɓɨndaga ndɨ pa imoti na ɨɓʉ katʉkya ka Galilaya na kadwɛ ka Yelusalɛma. Mbɨya wanʉ, ɨɓʉ ɓatʉ ɓi nɨɓɔ ɓa kʉwa ɓadɛmʉ kakɨ kambwa ka ɓambanzʉ. ");
INSERT INTO lik_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Iɓusu takamʉɓɨkyaga kʉwa Mongoni Manza mi nɨmɔ Kunzi ʉwanyaga ndɨ ɓotitosu, ");
INSERT INTO lik_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","otulyosoni ko bulya kusu, puponogo kaɓʉ, apupisa ndɨ Yeso ka mbʉkʉ. Ikpikaga ka Mambʉ, kʉpakʉkɔ kwa maɓa ɓɛ: ‹Ɨwɛ wa Mikamɨ mʉlʉkʉ yi, na lɨsyɛ li nɨlɨ, ɨmɨ niitoni kʉwa abakʉ.› ");
INSERT INTO lik_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Kunzi apupisatʉ ndɨ ka mbʉkʉ kyɛ koponi. Aɓɨkya ndɨ ɓɛ: ‹Namʉpátʉ ndɛkɛ ɓʉɓʉnga ɓotu na nɨɓɔ ɓa lɨngʉnʉ, nɨmɔ nawanyaga ndɨ Daudi.› ");
INSERT INTO lik_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Kinili, akaɓɨkya gɔnɨ ka moɓiso magɔgɔ ɓɛ: ‹Wakakwananɨgʉ ndɛkɛ kasa mʉgya-ligubo kakʉ Wotu kapɔ ka mbʉkʉ.› ");
INSERT INTO lik_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Ngbingo yi nɨnɔ Daudi a mbɛyɨ ndɨ mino ka ɔɓɨlɨ, agyaga ndɨ mogubo mʉɗɔngɔnɨ ɓɛyɔ Kunzi akpamyaga ndɨ mino. Kumbuso yi, okwo, ɓalumba ndɨ ka kpɔlɔ ka ɓatɨtakɨ, apɔ. ");
INSERT INTO lik_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Luki limoti, mʉtʉ yi nɨnɔ Kunzi apupisa ndɨ ka mbʉkʉ, kapɔgʉ ndɨ ɨyɨ. ");
INSERT INTO lik_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Ɓomika-mama, wiboni ambɛ: Na lɨsyɛ li nɨlɨ, minisono na mʉpɨlya pisi ka Yeso. Gʉtʉgʉ mʉtʉʉ ka Musa aka kakwananagʉ ndɨ kamʉkʉlaga ka ɓʉnyɛ. ");
INSERT INTO lik_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Luki limoti, mʉtʉ wasɨ nɨnɔ abaya Yeso, inisononi na ɓungbingbili. ");
INSERT INTO lik_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ɛɛɛ, wiminyonito nɛkɨ kyɛ kamusilyonito nɨlɔ ikpikaga ka ɓakɨtaɓʉ ka ɓogyalandʉ ɓɛ: ");
INSERT INTO lik_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‹Iɓunu ɓatʉ ɓakɨbɨnɨka, hukononi! Gwoni ombombo, tukyoni ko misa ka mɨ! Kyɛ, ɨmɨ, nakamʉgyɨlya lɨkpʉmʉka lɨmbanga, ɓakamʉtʉmbʉlyaga yi, makaɓɨnɨkyanɨgʉ!›» ");
INSERT INTO lik_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Nɨyɔ Pɔlɔ ɨɓʉ na Balanaba ɓopupa ndɨ ka ndaɓʉ ya malʉmba, ɓʉɓɨkya ndɨ ɓɛ ɓɨgɨlyɨtɔ ɓata mʉtʉʉ mi nɨmɔ aka mɔ ka Lɨsyɛ la kimumbiso nɨlɔ akodoku. ");
INSERT INTO lik_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Kumbusa wa musilyoni, Ɓayuda ɓudingi na ɓatʉ ɓi nɨɓɔ ɓabaya ndɨ ka kanisa ka Ɓayuda, ɓaɓyɛ ndɨ Pɔlɔ na Balanaba, ɓananzɨna na ɨɓʉ, ɓanutumiso mambɛngɨ ɓɛ ɓakosonononitɔgʉ na mazɨyɔ ko Kunzi. ");
INSERT INTO lik_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ka Lɨsyɛ la kimumbiso lagɔgɔ, ɓambanzʉ banda ɓasɨ ɓa gʉɗʉ ɓamʉmʉkana ndɨ kaʉkana lɨkpʉmʉka ka Mombukwono-dosu. ");
INSERT INTO lik_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Nɨyɔ Ɓayuda ɓʉmɨna ɓambaza ka ɓambanzʉ ɓɛyɔ, ɓotuma ndɨ na imi ɓɨɗɛ. Ɓapʉnga kʉwa ndɨ koyikoso di masɨ nɨmɔ Pɔlɔ a ndɨ kaɓɨkyaga, ɓaɓuɓiso ɓitu. ");
INSERT INTO lik_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Kʉwa wa, Pɔlɔ ɨɓʉ na Balanaba ɓʉɓɨkya ndɨ nɨ ɓakɛgʉ na kʉɓangakʉ ɓɛ: «Okwononi mbɛyɨ ɓi ɓɛ ɓamʉɓɨkyagɨ iɓunu Ɓayuda lɨkpʉmʉka ko Kunzi. Yɛkɨ makɛgʉ kabaɨlya, manɨmɨna ɓɛ makokwononigʉ na ɔɓɨlɨ wa ɓɛnzɛ na ɓɛnzɛ, kinili, iɓusu takaaga kʉwa miso ka ɓatʉ nɨɓɔ ɓakɛgʉ Ɓayuda. ");
INSERT INTO lik_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","A ɓɛyɔ, Mombukwono-dosu atɨkpamya ndɨ ɓɛ: ‹Nʉpʉnaga ndɨ kaiko ɓʉngbanganya ka ɓatʉ ɓagɔgɔ, kokpokyoniso mongoni ma muhukuso kadwɛ ka muliɓo ma ɔɓɨlɨ.›» ");
INSERT INTO lik_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ngbingo yi nɨnɔ ɓatʉ ɓi nɨɓɔ ɓakɛgʉ ndɨ Ɓayuda ɓʉkana mino ɓɛyɔ, ɓogwa magyagya. Ɓobibisa ndɨ lɨkpʉmʉka ko Mombukwono-dosu. Ɓasɨ nɨɓɔ Kunzi ʉpʉnaga ndɨ ka ɔɓɨlɨ wa ɓɛnzɛ na ɓɛnzɛ, ɓabaɨlya ndɨ. ");
INSERT INTO lik_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Lɨkpʉmʉka ko Mombukwono-dosu ɨtʉlyana ndɨ ka mutili mi nɨmɔ masɨ. ");
INSERT INTO lik_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Luki limoti, Ɓayuda ɓuvikimosaga kʉwa ndɨ ɓoko nɨɓɔ ɓakimibisikono ka ɓagʉɗʉ nɨɓɔ ɓabibisaga ndɨ Kunzi pa imoti na ɓatʉ ɓagɔgɔ ɓakinisono ka ɓagʉɗʉ. Ɓatʉ ɓi nɨɓɔ ɓʉgyagya kʉwa ndɨ Pɔlɔ na Balanaba, ɓukpumyo kʉ kaɓʉ. ");
INSERT INTO lik_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ɓaga ndɨ nɨ ɓanɨbʉmaga liɓungu la ɓakagba kaɓʉ, ɓɨnda ndɨ ka gʉɗʉ yi nɨnɔ ina ɓɛ Ikonio. ");
INSERT INTO lik_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Kʉ ka Atiokia kʉ, ɓaɓɨɓya ɓotigala ndɨ nɨ ɓotumini na magyagya na Lɨmbɛngɨ-Lotu ɓɨɗɛ. ");
INSERT INTO lik_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Kʉ ka Ikonio kʉ, Pɔlɔ na Balanaba ɓogulya ndɨ ka ndaɓʉ ya malʉmba ka Ɓayuda. Mʉnzɨna kaɓʉ ʉdwa ndɨ ɓambanzʉ mambɛngɨ, ɓatʉ ɓudingi ɓabaɨlya ndɨ, iki Ɓayuda na gʉtʉgʉ ɓatʉ nɨɓɔ ɓakɛgʉ ndɨ Ɓayuda. ");
INSERT INTO lik_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Luki limoti, Ɓayuda nɨɓɔ ɓakabaɨlyagʉ ndɨ ɓʉ, ɓuvikimosogo ɓatʉ nɨɓɔ ɓakɛgʉ ndɨ Ɓayuda kaʉmʉya nɨɓɔ ɓabaɨlya ndɨ. ");
INSERT INTO lik_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Gʉtʉgʉ ɓɛyɔ, Pɔlɔ na Balanaba ɓika ndɨ mututu manda ka Ikonio. Ɓa ndɨ ɓakɨgʉmya ka Mombukwono-dosu, ɓanzɨnaga ndɨ nɨ ɓakɛgʉ na kʉɓangakʉ. Ɨyɨ Mombukwono-dosu ʉpá ndɨ ngu yɨgya makpʉmʉka mʉmbanga-mbanga na mokingyosi. Owonisa ndɨ gɔnɨ ɓɛ nɨlɔ ɓa ndɨ kaɓɨkyaga ko bulya mazɨyɔ kakɨ a ndɨ la lɨngʉnʉ. ");
INSERT INTO lik_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Kʉsɔ wa gʉɗʉ, ɓambanzʉ ɓɨgbananaga ndɨ: liɗu limoti a ndɨ ka nakpangbala ka Ɓayuda, lagɔgɔ ka ɓatʉtʉmbwa. ");
INSERT INTO lik_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ɓayuda, ɓatʉ nɨɓɔ ɓakɛgʉ ndɨ Ɓayuda pa imoti na ɓangama kaɓʉ, ɓʉkanana ndɨ kaugyogyiso Pɔlɔ na Balanaba na kaʉmwɔ na matamʉ. ");
INSERT INTO lik_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Nɨyɔ Pɔlɔ na Balanaba ɓʉkana mino lɨkpʉmʉka li nɨlɔ, ɓapɨkɨta ndɨ miso ya ɓagʉɗʉ ɓa Likaonia ɓi nɨɓa: Lusetula, Delibe na ɓuwobi-ɓuwobi yi. ");
INSERT INTO lik_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Kʉ ɓɛyɔ, ɓidukulaga ndɨ gɔnɨ kaɓɨkyaga Mongoni Manza. ");
INSERT INTO lik_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Kʉ ka Lusetula, a ndɨ na alʉkʉ ɓemoti nɨnɔ ɨɓʉkʉta ndɨ zɛgɛsɨ, kakpakyanagʉ. ");
INSERT INTO lik_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Lɨsyɛ limoti a ndɨ kamʉkana Pɔlɔ nɨ akanzɨna. Pɔlɔ anda kʉwa ndɨ ɓɨngbangbangba, ɨna ɓɛ a na baya nɨyɔ akwanana kahukuso. ");
INSERT INTO lik_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Ɨyɨ aka ndɨ na ɨyɨ na lɨyʉ lapʉ ɓɛ: «Wamaga!» Alʉkʉ nɔ aka ndɨ ɓɨndɔmʉ, amaga, apʉnga kakpakyana. ");
INSERT INTO lik_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Nɨyɔ ɓambaza ka ɓambanzʉ ɓa Likaonia ɓɨna nɨlɔ Pɔlɔ agya ndɨ lɔ, ɓapamɨkanaga ndɨ na lɨva-kʉkaɓʉ ɓɛ: «Ɓokunzi ɓiitini abɛ ɓambanzʉ, ɓosiliniku kʉnʉ ku kusu.» ");
INSERT INTO lik_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ɓalʉka ndɨ Balanaba ɓɛ Zeusi, Pɔlɔ ɓɛ Elime, kyɛ ɨyɨ nɔ anzɨnaga ndɨ. ");
INSERT INTO lik_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Kumu ɓemoti ka Zeusi odoku ndɨ kunzi wa mupumi ma gʉɗʉ na ɓangɔmbɛ ɓomumu ɓi ɓubongogini maʉwa. Ɓʉkanana ndɨ na ambaza ka ɓambanzʉ ɓɛ ɓupíku ɓatʉtʉmbwa ka apɛpɛ. ");
INSERT INTO lik_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Luki limoti, nɨyɔ Balanaba na Pɔlɔ ɓʉkana mongoni mi nɨmɔ, ɓɨyɨɓaga ndɨ ɓotu, ɓɨnda kʉwa ndɨ ɓɨgala-gala luga wa ambaza ka ɓambanzʉ, ɓanapamɨkanaga ɓɛ: ");
INSERT INTO lik_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","«Ɓomika-mama, ko bulya ɨkɨ yɔ mo mino kagya ɓɛyɔ? Iɓusu ta ɓambanzʉ, mʉɗɔngɔnɨ abɛ iɓunu gɔnɨ. Kika nɨ takamʉɓɨkyaga Mongoni Manza a kyɛ wosoni makpʉmʉka ma gbalɨ, mamigilyoku Kunzi walɨngʉnʉ nɨnɔ agya ndɨ lɨsyɛ, lɨtɔmbʉ, moɓo na masɨ nɨmɔ a kʉsɔ yi. ");
INSERT INTO lik_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ka ɓʉndɛlɨ ndɨ, Kunzi ʉsa ndɨ ɓambanzʉ ɓasɨ kagya ɓɛyɔ ɓɨnaga ndɨ mino. ");
INSERT INTO lik_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Luki limoti, Kunzi kasagʉ ndɨ kaiwoniso pisi kagya ɓʉnza. A ɓɛyɔ, amulukusyaga mbwayɨ, amʉpá masɔlɔ ma ɓotiko ka ɓongbingo ɓi, amʉpá malɨlɨ, amutumisa na magyagya ɓɨɗɛ.» ");
INSERT INTO lik_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Gʉtʉgʉ mʉnzɨna mi nɨmɔ, Pɔlɔ na Balanaba ɓa ndɨ na ɓʉkpɛkɨ-kpɛkɨ aka kaʉɓɨkya ɓambaza ɓɛ ɓakupónitɔgʉ apɛpɛ. ");
INSERT INTO lik_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ɓayuda nɨɓɔ ɓotukyoku ndɨ ka Atiokia na Ikonio, ɓavikimosaga ndɨ ambaza ka ɓambanzʉ. Ɓatʉ ɓi nɨɓɔ ɓayipaga ndɨ Pɔlɔ na matamʉ, ɓaluto kunzi wa gʉɗʉ, ɓanasɨma ɓɛ okwini. ");
INSERT INTO lik_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Luki limoti, nɨyɔ ɓaɓɨɓya ɓamʉmʉkana ndɨ ka kpɔlɔ kakɨ, Pɔlɔ amaga ndɨ, ɨga ka gʉɗʉ. Ɓʉgala ɓi, ɓaga ndɨ na Balanaba ka Delibe. ");
INSERT INTO lik_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Pɔlɔ na Balanaba ɓaɓɨkyaga ndɨ Mongoni Manza ka gʉɗʉ wa Delibe, ɓinisono na ɓaɓɨɓya ɓudingi. Kumbuso yi, ɓɨga ndɨ ka gʉɗʉ wa Lusetula, wa Ikonio na wa Atiokia nɨnɔ kʉ ka Pisidia. ");
INSERT INTO lik_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Kʉ ɓɛyɔ, ɓutumisa ndɨ ɓaɓɨɓya mambɛngɨ, ɓʉɓɨkya ɓɛ ɓigwinonogi yapʉ ka baya. Ɓʉɓɨkya ndɨ gɔnɨ ɓɛ: «Tokwononi kakɨtaga ka ɓʉkpɛkɨ-kpɛkɨ ɓudingi kambwa kaingyo ka Ɓʉngama ko Kunzi.» ");
INSERT INTO lik_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Pɔlɔ na Balanaba ɓʉpʉnɨlyaga ndɨ ɓazɛɛ ka ɓakanisa yimoti-yimoti. Kumbuso kalʉmba na koginyo malɨlɨ, ɓubisa ndɨ ka maɓɔkʉ ka Mombukwono-dosu nɨnɔ ɓaɓɨnɨkyana ndɨ. ");
INSERT INTO lik_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Kumbuso yi, Pɔlɔ na Balanaba ɓakɨtanaga ndɨ ka iwili ya Pisidia, ɓadwɛ ka Pamufilia. ");
INSERT INTO lik_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ɓʉɓɨkyaga ndɨ gɔnɨ ɓambanzʉ Lɨkpʉmʉka ko Kunzi ka Peliga. Kumbuso yi, ɓaga ndɨ ka Atalia. ");
INSERT INTO lik_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Katʉkya wa, ɓaɗaka ndɨ ka bato, ɓɨga ka Atiokia, kʉ, ɓubisa ndɨ mino ka maɓɔkʉ ko Kunzi ka ligubo nɨlɔ ɓa ndɨ nɨ ɓogyini. ");
INSERT INTO lik_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Nɨyɔ ɓosila ndɨ ka Atiokia, ɓʉmʉmʉla ndɨ ɓatʉ ɓa kanisa, ɓʉtʉmbʉlyaga masɨ nɨmɔ Kunzi ʉgyɨlya ndɨ. Ɓʉtʉmbʉlyaga gɔnɨ ɓɛyɔ Kunzi uhukwilya ndɨ mino ɓatʉ nɨɓɔ ɓakɛgʉ ndɨ Ɓayuda mupumi ma baya. ");
INSERT INTO lik_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Pɔlɔ na Balanaba ɓasyɛsyɛ ndɨ ɓata ɓɨndɨ pa imoti na ɓaɓɨɓya. ");
INSERT INTO lik_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ɓatʉ ɓemoti-ɓemoti ɓotukyoku ndɨ ka Yudɛa, ɓosya ka Atiokia. Kʉ ɓɛyɔ, ɓapʉnga ndɨ kaʉtɨwa ɓatʉ nɨɓɔ ɓabaya ndɨ ɓɛ: «Makikusisi mʉɗɔngɔnɨ ɓɛyɔ mʉtʉʉ ka Musa aɓɨkya mino, makakwananɨgʉ kainisono na muhukuso.» ");
INSERT INTO lik_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Lɨkpʉmʉka atʉkya ndɨ ka ɓakpɨɓa, Pɔlɔ na Balanaba ɓapʉnga ndɨ kasaana na ɓatʉ ɓi nɨɓɔ. Ɓʉkanana kʉwa ndɨ ɓɛ Pɔlɔ, Balanaba pa imoti na ɓatʉ ɓagɔgɔ luga kaɓʉ ɓaɗakɨ ka Yelusalɛma kainzinzinyoku pa imoti na ɓatʉtʉmbwa na ɓazɛɛ ɓa kanisa ko bulya lɨkpʉmʉka li nɨlɔ. ");
INSERT INTO lik_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ka lɨgʉndʉ li nɨlɔ, kanisa ʉpá ndɨ makpʉmʉka nɨmɔ okwononi kabɨnɨka ɓuti kaɓʉ. Ɓakɨtanaga ndɨ ko giyo ya Foinikia na Samalia, ɓanatʉmbʉlaga ɓɛyɔ ɓatʉ nɨɓɔ ɓakɛgʉ ndɨ Ɓayuda ɓabaya ndɨ mino Kunzi. Mongoni mi nɨmɔ ʉpá ndɨ ɓakilisito magyagya kʉgbɛ. ");
INSERT INTO lik_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Nɨyɔ ɓosilo ka Yelusalɛma, kanisa, ɓatʉtʉmbwa pa imoti na ɓazɛɛ ɓa kanisa ɓʉtɨlya ndɨ. Kʉwa wa, ɓʉtʉmbʉlyaga ndɨ masɨ nɨmɔ Kunzi ʉgyɨlya ndɨ. ");
INSERT INTO lik_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Luki limoti, Ɓafalisayɔ ɓemoti-ɓemoti nɨɓɔ ɓabaya ndɨ, ɓamaga ndɨ, ɓaɓɨkya ɓɛ: «Okwononi ɓɛ ɓatʉ nɨɓɔ ɓabaya nɨ ɓakɛgʉ Ɓayuda ɓikusisi, ɓʉkpamya kagya mʉtʉʉ ka Musa.» ");
INSERT INTO lik_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Kʉwa wa, ɓatʉtʉmbwa pa imoti na ɓazɛɛ ɓa kanisa ɓamʉmʉkana ndɨ kakpɨma lɨkpʉmʉka li nɨlɔ. ");
INSERT INTO lik_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Nɨyɔ ɓagya ɓoɗongoso ɓɨndɨ, Pɛtɛlɛ amaga ndɨ, ɨyɨ aka ndɨ na ɨɓʉ ɓɛ: «Ɓomika-mama, makaiba ɓɛ Kunzi epunogoni ndɨ ndɛlɨ aka luga kunu kaɓɨkyaga Mongoni Manza ka ɓatʉ nɨɓɔ ɓakɛgʉ Ɓayuda, ɓɛ kyɛ ɓʉkanɨ, ɓabaɨlya. ");
INSERT INTO lik_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Kunzi nɨnɔ ibaga mambɛngɨ ka ɓambanzʉ, owoniso ɓɛ uhukwilyoni ndɨ ɓatʉ ɓi nɨɓɔ ɓakɛgʉ Ɓayuda pisi kaʉpá Lɨmbɛngɨ-Lotu, mʉɗɔngɔnɨ ɓɛyɔ atɨpá ndɨ mino gɔnɨ iɓusu. ");
INSERT INTO lik_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ɨyɨ kamakyagʉ ndɨ lɨbaba luga kusu na ɨɓʉ, oɓuɓisa ndɨ mambɛngɨ kaɓʉ ɓitu kyɛ ɓaboilyoni. ");
INSERT INTO lik_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Mbɨya wanʉ, ko bulya ɨkɨ yɔ makɛgʉ mino kaɓanga Kunzi? Makapa kaubinikiso ɓaɓɨɓya ɓuti ɓa likumbogi nɨlɔ iki ɓotitosu, iki iɓusu ɓamombukwono-dosu takakwananɨgʉ ndɨ kabɨnɨka? ");
INSERT INTO lik_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","A ɓɛyɔ, ta na baya ambɛ tinisana na muhukuso pisi ka ɨzɨyɔ ka Mombukwono-dosu Yeso mʉɗɔngɔnɨ abɛ ɨɓʉ.» ");
INSERT INTO lik_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Kʉwa wa, ɓatʉ ɓasɨ nɨɓɔ ɓa ndɨ wa ɓadakyana ndɨ ɓiwo. Ɓapʉnga ndɨ kamʉkana Pɔlɔ ɨɓʉ na Balanaba ɓɛyɔ ɓa ndɨ mino katʉmbʉlaga mokingyosi masɨ na makpʉmʉka mʉmbanga-mbanga nɨmɔ ɓagya ndɨ ko ngu ko Kunzi ka ɓatʉ nɨɓɔ ɓakɛgʉ Ɓayuda. ");
INSERT INTO lik_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Nɨyɔ ɓama kanzɨna, Yakɔbɔ aka ndɨ ɓɛ: «Ɓomika-mama, imukononi mbɛyɨ! ");
INSERT INTO lik_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simoni atitumbulyogini ɓɛyɔ Kunzi uɓuulyaga ndɨ mino ɓatʉ nɨɓɔ ɓakɛgʉ ndɨ Ɓayuda katʉkya ka ɓʉndɛlɨ, kyɛ ɨpʉnɨlyagɨ lɨvananza limoti luga kaɓʉ. ");
INSERT INTO lik_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Lɨkpʉmʉka li nɨlɔ a mʉɗɔngɔnɨ na mʉnzɨna ka ɓogyalandʉ ɓɛyɔ ikpikaga mino ka Moɓiso Motu ɓɛ: ");
INSERT INTO lik_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‹Kumbusa wa lɨkpʉmʉka li nɨlɔ, nigokuto ndɛkɛ, nomosa ndɛkɛ ɓata ndaɓʉ ka Daudi nɨyɔ oɗukana ndɨ, nopikatʉ ndɛkɛ ɓata, nomosa ɓɨgbʉ, ");
INSERT INTO lik_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","kyɛ ɓatʉ ɓagɔgɔ ɓasɨ ɓamigilyiku Mombukwono-dosu, iyo, ɓatʉ ɓa mababa masɨ nɨmɔ nɨpʉnɨlyaga ndɨ, ɓiki ɓatʉ kamɨ ɓɨkpɛ. ");
INSERT INTO lik_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Mombukwono-dosu aɓɨkya ɓɛyɔ, oɓikyoni ndɨ lɨkpʉmʉka li nɨlɔ ndɛlɨ.›» ");
INSERT INTO lik_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Yakɔbɔ idukulaga ndɨ kanzɨna ɓɛ: «Kinili, ɨmɨ, na na mʉtamanagɨ ambɛ kokwononigʉ kauɓukutisilyo ɓatʉ nɨɓɔ ɓamigilyoku Kunzi nɨ ɓakɛgʉ Ɓayuda makpʉmʉka nganga. ");
INSERT INTO lik_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Luki limoti, okwononi tukpikilyi ɓɛ: ɓakulyonitɔgʉ ɓanyama ɓi nɨɓɔ ɓʉpága ka ɓokunzi, ɓasɨ ɓʉɗanda, ɓakulyonitɔgʉ ɓanyama ɓi nɨɓɔ ɓʉmwɔgɔ kanɨ ɓudulini ɓasɔngʉ ikanɨ kalya ɓangʉ ");
INSERT INTO lik_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","A ɓɛyɔ, katʉkya ka ɓʉndɛlɨ, ɓambanzʉ ɓopungoni ndɨ kaɓɨkyaga Mʉtʉʉ ka Musa ka ɓagʉɗʉ ɓasɨ. Ka masyɛ masɨ ma kimumbiso, ɓikaga ndɨ katangʉlaga gɔnɨ Mʉtʉʉ mi nɨmɔ ka ɓandaɓʉ ɓaya malʉmba ka ɓayuda.» ");
INSERT INTO lik_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Kʉwa wa, ɓatʉtʉmbwa, ɓazɛɛ ɓa kanisa na kanisa wasɨ ɓʉkanana ndɨ kaʉpʉnaga ɓambanzʉ luga kaɓʉ, na kaʉtɨka pa imoti na Pɔlɔ ɨɓʉ na Balanaba ka Atiokia. Ɓapʉnaga ndɨ Yuda nɨnɔ ɨna ndɨ gɔnɨ ɓɛ Balisaba na Sila. Ɓalʉkʉ ɓaɓa ɓi nɨɓɔ ɓa ndɨ ɓatʉ ɓa kinisono luga ka ɓakilisito. ");
INSERT INTO lik_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ɓʉtɨka kʉwa ndɨ na balʉwa yi nɨmʉ: «Iɓusu ɓatʉtʉmbwa na ɓazɛɛ ɓa kanisa tamumuusogitɔ iɓunu ɓomomosu ka baya nɨɓɔ ɓakɛgʉ Ɓayuda kʉ ka Atiokia, ka Sulia na ka Kilikia. ");
INSERT INTO lik_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Tukoni ɓi ɓɛ ɓatʉ ɓemoti-ɓemoti ɓotukyi ɓi kʉnʉ nɨ takukpomyigʉ, ɓɨndo ɓi kamugbomiso na kamunzingimoso ɓamʉ na mʉnzɨna kaɓʉ. ");
INSERT INTO lik_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Kinili, tukononi ɓi pa imoti kaʉpʉnaga ɓambanzʉ na kamʉtɨkɨlya. Ɓatʉ ɓi nɨɓɔ ɓakpakyana pa imoti na ɓomomosu ɓa lɨmbɛngɨ ɓɛyɔ ka Balanaba na Pɔlɔ, ");
INSERT INTO lik_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ɨɓʉ ɓapóni ɔɓɨlɨ kaɓʉ kagugubyo Mombukwono-dosu Yeso-Kilisito. ");
INSERT INTO lik_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Tamutikilyito gɔnɨ Yuda na Sila. Ɨɓʉ ɓɔ ɓamʉtʉmbʉlyaga ɓɨngbanganya mongoni mi nɨmɔ tamukpikilyi mɔ. ");
INSERT INTO lik_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","A ɓɛyɔ, Lɨmbɛngɨ-Lotu pa imoti na iɓusu tini ɓi ɓɨnza ɓɛ takamubinikisoni ɓata likumbogi lagɔgɔ. Luki limoti, mokwononi kagya ɓɛ: ");
INSERT INTO lik_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Makolyonitɔgʉ makɔlɔ ka ɓanyama nɨɓɔ ɓʉpága abɛ apɛpɛ ka ɓokunzi, makolyonitɔgʉ ɓangʉ, makulyonitɔgʉ ɓanyama ɓi nɨɓɔ ɓʉmwɔgɔ kanɨ ɓudulini ɓasɔngʉ, wosoni ɓʉɗanda. Makagya ɓɛyɔ, iba mogyini ɓɨnza. Tamumuusogito ɓata.» ");
INSERT INTO lik_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Ka muliɓo, Pɔlɔ, Balanaba, Yuda pa imoti na Sila ɓatʉkya ndɨ, ɓaga ka Atiokia. Kʉ ɓɛyɔ, ɓʉmʉmʉla ndɨ ɓakilisito ɓasɨ, ɓʉpá balʉwa yi nɨnɔ. ");
INSERT INTO lik_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Nɨyɔ ɓatangʉlaga ndɨ, ɓogwa magyagya, mambɛngɨ utumo. ");
INSERT INTO lik_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yuda na Sila nɨɓɔ ɓa ndɨ ɓamombukwana-daɓʉ ɓi ɓogyalandʉ, ɓutumisa ndɨ ɓakilisito mambɛngɨ na ɓumomoso ka baya pisi ka mʉnzɨna dididi. ");
INSERT INTO lik_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ɓagya mbɛyɨ ɓata ndɨ mino masyɛ kʉ ɓɛyɔ. Kumbuso yi, ɓakilisito ɓʉpá ndɨ lɨgʉndʉ ka mazɨyɔ kaɨga ka ɓatʉ nɨɓɔ ɓutikoku ndɨ.  ");
INSERT INTO lik_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Luki limoti, Sila ɨna ndɨ ɓɨnza kotigolo kʉ ɓɛyɔ. ");
INSERT INTO lik_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pɔlɔ na Balanaba ɓasyɛsyɛ ndɨ mbɛyɨ ɓata mino ka Atiokia kʉ. Kʉ ɓɛyɔ, ɓikaga ndɨ kowonisilo na kaɓɨkyaga pa imoti na ɓatʉ ɓagɔgɔ ɓudingi lɨkpʉmʉka ka Mombukwono-dosu. ");
INSERT INTO lik_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Kumbusa wa masyɛ makɛɗɛ, Pɔlɔ aɓɨkya ndɨ Balanaba ɓɛ: «Tɨgɨ kaʉndaga ɓakilisito ka ɓagʉɗʉ ɓasɨ kʉ taɓɨkyaga ndɨ mino mongoni ko Mombukwono-dosu, tiniku mbɛyɨ ɓɛ ɓa ɓʉ.» ");
INSERT INTO lik_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Balanaba a ndɨ wakɨtʉlya ɓɛ ɓaga pa imoti na Yuani nɨnɔ ɓamakaga ndɨ gɔnɨ ɓɛ Malɨkɔ. ");
INSERT INTO lik_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Luki limoti, Pɔlɔ akya ndɨ lɨmbɛngɨ limoti, kyɛ ɨyɨ Yuani ʉsa ndɨ ɓɨgbʉ ka Pamufilia, akya ndɨ kaɨnda pa imoti na ɨɓʉ ka ligubo. ");
INSERT INTO lik_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Pɔlɔ na Balanaba ɓadwanana ndɨ kadwɛ kʉ kwa kʉ ɓasanana ndɨ mino. Balanaba ava kʉwa ndɨ Malɨkɔ, ɓaɗaka ka bato, ɓaga ko uzu wa Kipulo. ");
INSERT INTO lik_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Nɨyɔ ɓakilisito ɓʉlʉmbɨlya, Pɔlɔ ava kʉwa ndɨ ɨyɨ Sila, ɓaga. ");
INSERT INTO lik_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ɓakɨtanaga ndɨ luga wa iwili ya Sulia na nɨyɔ ya Kilikia. Kʉ ɓɛyɔ, Pɔlɔ utumisa ndɨ ɓatʉ ɓa makanisa mambɛngɨ. ");
INSERT INTO lik_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pɔlɔ osila kʉwa ndɨ ka Delibe, kumbuso yi, ka Lusetula. Kʉ ɓɛyɔ, a ndɨ na mʉɓɨɓya ɓemoti nɨnɔ ina ndɨ ɓɛ Timotio. Amakɨ a ndɨ Waɓayuda, na a ndɨ nɨ aɓinikyonini Kunzi, luki limoti, abakɨ a ndɨ ɨyɨ Mugiliki. ");
INSERT INTO lik_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Ɓakilisito nɨɓɔ ɓikaga ndɨ ka Lusetula na ka Ikonio ɓabɨbaga ndɨ Timotio kʉgbɛ. ");
INSERT INTO lik_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pɔlɔ a ndɨ kapa ɓɛ ɓiki kakpakyanaga na ɨyɨ. Akusiso kʉwa ndɨ kyɛ Ɓayuda ɓikaga ndɨ ka iwili yi nɨyɔ. A ɓɛyɔ, ɓatʉ ɓasɨ ɓibagatʉ ndɨ ɓɛ abakɨ a Mugiliki. ");
INSERT INTO lik_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ka ɓagʉɗʉ ɓasɨ nɨɓɔ ɓakɨtaga ndɨ mino, ɓikaga ndɨ kaʉɓɨkyaga ɓaɓɨɓya mʉtʉʉ nɨmɔ ɨpá ndɨ na ɓatʉtʉmbwa na ɓazɛɛ ɓa kanisa ya Yelusalɛma. Ɓʉɓɨkyaga ndɨ ɓɛ ɓaɓyɨ mʉtʉʉ mi nɨmɔ. ");
INSERT INTO lik_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Makanisa isisilaga kʉwa ndɨ kangata ka baya, ɓaɓɨɓya ɓonobwa masyɛ masɨ. ");
INSERT INTO lik_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pɔlɔ na ɓatʉ nɨɓɔ ɓɨnda ndɨ kabiso, ɓakɨtanaga ndɨ pisi aka ko giyo ya Fuligia na Galatia, kyɛ Lɨmbɛngɨ-Lotu ʉpakya ndɨ kaɓɨkyaga Mongoni Manza ko Kunzi ka iwili ya Azia. ");
INSERT INTO lik_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Nɨyɔ ɓosilo ɓuwobi na Misia, ɓakɨngɨla kaaga ka iwili ya Bitinia, luki limoti, Lɨmbɛngɨ ka Yeso ʉpakya. ");
INSERT INTO lik_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Kinili, ɓakɨtanaga kʉwa ndɨ pisi ka Misia, ɓosya ka Tolowasi. ");
INSERT INTO lik_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","No biti, Pɔlɔ alʉtaga ndɨ nziki. Amɨna ndɨ Mumakedonia ɓemoti wakamaga kambwa kakɨ, anɨtatanaga na ɨyɨ, anaɓɨkya ɓɛ: «Kikiliki, tisingyokuto gɔnɨ kʉnʉ ka Makedonia!» ");
INSERT INTO lik_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Kumbuso wo nziki yi nɨyɔ, takɨsa ndɨ kaaga ɓɨgala ka Makedonia. A ɓɛyɔ, ta kʉwa ndɨ nɨ tibini ɓɛ Kunzi nɔ atimoki kaɨnda kaɓɨkyaga Mongoni Manza kʉ ɓɛyɔ. ");
INSERT INTO lik_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Kʉwa wa, taɗaka ndɨ ka bato, tatʉkya ka Tolowasi wa, taga ngbingbili ko uzu wa Samotilake. Ɓʉgala ɓi, tosila ndɨ ka Nɛapoli. ");
INSERT INTO lik_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Katʉkya kʉ, taga ndɨ ka Filipi nɨnɔ gʉɗʉ wa mambwa ka iwili ya Makedonia. Ɓalʉma ɓɔ ɓandaga ndɨ gʉɗʉ yi nɨnɔ. Tagya ndɨ mino masyɛ kʉ ɓɛyɔ. ");
INSERT INTO lik_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ka Lɨsyɛ la kimumbiso, topupa ndɨ kunzi wa gʉɗʉ, taga ka mutili mo liɓo. A ɓɛyɔ, ta ndɨ kasɨma ambɛ tatakanyatʉ pa ya malʉmba. Tikonono kʉwa ndɨ, tapʉnga kanzɨna na ɓoko ɓi nɨɓɔ ɓa ndɨ ɓʉmʉmʉkana kʉ ɓɛyɔ. ");
INSERT INTO lik_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Lugo ko ɓoko ɓi nɨɓɔ, ɓemoti a ndɨ Waɓatuatɛla, ina ndɨ ɓɛ Ludia. Agabaga ndɨ ɓotu ɓayangbʉngbʉ ɓaya lɨgabʉ lapʉ, anaɓanga Kunzi. Muko yi nɨnɔ atɨmʉkanagatʉ ndɨ, Mombukwono-dosu ahukwa ndɨ lɨmbɛngɨ ɓikpo kaʉkana ɓɨnza lɨkpʉmʉka nɨlɔ Pɔlɔ aɓɨkyaga ndɨ. ");
INSERT INTO lik_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Kumbuso yi, iɓotisisa ndɨ na ndaɓʉ kakɨ. Atitikisyo, ɨyɨ aka ɓɛ: «Makɨna ɓɛ naɓinikyonini Mombukwono-dosu ka lɨngʉnʉ, doniku kaiko kʉ kamɨ.» Otiwolya ndɨ ɓɨndɔndɔlɔndɔ. ");
INSERT INTO lik_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Lɨsyɛ limoti, ngbingo yi nɨnɔ ta ndɨ mino kaɨnda ka malʉmba, mʉgya-ligubo ɓemoti muko yi atikpuɗoku ndɨ. Mʉgya-ligubo yi nɨnɔ a ndɨ na lɨmbɛngɨ la ɓʉnyɛ nɨlɔ awonisilaga ndɨ kaɓɨkyaga makpʉmʉka nɨmɔ kanigyonosigʉ. Ɓugyalandʉ ɓi nɨɓɔ ʉpága ndɨ ɓambʉkwakɨ ɓuyi ɓudingi. ");
INSERT INTO lik_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Apʉnga ndɨ katɨɓɨɓya iɓusu na Pɔlɔ, anapamɨkanaga ɓɛ: «Ɓatʉ nɨɓana ɓa ɓagya-ligubo ko Kunzi nɨnɔ Kʉgʉ-Kʉgbɛ. Ɓakamʉwanya pisi nɨyɔ makwanana mino kainisono na muhukuso.» ");
INSERT INTO lik_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Kʉsɔ wa masyɛ makpʉ, agyaga kʉwa ndɨ ɓɛyɔ aka yɔ. Ka muliɓo, lɨmbɛngɨ akundumana ndɨ Pɔlɔ, oyikono, ɨyɨ aka na lɨmbɛngɨ la ɓʉnyɛ ɓɛ: «Nakaʉɓɨkya ko lino ka Yeso-Kilisito ambɛ pupo ka muko yi nɨmʉ!» Ko ngbingo yi nɨnɔ aka nɔ, lɨmbɛngɨ la ɓʉnyɛ aka ndɨ ɓindeɗe. ");
INSERT INTO lik_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Nɨyɔ ɓamombukwana muko yi nɨnɔ ɓɨna ɓɛ ɨzangɨya kaɓʉ osyini, ɓugwi kʉwa ndɨ Pɔlɔ ɨɓʉ na Sila, ɓupupisa ka pa yangba kambwa ka ɓangama. ");
INSERT INTO lik_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ɓusilisa ndɨ kambwa ka ɓazozi ka Ɓalʉma, ɨɓʉ aka ɓɛ: «Ɓatʉ ɓi nɨɓa ɓa Ɓayuda, ɓaputini gʉɗʉ kusu. ");
INSERT INTO lik_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Ɓakowonisilo yɨgya yi nɨyɔ iɓusu Ɓalʉma takoɓingisyogigʉ ikanɨ kagya yi.» ");
INSERT INTO lik_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Kʉwa wa, mambɛngɨ ʉkandɨkanaga ndɨ ɓatʉ nɨɓɔ ɓa ndɨ ka ambaza wa ɓɨkpɛkɨ-kpɛkɨ ko bulya ka Pɔlɔ ɨɓʉ na Sila. Ɓazozi ɓakpamya ndɨ ɓɛ ɓʉnyʉ ndumbu, ɓʉtɨnɨ pimbo. ");
INSERT INTO lik_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Nɨyɔ ɓupa kaʉkʉɓa, ɓʉɗɨkɨta ka bɔlɔkɔ, ɓakpamya zamʉ ɓɛ uɓuulyogi ɓɨnza. ");
INSERT INTO lik_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ngbingo yi nɨnɔ ɓakpamya ndɨ mino zamʉ ɓɛyɔ, ʉmakya ndɨ ka kasɔ ka pa yakpwɔ, ʉmakyaga magʉ ka kpʉkpʉ. ");
INSERT INTO lik_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Lugo wo biti, Pɔlɔ ɨɓʉ na Sila ɓa ndɨ kalʉmba, ɓanɨmbɨla kabibiso Kunzi nɨ ɓatʉ ɓa bɔlɔkɔ ɓagɔgɔ ɓanʉmʉkana. ");
INSERT INTO lik_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Ko ngbingo ɓemoti aka, azigizo wapʉ azʉkʉla ndɨ muɓumbe ma ndaɓʉ ya bɔlɔkɔ. Wa aka wa, pumi yasɨ oukwikanaga ndɨ, ɓaselegeni ka ɓatʉ ɓasɨ ɓa bɔlɔkɔ ɓatɨnɨkaga ndɨ ɓitututu. ");
INSERT INTO lik_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Nɨyɔ zamʉ ozuzuko, ɨna ndɨ pumi ɓikpokpo, anyɔ kʉwa sabɨ kakɨ ɓɛkyɛ ɨmwɨ kyɛ a ndɨ kasɨma ɓɛ ɓatʉ ɓa bɔlɔkɔ ɓokyogini. ");
INSERT INTO lik_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Luki limoti, Pɔlɔ apamɨkana ndɨ ɓɛ: «Wakimwonitɔgʉ, ta ɓasɨ wa aka wa!» ");
INSERT INTO lik_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Kʉwa wa, zamʉ nɔ akʉnga ndɨ tala, ogulyo ɓɨgala-gala ka ndaɓʉ ya bɔlɔkɔ, ogwa ndɨ kambwa ka Pɔlɔ na Sila nɨ nzʉyɨ anatwa ɓɨkyakyakya. ");
INSERT INTO lik_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Kumbuso yi, upupisa ndɨ, umuusa ɓɛ: «Iɓunu ɓababa, okwononi ɓɛ nagyɨ ɓʉnɨ kainisono na muhukuso?» ");
INSERT INTO lik_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ɓasikisya ndɨ ɓɛ: «Mʉɓɨnɨkyana Mombukwono-dosu Yeso, winisono na muhukuso, ɨwɛ pa imoti na ndaɓʉ kakʉ.» ");
INSERT INTO lik_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Kʉwa wa, ɓaɓɨkyaga ndɨ Mongoni Manza ka Mombukwono-dosu pa imoti na ɓatʉ ɓa ndaɓʉ kakɨ ɓasɨ. ");
INSERT INTO lik_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ko ngbingo yi nɨnɔ aka nɔ wo biti nɔ, zamʉ ʉva ndɨ, ʉsʉkʉsa ɓapwayɨ ɓɨngɔ. Wa aka wa, ɓaɓotisa ndɨ, ɨyɨ pa imoti na ndaɓʉ kakɨ ɓasɨ. ");
INSERT INTO lik_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Kumbuso yi, aga ndɨ na Pɔlɔ ɨɓʉ na Sila kʉ kakɨ, ʉpá malɨlɨ. Alʉkʉ nɔ pa imoti na ndaɓʉ kakɨ yasɨ ɓogwa ndɨ magyagya, kyɛ ɓa ndɨ nɨ ɓaɓinikyonini Kunzi. ");
INSERT INTO lik_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Nɨyɔ lɨsyɛ asyɛ, ɓangama ka ɓazozi ɓʉtɨka ndɨ ɓambanzʉ kaɓɨkyoku zamʉ ɓɛ usisi. ");
INSERT INTO lik_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Zamʉ atʉmbʉlyaga ndɨ Pɔlɔ mongoni mi nɨmɔ ɓɛ: «Ɓazozi ɓotikiku mayʉ ɓɛ namusisi. Mbɨya wanʉ, makwanana kʉwa kopupo, maga na mazɨyɔ.» ");
INSERT INTO lik_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Luki limoti, Pɔlɔ ʉɓɨkya ndɨ ɓatʉ nɨɓɔ ɓutikoku ndɨ ɓɔ ɓɛ: «Ɓatitinisisi ɓi fimbo ka pa yangba nɨ ɓakatisombisigʉ, ɓatɨmakya ka bɔlɔkɔ. Wɨna sɛ ta ɓomikya Ɓalʉma. Mbɨya wanʉ, ko bulya ɨkɨ yɔ ɓakapa katipupiso ɓɨpɛlɛ? Kigyonosigʉ! Ɓodukuno nɨ ɨɓʉ aka ɓamombukwana-daɓʉ ɓi katipupiso yi!» ");
INSERT INTO lik_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Ɓatʉ ɓi nɨɓɔ ɓɨga ndɨ, ɓʉtʉmbʉlyaga ɓangama lɨkpʉmʉka li nɨlɔ. Nɨyɔ ɓʉkana ɓɛ Pɔlɔ na Sila ɓa ɓomikya Ɓalʉma, ɓaɓanga ndɨ ɓɨnyɛ. ");
INSERT INTO lik_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Kʉwa wa, ɓodoku ndɨ, ɓɨtatanaga na ɨɓʉ, ɓusiso. Kumbuso yi, ɓʉɓɨkya ndɨ ɓɛ ɓopupi ka gʉɗʉ yi nɨnɔ. ");
INSERT INTO lik_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Ngbingo yi nɨnɔ Pɔlɔ na Sila ɓopupa ndɨ mino ka bɔlɔkɔ, ɓɨnda ka ma Ludia. Kʉ ɓɛyɔ, ɓɨnanana ndɨ na ɓakilisito, ɓutumisa mambɛngɨ, kumbuso yi, ɓaga ndɨ ɨɓʉ. ");
INSERT INTO lik_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pɔlɔ ɨɓʉ na Sila ɓaga ndɨ pisi ka gʉɗʉ wa Amufipoli na Apɔlɔnia, ɓosila kʉwa ndɨ ka Tesalonika kʉ Ɓayuda ɓa ndɨ mino na ndaɓʉ ya malʉmba. ");
INSERT INTO lik_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Mʉɗɔngɔnɨ ɓɛyɔ Pɔlɔ agyaga ndɨ mino kambwa, ogulya ndɨ kʉ ɓɛyɔ. Ka Masyɛ ma kimumbiso masaa, ɓikaga ndɨ kagya ɓoɗongoso na ɨɓʉ kʉ ko bulya Moɓiso Motu. ");
INSERT INTO lik_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ikaga ndɨ kaʉtʉmbʉlyaga, anowoniso ɓɛ okwononi Kilisito igyogyisi, opupoku ka mbʉkʉ. Ɨyɨ aka ndɨ na ɨɓʉ ɓɛ: «Yeso yi nɨnɔ, nakamʉɓɨkyaga Mongoni Manza ko bulya kakɨ, ɨyɨ nɨ Kilisito.» ");
INSERT INTO lik_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Nɨyɔ Ɓayuda ɓemoti-ɓemoti ɓʉkana lɨkpʉmʉka li nɨlɔ, ɓabaya ndɨ, ɓaɓyɛ kʉwa ndɨ Pɔlɔ na Sila. Ɓagiliki ɓudingi nɨɓɔ ɓabibisaga ndɨ Kunzi pa imoti na ɓoko ɓakpʉ ɓakinisono, ɓabaya ndɨ gɔnɨ. ");
INSERT INTO lik_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Luki limoti, Ɓayuda ɓagɔgɔ ɓotuma ndɨ na imi ɓɨɗɛ. Ɓʉpʉnaga ndɨ na lɨgʉndʉ ɓawanza ɓemoti-ɓemoti nɨɓɔ ɓayɨgya yanyɛ. Ɓamʉmʉla kʉwa ndɨ ambaza wasɨ kavɨkɨmanaga ka gʉɗʉ, ɓaga ndɨ ka ndaɓʉ ka Yasoni kakɨsa Pɔlɔ na Sila ɓɨvaka-vaka ɓɛkyɛ ɓupupisi ko misa ka ɓambanzʉ. ");
INSERT INTO lik_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Yɛkɨ ɓakʉmɨnagʉ ndɨ, ɓaga kʉwa ndɨ na Yasoni pa imoti na ɓakilisito ɓemoti-ɓemoti ɓɨdaɗa-daɗa ko misa ka ɓangama ɓa gʉɗʉ nɨ ɓanapamɨkanaga ɓɛ: «Ɓatʉ ɓi nɨɓa ɓaputini ɔɓɨlɨ wasɨ, mbɨya wanʉ, ɓodwiniku kʉwa gɔnɨ wanʉ, ");
INSERT INTO lik_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Yasoni nɔ utilyi ɓi kʉ kakɨ. Ɓatʉ ɓi nɨɓana ɓasɨ ɓakɛgʉ kaɓyɛ mʉtʉʉ ka ngama mudingi wa Lʉma kyɛ ɓakaɓɨkya ɓɛ atʉ na ngama wagɔgɔ nɨnɔ ina ɓɛ Yeso.» ");
INSERT INTO lik_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Lɨkpʉmʉka li nɨlɔ ʉtʉla ndɨ ɓatʉ ɓakpʉ na ɓangama ɓa gʉɗʉ, ");
INSERT INTO lik_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","ɓusiso kʉwa ndɨ Yasoni nɨ ɓikolyogini. ");
INSERT INTO lik_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Nɨyɔ biti olipyo, ɓakilisito ɓamogosa ndɨ Pɔlɔ na Sila ka gʉɗʉ yi nɨnɔ ina ɓɛ Bɛlɔya. Nɨyɔ ɓosilo kʉ ɓɛyɔ, ɓaga ka ndaɓʉ ya malʉmba ka Ɓayuda. ");
INSERT INTO lik_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Ɓatʉ ɓi nɨɓɔ kʉ ɓa ndɨ ɓanza kaʉkɨtaga Ɓatesalonika. Ɓa ndɨ kabaɨlya Lɨkpʉmʉka ko Kunzi na mʉsasa makpʉ. Masyɛ masɨ, ɓakpɨmaga ndɨ Moɓiso ɓɛkyɛ ɓibi ɓɛ lɨkpʉmʉka nɨlɔ Pɔlɔ ʉɓɨkyaga ndɨ, a ndɨ la lɨngʉnʉ. ");
INSERT INTO lik_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ɓudingi luga kaɓʉ ɓabaɨlya ndɨ. Luga ka Ɓagiliki, ɓoko ɓakinisono na ɓalʉkʉ ɓudingi ɓabaɨlya ndɨ gɔnɨ. ");
INSERT INTO lik_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Nɨyɔ Ɓayuda ɓa Tesalonika ɓʉkana ɓɛ Pɔlɔ akaɓɨkyaga gɔnɨ Mongoni Manza ko Kunzi ka Bɛlɔya, Ɓaga ndɨ kʉ ɓɛyɔ, ɓapʉnga gɔnɨ kapá ɨpʉmbʉ na kauvikimosogo ɓambaza ka ɓambanzʉ. ");
INSERT INTO lik_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ko ngbingo yi nɨnɔ aka nɔ, ɓakilisito ɓamogosa ndɨ Pɔlɔ miso yo liɓo lidingi, luki limoti, Sila na Timotio ɓasɨkana mbɛyɨ ndɨ ɨɓʉ wa aka wa. ");
INSERT INTO lik_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Ɓatʉ nɨɓɔ ɓɨnda ndɨ kabiso Pɔlɔ, ɓasilisa ndɨ ka gʉɗʉ wa Atɛnɛ. Kumbuso yi, ɓigoku ndɨ ka Bɛlɔya na mayʉ nɨmɔ Pɔlɔ utikilyoku ndɨ Sila ɨɓʉ na Timotio ɓɛ ɓɨndɨ katakanya ɓɨgala-gala. ");
INSERT INTO lik_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Ngbingo yi nɨnɔ Pɔlɔ a ndɨ mino kaɓʉndaga Sila na Timotio ka Atɛnɛ, a ndɨ no kumbu kʉgbɛ kyɛ gʉɗʉ yi nɨnɔ a ndɨ wakɨgʉmya ka gbɨlɨtɔ. ");
INSERT INTO lik_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Agyaga ndɨ ɓoɗongoso na Ɓayuda na ɓatʉ ɓagɔgɔ nɨɓɔ ɓaɓangaga ndɨ Kunzi kʉsɔ wa ndaɓʉ ya malʉmba. Ka ɓapa ɓaya musilyoni, ikaga ndɨ na ɓoɗongoso masyɛ masɨ na ɓatʉ nɨɓɔ ɓosilyanaga ndɨ na ɨɓʉ. ");
INSERT INTO lik_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ɓatʉ ɓa kimibo ɓemoti-ɓemoti ka liɗu ka Ɓɛpikulio na ka Ɓasitoiko, ɓapʉnga ndɨ ɓoɗongoso na ɨyɨ. Ɓemoti-ɓemoti luga kaɓʉ ɓuusaga ndɨ ɓɛ: «Tongolobi mʉna a mbɛyɨ kapa kaɓɨkya ɓʉ?» Ɓagɔgɔ ɓaɓɨkyaga ndɨ ɓɛ: «Akainisono abɛ a mʉɓɨɓɨkya wo mongoni ko ɓokunzi ɓo di.» Ɓa ndɨ kanzɨna ɓɛyɔ kyɛ Pɔlɔ a ndɨ kaɓɨkyaga Mongoni Manza ko bulya ka Yeso na ɓɛyɔ opupoku ndɨ mino ka mbʉkʉ. ");
INSERT INTO lik_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ɓava kʉwa ndɨ Pɔlɔ, ɓaga na ɨyɨ ka Pa Yidingi nɨyɔ ɓalɨkyaga ndɨ ɓɛ «Alɨyɔpagɔ», ɓamuusa ndɨ ɓɛ: «Wakwananatʉ katɨtʉmbʉlya isi ya mʉtʉʉ mambɨya nɨmɔ wakapá? ");
INSERT INTO lik_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Wakatɨɓɨkyaga makpʉmʉka mo di. Ta nɛkɨ kapa kaiba ambɛ nɨyɔ yasɨ isi yi nɨ ɨkɨ.» ");
INSERT INTO lik_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","A ɓɛyɔ, ɓatʉ ɓa Atɛnɛ ɓasɨ pa imoti na ɓobiko nɨɓɔ ɓikaga luga kaɓʉ ɓokitisaga ndɨ ɓongbingo kaɓʉ ɓayasɨ kaɓɨkyaga na kaʉkana ɓomongoni ɓayambɨya. ");
INSERT INTO lik_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Kʉwa wa, Pɔlɔ amaga ndɨ kambwa ka ɓatʉ nɨɓɔ ɓa ndɨ ka Alɨyɔpagɔ wa, ɨyɨ aka ɓɛ: «Iɓunu ɓatʉ ɓa Atɛnɛ, nakaɨna abɛ maɓaɨpá ko ɓokunzi kʉgbɛ. ");
INSERT INTO lik_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","A ɓɛyɔ, wa no ɓi mino kalingyo gʉɗʉ kunu, nɨnagatʉ ɓi ɓapa nɨɓayɔ mubibisogo mino ɓokunzi kunu. Ninito ɓi gɔnɨ gbɔgbɔ yimoti nɨ ɓokpikini mino ɓɛ: ‹A ko bulya ko kunzi yi nɨnɔ takamibogigʉ.› Kinili, ɨmɨ, nakamʉɓɨkyaga Mongoni ka nɨnɔ mabibisogo nɨ makɛgʉ kamibo. ");
INSERT INTO lik_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Kunzi yi nɨnɔ agya ndɨ ɔɓɨlɨ na masɨ nɨmɔ a kʉsɔ yi, ɨyɨ nɔ a Mombukwana lɨsyɛ na lɨtɔmbʉ, kikogigʉ na ɓandaɓʉ nɨɓayɔ ɓambanzʉ ɓopikogo. ");
INSERT INTO lik_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Kɛgʉ na nza yi ɓɛ ɓambanzʉ ɓaguguɓyi abɛ kika na yangya. A ɓɛyɔ, ɨyɨ nɔ ʉpága ɓatʉ ɓasɨ ɔɓɨlɨ, muyukumi na makpʉmʉka masɨ. ");
INSERT INTO lik_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Katʉkya ka mʉmbanzʉ ɓemoti, agya ndɨ mababa ka ɓambanzʉ kyɛ ɓiki ka ɔɓɨlɨ wasɨ. Ubisilyaga ndɨ ɓongbingo na lɨlɨ ka ɓogiyo. ");
INSERT INTO lik_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Kunzi agya ndɨ ɓɛyɔ kyɛ ɓambanzʉ ɓakɨsɨ. Gʉtʉgʉ ɓakiko kakɨsa nɨ ɓakazakaɗaga, ɓakwananatʉ aka kamɨna. Wɨna sɛ, Kunzi a ɓuwobi na iɓusu ɓasɨ yɨkaka-yɨkaka. ");
INSERT INTO lik_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","A ɓɛyɔ: ‹Ta na ɔɓɨlɨ ko bulya kakɨ, tanɨgyɨgyɨlya na takaidukulogo kaiko na ɔɓɨlɨ.› A mʉɗɔngɔnɨ ɓɛyɔ ɓemoti-ɓemoti ka ɓayoko kunu ɓaɓɨkya ndɨ mino ɓɛ: ‹Ta gɔnɨ iɓusu ɓomikakɨ.› ");
INSERT INTO lik_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Yɛkɨ ta ɓomiko Kunzi, takikonitɔgʉ na tamanaga ambɛ akwanana kaika mʉɗɔngɔnɨ abɛ kunzi yi nɨnɔ ɓagyaga na ɔlɔ, na ngwɛyɨ ikanɨ lɨtalʉ nɨyɔ ɓambanzʉ ɓagya na ɓʉgɛgɛlɛ na yimibo. ");
INSERT INTO lik_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Luki limoti, Kunzi kɛgʉ ɓata kaanda ɓongbingo nɨɓɔ ɓambanzʉ ɓa ndɨ mino ko biti. Mbɨya wanʉ, akaʉɓɨkyaga ɓambanzʉ ɓasɨ na ka ɓogiyo ɓayasɨ ɓɛ ɓoyikosi mambɛngɨ. ");
INSERT INTO lik_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","A ɓɛyɔ, obisoni lɨsyɛ nɨlɔ akɔ ndɛkɛ mino ngbanga ka ɔɓɨlɨ wasɨ, ka ɓungbingbili, pisi ka mʉtʉ ɓemoti nɨnɔ apʉnaga ndɨ. Apupisa ndɨ ka mbʉkʉ ɓɛkyɛ ɓatʉ ɓasɨ ɓibi ɓɛ mʉtʉ yi ɨyɨ nɨnɔ.» ");
INSERT INTO lik_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Nɨyɔ ɓamʉkana Pɔlɔ nɨ ananzɨna ko bulya yipupa ka mbʉkʉ, ɓemoti-ɓemoti luga kaɓʉ ɓapʉnga ndɨ katɨba ɓɨkyaaa, ɓagɔgɔ ɓaɓɨkya ndɨ ɓɛ: «Tʉmʉkanatʉ ɓanʉ mbɛyɨ ɓata lɨsyɛ lagɔgɔ.» ");
INSERT INTO lik_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Kʉwa wa, Pɔlɔ ʉsa ndɨ. ");
INSERT INTO lik_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Luki limoti, ɓatʉ ɓemoti-ɓemoti ɓaga ndɨ pa imoti na ɨɓʉ, ɓaɓɨnɨkyana ndɨ Kunzi. Luga kaɓʉ, a ndɨ nɨ Dionisi, mʉtʉ ɓemoti wa Alɨyɔpagɔ, muko ɓemoti nɨnɔ ina ndɨ ɓɛ Damali na ɓatʉ ɓagɔgɔ ɓata. ");
INSERT INTO lik_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Kumbusa wa nɨyɔ, Pɔlɔ atʉkya ndɨ ka Atɛnɛ, aga ka gʉɗʉ yi nɨnɔ ina ɓɛ Kolito. ");
INSERT INTO lik_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Kʉ ɓɛyɔ, atakanya ndɨ Muyuda ɓemoti nɨnɔ ina ndɨ ɓɛ Akila. Ɨyɨ Akila a ndɨ mʉtʉ wa Pɔtɔ. A ndɨ nɨ iginiku mbɨya aka kotukyoku ka mugi ma Italia ɨɓʉ na mukakɨ ɓɛyɔ ka Pelesila, kyɛ ngama mudingi ɓɛyɔ ka Kɔlɔdɛ a ndɨ nɨ opíni mʉtʉʉ ɓɛ Ɓayuda ɓasɨ ɓopupi ka Lʉma. Pɔlɔ ɨnda kʉwa ndɨ kanda Akila ɨɓʉ na mukakɨ. ");
INSERT INTO lik_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Yɛkɨ Pɔlɔ agyaga ndɨ ligubo la ɓangbangba ɓaya lɨbʉɗya abɛ Akila gɔnɨ, ɓika kʉwa ndɨ na ɨɓʉ pa imoti kagya ligubo li nɨlɔ. ");
INSERT INTO lik_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ka masyɛ masɨ ma kimumbiso, Pɔlɔ agyaga ndɨ ɓoɗongoso ka ndaɓʉ ya malʉmba ka Ɓayuda, anagya yasɨ ɓɛ Ɓayuda na Ɓagiliki ɓamʉkanɨtɔ. ");
INSERT INTO lik_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Nɨyɔ Sila na Timotio ɓotukyoku ka Makedonia, ɓosiloku ka Kolito, Pɔlɔ ɨpá ndɨ wasɨ kaɓɨkyaga Lɨkpʉmʉka ko Kunzi. A ndɨ kaʉtʉmbʉlyaga Ɓayuda ɓɛ Yeso nɨ Masiya. ");
INSERT INTO lik_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Luki limoti, Ɓayuda ɓa ndɨ kaɓunilyo muki aka, ɓanatʉmbwa. Kʉwa wa, ʉbʉmɨlya ndɨ liɓungu la ɓotu kakɨ ɓipupupu, ɨyɨ aka ɓɛ: «Makoɓungogo gʉtʉgʉ ɓata iɓunu, kɛgʉ ɓata lɨkpʉmʉka kamɨ. Katʉkya mbɨya wanʉ, nakaɨnda ka ɓatʉ nɨɓɔ ɓakɛgʉ Ɓayuda.» ");
INSERT INTO lik_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Pɔlɔ atʉkya kʉwa ndɨ wa, ɨnda kaiko ka mʉtʉ ɓemoti nɨnɔ ina ndɨ ɓɛ Tito-Yusito. Ɨyɨ Tito-Yusito abibisagatʉ ndɨ Kunzi, ndaɓʉ kakɨ ikaga ndɨ ka kpɔlɔ wa nɨyɔ ya malʉmba ka Ɓayuda. ");
INSERT INTO lik_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kilisipo nɨnɔ a ndɨ ngama wa ndaɓʉ ya malʉmba ka Ɓayuda, aɓɨnɨkyana ndɨ Mombukwono-dosu pa imoti na ɓatʉ ɓa ndaɓʉ kakɨ ɓasɨ. Ɓatʉ ɓa Kolito ɓakpʉ nɨɓɔ ɓa ndɨ kamʉkana Pɔlɔ, ɓaɓɨnɨkyana ndɨ gɔnɨ, ɓiɓotisiso. ");
INSERT INTO lik_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Biti yimoti, Pɔlɔ alʉtaga ndɨ nziki nɨ Mombukwono-dosu anaɓɨkya ɓɛ: «Wakoɓongonitɔgʉ, wika asɨ kanzɨna aka, wakodokonitɔgʉ, ");
INSERT INTO lik_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","kyɛ na pa imoti na ɨwɛ. Mʉmbanzʉ gʉtʉgʉ ɓemoti aka kʉvɨlɨgʉ kyɛ na na ɓambanzʉ ɓudingi ka gʉɗʉ yi nɨmʉ.» ");
INSERT INTO lik_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Pɔlɔ agya ndɨ kʉ ɓɛyɔ syangasʉ simoti na ɓatɨmba maɗɨya, kaʉɓɨkyaga ɓambanzʉ Lɨkpʉmʉka ko Kunzi. ");
INSERT INTO lik_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Ko ngbingo yi nɨnɔ Galio a ndɨ mino ngama wa iwili ya Akaya, Ɓayuda ɓʉkanana ndɨ ko bulya ka Pɔlɔ. Ɓagwi, ɓaga ndɨ na ɨyɨ kambwa ka ɓazozi, ");
INSERT INTO lik_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","ɨɓʉ aka ndɨ ɓɛ: «Alʉkʉ yi nɨmʉ akaʉkpamya ɓambanzʉ kabibiso Kunzi nɨ kɛgʉ ɓɛyɔ mʉtʉʉ aɓɨkyaga mino.» ");
INSERT INTO lik_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Nɨyɔ Pɔlɔ a ndɨ kapa kanzɨna, Galio aka ndɨ na ɨɓʉ ɓɛ: «Iɓunu Ɓayuda, kamwo ɓi mʉmbanzʉ ikanɨ kagya ɓʉnyɛ, ɨmɨ, nakwananatʉ ɓi kamʉmʉkana. ");
INSERT INTO lik_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Luki limoti, yɛkɨ makagya ɓoɗongoso ko bulya mʉnzɨna, mino na ko bulya mʉtʉʉ kunu, nɨlɔ amundi iɓunu aka. Ɨmɨ, nakakwananɨgʉ kakɔ inguo ya lɨkpʉmʉka li nɨlɔ.» ");
INSERT INTO lik_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Kumbuso yi, Galio ukpumya ndɨ. ");
INSERT INTO lik_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Kʉwa wa, ɨɓʉ ɓasɨ ɓagwi ndɨ Sositeni, ngama wa ndaɓʉ ya malʉmba. Ɓalya ndɨ ɓɨsʉsʉsʉ kambwa ka ɓazozi wa, nɨ Galio kɛgʉ gʉtʉgʉ kobiso mino lɨmbɛngɨ aka. ");
INSERT INTO lik_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pɔlɔ asyɛsyɛ mbɛyɨ ndɨ ɓata aka ɓɨndɨ ka Kolito wa. Kumbuso yi, ɓasanana ndɨ na ɓakilisito, ɓaɗaka ndɨ ka bato kaaga ka Sulia pa imoti na Pelesila na Akila. Iwisisa ndɨ mʉ ɓɨngɔ ka lɨsʉ nɨlɔ ɓalɨkyaga ndɨ ɓɛ Kenekulɨa, kyɛ a ndɨ nɨ akuni silika kambwa ko Kunzi. ");
INSERT INTO lik_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Nɨyɔ ɓadwɛ ka Ɛfɛsɔ, Pɔlɔ ʉsa kʉwa ndɨ wa aka wa. Aga ndɨ ka ndaɓʉ ya malʉmba ka Ɓayuda, apʉnga ɓoɗongoso na ɨɓʉ. ");
INSERT INTO lik_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ɓayuda ɓaɓɨkya ndɨ ɓɛ ɓiki mbɛyɨ ɓata na ɨɓʉ wa aka wa. Luki limoti nɨ Pɔlɔ kopagʉ. ");
INSERT INTO lik_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Nɨyɔ a ndɨ kaasanana na ɨɓʉ, ʉɓɨkya ɓɛ: «Kunzi kapa, nigokuto ɓanʉ ɓata kamʉnda.» Kʉwa wa, atʉkya ndɨ na bato ka Ɛfɛsɔ wa, aga. ");
INSERT INTO lik_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Nɨyɔ adwɛ ka Kaizalɨa, osyo, aɗaka ndɨ ka Yelusalɛma kaumuuso ɓatʉ ɓa kanisa. Kumbuso yi, osyo kʉwa ndɨ ka Atiokia. ");
INSERT INTO lik_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Agya ndɨ wa masyɛ makɛɗɛ aka, nɨyɔ atʉkya wa, apʉnga ndɨ kolingyo giyo yimoti-yimoti katʉkya ka Galatia adwɛ ka Fuligia. Kʉ ɓɛyɔ, utumisa ndɨ ɓaɓɨɓya ɓasɨ mambɛngɨ. ");
INSERT INTO lik_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Muyuda ɓemoti nɨnɔ ɨɓʉkʉta ndɨ ka Alesandulia ina ndɨ ɓɛ Apɔlɔ, a ndɨ nɨ osilini ka Ɛfɛsɔ. Anzɨnaga ndɨ ɓipoli-poli na ibaga ndɨ Moɓiso ko Kunzi ɓɨnza kʉgbɛ. ");
INSERT INTO lik_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ɓawonisila ndɨ kaɓyɛ pisi ka Mombukwono-dosu. Agyaga ndɨ kɛkɛlɛ kaɓɨkyaga na kowonisilo ka ɓungbingbili Mongoni Manza ka Yeso. Luki limoti, ibaga ndɨ ɨyɨ iɓatiso ka Yuani aka. ");
INSERT INTO lik_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Apʉnga ndɨ kanzɨna nɨ kɛgʉ na kʉɓangakʉ ka ndaɓʉ ya malʉmba ka Ɓayuda kʉ. Nɨyɔ Pelesila ɨɓʉ na Akila ɓamʉkana ndɨ, ɓamaka kʉ kaɓʉ, ɓawonisila ɓata ɓɨngbanganya kʉgbɛ pisi ko Kunzi. ");
INSERT INTO lik_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Yɛkɨ a ndɨ kapa kaɨnda ka iwili ya Akaya, ɓakilisito ɓatumisa ndɨ lɨmbɛngɨ, ɓukpikilya kʉwa ndɨ ɓaɓɨɓya nɨɓɔ kʉ kambwa aka ɓɛ ɓatɨlyɨtɔ ɓɨnza. Nɨyɔ osilo kʉ ɓɛyɔ, usingya ndɨ kʉgbɛ ɓatʉ nɨɓɔ ɓinisana ndɨ na muhukuso pisi ka ɨzɨyɔ ko Kunzi. ");
INSERT INTO lik_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","A ɓɛyɔ, ʉnzɨnɨlyaga ndɨ Ɓayuda na ɓou ɓɨngbanganya ko misa ka ɓatʉ ɓasɨ, anowoniso pisi ka Moɓiso Motu ɓɛ Yeso nɨ Kilisito. ");
INSERT INTO lik_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Ngbingo yi nɨnɔ Apɔlɔ a ndɨ mino ka Kolito, Pɔlɔ akɨtanaga ndɨ ka iwili ya ɓangʉpa, adwɛ ka Ɛfɛsɔ. Kʉ ɓɛyɔ, ʉtakanya ndɨ ɓaɓɨɓya ɓemoti-ɓemoti, ");
INSERT INTO lik_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ɨyɨ aka na ɨɓʉ ɓɛ: «Ambɛ, minisanatʉ ndɨ na Lɨmbɛngɨ-Lotu ngbingo yi nɨnɔ mabaya ndɨ mino?» Ɓasikisya ndɨ ɓɛ: «Kalɨ! Takanukonigʉ ndɨ gʉtʉgʉ iki yi aka nɨ ɓananzɨna ko bulya Lɨmbɛngɨ-Lotu.» ");
INSERT INTO lik_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Umuuso ɓata ndɨ ɓɛ: «Mogwa ndɨ iɓatiso tino?» Ɓasikisya ɓɛ: «Nɨyɔ ka Yuani.» ");
INSERT INTO lik_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pɔlɔ ʉɓɨkya kʉwa ndɨ ɓɛ: «Yuani uɓotisaga ndɨ ɓatʉ nɨɓɔ ɓapaga ndɨ kayikoso ɔɓɨlɨ kaɓʉ. Ʉɓɨkyaga ndɨ gɔnɨ ɓɛ ɓabaɨlyɨ mʉtʉ yi nɨnɔ akodoku kumbuso kakɨ. Mʉtʉ yi ndɨ nɨ Yeso.» ");
INSERT INTO lik_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Nɨyɔ ɓʉkana ɓɛyɔ, ɓiɓotisisa ndɨ ko lino ka Mombukwono-dosu Yeso. ");
INSERT INTO lik_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pɔlɔ ubisilya ndɨ maɓɔkʉ, Lɨmbɛngɨ-Lotu usilyo. Ɓapʉnga ndɨ kanzɨna ka masasʉ dididi na kaɓɨkyaga makpʉmʉka nɨmɔ kanigyonosigʉ. ");
INSERT INTO lik_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ɓatʉ ɓi nɨɓɔ ɓasɨ ɓa ndɨ ɓuwobi tɛkɛɓɛ na ɓaɓa. ");
INSERT INTO lik_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Kʉsɔ wa ɓatɨmba ɓasaa, Pɔlɔ ɨndaga ndɨ ka ndaɓʉ ya malʉmba ka Ɓayuda, ananzɨna nɨ kɛgʉ na kʉɓangakʉ. Agyaga ndɨ na ɨɓʉ ɓoɗongoso ko bulya Ɓʉngama ko Kunzi, anakɨsa ɓɛ ɓatʉ ɓi nɨɓɔ ɓikaga ndɨ kamʉkana ɓabaɨlyɨ. ");
INSERT INTO lik_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Luki limoti, ɓagɔgɔ ɓa ndɨ mambɛngɨ muti, ɓakya ka baya, ɓapʉnga kanzɨna yanyɛnyɛ ko bulya yo pisi ka Mombukwono-dosu ka musilyoni wa. Kʉwa wa, Pɔlɔ ʉsa ndɨ, aga ndɨ pa imoti na ɓaɓɨɓya aka. Ɓikaga ndɨ kaɨnzɨnzɨnya na ɨɓʉ masyɛ masɨ ka ndaɓʉ ya ɨkɔlɔ ka alʉkʉ ɓemoti nɨnɔ ina ndɨ ɓɛ Tilano. ");
INSERT INTO lik_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Lɨkpʉmʉka li nɨlɔ igyonosa ndɨ ka ɓyanga ɓɨɓa. Ɓatʉ ɓasɨ nɨɓɔ ɓa ndɨ ka iwili ya Azia, iki Ɓayuda na gʉtʉgʉ Ɓagiliki aka ɓʉkana ndɨ lɨkpʉmʉka ko Mombukwono-dosu. ");
INSERT INTO lik_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Kunzi agyaga ndɨ makpʉmʉka mʉmbanga-mbanga pisi ka Pɔlɔ. ");
INSERT INTO lik_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Kinili, ɓubisilyaga ndɨ ɓatʉ ɓa ɓokoloɓu ɓotu na matambala nɨmɔ ikaga ndɨ nɨ odundini nzʉyɨ ka Pɔlɔ. Ɓatʉ ɓi nɨɓɔ ɓahʉkagatʉ ndɨ, mambɛngɨ ma ɓʉnyɛ anupupo gɔnɨ. ");
INSERT INTO lik_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ɓayuda ɓemoti-ɓemoti ɓikaga ndɨ kaamama ka ɓapa dididi kakɨngɨla kokpumyo mambɛngɨ ma ɓʉnyɛ ko lino ka Mombukwono-dosu Yeso. Ɓanaɓɨkya ɓɛ: «Nakamʉɓɨkya ambɛ puponi ko lino ka Yeso nɨnɔ Pɔlɔ akaɓɨkyaga lɨkpʉmʉka kakɨ.» ");
INSERT INTO lik_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Kumu-kumu ɓemoti Muyuda nɨnɔ ina ndɨ ɓɛ Sɛkɛva a ndɨ na ɓomiki maɗɨya na ɨka. Ɓomikakɨ ɓɔ ɓagyaga ndɨ lɨkpʉmʉka li nɨlɔ. ");
INSERT INTO lik_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Luki limoti, lɨmbɛngɨ la ɓʉnyɛ usikisya ndɨ ɓɛ: «Namibatʉ Yeso, namiba gɔnɨ Pɔlɔ ɓɨnza. Luki limoti, iɓunu ma ɓa wanɨ?» ");
INSERT INTO lik_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Alʉkʉ yi nɨnɔ a ndɨ na lɨmbɛngɨ la ɓʉnyɛ nɔ ubumbukyoku ɓomika Sɛkɛva, ʉkʉkʉmilyaga, ʉgyagya ndɨ ɓɨnyɛ kadwɛ kʉ kwa kʉ ɓomiki ɓɔ ɓopupoku ndɨ ka ndaɓʉ ɓondumbu na ɓeviɗi. ");
INSERT INTO lik_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ɓatʉ ɓasɨ ɓa Ɛfɛsɔ, iki Ɓayuda na gʉtʉgʉ Ɓagiliki aka ɓʉkana ndɨ mongoni mi nɨmɔ. Ɨɓʉ ɓasɨ ɓaɓanga ndɨ, ɓobibisa lino ka Mombukwono-dosu Yeso. ");
INSERT INTO lik_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ɓatʉ ɓudingi nɨɓɔ ɓa ndɨ nɨ ɓoboilyini, ɓodogoku ndɨ kaɓɨnɨkyana na kaɓɨkyaga ɓʉnyɛ kaɓʉ nɨɓɔ ɓagyaga ndɨ ɓɨngbanganya ko misa ka ɓambanzʉ. ");
INSERT INTO lik_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Luga ka ɓatʉ nɨɓɔ ɓʉkɨmaga ndɨ ɓanɛkɔ, ɓudingi ɓodoku ndɨ na ɓakɨtaɓʉ kaɓʉ ɓaya ɓanɛkɔ kabʉsya kambwa ka ɓambanzʉ ɓasɨ. Ɓagya kʉwa ndɨ ɨsaɓʉ ya ɓakɨtaɓʉ ɓi nɨɓɔ, apá ɓuyi ɓambuma ɓɛlɔfʉ ɓatɛkɛɓɛ kuɓukumuti. ");
INSERT INTO lik_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Kinili, pisi ko ngu ka Mombukwono-dosu, lɨkpʉmʉka ko Kunzi ɨgbata ndɨ, ɨtʉlyana ka ɓapa ɓayasɨ. ");
INSERT INTO lik_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Kumbusa wa lɨkpʉmʉko li nɨlɔ, Pɔlɔ osisila ndɨ kaɨnda ka Yelusalɛma pisi ka iwili ya Makedonia na nɨyɔ ya Akaya. Ɨyɨ aka ndɨ ɓɛ: «Nakadwɛ kʉ, nakwananatʉ ɓanʉ gɔnɨ kaaga ka Lʉma.» ");
INSERT INTO lik_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ʉtɨka kʉwa ndɨ ka Makedonia ɓatʉ ɓaɓa luga ka nɨɓɔ ɓesingyaga ndɨ ka ligubo, a ndɨ nɨ Timotio ɨɓʉ na Ɨlasɨtɔ. Ɨyɨ mombukwana-dakɨ otigolo mbɛyɨ ndɨ ɓata ka Azia aka. ");
INSERT INTO lik_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Ko ngbingo yi nɨnɔ, ɓambanzʉ ɓavɨkɨmanaga ndɨ ka Ɛfɛsɔ ko bulya Pisi ka Mombukwono-dosu. ");
INSERT INTO lik_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Kʉ ɓɛyɔ, a ndɨ na mutwo-mabɨsya ɓemoti nɨnɔ ina ndɨ ɓɛ Demetilio. Ɨyɨ Demetilio otwaga ndɨ ka ɓangwɛyɨ ɓekingyosi ɓayɨkɛkɛkɛ ɓaya ɓandaɓʉ ko kunzi muko yi nɨnɔ ina ndɨ ɓɛ Alitemisi. Ligubo li nɨlɔ ʉpága ndɨ ɓotwa-mabɨsya ɓuyi ɓudingi. ");
INSERT INTO lik_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Demetilio ʉmʉmʉla kʉwa ndɨ ɓotwa-mabɨsya na ɓatʉ ɓasɨ nɨɓɔ ɓagyaga ndɨ ɓʉsɔlɔ ɓa ligubo li nɨlɔ. Ɨyɨ aka na ɨɓʉ ɓɛ: «Ɓomika-mama, makaiba ɓɨnza ɓɛ talyalyaga ka ligubo li nɨlɨ. ");
INSERT INTO lik_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Mbɨya wanʉ, makaɨna na kaʉkana nɨlɔ Pɔlɔ akagya. Kɛgʉ asɨ ka Ɛfɛsɔ aka, luki limoti lɨkpʉmʉko nɨlɔ a kʉwa ɓuwobi kaɨtʉlyana ka Azia wasɨ. Ulutoni ɓatʉ ɓudingi, uyikasa tamanaga kaɓʉ ɓɛ ɓokunzi nɨɓɔ ɓambanzʉ ɓutwogo ɓakɛgʉ ɓokunzi. ");
INSERT INTO lik_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Kɛgʉ asɨ ligubo kusu aka lɔ akakɨsa kapʉtɨkana, luki limoti, gʉtʉgʉ ɨbɨba ya ndaɓʉ ko kunzi mudingi Alitemisi aka. Ɨyɨ nɨnɔ ɓabibisogo ɓapa ɓayasɨ ka Azia na ka ɔɓɨlɨ wasɨ!» ");
INSERT INTO lik_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Nɨyɔ ɓambanzʉ ɓʉkana lɨkpʉmʉka li nɨlɔ ɓɛyɔ, ɓavɨkɨmanaga ndɨ, ɓanapamɨkanaga ɓɛ: «Alitemisi wa Ɛfɛsɔ a mudingi!» ");
INSERT INTO lik_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Kʉwa wa, gʉɗʉ wasɨ avɨkɨmanaga ndɨ. Ɨɓʉ ɓasɨ ɓʉkanana ndɨ kaaga ɓɨgala-gala ka pa yangba nɨyɔ ɓamʉmʉkanaga ndɨ mino, ɓagwi ndɨ Gayɔ na Alisitaliko, Ɓamakedonia ɓaɓa ɓi nɨɓɔ ɓakpakyana ndɨ na Pɔlɔ. ");
INSERT INTO lik_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pɔlɔ a ndɨ wakɨtʉlya kaɨnda kambwa ka ambaza yi nɨnɔ, luki limoti ɓaɓɨɓya ɓapakya ndɨ. ");
INSERT INTO lik_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Gʉtʉgʉ ɓangama ɓemoti-ɓemoti ɓa Azia nɨɓɔ ɓa ndɨ ɓawai-dakɨ, ɓatɨkɨlya ndɨ ɓambanzʉ kaɓɨkya ɓɛ kipupisonitɔgʉ kʉ ɓɛyɔ. ");
INSERT INTO lik_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Ko ngbingo yi nɨnɔ aka nɔ, ɓambanzʉ ɓapʉnga ndɨ kanzɨna gbalɨ, ɓanzɨngɨmana ndɨ. Luga kaɓʉ, ɓambanzʉ ɓudingi ɓakɛgʉ ndɨ kaiba gʉtʉgʉ ɓɛ ɓomumukoni ko bulya ɨkɨ. ");
INSERT INTO lik_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Kʉwa wa, ɓambanzʉ ɓemoti-ɓemoti luga wa ambaza ɓatʉmbʉlyaga ndɨ Alesandulia lɨkpʉmʉka li nɨlɔ. Ɓayuda ɓakpamya ndɨ ɓɛ akɨtagɨ kambwa. Kʉwa wa, Alesandulia ʉgbʉma na maɓɔkʉ ɓɛ ɓadakɨ kyɛ a ndɨ kapa kanzɨna. ");
INSERT INTO lik_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Luki limoti, nɨyɔ ɓambanzʉ ɓibo ɓɛ Alesandulia a Muyuda, ɨɓʉ ɓasɨ ɓapʉnga ndɨ kapamɨkanaga ka ɓasaa banda ɓaɓa ɓɛ: «Alitemisi wa Ɛfɛsɔ a mudingi!» ");
INSERT INTO lik_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Ka muliɓo, ndɔmbɛ mudingi wa gʉɗʉ yi nɨnɔ udokisa ndɨ, ʉɓɨkya ɓɛ: «Ɓatʉ ɓa Ɛfɛsɔ, ɓambanzʉ ɓasɨ ɓakaiba ɓɛ Ɛfɛsɔ a pa yi nɨyɔ oɓuulyogo ndaɓʉ ko kunzi Alitemisi mudingi na mulundu kakɨ nɨmɔ ogwoku ndɨ kʉgʉ wa lɨsyɛ. ");
INSERT INTO lik_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Kɛgʉ na mʉtʉ gʉtʉgʉ ɓemoti aka nɨnɔ akwanana kaanganya. Kinili, okwononi mbɛyɨ kosisa mambɛngɨ, nɨ makogyigʉ lɨkpʉmʉka ɓɨsɔsɔsɔ. ");
INSERT INTO lik_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","A ɓɛyɔ, ɓalʉkʉ ɓi nɨɓana moduku na ɨɓʉ ɓa ɓakiɓigʉ ka ndaɓʉ ko kunzi kusu ikanɨ katʉmbwa yi. ");
INSERT INTO lik_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Kika nɨ Demetilio na ɓotwa-maɓɨsya nɨɓɔ ɓagyaga na ɨɓʉ ligubo ɓakɛgʉ kaʉkanana na mʉmbanzʉ, masyɛ mʉkɔ ɓangbanga atʉ, ɓazozi ɓatʉ gɔnɨ, ɓakwanana kaaga kʉ ɓɛyɔ. ");
INSERT INTO lik_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Makika na lɨkpʉmʉka lagɔgɔ lɨɓɨkya, nɨyɔ igyonosa kʉwa ɓanʉ kambwa ka ɓangama. ");
INSERT INTO lik_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","A ɓɛyɔ, kaɓyɛnɛnɛ na lɨkpʉmʉka li nɨlɔ igyonosi na lɨsyɛ li nɨlɨ, ɓakwanana katɨpɨlyaga ɓangbanga ɓɛ tovikimonogini. Takɛgʉ no pisi yi nɨyɔ tatʉmbʉlaga mino mʉ ma musilyoni mi nɨma.» ");
INSERT INTO lik_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Nɨyɔ ama kanzɨna ɓɛyɔ, ʉpá ɓambanzʉ lɨgʉndʉ. ");
INSERT INTO lik_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Nɨyɔ pa adakɨlya, Pɔlɔ ʉmʉmʉla kʉwa ndɨ ɓaɓɨɓya, utumiso mambɛngɨ. Kumbuso yi, ʉpága maɓɔkʉ, aga ndɨ ka Makedonia. ");
INSERT INTO lik_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Akɨtanaga ndɨ pisi kʉ ɓɛyɔ, ʉpá ndɨ ɓaɓɨɓya mʉtʉʉ makpʉ. Kumbuso yi, ɨnda ndɨ ka mugi ma Giliki, ");
INSERT INTO lik_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","agya ndɨ kʉ ɓɛyɔ ɓatɨmba ɓasaa. Nɨyɔ a kʉwa ndɨ ɓuwobi kaɗaka ka bato kaɨnda ka mugi ma Sulia, ʉkana ndɨ ɓɛ Ɓayuda ɓagyilini dikiɗi. Kʉwa wa, osisilya ndɨ kaɨga kumbuso, akɨtanaga pisi ka Makedonia. ");
INSERT INTO lik_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","A ndɨ kakpakyana pa imoti na ɓatʉ ɓi nɨɓa: Sopateli mika Pilo nɨnɔ a ndɨ Mubeloya, Ɓatesalonika ɓɛyɔ ka Alisitaliko ɨɓʉ na Sekundo, Mʉdelibe nɨnɔ ina ndɨ ɓɛ Gayɔ, Timotio, sɛ kʉwa Tikiko ɨɓʉ na Tolofimo nɨɓɔ ɓa ndɨ ɓatʉ ɓa Azia. ");
INSERT INTO lik_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ɓatʉ ɓi nɨɓa ɓɔ ɓapʉngaga ndɨ lɨgʉndʉ kaɨnda katɨɓʉndaga ka Tolowasi. ");
INSERT INTO lik_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Kumbusa wa yɨnga nɨyɔ ɓalyaga ndɨ mino mukati ɓikofulu, taɗaka ndɨ ka bato ka lɨsʉ la Filipi, kumbusa wa lɨgʉndʉ la masyɛ kuɓukumuti, tʉtakanyaga ndɨ ka Tolowasi, tagya na ɨɓʉ pɔsɔ yimoti. ");
INSERT INTO lik_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Lɨsyɛ la Mʉngʉ na ɓʉgɔgɔ, ta ndɨ ɓʉmʉmʉkana koɓunonogo mukati nɨ Pɔlɔ ananzɨna. Yɛkɨ a ndɨ kapa kopupyo na ɓʉgala ɓi, idukulaga ndɨ no bulo kadwɛ lugo wo biti. ");
INSERT INTO lik_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ta ndɨ ɓʉmʉmʉkana ka ndaɓʉ yi nɨyɔ ya kʉgʉ. Kʉ ɓɛyɔ, ɓatala ɓakpʉ ɓʉtʉna ɓingbiii. ");
INSERT INTO lik_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Wɨna sɛ, a ndɨ na Mʉwanza ɓemoti nɨnɔ ina ndɨ ɓɛ Eutiko, a ndɨ wakiko ka lidilisa wa, ɨyɨ aka ndɨ tɔtɔ ɓɨpɛ ko ngbingo yi nɨnɔ Pɔlɔ a ndɨ mino kanzɨna ɓɨndɨɨɨ nɔ. Mʉwanza nɔ onyukoku ndɨ ka tɔtɔ, ogwoku kotukyoku ka ndaɓʉ ya kʉgʉ nɨyɔ ya yɨsaa. Nɨyɔ ɓa kʉwa ndɨ ɓɛ ɓamomosi, a ndɨ nɨ okwini. ");
INSERT INTO lik_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Kʉwa wa, Pɔlɔ osyoku ndɨ, odidiko ɓuwobi na ɨyɨ, apututo, aɓɨkya ɓɛ: «A muɓisi, wosoni kombomboyo!» ");
INSERT INTO lik_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Nɨyɔ Pɔlɔ ɨgɨlya ndɨ ɓata kaɗaka ka ndaɓʉ ya kʉgʉ, oɓunonogo mukati, alya. Idukulaga ndɨ ɓata kanzɨna ɓɨndɨɨɨ kadwɛ kʉ kwa kʉ lɨsyɛ atɨnɨkaga ndɨ mino. Kumbuso yi, aga ndɨ. ");
INSERT INTO lik_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Ɓɨga ndɨ na mʉwanza yi nɨnɔ nɨ a muɓisi, ɓatʉ ɓasɨ ɓotumini na magyagya ɓɨɗɛ. ");
INSERT INTO lik_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Taga kʉwa ndɨ iɓusu kambwa, taɗaka ka bato kaɨnda ka gʉɗʉ yi nɨnɔ ina ɓɛ Asosi. Kʉ ɓɛyɔ, takwanana kʉwa ndɨ kava Pɔlɔ na lɨgʉndʉ kyɛ a ndɨ nɨ osisilyini kaɨnda na magʉ. ");
INSERT INTO lik_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Nɨyɔ tosilyono na Pɔlɔ ka Asosi, tava kʉwa ndɨ ka bato, taga pa imoti na ɨɓʉ ka gʉɗʉ wa Mitileni. ");
INSERT INTO lik_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Tatʉkya ndɨ ɓʉgalo ɓi, tadwɛ ko uzu nɨyɔ ina ɓɛ Kio. Nɨyɔ lɨsyɛ asyɛ, tadwɛ ndɨ ko uzu nɨyɔ ina ɓɛ Samosi, kʉwa na ɓʉgala ɓi topupana ndɨ ka gʉɗʉ wa Milɛtʉ. ");
INSERT INTO lik_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","A ɓɛyɔ, Pɔlɔ a ndɨ wakɨtʉlya kakɨtanaga ka Ɛfɛsɔ nɨ komogigʉ, kyɛ kɛgʉ ndɨ kapa kalya ngbingo ka iwili ya Azia. A ndɨ kaiɗuso ɓɛ odwino gʉtʉgʉ ka Yelusalɛma kambwa wa Patɛkɔtɨ. ");
INSERT INTO lik_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Katʉkya ka Milɛtʉ wa, Pɔlɔ ʉtɨka ndɨ ɓambanzʉ ka Ɛfɛsɔ kaumokoku ɓazɛɛ ɓa kanisa. ");
INSERT INTO lik_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Nɨyɔ ɓosiloku, Pɔlɔ ʉɓɨkya ndɨ ɓɛ: «Katʉkya ka lɨsyɛ nɨlɔ aka lɔ nosiloku ndɨ mino wanʉ ka Azia, makaiba yɨgya kamɨ ɓɨnza ɓɛyɔ na ndɨ mino ɓongbinga ɓasɨ luga kunu. ");
INSERT INTO lik_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Nagugubya ndɨ Mombukwono-dosu nɨ nakɛgʉ na yɨbɨnɨka, ka mʉgamʉ na ka yigyogyiso ko bulya ɓodikiɗi nɨɓayɔ Ɓayuda ɓɛgyɨlyaga ndɨ. ");
INSERT INTO lik_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Makaiba ɓɛ nakamʉsʉmɨlyagʉ ndɨ gʉtʉgʉ luki limoti aka nɨlɔ la ɨzangɨya. Namʉɓɨkyaga ndɨ ɓɨngbanganya lɨkpʉmʉka ko Kunzi, namʉpá mʉtɨwɨ ko misa ka ɓambanzʉ ɓasɨ na ka ɓandaɓʉ kunu. ");
INSERT INTO lik_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Nʉɓɨkyaga ndɨ Ɓayuda, gʉtʉgʉ ɓatʉ ɓi nɨɓɔ ɓakɛgʉ Ɓayuda ɓɛ ɓayikosi ɔɓɨlɨ kaɓʉ, ɓamigilyiku Kunzi, ɓaɓɨnɨkyana Mombukwono-dosu Yeso. ");
INSERT INTO lik_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Mbɨya wanʉ, Lɨmbɛngɨ-Lotu akɛkpamya kaɨnda ka Yelusalɛma. Nakɛgʉ kaiba ambɛ ikoku ɓanʉ na ɨmɨ kʉ ɓʉ. ");
INSERT INTO lik_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Luki limoti, ka ɓagʉɗʉ yɨkaka-yɨkaka, Lɨmbɛngɨ-Lotu ewonisilagatʉ kambwa ɓɛ bɔlɔkɔ na yigyogyiso akɛɓʉndaga. ");
INSERT INTO lik_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Nakamɨnagɨgʉ ɔɓɨlɨ kamɨ abɛ luki la ɨzangɨya. Luki limoti, ɨzangɨya kamɨ a ɓɛ nadwɨ ka muliɓo ma ligubo nɨlɔ Mombukwono-dosu Yeso ɛpá. Ligubo li nɨ kaɓɨkyaga Mongoni Manza ma ɨzɨyɔ ko Kunzi. ");
INSERT INTO lik_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Nikaga ndɨ kakpakyana luga kunu ɓasɨ, na naɓɨkyaga mongoni ma Ɓʉngama ko Kunzi. Luki limoti, katʉkya mbɨya wanʉ, nakaiba ambɛ makɛmɨnɨgʉ ɓanʉ ɓata. ");
INSERT INTO lik_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Kinili, na lɨsyɛ li nɨlɨ nakamʉgbɨtyaga ɓɛ ɓemoti kunu koɓungogo, kendigʉ ɓata ɨmɨ. ");
INSERT INTO lik_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","A ɓɛyɔ, namʉtʉmbʉlyaga ndɨ lɨkpʉmʉka ko Kunzi lasɨ nɨ nakamusumilyigʉ luki gʉtʉgʉ limoti aka. ");
INSERT INTO lik_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Wiminyonito iɓunu ɓamombukwana-donu. Ɓuulyogoni ambaza wasɨ nɨnɔ Lɨmbɛngɨ-Lotu amʉpá ɓɛ wikoni ɓoɓuɓulyo ɓi. Moɓuulyaga gɔnɨ kanisa ko Kunzi, nɨyɔ inisana ndɨ noyu pisi ka ɓangʉ ko mikakɨ ɓɨkpɛ. ");
INSERT INTO lik_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ɨmɨ, nakaiba ɓɨnza ambɛ kumbusa wa lɨgʉndʉ kamɨ, ɓambanzʉ mʉɗɔngɔnɨ abɛ ɓanyama ɓʉɗɨya ɓingyatʉ luga kunu, ɓakikigʉ no nzonzi wa ambaza. ");
INSERT INTO lik_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Gʉtʉgʉ luga kunu aka, ɓambanzʉ ɓipupisatʉ ndɛkɛ kaɓɨkyaga mʉtʉʉ ma kʉɓɔɓɔkʉ kyɛ ɓuluti ɓaɓɨɓya kumbuso kaɓʉ. ");
INSERT INTO lik_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Wiminyonito! Manatamana ambɛ ka ɓyanga ɓɨsaa, nikaga ndɨ kamʉpá mʉtɨwɨ yɨkaka-yɨkaka biti na lɨsyɛ ka mʉgamʉ. ");
INSERT INTO lik_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Mbɨya wanʉ, namupíni ko Kunzi na ko mongoni kakɨ ma ɨzɨyɔ. Mongoni mi nɨmɔ a no ngu kamupiko ka baya, kamʉpá lisimo pa imoti na ɓatʉ kakɨ ɓasɨ. ");
INSERT INTO lik_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Ɨmɨ, nakɛgʉ ndɨ na mʉsasa mo ɓuyi ikanɨ ma ɔlɔ ikanɨ ma ɓotu ka mʉmbanzʉ. ");
INSERT INTO lik_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Iɓunu ɓamombukwana-donu makaiba ɓɛyɔ nagyaga ndɨ mino ligubo na maɓɔkʉ kamɨ, ko bulya kamɨ, na ko bulya ka ɓatʉ ɓi nɨɓɔ takpakyanaga ndɨ na ɨɓʉ. ");
INSERT INTO lik_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ka masɨ nɨmɔ nagyaga ndɨ, namuwonisila ndɨ ɓɛ tokwononi kaɨkɔ ɓungu pisi ka ligubo, kabɨnɨka ɓuti ka ɓatʉ ɓa yangya. Manatamana gɔnɨ lɨkpʉmʉka nɨlɔ Mombukwono-dosu Yeso ɓɨkpɛ aɓɨkya ndɨ ɓɛ: ‹Ɨzangɨya ka mʉtʉ nɨnɔ apága luki okitogi nɨyɔ ka nɨnɔ ɓapága.›» ");
INSERT INTO lik_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Nɨyɔ Pɔlɔ ama kanzɨna ɓɛyɔ, oɓuna ndɨ moli pa imoti na ɨɓʉ ɓasɨ, ɓalʉmba. ");
INSERT INTO lik_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Ɨɓʉ ɓasɨ ɓagbʉngʉkana ndɨ na mʉgamʉ, ɓanapututo na kapanana maɓɔkʉ. ");
INSERT INTO lik_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Ɓalya ndɨ kumbu kʉgbɛ ka nɨlɔ Pɔlɔ ʉɓɨkya ndɨ ɓɛ ɓakamɨnɨgʉ ndɛkɛ ɓata. Ka muliɓo, ɓɨnda ndɨ kabiso ka lɨsʉ. ");
INSERT INTO lik_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Nɨyɔ tasanana na ɨɓʉ, taɗaka ndɨ ɓata ka bato, taga ngbingbili ko uzu nɨyɔ ɓalɨkyaga ɓɛ Kosi. Ɓʉgala ɓi, tadwɛ ndɨ ka mugi nɨmɔ ɓalɨkyaga ɓɛ Lodo. Katʉkya ka Lodo, tadwɛ ka Patala. ");
INSERT INTO lik_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Kʉ ɓɛyɔ, tatakanya ndɨ bato ɓemoti nɨ anaga ka Foinikia. Taɗaka ndɨ mino, taga. ");
INSERT INTO lik_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Nɨyɔ ta kʉwa ndɨ ɓuwobi na Kipulo, tasa ndɨ miso ya zebu, taga iɓusu ka Sulia. Tɨfʉma ka Tilo, ka pa yi nɨyɔ bato osisaga ndɨ mino makpʉmʉka. ");
INSERT INTO lik_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Kʉ ɓɛyɔ, tʉtakanya ndɨ ɓaɓɨɓya, tagya na ɨɓʉ pɔsɔ yimoti. Lɨmbɛngɨ-Lotu ʉkpamya ndɨ kapakya Pɔlɔ kaɗaka ka Yelusalɛma. ");
INSERT INTO lik_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Luki limoti, nɨyɔ pɔsɔ yi nɨyɔ akɨtaga, tidukulaga ndɨ na lɨgʉndʉ kusu. Ɓambanzʉ ɓasɨ, iki ɓoko na ɓomiki ɓɨnda ndɨ katibiso kunzi wa gʉɗʉ. Kʉ ɓɛyɔ, iɓusu ɓasɨ toɓuna ndɨ moli kubi wa, talʉmba. ");
INSERT INTO lik_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Nɨyɔ tasanana, taɗaka ndɨ ka bato, ɓaɓɨɓya ɓɨga kʉwa ndɨ ka ɓa kʉ-kaɓʉ. ");
INSERT INTO lik_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Katʉkya ka Tilo, tomosisya ndɨ kazaba, tadwɛ ka Tolemai. Kʉ ɓɛyɔ, tɨnanana ndɨ na ɓomomosu ɓakilisito, tasyɛ ndɨ na ɨɓʉ lɨsyɛ limoti. ");
INSERT INTO lik_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Ɓʉgala ɓi, tatʉkyɨlya ndɨ lɨgʉndʉ, tadwɛ ka Kaizalɨa. Tika ndɨ ka ndaɓʉ ka Filipi nɨnɔ ɓamakaga ndɨ ɓɛ «Mʉɓɨɓɨkya wo Mongoni Manza». Ɨyɨ Filipi a ndɨ ɓemoti ka ɓambanzʉ maɗɨya na ɨka nɨɓɔ ɓʉpʉnaga ndɨ ka Yelusalɛma. ");
INSERT INTO lik_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","A ndɨ na ɓasɨka ɓakwanganya nɨɓɔ ɓa ndɨ nɨ ɓakanibigʉ lɨkpʉmʉka ka ɓalʉkʉ. Ɓasɨka ɓi nɨɓɔ ɓa ndɨ na ɓugyalandʉ ɓʉtʉmbʉlaga makpʉmʉka ko lino ko Kunzi. ");
INSERT INTO lik_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Iɓusu ta kʉwa ndɨ wa nɨ togyini masyɛ makpʉ. Mugyalandʉ ɓemoti nɨnɔ ina ndɨ Agabʉ, otukyoku ndɨ ka Yudɛa, osiloku wa. ");
INSERT INTO lik_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Odoku katɨnda, ava mʉkaɓa ka Pɔlɔ, ɨkanda ndɨ nomu magʉ na maɓɔkʉ. Ɨyɨ aka ɓɛ: «Lɨmbɛngɨ-Lotu akaɓɨkya ɓɛ: ‹Ka Yelusalɛma, Ɓayuda ɓakandaga ɓanʉ mombukwana mʉkaɓa mi nɨma ɓɛyɔ, ɓagaba ka maɓɔkʉ ka ɓatʉ bi nɨɓɔ ɓakamibigʉ Kunzi.›» ");
INSERT INTO lik_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Nɨyɔ tʉkana lɨkpʉmʉka li nɨlɔ ɓɛyɔ, iɓusu na ɓatʉ ɓa Kaizalɨa tapakya ndɨ Pɔlɔ kaɗaka ka Yelusalɛma. ");
INSERT INTO lik_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Luki limoti, Pɔlɔ osikisya ndɨ ɓɛ: «Ko bulya ɨkɨ yɔ makagamana na kɛpá ombombo ɓɛyɔ? Na wakɨtʉlya kaikondisiso gʉtʉgʉ kokwo aka ka Yelusalɛma ko lino ka Mombukwono-dosu Yeso.» ");
INSERT INTO lik_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Nɨyɔ tɨna ɓɛ kɛgʉ katɨmʉkana, tasa kʉwa ndɨ. Taɓɨkya ɓɛ: «Sɨpananɨsɔ ka Mombukwono-dosu igyonosi nɛkɨ!» ");
INSERT INTO lik_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Kumbusa wa masyɛ makɛɗɛ, tiɓungusyaga ndɨ, taɗaka ka Yelusalɛma. ");
INSERT INTO lik_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Ɓaɓɨɓya ɓa Kaizalɨa ɓɨnda ndɨ katibiso ka alʉkʉ ɓemoti ka Kipulo nɨnɔ ina ndɨ ɓɛ Munasoni. Ɨyɨ Munasoni a ndɨ mʉɓɨɓya wandɛlɨ, tasyɛ kʉwa ndɨ kʉ kakɨ. ");
INSERT INTO lik_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Nɨyɔ tosilo ka Yelusalɛma, ɓomomosu ɓakilisito ɓatɨtɨlya ndɨ na magyagya. ");
INSERT INTO lik_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Ɓʉgala ɓi, tɨnda ndɨ pa imoti na Pɔlɔ kʉ ka Yakɔbɔ. Kʉ ɓɛyɔ, ɓazɛɛ ɓasɨ ɓa kanisa ɓa ndɨ ɓʉmʉmʉkana kʉ. ");
INSERT INTO lik_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Nɨyɔ Pɔlɔ ama kaumuusogo, ʉtʉmbʉlyaga ndɨ ɓuwobi-ɓuwobi nɨlɔ Kunzi ʉgyɨlya ndɨ ɓatʉ nɨɓɔ ɓakamibigʉ Kunzi pisi ka ligubo kakɨ. ");
INSERT INTO lik_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Nɨyɔ ɓazɛɛ ɓʉkana lɨkpʉmʉka li nɨlɔ, ɓabibisa ndɨ Kunzi. Kumbuso yi, ɓaɓɨkya ndɨ Pɔlɔ ɓɛ: «Mamakɨ, watʉkaɨna ɓɛyɔ Ɓayuda ɓudingi ɓoboilyi mino ɓɛnɛ, ɨɓʉ ɓasɨ ɓakaɓyɛ mʉtʉʉ ka Musa lɨmbɛngɨ limoti. ");
INSERT INTO lik_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Wɨna sɛ, ɓukoni ɓi ɓɛ a abɛ wakaʉtɨwa Ɓayuda ɓasɨ nɨɓɔ ɓikaga luga ka ɓɛvananza ɓayagɔgɔ ɓɛ ɓasɨ kaɓyɛ mʉtʉʉ ka Musa. Upokyi ɓi gɔnɨ ɓɛ ɓakukusisonitɔgʉ ɓomikaɓʉ, ɓakoɓyonitɔgʉ yɨgya ya ɓʉndɛlɨ ka Ɓayuda. ");
INSERT INTO lik_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Tagya sɛ kʉwa ɓʉnɨ kyɛ ɓibatʉ aka ɓɛ wosiliniku wanʉ? ");
INSERT INTO lik_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Yɛkɨ a ɓɛyɔ, gya nɛkɨ nɨlɔ takaʉɓɨkya. Ta wanʉ na ɓalʉkʉ ɓakwanganya nɨɓɔ ɓakoni silika kambwa ko Kunzi kaɨpá ko Kunzi. ");
INSERT INTO lik_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Windoni pa imoti na ɨɓʉ, miɓuɓisoku. Kalyatʉ gɔnɨ nɨlɔ okwononi kyɛ ɓiwisisi ɓamʉ. Kʉwa wa, ɓambanzʉ ɓasɨ ɓakwanana kaiba ɓɛ mongoni masɨ nɨmɔ ɓʉkana ndɨ ko bulya kakʉ a maɓɔngɔ. Luki limoti, ɓibo gɔnɨ ɓɛ ɨwɛ wagyagatʉ mʉtʉʉ. ");
INSERT INTO lik_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Tukpikilyini ɓi ɓatʉ nɨɓɔ ɓabaya nɨ ɓakɛgʉ Ɓayuda nɨlɔ ɓakwanana kagya. Ɓakakwananɨgʉ kalya makɔlɔ nɨmɔ ɓopí ɓokunzi ka ɓapɛpɛ, ikanɨ kalya ɓangʉ gʉtʉgʉ nyama yi nɨnɔ ɓamwogo kanɨ ɓadulini ɓasɔngʉ, ɓakogyonitɔgʉ gɔnɨ ɓʉɗanda.» ");
INSERT INTO lik_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Ɓʉgala ɓi, Pɔlɔ ɓɨnda ndɨ na ɓalʉkʉ ɓi nɨɓɔ, ɓiɓuɓisa ndɨ. Kumbuso yi, ingya ndɨ ka Ndaɓʉ ko Kunzi, ʉtʉmbʉlyaga ndɨ ɓɛ masyɛ ma kiɓuɓiso osyo ko ngbingo tino, isi yi ɓɛ ɓakwanana kaʉpɨ́lya ɓemoti-ɓemoti apɛpɛ ngbingo tino. ");
INSERT INTO lik_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Nɨyɔ masyɛ maɗɨya na ɨka a kʉwa ndɨ ɓuwobi kosyo, Ɓayuda nɨɓɔ ɓa Azia ɓamɨna ndɨ Pɔlɔ ka Ndaɓʉ ko Kunzi. Kʉwa wa, ɓavikimosaga ambaza wasɨ ka ɓambanzʉ, ɓagwi ndɨ Pɔlɔ. ");
INSERT INTO lik_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Ɓanapamɨkanaga ɓɛ: «Iɓunu Ɓezaleli, singyoniku! Alʉkʉ yi nɨmʉ nɔ akaɓɨkyaga ka ɓapa ɓayasɨ, akaʉpá ɓambanzʉ ɓasɨ mʉtɨwɨ manyɛ ko bulya kusu, ko bulya mʉtʉʉ ka Musa na ko bulya Ndaɓʉ ko Kunzi yi nɨyɨ. Umokyini gɔnɨ ɓatʉ ɓi nɨɓɔ ɓakɛgʉ Ɓayuda ka Ndaɓʉ ko Kunzi, ɓapʉta pa Yotu yi nɨyɨ.» ");
INSERT INTO lik_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","A ɓɛyɔ, ɓamɨnatʉ ndɨ Pɔlɔ kambwa wa ka Yelusalɛma na Mʉɛfɛsɔ ɓemoti nɨnɔ ina ndɨ ɓɛ Tolofimo. Ɨɓʉ ɓa ndɨ kasɨma ɓɛ Pɔlɔ amingyisatʉ ndɨ ka Ndaɓʉ ko Kunzi. ");
INSERT INTO lik_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Gʉɗʉ wasɨ avɨkɨmanaga ndɨ, ɓambanzʉ ɓotinikoku ndɨ ɓingbufu. Ɓagwi Pɔlɔ, ɓaluta ndɨ ɓikpwukpwukpwu kunzi wa Ndaɓʉ ko Kunzi. Kumbuso yi, ɓadʉlaga ndɨ pumi yi. ");
INSERT INTO lik_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Ɓa kʉwa ndɨ kakɨsa kamwɔ. Kʉwa wa, mongoni asilya ndɨ ngama ka ambaza wa ɓasʉda ɓɛ gʉɗʉ wasɨ wa Yelusalɛma ovikimonogini. ");
INSERT INTO lik_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Ko ngbingo yi nɨnɔ aka nɔ, ʉva ndɨ ɓasʉda na ɓakʉmanda kaɓʉ ɓaga ndɨ ɓangʉ kʉ ɓɛyɔ. Nɨyɔ ɓambanzʉ ɓʉmɨna, ɓasa ndɨ kabʉma Pɔlɔ. ");
INSERT INTO lik_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Ngama ka ɓasʉda isisiloku kʉwa ndɨ ɓuwobi na ɨyɨ, agwisiso. Akpamya ɓɛ ɓakandɨ na ɓaselegeni ɓayɨɓa. Kumbuso yi, uusa ɓɛ: «Wanɨ mʉ? Ogyi ɨkɨ?» ");
INSERT INTO lik_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Luki limoti, luga wa ambaza wa, ɓambanzʉ ɓa ndɨ kapamɨkana gbalɨ kanɨ ngama ka ɓasʉda kotombisyagʉ gʉtʉgʉ lɨkpʉmʉka limoti aka, kinili, akpamya kʉwa ndɨ ɓɛ ɓaga na Pɔlɔ ka mʉkɔɓɔ ka ɓasʉda. ");
INSERT INTO lik_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Nɨyɔ Pɔlɔ osilo ka mupumi, ɓasʉda ɓabɨnɨka ndɨ kyɛ ambaza ka ɓambanzʉ a ndɨ nɨ ovikimonogini. ");
INSERT INTO lik_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","A ɓɛyɔ, ɓatʉ ɓasɨ ɓa ndɨ kaɓɨɓya, ɓanapamɨkanaga ɓɛ: «Mumwoni!» ");
INSERT INTO lik_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Ngbingo yi nɨnɔ ɓa ndɨ kʉwa mino ɓuwobi kamakya Pɔlɔ ka mʉkɔɓɔ ka ɓasʉda, ɨyɨ aka ndɨ na ngama ka ɓasʉda ɓɛ: «Wakwananatʉ kɛsɨlya ngbingo kaɓɨkya lɨkpʉmʉka?» Ngama ka ɓasʉda amuusa ndɨ ɓɛ: «Wibatʉ Ligiliki? ");
INSERT INTO lik_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Kɛgʉ ɨwɛ nɨ Mumisili yi nɨnɔ opí ɓi ɨpʉmbʉ ka masyɛ mi nɨma, ʉva ɓonzikaɓʉ ɓɛlɔfʉ ɓatɛkɛɓɛ ɓakwanganya kaɨnda na ɨɓʉ ka ɨsa?» ");
INSERT INTO lik_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pɔlɔ asikisya ndɨ ɓɛ: «Ɨmɨ, na Muyuda wa Talasɨ, ka iwili ya Kilikia. Nɨɓʉkʉta ka gʉɗʉ wa kinisono. Kikiliki, ɨsɨlya mbɛyɨ mino ngbingo nanzɨnɨ na ɓatʉ ɓi nɨɓa.» ");
INSERT INTO lik_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Ngama asɨlya ndɨ mʉnzɨna. Pɔlɔ amaga kʉwa ndɨ ko misa ma mupumi, ʉgbʉma ndɨ ɓambanzʉ na kʉɓɔkʉkɔ. Nɨyɔ ɓadaka, ʉɓɨkya ndɨ na Libelenia ɓɛ: ");
INSERT INTO lik_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","«Ɓomika-mama, ɓababa, pongoni mbɛyɨ motili ka nɨlɔ nakamʉɓɨkya mbɨya wanʉ kowonisilo ɓɛ nakogyigʉ ɓʉnyɛ.» ");
INSERT INTO lik_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Nɨyɔ ɓamʉkana Pɔlɔ nɨ akanzɨna lɨva-kʉkaɓʉ ɓɛyɔ, ɨɓʉ aka ndɨ ɓiwo. Pɔlɔ aka ndɨ na ɨɓʉ ɓɛ: ");
INSERT INTO lik_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","«Ɨmɨ, na Muyuda. Nɨɓʉkʉta ka Talasɨ ka iwili ya Kilikia, luki limoti, nopinga wa ka Yelusalɛma wa. Gamalieli nɔ a ndɨ malima kamɨ. Ewonisilaga ndɨ ɓɛyɔ okwononi mino kaɓyɛ mʉtʉʉ ka ɓotitosu ka ɓungbingbili. Nagugubya ndɨ Kunzi na kɛkɛlɛ ɓɛgɛyɔ iɓunu ɓasɨ mo mino kagya na lɨsyɛ li nɨlɨ. ");
INSERT INTO lik_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Nugyogyisaga ndɨ, numwisiso ɓatʉ nɨɓɔ ɓaɓɨɓyaga ndɨ pisi ko Mombukwono-dosu. Nugwisisaga ndɨ ɓalʉkʉ na ɓoko ka bɔlɔkɔ. ");
INSERT INTO lik_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Kumu-kumu na basa yasɨ ka ɓazɛɛ ɓakaiba ɓɨnza nɨlɔ nakaɓɨkya. A ɓɛyɔ, ɓɛpátʉ ndɨ ɓabalʉwa kaupoku ɓomomosu ɓa Damasɨkɨ. Na ndɨ kapa kaɨnda kaugwi ɓakilisito nɨɓɔ ɓa ndɨ kʉ, kodoku na ɨɓʉ kaugyogyiso ka Yelusalɛma.» ");
INSERT INTO lik_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","«Na mbɛyɨ ndɨ ko pisi aka, ɓuwobi kadwɛ ka Damasɨkɨ. Mɔnɨ a kʉwa ndɨ banda ka mʉsɨkatʉ, ko ngbinga ɓemoti aka, ɓʉngbanganya osyoku ndɨ ɓigbututu kotukyoku kʉgʉ wa lɨsyɛ, ekungulo ɓikululu. ");
INSERT INTO lik_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Nogwa ndɨ wasɨ ɓɨngɔmʉ, nʉkana lɨyʉ limoti anɛɓɨkya ɓɛ: ‹Saulo, Saulo, ko bulya ɨkɨ yɔ wo mino kegyogyiso?› ");
INSERT INTO lik_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Nuusa ndɨ ambɛ: ‹Ɨwɛ nɨ wanɨ, Mombukwono-dosu?› Lɨyʉ li nɨlɔ esikisyo ɓɛ: ‹Ɨmɨ nɨ Yeso wa Nazalɛtɨ nɨnɔ wakegyogyiso nɔ.› ");
INSERT INTO lik_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Ɓatʉ ɓi nɨɓɔ ta ndɨ pa imoti na ɨɓʉ ɓɨnatʉ ndɨ ɓʉngbanganya ɓi nɨɓɔ, luki limoti nɨ ɓakukonigʉ lɨyʉ li nɨlɔ. ");
INSERT INTO lik_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Nuusa kʉwa ndɨ ɓɛ: ‹Mombukwono-dosu, nagyɨ sɛ ɓʉnɨ?› Esikisya ndɨ ɓɛ: ‹Wamaga, waga ka Damasɨkɨ. Kʉ ɓɛyɔ, ɓʉɓɨkyatʉ makpʉmʉka masɨ nɨmɔ Kunzi akaʉkpamya ɓɛ gya.› ");
INSERT INTO lik_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Miso epiya ndɨ ɓipi na ɓʉpʉ ɓa ɓʉngbanganya ɓi nɨɓɔ. Ɓatʉ nɨɓɔ ta ndɨ na ɨɓʉ ɓegwi kʉwa ndɨ kʉɓɔkʉkɔ, ɓaga na ɨmɨ ka Damasɨkɨ. ");
INSERT INTO lik_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Kʉ ɓɛyɔ, a ndɨ na mʉlʉkʉ ɓemoti nɨnɔ ina ndɨ ɓɛ Anania. Aɓangagatʉ ndɨ Kunzi, anaɓyɛ mʉtʉʉ kusu. Ɓayuda ɓasɨ nɨɓɔ ɓikaga ndɨ kʉ ɓabɨbaga ndɨ kʉgbɛ. ");
INSERT INTO lik_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Anania esilyoku ndɨ, ɨyɨ aka na ɨmɨ ɓɛ: ‹Saulo, mika-mama, miso ʉkʉlɨkanɨ!› Ko ngbingo yi nɨnɔ aka nɔ, miso ɛkʉlɨkana ndɨ, namɨna Anania. ");
INSERT INTO lik_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Kumbuso yi, ɛɓɨkya ndɨ ɓɛ: ‹Kunzi ka ɓotitosu upunogoni ndɨ kambwa aka ɓɛ wiba sɨpananɨsɔ kakɨ, wamɨna Mʉtʉ Wongbingbili, ʉkana lɨyʉ kakɨ. ");
INSERT INTO lik_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","A ɓɛyɔ, wika dɛmʉ kakɨ ko misa ka ɓatʉ ɓasɨ kaɓɨkyaga nɨlɔ wini ɓi na nɨlɔ ukoni ɓi. ");
INSERT INTO lik_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Mbɨya wanʉ, wakaɓʉnda ɓata ɨkɨ? Wamaga, wiɓotisiso, wakʉnga mʉpɨlya ma ɓʉnyɛ ko lino kakɨ.›» ");
INSERT INTO lik_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","«Kumbuso yi, nigoku ndɨ ka Yelusalɛma. Lɨsyɛ limoti, nɨyɔ na ndɨ kalʉmba ka Ndaɓʉ ko Kunzi, ɛgyɨlya ndɨ abɛ nakika ko nziki, ");
INSERT INTO lik_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","namɨna ndɨ Mombukwono-dosu, ɛɓɨkya ɓɛ: ‹Wiɗuso, tʉkya ɓɨgala-gala ka Yelusalɛma wa. A ɓɛyɔ, ɓatʉ nɨɓana wanʉ ɓakapagʉ ɓanʉ kaʉkana lɨkpʉmʉka li nɨlɔ ʉɓɨkyaga ɓanʉ ko bulya kamɨ.› ");
INSERT INTO lik_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Nasikisya ndɨ ɓɛ: ‹Mombukwono-dosu, ɓakaiba ɓɨnza ɓɛ nogulyaga ndɨ ka ɓandaɓʉ ɓaya malʉmba ka Ɓayuda kaugwisiso na kaubumisiso ɓatʉ nɨɓɔ ɓʉɓɨnɨkyana. ");
INSERT INTO lik_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ngbingo yi nɨnɔ ɓamwɔ ndɨ mino dɛmʉ kakʉ ɓɛyɔ ka Etieni, ɨmɨ mombukwana-dakɨ na ndɨ wa gɔ wa, noɓingisya ndɨ ɓɛ ɓamwɨ, noɓuulyaga gɔnɨ ndɨ ɓotu ka ɓatʉ ɓi nɨɓɔ ɓa ndɨ kamwɔ.› ");
INSERT INTO lik_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Kʉwa wa, Mombukwono-dosu ɛɓɨkya ndɨ ɓɛ: ‹Waga, kyɛ nakaʉtɨka ɓyɨ, ka ɓɛvananza ɓayagɔgɔ.›» ");
INSERT INTO lik_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Ɓambanzʉ ɓʉkana ndɨ mʉtʉmbʉlagɨ ka Pɔlɔ kadwɛ ka mʉnzɨna mi nɨma. Kʉwa wa, ɓapʉnga ndɨ kapamɨkana, ɓanaɓɨkya ɓɛ: «Mumwoni mʉtʉ yi nɨmʉ! Mumwoni! Mʉtʉ ɓɛyɔ ka nɨmʉ, kokwononigʉ na ɔɓɨlɨ!» ");
INSERT INTO lik_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ɓa ndɨ kapamɨkanaga, ɓanombimbo ɓotu na komisyo liɓungu kʉgʉ. ");
INSERT INTO lik_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Ngama ka ɓasʉda akpamya kʉwa ndɨ ɓɛ ɓaga na Pɔlɔ ka mʉkɔɓɔ kaɓʉ, ɓatɨnɨ fimbo ɓɛ kyɛ anzɨnɨ. A ɓɛyɔ, a ndɨ kapa kaiba ɓɛ ɓambanzʉ ɓakapamɨkanaga ɓɛyɔ ko bulya ɨkɨ. ");
INSERT INTO lik_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Nɨyɔ ɓa kʉwa ndɨ kakanda Pɔlɔ ɓɛkyɛ ɓatɨnɨ, ɨyɨ Pɔlɔ aɓɨkya kʉmanda nɨnɔ a ndɨ wa ɓɛ: «Ɓabʉmagatʉ Mʉlʉma nɨ ɓakasombisigʉ?» ");
INSERT INTO lik_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Nɨyɔ kʉmanda yi nɨnɔ ʉkana ɓɛyɔ, ɨnda ndɨ katʉmbʉlyaga ngama kakɨ, aɓɨkya ɓɛ: «Wagya sɛ kʉwa ɓʉnɨ? Alʉkʉ yi nɨmʉna a Mʉlʉma!» ");
INSERT INTO lik_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Ngama odoku kʉwa ndɨ, amuuso Pɔlɔ ɓɛ: «Ɨɓɨkya, ɨwɛ, wa Mʉlʉma?» Pɔlɔ oɓingisyo. ");
INSERT INTO lik_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Kʉmanda aka ndɨ ɓata na ɨyɨ ɓɛ: «Nakalya ndɨ ɨmɨ ɓuyi ɓakpʉ ɓɛ kyɛ niki Mʉlʉma.» Pɔlɔ asikisya ndɨ ɓɛ: «Ɨmɨ, na Mʉlʉma ɓɨkpɛ.» ");
INSERT INTO lik_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Ko ngbingo yi nɨnɔ aka nɔ, ɓatʉ nɨɓɔ ɓa ndɨ kapa kanziniso Pɔlɔ na mapʉpʉ ɓomisikana ndɨ. Nɨyɔ kʉmanda iba ɓɛ akondisisi ɓi Mʉlʉma, ogwa ombombo. ");
INSERT INTO lik_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Ɓʉgala ɓi, ngama ka ɓasʉda a ndɨ kapa kaiba ɓɨnza ɓɛ Ɓayuda ɓasungulyi Pɔlɔ ko bulya ɨkɨ. Ʉkpamya kʉwa ndɨ ɓatʉ kakɨ ɓɛ ɓakulogiku, ʉkpamya gɔnɨ ɓokumu-kumu na ɓatʉ ɓa Basa-Yidingi ɓasɨ kamʉmʉkana. Kumbuso yi, ɓodoku ndɨ na Pɔlɔ, ɓamomosa kambwa kaɓʉ. ");
INSERT INTO lik_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pɔlɔ ʉnda ndɨ ɓatʉ ɓa Basa-Yidingi ɓɨngbangbangba, ɨyɨ aka na ɨɓʉ ɓɛ: «Ɓomika-mama, lɨmbɛngɨ kɛgʉ kɛdwa ka ligubo lasɨ nɨlɔ nagyɨlya Kunzi kadwɛ na lɨsyɛ li nɨlɨ.» ");
INSERT INTO lik_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Luki limoti, kumu-kumu Anania ʉkpamya ndɨ ɓatʉ nɨɓɔ ɓa ndɨ ɓuwobi na Pɔlɔ ɓɛ ɓaɓɨtɨ. ");
INSERT INTO lik_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Kʉwa wa, Pɔlɔ aɓɨkya ndɨ ɓɛ: «Kunzi nɔ ʉɓɨta kʉwa ɓanʉ ɨwɛ, ɨwɛ nɨnɔ abɛ likingyosi la ikubasʉ sa ndaɓʉ si nɨsɔ ɓoɗingogo na pɛmbɛ. Wa wakiko kesombiso ɓɛyɔ mʉtʉʉ aɓɨkyaga mino, wɨna sɛ, ɨwɛ ɓɨkpɛ woɓunini mʉtʉʉ ɓɛyɔ weɓitisisi mino yi!» ");
INSERT INTO lik_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Ɓatʉ nɨɓɔ ɓa ndɨ ɓuwobi na Pɔlɔ wa, ɓaɓɨkya ndɨ ɓɛ: «Kumu-kumu ko Kunzi nɔ wakaɓuɓisa ɓɛyɔ!» ");
INSERT INTO lik_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pɔlɔ osikisya ndɨ ɓɛ: «Ɓomika-mama, nakɛgʉ ɓi kaiba ambɛ kumu-kumu nɔ. A ɓɛyɔ, ikpiko ka Moɓiso Motu ɓɛ: ‹Wakatumbwonitɔgʉ ngama wa lɨvananza kakʉ.›» ");
INSERT INTO lik_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Pɔlɔ a ndɨ kaiba ɓɛ ɓambanzʉ ɓagɔgɔ ka Basa-Yidingi wa, ɓa ndɨ Ɓasadukayɔ na ɓagɔgɔ Ɓafalisayɔ. Kinili, aɓɨkya ndɨ na lɨyʉ lapʉ kambwa kaɓʉ ɓɛ: «Ɓomika-mama, ɨmɨ na Mufalisayɔ, mikya-ɓafalisayɔ. Kika nɨ nakasamba, a kyɛ na na mʉtamanagɨ ambɛ ɓatʉ nɨɓɔ ɓokwaga ndɨ, ɓopupokuto ndɛkɛ ka ɓambʉkʉ.» ");
INSERT INTO lik_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Nɨyɔ aɓɨkya ɓɛyɔ, Ɓafalisayɔ ɓapʉnga ndɨ kasaana na Ɓasadukayɔ, ɓambanzʉ ɓɨgbananaga ndɨ. ");
INSERT INTO lik_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","A ɓɛyɔ, Ɓasadukayɔ ɓaɓɨkyaga ɓɛ kumbusa wa kukwakʉ, ɓakopupogigʉ ka mbʉkʉ. Ɓomotiloku gɔnɨ ɓɛ ɓamalaika ɓakɛgʉ, gʉtʉgʉ lɨmbɛngɨ ko Kunzi aka. Luki limoti, Ɓafalisayɔ ɓaɓɨnɨkyanagatʉ ɨɓʉ makpʉmʉka mi nɨmɔ masɨ. ");
INSERT INTO lik_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Gbʉngbʉ aka ndɨ ɓihooo! Ɓowonisilo ɓa mʉtʉʉ ɓagɔgɔ ka liɗu ka Ɓafalisayɔ ɓamanana ndɨ ɓigwo, ɓagya ndɨ ɓoɗongoso yapʉ, ɨɓʉ aka ndɨ ɓɛ: «Takaɨna abɛ alʉkʉ yi nɨmʉ kogyigʉ luki lanyɛ gʉtʉgʉ limoti aka. Abɨlɨ ikanɨ malaika sɛ nɔ anzinilyi ɓi?» ");
INSERT INTO lik_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Nɨyɔ ɗongoso atʉkya kʉwa ka ɓakpɨɓa, ngama ka ɓasʉda aɓanga ndɨ ɓɛ ɓakasinzogonitɔgʉ Pɔlɔ. Kinili, ʉkpamya ndɨ ɓasʉda kosyo luga ka ɓatʉ nɨɓɔ ɓamʉmʉkana ndɨ wa, ɓanyoku, ɓamigiso ka mʉkɔɓɔ. ");
INSERT INTO lik_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","No biti yi nɨyɔ aka yɔ, Mombukwono-dosu apuponilya ndɨ Pɔlɔ, aɓɨkya ɓɛ: «Wigwinɔ lɨmbɛngɨ aka! Mʉɗɔngɔnɨ ɓɛyɔ waɓɨkyaga ndɨ mino lɨkpʉmʉka kamɨ ka Yelusalɛma, okwononi kagya ɓɛgɛyɔ ka Lʉma.» ");
INSERT INTO lik_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Ɓʉgala ɓagɔgɔ, Ɓayuda ɓemoti-ɓemoti ɓagya ndɨ dikiɗi ɓɨpɛlɛ. Ɓakɔ ndɨ silika ɓɛ ɓakalyalyɨgʉ ikanɨ komwo luki kadwɛ kʉ kwa kʉ ɓamwɔ mino Pɔlɔ. ");
INSERT INTO lik_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Ɓatʉ ɓi nɨɓɔ ɓagya ndɨ dikiɗi yi nɨyɔ, ɓa ndɨ kakɨtaga ɓatɛkɛɓɛ ɓakwanganya. ");
INSERT INTO lik_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Ɓaga ndɨ ka ɓokumu-kumu na ɓazɛɛ, ɓʉɓɨkya ɓɛ: «Iɓusu, takuni ɓi silika ambɛ takalyɨgʉ luki kanɨ takanamwigʉ Pɔlɔ. ");
INSERT INTO lik_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Mbɨya wanʉ, ukononi na ɓatʉ ɓa Basa-Yidingi, maɓikyoku ngama ka ɓasʉda ɓɛ amunyulyiku Pɔlɔ kyɛ makapa kakpɨma lɨkpʉmʉka kakɨ ɓɨnza. Tika kʉwa iɓusu ɓakɨlɨka kamosisyo kanɨ kanosilikugʉ wanʉ.» ");
INSERT INTO lik_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Luki limoti, mʉbʉbʉgʉ ɓemoti ka Pɔlɔ ʉkana ndɨ dikiɗi yi nɨyɔ. Aga ndɨ ka mʉkɔɓɔ, ogulyo, atʉmbʉlyaga ndɨ lɨkpʉmʉka li nɨlɔ. ");
INSERT INTO lik_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Kʉwa wa, Pɔlɔ amaka ngama ka ɓasʉda ɓemoti, ɨyɨ aka na ɨyɨ ɓɛ: «Mubisoku mbɛyɨ mʉwanza nɨmʉ kʉ ka kʉmanda kyɛ a na lɨkpʉmʉka kaɓɨkya.» ");
INSERT INTO lik_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Ngama ka ɓasʉda yi nɨnɔ, ɓaga ndɨ na mʉwanza nɔ kʉ ka kʉmanda, aɓɨkya ɓɛ: «Mʉtʉ wa bɔlɔkɔ nɨnɔ ina ɓɛ Pɔlɔ, emoki, ɛɓɨkya ɓɛ noduku no mikya-ɓawanza yi nʉmʉna kʉnʉ kyɛ a na lɨkpʉmʉka kauzukilyogo.» ");
INSERT INTO lik_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Kʉmanda amaka ndɨ mʉwanza nɔ ɓɨkɛɗɛ, amuusa ɓɛ: «A sɛ ɓʉnɨ?» ");
INSERT INTO lik_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Asikisya ndɨ ɓɛ: «Ɓayuda ɓukononi ɓi ɓɛ ɓakaʉkʉnga Pɔlɔ na ɓʉgala, upupisilyoku kambwa ka ɓatʉ ɓa Basa-Yidingi abɛ ɓakiko kapa ɓakpɨmɨ lɨkpʉmʉka kakɨ ɓɨnza. ");
INSERT INTO lik_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Luki limoti, wakukononitɔgʉ. A ɓɛyɔ, ɓambanzʉ kakɨtaga ɓatɛkɛɓɛ ɓakwanganya luga kaɓʉ ɓa na ɨyɨ mʉlɨka. Ɓaku ɓi silika ɓɛ ɓakalyalyɨgʉ ikanɨ komwo luki kanɨ ɓakanamwigʉ. Mbɨya wanʉ, ɓa ɓakɨtʉlya kaɓʉndaga kʉwa nɨlɔ aka lɔ waɓɨkya.» ");
INSERT INTO lik_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Kʉwa wa, kʉmanda ɓasanana ndɨ na mʉwanza yi nɨnɔ nɨ agbityogini ɓɛ katumbulyogonitɔgʉ mʉmbanzʉ lɨkpʉmʉko li nɨlɔ. ");
INSERT INTO lik_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Kʉwa wa, kʉmanda ʉmaka ndɨ ɓangama ka ɓasʉda ɓaɓa luga ka nɨɓɔ ɓagɔgɔ, ʉɓɨkya ɓɛ: «Huvoni ɓasʉda ɓamɨya ɓaɓa, mʉva ɓatɛkɛɓɛ maɗɨya na ɨka nɨɓɔ ɓabʉmanaga kʉgʉ wa ɓapunda na ɓamɨya ɓaɓa nɨɓɔ ɓabʉmanaga na ɓosyogbu. Ɓiki ɓakɨtʉlya kaɨnda ka Kaizalɨa na saa-tatʉ yo biti. ");
INSERT INTO lik_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Muɓungusilyogonito gɔnɨ Pɔlɔ ɓapunda nɨɓɔ ɓakpokyoniso, ɓadwiso ɓɨnza kʉ ka ngama Felisi.» ");
INSERT INTO lik_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Kumbuso yi, akpika ndɨ ɓalʉwa ɓɛ: ");
INSERT INTO lik_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","«Ɨmɨ Kɔlɔdɛ Lusiasi, numuusogito ɨwɛ ngama wa ɨbɨba kʉgbɛ ɓɛyɔ ka Felisi. ");
INSERT INTO lik_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Ɓayuda ɓo ɓi nɨ ɓagwini alʉkʉ yi nɨmʉna nutikilyi mʉ, ɓo ɓi kapa kamwɔ. Nɨyɔ nukoni ɓi ɓɛ a Mʉlʉma, nasingyo ɓi na ɓasʉda kamɨ, nahukusogo. ");
INSERT INTO lik_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Yɛkɨ no ɓi kapa kaiba ambɛ Ɓayuda ɓasungulyi ko bulya ɨkɨ, nago ɓi na ɨyɨ ka Basa-Yidingi kaɓʉ. ");
INSERT INTO lik_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Nini ɓi ambɛ ɓo ɓi kagya ɓoɗongoso na Pɔlɔ ko bulya mʉtʉʉ kaɓʉ. Luki limoti, kɛgʉ na ɨɓɔ gʉtʉgʉ yimoti aka nɨyɔ ɓakwanana mino kamwɔ ikanɨ kagwi. ");
INSERT INTO lik_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Nɨyɔ nukoni ɓi ɓɛ Ɓayuda ɓakagyɨlya dikiɗi kyɛ ɓamwɨ, nʉtɨkɨlyo ɓi ɓɨgala-gala. Nʉɓɨkyo ɓi ɓatʉ ɓi nɨɓɔ ɓasungulyi ɓi ambɛ ɓɨndɨ na ngbanga yi nɨnɔ kʉ kakʉ.» ");
INSERT INTO lik_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Ɓasʉda ɓagya ndɨ ɓɛyɔ aka yɔ ɓʉkpamya ndɨ mino. Ɓava ndɨ Pɔlɔ, ɓaga na ɨyɨ no biti yi nɨyɔ aka yɔ kadwɛ kʉ kwa kʉ ka gʉɗʉ wa Atipatilisi. ");
INSERT INTO lik_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Ɓʉgala ɓi, ɓasʉda ɓi nɨɓɔ ɓa ndɨ na magʉ ɓigononoku kʉwa ndɨ ɨɓʉ ka mʉkɔɓɔ, ɓʉsa ndɨ nɨɓɔ ɓa ndɨ kʉgʉ wa ɓapunda kaidukulogo na Pɔlɔ. ");
INSERT INTO lik_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Nɨyɔ aka yɔ ɓosilo ka Kaizalɨa, ɓapá ndɨ ngama Felisi ɓalʉwa, ɓawanya kʉwa gɔnɨ ndɨ Pɔlɔ. ");
INSERT INTO lik_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Ngama atangʉlaga ndɨ, amuuso Pɔlɔ ɓɛ: «Wa mʉtʉ wa iwili tino?» Nɨyɔ ʉkana ndɨ ɓɛ Pɔlɔ a mʉtʉ wa Kilikia, ");
INSERT INTO lik_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ɨyɨ aka ndɨ na ɨyɨ ɓɛ: «Tanda lɨkpʉmʉka kakʉ ngbingo yi nɨnɔ ɓatʉ nɨɓɔ ɓusungulyi ɓi, ɓosiloku ɓanʉ mino.» Akpamya ndɨ ɓɛ ɓaɓuulyogi Pɔlɔ ka ndaɓʉ nɨyɔ Ɛlɔdɨ Mbɔkʉ opikisisa ndɨ. ");
INSERT INTO lik_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Kumbusa wa masyɛ kuɓukumuti, Kumu-Kumu Anania, ɓazɛɛ ɓemoti-ɓemoti pa imoti na bʉbʉma wa mʉnzɨna ɓemoti nɨnɔ ina ndɨ ɓɛ Teletulo ɓɨnda ndɨ ka Kaizalɨa. Kʉ ɓɛyɔ, ɓasʉngʉlya ndɨ Pɔlɔ ka ngama Felisi. ");
INSERT INTO lik_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Ɓamokoku ndɨ Pɔlɔ, Teletulo apʉnga ndɨ kaɓɨkya ɓɛ: «Ngama, kiki ndɨ ɨwɛ, iba takɛgʉ motili ɓɨdɛɛɛ. A ɓɛyɔ, ɓʉbʉbʉma ɓa ligubo kakʉ oyikosoni makpʉmʉka mudingi ka mugi mi nɨma. ");
INSERT INTO lik_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Ngama, tubibisaga ɓongbinga ɓasɨ na ka ɓapa ɓayasɨ, ka masɨ nɨmɔ wagyaga. ");
INSERT INTO lik_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Kʉwa wa gɔ wa, nakɛgʉ kapa kaʉlyɨlya ngbingo, no ɓi kapa ambɛ watimukonino gʉtʉgʉ mbɛyɨ ɓi ko ngbinga mʉkɛɗɛ. ");
INSERT INTO lik_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Tini ɓi iɓusu ambɛ alʉkʉ yi nɨmʉ a luki lanyɛ, ɨyɨ abɛ ngama ka liɗu ka ɓatʉ ɓa Nazalɛtɨ, akaudwonoso Ɓayuda ɓasɨ ɓa ɔɓɨlɨ. ");
INSERT INTO lik_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Okingilito ɓi gɔnɨ kagya makɔkɔ ka Ndaɓʉ ko Kunzi, tagwi kʉwa ɓi. To ɓi ɓɛ tasombisi kaɓyɛnɛnɛ na mʉtʉʉ kusu, ");
INSERT INTO lik_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","luki limoti, kʉmanda Lusiasi odoku ɓi no ɓou katɨkʉpya. ");
INSERT INTO lik_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Ʉkpamya ɓi ɓatʉ nɨɓɔ ɓasungulyi ɓi kodoku kʉ kakʉ. Wakwanana kʉwa mbɛyɨ kamuusogo nɨ ɨwɛ mombukwana-dakɨ yi, wiba ikanɨgʉ takaɓɨkya ɓɔngɔ.» ");
INSERT INTO lik_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Ɓayuda ɓoɓingisya ndɨ, ɨɓʉ aka ɓɛ a ɓɛyɔ aka yɔ Teletulo oɓikyi mino yɔ. ");
INSERT INTO lik_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Kʉwa wa, ngama Felisi akpamya ndɨ Pɔlɔ ɓɛ anzɨnɨ, Pɔlɔ aka ndɨ ɓɛ: «Ngama, nakaiba ambɛ wa zozi wandɛlɨ ka mugi mi nɨma, kinili nakasamba kambwa kakʉ lɨmbɛngɨ ɓipisiii. ");
INSERT INTO lik_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Wakwanana kakpɨma ɨwɛ mombukwana-dakɨ yi ambɛ kanokitogigʉ masyɛ tɛkɛɓɛ na maɓa, wa noɗoki ɓi mino kabibiso Kunzi ka Yelusalɛma. ");
INSERT INTO lik_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Mʉmbanzʉ gʉtʉgʉ ɓemoti aka ketokonyigʉ ɓi ka ɓoɗongoso ka Ndaɓʉ ko Kunzi, ikanɨ ka ndaɓʉ ya malʉmba ka Ɓayuda ikanɨ ka gʉɗʉ ikanɨ kakpamya ambaza ka ɓambanzʉ kavɨkɨmanaga. ");
INSERT INTO lik_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ɓatʉ ɓi nɨɓana ɓesungulyi mbɨya wanʉ, ɓakakwananɨgʉ kaumibiso ɓɛ ɓesungulyi ko bulya ɨkɨ. ");
INSERT INTO lik_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Luki limoti, nakaiba ambɛ nagugubyaga Kunzi nɨnɔ ka ɓotitosu, nanaɓyɛ pisi ka Mombukwono-dosu, nɨyɔ ɨɓʉ ɓalɨkyaga ɓɛ lɨgbʉta ka ɓatʉ ɓa kʉɓɔɓɔkʉ. Na gɔnɨ na baya ka masɨ nɨmɔ ikpikaga ka kɨtaɓʉ ya Mʉtʉʉ na ka ɓakɨtaɓʉ ka Ɓogyalandʉ. ");
INSERT INTO lik_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Mʉtamanagɨ kamɨ a makɨtʉlya ko Kunzi. Ɨɓʉ ɓa gɔnɨ na mʉtamanagɨ mi nɨmɔ ɓɛ ɓatʉ ɓa ɓungbingbili ikanɨ ɓa kʉɓɔɓɔkʉ nɨɓɔ ɓokwaga ndɨ ɓopupokuto ndɛkɛ ka ɓambʉkʉ. ");
INSERT INTO lik_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Kinili, ɨmɨ, nagyaga kɛkɛlɛ kaiko lɨmbɛngɨ lanza ɓongbinga ɓasɨ kambwa ko Kunzi na kambwa ka ɓambanzʉ. ");
INSERT INTO lik_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Kumbusa wa ɓyanga ɓudingi, nigoku ndɨ ka Yelusalɛma kaʉpápa ɓava-kʉkamɨ na kapá Kunzi ɓapɛpɛ. ");
INSERT INTO lik_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Na ndɨ kaiɓuɓiso ka Ndaɓʉ ko Kunzi, ɓɛtakanya kʉwa ndɨ nɨ nanama ligubo li nɨlɔ. Ambaza ka ɓambanzʉ kɛgʉ ndɨ ikanɨ ɨpʉmbʉ. ");
INSERT INTO lik_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Luki limoti, Ɓayuda ɓemoti-ɓemoti nɨɓɔ ɓotukyoku ndɨ ka Azia, ɓa tʉ ndɨ wa. Ɨɓʉ ɓɔ ɓakwanana ndɨ kodoku kɛsʉngʉlya kʉ kakʉ, ɓakika ndɨ na lɨkpʉmʉka na ɨmɨ. ");
INSERT INTO lik_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Kiki ɓɛyɔ, ɓatʉ ɓi nɨɓana ɓa wanʉ ɓatʉmbʉlagɨ nɛkɨ ɓʉnyɛ nɨɓɔ ɓɛmɨna ndɨ na iɓu wa ɓesombisa ndɨ mino ka Basa-Yidingi. ");
INSERT INTO lik_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Lɨkpʉmʉka limoti aka lɔ naɓɨkya ndɨ na lɨyʉ lapʉ kambwa kaɓʉ ɓɛ: ‹Na na baya ambɛ ɓatʉ nɨɓɔ ɓokwaga ndɨ ɓopupokuto ndɛkɛ ka ɓambʉkʉ, kinili nakasamba na lɨsyɛ li nɨlɨ kambwa kunu.›» ");
INSERT INTO lik_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Yɛkɨ ngama Felisi ibaga ndɨ ɓɨnza pisi ka Mombukwono-dosu, akitisaga ndɨ ngbanga ka lɨsyɛ lagɔgɔ, ɨyɨ aka na ɨɓʉ ɓɛ: «Nakɔ ɓanʉ ngbanga kunu ngbingo yi nɨnɔ kʉmanda Lusiasi odoku ɓanʉ mino.» ");
INSERT INTO lik_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Akpamya kʉwa ndɨ ngama ka ɓasʉda ɓɛ aɓuulyogi Pɔlɔ, anasɨlya gɔnɨ mino ɓongbingo ɓaya kɨnanaga magʉ nɨ kɛgʉ kaʉpakya ɓawai-dakɨ kasingyo. ");
INSERT INTO lik_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Kumbusa wa masyɛ makɛɗɛ, ngama Felisi ɓodoku ndɨ ɨɓʉ na mukakɨ ɓɛyɔ ka Dulusila nɨnɔ a ndɨ Waɓayuda. Ngama atikisya ndɨ Pɔlɔ, ʉkana nɨlɔ Pɔlɔ a ndɨ kaɓɨkya ko bulya baya kʉsɔ ka Yeso-Kilisito. ");
INSERT INTO lik_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Luki limoti, nɨyɔ Pɔlɔ apʉnga ndɨ kaɓɨkyaga Mongoni Manza ko bulya ɓungbingbili, kaigwi lɨmbɛngɨ, mʉngɨmbɔ ka masyɛ nɨmɔ akodoku, Felisi aɓanga ndɨ, ɨyɨ aka ndɨ ɓɛ: «Mbɨya wanʉ, wakwanana mbɛyɨ kaɨga. Nʉmakatʉ ɓanʉ ɓata kumbuso.» ");
INSERT INTO lik_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Ngama a ndɨ na mʉtamanagɨ ɓɛ Pɔlɔ akwananatʉ ndɨ kaɨkalyaga, kinili atikisyaga ndɨ ɓongbinga ɓasɨ kyɛ ɓiki na ɨyɨ ka ɓabʉbʉ. ");
INSERT INTO lik_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Kumbusa wa ɓyanga ɓɨɓa, Pɔlɔkio Fɛsɨtɔ alya ndɨ ɓʉngama ka pa ka Felisi. Yɛkɨ Felisi a ndɨ ɨyɨ kakɨsa kaiponoso na Ɓayuda, asa ndɨ Pɔlɔ ka bɔlɔkɔ aka. ");
INSERT INTO lik_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Nɨyɔ ngama wa iwili ɓɛyɔ ka Fɛsɨtɔ agya masyɛ masaa wa osila ndɨ mino ka iwili yi nɨyɔ, atʉkya ndɨ ka Kaizalɨa aɗaka ka Yelusalɛma. ");
INSERT INTO lik_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Kʉ ɓɛyɔ, ɓokumu-kumu na ɓangama ka Ɓayuda ɓasʉngʉlya ndɨ Pɔlɔ kambwa kakɨ. Ɓamalya lɨkpʉmʉka li no ngu, ");
INSERT INTO lik_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","ɨɓʉ aka ndɨ na ngama Fɛsɨtɔ ɓɛ ʉgyɨlyɨnɔ ɓaka yasɨ kadukusoku Pɔlɔ ka Yelusalɛma wa. A ɓɛyɔ, ɓa ndɨ nɨ ɓalikini ɓɛ ɓamwɨ ko pisi. ");
INSERT INTO lik_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Luki limoti, ngama Fɛsɨtɔ usikisya ndɨ ɓɛ: «Pɔlɔ iki ka bɔlɔkɔ aka kʉ ka Kaizalɨa kʉ, ɨmɨ na na lɨgʉndʉ kʉ gɔ kʉ.» ");
INSERT INTO lik_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Ɨyɨ aka ɓata ɓɛ: «Ɓatʉ ɓi nɨɓɔ ɓanzɨnaga luga kunu ɓakwanana kaɨnda pa imoti na ɨmɨ ka Kaizalɨa. Kika nɨ Pɔlɔ agyatʉ ndɨ ɓʉnyɛ ɓakwanana kasʉngʉlya.» ");
INSERT INTO lik_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Kumbuso Fɛsɨtɔ kagya na ɨɓʉ masyɛ ɓanda ɓʉgɨna ikanɨ tɛkɛɓɛ, ɨga ka Kaizalɨa. Ɓʉgala ɓi, ika ndɨ ka basa yɨkɔ ɓangbanga, akpamya ɓɛ ɓoduku na Pɔlɔ. ");
INSERT INTO lik_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Nɨyɔ osilo, Ɓayuda nɨɓɔ ɓotukyoku ndɨ ka Yelusalɛma ɓakungula ndɨ ɓikululu. Ɓabɨnɨkɨlya ndɨ makpʉmʉka ɓitititi nɨmɔ gʉtʉgʉ ɨɓʉ aka ɓakakwananɨgʉ katʉmbʉlaga mʉ mi. ");
INSERT INTO lik_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Pɔlɔ ɨtʉmbʉlyaga kʉwa ndɨ ɓɛ: «Ɨmɨ nakogyigʉ ɓʉnyɛ gʉtʉgʉ ɓumoti aka, nakoɓunigʉ mʉtʉʉ ka Ɓayuda ikanɨ nɨmɔ ma Ndaɓʉ ko Kunzi gʉtʉgʉ nɨmɔ ka Kaizalɨ aka.» ");
INSERT INTO lik_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Ngama Fɛsɨtɔ a ndɨ kapa kaʉbaɨlya Ɓayuda, ɨyɨ aka ndɨ na Pɔlɔ ɓɛ: «Watʉ kapa kaɨga ka Yelusalɛma kyɛ ɓakuku ngbanga kʉ ɓɛyɔ?» ");
INSERT INTO lik_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pɔlɔ asikisya ndɨ ɓɛ: «Ɨmɨ na wanʉ ka basa ka Kaizalɨ nɨyɔ ɓʉkɔgɔ mino ɓangbanga. Ɓakwanana kesombiso wanʉ. Nakugyilyigʉ Ɓayuda ɓʉnyɛ gʉtʉgʉ ɓumoti aka mʉɗɔngɔnɨ ɓɛyɔ ɨwɛ mombukwana-dakɨ wa mino kaiba ɓɨnza. ");
INSERT INTO lik_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Kika nɨ nogyi ɓi ɓʉnyɛ ikanɨ lɨkpʉmʉka nɨlɔ akwanana kemwisiso, ɨmɨ, nakoyagʉ. Luki limoti, kika nɨ ɓakɛbɨnɨkɨlyaga makpʉmʉka, mʉmbanzʉ gʉtʉgʉ ɓemoti aka kokwononigʉ kɛsʉta kʉ kaɓʉ. Nakapa ambɛ nasambɨ kambwa ka ngama Kaizalɨ aka!» ");
INSERT INTO lik_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Kʉwa wa, ngama Fɛsɨtɔ anzɨna ndɨ na ɓatʉ kakɨ nɨɓɔ ɓapága mʉtɨwɨ, asikisya Pɔlɔ ɓɛ: «Yɛkɨ wotiwolyi ɓɛ wokosomboku kambwa ka ngama Kaizalɨ aka, waga kʉwa kʉ kwa kʉ.» ");
INSERT INTO lik_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Kumbusa wa masyɛ makɛɗɛ, ngama Agilipa ɨɓʉ na mamakɨ mukoyi ɓɛyɔ ka Belenike ɓosila ndɨ ka Kaizalɨa, ɓamuusoku ngama Fɛsɨtɔ. ");
INSERT INTO lik_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Yɛkɨ ɓa ndɨ kagya kʉ ɓɛyɔ masyɛ mudingi, Fɛsɨtɔ atʉmbʉlyaga kʉwa ndɨ ngama Agilipa lɨkpʉmʉka ka Pɔlɔ. Ɨyɨ aka ndɨ na ɨyɨ ɓɛ: «Alʉkʉ ɓemoti a wanʉ nɨnɔ Felisi asa ndɨ ka bɔlɔkɔ. ");
INSERT INTO lik_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Ngbingo yi nɨnɔ naga ndɨ mino ka Yelusalɛma, ɓokumu-kumu na ɓazɛɛ ka Ɓayuda ɓasʉngʉlya ndɨ, ɓɛɓɨkya ɓɛ nakʉ lɨkpʉmʉka kakɨ kyɛ ɓamwɨ. ");
INSERT INTO lik_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Nusikisya ndɨ ɓɛ: ‹Ɓalʉma ɓakasʉtagɨgʉ mʉmbanzʉ nɨ ɓakanosombigʉ na ɓatʉ nɨɓɔ ɓasungulyi, mʉtʉ yi ɨtʉmbʉlyaga gɔnɨ nɨlɔ ɓiko kanɨ ɓasungulyini mino.› ");
INSERT INTO lik_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Tosiloku ndɨ pa imoti na ɨɓʉ wanʉ. Kolipyagʉ, ɓʉgala ɓi aka nika ndɨ ka basa yɨkɔ ɓangbanga, nakpamya ndɨ ɓɛ ɓoduku na alʉkʉ yi nɨmʉ. ");
INSERT INTO lik_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Ɓatʉ ɓi nɨɓɔ ɓasʉngʉlya ndɨ, ɓodoku ndɨ gɔnɨ. Luki limoti, ɓakaɓɨkyɨlyagʉ ndɨ makpʉmʉka ɓanyɛnyɛ ɓɛyɔ na ndɨ mino na mʉtamanagɨ. ");
INSERT INTO lik_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Ɓa ndɨ kagya na ɨɓʉ ɓoɗongoso ko bulya kanisa kaɓʉ aka ɓɨkpɛ na ko bulya ka alʉkʉ ɓemoti nɨnɔ ina ndɨ ɓɛ Yeso, ɓaɓɨkyaga ɓɛ okwoni ndɨ, luki limoti Pɔlɔ aɓɨkyaga ɨyɨ ɓɛ a muɓisi. ");
INSERT INTO lik_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Ɨmɨ, nakɛgʉ ndɨ kaiba ɓɛ nakwanana kakɔ inguo ya lɨkpʉmʉka li nɨlɔ ɓʉnɨ. Kʉwa wa, namuusa ndɨ Pɔlɔ ikanɨ akwananatʉ kaɗaka ka Yelusalɛma kyɛ ɓakuku ngbanga kakɨ ko bulya lɨkpʉmʉka li nɨlɔ. ");
INSERT INTO lik_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Luki limoti, Pɔlɔ a ndɨ kapa ɓɛ asambɨ kambwa ka ngama mudingi wa Lʉma aka. Nakpamya kʉwa ndɨ ɓɛ iki ka bɔlɔkɔ aka kadwɛ kʉ kwa kʉ natɨka ndɛkɛ mino kʉ ɓɛyɔ.» ");
INSERT INTO lik_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Ngama Agilipa aɓɨkya ndɨ Fɛsɨtɔ ɓɛ: «Ɨmɨ gɔnɨ, no ɓi kapa kamʉkana alʉkʉ yi nɨmʉ.» Fɛsɨtɔ aka ndɨ na ɨyɨ ɓɛ: «Wamʉkana kʉwa na ɓʉgala.» ");
INSERT INTO lik_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Ɓʉgala ɓi, Agilipa ɨɓʉ na Belenike ɓosiloku ndɨ na ɨbɨba, ɓambanzʉ kumbuso kaɓʉ ɓingbooo, ɓingyo ka basa yɨkɔ ɓangbanga pa imoti na ɓangama ka ɓasʉda na ɓangama ɓa mʉsɛngɨ. Kʉwa wa, Fɛsɨtɔ akpamya ndɨ ɓɛ ɓoduku na Pɔlɔ. ");
INSERT INTO lik_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Fɛsɨtɔ aɓɨkya ndɨ ɓɛ: «Ngama Agilipa, na iɓunu ɓasɨ nɨɓɔ ma mbɨya wanʉ pa imoti na iɓusu, muminoni alʉkʉ yi nɨmʉ. Ɓayuda ɓasɨ ɓoduku ɓi kasʉngʉlya kʉ kamɨ ka Yelusalɛma mʉɗɔngɔnɨ ɓɛgɛyɔ ɓoduku mino wanʉ, ɓanapamɨkanaga ɓɛ okwononi okwi. ");
INSERT INTO lik_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ɨmɨ, nini ɓi ɓɛ kogyigʉ luki nɨlɔ ɓakwanana mino kamwɔ. Luki limoti, ɨyɨ mʉkaka aka nɔ a ndɨ kapa kasamba kambwa ka ngama mudingi wa Lʉma, nɨna ndɨ ɨmɨ ɓɨnza gɔnɨ katɨka kʉ ɓɛyɔ. ");
INSERT INTO lik_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Nakinigʉ ɓi lɨkpʉmʉka la lɨngʉnʉ nɨlɔ nakwanano ɓi kokpika ko bulya kakɨ kapá ngama mudingi wa Lʉma. Kinili, noduku na ɨyɨ kambwa kunu, ɓɨkpɛ kambwa kakʉ ka ngama Agilipa. Ɓakamuusogo, nakwanana kʉwa kokpiko luki. ");
INSERT INTO lik_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","A ɓɛyɔ, nakaɨna ɓɛ kɛgʉ ngbingbili katɨka mʉtʉ wa bɔlɔkɔ ka Lʉma nɨ takanibigʉ ɓɛ ɓasungulyi ɓi ko bulya ɨkɨ.» ");
INSERT INTO lik_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Kʉwa wa, Ngama Agilipa aka ndɨ na Pɔlɔ ɓɛ: «Wakwanana kʉwa kasamba.» Pɔlɔ anana ndɨ kʉɓɔkʉkɔ, ɨyɨ aka ɓɛ: ");
INSERT INTO lik_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","«Ngama, na lɨsyɛ li nɨlɨ, na na ɨgyagya yidingi kasamba kambwa kakʉ ka makpʉmʉka masɨ nɨmɔ Ɓayuda ɓesungulyi ɓi mino. ");
INSERT INTO lik_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","A ɓɛyɔ, wibagatʉ ɓɨnza yɨgya yasɨ ka Ɓayuda na ɓoɗongoso kaɓʉ. Kikiliki, ɨmʉkanatʉ na lɨmbɛngɨ lɨnda. ");
INSERT INTO lik_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Ɓayuda ɓasɨ ɓamibatʉ ɔɓɨlɨ kamɨ katʉkya ka limiki. Ɓibagatʉ gɔnɨ ɓɛyɔ ɔɓɨlɨ kamɨ a ndɨ mino luga wa lɨvananza kamɨ na ka Yelusalɛma. ");
INSERT INTO lik_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Ɓemibagatʉ katʉkya ka ɓʉndɛlɨ, ɓakapa, ɓakwanana kepupilyo ɓʉdɛmʉ ɓɛ na ndɨ ka liɗu ka Ɓafalisayɔ. Luga wa moɗu ma kanisa kusu, liɗu li nɨlɔ ikaga na mʉtʉʉ mapʉ kʉgbɛ. ");
INSERT INTO lik_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Na ko ngbongu mbɨya wanʉ kyɛ mʉtamanagɨ kamɨ asyɛ ka agʉmɛ nɨnɔ Kunzi ʉgyɨlya ndɨ ɓotitosu. ");
INSERT INTO lik_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Biti na lɨsyɛ, mababa kusu tɛkɛɓɛ na ɓaɓa ɓakabibiso Kunzi na ɓa na mʉtamanagɨ kaɨna ɓɛyɔ agʉmɛ yi nɨnɔ ɨtʉlyana ndɛkɛ mino. Ngama, Ɓayuda ɓɛsʉngʉlya ko bulya mʉtamanagɨ mi nɨmɔ aka mɔ. ");
INSERT INTO lik_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Ko bulya ɨkɨ yɔ iɓunu makɛgʉ mino na baya ɓɛ Kunzi ozuzukisagatʉ ɓamanda? ");
INSERT INTO lik_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Ɨmɨ mombukwana-dakɨ, na ndɨ kasɨma ɓɛ nʉlananatʉ na ɓatʉ nɨɓɔ ɓatwaga ndɨ lino ka Yeso mʉtʉ wa Nazalɛtɨ ka ɓopisi ɓayasɨ. ");
INSERT INTO lik_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Nagya ndɨ ɓɛyɔ ka Yelusalɛma. Ɓokumu-kumu ɓɔ ɓɛtwa ndɨ, nugwisisaga ndɨ ɓakilisito ɓudingi ka ɓabɔlɔkɔ dididi, nɨyɔ ɓakɔgɔ lɨkpʉmʉka kaɓʉ ɓɛ ɓʉmwɨ, ɨmɨ noɓingisyagatʉ ndɨ gɔnɨ. ");
INSERT INTO lik_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Ɓongbingo ɓasɨ, nakɨtanagatʉ ndɨ ka ɓandaɓʉ ɓaya malʉmba ka ɓayuda ɓayasɨ, nanugyogyiso ɓakilisito kyɛ ɓatʉmbwɨ lino ka Yeso-Kilisito. Nikaga ndɨ na lɨngangɨ na ɨɓʉ, kinili nɨndaga ndɨ kaugyogyiso ka ɓagʉɗʉ ɓogiyo ɓayagɔgɔ.» ");
INSERT INTO lik_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","«A ɓɛyɔ, ɓokumu-kumu ɓɔ ɓɛtwa ndɨ, ɓɛtɨka ka Damasɨkɨ. ");
INSERT INTO lik_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Ngama, ngbingo yi nɨnɔ na ndɨ mino ko pisi, na mʉsɨkatʉ, nɨna kotukyoku kʉgʉ wa lɨsyɛ, ɓʉngbanganya ɓiwenge-wenge kakɨtaga ɓyɨ ɓʉngbanganya ɓa mɔnɨ. Ɓʉngbanganya ɓi nɨmɔ ekungula ndɨ ɓikululu pa imoti na ɓatʉ nɨɓɔ ta ndɨ na ɨɓʉ. ");
INSERT INTO lik_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Iɓusu ɓasɨ togwa ndɨ wasɨ. Nʉkana ndɨ lɨyʉ limoti ɛnɛɓɨkya na Libelenia ɓɛ: ‹Saulo, Saulo, ko bulya ɨkɨ yɔ wo mino kegyogyiso? Wakagya mʉ mapʉ ma payaya mʉɗɔngɔnɨ abɛ nyama yi nɨnɔ mombukwana-dakɨ akwanana katɨnaga.› ");
INSERT INTO lik_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Nuusa kʉwa ndɨ ɓɛ: ‹Ɨwɛ nɨ wanɨ, Mombukwono-dosu?› Mombukwono-dosu esikisya ndɨ ɓɛ: ‹Ɨmɨ nɨ Yeso, nɨnɔ wakagyogyiso. ");
INSERT INTO lik_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Luki limoti, tʉkya, wamaga. Nupuponilyi kyɛ nuitisi mʉgya-ligubo kamɨ. Wika kaʉɓɨkyaga ɓambanzʉ ɓɛyɔ wemini mino na nɨlɔ nuwonisila ndɛkɛ ɓata kumbuso. ");
INSERT INTO lik_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Nuɓuulyaga ndɛkɛ ka maɓɔkʉ Ɓayuda na ka ɓɛvananza ɓayagɔgɔ, kʉ no mino kaʉtɨka. ");
INSERT INTO lik_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Nakaʉtɨka kyɛ ʉkʉlɨ miso, upupisoku ko biti kyɛ ɓɨnɨ ɓʉngbanganya. Kopupo ko ngu ka Abɨlɨ na kamigilyoku Kunzi. Ɓakɛɓɨnɨkyana kʉwa, ɓinisanatʉ na mʉpɨlya ma ɓʉnyɛ kaɓʉ, ɓiko na lɨdɔdɔ luga ka ɓatʉ ko Kunzi.›» ");
INSERT INTO lik_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","«Ngama Agilipa, nakakwananɨgʉ ndɨ kakya kagya nɨlɔ nɨna ndɨ ko nziki kotukyoku kʉgʉ wa lɨsyɛ. ");
INSERT INTO lik_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Luki limoti, nʉɓɨkyaga mbɛyɨ ndɨ ɓatʉ ɓa Damasɨkɨ, na nɨɓɔ ɓa Yelusalɛma sɛ kʉwa ka iwili yasɨ ya Yudɛa na ɓatʉ ɓagɔgɔ ɓasɨ nɨɓɔ ɓakɛgʉ ndɨ Ɓayuda. Nʉɓɨkyaga ndɨ ɓɛ ɓayikosi ɔɓɨlɨ, ɓamigilyoku Kunzi, ɓowonisilo pisi ka yɨgya ɓɛ ɓayikosoni ɔɓɨlɨ. ");
INSERT INTO lik_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Ɓayuda ɓɛgwi ndɨ ka Ndaɓʉ ko Kunzi ko bulya lɨkpʉmʉka li nɨlɔ, ɓakɨsa ndɨ kɛmwɔ. ");
INSERT INTO lik_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Luki limoti, Kunzi eɓuulyagatʉ kadwɛ na lɨsyɛ li nɨlɨ. Na dɛmʉ kakɨ kambwa ka ɓambanzʉ ɓasɨ, iki ɓomiki ɨkanɨ ɓambɔkʉ. Nakɛgʉ kaɓɨkyaga luki lagɔgɔ di na nɨlɔ ɓogyalandʉ na Musa ɓaɓɨkya ndɨ ɓɛ igyonosatʉ ndɛkɛ. ");
INSERT INTO lik_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Ɨɓʉ ɓaɓɨkya ndɨ ɓɛ Kilisito igyogyisatʉ, iko mʉtʉ wa mambwa kopupo ka mbʉkʉ luga ka nɨɓɔ ɓokwaga ndɨ. Ʉɓɨkyaga ndɛkɛ ɓatʉ ɓa lɨvananza kusu mongoni ma muhukuso na gʉtʉgʉ ɓatʉ nɨɓɔ ɓakɛgʉ Ɓayuda aka.» ");
INSERT INTO lik_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Ngbingo yi nɨnɔ Pɔlɔ a ndɨ mino kozukogo lɨkpʉmʉka kakɨ, ambɔkʉ Fɛsɨtɔ apamɨkana ɓɛ: «Pɔlɔ, wa ibikyasʉ! Balʉwa nɨnɔ waɓyɛ ndɨ wakpʉ nɔ uputoni!» ");
INSERT INTO lik_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Pɔlɔ asikisya ndɨ ɓɛ: «Ngama, nakɛgʉ na ibikyasʉ, mʉnzɨna kamɨ a ma lɨngʉnʉ na mo ɓungbingbili. ");
INSERT INTO lik_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Ngama Agilipa nɨmʉ akaiba ɓɨnza lɨkpʉmʉka li nɨlɔ. Kinili, nakanzɨna kambwa kakɨ nɨ nakɛgʉ na kʉɓangakʉ. Na na lɨmbɛngɨ ɓɨɗɛ ɓɛ akaiba makpʉmʉka mi nɨmɔ masɨ kyɛ kɛgʉ na nɨlɔ igyonosa ndɨ ko dikiɗi. ");
INSERT INTO lik_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Ngama Agilipa, watʉ na baya ka lɨkpʉmʉka li nɨlɔ ɓogyalandʉ ɓaɓɨkya ndɨ? Nakaiba ambɛ wa na baya ka lɨkpʉmʉka li nɨlɔ!» ");
INSERT INTO lik_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Ngama asikisya ndɨ Pɔlɔ ɓɛ: «Wakasɨma ɓɛ wakwananatʉ keitiso Mukilisito ko ngbinga mʉkɛɗɛ ɓɛyɔ?» ");
INSERT INTO lik_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pɔlɔ asikisya ɓɛ: «Iki gʉtʉgʉ mbɨya wanʉ ikanɨ kumbuso ndɛkɛ, nakakʉnga Kunzi ambɛ kikonitɔgʉ asɨ ɨwɛ aka, gʉtʉgʉ ɓatʉ ɓasɨ nɨɓɔ ɓakɛmʉkana na lɨsyɛ li nɨlɨ ɓɨɨtɨ mʉɗɔngɔnɨ abɛ ɨmɨ, kanɨ ɓakɛgʉ ɓata na ɓaselegeni ɓi nɨɓa!» ");
INSERT INTO lik_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Kʉwa wa, ngama mudingi, ngama wa iwili, Belenike na ɓatʉ ɓagɔgɔ ɓudingi nɨɓɔ ɓa ndɨ pa imoti na ɨɓʉ ɓamaga ndɨ, ");
INSERT INTO lik_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","ɓa ndɨ komisikono nɨ ɓananzɨna luga kaɓʉ ɓɛ: «Alʉkʉ yi nɨmʉ kogyigʉ ɓʉnyɛ gʉtʉgʉ ɓumoti aka nɨɓɔ okwononi mino ɓɛ ɓamwɨ ɨkanɨ kagwi.» ");
INSERT INTO lik_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agilipa aɓɨkya ndɨ Fɛsɨtɔ ɓɛ: «Ɓakwanano ɓi kasiso alʉkʉ yi nɨmʉ kiki ɓi ɓɛ oɓikyi ɓi ɓɛ asamba kambwa ka ngama mudingi wa Lʉma aka.» ");
INSERT INTO lik_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Nɨyɔ ɓʉkanana katimogoso ka Italia pisi ka bato, ɓʉpá kʉwa ndɨ Pɔlɔ na ɓatʉ ɓemoti-ɓemoti ɓa bɔlɔkɔ ɓagɔgɔ ka maɓɔkʉ ka Yulio nɨnɔ a ndɨ ngama wa liɗu ka ɓasʉda mɨya. Ɨyɨ Yulio a ndɨ ka liɗu ka ɓasʉda nɨlɔ ɓalɨkyaga ndɨ ɓɛ «Ɓasʉda ka Kaizalɨ». ");
INSERT INTO lik_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Taɗaka ndɨ ka bato ɓemoti wa gʉɗʉ wa Adalamiti, nɨnɔ a ndɨ kaifumoku ka masʉ ma iwili ya Azia. Taga kʉwa ndɨ. Ta ndɨ kʉ ɓɛyɔ na Mumakedonia ɓemoti nɨnɔ ina ndɨ ɓɛ Alisitaliko mʉtʉ wa Tesalonika. ");
INSERT INTO lik_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Ɓʉgala ɓi, tɨfʉma ndɨ ka Sidɔna. Yulio a ndɨ kagya Pɔlɔ ɓɨnza. Asɨlya kʉwa ndɨ pisi kaɨnda kaɨnanana na ɓawai-dakɨ ɓɛ ɓapágɨ makpʉmʉka nɨmɔ akwanana ndɨ kaiko na mʉsasa mi. ");
INSERT INTO lik_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Katʉkya wa, taɗakaga ndɨ, taɓyɛ mutili aka ko uzu nɨnɔ ɓamakaga ɓɛ Kipulo kyɛ ovivi a ndɨ wapʉ kambwa kusu. ");
INSERT INTO lik_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Tazaba ndɨ liɓo lidingi ɓuwobi na iwili ya Kilikia na nɨyɔ ya Pamufilia, tadwɛ ka lɨsʉ ka gʉɗʉ wa Mila ka iwili ya Likia. ");
INSERT INTO lik_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Kʉ ɓɛyɔ, ngama ka ɓasʉda yi nɨnɔ atakanya ndɨ bato ɓemoti wa gʉɗʉ wa Alesandulia nɨ anaga ka Italia. Atiɗokisa ndɨ mino. ");
INSERT INTO lik_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Kʉsɔ wa masyɛ mudingi, takpakyana ndɨ ɓɨwɛsɛ, tadwɛ ndɨ ɓuwobi na gʉɗʉ wa Kinido ka ɓʉkpɛkɨ-kpɛkɨ ɓudingi. Luki limoti, avivi kɛgʉ ndɨ kapa ɓɛ taga miso ya kʉ ɓɛyɔ, kinili ta kʉwa ndɨ kopupono ka Kɨlɛtɛ pisi ka kpɔlɔ-kpɔlɔ wa lɨtalʉ lidingi nɨlɔ ɓalɨkyaga ɓɛ Salimoni kyɛ avɨvɨ kɛgʉ ndɨ wapʉ kʉgbɛ kʉ ɓɛyɔ. ");
INSERT INTO lik_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Tidukulaga ndɨ kakpakyana aka ka ɓʉkpɛkɨ-kpɛkɨ ɓudingi, tɨfʉma ndɨ ka pa yi nɨyɔ ɓalɨkyaga ɓɛ «Masʉ manza», ɓuwobi na gʉɗʉ wa Lasea. ");
INSERT INTO lik_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Yɛkɨ masyɛ atɨkɨtanɨlyaga ndɨ mudingi, tosila kʉwa ndɨ ko ngbingo wa ɓʉkpɛkɨ-kpɛkɨ kʉgbɛ kakpakyana kʉgʉ wo liɓo kyɛ ngbingo muginyo malɨlɨ a kʉwa ndɨ nɨ okitogini gɔnɨ. Pɔlɔ utukusya kʉwa ndɨ motili ɓɛ: ");
INSERT INTO lik_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","«Ɓomika-mama, nakaɨna abɛ takatʉkyɨlya lɨgʉndʉ, ikatʉ na ɓʉkpɛkɨ-kpɛkɨ, iki makpʉmʉka ikanɨ bato apʉtɨkanatʉ, iɓusu tahʉkaga kukwakʉ ɓaka ɓɨkwɛ.» ");
INSERT INTO lik_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Luki limoti, ngama ka ɓasʉda a ndɨ wakɨgʉmya kʉgbɛ ka mʉnzɨna ka sʉfɛlɛ wa bato na mombukwana bato kakɨtaga nɨmɔ ka Pɔlɔ. ");
INSERT INTO lik_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","A ndɨ ngbingo wa ɓʉdɨ ɓapʉ, na lɨsʉ li nɨlɔ kikogigʉ lanza ko ngbingo yi nɨnɔ. Ɓudingi ɓa ɓambanzʉ nɨɓɔ ɓa ndɨ ka bato ɓa ndɨ ɓakɨtʉlya katʉkya na kaaga ka Foinikia kaiko kʉ kadwɛ kʉ kwa kʉ ngbingo yi nɨnɔ akɨtaga mino. Foinikia a lɨsʉ la Kɨlɛtɛ nɨlɔ a iikono miso kʉ mɔnɨ ogwaga mino. ");
INSERT INTO lik_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Kʉwa wa, ovivi apʉnga ndɨ kovivo nɨ kɛgʉ wapʉ kotukyoku ka Zebu, ɓatʉ nɨɓɔ ɓa ndɨ ka bato ɓa ndɨ kasɨma ɓɛ ɓagyatʉ mʉɗɔngɔnɨ ɓɛyɔ ɓa ndɨ mino nɨ ɓosisilini. Ɓapwa bato, ɓakpatɨla ndɨ ɓuwobi na mutili mo uzu wa Kɨlɛtɛ. ");
INSERT INTO lik_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Kolipyagʉ, kotukyoku ko uzu, ovivi wapʉ nɨnɔ ɓamakaga ɓɛ «ovivi wa zɨɓɔ-ɨngɛngɛ» apʉnga ndɨ kovivo wapʉ kʉgbɛ. ");
INSERT INTO lik_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Ovivi yi nɨnɔ atundula ndɨ bato nɨ kɛgʉ wa ɨtɨlyanago mino. Takɨka kʉwa ndɨ. ");
INSERT INTO lik_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Takɨka ndɨ miso ya kʉsɨlɨ ko mikyo uzu nɨnɔ ɓamakaga ɓɛ Kauda. Tagya ndɨ ngu yasɨ koluto ɨngbɔlɔ nɨyɔ ɓuɗusogo na iyu ɓambanzʉ. ");
INSERT INTO lik_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Ɓagya-ligubo ɓa bato ɓoɗokisa ndɨ ɨngbɔlɔ yi nɨyɔ ka bato, ɓalingisyogo bato no ligi ya kiɗuso. Ɓa ndɨ kaɓanga ɓɛ ɓakitilyonogonitɔ ko mbumi ya mutili ma Libia. Ɓosisa kʉwa ndɨ lɨɓaʉ liti nɨlɔ ikaga ndɨ lɨkpɨkɨla ka bato ko liɓo kyɛ bato iki kakɨka ɓɨwɛsɛɛɛ. ");
INSERT INTO lik_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Ɓʉgala ɓi, mbumbo idukulaga ndɨ katiyongo aka no ngu. Ɓagya-ligubo ɓa bato ɓapʉnga ndɨ kombimbo mukumbo ko liɓo kyɛ bato opolimoni. ");
INSERT INTO lik_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Ɓʉgala ɓagɔgɔ, ɓapʉnga ndɨ kombimbo nɨ ɨɓʉ ɓamombukwana-daɓʉ ɓi makpʉmʉka ma bato ko liɓo. ");
INSERT INTO lik_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Kʉsɔ wa masyɛ mudingi, iki mɔnɨ ikanɨ mangʉtʉ kinisonogigʉ ndɨ. Mbumbo kɛgʉ ndɨ kaɨgaga mayʉ, takɛgʉ ndɨ ɓata na mʉtamanagɨ ɓɛ tahʉkatʉ. ");
INSERT INTO lik_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Ɓatʉ nɨɓɔ ɓa ndɨ ka bato ɓa ndɨ nɨ ɓogyini masyɛ mudingi na ɓanza. Pɔlɔ amaga ndɨ luga kaɓʉ, ʉɓɨkya ɓɛ: «Ɓawai, makɛmʉkano ɓi iba makotukyigʉ ɓi ka Kɨlɛtɛ, takabanganɨgʉ ɓi no mbumbo, makpʉmʉka kapʉtɨkanɨgʉ ɓi gɔnɨ ɓɛnɛ. ");
INSERT INTO lik_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Luki limoti, mbɨya wanʉ makikonitɔgʉ na kʉɓangakʉ kyɛ mʉtʉ gʉtʉgʉ ɓemoti luga kunu kokwigʉ, luki limoti, bato aka nɔ akapʉtɨkana. ");
INSERT INTO lik_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","A ɓɛyɔ, no biti yi nɨyɨ, malaika ko Kunzi nɨnɔ nɨgʉmya kʉ kakɨ na nɨnɔ nabibisogo epuponilyito, ");
INSERT INTO lik_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ɛɓɨkyo ɓi ɓɛ: ‹Pɔlɔ, wakoɓongonitɔgʉ, okwononi ɨwɛ kasamba kambwa ka Kaizalɨ. Ko bulyo mazɨyɔ kakɨ kʉgʉ kakʉ, Kunzi uhukusogi ɓatʉ ɓasɨ nɨɓɔ ma ɨɓʉ ka lɨgʉndʉ.› ");
INSERT INTO lik_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Ɓawai, makoɓongonitɔgʉ nɛkɨ kyɛ, na wakɨgʉmya ko Kunzi, masɨ igyonoso ɓaka yɔ eɓikyi ɓi mino. ");
INSERT INTO lik_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Titilyonogokuto ka mutili mo uzu yimoti ɓɛnɛ.» ");
INSERT INTO lik_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Totulyosa ndɨ ɓapɔsɔ ɓaɓa nɨ mbumbo anatiyungo aka gbalɨ kʉgʉ wo liɓo lidingi la Meditelane. Lugo wo biti, ɓagya-ligubo ɓa bato ɓa ndɨ kasɨma ɓɛ ta kʉwa ɓuwobi kadwɛ kubi. ");
INSERT INTO lik_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Ɓakandɨla ndɨ lɨtalʉ na muligi, ɓaɗɨkɨta ko liɓo, ɓɨna ndɨ ɓɛ ɓudu ɓi a mɛtɛlɛ ɓatɛkɛɓɛ ɓasaa na maɗɨya na ɨka. Nɨyɔ ɓisisilo, ɓaɗɨkɨta ɓata, ɓɨna kʉwa ɓɛ a ɓatɛkɛɓɛ ɓaɓa na ɓʉgɨna. ");
INSERT INTO lik_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Ɓa ndɨ kaɓanga ɓɛ bato kokpokpogonitɔgʉ ɓaka ka matamʉ. Kinili, ɓosisaga ndɨ ligi yɨkwanganya nɨyɔ a ndɨ yɨkpɨkɨlaga na ɓangwɛyɨ ɓayitititi miso ya liɓo li ɓɛkyɛ bato amagɨ, ɓaɓʉndɨla ndɨ na lɨmbɛngɨ lɨnda ɓɛ lɨsyɛ asyɨ. ");
INSERT INTO lik_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Luki limoti, ɓagya-ligubo ɓa bato ɓa ndɨ kakɨsa kapɨkɨta. Ɓosisa kʉwa ndɨ mikya-ɨngbɔlɔ nɨnɔ ɓiɗusaga na ɨyɨ ko ngbingo wa ɓʉkpɛkɨ-kpɛkɨ, ɓaɓɔ ɓɛ ɓakosisogo ligi miso ya mʉ ma bato. ");
INSERT INTO lik_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Luki limoti, Pɔlɔ aɓɨkya ndɨ kʉmanda na ɓasʉda ɓɛ: «Ɓatʉ ɓi nɨɓa ɓakiki ka bato aka, makakwananɨgʉ ɓi kahʉkaga.» ");
INSERT INTO lik_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Kʉwa wa, ɓasʉda ɓakɔgɔ ndɨ ligi yo mikya-ɨngbɔlɔ yi nɨnɔ, akɨka ndɨ. ");
INSERT INTO lik_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Kambwa lɨsyɛ katɨnɨkaga, Pɔlɔ ʉɓɨkya ndɨ ɓatʉ ɓasɨ ɓɛ ɓalyalyɨ. Ʉɓɨkya ɓɛ: «Na lɨsyɛ li nɨlɨ, odwini kʉwa masyɛ tɛkɛɓɛ na makwanganya nɨmɔ mo mino ka mʉɓʉndɨlagɨ nɨ makɛgʉ kalya luki. ");
INSERT INTO lik_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Nakamʉɓɨkya ambɛ lyoni nɛkɨ mino mikyo luki, kyɛ miki ɓapʉpʉ aka. A ɓɛyɔ, lɨkpʉmʉka kagyɨgʉ mʉtʉ gʉtʉgʉ ɓemoti aka luga kunu.» ");
INSERT INTO lik_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Kumbusa wa mʉnzɨna mi nɨmɔ ɓɛyɔ, Pɔlɔ ava ndɨ mukati, abibiso Kunzi kambwa ka ɓambanzʉ ɓasɨ, oɓunonogo, apʉnga kalya. ");
INSERT INTO lik_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Nzʉyɨ upolimana ndɨ ɨɓʉ ɓasɨ, ɓalya kʉwa ndɨ gɔnɨ ɨɓʉ. ");
INSERT INTO lik_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Kʉsɔ wa bato, ta ndɨ ɓasɨ ɓambanzʉ mɨya yɨɓa ɓatɛkɛɓɛ maɗɨya na ɨka na maɗɨya (276). ");
INSERT INTO lik_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Nɨyɔ ɓikutogo, ɓambimba ndɨ nganʉ ko liɓo ɓɛkyɛ bato opolimoni. ");
INSERT INTO lik_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Nɨyɔ lɨsyɛ asyɛ, ɓagya-ligubo ɓa bato ɓakibagʉ ndɨ ɓata pa. Luki limoti, ɓɨna kʉwa ndɨ ɓyɨ pa yo mbumi yimoti ɓɛnɛ, ɓʉkanana ndɨ ɓɛ bato akwanana kaɨnda kaɨfʉma kʉ ɓɛyɔ. ");
INSERT INTO lik_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Ɓakʉlaga ndɨ ligi nɨyɔ ɓamʉ ɓi a ndɨ ɓayɨkpɨkɨlaga na ɓangwɛyɨ, ɓasa ndɨ kolindo ko liɓo. Ko ngbingo yi nɨnɔ gɔnɨ nɔ, ɓakʉla ndɨ ligi ya ambʉ nɨnɔ ananaga bato ka mʉ mo liɓo. Kumbuso yi, ɓobongisa ndɨ kutuko ka mʉ ma bato, muvivi utundulo, ɓaga miso kʉ mbumi a ndɨ mino. ");
INSERT INTO lik_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Luki limoti, ɓadwɛ ndɨ ka liɗuku lo mbumi yi nɨyɔ, luga wa ɓodungo ɓayɨɓa, bato akpakpaga ndɨ wa aka wa. Mʉ mi olinda ndɨ ɓɨɓɛ ko mbumi nɨ kɛgʉ ɓata koɗwo, lɨbɔ li lasɨ a ndɨ kapanzɨkana na mʉɓaka mapʉ nɨmɔ a ndɨ kaigyonoso. ");
INSERT INTO lik_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Kʉwa wa, ɓasʉda ɓa ndɨ kapa kaulumwisogo ɓatʉ ɓa bɔlɔkɔ, ɓɛkyɛ gʉtʉgʉ ɓemoti aka kokyogonitɔgʉ pisi kogwo liɓo. ");
INSERT INTO lik_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Luki limoti, kʉmanda wa Lʉma a ndɨ na mʉsasa kahukusogo Pɔlɔ, ʉpakya ndɨ kagya ɓɛyɔ. Ʉkpamya ɓatʉ nɨɓɔ ɓibaga ndɨ kogwo liɓo ɓɛ ɓapʉngɨ nɨ ɨɓʉ kogwo, ɓopupana kubi. ");
INSERT INTO lik_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Ɓatʉ ɓagɔgɔ ɓakwanana kaʉɓyɛ gɔnɨ nɨ ɓigwinonogini ka ɓodongbu ɓaya maɓaʉ, ikanɨ ka nɨɓayɔ apanzɨkana ndɨ ka bato. Kinili, ɓatʉ ɓasɨ ɓosila ndɨ kubi ɓɨnza aka. ");
INSERT INTO lik_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Nɨyɔ tahʉkaga ɓɛyɔ, ɓatɨɓɨkya ndɨ ɓɛ lino lo uzu nɨyɔ ta ndɨ mino nɨ Melita. ");
INSERT INTO lik_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Ɓatʉ ɓa mugi mi ɓatɨgya ndɨ ɓɨnza kʉgbɛ, ɓatɨtɨlya ndɨ. Yɛkɨ mbwayɨ a ndɨ kalʉka na ɓʉdɨ gɔnɨ, ɓatɨgbʉndɨlya ɓuku ɓɛ tʉtɨ iɓusu ɓasɨ. ");
INSERT INTO lik_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pɔlɔ atʉpa ndɨ ɓɛnzyaga koɗikitoku ko ɓuku. Mbʉma opupa ndɨ kʉsɔ yi ko bulya ɓʉzʉ, ayangata ndɨ ka kʉɓɔkʉkɔ. ");
INSERT INTO lik_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Nɨyɔ ɓatʉ ɓa mugi ɓamɨna mbʉma kanɨ ayongotini ka kʉɓɔkʉkɔ ɓɛyɔ, ɓapʉnga ndɨ kaɨnzɨnzɨnya ɓɛ: «Alʉkʉ yi nɨmʉ a asɨ mʉgya-manyɛ aka. Oukogi mbɛyɨ ɓɨkwɛ ko liɓo, luki limoti, ɓungbingbili ko Kunzi akapa ɓaka ɓɛ okwi.» ");
INSERT INTO lik_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Luki limoti, Pɔlɔ ɨkpazya ndɨ nzʉka yi nɨnɔ ko ɓuku nɨ kimukonigʉ gʉtʉgʉ luki limoti aka. ");
INSERT INTO lik_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Ɓa ndɨ kasɨma ɓɛ kʉɓɔkʉkɔ afulatʉ Pɔlɔ ikanɨ okwo ɓigbututu. Nɨyɔ ɓaɓʉndɨla ɓɨndɨ nɨ luki kagyigʉ, ɓoyikasa tamanaga kaɓʉ, ɓapʉnga ndɨ kaɓɨkya ɓɛ a kunzi. ");
INSERT INTO lik_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Ngama wo uzu yi nɨnɔ ina ndɨ ɓɛ Pubiliyɔ, a ndɨ no tiko ɓuwobi na pa yi nɨyɔ. Ɨyɨ Pubiliyɔ atɨtɨlya ndɨ ɓɨnza, tasyɛ masyɛ masaa kʉ kakɨ. ");
INSERT INTO lik_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Abakɨ Pubiliyɔ a ndɨ wakanga, anɨmʉkana ɓʉdɨ, anapʉwa gɔnɨ ɓangʉ. Pɔlɔ ingya ndɨ kʉ a ndɨ mino, alʉmbɨlya, abisilya maɓɔkʉ, ahʉka ndɨ. ");
INSERT INTO lik_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Kumbuso yi, ɓatʉ ɓagɔgɔ nɨɓɔ ɓa ndɨ kayɨmʉkana ko uzu yi nɨnɔ ɓodoku ndɨ gɔnɨ, ɓahʉka ndɨ. ");
INSERT INTO lik_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Ɓambanzʉ ɓapága ndɨ ɨbɨba kʉgbɛ. Nɨyɔ ta kʉwa ndɨ katʉkya, ɓatɨpápa ndɨ. ");
INSERT INTO lik_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Kumbusa wa ɓatɨmba ɓasaa, tatʉkyɨlya ndɨ lɨgʉndʉ ka bato nɨnɔ ina ndɨ ɓɛ «Ɓokunzi ka ɓoɓigi». Bato yi nɨyɔ a ndɨ bato wa gʉɗʉ wa Alesandulia, ɓafʉma ndɨ ko uzu wa, kaɓʉndaga ɓɛ ngbinga wa ɓʉdɨ ɓapʉ akɨtagɨ mbɛyɨ. ");
INSERT INTO lik_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Nɨyɔ tosilo ka Silakuse, tagya ndɨ kʉ ɓɛyɔ masyɛ masaa. ");
INSERT INTO lik_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Katʉkya wa, taɓyɛ ka mutili mo liɓo lidingi aka kadwɛ ka gʉɗʉ yi nɨnɔ ina ɓɛ Legio. Ɓʉgala ɓi, muvivi nɨmɔ kɛgʉ ndɨ mapʉ kotukyoku miso ya Zebu apʉnga ndɨ kovivo. Kumbusa wa masyɛ maɓa, tadwɛ ndɨ ka gʉɗʉ yi nɨnɔ ina ɓɛ Puteoli. ");
INSERT INTO lik_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Kʉ ɓɛyɔ, tʉtakanya ndɨ ɓomomosu ɓakilisito, ɓatɨɓɨkya ndɨ ɓɛ tasyɨ mbɛyɨ na ɨɓʉ pɔsɔ yimoti. Lɨgʉndʉ kusu ka Lʉma a ndɨ ɓɛyɔ. ");
INSERT INTO lik_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Nɨyɔ ɓomomosu ɓa Lʉma ɓʉkana ndɨ mino mongoni kusu, ɓodoku ndɨ katɨtɨlya ka sɔkɔ wa Apiyo, na ka Tiletabeline. Nɨyɔ Pɔlɔ ʉmɨna ndɨ, abibiso Kunzi, ngu amigoku ɓata. ");
INSERT INTO lik_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Nɨyɔ tosila ndɨ ka Lʉma, ɓawanya Pɔlɔ ndaɓʉ di, ɓapá sʉda ɓemoti nɨnɔ a ndɨ kaɓuulyogo. ");
INSERT INTO lik_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Kumbusa wa masyɛ masaa, Pɔlɔ ʉmaka ndɨ ɓangama ka Ɓayuda nɨɓɔ ɓa ndɨ kʉ ka Lʉma. Nɨyɔ ɓamʉmʉkana, ʉɓɨkya ndɨ ɓɛ: «Ɓomika-mama, nakʉgyɨlyagʉ ndɨ ɓava-kukusu ɓʉnyɛ gʉtʉgʉ ɓumoti aka ikanɨ koɓuno yɨgya yaɓʉndɛlɨ ka ɓotitosu. Luki limoti, ɓegwi ndɨ ka Yelusalɛma, ɓɛsʉta ka maɓɔkʉ ka Ɓalʉma. ");
INSERT INTO lik_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Nɨyɔ ɓesombiso, ɓa ndɨ kapa kesiso. A ɓɛyɔ, ɓakɛmɨnagʉ ndɨ gʉtʉgʉ na lɨkpʉmʉka limoti aka nɨlɔ ɓakwanana ndɨ mino kɛmwɔ. ");
INSERT INTO lik_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Luki limoti, Ɓayuda ɓakɛgʉ ndɨ ɨɓʉ kabaɨlya. Kinili, nɨna ndɨ ambɛ okwononi ɓɛ ngama mudingi wa Lʉma aka nɔ akʉ ngbanga kamɨ. Kʉsɔ wa nɨyɔ yasɨ, nakɛgʉ ndɨ na tamanaga kaʉsʉngʉlya ɓava-kukusu. ");
INSERT INTO lik_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Kinili, namumoki ambɛ namʉɓɨkyɨ ɓɛyɔ. A ɓɛyɔ, namʉkandɨla na selegeni ɓɛnɛ ko bulya mʉtamanagɨ nɨnɔ Ɓezaleli ɓa nomu.» ");
INSERT INTO lik_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Ɓasikisya ndɨ ɓɛ: «Iɓusu, takamɨnagʉ balʉwa gʉtʉgʉ ɓemoti aka kotukyoku ka Yudɛa ko bulya kakʉ. Gʉtʉgʉ momosu Muyuda kodokugʉ katɨpága mongoni, ikanɨ katɨɓɨkya lɨkpʉmʉka lanyɛ ko bulya kakʉ. ");
INSERT INTO lik_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Luki limoti, to ɓi kapa kaʉkana tamanaga kakʉ. A ɓɛyɔ, takaiba ambɛ ɓapa ɓayasɨ, ɓambanzʉ ɓakɛgʉ kabaɨlya liɗu li nɨlɔ wo mino.» ");
INSERT INTO lik_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Kʉwa wa, ɓangama ka Ɓayuda ɓi nɨɓɔ ɓobisa ndɨ lɨsyɛ limoti kosilyono na Pɔlɔ. Ka lɨsyɛ li nɨlɔ, ɓodoku kʉwa ndɨ ɓakpʉ kʉgbɛ ka pa nɨyɔ Pɔlɔ asyɛgɛ ndɨ mino. Katʉkya na ɓʉsɔɓɨ kadwɛ na ɓʉgɔgɔ, Pɔlɔ a ndɨ kaʉtʉmbʉlyaga, anʉpá mʉtʉʉ ko bulya Ɓʉngama ko Kunzi. Anakɨsa ɓɛ ɓaɓɨnɨkyanɨ lɨkpʉmʉka ka Yeso, pisi ka mʉtʉʉ ka Musa, na ka ɓakɨtaɓʉ ka ɓogyalandʉ. ");
INSERT INTO lik_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Luga kaɓʉ, ɓemoti-ɓemoti ɓaɓɨnɨkyana ndɨ nɨlɔ a ndɨ kaɓɨkya, luki limoti ɓatʉ ɓagɔgɔ ɓakya ndɨ. ");
INSERT INTO lik_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Ngbingo yi nɨnɔ ɓa ndɨ mino komisikono, ɓakɛgʉ ndɨ kaʉkanana luga kaɓʉ. Pɔlɔ ʉmatɨlya ndɨ lɨkpʉmʉka limoti aka ɓɛ: «Lɨmbɛngɨ-Lotu aɓɨkya ndɨ lɨngʉnʉ ngbingo yi nɨnɔ a ndɨ mino kaʉnzɨnɨlya ɓotitonu, pisi ka mugyalandʉ Isaya ɓɛ: ");
INSERT INTO lik_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‹Waga, hʉɓɨkya ɓatʉ nɨɓana ɓɛ: Mikatʉ kaʉkana ɓɨnza, luki limoti makotombisyigʉ. Mikatʉ kaanda ɓɨnza, luki limoti makɨnɨgʉ. ");
INSERT INTO lik_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","A ɓɛyɔ, mambɛngɨ ka ɓatʉ nɨɓana a kʉwa muti. Ɓidulogoni ndɨ motili, ɓaɓʉwa miso, kyɛ misa kaɓʉ kinonitɔgʉ, motili kaɓʉ kukononitɔgʉ, mambɛngɨ kaɓʉ kotombisyonitɔgʉ ɓɛkyɛ ɓakemigilyonitɔgʉ, nuhukuso!›» ");
INSERT INTO lik_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Pɔlɔ opipiloku kʉwa ndɨ ɓɛ: «Wibonito sɛ ɓɛ Kunzi otikoniku Muhukuso ka ɓatʉ nɨɓɔ ɓakɛgʉ Ɓayuda. Ɓʉkanatʉ ndɛkɛ ɨɓʉ.»  ");
INSERT INTO lik_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Nɨyɔ Pɔlɔ aɓɨkya ɓɛyɔ, Ɓayuda ɓaga ndɨ nɨ ɓanagya ɓoɗongoso kʉgbɛ luga kaɓʉ. ");
INSERT INTO lik_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Pɔlɔ agya ndɨ ɓyanga ɓɨɓa ka ndaɓʉ nɨyɔ apága ndɨ mino ɓuyi yɔ. Ʉtɨlyaga ndɨ ɓatʉ ɓasɨ nɨɓɔ ɓodogoku ndɨ kanda. ");
INSERT INTO lik_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Aɓɨkyaga ndɨ mongoni ma Ɓʉngama ko Kunzi, anuwonisilo ɓambanzʉ lɨkpʉmʉka ka Mombukwono-dosu Yeso-Kilisito nɨ kɛgʉ na kʉɓangakʉ, nɨ ɓakɛgʉ gɔnɨ kapakya.");
INSERT INTO lik_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Ɨmɨ Pɔlɔ, mʉgya-ligubo ka Yeso-Kilisito nɔ nakpiki balʉwa yi nɨmʉ. Kunzi ɛmaka ndɨ kaika atʉtʉmbwa, ɛtɛ di kaɓɨkyaga Mongoni Manza kakɨ. ");
INSERT INTO lik_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Mongoni Manza mi nɨmɔ Kunzi awanyaga ndɨ ndɛlɨ aka, pisi ka ɓogyalandʉ kakɨ ka Moɓiso Motu. ");
INSERT INTO lik_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","4","Akanzɨna ko bulya ko Mikakɨ, Mombukwono-dosu Yeso-Kilisito nɨnɔ ɨɓʉkʉta ndɨ abɛ mʉmbanzʉ pisi ka lɨvananza ka ngama Daudi. Luki limoti, wa opupa ndɨ mino ka mbʉkʉ, Lɨmbɛngɨ-Lotu owonisila ndɨ no ngu ɓɛ a Miko Kunzi. ");
INSERT INTO lik_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Ko pisi ka Yeso, Kunzi ɛpá ɨzɨyɔ kaika atʉtʉmbwa ka ɨbɨba kakɨ, kauluto ɓambanzʉ ɓa ɓɛvananza ɓayasɨ kabaɨlya na kagya Mʉtʉʉ kakɨ. ");
INSERT INTO lik_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Ma gɔnɨ kʉsɔ ka ɓatʉ ɓi nɨɓɔ, iɓunu ɓi nɨɓɔ Kunzi amʉmakaga kaiko ɓatʉ ka Yeso-Kilisito. ");
INSERT INTO lik_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Nakamukpikilyo iɓunu nɨɓɔ ma kʉ ka Lʉma, iɓunu ɓasɨ nɨɓɔ Kunzi amʉpa, amʉmaka kaiko ɓatʉ kakɨ ɓotu. Obosu Kunzi na Mombukwono-dosu Yeso-Kilisito amuɗukilyi ɨzɨyɔ na mazɨyɔ. ");
INSERT INTO lik_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Kambwa wa yasɨ, namigisyaga Kunzi kamɨ ɨbɨba pisi ka Yeso-Kilisito ko bulya kunu ɓasɨ, kyɛ mongoni ma baya kunu akomisikono ka ɔɓɨlɨ wasɨ. ");
INSERT INTO lik_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Kunzi nɨnɔ nagugubyogo na lɨmbɛngɨ limoti kaɓɨkyaga Mongoni Manza ko mikakɨ, akaiba ɓɛ nakaɓɨkya lɨngʉnʉ. Akaiba ɓɛ nasyɛgɛ lɨmbɛngɨ kunu, ");
INSERT INTO lik_vpl VALUES (